﻿USE sofia;
DROP TABLE IF EXISTS sofia.dji_vpl;
CREATE TABLE dji_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES dji_vpl WRITE;
INSERT INTO dji_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Ngurrununggaḻ bilidjirri, bilapilakiṉing Goddji ngurr yirrpini ngamangamadjili gurrbi ngirki ga bukmak ṉami. ");
INSERT INTO dji_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Ngunukiṉing wirrpmban miri gumbaḻa gurrbi ngirki, ga gar malirdji ngagirrdjini gapi djalkng ga ngunungiri Godngiri waṯi galminyi gapimirrpm. ");
INSERT INTO dji_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Nyani God yan kungiliban, “Baḏayaladjirriban!” Girri baḏayala birraldjiniban, miri gar kambarrdjini. ");
INSERT INTO dji_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Maṉngibirri nyani nyangiṉi miri ngunung buṯalban. Ga maṉngibirri ga gar malir nyani biliny maltjiliban, nyani rarrmaḻi nyani rarrmaḻi. ");
INSERT INTO dji_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Nyani Goddji biliny bultjidjini Maṉngibirri ga Malir. Mir bindjiniban balnggidjini ga milwartjini, yuwirdjakiṉim wurpm yakirri. ");
INSERT INTO dji_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Manymak, nyani wanginiban, “Gapi irr rindigiban, mir rarrmaḻipm bil djirridji, wurpm irr biḻibiḻigilidjigi nguymirri ga wurpitji gilitjiligi ṉammirri, marrga baṉim irr djamadjigi miraḻ garrkuḻuk.” ");
INSERT INTO dji_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Mir nyani bindjin, girr gapi inydji rindingiliban. Ga Goddji biliny garrwurdjili gapi rarrmaḻi rarrmaḻipm, mir wurpmi rarrmaḻipm djarrinyi djiḻi gurrbi munganmirri, ga wurpi ṉammirri djarrinyi rarrmaḻipm, ga baṉimi miraḻ garrkuḻuk dja'djarrinyban. ");
INSERT INTO dji_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ga mir ngunu miraḻ nyani bultjidjini Giṉimbirri. Mir bindjiniban balnggidjini ga milwartjini, bingili yakirri inydji malimdjiliban. ");
INSERT INTO dji_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Manymak, nyani wanginiban, “Ngunu gapi nguymirri irr rirrbigi yilitjigi wurpmbirrimili marrga gurrbi baṉḏany irr nyangi.” Mir bindjin, girri gurrbi baṉḏany birraldjiniban. ");
INSERT INTO dji_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Gurrbi baṉdany nyani bultjidjini Munatja, gapi djalkng nyani bultjidjini Wulan. Nyani milingili nyangiṉi, girri marrkapdjiliban. ");
INSERT INTO dji_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Girr nyani yan kungili “Lidji djurriguw kiruwban mir miṉitjigiṉing mala, bubalikiṉing djalwaligiṉing mala galinmi miṉitji ṉambiḏi walimirri, djurriguwban.” Mir nyani bindjini, girri wali birraldjiniban. ");
INSERT INTO dji_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Munatjangir djin djurrginy kirinyban wurpi wurpi mala miri yurryarr, gurrtji, ga wali mala bubalikiṉing nyim nyim kunyirri miṉitjigiṉing mala ga bubalikiṉing djunggi djalwaligiṉing. Nyani nyangiṉiban mir bukmak buṯaldjiniban. ");
INSERT INTO dji_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Mir bindjiniban balnggidjini ga milwartjini, yakirr warrangguwili inydji malimdjiliban. ");
INSERT INTO dji_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Manymak, nyani God wanginiban, “Waḻirr, rangu, ga kaṯa irr ngamangamadjigi ṉam irr yirrpigi, marrga djani miḻmiḻdjigi nguḻi, ga djin yingarraydjigi wurpi wurpi bilidjirri, miri yakirri bilidjirri ga rarranydjarr bilidjirri, bilapilang. ");
INSERT INTO dji_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Ga gurrbili muṉatjali djin miḻmiḻdjigi. Nyani bindjini, girri guḏitjimarr mala djin birraldjiniban. ");
INSERT INTO dji_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","17","Ga ngunupili baḏayala mirrpili, miri ngunung bingili wana mirrpili, nyani biliny ngamangamadjili waḻirr ga rangu. Mir maṉngibirri bilidjirri ngunukuma waḻirr miri bunggawa nyani djirridji giri waḻirr gurrpigi, ga ngunukuma rangu bintji giri ngurrguma malir gurrpigi. Ga ngunukiṉing bilidjirri Goddji djamadjili gaṯa mala girri. ");
INSERT INTO dji_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","19","Mir bilapilang nyani biliny yirrpini ṉamili, marrga bil miḻmiḻdjigi bapiḻi, ga bilang baḏayala, ngunung bil rindigi gar malirngiri. Manymak, nyani Goddji nyangiṉiban mir bukmak buṯaldjiniban. Mir bindjiniban balnggidjini ga milwartjini, bingili ga bingili yakirri inydji malimdjiliban. ");
INSERT INTO dji_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Manymak, nyani wanginiban, “Galbi wanngi mala irr ngamangamadjigi, gapimirri djin nyinidji giri, ga waykiṉing mala irr ngamangamadjigi girri, djin ṉunydjirri giri ṉamṉammirrpm.” Mir nyani bindjini, girri gapibi mala ga waykiṉing mala djin birraldjiniban. ");
INSERT INTO dji_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Mir nyani ngamangamadjili maypal wana wulanbi, ga wurpi wurpi mala walim girim mala gapibi, ga wurpi wurpi mala waykiṉing girrgima. Nyani nyangiṉiban mir bukmak buṯaldjiniban. ");
INSERT INTO dji_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Girr nyani yabuḻu djina wangini, “Yuwirdjingpilinginyi lidji djamadjigi inydji lidji galbidji kiri, wulanmirrpm lidji garrwurdji kiri, ga ngilidji waykiṉing mala lidji galbidji kiri gurrbi munganmirri.” ");
INSERT INTO dji_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Mir bindjiniban balnggidjini ga milwartjini, gumbirri wurpingirpm yakirri inydji malimdjiliban. ");
INSERT INTO dji_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Manymak, nyani wanginiban, “Wurpi wanngi mala irr ngamangamadjigiban mir djin gukirridji giri gurrbi munganmirri, irr ngamangamadjigi wurpi wurpi mala maypal mala, mir buluki mala, walim girim mala, ga nyim ngunupilang mala.” Mir nyani bindjini, girri maypal mala djin birraldjiniban. ");
INSERT INTO dji_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Nyani ngamangamadjili wurpi wurpi maypal mala, ga bukmak wurpi wurpi mala walim girim mala. Mir nyani bindjini munatjabi mala ngamangamadjili. Ga nyani djiny nyangiṉiban, ga djina marrkapdjiliban. ");
INSERT INTO dji_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Girr nyani wangini, “Yulban ngilimi lim ngamangamadjigi mir ngilimibipm, ga nyani yul djina ngurrḏawalangudjidji guyipilingirgi waykiṉingirgi maypalpilingirgi ga bukmakigi walinyirakiṉingirgi.” ");
INSERT INTO dji_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Marrga yul nyani Goddji ngamangamadjili mir nyanibipm, mir nyani ngamangamadjili yulnginyi marri djayaḻ mir miligidjinginyi, gumbirr ngaṉgigiṉing ga gumbirr gaṉigiṉing biliny djamadjili. ");
INSERT INTO dji_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Nyani bumir yilimbirring bilingga wanginiban, “Mala nyim pung kiri nyim galbidji kiri ga barrkirrdjidji wurpili wurpili djawalili. Bukmak mala djiny nyim djanadjanadjigi, mir maypalpilingirgi munatjabi ga waykiṉingirgi ṉampi ga guyipilingirgi gapibi djina nyim ngurrḏawalangudjidji.” ");
INSERT INTO dji_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Girri nyani wangini yiligima, “Mir nyim nyawi, Ngarri nyirr kumban bubalikiṉing wali ngambuḻgiṉing ga bubalikiṉing djunggi djalwaligiṉing gatjinmi, nguṉitjini mala dja'djarri mala djalwaligiṉing nyim ḏirradjigi. ");
INSERT INTO dji_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ga maypalpilingirgi munatjabi waykiṉingirgi ga bukmak walinyirakiṉingirgi mala djiny irr gung yurryarr wali.” Mir bilapilang wurpi wurpi walipili nyani yirrpiniban djina, yulgi ga maypalgi. ");
INSERT INTO dji_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Nyani nyangiṉiban ngunung miri ngamangamadjili djina, girri marrkapdjiliban mirrpmban. Mir bindjini balnggidjini ga milwartjini, gumbirr wurpingirpm ga nyani wurpm yakirri inydji malimdjiliban. ");
INSERT INTO dji_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","2","Mir bilapilang nyani malimdjili bukmak mala. Ga wurpili yakirrdji mir ingki ngamangamadjnyir, ngunung gumbirr wurpingirpm ga biling bingili yakirri, ngunukiṉing bilidjirri nyani gaṉḏi inydji galdirrdjiniban djamangiri. ");
INSERT INTO dji_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Djini'djining malir nyani bultjidjini djuyu waḻirr, gima ngunukiṉingban guḻdjili nyanngang djamangiri. ");
INSERT INTO dji_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Bilapilang ṉampi ga gurrbibi djanguny mir nyalikidjny djamadjili. ");
INSERT INTO dji_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Ngunukiṉing bilidjirri nyadji Goddji djamadjili gurrbi ngirki ga ṉami, yarim wirrpm djunggi ga yurryarr djirrinyir, wirrpm djurriginyir kirinyir, gima wirr yanginyir mayurrk munatjali. Ga wirrpm yul nyininyir, marrga ingki wari ngunupilang gaminir miri wali yirrpinir gima ganbapm, ");
INSERT INTO dji_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","mir yirrim munatjangir ṉambiḏingir gapi buwalbuwaldjny kiriny gurrbi mungan gapiriny djarrinyi. ");
INSERT INTO dji_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Ngunukiṉing Goddji ngamangamadjili yul ngurruḏawalangu, mir munatja marrngili marrga munatjabi djamadjiliban yulnginyi, girri wupwupdjili ngurrimirrpm marrga nyani ngalwartjingini kirinyban. Mir bindjini ngunung yul ngalwartjinakiṉing. ");
INSERT INTO dji_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Girri Goddji wali ngamangamadjili, girri lamudjili bumir djimurrungir, ngunung gurrbi bultjidjini Idin (Eden), nguḻi nyani yirryirrpini yulnginyi. ");
INSERT INTO dji_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Ga djurriginy kiriny djunggi garray ga manymak ḏirradjnyirbi. Ga bingili gurrtji nyani djamadjili, yagirri bilingga miri Djunggi Wanngi Gunyirbi ngunung budjirrminy dja'djarri, ga wurpi djunggi dja'djarri yagirri ngunugirki Djunggi Marnggi Gunyirbi Ngungirapibi Buṯalbi ga Mirkngibi. ");
INSERT INTO dji_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Mir nguḻi gapi buwalbuwaldjny kirinyi baḻangawdjili girri wurpili wurpili mani bipiṉi biling bingili ga biling bingili mani. ");
INSERT INTO dji_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","12","Wurpm mani djin bultjidjini Pidjun (Pishon), ngunung mani wiḻtjnyi wiḻtjnyiring djawalmirrpm Abilamirrpm (Havilah) wirrwirrdjny kirinyi, mir nguḻi djin gamirrdjini djimuku munatjabi miri gold, ga nguḻi djin marriny giriny laytju mala miri rirrkiyan buṯal nyanyirbi ga gaḻanyan buṯal nyuminirbi. ");
INSERT INTO dji_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ga wurpi mani djin bultjidjini Giyun (Gihon), ga djining wirrwirrdjny kirinyi djawalmirrpm Kutjmirrpm (Cush). ");
INSERT INTO dji_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Wurpi mani djin bultjidjini Tigris, djining wirrwirrdjny kirinyi djimurruli Atjurli (Asshur) gurrbili. Ga wurpi mani djin bultjidjini Yupratis (Euphrates). ");
INSERT INTO dji_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Manymak, Goddji gangili yulnginyi, girri yirryirrpini gatnimirri Idin miri nyani yul lamudjigi wali ga djagadjigi gatni. ");
INSERT INTO dji_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ga nyani God inga wangini yulgi, “Mir nyuni ḏirradjigi wali bubalikiṉingibi gurrtjibi, ");
INSERT INTO dji_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","bil mir wurpm gurrtji dja'djarri djiḻigima, ingki nyuni ḏirradjigi ngungirapibi, mir ngunung Djunggi Marnggi Gunyirbi Ngungirpibi Buṯalbi ga Mirkngibi, mir ngunung nyuni gubidji. Ngunubilang nyuni ḏirradjigi ngungirapibi, mir warray nyuni balidji ngunyili yipi.” ");
INSERT INTO dji_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Manymak, girr God guṉgi inydji wangini, “Mir ingki djining buṯal mir yul ngiḏawa nyi'nyinidji giri. Ngarri ingarr djamadjigiban baḻpirgiṉing.” ");
INSERT INTO dji_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Marrga nyani Goddji djamadjili wanngi mala munatjadji, mir wurpi wurpi mala maypal mala ga waykiṉing mala, girr inga birrungili yulgi ga nyanitja yuldji yagirri djiny yirrpini kirinyi rarrimaḻi rarrimaḻipm. Mir nyani djiny yagirri yirrpini minydjin djirridjipm yagirri djini. ");
INSERT INTO dji_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Mir yuldji yagirri djiny gungili bukmaknginyi waykiṉinginyi ga maypalpilinginyi, bil ingki inga manyanyir baḻpirgiṉing inga. ");
INSERT INTO dji_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Marrga Goddji yakirri galwupiṉi yulnginyi, luṉbu ḏarrarrmiyngili ga biḻiwurrwarr gaypiliban wurpmi. Girr djidji inga miṉibili marrga galngi bulanggitjdjiliban. ");
INSERT INTO dji_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Biḻiwurrwarr baṯ, miyilkban nyani djamadjili Goddji ngungirapibi ngirkibi yilyilmiyngili yulngiri, girr inga birrungili yulgi. ");
INSERT INTO dji_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ga nyani yul wanginiban bindjiniban, “Djinimi mir ngirki ngirkibi ngirrapibi, ga munydjal munydjalpi ngirrapibi, marrga djinim ngarri bultjigi Miyilk gima nyuni gaypili galngibi yulangpibi.” ");
INSERT INTO dji_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Mir bilapilang rum djiningi minydji djirridjipmban limila, mir wari ngunupilang yul djiny gubidji nyanngang gunydjirri ga ngambirri, girri miyilk nyanngapibi galiki marrga giḏidjirrim bil nyinidji giri, mir wurpilipm galngi bil nyinidji giri nginipingim ga nyanimngim bil wurpilipmdjidjiban. ");
INSERT INTO dji_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Manymak, ngunu yul ga miyilk biling bil girinyi gar gurriyili, bil ingki inydji bil guṉidjnyir inydji bili. ");
INSERT INTO dji_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Manymak, Goddji djamadjili nyibi maypalpili ginginyakiṉing, bil nyani minarr mani wanginyakiṉing mirrpm. Nyani minarr inga wangini miyilkigi, “God nyimila yan gungili mir ingki nyim ḏirradjigi bubalikiṉingibi djunggibi wali.” ");
INSERT INTO dji_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","3","Girri miyilkdji yan bumir gaypili, “Ingki! Mir yirrim ngunung liny ḏirradjigi gurrtibi bubalikiṉingibi. Bil mir ngunung djunggi dja'djarri baṉimi mir ngunugiriny girri ingki liny ḏirradjigi ngungirapibi gima nyani God linyila wangini ‘Ingki nyim ḏirradjigi ngungirapibi ga ingki nyim gatjigi ngunugirinyi bintji nyim balidji.’” ");
INSERT INTO dji_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Bil ngunung minarr inga wanginiban, “Ingki nyum balidji. ");
INSERT INTO dji_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Mir birral God marnggi mir nyadji ngunupilang nyim ḏirradjigi, ganydjirrdjipm marrga mil inydjim ḻapmiygi marrga mirkng malagi ga manymak malagi nyim marnggi, marrga nyumibi ga nyanibi inydji lidji djirridjiban.” ");
INSERT INTO dji_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Manymak. Nguṉi miyilkdji nyangiṉi wali buṯal ḏirradjnyirbi djunggimirri wirardjinginmi, ga ngunu waligi nguy djalngdjiniban ga nyani gingini mir nguṉi walidji gaḏamandjigi, marrga nyani butnyirdjili ngunuguma djalwali girri ḏirradjiliban, yili rindingili ga inga birrungili nginipingirgimi ga nyanitja ḏirradjili girrgima. ");
INSERT INTO dji_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Rirringir ngunungir girri mil inydji bil ḻapmiyngili marrga marnggikiṉingban bili. Girri galngi inydji bil nyangiṉiban mir inydji bil birraldjnyirdjili gar gurriyili bil girinyi, marrga bumalng mapalpili bil rarri baringili muṉḏaṉdji marrga gar inydji bil ngagirrdjiniban. ");
INSERT INTO dji_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Djaming yabuḻudjini bil marrngini God yirryarrdjny kiriny biliny baḻpariny kirinyi, marrga murrurrtmirri inganydji bil gilgirrdjiniban. ");
INSERT INTO dji_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Nyani God inga witjiliban yulgi, “Nyali nyini?” ");
INSERT INTO dji_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ga nyani yan bumir gaypili, “Mir ngarri nyirr marrngini murrurrtmirrpm bi giriny nyininyi marrga inmarr yawngini gima gar gurriyili irr nyininyi marrga inmanydjirr gilgirrdjini.” ");
INSERT INTO dji_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ga nyanitja butjalmini, “Wari ngunung inma wangini miri gar gurriyili nyuni nyi'nyininyi? Bina ngurr ḏirradjili ngununggirapibi gurrtji budjirrminy gatni dja'djarri mir ngunung nyirr ṉunggaṯmiyngili?” ");
INSERT INTO dji_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","“Djiṉi miyilkdji nyuni irra djamadjili nyanibi irriny gungili djalwali ngungirapibi gurrtjibi girri ngarri ḏirradjiliban.” ");
INSERT INTO dji_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Girri God inga wangini miyilkigi, “Nyimki mirikuṉu nyuni djamadjili mir bindjini?” Ga nyanitja wangini, “Djinim minarrtji irra mani wangini marrga irr ḏirradjiliban.” ");
INSERT INTO dji_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Girri God inga wangini minarrki, “Gima nyuni mirrpm murgungili ngarri nyirr bulu ngurri bukmakngiri maypalpilingir. Budjirrdjipmban nyuni waliki giri, ga midjirri ḏirradji giri bintji giri ngurrguma. ");
INSERT INTO dji_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Nyuni ga ngunu miyilk inydjim djabir margiṉidjidji, nyungung mala ga nyanngang mala inydjin djabir margiṉidjidji gurrkunyi. Djani guṉgi nyin djin baḻpigi bil miri nyuni djiny ḏirradjigi ṉu bunyan.” ");
INSERT INTO dji_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Girri miyilkigi inga wangini, “Nyadji ngunupilang nyuni gapaḻmirrpilidjidji ngunukiṉingban nyuni galngi djalgidjidji mirrpmban. Miri djalgidjidji kiri nyuni yidjipili mini, bil yirrim inga djalngdjidjipm nginipingirgim inma, ga nyanitji ngurrḏawalangudjidji inma.” ");
INSERT INTO dji_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Girri inga wangini yulgi, “Gima nyuni butjir inganydji gungili nyanimiki ga ḏirradjili djalwali ngungirapibi djunggibi nyirr ṉunggaṯmiyngili, munatja inma mirgidjidjiban gima mir nyungupibi. Nguy wargugugiṉing nyuni ḏirradjigi wali munatjabi bintji giri ngurrguma. ");
INSERT INTO dji_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ingki galbi wali inma djurri giri, bil yarim galbi djiṉdjiṉkili inma djurri giriban. ");
INSERT INTO dji_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Nyuni maṉbing djamadjigi ngurrbirridji marrgi wali inma marrgi, yarimipm nyuni wiṉidji munatjali, gima munatjangir ngarri nyirr djamirrdjini. Miri nyuni yarim midjirrdjini, marrga ngunyilipm ngarri nyirr wiṉidjingilgi midjirrili.” ");
INSERT INTO dji_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Manymak, ngunung yul yagirri inga Adam, ga yuldji bultjidjini nyanngang miyilk Yip (Eve) gima nyani ngurruḏawalangu ngambirri djina nyininyi bukmakigi yulpiligi. ");
INSERT INTO dji_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Ga nyani Gunydjirrar bipiṉi maypal girri maypaldji gilingkaḻdji biliny ngagirrdjiniban. ");
INSERT INTO dji_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Manymak, Gunydjirri wanginiban, “Ngunung yul miri marnggiban buṯalbi ga mirkngibi, mir marnggiban mir ngilim. Ngunubilang nyani rindinyir djalwali ngungirapibi djunggibi ngunung Wanngi Gunyirbi, ḏirradjnyiri, girri nyani wanngigakiṉing nyininyir girinyiri.” ");
INSERT INTO dji_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Marrga Gunydjirrar biliny bulu nguli gatningiri Idinngiri, miri nyani minydji yaniliban djawalili wurpili miri nguḻi bil ḻamudjigi wali wurpirri gurrbuwi. ");
INSERT INTO dji_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Rirringir ngunungir girri wugiḻinginyi nyani yirryirrpini Gunydjirrar, wugiḻi badji nyanyirakiṉing, ga nyani maltjirri djarrinyi gadjigirring, ga ngurri djarrkuṯ giḻiwiḻingi mandjawak gatjini, ga ngunung mandjawak burrtjirriny djarrinyi, marrga wirapili djani bilayili minydjin yilitjirridji djunggingir ngidjirrkngiri. ");
INSERT INTO dji_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Manymak, giḻiwiḻim bil ngurrinyi girri nyani Yip gapaḻmirrpilidjini. Djamingi yidjipili bungtjili, girri nguṉi miyilkdji yagirr yirrpini Kayn (Cain) gima nyanibi inydji wangini, “Goddji irriny gunggatjili miri yul irr marrngili yuwirdjing.” ");
INSERT INTO dji_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Ga djamingi yili bungtjili djirrakay, yagirri bil yirrpini Abil (Abel). Kayn ga Abil biling galngi bil wanadjini. Nyani Abil djagadjny girinyi maypal bimbi mala, ban Kayn nyani lamudjny girinyi wali. ");
INSERT INTO dji_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Guyumban mundjarr inga bil birrungili Godki Gunydjirrgirki. Miri Kayn inga birrungili nyanngapibi djamadjnyirbi wali, ");
INSERT INTO dji_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","ban Abil guḻtjigiṉing munydjal bimbi inga birrungili, galbi yuwiridjingpili. Marrga nyani God marr inga bulanggitjdjini Abilgi ga nyanngang mundjarrgi, ");
INSERT INTO dji_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","bil Kaynnyi biri yirrpini ga nyanngang mundjarr biri yirrpini girrgima. Girri Kayn nguy murmurdjiliban ga bumir nyirrnyirrdjiliban. ");
INSERT INTO dji_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Marrga God inga wangini Kayngi, “Nyimki nyuni nguy margiṉdjini, nyimki bumir nyirrnyirrdjili? ");
INSERT INTO dji_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Miri warray ngunubilang gadjigarr buṯal nyuni bargi, girri nyuni marrkapdjidjiban. Bil ngunubilang nyuni mirgi djamadjigi, nyungung mirgipili galngimirri inma ngu'ngurri nyin wanngi ḏutjigi miri mirrir. Bil ginginyirbi mirgipili nyuni bilang biri yirrpigi, marrga ngunugirri gadjigarr mirkngi miri ngunung nyuni gubidjiban.” ");
INSERT INTO dji_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Manymak ngunungir girri Kayn inga wangini gulmingirgipm Abilgi, “Il giruwban ngunyili murrurrtili.” “Ngiy manymak.” Biling bil giriny nyininyi murrurrtmirrpm, girri Kayn minydji bipiṉiban gulmigipm. ");
INSERT INTO dji_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Ga guyumban God inga wangini Kayngi, “Nyaling inma gulmigipm Abil?” Nyani yan bumir gaypili, “Ingki irr marnggi! Ingki ingarr djagagiṉing bina?” ");
INSERT INTO dji_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Girri nyani inga wangini, “Mirikuṉu nyuni mirrpm djamadjiliban! Nyuni butjir inydji guw! Nyungung gulmigirang buḏi nyani irra witjim kirimban munatjangir. ");
INSERT INTO dji_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Miri gumbirrdji nyunguri nyuni bipiṉi, marrga nyanngang buḏi rarrmiyngili munatjali, marrga ngarri nyirr bulu ngurriban munatjangir. ");
INSERT INTO dji_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Miri nyadji ngunupilang wali nyuni lamudjigi, yarim wirrpm inma djurri giri wali. Yarim miri nyuni mulkuru gu'gukirridji walikiban, gurrbi wirrpm inma djirridjiban.” ");
INSERT INTO dji_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Girri Kayn inga wangini, “Djining bulu ngurriginyirbi irr mini giri djiningi miri biri maṉbi irra guṉgan mirrpmi. ");
INSERT INTO dji_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Miri djini'djining nyuni irriny bulu nguli munatjangir, ga ngarri bilang inmanydjirr gilkilgirrgiban, miri nguy wargugugiṉing mulkuru minydji irr gukirridji walikiban, marrga wiḻi ngunupilangir irriny manyang irriny bungi!” ");
INSERT INTO dji_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","“Ingki birral,” Gunydjirri inga wangini, “bilang wiḻi ngunupilangir nyin bunyiri, ngunuguma ngarritja warray yarṯi ḏapiḻidjnyir mirrpmguma.” Rirringir ngunungir girri nyani mak inga yirrpini Kayngi galngimirri, marrga wiḻi ngunupilangir mildji bunyiri, mir ngunung mak djin nyanyiri, girri ingki djin bunyiri nyaninyi. ");
INSERT INTO dji_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Manymak, rirringir ngunungir girri nyani Kayn gubini, ga bilayili giraliban. Nguḻi gawarrkamirri gukirriny girinyban wurpirri gurrbuw Nud bumir djimurrumirri. ");
INSERT INTO dji_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Manymak, biling giḻiwiḻim bil ngurrinyi Kayn ga nyanimngim inga, girri ngunugirri miyilk gapaḻmirrpilidjini, yidjipili miniginy kirinyi yagirri Inuk (Enoch). Ga nyani Kayn manyangiṉi gurrbi, girri galbi bala' mutjpiningili nguḻi, ga gurrbi wana yagirri yirrpini djining ngurrguma mir nyanngang walkiripm yagirri Inuk. ");
INSERT INTO dji_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Manymak, Inukang walkiripm Irad, djabiringir ngunungir girri Iradang walkiripm Mayudjayil, djabiringir ngunungir girri Mayudjayil walkiripm Mitjutjayil, ga djabiringir ngunungir girri Mitjutjayilang walkiripm Lamitj. ");
INSERT INTO dji_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamitj biliny marrngili nyanimwilingim bingili biliny galini, wurpm yagirri Ada ga wurpi yagirri Djila. ");
INSERT INTO dji_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Manymak, bingili yutjuwili bil bungtjili Adangpibi. Mir miḻimiti bungtjili yagirri Djabal, ga nyani ngurrḏawalangu djina yulpilingirgi miri wiṉinimirri djin ngurrinyi mala ga djagadjny girinyi mala buluki. ");
INSERT INTO dji_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Ga nyanngang gulmingim yagirri Djubal, nyani ngurrḏawalangu djina wuyimbaḻ gatjinakiṉing djina malagi, mir nyim ngunupilang djani djin gatjini mir wuyimbaḻ, biḻma, manikay, bilapilang. ");
INSERT INTO dji_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Ban ngunugirri miyilk Djila, nyanngangpibi miḻimiti yagirri Djubal-Kayn. Ga djiṉi yuldji girri djamadjny girinyi miri djimuku mala maṉbing wurpi wurpi. Ga nyanngang gaḏingimi yagirri Nama. ");
INSERT INTO dji_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Manymak, nyani Lamitj bilingga wangini nyanimwilingirgim, “Ada ga Djila irriny nyim marrngirriy yan, butjir irranydjim guw miri irr djabarrkdjigiban. ‘Miri nyani irriny gaṯpurrdjili marrga ngarritja irr buḻkitj marrngili nyaniny irr bipiṉi, miri yawirrinynginyi irr bipiṉi gima nyani ngurrum irriny gaṯpurrdjili. ");
INSERT INTO dji_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Mir ngunubilang wirinyi Goddji yarṯi ḏapiḻidjigi Kayngi warray, miri mirrpm yili ngarribi irr bintji ngurrguma irr yarṯi ḏapiḻidjigi.’” ");
INSERT INTO dji_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Manymak, bilingi Adam ga Yip yili bil ngurrinyi, ga yili nyani gapaḻmirrpilidjini, ga guyumban yidjipili bungtjili. Ga yagirri yirrpini Sit, djining yagirri mayaligiṉing miri ‘Gumi’ gima nyani Goddji gungili yuwiridjing yidjipili miri ngunung ngurrguma Kayndji bipiṉi. ");
INSERT INTO dji_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Manymak, Sitang walkiripm bungtjili, ga yagirri yirrpini Inutj. Ga miri Inutj bilidjirri yulpilingir djin ngurr yirrpini miri Godnyi djin butjalmini girinyi yagirrmirrpm Yawaymirrpm. ");
INSERT INTO dji_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Djining djanguny Adamang gurruṯigiṉing muṉḏaṉdji. Manymak, baman pirr nyadji Gunydjirrar ngamangamadjili yulnginyi, mir nyanipibm ngamangamadjili miri God. ");
INSERT INTO dji_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Bingili nyani djamadjili gumbirr ngaṉgigiṉing ga gumbirr gaṉigiṉing. Nyani djamadjili, girr yabuḻu bilingga wanginiban, ga yagirri wana biliny bultjidjini miri Yul. ");
INSERT INTO dji_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Manymak. Nyani Adam ngurrum gatjini galbi guṉmal ga rarranydjarr (130 years) nyadji ngunupilang bungtjili walkiripm inga mir nyanibipm, ga yagirri yirrpini Sit, girri nyibi mala gatjini walgurwalgur mala inga galbi, ");
INSERT INTO dji_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","5","ga rirringir ngunungir girri Adam nga'ngalwartjingini kiriny guṉmal ga rarranydjarr galbi galbi (800 years) bilidjirri, girri nyani wirrdjiniban. ");
INSERT INTO dji_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","20","Manymak, nyani Sit walkiri marrngili Inutj, ga Inutj walkiri marrngili Kinan, ga Kinan walkiri marrngili Mayalalil, ga Mayalalil walkiri marrngili Djarid, ga Djarid walkiri marrngili Inuk. Djiniwili yulpili djin nyininyi djin bininy ngurrguma wanngigakiṉing miri Adam, ga djin walkiri djamini galbi djina walguwalgur nyibi mala. ");
INSERT INTO dji_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","23","Ga Inuk guṉmal ga rarranydjarr gatjini galbi, girri walkiri marrngiliban Matjutjila (Methuselah). Ga nyani Inuk walkiri djamirrdjini walguwalgur, ga bininy ngurrguma nyininy wanngigakiṉing miri Adam. ");
INSERT INTO dji_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Ga nyani Inuk inga maltjili Gunydjirrgirki, ga bil giriny nyininy giḻiwiḻim, girri Inuk manydjirri gima Gunydjirrar minydji djamirrdjini. ");
INSERT INTO dji_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","28","Manymak, Matjutjila walkiri marrngili Lamitj (Lamech), ga Lamitj walkiri marrngili, ");
INSERT INTO dji_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","ga yagirri nyani yirrpini Nuwa. Miri djining yagirri mayaligiṉing miri ‘Ḻaydjigi’ gima nyani bindjin nyanngangi “Mir Gunydjirrar litja mirgidjnyirdjili munatja, ban djiṉi yidjipilir litjny gunggatjigi il ngalwartjingilgi djamangir maṉbingir.” ");
INSERT INTO dji_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Rirringir ngunungir girri Nuwa bungtjili, nyani Lamitj ngalwartjingini kiriny galbi guṉmal ga rarranydjarr, girri wirrdjiniban. Ga nyani bininy ngurrguma galbi yutjuwili djiny gatjini. ");
INSERT INTO dji_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Ga Lamitjang walkiripm Nuwa nyani gatjini galbi galbi guṉmal ga rarranydjarr (500 years), girri djiny walkiri djamirrdjini warrangguwilingim, Djim, Yam, ga Djapit, Nuwang walkiriwilingimi. ");
INSERT INTO dji_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Manymak. Ngunukiṉingi Nuwang bilidjirri, yulpilingir djani mala djin buny kirinyi galbiwili, marrga yul mala djin nyininy kirinyi galbi, wurpirri wurpirri gurrbuwi. Ga miyilkpili djani djal maḻimaḻingpili mirrpmi. ");
INSERT INTO dji_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Manymak. Godang djamagiṉpilingir wugiḻipilingir, djiny djin nyangiṉi ngunugirri miyilkpili djal maḻimaḻingpili, ga djina djin djalngdjiniban. Marrga miri ngunungi djina djin djalngny kiriny, djiny djin marriny kirinyban. ");
INSERT INTO dji_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Girri God Yaway inydji wanginban, “Ngirrar marrdji ingki djiny irr watjarrdji giri marngiri bintji giri ngurrguma yulpilinginyi. Miri ingki djiny irr ṉamkaṯdjingil giri yulpilinginyi, gima miri djani yarim djin galngipili. Ngarri djiny irr gung marri warrangguwili guṉmal ga rarranydjarr (120 years) marrga inydjin birrindjingilgi miri gadjigarr djunupa djin gurrpigi.” ");
INSERT INTO dji_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Manymak, ngunukiṉing Nipilim bapurrurr mala djin birraldjini djiḻi gurrbi munganmirri, miri mirrpm giḻiwiḻipili yulpili. Miri rirringir ngunungir girri Godang djamagiṉingir wugiḻipilingir djiny djin djamirrdjini miyilkpili, marrga ngunungiri yidjipilpili djina djin bungtjny kiriny, ngunukiṉingban djani birraldjiniban ngunukuma Nipilim bapurrurr. Ga rirringir ngunungir girri djin walkiri djamini kiriny yarim yalkuy, ga miri nguṉitjini mala djani yagirr wanapili mala buḻaḻkitjpi mala, bilapilang. ");
INSERT INTO dji_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Manymak, nyani Gunydjirrar djiny nyangiṉi yulpilinginyi miri djin ginginy girinyi mirkngpili, miri bininy kiriny ngurrguma miri gadjigarr mirkuṉu djin gurrpini girinyi. ");
INSERT INTO dji_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Girri nyani djina nguy giṉirgiṉdjini gima djani djin gurrpini gadjigarr mirkngi, marrga mirrpm nyani nguy wargugudjiniban. ");
INSERT INTO dji_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Ga Yaway inydji wangini, “Gurrbi mungan irr garrkuḻukdjigi miri yulpili bukmaknginyi irr djingirgiban, mir yul, maypal, walinyakiṉing, ga waykiṉing, djiny irr djingirgi mala bukmak, gima djinarr nguy mirgidjini miri ngurrwakng djiny irr djamadjili.” ");
INSERT INTO dji_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ban nganngangi ngunung yul Nuwa, nyani God Yaway inga marr bulanggitjdjini. ");
INSERT INTO dji_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Djiningi Nuwang walkirwilingim yagirrpili djini, Djim, Yam, ga Djapit. Ngunukuma yul Nuwa nyani djuburr djunupa nyininy girinyi ngunukiṉing nyanngang bilidjirri. Nyani yarṯi nyany girinyi Godnyi, miri djuburr garray girinyi. ");
INSERT INTO dji_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ban nyibiwili yulpili djani nguy midjirrgiṉpili milmirri Godar. Miri djiḻi gurrbi munatjamirri bukmak djin nyininy girinyi rumnyirringi buṯilnyirringi. ");
INSERT INTO dji_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ga nyani Gunydjirrar djiny nyangiṉiban miri nyaliki djin murkuny giriny gadjigarr djina, gima bukmak yul mala gadjigarr ngurrum djina wiḻdjili. ");
INSERT INTO dji_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Manymak, nyani God inga wangini Nuwagi, “Djinimirri irr gingini, bukmak mirgipili djiny irr djingirgiban, gima djanngapibingir djin mirgidjiniban bukmak mala. Marrga ngidjirrkngban djiny irr buwayaknyirdjigiban bubalikiṉinginyi, miri yulpili ga gurrbi mungan. ");
INSERT INTO dji_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Nyuni ngurr yirrpigiban djamadjigiban mitjiyang wana bukuḻumbak, ga manymakdjigi djunggili manymakdji. Ga ṉambiḏi nyuni mutjpinigi guḻmung rarrmaḻi rarrmaḻipm, girri galanyindji nyuni ngamirrgi ṉambiḏi ga gar gurryili. ");
INSERT INTO dji_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Miri djinimirri nyuni mutjpinigi ngunung mitjiyang. Giḻiwiḻing nyuni djamadjigi miri 150 inydji bala ngurri, ga budjirri mal giri 25 inydji bala ngurri, ga ṉamili djining djaka miri gurrtji wurpmi giḻiwiḻing. ");
INSERT INTO dji_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ga milak yirrpi kiri raymirrpmi ngidjirrkng ṉami, ga djabigi yirrpigi baṉim ḻurrkinmirri, ga warrngguwili biḻibiḻigili djarrpiṉdjingilgi ṉambiḏi. Miri bilapilang nyuni djamadjigi ngunung. ");
INSERT INTO dji_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Ban ngirrangi, ngidjirrkngban gapi wana ngarri yani bapiḻi gurrbili munatjali, marrga irr buwayaknyirdjigi bubalikiṉinginyi ngalwartjinakiṉing mala, bukmakban irr djingirgi djiḻi gurrbi munganmirri. ");
INSERT INTO dji_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Bil ngilidjarki ngarri lidjarr yirrpigiban murr randinirbi, marrga lidjny irr wanngidjnyirdjigi, mir warray lidji ragi mitjiyangili, nyunibi, ga nyungung nyanimngim, ga walkirwilingim inma djin ragi, ga walkirgiranguw nyanimwilingim djina djin ragi girri. ");
INSERT INTO dji_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ga guyumban wurpi wurpi mala maypal djiny gangban nyunguli ngunyili mitjiyangili, biling bingili biling bingili biliny gang maypal yul ga miyilk giḻiwiḻim. ");
INSERT INTO dji_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Miri wurpi wurpi mala bubalikiṉing nyuni kurtjigi, waykiṉing, ṉukiṉing, ga walinyakiṉing, bingili nyunguli bil ragi marrga wanngi bil nyinidji nguḻi. ");
INSERT INTO dji_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ga wali djina lidji kurtjigi rarrmaḻi rarrmaḻipm ga ngilidjang girrgima,” bindjin God inga wangini Nuwagi. ");
INSERT INTO dji_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Girri Nuwa butjirgiṉdjiniban, nyani djamadjiliban yarim miri Goddji inga yan kungili. ");
INSERT INTO dji_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","3","Manymak, girri Nuwadji djingiringiliban mitjyang miri galbi guṉmal ga rarranydjarr djadjuḏitj (100 years). Ngunukiṉingban Gunydjirr inga wangini, “Rawban ngunyili mitjiyangili, nyunibi ga nyungung gurrṯigiṉing mala, gima nyunibipm nyininy girinyi djuburr djunupa. Maypal mala nyuni djiny yagirrgiban, yarang mala ga ṉunggaṯmiynyirbi mala maypal djiny yagirrgi, wurpm wurpm nyuni biliny gangi ṉunggaṯmiynyirbi bili, ban bingilipili, miri gumbirr wurpingirpm ga biling bingili nyuni djiny birrugi yarangpili maypilpili, ga yili nyuni bintji ngurrguma waykiṉingirgi miri galbi nyuni birrugi. ");
INSERT INTO dji_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Gumbirr wurpingirpm ga biling bingili yakirri bilidjirri ngarri minydji irr yaniban gapi wana, ga nyani rikidji kiri miri 40dji maḻiri ga maṉngibirri bintji ngurrguma, marrga djiningiri munatjangiri bubalikiṉinginyi djiny irr buwayaknyirdjigiban, miri warrpam irr ngamangamadjili ngurrwagi. ");
INSERT INTO dji_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Girri Nuwa butjirgiṉdjiniban miri God Yaway inga wangini. ");
INSERT INTO dji_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nuwa ngurrum gatjidjini gumbirr wurpingirpm ga yili wurpm guṉmal ga rarranydjarr muṉḏaṉ (600 years) ngunukiṉing bilidjirri ngunung wunggutj yulgungili. ");
INSERT INTO dji_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","18","Manymak, girri Nuwa ga nyanngang gurrṯigiṉing mala djin ragiliban mitjiyangili ṉambiḏili. Girri yilimirri ngunugirri maypal djin rany kiriny mitjiyangili Nuwali. Djin rany kirinyi, girri gumbirr wurpingirpm ga biling bingili yakirri djin guḻdjini ranyirngir, girri Goddji rarri djina miṉibili ga maṉbidjnyirdjiliban. Rirrngir ngunungir girri mayurrk wana rikini, ga yuwirdjing djatjapili muy inydji bipiṉi galbi galbi, marrga gapi gaḻgaḻmiyny kiriny ga buwalbuwaldjny kirinyi. Miri 40dji yakirrdji rikiny kiriny, gapi buwalbuwaldjny kiriny marrga ngunung mitjiyang gilitjiliny kirinyban. ");
INSERT INTO dji_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","20","Ga nyuṉaṉ buwalbuwaldjny kiriny marrga ngagirrdjini bukaḻ bubalikiṉingi ga yili ngunyilatjuy buwalbuwaldjny kirinyi. ");
INSERT INTO dji_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","23","Ga bubalikiṉing wanngi mala djin baliniban, miri bukmak waykiṉing, ṉukiṉing, walinyakiṉing, ga yulpili, miri bubalikiṉing djin gukirriny girinyi mala djin buwayakdjiniban. ");
INSERT INTO dji_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Yarim nyanibi Nuwa wanngi nyininyban, ga nyanngang gurrṯigiṉpili mala nguḻi mitjiyangmirri. ");
INSERT INTO dji_vpl VALUES ("GN7_25","002_7_25","GEN","7","25","25","Ga ngunung nyuṉaṉ miri gumbirr wurpingirpm rangu dja'djarrinyi. ");
INSERT INTO dji_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Manymak, ingkiban Goddji marrbinir Nuwany ga maypilpili nguḻi ṉambiḏi mitjiyangmirri. Waṯi maṉbingi galmini djina yanali Goddji, marrga gapi baḻtjny kirinyban. ");
INSERT INTO dji_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ga ngunugirri djatjapili muy inydji miṉibili, ga guḻdjili mayurrk rikinyirngir. ");
INSERT INTO dji_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","4","Marri djayaḻ gapi ba'paḻtjny kiriny, marrga wurpm rangu djadjuḏitj ngunukiṉing miytjiyang inydji mungan yirrpini bukiḻmirri yagirri Ararat gurrbuwi. ");
INSERT INTO dji_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Miri bininy kiriny ngurrguma gapi baḻtjny kiriny yili warrngguwili rangu girri bukaḻ guṉgi yulgungiliban. ");
INSERT INTO dji_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","7","Manymak, Nuwa yili marrkangili rangu wurpm, girri rarri ḻapmiyngili ga wakwak yanaliban. Ga ngunung wakwak wirrkwirrkny walinyi bil wirrpm manyanyir gurrbi baṉḏany. ");
INSERT INTO dji_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Girri wurpi nyani marrngili mukumbuḻ yanali, ga ngunung mukumbuḻ wirrkwirrkny walinyi marrga nyangiṉi bilang gapi wirrpildjnyiri. ");
INSERT INTO dji_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Bil ngunung mukumbuḻ ingki manyanyir burrdjing munatja, marrga wiṉiniban ngunyili mitjiyangili. Nuwa djarrtjirr ngurrinyini, gatjidjini marrngili girri gangili ṉambiḏili. ");
INSERT INTO dji_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Ga gumbirr wurpingirpm ga biling bingili yili yakirri marrkangili, girri bindjini ngurrguma yanali mukumbuḻ ngunungir mitjiyangir. ");
INSERT INTO dji_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ga mukumbuḻ wiṉiniban mitjiyangili waḻirr bunyin inydji yirrpini kiriny, rarrdji ḏirradjili bumalng mapal yuwirdjing. Marrga Nuwa marnggiban miri gapi wirrpildjny kirinyban. ");
INSERT INTO dji_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ga gumbirr wurpingirpm ga biling bingili yakirri yili marrkangili, girri yili yanali mukumbuḻ ga ingkiban yili ngunung bi wiṉinyir inga Nuwagi. ");
INSERT INTO dji_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Ngunukiṉing gapi wirrpildjny kiriny munatjangir nyadji Nuwa ngurrum gatjidjini 601 guṉmal ga rarranydjarr. Girri Nuwa gilingkaḻ yilbirtjili ṉamngiri, ga milingiliban bilang gar gurriyilili djin giri, bil nyani nyangiṉi miri munatja biḻbaḻngipm. ");
INSERT INTO dji_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ga djani marrkangiliban bingili yili rangu djin nyininy kiriny mitjiyangmirri, girri munatja burrdjidjiniban. ");
INSERT INTO dji_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Manymak, munatja maṉbidjini, God inga wangini Nuwagi, ");
INSERT INTO dji_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Gar gurriyili minydji yulguwban, nyuni ga nyungung gurrṯi mala. ");
INSERT INTO dji_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ga djiny birrugiban ngunuwili maypilpili gar gurriyilili, marrga djani inydjin barrkirrdjidjiban, mala djin bungi marrga djin galbidjidji djiḻi gurrbi munganmirri.” ");
INSERT INTO dji_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Girri djani djin yulgungiliban, Nuwa, ga nyanngang gurrṯigiṉpili, ");
INSERT INTO dji_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","ga ngunukuma maypilpili, maladji ga maladji djin yulkuny kiriny bubalikiṉing maypal ṉukiṉingi ga waykiṉingi minydjin gi'kirinyban. ");
INSERT INTO dji_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Manymak, rirringir ngunungir girri Nuwadji guṉkurtjnyirdjili rirrkiyan wana, girri yip yirrpiniban Gunydjirrgirki. Girri ngunuwilangirangpibi yarangbi maypilbi ga waykiṉingibi nyibiwili nyani rindilali, djiny bipiṉi, rirrkiyinmirri djiny gilibili, girri djiny burrtjidjiniban marrga bumir girrbigi Gunydjirrgirinyi. ");
INSERT INTO dji_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Ga ngunungiri ngirimbiy burburdjny kirinyi, marrga Gunydjirrar nyumirrdjiniban ngunungi bunggan yabuḻudjnyirbi, ga nyani marr ḏapiḻidjiliban, marrga nyanibi inydji wanginiban, “Ingki yili ngunupilang mirgi irr djamadjigi djinarri djanngar mirgidji yulpilngirang. Miri birral bubalikiṉing yul ging girimipm mirkng mala, ngunukiṉingir yidjipili bilidjirringir ginginyirbi inga yarim mirgidjny girinyi munguyipm, bil ingki yili djiny irr buwayaknyirdjigi yul ga wurpi mala wanngi mala, miri djinimirri ngurrum djiny irr bindjini. ");
INSERT INTO dji_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Miri bilang djining gurrbi ngirki dji'djarri nyini, lamudjnyirbi bilidjirri ga buṯnyirdjnyirbi bilidjirri, murmurtjnyiring bilidjirri ga miṉ bilidjirri, guṉmal ga rarranydjarr, djarribir ga malir, ingki djin guḻdjigiban warray.” ");
INSERT INTO dji_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Manymak, Goddji yabuḻu djina wangini Nuwagi ga walkirwilingirgim, ga djina bindjini, “Mala galbi lidji bungi, mala inydji lidji galbidji kiri, marrga lidji barrkirrdjidji wurpili wurpili gurrbili. ");
INSERT INTO dji_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Bubalikiṉing maypal ga waykiṉing djani lijda djin yawngidji giri, ga guyi girrgima, ga gumbirrli lidja djiny irr galbuli. ");
INSERT INTO dji_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Bubalikiṉing maypal wanngi lidji ḏirradjigi, ngarri lidjny irr gungban bukmak miri ngunung mala lidjny irr gungili ngurrwagi walipili. ");
INSERT INTO dji_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Bil miri djanggu buḏigiṉing ingki lidji ḏirradjigi. ");
INSERT INTO dji_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Miri bilang wiḻi ngunupilang buḏi lidjny maltjarrkang marrga lidji balidji, girri ngarri ngunugirinyi yarṯi irr ḏapiḻidjigi. Ga ngunubilang maypaldji bungi yulnginyi, irr yarṯi ḏapiḻidjigi girrgima, miri yuldji ngunukuma maypal bintji ngurrgima bungi. ");
INSERT INTO dji_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Miri bilang wiḻi ngunupilang yulnginyi bungi, wurpilitja yuldji bintji ngurrguma ngungiriny bungi, gima ngarri ngamangamadjili yul miri ngarribipm.” ");
INSERT INTO dji_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Nyuniban mala bungi marrga yulpili djani mala inydjin ngurri djin galbidjidji. ");
INSERT INTO dji_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","11","Girri Gunydjirri djina wangini, “Djiningi murr randinirbi lidjny irr gungi lidjarr yirryirrpigi, ngilidjang ga djanngang ngunung yulpili djin bungtjigi djadjuḏitj, ngunyili yipi djirridjipm bintji ngurrguma, ga miri maypilgi, ṉukiṉingirgi, ga waykiṉingirgi djiny irr gungi djiniginy murr randinirbi, gam'. Ingki yili miri ngarri buwayaknyirdjigi maypal ga yul djiḻi gurrbi munganmirri, ingki yili nyuṉaṉ wurpi irr yani bapiḻi miri lidjny irr djingirigi. ");
INSERT INTO dji_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","17","Namba irr yirrpi giri ṉammirri giṉimbirrimirri, irr djir'wakdji giri, ga ngunukuma namba nyani minydji djirridji miri mayaligiṉing ngilidjang, marrga limiliny guṉgi biḻmiygi djining murr randinirbi, bilpilang. Nyadji ngunupilang mangurr bi giri, ga inydji manymakdji giri djir'wakdji giri, ngarri ngunung irr nyangban, miri ngunung irriny guṉgigiṉdjigi ngirrang murr randinirbi, marrga ingki yili irr yani nyuṉaṉ wana miri lidjny bungi. Miri bilapilang irr yirrpigi ngunukuma namba ṉammirri marrga irr gingidjiban ngilidjangban.” ");
INSERT INTO dji_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Manymak, walkiriwilingim Nuwang djin yulgungili mitjiyangngir Djim, Yam, ga Djapit, ga Yamang walkiripm yagirri Kanan. ");
INSERT INTO dji_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Djiniwilingir yulpili djin barrkirrdjini bukmak wurpili wurpili gurrbili. ");
INSERT INTO dji_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Manymak, nyani Nuwa munatja djamagiṉingi. Nyani ngurrḏawalangudji miri lamudjili gambilki. ");
INSERT INTO dji_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Djungapm nyani djamadjili nganatji, ḏirradjili, girri babakiṉdjiniban, miri gar gurriyili ngu'ngurrinyi wiṉiṉmirri. ");
INSERT INTO dji_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ga Yam nyangiṉi gunydjirripm gar gurriyili ngurrinyi, ga wuwwilingim djiny butjirgiṉdjili. ");
INSERT INTO dji_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Girri biling Djim ga Djapit mirikal bil marrngili, burrdjipm bil gangili, mungandjipm bil wiṉini, girri gari bil ngagirrdjini Nuwang. Ingkiban bil nyanyiri nyanngang gari. ");
INSERT INTO dji_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Guyumban Nuwa binygadjini, ripirrdji gubini, ga marnggidjini miri Yam nyangiṉi nyaninyi gunydjirripm gar gurriyili ngu'ngurrinyi. ");
INSERT INTO dji_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Ga nyani Nuwa yan mayaligiṉing inga wangini Yamgi marrga gunyambi birraldjidji, nyani bindjin, “Djining birraldjidji gunyambi, nyungung walkiripmngirang, nyani ingki djirridji yagirr wana, bil yagirr ṉininidjidji, miri djamagiṉing djina wuwwilingirgim.” ");
INSERT INTO dji_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Ga yili Nuwa djina wangini walkirwilingirgim, “Lim djaltjibigi Yawaynginyi yagirri, God Miligidji Djimang. Kanan nyani djina djamagiṉingi nyibiwiliki. ");
INSERT INTO dji_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Goddji gurrbi rirrbigi Djapitgi marrga nyani nyinidji giri nyanngar Djimngirar wiṉiṉmirri, ga Kanan djamagiṉing bilingga.” ");
INSERT INTO dji_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Manymak, rirrngiri nyuṉaṉngir Nuwa wanngi nyininyi 350 guṉmal ga rarranydjarr, ");
INSERT INTO dji_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","miri bukmak guṉmal ga rarranydjarr Nuwang 950 gatjidjini, girri nyani wirrdjiniban. ");
INSERT INTO dji_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Manymak, djining djanguny Nuwang gurrṯigiṉingirang mala muṉḏaṉ. Djim, Djapit, ga Yam, djiniwilitji mala djin buny kirinyi rirringir nyuṉaṉngir, ga djining djanguny bultjigi djanngang gadjigarr. ");
INSERT INTO dji_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Djining Djapitang gurrṯigiṉingirang mala gadjigarr (ga nyani Djimang gulmingimi). Guma, Maguk, Maday, Djaban, Tubal, Midjik, ga Tiratj, ngunuwili Djapitang walkirwilingim. ");
INSERT INTO dji_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Ga Gumang walkirwilingim, Atjkinatj, Ripat, ga Tugama. ");
INSERT INTO dji_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Ga Djabanang walkirwilingim, Yilitja, Tatjitj, Kitim, ga Rudanim. ");
INSERT INTO dji_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Djinikirang yulpili mala djin barrkirrdjini wurpili wurpili gurrbili mala, ngidjirrkng gapi djalkngmirri djin gurrbidjili, djal ḏambimirri ga djabir burringi, wurpi wurpi mala yan djin wanginyi. ");
INSERT INTO dji_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Djining Yamang gurrṯigiṉingirang mala gadjigarr. Kutj, Yidjipt, Put, ga Kanan. ");
INSERT INTO dji_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Ga Kutjang walkirwilingim, Djiba, Abila, Djapta, Rama, ga Djaptika, ga Ramang walkirwilingim Djiba ga Didan. ");
INSERT INTO dji_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Manymak, wurpi walkiripm Kutjang yagirri Nimrut. Nyani yagirr wana yul, ngurrḏawalangu djina wurpi wurpigi malagi. ");
INSERT INTO dji_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Nyani djambatj mirrpm maypilgi milbimirri Godang Yawayang, marrga yulpili djin wanginy giriny nyanngangi djin bininy giriny, “Miri Nimrut, mirrpm djambatj maypilgi milbimirri Godang Yawayang.” ");
INSERT INTO dji_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Warrngguwili gurrbi wana nyani mutjpiningili, wurpm Babilun (Babylon), wurpi Yiritj, ga wurpi Yakat, djiniwili gurrbi wana djarrinyi gurrbuwi yagirrmirri Djinar (ngunung Iraq djawal). ");
INSERT INTO dji_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","12","Ga ngunungir gurrbingir Djinarngir yul girali yagirri Atjur. Ga nyani Nimrut mutjpiningili gurrbi wanapili djiniwili, Niniba, Riyubutir, Kala, ga Ritjin. ");
INSERT INTO dji_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Manymak, Yidjipt nyani guṉgi bilagaping djina wurpi wurpi malagi, miri Ludim mala, Anamim mala, Liyabim mala, Naptuyim mala, ");
INSERT INTO dji_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrutjim mala, Katjiluyim mala, ga Kapturim mala. Ga ngunukuma Kapturim yulpili djanngapibi wurpi mala birraldjili, miri Pilitjayin (Philistines) mala. ");
INSERT INTO dji_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Ga Kanan walkir marrngili yidjipilpili galbi, yagirrpili Djaydun nyannang miḻimiti, girri Ngitj, ga wurpiwili. Ngunutjini, mala inydjin bipiṉi miri, wurpi wurpi mala bapurrurr, yagirrpili ");
INSERT INTO dji_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Djibutjayit (Jebusites mala), Amurayit (Amorites mala), Girgatjayit, ");
INSERT INTO dji_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Yibayit (Hivites mala), Arkayit, Djinayit, ");
INSERT INTO dji_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arbadayit, Djimarayit, ga Yamatayit. Ga guyumpiliban Kananang gurrṯigiṉing mala inydjin garrwurdjili, ");
INSERT INTO dji_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","marrga ngunungiri gurrbingir Djaydunngir ga djiningiri gurrbingir Gadjangiri rarri gapimirri djin gurrbidjili, ga rarri burringi djin gurrbidjili ngunung yagirrpili gurrbipili Djudum, Gumurra, Adma, ga Djibuyim ngidjirrkng Latja gurrbi. ");
INSERT INTO dji_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Nguṉitjini girri Yamang gurrṯigiṉing mala, miri wurpi wurpi yulpili, wurpi wurpi bapurrurr, wurpi wurpi yan djin wanginyi, ga wurpirri wurpirri gurrbuw djin nyininyi. ");
INSERT INTO dji_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","24","Djiningi Djimang gurrṯigiṉing gadjigarr. Djimang walkirwilingim yagirrpili, Yilam, Atjur, Arpatjat, Lud, ga Aram. Aramang walkirwilingim yagirrpili, Yutj, Ngul, Gitir, ga Matj. Arpatjat walkir marrngili Djila ga Djila walkir marrngili Yibir. Bilapilang miri Djim nyani guṉgi bilagaping inga Yibirgi, ga Djim nyani Djapitang wuwngimi. ");
INSERT INTO dji_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Manymak, Yibir walkir marrngili yutjuwili bingili Pilik ga Djuktan. Ga Pilik bilidjirri bukmak djin barrkirrdjiniban. ");
INSERT INTO dji_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Ga Djuktanang walkirwilingim yagirrpili, Almudat, Djilip, Yatjamabit, Djirar, ");
INSERT INTO dji_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","29","Yaduram, Yutjal, Dikla, Yubal, Abimayil, Djiba, Yupir, Yabila, ga Djabap. ");
INSERT INTO dji_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Djanngang gurrbi djabir burri bumir djimurruli. ");
INSERT INTO dji_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Nguṉitjini girri Djimang gurrṯigiṉing mala, miri wurpi wurpi yulpili, wurpi wurpi bapurrurr, wurpi wurpi yan djin wanginyi, ga wurpirri wurpirri gurrbuw djin nyininyi. ");
INSERT INTO dji_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Miri ngunung ngurrguma Nuwang gurrṯigiṉing mala, ga nyalinggirapibi djini wurpapi wurpapi gurrbibi. Miri djiningir ngurrḏawalangungir yulpili djin barrkirrdjini wurpili wurpili gurrbili rirringir ngunungir girri nyuṉaṉngiri, girrban. ");
INSERT INTO dji_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Manymak, ngurrwakng baman pirr bukmak djin wanginy girinyi wurpm yan ga wurpm djilang. ");
INSERT INTO dji_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Manymak, nyibi yulpili bi djin girinyi djimurrungir, ga djin birraldjnyirdjili gurrbi wayala mirrpm ḻambirring, girri miri nguḻiguma djin gurrbidjili gurrbi yagirri Djinar. ");
INSERT INTO dji_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ga djina djin witjili, “Bi lidji giruwi bapiḻi gurrbili, gaṉamba lim marrgi, lim ḏutjigi, lim batjigi marrga maṉbidjidji. Marrga lim mutjpinigi bala' galbi.” Djin djamadjiliban galbi batjinirbi maṉbipili, ga ngaḏitjalidji mulngdji munatjabir (bitumen) djin mapirrdjini, miri bilapilang djin mutjpiningili bala'. ");
INSERT INTO dji_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Rirringir ngunungir girri djina djin witjili, “Bi lidji giruwban, lim mutjpinigi gurrbi wanaban, ga lim mutjpinigi wurpm bala' guṉgi giḻiwiḻi djaydjaying giṉimbirrimirri. Yagirri inydji lim wanadjigiban bintji inydji lim garrwurdjigi wurpili wurpili gurrbili.” ");
INSERT INTO dji_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Manymak, God Yaway bi djundjini marrga nyangi ngunung gurrbi wana ga ngunung guṉgi giḻiwiḻi miri wiṉḏi djakuḻuḻu. ");
INSERT INTO dji_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Girri Gunydjirri Ṉampi wanginiban, “Ngunubilang inydjin bumir gurrkung marrga giḻiwiḻim djin djamadjigi nyim ngunupilang djin djalngdjidji, miri bintji ngurrguma djin djamadjigi, gima miri wurpm mala djini ga wurpm yan djin wang girimi. ");
INSERT INTO dji_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ma', lim djundidjiban, marrga yan wurpi wurpi djinyi lim gungi, marrga inydjin bumir marrbigi yan.” ");
INSERT INTO dji_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Girri nyani God bi djundjini, ga djiny gungili wurpi wurpi yan, marrga inydjin garrgarrpiniban yan. Ga nyani djiny garrwurdjili wurpili wurpili gurrbili djin giraliban, ga djani djin guḻdjiliban bala'ngiri mutjpininyirngir, miri ingkiban yili djin mutjpininyir bala'. ");
INSERT INTO dji_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Nguṉitjini yulpilingir ngunung gurrbi wana djin bultjini giriny Babil gima ngunung yagirri mayaligiṉing miri ‘butjir mal baḻpinyirbi’. Yarimban nguḻiguma djani inydjin garrpini wanginy kirinyban, marrga djin butjir mal baḻpiny giriny, ga ngunungiri djin barrkirrdjini wurpili wurpili mala gurrbili djin girali djiḻi gurrbi munganmirri. ");
INSERT INTO dji_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Manymak, djining Djimang gurrṯigiṉing muṉḏaṉ. Djim nyani ngurrum gatjidjini 100 guṉmal ga rarranydjarr ngunukiṉing nyani walkir marrngili Arpatjat, bingili guṉmal rirringir ngunungir girri nyuṉaṉngiri. ");
INSERT INTO dji_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Rirringir ngunungir girri Arpatjat bungtjili, nyani Djim yili gatjidjini 500 guṉmal ga rarranydjarr, ga walgurwalgur gatjidjini galbi. ");
INSERT INTO dji_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","23","Arpatjat nyani walkir marrngili Djila, ga Djila walkir marrngili Yibir, ga Yibir walkir marrngili Pilik, ga Pilik walkir marrngili Riyu, ga Riyu walkir marrngili Djiruk, ga Djiruk walkir marrngili Nayur. Nguṉitjini mala yulpilingir djin walkir djamini galbi yidjipilpili, ga miri djin nyininyi wanngi giḻiwiḻingakiṉingi. ");
INSERT INTO dji_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","27","Ga Nayur walkir marrngili Tira, ga ngunukiṉing Tira gatjidjini 70 guṉmal ga rarranydjarr nyani ngurrum walkir marrngili warrngguwili walkirwilingim, yagirrpili djina Abram, Nayur, ga Ngaran. Ga Ngaran walkir marrngili Lut. ");
INSERT INTO dji_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Miri ngunukiṉing bilidjirri Tira nyininyi, nyani Ngaran baliniban nyanngarpm gurrbuwi mutjing inga, ngunung gurrbi wana yagirri Ngur nguḻi ngunung Kaldiyang malang djawal. ");
INSERT INTO dji_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram ga Nayur biling bil marrngili miyilk mirrpili biliny bili nyanimwilingim. Abramang nyanimngim yagirri Saray (Sarai), ga Nayurang nyanimngim yagirri Milka. Milka nyani Ngaranang walkiripm, ga Milkang gaḏingim yagirri Yitjka. ");
INSERT INTO dji_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Ga Saray, Abramang nyanimngimi, nyani budjirr yidjipilinyirring. ");
INSERT INTO dji_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Manymak, djani djin yilitjini wurpili gurrbili bilay bilayili, Tira, ga nyanngang walkiripm Yipram, ga nyanngang marratjamirringipm Lut, ga Saray Abramang nyanimngim. Djin gubini gurrbingir Ngurngir marrga djin giri bumir djunupa Kananili gurrbili. Bil baṉimi Yaran gurrbi nguḻi djin gurrbidjili, giḻiwiḻing djin nyininyi nguḻi. ");
INSERT INTO dji_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Ga Tira nguḻiguma balini gurrbuwi Yaran, nyani ngurrum gatjidjini 205 guṉmal ga rarranydjarr, girri nyani wirrdjiniban. ");
INSERT INTO dji_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Manymak, ngurrwakng nyani Abram yilitjini gurrbingir nyanngangir mutjingir, nyani God Yaway nyani inga wangini Abramgi, “Djining djawal nyungung gurrbi mungan nyuni gubidjiban, ga minydji giriwban djiningir, ga yilitjirrdji wurpiliban, ngunyili gurrbili miri ngarri guyumban nyirr mil-ḻirrpigi. Ga ngunuwiliny nyungung gunydjirrgirang malany nyuni djiny gubidjiban. ");
INSERT INTO dji_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ga ngarri djinimirri inmarr djamadjigi inmarr manymakdjigi gam': nyungupibi ngarri ngamangamadjigi bapurrurr yuwirdjing, ga nyungung mala-punyirbi djani minydjin nyinidji yagirri-wana mala. Ga ngarri inmarr djakadjigi, ga nyuni yagirr-wanadjidji, marrga nyungupibi galbi yulpili djin marrkapdjidji giri. ");
INSERT INTO dji_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ga ngunubilang wirapili inma djin marr-bulanggitjdjidji, ngarritjaban bilang djinarr marr-bulanggitjdjidji. Ban ngunubilang wirapili inma djin rarri-wangidji, ngarritjaban djinarr rarri-wangidji. Ga gima nyungupibi, bukmakgi bapurrurrgi malagi djiḻi gurrbi-munganmirri nyi'nyini, rum djina djin manymakdjidji. ");
INSERT INTO dji_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Manymak, Abram giraliban miri Yaway inga bultjidjini, ga nyani Lut inga maltjili. Nyani Abram ngurrum gatjidjini 75 guṉmal ga rarranydjarr ngunukiṉing minydji yilitjini gurrbingir Yaranngir marrga wurpili djawalili giri. ");
INSERT INTO dji_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Ga nyani gangili nyanngang nyanimngimi Saray, nyanngang gulmigirang walkiringim Lut, ga bukmak djamagiṉpili nyani djiny marrngili ngungirapibi gurrbibi Yaranbi, ga bukmak girripili nyani gurtjili nguḻi gurrbiwi. Nyani marrngili bubalikiṉing, girri ḻarrban djin warrwarrdjny kirinyban walanggarrali, ngunukima djawal Kanan bilay pirr, ga rirringir yakirri galbingir djin yulgungili Kanan. ");
INSERT INTO dji_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Girri Kananmirrpmi djin gukirriny kirinyban, gima djin djawal-nyany kirinyi. Guyumban djin yulgungili nguḻi gurrbiwi Djikim, ngunukima gurrbi nyaling gurrtji wana djarrinyi, ga nguḻiban djin gurrbidjili munganmirri ngunukima djunggimirri. Manymak, ngunukiṉing bildjirri ngunukima Kanan djawal ingki ganba, bil wurpi wurpi bapurrurrpili djin nyininy giriny mala Kananmirrpmi, miri Kananayit bapurrurr, ga wurpipili. ");
INSERT INTO dji_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Manymak, God Yaway inganydji mil-ḻirrpini Abramgi ga inga wanginiban, “Djining djawal djinarr gungi djanki miri nyungung bapurrurrgi, ngunung mala guyum inydjin ngurri.” Marrga Abramdji yip mutjpiningili rirrkiyandji, marrga ṉammirri inga burrtjirrdji maypal Yawaygi miri mundjarr inga, gima nyani nguḻikima inganydji mil-ḻirrpini. ");
INSERT INTO dji_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Rirringir ngunungir-kirri nyani yilitjini ngunyili bumirili gurrbili, ngidjirrkng Bitil gurrbiwi bil ngunyilatjuy bumiri-djimurruli, ga nguḻikima nyani wiṉiṉ yirrpini; yarim biling gurrbimirrpili Bitil ga Ngay ray ray inga bil gatjini, ga baṉim nyani yirrpini wiṉiṉ burringi. Ga nguḻi nyani rirrkiyanpili marrngili, girri yip yirrpini madjirri, girri bumirgiṉdjiliban Gunydjirrgiriny yagirrmirrpm Yawaymirrpm. ");
INSERT INTO dji_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Ga guyumi nyani yilitjini, ga yirrpili djin girali, ngunung wirrpili djawal bumir-djalatjangili, ngunukima gurrbi djin bultjini giriny Nigip (Negeb). Djin ngurriny kiriny djutjdjutj, Nigip-li djin djundjini kiriny, gima waligi djin miliny kirinyi. ");
INSERT INTO dji_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Bilapilakiṉing bildjirri bubalikiṉing bapurrurr djin nyininy kiriny ngalbirkiban, gima wirrban mayurrk rikinyir, marrga marri ṉinini wali djurrginy giriny ṉambiḏi djawalmirri Kanan. Marrga nyani Abram yulgungiliban Kananngir, ga djin djundirrdjini djawalili Yidjipt-li, marrga yalkuy djin nyinidji nguḻi, gima Kananmirri bukmak yul mala mirrpmban djin baliny giriny maypalgi ga waligi. ");
INSERT INTO dji_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ga ngidjirrkng Yidjipt djini-guyum ngunyili djin ranyir, nguḻiban nyani Abram inga wangini nyanimngirgim Saraygi, “Ngarri marnggi miri nyuni mirrpmi djal-maḻimaḻing miyilk. ");
INSERT INTO dji_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Marrga ngunukiṉing nguṉitjini Yidjiptmimigi mala nyin djin nyangi, miri djining ngurrgima djin bintji wangidji, ‘Ngunung miyilk nyani djining nyanimngim inga!’. Ga ngirrinyban irriny djin rani marrga nyin djin djamigi. ");
INSERT INTO dji_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Buṯaltja nyuni djina bultjigi miri nyuni ngirrang gaḏingimi, marrga gima nyungupibi ngarri nyinidji bulanggitj marinyirring, ga wanngipm irr nyinidji giri.” ");
INSERT INTO dji_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Manymak, girri ngunyili djin ragiliban Yidjipt-li. Ga nguṉitjini Yidjiptmimigi mala djin nyangiṉiban miri Saray djal-maḻimaḻing mirrpmi. ");
INSERT INTO dji_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ga djanngang ngurrḏawalangu ngunung yaku-wana yul djin bultjini giriny Paruw (Pharaoh). Manymak, Paruwang djamagiṉingir maladji djani djin nyangiṉi, ga djanguny djin gangiliban Paruwli Sarayang, ga inga djin wukdjili Saraygi nyanngali Paruwli. Marrga nyani Paruwdji djina yan-kungiliban miri djin bagiligi Saraynyi, marrga nyani Saray nyinidji giri nyanngar miri nyanimngim inga. Girri djani djin marrngili Saraynyi, ga ngunukima miyilk nyani nyininyban gurrbiwi Paruwang, ngunukiṉingban nyi'nyininyban bala'mirri wanamirri nyanngang. ");
INSERT INTO dji_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Ga gima nyanngapibi Saraybi, nyani Paruwdji gumbirrgiṉdjili Abramnyi, yarim galbi mundjarrpili inga gungili, marrga nyani Abramdji ma'marriny kiriny mala mala galbi, yarim nyani gatjini giriny galbi bimbi maypal mala, ga galbi buluki mala, ga galbi dungki mala, ga kamul mala, ga galbi djamagiṉpili yarim yulpili ga miyilkpili. ");
INSERT INTO dji_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Bil Yawaydji nyani mari djina djamadjiliban, miri Paruwgi ga nyanngang gurrṯigiṉingirgim, marrga djani burrkburrk wanaban djin marrngili gima nyanimngim inga Paruwdji gaypili Abramnyi. ");
INSERT INTO dji_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Girri Paruwdji nyani yan yanili miri Abram bi baḻpargi. Ga ngunukiṉing Abram yulgungili, nyani Paruw yan-maṉbi inga bindjiniban, “Nyawban nyaliki nyuni irra mari-djamadjili, yarim irr rirrkminygiṉdjini gima nyungupibi! Nyimki nyuni ingki irra bultjinir miri Saray nyani nyanimngim inma? ");
INSERT INTO dji_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Nyimki nyuni irra bindjin, ‘Nyani djining ngirrang gaḏingimi,’ marrga irr djamirrdjini ngunukima, biṯma burali miyilk? Djinimkima nyungung nyanimngimi, marriwban ga bilayiliban minydji giriw!” ");
INSERT INTO dji_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Girri Paruw djina bultjidjini nyanngang djamagiṉpilngiriny miri djani djiny djin guṉdjirr-djitigi Abramnyi mala. Girri ngunukirri djamagiṉpilingir djiny djin badji-nyangiṉiban, marrga minydjin giraliban, miri Abram, nyanngang nyaningimi, ga nyanngang djamagiṉing mala. Ga Abramdji gangili bukmak girripili nyani gurtjili nguḻi Yidjipt gurrbiwi. ");
INSERT INTO dji_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Manymak, djani djin yulgungili Yidjipt-ngir, miri Abram, nyanimngim inma Saray, ga bukmak Abramang girripili, ga Lut. Ga djin wiṉiniban yirrpili djin walmini ngunyili Nigip-ili djawalili giḏidjirrim. ");
INSERT INTO dji_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Yarim nguḻikirri Yidjipt gurrbimirri nyani Abram rrupiyagiṉdjini mirrpm, marrga ngunungir-kirri nyani djiny gatjini giriny galbi rrupiya ga nyim ngunupilang maypalpili miri buluki ga bimbi, galbi mala. ");
INSERT INTO dji_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Ga djin warrwarrdjny kiriny yirrpimirrpm, djin ngurriny kiriny djutjdjutj, girri djin yulgungiliban gurrbiwi ngunukima wanim gurrbi ngidjirrkng Bitil nyibirri djin gurrbidjili biligi, ");
INSERT INTO dji_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","yarim ngunung ngurrgima gurrbiw nyaling rirrkiyanpili nyani mutjpiningili ga yip djamadjili Garraygi ngurrwakngi. Manymak, rirringir yulgunyirngir nyani inga bumir-witjili Godgi madjirri yagirrimirrpm Yawaymirrpm. ");
INSERT INTO dji_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Ga nyanngangi Lutgi, nyani wurpi miri galbi wiṉiṉ ga djamagiṉpili ga maypalpili djiny gatjini giriny yarim miri Abramdji. ");
INSERT INTO dji_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Manymak, Abram ga Lut biling wurpilipm bil nyininy girinyi, bil ingki galbi yurryarr djurrginyir nguḻi maypalgi ḏirradjnyirgi, gima bil gatjini maypal galbi. Marrga maṯiṯdju bilngga yarim wurpilipm bil nyininy giriny wurpirrim gurrbimirri, ");
INSERT INTO dji_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","gima bilngirang djamagiṉpili inydjin yimini giriny yurryarrgi, gima ngunukima malamirrpili biling bil djalngdjny giriny yurryarrgi bukmakgi, bil wirr gadjigarr bilingga gima wurpipili bapurrurrpili djin nyininyi nguḻi, miri Kananayit bapurrurr ga Piritjayit bapurrurr. ");
INSERT INTO dji_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Marrga nyani Abram inga wangini walkiringirgim Lutgi, “Ngili djining gurruṯigiṉing ili, ingkiban bilang inydjil yimigi. Manymaktja djiny il guḻmiygi yiminirngir ngunuwili djamagiṉpilngiriny ngiltjang. ");
INSERT INTO dji_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Nyuniban djawal-nyangi, ga nyibirri gurrbigi nyuni djalngdjidji, nyuniban bilang inma rindiligi ngunukima gurrbi. Girri nyuni yilitjirrdji ngirrangir, marrga rarrmiḻi-rarrmaḻipmban il nyinidji giri. Yarim ngunubilang nyuni yilitjirrdji wiṉgungir, ngarritjaban bilang irr yilitjirrdji djunupangir, ban ngunubilang nyuni yilitjirrdji djunupangir, ngarritjaban bilang wiṉgungir irr giri.” ");
INSERT INTO dji_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Girri nyani Lut milingiliban, ga gurrpuḻu nyangiṉi miri ngunung djawal djarrinyi ngidjirrkng ngunukima mani djin bultjini giriny Djudun (Jordan). Ga ngunung gurrpuḻu miri buṯal mirrpm gima gapi galbi ngurriny giriny nguḻi, miri ngunung ngurrgima ngunukirri gatni Godangpibi ngurrwagipi, ga miri Yidjipt gurrbiwi. (Ngunupili wana gurrbimirrpili, Djudum ga Gumurra, djarrinyini nguḻikima gurrpuḻumirri, gima ingkipm nyani Goddji bilngiriny malimdjnyir, biḏakipm. Yarim bilapilakiṉing nyani Lut ngunyili yilitjini, buṯalban ngunung gurrpuḻu djarrinyipm.) ");
INSERT INTO dji_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Marrga ngunukima gurrpuḻu nyani Lutdji inga rindilali nyanngangpibi, ga ngunyili yilitjiniban bumir-djimurruli. Miri bilapilang biling Abram ga Lut inydji bil garrwurdjili. ");
INSERT INTO dji_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Manymak, rirringir ngunungir-kirri nyani Abram gurrpini giriny nyininy giriny nguḻi burringi Kanan djawalmirri, ban nyani Lut inydji yirryirrpini gurrpuḻumirri, yarim nyininy giriny wayalimirri ngidjirrkng ngunuwili wana gurrbipili djin djarrinyi gurrpuḻumirri, ga ngidjirrkng Djudum gurrbiw nyani djiny yirrpini wiṉiṉpili inga. ");
INSERT INTO dji_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Bil ngunutjini Djudum-mimigi mala, gadjigarr djina mirikunu mirrpmi, ga Godang rum djin wubirdjny giriny munguy. ");
INSERT INTO dji_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Manymak, rirringir nyani Lut yilitjini Abramngir, nyani Yaway inga wanginiban Abramgi, “Nyuni milikiban miri ngunyili ḻunggurrmali ga djalatjangili ga djimurruli ga waḻirr mungan inydji yirrpinirli, ");
INSERT INTO dji_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","gima bubalikiṉing gurrbi nyuni nyangi, ngarri djiniwiliny inmarr gungi gurrbipili, miri nyungki ga djanki nyungung mala-punyirbi ngildjnyirr gungi djining djawal, ga djani minydjin galiki ngunyili yipi. ");
INSERT INTO dji_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ga nyungung mala-punyirbi djani djin galbidjidji, bilapilang miri rirrpiḏi mala djin ngurrinyi munatjamirri; yarim ngunubilang wari ganydjirrgiṉdjidji djiny butjurrudjigi djiniwiliny, nyani girri ganydjirrgiṉdjidji djiny butjurrudjigi nyungung mala-punyirbi, bilapilang. ");
INSERT INTO dji_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Djirridjiban, ga gukirridjiban djawalmirrpm djiningir ngunungir, gima nyungkiban ngarri inmarr gungiban djining djawal.” ");
INSERT INTO dji_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Girri nyanngang wiṉiṉ Abramdji yilbirtjili ga yilitjini djalatjangili. Ga ngidjirrkng Yibrun (Hebron) nyani inydji yirryirrpini munganmirri gurrtjimirri, ngunukima gurrtjipili Mamri'ang ngunung gurrbiwaṯangungirang wari nyininy giriny nguḻi gurrbiwi Yibrun. Ga madjirri rirrkiyanpili nyani Abrayamdji gurtjili girri yip djuyugiṉing inga mutjpiningili Yawaygi. ");
INSERT INTO dji_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","2","Bilapilakiṉing bildjirri, yul gamuṉunggumirrpili inydji bil gurrkungili, bil bumir-gamuṉunggudjiniban. Wurpmi mala bi djin girali bilayngir djimurrungir, yarim Yamrapil ngurrḏawalangu djina Djinar-mimigi malagi, ga Yariyuk ngurrḏawalangu djina Yilatjar-mimigi malagi, ga Djidurlayumir ngurrḏawalangu djina Yilam-mimigi malagi, ga Tidal ngurrḏawalangu djina Guyam-mimigi malagi, yarim bingili ga bingili ngurrḏawalangupili ga guḻinydjarr djina mala, wurpirrim inydjin ṉu-gurrkungili marrga djani djin djirridji wurpirrimban, yarim djani miri mulkurupili walanggarrabi. Ban ngunukima wurpitji mala djingirapibi djawalbi djani miri bilapilang gam': Bira ngurrḏawalangu djina Djudum-mimigi malagi, ga Birtja ngurrḏawalangu djina Gumurra-mimigi malagi, ga Djinap ngurrḏawalangu djina Yatma-mimigi malagi, ga Djimibir ngurrḏawalangu djina Djibuyim-mimigi malagi, ga wurpi ngurrḏawalangu ngungirapibi gurrbibi Bila-bi ngunukirri gurrbiwi Djuwar marri bilay, yarim gumbirr wurpingirpm ngurrḏawalangu ga gayitgiṉing djina mala. ");
INSERT INTO dji_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Djiniwili 5 ngurrḏawalangupili ga djanngang gamuṉunggupili inydjin mutpiningili nguḻi gurrpuḻumirri, ngidjirrkng gapimirri djalgimirri ngunung wana ngambuḻ gapi ngurrinyi wayalimirri, ga ngunung wayali djin bultjini giriny Djidim. ");
INSERT INTO dji_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Bilapilang miri bilakiṉing 12 guṉmal ga rarranydjarr djin bangiringili, ngunukima ngurrḏawalangupilingir djin djamadjny giriny inga ngungirki bunggawagi Djidurlayumirgi, bil rirringir wurpingir guṉmalngir djani rurruḻdji inganydjin yirrpiniban bunggawagi, marrga inga djin butjir-djumiḻidjny girinyban. ");
INSERT INTO dji_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Manymak, wurpi guṉmal bangiringili, rirringir ngunungir-kirri ngunukirri 4 mulkurupili ngurrḏawalangupili djani bi djin girali bunyirli, yarim Djidurlayumir ga wurpiwilitji ga djanngang gamuṉunggu mala, ga djin ragili djawalili Kanan-li. Girri nguḻikima djin buny kirinyban, ga galbi yulpilngiriny djiny djin barrtjin, marrga wurpi wurpi bapurrurrpilngirinyi djiny djin ḏimbitjnyirdjili. Yarim djiny djin baḏirdjili djiniwiliny malany, gam': Ripayim mala nguḻi gurrbiwi Yatjirutj-karnayim, ga wurpiwili girri miri Djutjim mala nguḻi gurrbiwi Yam, ga Yimim mala nguḻi gurrbiwi Djabi-kiriyatjayim, ");
INSERT INTO dji_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ga Yurayit mala nguḻi Djiyar gurrbiwi ngunung bumiri gurrbi ngidjirrkng Yil-paran gurrbiwi galiymirri yirrpimirri djarrinyi. ");
INSERT INTO dji_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Girri bapiḻakuwa djin wirrkwirrkdjili ngunyili Yin-mitjpat gurrbili, ngunung gurrbi nibi bultjin girimban Kaditj, girri nguḻi djiny djin djanadjanadjili bukmaknyi Amalikayit malany ga ngunuwiliny Amurayit malany djin nyininy giriny nguḻi gurrbiwi Atjatjun-tamar. Miri bilapilang, djin buny kirinyban. ");
INSERT INTO dji_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","Marrga ngunukirri ngurrḏawalangu mala Djudumbi, Gumurrabi, Yatmabi, Djibuyimbi, ga Bilabi, djiniwiltji djiny djin mutpiningili djanngang gamuṉunggu malany, girri ḻarrban ngurri-wurpmi djin giriny nyininy bunyirli. Guyumi djina djin yulgungili, girri inydjin bumir-baḻparngiliban, bingili mala yarim 4 ngurrḏawalangupili biribiri 5 ngurrḏawalangupili mulkurupili. ");
INSERT INTO dji_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Miri bilapilang nguḻikima Djidim wayalimirri, galbi ngambuḻ ralal ngurriny girinyi miri ralal gaḻanyangiṉing mulngi munatjabi, mirikunu mirrpmi. Ga ngunuwiltji gamuṉunggupilingir Djudumbi ga Gumurrabi djani djina djin barrtjidjini mulkurupilingirgi gamuṉunggu malagi, bil inydjin yulili, marrga minydjin ṉunydjirraliban. Ga ngunupili bunggawamirrpili Djudumbi ga Gumurrabi biling bil ṉunydjirrali ga rungili inydji bil nguli ngunyili ralalili mirgili, ga wurpiwiltji djin butdjili ga bumirili djin walmini rirrkiyanili. ");
INSERT INTO dji_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Girri nguṉitjini mulkurupilingir djani girripili biliny djin gaypili Djumum-mimigi malany ga Gumurra-mimigi malany, ga djin djamirrdjini bukmaknyi walipiliny ngungirapibi gurrbimirrpilibi, ga djiny djin djamirrdjini girri yulpilingirinyi, girri warrpam minydjny djin gangiliban. ");
INSERT INTO dji_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ga djin djamirrdjini Lutnyi Abramang gulmigirang walkiringimi, ga warrpamnyi miri nyanngang girripili ga yulpili girrgima djiny djin djamirrdjini, gima nyani Lut ngurriny giriny nguḻi ṉambiḏi Djudum gurrbimirri. ");
INSERT INTO dji_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Manymak, wurpilim butnyirakiṉingir bi inga gangili djanguny Abramgi ngungirki Yibriw (Hebrew) yulgi, ga ngunukima yuldji manyangiṉi Abramnyi nyininyi munganmirri gurrtjipilimirri, ngunuwili gurrtjipili Mamridji djiny gatjini giriny. Yarim djining yul Mamri nyani miri Amurayit yul, ga nyani miri gurruṯigiṉing bilingga Yitjkulgi ga Anirgi, ga djiniwiltji gurrbiwaṯangupili djani miri ṉamkaṯdjinginakiṉpili inga Abramgi. ");
INSERT INTO dji_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Manymak, ngunukiṉing Abramdji marrngini djanguny miri nyaliki djin djamirrdjini nyanngang gurruṯigiṉing Lutnyi, nyani djina witjiliban gamuṉunggu malagi nyanngangpibi, nyabiniwili miri 318 yul mala, yarim ngunuwiltji djin bungtjili ngurrwakng gurrbimirri nyanngar. Girri djani djin marrngili gayitpili, ga ngunukima wurpiwiltji bunggawapili miri Anir, Yitjkul, ga Mamri, djina djin maltjili, ga djanngang gamuṉunggu mala girrgima, girri djiny djin gurrpiniban. Djin giriny nyininya-a-a, ṉu djin gurrpini kirinyban, djiny djin djugadjugamiyngili. Guyumban maliri, djiny djin manyangiṉiban ngidjirrkng Dan gurrbiwi nyaling gaṉḏi inydjin galini kiriny. ");
INSERT INTO dji_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Girri Abram ga nyanngang yulpili djin barrkirrdjini, yungaṉban djin wirrkwirrkdjili ḻiyuw ḏap djin baḻbaḻdjili djin djuḏapdjili. Ngidjirrgingir djin yarrarramiyngili djin barrtjinban. Ga ngunukirri mulkurupilngiriny nyibi djiny djin bipiṉiban bil nyibi minydjin ṉunydjirraliban, ga djani djiny djin gurrpiniban gamuṉunggudji Abramang giḻiwiḻing ngunyili Yubar-li gurrbili, ngunung gurrbi bilay pirr djarrinyi ngidjirrkng Damaskus gurrbiw bil ngunyilatjuy bumir-ḻunggurrmali. ");
INSERT INTO dji_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ga nyani Abramdji bubalikiṉinginyi biringirpm djiny gaypili miri bukmak girripili, yidjipilpili, miyilkpili, ga yulpili, ga nyani wanngirngili Lutnyi girrgima, ga warrpamnyi Lutang girripili ga yulpili. Girri bapiḻi-kirri nyani djiny wiṉidjinginiban bukmaknyi gurrbiliban. ");
INSERT INTO dji_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ngunukiṉing Abram bi wiṉini bunyirngir, ngunung ngurrḏawalangu Djudumbi inga bir-kirali Abramgi gurrbingir Djudumngir, girri inydji bil birmirrpilidjili nguḻi wayalimirri, ngunukima wayali djin bultjini giriny Djabiy (miri djining yagirri mayali miri ‘Bunggawang Wayali’), ga nyani inga bir-bulanggitjdjini Abramgi nguḻi. ");
INSERT INTO dji_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ga wurpi ngurrḏawalangu Miltjisidik inga bir-kirali Abramgi, ga gurrbi inga Salim. Yarim nyani rum-kanyirakiṉing yul Godang ngunukima Wana Miligidjingirang. Manymak, wali ga nganitji nyani Miltjisidikdji inga birrungili Abramgi miri mundjarrpili inga, girri djiny gungili inga. ");
INSERT INTO dji_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Girri nyani manymak inga wangini Abramgi, inga bindjin, “Marrkapdjidjiban Abram, God inma djamadjigi inma manymakdjigi, ngunung God miri Ngamangamadjnyirakiṉing Miligidji gurrbigi ga giṉimbirrigi. ");
INSERT INTO dji_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ga God Wana inga lim wukdjigi nyanki, ngunukima Miligidji wiḻi djiny galwupiṉi ngunuwiliny mulkurupilngirinyi gumbirrili nyunguli.” Ga Abramdji girripili marrngili, girri 10-bi gaṉḏibi nyani butbutnyirdjiliban nyanngang girripili, girri inga gungiliban Miltjisidikgi wurpmi gaṉḏibi, bil ngunuwili wurpipili 9 gaṉḏibi mala nyani djiny galini miri nyanngangpibi. ");
INSERT INTO dji_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Girri ngunukima ngurrḏawalangu Djudumbi inga wangini Abramgi, “Yarim nyuni irriny gungi ngunuwiliny yulpilngiriny nyuni djiny wanngirngili, bil djinim girripili nyuni galikiban miri nyungungban warrpamnyi nyuni bi djiny wiṉidjingini.” ");
INSERT INTO dji_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Bil Abram inga bumir-wubirdjiliban, “Ngarri ngurrwakng ingarr gungili murr-randinirbi Yawaygi, ngunukima Miligidji Wana Ngamangamadjnyirakiṉing gurrbigi ga giṉimbirrigi, ");
INSERT INTO dji_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","miri wirrpm irr gaypigi nyuninyi girripili nyungung, ingkipm wurpmi muṉḏaṉ u djapatjunggi irr marrgi nyungungir, bintji nyuni wangidjiban, ‘Ngarribipm irr rrupiyagiṉdjili Abramnyi.’ ");
INSERT INTO dji_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Yarim wirrban ngirrki. Bil nyim malany ngirrang yulpilingir djin djingiringili bunyirbimirri, yuwirdjingpili djanki nyuni djina galbungi gumbirrmirri djanngar. Ban djanngangi, miri ngunukima yulmirrpili wirapilingir irriny djin ṉamkaṯdjingini, ngunuwiltji yulmirrpili Anir, Yitjkul, ga Mamri, gaṉḏi-girripili nyuni djiny gupirr-gungban, inydji ildji rarri-gaypigiban djinim girri mala.” ");
INSERT INTO dji_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Djamingi wurpilim malirdji nyani Abram ngurrinyi ṉambiḏi wiṉiṉmirri. Ga nyani mabugidjini. Ga Yaway inga wanginban Abramgi ngungirapi mabugibi, nyani inga bindjin, “Abram, yawnginyirring nyuni! Ngarribipm rirrang inmanydjirr galbungi miri nyungung gulurrurru; ga bayarra inma wanadjidji mirrpmi.” ");
INSERT INTO dji_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Bil Abramdji bumir-wubirdjili, “Garray Yaway, nyimpi ngirrki nyungung mundjarr mala? Yarim ngarri yidjipilinyirring irr nyini girimipmban. Bilang irr wirrdjidji, ngunukima yul Yiliyitja ngirrang ḏapmiynyirbi djamagiṉing ngungirapibi gurrbibi Damaskusbi nyaniban djiny galiki warrpam irra miri girripili ga djamagiṉpili. ");
INSERT INTO dji_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Miri bilapilang gima wirrpm walkiripm nyuni irriny guw giriw, marrga ngunukima ḏapmiynyirbi yul ngarri marrngili djamadjnyirgi nyani gatj nyinidji bubalikiṉing mala ngirrangi, miri nginbilang rum inbila bultjinmi.” ");
INSERT INTO dji_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Girri nyani Yaway yan inga bumir-gaypili, “Ingki ngunung yul marrgi bubalikiṉing mala nyungungi; bil birralkima nyungungpibi walkiripm nyanngarki gatj nyinidji bubalikiṉing mala bulanggitj nyungungi.” ");
INSERT INTO dji_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Ga Goddji nyaniny walmirdjinginban wiṉiṉngir, ga inga bindjin, “Gurrknyaw ṉamili, ga manyaw butjurrudjigiban gata mala. Miri bilapilang miri mala-punyirbi nyungupibi djani djin galbidjidji miri ngunung ngurrgima mala ṉammirri.” ");
INSERT INTO dji_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Girri Abram marr-yirrimkiṉdjiniban ga inganydji marr-yirrpiniban Yawayli. Marrga gima ngungirapibi marr-yirrimkiṉdjnyirbi nyani Yawaydji nguy inga garrkuḻukdjili Abramnyi marrga nyani djuburr djunupa yul milbimirri Godar. ");
INSERT INTO dji_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ga madjirri God inga wangini inga bindjin, “Ngarri djining God Yaway, ga ngarri nyirr walmirdjingini ngunungir gurrbingir Wurngir, ngunung Kaldiyang malang djawal, marrga djingiriny djawal Kanan nyirr gungi, ga nyuni galikiban bintji giri ngurrgima.” ");
INSERT INTO dji_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Bil Abramdji butjalmini, “Garray Yaway, nyaliki ngarri marnggidjidji miri djinimkima djawal irr gatjigi?” ");
INSERT INTO dji_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Ga nyani inga bindjin Abramgi, “Ngarri djinipan rum inma yirrpigi marrga guyumban djining murr-randinirbi inmanydji birraldjnyirdjigi nyungki. Nyuni bidjny gangban ngirrali djingiriny malany gam': wurpm buluki miyilk, wurpm nanikut, ga wurpm bimbi yul; djiniwiliny nyuni djiny marrgi yarim warrngguwili guṉmalgiṉing maypalpili. Ga madjirri bi biliny gangi waykiṉingmirrpiliny, miri wurpmi mukumbuḻ ga wurpmi mukandi yuwirdjing.” Girri ngunukima mabugi inydji malimdjili, ga nyani Abram binygadjiniban. ");
INSERT INTO dji_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Manymak, ngunuwiliny maypalpilngiriny Abramdji djiny marrngiliban, girri djiny djarngili baṉimi, miri wirrbi wurpmi ga wirrbi wurpmi. Girri ngunupili wirrbimirrpili nyani biliny galwupiṉi biribiri munatjamirri, miri bingilidji muṉḏaṉdji Abramdji biliny marrngili. Bil ingki nyani biliny djarinyir ngunukima waykiṉingmirrpili, yarim biribiri biliny galwupiṉi munatjamirri. ");
INSERT INTO dji_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Girri nyani marrkany kiriny, ga ngunubilang galminyir waykiṉing biliny ḏirradjnyiri miri gurrtjirtjir u damili u bilapilang, Abramdji djiny badji-nyangiṉiban djiniwiliny maypalngir. ");
INSERT INTO dji_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Djampan djini-guyum waḻirr mungan inydji yirrpini kiriny, nyani Goddji gungili Abramnyi mabugi, girri nyani Abram yawngini ga wurrwurrdjny kiriny. ");
INSERT INTO dji_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ga God inga wangini mabugibi, “Ngarri nyirr butjirgiṉdjigiban nyim inydji birraldjnyirdjigi djamingi. Nyungung mala-punyirbi djani djawalili wurpili djin giri mulkurupilingirang, ga nguḻi ngunuwiltji mulkurupilingir djiny djin ḏapmiygi nyungung malany, ga djiny djin ḏimbitjnyirdjigi marrga djama maṯiṯ djina djin gungban. Bilapilang miri wanadji maridji djiny bargi bilakiṉing 400 guṉmal ga rarranydjarr djina bangirigi. ");
INSERT INTO dji_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Bil rirringir ngunungir-kirri, ngarri djiny irr yaṯi-wubirdjigi ngungiriny mari-djamagiṉing malany, ngunuwili yulpili wirapiligi nyungung mala-punyirbi djina djin djamadjigi, gunyambipili djinarr gilibigi. Ga rirringir ngunungir-kirri nyungung mala-punyirbi djin yulgungban ngunungir djawalngir, ga girripili galbi minydjin miniban djanngar, yarim rrupiya galbingakiṉing mala miri, ga djin wiṉidji bapiḻipm. ");
INSERT INTO dji_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","16","Ngiy, guṉmalpili ga rarranydjarrpili miri bingili ga bingili muṉḏaṉ djin bangirigi, ga rirringir ngunungir-kirri djani bapiḻi bi djin wiṉidjiban nyungung mala-punyirbi, gima bilapilakiṉing bildjirri djinim Amurayit bapurrurr djin mirgidjidji mirrpmban, marrga ngunukiṉingban ngarri djiny irr malimdjigi djiniwiliny Amurayit yulpilngiriny marrga djani nyungung mala-punyirbili biḻamirri djina djin djamigi ngungirki Amurayit malagi. Bil nyungungi, nyuni mirrpmi bir-gaypingdjidji magayagiṉing ga marrkapgiṉing, girri nyuni wirrdjidji ga nyungung gurruṯigiṉpilingir nyin djin djalirgiban.” Bilapilang Yaway inga bindjin wangin Abramgi mabugibi. ");
INSERT INTO dji_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Manymak, waḻirr mungan inydji yirrpiniban, girri gar-malirdjiniban, ga Abram gurrpini kiriny buḻkiny kiriny. Girri Abramdji yakirr-nyangiṉiban, miri djunggi ngirimbiygiṉing ga ngirrtjnyakiṉing burrtjirrinyi biling bil birraldjiniban, girri bil yilitjiniban baṉimmirrpm muṉḏaṉmirrpm ngunupili maypal wirrbi muṉḏaṉmirrpili. ");
INSERT INTO dji_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Miri bilapilang Goddji rum inga yirrpini Abramgi, marrga djining murr-randinirbi nyanngapibi Yawaybi nyani inydji birraldjnyirdjigi guyumpiligi. Ga djining ngunukima murr-randinirbi: nyani Yaway inga wangini Abramgi, “Nyunguli mala-punyirbili ngarri djiny irr gungi djingiriny djawal, ngunungir maningir Yidjipt-ang ngunyili manili wanali, ngunukima mani djin bultjin girim Yupratis. ");
INSERT INTO dji_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","21","Miri nyungung mala-punyirbi biḻamirri djina djin djamigi djiniwiliki bapurrurrgi, gam': Kinayit, Kinitjayit, Kadmunayit, Yitayit, Piritjayit, Ripayit, Amurayit, Kananayit, Girgatjayit, ga Djibutjayit, ga bilapilang; djiniwilang malang gurrbipili ngarri djinarr gungi mala-punyirbigi nyungungirgi.” ");
INSERT INTO dji_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","3","Rirringir Abram nyininy giriny nguḻikima Kana djawalmirri 10 guṉmal ga rarranydjarr, nyanngang nyanimngim Saraydji nyani wirrpm inga miniginyir yidjipili Abramang, biḏakipm. Bil nyani Saraydji gatjini wurpmi ḏapmiynyirbi djamagiṉing miyilk yagirri Yagar, yarim ngunukima miyilk miri ngungirapibi gurrbibi Yidjipt-bi. Marrga Saray inga wangini Abramgi, “Miri nyani Yawaydji yidjipiliny mirrbilali ngirrangir. Ngunukima miyilk bilang nyuni marrgiban, yarim ngirrang djamagiṉing miyilknyi, girri waymirri nyanngar nyuni ngurridjiban. Ga djinimirri bilangi, ngarriban yidjipiliny inmarr birraldjnyirdjigi nyanngamirrpmi.” Ga Abram yitjidjiniban. Bilapilang nyani Saraydji inga gungili Abrayamgi nyanngang ḏapmiynyirbi djamagiṉing miyilk, biṯma nyanimngim inga bil djamagiṉingipm. ");
INSERT INTO dji_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Girri maliri biling Abram ga Yagar bil ngurrinyini wurpilipm, ga nyani yidjipilakiṉdjiniban. Bil ngunukiṉing nyani djakiy inydji marrngini miri murrbiṉdjini gima yidjipiliny miniginy kiriny, nyani mil-ḏinytjnyi Saraynyi, yarim milbimirri nyanngar ngunukima Saray ngaminydjiniban. ");
INSERT INTO dji_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Girri nyani Saray mirrpm inga maḏakarritjdjini ga inga bindjin Abramgi, “Djining mil-ḏinytjnyirbi irriny barngili gima nyungupibi! Ngarribipm inmarr galwupim ngunukima miyilk nyungur waymirri, bil ngunukiṉing nyani djiringinmi miri nyani yidjipilikiṉdjirri, ngunungir yipi nyani irriny burrdji ngurrgum girim, ga nyani irriny ging girim biṯma ngarri ngaminyi miyilk! Nyani Yaway miri ngiltjang rum-yirrpinakiṉing marrga nyani iltjny gingidji ngunubilang ngarri mirkng u ngunubilang nyunikima! ");
INSERT INTO dji_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Girri Abram inga bumir-wubirdjili, inga bindjin, “Ngunukima djamagiṉing miyilk nyani gumbirrmirri nyungur, nyuni yaṯi-wubirdjigiban nyaninyi nyalikidjidji nyuni djalngdjidji.” Girri nyani Saraydji galngi-bilwirtjili ga marr-mirgidjnyirdjili Yagarnyi, marrga nyani minydji ṉunydjirraliban. ");
INSERT INTO dji_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Manymak, nyani Yagar manydjini, girri Yawaydji munatjali yanili wurpm wugiḻi djangunygiṉing, marrga nyani birraldjnyirdjigi Yagarnyi. Ga ngungiriny miyilk nyani birraldjnyirdjili yirrpimirri, ngidjirrkng ngambuḻ gapi munganmirri gadjigirring, ngunung gadjigarr ngunyili ṉunydjirrim girim gurrbili Djur-li. ");
INSERT INTO dji_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Girri nyani butjalmini, “Way Yagar djamagiṉing Sarayang, nyalingir nyuni girali ga nyanydjili nyuni girimban?” Ga Yagar bumir-wubirdjili, “Ngarri nyanngangir ṉunydjirrali Sarayngir ngirrang bunggawangir.” ");
INSERT INTO dji_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Bil ngunukima wugiḻi Yawayang inga bindjin, “Ingki, bi wiṉiyban nyunguli bunggawali, ga ngunubilang maridji nyin bargi, nyuni bumiripm inydji galbungi ga nyuni guṉgi-djumiḻidjidji gunyambigi, ");
INSERT INTO dji_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","gima mala-punyirbi nyani Yawaydji nyin gungi galbi mirrpmi, ga ingki wiḻi ngunupilang djiny butjurrudjigi gima galbikima.” ");
INSERT INTO dji_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ga madjirri inga bindjin ngunukima wugiḻi, “Nyuni yidjipilakiṉdjirri, ga guyumban nyani miḻimiti bungtjigi, ga nyuni yagirri yirrpigi ngunukima Yitjmayil.” (Miri djining yagirri mayali miri ‘Goddji marrngini’.) Ga nyani gurrpini wangin inga, “Yarim djining yagirri Yitjmayil nyuni yirrpigi, gima nyani Yawaydji nyin marrngini bimbi nyungupibi wargugudjnyirbi. ");
INSERT INTO dji_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Bil ngunukima yul Yitjmayil nyani nyinidji giri miri budjirr-wayirrigiṉing miri nganaparra. Yarim bubalikiṉingirgi nyani mari djina djamadji giri, marrga djanitja mari inga djamadjigi girri. Ga nyani rarrmaḻipm nyinidji giri, ga nyanngangipm malagi nyani djina nguy-margiṉdjidji.” Inga bindjin ngunung wugiḻi Yagargi. ");
INSERT INTO dji_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Miri bilapilang nguṉitjini wugiḻir bi gangili djanguny nyanngapibi Yawaybi. Ga ngunukima miyilk Yagar nyani bultjidjini Yawaynyi djining yagirri miri ‘Nyuni djining God wiḻi irriny nyangini’, gima nyanibi inydji wangini, “Ngarribi birralkima Godnyi irr nyangiṉi, ngunukima Miligidji wiḻi irriny nyangiṉi!” ");
INSERT INTO dji_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Marrga ngunukima ngambuḻ gapi djin bultjini giriny ‘Ngambuḻ gapi nyanngang Wanngidjnyirakiṉingirang wiḻi irriny nyangiṉi’. Ga ngunung ngambuḻ gapi dja'djarripmban, ngidjirrkng djinipili gurrbimirrpili Kaditj ga Birid bil baṉimi. ");
INSERT INTO dji_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Bilapilang miri nyani Yagardji minali yidjipili Abramang, ga ngunukiṉing nyani bungtjili, Abramdji ngunung yagirri yirrpini Yitjmayil. ");
INSERT INTO dji_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ga Abramdji ngurrum gatjidjini 86 guṉmal ga rarranydjarr ngunukiṉing Yitjmayil bungtjili nyanngapibi Yagarbi ngunung ḏapmiynyirbi miyilk Sarayang. ");
INSERT INTO dji_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ngunukiṉing Abramdji gatjidjini 99 guṉmal ga rarranydjarr, Yaway inganydji mil-ḻirrpiniban Abramgi, ga inga bindjin, “Ngarri djining God Ganydjirrgiṉing Mirrpmi. Ngirrang rum nyuni yaṯi-nyangi, ga rum-mirginyirring djirriyi. ");
INSERT INTO dji_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ngarri inmarr gungi murr-randinirbi nyungki ngiḏawa, ga galbi mirrpm nyuni mala-pungi gima ngirrapibi.” ");
INSERT INTO dji_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Girri Abram inydji nguli munatjali girri ngurri munatjapm ngurrinyban bilakiṉing God inga wanginy kiriny. ");
INSERT INTO dji_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Girri God bindjin wangin inga, “Djiniwili ngarri nyirr murr-raniban, gam': nyuni djina djirridji miri guṉgi-biligaping djina galbigi bapurrurrgi. ");
INSERT INTO dji_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ga yuwirdjing yagirri ngarri nyirr gungban, marrga ingki madjirri nyin djin bultjigi Abram, bil djiningir yipi nyin djin bultjigi Abrayam, gima djining yagirri mayali miri ‘Gunydjirri djina galbigi bapurrurrgi’. ");
INSERT INTO dji_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ga ngarri inmarr gungi galbi walgurwalgur, ga galbi yuwirdjing bapurrurrpili djiny irr ngamangamadjigi nyungupibi, ga wanapili ngurrḏawalangupili djani inydjin ngurri nyungupibi. ");
INSERT INTO dji_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Ga djining murr-randinirbi djirridji inydji mungbinigi, miri nyungki ga djanki nyungung mala-punyirbi wirapili djin birraldjidji djadjuḏitj. Djining murr-randinirbi ildja djirridji bintji giri ngurrgima, miri ngarri djining God Miligidji, nyungung ga djanngang nyungung mala-punyirbingirang. ");
INSERT INTO dji_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Yarim miri bilapilang nyuni nyini kirim djiḻi gurrbimirri Kanan miri mulkuru nyuni, bil ngarri djining nyirr gungi gurrbi Kanan nyungungi marrga nyuni mala-pungi, miri djining djawal nyibirri nyuni nyininy giriny gurrbinyirring, ga nyungung mala-punyirbidji djin galiki djingiriny djawal bintji giri ngurrgima. Ga djanngangi, ngarri djining God Miligidji djinarri.” Bilapilang nyani Goddji murr-rangirri Abrayamnyi. ");
INSERT INTO dji_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Girri God inga wangini, “Bil nyungungi, djinipan nyungung djama: nyuni rum-katjigi ngirrang, miri nyuni ga nyungung walgurwalgurdji wirapili djin birraldjidji djamingi, bintji giri ngurrgima ngildji rum irraldji gatji giri ngunyili yipi. ");
INSERT INTO dji_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ga djinipan ngunukima rum inmarr yirrpigi: bukmaknyi yulpilngiriny nyuni gurrmildjigi. Bilapilang ngarri inmarr gungi djingiriny rum, ga djining rum nyuni gatjigiban. ");
INSERT INTO dji_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Yarim nyuni bupiḏidjigi, miri bilapilang nyuni yirrpigi gurrmildjnyirbi djangunygiṉing galngili, marrga nguṉi gurrmildjnyirbi irriny guṉgigiṉdjigi ngirrang murr-randinirbi, bilapilang ngunukima gurrmildjnyirbi murr-randinirbingirang dji'djirridji nyungki ga ngirrki. ");
INSERT INTO dji_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","13","Yarim rirringir gurrulk yul bungtjigi yuwirdjing, nyuni marrkang bilakiṉing 8 yakirripili djin bangirigi, girri ngunukima gurrulk nyuni bupiḏidjigiban. Miri djining rum djina djirridji inydji mungbinigi gurruṯigiṉingirgi nyungungirgi. Yarim warrpamnyi yulpilngiriny nyuni djiny gurrmildjigi, miri nyungung mala-punyirbi, ga bubalikiṉing ḏapmiynyirbi djamagiṉing wirapili djin bungtjili gurrbimirri nyungur, ga bubalikiṉing ḏapmiynyirbi yul nyuni djiny bayimdjili mulkurupilingir, bukmaknyi nyuni djiny gurrmildjigi. Miri bilapilang ngirrang rum yulgi, gurrulkgi ga wanagi, ga ngunukima rum ngarri inmarr yirrpigiban ga ngildji ildji gatji giri ildji bintji giri ngurrgima. ");
INSERT INTO dji_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Bil ngunubilang wari ngunupilang yul djunggaḻdjidji, marrga ingki gurrmildjnyiri, girri ngunukima yul nyuni butnyirdjigi gurruṯigiṉngiri girri bungban, gima ngirrang rum nyani wubirdjili.” Bilapilang God inga wangini Abrayamgi. ");
INSERT INTO dji_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Girri God madjirri inga wangini Abrayamgi, inga bindjin, “Nyanngangi Saraygi, ingki madjirri nyuni yagirri bultjigi inga miri Saray, gima ngarri yagirri inga yirrpigiban miri Sara. ");
INSERT INTO dji_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ga ngarri nyaniny irr djakadjigi Sarany, ga nyirr gungi walkiringimi nyanngamirrpmi, ga ngunukima yidjipili irr djakadjigi girri. Ngiy, budjirribi Sarabi ngurrḏawalangupili ga bapurrurrpili inydjin ngurri.” ");
INSERT INTO dji_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ga madjirri Abrayam inydji nguli munatjali girri ngurri-munatjapm ngurrinyi, girri djal-gitgitdjili bilakiṉing bindjin gingin, “Ingang! Nyaliki yidjipili irra bungtjigi? Ngarri ngurrumi 100 guṉmal! Ga nyani Sara ngurrum gatjidjini 90 guṉmal, nyaliki marrga nyani irra mini yidjipili?” ");
INSERT INTO dji_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Girri Abrayam inga wangini Godgi, “Ngunubilang nyuni djalngdjirri, ngirrang yidjipili Yitjmayil nyuni yitjidjidji marrga nyanngamirrpmi nyuni mala-pungi.” ");
INSERT INTO dji_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Bil God bumir-wubirdjili, “Ingki. Bil yirrimi nyungung nyanimngim Saradji nyani inma mini yidjipili, ga nyuni yagirri yirrpigi ngunukima Yisak. Ga ngarri yan irr gatjigi nyanki girri, yarim ngirrang murr-randinirbi djirridji nyanki ga nyanngang mala-punyirbigi, bintji giri ngurrgima. ");
INSERT INTO dji_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ga djining wurpi: ngarri nyirr marrngini ngunukiṉing nyuni irriny butjalmini nyanki Yitjmayilgi, marrga nyaniny irr gumbirrgiṉdjigi girri. Nyani girri mala-pungi galbi, ga nyanngapibi galngibi 12 ngurrḏawalangupili djin birraldjidji, ga nyanngapibi irr ngamangamadjigi bapurrurr wana. ");
INSERT INTO dji_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Bil nyankigima Yisakgi ngarri ingarr gungili ngirrang murr-randinirbi ga nyanki ngirrang yan ingarr gatjigi munguy, ga ngunukima yidjipili Yisak nyani bungtjigi bilapilakiṉing bildjirri rirringir wurpi guṉmal ga rarranydjarr bangirigi.” ");
INSERT INTO dji_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Girri rirringir nyani God guḻdjili wanginyirngir inga, nyani manydjiniban. ");
INSERT INTO dji_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Girri Abrayamdji marrngiliban walkiringim Yitjmayil, girri gurrmildjiliban ngunung ngurrgima maṉngibirri. Ga nyani djiny marrngili bukmaknyi ḏapminyirbipili yulpili mala nyanngangi, ngunuwiliny miri djin bungtjili nyanngar gurrbimirri ga ngunuwiliny miri nyani djiny bayimdjili, girri djiniwiltji girri nyani djiny gurrmildjiliban, yarim miri God inga bultjidjini. ");
INSERT INTO dji_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Yarim Abrayam miri nyani gatjidjini 99 guṉmal ngunukiṉing nyani gurrmildjini, ");
INSERT INTO dji_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","ga nyani Yitjmayil gatjidjini 13 guṉmal ngunukiṉing bildjirri. ");
INSERT INTO dji_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","27","Miri bilapilang, maṉngi wurpmi djani warrpam djin gurrmildjini, miri Abrayam, nyanngang walkiringimi Yitjmayil, ga bubalikiṉing ḏapmiynyirbi yulpili mala, wurpilipmban djin gurrmildjiniban. ");
INSERT INTO dji_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Guyumban nyani Yaway inganydji mil-ḻirrpini Abrayamgi madjirridji. Yarimban Abrayamang wiṉiṉ dja'djarriny ngidjirrkng gurrtjimirri, ngunukima yulang gurrtjipili Mamri'ang. Ga malir-gunyirri nyani Abrayam nyi'nyininy rarrimirri wiṉiṉmirri, yarim maṉngibirri murmurdjny kirinyban, girri Yaway inganydji mil-ḻirrpiniban. ");
INSERT INTO dji_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ga nyani Abrayam ṉamili milingili, girri djiny nyangiṉiban yulmirrpili mulkurumirrpili inga djin djarrinyi ngidjirrkngi, warrngguwilipm. Ga ngunukiṉing djiny nyangiṉi ngunukima mulkurumirrpili, Abrayam inydji waykungili, girri ngunyili djina bir-kirali. Nyani djina yulgungili, girri gupildjini munatjali, ");
INSERT INTO dji_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","ga djina wanginiban bunggawagi inga bindjin, “Bunggawa, djinipan ngarri nyirr butjalmidji: ingkipmban irriny bumir-bangirigi, ngarri djiningi djakagiṉing inma, inmarr bir-bulanggitjdjidji. ");
INSERT INTO dji_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Nyiniyi yalkuy, ga ngarri gapi irr marrgiban ṉinini, girri ṉu inydji ildji rurrtjirrmigi, ga gaṉḏi inydji ildji galiki djiḻi bumalngmirri. ");
INSERT INTO dji_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ga wurpi irr marrgi, dampa marri ṉinini, marrga ildji ḏirradjigi girri ildji ḻaydjigiban, ga ngunungir-kirri manymakban minydji ildji giriban djutjdjutj. Ngarri marrkapdjili miri ngildji irriny ildji baḻparngili gima ngarri djamagiṉing ngildjang irri,” bindjin Abrayam. Ga djani djin bumir-wubirdjili, “Ngiy buṯal, miri nyalikidjini nyuni inbila wangin, nyuni nginbilikiban djakadjigi.” ");
INSERT INTO dji_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Manymak, nyani Abrayam ṉunydjirrali wiṉiṉili, ga inga witjili Saragi, “Giḏagiḏapm ṉunydjirriw, dampa marriw warrngguwili garrung, yarim mirrpm manymak dampa. Girri ḏutjigi ga batjigi dampa mala.” ");
INSERT INTO dji_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Ngunungir-kirri nyani gurriyilili ṉunydjirrali ngunyilipm bulukili malali, girri rindilaliban wurpmi yuwirdjing ḻatju ḏirradjnyirbi. Nyani gumbirrdji gatjidjini, gangili, girri gungiliban yawirrinynyi ngunung djamagiṉing inga. Ga ngunukima yawirrinydji bipiṉi, djaringili ganydjirrdjipm, girri maypal batjidjiniban. ");
INSERT INTO dji_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Girri madjirri nyani Abrayam ṉunydjirrali, ga ngaman marrngiliban nanikutbi. Manymak, nyani gurtjili bubalikiṉing, girri djina gangiliban mulkurupilingirgi djiningi, miri dampa, buluki djanggu, ga ngaman. Nyani birrungili, galwupiṉi munatjali birbimirri mulkurupilingirgi. Ga djani djin ḏirradj nyininya-a-a, ga nyani dja'djarrinyi ngidjirrkngi munganmirri djunggimirri. ");
INSERT INTO dji_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Djin ḏirradjili, girri djin butjalminiban, “Nyaling Sara, nyungung nyanimigi?” Ga Abrayam bindjin, “Ṉambiḏipm wiṉiṉmirri nyi'nyini.” ");
INSERT INTO dji_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Girri wurpmi mulkuru bindjini, “Nyani Sara gapaḻmirrpilidjidji, ga guyumi ngunukiṉing ngarri inmarr wiṉidji bapiḻipm, nyani Sara djilidjigiban yidjipili yul nyangangpibi,” bindjini. Ga ngunukima miyilk butjir-marnggiban gima nyi'nyininy nguḻikirri rarrimirri wiṉiṉmirri, yarim burrimirri Abrayamar ngidjirrkngipm. ");
INSERT INTO dji_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Bilapilang miri biling Abrayam ga Sara bil wurrungdjiniban, miri galbi guṉmal ga rarranydjarr bil gatjidjini, marrga nyani Sara yirrmirringdjini, miri wirrban yidjipiligi mini, gima ngurrum wulgaman, bilapilang. ");
INSERT INTO dji_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Marrga Sara nguy inydji gitgitdjili, gima nyani gingini miri, “Nyaliki yidjipili irr marrgi, gima ngarri yirrmirringban, ga ngirrang nginipingim yirrmirring girri; nyalikiban irr ṉitjanydjidji yidjipiligi?” ");
INSERT INTO dji_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Bil nyani Yaway inga wanginban Abrayamgi, “Nyimki Sara gitgitdjili, ga djining wangini miri, ‘Bina djining birralkima djanguny, miri ngarri yidjipilikiṉdjidji? Yarim wulgamanban irri.’ ");
INSERT INTO dji_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Bina djining djama maṯiṯipm Yawaygi? Birralkima, guyum irr wiṉidji ga nyimila yulgungi, ngunukiṉingban nyanngang miḻimiṯi bungtjigi Sarang!” bindjin Yaway. ");
INSERT INTO dji_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Bil nyani Sara ingki-pultjiniban, nyani bindjin, “Ingki irr gitgitdjnyir,” gima nyani mirrpm inga yawngini. Bil nyani Yaway bumir-wubirdjili, “Ingki, birralkima nyuni gitgitdjiliban.” ");
INSERT INTO dji_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Manymak, ngunukima mulkurumirrpili inydjin waykungili, inydjin birrindjingini bumiri Djudumili gurrbili, girri ḻarrban. Ga nyani Abrayam yalkuy djina maltjili gima mayaligiṉing nyani. ");
INSERT INTO dji_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Giḻiwiḻim djin giriny nyininya-a-a, girri nyani Yawaydji ginginy kiriny Abrayamnyi, miri bindjin ginginy, “Bina djanguny ingarr gilgirrgi Abrayamgi, bil marri ingarr bultjigi miri nyaliki mari irr djamadjigi djini-guyum? ");
INSERT INTO dji_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ngidjirrkngban nyani mala-pungi, ga nyanngang gurruṯigiṉing mala mirrpmi djin galbidjidji, yarim yagirri wana bapurrurr minydjin djirridji, ga bukmak bapurrurr mala djiḻi gurrbi-munganmirri djani inydjin bulanggitjnyirdjigi nyanngamirrpmi Abrayam-mirrpmi. ");
INSERT INTO dji_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Ngiy, nyaninyi irr butjirigiṉdjigiban gima djinikima yul irr rindiligim marrga nyani djiny marnggidjigi yidjipilpili nyanngang, marrga ngirrang rum djin gatj nyinidji, miri djunapapm djin giri nyinidji ga djuburr garray djin gurrpigi birraldjipm. Marrga ngarri Yaway ingarr birraldjnyirdjigi Abrayamgi ngunukima murr-randinirbi mala ingarr bultjinmi bilimi.” Bilapilang miri Yawaydji guṉgili ginginyi Abrayamnyi. ");
INSERT INTO dji_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Ngunungir-kirri Yaway inga wanginiban Abrayamgi, nyani bindjin, “Bilngirang miri ngunupili gurrbimirrpili Djudumgi ga Gumurragi, mirikunudji djangunydji irr marrngirriny giriny munguypmi, yarim galbi mala djin nguy-murmurdjiliban, gima ngunukima yulpili Djudum ga Gumururramimigi djani mirrpmi djin mirgidjiniban. ");
INSERT INTO dji_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Marrga ngarri djirrdjirrdjigiban ngunyilipm ga birrkadjigi, marrga irr nyangban ngunubilang birralkima ngunung mirikunu djangunypili irr marrngirriny giriny. Marri ingki birral, marri birral, miri djani ngaminypili yul mala; ngarribipm birrkadjigiban marrga irr marnggidjidji birralgi,” bindjin Yaway. ");
INSERT INTO dji_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Manymak, ngunupili Yawayang djamagiṉingmirrpili biling bil ngurrgiḻidjini ngunyilipm Djudumili, ban nyani Yaway guḻdjili ga djarrinyini birbimirri Abrayamar. ");
INSERT INTO dji_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Girri nyani Abrayam ngidjirrgili girali ga inga bindjiniban, “Bina nyuni bilngiriny malimdjigi ga buwayaknyirdjigi ngunung bingili mala giḏidjirrim, miri djuburr manymak mala ga djuburr mirkngi mala? ");
INSERT INTO dji_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Bilang nguḻikima miri 50 mirginyirring yulpili nyi'nyini ṉambiḏi ngunung gurrbimirri, bina nyuni malimdjigipmban ngunung gurrbi? Miri ngunubilang 50 murgunyirbi-nyirring yulpili nyi'nyini nguḻi, nyuni gubidjiban djanki, ngangi? ");
INSERT INTO dji_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Buṯaltja ngunung mayali nyuni marrbigiban, gubidjiban bintji manymakpili ga mirgipili biling giḏidjirrim bil balidji. Djining mirikunu miri nyuni bilngiriny bungi mirkng mala ga manymak mala wurpilipmi. Nyuni inydji rum-ngurrgiwban! Miri nyuni djining nginbilang rum-yirrpinakiṉing bubalikiṉingirgi bapurrurrgi djiḻi gurrbi-munganmirri nyi'nyini, marrga nyuni yirrimban rum djunupa djina gatjigi djanki, ngangi?” bindjin wangin inga Abrayam. ");
INSERT INTO dji_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Ga nyani Yaway bumir-wubirdjili, inga bindjin, “Ngunubilang ngarri birraldjnyirdjigi yarim 50 mirginyirring yulpili nguḻikima Djudum gurrbiwi, bilang ingkipm wurpmi irr bungi nguḻikima, bukmak yul mala djiny irr wanngirgi balinyirbingir gima ngungirapibi djuburr manymakpilingirbi.” ");
INSERT INTO dji_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Girri madjirri nyani Abrayam inga wangin, bindjini, “Djining ngarri inmarr djarri miri mayalinyirring yul, yarim ngaminyi irri miri midjirri ga girrabili; bil madjirriban nyirr butjalmidji, Garray. ");
INSERT INTO dji_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Nyabini bilang 45 djuburr manymak yulpili nyi'nyini nguḻikima, bina nyuni gurrpigi malimdjigi ngunung wana gurrbi Djudum, gima ingki galbipm manymak yulpili nyi'nyiniy giriw nguḻi?” bindjin Abrayam. Ga nyani Garray bumir-wubirdjili, “Ngunubilang 45 manymak yulpili irr birraldjnyirdjigi nguḻi, ingkiban bilang irr burtjildjigi ngunung gurrbi.” ");
INSERT INTO dji_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Bil nyani Abrayamdji bumir-ḏuwaṯ butjalmini, miri inga bindjinban, “Nyabini bilang 40 manymakpili nyuni birraldjnyirdjigi nguḻi?” Ga nyani Garray inga bumir-wubirdjili, “Bilang 40-kima, ngarri ingkipm bungban Djudum-mimigi.” ");
INSERT INTO dji_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ga nyani Abrayam inga bindjin, “Biḏak Garray, nyuni marr inydji galbungi ga ngarri giri djutjdjutj. Nyabini bilang yarim 30 manymakpili nyuni birraldjnyirdjigi nguḻi?” Bil nyani bumir-wubirdjili Abrayamgi, “Ingkiban ngarri gurrbi malimdjigi ngunubilang nguḻi irr manyangi yarimipm 30 manymakpili.” ");
INSERT INTO dji_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Bil nyani Abrayam bumir-ḏuwaṯ bu'butjalminyi, ga inga bindjini, “Miri mayali mirkng yul irri, yarim madjirripm nyirr butjalmidji, Garray. Nyabini bilang yarim 20 nyuni birraldjnyirdjigi?” Bil nyani inga wanginban, “Bilang ingkiban irr midjirrdjigi.” ");
INSERT INTO dji_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ga madjirripm nyani Abrayam gurrpini, bindjin inga wangini, “Ingkiban nyuni irra maḏakarritjdjidji bilang bumir-wurpmi madjirri inmarr wangidji ga girriban. Nyabini bilang galbigima wirrpmi, bil yarimipm 10 manymakpili?” Bil nyani Garray bumir-wubirdjili, “Ngungirki 10-gi ingkipmban irr birrugi burtjildjnyirbi ngunyilipm.” ");
INSERT INTO dji_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Manymak, ngunukiṉing nyani Yaway djingiringili wanginyirngir Abrayamgi, nyaniban minydji giraliban, bil nyani Abrayam bi wiṉiniban gurrbili nyanngali. ");
INSERT INTO dji_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Manymak, ngunukima wugiḻimirrpili Godang biling bil yulgungili Djudum, ngunung ngurrgima maliri. Ga nyani Lut nyi'nyininyi rarrimirri Djudum gurrbiwi. Nyanngali bil girali, ga Lut biliny nyangiṉiban inga bil yulgungi; marrga nyani inydji waykungili ga bilingga bir-bulanggitjdjini, ga gupildjini munatjali. ");
INSERT INTO dji_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Girri bilingga bindjin, “Guwa, bunggawamirrpila, nyumi nyim djaypirgi ngunyilipm miri ngirrali bala'li, ga nguḻikima nyim ngurridji djini'djining maliri. Ga ṉu inydjim rurrtjirrmigi, girri yakirriban nyim ngurridji. Ga malir-gunyirri inydjim waykung, girri ḻarrban nyim mukurdjigiban.” Bil biling inga bil wangin, “Ingki. Djiḻipm gar-gurriyili liny ngurridji ngalwirrgimirri.” ");
INSERT INTO dji_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Bil nyani Lut bumir-ḏuwaṯ ga bumir-ḏuwarratj bilngiriny bu'butjalminy kiriny, marrga bil yitjidjiniban ga bil ragiliban bala'li Lutar. Bil nyinini, ga nyani bilingga galngarradjny kiriny, yarim wali bilingga batjidjini dampa, girri bil ḏirradjiliban. ");
INSERT INTO dji_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Bil ngurrwakngi bil ngurrinyir, yul mala ngungirapibi gurrbibi djani inydjin gurrkungili nguḻikima Djudum-mimigi, miri bubalikiṉing yul, miri djalkiṉing, yawirriny ga wanapili, guḻukngi wana ḻiyuw ḏap inga djin garrpini ngunukima bala' Lutang, girri djin djuḏapdjili. ");
INSERT INTO dji_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Girri djin waywaydjili Lutnyi, “Way Lut! Nyaling ngunupili yulmirrpili, ngunung bingili nyin bil baḻparingili djuli? Bapiḻiban bi biliny birruwi nginbiliki, marrga waymirri nibi ngurridji bilngirar, ga bilnyi nibi ḻuḻtjigi yulmirrpiliny.” ");
INSERT INTO dji_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Bil nyani Lut rarri ḻapmiyngili, yulgungili, girri miṉibili rarri, ga nguḻi gar-gurriyili inydjin bir-mirrpilidjili, ngidjirrkng rarrimirri djarrinyi. ");
INSERT INTO dji_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Nyani djina bindjinban, “Way miygiṉpila; ingkiban ildji bintjiban djuburr mirkng ildji gatjigi djinimirri! ");
INSERT INTO dji_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Butjir inydjildji guwi: ngirrang walkiripm, bingili muṉgimirrpili, ingki yulmirri waymirri bil ngurrinyir ngurrwakng yulpilngirar. Nyabini bilang djinipili bilny ildji gangban, ga nyaliki ildji djal ildji bintji ngurrgima bilngiriny. Bil ingkiban ildji gatjigi ngunupili yulmirrpili bilny irr djakadjimi, gima irra bil guṉgi-baltjimban miri bilny irr djakadjigi djiḻi,” bindjin Lut. ");
INSERT INTO dji_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Bil djani inga djin bindjinban, “Burridjipm yilitjirriy!” Ga djanibi inydjin bininy wanginyiban, “Djining yul Lut ingki djingirapibi gurrbibi miri, yarim mulkuru djinikima, ga biligi ngilimi lim yitjidjini miri nyani nginmilar nyinidji giri; bil djini'djining nyani ging kirimi miri nginmiliny raypirridjigi biṯma bunggawadji nginmilang!” Bilapilang miri inga djin gudjirr-mirgidjiniban Lutgi, ga inga bindjin, “Marri ṉinini gunyambi nibi djamadjigi bilinggirki yulmirrpiligi, bil gunyambi wana nyungki!” Ngunungir-kirri djin bumir-baḻparingili Lutnyi ga djin galngi-ngurrginy kirinyban, ga ngidjirrgili djin girali marrga djin wubirdjigi bala' djabiri. ");
INSERT INTO dji_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Bil ngunukirri yulmirrpilim bil ḻapmiyngili djabiri, girri gumbirrdji bil gatjidjini Lutnyi ga ṉambiḏiliban bil djitingili, girri djabiri bil maṯiṯdjili. ");
INSERT INTO dji_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Rirringir ngunungir-kirri djiny bil bipiṉiban baḏayaladji wanadji, ngunuwiliny yul malany gar-gurriyili djin djarrinyi; marrga mil-djumiḻingban djin gu'gukirriny kirinyban, yarimban djin gar-gatjingini giriny djabirigi, bil ingkiban ngunung djin manyaw giriw. ");
INSERT INTO dji_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Manymak, ngunungir-kirri biling wugiḻimirrpilim bil butjalminiban Lutnyi, “Wirapili wurpipili nyungupibi malabi djani nyi'nyiniban djiḻikima? Miri gapirri, walkiri, nyim ngunupilang gurruṯi nyuni djiny butjirgiṉdjigi marrga djin yilitjirridji djiningir gurrbingir; ");
INSERT INTO dji_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","gima ngilinyi djining wana gurrbi djini-guyumban liny burtjildjigi. Miri galbikima gudjirr-mirgidjnyakiṉing mala inga djin witjny giriny Godgi miri nyani yaṯi-wubirdjigi yul mala djingirapibi gurrbibi, gima rum djina mirikunu mirrpmi Djudum-mimigirang. Marrga ngilinyi miri bapiḻi yanginyirbi Yawaybi linyi, marrga djining liny malimdjigiban gurrbi,” inga bil bindjin Lutgi. ");
INSERT INTO dji_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Manymak, ngunung ngurrgima maliri nyani Lut yulgungili bala'ngir ga ṉunydjirraliban bilngali ngunukima gapirriwilingim wiḻi djaming biliny bil marrgi Lutang walkiriwilingim. Nyani bilingga yulgungili, girri biliny butjir-karrdjiniban. Nyani bilingga bindjin, “Binygadjiyi, nyim djirriyi! Nyim ṉunydjirriwban djiningir gurrbingir, nyim gubidjiban giḏagiḏapm, gima nyani Yawaydji djini-guyumban malimdjigi djining gurrbi wana!” Bil biling gapirriwilingim yarim bil nyany ngurrinyban ray-yakirringir, biṯma nyani bilingga wakal marrngili bil ginginy kiriny, marrga rarri inga bil balini. Marrga gumbaḻaban nyani bi wiṉini gurrbili. ");
INSERT INTO dji_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Manymak, milwartjini, ngunukirri wugiḻimirrpili bil bumir-ḏuwarratjny kiriny djina bil bultjini kiriny, “Ṉunydjirriw ṉunydjirriw, bilayiliban nyuni minydjny yilitjiwi nyungung nyanimngim ga walkiriwilingim, bintji nguṉi yaṯi-wubirdjnyirbi ildny wiṉgaḻamiygi marrga ngildji wurpi ildji balidjiban!” ");
INSERT INTO dji_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Bil nyani Lut biḏakipm marrkany kirinyban. Marrga biling wuguḻimirrpilim gumbirrdji djiny bil gatjidjiniban, girri djiny bil guṉdjirr-djitingiliban ngunyilipm gurrpuḻuli; gima nyani Yaway inga mil-yilgidjini Lutgi. ");
INSERT INTO dji_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ga rirringir djin yulgungili gurrbingir, ngunukima wugiḻimirrpili inga bil bindjinban Lutgi, “Ṉunydjirriwban ganydjirrdjipm bintji ngildji balidji! Bapi inydji ildji nyanyirringi, ga ingkiban ildji guḻdjigi bubalikiṉimirri ṉambiḏi gurrpuḻumirri; burriliban bumirili ildji ṉunydjirriw bintji djining yaṯi-wubirdjnyirbi ildjny bangirigi ga ildjny bargi.” ");
INSERT INTO dji_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Bil nyani Lut yan bumir-gaypili, “Ingki, bunggawa! ");
INSERT INTO dji_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Ngurrumi nyuni irriny gunggatjili ga irriny wanngirngili. Bina madjirriban nyuni irra mil-biḻbaḻdjidji? Miri ngarri ingki ganydjarrgiṉing miri irr gatjigi ngunung bumiri mala gima bilay, yarim gunyambi irriny bargi malngiri marrga irr balidjiban. ");
INSERT INTO dji_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Djinim gurrbi ṉinini dja'djarri ngunumi marri bilay, manymaktja irr ṉunydjirriban ngunyilipm gima ngidjirrkngi. Ngunung gurrbi ingki wana bil ṉininikima. Bina buṯal ngunyilipm irr ṉunydjirriban marrga ṉambiḏi minydjirr nyinidji wanngipmban nguḻi?” ");
INSERT INTO dji_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ga ngunukima wugiḻi inga bumir-wubirdjili Lutgi, “Ngiy, djingirki mayaligi ngarri yitjidjnyirbi nyirr gungban; ingkiban marrga irr burtjildjigi ngunukima ṉinini gurrbiwi nyuni irra bultjidjini. ");
INSERT INTO dji_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Bil ṉunydjirriwban ganydjirrdjipmban ngunyilipmi, gima wirrpm irr djirriḻbigi bala'pili yarimipm nyuni nguḻikima yulgungi.” Bilapilang miri djinimirri ngunung ṉinini gurrbi djampan djin bultjini giriny Djuwar, yarim ngunung yagirri mayali miri ‘Ṉinini’. ");
INSERT INTO dji_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Manymak, waḻirr djapi yulguny kiriny nguṉukiṉing nyani Lut rany kiriny ngunyili Djuwarli gurrbili, ga yilimirri djani djin gurrpin kiriny nyanimngim inga ga miḏipiḻi-mirripili. ");
INSERT INTO dji_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Ga bilapilakiṉing djunggi burrtjirriny ga bunggan balinyirakiṉing ga'galminy kirinyban ṉamngiri yanginyirbi Yawaybi, ga baringiliban Djudum ga Gumurra. ");
INSERT INTO dji_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Miri bilapilang Yawaydji djirriḻbili ngunupili gurrbimirrpili, ga nyani malimdjili bubalikiṉing: miri gurrbimimigi, ga warrpam wali djurriginy kiriny gurrpuḻumirri; bukmakban djin wirrdjini nguḻikima wayalimirri, djin manydjiniban. ");
INSERT INTO dji_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Bil ngunukirri miyilk, Lutang nyanimngim yilimirri gurrpini kiriny Lutnyi, nyani murgungiliban; yarim nyani bapi inydji nyangiṉi. Girri ṉamngiri inga galmini rirrkiyanpili miri djalkng rirrkiyan mala djin baringili ngunukima miyilknyi, marrga nyani inydji birrindjinginiban, yarim djalkngdjiniban rirrkiyandjini inydji mungbiningiliban. ");
INSERT INTO dji_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Manymak, ngunung ngurrgima maṉngibirri, maliri-gunyirri, bapiḻi-guwa nyani Abrayam bi ṉunydjirrali wiṉiniban ngunyilipm ngunukima bumiri gurrbi nyibirri nyani dja'djarri nyanngar Yawayngirar gadjiri balnggili. ");
INSERT INTO dji_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Nyani yulgungili bukiḻmirri, girri mildji inydji garrkarrpini gurrbimirrpiligi, bil wirrpm nyanyiri. Ga nyani milingili gurrpuḻumirrpmi, bil wirrpm nya'nyanyiri gurrbi; yarimban ngirimbiy wana burburdjny giriny gima bubalikiṉimirri ngunung wayali bungbuldjny girinyban, miri ngirimbiy ḏuwarrngir wanangir. ");
INSERT INTO dji_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Miri bilapilang, nyani Goddji djirriḻbili ngunupili gurrbimirrpili nyibirri Lut nyininy giriny. Bil nyani gingini Lutnyi marrga nyaniny yilitjili ngunungir gunyambingir, bintji Abrayam marr-mirgidjidji Lutgi; bilapilang God inga mil-yilgidjini Abrayamgi. ");
INSERT INTO dji_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Manymak, rirringir ngunungir-kirri nyani Lut mirrpmban yawnginy giriny nguḻikima gurrbimirri Djuwar nyi'nyininy, marrga ngunungir djin gubini, Lut, ga walkiriwilingim ngunupili muṉgimirrpili, ga djin walminiban bumirili gurrbili; ga nguḻi inydjin yirryirrpini bumirimirri, yarim ṉambiḏi miringmirri djin ngurriny giriny ngiḏawa bilaypilay yulpilingir. ");
INSERT INTO dji_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Manymak, ngunung ngurrwagiping muṉgi inga wangini gaḏiṯingirgim, inga bindjin, “Ngiltjang gunydjirri nyani wurrungdjirr kirimban; ga wirrpmban wurpi yul nyi'nyiniy giriw djiḻikima nginmilar, marrga ingki wari ngunupilang yul waymirri iltja ngurridji ngiltjar; yarim ngunukima miri rum bamanpi miyilkigi ga yulgi, bil ngiltjiki wirrban. ");
INSERT INTO dji_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Ma', gunydjirrgiriny il gu'kung kiri nganitji galbi, marrga nyani babakiṉdjidji. Ngunungir-kirri maliri, waymirri il ngurridji nyanngar miri minitjingimi, marrga il yidjipilikiṉdjidji nyanngapibi gunydjirrgirapibi ngiltjang, marrga djampiligi ngiltjang mala wanngipm minydjin nyinidji bintji ngurrgima.” ");
INSERT INTO dji_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Manymak, maliri rirringir galbikima bil gungili nganitji, ngunukima ngurrwagiping miḏipiḻi ragiliban nyanngali gunydjirrngiralipm, girri bil ngurrinyban. Bil nyani Lut wawu ngurrinyi gima ingki ginginyir nganitjiri, yarim ingkiban djiringinir ngunukiṉing ngunung muṉgi djundjini ga inydji waykungili djamingi. ");
INSERT INTO dji_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Milwartjini, ngunung ngurrwagiping miḏipiḻi inga wanginiban gaḏiṯingirgim, “Gu, gadjiri maliri ngarribipm ngurriban gunydjirrgirar; ban djini'djining maliri madjirri girri nganitji il gu'kung kiri, girri nyunitjaban ragi ga ngurridjiban nyanngar, marrga il mala-pungi bintji ngiltjang gurruṯigiṉing gadjigarr guḻdjigi.” ");
INSERT INTO dji_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Marrga djamingi, rirringir nyaniny bil gungili nganitji galbi, ngunukima djuḏitjping gaḏingimi ragiliban, girri bil ngurrinyban; ga madjirri nyani Lut ingki djiringinir miri ngunukima miḏipiḻi ngu'ngurriny kiriny nyanngar, yarimban Lut wawu ngurriny kiriny. ");
INSERT INTO dji_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Marrga gima ngungirapibi biling wawayka, Lutang walkiriwilingim miḏipiḻimirrpili bil yidjipilikiṉdjiniban, gunydjirrgirangipm bilngirang. ");
INSERT INTO dji_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ga ngunung gaḻitjirringirangpibi yidjipili yul bungtjili, ga ngunukima nyani yagirri yirrpini Muwap (Moab); ga djamingi ngunukima yul nyani ngurrḏawalangu djina Mawabayit malagi. ");
INSERT INTO dji_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ga nguṉi mirrdjingir miyilkdji marrngili yidjipili yul girri, ga nyani yagirri yirrpini Bin-Amiy; ga ngunukima yul nyani ngurrḏawalangu djina Amunayit malagi. ");
INSERT INTO dji_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Rirringir Goddji malimdjili ngunukima gurrbimirrpili Djudum ga Gumurra, nyani Abrayam minydji giraliban ngunungir gurrbingir, ga ngunyilipm girali Nigipili djawalili bumir-djalatjangili. Ga djani inydjin yirryirrpini ngidjirrkng gurrbimirrpili Kaditj ga Djur, miri Abrayam, Sara, Abrayamang yidjipili Yitjmayil, ga bilngirang djamagiṉpili, ga maypal mala, bilapilang. Ga guyumi djin yilitjini wurpili gurrbili, ngunukima gurrbiwi Girar nyibirri Pilitjayin bapurrurr nyi'nyininy giriny. Nguḻikima giḻiwiḻing djin nyininy girinyban. ");
INSERT INTO dji_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Manymak, ngunukiṉing Abrayam nyininy kiriny nguḻi, nguṉi Girarbi yulpilingiri djin nyangiṉi Sara. Bil nyani Abrayam djinanydji bultjini giriny Sarang, “Djinimkima miyilk nyani djining ngirrang gaḏingimi.” Ga ngunuwiltji Pilitjayin mala djin gangili ngunukima djanguny nyanngali bunggawali, ngunung Pilitjayin ngurrḏawalangu nyi'nyininy giriny nguḻi Girar gurrbiwi, yagirri Abimilik. Marrga djamagiṉpili nyani Abimilikdji djiny yaniliban ngunyili Abrayamang gurrbili, marrga inga djin bagiligi Sarany. Djin yulgungili, girri Sarany djin djamirrdjini, girri bapiḻipm inga djin birrungiliban Abimilikgi. ");
INSERT INTO dji_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Bil wurpm maliri, ngunukiṉing Abimilik ngurriny kiriny, nyani yakirr-nyangiṉiban miri nyani God inga yulgungili ga inga bindjin wanginban, “Djini-guyum nyuni balidjiban, gima ngunukima miyilk nyuni djaminmi miri nyani wurpang yulang nyanimngim!” ");
INSERT INTO dji_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Bil ngurrwakng, nyani Abimilik ingki waymirri ngurrinyir nyanngar Sarar, yarim ingkipm ngidjirrgili inga girinyir Sarali gima murtjili. Marrga nyani butjalminiban Garraynyi, “Wirr, Garray! Bina buṯal miri nyuni bungi rum-manymakgiṉing yul? Yarim ngarribi miri djuburr djunupa yul; ");
INSERT INTO dji_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","gima ngunukima yul Abrayam miri nyanibipm irra wangi, ‘Djinim miyilk nyani djiningi ngirrang gaḏingimi’, ga ngunukima miyilk nyanibipm irra bultjinmi, ‘Djinim yul nyani djining ngirrang wuwngimi’. Ga ngarri bilinggarr marr-yirrimkiṉdjirri, marrga ngunukima miyilk irr marrimban. Ingkiban gumbirrdji irr murguwi!” ");
INSERT INTO dji_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Girri God yan inga bumir-gaypili ngungirapibi mabugibi, “Ngiy, ngarri marnggi miri nyuni ingkiban djiringirri miri nyuni murgum kirim. Marrga ngarribipm nyirr way-mirrbilgim marrga nyuni ingki ngurridji nyanngar, bintji nyaninyi nyuni gatjigi gumbirrdji ga rum wubirdjigiban ngirrang. ");
INSERT INTO dji_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Bil djunupaban ngunukima miyilk nyuni wiṉidjingilgi nyanngali, gima ngunukima yul Abrayam nyani ngunung Godang djabarrkgiṉing, yarim nyani miri bultjinakiṉing djangunypili Godbi; ga nyani irriny butjalmidji nyungki, ga nyin wanngirgi balinyirbingir. Bil djiningkima nyuni marnggiban, ngunubilang nyuni ingki wiṉidjingilgi Sarany, ngildji yirrimban ildji balidji, miri nyunibi, ga bukmak nyungung mala,” inga bindjini God Abimilikgi mabugimirrpmi. ");
INSERT INTO dji_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Manymak, djaḏaw, nyani Abimilik inydji waykungili girri guwakuwatjili warrpam, nyanngang gurruṯigiṉpili ga nyanngang djamagiṉpili, girri djiny butjirgiṉdjiliban bubalikiṉing God inga bultjinmi mabugibi. Ga ngunuwiltji djin guway-ṉirrdjili, ga mirrpmban djin yawnginiban. ");
INSERT INTO dji_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Marrga Abrayamnyi nyani Abimilik guwadjili, ga inga bindjini, “Nyawban, mari wanaban inbiliny barngiliban gima nyungupibi. Nyim gunyambi inmarr djamadjimi marrga djinimirri nyuniban irra mari-djamadjimi ngirrki? Gima nyungupibi nyani God inbila maḏakarritjdjiniban, ngirrki ga ngirrang malagi. Nyuni inbila gar-yulgimi, yarim nyungung djuburr miri mirgidjnyakiṉing ngirrki; guṉgi inma mirikunu! ");
INSERT INTO dji_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Nyimpi bilang nyuni bindjirr ngurrgima?” bilapilang, nyani Abimilik yan maṉbi inga wangini Abrayamgi. ");
INSERT INTO dji_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ga nyani Abrayam yan bumir-gaypili, “Ngarri ginginyi miri, birralkima djiniwili Girarmimigi yulpili ingki djin marnggi Godgi, ga ingki djin marr-bulanggitjdjidji rumgi Godang, marrga irriny djin bungi ga ngirrang miyilk djin djamigiban. ");
INSERT INTO dji_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Bil djining djanguny birralkima miri nyani Sara miri ngirrang gaḏingimi; gima nyani miri walkiripm inga gunydjirrgirki ngirrang, bil ingki nyani ngirrang ngambirrgirang rambirri, bil wurpang ngambirrgirang. Marrga inydji liny marrngili, ga nyani ngirrang nyanimngimban. ");
INSERT INTO dji_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ga gima ngungirapibi, miri biligi nyadji Goddji minydji yanili ngirrinyi marrga irr gukirri girim gurruṯinyirringi, ngunukiṉingban ngarri ingarr wanginiban Saragi, “Ngarri djal miri djinimirri nyuni irra marr-bulanggitjdjidji: yarim nyibirri nyibirri gurrbiwi il yulgungi, nguḻikima nyuni inydji bultjigiban ngirrangi, ‘Djinimkima yul nyani ngirrang wuwngimi’, bilapilang ngurrgima nyuni djina wangidji.” Bilapilang Abrayam inga bindjinban ngungirki yulgi Abimilikgi. ");
INSERT INTO dji_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Manymak, nyani Abimilik marrngiliban galbi miri maypal bimbi, bulukipili, ga djamagiṉpili - yul ga miyilk; girri Abrayamgi djiny gupirr-gungiliban. Ga Sarany nyani wiṉidjinginiban girrigima. ");
INSERT INTO dji_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Girri inga bindjin Abrayamgi, “Djinimpan, ngirrang djawal ḻapdjiliban nyungki: rawban ga nyibirri nyuni djal nguḻiban nyuni inydji yirryirrpigi.” ");
INSERT INTO dji_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Girri Saragi inga bindjinban, “Galbi rrupiya ngarri gungban wuwgiriny nyungung, miri 1,000 ḏiḏipili, miri bilapilang milmaban ngarri djinyirr mil-ḻirrpigiban warrpamnyi miri nyuni rum-manymakgiṉing miyilk.” ");
INSERT INTO dji_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Rirringir ngunungir-kirri nyani Abrayam butjalmini Godnyi, ga nyani Goddji burri-wanngidjnyirdjiliban ngunukima yul Abimilik, marrga nyani galng-manymakdjiniban. Ga wurpi mala Goddji burri-wanngidjnyirdjili girri, miri Abimilakang nyanimngim ga djamagiṉing miyilkpili; marrga djamingi djani ganydjarrgiṉdjidji miri budjirrimirri djin mini giri yidjipilpili. ");
INSERT INTO dji_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Gima ngurrwakngi, ngunukiṉing nyani Abimilikdji djaminmi Sarany, nyani Goddji miṉipmban yarrpili djina miyilkpilngirang, marrga ingkiban djin gapaḻmirrpilidjidji; gima nyani Abimilikdji djaminmi Sarany Abrayamang nyanimngim. ");
INSERT INTO dji_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Ga nyaninyi nyani Yawaydji djakadjili Sarany, miri nyanngapibi Godbi yuwirdjing yidjipili birraldjili, ngunung Goddji murr-rangirri, ");
INSERT INTO dji_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","girri nyani yidjipilikiṉdjiniban ngunukima miyilk Sara, ga guyumi nyanngapibi ngunung yidjipili yul bungtjili, Abrayamang walkiringim ngunukima murr-randinirbi Godbi. Ga bilakiṉing nyani Abrayam wurrungdjini, bil yarim ngunukima yidjipili bungtjili ngunukiṉingban miri ngunung ngurrgima waḻirrdji miri God inga bultjidjini biligi. ");
INSERT INTO dji_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ga Abrayam yagirri yirrpini ngunung yidjipili Yisak (Isaac). (Ngunung yagirri mayali miri ‘Gitgit’.) ");
INSERT INTO dji_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Ga ngunukiṉing miri 8 yakirri bangiringili Yisakgi, nyani Abrayamdji marrngili birrang, girri nyaninyi gurrmildjiliban, miri ngunung ngurrgima rum Goddji yirrpini ngurrwakngi. ");
INSERT INTO dji_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ga Abrayam miri nyani bir-gayping yul bilakiṉing, nyani ngurrum gatjidjini 100 guṉmal ga rarranydjarr ngunukiṉing Yisak bungtjili. ");
INSERT INTO dji_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Ga nyani Sara inydji bultjidjini bindjin, “Nyanngapibi ngarri gitgitdjimi Godbi, ga bukmak miri ngunuwili djining djanguny djin marrngirrdji mala irra djin maltjigiban djin ṉitjanydjidjiban girri.” ");
INSERT INTO dji_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ga nyani gurrkungili wanginban, “Wari ngirrinyi inga bultjinir Abrayamgi, miri nyadji ngunupilang guyumi irr mini yidjipili, ga ngaman gungi inga yidjipiligi! Wirrgima! Bil marriban, yarim Abrayam wurrungban, bil djinipankima ngarri minigimi walkiripm inga.” ");
INSERT INTO dji_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Manymak, ngunukirri yidjipili djurrginyi, ga ngunukiṉing nyani marri wana, nyani Sara ḏaḏawdjiniban gunyirngir ngamanngiri. Ga ngunupan, yarim ngunung ngurrgima maṉngibirri, nyani Abrayamdji djanguny yaniliban marrga bubalikiṉing inydjin gurrkungi bunggulgi wanagi, marrga maypal ga wali djin ḏirradj nyinidjiban ngunung guḻukngwilidji; yarimban inydjin ralkungi Abrayamgi ngungirki yidjipiligi. ");
INSERT INTO dji_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Manymak, guḻukng wana ḏirradj nyininyi, ga biling yidjipilimirrpili Yitjmayil ga Yisak inydji bil walngirriny kirinyban. Yarim ngunung yidjipili Yitjmayil nyani budjirribi Yagarbi, ngunukima Sarang djamagiṉing miyilk. Ga nyani Sara bilny nyany kiriny bil walngirriny kiriny, ga ngunung ngurrwagiping yidjipili Yitjmayil nyani mil-ḏinytjiliban gulmigipm inga, ga inga gitgitny kirinyban Yisakgi. Ga nyani Sara mil-marnggiban, ");
INSERT INTO dji_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","marrga inydji birrindjinginiban Abrayamili ga bindjin wangin, “Nyuni bilngiriny badji-nyawban, minydji ngurrgiwi ngunukima djamagiṉing miyilk ga nyanngang gapirri! Guyumi nyuni wirrdjidji, ga ngirrang gapirri Yisak nyanibipm marrgiban nyim mala bulanggitj nyungupibi, miri nyanibipm ngiḏawa; bil ngungirki ngunukima miyilkang gapirringirgim wirrban inga!” bindjin Sara yan-maṉbi wanginyi inga. ");
INSERT INTO dji_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Bil nyani Abrayam mirrpmban marr-mirgidjiniban, gima ngunung yawirriny Yitjmayil nyani girrgima nyanngapibi Abrayambi walkiripmi. ");
INSERT INTO dji_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Bil nyani God bindjin wangin inga Abrayamgi, “Ingki marr-mirgidjiyi nyanki Yitjmayilgi, ingki inga wargugudjiyi miyilkigi ngunung ḏapmiynyirbi djamagiṉing inma. Manymaktja nyuni bintji ngurrgima miri nyalikidjini nyani Sara inma bultjidjini, gima Yisakmirrpmi nyuni mala-pungi marrga nyanngamirrpmi nyungung gurruṯigiṉingirang muṉḏaṉ minydji djirridji inydji mungbinigi. ");
INSERT INTO dji_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ban djingirki, ngunung djamagiṉingirang gapirri, ngarri mala-pungi wana nyanngamirrpmi girrigima, gima nyani wurpi miri nyungung yidjipili.” ");
INSERT INTO dji_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Manymak, milwartjini maliri-gunyirri, nyani Abrayamdji wali marrngiliban, ga gapi ṉambiḏi gilingkaḻmirri maypalang marrngili rarrtjaḻ, girri burrili gilibili Yagarli. Girri nyani marrngili nyanngang yidjipili Yitjmayil, girri minydji bilny yaniliban murrurrtili. Biling bil gubini, ga bubaliban bil gukirriny kiriny wirrpil-mirrpmi, ngidjirrkngi ngunung gurrbiwi Biya-Djiba (Beer-Sheba). ");
INSERT INTO dji_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Miri yakirri galbi bil gukirriny kiriny, girri gapiban bil malimdjili. Marrga nyani Yagardji galwupiṉi yidjipili gurrtjimirri munganmirri, ");
INSERT INTO dji_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","girri marri bilayili minydji girali ga nyininiban; gima nyani inydji wangini, “Ngarri ingki djalngdjiyi miri irr nyangban ngirrang yidjipili balidji.” Ga bilapilakiṉing ngunung miyilk ngurr-yirrpiniban ngadjiniban mirrpmban nguḻi marri bilayngiri yidjipilingir nyanngangi. ");
INSERT INTO dji_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Bil nyani God marrnginiban ngunukima yidjipilang bimbi ngadjny kiriny. Ga wurpmi Godang wugiḻi djamagiṉing inga witjiliban Yagargi ṉamngiri, nyani bindjin, “Nyimkiban nyuni marr-mirgidjirr kirimban Yagar? Yawnginyirringi, gima Goddji inga marrngini bimbi ngadjnyirakiṉing nyanngapibi maribi yidjipilangirangpibi. ");
INSERT INTO dji_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Guwu, marriwban ga djaltjibigi yidjipili, ga djalng-gungban inga; gima nyani Goddji djingiriny gungi mala-punyirbi galbi mirrpmi, marrga nyanngang bapurrurr minydjin djirridji miri yagirri-wana mala,” bindjin ngunukima wugiḻi Godbi. ");
INSERT INTO dji_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Girri Goddji mil-ḻapmiyngili inga marrga nyani djiringiniban miri ngunumkima gapi bungbungdjili ralalngiri. Nyani nyangiṉi gapi, girri marrngiliban ngunung gumbaḻa gilingkaḻ, djirrdjirrdjili girri gangiliban gapi, ga inga minali yidjipiligi ga nyani ḏirradjiliban. ");
INSERT INTO dji_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Manymak, ngunukima yidjipili Yitjmayil galng-wanadjini, ga nyaninyi Goddji djakadjny girinyi. Ga nguḻikima ngunung yul Yitjmayil nyininy girinyi yirrpimirri, ngunukima gurrbi djin bultjidjini Paran, ga nyani djambatj mirrpmi bow-gi maypalgi. ");
INSERT INTO dji_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Ga guyumi nyanngang ngambirri marrngili miyilk nyanki Yitjmayilgi ngungirapibi gurrbibi Yidjipt-bi. ");
INSERT INTO dji_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Bilakiṉingi Abimilik ga Pikul Abimilikang ngurrḏawalangu gamuṉunggu malagi, biling bil baḻparingili Abrayamnyi. Ga nyani Abimilik bindjin wangin inga, “Miri nyim ngunupilang djama nyuni gatjinmi, yarim nyani Goddji nyin gunggatjimi. ");
INSERT INTO dji_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Marrga yagirrimirri Godangmirri nyuni irriny murr-raniban, miri bilapilang gam': ingki nyuni irriny gar-yuli ga ingki nyuni djina mirgi-djamadjigi ngirrang gurruṯigiṉingirgi; bil ngunyili yipi irra mil-biḻbaḻdjidji giri, ga djakadjigi djining gurrbi nyibirri gurrbimirri nyuni nyini girimban; yarim miri ngunung ngurrgima ngarri nyirr djakadjim girim nyuninyi.” ");
INSERT INTO dji_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ga nyani Abrayam inga bindjin, “Ngiy, ngarri murr-rangirriban.” ");
INSERT INTO dji_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Girri nyani yan maṉbi inga wanginiban Abimilikgi bil miri yilimbirring, nyani bindjin gima Abimilikang djamagiṉpilingir djin gatjinmi ngunung ralal Abrayamdji gaminmi bilimi. ");
INSERT INTO dji_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Bil nyani Abimilik yan bumir-gaypili, “Ngarri djunga miri wiḻi gatjinmi ngunukima ralal nyuni gamirrdjini. Nyuni wirrgima irra bultjirri, ga ngarri wirr irr marrngirriy djining djanguny yarimipm djinipankima.” ");
INSERT INTO dji_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Girri nyani Abrayam marrngili maypal bimbi mala ga buluki mala, girri gupirr-gungiliban Abimiliknyi. Bilapilakiṉing inydji bil murr-rangirriban, yarim ṉu bilingga bil yirrpiniban, miri bilapilang gam': rum magayagiṉing inydji bil gurrpigi ga bilingganydji bil mil-biḻbaḻdjidji. ");
INSERT INTO dji_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ga nyani Abrayam butnyirdjili 7 bimbi maypalpili miyilkpili, ga bapiḻi gangili gurrbili ga djani bimbipili nguḻi dja'djarriny kiriny milmaban Abimilikar. ");
INSERT INTO dji_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Marrga nyani Abimilik butjalmini Abrayamnyi, “Nyimgima djining mayali miri ngunumkima bimbipili nyuni rindilali, ngunuwili rarrmaḻipm dja'djarri, miri nyimki?” ");
INSERT INTO dji_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ga nyani bumir-wubirdjili, “Djining mayali miri; bilang nyuni marrgi djiniwiliny, nyuniban mil-ḻirrpigi bubalikiṉinginyi miri ngarri birral irr gaminmi djinim ralal gapigi.” ");
INSERT INTO dji_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Manymak, gima ngungirapibi djangunybi djin bultjini giriny ngunukima gurrbi Biya-Djiba, gima ngunung yagirri mayali miri ‘Biling murr-rangirri’, gima biling inydji bil murr-rangirri nguḻikima, bilapilang. ");
INSERT INTO dji_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Rirringir ngunungir-kirri bilingi Abimilik ga Pikul, ngunung bunggawa miri guḻinydjarr malagi, bil gubiniban ga bil wiṉini djawalili bilngalipm, ngunung Pilitjayin djawal. ");
INSERT INTO dji_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ga nyanngangi Abrayamgi, nguḻi Biya-Djiba nyani ḻamudjili djamban gurrtji, ga nguḻikima nyani bumir-witjny giriny Yawaygi ngunukima God Wanngi-giḻiwiḻingakiṉing. ");
INSERT INTO dji_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ga giḻiwiḻing bildjirri nyani nyininy giriny nguḻi ṉambiḏi ngunung Pilitjayinar gurrbimirri, yarim galbi guṉmal ga rarranydjarr. ");
INSERT INTO dji_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Rirringir bamanngir nyani Goddji manyangiṉi Abrayamnyi miri nyimkiṉing djakiy. Nyani inga witjili, “Abrayam guwa!” “Nyimay? Ngarri butjir inydjirr gum kirimban,” nyani bindjini Abrayam. ");
INSERT INTO dji_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Girri nyani Goddji inga bindjini, “Guwu, marriwban nyungung walkiripm Yisak, ngunukima yidjipili marr-bulanggitjnyirbi nyungupibi, ga nyum nyim giriban gurrbili Murayali. Ga ngunukiṉing nyim yulgungi, ngarri nyirr mil-ḻirrpigi bumiri gurrbi, ga nguḻikima nyuni bungban Yisaknyi gurrbimirri guṉgimirri ngunung wurpmi nyirr mil-ḻirrpigi, yarim nyuni rani ga batjigiban miri mundjarr burrtjirrinyirbi gunyirbi ngirrali,” God inga bindjin. ");
INSERT INTO dji_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Manymak, milwartjini nyani Abrayam inydji waykungiliban. Nyani marrngili nyininyirbi ga gilibili burrili dungki-li biṯma yarraman. Girri nyani marrngili djunggi biral, barrbiḻpilingdjili djunggi ngunung djaming rarrtjilkungi. Girri marrngili yawirrinymirrpili nyanngang djamagiṉingmirrpili, ga Yisak nyanngang walkiringimi, girri ḻarrban djin walminiban bumir-ḻunggurrmali, ngunyilipm ngunung bumiri gurrbi God inga bultjinmi. ");
INSERT INTO dji_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Djin giriny nyininya-a-a yakirr bingili. Milwartjini ḻarrban; ga malngiri nyani Abrayamdji bumir-nyangiṉiban gurrbili bilaypmi. ");
INSERT INTO dji_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Girri nyani bilingga wangini djamagiṉingmirrpiligim, “Nyumi djiḻigima nyim djirridji, nyumi ga djining dungki nyim marrkang djiḻi, bil ngilinyi ngunyilatjuy liny giriban; liny bumir-kirrbigi Godnyi ngunumi, girri bapiḻiban liny wiṉidji nyumilali.” ");
INSERT INTO dji_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Girri djunggi mala nyani gilibili burrili Yisakang Abrayamdji, bil nyanibipm gumbirridji minali birrang ga balinyirring ngirrtjnyakiṉing marrga rarrtjilkungi djunggi. Girri biling giḏidjirrim bil giraliban. ");
INSERT INTO dji_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Bil giriny nyininya-a-a, malngiri Yisakdji yanyangiṉi gunydjirrgiriny, nyani bindjin, “Maḻu?” “Nyim walkira?” bindjin Abrayam. “Djining irr minigim kirim djunggipili, ga nyunibi minigim kirim ngirrtjnyakiṉing djunggi, bil nyalipan ngunung maypal bimbi il bungi ga batjigi miri mundjarr Godgi gunyirbi ngiltjapibi?” bindjin Yisak. ");
INSERT INTO dji_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ga nyani Abrayam inga bumir-wubirdjiliban, “Ngunukima maypal bimbi Goddji nyanngarki iltja gungi, walkira.” Ga biribiri biling mungu bil giraliban ngunyilipm. ");
INSERT INTO dji_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Bur bil yulgungili nguḻi ngunung gurrbi God inga bultjinmi Abrayamgi. Girri nyani yip mutjpiningiliban rirrkiyandji, girri ṉamiliban gilibili djunggipili ga djarrpiṉdjinginiban, girri walkiripm inga garrpiniban muṉḏaṉdji, djaltjibili, girri gilibiliban ṉamiliban djunggimirri. ");
INSERT INTO dji_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Birrangban baṯ, way djaltjibili djini-guyumban bungban walkiripm inga, ");
INSERT INTO dji_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","bil bilapilakiṉingban ṉamngiri bimbi inga witjiliban wugiḻibi, “Abrayam! Abrayam!” inga witjili Yawayang wugiḻi djamagiṉing. Ga nyani Abrayam bindjin, “Nyimay? Ngarri djinipan!” ");
INSERT INTO dji_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Ga nyani bindjin, “Guḻdjiwban! Ingkiban rarri! Ingkiban nyuni galng inga mirgidjiwi nyaninyi! Ngiy, djinimirriban ngarri inmarr marnggidjini nguygi, miri nyimkiṉing djakiy inma. Miri bilapilang nyuni bintji ngurrgima butjirgiṉdjidji yan gunyirbi ngirrapibi, gima nyuni ingki irra mirrbilginyiri ngirrki nyungung walkiripm nyungung marr-bulanggitjnyirbi yidjipili.” ");
INSERT INTO dji_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Rirringir nyani mukdjili, ṉamiliban nyani Abrayam milingili, girri maypal bimbi mildji bipiṉiban nguḻikirri, miri wana bimbi yul; yarim ngunung bimbi guṉgi-gaṯtjili butjiridji gurrtjimirri waymirri. Marrga Abrayamdji marrngiliban ngunukima, bipiṉi, yipmirri rirrkiyanmirri galwupiṉi, girri batjidjiniban miri mundjarrban Godgi gungili; ga nguṉi maypaldji biḻamirri djamirrdjiniban ngungirki yidjipiligi. Bilapilang, Abrayamdji yidjipiligi rirrang inganydji galwupiṉi ngunukima maypal bimbi. ");
INSERT INTO dji_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ga nyani Abrayam yagirri yirrpini ngunukima gurrbiwi “Yaway Gunyirakiṉing”; marrga gima ngungirapibi yulpili djin wang girimipm mungu djini'djining, djin bindjirri, “Nguḻi bumirimirri gurrbimirri Yawayang, nyani inmila gungi”. ");
INSERT INTO dji_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Ga nyani madjirri inga witjili Abrayamgi ngunung wugiḻi ngunungir ṉamngiri, inga bindjin, ");
INSERT INTO dji_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Abrayam, nyani God djining djanguny inma yaniliban nyungki gam': Ngarri djining inmarr gungban maṯiṯ murr-randinirbi, ga ingki yan irr wubirdjigi bintji ngarribipm yagirri inydjirr mirgidjigi. Gima nyuni yan butjirgiṉdjini ngirrang, ga ingki irra mirrbilginyiri nyungung walkiringim ngunung nyuni marr-bulanggitjdjirri, ");
INSERT INTO dji_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ngarriban inmarr mil-biḻbaḻdjidji ga bulanggitj mala nyirr gungban, miri bilapilang gam': nyungung mala-punyirbi inydjin ngurri ga djin galbidjidji, yarim wana guḻukng miri ngunuwili gata mala ṉammirri dji'djarri giṉimbirrimirri, ga miri munatja rirrpiḏi mala munganmirri gapi djalkngmirri ngu'ngurri, miri bilapilang nyungung gurruṯigiṉing mala djin galbidjidji. Ga ngunubilang wurpili bapurrurrdji mari djina djin djamadjigi gurruṯigiṉingirgi inma, djani nyungung mala-punyirbili djiny djin wiṉgaḻamiygi ga gurrbi djina djin djamigiban. ");
INSERT INTO dji_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Ga nyungupibi mala-punyirbibi bukmak bapurrurr mala djiḻi gurrbi-munganmirri djani inydjin marrkapdjigi, yarim ngunukima birraldjidji gima yan nyuni butjirgiṉdjini ngirrang,” bilapilang ngunung wugiḻi inga bindjin djining djanguny gunyirbi Yawaybi. ");
INSERT INTO dji_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Manymak, biling Abrayam ga Yisak bil wiṉiniban bilinggali ngunukirri yulmirrpili bil marrkany kiriny nguḻikirri, girri warrpamdji djin gubini Murayangir gurrbingir ga ngunyilipm Biya-Djibaliban djin wiṉiniban. Ga rirringir ngunungir-kirri nyani Abrayam giḻiwiḻing nyininyi nguḻikima gurrbiwi Biya-Djiba. ");
INSERT INTO dji_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Manymak, marri guyumi wiḻi inga birrungili djanguny Abrayamgi gurruṯigiṉingibi walanggarrangir djawalngir. Ga ngunukima djanguny inga bultjidjini gam': “Milka, nyanimngim Nayurgi, nyani girri miri yidjipilpili minigim girim nyanngapibi Nayurbi nyungung gulmingimi. ");
INSERT INTO dji_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Miri Yutj, nyanngang miḻimiṯi, girri Butj, girri Kimuwil (ngunung djampan miri gunydjirri Aramgi); ");
INSERT INTO dji_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","girri djining yulpili mala yagirripili: Tjisit, Yatju, Pildatj, Djitlap, ga Bituwil.” ");
INSERT INTO dji_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Miri ngunukima yul Bituwil, nyani miri gunydjirri miyilkigi yagirri Ribika ngunukima miri guyumi nyanimngim Yisakgi. Djiniwiliny 8 yidjipilpilngirinyi nyani Milka minigimi budjirrimirri Nayurbi, Abrayamang gulmingim. ");
INSERT INTO dji_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Ga wurpi miyilk Nayurang yagirri Riyuma, ngunung biṯma nyanimngim bil djamagiṉing inga, nyani minigimi yidjipilpilngirinyi Nayurbi girri; djining yulpili mala yagirripili gam': Tiba, Gayam, Tayatj, ga Maka. ");
INSERT INTO dji_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Manymak, nyani Sara gatjidjini 127 guṉmal ga rarranydjarr, ");
INSERT INTO dji_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","girri nguḻi wirrdjini gurrbiw Kiriyatj-Arba, ṉambiḏi ngunung wana gurrbi Kanan. Ga ngunung gurrbi Kiriyatj-Arba djamingi djin bultjidjini Yibrun. Manymak, Sara wirrdjini, girri nyani Abrayam ngurr-yirrpiniban inga ngadjiniban Saragi. Nyani munganmirri nyininy giriny nyanngar ngunukima balinyirbi Sara, inga ngadjny kirinya-a-a, girriban. ");
INSERT INTO dji_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Nyani mukdjili ngadjnyirngir Saragi, inydji waykungili, girri gurrbiwaṯanguny malany djiny baḻparngili, ngunuwili yulpili mala bapurrurrbi Yitayitbi. Nyani nyinini djanngar, girri inydjin bultjidjiniban. ");
INSERT INTO dji_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Nyani Abrayam djina bindjini, “Yarim ngarri yul gurrbinyirring djiḻi ngildjar waymirri irr nyini girim gima mulkuru irri, bil marriban, ngarri irr djal miri ngildji irriny ildji djilimdjigi wurpmi ṉinini gurrbi marrga nguḻi mulumirri irr djalirgi ngirrang balinyirbi gurruṯigiṉing mala.” ");
INSERT INTO dji_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Ga djani inga djin bumir-wubirdjili Abrayamgi, “Biḏak, butjir-inydji guw bunggawa! ");
INSERT INTO dji_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Nyuni miri yagirri wana yul, ngunukima yirryirrpinirbi Godbi, ga djiḻi nginbilar nyi'nyini. Manymak, nyuni rindiligi wurpmi ngunupilang buṯal mulugiṉing gurrbi nginbilang, girri nguḻiban nyuni djalirgi nyungung balinyirbi gurruṯigiṉing mala. Ingki wiḻi inma mirrbili nyungki mulugiṉing gurrbi nginbilang marrga nyuni djalirgi nyungung gurruṯigiṉing mala.” ");
INSERT INTO dji_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Girri nyani Abrayam gupildjini, miri bilapilang nyani djina bumir-kirrbili. ");
INSERT INTO dji_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Girri madjirri Abrayamdji djiny butjalminiban, djina bindjin, “Ngunubilang ngildji birral djalngdjirri miri ngirrang balinyirbi mala djiny irr yilitjigi ga djiny irr djalirgi, ngildji yitjidjidjiban miri ildji butjalmidji ngunukima yul yagirri Yiprun walkiringim Djuwargi, ");
INSERT INTO dji_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","marrga nyani irriny djilimdjigi ngunung miring ngu'ngurri gurrbiwi nyanngar. Ngungirki ildji marnggi, ngunung miring ildji bultjin girim Makpila, ngunumi dja'djarri galiymirri gurrbimirri nyanngar. Ngunubilang ngunukima nyani irriny djilimdjigiban milma, ga ildji mil-marnggidjidji, ngunung irr bayimdjigiban miri nyabiniwili rrupiya nyani irra bultjigi, ga irr galikiban ngunung, miri ngirrangpibi mulugiṉing gurrbi.” ");
INSERT INTO dji_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ga nyani Yiprun nguḻikirri nyininy kiriny, ga nyani butjir-marnggidjini Abrayamgi. Ga ngunukima yul Yiprun nyani girri miri ngungirapibi Yitayit bapurrurrbi. Miri ngunutjini yul mala nyininyi nguḻi gurrbimirri rarrimirri munganmirri gadjigirring, djani miri ngurrḏawalangupili wanapilimirring ngungirapibi gurrbibi, ga rum djin djakadjny giriny ngungirki gurrbigi. ");
INSERT INTO dji_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Manymak, nyani Yiprun marrngini Abrayamnyi, girri yan inga bumir-gaypili Abrayamgi, “Ingki, bunggawa; biḏak, ngarri wangidjiban. Ngarri gupirri-gungban nyungki ngunukima miring ga ngunung gurrbi nyibirri ngunukima miring ngu'ngurri budjirrminy. Djining miri mundjarr inma, ga milmaban ngarri nyirr gungban, marrga ngirrang gurruṯigiṉpili djiḻi djin nyi'nyini mala djin mil-marnggidjidjiban. Manymak, guwu ga nyungung balinyirbi nyuni djalirgiban nguḻi.” ");
INSERT INTO dji_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ga madjirri nyani Abrayam djina gupildjiniban ngungirki gurrbiwaṯangugi malagi; ");
INSERT INTO dji_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","girri nyani inga wangini Yiprun-gi milma djanngar, “Bilang manymak nyunguri miri nyuni yitjidjidji, ngarriban nyirr gungi rrupiya ngungirki gurrbigi. Yarim irr bayimdjigi rrupiyadji, ga nguḻiban djiny irr djalirgi ngirrang balinyirbi gurruṯigiṉing mala.” ");
INSERT INTO dji_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ga nyani Yiprun inga bumir-wubirdjili Abrayamgi, inga bindjin, ");
INSERT INTO dji_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Manymak, butjir-inydji guw bunggawa! Manymak ngunukima gurrbi nyuni bayimdjigiban nyabiniwili marri, yarim 400 ḏiḏipili; bil djining rrupiya miri marr-malngiri ngiltjiki, il marrbigi rrupiya ga ngunukima gurrbi ngarri nyirr gungi nyirr mungbinigi. Girri nguḻi nyuni djalirgi nyungung balinyirbi mala.” ");
INSERT INTO dji_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Girri giḏagiḏapm nyani Abrayam yitjidjini miri bayimdjigi Yiprunngir, marriban rrupiya wana bil nyani marrngilipmban. Nyani djarrdjingini rrupiya girri milmaban butjurrudjili 400 ḏiḏipili, ga ngunuwiltji gurrbiwaṯangupili djani inga djin mil-marnggidjini. Nyani Abrayamdji galwupiṉi djunupa rrupiya bilapilang miri rrupiya-djamagiṉing rum djina bultjidjini ngunuban bildjirri. ");
INSERT INTO dji_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Bilapilang, Yiprunang gurrbi, miri ngidjirrkng Mamri'ang gurrbi ngu'ngurri, nyani Abrayamdji bayimdjili; miri ngunung miring ga warrpam ngunung gurrbi inydji garrpinirbi ga warrpam gurrtjipili ṉambiḏi ngunung gurrbimirri; djining mala Abrayamdji galini girinyban. ");
INSERT INTO dji_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Ga bukmak ngunuwiltji gurrbiwaṯangu mala inga djin mil-marnggidjini miri Abrayamdji galiki giri ngunung gurrbi miringgiṉing ngunyili yipi. ");
INSERT INTO dji_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Rirringir ngunungir-kirri, Abrayamdji djalirngili Sarany nguḻi mulumirri miringmirri, ngunukima gurrbi djin bultjini giriny Makpila budjirrminy Kananmirri gurrbimirri. ");
INSERT INTO dji_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Miri bilapilang Abrayamdji marrngili ngunung mulugiṉing gurrbi djanngangir gurrbiwaṯangungir ngungirapibi gurrbibi, ngunungir Yitayit bapurrurrngir. ");
INSERT INTO dji_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Manymak, rirringir galbi guṉmal ga rarranydjarr inydji bangiringili, nyani Abrayam wulmandjiniban mirrpmban; ga ngurrwagipi nyani Goddji inga gungili galbi manymak mala ga djagadjili nyaninyi. ");
INSERT INTO dji_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Manymak, nyani Abrayam djiringini miri nyanngang balinyirbi bildjirri ngidjirrgidjini inga. Marrga nyani inga witjili nyanngang bunggawagi djamagiṉingirgi, ngunukima yuldji djakadjny giriny bukmak girripili Abrayamang. Nyani yulgungili, ga Abrayam inga bindjin, “Nyuni gumbirri-rawban bapiḻi ṉambiḏili gaṉḏili ngirrali, ");
INSERT INTO dji_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","marrga milmaban nyanngar Yawayngirar nyuni irriny murr-raniban miri ingki djingirapibi gurrbibi nyuni marrgi nyanimngimi Yisakgi; yarim miri djiḻi lim nyini girim djanngar djinikima Kananayitar malar, bil ingki nyuni djamigi miyilknyi djiningir bapurrurrngir, bilapilang nyuni murr-raniban milbimirri Godar ngunukima Miligidji gurrbigi ga giṉimbirrigi. ");
INSERT INTO dji_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ga nyuni irriny gungi murr-randinirbi miri nyuni wiṉidji ngunyili djawalkitjili ngirrali, marrga ngunungir nyuni inga marrgi miyilknyi walkiringirgim irra Yisakgi djanngapibi ngirrang gurruṯigiṉpilngirapibi.” ");
INSERT INTO dji_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ga ngunung djamagiṉing inga bindjin Abrayamgi, “Ngunubilang ngunung miyilk irriny ingki-pultjigi marrga nyani ingki irriny gurrpigi bapiḻi gurrbili, nyalikiban ngarri ingarr marrgi miyilk Yisakgi? Bina manymak miri nyungung walkiripm irr gangban ngunyilipm?” ");
INSERT INTO dji_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Bil nyani Abrayam inga bultjidjini, “Ingki ingki! Ingki nyuni wiṉidjingilgi ngirrang walkiripm ngunyilipm! ");
INSERT INTO dji_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Yaway, ngunung Miligidji ṉammirri nyi'nyini, nyani irriny djamirrdjini ngirrangir gunydjirrgirang gurrbingir, ga ngunungir gurrbingir nyibirri irr bungtjili, ga nyani irriny murr-rangirri djinimirri gam': ‘Ngarri djinarr gungi djining djawal mala-punyirbigi nyungungkima’. Marrga nyanibi inma yani nyanngang djamagiṉing wugiḻi miri inma gunggatjigi marrga ngunungir gurrbingir nyuni bi birrugi miyilk inga bapiḻi Yisakgi ngirrang walkiringirgim. ");
INSERT INTO dji_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Ga bilang nguṉi miyilkdji nyin ingki-pultjigi ga ingki nyin gurrpigi, nyuni yarangdjidjiban djiningir murr-randinirbingir; bil ingki nyuni wiṉidjingilgi ngirrang walkiripm ngunyilikima, wirrpm!” inga bindjin Abrayam djamagiṉingirgi. ");
INSERT INTO dji_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Ga ngunukirri yul gumbirri-ragiliban ṉambiḏili gaṉḏili Abrayamli, girri inga murr-rangirriban bunggawagi. ");
INSERT INTO dji_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Manymak, nguṉi djamagiṉingir marrngili 10 kamulpili Abrayamang, ga galbi wurpi wurpi mundjarr mala djiny gurtjili nyanngapibi bunggawabi, girri djingiriny malany djiny birrpirrungili ga djiny gilibili burrili kamul-li, girri ḻarrban nyani ga nyibi wurpipili djamagiṉpili Abrayamang. Djin giriny nyininya-a-a, yakirri galbi, ga djawalmirri Mitjuputamiya (Mesopotamia) djin yulgungili bilay pirr nyibirri djani Nayurang mala-punyirbi djin nyininyi. ");
INSERT INTO dji_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Manymak, nguḻi gar-gurriyili gurrbimirri biligi djani yulpili djin gamirrdjini ralal wana marrga gapi djin marrgi; ga giḻiwiḻing mala biṯma djapiḏi ngurrinyi nguḻi munatjamirri marrga ngunyili gapi djin djuḻuḻupmiyngili marrga maypalpilingiri djin ḏirradjigi. Ga ngunukiṉing Abrayamang djamagiṉing yulgungili ralalmirri, nguḻikima nyani guḻdjiliban, ga nyanngang kamulpili inydjin buṉḏirrdji rangirri ga gaṉḏi inydjin galdirrdjini. Ga waḻirr ngidjirrkngban mungan inydji yirrpini kiriny. Yarim ngunung bildjirri bilakiṉing miyilkpili bi djin giri ralalili gapi djin marrgi. ");
INSERT INTO dji_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ga Abrayamang djamagiṉing inydji galwupiṉi kamulngir, girri bumirigiṉdjiliban Yawaygi, nyani inga bindjin, “Yaway, Miligidji ngirrang bunggawagi Abrayamgi marrngirriyban: bina djini'djining maṉngibirri nyuni irra mil-ḻirrpigi nyim ngunupilang djangunygiṉing, marrga irr marnggidjidji wirinyi miyilknyi nyuni inga manyangiṉi Yisakgi. Miri bilapilang nyuni inga mil-bulanggitjdjidji Abrayamgi ga inga gunggatjigi ngirrang bunggawagi. ");
INSERT INTO dji_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ngarri djiḻi irr djirridji ralalmirri irr bumiri-bargi bilakiṉing bildjirri miḏipiḻipili djingirapibi gurrbibi bi djin giri marrga gapi djin marrgi. ");
INSERT INTO dji_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ga ngunukiṉing wurpm yulgung, ngarri ingarr bir-kiri ga butjalmidji miri bilapilang gam': “Bina manymak nyuni irra djirrdjirrdjigi nyungung dandanga marrga gapiban irr ḏirradjigi?” Ga ngunubilang ngunukima miḏipiḻi irra bintjiban, “Ngiy manymak, ḏirradjiw, ga gapi irr marrgi ga djinarr gungban kamulgi malagi nyungung girrigima,” irr djiringilgiban bilang miri ngunukima miḏipiḻi nyani miri yirryirrpinirbi miyilk nyungupibi, marrga nyungung djamagiṉing yul Yisak nyani marrgi ngunukima miyilk miri nyanimngim inga. Bilapilang irr marnggidjidjiban miri nyuni inga mil-bulanggitjdjini Abrayamgi ngirrang bunggawagi.” ");
INSERT INTO dji_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Nyani mukdjili, girri giḏigiḏapmban nyani Ribika yulgungiliban gurrbingir miniginy kiriny dandanga bapimirri nyanngar. Ga ngunung miḏipiḻi Ribika nyani miri walkiringim Bituwilang, ngunung yul budjirribi Milkabi - ngunung nyanimngim Nayurang, ga Nayur nyani miri Abrayamang gulmingim. ");
INSERT INTO dji_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Yarim ngunukima miḏipiḻi nyani miri mirrpmi djal-maḻimaḻing, bil wirr inga minitjingim miri, yarim nyani djuburr bulanggitj nyininy giriny. Manymak, nyani djundirrdjini gapili, butirrdjini dandangany, girri walminiban. ");
INSERT INTO dji_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Ga ngunukima djamagiṉing yul inga ṉunydjirrali ga inga bindjin, “Bina buṯal miri ṉinini gapi irr ḏirradjigiban nyungur dandangadji?” ");
INSERT INTO dji_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","“Ngiy, ḏirradjiw!” nyani bumir-wubirdjili, girri giḏagiḏapm inga djirrdjirrdjili dandangany, girri gumbirridji gatjini kiriny bilakiṉing nyani ḏirradjny kiriny. ");
INSERT INTO dji_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Rirringir nyani ḏuḻpidjini, ngunukima miḏipiḻi inga bindjinban, “Kamulgi malagi nyungung djinarr marrgiban gapi marrga djin ḏirradjigi ga djin ḏuḻpidjidji girri.” ");
INSERT INTO dji_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Girri nyani djuḻuḻupmiyngili dandangany ngunyili djapiḏili maypalang, girri wiṉini gapili, butirrdjini, girri bapiḻi minali ga madjirri djuḻuḻupmiyngili djuḻuk ṉambiḏili djapiḏili; girri bi'bininy ngurrgima mi'miniginy kiriny gapi yarimipm kamulpili djin ḏuḻpidjini. ");
INSERT INTO dji_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ban Abrayamang djamagiṉing dja'djarrinyi nyi'nyanyi ngunukima miyilknyi, nyani mukny djarriny yungaṉ yarimipm nyani marnggidjini ngunubilang nyani Yawaydji inga djamadjili manymakdjili, u ngunubilang ingki. ");
INSERT INTO dji_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Rirringir ngunuwili kamulpili djin guḻdjili ḏirradjnyirngir, ngunukirri yuldji djarrdjinginiban wurpm gold ring, girri ngurr-rangirri; girri marrngili bingili gold mala biṯma nganybak, girri guṉdjarrmirri biliny galwupiṉi nyanngar, miri mundjarr mala nyanki Ribikagi. ");
INSERT INTO dji_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Girri nyani inga bindjin, “Nyuni irra bultjigiban, wirang walkiringim nyuni? Bina buṯal ngildjar bala'mirri nibi ngurridji djini'djining maliri, ṉambiḏi nyungung gunydjirrgirar bala'mirri?” ");
INSERT INTO dji_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Nyani bumir-wubirdjili, “Ngarri miri Bituwilang walkiringimi, ga nyani Bituwil miri gapirringim Milkagi Nayurang nyanimngim. ");
INSERT INTO dji_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ga ngiy, nibi marrkapdjigi miri ngildjny nibi djakadjigi djini'djining maliri. Ngurrumi galbi yurryarr maypalpiligi ngu'ngurriban bala'mirri nginbilar, marrga nyuni djiny birrugi nyungung kamulpili ga djiny nibi djakadjigi girrigima nguḻi bala'mirri nginbilar.” ");
INSERT INTO dji_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Marrga ngunukima yul gupildjiniban ga bumir-kirrbili nyanngali Yaway-li, ga inga wukdjiliban, ");
INSERT INTO dji_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","inga bindjin, “Yaway nyuni wuknyirbi ngirrapibi, God Miligidji Abrayamgi ngirrang bunggawagi, nyuni ingki inga mirrbilginyir girinyir gunggatjnyirbi bunggawagi ngirrangirgi, djini'djining ga ngurrwakng. Irr marrkapdjilban Garray, irr birraldjnyirdjili djining bala' Abrayamang gulmingirangipm, ga bapiḻi djunupa nyuni irriny mil-ḻirrpini gadjigarr!” ");
INSERT INTO dji_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Rirringir ngunungir-kirri Ribika ṉunydjirraliban wiṉiniban gurrbili ngambirrgirali marrga djanguny garrwurdjigiban gurruṯigiṉingili malali. ");
INSERT INTO dji_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Manymak, Ribikang wuwngim yagirri Laban. Ngunukiṉing Ribika yulgungili bala'mirri, nyani Laban nyangiṉiban ngunukima mundjarr mala gunyirbi Ribikali, ngunung gold ring ngurrimirri wirardjingini, ga ngunung bingili gold nganybakmirrpili guṉdjarrmirri, ga nyani marrngini djanguny nyanngapibi Ribikabi bultjinirbi. Marrga nyani ṉunydjirraliban gar-gurriyilili ngunyilipm djatjali nyibirri Abrayamang djamagiṉing marrkany kiriny, djarrinyipm mungangmirri kamular nguḻi ralalmirri. ");
INSERT INTO dji_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Ga Laban inga bindjini, “Guwa, nyuni marrkapgiṉing yul Yawayang! Nyimki nyuni marrkam kirim djiḻipm? Ngarri ngurrum biri inmanydjirr bulanggitjdjiliban, biḻa inmarr rirrbili nyungki, ga djanki girrigima nyungung kamulgi malagi.” ");
INSERT INTO dji_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Marrga ngunukima yul ragiliban. Djani djin djirrdjirrdjili girri mala ga Abrayamang mundjarrpili kamulngir burringir, girri djina djin birrungili yurryarr kamulpiligi. Girri gapi djin birrungili marrga djani ṉu inydjin rurrtjirrmini bukmak Abrayamang djamagiṉing mala. ");
INSERT INTO dji_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Girri djani wali djina djin birrungili. Bil ngunukiṉing djin galwupiṉi wali birbimirri nyanngar, ngunukima djamagiṉing Abrayamang, nyani djina bindjinban, “Wirrban irr ḏirradjigi wali yarimipm ngirrang djanguny ildjanydjirr bultjigi.” “Ma'!” inga djin bindjiniban. ");
INSERT INTO dji_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Nyani ngurr-yirrpini djina wangini, “Ngarri Abrayamang djamagiṉing. ");
INSERT INTO dji_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Mirrpm galbi manymak mala nyani Yawaydji inga gupirr-gungili Abrayamgi ngirrang bunggawagi, marrga nyani rrupiya galbingakiṉing yul: ga nyanngali Goddji gungili maypal mala - miri galbi bimbi, buluki, kamul, dungki, ga ḏapmiynyirbi djamagiṉpili mala miri miyilkpili ga yulpili. ");
INSERT INTO dji_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ga ngirrang bunggawangirang nyanimngim Sara nyani inga minali yidjipili yul Abrayamgi, rirringir nyani wulgamandjini, ga ngungirki yidjipiligi nyani Abrayamdji inga gungili warrpamban galinirbi mala Abrayamang. ");
INSERT INTO dji_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Girri ngirrang bunggawadji irriny yan-kungili miri ngarri ingarr murr-rangirri bilapilang gam': ‘Ingki djingirapibi bapurrurrbi djiḻi ngu'ngurri nyuni inga marrgi nyanimngim Yisakgi, ingki djingirapibi miyilkpilibi, djiniwili Kayanayit malang miyilkpili wirapilar lim nyini girimban. ");
INSERT INTO dji_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Bil nyuni wiṉidjiban ngunyili ngirrali gurruṯigiṉingirang gurrbili, ga djinanydji garrkarrpigi ngirrang gunydjirrgirang malagi, girri djanngapibi nyuni inga marrgiban nyanimngimi Yisakgi ngirrang walkiringirgim.’ ");
INSERT INTO dji_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Girri ngarri ingarr wangini bunggawagi, ingarr bindjin, ‘Nyaliki irr marrgi miyilk inga ngunubilang ngunung miyilk irra ingkidjigi ga nyani ngirrinyi ingki irriny gurrpigi bapiḻi?’ ");
INSERT INTO dji_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Nyani irra bumir-wubirdjili, ‘Nguṉi Yawaydji nyin gunggatjigi; nyanngamirrpm gadjigarrmirrpm ngarri ingarr rum-gurrpin giriny, marrga nyani bi yani nyanngang djamagiṉing wugiḻi ga ngunukima wugiḻi inma ngurrgiḻidjidjiban marrga inma djamadjigi manymakdjigi, marrga ngirrangir gurruṯigiṉingir nyuni bi inga gangi nyanimngimi nyanki ngirrangirgi walkiringirgim, miri ngunukima nyuni marrgi djanngapibi ngirrang gunydjirrgirangpibi malabi. ");
INSERT INTO dji_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Bil ngunubilang djani nyin djin bir-yirrpigi, marriban bilang, nyuni yarangdjidjiban nyungungir murr-randinirbingir.’ ");
INSERT INTO dji_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Ga djuli irr yulgungili djatjamirri, ngunukiṉingban ingarr bindjin wangin Yawaygi, ‘Yaway, Miligidji Abrayamang ngirrang bunggawangirang, ngunubilang nyuni birral irriny gunggatjigiban, djining ngirrang ginginyirbi: ");
INSERT INTO dji_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Djinimirri irr marnggidjidji nyim miyilk yirryirrpinirbi nyungupibi. Djiḻi djatjamirri munganmirri irr djirridji bilakiṉing miḏipiḻipili bi djin giri gapigi. Ga djiny irr butjalmidji, ‘Way, bi irriny guw gapi ṉinini nyungur dandangadji.’ ");
INSERT INTO dji_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Ga wiḻi ngunupilang wurpilim miyilkdji irra bumir-wubirdjigi miri bilapilang gam': ‘Ngiy, ḏirradjiw, ga ingki nyuni ngiḏawa bil nyungung kamulpilingir girrigima, djankiban ngarri djinarr marrgi gapi,’ nguṉitjini miyilkdji ngarri irr djiringilgiban miri ngunukima nyuni yirryirrpini inga walkiringirgim ngirrang bunggawangirang.’ ");
INSERT INTO dji_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Rirringir irr mukdjili wanginyirngir guṉgimirri, giḏagiḏapmban Ribika yulgungiliban, dandanga miniginy kiriny bapimirri. Nyani butirrdjini dandanga ga wiṉiniban, girri ngarri ingarr bindjin, ‘Way, bina nyuni bi irriny gung gapi?’ ");
INSERT INTO dji_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Ganydirrdji nyani djirrdjirrdjili dandangany, girri irra bindjin, ‘Ngiy, ḏirradjiw, ga ngarri gapi djinarr marrgi kamulgi malagi nyungungirgi.’ Ngarri irr ḏirradjiliban, ga nyani girri djina gungili gapi kamulpiligi. ");
INSERT INTO dji_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Ngarri irr butjalminiban, ‘Wirang walkiringim nyuni?’ Ga nyani irriny bumir-wubirdjili, ‘Ngarri Bituwilang walkiringim, ga ngunukima Bituwil nyani djining Nayurang walkiringimi, ga Nayurang nyanimngimi djining Milka.’ Girri ngarri marrngili ngunukima gold ring, girri irr ngurr-rangirriban, ga irr yirrpini ngunupili nganybakmirrpili guṉdjarrmirri nyanngar miniginy. ");
INSERT INTO dji_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Girri ingarr gupildjini Yawaygi ingarr marrkapgiṉdjiniban, ga irr bumir-kirrbili Yawaynyi, ngunukima Miligidji Abrayamang ngirrang bunggawangirang, gima ṉu-piḏipiḏing nyani irriny guṉdjirr-katjidjini bapiḻipm, marrga djinim miyilk irr marrgiban, ngirrang bunggawangirang gurruṯigiṉingirang yidjipili, ga ngunyili djinim irr gangi inga Abrayamang walkiringirgim. ");
INSERT INTO dji_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Manymak, ngunubilang ngildji birral ingildji marr-bulanggitjdjirri ngirrang bunggawagi Abrayamgi, ga ingildji mil-yilgidjirriban marrga ildji yitjidjidji, djinipan irriny ildji butjirigiṉdjiwi, bil ngunubilang ingki ildji yitjidjidji, djinipan irriny ildji butjirigiṉdjiwi, marrga irr marnggidjidjiban nyalimirri irr giriban.” ");
INSERT INTO dji_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Girri nyani Laban inga bumir-wubirdjili Abrayamang djamagiṉingirgi, “Yawaydji nyanibipm ngurrum yirryirrpini Ribikany, ingki nibi ingkidjigi, ga ingki nibi yitjidjidji; nyanngarki ngurrum rindilali marrga nibi wirr-pultjigiban. ");
INSERT INTO dji_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Nyungur gumbirrmirri nyani Ribika nyini girimban, baḻpiri nyuni gangban, marrga nyani ga nyungung bunggawangirang walkiringimi inydji bil marrgi, miri nyani Yaway inmila bultjidjiniban.” ");
INSERT INTO dji_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ngunukiṉing Abrayamang djamagiṉing yul djina marrngini djanngang guṉgi, nyani bumir-galmini munatjali birbimirri Yawayar. ");
INSERT INTO dji_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Girri nyani inga djarrdjinginiban galbi mundjarr mala, miri gold, silba (silver), ga wurpi wurpi mirikal mala, girri inga gungiliban Ribikali. Ga nyani biliny gungili mundjarrpili Ribikang wuwngimi ga ngambirripm bilingga girri. ");
INSERT INTO dji_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Girri djani djin ḏirradjiliban wali ga maypal, ngunukima djamagiṉing yul Abrayamang ga nyanngang gunggatjnyakiṉpili; ga nguḻi bala'mirri djin yakirr-ngurrinyiniban. Manymak, maliri-gunyirri inydjin waykungili, girri Abrayamang djamagiṉing djiny butjalmini, djina bindjin, “Bina ildji yitjidjidji miri nibi wiṉidjiban nyanngali ngirrang bunggawali?” ");
INSERT INTO dji_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Ga Ribikang ngambirri ga wuwi biling inga bil bumir-wubirdjili, “Biḏak, marri giḻiwiḻing nyani nyinidji djiḻikima nginbilar, marri 10 yakirripili u bilapilang, rirringir ngunungir-kirri minydji ildji giriban.” ");
INSERT INTO dji_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Bil nyani djina bindjin, “Ingki irriny ildji watjarrdjigi, ngarri miri irr giri gima Yawaydji irra djamadjili manymakdjili. Bina ildji yitjidjidji miri nibi wiṉidjiban nyanngali ngirrang bunggawali?” ");
INSERT INTO dji_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Girri djin bumir-wubirdjili, “Inga lim witjigiban ngungirki miḏipiḻigi bapiḻi, girri nyaninyi lim butjalmidji nyim guṉgimirri ngurriban nyanngar.” ");
INSERT INTO dji_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Marrga inga djin witjiliban Ribikagi, girri inga djin bindjin, “Bina nyuni djiny yaṯi-nyangban marrga djini'djining ngildji minydji ildji giri?” “Ngiy,” nyani djina bindjin. ");
INSERT INTO dji_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Marrga djani djina djin bubudjili Ribikagi ga nyanngang djakadjnyakiṉingirgi miyilkigi, ga Abrayamang djamagiṉpiligi. ");
INSERT INTO dji_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Girri djanguny mayaligiṉing manymakgiṉing inga djin wanginban Ribikagi, inga djin bindjin, “Nyuni mala-pungban yidjipilpili galbi mirrpmban. Ga nyungung mala-punyirbi djin djamigi gurrbipili djina nguy-margiṉpilngirang malang.” ");
INSERT INTO dji_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Rirringir ngunungir-kirri, Ribika ga nyanngang djamagiṉing miyilkpili djani djin baltjili ngunyili kamulpilili burrili, girri minydjin giraliban, Abrayamang djamagiṉing ngurrwakng, ga djani yilimirri gurrpini kiriny. Miri bilapilang ngunukima djamagiṉing yul marrngili Ribikany, girri wiṉiniban. ");
INSERT INTO dji_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Manymak, bilakiṉing bildjirri djani bilaypm djin gupidjny kiriny, nyani Yisak yilitjini wurpili gurrbili. Nyani wiṉini ngunungir gurrbingir Biya-Laray-Ruyngir, ga inydji yirryirrpini gurrbimirri Nigip, girri nguḻiban djina marrkany giriny. ");
INSERT INTO dji_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ga wurpm balnggili, miri yabuḻu bildjirri, nyani Yisak gukirrinyi murrurrtmirrpmi. Nyani milingili, girri djiny bumiri-nyangiṉi ngunuwiltji kamulpili bi girim nyini. ");
INSERT INTO dji_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ga ngunukiṉing nyani Ribika mildji bipiṉi Yisaknyi, nyani inydji nguli burringir kamulngir, ");
INSERT INTO dji_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","girri butjalmini nyaniny Abrayamang djamagiṉing, “Bilang ngunumi, wari ngunung yul bi inmila girim nyini yurryarrmirrpmi?” “Ngunukima yul ngunung ngirrang ngurrḏawalangu,” inga bindjin Abrayamang djamagiṉing. Marrga nyani Ribika ngagirrdjini ngurri ga rarri nyanngar mirikaldji, gima ngunung miri rum mayaligiṉing miyilkigi bilapilakiṉing bildjirri. ");
INSERT INTO dji_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Manymak, Yisak ga Abrayamang djamagiṉing biling inydji bil birmirrpilidjili, girri ngunukima yul inga bultjidjini djanguny miri nyalikidjini nyani birraldjnyirdjili Ribikany, ga nyim birraldjini, ga bilapilang. ");
INSERT INTO dji_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Rirringir ngunungir-kirri nyani Yisakdji gangiliban Ribikany nyanngali wiṉiṉli. Ga biling bil djabir-kurrkungiliban, ga ngunungir yipi nyani Yisak mirrpm inga marr-bulanggitjdjini Ribikagi. Ga ngungirapibi marr-bulanggitjnyirbibi nyani Yisak ḻaydjiliban wargugungir, gima ngurrwakng nyanngang ngambirringim Sara nyani wirrdjini. ");
INSERT INTO dji_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Biligi, rirringir Yisak bungtjili, nyani Abrayam marrngili wurpi miyilk, biṯma nyanimngimi bil miri djamagiṉing inga, ga nyanngang yagirri Kitura. ");
INSERT INTO dji_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ga djiniwili Abrayamang yidjipilpili miri yulpili mala nyanngapibi Kiturabi budjirrbi, gam': Djimran, Djuktjan, Midan, Midiyan, Yitjbak, ga Djuwa. ");
INSERT INTO dji_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Ga ngunukima Djuktjan nyani walkiri-marrngili Djiba ga Didan. Ga Didan mala-bipiṉi warrngguwili bapurrurrpili gam': Atjurim mala, Litutjim mala, ga Liyumim mala. ");
INSERT INTO dji_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Ga djiniwili Midiyanang walkiriwilingim yul mala, gam': Yipa, Yipir, Yanuk, Abida, ga Yilda. Bukmak djiniwili yulpili djani ngunung Kiturang mala-punyirbi. ");
INSERT INTO dji_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ga nyani Abrayam djiny djakadjili bukmaknyi nyanngang yidjipilpili. Nyani yan yirrpini marrga rirringir nyani wirrdjidji nyanngang yidjipili Yisak nyani marrgiban warrpam girrpili gunydjirrgirang. ");
INSERT INTO dji_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Bil djanki, ngunuwiliny wurpipiliny yidjipilpiliny djiny djin minali djamagiṉpilingir miyilkpilingir, nyani Abrayamdji djina gungili mundjarr mala gaṉḏi-girrpili nyanngang, bilakiṉing nyani wanngipm nyininy kiriny, girri nyani minydjny yanali wurpili gurrbili djimurruli, marrga nguḻi minydjin nyinidji giriban rarrmaḻipm bilayngiri Yisakngir. ");
INSERT INTO dji_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Manymak, nyani Abrayam gatjidjini 175 gunmal ga rarranydjarr, girri nyani wirrdjiniban. Ngunukiṉing nyani wirrdjini, nyani ngunung mirrpm bir-gayping yul, ga marrkapgiṉing, ga guṉmal galbingakiṉing. ");
INSERT INTO dji_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Ga nyanngang walikiriwilingim Yisak ga Yitjmayil biling bil djalirngili Abrayamnyi mulumirri miringmirri, ngunung miring nyani Abrayamdji bayimdjili biligi ngunungir Yiprunngir, ngunung yul djanngang Yitayit malang, ");
INSERT INTO dji_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","yarim Abrayamdji bayimdjili ngunukima gurrbi djanngangir Yitayit bapurrurrngir. Ga nguḻi miringmirri nyaninyi bil djalirngili ngurrinyi mungangmirri Sara nyanngang nyanimngim, yarim biribiri Abrayam ga Sara bil ngurrinyi wurpilipm. ");
INSERT INTO dji_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ga rirringir Abrayam wirrdjini, nyani Goddji djakadjili Yisaknyi nyanngang walkiringimi. Ga nyani Yisak inydji yirryirrpini ngidjirrkng gurrbimirri Biya-Laray-Ruy. ");
INSERT INTO dji_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Djining ngunung gurruṯigiṉing gadjigarr Yitjmayilang, nyani miri Abrayamang walkiringim, ga ngambirringim inga Yagar, ngunukima Sarang ḏapmiynyirbi djamagiṉing miyilk wirinyi Abrayamdji marrngili djawalmirri Yidjipt. ");
INSERT INTO dji_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ga djiningi ngunung Yitjmayilang walkiriwilingim yagirrpili muṉḏaṉdji, gam': Nibayut nyanngang miḻimiṯi, girri Kidar, Adbil, Mibsam, Mitjma, Duma, Masa, ");
INSERT INTO dji_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Yarad, Tima, Djitur, Napitj, girri Kidma nyanngang djirrakay. ");
INSERT INTO dji_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ga djiniwili 12 walkiriwilingim Yitjmayilang djani djin ngurrḏawalangudjini buṉḏurrgi 12-gi, ga djiniwili yagirrpili djani miri yagirripili buṉḏurrgi, ga yagirripili gurrbigi nyibirri ngunuwilikima ngurrḏawalangupili inydjin yirryirrpini wurpirri wurpirri gurrbiwi. ");
INSERT INTO dji_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ga nyani Yitjmayil wurrungdjini, ga nyani gatjidjini 137 guṉmal ga rarranydjarr, girri wirrdjiniban. ");
INSERT INTO dji_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Bil nyanngang walkiriwilingim djani djin barrkirrdjini wurpili wurpili gurrbili, miri ngunungir gurrbingir Yabilangir ngunung gurrbiwi ngidjirrkng Yidjipt djawal, ga ngunyili Atjiriya (Assyria) gurrbili, ga baṉim galbi gurrbipili. Bil ngunuwili walkiriwilingim inydjin nguy-margiṉdjini djanibinydjin, marrga gamuṉunggupilingir djiny djin bumir-baḻpiny giriny wurpipili djanngangpibi gurruṯigiṉing djuwinapili, djiny djin bininy giriny ngurrgima. ");
INSERT INTO dji_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Djinipan Yisakang djanguny, walkiringim Abrayamgi. A djiniwili nyanngang gurruṯigiṉpili: miri Abrayam nyani gunydjirrngim inga Yisakgi, ");
INSERT INTO dji_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","a ngunukiṉing nyani Yisak gatjidjini 40 guṉmal a rarranydjarr, nyani mungan-miyilkgiṉdjiniban. A nyanngang nyanimngim yagirri Ribika, gaḻitjirringi ngungirki yulgi Bituwil ngungirapibi Aramiyan bapurrurrbi, a Yisakdji marrngili ngunukima miyilk ngunungir gurrbingir Padan-aram. A Ribikang wuwngim yagirri Laban ngunung Aramiyanbi bapurrurrbi yul. ");
INSERT INTO dji_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Manymak. Nyani Ribika giḻiwiḻing nyininy giriny yidjipilinyirring, gima budjirr-djumiḻidjini. Girri Yisakdji nyani inga butjalminiban Garraynyi nyanimngirgim, yarim yidjipilngiriny nyani marrgi. A nyani Garray inga marrngini, a yitjidjiniban. Marrga ngunungiri nyanimngim inga gapaḻmirrpilidjiniban. ");
INSERT INTO dji_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Bil nyanngar yarrmirri ngunupili yidjipilimirrpili biling galng inydji bil ngurrginy kiriny, miri inydji bil birrirrpirrirrdjny kiriny budjirrmirri nyanngar. Girri bilngirang ngambirrngim bindjin wanginban, “Ngunubilang miri bindjirr ngurrgima irr djalgidjirri kirim, nyimkiban bilang irr wanngi nyinidjipmban?” Marrga ngunyili nyani girali djuyuli gurrbili, girri nguḻi Ribikadji butjalminiban Garraynyi nyimki djining gunyambi nyanngar budjirrmirri. ");
INSERT INTO dji_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Girri nyani Garray inga bultjidjini djinikima djanguny, “Nyungur yarrmirri bingili yidjipilimirrpili bil ngurri kirim. A biling inydji bil bum kirimban, yarim bilapilang miri bingili bapurrurrmirrpili inydji bil ngurrparim kirim nyungur budjirrmirri. A bilingapibi yidjipilibi bingili bapurrurr inydji bil ngurri. Bil wurpilim bapurrurrdji nyani bangirigi ngunukima wurpi, miri nyungung miḻimiṯang mala djani djina djin djamagiṉdjidji nyungung djirrakaygi malagi, bilapilang.” ");
INSERT INTO dji_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Guyumi nyanngang waḻirr yulgungili yidjipiligi, a bingili yidjipilimirrpili yulmirrpili biling bil bungtjiliban. ");
INSERT INTO dji_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ngunung ngurrwagiping yidjipili bungtjili, a galngi inga marri buḏibuḏigili, a giḻingkaḻ inga guyilibiṉi galkngu miri nanikut, marrga gunydjirrngirim yagirr-yirrpini ngunukima Yisuw (Esau), gima ngunung yagirri mayali miri ‘mapaḻbiṉi’. ");
INSERT INTO dji_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Rirringir ngunungir-kirri ngunung yilaping yidjipili bungtjili, a nyani gumbirrdji gatjini kiriny wuwngim ṉu-punyan. Marrga ngungirinyi nyani Yisakdji yagirr-yirrpini nyaniny Djakup, gima djining yagirri a ngunung yan ‘ṉu-punyan’ bimbi bilingga wurpilipmili. A bilngang gunydjirrngirim Yisakdji ngurrum gatjidjini 60 guṉmal ngunukiṉing biling yidjipilimirrpili bil djawal-gingini. ");
INSERT INTO dji_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Manymak, biling yidjipilimirrpili bil djurrali, a bil yuldjini. Ban Yisuw nyani djambatj yul maypilgi, bininy giriny ngurrgima maypilgi galnggalngdjny girinyi, a gar-gurryili murrurrtmirri gukirriny giriny, bilapilang nyanngang rum. Ban Djakup, nyani bugiṉingi a mundurrpi yul, yarim bininy giriny ngurrgima bi nyininy giriny gurrbiwi ṉambiḏi wiṉiṉmirri. ");
INSERT INTO dji_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Ban Yisak nyani mirrpm marr-bulanggitjdjini Yisuwgi, gima nyani galng-bulanggitjdjini nyadji ngunupilang maypilpilngiriny ḏirradjim kirim ngunuwili Yisuwdji bipiṉi; bil nyani Ribika inga marr-bulanggitjdjini Djakupki. ");
INSERT INTO dji_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Wurpilim waḻirrdji, bilakiṉing Djakupdji miṉitjigiṉing gidjirri batjini kiriny, nyani Yisuw wiṉiniban gumbaḻa maypilngiri, ngal-buṯdjiliban mirrpmi. Nyani ragiliban wiṉiṉili nyibirri gulmingim nyininyi, ");
INSERT INTO dji_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","girri inga bindjin, “Irr bali kirim waligi, bi irriny kuw nyibi djinimkima buḏibuḏigili gidjirri nyuni batjin kirimban.” (Bilapilangdji wurpi yagirri Idum (Edom) djin yirrpini nyaninyi, gima ngungirang bimbi miri ‘buḏibuḏigili’ djanngamirrpmi yanmirrpmi.) ");
INSERT INTO dji_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Nyani butjalmini waligi, bil nyani Djakupdji bumir-wubirdjili, “Biḏak, miḻimiṯi nyini gunydjirrgirang, a ngunukiṉing nyani balidji ngili il rarri-gaypigiban nyim ngunupilang mala nyani gatjigi djiḻikima. Miri nyuni marrgi galbi gima miḻimiṯi inga, bil ngarri yarim marri warrngguwili irr marrgi nyanngangir, bilapilang nginmilang rum inmila bultjinmi. Marrga ngurrwakng ngarri nyirr gungi djinimkima wali, nyuni miri yitjidjidji miri ngirrarki irr galiki bukmak girripili mala nyuni guyum ngunupilang marrgi gunydjirrngir rirringir nyani wirrdjidji. Bilapilang il bumir-tjamigi.” ");
INSERT INTO dji_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Girri Yisuw inga bindjin, “Ngiy manymak, ngarri djini-kuyimban irr balidji, bil djining miḻimiṯang rum ingkiban irriny gunggatjigiban djini'djiningkima! Irr yitjidjini miri nyuni galiki bukmak ngunukima girri mala.” ");
INSERT INTO dji_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Girri Djakup inga bindjin wanginban, “Biḏak, ngurrwakng nyuni irriny murr-raniban, miri maṯiṯ murr-randinirbi irriny kuw marrga bukmak ngunukima mala irr galiki yirrimban.” Girri nyani Yisuw murr-rangirriban, a bilapilangdji nyani djilimdjili Djakupali warrpam nyanngang buṯal mala guyumpiligi. ");
INSERT INTO dji_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Rirringir ngunungir Djakupdji nyaniny gungiliban nyibi wali a nyibi gidjirri. Girri Yisuwdji ḏirradjiliban, inydji waykungili, girri gubiniban wiṉiṉngiri. Bilapilang Yisuwdji ngaminyi-bultjidjiniban ngunukima manymak rum miḻimiṯang. ");
INSERT INTO dji_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Djinipan wurpi djanguny Yisakbi, ngunukiṉing djawalmirri Kananmirri bukmak yulpili djin nguy-walinyirringdjini gima mayurrknyirringi giḻiwiḻingi djin nyininyi. A djining wurpi djiningkima walinyirring bilidjirri, ingki ngunung ngurrgima walinyirring bilidjirri miri biligi bilapilakiṉing Abrayamar bilidjirri, biling rarrmaḻipm. A djining djanguny birraldjini rirringir Abrayam ngurrum balini, a ngunukiṉing Yisak ngurrum mungan-miyilkgiṉdjini, bil nyanimngim inga nyani biḏak gapaḻmirrpilidjnyiri. Yisak a nyanngang mala ngalbirki djin nyininy giriny, marrga nyanngali minydjin girali Abimilikili ngunung ngurrḏawalangu yul Pilitjayingi bapurrurrgi nguḻi Girar gurrbimirri nyininyi gurrpuḻumirri ngidjirrkng gapi djalkng. ");
INSERT INTO dji_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Miri Goddji Yawaydji ngurrum inganydji mil-ḻirrpini Yisakgi a bindjin inga wanginban, “Ingki ngunyili nyuni giri Yidjiptili djawalili; bil ngidjirrkng nyuni gurrbidjigi nyibirri ngunupilangmirri ngarri gurrbi inmarr bultjigi. ");
INSERT INTO dji_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Yarim nyuni bar-kalikiban nguḻikima ngunung ngurrgima gurrbimirri, a ngarri inmarr djamadjigi a nyirr gunggatjigiban. A djiniwili gurrbipili nyuni djiny nyami ngarri djinikiwiliny nyirr gungi, miri nyunguli a nyungung mala-punyirbili. Bilapilang ngirrang djanguny ngarri inmarr birraldjnyirdjigi, ngunung yan ingarr murr-rangirri ngurrwakng nyungung gunydjirrgirki Abrayamgi. ");
INSERT INTO dji_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","A nyungung mala-punyirbigi ngarri djinyirr galbidjnyirdjigi miri guḻukng wana bilabilang miri ngunuwili gatapili giṉimbirrimirri dji'tjarri mala, a nyungung mala-punyirbi djin marrgi bukmak djinikiwiliny djawal mala ngirrangir gumbirrngir. A bilapilangibi nyungung mala-punyirbibi, bukmak bapurrurr mala djiḻi munatjamirri djani djin marrkapdjidji. ");
INSERT INTO dji_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","A warrpam djiniwiltji manymak mala ngarri inmarr bultjidjini, djani yirrimkima djin birraldjidji, gima nyani Abrayam butjirgiṉdjini ngunukiṉing irr witjili nyaninyi, a ngirrang yan nyani gatjidjiniban, miri ngirrang yan-kunyirbi mala, ngirrang rum mala, a ngirrang raypirri mala.” Bilapilang God inga bindjinban Yisakgi. ");
INSERT INTO dji_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Marrga nyani Yisakdji yalkuy gurrbidjili nguḻi Girar gurrbiwi. ");
INSERT INTO dji_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Bilapilakiṉingi ngunitjini Girarmimigi yulpilingir maladji djin nyangiṉi nyanimngim inga, girri nyaninyi djin butjalminiban miyilkibi, inga djin bindjin, “Djinim wari?” A nyani djina bindjin wangin, “Nyani gaḏingim irra,” gima nyani yawngini djina bintji wangidji, “Djinim ngirrang nyanimngimi.” Miri nyani gingini, “Mayalimirrpm ngarri djinarr wangidji, bintji yulpili mala djingirapibi gurrbibi djani irriny djin bungban, marrga Ribikany djin djamigi, gima djal-maḻimaḻing mirrpmi nyani.” ");
INSERT INTO dji_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Manymak, rirringir Yisak ngurrum nyi'nyininyi nguḻi marri giḻiwiḻingi, nyani Abimilik nyininy kiriny ṉambiḏi nyanngar bala'mirri, a milakngir nyani miniminirngili, girri Yisaknyi nyangiṉiban ḏutjny kiriny nyanngang miyilk Ribikany. ");
INSERT INTO dji_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Marrga rirringir ngunungir-kirri nyani Abimilik inga witjili Yisakgi, a ngunukiṉing nyani inga yulgungili, girri Abimilik inga bindjin, “Ngunung miyilk yirrimkima nyungung nyanimngim marri! Nyimki bindjini nyuni irra wangini, ‘Nyani djining ngirrang gaḏingim’?” Girri Yisakdji nyaniny bumir-wubirdjili, “Ngarri bindjin inmarr wanginban gima irr gingini miri inydjirr marrbigi wanngingir marri, bilang wari ngunupilang inga budjirr-djalngdjidji.” ");
INSERT INTO dji_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Girri nyani Abimilik inga wanginban, “Bina nyuni djiringini nyabinakiṉing mari nyuni bapiḻi gangi nginbilangi? Bilang wurpilim yuldji djingirapibi nyani waymirri ngurrinyir nyungur miyilkdji, wana mariban inbiliny barinyirban, miri nyungungpibi murkunyirbibi!” ");
INSERT INTO dji_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Marrga Abimilik djiny yan-kungiliban bukmaknyi yulpilngiriny nyanngangi, nyani djina bindjin, “Bilngiriny lim gubidji djingiriny yul a nyanngang nyanimngim. Marrga wiḻi ngunupilang gumbirrdji bilngiriny mal-djatdjigi, yirrimban nyaninyi minydji lim raniban, a nyani balidjiban.” Girri Abimilkdji mil-pultjidjini Yisaknyi, girri nyani Yisak gurrbiliban wiṉiniban. ");
INSERT INTO dji_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Rirringir ngunungir-kirri nguḻi Yisakdji miṉitji ḻamudjili munatjamirri wurpirri-wurpirri ngidjirrkng nyanngar gurrbimirri, a djampan rirringir ngunung wali djurrali nyani djarngili a gurtjili mirrpmi galbi wali ngunung ngurrgima guṉmal, gima Yawaydji manymakdjili djamadjili inga. ");
INSERT INTO dji_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Miri Yisakdji ma'marriny kiriny girri mala a maypal mala bininy kiriny ngurrgima, yarimipm nyani rrupiya-galbingakiṉdjiniban. ");
INSERT INTO dji_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Miri mirrpmi galbi mala nyani gatjidjini galkngu maypal bimbipili, bulukipili, a djamagiṉpili mala. A bilapilangirgi ngunitjini Pilitjayin mala djani ngurr-yirrpiniban nyaninyi djin mil-ḏinytjiliban. ");
INSERT INTO dji_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Marrga gunyambiban djin ngamangamadjili Yisakgi. Miri ngurrwakng bilakiṉing Abrayam bilidjirri, Abrayamang djamagiṉpilingir djani djin gamirrdjini gapigi wurpirri-wurpirri gurrbipilimirri ṉambiḏi ngunung ngurrgima djawalmirri, a girrkiḻing djin manyangiṉi nguymirri munatjamirri, girri ngunungir waḻirrngir ngunuwili ngambuḻ mala minydjin dji'tjarrinyipm, miri mani-girrirrkgiṉpili djani. Manymak, Yisakgi djani mari djin djamadjili djinimirri; yarim bubalikiṉing mani-girrirrkgiṉing ralal nyanngang gunydjirrgirang djamagiṉpilingir djin gamirrdjini mala, ngunukuwiliny djani ngunitjini Pilitjayin yulpilingir djiny djin ngurri-barngiliban djaltjiri, bilapilangdji djin miṉibili ngunuwili ngambuḻ ralal mala, a djiny djin mirgidjnyirdjiliban Yisakgi. ");
INSERT INTO dji_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Girri nyani Abimilikdji bulu-nguliban Yisaknyi, nyani inga bindjin, “Nyuni miri minydji yilitjirrdji nginbilangir, gima nyunung mala ngurrum djin galbidjini miri giḏidjirringi, ildji bir-maṯiṯdjiniban nginbilangi.” ");
INSERT INTO dji_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Marrga nyani Yisak wurpili gurrbili yilitjiniban marri bilay Abimilikngir, girri gurrbidjili budjirrminy gapinyirring manimirri, yarim wirr gapi wirrwirrdjnyir kirinyir gima wirrpili gurrbi ngunung, a mayurrk wirrban. A marri galbi rarranydjarr nyani nyininyipm nguḻi mani baṉḏanymirri ngidjirrkng Girar gurrbiwi. ");
INSERT INTO dji_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","A bilakiṉing nguḻipm, nyanngang djamagiṉpili nyani djiny yaniliban gapigi, marrga madjirri djin ḻapmiygi ngunukima gayping ngambuḻpili Abrayamang djamagiṉpilingir djin gamirrdjini baman pirr, ngunung ngurrgima ralalpili ngunitjini Pilitjayin maladji djiny djin ngurri-barngili rirringir Abrayam wirrdjini. A nyani djiny yagirr-yirrpini ngunuwili mani-girrirrkgiṉpili bilapilang ngurrgima miri Abrayamdji djiny yagirri-yirrpini ngunukuwiliny biligi. ");
INSERT INTO dji_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Wurpilim waḻirrdji, Yisakang djamagiṉpilingir djin gamini kiriny gapigi nguymirri ngunung mani baṉḏanymirri, a ngunung ralal wurtjiliban, girri gapi girrkiḻing buwalbuwaldjiliban. ");
INSERT INTO dji_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Bil ngunukiṉing ngunitjini maypal-djakadjnyakiṉpilingir ngungirapibi Girarbi gurrbibi djin marrngini ngunung, djiny djin yimirrdjiniban Yisakang maypal-djakadjnyakiṉing malany, a djina djin wanginiban, “Djinim gapi nginbilangipm!” Marrga Yisakdji yagirri-yirrpiniban ngunung djatja Itjik (Esek), gima djanngamirrpm yanmirrpm nguṉi mayali gatjinmi miri ‘Winytjnyirbi’. ");
INSERT INTO dji_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Rirringir ngunungir-kirri djin gamirrdjini wurpi ralal gapigi, bil madjirri ngunitjini Girarbi maypal-djakadjnyakiṉpilingir djiny djin yimirrdjiniban, marrga Yisakdji yagirr-yirrpini ngunung ngambuḻ Djitna (Sitnah), a ngunung mayali bilapilang miri ‘Ngandarrkmiynyirbi’. ");
INSERT INTO dji_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Girri nyani yilitjini ngunungir gurrbingir, a wurpi gurrbi marrngili. A nyanngang djamagiṉpilingir madjirri djin gamirrdjini ralal gapigi, a djatja djin bipiṉi. Ban djini'djining ngunitjini wurpili maladji ingkiban djin yiminirban. Marrga ngunukima Yisakdji yagirr-yirrpiniban Riyubut (Rehoboth), gima ngunung gatjidjini mayali bilapilang miri djining djanguny djin wangini, “Djini'djining waḻirr Yawaydji gadjigarr inmiliny gungiliban lim ngalwartjingilgi djiḻi, a lim galbidjidji djawalmirri djiḻikima.” ");
INSERT INTO dji_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Guyumi ngunungir gurrbingir nyani yilitjini, a walmini ngunyili bukiḻili, a yulgungili Biya-Djiba gurrbiwi. ");
INSERT INTO dji_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","A rirringir nyani yulgungili, ngunung ngurrgima maliri nyani Yaway inga birraldjiniban, a bindjin inga, “Ngarri djining Miligidji nyungung gunydjirrgirki Abrayamgi. Ingkiban yawngiyi gima ngarri nyirr djakadjim girim. Ngarri nyirr gunggatjigi, a nyungung mala-punyirbi djiny irr galbidjnyirdjigi. Bilapilang irr djamadjigi nyungungi, gima ingarr marr-bulanggitjdjini Abrayamgi ngirrang djamagiṉingirgi.” ");
INSERT INTO dji_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Girri nguḻi ngurrgima gurrbimirri nyani Yisakdji yip mutjpiningiliban rirrkiyanpili, marrga bumir-kirrbigi Garraynyi, a nguḻikima nyani inga bumirgiṉdjini Godki nyanngamirrpm yagirrmirrpm Yawaymirrpm. A nguḻi nyani wiṉiṉ yirrpini, bilakiṉing nyanngang djamagiṉpilingir djin ngurr-yirrpini djin gamirrdjini gapigi. ");
INSERT INTO dji_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Ngunukiṉing bilidjirri, Girarngir gurrbingir nyani Abimilik bi giriny nyininy Yisakili, a nyanngar nyani gangili Ayudjat (Ahuzzath) nyanngang balpirgiṉing a gunggatjnyakiṉing, a ngunukirri yul Pikul ngunung ngurrḏawalangu yulpilngirgi gamuṉunggupilngirgi Abimilikang. ");
INSERT INTO dji_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Inga djin yulgungili, girri nyani Yisak djiny butjalminiban, “Nyimkiban ngildji irriny ildji balparngili? Yarim ngurrum irriny ildji bir-yirrpini, girri irriny ildji badji-nyangiṉiban ngildjangir.” ");
INSERT INTO dji_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","A djin bumir-wubirdjiliban nyaninyi, “Nginibi yirrimban nibi djiringini nyani Yawaydji bindjirr kirim ngurrgima nyin gunggatjim girim, marrga nginbilang ginginyirbi bilapilang gam'. Miri nyungung galiy, a nginbilang galiy, inydji lim murr-raniban, lim djamadjigi maṯiṯ ṉu-yirrpinirbi miri ingki inydji lim mari-djamadjigi inydji limi. Nyuni murr-rani a ngarri, rum magaya il yirrpigiban nginmilang, miri il maṯiṯdjigiban. ");
INSERT INTO dji_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Miri nyunitja ingki inbila nguy-murmurdji giri yarim bilapilang miri nginibitja ingki inma nibi mari-djamadjnyir girinyir. Nibi bininy giriny ngurrgima inma nibi mil-biḻbaḻdjny giriny nyungungkima, a nibi mil-pultjidjini nyuniny magayadjipm. Ngiy, djini'djining a ngunyilatjuy inma nibi bir-bulanggitjdjidji gima nyuni yul marr-bulanggitjnyirbi Yawaybi.” ");
INSERT INTO dji_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Girri nyani Yisakdji maypal a wali galngarrarradjili djanngang, girri djani warrpam djin nyininiban wurpilipm, djin ḏirradjiliban Yisakang mala a Abimilikang. ");
INSERT INTO dji_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","A malipmalir gunyirri inydjin waykungili, girri biling Abimilik a Yisak biri-biri bil nyininiban, girri inydji bil murr-rangirriban inydji bili. Girri Yisakdji djiny bubudjili, girri Abimilik a nyanngang yulmirrpili djin gubiniban miri miy-baṯpirrgiṉingban djani Yisakang. ");
INSERT INTO dji_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","A ngunung ngurrgima maṉngibirri Yisakang djamagiṉpili bi girali nyanngali, djanguny inga djin birrungili gapibi gima djin malimdjili gaminirngir, inga djin bindjin wanginban, “Way! Gapi nibi birraldjnyirdjiliban!” ");
INSERT INTO dji_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","A nyani yagirr-yirrpiniban ngunukima ngambuḻ Djiba (Shibah), a ngunung mayali bilapilang miri namba 7, a bilapilangdji ngunung gurrbi nyanngang mala-punyirbili mutjpiningili nguḻikima ngunung djin bultjidjini Biya-Djiba, a ngunung ngurrgima yagirri dji'tjarri kirimipm djini'djining ngungirki gurrbigi. ");
INSERT INTO dji_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Manymak. Ban Yisuw, Yisakang miḻimiṯi, ngunukiṉing nyani gatjidjini 40 guṉmal a rarranydjarr, nyani mungan-miyilkgiṉdjiniban. Bingili miyilkmirrpili nyani biliny marrngili, yagirri bilingga Djudit (Judith) walkirngim Biyriyang (Beeri) ngunung Yitayit yul, a ngunung wurpitji miyilk yagirri Batjimat (Basemath), walkirngim Yilunang (Elon) - wurpi Yitayit yul. ");
INSERT INTO dji_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Bil ngunupili miyilkmirrpili mirikunu bili, a bilingapibi miyilkmirrpilibi biling Yisak a Ribika bil nguy-giṉirgiṉdjini wana. ");
INSERT INTO dji_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Ngunukiṉing nyani Yisak ngurrum wurrungdjini, nyani mil-djumiḻidjiniban. Wurpilim waḻirrdji nyani inga witjili nyanngang miḻimiṯigi Yisuwgi, girri inga wangin, “Walkira!” “Ngiy gunydjirra?” Yisuwdji bumir-wubirdjili. ");
INSERT INTO dji_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","A Yisak bindjin wangin inga, “Nyuni nyamban ngarri mirrpmi wurrungi, a nyadji ngunupilang ngidjirrkngban irr balidji. ");
INSERT INTO dji_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Nyuni marrgiban nyungung bow a arrows mala, girri ngunyili giri murrurrtili, a bungban maypal ngirrki. ");
INSERT INTO dji_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","A ngunukiṉing nyuni birrugi ngunung bapiḻi, batjirriban, a djamadjiwi ngunung ḻatju gidjirri ngarri djal, girri bi gangi bapiḻipm ngirrki. Rirringir ḏirradjnyirngir, ngarri nyirr gungban djanguny ngirrapibi guyumpiligi, marrga nyani God irra butjir-marnggidjidjiban, girri nyani inma birraldjnyirdjigi ngunung djanguny. Miri ngarri bindjin inmarr bultjigi ngunukima djanguny ngurrwakng irr wirrdjidji.” ");
INSERT INTO dji_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Bilakiṉing Yisak inga wanginy kiriny Yisuwgi, nyani Ribika butjir inydji guny kirinyban. Marrga bilakiṉing Yisaw bilay, ");
INSERT INTO dji_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","nyani inga wanginban Djakupgi, inga bindjin, “Yarimban irr marrngini nyungung gunydjirripm inga bultjidjini Yisuwgi miri bindjin, ");
INSERT INTO dji_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Maypal buwi, batjirri, girri irriny gangban. A rirringir ḏirradjnyirngir, ngarri nyuninyi nyirr gungban ngirrang djanguny guyumpiligi, marrga nyani God butjir-marnggidjidji, girri inma birraldjnyirdjigi ngunung djanguny. Ngarri bintji marrga God inma yitjidjidji ngurrwakng irr balidji.’ Bilapilang nyani inga wanginiban Yisuwgi. ");
INSERT INTO dji_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Bil irriny marrngirriy gapirra. Djini'djining nyuni miri bintji djamadjigi miri djining ngurrgima ngarri inmarr bultjigiban. ");
INSERT INTO dji_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Gar-gurryilili nyuni giriban nginmilali maypal malali, girri bingili nanikutmirrpili nyuni bilnyirr rindiligi, yarim yuwirdjingmirrpili guḻtjigiṉingmirrpili, a bapiḻipm bilngiriny gangban. Ngarri bilngiriny irr batjigi, irr djamadjigiban ngunung ḻatju gidjirri, ngunukima nyungung gunydjirrngim djalngdjirri wana. ");
INSERT INTO dji_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Girri ngunung wali nyuni inga gangi ḏirradjnyirgi, a nyani gingidji nyuni ngunung Yisuw, girri nyunguliban nyani gungi ngunung djanguny miḻimiṯang, ngurrwakng nyani wirrdjidji.” Bilapilang Ribika inga bindjin. ");
INSERT INTO dji_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Bil nyani Djakup inga wanginban mumngimngirgim, “Nyuni marnggi miri Yisuw nyani mapalbiṉi a guyiligiṉing, bil ngarri wirr, ngirrang giḻingkaḻ guyilinyirring. ");
INSERT INTO dji_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ngunubilang gunydjirrar irriny mal-djatdjigi gumbirrdji, nyani marnggidjidjiban ngarri mayalidji irr ngaginmi nyaninyi miri bindjirri, girri ingkiban nyani irra bultjigi djanguny buṯal bil djanguny mirkngi marrga nyani irra barranggadjigi gunyambili.” ");
INSERT INTO dji_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Bil ngambirrngirim bumir-wubirdjili, “Marriban gapirra, ngunubilang nyani barranggadjigi nyuniny, nguṉi maridji bargiban ngirrali, ingki nyunguli, gima djiningkima ngirrangipm mayali. Yarim nyuni irra butjirgiṉdjidjiban, guwu a nanikutmirrpili bilngiriny bagiligiban ngirrangi.” ");
INSERT INTO dji_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Marrga nyani Djakup giraliban, bilngiriny marrngili nanikutmirrpili, bilngiriny bipiṉi, a munydjal gangiliban ngambirrngirali. Girri ngambirrngirim batjidjini ḻatju gidjirri buṯal ganirbi, miri ngunung ngurrgima gidjirri Yisak djalngdjini ḏirradjnyirgi. ");
INSERT INTO dji_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","A Yisuwang manymak mirikal mala ngurriny kiriny nguḻikima ṉambiḏi wiṉiṉmirri, marrga Ribikadji inga marrngili nyibi mirikalpili, girri djiny yirrpiniban Djakupili nyanngang djirrakayili. ");
INSERT INTO dji_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Girri Ribikadji gumbirrmirrpili inga nyani garrpiniban giḻingkaḻdji nanikutdji marrga Djakupang gumbirrmirrpili bil guyiligiṉdjidji miri ngunung ngurrgima Yisuwang, a guraki inga nyani ngagirrdjini giḻingkaḻdji nanikutdji gurrkunyi. ");
INSERT INTO dji_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Girri ngunukima ḻatju gidjirri nyani galwupiṉi nyanngar gumbirrimirri, a dampa nyani batjidjini girrgima. ");
INSERT INTO dji_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Girri nyani Djakup minydji ragiliban nyanngali gunydjirrngirali, nyani inga bindjin, “Gunydjirra!” “Ngiy walkira, wari nyini?” ");
INSERT INTO dji_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","“Ngarri Yisuw gunydjirra, nyungung miḻimiṯi. Ngurrumban maypal irr bipiṉi miri bindjin ngurrgima nyuni irra bultjidjini. Inydji waykungban a nyinidjiban, nyuni ḏirradjigi djining maypal inmarr bipiṉi, girri rirringir ngunungir-kirri nyuni irriny gungban nyungung djanguny milbimirri Garrayar.” Miri bilapilang Djakup inganydji yulili gunydjirrngirgim. ");
INSERT INTO dji_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Girri gunydjirrngirim yanyangiṉban, “Bil nyalikidjini nyuni manyangiṉi maypal bilapilangdji ganydjirrdjipm, walkira?” Djakup bumir-wubirdjili, “Garraydji nyungur Miligidjir nyanngarki irriny gunggatjili djingiriny irr manyangiṉi.” ");
INSERT INTO dji_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Girri Yisak inga wangin Djakupgi, “Guwa, ngidjirrkng bi irra giriw marrga ngarri gumbirrdji nyirr mal-djatdjigi. Bina birral nyuni Yisuw?” ");
INSERT INTO dji_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Djapup ngidjirrgili inga giraliban gunydjirrngirali, girri Yisakdji nyaniny mal-djatdjiliban gumbirrdji, inga bindjin wanginban, “Nyungung bimbi miri galkngu Djakupang, bil nyungung gumbirrimirrpili galkngu miri Yisuwang.” ");
INSERT INTO dji_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Bilapilangdji nyani malubipiṉi Djakupnyi, gima gumbirrimirrpili biling guyilibiṉi miri Yisuw. Girri djini-kuyimban nyani Yisakdji inga gunyiri nyanngang djanguny walkiringirgim, bil biḏak, ");
INSERT INTO dji_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","madjirrtji nyani butjalminiban, “Bina birral galkngu nyuni Yisuw?” “Ngiy birralgima!” nyani bumir-wubirdjili gundjirrgiriny. ");
INSERT INTO dji_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","A Yisak inga bultjidjiniban, “Bi irra guw nyibi ngunung munydjalgiṉing gidjirri. Rirringir irr ḏirradjigi, nyungkiban inmarr gungi djanguny ngirrapibi marrga Goddji inma manymakdjigi djamadjigi guyumpiligi.” Girri nyani Djakupdji marrngiliban ngunung gidjirri, girri inga gungili, a nyani birrungili miṉim nganitji nyanngangi gurrkunyi, girri nyani ḏirradjiliban gunydjirrar. ");
INSERT INTO dji_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Rirringir ḏirradjnyirngir, gunydjirrngim inga bindjinban, “Guwa bapiḻi walkira, nyuni irriny wuṉḏigiban djal.” ");
INSERT INTO dji_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Marrga nyani ngidjirrgili inga girali, girri nyaniny wuṉḏiniban. A Yisakdji nyumirrdjiniban bunggan inga mirikalbi Yisuwangpibi, girri nyani marr-pirralkiṉdjiniban ngunung nyannang walkiringim Yisuw. Rirringir ngunungirr-kirri Yisakdji inga gungiliban ngunukima djanguny biṯma miḻimiṯigi. Nyani inga bindjin wangin, “Djining ngirrang walkiringirang bunggan ḻatju mirrpmi, bilapilang miri bunggan murrurrtbi miri ngungirapibi gurrbibi nyani Goddji djamadjili manymak nginmilang miri maypalgiṉing a waligiṉing. ");
INSERT INTO dji_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Walkira, nyani Goddji mayurrk inma yani, a munatja nyani inma manymakdjigi. Marrga ngunukiṉing nyuni djal-rani, galbi inma djurri kiriban wali. A nyuni bintji kiri ngurrgima marrgi galbi wali a gambilki miri nganitjigi. ");
INSERT INTO dji_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Yulpilingir galbibi malabi djani inma djin djamadjigi, a mulkurupilngirang bapurrurrdji maladji inma djin guṉgi-baltjigi. A nyuni djina bunggawadjidji djanngangi miri bukmakgi nyungung gurruṯigiṉpilngirgi, a warrpam nyungung ngambirrngirang mala-punyirbi mala djani inma djin guraki-gupildjidji. A nyani God inma djamadjigi djinimirri, ngunubilang wirapili ngunupilang djin manyangi inma djin rarri-wangidji, girri nyanitja djina rarri-wangidji. Bil ngunubilang wirapilingir ngunupilang nyin djin birdjigi, girri nyanitja djiny birdjigi a djiny gunggatjigi.” Bilapilang Yisak inga bultjidjini djanguny marrga nyani God butjir-marnggidjidji, girri inga birraldjnyirdjigi ngunung djanguny nyanngang walkiringirgim. ");
INSERT INTO dji_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Ngunukiṉing Djakup djini-kuyim girali gar-gurryilili, djayurrkdjurrk nyani Yisaw yulgungiliban maypalngir. ");
INSERT INTO dji_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Nyani girri gidjirri batjidjini ḻatju gunydjirrgirki, girri inga gangili. Nyani inga bindjin gunydjirrgirki, “Inydji waykungban gunydjirra, nyuni nyinidji a ḏirradjigiban djining maypalgiṉing gidjirri ngarri inmarr birrungili. Girri nyuni irra gungban ngunukima djanguny marrga Goddji irriny djakadjigi.” ");
INSERT INTO dji_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","“Wari nyini?” Yisakdji butjalminiban. “Nyungung miḻimiṯi Yisuw” nyani bumir-wubirdjili. ");
INSERT INTO dji_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Girri nyani Yisak ngurr-yirrpiniban galngi-wurrwurrtjiniban, a nyani butjalminiban, “Wiḻi bilang ngurrum bipiṉi maypal, a ngirrali irra birrungili? Irr malimdjiliban djini-kuyim ngurrwakng nyuni irra yulgungili. Ngungirki yulgi ngarri ingarr bultjidjini nyungung djanguny, a ngunung djanguny miri inga dji'djirridjipmban ngunyili yipi!” ");
INSERT INTO dji_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ngunukiṉing nyani Yisuw djining marrngini, wargugungir wanangir nyani witjiliban mirrpmi ṉami, girri gunydjirrgirki inga wanginban, “Ngirrkiban girrgima djanguny irra gungban, gunydjirra!” ");
INSERT INTO dji_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","“Bil walkira, nyungung gulmingirim ngurrum mil-gangiliban ngunukima djanguny inmarr manyangiṉi nyungki! Nyani bi irra girali, girri irra mani-wanginban.” ");
INSERT INTO dji_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Girri Yisuw inga bindjinban, “Bumiri bingilipmban nyani irriny gar-yulili mayalidji. Ngarri marnggiban nyimki nyuni yagirri-yirrpini nyaninyi Djakup, gima mayali miri bilapilang ‘waparr’ ngunukima yagirri. Ngurrwakng nyani djamirrdjini bukmak ngunung girri mala ngarri bilang irr marrgi rirringir nyuni wirrdjidji, a djini'djining nyani djamirrdjini ngirrang djanguny guyumpiligi! Gunydjirra, marri wurpmipm nyuni irra galdirrdjini ngirrki djanguny ḏambingi, ngangi?” ");
INSERT INTO dji_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Bil Yisakdji bumir-wubirdjili Yisuwnyi, “Wirr walkira, ngarri ngurrum nyaniny bunggawadjnyirdjili nyungung, a ngarri djining ingarr yirrpini miri bukmak nyanngang gurruṯigiṉpili djani inga djin djamagiṉdjidji, a ngarri ingarr bultjidjini nyani Goddji inga gungi galbi wali a nganitji, marrga nyungung wuwngim bintji kiri ngurrgima maṯiṯdjidji a ḏuḻpidjidji. Ngarri irr mirrbilali wirr nyanngangir, walkira, marrga nyalikidjidjiban djanguny wurpi inmarr manyangban djini'djining nyungung?” ");
INSERT INTO dji_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Girri Yisuwdji bumir-ḏuwaṯ bu'putjalmini gunydjirrgiriny, “Ingki gunydjirra, bil yarim ḏambingipm djanguny nyuni irra manyangban, girri irra bultjigi marrga Goddji marrngirrdji. Nyabini yarim ḏambingi nyuni bintji irra bultjigi djanguny ngirrki girrgima, gunydjirra? Marrga ngirrki wurpi Goddji irra manymakdjigi djamadjigi!” Yisuw ngadjny kirinyban. ");
INSERT INTO dji_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Girri nyani Yisak manyangiṉi djanguny, girri walkiringirgim inga bultjidjini marrga nyani God butjir-marnggidjidji girri inga birraldjnyirdjigi ngunukima djanguny. Nyani inga bindjin, “Ngunung gurrbi nyibirri nyuni nyinidji ngunukima wirrpildjidji nyunungi, wirr inma rikidji giri, a munatja inma mirgidjidji, ingki inma djurri giri galbi wali. ");
INSERT INTO dji_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Miri wapirrmirri rummirri nyuni nyinidji, a wali nyuni marrgi nyungur mandjawakdji; nyungung gulmingim nyani yagirr-wanadjidji, bil nyuni yagirr-ṉinindjidji marrga nyuni inga djamadjigi miri bintji ngurrgima nyani nyin yan-kungi. Bil guyum ngunupilang nyaninyi nyuni burrdji gungi, girri nyanngangir gumbirrngir nyuni buṯdjigiban.” ");
INSERT INTO dji_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Rirringir ngunungir-kirri nyani Yisuw nguy inga margiṉdjiniban Djakupgi, gima Djakupdji marrngili nyanngangipm djanguny gunydjirribi. Marrga nyani guṉgi inydji ngamangamadjili nyani bungi gulmigipm. Nyanibi inydji wangini, “Ngunung waḻirr nyadji inga lim ngadjidji gunydjirrgirki ngidjirrkngban bi inmila girim nyiniban, rirringir nyani wirrdjidji ngunukiṉingban irr bungban Djakupnyi.” ");
INSERT INTO dji_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Bil wari ngunupilang butjir-marnggidjini yan inga miḻimiṯang, girri Ribikany butjirgiṉdjili. Ngunukiṉing nyani Ribika marnggidjini Yisuwang ginginyirbi, nyani inga yan-kungiliban djirrakaygi Djakupgi miri nyani bi inga giri. Nyani yulgungili, girri ngambirrngim inga wanginban, “Marrngirriy, nyungur wuwar nyin ging kirimban djampan nyin rani. ");
INSERT INTO dji_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Miri bintji nyuni djamadjigiban gapirra. Djini'djining nyuni minydji ṉunydjirriban, a ngirrali wuwngirali inga giri, ngunukima yul Laban nguḻi gurrbimirri Yaran nyini kirimi. ");
INSERT INTO dji_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Girri nyanngar nyuni bar-kalikiban, yarimipm Yisaw nguy-djunggingir nyanibi inydji djanadjanadjigi, girri inma nguy-miṉgiṉdjidji, ");
INSERT INTO dji_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","a nyani marrbigiban nyaliki nyuni gar-yulili nyaninyi. Girri nyunguli ngarri irr yaniban wirinyi marrga nyani nyin bagiligiban ngunungir gurrbingir. Nyuni giriban bintji nyimilinyirr marrbigi ngirrang gapirrimirrpili wurpmmirri waḻirrmirri. Miri bilang Yisuwdji nyin bungi, wiḻi ngunupilang nyaninyi bungban gima nyani muṉingdjini, bilapilangdji waḻirrmirri wurpmmirri irr yidjipilinyirringdjidjiban.” ");
INSERT INTO dji_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Girri Ribika inga girali Yisakgi, girri inga bindjin wangin, “Wanngi irr mirgidjiniban bilingapibi ngunupili mulkurumirrpili miyilkmirrpili Yisuwdji biliny marrngili, ngarriban bilinggarr gudjirrdjirri mirrpmi. Ngunubilang djingirapibi Yitayitbi bapurrurrbi nyani Djakupdji marrgi nyanimngim, manymaktja irr balidji djini'djining bintji wanaban irr nyinidji kiri wargugugiṉing ngungirapibi miyilkibi Djakupang.” ");
INSERT INTO dji_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Girri nyani Yisak inga witjili Djakupgi nyanngang walkiringirgim. A nyani Djakup inga giraliban, girri nyani gunydjirrngim inga bir-bulanggitjdjini, girri nyanininy yan-kungiliban miri bindjin gam': “Ingkiban djingirapibi mulkurupilngirapibi nyuni inma marrgi miyilknyi, miri ingki djingirapibi Kananayitbi bapurrurrbi rindiligiw! ");
INSERT INTO dji_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Yarim ngunyiliban djayurrkdjurrk nyuni giriban Padan-Aramili gurrbili, nyuni balpargiban gaykiygiriny nguḻi gurrbiwi Bituwilang nyungung ngatjitjingim. Girri nguḻikima miyilk inma nyuni rindiligiban, bilapilang nyuni marrgi nyanimngim inma nyungupibi gurruṯigiṉpilngirapibi, miri wurpmgima Labanang walkiringim nyungung gaykiyngirang miḏipiḻi. ");
INSERT INTO dji_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","A ngarri inmarr butjalmidji Godnyi ngunung Ganydjirrgiṉing Miligidji miri bilapilang gam'. Nyani Goddji nyin gunggatjigi, marrga nyuni walkir-marrgi galbi, marrga nyungupibi wurpi-wurpi bapurrurr mala inydjin ngurriban. ");
INSERT INTO dji_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ngiy, nyaniny irr butjalmidji miri nyani nyin gungi ngunung ngurrgima murr-randinirbi nyani gungili Abrayamnyi biligi, marrga nyani inma mil-wurdjigi a nyin gunggatjigi, a djagadjigi nyungung mala-punyirbi gurrkunyi. Nyani bintji djina djamadjigi marrga djining djawal djani minydjin galikiban inydji mungbinigi, djinikima gurrbi nyibirri lim nyini girimban, djingiriny Goddji gungili Abrayamgi.” Bilapilang Yisak inga wangin Djakupgi. ");
INSERT INTO dji_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Rirringir ngunungir-kirri Yisakdji minydji yaniliban Djakupnyi nyanngang djirrakay. A nyani giraliban ngunyili Labanang gurrbili, gima Laban nyani miri Aramiyanbi bapurrurrbi yul, walkiringim Bituwilang, a Ribikang wuwngim, a gaykiy bilingga miri Yisuwgi a Djakupgi, bilapilang. ");
INSERT INTO dji_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Ban Yisuwgi, nyani marnggidjini ngunukima djanguny, miri nyaliki gunydjirrngim inga bir-bulanggitjdjini Djakupgi, a nyaliki nyani butjalmini Godnyi miri nyani djagadjigi gulmigipm bilakiṉing girim nyini ngunyili Padan-Aramili gurrbili, marrga nyani marrgi miyilk ngungirapibi. A Yisuwdji marrngini ngunukima djanguny miri nyalikidjini gunydjirrar butjir-karrdjini Djakupnyi miri bindjin gam', “Ingki nyuni marrgi miyilk djingirapibi bapurrurrbi Kananayitbi.” ");
INSERT INTO dji_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","A Yisuwdji nyangiṉi nyalikidjini Djakup bilingga butjirgiṉdjiniban gunydjirrgirki a ngambirrgirki, gima Djakup ngurrum giraliban ngunyili Padan-Aramili gurrbili. ");
INSERT INTO dji_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","A ngunukiṉing Yisuwdji djiny nyangiṉi ngunukirri mala, nyani djiringiniban nyani murkungili ngurrwakng ngunukiṉing nyani biliny marrngili ngunpili miyilkmirrpili ngungirapibi Kananayit bapurrurrbi, gima nyani nyangiṉi ngunupilingir miyilkmirrpilim bilngiriny bil nguyulkdjny kiriny gundjirrgiriny a ngambirrgiriny. ");
INSERT INTO dji_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Marrga Yisuwdji balparngili nyanngang gunydjirrgiriny Yitjmayil, a wurpi nyanimngim rindilaliban. A ngunukima miyilk nyani gaḏingimi Nibayutgi a walkiringim Yitjmayilgi Abrayamang wuwngimi, a yagirri inga Mayalat. A nyani marrngili djingiriny miyilknyi gurrkunyi rirringir nyani ngurrum biliny gatjidjini ngunupili bingili wurpiwili miyilkmirrpili. ");
INSERT INTO dji_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Manymak, nyani Djakup gubini Biya-Djiba gurrbiwi, a ḻarrban ngunyilipm Yaranili gurrbili nyaling nyani Laban nyi'nyininyi. ");
INSERT INTO dji_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Malngiri, waḻirr ngurrum mungan inydji yirrpini, nyani guḻdjili nyibirri ngunupilangmirri murrurrtmirri, gima ngurrum gar-malirdjiniban. Rirrkiyan nyani marrngili, galwupiṉi munatjamirri, girri guṉgili bukurrngili a ngurrinyiniban yakirrigi. ");
INSERT INTO dji_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Bil nyani buḻkiniban. Nyani mabugi nyangiṉi bilapilang gam'; baltjnyirbi mala nyani nyangiṉi, miri djiḻi munatjamirri mungan-yirrpini, a nguḻi giṉimbirrimirri guraki-galwupiṉi ṉamṉammirri, bilapilang. A nyani djiny nyangiṉi Godang wugiḻi djamagiṉing mala djani ngunyili djin baltjny kiriny a bapiḻi djin djundini kiriny, bilapilang djiningir ngunungir. ");
INSERT INTO dji_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Girri nyani nyangiṉi Yawaynyi djarri kirim ngidjirrkng nyanngar. A nyani Yaway inga wanginban, “Ngarri Yaway, Miligidji Abrayamang nyungung mar'mingngirang, a Miligidji Yisakang. Djining gurrbi nyaling nyuni ngurri kirimban ngarri nyirr gupirrgungi miri nyunki a nyungung mala-punyirbigi. ");
INSERT INTO dji_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Nyungung mala-punyirbi djani djin galbidjidji bilapilang miri midjirri munatjamirri ngurri kirim, a ngildji ngunyili-ngunyili inydji ildji garrwurdjigi - miri djimurruli, barrali, ḻunggarrmali, a djalatjangili. A nyungumirrpmi a nyungung mala-punyirbimirrpmi ngarri djiny irr gunggatjigi warrpam bapurrurr malany marrga rummirri manymakmirri djin nyinidjiban. ");
INSERT INTO dji_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ingki marrbirri djining, ngarri inmarr djamadjigi a nyirr gunggatjigi; miri bilang ngunyili ngunupilang nyuni giri, ngarri bintji kiri ngurrgima nyirr djagadjigipm. A mari-djamagiṉpilngirgi ngarri ngandarrk djinarr djirridjiban nyungungi, marrga magayagiṉing nyuni giri nyinidji, a bapiḻi nyirr wiṉidjingilgi nyunguli gurrbili djampan. Ngiy birralgima ngarri ingki nyirr marrbigi, bil yarim inmarr djamadjigi yarimipm irr malimdjigi bubalikiṉing nyirr murr-rangirri.” ");
INSERT INTO dji_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Girri buḻkinyirbingir nyani Djakup binygadjiniban, a nyani wangin, “Birral, Yaway djiḻigima gurrbiwi! Nyani gukirri kirim djiḻikima, a ngarri wawu ngurrinyini!” ");
INSERT INTO dji_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","A yawnginyirbingir nyani wurrwurrdjny kirinyban, girri bindjin wangin, “Djining mirrpmi butjir-kanirbi gurrbi! Djinikima Godang gurrbiwi marri; a djiḻikima Godang milak dji'tjarri marrga ngunumirri lim ragi ṉamili!” ");
INSERT INTO dji_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Djaḏaw nyani inydji waykungiliban, marrngili ngunung bukurrnyirbi rirrkiyan, girri mungun-yirrpiniban munatjamirri marrga ngunukima rirrkiyan dji'djirridji kiri miri guṉgi-biḻmiynyakiṉingi. Girri gapi gidjirri djal-walibi nyani djululupmiyngili ṉamili rirrkiyanili, bilapilangdji ngunung rirrkiyan djuyugiṉdjiniban Godang. ");
INSERT INTO dji_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Girri nyani bultjidjini ngunung gurrbi Bitil, gima ngunung yagirri mayali miri ‘Godang gurrbi’. (Guyumi yulpili djin mutjpiningili bala'pili nguḻi, a yagirri djin yirrpini gurrbiwi Lutj; bil rirringir ngunungir-kirri Djakupang mala-punyirbi madjirri djin bultjidjini ngunukima gurrbiwi Bitil.) ");
INSERT INTO dji_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Girri Djakupdji murr-rangirri Garraynyi djining budjirr-randinirbi maṯiṯ, “Ngunubilang nyuni irriny gunggatjigi, a ngunubilang nyuni dji'djirridji kiri ngirrar miri ṉamkaṯdjinginakiṉing ngirrangi bilakiṉing irr gukirri kirim, a ngunubilang nyuni irriny gungi wali a mirikal mala, ");
INSERT INTO dji_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","a ngunubilang nyuni irriny wiṉidjingilgi ngirrali gunydjirrgirali marrga ingarr yulgungi magayagiṉing, Miligidjiban nyuni ngirrangi bintji kiri ngurrgima, yarim nyuni ngiḏawapm. ");
INSERT INTO dji_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","A djiḻi djani yulpili inma djin bumir-baltjigi, yarim djiḻikima nyaling irr yirrpini djinim guṉgi-biḻmiynyakiṉing rirrkiyan. A ngunukiṉing girripili mala irr marrgi, ngarri bintji inmarr djamadjigi gam': irr buṯbuṯnyirdjigi ngunitjini mala marrga 10-bi gaṉḏibi irr galbungi, girri wurpmi gaṉḏibi nyirr gungiban, bil wurpiwiltji irr galiki miri ngirrangipm, bilapilang.” ");
INSERT INTO dji_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Rirringir ngunungir-kirri nyani Djakupdji gubini ngunung gurrbiwi, girri minydji giraliban djimurruli. Rirringir yakirri galbi djin bangiringili, nyani ngidjirrkng bi giriny nyininy Yaran gurrbiwi nyibirri yulpili djimurrubi djin nyininyi mala. ");
INSERT INTO dji_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Nyani giriny nyininy, mani-girrirrkgiṉing ralalban nyani mildji bipiṉi gurrpuḻumirri, a maypal bimbi mala - warrngguwili guḻukng, ḻiw ḏap djin ngurriny kiriny rarrmaḻi-rarrmaḻipm, miri nyani guḻukng ngurrinyi rarrmaḻipm, a nyani wurpi guḻukng ngurrinyi rarrmaḻipm, a bilapilang. Djani warrpam djin marrkany kiriny marrga gapi djin ḏirradjigi. Miri maypal-djagagiṉing mala ngungirapibi gurrbibi djani djin djaltjibiny giriny gapi djanngang maypalpilngirgi ngunungir ralalngir. A ngunung ralal djabiri djin miṉibiny giriny rirrkiyandji murrbiṉir, bintji maypal galmidji a gapi mirgidjidjiban. ");
INSERT INTO dji_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Djanngang rum bilapilang gam': ngunukiṉing bukmak ngunuwiltji maypal-djagagiṉpili djin gurrkunyir nguḻi, giḻiwiḻim djin djaltjibinyir ngunung giḏidjirring rirrkiyan, girri ngunung djin yilbirtjnyir ralalngir, girri djin burrunyir gapi maypalgi malagi. Rirringir ngunungir-kirri ngunung ralal djin miṉibinyir rirrkiyandji madjirri. ");
INSERT INTO dji_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Manymak, nyani Djakup djina yulgungili maypal-djagagiṉpilngirgi, girri djiny butjalmini, “Way miygiṉpila, nyalinggirapibi ngildji?” “Yaranngir gurrbingir,” djin bumir-wubirdjili. ");
INSERT INTO dji_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Girri nyani djiny butjalmini, “Bina Laban walkiringim Nayurang ildji marnggi?” “Ngiy nibi marnggi ngungirki,” inga djin bindjin. ");
INSERT INTO dji_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","“Bina nyani manymak?” nyani djina bindjin. “Ngiy, nyani manymak,” djin bumir-wubirdjili, girri inga djin wangin, “Nyawi, nyanngang miḏipiḻi bi inmila girim nyiniban walkiringim inga Ratjil (Rachel), nyani djiny djudju-gam kirim Labanang maypal bimbi malany bapiḻi.” ");
INSERT INTO dji_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","A Djakup djina bindjin, “Bil djini'djining yarim balnggiḻipmban, ingkiban ngurrum ildja yulgunyir ngunung bilidjirri ngunukiṉing ildji gurtjigi maypalpili malirigi. Nyimkiban ingki ildji gapirigi djinikiwiliny maypalpilngiriny djini'djining, marrga djiny ildji wiṉidjingilgi yurryarrili marrga djin ḏirradjigi bilakiṉing waḻirr gurrpin kirimipm?” ");
INSERT INTO dji_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Bil djin bumir-wubirdjili, “Ingki nibi bintji, biḏak. Djiḻi nibi marrkang yarimipm djani maypal-djagagiṉpilingir djin birrugi bapiḻi bukmakgima nginbilang maypal bimbi mala. Rirringir ngunungir-kirri nginibi warrpam nibi yilbirtjigi ngunung rirrkiyan murrbiṉi, girri gapi nibi marrgiban maypal malagi.” ");
INSERT INTO dji_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","A bilakiṉing nyani Djakup djina wanginy kiriny, nyani Ratjil djina yulgungiliban gam kirimban Labanang maypal bimbi mala - nyani maypal-djagagiṉing miyilk nyanngang gunydjirrgirki. ");
INSERT INTO dji_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","A ngunukiṉing Djakupdji nyangiṉi Ratjilnyi a nyanngang gaykiygirang maypal malany, nyani Djakup giraliban mani-girrirrkgiṉingili, ngunung rirrkiyan yilyilmiyngili djabiringir ralalngir, girri ma'marriny kiriny gapi maypalpilngirgi gaykiygirang Labanang yarimipm djin ḏuḻpidjini. ");
INSERT INTO dji_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Girri nyani wuṉḏirrdjini Ratjilnyi, a ngurr-yirrpini ngadjiniban gima mirrpmi galng-wakalbiṉi. ");
INSERT INTO dji_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Girri nyani inga bultjidjini, “Ngarri djining nyungung gunydjirrgirang gurruṯigiṉing, Ribikang gapirringim irri.” Girri nyani Ratjil ṉunydjirraliban marrga gunydjirrgirki bultjigi. ");
INSERT INTO dji_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","A ngunukiṉing nyani Laban marrngini ngunung djanguny miri gapirringim inga yulgungili, nyani ṉunydjirraliban inga bir-kiri, gurkirrali nyaninyi, a wuṉḏirrdjini, girri nyani birrungiliban Djakupnyi nyanngali bala'li. Girri nyani Djakup inga bultjidjini bukmak nyim ngunupilang inga birraldjini ngurrwakngi mala. ");
INSERT INTO dji_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Rirringir nyani Laban marrngini djanguny nyanngapibi, nyani bindjin inga wanginban, “Ngiy, birral galkngu nyuni ngirrang gurruṯigiṉing, ngirrangpibi bapurrurrbi!” A nyani Djakup nyininiban nyanngar wurpm rangu, miri inga djamadjny kiriny Labangi yarimban. ");
INSERT INTO dji_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Rirringir wurpm rangu bangirngili, nyani Laban inga bindjin wangin Djakupgi, “Marriban nyuni ngirrang gurruṯigiṉing, ingki nyuni bilang irra djamadjigi yarimban. Ngarri nyuniny nyirr bayimdjigiban djamagi, yarim nyuni irra bultjigiban nyabinwili nyuni djalngdjidji.” ");
INSERT INTO dji_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Ban Laban nyani biliny gatjidjini miḏipiḻimirrpili - nyanngang walkirwilingim, a yagirri bilingang Liya (Leah) nyanngang gaḻitjirringi, a Ratjil nyanngang mirrdjingi. ");
INSERT INTO dji_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","A ngungirki miyilkigi Liyagi, mil inga biḻbaḻdjini; ban Ratjilgi, galngi inga ḻatju, a nyani mirrpmi djal-maḻimaḻing miyilk. ");
INSERT INTO dji_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","A nyani Djakup inga marr-bulanggitjdjini Ratjilgi a budjirr-djalngdjini inga, bil Liyagi wirr. Marrga nyani bumir-wubirdjili Labannyi miri bindjin gam', “Nyungki inmarr djamadjigi 7 guṉmal a rarranydjarr, bilang nyuni irriny murr-raniban miri djampan Ratjilnyi nyuni ranytili irra gungi miri nyanimngim irra.” ");
INSERT INTO dji_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Girri nyani Labandji bumir-wubirdjili, “Ngiy, buṯaltja nyaninyi irr gungi nyunguli, ingki wurpili yulngirali, gima nyuni ngirrang gurruṯikiṉing. Irr yitjidjirri, nyuni djiḻikima nyinidjiban ngirrarban.” ");
INSERT INTO dji_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Manymak, 7 guṉmal a rarranydjarr nyani Djakupdji inga djamadjili Labangi marrga Ratjilnyi marrgi. A ngunung bilidjirri nyani gingini yarim ḏambingipm galkngu warrngguwilipm yakirri, gima nyani mirrpm inga marr-bulanggitjdjini Ratjilgi. ");
INSERT INTO dji_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","A ngunukiṉing ngunung bilidjirri inydji malimdjili, nyani Djakup inga wanginban Labangi, “Girrban waḻirr ngirrangi, nyuni irriny gungban ngirrang nyanimngim marrga liny ngurridjiban wurpilipmban.” ");
INSERT INTO dji_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Marrga nyani Labandji galngarrarradjili bunggul wana, a nyani djina walidjirrdjini bukmakgi yulpilngirgi ngungirapibi gurrbibi. Girri bunggulban djin buny kirinyi. ");
INSERT INTO dji_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","A djinimirri djanngang rum djarrinyini. Maliri nyani yul inga marrkang nyanngang murr-randinirbigi miyilkigi, ṉambiḏi wiṉiṉmirri nyinidji kiri inga marrkam kirim. Girri gunydjirrngirim nyani marrgiban nyanngang walkiringim, girri ngunung miyilk bi inga birrugiban ngunyili, miri nginipingirang wiṉiṉili. Bil ngurrwakng ngunung miyilk inga yulgungi, nyanibi ngurrum inydji garrpigi mirikaldji, bilapilang. Manymak, nyani Djakup inga marrkany kiriny Ratjilgi wiṉiṉmirri, ngurrum maliridjini, bil ingki Ratjilnyi nyani Labandji inga birrunyir, yarim Liyany inga birrungili Djakupgi, a girrban. A nyani Djakup ngurrinyiniban nyanngar gima nyani wawupm ngunukima ingki Ratjil. ");
INSERT INTO dji_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(A nyani Labandji gungili Liyanyi wurpm miyilk miri djamagiṉing inga, gima ngunung wurpi rum djanngang ngurrwagipi. A ngunung djamagiṉing miyilk Labandji gungili nyanngang, yagirri nyani Djilpa (Zilpah).) ");
INSERT INTO dji_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Manymak, milwartjili nyani Djakup binygadjini a mil-nyangiṉiban. “Way, djinimkima ingki Ratjil!” Nyani inga warrwarrdjili Labangi, girri inga bindjin, “Nyimki nyuni irriny gar-yulgimi miri bindjirri? Ngarri inmarr djamadjny kiriny marrga Ratjilgima irr marrgi. Nyimki rarri wurpm nyuni irriny gungili?” ");
INSERT INTO dji_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Girri nyani Labandji bumir-wubirdjili, “Nginbilang rum djingirapibi gurrbibi ingki miri ngunukima. Yarim ngurrwakng nibi gungi gaḻitjirringkima, a rirringir ngunungir-kirri manymak nibi gungban mirrdjingi, bilapilang nginbilang rum. ");
INSERT INTO dji_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Nyuni bar-kaliki, yarim nyuni inga malimdjigi djingiriny wurpm week gaḻitjirringirgi, girri ngunung wurpi nyinibi gungban ngirrang mirrdjingi. Bilapilang gam', ngili il bumir-tjamigi, miri ngarri nyirr gungi Ratjilnyi, a nyuni madjirrtji irra djamadji kiri nyibingirgi 7 guṉmalpilngirgi.” ");
INSERT INTO dji_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Nyani Djakup yitjidjiniban. Nyani marrkangili yarimipm Liyang week inydji djingiringili, girri ngunukiṉingban nyani Labandji ranytili inga gungiliban Ratjilnyi girrgima. ");
INSERT INTO dji_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","A nyanngali girri nyani Labandji gungili wurpm djamagiṉing miyilk Ratjilali, a nyani yagirri Bilya (Bilhah). ");
INSERT INTO dji_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Manymak, Djakup a Ratjil biling bil ngurrinyiniban wurpilipm. A nyani Djakup inga marr-bulanggitjdjini Ratjilgi, miri mirrpmgima nyani inga marr-bulanggitjdjini, bil Liyagi yarim marri djayaḻ. Manymak, nyani nyi'nyininyi nguḻikima nyibiwili 7 guṉmalpili marrga bayimdjigi gaykiygiriny Ratjilgi. ");
INSERT INTO dji_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Manymak, ngunukiṉing nyani Yawaydji nyangiṉi Djakup ingki inga marr-bulanggitjnyir Liyagi, nyanngali nyani gungili yidjipilpilngiriny Liyali, bil Ratjilgi wirr - nyani budjirr-djumiḻidjini. ");
INSERT INTO dji_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Marrga nyani Liya gapaḻmirrpilidjini, a djampan miḻimiṯi inga bungtjili, a nyani yagirr-yirrpini nyaninyi Riwbin (Reuben); gima nyani wangin bindjin, “Djining yagirri mayali miri, ‘Goddji nyangiṉi ngirrang wargugu’, a wurpi mayali miri, ‘Djinin'djining ngirrang nginipingim irra marr-bulanggitjdjidjiban’, bilapilang.” ");
INSERT INTO dji_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Girri madjirri nyani yidjipilakiṉdjini, girri djirrakay inga bungtjili, a yagirri nyani yirrpini nyanininy Djimiyun (Simeon). Miri djini'djining bilidjirri nyani bindjin wangin, “Djining yagirri mayali miri, ‘Yaway marrngini irr nyini kirimipm marr-bulanggitjnyirring,’ marrga djingirinyi wurpi nyani irra gungili yidjipilngiriny.” ");
INSERT INTO dji_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Girri madjirrtji nyani gapaḻmirrpilidjini, wurpi yidjipili yul marrngili, a djiningkima nyani yagirri bultjidjini Liybay (Levi), gima nyani bindjin, “Djining ngirrang nginipingim irra djalngdjidjiban, gima ingarr marrngili yidjipilpilngirinyi warrngguwiliban.” ");
INSERT INTO dji_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Girri wurpm bilidjirri madjirri nyani yidjipilakiṉdjini, a djampan yidjipili yul bungtjili. A nyani bindjin wangin, “Djini'djining bilidjirri Yawaygi ingarr guṉgi-baltjigi”; bilapilangdji yagirri nyani yirrpini nyaninyi Djuda (Judah). Rirringir ngunungir-kirri nyani ḏaḏawdjili marrinyirngir yidjipilpilngirinyi. ");
INSERT INTO dji_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Ban ngunukiṉing nyani Ratjil djiringini nyani baḏatj djiny marrngili yidjipilpilngirinyi Djakupgi, nyani inga mil-ḏinytjnyirakiṉdjiniban gaḏingirgim Liyagi. Nyani bindjin inga wanginiban nginipingirgim, “Ngirrinyban irriny kuw walgurwalgur, bintji irr balidji wargugungir!” ");
INSERT INTO dji_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Bil nyani Djakup inga maḏakarritjdjini, a yan birintilipm inga nguli, “Ingki irr ganydjarrgiṉing miri God! Nyanngarki nyin budjirr-djumiḻidjnyirdjili, ingki ngarrigima!” ");
INSERT INTO dji_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Girri Ribika inga wanginban, “Djinimgima ngirrang djamagiṉing miyilk Bilya (Bilhah), nyum nyim ngurridji wurpilipm marrga nyanngangir budjirringir djiny irr marrgi yidjipilpili ngirrangipmban.” ");
INSERT INTO dji_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Marrga nyani Djakupdji marrngili ngunukima miyilk Bilya miri wurpi nyanimngim inga, a nyanngar waymirri ngurriny girinyban gurrkunyi. ");
INSERT INTO dji_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Manymak, guyumi nyani Bilya gapaḻmirrpilidjini, a walkir-marrngili yidjipili yul Djakupgi. A nyani Ratjildji djagadjiliban ngunung ngaṉarr biṯma nyanngangipm. ");
INSERT INTO dji_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","A nyani bindjin wangini, “Goddji bukmaknyi yulpilngiriny djiny mil-ḻirrpiniban ingki djuburr-mirkng ngarri. Yarim warrpam djin marnggiban ngarri murkunyirbinyirring, gima Goddji irriny gungiliban djingiriny yidjipilngirinyi rirringir ngarri nyaniny irr butjalmini yidjipiligi ngirrangipm.” Bilapilang nyani bindjin, marrga yagirri nyani yirrpini ngungiriny ngaṉarr Dan. ");
INSERT INTO dji_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","A rirringir ngunungir-kirri ngunukima djamagiṉing miyilk Bilya gapaḻmirrpilidjini madjirrtji, a wurpi yidjipili yul djawal-gingini. ");
INSERT INTO dji_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","A nyani Ratjil wangini, “Ngili ngirrang gaḏingimi Liya inydji il birrirrpirrirrdjim kirimban, bil marriban, ngarri nyaniny irr burrdji nguliban!” Bilapilang nyani wangin, marrga nyaninyi yagirri nyani yirrpiniban Naptali (Naphtali), gima ngunung yagirri gatjinmi mayali miri ‘Birrirrpirrirrdjnyirbi’. ");
INSERT INTO dji_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Ngunukiṉing nyani Liya nyangiṉi ingki madjirri nyani marrnyir kirinyir yidjipili malany, nyani marrngiliban nyanngang djamagiṉing miyilk Djilpa (Zilpah), girri ngunukima inga gungili Djakupili miri wurpi nyanimngim inga. ");
INSERT INTO dji_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Manymak, Djilpangir wurpi yidjipili yul bungtjili Djakupgi, a nyani Liyadji marrngili ngunukima ngaṉarr a djagadjiliban miri nyanngangipm. ");
INSERT INTO dji_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Nyani bindjin, “Ngarri djambatjpan!” Marrga nyani yagirri-yirrpini nyaninyi Gat (Gad), gima ngunung yagirri mayali gatjinmi miri ‘Djambatj’. ");
INSERT INTO dji_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Girri madjirri Liyang djamagiṉing miyilk gapaḻmirrpilidjini, a wurpi yidjipili yul bungtjili Djakupang. ");
INSERT INTO dji_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","A nyani Liya bindjin wanginban, “Ngarri marrkapgiṉingban! Ngunuwiltji wurpiwili miyilkpilingir djani irriny djin gingidji ngarri marrkapgiṉing miyilk.” Marrga ngunukima yidjipili nyani yagirri-yirrpini Atjir (Asher), gima ngunung yagirri mayali gatjinmi miri ‘Marrkapgiṉing’. ");
INSERT INTO dji_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Wurpilim waḻirrdji, ngunukiṉing bilidjirri nyadji djin yirryirrdjny kiriny wali marrga djin gurtjigi mirring miṉitji mala dampagi, Riwbin ngunung miḻimiṯi Liyang nyani gukirrinyi murrurrtmirrpmi. Girri nyani birraldjnyirdjili djal-waligiṉing gurrbi, a ngunukima djal-wali buṯbuṯnyirdjili, a gurrbili minaliban nyanngali ngambirrgirali. Bil nyani Ratjil nyangiṉi ngunung djal-wali, marrga nyani butjalminiban gaḏiṯipm, “Way, bi irriny kuw nyibi ngunukima djal-wali nyungur gapirringirim gurtjili.” ");
INSERT INTO dji_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Bil nyani Liyadji bumir-wubirdjili, “Ngurrumban nyuni mil-gami ngirrang nginipingim, bina djini'djining nyuni djalngdjirri ngirrang gapirringirang djal-wali nyuni djamigi gurrkunyi?” Girri Ratjil inga bindjin, “Il bumir-tjamigi; nyuni irriny gungban ngunukima djal-wali, a ngiltjang nginipingim nyani ngurridjiban nyunguri djini'djining maliri, bilapilangdji ngarri nyuniny nyirr bumir-wiṉidjingilgi.” ");
INSERT INTO dji_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Marrga djampan ngunukiṉing Djakup wiṉiny kiriny murrurrtngir rirringir djamangir, nyani Liya wiṉiṉngir yulgungiliban, girri inga bir-kiraliban. Nyani inga bindjin, “Nyuni ngurridji ngirrarban, gima irr bayimdjili ngirrang gaḏiṯipm marrga nyirr marrgi. Ngarri gupirrgungili nyanngali ngirrang djal-wali ngunukima ngirrar gapirringirim buṯbuṯnyirdjili djuli.” Marrga ngunuban maliri nyani Djakup ngurrinyiniban nyanngari. ");
INSERT INTO dji_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","A nyani God inga mil-wurdjili Liyagi a marrngini nyanngang butjalminyirbi, marrga nyani gapaḻmirrpilidjini madjirriban. A guyumi wurpi yidjipili yul bungtjili, marrga Liya gatjidjiniban 5 yidjipilpili. ");
INSERT INTO dji_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","A nyani Liyadji yagirri-yirrpini nyaninyi Yitjikar (Issachar), a ngunung yagirri mayali gatjinmi galkngu ‘Bayarra’, gima nyani wangini, “Goddji irriny bayarradjili gima ngirrang djamagiṉing miyilknyi irr gungili ngirrali nginipingirali.” ");
INSERT INTO dji_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","A madjirrtji nyani Liya yidjipilakiṉdjini, a yidjipili yul bungtjili - namba 6 nyanngangi. ");
INSERT INTO dji_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","A nyani yagirri-yirrpini ngungiriny Djibulun (Zebulun), a ngunung yagirri gatjinmi mayali miri ‘Mundjarr’, gima nyani bindjin wangin, “Goddji irriny gungiliban mundjarr buṯalgima. Marri rirringir djiningir ngirrar nginipingirim bi irriny gang kiri mundjarr mala, gima ngarri ingarr gungili 6-ban yidjipilpiliban.” ");
INSERT INTO dji_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","A djuḏitjban nyani Liyadji marrngili yidjipili miyilk, a yagirri-yirrpini nyaninyi Dina (Dinah). ");
INSERT INTO dji_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Bil nyani Goddji ingki marrbinir Ratjilnyi, nyani butjir inydji kungili nyanngang butjalminyirbi, girri nyanngang yarr nyani maṯiṯdjili yidjipiligi. ");
INSERT INTO dji_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","A ngunukiṉing Djakup ngurrinyini nyanngar waymirri, nyani Ratjil wurpi gapaḻmirrpilidjiniban. A djampan nyanngang miḻimiṯi bungtjili. Girri Ratjil bindjin wangin, “Guṉigima ngirrangi nyani Goddji yilbirtjiliban ngirrangir.” ");
INSERT INTO dji_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","A yagirri nyani yirrpini nyaninyi Djusip (Joseph), a ngunung yagirri mayali gatjinmi galkngu miri ‘Wurpi Irr Marrgi’, gima nyani bindjinban, “Ngarri djalngdjirri nyani Goddji irriny gungban wurpigima yidjipili ngirrangipm!” ");
INSERT INTO dji_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Manymak, rirringir Ratjilang miḻimiṯi Djusip djawal-gingini, nyani Djakup inga wanginban Labangi, inga bindjin, “Bina manymak ngarri irr gubidji djining gurrbiwi, irr wiṉidjiban ngirrali gurrbiliban? ");
INSERT INTO dji_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","A ngarri djiny irr gangban ngirrang nyanimwilingim a walgurwalgur, a minydji nibi giriban. Bamanban inmarr djamadjny kiriny nyungki, a ngurrumban nyirr bumir-wiṉidjingini ngirrang miyilkpilngirgi. Miri yirrimban nyuni marnggi nyaliki ngirrar djamadji nyin gunggatjili.” ");
INSERT INTO dji_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Bil nyani Laban inga wanginban, “Ingkiban ildji giriban. Butjir inydji kungban; ngarri djining djanguny irr marnggidjini miri warngarringir djangunygiṉingir, miri bilapilangir irr birraldjnyirdjili gam': nyani Goddji irra manymakdjim djamadjim gima nyunikima nyini kirimban ngirrari. ");
INSERT INTO dji_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ngarri irr djalngdjirri nyuni bar-kalikiban djiḻigima. Yarim nyimki nyuni djalngdjidji ngirrapibi, nyuni irra bultjigiban, a ngarri inmarr gungi ngunukima ngunubilang nyuni madjirri irra djamadji kiri, bilapilang ngarri nyirr bayimdjigi nyunung djamagi - nyimki ngunupilang nyuni djalngdjidjiban.” ");
INSERT INTO dji_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Girri nyani Djakup bindjin, “Nyuni marnggi miri ngarri nyuniny nyirr rrupiya-galbidjnyirdjili ngirrar djamadji, a nyaliki nyungung bimbi a nanikut mala djin galbidjini ngirrapibi djamabi, gima djiny irr djagadjny kiriny manymak. ");
INSERT INTO dji_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Miri ngurrwakng inmarr yulgungili biligi nyuni ingki gatjinir galbi maypal mala, bil yarim warrngguwilipmban. Ban djiṉi guḻukng wanagima nyungung, gima nyani Yawaydji irriny gunggatjny kiriny, marrga galbi maypalpili nyani nyin gungili ngirrapibi djamabi. Bil rirringir djiningir-kirri manymaktja nginibi inydji nibi djagadji giriban, gima wirr maypalpili nibi gatjirriban nginbilangpibi. Marrga ngirrangipm miyilkpili a walgurwalgur djiny irr djagadjigiban, a maypal malany djinyi nibi marrgiban nginbilangipm. ");
INSERT INTO dji_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Bil Laban butjalminiban madjirri, “Nyili ngarri nyirr bayimdjigi?” A nyani Djakupdji bumir-wubirdjili, “Nyuni irriny gungi wirrpm djini'djining. Ngarri djiny irr djagadji kiri nyungung maypal mala yarim miri ngurrwakngi, ngunubilang djining ngirrang mayali nyuni yitjidjidjiban. ");
INSERT INTO dji_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Bilapilang nyungung maypal mala: miri nanikutpili djani mulngi mala, a bimbi djani bardjining mala, bil yarim warrngguwili ḻurrkin-djuḻatjdjuḻatjmiynyakiṉing mala nyuni gatjinmi bimbi a nanikut, a warrngguwili djuḻtjdjuḻtjnyakiṉpili girrgima. Marrga djiniwili ḻurrkin-rindinyirbi a djuḻtjdjuḻtjnyakiṉing maypalpili nyuni djiny gungi ngirrali, miri yarim djinikiwiliny a warrpam minytjigiṉing yuwirdjingpili djani djin bungtjigi djampan nanikut a bimbi, yarim djinikiwilinygima djiny irr marrgi minytjigiṉpili nyungungpibi maypal malabi. Bilapilangdji nyuni irriny bayimdjigiban, ban nyunibipm djiny galiki warrpam bardjining bimbi, a warrpam mulngi nanikut. Manymak, djamingi irr gukirrdji kiri nyungumirrpmi maypalpilimirrpmi, djiny irr buṯbuṯnyirdjigiban warrpam minytjigiṉing maypalpili nanikut a bimbi, girri djani ngirrangipmban. ");
INSERT INTO dji_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Girri bubalikiṉim bilidjirri nyuni djiny nyangi ngirrang maypal malany, nyuni miliki a manyangban. A ngunubilang wurpmipm nyuni birraldjnyirdjigi maypal nyunungpibi, galkngu bardjining bimbi u mulngi nanikut, nyuni marnggiban ngarri waparrbi ngunukima irr djaminmi nyungungir maypalpilingir!” ");
INSERT INTO dji_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Girri nyani Laban inga wangini, “Ma', miri bintjigima ngurrgima il djamadjigiban miri nyuni irra bultjidjini.” ");
INSERT INTO dji_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Bil nyani Laban djayurrkdjurrk wiṉiniban nyanngali maypal malali, girri nyani djiny buṯbuṯnyirdjiliban bukmaknyi ngunuwili ḻurrkin-djuḻatjdjuḻatjmiynyakiṉing a djuḻtjdjuḻtjnyakiṉing maypal mala, miri nanikutpili a bimbipili, girri djiny gungili nyanngali walgurwalgurli marrga djiny djin djagadji kiri rarrmaḻipm Djakupngir. ");
INSERT INTO dji_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Girri Laban a nyanngang walgurwalgur djin yilitjiniban Djakupngir, marri bilay miri 3 yakirrpili djin girali, girri inydjin nyininiban nguḻi, marrga ngunuwili minytjigiṉing maypal mala Labandji djiny djagadjny kiriny, a ngunuwili bardjining bimbi a mulngi nanikut mala Djakupdji djin djagadjny kiriny Labangi. Ingkiban djani mayalpili djin mil-kurrkunyir girinyir, bil yarim rarrmaḻi-rarrmaḻipm bil djirridji kiripmban mala. Miri bilapilang nyani Labandji gar-yulili Djakupnyi. ");
INSERT INTO dji_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Bil nyani Djakup girali murrurrtili, girri djarngili wurpi-wurpi mala djadjiri yuwirdjing, miri ḏiṯiy a nyim-kunyirri yuwirdjing bumalng ngunuwili djin gatjinmi bardjining galngi nguymirri giḻingkaḻmirri mala. Girri nyani marrngili yiki, girri yalwupiṉiban giḻingkaḻ marrga ngunuwili djadjiri malany nyani djiny djuḻatjmiyngiliban, miri bindjin nyani gar-gurryilidjnyirdjili bardjining galngi nguymirri. ");
INSERT INTO dji_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Girri nyani ngurr-yirrpini ngunukuwiliny ḻurrkin-djuḻatjdjuḻatjmiynyakiṉing bumalngpili ngunyili munatjali - ngidjirrkng djapiḏipilimirri nyaling gapi dji'djapin ṉambiḏi maypal malagi djin ḏirradjigi. Nyani miri bindjin djamadjili marrga ngunitjini nanikut maladji djiny djin nyangban ngunukuwiliny djunggipili birbimirri djanngar, marrga ngunukiṉing yuwirdjingpili nanikutpili djin bungtjigi, giḻingkaḻ djina djuḻatjdjuḻatjmiynyakiṉdjidjiban girrgima. Gima nguḻigima ngidirrkng ngunuwili djapiḏipili, bininy kiriny ngurrgima nyani gurrkiṉingir nanikutdji burrili inga baltjny giriny miyilkali, girri guḏidjiliban, ngunukiṉing bukmak ngunuwili nanikutpili djin gurrkungili nguḻi ḏirradjnyirgi. ");
INSERT INTO dji_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Marrga ngidjirrkng ngunuwili ḻurrkin-rindinyirbi bumalngpili djani nanikut mala inydjin guḏidjiliban. A bilapilangdji ngunukiṉing yuwirdjingpili djin buntjili, djani warrpam minytjigiṉingban, miri nyibi ḻurrkin-djuḻatjdjuḻatjmiynyakiṉpili, a nyibi djuḻtjdjuḻtjnyakiṉpili. ");
INSERT INTO dji_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Ban bimbipilngirgi, nyani Djakupdji djinimirri djamadjili gam': nyani djiny buṯbuṯnyirdjili bukmak bimbi miyilkpili marrga djin djarriny kirinyban rarrmaḻipmban. Girri ngunukiṉing djani minytjigiṉing nanikutpilingir djin ḏirradjny tjarriny gapi djapiḏimirri djinngirpmi, ngunuwiltji miyilk bimbipili nyani Djakupdji djiny djudju-gangiliban wurpili galiyili, marrga ngunngirpm biri-biri djiny djin nyang djirridjiban ngunukuwiliny minytjigiṉing nanikutpili. Bilapilangdji ngunukiṉing yuwirdjing bimbi mala djin bungtjili, djani wurpi minytjigiṉing bilapilang miri nanikut mala. Miri bilapilang nyani Djakupdji djiny marrngili mirrpm galbi nanikut a bimbi mala minytjigiṉing; girri nyani djiny buṯbuṯnyirdjili Labanngir maypal malangir, girri djiny yagirrdjiniban nyanngalipm maypal malali. Miri Labanang maypalpili nyani Djakupdji djiny djagadjny kiriny rarrmaḻipm, a nyanngangipm rarrmaḻipm, ingkiban inydjin mil-kurrkunyir girinyir. ");
INSERT INTO dji_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","A nyani bindjin djamadjili djinimirri wurpi: ngunukiṉing maṯiṯpili gurrkiṉing maypalpili burrili djina baltjili ngidjirrkng djapiḏimirri, nyani marrngili ngunukuwiliny ḻurrkin-rindinyirbi djunggipili, girri munatjaliban nyani djiny ngurr-yirrpiniban nguḻi milbimirri maypalpilngirar. ");
INSERT INTO dji_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Bil ingki nyani bininyir djamadjnyir ngunukiṉing biḻbaḻingpili maypalpili inydjin guḏidjili. Marrga Djakupdji djiny marrngili warrpam maṯiṯ maypal malany, bil Labandji djiny marrngili bukmak biḻbaḻing malany. ");
INSERT INTO dji_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Bilapilang nyani Djakup yagirr-wanadjiniban, a rrupiya-galbingakiṉdjiniban, a nyani gatjidjiniban mirrpm galbi maypalpili, kamulpili, dungkipili, a djamagiṉpili - miyilkpili a yulpili. ");
INSERT INTO dji_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Manymak, nyani Djakupdji birraldjnyirdjili Labanang walkiriwilingim djin wanginy kiriny nyanngapibi miri djin bininy kiriny, “Warrpam nginmilang gunydjirrgirang girri malany nyani Djakupdji mil-gamban, bubalikiṉing nyani gunydjirrar gatjinmi mala. Miri bukmak ngunuwili maypalpili a djamagiṉpili nyani Djakupdji djiny gatjinmiban, nyani djiny gurrkumi ngunukuwiliny gunydjirrgirangpibi malabi, yarim djani bilang guydjirrgirang, ingki Djakupang.” ");
INSERT INTO dji_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","A wurpi, Djakupdji nyangiṉi miri nyani Labandji inga rum-nguliban, ingkiban nyani inga bir-bulanggitjnyir nyininyir miri ngurrwakngi, bilapilang. ");
INSERT INTO dji_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Girri nyani Yaway inga bindjin wanginban Djakupgi, “Wiṉiyban nyunguli mutjingili nyibirri nyuni bungtjili, a ngarri inmarr maltjigiban marrga nyirr djagadjigi.” ");
INSERT INTO dji_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Marrga nyani Djakupdji yan yaniliban marrga biling nyaniwilingim inga bil bir-kiri nguḻi murrurrtmirri nyibirri nyanngang maypalpili djin djarri kirim. ");
INSERT INTO dji_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","A ngunukiṉing inga djin yulgungili, nyani bilingga wangin bilingga bindjin, “Ngarri irr nyangiṉi miri nyumilang gunydjirrgirang djuburr nyani irra wurpidjiniban, miri ngurrwakngi ngunukima yul irra marr-bulanggitjdjini, ban djini'djining bumirli irriny ngurrgimban. Bil marriban, ngunukima ngirrang gunydjirrgirang Miligidjir nyani irriny gunggatjim. ");
INSERT INTO dji_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Nyum nyim marnggi ngarri inga djamadjny giriny mirrpm wana gunydjirrgirki nyumilang, ");
INSERT INTO dji_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","bil nyani irriny gar-yulgimi bumir-galbi bilidjirri, miri nyanngang murr-randinirbi nyani djambidjambidjimi madjirri a madjirri. Bil nyani God ngandarrk inga djarri Labangi marrga ngunung mari Labanbi irranydji yulgimi. ");
INSERT INTO dji_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Miri bilapilang gam': ngunubilang nyani irra bindjin wangin, “Bukmak mil-kurrkunyirbi minytjigiṉing maypalpili nyuni djiny galikiban, bilapilangdji ngarri nyirr bumir-wiṉidjingilgi djamagi nyungung,” girri djani maypalpilingir warrpamdji djiny djin buṉḏigiban yarim mil-kurrkunyirbi minytjigiṉing yuwidjingpili. Bil ngunubilang nyani irra wangini irra bindjin, “Ingkiban mil-kurrkunyirbi minytjigiṉpili, bil ḻurrkin-djuḻatjdjuḻatjmiynyakiṉpili nyuni djiny galikiban yarim ngunukuwiliny,” girri warrpam maypalpili djani djiny djin buṉḏigiban yarim ḻurrkin-djuḻatdjuḻatjmiynyakiṉing yuwirdjingpili. ");
INSERT INTO dji_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Bilapilang djiniwili maypalpili nyani Goddji nyaniny gaypili gunydjirrgiriny nyumilang, a djiny gungiliban ngirraliban. ");
INSERT INTO dji_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Miri ngurrwakng, ngunukiṉing nyani gurrkiṉing nanikutdji burrili inga baltjny, girri guḏidjny, ngarri mabugi irr nyangiṉiban. Miri mabugimirri irr nyangiṉi galbi gurrkiṉing nanikutpili, djani burrili djina baltjny kiriny miyilkpilingiriny, a ngunuwili gurrkiṉing mala yarim djani warrpam minytjigiṉing - miri ḻurrkin-djuṯatjdjuḻatjmiynyakiṉing, djuḻtjdjuḻtjnyakiṉing, a mil-kurrkunyirbi minytjigiṉing mala, bilapilang. ");
INSERT INTO dji_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Girri wari ngunupilang irra witjiliban Godang djanguny-ganyakiṉing marri, irr buḻkinyipm, a nyani irra wangin, “Way, Djakup!” “Ngarri djiḻi,” ingarr bindjin. ");
INSERT INTO dji_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","A bilakiṉiŋ biliŋ ŋuḻi bil nyininyipm, waḻirr inga yulguŋiliban Merigi miri gurrulk inga buŋtjigi. ");
INSERT INTO dji_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Girri nyanŋaŋ miḻimiṯi djawal-giŋiniban, a Meridji marrŋili ŋunukima, girri garrpiniban mirikaldji giḻiwiḻiŋir, girri yakirr-galwupiṉi ŋunyili djapiḏili yurryarrkiṉiŋili nyaliŋiri buluki mala djin ḏirradjigi yurryarr ŋuli bulukiŋirar bala’mirri. Bilapilaŋirgi nyani yakirr-galwupiṉi djapiḏili bulukiŋiraŋ, gima wirr gadjigarr biliŋki ṉambiḏi bala’mirri yulpilŋiraŋ, gima ŋunuŋ bala’ŋurrum rarri inydji barŋiliban. ");
INSERT INTO dji_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Manymak, ŋidjirrkŋ Bitiliyim gurrbiwi, gar-gurryili murrurrtmirri nyibi maypal-djamagiṉpili djani djin nyininy kiriny, maypal bimbi mala djiny djin djagadjny kirinyban, a ŋunupan ŋurrum gar-maliridjiniban. ");
INSERT INTO dji_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Girri ŋunukiṉiŋban wurpmi Garrayaŋ djamagiṉiŋ wugiḻi nyani djina birraldjini, a Garrayar warrdjinirnir djiny ḻiwḻiwmiyŋili, a munutjaban warrpaḏaḏadjini ŋidjirrkŋ djanŋar biṯma maṉŋibirri. Wanaban inga djin ŋuy-yawŋiniban. ");
INSERT INTO dji_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Bil ŋunukima wugiḻi djina waŋini, djina binjin, ‘Iŋkiban ildji yawŋidji. Butjir inydji ildji kuwi, ŋarri ildjarr birruŋiliban djaŋuny buṯal, marrga bukmak yulpili wanaban djin ṉitjanydjidji ŋunukiṉiŋ djiniŋ djaŋuny djin marrŋirrdji. ");
INSERT INTO dji_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Gima djini’djiniŋ maliri, nyani Wanŋirnyakiṉiŋ ildja buŋtjiliban ŋildjaŋi, djiḻi gurrbiwi Dabidaŋ nyani Garray djawal-nyaŋiṉiban ŋunukima Godaŋ Yirryirrpinirbi yul. ");
INSERT INTO dji_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","A bilapilaŋ djiniŋ warŋarri djaŋunygiṉiŋ djarri kirimban ŋildjiki, marrga ildji birraldjnyirdjigi ŋunuŋ yidjipili: ildji manyaŋi nyaninyi mirikaldji garrpini, a ŋurri kirim djapiḏimirri bulukiŋirar.’ Bilapilaŋ ŋunuŋ wugiḻ djina bindjini maypal-djagadjnyakiṉpilŋirgi. ");
INSERT INTO dji_vpl VALUES ("J11_1","092_1_1","1JN","1","1","1","Djiniŋ djaŋuny ŋarri irr wukirridjim kirimban marrga lidjarr bultjigi yulbi, ŋunuŋi, nibi bultjin girim nyaninyi yagirri “Yan Wanŋigiṉiŋ”. A ŋunuŋi baman ŋurrwakŋ, nyani nyi'nyininy ŋurrnuŋgaḻ bilidjirri; a nyanŋaŋ yan nibi marrŋini, a nyaniny galŋi nibi nyaŋiṉi ŋinibilar mildji. Ŋiy, yirrimban nibi nyaŋiṉi nyaniny, a nyaninyi galŋi nibi gatjidjini ŋinibilar gumbirrdji; a djiniban lidja nibi bultjinmi nyanŋapibi. ");
INSERT INTO dji_vpl VALUES ("J11_2","092_1_2","1JN","1","2","2","Ŋuṉi yuldji gatjinmi birral wanŋi, ŋunuŋi wanŋi-giḻiwiḻiŋakiṉiŋi, a nyani nyi'nyininyi Gunydjirrgirar; a ŋunuŋ wanŋigiṉiŋ birraldjiniban miri yuldjiniban, bilapilaŋ miri ŋilimban, girri nibi nyaŋiṉiban nyaninyi. A bilapilaŋban, miri mil-marŋgigiṉpili nibi, a lidja nibi bultjinmiban nyanŋapibiban. Nyani miri wanŋi-giḻiwiḻiŋakiṉiŋi, a wirrban balidji, yarim nyi'nyinidjipm bintjiban ŋurrgima. A ŋunuŋi baman pirr nyani nyi'nyininy giḻiwiḻim Gunydjirrgirar ŋunukirri ŋurrnaŋgaḻ bilidjirri, ban djini'djiniŋ nyanibi inydji mil-ḻirrpiniban nyanŋarki djiḻi ŋilimilar munatjamirriban. ");
INSERT INTO dji_vpl VALUES ("J11_3","092_1_3","1JN","1","3","3","Bubalikiṉiŋ nibi nyaŋiṉi a nibi marrŋini, ŋunitjini mala lidja nibi bultjigi, marrga ŋilidji nibila lidji maltjigiban a wurpmban mala yulpili limi, miri wurpirrimban rummirri lim nyinidjiban. A ŋinibilaŋi, nibi nyini kirimban giḻiwiḻim Gunydjirrgirarban, a nyanŋar Walkirgirar Djesur Christarban, miri wurpmban mala. ");
INSERT INTO dji_vpl VALUES ("J11_4","092_1_4","1JN","1","4","4","Ŋurrumban nibi galŋ-ṉitjanydjirri, a nibi wukirridjim ŋilidjaliban marrga ŋilidji bintji ŋurrgima lidji galŋ-ṉitjanydjidji. ");
INSERT INTO dji_vpl VALUES ("J11_5","092_1_5","1JN","1","5","5","A djiniban ŋunuŋ djaŋuny nibi marrŋini nyanŋapibi, miri Djesubi, a ŋunuŋ ŋurrgima djaŋuny lida nibi bultjigi, bilapilaŋ gam': Gunydjirrŋimi ŋunuŋ Warrpaḏaḏadjnyiri a wirrpm nyanŋar gar-maliri, miri mirikunu rum mala, a bilapilaŋ. ");
INSERT INTO dji_vpl VALUES ("J11_6","092_1_6","1JN","1","6","6","A marrga ŋunubilaŋ lim bintji giŋidji, “Ŋarri ŋurrum Godkiṉiŋban”, bil biḏakipm lim giri gar-malirmirrpm, miri rummirrpm mirgimirrpm, girri inydji lim yulgimban, a lim burr-birrindjiŋin girimban Godŋir birralŋir rumŋir. ");
INSERT INTO dji_vpl VALUES ("J11_7","092_1_7","1JN","1","7","7","Bil ŋunubilaŋ lim giri warrpaḏaḏamirrpmi, bindjirr ŋurrgima miri nyanibipm Gunydjirrŋimi girim nyini maṉŋibirrimirrpmi, girri wurpilipmban lim nyinidji giri mala; a Djesu, ŋunuŋ Gunydjirrgiraŋ Walkiripm, nyanŋari buḏiri limiliny rurrtjirrmigiban, miri limiliny ŋalwirrgidjigi ŋilimilaŋir mirgiŋir. Ban ŋunubilaŋ bintji ŋurrgima lim giŋidji gam', “Wirrban mirgi irr gatjirri ŋarribibi”, girri miri bilapilaŋban mayali inydji lim ŋagirrgi, a nyanŋaŋ birral rum iŋkiban ŋurriyi ŋilimilar. ");
INSERT INTO dji_vpl VALUES ("J11_8","092_1_8","1JN","1","8","9","Bil ŋunubilaŋ bintji ŋurrgima inganydji lim bultjigi Gunydjirrgirki gam', “Gunydjirra, yirrimban mirikunu yul ŋarri, mirgiban irr djamadjili”, girri nyani Gunydjirrar limila djuy-bultjigiban, a limiliny ŋalwirrgidjigiban bukmakŋir ŋilimilaŋir mirgiŋir, gima Miligidji nyani wiḻi nyanŋapibi yan gatjigi, yarim wirrban limila gar-yuliban, yarim bulaŋgitj limila djamadjigiban. A bilapilaŋ, miri warrpam ŋilimiliny mirgi mala nyani djiny yilyilmiygi ŋilimilaŋir, a girri lim ŋalwirrgidjidjiban, gima bukmak ŋilimilaŋ mirgipili inganydji lim bultjidjiniban nyankiban. ");
INSERT INTO dji_vpl VALUES ("J11_10","092_1_10","1JN","1","10","10","Bil ŋunubilaŋ bintji ŋurrgima lim waŋidji gam': “Iŋkirr mirgi-djamadjiw giriwi”, girri bilapilaŋir djaŋunydji nyaniny lim bultjinmiban Gunydjirrgiriny yagirri ‘Inydji Yulginyakiṉiŋi’, bilapilaŋ, a nyanŋaŋ yan iŋkiban lim gatjirriban ŋilimilarban. ");
INSERT INTO dji_vpl VALUES ("J12_1","092_2_1","1JN","2","1","1","Marrkapnyakiṉiŋ yutjuwili ŋirraŋi, djiniŋ djaŋuny ŋarri wukirridjimi ŋilidjali marrga ŋilidji iŋkiban lidji djamadjigi mirikunu mala. Bil ŋunubilaŋ mirgi lim djamadjigi, girri lim gatjinmi warŋarrinyi, miri ṉamkaṯdjiŋinakiṉiŋi, a ŋunuŋi djarri kirimban ŋilimilar galiymirri marrga nyani limiliny guŋgatjigi, miri Djesu Christ, ŋunuŋ djuburr-garray yul, wari nyanŋar nyi'nyiniban Gunydjirrgirar, a nyani limilanydji ŋurriban, a limiliny guŋgatjigiban. ");
INSERT INTO dji_vpl VALUES ("J12_2","092_2_2","1JN","2","2","2","Miri, nyadji ŋunupilaŋ lim mirgi-djamadjigi, nyani Gunydjirrŋim limila maḏakarritjdjidjiban, bil nyani Djesu limilanydji ŋurriban, girri inga waŋidji a nyaniny djanadjanadjigiban, marrga Gunydjirrŋimi nyani ŋuy-miṉdjidjiban, a limila djuy-bultjigiban, iŋkipmban nyani limila maḏakarritjdjidjiban muŋuy. Ŋiy, miri bintji ŋurrgima Djesudji limila djamadjigi, a iŋki yarim ŋilimiliki ŋiḏawirrka, bil bukmakgi ŋunuwili yulpili djin nyini girim djiḻi munatjamirri mala. ");
INSERT INTO dji_vpl VALUES ("J12_3","092_2_3","1JN","2","3","3","A nyalikidjidji ŋilimi birral lim djiriŋilgi lim marŋgi Djesugi? Ŋunubilaŋ lim butjirgiṉdjirr girim nyanŋaŋ yan-gunyirbigi malagi, bilapilaŋdji lim djiriŋilgiban inga lim marŋgi. ");
INSERT INTO dji_vpl VALUES ("J12_4","092_2_4","1JN","2","4","4","Nyibi yulpili djani bintji djin waŋidji gam': “Ŋarri marŋgi Djesugi,” bil djin gurrpinmipm djin butjir-djumiḻiŋipmban nyanŋaŋ yan-gunyirbigi malagi. Ŋunubilaŋ djin bintji ŋurrgima djin waŋidji, girri ŋunitjini yulpili inydjin yulgimban, a baḏatj djin marŋgi birralgi. ");
INSERT INTO dji_vpl VALUES ("J12_5","092_2_5","1JN","2","5","5","Ban ŋunubilaŋ wari ŋunupilaŋ mil-yirrpin girim Garrayili djaŋunyili, a butjirgiṉdjirr girim ŋunugirki yangi, girri yirrimban ŋunuŋ yul inga marr-bulaŋgitjdjirrban Godki buṯalban. A djiniŋ ŋarri lidjarr bultjigi nyaliki lim djiriŋilgi lim nyini kirim Godar nyanŋar marr-bulaŋgitjmirri. ");
INSERT INTO dji_vpl VALUES ("J12_6","092_2_6","1JN","2","6","6","Ŋunubilaŋ lim bintji waŋidji, “Ŋarri wurpilipm irr nyini kirim Djesur” girri ŋilimi bilaŋ lim yaṯi-nyaŋban Djesuny, miri, nyalikidjny Djesudji djamadjny giriny djiḻi munatjamirri, ŋilimi wurpi bintji ŋurrgima bilaŋ lim djamadjigiban miri nyanibi. ");
INSERT INTO dji_vpl VALUES ("J12_7","092_2_7","1JN","2","7","7","Marrkapnyakiṉpila, iŋkiban ŋarri lidjarr yirrpinmi wurpi rum yuwirdjiŋ, bil yarim yiligima lidjnyirr gumban ŋunuŋ wanim yan-gunyirbi, ŋunuŋi lidji marrŋini ŋunukiṉiŋ yuwirdjakiṉim lidji marr-birralŋakiṉidjini: miri, ŋilimibi bilaŋ inydji lim marr-bulaŋgitjdjidjiban, bilapilaŋ ŋunuŋ yan. Ŋurrumban lidji marŋgi ŋunugirki djaŋunygi, gima biligi lidji marrŋini ŋunuŋi. ");
INSERT INTO dji_vpl VALUES ("J12_8","092_2_8","1JN","2","8","8","Bil ŋarri lidjnyirr guṉgi-biḻmiymban bapiḻi yan-gunyirbili, miri, djina lidji marr-bulaŋgitjdjidji wurpiwiliki yulpilŋirgi, gima Djesu nyanŋarki nyininy giriny ŋunumirri, a ŋunuŋ rum lidja manymakdjirrban ŋilidjiki girri. Ŋilimi wirapili djiniŋ Godaŋ yulpili lim gubiniban ŋunuŋ rum gar-malirigiṉiŋ, a ŋunuŋ gar-maliri limila manydjirr kirimban, a Godaŋ birral warrpaḏaḏadjnyiri ŋurrumban limila ŋalapdjim kirimban ŋilimilali. ");
INSERT INTO dji_vpl VALUES ("J12_9","092_2_9","1JN","2","9","9","Bil ŋunbilaŋ nyuni bintji waŋidji, “Ŋarri nyini kirimban Godar warrpaḏaḏamirri”, bil biḏak nyuni ŋuy-margiṉidjirripmban wirki ŋunupilaŋ, girri nyuni nyi'nyinipmban gar-malirimirriban, a biḏak wirrban nyuni ranyir ŋunyili Godili warrpaḏaḏali. ");
INSERT INTO dji_vpl VALUES ("J12_10","092_2_10","1JN","2","10","10","Ban ŋunubilaŋ nyuni djina marr-bulaŋgitjdjirr kirim wurpiwiliki yulpilŋirgi, birralban nyuni nyini kirimban warrpaḏaḏamirri. Marrga iŋkiban nyuni djalŋdjidji nyuni djiny ŋurri-djitigi wurpiwili yulpili ŋunyili mirgili rumili, gima nyunibi gi'kirim nyiniban warrpaḏaḏamirrpmi, a nyuni gubidjiban mari. ");
INSERT INTO dji_vpl VALUES ("J12_11","092_2_11","1JN","2","11","11","Ŋiy, ŋunubilaŋ wari ŋunupilaŋ ŋuy-margiṉidjirri gurruṯigiṉiŋirgi, gar-malirimirriban nyani nyi'nyinipmi, a mil-bambay gu'gukirriban gar-malirimirri, a nyani djuŋa nyanydjili girim nyiniban, gima ŋuṉi gar-malirdji mil-djumiḻidjiliban nyaninyi, a ŋunuŋ yul mil-djalminiban gadjigarrŋiri Godŋiri. ");
INSERT INTO dji_vpl VALUES ("J12_12","092_2_12","1JN","2","12","12","A ŋilidjaŋ yutjuwiliki, nyani Goddji djiny midjirrdjili mirgipili ŋilidjaŋi, gima marr lidji yirrpini Djesuli, a bilapilaŋirgi ŋarri lidjarr wukirridjimban djining djaŋuny. ");
INSERT INTO dji_vpl VALUES ("J12_13","092_2_13","1JN","2","13","13","A ŋilidjaŋ wanapilimirriŋ marr-birralŋakiṉpilŋirgi, ŋarri djiniŋ lidjarr wukirridjimban djaŋuny, gima lidji marŋgi Djesugi, ŋunuŋ gaypiŋibi wari nyi'nyininyi ŋurrnaŋgaḻŋiri. A ŋilidjaŋi marri wana yulpilŋirgi, ŋarri lidjarr wukirridjim girri, gima ŋunuŋ mirikunu wugiḻi lidji ḏimbitjnyirdjiliban. Ŋiy, ŋarri lidjarr wukirridjimi yutjuwiliki, gima Gunydjirrgirki lidji marŋgi. ");
INSERT INTO dji_vpl VALUES ("J12_14","092_2_14","1JN","2","14","14","A ŋarri lidjarr wukirridjimi gunydjirripilŋirgi, gima lidji djiriŋinmi nyaninyi, ŋunuŋ bir-gaypiŋibi wari bininy kiriny ŋurrgima nyi'nyininy kiriny ŋurrnaŋgaḻŋiri. A ŋarri lidjarr wukirridjim yawirrinygi a miḏipiḻiŋirgi, gima maṉbiŋban lidji djarri kirimban, lidji marŋgidjini Godaŋ yangi, a lidji ŋuy-yirrpini ŋunuŋ yan ṉambiḏili ŋilidjali ŋunyili yipi, a lidji ḏimbitjnyirdjiliban ŋunuŋ mirikunu wugiḻinyi. ");
INSERT INTO dji_vpl VALUES ("J12_15","092_2_15","1JN","2","15","15","Iŋkiban djiniŋ munatjabi rum nyuni marr-bulaŋgitjdjiyi, iŋki djalŋdjiyi malagi djingirapibi, miri munatjabi mala. Ŋunubilaŋ nyuni djalŋdjidji djingirki munatjabi rumgi, iŋkiban nyuni inga marr-bulaŋgitjdjidji Godki Gunydjirrgirki, a nyuŋuŋ djalŋ inga manydjidjiban. ");
INSERT INTO dji_vpl VALUES ("J12_16","092_2_16","1JN","2","16","16","Gima djiniwili munatjabi mala djani rarrmaḻipm, a ŋunuwili ṉampi mala, miri Gunydjirrgirapibi mala, djani rarrmaḻipm, bilapilaŋ, rarrmaḻi-rarrmaḻipm biliŋi munatjabi mala a ṉampi mala, iŋki wurpilipmili bili. A ŋunuwili mirgipili rumpili mala djani miri bilapilaŋ gam': nyuni djalŋbiṉi yul marri, miri galkŋu, nyuni djalŋdjirri ḻatjugi djakiygi, a bilapilaŋirgi. A wurpi mirgi rum nyani bilapilaŋ gam': nyuni bindjirr kirim ŋurrgima djalŋdjirri ŋunuwiliki malagi nyuni nyaŋi nyuŋur mildji, miri rrupiyagi galkŋu, a girripilŋirgi, a bilapilaŋirgi. A wurpi mirikunu rum nyani bilapilaŋ gam': nyuni inydji wanadjigi, gima nyuni giŋi nyuŋuŋ munatjabi rum nyani manymak. Bilapilaŋ mirikunu djuburr iŋki milarrdjiw giriw Gunydjirriŋir bil yarim djingirapibi, miri munatjabi, nyani inydji ŋurrgimi. ");
INSERT INTO dji_vpl VALUES ("J12_17","092_2_17","1JN","2","17","17","A djiniŋ munatja gurrbi nyani manydjidji ŋidjirrkŋban, gima nyani Goddji malimdjigi, a bubalikiṉiŋ djalŋbiṉi yulŋiriny nyani djiŋirigiban ŋunukiṉiŋban girri. Marrga ŋunubilaŋ nyuni bilapilaŋ yul, nyuninyi girri Goddji nyin malimdjigiban, bilaŋ rummirri munatjamirri nyuni nyi'nyiniban. Ban ŋunubilaŋ nyuni djamadjigi nyimki ŋunupilaŋ nyani God djalŋdjirri, girri nyuni wanŋi nyi'nyinidjipmban bintji kiri ŋurrgima. ");
INSERT INTO dji_vpl VALUES ("J12_18","092_2_18","1JN","2","18","18","Ŋiy, ŋirraŋ yutjuwili, ŋunuŋ waḻirr ŋunukiṉiŋ Goddji malimdjigi djingiriny munatja gurrbi ŋunugima waḻirr ŋurrumban ŋidjirrgidjini ŋilimilaŋ bukmakgi. A ŋunuŋ mirikunu yul wiriny lim bultjigi nyaniny yagirri ‘Bir-yirrpinakiṉiŋ Christgi’, nyani bi giri bapiḻi nyadji ŋunupilaŋ, a nyani djamadjigi marrga bir-yirrpigiban Christnyi a Garrayaŋ yulpilŋirinyi. Ŋilidji yirrimi lidji marrŋini ŋunuŋ djaŋuny ŋurrwakŋi. A ŋurrumban galbi yulpili bilapilaŋ miri ŋunuŋ yul inydjin ŋuliban, a limila djin yulguŋiliban. Marrga yirrimi lim nyamban ŋunuŋ djawardjnyirbi waḻirr ŋidjirrkŋi bi girimban. ");
INSERT INTO dji_vpl VALUES ("J12_19","092_2_19","1JN","2","19","19","Bilimi ŋunuwilitji yulpili limila djin maltjny giriny, biṯma djani girri Garrayaŋ yulpili, miri ŋilimi. Bil djuḏitjpan limiliny djin gubini, gima iŋki birral djani wurpilipm ŋilimilar. Ŋunubilaŋ birral ŋunuwilitji yulpili djani giṉḏibi ŋilimilapibi malabi, girri djin gurrpinir girinyir limila djin maltjigi. Bil djin gar-gurryilidjini ŋilimilaŋir malaŋir, a bilapilaŋdji ŋilimi bukmakdji lim djiriŋiniban iŋkiban ŋilimilapibi malabi djini. ");
INSERT INTO dji_vpl VALUES ("J12_20","092_2_20","1JN","2","20","20","Iŋkiban marŋginyirriŋ yulpili lidji, gima nyani Djuyu Wugiḻi lidja yulguŋiliban, a yirrpini nyanŋaŋ ganydjarr ŋilidjali, marrga lidji marŋgiban warrpamgi Garrayaŋ djaŋunygi. ");
INSERT INTO dji_vpl VALUES ("J12_21","092_2_21","1JN","2","21","21","Ŋiy, yirrimban lidji marŋgiban birralgi. Ŋarri iŋkirr giŋiyi lidji djuŋadjirripm birralgi, bil lidjarr wukirridjimban djiniŋ djurra marrga lidjnyirr guṉgi-biḻmiygi ŋurrum lidji marŋgiban ŋunugirki birralgi gadjigarrgi Garrayaŋ. A djiniŋgirki djaŋunygi lidji marŋgiban girri, miri, ŋunubilaŋ wari ŋunupilaŋ inydji yulgim kirim, a marŋgidjim kirim wiḻtjnyiriŋ djaŋuny, girri ŋunuŋ wiḻtjnyiriŋ djaŋuny iŋki bi girinyir birralŋiri djaŋunyŋiri. ");
INSERT INTO dji_vpl VALUES ("J12_22","092_2_22","1JN","2","22","22","Wariban ŋunuŋ wana inydji yulginyakiṉiŋ yul? Bubalikiṉiŋiri yuldji wiḻi bir-yirrpinmi Djesu Christnyi, a bindjirr waŋban gam', “Ŋunuŋ Djesu nyani yarim yul, iŋki ŋunuŋ Wanŋirnyirakiṉiŋ yanginyirbi Godbi ṉamŋiri nyani.” Bilapilaŋ yul nyani ŋunuŋ ‘bir-yirrpinakiṉiŋ Christgi’, a nyanŋaŋ guḻinydjirr yul, gima nyani biliŋga iŋkidjim girim Godki Gunydjirrgirki a nyanŋaŋ Walkiriŋirgim, bindjirr kirim ŋurrgima biliny bir-yirrpin girimban bilapilaŋdji yuldji. ");
INSERT INTO dji_vpl VALUES ("J12_23","092_2_23","1JN","2","23","23","A ŋunubilaŋ wiḻi ŋunupilaŋ bir-yirrpigi Godaŋ Walkiripm a nyanki iŋkidjigi, girri yirrimban ŋuṉi yuldji bir-yirrpigiban God Gunydjirrgiriny girrgima. Iŋki wiḻi marr-yirrpigi Gunydjirrgirali, a ŋunukiṉiŋ bilidjirri bir-yirrpigiban nyanŋaŋ Walkiripm. Bil ŋunubilaŋ wari ŋunupilaŋ milma waŋidji bilapilaŋ gam': “Ŋiy, yirrimi Djesu nyani Godaŋ Walkiriŋim, a marr-birralŋakiṉiŋ inga ŋarri,” giri bilapilaŋir yuldji nyani gumbirr-gatjigi Djesunyban, a Gunydjirrgirinyban girrgima. ");
INSERT INTO dji_vpl VALUES ("J12_24","092_2_24","1JN","2","24","24","Marrga iŋki marr-birralŋakiṉidjiyi djaŋunygi wurpigi, bil yarim lidji ga'gatjirri ŋunuŋ djaŋuny lidji marrŋini ŋurrnaŋgaḻŋiri. Ŋunubilaŋ ŋunuŋ nininyŋu djaŋuny ŋu'ŋurri ḏurkḏurkmirri ŋilidjar, a lidji marr-birralŋakiṉidjirr girimban, girri nyanŋari lidji nyinidji giriban ŋunyili yipiban Walkiriŋirar, a Gunydjirrgirar girri. ");
INSERT INTO dji_vpl VALUES ("J12_25","092_2_25","1JN","2","25","25","A djiniban ŋunuŋ djaŋuny Djesudji nyani limila yirrpini: ŋilimi miri wanŋi-giḻiwiḻiŋakiṉiŋ lim gatjigi bintji kiri ŋurrgima. ");
INSERT INTO dji_vpl VALUES ("J12_26","092_2_26","1JN","2","26","26","Ŋarri lidjarr wukirridjimban djiniŋ djaŋuny marrga lidjnyirr butjir-garriban iŋki butjinydji-guw ŋunuwilitji inydji yulginyakiṉiŋ malany. Djani djin manyam kirim lidja djin gar-yuliban marrga ŋilidji wurpili djaŋunyili lidji djaypirgiban. ");
INSERT INTO dji_vpl VALUES ("J12_27","092_2_27","1JN","2","27","27","Bilapilaŋ miri ŋarri lidjarr bultjidjini ŋurrwakŋi, Djuyu Wugiḻiri nyani yirrpini nyanŋaŋ ganydjarr ŋilidjali, a ŋilidji galiki ŋunuŋ ganydjarr inydji muŋbinigiban. Marrga yarim Djuyuny Wugiḻiny bilaŋ lidji butjinydji guŋban, a nyanibi lidjny marŋgi-gupirrguŋban. Marrga iŋkiban inga lidji miliki wurpigi yulgi marrga ŋuṉi lidjny marŋgidjigi, bintji nyani lidjanydji yuli, a mayalidji lidjny ŋagirrgi. Bil ŋunuŋ ganydjarr Djuyu Wugiḻiŋiraŋ birral ŋu'ŋurriban ŋilidjar, a ŋuṉi lidjny marŋgidjigiban bukmakibi malabi, yarim nyani lidjny mil-ḻirrpigiban birralnyi, a iŋkiban lidjny mayali-ŋagirrgi. Marrga bilapilaŋ miri Djuyu Wugiḻiri nyani lidjny marŋgidjili biligi, ŋilidji bilaŋ bi'bintji ŋurrgima lidji nyinidjiban, miri, ŋidjirrkŋ Garrayar bilaŋ lidji nyinidji giriban muŋuyban. ");
INSERT INTO dji_vpl VALUES ("J12_28","092_2_28","1JN","2","28","28","A djini'djiniŋ ŋirraŋ yutjuwili, wurpilipm nyanŋar nyi'nyiniy giriwban, marrga ŋunukiṉiŋ nyani milarrdjigi a maḻŋdjigi yili djiḻi ŋilimilar munatjamirri, ŋilidjiban birbimirri nyanŋar lidji djirridjiban rumrum'nyirriŋban, iŋkiban inydji lidji mirrbiliban nyanŋaŋir, miri, guṉigiṉiŋban ŋunukiṉiŋ nyani lidja yulguŋi. ");
INSERT INTO dji_vpl VALUES ("J12_29","092_2_29","1JN","2","29","29","Ŋunubilaŋ ŋurrum lidji marŋgiban Djesu Christ djiniŋi rum-garraygiṉiŋ yul, girri djiniŋ lidji marŋgiban girrgima gam': Godaŋ birral yulpili djani djiniŋ djuburr-manymakgiṉiŋ yulpili, bilapilaŋ miri Djesu. Marrga ŋunubilaŋ wurpilim yuldji djamadjim kirim mirrpm manymak, girri ŋunuŋ yul buŋtjili nyanŋapibi ganydjirrbi Garrayibi, miri, nyani yuwirdjidjini, a bilapilaŋir yuldji iŋkiban mayalidji lidjny ŋagirrgiban. ");
INSERT INTO dji_vpl VALUES ("J13_1","092_3_1","1JN","3","1","1","Nyani God limila marr-bulaŋgitjdjirrban mirrpm wana. Ŋilidji lidji nyamban ŋunuŋ djaŋuny nyani birral, gima Gunydjirrar limiliny bultjidjini yagirri “yutuwili Godaŋ”, a ŋunuŋi birral, nyanŋaŋ yutjuwili yirrimban limi. Bil ŋunuwiliŋir munatjabi yulpiliŋir djani iŋkiban limiliny djin djiriŋirri, miri, nyanŋaŋ yidjipilpili limi, gima iŋki djin marŋgi Godki djanŋarki. ");
INSERT INTO dji_vpl VALUES ("J13_2","092_3_2","1JN","3","2","2","Marrkapnyakiṉpila, yirrimban Godaŋ yutjuwili limi, bil biḏak nyani iŋki limiliny mil-ḻirrpinir nyim gunyirri yuwirdjiŋ yulpili limi guyumpiligi, ŋunukiṉiŋ nyanŋar lim nyinidji djamiŋi. Bil lim marŋgi djingirki wurpmgi gam': ŋunukiṉiŋ nyani Djesu yili maḻŋdjigi djiḻi munatjamirri, ŋilimi wirapili Godaŋ yulpili lim wurpidjidjiban, a ŋilimi girri bilapilaŋ ŋurrgima miri Djesu nyanibi lim djirridjiban. A ŋunuŋ limila birraldjidji gima Djesunyban lim nyaŋban miri bilapilaŋ ŋurrgima nyanibi birral dji'djarriban. ");
INSERT INTO dji_vpl VALUES ("J13_3","092_3_3","1JN","3","3","3","Ŋunubilaŋ nyani yul marr inga baltjinmi Djesugi, miri nyani Djesudji inga birraldjnyirdjigi ŋunuŋ djaŋuny, girri nyanŋar marr-birralŋakiṉiŋiri ŋa'ŋalwirrgidjigiban nyaninyi bukmakŋir nyanŋaŋir mirgiŋir, marrga nyani midjirrnyirriŋdjidjiban, yarim bilapilaŋ miri Djesu nyanibi. ");
INSERT INTO dji_vpl VALUES ("J13_4","092_3_4","1JN","3","4","4","Ŋunubilaŋ wiḻi ŋunupilaŋ mirgi-djamadjimi, ŋunuŋ yul, miri, rum-ḏapiḻidjnyirakiṉiŋban nyani, gima ḏapiḻidjim kirimban Godaŋ rumban. Miri, rum mirikunu ŋunuŋ bilapilaŋ gam': yuldji nyani bir-yirrpigi Godaŋ djaŋuny, a nyani dji'djalŋdjidji djamadjigi nyanŋaŋpibi mirgipili rum mala. ");
INSERT INTO dji_vpl VALUES ("J13_5","092_3_5","1JN","3","5","5","Bil ŋilidji marŋgi nyani Djesu maḻŋdjili djiḻi munatjamirri marrga limiliny gaypigiban mirgi mala ŋilimilaŋiri. A nyanibi yirrim ŋalwirrgi, a wirrban mirgi nyanŋari. ");
INSERT INTO dji_vpl VALUES ("J13_6","092_3_6","1JN","3","6","6","Marrga ŋunukiṉiŋ nyani yul nyi'nyini wurpilipm Djesur, iŋkiban nyani dji'djamadjiw mirgi mala. Bil ŋunubilaŋ nyani yul nyi'nyini rummirri mirikunumirri, bilapilaŋir yuldji iŋkiban djiriŋirri giriw Garraynyi, a iŋkipmban marŋgi Godki. ");
INSERT INTO dji_vpl VALUES ("J13_7","092_3_7","1JN","3","7","7","Ŋirraŋ yutjuwila, iŋki djina maltjiwi ŋunuwiliki yulpilŋirgi wirapili djin nyinipmban bilapilaŋmirri mirikunumirri rummirri, bintji lidja djin gar-yuliban. Ŋunukiṉiŋ wiḻi ŋunupilaŋ dji'djamadjim bulaŋgitj, ŋunuŋ yul djarriban rum-djunupagiṉiŋban milbimirri Godar, bilapilaŋ miri Djesu nyanibi. ");
INSERT INTO dji_vpl VALUES ("J13_8","092_3_8","1JN","3","8","8","Bil ŋunukiṉiŋ wiḻi ŋunupilaŋ dji'djamadjim mirikunu, miri bindjirr ŋurrgima ŋuṉi yuldji mil-ḻirrpinmiban nyani nyi'nyiniban rummirri mirriŋirar, miri, nyanŋaŋ djuburr bi girimi ŋunuŋir mirriŋir Satanŋir, gima ŋuṉi mirrir dji'djamadjim girim mirikunu bindjirr kirim ŋurrgima, ŋurrnaŋgaḻŋir bi'bininyi nyanibi, a djinikirriban gunyambi dji'djamadjimban. Bil nyani Godar Walkiriŋirim midjirrdjigi bukmaknyi ŋunuŋ mirraŋ djama malany. Bilapilaŋirgi djamagi nyani Djesu maḻŋdjili djiḻi a yuldjini, marrga guḻmiygi Satanaŋ djama. ");
INSERT INTO dji_vpl VALUES ("J13_9","092_3_9","1JN","3","9","9","Ŋunubilaŋ nyani yul yuwirdjidjini, girri ŋunuŋ yul buŋtjili nyanŋapibi Godbi, marrga iŋkiban nyani mirikunu dji'djamadjigipmban, gima Godaŋ Wugiḻi nyini girim nyanŋari. Miri, ŋuṉi Wugiḻiri watjarrdjigiban nyaniny djamaŋir mirgiŋir, gima Goddji Gunydjirrar yuwirdjnyirdjili nyaninyi ŋurrwagi, miri, nyani buŋtjili nyanŋapibi ganydjirrbi Godbi. ");
INSERT INTO dji_vpl VALUES ("J13_10","092_3_10","1JN","3","10","10","Bilapilaŋdji djinyi lim djiriŋilgi ŋunuwili yulpili wirapili Godaŋ birral yutjuwili djini, a ŋunuwili wurpiwili wirapili djani ŋunuŋ Mirraŋ yutuwili, miri bilapilaŋ gam': wiḻi iŋki djamadjigi bulaŋgitj, girri ŋunuŋ iŋki Godaŋ yul; a ŋunubilaŋ iŋki wari inga marr-bulaŋgitjdjidji wurpigi yulgi, girri ŋunuŋ yul iŋkiban Godaŋ yidjipili nyani, bilapilaŋi. ");
INSERT INTO dji_vpl VALUES ("J13_11","092_3_11","1JN","3","11","11","Ŋurrnaŋgaḻŋir ŋilidji marrŋinyi djiniŋ djaŋuny gam': ŋilimibi bilaŋ inydji lim marr-bulaŋgitjdjidji, bilapilaŋ djaŋuny lidji marrŋini bumir-galbi bilidjirri. ");
INSERT INTO dji_vpl VALUES ("J13_12","092_3_12","1JN","3","12","12","Iŋkiban lidji bintji ŋurrgima lidji nyinidjiban miri Kayin; nyanigima wurpm yul Satanaŋ - nyani bipiṉi gulmigipm. A nyimki Kayindji bipiṉi nyaninyi? Gima nyanŋaŋ djama mirikunu, bil gulmigiraŋ djama manymak, bilapilaŋgi nyani bipiṉiban gulmigipm. ");
INSERT INTO dji_vpl VALUES ("J13_13","092_3_13","1JN","3","13","13","Marrga iŋkiban ŋuy inydji lidji yaryardjigi, gulmaw, ŋunukiṉiŋ munatjabi yulpili djani lidja djin ŋuy-margiṉidjidji. Miri, djuburr-mirikunu yulpili bintji ŋurrum djina djin ŋuy-margiṉidjidji djuburr-manymakgi yulpilŋirgi. ");
INSERT INTO dji_vpl VALUES ("J13_14","092_3_14","1JN","3","14","14","Bil wurpiwiliki yulpilŋirgi ŋilimi djina lim marr-bulaŋgitjdjirri, miri, warrpamgi wirapili Godaŋ yulpili a ŋilimilaŋ wuwwiliŋimi ŋunuwili djina lim marr-bulaŋgitjdjirriban, a bilapilaŋmirrpmi marr-bulaŋgitjnyirbimirrpmi lim djiriŋinmiban ŋurrum lim gubini ŋunuŋ balinyiriŋ gadjigarr, a lim bariŋiliban gadjigarr wanŋi. Bil wari ŋunupilaŋ iŋki djina marr-bulaŋgitjdjiyi wurpiwiliki yulpilŋirgi, ŋunuŋ yul nyani ŋuḻikirripmban, nyi'nyinipmban rummirri balinyirimirri. ");
INSERT INTO dji_vpl VALUES ("J13_15","092_3_15","1JN","3","15","15","A ŋunubilaŋ nyuni inga ŋuy-margiṉidjirri wurpigi yulgi, galkŋu nyuŋuŋ gurruṯigiṉiŋirgi, girri milbimirri Godar nyuni bilapilaŋ ŋurrgima miri muṉiŋ. A nyuni marŋgi djingirki gam': wirr muṉiŋ yul gatjirri Godaŋ birral wanŋi nyanŋar, a bilapilaŋ yul iŋki nyinidji giri ŋuḻi nyanŋar Godar gurrbimirri. ");
INSERT INTO dji_vpl VALUES ("J13_16","092_3_16","1JN","3","16","16","Bil ŋili marŋgiban birralgi marr-bulaŋgitjnyirbigi, gima il nyaŋiṉiban nyaliki Djesudji nyanibi litjanydji guŋili, a ŋilitjar biḻamirri nyanibi baliniban. Marrga ŋilibi wurpi bilaŋ djinanydjil guŋban Godaŋ yulpilŋirgi, a djanŋar biḻamirri il balidji. ");
INSERT INTO dji_vpl VALUES ("J13_17","092_3_17","1JN","3","17","17","A marri nyuni gatjinmi galbi girri mala a wali, a nyuni nyami nyuŋuŋ gurruṯigiṉiŋ nyini kirim gumbaḻa, a iŋkiban nyuni inga guŋban nyim ŋunupilaŋ, bil nyuni ray-maṉbidjidjiban. Ŋunubilaŋ bilapilaŋ nyuni bintjigima, girri iŋkiban nyuni gatjirriban Godaŋ birral marr-bulaŋgitjnyirbi nyuŋuri. ");
INSERT INTO dji_vpl VALUES ("J13_18","092_3_18","1JN","3","18","18","A wurpi, ŋirraŋ yutjuwila, iŋki lidji waŋidji miri bilapilaŋ gam', “Ŋarri djinarr marr-bulaŋgitjdjirrban wurpiwiliki yulpilŋirgi”, bilakiṉiŋ iŋkiban djinyi lidji guŋgatjiwi a djina lidji djamadjiw bulaŋgitj. Bil ŋilidjamirrpm djamamirrpm djinyi lidji mil-ḻirrpigi djina lidji marr-bulaŋgitjdjirrban yirrimi. ");
INSERT INTO dji_vpl VALUES ("J13_19","092_3_19","1JN","3","19","19","Ŋirraŋ yutjuwila, ŋunubilaŋ yirrimi ŋili djiny il djagadjigi Godaŋ yulpilŋirinyi, girri bilapilaŋdji il djiriŋilgiban il nyini girimban birralmirri. Marrga ŋunubilaŋ ŋilitjar giŋinyirbili maladji litjny djin mirgi-bultjigi, iŋkiban butjinydjil guŋban ŋilitjaŋ giŋinyirbi malany, girri il ŋuy-ḻaydjigiban ŋunukiṉiŋ ŋidjirrgili il giri Godili a il giŋidjiban ŋilitjnyi djuburrnyi. ");
INSERT INTO dji_vpl VALUES ("J13_20","092_3_20","1JN","3","20","20","Ŋiy, nyadji ŋunupilaŋ guṉi il marrŋirrdji, a ŋilitjar ŋuydji litja bultjigiban, “Nyuni mirrpm mirikunu yul”, bil birralgima wurpiwiliki yulpilŋirgi djinal marr-bulaŋgitjdjirrban. Marriban, nyani God djiniŋ wana mirrpm, a bukmakgi marŋgi, ŋiy, nyani marŋgi ŋunugirki djaŋunygi ŋunuŋ ŋilitjapibi rumbi. Ŋunuŋ iŋkiban Godaŋ bimbi litja waŋiyi, iŋkiban nyani litja bultjirri, miri, mirikunu ŋili, ŋunuŋ yarim ŋilitjapibi rumrum'djnyirbi mala litja djin waŋban, marrga yarim il marrbigiban, a il ŋuy-ḻaydjigi birbimirri Godar, gima yirrim djiny il djagadjim girimban nyanŋaŋ yulpilŋirinyi. ");
INSERT INTO dji_vpl VALUES ("J13_21","092_3_21","1JN","3","21","21","Marrkapnyakiṉpila, ŋunubilaŋ ŋilitjar ŋuydji iŋkiban litja mirgi-bultjirri, girri mil-burrdjiŋi il djirridjiban birbimirri Godar, a ŋidjirrgili bi ingal giriban rumrum'nyirriŋban. ");
INSERT INTO dji_vpl VALUES ("J13_22","092_3_22","1JN","3","22","22","Girri bubalikiṉiŋirgi il butjalmidji nyaninyi, a nyani litja guŋban ŋunuŋi, gima il bu'butjirgiṉdjirri nyanŋaŋ yan-gunyirbigi malagi, a il dji'djamadjim ŋunuwili djin galŋi-bulaŋgitjnyirdjigi nyaninyi mala. ");
INSERT INTO dji_vpl VALUES ("J13_23","092_3_23","1JN","3","23","23","A djiniban nyanŋaŋ yan-gunyirbi ŋunuŋi nyani Gunydjirrar litja yirrpini. Ŋili bilaŋ marr il yirrpigi nyanŋali Walkirŋiralim, Djesu Christili, a bilaŋ inydjil marr-bulaŋgitjdjidji ŋilibinydjili, bilapilaŋ miri nyani litjny yan-guŋili ŋurrwakŋi. ");
INSERT INTO dji_vpl VALUES ("J13_24","092_3_24","1JN","3","24","24","Bubalikiṉiŋ yul, bilaŋ nyanŋar Godar yan-gunyirbimirri nyani girim nyini, girri nyani nyi'nyinidjipmban Godar, a God nyanibi nyi'nyinidji nyanŋar ŋuymirri. A bilapilaŋmirrpmi il djiriŋilgiban nyani God nyi'nyinipm ŋilitjar; nyanŋari Djuyudji Wugiḻiri il djiriŋilgi ŋunuŋ, gima ŋunuŋ Wugiḻinyi nyani litjny guŋiliban Gunydjirrari. ");
INSERT INTO dji_vpl VALUES ("J14_1","092_4_1","1JN","4","1","1","Marrkapnyakiṉpila, ŋunubilaŋ wari ŋunupilaŋ lidja bultjigi miri bilapilaŋ gam': “Ŋirramirrpmi Godaŋ Wugiḻi nyani waŋi”, iŋkiban djayurrkdjurrk lidji marr-birralŋakiṉidjidji ŋunugirki yangi, biḏak, manyawi ŋunuŋ wugiḻinyi ŋurrwakŋi, marrga lidji djiriŋilgiban bilaŋ ŋunuŋ wugiḻi nyani birral Godŋiri waŋ kirimi, gima marri ŋunuŋ waŋ kirimi Mirriŋir. Ŋiy, ŋilidji bilaŋ lidji manyaŋi nyim wugiḻi ŋunuŋi, bintji nyani lidjny gar-yuli marri, gima galbi wiḻtjnyiwiḻtjnyiriŋ djabarrkgiṉpili inydjin yulgimban bubalikiṉimirri djiḻi munatjamirri. ");
INSERT INTO dji_vpl VALUES ("J14_2","092_4_2","1JN","4","2","2","Djinimirri lidji djiriŋilgi nyim wugiḻi lidja waŋ kirimi yulmirrpmi: ŋunubilaŋ ŋunuŋ yul lidja waŋidji bilapilaŋ gam', “Djesu Christ bapiḻi lidja milarrdjili ṉamŋiri miri yul birral nyani, a gatjidjini birral galŋi”, girri ŋunugima yul lidja waŋ kirimi Godar Wugiḻiri. ");
INSERT INTO dji_vpl VALUES ("J14_3","092_4_3","1JN","4","3","3","Bil bubalikiṉiŋir yuldji wiḻi iŋkidjimi ŋunuŋ djaŋuny Djesubi, nyani iŋkiban waŋiy kiriw Godŋiri, bil wurpiŋir wugiḻiŋir waŋ kirimban. Bilapilaŋir wugiḻiri nyani bir-yirrpigi Djesu Christnyi, a nyanŋaŋ guḻinydjirr wugiḻi nyani, a bubalikiṉiŋ yul wari waŋidji bilapilaŋmirrpmi wugiḻimirrpmi, yagirri nyaninyi lim bultjigi ‘bir-yirrpinakiṉiŋ Christgi’. Djiniŋ djaŋuny ŋilidji ŋurrum lidji marrŋini, miri, ŋunuŋ ‘Bir-yirrpinakiṉiŋ Christgi’ nyani djiḻi maḻŋdjigi munatjamirri nyadji ŋunupilaŋ. A djini'djiniŋ ŋilimi warrpamdji lim nyamban bilapilaŋ wugiḻi nyani ŋurrum limila yulguŋiliban djiḻi munatjamirri, gima galbidji yulpilŋiri djin bir-yirrpinmiban Djesu Christnyi djini'djiniŋ djanŋar yandji. ");
INSERT INTO dji_vpl VALUES ("J14_4","092_4_4","1JN","4","4","4","Bil ŋilidji, ŋirraŋ yutjuwila, djinyi lidji baŋiriŋiliban ŋunuwiliny inydjin yulginyakiṉpili yulpilŋirinyi, gima Godaŋ yulpili lidji, a Godaŋ Wugiḻi, ŋunuŋ ŋilidjar nyi'nyiniban, nyani mirrpm ganydjarrgiṉiŋ, bil ŋunuŋ mirgi wugiḻi wari nyi'nyini munatjabimirri yulpilimirri nyani gatjinmi yarim marri djayaḻ ganydjarr, marrga ŋilidji maṉbiŋ lidji djirridjiban, bil ŋunitjini munatjabi mala djin djirridjiban biḻbaḻiŋi. ");
INSERT INTO dji_vpl VALUES ("J14_5","092_4_5","1JN","4","5","5","Djani yarim munatjabi yulpili, marrga djin waŋidji giri munatjabi djaŋunypili, marrga wurpiwiliŋir munatjabi yulpiliŋir djani butjinydjin guŋban djanki, a djina djin marr-birralŋakiṉidjidjiban. ");
INSERT INTO dji_vpl VALUES ("J14_6","092_4_6","1JN","4","6","6","Ban ŋilimibi Godaŋ birral yulpili limi. Ŋunubilaŋ wurpi yul nyani birral marŋgi Godki, ŋunuŋ yul butjinydji guŋban ŋilimiliki. Bil bubalikiṉiŋ yul marŋginyirriŋ Godki, ŋunugima iŋkiban limila butjinydji guŋi ŋunukiṉiŋ inga lim bultjigi ŋunuŋ djaŋuny birral Godbi. Bilapilaŋdji lim djiriŋilgi nyim wugiḻi wurpiwiliŋir yulpiliŋir djin gatjinmi ṉambiḏi djanŋar; nyibili djin gatjinmi Godaŋ Wugiḻinyi a djanŋamirrpmi ŋuṉi Wugiḻiri limila bultjigi djaŋuny birral, bil nyibiri djin gatjinmi wugiḻiny mari-djamadjnyirakiṉiŋ djanŋari, a djanŋamirrpmi ŋunuŋ wugiḻi limila waŋidji djaŋuny wiḻtjnyiriŋ, a bilapilaŋ yul iŋki inga marr-birralŋakiṉidjidji ŋilimilaŋ djaŋunygi. ");
INSERT INTO dji_vpl VALUES ("J14_7","092_4_7","1JN","4","7","7","Marrkapnyakiṉpila, ŋilimibi bilaŋ inydji lim marr-bulaŋgitjdjidji, gima marr-bulaŋgitjnyirbi djiniŋ Godbi gunyirbi nyanŋapibi, a ŋunubilaŋ djina lidji marr-bulaŋgitjdjidji wurpiwiliki yulpilŋirgi, girri birralban nyanŋapibi Godbi lidji buŋtjili marrga lidji yuwirdjidjini, a Godki lidji marŋgiban. ");
INSERT INTO dji_vpl VALUES ("J14_8","092_4_8","1JN","4","8","8","Bil ŋunubilaŋ wari ŋunupilaŋ iŋki djina marr-bulaŋgitjdjidji nyinidji wurpiwiliki, girri ŋunuŋ yul iŋki birral marŋgiban Godki, gima God a marr-bulaŋgitjnyirbi biliŋ wurpilipmili. ");
INSERT INTO dji_vpl VALUES ("J14_9","092_4_9","1JN","4","9","9","A nyani Goddji limiliny mil-ḻirrpini nyanŋaŋ marr-bulaŋgitjnyirbi ŋilimiliki djinimirri: nyani yanili nyanŋaŋ Walkiriŋimi bapiḻi munatjali ŋilimiliki, marrga nyanŋamirrpmi lim gatjigiban wanŋi birral. ");
INSERT INTO dji_vpl VALUES ("J14_10","092_4_10","1JN","4","10","10","Wiraŋ marr-bulaŋgitjnyirbi ŋarri inydjirr bultjinmiban? Ŋilimilaŋ? Iŋki. Ŋurrwakŋi, iŋkiban inga lim marr-bulaŋgitjnyiri Godki, bil marriban nyanibi limila marr-bulaŋgitjdjinipmban. A birral marr-bulaŋgitjnyirbi nyani miri bilapilaŋ gam'. Goddji nyani yanili nyanŋaŋ Walkiripm bapiḻi, marrga nyani balidji ŋilimilar biḻamirri, marrga God ḏaḏawdjidjiban nyanŋaŋir maḏakarritjŋir ŋilimilar, ŋunukiṉiŋ lim mirgi-dji'djamadjnyi; bilapilaŋdji Gunydjirrar limiliny mil-ḻirrpini limila marr-bulaŋgitjdjirri. ");
INSERT INTO dji_vpl VALUES ("J14_11","092_4_11","1JN","4","11","11","Marrkapnyakiṉpila, ŋunubilaŋ miri bindjirr ŋurrgima nyani God limila marr-bulaŋgitjdjirri, ŋilimibi girri bilaŋ inydji lim marr-bulaŋgitjdjidjiban. ");
INSERT INTO dji_vpl VALUES ("J14_12","092_4_12","1JN","4","12","12","Wirr yuldji nyaw giriwi Godnyi nyanŋar mildji, iŋki lim marŋgidjidji Godki ŋunumirri; bil ŋunubilaŋ ŋilimibi inydji lim marr-bulaŋgitjdjidji, girri God nyanŋarki nyinidjiban ŋilimilar. Bilapilaŋdji lim marŋgidjidjiban nyanŋaŋ marr-bulaŋgitjnyirakiṉiŋirgi rumgi, a nyanŋaŋ marr-bulaŋgitjnyirbi maṉbidjidji ŋilimilar ḏurkḏurkmirri. ");
INSERT INTO dji_vpl VALUES ("J14_13","092_4_13","1JN","4","13","13","Miri bintji lim djiriŋilgi lim nyini girimban Godar, a nyani nyini girimban ŋilimilar, gam': nyani Gunydjirrar yirrpini nyanŋaŋ Wugiḻinyi ŋilimilali ḏurkḏurkili. ");
INSERT INTO dji_vpl VALUES ("J14_14","092_4_14","1JN","4","14","14","A ŋinibilar mildji nibi nyaŋiṉi Garray Djesuny, a lidja nibi bultjinmiban djiniŋ djaŋuny birral, miri, Gunydjirrar munatjali yanili Walkiriŋimi, marrga ŋuṉi limiliny wanŋirgiban bukmaknyi ŋilimiliny munatjabi yulpilŋirinyi; miri bilapilaŋ Djesuŋ djama djiḻi munatjamirri ŋilimiliki. ");
INSERT INTO dji_vpl VALUES ("J14_15","092_4_15","1JN","4","15","15","A bubalikiṉiŋ yul wiḻi inydji bultjigi Djesubi miri bintji gam': “Nyani djiniŋ Godaŋ Walkiriŋimi”, girri ŋunuŋ yul nyi'nyiniban Godar, a nyani God nyi'nyiniban nyanŋar girri. ");
INSERT INTO dji_vpl VALUES ("J14_16","092_4_16","1JN","4","16","16","Bilapilaŋdji lim djiriŋilgiban ŋunuŋ marr-bulaŋgitjnyirbi Gunydjirrgiraŋ - ŋunuŋ nyani gatjinmi ŋilimiliki, ŋilimi lim djiriŋinmiban ŋunugirki marr-bulaŋgitjnyirbigi, a lim marr-birralŋakiṉidjirri nyani birral limila marr-bulaŋgitjdjirri. God a marr-bulaŋgitjnyirbi wurpilipmili bili, marrga ŋunubilaŋ marr-bulaŋgitjnyirbimirri rummirri lim nyini girimban, girri nyanŋari lim nyini girimi Godar nyanŋarki, a nyani nyini girimi ŋilimilar. ");
INSERT INTO dji_vpl VALUES ("J14_17","092_4_17","1JN","4","17","17","Djinimirri ŋilimilaŋ marr-bulaŋgitjnyirbi nyani wanadjidji a maṉbidjidji, marrga guyumpiligi, ŋunukiṉiŋ ṉammirri lim djirridji birbimirri Godar, iŋkiban inga lim rumrum'djigiban a inga lim yawŋidjiban; gima Djesu nyanibi iŋki inga yawŋiyi Gunydjirrgirki, a bilakiṉiŋ djiniban lim nyini kirim munatjamirri ŋilimi djiniŋi yarim bilapilaŋ miri Djesu, miri, lim gatjinmi birral marr-bulaŋgitjnyirbi yulpilŋirgi, a Gunydjirrgirki. ");
INSERT INTO dji_vpl VALUES ("J14_18","092_4_18","1JN","4","18","18","Ŋunubilaŋ Godki inga lim marr-bulaŋgitjdjirri, iŋkiban inga lim rumrum'djigiban, gima bilaŋ mirrpmi lim marr-bulaŋgitjdjidji, girri ŋilimilaŋ yawŋinyirbi nyani manydjidjiban. Bil ŋunubilaŋ inga lim yawŋi, girri lim giŋ kirimban marri Goddji limiliny yaṯi-ḏapiḻidjigi. A ŋunubilaŋ miri bindjirr ŋurrgima lim giŋi, girri ŋilimilaŋ marr-bulaŋgitjnyirbi inga iŋkipmban wanadjnyirban. ");
INSERT INTO dji_vpl VALUES ("J14_19","092_4_19","1JN","4","19","19","A ŋilimi inga lim marr-bulaŋgitjdjirrban gima nyani ŋurrwakŋi limila marr-bulaŋgitjdjini. Miri, nyani limila marr-bulaŋgitjdjini ŋurrwagi, a ŋunuŋir girri lim marŋgidjini inga lim marr-bulaŋgitjdjidji. ");
INSERT INTO dji_vpl VALUES ("J14_20","092_4_20","1JN","4","20","20","Bil wari ŋunupilaŋ bindjirr waŋi gam', “Ŋarri ingarr marr-bulaŋgitjdjirri Godki”, a ŋunuŋ nyani waŋi bilakiṉiŋ inga ŋuy-margiṉidjirrpm wurpigi yulgi, girri ŋunuŋ yul inydji yulgimban. Gima, ŋunubilaŋ iŋki nyani inga marr-bulaŋgitjdjiyi wurpigi yulgi wiriny nyami nyanŋar mildji, nyalikiban nyani inga marr-bulaŋgitjdjirriban Godki Gunydjirrgirki, wirinyi iŋki nyaw giriwi? ");
INSERT INTO dji_vpl VALUES ("J14_21","092_4_21","1JN","4","21","21","A gurrkunyi, djiniŋ yan-gunyirbi Djesudji limiliny guŋili miri bilapilaŋ gam': bubalikiṉiŋ yul wari Godki inga marr-bulaŋgitjdjirri, nyani bilaŋ djina marr-bulaŋgitjdjidji wurpiwiliki yulpilŋirgi girri; bilapilaŋ nyani Djesu limila bultjidjini. ");
INSERT INTO dji_vpl VALUES ("J15_1","092_5_1","1JN","5","1","1","Bubalikiṉiŋ yul wari marr-birralŋakiṉidjirri miri bindjirr gam', nyani Djesu djiniŋ Godaŋ Yirryirrpinakiṉiŋ yul, miri, nyanŋaŋ Christ, girri ŋunuŋ yul nyani birral Godaŋ yidjipili. A ŋilimi bukmak lim marŋgi bilaŋ yulgi inga lim marr-bulaŋgitjdjirri a ŋunuŋ yul nyani gunydjirriŋimi yidjipiligi, girri inga lim marr-bulaŋgitjdjidji nyanŋaŋ yidjipiligi gurrkunyi. Marrga, ŋunubilaŋ ŋilimibi inga lim marr-bulaŋgitjdjirrban Godki, girri djina lim marr-bulaŋgitjdjidjiban warrpamgi ŋunuwiliki yulpilŋirgi wirapili inga djin marr-bulaŋgitjdjirri Godki, gima djani girri nyanŋaŋ yutjuwiliban. ");
INSERT INTO dji_vpl VALUES ("J15_2","092_5_2","1JN","5","2","2","Bil nyalikidjidji lim djiriŋilgi yirrimi djina lim marr-bulaŋgitjdjirrban yutjuwiliki Godaŋ? Djinimirriban lim djiriŋilgi gam': Godki inga lim marr-bulaŋgitjdjirri, a lim butjirgiṉdjirri nyanŋaŋ yangi. ");
INSERT INTO dji_vpl VALUES ("J15_3","092_5_3","1JN","5","3","3","Ŋiy, bilapilaŋdji inga lim marr-bulaŋgitjdjidji Godki, miri, butjinydji lim guŋi nyanŋaŋ yangi, ŋunuŋ nyani limiliny guŋili, a ŋunuŋ lim marrgi a lim butjirgiṉdjidji. A nyanŋaŋ yan iŋki bir-maṉbiŋ limila, ");
INSERT INTO dji_vpl VALUES ("J15_4","092_5_4","1JN","5","4","4","gima ŋurrumban lim yuwirdjidjiniban ganydjirrdji Godar. Ŋiy, bubalikiṉiŋ yul wari buŋtjili Godbi nyani maṉbidjidji, marrga ḏimbitjnyirdjigi nyim mirgi mala djingirapibi munatjabi. A nyalikidjidji lim maṉbidjidji bilapilaŋ miri ŋunuŋi? Ŋunukiṉiŋ marr inydji lim yirrpigi nyanŋali, Djesuli, bilapilaŋdji djinyi lim baŋirigi munatjabi yulpilŋirinyi - ŋunuwiliŋir wirapiliŋir djin iŋki-bultjinmi Godaŋ gadjigirrgi. ");
INSERT INTO dji_vpl VALUES ("J15_5","092_5_5","1JN","5","5","5","Ŋiy, ŋunubilaŋ nyuni marr-birralŋakiṉidjidji nyani Djesu djiniŋi birral Walkiriŋimi Godaŋ, nyuniban bilapilaŋ yul wiḻi djiny ḏimbitjnyirdjim kirim mirikunu yulpilŋirinyi a djanŋaŋ mirikunu rumnyi. ");
INSERT INTO dji_vpl VALUES ("J15_6","092_5_6","1JN","5","6","6","Djesu Christ bi girali munatjali, a gapimirrpmi a buḏimirrpmi nyani limiliny mil-ḻirrpiniban nyani Goddji Gunydjirrar bapiḻi yanili nyaninyi. Miri, gapimirrpmi nyani Djesu bi limila girali, gima guṉgi-yigiliŋili gapili; a buḏimirrpmi limiliny guŋgatjili, gima nyani buḏi djiḻŋdjili nyanŋaŋir galŋiŋir ŋunukiṉiŋ gurrtjimirri nyani wirardjiŋini a balini, bilapilaŋ. Iŋkiban nyani guṉgi-yigiliŋili a girrban, bil ŋunuŋir girri nyani buḏiri limila djiḻŋdjili, marrga lim marrgiban wanŋi birral. A Godaŋ Wugiḻi, ŋunuŋ nyi'nyiniban ŋilimilar, nyani limila bultjinmi djiniŋ, miri, djaŋuny djiniŋ birral, gima Djuyu Wugiḻiri yarim limila bultjigi birral, iŋki limilanydji yuli giri. ");
INSERT INTO dji_vpl VALUES ("J15_7","092_5_7","1JN","5","7","7","Ŋiy, ŋunuwiliŋir warrŋguwiḻidji maladji nyani Goddji limiliny mil-djunupadjili Djesuli, ");
INSERT INTO dji_vpl VALUES ("J15_8","092_5_8","1JN","5","8","8","miri, Djuyudji Wugiḻiri, a gapidji, a buḏiri; a djiniwili warrŋguwiḻi mala djin yitjidjirri, yarim wurpm ŋurrgima djaŋuny limila djin bultjinmi, miri, Djesu djiniŋ Godaŋ Walkiriŋimi. ");
INSERT INTO dji_vpl VALUES ("J15_9","092_5_9","1JN","5","9","9","Ŋunubilaŋ butjinydji lim guŋi a djina lim marr-birralŋakiṉidjidji ŋunukiṉiŋ yulpiliŋir limila djin bultjigi nyim ŋunupilaŋ birraldjini, girri bilaŋ butjir inganydji lim guŋban Godki girrgima a yirrimi lim marr-birralŋakiṉidjidji ŋunugirki djaŋunygi nyanitja limila bultjigi; gima yulpili inydjin yuli bilaŋi, bil nyani God wirr. Ŋiy, nyani God limila bultjidjini ŋunuŋ birral djaŋuny nyanŋapibi Walkiribi, a djiniban ŋunuŋ djaŋuny nyani limila bultjidjini: ");
INSERT INTO dji_vpl VALUES ("J15_10","092_5_10","1JN","5","10","11","“Ŋarri, Goddji Gunydjirrŋirim, ŋilidjarr guŋban birral wanŋi, marrga iŋkiban lidji balidji, bil yarim lidji nyinidjipm bintji kiri ŋurrgima, a ŋunuŋ wanŋi lidji marrgiban ŋirramirrpmi Walkirimirrpmi,” miri bindjin limila waŋini nyani. A ŋunubilaŋ nyuni inga marr-baltjigiban Djesugi, a nyuni marr-yirrimkiṉidjidji nyani djiniŋ Godaŋ Walkiriŋimi, girri nyuni djiriŋilgiban Goddji inma bultjidjini djaŋuny birral Djesubi. Bil ŋunubilaŋ iŋki nyuni inga marr-birralŋakiṉidjidji Godki, girri Godnyi nyuni bultjinmiban yagirri miri “yulginyakiṉiŋ”, gima iŋkiban nyuni marr-birralŋakiṉidjnyir ŋunugirki djaŋunygi ŋunuŋ nyani Goddji Gunydjirrar inma bultjidjini nyanŋapibi Walkiribi, bilapilaŋ. ");
INSERT INTO dji_vpl VALUES ("J15_12","092_5_12","1JN","5","12","12","Ŋiy, Djesudji Godaŋ Walkiriŋirim gatjinmi birral wanŋi ŋilimiliki, marrga ŋunubilaŋ nyuni marrŋili Djesuny, girri ŋunuŋ wanŋi nyuni ŋurrum marrŋiliban nyanŋapibi. Bil ŋunubilaŋ wiḻi ŋunupilaŋ iŋki marrinyir girinyir Godaŋ Walkiriŋim, girri ŋunuŋ yul nyani baḏatj marrgi ŋunugiriny wanŋi. ");
INSERT INTO dji_vpl VALUES ("J15_13","092_5_13","1JN","5","13","13","Djiniwiliny djaŋunypili ŋarri lidjarr wukirridjili, miri, ŋilidjiki wirapili inga lidji marr-birralŋakiṉidjini Djesugi a lidji marrŋili nyaninyi, irr wukirridjili marrga ŋilidji lidji marŋgiban ŋurrum lidji marrŋiliban wanŋi birralban, a lidji nyinidji giriban bintji kiri ŋurrgima. ");
INSERT INTO dji_vpl VALUES ("J15_14","092_5_14","1JN","5","14","14","A miri bilapilaŋ ŋurrgima ŋilimi inga lim marr-baltjigi Godki gam': ŋunukiṉiŋ nyaninyi lim butjalmidji nyimki ŋunupilaŋirgi, a nyani djalŋdjirri lim gatjigi ŋunuŋi, girri nyani limiliny marrŋirrdji butjalminyibi. ");
INSERT INTO dji_vpl VALUES ("J15_15","092_5_15","1JN","5","15","15","A ŋunubilaŋ lim djiriŋilgi nyani limiliny marrŋirriban ŋunukiṉiŋ lim butjalmidji ŋunugirki, girri lim marŋgiban nyani yirrimban limiliny guŋban nyim ŋunupilaŋ lim butjalmini nyaninyi. ");
INSERT INTO dji_vpl VALUES ("J15_16","092_5_16","1JN","5","16","16","Miri galkŋu, ŋunupilaŋ nyuni nyaŋi yulnyi, a nyani djamadjim kirim nyim ŋunupilaŋ mirikunu, a ŋunuŋ mirgi iŋki wana, bil yarim ṉininipm, a ŋunuŋ yul nyani Garray Djesugiṉiŋ, manymak, nyuni bilaŋ inga bumirgiṉdjidji ŋunugirki yulgi djuburr-mirikunugi. Girri nyani Goddji djuy-bultjigiban nyaniny, a wanŋirgiban nyaninyi, gima ŋunuŋ mirgi iŋki wanaban, a ŋunuŋ yul iŋki burr-birrindjiŋinir Godŋir rumŋir. Bil wurpiwili yulpili djani djin burr-birrindjiŋinmi muŋuy Godŋiri, a mirrpm wana mirikunu mala djin djamadjim girimban, a ŋuṉi mirgili nyani buŋban Godaŋ birral wanŋi djanŋari. Ŋunubilaŋ nyuni nyaŋi bilapilaŋ yulŋirinyi a nyani mirgi-djamadjim kirim miri bindjirr ŋurrgima, iŋkiban nyuni bumirgiṉdjidji Garrayili ŋunugirki yulgi, gima iŋki nyani Garraydji wanŋi-guŋi ŋunuŋ yulŋiriny, bilaŋ nyani burr-birrindjiŋini Godŋir djunupaŋir gadjigarrŋir. ");
INSERT INTO dji_vpl VALUES ("J15_17","092_5_17","1JN","5","17","17","Miri, bubalikiṉiŋ mirgi lim djamadjigi, milbimirri Godar lim murgum kirim; nyibi mirgipili djani mirrpm mirikunu, bil wurpiwili mirgipili djani yarim marri mirikunu, a ŋunuwilitji ṉininipili mirgipili iŋki djin malimdjigi ŋunuŋ wanŋi lim marrŋili Godŋiri. ");
INSERT INTO dji_vpl VALUES ("J15_18","092_5_18","1JN","5","18","18","A ŋilimi lim bindjirri lim marŋgi gam': ŋunubilaŋ Godaŋ yutjuwili limi, girri iŋkiban lim mirgi-dji'djamadjigiban muŋuy, a Djesudji, wari buŋtjili Godbi, nyani limiliny djagadjigiban, a ŋuṉi mirikunu wugiḻiri Satandji iŋki nyani limiliny djatdjigiban, gima Godaŋ Walkiriŋirim watjarrdjigiban nyaninyi. ");
INSERT INTO dji_vpl VALUES ("J15_19","092_5_19","1JN","5","19","19","A wurpigi lim marŋgiban miri bilapilaŋ gam': ŋilimi birral Godaŋ yutjuwili limi, a nyanŋar gumbirrmirri lim nyini girimban; bil ŋunuwilitji wurpiwili, miri bukmak ŋunuwili munatjabi yulpili, ŋuṉi mirikunudji wugiḻiri nyani djiny gatjinmiban nyanŋar gumbirrmirri. ");
INSERT INTO dji_vpl VALUES ("J15_20","092_5_20","1JN","5","20","20","A wurpigi lim marŋgiban miri bilapilaŋ gam': Godaŋ Walkiriŋim nyani milarrdjili bapiḻi munatjali, a nyani limiliny marŋgi-gupirrguŋili, marrga inga lim marŋgiban, a nyaninyi lim djiriŋilgiban, miri, nyanigima djiniŋ wurpm birral Miligidji. A ŋilimi lim nyini girimban nyanŋar, ŋiy birral, Godar Walkiriŋirar, Djesu Christar, lim nyiniban. A djinim yul Djesu, nyani djiniŋ birral Miligidji, a nyanŋari lim nyinidji giriban bintji ŋurrum a bintji ŋurrum. ");
INSERT INTO dji_vpl VALUES ("J15_21","092_5_21","1JN","5","21","21","Ŋirraŋ yutjuwili, iŋki djina lidji marr-baltjigi maḏayinpilŋirgi djingirapibi munatjabi, galkŋu miri ŋunuwili maḏayin mala djani munatjabi yulpiliŋir djin djamadjigi djanŋar gumbirrdji, yarim djinyi lidji gubidjiban, a inydji lidji mirrbiliban ŋunuwiliŋir maḏayinŋir malaŋir. ");
ALTER TABLE dji_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
