﻿USE sofia;
DROP TABLE IF EXISTS sofia.dikNT_vpl;
CREATE TABLE dikNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES dikNT_vpl WRITE;
INSERT INTO dikNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Käkkä aa rin kuat kɔc ke dhiëëth Jethu thïn, kuat Bɛ̈nyŋaknhom Debit bɔ̈ cök tënë Abaram. ");
INSERT INTO dikNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abaram ë ye wun Ithäk. Ithäk ë ye wun Jakop. Yen cï Juda bɛ̈n dhiëëth kek wämäthakën kɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda ë ye wun pandiɛɛt, Peredh ku Dhara ku manden ë cɔl Tamar, Peredh ë ye wun Ɣedhron ku Ɣedhron ë ye wun Ram. ");
INSERT INTO dikNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram ë ye wun Aminadap, ku Aminadap ë ye wun Nacon, ku Nacon ë ye wun Thalmon. ");
INSERT INTO dikNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Thalmon ë ye wun Boath, ku man ë cɔl Raɣäp. Boath ë ye wun Obet, ku man ë cɔl Ruth, ku Obet ë ye wun Jethe. ");
INSERT INTO dikNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ku Jethe ë wun Bɛ̈nyŋaknhom Debit, ku Debit ë ye wun Tholomon, ku man ëcï kaŋ aa tiŋ Uria. ");
INSERT INTO dikNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Tholomon ë ye wun Raboam, ku Raboam ë ye wun Abija, ku Abija ë ye wun Atha. ");
INSERT INTO dikNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Atha ë ye wun Jocapat, Jocapat ë ye wun Joram, ku Joram ë ye wun Udhia. ");
INSERT INTO dikNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Udhia ë ye wun Jotham, Jotham ë ye wun Aɣath, ku Aɣath ë ye wun Ɣedhekia. ");
INSERT INTO dikNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ɣedhekia ë ye wun Manathe, Manathe ë ye wun Amon, ku Amon ë ye wun Jothia. ");
INSERT INTO dikNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jothia ë ye wun Jekonia, ku wämäthakën kɔ̈k, ku jɔl ke peec ku ɣɛ̈th ke Babilonia. ");
INSERT INTO dikNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Wën cï ke ɣäth Babilonia aacï la dhiëth këlä, Jekonia acï Cealtiel la dhiëëth. Cealtiel ë ye wun Dherubabel. ");
INSERT INTO dikNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Dherubabel ë ye wun Abiöt ku Abiöt ë ye wun Eliakim. Ku Eliakim ë ye wun Adhor. ");
INSERT INTO dikNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Adhor ë ye wun Dhadok. Dhadok ë ye wun Acim, ku Acim ë ye wun Eliöt. ");
INSERT INTO dikNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliöt ë ye wun Aliadhër ku Aliadhër ë ye wun Mathan. Ku Mathan ë ye wun Jakop. ");
INSERT INTO dikNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ku Jakop ë ye wun Jothep mony Maria, ku ë yen acï Jethu cɔl Raan cï lɔc ku dɔc bɛ̈n dhiëëth. ");
INSERT INTO dikNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Këya, kuat Jethu ë kith, ee ye yic thiäär ku ŋuan jɔɔk Abaram ɣeet Debit, ku ben yic aa thiäär ku ŋuan ɣeet tɛ̈wäär cï ke pɛɛc Babilonia, ku ben yic aa thiäär ku ŋuan jɔɔk kɔc cï dhiëëth Babilonia ɣet dhiënh Jethu raan cï lɔc ku dɔc. ");
INSERT INTO dikNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Dhiënh Jethu ë loi rot këlä. Maria ë wïc Jothep bï thiaak. Tɛ̈wën këc ye gam, ke yök ke cï liëc ë manh yök tënë Wëi Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Jothep, raan awën wïc ye bï thiaak ë ye raan path, ku akëc wïc bï Maria yɔ̈ɔ̈r guɔ̈p, go wïc bï puɔ̈l ke cïn raan piŋ ye. ");
INSERT INTO dikNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Tɛ̈wën wïc yen kënë bï looi, ka atuny Nhialic nyuth rot ye nyuɔ̈th yic ku lueel, “Jothep, manh Debit, duk riɔ̈c ba Maria cïï thiak, rin ë riɛl Wëi Nhialic yen ayök yen manh tɔ̈ yeyäc. ");
INSERT INTO dikNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Yeen abï mɛnh moc dhiëëth, ku aba cäk ke cɔl Jethu rin yen ë raan bï kɔc wɛ̈ɛ̈r bei adumuɔ̈ɔ̈mken yiic.” ");
INSERT INTO dikNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Kënë acï rot looi këya, bï wɛ̈t Nhialic cï raan käkke tïŋ lueel yenhom tiɛɛŋ. Ku wɛ̈t kënë ëcï lueel ëlä, ");
INSERT INTO dikNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Nyan bïm abï liëc, ku abï manh moc dhiëëth ku abï cɔl Emanuel. Ku wɛ̈tde yic, Nhialic atɔ̈ kek ɣook.” ");
INSERT INTO dikNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Këya, Jothep acï kë cï atuny Nhialic lɛ̈k ye gam, ku ɣɛ̈th Maria baai. ");
INSERT INTO dikNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ku aa këc rëër cïmën tik ke moc ɣet tɛ̈ dhiëëth Maria wënde, ku ciɛ̈k Jothep ke cɔl Jethu. ");
INSERT INTO dikNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Tɛ̈wën cï Jethu dhiëëth gen Bethalem pan Judia, wäär ye Ɣërot Bɛ̈ny. Ke bäny kɔ̈k ŋic käk Nhialic bɔ̈ piny ciëën ku ɣëëtkë Jeruthalem, ");
INSERT INTO dikNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ku thiëckë, “Tɔ̈ Bɛ̈nyŋaknhom kɔc Itharel puɔc dhiëëth tɛ̈no? Ciɛ̈ɛ̈rde acuk tïŋ piny ciëën, yen abï ɣok buk bɛ̈n door.” ");
INSERT INTO dikNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nawën piŋ Bɛ̈ny Ɣërot ë wɛ̈t kënë, ke jieth puɔ̈u, agut kɔcdït käk Nhialic Jeruthalem aya. ");
INSERT INTO dikNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Go bänydït käk Nhialic, ku kɔc piööc lööŋ cɔɔl ëbën ku thiëëc ke, “Ye tɛ̈nɛn bï Raan cï lɔc ku dɔc dhiëëth thïn?” ");
INSERT INTO dikNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Gokë lueel, “Abï dhiëëth gen Bethalem pan Judia, cït wɛ̈t cï raan käk Nhialic tïŋ gɔ̈t ëlä, ");
INSERT INTO dikNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Yïn Bethalem pan Judia, na cɔk alɔn koor yïn kam gɛɛthdït pan Judia, ke yïn abï bɛ̈ny mɛc thändiɛ̈n Itharel tuɔ̈l thïn.’ ” ");
INSERT INTO dikNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Go Ɣërot bäny wën bɔ̈ ciëën cɔɔl ë röt, ku thiëëc ke aköl tïŋ kek ciɛ̈ɛ̈r panden. ");
INSERT INTO dikNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ku cɔl ke aa bɛr Bethalem ku thɔn ke ëlä, “Lak wiɛ̈ckë meth apɛi ku na yɔ̈kkë, ke we dhuk bäk bɛ̈n lɛ̈k ɣa, ba la aya, ba la door.” ");
INSERT INTO dikNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Nawën cïk wɛ̈t Bɛ̈ny Ɣërot piŋ ë ke lööny dhöl, ku tïŋkë ciɛ̈ɛ̈r wäär cïk tïŋ ciëën panden ke wat kenhïïm, ku ler ku kɛ̈ɛ̈c ɣöt nhom, ɣön tɔ̈ meth thïn, ");
INSERT INTO dikNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ku mitkë puɔ̈th apɛi. ");
INSERT INTO dikNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ku lek ɣöt ku yökkë meth kek man, ku gutkë kenhiɔl piny ku dorkë, ku liepkë jɔgɔɔken thook ku juërkë mïlɔ̈ɔ̈ŋthith, ku adöŋ ŋïr mit tuɔlde ku adöŋ kec. ");
INSERT INTO dikNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nawën ke nyuɔ̈th ku lëk ke bïk cïï dhuk tënë Ɣërot, gokë dhuk panden dhël dɛ̈t. ");
INSERT INTO dikNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Wën cï kek jäl ka atuny ë Nhialic nyuth rot Jothep ku nyuɛ̈ɛ̈th ëlä, “Jɔt rot ku luɔɔc rot wei kek meth ku man ku lak Ijip, ku rɛ̈ɛ̈rkë thïn ɣet aköl bï ɣɛn we lɛ̈k bäk dhuk, rin Ɣërot awïc meth bï nɔ̈k.” ");
INSERT INTO dikNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Go Jothep rot jɔt ku nyɛɛi meth kek man ë wɛ̈ɛ̈r kënë, ku lek Ijip. ");
INSERT INTO dikNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ku rëërkë thïn ɣet aköl thou Ɣërot, rin bï wɛ̈t raan käk Nhialic tïŋ, cï lueel thɛɛr ëlä yenhom tiɛɛŋ, “Ɣɛn abï Wëndiɛ̈ cɔɔl Ijip.” ");
INSERT INTO dikNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Nawën tïŋ Ɣërot lɔn cï bäny ke bɔ̈ ciëën ye ruëëny, ke riääk puɔ̈u. Ku cɔl mïth röör aa nɛ̈k ëbën Bethalem, ku bɛ̈ɛ̈i kɔ̈k thiääk kek ye, mïth ye ruɔ̈nken rou, ayï mïth kɔ̈k këc run karou dööt, cït tɛ̈ ye täk ye tɛ̈wäär piŋ yen wɛ̈t tënë bäny ciëën. ");
INSERT INTO dikNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ku käk ke cï Jeremia raan käk Nhialic tïŋ lueel thɛɛr, aacï kenhïïm tiɛɛŋ thïn. Ku ëcï lueel ëlä, ");
INSERT INTO dikNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Dhiëëu ëcï piŋ gen Rama, dhiëëu ku kiɛɛu ë dït apɛi. Kɔc Itharel aake dhur miɛ̈thken, Ku aacïï wɛ̈c ë puɔ̈u ye gam, rin cï kek thou ëbën.” ");
INSERT INTO dikNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Nawën cï Ɣërot thou, ka atuny Nhialic ben rot nyuɔ̈th Jothep pan Ijip, ");
INSERT INTO dikNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ku lueel ëlä, “Jɔt rot, ku dhuɔ̈k meth kek man pan Itharel, rin kɔc wäär wïc ye bïk nɔ̈k aacï thou.” ");
INSERT INTO dikNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Go Jothep rot jɔt, ku jiël kek meth ku man, ku dhuk pan Itharel. ");
INSERT INTO dikNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Nawën piŋ lɔn ye Arkelao bɛ̈ny Judia nyin wun, go riɔ̈ɔ̈c bï la Judia, ku ben nyuääth, go muɔ̈l la Judia ku ler Galilia, ");
INSERT INTO dikNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ku ler ku rëër gen cɔl Nadharet. Këya, wël ke cï raan käk Nhialic tïŋ lueel aacï kenhïïm tiɛɛŋ thïn, “Lɔn bï Jethu aa raan Nadharet.” ");
INSERT INTO dikNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ye nïnkä, Joon raan kɔc muɔɔc nhïïm ëcï piɔ̈ɔ̈cde jɔɔk pan Judia, roor tɛ̈ cïï ceŋ, ku lëk kɔc ëlä, ");
INSERT INTO dikNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Pälkë luɔi kärac rin Bääny Nhialic acï thiɔ̈k.” ");
INSERT INTO dikNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Mony kënë, yen ëcï Ithaya raan käk Nhialic tïŋ jam riɛnke thɛɛr wäär lueel yen ye ëlä, “Raan käkkiɛ̈ tïŋ abï piŋ röl ke jam roor tɛ̈ cïï ceŋ, ‘Guiɛrkë dhël ë Bɛ̈ny, luɔikë dhɔ̈lke bïk la cök.’ ” ");
INSERT INTO dikNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Joon ë ye ceŋ alɛ̈th cï looi nhiëm thɔ̈rɔ̈l, ku ceŋ gɔɔp ye aŋum, ku mïïth ke ye cam, aa kɔryɔm ku kiëc. ");
INSERT INTO dikNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Kɔc Jeruthalem ku kɔc juëc pan Judia, ku lɔŋ Jordan ëbën aacï wɛt tënë ye, ");
INSERT INTO dikNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ku lekkë adumuɔ̈ɔ̈mken, ku jɔl Joon ke muɔɔc nhïïm wär Jordan. ");
INSERT INTO dikNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Wën tïŋ Joon kɔc juëc akut Parathï ku Thaduthï ke bɔ̈ tënë ye bï ke bɛ̈n muɔɔc nhïïm, ke lëk ke, “Awek dhiënh käpiɛny! Yeŋa lëk we bäk kat kërɛɛc bɔ̈? ");
INSERT INTO dikNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Luɔikë käk ye nyooth lɔn cï wek muɔ̈l kärac yakë ke looi. ");
INSERT INTO dikNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ku duɔ̈kkë wepuɔ̈th tɔŋ ku luɛlkë ɣok aa mïth Abaram. Alɛ̈k we, lɔn alëu Nhialic bï aleelkä cɔl aaye mïth Abaram. ");
INSERT INTO dikNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ku ëmën yëp acï ther bï ke tiim yep, rin na ye tim cie luɔk mïth path, ka yep ku cuɛt ë mɛɛc. ");
INSERT INTO dikNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Wek aa ya muɔɔc nhïïm ë pïu bäk luɔi kärac puɔ̈l, ku raan bɔ̈ ciëën ɣacök abï we muɔɔc nhïïm ë Wëi Nhialic ku mac. Yeen adït apɛi tënë ɣa, ku ɣɛn acïï path na cɔk a warke ka cä lëu ba ke dɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yeen acït raan muk lɔk ë käm, ye rap kɔ̈ɔ̈m bï rap tek thook ke miël. Ku wiiu rap ku tɔ̈ɔ̈u ke. Ku yɔɔt miël many cie thou.” ");
INSERT INTO dikNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Nawën ke Jethu jiël Galilia bï la Jordan bï Joon la muɔɔc nhom. ");
INSERT INTO dikNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Go Joon them bï Jethu yenhom waar ku lëk ye, “Awiëc bï ya yïn muɔc ɣanhom. Yeŋö bïï yïn tënë ɣa?” ");
INSERT INTO dikNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Go Jethu dhuɔ̈k ye, “Cɔl aloi rot këya. Ee tɛ̈de bï rot looi këlä rin bï ɣok kë wïc Nhialic tiɛɛŋ nhom.” Go Joon gam. ");
INSERT INTO dikNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Kaam wën cï Jethu muɔɔc nhom, ke bɔ̈ bei wïïr ku tïŋ nhial ke liep rot, ku tïŋ Wëi Nhialic ke bɔ̈ yenhom kecït kuur ë dit. ");
INSERT INTO dikNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ku piŋ röl Nhialic nhial ke lueel, “Kënë ë manhdiɛ̈n nhiaar, ɣɛn amit puɔ̈u tënë ye.” ");
INSERT INTO dikNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kaam wën ke Wëi Nhialic la Jethu guɔ̈p, ku ɣɛ̈th roor tɛ̈ cïï ceŋ bï jɔŋrac la them. ");
INSERT INTO dikNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ku jɔl miëth theek nïn thiärŋuan, aköl ku wɛ̈ɛ̈r go cɔk nɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Go jɔŋrac rot cuɔ̈t ye ku lueel, “Na ye Wën Nhialic, ke lɛ̈k aleelkä bïk röt wel bïk ya ayuɔ̈p.” ");
INSERT INTO dikNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Go Jethu bɛ̈ɛ̈r, “Acï gɔ̈t thɛɛr ëlä, ‘Raan acie pïr ayup ë rot, ee pïr wël bɛ̈n bei ëbën Nhialic thok.’ ” ");
INSERT INTO dikNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Go jɔŋrac ɣäth gendït ku tɛ̈ɛ̈u luaŋ Nhialic nhom, ");
INSERT INTO dikNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ku lueel tënë ye, “Na ye wën Nhialic, ke yï cuɛt rot piny, rin ëcï gɔ̈t ëlä, ‘Nhialic abä atuɔ̈ɔ̈cke lɛ̈k bïk yï muk kecin, ba yïcök cïï deeny alɛl.’ ” ");
INSERT INTO dikNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Go Jethu lɛ̈k ye, “Acï gɔ̈t ëlä aya, ‘Duk Nhialic Bänydu them ë path.’ ” ");
INSERT INTO dikNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Go jɔŋrac bɛn ɣäth gɔn bär apɛi nhom, ku nyuth bɛ̈ɛ̈i pinynhom ëbën ke diɛɛkden. ");
INSERT INTO dikNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ku lueel tënë ye, “Käkkä ëbën aba yiëk yï tɛ̈ cuɛt yïn rot piny ku door ɣa.” ");
INSERT INTO dikNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Go Jethu lɛ̈k ye, “Jälë, Jɔŋ ater, rin acï gɔ̈t ëlä, ‘Yïn abï Nhialic Bänydu door ku loi wɛ̈tde yetök!’ ” ");
INSERT INTO dikNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Go jɔŋrac nyääŋ piny, ku bɔ̈ atuuc nhial ku konykë. ");
INSERT INTO dikNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Nawën piŋ Jethu lɔn cï Joon dɔm, ke dhuk Galilia. ");
INSERT INTO dikNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ku jiël Nadharet gɛnden ku le rëër Kapernaum, gen thiääk kek wär Galilia, lɔŋ Dhebulun ku Naptalï. ");
INSERT INTO dikNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Kënë ëcï rot looi, bï wɛ̈t cï Ithaya raan käk Nhialic tïŋ lueel yenhom tiɛɛŋ, ");
INSERT INTO dikNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Piny ë Dhebulun ku piny Naptalï, tɛ̈ la wïïr, wär Jordan alɔŋtui, Galilia, wun thäi juëc kuc Nhialic! ");
INSERT INTO dikNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Kɔc ke rɛ̈ɛ̈r muɔ̈ɔ̈th yic aacï ruɛldït apɛi tïŋ. Ku kɔc ciëŋ piiny muɔ̈ɔ̈th yic tɛ̈n thou, ruɛl acï bɛ̈n.” ");
INSERT INTO dikNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ku ë nïnkä, Jethu acï piɔ̈ɔ̈cde jɔɔk, ku lëk kɔc ëlä, “Pälkë luɔi kärac, rin Bääny Nhialic acï thiɔ̈k.” ");
INSERT INTO dikNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Tɛ̈wën kuɛny Jethu wär Galilia yɔu, ke tïŋ amɛ̈i karou, Thaimon, ku ë cɔl Pïtɛr aya, kek Andria wämënh ke dɔm rec buɔi. ");
INSERT INTO dikNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Go lɛ̈k ke, “Biathkë ɣa ku wek aaba piɔ̈ɔ̈c bäk kɔc aa dɔm.” ");
INSERT INTO dikNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Gokë biaiken nyääŋ piny nyin yic ku buɔthkë Jethu. ");
INSERT INTO dikNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Wën jiël yen ë tɛ̈n, ke tïŋ Jemith ku Joon kek wunden Dhubedï riäi yic, ke guir biaiken. Go Jethu ke cɔɔl. ");
INSERT INTO dikNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Gokë lööny dhöl nyin yic kek ye, ku nyiëëŋkë wunden piny riäi yic. ");
INSERT INTO dikNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ku jɔl Jethu pan Galilia kuany yic, ke ye piööc ɣɔ̈n amat yiic, ku lëk kɔc Wɛ̈t Puɔth Yam ë Bääny Nhialic, ku kony kɔc kuat tuaany ëbën bïk pial. ");
INSERT INTO dikNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Go lɛcde thiëi piny pan Thiria ëbën, go kɔc ke tuany tuɛny juëc, kɔc ke rem gup apɛi, ku kɔc cï jakrɛc dɔm, ku kɔc la gup nok ku kɔc cï ruai, bɛ̈ɛ̈i tënë ye. Goke kony bïk pial. ");
INSERT INTO dikNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Go kɔc juëc apɛi pan Galilia, ku gɛɛth kathiäär yiic, ku Jeruthalem ku Judia ku bɛ̈ɛ̈i kɔ̈k lɔŋ Jordan, buɔɔth. ");
INSERT INTO dikNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Wën tïŋ Jethu kɔc juëc apɛi, go la tɛ̈thöny gɔt nhom. Ku nyuuc ku mɛ̈t kɔcken ye buɔɔth röt ye, ");
INSERT INTO dikNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","go jam ku piööc ke ëlä, ");
INSERT INTO dikNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Kɔc mit gup aa kɔc ë lɛŋ kepuɔ̈th, rin ye Bääny pan Nhialic këden! ");
INSERT INTO dikNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Kɔc mit gup aa kɔc dhuɔ̈ɔ̈r rin bï Nhialic ke waac puɔ̈th! ");
INSERT INTO dikNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Kɔc mit gup aa kɔc lir puɔ̈th, rin bï kek kë cï Nhialic thɔn yök! ");
INSERT INTO dikNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Kɔc mit gup aa kɔc nɛ̈k tuil puɔ̈n la cök, ku aabï kuɛth yeen! ");
INSERT INTO dikNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Kɔc mit gup aa kɔc abiökruɛl, rin bï keek kony aya! ");
INSERT INTO dikNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Kɔc mit gup aa kɔc ɣer puɔ̈th, rin bï kek Nhialic tïŋ! ");
INSERT INTO dikNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Kɔc mit gup aa kɔc ë kɔc dɔ̈ɔ̈r, rin bï keek aa cɔl mïth Nhialic! ");
INSERT INTO dikNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Kɔc mit gup aa kɔc ye jöör rin wɛ̈t path, rin ye pan Nhialic këden! ");
INSERT INTO dikNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Wek aa mit gup tɛ̈ lɛ̈ɛ̈t we ku näk we, ku tör kɔc kɔ̈k wegup wël lueth ë riɛnkiɛ̈. ");
INSERT INTO dikNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Yakë puɔ̈th miɛt ku dalkë wepuɔ̈th, rin bï ariɔ̈pdun dït apɛi pan Nhialic. Yen ë tɛ̈wäär jöör kek kɔc käk Nhialic tïŋ thïn aya. ");
INSERT INTO dikNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Wek aa cït awai pinynhom. Ku na thöök kɔ̈u alɛ̈i, ke ben dhuɔ̈k thïn këdë? Awan cït kënë acie bɛn piath. Aye puɔ̈k wei bï ya dum kɔc cök. ");
INSERT INTO dikNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Wek aa mermer pinynhom ëbën. Gen cï buth gɔt nhom acie thiaan. ");
INSERT INTO dikNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Acïn raan mermer dɛ̈ɛ̈p ku kum nyin, aye tɔ̈ɔ̈u tɛ̈n ë yen ɣöt mer yic thïn tënë kɔc tɔ̈ ɣööt ëbën. ");
INSERT INTO dikNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Këya, mermer adhil tïŋ kɔc ëbën, rin na tïŋkë luɔidun path la cök ka lec Wuurdun tɔ̈ nhial. ");
INSERT INTO dikNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Yakë tak lɔn cï ɣɛn bɛ̈n, ba löŋ Mothith ayï käk ye kɔc käk Nhialic tïŋ piɔ̈ɔ̈c bɛ̈n rac? Acie tɛ̈de, ɣɛn akëc bɛ̈n ba ke bɛ̈n rac, ɣɛn acï bɛ̈n ba ke bɛ̈n thääp. ");
INSERT INTO dikNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Alɛ̈k we alanden, agut tɛ̈ bï nhial ku piny liu, acïn wɛ̈t koor ayï këthiin tɔ̈ löŋ yic, bï kaŋ määr ke këc guɔ̈t nhom. ");
INSERT INTO dikNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Këya, raan dhoŋ lɔ̈ŋ tök kɔ̈u, cɔk a löŋ thin koor, ku piööc kɔc kɔ̈k bïk löŋ dhoŋ kɔ̈u aya, acïn tɛ̈pɛth bï yök pan Nhialic. Ku raan thek ke, ku ye ke piɔ̈ɔ̈c abï ya raandït apɛi pan Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Alɛ̈k we, na cïï piathdun ku luɔidun la cök, abï luɔi kɔc piööc lööŋ Nhialic ku luɔi Parathï waan thok, ke wek aacïï la pan Nhialic alanaɣɔn. ");
INSERT INTO dikNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Acäk piŋ lɔn cï ye lɛ̈k wärkuan dït thɛɛr ëlä, ‘Duk raandä näk, ku na ye raan näk raan dɛ̈t ka bï luɔ̈k wei.’ ");
INSERT INTO dikNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ku wek aa lɛ̈k wɛ̈t kënë, raan la puɔ̈u agɔ̈th tënë raandä, abï luɔ̈k wei aya. Ku na ye raan lat wämënh, ‘Yïn acïn nhom!’ Ka tëm thou, ku na ye raan lat raan dɛ̈t, ‘Yïn acïn puɔ̈u,’ Ka bï ɣäth pan mac. ");
INSERT INTO dikNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Na lɔ juar ariäk nhom, ku lɔ tak lɔn cï wämuuth puɔ̈u riääk tënë yï, ");
INSERT INTO dikNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ke yï nyiëëŋ këdu ariäk lɔ̈ɔ̈m ku lɔɔr bäk kaŋ la dɔ̈ɔ̈r wek wämuuth, ku jɔl dhuk ba Nhialic la juɛ̈r. ");
INSERT INTO dikNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Lɔc wɛ̈t waar yic ku dɔ̈ɔ̈rkë wek raan ɣɛ̈th yï luk yic. Na cïï lɔc looi këlä, ka ɣɛ̈th yï luk yic tënë bɛ̈ny. Ku bɛ̈ny abï yï la thɔ̈n apuruuk, ku mac yï. ");
INSERT INTO dikNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Yïn alɛ̈k yic, yïn acïï bï kaŋ lony ɣet tɛ̈ bï yïn këthiin kɔ̈ny tënë yï kaŋ cool. ");
INSERT INTO dikNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Acäk piŋ lɔn cï ye lueel thɛɛr ëlä, ‘Duk tiŋ raandä kɔr.’ ");
INSERT INTO dikNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ku alɛ̈k we, raan döt tik ku tuiil ye, kacït raan cï tik kɔɔr aya rin tɔ̈ yen yepuɔ̈u. ");
INSERT INTO dikNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Këya, na ye nyindun cuëc yï cɔl aloi awuɔ̈c, ke ŋuët bei ku cuat wei! Aŋuɛ̈ɛ̈n ba cɔr nyiɛn tök, tɛ̈në lɔn bï yï cuat pan mac ëbën. ");
INSERT INTO dikNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ku na ye cindun cuëc yï cɔl aloi awuɔ̈c, ke tɛɛm wei. Aŋuɛ̈ɛ̈n ba la ciɛɛn tök, tɛ̈në lɔn bï yïn la pan mac. ");
INSERT INTO dikNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Acï lueel aya ëlä thɛɛr, ‘Raan päl tiɛŋde adhil athör ë liɔ̈ɔ̈i gɔ̈t tënë tik.’ ");
INSERT INTO dikNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ku alɛ̈k we, na ye raan cï tiɛŋde liɔ̈ɔ̈i ke këc wïc mony dɛ̈t, ka bï ye cɔl aloi adumuɔ̈ɔ̈m, ku raan thiak tiŋ cï liɔ̈ɔ̈i ka cä akɔr looi. ");
INSERT INTO dikNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Acäk piŋ aya lɔn cï ye lɛ̈k kɔckun thɛɛr ëlä, ‘Duk mël kuëŋ ë lueth, muk kuëëŋdun ca looi tënë Bɛ̈ny.’ ");
INSERT INTO dikNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ku alɛ̈k we, duɔ̈kkë mël kuëŋ, tɛ̈dë rin pan Nhialic tɛ̈dë rin ë Bäänyde, ");
INSERT INTO dikNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","tɛ̈dë rin piny, rin yen ë tɛ̈ mɛc Nhialic ku duk kuëëŋ Jeruthalem rin ë gen Bɛ̈nydït. ");
INSERT INTO dikNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Duk kuëëŋ ë cɔ̈ɔ̈kdu rin acie yïn yï cak ye. ");
INSERT INTO dikNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Jamdu ë lɔn bï yïn ye lueel amääth ë path, ‘Ee këya’ ku, ‘Acie këya,’ Kë ye juak thïn, ee bɛ̈n tënë jɔŋrac. ");
INSERT INTO dikNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Acäk piŋ aya ke cï lueel ëlä, ‘Na yup raan yï nyin ke yup nyin aya, na dhoŋ yïlëc ke dhoŋ lëc.’ ");
INSERT INTO dikNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ku wek alɛ̈k kënë, duk kërac col kërɛɛc dɛ̈t. Na gut raan gëmdun cuëc ke wɛ̈l gëm dɛ̈t aya. ");
INSERT INTO dikNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Na wïc raan dɛ̈t bï këdun path tuɔ̈ɔ̈r nyin, ke mät këdun dɛ̈t puɔth nhiar aya. ");
INSERT INTO dikNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Na cɔl raan yï ba këthiek muk tënë ye, ke ruac ba ɣäth tɛ̈mec. ");
INSERT INTO dikNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Muɔc raan lim yï, ku na wïc raan këdäŋ tënë yï, ke gäm ye. ");
INSERT INTO dikNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Acäk piŋ ke cï lueel ëlä, ‘Nhiar kɔc määth kek yï ku man kɔc ater.’ ");
INSERT INTO dikNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ku alɛ̈k we, nhiarkë kɔc atɛrdun ku rɔ̈ɔ̈kkë rin kɔc jör we, ");
INSERT INTO dikNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","rin bï wek jäl ciɛ̈t mïth Wuurdun tɔ̈ nhial, rin ë piny cɔl abak tënë kɔc path ku kɔc rɛc kedhie, ku cɔl deŋ atueny tënë kɔc ë luui käpath ku kɔc luui kärac aya. ");
INSERT INTO dikNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Na nhiar ke ë kɔc nhiar yï kepɛ̈c, ke ye rin ŋö bï Nhialic yï kony? Cïï kɔc kut ajuër ye looi këlä aya? ");
INSERT INTO dikNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Na yeke muɔ̈ɔ̈th ë kɔc määth kek yï ë röt, ke la këpɛth ca looi wɛ̈r yïn kɔc kɔ̈k? Cïï kɔc cie kɔc Itharel këcït kënë ye looi aya? ");
INSERT INTO dikNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Yïn adhil piath cïmën puɔth Wuur tɔ̈ nhial! ");
INSERT INTO dikNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Tiɛtkë röt bäk käpath cïï ye looi ë kɔc nhïïm rin bï we tïŋ. Na luɔikë këya, ka cïn ariöp bäk yök tënë Wuurdun tɔ̈ nhial. ");
INSERT INTO dikNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Na le raan ŋɔ̈ŋ ca kony, ke yï duk nhiam ba ya cath ke luel cïmën kɔc alueth, ye looi tɛ̈n amat ku dhɔ̈l yiic, rin bï ke leec. Dɛtkë apath, kek ë kɔckä acïn ariöp dɛ̈t benkë yök. ");
INSERT INTO dikNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ku na gäm raan ŋɔ̈ŋ këdäŋ, ku cɔk a mäthdu ke duk cɔl aŋic. ");
INSERT INTO dikNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Rin bï këdun cï yïn raandä kony cïï ŋic. Na loi këya, ke yïn abï Nhialic cuɔ̈ɔ̈t, raan yen këriëëc ëbën ŋic, agut kë cï moony. ");
INSERT INTO dikNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ku tɛ̈ röök yïn, duk kɔc alueth kïït, anhiarkë bïk röök ke kääc tɛ̈n amat ku dhɔ̈l yöth, rin bï ke tïŋ. Ku alɛ̈k we, keek aacä ariɔ̈pden yök. ");
INSERT INTO dikNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","“Tɛ̈ röök yïn, ke yï la tɛ̈du ë rot, ku rɔ̈ɔ̈k tënë Wuur Nhialic cie tïŋ, rɛ̈ɛ̈r ë tɛ̈në, ku yen Wuur daai yï, yen abï cuɔ̈ɔ̈t. ");
INSERT INTO dikNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ku tɛ̈ röök yïn, duk wël ye ber yiic ë path cïmën kɔc kuc wɛ̈t Nhialic, kɔc ye tak lɔn na luelkë wël juëc, ke yen bï Nhialic rɔ̈ɔ̈kken piŋ? ");
INSERT INTO dikNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Duk rot loi ba ciɛ̈t ke, rin Nhialic ë kë tɔ̈ yïpuɔ̈u guɔ ŋic ke kɛ̈c cak thiëëc. ");
INSERT INTO dikNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Këya, yïn adhil röök ëlä, ‘Wädan tɔ̈ nhial, bï riɛnku aleec, ");
INSERT INTO dikNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","bï bäänydu bɛ̈n ɣoyiic, bï wɛ̈tdu alooi piiny cïmën nhial. ");
INSERT INTO dikNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Muɔc ɣook miëth yaköl. ");
INSERT INTO dikNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Päl wɛ̈t piny tënë ɣook, cïmën ye ɣok ye puɔ̈l tënë kɔc rɛc ɣook. ");
INSERT INTO dikNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ku duk ɣook cɔl athem kërac, ku ba ɣook lac waar kërac yic.’ ");
INSERT INTO dikNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Rin na ye wɛ̈t päl piny tënë kɔc kɔ̈k, ke Nhialic abï wɛ̈t päl piny tënë yï aya. ");
INSERT INTO dikNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ku na cïï wɛ̈t ye päl piny tënë kɔc kɔ̈k, ke Nhialic acïï wɛ̈t pɛ̈l piny tënë yï. ");
INSERT INTO dikNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Tɛ̈ thëk yïn, duk rɛ̈ɛ̈r yï ŋɔ̈ŋ nyin cïmën ye kɔc ruëëny ye looi. Aake nyïn looi ŋuarar bïk nyuɔɔth lɔn thëk kek. Alɛ̈k we, keek aacä ariɔ̈pden yök. ");
INSERT INTO dikNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Tɛ̈ thëk yïn, rɛ̈ɛ̈r ë path ku duk nyooth lɔn nɛ̈k cɔk yï, ");
INSERT INTO dikNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","bï ciɛ̈n raan ŋic ye lɔn thëk yïn, ku Nhialic Aciëŋ yen kë ye ŋɛk looi ë rot ŋic, yen abï yiëk ariɔ̈pdu. ");
INSERT INTO dikNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Duɔ̈kkë jak käk tɔ̈ pinynhom rin ye aruɔp ku keth ke rac, ku aaye cuɛ̈r kual aya. ");
INSERT INTO dikNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Këya, apath bï ya jiɛɛk pan Nhialic yen wïc, yen acïn kë bï ye rac. ");
INSERT INTO dikNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Rin piändu abï ya rëër akölaköl tɛ̈ tɔ̈ jaakdu thïn. ");
INSERT INTO dikNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Këya, puɔ̈n path acït nyin path, raan path nyin ee daai apath, acïï thöŋ kek raan cï cɔr. Raan la puɔ̈n ɣer acït raan path nyin, ");
INSERT INTO dikNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ku raan ye ŋic këde ë rot, ee raan col puɔ̈u cït cɔr cie piny ë tïŋ! ");
INSERT INTO dikNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Acïn raan bäny karou luɔ̈ɔ̈i ë tök, tɛ̈dë ka man bäny tök ku nhiɛɛr bɛ̈ny dɛ̈ɛ̈të, tɛ̈dë ka thek raan tök ku dhɛ̈l raan dɛ̈t. Acïï raan lëu bï Nhialic ku jiɛɛk nhiaar kedhie. ");
INSERT INTO dikNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Këya, alɛ̈k we bäk cïï ye diɛɛr kë bäk cam, ku kë bäk dek, rin bï wek rëër we pïr, tɛ̈dë ke we diɛɛr käk bäk ceŋ. Wëi aŋuɛ̈ɛ̈n tënë miëth. Ku guɔ̈p raan cïï ŋuɛ̈ɛ̈n tënë alɛ̈th? ");
INSERT INTO dikNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Daaikë diɛt ë pär nhial, aa cie pur, ku aa cïn mïïth yekë ke tɔ̈ɔ̈u, ee Wuur tɔ̈ nhial yen ë diɛɛr ë ke! Na week cäk ye kädït apɛi tënë ke? ");
INSERT INTO dikNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Yeŋa kamkun na diir piɛ̈rde, ke juak ruɔ̈nke? ");
INSERT INTO dikNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ku yeŋö ye wek diɛɛr käk bäk ceŋ? Tiɛ̈ŋkë yɔ̈k pɛth ë cil roor, aa cie luui ku aa cie alɛ̈th ë kɔɔc ë riɛnken. ");
INSERT INTO dikNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ku adhiɛl lɛ̈k we na cɔk a Bɛ̈nyŋaknhom Tholomon wäär ë jaakde yic, ee cïï cït ke. ");
INSERT INTO dikNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ku na ye Nhialic wɛl tɔ̈ roor cɔl adhëŋ këya, wɛl tɔ̈ thïn ëmën, ku na nhiäk nïn lik ke ril wei ku took ke mac, ke yeen cïï we bï kuɛ̈ɛ̈c nhïïm? Ye gam thiin koor ŋö be rëër kek we këya! ");
INSERT INTO dikNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Duɔ̈kkë ye diɛɛr ku luɛlkë, ‘Yeŋö buk cam? Yeŋö buk dek? Buk kë ceŋku yök tɛ̈no?’ ");
INSERT INTO dikNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","(Aa kɔc kuc wɛ̈t Nhialic kek aa kepuɔ̈th yiëk ë käkkä.) Ku aŋic Wuurdun tɔ̈ nhial lɔn wïc wek käkkä ëbën. ");
INSERT INTO dikNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Yakë wepuɔ̈th wɛ̈l bäänyde kek käk wïc ke tënë we, käjuëc wiɛ̈ckë ke aabï yiëk we. ");
INSERT INTO dikNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Këya duɔ̈kkë ye diɛɛr ë nhiäk, nhiäk abï bɛ̈n kek käkke. Akɔ̈l ëbën ala yic këraacde ë rot. ");
INSERT INTO dikNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Duk kɔc kɔ̈k ye nyieeny kärac cïk looi käk ye ke looi aya, rin bï yï cïï gut nyin, ");
INSERT INTO dikNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","rin tɛ̈ ye luɔ̈k kɔc kɔ̈k, yen ë tɛ̈ bï Nhialic yï luɔ̈k thïn aya. ");
INSERT INTO dikNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Yeŋö, ye yïn kërɛɛc dït ye looi kuc, ku ye tïŋ kërɛɛc koor ye wämuuth looi? ");
INSERT INTO dikNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ye këdë bï yïn ke mɛnhkui dɔk kärac ye looi, ku keek aaye looi aya? ");
INSERT INTO dikNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Awëëŋkui! Kaŋkë kärac yakë ke looi puɔ̈l, yen abï wek ye lëu bäk miɛ̈thakun jäl wɛ̈ɛ̈t. ");
INSERT INTO dikNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Duk jɔ̈k gɛ̈m kënë Nhialic, ku duk rot gɔ̈u ba wɛ̈t lëk kɔc cïï ye bï gam, tɛ̈dë aabï kuec ku näkkë yïïn. ");
INSERT INTO dikNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Thiëc, ku abï gäm yï, wïc ku aba yök, gut ɣöt thok ku abï ŋaany thok tënë yï. ");
INSERT INTO dikNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Raan ë thiëc, aye gäm këdäŋ, ku raan wïc këdäŋ, ee kë wïc yök, ku raan ɣöt tɔɔŋ thok aye ŋäny thok ye akölaköl. ");
INSERT INTO dikNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nadë le raan kamkun gɛ̈m manhde dööt tɛ̈ wïc yen miëth? ");
INSERT INTO dikNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Nadë, ke gɛ̈m këpiny, tɛ̈ cï yen ye thiëëc ë rɛ̈c? ");
INSERT INTO dikNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Na yakë ŋic wek kɔc cïï path bäk miɛ̈thkun aa gäm käpath wïckë ke, ke Wuur tɔ̈ nhial cïï käjuëc path bï gäm kɔc ye thiëëc! ");
INSERT INTO dikNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Loi käpath tënë kɔc kɔ̈k, cïmën nhiɛɛr yïn ye bïk käpath looi tënë yï aya, käkkä kek aacï lueel thɛɛr athör Nhialic yic. ");
INSERT INTO dikNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Kuany dhël ye kɔc gum thïn yic, rin dhël cïï kɔc ye gum thïn, ee kɔc ɣäth pan mac, ku ë yen aye kɔc juëc mɛ̈r thïn.” ");
INSERT INTO dikNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ku dhël ye kɔc gum thïn yen ë la pan Nhialic, ku aa kɔc lik kek aaye kuany yic. ");
INSERT INTO dikNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Tiɛtkë röt kɔc piööc wël ë lueth, kɔc bɛ̈n tënë we ku luelkë wël puɔth cï la läiläi, ku käk rɛ̈ɛ̈r keyääc arac apɛi. ");
INSERT INTO dikNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Aa bäk ŋic tɛ̈den ye kek luui thïn. Acïn mïth tim ye cam, ye bet tim dɛ̈t cie ye nhom. ");
INSERT INTO dikNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Këya, tim ye miɛ̈thke cam ë luɔk mïth path, ku tim rac cïï miɛ̈thke ye cam, acïn kë ye yök tënë ye. ");
INSERT INTO dikNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tim pɛth ye miɛ̈thke cam acïï lëu bï dhiëth mïth rɛc, ku tim cïï miɛ̈thke ye cam acie kaŋ luɔk mïth ye cam. ");
INSERT INTO dikNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ku kuat tim cïn kë ye kuany tënë ye aye yep ku tok. ");
INSERT INTO dikNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Abɛn lɛ̈k we, kɔc aa lueth, aa bäk ŋic tɛ̈den ye kek luui thïn. ");
INSERT INTO dikNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Acie kuat raan ɣa cɔɔl, ‘Bɛ̈ny, Bɛ̈ny,’ Yen bï la pan Nhialic, aa kɔc kë wïc Wä tɔ̈ nhial looi kek aabï Bääny Nhialic yök. ");
INSERT INTO dikNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Tɛ̈ le aköl kënë bɛ̈n, abï kɔc juëc lueel tënë ɣa, ‘Bɛ̈ny, Bɛ̈ny! Ɣok aacï wɛ̈t Nhialic piɔ̈ɔ̈c ë riɛnku. Ku ɣok aacï jakrɛc cuɔp wei ë riɛnku, ku loiku käjuëc kɔc gɔ̈i!’ ");
INSERT INTO dikNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ku aba lɛ̈k ke, ‘Wek aa kɛ̈c kaŋ ŋic. Jälkë ɣalɔ̈ɔ̈m, kɔc ë luui kärac!’ ");
INSERT INTO dikNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Këya, kuat raan wëlkiɛ̈n kä piŋ, ku luui ë wëlkä, abï ciɛ̈t raan ŋic käŋ cï paande looi tɛ̈thöny. ");
INSERT INTO dikNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Go deŋ tuɛny ku bɔ̈ aboor ku yomdït apɛi. Ku paande akëc wïïk rin cï ye buth tɛ̈thöny. ");
INSERT INTO dikNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ku kuat raan wëlkiɛ̈n kä piŋ ku cïï lui ë ke, abï ciɛ̈t raan abɛ̈ɛ̈l cï paande looi tɛ̈thuth. ");
INSERT INTO dikNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Go deŋ tuɛny apɛi ku bɔ̈ aboor ku yomdït, go baai wïïk ëbën abï ciɛ̈n ɣön töŋ dɔ̈ŋ!” ");
INSERT INTO dikNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Wën cï Jethu wël ke wïc bï keek lueel thöl, go thän awën tɔ̈ thïn gäi tɛ̈ cï yen ke piɔ̈ɔ̈c thïn, ");
INSERT INTO dikNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","rin Jethu acïï cït kɔcken piööc ë lööŋ, rin acï piööc ke la riɛl Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Wën cï yen bɛ̈n piny gɔt nhom, ëcï kɔc juëc apɛi buɔɔth. ");
INSERT INTO dikNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Go raan cï tuet bɛ̈n tënë ye ku gut yenhiaal piny yenhom ku lueel, “Bɛ̈ny, na wïc ke yïn cɔl ë tuen kënë adem.” ");
INSERT INTO dikNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Go Jethu yekök riny ku gɔɔt, ku lueel, “Ee yic awiëc, Piaalë!” Go tuet guɔ dɛm nyin yic. ");
INSERT INTO dikNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ku lëk Jethu ye, “Muk yïnhom apath duk kënë lëk raan dɛ̈t, lɔɔr ku nyuɔ̈th rot raan käk Nhialic bï caath, ku juar käŋ cït tɛ̈ ye löŋ Mothith ye luɛɛl thïn, bï kɔc ëbën ŋic lɔn cï yïn pial.” ");
INSERT INTO dikNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Wën cï yen ɣet Kapernaum, ke bɛ̈ny mɛc apuruuk juëc bɔ̈ tënë ye ku lɛ̈ŋ, ");
INSERT INTO dikNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Bɛ̈ny, raan lui paandiɛ̈ atɔ̈ baai ke tuany, acïn tɛ̈ ye yen rot cak jɔt, adhɛ̈l apɛi.” ");
INSERT INTO dikNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Go Jethu lueel. “Ɣɛn abï la ba kony bï pial.” ");
INSERT INTO dikNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Go bɛ̈ny apuruuk bɛ̈ɛ̈r, “Bɛ̈ny, duk rot näk cäth, rin ɣɛn acie raan path nadë ke yï bɔ̈ atiɛ̈mdiɛ̈ yic, toc wɛ̈tdu ë path ku yeen abï pial. ");
INSERT INTO dikNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Rin ɣɛn aya, ɣɛn arɛ̈ɛ̈r bänydït cök, ku ɣɛn ala apuruuk rɛ̈ɛ̈r ɣacök. Ku aya lɛ̈k ŋɛk. ‘Lɔɔr!’ Ka la, ku lɛ̈k ŋɛk, ‘Bäär tɛ̈n!’ Ka bɔ̈. Ku lɛ̈k raan lui paandiɛ̈, ‘Loi kënë!’ Ka looi.” ");
INSERT INTO dikNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Kaam wën piŋ Jethu wël raan kënë ke gɛ̈i, ku lëk kɔc awën buɔth ye, “Alɛ̈k we ayic, acïn raan töŋ ca kaŋ yök Itharel ke la gamdït cït kënë. ");
INSERT INTO dikNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Muɔ̈kkë kënë nhom, kɔc juëc aabï bɛ̈n pinynhom ëbën ku nyuuckë ë tök kek Abaram, ku Ithäk, ku Jakop yai yic bääny yic pan Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ku kɔc ke bï rëër bääny yic aabï ciɛɛc aɣeer muɔ̈ɔ̈th yic, tɛ̈ bï kek rëër thïn ke dhiau bïk kethook aa kac, ke cï nhïïm la cɔ̈t.” ");
INSERT INTO dikNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ku wël yethok bɛ̈ny apuruuk ku lueel, “Lɔɔr, dhuɔ̈k baai, yïn acï gam, ku kënë abï looi tënë yï.” Ku raanden luɔi acï guɔ pial ë tɛ̈n awën. ");
INSERT INTO dikNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Tɛ̈wën le Jethu pan Pïtɛr, ke yök man tiŋ Pïtɛr piiny biöök yic ke cï juäi göök. ");
INSERT INTO dikNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Go gɔɔt, go juäi jäl, ku jɔt rot ku looi miëth tënë ke. ");
INSERT INTO dikNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Naɣɔn thëëi, ke kɔc juëc la gup jakrɛc bïï tënë ye. Go jakrɛc cuɔp wei kegup wɛ̈t thok ë path, ku kony kɔc tuany bïk pial. ");
INSERT INTO dikNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Kënë acï rot looi rin bï wɛ̈t cï Ithaya lueel thɛɛr yenhom tiɛɛŋ, “Acï kuat arɛɛm ku tuaany ëbën jat yeyeth.” ");
INSERT INTO dikNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nawën tïŋ Jethu thändït apɛi yelɔ̈ɔ̈m, ke lëk kacke bïk teem wär alɔŋtui. ");
INSERT INTO dikNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Go raan piööc lööŋ bɛ̈n tënë ye ku lueel, “Bänydiɛ̈, yïn aba biaath kuat tɛ̈ ler yïn thïn.” ");
INSERT INTO dikNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Go Jethu bɛ̈ɛ̈r, “Luɔny roor aala ɣöötken yekë ke wuut, ku diɛt pär aala ɣɔ̈ɔ̈tken, ku Manh Raan acïn nhom baai pinynhom tɛ̈n.” ");
INSERT INTO dikNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Go raan dɛ̈t kam kɔc ye buɔɔth lueel tënë ye, “Bɛ̈ny, cɔl ɣa akɔŋ wä la thiɔ̈k.” ");
INSERT INTO dikNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Go Jethu bɛ̈ɛ̈r, “Buɔth ɣa, ku päl kɔc cït kɔc cï thou bïk kacken thiɔ̈k.” ");
INSERT INTO dikNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Go Jethu la riäi yic, ku buɔɔth kɔcken ye buɔɔth. ");
INSERT INTO dikNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Kaam awën, ke yomdït ril apɛi jɔt rot, ku loi atiaktiak rot bï riäi duër puk yic, ku Jethu ë nin. ");
INSERT INTO dikNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Go kɔcken ye buɔɔth la tënë ye ku puɔ̈ckë ke dhiau, “Luäk ɣo, Bɛ̈ny, ɣok aa dïïr!” ");
INSERT INTO dikNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Go lɛ̈k ke, “Wek kɔc koor gamdun, yeŋö ye wek riɔ̈ɔ̈c këlä?” Ku jɔt rot ku rël yom ku atiaktiak, gokë la dïl. ");
INSERT INTO dikNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Go kɔc awën gäi ku thiëckë röt, “Ye raan la guɔ̈p ŋö kënë? Na cɔk a yom ku atiaktiak ë ke piŋ wɛ̈tde!” ");
INSERT INTO dikNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Wën cï Jethu ɣet pan Gadara tɔ̈ wär alɔŋtui, ke räm kek röör karou ke bɔ̈ bei rɛ̈ŋ nhïïm. Ku röörkä aake la gup jakrɛc ë ke riir nhïïm apɛi, abï kɔc aa riɔ̈ɔ̈c ke, abï ciɛ̈n raan tëëk ë dhël kënë. ");
INSERT INTO dikNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Gokë duɔɔt looi wën tïŋ kek Jethu, “Yeŋö wïc tënë ɣo Wën Nhialic? Ca bɛ̈n ba ɣo bɛ̈n tɛ̈m awuɔ̈c ke tën awuɔ̈c ŋoot?” ");
INSERT INTO dikNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ku duut dïr baai ë nyuäth tɛ̈thiɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Go jakrɛc Jethu lɔ̈ŋ, “Na wïc ba ɣo cuɔp wei ë röörkä gup, ke yï cop ɣo ë dïrkä gup.” ");
INSERT INTO dikNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Go lëk ke, “Lak,” Gokë bɛ̈n bei ku lek ë dïr gup, ku tɛ̈n awën, ke duut diëër riŋ agör yic ku thootkë wïïr ku moukë ëbën. ");
INSERT INTO dikNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Go röör ke biöök dïr kat ku riŋkë geeu, ku lek kë cï rot looi tënë dïr ku tënë röör awën karou la gup jakrɛc tɛ̈t kɔc. ");
INSERT INTO dikNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Go kɔc juëc apɛi geeu la bïk rɔ̈m kek Jethu. Nawën tïŋkë, ke läŋkë bï jäl panden. ");
INSERT INTO dikNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Go Jethu dhuk riäi yic, ku teem wär, ku ler gɛnden Kapernaum. ");
INSERT INTO dikNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Go kɔc kɔ̈k mony cï ruai bɛ̈ɛ̈i tënë ye ke ketkë, ke cï tɔ̈c biöök alom yic. Tɛ̈wën tïŋ Jethu gamdït tɔ̈ ke ke, ke lueel tënë mony aduany, “Dɛɛt yïpuɔ̈u manhdiɛ̈! Adumuɔ̈ɔ̈mku aacï päl piny.” ");
INSERT INTO dikNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tɛ̈wën piŋ kɔc piööc ë lööŋ ë wɛ̈t kënë, gokë jam kamken ëlä, “Mony kënë adhäl Nhialic!” ");
INSERT INTO dikNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Go Jethu lɛ̈k ke wën ŋic yen kë yekë tak, “Yeŋö ye wek tak kärac cït käkkä? ");
INSERT INTO dikNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ëmën ye kënɛn puɔl yic käkkä yiic, ba lueel, ‘Adumuɔ̈ɔ̈mku aacï päl piny,’ Tɛ̈dë ke luɛɛl, ‘Jɔt rot ku cathë’? ");
INSERT INTO dikNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ku aba nyuɔ̈th we lɔn le Manh Raan riɛl pinynhom ba adumuɔ̈ɔ̈m päl piny.” Ku lëk mony aduany, “Jɔt rot ku kuany biɔ̈ŋdu ku lɔɔr baai!” ");
INSERT INTO dikNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Go mony kënë rot jɔt ku dhuk baai. ");
INSERT INTO dikNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Go thän awën riɔ̈ɔ̈c wën tïŋ kek mony kënë, ku leckë Nhialic rin cï yen riɛldïït cït kënë gäm raan ë path. ");
INSERT INTO dikNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Tɛ̈wën jiël Jethu tɛ̈n awën, ke tïŋ mony ajuër kut cɔl Matheo ke rɛ̈ɛ̈r tɛ̈den luɔi, go lɛ̈k ye, “Buɔth ɣa.” Go Matheo rot jɔt ku buɔɔth. ");
INSERT INTO dikNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tɛ̈wën mïth Jethu pan Matheo kek kɔcken ye buɔɔth, ke kɔc ajuër kut, ku kɔc kɔ̈k la gup anyon, mɛ̈t röt ke bïk mïth ë tök. ");
INSERT INTO dikNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nawën tïŋ Parathï ë kënë, ke thiëc kɔcken ye buɔɔth, “Yeŋö ye raandun piööc mïth kek kɔc ajuër kut ku kɔc kɔ̈k la gup adumuɔ̈ɔ̈m?” ");
INSERT INTO dikNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Go Jethu wɛ̈lken piŋ ku bëër, “Aacie kɔc puɔl kek la tënë akïïm, aa kɔc tuany. ");
INSERT INTO dikNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Lak bäk wëlkä la deet yiic, kë wiëc ë ɣɛr puɔ̈u, acä wïc bï ɣa näk ɣɔ̈k. Ɣɛn akëc bɛ̈n ba kɔc path bɛ̈n cɔɔl, aa kɔc la gup adumuɔ̈ɔ̈m.” ");
INSERT INTO dikNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Go kɔc Joon raan kɔc muɔɔc nhïïm bɛ̈n tënë Jethu ku thiëckë, “Ɣook, ku kɔc Parathï ɣok aa thek buk cïï mïth, ku kɔckun yï buɔɔth aacie thek, yeŋö?” ");
INSERT INTO dikNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Go Jethu lɔ̈ŋden bɛ̈ɛ̈r ëlä, “Yakë tak lɔn bï kɔc cï bɛ̈n ruääi yic rëër ke cïï mïth, ku ɣɛn athiëëk nhom ɣa rɛ̈ɛ̈r ke ke? Acie tɛ̈de! Aköl bï athiëëk dɔm ku nyɛɛi keyiic, yen aköl bï kek thek. ");
INSERT INTO dikNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Ɣɛn acï bɛ̈n ba we bɛ̈n lɛ̈k, lɔn nadë acïn raan bï abaŋ alanh rɛt wei alanh yam kɔ̈u bï la buɔ̈ɔ̈p ë dhiäth alath kɔ̈u. ");
INSERT INTO dikNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ku acïn raan bï muɔ̈n abiëc ë yam puɔ̈k töny thɛɛr yic, na looi këya, ke töny abï yic pät ku puɔ̈k mɔ̈u wei, ku riëëkkë kedhie. Muɔ̈n yam adhil puɔ̈k töny ë yam yic. Ku na ye muɔ̈n abiëc ë yam, ka ye tääu töny ë yam yic, ku keek ëbën aacïï bï riääk.” ");
INSERT INTO dikNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Tɛ̈wën lëk Jethu ke ë wëlkä, ke bɛ̈ny tɛ̈n amat kɔc Itharel bɔ̈ tënë ye ku gut yenhiɔl piny yenhom ku lɛ̈ŋ, “Nyaandiɛ̈ apuɔc thou ëmën thiin, bäär ba yïcin la tääu yenhom bï bɛn pïr.” ");
INSERT INTO dikNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Go Jethu rot jɔt kek kɔcken ye buɔɔth ku buɔthkë. ");
INSERT INTO dikNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Nawën ke tiŋ tuany, cïï thɛ̈kde kɔ̈u ye tɛɛm ruɔ̈ɔ̈n thiäär ku rou, bɔ̈ Jethu kɔ̈u ciëën ku gɔɔt alanhde. ");
INSERT INTO dikNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Rin ëcï jam yepuɔ̈u ëlä, “Na gaat alanhde ke ɣɛn abï pial.” ");
INSERT INTO dikNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Go Jethu yenhom wel, ku tïŋ ku lueel tënë ye, “Dɛɛt yïpuɔ̈u nyaandiɛ̈, gamdu acï cɔl apuɔl.” Ku kaam awën ke riɛm kääc. ");
INSERT INTO dikNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Tɛ̈wën cï Jethu ɣet pan bɛ̈ny tɛ̈n amat kɔc Itharel, ke yök kɔc ke näk röt ke dhiau apɛi, go lɛ̈k ke, ");
INSERT INTO dikNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","“Jälkë tɛ̈n! Nyanthiin kënë akëc thou, anin!” Gokë dɔl guɔ̈p. ");
INSERT INTO dikNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Go la ɣöt wën cï kɔc la aɣeer ëbën, ku dɔm nyanthiin cin. Go rot jɔt. ");
INSERT INTO dikNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ku thiëi thoŋ kënë piny pan awën. ");
INSERT INTO dikNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Wën cï Jethu jäl pan mony awën ke bɛr tueŋ, go cöör karou buɔɔth cök ke dhiau. “Yïn aŋɔ̈thku, kony ɣo Wën Debit.” ");
INSERT INTO dikNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Nawën le ɣet ɣöt, ke buɔɔthkë thïn, goke thiëëc, “Yakë gam wepuɔ̈th lɔn bï ɣɛn kënë looi?” Gokë rek yic, “Bɛ̈ny, ayeku gam!” ");
INSERT INTO dikNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Goke gɔɔt nyïn ku lueel, “Abï rot looi këya, cïmën cï wek ye gam!” ");
INSERT INTO dikNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Gokë guɔ daai nyin yic, ku thɔn ke ëlä, “Duɔ̈kkë ë kënë lëk raan dɛ̈t!” ");
INSERT INTO dikNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Nawën lek jäl tënë Jethu, ke la jam riɛnke baai yic ëbën. ");
INSERT INTO dikNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Kaam wën puɔc kɔc awën karou jäl, ke mony la guɔ̈p jɔŋrac cie jam bïï tënë ye. ");
INSERT INTO dikNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ku kam thin cï Jethu jɔŋrac cuɔp wei yeguɔ̈p, go guɔ jam, go kɔc gäi ëbën ku luelkë, “Ɣok aa këc këcït kënë kaŋ tïŋ Itharel ë tɛ̈n!” ");
INSERT INTO dikNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Go Parathï yɔ̈ɔ̈ŋ yic ku luelkë, “Ee bɛ̈ny jakrɛc yen ë ye yiëk riɛl bï ke aa cuɔp wei kɔc gup.” ");
INSERT INTO dikNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ku jɔl Jethu gɛɛth ku baai kuany yiic ke ye piööc tɛ̈n amat kɔc Itharel. Ku lëk kɔc Wɛ̈t Puɔth Yam rin bääny Nhialic, ku kony kɔc ë tuɛny yiic ëbën. ");
INSERT INTO dikNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nawën tïŋ thändïït guëër tënë ye, ke ŋɛɛr yic tënë ke, rin aacï tïŋ ke cïn raan piööc ke, kecït amɛ̈l pap cïn nhïïm abiöök. ");
INSERT INTO dikNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ku lueel tënë kɔcken ye buɔɔth, “Käk tem ajuëc ku kɔc luɔi aa lik. ");
INSERT INTO dikNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Këya, rɔ̈ɔ̈kkë Bɛ̈ny la nhom käk tem, bï kɔc luɔi cɔl ajuak röt.” ");
INSERT INTO dikNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Go Jethu kɔcken ye buɔɔth kathiäär ku rou cɔɔl, ku yïk ke riɛl bï kek jakrɛc aa cuɔp wei, ku konykë kɔc tuany bïk pial. ");
INSERT INTO dikNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Rin kɔc ke cï kuany aa kïk. Thaimon, cï Jethu bɛ̈n cäk ke cɔl Pïtɛr. Ku wämënh Andria ku wɛ̈ɛ̈t Dhubedï, Jemith ku Joon. ");
INSERT INTO dikNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilipo ku Bartholomeo. Thomath ku Matheo raan ajuër kut. Jemith Alpawuth, Thadawuth, ");
INSERT INTO dikNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Thaimon (raan la puɔ̈u ater) ku jɔl a Judath Ithkariöt raan wäär cï Jethu bɛ̈n luɔm bï dɔm. ");
INSERT INTO dikNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Keek kathiäär ku rou aake cï Jethu tooc ku yöök ke ëlä, “Duɔ̈kkë bɛ̈ɛ̈i kɔc cie kɔc Itharel kɛ̈c yiic, ku duɔ̈kkë la gɛɛth Thamaria yiic. ");
INSERT INTO dikNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Lakkë tënë kɔc Itharel kuc Wɛ̈t Puɔth Yam Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Tɛ̈ le wek ke lɛ̈kkë ke, ‘Lɔn cï bääny Nhialic thiɔ̈k!’ ");
INSERT INTO dikNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Kuɔnykë kɔc tuany bïk pial, ku calkë kɔc cï thou aa ben pïr, ku calkë kɔc la gup tuet aa dem, ku cuɔpkë jakrɛc wei kɔc gup. Duɔ̈kkë röt cɔl aye riɔp tɛ̈ looi wek käkkä, rin riɛl ye wek ke looi ë cäk ɣɔc. ");
INSERT INTO dikNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Duɔ̈kkë muk wëëu ku duɔ̈kkë muk jɔkgɔɔ ye wek lim mïïth dhël yic. ");
INSERT INTO dikNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Muɔ̈kkë alɛ̈th ku war cɛŋkë kepɛ̈c, ku wai tök ë path. Rin raan ë luɔi aye gäm këden cï yen luui. ");
INSERT INTO dikNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Kuat gɛu, ayï pan ye wek la thïn, yakë thiëc raan puɔth bï we lor, ku rɛ̈ɛ̈rkë kek ye ɣet aköl bï wek jäl. ");
INSERT INTO dikNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Tɛ̈ ye wek la bɛ̈ɛ̈i yiic, yakë kɔc kaŋ tïŋ lɔn bï kek we lor ku nyuuckë we. ");
INSERT INTO dikNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ku na lor kɔc baai we, ke we rɛ̈ɛ̈r ku nyuɔ̈thkë ke Wɛ̈t Puɔth Yam, ku na cïk nyïn la we, ka cïn wɛ̈t lɛ̈kkë ke. ");
INSERT INTO dikNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ku na cïï kɔc baai, ayï kɔc gɛu we lor ku piŋkë wɛ̈t ciɛth wek, ke we jiël ku tɛŋkë wecök. ");
INSERT INTO dikNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ku wek aa lɛ̈k kënë! Aköl luŋdït, Nhialic abï kɔc rɛc pan Thodom ku Gomora ŋuään tënë ë kɔckä! ");
INSERT INTO dikNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Piɛŋkë kënë! Wek aa tuɔɔc bɛ̈ɛ̈i yiic cïmën amɛ̈l la gal yiic. Këya, cɔ̈kkë wepuɔ̈th ku luɔikë röt bäk aa kɔc path ŋic käŋ, ŋic luui. ");
INSERT INTO dikNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ku alɛ̈k we aya bäk ŋic lɔn bï we aa dɔm ku ɣɛ̈th we luk yic, ku thatkë we tɛ̈den amat. ");
INSERT INTO dikNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ku wek aabï kɔ̈ɔ̈c bäny nhïïm ë riɛnkiɛ̈, bäk Wɛ̈t Puɔth Yam lɛ̈k ke ku kɔc cie kɔc Itharel. ");
INSERT INTO dikNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ku tɛ̈ ɣɛ̈th kek we luk yic, duɔ̈kkë diɛɛr tɛ̈ bï wek la jiɛɛm thïn, rin wɛ̈t bäk lueel abï guɔ bɛ̈n wenhïïm tɛ̈ jiɛɛm wek. ");
INSERT INTO dikNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Rin wël bäk lueel aacie wɛ̈lkun, aabï bɛ̈n tënë Wëi Nhialic yen bï jam wegup. ");
INSERT INTO dikNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Raan kek wämënh aabï röt gaany bïk röt cɔl aa näk, ku wärken mïth aabï miɛ̈thken luɔm, ku mïth aabï kɔc ke dhiëth ke luɔm bïk ke cɔl aa näk. ");
INSERT INTO dikNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kɔc ëbën aabï we maan riɛnkiɛ̈. Ku raan bï yepuɔ̈u dɛɛt ɣet tɛ̈ bï yen thou, abï pïr akölriëëc ëbën. ");
INSERT INTO dikNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Na wïckë bïk we nɔ̈k gen cï wek la thïn, ke we riŋ gen dɛ̈t. Ku na näkkë we ë gen kënë aya, ke we riŋ gen dɛ̈ɛ̈të. Alɛ̈k we ayic, wek acï luɔidun bï thöl pan Itharel, ke Manh Raan këc bɛ̈n. ");
INSERT INTO dikNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Acïn manh piööc wär raan piööc ye, ku acïn alony dït tënë bänyde. ");
INSERT INTO dikNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Këya, apath bï raan biöth ciɛ̈t raanden ë piööc, ku alony kecït bänyde. Na ye wun baai cɔɔl ke Beldhebul bɛ̈ny jakrɛc, ke kacke bï cɔɔl rin yïndë! ");
INSERT INTO dikNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Këya, duɔ̈kkë riɔ̈c ke. Rin käk ye moony ëmën aa ŋot ke bï ŋic aköldä, rin acïn kë ye thiaan bï cïï ŋic. ");
INSERT INTO dikNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Yakë käk ya lɛ̈k we ë röt lueel kɔc nhïïm ëbën ke cïn riɔ̈ɔ̈c, ku luɛlkë käk ye ŋääi weyïth, bï kɔc kɔ̈k ke piŋ aya. ");
INSERT INTO dikNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Duɔ̈kkë riɔ̈c kɔc we nɔ̈k, wɛ̈ikun aa liu kecin. Aŋuɛ̈ɛ̈n bäk riɔ̈ɔ̈c ë Nhialic, yen la riɛl we cɔl apïr pinynhom ku kony wɛ̈iku ë pan mac aköldä. ");
INSERT INTO dikNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Acïn këthiin koor lëu bï määr ke kuc Wuur tɔ̈ nhial. Na cɔk ajïnh thin koor tɔ̈ baai ka ŋic. ");
INSERT INTO dikNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ku week aya, na cɔk a këthiin tɔ̈ wegup cïmën nhïm tɔ̈ wenhïïm, ka ŋic Wuur tɔ̈ nhial. ");
INSERT INTO dikNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Këya, duɔ̈kkë riɔ̈c, wek aa wär käkkä ëbën! ");
INSERT INTO dikNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Na ye raan wɛ̈tdiɛ̈ piɔ̈ɔ̈c ku cïï guɔ̈p riɔ̈c, ke ɣɛn acïï guɔ̈p riɔ̈c ye ë Wä nhom nhial. ");
INSERT INTO dikNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ku na ye raan jɛi ɣa kɔc nhïïm lɔn cïï yen ye raandiɛ̈, ka ba jai aya ë Wä nhom nhial. ");
INSERT INTO dikNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Duɔ̈kkë ye tak lɔn cï ɣɛn bɛ̈n ba dɔ̈ɔ̈r bɛ̈n looi pinynhom. Ɣɛn akëc bɛ̈n ba käŋ bɛ̈n cɔl aa puɔl yiic, ee gum bï raan ëbën gum. ");
INSERT INTO dikNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Rin ɣɛn acï bɛ̈n ba meth kek wun, ku nya kek man cɔl aman röt, ku man athiëëk kek tiŋ wënde aabï röt maan aya, ");
INSERT INTO dikNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","kɔc bï raan aa maan aa kɔcken rɛ̈ɛ̈r kek ye baai. ");
INSERT INTO dikNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Raan ye nhiaar bï aa kɔc ke dhiëth ye kek nhiɛɛr apɛi tënë ɣa, ka cie raandiɛ̈, ku na ye raan miɛ̈thke nhiaar apɛi tënë ɣa, ka cie raandiɛ̈ aya. ");
INSERT INTO dikNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Raan cie kärac ye guum wɛ̈tdiɛ̈ ku looi wɛ̈tdiɛ̈ acie raandiɛ̈. ");
INSERT INTO dikNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Raan ye wïc bï wɛ̈ike ŋiɛc muk pinynhom ë tɛ̈n, acïï pïr aköldä bï yök, ku raan bï gum ë wɛ̈tdiɛ̈, abï pïr akölriëëc ëbën yök. ");
INSERT INTO dikNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Raan we lor ë ɣɛn aye lor, ku kɔc ɣa lor, ee Wä raan toc ɣa yen ayekë lor. ");
INSERT INTO dikNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Raan atuɔ̈nydiɛ̈ lor rin ŋic yen ye lɔn ë yen atuɔ̈nydiɛ̈, abï la abak ariöp bï yiëk atuuc yiic. ");
INSERT INTO dikNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Muɔ̈kkë kënë na gɛm raan pïu col nyïn ë path tënë raan thiin koor kam kɔc ɣa buɔɔth, rin ye yen raan ɣa buɔɔth, ka bä ariɔ̈pde dhiɛl yök.” ");
INSERT INTO dikNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Wën cï Jethu wëlkä jal lɛ̈k kɔcken ye buɔɔth kathiäär ku rou, ke jiël ë tɛ̈n bï la piööc ku le kɔc lɛ̈k gɛɛth Galilia yiic. ");
INSERT INTO dikNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ee nïnkä, tɛ̈wën tɔ̈ Joon raan kɔc muɔɔc nhïïm ɣööt ke mac, ke piŋ käk looi Jethu. Go kɔc abɛ̈k, kɔcken ye buɔɔth tuɔɔc tënë ye bïk la thiëëc wɛ̈t kënë. ");
INSERT INTO dikNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Ye yïn raan yï bï bɛ̈n, aye raan dɛ̈t yen buk tiit?” ");
INSERT INTO dikNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Go Jethu bɛ̈ɛ̈r, “Dhuɔ̈kkë ku lɛ̈kkë Joon, käk cäk piŋ ku käk cäk tïŋ. ");
INSERT INTO dikNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Cɔr acï bɛn daai ku aduany acï ya cath. Ku kɔc cï tuet aacï tuet jäl kegup. Ku miŋ acï ya piŋ ku kɔc cï thou aacï röt jɔt. Ku Wɛ̈t Puɔth Yam Nhialic alëk kɔc ŋɔ̈ŋ nyïn. ");
INSERT INTO dikNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Raan mit guɔ̈p ë raan cie puɔ̈u ë rou wɛ̈tdiɛ̈ yic!” ");
INSERT INTO dikNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Kaam wën jiël atuuc Joon, ke Jethu jam ku tët kɔc Joon, “Ye raan yïndë yen cï wek la ror cïï ceŋ bäk la tïŋ? Ye raan puɔl yic ye wel nhom ë path cïmën ye yom aruɔ̈ɔ̈r wel nhom? Acie tɛ̈de, acie yen kënë ler wek. ");
INSERT INTO dikNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ye raan yïndë yen lak tïŋ? Ye mony ceŋ alɛ̈th path? Aŋot cie tɛ̈de, kɔc ceŋ alɛ̈th dhëŋ aa kɔc tɔ̈ bɛ̈ɛ̈i bäny yiic! ");
INSERT INTO dikNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Na cie këya, ke yeŋö yen ler wek? Ye raan käk Nhialic tïŋ? Ee yic, ku alɛ̈k we, yeen adït tënë raan käk Nhialic tïŋ. ");
INSERT INTO dikNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yen Joon, yen ë raan cï wël gɔ̈t ë riɛnke thɛɛr ëlä, ‘Ɣɛn abä atuɔ̈nydiɛ̈ tuɔɔc yïnhom tueŋ, ku yeen abï dhël la guiir tënë yï.’ ");
INSERT INTO dikNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Ku wek aba lɛ̈k yiny kënë, Joon raan kɔc muɔɔc nhïïm aril, acïn raan kuat kɔc cï dhiëëth pinynhom dït tënë Joon. Ku raan koor bääny Nhialic yic adït tënë ye. ");
INSERT INTO dikNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tɛ̈wäär piööc Joon raan kɔc muɔɔc nhïïm agut cït akölë, bääny Nhialic ala tueŋ, ku aye kɔc rɛc kɔ̈k la riɛl them bïk dhuɔ̈k ciëën. ");
INSERT INTO dikNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Rin löŋ Mothith, ku kɔc ke käk Nhialic tïŋ ëbën agut tɛ̈ ɣëët yen Joon, aake ye jam rin bääny Nhialic, ");
INSERT INTO dikNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ku na tɔ̈u wepuɔ̈th bäk wɛ̈tdiɛ̈ gam, ke yen Joon yen ë Elija wäär cï bɛ̈nde lɛ̈k thäi. ");
INSERT INTO dikNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Piɛŋkë tɛ̈ le wek yïth! ");
INSERT INTO dikNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Yeŋö ba thɔ̈ŋ kek riëëc akölë? Aa cït mïth cï kenhïïm mat laar yic leŋ kegup, ye lueel ëlä, ");
INSERT INTO dikNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Ɣok aacï waak pɛth ye keek ket tɛ̈ looi ruääi ket, ku wek aa këc dier! Ku ɣok aacï käk ye keek looi thuɔɔu yic thɔ̈ɔ̈ŋ, ku wek aa këc dhiau!’ ");
INSERT INTO dikNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“Rin Joon acï tuɔ̈l ku ëcie bɛ̈ɛ̈i kuany yiic ke mïth ku dëk, go raan ëbën lueel, ‘Joon ala guɔ̈p jɔŋrac!’ ");
INSERT INTO dikNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nawën bɔ̈ Manh Raan ku ye mïth ke kɔc ku dëk ke ke, gokë lueel, ‘Tiɛ̈ŋkë mony kënë! Yeen akok ku a dɛk määu, ku amääth kek kɔc ajuër kut ku kɔc la gup adumuɔ̈ɔ̈m!’ Ku luɔi puɔth Nhialic ë rot nyuɔɔth käk ya looi yiic.” ");
INSERT INTO dikNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tɛ̈wën, go Jethu puɔ̈u dak ku nyieeny kɔc gɛɛth cï yen käjuëc jäŋ gɔ̈i looi thïn, rin këc kek luɔi kärɛc puɔ̈l. ");
INSERT INTO dikNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Wek kɔc gen Koradhin! Ku Bethaida! Wek aa tiit kärac apɛi, rin käjuëc jäŋ gɔ̈i cäk tïŋ cï looi gɛɛthkun yiic, ku ke cï looi Tire ku Thidon gɛɛth wäär ceŋ kɔc rɛc, ŋuɔ̈t kɔc ë gɛɛthkä aacï kepuɔ̈th dhuɔ̈k ciëën thɛɛr ku pälkë luɔi kärac! ");
INSERT INTO dikNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ku wek aa lɛ̈k kënë, aköl luŋdït, Nhialic abï kɔc Tire ku Thidon ŋuään! ");
INSERT INTO dikNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ku wek kɔc gen Kapernaum! Yakë tak lɔn bï we jat nhial? Wek abï cuat pan mac. Rin käk jäŋ gɔ̈i cï looi wenyïn cäk ke tïŋ, ku ke cï looi Thodom, ŋuɔ̈t acïn kë cie rac agut ëmën! ");
INSERT INTO dikNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ku abɛn lɛ̈k we, käŋ aacïï yiic bï riɛl apɛi tënë ke aköl luŋdït, cïmën tɛ̈ bï kek yiic ril thïn tënë we!” ");
INSERT INTO dikNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ku ë tɛ̈n awën ke lueel Jethu, “Wä, Bɛ̈ny nhial ku piny! Yïn alɛɛc rin cï yïn käk ca thiaan tënë kɔc ŋic käŋ cï piöc, nyuɔ̈th kɔc kor këc piöc. ");
INSERT INTO dikNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ee yic Wä, yen ë kën yï yuum puɔ̈u. ");
INSERT INTO dikNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Këriëëc ëbën acï Wä gäm ɣa. Ku acïn raan ŋic Wënde, ee Wun ë rot, cïmën cïn yen raan ŋic Wun, ee Wënde ku kɔc cï Wënde lɔc bïk ŋic. ");
INSERT INTO dikNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Bäk tënë ɣa ëbën, wek kɔc cï jɔ̈t yiëth käthiek bäk ke ɣääc, wek aba cɔl alɔ̈ŋ. ");
INSERT INTO dikNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Gamkë piɔ̈ɔ̈cdiɛ̈ bäk yith ŋic, rin ɣɛn acïï la ruathruath, ɣɛn alir puɔ̈u, ku wek aabï wɛ̈ikun pïr. ");
INSERT INTO dikNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Rin piɔ̈ɔ̈cdiɛ̈ acïï ril, apuɔl yic.” ");
INSERT INTO dikNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Naɣɔn akäl tök ë nïnkä, Jethu ë cath kek kɔcken ye buɔɔth, ke kuany dhël yic kam dum aköl lɔ̈ŋ. Ku kɔcken ye buɔɔth aake nɛ̈k cɔk, gokë rap lek cam dhoŋ. ");
INSERT INTO dikNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nawën tïŋ kɔc akut Parathï, gokë Jethu thiëëc, “Tïŋ, kɔckun yï buɔɔth aa loi kë cie looi aköl lɔ̈ŋ!” ");
INSERT INTO dikNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Go bɛ̈ɛ̈r ku lueel, “Kɛ̈ckë kë cï Debit looi thɛɛr kaŋ kueen, wäär nɛ̈k cɔk ye ke kɔcken cath kek ye? ");
INSERT INTO dikNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Acï bɛ̈n la luaŋ Nhialic, ku ciɛm ayum yath cï tɔ̈ɔ̈u tënë Nhialic, kek kacke. Ayum kënë ëcïï Debit lëu bï cam kek kacke, aa kɔc käk Nhialic looi kek aake ye cam ë röt. ");
INSERT INTO dikNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Dɛ̈t aya, kɛ̈ckë kueen löŋ Mothith yic lɔn aköl lɔ̈ŋ thok ëbën, kɔc käk Nhialic looi luaŋ Nhialic aa löŋ aköl lɔ̈ŋ dhoŋ kɔ̈u, ku aacïï ke ye nyieeny? ");
INSERT INTO dikNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ku Manh Raan jam kek we, adït tënë luaŋ Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Na we cï wël cï gɔ̈t thɛɛr deet yiic, lɔn kë wïc Nhialic ë nhiɛ̈r ye kɔc röt nhiaar, aacie ɣɔ̈k ye näk ye, ŋuɔ̈t wek aa këc kɔc cïn awuɔ̈c cïk looi nyieeny, ");
INSERT INTO dikNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","rin Manh Raan adït tënë aköl lɔ̈ŋ.” ");
INSERT INTO dikNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Naɣɔn aköl dɛ̈t ke Jethu jiël tënë awën ku ler tɛ̈n amat kɔc Itharel, ");
INSERT INTO dikNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ku mony cï cin ruai ë tɔ̈ thïn. Ku kɔc kɔ̈k ke wïc Jethu bïk gaany kë cï wuɔ̈ɔ̈c, aake tɔ̈ tɛ̈n amat aya, gokë Jethu thiëëc. “Ye lɔ̈ŋda pëën bï raan kony aköl lɔ̈ŋ?” ");
INSERT INTO dikNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Go Jethu bɛ̈ɛ̈r, “Na la raan tök kamkun ë tɛ̈n amäl tök, ku lööny yiith aköl lɔ̈ŋ, ke cïï bïï bei yiith? ");
INSERT INTO dikNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Raan adït apɛi tënë lɛ̈i! Këya, lɔ̈ŋda acie ɣo ye pëën buk raan cïï kony aköl lɔ̈ŋ.” ");
INSERT INTO dikNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ku lëk mony wën cï cin ruai, “Nyoth yïcin.” Go yecin nyooth, go cin piath abï ciɛ̈t ciin këc ruai. ");
INSERT INTO dikNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Go Parathï jäl tɛ̈n amat, ku lek mat tɛ̈ bï kek Jethu näk thïn. ");
INSERT INTO dikNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Go Jethu kë loikë ŋic, ku jiël tɛ̈n awën, go kɔc juëc buɔɔth. Ku kony kɔc tuany bïk pial, ");
INSERT INTO dikNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ku thɔn ke apɛi bïk cïï la lɛ̈k kɔc kɔ̈k, bï cïï ŋic. ");
INSERT INTO dikNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Rin bï kë cï Ithaya lueel wäthɛɛr ëlä ë riɛnke yenhom tiɛɛŋ, ");
INSERT INTO dikNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Yen akïn yen alonydiɛ̈n ca lɔc, raan töŋ yen nhiaar, mit ɣɛn puɔ̈u tënë yeen. Ɣɛn abï Wɛ̈ikiɛ̈ cɔl alööny yeguɔ̈p, ku abï gam ë yic lɛ̈k thäi ëbën. ");
INSERT INTO dikNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Acïï bï ya gɔ̈th ku rɛ̈ɛ̈m kɔc nhïïm wël cie yith, acïï bï ya piŋ röl ë dhɔ̈l yiic. ");
INSERT INTO dikNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Acïn këthiin bï kaŋ tuɔ̈ɔ̈r nyin, cɔk ayiny kɔc kor ka cïï dhäl. Acïï bï kaŋ dhɔ̈r ɣet tɛ̈ bï yiɛnyde ŋic, ");
INSERT INTO dikNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ku abï wuɔ̈ɔ̈t ëbën ŋɔ̈ɔ̈th.” ");
INSERT INTO dikNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nawën ke kɔc kɔ̈k bïï mony cï cɔr tënë Jethu, ku ëcie jam aya rin tɔ̈ jɔŋrac yeguɔ̈p. Go Jethu kony, ɣet bï jam ku dɛɛi. ");
INSERT INTO dikNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Go kɔc awën tɔ̈ thïn gäi ëbën ku thiëckë röt. “Nadë ke bï ya Manh Debit?” ");
INSERT INTO dikNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nawën piŋ Parathï ë wɛ̈t kënë, ke luelkë, “Yeen ë jakrɛc cuɔp wei kɔc gup, rin ye bɛ̈ny jakrɛc, cɔl Beldhebul ye yiëk riɛl.” ");
INSERT INTO dikNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Go Jethu kë takkë ŋic ku lueel, “Pan yeyic tek ku thär kɔc ë kamken, ë lac riääk. Ku na tek gɛn tök yeyic, ayï dhiënh tök ku tuumkë kenhïïm ku thɛ̈rkë, ka puɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Na ye jɔŋrac jɔŋrɛɛc dɛ̈t cuɔp wei, ka cï keyiic tek. Këya, lëu panden bï kɔ̈ɔ̈c këdë! ");
INSERT INTO dikNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ku na ye riɛl Beldhebul yen ye ɣɛn jakrɛc cuɔp wei, ke ye riɛl ŋa yen ye kɔckun yakë buɔɔth ke cuɔp wei? Calkë ke aa lëk we yic. ");
INSERT INTO dikNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ku na ye riɛl Wëi Nhialic yen ye ɣɛn jakrɛc cuɔp wei, ke ŋiɛckë lɔn cï bääny Nhialic bɛ̈n tënë we. ");
INSERT INTO dikNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Acïn raan lëu ye bï ɣön raan ril dhoŋ ku nyɛɛi käkke, akɔŋ raan ril kënë dɔm ku der, ku jɔl käk tɔ̈ baai nyaai. ");
INSERT INTO dikNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Raan këc rot mät ɣa acie raandiɛ̈, ku raan cïï ɣa kony bï kɔc lɛ̈k wɛ̈t Nhialic, ee kɔc thiɔ̈i. ");
INSERT INTO dikNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Këya, wek aa lɛ̈k yic lɔn nadë adumuɔ̈ɔ̈m ë kɔc, ku kärac yekë ke lueel, aa lëu bï ke päl piny. Ku kuat raan kärɛc luɛɛl Wëi Nhialic guɔ̈p, acïï bï päl piny tënë ye. ");
INSERT INTO dikNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ku na ye raan lueel wɛ̈t rac Manh Raan guɔ̈p, ka pɛ̈l piny. Ku raan ye lueel lɔn ye Wëi Nhialic jɔŋrac, ka cïï kɔŋ päl piny acïn ëmën agut akölriëëc ëbën. ");
INSERT INTO dikNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Com tim tɛ̈path bï miɛ̈thke piath. Tɛ̈dë ke com tɛ̈rac bï miɛ̈thke rɛ̈ɛ̈c. Këya, tim aye ŋic miɛ̈thke. ");
INSERT INTO dikNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Wek mïth käpiɛny, mïth kɔc cie yith ye gam, lɛ̈ukë bäk këpath lueel, ke we ye jakrɛc ëmëndun? Rin kë ye thok lueel ë bɛ̈n bei raan puɔ̈u. ");
INSERT INTO dikNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Raan path ë luui käpath, rin käpuɔth tɛ̈ yepuɔ̈u. Ku raan rac ë luui kärac rin kärɛc tɔ̈ yepuɔ̈u. ");
INSERT INTO dikNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Alɛ̈k we, raan ëbën abï thiëëc aköl luŋdït ë wël rɛc cï lueel. ");
INSERT INTO dikNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Rin wɛ̈lku kek aabï ɣäth tɛ̈path, ku aa kek aabï cɔl atëm awuɔ̈c aköl luŋdït.” ");
INSERT INTO dikNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Go kɔc kɔ̈k piööc lööŋ ku Parathï lueel tënë ye, “Raan piööc awïcku ba kënë jäŋ gɔ̈i looi buk tïŋ.” ");
INSERT INTO dikNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Go Jethu bɛ̈ɛ̈r, “Aa kɔc la gup anyon ku gam koor kek aa thiëc käk tïŋkë! Acïn kën jäŋ gɔ̈i bï nyuɔ̈th we, ee këwäär cï rot looi tënë Jona, raan käk Nhialic tïŋ yen abï rot looi. ");
INSERT INTO dikNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Cïmën wäär cï Jona rëër akööl kadiäk ku wër kadiäk rɛ̈cdït apɛi yic, ke Manh Raan aya abï rëër nïn kadiäk ë raŋ yic. ");
INSERT INTO dikNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Aköl luŋdït kɔc gen Ninibe, aabï we gɔ̈k rin cï kek kepuɔ̈th waar ku pälkë luɔi kärac wäär cï Jona ke lɛ̈k. Ku alɛ̈k we, ɣɛn jam kënë, ɣɛn adït tënë Jona! ");
INSERT INTO dikNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Tiŋdït ë bɛ̈ny wäär jiël pan Athia bï la Jeruthalem, abï we gɔ̈k aköl luŋdït rin cï yen jäl tɛ̈mec apɛi bï wël puɔth bɛ̈nyŋaknhom Tholomon la piŋ, ku ɣɛn jam, ɣɛn adït tënë Tholomon! ");
INSERT INTO dikNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Tɛ̈ cï jɔŋrac jäl raan guɔ̈p, ee piny yɔ̈ɔ̈p tɛ̈dɛ̈t bï yen lɔ̈ŋ thïn. Na cïï yök, ");
INSERT INTO dikNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ke lueel, ‘Ɣɛn abï dhuk tɛ̈wäär jiël ɣɛn thïn.’ Këya, ke dhuk ku yök tɛ̈n bï yen rëër thïn ke cïn raan tɔ̈ thïn, ku acï guiir. ");
INSERT INTO dikNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ku dhuk, ku le bɛ̈n kek jakrɛc apɛi kɔ̈k kadhorou wär ye, bïk bɛ̈n ceŋ baai. Ku pïr ë raan kënë ë jäl rɛ̈ɛ̈c apɛi tënë pïrden tueŋ. Yen ë tɛ̈n ben rot luɔɔi thïn aya tënë kuat akölë.” ");
INSERT INTO dikNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jethu ee ŋot jam kek kɔc tɛ̈wën ɣëët man kek wämäthakën. Ku kɛ̈ɛ̈ckë aɣeer, ku thiëckë bïk jam kek ye. ");
INSERT INTO dikNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Go raan tök kam kɔc awën lëk ye, “Moor ku wämäthakui aa kääc aɣeer, ku awïckë bïk jam kek yï.” ");
INSERT INTO dikNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Go Jethu bɛ̈ɛ̈r, “Yeŋa ë ma? Ku ye yïŋa paan ë ma?” ");
INSERT INTO dikNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ku nyooth kɔcken ye buɔɔth ku lueel, “Kɔckä! Kek aa ma ku wämäthakäi! ");
INSERT INTO dikNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kuat raan ë wɛ̈t Wä tɔ̈ nhial looi yen ë wämääth, ku nyankäi, ku ma.” ");
INSERT INTO dikNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ku aköl töŋ awën, ke Jethu jiël baai ku ler wär Galilia yɔu ku nyuuc, ku piööc. ");
INSERT INTO dikNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ku gööm kɔc juëc apɛi, go la riäi yic ku nyuuc thïn, ku kääc thän awën ë pïu thook aɣeer. ");
INSERT INTO dikNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ku jɔl Jethu kɛ̈ŋ aa lueel bï yen kɔc piɔ̈ɔ̈c käjuëc. Ku lëk ke, “Raan puɔ̈r ëcï la dom bï la pur. ");
INSERT INTO dikNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tɛ̈wën yen rap wɛɛr dom, ke kɔ̈th abɛ̈k lööny dhël yic. Go diɛt bɛ̈n ku tetkë ke. ");
INSERT INTO dikNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ku lööny kɔ̈th kɔ̈k alɛl nhom, tɛ̈ koor tiɔp thïn. Gokë guɔ cil rin tiɔp ëcïï dït thïn. ");
INSERT INTO dikNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Nawën la akɔ̈l ruɛl apɛi ke rap awën yuɔm, ku riɛɛukë rin këc mɛiken ɣet piny. ");
INSERT INTO dikNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ku lööny kɔ̈th abɛ̈k tɛ̈ ye yuɔ̈ɔ̈t lac dït thïn, nawën la yuɔ̈ɔ̈t dït ke näk rap. ");
INSERT INTO dikNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ku lööny kɔ̈th kɔ̈k ë tiɔm path yic, ku lokkë apath, kɔ̈k ke dït nhïïm ku kɔ̈k ke thööŋ röt ku kɔ̈k ke thoi nhïïm!” ");
INSERT INTO dikNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ku wit Jethu wɛ̈tde ëlä, “Piɛŋkë tɛ̈ le wek yïth!” ");
INSERT INTO dikNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nawën ke kɔcken ye buɔɔth bɔ̈ tënë ye ku thiëckë, “Yeŋö ye yïn jam ë waal tënë ke?” ");
INSERT INTO dikNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Go dhuk nhom ku lueel, “Ŋiɛ̈ɛ̈c käk bääny Nhialic acï gäm we ku akëc gäm ke. ");
INSERT INTO dikNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Rin raan la këdäŋ abï bɛn muɔɔc bï käkke juëc apɛi, ku raan cïn këdäŋ, ke këthiin ye tak lɔn tɔ̈ yen tënë ye, abï nyaai aya. ");
INSERT INTO dikNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kënë ye ɣɛn jam waal tënë ke, rin keek aa daai ku acïn kë yekë tïŋ, aa piŋ ku aa cïn kë yekë piŋ, tɛ̈dë ke detkë yic. ");
INSERT INTO dikNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Këya, wɛ̈t cï Ithaya raan käk Nhialic tïŋ lueel wäthɛɛr ë riɛnken ëlä atiiŋ yenhom, ‘Na cɔk alɔn ye kɔckä wɛ̈t piŋ ku benkë piŋ, ka cïk bï deet yic, na cɔk alɔn ye kɔckä daai, ku cockë keek ka cïï käŋ bï tïŋ, ");
INSERT INTO dikNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","rin cï kek kepuɔ̈th wɛl wei, ku aacï keyïth cuɔ̈k bïk cïï ye piŋ ku niinkë kenyïn. Na këckë looi këya, ŋuɔ̈t aa daai ku pïŋkë, ku detkë käŋ yiic, ku ŋuɔ̈t aacï röt thɔ̈n Nhialic, ku kony keek.’ ");
INSERT INTO dikNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Ku wekkä, wek aa mit gup, rin wek aa daai ku piɛ̈ŋkë. ");
INSERT INTO dikNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ku alɛ̈k we, acï kɔc juëc käk Nhialic tïŋ, ku kɔc path ŋic Nhialic wïc bïk tïŋ käk yakë tïŋ, ku aa këckë tïŋ, acïk wïc bïk piŋ käk yakë piŋ, ku aa këckë piŋ.” ");
INSERT INTO dikNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Go Jethu lueel, “Ëmën piɛŋkë tɛ̈ teet ɣɛn kääŋ kënë yic thïn. ");
INSERT INTO dikNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Kɔc ë wɛ̈t bääny Nhialic piŋ ku cïk det yic, aa cït kɔ̈th cï lööny dhël yic. Jɔŋrac ë bɛ̈n ku nyɛɛi wɛ̈t awën kepuɔ̈th. ");
INSERT INTO dikNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kɔ̈th cï lööny alɛl nhom aa cït kɔc wɛ̈t Nhialic gam nyin yic ku mitkë puɔ̈th. ");
INSERT INTO dikNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ku aacie kepuɔ̈th ye dɛɛt, aa löŋ Nhialic guɔ wai wei tɛ̈ looi aliääp rot, ku tɛ̈ nɛ̈k ke rin wɛ̈t Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kɔ̈th cï lööny tɛ̈ ye yuɔ̈ɔ̈t lac dït thïn, aa cït kɔc ë wɛ̈t Nhialic piŋ, ku käjuëc ke diir rin pïr pinynhom, ku nhiɛ̈r jiɛɛk aa bɛ̈n thïn, ku rɛckë löŋ Nhialic kepuɔ̈th. ");
INSERT INTO dikNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ku kɔ̈th cï puur tiɔm path yic, aa cït kɔc ë wɛ̈t Nhialic piŋ ku detkë yic apath, ku käjuëc aye yök tënë ke, cïmën rap cï ŋiɛc luɔk ke dït nhïïm, ku rap kɔ̈k thööŋ kenhïïm ku kɔ̈k ke thoi nhïïm.” ");
INSERT INTO dikNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ku ben Jethu ke lɛ̈k kääŋ dɛ̈t, “Bääny Nhialic acït raan cï kɔ̈th path com duɔmde. ");
INSERT INTO dikNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Naɣɔn akɔ̈u ke raan ëbën nin, ke raan atɛrde bɔ̈ ku weer abaar rap cök ku jiël. ");
INSERT INTO dikNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nawën la rap cil ke abaar cil aya. ");
INSERT INTO dikNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Go raan lui dom yic bɛ̈n tënë wun dom ku lueel, ‘Bɛ̈ny, wäär pur yïn, cie rap path kek ca wɛɛr dom yic? Na ye këya ka abaar kënë cil këdë dom yic?’ ");
INSERT INTO dikNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Go bɛ̈ɛ̈r, ‘Ee raan man ɣa yen acï kënë looi,’ Go raan ë luɔi lueel, ‘Wïc buk abaar nyuän wei dom yic?’ ");
INSERT INTO dikNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Go wun dom bɛ̈ɛ̈r, acie tɛ̈de, ‘Rin tɛ̈ nyuɛ̈n yïn abaar, ke yïn amɛt rap wei ke ke. ");
INSERT INTO dikNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Cɔl rap ku abaar aa dït kedhie agut tɛ̈ bï kek luɔk, ku aba lɛ̈k kɔc tëm ëlä, kaŋkë abaar nyuɔ̈n ku duɔ̈tkë ke bï ke yɔɔt, ku jälkë rap tem ku tääukë ke kändiɛ̈ yic.’ ” ");
INSERT INTO dikNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ku benke lɛ̈k kääŋ dɛ̈t ëlä, “Bääny Nhialic acït käu koor nyin cï raan com duɔmde. ");
INSERT INTO dikNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Yeen akoor nyin apɛi kam kɔ̈th ëbën. Ku na le dït ka wär tiim ëbën, ee la nhial ke loi kërdït apɛi abï diɛt ɣɔ̈ɔ̈tken aa yïk thïn.” ");
INSERT INTO dikNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ku ben lueel, “Bääny Nhialic acït luɔu cï tik puɔr ayumdït tet yic, na lä ke piäär ëbën.” ");
INSERT INTO dikNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Këya, Jethu ë ye kɛ̈ŋ lueel ku bï yen kɔc lɛ̈k wɛ̈lke ëbën, acïn kë ye lueel ke cïï kääŋ thɔ̈th. ");
INSERT INTO dikNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ee ye looi këya rin bï wɛ̈t cï raan käk Nhialic tïŋ lueel thɛɛr yenhom tiɛɛŋ, “Ɣɛn abï jam kɛ̈ŋ tënë week, bï ɣɛn ke käk kuc tɛ̈wäär ciɛk nhial ku piny teet yiic.” ");
INSERT INTO dikNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Go Jethu kɔc nyääŋ aɣeer ku ler ɣöt, go kɔcken ye buɔɔth bɛ̈n tënë ye ku luelkë, “Tɛ̈t ɣo kääŋ abaar yic.” ");
INSERT INTO dikNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Go bɛ̈ɛ̈r, “Raan ë puɔ̈r cï kɔ̈th path wɛɛr dom, ee Manh Raan. ");
INSERT INTO dikNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Dom ë pinynhom, ku kɔ̈th path aa kɔc ŋic Nhialic, ye bääny Nhialic këden, ku abaar aa kɔc ë jakrɛc, ");
INSERT INTO dikNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ku raan cä abaar mat dom yic ë jɔŋrac. Ku tëmtëm ë thök ë piny, ku kɔc tëm atuuc Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Këya, cïmën ye abaar nyuän wei dom yic ku yɔt, yen abï ya tɛ̈de aköl thöök piny. ");
INSERT INTO dikNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Manh Raan abä atuuc Nhialic tooc, ku aabï kɔc rɛc ë kɔc ɣäth kärac yiic, ku kɔc luui kärɛc tɛ̈t bei kɔc path yiic, ");
INSERT INTO dikNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ku cuɛt ke many dɛ̈p cï löklök apɛi, bï kek aa dhiau thïn ke ŋɛny kelec akölriëëc ëbën. ");
INSERT INTO dikNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ku kɔc path aabï ruɛl cïmën akɔ̈l bääny Wunden yic nhial.” Ku wit lɔ̈ŋde ëlä, “Piɛŋkë tɛ̈ le wek yïth!” ");
INSERT INTO dikNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ku thɔ̈th Jethu kääŋ dɛ̈t ëlä, “Bääny Nhialic acït jiɛɛk cï wɛc piny dom yic. Go raandä yök ku nyiɛɛi ku ben thiaan ku jiël ke cï puɔ̈u miɛt apɛi, ku le käkke ɣaac ëbën, ku ɣɔɔc dom wën, rin nhiɛɛr yen jiɛɛk kënë apɛi.” ");
INSERT INTO dikNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ku ben Jethu lueel, “Bääny Nhialic acït raan ɣöc, wïc käpath apɛi, ");
INSERT INTO dikNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","nawën yök këtööŋ path apɛi ke la käkke ɣaac wei ëbën ku ɣɔɔc kënë awën.” ");
INSERT INTO dikNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Bääny Nhialic aya, acït buɔn cï cuat wïïr ku dɔm kuat ë rɛ̈c ëbën. ");
INSERT INTO dikNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Tɛ̈ cï yen thiäŋ, ke miit amɛ̈i agör nhom ku nyuuckë bïk rec kuany yiic, ku tɛ̈ɛ̈ukë rec path gäc yic, ku cuɛtkë rec cïï path wei. ");
INSERT INTO dikNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kënë, yen ë tɛ̈ bï yen rot luɔɔi thïn aköldä thöök piny. Atuuc Nhialic aabï tuɔ̈l ku kuënykë kɔc rɛc bei ë kɔc yiic, ");
INSERT INTO dikNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ku cuɛtkë ke pan mac tɛ̈ bï kek dhiau thïn ke ŋɛny kelec akölriëëc ëbën.” ");
INSERT INTO dikNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ku thiëc Jethu ke, “Cäk wëlkä deet yiic apath?” Gokë gam. ");
INSERT INTO dikNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Go lɛ̈k ke, “Na ye këya, ke raan piööc ë lööŋ cï piɔ̈ɔ̈c käk bääny Nhialic, acït raan baai käkken yam ku käthɛɛr bɛ̈ɛ̈i aɣeer ëbën paande.” ");
INSERT INTO dikNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Wën cï Jethu thök luɛl ë kɛ̈ŋkä, ke jiël, ");
INSERT INTO dikNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ku dhuk gɛnden. Ku piööc kɔc tɛ̈n amat, piööc cï kɔc ke tɔ̈ thïn bɛ̈n gɔ̈i ëbën ku luelkë, “Cï mony kënë käŋ bɛ̈n aa ŋic nɛn, ku yök riɛl ë yen käk jäŋ gɔ̈i looi tɛ̈nɛn? ");
INSERT INTO dikNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Kënë, cie wën raan dhie ë guaŋ? Ku man cie tiŋ dhie cɔl Maria, ku yeen cie mɛ̈nh ë Jemith ku Jothep ku Thaimon ku Judath? ");
INSERT INTO dikNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ku nyiɛ̈rakën aya, cïk tɔ̈u ë tɛ̈n kek ɣo? Yök käkkä ëbën tɛ̈nɛn?” ");
INSERT INTO dikNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ku kueeckë ë ye. Go Jethu lueel tënë ke, “Raan cï Nhialic lööny yeguɔ̈p aye baai ëbën theek, ka kɔc gɛnden ku kɔc ruääi kek ye, kek aacie ye ye theek.” ");
INSERT INTO dikNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ku akëc käjuëc jäŋ gɔ̈i looi tɛ̈në rin cïn kek gam. ");
INSERT INTO dikNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tɛ̈wën ke bɛ̈nyŋaknhom Antipäth Ɣërot, bɛ̈ny Galilia ëcï wɛ̈t cï Jethu ŋic apɛi piŋ. ");
INSERT INTO dikNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Go lɛ̈k bänyken luk, “Kënë ë Joon raan kɔc muɔc nhïïm guɔ̈p, yen acï bɛn pïr. Ee yen le yen riɛl yen käkkä looi.” ");
INSERT INTO dikNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Antipäth Ɣërot ëcï Joon cɔl adɔm ku rek ku mac, rin wɛ̈t Ɣërodia tiŋ Pilipo wämënh cï rum bï ya tiɛŋde. ");
INSERT INTO dikNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Rin cï Joon ye lɛ̈k ye ëlä, “Acïï path ba tiŋ wämuuth rum ke pïr!” ");
INSERT INTO dikNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Go Antipäth Ɣërot wïc bï Joon nɔ̈k, ku ë riɔ̈c kɔc Itharel, rin ŋic kek Joon ke ye raan käk Nhialic tïŋ. ");
INSERT INTO dikNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nawën aköl yan dhiëëth Antipäth Ɣërot, ke nyan Ɣërodia diër kɔc nhïïm, abï Antipäth Ɣërot puɔ̈u miɛt apɛi, ");
INSERT INTO dikNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ku kuëëŋ lɔn bï yen ye gäm kuat këden bï wïc! ");
INSERT INTO dikNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Go lɛ̈k ye tɛ̈ cït tɛ̈ cï man ye than thïn, “Yiëk ɣa nhom Joon ëmën ke cï tääu aduɔ̈k yic!” ");
INSERT INTO dikNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Kënë ëcï bɛ̈ny rac puɔ̈u, ku rin cï yen kuëëŋ ë jɔ̈ɔ̈l nhïïm, acï gam bï nhom Joon gäm ye. ");
INSERT INTO dikNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ku cɔl Joon ala tök yeth tɛ̈wën mɛc yen thïn. ");
INSERT INTO dikNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ku bïï nhom ke cï tääu aduɔ̈k yic, ku gɛ̈m nya ku le gäm man. ");
INSERT INTO dikNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Go kɔc Joon buɔɔth bɛ̈n ku nyɛɛikë guäpde, ku lek tɔ̈ɔ̈u, ku lek lɛ̈k Jethu. ");
INSERT INTO dikNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Wën piŋ Jethu kë cï rot looi, go jäl ë riäi bï la tɛ̈de ë rot. Ku tɛ̈wën piŋ kɔc ë kënë, ke jiël gɛɛthken yiic kecök ku buɔthkë. ");
INSERT INTO dikNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Nawën kɛɛc Jethu piny ë riäi yic, ke tïŋ kɔc juëc apɛi, go yic ŋɛɛr ë ke, ku kony kɔcken tuany. ");
INSERT INTO dikNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nawën col piny, ke kɔcken ye buɔɔth bɔ̈ tënë ye ku luelkë, “Piny acï cuɔl, ku tɛ̈n ë ror cïn kë kuany thïn. Cɔl kɔc aa thiɛ̈i bïk la bɛ̈ɛ̈i yiic ku bïk röt la ɣɔ̈c miëthden.” ");
INSERT INTO dikNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Go Jethu bɛ̈ɛ̈r, “Acïn tɛ̈ bï kek jäl, na le miëth ke gämkë ke!” ");
INSERT INTO dikNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Gokë bɛ̈ɛ̈r, “Käk mukku ëbën, aa ayuɔ̈p kadhiëc ku rec karou.” ");
INSERT INTO dikNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Go Jethu lueel, “Bɛ̈ɛ̈ikë ke tɛ̈n tënë ɣa.” ");
INSERT INTO dikNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ku yöök kɔc bïk nyuc ë noon nhom, ku lööm ayuɔ̈p awën kadhiëc ku rec karou, ku döt nhial ku leec Nhialic. Ku bɛny ayuɔ̈p yiic, ku gɛ̈m ke kɔcken ye buɔɔth bïk ke tek agut rec, tënë thän awën. ");
INSERT INTO dikNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ku mïthkë ëbën abï miëth ke göök, ku jɔl kɔcken ye buɔɔth awuthueei ayuɔ̈p ku rec cï döŋ piny, kuany gääc kathiäär ku rou. ");
INSERT INTO dikNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Kɔc ke cï mïth ëbën, röör röt aake ye tiim kadhiëc. ");
INSERT INTO dikNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ku kaam awën ke Jethu yöök kɔcken ye buɔɔth bïk la riäi yic, ku lek tueŋ yenhom agör alɔŋtui, ku cɔl thɛ̈i ajiël. ");
INSERT INTO dikNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Wën cï yen kɔc cɔl athiɛ̈i, ke la gɔt nhom ë rot bï la röök. Nawën la thëi bɛ̈n, ke Jethu ë rɛ̈ɛ̈r ë tɛ̈ɛ̈n yetök, ");
INSERT INTO dikNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ku riäi ke cï ɣet tɛ̈mec, ke cïï cath apath rin lor yen yom nhom. ");
INSERT INTO dikNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Nawën bɛ̈ɛ̈k piny ke Jethu bɔ̈ tënë ke ke cath pïu nhïïm. ");
INSERT INTO dikNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Nawën tïŋ kɔcken ye buɔɔth ke cath pïu nhïïm gokë riɔ̈ɔ̈c apɛi, ku luelkë, “Atïm raan cï thou,” ku dhiɛɛukë rin cï kek riɔ̈ɔ̈c. ");
INSERT INTO dikNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ku kaam awën ke lëk Jethu ke, “Dɛɛtkë wepuɔ̈th, ee ɣɛn Jethu, Duɔ̈kkë riɔ̈c!” ");
INSERT INTO dikNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Go Pïtɛr lueel, “Bɛ̈ny, na ye yï ayic, ke yï yïk ɣa riɛl ba la tënë yï, ɣa cath pïu nhïïm.” ");
INSERT INTO dikNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Go Jethu lueel, “Bäär!” Go Pïtɛr bɛ̈n bei riäi yic, ku ciɛth pïu nhïïm ke la tënë Jethu. ");
INSERT INTO dikNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ku wën tïŋ yen yom ke biök apɛi, go riɔ̈ɔ̈c ku duër dïïr, go dhiau, “Luäk ɣa Bɛ̈ny!” ");
INSERT INTO dikNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Go Jethu dɔm nyin yic ku lueel, “Yïn raan la gam koor, yeŋö diiu yïn?” ");
INSERT INTO dikNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ku wën le kek riäi yic, ke yom kääc. ");
INSERT INTO dikNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Go atuuc ke tɔ̈ riäi yic Jethu door ku luelkë, “Yïn ë Manh Nhialic alanden.” ");
INSERT INTO dikNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Gokë wär teem ku lek Jenetharet. ");
INSERT INTO dikNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nawën ŋic kɔc Jenetharet Jethu, gokë kɔc thiääk ke ke lɛ̈k, ku ɣɛ̈thkë kɔc tuany ëbën tënë ye. ");
INSERT INTO dikNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ku läŋkë bïk gɔɔt, cɔk alanhde thok ë path, ku kuat raan cï ye gɔɔt ëbën ee pial. ");
INSERT INTO dikNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Go Parathï ku kɔc piööc ë ciɛɛŋ kɔc Itharel bɔ̈ Jeruthalem la tënë Jethu ku thiëckë, ");
INSERT INTO dikNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Yeŋö ye kɔckun yï buɔɔth ciɛɛŋ thɛɛr wärkuan dït dhɔ̈l yic? Keek aacie kecin ë lɔɔk tueŋ tɛ̈ mïth kek!” ");
INSERT INTO dikNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Go Jethu bɛ̈ɛ̈r, “Ku yeŋö ye wek kuec löŋ ë Nhialic, ku yakë buɔɔth yic ë ciɛɛŋdun thɛɛr? ");
INSERT INTO dikNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Rin acï Nhialic lueel, ‘Thek wuur ku moor, ku raan wun ku man jääm guɔ̈p kärɛc ka dhil nɔ̈k bï thou.’ ");
INSERT INTO dikNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ku ayakë lueel aya lɔn na la raan kën bï yen wun ku man kony, ku lueel, ‘Acïn tɛ̈ kuɔ̈ny we, rin kë muɔ̈k kënë ë kën ë Nhialic,’ ");
INSERT INTO dikNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ka këc wun ku man theek. Yen ë tɛ̈ ye wek wɛ̈t Nhialic dhäl yic thïn, ku ye ciɛɛŋdun thɛɛr yen biathkë yic. ");
INSERT INTO dikNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Awëëŋ kui, Ithaya acï yic lueel ë riɛnkun wäär lueel yen wɛ̈t ëlä! ");
INSERT INTO dikNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Kɔckä, aa ɣa leec kethook ku aliu kepuɔ̈th. ");
INSERT INTO dikNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Keek aa ɣa door ku acie duɔ̈ɔ̈r ë yic, rin keek aa kɔc piɔ̈ɔ̈c lööŋ ciɛɛŋ raan ciɛ̈t ke ye lɔ̈ɔ̈ŋkiɛ̈!’ ” ");
INSERT INTO dikNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Go Jethu kɔc juëc bɛn cɔɔl ku lëk ke, “Piɛŋkë wɛ̈tdiɛ̈ wedhie ku dɛtkë yic. ");
INSERT INTO dikNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Acie kë ye raan cam, yen ye cɔl aye raan rac, aa käk ye tak ku käk ye lueel, ku käk ye looi kek aaye cɔl aye raan rac.” ");
INSERT INTO dikNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Nawën ke kɔcken ye buɔɔth bɔ̈ tënë ye ku luelkë, “Ŋic lɔn cï Parathï puɔ̈th riääk wën piŋ kek kë ca lueel?” ");
INSERT INTO dikNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Go bɛ̈ɛ̈r, “Kuat raan cïï wɛ̈t Wä tɔ̈ nhial loi, acïï pïr akölriëëc ëbën bï yök. ");
INSERT INTO dikNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Duɔ̈kkë diɛɛr ë ke! Aa cït cöör thel röt, ku na thel cɔr, cɔr dɛ̈t, ka lööny adhuɔ̈m yic kedhie.” ");
INSERT INTO dikNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Nawën cï lɔ̈ŋde wit, ke thiëëc Pïtɛr, “Tɛ̈t ɣo kääŋ kënë yic.” ");
INSERT INTO dikNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Go Jethu lɛ̈k ke, “Cäk käŋ ye deet yiic aya? ");
INSERT INTO dikNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Cäk ye tïŋ lɔn kë ye raan cam acie la yepuɔ̈u, ee la yeyäc ku le bɛ̈n bei? ");
INSERT INTO dikNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ku käk ye raan lueel aa bɛ̈n bei yepuɔ̈u, ku aa kek raan cɔl ala guɔ̈p adumuɔ̈ɔ̈m. ");
INSERT INTO dikNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Rin puɔ̈u yen aye kärɛc ye raan looi bɛ̈n bei thïn, cïmën bal ku näk raan ë path ku kɔ̈r ë diäär, ku cuëër ku jam lueth. ");
INSERT INTO dikNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Käkkä kek aa raan cɔl aloi kärɛc. Ku miëth ye raan mïth ke këc yecin lɔɔk acie adumuɔ̈ɔ̈m.” ");
INSERT INTO dikNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ku jɔl Jethu jäl ku ler wun dɛ̈t tɛ̈thiääk kek Tire ku Thidon. ");
INSERT INTO dikNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Go tiŋ wun Kanaan ciëŋ ë tɛ̈në bɛ̈n tënë ye ku lɛ̈ŋ, “Bɛ̈ny, wën Debit, kony ɣa! Nyaandiɛ̈ acï jɔŋrac la yeguɔ̈p, ku yeen adhɛ̈l apɛi.” ");
INSERT INTO dikNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Go Jethu wɛ̈tde cïï bëër. Go atuɔ̈ɔ̈cke bɛ̈n tënë ye ku läŋkë, “Gäm kë wïc ku cɔl ajiël! Abuɔth ɣo ke rɛ̈ɛ̈m ɣonhïïm tɛ̈thɛɛr awën!” ");
INSERT INTO dikNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Go Jethu bɛ̈ɛ̈r, “Ɣɛn acï tuɔ̈ɔ̈c tënë kɔc Itharel kuc Nhialic kepɛ̈c.” ");
INSERT INTO dikNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Kaam wën ke tik bɔ̈ ku cuɛt rot piny yecök ku lɛ̈ŋ, “Kony ɣa Bɛ̈ny.” ");
INSERT INTO dikNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Go Jethu bɛ̈ɛ̈r, “Acïï path bï miëth ë mïth gäm jɔ̈k.” ");
INSERT INTO dikNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Go bɛ̈ɛ̈r, “Ee yic Bɛ̈ny, ku jɔ̈k rɛ̈ɛ̈r tɛ̈ mïth kɔc thïn awuthueei cï lööny piny kuany aya.” ");
INSERT INTO dikNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Go Jethu lɛ̈k ye. “Yïn ee tiŋ la gam dït apɛi. Kë wïc abï looi tënë yï.” Ku kaam thiin awën ke nyaande pɛ̈l këdäŋ piny. ");
INSERT INTO dikNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Go Jethu jäl ë tɛ̈në ke kuany wär Galilia kɔ̈u. Nawën ke la gɔt nhom ku nyuuc. ");
INSERT INTO dikNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Go kɔc juëc kɔcken tuany bɛ̈ɛ̈i tënë ye, kɔc cï ŋɔl ku cöör ku kɔc cï ruai ë rɔ̈c piiny, ku miŋ cie jam ku kɔc juëc kɔ̈k. Ku nyuuckë ke yelɔ̈ɔ̈m, goke kony bïk pial. ");
INSERT INTO dikNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Go thän awën gäi wën tïŋ kek miŋ ke jam, ku aduany ke cï la cök, ku ŋɔl ke cath path ku cɔr ke daai, ku leckë Nhialic Itharel. ");
INSERT INTO dikNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ku cɔl Jethu kɔcken ye buɔɔth ku lueel, “Ɣɛn acï guɔ̈p ŋɔ̈ŋ, rin kɔckä aacï rëër kek ɣɛn nïn kadiäk ëmën, ku acïn kë camkë. Ku acä wïc ba ke cɔl ajiël ke nɛ̈k cɔk, tɛ̈dë ka la wïïk dhël yic.” ");
INSERT INTO dikNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Go kɔcken ye buɔɔth lɛ̈k ye, “Ye tɛ̈nɛn bï ɣok miëth yök thïn roor ë tɛ̈n bï kɔc juëckä cam?” ");
INSERT INTO dikNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Go Jethu ke thiëëc, “Lak ayuɔ̈p kadë?” Gokë lueel, “Aa dhorou ku rec thii lik.” ");
INSERT INTO dikNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Go lɛ̈k thän awën bïk nyuc piiny. ");
INSERT INTO dikNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ku lööm ayuɔ̈p awën kadhorou ku rec thii awën, ku röök Nhialic ku bɛny keyiic, ku gɛ̈m ke kɔcken ye buɔɔth bïk ke tɛ̈k kɔc. ");
INSERT INTO dikNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ku jɔlkë mïth ëbën bïk kuɛth. Ku kuɛny kɔc Jethu buɔɔth awuthueei ayuɔ̈p cï döŋ piny gääc kadhorou. ");
INSERT INTO dikNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Kɔc ke cï mïth, röör ë röt aake ye tiim kaŋuan, ke diäär ku mïth këc mat thïn. ");
INSERT INTO dikNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ku jɔl Jethu kɔc cɔl ajiël, ku ler riäi yic ku ler wun cɔl Magadan. ");
INSERT INTO dikNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Tɛ̈wën ke Parathï ku Thaduthï bɔ̈ tënë Jethu, ku wïckë bïk deep ë wɛ̈t, ku yöökkë bï kënë jäŋ gɔ̈i looi, bï nyuɔ̈th ke lɔn ye Nhialic wɛ̈lke gam. ");
INSERT INTO dikNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Go Jethu bɛ̈ɛ̈r, “Ayakë lueel tɛ̈ lööny akɔ̈l piny. Abä aliir path bɛ̈ɛ̈i, akɔ̈l acï nyaany looi.” ");
INSERT INTO dikNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ku na ye nhiäknhiäk ka luɛlkë, Abï tuɛny akölë, rin acï piny dɔm bï la dïl ku looi luäät. Wek aa kë bï rot looi ŋic tɛ̈ tïŋ wek käkkä nhial, ku wek aacie käk loi röt ëmën ye ŋic! ");
INSERT INTO dikNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Aa kɔc la gup anyon ku gam koor kek aa thiëc kë tïŋkë. Acïn kën jäŋ gɔ̈i bï nyuɔ̈th we, ee këwäär cï rot looi tënë Jona. Ku nyiëëŋ ke piny ku jiël. ");
INSERT INTO dikNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Kaam wën ɣeet kek wär alɔŋtui, ke tɛk kɔcken ye buɔɔth lɔn cï kek nhïïm määr bïk miëth cïï muk. ");
INSERT INTO dikNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Go Jethu lɛ̈k ke, “Tiëërkë nhïïm, ku tiɛtkë röt bäk cïï nhiam cïmën Parathï ku Thaduthï, nhiaamden ke cɔl ago puɔ̈ɔ̈r cïmën ayum cï yiëk yic luɔu.” ");
INSERT INTO dikNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Gokë jam ë kamken, “Ee ɣo yɔ̈ɔ̈k këlä, rin cïn yen ayuɔ̈p cuk bɛ̈ɛ̈i.” ");
INSERT INTO dikNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Go Jethu kë takkë guɔ ŋic ku lëk ke, “Wek kɔc koor gamdun! Yeŋö ye wek diɛɛr lɔn cïn wek miëth? Ŋot we cie käŋ ye deet? ");
INSERT INTO dikNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Cäk lëu ku bäk tak yen tɛ̈wäär kueth ayuɔ̈p kadhiëc röör tiim kadhiëc, ku gääcdït cï bɛ̈n thiäŋ awuthueei cï döŋ piny? ");
INSERT INTO dikNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ku jɔl aa yuɔ̈p kadhorou wäär cï röör tiim kaŋuan cam bïk kuɛth, ku gääc thiäŋ awuthueei cäk bɛ̈n kuany? ");
INSERT INTO dikNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Yeŋö këc wek ye deet yic, lɔn ɣɛn a ɣa cïï jam tënë we rin ayuɔ̈p? Kë ca lueel akïn, abɛn ber yic, tiɛtkë röt bäk cï nhiam cïmën Parathï ku Thaduthï!” ");
INSERT INTO dikNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Go atuɔ̈ɔ̈cke jäl deet yic, lɔn acïï Jethu lëk ke bïk röt tiit lon dhie ye tääu ayup yic bï puɔ̈ɔ̈r, ee lɔn bï kek röt tiit piööc rɛɛc Parathï ku Thaduthï. ");
INSERT INTO dikNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Wën cï Jethu ɣet Cetharia tɔ̈ Pilipi, ke thiëc kɔcken ye buɔɔth ëlä, “Ye jäŋ tak ye Manh Raan ŋa?” ");
INSERT INTO dikNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Gokë bɛ̈ɛ̈r, “Ayekë lueel lɔn ye yen Joon raan kɔc muɔɔc nhïïm, ku lueel kɔc kɔ̈k lɔn ye yen Elija, ku aye kɔc kɔ̈k lueel lɔn ye yen Jeremia, tɛ̈dë ke ye raan töŋ kam kɔc käk Nhialic tïŋ.” ");
INSERT INTO dikNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Goke thiëëc, “Na week, yakë tak lɔn ye ɣɛn ŋa?” ");
INSERT INTO dikNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Go Pïtɛr bɛ̈ɛ̈r, “Yïn ë Raan cï lɔc ku dɔc, Manh Nhialic pïr.” ");
INSERT INTO dikNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Go Jethu lueel, “Yïn acï Nhialic dɔɔc wën Jona, rin yic kënë ëcïï tak ë rot, ee Wä tɔ̈ nhial yen anyuth ye yï ba lueel këya. ");
INSERT INTO dikNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ku alɛ̈k yï ëmën. Yïn acɔl Pïtɛr, ku wɛ̈tde yic, alɛl, ku alel kënë nhom ɣɛn bï luaŋdiɛ̈ buth thïn, ku acïï riɛl ë jɔŋrac bï lëu bï thuɔ̈r piny. ");
INSERT INTO dikNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ku yïn aba gäm riɛl bääny pan Nhialic, kë cïï bï päl piny pinynhom acïï bï puɔ̈l nhial, ku kë ba puɔ̈l pinynhom abï puɔ̈l nhial aya.” ");
INSERT INTO dikNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ku yöök kɔcken ye buɔɔth bïk cïï lëk raan dɛ̈t, lɔn ye yen Raan cï lɔc ku dɔc. ");
INSERT INTO dikNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ku jɔl Jethu wɛ̈t agai yic tënë kɔcken ye buɔɔth, “Ɣɛn abï dhiɛl la Jeruthalem. Ku ɣɛn abï gum apɛi kɔcdït ë baai cin, ku kɔc käk Nhialic, ku kɔc piööc lööŋ cin aya. Ku ɣɛn abï nɔ̈k ba thou, ku na ye aköl ye nïn diäk ke ɣɛn abï bɛn pïr.” ");
INSERT INTO dikNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Go Pïtɛr miɛɛt wei kɔc yiic, ku dɔk bï cïï ye jam këlä, ku lueel, “Bɛ̈ny, acïï Nhialic bï puɔ̈l bï rot looi. Kënë acïï rot bï dhiɛl looi tënë yï!” ");
INSERT INTO dikNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Go Jethu yenhom wel ku lëk Pïtɛr, “Jäl ɣalɔ̈ɔ̈m jɔŋrac! Wïc ba kë cï Nhialic guiir riɛnkiɛ̈ waar yic. Käk ye tak aacie käk Nhialic aa wël raan ë path.” ");
INSERT INTO dikNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ku jɔl Jethu lɛ̈k kɔcken ye buɔɔth, “Na ye raan wïc bä buɔɔth, ka dhil nhom määr käpuɔth bï yök ë piɛ̈rde yic pinynhom ë tɛ̈n. Ku dhil puɔ̈u riɛl ku buɔɔth ɣa, cɔk alɔn wïc kɔc kɔ̈k ye bïk nɔ̈k ë riɛnkiɛ̈. ");
INSERT INTO dikNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Rin raan wïc ye bï wɛ̈ike ë rot ŋiɛc muk pinynhom ë tɛ̈n, ka cïï pïr aköldä bï yök, ku na ye raan mär wɛ̈ike ë riɛnkiɛ̈, ku rin ë piɔ̈ɔ̈cdiɛ̈ ka bï wɛ̈ike muk akölriëëc ëbën. ");
INSERT INTO dikNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Yeŋö bï raan yök thïn, tɛ̈ jiɛɛk yen apɛi pinynhom ë tɛ̈n ku mɛ̈r wɛ̈ike? Tɛ̈dë, ye këpiath ŋö bï yök bï yen wɛ̈ike waar? ");
INSERT INTO dikNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Rin aköl bï Manh Raan bɛ̈n kek duaar ë Wun kek atuuc nhial, ke yeen abï raan ëbën yiëk ariöp thöŋ kek këden cï looi. ");
INSERT INTO dikNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ku le tueŋ ku lueel, wek aa lɛ̈k yic, ala kɔc kɔ̈k rɛ̈ɛ̈r ë tɛ̈n aacïï bï thou agut tɛ̈ bï kek Manh Raan tïŋ ke bɔ̈ ke ye Bɛ̈nyŋaknhom.” ");
INSERT INTO dikNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nawën nïn kadätem cök, ke Jethu cɔl Pïtɛr ku Jemith kek wämënh Joon, ku lek gɔn bär apɛi nhom kepɛ̈c. ");
INSERT INTO dikNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tɛ̈wën rëër kek, ke Jethu waŋ rot, ku ɣer nyin cïmën akɔ̈l, ku jɔl aläthke ɣɛr apɛi bïk la diardiar. ");
INSERT INTO dikNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kaam awën ke Mothith ku Elija tul, ku jiɛɛmkë kek Jethu. ");
INSERT INTO dikNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Go Pïtɛr lɛ̈k Jethu, “Bɛ̈ny, apath buk rëër ë tɛ̈n. Na wïc ke ɣɛn aloi duɛ̈l kadiäk ë tɛ̈n, tök kek yï, ku tök kek Mothith ku töŋ dɛ̈t kek Elija.” ");
INSERT INTO dikNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Kaam wën ŋot jiɛɛm yen, ke këcït rur pat piny abï ciɛ̈n tɛ̈ yekë tïŋ, ku piŋkë Nhialic ke jam ëlä, “Kënë ë Wëndiɛ̈n nhiaar, mit ɣɛn puɔ̈u tënë ye piɛŋkë wɛ̈tde.” ");
INSERT INTO dikNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nawën piŋ kɔc Jethu buɔɔth wɛ̈t kënë, gokë riɔ̈ɔ̈c apɛi ku wïïkkë. ");
INSERT INTO dikNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Go Jethu bɛ̈n tënë ke ku gɔɔt ke ku lueel, “Jatkë röt. Duɔ̈kkë riɔ̈c.” ");
INSERT INTO dikNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nawën jɔtkë kenyïn, ke cïn raan dɛ̈t tïŋkë, ke ye Jethu ë rot. ");
INSERT INTO dikNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Tɛ̈wën dhuk kek piny ë gɔt nhom, ke lëk Jethu ke, “Duɔ̈kkë käk cäk tïŋ lëk raan dɛ̈t ɣet aköl bï Manh Raan jɔt raŋ yic.” ");
INSERT INTO dikNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Go kɔcken ye buɔɔth thiëëc, “Yeŋö ye kɔc piööc lööŋ kɔc Itharel ye lueel, lɔn ë yen Elija yen bï kaŋ bɛ̈n tueŋ?” ");
INSERT INTO dikNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Go bɛ̈ɛ̈r ëlä, “Ee yic Elija akɔŋ bɛ̈n rin bï yen dhël bɛ̈n guiir. ");
INSERT INTO dikNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ku alɛ̈k we lɔn cï Elija bɛ̈n thɛɛr, ku akëc kɔckä bɛ̈n ŋic ku luikë këden nhiarkë. Cït ëmën aya, Manh Raan abïk cɔl arem apɛi.” ");
INSERT INTO dikNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Go kɔcken ye buɔɔth deet yic lɔn nadë ka jam tënë ke rin Joon raan kɔc muɔɔc nhïïm. ");
INSERT INTO dikNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nawën lek dhuk piny gɔt nhom, ke yök kɔc juëc ke tit ke. Go raan tök bɛ̈n ku gut yenhiɔl piny Jethu nhom, ");
INSERT INTO dikNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ku lueel, “Bɛ̈ny, kony manhdiɛ̈. Ala guɔ̈p nok ku acï ye göök apɛi. Aye lac wiɛt mɛɛc, tɛ̈dë ke le wiɛt wïïr. ");
INSERT INTO dikNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ku ë ca bɛ̈ɛ̈i tënë kɔckun yï buɔɔth ku akëckë lëu bï pial.” ");
INSERT INTO dikNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Go Jethu lɛ̈k ke, “Wek kɔc cie lac gam, yakë tak ba rëër kek we ɣet nɛn? Bɛ̈ɛ̈i dhɔ̈ŋ kënë tënë ɣa.” ");
INSERT INTO dikNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Nawën lek bɛ̈ɛ̈i, ke Jethu rël jɔŋrac, go jäl meth guɔ̈p, ku go pial nyin yic. ");
INSERT INTO dikNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Nawën ke kɔc Jethu buɔɔth bɔ̈ tënë ye ë rot ku thiëckë, “Yeŋö këc ɣok ye lëu buk jɔŋ kënë cuɔp wei?” ");
INSERT INTO dikNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Go lɛ̈k ke, “Ee rin koor gamdun,” Ku le tueŋ ku lueel, “Na we la gam cɔk kuur cïmën manh ŋaap koor nyin, ka lɛ̈kkë ë gɔn kënë, ‘Jälë ë tɛ̈n!’ Ka lëu bï jäl. Acïn kë dhal we bäk cïï loi.” Ku lëk ke, “Jɔŋ cït kënë ë ɣɛn alëu ye ba cuɔp wei, rin ye ɣɛn cool ë röök!” ");
INSERT INTO dikNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Naɣɔn akäl tök, wën ŋoot kek Galilia, ke lëk Jethu ke, “Manh Raan abï thɔ̈n kɔc, ");
INSERT INTO dikNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ku abïk nɔ̈k, ku na aköl ye nïn diäk, ka bï jɔt raŋ yic.” Gokë puɔ̈th dak apɛi. ");
INSERT INTO dikNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Nawën cï Jethu kek atuɔ̈ɔ̈cke ɣet Kapernaum, ke kɔc ë kut ajuër luaŋ Nhialic bɔ̈ tënë Pïtɛr ku thiëckë, “Ye raandun piööc ajuër luaŋ Nhialic tääu piny?” ");
INSERT INTO dikNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Go Pïtɛr bɛ̈ɛ̈r, “Aye tääu piny.” Ku le ɣöt bï la lɛ̈k Jethu. Go Jethu guɔ kaaŋ wei ku thiëëc, “Ye tak këdë Pïtɛr? Yeŋa bäny pinynhom juɛ̈r? Ye kɔcken baai aye kɔc thäi kɔ̈k?” ");
INSERT INTO dikNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Go Pïtɛr bɛ̈ɛ̈r, “Aa kɔc ë thäi.” Go Jethu lueel, “Na ye këya ke kɔc baai aacie ajuër ë tääu piny. ");
INSERT INTO dikNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ku yen acuk wïc buk kɔckä rac puɔ̈th. Lɔr wïïr ku cuat bïdho, ku mïït rɛ̈c ba dɔm tueŋ bei ku ŋam thok, ku yïn abï wëëu lëu ajuerdiɛ̈ ku ajuërdu yök thïn. Ɣäth ke tënë ke ke ya ajuɛ̈rda ɣodhie.” ");
INSERT INTO dikNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Kaam wën ke kɔc Jethu buɔɔth bɔ̈ tënë ye ku thiëckë ëlä, “Yeŋa yen dït apɛi kam kɔc tɔ̈ bääny pan Nhialic yic?” ");
INSERT INTO dikNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Go Jethu meth cɔɔl, ku cɔl akääc kenhïïm, ");
INSERT INTO dikNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ku lueel, “Wek alɛ̈k yic, na cäk röt war bäk ciɛ̈t mïth kor, ke wek aacïï bääny Nhialic bï kaŋ yök. ");
INSERT INTO dikNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Këya raan rot dhuɔ̈k piny bï ciɛ̈t ë manh kënë yen adït apɛi pan Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ku raan manh koor cït manh kënë lor riɛnkiɛ̈, acä lor. ");
INSERT INTO dikNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Na ye raan wëŋ mɛnh tök kam ë mïthkä, ku bä maan ka ŋuɛ̈ɛ̈n tënë ë raan cït kënë diɛ̈t cï ruɔ̈k yeth aleldït tet, ku pïk wïïr bï mou. ");
INSERT INTO dikNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ye kërɛɛc yïndë pinynhom ye kɔc kɔ̈k kɔc wɛ̈ŋ kärɛc yiic. Käkkä aabï röt dhiɛl aa looi akölaköl, ku bï yiën dë tënë kɔc käkkä looi! ");
INSERT INTO dikNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Ku na ye ciɛɛndu ayï cɔ̈ɔ̈kdu yï cɔl aloi awuɔ̈c, ka tëëm bei ku cuat ke wei. Rin aŋuɛ̈ɛ̈n ba pïr pïr path ke yï ye ŋɔl, tɛ̈në tɛ̈ bï yïn la cin karou ku cök karou ku cuɛt yï many dɛ̈p yic akölriëëc ëbën. ");
INSERT INTO dikNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ku na ye nyiɛndu yï cɔl aloi adumuɔ̈ɔ̈m, ke ŋuët bei ku cuat wei. Rin aŋuɛ̈ɛ̈n ba pïr yök ke yï la nyiɛn tök, tɛ̈n tɛ̈ bï yïn la nyïn karou, ku bï yï la cuat pan mac. ");
INSERT INTO dikNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Duɔ̈kkë them bäk mïth thiikä bui. Alɛ̈k we bäk ŋic lɔn atuɔ̈ɔ̈cken nhial aa rëër Wä lɔ̈ɔ̈m akölaköl pan Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ku ɣɛn Manh Raan ɣɛn acï bɛ̈n ba kɔc cï määr bɛ̈n gäm pïr. ");
INSERT INTO dikNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Lɛ̈k ɣa yic. Na raan ala amääl buɔɔt ku mär amäl tök ke cïï thiärdhoŋuan ku dhoŋuan nyiëëŋ piny, ku le amäl kënë wïc? ");
INSERT INTO dikNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ku na le yök ka mit puɔ̈u apɛi, miɛt puɔ̈u wär miɛt puɔ̈u wäär tɔ̈ amɛ̈l kɔ̈k thïn. ");
INSERT INTO dikNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Këlä aya, acïï Wuurdun tɔ̈ nhial nhiar, bï mɛnh tök kam ee mïth thiikä määr. ");
INSERT INTO dikNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Na loi wämuuth awuɔ̈c tënë yï, ke yï la tënë ye ku lɛ̈k kë cï wuɔ̈ɔ̈c tɛ̈dun wepɛ̈c. Na piŋ wɛ̈tdu, ke wek aacï dɔ̈ɔ̈r. ");
INSERT INTO dikNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Na cïï wɛ̈tdu piŋ, ke yï cɔl raan tök ayï kɔc karou ku dhuɔ̈kkë tënë ye, ‘Rin bï awuɔ̈c cï looi tënë yï ŋic kɔc karou ayï diäk.’ ");
INSERT INTO dikNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Na ŋot kuec bï wɛ̈tden cïï piŋ, ke lɛ̈k akut, ku na kueec bï wɛ̈t akut cïï piŋ aya, ke päl bï ciɛ̈t raan thäi ku raan ajuër kut, kɔc kuc wɛ̈t Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ku wek aa lɛ̈k kënë, awuɔ̈c cäk bï päl piny pinynhom, acïï bï päl piny nhial, ku awuɔ̈c bäk päl piny ë tɛ̈n abï päl piny nhial. ");
INSERT INTO dikNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Ku abɛn lɛ̈k we, na mät kɔc karou kamkun pinynhom ë tɛ̈n, ku thiëckë kë wïckë ka gɛ̈m Wä tɔ̈ nhial ke. ");
INSERT INTO dikNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Rin tɛ̈ ye kɔc karou ayï diäk kenhïïm mat ë wɛ̈tdiɛ̈ ke ɣɛn abï rëër kamken.” ");
INSERT INTO dikNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Nawën ke Pïtɛr bɔ̈ tënë Jethu ku thiëëc, “Bɛ̈ny, ya arak dë lëu bï ɣɛn wɛ̈t päl piny tënë wämääth cä awuɔ̈c looi tënë ɣa? Ye arak dhorou?” ");
INSERT INTO dikNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Go Jethu bɛ̈ɛ̈r, “Alɛ̈k yï, aca arak dhorou, ee thiärdhorou arak dhorou, ");
INSERT INTO dikNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","rin bääny Nhialic acït bɛ̈nyŋaknhom wïc ye bï käkke kuɛ̈ɛ̈n nyïn kek aluakke. ");
INSERT INTO dikNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kaam wën kuëën kek käŋ nyïn, ka aluaŋ tök cï wëëu juëc apɛidït muɔ̈r bïï tënë ye. ");
INSERT INTO dikNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ku yen ë cïn wëëu cool yen wëëu cï muɔ̈r, go bänyde lueel bï ɣaac wei kek tiɛŋde ku miɛ̈thke ku käkke ëbën bï käny cool. ");
INSERT INTO dikNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Nawën piŋ ë wɛ̈t kënë ke läŋ bänyde apɛi ku lueel ëlä, ‘Päl ɣa kaam thin koor, ku ɣɛn abï käkkä cool bɛ̈ny.’ ");
INSERT INTO dikNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Go bɛ̈nyŋaknhom tɛ̈ mɛɛm yen thïn tïŋ, ku pɛ̈l känyde tënë ye ku cɔl ajiël. ");
INSERT INTO dikNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Kaam wën le aluaŋ kënë aɣeer, ke räm kek aluaŋ dɛ̈t rëër kek baai kɔ̈ɔ̈ny wëëu reen lik. Go pac yeth ku yöök bï wɛ̈ɛ̈uke cool nyin yic. ");
INSERT INTO dikNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Go lɔ̈ŋ apɛi ku lueel, ‘Päl ɣa kaam ku ɣɛn abï wɛ̈ɛ̈uku cool!’ ");
INSERT INTO dikNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Go cïï gam, ku cɔl amac ɣet tɛ̈ bï yen wɛ̈ɛ̈uke cool. ");
INSERT INTO dikNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nawën tïŋ aluɛk kɔ̈k kë cï rot looi, ke riääk puɔ̈th apɛi ku lek tënë bänyden ku lëkkë këriëëc ëbën cï rot looi. ");
INSERT INTO dikNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Go bɛ̈nyŋaknhom aluaŋ kënë cɔɔl ku lueel, ‘Yïn acïn puɔ̈u, ɣɛn acï wëëu juëc kääny ke tënë yï päl piny rin cï yïn ɣa lɔ̈ŋ. ");
INSERT INTO dikNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Cïï lëu ba käny päl piny tënë raandun rëër wek, cïmën këwäär ca luɔ̈i yï?’ ");
INSERT INTO dikNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ku wën cï yen puɔ̈u riääk apɛi, ke cɔl amac ɣet tɛ̈ bï yen käny cool ëbën.” ");
INSERT INTO dikNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ku wit Jethu wɛ̈tde ëlä, “Yen ë tɛ̈ bï Wä tɔ̈ nhial luɔ̈i we, tɛ̈ cï wek awuɔ̈c ye päl piny kamkun puɔ̈u ëbën.” ");
INSERT INTO dikNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Wën cï Jethu wɛ̈t wïc bï lueel thöl, go jäl Galilia ku ler Judia ku teem wär Jordan. ");
INSERT INTO dikNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Go kɔc juëc apɛi buɔɔth, goke kony. ");
INSERT INTO dikNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Go Parathï kɔ̈k bɛ̈n tënë ye, ku wïckë bïk deep ë wɛ̈t ku thiëckë ëlä, “Ye lɔ̈ŋda raan puɔ̈l bï tiɛŋde liɔ̈ɔ̈i ë path?” ");
INSERT INTO dikNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Go Jethu bɛ̈ɛ̈r, “Kɛ̈ckë kaŋ kueen athöör yic lɔn wär ciɛk Aciëk kɔc wäthɛɛr, aacï cak moc ku tik. ");
INSERT INTO dikNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ku lueel, ‘Rin ë wɛ̈t kënë yen abï raan wun ku man nyääŋ piny ku le ker kek tiɛŋde, ku keek karou aabï ya many tök.’ ");
INSERT INTO dikNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Këya, aacïï ŋot ke ben aa rou, ee tök. Ku këya, na cï Nhialic ke puɔ̈l bï ya moc ku tik, ka cïn raan päl ŋɛk ë kamken.” ");
INSERT INTO dikNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Go Parathï bɛn thiëëc, “Na ye këya, yeŋö pɛ̈l Mothith ye bï raan athör liɔ̈ɔ̈i gɔ̈t ku pɛ̈l tik?” ");
INSERT INTO dikNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Go Jethu bɛ̈ɛ̈r, “Mothith acï wärkuan dït puɔ̈l bïk diäärken aa liɔ̈ɔ̈i rin aake cie yith ye lac gam. Ku ëcie këya wäthɛɛr ciɛk kɔc. ");
INSERT INTO dikNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ku aba lɛ̈k we ëmën, na ye mony liɔ̈i tiɛŋde, ke këc wïc mony dɛ̈t, ka cï kërac looi.” ");
INSERT INTO dikNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Go kɔcken ye buɔɔth lɛ̈k ye ëlä, “Na ye yen tɛ̈n ye käŋ röt luɔi thïn kam moc ku tik akan, ka ŋuɛ̈ɛ̈n bï raan cïï thiëk.” ");
INSERT INTO dikNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Go dhuɔ̈k ke ku lueel, “Acie raan ëbën yen bï kë ca lueel gam, aa kɔc ye Nhialic kuɔny. ");
INSERT INTO dikNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Raan dɛ̈t aye dhiëëth ke ya aboi, na cɔk thiëëk tɛ̈ le yen dït ka cïï dhiëth, ku kɔc kɔ̈k aaye roc bïk cïï dhiëth tɛ̈ cɔk kek thiëëk. Ku kɔc kɔ̈k aacie thiëëk rin wïc kek ye bïk wɛ̈t Nhialic ɣäth tueŋ. Këya, na ye raan gam ë wɛ̈t kënë, ke gɛm ku piööc.” ");
INSERT INTO dikNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kɔc kɔ̈k aake cï mïth bɛ̈ɛ̈i tënë Jethu bï ke bɛ̈n dɔɔc, go kɔc Jethu buɔɔth kɔc läät. ");
INSERT INTO dikNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Go Jethu lueel tënë ke, “Calkë mïth aabɔ̈ tënë ɣa, duɔ̈kkë ke pën. Raan wïc ye bï la pan Nhialic adhil gam cïmën ee mïth thiikä.” ");
INSERT INTO dikNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ku cɔɔl mïth yelɔ̈ɔ̈m ku tɛ̈ɛ̈u yecin kenhïïm, ku dɔɔc ke ku jiël. ");
INSERT INTO dikNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Go mony dɛ̈t kaaŋ nhom ku thiëëc ëlä, “Raan piööc ye këpiath ŋö ba looi ba pïr akölriëëc ëbën yök?” ");
INSERT INTO dikNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Go Jethu bɛ̈ɛ̈r, “Yeŋö ye yïn ɣa thiëëc këpath ba looi? Ee Nhialic rot yen apath. Na wïc ba pïr akölriëëc ëbën yök, ke yï thek lɔ̈ɔ̈ŋke.” ");
INSERT INTO dikNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Go mony kënë Jethu bɛn thiëëc ëlä, “Ye lööŋ nɛn?” Go Jethu bɛ̈ɛ̈r, “Duk raan näk, duk tiŋ raan dɛ̈t kɔr, duk cuëër, duk kuëëŋ wɛ̈t ë lueth. ");
INSERT INTO dikNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Thek wuur ku moor, ku nhiar raan dɛ̈t cïmën nhiɛɛr yïn rot.” ");
INSERT INTO dikNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Go riënythii awën dhuɔ̈k ye ku lueel ëlä, “Lööŋkä aaca muk nhïïm ëbën. Ye kë nɛn ba bɛn looi?” ");
INSERT INTO dikNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Go Jethu bɛ̈ɛ̈r, “Na wïc ba la cök tënë Nhialic, ke yï la ba käkku la ɣaac ëbën, ku gam wëëu tënë kɔc ŋɔ̈ŋ, yïn abï jiɛɛk la yök pan Nhialic, ku bäär buɔth ɣa.” ");
INSERT INTO dikNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nawën piŋ ë wëlkä ke mɛɛn, ku jiël ke cï puɔ̈u dak rin ë la käjuëc apɛi. ");
INSERT INTO dikNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Go Jethu yenhom wɛ̈l kɔcken ye buɔɔth ku lëk ke, “Abï riɛl tënë raan ajak bï la pan Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ku abɛn lɛ̈k we, apuɔl yic bï thɔ̈rɔ̈l bak with cök, tɛ̈në lɔn bï raan ajak la pan Nhialic.” ");
INSERT INTO dikNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nawën piŋ kɔcken ye buɔɔth ë kënë, ke gɛ̈i apɛi ku luelkë, “Na ye këya, ke yeŋa bï la pan Nhialic.” ");
INSERT INTO dikNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Go Jethu ke döt ku bëër, “Acïï raan bï lëu ë rot, bï gam tɛ̈ këc Nhialic ye kony, rin Nhialic ë këriëëc ëbën lëu, acïn kë dhal ye.” ");
INSERT INTO dikNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Go Pïtɛr rot jɔt ku lueel, “Na ɣook, ɣok kɔc cï käkkua ëbën nyääŋ piny ku buɔthku yï, yeŋö bï ya këda?” ");
INSERT INTO dikNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Go Jethu bɛ̈ɛ̈r, “Wek alɛ̈k kënë, tɛ̈ le käŋ röt waar, ke Manh Raan abï nyuc thɔ̈nyde nhom ë diik yic pan Nhialic, ku week wathiäär ku rou, wek aabï nyuc thöc nhïïm aya bäk luŋ kuat Itharel kathiäär ku rou looi. ");
INSERT INTO dikNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ku kuat raan cï paande nyääŋ wei kek paan ë man ku nyiɛ̈rakën, ku wun ku man ku miɛ̈thke ku dum ë riɛnkiɛ̈, abï käjuëc yök arak buɔɔt, ku abï pïr akölriëëc ëbën yök aya. ");
INSERT INTO dikNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ku kɔc juëc tɔ̈ tueŋ ëmën aabï döŋ ciëën, ku kɔc kɔ̈k juëc tɔ̈ ciëën aabï la tueŋ.” ");
INSERT INTO dikNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ku ben Jethu bääny Nhialic thɔ̈ɔ̈ŋ ëlä, “Raan dom ëcï rial bï la wïc kɔc bï duɔmde bɛ̈n tem. ");
INSERT INTO dikNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ku ciëk ariöp bï ya gäm ke akäl tök, ku tooc ke dom. ");
INSERT INTO dikNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Nawën tɛ̈cït lunyluny ë ɣɔ̈k, ke la tɛ̈ ye kɔc ɣɔɔc thïn, go kɔc kɔ̈k tïŋ thïn ke kääc ke cïn kë loikë, ");
INSERT INTO dikNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","go lɛ̈k ke ëlä, ‘Lak dom yic aya bäk la tem, ku wek aaba yiëk ariöp thöŋ ke luɔidun.’ ");
INSERT INTO dikNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Gokë la. Nawën akɔ̈l ciɛl yic, ku tääŋ akɔ̈l aya, ke la aɣeer ku le bɛ̈n ke kɔc kɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Naɣɔn thëëi ke la aɣeer ku yök kɔc kɔ̈k ke kääc ë path go lɛ̈k ke, ‘Yeŋö rëër wek tɛ̈wën aköl ke cïn kë luɔikë?’ ");
INSERT INTO dikNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Gokë lɛ̈k ye ëlä, ‘Acïn raan cï ɣo cɔɔl buk la luui.’ Go lɛ̈k ke bïk la luui aya. ");
INSERT INTO dikNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Naɣɔn thëëi ke wun dom cɔl raanden kɔc dɔ̈m ku lueel, ‘Cɔl kɔc luɔi, ba ke dɔ̈m wɛ̈ɛ̈uken, ku jɔk kɔc ë ke bɔ̈ ciëën, bï jäl la thök kɔc wën anhiäk jɔk luɔi ë rial.’ ");
INSERT INTO dikNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Go kɔc ke bɔ̈ luɔi yic ciëën bɛ̈n ku gɛ̈m ke wɛ̈ɛ̈uken. ");
INSERT INTO dikNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nawën la kɔc ke jɔk luɔi ë rial bɛ̈n bï ke bɛ̈n riɔp, ke takkë lɔn bï ke gäm wëëu juëc, ku keek aacï bɛ̈n riɔp wëëu cït wëëu cï gäm kɔc ke lök bɛ̈n luɔi yic ciëën. ");
INSERT INTO dikNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","“Gokë wëëu dɔm ke dak puɔ̈th, ku jiëëmkë wun dom guɔ̈p ëlä, ");
INSERT INTO dikNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Kɔc ke lök bɛ̈n ciëën, cïn luɔi dïït cïk looi, aaca thɔ̈ɔ̈ŋ nhïïm kek ɣo, ɣok kɔc cï luui akɔ̈l yic tɛ̈wën anhiäk agut tɛ̈ col piny cït ëmën!’ ");
INSERT INTO dikNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Go wɛ̈t raan tök bɛ̈ɛ̈r ëlä, ‘Mäthdiɛ̈, yïn acä jör, ciɛ̈t ɣo cï tɛ̈ bï ɣɛn yï riap thïn akäl tök cäk. ");
INSERT INTO dikNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Dɔm ariɔ̈pdu ku jälë. Aca tak ba raan lök bɛ̈n ciëën gäm ariöp cït ariɔ̈pdu. ");
INSERT INTO dikNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Cä la yic ba wɛ̈ɛ̈ukiɛ̈ gam tɛ̈cït tɛ̈ wiëc ye? Yeŋö ye tiɛɛl yï dɔm tɛ̈ muɔɔc ɣɛn kɔc?’ ” ");
INSERT INTO dikNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ku wit Jethu wɛ̈tde ëlä, “Këya, kɔc tɔ̈ ciëën aabï tɔ̈ tueŋ ku kɔc tɔ̈ tueŋ aabï tɔ̈ ciëën.” ");
INSERT INTO dikNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Naɣɔn aköl dɛ̈t ke Jethu cath kek kɔcken ye buɔɔth ke la Jeruthalem, ke cɔɔl ke tɛ̈den ë röt ku lëk ke, ");
INSERT INTO dikNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ëmën ɣok aala Jeruthalem, ku Manh Raan abï la dɔm ku ɣɛ̈th kɔc käk Nhialic nhïïm, ku kɔc piööc ë lööŋ. Ku abïk tɛ̈m thou, ");
INSERT INTO dikNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ku thönkë bäny kɔc cie kɔc Itharel bïk läät ku thatkë ku piɛ̈ɛ̈tkë tim cï rïïu kɔ̈u. Ku na ye nïn kadiäk cök ka bï pïr ku jöt bei ë raŋ yic.” ");
INSERT INTO dikNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nawën ke man wɛ̈ɛ̈t Dhubedï bɔ̈ tënë Jethu kek wätke, ku gut yenhiaal piny ku thiëëc bï luɔ̈i kë wïc. ");
INSERT INTO dikNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Go Jethu thiëëc, “Yeŋö wïc?” Go bɛ̈ɛ̈r ëlä, “Tɛ̈ nyuuc yïn thɔ̈nydu nhom bääny Nhialic yic aköldä, ke yï tɔŋ yïpuɔ̈u lɔn bï yïn wɛ̈tkiɛ̈n kë karou cɔl aa nyuc yïlɔ̈ɔ̈m, raan tök köŋ cuëc ku raan dɛ̈t köŋ ë cam.” ");
INSERT INTO dikNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Go Jethu dhuɔ̈k ke ëlä, “Wek aakuc kë thiëckë, ɣɛn abï baŋ apɛi ë nïnkä ku ɣɛn abï nɔ̈k. Lɛ̈ukë bäk gum cïmëndiɛ̈?” Gokë bɛ̈ɛ̈r, “Alëuku.” ");
INSERT INTO dikNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Go Jethu lɛ̈k ke, “Na cɔkkë we nɔ̈k ayic ka lɛ̈ukë bäk gum, ku acie ɣɛn la riɛl ba raan bï nyuc köŋdiɛ̈n cuëc ku köŋdiɛ̈n cam kuany. Thöckä aa käk kɔc cï Wä guiër ke.” ");
INSERT INTO dikNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nawën le atuuc kɔ̈k kathiäär piŋ, ke riääk puɔ̈th tënë wɛ̈ɛ̈t Dhubedï. ");
INSERT INTO dikNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Go Jethu ke cɔɔl ku lëk ke, “Aŋiɛckë lɔn kɔc cï gam bïk aa bäny kɔc cie kɔc Itharel aala riɛl kɔc nhïïm, ku acïï path bäk ciɛ̈t ke. ");
INSERT INTO dikNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ku kënë acïï rot bï looi kamkun. Raan wïc ye bï ya raandït kamkun, adhil rot dhuɔ̈k piny bï ya luui rin kɔc kɔ̈k, ");
INSERT INTO dikNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ku na ye raan wïc ye bï ya bɛ̈ny wenhïïm, ka dhil ya aluaŋdun. ");
INSERT INTO dikNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Cïmën Manh Raan aya akëc bɛ̈n bï kɔc bɛ̈n loony, acï bɛ̈n bï kɔc bɛ̈n kony, ku gɛm wɛ̈ike bï kɔc juëc waar thou yic.” ");
INSERT INTO dikNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Tɛ̈wën jiël Jethu Jeriko kek kɔcken ye buɔɔth, ke buɔɔth kɔc juëc apɛi. ");
INSERT INTO dikNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ku kɔc cï cɔr karou aake rɛ̈ɛ̈r ë dhël këc. Nawën piŋkë lɔn cï Jethu ɣëët, ke cöt röldït, “Bɛ̈ny, Wën Debit, kony ɣo!” ");
INSERT INTO dikNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Go kɔc kɔ̈k ke rɛ̈l ku yöökkë ke bïk biɛt. Gokë ŋot ke kiu apɛi, “Wën Debit! Kony ɣo.” ");
INSERT INTO dikNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Go Jethu kɔ̈ɔ̈c ku cɔɔl ke, ku thiëëc ke, “Yeŋö wiɛ̈ckë ba looi tënë we?” ");
INSERT INTO dikNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Gokë lɛ̈k ye, “Bɛ̈ny awïcku buk bɛn daai.” ");
INSERT INTO dikNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Go Jethu gam, ku gɔɔt kenyïn, gokë daai nyin yic ku buɔthkë. ");
INSERT INTO dikNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Tɛ̈wën cï kek thiɔ̈k kek Jeruthalem, ke bɔ̈ Bethpeec tɛ̈thiääk kek gɔn Olip, ke Jethu ëcï kɔcken ye buɔɔth karou tuɔɔc tueŋ, ");
INSERT INTO dikNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ku lëk ke, “Lak bɛ̈ɛ̈i tɔ̈ tueŋ yiic, ku wek aabä akaja yök ke mac ku manhde yelɔ̈ɔ̈m. Luɔnykë ke ku bɛ̈ɛ̈ikë ke tënë ɣa. ");
INSERT INTO dikNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Na le raan thiëc we ke luɛlkë, keek aa wïc Bɛ̈ny ku aabï dhuk ëmën.” ");
INSERT INTO dikNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Kënë acï rot looi këya rin bï wɛ̈t cï lueel ëlä thɛɛr raan käk Nhialic tïŋ yenhom tiɛɛŋ, ");
INSERT INTO dikNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Lëk kɔc Itharel, ëmën bɛ̈nyŋaknhom dun abɔ̈ tënë week! Alir puɔ̈u ee cath akaja, manh akaja.” ");
INSERT INTO dikNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Go kɔc Jethu buɔɔth la ku loikë cïmën cï Jethu ye lɛ̈k ke, ");
INSERT INTO dikNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ku bïïkë akaja ke manhde ku kumkë kekɔ̈th aläthken, ku nyuc Jethu manh akaja kɔ̈u. ");
INSERT INTO dikNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Kɔc juëc aacä aläthken thiɛth dhël yic, ku kɔc kɔ̈k aacä ayɔ̈r tiim dhoŋ ku thiethkë ke dhël yic aya. ");
INSERT INTO dikNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Go kɔc ke tɔ̈ tueŋ yenhom ku kɔc ke buɔth ye, yai looi ku yekë wak ëlä, “Lecku wën Debit! Bɛ̈ny dɔc raan bɔ̈ riɛnku lecku Nhialic Madhɔl!” ");
INSERT INTO dikNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nawën ɣeet geeu Jeruthalem, ke kɔc gɛ̈i apɛi ku yekë thiëc ëlä, “Yeŋa kënë?” ");
INSERT INTO dikNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ke bëër kɔc ŋic ye ku luelkë, “Yen ë raan käk Nhialic tïŋ cɔl Jethu pan Nadharet, wun Galilia.” ");
INSERT INTO dikNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Nawën lek ɣet Jeruthalem ke Jethu la luaŋ Nhialic, ku cop kɔc käŋ ɣaac ku kɔc ɣööc aɣeer kal luaŋ Nhialic yic. Ku wel agen kɔc wëëu waar yiic piny, ku thöc kɔc ɣɔɔc wei ë kuɔ̈r. ");
INSERT INTO dikNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ku lëk ke, “Acï gɔ̈t ëlä athör thɛɛr wël Nhialic yiic, ‘Kal luaŋdiɛ̈ acï looi bï ya tɛ̈n ye kɔc wuɔ̈t ëbën röök thïn,’ ku yen acäk wel bï ya tɛ̈n cuɛ̈r.” ");
INSERT INTO dikNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Kɔc cï cɔr ku kɔc cï duany aake cï bɛ̈n tënë ye kal yic luaŋ Nhialic, goke kony. ");
INSERT INTO dikNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Kɔc dït käk Nhialic ku kɔc gɛ̈t lööŋ aake cï puɔ̈th dak tɛ̈wën tïŋ kek käpuɔth cï Jethu looi, ku wën ye mïth ket kal yic luaŋ Nhialic ëlä, “Lecku Wën Debit.” ");
INSERT INTO dikNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ku luelkë tënë Jethu, “Ye kë lueel ë mïthkä piŋ?” Go bɛ̈ɛ̈r, “Aya piŋ. Ku kɛ̈ckë kënë kaŋ kueen, ‘Yïn acï mïth agut mïth thii kor piɔ̈ɔ̈c bïk lɛc la cök aa lueel.’ ” ");
INSERT INTO dikNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Kaam wën cï Jethu wëlkä lueel, ke jiël geeu ku ler Bethanï tɛ̈ cï yen bën anin thïn. ");
INSERT INTO dikNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Naɣɔn nhiäk, tɛ̈wën dhuk kek geeu, Jethu ë nɛ̈k cɔk. ");
INSERT INTO dikNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Nawën tïŋ tim cït ŋaap dhël yɔu, go la cɔl bï yök ke cï luɔk, go yök ke ayɔ̈r kepɛ̈c. Go Jethu lueel, “Yïn acïï mïth kɔŋ bɛn tïŋ athɛɛr!” Ku nyin yic tɛ̈wën ke tim riau. ");
INSERT INTO dikNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tɛ̈wën tïŋ kɔcken ye buɔɔth ë kënë, ke gɛ̈i apɛi, ku thiëckë röt, “Yeŋö cï tim kënë guɔ riau?” ");
INSERT INTO dikNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Go Jethu bɛ̈ɛ̈r, “Na gamkë ke cïn diu, ka cie kë ca looi tënë ë tim kënë yen luɔikë ë rot, na cɔk a gɔn kënë yen yɔ̈ɔ̈kkë ëlä, ‘Jɔt rot ku cuat rot wïïr,’ ka loi rot. ");
INSERT INTO dikNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ku na lak gam, ke këriëëc ëbën yakë ke thiëëc tɛ̈ röök wek, aa yɔ̈kkë.” ");
INSERT INTO dikNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Go Jethu bɛn dhuk kal yic luaŋ Nhialic, ku tɛ̈wën piööc yen, ke bänydït käk Nhialic ku kɔc baai bɔ̈ tënë ye ku thiëckë ëlä, “Ee yïn, ye riɛl ŋö tɔ̈ yïguɔ̈p ye yïn luui këlä? Ku yeŋa yïk yï ë riɛl kënë?” ");
INSERT INTO dikNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Go Jethu bɛ̈ɛ̈r, “Wek aba thiëëc wɛ̈t tök aya, na bɛ̈ɛ̈rkë apath, ke wek aba lɛ̈k raan cä gäm riɛl ye ɣɛn käkkä looi. ");
INSERT INTO dikNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Lɛ̈kkë ɣa, Joon yök riɛl yen kɔc gäm lɔ̈kwëi tɛ̈nɛn, ye tënë Nhialic aye riɛlde ë rot?” Gokë guëëk yic kamken ku luelkë, “Na luelku, ke yök tënë Nhialic, ka thiëc, ‘Aye ŋö këc wek wɛ̈tde gam?’ ");
INSERT INTO dikNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ku na luelku, ‘Ke riɛlde ë rot,’ ke ɣok aa jɔ̈ny ke rin cï raan ëbën ye gam.” ");
INSERT INTO dikNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Gokë dhuɔ̈k Jethu, “Akucku.” Go Jethu lɛ̈k ke, “Na ye këya, ke wek aacä lëk riɛl ye ɣɛn käkkä looi.” ");
INSERT INTO dikNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ku ben Jethu ke thiëëc, “Yeŋö yakë tak wɛ̈t kënë yic? Monytui ë la dhäk karou. Go la tënë wëndït ku lëk ye, ‘Manhdiɛ̈ lɔr lui dom yic ya aköl.’ ");
INSERT INTO dikNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Go bɛ̈ɛ̈r, ‘Ɣɛn acïï la,’ nawën ke ben yenhom waar ku ler. ");
INSERT INTO dikNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Go bɛn la tënë wënden koor ku lëk wɛ̈t awën cï kaŋ lɛ̈k wëndït. Go gam ku cïï la. ");
INSERT INTO dikNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Yeŋa kamken karou cï kë wïc wun looi?” Gokë bɛ̈ɛ̈r, “Ee wëndït.” Go Jethu lɛ̈k ke, “Kɔc ajuër kut ku adëjök ë tɔ̈c kek kuat moc ë path, aa kek aabï röt kaŋ mat ë bääny Nhialic yic tënë we. ");
INSERT INTO dikNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Rin Joon raan wäär kɔc muɔɔc nhïïm ëcï bɛ̈n tënë we bï we nyuɔ̈th dhël ë yic, ku wek aa këc wɛ̈tde gam. Nawën ke ye kɔc ajuër kut ku adëjök kek gam ye. Ku na cɔk awën cï wek käkkä tïŋ ke loi röt, ke wek aa këc wepuɔ̈th waar ku pälkë luɔi kärɛc ku gamkë wɛ̈tde.” ");
INSERT INTO dikNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ku ben Jethu jam waal ku lueel tënë kɔc man ye ëlä, “Monytui ëcï dom looi ku cum yic tiim luɔk ku rɔk. Ku wec tɛ̈ ye mïth tiim guɔ̈r thïn bïk ya miök, ku looi kät. Ku jɔl dom riɔ̈p yic kɔc kɔ̈k, ku le keny wun dɛ̈t. ");
INSERT INTO dikNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Nawën le tɛ̈ cï tiim luɔk thɔ̈ɔ̈ŋ, ke tooc aluɔɔnyke tënë ke bïk la gäm abäkke. ");
INSERT INTO dikNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Go kɔc awën cï riɔ̈p dom yic aloony dɔm, ku thatkë aluɔny tök, ku näkkë alony dɛ̈t ku biöökkë alony ye kek diäk aleel. ");
INSERT INTO dikNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Go aloony juëc tënë aloony tueŋ bɛn tooc, ku ŋot ke looikë ke tɛ̈wäär. ");
INSERT INTO dikNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Nawën ciëën ke wun dom jɔl wënde tooc, ku tɛk lɔn bï kek ye theek. ");
INSERT INTO dikNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Go kɔc awën cï riɔ̈p dom yic lueel kamken wën tïŋ kek ye, ‘Kënë ee manh raan la dom, bï käŋ lɔ̈k thɔn aköldä. Bäk näkku ku käkke aabï dɔ̈ŋ ke ɣo.’ ");
INSERT INTO dikNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Gokë dɔm ku thelkë aɣeer dom yic ku näkkë.” ");
INSERT INTO dikNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ku jɔl Jethu ke thiëëc, “Na bɔ̈ raan la dom ke loi ŋö tënë ke?” ");
INSERT INTO dikNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Gokë bɛ̈ɛ̈r, “Abï kɔckä nɔ̈k, ku riɔp dom yic wei tënë kɔc bï ye ayiëk abäkke tɛ̈ cï käŋ luɔk.” ");
INSERT INTO dikNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ku lëk Jethu ke, “Kɛ̈ckë wɛ̈t cï gɔ̈t athör thɛɛr wël Nhialic yic ëlä, kaŋ kueen? ‘Mën wäär yen cï atëët kuec yen acï bɛ̈n a mën ril apɛi, kënë ë ye luɔi Bɛ̈ny, ayeku tïŋ ke path ku dhëëŋ ɣonyïn!’ ” ");
INSERT INTO dikNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ku la Jethu tueŋ ku lueel, “Këya alɛ̈k we, bääny Nhialic abï nyaai tënë we ku gɛ̈m kɔc wuɔ̈t kɔ̈k bï wɛ̈tdiɛ̈ piŋ ku loikë. ");
INSERT INTO dikNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ku raan bï löny alel kënë nhom, ka duɔɔny bï ruɔ̈th, ku raan bï alel kënë lööny yenhom ka niɔɔn yic.” ");
INSERT INTO dikNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nawën piŋ kɔcdït käk Nhialic ku kɔc gɛ̈t lööŋ ë jam kënë, ke ŋickë lɔn jiɛɛm Jethu riɛnken, ");
INSERT INTO dikNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ku na cɔk alɔn wïc kek ye bïk dɔm, ka ke cï riɔ̈ɔ̈c kɔc juëc tɔ̈ thïn ë Jethu tïŋ ke ye raan käk Nhialic tïŋ. ");
INSERT INTO dikNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Go Jethu bɛn jam tënë ke ë waal ku lueel. ");
INSERT INTO dikNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Bääny Nhialic ë duɛ̈r thöŋ kek yan thiëëk cï bɛ̈nyŋaknhom looi tënë wënde. ");
INSERT INTO dikNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ku tooc aluɔɔnyke bï kɔc cï cɔɔl la lɛ̈k bïk bɛ̈n yai yic. Gokë kuec ku cïk bɔ̈ yɛɛi. ");
INSERT INTO dikNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Go aloony juëc bɛn tooc ku thɔnke ëlä, ‘Lak, lëkkë kɔc cï cɔɔl lɔn mïïth aacï thök ë guiër, muɔɔr ku nyök cuai aacï nɔ̈k, këriëëc ëbën acï guiir. Bäk yai yic!’ ");
INSERT INTO dikNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ku keek aake liu puɔ̈th thïn, ku puɔ̈kkë bï ŋɛk ala duɔmde, ku la raandä luɔide yic. ");
INSERT INTO dikNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ku dɔm kɔc kɔ̈k aloony bɛ̈nyŋaknhom, ku baŋkë ke ku näkkë ke. ");
INSERT INTO dikNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Go bɛ̈nyŋaknhom puɔ̈u riääk apɛi, ku tooc apuruɔ̈ɔ̈kke ku lek kɔc awën näk aluɔɔnyke nɔ̈k, ku cuänykë gɛnden. ");
INSERT INTO dikNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ku cɔɔl aluɔɔnyke ku lëk ke, ‘Yai acï thök ë guiër, ku kɔc ke cï cɔɔl aa këc aa kɔc path, aacï kuec ë bɛ̈n. ");
INSERT INTO dikNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Lak geeu ku calkë kuat kɔc bäk yök dhɔ̈l yiic bïk bɛ̈n yai yic.’ ");
INSERT INTO dikNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Go aloony la dhɔ̈l yiic ku cɔlkë kuat raan cïk yök ëbën, abï yai thiäŋ apɛi. ");
INSERT INTO dikNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Nawën bɔ̈ bɛ̈nyŋaknhom bï thän cï guëër yɛɛi bɛ̈n tïŋ, ke tïŋ raan tök ke këc alɛ̈th yai ruɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Go bɛ̈nyŋaknhom lueel, ‘Mäthdiɛ̈, yï bɔ̈ tɛ̈n këdë ke yï cïï alɛ̈th yai ceŋ?’ Go mony awën biɛt ku cïï wɛ̈t bëër. ");
INSERT INTO dikNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Go bɛ̈nyŋaknhom lɛ̈k aluɔɔnyke, ‘Dɛrkë cin ku cök ku cuatkë muɔ̈ɔ̈th yic aɣeer, tɛ̈ bï yen dhiau thïn ke ŋɛny yelec.’ ” ");
INSERT INTO dikNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ku wit Jethu wɛ̈tde ëlä, “Rin kɔc juëc aaye cɔɔl, ku aa kɔc lik kek aaye lɔc.” ");
INSERT INTO dikNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Go Parathï la tɛ̈den ë röt bïk tɛ̈ bï kek Jethu dam thïn, wɛ̈tden bï lueel, la mat. ");
INSERT INTO dikNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ku toockë kɔcken abɛ̈k ke buɔɔth tënë ye, ku kɔc Antipäth Ɣërot bïk la wëëŋ bï wɛ̈t rac luɛɛl kegup bï ye dɔm. Ku bïk ku luelkë ëlä, “Raan piööc, aŋicku yïn ë raan la cök jam ë yith. Yïn ë kɔc piɔ̈ɔ̈c bïk käk wïc Nhialic looi dhël la cök, ke yï cïï diɛɛr käk ye kɔc kɔ̈k tak. Ku yïn acie diɛ̈tden ye kuɛ̈ɛ̈c nhom. ");
INSERT INTO dikNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Lɛ̈k ɣo na ye täktäkdu, buk ajuër aa gam ɣok kɔc Itharel tënë Cithɛ̈r Bɛ̈nyŋaknhom, tɛ̈dë ke cuk bï ya gäm ye?” ");
INSERT INTO dikNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ku Jethu ëcï ruɛ̈ɛ̈nyden ŋic, ku bëër, “Yeŋö wïc wek ye bäk ɣa deep wɛ̈t? ");
INSERT INTO dikNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Calkë ɣa atïŋ wënh yakë tääu piny ajuër!” Gokë yiëk wëëth. ");
INSERT INTO dikNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Goke thiëëc, “Ye nhom ŋa, ku ye rin ŋa käkkä cï giɛɛt wëëth kɔ̈u?” ");
INSERT INTO dikNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Gokë bɛ̈ɛ̈r, “Aa käk Cithɛ̈r Bɛ̈nyŋaknhom.” Go Jethu lɛ̈k ke, “Na ŋiɛckë këya, gämkë Cithɛ̈r Bɛ̈nyŋaknhom këde, ku gämkë Nhialic këde.” ");
INSERT INTO dikNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Gokë gäi, tɛ̈ cï Jethu wɛ̈t bɛ̈ɛ̈r thïn, ku nyiëëŋkë piny ku jiëlkë. ");
INSERT INTO dikNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Aköl töŋ awën ke kɔc kɔ̈k akut Thaduthï, akut cïï ye ye gam lɔn bï Nhialic kɔc cï thou bɛn cɔl apïr, bɔ̈ tënë Jethu ku thiëckë ëlä, ");
INSERT INTO dikNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Raan piööc, acï Mothith lɛ̈k ɣo ëlä, Na thou raan ku nyiëëŋ tik piny ke cïn mïth, ke wämënh koor ala ɣöt tik bï mïth dhiëëth ɣön mɛ̈nhë. ");
INSERT INTO dikNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Na thööŋku lɔn tɔ̈ mïth tik thïn kadhorou, ku thiëk wëndït ku thou ke cïn mïth, ku dɔ̈ŋ tiɛŋde ke wëmënh buɔth ye, ");
INSERT INTO dikNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ku thou aya ke cïn mïth cï dhiëëth. Ku looi rot këya tënë raan ye kek diäk, agut wämënh kun ye kek dhorou. ");
INSERT INTO dikNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Nawën ke tik thou aya.” ");
INSERT INTO dikNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ku lek tueŋ ku thiëckë, “Tɛ̈ le kɔc cï thou röt jɔt aköldä, bï ya tiŋ ŋa, rin cï yen rëër ke ke ëbën kadhorou?” ");
INSERT INTO dikNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Go Jethu bɛ̈ɛ̈r, “Wek aa kɔc ril nhïïm cïn kë ŋiɛckë, rin cïï wek athör thɛɛr wël Nhialic cï gɔ̈t ye gam. Ku acäk ye gam aya lɔn bï Nhialic kë ye lueel ke bï looi, lëu bï looi. ");
INSERT INTO dikNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Rin tɛ̈ le kɔc cï thou röt jɔt, aacïï bï thiëëk ku aacïï bï thiaak, aabï rëër kecït atuuc nhial. ");
INSERT INTO dikNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ku na ye rin wɛ̈t bï kɔc cï thou röt jɔt, ke we këc wɛ̈t cï Nhialic lɛ̈k we thɛɛr kueen? Acï lueel, ");
INSERT INTO dikNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ɣɛn ë Nhialic Abaram ku Ithäk ku Jakop.’ Kɔc cï thou ke ŋic Nhialic, aa pïr alanden. Yeen ë Nhialic kɔc pïr, ku kɔc cï thou aya.” ");
INSERT INTO dikNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nawën piŋ thän tɔ̈ thïn wɛ̈t kënë, ke gɛ̈i ë piɔ̈ɔ̈cde. ");
INSERT INTO dikNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Nawën piŋ Parathï lɔn cï Jethu Thaduthï thöl nhïïm, ke mat kenhïïm bïk Jethu thiëëc aya, ");
INSERT INTO dikNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ku jɔl raan tök kamken, ");
INSERT INTO dikNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","raan piööc lööŋ, Jethu thiëëc, “Ye löŋ nɛn yen ril kam ë lööŋ?” ");
INSERT INTO dikNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Go Jethu bɛ̈ɛ̈r, “Yïn adhil Bänydu Nhialic nhiaar piändu ëbën, ku wɛ̈iku ëbën, ku nhiamdu ëbën.” ");
INSERT INTO dikNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Kënë, yen ë löŋ ril tueŋ. ");
INSERT INTO dikNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Löŋ dɛ̈t ril ye kek rou thöŋ kek ë löŋ kënë akïn, yïn adhil raan dɛ̈t nhiaar cïmën nhiɛɛr yïn rot. ");
INSERT INTO dikNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Lööŋkä karou kek aa ye lööŋ Mothith ëbën, ku lööŋ ye kɔc käk Nhialic tïŋ piɔ̈ɔ̈c, kɛ̈r bei thïn. ");
INSERT INTO dikNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Kaam wën cï Parathï kenhïïm kut Jethu lɔ̈ɔ̈m ke thiëëc ke wɛ̈t kënë, ");
INSERT INTO dikNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Yakë tak Raan cï lɔc ku dɔc yeŋa? Ye wën ŋa?” Gokë lɛ̈k ye, “Ee wën Debit?” ");
INSERT INTO dikNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Go dhuɔ̈k ke ku lueel, “Na ye këya, yeŋö ye Wëi Nhialic Debit yɔ̈ɔ̈k bï cɔɔl Bänydiɛ̈. Rin ëcï Debit lueel ëlä, ");
INSERT INTO dikNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Acï Nhialic lueel tënë Bänydiɛ̈, “Nyuc ë tɛ̈n köŋdiɛ̈n cuëc, ɣet tɛ̈ bï ɣɛn kɔc atɛrdu dhuɔ̈k ciëën yïcök.” ’ ");
INSERT INTO dikNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Na ye Debit cɔɔl, ‘Bänydiɛ̈,’ Ke lëu bï ya wënde këdë?” ");
INSERT INTO dikNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Go ciɛ̈n mën raan töŋ bëër wɛ̈tde, ku wën akölë ɣet tueŋ acïn raan töŋ cïï yethok bɛn kuek bï thiëëc. ");
INSERT INTO dikNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ku jɔl Jethu lueel tënë kɔc juëc awën ku kɔcken ye buɔɔth. ");
INSERT INTO dikNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Kɔc piööc lööŋ ku Parathï kek aatɔ̈ nyin Mothith. ");
INSERT INTO dikNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Këya, aa dhiɛlkë ke theek ku luɔikë kë yekë lɛ̈k we, ku piɛŋkë kë yekë lɛ̈k we, ku duɔ̈kkë käkken yekë ke looi ye kiɛ̈ɛ̈t, rin aacie käk yekë lɛ̈k kɔc kek yekë ke looi. ");
INSERT INTO dikNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Aa kɔc piɔ̈ɔ̈c käril yiic bï ke looi, ku aa cie kɔc ë kony bïk ke looi. ");
INSERT INTO dikNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Këriëëc ëbën yekë ke looi, ayekë ke looi rin bï kek kɔc wëŋ. Aa cath ke muk athör thɛɛr wël Nhialic. Ku rukkë alɛ̈th path, ku mukkë athör kecin bïk nyuɔɔth lɔn ye kek kɔc path thek löŋ Mothith. ");
INSERT INTO dikNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ayekë nhiaar bïk nyuc tueŋ thöc kɔcdït tënë amat, ku ɣɔ̈n path aköl yai. ");
INSERT INTO dikNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ayekë nhiaar bï ke aa muɔ̈ɔ̈th athɛ̈ɛ̈k ɣɔ̈n ɣɔɔc yiic, ku yeke cɔɔl, ‘Kɔc piööc.’ ");
INSERT INTO dikNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Duɔ̈kkë röt cɔl aye cɔɔl, ‘Kɔc piööc,’ Rin wek aa ŋɛk ke wämënhë, ku wek aa la raan piööc tök. ");
INSERT INTO dikNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ku acïn raan dhiɛlkë cɔɔl pinynhom tɛ̈n, ‘Wä,’ Rin ë Nhialic tɔ̈ nhial yen ee Wuurdun yetök. ");
INSERT INTO dikNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ku duɔ̈kkë röt cɔl aye cɔɔl, ‘Kɔc piööc,’ Rin wek aa la raan piööc tök, ‘Raan cï lɔc ku dɔc.’ ");
INSERT INTO dikNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Raandït apɛi kamkun adhil rot dhuɔ̈k piny bï luui riɛnkun. ");
INSERT INTO dikNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kuat raan rot ɣäth tueŋ ë rot abï dhuɔ̈k ciëën, ku raan lir puɔ̈u rot tɔ̈ɔ̈u ciëën, abï ɣäth tueŋ. ");
INSERT INTO dikNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Kɔc piööc lööŋ ku wek Parathï, Awëëŋkui! Ee kërac apɛi yen ayakë looi, rin ye wek kɔc piɔ̈ɔ̈c dhël cïï kek bï mɛt bääny Nhialic yic. Rin wek aacïï bï mɛt thïn aya. Na cɔk kɔc kɔ̈k wïc bïk mɛt thïn, ka yakë ke wel nhïïm ë piööcdun cïï la cök! ");
INSERT INTO dikNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Kɔc piööc lööŋ ku wek Parathï, Awëëŋkui! Wek aa cath we rɔ̈ɔ̈k apɛi dhɔ̈l yiic bäk kɔc wëŋ lɔn ye wek kɔc path, ku wek aa bɛ̈ɛ̈i lër tuɔ̈ɔ̈r nyïn bïk aa käkkun. Wek aabï tɛ̈m awuɔ̈cdït tet apɛi rin kärɛc yakë looikä! ");
INSERT INTO dikNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Kɔc piööc ku wek Parathï, Awëëŋkui! Wek aa piny kuany yic rin bï la raan töŋ yɔ̈kkë bï piɔ̈ɔ̈cdun gam. Na yɔ̈kkë, ke tɛ̈ ye wek ye piɔ̈ɔ̈c thïn, ee ye cɔl aye raan pan mac, abï we duɛ̈r waan thook! ");
INSERT INTO dikNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Awëëŋkui, wek kɔc ë kɔc kɔ̈k wat nhïïm ke we ye cöör aya, ku luɛlkë, raan mël kuëëŋ rin luaŋ Nhialic, ke rot mac wɛ̈tde. ");
INSERT INTO dikNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Wek aa muɔ̈ɔ̈l ku cöör! Yeŋö dït? Ye mïläŋ thith aye luak? ");
INSERT INTO dikNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ku bɛnkë lueel ëlä, raan mël kuëëŋ rin yïk ka cïn wɛ̈tde yic, ku na kuëëŋ mël rin ajuër cï tääu yenhom, ke rot mac wɛ̈tde. ");
INSERT INTO dikNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Wek kɔc cï cɔr wepuɔ̈th! Yeŋö dït? Ye ajuër cï tääu yïk nhom aye yïk guɔ̈p ë loi bï ajuër cï tääu yenhom ya kën ë Nhialic? ");
INSERT INTO dikNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Këya, tɛ̈ kuëëŋ raan yïk, ka kuëëŋ ye, ku käk cï juaar yenhom. ");
INSERT INTO dikNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ku tɛ̈ kuëëŋ raan luaŋ Nhialic ka kuëëŋ ye ku Nhialic yen rɛ̈ɛ̈r thïn, ");
INSERT INTO dikNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ku tɛ̈ kuëëŋ raan pan Nhialic, ka kuëëŋ määcde, ku yenhom guɔ̈p. ");
INSERT INTO dikNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Kɔc piööc lööŋ ku wek Parathï! Awëëŋkui! Wek aa kälik käkkun cäk puur yiic juɛ̈r Nhialic, ku wek aacie käril ye löŋ lueel ye kuɛ̈ɛ̈c nhïïm, cïmën bï raan dhiɛl la cök ku lir puɔ̈u, ku kony kɔc kɔ̈k ku cïï kɔc ye ruëëny. Wek aa dhil käkkä muk nhïïm, ke we cïï mäl ë juɛ̈r käŋ aya tënë Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kɔc mär kɔc, wek aacie käk wïc Nhialic ye looi, ku aa käk puɔl yiic kek aa yakë ke kuɛ̈ɛ̈c nhïïm. ");
INSERT INTO dikNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Kɔc piööc lööŋ ku wek Parathï! Awëëŋkui! Wek aacïï puɔ̈th la cök, wek aa cït bïïny ku aduuk ye lɔɔk kɔ̈th, ku aa thiäŋ mïïth ye rum riɛl ku mïïth ye ke tuɔ̈ɔ̈r nyïn. ");
INSERT INTO dikNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Wek kɔc Parathï cï cɔr wepuɔ̈th! Kaŋkë bïïny ku aduuk lɔɔk yiic, yen aabï kek kɔ̈th la wic aya! ");
INSERT INTO dikNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Kɔc piööc lööŋ ku wek Parathï! Awëëŋkui! Wek aa thöŋ kek rɛ̈ŋ cï buth, na tïŋ kekɔ̈th ke dhëŋ apɛi, ku keyiic alɔŋthïn aacï thiäŋ yom kɔc cï thou ku kärɛc kɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Këya, wek aa cït rɛ̈ŋkä aya. Wek aaye raan ëbën tïŋ we path gup aɣeer, ku piäthkun alɔŋthïn aacï thiäŋ ruëëny ku kärɛc kɔ̈k ëbën. ");
INSERT INTO dikNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Kɔc piööc lööŋ ku wek Parathï! Awëëŋkui! Wek aa rɛ̈ŋ buth tënë kɔc käk Nhialic tïŋ. Ku giɛtkë rɛ̈ŋ kɔc path bïk dhëŋ apɛi, ");
INSERT INTO dikNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ku luɛlkë ëlä, na ɣo tɔ̈ thïn wäär nɛ̈k wärkuan dït kɔc käk Nhialic tïŋ, ŋuɔ̈t ɣok aa këc röt mat ë nääkden yic. ");
INSERT INTO dikNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Këya, ayakë gam ayic lɔn ye wek mïth kɔc wäär näk kɔc käk Nhialic tïŋ! ");
INSERT INTO dikNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ku cït mënë ye wek kɔc ril nhïïm, cïn kë yakë gam, këriëëc ëbën atɔ̈ wecin, thääpkë kärɛc wäär cï wärkuɔ̈n dït jɔɔk! ");
INSERT INTO dikNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Mïth käpiɛny! Yakë tak bäk poth la pan mac këdë? ");
INSERT INTO dikNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ku rin ë wɛ̈t kënë yen acï Wä we tuɔ̈c kɔc käk Nhialic tïŋ. Ku ë kɔckä yiic, kɔc kɔ̈k aa bäk nɔ̈k, ku piäätkë kɔc kɔ̈k tim cï rïïu kɔ̈u, ku thatkë kɔc kɔ̈k ɣɔ̈nkuɔ̈n amat yiic, ku yakë ke yɔ̈ɔ̈p gɛɛth yiic ëbën. ");
INSERT INTO dikNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ku tɛ̈dun ye wek luui thïn kënë, abï awuɔ̈c bï teem rin kɔc cï nɔ̈k lööny weyiëth, jɔɔk nääk wäär nɛ̈k Abel ɣet nääk Dhäkaria wën Barakia wäär näkkë luaŋ Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ku lëk Jethu ke, awuɔ̈c bï gam rin ë käkkä ëbën abï bɛ̈n ë riëëc kënë yeth. ");
INSERT INTO dikNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Wek kɔc gen Jeruthalem, wek aa kɔc käk Nhialic tïŋ nɔ̈k, ku biɔ̈ɔ̈kkë kɔc cï Nhialic tuɔ̈c we aleel. Aca wïc arak juëc, ba we kony cïmën dhie ye ajïth miɛ̈thke kuɔ̈m piny yewuk bï ke kony bï ke cïï gɔp, ku wek aacï kuec. ");
INSERT INTO dikNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ëmën abäk tïŋ ke Nhialic cï yecin miëët bei, ku nyiëŋ pandun we. ");
INSERT INTO dikNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ku ëmën alɛ̈k we, ‘Wek acïï ɣa bï bɛn tïŋ ɣet aköl bï wek röt guiir bäk ɣa lor tɛ̈ ben ɣɛn dhuk.’ ” ");
INSERT INTO dikNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Tɛ̈wën jiël Jethu kal luaŋ Nhialic yic, ke kɔcken ye buɔɔth bɔ̈ tënë ye ku luelkë, “Raan piööc, tïŋ, ye luaŋdïït dhëëŋ ŋö kënë!” ");
INSERT INTO dikNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Go Jethu bɛ̈ɛ̈r, “Alɛ̈k we, ɣööt dït yakë tïŋkä aabï thuɔ̈r piny ëbën ka cïn alel töŋ bï kɔ̈ɔ̈c alel dɛ̈t nhom.” ");
INSERT INTO dikNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Tɛ̈wën rëër Jethu gɔn Olip nhom ë rot, ke kɔcken ye buɔɔth bɔ̈ tënë ye ku thiëckë, “Lɛ̈k ɣo ye nɛn bï käkkä röt looi, ku yeŋö bï tɛ̈ bï yïn dhuk pinynhom ku thök piny, nyuɔɔth?” ");
INSERT INTO dikNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Go Jethu lɛ̈k ke, “Duɔ̈kkë röt cɔl aduɔ̈ŋ. ");
INSERT INTO dikNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Rin kɔc juëc aabï bɛ̈n riɛnkiɛ̈, ku ye ŋɛk lueel, ‘Ke ɣɛn Raan cï lɔc ku dɔc.’ Ku aabï kɔc juëc duɔ̈ɔ̈ŋ. ");
INSERT INTO dikNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Duɔ̈kkë diɛɛr tɛ̈ tïŋ wek tɔɔŋ ke loi röt, ku tɛ̈ piŋ wek tɔɔŋ kɔ̈k wuɔ̈t mec yiic. Käkkä aa dhil röt looi, ku acie yen bɛ̈n thök ë piny. ");
INSERT INTO dikNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Rin wuɔ̈t aabï thɔ̈r kamken ku pan bɛ̈nyŋaknhom kek pan bɛ̈nyŋaknhom dɛ̈t aabï thɔ̈r aya. Cɔŋdït apɛi abï tɔ̈ thïn, ku ayiɛ̈ɛ̈kyiɛ̈ɛ̈k piny abï rot looi bɛ̈ɛ̈i juëc yiic. ");
INSERT INTO dikNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Käkkä kek aa käk tueŋ. ");
INSERT INTO dikNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ku dɛ̈t, wek aabï dɔm ku ɣɛ̈th we luk yic, ku wek aabï nɔ̈k. Ku wuɔ̈ɔ̈t ëbën aabï we maan riɛnkiɛ̈. ");
INSERT INTO dikNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ku ë tɛ̈ɛ̈n, kɔc juëc cï wɛ̈tdiɛ̈ gam aabï röt waar, ku kɔc kɔ̈k aabï ŋɛk raandä aluɔm ku man raandä ŋɛk. ");
INSERT INTO dikNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ku awëŋ juëc aabï tuɔ̈l aya, ku aabï kɔc juëc rac nhïïm. ");
INSERT INTO dikNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ku luɔi kärɛc abï rot juak apɛi, kɔc juëc aabï gamden wai wei. ");
INSERT INTO dikNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ku raan bï yepuɔ̈u dɛɛt ɣet tɛ̈ bï yen thou, abï pïr akölriëëc ëbën. ");
INSERT INTO dikNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ku Wɛ̈t Puɔth Yam kënë rin bääny Nhialic, abï kaŋ lɛ̈k kɔc ëbën pinynhom bïk piŋ, ku jɔl thök piny bɛ̈n. ");
INSERT INTO dikNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ala aköl bï wek kërac apɛi tïŋ, këwäär cï Daniel raan käk Nhialic tïŋ jam ë ye.” (Raan kuën adhil kënë deet yic!) ");
INSERT INTO dikNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Kɔc rɛ̈ɛ̈r Judia, ku tïŋkë ë kënë, ka dhil riŋ gat nhïïm roor bïk la thiaan. ");
INSERT INTO dikNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ku na rɛ̈ɛ̈r raan aɣeer, ka cïï ben la ɣöt bï la guik kë muk. ");
INSERT INTO dikNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ku na tɔ̈ raan dom yic, ka cïï ben dhuk baai bä alanhde la lööm. ");
INSERT INTO dikNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Diäär liɛc ku diäär muk mïthkor aabï gum apɛidït ye nïnkä. ");
INSERT INTO dikNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Rɔ̈ɔ̈kkë bï rot cïï loi wiir yic rut, tɛ̈dë aköl cïï kɔc ye luui. ");
INSERT INTO dikNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kɔc aabï gum apɛi ye nïnkä, gum këckë kaŋ yök tɛ̈wäär ciɛk Nhialic kɔc agut cït ëmën. Ku acïï rot bï bɛn looi. ");
INSERT INTO dikNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Na këc Nhialic looi bï nïnkä cɔl alik, ŋuɔ̈t acïn raan cï pïr. Ku rin kɔcken cï lɔc, acï nïn cɔl alik. ");
INSERT INTO dikNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Wek aa lɛ̈k, na le raan yöök we, ‘Tiɛ̈ŋkë Raan cï lɔc ku dɔc kïn, tɛ̈dë ke lueel, tiɛ̈ŋkë yen akan!’ Ke duɔ̈kkë gam. ");
INSERT INTO dikNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Rin kɔc juëc aabï bɛ̈n ku lueel ŋɛk, ee ɣɛn Raan cï lɔc ku dɔc, ku lueel raan dɛ̈t, ee ɣɛn raan käk Nhialic tïŋ, ku loikë käril kɔc gɔ̈i, na lëukë, ke mär kɔc cï Nhialic kuany. ");
INSERT INTO dikNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tiɛtkë röt, këriëëc ëbën alɛ̈k we ëmën bäk nhïïm tïr kë bï bɛ̈n. ");
INSERT INTO dikNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Këya, na le raan lëk yï ëlä, ‘Yen akan atɔ̈ roor tɛ̈ɛ̈n!’ Ke yï duk la, tɛ̈dë, ‘Yen akïn acï thiaan tɛ̈n,’ Ke duk gam. ");
INSERT INTO dikNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Rin tɛ̈ dhuk Manh Raan ka guɔkë ŋic. Abäk tïŋ cïmën bir deŋ dhie yen nhial reet yic, ku tïŋ lɔŋ ku lɔŋë. ");
INSERT INTO dikNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Dɛ̈t aya, abï ciɛ̈t mën dhie na cï cuɔr kenhïïm kut, ka la kë ŋuetkë. ");
INSERT INTO dikNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Awiëc ku bäk ŋic aya, ye nïnkä, tɛ̈ cï kɔc jäl gum apɛi, akɔ̈l abï kum nyin bï piny cuɔl, ku pɛɛi acïï bï ruɛl. Ku kuɛl aabï röt yääk ku löönykë. ");
INSERT INTO dikNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kë bï bɛ̈n Manh Raan cɔl aŋic abï tïŋ nhial, ku kɔc ëbën pinynhom aabï yiic ŋɛɛr käkken rɛc cïk looi. Ku keek aabï Manh Raan tïŋ ke bɔ̈ pial yiic nhial ke diik ku riɛldït apɛi. ");
INSERT INTO dikNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ku abä atuɔ̈ɔ̈cke tooc bïk këcït lɔ̈ɔ̈r yup yic, bï kek kɔcken cï lɔc kuɔ̈ɔ̈t yiic pinynhom ëbën. ");
INSERT INTO dikNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Ŋiɛckë ë kënë tim cït ŋaap, tɛ̈ looi yen yɔ̈ɔ̈k ku looi yïth, ke kër acï thiɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Këya, tɛ̈ tïŋ wek käkkä ke loi röt aya, ke ŋiɛckë lɔn cï yen thiɔ̈k apɛi. ");
INSERT INTO dikNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Alɛ̈k we, wek aacïï bï määr tɛ̈ cɔk käkkä röt looi. ");
INSERT INTO dikNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Nhial ku piny aabï liu, ku wɛ̈tdiɛ̈ acïï bï kaŋ määr. ");
INSERT INTO dikNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Acïn raan ŋic aköl bï käkkä röt looi. Na cɔk atuuc nhial, ayï Wënde, ka cïk ŋic. Ee Wä ë rot yen aŋic ye. ");
INSERT INTO dikNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Bɛ̈n Manh Raan abï ciɛ̈t këwäär loi rot wäär pïïr Noa. ");
INSERT INTO dikNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ee nïnkä, aboordït nhom tueŋ, kɔc aake rɛ̈ɛ̈r ke mit puɔ̈th, ke ye luui ruɛ̈i ku yëi ɣet aköl le Noa riäi yic, ");
INSERT INTO dikNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ku ë cïn kën ŋic ɣet tɛ̈ bïï aboor. Ku muɔu kɔc ëbën. Yen abï ciɛ̈t bɛ̈n Manh Raan aya. ");
INSERT INTO dikNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Tɛ̈ɛ̈n na cɔk kɔc karou luui dom yic, ke raan tök yen abï nyaai ku nyiëëŋ raan dɛ̈t piny. ");
INSERT INTO dikNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ku diäär karou lui tɛ̈tök aabï ke tiɛŋ tök nyaai, ku nyiëëŋ tiŋ dɛ̈t piny. ");
INSERT INTO dikNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Këya, guiɛrkë röt ku tiëërkë nhïïm, rin wek aa kuc aköl bï Bänydun bɛ̈n. ");
INSERT INTO dikNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Yen acït kën na raan la baai ŋic tɛ̈ bï cuär bɛ̈n thïn wakɔ̈u, ka rɛ̈ɛ̈r ke yiën, ku cïï cuär päl bï käkke nyaai. ");
INSERT INTO dikNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ke week aya, wek aa dhil rëër we tït, rin acäk ŋic ye nɛn bï Manh Raan bɛ̈n. ");
INSERT INTO dikNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Na ye këya, yeŋa alony path ku ŋic käŋ apɛi, bï bɛ̈ny nyääŋ paande, bï kacke aa gäm miëth akölaköl? ");
INSERT INTO dikNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Alony mit guɔ̈p, alony bï bɛ̈ny yök ke loi luɔide apath tɛ̈ dhuk yen! ");
INSERT INTO dikNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Alɛ̈k we, abï alony kënë tääu käkke yiic ëbën. ");
INSERT INTO dikNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ku alony cïï luɔide bï ŋiɛc looi, rin yen ye tak lɔn cïï bänyde bï lac dhuk, ");
INSERT INTO dikNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ku kuc kɔc pan bɛ̈ny ciëëŋ, ku ye cool wiɛɛt kek kɔc dek ë määu, ");
INSERT INTO dikNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ke bänyde abï la luät yeguɔ̈p aköl cïï ye tak lɔn yen aköl bï yen bɛ̈n. ");
INSERT INTO dikNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ku yeen abï bɛ̈ny tɛ̈m awuɔ̈cdït, ku mɛt tɛ̈ rëër kɔc rɛc thïn, ë tɛ̈ɛ̈n kɔc aa rëër ke dhiau ke ŋɛny kelec.” ");
INSERT INTO dikNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ku ben Jethu kääŋ dɛ̈t thɔ̈ɔ̈th, ku thööŋ bääny Nhialic ëlä, “Nyïïr kathiäär aake cï käkken ye kek mer lööm ku lek yan thiëëk yic. ");
INSERT INTO dikNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Kam ë nyïïrkä, nyïïr kadhiëc aake pel nyïn, ku nyïïr kadhiëc aa cïï nyïn pel. ");
INSERT INTO dikNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nyïïr aa bɛ̈lkä aake cï mermerken lööm ku cïk miök dït muk. ");
INSERT INTO dikNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ku nyïïr ŋic käŋ aake muk mermerken ku miök dït tet aya. ");
INSERT INTO dikNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nawën ka athiëëk gääu bï cïï lɔc bɛ̈n, gokë tɔ̈c bïk nin. ");
INSERT INTO dikNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Nawën wɛ̈ɛ̈r ciɛl yic, ke piŋ duɔɔt, ‘Athiëëk abɔ̈, bäk aɣeer ku luɔrkë!’ ");
INSERT INTO dikNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Go nyïïr awën kathiäär röt jɔt kedhie ku dëëpkë mermerken. ");
INSERT INTO dikNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Go mermer nyïïr aabɛ̈l cïï dɛ̈p apath rin cïn kek yiic miök. Gokë nyïïr kɔ̈kkä lim, ‘Miackë ɣo ë miök, mermerkua aacïï dɛ̈p.’ ");
INSERT INTO dikNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Gokë bɛ̈ɛ̈r, ‘Miök acïï ɣo thöŋ, lak tɛ̈ ye miök ɣaac thïn bäk la ɣɔɔc miɔ̈kdun.’ ");
INSERT INTO dikNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Go nyïïr aabɛ̈l la bïk la ɣɔɔc miök, ku go athiëëk guɔ lɔ̈k bɛ̈n kecök. Go nyïïr awën cï röt guiir la kal yic kek athiëëk tɛ̈wën dieer yai thïn, ku thiök kal thok. ");
INSERT INTO dikNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Nawën la nyïïr awën cï la ɣɔɔc miök dhuk ke cöt, ‘Bɛ̈ny, Bɛ̈ny, ŋäny ɣo kal thok!’ ");
INSERT INTO dikNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Go athiëëk bɛ̈ɛ̈r, ‘Ye wek yïŋa?’ Wek aacä ŋic!” ");
INSERT INTO dikNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ku wit Jethu wɛ̈tde ëlä, “Rɛ̈ɛ̈rkë we cï röt guiir, rin wek aa kuc aköl bï ɣɛn bɛ̈n.” ");
INSERT INTO dikNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ku ben Jethu kääŋ dɛ̈t bɛn thɔ̈ɔ̈th ku lueel, “Bääny Nhialic abï thöŋ ke mony la keny wun dɛ̈t, cä aluɔɔnyke cɔɔl ku gɛ̈m ke wëëu bï kek lɔ̈k luui. ");
INSERT INTO dikNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ku yïk aluɔny tök tim buɔɔt. Ku gɛ̈m alony dɛ̈t tim thiärdhiëc, ku gɛ̈m alony ye kek diäk tim thiäär. Acï wëëu tek këya cït tɛ̈ ŋic ŋɛk luui thïn, ku jiël bï la keny. ");
INSERT INTO dikNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Go alony cï yiëk tim buɔɔt, wɛ̈ɛ̈uke la luɔɔi ku yök tim buɔɔt dɛ̈t. ");
INSERT INTO dikNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ku lui alony cï gäm tim thiärdhiëc cïmën alony wën aya, ku yök tim thiärdhiëc dɛ̈t. ");
INSERT INTO dikNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ku la alony cï gäm tim thiäär wëëu bänyde la wuɔ̈ɔ̈t piny ëbën. ");
INSERT INTO dikNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Nawën ke bänyden jɔl dhuk, ku cɔɔl aluɔɔnyke bï wɛ̈ɛ̈uke bɛ̈n kuɛ̈ɛ̈n nyïn. ");
INSERT INTO dikNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Go alony wäär cï gäm tim buɔɔt bɛ̈n ku lueel, ‘Bɛ̈ny, wäär yïn acä gäm tim buɔɔt, ku ëmën tïŋ, ɣɛn acï tim buɔɔt dɛ̈t juak thïn.’ ");
INSERT INTO dikNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Go bänyde leec luɔiden pɛth cï looi ku lueel, ‘Yïn acï wëëu lik ŋiɛc muk apath ku juak keyiic, këya ëmën yïn aba tääu käjuëc yiic ba ke muk. Bäär rëërku ɣo mit puɔ̈th ɣodhie.’ ");
INSERT INTO dikNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ku ben alony cï gäm tim thiärdhiëc bɛ̈n ku lueel, ‘Bɛ̈ny yïn acä yiëk tim thiärdhiëc wäär le yïn keny, ku ɣɛn acï lɔ̈k luui ku juak tim thiärdhiëc dɛ̈t thïn.’ ");
INSERT INTO dikNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Go bɛ̈ny leec luɔiden cï ŋiɛc looi ku lueel, ‘Yïn alony puɔth käŋ tiit apath. Yïn acï kälik tiit apath, ku ëmën yïn abï tääu käjuëc nhïïm, bäär miɛt puɔ̈u ë bääny bäänydu yic.’ ");
INSERT INTO dikNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Go raan cï tim thiäär lööm bɛ̈n ku lueel, ‘Bɛ̈ny, aca piŋ lɔn ye yïn raan col puɔ̈u rap kɛ̈c puur tem, ku kuany käk ke këc ke wɛɛr piny. ");
INSERT INTO dikNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Këya, ɣɛn acï riɔ̈ɔ̈c ku la wɛ̈ɛ̈uku wɛc piny. Ŋɔ̈! Wëëu wäär ca kuɛ̈i ɣa aa kïk.’ ");
INSERT INTO dikNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Go bɛ̈ny lɛ̈k ye ëlä, ‘Alony rac, ku ye adak rot aya. Na ŋic lɔn ye ɣɛn rap tem, rap kɛ̈c puur, ku lɔn ye ɣɛn käŋ kuany, ku aa kɛ̈c pok. ");
INSERT INTO dikNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ŋuɔ̈t yïn acï wɛ̈ɛ̈ukiɛ̈ dhiɛl gäm raan ŋic luɔi wëëu, na la dhuk ciëën, ke ɣa yök wɛ̈ɛ̈ukiɛ̈ ke cï keyiic juak. ");
INSERT INTO dikNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Nyaaikë wëëu tënë ye ku gämkë ke raan la tim buɔɔt. ");
INSERT INTO dikNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Rin raan kälik ŋiɛc muk abï käkke juak yiic, ku raan cïï käŋ ye ŋiɛc muk, abï këden tɔ̈ thïn nyaai. ");
INSERT INTO dikNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ku cuatkë alony rɛɛc kënë muɔ̈ɔ̈th yic aɣeer, ku tɛ̈ɛ̈n dhiëëu abï tɔ̈ thïn, ke kac yelec.’ ");
INSERT INTO dikNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Aköl bï Manh Raan bɛ̈n ke duaar, ku atuuc nhial ëbën ke cath ke ye, abï nyuc thɔ̈nyde nhom ke duaar pan Nhialic, ");
INSERT INTO dikNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ku thäi ëbën aabï guëër yenhom. Ku aabï tek yiic akuut karou, cïmën raan la thök, yen amɛ̈l ku apïyeem tek thook. ");
INSERT INTO dikNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ku tɛ̈ɛ̈u amɛ̈l köŋden cuëc ku apïyeem köŋ cam. ");
INSERT INTO dikNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ku Bɛ̈ny abï kɔc kääc lɔŋ cuëc lɛ̈k, ‘Bäk, kɔc cï Wä dɔɔc ku lɔ̈mkë bääny cï guiir tënë we tɛ̈wäär ciɛk piny. ");
INSERT INTO dikNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Wën cï cɔk ɣa nɔ̈k, wek aacä muɔɔc këcam. Ku wën cï rou ɣa nɔ̈k wek aacä muɔɔc këdɛk, ku wën ye ɣɛn jäl, wek aacä lor pandun, ");
INSERT INTO dikNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ku wën cïn ɣɛn lubo wek aacä ruɔ̈k kɔ̈u, ku wën tuɛɛny ɣa wek aacä la neem, ku wën cï ɣa mac, wek aacä bɛ̈n tïŋ.’ ");
INSERT INTO dikNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ku kɔc wën aabï wɛ̈tde dhuk nhom ëlä, ‘Bɛ̈ny, yï cuk tïŋ nɛn yï nɛ̈k cɔk buk yï muɔɔc këcam? Ku nɛ̈k rou yï buk yï muɔɔc këdek, ");
INSERT INTO dikNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ku cuk yï tïŋ nɛn ke yï bɔ̈ keny yic buk yï lor? Ku yïn acïn lubo goku yï ruɔ̈k kɔ̈u? ");
INSERT INTO dikNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Yï cuk tïŋ nɛn ke yï tuany, ke yï cï mac buk yï la neem?’ ");
INSERT INTO dikNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ku abï Bɛ̈nyŋaknhom lɛ̈k ke, wɛ̈t yic alɛ̈k we, ‘Këriëëc ëbën cäk luɔ̈i raan tök kam wämäthkiɛ̈ thiikä, aa cäk luɔ̈i ɣa aya.’ ");
INSERT INTO dikNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ku abï lɛ̈k kɔc lɔŋ cam, ‘Aa wek kɔc cï cieen, jälkë ë tɛ̈n bäk la many dɛ̈p yic akölriëëc ëbën, many cï guiir tënë jɔŋrac ku atuɔ̈ɔ̈cke ëbën. ");
INSERT INTO dikNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Rin wäär nɛ̈k cɔk ɣa, wek aa këc ɣa muɔɔc këcam, ku nɛ̈k rou ɣa ku wek aa këc ɣa muɔɔc këdɛk. ");
INSERT INTO dikNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ku wäär ɣɛn ë jäl ku wek aa këc ɣa gɔɔŋ pandun, ku ɣɛn ɣa cïn kɔ̈u alath, wek aa këc ɣa ruɔ̈k kɔ̈u, ku ɣɛn a ɣa cï tuaany, ku mac ɣa ku wek aa këc bɛ̈n bäk ɣa neem.’ ");
INSERT INTO dikNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ku kɔckui aya aabï thiëc, ‘Bɛ̈ny, yï cuk tïŋ nɛn ke yï nɛ̈k cɔk ku rou, ku ye nɛn yï bɔ̈ keny yic, ku cïn alanh ceŋ, ku tuany yï ku mac yï ku yïn akëcku kony?’ ");
INSERT INTO dikNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ku abï bɛ̈ɛ̈r, tënë ke, ‘Wɛ̈t yic alɛ̈k we, këriëëc ëbën kɛ̈ckë luɔ̈i wämäthkiɛ̈ thiikä, ka kɛ̈ckë luɔ̈i ɣɛn aya.’ ");
INSERT INTO dikNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ku keek aabï la tɛ̈ bï ke reem thïn akölriëëc ëbën, ku kɔc path aabï la tɛ̈ bï kek pïr thïn akölriëëc ëbën.” ");
INSERT INTO dikNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Nawën cï Jethu thök jam kek kɔcken ye buɔɔth, ke lëk ke, ");
INSERT INTO dikNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Cïmën ŋic wek ye, Yan Ayum cïn yic luɔu abï yecök jɔɔk nïn karou bï bɛ̈n. Ku Manh Raan abï luɔm tënë kɔc rɛc bïk piäät tim cï rïïu kɔ̈u.” ");
INSERT INTO dikNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Kaam awën ke kɔcdït käk Nhialic ku kɔcdït baai Itharel, aake mɛ̈t pan raandït käk Nhialic cɔl Kaipa, ");
INSERT INTO dikNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ku guirkë tɛ̈ bï kek Jethu dam thïn ke cïï ŋic ku näk. ");
INSERT INTO dikNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ku luelkë, “Acuk dɔm aköl yai. Ɣok aabï tïït bï kɔc kaŋ jäl, rin na dɔmku, ke kɔc ŋoot yai yic, tɛ̈dë ke kɔc juëc aa thär kek ɣo.” ");
INSERT INTO dikNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Tɛ̈wën rëër Jethu Bethanï pan raan atuet cɔl Thaimon, ");
INSERT INTO dikNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ke tik bɔ̈ tɛ̈wën mïth yen, ke muk töny koor cï cuëëc tiɔm ril la yic miök ŋïr ye ɣɔɔc wëëu juëc apɛi, ku kuem thok ku luuŋ miök Jethu nhom ëbën. ");
INSERT INTO dikNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Go kɔc Jethu buɔɔth puɔ̈th dak wën tïŋ kek kënë, ku jiɛɛmkë kamken, “Yeŋö tuuk yen miök ŋïr?” ");
INSERT INTO dikNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","“Miök ŋïr kënë ŋuɔ̈t acï ɣaac wëëu juëc ku gɛ̈m wëëu kɔc ŋɔ̈ŋ.” ");
INSERT INTO dikNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Go Jethu kë luelkë ŋic, ku lueel tënë ke, “Pälkë, yeŋö nyieeny wek ye? Kë cï looi tënë ɣa yen tiŋ, ee këpath apɛi. ");
INSERT INTO dikNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kɔc ŋɔ̈ŋ aabï rëër kamkun akölaköl, ku ɣɛn acïï bï rëër kek we akölaköl. ");
INSERT INTO dikNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Wën luuŋ tiŋ kënë miök ɣaguɔ̈p, ee looi këya bä tɔc bï guäpdiɛ̈ guiir bï jal thiɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Wek alɛ̈k yic, kuat tɛ̈ bï Wɛ̈t Puɔth Yam piɔ̈ɔ̈c thïn pinynhom, kë cï tiŋ kënë looi, abï ya lueel bï ye atak.” ");
INSERT INTO dikNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Nawën ke raan tök kam atuuc kathiäär ku rou, cɔl Judath Ithkariöt la tënë kɔcdït käk Nhialic ");
INSERT INTO dikNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ku lueel, “Yeŋö bäk yiëk ɣa tɛ̈ thɔ̈n ɣɛn we Jethu?” ");
INSERT INTO dikNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Gokë gäm wëëu juëc. Ku jɔl tɛ̈ bï yen Jethu dɔm thïn wïc. ");
INSERT INTO dikNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Nawën aköl tueŋ Yandït Ayum cïn yic luɔu, ke kɔc Jethu buɔɔth bɔ̈ tënë ye, ku thiëckë, “Ye tɛ̈nɛn wïc bï ɣok miëth yai guiir thïn tënë yï?” ");
INSERT INTO dikNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Go bɛ̈ɛ̈r, “Lak geeu tënë ŋɛkdït ku lɛ̈kkë ye, ‘Aye Bänyda lueel, aköl bï luɔidiɛ̈ thök acï bɛ̈n. Ee paandu yen abï ɣɛn Yan Ayum cïn yic luɔu cam thïn kek kɔckiɛ̈n ɣa buɔɔth.’ ” ");
INSERT INTO dikNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Go kɔc ë biööth kë cï Jethu lɛ̈k ke looi, ku guirkë miëth yai. ");
INSERT INTO dikNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nawën la thëi bɛ̈n ke Jethu nyuc kek kɔcken ye buɔɔth kathiäär ku rou bïk mïth. ");
INSERT INTO dikNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Tɛ̈wën mïth kek ke lueel Jethu, “Wek alɛ̈k yic, raan tök kamkun abä luɔm.” ");
INSERT INTO dikNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Gokë puɔ̈th riääk apɛi ku gɛ̈ikë, ku thiëckë tök-tök, “Makei! Ye yic? Ye ɣɛn Bɛ̈ny?” ");
INSERT INTO dikNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Go Jethu bɛ̈ɛ̈r, “Ee raan tök kamkun lut yecin kek ɣa aduɔ̈k yic, yen ë raan bï ɣa gaany. ");
INSERT INTO dikNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ee yic, Manh Raan abï nɔ̈k cït tɛ̈ cï gät ye riɛnke athör thɛɛr yiic. Ku raan bï ye luɔm abï gum apɛi! Ku aŋuɛ̈ɛ̈n tënë ye diɛ̈t këc kaŋ dhiëëth.” ");
INSERT INTO dikNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ku Judath aya, ëcï Jethu thiëëc, “Raan piööc, ye ɣa?” Go Jethu bɛ̈ɛ̈r, “Ee yï.” ");
INSERT INTO dikNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Tɛ̈wën mïth kek, ke Jethu löm ayup ku dɔɔc ku bɛny yic, ku gɛ̈m kɔcken ye buɔɔth ku lueel, “Lɔ̈mkë kënë, ku camkë, kënë ee guäpdiɛ̈.” ");
INSERT INTO dikNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ku lööm aduŋ cï thiäŋ muɔ̈n abiëc, ku leec Nhialic ku gɛ̈m ke ku lueel, “Dɛ̈kkë thïn ëbën.” ");
INSERT INTO dikNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","“Kënë ë riɛmdiɛ̈, riɛm dɔ̈ɔ̈r kek Nhialic, bï kuër rin bï adumuɔ̈ɔ̈m kɔc ëbën päl piny. ");
INSERT INTO dikNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Alɛ̈k we, ɣɛn acïï bï bɛn dek muɔ̈n abiëc pinynhom tɛ̈n kek we, ɣet aköl bï ɣok ye dek ɣodhie pan Nhialic.” ");
INSERT INTO dikNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nawën cïk jäl thök ke ket waak ku lek gɔn Olip cök. ");
INSERT INTO dikNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ku lueel Jethu tënë ke, “Wek kackiɛ̈, wek aabï kat ɣa ë wɛ̈ɛ̈r kënë cïmën këwäär cï gɔ̈t athör thɛɛr wël Nhialic yic ëlä, ‘Ɣɛn abä abiöök cɔl anäk ku amɛ̈l aabï wɛɛr.’ ");
INSERT INTO dikNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ku tɛ̈ cï ɣɛn rot jɔt raŋ yic, ke ɣɛn abï kaŋ la Galilia ba we la tiit thïn.” ");
INSERT INTO dikNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Go Pïtɛr lueel tënë Jethu, “Ɣɛn acïï bï kat tɛ̈ cɔk kɔc ëbën kat yï!” ");
INSERT INTO dikNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Go Jethu bɛ̈ɛ̈r, “Alɛ̈k yï, ee wɛ̈ɛ̈r kënë, ke thɔn ajïth këc kiu, yïn abä jai arak diäk.” ");
INSERT INTO dikNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Go Pïtɛr dhuɔ̈k ye, “Na cɔk ɣa nɔ̈k kek yï, ke yïn acä bï kaŋ jai.” Ku lueel kɔcken kɔ̈k ye buɔɔth ëbën këya. ");
INSERT INTO dikNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Kaam wën ke Jethu kek kɔcken ye buɔɔth la tɛ̈ cɔl Jethemani, ku lueel tënë ke, “Nyuɔ̈ɔ̈ckë tɛ̈n, ku yiënkë, ɣɛn ala tɛ̈ɛ̈n ba la röök.” ");
INSERT INTO dikNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ku cɔɔl Pïtɛr ku wɛ̈ɛ̈t Dhubedï karou, ku jɔl rëër ke nɛ̈k atiëël, ku dhiɛɛu apɛi yepuɔ̈u. ");
INSERT INTO dikNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ku lueel tënë ke, “Ɣɛn adhiau puɔ̈u apɛi, ee thou guɔ̈p. Rɛ̈ɛ̈rkë tɛ̈n ku yiënkë.” ");
INSERT INTO dikNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ku le tueŋ tɛ̈thin-nyɔɔt, ku rɛ̈ɛ̈ny rot piny ke gut yenhom piny ku röök ëlä, “Wä, na lëu rot ke yï cɔl kërɛɛc tit ɣa acïï bɔ̈. Ku acie wɛ̈t piändiɛ̈, ee wɛ̈t piändu.” ");
INSERT INTO dikNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nawën ke dhuk tënë ke kadiäk ku yök ke ke nin. Go lueel tënë Pïtɛr, “Niɛɛnkë! Cäk yiën tɛ̈thin-nyɔɔt? Yeŋö ye wek nin këlä? ");
INSERT INTO dikNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Yiënkë ku rɔ̈ɔ̈kkë bï we cïï them jakrɛc. Puɔ̈u ë gam ku guɔ̈p acïn riɛl.” ");
INSERT INTO dikNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ku ben jäl ku le röök ëlä, “Wä, na cïï kërɛɛc kënë jiël, ke wɛ̈t piändu abï rot looi.” ");
INSERT INTO dikNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ku ben dhuk tënë ke, ku ben ke yök ke nin, rin cï nin ke göök apɛi. ");
INSERT INTO dikNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Goke nyääŋ piny ku ben jäl, ku ben la röök cïmën awën, kën ye kek diäk. ");
INSERT INTO dikNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ku dhuk tënë kɔcken ye buɔɔth ku lueel, “Ŋot we nin! Lääŋkë? Tɛ̈n nin acï thök, tiɛ̈ŋkë Manh Raan acï luɔ̈m kɔc rɛc. Ëmën tɛ̈ bï ɣa jal thɔ̈n kɔc rɛc acï ɣëët. ");
INSERT INTO dikNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Raan cä luɔm acï bɛ̈n. Jatkë röt, lokku buk rɔ̈m!” ");
INSERT INTO dikNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Tɛ̈wën ŋot jiɛɛm yen, ku Judath raan töŋ kɔc atuuc kathiäär ku rou ɣëët. Ku yeen ë cath kek kɔc juëc muk paal ku atuel, ke cï kɔcdït käk Nhialic ku kɔcdït baai tooc. ");
INSERT INTO dikNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ku Judath acï kɔc awën cath kek ye, lɛ̈k tɛ̈ bï kek raan wïckë bïk bɛ̈n dɔm ŋiɛc thïn, ëlä, “Raan ba muɔ̈ɔ̈th ku ciɛɛm yen ë raan wiɛ̈ckë. Damkë ku kuathkë.” ");
INSERT INTO dikNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Kaam wën ɣëët Judath, ke la tënë Jethu nyin yic ku lueel, “Bɛ̈ny,” ku muɔ̈ɔ̈th ku ciim. ");
INSERT INTO dikNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Go Jethu bɛ̈ɛ̈r, “Mäthdiɛ̈, loi kënë bï yïn ë tɛ̈n.” Go kɔc awën bɛ̈n ku dɔmkë Jethu ku derkë. ");
INSERT INTO dikNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Go raan tök kam kɔc awën rɛ̈ɛ̈r kek Jethu palde miëët bei, ku tök alony lui pan raandït käk Nhialic yïc, abï tɛɛm yïc wei. ");
INSERT INTO dikNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Go Jethu lɛ̈k ye, “Dhuɔ̈k paldu tɛ̈den awën, kɔc ye wïc bïk kɔc nɔ̈k, aabï thou aya këya. ");
INSERT INTO dikNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Cäk ë tak lɔn nadë, ka lɛ̈u ba Wä thiëëc bï ɣa tuɔ̈c atuuc nhial juëc apɛi bïk ɣa bɛ̈n kony? ");
INSERT INTO dikNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ku na ye këya, ke wël athör thɛɛr Nhialic bï röt tiɛɛŋ, wël ye lueel ka dhil rot looi këlä?” ");
INSERT INTO dikNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ku kaam wën ke lueel Jethu tënë ke ëlä, “Cäk bɛ̈n we muk atuel ku paal bäk ɣa bɛ̈n dɔm, ciɛ̈t ɣa ye raan kɔc rum? Ɣɛn ee rëër kek we akölaköl ɣa piööc kɔc luaŋ Nhialic, ku wek aa këc ɣa dɔm. ");
INSERT INTO dikNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ku kënë acï rot looi bï kë cï gɔ̈t athör thɛɛr wël Nhialic yiic yenhom tiɛɛŋ.” Ku jɔl kɔcken ye buɔɔth ëbën nyääŋ piny ku kɛtkë. ");
INSERT INTO dikNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ku jɔl kɔc awën cï Jethu dɔm, Jethu ɣäth pan Kaipa luk yic, cï bäny käk Nhialic Itharel, ku kɔc piööc lööŋ kenhïïm mat thïn. ");
INSERT INTO dikNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ku Pïtɛr ë biöth, ke mec kɔc cök ciëën agut tɛ̈ ɣëët yen pan bɛ̈ny luk yic. Ku nyuuc kek kɔc bɛ̈ny tiit, ku jɔl rëër bï kë lui Jethu tïŋ. ");
INSERT INTO dikNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Bäny luk ku kɔcdït käk Nhialic aake cï nyuc bïk Jethu wïc guɔ̈p awuɔ̈c cï looi, rin bï kek ye tɛ̈m thou. ");
INSERT INTO dikNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ku acïn awuɔ̈c cïï bɛ̈n yök, cɔk alɔn ye kɔc juëc ye luɔm lueth, ke wɛ̈lken akëc rɔ̈m. Nawën ke kɔc karou jɔt röt, ");
INSERT INTO dikNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ku luelkë, “Acuk piŋ ke lueel, ‘Ɣɛn abï luaŋ Nhialic kënë thuɔ̈r piny, ku na ye aköl ye nïn diäk ke ɣɛn abï dɛ̈t buth nyiɛnde.’ ” ");
INSERT INTO dikNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Go Kaipa raandït käk Nhialic rot jɔt ku thiëëc Jethu, “Cïn wɛ̈t dhuk nhom ë wël cï luɛɛl yïguɔ̈pkä yiic?” ");
INSERT INTO dikNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Go Jethu biɛt. Go Kaipa bɛn lɛ̈k ye, “Yïn athiëëc rin Nhialic ba lɛ̈k ɣo lɔn ye yïn Raan cï lɔc ku dɔc, Manh Nhialic.” ");
INSERT INTO dikNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Go Jethu lɛ̈k ye, “Ee yic, cït tɛ̈ ca luɛ̈l ye. Ku aŋot lɛ̈k we ëbën lɔn ëmën ɣet tueŋ, wek aabï Manh Raan jäl tïŋ ke cï nyuc cuëny Nhialic ŋic käŋ looi ëbën, ku bïï puɔl nhïïm nhial.” ");
INSERT INTO dikNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Go Kaipa aläthke rɛt yiic yekɔ̈u ku lueel, “Acï Nhialic tɔɔn guɔ̈p. Yeŋö ŋot wïcku kɔc kɔ̈k bï bɛn jam käk cï looi ëmën? Ku wek aacï tɛ̈ tɔɔn yen Nhialic thïn piŋ. ");
INSERT INTO dikNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Yeŋö yen wɛ̈tdun?” Gokë bɛ̈ɛ̈r, “Ala guɔ̈p awuɔ̈c, adhil nɔ̈k.” ");
INSERT INTO dikNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ku jɔl kɔc kɔ̈k aa ŋuɔ̈ɔ̈t nyin ku guutkë kecin. Ku lëk kɔc kɔ̈k ye tɛ̈wën ye kek ye gut, ");
INSERT INTO dikNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Raan cï lɔc ku dɔc, mɛɛk raan yï gut?” ");
INSERT INTO dikNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Kaam wën ŋot rëër Pïtɛr piiny kal yic pan bɛ̈ny, ke nyɛn lui pan Kaipa bɔ̈ tënë ye ku lueel, “Yïïn aya, yïn yï rëër kek Jethu raan Galilia.” ");
INSERT INTO dikNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Go jai kenhïïm ëbën ku lueel ëlä, “Ɣɛn acïï raandun ye lueel ŋic diɛn. Ku kë ye lueel acä cak deet yic aya.” ");
INSERT INTO dikNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ku ler aɣeer. Go nyɛn dɛ̈t alony bɛ̈n ku lëk kɔc awën kääc thïn, “Mony kënë ë ye rëër kek Jethu raan Nadharet.” ");
INSERT INTO dikNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Go Pïtɛr bɛn jai ku kuëëŋ ku lueel, “Ɣɛn akuc mony kënë.” ");
INSERT INTO dikNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ku kaam awën, ke lueel kɔc kääc thïn tënë Pïtɛr, “Ee yic, yïn ë raanden rin yïn ë raan Galilia, yïn ë jam cïmënden.” ");
INSERT INTO dikNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Go Pïtɛr rot bɛn kuëëŋ, “Nhialic abä nɔ̈k tɛ̈ cïï ɣɛn yic luel! Ɣɛn akuc raan jiɛɛm wek riɛnke!” Nyin yic tɛ̈wën ke thɔn ajïth kiu. ");
INSERT INTO dikNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Go Pïtɛr këwäär cï Jethu lɛ̈k ye tak. “Tueŋ ke thɔn ajïth këc kiu, ke yïn abä jai arak diäk.” Ku ler aɣeer ke cï guɔ̈p yär ku dhiɛɛu. ");
INSERT INTO dikNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Naɣɔn nhiäk rial yic, ke bänydït käk Nhialic, ku kɔcdït baai mɛ̈t tɛ̈ bïk luɔ̈i Jethu ku bïk nɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Gokë rek ku kuɛɛthkë tënë bɛ̈nydït Pilato, raan Roma. ");
INSERT INTO dikNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Nawën le Judath, raan wäär gɔɔny Jethu tïŋ, lɔn cï Jethu tɛ̈m thou, ke riääk puɔ̈u apɛi ku dhuk wëëu ke cï ye riɔp ciëën tënë bäny luk. ");
INSERT INTO dikNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ku lueel, “Ɣɛn acï kërac looi rin cï ɣɛn raan cïn guɔ̈p awuɔ̈c luɔm ë lueth.” Gokë bɛ̈ɛ̈r, “Ee wɛ̈tdu, acïn këda thïn.” ");
INSERT INTO dikNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Go Judath wëëu cuat kal luaŋ Nhialic yic, ku le rot nöök. ");
INSERT INTO dikNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Go bäny käk Nhialic wëëu kuany ku luelkë, “Acïï path buk wëëukä mat wëëu ye juaar yiic ɣön Nhialic, rin ye kek wëëu ë riɛm.” ");
INSERT INTO dikNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ku jɔlkë tɛ̈ bï kek wëëu luɔɔi thïn guëëk yic. Nawën ke matkë yic bïk piny ye ke tiɔp wec thïn kɔc cuëc ë töny, ɣɔɔc ë wëëukä, ku bï ya tɛ̈ ye kɔc thäi cï thou Jeruthalem thiɔ̈k thïn. ");
INSERT INTO dikNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ku ë yen kë ye dom kënë cɔɔl, ke cɔl, “Tiɔm Riɛm,” agut ya akölë. ");
INSERT INTO dikNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ku kënë cï Jeremia, raan käk Nhialic tïŋ, lueel ëlä thɛɛr acï yenhom tiɛɛŋ, “Aacï wëëu lööm, wëëu kek ke cï kɔc Itharel gam bï ya kek ɣɔɔc yeen, ");
INSERT INTO dikNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ku ɣɔɔc kek piny raan cuëc ë töny cïmën cï Bɛ̈ny ye lɛ̈k ɣɛn.” ");
INSERT INTO dikNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ku Jethu ë kääc Pilato nhom. Go Pilato thiëëc, “Ye yïn Bɛ̈nyŋaknhom kɔc Itharel?” Go Jethu bɛ̈ɛ̈r, “Ee ɣɛn, cït tɛ̈ ca luɛ̈l ye.” ");
INSERT INTO dikNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ku acïn wɛ̈t cï bɛ̈ɛ̈r wël juëc ke ye bäny Itharel luɛɛl yeguɔ̈p. ");
INSERT INTO dikNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Go Pilato thiëëc, “Cïï käjuëc cï yï gaanykä ye piŋ?” ");
INSERT INTO dikNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Go Jethu biɛt ke cï wɛ̈t Pilato bëër. Go Pilato gäi apɛi. ");
INSERT INTO dikNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ruɔ̈ɔ̈n ëbën, aköl Yan Ayum cïn yic luɔu, bɛ̈nyŋaknhom ee raan tök kam kɔc cï mac lony, tɛ̈ wïc kɔc baai ye bï lony. ");
INSERT INTO dikNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ku ë ruɔ̈ɔ̈n kënë raan cï kärɛc apɛi looi cɔl Barabath ë mac. ");
INSERT INTO dikNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nawën cï kɔc kenhïïm kut, ke thiëëc Pilato ëlä, “Yeŋa wiɛ̈ckë ba lony tënë we, ye Barabath aye Jethu, ye cɔl Raan cï lɔc ku dɔc?” ");
INSERT INTO dikNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Rin ee ŋic Pilato lɔn ë yen tiɛɛl yen ë thön kek Jethu ye. ");
INSERT INTO dikNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Tɛ̈wën cï Pilato nyuc thɔ̈nyde nhom luk yic, ke tuc tiɛŋde wɛ̈t, “Duk them ba yïthok mat raan cïn kë cï wuɔ̈ɔ̈c kënë guɔ̈p, këde ë bɛ̈n ɣanhom kecït nyuɔ̈th wën akɔ̈u bä pɛ̈n nïn.” ");
INSERT INTO dikNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ku kɔc ater Jethu aake kɔc kuɔ̈ɔ̈t thook bïk lɛ̈k Pilato bï ya Barabath yen lony, ku cɔl Jethu anäk. ");
INSERT INTO dikNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Nawën thiëc Pilato ke, “Yeŋa kamken karou wiɛ̈ckë ba lony tënë we?” Gokë lueel, “Ee Barabath.” ");
INSERT INTO dikNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Go Pilato ke thiëëc, “Yeŋö ba looi tënë Jethu raan ye lueel ka cï lɔc ku dɔc?” Gokë rek yic ëbën, “Apiëët tim cï rïïu kɔ̈u.” ");
INSERT INTO dikNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Go Pilato ke bɛn thiëëc, “Yeŋö? Ye awäc ŋö cï looi?” Gokë bɛn rek yic röldït apɛi, “Apiëët tim cï rïïu kɔ̈u.” ");
INSERT INTO dikNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Nawën tïŋ Pilato ke cïï bï lëu, ku tïŋ aya ka aliääp bï rot looi, ke cɔl pïu ku lɔɔk yecin kenhïïm ke dɛɛi kek ëbën ku lueel, “Thon ë raan kënë aliu ɣacin! Arɛ̈ɛ̈r wecin.” ");
INSERT INTO dikNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Gokë dhuɔ̈k ye ëbën ke ke cï puɔ̈th dak, “Riɛmde abï täu ɣocin ku miɛ̈thkua cin aya.” ");
INSERT INTO dikNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Go Pilato Barabath lony. Ku wën cï yen apuruuk yɔ̈ɔ̈k bïk that ku ŋakkë nhom kuɔɔth, ke gɛ̈m ke bïk la piäät tim cï rïïu kɔ̈u. ");
INSERT INTO dikNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Go apuruuk Pilato, Jethu kuaath pan bɛ̈nyŋaknhom. Ku jɔl apuruuk ëbën gɔ̈ɔ̈m piny. ");
INSERT INTO dikNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ku dɛ̈kkë aläthke bei ku rukkë alanh thith lual yekɔ̈u. ");
INSERT INTO dikNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ku cuëckë kou ku ŋɛk kek yenhom, ku tɛ̈ɛ̈ukë wai ciinden cuëc. Ku gutkë kenhiɔl piny yenhom bïk nyuɔɔth ciɛ̈t leckë ku buikë, “Mädho Bɛ̈nyŋaknhom, Bɛ̈ny Itharel.” ");
INSERT INTO dikNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ku ŋuutkë guɔ̈p ku yuupkë nhom wai. ");
INSERT INTO dikNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Wën cï kek ye jal bui këlä, ke dɛ̈k alanh wën bei, ku dhukkë aläthke yekɔ̈u. Ku kuathkë bïk la piäät tim cï rïïu kɔ̈u. ");
INSERT INTO dikNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Tɛ̈wën le kek tɛ̈ ye kɔc la nɔ̈k thïn, ke räm kek mony cɔl Thaimon raan pan Thirene, gokë dɔm riɛl bï tim cï rïïu ket. ");
INSERT INTO dikNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ku ɣeetkë tɛ̈ cɔl Golgotha. (Ku wɛ̈tde yic, gɔn la gueŋ-ŋeŋ cït apen nhom raan.) ");
INSERT INTO dikNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ku gɛ̈mkë Jethu muɔ̈n abiëc cï liääp wäl kec cɔl gal bï dek, nawën thiëëp ke kuec ye. ");
INSERT INTO dikNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Gokë piäät tim cï rïïu kɔ̈u, ku cuɛtkë gɛk bïk aläthke tek kamken. ");
INSERT INTO dikNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ku jɔlkë rëër bïk tiit. ");
INSERT INTO dikNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ku jɔlkë awuɔ̈c yekë tak ke cï Jethu looi gɔ̈t yenhom nhial tim cï rïïu kɔ̈u ëlä, “KËNË Ë JETHU BƐNYŊAKNHOM ITHAREL.” ");
INSERT INTO dikNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ku piɛ̈ɛ̈tkë cuɛ̈r karou kek Jethu tiim cï rïïu kɔ̈ɔ̈th aya, raan tök lɔŋ cuëc ku raan tök lɔŋ cam. ");
INSERT INTO dikNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ku jɔl kɔc ke ye tëëk tɛ̈wën, Jethu aa cuiit ku latkë ku luelkë, ");
INSERT INTO dikNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Cie yïn wäär ye lueel lɔn bï yïn luaŋ Nhialic thuɔ̈r piny ku buth nïn kadiäk! Kony rot tɛ̈ ye yïn Manh Nhialic! Bäär piny tim cï rïïu kɔ̈u!” ");
INSERT INTO dikNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ku bui kɔc käk Nhialic, ku kɔc gät lööŋ ku kɔcdït baai. ");
INSERT INTO dikNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ee kɔc kɔ̈k kony ku cïï rot kony! Cie yen Bɛ̈nyŋaknhom Itharel? Cɔl abɔ̈ piny tim cï rïïu kɔ̈u ëmën, ku abuk jäl gam! ");
INSERT INTO dikNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Yeen ë Nhialic ŋɔ̈ɔ̈th, cɔl ajɔl Nhialic kony ëmën tɛ̈ wïc yen ye. Rin aye lueel ëlä, ɣɛn ë Manh Nhialic.” ");
INSERT INTO dikNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Agut cuɛ̈r awën cï piäät tiim kɔ̈ɔ̈th kek ye, ee yekë tɔɔn guɔ̈p aya. ");
INSERT INTO dikNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Nawën akɔ̈l ciɛl yic ke muɔ̈ɔ̈th loi rot ɣet tääŋ akɔ̈l pan awën. ");
INSERT INTO dikNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Nawën tääŋ akɔ̈l ke Jethu cöt röldït, “Eli, Eli, lama thabakthanï?” Ku wɛ̈tde yic, “Nhialicdiɛ̈, Nhialicdiɛ̈, yeŋö pɛ̈l yïn ɣa wei.” ");
INSERT INTO dikNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nawën piŋ kɔc kɔ̈k ke kääc ë tɛ̈në, ke luelkë, “Mony kënë acɔl Elija.” ");
INSERT INTO dikNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Go raan tök kat ku lut alath muɔ̈n wac yic, ku tɛ̈ɛ̈u wai thok ku ɣɔɔk Jethu thok. ");
INSERT INTO dikNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ku lueel kɔc kɔ̈k, “Titku buk tïŋ lɔn bï Elija bɛ̈n bï bɛ̈n kony!” ");
INSERT INTO dikNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ku jɔl Jethu keŋ apɛi ku thou. ");
INSERT INTO dikNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Kaam wën ka alanh ye gɛ̈ɛ̈ŋ bï luaŋ Nhialic tek yic alɔŋ thïn rɛɛt yic rou, jɔɔk nhial ɣeet piny. Ku loi ayiɛ̈ɛ̈kyiɛ̈ɛ̈k dït rot ku ɣɛr piny yic. ");
INSERT INTO dikNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ku ŋany rɛ̈ŋ kenhïïm, ku gup kɔc juëc, kɔc path wäär cï thou aacï bɛ̈n pïr ku jɔtkë röt. ");
INSERT INTO dikNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ku wën cï Jethu rot jɔt, ke jiël rɛ̈ŋ nhïïm ku lek Jeruthalem ku nyuthkë röt kɔc juëc. ");
INSERT INTO dikNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nawën tïŋ bɛ̈ny apuruuk ku apuruukken ke tit Jethu, ayiɛ̈ɛ̈kyiɛ̈ɛ̈k piny ku käk cï röt looi ëbën ke riɔ̈c apɛi, ku luelkë, “Yeen ë Manh Nhialic guɔ̈p alanden.” ");
INSERT INTO dikNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Diäär juëc aake tɔ̈ thïn, ku keek aake daai tɛ̈mec. Wäär rëër Jethu Galilia, ë ye diäärkä buɔɔth bïk miëth aa looi tënë ye. ");
INSERT INTO dikNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Kam ë diäärkä, Maria Magdalena ku Maria man Jemith ku Jothep, ku jɔl a man wɛ̈ɛ̈t Dhubedï aake tɔ̈ thïn aya. ");
INSERT INTO dikNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Wën col piny, ke mony ajak gen Arimatheo cɔl Jothep cï wɛ̈t Jethu gam bɔ̈. ");
INSERT INTO dikNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ku ler tënë Pilato ku thiëëc guɔ̈p Jethu bï la thiɔ̈k. Go Pilato lɛ̈k apuruuk bïk gäm ye. ");
INSERT INTO dikNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Go Jothep guɔ̈p Jethu bɛ̈ɛ̈i piny tim kɔ̈u ku der alanh ɣer, ");
INSERT INTO dikNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ku tɛ̈ɛ̈u raŋ cï wec kuur yic. Ku lɔɔr kuur dïttet raŋ thok ku jiël. ");
INSERT INTO dikNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Magdalena ku Maria dɛ̈ɛ̈të aake cï nyuc ke cï kenhïïm wɛ̈l raŋ. ");
INSERT INTO dikNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Nawën aköl Dätem aköl bɔ̈ aköl Dhiëc cök, ke kɔcdït käk Nhialic ku kɔc akut Parathï la tënë Pilato, ");
INSERT INTO dikNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ku luelkë, “Bɛ̈ny, acuk tak, wäär pïr aluenh kënë ëcï lueel ëlä, ‘Ɣɛn abï bɛn pïr nïn kadiäk cök.’ ");
INSERT INTO dikNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Këya, lɛ̈k apuruuk bïk raŋ tiit apath ɣet aköl ye nïn diäk, rin bï kɔcken ye buɔɔth guäpde cïï kual ku törkë tënë kɔc lɔn cï ye jɔt thou yic. Ku luenh ciëën abï dït apɛi tënë luenh tueŋ.” ");
INSERT INTO dikNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Go Pilato lɛ̈k ke, “Calkë apuruuk bïk raŋ la tiit apath cït tɛ̈ wïc wek ye thïn.” ");
INSERT INTO dikNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Gokë la ku buthkë raŋ thok ku thanykë thok ë kiɛ̈nden ku tɛ̈ɛ̈ukë apuruuk raŋ nhom bïk tiit. ");
INSERT INTO dikNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Naɣɔn nhiäk rial aköl Nhialic ke Maria Magdalena ku Maria dɛ̈ɛ̈të, la bïk raŋ la neem. ");
INSERT INTO dikNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ku kaam awën ka ayiɛ̈ɛ̈kyiɛ̈ɛ̈k piny dït apɛi loi rot, ku bɔ̈ atuny Nhialic ku lɔɔr alɛl wei raŋ thok, ku nyuuc yenhom, ");
INSERT INTO dikNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ke ceŋ alɛ̈th ɣer apɛi la toptop, ku dɛ̈p nyin cït ye deŋ biɛr. ");
INSERT INTO dikNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Go apuruuk puɔ̈th jiɛth ku riɔ̈ɔ̈ckë apɛi abïk ril wei ciɛ̈t kɔc cï thou. ");
INSERT INTO dikNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Go atuny Nhialic jam tënë diäär ku lueel, “Duɔ̈kkë riɔ̈c, aŋiɛc wek aa wïc Jethu wäär cï piäät tim cï rïïu. ");
INSERT INTO dikNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Aliu tɛ̈n, acï rot jɔt cït tɛ̈wäär cï luɛ̈l ye. Bäk, tiɛ̈ŋkë tɛ̈wäär cï ye tääu thïn. ");
INSERT INTO dikNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Lackë la bäk la lɛ̈k kɔcken ye buɔɔth, ‘Lɔn cï yen rot jɔt raŋ yic ku ala Galilia bïk la rɔ̈m thïn.’ Lak lɛ̈kkë ke këya.” ");
INSERT INTO dikNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Go diäär jäl raŋ nhom ke ban kekɔ̈ɔ̈th ke cï riɔ̈ɔ̈c, ku keek ke mit puɔ̈th aya, bïk thok riɛɛŋ tënë kɔcken ye buɔɔth. ");
INSERT INTO dikNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Kaam awën ke Jethu räm ke ke ku lueel, “Bï dɔ̈ɔ̈r arëër kek we.” Gokë bɛ̈n tënë ye ku cuɛtkë röt piny yenhom ku dɔmkë cök ku dorkë. ");
INSERT INTO dikNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Go Jethu lɛ̈k ke, “Duɔ̈kkë riɔ̈c,” “Lak lɛ̈kkë wämäthkiɛ̈ bïk lac la Galilia tɛ̈ bï ɣok la rɔ̈m thïn.” ");
INSERT INTO dikNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Tɛ̈wën ŋoot diäär dhël yic ke la geeu, ka apuruuk abɛ̈k, apuruuk ke tit raŋ yiic, la geeu ku lek bäny lɛ̈k käk cï röt looi ëbën. ");
INSERT INTO dikNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Go bäny Itharel amat cɔɔl. Nawën cïk kë cï rot looi jääm yic, ke matkë yic bïk apuruuk gäm wëëu juëc apɛi, ");
INSERT INTO dikNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ku bïk lueel, “Lɔn ë niin kek nawën ke kɔc Jethu buɔɔth bɔ̈ wakɔ̈u ku kualkë guäpde ɣo nin. ");
INSERT INTO dikNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ku na piŋ Bɛ̈nyŋaknhom ë wɛ̈t kënë, ke ɣok aabï jam ke ye bï ciɛ̈n kërɛɛc yök we.” ");
INSERT INTO dikNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Go apuruuk wëëu dɔm ku jɔlkë wɛ̈t awën cï bäny ke kuɔ̈ɔ̈t thook aa lueel. Ku jɔl wɛ̈tden thiëi kɔc Itharel yïth. Ku ë yen kë yekë lueel agut ya aköl. ");
INSERT INTO dikNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nawën ke kɔcken ye buɔɔth kathiäär ku tök lööny dhöl bïk la Galilia. Ku lek gɔt nhom tɛ̈ cï Jethu lɛ̈k ke bï kek la rɔ̈m thïn. ");
INSERT INTO dikNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Tɛ̈wën tïŋ kek ye ke dorkë, ku kɔc kɔ̈k keyiic aake diu ciɛ̈t cie Jethu ayic. ");
INSERT INTO dikNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Go Jethu rot cuɔ̈t ke ku lueel, “Ɣɛn acï yiëk riɛl nhial ku piny. ");
INSERT INTO dikNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Lak pinynhom ëbën ku lɛ̈kkë kɔc wɛ̈tdiɛ̈. Ku miackë kenhïïm Rin Wun, ku Wënde ku Wëi Nhialic, ");
INSERT INTO dikNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ku piɔ̈ɔ̈ckë ke bïk käjuëc ca lɛ̈k we gam. Ku muɔ̈kkë wenhïïm lɔn ɣɛn abï rëër kek we akölaköl ɣet thök ë piny.”");
INSERT INTO dikNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Wɛ̈t kënë ë Wɛ̈t Puɔth Yam rin Jethu raan cï lɔc ku dɔc Wën Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","4","Wäär këc Jethu piɔ̈ɔ̈cde guɔ jɔɔk Joon raan kɔc muɔɔc nhïïm ëcï piɔ̈ɔ̈cde jɔɔk roor tɛ̈ cïï ceŋ. Ku wëët kɔc ëlä, “Pälkë luɔi kärɛc, ku calkë röt aa muɔc nhïïm rin bï adumuɔ̈ɔ̈mkun päl piny tënë we.” Ku tueŋ ëcï Ithaya raan käk Nhialic tïŋ gɔ̈t ku lueel ëlä, “Tɛ̈ ler yïn, ɣɛn abï raan tök kam kɔc käkkiɛ̈ luɛɛl cɔl alëk kɔc, bïk yïïn tiit.” Ku ben Nhialic lueel aköl dɛ̈t ëlä, “Raan käkkiɛ̈ tïŋ abï kë cït lɔ̈ɔ̈r gut yic bï yen kɔc caal tɛ̈de ë rot, ku lëk keek ëlä, ‘Guiɛrkë dhël ë Bɛ̈ny, luɔikë dhɔ̈lke bïk la cök.’ ” Tɛ̈ɛ̈n, go Joon kɔc aa piɔ̈ɔ̈c tɛ̈de ë rot. Nawën gamkë wɛ̈tde ke muɔɔc nhïïm, ku ye lɛ̈k ke ëlä, “Pälkë luɔi adumuɔ̈ɔ̈m ku calkë röt aa muɔc nhïïm, yen abï Nhialic adumuɔ̈ɔ̈mkun päl piny.” ");
INSERT INTO dikNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Kɔc juëc pan Judia ku gen Jeruthalem aacï wɛt tënë ye, ku lekkë adumuɔ̈ɔ̈mken, ku jɔl Joon ke muɔɔc nhïïm wär Jordan. ");
INSERT INTO dikNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Joon ë ye ceŋ alɛ̈th cï looi nhiëm thɔ̈rɔ̈l, ku ceŋ gɔɔp yen aŋum, ku mïïth ke ye cam aa kɔryɔm ku kiëc. ");
INSERT INTO dikNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ku ë ye lɛ̈k kɔc, “Raan bï bɛ̈n ë nïn thiɔ̈kkä adït ku aril tënë ɣa apɛi. Ɣɛn acïï thöŋ kek ye, nadë ke ɣa cɔk guŋ ba warke dɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Wek aaya muɔɔc nhïïm pïu, ku yeen abï we muɔɔc nhïïm Wëi Nhialic.” ");
INSERT INTO dikNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ye nïnkä yiic ke Jethu bɔ̈ gen Nadharet tɔ̈ pan Galilia tënë Joon, ku muɔɔc Joon nhom wär Jordan. ");
INSERT INTO dikNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tɛ̈wën bï Jethu bei wïïr, ke tïŋ nhial ke liep rot ku tïŋ Wëi Nhialic ke bɔ̈ yenhom ke cït kuur ë dit. ");
INSERT INTO dikNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ku piŋ röl Nhialic nhial ke lueel, “Yïn ë manhdiɛ̈n nhiaar, ɣɛn amit puɔ̈u ke yï.” ");
INSERT INTO dikNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Kaam awën ke Wëi Nhialic la yeguɔ̈p ku ɣɛ̈th roor tɛ̈ cïï ceŋ. ");
INSERT INTO dikNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ku jɔl Jethu rëër roor tɛ̈ cïï ceŋ nïn thiärŋuan kek lääi, ku ë ye jɔŋrac them. Ku atuuc nhial aacï bɛ̈n ku konykë. ");
INSERT INTO dikNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Wën cï Joon dɔm, ke Jethu dhuk pan Galilia ku le kɔc piɔ̈ɔ̈c Wɛ̈t Puɔth Yam. ");
INSERT INTO dikNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ke ye lueel, “Aköl la cök acï bɛ̈n, bääny Nhialic athiɔ̈k! Pälkë luɔi kärɛc ku gamkë Wɛ̈t Puɔth Yam.” ");
INSERT INTO dikNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Tɛ̈wën kuɛny Jethu wär Galilia yɔu, ke tïŋ amɛ̈i karou, Thaimon kek Andria wämënh ke dɔm rec buɔi. ");
INSERT INTO dikNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Go Jethu lɛ̈k ke, “Biathkë ɣa ku wek aba piɔ̈ɔ̈c bäk kɔc aa dɔm.” ");
INSERT INTO dikNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Gokë biaiken nyääŋ piny nyin yic ku buɔthkë Jethu. ");
INSERT INTO dikNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Wën le Jethu tueŋ tɛ̈thin-nyɔɔt, ke tïŋ Jemith wën Dhubedï ku Joon wämënh ke tɔ̈ riäi yic ke guir biaiken. ");
INSERT INTO dikNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Go Jethu ke cɔɔl bïk jäl ke ye. Gokë wunden Dhubedï nyääŋ piny riäi yic kek kɔc cïk riɔp, ku buɔthkë Jethu. ");
INSERT INTO dikNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Gokë la Kapernaum. Nawën aköl cïï kɔc Itharel ye luui, ke Jethu la tɛ̈ ye kɔc Itharel kenhïïm mat thïn ku piööc. ");
INSERT INTO dikNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Go kɔc gäi ë piɔ̈ɔ̈cde, rin aacï piɔ̈ɔ̈c apath ke la riɛl Nhialic, cïï thöŋ kek kɔcken piööc ë lööŋ. ");
INSERT INTO dikNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Kaam thiin awën, ke raan tɔ̈ kam kɔc tɛ̈n amat kɔc Itharel, ke la guɔ̈p jɔŋrac, jam ke cï yeröl jɔt apɛi ëlä, ");
INSERT INTO dikNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yeŋö wïc tënë ɣo Jethu raan gen Nadharet? Ca bɛ̈n ba ɣo bɛ̈n rac? Yïn aŋiɛc, yïn ë raan puɔth la cök bɔ̈ tënë Nhialic.” ");
INSERT INTO dikNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Go Jethu jɔŋrac duɔ̈m thok piny, “Biɛt, ku bäär bei yeguɔ̈p!” ");
INSERT INTO dikNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Go jɔŋrac mony awën lath ku wit piny, ku bïï bei yeguɔ̈p ke dhiau. ");
INSERT INTO dikNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Go kɔc gäi apɛi ku thiëckë röt, “Yeŋö kënë? Ye piööc yam kek riɛl Nhialic. Mony kënë ala riɛl ye yen jak yɔ̈ɔ̈k ku gamkë wɛ̈tde aya!” ");
INSERT INTO dikNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Këya, lɛc ku piathde aacï guɔ thiëi piny pan Galilia ëbën. ");
INSERT INTO dikNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Kaam awën jiël kek tɛ̈n amat kɔc Itharel, ke Jethu ku Jemith ku Joon la pan yï Thaimon kek Andria. ");
INSERT INTO dikNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nawën ɣeetkë baai ke yök man tiŋ Thaimon piiny ke cï tɔ̈c, ke cï juäi göök. Gokë lɛ̈k Jethu. ");
INSERT INTO dikNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Go Jethu la tënë ye ku dɔm cin ku dɔɔc ku kony bï rot jɔt. Go juäi guɔ päl piny, ku bïï miëth tënë ke. ");
INSERT INTO dikNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Wën cï akɔ̈l lööny piny, ke kɔc guëër tënë Jethu kek kɔc tuany, ku kɔc la gup jakrɛc. ");
INSERT INTO dikNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ku jɔl kɔc juëc geeu kenhïïm kut ɣöt thok. ");
INSERT INTO dikNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Go Jethu kɔc juëc awën la gup tuɛny juëc cï bɛ̈ɛ̈i tënë ye kony bïk pial. Ku cop jakrɛc juëc wei kɔc gup. Ku cïï jakrɛc päl bïk jam rin ŋic kek ye. ");
INSERT INTO dikNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Naɣɔn nhiäk riɛl, akëc piny bak, ke Jethu jɔt rot ku jiël baai. Ku le tɛ̈de ë rot bï la röök. ");
INSERT INTO dikNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Go Thaimon kek kɔc kɔ̈k Jethu buɔɔth bïk la wïc. ");
INSERT INTO dikNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Nawën lek yök, ke luelkë, “Raan ëbën awïc yï.” ");
INSERT INTO dikNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Go Jethu bɛ̈ɛ̈r, “Lokku bɛ̈ɛ̈i kɔ̈k tɔ̈ tueŋ yiic, ku ba la piööc thïn aya, yen ee kën bïï ɣɛn.” ");
INSERT INTO dikNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ku jɔl Jethu pan Galilia kuany yic ke piɔ̈ɔ̈c ɣɔ̈nken amat yiic, ku cop jakrɛc wei. ");
INSERT INTO dikNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tɛ̈wën kuɛny Jethu bɛ̈ɛ̈i yiic ke piɔ̈ɔ̈c, ke raan cï tuet bɔ̈ tënë ye, ku gut yenhiɔl piny ku lɛ̈ŋ, “Aŋiɛc alëu ba ɣa kony bɛ̈ny, ba pial. Kony ɣa.” ");
INSERT INTO dikNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Go Jethu ŋääŋ nyinde tïŋ ku wïc bï kony. Ku jɔt yecin ku gɔɔt ku lueel, “Awiëc, piaalë!” ");
INSERT INTO dikNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Kaam thiin awën, ke tuet jiël. ");
INSERT INTO dikNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ku jɔl Jethu cɔl alɔc jäl ku thɔn apɛi ëlä, ");
INSERT INTO dikNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Duk kënë la lɛ̈k raan dɛ̈t. Lɔɔr ku nyuɔ̈th rot raan käk Nhialic bï caath, ku juar käŋ cït tɛ̈ ye löŋ Mothith ye luɛɛl thïn, bï kɔc ëbën ŋic lɔn cï yïn pial.” ");
INSERT INTO dikNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Go jäl ku ŋot la kë cï rot looi lɛ̈k raan ëbën. Ku thiëi wɛ̈t piny abï Jethu cïï bɛn la geeu ke ŋic. Ku ye rëër tɛ̈de ë rot tɛ̈ cïn yic kɔc ë rëër thïn. Go kɔc juëc ŋot ke ye bɛ̈n tënë ye baai yic ëbën. ");
INSERT INTO dikNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nïn juëc cök, ke Jethu ben dhuk Kapernaum. Go guɔ piŋ lɔn cï yen dhuk baai. ");
INSERT INTO dikNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Go kɔc juëc wɛt tënë ye abï ciɛ̈n tɛ̈ lääu, ye cök cak la piny ɣööt agut ɣöt thok aɣeer. Ku Jethu ë piööc kɔc Wël Puɔth Yam ë Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tɛ̈wën ke raan aduany ke ket kɔc kaŋuan bïï tënë Jethu. ");
INSERT INTO dikNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nawën cïn tɛ̈ ɣɛ̈th kek ye tënë Jethu, rin cï ɣöt thok thiäŋ kɔc, gokë la ku ŋanykë ɣöt nhom lɔŋ awën rëër Jethu thïn. Ku luɛɛckë raan aduany piny yenhom. ");
INSERT INTO dikNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Tɛ̈wën tïŋ Jethu gamdït tɔ̈ ke ke, ke lueel tënë mony aduany, “Manhdiɛ̈, adumuɔ̈ɔ̈mku aacï päl piny.” ");
INSERT INTO dikNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Go kɔc piööc lööŋ kɔc Itharel ke tɔ̈ thïn, jäl tak ku luelkë kepuɔ̈th, ");
INSERT INTO dikNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Yeŋö ye mony kënë jam këlä. Adhäl Nhialic! Yeŋa adumuɔ̈ɔ̈m päl piny? Ciɛ̈t ë Nhialic ë rot.” ");
INSERT INTO dikNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Go Jethu käk yekë tak guɔ ŋic ku lueel, “Yeŋö ye wek ye tak lɔn lueel ɣɛn lueth? ");
INSERT INTO dikNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ye kënɛn ril yic ë käkkä yiic ba lueel tënë raan aduany, ‘Adumuɔ̈ɔ̈mku aacï päl piny,’ Tɛ̈dë ke luɛɛl, ‘Jɔt rot ku löm biɔ̈ŋdu ku cathë?’ ");
INSERT INTO dikNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Aba nyuɔ̈th we ëmën lɔn Manh Raan ala riɛl pinynhom ba adumuɔ̈ɔ̈m päl piny.” Ku lueel tënë mony aduany, ");
INSERT INTO dikNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Alɛ̈k yï, jɔt rot ku kuany biɔ̈ŋdu ku lɔɔr baai.” ");
INSERT INTO dikNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Go rot jɔt ku kuɛny biɔ̈ŋde ke dɛɛi kek ëbën. Kënë acï raan ëbën gɔ̈i. Ku leckë Nhialic ku luelkë, “Ɣok aakëc këcït kënë kaŋ tïŋ.” ");
INSERT INTO dikNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Nawën ke Jethu ben dhuk wär Galilia yɔu. Go kɔc juëc apɛi bɛ̈n tënë ye. Goke piɔ̈ɔ̈c. ");
INSERT INTO dikNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Wën ben yen la tueŋ ke dhuk geeu, ke tïŋ raan ajuër kut cɔl Lebï Alpawuth ke rɛ̈ɛ̈r tɛ̈den luɔi. Go Jethu lɛ̈k ye, “Buɔth ɣa.” Go rot jɔt ku buɔɔth. ");
INSERT INTO dikNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Tɛ̈wën mïth Jethu pan Lebï, kek kɔc juëc ajuër kut, ku kɔc kɔ̈k la gup anyon, ke kɔcken ye buɔɔth ku kɔc juëc kɔ̈k ye buɔɔth aya, aake mïth kek ye ë tök. ");
INSERT INTO dikNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Wën tïŋ kɔc piööc lööŋ, kɔc akut Parathï ye, ke mïth kek kɔc la gup adumuɔ̈ɔ̈m ku kɔc ajuër kut, gokë kɔcken ye buɔɔth thiëëc, “Yeŋö ye bänydun mïth kek kɔc ajuër kut ku kɔc kɔ̈k la gup adumuɔ̈ɔ̈m?” ");
INSERT INTO dikNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Wën piŋ Jethu wɛ̈t kënë, go lɛ̈k ke, “Acie kɔc puɔl kek akïïm wïc, aa kɔc tuany. Ɣɛn akëc bɛ̈n ba kɔc path bɛ̈n cɔɔl, aa kɔc la gup adumuɔ̈ɔ̈m.” ");
INSERT INTO dikNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ye nïnkä, kɔc Joon raan kɔc muɔɔc nhïïm buɔɔth ku jɔl aa Parathï, aake la nïn ye kek thek bïk cïï mïth. Go kɔc kɔ̈k bɛ̈n tënë Jethu ku thiëckë, “Ɣok kɔc abiöth Parathï ku abiöth Joon ɣok aa thek, ku yïïn ku kacku wek aacie thek, yeŋö?” ");
INSERT INTO dikNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Go Jethu bɛ̈ɛ̈r ku lueel, “Yakë wïc bï kɔc cï bɛ̈n ruääi yic rëër ke cïï mïth? Acie tɛ̈de! Na rɛ̈ɛ̈r raan thiëk ke ke, ka cïk loi këya. ");
INSERT INTO dikNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Aköl bï athiëëk dɔm ku nyɛɛi keyiic, yen aköl bï kek thek. ");
INSERT INTO dikNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Acïn raan alanh thiin ë yam buɔ̈ɔ̈p alanh thɛɛr kɔ̈u, rin alanh thiin yam abï rot rɔt ku abï abaŋ alanh thɛɛr rɛ̈t bei. ");
INSERT INTO dikNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ku acïn raan muɔ̈n abiëc ë yam puɔ̈k töny thɛɛr yic, rin muɔ̈n abiëc abï töny puɔ̈t yic, ku riääk muɔ̈n abiëc kek töny kedhie. Ku acïï bï ya këya, muɔ̈n abiëc ë yam adhil puɔ̈k töny yam yic.” ");
INSERT INTO dikNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Naɣɔn aköl cïï kɔc Itharel ye luui, ke Jethu kek kɔcken ye buɔɔth aake cath ke kuany dhël yic kam ë dum. Go kɔc Jethu buɔɔth rap lek cam dhoŋ. ");
INSERT INTO dikNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Go Parathï ke cath ke ke Jethu thiëëc, “Yeŋö ye kacku luui aköl cï löŋdan Itharel pëën bï kɔc cïï ye luui thïn?” ");
INSERT INTO dikNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Go Jethu bɛ̈ɛ̈r, “Kɛ̈ckë kë cï Debit looi wäthɛɛr kaŋ kueen? Wäär nɛ̈k cɔk ye kek kɔcken ke cath ke ye, ku wïckë miëth camkë, ");
INSERT INTO dikNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","go la luaŋ Nhialic ku ciɛm ayum ë yath cï tɔ̈ɔ̈u tënë Nhialic, kënë aloi rot wäär ye Abiathär raandït käk Nhialic. Ayum kënë ee raan käk Nhialic ë rot yen ë ye cam. Ku yeen acï Debit bɛ̈n cam, ku gɛm abak tënë kɔcken awën cath kek ye. Këya, acïn kërɛɛc cï kackiɛ̈ looi aya.” ");
INSERT INTO dikNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ku jɔl Jethu lɛ̈k ke, “Aköl lɔ̈ŋ acï looi ke ye aköl lɔ̈ŋ path tënë raan. Akëc looi bï kɔc röt aa baŋ thïn. ");
INSERT INTO dikNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Këya, Manh Raan ë bɛ̈ny këriëëc ëbën agut aköl ë lɔ̈ŋ.” ");
INSERT INTO dikNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Naɣɔn aköl dɛ̈t, aköl cïï kɔc Itharel ye luui, ke Jethu la tɛ̈n amat kɔc Itharel, ku mony cï cin ruai ë tɔ̈ thïn. ");
INSERT INTO dikNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ku kɔc kɔ̈k aake tɔ̈ thïn, ku ë wïckë bïk tïŋ lɔn bï Jethu mony kënë kony bïk la luɔm, rin cï yen ye kony aköl cïï kɔc ye luui. ");
INSERT INTO dikNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Wën ŋic Jethu kë tɔ̈ kepuɔ̈th, ke lëk mony awën cï cin ruai, “Jɔt rot ku bäär tueŋ tɛ̈n kɔc nhïïm.” ");
INSERT INTO dikNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ku lëk Jethu Parathï ëlä, “Wek kɔc ŋoot nhïïm lööŋ thɛɛr yic, ye kënɛn yic lëu bï looi aköl cïï kɔc ye luui, ye këpath aye kërac, bï raan kony bï pïr, kua pɛ̈l wei bï thou?” Gokë biɛt ëbën. ");
INSERT INTO dikNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Go Jethu ke döt ke cï puɔ̈u riääk apɛi, rin ŋic kek yic ku cïk luel. Ku lëk mony awën cï cin ruai, “Nyoth yïcin.” Go yecin nyooth. Go ciɛɛnde piath. ");
INSERT INTO dikNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Go Parathï, kɔc wïc ye bï Jethu nɔ̈k jäl tɛ̈n amat ku lek tënë kɔc Ɣërot. Ku lek mat ke ke tɛ̈ bï kek Jethu näk thïn. ");
INSERT INTO dikNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Go Jethu jäl kek kɔcken ye buɔɔth ku lek wär Galilia kɔ̈u. Go kɔc juëc pan Galilia ke buɔɔth. ");
INSERT INTO dikNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Wën piŋ kek käjuëc ye Jethu looi, ke kɔc juëc apɛi bɔ̈ tënë ye pan Judia, ku gen Jeruthalem ku Idumiɛ, ku jɔl aa bɛ̈ɛ̈i tɔ̈ wär Jordan kɔ̈u, ayï gen Tire ku Thidon. ");
INSERT INTO dikNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Go Jethu lɛ̈k kɔcken ye buɔɔth bïk riäi guiir tënë ye bï yen la thïn, bïk cïï bɛr piny, ");
INSERT INTO dikNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","rin Jethu ëcï kɔc juëc tuany kony. Go kɔc juëc kɔ̈k tuany wïc bïk la tënë ye bïk la gɔɔt. ");
INSERT INTO dikNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Na tïŋ kɔc la gup jakrɛc ë ke cuɛt röt piny yenhom ku dhiɛɛukë, “Yïn ee Manh Nhialic.” ");
INSERT INTO dikNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Go Jethu jakrɛc yɔ̈ɔ̈k bïk cïï nyooth. ");
INSERT INTO dikNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Go Jethu kɔcken wïc cɔɔl ku jiël ke ke, ku lek gat nhïïm tɛ̈ cïï ceŋ. Wën cï kek ɣet tɛ̈n awën, ");
INSERT INTO dikNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ke kuëny raan thiäär ku rou bei kɔc yiic. Ku ciëk ke ke cɔl atuuc ku lëk ke, “Wek aca kuany bäk rëër ke ɣa. Ku wek aba ya tuɔɔc aɣeer bäk wɛ̈tdiɛ̈ aa la piɔ̈ɔ̈c. ");
INSERT INTO dikNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ku wek aabï la riɛl bäk jakrɛc aa cuɔp wei kɔc gup.” ");
INSERT INTO dikNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Kɔc ke cï Jethu kuany bïk ya atuɔ̈ɔ̈cke aayï, Thaimon (cï Jethu bɛ̈n cäk ke cɔl Pïtɛr.) ");
INSERT INTO dikNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jemith Dhubedï kek wämënh koor cɔl Joon (kek aacï Jethu cäk ke cɔl Boanergeth, ku wɛ̈tde yic kɔc ë mär deŋ.) ");
INSERT INTO dikNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ku Andria, Pilipo, Bartholomeo, Matheo, (cɔl Lebï) Thomath, Jemith wën Alpawuth, Thadawuth, Thaimon, ");
INSERT INTO dikNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ku jɔl a Judath Ithkariöt, raan wäär cï Jethu bɛ̈n luɔm bï dɔm. ");
INSERT INTO dikNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Nawën ke Jethu dhuk Kapernaum. Go kɔc juëc apɛi bɛn buɔɔth abï ciɛ̈n tɛ̈ cɔk yen nhom lääu kek kacke bïk mïth. ");
INSERT INTO dikNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nawën piŋ kɔc ruääi kek Jethu lɔn ye kɔc rɛ̈ɛ̈r kek ye ye lueel, lɔn cïï yen nhom path, gokë la nyaai. ");
INSERT INTO dikNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ku ëcï kɔc kɔ̈k piööc lööŋ Itharel bɔ̈ Jeruthalem lueel, “Ala guɔ̈p riɛl Beldhebul. Ee yen bɛ̈ny jakrɛc, yen ye yiëk riɛl bï ke aa cuɔp wei.” ");
INSERT INTO dikNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Go Jethu ke yɔ̈ɔ̈k, ku thööŋ wɛ̈t ëlä, “Ye jɔŋrac jɔŋ rɛɛc dɛ̈t cuɔp wei këdë. ");
INSERT INTO dikNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Na tek kɔc paan tök keyiic ku thɛ̈rkë kamken, ke pan kënë abï riääk. ");
INSERT INTO dikNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Na tuum dhiënh tök yenhom aya ku thɛ̈rkë kamken ë röt, ke dhiënh kënë abï wɛɛr aya. ");
INSERT INTO dikNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Këya, na tek jakrɛc keyiic ku thɛ̈rkë kamken, ka thök. ");
INSERT INTO dikNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Acïn raan lëu ye bï ɣön raan ril dhoŋ ku nyɛɛi käkke, akɔŋ raan ril kënë dɔm ku der, ku jɔl käk tɔ̈ baai nyaai. ");
INSERT INTO dikNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Wek aa lɛ̈k yic lɔn nadë adumuɔ̈ɔ̈m, ku kärɛc yekë ke looi, ku käk yekë lueel, aa lëu bï ke päl piny ëbën tënë kɔc. ");
INSERT INTO dikNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ku na ye raan Wëi Nhialic yɔ̈ɔ̈k lɔn ye yen jɔŋrac, ka adumuɔ̈ɔ̈mke aacïï kɔŋ päl piny akölriëëc ëbën.” ");
INSERT INTO dikNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ee lueel Jethu këlä ë rin cï kɔc kɔ̈k ye lueel, “Ka la guɔ̈p jakrɛc.” ");
INSERT INTO dikNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Go man Jethu kek wämäthakën ë Jethu bɛ̈n ku kɛ̈ɛ̈ckë aɣeer ku tockë raan bï Jethu la cɔɔl. ");
INSERT INTO dikNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Go kɔc ke rɛ̈ɛ̈r, ke cï ye gööm lɛ̈k ye, “Moor ku wämäthakui aatɔ̈ aɣeer, ku aa wïc yï.” ");
INSERT INTO dikNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Go Jethu bɛ̈ɛ̈r, “Yeŋa ë ma ku wämäthakäi? ");
INSERT INTO dikNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ku kë wiëc bäk ŋic, kɔc rɛ̈ɛ̈r kek ɣa aa nhiaar, aa cït paan ë ma. ");
INSERT INTO dikNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kuat raan wɛ̈t Nhialic looi yen ë wämääth, ku nyankäi ku ma.” ");
INSERT INTO dikNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Go Jethu bɛn piööc wär Galilia yɔu. Nawën le kɔc juëc apɛi gööm, ke la riäi yic ë pïu thook ku nyuuc thïn, ku jɔl kɔc ëbën nyuc piiny ë pïu thook aɣeer. ");
INSERT INTO dikNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ku jɔl Jethu kɛ̈ŋ aa lueel bï yen kɔc piɔ̈ɔ̈c käjuëc, ku lɛ̈k ke. ");
INSERT INTO dikNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Piɛŋkë! Raan puɔ̈r ëcï la dom bï la pur. ");
INSERT INTO dikNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ke wën yen rap wɛɛr dom yic, ke kɔ̈th abɛ̈k lööny dhël yic. Go diɛt bɛ̈n ku tetkë ke. ");
INSERT INTO dikNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ku lööny kɔ̈th kɔ̈k alɛl nhom tɛ̈ koor tiɔp thïn. Gokë guɔ cil. ");
INSERT INTO dikNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Nawën la akɔ̈l ruɛl apɛi ke rap awën go yom, ku riɛɛukë rin këc mɛiken ɣet piny apath. ");
INSERT INTO dikNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ku lööny kɔ̈th abɛ̈k tɛ̈ ye tiim la kuɔɔth cil thïn, na la tiim juäk ke dec rap ku cïk lok apath. ");
INSERT INTO dikNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ku lööny kɔ̈th kɔ̈k tiɔm path yic, ku ciilkë apath ku dïïtkë ku lokkë apath. Rap abɛ̈k aake cï luɔk ke thoi nhïïm, ku kɔ̈k ke thööŋ röt, ku rap kɔ̈k ke dït nhïïm.” ");
INSERT INTO dikNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ku wit Jethu lɔ̈ŋde ëlä, “Piɛŋkë tɛ̈ le wek yïth.” ");
INSERT INTO dikNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Nawën cï kɔc juëc jäl, go atuɔ̈ɔ̈cke kathiäär ku rou, ku kɔc ke cï döŋ kek ye, thiëc bï kɛ̈ŋ teet yiic tënë ke. ");
INSERT INTO dikNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Go lɛ̈k ke, “Wek aacï nyuɔ̈th kë cï rot moony ë bääny Nhialic yic, ku kɔc kɔ̈k këc gam aabï käŋ ŋic tɛ̈ lɛ̈k ke kɛ̈ŋ, ");
INSERT INTO dikNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","këya, rin na cɔk alɔn ye kɔckä daai, ka cïï käŋ bï tïŋ. Ku na cɔk alɔn ye kek wɛ̈t piŋ, ka cïk bï deet yic. Na ke bï röt waar, ŋuɔ̈t aa käŋ tïŋ ku detkë keyiic. Ku ŋuɔ̈t aacï röt thɔ̈n Nhialic, ku pɛ̈l wɛ̈t piny tënë ke.” ");
INSERT INTO dikNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Go Jethu lɛ̈k ke, “Na këckë kääŋ kënë deet yic ke wek aacïï kɛ̈ŋ kɔ̈k bï deet yiic. ");
INSERT INTO dikNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Kɔ̈th cï com aa cït wɛ̈tdiɛ̈n ya piɔ̈ɔ̈c tënë we. ");
INSERT INTO dikNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Kɔc kɔ̈k aa cït kɔ̈th cï lööny dhël yic, ye diɛt ke tet. Tɛ̈ piŋ kek wɛ̈t Nhialic, ke jɔŋrac bɔ̈ ku nyɛɛi wɛ̈t awën kepuɔ̈th ku mɛ̈rkë nhïïm wɛ̈t ë Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Kɔc kɔ̈k aya aa cït kɔ̈th cï lööny alel la nhom tiɔm koor ye rap guɔ yom thïn, rin këc mɛiken ɣet piny. Ku kɔc kɔ̈k aacït kɔ̈th cï com alɛl nhom, aa löŋ Nhialic gam nyin yic ke mit puɔ̈th. ");
INSERT INTO dikNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ku aacie kepuɔ̈th ye dɛɛt, aa wɛ̈t Nhialic guɔ wai wei tɛ̈ looi aliääp rot, ku tɛ̈ yɔŋ ke rin wɛ̈t Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Kɔc kɔ̈k aya aa cït kɔ̈th cï lööny tɛ̈ ye tiim la kuɔɔth cil thïn, keek aa wɛ̈t Nhialic piŋ, ");
INSERT INTO dikNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ku käjuëc ke diir, rin pïr pinynhom ë tɛ̈n, nhiɛ̈r jiɛɛk, ku käpuɔth yekë wïc aa bɛ̈n thïn, ku rɛckë löŋ Nhialic kepuɔ̈th. ");
INSERT INTO dikNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ku kɔc kɔ̈k aa cït kɔ̈th cï puur tiɔm path yic, keek aa löŋ Nhialic piŋ ku gamkë apɛi, ku käjuëc path aaye yök tënë ke, cïmën rap cï ŋiɛc luɔk ke thoi nhïïm, ku rap kɔ̈k ke thööŋ kenhïïm ku kɔ̈k ke dït nhïïm.” ");
INSERT INTO dikNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ku ben ke thiëëc, “Le raan cï mermer kaŋ ɣäth ɣöt ku kum nyin, nadë ke tɛ̈ɛ̈u agen tɔ̈c cök, cie tɔ̈ɔ̈u ɣöt ciɛl yic? ");
INSERT INTO dikNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kuat kë cï thiaan, aŋot bï rot nyuɔɔth, ku wɛ̈t Nhialic aŋot bïk piɔ̈ɔ̈c. ");
INSERT INTO dikNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Piɛŋkë, tɛ̈ le wek yïth!” ");
INSERT INTO dikNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ku ben lɛ̈k ke ëlä, “Tɛ̈ ye wek kɔc kɔ̈k luɔɔi thïn yen ë tɛ̈ bï Nhialic we luɔɔi thïn aya. Dɛtkë käk yakë ke piŋ! ");
INSERT INTO dikNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Rin raan la këdäŋ abï bɛn muɔɔc, ku na ye raan cïn këdäŋ, ke këthiin ye tak lɔn tɔ̈ yen tënë ye, abï nyaai aya.” ");
INSERT INTO dikNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ku la Jethu tueŋ ku lueel, “Bääny Nhialic ë duɛ̈r thöŋ kek kënë. Monytui ëcï kɔ̈th wɛɛr dom yic. ");
INSERT INTO dikNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ee rëër akölaköl ku kɔ̈th awën cï com aa la tueŋ ke cil ë röt, ke pïr ku dïïtkë ku akuc kën ë ke looi këya. ");
INSERT INTO dikNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kɔ̈th ëbën aa cil piiny tiɔp yic. Käu ë kaŋ lou ku bïï yiɛ̈ny tök bei, ku jɔl la tueŋ ke dït agut tɛ̈ bï yen deer ku ɣeer ku lok. ");
INSERT INTO dikNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ku tɛ̈ cï kek luɔk aaye tem rin cï tɛ̈n tëmtëm bɛ̈n.” ");
INSERT INTO dikNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ku ben lueel, “Yeŋö buk thɔ̈ŋ bääny Nhialic? Ye kääŋ piath ŋö buk thɔ̈ŋ ye? ");
INSERT INTO dikNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Bääny ë Nhialic acït käu koor nyin cï raan com duɔmde. ");
INSERT INTO dikNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ku na le dït ka la nhial ke loi kër ku yïth dït apɛi, abï diɛt ɣɔ̈ɔ̈tken aa yïk thïn.” ");
INSERT INTO dikNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jethu acï Wɛ̈t Puɔth Yam piööc tënë kɔc ë kɛ̈ŋ cït kɛ̈ŋkä. Aake cï lɛ̈k käjuëc lëukë bïk ke deet yiic. ");
INSERT INTO dikNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ee ye kɔc jääm ë kɛ̈ŋ tɛ̈ piööc yen kɔc, ku na ye yeen ë rot kek kɔcken ye buɔɔth, ka ye tɛ̈t këriëëc ëbën yiic. ");
INSERT INTO dikNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Na aköl dɛ̈t ɣɔnthëëi, ke lëk Jethu atuɔ̈ɔ̈cke, “Lok teemku wär alɔŋtui.” ");
INSERT INTO dikNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Gokë kɔc kɔ̈k nyääŋ piny, ku lek riän awën rëër Jethu thïn yic, ku tëmkë agut Jethu. Ku riëth kɔ̈k ke tɔ̈ thïn aacï tem aya. ");
INSERT INTO dikNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kaam thiin awën ke yomdït apɛi jɔt rot, ku jɔt atiaktiak rot abï riäi duɛ̈r thiäŋ ë pïu. ");
INSERT INTO dikNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Tɛ̈wën looi kënë rot, Jethu ë nin riäi yic ciëën, ke cï yenhom kan. Gokë puɔ̈ɔ̈c ku luelkë, “Bänyda! Ɣok aa muɔu, cïï diɛɛr ë ɣo?” ");
INSERT INTO dikNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Go Jethu rot jɔt ku rël yom, “Lɔ dïl!” Ku rël atiaktiak, “Kääc!” Go yom kɔ̈ɔ̈c ku le dïl. ");
INSERT INTO dikNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ku thiëëc ke, “Yeŋö riɔ̈ɔ̈c wek ciɛ̈t we bï mou? Cäk ŋic lɔn bï ɣɛn we kony?” ");
INSERT INTO dikNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Gokë nhïïm la cɔ̈t riɛldït cït kënë ku jiɛɛmkë kamken, “Ye raan yïndë kënë? Na cɔk a yom ku atiaktiak ë ke piŋ wɛ̈tde!” ");
INSERT INTO dikNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Gokë wär Galilia teem ku lek tɛ̈ cɔl Jeratha. ");
INSERT INTO dikNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Kaam wën kɛɛc Jethu piny riäi yic, ke tïŋ mony la guɔ̈p jakrɛc, ke bɔ̈ bei rɛ̈ŋ nhïïm. ");
INSERT INTO dikNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mony kënë ë ye rëër rɛ̈ŋ nhïïm, ku acïn raan ye lëu bï rɛ̈ɛ̈k. ");
INSERT INTO dikNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ee ye rɛ̈ɛ̈k cök ku cin arak juëc, ku ŋot ke tueny, ku dhoŋ luɔ̈ŋ kɔ̈th yecök. Ee ril apɛi, acïn raan ye lëu bï rɛ̈ɛ̈k. ");
INSERT INTO dikNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Aköl ku wɛ̈ɛ̈r thok ëbën, ee ye cool ku ruu kat rɛ̈ŋ nhïïm, ke looi duɔɔt ku ye rot dɛɛny aleel bï rot nɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Wën tïŋ yen Jethu tɛ̈mec, ke lor ku cuɛt rot piny yenhom, ");
INSERT INTO dikNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","ku lueel Jethu, “Jɔŋrac, bäär bei ë mony kënë guɔ̈p.” Go kiɛɛu looi apɛi, “Jethu Wën Madhɔl, yeŋö wïc ba looi tënë ɣa? Yïn aläŋ ë rin Nhialic duk ɣa tëm awuɔ̈c.” ");
INSERT INTO dikNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Go Jethu jäl thiëëc, “Cɔl yï ŋa?” Go bɛ̈ɛ̈r, “Ɣɛn aa kut rin ɣok ajuëc.” ");
INSERT INTO dikNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ku jɔl mony kënë Jethu ya lɔ̈ŋ bï jakrɛc cïï cop wei tɛ̈den rëër kek thïn. ");
INSERT INTO dikNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ku duut dïr baai ë nyuäth gɔt cök ë tɛ̈n awën. ");
INSERT INTO dikNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Go jakrɛc Jethu lɔ̈ŋ, “Tuɔɔc ɣo ë dïrkä gup, ku cɔl ɣo aa lur keyiic.” ");
INSERT INTO dikNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Goke puɔ̈l, ku jɔl jakrɛc bɛ̈n bei mony awën guɔ̈p ku lek dïr gup. Go duut diëër, kecït tiim karou riŋ agör yic, ku thootkë wïïr ku moukë ëbën. ");
INSERT INTO dikNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Go röör ke biöök dïr kat, ku lek kë cï rot looi lueel tënë kɔc rɛ̈ɛ̈r geeu, ku kɔc tɔ̈ bɛ̈ɛ̈i yiic. Go kɔc ëbën jal wɛt bïk kë cï rot looi la tïŋ. ");
INSERT INTO dikNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Nawën lek ɣet tënë Jethu, ke yök mony wäär la guɔ̈p jakrɛc ke rɛ̈ɛ̈r, ke ceŋ alath, ke la nhom cök. Gokë riɔ̈ɔ̈c. ");
INSERT INTO dikNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Go kɔc ke cï kën cï rot looi tënë mony awën ku dïr tïŋ, la lɛ̈k kɔc kɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ku wën piŋ kɔc baai ë wɛ̈t kënë ë ke riɔ̈c, ku lek tënë Jethu ku läŋkë bï jäl panden. ");
INSERT INTO dikNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Tɛ̈wën le Jethu riäi yic, go mony wën cï Jethu jɔŋrac cɔl ajiël yeguɔ̈p bɛ̈n tënë Jethu, ku lɛ̈ŋ bï cath kek ye. ");
INSERT INTO dikNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Go Jethu jai, ku lëk ye, “Lɔɔr baai tënë kacku ku lɛ̈k ke käjuëc cï Bɛ̈ny looi tënë yï, ku tɛ̈puɔth cï luɔ̈i yï.” ");
INSERT INTO dikNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Go jäl ku le panden Dekapolith la yic gɛu thiäär. Ku kuɛny keyiic ëbën ke ye kɔc lɛ̈k käk cï Jethu looi tënë ye. Go kɔc gäi. ");
INSERT INTO dikNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Wën cï Jethu bɛn tem riäi bï dhuk Kapernaum, ke kɔc juëc apɛi bɔ̈ tënë ye wär yɔu. ");
INSERT INTO dikNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Kaam wën ke raan cɔl Jariöth, bɛ̈ny tɛ̈n amat kɔc Itharel bɔ̈ aya. Nawën tïŋ Jethu, ke cuɛt rot piny yecök. ");
INSERT INTO dikNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ku lɛ̈ŋ, “Nyandiɛ̈n thin koor acï dhal apɛi, athou. Bäär ba yïcin la tääu yenhom bï pial.” ");
INSERT INTO dikNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Go Jethu gam ku lööny dhöl kek ye. Ku buɔth kɔc juëc ke, ke cïk kum apɛi. ");
INSERT INTO dikNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ku tiŋ tuany, cïï thɛ̈kde kɔ̈u ye tɛɛm ruɔ̈ɔ̈n thiäär ku rou, ee tɔ̈ kɔc yiic, ");
INSERT INTO dikNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ku yeen ëcï wëëu juëc gäm akïm rin bï tuaanyde ŋuɛ̈ɛ̈n, ku tuaanyde akëc ŋuɛ̈ɛ̈n, ëcï rot jal juak. ");
INSERT INTO dikNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ku yeen ëcï käk ye Jethu looi piŋ. Go bɛ̈n Jethu kɔ̈u ku gɔɔt alanhde, ");
INSERT INTO dikNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","rin ëcï jam ë rot yepuɔ̈u ëlä, “Na gaat alanhde, ke ɣɛn abï pial.” ");
INSERT INTO dikNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Kaam thiin awën ke riɛm cïï ben kuër, ku yök rot ke cï pial. ");
INSERT INTO dikNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Go Jethu yök lɔn cïï riɛl jäl yeguɔ̈p. Go yenhom wel ku thiëëc kɔc, “Yeŋa cä alanhdiɛ̈ gɔɔt?” ");
INSERT INTO dikNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Go kɔcken ye buɔɔth lɛ̈k ye, “Yïn ë kɔc juëc tïŋ ke cï yï kum ku ye thiëc, Yeŋa cä gɔɔt?” ");
INSERT INTO dikNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Go Jethu ŋot döt kɔc bï tïŋ yeŋa cï ye looi. ");
INSERT INTO dikNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Wën ŋic tiŋ awën tuany ye ke tuaany cï jäl yeguɔ̈p, go bɛ̈n tënë Jethu ke cï riɔ̈ɔ̈c, ke lɛth, ku gut yenhiaal piny Jethu nhom. Ku lëk ye lɔn ë yen cï ye gɔɔt. ");
INSERT INTO dikNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Go Jethu lueel tënë ye, “Nyaandiɛ̈, gamdu acï kony ba pial, lɔɔr, kek dɔ̈ɔ̈r.” ");
INSERT INTO dikNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Kaam wën jiɛɛm Jethu, ke kɔc rïŋ pan Jariöth ku lëkkë ye, “Nyaandu acï ɣet wei, duk raan piööc ben rääm nhom.” ");
INSERT INTO dikNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ku Jethu ë këc kë cïk lueel kuɛ̈ɛ̈c nhom, ku lɛ̈k ye, “Duk riɔ̈c, dɛɛt yïpuɔ̈u ku gam wɛ̈t yic.” ");
INSERT INTO dikNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ku ë cïn kɔc juëc cïï puɔ̈l bïk cath kek ye, ee Pïtɛr ku Jemith ku Joon kepɛ̈c. ");
INSERT INTO dikNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Tɛ̈wën ɣeet kek pan Jariöth ke Jethu yök kɔc ke näk röt, ke dhiau apɛi. ");
INSERT INTO dikNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ku ler ɣöt ku lëk ke, “Yeŋö nɛ̈k wek röt? Ye dhiëndïït ŋö kënë? Meth akëc thou, anin.” ");
INSERT INTO dikNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Gokë dɔl guɔ̈p. Go Jethu ke cɔl ala aɣeer, ku cɔɔl wun meth kek man meth ku kɔcken awën kadiäk, ku lek ɣöt tɛ̈wën cï meth tääc thïn. ");
INSERT INTO dikNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ku dɔm cin ku lëk ye, “Nyan thiin, alɛ̈k yï, jɔt rot!” ");
INSERT INTO dikNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Go rot jɔt nyin yic ku ciɛth. Go kɔc awën tɔ̈ ɣööt kek Jethu gäi apɛi wën tïŋ kek kë cï rot looi (ë ye run thiäär ku rou.) ");
INSERT INTO dikNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ku thɔn Jethu ke bïk cïï lëk kɔc kɔ̈k. Ku lëk ke bïk yiëk miëth. ");
INSERT INTO dikNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Go Jethu jäl tɛ̈den awën ku ler gɛnden Nadharet, ku buɔɔth kɔcken ye buɔɔth. ");
INSERT INTO dikNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nawën aköl ë lɔ̈ŋ, ke piɔ̈ɔ̈c tɛ̈n amat. Ku kɔc juëc aake tɔ̈ thïn. Nawën piŋkë piɔ̈ɔ̈cde ke gɛ̈i, ku luelkë, “Cï käŋ bɛ̈n aa ŋic nɛn?” “Ku ye käkkä looi këdë? ");
INSERT INTO dikNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Yen ë raan guëŋguëŋ tiim, ku ë wën Maria, ku ë mɛ̈nh ë Jemith, ku Jothep, ku Jut ku Thaimon. Ku cie nyiɛ̈rakën kä rɛ̈ɛ̈r ë tɛ̈n kek ɣo?” Ku jɔlkë jai bïk piɔ̈ɔ̈cde cïï gam. ");
INSERT INTO dikNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Go Jethu lɛ̈k ke, “Raan cï Nhialic lööny yeguɔ̈p aye baai ëbën theek, ka kɔc gɛnden ku kɔc ruääi kek ye, ku paan wun kek paan man kek aacïï ye ye theek.” ");
INSERT INTO dikNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","Ku akëc lëu bï käk jäŋ gɔ̈i looi, ka kɔc tuany lik kek aacï yen yecin tääu kenhïïm, ku kony ke bïk pial. Ee cï gäi apɛi rin këc kek ye gam. Go Jethu jäl ku ler bɛ̈ɛ̈i kɔ̈k yiic ku le kɔc piɔ̈ɔ̈c thïn. ");
INSERT INTO dikNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ku tuum atuɔ̈ɔ̈cke ku tooc ke wei, bï kɔc karou aa cath ë tök bïk aala piööc Wɛ̈t Puɔth Yam ë Nhialic, ku yïk ke riɛl bïk kek kɔc aala kony. ");
INSERT INTO dikNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ku lëk ke apɛi. “Duɔ̈kkë muk ë mïïth yakë cam dhël yic, muɔ̈kkë ke wɛi kepɛ̈c. ");
INSERT INTO dikNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Cɛŋkë war ku duɔ̈kkë muk alɛ̈th kɔ̈k.” ");
INSERT INTO dikNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ku lëk ke aya, “Yakë rëër pan ye we lor thïn ɣet tɛ̈ bï wek jäl. ");
INSERT INTO dikNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ku na lak pan cïï we lor thïn, ku pan cïï wɛ̈lkun ye piŋ thïn, ke we jiël ku tɛŋkë wecök. Ku abï nyooth lɔn cï wek kuec ë ke!” ");
INSERT INTO dikNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ku jiëlkë ku lek kɔc piɔ̈ɔ̈c bïk luɔi adumuɔ̈ɔ̈m puɔ̈l. ");
INSERT INTO dikNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ku copkë jakrɛc juëc wei, ku tɔckë kɔc juëc tuany nhïïm. Ku röökkë bï ke kony bïk pial. ");
INSERT INTO dikNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ku bɛ̈ny Antipäth Ɣërot ëcï wɛ̈t piŋ rin cï ke Jethu ŋic apɛi. Ku ë ye kɔc kɔ̈k lueel, “Joon raan kɔc muɔɔc nhïïm acï bɛn pïr, ee yen ale yen riɛl yen käkkä looi.” ");
INSERT INTO dikNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ku lueel kɔc kɔ̈k, “Mony kënë adhil a Elija raan wäär käk Nhialic tïŋ.” Ku ben kɔc kɔ̈k lueel, “Ee raan tök kam kɔc thɛɛr, kɔc käk Nhialic tïŋ.” ");
INSERT INTO dikNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ku wën piŋ Antipäth Ɣërot ë wɛ̈t kënë go lueel, “Ee Joon raan kɔc muɔɔc nhïïm wäär ca cɔl atök yeth yen acï jɔt thou yic.” ");
INSERT INTO dikNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Antipäth Ɣërot ëcï Joon cɔl anäk këlä, ee cï cɔl adɔm ku rek, ku cɔl amac rin wɛ̈t Ɣërodia tiŋ Pilipo wämënh cï rum bï ya tiɛŋde, ");
INSERT INTO dikNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","rin cï Joon ye lueel tënë ye ëlä, “Acïï path ba tiŋ wämuuth rum ke pïr.” ");
INSERT INTO dikNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ku Ɣërodia ëcïï puɔ̈u mit tënë Joon rin ë wɛ̈t kënë. Ku wïc diɛ̈t nɛ̈k ku cïï lëu, ");
INSERT INTO dikNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","rin Ɣërot ë riɔ̈c Joon, rin ye Joon raan puɔth wɛ̈t Nhialic, ku kony bï ciɛ̈n kë näk ye. Nawën piŋ Ɣërot wɛ̈t Joon, ke gɛ̈i apɛi ku ŋot nhiɛɛr bï wël Joon aa piŋ. ");
INSERT INTO dikNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nawën ke Ɣërodia jɔl tɛ̈ bï yen Joon näk thïn yök, ku ë ye aköl looi Antipäth Ɣërot yan akölden dhiëëth ye, tënë kɔcken dït mɛc kek baai, ku bäny apuruuk ku jɔl aa kɔcdït pan Galilia. ");
INSERT INTO dikNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ku nyan Ɣërodia nhom guɔ̈p, ee cï bɛ̈n yɛɛi bï bɛ̈n dier. Go Ɣërot kek jäälke puɔ̈th miɛt apɛi tënë ye. Go Antipäth Ɣërot bɛ̈ny lɛ̈k ë nyan ëlä, “Na le ke wïc, ke luel tënë ɣa ku ba gäm yï.” ");
INSERT INTO dikNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ku kuëëŋ tënë ye jɔ̈ɔ̈l nhïïm ku lueel, “Kuat këdun ba thiëëc tënë ɣa aba dhiɛl yiëk yï, cɔk alɔn ë yen abaŋ ë bäänydiɛ̈.” ");
INSERT INTO dikNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Go nya la aɣeer ku lëk man, “Yeŋö ba thiëëc?” Go man lueel, “Lɛ̈k ye bï Joon raan kɔc muɔɔc nhïïm tök yeth, ku gɛ̈m yï nhiamde ba bɛ̈ɛ̈i.” ");
INSERT INTO dikNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Go nya dhuk tënë bɛ̈ny nyin yic ku lueel, “Yïn awiëc ba gäm nhom Joon raan kɔc muɔɔc nhïïm tɛ̈n ëmën thiin, ke cï tääu aduɔ̈k yic!” ");
INSERT INTO dikNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Kënë acï bɛ̈ny rac puɔ̈u apɛi, ku akëc kuec rin cï yen mël kuëëŋ ë jɔ̈ɔ̈l nhïïm. ");
INSERT INTO dikNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Go bɛ̈ny apuruɔ̈kde tooc nyin yic, ku lëk ye bï nhom Joon raan kɔc muɔɔc nhïïm bɛ̈ɛ̈i. Go apuruk la tɛ̈wën mɛc yen thïn ku tök yeth. ");
INSERT INTO dikNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ku bïï nhom ke cï tääu aduɔ̈k yic, ku yïk nya, ku jɔl nya gäm man. ");
INSERT INTO dikNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nawën piŋ kɔc Joon buɔɔth lɔn cï ye nɔ̈k, gokë la ku nyɛɛikë guäpde ku thiäkkë. ");
INSERT INTO dikNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Kɔc Jethu buɔɔth aake ye bɛ̈n yenhom ku lëkkë käk cïk looi, ku käk cïk piɔ̈ɔ̈c ëbën. ");
INSERT INTO dikNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kɔc juëc apɛi aake ye wääc, kɔc jiël ku kɔc bɔ̈ tënë Jethu bï ke bɛ̈n kony, abï Jethu kek atuɔ̈ɔ̈cke cïï lääu bïk cak mïth. Go lɛ̈k atuɔ̈ɔ̈cke, “Jiëlku buk la tɛ̈ cïn yic kɔc buk la lɔ̈ŋ.” ");
INSERT INTO dikNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Gokë jäl ë riäi ë röt bïk la tɛ̈ cïï ceŋ, ku aake këc kɔc lɛ̈k tɛ̈ ler kek thïn. ");
INSERT INTO dikNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Go kɔc juëc ke tïŋ, ku ŋickë ke. Gokë miööt gɛɛth yiic ku riŋkë tueŋ ke kuany wär kɔ̈u, ke la tɛ̈wën cï Jethu kek atuɔ̈ɔ̈cke kenhïïm wɛl thïn. Ku ye kek kɔŋ ɣet tɛ̈wën. ");
INSERT INTO dikNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Wën kɛɛc Jethu piny riäi yic, ke tïŋ kɔc juëckä. Go wïc bï ke kony rin acï tïŋ kecït amɛ̈l pap cïn nhïïm abiöök. Ku jɔlke piɔ̈ɔ̈c käjuëc. ");
INSERT INTO dikNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nawën col piny, ke kɔcken ye buɔɔth bɔ̈ tënë ye ku luelkë, “Piny acï cuɔl ku tɛ̈n ë ror cïn kë kuany thïn, ");
INSERT INTO dikNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","cɔl kɔc aa jiël bïk la bɛ̈ɛ̈i yiic bïk la ɣɔɔc miëth camkë.” ");
INSERT INTO dikNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Go bɛ̈ɛ̈r, “Miackë ke ë miëth.” Gokë lɛ̈k ye, “Wïc buk ayuɔ̈p lëu ë kɔc kithkä ɣɔɔc tënë ke bïk ke cam? Aa wïc wëëu juëc apɛi.” ");
INSERT INTO dikNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Go Jethu ke thiëëc, “Ye ayuɔ̈p kadë tɔ̈ thïn? Lak bäk ke la tïŋ.” Gokë dhuk ku lëkkë ye, “Aa yuɔ̈p kadhiëc ku rec karou.” ");
INSERT INTO dikNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Go lɛ̈k ke bïk kɔc cɔl anyuc piiny akuut noon tɔ̈c nhom. ");
INSERT INTO dikNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Gokë nyuc piiny akuut buɔt ku akuut thiärdhiëc. ");
INSERT INTO dikNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Go ayuɔ̈p awën kadhiëc ku rec karou lööm, ku döt nhial ku leec Nhialic. Ku bɛny ayuɔ̈p yiic ku gɛ̈m ke kɔcken ye buɔɔth bïk ke tek agut rec, tënë kɔc. ");
INSERT INTO dikNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ku mïthkë abï miëth ke göök. ");
INSERT INTO dikNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ku jɔl kɔcken ye buɔɔth awuthueei ayuɔ̈p ku rec cï döŋ piny kuany gääc kathiäär ku rou. ");
INSERT INTO dikNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Kɔc ke cï mïth ëbën, röör röt aake ye tiim kadhiëc. ");
INSERT INTO dikNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kaam thin awën, ke Jethu yöök kɔcken ye buɔɔth bïk la riäi yic, ku lek tueŋ yenhom agör alɔŋtui gen cɔl Bethaida. Ku cɔl thɛ̈i ajiël. ");
INSERT INTO dikNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Wën cï yen kɔc tɔ̈ɔ̈ŋ, ke jiël bï la gɔt nhom bï la röök. ");
INSERT INTO dikNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nawën la thëi bɛ̈n, ke atuɔ̈ɔ̈cke aake ŋoot ë riäi yic wär ciɛl yic, ku yeen ë rot agör nhom. ");
INSERT INTO dikNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Goke tïŋ ke cï gök gɛ̈r ë riäi rin cï kek kenhïïm wɛ̈l yom. Nawën bääk ë piny, ke bɔ̈ tënë ke ke cath pïu nhïïm, ku ë wïc bï ke waan thook. ");
INSERT INTO dikNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ku wën tïŋ kek ye ke cath wïïr pïu nhïïm, ke tïŋkë kecït atïm raan cï thou, ku dhiɛɛukë, ");
INSERT INTO dikNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","rin ë cïk tïŋ kedhie ku riɔ̈ɔ̈ckë. Go guɔ jam tënë ke ku lueel, “Dɛɛtkë wepuɔ̈th, ee ɣɛn Jethu, duɔ̈kkë riɔ̈c.” ");
INSERT INTO dikNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ku mɛt rot riäi yic tënë ke. Go yom kɔ̈ɔ̈c. Gokë gäi apɛi, ");
INSERT INTO dikNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ë rin këc kek kënë ayuɔ̈p wäär cï gäm röör tiim kadhiëc deet yic, rin ril kek nhïïm. ");
INSERT INTO dikNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Nawën aköl dɛ̈t cï kek wär teem, ke ɣet Jenetharet tɔ̈ agör nhom ku dɔmkë riäi. ");
INSERT INTO dikNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nawën bïkkë bei ë riäi yic, go Jethu guɔ ŋic kɔc ëbën. ");
INSERT INTO dikNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Gokë kat ku riŋkë bɛ̈ɛ̈i yiic ku lek kɔc tuany kɛ̈t, ku ɣɛ̈thkë ke tɛ̈ cï kek ye piɛŋ thïn. ");
INSERT INTO dikNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ku kuat tɛ̈n cï Jethu la thïn ëbën, bɛ̈ɛ̈i yiic ku gɛɛth yiic, kɔc juëc tuany aake ye tääc tënë ɣɔɔc ku dhɔ̈l yiic, ku läŋkë bïk gɔɔt, cɔk alanhde thok ë path. Ku kuat raan cï ye gɔɔt ëbën, ee ye pial. ");
INSERT INTO dikNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Wën cï Parathï kek kɔc piööc lööŋ kɔc Itharel, ke cï bɛ̈n Jeruthalem Jethu gɔ̈ɔ̈m piny. ");
INSERT INTO dikNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ke tïŋ kɔc Jethu buɔɔth ke mïth ke këc kecin lɔɔk apath, bïk ajuɛ̈ɛ̈c nyaai kegup cït tɛ̈ ye kɔc Itharel ye luɔɔi thïn. ");
INSERT INTO dikNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Kɔckä aake cï kë cï atuuc Jethu looi rac puɔ̈th, rin kɔc Itharel kek Parathï, aake cïï ye mïth tɛ̈ këc kek kecin kaŋ lɔɔk kecït ciɛɛŋ thɛɛr kɔcken dït. ");
INSERT INTO dikNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ku na le mïïth cïk la bɛ̈ɛ̈i geeu, ka cïk cam ke këckë kaŋ lɔɔk kɔ̈th. Ku keek aake ye käk cï kɔcken dït thɛɛr lɛ̈k ke looi, cïmën lɔ̈k bïïny ku töny ku aduuk ë miëth. ");
INSERT INTO dikNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Go Parathï ku kɔc piööc ë lööŋ Jethu thiëëc, “Yeŋö cïï kɔckun yï buɔɔth ye ceŋ ë ciɛɛŋ wärkuan dït, ku yekë mïïth juääk ke këc kecin lɔɔk?” ");
INSERT INTO dikNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Go Jethu bɛ̈ɛ̈r, “Ithaya acï yic lueel ë riɛnkun lɔn ye wek awëŋ puɔ̈th rou, ku gɛ̈t ëlä, ‘Kɔckä aa ɣa leec kethook ku aliu kepuɔ̈th. ");
INSERT INTO dikNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Keek aa ɣa door ku acie duɔ̈ɔ̈r ë yic, rin keek aa kɔc piööc lööŋ ciɛɛŋ wärkuan dït ciɛ̈t ke ye lɔ̈ɔ̈ŋkiɛ̈!’ ");
INSERT INTO dikNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Ee yic, wek aacït kɔc ye Ithaya jam ë riɛnken. Wek aacï kuec lööŋ Nhialic ku ye lööŋ ciɛɛŋdun kek yakë gam.” ");
INSERT INTO dikNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ku lëk Jethu ke, “Ayakë tak lɔn ë yen këpath yen cäk looi ye wek kuec lööŋ Nhialic, ku muɔ̈kkë ciɛɛŋdun thɛɛr. ");
INSERT INTO dikNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Rin acï Mothith lueel, ‘Thek wuur kek moor, ku na ye raan wun kek man jääm gup kärɛc, ka dhil nɔ̈k bï thou.’ ");
INSERT INTO dikNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ku ayakë lueel aya lɔn ye yen yic, bï raan wun kek man jäi tɛ̈ wïc kek këpïïr kek tënë ye, ‘Acïn tɛ̈ kuɔ̈ny we, rin ɣɛn acï Nhialic gäm kën ba yiëk we.’ ");
INSERT INTO dikNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ke wek aa kuec bï käkkä cïï loi tënë wun ku man. ");
INSERT INTO dikNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Këya, tɛ̈ ye wek kɔc piɔ̈ɔ̈c thïn acïï thöŋ kek wël ye Nhialic lueel. Ku wek aa kärɛc juëc kɔ̈k cït käkkä looi aya.” ");
INSERT INTO dikNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Go Jethu kɔc juëc bɛn cɔɔl ku lëk ke, “Piɛŋkë wɛ̈tdiɛ̈ wedhie ku dɛtkë yic. ");
INSERT INTO dikNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Acie kë ye raan cam, yen ye cɔl aye raan rac, aa käk ye tak ku käk ye lueel, ku käk ye looi kek aaye cɔl aye raan rac.  ");
INSERT INTO dikNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Piɛŋkë tɛ̈ le wek yïth.” ");
INSERT INTO dikNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Wën cï yen kɔc nyääŋ piny aɣeer ku ler ɣöt, ke thiëëc kɔcken ye buɔɔth bï wɛ̈t awën cï lueel teet yic tënë ke. ");
INSERT INTO dikNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Go lɛ̈k ke, “Cäk käŋ ye deet yiic aya? Acie miëth ye raan cam yen ye cɔl ala guɔ̈p adumuɔ̈ɔ̈m, ");
INSERT INTO dikNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","rin acie la yepuɔ̈u, ee la yeyäc ku le bɛ̈n bei.” Këya, acï Jethu nyuɔɔth lɔn miëth ëbën apath. ");
INSERT INTO dikNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ku ben lɛ̈k ke, “Aa käk ye raan tak ku looi ke, kek aa rɛc. ");
INSERT INTO dikNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Rin puɔ̈u yen aye kärɛc ye looi bɛ̈n bei thïn, cïmën bal ku ruɔ̈ɔ̈m, ku nääk raan ë path, ku kɔ̈r diäär. ");
INSERT INTO dikNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Ku kook ku wëëŋ ku nhiam ku tiɛɛl, ku yïk yepuɔ̈u kënë raandä, ku luɔɔm ku kuat kärɛc ëbën. ");
INSERT INTO dikNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Käkkä ëbën aa bɛ̈n bei raan puɔ̈u, ku looi ke ku rɛckë ye.” ");
INSERT INTO dikNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ku jɔl Jethu jäl ku ler wundɛ̈t tɛ̈thiääk kek Tire ku Thidon, ku ler ɣöt. Ku cïï wïc bï la raan ŋic ye. Ku akëc lëu bï thiaan. ");
INSERT INTO dikNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Go tiŋ la nyanden koor ŋot këc kuäc cï jɔŋrac la yeguɔ̈p, Jethu piŋ. Go bɛ̈n tënë ye ku gut yenhiaal piny Jethu nhom. ");
INSERT INTO dikNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Tiŋ kënë ë ye jam thoŋ Gïrïk, ku ee nyan pan Ponicia. Go bɛ̈n ku lɛ̈ŋ Jethu ëlä, “Bɛ̈ny, cɔk a lɔn cï ɣɛn ye tiŋ pandun ke yï bɔ̈ ba jɔŋrac cuɔp wei nyaandiɛ̈ guɔ̈p.” ");
INSERT INTO dikNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Go Jethu lueel, “Ɣɛn ɣa cïï bɔ̈ ba miëth mïth bɛ̈n gäm jɔ̈k. Acie yic bï miëthden yiëk jɔ̈k, ke këc kuɛth.” ");
INSERT INTO dikNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Go bɛ̈ɛ̈r, “Ee yic Bɛ̈ny, ku jɔ̈k rɛ̈ɛ̈r tɛ̈ mïth kɔc thïn awuthueei cï lööny piny kuany.” ");
INSERT INTO dikNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Go Jethu lɛ̈k ye, “Rin cï yïn ye ŋiɛc bɛ̈ɛ̈r këya, dhuɔ̈k baai, yïn abï jɔŋrac yök ke cï jäl nyaandu guɔ̈p!” ");
INSERT INTO dikNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Go dhuk baai ku yök nyaande ke cï tɔ̈c biöök yic, ku jɔŋrac ke cï jäl yeguɔ̈p. ");
INSERT INTO dikNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Go Jethu jäl Tire ku dhuk wär Galilia ke kuany gɛɛth kathiäär Dekapolith yiic ku Thidon. ");
INSERT INTO dikNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tɛ̈wën ke kɔc kɔ̈k bïï raan cï miŋ tënë Jethu, ku läŋkë bï gɔɔt. ");
INSERT INTO dikNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Go Jethu nyaai kɔc yiic ku ɣɛ̈th tɛ̈de ë rot, ku tɛ̈ɛ̈u yecin yeyïc, ku ŋuut ku gɔɔt liep. ");
INSERT INTO dikNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ku döt nhial ku wëëi apɛi ku lɛ̈k ye, “Piɛ̈ŋë!” ");
INSERT INTO dikNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Kaam thiin awën, ke ɣɔ̈r yïth ku jiɛɛm. ");
INSERT INTO dikNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ku yöök Jethu kɔc awën tɔ̈ thïn bïk cïï lëk raan dɛ̈t. Ku ŋot lek lueel. ");
INSERT INTO dikNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ku kɔc cï ye piŋ aacï gäi apɛidït ku luelkë, “Mony cɔl Jethu kënë acï këriëëc ëbën lëu. Kɔc cï miŋ aa piŋ ëmën, ku kɔc ke cie jam, aacï ya jam aya.” ");
INSERT INTO dikNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ye nïnkä, ke kɔc juëc mat kenhïïm. Nawën cïn miëth ke Jethu cɔl kɔcken ye buɔɔth ku lueel, ");
INSERT INTO dikNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ɣɛn acï guɔ̈p ŋɔ̈ŋ, rin kɔckä aacï rëër kek ɣa nïn kadiäk ëmën, ku acïn kë camkë. ");
INSERT INTO dikNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Na cal ke aa dhuk bääiken yiic, ke cïn kë cïk cam, ka la wïïk dhël yic, rin kɔc kɔ̈k aabɔ̈ tɛ̈mec.” ");
INSERT INTO dikNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Go kɔcken ye buɔɔth lɛ̈k ye, “Ye tɛ̈nɛn roor ë tɛ̈n bï raan miëth yök thïn bï kɔc juëckä cam?” ");
INSERT INTO dikNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Go Jethu ke thiëëc, “Lak ayuɔ̈p kadë?” Gokë lueel, “Aa dhorou.” ");
INSERT INTO dikNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","7","Go lɛ̈k thän awën bïk nyuc piiny. Ku lööm ayuɔ̈p awën kadhorou ku rec thii lik ku röök Nhialic, ku bɛny keyiic, ku gɛ̈m ke kɔcken ye buɔɔth bïk ke tɛ̈k kɔc. Gokë looi këya. ");
INSERT INTO dikNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Ku jɔl thän awën, kecït tiim kaŋuan mïth bïk kuɛth. Ku jɔl kɔc Jethu buɔɔth awuthueei ayuɔ̈p cï döŋ kuany gääc kadhorou. Ku jɔl Jethu kɔc cɔl ajiël, ");
INSERT INTO dikNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ku ler riäi yic kek kɔcken ye buɔɔth, ku lek pan cɔl Dalmanutha. ");
INSERT INTO dikNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Tɛ̈wën ke Parathï kɔ̈k ben bɛ̈n tënë Jethu ku teerkë wɛ̈t kek ye, ku wïckë bïk deep ë wɛ̈t, gokë yɔ̈ɔ̈k bï kënë jäŋ gɔ̈i looi, bï nyuɔ̈th ke lɔn ye Nhialic wɛ̈lke gam. ");
INSERT INTO dikNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Go Jethu keŋ apɛi ku lueel, “Yeŋö ye riëëc aköl thiëc kënë jäŋ gɔ̈i. Wek alɛ̈k yic. Acïn këcït kënë bï nyuɔ̈th ke.” ");
INSERT INTO dikNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ku nyiëëŋ ke piny, ku dhuk riäi yic, bï teem wär alɔŋtui. ");
INSERT INTO dikNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Kɔc Jethu buɔɔth aake cï nhïïm määr bïk ayuɔ̈p juëc cïï muk wën ler kek riäi yic, ku mukkë ayuɔ̈m tök giliŋ. ");
INSERT INTO dikNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Go Jethu lɛ̈k ke, “Tiëërkë nhïïm, ku tiɛtkë röt bäk cïï nhiam cïmën Parathï ku Antipäth Ɣërot, nhiaamden ke cɔl ago puɔ̈r cïmën ayum cï yiëk yic luɔu.” ");
INSERT INTO dikNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Gokë jam kamken ëlä, “Ee wɛ̈t kënë lueel rin cïn ɣok ayup.” ");
INSERT INTO dikNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Go Jethu kë luelkë guɔ ŋic, ku thiëëc ke, “Yeŋö ye wek ye tak wek acïn ayup. Cäk käŋ ye tak lɔn bï ɣɛn we muɔɔc ayup. Cäk käŋ ye tïŋ ku dɛtkë keyiic, kua cäk puɔ̈th cɔr? ");
INSERT INTO dikNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Wek aala nyïn, cäk ye daai? Ku wek aala yïth, cäk ye piŋ ku cäk ye tak? ");
INSERT INTO dikNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ye gääc awuthueei kadë cäk bɛ̈n kuany wäär bɛny ɣɛn ayuɔ̈p kathiëc yiic tënë röör tiim kadhiëc?” Gokë bɛ̈ɛ̈r, “Ee gäc thiäär ku rou.” ");
INSERT INTO dikNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Na wäär bɛny ɣɛn ayuɔ̈p kadhorou yiic tënë raan tiim kaŋuan, ye gääc awuthueei ayuɔ̈p cï döŋ piny kadë cäk bɛ̈n kuany?” Gokë lueel, “Aa dhorou.” ");
INSERT INTO dikNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Go Jethu ke thiëëc, “Ku këya ëmën ŋot cäk ye deet lɔn le ɣɛn riɛl ba miëth gäm we?” ");
INSERT INTO dikNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Gokë bɛ̈n Bethaida. Go kɔc kɔ̈k mony cï cɔɔr thɛl tënë Jethu, ku läŋkë bï gɔɔt. ");
INSERT INTO dikNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Go Jethu cɔɔr dɔm cin ku thel wei baai. Nawën cï ŋuɔ̈ɔ̈t nyin, ke tɛ̈ɛ̈u yecin yenyin ku thiëëc, “Le kë ye tïŋ?” ");
INSERT INTO dikNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Go yenhom jɔt ku lueel, “Ɣɛn acie daai apath, ɣɛn ë kɔc tïŋ kecït tiim kek cath.” ");
INSERT INTO dikNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Go Jethu yecin bɛn tääu yenyin, go daai ku tïŋ këriëëc ëbën apath. ");
INSERT INTO dikNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Go Jethu cɔl adhuk paande ku thɔn bï cïï la lɛ̈k kɔc kɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Go Jethu kek kɔcken ye buɔɔth la Cetharia Pilipi. Tɛ̈wën ciɛth kek, ke thiëëc Jethu, “Lɛ̈kkë ɣa, ye jäŋ tak ye ɣɛn ë ŋa?” ");
INSERT INTO dikNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Gokë lueel, “Ayekë lueel lɔn ye yïn Joon raan kɔc muɔɔc nhïïm. Ku lueel kuat dɛ̈t lɔn ye yïn Elija, ku kɔc kɔ̈k ayekë lueel lɔn ye yïn raan töŋ kam kɔc käk Nhialic tïŋ.” ");
INSERT INTO dikNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Goke thiëëc, “Na week yakë lueel lɔn ye ɣɛn ŋa?” Go Pïtɛr bɛ̈ɛ̈r, “Yïïn nhom guɔ̈p, yïn ë Raan cï lɔc ku dɔc.” ");
INSERT INTO dikNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","“Kë ca lueel ë yic Pïtɛr.” Ku lëk ke, “Duɔ̈kkë lëk raan dɛ̈t.” ");
INSERT INTO dikNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Nawën ke jɔl Jethu piɔ̈ɔ̈c ëlä, “Manh Raan abï dhiɛl reem, ku yeen abï kɔcdït baai, ku bäny käk Nhialic ku jɔl aa kɔc piööc lööŋ kɔc Itharel jai, ku näkkë. Ku yeen abï nïn kadiäk nɔ̈k piiny ë raŋ yic, ku ben pïr ku jɔt rot raŋ yic.” ");
INSERT INTO dikNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ku teet kënë yic apath tënë ke. Go Pïtɛr miɛt wei kɔc yiic ku yöök bï cïï ye jam këya. ");
INSERT INTO dikNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Go Jethu yenhom wel ku tïŋ kɔcken ye buɔɔth ku rël Pïtɛr ku lueel, “Jäl ɣalɔ̈ɔ̈m jɔŋrac. Wïc ba käk cï Nhialic guiir waar yiic! Käk ye tak aacie käk Nhialic, aa wël raan ë path.” ");
INSERT INTO dikNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ku jɔl Jethu kɔcken ye buɔɔth cɔɔl ku lɛ̈k ke, “Na le raan wïc bä buɔɔth, ka dhil nhom määr käpuɔth bï yök piɛ̈rde yic pinynhom ë tɛ̈n. Ku dhil puɔ̈u riɛl ku buɔɔth ɣa, cɔk alɔn wïc kɔc kɔ̈k ye bïk nɔ̈k ë riɛnkiɛ̈. ");
INSERT INTO dikNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Rin raan wïc ye bï wɛ̈ike kony aabï muɔ̈r, ku na ye raan mär wɛ̈ike ë riɛnkiɛ̈ ku rin piɔ̈ɔ̈cdiɛ̈, ka bï wɛ̈ike muk akölriëëc ëbën. ");
INSERT INTO dikNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Yeŋö bï raan kuany thin, bï jak apɛi pinynhom ku mɛ̈r wɛ̈ike? ");
INSERT INTO dikNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Pïr wëi akölriëëc apath, acïn kë lëu bï ye waar. ");
INSERT INTO dikNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Na ye raan guɔ̈p yär ɣa ku piɔ̈ɔ̈cdiɛ̈ ë riëëc cïï ye wïc bï wɛ̈t Nhialic gam, ke Manh Raan abï guɔ̈p yär ye aya, aköl dhuk yen kek diik Wun kek atuuc Nhialic.” ");
INSERT INTO dikNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ku le tueŋ ku lueel, “Wek alɛ̈k yic, ala kɔc kɔ̈k rɛ̈ɛ̈r ë tɛ̈n, aacïï bï thou agut tɛ̈ bï kek ɣa tïŋ kek riɛl ye nyuɔɔth lɔn ye ɣɛn bɛ̈ny cï Nhialic lɔc.” ");
INSERT INTO dikNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nawën nïn kadätem cök, ke Jethu cɔl Pïtɛr ku Jemith ku jɔl a Joon, ku lek gɔn bär apɛi nhom kepɛ̈c. Kaam wën röök kek, ke tïŋ Jethu ke cï rot waaŋ, ");
INSERT INTO dikNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ku jɔl aläthke ɣɛr apɛi abïk la diardiar. ");
INSERT INTO dikNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Nawën ë ke tïŋ Elija ku Mothith ke jam kek Jethu. ");
INSERT INTO dikNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Wën cï kek rëër kaam thin-nyɔɔt, go Pïtɛr lɛ̈k Jethu, “Raan piööc, apath buk rëër ë tɛ̈n. Ɣok abï duɛ̈l kadiäk looi, tök tënë yï, ku tök kek Mothith, ku töŋ dɛ̈t kek Elija.” ");
INSERT INTO dikNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Kënë jiɛɛm yen këlä, ee rin kuc yen wɛ̈t pɛth bï lueel, rin këpuɔth cïk tïŋ cï ke nyɔ̈ŋ nhïïm wël. ");
INSERT INTO dikNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Go këcït rur piny paat abï ciɛ̈n tɛ̈ yekë tïŋ, ku piŋkë Nhialic ke jam ëlä, “Kënë ë Wëndiɛ̈n nhiaar, piɛŋkë wɛ̈tde.” ");
INSERT INTO dikNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nawën tïŋkë piny kaam thiin awën, ke ye Jethu yen tïŋkë yetök. ");
INSERT INTO dikNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tɛ̈wën dhuk kek piny gɔt nhom, go Jethu lɛ̈k ke, “Duɔ̈kkë käk cäk tïŋ lëk raan dɛ̈t ɣet aköl bï Manh Raan jɔt raŋ yic.” ");
INSERT INTO dikNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Gokë wɛ̈t Jethu gam, ku jɔlkë röt aa thiëëc ëlä, “Yeŋö wïc Jethu bï lueel wën ye yen jam jön rot ë raŋ yic?” ");
INSERT INTO dikNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ku thiëckë Jethu, “Yeŋö ye kɔc piööc lööŋ ye lueel lɔn ye yen Elija yen bï kaŋ bɛ̈n tueŋ, ku ëmën acï lɔ̈k bɛ̈n yïcök?” ");
INSERT INTO dikNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Go bɛ̈ɛ̈r ëlä, “Ee yic, Elija akɔŋ bɛ̈n tueŋ, rin bï yen dhël bɛ̈n guiir. Ku yeŋö gɛ̈t ye aya, lɔn Manh Raan abï kɔc Itharel jai, ku abïk cɔl arem apɛi? ");
INSERT INTO dikNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Alɛ̈k we lɔn cï Elija bɛ̈n thɛɛr ku acïk luɔɔi tɛ̈den nhiarkë, cït tɛ̈ cï ye gät thïn thɛɛr riɛnke.” ");
INSERT INTO dikNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Nawën dhukkë tënë abiöth Jethu kɔ̈k awën, ke yökkë ke ke cï kɔc juëc apɛi gööm, ku kɔc piööc lööŋ ke teer wël ke ke. ");
INSERT INTO dikNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Tɛ̈wën tïŋ kek Jethu, gokë puɔ̈th miɛt apɛi ku lorkë ku muɔ̈thkë. ");
INSERT INTO dikNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Nawën ɣëët Jethu tënë atuɔ̈ɔ̈cke ke thiëëc, “Yeŋö tɛɛrkë wek ke?” ");
INSERT INTO dikNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Go raan tök thän awën yic wɛ̈t dɛ̈t tɛ̈ɛ̈m thïn ku lueel, “Raan piööc, ɣɛn acï manhdiɛ̈n ca kaŋ bɛ̈ɛ̈i tënë kɔckun yï buɔɔth, bɛn bɛ̈ɛ̈i tënë yï, rin këc kek jɔŋ tɔ̈ yeguɔ̈p lëu bïk cuɔp wei. Yeen acï jɔŋrac la yeguɔ̈p ku ye pɛ̈n jam. ");
INSERT INTO dikNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Tɛ̈ dɔm ë jɔŋ kënë ye, aye wiɛt piny ku yïk thok ayɔ̈k, ku reem yelec ku riny. Ɣɛn acï kɔckun yï buɔɔth thiëëc bïk jɔk cuɔp wei, ku akëckë lëu.” ");
INSERT INTO dikNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Go Jethu lɛ̈k ke, “Wek kɔc cie lac gam, yakë tak ba rëër kek we ɣet nɛn, bäk jäl gam. Bɛ̈ɛ̈ikë dhɔ̈ŋ kënë tënë ɣɛn.” ");
INSERT INTO dikNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Gokë bɛ̈ɛ̈i tënë ye. Kaam wën tïŋ jɔŋrac Jethu, ke lɛth dhɔ̈k ku wit piny ku lɔɔr ku yïk thok ayɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Go Jethu wun thiëëc, “Ye nɛn dɔm jɔŋ kënë ye?” Go bɛ̈ɛ̈r, “Tɛ̈wäär ye yen meth. ");
INSERT INTO dikNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Acï jɔŋ kënë duër nɔ̈k, aye wiɛt mɛɛc, ku le wiɛt wïïr bï duër mou. Na lëu ke yï kony ɣo.” ");
INSERT INTO dikNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Go Jethu lɛ̈k ye, “Yeŋö ye yïn ye lueel, lɔn na lɛ̈u! Ee yic, këriëëc ëbën apuɔl yic tënë raan cï gam.” ");
INSERT INTO dikNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Go wun meth dhiau, “Ɣɛn ala gam ku akoor, kony ɣa bï gamdiɛ̈ rot juak.” ");
INSERT INTO dikNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nawën tïŋ Jethu kɔc juëc ke bɔ̈ tɛ̈thiääk kek ye, ke rël jɔŋrac ku lueel, “Ee yïn jɔŋ miŋ cie jam. Yïn ayɔ̈ɔ̈k, bäär bei dhɔ̈k guɔ̈p, ku duk ben dhuk yeguɔ̈p.” ");
INSERT INTO dikNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Go jɔŋrac dhiau yeröl ku wit piny, ku lɛth, ku bïï bei. Ku jɔl dhɔ̈k anaŋnaŋ piiny abï kɔc kɔ̈k aa lueel, ka cï thou. ");
INSERT INTO dikNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Go Jethu dɔm cin ku kony bï rot jɔt. Go rot jɔt ku kɛ̈ɛ̈c. ");
INSERT INTO dikNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Tɛ̈wën rëër Jethu kek kɔcken ye buɔɔth ë röt, ke thiëckë, “Yeŋö këc ɣok ye lëu buk jɔŋ kënë cuɔp wei?” ");
INSERT INTO dikNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Go lɛ̈k ke, “Jɔŋ cït kënë acäk lëu bäk cuɔp wei. Ee röök ë rot yen ë ye alëu bï jak cït käkkä cuɔp wei.” ");
INSERT INTO dikNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Go Jethu kek kɔcken ye buɔɔth jäl tɛ̈wën ke ke ret pan Galilia yic, ku cïï wïc bï la raan ŋic ye. ");
INSERT INTO dikNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Rin ë nïnkä ë piööc kɔcken ye buɔɔth kë bï rot luɔ̈i ye, “Manh Raan abï thɔ̈n kɔc bï ye nɔ̈k, ku na aköl ye nïn diäk ka bï rot jɔt raŋ yic.” ");
INSERT INTO dikNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ku aa këc wɛ̈tde bɛ̈n deet yic, ku riɔ̈ɔ̈ckë bïk thiëëc. ");
INSERT INTO dikNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Gokë ɣet Kapernaum. Nawën lek ɣet ɣöt, ke thiëc atuɔ̈ɔ̈cke, “Yeŋö kënë tɛɛrkë wën dhël yic?” ");
INSERT INTO dikNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Gokë gup riɔ̈ɔ̈c ku bitkë, rin wën ciɛth kek, aake teer wɛ̈t lɔn, yeŋa kamken yen dït apɛi. ");
INSERT INTO dikNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Go nyuc ku cɔɔl atuɔ̈ɔ̈cke kathiäär ku rou ku lëk ke, “Piɛŋkë, na ye raan wïc ye bï tɔ̈u tueŋ, ka dhil dhuk ciëën ku luui rin kɔc ëbën.” ");
INSERT INTO dikNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ku dɔm meth ku cɔl akääc kenhïïm ku tɛ̈ɛ̈u yecin yekët ku lëk ke, ");
INSERT INTO dikNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Raan manh koor cït manh kënë lor ë riɛnkiɛ̈, acä lor, ku raan ɣa lor, acie ɣɛn ye lor, ee Wä Aciëŋ toc ɣa.” ");
INSERT INTO dikNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Nawën aköl dɛ̈t ke lëk Joon ye, “Raan piööc, ɣok aacï mony dɛ̈t tïŋ keye jakrɛc cuɔp wei kɔc gup ë riɛnku ku acuk pëën rin acie raanda.” ");
INSERT INTO dikNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Go Jethu lueel, “Duɔ̈kkë ye pëën rin raan käŋ looi riɛnkiɛ̈, acïï lëu bï rot guɔ wel ku lëk ɣa kërac. ");
INSERT INTO dikNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Rin raan cïï ɣo man, ee raanda. ");
INSERT INTO dikNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Wek alɛ̈k yic, raan we muɔɔc pïu ë rin ye wek kɔc Raan cï lɔc ku dɔc, abä ariɔ̈pde yök.” ");
INSERT INTO dikNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Na ye raan wëŋ mɛnh tök kam ë mïthkä ku bä maan, ka ŋuɛ̈ɛ̈n tënë ë raan cït kënë, diɛ̈t cï ruɔ̈k yeth alel dït tet, ku pïk wïïr bï mou.  ");
INSERT INTO dikNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","tɛ̈ cïï kämden ë thou thïn, ku mac acie thou akölriëëc ëbën. ");
INSERT INTO dikNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ku na ye ciɛɛndu yï cɔl aloi awuɔ̈c, ke tɛɛm wei, aŋuɛ̈ɛ̈n ba pïr pïr path kek ciɛɛn tök, kek tɛ̈ bï yïn la cin karou ku cuɛt yï pan many cie thou akölriëëc ëbën.  ");
INSERT INTO dikNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","tɛ̈ cïï kämden ë thou thïn, ku mac acie thou akölriëëc ëbën. ");
INSERT INTO dikNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ku na ye cɔ̈ɔ̈kdu yï ɣäth awuɔ̈c yic, ke tɛɛm wei, rin aŋuɛ̈ɛ̈n ba pïr pïr path ke yï ye ŋɔl, kek tɛ̈ bï yïn la cök karou ku cuɛt yï pan mac. ");
INSERT INTO dikNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ku na ye nyiɛndu yï cɔl aloi awuɔ̈c, ke ŋuët bei. Aŋuɛ̈ɛ̈n ba rot mat bääny Nhialic yic kek nyiɛn tök, kek tɛ̈ bï yïn la nyïn karou ku cuɛt yï pan mac. ");
INSERT INTO dikNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ee tɛ̈ɛ̈n arɛɛm yekë yök thïn acie thök, ë rin many pan mac acie many ye yor. ");
INSERT INTO dikNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Raan ëbën abï lɔɔk ë mac cïmën ye ajuër lɔɔk awai. ");
INSERT INTO dikNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Awai apath. Ku na thöök kɔ̈u alɛ̈i ke ben dhuɔ̈k thïn këdë? Rɛ̈ɛ̈rkë kek awan määth kamkun ku lakkë dɔ̈ɔ̈r kamkun. ");
INSERT INTO dikNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Go Jethu jäl tɛ̈wën ku ler Judia ku teem wär Jordan. Go kɔc juëc apɛi bɛn guëër tënë ye. Goke piɔ̈ɔ̈c cïmënden thɛɛr. ");
INSERT INTO dikNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Go Parathï kɔ̈k bɛ̈n tënë ye ku wïckë bïk deep wɛ̈t ku thiëckë, “Na päl raan tiɛŋde ke cïï path?” ");
INSERT INTO dikNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Go Jethu bɛ̈ɛ̈r, “Yeŋö cï Mothith lɛ̈k we wäthɛɛr?” ");
INSERT INTO dikNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Gokë lueel, “Acï Mothith puɔ̈l bï moc athör liɔ̈ɔ̈i gɔ̈t, ku pɛ̈l tik.” ");
INSERT INTO dikNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Go Jethu dhuɔ̈k ke, “Mothith acï löŋ kënë gät we ë rin wärkuan dït aake cie yith ye lac gam. ");
INSERT INTO dikNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ku wäär tueŋ cɛk Nhialic kɔc aacï cak moc ku tik. ");
INSERT INTO dikNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Ku rin ë wɛ̈t kënë raan abï wun ku man nyääŋ piny, ku le ker kek tiɛŋde, ");
INSERT INTO dikNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ku keek karou aabï ya many tök.’ Këya aacïï ben ya rou aa tök. ");
INSERT INTO dikNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Këya, na cï Nhialic ke puɔ̈l bï ya moc ku tik, ka cïn raan päl ŋɛk kamken.” ");
INSERT INTO dikNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ku wën cï kek dhuk baai, ke thiëëc kɔcken ye buɔɔth ë wɛ̈t kënë. ");
INSERT INTO dikNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Go lɛ̈k ke, “Na ye raan liɔ̈i tiɛŋde ku thiɛɛk tiŋ dɛ̈t, ka cï kërac looi tënë tiŋden tueŋ. ");
INSERT INTO dikNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ku na ye tiŋ päl muɔnyde ku le mony dɛ̈t thiaak, ka cï akɔr looi.” ");
INSERT INTO dikNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Kɔc kɔ̈k aake ye mïth bɛ̈ɛ̈i tënë Jethu bï ke bɛ̈n dɔɔc, go kɔc Jethu buɔɔth ke läät. ");
INSERT INTO dikNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Nawën la Jethu kë looi atuɔ̈ɔ̈cke tiŋ, ke dak puɔ̈u ku lueel tënë ke, “Calkë mïth aabɔ̈ tënë ɣa, duɔ̈kkë ke pën. Raan wïc ye bï la bääny Nhialic yic adhil gam cïmën ë mïth thiikä. ");
INSERT INTO dikNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Alɛ̈k we, raan wïc ye bï bääny Nhialic yök adhil wɛ̈t Nhialic gam, cïmën ye manh koor wɛ̈t kɔc ke dhiëth ye gam.” ");
INSERT INTO dikNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ku cɔɔl mïth yelɔ̈ɔ̈m ku tɛ̈ɛ̈u yecin kenhïïm ku dɔɔc ke. ");
INSERT INTO dikNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Tɛ̈wën jiël Jethu geeu, ke raan rïŋ tënë ye ku gut yenhiaal piny ku lueel, “Raan piööc path yeŋö ba looi ba pïr akölriëëc ëbën yök?” ");
INSERT INTO dikNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Go Jethu thiëëc, “Yeŋö yïn ye lueel lɔn ɣɛn apath? Acïn raan path, ee Nhialic ë rot yen apath. ");
INSERT INTO dikNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Yïn aŋic lööŋ Nhialic, ‘Duk raan näk, duk tiŋ raan dɛ̈t kɔr, duk kuëëŋ wɛ̈t lueth, duk cuëër, thek wuur ke moor.’ ” ");
INSERT INTO dikNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Go bɛ̈ɛ̈r, “Raan piööc, lööŋkä aaya theek tɛ̈wäär koor ɣɛn agut cït ëmën.” ");
INSERT INTO dikNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Go Jethu döt apɛi, ku nhiɛɛr ku lueel, “Ee tök yen akɛ̈c looi, lɔɔr ɣaac käkku wei ëbën ku gam wëëu tënë kɔc ŋɔ̈ŋ, yïn abï jiɛɛk la yök pan Nhialic, ku bäär buɔth ɣa.” ");
INSERT INTO dikNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Wën piŋ yen wɛ̈t kënë, ke mɛɛn ku jiël ke cï puɔ̈u dak, rin ë la käjuëc apɛi. ");
INSERT INTO dikNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Go Jethu yenhom wɛ̈l kɔcken ye buɔɔth ku lëk ke, “Abï yic riɛl tënë ajiɛɛk bïk la bääny Nhialic yic.” ");
INSERT INTO dikNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Go kɔcken ye buɔɔth gäi ë wëlkä. Go Jethu bɛn ber yic tënë ke, “Miɛ̈thkiɛ̈, yeŋö ril yen këya bï raan la bääny Nhialic yic! ");
INSERT INTO dikNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Apuɔl yic bï thɔ̈rɔ̈l bak with cök, tënë tɛ̈ bï raan ajak la bääny Nhialic yic.” ");
INSERT INTO dikNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Gokë ŋot ke gäi apɛi, ku thiëckë, “Na ye këya, ke yeŋa bï la pan Nhialic?” ");
INSERT INTO dikNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Go Jethu ke döt ku bëër, “Acïï raan bï lëu ë rot, bï gam tɛ̈ këc Nhialic ye kony, rin Nhialic ë këriëëc ëbën lëu, acïn kë dhal ye.” ");
INSERT INTO dikNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Go Pïtɛr rot jɔt ku lueel, “Na ɣo, ɣok kɔc cï käkkua ëbën nyääŋ piny ku buɔthku yï?” ");
INSERT INTO dikNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Go Jethu bɛ̈ɛ̈r, “Ee yic, ku alɛ̈k we, kuat raan cï panden nyääŋ wei kek paan ë man ku nyiɛ̈rakën, ku wun ku man ku miɛ̈thke ku kacke ëbën ë riɛnkiɛ̈, ku rin wɛ̈t Nhialic, ");
INSERT INTO dikNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","cïï käjuëc bï yök pan Nhialic. Abï bɛ̈ɛ̈i juëc ku wämäthakën ku nyiɛ̈rakën ku märakën juëc, ku mïth ku dum, ku kuɔ̈c ciëëŋ bï ye kuɔ̈c ciëëŋ aabï yök aya arak buɔɔt. Käkkä aabï yök pinynhom ë tɛ̈n, ku abï pïr akölriëëc ëbën yök aköldä. ");
INSERT INTO dikNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ku kɔc juëc tɔ̈ tueŋ ëmën aabï dɔ̈ŋ ciëën, ku kɔc kɔ̈k juëc tɔ̈ ciëën aabï la tueŋ.” ");
INSERT INTO dikNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Naɣɔn aköl dɛ̈t Jethu kek kɔcken ye buɔɔth, ku kɔc kɔ̈k aake kuany dhël yic, ke la Jeruthalem. Ku Jethu ë tɔ̈ tueŋ ku buɔɔth kɔcken ye buɔɔth ke cï nhïïm mum. Ku kɔc awën biöth, ke cï riɔ̈ɔ̈c. Go Jethu atuɔ̈ɔ̈cke kathiäär ku rou bɛn caal tɛ̈den röt, ku lëk ke kë bï rot la looi tënë ye. ");
INSERT INTO dikNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ku lëk ke, “Ëmën, ɣok aala Jeruthalem tɛ̈ bï Manh Raan la dɔm ku ɣɛ̈th bäny Itharel nhïïm, ku kɔc piööc ë lööŋ. Ku abïk tɛ̈m thou, ku thönkë bɛ̈nyŋaknhom Roma mac baai bï la nɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ku abïk läät ku buikë, ku ŋuutkë ku thatkë, ku näkkë, ku na ye nïn kadiäk cök, ka bï pïr ku jɔt rot raŋ yic.” ");
INSERT INTO dikNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Naɣɔn thëëi ke Jemith ku Joon wɛ̈ɛ̈t Dhubedï bɔ̈ tënë Jethu, ku luelkë tënë ye, “Raan piööc, awïcku ba ɣo luɔ̈i kë buk thiëëc tënë yï.” ");
INSERT INTO dikNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Go Jethu ke thiëëc, “Yeŋö wiɛ̈ckë ba looi tënë we?” ");
INSERT INTO dikNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Gokë dhuk ëlä, “Tɛ̈ nyuc yïn thɔ̈nydu nhom diɛɛkdu yic nhial, ke yï cɔl ɣo aa nyuc kek yï, raan tök lɔŋ cuëc, ku raan dɛ̈t lɔŋ cam.” ");
INSERT INTO dikNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Go Jethu lɛ̈k ke, “Wek aa kuc kë thiëckë, ɣɛn abï baŋ apɛi ë nïnkä ku ɣɛn abï nɔ̈k. Lɛ̈ukë bäk gum cïmëndiɛ̈?” ");
INSERT INTO dikNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Gokë bɛ̈ɛ̈r, “Alëuku.” Go Jethu lɛ̈k ke, “Na cɔkkë we nɔ̈k ayic, ka lɛ̈ukë bäk gum, ");
INSERT INTO dikNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ku acie ɣɛn la riɛl ba raan nyuc köŋdiɛ̈n cuëc ku köŋdiɛ̈n cam kuany, ee Nhialic yen abï ke yiëk kɔcken cï guiër ke.” ");
INSERT INTO dikNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nawën le atuuc kɔ̈k kathiäär piŋ, ke riääk puɔ̈th tënë Jemith ku Joon. ");
INSERT INTO dikNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Go Jethu ke cɔɔl ëbën ku lueel, “Aŋiɛckë lɔn kɔc cï gam bïk aa bäny kɔc cie kɔc Itharel aala riɛl kɔc nhïïm, ku acïï path bäk ciɛ̈t ke. ");
INSERT INTO dikNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ku kënë acïï rot bï looi kamkun. Raan wïc ye bï ya raandït kamkun adhil rot dhuɔ̈k piny bï ya luui rin kɔc kɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ku na ye raan wïc ye bï ya bɛ̈ny kɔc nhïïm, ka dhil ya aluaŋ kɔc ëbën. ");
INSERT INTO dikNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Cïmën Manh Raan aya akëc bɛ̈n bï kɔc bɛ̈n loony, acï bɛ̈n bï kɔc bɛ̈n kony, ku gɛm wɛ̈ike bï kɔc juëc waar thou yic.” ");
INSERT INTO dikNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Go Jethu kek kɔcken ye buɔɔth, ku kɔc juëc kɔ̈k ɣet gen Jeriko. Kaam wën jiël kek geeu, ke mony cɔɔr ë kɔc lim, cɔl Timawuth ë rɛ̈ɛ̈r dhël yɔu ke lïm. ");
INSERT INTO dikNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nawën piŋ lɔn cï Jethu raan pan Nadharet ɣëët, ke cöt röl dït, “Bɛ̈ny Jethu yïn aŋääth apɛi. Yïn ë wën Debit cï Nhialic tooc. Kony ɣa.” ");
INSERT INTO dikNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Go kɔc kɔ̈k rɛ̈l ku yöökkë bï biɛt, go ŋot kiu apɛi, “Wën Debit kony ɣa.” ");
INSERT INTO dikNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Go Jethu kɔ̈ɔ̈c ku lueel, “Cɔ̈ɔ̈lkë.” Gokë cɔɔl, “Jɔt rot, yïn aye bɛ̈ny cɔɔl.” ");
INSERT INTO dikNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Go rot puur abä alanhden acuat lööny wei yekɔ̈u ku riŋ tënë Jethu. ");
INSERT INTO dikNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Go Jethu thiëëc, “Yeŋö wïc ba looi tënë yï?” Go cɔɔr lueel, “Bänydiɛ̈, awiëc ba bɛn daai.” ");
INSERT INTO dikNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Go Jethu lɛ̈k ye, “Lɔɔr, gamdu acï cɔl apuɔl.” Go daai nyin yic, ku buɔɔth Jethu. ");
INSERT INTO dikNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Nawën nïn kɔ̈k cök ciëën, ke Jethu kek kɔcken ye buɔɔth la Jeruthalem. Ku tɛ̈wën cï kek thiɔ̈k kek Bethpeec ku Bethanï, tɛ̈thiääk kek gɔn Olip, ke Jethu tooc kɔcken ye buɔɔth karou tueŋ, ");
INSERT INTO dikNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ku lëk ke, “Lak bɛ̈ɛ̈i tɔ̈ tueŋ yiic ku tɛ̈ ɣeet wek, ke wek aabï akaja cïn raan cï kaŋ cath ye yök ke mac. Luɔnykë ku bɛ̈ɛ̈ikë. ");
INSERT INTO dikNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Na le raan thiëc we, ke luɛlkë, awïc Bänyda, ku abï dhuk ëmën thiin.” ");
INSERT INTO dikNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Gokë la ku yökkë manh akaja ke mac ɣöt thok, dhël yɔu. Tɛ̈wën lony kek ye, ");
INSERT INTO dikNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","go kɔc ke kääc tɛ̈thiɔ̈k ke thiëëc, “Yeŋö luɔikë, lony wek manh akaja?” ");
INSERT INTO dikNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Gokë lɛ̈k ke cït tɛ̈wën cï Jethu ke than thïn. Go päl ke ku jiëlkë. ");
INSERT INTO dikNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Gokë manh akaja ɣäth tënë Jethu ku kumkë kɔ̈u aläthken, ku nyuc Jethu yekɔ̈u. ");
INSERT INTO dikNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Kɔc juëc aacä aläthken thiɛth dhël yic, ku kɔc kɔ̈k aacä ayɔ̈r tiim dhoŋ dum yiic, ku thiethkë ke dhël yic aya. ");
INSERT INTO dikNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Go kɔc ke tɔ̈ yenhom tueŋ, ku kɔc ke buɔth Jethu, yai looi ku yekë wak ëlä, “Lecku Nhialic! Bɛ̈ny dɔc raan bɔ̈ ë riɛnku, ");
INSERT INTO dikNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nhialic dɔc bääny wäda Debit bɔ̈! Lecku Nhialic!” ");
INSERT INTO dikNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ku jɔl la Jeruthalem ku bɛk luaŋ Nhialic ku ciɛɛth këriëëc ëbën. Nawën cï piny guɔ cuɔl, ke dhuk Bethanï kek atuɔ̈ɔ̈cke kathiäär ku rou. ");
INSERT INTO dikNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Naɣɔn nhiäk, tɛ̈wën jiël kek Bethanï, Jethu ë nɛ̈k cɔk. ");
INSERT INTO dikNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Nawën ke tïŋ tim cït ŋaap ke cï nhom thiäŋ ayɔ̈r, go la cɔl bï yök ke cï luɔk. Nawën le ɣet ke yök ke ayɔ̈r kepɛ̈c, rin tɛ̈den ye yen luɔk aŋoot. ");
INSERT INTO dikNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Go Jethu lueel, “Acïn raan kɔŋ miɛ̈thku bɛn cam lanaɣɔn.” Ku wɛ̈t kënë ëcï kɔcken ye buɔɔth piŋ. ");
INSERT INTO dikNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Nawën lek ɣet Jeruthalem, ke Jethu la luaŋ Nhialic, ku cop kɔc käŋ ɣaac aɣeer kal luaŋ Nhialic yic. Ku wel agen kɔc war wëëu yiic, ku thöc kɔc ɣɔɔc wei ë kuɔ̈r. ");
INSERT INTO dikNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ku cï kuat raan la kë muk päl bï ret luaŋ Nhialic lɔ̈ɔ̈m. ");
INSERT INTO dikNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ku jɔl kɔc piɔ̈ɔ̈c, “Acï gɔ̈t ëlä athör thɛɛr wël Nhialic yiic, ‘Luaŋdiɛ̈ acï looi bï ya tɛ̈n ye kɔc wuɔ̈t ëbën röök thïn, ku yeen acäk wel bï ya luaŋ cuɛ̈r.’ ” ");
INSERT INTO dikNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Wɛ̈t kënë acï kɔc käk Nhialic ku kɔc piööc lööŋ piŋ ku wïckë dhël nɛ̈k kek ye. Ku keek aake cï riɔ̈ɔ̈c Jethu rin cï kɔc ëbën puɔ̈th miɛt piɔ̈ɔ̈cde yic. ");
INSERT INTO dikNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nawën la thëi bɛ̈n, ke Jethu kek atuɔ̈ɔ̈cke jiël geeu. ");
INSERT INTO dikNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Naɣɔn nhiäk dɛ̈ɛ̈t, tɛ̈wën kuɛny kek dhël yic, ke ke tïŋ tim cït ŋaap wäär cï Jethu wak ke cï riau. ");
INSERT INTO dikNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Go Pïtɛr këwäär cï Jethu lueel tak ku lueel, “Raan piööc tïŋ tim wäär ca wak acï riau.” ");
INSERT INTO dikNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Go Jethu bɛ̈ɛ̈r, “Gamkë Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Wek alɛ̈k yic, na le raan yöök gɔn kënë, cuat rot wïïr, ku cï diu ku gɛm lɔn bï kë cï lueel rot looi, ka tiiŋ rot. ");
INSERT INTO dikNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Këya, alɛ̈k we, kuat kë thiëc tɛ̈ röök yïn, gam lɔn bï yïn ye yök, ku kë wïc aba yök. ");
INSERT INTO dikNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ku tɛ̈ röök yïn, ke yï pɛ̈l wɛ̈t piny tënë raan dɛ̈t, rin bï Nhialic adumuɔ̈ɔ̈mku päl piny aya.  ");
INSERT INTO dikNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Na cïï wɛ̈t ye päl piny tënë kɔc kɔ̈k, ke Nhialic acïï awäcdu pɛ̈l piny.” ");
INSERT INTO dikNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Gokë bɛn dhuk Jeruthalem, ku tɛ̈wën ciɛth Jethu kal luaŋ Nhialic yic, ke bänydït käk Nhialic ku kɔc piööc ë lööŋ ku jɔl aa kɔcdït baai, bɔ̈ tënë ye. ");
INSERT INTO dikNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ku thiëckë ëlä, “Ee yïn ye riɛl ŋö tɔ̈ yïguɔ̈p ye yïn luui këlä? Ku yeŋa yïk yï ë riɛl kënë ba keek aa looi?” ");
INSERT INTO dikNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Go Jethu bɛ̈ɛ̈r tënë ke, “Wek aba thiëëc wɛ̈t kënë aya, na bɛ̈ɛ̈r kë, ke wek aba lɛ̈k raan cä yiëk riɛl ye ɣɛn käkkä looi.” ");
INSERT INTO dikNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Lɛ̈kkë ɣa, “Joon raan kɔc muɔɔc nhïïm, yök riɛl yen kɔc gäm lɔ̈kwëi tënë Nhialic, aye riɛlde ë rot?” ");
INSERT INTO dikNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Gokë guëëk yic kamken ku luelkë, “Na luelku, ‘Ke yök tënë Nhialic,’ Ka thiëc, ‘Aye ŋö këc wek wɛ̈tde gam?’ ");
INSERT INTO dikNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ku na luelku, ‘Ke riɛlde ë rot,’ ke ɣok aa jɔ̈ny keek rin cï raan ëbën ye gam.” ");
INSERT INTO dikNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Gokë dhuɔ̈k Jethu, “Akucku.” Go Jethu lɛ̈k ke, “Na ye këya, ke wek aacä lëk riɛl ye ɣɛn käkkä looi.” ");
INSERT INTO dikNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Nawën ke Jethu jam waal tënë kɔc man ye ëlä, “Monytui ëcï dom looi ku cum yic tiim ë luɔk ku rɔk. Ku looi tɛ̈n ye mïth tim guɔ̈r thïn bïk ya mɔ̈u. Ku wec kät piny. Ku jɔl dom riɔ̈p yic kɔc kɔ̈k, ku le keny wun dɛ̈t. ");
INSERT INTO dikNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Nawën le tɛ̈ cï tiim luɔk thɔ̈ɔ̈ŋ, ke tooc aluɔnyde tënë ke bïk la gäm abäkke. ");
INSERT INTO dikNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Gokë alony dɔm ku thatkë ku copkë ciëën yecin. ");
INSERT INTO dikNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Go raan la dom alony dɛ̈t bɛn tooc, gokë yup nhom, ku baŋkë apɛi. ");
INSERT INTO dikNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Go alony dɛ̈t bɛn tooc, gokë nɔ̈k, ku jɔlkë aloony kɔ̈k aa that ku näkkë aloony kɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ku ë manhde yen ëcï jal döŋ bï bɛn tooc. Go jäl tooc ku lueel, ‘Aŋiɛc abïk la theek,’ ");
INSERT INTO dikNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Go kɔc awën cï riɔ̈p dom yic lueel ë kamken, ‘Kënë ë manh raan la dom, bï käŋ lɔ̈k thɔn aköldä. Bäk näkku ku käkkä aabï döŋ kek ɣo!’ ");
INSERT INTO dikNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Gokë dɔm ku näkkë ku cuɛtkë guäpde wei.” ");
INSERT INTO dikNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ku jɔl Jethu ke thiëëc, “Yeŋö bï raan la dom looi? Abï bɛ̈n ku nɛ̈k kɔc awën cï riɔ̈p dom yic. Ku riöp dom yic kɔc kɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Kɛ̈ckë wɛ̈t cï gɔ̈t athör thɛɛr wël Nhialic yic kënë kaŋ kueen? ‘Mën wäär yen cï atëët kuec, yen acï bɛ̈n a mën ril apɛi. ");
INSERT INTO dikNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Kënë ë ye luɔi Bɛ̈ny, ayeku tïŋ ke path ku dhëëŋ ɣonyïn!’ ” ");
INSERT INTO dikNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Go bäny Itharel puɔ̈th dak ku wïckë bïk dɔm, rin acïk ŋic lɔn jiɛɛm Jethu ë riɛnken. Ku rin riɔ̈ɔ̈c kek kɔc juëc tɔ̈ thïn, gokë puɔ̈l ku jiëlkë. ");
INSERT INTO dikNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Go kɔc ke man Jethu, Parathï kɔ̈k, ku kɔc Antipäth Ɣërot tuɔɔc tënë ye bïk la wëëŋ, bï wɛ̈t rac lueel. ");
INSERT INTO dikNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ku bïk ku luelkë tënë ye, “Raan piööc, aŋicku yïn ë jam yith. Yïn acie diɛɛr käk ye kɔc kɔ̈k tak. Ku yïn acie diɛ̈tden ye kuɛ̈ɛ̈c nhom. Ku yïn ë kɔc piɔ̈ɔ̈c bïk käk wïc Nhialic looi dhël la cök. Lɛ̈k ɣo na ye täktäkdu, buk ajuër dhiɛl aa gam, ɣok kɔc Itharel tënë Cithɛ̈r Bɛ̈nyŋaknhom, kua cuk bï gäm ye?” ");
INSERT INTO dikNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ku Jethu ëcï ruɛ̈ɛ̈nyden ŋic, ku bëër, “Yeŋö wïc wek ye bäk ɣa deep ë wɛ̈t? Bɛ̈ɛ̈ikë ë wënh kënë ba tïŋ.” ");
INSERT INTO dikNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Gokë jal yiëk wëëth. Goke thiëëc, “Ye nhom ŋa, ku ye rin ŋa käkkä cï giɛɛt wëëth kɔ̈u?” Gokë bɛ̈ɛ̈r, “Aa käk Cithɛ̈r Bɛ̈nyŋaknhom.” ");
INSERT INTO dikNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Go Jethu lɛ̈k ke, “Gämkë Cithɛ̈r Bɛ̈nyŋaknhom këde, ku gämkë Nhialic këde.” Gokë puɔ̈th dak rin cï Jethu ruɛ̈ɛ̈nyden ŋic. ");
INSERT INTO dikNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Nawën ke kɔc kɔ̈k akut Thaduthï. Akut cïï ye ye gam lɔn bï Nhialic kɔc cï thou bɛn cɔl apïr, bɔ̈ tënë Jethu ku thiëckë ëlä, ");
INSERT INTO dikNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Raan piööc, Mothith acï löŋ gɔ̈t ëlä tënë ɣo, ‘Na thou wämënh ë raan, ku nyiëëŋ tik piny ke cïn mïth, ke wämënh koor ala ɣöt tik bï mïth dhiëëth ɣön mɛ̈nhë.’ ");
INSERT INTO dikNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Na thööŋku lɔn tɔ̈ mïth tik thïn kadhorou. Ku thiëk wën dït ku thou ke cïn mïth. ");
INSERT INTO dikNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Go wën buɔth ye la ɣöt tik ku thou aya ke cïn mïth cï dhiëëth. Ku loi kënë rot aya tënë mɛ̈nh ye kek diäk. ");
INSERT INTO dikNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ku looi rot këya tënë wämäthakën kɔ̈k, keek ëbën kadhorou acïn mïth cïk nyääŋ piny. ");
INSERT INTO dikNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ku lek tueŋ ku thiëckë, tɛ̈ le kɔc cï thou röt jɔt aköldä, bï ya tïŋ ŋa rin cï yen rëër ke ke ëbën kadhorou?” ");
INSERT INTO dikNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Go Jethu bɛ̈ɛ̈r, “Wek aa kɔc ril nhïïm cïn kë ŋiɛckë, rin cïï wek wël cï gɔ̈t athör thɛɛr wël Nhialic yic ye gam. Ku acäk ye gam aya lɔn bï Nhialic kë ye lueel ka bï looi, lëu bï looi. ");
INSERT INTO dikNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Rin tɛ̈ le kɔc cï thou röt jɔt, aacïï bï thiëëk ku aacïï bï thiaak, aabï rëër kecït atuuc nhial. ");
INSERT INTO dikNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ku na ye rin wɛ̈t bï kɔc cï thou röt jɔt, ke we këc athör cï Mothith gɔ̈t kueen rin bun dɛ̈p, tɛ̈wäär cï Nhialic jam tënë ye ëlä, ‘Ɣɛn ë Nhialic Abaram, ku Ithäk ku Jakop.’ ");
INSERT INTO dikNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Kɔc cï thou ke ŋic Nhialic aa pïr alanden. Yeen ee Nhialic kɔc pïr, ku kɔc cï thou aya. Acäk wuɔ̈ɔ̈c!” ");
INSERT INTO dikNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Raan piööc lööŋ kɔc Itharel ë tɔ̈ thïn tɛ̈wën teer Jethu wël kek Thaduthï. Na le tïŋ ke Jethu ye wɛ̈lken ŋiɛc bɛ̈ɛ̈r, go bɛ̈n tënë ye ku thiëëc, “Ye löŋ nɛn yen ril apɛi kam lööŋ?” ");
INSERT INTO dikNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Go Jethu bɛ̈ɛ̈r, löŋ ril akïn, “Piɛŋkë kɔc Itharel, Bänyda ë Nhialic ku ee tök. ");
INSERT INTO dikNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nhiar Bɛ̈ny, Nhialicdu puɔ̈u ëbën, ku wɛ̈iku ëbën, ku nhiamdu ëbën, ku riɛldu ëbën. ");
INSERT INTO dikNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Löŋ dɛ̈t ril ye kek rou akïn, yïn adhil raan dɛ̈t nhiaar cïmën nhiɛɛr yïn rot. Acïn löŋ dɛ̈t ril apɛi wär ë lööŋkä karou.” ");
INSERT INTO dikNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Go raan piööc ë lööŋ lueel tënë Jethu, “Ee yic raan piööc cït tɛ̈ ca luɛ̈l ye, acïn Nhialic dɛ̈t, Nhialic ë tök. ");
INSERT INTO dikNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ku raan adhil Nhialic nhiaar piände ëbën, ku nhiamde ëbën, ku riɛlde ëbën. Ku adhil raan dɛ̈t nhiaar cïmën nhiɛɛr yen rot. Lööŋkä karou kek adhil ë theek, tɛ̈n tɛ̈ bï Nhialic näk ɣɔ̈k ku dor ë yïïk nhïïm.” ");
INSERT INTO dikNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Wën tïŋ Jethu ye ke cï bɛ̈ɛ̈r apath, go lɛ̈k ye, “Yïn acï mec kek bääny Nhialic.” Ku tɛ̈ɛ̈n acïn raan kam kɔc man Jethu cie bɛn thiëëc. ");
INSERT INTO dikNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Tɛ̈wën piööc Jethu luaŋ Nhialic, ke lueel, “Aŋiɛckë lɔn ye kɔc piööc ë lööŋ kɔc Itharel ye lueel lɔn Raan cï lɔc ku dɔc, abï ya raan dhiënh Debit? ");
INSERT INTO dikNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Debit guɔ̈p ëcï Wëi Nhialic yɔ̈ɔ̈k bï lueel ëlä, ‘Acï Nhialic lueel tënë Bänydiɛ̈, “Nyuc ë tɛ̈n köŋdiɛ̈n cuëc, ɣet tɛ̈ bï ɣɛn kɔc atɛrdu dhuɔ̈k ciëën yïcök.” ’ ");
INSERT INTO dikNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Ye këdë ye Raan cï lɔc ku dɔc manh Debit, ku yeen aye Debit cɔɔl ‘Bänydiɛ̈?’ ” Ku kɔc juëc awën cï wɛ̈t Jethu piŋ aacï puɔ̈th miɛt. ");
INSERT INTO dikNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Tɛ̈wën piööc yen ke ke lueel, “Tiɛtkë röt, ku duɔ̈kkë kɔc piööc lööŋ kɔc Itharel ye kiɛ̈ɛ̈t. Kɔc cath kek alɛ̈thken dït bär, röt teem ɣɔ̈n ɣɔɔc yiic bï ke aa muɔ̈ɔ̈th athɛ̈ɛ̈k. ");
INSERT INTO dikNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ayekë nhiaar bïk nyuc tueŋ thöc kɔcdït tɛ̈n amat, ku ɣɔ̈n path aköl yai, ");
INSERT INTO dikNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ku keek aa käk lëër tuɔ̈ɔ̈r nyïn, ku röökkë apɛi bïk kɔc wëŋ lɔn puɔth kek. Kɔckä, aabï tɛ̈m awuɔ̈cdït tet apɛi!” ");
INSERT INTO dikNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Tɛ̈wën cï Jethu nyuc tɛ̈ ye wëëu juaar thïn luaŋ Nhialic, ke döt kɔc juëc wëëu cuat kënë ajuër yic. Ku kɔc juëc ajiɛɛk aake cï wëëu juëc ya tääu thïn. ");
INSERT INTO dikNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Nawën ke lëër aŋäŋ bɔ̈ ku cuɛt wëëu reen lik thïn. ");
INSERT INTO dikNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Go Jethu lueel tënë kɔcken ye buɔɔth ëlä, “Wek alɛ̈k yic, lëër kënë acï Nhialic këden cï juaar nhiaar tënë kɔc kɔ̈k ëbën. ");
INSERT INTO dikNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Rin keek aa cïk juaar wëëuken juëc yiic, ku yen aŋäŋë, acï kënë bï yen pïr dhuɔl thïn ëbën.” ");
INSERT INTO dikNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Tɛ̈wën jiël Jethu luaŋ Nhialic, ke lueel raanden töŋ ye buɔɔth tënë ye, “Raan piööc, tïŋ, ye luaŋdït dhëëŋ ŋö kënë!” ");
INSERT INTO dikNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Go Jethu bɛ̈ɛ̈r, “Ɣöötdït dhëŋ ye tïŋkä, aabï thuɔ̈r piny ëbën, ka cïn alel töŋ bï kɔ̈ɔ̈c alel dɛ̈t nhom.” ");
INSERT INTO dikNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Tɛ̈wën rëër Jethu gɔn Olip nhom, ke cï yenhom wɛ̈l luaŋ ë Nhialic, ke thiëëc Pïtɛr ku Jemith ku Joon ku Andria wën rëër kek ë röt. ");
INSERT INTO dikNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Lɛ̈k ɣo, ye nɛn bï kënë rot looi? Ku yeŋö bï ye nyuɔɔth lɔn cï tɛ̈n bï käkkä röt looi thiɔ̈k?” ");
INSERT INTO dikNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Go Jethu lɛ̈k ke, “Tiëërkë nhïïm ku duɔ̈kkë röt cɔl aduɔ̈ŋ. ");
INSERT INTO dikNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kɔc juëc aabï bɛ̈n ë riɛnkiɛ̈, ku ye ŋɛk lueel, ‘Ke ɣɛn Raan cï lɔc ku dɔc,’ ku aabï kɔc juëc duɔ̈ŋ. ");
INSERT INTO dikNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Tɛ̈ tïŋ wek tɔɔŋ ke loi röt aköldä, bï dhiëëth ayï kɔc wuɔ̈n tök röt nɔ̈k, ke duɔ̈kkë diɛɛr, käkkä adhil röt looi. Ku kärɛc kɔ̈k aabï röt looi aya, ku acie lɔn cï thök ë piny bɛ̈n. ");
INSERT INTO dikNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Rin kɔc paan tök aabï kenhïïm tuɔ̈ɔ̈m ku thɛ̈rkë, ku wuɔ̈t aabï thɔ̈r kamken. Ayiɛ̈ɛ̈kyiɛ̈ɛ̈k piny juëc aabï röt looi bɛ̈ɛ̈i juëc yiic. Ku cɔŋdït apɛi abï tɔ̈u thïn. Käkkä kek aa käk tueŋ.” ");
INSERT INTO dikNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","10","Ku lëk Jethu atuɔ̈ɔ̈cke, “Wɛ̈t Nhialic abï kaŋ lɛ̈k kɔc ë pinynhom ëbën, ke thök ë piny këc bɛ̈n. Muɔ̈kkë wenhïïm bäk puɔ̈th riɛl kärɛc bï we yök yiic. Wek aabï kɔ̈ɔ̈c bäny nhïïm ë riɛnkiɛ̈ bäk ke lɛ̈k Wɛ̈t Puɔth Yam. ");
INSERT INTO dikNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ku tɛ̈ dɔm we ku ɣɛ̈th we luk yic, duɔ̈kkë diɛɛr tɛ̈ bï wek la jiɛɛm thin. Lak tueŋ ke we piööc wɛ̈tdiɛ̈ pinynhom ëbën rin acie wek jam, ee Wëi Nhialic.” ");
INSERT INTO dikNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ku ben Jethu lueel, “Raan kek wämënh aabï röt aa gaany bïk röt cɔl anäk. Ku wärken mïth aabï miɛ̈thken luɔm, ku mïth aabï kɔc ke dhiëth ke luɔm bï ke cɔl aa näk aya. ");
INSERT INTO dikNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kɔc ëbën aabï we maan riɛnkiɛ̈. Ku raan bï ye puɔ̈u dɛɛt agut tɛ̈ bï yen thou, abï pïr akölriëëc ëbën.” ");
INSERT INTO dikNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Piɛŋkë alɛ̈k we aya, “Ala aköl bï wek kërac apɛi tïŋ. (Raan kuën adhil wɛ̈t kënë deet yic.) Na rɛ̈ɛ̈r Judia ku tïŋ ë kënë, ke yïn adhil riŋ gat nhïïm roor ba la thiaan. ");
INSERT INTO dikNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","16","“Ku raan tɔ̈ dom yic acïï ben dhuk baai bä alanhde la lööm. Ku raan rɛ̈ɛ̈r aɣeer, acïï ben la ɣöt bï la guik kë nyiɛɛi. ");
INSERT INTO dikNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Diäär liɛc ku diäär muk mïthkor aabï gum apɛidït ye nïnkä. ");
INSERT INTO dikNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Rɔ̈ɔ̈kkë bï röt cïï loi wiir yic rut. ");
INSERT INTO dikNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kɔc aabï gum apɛi ye nïnkä, gum këc kë kaŋ yök tɛ̈wäär cɛk Nhialic kɔc agut cït ëmën. Ku acïï rot bï bɛn looi. ");
INSERT INTO dikNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Na këc Bɛ̈ny looi bï nïnkä cɔl alik, ŋuɔ̈t acïn raan cï pïr. Ku rin kɔcken cï kuany, acï nïn cɔl alik. ");
INSERT INTO dikNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Wek alɛ̈k kënë, ‘Na le raan yöök we tiɛ̈ŋkë Raan cï lɔc ku dɔc kïn,’ tɛ̈dë ke lueel, ‘Tiɛ̈ŋkë yen akan!’ Ke duɔ̈kkë gam. ");
INSERT INTO dikNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Rin kɔc juëc abï bɛ̈n ku lueel ŋɛk, ee ɣɛn Raan cï lɔc ku dɔc, ku lueel raan dɛ̈t ë ɣɛn raan käk Nhialic tïŋ, ku looi käril apɛi kɔc gɔ̈i. Ku märkë kɔc kɔ̈k cï Nhialic kuany, tɛ̈ lëu kek ye. ");
INSERT INTO dikNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Tiɛtkë röt, këriëëc ëbën alɛ̈k we ëmën bäk wenhïïm tiit käk bï bɛ̈n! ");
INSERT INTO dikNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Awiëc ku bäk ŋic aya, ye nïnkä, tɛ̈ cï kɔc jal gum apɛi, akɔ̈l abï kum nyin bï piny cuɔl, ku pɛɛi acïï bï ruɛl. ");
INSERT INTO dikNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Kuɛl aabï röt yääk ku löönykë. ");
INSERT INTO dikNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ku Manh Raan abï tïŋ ke bɔ̈ pial yiic kek diik ku riɛldït apɛi. ");
INSERT INTO dikNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ku yeen abä atuuc nhial tooc bïk kɔcken cï lɔc kuɔ̈ɔ̈t yiic pinynhom ëbën. ");
INSERT INTO dikNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Ŋiɛckë ë kënë tim cït ŋaap, tɛ̈ looi yen yɔ̈ɔ̈k ku looi yïth, ke kër acï thiɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Këya, tɛ̈ tïŋ wek käkkä ke loi röt, ke ŋiɛckë lɔn cï yen thiɔ̈k apɛi. ");
INSERT INTO dikNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Alɛ̈k we, wek aacïï bï määr tɛ̈ cɔk käkkä röt looi. ");
INSERT INTO dikNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Nhial ku piny aabï liu, ku wɛ̈tdiɛ̈ acïï bï kaŋ määr. ");
INSERT INTO dikNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Acïn raan ŋic aköl bï käkkä röt looi. Na cɔk atuuc nhial, ayï Wënde, ka cïk ŋic, ë Wä rot yen aŋic ye. ");
INSERT INTO dikNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Rɛ̈ɛ̈rkë we cï röt guiir rin wek akuc aköl bï kënë rot looi. ");
INSERT INTO dikNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Kënë, acït kënë rot looi tënë raan la keny, ku nyiëëŋ aluɔɔnyke baai, ŋɛk ke luɔide. Ku lëk raan cï nyiääŋ baai thok bï rëër ke tït akölaköl. ");
INSERT INTO dikNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Këya, wek adhil rëër we tït aya, rin acäk ŋic yen tɛ̈ bï Bänydun bɛ̈n thïn, lɔn bï yen bɛ̈n thëëi, ku lɔn bï yen bɛ̈n wɛ̈ɛ̈r ciɛl yic, ku lɔn yen dhiën thɔn ajïth, ku lɔn yen nhiäknhiäk ë rial. ");
INSERT INTO dikNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Na guɔ bɛ̈n, ke we cä yök we nin. ");
INSERT INTO dikNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Kë ya lɛ̈k we, alɛ̈k kɔc ëbën. Rɛ̈ɛ̈rkë we tït, ke we tïr nhïïm!” ");
INSERT INTO dikNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nïn karou Yan Ayum cïn yic luɔu nhom tueŋ, kɔcdït käk Nhialic ku kɔc piööc lööŋ aake wïc tɛ̈ bï kek Jethu dɛɛp thïn, bïk dɔm ke kuc ku näkkë. ");
INSERT INTO dikNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ku luelkë, “Acuk dɔm aköl yai, ɣok aabï tïït bï kɔc juëc kaŋ jäl, rin na dɔmku ku näkku, ke kɔc ŋoot yai yic, tɛ̈dë ke kɔc juëc aa thär kek ɣo.” ");
INSERT INTO dikNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ku tɛ̈wën rëër Jethu Bethanï pan raan atuet cɔl Thaimon, tɛ̈wën mïth yen, ke tik bɔ̈ kek töny koor cï cuëëc ë tiɔm ril la yic miök ŋïr cɔl naar, ye ɣɔɔc wëëu juëc apɛi. Ku kuem thok ku luuŋ miök Jethu nhom ëbën. ");
INSERT INTO dikNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Go kɔc kɔ̈k ke rɛ̈ɛ̈r thïn puɔ̈th dak ku jiɛɛmkë kamken. “Yeŋö tuuk yen miök ŋïr? ");
INSERT INTO dikNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Miök ŋïr kënë ŋuɔ̈t acï ɣaac wëëu juëc wär wëëu ye dɔ̈m raan ë ruɔ̈ɔ̈n tök, ku yïk wëëu kɔc ŋɔ̈ŋ.” Ku nyienykë tik apɛi. ");
INSERT INTO dikNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Go Jethu lueel, “Pälkë, yeŋö nyieeny wek ye? Acï këpath looi tënë ɣa. ");
INSERT INTO dikNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Rin kɔc ŋɔ̈ŋ aabï rëër kek we akölaköl. Ku na wiɛ̈ckë bäk ke kony ka luɔikë. Ku ɣɛn acïï bï rëër kek we akölaköl. ");
INSERT INTO dikNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Tiŋ kënë, acï kë lëu bï looi tënë ɣa looi. Acï bɛ̈n bä bɛ̈n tɔc bï guäpdiɛ̈ guiir bï jal thiɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Wek alɛ̈k yic, kuat tɛ̈ bï Wɛ̈t Puɔth Yam piɔ̈ɔ̈c thïn pinynhom, kë cï tiŋ kënë looi, abï ya lueel bï ye a tak.” ");
INSERT INTO dikNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Nawën ke Judath, raan töŋ atuuc kathiäär ku rou, la tënë kɔcdït käk Nhialic bï Jethu la luɔm tënë ke. ");
INSERT INTO dikNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Gokë puɔ̈th miɛt apɛi wën piŋ kek wɛ̈tde, ku thɔnkë lɔn bï kek ye gäm wëëu juëc. Ku jɔl tɛ̈ bï yen Jethu dɔm thïn wïc. ");
INSERT INTO dikNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Nawën aköl tueŋ Yandït Ayum cïn yic luɔu, nɛ̈k amɛ̈l rin yai, ke Jethu thiëëc kɔcken ye buɔɔth ëlä, “Ye tɛ̈nɛn wïc yïn ɣo buk miëth yai la guiir thïn?” ");
INSERT INTO dikNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Go Jethu kɔcken ye buɔɔth tooc karou ku lëk ke, “Lak geeu Jeruthalem, ku wek abï rɔ̈m kek raan ɣɛ̈ɛ̈c tööny pïu, biaathkë, ");
INSERT INTO dikNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","pan le yen thïn, ku lɛ̈kkë raan la baai. Aye Raan piööc lueel, ‘Ye ɣön nɛn bï ɣɛn miëth yai cam thïn ɣok kɔckiɛ̈n ɣa buɔɔth?’ ");
INSERT INTO dikNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ku abï we nyuɔ̈th ɣön nhial lääu yic cï guiir yic. Guiɛrkë miëthda ë tɛ̈ɛ̈n.” ");
INSERT INTO dikNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Go kɔc ye buɔɔth jäl ku lek geeu Jeruthalem, ku yökkë këriëëc ëbën cït tɛ̈wën cï Jethu ye lɛ̈k ke thïn. Ku jɔlkë miëth yai guiir. ");
INSERT INTO dikNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nawën la thëi bɛ̈n, ke Jethu bɔ̈ kek atuɔ̈ɔ̈cke thiäär ku rou. ");
INSERT INTO dikNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Tɛ̈wën mïth kek, ke lueel Jethu, “Wek alɛ̈k yic, raan tök kamkun abä luɔm ku ë raan mïth kek ɣa.” ");
INSERT INTO dikNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Gokë puɔ̈th riääk ku jɔlkë gäi ku thiëckë tök-tök, “Makei! Ye yic? Ye ɣɛn?” Ku riëëkkë puɔ̈th apɛi. ");
INSERT INTO dikNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Go Jethu bɛ̈ɛ̈r, “Ee raan tök kamkun wathiäär ku rou, raan yecin rɛk aduɔ̈k yic kek ɣa. ");
INSERT INTO dikNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ee yic, Manh Raan abï nɔ̈k cït tɛ̈ cï gät ye riɛnke athör thɛɛr wël Nhialic yiic. Ku raan bï ye luɔm abï gum apɛi. Ku aŋuɛ̈ɛ̈n tënë ye diɛ̈t këc cak dhiëëth.” ");
INSERT INTO dikNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Tɛ̈wën mïth kek, ke Jethu löm ayup ku dɔɔc, ku bɛny yic ku gɛ̈m ke ku lueel, “Lɔ̈mkë kënë, ku camkë, kënë ee guäpdiɛ̈.” ");
INSERT INTO dikNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ku lööm aduŋ cï thiäŋ muɔ̈n abiëc, ku leec Nhialic ku gɛ̈m ke, ku dëkkë thïn ëbën, ");
INSERT INTO dikNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ku lueel tënë ke, “Kënë ë riɛmdiɛ̈, riɛm ë dɔ̈ɔ̈r kek Nhialic, bï kuër rin kɔc ëbën. ");
INSERT INTO dikNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Alɛ̈k we, ɣɛn acïï bï bɛn dek muɔ̈n abiëc pinynhom tɛ̈n kek we, ɣet aköl bï ɣok ye dek ɣodhie pan Nhialic.” ");
INSERT INTO dikNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nawën cïk jal thök ke ket waak, ku lek gɔn Olip cök. ");
INSERT INTO dikNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ku lueel Jethu tënë ke, “Wek kackiɛ̈, wek aabï kat ɣa cïmën këwäär cï gɔ̈t athör thɛɛr wël Nhialic yic ëlä, ‘Ɣɛn abä abiöök cɔl anäk ku amɛ̈l abï wɛɛr.’ ");
INSERT INTO dikNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ku tɛ̈ cï ɣɛn jɔt raŋ yic, ke ɣɛn abï kaŋ la Galilia ba we la tiit thïn.” ");
INSERT INTO dikNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Go Pïtɛr lueel tënë ye, “Ɣɛn acïï bï kat tɛ̈ cɔk kɔc ëbën kat!” ");
INSERT INTO dikNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Go Jethu lueel tënë ye, “Alɛ̈k yï, ë wɛ̈ɛ̈r kënë, ke thɔn ajïth këc kiu rou, yïn abä jai arak diäk.” ");
INSERT INTO dikNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Go Pïtɛr dhuɔ̈k ye, “Na cɔk ɣa nɔ̈k kek yï, ke yïn acä bï kaŋ jai.” Ku lueel atuuc kɔ̈k ëbën këya. ");
INSERT INTO dikNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nawën ke Jethu kek kɔcken ye buɔɔth la tɛ̈ ye cɔl Jethemani, ku lueel tënë ke, “Nyuɔ̈ɔ̈ckë tɛ̈n ku yiënkë, ɣɛn ala röök.” ");
INSERT INTO dikNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ku cɔɔl Pïtɛr ku Jemith ku Joon bïk la kek ye. Ku jɔl rëër ke nɛ̈k atiëël, ku dhiɛɛu apɛi yepuɔ̈u. ");
INSERT INTO dikNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ku lueel tënë ke, “Ɣɛn adhiau puɔ̈u apɛi, ee thou guɔ̈p. Rɛ̈ɛ̈rkë tɛ̈n ku yiënkë.” ");
INSERT INTO dikNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ku le tueŋ tɛ̈thin-nyɔɔt, ku rɛ̈ɛ̈ny rot piny ku röök ëlä, “Na lëu rot, ke kërɛɛc tit ɣa acïï bɔ̈.” ");
INSERT INTO dikNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ku lueel, “Wä, yïn ë këriëëc ëbën lëu, nyaai ë kërɛɛc kënë tënë ɣa. Ku acie wɛ̈t piändiɛ̈ ë wɛ̈t piändu.” ");
INSERT INTO dikNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Nawën ke dhuk tënë ke ku yökke ke nïn. Go lueel tënë Pïtɛr, “Thaimon, niɛnkë? Cäk yiën tɛ̈thin-nyɔɔt?” ");
INSERT INTO dikNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ku lueel tënë ke, “Yiënkë ku rɔ̈ɔ̈kkë bï we cïï them jakrɛc. Puɔ̈u ë gam ku guɔ̈p acïn riɛl.” ");
INSERT INTO dikNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ku ben jäl ku le röök cïmën awën. ");
INSERT INTO dikNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Go bɛn dhuk tënë ke, ku ben ke yök ke nin, rin cï nïn ke göök apɛi. Ku muumkë nhïïm kë bïk lɛ̈k ye, rin cï kek gup riɔ̈ɔ̈c. ");
INSERT INTO dikNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Nawën dhuk tënë ke kën ye kek diäk, ke thiëëc ke, “Ŋot we nin! Lääŋkë? Ŋiɛckë lɔn cï tɛ̈n nïn thök, tiɛ̈ŋkë Manh Raan acï luɔ̈m kɔc rɛc. Ëmën, tɛ̈ bï ye jäl thɔ̈n kɔc rɛc acï ɣëët. ");
INSERT INTO dikNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Raan cä luɔm acï bɛ̈n. Jatkë röt, lokku buk rɔ̈m.” ");
INSERT INTO dikNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Tɛ̈wën ŋot jiɛɛm yen, ke Judath raan ye kek thiäär ku rou bɔ̈ ke cath kek kɔc juëc muk paal ku atuel, ke cï kɔcdït käk Nhialic, ku kɔc gät lööŋ, ku kɔcdït baai tooc. ");
INSERT INTO dikNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ku Judath ëcï kɔc awën cath kek ye, lɛ̈k tɛ̈ bï kek raan wïckë bïk bɛ̈n dɔm ŋiɛc thïn, ëlä, “Raan ba muɔ̈th ku ciɛɛm yen ë raan wiɛ̈ckë, damkë ku kuathkë ku tiɛtkë röt ë kacke apath.” ");
INSERT INTO dikNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Kaam wën ɣëët Judath, ke la tënë Jethu nyin yic ku lueel, “Bɛ̈ny.” Ku muɔ̈ɔ̈th ke ciim. ");
INSERT INTO dikNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Gokë dɔm ku derkë. ");
INSERT INTO dikNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Go raan tök kam kɔc ye buɔɔth wën kääc thïn palde miëët bei ku tök alony lui pan raandït käk Nhialic yïc abï tɛɛm wei ");
INSERT INTO dikNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Go Jethu ke thiëëc, “Cäk bɛ̈n we muk atuel ku paal bäk ɣa bɛ̈n dɔm. Cäk tak lɔn ye ɣɛn raan kɔc rum? ");
INSERT INTO dikNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ɣɛn ë rëër ke we akölaköl ɣa piɔ̈ɔ̈c luaŋ Nhialic, ku wek aa këc ɣa dɔm. Ku kënë acï rot looi ë rin bï kë cï gɔ̈t athör thɛɛr wël Nhialic yiic yenhom tiɛɛŋ.” ");
INSERT INTO dikNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ku jɔl kɔcken ye buɔɔth nyääŋ piny ku kɛtkë. ");
INSERT INTO dikNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ku riënythii dɛ̈t ceŋ alanh acuat ë buɔth Jethu. Nawën wïc kɔc awën kuath Jethu bïk dɔm, ");
INSERT INTO dikNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ke nyiëëŋ alath kecin ku kɛt kecin kë ceŋ. ");
INSERT INTO dikNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ku jɔlkë Jethu ɣäth pan Kaipa luk yic, cï bäny käk Nhialic ku kɔc piööc lööŋ, ku kɔcdït baai kenhïïm mat thïn. ");
INSERT INTO dikNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ku Pïtɛr ë biöth ke mec kɔc cök ciëën agut tɛ̈ ɣeet yen luk yic. Ku nyuuc bï ɣɔ̈c aya tɛ̈wën ɣɔ̈c kɔc bäny tiit thïn. ");
INSERT INTO dikNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Bäny käk Nhialic aake cï nyuc bïk Jethu wïc guɔ̈p awuɔ̈c cï looi, rin bï kek ye tɛ̈m thou, ku acïn awuɔ̈c cïk yök. ");
INSERT INTO dikNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Kɔc juëc aake cï Jethu luɔm ë lueth ku wɛ̈lken akëc rɔ̈m. ");
INSERT INTO dikNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Nawën ke kɔc kɔ̈k jɔt röt, ku lueelkë luenh kënë Jethu guɔ̈p. ");
INSERT INTO dikNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Acuk piŋ ke lueel, “Ɣɛn abï luaŋ Nhialic cï raan looi kënë thuɔ̈r piny, ku na ye aköl ye nin diäk, ke ɣɛn abï dɛ̈t buth nyiɛnde, ke cie kënë ë looi raan.” ");
INSERT INTO dikNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Agut ke aya aa këc wɛ̈lken rɔ̈m. ");
INSERT INTO dikNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Go Kaipa rot jɔt kenhïïm ku thiëëc Jethu, “Cïn kë dhuk nhom wël cï luɛɛl yïguɔ̈pkä yiic?” ");
INSERT INTO dikNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Go Jethu biɛt ku cïï jam. Go Kaipa bɛn thiëëc, “Ye yök yïpuɔ̈u ye yïn Raan cï lɔc ku dɔc, Manh Nhialic yeku door?” ");
INSERT INTO dikNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Go Jethu bɛ̈ɛ̈r, “Ee ɣɛn, ku wek aabï Manh Raan tïŋ ke cï nyuc cuëny Nhialic ŋic käŋ looi ëbën, ku bïï ke pial nhial.” ");
INSERT INTO dikNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Go Kaipa aläthke rɛt yiic yekɔ̈u ku lueel, “Yeŋö ŋot wïcku kɔc kɔ̈k bï bɛn jam käk cï looi. ");
INSERT INTO dikNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Wek acï tɛ̈ tɔɔn yen Nhialic thïn piŋ. Yeŋö yen wɛ̈tdun?” Gokë mat yic kedhie bï dhiɛl nɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ku jɔl kɔc kɔ̈k Jethu aa ŋuɔ̈ɔ̈t. Ku derkë nyin ku guutkë kecin ku yöökkë, “Mɛɛk raan yï gut.” Ku dɔm apuruuk ku biɛ̈kkë. ");
INSERT INTO dikNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Tɛ̈wën rëër Pïtɛr piiny ke ɣɔ̈c mac, ke nyan lui pan Kaipa bɔ̈. Ku tɛ̈wën tïŋ yen Pïtɛr, ke döt apɛi ku lueel, “Yïïn aya, yïn yï rëër kek Jethu raan Nadharet.” ");
INSERT INTO dikNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Go jai, ku lueel, “Ɣɛn acïï raandun ye lueel ŋic diɛn. Ku kë ye lueel acä cak deet yic aya.” Ku ler aɣeer. Ku kaam thiin awën, ke thɔn ajïth kiu. ");
INSERT INTO dikNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Go nyan awën tïŋ ku ben lɛ̈k kɔc kääc thïn, “Mony kënë ë raanden.” ");
INSERT INTO dikNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Go Pïtɛr bɛn jai. Ku kaam awën, ke lueel kɔc ke kääc thïn tënë Pïtɛr, “Ee yic, yïn ë raanden, rin yïn ee raan Galilia.” ");
INSERT INTO dikNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Go Pïtɛr rot kuëëŋ, “Nhialic abä nɔ̈k tɛ̈ cïï ɣɛn yic luel. Ɣɛn akuc raan jiɛɛm wek ë riɛnke.” ");
INSERT INTO dikNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Nyin yic, tɛ̈wën ye dhiën ajïth yic rou bɛ̈ɛ̈k piny, ke Pïtɛr tak këwäär cï Jethu lɛ̈k ye, “Tueŋ ke thɔn ajïth këc kiu kënë ye kek rou, ke yïn abä jai arak diäk.” Ku wel yenhom wei kɔc yiic ke cï guɔ̈p yär ku dhiɛɛu. ");
INSERT INTO dikNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Naɣɔn nhiäk rial yic, ke kɔcdït käk Nhialic, ku kɔcdït baai ku kɔc piööc lööŋ mɛ̈t tɛ̈ bïk luɔ̈i Jethu. Gokë rek ku kuɛɛthkë tënë bɛ̈ny Pilato. ");
INSERT INTO dikNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","3","Kɔc luk aake cï Jethu gaany lɔn cï yen kärɛc apɛi looi. Go Pilato thiëëc, “Ye yïn bɛ̈nyŋaknhom kɔc Itharel?” Go Jethu bɛ̈ɛ̈r, “Ee ɣɛn, cït tɛ̈ ca luɛ̈l ye.” ");
INSERT INTO dikNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Go Pilato bɛn thiëëc, “Cïï käjuëc cï yï gaanykä ye bɛ̈ɛ̈r, piŋ käkkith yeke kuɛɛn yïguɔ̈p.” ");
INSERT INTO dikNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Go Jethu biɛt ku cïï wɛ̈t Pilato bëër. Go Pilato gäi. ");
INSERT INTO dikNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ruɔ̈ɔ̈n ëbën, aköl Yan Ayum cïn yic luɔu, bɛ̈nyŋaknhom ë raan tök kam kɔc cï mac lony, tɛ̈ wïc kɔc baai ye bï lony. ");
INSERT INTO dikNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ke mony cɔl Barabath ë mac, kek kɔc cï kɔc nɔ̈k ke thär kek kɔc mac baai. ");
INSERT INTO dikNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Go kɔc juëc apɛi la tënë Pilato, ku thiëckë bï ke luɔ̈i kë ye looi aköl yai. ");
INSERT INTO dikNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Go Pilato ke thiëëc, “Wiɛ̈ckë ba Jethu bɛ̈nyŋaknhom Itharel, lony tënë we?” ");
INSERT INTO dikNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ee ŋic lɔn yen tiɛɛl ku män mɛɛn kɔc luk Jethu, yen aabï kek Jethu tënë ye. ");
INSERT INTO dikNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ku kɔc ater Jethu aake ye kɔc kuɔ̈ɔ̈t thook, bïk lɛ̈k Pilato bï ya Barabath yen lony. ");
INSERT INTO dikNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Go Pilato ke thiëëc, “Yeŋö ba looi tënë raan yakë cɔɔl ke bɛ̈nyŋaknhom kɔc Itharel?” ");
INSERT INTO dikNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Gokë rek yïc röldït, “Apiëët tim cï rïïu kɔ̈u.” ");
INSERT INTO dikNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Go Pilato ke bɛn thiëëc, “Yeŋö? Ye awäc ŋö cï looi?” Gokë bɛn rek yic röldït apɛi, “Apiëët tim cï rïïu kɔ̈u.” ");
INSERT INTO dikNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Go Pilato Barabath lony rin wïc yen kɔc bïk puɔ̈th miɛt. Ku wën cï yen apuruuk yɔ̈ɔ̈k bïk that ku ŋakkë nhom ë kuɔɔth, ke gɛ̈m ke bïk la piäät tim cï rïïu kɔ̈u. ");
INSERT INTO dikNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Go apuruuk Jethu kuaath aɣeer pan bɛ̈ny. Ku cɔlkë apuruukken kɔ̈k bïk röt mät ke. ");
INSERT INTO dikNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ku rukkë alanh mathiäŋ Jethu kɔ̈u. Ku jɔlkë kër la kuɔɔth riic yiic ku ŋɛk kek yenhom. ");
INSERT INTO dikNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ku jɔlkë aa cɔɔl, ku muɔ̈thkë ku buikë, “Mädho bɛ̈nyŋaknhom Itharel.” ");
INSERT INTO dikNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ku yuupkë nhom wai, ku ŋuutkë guɔ̈p, ku gutkë kenhiɔl piny bïk nyuɔɔth ciɛ̈t leckë. ");
INSERT INTO dikNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Wën cï kek ye jal bui, ke ke bïï alanh mathiäŋ awën bei, ku dhukkë aläthke yekɔ̈u, ku kuathkë bïk la piäät tim cï rïïu kɔ̈u. ");
INSERT INTO dikNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Tɛ̈wën cï tim cï rïïu Jethu göök këtkët, ke mony cɔl Thaimon, raan pan Thirene, wun Alekdhändɛ̈r ku Ruputh, ë bɔ̈ baai ke kuany dhël yic ke la geeu. Go apuruuk dɔm riɛl bï tim cï rïïu ket. ");
INSERT INTO dikNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ku ɣeetkë tɛ̈ cɔl Golgotha, ku wɛ̈tde yic, gɔn la ŋueŋ-ŋeŋ cït apen nhom raan. ");
INSERT INTO dikNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ku gɛ̈mkë Jethu muɔ̈n abiëc cï liääp wäl kec cɔl mir bï dek, go kuec ye. ");
INSERT INTO dikNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Gokë jäl piäät tim cï rïïu kɔ̈u. Ku cuɛtkë gɛk bïk alɛ̈th Jethu tek kamken. ");
INSERT INTO dikNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ee ye tɛ̈ cït lunyluny ɣɔ̈k yen ë piɛ̈ɛ̈t kek ye tim cï rïïu kɔ̈u. ");
INSERT INTO dikNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ku jɔlkë awuɔ̈c yekë tak ke cï Jethu looi, gɔ̈t nhial tim cï rïïu kɔ̈u ëlä, “BƐNYŊAKNHOM ITHAREL.” ");
INSERT INTO dikNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Ku piɛ̈ɛ̈tkë cuɛ̈r karou kek Jethu tiim cï rïïu kɔ̈ɔ̈th aya, raan tök lɔŋ cuëc ku raan tök lɔŋ cam. ");
INSERT INTO dikNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ku jɔl kɔc ke ye tëëk tɛ̈wën Jethu aa cuiit ku latkë ku luelkë, “Cie yïn wäär ye lueel lɔn bï yïn luaŋ Nhialic thuɔ̈r piny ku buth nïn kadiäk. ");
INSERT INTO dikNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Na ye këya, yeŋö cïï yïn rot kony ku bär piny tim cï rïïu kɔ̈u!” ");
INSERT INTO dikNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Këya, ee ye kɔcken ater bui ku luelkë kamken. “Ee kɔc kɔ̈k kony ku cïï rot kony. ");
INSERT INTO dikNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Raan cï lɔc ku dɔc cï Nhialic nhiaar ku yïk riɛl, cï rot looi bï ya bänyda, jɔl bɛ̈n piny tim cï rïïu kɔ̈u ëmën, buk jäl tïŋ ku gamku!” Ku acï kɔc awën cï piäät tiim kɔ̈ɔ̈th cïmënde aa bui ku lɛ̈ɛ̈tkë aya. ");
INSERT INTO dikNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Nawën akɔ̈l ciɛl yic ke muɔ̈th loi rot ɣet tääŋ aköl pan awën, ");
INSERT INTO dikNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Nawën tääŋ akɔ̈l, ke Jethu cöt röl dït, “Eloi, Eloi, lama thabakthanï?” Ku wɛ̈tde yic, “Nhialicdiɛ̈, Nhialicdiɛ̈, yeŋö pɛ̈l yïn ɣa wei?” ");
INSERT INTO dikNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nawën piŋ kɔc kɔ̈k ke kääc thïn, ke luelkë, “Piɛŋkë acɔl Elija.” ");
INSERT INTO dikNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Go raan tök kat ku lut alath muɔ̈n wac yic. Ku tɛ̈ɛ̈u wai thok ku ɣɔɔk Jethu thok, ku lueel, “Titku buk tïŋ lɔn bï Elija bɛ̈n bï bɛ̈n bɛ̈ɛ̈i bei tim cï rïïu kɔ̈u!” ");
INSERT INTO dikNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ku jɔl Jethu keŋ apɛi, ku thou. ");
INSERT INTO dikNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ku kaam wën ka alanh ye gɛ̈ɛ̈ŋ, bï luaŋ Nhialic tek yic alɔŋthïn rɛɛt yic ë rou, jɔɔk nhial ɣeet piny. ");
INSERT INTO dikNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Go bɛ̈ny apuruuk tɔ̈ thïn lueel wën tïŋ yen tɛ̈ cï Jethu thou thïn, “Mony kënë ë ye Manh Nhialic alanden!” ");
INSERT INTO dikNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Diäär aake tɔ̈ thïn, ku keek aake daai tɛ̈mec. Wäär rëër Jethu Galilia, ee ye diäärkä buɔɔth bïk miëth aa looi tënë ye. Ku diäär juëc kɔ̈k ke cath kek ye, wäär le yen Jeruthalem aake tɔ̈ thïn aya. Kam ë diäärkä Maria Magdalena, ku Thalome, ku Maria man Jemith thii kek Jothep aake tɔ̈ thïn. ");
INSERT INTO dikNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Wën col piny, bï aköl cïï kɔc Itharel ye luui guɔ bɛ̈n, ke Jothep raan gen Arimatheo bɔ̈. Ku ë ye raan kɔcdït luŋ Itharel, ku yeen aya ëcï Wɛ̈t Puɔth Yam gam. Nawën le tïŋ lɔn cï Jethu thou, ke riil yenyin ku ler tënë Pilato, ku thiëëc guɔ̈p Jethu bï la thiɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Go Pilato gäi lɔn nadë ke Jethu cï guɔ thou. Ku cɔɔl bɛ̈ny apuruuk ku thiëëc lɔn cï Jethu guɔ thou ayic. ");
INSERT INTO dikNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Nawën piŋ tënë bɛ̈ny apuruuk lɔn cï Jethu thou, go guäpde puɔ̈l bï Jothep nyaai. ");
INSERT INTO dikNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Go Jothep kɔc tooc bïk alanh ɣer la ɣɔɔc, ku bïï guɔ̈p Jethu piny tim kɔ̈u, ku der alanh awën. Ku tɛ̈ɛ̈u raŋ cï wec kuur yic. Ku lɔɔr alel dïttet raŋ thok. ");
INSERT INTO dikNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Magdalena ku Maria man Jothep aake daai, ku tïŋkë tɛ̈ cï ye thiɔ̈k thïn. ");
INSERT INTO dikNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Naɣɔn thëëi aköl cïï kɔc Itharel ye luui, ke Maria Magdalena ku Thalome ku Maria man Jemith la miök ŋïr ɣɔɔc bï kek guɔ̈p Jethu la tɔc. ");
INSERT INTO dikNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Naɣɔn nhiäk rial, aköl Nhialic, abɔ̈ akɔ̈l nyin ke la raŋ nhom. ");
INSERT INTO dikNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Wën ŋoot kek dhël yic, aake röt thiëëc, “Yeŋa ba aleldït tɔ̈ raŋ thok la laar wei?” ");
INSERT INTO dikNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nawën jɔtkë kenyïn ke tïŋ alɛl ke cï laar wei. ");
INSERT INTO dikNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Gokë la raŋ yic, ku tïŋkë riënythii ë köŋ cuëc ke rɛ̈ɛ̈r ke ceŋ alanh ɣer. Gokë gäi apɛi. ");
INSERT INTO dikNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Go lueel, “Duɔ̈kkë gɛ̈i, aŋiɛc wek awïc Jethu raan gen Nadharet wäär cï piäät tim cï rïïu kɔ̈u. Aliu ë tɛ̈n, acï rot jɔt. Tiɛ̈ŋkë tɛ̈wäär cï kek ye tääu thïn. ");
INSERT INTO dikNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Lakkë ku lɛ̈kkë kɔcken ye buɔɔth ku Pïtɛr, lɔn yen Jethu acï la Galilia. Abäk la yök thïn cïmën wäär cï yen ye lɛ̈k we.” ");
INSERT INTO dikNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Gokë la aɣeer raŋ yic ku kɛtkë, ke lɛth, ke cï gäi. Acïn raan cïk lɛ̈k wɛ̈t kënë dhël yic, rin cï kek riɔ̈ɔ̈c. ");
INSERT INTO dikNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Wën cï Jethu rot jɔt ë raŋ yic ɣɔn nhiäk rial aköl Nhialic, ke kɔŋ rot nyuɔ̈th Maria Magdalena wäär cï yen jakrɛc kadhorou cuɔp wei yeguɔ̈p. ");
INSERT INTO dikNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Go la ku lëk atuuc Jethu ke rɛ̈ɛ̈r thuɔɔu yic ke dhiau, lɔn cï Jethu rot jɔt. ");
INSERT INTO dikNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Nawën piŋkë tënë ye lɔn cï Jethu bɛn pïr, ku acï tïŋ, gokë cïï gam. ");
INSERT INTO dikNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Nawën ke Jethu nyuth rot atuɔ̈ɔ̈cke karou ke cï rot waaŋ, tɛ̈wën kuɛny kek baai yic. Ku cïk ŋic lɔn ye yen Jethu. ");
INSERT INTO dikNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Gokë dhuk Jeruthalem nyin yic bïk kacken la lɛ̈k, ku akëc kacken gam. ");
INSERT INTO dikNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Nawën ke Jethu jɔl rot nyuɔɔth tënë atuɔ̈ɔ̈cke kathiäär ku tök ke ke mïth. Ku nyieeny ke rin këc kek gam, ku rin cï kek nhïïm riɛl bïk wɛ̈t kɔc cï ye tïŋ ke cï pïr, cïï gam. ");
INSERT INTO dikNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Naɣɔn aköl dɛ̈t ke lëk ke, “Lak pinynhom ku lɛ̈kkë kɔc ëbën Wɛ̈t Puɔth Yam Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Raan bï gam ku yök lɔ̈kwëi, abï pïr akölriëëc ëbën, ku raan bï jai acïï bï kony. ");
INSERT INTO dikNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Kɔc cï gam abï yiëk riɛl kënë, aabï jakrɛc aa cuɔp wei ë riɛnkiɛ̈, ku aabï jam thok kɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Aabï kecin aa tääu kɔc tuany nhïïm, ku aabï pial. Na cɔkkë käpiɛny kuany, ku dekkë käk ë kɔc luaaŋ, kacïn kë näk ke thïn.” ");
INSERT INTO dikNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nawën cï Jethu nïn nɔ̈k ke ke, ke ɣɛ̈th pan Nhialic ku nyuuc köŋ cuëc ë Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ku jɔl atuuc Jethu thiëi pinynhom ke ke lëk kɔc. Ku jɔl käkken jäŋ gɔ̈i yekë ke looi kenhïïm aa tiɛɛŋ, rin tɔ̈ riɛl ë Nhialic ke ke.");
INSERT INTO dikNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Tënë Thiöpiluth, cït tɛ̈ ye piɛ̈ŋ ye, acï kɔc juëc them bïk käk cï röt looi kamkua gɔ̈t. ");
INSERT INTO dikNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Aacï gɛ̈t käk cï kɔc cï ke tïŋ, ku kɔc lui wɛ̈t Nhialic lɛ̈k ɣo tɛ̈wäär jɔɔk käkkä röt. ");
INSERT INTO dikNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Këya, Bänydiɛ̈, wën cï ɣɛn käk cï röt looi muk cök tɛ̈wäär jɔɔk kek röt, aca tak ba ke gɔ̈t apath tënë yï, ");
INSERT INTO dikNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","rin bï yïn käjuëc cï piɔ̈ɔ̈c tënë yï jäl ŋic lɔn cïï kek ye lueth. ");
INSERT INTO dikNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Wäär ye Ɣërot bɛ̈nyŋaknhom pan Judia, raan käk Nhialic cɔl Dhäkaria ë tɔ̈ thïn, ku yeen ë ye raan akut kɔc käk Nhialic cɔl Abija, ku yeen ë la tiŋden cɔl Elithabeth, nyɛn kuat Aron. ");
INSERT INTO dikNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Dhäkaria ku Elithabeth aake ye kɔc path tënë Nhialic, rin keek aake rɛ̈ɛ̈r ke cïn gup awuɔ̈c ke thek lööŋ Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ku keek aake cïn mïth rin Elithabeth ëcïï dhiëth, ku keek aake cï dhiɔp kedhie aya. ");
INSERT INTO dikNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Naɣɔn akäl tök, yen ke kuëër kɔc akut Dhäkaria bïk luui luaŋ Nhialic, ");
INSERT INTO dikNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ke kɔcken akut cuɛt gɛk, go lööny tënë ye bï ya yen la adöŋ ŋïr took ariäk nhom luaŋ Nhialic. Go la luɛɛk. ");
INSERT INTO dikNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ku tɛ̈wën took yen adök luɛɛk, ke kɔc juëc awën cï guëër aake rɔ̈ɔ̈k aɣeer. ");
INSERT INTO dikNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Kaam wën, ka atuny Nhialic nyuth rot ye ke kääc lɔŋ cuëc ariäk nhom tɛ̈wën took yen adöŋ ŋïr thïn. ");
INSERT INTO dikNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tɛ̈wën tïŋ Dhäkaria ye, go riɔ̈ɔ̈c apɛi ku muum nhom. ");
INSERT INTO dikNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Go atuny Nhialic lɛ̈k ye, “Dhäkaria! Duk riɔ̈c, rɔ̈ɔ̈kdu acï Nhialic piŋ, ku ëmën tiɛŋdu Elithabeth abï manh moc yök. Na la dhiëëth, ka bï cɔl Joon. ");
INSERT INTO dikNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Wek aabï puɔ̈th miɛt wedhie wek tiɛŋdu tɛ̈ le ye dhiëëth. Ku kɔc juëc aabï puɔ̈th miɛt ke we aya, ");
INSERT INTO dikNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","rin yeen abï ya raan töŋ ril kam kɔc käk Nhialic tïŋ. Ku yeen acïï bï ya dek kuat muɔ̈n la yic luɔu. Ku yeen abï Wëi Nhialic la yeguɔ̈p ke cɔk ŋoot man yäc, ");
INSERT INTO dikNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ku yeen abï kɔc Itharel cɔl adhuk Nhialic Bänyden. ");
INSERT INTO dikNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Abï kaŋ tuɔ̈l tënë Bɛ̈ny kek riɛl thöŋ cïmën riɛl Nhialic wäär tɔ̈ tënë Elija. Ku Joon abï wärken ë mïth cɔl anhiar miɛ̈thken. Ku kɔc ril nhïïm ëmën cie wɛ̈t Nhialic ye piŋ, aabï kenhïïm waar. Ku këya, yen ë tɛ̈ cï Joon kɔc cɔl aa guiir röt thïn rin bɛ̈n Bänyda.” ");
INSERT INTO dikNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Go Dhäkaria lueel tënë atuny Nhialic ëlä, “Ba ŋic këdë lɔn bï kënë rot looi? Ɣɛn acï dhiɔp ku tiɛŋdiɛ̈ acï dhiɔp aya.” ");
INSERT INTO dikNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Go atuny Nhialic dhuɔ̈k ye, “Ee ɣɛn Gabriɛl, rɛ̈ɛ̈r Nhialic lɔ̈ɔ̈m ku ɣɛn acï tooc ba yï bɛ̈n lɛ̈k wɛ̈t puɔth kënë. ");
INSERT INTO dikNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Rin këc yïn wɛ̈t ca lueel gam, yïn abï rëër yï cie jam, ɣet tɛ̈ bï kënë rot kaŋ looi akölden bï yen rot looi ke cït tɛ̈de.” ");
INSERT INTO dikNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Tɛ̈n awën, kɔc aake tit Dhäkaria ke cï gäi kë rëër yen luaŋ Nhialic apɛi këlä. ");
INSERT INTO dikNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Nawën le bɛ̈n bei ke cïï jam, gokë ŋic lɔn le yen kë cï rot nyuɔ̈th ye, tɛ̈wën ye yen nyuuth yecin ku cïï jam. ");
INSERT INTO dikNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nawën la nïn luui Dhäkaria luaŋ Nhialic thök, ke dhuk paande. ");
INSERT INTO dikNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Nawën ke tiɛŋde Elithabeth yök meth, ku jɔl rëër baai pɛ̈i kadhiëc ke cie la aɣeer. ");
INSERT INTO dikNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ku jɔl ya lueel, “Nhialic acï kënë looi tënë ɣa bï piathde nyuɔ̈th ɣa, ku acï kë ye ɣa dhɔ̈l guɔ̈p rin cï ɣɛn rol jal nyaai!” ");
INSERT INTO dikNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Tɛ̈wën ye pɛ̈i Elithabeth dätem, ke Nhialic tooc atuɔ̈nyde Gabriɛl gen Nadharet tɔ̈ pan Galilia, ");
INSERT INTO dikNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","tënë nyan bïm cɔl Maria, ku ë thiɛɛk mony cɔl Jothep, raan dhiënh Bɛ̈nyŋaknhom Debit. ");
INSERT INTO dikNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Go atuny Nhialic bɛ̈n tënë ye ku lueel ëlä, “Madho, yïn athiäŋ dhëëŋ Nhialic. Bänyda atɔ̈ ke yï!” ");
INSERT INTO dikNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Go Maria riɔ̈ɔ̈c ku muum nhom wën piŋ yen wëlkä, ku thööŋ yepuɔ̈u käk tɔ̈ ë wɛ̈t kënë yic. ");
INSERT INTO dikNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Go atuny Nhialic lueel tënë ye, “Duk riɔ̈c Maria, yïn anhiɛɛr Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Yïn abï meth yök, manh moc. Ku na la dhiëëth ka ba cäk ke cɔl Jethu. ");
INSERT INTO dikNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Abï ya raandït apɛi Nhialic nhom. Ku abï cɔl Wën Nhialic Madhɔl. Ku Nhialic Bänyda abï bääny Debit wundït yiëk ye, ");
INSERT INTO dikNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ku abï ya bɛ̈ny pan yï Jakop akölriëëc ëbën, ku bäänyde acïï bï thök alanden!” ");
INSERT INTO dikNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Go Maria lueel tënë atuny Nhialic, “Bï rot looi këdë. Ɣɛn ë nyɛn bïm këc thiaak?” ");
INSERT INTO dikNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Go atuny Nhialic bɛn lɛ̈k ye, “Wëi Nhialic abï lööny yïguɔ̈p ku riɛlde abï bɛ̈n yïnhom. Manh thin dhëŋ ba dhiëëth abï cɔl Wën Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ku dɛ̈t akïn aya, molɛ̈n Elithabeth cï dhiɔp acï meth jäl yök cɔk a wäär ye ye tïŋ ke ciɛ̈t cï rol. Päike aa dätem ëmën. ");
INSERT INTO dikNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Rin ŋic Nhialic käŋ looi ëbën. Acïn kë gök ye.” ");
INSERT INTO dikNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Go Maria lueel, “Ɣɛn alony Bänyda, abï looi tënë ɣa cïmën wɛ̈tdu.” Go atuny Nhialic jäl. ");
INSERT INTO dikNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Nawën nïn lik cök, ke Maria lööny dhöl ke cïn gääu bï la pan yï Dhäkaria rɛ̈ɛ̈r tɛ̈thöny pan Judia. ");
INSERT INTO dikNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ku ler pan Dhäkaria ku muɔ̈th Elithabeth. ");
INSERT INTO dikNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Kaam wën piŋ Elithabeth Maria ke muɔ̈th ye, ke manh liɛc yen riäŋ yeyic. Ku go Wëi Nhialic guɔ lööny yeguɔ̈p. ");
INSERT INTO dikNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ku lueel röldït tënë Maria, “Yïn aye leec diäär yiic ëbën, ku lec manh yänydu. ");
INSERT INTO dikNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Yeŋö thieek ɣayic abï man Bänydiɛ̈ ɣa bɛ̈n neem? ");
INSERT INTO dikNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kaam wën piŋ ɣɛn yïröl yï muɔ̈th ɣa, ke manh tɔ̈ ɣayic mit puɔ̈u ku le nyooŋ-nyooŋ. ");
INSERT INTO dikNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Yïn amit guɔ̈p rin cï yïn wɛ̈t Bänyda gam, lɔn bï wɛ̈t cï lɛ̈k yï rot tiɛɛŋ!” ");
INSERT INTO dikNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Go Maria lueel, “Yïn Bänyda yïn apiaany ɣapuɔ̈u, ");
INSERT INTO dikNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ku ɣɛn acï puɔ̈u miɛt tënë Nhialic pïr ɣɛn, ");
INSERT INTO dikNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","rin cï yen aluɔnyden cie kuɛ̈ɛ̈c nhom lieec. Ku akölë le tueŋ, riëëc ëbën abä leec rin cï Nhialic ɣɛn dɔɔc, ");
INSERT INTO dikNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","rin cï Nhialic Madhɔl kädït looi tënë ɣɛn. Yen aril ku adhëŋ. ");
INSERT INTO dikNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ku yeen alir puɔ̈u tënë kuat raan ëbën, kuat riɔ̈c ë yeen. ");
INSERT INTO dikNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nhialic acï kɔc bäŋ nhiam thiäi pinynhom köŋden ril. ");
INSERT INTO dikNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ku acï bäny ril piɛ̈k piny thɔ̈cken nhïïm, ku jɔt kɔc cïï nhiam cie kuɛ̈ɛ̈c nhïïm nhial. ");
INSERT INTO dikNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ku ee kɔc ŋɔ̈ŋ wïc käŋ, yiëk käjuëc ku nyiëŋ ajiɛɛk. ");
INSERT INTO dikNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ku acï wɛ̈tden cï thɔ̈n wärkuan dït tiɛɛŋ nhom ku kony aluɔɔnyke, kɔc Itharel. ");
INSERT INTO dikNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Cïmën wäär cï yen ye lɛ̈k wärkuan dït, Abaram ku mïth cï lɔ̈k dhiëëth!” ");
INSERT INTO dikNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ku jɔl Maria rëër kek Elithabeth tɛ̈cït pɛ̈i kadiäk ku dhuk panden. ");
INSERT INTO dikNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nawën ke pɛ̈i Elithabeth thök, ku dhiëëth manh moc. ");
INSERT INTO dikNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nawën piŋ kɔc akeu nhom ku kɔc ruääi ke ye lɔn cï Nhialic ye lieec, ke mit puɔ̈th apɛi. ");
INSERT INTO dikNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nawën aköl ye nïn bɛ̈t, ke kɔc bɔ̈ bï meth bɛ̈n ŋoot. Ku wïckë bïk cäk rin wun Dhäkaria. ");
INSERT INTO dikNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Go man kuec ku lueel, “Acɔl Joon.” ");
INSERT INTO dikNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Gokë lueel tënë ye, “Acïn raan ruääi ke we cï cäk ë rinkä.” ");
INSERT INTO dikNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ku nieukë wun nyin, ku thiëckë tɛ̈ bï yen meth cäk thïn. ");
INSERT INTO dikNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Go Dhäkaria agen gɛ̈tgɛ̈t cɔɔl ku gɛ̈t, “Acɔl Joon.” Gokë gäi ëbën. ");
INSERT INTO dikNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ku kaam thiin awën ke go ŋiɛc jam ku leec Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Go kɔc thiääk ke ke gäi, ku thiëi wëlkä pan Judia yic, ku ye kɔc ëbën jam ë ke. ");
INSERT INTO dikNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ku kuat raan cï wëlkä piŋ ë gäi ku lueel, “Manhë, bï jäl yiëndë aköldä?” Rin ë yic, riɛl Bänyda arɛ̈ɛ̈r kek ye. ");
INSERT INTO dikNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Go Wëi Nhialic lööny Dhäkaria guɔ̈p, ku lueel maany cï Nhialic nyuɔ̈th ye ëlä, ");
INSERT INTO dikNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Lecku Bɛ̈ny, Nhialic Itharel! Rin cï yen bɛ̈n bï kacke bɛ̈n luɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ku cɔl raan pïr ɣo atul ɣön Debit aluɔnyde. ");
INSERT INTO dikNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Wɛ̈tde acï kɔc käkke tïŋ lueel thɛɛr, ");
INSERT INTO dikNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","lɔn bï yen ɣo kony alɛikua ku kɔc man ɣo. ");
INSERT INTO dikNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Acï Nhialic lueel lɔn bï yen wärkuan dït lieec, ku muk lɔ̈ŋ ë dɔ̈ɔ̈r cï yen määth dɔm ke ke nhom. ");
INSERT INTO dikNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Cïmën cï yen mël kuëŋ tënë Abaram wädïtda, ku thɔn lɔn bï yen ɣo kony alɛikua, ɣok aabï këde ya looi ke cïn diɛɛr, ");
INSERT INTO dikNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","tɛ̈ ɣer ɣok puɔ̈th ku lok cök yenhom akölaköl tɛ̈ pïïr ɣok. ");
INSERT INTO dikNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ku yïn manhdiɛ̈, yïn abï ya raan käk Nhialic tïŋ, yïn abï la tueŋ yenhom ba dhöl la guiir tënë yeen. ");
INSERT INTO dikNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ba lɛ̈k kɔc tɛ̈ bï kek pïr akölriëëc ëbën yɔ̈k thïn, tɛ̈ pɛ̈l adumuɔ̈ɔ̈mken piny. ");
INSERT INTO dikNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nhialic alir puɔ̈u, ku yen abï raan cït ruɛl cɔl abɔ̈ pinynhom. ");
INSERT INTO dikNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ku yeen abï ruɛl tënë kɔc tɔ̈ muɔ̈ɔ̈th yic, rɛ̈ɛ̈r thou yic, bïk dhöl ye kɔc dɔ̈ɔ̈r ke Nhialic jäl yök.” ");
INSERT INTO dikNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ku Joon acï jäl dït ku yïk Wëi Nhialic riɛl dït. Ku pïïr roor tɛ̈ cïï ceŋ ë rot ɣet aköl tul yen Itharel nhom. ");
INSERT INTO dikNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Bɛ̈nyŋaknhom cɔl Cithɛ̈r ëcï wɛ̈t lueel bï kɔc bɛ̈ɛ̈i mɛc ke kueen. ");
INSERT INTO dikNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ku kën yen ë tɛ̈ jɔɔk kuɛ̈n ë kɔc rot tɛ̈wäär ye Kuirino bɛ̈ny pan Thiria. ");
INSERT INTO dikNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Go raan ëbën la bï la gɔ̈t rin, ŋɛk pan wundït ku ŋɛk pan wundït. ");
INSERT INTO dikNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Go Jothep jäl Nadharet tɔ̈ Galilia bï la gen Bɛ̈nyŋaknhom Debit, tɔ̈ pan Judia cɔl Bethalem, rin ye yen raan dhiënh Debit. ");
INSERT INTO dikNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Acï la bïk riɛnken la gɔ̈t kek Maria wïc kacken bïk gäm ye, ku ë liac. ");
INSERT INTO dikNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Tɛ̈wën rëër kek Bethalem, ke nïn bï Maria dhiëth thök. ");
INSERT INTO dikNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ku dhiëëth wënde, ku der kɔ̈u alath ku tɛ̈ɛ̈u diaany yic wën liiu tënë anïïn ɣön jɔ̈ɔ̈l. ");
INSERT INTO dikNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ku kɔc biöök aake rɛ̈ɛ̈r pan wën, ku aake ruu tiɛ̈t ë thäkken. ");
INSERT INTO dikNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kaam wën ka atuny Nhialic tul kelɔ̈m ku ruel ɣɛr Nhialic kekɔ̈th bï ke riaal. Gokë riɔ̈ɔ̈c apɛi. ");
INSERT INTO dikNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Go atuny Nhialic lɛ̈k ke, “Duɔ̈kkë riɔ̈c, ee wɛ̈t path yen alɛ̈k we, wɛ̈t bï thäi ëbën puɔ̈th miɛt thïn. ");
INSERT INTO dikNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Rin akölë, gen Debit tɛ̈n, Bɛ̈ny Pïr kɔc acï dhiëëth, ku yen ë Raan cï Nhialic lɔc ku dɔɔc. ");
INSERT INTO dikNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ku abäk ŋic këlä, wek aabï meth yök, manh cï der kɔ̈u alath, ku acï tɔ̈ɔ̈u gɔl cök.” ");
INSERT INTO dikNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kaam awën ka atuuc juëc kɔ̈k mɛt röt thïn ku leckë Nhialic ku luelkë, ");
INSERT INTO dikNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Yeku Nhialic door, Aciëŋ tɔ̈ nhial, ku dɔ̈ɔ̈r pinynhom tënë kɔc nhiɛɛr.” ");
INSERT INTO dikNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nawën cï atuuc juëckä dhuk nhial, go kɔc awën lueel kamken, “Lok Bethalem buk käk cï lɛ̈k ɣo la tïŋ, ku käk cï Bänyda nyuɔ̈th ɣo.” ");
INSERT INTO dikNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Gokë la ke ban kekɔ̈th, ku yökkë Jothep kek Maria ku Meth ke cï tääu gɔl cök. ");
INSERT INTO dikNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nawën tïŋ abiök meth, ke lëk kɔc ëbën käwën cï atuny Nhialic lueel ë riɛnke. ");
INSERT INTO dikNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Go kɔc cï wël kɔc abiök piŋ gäi apɛi. ");
INSERT INTO dikNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Go Maria wëlkä ëbën piŋ apath, ku muk ke yepuɔ̈u. ");
INSERT INTO dikNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Go kɔc abiök awën dhuk ke lec Nhialic, rin käk cïk piŋ ku tïŋkë ke, kecït tɛ̈wäär cï atuny Nhialic lɛ̈k ke. ");
INSERT INTO dikNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nawën aköl ye nïn bɛ̈t, aköl yen bï ye ŋoot, go cäk ke cɔl Jethu, rin wäär kek cï atuny Nhialic lueel wäär ŋot këc Maria liëc ë ye. ");
INSERT INTO dikNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Nawën cï nïn thiärŋuan thök cït löŋ Mothith, ke Jothep kek Maria la luaŋ Nhialic Jeruthalem bïk meth la nyuɔɔth, ");
INSERT INTO dikNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","cïmën löŋ cï Mothith nyooth thɛɛr ëlä, “Manh moc, ku ye kaai abï juɛ̈r Nhialic.” ");
INSERT INTO dikNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ku keek aya aacï kuɔ̈r karou juaar cïmën löŋ Bɛ̈ny. ");
INSERT INTO dikNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ku mony cɔl Thaimon ë ciëŋ Jeruthalem, ku ë raan path apɛi ku ë riɔ̈c Nhialic. Ku ë tit Raan Pïr kɔc Itharel, ku Wëi Nhialic ë tɔ̈ yeguɔ̈p. ");
INSERT INTO dikNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ku ëcï Wëi Nhialic lɛ̈k ye lɔn cïï yen bï kaŋ thou, tɛ̈ këc yen Raan cï Nhialic lɔc ku dɔɔc kaŋ tïŋ. ");
INSERT INTO dikNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nawën ɣɛ̈th Maria ku Jothep Jethu luaŋ Nhialic, bïk kë ye löŋ Mothith lueel la looi, ke tɛ̈ɛ̈u Wëi Nhialic Thaimon puɔ̈u bï la luaŋ Nhialic aya. ");
INSERT INTO dikNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Go Thaimon Jethu jɔt ku leec Nhialic ku lueel, ");
INSERT INTO dikNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Ee yïn Bɛ̈ny, yïn acï wɛ̈tdu tiɛɛŋ nhom, jɔl aluɔnydu puɔ̈l bï jäl, ke cï la läŋ. ");
INSERT INTO dikNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Tɛ̈ bï yïn kacku kuɔny thïn aca tïŋ nyiɛ̈nkiɛ̈, ");
INSERT INTO dikNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ku aca guiir thɛ̈i nhom ");
INSERT INTO dikNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ku ee piny mer bï kɔc cie kɔc Itharel käŋ tïŋ ku bï Itharel thändu aleec thïn.” ");
INSERT INTO dikNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Kaam wën kɛ̈ɛ̈c Jothep kek Maria ke cï gäi wël lueel Thaimon rin meth Jethu, ");
INSERT INTO dikNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","go Thaimon ke dɔɔc ku lueel tënë Maria, “Yen manh kënë acï Nhialic lɔc bï kɔc juëc Itharel muɔ̈r ku pïïr kɔc kɔ̈k. Ku yeen abï ya raan bï wɛ̈t Nhialic nyuɔɔth, ku abï kɔc juëc wël rɛc aa luɛɛl yeguɔ̈p. ");
INSERT INTO dikNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ku yïn Maria, yïn abï reem puɔ̈u ciɛ̈t yï cï gut pal, bï wɛ̈t tɔ̈ kɔc juëc puɔ̈th jäl ŋic thïn.” ");
INSERT INTO dikNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ku tiŋ käk Nhialic tïŋ cɔl Ana ë tɔ̈ thïn, ku ë ye nyan mony cɔl Panuel, raan dhiënh cɔl Acer kuat Itharel yic. Ana ëcï dhiɔp apɛi, ku ëcï thiaak ku rëër kek muɔnyde run kadhorou ku thou muɔnyde. ");
INSERT INTO dikNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ku jɔl Ana lɔ̈k rëër ke ye lëër ruɔ̈ɔ̈n thiärbɛ̈t ku ŋuan. Ëcie jäl luaŋ Nhialic, ë ye cool ku ruu ke loi käk Nhialic, ku röök ku theek miëth. ");
INSERT INTO dikNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ku akölë guɔ̈p acï rot mät kɔc wën, ku leec Nhialic ku lueel wɛ̈tde rin meth, tënë kɔc ye tiit lɔn bï Nhialic thänden Itharel wɛ̈ɛ̈r bei. ");
INSERT INTO dikNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nawën cïk këriëëc ëbën jäl looi cïmën löŋ Nhialic, ke Maria ku Jothep dhuk Galilia Nadharet panden. ");
INSERT INTO dikNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ku jɔl Jethu dït ku ril apɛi, ku ŋic käŋ ku dɔɔc Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ruɔ̈ɔ̈n ëbën Jothep kek Maria aake ye la Jeruthalem rin Yandït Ayum cïn yic luɔu. ");
INSERT INTO dikNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Naɣɔn cï run Jethu jäl aa thiäär ku rou, ke cath ke ke bïk la yai yic Jeruthalem. ");
INSERT INTO dikNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nawën cï yai thök ke dhuk ciëën, ku kuckë lɔn cï Jethu döŋ geeu, ");
INSERT INTO dikNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ë cïk tak lɔn ciɛth yen ke kɔc kɔ̈k, ku ciɛthkë ɣet thëi. Nawën ke wïckë kam kɔc ruääi ke ke ku kɔc ŋickë. ");
INSERT INTO dikNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Nawën cïk yök, gokë dhuk Jeruthalem bïk bɛn la wïc thïn. ");
INSERT INTO dikNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Na aköl ye nïn diäk, ke jɔlkë yök luaŋ Nhialic Jeruthalem, ke cï nyuc kam kɔc piööc lööŋ Nhialic ke piŋ wɛ̈lken, ku yeke thiëëc. ");
INSERT INTO dikNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Go kɔc ëbën gäi wën piŋ kek ye ke jam cïmën raan ŋic käŋ apɛi, ku tɛ̈ bëër yen wɛ̈lken aya. ");
INSERT INTO dikNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nawën tïŋkë manhden ke gɛ̈i ku lueel man, “Yeŋö manhdiɛ̈ looi yïn kënë tënë ɣo? Yïn acuk wïc apɛi ɣok wuur.” ");
INSERT INTO dikNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Go lɛ̈k ke, “Yeŋö wiɛ̈ckë ɣa? Kuɔ̈ckë lɔn dhil ɣɛn käk ë Wä looi?” ");
INSERT INTO dikNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ku aa këc wɛ̈t cï lueel deet yic. ");
INSERT INTO dikNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Go Jethu jäl ke ke ku dhukkë Nadharet, ku jɔlkë ceŋ ke ye wɛ̈lken piŋ, ku jɔl man käkkä muk yepuɔ̈u. ");
INSERT INTO dikNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ku jɔl Jethu dït ku ŋic käŋ apɛi. Ku Nhialic ë mit puɔ̈u tënë ye, ku yen lɔn kɔc aya. ");
INSERT INTO dikNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ɣɔn yen ruɔ̈ɔ̈n thiäär ku dhiëc ke Tiberiöth ye bɛ̈ny, ku Pilato ke ye bɛ̈nydït mac Judia, Antipäth Ɣërot ë ye bɛ̈ny Galilia ku Pilipo wämënh ë mac Ituria kek Trakonitith, ku Lithaniath ë ye bɛ̈ny Abilene, ");
INSERT INTO dikNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ku Anath kek Kaipa aake ye bänydït käk Nhialic. Tɛ̈ɛ̈në, ke Nhialic lëk wɛ̈t Joon wën Dhäkaria tɔ̈ roor. ");
INSERT INTO dikNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Go Joon bɛ̈ɛ̈i tɔ̈ wär Jordan yɔu kuɛny yiic ke wëët kɔc, “Pälkë luɔi kärɛc, ku calkë röt aa muɔc nhïïm, rin bï adumuɔ̈ɔ̈mkun päl piny tënë we.” ");
INSERT INTO dikNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Cïmën cï ye gɔ̈t athör Ithaya yic raan käk Nhialic tïŋ ëlä, “Raan käkkiɛ̈ tïŋ abï këcït lɔ̈ɔ̈r gut yic bï yen kɔc caal tɛ̈de ë rot, ku lëk keek ëlä, ‘Guiɛrkë dhël ë Bɛ̈ny, luɔikë dhɔ̈lke bïk la cök. ");
INSERT INTO dikNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Thɔ̈nykë ɣɔ̈n la tiäm piny ku dhuɔ̈kkë ɣɔn thöny nhïïm piny, ku cɔ̈kkë dhël cie yic neer, ku thɔ̈ɔ̈ŋkë dhɔ̈l la yiic ŋɔny nhïïm. ");
INSERT INTO dikNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ku raan ëbën, abï tɛ̈ ye Nhialic ɣook luäk thïn tïŋ!’ ” ");
INSERT INTO dikNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ku lëk kɔc juëc bɔ̈ tënë ye bï ke bɛ̈n muɔɔc nhïïm, “Awek dhiënh käpiɛny! Yeŋa lëk we bäk kat kërɛɛc bɔ̈? ");
INSERT INTO dikNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Luɔikë käk ye nyooth lɔn cï wek muɔ̈l kärɛc yakë ke looi. Ku duɔ̈kkë wepuɔ̈th tɔŋ ku luɛlkë ɣok aa mïth Abaram. Alɛ̈k we lɔn alëu Nhialic bï aleelkä cɔl aaye mïth Abaram. ");
INSERT INTO dikNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ku ëmën yëp acï ther bï ke tiim yep, rin na ye tim cie luɔk, ka yep ku cuɛt ë mɛɛc.” ");
INSERT INTO dikNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Go thän awën Joon thiëëc ëlä, “Na ye këya, buk ŋö looi?” ");
INSERT INTO dikNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Go Joon bɛ̈ɛ̈r, “Raan la alɛ̈th karou, adhil tök yiëk raan cïn alath, ku raan la miëth adhil looi këya.” ");
INSERT INTO dikNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Go kɔc ajuër kut bɛ̈n tënë ye aya bï ke bɛ̈n muɔɔc nhïïm, ku thiëckë, “Raan piööc buk ŋö looi?” ");
INSERT INTO dikNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Go lɛ̈k ke, “Duɔ̈kkë wëëu ye lööm ë ruëëny tënë kɔc.” ");
INSERT INTO dikNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Go apuruuk bɛ̈n ku thiëckë ëlä, “Na ɣook, buk ŋö looi?” Go lɛ̈k ke, “Duɔ̈kkë kɔc ye rum, ku duɔ̈kkë kɔc ye gaany wɛ̈t ë lueth, ku yakë puɔ̈th la yum ariɔ̈pdun yic.” ");
INSERT INTO dikNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Go ŋäthden jäl dït, ku yekë tak lɔn nadë ke mony abï dhiɛl a Raan cï Nhialic lɔc ku dɔɔc. ");
INSERT INTO dikNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Go Joon lɛ̈k ke ëbën ëlä, “Wek aa ya muɔɔc nhïïm pïu ë path, ku raan dït ku ril apɛi tënë ɣa abɔ̈, raan na cɔk aa warke ka cä lëu ba ke dɔ̈k. Ku ë yic ɣɛn acïï path ba lëu, ba ya aluɔnyde. Ku yeen abï kɔc kɔ̈k weyiic muɔɔc nhïïm Wëi Nhialic, ku muɔɔc kɔc kɔ̈k nhïïm ë mac. ");
INSERT INTO dikNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Yeen acït raan muk lɔk käm ye rap kɔ̈ɔ̈m, bï rap tek thook kek miël. Ku wiiu rap ku tɔ̈u ke. Ku yɔɔt miël many cie thou.” ");
INSERT INTO dikNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Wël kɔ̈k cït käkkä aacï Joon lɛ̈k kɔc apɛi bï yen Wɛ̈t Puɔth Yam piɔ̈ɔ̈c thïn. ");
INSERT INTO dikNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ku Joon ëcï Antipäth Ɣërot, bɛ̈ny Galilia jääm guɔ̈p kärɛc apɛi, rin cï yen Ɣërodia tiŋ wämënh rum bï ya tiɛŋde, ku looi käjuëc rɛc kɔ̈k aya. ");
INSERT INTO dikNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Go Antipäth Ɣërot Joon mac, ku kënë ë kërɛɛc dɛ̈t cï mat käracken cï looi yiic. ");
INSERT INTO dikNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nawën cï thän awën muɔɔc nhom ëbën, ku Jethu ke cï muɔɔc nhom aya. Kaam wën röök yen ke nhial liep rot. ");
INSERT INTO dikNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ku bɔ̈ Wëi Nhialic yenhom kecït kuur ë dit. Ku piŋ röl Nhialic nhial ke lueel, “Yïn ë manhdiɛ̈n nhiaar. Ɣɛn amit puɔ̈u kek yï.” ");
INSERT INTO dikNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Wäär jɔɔk Jethu piɔ̈ɔ̈cde cök, ke ruɔ̈nke aake ye thiärdiäk. Ku ë ye raan ëbën tak lɔn ë yen wën Jothep, wäär wën Ɣeli, ");
INSERT INTO dikNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","wën Mathat, wën Lebï, wën Melki, wën Janai, wën Jothep, ");
INSERT INTO dikNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","wën Matathia, wën Amoth, wën Naɣum, wën Ethli, wën Nagai, ");
INSERT INTO dikNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","wën Manth, wën Matathia, wën Themein, wën Jothek, wën Joda, ");
INSERT INTO dikNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","wën Joanan, wën Retha, wën Dherubabel, wën Cealtiel, wën Neri, ");
INSERT INTO dikNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","wën Melki, wën Adi, wën Kotham, wën Elmadam, wën Er, ");
INSERT INTO dikNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","wën Jocua, wën Eliedher, wën Jorim, wën Mathat, wën Lebï, ");
INSERT INTO dikNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","wën Thaimon, wën Juda, wën Jothep, wën Jonam, wën Eliakim, ");
INSERT INTO dikNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","wën Meliea, wën Mena, wën Matatha, wën Nathan, wën Debit, ");
INSERT INTO dikNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","wën Jethe, wën Obet, wën Boath, wën Thalmon, wën Nacon, ");
INSERT INTO dikNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","wën Aminadap, wën Admin, wën Arni, wën Ɣedhron, wën Peredh, wën Juda, ");
INSERT INTO dikNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","wën Jakop, wën Ithäk, wën Abaram, wën Tera, wën Naɣör, ");
INSERT INTO dikNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","wën Theruk, wën Reu, wën Pelek, wën Eber, wën Cela, ");
INSERT INTO dikNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","wën Kainan, wën Arpakcat, wën Cem, wën Noa, wën Lamek, ");
INSERT INTO dikNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","wën Methuthela, wën Enok, wën Jaret, wën Malaleel, wën Kenan, ");
INSERT INTO dikNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","wën Enok, wën Theth, wën Adam wën Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Go Jethu jäl wär Jordan ke cï Wëi Nhialic la yeguɔ̈p, ku ɣɛ̈th roor tɛ̈ cïï ceŋ, ");
INSERT INTO dikNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","tɛ̈ cï jɔŋrac ye bɛ̈n la them thïn nïn thiärŋuan. Ku ëcie mïth ë nïnkä yiic ëbën, nawën cïk thök ke jɔl cɔk nɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Go jɔŋrac rot cuɔ̈t ye ku lueel, “Na ye Wën Nhialic ke lɛ̈k alel kënë bï ya ayup.” ");
INSERT INTO dikNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Go Jethu bɛ̈ɛ̈r, “Acï gɔ̈t thɛɛr ëlä, ‘Raan acie pïr ayup ë rot.’ ” ");
INSERT INTO dikNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Go jɔŋrac ɣäth tɛ̈thöny, ku nyuth bɛ̈ɛ̈i pinynhom ëbën nyin yic. ");
INSERT INTO dikNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ku lueel tënë ye, “Käkkä ëbën aacï gäm ɣa, ku alɛ̈u ba ke gäm raan ca tak. ");
INSERT INTO dikNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Këya, na dor ɣa ka bï ya käkku ëbën.” ");
INSERT INTO dikNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Go Jethu bɛ̈ɛ̈r tënë ye, “Acï gɔ̈t ëlä, ‘Yïn abï Nhialic Bänydu door ku loi wɛ̈tde yetök!’ ” ");
INSERT INTO dikNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Go jɔŋrac ɣäth Jeruthalem, ku tɛ̈ɛ̈u luaŋ Nhialic nhom ku lueel, “Na ye Wën Nhialic ke yï cuɛt rot piny tɛ̈mec kënë, ");
INSERT INTO dikNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","rin ëcï gɔ̈t ëlä Nhialic abä atuɔ̈ɔ̈cke lɛ̈k bïk yï tiit, ");
INSERT INTO dikNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ku mukkë yï kecin, ba yïcök cïï cɔk dɛɛny alɛl.” ");
INSERT INTO dikNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Go Jethu bɛ̈ɛ̈r, “Acï lueel thɛɛr ëlä, ‘Duk Nhialic Bänydu them ë path.’ ” ");
INSERT INTO dikNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nawën cï jɔŋrac Jethu jäl them ë dhɔ̈lkä yiic ëbën, ke nyiëëŋ piny ku pɛ̈l kaam koor. ");
INSERT INTO dikNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Go Jethu ke tɔ̈ Wëi Nhialic yeguɔ̈p, dhuk Galilia. Go guɔ piŋ Galilia ëbën, ");
INSERT INTO dikNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","rin piɔ̈ɔ̈cde tɛ̈ ye kɔc Itharel kenhïïm mat thïn, ee ye leec raan ëbën. ");
INSERT INTO dikNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Go Jethu jäl tɛ̈den awën ku ler gɛnden Nadharet tɛ̈wäär muk ye thïn. Nawën aköl lɔ̈ŋ, ke la tɛ̈n amat kɔc Itharel cït tɛ̈ ye luɔ̈i ye akölaköl. Nawën jɔt rot bï wɛ̈t Nhialic kueen, ");
INSERT INTO dikNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ke gɛ̈m athör Ithaya, raan käk Nhialic tïŋ. Go athöör pet yic ku yök tɛ̈ cï ye gɔ̈t thïn këlä, ");
INSERT INTO dikNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Wëi Nhialic atɔ̈ ke ɣɛn rin acä lɔc, ba Wɛ̈t Puɔ̈th Yam lɛ̈k kɔc ŋɔ̈ŋ. Bɛ̈ny acä tooc ba lɛ̈k kɔc cï loony ku kɔc mac, ku kɔc rɛ̈ɛ̈r wïn jɔŋrac yic, lɔn bï keek lony, ku lɔn bï kɔc cï cɔɔr bɛn daai, ku ba lääu nhom tënë kɔc gum, bɛ̈n lɛ̈k keek. ");
INSERT INTO dikNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ku ba ruɔ̈ɔ̈n bï Nhialic kɔc bɔ̈ tënë yeen dɔɔc, bɛ̈n lɛ̈k keek.” ");
INSERT INTO dikNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ku mat Jethu athör yic ku gɛm ku nyuuc. Go kɔc ke tɔ̈ amat yic kenyïn wɛ̈l ye ëbën. ");
INSERT INTO dikNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Go Jethu lɛ̈k ke, “Wɛ̈t cäk piŋ ca kueen athör thɛɛr wël Nhialic yic acie nhom tiɛɛŋ ya aköl.” ");
INSERT INTO dikNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Go kɔc ke tɔ̈ thïn gäi ëbën ku leckë rin wël puɔth cï lueel. Ku yekë röt thiëëc ëlä, “Kënë, lëu bï rot looi këdë, yeen cie wën Jothep?” ");
INSERT INTO dikNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Go Jethu bɛ̈ɛ̈r, “Ee yic, wek aaba lɛ̈k kääŋ ye lueel ëlä, ‘Akïïm kɔŋ rot cɔl apuɔl,’ Ku abäk lɛ̈k ɣa ba käk cäk piŋ ke ca looi Kapernaum, looi aya gɛnda ë tɛ̈n. ");
INSERT INTO dikNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ku le tueŋ ku lueel, ‘Acïn kɔc käk Nhialic tïŋ ye wël yekë lueel gam panden.’ ");
INSERT INTO dikNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ku cïmën ŋic wek ye lɔn cï Elija, raan käk Nhialic tïŋ, tiŋ lëër cɔl Dharepath kony. ");
INSERT INTO dikNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ku Dharepath ë ye tiŋ wundɛ̈t cɔl Thidon. Ku diäär lër Itharel aake wïc kuɔɔny wäär nɛ̈k cɔk kɔc, rin këc deŋ tuɛny run kadiäk ku abak bï cɔk dït apɛi pan Itharel. Ku Elija akëc bɛ̈n tuɔ̈c ke. ");
INSERT INTO dikNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ku dɛ̈t aya, wäär ye Elica raan käk Nhialic tïŋ, kɔc juëc cï tuet aake tɔ̈ pan Itharel, ku acïn atuen töŋ cï Elica bɛ̈n kony, acï bɛ̈n la kony Naman raan pan Thiria.” ");
INSERT INTO dikNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Go kɔc ke tɔ̈ tɛ̈n amat puɔ̈th riääk ëbën wën piŋ kek wëlkä, ");
INSERT INTO dikNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ku jɔtkë röt ku göömkë piny. Ku ɣɛ̈thkë aɣeer geeu ke yekë pïk bïk ɣɛɛt gɔt nhom tɛ̈ cï gɛu buth thïn, ku ɣɛ̈thkë agala nhom rin wïc kek ye bïk la piɛ̈k wïïr. ");
INSERT INTO dikNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Go bak keciɛl yiic ku jiël. ");
INSERT INTO dikNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Go Jethu la Kapernaum gen tɔ̈ Galilia, tɛ̈ ye yen kɔc piɔ̈ɔ̈c thïn aköl cïï kɔc Itharel ye luui. ");
INSERT INTO dikNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ku piɔ̈ɔ̈cde ëcï kɔc gɔ̈i ë tɛ̈n aya, rin käk ye lueel aa wël yith ye nyuɔɔth lɔn le yen riɛl Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Naɣɔn akäl tök tɛ̈wën piööc yen, ke raan tɔ̈ kam kɔc tɛ̈n amat, ke la guɔ̈p jɔŋrac jam ke cï yeröl jɔt apɛi ëlä, ");
INSERT INTO dikNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Yeŋö wïc tënë ɣo Jethu raan gen Nadharet? Ca bɛ̈n ba ɣo bɛ̈n rac? Yïn aŋiɛc, yïn ë raan puɔth la cök bɔ̈ tënë Nhialic.” ");
INSERT INTO dikNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Go Jethu jɔŋrac duɔ̈m thok piny, “Biɛtë, ku bäär bei yeguɔ̈p.” Go jɔŋrac mony awën wiɛt piny kenhïïm ku bïï bei yeguɔ̈p ke cïn tɛ̈tök cï yiëk ye. ");
INSERT INTO dikNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Go kɔc gäi apɛi ku thiëckë röt, “Yeŋö kënë? Ye piööc yam kek riɛl Nhialic. Mony kënë ala riɛl ye yen jak yɔ̈ɔ̈k ku gamkë wɛ̈tde aya.” ");
INSERT INTO dikNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Go lɛc ku piathde guɔ thiëi baai yic ëbën. ");
INSERT INTO dikNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Kaam awën jiël yen tënë amat kɔc Itharel ke la pan yï Thaimon. Go man tiŋ Thaimon yök ke cï juäi göök, gokë lɛ̈k Jethu. ");
INSERT INTO dikNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Go la ku kɛ̈ɛ̈c yelɔ̈ɔ̈m tɛ̈wën cï yen tɔ̈c thïn ku yöök juäi bï jäl. Go juäi guɔ päl piny ku looi miëth tënë ke. ");
INSERT INTO dikNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ye thën kënë, wën cï akɔ̈l lööny piny, ke kɔc guëër kek kɔcken tuany tënë Jethu, ku tɛ̈ɛ̈u yecin kenhïïm, gokë pial ëbën. ");
INSERT INTO dikNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ku bɔ̈ jakrɛc bei kɔc juëc gup ke dhiau ëlä, “Yïn ë Wën Nhialic.” Go Jethu ke yɔ̈ɔ̈k bïk cïï jam, rin ŋic kek ye lɔn ye yen Raan cï lɔc ku dɔc. ");
INSERT INTO dikNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Naɣɔn nhiäk riɛl, akëc piny bak ke Jethu jiël baai ku le tɛ̈de ë rot. Go kɔc juëc la wïc. Nawën lek yök, gokë lɔ̈ŋ bï rëër Kapernaum ku cïï ke nyiëëŋ piny. ");
INSERT INTO dikNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Go bɛ̈ɛ̈r, “Ɣɛn adhil Wɛ̈t Puɔth Yam rin bääny Nhialic la piɔ̈ɔ̈c bɛ̈ɛ̈i kɔ̈k yiic aya, yen ë kën tuuc ɣa ba bɛ̈n looi.” ");
INSERT INTO dikNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Go pan Galilia kuany yic ke piööc kɔc tɛ̈n amat. ");
INSERT INTO dikNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ɣɔn akäl tök tɛ̈wën piööc Jethu wär cɔl Jenetharet yɔu, ke kɔc juëc apɛi wët bïk wɛ̈t Nhialic bɛ̈n piŋ. ");
INSERT INTO dikNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Go riäth karou tïŋ agör yɔu ke cï amɛ̈i nyääŋ piny ku jiëlkë bïk biaiken la thuak. ");
INSERT INTO dikNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Go Jethu thuɛɛt riän tök yic, ku ë ye riän mony cɔl Thaimon, ku lëk ye bï piɛ̈k wïïr tɛ̈thin-nyɔɔt. Ku jɔl nyuc riäi yic ku piööc kɔc. ");
INSERT INTO dikNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nawën cï thök ë jam, ke lëk Thaimon, “Gɛɛrkë riäthkun tɛ̈thiäŋ ku cuatkë biaikun bäk rec dɔm.” ");
INSERT INTO dikNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Go Thaimon bɛ̈ɛ̈r, “Bɛ̈ny, ɣok aacï ruu mäi wën akɔ̈u ku acïn kë cuk dɔm. Ku na ca lueel, ka buk cuat.” ");
INSERT INTO dikNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ku cuɛtkë buɔi. Gokë rec juëc apɛi dɔm abï buɔi yiic duɛ̈r rɛɛt. ");
INSERT INTO dikNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Gokë amɛ̈iken kɔ̈k tɔ̈ riän dɛ̈t yic cɔɔl bïk ke bɛ̈n kony. Gokë bɛ̈n, ku tekkë rec riäth karou yiic ku thiëŋkë kedhie abïk duɛ̈r dïïr. ");
INSERT INTO dikNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Nawën tïŋ Thaimon kë cï rot looi, ke gut yenhiɔl piny Jethu nhom ku lueel, “Bɛ̈ny, jäl tënë ɣa, ɣɛn ë raan la guɔ̈p adumuɔ̈ɔ̈m.” ");
INSERT INTO dikNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Rin yen Thaimon, ku kɔc awën mɛ̈i kek ye aake cï gäi rec juëc cïk dɔm. ");
INSERT INTO dikNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ku kɔcken cath kek ye Jemith ku Joon, wɛ̈ɛ̈t Dhubedï, aake cï gäi aya. Go Jethu lɛ̈k Thaimon, “Duk riɔ̈c, ëmën le tueŋ aa kɔc kek aaba ya dɔm.” ");
INSERT INTO dikNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Gokë riäth ɣɔ̈c wär thok aɣeer, ku nyiëëŋkë këriëëc ëbën piny ku buɔthkë Jethu. ");
INSERT INTO dikNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ɣɔn akäl tök Jethu ëcï la keny gen dɛ̈t, ku raan cï tuet ë tɔ̈ thïn. Nawën tïŋ Jethu ke gut yenhiɔl piny ku lɛ̈ŋ, “Bɛ̈ny aŋiɛc alëu ba ɣa kony ba pial, kony ɣa.” ");
INSERT INTO dikNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Go Jethu ŋääŋ nyinde tïŋ ku wïc bï kony. Ku jɔt yecin ku gɔɔt ku lueel, “Awiëc, piaalë!” Kaam thiin awën ke tuet jiël. ");
INSERT INTO dikNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ku cɔl Jethu ajiël ku thɔn apɛi, “Duk kënë la lɛ̈k raan dɛ̈t. Lɔɔr ku nyuɔ̈th rot raan käk Nhialic, ku bï caath, ku juar käŋ cït tɛ̈ ye löŋ Mothith ye luɛɛl thïn, bï raan ëbën ŋic lɔn cï yïn pial.” ");
INSERT INTO dikNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ku tɛ̈wën cï Jethu ye cak thɔn këya, ke wɛ̈t go thiëi piny abï kɔc juëc aa guëër tënë Jethu bïk piɔ̈ɔ̈cde bɛ̈n piŋ, ku kony ke bïk pial. ");
INSERT INTO dikNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ku ye la tɛ̈de ë rot tɛ̈ cïn yic kɔc ë rëër thïn bï la röök. ");
INSERT INTO dikNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Naɣɔn akäl tök, ke kɔc kɔ̈k akut Parathï, ku kɔc piööc lööŋ nyuc bïk piŋ tɛ̈ piööc Jethu kɔc thïn. Ku aake bɔ̈ bɛ̈ɛ̈i yiic Galilia ku Judia ku Jeruthalem. Ku Nhialic ëcï Jethu yiëk riɛl bï kɔc tuany kony. ");
INSERT INTO dikNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Kaam wën ke kɔc bɔ̈ ke ket raan aduany alom. Ku wïc kɔc awën ket ye bïk ɣäth ɣöt tënë Jethu. ");
INSERT INTO dikNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Nawën cïn tɛ̈ ɣɛ̈th kek ye tënë Jethu rin cï ɣöt thiäŋ kɔc, gokë la nhial ku ŋanykë ɣöt nhom lɔŋ awën rëër Jethu thïn. Ku luɛɛckë raan aduany piny kek biɔ̈ŋde yenhom. ");
INSERT INTO dikNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ku wën tïŋ yen gamdït tɔ̈ ke ke, ke lueel, “Mäthdiɛ̈, adumuɔ̈ɔ̈mku aacï päl piny.” ");
INSERT INTO dikNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Go kɔc piööc lööŋ kɔc Itharel ku kɔc akut Parathï wën rɛ̈ɛ̈r thïn, jäl tak ku luelkë kepuɔ̈th, “Yeŋa kënë Nhialic jääm guɔ̈p këlä? Yeŋa adumuɔ̈ɔ̈m päl piny, ee Nhialic ë rot.” ");
INSERT INTO dikNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Go Jethu käk yekë tak guɔ ŋic ku lueel, “Yeŋö ye wek ye tak lɔn lueel ɣɛn lueth? ");
INSERT INTO dikNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ye kënɛn puɔl yic käkkä yiic ba lueel, ‘Adumuɔ̈ɔ̈mku aacï päl piny’ tɛ̈dë ke luɛɛl, ‘Jɔt rot ku cathë?’ ");
INSERT INTO dikNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ku aba nyuɔ̈th we ëmën lɔn le Manh Raan riɛl pinynhom bä adumuɔ̈ɔ̈m päl piny.” Ku lëk raan aduany, “Alɛ̈k yï, jɔt rot ku kuany biɔ̈ŋdu ku lɔɔr baai.” ");
INSERT INTO dikNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Go rot jɔt nyin yic kenhïïm ke dɛɛi kek ëbën, ku kuɛny biöŋden awën cï ye tääc thïn, ku ler baai ke lec Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ku jɔl kuat raan tɔ̈ thïn ëbën gäi ku riɔ̈ɔ̈ckë. Ku leckë Nhialic ku luelkë, “Ɣok aacï këdïït jäŋ gɔ̈i tïŋ ya aköl.” ");
INSERT INTO dikNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Nawën ke Jethu jiël geeu, ku tɛ̈wën ciɛth yen ke tïŋ raan ajuër kut cɔl Lebï ke rɛ̈ɛ̈r tɛ̈den ë luɔɔi. Go Jethu lɛ̈k ye, “Buɔth ɣa.” ");
INSERT INTO dikNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Go Lebï luɔide puɔ̈l ku buɔɔth. ");
INSERT INTO dikNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Nawën ke Lebï loi miëth paande bï yen Jethu gɔɔŋ. Go kɔc juëc bɛ̈n, kɔc ajuër kut ku kɔc kɔ̈k, ku nyuuckë ke ke bïk mïth. ");
INSERT INTO dikNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Go kɔc akut Parathï ku kɔcken piööc lööŋ la ŋoomŋoom ku luelkë tënë kɔc Jethu buɔɔth, “Yeŋö ye wek mïth ku dɛ̈kkë kek kɔc ajuër kut, ku kɔc la gup adumuɔ̈ɔ̈m?” ");
INSERT INTO dikNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Kaam wën piŋ Jethu ë wɛ̈t kënë, ke lɛ̈k ke, “Acie kɔc puɔl kek akïïm wïc, aa kɔc tuany. ");
INSERT INTO dikNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ɣɛn akëc bɛ̈n ba kɔc ye tak lɔn puɔth kek bɛ̈n kony. Ɣɛn acï bɛ̈n bï kɔc rɛc la gup adumuɔ̈ɔ̈m kepuɔ̈th dhuɔ̈k ciëën.” ");
INSERT INTO dikNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Gokë bɛn lueel tënë ye, “Kɔc Joon buɔɔth aa lac thek ë miëth ku röökkë. Ku aye kɔc akut Parathï buɔɔth looi aya, ku kɔckun yï buɔɔth aa mïth ku dëkkë.” ");
INSERT INTO dikNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Go Jethu bɛ̈ɛ̈r ku lueel, “Yakë wïc bï kɔc cï bɛ̈n ruääi yic rëër ke cïï mïth? Acie tɛ̈de! Na rɛ̈ɛ̈r raan thiëk ke ke, ka cïk loi këya. ");
INSERT INTO dikNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Aköl bï athiëëk dɔm ku nyiɛɛi keyiic, yen aköl bï kek thek.” ");
INSERT INTO dikNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ku ben Jethu kääŋ dɛ̈t bɛn thɔ̈ɔ̈th aya tënë ke, “Acïn raan bï abaŋ alath rɛt wei alanh yam kɔ̈u bï la buɔ̈ɔ̈p ë dhiäth alath kɔ̈u. ");
INSERT INTO dikNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ku acïn raan bï muɔ̈n abiëc ë yam puɔ̈k töny thɛɛr yic. Na looi këya, ke muɔ̈n abiëc yam abï töny puɔ̈t yic, ku muɔ̈n abiëc abï luuŋ wei ku töny abï kuɛm. ");
INSERT INTO dikNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Acie këya, muɔ̈n abiëc yam adhil puɔ̈k ë töny yam yic. ");
INSERT INTO dikNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ku acïn raan wïc bï muɔ̈n abiëc yam dek tɛ̈ cï yen muɔ̈n abiëc cï ceŋ kaŋ dek, abï lueel, ‘Muɔ̈n abiëc cï cieŋ aŋuɛ̈ɛ̈n.’ ” ");
INSERT INTO dikNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Naɣɔn aköl cïï kɔc Itharel ye luui, Jethu kek kɔcken ye buɔɔth aake cath ke kuany dhël yic kam dum. Go kɔcken ye buɔɔth rap thoŋ ku koikë ke kecin, ku camkë ke. ");
INSERT INTO dikNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Go kɔc akut Parathï kɔ̈k lueel, “Yeŋö ye wek luui aköl cï löŋdan Itharel pëën bï kɔc cïï ye luui thïn?” ");
INSERT INTO dikNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Go Jethu bɛ̈ɛ̈r, “Këckë kë cï Debit looi wäthɛɛr kaŋ kueen? Wäär nɛ̈k cɔk ye kek kacke, ");
INSERT INTO dikNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","go la luaŋ Nhialic ku lööm ayum yaath cï tɔ̈ɔ̈u tënë Nhialic ku ciɛm, ku gɛ̈m kacke aya bïk cam. Ku ayum kënë ëcï lɔ̈ŋda pëën bï kuat raan ë path cïï cam. Ee raan käk Nhialic yen ë ye cam ë rot.” ");
INSERT INTO dikNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ku wit Jethu wɛ̈tde ëlä, “Manh Raan ë bɛ̈ny këriëëc ëbën agut aköl lɔ̈ŋ.” ");
INSERT INTO dikNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Naɣɔn aköl dɛ̈t, aköl cïï kɔc ye luui ke Jethu la tɛ̈n amat kɔc Itharel ku piööc. Ku mony cï cin cuëc ruai ë tɔ̈ thïn. ");
INSERT INTO dikNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Go kɔc kɔ̈k piööc lööŋ Mothith, ku kɔc kɔ̈k akut Parathï ke tɔ̈ thïn wïc bïk tïŋ, lɔn bï Jethu mony kënë kony bïk la luɔm, rin cï yen ye kony aköl cïï kɔc ye luui. ");
INSERT INTO dikNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ku Jethu ë ŋic kë tɔ̈ kepuɔ̈th, go lɛ̈k mony awën cï cin ruai, “Jɔt rot ku bäär tueŋ tɛ̈n kɔc nhïïm.” Go bɛ̈n ku kɛ̈ɛ̈c. ");
INSERT INTO dikNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Go Jethu ke thiëëc, “Yeŋö ye lɔ̈ŋda päl ɣo buk looi aköl cïï kɔc ye luui? Ye këpath aye kërac, bï raan kony bï pïr, kua pɛ̈l wei bï thou?” ");
INSERT INTO dikNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ku döt ke ëbën ku lëk mony awën cï cin ruai, “Nyoth yïcin.” Go yecin nyooth. Go ciɛɛnde piath. ");
INSERT INTO dikNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Tɛ̈ɛ̈në, go kɔc ater Jethu puɔ̈th riääk apɛi, ku matkë kë bïk looi tënë ye. ");
INSERT INTO dikNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Naɣɔn akäl tök ë nïnkä yiic, ke Jethu la gɔt nhom tɛ̈ cïï ceŋ bï la röök, ku jɔl ruu röök tënë Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nawën bak piny ke cɔl kɔcken ye buɔɔth, ku kuany raan thiäär ku rou keyiic ku ciëk ke ke cɔl atuuc. ");
INSERT INTO dikNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Kɔc ke cï kuany ayï, Thaimon (cï Jethu bɛ̈n cäk ke cɔl Pïtɛr), Andria (mɛ̈nh koor ë Thaimon), Jemith, Joon, Pilipo, Bartholomeo, Lebï, Thomath, Jemith wën Alpawuth, ku Thaimon (raan la puɔ̈u ater), Juda wën Jemith ku jɔl a Juda Ithkariöt, raan wäär cï Jethu bɛ̈n luɔm bï dɔm. ");
INSERT INTO dikNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","18","Go Jethu bɛ̈n piny ku kɛ̈ɛ̈c tɛ̈thöŋ nhom gɔt cök kek kɔcken ye buɔɔth, ku kɔc juëc kɔ̈k ke bɔ̈ Judia ku Jeruthalem. Ku kɔc bɛ̈ɛ̈i kɔ̈k tɔ̈ wärkɔ̈u cïmën Tire ku Thidon, aake cï bɛ̈n bïk bɛ̈n piŋ piööc Jethu, ku bï ke bɛ̈n kony tuɛny tɔ̈ kegup. Ku kɔc ke la gup jakrɛc aake cï bɛ̈n aya go Jethu ke kony. ");
INSERT INTO dikNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ee wïc kuat raan ëbën bï gɔɔt, rin riɛl yen kɔc kony bïk pial ë ye yök yeguɔ̈p ë path tɔ̈ cï ye gɔɔt. ");
INSERT INTO dikNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Go Jethu yenhom wɛ̈l kɔcken ye buɔɔth ku lueel, “Wek aa mit gup wek kɔc ŋɔ̈ŋ, rin ye bääny Nhialic këdun! ");
INSERT INTO dikNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Wek aa mit gup wek kɔc nɛ̈k cɔk ëmën, rin wek aabï kuɛth aköldä! Wek aa mit gup wek kɔc dhiau ëmën, rin wek aabï dɔl. ");
INSERT INTO dikNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Wek aa mit gup tɔ̈ mɛɛn week, ku cop week wei ku lat week, ku yekë kuec week ciɛ̈t yakë jakrɛc rin ye wek kackiɛ̈ ɣɛn Manh Raan! ");
INSERT INTO dikNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Wäthɛɛr wärken dït aake cï käk cït käkkä looi tënë kɔc käk Nhialic tïŋ. Këya, tɛ̈ looi käkkä röt tënë week, ke we mit puɔ̈th rin wek aabä ariöpdït yök tënë Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Tɛ̈ rɛɛc yen thïn tënë week, wek kɔc cï jak ëmën, rin cï wek pïr path yök thïn. ");
INSERT INTO dikNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Tɛ̈ rɛɛc yen thïn tënë week, wek kɔc cï kuɛth ëmën, rin wek aabï cɔk nɔ̈k. Ku tɛ̈ rɛɛc yen thïn tënë week, wek kɔc dal ëmën, wek aabï tɔ̈u tiɔp nhom ku dhiaaukë! ");
INSERT INTO dikNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ku tɛ̈ rɛɛc yen thïn tënë we tɛ̈ bï kɔc ëbën jam käpath ë riɛnkun, rin wärken dït aake ye jam këlä, wäthɛɛr tënë kɔc aa lueth röt cɔl aye kɔc käk Nhialic tïŋ. ");
INSERT INTO dikNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ku wek alɛ̈k kënë wek kɔc piŋ wɛ̈lkiɛ̈, Nhiarkë kɔc atɛrdun, ku yakë käpath looi tënë kɔc man we. ");
INSERT INTO dikNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Thiëc Nhialic bï kɔc ye wïc diɛ̈t yï yök kërac dɔɔc, ku rɔ̈ɔ̈k rin kɔc yï bui. ");
INSERT INTO dikNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Tɛ̈ maŋ raan yïgëm, ke wɛ̈l gëm dɛ̈t aya. Këya cïmën ë kënë, na wïc raan alath tënë yï ke duk pën alanh dɛ̈t aya. ");
INSERT INTO dikNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Na wïc raan këdäŋ tënë yï ke gäm ye, ku duk raan cï këdu nyaai thiëc bï cool tënë yï. ");
INSERT INTO dikNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Loi këpath tënë kɔc kɔ̈k cïmën nhiɛɛr yïn këpath bï looi tënë yï aya. ");
INSERT INTO dikNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Na ye ke nhiaar kɔc nhiar yï kepɛ̈c, ke yï yök lɛc Nhialic? Ayï kɔc kärɛc looi aa nhiar kɔc nhiar ke aya. ");
INSERT INTO dikNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ku na ye käpath looi tënë kɔc käpath looi tënë yï kepɛ̈c, ke yï yök lɛc Nhialic? Ayï kɔc kärɛc looi aa käpath looi tënë kɔc nhiar ke. ");
INSERT INTO dikNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ku na ye këdu gam tënë raan ye ŋɔ̈ɔ̈th ciɛ̈t bï cuɔ̈ɔ̈t aköldä, ke Nhialic mit puɔ̈u tënë yï? Agut kɔc kärɛc looi aa käkken gäm kɔc rɛc kɔ̈k cït ke, rin ye kek ye tak ciɛ̈t käkken bï dhuɔ̈k ke ëbën aköldä. ");
INSERT INTO dikNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Na ye këya, nhiar kɔc atɛrdu, ku loi käpath tënë ke. Yakë käkkun gam ë path ku duɔ̈kkë ye ŋɔ̈ɔ̈th lɔn bï we cuɔ̈ɔ̈t. Wek abä acutdït apɛi yök. Ku wek aabï ya mïth Nhialic Madhɔl, rin alir puɔ̈u tënë kɔc ëbën, agut kɔc na cɔk këpath looi tënë ke, ke cïï ke tiŋ puɔ̈th, ku kɔc rac aya. ");
INSERT INTO dikNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Liɛrkë puɔ̈th cïmën ye Wuurdun puɔ̈u liɛr. ");
INSERT INTO dikNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Duɔ̈kkë kɔc ye luɔ̈k wei bï Nhialic we cïï ye luɔ̈k wei. Duɔ̈kkë kɔc kɔ̈k ye tɛ̈m awuɔ̈c bï Nhialic we cïï ye tɛ̈m awuɔ̈c. Pälkë wɛ̈t piny tënë kɔc kɔ̈k bï Nhialic wɛ̈t päl piny tënë we. ");
INSERT INTO dikNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Na ye kɔc kɔ̈k muɔɔc ke Nhialic abï muɔɔc aya. Abä athëmdït cïï ciɛnku lëu bïk muk yiëk yï, rin käk ye looi tënë kɔc kɔ̈k, kek aabï Nhialic looi tënë yï.” ");
INSERT INTO dikNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ku lëk Jethu ke kääŋ ëlä, “Lëu raan cï cɔɔr bï cɔɔr dɛ̈t thel? Cïk lëu bïk lööny adhuɔ̈m yic kedhie? ");
INSERT INTO dikNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Acïn manh piööc dït tënë raanden piööc. Ku manh piööc na le piɔ̈ɔ̈cde thöl ka cït raanden piööc. ");
INSERT INTO dikNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Yeŋö ye yïn kërɛɛc dït ye looi kuc, ku ye tïŋ kërɛɛc cï wämuuth looi? ");
INSERT INTO dikNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Acïï lëu ba wämuuth wɛ̈ɛ̈t bï kërɛɛc thiin ye looi puɔ̈l, tɛ̈ cïï yïn rot kɔŋ wɛ̈ɛ̈t ba kärɛc ye looi puɔ̈l. Awëëŋkui! Kaŋkë kärɛc yakë ke looi puɔ̈l, ku abäk lëu bäk wämäthkun jäl wɛ̈ɛ̈t bïk kärɛc thii yekë ke looi puɔ̈l.” ");
INSERT INTO dikNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ku la Jethu tueŋ ku lueel ëlä, “Tim cï cil tɛ̈path acie luɔk mïth rɛc, ku tim cï cil tɛ̈rac acie luɔk mïth path. ");
INSERT INTO dikNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Këya, tim aye ŋic ë miɛ̈thke. Acïï lëu ba mïth tim dɛ̈t la kuany tim dɛ̈t cök. ");
INSERT INTO dikNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Raan path ë luui käpath, rin käpuɔth tɔ̈ yepuɔ̈u. Ku raan rac ë luui kärɛc, rin kärɛc tɔ̈ yepuɔ̈u. Wël ye ke lueel, aa käk tɔ̈ yïpuɔ̈u nyuɔɔth. ");
INSERT INTO dikNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Yeŋö ye wek ɣa cɔɔl, ‘Bɛ̈ny, Bɛ̈ny’ ku wek aa cie kë ca lueel ye looi? ");
INSERT INTO dikNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kuat raan ë bɛ̈n ku piŋ wɛ̈tdiɛ̈ ku theek ɣa ku looi, ");
INSERT INTO dikNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","acït raan cï ɣɔ̈nde ŋiɛc buth tɛ̈thöny. Nawën la aboor bɛ̈n, ku cɔk pïu ɣöt gɔ̈ɔ̈l piny, ku ɣöt cïï yic cɔk päk rin cï ye ŋiɛc buth. ");
INSERT INTO dikNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ku raan wɛ̈lkiɛ̈ piŋ ku cïï ɣa thek bï ke looi, acït raan ɣöt buth tɔ̈ ye aboor tëëk. Na la aboor bɛ̈n ke wit ɣöt!” ");
INSERT INTO dikNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Tɛ̈wën cï Jethu kënë wïc bï lɛ̈k kɔc thöl, ke la Kapernaum. ");
INSERT INTO dikNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ee gen kënë raan lui pan bɛ̈ny apuruuk ë tuany, ka tiit piny. Ku bɛ̈ny ë nhiar raanden luɔi apɛi. ");
INSERT INTO dikNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nawën piŋ Jethu, ke toc kɔcdït Itharel bïk Jethu la thiëëc bï bɛ̈n bä aluɔnyde bɛ̈n kony. ");
INSERT INTO dikNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Gokë la tënë Jethu ku läŋkë ku luelkë ëlä, “Apath ba bɛ̈ny apuruuk kënë kony. ");
INSERT INTO dikNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Anhiar kackua, ku ë yen buth tɛ̈dan ye ɣok mat thïn.” ");
INSERT INTO dikNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Go Jethu la ke ke. Ku kaam wën bï yen baai dööt, ke bɛ̈ny apuruuk toc mäthke bïk la lɛ̈k ye ëlä, “Bɛ̈ny, duk rot näk cäth rin ɣɛn acie raan path nadë ke yï bɔ̈ atiɛ̈mdiɛ̈ yic. ");
INSERT INTO dikNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ku ɣɛn akëc la tënë yï rin ŋic ɣɛn ye lɔn ye ɣɛn raan rac. Luel wɛ̈t ë path ku aluɔnydiɛ̈ abï pial. ");
INSERT INTO dikNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Rin ɣɛn aya, ɣɛn arɛ̈ɛ̈r bänydït cök, ku ɣɛn ala apuruuk rɛ̈ɛ̈r ɣacök. Aya lɛ̈k ŋɛk, ‘Lɔɔr!’ Ka la, ku lɛ̈k ŋɛk, ‘Bäär tɛ̈n,’ Ka bɔ̈, ku aya lɛ̈k aluɔnydiɛ̈, ‘Loi kënë!’ Ka looi.” ");
INSERT INTO dikNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Go Jethu gäi wën piŋ yen wëlkä, ku wël yenhom thän awën buɔth ye ku lueel, “Acïn raan ca kaŋ yök kam kɔc Itharel la gam cït gam ë mony kënë.” ");
INSERT INTO dikNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nawën dhuk kɔc awën cï tooc baai, ke yök alony bɛ̈ny ke cï pial. ");
INSERT INTO dikNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nawën ke Jethu la gen Nain, ku ë cath kek kɔcken ye buɔɔth ku kɔc juëc kɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nawën dötkë gɛu ke räm kek kɔc ket raan cï thou. Ku raan cï thou ë ye wän töŋ. Ku kɔc juëc aake cath kek tiŋ lëër kënë. ");
INSERT INTO dikNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nawën tïŋ Jethu tiŋ kënë, ke ŋɛɛr yic ku lëk ye ëlä, “Duk dhiau.” ");
INSERT INTO dikNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ku lëk kɔc bïk kɔ̈ɔ̈c ku gɔɔt biöŋ awën cï raan kuɔ̈m piny, ku lueel, “Riënythii, jɔt rot.” ");
INSERT INTO dikNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Go riënythii awën cï thou rot jɔt ku jiɛɛm ku cɔl Jethu ajiël kek man. ");
INSERT INTO dikNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Go raan ëbën riɔ̈ɔ̈c ku leckë Nhialic ku luelkë, “Raan käk Nhialic tïŋ ril apɛi acï tuɔ̈l ë kamkua. Ku Nhialic acï bɛ̈n bï kacke bɛ̈n luɔ̈k.” ");
INSERT INTO dikNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ku jɔl kë cï Jethu looi piŋ raan ëbën pan Judia, ku wuɔ̈t kɔ̈k thiääk ke ye. ");
INSERT INTO dikNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Go kɔc Joon buɔɔth käkkith ye lueel rin Jethu lɛ̈k Joon. Go kɔc karou kamken tuɔɔc tënë Jethu bïk la thiëëc ëlä, ");
INSERT INTO dikNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","“Ye yïn raan bï bɛ̈n aye raan dɛ̈t yen buk tiit?” ");
INSERT INTO dikNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nawën ɣëëtkë tënë Jethu ke luelkë, “Joon raan kɔc muɔɔc nhïïm acï ɣo tooc buk yï bɛ̈n thiëëc, ee yïn raan bï bɛ̈n aye raan dɛ̈t yen buk tiit?” ");
INSERT INTO dikNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ku kaam awën thiëc kek, Jethu ë kony kɔc juëc tuany apɛi, ku kɔc cï jakrɛc dɔm. Ku kɔc cï cɔɔr. ");
INSERT INTO dikNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Go wɛ̈tden bɛ̈ɛ̈r ku lueel, “Lak ku lɛ̈kkë Joon käk cäk tïŋ ku käk cäk piŋ, cɔɔr acï bɛn daai ëmën, ku aduany acï ya cath ku kɔc cï tuet acï tuet jal kegup, ku miŋ acï ya piŋ, ku kɔc cï thou aacï röt jɔt. Ku Wɛ̈t Puɔth Yam alëk kɔc ŋɔ̈ŋ nyïn. ");
INSERT INTO dikNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ku raan mit guɔ̈p ë raan cie puɔ̈u ë rou wɛ̈tdiɛ̈ yic.” ");
INSERT INTO dikNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Nawën cï kɔc Joon jäl, ke Jethu jam ku tët kɔc Joon, “Ye raan yïndë yen cï wek la ror cïï ceŋ bäk la tïŋ? Ye raan puɔl yic ye wel nhom ë path cïmën ye yom aruɔ̈ɔ̈r wel nhom? ");
INSERT INTO dikNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ye raan yïndë yen cäk la tïŋ? Ye raan ceŋ alɛ̈th path apɛi? Kɔc ciëŋ alɛ̈th dhëŋ ku yekë mïïth path cam akölaköl aa kɔc pan bɛ̈nydït. ");
INSERT INTO dikNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Lɛ̈kkë ɣa, yeŋö cäk la tïŋ? Ye raan käk Nhialic tïŋ. Ee yic. Ku alɛ̈k we, yeen adït tënë raan käk Nhialic tïŋ. ");
INSERT INTO dikNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Rin Joon yen aye athör thɛɛr wël Nhialic jam riɛnke ëlä, ‘Ɣɛn abï raan tök kam kɔc käkkiɛ̈ luɛɛl, cɔl alëk kɔc bï dhël la guiir tënë yïïn.’ ” ");
INSERT INTO dikNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ku ben Jethu lɛ̈k ke ëlä, “Acïn raan kuat kɔc cï dhiëëth pinynhom dït tënë Joon. Ku yeen aŋot wɛ̈r raan koor tɔ̈ bääny Nhialic yic.” ");
INSERT INTO dikNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Kuat kɔc cï wɛ̈tde piŋ, agut kɔc ajuër kut aacï këpuɔth looi Nhialic ŋic, ku cɔlkë röt aa muɔɔc Joon nhïïm. ");
INSERT INTO dikNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ku kɔc akut Parathï ku kɔc piööc lööŋ Mothith, aacïï jai kë wïc Nhialic bï guiir tënë ke, rin cï kek kuec bï Joon ke cïï muɔɔc nhïïm. ");
INSERT INTO dikNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ku ben Jethu thiëc, “Yeŋö ba thɔ̈ŋ kek riëëc akölë? Thɔ̈ŋkë kek ŋö? ");
INSERT INTO dikNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Keek aa cït mïth cï kenhïïm mat laar yic leŋ kegup, ye lueel ëlä, ‘Ɣok aacï waak pɛth ye keek ket tɛ̈ looi ruääi ket, ku wek aa këc dier! Ɣok aacï käk ye looi thuɔɔu yic thɔ̈ɔ̈ŋ, ku wek aakëc dhiau!’ ");
INSERT INTO dikNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Rin Joon raan kɔc muɔɔc nhïïm ëcie bɛ̈ɛ̈i kuany yiic ke mïth ku dëk ë mɔ̈u, ku ayakë lueel, ‘Lɔn le yen guɔ̈p jɔŋrac!’ ");
INSERT INTO dikNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ku Manh Raan acï bɛ̈n ku ye mïth kek kɔc ku dëk ke ke, ku ayakë lueel, ‘Jethu akok, ku a dɛk määu. Ku amääth kek kɔc ajuër kut ku kɔc la gup adumuɔ̈ɔ̈m!’ ");
INSERT INTO dikNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ku luɔi puɔth Nhialic ë rot nyuɔɔth käk ye kɔc ke buɔɔth yiic looi.” ");
INSERT INTO dikNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Naɣɔn akäl tök ke raan tök kɔc akut Parathï cɔl Jethu bïk la mïth. Go Jethu la pan raan akut Parathï ku nyuuc bï mïth. ");
INSERT INTO dikNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Nawën piŋ tiŋ adëjöök, ŋic gɛu yic ëbën, lɔn cï raan akut parathï Jethu caal paande, ke bɔ̈ kek töny koor cï cuëëc tiɔm ril apɛi, la yic miök ŋïr ye ɣɔɔc wëëu juëc apɛi. ");
INSERT INTO dikNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ku le ɣöt, ku nyuuc Jethu lɔ̈ɔ̈m, ku dhiɛɛu ke cie nhom guɔ̈t Jethu cök. Go pïu awën dhiɛɛu yen Jethu luak cök. Goke weec nhïmken nhom. Ku ciim cök ku tɔc cök miök ŋïr awën muk. ");
INSERT INTO dikNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nawën tïŋ raan akut Parathï wën cï Jethu gɔɔŋ ë kënë, ke jam yetök ëlä, “Na mony kënë ye raan käk Nhialic tïŋ, ŋuɔ̈t acï tïŋ ye gɔɔt ŋic, ye tiŋ yïndë, rin adëjöök.” ");
INSERT INTO dikNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Go Jethu wɛ̈t Thaimon guɔ ŋic ku lueel tënë ye, “Thaimon! Ala kë wiëc ba lɛ̈k yï. Päl yïyïc piny.” Go bɛ̈ɛ̈r, “Ye kënë ŋö, Raan ë piööc?” ");
INSERT INTO dikNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Go Jethu lɛ̈k anyïköl kënë, “Monytui ë kɔ̈ny kɔc karou. Raan tök kek wëëu ye dɔ̈m raan ruɔ̈ɔ̈n tök, ku raan dɛ̈t kek wëëu ë pɛn tök. ");
INSERT INTO dikNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ku akëckë lëu kedhie bïk wëëu cool. Go wëëu puɔ̈l, ku cïï ke ben kɔ̈ɔ̈ny. Na ye yï, yeŋa kamken bï mony kënë nhiaar apɛi?” ");
INSERT INTO dikNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Go Thaimon bɛ̈ɛ̈r, “Aya tak ë raan cï wëëu juëc päl piny tënë ye.” Go Jethu bɛ̈ɛ̈r, “Këdu ë yic!” ");
INSERT INTO dikNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ku wël yenhom tik ku lëk Thaimon, “Ca kë looi ë tiŋ tënë ɣa tïŋ? Ɣɛn acï bɛ̈n paandu ku yïn akëc ɣa yiëk pïu ba cök lɔɔk. Ku yen tiŋë acä lɔɔk cök pïuken nyin, ku wuuny ke nhïmken nhom. ");
INSERT INTO dikNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Yïn akëc ɣa ciim wën bï ɣɛn cït tɛ̈ ye miäth kɔc ë ciɛɛŋda yic. Ku yeen ë ɣa ciim cök ëmën ku ëmën, tɛ̈wën rëër ɣɛn ë tɛ̈n. ");
INSERT INTO dikNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Yïn akëc ɣa cak lor apath ba tɔc nhom, ku yeen acä tɔc cök miök ŋïr. ");
INSERT INTO dikNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ku alɛ̈k yï lɔn nhiɛ̈rdït cï nyuɔɔth thïn aye nyooth aya lɔn cï adumuɔ̈ɔ̈mken juëc päl piny. Rin raan cï käklik päl piny tënë ye, ee nhiɛ̈r koor nyuɔɔth.” ");
INSERT INTO dikNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ku lëk tik, “Adumuɔ̈ɔ̈mku aacï päl piny.” ");
INSERT INTO dikNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Go kɔc awën mïth kek ye aa jiɛɛm wei ku yekë lueel ëlä, “Yeŋa kënë jam lɔn ë yen adumuɔ̈ɔ̈m päl piny?” ");
INSERT INTO dikNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ku ben Jethu lɛ̈k tik, “Gamdu acï kony. Lɔɔr ke dɔ̈ɔ̈r Nhialic.” ");
INSERT INTO dikNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nawën ke jiël, ku kuɛny gɛɛth yiic ku bɛ̈ɛ̈i ke piööc Wɛ̈t Puɔth Yam rin bääny Nhialic. Ku atuɔ̈ɔ̈cke kathiäär ku rou aake cath kek ye. ");
INSERT INTO dikNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Diäär juëc aake cath kek ye aya. Diäär kɔ̈k kamken aake cï Jethu kony jakrɛc ku tuaany, Maria Magdalena cï jakrɛc kadhorou jäl yeguɔ̈p. ");
INSERT INTO dikNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ku Joanan tiŋ mony cɔl Kudha raan käk pan bɛ̈ny Antipäth Ɣërot tiit, ku Thuthana ku diäär juëc kɔ̈k ë Jethu kek kɔcken ye buɔɔth kony wɛ̈ɛ̈uken. ");
INSERT INTO dikNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Go kɔc juëc aa guëër tënë Jethu gɛɛth yiic, go ke lëk kääŋ kënë, ");
INSERT INTO dikNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Raan puɔ̈r ëcï la dom bï la pur. Ke wën ye yen rap wɛɛr dom yic ke kɔ̈th abɛ̈k lööny dhöl yic tɛ̈ ye kɔc tëëk thïn, ku tet diɛt ke aya. ");
INSERT INTO dikNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ku lööny kɔ̈th kɔ̈k alɛl nhom tɛ̈ koor tiɔp thïn. Nawën ciilkë, ke ke go guɔ riau rin këc mɛiken ɣet piny apath. ");
INSERT INTO dikNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ku lööny kɔ̈th abɛ̈k tɛ̈ ye tiim la kuɔɔth cil thïn, na la tiim juäk ke ke dec rap ku cïk lok apath. ");
INSERT INTO dikNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ku lööny kɔ̈th kɔ̈k tiɔm path yic, ku ciilkë ku lokkë apath ke dït nhïïm apɛi.” Ku wit Jethu lɔ̈ŋde ëlä, “Piɛŋkë tɛ̈ le wek yïth.” ");
INSERT INTO dikNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Go kɔcken ye buɔɔth thiëëc, “Kääŋ kënë wɛ̈tde yic yeŋö?” ");
INSERT INTO dikNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Go Jethu bɛ̈ɛ̈r, “Wek anyuth Nhialic bäänyden cäk ŋic thɛɛr. Ku kɔc kɔ̈k aabï käŋ ŋic ë kɛ̈ŋ ya lɛ̈k ke yiic, rin na cɔk alɔn ye kek daai, ka cïï käŋ bï tïŋ. Ku na cɔk alɔn ye kek wɛ̈t piŋ, ka cïk bï deet yiic.” ");
INSERT INTO dikNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ku lëk Jethu ke, “Kääŋ kënë wɛ̈tde yic akïn. Kɔ̈th cï com aa cït wɛ̈tdiɛ̈n ya piɔ̈ɔ̈c tënë we. ");
INSERT INTO dikNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Kɔc kɔ̈k aa cït kɔ̈th cï lööny dhël yic, ye diɛt ke tet. Tɛ̈ piŋ kek löŋ Nhialic, ke jɔŋrac bɔ̈ ku nyiɛɛi löŋ awën kepuɔ̈th bïk wɛ̈t Nhialic cïï piŋ, ku bï ke kony bïk pïr. ");
INSERT INTO dikNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kɔc kɔ̈k aa cït kɔ̈th cï com alɛl nhom, aa löŋ Nhialic gam nyin yic ke mit puɔ̈th. Ku aacie kepuɔ̈th ë dɛɛt, aa löŋ Nhialic guɔ wai wei tɛ̈ nɛ̈k ke rin wɛ̈t Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Kɔc kɔ̈k aya aa cït kɔ̈th cï lööny tɛ̈ ye tiim la kuɔɔth cil thïn, keek aa löŋ Nhialic piŋ. Ku käjuëc ke diir rin pïr pinynhom ë tɛ̈n, nhiɛ̈r jiɛɛk ku käpuɔth yekë wïc kepuɔ̈th aa bɛ̈n thïn, ku rɛckë löŋ Nhialic kepuɔ̈th. ");
INSERT INTO dikNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ku kɔc kɔ̈k aa cït kɔ̈th cï puur tiɔm path yic. Keek aa löŋ Nhialic piŋ ku gamkë apɛi, ku käjuëc path aaye yök tënë ke rin ye kek kepuɔ̈th dɛɛt.” ");
INSERT INTO dikNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ku ben lɛ̈k ke, “Acïn raan cï mermer kaŋ ɣäth ɣöt ku kum nyin, tɛ̈dë ke tɛ̈ɛ̈u agen tɔ̈c cök. Aye tɔ̈ɔ̈u ɣöt ciɛl yic rin bï ɣöt amer yic tënë kɔc bɔ̈ ɣöt. ");
INSERT INTO dikNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Këriëëc ëbën cï thiaan abï bɛ̈ɛ̈i bei kɔc nhïïm, ku këriëëc ëbën cï kum nhom, abï ɣɛ̈th aɣeer ruɛl yic. ");
INSERT INTO dikNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Piɛŋkë ku dɛtkë apath tɛ̈ ye wek wël piŋ, rin raan la këdäŋ abï bɛn muɔɔc, ku na ye raan cïn këdäŋ, ke këthiin ye tak lɔn tɔ̈ yen tënë ye, abï nyaai aya.” ");
INSERT INTO dikNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Go man Jethu kek wämäthakën bɛ̈n tënë ye, ku cïn tɛ̈ le kek tënë ye rin juëc kɔc ɣööt apɛi. ");
INSERT INTO dikNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Go raan tök lɛ̈k Jethu, “Moor ku wämäthakui aa kääc aɣeer, ku aa wïc yï.” ");
INSERT INTO dikNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Go Jethu lueel tënë ke, “Ma ku wämäthkiɛ̈ aa kɔc wɛ̈t Nhialic piŋ ku loikë.” ");
INSERT INTO dikNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Naɣɔn akäl tök, ke Jethu la riäi yic kek kɔcken ye buɔɔth ku lëk ke, “Lok teemku wär alɔŋtui.” Gokë riäi gɛɛr wïïr. ");
INSERT INTO dikNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Tɛ̈wën gër kek, ke Jethu go nin. Kaam awën niin yen ke yomdït apɛi jɔt rot, ku loi atiaktiak rot abï riäi duɛ̈r thiäŋ pïu, ku duërkë dïïr. ");
INSERT INTO dikNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Gokë puɔ̈ɔ̈c ku luelkë, “Bänyda, Bänyda! Ɣok aa muɔu.” Go Jethu rot jɔt ku rël yom ku atiaktiak. Gokë kɔ̈ɔ̈c ku la wär dïl. ");
INSERT INTO dikNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ku thiëëc ke, “Tɛ̈ gamdun tɛ̈nɛn?” Gokë nhïïm la cɔ̈t ku riɔ̈ɔ̈ckë riɛldït cït kënë, ku jiɛɛmkë kamken, “Ye raan yïndë kënë, na cɔk a yom ku atiaktiak ë ke piŋ wɛ̈tde?” ");
INSERT INTO dikNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Gokë wär Galilia teem ku lek tɔ̈ cɔl Jeratha tɔ̈ wär Galilia alɔŋtui. ");
INSERT INTO dikNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Tɛ̈wën kɛɛc Jethu piny riäi yic, ke mony ë gen kënë la guɔ̈p jakrɛc bɔ̈ tënë ye. Mony kënë ëcie ceŋ alɛ̈th ku ëcie rëër baai, ee ye rëër rɛ̈ŋ nhïïm. ");
INSERT INTO dikNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Nawën tïŋ Jethu ke lor nhom ke loi wuɔɔu, ku cuɛt rot piny yenhom ku looi kiɛɛu apɛi, “Jethu, wën Nhialic Madhɔl yeŋö wïc ba looi tënë ɣa? Yïn aläŋ duk ɣa tëm awuɔ̈c.” ");
INSERT INTO dikNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ee jam këlä rin cï Jethu jɔŋrac yɔ̈ɔ̈k bï jal yeguɔ̈p. Ee ye jɔŋ kënë dɔm arak juëc, na cɔk dɛr piny bï rek cin ku cök ku tit, ke ŋot ke tueny ku dhoŋ luɔ̈ŋ kɔ̈th yecök. Ku ɣɛ̈th jɔk roor tɛ̈ cïï ceŋ. ");
INSERT INTO dikNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Go Jethu jäl thiëëc, “Cɔl yï ŋa?” Go bɛ̈ɛ̈r, “Ɣok aa kut.” Ee lueel këya rin cï jak juëc la yeguɔ̈p. ");
INSERT INTO dikNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Go jakrɛc jam ku lɛ̈ŋkë Jethu bï ke cïï cop tɛ̈thuth dït yic, ye kɔc rɛc ɣäth thïn. ");
INSERT INTO dikNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ku duut dïr baai ë nyuäth gɔt cök ë tɛ̈n awën. Go jakrɛc Jethu lɔ̈ŋ bï ke cɔl aa la dïr gup. Goke puɔ̈l. ");
INSERT INTO dikNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Go jakrɛc bɛ̈n bei yeguɔ̈p ku lek dïr baai gup, ku riŋkë agör yic, ku thootkë wïïr ku moukë ëbën. ");
INSERT INTO dikNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nawën tïŋ röör ke biöök dïr kë cï rot looi, ke kat bïk wɛ̈t la lɛ̈k kɔc rɛ̈ɛ̈r geeu ku kɔc tɔ̈ bɛ̈ɛ̈i yiic. ");
INSERT INTO dikNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Go kɔc ëbën jal wɛt bïk kë cï rot looi la tïŋ. Nawën lek ɣet tënë Jethu, ke yök mony wäär la guɔ̈p jakrɛc ke cï nyuc Jethu cök, ke ceŋ alɛ̈th, ke la nhom cök. Gokë riɔ̈ɔ̈c. ");
INSERT INTO dikNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ku kɔc ke cï kënë tïŋ, aacï tɛ̈ cï mony la guɔ̈p jakrɛc kuɔny thïn la lɛ̈k kɔc kɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Go kɔc Jeratha ëbën riɔ̈ɔ̈c, ku lëkkë Jethu bï jäl panden. Go Jethu la riäi yic ku dhuk. ");
INSERT INTO dikNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Go mony wën cï Jethu jakrɛc cɔl ajiël yeguɔ̈p, Jethu thiëëc bï cath kek ye. Go Jethu jai ku lëk ye, ");
INSERT INTO dikNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Lɔɔr baai tënë kacku ku lɛ̈k ke käjuëc cï Nhialic looi tënë yï.” Go mony kënë jäl ke kuany gɛu yic, ke ye kɔc lɛ̈k käk cï Jethu looi tënë ye. ");
INSERT INTO dikNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Wën cï Jethu tem ku dhuk wär alɔŋtui, ke lor kɔc juëc apɛi, kɔc ke tit ye. ");
INSERT INTO dikNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Tɛ̈wën ke mony cɔl Jariöth, bɛ̈ny tënë amat kɔc Itharel bɔ̈ aya. Nawën tïŋ Jethu, ke cuɛt rot piny yecök ku lɛ̈ŋ bï la paande, ");
INSERT INTO dikNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","rin nyanden töŋ ye ruɔ̈nke thiäär ku rou ëcï dhal apɛi. Go Jethu gam ku lööny dhöl. Ku buɔɔth kɔc juëc ke cïk kum apɛi. ");
INSERT INTO dikNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ku tiŋ tuany këc thɛ̈kde kɔ̈u kaŋ tɛɛm ruɔ̈ɔ̈n thiäär ku rou ë tɔ̈ kɔc yiic. Ku yeen ëcï wëëu juëc gäm akïm, ku acïn akïm töŋ cï tuaanyde cɔl aŋuɛ̈ɛ̈n. ");
INSERT INTO dikNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Go bɛ̈n Jethu kɔ̈u ku gɔɔt alanhde thok. Go riɛm kɔ̈ɔ̈c nyin yic. ");
INSERT INTO dikNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Go Jethu thiëc, “Yeŋa cä gɔɔt?” Nawën cïn raan gɛ̈m ye rot, go Pïtɛr lueel, “Bɛ̈ny aa kɔc juëc cï kum kek aa yï pïk.” ");
INSERT INTO dikNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Go Jethu bɛn lueel, “Ala raan cä gɔɔt rin aca ŋic lɔn le yen raan ca kony?” ");
INSERT INTO dikNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nawën tïŋ tiŋ awën lɔn cï ye ŋic, go bɛ̈n tënë Jethu ke cï riɔ̈ɔ̈c, ke lɛth ku cuɛt rot piny yecök. Ku lëk Jethu, kɔc nhïïm ëbën yen kënë gɔɔt yen ye, ku tɛ̈ cï tuaanyde guɔ ŋuɛ̈ɛ̈n thïn ë kaam thiin awën. ");
INSERT INTO dikNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Go Jethu lueel tënë ye, “Nyaandiɛ̈ gamdu acï kony. Lɔɔr, ke dɔ̈ɔ̈r Nhialic.” ");
INSERT INTO dikNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Kaam wën jiɛɛm Jethu, ke raan rïŋ pan Jariöth ku lëk ye, “Nyaandu acï ɣet wei, duk raan piööc ben rääm nhom.” ");
INSERT INTO dikNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ku Jethu ëcï wɛ̈t ë mony piŋ, go lɛ̈k Jariöth, “Duk riɔ̈c, dɛɛt yïpuɔ̈u ku gam wɛ̈t yic. Nyaandu abï pial.” ");
INSERT INTO dikNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Wën ɣeet yen baai, ee cïn kɔc cïï puɔ̈l bïk la ɣöt kek ye, ee Pïtɛr ku Joon ku Jemith, ku jɔl aa wun ku man meth kepɛ̈c. ");
INSERT INTO dikNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Tɛ̈wën le Jethu ɣöt, ke yök kɔc ke näk röt, ke dhiau. Go lɛ̈k ke, “Duɔ̈kkë dhiau. Meth akëc thou, anin.” ");
INSERT INTO dikNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Gokë dɔl guɔ̈p rin ŋic kek ye lɔn cï yen thou. ");
INSERT INTO dikNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Go meth dɔm cin ku lëk ye, “Manhdiɛ̈ jɔt rot.” ");
INSERT INTO dikNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Go wɛ̈ike dhuk ku jɔt rot nyin yic. Ku lëk Jethu ke bïk yiëk miëth. ");
INSERT INTO dikNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Go kɔc ke dhiëth meth gäi apɛi, ku thɔn Jethu ke bïk kë cï rot looi cïï lëk kɔc kɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ku cɔl Jethu kɔc ye buɔɔth kathiäär ku rou, ku yïk ke riɛl bï kek jakrɛc aa la cuɔp wei, ku riɛl bï kek kɔc cɔl aaye pial aya, ");
INSERT INTO dikNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ku tooc ke bïk aa la piööc wɛ̈t bääny Nhialic ku konykë kɔc tuany. ");
INSERT INTO dikNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ku lëk ke, “Duɔ̈kkë muk käk la keny, cïmën wai ku jɔkgɔɔ ku mïïth yakë cam dhöl yic, ku wëëu ku duɔ̈kkë muk alɛ̈th kɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Yakë rëër pan ye we lor thïn ɣet tɛ̈ bï wek jäl. ");
INSERT INTO dikNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ku na ye pan cïï we lor thïn, ke we jiël ku taŋkë wecök, bï nyooth lɔn cï wek kuec ë ke.” ");
INSERT INTO dikNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Go atuuc jäl, ku kuɛnykë bɛ̈ɛ̈i yiic ke piööc Wɛ̈t Puɔth Yam ku konykë kɔc bïk pial kuat pan cï kek la thïn. ");
INSERT INTO dikNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Antipäth Ɣërot, bɛ̈nydït pan Galilia, ee cï käjuëc loi röt piŋ ëbën. Go diɛɛr rin ë ye kɔc kɔ̈k lueel lɔn Joon raan wäär kɔc muɔɔc nhïïm acï bɛn pïr. ");
INSERT INTO dikNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ku lueel kɔc kɔ̈k ë Elija yen acï bɛn tuɔ̈l, ku kɔc kɔ̈k ë yekë lueel, lɔn ë yen raan tök kam kɔc käk Nhialic tïŋ yen acï bɛn pïr. ");
INSERT INTO dikNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Go Antipäth Ɣërot lueel, “Ɣɛn acï Joon cɔl atëëm nhom bei! Yeŋa kënë ye ɣɛn wɛ̈lke piŋ ë bak?” Ku ë wïc bï rɔ̈m kek ye. ");
INSERT INTO dikNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Go atuuc Jethu dhuk ku lëkkë käk cïk looi ëbën. Ku jiëlkë ë röt ku lek gen cɔl Bethaida. ");
INSERT INTO dikNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nawën piŋ kɔc juëc tɛ̈ cï yen la thïn, ke buɔthkë. Go Jethu ke lor ku jiɛɛm tënë ke rin wɛ̈t bääny Nhialic, ku kony kɔc cï ye thiëëc, bïk pial. ");
INSERT INTO dikNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nawën la piny cuɔl, ka atuɔ̈ɔ̈cke kathiäär ku rou bɔ̈ tënë ye ku luelkë, “Cɔl kɔc aa jiël bïk la bɛ̈ɛ̈i yiic bïk la wïc tɛ̈ niin kek thïn, ku lek ɣɔɔc miëth camkë, rin tɛ̈ rëër ɣok thïn ë ror cïï ceŋ cïn kë kuany thïn.” ");
INSERT INTO dikNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Go Jethu bɛ̈ɛ̈r, “Miackë ke miëth.” Gokë lɛ̈k ye, “Käk mukku aa yuɔ̈p kadhiëc ku rec karou. Wïc buk miëth ɣɔɔc tënë ë kɔc juëckä?” ");
INSERT INTO dikNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kɔc ke tɔ̈ thïn aake röör tiim kadhiëc. Go lɛ̈k kɔcken ye buɔɔth, “Calkë kɔc aa nyuc, thiär dhiëc akuɔ̈t tök yic.” ");
INSERT INTO dikNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Go kɔc ye buɔɔth kɔc cɔl anyuc piiny këya. ");
INSERT INTO dikNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Go ayuɔ̈p awën kadhiëc ku rec karou lööm ku döt nhial ku leec Nhialic. Ku bɛny ayuɔ̈p yiic, ku gɛ̈m ke kɔcken ye buɔɔth bïk ke tek agut rec tënë kɔc. ");
INSERT INTO dikNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ku mïthkë abï miëth ke göök, ku jɔl kɔcken ye buɔɔth awuthueei ayuɔ̈p ku rec cï döŋ kuany gääcdït kathiäär ku rou. ");
INSERT INTO dikNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Naɣɔn akäl tök, tɛ̈wën röök Jethu ë rot, ke kɔc ye buɔɔth bɔ̈ tënë ye. Go Jethu ke thiëëc, “Lɛ̈kkë ɣa, ye jäŋ tak, ye ɣɛn ë ŋa?” ");
INSERT INTO dikNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Gokë lueel, “Ayekë lueel lɔn ye yïn Joon raan kɔc muɔɔc nhïïm. Ku lueel kuat dɛ̈t lɔn ye yïn Elija. Ku kɔc kɔ̈k ayekë lueel, lɔn ye yïn raan kam kɔc käk Nhialic tïŋ thɛɛr cï bɛn pïr.” ");
INSERT INTO dikNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Goke thiëëc, “Na week yakë lueel lɔn ye ɣɛn ŋa?” Go Pïtɛr bɛ̈ɛ̈r, “Yïïn nhom guɔ̈p, yïn ë raan cï Nhialic lɔc ku dɔɔc.” ");
INSERT INTO dikNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Kë ca lueel ë yic Pïtɛr. Ku thɔn ke apɛi ëlä, “Duɔ̈kkë lëk raan dɛ̈t.” ");
INSERT INTO dikNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Nawën ke lëk Jethu ke ëlä, “Manh Raan abï dhiɛl reem, ku abï kɔcdït baai ku bäny käk Nhialic, ku jɔl aa kɔc piööc löŋ kɔc Itharel jai, ku abïk nɔ̈k, ku yeen abï nïn kadiäk nɔ̈k piiny raŋ yic ku ben jɔt bï pïr.” ");
INSERT INTO dikNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ku lueel tënë ke ëbën, “Na ye raan wïc bä buɔɔth, ka dhil nhom määr käpuɔth bï yök piɛ̈rde yic pinynhom ë tɛ̈n. Ku dhil puɔ̈u riɛl ku buɔɔth ɣa akölaköl, cɔk alɔn wïc kɔc kɔ̈k ye bïk nɔ̈k ë riɛnkiɛ̈. ");
INSERT INTO dikNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Rin raan wïc ye bï wɛ̈ike kony abï muɔ̈r. Ku na ye raan mär wɛ̈ike ë riɛnkiɛ̈, ka bï wɛ̈ike muk akölriëëc ëbën. ");
INSERT INTO dikNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Yeŋö bï raan kuany thïn bï jak apɛi pinynhom ku mɛ̈r wɛ̈ike? ");
INSERT INTO dikNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Na ye raan guɔ̈p yär ë ɣa ku piɔ̈ɔ̈cdiɛ̈, ke Manh Raan abï guɔ̈p yär ye aya, aköl dhuk yen diɛɛkde yic ku diik Wun yic, ku diik atuuc Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ku le tueŋ ku lueel, wek alɛ̈k yic ala kɔc kɔ̈k rɛ̈ɛ̈r ë tɛ̈n, aacïï bï thou agut tɛ̈ bï kek ɣa tïŋ, kek riɛl ye nyuɔɔth lɔn ye ɣɛn bɛ̈ny cï Nhialic lɔc.” ");
INSERT INTO dikNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Nawën nïn kabɛ̈t cök cï yen käkkä lueel, ke Jethu cɔl Pïtɛr ku Jemith ku jɔl a Joon, ku lek gɔt nhom bïk la röök. ");
INSERT INTO dikNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Tɛ̈wën röök yen ke waŋ yenyin, ku ɣer aläthke apɛi bïk la diardiar. ");
INSERT INTO dikNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Kaam thiin awën ke röör tul ku jiɛɛmkë kek ye. Ku keek aake ye yï Mothith ku Elija. ");
INSERT INTO dikNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Keek aacï bɛ̈n ke la gup dhëëŋ Nhialic ku jiɛɛmkë tënë Jethu tɛ̈ bï yen la thou thïn Jeruthalem, rin bï yen kë wïc Nhialic jäl thöl. ");
INSERT INTO dikNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ku Pïtɛr kek kɔc awën cath ke ye, aake ye nïn muɔ̈r puɔ̈th. Nawën liepkë kenyïn ke tïŋ lɛc Jethu, ku röör karou ke kääc yelɔ̈ɔ̈m. ");
INSERT INTO dikNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nawën jiël ë röörkä, ke lueel Pïtɛr tënë Jethu, “Bɛ̈ny, apath buk rëër ë tɛ̈n. Ɣok aabï duɛ̈l kadiäk looi tök tënë yï, ku tök kek Mothith ku töŋ dɛ̈t kek Elija.” (Kënë jiɛɛm yen këya, ee kuc kënë bï lueel.) ");
INSERT INTO dikNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Kaam wën ŋot jiɛɛm yen, go kecït rur piny paat abï ciɛ̈n tɛ̈ yekë tïŋ. Gokë riɔ̈ɔ̈c wën kum rur ke piny. ");
INSERT INTO dikNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ku piŋkë Nhialic ke jam luäät yic ëlä, “Kënë ë Wëndiɛ̈, yen aca lɔc, piɛŋkë wɛ̈tde.” ");
INSERT INTO dikNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nawën cïk röl ben piŋ, ke ye Jethu yen tïŋkë ë rot. Go kɔc Jethu buɔɔth käkkä muk kepuɔ̈th ku cïk ke lëk raan dɛ̈t. ");
INSERT INTO dikNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Nawën dhukkë piny gɔt nhom aköl dɛ̈ɛ̈të, ke lor kɔc juëc apɛi. ");
INSERT INTO dikNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Kaam awën ke raan tök thän awën yic, cöt ke cie röl jɔt ku lueel, “Raan piööc, yïn aläŋ bä manhdiɛ̈ tïŋ, yen ë mänh töŋ tɔ̈ ɣanhom. ");
INSERT INTO dikNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Tɛ̈ dɔm ë jɔŋ ye, ka dhiau nyin yic, ku wit piny ku lɛth ku yïk thok ayɔ̈k. Jɔŋ kënë acïï ye lac päl piny, ku aye cɔl anäk rot apɛi. ");
INSERT INTO dikNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ɣɛn acï kɔckun yï buɔɔth lɔ̈ŋ bïk cuɔp wei yeguɔ̈p, ku akëckë lëu.” ");
INSERT INTO dikNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Go Jethu lɛ̈k ke, “Wek kɔc cie lac gam, ba rëër ke we, ke ɣa cïï guɔ̈p la cut wɛ̈lkun?” Ku lëk wun meth, “Bɛ̈ɛ̈i manhdu tɛ̈n.” ");
INSERT INTO dikNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kaam wën le dhɔ̈k tënë Jethu, ke wit jɔk piny ku lɛth. Go Jethu jɔk yɔ̈ɔ̈k bï jäl yeguɔ̈p, ku kony dhɔ̈k bï pial. Ku lëk wun bï jäl kek ye. ");
INSERT INTO dikNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ku jɔl raan ëbën gäi riɛl Nhialic. Tɛ̈wën ŋot rëër kɔc ke cï gäi käjuëc cï looi, ke lueel tënë atuɔ̈ɔ̈cke, ");
INSERT INTO dikNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Piɛŋkë wëlkä apath ku calkë ke aa lööny wepuɔ̈th, rin Manh Raan abï thɔ̈n kɔc bï ye nɔ̈k.” ");
INSERT INTO dikNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ku kɔcken ye buɔɔth aake këc wɛ̈t kënë deet yic, wɛ̈t ëcï moony tënë ke rin bïk cïï det yic. Ku keek aake cï riɔ̈ɔ̈c bïk thiëëc kë cï lueel. ");
INSERT INTO dikNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Nawën ke kɔc ye buɔɔth teer wɛ̈t lɔn yeŋa kamken yen dït apɛi. ");
INSERT INTO dikNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ku Jethu ë ŋic kë tɔ̈ kepuɔ̈th. Ku dɔm meth ku cɔl akääc yelɔ̈ɔ̈m. ");
INSERT INTO dikNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ku lëk ke, “Raan manh koor cït manh kënë lor ë riɛnkiɛ̈, acä lor. Ku raan ɣa lor, acie ɣɛn ye lor, ee Wä Aciëŋ ë toc ɣa. Rin raan koor kamkun ëbën, yen ë raandït.” ");
INSERT INTO dikNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Nawën ka atuny cɔl Joon bɔ̈ tënë Jethu ku lëk ye, “Bɛ̈ny, ɣok aacï mony dɛ̈t tïŋ keye jakrɛc cuɔp wei kɔc gup ë riɛnku, ku acuk pëën rin acie raanda.” ");
INSERT INTO dikNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Go Jethu lɛ̈k ye kek atuuc kɔ̈k aya, “Duɔ̈kkë ye pëën, rin raan cïï we man ë raandun.” ");
INSERT INTO dikNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Nawën cï nïn bï Jethu ɣäth nhial thiɔ̈k, go tak bï dhiɛl la Jeruthalem. ");
INSERT INTO dikNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ku tooc kɔc yenhom tueŋ bïk tɛ̈ bï kek la nyuc thïn la guiir pan tɔ̈ wun Thamaria. ");
INSERT INTO dikNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Go kɔc pan awën kuec rin ŋic kek ye lɔn Jethu ala Jeruthalem. ");
INSERT INTO dikNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nawën le kɔc Jethu buɔɔth, Jemith ku Joon, ŋic lɔn cï kɔc baai kuec bïk Jethu lor ke luelkë, “Bɛ̈ny, cuk mac cɔl abɔ̈ piny nhial bï pan kënë rac?” ");
INSERT INTO dikNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Go Jethu ke duɔ̈m thook piny, ");
INSERT INTO dikNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ku bɛrkë pan dɛ̈t tɔ̈ tueŋ. ");
INSERT INTO dikNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Tɛ̈wën kuɛny kek dhël yic, ke räm kek mony dɛ̈t cï ye bɛ̈n lɛ̈k Jethu ëlä, “Yïn aba biaath kuat tɛ̈ ler yïn thïn.” ");
INSERT INTO dikNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Go Jethu bɛ̈ɛ̈r, “Luɔny aa la ɣöötken yekë ke wuut, ku diɛt pär aa la ɣɔ̈ɔ̈tken aya. Ku ɣɛn Manh Raan ɣɛn acïn baai pinynhom tɛ̈n.” ");
INSERT INTO dikNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ku lueel Jethu tënë mony dɛ̈t, “Buɔth ɣa.” Go bɛ̈ɛ̈r, “Bɛ̈ny, cɔl ɣɛn akɔŋ wä la thiɔ̈k.” ");
INSERT INTO dikNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Go Jethu bɛ̈ɛ̈r, “Cɔl kɔc cït kɔc cï thou aa thiäk kacken, ku yïïn bäär ba Wɛ̈t Puɔth Yam bɛ̈n la piɔ̈ɔ̈c.” ");
INSERT INTO dikNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ku lueel mony dɛ̈t, “Yïn aba buɔɔth Bɛ̈ny, ku cɔl ɣɛn akɔŋ kackiɛ̈ la tɔ̈ɔ̈ŋ.” ");
INSERT INTO dikNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Go Jethu lɛ̈k ye, “Yïn acït raan dhie pur, na tïŋ raan dɛ̈t cath, ke cuɛt pur piny ku kɛɛŋ nhom ku ruɛc. Këya, raan ye käk kɔ̈k nyaai luɔi ca guiër ye yic, acïn këpuɔth lëu bï looi rin bääny Nhialic.” ");
INSERT INTO dikNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Nawën ë kënë cök, ke Jethu kuany kɔc kɔ̈k kathiärdhorou ku rou kam kɔc ye buɔɔth, ku tooc ke tueŋ bï kɔc karou aa cath, bïk la gɛɛth ku bɛ̈ɛ̈i ke bï yen la thïn yiic. ");
INSERT INTO dikNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ku lëk ke, “Käk tem ajuëc ku kɔc luɔi aa lik. Rɔ̈ɔ̈kkë Bɛ̈ny la nhom käk tem bï kɔc luɔi cɔl aa juak röt. ");
INSERT INTO dikNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Lak! Ku ŋiɛckë, wek atuɔɔc cïmën amɛ̈l ë kam gal. ");
INSERT INTO dikNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Duɔ̈kkë wëëu ku jɔkgɔɔ ku war kɔ̈k muk. Ku duɔ̈kkë ye kɔ̈ɔ̈c dhɔ̈l yiic bäk kɔc aa muɔ̈ɔ̈th. ");
INSERT INTO dikNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Tɛ̈ ɣeet wek baai ke kaŋkë lueel, ‘Kɔc baai yakë dɔ̈ɔ̈r.’ ");
INSERT INTO dikNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ku na ye kɔc rɛ̈ɛ̈r ë pan kɔc nhiar dɔ̈ɔ̈r, ke rɔ̈ɔ̈kkun aabï ke dɔɔc. Ku na yekë kɔc man dɔ̈ɔ̈r, ke rɔ̈ɔ̈kkun aacïï ke bï kony. ");
INSERT INTO dikNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ku yakë rëër ë pan ku miëthkë ku dɛ̈kkë käk yekë yiëk we, rin apath bï raan lui ariɔ̈pde yök. Duɔ̈kkë ye jäl pan ku lak pan. ");
INSERT INTO dikNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Na lor kɔc gen cï wek la thïn we, ke we cam kuat miëth cïk gäm we. ");
INSERT INTO dikNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ku kuɔnykë kɔc tuany ku lɛ̈kkë ke, ‘Bääny Nhialic acï thiɔ̈k ke we.’ ");
INSERT INTO dikNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ku na lak gen cïï we ye lor thïn, ke we jiël ku luɛlkë, ");
INSERT INTO dikNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ɣok aabï tɔr gɛndun tɛŋ wei ɣocök bï döŋ kek we.’ Ku dhiɛlkë deet apath, bääny Nhialic acï thiɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Awuɔ̈c bï Nhialic tɛ̈m kɔc Thidon aköl luŋdït abï kuur tënë awuɔ̈c bï tɛ̈m kɔc ë gen. ");
INSERT INTO dikNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Wek kɔc gen Koradhin ku Bethaida, wek aa tiit kärɛc apɛi, rin käjuëc jäŋ gɔ̈i cäk tïŋ cï ke looi gɛɛthkun yiic, ku ke cï looi Tire ku Thidon, gɛɛth wäär ceŋ kɔc rac, ŋuɔ̈t kɔc ë gɛɛthkä aacï kepuɔ̈th dhuɔ̈k ciëën thɛɛr, ku pälkë luɔi kärɛc. ");
INSERT INTO dikNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ku Nhialic abï we tɛ̈m awuɔ̈cdït Aköl luŋdït, awuɔ̈c bï dït apɛi tënë awuɔ̈c bï tɛ̈m kɔc Tire ku Thidon. ");
INSERT INTO dikNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ku wek kɔc Kapernaum yakë tak lɔn bï we jat nhial? Wek aabï cuat pan mac.” ");
INSERT INTO dikNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ku lueel Jethu tënë kɔc wën cï tooc, “Raan piŋ wɛ̈tdun ë wɛ̈tdiɛ̈ piŋ, ku raan we dhɔ̈l gup acä dhɔ̈l guɔ̈p, ku raan dhäl ɣaguɔ̈p ë raan toc ɣa dhɔ̈l guɔ̈p.” ");
INSERT INTO dikNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Go kɔc thiärdhorou ku rou wën dhuk ke cï puɔ̈th miɛt ku luelkë, “Bɛ̈ny agut jakrɛc aya aacï wɛ̈tda piŋ ë riɛnku.” ");
INSERT INTO dikNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Go Jethu lɛ̈k ke, “Riɛl jɔŋrac acï riääk ku tiɛ̈ŋ ke lööny piny cïmën many nhial. ");
INSERT INTO dikNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Wek aca yiëk riɛl bï wek aa cath käpiɛny ku kith nhïïm ë path. Ku wek aca yiëk riɛl wɛ̈r wek alɛikun ku kɔc man we. Ku acïn kë kɔŋ we nɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ku duɔ̈kkë puɔ̈th jɔl miɛt rin cï jakrɛc wɛ̈tdun piŋ, miɛtkë puɔ̈th rin cï riɛnkun gɔ̈t pan Nhialic.” ");
INSERT INTO dikNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nawën ke Wëi Nhialic cɔl Jethu amit puɔ̈u ku lueel, “Wä, Bɛ̈ny nhial ku piny! Yïn alɛɛc rin cï yïn käk cï thiaan tënë kɔc ŋic käŋ cï piöc, nyuɔ̈th kɔc kor këc piöc. Ee tɛ̈de, Wä, yen ë kën yï yuum puɔ̈u. ");
INSERT INTO dikNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Këriëëc ëbën aacï Wä gäm ɣa. Acïn raan ŋic Wënde ë Wun ë rot, ku acïn raan ŋic Wun ë Wënde ku kɔc cï Wënde lɔc bï nyuɔ̈th ke.” ");
INSERT INTO dikNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Tɛ̈wën rëër Jethu kek kɔcken ye buɔɔth ë röt, ke wël yenhom ke ku lueel, “Wek aala gup duaar bäk käk tiɛ̈ŋkë tïŋ. ");
INSERT INTO dikNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ku alɛ̈k we, ëcï kɔc juëc käk Nhialic tïŋ ku bänydït wïc bïk käk yakë tïŋkä tïŋ, ku aa këckë ke tïŋ. Ku ë cïk wïc aya bïk käk yakë piŋ, piŋ, ku aa këckë ke piŋ.” ");
INSERT INTO dikNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Raan piööc ë löŋ kɔc Itharel, ëcï bɛ̈n ku wïc bï Jethu deep ë wɛ̈t ku thiëëc, “Raan piööc, yeŋö ba looi ba pïr akölriëëc ëbën pan Nhialic?” ");
INSERT INTO dikNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Go Jethu bɛ̈ɛ̈r, “Ye Löŋ Mothith lueel këdë ë wɛ̈t kënë? Yeŋö ye deet yic thïn?” ");
INSERT INTO dikNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Go bɛ̈ɛ̈r, “Yïn adhil Nhialic Bänydu nhiaar yïpuɔ̈u ëbën, ku wɛ̈iku ëbën, ku yïnhom ëbën, ku nhiar raan dɛ̈t cïmën nhiɛɛr yïn rot.” ");
INSERT INTO dikNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Go Jethu lueel, “Aca ŋiɛc bɛ̈ɛ̈r. Loi käkkä, ku pïr pan Nhialic akölriëëc ëbën aba yök.” ");
INSERT INTO dikNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Go monytui wïc bï wɛ̈t deet apath rin wïc yen ye bï rot kony, ku ben Jethu thiëëc, “Raandiɛ̈n ba nhiaar yeŋa?” ");
INSERT INTO dikNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Go Jethu bɛ̈ɛ̈r ku lueel, “Monytui, ke ye raan Itharel, ëcï jäl Jeruthalem bï la Jeriko. Go rɔ̈m ke cuɛ̈r dhël yic ku rumkë aläthke ku wɛ̈ɛ̈uke ëbën, ku näkkë ku jɔlkë nyääŋ piny ke duër thou. ");
INSERT INTO dikNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nawën ke raan käk Nhialic, ke ye raan Itharel, bɔ̈ ke kuany dhël kënë yic, go monytui tïŋ ku wɛɛn thok piiny. ");
INSERT INTO dikNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nawën ke raan dhiënh Lebï ben bɛ̈n, go mony kënë tïŋ ku bɛ̈r. ");
INSERT INTO dikNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Go raan pan Thamaria bɛ̈n ke kuany ë dhël kënë yic. Nawën tïŋ mony kënë piiny ke ŋɛɛr yic. ");
INSERT INTO dikNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Go rot cuɔ̈t ye, ku muɔɔc ɣɔ̈ntöök yiic miök ku muɔ̈n abiëc ku der keyiic, ku jɔt akaja kɔ̈u ku ɣɛ̈th pan jɔ̈ɔ̈l, ku rëër yelɔ̈ɔ̈m ë wɛ̈ɛ̈r wën. ");
INSERT INTO dikNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Naɣɔn nhiäk, ke gɛm wëëu tënë raan lui pan jɔ̈ɔ̈l ku lëk ye, ‘Lök mony kën töök apath, na la dhuk ku le wëëu ca lɔ̈k muɔ̈r ë riɛnke tɛ̈ lik wɛ̈ɛ̈ukiɛ̈, ka ba bɛ̈n cool.’ ” ");
INSERT INTO dikNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ku wit Jethu wɛ̈tde ku lueel ëlä, “Na ye yï, ke raan cï cuɛ̈r baŋ, yeŋa kam kɔc awën kadiäk ë raande?” ");
INSERT INTO dikNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Go lueel, “Raan cï ye kony yen ë raande.” Go Jethu lueel, “Lɔɔr, ku ye luui këya.” ");
INSERT INTO dikNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Tɛ̈wën ciɛth Jethu kek atuɔ̈ɔ̈cke ke la Jeruthalem, gokë nyuc gen thiin tɔ̈ dhël yic. Go tiŋ cɔl Martha ke ɣäth baai. ");
INSERT INTO dikNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ku Martha a la nyankën cɔl Maria, cï bɛ̈n nyuc Jethu lɔ̈ɔ̈m bï piɔ̈ɔ̈cde piŋ. ");
INSERT INTO dikNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Go Martha puɔ̈u riääk rin këc Maria ye kony luɔi miëth tënë jɔ̈ɔ̈l. Go bɛ̈n tënë Jethu ku lueel, “Bɛ̈ny, ye këpath yen looi nyankäi cï yen ɣa päl luɔi ë rot tɛ̈thɛɛr awën? Lɛ̈k ye bä bɛ̈n kony.” ");
INSERT INTO dikNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Go Bänyda bɛ̈ɛ̈r ku lueel, “Yïn Martha, yïn adiɛɛr rin awïc ba käjuëc tɔ̈ yïpuɔ̈u looi ëbën, ");
INSERT INTO dikNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ku ë tök yen aril, Maria acä abaŋ ŋuɛ̈ɛ̈n kuɛ̈ny bei, ku acïï bï nyaai tënë ye.” ");
INSERT INTO dikNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ɣɔn akäl tök Jethu ë rɔ̈ɔ̈k, nawën cï rɔ̈ɔ̈kde jal thök, ke lueel raan tök kam kɔcken ye buɔɔth tënë ye, “Bɛ̈ny, piɔ̈ɔ̈c ɣo tɛ̈ bï ɣok aa röök thïn, cïmën wäär cï Joon raan kɔc muɔɔc nhïïm kɔcken ye buɔɔth piɔ̈ɔ̈c.” ");
INSERT INTO dikNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Go Jethu lɛ̈k ke, “Yakë lueel këlä tɛ̈ röök wek, ‘Wädan tɔ̈ nhial, bï riɛnku aleec. Bï bäänydu bɛ̈n ɣoyiic. ");
INSERT INTO dikNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Muɔc ɣook miëth akölaköl. ");
INSERT INTO dikNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ku päl adumuɔ̈ɔ̈mkua piny tënë ɣook, rin ye ɣok wɛ̈t puɔ̈l tënë kɔc rɛc ɣook. Ku duk ɣook cɔl athem kërac.’ ” ");
INSERT INTO dikNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Ku ben Jethu lɛ̈k kɔcken ye buɔɔth, “Tɛ̈dë, na yïn ala mäthdu ku lɔr tënë ye wakɔ̈u wɛ̈ɛ̈r ciɛl yic ku luel tënë ye, ‘Mäthdiɛ̈ gäm ɣa ayuɔ̈p kadiäk. Rin mäthdiɛ̈n cï la keny acï bɛ̈n paandiɛ̈, ku ɣɛn acïn miëth gäm ye.’ ");
INSERT INTO dikNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ku bëër ɣööt alɔŋ thïn ku lueel, ‘Duk ɣa rɛ̈ɛ̈m nhom. Ɣöt acï gur thok, ku ɣok aacï tɔ̈c ɣok miɛ̈thkiɛ̈. Ɣɛn acïï rot ben jɔt ba yï gäm ayuɔ̈p.’ ");
INSERT INTO dikNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ku la Jethu tueŋ ku lueel, na cɔk alɔn cïï monyë rot jɔt bï gäm ayuɔ̈p rin yen mäthdu, ka ŋot bï rot jɔt bï gäm kuat kë wïc, rin yïn acïï guɔ̈p bï riɔ̈ɔ̈c ë ye, ku lɔɔr tueŋ ke thiëc. ");
INSERT INTO dikNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Këya alɛ̈k we, thiëc, ku abï Nhialic gäm yï, na wïc këdäŋ tënë Nhialic ka yök. Ku ë tɛ̈de aya, na gut ɣöt thok, ka ŋany thok tënë yï. ");
INSERT INTO dikNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Raan thiëc aye gäm ke wïc, ku raan la kë wïc aye yök. Ku ɣöt aye ŋaany thok tënë raan wïc ye. ");
INSERT INTO dikNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Yeŋa kamkun na le meth, ku thiëëc manhde miëth ke gɛ̈m këpiiny tɛ̈ wïc yen rɛ̈c. ");
INSERT INTO dikNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ku na wïc tuɔŋ ajïth, ke dɔm kiɛth ku gɛ̈m ye. ");
INSERT INTO dikNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Na ŋiɛckë wek kɔc ë luui kärɛc bäk miɛ̈thkun aa gäm käpath, ke cäk lëu bäk ŋic lɔn bï Wuurdun tɔ̈ nhial ye ŋic apɛi bï Wëi Nhialic tuɔ̈c kɔc thiëc ye.” ");
INSERT INTO dikNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Naɣɔn akäl tök ke Jethu ë cop jɔŋrac wei raan guɔ̈p, ku ëcie jam. Nawën cï jɔŋë jäl yeguɔ̈p ke mony awën jam. Go thän awën tɔ̈ thïn gäi apɛi, ");
INSERT INTO dikNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ku lueel kɔc kɔ̈k, “Ee Beldhebul bɛ̈ny jakrɛc yen ë ye yiëk riɛl bï ke aa cuɔp wei.” ");
INSERT INTO dikNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ku ë wïc kɔc kɔ̈k bïk deep wɛ̈t, ku thiëckë bï kënë jäŋ gɔ̈i looi, bï nyuɔ̈th ke lɔn ye Nhialic käkke gam. ");
INSERT INTO dikNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ku Jethu ë ŋic kë yekë tak, go lɛ̈k ke, “Na tek kɔc paan tök keyiic ku thɛ̈rkë ë kamken, ke pan kënë abï riääk. Ku na tuum dhiënh tök yenhom aya ku thɛ̈rkë kamken ë röt, ke dhiënh kënë abï wɛɛr aya. ");
INSERT INTO dikNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Këya, na tek jakrɛc keyiic ku thɛ̈rkë ë kamken ke cïï thök? Ayakë lueel lɔn ye ɣɛn jakrɛc cuɔp wei riɛl ye Beldhebul gäm ɣa. ");
INSERT INTO dikNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ku na ye riɛl Beldhebul yen ye ɣɛn jakrɛc cuɔp wei, ke ye riɛl ŋa yen ye kɔckun yakë buɔɔth ke cuɔp wei? Calkë ke aa lëk we yic. ");
INSERT INTO dikNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ku na ye riɛl Nhialic yen ye ɣɛn jakrɛc cuɔp wei, ke ŋiɛckë lɔn cï bääny Nhialic bɛ̈n tënë we. ");
INSERT INTO dikNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Na tit raan ril paande thok ë tɔɔŋ ku köt, ke käkke aacïï nyiɛɛi. ");
INSERT INTO dikNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ku na mɛ̈t raan dɛ̈t ril, ka wer ye. Ku jɔl käk muk bï yen rot tiit nyaai ëbën, ku tek käk cï rum. ");
INSERT INTO dikNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Raan këc rot mät ɣa acie raandiɛ̈, ku raan cïï ɣa kony bï kɔc lɛ̈k wɛ̈t Nhialic, ee kɔc thiɔ̈i. ");
INSERT INTO dikNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Tɛ̈ cï jɔŋrac jäl raan guɔ̈p, ee piny yɔ̈ɔ̈p tɛ̈dɛ̈t bï yen lɔ̈ŋ thïn. Na cïn tɛ̈ yök, ka lueel, ‘Ɣɛn abï dhuk tënë raan wäär jiël ɣɛn thïn.’ ");
INSERT INTO dikNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ku dhuk ku yök raan wäär, ke cït ɣön cï guiir yic apath, ");
INSERT INTO dikNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ku dhuk ku le bɛ̈n kek jakrɛc apɛi kɔ̈k kadhorou wär ye, ku lek yeguɔ̈p. Ku pïr ë raan kënë ë jäl rɛ̈ɛ̈c apɛi tënë pïrden tueŋ.” ");
INSERT INTO dikNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Kaam wën jiɛɛm yen këlä, ke tik jam röldït kɔc yiic ku lëk ye, “Tiŋ ë dhiëth yï ku muk yï amit guɔ̈p apɛi.” ");
INSERT INTO dikNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Go Jethu bɛ̈ɛ̈r ku lueel, “Ee yic, ku kɔc mit gup alanden aa kɔc wɛ̈t Nhialic piŋ ku loikë.” ");
INSERT INTO dikNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tɛ̈wën cï kɔc juëc kenhïïm kut Jethu lɔ̈ɔ̈m, ke lueel, “Yeŋö be riëëc akölë rɛ̈ɛ̈c këlä? Ee riëëc ye wïc bï kënë jäŋ gɔ̈i tïŋ. Ku acïn kë bï nyuɔ̈th ke. Ee kënë jäŋ gɔ̈i wäär cï rot looi tënë Jona yen abïk tïŋ. ");
INSERT INTO dikNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Cïmën wäär cï Jona raan käk Nhialic tïŋ jäl a kït tënë kɔc Ninibe, këya Manh Raan abï jäl a kït tënë kɔc akölë ëbën. ");
INSERT INTO dikNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Tiŋ bɛ̈ny wäär jiël pan Athia abï rot jɔt aköl luŋdït ku gɛ̈k riëëc akölë, rin cï yen jäl tɛ̈mec apɛi bï wël puɔth bɛ̈nyŋaknhom Tholomon la piŋ, ku ɣɛn jam kën, ɣɛn adït tënë Tholomon. ");
INSERT INTO dikNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Aköl luŋdït kɔc gen Ninibe aabï we gɔ̈k rin cï kek kepuɔ̈th waar, ku pälkë luɔi kärɛc wäär cï Jona ke lɛ̈k. Ku alɛ̈k we, ɣɛn jam kënë, ɣɛn adït tënë Jona. ");
INSERT INTO dikNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Acïn raan cï mermer kaŋ ɣäth ɣöt ku kum nyin. Aye tɔ̈ɔ̈u tɛ̈n ye yen ɣöt mer yic thïn, bï piny amer tënë raan la ɣöt. ");
INSERT INTO dikNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Puɔ̈n path acït nyin path. Raan path nyin ë daai apath, acïï thöŋ kek raan cï cɔɔr cie daai apath. ");
INSERT INTO dikNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Këya, luɔikë röt bäk puɔ̈th la cök, ku duɔ̈kkë puɔ̈th cɔɔr. ");
INSERT INTO dikNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Na yïn aɣer puɔ̈u, ke yïn acït raan këc cɔɔr ë daai apath cïmën dhie ye mac piny riaal.” ");
INSERT INTO dikNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nawën cï Jethu thök ë jam, ke cɔɔl raan töŋ akut Parathï paande bïk la mïth, go la ku nyuuc ku mïth ke këc yecin ku yecök lɔɔk cïmën ciɛɛŋ kɔc Itharel. ");
INSERT INTO dikNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Kënë, acï raan akut Parathï wën la baai bɛ̈n gɔ̈i apɛi. ");
INSERT INTO dikNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Go Jethu lueel tënë ye, “Wek kɔc akut Parathï, aa wegup aɣeer kek yakë lɔɔk, ku piäthkun aacï thiäŋ kärɛc apɛi. ");
INSERT INTO dikNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Kɔc cïn kë ŋiɛckë! Këc Nhialic yen cak guɔ̈p, puɔ̈u alɔŋthïn cak aya? ");
INSERT INTO dikNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Biökruɛɛl aye nyuɔɔth puɔ̈n ɣer tɛ̈ muɔɔc yïn kɔc, ku acie miɔ̈c ye yïn biökruɛɛl nyuɔɔth ë path. ");
INSERT INTO dikNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Tɛ̈ rɛɛc yen thïn tënë we, kɔc akut Parathï. Wek aa Nhialic juɛ̈r kälik, käk cït tök ë thiäär yic käkkun yakë ke puur ë dum yiic, ku kuat wɛl kɔ̈k ëbën. Ku wɛ̈t la cök ku nhiɛ̈r Nhialic akuɔ̈ckë looi. Käkkä aa dhiɛlkë looi, ku luɔikë käkkä aya. ");
INSERT INTO dikNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Tɛ̈ rɛɛc yen thïn tënë we, kɔc akut Parathï. Ayakë nhiaar bäk aa nyuc tueŋ thöc kɔcdït nhïïm tɛ̈n amat, ku ye we muɔ̈ɔ̈th athɛ̈ɛ̈k ɣɔ̈n ë ɣɔɔc yiic. ");
INSERT INTO dikNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Tɛ̈ rɛɛc yen thïn tënë we, wek aa thöŋ kek rɛ̈ŋ cïn kë ye ke ŋic, ye kɔc cath kenhïïm ë path, ku kärɛc cïk thiaan keyiic piiny aacïï ŋic.” ");
INSERT INTO dikNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Nawën, ke raan tök kɔc piööc ë lööŋ jɔt rot ku lueel tënë ye, “Bɛ̈ny, tɛ̈ jiɛɛm yïn këlä, ke yïn ë ɣo lat aya.” ");
INSERT INTO dikNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Go Jethu bɛ̈ɛ̈r, “Wek kɔc piööc ë lööŋ, kärɛc aa tit we aya. Wek aa kɔc piööc käril apɛi cie lëu bï ke looi. Ku wek aacie kɔc kony aya ë luɔiden. ");
INSERT INTO dikNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Tɛ̈ rɛɛc yen thïn tënë we. Awëëŋkui, wek aa rɛ̈ŋ path buth tënë kɔc käk Nhialic tïŋ, kɔc wäär nɛ̈k wärkun dït. ");
INSERT INTO dikNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Acäk gam lɔn këwäär cï wärkun dït looi apath, ku na we tɔ̈ thïn ŋuɔ̈t wek cï näk aya. Rin aacï kɔc käk Nhialic tïŋ nɔ̈k ku buɔ̈thkë räŋken. ");
INSERT INTO dikNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ku rin ë wɛ̈t kënë yen acï Nhialic ye lɛ̈k we ëlä, ‘Wek aaba tuɔ̈c kɔc käkkiɛ̈ tïŋ ku atuuc. Ku wek aabï kɔc kɔ̈k nɔ̈k ku cuɔpkë kɔc kɔ̈k wei.’ ");
INSERT INTO dikNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Riëëc akölë abï tɛ̈m awuɔ̈c rin cï yen kɔc käk Nhialic tïŋ nɔ̈k tɛ̈wäär cɛk piny ɣëët ëmën, ");
INSERT INTO dikNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","jɔɔk ë nääk Abel ɣet nääk Dhäkaria wäär näk luaŋ Nhialic. Ku ben Jethu lɛ̈k ke, riëëc akölë abï tɛ̈m awuɔ̈c rin ë käkkä ëbën! ");
INSERT INTO dikNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Tɛ̈ rɛɛc yen thïn tënë we, wek aa yic moony tënë kɔc ku acäk ye gam kek week ë röt. Ku wek aa kɔc kɔ̈k wïc yic bïk gam gël!” ");
INSERT INTO dikNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Nawën wïc Jethu bï jäl, ke jiëëm kɔc akut Parathï ku kɔc piööc lööŋ guɔ̈p apɛi, ku thiëckë wël juëc ku wïckë bï ke dhiɛl dhuk nhïïm, ");
INSERT INTO dikNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","rin wïc kek ye bïk deep wɛ̈t bïk dɔm, tɛ̈ le yen wɛ̈t rɛɛc lueel. ");
INSERT INTO dikNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Wën cï käkkä röt looi, ke kɔc juëc apɛidït aake cï kenhïïm kut Jethu lɔ̈ɔ̈m abï ciɛ̈n tɛ̈ ye cök cak la piny. Tɛ̈wën ke Jethu kɔŋ jam tënë kɔcken ye buɔɔth ku lëk ke, “Tiɛtkë röt, ku duɔ̈kkë ye luui cïmën kɔc akut Parathï, kɔc ë kɔc ruëëny. ");
INSERT INTO dikNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Acïn kë ye moony arɛ̈k abï cïï tiɛ̈c. Tɛ̈dë ke lëu bï këdäŋ thiaan abï cïï ŋic. ");
INSERT INTO dikNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Na cɔk a wɛ̈t luel wakɔ̈u ka ŋot piŋ nhiäk aköl. Ku këriëëc ëbën cäk ŋääi weyïth ɣööt alɔŋthïn ke ɣöt cï thiöök thok aŋot ye kɔc kɔ̈k piŋ. ");
INSERT INTO dikNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ku alɛ̈k we wek mäthkiɛ̈, duɔ̈kkë riɔ̈c kɔc guäpkun nɔ̈k ë path. Aa we nɔ̈k ku na lä ka cïn këdɛ̈t ben kë looi. ");
INSERT INTO dikNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ee Nhialic yen adhil kɔc riɔ̈ɔ̈c, rin na cï nɔ̈k ka la riɛl aya bï cuat pan mac. Alɛ̈k we, ee Nhialic ë rot yen adhil kɔc riɔ̈ɔ̈c. ");
INSERT INTO dikNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Diɛt thii kor kadhiëc cït amuɔ̈r, cïï ke ye ɣɔɔc wëëu lik? Ku acïn tök ë kamken cï Nhialic kaŋ muɔ̈r nhom, ");
INSERT INTO dikNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","agut nhïmkun tɔ̈ yïnhom aŋic Nhialic akuɛ̈nden. Duɔ̈kkë riɔ̈c, wek aa awär amuɔ̈r juëc. ");
INSERT INTO dikNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Alɛ̈k we, raan ye gam kɔc nhïïm lɔn ye yen raan Manh Raan, aba gam aya lɔn ye yen raandiɛ̈ atuuc Nhialic nhïïm. ");
INSERT INTO dikNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ku raan jɛi kɔc nhïïm lɔn cïï yen ye raandiɛ̈, abï Manh Raan kuec aya atuuc Nhialic nhïïm.” ");
INSERT INTO dikNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ku ben Jethu lɛ̈k ke, “Kuat raan wɛ̈t rac luɛɛl Manh Raan guɔ̈p abï päl piny tënë ye, ku raan lueel kërac Wëi Nhialic guɔ̈p, acïï bï kaŋ päl piny tënë ye. ");
INSERT INTO dikNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Tɛ̈ ɣɛ̈th yï tɛ̈n amat luk yic, bäny dït ku bäny kor nhïïm, duk diɛɛr tɛ̈ bï yïn rot kuɔny thïn ku wɛ̈t ba lueel, ");
INSERT INTO dikNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","rin Wëi Nhialic abï cɔl aŋic kë ba lueel.” ");
INSERT INTO dikNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Go mony dɛ̈t rot jɔt kɔc yiic ku lueel, “Bɛ̈ny lɛ̈k wämääth bä yiëk abäkkiɛ̈ käk cï wä nyäŋ ɣo yiic.” ");
INSERT INTO dikNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Go Jethu bɛ̈ɛ̈r, “Mäthdiɛ̈, yeŋa cä kuany ba ya bɛ̈ny, ba käŋ tɛ̈k we?” ");
INSERT INTO dikNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ku lëk kɔc awën tɔ̈ thïn, “Tiɛtkë röt, duɔ̈kkë jiɛɛk cɔl arum wepuɔ̈th. Acïn raan rëër piɛ̈rde yecin cɔk alɔn le yen käjuëc.” ");
INSERT INTO dikNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ku lëk ke kääŋ kënë, “Thɛɛr raan ajak ë tɔ̈ thïn, ku duɔmde ëcï luɔk rap juëc apɛi. ");
INSERT INTO dikNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Go jal jam ku lueel, ‘Yeŋö ba jal looi? Ɣɛn acïn duël lääu yic bï ɣɛn ke tɔ̈ɔ̈u thïn.’ ");
INSERT INTO dikNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Nawën ke tɛk ku lueel, ‘Kë ba looi akïn. Duël kënë aba ŋaany, ku bɛn duëldït apɛi looi bï ɣɛn rap ku käk kɔ̈k baai tääu thïn. ");
INSERT INTO dikNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ku jal lɛ̈k rot ɣatök. Mony mit guɔ̈p, yïn ala mïïth juëc apɛi bï run juëc nɔ̈k, jɔl pïr apath, miëthë ku dɛ̈kkë, ku jɔl puɔ̈u miɛt!’ ");
INSERT INTO dikNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Go Nhialic lɛ̈k ye, ‘Raan kuc käŋ! Ee wɛ̈ɛ̈r kënë, yïn abï thou ku käjuëc ca täu rot kë, bïk lɔ̈k aa käk ë ŋa?’ ” ");
INSERT INTO dikNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ku wit Jethu wɛ̈tde ëlä, “Kënë, yen ë rot looi tënë kɔc käjuëc tɔ̈ɔ̈u ë riɛnken, ku acïn jiɛɛk Nhialic tɔ̈ kepuɔ̈th.” ");
INSERT INTO dikNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ku wël Jethu yenhom kɔcken ye buɔɔth ku lueel, “Këya alɛ̈k we, bäk röt cïï cɔl anɛ̈k diɛɛr kë bäk cam bäk pïr. Ku diɛɛrkë aya käk bäk ceŋ. ");
INSERT INTO dikNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Wëi aŋuɛ̈ɛ̈n tënë miëth, ku guɔ̈p raan aŋuɛ̈ɛ̈n tënë alɛ̈th. ");
INSERT INTO dikNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Daaikë diɛt pär nhial, aacie pur rap ku temkë ke, ku tɛ̈ɛ̈ukë ke atuɔk yic, ku aa ŋot ke pïr rin ye Nhialic ke yiëk miëth. Ku wek aa ŋuɛ̈ɛ̈n apɛi tënë ke. ");
INSERT INTO dikNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Yeŋa kamkun na diir ë wɛ̈ike ke juak ruɔ̈nke? ");
INSERT INTO dikNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Na cäk käk thiikä ye lëu, yeŋö ye wek diɛɛr käk kɔ̈k? ");
INSERT INTO dikNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Tiɛ̈ŋkë yɔ̈k cil tɛ̈ dhëëŋ kek thïn, aacie luui ku aacie luui alɛ̈th. Ku alɛ̈k we na cɔk a bɛ̈nyŋaknhom Tholomon cïmënden wäär ë bäänyde yic, ëcïï la alɛ̈th la kït dhëŋ cïmën yäŋ tök ë yɔ̈kkë yiic. ");
INSERT INTO dikNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ku na ye Nhialic wɛl cil ë path cɔl adhëŋ këlä, wɛl tɔ̈ thïn akölë ku na nhiäk nïn lik ke ril wei ku took ke mac, ke Nhialic cïï we bï kuɛ̈ɛ̈c nhïïm, wek aa kɔc la gam thin koor. ");
INSERT INTO dikNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Duɔ̈kkë wenhïïm ye yiëk kë bäk cam ku kë dɛkkë akölaköl. ");
INSERT INTO dikNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Aa kɔc kuc wɛ̈t Nhialic pinynhom ë tɛ̈n kek aa kepuɔ̈th yiëk käkkä. Ku Nhialic Wuurdun aŋic lɔn wïc wek käkkä. ");
INSERT INTO dikNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Na ye këya, yakë ke wïc käk bääny Nhialic, ku aabï yiëk we aya. ");
INSERT INTO dikNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Duɔ̈kkë riɔ̈c wek kɔc buɔth ɣa rin Wuurdun amit puɔ̈u bï we yiëk ë bäänyë. ");
INSERT INTO dikNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ɣaackë käkkun ku gämkë wëëu kɔc ŋɔ̈ŋ. Kënë abï jaakdun juak yic pan Nhialic. Ku jiɛɛk pan Nhialic acie thök, ku acie riääk cïmën jiɛɛk pinynhom, rin acïn cuɛ̈r tɔ̈ thïn. Ku acïï aruɔp ye rac. ");
INSERT INTO dikNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ku piändu abï ya rëër akölaköl tɛ̈ tɔ̈u jaakdu thïn. ");
INSERT INTO dikNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Rɛ̈ɛ̈r yï cï rot guiir akölaköl, ku rɛ̈ɛ̈r yï muk mermer rin kuat kë bï rot looi bï yök wakɔ̈u, ");
INSERT INTO dikNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","cïmën alony lui baai tit bänyden cï la yan thiëëk yic ke bï dhuk baai. Na bï ke go ɣöt guɔ ŋaany thok tënë ye. ");
INSERT INTO dikNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Aloony mit gup aa loony ye bänyden yök ke tït tɛ̈ dhuk yen baai. Alëk we alanden, bɛ̈ny abä alanhden luɔi ruɔ̈k, ku cɔl ke aa nyuc bïk mïth ku luui tënë ke. ");
INSERT INTO dikNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Tɛ̈dë, ke bɛ̈ny abï dhuk baai wɛ̈ɛ̈r ciɛl yic, tɛ̈dë ke dhuk bɛ̈ɛ̈k ë piny. Ku aloony mit gup aa loony bï bäny yök ke tït. ");
INSERT INTO dikNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Wek aa lëu kënë bäk deet yic ë röt. Na raan ye wɛ̈ɛ̈r alɔŋ bï cuär bɛ̈n ŋic, ka rɛ̈ɛ̈r ke yiën bï cuär käkke cïï kual. ");
INSERT INTO dikNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ke week aya rɛ̈ɛ̈rkë we tït, rin wek aa kuc aköl bï Manh Raan bɛ̈n.” ");
INSERT INTO dikNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Go Pïtɛr lueel, “Bɛ̈ny, ye ɣok lɛ̈k ë kääŋ kënë aye kɔc ëbën?” ");
INSERT INTO dikNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Go Bɛ̈ny dhuk nhom ku lueel, “Na ye këya, yeŋa alony path ku ŋic käŋ apɛi? Yeen alony bï bɛ̈ny nyääŋ käkke yiic paande, bï kacke ya gäm miëth akölaköl. ");
INSERT INTO dikNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Alony mit guɔ̈p alony bï bɛ̈ny yök ke loi luɔide apath tɛ̈ dhuk yen. ");
INSERT INTO dikNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Alëk we, abï alony kënë tääu käkke yiic ëbën. ");
INSERT INTO dikNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ku na ye alony ye tak lɔn cïï bänyde bï lac dhuk. Ku ye rëër ke näk aloony kɔ̈k, röör ku diäär. Ku ye cool ke mïth ku dëk abï wiɛɛt. ");
INSERT INTO dikNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ke bänyde abï la luät yeguɔ̈p aköl cïï ye tak lɔn yen aköl bï yen bɛ̈n. Ku yeen abï bɛ̈ny tɛ̈m awuɔ̈cdït ku mɛt tɛ̈ rëër kɔc rɛc thïn. ");
INSERT INTO dikNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ku aluaŋ ŋic kë wïc bänyde bï looi, ku rëër ke cïï rot guir bï kë wïc bɛ̈ny looi, ka bï tɛ̈m awuɔ̈cdït apɛi. ");
INSERT INTO dikNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ku aluaŋ kuc kë wïc bänyde ku looi awuɔ̈c bï yen that thïn, ka bï ya awuɔ̈c koor. Käjuëc aa wïc tënë raan cï gäm käjuëc, ku raan cï gäm käjuëc apɛi awïc käjuëc apɛi tënë ye. ");
INSERT INTO dikNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ɣɛn acï bɛ̈n ba piny bɛ̈n cuɔ̈ny. Ku anhiaar diɛ̈t cï dëp thɛɛr. ");
INSERT INTO dikNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ɣɛn atiit kërac apɛi, ɣɛn abï gum ku rem ɣa apɛi ɣet aköl bï kënë thök. ");
INSERT INTO dikNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Yakë tak lɔn cï ɣɛn bɛ̈n ba dɔ̈ɔ̈r bɛ̈n looi pinynhom? Alɛ̈k we acie ye. Ee lɔn bï kɔc keyiic tek. ");
INSERT INTO dikNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Many la yic kɔc kadhiëc abï yeyic tek. Kɔc kadiäk aabä nhiaar ku man rou ɣa. Tɛ̈dë, kɔc karou aabä nhiaar ku man kɔc kadiäk ɣa. ");
INSERT INTO dikNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Mïth röör kek wärken aabï kenhïïm tuɔ̈ɔ̈m ë riɛnkiɛ̈. Ku yen ë lɔn nyïïr kek märken. Ku man athiëëk kek tïŋ wënde aabï röt maan aya.” ");
INSERT INTO dikNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ku ben Jethu lɛ̈k thän awën tɔ̈ thïn, “Na tiɛ̈ŋkë luät nhial, ka guɔkë lueel lɔn deŋ abï tuɛny, ku tueny ayic. ");
INSERT INTO dikNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ku na dɔm bï la dïl, ku ruel akɔ̈l apɛi, ka luɛlkë lɔn bï piny tuɔ̈c, ku tuc ayic. ");
INSERT INTO dikNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Yeŋa wiɛ̈ckë bäk ruëëny! Awëëŋkui? Wek aa kë bï rot looi ŋic tɛ̈ tïŋ wek käkkä nhial. Ku cäk kë loi rot ëmën ŋic ayic? ");
INSERT INTO dikNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Yeŋö cïï wek yic bäk looi ye ŋic? ");
INSERT INTO dikNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Cïmën na ɣɛ̈th raan yï luk yic, ke yï lɔc wɛ̈t waar yic, ku dɔ̈ɔ̈rkë ke këc yï guɔ ɣäth luk yic. Na cïï lɔc looi këlä, ka ɣɛ̈th yï luk yic tënë bäny, ku bɛ̈ny abï la thɔ̈n apuruuk, ku mac yï. ");
INSERT INTO dikNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Alɛ̈k yï, yïn acïï bï kaŋ lony, ɣet tɛ̈ bï yïn këthiin kɔ̈ny tënë yï kaŋ cool.” ");
INSERT INTO dikNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Nawën ke kɔc bɔ̈ tënë Jethu, ku lëkkë ye lɔn cï bänydït Pilato kɔc Galilia cɔl anäk, kɔc ke cï käk juërkë Nhialic la nɔ̈k luaŋ Nhialic Jeruthalem. ");
INSERT INTO dikNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Go Jethu bɛ̈ɛ̈r. “Yakë tak lɔn kɔc Galilia cï nɔ̈k ëmën aa kärɛc apɛi wɛ̈r kek kɔc Galilia kɔ̈k looi? ");
INSERT INTO dikNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Acie yic! Ku cäk ŋic lɔn wek aabï thou aya cïmënden, tɛ̈ cïï wek kärɛc yakë looi päl, ku wɛ̈lkë wepuɔ̈th Nhialic? ");
INSERT INTO dikNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ku na kɔc wäär kathiäär ku bɛ̈t wïk ɣön bäär apɛi kenhïïm Thiloam bïk thou ëbën, ye kek kɔc kärɛc looi Jeruthalem kepɛ̈c? ");
INSERT INTO dikNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Aacie ke! Ku alëk we, na cäk luɔi kärɛc päl, ke wek aabï thou ëbën cïmënden.” ");
INSERT INTO dikNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Go Jethu ke lɛ̈k kääŋ kënë, “Monytui ëcï tim luɔk com duɔmde. Nawën thööŋ tɛ̈ cï yen luɔk, ke bɔ̈ bï bɛ̈n bet. Go ciɛ̈n mïth yök yenhom. ");
INSERT INTO dikNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Go puɔ̈u riääk apɛi, ku lëk raan lui dom yic bï yɛp wei, ku lëk ye, ‘Aca tiit run kadiäk ku acïn manh töŋ ca yök yenhom. Yeŋö pɛ̈l ye bï dom rooc ë path ke cie luɔk?’ ");
INSERT INTO dikNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Go raan ë luɔi bɛ̈ɛ̈r, ‘Bɛ̈ny, päl ë ruɔ̈ɔ̈n töŋ kënë ë path, aba guiir ku tääu dhiääp yecök. ");
INSERT INTO dikNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Na lok ruɔ̈ɔ̈ntui ka path, ku na cïï lok, ka jɔl cɔl ayep.’ ” ");
INSERT INTO dikNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Tɛ̈wën aköl cïï kɔc ye luui ke Jethu piɔ̈ɔ̈c tɛ̈n amat kɔc Itharel, ");
INSERT INTO dikNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ke tik ë tɔ̈ thïn ke la guɔ̈p jɔŋrac cï ye dhoŋ kɔ̈u, bï yekɔ̈u cïï ye jɔt ruɔ̈ɔ̈n thiäär ku bɛ̈t. ");
INSERT INTO dikNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Nawën tïŋ Jethu ke cɔɔl ku lëk ye, “Tik, yïn acï kony.” ");
INSERT INTO dikNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ku tɛ̈ɛ̈u yecin yekɔ̈u. Ku kaam thiin awën ke la kɔ̈u cök. Go Nhialic leec. ");
INSERT INTO dikNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ku raandït tɛ̈n amat ëcï puɔ̈u dak apɛi rin cï Jethu ye kony aköl cïï kɔc ye luui. Ku lëk kɔc awën tɔ̈ thïn, “Ɣok aa la nïn kadätem ye kɔc luui. Ke raan alëu bï bɛ̈n akäl tök kam ë nïnkä yiic bï bɛ̈n kony, ku acie aköl cïï kɔc ye luui.” ");
INSERT INTO dikNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Go Bɛ̈ny bɛ̈ɛ̈r ke tɔɔn guɔ̈p, “Aa wek kɔc la gup ruëëny! Le raan tök ë kamkun cie ɣäkke ye lony aköl cïï kɔc ye luui bï ke la wiëc wal ku pïu? ");
INSERT INTO dikNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ku tiŋ kënë, nyan many Abaram cï bɛ̈ny jak dhoŋ kɔ̈u, bï ya rëër ke duɔl ë runkä kathiäär ku bɛ̈t, cïï path bï kony aköl cïï kɔc ye luui bï la cök?” ");
INSERT INTO dikNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Tɛ̈wën lueel yen ye këlä, ke kɔc awën man ye yär gup, ku mit thän dïït awën tɔ̈ thïn puɔ̈th käk kɔc gɔ̈i cï Jethu looi. ");
INSERT INTO dikNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ku la Jethu tueŋ ke jam ku lueel, “Bääny Nhialic cït ŋö? Yeŋö ba thɔ̈ɔ̈ŋ ke ye? ");
INSERT INTO dikNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Aba thɔ̈ŋ manh tim koor nyin cï raan com duɔmde. Go dït abï ya tim dïttet ye diɛt ɣɔ̈ɔ̈tken yïk kɛ̈rke kɔ̈th.” ");
INSERT INTO dikNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ku ben lueel, “Yeŋö ba bɛn thɔ̈ŋ bääny Nhialic? ");
INSERT INTO dikNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Acït lon cï tik puɔr ayumdït tet yic, na lä ke piäär ëbën.” ");
INSERT INTO dikNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ku bɛ̈r Jethu ke kuany gɛɛth ku bɛ̈ɛ̈i yiic ke la Jeruthalem. ");
INSERT INTO dikNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Go raan tök thiëëc, “Bɛ̈ny! Le kɔc lik bï poth bïk la pan Nhialic?” Go Jethu bɛ̈ɛ̈r, ");
INSERT INTO dikNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Thamkë bäk bak dhël ye kɔc gum thïn yic, rin alɛ̈k we lɔn wïc kɔc juëc ye bïk la alɔŋthïn, ku acïk bï lëu. ");
INSERT INTO dikNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Tɛ̈ jɔt wun baai rot ku riit ɣöt thok, wek aabï kɔ̈ɔ̈c aɣeer ku jälkë ɣöt tɔɔŋ thok ku luɛlkë, ‘Bɛ̈ny, ŋany ɣöt thok tënë ɣo,’ ku abï bɛ̈ɛ̈r tënë we, ‘Akuɔ̈c tɛ̈ bïï wek thïn.’ ");
INSERT INTO dikNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ku abäk lɛ̈k ye, ‘Ɣok aacï mïth ku dëkku kek yï, ku yïn acï piööc ë gɛɛthkua yiic!’ ");
INSERT INTO dikNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ku abï dhuk nhom ku lueel, ‘Alɛ̈k we bäk piŋ, wek aacïï bɔ̈ ɣöt rin wek aacä ŋic. Jälkë, kɔc luui ë kärɛc!’ ");
INSERT INTO dikNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ku tɛ̈ cï yï cuɔp wei, ke yïn ariääk puɔ̈u ku dhiau aba yïthok a kac tɛ̈ tïŋ yïn Abaram, ku Ithäk ku Jakop ku kɔc käk Nhialic tïŋ, ke rɛ̈ɛ̈r bääny Nhialic yic pan Nhialic, ku gël yï wei thïn! ");
INSERT INTO dikNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ku kɔc aabï bɛ̈n pinynhom ëbën ku camkë yan bääny Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ku kɔc tɔ̈ ciëën ëmën aabï tɔ̈ tueŋ. Ku kɔc tɔ̈ tueŋ aabï dhuk ciëën.” ");
INSERT INTO dikNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Tɛ̈ɛ̈n, ke kɔc akut Parathï bɔ̈ tënë Jethu ku lëkkë ye, “Jäl ë tɛ̈n rin bɛ̈ny Antipäth Ɣërot awïc bï yï nɔ̈k.” ");
INSERT INTO dikNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Go Jethu lueel, “Lak ku lɛ̈kkë raan la guɔ̈p awandït lɔn ɣɛn abï la tueŋ akölë ayï nhiäk ɣa cop jakrɛc wei kɔc gup, ku luɔi käk jäŋ gɔ̈i ye ɣɛn kɔc kony. Ku na ye nïn diäk ke ɣɛn abï luɔidiɛ̈ thöl pinynhom. ");
INSERT INTO dikNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ku akölë ku nhiäk ku aköl dɛ̈ɛ̈të, ɣɛn ala tueŋ ɣa lui rin acïï path bï raan käk Nhialic tïŋ nɔ̈k tɛ̈dɛ̈t cie Jeruthalem. ");
INSERT INTO dikNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Kɔc Jeruthalem! Kɔc Jeruthalem! Kɔc ë kɔc käk Nhialic tïŋ nɔ̈k, ku biɔ̈ɔ̈kkë kɔc cï tuɔ̈c we aleel. Ye arakdë cï ɣɛn ye wïc ba we kuɔ̈ɔ̈t yiic, ku kuɔny we cïmën adhie ye ajïth miɛ̈thke kuɔ̈m piny yewuɔ̈k, ku wek aacï kuec. ");
INSERT INTO dikNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nhialic abï we nyäŋ pandun. Ku athɔ̈n we bäk ŋic, wek aacïï ɣa bï bɛn tïŋ ɣet aköl bï wek röt guiir, ku luɔrkë ɣa yai ke yakë lueel, ‘Lecku raan bɔ̈ rin Bänyda.’ ” ");
INSERT INTO dikNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Nawën ke Jethu la pan raan akut Parathï aköl cïï kɔc ye luui bï la mïth. Ku kɔc ke tɔ̈ thïn aake döt Jethu apɛi. ");
INSERT INTO dikNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Go raan cï but ɣɔ̈ɔ̈m ku kök ëbën bɛ̈n tënë ye. ");
INSERT INTO dikNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Go Jethu jam ku thiëëc kɔc piööc ë lööŋ ku kɔc akut Parathï, “Cï löŋ pëën bï raan tuany kony aköl cïï kɔc ye luui tɛ̈dë ke kony?” ");
INSERT INTO dikNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Gokë cïï bëër. Go Jethu mony awën cɔɔl ku kony ku cɔl ajiël. ");
INSERT INTO dikNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ku jɔl lɛ̈k ke, “Yeŋa kamkun ë tɛ̈n, na cï manhde, ayï wɛŋde lööny yiith aköl cïï kɔc ye luui, ke pɛ̈l yiith ku cïï bïï bei nyin yic?” ");
INSERT INTO dikNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ku wɛ̈t kënë acï ke nyɔ̈ŋ nhïïm kë bëër kek ye. ");
INSERT INTO dikNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Wën cï yen ye tïŋ aya ke jɔ̈ɔ̈l awën cï cɔɔl aaye ŋɛk tɛ̈den nyuuc yen thïn lɔc, ke luel kääŋ kënë, ");
INSERT INTO dikNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Tɛ̈ cï yï cɔɔl yai yic, duk la ku nyuc tɛ̈n kɔcdït, tɛ̈dë ke raan ben dït tënë yï acï cɔɔl aya. ");
INSERT INTO dikNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Na bïï, ke raan awën cɔl we wedhie abï yɔ̈ɔ̈k ba rot jɔt ba thööc päl ye. Ku yïn abï jäl dhuk thöc tɔ̈ ciëën yiic ke yï cï guɔ̈p yär. ");
INSERT INTO dikNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Tɛ̈ cï yï cɔɔl, ke yï la ku nyuc thöc tɔ̈ ciëën yiic rin na la raan la baai bɛ̈n, ka bɔ̈ tënë yï ku lueel, ‘Jɔt rot, bäär tueŋ tɛ̈n mäthdiɛ̈.’ Kënë abï cɔl athiek yic jɔ̈ɔ̈l nhïïm ëbën. ");
INSERT INTO dikNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Këya, kuat raan dït puɔ̈u rot ɣäth tueŋ ë rot abï Nhialic dhuɔ̈k ciëën, ku raan lir puɔ̈u ë rot dhuɔ̈k ciëën abï Nhialic ɣäth tueŋ.” ");
INSERT INTO dikNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ku lueel Jethu tënë mony awën cï ye gɔɔŋ, “Na loi miëth bï yïn kɔc gɔɔŋ, ke duk ke cɔl mäthku ku paan moor, ku kɔc ruääi kek yï ku kɔc ajiɛɛk thiëëk bääikun, rin aabï bɛn cɔɔl. Ku na looi rot këya, ke këwäär ca luɔ̈i ke yen acolkë tënë yï. ");
INSERT INTO dikNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Na loi miëth cɔɔl yïn kɔc, ke cɔl ke kɔc ŋɔ̈ŋ, ku kɔc cï duany, ku kɔc cï ŋɔl ku cöör, ");
INSERT INTO dikNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","rin na la kɔc röt jɔt thou yic aköldä, ke yïn abï Nhialic cuɔ̈ɔ̈t rin wäär cï yïn ke cɔɔl kɔc cïï ye lëu bïk miëëthku cool.” ");
INSERT INTO dikNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Go mony dɛ̈t mïth kek kɔc lueel tënë Jethu wën piŋ yen kënë, “Kɔc mit gup aa kɔc bï cɔɔl yai yic, bääny Nhialic yic.” ");
INSERT INTO dikNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Go Jethu lɛ̈k ye, “Monytui ëcï yandït apɛi looi ku cɔɔl kɔc juëc. ");
INSERT INTO dikNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nawën cï mïïth yai guiir, ke toc aluɔnyde bï kɔc wïc ke yai yic la cɔɔl, ‘Bäk, këriëëc ëbën acï thök ë guiër.’ ");
INSERT INTO dikNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Gokë wël juëc lueel kedhie bï kek kenhïïm kɔl. Ku lueel raan wën cï alony kaŋ yök ëlä, ‘Ɣɛn acï piny ɣɔɔc, ku ɣɛn adhil la ba la tïŋ. Lɔɔr ku lɛ̈k bɛ̈ny lɔn acïn kë maan yen cïï ɣɛn la yai yic.’ ");
INSERT INTO dikNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ku lueel raandɛ̈t, ‘Ɣɛn acï miöör kathiäär ye kɔc pur ɣɔɔc, ɣɛn ala ba ke la them, lɔɔr lɛ̈k bɛ̈ny lɔn acïn kë maan tënë ye.’ ");
INSERT INTO dikNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ku lueel raan ye kɔc diäk, ‘Ɣɛn acï piac dɔ̈m nya, acä lëu ba la yai yic.’ ");
INSERT INTO dikNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Go alony dhuk baai ku le wëlkä lɛ̈k bänyde. Go bänyde puɔ̈u riääk ku lëk aluɔnyde, ‘Lɔɔr dhɔ̈l yiic ku kam bɛ̈ɛ̈i geeu, ku cɔl kɔc lïm dhɔ̈l yiic ku kɔc cï duany, ku kɔc cï ŋɔl ku cöör bïk bɛ̈n.’ ");
INSERT INTO dikNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Go alony lueel, ‘Bɛ̈ny, kë ca lɛ̈k ɣa aca looi ku piny aŋot lääu.’ ");
INSERT INTO dikNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Go bɛ̈ny bɛn lɛ̈k aluɔnyde, ‘Lɔɔr kuany baai yic ku dhɔ̈l yiic geeu, ku lɛ̈k kɔc ëbën bïk dhiɛl bɛ̈n bï paandiɛ̈ thiäŋ. ");
INSERT INTO dikNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Alɛ̈k yï, kɔc wäär ca kaŋ cɔɔl acïn miëth yai bïk bɛn yök paandiɛ̈!’ ” ");
INSERT INTO dikNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Kɔc juëc aake cath kek Jethu. Nawën ke wël yenhom kɔc ku lueel, ");
INSERT INTO dikNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Na ye raan bɔ̈ tënë ɣa, ku cïï wun ku man ku tiɛŋde ku miɛ̈thke, ku wämäthakën ku nyiɛ̈rakën, ku wɛ̈ike man, ka cie raan buɔth ɣa. ");
INSERT INTO dikNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ku raan cie gum ku buɔɔth ɣa, acïï lëu bï ya raan buɔth ɣa. ");
INSERT INTO dikNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Na wïc raan bï ɣöndït bäär apɛi buth, yeŋö bï kaŋ looi? Nadë ke cïï wëëu muk bï kaŋ kuɛ̈ɛ̈n nyïn bï ŋic lɔn le yen wëëu juëc bï yen ɣöt buth bï thöl? ");
INSERT INTO dikNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Na jɔɔk cök ku le ciɛ̈n wëëu juëc bï yen ye thöl, ka bï kɔc ɣöt tïŋ ke këc thök aa bui, ku yekë lueel, ");
INSERT INTO dikNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Mony kënë acï ɣöt jɔɔk bï buth ku akëc thääp.’ ");
INSERT INTO dikNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Na jɔt bɛ̈nyŋaknhom tɔŋ ke la apuruk tim thiäär bï la thɔ̈r kek bɛ̈nyŋaknhom dɛ̈t la apuruk tim thiär-rou, ke cïï bï kaŋ tak lɔn bï yen tɔŋ lëu kek ë bɛ̈ny kënë? ");
INSERT INTO dikNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Na yök ke cïï tɔŋ bï lëu, ka toc kɔc ke bɛ̈nyŋaknhom tui ŋot mec kek apuruɔ̈ɔ̈kke bïk dɔ̈ɔ̈r looi.” ");
INSERT INTO dikNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Këlä aya, acïn raan kamkun lëu ye bï ya raan buɔth ɣa agut tɛ̈ bï yen käkke kaŋ puɔ̈l. ");
INSERT INTO dikNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Awai, apath. Ku na thöök kɔ̈u alɛ̈i ke ben dhuɔ̈k thïn këdë? ");
INSERT INTO dikNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Awan cït kënë acie bɛn piath. Aye puɔ̈k wei. Piɛŋkë tɛ̈ le wek yïth.” ");
INSERT INTO dikNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","2","Kɔc ajuër kut ku kɔc kärɛc looi aake cï bɛ̈n tënë Jethu bïk piɔ̈ɔ̈cde bɛ̈n piŋ. Ku kënë, ee këc kɔc akut Parathï ku kɔc piööc lööŋ nhiaar, rin ye Jethu kɔc rɛc mɛɛn jäŋ lor, ku mïth ke ke aya. ");
INSERT INTO dikNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Goke lɛ̈k kääŋ kënë. ");
INSERT INTO dikNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Na la raan tök kamkun amääl buɔɔt, ku mär amäl tök, ke cïï thiärdhoŋuan ku dhoŋuan nyiëëŋ piny roor, ku le amäl töŋ cï määr kaŋ wïc ɣet tɛ̈ bï yen ye yök? ");
INSERT INTO dikNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ku na yök ka mit puɔ̈u apɛi ku jɔt yekët. ");
INSERT INTO dikNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ku na le ɣet baai ka cɔl mäthke ku kɔcken akeu nhom ku lëk ke, ‘Ɣɛn acï puɔ̈u miɛt rin cï ɣɛn amäldiɛ̈n wäär cï määr yök. Loiku yai.’ ");
INSERT INTO dikNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Këlä aya, miɛt puɔ̈u dït abï tɔ̈ pan Nhialic, rin raan töŋ kërac looi cï yepuɔ̈u dhuɔ̈k ciëën rin adumuɔ̈ɔ̈mke. Ku miɛt puɔ̈u kɔc tɔ̈ pan Nhialic, rin ë raan töŋ, acïï bï thöŋ kek miɛt puɔ̈u rin kɔc path kathiärdhoŋuan ku dhoŋuan cïn awuɔ̈c cïk looi, bï kek kepuɔ̈th dhuɔ̈k ciëën.” ");
INSERT INTO dikNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Tɛ̈dë, tik ala wëëth thiäär mïläŋ ɣer, ku mär wɛ̈nh tök. Yeŋö bï looi? Abï mac dɛ̈ɛ̈p ku wïc apɛi arɛ̈k bï ɣöt a weec yic agut tɛ̈ bï yen ye yök. ");
INSERT INTO dikNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Tɛ̈ cï yen ye yök ka cɔl mäthke ku kɔc akeu ëbën ku lëk ke, ‘Ɣɛn amit puɔ̈u apɛi, wëëukiɛ̈n wäär cï määr aaca yök. Loiku yai.’ ");
INSERT INTO dikNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Këlä aya, atuuc Nhialic aa puɔ̈th miɛt rin raan töŋ kärɛc looi cï yepuɔ̈u waar ku dhuk Nhialic.” ");
INSERT INTO dikNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ku la Jethu tueŋ ku lueel, “Monytui ë tɔ̈ thïn ku ë la wät karou. ");
INSERT INTO dikNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Go wën koor lɛ̈k wun, ‘Gäm ɣa käk ba tɛ̈k ɣa aköldä?’ Go wun käŋ tek tënë ke. ");
INSERT INTO dikNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Nawën nïn lik cök ke wën koor ɣɔɔc käkke ëbën, ku jiël bï la wun dɛ̈t, wun cï yen wɛ̈ɛ̈uke bɛ̈n la thöl thïn dëŋ ë määu ku wïcwïc adëjök. ");
INSERT INTO dikNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Wën cï yen wëëu thöl ke cɔŋdït apɛi loi rot ye pan awën, ku jɔl rëër ke nɛ̈k cɔk apɛi. ");
INSERT INTO dikNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nawën le käkke dhal ke luɛɛk rot pan raan tök ë kɔc pan awën. Go raan la baai cɔl aye dïr baai biɔ̈ɔ̈k. Ku gɛ̈m ke kë camkë. ");
INSERT INTO dikNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ku ë ye wïc diɛ̈t cɔk yeyäc thiɔ̈ɔ̈ŋ kë ye dïr cam, ku acïn raan cïï ye gäm ye. ");
INSERT INTO dikNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Nawën jɔl kërɛɛc cï looi tak yic yepuɔ̈u ke lueel, ‘Ye kɔc luɔi kadë tɔ̈ tënë wä ë kuɛth abï miëth döŋ piny, ku ɣɛn akïn duër thou ë tɛ̈n rin cɔk! ");
INSERT INTO dikNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ɣɛn abï dhuk tënë wä ku lɛ̈k ye, wä ɣɛn acä awuɔ̈c looi tënë Nhialic ku tënë yï. ");
INSERT INTO dikNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ɣɛn acïï ben a cɔ̈l yï, loi ɣa ke ɣa cït alony ye riɔp.’ ");
INSERT INTO dikNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ku jɔl jäl pan awën ku dhuk tënë wun. “Tɛ̈wën ŋoot yen tɛ̈mec ke baai, ke tïŋ wun ke bɔ̈. Go puɔ̈u la yum ku riŋ tënë ye ku pɛɛt yic ku cim gëm. ");
INSERT INTO dikNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Go wënde lueel, ‘Wä ɣɛn acï kërac looi tënë Nhialic ku tënë yï. Ɣɛn acïï ben piath nadë ke ɣa cöl ë yï.’ ");
INSERT INTO dikNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Go wun aluɔɔnyke cɔɔl ku lueel, ‘Riɛ̈ŋkë! Bɛ̈ɛ̈ikë alanh path ku tääukë yekɔ̈u. Ku cuɔ̈thkë cin joth mïläŋ tɔ̈c ku tääukë war yecök. ");
INSERT INTO dikNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ku bɛ̈ɛ̈ikë muɔɔr thiin cuai apɛi ku näkkë bï ɣok yai looi, ");
INSERT INTO dikNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","rin manhdiɛ̈n kënë ë cït mänh cï thou ku acï bɛn pïr. Yeen ëcï määr ku acï yök.’ Ku jɔlkë yai cam. ");
INSERT INTO dikNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Tɛ̈wën looi käkkä röt, wëndït ëcï la luui dom yic. Nawën dhuk ku jɔl bï baai dööt, ke piŋ lɔ̈ɔ̈r yic ku diër. ");
INSERT INTO dikNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Go aluɔny tök cɔɔl ku thiëëc kë diër kɔc baai. ");
INSERT INTO dikNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Go alony awën lɛ̈k ye, ‘Wämuuth acï bɛ̈n, ku wuur acï muɔɔr wäär cuk muk apɛi bï cuai nɔ̈k bï yai looi rin cï yen dhuk ke puɔl guɔ̈p.’ ");
INSERT INTO dikNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Go wëndït puɔ̈u riääk apɛi ku kueec bï cïï la baai. Go wun bɛ̈n tënë ye ku lɛ̈ŋ bï la baai. ");
INSERT INTO dikNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Go lɛ̈k wun, ‘Ɣɛn acï luui apɛi ë runkä ëbën tënë yï, ku acïn töŋ ca lɛ̈k ɣa ba looi cï ɣɛn kaŋ kuec ba cïï loi. Ku ë runkä ëbën acïn mën manh ë thɔ̈k ca kaŋ yiëk ɣa bï ɣɛn luui yai ɣok mäthkiɛ̈. ");
INSERT INTO dikNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ku wën dhuk wëndu ke cï wɛ̈ɛ̈uku la muɔ̈r adëjök kɔ̈th, ke yï loi yai ku näk muɔɔr töŋ yen cuai apɛi ɣäkkua yiic.’ ");
INSERT INTO dikNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Go wun bɛ̈ɛ̈r, ‘Manhdiɛ̈, yïn arɛ̈ɛ̈r kek ɣa akölaköl, ku käk muɔ̈k ëbën aa käkku. ");
INSERT INTO dikNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ku ë yic buk yai looi rin wämuuth ë cït manh cï thou, ku ëmën acï pïïr, ee cï määr ku ëmën acï yök.’ ” ");
INSERT INTO dikNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ku ben Jethu lueel tënë kɔcken ye buɔɔth ëlä, “Wäthɛɛr raan ajak ë tɔ̈ thïn, ku yeen ë la raan käkke guiir baai, ku raan kënë ëcï luɔm tënë ye rin cï yen wɛ̈ɛ̈uke muɔ̈r. ");
INSERT INTO dikNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Go cɔɔl ku lueel, ‘Yeŋö kë ya piŋ keye lueel ë riɛnku? Nyoth wëëu ca dɔm ku wëëu cï määr thook ëbën, rin yïn acïï bï bɛn ŋot yï lui tënë ɣa.’ ");
INSERT INTO dikNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Go mony wën lueel yepuɔ̈u ëlä, ‘Ba ŋö looi tɛ̈ cop bɛ̈ny ɣa luɔidiɛ̈ yic? Ɣɛn akuc puɔ̈r ë dom ku ɣɛn abï guɔ̈p yär tɛ̈ ye ɣɛn lim. ");
INSERT INTO dikNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ëmën, kë ba looi aca jäl ŋic, kë bï ɣɛn cɔl ala kɔc juëc määth ke ɣa, bïk ɣa aa lor bääiken tɛ̈ cop ɣa wei luɔidiɛ̈ yic.’ ");
INSERT INTO dikNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Go kɔc la gup käny bänyde cɔɔl ku lueel tënë raan cï kaŋ bɛ̈n, ‘Käk bɛ̈ny kɔ̈ny tënë yï yekë dë?’ ");
INSERT INTO dikNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Go lueel, ‘Ɣɛn akɔ̈ny tönydït miök bian tök.’ Go raan käŋ guiir baai lɛ̈k ye, ‘Kënë acï ya akuɛ̈ndu, nyuc ku gät thiärdhiëc.’ ");
INSERT INTO dikNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ku thiëëc raan dɛ̈t, ‘Na yïïn, kɛ̈ny tɔ̈ yïguɔ̈p ye dë?’ Go lueel, ‘Ee gäny rap tiɛm tök.’ Go lɛ̈k raan wën, ‘Gät buɔt kabɛ̈t.’ ");
INSERT INTO dikNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Go wun baai raanden la guɔ̈p awan leec wën cï yen rot kony. Rin tɛ̈ ye riëëc akölë käkken luɔɔi thïn kamken aŋuɛ̈ɛ̈n tënë mïth bääny Nhialic.” ");
INSERT INTO dikNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Go Jethu la tueŋ ku jiɛɛm, “Këya alɛ̈k we, luɔikë jiɛɛk pinynhom bï wek ke la mɛ̈th, rin na la jaakdun thök ke wek aabï lor pïr akölriëëc ëbën yic. ");
INSERT INTO dikNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Raan ŋic kälik muk apath ë käjuëc ŋiɛc muk aya, ku raan kuc kälik muk, acie käjuëc ë ŋiɛc muk. ");
INSERT INTO dikNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Na yïn acie käk ciɛɛŋ pinynhom ë tɛ̈n ŋiɛc muk, ke yï bï deet puɔ̈u këdë bï yï gäm jiɛɛk tɔ̈ pan Nhialic? ");
INSERT INTO dikNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Na yïn acie ŋɔ̈ɔ̈th puɔ̈u lɔn bï yïn kën raandä ŋiɛc muk, ke yeŋa bï gäm kë cɔk a këdu? ");
INSERT INTO dikNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Acïn alony lëu ye bï luui tënë bäny karou, ka man raan tueŋ ku nhiɛɛr raan ye kɔc rou. Tɛ̈dë ka thek raan tueŋ ku dhɛ̈l raan dɛ̈t guɔ̈p. Acïï raan lëu bï Nhialic ku jiɛɛk nhiar kedhie.” ");
INSERT INTO dikNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Go kɔc akut Parathï, kɔc nhiar wëëu, käkkä piŋ ëbën ku dɔlkë Jethu guɔ̈p. ");
INSERT INTO dikNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Go Jethu lɛ̈k ke, “Wek aa röt nyuɔɔth kɔc nhïïm ciɛ̈t wek kɔc path ku Nhialic aŋic kë tɔ̈ wepuɔ̈th. Rin käk ye kɔc juëc yiëk kepuɔ̈th apɛi ciɛ̈t kek ril, aaye Nhialic tïŋ ke kor. ");
INSERT INTO dikNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Wäthɛɛr agut tɛ̈wäär tul Joon, kɔc aake ye löŋ Mothith ku wël cï kɔc käk Nhialic tïŋ gɔ̈t, theek. Ku ëmën, Wɛ̈t Puɔth Yam rin bääny Nhialic alëk kɔc, ku awïc kuat raan ëbën bï rot riɛɛny thïn. ");
INSERT INTO dikNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ee këya, apuɔl yic bï käk tɔ̈ nhial ku pinynhom riääk, tɛ̈n tɛ̈ bï wɛ̈t thiin koor tɔ̈ Löŋ yic cuat wei. ");
INSERT INTO dikNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Raan liɔ̈i tiɛŋde ku thiɛɛk tiŋ dɛ̈t, ka cä akɔr looi. Ku mony thiak tiŋ cï muɔnyde liɔ̈ɔ̈i, ka cï akɔr looi aya.” ");
INSERT INTO dikNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Go Jethu kääŋ bɛ̈n thɔ̈ɔ̈th ku lueel, “Raan tök ë tɔ̈ thïn ku ëcï jak apɛi, ku ë ceŋ alɛ̈th dhëŋ ku ë ye yai looi paande akölaköl. ");
INSERT INTO dikNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ku raan laaŋ cɔl Ladhäro la guɔ̈p tɛ̈töök juëc apɛi ë tɔ̈ thïn aya. Ku ë ye nyuc ɣön raan ajak thok, ");
INSERT INTO dikNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","bï lim awuthueei ë lööny piny. Ku jɔ̈k aake ye bɛ̈n aya ku nyankë tɛ̈töök yiic. ");
INSERT INTO dikNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Nawën ke laaŋ kënë thou, go atuuc Nhialic wɛ̈ike tääu Abaram yɔu nhial pan kɔc path cï thou. Nawën ke mony ajak lök thou aya ku thiäk, ");
INSERT INTO dikNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ku tɛ̈ɛ̈u wɛ̈ike pan mac, ku rem thïn apɛi. Nawën ŋɛ̈ɛ̈r yenyin nhial ke tïŋ Abaram tɛ̈mec, ku Ladhäro ke tɔ̈ yeyɔu. ");
INSERT INTO dikNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Go dhiau ku lueel, ‘Wä Abaram liec ɣa, ku toc Ladhäro bï ciɛɛn tök luɔ̈t thok pïu yiic, ku gɔɔt ɣaliep bï liɛmdiɛ̈ liɛr, rin ɣɛn arem apɛi ë tɛ̈n!’ ");
INSERT INTO dikNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Go Abaram bɛ̈ɛ̈r, ‘Manhdiɛ̈, tak lɔn cï yïn käpath yök wäär pïïr yïn ku yök Ladhäro kärɛc. Ku yeen awac puɔ̈u ëmën ku yïn arem apɛi. ");
INSERT INTO dikNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ku dɛ̈t aya, tɛ̈thuth mec yic apɛi atɔ̈ kamkua bï ciɛ̈n raandan la lɔŋtui, ku cïn raandun bɔ̈ tënë ɣa ë tɛ̈n.’ ");
INSERT INTO dikNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Go mony ajak wën lueel, ‘Wä Abaram yïn aläŋ ba Ladhäro tuɔɔc panda, ");
INSERT INTO dikNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","tënë mïth wä kadhiëc bï ke la wɛ̈ɛ̈t bïk cïï bɔ̈ ë tɛ̈n bï ke reem aya.’ ");
INSERT INTO dikNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Go Abaram lɛ̈k ye, ‘Mothith ku kɔc käk Nhialic tïŋ aa tɔ̈ thïn, cɔl ke aa piŋ wɛ̈lken.’ ");
INSERT INTO dikNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Go mony ajak bɛn lueel, ‘Kënë acïï ye lëu, Wä Abaram! Ku na jɔt raan rot kɔc cï thou yiic ku le tënë ke, ka päl kärɛc yekë ke looi.’ ");
INSERT INTO dikNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Go Abaram lueel, ‘Na cïk wël Mothith ku wël kɔc käk Nhialic tïŋ piŋ, ka cïï wɛ̈t raan cï thou ku ben pïr piŋ aya.’ ” ");
INSERT INTO dikNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Naɣɔn akäl tök ke lueel Jethu tënë kɔcken ye buɔɔth, “Käk kɔc cɔl aloi adumuɔ̈ɔ̈m aa röt dhiɛl looi akölaköl. Ku raan käkkä cɔl aloi röt abï kërac apɛi yök. ");
INSERT INTO dikNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ee ŋuɛ̈ɛ̈n tënë ye diɛ̈t cï ruɔ̈k yeth aleldït tet, ku pïk wïïr bï mou, bï kɔc thiikä cïï cɔl aloi adumuɔ̈ɔ̈m. ");
INSERT INTO dikNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Tiɛtkë röt! “Na loi mɛnhkui adumuɔ̈ɔ̈m, ke nyieny, ku na dhuk yepuɔ̈u ciëën kërɛɛc cï looi, ke yï pɛ̈l wɛ̈t piny tënë ye. ");
INSERT INTO dikNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ku na looi kërac tënë yï arak dhorou akäl tök, ku bïï tënë yï arak dhorou aya, ku thiëëc yï ba wɛ̈t päl piny, ke yï pɛ̈l wɛ̈t piny tënë ye.” ");
INSERT INTO dikNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Naɣɔn aköl dɛ̈t ke lueel atuuc tënë Bɛ̈ny Jethu, “Ɣok aa wïc gamdït, lɛ̈k ɣo tɛ̈ bï ɣok ye yɔ̈k thïn.” ");
INSERT INTO dikNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Go Bɛ̈ny bɛ̈ɛ̈r, “Na gamdun cɔk kuur bï ciɛ̈t manh ŋaap, ka lɛ̈ukë bäk tim dïït tui yɔ̈ɔ̈k ëlä, ‘Nyuɛ̈n rot bei piiny agut mei, ku lɔɔr pith rot wïïr!’ Ke wɛ̈tdun aloi rot. ");
INSERT INTO dikNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Na thööŋku lɔn raan tök kamkun ala alony cï la pur, tɛ̈dë ke cï la biöök amɛ̈l. Na le dhuk dom yic, ye lɛ̈k ye, ‘Lɔc bɛ̈n ba bɛ̈n mïth?’ ");
INSERT INTO dikNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Acïï bï lɛ̈k ye këya! Tɛ̈dë aba lueel tënë ye, ‘Guir miëth tënë ɣa, ku tït ba kaŋ mïth ku dɛ̈k, na lä ciëën ke yïn abï jäl mïth ku dɛ̈kë.’ ");
INSERT INTO dikNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ku aloony aa cie leec tɛ̈ looi kek luɔiden. ");
INSERT INTO dikNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Athöŋ kek we aya, na luɔikë kë ca lɛ̈k we bäk looi, ka luɛlkë, ‘Ɣok aa loony ë path, ee luɔida yen acuk looi ku acïn dɛ̈t.’ ” ");
INSERT INTO dikNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Nawën la Jethu Jeruthalem, ke tëk kam Thamaria ku Galilia. ");
INSERT INTO dikNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nawën ɣeet gen thiin tɔ̈ dhël yic ke räm kek atuet thiäär. Gokë kɔ̈ɔ̈c tɛ̈mec, ");
INSERT INTO dikNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ku luelkë, “Jethu Bɛ̈ny, liec ɣo.” ");
INSERT INTO dikNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Nawën tïŋ ke ke lueel, “Lak ku nyuɔ̈thkë röt kɔc käk Nhialic.” Tɛ̈wën ŋoot kek dhël yic, ke tuet jiël kegup. ");
INSERT INTO dikNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Go raan tök dhuk tënë Jethu wën cï yen ye tïŋ ke tuet cï jäl yeguɔ̈p, ku leec Nhialic apɛi röldït, ");
INSERT INTO dikNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ku cuɛt rot piny Jethu nhom ku leec. Ku mony kënë ë raan Thamaria. ");
INSERT INTO dikNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Kënë acï Jethu cɔl athiëc ku lueel, “Cie raan thiäär yen cï kony bï tuet jäl kegup? Kɔc kɔ̈k kadhoŋuan aako? ");
INSERT INTO dikNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Yeŋö yen raan wun dɛ̈t yen dhuk bï Nhialic bɛ̈n leec?” ");
INSERT INTO dikNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ku lëk ye, “Jɔt rot ku jäl. Gamdu acï pïïr.” ");
INSERT INTO dikNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Naɣɔn akäl tök ke kɔc akut Parathï thiëc Jethu, “Bï bääny Nhialic yecök jɔɔk nɛn?” Go Jethu bɛ̈ɛ̈r ku lueel, “Bääny Nhialic acie kënë na bïï ke tïŋ kɔc nyïn? ");
INSERT INTO dikNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ku acïn raan lëu ye bï lueel, ‘Daai tɛ̈n, yen akïn, tɛ̈dë ke lueel, yen akan.’ Rin bääny Nhialic atɔ̈ wepuɔ̈th.” ");
INSERT INTO dikNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ku lueel Jethu tënë kɔcken ye buɔɔth, “Tɛ̈ bï wek ɣa, ɣɛn Manh Raan nhiaar diɛ̈t ɣa cɔk rëër ke we akäl tök abɔ̈. Ku ɣɛn acïï bï rëër tɛ̈n. ");
INSERT INTO dikNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Abï kɔc kɔ̈k lɛ̈k we lɔn cï ɣɛn dhuk ɣɛn atɔ̈ tɛ̈n, ke duɔ̈kkë gam, ku duɔ̈kkë ɣa cɔk wïc. ");
INSERT INTO dikNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Rin tɛ̈ dhuk Manh Raan, ka guɔ kë ŋic. Abäk tïŋ cïmën bir deŋ dhie yen nhial reet yic, ku tïŋ lɔŋ ku lɔŋë. ");
INSERT INTO dikNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ku ɣɛn abï kaŋ gum apɛi, ku riëëc akölë acïï wɛ̈tdiɛ̈ bï gam. ");
INSERT INTO dikNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Tɛ̈ le Manh Raan bɛ̈n, ke kë bï rot looi abï ciɛ̈t këwäär loi rot wäär pïïr Noa. ");
INSERT INTO dikNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ee nïnkä kɔc aake rɛ̈ɛ̈r ke mit puɔ̈th, keye mïth ku dëkkë ku loikë ruɛ̈i ɣet aköl le Noa riäi yic, ku bɔ̈ aboor ku moukë ëbën. ");
INSERT INTO dikNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ku bɛ̈ndiɛ̈ abï thöŋ aya kek këwäär loi rot wäär pïïr mony cɔl Lot. Ee nïnkä kɔc aake ye mïth ku dëkkë, ku ɣɔckë käŋ ku ɣɔɔckë ke wei, ku purkë ku loikë ɣööt. ");
INSERT INTO dikNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ku aköl wën jiël Lot Thodom, ke Nhialic cɔl deŋ atueny ë mac ku nɛ̈k kɔc ëbën, ");
INSERT INTO dikNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","yen abï ciɛ̈t aköl bï Manh Raan dhuk. ");
INSERT INTO dikNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Tɛ̈ le akölë bɛ̈n, ke raan rɛ̈ɛ̈r aɣeer acïï ben la ɣöt bï la guik kë muk. Ku raan tɔ̈ dom yic acï dhuk baai aya. ");
INSERT INTO dikNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Takkë këwäär cï rot looi tënë tiŋ Lot. ");
INSERT INTO dikNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Raan wïc ye bï wɛ̈ike kony aabï muɔ̈r, ku na ye raan mär wɛ̈ike ë riɛnkiɛ̈ ka bï wɛ̈ike muk akölriëëc ëbën. ");
INSERT INTO dikNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Wakɔ̈u ë nïnkä kɔc karou aabï tɔ̈ ɣööt ke nin. Raan tök kamken abï lɔc ku nyɛɛi ku dɔ̈ŋ raan tök. ");
INSERT INTO dikNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Këlä aya, diäär karou aabï luui ë tök luɔiden baai, tiɛŋ tök abï ɣäth nhial ku nyiëëŋ tiɛŋ tök piny. ");
INSERT INTO dikNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ku abï rot looi këlä aya tënë kɔc lui dom yic. Raan dɛ̈t abï ɣäth nhial ku nyiëëŋ raan dɛ̈t piny.” ");
INSERT INTO dikNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Go kɔcken ye buɔɔth thiëëc, “Bɛ̈ny, bï ke ɣäth tɛ̈nɛn?” Go Jethu bɛ̈ɛ̈r, “Tɛ̈ rëër guɔ̈p kë cï thou thïn, aye cor yenhom mat thïn.” ");
INSERT INTO dikNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Naɣɔn aköl dɛ̈t ke Jethu lëk kɔcken ye buɔɔth kääŋ bï ke piɔ̈ɔ̈c bïk dhiɛl aa röök akölaköl ku cïk dhɔ̈r. ");
INSERT INTO dikNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ku lueel, “Wäthɛɛr bɛ̈ny luɔ̈k ë tɔ̈ thïn gɛn tök. Ku ëcie riɔ̈ɔ̈c Nhialic ku ë dhäl kɔc gup ëbën. ");
INSERT INTO dikNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ku tiŋ lëër ë tɔ̈ ë gen kënë aya. Ku ë ye lac bɛ̈n tënë bɛ̈ny, ku lɛ̈ŋ bï luɔ̈k yic tënë mony luk kek. ");
INSERT INTO dikNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Go bɛ̈ny wɛ̈tde cïï kuëëc nhom. Nawën le tak ke lueel, ‘Na cɔk alɔn cïï ɣɛn ye riɔ̈ɔ̈c ë Nhialic, ku cä kɔc thek, ke rin ë tiŋ kënë ɣa rääm nhom ë bak, aba tïŋ ba dhiɛl luɔ̈k yic, na cä loi këlä, ka bï ya cool ë bɛ̈n ku cut ɣaguɔ̈p.’ ” ");
INSERT INTO dikNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ku jɔl Jethu lɛ̈k ke, “Piɛŋkë tɛ̈ ye bɛ̈ny kuc luk jiɛɛm thïn. ");
INSERT INTO dikNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Cïï Nhialic lëu bï luk ŋiɛc looi tënë kɔcken cï lɔc, kɔc ye rɔ̈ɔ̈k aköl ku wɛ̈ɛ̈r? Bï ke cɔl ke mec tënë ye? ");
INSERT INTO dikNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Alɛ̈k we, abï luk ŋiɛc looi tënë ke. Ku na la dhuk, ɣɛn Manh Raan, ye kɔc kadë ba yök ke la gam pinynhom?” ");
INSERT INTO dikNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ku lueel Jethu kääŋ kënë aya tënë kɔc röt yök ciɛ̈t kek path kepɛ̈c, ku dhälkë raan ëbën guɔ̈p. ");
INSERT INTO dikNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Kɔc karou aake cï la luaŋ Nhialic bïk la röök, raan akut Parathï nhiam apɛi ku raan ë kut ajuër kɔc tuɔ̈ɔ̈r nyïn. ");
INSERT INTO dikNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Go mony nhiam akut Parathï bɛ̈n ku kɛ̈ɛ̈c ku röök ë rot ëlä, ‘Yïn alɛɛc Nhialic, ɣɛn acïï thöŋ kek kɔc kɔ̈k, kɔc käk kɔc kɔ̈k tuɔ̈ɔ̈r nyïn, kɔc ë luui kärɛc ë diäär kɔc kɔ̈k kɔɔr. Yïn alɛɛc rin ɣɛn acïï thöŋ kek raan ajuër kut kënë. ");
INSERT INTO dikNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ɣɛn ë thek ba cïï mïth, arak rou nïn kadhorou yiic, ku yïn aya juɛ̈r tök thiäär yic käkkiɛ̈n ya yök luɔi yic ëbën.’ ");
INSERT INTO dikNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ku raan ajuër kut acï bɛ̈n ku kɛ̈ɛ̈c tɛ̈mec ku cïï yenyin ŋɛ̈ɛ̈r nhial wën röök yen, ku gut yepuɔ̈u amääth bï nyuɔɔth lɔn ë yen kärɛc looi ku lueel, ‘Nhialic liec ɣa, ɣɛn ë raan la guɔ̈p adumuɔ̈ɔ̈m.’ ” ");
INSERT INTO dikNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ku jɔl Jethu lɛ̈k ke, “Mony kënë, ku acie raan akut Parathï, acï dhuk baai ka adumuɔ̈ɔ̈mke cï päl piny tënë ye. Rin raan nhiam rot ɣäth tueŋ abï dhuɔ̈k ciëën, ku raan lir puɔ̈u rot tɔ̈ɔ̈u ciëën abï ɣäth tueŋ.” ");
INSERT INTO dikNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Kɔc kɔ̈k aake mïth bɛ̈ɛ̈i tënë Jethu bï ke bɛ̈n dɔɔc. Go kɔc Jethu buɔɔth ke läät. ");
INSERT INTO dikNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Go Jethu mïth caal yelɔ̈ɔ̈m ku lueel, “Calkë mïth aa bɔ̈ tënë ɣa, duɔ̈kkë ke pën. Rin raan wïc ye bï la bääny Nhialic yic adhil gam cïmën ë mïth thiikä. ");
INSERT INTO dikNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Alɛ̈k we, raan wïc ye bï bääny Nhialic yök adhil wɛ̈t Nhialic gam, cïmën ye manh koor wɛ̈t kɔc ke dhiëth ye gam.” ");
INSERT INTO dikNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Go raandït kɔc Itharel Jethu thiëëc, “Raan piööc path, yeŋö ba looi ba pïr akölriëëc ëbën yök?” ");
INSERT INTO dikNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Go Jethu lɛ̈k ye, “Yeŋö ye yïn ɣa cɔɔl raan path? Acïn raan path, ee Nhialic ë rot. ");
INSERT INTO dikNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","“Ku na bɛ̈ɛ̈r wɛ̈tdu, ke yïn aŋic käk ye lööŋ Nhialic lueel, ‘Duk tiŋ raandä kɔr, duk raan näk, duk cuëër, duk kuëëŋ wɛ̈t lueth. Thek wuur ku moor.’ ” ");
INSERT INTO dikNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Go mony wën bɛ̈ɛ̈r, “Lööŋkä aaca muk nhïïm ëbën tɛ̈wäär koor ɣɛn agut ëmën.” ");
INSERT INTO dikNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nawën piŋ Jethu kënë, ke lueel tënë ye, “Ala löŋ ŋot kɛ̈c ë looi. Ɣaac käkku ëbën ku gam wëëu tënë kɔc ŋɔ̈ŋ, yïn abï jiɛɛk la yök pan Nhialic ku bäär buɔth ɣa.” ");
INSERT INTO dikNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nawën piŋ mony kën ë wëlkä, ke mɛɛn rin ë jak apɛi. ");
INSERT INTO dikNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Go Jethu tïŋ ke cï puɔ̈u dak ku lueel, “Abï yic riɛl tënë kɔc ajiɛɛk bïk la bääny Nhialic yic. ");
INSERT INTO dikNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Alɛ̈k we alanden, apuɔl yic bï thɔ̈rɔ̈l bak with cök, tɛ̈n tɛ̈ bï raan ajak la bääny Nhialic yic.” ");
INSERT INTO dikNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Go kɔc awën piŋ ë wëlkä Jethu thiëëc, “Na ye këya, yeŋa bï la pan Nhialic?” ");
INSERT INTO dikNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Go Jethu bɛ̈ɛ̈r, “Käk cïï raan ke lëu aaye Nhialic looi.” ");
INSERT INTO dikNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Go Pïtɛr lueel, “Na ɣook, ɣok aacï käkkua nyääŋ wei ku buɔthku yï!” ");
INSERT INTO dikNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Go Jethu lɛ̈k ke, “Wek alɛ̈k yic, raan nyiëëŋ panden wei, ku tiɛŋde ku wämäthakën ku kɔc ke dhiëth ye, ayï miɛ̈thke rin bääny Nhialic, ");
INSERT INTO dikNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","abï käjuëc yök ë riëëc kënë yic, ku pïr akölriëëc ëbën bï bɛ̈n aköldä yic.” ");
INSERT INTO dikNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Nawën ke Jethu cɔɔl kɔcken ye buɔɔth kathiäär ku rou tɛ̈den röt ku lëk ke, “Ëmën ɣok aa la Jeruthalem, tɛ̈ bï käwäär cï kɔc käk Nhialic tïŋ gɔ̈t rin Manh Raan kenhïïm la tiɛɛŋ thïn. ");
INSERT INTO dikNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Abï la thɔ̈n kɔc cie kɔc Itharel bïk bui ku lɛ̈ɛ̈tkë, ku ŋuutkë nyin, ");
INSERT INTO dikNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ku abïk that ku näkkë, ku na ye aköl ye nïn diäk, ke yeen abï pïïr ku jɔt rot raŋ yic.” ");
INSERT INTO dikNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ku kɔc ye buɔɔth aake këc käkkä deet yiic. Wɛ̈tde yic acï thiaan tënë ke, ku keek aacïï kën jiɛɛm Jethu kuc. ");
INSERT INTO dikNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Nawën dötkë Jeriko, ke mony cï cɔɔr ë rɛ̈ɛ̈r dhël yɔu ke lïm. ");
INSERT INTO dikNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nawën piŋ kɔc cath röt, ke thiëc, “Yeŋö loi rot?” ");
INSERT INTO dikNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Go lɛ̈k ye lɔn ë Jethu raan Nadharet yen atëk dhël yic. ");
INSERT INTO dikNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Go cööt, “Jethu, wën Debit liec ɣa.” ");
INSERT INTO dikNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Go kɔc ke tɔ̈ tueŋ läät ku lëkkë ye bï biɛt. Go ŋot kiu apɛi, “Wën Debit kony ɣa.” ");
INSERT INTO dikNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Go Jethu kɔ̈ɔ̈c ku lëk kɔc bïk mony kënë thɛ̈l tënë ye. Nawën cï ɣëët tɛ̈thiɔ̈k, ke thiëëc Jethu, ");
INSERT INTO dikNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Yeŋö wïc ba looi tënë yï?” Go bɛ̈ɛ̈r, “Bɛ̈ny awiëc ba bɛn daai.” ");
INSERT INTO dikNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Go Jethu lɛ̈k ye, “Daaië! Gamdu acï kony.” ");
INSERT INTO dikNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Go guɔ daai nyin yic, ku buɔɔth Jethu ke lec Nhialic. Nawën tïŋ kɔc juëc ke tɔ̈ thïn kë cï rot looi, ke lec Nhialic ëbën. ");
INSERT INTO dikNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Nawën cï Jethu ɣet Jeriko ku bɛr yic. ");
INSERT INTO dikNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ke raan ajak cɔl Dhäkeo ë tɔ̈ thïn ke ye raandït kam kɔc ajuër kut, ");
INSERT INTO dikNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ku yeen ë wïc bï Jethu tïŋ ku ë ciek apɛi. Go ciɛ̈n tɛ̈ tïŋ yen Jethu rin kɔc aake juëc. ");
INSERT INTO dikNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Go riŋ tueŋ ku ler ŋaap nhom, ŋam bïï Jethu tëëk yecök. ");
INSERT INTO dikNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nawën ɣëët Jethu ŋam awën cök ke tïŋ Dhäkeo nhial, go cɔɔl ku lueel, “Dhäkeo, lɔc bɛ̈n piny, yaköl ɣɛn abï cool paandu.” ");
INSERT INTO dikNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Go Dhäkeo bɛ̈n piny ku lor Jethu ke cï puɔ̈u miɛt apɛi. ");
INSERT INTO dikNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nawën tïŋ kɔc ke tɔ̈ thïn ë kënë, ke la ŋoomŋoom ku luelkë, “Mony kënë acï la cool pan raan rac.” ");
INSERT INTO dikNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Go Dhäkeo wɛ̈lken cïï kuëëc nhïïm ku jɔt rot ku lëk Bänyda, “Bɛ̈ny, ëmën thiin ɣɛn abä abɛ̈k ë wɛ̈ɛ̈ukiɛ̈ yiëk kɔc ŋɔ̈ŋ, ku na ca kën raandä cam ruëëny, ka ba dhuk arak ŋuan.” ");
INSERT INTO dikNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Go Jethu lɛ̈k Dhäkeo, “Yaköl, yïïn ku kacku wek aacï pïr akölriëëc ëbën yök, rin yïïn aya yïn ë manh Abaram, ");
INSERT INTO dikNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","rin Manh Raan acï bɛ̈n bï kɔc cï määr wïc, ku kony ke.” ");
INSERT INTO dikNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Tɛ̈wën pïŋ kɔc ë wëlkä, ke Jethu thɔ̈th kääŋ rin ëcï thiɔ̈k ke Jeruthalem. Ku ë yekë tak lɔn bï bääny Nhialic rot guɔ la jɔɔk thïn. ");
INSERT INTO dikNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ku jɔl lueel, “Monytui, ke ye raan gɔl bɛ̈ny, ëcï la wun dɛ̈t mec apɛi bï la ruɔ̈k bï ya bɛ̈nyŋaknhom. Ku jɔl dhuk wuɔ̈nden. ");
INSERT INTO dikNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ku wën këc yen guɔ jäl, ke cɔl aluɔɔnyke kathiäär, ku ye ŋɛk gäm wëëu ku lëk ke, ‘Lɔ̈kkë luui ë wëëukä ɣet aköl bï ɣɛn dhuk.’ ");
INSERT INTO dikNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ku yeen ë mɛɛn kɔcken mɛc, gokë kɔc tuɔɔc yecök bïk la lueel, ‘Mony kënë acuk wïc bï ya bɛ̈nyŋaknhom.’ ");
INSERT INTO dikNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Cɔk awën cïï kacke ye wïc ka ŋot cï ya bɛ̈nyŋaknhom, ku dhuk ku cɔɔl aloonyken wäär cï gäm wëëu, bï bɛ̈n ŋic ye wëëu kadë cï raan tök ya juak wëëu wäär cï yiëk ye yiic. ");
INSERT INTO dikNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Go alony tueŋ bɛ̈n ku lueel, ‘Bɛ̈ny, wëëu wäär ca gäm ɣa, ɣɛn acï wëëu juëc tënë ke arak thiäär yök thïn.’ ");
INSERT INTO dikNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Go bɛ̈ny lɛ̈k ye, ‘Aca ŋiɛc looi, yïn alony path, ku rin cï yïn kälik ŋiɛc muk apath, yïn abï ya bɛ̈ny gɛɛth kathiäär.’ ");
INSERT INTO dikNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Go alony ye kek rou bɛ̈n ku lueel, ‘Bɛ̈ny, ɣɛn acï wëëu juëc arak dhiëc yök tɛ̈n wëëu wäär ca gäm ɣa.’ ");
INSERT INTO dikNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Go bɛ̈ny lɛ̈k alony kënë aya, ‘Yïn abï ya bɛ̈ny gɛɛth kadhiëc.’ ");
INSERT INTO dikNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Ku ben alony dɛ̈t bɛ̈n ku lueel, ‘Bɛ̈ny, wëënkun wäär aa kïk. Aake ca der yiic alanhthiin ye kɔc kenyïn wuuny ku tääu ke. ");
INSERT INTO dikNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ɣɛn ɣa cï riɔ̈ɔ̈c yï, rin ye yïn raan cie këdu puɔ̈l. Yïn ë kë cie këdu lööm, ku yïn ë tem rap kɛ̈c ë puur.’ ");
INSERT INTO dikNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Go bɛ̈ny lɛ̈k ye, ‘Yïn alony rac, dak rot. Wëlkun ca lueel kek aabï luɔ̈k wei. Aŋic lɔn ye ɣɛn kë cie këdiɛ̈ lööm, ku ɣɛn ë rap tem rap kɛ̈c puur. ");
INSERT INTO dikNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Yeŋö këc yïn wɛ̈ɛ̈ukiɛ̈ gäm kɔc ŋic luui wëëu rin na la dhuk aköldä ke yɔ̈k ke cï keyiic juak?’ ” ");
INSERT INTO dikNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Ku yöök bɛ̈ny kɔc wën kääc thïn, ‘Nyaaikë wëëu tënë ye ku gamkë ke tënë raan la wëëu juëc.’ ");
INSERT INTO dikNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Gokë lɛ̈k ye, ‘Bɛ̈ny yeen ala wëëu juëc apɛi.’ ");
INSERT INTO dikNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Go bɛ̈ny lɛ̈k ke, ‘Raan la käŋ abï gäm käjuëc kɔ̈k, ku raan cïn käŋ, abï këthiin tɔ̈ tënë ye nyaai aya. ");
INSERT INTO dikNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ku kɔc man ɣɛn kä, kɔc cïï ɣɛn wïc ba ya bänyden, bɛ̈ɛ̈ikë ke ɣanhom tɛ̈n ku näkkë ke ɣa daai ë ke.’ ” ");
INSERT INTO dikNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Wën cï Jethu käkkä lueel, ke jiël bï la Jeruthalem ke wat atuɔ̈ɔ̈cke nhïïm. ");
INSERT INTO dikNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Tɛ̈wën cï kek thiɔ̈k ke Bethpeec ku Bethanï, tɛ̈thiääk kek gɔn Olip, ke tooc kɔc ye buɔɔth karou tueŋ ");
INSERT INTO dikNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ku lëk ke, “Lak bɛ̈ɛ̈i tɔ̈ tueŋ yiic. Tɛ̈ ɣeet wek, wek aabï manh akaja cïn raan cï kaŋ cath ye yök ke mac. Luɔnykë ku bɛ̈ɛ̈ikë tɛ̈n. ");
INSERT INTO dikNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Na le raan thiëc we, yeŋö lony wek ye? Ke lɛ̈kkë ye, awïc Bänyda.” ");
INSERT INTO dikNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Gokë la ku yökkë manh akaja cït tɛ̈wën cï Jethu ke than thïn. ");
INSERT INTO dikNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Tɛ̈wën lony kek manh akaja, ke lëk raan la akaja ke, “Yeŋö lony wek manh akaja?” ");
INSERT INTO dikNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Gokë bɛ̈ɛ̈r, “Awïc Bänyda.” ");
INSERT INTO dikNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Gokë manh akaja ɣäth tënë Jethu ku kumkë kɔ̈u aläthken, ku nyuc Jethu yekɔ̈u. ");
INSERT INTO dikNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Tɛ̈wën lööny yen dhöl, ke kɔc juëc thieth aläthken dhël yic. ");
INSERT INTO dikNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ku wën lɔɔr yen piny gɔn Olip nhom, go kɔcken ye buɔɔth puɔ̈th miɛt ëbën, ku leckë Nhialic rin käjuëcdït jäŋ gɔ̈i cïk tïŋ ku wɛkkë apɛi ëlä, ");
INSERT INTO dikNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Bï Nhialic bɛ̈nyŋaknhom cï bɛ̈n rin Bänyda dɔɔc. Dɔ̈ɔ̈r pan nhial ku lɛc tënë Nhialic.” ");
INSERT INTO dikNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Go kɔc akut Parathï kɔ̈k ke tɔ̈ kɔc yiic lueel tënë Jethu, “Bɛ̈ny cɔl kɔckun yï buɔɔth aa bit.” ");
INSERT INTO dikNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Go Jethu bɛ̈ɛ̈r, “Alɛ̈k we, na cɔk kë biɛt, ka aleel ë röt, aa loi wuɔɔu.” ");
INSERT INTO dikNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Nawën lek Jeruthalem dööt, ke dhiau wën tïŋ yen gɛu nhom, ");
INSERT INTO dikNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ku lueel, “Dɔ̈ɔ̈r akölriëëc ëbën ëcï we dööt kɔc Jeruthalem, ku wek aacï jai ë ye. Ku ëmën acäk bï bɛn tïŋ. ");
INSERT INTO dikNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ala aköl bï kɔc atɛrdun bɛ̈n ku golkë we abï ciɛ̈n tɛ̈ɣɔ̈r bakkë. ");
INSERT INTO dikNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Aabï we nɔ̈k ëbën agut mïth rɛ̈ɛ̈r ke we. Ku gen Jeruthalem abï thuɔ̈r piny ëbën, abï ciɛ̈n alel kääc alel dɛ̈t nhom, rin këc wek aköl cï Nhialic bɛ̈n bï we kony ŋic.” ");
INSERT INTO dikNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Nawën lek ɣet Jeruthalem ke Jethu la luaŋ Nhialic. Ku cop kɔc käŋ ɣaac aɣeer kal luaŋ Nhialic yic. ");
INSERT INTO dikNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ku lëk ke, “Acï gɔ̈t athör thɛɛr wël Nhialic yic lɔn cï Nhialic ye lueel ëlä, ‘Luaŋdiɛ̈ acï looi bï ya tɛ̈n ye kɔc ëbën röök thïn.’ Ku yeen acäk wel bï ya luaŋ cuɛ̈r.” ");
INSERT INTO dikNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ku jɔl a piööc luaŋ Nhialic akölaköl. Go kɔc käk Nhialic ku kɔc gɛ̈t lööŋ ku kɔcdït baai wïc bïk nɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ku acïn dhël cïk lëu bïk yök bï kek ye looi, rin ye kɔc ëbën rëër yelɔ̈ɔ̈m ke piŋ wɛ̈lke, ku wïckë bï ciɛ̈n töŋ cïk piŋ. ");
INSERT INTO dikNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Naɣɔn akäl tök, tɛ̈wën piööc Jethu kɔc ë Wɛ̈t Puɔth Yam luaŋ Nhialic, ke bɛ̈nydït käk Nhialic, ku kɔc gät lööŋ ku kɔcdït baai bɔ̈ tënë ye. ");
INSERT INTO dikNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ku thiëckë, “Ee yïn, lɛ̈k ɣo ye riɛl ŋö tɔ̈ yïguɔ̈p ye yïn luui këlä? Ku yeŋa yïk yï ë riɛl kënë?” ");
INSERT INTO dikNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Go Jethu bɛ̈ɛ̈r tënë ke, “Wek aba thiëëc aya, lɛ̈kkë ɣa, ");
INSERT INTO dikNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","riɛl ye Joon kɔc gäm lɔ̈kwëi yök tënë Nhialic aye riɛlde ë rot?” ");
INSERT INTO dikNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Gokë kaŋ guëëk yic kamken ë röt ku luelkë, “Na luelku ka yök tënë Nhialic, ka lueel ëlä, yeŋö këc wek wɛ̈tde gam? ");
INSERT INTO dikNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ku na luelku ke riɛlde ë rot, ke ɣok aa näk, rin cï raan ëbën ye gam lɔn Joon ë ye raan käk Nhialic tïŋ.” ");
INSERT INTO dikNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Gokë dhuɔ̈k Jethu, “Ɣok aa kuc tɛ̈ yök yen riɛlde thïn.” ");
INSERT INTO dikNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Go Jethu lɛ̈k ke, “Na ye këya, ke wek aacä lëk riɛl ye ɣɛn käkkä looi.” ");
INSERT INTO dikNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ku ben Jethu jam ë waal tënë kɔc ku lueel, “Monytui ëcï dom looi ku cum yic tiim ë luɔk, ku riöp yic kɔc kɔ̈k. Ku keny wun dɛ̈t, ku le pɛ̈i juëc nɔ̈k wei. ");
INSERT INTO dikNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Nawën le tɛ̈ cï tiim luɔk thɔ̈ɔ̈ŋ, ke tooc aluɔnyde tënë kɔc wäär cï riɔ̈p dom yic bïk la gäm abäkke. Gokë alony dɔm ku thatkë ku copkë ciëën yecin. ");
INSERT INTO dikNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Go alony dɛ̈t bɛn tooc, gokë bɛn dɔm ku thatkë ku baŋkë apɛi. Ku toockë ciëën ke cïn kë cïk gäm ye. ");
INSERT INTO dikNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Go alony dɛ̈t ye kek diäk bɛn tooc, gokë yiëk tɛ̈tök aya ku copkë wei. ");
INSERT INTO dikNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Go wun dom lueel, ‘Yeŋö ba looi? Ɣɛn abï manhdiɛ̈n nhiaar tooc, tɛ̈dë ka bïk la theek.’ ");
INSERT INTO dikNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Nawën tïŋ kɔc cï riɔ̈p dom yic manhde, ke luelkë, ‘Kënë ë manh raan yen la dom, ku ë yen abï käŋ lɔ̈k thɔn aköldä. Bäk näkku ku käkkä aabï döŋ ke ɣo.’ ");
INSERT INTO dikNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ku thelkë aɣeer dom yic ku näkkë.” Ku jɔl Jethu ke thiëëc, “Yeŋö bï raan la dom looi tënë ke?” ");
INSERT INTO dikNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“Abï bɛ̈n ku nɛ̈k kɔc awën cï riɔ̈p dom yic, ku riöp dom yic kɔc kɔ̈k.” Nawën piŋkë ë wɛ̈t kënë ke luelkë, “Diɛ̈t cïï rot loi!” ");
INSERT INTO dikNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Go Jethu ke döt apɛi ku thiëëc ke, “Yeŋö ye wɛ̈t kënë cï gɔ̈t këlä thɛɛr teet yic, ‘Mën wäär yen cï atëët kuec, yen acï bɛ̈n a mën ril.’ ” ");
INSERT INTO dikNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ku lëk Jethu ke, “Na deeny raan yecök mën ka duɔɔny bï ruɔ̈th. Ku na wïk raan nhom ka niɔɔn yic.” ");
INSERT INTO dikNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Go kɔc piööc lööŋ ku bäny käk Nhialic wïc bïk Jethu dɔm nyin yic, rin cï kek ye ŋic lɔn aa kek ke jiëëm Jethu gup ë waal. Ku keek aacï riɔ̈ɔ̈c kɔc awën tɔ̈ thïn. ");
INSERT INTO dikNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Gokë kɔc kɔ̈k riɔp thook bïk röt looi ciɛ̈t ke ye kɔc path tënë Jethu, bïk aa la thiëëc bïk deep rin na le wɛ̈t rɛɛc lueel, ke dɔmkë ku ɣɛ̈thkë tënë bänydït mac baai. ");
INSERT INTO dikNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ku bïk tënë Jethu ku thiëckë ëlä, “Raan piööc, aŋicku lɔn wɛ̈t ye lueel ku kë ye piɔ̈ɔ̈c ee yic. Yïn acie dït raan ye kuɛ̈ɛ̈c nhom. Ku yïn ë kɔc piɔ̈ɔ̈c bïk kë wïc Nhialic looi dhël la cök. ");
INSERT INTO dikNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Lɛ̈k ɣo, na ye täktäkdu buk ajuër dhiɛl aa gam, ɣok kɔc Itharel tënë bɛ̈nyŋaknhom Cithɛ̈r kua cuk bï gäm ye.” ");
INSERT INTO dikNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ku Jethu ëcï ruɛ̈ɛ̈nyden ŋic, ku bëër, ");
INSERT INTO dikNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Nyuɔ̈thkë ɣa wëëu, ku thiëëc ke, ye nhom ŋa ku ye rin ŋa käkkä cï giɛɛt ë wëëth kɔ̈u?” Gokë bɛ̈ɛ̈r, “Aa käk Cithɛ̈r bɛ̈nyŋaknhom.” ");
INSERT INTO dikNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Go Jethu lɛ̈k ke, “Na ŋiɛckë këya, gämkë Cithɛ̈r bɛ̈nyŋaknhom këde ku gämkë Nhialic këde.” ");
INSERT INTO dikNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ku acïn wɛ̈t rɛɛc cï Jethu lueel kɔc nhïïm lëu bï ya awuɔ̈c bï kek ye dɔm. Ku wɛ̈t cï lueel ëcï ke gɔ̈i ku bitkë. ");
INSERT INTO dikNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Go kɔc kɔ̈k akut Thaduthï. Akut cïï yeen ye gam lɔn bï Nhialic kɔc cï thou bɛn cɔl apïr, bɛ̈n tënë Jethu ku thiëckë ëlä, ");
INSERT INTO dikNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Raan piööc, Mothith acï löŋ gɔ̈t ëlä tënë ɣo, ‘Na thou wämënh ë raan ku nyiëëŋ tik piny ke cïn mïth, ke wämënh koor ala ɣöt tik bï mïth dhiëëth ɣön mɛ̈nhë.’ ");
INSERT INTO dikNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Na thööŋku lɔn tɔ̈ mïth tik thïn kadhorou, ku thiëk wën dït, ku thou ke cïn mïth. ");
INSERT INTO dikNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Go wämënh buɔth ye la ɣöt tik, ku thou aya ke cïn mïth cï dhiëëth. ");
INSERT INTO dikNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ku looi rot këya tënë mɛ̈nhë ye kek diäk. Ku këya tënë ke ëbën kadhorou, aacï thou ke cïn mïth cïk nyääŋ piny. ");
INSERT INTO dikNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Nawën ke tik thou aya. ");
INSERT INTO dikNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ku lek tueŋ ku thiëckë, tɛ̈ le kɔc cï thou röt jɔt aköldä, bï ya tiŋ ŋa, rin cï yen rëër ke ke ëbën kadhorou?” ");
INSERT INTO dikNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Go Jethu bɛ̈ɛ̈r, “Thiëŋ ye kɔc röt thiaak ë kën pinynhom tɛ̈n. ");
INSERT INTO dikNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ku kɔc path bï röt jɔt thou yic, kɔc ye pan Nhialic këden, aacie thiëëk ku aacie ë thiaak, ");
INSERT INTO dikNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ku aacïï bï bɛn thou rin aa thöŋ kek atuuc Nhialic. Ku aa mïth Nhialic rin cï kek röt jɔt thou yic. ");
INSERT INTO dikNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ku Mothith guɔ̈p ë jam lɔn ye kɔc cï thou bɛn pïr, wäär gɛ̈t yen tɛ̈ cï Nhialic rot nyuɔ̈th ye ë bun dɛ̈p yic, ku jiɛɛm rin Bɛ̈ny ëlä, ‘Ee Nhialic Abaram, ee Nhialic Ithäk ku ee Nhialic Jakop.’ ");
INSERT INTO dikNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Wɛ̈tde yic ë lɔn ye yen Nhialic ë kɔc pïr, ku acie Nhialic kɔc cï thou, rin kɔc ëbën aa pïr tënë ye.” ");
INSERT INTO dikNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Go kɔc piööc lööŋ ke kääc thïn jam ku luelkë, “Aca ŋiɛc dhuk nhom raan piööc.” ");
INSERT INTO dikNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ku thök jamden rin ë cïk wïc bïk bɛn thiëëc. ");
INSERT INTO dikNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ku lueel Jethu tënë ke, “Yeŋö ë ye lueel lɔn raan cï lɔc ku dɔc ya raan dhiënh Debit? ");
INSERT INTO dikNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Rin aye Debit guɔ̈p luel athör waak yic ëlä, ‘Acï Nhialic lueel tënë Bänydiɛ̈, “Nyuc ë tɛ̈n köŋdiɛ̈n cuëc, ");
INSERT INTO dikNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ɣet tɛ̈ bï ɣɛn kɔc atɛrdu dhuɔ̈k ciëën yïcök.” ’ ");
INSERT INTO dikNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Ye këdë ye yen manh Debit, ku yeen aye Debit cɔɔl, ‘Bänydiɛ̈?’ ” ");
INSERT INTO dikNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Tɛ̈wën piŋ kɔc ëbën wɛ̈tde, ke Jethu wël yenhom kɔcken ye buɔɔth ku lueel, ");
INSERT INTO dikNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Tiɛtkë röt ku duɔ̈kkë kɔc piööc lööŋ Itharel ye kiɛ̈ɛ̈t. Kɔc cath kek alɛ̈thken dït bär, röt teem ɣɔ̈n ɣɔɔc yiic bï ke aa muɔ̈th athɛ̈ɛ̈k. Ayekë nhiaar bïk nyuc tueŋ thöc kɔcdït tɛ̈n amat, ku ɣɔ̈n path aköl yai. ");
INSERT INTO dikNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ku keek aa käk lëër tuɔ̈ɔ̈r nyïn, ku röökkë apɛi bïk kɔc wëŋ lɔn puɔth kek. Kɔckä aabï tɛ̈m awuɔ̈c ril apɛi.” ");
INSERT INTO dikNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Kaam wën ke Jethu cï nyuc tɛ̈ ye wëëu juaar thïn luaŋ Nhialic, ku döt kɔc wëëu cuat kën ajuër yic. Ke kɔc juëc ajiɛɛk aake cï wëëu aa tääu thïn. ");
INSERT INTO dikNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Nawën ke tiŋ lëër aŋääŋ bɔ̈ ku cuɛt wëëu reen lik thïn aya. ");
INSERT INTO dikNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Go Jethu lueel, “Wek alɛ̈k yic, lëër kënë acï Nhialic këden cï juaar nhiaar tënë kɔc kɔ̈k ëbën. ");
INSERT INTO dikNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Rin aa cïk juaar wëëuken juëc yiic, ku yen aŋäŋë, acï kën bï yen pïr dhuɔl thïn ëbën.” ");
INSERT INTO dikNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Tɛ̈wën jiël kek luaŋ Nhialic, ka atuuc kɔ̈k jam tɛ̈ dhëëŋ luaŋ Nhialic thïn ku aleel pɛth cï ye buth, ku kädhëŋ cï gäm Nhialic bï ye door. Go Jethu bɛ̈ɛ̈r, ");
INSERT INTO dikNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Käkkith yakë tïŋ ëmën, ala aköl bï ke thuɔ̈r piny ëbën, ka cïn alel töŋ bï kɔ̈ɔ̈c alel dɛ̈t nhom.” ");
INSERT INTO dikNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Go kë thiëëc, “Raan piööc, ye nɛn bï kënë rot looi, ku yeŋö bï ye nyuɔɔth lɔn tɛ̈ bï kënë rot looi acï thiɔ̈k?” ");
INSERT INTO dikNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Go Jethu lɛ̈k ke, “Tiëërkë nhïïm ku duɔ̈kkë röt cɔl aduɔ̈ŋ. Rin kɔc juëc aabï bɛ̈n ë riɛnkiɛ̈ ku ye ŋɛk lueel, ‘Ke ɣɛn raan cï lɔc ku dɔc, aköl bï ɣɛn bɛ̈n akïn.’ Duɔ̈kkë ke buɔth. ");
INSERT INTO dikNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ku duɔ̈kkë riɔ̈c aköldä tɛ̈ tïŋ wek tɔɔŋ, ku aliääp baai ke loi röt. Käkkä abï röt kaŋ dhiɛl looi tueŋ, ku acie lɔn cïï thök piny guɔ thiɔ̈k.” ");
INSERT INTO dikNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ku ben Jethu lueel ëlä tënë ke, “Wuɔ̈t aabï kenhïïm tuɔ̈ɔ̈m ku thɛ̈rkë, ku bɛ̈ɛ̈i mɛc bänydït abï thɔ̈r kamken. ");
INSERT INTO dikNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ayiɛ̈ɛ̈kyiɛ̈ɛ̈k piny dït juëc aabï röt looi, ku tuaany ku cɔŋdït apɛi aabï röt looi ɣɔ̈n juëc yiic. Ku kärɛc kɔ̈k aabï röt looi, ku kädït kɔc cɔl ariɔ̈c aabï tïŋ nhial. ");
INSERT INTO dikNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ku tueŋ bï käkkä röt looi, wek aabï gum apɛi, ku wek aabï ɣäth tɛ̈n amat ku mɛc we. Ku wek aabï ɣäth luk yic bäny nhïïm ë riɛnkiɛ̈. ");
INSERT INTO dikNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ku ë yen tɛ̈n bï wek kɔc ëbën lɛ̈k Wɛ̈t Puɔth Yam thïn. ");
INSERT INTO dikNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ku duɔ̈kkë diɛɛr tɛ̈ bï wek röt kuɔny thïn, ");
INSERT INTO dikNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","rin wek aba kony ba we cɔl aŋic wël puɔth bäk lueel, käk cïï kɔc atɛrdun we bï jɔ̈ɔ̈ny, tɛ̈dë ke dhäl käkkun yakë lueel. ");
INSERT INTO dikNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Wek aabï kɔc ke dhiëth we, ku wämäthakun, ku kɔc ruääi ke we ku mäthkun gaany. Ku kɔc kɔ̈k kamkun aabï nɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ku raan ëbën abï we maan ë riɛnkiɛ̈, ");
INSERT INTO dikNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ku wek aabï kony na cɔk a nhiëm töŋ nhom ka cïï bï määr. ");
INSERT INTO dikNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Deet bï wek wepuɔ̈th dɛɛt abï we cɔl apïr. ");
INSERT INTO dikNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Aköl tïŋ wek Jeruthalem ke cï apuruuk wuɔ̈t kɔ̈k gool, ke ŋiɛckë lɔn tɛ̈ bï ye rac acï bɛ̈n. ");
INSERT INTO dikNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ke kɔc rɛ̈ɛ̈r Judia aa dhil riŋ gat nhïïm, ku kɔc rɛ̈ɛ̈r geeu Jeruthalem aa dhil jäl, ku kɔc tɔ̈ bɛ̈ɛ̈i yiic aɣeer aacïï la geeu. ");
INSERT INTO dikNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Rin tɛ̈në, kek aa nïn bï kɔc tɛ̈m awuɔ̈c bï kë cï gɔ̈t athör thɛɛr wël Nhialic yic yenhom tiɛɛŋ. ");
INSERT INTO dikNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Diäär liɛc ku diäär muk mïth kor aabï gum apɛidït ë nïnkä. Kɔc ë wunë, aabï gum apɛi ku aabï Nhialic tɛ̈m awuɔ̈c. ");
INSERT INTO dikNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Kɔc kɔ̈k aabï nɔ̈k tɔŋ yic, ku kɔc kɔ̈k aabï dɔm ku la ke mac wuɔ̈t kɔ̈k yiic. Ku Jeruthalem abï wuɔ̈t kɔ̈k dɔm ku rɛckë apɛi, ku mackë ɣet aköl bï bäänyden thök. ");
INSERT INTO dikNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Käk këc kaŋ tïŋ aabï röt looi tënë akɔ̈l ku pɛɛi ku kuɛl. Ku kɔc wuɔ̈t pinynhom ëbën aabï puɔ̈th jiɛth, ku riɔ̈ɔ̈ckë atiaktiak dït loi rot wër yiic. ");
INSERT INTO dikNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ku kɔc aabï riɔ̈ɔ̈c apɛi rin käk loi röt pinynhom. Käk tɔ̈ nhial ëbën, akɔ̈l ku pɛɛi ku kuɛl aabï röt yääk. ");
INSERT INTO dikNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ku Manh Raan abï tïŋ ke bɔ̈ nhial pial yiic kek diik ku riɛldït apɛi. ");
INSERT INTO dikNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Tɛ̈ looi käkkä röt, ke we deet wepuɔ̈th ku rɛ̈ɛ̈rkë ë cök rin tɛ̈ bï we luɔ̈k kärɛc yiic acï ɣëët.” ");
INSERT INTO dikNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","30","Ku ben Jethu ke lɛ̈k kääŋ kënë, “Tɛ̈ tïŋ wek tim cït ŋaap ayï tiim kɔ̈k ke loi yïth yam, ka ŋiɛckë lɔn cï kër thiɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Këya, na tiɛ̈ŋkë käkkä ke loi röt, ke ŋiɛckë lɔn cï bääny Nhialic thiɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Alɛ̈k we, wek aacïï bï määr tɛ̈ cɔk käkkä röt looi. ");
INSERT INTO dikNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Nhial ku piny aabï liu, ku wɛ̈tdiɛ̈ acïï bï kaŋ määr. ");
INSERT INTO dikNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Guiɛrkë röt, ku rɛ̈ɛ̈rkë we tïr nhïïm. Duɔ̈kkë aköl bï ɣɛn bɛ̈n cɔl ayök we ke we këc röt guiir. Duɔ̈kkë röt cɔl ayɔ̈k we pïr pïr rac, bäk aa rëër we cï wiɛɛt ë mɔ̈u akölaköl, ku yakë rëër we tɛ̈k käk pïr pinynhom. Aköl kënë abï la ciel wegup ke cäk ŋic, ");
INSERT INTO dikNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","cïmën län adhie wɛ̈i adëëp. Ku kënë abï bɛ̈n tënë kuat raan pïr pinynhom ëbën. ");
INSERT INTO dikNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Rɛ̈ɛ̈rkë we tït ku rɔ̈ɔ̈kkë akölaköl bäk la riɛl bï wek kë bï rot looi göök, bäk kɔ̈ɔ̈c ɣanhom ɣɛn Manh Raan we cïï diɛɛr.” ");
INSERT INTO dikNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ku jɔl Jethu ë nïnkä nɔ̈k ke ye piööc luaŋ Nhialic, na bɔ̈ thëi ke jiël bï la nin gɔn Olip nhom. ");
INSERT INTO dikNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ku kɔc aake ye guëër luaŋ Nhialic rial bïk piɔ̈ɔ̈cde bɛ̈n piŋ. ");
INSERT INTO dikNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Nawën la tɛ̈ bï Yan Ayum cïn yic luɔu looi thiɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ke kɔcdït käk Nhialic ku kɔc piööc lööŋ wïc dhël path bï kek Jethu nɔ̈k, rin riɔ̈ɔ̈c kek ciɛ̈t la aliäm bï rot looi. ");
INSERT INTO dikNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ku raan tök kam kɔc ye buɔɔth kathiäär ku rou cɔl Juda Ithkariöt, ëcï bɛ̈ny jɔŋrac la yepuɔ̈u. ");
INSERT INTO dikNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Go la tënë kɔcdït käk Nhialic ku bäny apuruuk luaŋ Nhialic tiit, bï tɛ̈ bï yen ke kuɔny thïn, bïk Jethu dɔm la guëëk yic. ");
INSERT INTO dikNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Gokë puɔ̈th miɛt wën piŋ kek ye lɔn bï yen ke kony, ku thɔnkë lɔn bï kek ye riɔp. ");
INSERT INTO dikNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Go gam, ku wïc tɛ̈pɛth bï yen Jethu dɔm thïn ke cïn kɔc ŋic ye. ");
INSERT INTO dikNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Aköl bï Yan Ayum cïn yic luɔu looi ëcï bɛ̈n, aköl ye amɛ̈l nɔ̈k rin yai. ");
INSERT INTO dikNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Go Jethu Pïtɛr ku Joon tooc ku lëk ke, “Lak bäk miëth yai la guiir tënë ɣo.” ");
INSERT INTO dikNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Gokë thiëëc, “Ye tɛ̈nɛn wïc yïn ɣo buk miëth yai la guiir thïn?” ");
INSERT INTO dikNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Go Jethu bɛ̈ɛ̈r, “Tɛ̈ le wek geeu Jeruthalem, ke wek aabï rɔ̈m kek mony ɣɛ̈ɛ̈c töny ë pïu. Biaathkë pan le yen thïn. ");
INSERT INTO dikNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ku lɛ̈kkë raan la baai, aye Raan piööc lueel, ‘Ye ɣön nɛn bï ɣɛn miëth yai cam thïn ɣok kɔckiɛ̈n ɣa buɔɔth?’ ");
INSERT INTO dikNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ku abï we nyuɔ̈th ɣön nhial lääu yic cï guiir yic. Guiɛrkë miëth ë tɛ̈ɛ̈n.” ");
INSERT INTO dikNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Gokë la ku yökkë këriëëc ëbën cït tɛ̈wën cï Jethu ye lɛ̈k ke thïn. Ku jɔlkë miëth yai guiir. ");
INSERT INTO dikNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Tɛ̈wën bï kek jäl mïth ke Jethu nyuc tɛ̈de ku nyuc atuɔ̈ɔ̈cke aya, ");
INSERT INTO dikNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ku lëk ke, “Aca wïc apɛi ba miëth Yan Ayum cïn yic luɔu kënë cam kek we ku ba jäl gum. ");
INSERT INTO dikNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Alɛ̈k we lɔn acä bï bɛn cam ɣet tɛ̈ bï wɛ̈t tɔ̈ yeyic yök bääny Nhialic yic.” ");
INSERT INTO dikNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ku lööm aduŋ cï thiäŋ muɔ̈n abiëc, ku leec Nhialic ku lueel, “Lɔ̈mkë kënë ku tɛkkë ë kamkun. ");
INSERT INTO dikNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Alɛ̈k we lɔn ɣɛn acïn muɔ̈n abiëc dɛ̈t ba bɛn dek ɣet aköl bï bääny Nhialic bɛ̈n.” ");
INSERT INTO dikNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Nawën ke löm ayup ku leec Nhialic, ku bɛny yic ku gɛ̈m ke ku lueel, “Kënë ë guäpdiɛ̈ cï juaar riɛnkun. Yakë looi këlä bäk ɣa ya tak.” ");
INSERT INTO dikNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nawën miëth cök ke ben aduŋ la yic muɔ̈n abiëc lööm aya ku lueel, “Kënë ë dɔ̈ɔ̈r yam ke Nhialic cï thany ë riɛmdiɛ̈ bï kuër ë riɛnkun.” ");
INSERT INTO dikNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Ku yen kïn, raan bä luɔm arɛ̈ɛ̈r tɛ̈n, ku amïth kek ɣa! ");
INSERT INTO dikNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ku ë tɛ̈de, Manh Raan adhil thou cït tɛ̈ cï Nhialic guiër ye. Ku raan bä luɔm abï gum apɛi!” ");
INSERT INTO dikNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Gokë röt thiëëc tök, tök, yeŋa kamkua lëu bï ya yen loi kënë. ");
INSERT INTO dikNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kaam wën aya ke kɔc ye buɔɔth teer wɛ̈t lɔn nadë, “Yeŋa kamken yen bï ya raan dït apɛi.” ");
INSERT INTO dikNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Go Jethu lɛ̈k ke, “Pinynhom tɛ̈n bäny kɔc cie kɔc Itharel aa la riɛl tënë kɔcken mɛckë, ku kɔc mac baai aa röt cɔɔl, ‘Kɔc määth ke kɔc baai.’ ");
INSERT INTO dikNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ku acie tɛ̈de tënë we, rin raandït kamkun adhil rot dhuɔ̈k piny bï ciɛ̈t raan koor. Ku raan tɔ̈ tueŋ adhil rot dhuɔ̈k ciëën bï luui tënë kɔc kɔ̈k.” ");
INSERT INTO dikNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ku thiëëc ke, “Yeŋa yen dït, ye raan ye luɔ̈ɔ̈i aye raan ë luui? Cie raan ye luɔ̈ɔ̈i? Ku ɣɛn kamkun ɣɛn acït raan ë luui. ");
INSERT INTO dikNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Wek aacï kɔ̈ɔ̈c ke ɣa käril cä yök yiic, ");
INSERT INTO dikNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ku cït mënë cï Wä ɣa looi ba ya bɛ̈ny, wek aba yiëk ë bääny kënë aya. ");
INSERT INTO dikNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Wek aabï mïth ku dɛ̈kkë kek ɣa bäänydiɛ̈ yic, ku nyuɔ̈ɔ̈ckë thöc nhïïm bäk luŋ thän Itharel yic thiäär ku rou looi.” ");
INSERT INTO dikNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ku ben Jethu lueel, “Thaimon, Thaimon piŋ wɛ̈tdiɛ̈në, bɛ̈ny jakrɛc acï thiëc bï gäm riɛl bï we them ëbën, bï kɔc path tek thook tënë kɔc rɛc, cïmën dhie ye rap kɔ̈ɔ̈m bï miël tek thok rap yiic. ");
INSERT INTO dikNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ku ɣɛn acï röök riɛnku yïn Thaimon bï gamdu dhiɛl riɛl. Ku na ca jal dhuk tënë ɣa, ke yï kony wämäthakui kɔ̈k.” ");
INSERT INTO dikNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Go Pïtɛr bɛ̈ɛ̈r, “Bɛ̈ny acïn kë bä gël bï ɣa cïï mɛc kek yï, ku thuɔɔu kek yï aya.” ");
INSERT INTO dikNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Go Jethu lueel tënë ye, “Alɛ̈k yï Pïtɛr, nhiäk bɛ̈ɛ̈k piny ke thɔn ajïth këc kiu, yïn abä jai arak diäk lɔn kuc yïn ɣa.” ");
INSERT INTO dikNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Nawën ke Jethu thiëc kɔcken ye buɔɔth, “Tɛ̈ tooc ɣɛn we bäk Wɛ̈t Puɔth Yam la lɛ̈k kɔc, ku wek aacïn wëëu ku jɔkgɔɔ la keny ayï war, yakë yök lɔn le yen kë liu tënë we?” Gokë bɛ̈ɛ̈r, “Acïn këdäŋ.” ");
INSERT INTO dikNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Go Jethu lueel, “Ëmën, na la raan wëëu ke muk ke, ku muk jɔkgɔ aya. Ku na yïn acïn pal, ke yï ɣɔɔc alɛ̈th abɛ̈k wei ku ɣɔc. ");
INSERT INTO dikNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Luɔikë ë kënë rin aye wël cï gɔ̈t thɛɛr ë riɛnkiɛ̈ lueel, lɔn ye ɣɛn raan tök kam kɔc kärɛc looi. Ku wɛ̈t kënë abï yenhom tiɛɛŋ ëmën.” ");
INSERT INTO dikNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Go kɔc ye buɔɔth lueel, “Bɛ̈ny, paal karou aa kïk.” Go bɛ̈ɛ̈r, “Aa juëc.” ");
INSERT INTO dikNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Nawën ke Jethu jiël ku ruɛc kɔcken ye buɔɔth, ku ler gɔn Olip nhom cïmënden yen ye looi akölaköl. ");
INSERT INTO dikNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Nawën lek ɣet tɛ̈den adhie, ke lëk ke, “Rɔ̈ɔ̈kkë Nhialic bï we cïï them jakrɛc.” ");
INSERT INTO dikNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ku nyiëëŋke piny ku le tueŋ tɛ̈thin-nyɔɔt, ku gut yenhiɔl piny ku röök, ");
INSERT INTO dikNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ku lueel, “Wä, na lëu rot ke kërɛɛc tit ɣa acïï bɔ̈. Ku acie wɛ̈tdiɛ̈ ë wɛ̈tdu.” ");
INSERT INTO dikNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Go atuny nhial rot nyuɔ̈th ye ku deet puɔ̈u, ");
INSERT INTO dikNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","rin ë dhiau apɛi yepuɔ̈u. Ku ben röök apɛi abï tuc kuër yeguɔ̈p cïmën riɛm. ");
INSERT INTO dikNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ku jɔt rot tɛ̈wën röök yen thïn ku dhuk tënë kɔc ye buɔɔth, ku yök ke ke nin rin cï riääk ë puɔ̈u ke cɔl agök. ");
INSERT INTO dikNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Go lueel tënë ke, “Yeŋö niin wek? Jatkë röt ku rɔ̈ɔ̈kkë bï we cïï them jakrɛc.” ");
INSERT INTO dikNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jethu ë ŋot jam tɛ̈wën bïï kɔc juëc ke wɛt Juda nhïïm, raan tök kam kɔc ye buɔɔth kathiäär ku rou. Ku ler tënë Jethu ku muɔ̈ɔ̈th ke ciim. ");
INSERT INTO dikNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Go Jethu lueel, “Juda ca ɣa ciim ba Manh Raan nyuɔ̈th kɔc dɔm ye?” ");
INSERT INTO dikNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Nawën tïŋ kɔc ye buɔɔth ke rɛ̈ɛ̈r kek ye kë bï rot looi, ke luelkë, “Bɛ̈ny, cuk thär? Ɣok aa muk paalkua.” ");
INSERT INTO dikNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Go raan tök kamken palde miëët bei, ku tök alony lui pan raandït käk Nhialic ku teem yïnyden cuëc wei. ");
INSERT INTO dikNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Go Jethu lueel, “Acie këya.” Ku gɔɔt mony awën yïc tɛ̈wën cï tök pal, ku kony bï dɛm. ");
INSERT INTO dikNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ku jɔl Jethu jam tënë raandït käk Nhialic ku bäny apuruuk luaŋ Nhialic tiit, ku kɔcdït baai cï bɛ̈n bïk ye dɔm, ku lueel, “Cäk bɛ̈n we muk paal ku atuel ciɛ̈t ɣa ye raan kɔc rum? ");
INSERT INTO dikNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ɣɛn ë rëër kek we luaŋ Nhialic akölaköl, ku akɛ̈ckë kaŋ them bäk ɣa dɔm. Ku ëmën wek aacï puɔ̈l bäk kë tɔ̈ wepuɔ̈th looi. Ku tɛ̈në jɔŋrac abï la riɛl bï kërɛɛc wïc looi.” ");
INSERT INTO dikNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Gokë Jethu dɔm ku ɣɛ̈thkë pan raandït käk Nhialic. Ku Pïtɛr ë biöth ke mec kɔc cök ciëën. ");
INSERT INTO dikNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ku apuruuk aake cï many ɣɔ̈ckë took kal yic. Go Pïtɛr rot mät ke ku nyuuc bï ɣɔ̈c. ");
INSERT INTO dikNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nawën tïŋ nyan lui pan bɛ̈ny Pïtɛr ke nyuc mac lɔ̈ɔ̈m, ke döt apɛi ku lueel, “Mony kënë ë ye rëër kek Jethu aya.” ");
INSERT INTO dikNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Go Pïtɛr jai ku lueel, “Mony kënë acä cɔk ŋic yïn nyɛnë!” ");
INSERT INTO dikNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ku kaam thiin awën ke mony dɛ̈t tïŋ Pïtɛr ku lueel, “Yïn ë raanden aya.” Go Pïtɛr bɛ̈ɛ̈r, “Acie ɣɛn mäthdiɛ̈.” ");
INSERT INTO dikNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ku kaam awën, ke wɛ̈t yen raan Jethu, ben mony dɛ̈t muɔ̈k yeguɔ̈p apɛi ku lueel, “Acïn diu lɔn ye mony kënë rëër kek Jethu, rin ë raan Galilia.” ");
INSERT INTO dikNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Go Pïtɛr bɛ̈ɛ̈r! “Mäthdiɛ̈, kë ye lueel acä cak deet yic.” Ku kaam wën ŋot jiɛɛm yen ke thɔn ajïth kiu. ");
INSERT INTO dikNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Go Jethu yenhom wel ku döt Pïtɛr. Go Pïtɛr këwäär cï Bɛ̈ny Jethu lɛ̈k ye ëlä, “Tueŋ ke thɔn ajïth këc kiu ya aköl, aba lueel arak diäk lɔn kuc yïn ɣa.” ");
INSERT INTO dikNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ku ler aɣeer ke cï guɔ̈p yär ku dhiɛɛu apɛi. ");
INSERT INTO dikNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Tɛ̈n awën ke kɔc ke tit Jethu, ee yekë bui ku thatkë, ");
INSERT INTO dikNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ku derkë nyin ku guutkë kecin ku yöökkë, “Mɛɛkë! Yeŋa yï gut?” ");
INSERT INTO dikNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ku lueelkë kärɛc apɛi yeguɔ̈p. ");
INSERT INTO dikNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nawën bak piny, ke kɔcdït Itharel ku kɔcdït käk Nhialic, ku kɔc piööc lööŋ mat kenhïïm. Ku bïï Jethu luɔ̈ŋden yic. ");
INSERT INTO dikNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ku lëkkë ye, “Na ye Raan cï lɔc ku dɔc, ke lɛ̈k ɣo.” Go Jethu bɛ̈ɛ̈r, “Na lɛ̈k we ke wek aacïï wɛ̈tdiɛ̈ bï gam, ");
INSERT INTO dikNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ku na thiëëc we, ka cäk bï bɛ̈ɛ̈r. ");
INSERT INTO dikNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ku ëmën ler tueŋ, Manh Raan abï nyuc lɔŋ cuëc Nhialic Madhɔl.” ");
INSERT INTO dikNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Gokë rek yic ëbën, “Na ye këya, ye Wën Nhialic?” Go Jethu bɛ̈ɛ̈r, “Ee ɣɛn, cït tɛ̈ cäk luɛ̈l ye.” ");
INSERT INTO dikNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Gokë lueel, “Acïn dɛ̈t wïcku kɔc kɔ̈k bï bɛ̈n jam käk cï looi. Ɣok aacï wël cï lueel ë thuɔŋde piŋ.” ");
INSERT INTO dikNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Go kɔc luk röt jɔt ëbën ku ɣɛ̈thkë Jethu Pilato nhom raan Roma. ");
INSERT INTO dikNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ku gɔɔnykë ku luelkë, “Ɣok aacï mony kënë yök ke rɛc kackua nhïïm, ke ye lɛ̈k ke bïk ajuër cïï ye tääu piny tënë bɛ̈nyŋaknhom Roma. Ku aye lueel aya lɔn ye yen Raan cï lɔc ku dɔc, bɛ̈nyŋaknhom.” ");
INSERT INTO dikNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Go Pilato thiëëc, “Ye yïn bɛ̈nyŋaknhom kɔc Itharel?” Go Jethu bɛ̈ɛ̈r, “Ee ɣa, cït tɛ̈ ca luɛ̈l ye.” ");
INSERT INTO dikNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Go Pilato yenhom wɛ̈l kɔcdït käk Nhialic ku thän awën ku lueel, “Acïn awuɔ̈c ca yök ee raan kënë guɔ̈p.” ");
INSERT INTO dikNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Gokë ŋot ke jam apɛi ku luelkë, “Tɛ̈den yen kɔc piɔ̈ɔ̈c thïn ajɔk aliääp Judia yic ëbën. Acï jɔɔk Galilia ku yen kïn cï bɛ̈n Jeruthalem ëmën.” ");
INSERT INTO dikNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Nawën piŋ Pilato ë wëlkä ke thiëëc lɔn yen raan Galilia. ");
INSERT INTO dikNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Nawën le ŋic lɔn ye Jethu raan wun mɛc Antipäth Ɣërot, ku yeen ë rɛ̈ɛ̈r Jeruthalem ë nïnkä, ke cɔl Jethu aɣɛ̈th yenhom. ");
INSERT INTO dikNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Go Antipäth Ɣërot puɔ̈u miɛt wën tïŋ yen Jethu, rin ëcï käjuëc piŋ ë riɛnke. Ku ëcï Ɣërot wïc apɛi bï Jethu tïŋ, ku ŋɔ̈ɔ̈th aya bï käk ye Jethu ke looi tïŋ. ");
INSERT INTO dikNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Go Jethu jal thiëëc wël juëc, go Jethu biɛt kecïn wɛ̈t töŋ dhuk nhom. ");
INSERT INTO dikNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Go kɔcdït käk Nhialic ku kɔc piööc lööŋ röt cuɔt tueŋ, ku lueelkë wël rɛc apɛi Jethu guɔ̈p. ");
INSERT INTO dikNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Go Antipäth Ɣërot kek apuruɔ̈ɔ̈kke Jethu bui ku lɛ̈ɛ̈tkë. Ku rukkë alanh dhëŋ apɛi cït alanh bɛ̈ny yekɔ̈u, ku toockë ciëën tënë Pilato. ");
INSERT INTO dikNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ku jɔl Antipäth Ɣërot kek Pilato, wäär man röt jal määth akölë. ");
INSERT INTO dikNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Go Pilato kɔcdït käk Nhialic ku kɔcdït baai, ku kɔc kɔ̈k cɔɔl ëbën, ");
INSERT INTO dikNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ku lëk ke, “Wek aacï mony kënë bɛ̈ɛ̈i ɣanhom, ku luɛlkë lɔn ë yen raan rɛc kɔc nhïïm bïk aliääp looi. Ku ëmën ɣɛn acï wɛ̈t wïc yic wenhïïm, ku akɛ̈c yök ke la guɔ̈p awuɔ̈c cɔk alɔn cï wek ye gaany käjuëc apɛi. ");
INSERT INTO dikNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Na cɔk a Antipäth Ɣërot ka këc yök ke la guɔ̈p awuɔ̈c, yen ale yen ye cɔl adhuk ɣanhom. Acïn awuɔ̈c cï mony kënë looi lëu bï ye nɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Aba cɔl athat ku luɔny.” ");
INSERT INTO dikNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ruɔ̈ɔ̈n ëbën aköl Yan Ayum cïn yic luɔu, Pilato ë raan tök kam kɔc cï mac lony tɛ̈ wïc kɔc baai ye bï lony. ");
INSERT INTO dikNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Go thän awën tɔ̈ thïn wuɔɔu looi, “Näk! Ku lony Barabath tënë ɣo.” ");
INSERT INTO dikNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabath ëcï mac rin aliäm cï rot looi geeu, ku rin cï yen raan nɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ë wïc Pilato bï Jethu lony, ku ben jam tënë ke. ");
INSERT INTO dikNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Gokë bɛn kiu apɛi, “Apiëët tim cï rïïu kɔ̈u.” ");
INSERT INTO dikNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Go Pilato bɛn jam tënë ke, kënë yen yic diäk ku lueel, “Yeŋö? Ye awäc ŋö cï looi? Acïn awuɔ̈c ca yök ke cï looi lëu bï ye nɔ̈k! Aba cɔl athat ku cal ajiël.” ");
INSERT INTO dikNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Gokë ŋot ke kiu apɛi röldït, lɔn dhil Jethu piäät tim cï rïïu kɔ̈u. Ku këden wën yekë lueel acï yenhom bɛ̈n guɔ̈t. ");
INSERT INTO dikNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Go Pilato wɛ̈tden gam ku tëm Jethu awuɔ̈c wën wïckë. ");
INSERT INTO dikNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ku lony Barabath, raan wäär cï mac rin aliääp, ku rin cï yen raan nɔ̈k. Ku yïk ke Jethu bïk la luɔɔi tɛ̈den wïckë kepuɔ̈th. ");
INSERT INTO dikNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Gokë Jethu kuaath aɣeer. Ku wën kuɛɛth kek ye, ke mony cɔl Thaimon raan pan Thirene bɔ̈ baai, nawën cï tim cï rïïu Jethu göök, gokë dɔm ku cɔlkë aket tim ke buɔɔth Jethu cök. ");
INSERT INTO dikNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ku buɔɔth kɔc juëc apɛi ku diäär dhiau riɛnke aya. ");
INSERT INTO dikNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Go Jethu yenhom wɛ̈l ke ku lueel, “Diäär Jeruthalem, duɔ̈kkë dhiau ë riɛnkiɛ̈, dhiaaukë ë riɛnkun ku rin miɛ̈thkun. ");
INSERT INTO dikNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Rin nïn bï ye lueel ëlä aacï thiɔ̈k, ‘Diäär mit gup aa diäär këc mïth kaŋ thuɛ̈ɛ̈t!’ ");
INSERT INTO dikNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ku ë yen tɛ̈n bï ye aa luɛɛl thïn aya ëlä, ‘Aŋuɛ̈ɛ̈n buk ciɛ̈t kɔc cï thou, kɔc cï wiɛ̈k nhïïm, kɔc cï kë cï wïïk kenhïïm kuɔ̈m piny.’ ");
INSERT INTO dikNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Na ye këcït kënë rot looi ke tim tɔ̈c, ke yeŋö yakë tak ke bï rot looi tɛ̈ le yen riɛl.” ");
INSERT INTO dikNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ku kuath apuruuk kɔc karou aya, kɔc la gup awuɔ̈cdït tet bïk ke la nɔ̈k kek Jethu. ");
INSERT INTO dikNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Nawën lek tɛ̈ cɔl Ithkal dööt, ke piɛ̈ɛ̈t Jethu tim cï rïïu kɔ̈u ku kɔc awën karou, raan tök lɔŋ cuëc ku raan dɛ̈t lɔŋ cam. ");
INSERT INTO dikNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Go Jethu lueel, “Wä, päl piny tënë ke, keek aa kuc kë loikë.” Ku cuɛt apuruuk gɛk bïk alɛ̈th Jethu tek kamken. ");
INSERT INTO dikNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ku jɔl kɔc juëc kɔ̈ɔ̈c ë tɛ̈ɛ̈n ke daai ye. Ku tɛ̈n awën ë ye kɔcdït Itharel bui ku luelkë, “Ee kɔc kɔ̈k kony, cɔl akony rot tɛ̈ ye yen Raan cï Nhialic lɔc ku dɔɔc.” ");
INSERT INTO dikNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ku bui apuruuk aya. Ku bïk tënë ye ku gɛ̈mkë muɔ̈n abiëc cï wac, ");
INSERT INTO dikNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ku luelkë, “Na ye bɛ̈ny kɔc Itharel ke yï kony rot.” ");
INSERT INTO dikNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ku piɛ̈ɛ̈tkë tim cï ye gɔ̈t thïn këlä nhial tim Jethu nhom, “KËNË Ë BƐNYŊAKNHOM ITHAREL.” ");
INSERT INTO dikNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Go raan tök kam kɔc awën cï piäät kek ye lat ku lueel, “Cïï ye Raan cï Nhialic lɔc ku dɔɔc? Kony rot ku kony ɣo aya.” ");
INSERT INTO dikNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Go raan dɛ̈ɛ̈të puɔ̈u riääk ku nyieeny, “Cïï ye cak riɔ̈ɔ̈c Nhialic agut tɛ̈ thou yïn aya? Ɣok aacï tɛ̈m thou cïmënde. ");
INSERT INTO dikNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ku awäcda adhilku jɔt rin ɣok aa col kë cuk looi, ku mony kënë acïn kërɛɛc cï looi.” ");
INSERT INTO dikNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ku lueel tënë Jethu, “Tak ɣa tɛ̈ ɣeet yïn Bäänydu yic.” ");
INSERT INTO dikNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Go Jethu lɛ̈k ye, “Yïn alɛ̈k yic, yaköl yïn abï rëër kek ɣa pan Nhialic.” ");
INSERT INTO dikNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Nawën tɛ̈cït akɔ̈l ciɛl yic ke muɔ̈ɔ̈th loi rot pan awën, ku cïï akɔ̈l ruel ɣet tääŋ akɔ̈l. ");
INSERT INTO dikNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ku tɛ̈wën ka alanh ye gɛ̈ɛ̈ŋ bï luaŋ Nhialic tek yic alɔŋ thïn rɛɛt yic rou. ");
INSERT INTO dikNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ku cöt Jethu röldït ku lueel, “Wä, wɛ̈ikiɛ̈ aaca than yïcin.” Acï wëlkä lueel ku thou. ");
INSERT INTO dikNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nawën tïŋ bäny apuruuk kë cï rot looi, ke lec Nhialic ku lueel, “Mony kënë ë ye raan path alanden.” ");
INSERT INTO dikNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nawën tïŋ kɔc ke cï kenhïïm kut tɛ̈ɛ̈n bïk daai kë cï rot looi, gokë dhuk baai ke gut kepuɔ̈th. ");
INSERT INTO dikNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Kɔc ke ŋiɛ̈c kek Jethu ëbën, agut diäär ke buɔth ye wäär jiël yen Galilia, aake daai ë käkkä ëbën. ");
INSERT INTO dikNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Mony cɔl Jothep ë tɔ̈ thïn. Ku yeen ë raan gen Arimatheo, pan Judia. Jothep ë ye raan path la cök, ku yeen ë ŋɔ̈th bɛ̈n bääny Nhialic. Ku yeen ë ye raan akut luk kɔc Itharel. ");
INSERT INTO dikNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nawën le tïŋ lɔn cï Jethu thou, ke la tënë Pilato ku thiëëc guɔ̈p Jethu. ");
INSERT INTO dikNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ku bïï piny tim kɔ̈u ku der alath, ku tɛ̈ɛ̈u raŋ cï wec kuur yic, raŋ cïn raan cï kaŋ thiɔ̈k thïn. ");
INSERT INTO dikNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ee ya aköl nïn dhiëc, aköl ye kɔc röt guiir rin aköl cïï kɔc ye luui, ee bï guɔ bɛ̈n. ");
INSERT INTO dikNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Nawën cï guɔ̈p Jethu bɛ̈ɛ̈i piny tim kɔ̈u, ke diäär wäär bɔ̈ kek Jethu Galilia, buɔth Jothep ku tïŋkë tɛ̈ cï guɔ̈p Jethu tääu thïn raŋ yic, ");
INSERT INTO dikNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ku dhukkë baai ku lek miök ŋïr guiir bï kek guɔ̈p Jethu bɛ̈n tɔc. Nawën aköl cïï kɔc ye luui, ke ke lɔ̈ŋ cït tɛ̈ ye löŋ Mothith luɛ̈l ye. ");
INSERT INTO dikNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Naɣɔn nhiäk rial aköl Nhialic, ke diäär la raŋ nhom kek miök ŋïr cïk guiir. ");
INSERT INTO dikNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ku yökkë alel cï raŋ kum nhom ke cï laar wei. ");
INSERT INTO dikNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Nawën lek raŋ yic ke cïï guɔ̈p Jethu yök thïn. ");
INSERT INTO dikNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Tɛ̈wën kɛ̈ɛ̈c kek ke cï gäi, ke röör karou ceŋ alɛ̈th ɣer apɛi cï la toptop bɔ̈, ku kɛ̈ɛ̈ckë kelɔ̈m. ");
INSERT INTO dikNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Go diäär riɔ̈ɔ̈c ku gutkë kenhïïm piny. Go röör wën lueel tënë ke, “Yeŋö ye wek raan pïr bɛ̈n wïc tɛ̈n kɔc cï thou? ");
INSERT INTO dikNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Acïï tɔ̈ tɛ̈në, acï rot jɔt. Takkë këwäär cï lɛ̈k we ëlä wäär ŋoot yen Galilia, ");
INSERT INTO dikNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","lɔn Manh Raan abï thɔ̈n kɔc rɛc bïk piäät tim cï rïïu kɔ̈u, ku abï bɛn pïr aköl ye nïn diäk.” ");
INSERT INTO dikNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Go diäär wël wäär cï Jethu lɛ̈k ke tak. ");
INSERT INTO dikNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","10","Maria Magdalena, ku Joanan, ku Maria man Jemith ku diäär kɔ̈k, kek aake cï la raŋ nhom. Nawën dhukkë ke la kɔc Jethu buɔɔth kathiäär ku tök ku atuuc kɔ̈k, lɛ̈k kë cï rot looi. ");
INSERT INTO dikNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Go atuuc tak lɔn ë yen wɛ̈t lueth, ku cïk gam. ");
INSERT INTO dikNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Go Pïtɛr rot jɔt ku riŋ raŋ nhom bï la tïŋ. Nawën guŋ yekɔ̈u piny ku tïŋ raŋ yic, ke tïŋ alɛ̈th wäär cï guɔ̈p Jethu der kepɛ̈c. Go dhuk baai ke cï gäi aya kë cï rot looi. ");
INSERT INTO dikNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ya aköl töŋ awën, ke kɔc Jethu buɔɔth karou jɔt röt bïk la pan cɔl Emauth, ku ë mec kek Jeruthalem tɛ̈ cït kilomïter thiäär ku tök. ");
INSERT INTO dikNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Tɛ̈wën ciɛth kek ke jam ku takkë käk cï röt looi, ");
INSERT INTO dikNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ke Jethu bɔ̈ ku ciɛth ke kuany keyöth. ");
INSERT INTO dikNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ku mär këdäŋ kepuɔ̈th bïk cïï ŋic. ");
INSERT INTO dikNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Go Jethu ke thiëëc, “Yeŋö bakë lueel tɛ̈thɛɛr awën ciɛth wek?” Gokë kɔ̈ɔ̈c ku dötkë piny ke cï kenyïn wel. ");
INSERT INTO dikNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Go raan tök kamken cɔl Kliöpath wɛ̈tde bɛ̈ɛ̈r, “Adhil a yïn raan töŋ rɛ̈ɛ̈r Jeruthalem kuc käk cï röt looi thïn ye nïnkä yiic.” ");
INSERT INTO dikNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Go Jethu thiëc, “Ye käŋö?” Gokë bɛ̈ɛ̈r, “Aa käk cï röt looi tënë mony cɔl Jethu, raan Nadharet. Käk cï looi ku wël cï lueel aye nyuɔɔth lɔn ye yen raan ril käk Nhialic tïŋ. Ku acï Nhialic ku kɔc ëbën gam lɔn ril yen këriëëc ëbën yic ye lueel ku looi. ");
INSERT INTO dikNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Acï kɔckuan dït käk Nhialic ku kɔc piööc lööŋ dɔm ku gɛ̈mkë bäny mac baai bï tɛ̈m thou, ku piɛ̈ɛ̈tkë tim cï rïïu kɔ̈u. ");
INSERT INTO dikNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ku ë yeku ŋɔ̈ɔ̈th lɔn ye yen raan bï kɔc Itharel waar kärɛc yiic. Ku ë nïn kadiäk ëmën tɛ̈n looi käkkä röt. ");
INSERT INTO dikNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Diäär kɔ̈k akuɔ̈tda yic, aake cï riɛɛl raŋ nhom wën anhiäk, ku lek dhuk ke wɛ̈t cï ɣook bɛ̈n cɔl agɛ̈i lɔn liiu guäpde raŋ yic. Ku lɔn cï kek atuuc Nhialic cie lɛ̈k ke lɔn pïïr Jethu tïŋ. ");
INSERT INTO dikNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Go kɔc kɔ̈k kamkua riŋ bïk la tïŋ. Ku yökkë ayic lɔn liiu guɔ̈p Jethu raŋ yic, cït tɛ̈ cï diäär ye luɛɛl thïn.” ");
INSERT INTO dikNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Go Jethu lɛ̈k ke, “Wek aa kɔc cïn kë ŋiɛckë! Wek aacie käk cï kɔc käk Nhialic tïŋ lɛ̈k we ye lac gam! ");
INSERT INTO dikNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Këc kɔc käk Nhialic lueel wäär, lɔn bï Raan cï lɔc ku dɔc käjuëckä kaŋ guum bï jal la Bäänyde yic.” ");
INSERT INTO dikNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ku tët Jethu ke käk cï lueel riɛnke wël thɛɛr Nhialic yiic, jɔɔk athör Mothith agut käk cï kɔc käk Nhialic tïŋ gɔ̈t. ");
INSERT INTO dikNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nawën cïk thiɔ̈k kek pan awën le kek thïn, ke Jethu loi rot ke cït raan bɛr tueŋ. ");
INSERT INTO dikNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Gokë pëën ku luelkë, “Rɛ̈ɛ̈r ke ɣo, akɔ̈l acï cuɔl.” Go la baai ke ke. ");
INSERT INTO dikNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Tɛ̈wën cï kek nyuc bïk mïth, ke Jethu löm ayup ku dɔɔc ku bɛny yic, ku gɛ̈m ke. ");
INSERT INTO dikNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Nyin yic tɛ̈wën ke ŋickë ku mɛ̈r bïk cïï ben tïŋ. ");
INSERT INTO dikNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Gokë röt thiëëc ë röt, “Ɣo këc puɔ̈th ayum tɛ̈wën jiɛɛm yen kek ɣo, ku teet wël cï gɔ̈t thɛɛr tënë ɣo.” ");
INSERT INTO dikNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ku jɔtkë röt nyin yic ku dhukkë Jeruthalem. Ku yökkë kɔc Jethu buɔɔth kathiäär ku tök ku kɔc kɔ̈k ke cï kenhïïm mat, ku lëkkë ke, ");
INSERT INTO dikNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","“Bɛ̈ny acï rot jɔt ayic, ka cï rot nyuɔ̈th Pïtɛr.” ");
INSERT INTO dikNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ku jɔl kɔc wën bɔ̈ Emauth karou kë cï rot looi dhël yic teet, tɛ̈ cï kek bɛ̈ny ŋiɛc thïn wën bɛny yen ayup yic. ");
INSERT INTO dikNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Wën ŋot jiɛɛm kek, ke Bɛ̈ny bɔ̈ ku kɛ̈ɛ̈c kamken ku lueel, “Bï dɔ̈ɔ̈r arëër ke we.” ");
INSERT INTO dikNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Gokë pɛ̈k wei ku riɔ̈ɔ̈ckë ëbën ku takkë lɔn yen atiɛ̈p yen yekë tïŋ. ");
INSERT INTO dikNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Goke thiëëc, “Yeŋö riɔ̈ɔ̈c wek? Yeŋö ye wek diu lɔn cïï yen ye ɣa? ");
INSERT INTO dikNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Tiɛ̈ŋkë ɣacin! Ku tiɛ̈ŋkë ɣacök, ee ɣɛn ayic. Gatkë ɣa, ku abäk tïŋ rin atiɛ̈p acie la adiɔ̈ɔ̈ŋ ku yom cïmën ye wek ke tïŋ kek ɣa.” ");
INSERT INTO dikNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ku wën lueel yen kënë, ke nyuth yecin ku yecök ke. ");
INSERT INTO dikNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ku ŋot cïk gam, rin miɛt dïït cï kek puɔ̈th miɛt ku gäi dïït cï kek gäi. Go Jethu ke thiëëc, “Le miëth camkë tɔ̈ thïn?” ");
INSERT INTO dikNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Gokë gäm rɛ̈c cï tuak ");
INSERT INTO dikNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ku cuet ke dɛɛi kek ëbën. ");
INSERT INTO dikNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ku jɔl lɛ̈k ke, “Käkkä gup aa käk ca lɛ̈k we wäär ŋot rëër ɣɛn ke we, lɔn bï këriëëc ëbën cï gɔ̈t Löŋ Mothith yic, ku athör kɔc käk Nhialic tïŋ ku diɛt Nhialic yic aya ë riɛnkiɛ̈, aa dhil röt tiɛɛŋ tɛ̈den.” ");
INSERT INTO dikNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ku kony ke bïk wël thɛɛr Nhialic deet yiic, ");
INSERT INTO dikNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ku lëk ke, “Ayakë tïŋ tɛ̈ cï ye gät thïn lɔn Raan cï lɔc ku dɔc, ë bï gum ku jɔt rot raŋ yic aköl ye nïn diäk. ");
INSERT INTO dikNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ku acï wël cï gɔ̈t lueel aya lɔn dhil kɔc pinynhom ëbën, jɔɔk Jeruthalem lɛ̈k bïk kepuɔ̈th wɛ̈l Nhialic, bï käracken päl piny. ");
INSERT INTO dikNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Wek aacï käkkä tïŋ ke cï kenhïïm tiɛɛŋ. ");
INSERT INTO dikNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ku wek abï tuɔ̈c Wëi Nhialic wäär cï Wä lueel. Rɛ̈ɛ̈rkë geeu ɣet aköl bï riɛl nhial kënë bɛ̈n tënë we.” ");
INSERT INTO dikNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Nawën ke Jethu jiël ke ke ku lek Bethanï. Ku jɔt yecin nhial ku dɔɔc ke. ");
INSERT INTO dikNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Tɛ̈wën dɔɔc yen ke, ke jiël tënë ke ku jɔt ë nhial. ");
INSERT INTO dikNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Gokë door ku dhukkë Jeruthalem ke cï puɔ̈th miɛt. ");
INSERT INTO dikNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ku keek aake ye lac rëër Luaŋ Nhialic ke lec Nhialic.");
INSERT INTO dikNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Wäthɛɛr këc nhial ku piny cak, Wɛ̈t ë tɔ̈ thïn, ee rɛ̈ɛ̈r kek Nhialic, ku Wɛ̈t ë ye Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Wɛ̈t ë rɛ̈ɛ̈r kek Nhialic wäär cɛk käŋ. ");
INSERT INTO dikNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Käjuëc rɛ̈ɛ̈r nhial ku piny ëbën aake cak ë ye. Ku acïn käk tɔ̈ thïn këc ke cak ke yeen liu thïn. ");
INSERT INTO dikNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Kuat käk tɔ̈ thïn ëbën aa pïr yök tënë ye. Ku piɛ̈rde acï ruɛl gäm raan ëbën. ");
INSERT INTO dikNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Piɛ̈rde yen ë ruɛl dɛ̈p apɛi muɔ̈ɔ̈th yic, ku akëc lëu bï kuɔ̈m nyin piny. ");
INSERT INTO dikNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Nhialic ëcï atuɔ̈nyde tooc, raan cɔl Joon. ");
INSERT INTO dikNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Acï bɛ̈n bï kɔc bɛ̈n lɛ̈k bïk ruɛl ŋic. Acï bɛ̈n bï lɛ̈k ke bï raan ëbën wɛ̈t piŋ ku gɛm. ");
INSERT INTO dikNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yeen ëcie yen ruɛl, acï bɛ̈n bï kɔc bɛ̈n lɛ̈k ruɛl. ");
INSERT INTO dikNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ku Wɛ̈t yen ë ye ruɛl ayic, ruɛl cï bɛ̈n pinynhom tënë raan ëbën. ");
INSERT INTO dikNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Wɛ̈t ë tɔ̈ pinynhom, ku Nhialic ë cak piny ë ye, ku akëc kɔc pinynhom ŋic. ");
INSERT INTO dikNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Yeen acï bɛ̈n tënë käk ke cï cak, ku akëc kɔcken cï cak lor. ");
INSERT INTO dikNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ku acï kɔc abɛ̈k bɛ̈n lor ku gamkë wɛ̈tde, goke gäm riɛl bïk aa mïth Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Keek aacie mïth Nhialic cït tɛ̈ ye kɔc dhiëëth thïn, cïmën ye mïth la wun dhiëth ke. Ee Nhialic guɔ̈p yen ë Wunden. ");
INSERT INTO dikNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Wɛ̈t acï bɛ̈n a raan ku ciëŋ ke ɣo. Ku diɛɛkde acuk tïŋ, diik Wën töŋ Nhialic. Ku ë yen bïï yic, ku liɛr puɔ̈u Nhialic tënë ɣo. ");
INSERT INTO dikNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ku Joon acï tuɔ̈l ku lëk kɔc ë riɛnke ëlä, “Kënë yen ë raan wäär ye ɣɛn jam ë riɛnke, raan wäär ya lueel ëlä, ‘Yen abï lɔ̈k bɛ̈n ɣacök, ku adït tënë ɣa. Yeen ë rɛ̈ɛ̈r thïn wäär ke ɣa këc cak dhiëëth.’ ” ");
INSERT INTO dikNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Rin käpuɔth ë yen Wën Nhialic, yen acï ɣo dɔɔc ëbën, dɔ̈c tök ë dɔ̈c dɛ̈t cök. ");
INSERT INTO dikNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Wäthɛɛr löŋ ëcï Nhialic gäm kɔc ë Mothith, ku ëmën Nhialic acï yic ku liɛr piände gäm kɔc ë Jethu raan cï lɔc ku dɔc. ");
INSERT INTO dikNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Acïn raan cï Nhialic kaŋ tïŋ tɛ̈ɣɔn. Ee Wën töŋ thöŋ kek Nhialic, rɛ̈ɛ̈r Wun lɔ̈ɔ̈m yen acï ɣo cɔl aŋic Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Kɔcdït Itharel Jeruthalem aake cï kɔc käk Nhialic ku kɔc kuat Lebï tuɔɔc tënë Joon, bïk la thiëëc ëlä, “Ye yïn ŋa?” ");
INSERT INTO dikNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ku Joon akëc bɛ̈n jai bï wɛ̈tden dhuk nhom. Acï bɛ̈n bɛ̈ɛ̈r ë cök ku lueel ëlä, “Acie ɣɛn Raan cï lɔc ku dɔc.” ");
INSERT INTO dikNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Gokë thiëëc, “Aye yïn ŋa? Ee yïn Elija?” Go bɛ̈ɛ̈r, “Acie ɣa.” Gokë bɛn thiëëc, “Ye yïn raandït käk Nhialic tïŋ bï bɛ̈n?” Go dhuɔ̈k ke, “Ɣei! Acie ɣa.” ");
INSERT INTO dikNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Gokë lueel, “Lɛ̈k ɣo, ee yïn ŋa? Ɣok aa dhil wɛ̈t dhuɔ̈k kɔc ke toc ɣo. Ye rot yök ë yïn ŋa?” ");
INSERT INTO dikNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Go Joon bɛ̈ɛ̈r, “Ɣɛn ë jam apɛi roor tɛ̈ cïï ceŋ, ‘Guiɛrkë dhël Bɛ̈ny bï la cök cïmën wäär cï Ithaya raan käk Nhialic tïŋ ye lueel.’ ” ");
INSERT INTO dikNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Röörkä aake tooc kɔc akut Parathï, ");
INSERT INTO dikNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ku jɔlkë Joon bɛ̈n thiëëc ëlä, “Yeŋö ë yïn kɔc muɔɔc nhïïm tɛ̈ cïï yïn ye Raan cï lɔc ku dɔc, ku yïn acie Elija ku cïï ye raandït käk Nhialic tïŋ?” ");
INSERT INTO dikNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Go Joon dhuɔ̈k ke, “Ɣɛn ë kɔc muɔɔc nhïïm pïu ë path, ku raan arɛ̈ɛ̈r kamkun ë tɛ̈n ku acäk ŋic, ");
INSERT INTO dikNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","raan yen lök bɛ̈n ɣacök ciëën, ku acä lëu ba warke dɔ̈k.” ");
INSERT INTO dikNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Kën ë loi rot pan cɔl Bethanï, wär Jordan kɔ̈u tɛ̈wäär ye Joon kɔc muɔɔc nhïïm thïn. ");
INSERT INTO dikNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Naɣɔn aköl dɛ̈t ke Joon tïŋ Jethu ke bɔ̈ tënë ye, go lueel, “Tiɛ̈ŋkë Amälthiin Nhialic yen bä adumuɔ̈ɔ̈m kɔc pinynhom nyaai, kan abɔ̈. ");
INSERT INTO dikNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Yen ë raan ye ɣɛn jam ë riɛnke wäär ë ɣɛn ye lueel ëlä, ‘Yen abï lɔ̈k bɛ̈n ɣacök, ku adït tënë ɣa. Yeen ë rɛ̈ɛ̈r thïn wäär ke ɣa këc cak dhiëëth.’ ");
INSERT INTO dikNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Aacä ŋic bï ya yen ŋa, ku ɣɛn acï bɛ̈n ku ya kɔc muɔɔc nhïïm pïu rin bï ɣɛn ye cɔl aŋic kɔc Itharel.” ");
INSERT INTO dikNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ku ëcï Joon lueel aya ëlä, “Ɣɛn acï Wëi Nhialic tïŋ ke bɔ̈ kecït kuur ë dit, ku nyuuc yenhom. ");
INSERT INTO dikNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ku ë ŋot kɛ̈c ŋic, ku ëcï Nhialic raan toc ɣa ba kɔc aa muɔɔc nhïïm pïu, lɛ̈k ɣa ëlä, ‘Raan bï yïn Wëi Nhialic tïŋ ke bɔ̈ ku nyuuc yenhom yen ë raan bï kɔc muɔɔc nhïïm Wëi Nhialic.’ ");
INSERT INTO dikNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ee yic, aca tïŋ ku alɛ̈u ba lueel, wenhïïm lɔn ë yen Wën Nhialic.” ");
INSERT INTO dikNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ɣɔn aköl dɛ̈t, Joon ë kääc kek kɔcken ye buɔɔth karou tɛ̈wäär aköl. ");
INSERT INTO dikNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Nawën tïŋ Jethu ke tëk tɛ̈thiɔ̈k ke ke, go Joon döt apɛi ku lueel, “Tiɛ̈ŋkë, yen akan yen Amäl Nhialic.” ");
INSERT INTO dikNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ku jɔl piŋ kɔc ye buɔɔth awën karou këya, gokë Jethu buɔɔth. ");
INSERT INTO dikNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Nawën wel Jethu yenhom, ke tïŋ ke ke buɔth ye, go ke thiëëc, “Yeŋö wiɛ̈ckë?” Gokë lueel, “Rabi, rɛ̈ɛ̈r tɛ̈nɛn?” (Ku wɛ̈tde yic, “Raan Piööc.”) ");
INSERT INTO dikNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Go lɛ̈k ke, “Bäk, bäk bɛ̈n tïŋ.” Gokë la ku tïŋkë tɛ̈ rëër yen thïn. Ku ë ye tääŋ akɔ̈l, ku jɔlkë rëër kek ye abï piny cuɔl. ");
INSERT INTO dikNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Raan tök kam kɔc wën karou cï wɛ̈t Joon piŋ ku buɔɔth Jethu, ee ye Andria wämënh Thaimon Pïtɛr. ");
INSERT INTO dikNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Naɣɔn nhiäk rial, ke Andria räm ke mɛ̈nhë, go lɛ̈k ye, “Ɣok aacï Methaya yök.” (Ku wɛ̈tde yic Raan cï lɔc ku dɔc.) ");
INSERT INTO dikNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ku ɣɛ̈th Thaimon tënë Jethu. Go Jethu döt apɛi ku lueel, “Yïn ë Thaimon wën Joon, yïn abï cɔl Kepa.” (Ku yen Pïtɛr wɛ̈tde yic ee kuur.) ");
INSERT INTO dikNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Nawën aköl dɛ̈t ke Jethu la Galilia, ke räm kek Pilipo, go lɛ̈k ye, “Buɔth ɣa.” ");
INSERT INTO dikNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ku Pilipo ë raan Bethaida, ku ë gen yï Andria ku Pïtɛr aya. ");
INSERT INTO dikNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Go Pilipo Nathaniel yök ku lëk ye, “Ɣok aacï raan wäär cï Mothith gät ë riɛnke athör lööŋ yic, raan yen cï kɔc käk Nhialic tïŋ gät ë riɛnke aya, acuk yök. Yen ë Jethu wën Jothep raan Nadharet.” ");
INSERT INTO dikNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Go Nathaniel lueel, “Ye këpiath ŋö lëu bï tuɔ̈l Nadharet?” Go Pilipo bɛ̈ɛ̈r, “Bäär ba tïŋ.” ");
INSERT INTO dikNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nawën tïŋ Jethu Nathaniel ke bɔ̈, ke jam rin Nathaniel ku lueel, “Raan kënë ë raan Itharel ayic guɔ̈p, kecïn guɔ̈p ruëëny.” ");
INSERT INTO dikNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Go Nathaniel lueel, “Ca ŋic këdë?” Go Jethu bɛ̈ɛ̈r, “Yïn guɔ ŋic wën rëër yïn ŋaap cök, tɛ̈wën këc Pilipo la bï yï la cɔɔl.” ");
INSERT INTO dikNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Go Nathaniel bɛ̈ɛ̈r ku lueel, “Raan piööc, yïn ë Wën Nhialic, yïn ë Bɛ̈ny Itharel.” ");
INSERT INTO dikNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Go Jethu bɛ̈ɛ̈r, “Ca jäl gam rin cï ɣɛn ye lɛ̈k yï lɔn cï ɣɛn yï tïŋ wën rëër yïn ŋaap cök? Yïn abï kädït kɔ̈k wär ë käkkä tïŋ!” ");
INSERT INTO dikNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ku ben mat thïn, “Wɛ̈t yic alɛ̈k we, wek aabï nhial tïŋ ke liep rot, ku atuuc Nhialic aa bäk tïŋ ke bɔ̈ piny tënë Manh Raan ku lek nhial.” ");
INSERT INTO dikNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Nïn kadiäk cök ciëën, ke ruääi loi gen Kana pan Galilia. Ku man Jethu ë tɔ̈ thïn, ");
INSERT INTO dikNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ku Jethu ëcï cɔɔl yai yic aya kek kɔcken ye buɔɔth. ");
INSERT INTO dikNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Nawën la mɔ̈u thök, ke lëk man ye, “Mɔ̈u acï liu tënë ke.” ");
INSERT INTO dikNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Go Jethu lueel, “Tiŋë, yïn acïï kë luɔɔi dhil lɛ̈k ɣa. Akäldiɛ̈ aŋot këc ɣëët.” ");
INSERT INTO dikNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Go man lɛ̈k kɔc luɔi, “Luɔikë käk bï lɛ̈k we ëbën.” ");
INSERT INTO dikNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ku tönydït kadätem aake cäp kɔc lɔ̈m. Tönykä aake ye ke pïu tääu thïn bï kɔc kecök aa lɔɔk, cït tɛ̈ ye löŋ ciɛɛŋ kɔc Itharel ye nyuɔɔth thïn. Ku tɔ̈ɔ̈ny tök ë jɔt tɛ̈ cït tɛ̈n aduɔ̈k thiär-rou, tɛ̈dë aduɔ̈k thiärdiäk. ");
INSERT INTO dikNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Go Jethu lɛ̈k kɔc luɔi, “Thiäŋkë tönykä pïu.” Gokë töny thiɔ̈ɔ̈ŋ abïk thook alic. ");
INSERT INTO dikNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ku jɔl Jethu lɛ̈k ke, “Gɛ̈mkë ye tönykä yiic, ku gämkë ke raan yen wun ruääi.” Gokë looi këya, ");
INSERT INTO dikNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ku jɔl raandït kɔc athiɛ̈k awën pïu thiëëp, pïu cï waar bï ya mɔ̈u. Ku akuc tɛ̈ bïï mɔ̈u thïn, aa kɔc luɔi wën thiɔ̈ŋ töny kek aa ŋic ye. Go raandït kɔc athiɛ̈k wun nya cɔɔl, ");
INSERT INTO dikNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ku lëk ye, “Raan ëbën ë muɔ̈n path kaŋ gam tueŋ, ku na cï kɔc jäl kuɛth ke muɔ̈n lir ajɔl lɔ̈k gam. Ku yïn cï muɔ̈n path waan ciëën agut ëmën.” ");
INSERT INTO dikNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Kënë yen ë këdït jäŋ gɔ̈i cï Jethu kaŋ looi gen Kana pan Galilia. Ku yen acï diɛ̈tde nyuɔɔth, ku aacï kɔcken ye buɔɔth jäl gam. ");
INSERT INTO dikNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Nawën ë kënë cök, ke Jethu la Kapernaum kek man ku wɛ̈ɛ̈t wun ku kɔcken ye buɔɔth, ku rëërkë thïn ë tɛ̈ɛ̈n nïn lik. ");
INSERT INTO dikNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ɣɔn cï Yan Ayum cïn yic luɔu jäl thiɔ̈k, ke Jethu la Jeruthalem. ");
INSERT INTO dikNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ku jɔl ler kal luaŋ Nhialic yic, ke yök kɔc ke ɣɔɔc wei thïn ë ɣɔ̈k ku amɛ̈l ku jɔl aa kuɔ̈r. Ku kɔc wëëu waar yiic aake cï nyuc thïn aya. ");
INSERT INTO dikNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Go waat nai ë wiɛ̈n, ku cop kɔc wei kal luaŋ Nhialic yic kek ɣäkken ku thäkken ku weer wëëu wei, ku wel agɛnken yiic. ");
INSERT INTO dikNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ku lëk kɔc kuɔ̈r ɣaac wei, “Nyaaikë käkkä ë tɛ̈n, ku duɔ̈kkë ɣön Wä cɔl aye ɣön ɣɔɔc.” ");
INSERT INTO dikNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Go kɔcken ye buɔɔth wël cï gɔ̈t athör thɛɛr wël Nhialic yic tak. Wël ye lueel ëlä, “Yïn Nhialic, nhiɛ̈r ɣɔ̈ndu adɛ̈p ɣapuɔ̈u cïmën mac.” ");
INSERT INTO dikNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Go kɔcdït Itharel bɛ̈n ku thiëckë, “Ye këdït jäŋ gɔ̈i yïndë ba looi ba nyuɔ̈th ɣo, lɔn le yïn yic ba këcït kënë looi?” ");
INSERT INTO dikNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Go Jethu bɛ̈ɛ̈r ku lëk ke, “Rackë luaŋ Nhialic kënë, ku aba bɛn looi nïn kadiäk.” ");
INSERT INTO dikNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Gokë lueel, “Acï ruɔ̈ɔ̈n thiärŋuan ku dätem nɔ̈k bï jäl thök, ku luel ka ba looi nïn kadiäk yiic?” ");
INSERT INTO dikNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ku luaŋ Nhialic jiɛɛm Jethu ë guäpde. ");
INSERT INTO dikNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ku na wäär la jɔt raŋ yic, ke kɔcken ye buɔɔth tak këwäär cï lueel. Ku gamkë wël thɛɛr Nhialic cï gɔ̈t, ku wël cï Jethu lɛ̈k kɔc. ");
INSERT INTO dikNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Tɛ̈wäär rëër yen Jeruthalem yai yic, ke kɔc juëc gam wɛ̈tde wën tïŋ kek käkken jäŋ gɔ̈i cï looi. ");
INSERT INTO dikNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ku aake ŋic Jethu ëbën ku yen akëc rot nyuɔ̈th ke. ");
INSERT INTO dikNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ku acïn kën nadë ke wïc raan dɛ̈t bï ye nyuɔ̈th kɔc, rin aŋic käk tɔ̈ raan puɔ̈u. ");
INSERT INTO dikNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Raan akut Parathï cɔl Nikodemo, ku ë ye raandït kɔc Itharel ë tɔ̈ thïn, ");
INSERT INTO dikNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","naɣɔn akɔ̈u wɛ̈ɛ̈r tök ke la tënë Jethu ku lueel, “Raan piööc, aŋicku yïn ë raan piööc cï Nhialic tooc. Rin acïn raan loi käk jäŋ gɔ̈i cïmën yïn, tɛ̈ liu Nhialic kek ye.” ");
INSERT INTO dikNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Go Jethu bɛ̈ɛ̈r, “Yïn alɛ̈k yic, acïn raan bï bääny Nhialic tïŋ, tɛ̈ cïï ye ben dhiëëth dhiën dɛ̈t.” ");
INSERT INTO dikNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Go Nikodemo lueel, “Bï raan bɛn dhiëëth këdë? Lëu bï dhuk man yäc bï jäl bɛn dhiëëth?” ");
INSERT INTO dikNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Go Jethu bɛ̈ɛ̈r, “Wɛ̈t yic alɛ̈k yï, raan këc bɛn dhiëëth ë pïu ku Wëi Nhialic, acïï bääny Nhialic bï yök. ");
INSERT INTO dikNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Raan aye dhiëëth kɔc ë path, ku Wëi Nhialic ë pïr yam ye Nhialic gäm kɔc. ");
INSERT INTO dikNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Duk ye gäi tɛ̈ lëk ɣɛn yï, lɔn dhil we bɛn dhiëëth. ");
INSERT INTO dikNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Wëi Nhialic acït mën dhie ye raan yom piŋ ke wuu, ku cïï tɛ̈ bïï yen thïn ku tɛ̈ le yen thïn ŋic. Yen ë tɛ̈n kɔc bï bɛn dhiëëth Wëi Nhialic.” ");
INSERT INTO dikNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Go Nikodemo thiëc, “Bï kënë rot lëu këdë?” ");
INSERT INTO dikNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Go Jethu lɛ̈k ye, “Yïn ë raan piööc kɔc pan Itharel ku kuc kënë! ");
INSERT INTO dikNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Wɛ̈t yic alɛ̈k yï, ɣok aa jam käk ŋicku ku luelku käk cuk tïŋ. Ku ŋot we jɛi bäk wɛ̈tda cïï gam. ");
INSERT INTO dikNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Na cäk wɛ̈tdiɛ̈ gam tɛ̈ jiɛɛm ɣɛn käk pinynhom, ke we bï wɛ̈tdiɛ̈ gam këdë tɛ̈ jiɛɛm ɣɛn tënë we käk Nhialic? ");
INSERT INTO dikNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Acïn raan cïï kaŋ la nhial bï käk Nhialic bɛ̈ɛ̈i, ee raan bɔ̈ nhial Manh Raan bɔ̈ piny nhial.” ");
INSERT INTO dikNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Cïmën wäär cï Mothith luŋ wëëth cït këpiiny jat nhial roor bï yen kɔc cï këpiiny cam aa dɔɔc, ke Manh Raan adhil ɣäth nhial, ");
INSERT INTO dikNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","rin bï raan gam wɛ̈tde ëbën pïr akölriëëc ëbën yök. ");
INSERT INTO dikNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Nhialic anhiar kɔc pinynhom apɛi. Yen agɛm yen Wënden juɔ̈l, bï raan ëbën wɛ̈tde gam cïï mär, ku pïïrkë akölriëëc ëbën. ");
INSERT INTO dikNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ku Nhialic akëc Wënde tuɔ̈ɔ̈c piny bï kɔc bɛ̈n luɔ̈k wei, ee rin bï thäi pinynhom pïr ë riɛnke. ");
INSERT INTO dikNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Raan gam wɛ̈tde acïï bï luɔ̈k wei, ku raan cï jai bï wɛ̈t cïï gam acï luɔ̈k wei, rin këc yen wɛ̈t Wën tööŋ ë Nhialic gam. ");
INSERT INTO dikNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ku kën bï ke luɔ̈k wei akïn, ruɛl acï bɛ̈n pinynhom ku kɔc aa nhiar muɔ̈ɔ̈th tɛ̈n ruɛl rin aa luui kärɛc. ");
INSERT INTO dikNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Raan ëbën kärɛc looi ë ruɛl maan ku cïï la ɣɛr yic, rin cïï yen kärɛc ye looi wïc bï ke ŋic. ");
INSERT INTO dikNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ku raan luui käpath ë bɛ̈n ɣɛr yic bï luɔide nyuɔɔth, rin cï ke luɔ̈i Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Nawën ke Jethu kek kɔcken ye buɔɔth la pan Judia, ku rëër thïn ke ke, ku muɔɔc kɔc nhïïm pïu. ");
INSERT INTO dikNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ku Joon ë ye kɔc muɔɔc nhïïm aya tɛ̈ cɔl Aenon thiääk kek Thalim la yic pïu juëc. Ku kɔc aake ye la bï ke la muɔɔc nhïïm. ");
INSERT INTO dikNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Ku Joon ë ŋot këc guɔ mac.) ");
INSERT INTO dikNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Nawën ke kɔc Joon buɔɔth kɔ̈k jɔl teer kek raan Itharel rin lɔ̈k ye kɔc kegup lɔɔk, ");
INSERT INTO dikNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","gokë la tënë Joon ku luelkë, “Raan piööc, lëu ba mony wäär rɛ̈ɛ̈r kek yï wär Jordan alɔŋtui tak, raan ye yïn jam ë riɛnke? Yen amuɔc kɔc nhïïm ëmën, ku kɔc juëc aala tënë ye!” ");
INSERT INTO dikNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Go Joon bɛ̈ɛ̈r, “Acïn tɛ̈ bï raan këdäŋ yök tɛ̈ këc Nhialic ye gäm ye. ");
INSERT INTO dikNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Week wepɛ̈c acäk piŋ ke lɛ̈k we ëlä, ‘Ɣɛn acie Raan cï lɔc ku dɔc, ku ɣɛn acï tuɔ̈ɔ̈c tueŋ ë path yenhom.’ ");
INSERT INTO dikNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Raan thiëk yen ë raan bï gäm nya, ku mäthde ë kɔ̈ɔ̈c ku ë puɔ̈u miɛt tɛ̈ piŋ yen rɔ̈lde. Yen ë miɛt piändiɛ̈ aya ëmën. ");
INSERT INTO dikNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yen abï dhiɛl dït apɛi ku ɣɛn abï kuur.” ");
INSERT INTO dikNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Raan bɔ̈ nhial adït tënë kɔc ëbën, ku raan piiny ë kën piny. Raan bɔ̈ nhial atɔ̈ kɔc nhïïm tueŋ ëbën. ");
INSERT INTO dikNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ee kɔc lɛ̈k käk cï tïŋ ku käk cï piŋ, ku acïn raan wɛ̈tde gam. ");
INSERT INTO dikNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ku raan cï gam, acï gam lɔn ye Nhialic yic lueel. ");
INSERT INTO dikNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Raan cï Nhialic tooc yen ë jam wël Nhialic, rin aye Nhialic gäm riɛl Wɛ̈ike ëbën. ");
INSERT INTO dikNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Wun ë Wënde nhiaar ku tɛ̈ɛ̈u këriëëc ëbën yecin. ");
INSERT INTO dikNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Raan gam wɛ̈t Wën ë Nhialic abï pïr akölriëëc ëbën, ku raan cïï wɛ̈t Wën Nhialic bï gam acïï pïr akölriëëc ëbën bï yök, rin acïn kë bï riääk puɔ̈u ë Nhialic nyaai tënë ye. ");
INSERT INTO dikNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Nawën ke ŋic Jethu lɔn cï kɔc akut Parathï ye piŋ, lɔn nadë ke kɔc aa bɛ̈n tënë ye bï ke bɛ̈n muɔɔc nhïïm, ku lɔn cï yen la kɔc juëc ye buɔɔth wär kɔc Joon buɔɔth. ");
INSERT INTO dikNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Ku acie yen ye kɔc muɔɔc nhïïm, aa kɔcken ye buɔɔth.) ");
INSERT INTO dikNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Nawën piŋ wɛ̈t ye lueel, go jäl pan Judia ku dhuk Galilia. ");
INSERT INTO dikNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ku ë bï dhiɛl ɣet pan Thamaria rin yen ë dhël tëëk yen thïn. ");
INSERT INTO dikNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Go ɣet pan Thamaria cɔl Thikar thiääk ke piny wäär cï Jakop gäm wënde Jothep. ");
INSERT INTO dikNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ku yinh cï Jakop cɔl awec ë tɔ̈ thïn. Nawën cï Jethu dak ë cäth, go nyuc yith lɔ̈ɔ̈m. Ku ë ye akɔ̈l ciɛl yic. ");
INSERT INTO dikNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Go tiŋ pan Thamaria bɛ̈n yiith bï bɛ̈n gem pïu, go Jethu lɛ̈k ye, “Muɔc ɣɛn pïu ba dek.” ");
INSERT INTO dikNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Ku kɔcken ye buɔɔth aake cï la geeu bïk la ɣɔɔc miëth.) ");
INSERT INTO dikNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Go tiŋ pan Thamaria lɛ̈k ye, “Këdë wën? Yïn ë raan Itharel ku thiëc ɣa, ɣɛn raan Thamaria ba yï muɔɔc ë pïu?” (Kɔc Itharel aake cie dek kek kɔc Thamaria.) ");
INSERT INTO dikNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Go Jethu bɛ̈ɛ̈r, “Na yï ŋic miɔ̈c Nhialic ku raan thiëc yï pïu ŋuɔ̈t aca thiëëc, ku ŋuɔ̈t acï muɔɔc pïu pïr.” ");
INSERT INTO dikNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Go tik lueel, “Bɛ̈ny, yïn acïn kë gem yïn pïu, ku yith amec yic, ba pïu pïr yök tɛ̈nɛn? ");
INSERT INTO dikNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ye yïn dït tënë wädït Jakop raan cï ɣo gäm yinh kënë, ku dëk thïn yen ye nhom kek miɛ̈thke ku ɣäkke?” ");
INSERT INTO dikNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Go Jethu bɛ̈ɛ̈r, “Kuat raan dek pïukä abï rou bɛn nɔ̈k, ");
INSERT INTO dikNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ku raan bï dek pïu ba yiëk ye acïï rou bï bɛn nɔ̈k, ku pïu bï yiëk ye aabï ya dhiama yeyic ye pïu pïr kuër thïn, ku yïk ye pïr alanden.” ");
INSERT INTO dikNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Go tik lɛ̈k ye, “Bɛ̈ny, yiëk ɣɛn pïukä bï rou ɣa cïï ben nɔ̈k, ba cïï ben bɛ̈n tɛ̈n ba bɛ̈n gem pïu.” ");
INSERT INTO dikNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Go Jethu lɛ̈k ye, “Lɔɔr cɔl muɔnydu bäk bɛ̈n tɛ̈n.” ");
INSERT INTO dikNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Go tik lueel, “Ɣɛn acïn moc.” Go Jethu bɛ̈ɛ̈r, “Këdu ë yic, lɔn cïn yïn moc. ");
INSERT INTO dikNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Yïn acï kaŋ rëër kek röör kadhiëc, ku mony rɛ̈ɛ̈r kek yï ëmën acie muɔnydu. Yïn acï yic lueel.” ");
INSERT INTO dikNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Go tik lueel, “Bɛ̈ny aca ŋic, yïn ë raan käk Nhialic tïŋ. ");
INSERT INTO dikNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Wärkuan thɛɛr pan Thamaria aake ye Nhialic door ë gɔn kënë nhom, ku ayakë lueel wek kɔc Itharel lɔn dhil ɣok Nhialic la door Jeruthalem.” ");
INSERT INTO dikNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Go Jethu lueel, “Gam wɛ̈tdiɛ̈, yïn tiŋë tɛ̈ bï wek Wä door acï thiɔ̈k, ku acie gɔn kënë nhom ku acie Jeruthalem. ");
INSERT INTO dikNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Wek kɔc Thamaria wek kuc raan yakë door, ku ɣok kɔc Itharel ɣok aa ŋic raan yeku door rin pïr abɔ̈ tënë Itharel. ");
INSERT INTO dikNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ku akɔ̈l ajɔl bɛ̈n, ku acï guɔ bɛ̈n ëmën guɔ̈p, tɛ̈ bï riɛl Wëi Nhialic kɔc cɔl aa dor Wä cïmënde, kek aa kɔc wïc Wä bïk ye door. ");
INSERT INTO dikNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Nhialic ë Wëi, ku rin riɛl Wɛ̈ike yen alëu ye bï door cïmënde.” ");
INSERT INTO dikNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Go tik bɛn lɛ̈k ye, “Aŋiɛc lɔn bï Raan cï lɔc ku dɔc bɛ̈n. Na le bɛ̈n ka bï ɣo nyuɔ̈th këriëëc ëbën.” ");
INSERT INTO dikNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Go Jethu bɛ̈ɛ̈r, “Yen ë ɣɛn, raan jam kek yï.” ");
INSERT INTO dikNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ku kaamthiin wën jiɛɛm kek, ke kɔcken ye buɔɔth bɔ̈ ku gɛ̈ikë apɛi rin jiɛɛm yen kek tik. Ku acïn raan tök kamken cï tik thiëëc, “Yeŋö wïc, ku yeŋö jiɛɛm yen kek ye?” ");
INSERT INTO dikNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Go tik tönyden pïu nyääŋ piny, ku kɛt ke dhuk geeu ku lëk kɔc. ");
INSERT INTO dikNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Bäk tiɛ̈ŋkë mony cä lɛ̈k këriëëc ëbën ca looi. Nadë ke ye Raan cï lɔc ku dɔc?” ");
INSERT INTO dikNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Gokë bɛ̈n bei geeu bïk la tënë Jethu. ");
INSERT INTO dikNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ku kaamthiin wën, ke lëk kɔcken ye buɔɔth ye, “Raan piööc, jɔl mïth.” ");
INSERT INTO dikNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Go bɛ̈ɛ̈r, “Ɣɛn ala miëth, cïn kë ŋiɛckë thïn.” ");
INSERT INTO dikNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Go kɔcken ye buɔɔth röt jal aa thiëëc kamken, “Tɛ̈dë le raan cï miëth bɛ̈ɛ̈i tënë ye?” ");
INSERT INTO dikNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Go Jethu lɛ̈k ke, “Miëthdiɛ̈ ee lɔn ba wɛ̈t raan toc ɣɛn looi, ku thääp luɔi cï gäm ɣa. ");
INSERT INTO dikNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Cäk kääŋ ye lueel dhie ëlä, ‘Pɛ̈i kaŋuan aŋoot ku rap abï tem.’ Ku alɛ̈k we, jatkë wenyïn bäk dum tïŋ, yemën rap aacï luɔk ku apath bï ke tem! ");
INSERT INTO dikNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Raan rap tem aye riɔp ku ë kɔ̈th pïr tem alanden, këya raan cumcum ku raan tëmtëm aabï puɔ̈th miɛt kedhie. ");
INSERT INTO dikNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kääŋ acï ya yic. ‘Raan tök ë com ku tëm raan dɛ̈t.’ ");
INSERT INTO dikNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Wek tuɔɔc bäk rap la tem dom yic ku ë dom këc wek luui thïn. Kɔc kɔ̈k aacï luui thïn ku wek aa röt kony luɔiden.” ");
INSERT INTO dikNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Go kɔc juëc Thamaria ë gen wën yic wɛ̈t Jethu gam, rin cï tik wɛ̈t lueel ëlä, “Këriëëc ëbën ca looi acï lɛ̈k ɣa.” ");
INSERT INTO dikNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Nawën bɔ̈ kɔc Thamaria tënë ye ke läŋkë bï rëër ke ke. Go Jethu nïn karou nɔ̈k thïn tɛ̈ɛ̈n. ");
INSERT INTO dikNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Go kɔc kɔ̈k juëc wɛ̈tde jäl gam rin wël ye lɛ̈k ke, ");
INSERT INTO dikNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ku lëkkë tik, “Ëmën, ɣok aacï wɛ̈t jäl gam, ku akëcku gam rin wëlkun ca lueel, ku ë rin cï ɣok wɛ̈tde piŋ ku ŋicku lɔn ë yen Aluäŋ kɔc pinynhom ëbën alanden.” ");
INSERT INTO dikNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Nawën cï nïn karou nɔ̈k thïn tɛ̈ɛ̈n, ke Jethu jɔl jäl ku ler lɔŋ Galilia. ");
INSERT INTO dikNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Rin yen Jethu guɔ̈p ëcï lueel lɔn, “Raan käk Nhialic tïŋ acie theek wuɔ̈nden.” ");
INSERT INTO dikNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Nawën ɣeet Galilia ke lor apɛi, rin wäär cï kek käk cï Jethu looi yai yic tïŋ, wäär cï kek la Yan Ayum cïn yic luɔu yic Jeruthalem. ");
INSERT INTO dikNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Go Jethu bɛn dhuk gen Kana tɔ̈ Galilia, tɛ̈wäär cï yen pïu waar thïn bï ya muɔ̈n abiëc. Ku raandït kam kɔc mac baai cï manhde tuaany Kapernaum ë tɔ̈ thïn. ");
INSERT INTO dikNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Nawën piŋ lɔn cï Jethu jäl Judia ku ben dhuk Galilia, ke la tënë ye ku lɛ̈ŋ bï la Kapernaum bï manhden cï thiɔ̈k ke thou kony bï pial. ");
INSERT INTO dikNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Go Jethu lɛ̈k ye, “Acïn raan bï ye gam kamkun tɛ̈ këc wek kït ku kädït jäŋ gɔ̈i tïŋ.” ");
INSERT INTO dikNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Go raandït awën bɛ̈ɛ̈r ku lueel, “Bɛ̈ny, bäär lokku ba manhdiɛ̈ dööt.” ");
INSERT INTO dikNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Go Jethu lɛ̈k ye, “Lɔɔr, manhdu abï pïr.” Go mony wën wɛ̈t Jethu gam ku jiël. ");
INSERT INTO dikNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Wën ciɛth yen dhël yic, ke räm kek kɔcken luɔi ku luelkë, “Manhdu acï ɣɔ̈r.” ");
INSERT INTO dikNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Go ke thiëëc akɔ̈l alɔŋ jɔl manhde ŋuɛ̈ɛ̈n. Gokë lueel, “Wäraköl tääŋ akɔ̈l yen ë jiël juäi yeguɔ̈p.” ");
INSERT INTO dikNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Go wun ŋic lɔn ë yen akɔ̈l alɔŋ wäär cï Jethu ye lɛ̈k ye ëlä, “Manhdu abï pïr.” Ku jɔl wɛ̈t Jethu gam kek kacke ëbën. ");
INSERT INTO dikNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Kënë, yen aye kädït jäŋ gɔ̈i cï Jethu looi rou, wäär le yen dhuk Judia ku ler Galilia. ");
INSERT INTO dikNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Nawën ke yan kɔc Itharel ë tɔ̈ thïn, go Jethu la Jeruthalem yai yic. ");
INSERT INTO dikNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ku tɛ̈thiääk kek tɛ̈ cɔl Kal Amɛ̈l Thok, pul ë tɔ̈ thïn, pul cɔl Bethaida thoŋ kɔc Itharel. ");
INSERT INTO dikNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ku kɔc juëc tuany aake ye tɔ̈c thïn, kɔc cï cɔɔr ku kɔc cï ŋɔl ku kɔc cï duany. Ku keek aake ye pïu tiit bïk la tiaktiak, ");
INSERT INTO dikNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","rin atuny Nhialic ë ye bɛ̈n pul yic, ku cɔl pïu ala tiaktiak, ku raan cï kaŋ la wïïr tɛ̈ cï pïu röt tiak, ke kony kuat tuɛny tɔ̈ yeguɔ̈p. ");
INSERT INTO dikNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ku raan tuany ruɔ̈ɔ̈n thiärdiäk ku bɛ̈t ë tɔ̈ thïn. ");
INSERT INTO dikNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Nawën tïŋ Jethu puɔk yic ke cï tɔ̈c, ku aŋic lɔn cï ye tuaany run juëc, go thiëëc, “Wïc ba pial?” ");
INSERT INTO dikNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Go raan tuany bɛ̈ɛ̈r, “Bɛ̈ny, acïn raandiɛ̈n tɔ̈ tɛ̈n bï ɣa ɣäth wïïr tɛ̈ tiak pïu röt thïn, rin na thɛm ba la thïn, ke raan dɛ̈t ë kaŋ wɛ̈r thïn.” ");
INSERT INTO dikNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Go Jethu lɛ̈k ye, “Jɔt rot ku löm biɔ̈ŋdu ku cathë.” ");
INSERT INTO dikNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Go raan wën guɔ pial ku kuɛny biɔ̈ŋde ku ciɛth. Ku aköl looi kën rot ë ye aköl cïï kɔc Itharel ye luui, ");
INSERT INTO dikNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","go kɔc Itharel lɛ̈k mony cï kony, “Yaköl, aköl cïï kɔc ye luui, ku akëc puɔ̈l tënë yï ba biɔ̈ŋdu ket.” ");
INSERT INTO dikNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Go bɛ̈ɛ̈r, “Acï raan cä kony ba pial lɛ̈k ɣa ëlä, ‘Löm biɔ̈ŋdu ku cathë.’ ” ");
INSERT INTO dikNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Gokë thiëëc, “Yeŋa yen raan cï lɛ̈k, ‘Löm biɔ̈ŋdu ku cathë?’ ” ");
INSERT INTO dikNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ku raan cï kony ë kuc raan kony ye, rin kɔc juëc aake tɔ̈ ë tɛ̈wën ku Jethu ëcï la liɛpläŋ wei. ");
INSERT INTO dikNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Nawën ke yök Jethu luaŋ Nhialic, go lɛ̈k ye, “Tïŋ yïn acï pial ëmën, päl adumuɔ̈ɔ̈m, tɛ̈dɛ̈t ke këdɛ̈t rac apɛi abï röt bɛn luɔ̈i yï.” ");
INSERT INTO dikNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Go mony wën jäl ku le lɛ̈k bäny Itharel lɔn ë Jethu yen acï ye kony bï pial. ");
INSERT INTO dikNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Gokë jɔɔk bïk Jethu aa jöör rin cï yen raan kony aköl cïï kɔc ye luui. ");
INSERT INTO dikNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Go Jethu bɛ̈ɛ̈r tënë ke ëlä, “Wä ë luui akölaköl, ku ɣɛn adhil luui aya.” ");
INSERT INTO dikNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ku jam kënë acï bäny Itharel rac puɔ̈th apɛi, ku wïckë bïk nɔ̈k, ku acie rin cï yen löŋ aköl cïï kɔc ye luui thoŋ rot, ee rin cï yen ye lueel lɔn ye Nhialic Wun, ku këya acï rot looi bï thöŋ kek Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Go Jethu jal bɛ̈ɛ̈r, “Wɛ̈t yic alɛ̈k we, acïn kë ye Wät looi piände ë rot, kë ye looi ë tök, ee kë cï tïŋ kë ye Wun looi. Ku kë ye Wun looi aye Wënde looi aya. ");
INSERT INTO dikNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Rin Wun ë Wënde nhiaar, ku nyuth këriëëc ye looi. Ku kädït tënë këwën aabï nyuɔ̈th ye, ku wek aabï jal gäi ëbën. ");
INSERT INTO dikNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Cïmën ye Wun kɔc cï thou jɔt ku yïk ke pïr, ke Wënde aya ë pïr yiëk kɔc wïc ye. ");
INSERT INTO dikNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Wun guɔ̈p acïn raan ye luɔ̈k wei. Ku acï Wënde yiëk riɛl bï looi tënë ke ëbën. ");
INSERT INTO dikNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Rin bï kɔc ëbën Wënde theek cïmën ye kek Wun theek. Kuat raan cie Wënde ye theek, acie Wun ye theek raan toc ye. ");
INSERT INTO dikNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Wɛ̈t yic alɛ̈k we, raan piŋ wɛ̈tdiɛ̈, ku gɛm wɛ̈t raan toc ɣa pïr akölriëëc ëbën atɔ̈ tënë ye. Acï bï luɔ̈k wei, yeen acï jäl thou yic ku yök pïr. ");
INSERT INTO dikNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Wek aa lɛ̈k yic, aköl bï bɛ̈n, ku acï guɔ bɛ̈n tɛ̈ bï kɔc cï thou röl Wën Nhialic piŋ, ku kɔc bï ye piŋ aabï pïr. ");
INSERT INTO dikNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Cïmën ye pïr bɛ̈n bei tënë Wun, këya, yeen acï Wënde looi bï ya tɛ̈ ye pïr bɛ̈n bei thïn aya. ");
INSERT INTO dikNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ku yeen acï Wënde yiëk riɛl bï luk looi tënë kɔc, rin ye yen Manh Raan. ");
INSERT INTO dikNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Duɔ̈kkë gɛ̈i ë wɛ̈t kënë, aköl bï kɔc cï thou rɔ̈lde piŋ rɛ̈ŋ yiic abɔ̈, ");
INSERT INTO dikNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ku keek aabï bɛ̈n bei räŋken yiic, kɔc cï ŋiɛc luui apath aabï röt jɔt ku aabï pïr, ku kɔc cï luui kärɛc aabï röt jɔt ku aabï luɔ̈k wei. ");
INSERT INTO dikNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Acïn kë lɛ̈u ba looi piändiɛ̈ ë rot, ɣɛn ë wɛ̈t teem kecït kë cï Nhialic lɛ̈k ɣa, këya wɛ̈t ca teem ala cök rin acie wɛ̈t piändiɛ̈ yen wiëc ba looi, ee wɛ̈t wïc raan toc ɣa ë rot. ");
INSERT INTO dikNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Na jaam ë riɛnkiɛ̈ ke kë luɛɛl acie gam ciɛ̈t ye yic. ");
INSERT INTO dikNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ku raan dɛ̈t jam ë riɛnkiɛ̈ atɔ̈ thïn, ku aŋiɛc lɔn kë ye lueel riɛnkiɛ̈ ë yic. ");
INSERT INTO dikNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Atuc aa cäk tuɔɔc tënë Joon ku yeen acï wɛ̈t yic lueel. ");
INSERT INTO dikNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Acie lɔn bï ɣɛn la raan jam ë riɛnkiɛ̈, aya lueel yen kënë rin bï wek pïr. ");
INSERT INTO dikNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Joon ë ye këcït mermer dɛ̈p ku mer piny, ku week ë yakë wïc kaam thin-nyɔɔt bäk puɔ̈th miɛt thïn ruɛlde. ");
INSERT INTO dikNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ku raan jam ë riɛnkiɛ̈ atɔ̈ thïn, ku wɛ̈tde aril tënë wɛ̈t cï Joon lueel ë riɛnkiɛ̈ luɔi ya ke looi, luɔi cï Wä yiëk ɣa ba ke looi, keek aa jam ë riɛnkiɛ̈ ku nyoothkë lɔn cï Wä ɣa tooc. ");
INSERT INTO dikNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ku Wä aya, raan toc ɣa, yen ajam ë riɛnkiɛ̈ aya. Wek aa këc rɔ̈lde kaŋ piŋ ku akëckë kaŋ tïŋ, ");
INSERT INTO dikNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ku wɛ̈t cï lueel acäk ye muk wepuɔ̈th, rin cïï wek wɛ̈t raan cï tooc ye gam. ");
INSERT INTO dikNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Athör Nhialic ayakë kueen, rin ye wek ye tak lɔn bäk pïr akölriëëc yök thïn. Ku keek aya aa jam ë riɛnkiɛ̈! ");
INSERT INTO dikNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ku ŋot cäk wïc bäk bɛ̈n tënë ɣa bäk pïr yök thïn. ");
INSERT INTO dikNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Acä wïc bï kɔc ɣa leec. ");
INSERT INTO dikNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ku wek ŋiɛc, ku aŋiɛc lɔn tɔ̈u nhiɛ̈r Nhialic wepuɔ̈th. ");
INSERT INTO dikNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ɣɛn acï bɛ̈n kek riɛl ë Wä, ku kuɛckë bäk ɣa lor, ku na bɔ̈ raan dɛ̈t kek riɛlde ë rot ke yen abäk lor. ");
INSERT INTO dikNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Anhiarkë bäk lɛc yök tënë raan dɛ̈t, ku acäk ye them bäk lɛc yök tënë Nhialic, ye këdë yen bï wek ɣa gam? ");
INSERT INTO dikNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ku ëmën duɔ̈kkë tak lɔn bï ɣɛn we luɔm tënë Wä. Mothith guɔ̈p yen abï we luɔm, ku ë Mothith yen acäk ŋɔ̈ɔ̈th wepuɔ̈th. ");
INSERT INTO dikNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Na we cï Mothith gam alanden, ke wek ŋot we gam ɣa aya, rin cï yen wël gɔ̈t ë riɛnkiɛ̈. ");
INSERT INTO dikNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ku rin ye wek kuec gäm wël cï gɔ̈t, ke lɛ̈ukë këdë bäk wël ca lɛ̈k we gam?” ");
INSERT INTO dikNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ye tɛ̈ɛ̈n ke Jethu tem wär Galilia cɔl Tiberia aya. ");
INSERT INTO dikNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Go kɔc juëc buɔɔth rin cï kek kädït jäŋ gɔ̈i, cï yen kɔc tuany kony tïŋ. ");
INSERT INTO dikNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Go Jethu la gɔt nhom ku nyuuc kek kɔcken ye buɔɔth. ");
INSERT INTO dikNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ku yan kɔc Itharel, Yan Ayum cïn yic luɔu ëcï thiɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Nawën ciɛɛth Jethu piny ke tïŋ kɔc juëc ke bɔ̈ tënë ye, go Pilipo thiëëc, “Ye tɛ̈no bï ɣok miëth kueth kɔc ëbën ɣɔɔc thïn?” ");
INSERT INTO dikNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Acï kënë lueel ku bï Pilipo them, rin ŋic yen kë bï looi. ");
INSERT INTO dikNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Go Pilipo bɛ̈ɛ̈r, “Rin bï raan tök ayum thin-nyɔɔt yök, ka wïc wëëu juëc apɛi bï ayuɔ̈p ɣɔɔc.” ");
INSERT INTO dikNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Go Andria, mɛ̈nh Thaimon Pïtɛr, ku ë ye raan tök kam kɔcken ye buɔɔth lueel, ");
INSERT INTO dikNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Dhɔ̈k atɔ̈ thïn tɛ̈n ke muk ayuɔ̈p kadhiëc ku rec karou, ku aacïï kɔckä ëbën bï lëu.” ");
INSERT INTO dikNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Go Jethu lɛ̈k ke, “Calkë kɔc anyuc piiny.” (Ku noon ë dït thïn ë tɛ̈ɛ̈n. Go kɔc nyuc ëbën piiny.) Ku röör kepɛ̈c aake ye tɛ̈cït tɛ̈n tiim kadhiëc. ");
INSERT INTO dikNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Go Jethu ayuɔ̈p lööm ku leec Nhialic, ku tek ke tënë kɔc wën cï nyuc ëbën. Ku ben looi këya kek rec, bï raan ëbën kuɛth cït tɛ̈ wïc. ");
INSERT INTO dikNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Wën cï kek kuɛth ëbën, ke lëk kɔcken ye buɔɔth, “Kuanykë abɛ̈k cï döŋ piny, bï ciɛ̈n kë riääk.” ");
INSERT INTO dikNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Gokë ke kuany ëbën, ku thiɔ̈ŋkë gäc thiäär ku rou abɛ̈k ayuɔ̈p cï döŋ piny, tënë ayuɔ̈p kadhiëc wën cï ke tɛ̈k kɔc bïk cam. ");
INSERT INTO dikNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nawën tïŋ kɔc wën luɔi ril cï Jethu looi ke luelkë, “Kënë ë raan käk Nhialic tïŋ yen bï dhiɛl bɛ̈n pinynhom.” ");
INSERT INTO dikNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Go Jethu jäl ŋic lɔn bï kek bɛ̈n bïk ye bɛ̈n dɔm riɛl, ku loikë bï ya bɛ̈nyŋaknhom, go bɛn dhuk gat nhïïm ë rot. ");
INSERT INTO dikNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Nawën cï piny cuɔl, ke kɔcken ye buɔɔth la piny wär thok, ");
INSERT INTO dikNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ku lek riäi yic, ku dhukkë ciëën wär alɔŋtui lɔŋ Kapernaum. Nawën ke wɛ̈ɛ̈r jɔl yic dït ke Jethu ŋot këc bɛ̈n tënë ke. ");
INSERT INTO dikNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Kaam wën ke yomdït jɔt rot ku loi atiaktiak rot apɛi. ");
INSERT INTO dikNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ku kɔcken ye buɔɔth, aake ye tɛ̈cït meel kadiäk ayï ŋuan wën tïŋ kek Jethu ke cath pïu nhïïm, ke bɔ̈ tɛ̈thiɔ̈k kek riäi, gokë riɔ̈ɔ̈c apɛi, ");
INSERT INTO dikNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Go Jethu lɛ̈k ke, “Duɔ̈kkë riɔ̈c, ee ɣɛn.” ");
INSERT INTO dikNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Gokë jat riäi yic, ku go riäi guɔ ɣet wär thok tɛ̈wën le kek thïn. ");
INSERT INTO dikNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Naɣɔn nhiäk ke tïŋ kɔc ke cï döŋ wär alɔŋtui, lɔn ë yen riän tökaliŋ yen acï döŋ. Ku aŋickë lɔn këc Jethu la riäi yic kek kɔcken ye buɔɔth, ku aake cï jäl ë röt. ");
INSERT INTO dikNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Go riëth kɔ̈k ke bɔ̈ Tiberia bɛ̈n wär thok tɛ̈thiääk ke tɛ̈wäär ciɛm kɔc juëc ayup thïn, wën cï Bɛ̈ny lɛc gam. ");
INSERT INTO dikNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Nawën tïŋkë lɔn liu Jethu thïn, ku liu kɔcken ye buɔɔth aya, gokë kɛɛc riäth yiic ku lek Kapernaum bïk Jethu la wïc. ");
INSERT INTO dikNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nawën lek Jethu yök wär alɔŋtui ke lëkkë ye, “Raan piööc, ye nɛn bï yïn ë tɛ̈n?” ");
INSERT INTO dikNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Go Jethu bɛ̈ɛ̈r, “Wɛ̈t yic alɛ̈k we, wek aa wïc ɣa rin cï wek ayup cam tɛ̈cït tɛ̈ wiɛ̈ckë, ku acie rin cï wek luɔikiɛ̈n ril deet yiic. ");
INSERT INTO dikNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Duɔ̈kkë lui rin miëth riääk, luɔ̈ɔ̈ikë rin miëth rëër rin pïr akölriëëc ëbën. Miëth kënë abï Manh Raan yiëk we rin Wun, Nhialic acï riɛlde gäm ye ku tooc.” ");
INSERT INTO dikNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Gokë thiëëc, “Buk ŋö looi buk luɔi wïc Nhialic looi?” ");
INSERT INTO dikNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Go Jethu bɛ̈ɛ̈r, “Luɔi wïc Nhialic bäk looi akïn, ë lɔn bäk wɛ̈t raan cï tuɔ̈ɔ̈c gam.” ");
INSERT INTO dikNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Gokë lueel, “Ye kïn riɛl ŋö ba looi buk tïŋ ku buk wɛ̈tdu gam? Yeŋö ba looi? ");
INSERT INTO dikNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Wärkuan thɛɛr aacä ayum löny nhial cam roor, cïmën cï ye gɔ̈t athör thɛɛr wël Nhialic yiic ëlä, ‘Ayum nhial acï yiëk ke bïk cam.’ ” ");
INSERT INTO dikNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Go Jethu lueel, “Wɛ̈t yic alɛ̈k we, kë cï Mothith yiëk we acie ayum pan nhial, ee Wä yen ë we yiëk ayum yic bɔ̈ pan nhial. ");
INSERT INTO dikNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Rin ayum ye Nhialic gam ë yen raan bɔ̈ piny pan nhial, ku yïk thäi pinynhom pïr.” ");
INSERT INTO dikNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Gokë thiëc, “Bɛ̈ny, muɔc ɣo ayum kënë akölaköl.” ");
INSERT INTO dikNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Go Jethu lɛ̈k ke, “Ɣɛn ayum ë pïr,” Ku raan bɔ̈ tënë ɣa acïï cɔk bï kaŋ nɔ̈k, “Ku raan gam wɛ̈tdiɛ̈ acïï rou bï nɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ëmën, aca lɛ̈k we lɔn cï wek ɣa tïŋ, ku aŋot kɛ̈ckë gam. ");
INSERT INTO dikNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Raan ëbën cï Wä yiëk ɣa, yen abï bɛ̈n tënë ɣa. Ku raan bï bɛ̈n tënë ɣa acä bï cuɔp wei, ");
INSERT INTO dikNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","rin cï ɣɛn bɛ̈n pan nhial ba wɛ̈t raan toc ɣa bɛ̈n looi, ku acie wɛ̈t piändiɛ̈. ");
INSERT INTO dikNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Kë wïc raan toc ɣa ba looi akïn, bï ciɛ̈n kë mär kam käk cï yiëk ɣa, ku ba ke jɔt ëbën aköl ciëën. ");
INSERT INTO dikNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Rin kë wïc Wä akïn, lɔn raan ëbën tïŋ Wënde ku gɛm wɛ̈tde, abï pïr akölriëëc ëbën yök thïn, ku keek aaba jɔt bïk pïr ëbën aköl ciëën.” ");
INSERT INTO dikNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Go kɔc Itharel luɔ̈ɔ̈p guɔ̈p rin cï yen ye lueel ëlä, “Ɣɛn ayum cï bɛ̈n piny pan nhial.” ");
INSERT INTO dikNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ku luelkë, “Monyë cie Jethu wën Jothep? Wun ku man aa ŋicku. Ku yeŋö ye yen ye lueel lɔn cï yen bɛ̈n piny pan nhial?” ");
INSERT INTO dikNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Go Jethu bɛ̈ɛ̈r, “Duɔ̈kkë lum kamkun. ");
INSERT INTO dikNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Acïn raan lëu ye bï bɛ̈n tënë ɣa tɛ̈ këc Wä ë toc ɣa ye thɛ̈l ɣɛn, ku aba jɔt bï pïr aköl ciëën. ");
INSERT INTO dikNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Acï kɔc käk Nhialic tïŋ gɔ̈t ëlä, ‘Kɔc ëbën aabï Nhialic ke piɔ̈ɔ̈c.’ Raan ëbën piŋ wɛ̈t Wä ku piööc tënë ye ë bɛ̈n tënë ɣa. ");
INSERT INTO dikNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ku acie rin nadë yen raan cï Wä kaŋ tïŋ, raan bɔ̈ tënë Nhialic, yeen ë rot, yen ë raan cï Wä kaŋ tïŋ. ");
INSERT INTO dikNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Wɛ̈t yic alɛ̈k we, raan gam wɛ̈t ala pïr alanden. ");
INSERT INTO dikNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ɣɛn ayum ë pïr. ");
INSERT INTO dikNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Wärkun thɛɛr aacä ayum löny nhial cam roor ku aacï thou. ");
INSERT INTO dikNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ku ayum bɔ̈ piny pan nhial, yen acït kën na ciɛm raan ka cie bɛn thou. ");
INSERT INTO dikNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ɣɛn ayum ë pïr cï bɛ̈n piny pan nhial. Raan cam ayum kënë, ka pïr akölriëëc ëbën. Ayum yen ba yiëk ye ë riëŋdiɛ̈ ya gam bï kɔc ëbën pïr.” ");
INSERT INTO dikNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Go kɔc Itharel teer apɛi kamken, ku thiëckë, “Lëu mony kënë këdë, bï riëŋde yiëk ɣo buk cuet?” ");
INSERT INTO dikNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Go Jethu bɛ̈ɛ̈r, “Wɛ̈t yic alɛ̈k we, tɛ̈ cï wek Manh Raan cuet ku dɛ̈kkë riɛmdiɛ̈ ka cïn pïr bäk yök wɛ̈ikun yiic. ");
INSERT INTO dikNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Raan cuet riëŋdiɛ̈ ku dek riɛmdiɛ̈ ala pïr alanden, ku abï jɔt aköl ciëën bï pïr. ");
INSERT INTO dikNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Rin riëŋdiɛ̈ ë miëth alanden, ku riɛmdiɛ̈ ë këdek alanden. ");
INSERT INTO dikNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Raan cuet riëŋdiɛ̈ ku dek riɛmdiɛ̈ abï pïr ɣayic, ku ɣɛn abï pïr yeyic. ");
INSERT INTO dikNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Wä pïr acä tooc, ku ë rin riɛnke yen abï ɣɛn aya, ku këya raan cuet ɣɛn abï pïr ë riɛnkiɛ̈. ");
INSERT INTO dikNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ku yen kïn ayum bɔ̈ piny pan nhial, acïï thöŋ kek ayum cï wärkun thɛɛr cam ku lökkë thou. Raan cam ayum kënë abï pïr akölriëëc ëbën.” ");
INSERT INTO dikNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Wëlkä aacï Jethu lueel wäär piööc yen kɔc tɛ̈n amat Kapernaum. ");
INSERT INTO dikNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Nawën piŋ kɔc juëc ye buɔɔth wëlkä, ke luelkë, “Piööc kënë aril apɛi. Yeŋa lëu bï ke piŋ?” ");
INSERT INTO dikNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Go Jethu ŋic lɔn jiɛɛm kek wël wën, ku lëk ke, “Wiɛ̈ckë bäk jäl rin ë wëlkä? ");
INSERT INTO dikNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Yeŋö bäk looi tɛ̈ tïŋ wek Manh Raan ke dhuk nhial tɛ̈wën rëër yen thïn? ");
INSERT INTO dikNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ee Wëi Nhialic yen ë pïr gam, ku riɛl raan acïn kë ye kony. Wël ca lɛ̈k we aa wëi ku aa pïr. ");
INSERT INTO dikNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ku këya acïï kɔc kɔ̈k kamkun ye gam.” (Rin ëcï Jethu guɔ ŋic tueŋ lɔn ye yïŋa cïï bï gam, ku yeŋa bï ye gaany.) ");
INSERT INTO dikNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ku ben lueel, “Ee rin wɛ̈t kënë guɔ̈p yen alëk ɣɛn ye we, lɔn acïn raan lëu ye bï bɛ̈n tënë ɣa, tɛ̈ këc Wä ye looi bï yic pial tënë ye.” ");
INSERT INTO dikNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ku rin ë wëlkä, ke kɔc juëc kam kɔc ye buɔɔth dhuk ciëën, ku cïk ben cath kek ye. ");
INSERT INTO dikNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Go Jethu atuɔ̈ɔ̈cke thiäär ku rou thiëëc, “Na week, wiɛ̈ckë bäk jäl aya?” ");
INSERT INTO dikNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Go Thaimon Pïtɛr bɛ̈ɛ̈r tënë ye, “Bɛ̈ny, buk la tënë ŋa? Yïn ala wël pïr alanden. ");
INSERT INTO dikNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ku ëmën acuk gam ku acuk ŋic lɔn ë yïn raan dhëŋ bɔ̈ tënë Nhialic.” ");
INSERT INTO dikNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Go Jethu bɛ̈ɛ̈r, “Cie ɣɛn ɣa kuany we wathiäär ku rou? Ku raan tök kamkun aŋot ye jɔŋrac.” ");
INSERT INTO dikNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yeen ë jam rin Judath, wën Thaimon Ithkariöt. Rin Judath, na cɔk alɔn ë yen raan tök kam atuɔ̈ɔ̈cke kathiäär ku rou, ka wïc bï ye luɔm. ");
INSERT INTO dikNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Wën ë wëlkä cök ciëën, ke Jethu kuɛny bɛ̈ɛ̈i Galilia yiic, ku ë këc wïc bï la keny Judia, rin wïc bäny Itharel tɔ̈ Judia ye bïk nɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ku yan kɔc Itharel cɔl Yan Duɛ̈l ëcï thiɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Go wämäthakën lɛ̈k ye, “Jäl ë tɛ̈n ku lɔɔr Judia bï kɔckun yï buɔɔth luɔidun ye looi tïŋ. ");
INSERT INTO dikNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Acïn raan kë looi thiaan tɛ̈ wïc yen ye bï ŋic apath. Rin ye yïn käkkä looi, ke yï cɔl kɔc pinynhom aa ŋic yï.” ");
INSERT INTO dikNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Agut wämäthakën aakëc wɛ̈tde gam, yen aa lueel kek ye këya. ");
INSERT INTO dikNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Go Jethu lɛ̈k ke, “Akäldiɛ̈ guɔ̈p aŋot këc ɣëët. Ku na ye we, ke kuat akɔ̈l ëbën apath. ");
INSERT INTO dikNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Acïn tɛ̈ bï kɔc pinynhom we maan, ku keek aa man ɣa rin aya lueel, lɔn rɛɛc luɔiken. ");
INSERT INTO dikNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Lak yai yic, ku ɣɛn acïï la ë yan kënë yic, rin aköldiɛ̈n bï ɣɛn la akëc guɔ bɛ̈n.” ");
INSERT INTO dikNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yeen acï jam këya ku jɔl rëër pan Galilia. ");
INSERT INTO dikNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Nawën cï wämäthakën la yai yic, ke Jethu lök la aya, ku akëc la ke ŋic, yeen acï la ke mony rot. ");
INSERT INTO dikNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ku bäny Itharel aake wïc Jethu yai yic, ku thiëckë, “Tɔ̈ monyë tɛ̈nɛn?” ");
INSERT INTO dikNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ku aluɔp ë dït apɛi ë riɛnke. Aye kɔc kɔ̈k lueel, “Yeen ë raan path.” Ku lueel kɔc kɔ̈k, “Acie këya, yeen ë raan kɔc duɔ̈ɔ̈ŋ.” ");
INSERT INTO dikNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ku acïn raan ye jam ë riɛnke kɔc nhïïm, rin riɔ̈ɔ̈c kek bäny Itharel. ");
INSERT INTO dikNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Wën cï nïn abɛ̈k yai thök, ke Jethu la kal luaŋ Nhialic yic ku jɔl kɔc piɔ̈ɔ̈c. ");
INSERT INTO dikNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Go bäny Itharel gäi apɛi ku luelkë, “Ye raan kënë käŋ ŋic këdë ku akëc kaŋ piɔ̈ɔ̈c.” ");
INSERT INTO dikNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Go Jethu bɛ̈ɛ̈r, “Wël ya piɔ̈ɔ̈c acie wɛ̈lkiɛ̈ aa wël bɔ̈ bei tënë Nhialic, Aciëŋ cï ɣa tooc. ");
INSERT INTO dikNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Raan wïc ye bï kë wïc Nhialic looi, abï ŋic lɔn nadë kë ya piɔ̈ɔ̈c abɔ̈ tënë Nhialic, ku acie riɛldiɛ̈ ë rot. ");
INSERT INTO dikNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Raan jam riɛlde ë rot ë lɛc yen aye wïc, ku raan wïc lɛc tënë raan toc ye, yen ë raan path, ku acïn ruëëny tɔ̈ yepuɔ̈u. ");
INSERT INTO dikNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Këc Mothith löŋ Nhialic nyuɔ̈th we? Ku acïn raan löŋ theek kamkun. Yeŋö ye wek ye wïc bäk ɣa nɔ̈k?” ");
INSERT INTO dikNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Go kɔc juëc wën bɛ̈ɛ̈r, “Yïn ala guɔ̈p jɔŋrac, yeŋa wïc ye bï yï nɔ̈k?” ");
INSERT INTO dikNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Go Jethu bɛ̈ɛ̈r, “Këdït jäŋ gɔ̈i tök aca looi guɔkë gäi wedhie. ");
INSERT INTO dikNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mothith acï we thɔn bäk miɛ̈thkun aa ŋoot, ku acie Mothith guɔ̈p yen cï wɛ̈t kënë jɔɔk, aa wärkun thɛɛr, ku këya wek a dhɔ̈k ŋoot aköl cïï kɔc ye luui. ");
INSERT INTO dikNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ku ëmën na ŋot dhɔ̈k aköl cïï kɔc ye luui rin bï löŋ Mothith cïï dhäl yic, yeŋö ye wek puɔ̈th riääk tënë ɣa, rin cï ɣɛn raan tök kony bï pial aköl cïï kɔc ye luui? ");
INSERT INTO dikNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Duɔ̈kkë raan ye guɔ tɛ̈m awuɔ̈c wɛ̈t kɔ̈u aɣeer, yakë raan tɛ̈m awuɔ̈c wɛ̈t ë yic.” ");
INSERT INTO dikNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Go kɔc kɔ̈k Jeruthalem lueel ëlä, “Cie raan kënë yen wïckë bïk nɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Tiɛ̈ŋkë! Yen kïn jam kɔc nhïïm, ku acïn kë luelkë ë riɛnke. Tɛ̈dë, cïï bäny ŋic lɔn ë yen Raan cï lɔc ku dɔc? ");
INSERT INTO dikNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Na la Raan cï lɔc ku dɔc bɛ̈n, ka cïn raan bï ye ŋic tɛ̈ bï yen thïn, ku aŋicku ëbën yen tɛ̈ bïï mony kënë thïn.” ");
INSERT INTO dikNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Nawën piɔ̈ɔ̈c Jethu luaŋ Nhialic ke lueel röldït, “Ee tɛ̈dë, wek aa ŋic ɣa ku aŋiɛckë yen tɛ̈ bï ɣɛn thïn. Ku ɣɛn akëc bɛ̈n wɛ̈tdiɛ̈ ë rot, ku yeen raan toc ɣa ala yic ku yeen akuɔ̈ckë, ");
INSERT INTO dikNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ku yeen aŋiɛc rin bï ɣɛn tënë ye, ku yen acä tooc.” ");
INSERT INTO dikNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Gokë wïc bïk dɔm, ku acïn raan cï yecin tääu yeguɔ̈p rin këc akälde guɔ bɛ̈n. ");
INSERT INTO dikNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Go kɔc juëc thän wën yic wɛ̈tde gam ku luelkë, “Tɛ̈ bï Raan cï lɔc ku dɔc bï kädït jäŋ gɔ̈i looi cïmën ë raan kënë?” ");
INSERT INTO dikNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Nawën piŋ kɔc akut Parathï lɔn ye kɔc juëc wën wëlkä loop kamken rin Jethu, ke keek ku bäny käk Nhialic toc apuruuk luaŋ Nhialic tiit bïk Jethu la dɔm. ");
INSERT INTO dikNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Go Jethu lueel, “Ɣɛn abï rëër kamkun tɛ̈thin-nyɔɔt, ku ɣɛn abï la tënë raan yen cä tooc. ");
INSERT INTO dikNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Wek abä wïc, ku wek aacïï ɣa bï yök, rin acïn tɛ̈ bï wek la tɛ̈ rëër ɣɛn thïn.” ");
INSERT INTO dikNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Go bäny Itharel lueel kamken, “Bï la dä buk cïï ben yök? Cï bï la gɛɛth Gïrïk yiic tɛ̈ ciëŋ kɔc Itharel thïn, ku bï kɔc Gïrïk piɔ̈ɔ̈c? ");
INSERT INTO dikNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Aye lueel, wek abä wïc ku wek aacïï ɣɛn bï yök, ku wek aacïï bï la tɛ̈ rëër ɣɛn thïn, yeŋö wïc bï lueel?” ");
INSERT INTO dikNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Aköl ciëën yen aköl dït nïn yai. Akölë, Jethu acï rot jɔt ku lueel röldït, “Kuat raan nɛ̈k rou abï bɛ̈n tënë ɣa ku bï dek. ");
INSERT INTO dikNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Cïmën cï ye gɔ̈t athör thɛɛr wël Nhialic yic ëlä, ‘Raan gam wɛ̈tdiɛ̈, kuëër pïu ë pïr abï rëër yepuɔ̈u.’ ” ");
INSERT INTO dikNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Kënë acï Jethu lueel rin Wëi Nhialic, bï kɔc gam wɛ̈tde lɔ̈k yök. Ku tɛ̈në, Wëi Nhialic a këc guɔ gam tënë kɔc, rin këc Jethu guɔ la diɛɛkde yic. ");
INSERT INTO dikNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Kɔc kɔ̈k kam kɔc wën aacï kënë piŋ ku luelkë, “Raan kënë ë raan käk Nhialic tïŋ alanden!” ");
INSERT INTO dikNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Go kɔc kɔ̈k lueel, “Yen ë Raan cï lɔc ku dɔc!” Ku lueel kɔc kɔ̈k, “Raan cï lɔc ku dɔc aacïï bï bɛ̈n pan Galilia! ");
INSERT INTO dikNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Acï gɔ̈t athör thɛɛr wël Nhialic yic lɔn Raan cï lɔc ku dɔc abï ya raan dhiënh Debit, ku abï dhiëëth Bethalem, gen wäär ciëŋ Debit thïn.” ");
INSERT INTO dikNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Go kɔc wën keyiic tek ë riɛnke. ");
INSERT INTO dikNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ku wïckë bïk dɔm, ku acïn raan cï yecin tääu yeguɔ̈p. ");
INSERT INTO dikNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Nawën dhuk apuruuk ciëën tënë bäny käk Nhialic ku kɔc akut Parathï, gokë ke thiëëc, “Yeŋö këc wek ye bɛ̈ɛ̈i?” ");
INSERT INTO dikNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Go apuruuk bɛ̈ɛ̈r, “Acïn raan cï kaŋ jam cïmën ë mony kënë!” ");
INSERT INTO dikNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Go kɔc akut Parathï ke thiëëc, “Cï we duɔ̈ɔ̈ŋ aya? ");
INSERT INTO dikNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Le raan tök kam bäny, ayï kam kɔc akut Parathï cï wɛ̈tde gam cäk kaŋ piŋ? ");
INSERT INTO dikNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Kɔckä aa kuc löŋ Mothith, ku aa kɔc cï Nhialic läm kërac.” ");
INSERT INTO dikNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Go raan tök kam kɔc akut Parathï, raan cï kaŋ la bï Jethu la tïŋ, cɔl Nikodemo lɛ̈k ke, ");
INSERT INTO dikNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Na ye löŋ ciɛɛŋ panda, ka cïn tɛ̈ bï ɣok raan luɔ̈k wei ke këcku kaŋ piŋ thok tueŋ, ku ŋicku kë cï looi.” ");
INSERT INTO dikNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Gokë bɛ̈ɛ̈r, “Yïïn aya, ye raan Galilia? Kuen athör thɛɛr wël Nhialic, ku aba ŋic lɔn acïn raan käk Nhialic bɛ̈n Galilia.”  ");
INSERT INTO dikNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Nawën cï raan ëbën dhuk paande, ");
INSERT INTO dikNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ke Jethu la gɔn Olip nhom. ");
INSERT INTO dikNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Naɣɔn nhiäk dur yic ke dhuk luaŋ Nhialic. Go kɔc ëbën guëër yelɔ̈ɔ̈m, ku nyuuc piiny ku jɔɔk piööc cök tënë ke. ");
INSERT INTO dikNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Go kɔc piööc lööŋ ku kɔc akut Parathï tik bɛ̈ɛ̈i, ku ë tiŋ cï käl piny ke kɔr. Ku cɔlkë akääc kɔc nhïïm ëbën, ");
INSERT INTO dikNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ku luelkë tënë Jethu, “Raan piööc, tiŋ kënë acï käl piny ke kɔr. ");
INSERT INTO dikNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mothith acï löŋ lɛ̈k ɣo athör yic lɔn kuat tiŋ loi këcït kënë, adhil biɔ̈ɔ̈k aleel bï thou. Na yïïn ëmën, ye lueel këdë?” ");
INSERT INTO dikNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Keek aake jam këlä bïk Jethu deep bïk wɛ̈t yök bïk la luɔm. Go Jethu guŋ ku gɛ̈t piny yecin. ");
INSERT INTO dikNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Nawën ŋot ke kääc ku yekë thiëëc, ke jɔt yekɔ̈u ku lëk ke, “Na le raan kamkun cïn adumuɔ̈ɔ̈m cïï kaŋ looi, ke biök alel tueŋ yeguɔ̈p.” ");
INSERT INTO dikNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ku ben guŋ ku gɛ̈t piny yecin. ");
INSERT INTO dikNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Nawën cïk wɛ̈t kënë piŋ, ke jiël ëbën ke wath röt, ku kɔŋ kɔcdït jäl tueŋ, agut tɛ̈ döŋ Jethu ë rot, ku tiŋ wën ke ŋot kääc yenhom. ");
INSERT INTO dikNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Go yekɔ̈u jɔt ku lëk ye, “Tɔ̈kë tɛ̈no? Cïn raan cïï döŋ bï yï luɔ̈k wei?” ");
INSERT INTO dikNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Go bɛ̈ɛ̈r, “Acïn raan Bɛ̈ny.” Go Jethu lueel, “Apath, ke yïïn acä bï luɔ̈k wei aya. Lɔɔr ku duk adumuɔ̈ɔ̈m ben looi.” ");
INSERT INTO dikNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Go Jethu bɛn jam tënë kɔc ku lueel, “Ɣɛn ë ruɛl pinynhom, kuat raan buɔth ɣa abï ruɛl pïr yök, ku acïï bï kaŋ cath muɔ̈ɔ̈th yic.” ");
INSERT INTO dikNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Go kɔc akut Parathï lɛ̈k ye, “Ëmën, yïn ajam ë riɛnku, ku wɛ̈t ca lueel acïn kë ye nyuɔɔth.” ");
INSERT INTO dikNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Go Jethu bɛ̈ɛ̈r, “Acie këya, na cɔk alɔn jiɛɛm ɣɛn ë riɛnkiɛ̈, ke wɛ̈t luɛɛl ë yic, rin ɣɛn aŋic tɛ̈ bïï ɣɛn thïn. Ku wek aa kuc tɛ̈ bïï ɣɛn thïn ayï tɛ̈ ler ɣɛn thïn. ");
INSERT INTO dikNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Wek aa wɛ̈t teem cïmën wɛ̈t raan, ku ɣɛn acïn raan ya gäm awuɔ̈c. ");
INSERT INTO dikNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ku tɛ̈ bï ɣɛn wɛ̈t teem, ke wɛ̈t ba teem abï jal a yic, rin acie ɣɛn tem wɛ̈t, Wä ë toc ɣɛn arɛ̈ɛ̈r ke ɣa. ");
INSERT INTO dikNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Wɛ̈t acï gɔ̈t lɔ̈ŋdun yic lɔn tɛ̈ lueel kɔc karou wɛ̈t tök luk yic, ke wɛ̈tden ë ya yic. ");
INSERT INTO dikNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ɣɛn ajam ë riɛnkiɛ̈, ku Wä cä tooc ajam ë riɛnkiɛ̈ aya.” ");
INSERT INTO dikNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Gokë thiëëc, “Tɔ̈ Wuur tɛ̈no?” Go Jethu bɛ̈ɛ̈r, “Wek aacïï ɣa ŋic, ku wek aacïï Wä ŋic. Na we ŋic ɣa, ŋuɔ̈t wek aa ŋic Wä aya.” ");
INSERT INTO dikNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Wëlkä ëbën aacï Jethu lueel wäär piööc yen luaŋ Nhialic, ɣön cï käkken ajuër tɔ̈u thïn. Ku acïn raan cie dɔm rin këc akälde guɔ bɛ̈n. ");
INSERT INTO dikNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Go Jethu bɛn lɛ̈k ke, “Ɣɛn abï jäl ku wek abä wïc, ku wek aabï thou awäckun yiic. Tɛ̈ le ɣɛn thïn, acie yen tɛ̈ bï wek la thïn.” ");
INSERT INTO dikNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Tɛ̈wën, ke lueel bäny Itharel, “Aye lueel lɔn cïï ɣok bï la tɛ̈ le yen thïn. Ye ciɛ̈t bï rot nɔ̈k?” ");
INSERT INTO dikNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Go Jethu bɛ̈ɛ̈r, “Wek aa kɔc piny tɛ̈n, ku ɣɛn ee raan bɔ̈ nhial. Wek aa kɔc piny kënë nhom, ku ɣɛn acie raan pinynhom tɛ̈n. ");
INSERT INTO dikNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ee rin kënë yen acï ɣɛn ye lueel lɔn bï wek thou adumuɔ̈ɔ̈mkun yiic. Ku wek aabï thou adumuɔ̈ɔ̈mkun yiic tɛ̈ këc wek ye gam, lɔn ë Ɣɛn tɔ̈ thïn, yen ë Ɣɛn.” ");
INSERT INTO dikNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Gokë thiëëc, “Ye yïn ŋa?” Go Jethu bɛ̈ɛ̈r, “Wɛ̈t aca lɛ̈k we tɛ̈wën jɔɔk ɣɛn wɛ̈t cök. ");
INSERT INTO dikNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ɣɛn ala wël juëc ba ke lueel ë riɛnkun, ku wël juëc bï ɣɛn ke we luɔ̈k wei. Ku raan cä tooc guɔ̈p ala yic, ku ɣɛn ë kɔc lɛ̈k kuat kë ca piŋ tënë ye.” ");
INSERT INTO dikNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Gokë kɛ̈c deet lɔn jiɛɛm Jethu wɛ̈t Wun. ");
INSERT INTO dikNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Go Jethu bɛn lueel tënë ke, “Aköl bï wek Manh Raan jat nhial, ka bäk jäl ŋic lɔn, ‘Ɣɛn tɔ̈ thïn Yen ë Ɣɛn.’ Ku abäk deet yic aya lɔn acïn kë ya looi ruɔtdiɛ̈, ku aa ya ke lueel wël cï Wä piɔ̈ɔ̈c tënë ɣa. ");
INSERT INTO dikNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ku raan cä tooc arɛ̈ɛ̈r ke ɣa, ku akëc ɣa nyääŋ piny ɣatök, rin ye ɣɛn wɛ̈t nhiɛɛr looi akölaköl.” ");
INSERT INTO dikNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Go kɔc juëc cï Jethu piŋ ke jam ë wëlkä wɛ̈tde jäl gam. ");
INSERT INTO dikNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Go Jethu lɛ̈k kɔc Itharel cï wɛ̈tde gam, “Na piɛŋkë wël ca piɔ̈ɔ̈c, ke wek aa kɔckiɛ̈n buɔth ɣa ayic, ");
INSERT INTO dikNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ku wek aabï yic ŋic, ku yic abï we wɛ̈ɛ̈r bei.” ");
INSERT INTO dikNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Gokë bɛ̈ɛ̈r, “Ɣok aa kɔc dhiënh Abaram, ku acïn kɔc kɔ̈k cïï ɣo kaŋ loony. Ku na luel, ‘Wek aabï wɛ̈ɛ̈r bei,’ ke yeŋö wïc ba lueel?” ");
INSERT INTO dikNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Go Jethu lɛ̈k ke, “Yic alɛ̈k we, raan ëbën cä adumuɔ̈ɔ̈m looi yen alony adumuɔ̈ɔ̈m. ");
INSERT INTO dikNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Alony acie raan mac thok alanden, ku Wät yen ee raan thïn lanaɣɔn. ");
INSERT INTO dikNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Na cï Wät we wɛ̈ɛ̈r bei, ke wek aabï rëër ke cïn loony alanden. ");
INSERT INTO dikNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","“Aŋiɛc lɔn ye wek dhiën Abaram. Ku aŋot wiɛ̈ckë bäk ɣa nɔ̈k, rin piɔ̈ɔ̈cdiɛ̈ acäk ye gam. ");
INSERT INTO dikNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Kë cï Wä nyuɔ̈th ɣa yen aya lueel, ku wek aa loi kë cï wärkun lɛ̈k we.” ");
INSERT INTO dikNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Gokë bɛ̈ɛ̈r tënë ye, “Abaram yen ë wäda.” Go Jethu wɛ̈t dhuk nhom ku lueel, “Na we mïth Abaram alanden, ŋuɔ̈t wek aa loi këcït kë cï Abaram looi. ");
INSERT INTO dikNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Këriëëc ëbën ca looi ë rin ba we lɛ̈k yiny ca piŋ tënë Wä, ku aŋot wiɛ̈ckë bäk ɣa nɔ̈k. Abaram acïn kë cï looi cït kënë! ");
INSERT INTO dikNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Wek aa loi kë cï wärkun looi.” Gokë lueel, “Nhialic yetök yen ë Wäda, ku ɣok aa miɛ̈thke guɔ̈p.” ");
INSERT INTO dikNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Go Jethu bɛ̈ɛ̈r tënë ke, “Tɛ̈ ye Nhialic wuurdun guɔ̈p, ŋuɔ̈t wek nhiar ɣa, rin cï ɣɛn bɛ̈n tënë Nhialic, ku ëmën ɣɛn atɔ̈ tɛ̈n. Ɣɛn akëc bɛ̈n wɛ̈tdiɛ̈ ë rot, ee yen acä tooc. ");
INSERT INTO dikNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Yeŋö cïï wek kë ya lueel ye deet yic? Ee rin cïï wek ye lëu bäk wɛ̈tdiɛ̈ piŋ. ");
INSERT INTO dikNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ee jɔŋrac yen ë wuurdun, ku ayakë nhiaar bï ya kën wuurdun yen yakë looi. Yen ë raan ë tir tɛ̈thɛɛr ɣɔn, ku akëc yic kaŋ lueel rin ye yen alueeth, ku ye wun lueth ëbën. ");
INSERT INTO dikNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ɣɛn aluel yic, ku rin ë kënë yen akëc wek ɣa gam. ");
INSERT INTO dikNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Yeŋa kamkun lëu ye bï awuɔ̈c nyooth ɣaguɔ̈p rin adumuɔ̈ɔ̈m ca looi? Na luɛɛl yic, ke ye rin ŋö cïï wek ɣa ye gam? ");
INSERT INTO dikNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Raan bɔ̈ tënë Nhialic ë wɛ̈t Nhialic piŋ, wek aacïï bɔ̈ tënë Nhialic, ku yen ë kë cïï wek wɛ̈t bï piŋ.” ");
INSERT INTO dikNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Go kɔc Itharel bɛ̈ɛ̈r tënë Jethu, “Këcku wɛ̈t yic lueel wën lɔn ë yïn raan pan Thamaria, ku jɔŋrac atɔ̈ yïguɔ̈p?” ");
INSERT INTO dikNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Go Jethu bɛ̈ɛ̈r, “Acïn jɔŋrac tɔ̈ ɣaguɔ̈p, ɣɛn ë Wä theek ku wek aa ɣa dhɔ̈l guɔ̈p, ");
INSERT INTO dikNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ɣɛn acïï lɛcdiɛ̈ wïc. Raan wïc ye atɔ̈ thïn, ku ë wɛ̈t teem bä kony. ");
INSERT INTO dikNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Wɛ̈t yic alɛ̈k we, raan piŋ wɛ̈tdiɛ̈ acïï bï thou akölriëëc ëbën.” ");
INSERT INTO dikNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Go kɔc Itharel lɛ̈k yen. “Ëmën, aŋicku alanden lɔn tɔ̈ jɔŋrac yïguɔ̈p. Abaram acï thou, ku kɔc käk Nhialic tïŋ aacï thou aya ku ŋot ye lueel, ‘Raan piŋ wɛ̈tdiɛ̈ acïï bï thou akölriëëc ëbën.’ ");
INSERT INTO dikNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Abaram wäda acï thou, nadë ye lueel lɔn dïït yïn tënë Abaram? Ku kɔc käk Nhialic tïŋ aacï thou aya. Ye tak ye yïn ë ŋa?” ");
INSERT INTO dikNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Go Jethu bɛ̈ɛ̈r, “Na ɣa cï rot leec, ŋuɔ̈t lɛc kënë acie lɛc acïn. Ee Wä yen ë raan ɣa leec, ku yeen guɔ̈p ayakë lueel ke Nhialicdun. ");
INSERT INTO dikNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Yeen akɛ̈ckë kaŋ ŋic, ku yeen aŋiɛc. Na luɛɛl lɔn kuc ɣɛn ye, ke ɣɛn abï ya alueeth cïmëndun, ku yeen aŋiɛc, ku ɣɛn ë wɛ̈tde looi puɔ̈u ëbën. ");
INSERT INTO dikNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Wuurdun Abaram acï puɔ̈u miɛt apɛi lɔn bï yen aköl bɛ̈ndiɛ̈ tïŋ, acï tïŋ ku acï puɔ̈u la yum.” ");
INSERT INTO dikNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Go kɔc Itharel lɛ̈k ye, “Yïn aŋot yï këc ruɔ̈ɔ̈n thiärdhiëc dööt, ku yïn ca Abaram tïŋ?” ");
INSERT INTO dikNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Go Jethu bɛ̈ɛ̈r, “Wɛ̈t yic alɛ̈k we, wäär këc Abaram guɔ dhiëëth, ‘Ke Ɣɛn atɔ̈ thïn.’ ” ");
INSERT INTO dikNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Gokë aleel kuany bï kek ye biɔ̈ɔ̈k, go Jethu rot thiaan ku jiël ɣön Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Tɛ̈wën ciɛth Jethu, ke tïŋ raan cï dhiëëth ke cï cɔɔr. Go kɔcken ye buɔɔth thiëëc, ");
INSERT INTO dikNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","“Raan piööc, ye adumuɔ̈ɔ̈m cï ŋa looi cɔl ye adhiëth ke cï cɔɔr? Ye adumuɔ̈ɔ̈mde aye adumuɔ̈ɔ̈m kɔc ke dhiëth ye?” ");
INSERT INTO dikNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Go Jethu bɛ̈ɛ̈r, “Kë cï yen cɔɔr acie rin adumuɔ̈ɔ̈m cï looi, ayï rin adumuɔ̈ɔ̈m cï kɔc ke dhiëth ye looi, yeen acï cɔɔr bï riɛl luɔi Nhialic tïŋ yeguɔ̈p. ");
INSERT INTO dikNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ɣok aa dhil la tueŋ ɣo lui luɔi raan cä tooc ɣet tɛ̈ ŋot ruel akɔ̈l, wakɔ̈u abɔ̈, ku acïn raan bï ye lëu bï luui. ");
INSERT INTO dikNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ɣet aköl ŋoot ɣɛn pinynhom, ke ɣɛn ë ruɛl tënë kɔc.” ");
INSERT INTO dikNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Tɛ̈wën cï yen jam këlä, ke ŋuut piny ku nueen tiɔp luɛɛth, ku rɔɔth tiɔp mony wën nyin, ");
INSERT INTO dikNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ku lëk ye, “Lɔɔr lɔk yïnyin wär Thiloam.” (Ku wɛ̈tde yic, “Cï tooc.”) Go mony wën la ku lɔɔk yenyin, ku le dhuk ke ye piny tïŋ. ");
INSERT INTO dikNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Go kɔc akeu nhom ku kɔc cï ye kaŋ tïŋ ke lïm thiëc, “Cie mony dhie cool nyuc piiny ke lïm kënë?” ");
INSERT INTO dikNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Go kɔc kɔ̈k lueel, “Ee yeen guɔ̈p.” Ku lueel kɔc kɔ̈k, “Acie ye ë raan thöŋ kek ye.” Go mony wën nhom lueel, “Ee ɣɛn raan wën guɔ̈p.” ");
INSERT INTO dikNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Gokë thiëëc, “Cï rot lëu këdë ba bɛn daai?” ");
INSERT INTO dikNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Go bɛ̈ɛ̈r, “Mony cɔl Jethu acï tiɔp nueen ku rɔɔth ɣanyin ku lëk ɣa, ‘Lɔɔr wär Thiloam ku lɔk yïnyin.’ Guɔ la, ku kaam wën lɔɔk ɣɛn ɣanyin, ke ɣa tïŋ piny nyin yic.” ");
INSERT INTO dikNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Gokë thiëëc, “Yen ako?” Go bɛ̈ɛ̈r, “Akuɔ̈c.” ");
INSERT INTO dikNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Gokë mony wën cï cɔɔr thɛl tënë kɔc akut Parathï. ");
INSERT INTO dikNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Aköl nueen Jethu tiɔp ku rɔɔth raan nyin bï daai, ee ya aköl cïï kɔc ye luui. ");
INSERT INTO dikNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Go kɔc akut Parathï mony wën bɛn thiëëc tɛ̈ cï ye liɛp nyin thïn. Go lɛ̈k ke, “Yeen acï tiɔp tääu ɣanyin, ku laak ɣanyin, ku ëmën alëu ba piny tïŋ.” ");
INSERT INTO dikNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Go kɔc kɔ̈k akut Parathï lueel, “Raan cï kënë looi acïï lëu bï bɛ̈n tënë Nhialic, rin acï löŋ cïï kɔc ye luui thek.” Go kɔc kɔ̈k lueel, “Lëu këdë bï raan la guɔ̈p adumuɔ̈ɔ̈m kädït jäŋ gɔ̈i, cït käkkä, looi?” Gokë keyiic tek kamken. ");
INSERT INTO dikNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Go kɔc akut Parathï mony wën bɛn thiëëc, “Yïïn ye lueel lɔn cï yen yï liep nyin apath, ku yïïn ye lueel ye yen ŋa?” Go bɛ̈ɛ̈r, “Ee raan käk Nhialic tïŋ.” ");
INSERT INTO dikNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ee këc bäny Itharel gam lɔn cï yen cɔɔr ku ben nyin kuɛk, agut tɛ̈ bï kek kɔc ke dhiëth ye cɔɔl, ");
INSERT INTO dikNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ku thiëckë ke, “Ye manhdun kënë? Ayakë lueel lɔn cï ye dhiëëth ke ye cɔɔr, lëu këdë, bï piny tïŋ?” ");
INSERT INTO dikNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Go wun ku man bɛ̈ɛ̈r, “Aŋicku lɔn ye yen manhda, ku lɔn cï ye dhiëëth ke ye cɔɔr. ");
INSERT INTO dikNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ku akucku tɛ̈ cï yen piny jäl tiɛ̈ŋ thïn, ɣok aa kuc raan cï ye liep nyin aya. Thiëckë, yeen acï dït ku alëu bï këde bɛ̈ɛ̈r ë rot.” ");
INSERT INTO dikNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Wun ku man aacï jam këlä rin riɔ̈ɔ̈c kek bäny Itharel, rin cï kek ye mat lɔn kuat raan gam Jethu lɔn ë yen Raan cï lɔc ku dɔc, ka dhil cuɔp wei tɛ̈n amat kɔc Itharel. ");
INSERT INTO dikNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Rin kënë, yen ë lueel wun ku man ye ëlä, “Yeen acï dït, thiëckë!” ");
INSERT INTO dikNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Gokë mony wën cï dhiëëth ke cï cɔɔr bɛn cɔɔl arak dɛ̈t, ku lëkkë ye, “Kuɛ̈ɛ̈ŋ ë Nhialic nhom lɔn bï yïn yic lueel. Aŋicku lɔn mony kënë ë raan adumuɔ̈ɔ̈m.” ");
INSERT INTO dikNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Go mony wën bɛ̈ɛ̈r, “Akuɔ̈c lɔn ye yen raan la guɔ̈p adumuɔ̈ɔ̈m, wɛ̈t yen ŋiɛc, ɣɛn a ɣa ye cɔɔr ku ëmën ɣɛn ë piny tïŋ.” ");
INSERT INTO dikNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Gokë thiëëc, “Yeŋö cï looi tënë yïn? Cï nyiɛ̈nku kuek këdë?” ");
INSERT INTO dikNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Go bɛ̈ɛ̈r, “Aca lɛ̈k we wënthɛɛr, ku acäk ye piŋ. Ye rin ŋö wïc wek wɛ̈t bäk bɛn piŋ? Tɛ̈dɛ̈t wiɛ̈ckë aya bäk ya kɔcken ye buɔɔth?” ");
INSERT INTO dikNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Gokë lat ku luelkë, “Yïn acï ya raanden ye buɔɔth, ɣok aa kɔc Mothith. ");
INSERT INTO dikNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Aŋicku lɔn cï Nhialic jam tënë Mothith, ku na ye monytui, ka cɔkku kuc aya tɛ̈ bïï yen thïn!” ");
INSERT INTO dikNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Go mony wën bɛ̈ɛ̈r, “Kë gɛ̈i kɔc akïn! Akuɔ̈ckë tɛ̈ bïï yen thïn, ku yeen guɔ̈p acï nyiɛ̈nkiɛ̈ liep! ");
INSERT INTO dikNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Aŋicku lɔn cïï Nhialic wɛ̈t kɔc adumuɔ̈ɔ̈m ye piŋ, ku yeen ë wɛ̈t kɔc thek ye ku loikë luɔiden cï lɛ̈k ke piŋ. ");
INSERT INTO dikNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ɣɔnthɛɛr cɛk pinynhom akɛ̈c kaŋ piŋ lɔn le yen raan cï dhiëëth ke ye cɔɔr cï kuek nyin. ");
INSERT INTO dikNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Na cie lɔn bïï raan kënë tënë Nhialic, ka cïï lëu bï këcït kënë looi.” ");
INSERT INTO dikNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Gokë bɛ̈ɛ̈r, “Yïn acï dhiëëth ku muk yï adumuɔ̈ɔ̈m yic, ku wïc ba ɣo piɔ̈ɔ̈c?” Ku copkë wei tënë amat. ");
INSERT INTO dikNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Go Jethu piŋ lɔn cï kek ye cuɔp wei. Nawën yök ke lueel, “Ye wɛ̈t Manh Raan gam?” ");
INSERT INTO dikNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Go mony wën bɛ̈ɛ̈r, “Bɛ̈ny, lɛ̈k ɣa ye ŋa, rin ba lëu ba gam.” ");
INSERT INTO dikNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Go Jethu lɛ̈k ye, “Yeen aca tïŋ, ku yen ë raan jam kek yï ëmën.” ");
INSERT INTO dikNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Go mony wën lueel, “Bɛ̈ny aca gam.” Ku gut yenhiɔl piny Jethu nhom. ");
INSERT INTO dikNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Go Jethu lueel, “Ɣɛn acï bɛ̈n pinynhom tɛ̈n ba wɛ̈t teem, rin bï cɔɔr piny tïŋ, ku bï kɔc piny tïŋ jäl cɔɔr.” ");
INSERT INTO dikNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Go kɔc kɔ̈k akut Parathï rɛ̈ɛ̈r kek ye wël cï lueel piŋ ku thiëckë, “Ee ciɛ̈t wïc ba lueel lɔn ye ɣok cöör aya?” ");
INSERT INTO dikNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Go Jethu bɛ̈ɛ̈r, “Na we ye cöör ke wek aa cïn gup awuɔ̈c, ku rin ye wek ye lueel lɔn ye wek piny tïŋ, ke wɛ̈t kënë aye nyooth lɔn le wek gup awuɔ̈c.” ");
INSERT INTO dikNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Go Jethu lueel, “Wɛ̈t yic alɛ̈k we, raan cie tëëk kal amɛ̈l thok, ku lïr nhom tɛ̈dɛ̈t, yeen ë cuär, ku ë raan rum käŋ. ");
INSERT INTO dikNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ku raan tëk kal thok yen abiöŋ amɛ̈l. ");
INSERT INTO dikNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Raan tit kal abï kal ŋaany thok tënë ye, ku piŋ amɛ̈l rɔ̈lde tɛ̈ cɔɔl yen amälke ë riɛnken, ku thel ke aɣeer. ");
INSERT INTO dikNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ku tɛ̈ cï ke ɣäth aɣeer, ka cath tueŋ kenhïïm ku buɔɔth amɛ̈l cök rin ŋic kek rɔ̈lde. ");
INSERT INTO dikNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Aacïï raan dɛ̈t bï buɔɔth cök, aabï kat ye rin kuc kek rɔ̈lde.” ");
INSERT INTO dikNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Kääŋ kënë acï Jethu thäth ke, ku wɛ̈t lueel tënë ke akɛ̈ckë deet yic. ");
INSERT INTO dikNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Go Jethu bɛn lueel, “Wɛ̈t yic alɛ̈k we, ɣɛn ee kal thok tënë amɛ̈l. ");
INSERT INTO dikNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Kɔc kɔ̈k ëbën cï kaŋ bɛ̈n ɣanhom tueŋ, aa cuär ku aa kɔc rum käŋ, ku rɔ̈lden akëc amɛ̈l piŋ. ");
INSERT INTO dikNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ɣɛn ë kal thok. Raan bɔ̈ thïn thuɔŋdiɛ̈ abï luɔ̈k, yeen abï bɛ̈n alɔŋthïn ku ler aɣeer, ku yök wɛl path. ");
INSERT INTO dikNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Cuär ë bɛ̈n rin bï cuëër, ku nɛ̈k käŋ ku rɛc ke. Ɣɛn acï bɛ̈n bïk pïr yök, pïrdït alanden. ");
INSERT INTO dikNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ɣɛn abiöŋ path. Abiöŋ path aye wïc bï thou rin amälke. ");
INSERT INTO dikNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Raan lui ariöp ku cie raan abiöök ku cie wun amɛ̈l, ku tïŋ gɔl ke bɔ̈, ka päl amɛ̈l ku kɛt, bï gɔl thuɛɛt amɛ̈l yiic ku thiëi ke roor. ");
INSERT INTO dikNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Raan lui ariöp ë kat rin ë raan lui ariöp ë path, ku aliu puɔ̈u kegup. ");
INSERT INTO dikNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Ɣɛn abiöŋ path. Cïmën ŋic Wä ɣɛn ku ŋiɛc Wä, këya ɣɛn aŋic amälkiɛ̈ ku amälkiɛ̈ aa ŋic ɣa. Ku awiëc ba thou ë riɛnken. ");
INSERT INTO dikNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Amɛ̈l kɔ̈k aa tɔ̈ thïn ku aa käkkiɛ̈ ku aa liu thïn kal kënë yic. Keek aaba bɛ̈ɛ̈i aya, ku aabï rɔ̈ldiɛ̈ piŋ, ku keek aabï ya luɔ̈ny tökaliŋ kek raan töŋ biöök ke. ");
INSERT INTO dikNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Wä anhiar ɣa rin awiëc ba piɛ̈rdiɛ̈ puɔ̈l rin bï ɣɛn ye bɛn yök. ");
INSERT INTO dikNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Acïn raan bï piɛ̈rdiɛ̈ nyaai tënë ɣa. Yeen aya puɔ̈l wɛ̈t piändiɛ̈ ë rot. Ɣɛn ala riɛl ba päl wei, ku ɣɛn ala riɛl ba bɛn lööm.” ");
INSERT INTO dikNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Go kɔc Itharel keyiic bɛn tek kamken rin ë wëlkä. ");
INSERT INTO dikNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Kɔc juëc kamken aa yekë lueel, “Yeen ala guɔ̈p jɔŋrac! Yeen amuɔ̈l! Yeŋö ye wek wɛ̈lke piŋ?” ");
INSERT INTO dikNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Go kɔc kɔ̈k lueel, “Lëu raan la guɔ̈p jɔŋrac bï jam cïmën yen! Lëu jɔŋrac këdë bï cɔɔr cɔl akuek yenyin?” ");
INSERT INTO dikNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Aköl looi Yan Dɔ̈c luaŋ Nhialic Jeruthalem acï bɛ̈n, ku piny ë ye mɛ̈i. ");
INSERT INTO dikNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ku Jethu ë cath puɔk yic, cɔl puɔk Tholomon tɔ̈ luaŋ Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Go kɔc Itharel guëër yelɔ̈ɔ̈m ku luelkë, “Ɣet nɛn bï yïn ɣo cɔl arɛ̈ɛ̈r ɣo diu puɔ̈th? Lɛ̈k ɣo yic la gɛi, ye yïn Raan cï lɔc ku dɔc?” ");
INSERT INTO dikNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Go Jethu bɛ̈ɛ̈r, “Wɛ̈t aca lɛ̈k we ku wek aacie wɛ̈tdiɛ̈ ye gam. Luɔikiɛ̈n ya looi ë riɛl Wä, kek ajam ë riɛnkiɛ̈. ");
INSERT INTO dikNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ku wek aacie wɛ̈tdiɛ̈ ye gam rin cïï wek ye amälkiɛ̈. ");
INSERT INTO dikNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Amälkiɛ̈ aa rɔ̈ldiɛ̈ piŋ ku keek aŋiɛc ku keek aa ɣa buɔɔth cök. ");
INSERT INTO dikNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Pïr akölriëëc ëbën aya yiëk ke, ku keek aacïï bï kaŋ thou athɛɛr, ku acïn raan lëu ye bï ke rum tënë ɣa. ");
INSERT INTO dikNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Kë cï Wä yiëk ɣɛn awär këriëëc ëbën, ku acïn raan lëu ye bï ke rum Wä cin. ");
INSERT INTO dikNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Wä ku ɣɛn ɣok aa tök.” ");
INSERT INTO dikNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Go kɔc Itharel aleel bɛn kuany bïk biɔ̈ɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Go Jethu lɛ̈k ke, “Luɔi puɔth juëc cï Wä yiëk ɣɛn ba ke looi, aa ca looi wenhïïm, ye luɔi töŋ nɛn kamken yen wïc wek ye bäk ɣa biɔ̈ɔ̈k aleel?” ");
INSERT INTO dikNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Go kɔc Itharel bɛ̈ɛ̈r, “Yïn acuk wïc buk yï biɔ̈ɔ̈k aleel rin luɔi path, ku ë rin ye yïn Nhialic dɔl guɔ̈p. Yïn ë raan ë path, ku wïc ba rot looi ba ya Nhialic!” ");
INSERT INTO dikNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Go Jethu bɛ̈ɛ̈r, “Acï gɔ̈t lɔ̈ŋdun yic guɔ̈p lɔn cï Nhialic ye lueel, ‘Wek aa Nhialic.’ ");
INSERT INTO dikNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Aŋicku lɔn wɛ̈t cï gɔ̈t athör wël thɛɛr Nhialic yic ë yic alanden, ku kɔckä acï Nhialic cɔl, ‘Nhialic,’ kɔc cï Nhialic thɔ̈n wɛ̈tde. ");
INSERT INTO dikNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ku na ɣɛn, ke Wä cä cɔɔl ku tuuc ɣa pinynhom, ku ye këdë ye wek ye lueel lɔn cï ɣɛn Nhialic dɔl, ye rin cï ɣɛn ye lueel lɔn ye ɣɛn Wën Nhialic? ");
INSERT INTO dikNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Duɔ̈kkë wɛ̈tdiɛ̈ gam tɛ̈ cïï ɣɛn luɔi Wä loi. ");
INSERT INTO dikNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ku na ya ke looi, ku cɔk alɔn cïï wek wɛ̈tdiɛ̈ gam, ke we dhil luɔikiɛ̈ gam, bäk ŋic alanden lɔn Wä arɛ̈ɛ̈r kek ɣa ku ɣɛn atɔ̈ Wä yic.” ");
INSERT INTO dikNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Gokë wïc bïk dɔm, go ke käl nyïn. ");
INSERT INTO dikNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Go Jethu bɛn dhuk ciëën wär Jordan alɔŋtui tɛ̈wäär ye Joon kɔc muɔɔc nhïïm thïn, ku rëër thïn tɛ̈ɛ̈n. ");
INSERT INTO dikNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Go kɔc juëc bɛ̈n tënë ye ku luelkë, “Joon akëc käril looi, ku këriëëc ëbën cï lueel rin ë mony kënë aacï ya yith.” ");
INSERT INTO dikNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ku gam kɔc juëc wɛ̈tde ë tɛ̈në. ");
INSERT INTO dikNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Raan cɔl Ladhäro, ku ë rɛ̈ɛ̈r Bethanï, ëcï tuaany. Bethanï ë gen rëër Maria thïn kek nyankën cɔl Martha. ");
INSERT INTO dikNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maria kënë yen ë nyan wäär cï Bänyda tɔc cök miök ŋïr, ku wuuny ke nhiëmke. Ku ë mɛ̈nhë Ladhäro yen ëcï tuaany. ");
INSERT INTO dikNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Go nyiɛ̈rakën wɛ̈t tuɔ̈c Jethu, “Bɛ̈ny, mäthdun nhiar acï tuany.” ");
INSERT INTO dikNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Nawën piŋ Jethu ke lueel, “Tuɛny kënë acïï Ladhäro bï nɔ̈k, kënë acï rot looi bï Nhialic leec thïn. Ku yen ë tɛ̈ bï Wën Nhialic lɛc yök thïn.” ");
INSERT INTO dikNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ku Jethu ë nhiar Martha kek nyankën ku Ladhäro. ");
INSERT INTO dikNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Nawën cɔk piŋ lɔn cï Ladhäro tuaany, ke näk nïn karou tɛ̈wën rëër yen thïn. ");
INSERT INTO dikNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ku jɔl lɛ̈k kɔc ye buɔɔth, “Benku dhuk ciëën pan Judia.” ");
INSERT INTO dikNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Go kɔc ye buɔɔth lueel, “Raan piööc, wäär ëmën thiɔ̈ɔ̈k, ee wïc kɔc Itharel bïk yï biɔ̈ɔ̈k aleel, ku ye wïc ëmën ba bɛn dhuk thïn?” ");
INSERT INTO dikNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Go Jethu bɛ̈ɛ̈r, “Akäl tök cï yic la aköl ku wakɔ̈u? Tɛ̈ ciɛth raan ke ruɛl dït ke yeen acie kɔ̈th, rin ala ruɛl yen piny tïŋ. ");
INSERT INTO dikNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ku na ciɛth wakɔ̈u ka kɔ̈th, rin liu ruɛl tënë ye.” ");
INSERT INTO dikNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jethu acï wëlkä lueel ku mɛt dɛ̈t thïn, “Mäthda Ladhäro acï nïn wit, ku ɣɛn ala ba la puɔ̈ɔ̈c.” ");
INSERT INTO dikNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Go kɔc ye buɔɔth lueel, “Bɛ̈ny, na cï nïn ka bï ŋuɛ̈ɛ̈n.” ");
INSERT INTO dikNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ku wɛ̈t wïc Jethu bï lɛ̈k ke ë lɔn cï Ladhäro thou. Gokë tak lɔn jiɛɛm yen wɛ̈t nïn ë path. ");
INSERT INTO dikNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Go Jethu gai yic tënë ke, “Ladhäro acï thou, ");
INSERT INTO dikNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ku ɣɛn acï puɔ̈u miɛt ë riɛnkun ba kɛ̈c rëër kek ye, rin bäk gam. Jɔlku la tënë ye.” ");
INSERT INTO dikNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Go Thomath, cɔl Acueek, lɛ̈k atuuc, “Lokku ɣodhie kek Raan piööc, rin buk la thou kek ye.” ");
INSERT INTO dikNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Nawën ɣet Jethu ke yök lɔn cï Ladhäro thiɔ̈k ka la nïn kaŋuan raŋ yic. ");
INSERT INTO dikNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bethanï amec kek Jeruthalem tɛ̈cït tɛ̈n meel karou, ");
INSERT INTO dikNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ku kɔc juëc Itharel aake cï bɛ̈n bïk Martha kek Maria bɛ̈n dɛɛt puɔ̈th, rin wämënhden cï thou. ");
INSERT INTO dikNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Nawën piŋ Martha lɔn bïï Jethu, ke la aɣeer bï la rɔ̈m kek ye, ku dɔ̈ŋ Maria bei. ");
INSERT INTO dikNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Go Martha lɛ̈k Jethu, “Bɛ̈ny, na yï tɔ̈ thïn, ŋuɔ̈t wämääth akëc thou. ");
INSERT INTO dikNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ku aŋiɛc lɔn na cɔk amën ke Nhialic abï këriëëc ëbën ba thiëëc ye, gäm yï.” ");
INSERT INTO dikNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Go Jethu lɛ̈k ye, “Wämuuth abï rot jɔt bï pïr.” ");
INSERT INTO dikNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Go Martha bɛ̈ɛ̈r, “Aŋiɛc lɔn bï yen rot jɔt bï pïr aköl ciëën.” ");
INSERT INTO dikNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Go Jethu lɛ̈k ye, “Ɣɛn ë jön rot ku pïr. Raan gam wɛ̈tdiɛ̈, na cɔk alɔn thou yen ka bï pïr. ");
INSERT INTO dikNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ku kuat raan pïr ku gɛm wɛ̈tdiɛ̈ acïï bï kaŋ thou. Ca kënë gam?” ");
INSERT INTO dikNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Go lueel, “Ee këya, Bɛ̈ny. Aca gam lɔn ye yïn Raan cï lɔc ku dɔc, Wën Nhialic, bï dhiɛl bɛ̈n pinynhom.” ");
INSERT INTO dikNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Nawën cï Martha wëlkä lueel, ke dhuk ciëën ku cɔɔl nyanakën Maria amääth ku lueel, “Raan piööc atɔ̈ tɛ̈n ku awïc yï.” ");
INSERT INTO dikNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Nawën piŋ Maria wɛ̈t kënë, ke jɔt rot ku lɔc la aɣeer bï la rɔ̈m kek ye. ");
INSERT INTO dikNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ku Jethu ë ŋot këc ɣet baai, a ŋot rɛ̈ɛ̈r tɛ̈wën rɛ̈m yen thïn kek Martha. ");
INSERT INTO dikNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Go kɔc Itharel wën rɛ̈ɛ̈r ɣööt kek Maria rin bïk dɛɛt puɔ̈u, buɔɔth cök, wën tïŋ kek ye ke cï rot jɔt ku bɛn yekɔ̈u aɣeer. Ee cïk tak lɔn ler yen raŋ nhom bï la dhiau thïn. ");
INSERT INTO dikNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Wën ɣeet Maria tɛ̈wën rëër Jethu thïn, ke cuɛt rot piny yecök ku lueel, “Bɛ̈ny, na yï tɔ̈ thïn tɛ̈n ŋuɔ̈t wämääth akëc thou.” ");
INSERT INTO dikNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Nawën tïŋ Jethu ke dhiau, ku kɔc Itharel awën ruɛc ye ke dhiau aya, go keŋ yepuɔ̈u ku ŋeer yic apɛi. ");
INSERT INTO dikNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Go ke thiëëc, “Cäk thiɔ̈k tɛ̈no?” Gokë lueel, “Bɛ̈ny, bäär ba tïŋ.” ");
INSERT INTO dikNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Go Jethu dhiau. ");
INSERT INTO dikNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Go kɔc Itharel lueel, “Tiɛ̈ŋkë tɛ̈ nhiɛɛr yen ye thïn.” ");
INSERT INTO dikNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Go kɔc kɔ̈k kamken lueel, “Acï raan cï cɔɔr liep nyin, këc looi? Ku yeŋö këc yen Ladhäro kuɔ̈ny bei thou yic?” ");
INSERT INTO dikNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Go Jethu yic bɛn ŋɛɛr apɛi ku ler raŋ nhom, ku raŋ ëcï wec kuur yic, ku kuurdït acï tääu yethok. ");
INSERT INTO dikNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Go Jethu ke yɔ̈ɔ̈k, “Nyaaikë kuur.” Go Martha, nyanakën raan cï thou bɛ̈ɛ̈r, “Bɛ̈ny, acï nhiany. Nïn cï ye thiɔ̈k aa ŋuan.” ");
INSERT INTO dikNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Go Jethu lɛ̈k ye, “Kɛ̈c lɛ̈k yï lɔn bï yïn lɛc Nhialic tïŋ tɛ̈ gɛ̈m yïn?” ");
INSERT INTO dikNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Gokë kuur laar wei. Go Jethu yenyin ŋäär nhial ku lueel, “Wä yïn alɛɛc rin ye yïn ɣa piŋ, ");
INSERT INTO dikNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ku aŋiɛc lɔn ye yïn ɣa piŋ akölaköl, ku aluɛɛl rin bï kɔc tɔ̈ thïn tɛ̈n ye gam, lɔn cï yïn ɣa tooc.” ");
INSERT INTO dikNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Kaam wën cï yen wëlkä lueel ke cöt röldït, “Ladhäro, bäär aɣeer.” ");
INSERT INTO dikNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Go bɛ̈n aɣeer ke cï duut cök ku cin alanh thiëkthiëk, ku acï der nyin alath. Go Jethu lɛ̈k ke, “Däkkë ku calkë acath.” ");
INSERT INTO dikNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Go kɔc juëc Itharel cï bɛ̈n bïk Maria bɛ̈n neem, kë cï Jethu looi tïŋ, ku gamkë wɛ̈tde. ");
INSERT INTO dikNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ku dhuk kɔc kɔ̈k ciëën kamken tënë kɔc akut Parathï, bïk käk cï Jethu looi la lɛ̈k ke. ");
INSERT INTO dikNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Go kɔc akut Parathï ku kɔc käk Nhialic mat kek bɛ̈ny luk, ku luelkë, “Buk ŋö looi? Mony kënë ee luɔi ril apɛi looi! ");
INSERT INTO dikNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Na pälku bï la tueŋ këlä, ke kɔc ëbën abï wɛ̈tde gam, ku bäny Roma aabï bɛ̈n bïk luaŋ Nhialic thuɔ̈r piny ku rɛckë panda.” ");
INSERT INTO dikNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Go Kaipa yen ye raandït kɔc käk Nhialic ë ruɔ̈ɔ̈n kënë lueel, “Wɛ̈t tök akuɔ̈ckë! ");
INSERT INTO dikNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Cäk ye tïŋ lɔn aŋuɛ̈ɛ̈n tënë we bï raan tök thou rin kɔc, tɛ̈n tɛ̈ bï wuɔ̈nda riääk ëbën?” ");
INSERT INTO dikNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ku akëc wɛ̈t kënë lueel piände ë rot, ku ë rin ye yen raandït kɔc käk Nhialic ë ruɔ̈ɔ̈n kënë. Ku ë luel käk tueŋ bï röt looi lɔn bï Jethu thou rin thän Itharel, ");
INSERT INTO dikNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ku acie riɛnken kepɛ̈c, abï thou aya bï mïth Nhialic cï thiëi pinynhom kuɔ̈ɔ̈t yiic bïk aa tök. ");
INSERT INTO dikNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Jɔɔk aköl kënë ke bäny aake guïr bïk Jethu nɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Këya, go Jethu kɛ̈c bɛn acath ë path kam kɔc pan Judia, ku jiël bï la gen cɔl Epraim tɛ̈thiɔ̈k ke ror, ku rëër thïn kek kɔc ye buɔɔth. ");
INSERT INTO dikNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ku Yan Ayum cïn yic luɔi kɔc Itharel ëcï thiɔ̈k, go kɔc juëc jäl bääiken yiic bïk la Jeruthalem, bïk köc wuuny kek kegup yandït nhom tueŋ la looi. ");
INSERT INTO dikNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Gokë Jethu wïc, ku thiëckë röt kamken wën cï kek guëër luaŋ Nhialic, “Yeŋö yakë tak? Bï bɛ̈n yai yic, kua cïï bï bɛ̈n?” ");
INSERT INTO dikNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ku kɔc käk Nhialic ku kɔc akut Parathï aake cï wɛ̈t lueel, lɔn raan ŋic tɛ̈ rëër Jethu thïn adhil wɛ̈t lɛ̈k ke, ku bï dɔm. ");
INSERT INTO dikNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Nïn kadätem Yan Ayum cïn yic luɔu nhom tueŋ, ke Jethu la Bethanï, pan ciëŋ Ladhäro thïn, raan wäär cï jɔ̈t bei thou yic. ");
INSERT INTO dikNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Gokë miëth guiir tënë ye, miëth cï Martha bɛ̈n luui thïn apɛi. Ku Ladhäro atɔ̈ kam kɔc ke rɛ̈ɛ̈r thïn aya. ");
INSERT INTO dikNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Go Maria karjac cï thiäŋ miök ŋïr cɔl naar, ye ɣɔɔc wëëu juëc lööm, ku puk Jethu cök ku wuuny nhïmken nhom. Go aŋïr miök ɣöt rum yic ëbën. ");
INSERT INTO dikNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Go raan tök kam kɔc Jethu buɔɔth, cɔl Judath Ithkariöt, raan bï ye luɔm lueel, ");
INSERT INTO dikNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Yeŋö këc miök ŋïr kënë ɣaac wëëu juëc wär wëëu ye dɔ̈m raan tök, ku yïk ke kɔc ŋɔ̈ŋ?” ");
INSERT INTO dikNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ku ëcie rin nhiɛ̈r kɔc ŋɔ̈ŋ yen lueel yen kënë, ee rin ye yen cuär, ee ye wëëu akut muk, ku ë ye rot kony thïn. ");
INSERT INTO dikNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Go Jethu lueel, “Pälkë, calkë amuk miök rin aköl bï ɣa thiɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Kɔc ŋɔ̈ŋ aabï rëër thïn akölaköl kek we, ku ɣɛn acïï bï rëër kek we akölaköl.” ");
INSERT INTO dikNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Go kɔc juëc Itharel jäl ŋic lɔn tɔ̈ Jethu Bethanï, gokë la thïn, ku acie rin Jethu yetök, ee rin bïk Ladhäro la tïŋ aya, raan wäär cï Jethu jɔt kam kɔc cï thou. ");
INSERT INTO dikNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Go kɔc käk Nhialic wɛ̈t mat yic bïk Ladhäro nɔ̈k aya, ");
INSERT INTO dikNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","rin wɛ̈t Ladhäro yen aye kɔc juëc Itharel bänyken puɔ̈l ku gamkë wɛ̈t Jethu. ");
INSERT INTO dikNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Naɣɔn nhiääk dɛ̈t ke akutdït kɔc cï bɛ̈n Yan Ayum cïn yic luɔu yic, piŋ wɛ̈t lɔn bïï Jethu Jeruthalem. ");
INSERT INTO dikNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Gokë ayɔ̈r agɛ̈p lööm, ku lek bïk la lor, ku ketkë ëlä, “Lɛc tënë Nhialic! Nhialic dɔc raan bɔ̈ rin Bɛ̈ny! Nhialic dɔc Bɛ̈ny Itharel!” ");
INSERT INTO dikNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Go Jethu akaja yök ku nyuuc yekɔ̈u, cït tɛ̈ cï gät ye athör thɛɛr wël Nhialic yic, ");
INSERT INTO dikNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Duɔ̈kkë riɔ̈c kɔc Itharel! Yen kïn, Bänydun abɔ̈, ke cï nyuc akaja kɔ̈u.” ");
INSERT INTO dikNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ku käkkä aake këc kɔcken ye buɔɔth deet yiic, nawën cï Jethu rot jɔt ke lɛc, ke jɔlkë ŋic lɔn cï käkkä gɔ̈t athör thɛɛr wël Nhialic yic, ku lɔn cï kek käkkä looi tënë ye. ");
INSERT INTO dikNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ku kɔc juëc ke rɛ̈ɛ̈r thïn wäär cï Jethu Ladhäro caal aɣeer raŋ yic, ku jɔt kam kɔc cï thou, aake kë cïk tïŋ tɛ̈t kɔc. ");
INSERT INTO dikNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ku rin wɛ̈t kënë aya yen aa lor kɔc juëc ye, rin cï kek luɔidït jäŋ gɔ̈i cï looi piŋ. ");
INSERT INTO dikNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Go kɔc akut Parathï lueel kamken, “Cäk ye tïŋ lɔn cïn yen kë yökku thïn. Tiɛ̈ŋkë, aye thɛ̈i ëbën buɔɔth cök.” ");
INSERT INTO dikNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Kɔc Gïrïk kɔ̈k aake tɔ̈ kam kɔc cï la Jeruthalem bïk Nhialic la door thïn. ");
INSERT INTO dikNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Gokë bɛ̈n tënë Pilipo, raan Galilia pan Bethaida ku luelkë, “Bɛ̈ny, ɣok aa wïc Jethu buk tïŋ.” ");
INSERT INTO dikNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Go Pilipo wɛ̈t lɛ̈k Andria, ku lekkë karou tënë Jethu bïk la lɛ̈k ye. ");
INSERT INTO dikNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Go Jethu bɛ̈ɛ̈r, “Ëmën, aköl bï Manh Raan ya leec apɛi acï guɔ ɣëët. ");
INSERT INTO dikNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Wɛ̈t yic alɛ̈k we, nyin rap ë rëër ke ye tök ë path, tɛ̈ këc ye tääu tiɔp yic bï ciɛ̈t kë cï thou. Na le yic pät bï ciɛ̈t kë cï thou, ka jɔl luɔk mïth juëc. ");
INSERT INTO dikNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Raan nhiar piɛ̈rde, abï muɔ̈r ku raan man piɛ̈rde pinynhom tɛ̈n abï muk tënë pïr akölriëëc ëbën. ");
INSERT INTO dikNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Kuat raan wïc ye bï ɣɛn luɔ̈ɔ̈i ka dhil ɣa buɔɔth cök, rin tɛ̈ rëër ɣɛn thïn, aluɔnydiɛ̈ abï rëër thïn aya, ku Wä abï kuat raan luui ɣa leec. ");
INSERT INTO dikNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Piändiɛ̈ arem ëmën, ku ba ŋö lueel? Ba lueel, ‘Wä, duk kërɛɛc tit ɣa cɔl abɔ̈?’ Ku kënë ë yen cï ɣɛn bɛ̈n thïn, rin ba arɛɛm aköl kënë thöl. ");
INSERT INTO dikNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Wä, cɔl riɛnku alec!” Go röl jam nhial ku lueel, “Aca cɔl alec ku aba bɛn cɔl alec.” ");
INSERT INTO dikNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Go kɔc ke kääc thïn tɛ̈ɛ̈n röl piŋ ku luelkë, “Deŋ acï mär.” Go kɔc kɔ̈k lueel, “Atuny Nhialic acï jam tënë ye.” ");
INSERT INTO dikNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Tɛ̈ɛ̈në, go Jethu lɛ̈k ke, “Ee cie tënë ɣa yen jiɛɛm röl kënë, ee riɛnkun. ");
INSERT INTO dikNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ëmën, ë tɛ̈ bï luk teem tënë kɔc tɔ̈ pinynhom, ku bɛ̈ny jakrɛc abï cuɔp wei. ");
INSERT INTO dikNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Tɛ̈ cï ɣa jat nhial, ke ɣɛn abï kɔc ëbën miëët tënë ɣa.” ");
INSERT INTO dikNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ku wën lueel yen kënë, ke wïc bï nyuɔɔth yen tɛ̈ bï yen thou thïn. ");
INSERT INTO dikNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Go akut bɛ̈ɛ̈r tënë ye, “Wɛ̈t cï gɔ̈t athör yic ë ɣok lɛ̈k lɔn bï Raan cï lɔc ku dɔc, pïr akölriëëc ëbën. Na yïïn lëu këdë ba lueel lɔn bï Manh Raan jat nhial? Ku yeŋa yen Manh Raan?” ");
INSERT INTO dikNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Go Jethu bɛ̈ɛ̈r, “Aŋoot tɛ̈thin nyɔɔt bï ruɛl rëër kamkun. Lakkë tueŋ dhɔ̈ldun yic ëmën tɔ̈u ruɛl tënë we bï muɔ̈ɔ̈th we cïï döt, rin raan cath muɔ̈ɔ̈th yic akuc tɛ̈ ler yen thïn. ");
INSERT INTO dikNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Gamkë ruɛl ëmën ŋoot yen kek we, rin bäk aa kɔc ruɛl.” Tɛ̈wën cï Jethu wëlkä lueel ke la aɣeer ku thiɛɛn rot tënë ke. ");
INSERT INTO dikNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Na cɔk amën cï yen luɔi rilkä ëbën looi kenhïïm guɔ̈p, ke keek aa këc wɛ̈tde gam, ");
INSERT INTO dikNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","bï wɛ̈t cï Ithaya, raan käk Nhialic tïŋ kaŋ lueel thɛɛr yenhom tiɛɛŋ, wɛ̈tden wäär lueel ëlä, “Bɛ̈ny, yeŋa cï wɛ̈t cuk lɛ̈k kɔc gam? Yeŋa cï Bɛ̈ny nyuɔ̈th riɛl?” ");
INSERT INTO dikNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ku rin ë kënë acïn tɛ̈ bï kek gam, rin wɛ̈t kënë aya, acï Ithaya lueel ëlä, ");
INSERT INTO dikNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Aacï Nhialic dhɔ̈ny nyïn, ku mɛ̈r kepuɔ̈th. Bïk käŋ cïï tïŋ kenyïn, ku cïk wɛ̈t det kepuɔ̈th. Bïk röt wɛ̈l ɣɛn ku ba keek kony.” ");
INSERT INTO dikNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ithaya acï kënë lueel rin cï yen lɛc Jethu tïŋ ku jiɛɛm riɛnke. ");
INSERT INTO dikNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ku ëmën aya, ke bäny kɔc Itharel aake cï wɛ̈t Jethu gam, ku akëckë lueel kɔc nhïïm, rin riɔ̈c kek kɔc akut Parathï bïk ke cïï cop wei tɛ̈n amat. ");
INSERT INTO dikNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Aake lɛc kɔc nhiaar tënë lɛc Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Go Jethu lueel röldït kɔc nhïïm, “Raan gam wɛ̈tdiɛ̈ acie wɛ̈tdiɛ̈ rot yen ye gam, ee wɛ̈t raan toc ɣa gam aya. ");
INSERT INTO dikNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ku raan tïŋ ɣa, ka tïŋ raan cä tooc aya. ");
INSERT INTO dikNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ɣɛn acï bɛ̈n cïmën ruɛl pinynhom, bï raan ëbën gam wɛ̈tdiɛ̈ cïï ben rëër muɔ̈ɔ̈th yic. ");
INSERT INTO dikNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Raan piŋ wɛ̈tdiɛ̈ ku cïï lɔ̈k looi, ke ɣɛn acïn wɛ̈t ba tɛ̈m ye, rin këc ɣɛn bɛ̈n ba kɔc pinynhom bɛ̈n luk, ɣɛn acï bɛ̈n ba ke bɛ̈n pïïr. ");
INSERT INTO dikNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Raan kuec ë ɣa ku cïï wɛ̈tdiɛ̈ gam, raan bï ye tɛ̈m awuɔ̈c abï tɔ̈ thïn, ku wɛ̈tdiɛ̈n ca lɛ̈k kɔc abï ye luk aköl ciëën. ");
INSERT INTO dikNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ku ë këya, rin këc ɣɛn jam wɛ̈t piändiɛ̈ rot, ku ë Wä Aciëŋ toc ɣa, yen acï ɣa thɔ̈n kë ba dhiɛl lueel ku jaam ë yic. ");
INSERT INTO dikNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ku aŋiɛc lɔn ye wɛ̈tde pïr akölriëëc ëbën bɛ̈ɛ̈i. Käk ya lueel aa käk cï Wä nyuɔ̈th ɣa ba ke lueel.” ");
INSERT INTO dikNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ee ye aköl Yan Ayum cïn yic luɔu nhom tueŋ. Go Jethu ŋic lɔn cï aköl jiël yen pinynhom tɛ̈n jäl bɛ̈n, ku bï la tënë Wun. Yeen acï kɔcken rɛ̈ɛ̈r pinynhom nhiaar alanden, ku nhiɛɛr ke ɣet tɛ̈ bï wɛ̈t thök. ");
INSERT INTO dikNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jethu ku kɔcken ye buɔɔth aake cï nyuc bïk miëth thëi cam. Ku jɔŋrac ëcï wɛ̈t tääu Judath, wën Thaimon Ithkariöt puɔ̈u, bï Jethu gaany. ");
INSERT INTO dikNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Go Jethu ŋic lɔn cï Wun riɛl ëbën tääu yecin, ku ë ŋic lɔn cï yen bɛ̈n tënë Nhialic, ku ë ben dhuk tënë ye. ");
INSERT INTO dikNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Go rot cuɔt wei tɛ̈wën mïth kek thïn ku dɛ̈k alanh kɔ̈u, ku ruk alanh wuɔ̈ny ye aŋum. ");
INSERT INTO dikNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ku jɔl pïu puɔ̈k aduɔ̈k yic ku lɔɔk kɔcken ye buɔɔth cök, ku wuuny ke alanh wuɔ̈ny wën cï ruɔ̈k ye aŋum. ");
INSERT INTO dikNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ku jɔl bɛ̈n tënë Thaimon Pïtɛr, go Pïtɛr lɛ̈k ye, “Ye yïn bä lɔɔk cök, Bɛ̈ny?” ");
INSERT INTO dikNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Go Jethu bɛ̈ɛ̈r tënë ye, “Ke luɔɔi acïï ye deet yic ëmën, ku aba lɔ̈k deet yic.” ");
INSERT INTO dikNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Go Pïtɛr lueel, “Yïn acïï ɣa bï kaŋ lɔɔk cök acïn.” Go Jethu bɛ̈ɛ̈r, “Na cä yï lɔk cök, ke yïn acïn tɛ̈ bï yïn bɛn a raandiɛ̈.” ");
INSERT INTO dikNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Go Thaimon Pïtɛr lueel, “Bɛ̈ny, na ye këya ke yï duk ɣa lɔk cök ë rot, lɔk ɣacin ku ɣanhom aya.” ");
INSERT INTO dikNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Go Jethu lueel, “Raan cï laak acïn guɔ̈p acuɔl, ku abï yecök lɔɔk rot. Wek aa ɣer ëbën, ke raan tök kamkun yen acïï ɣer.” ");
INSERT INTO dikNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jethu ë ŋic raan bï ye gaany, yen ë lueel yen ye ëlä, “Wek aa ɣer wedhie, ke raan tök yen acïï ɣer.” ");
INSERT INTO dikNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Nawën cï Jethu ke lɔɔk cök, ke ben alanhde ruɔ̈k ku nyuuc tɛ̈den wën rëër yen thïn, ku thiëëc ke, “Cäk käk ca looi tënë we ëmën deet yiic? ");
INSERT INTO dikNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Wek aa ɣa cɔɔl raan piööc ku Bɛ̈ny, ku yeen apath bäk looi këya, rin ë ɣa. ");
INSERT INTO dikNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ɣɛn ë Bɛ̈ny ku Raan piööc tënë we, ku ŋot we laak cök. Ke week aya, wek aabï wecök lɔɔk kamkun, ŋɛk kek ŋɛk. ");
INSERT INTO dikNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Wɛ̈t path aca nyuɔ̈th we, bäk looi cïmën cï ɣɛn ye looi tënë we. ");
INSERT INTO dikNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Wɛ̈t yic alɛ̈k we, acïn alony dït tënë bänyde, ku acïn atuny dït tënë raan toc ye. ");
INSERT INTO dikNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ëmën ŋic wek wɛ̈t yic kënë, tɛ̈ looi wek ye, ke miɛt puɔ̈u dït abäk yök thïn. ");
INSERT INTO dikNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ɣɛn acïï jam ë riɛnkun ëbën, ɣɛn aŋic kɔc ca kuɛ̈ny bei. Ku wɛ̈t cï gɔ̈t athör thɛɛr wël Nhialic yic ëlä, ‘Raan mïth ɣok aduäŋ tök yic acie nhom wɛ̈l ɣa,’ adhil yenhom tiɛɛŋ. ");
INSERT INTO dikNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Wek aa lɛ̈k wɛ̈t kënë ëmën ke këc rot guɔ looi, rin aköl bï yen rot looi ka bäk jäl gam lɔn, ‘Ye Ɣɛn Yeen.’ ");
INSERT INTO dikNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Wɛ̈t yic alɛ̈k we, raan lor raan ca tooc, acä lor aya, ku raan lor ɣɛn ka lor raan toc ɣɛn aya.” ");
INSERT INTO dikNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Nawën cï Jethu wëlkä lueel, ke ŋɛɛr yic ku lueel, “Wɛ̈t yic alɛ̈k we, raan tök kamkun abï ɣa gaany.” ");
INSERT INTO dikNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Go kɔc ye buɔɔth kenyïn liääth kamken ke cï nhïïm la dïl apɛi wɛ̈t ye lueel. ");
INSERT INTO dikNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ku raan töŋ nhiɛɛr Jethu kam kɔc ye buɔɔth, ëcï nyuc Jethu lɔ̈ɔ̈m, ");
INSERT INTO dikNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","go Pïtɛr nieu nyïn ku lueel, “Thiëc, ye raan nɛn yen jiɛɛm yen riɛnke.” ");
INSERT INTO dikNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Go atuny kënë rot cuɔ̈t Jethu ku thiëëc, “Bɛ̈ny, ye yen ë ŋa?” ");
INSERT INTO dikNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Go Jethu bɛ̈ɛ̈r, “Ee raan bï ɣɛn ayup luɔ̈t kada yic ku yiëk ye.” Ku lööm ayum ku lut kada yic ku yïk Judath, wën Thaimon Ithkariöt. ");
INSERT INTO dikNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Tɛ̈wën lööm Judath ayup, ke jɔŋrac go la yeguɔ̈p. Go Jethu lɛ̈k ye, “Kë wïc ba looi, lɔc looi.” ");
INSERT INTO dikNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ku acïn raan kam kɔc ke mïth kek ye cï wɛ̈t deet yic, ye rin ŋö yen jiɛɛm Jethu këya tënë ye. ");
INSERT INTO dikNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ku rin yen Judath yen wɛ̈ɛ̈uken muk, ke cï kɔcken kɔ̈k tak lɔn cï Jethu ye lɛ̈k ye bï la ɣɔɔc kä wïckë rin yai, tɛ̈dë ke cï lueel bï kɔc ŋɔ̈ŋ muɔɔc. ");
INSERT INTO dikNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ku kaam wën lööm Judath ayup, ke la aɣeer. Ku ë ye wakɔ̈u. ");
INSERT INTO dikNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Wën cï Judath jäl, ke lueel Jethu, “Ëmën lɛc Manh Raan acï nyuɔ̈th kɔc, ku lɛc Nhialic acï nyuɔ̈th kɔc ë ye. ");
INSERT INTO dikNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ku tɛ̈ cï lɛc Nhialic nyuɔ̈th kɔc ë ye, ke Nhialic abï lɛc Manh Raan nyuɔɔth yeguɔ̈p, ku abï lac looi nyin yic. ");
INSERT INTO dikNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Miɛ̈thkiɛ̈, ɣɛn acïï bï rëër kek we apɛi. Wek abä wïc, ku alɛ̈k we ëmën yen wɛ̈t ca lɛ̈k kɔc Itharel, ‘Acïn tɛ̈ bï wek la tɛ̈ ler ɣɛn thïn.’ ");
INSERT INTO dikNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Löŋ yam ayiëk we, nhiarkë röt kamkun, cïmën cï ɣɛn we nhiaar, këya, ke wek aa dhil röt nhiaar kamkun. ");
INSERT INTO dikNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Na nhiarkë röt kamkun ka bï ŋic kɔc ëbën lɔn ye wek kɔckiɛ̈n ɣa buɔɔth.” ");
INSERT INTO dikNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Go Thaimon Pïtɛr thiëëc, “Na yïïn lɔrdë Bɛ̈ny?” Go Jethu bɛ̈ɛ̈r, “Tɛ̈ ler ɣɛn thïn acïn tɛ̈ buɔɔth yïn ɣacök ëmën, ku yïn abä buɔɔth aköldä.” ");
INSERT INTO dikNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Go Pïtɛr thiëëc, “Bɛ̈ny, yeŋö cïï ɣɛn ye lëu ba yï buɔɔth ëmën? Atɔ̈u ɣapuɔ̈u ba thou ë riɛnku.” ");
INSERT INTO dikNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Go Jethu bɛ̈ɛ̈r, “Lëu ba thou alanden ë riɛnkiɛ̈? Wɛ̈t yic alɛ̈k yï. Tɛ̈ ŋot këc thɔn ajïth kiu, aba lueel arak diäk lɔn kuc yïn ɣa.” ");
INSERT INTO dikNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Go Jethu lɛ̈k ke, “Duɔ̈kkë diɛɛr ku rɛ̈ɛ̈rkë we rac puɔ̈th. Gamkë Nhialic ku gamkë ɣa aya. ");
INSERT INTO dikNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Pan Wä ala yic ɣööt juëc, ku ɣɛn ala ba piny la guiir tënë we. Na cie yic wɛ̈t kënë, ŋuɔ̈t akɛ̈c lɛ̈k we. ");
INSERT INTO dikNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ku tɛ̈ cï ɣɛn la ba piny la guiir tënë we, ke ɣɛn abï dhuk ba we mat tɛ̈diɛ̈ rin bäk rëër tɛ̈ tɔ̈u ɣɛn thïn. ");
INSERT INTO dikNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ku dhël bï wek ɣet tɛ̈ le ɣɛn thïn aŋiɛckë.” ");
INSERT INTO dikNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Go Thomath lɛ̈k ye, “Bɛ̈ny, ɣok aa kuc tɛ̈ le yïn thïn, ku buk dhël bï ɣok ɣet tɛ̈ tɔ̈ yïn thïn ŋic këdë?” ");
INSERT INTO dikNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Go Jethu bɛ̈ɛ̈r tënë ye, “Ɣɛn ee dhël ku yic ku pïr, acïn raan la tënë Wä tɛ̈ cïï yen riɛnkiɛ̈.” ");
INSERT INTO dikNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ku lëk ke, “Ëmën cï wek ɣa ŋic, ke wek aabï Wä ŋic aya, ku ëmën ɣet tueŋ, aŋiɛckë ku acäk tïŋ.” ");
INSERT INTO dikNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Go Pilipo lueel, “Bɛ̈ny, nyuɔ̈th ɣo Wuur, yen ee kë wïcku yetök.” ");
INSERT INTO dikNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Go Jethu bɛ̈ɛ̈r, “Ɣɛn acï ceŋ apɛi kek we, ku yïn aŋot yï këc ɣa ŋic, Pilipo? Raan cä tïŋ, acï Wä tïŋ aya. Yeŋö ë yïn ye lueel, ‘Nyuɔ̈th ɣo Wuur?’ ");
INSERT INTO dikNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Kɛ̈c gam yïn Pilipo, lɔn rëër ɣɛn Wä yic ku Wä ɣayic?” Ku jɔl Jethu lɛ̈k kɔcken ye buɔɔth, “Wël ca lɛ̈k we aacie wël bɔ̈ bei tënë ɣa. Wä rɛ̈ɛ̈r ɣayic, yen ë luɔide looi. ");
INSERT INTO dikNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Gamkë wɛ̈tdiɛ̈ lɔn rëër ɣɛn Wä yic ku lɔn tɔ̈ Wä ɣayic. Na liu gam ke gamkë rin luɔikiɛ̈. ");
INSERT INTO dikNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Wɛ̈t yic alɛ̈k we, raan gam wɛ̈tdiɛ̈ abï luɔi ya looi a looi, ku tɛ̈dɛ̈t abï luɔidït tɛ̈në luɔidiɛ̈ a looi, rin ler ɣɛn tënë Wä. ");
INSERT INTO dikNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ku këriëëc ëbën bäk thiëëc ë riɛnkiɛ̈ aba looi, rin bï lɛc Wun nyuɔɔth rin Wënde. ");
INSERT INTO dikNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Tɛ̈ thiëëc wek këdäŋ ë riɛnkiɛ̈, ka ba looi. ");
INSERT INTO dikNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Na nhiarkë ɣa, ke we piŋ lɔ̈ɔ̈ŋkiɛ̈. ");
INSERT INTO dikNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ɣɛn abï Wä thiëëc ku abï we yiëk raan dɛ̈t kɔc kony, ku ye Wëi ë yic bï rëër kek we akölriëëc ëbën. ");
INSERT INTO dikNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Acïn tɛ̈ bï kɔc pinynhom ye gam, rin acïk lëu bïk tïŋ ku cïk lëu bïk ŋic. Ku yeen aŋiɛckë rin yen adɔ̈ŋ kek we ku aciëŋ kek we. ");
INSERT INTO dikNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Wek aacä bï puɔ̈l wepɛ̈c, ɣɛn abï dhuk tënë we. ");
INSERT INTO dikNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Aŋoot tɛ̈thin-nyɔɔt ku kɔc pinynhom aacïï ɣa bï bɛn tïŋ ku wek aabä tïŋ, ku rin pïïr ɣɛn, ke wek aabï pïr aya. ");
INSERT INTO dikNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Tɛ̈ ler aköltui bɛ̈n ka bäk ŋic lɔn tɔ̈ ɣɛn Wä yic ku lɔn rëër ɣɛn weyiic. ");
INSERT INTO dikNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Raan gam lɔ̈ɔ̈ŋkiɛ̈ ku looi ke, yen ë raan nhiar ɣa. Ku raan nhiar ɣa abï Wä nhiaar, ku yeen aba nhiaar aya, ku ɣɛn abï rot nyuɔ̈th ye.” ");
INSERT INTO dikNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Go Judath lueel, ku yeen acie Judath Ithkariöt, “Bɛ̈ny, bï rot lëu këdë ba rot nyuɔ̈th ɣo ku cïï rot nyuth kɔc pinynhom?” ");
INSERT INTO dikNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Go Jethu bɛ̈ɛ̈r tënë ye, “Raan nhiar ɣa, ka piŋ wɛ̈tdiɛ̈ ku yeen abï Wä nhiaar, ku ɣok aabï bɛ̈n tënë ye ɣok Wä buk pïr kek ye. ");
INSERT INTO dikNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Raan cïï ɣa nhiar acie wɛ̈tdiɛ̈ ye piŋ. Wɛ̈t cäk piŋ tënë ɣa acie wɛ̈tdiɛ̈, ee wɛ̈t bɔ̈ tënë Wä raan toc ɣa. ");
INSERT INTO dikNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Wëlkä aaca lɛ̈k we ëmën ŋoot ɣɛn kek we. ");
INSERT INTO dikNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ku raan kɔc kony, Wëi Nhialic bï Wä tuɔ̈ɔ̈c ë riɛnkiɛ̈ yen abï we piɔ̈ɔ̈c këriëëc ëbën ca lɛ̈k we. ");
INSERT INTO dikNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Dɔ̈ɔ̈r aya nyääŋ piny ke we, ku dɔ̈ɔ̈rdiɛ̈ guɔ̈p ayiëk we. Acä ye gäm we cïmën ye kɔc piny ye yiëk kɔc. Duɔ̈kkë yiic ŋɛɛr ku duɔ̈kkë riɔ̈c. ");
INSERT INTO dikNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Acäk piŋ ke luɛɛl tënë we ëlä, ‘Ɣɛn ajiël ku ɣɛn abï la dhuk tënë we.’ Na nhiarkë ɣa ke wek aabï puɔ̈th miɛt rin ler ɣɛn tënë Wä, rin adït tënë ɣa. ");
INSERT INTO dikNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Kënë aca lɛ̈k we ëmën ke ŋot këc rot guɔ looi, na le rot looi ke bäk gam. ");
INSERT INTO dikNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Acä lëu ba jam apɛi kek we ëmën, rin jɔŋ pinynhom abɔ̈. Ku yeen acïn riɛl tënë ɣa. ");
INSERT INTO dikNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ku adhil kɔc pinynhom ŋic lɔn nhiɛɛr ɣɛn Wä, yen ë rin ye ɣɛn këriëëc ëbën ye thɔ̈n ɣa looi. “Bäk, jiëlku tɛ̈n. ");
INSERT INTO dikNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Ɣɛn abiëny yic ku Wä ë raan dom, ");
INSERT INTO dikNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","yen ee kuat kër cie luɔk tɔ̈ ɣakɔ̈u tɛɛm wei, ku teem kuat kër luɔk nhom, rin bï nyäc bï ŋiɛc luɔk apɛi. ");
INSERT INTO dikNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Wek aacï jäl piath rin piööc ca yiëk we. ");
INSERT INTO dikNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Rɛ̈ɛ̈rkë akut yic kek ɣa, ku ɣɛn abï rëër akut yic kek we. Kër acie luɔk ë rot, alëu bï looi tɛ̈ rëër yen abiëc yic. Këya, acäk lëu bäk luɔk tɛ̈ cïï wek rɛ̈ɛ̈r ɣayic. ");
INSERT INTO dikNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ɣɛn abiëc ku wek aa kër. Raan rɛ̈ɛ̈r ɣayic ku ɣɛn yeyic abï luɔk apɛi, rin week acïn kë lɛ̈ukë bäk looi tɛ̈ liu ɣɛn tënë we. ");
INSERT INTO dikNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Raan cie rëër ɣayic ka ya cuat wei cïmën kër tim ku bï riɛl, ku kuat kërkä aabï kuɔ̈ɔ̈t yiic ku cuɛt ke mɛɛc tɛ̈ bï kek dëp thïn. ");
INSERT INTO dikNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Na rɛ̈ɛ̈rkë ɣayic, ku rɛ̈ɛ̈r wɛ̈lkiɛ̈ wepuɔ̈th ke këriëëc ëbën bäk thiëëc ku wiɛ̈ckë, ka bäk yök. ");
INSERT INTO dikNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Lɛc Wä aye nyuɔɔth tɛ̈ lok wek apɛi, ku këya, ke wek aabï ya kɔckiɛ̈n ɣa buɔɔth. ");
INSERT INTO dikNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Wek aa nhiaar cïmën nhiɛɛr Wä ɣɛn, rɛ̈ɛ̈rkë nhiɛ̈rdiɛ̈ yic. ");
INSERT INTO dikNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Na thɛkkë lɔ̈ɔ̈ŋkiɛ̈ ke wek aabï rëër nhiɛ̈rdiɛ̈ yic cïmën cï ɣɛn lööŋ Wä buɔɔth yiic, ku rɛ̈ɛ̈r nhiɛ̈rde yic. ");
INSERT INTO dikNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Kënë aca lɛ̈k we, bï miɛt puɔ̈u tɔ̈ tënë ɣa täu wepuɔ̈th aya, ku bï miɛt piändu thääp ë dït. ");
INSERT INTO dikNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ku lɔ̈ŋdiɛ̈ akïn, nhiarkë röt cïmën cï ɣɛn we nhiaar. ");
INSERT INTO dikNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nhiɛ̈rdït tet lëu raan bï yiëk mäthke, ee gɛm wɛ̈ike ë riɛnken. ");
INSERT INTO dikNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ku wek aa mäthkiɛ̈ tɛ̈ looi wek käk ca lɛ̈k we. ");
INSERT INTO dikNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Wek aacä bï bɛn cɔɔl aloony, rin alony akuc käk ye wun baai looi. Ku wek aaya cɔɔl mäthkiɛ̈, rin cï ɣɛn këriëëc ëbën ca piŋ tënë Wä nyuɔ̈th we. ");
INSERT INTO dikNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Aacie wek cä lɔc, ee ɣɛn acï we lɔc, ku wek aaca tooc bäk la bäk la luui apɛi, luɔi bï döŋ athɛɛr. Ku Wä abï këriëëc ëbën cäk thiëëc ë riɛnkiɛ̈ yiëk we, ");
INSERT INTO dikNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","kë thɔ̈n we akïn, nhiarkë röt kamkun. ");
INSERT INTO dikNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Na man kɔc pinynhom we, ke dhiɛlkë tak lɔn cï kek ɣa kaŋ maan. ");
INSERT INTO dikNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Na we kɔc pinynhom, ke kɔc pinynhom aabï we nhiaar rin ye wek kacken, ku wën cï ɣɛn we kuɛ̈ny bei pinynhom, ke wek aacie kɔc pinynhom, ku rin ë wɛ̈t kënë, kɔc pinynhom aa man we. ");
INSERT INTO dikNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Muɔ̈kkë wɛ̈t ca lɛ̈k we nhom, ‘Acïn alony dït tënë bänyde.’ Na jörkë ɣa, ke keek aabï we jöör aya, na piŋkë wɛ̈tdiɛ̈, ke keek aabï wɛ̈tdun piŋ aya. ");
INSERT INTO dikNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ku keek aabï käkkä looi ëbën tënë we rin ye wek kackiɛ̈, rin kuc kek raan cä tooc. ");
INSERT INTO dikNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Na ɣa këc bɛ̈n ku cä jam tënë we, ŋuɔ̈t aa këc gup la adumuɔ̈ɔ̈m, ku cït ëmën këlä, acïn tɛ̈ bï ke bɛn puɔ̈l rin adumuɔ̈ɔ̈mken. ");
INSERT INTO dikNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Raan man ɣa, ee Wä maan. ");
INSERT INTO dikNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Na ɣa këc luɔikä kaŋ looi kamken, käk cïn raan cï ke kaŋ looi, ŋuɔ̈t aa cïn gup adumuɔ̈ɔ̈m, cït ëmën këlä, aacï käk ca looi tïŋ, ku keek aa ŋot ke man ɣa ku Wä aya. ");
INSERT INTO dikNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ku kënë adhil rot looi këya bï wɛ̈t cï gɔ̈t lɔ̈ŋden yic rot tiɛɛŋ, ‘Keek aa man ɣa ë path ke cïn wɛ̈t yic.’ ");
INSERT INTO dikNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Raan kuɔɔny abï bɛ̈n, Wëi Nhialic abï yiny Nhialic nyooth, ku yeen abɔ̈ tënë Wä. Yeen aba tuɔ̈c we tënë Wä, ku yeen abï jam ë riɛnkiɛ̈. ");
INSERT INTO dikNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ku week aya wek aabï jam ë riɛnkiɛ̈ rin cï wek rëër ke ɣa thɛɛr. ");
INSERT INTO dikNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Kënë aca lɛ̈k we bäk gamdun cïï päl. ");
INSERT INTO dikNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Wek aabï cuɔp wei tɛ̈n amat. Ku kaam abï bɛ̈n, tɛ̈ bï kuat raan näk we ye tak lɔn na looi kënë, ke yeen aluui Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Keek aabï käkkä looi tënë we, rin kuc kek Wä ku kuckë ɣa. ");
INSERT INTO dikNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Käkkä aaca lɛ̈k we, rin aköl bï kek käkkä looi, ka jälkë tak lɔn cï ɣɛn ye kaŋ lɛ̈k we. “Wëlkä aa kɛ̈c lɛ̈k we wäär tueŋ rin rëër ɣɛn kek we. ");
INSERT INTO dikNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ku ëmën ɣɛn ala tënë raan cä tooc, ku aŋot cïn raan kamkun ɣa thiëëc, ‘Na yïïn lɔr dë?’ ");
INSERT INTO dikNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ku ëmën cï ɣɛn ye lɛ̈k we, wek aacï puɔ̈th jiɛth. ");
INSERT INTO dikNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Wɛ̈t yic alɛ̈k we, aŋuɛ̈ɛ̈n tënë we lɔn jiël ɣɛn, rin na cä jiël ke raan kɔc kony acïï bï bɛ̈n tënë we. Ku na jäl ke yen aba la tuɔ̈c we. ");
INSERT INTO dikNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ku na bïï, ka bï nyuɔ̈th kɔc pinynhom lɔn rɛɛc kek rin wɛ̈t adumuɔ̈ɔ̈m, ku rin wɛ̈t ciɛɛŋ path ku wɛ̈t luŋ Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Keek aa rɛc rin wɛ̈t adumuɔ̈ɔ̈m, rin këc kek ɣa gam, ");
INSERT INTO dikNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","rin wɛ̈t ciɛɛŋ path cï ladiɛ̈ tënë Wä nyuɔɔth, ku kë cïï wek ɣɛn bï bɛn tïŋ. ");
INSERT INTO dikNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ku keek aa rɛc rin luk, rin cï bɛ̈ny pinynhom tɛ̈n luɔ̈k wei. ");
INSERT INTO dikNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ɣɛn ala käjuëc kɔ̈k ba lɛ̈k we, ku ëmën aril yic bäk ke muk wenhïïm. ");
INSERT INTO dikNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ku na bɔ̈ Wëi Nhialic yen ë yic, ka bï we nyuɔ̈th wël yith ëbën. Yeen acïï bï jam wɛ̈lke ë rot, ku käk ye piŋ aabï lɛ̈k we. ");
INSERT INTO dikNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Yeen aba leec, rin bï yen këdiɛ̈n ba lueel lööm ku nyuth we. ");
INSERT INTO dikNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Käk Wä ëbën aa käkkiɛ̈, ku ë yen acï ɣɛn ye lueel lɔn bï Wëi käk ba yiëk ye lööm, ku jɔl ke lɛ̈k we. ");
INSERT INTO dikNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Aŋoot kaam thin nyɔɔt, ku wek aacïï ɣa bï tïŋ, ku na ben a kaam thin nyɔɔt ke we abï ɣɛn bɛn tïŋ.” ");
INSERT INTO dikNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Go kɔc kɔ̈k kam kɔcken ye buɔɔth lueel, “Kënë wɛ̈tde yic yeŋö? Aye lɛ̈k ɣo, kaam thin-nyɔɔt ke week aacïï ɣa bï bɛn tïŋ, ku ben a kaam thin-nyɔɔt ku wek aabï ɣa tïŋ? Ku lueel aya, ‘Ee rin ler ɣɛn tënë Wä.’ ” ");
INSERT INTO dikNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Gokë thiëc, “Kam thin-nyɔɔt kënë wɛ̈tde yic ako? Kë wïc bï lueel akucku!” ");
INSERT INTO dikNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Go Jethu ŋic lɔn wïc kek ye bïk thiëëc, ku lëk ke, “Aca lueel, ‘Kam thin nyɔɔt ke wek aacïï ɣa bï tïŋ, ku na ben a kaam dɛ̈t ke wek aabï ɣa tïŋ.’ Ye wɛ̈t kënë yen yakë thiëëc kamkun? ");
INSERT INTO dikNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Wɛ̈t yic alɛ̈k we, wek aabï dhiau ku dhuɔ̈ɔ̈rkë apɛi, ku kɔc pinynhom aabï puɔ̈th miɛt, ku wek aabï puɔ̈th rɛ̈ɛ̈c, ku rɛ̈ɛ̈c piändun abï wel tënë we bï ya miɛt puɔ̈u. ");
INSERT INTO dikNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Na thiɔ̈k tik kek dhiëth ka rac puɔ̈u rin cï aköl reem ye ɣëët, ku na cï meth jäl dhiëëth ka arɛɛm wën acïï ben tak rin cï yen puɔ̈u miɛt, rin cï yen meth dhiëëth pinynhom. ");
INSERT INTO dikNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ku acït kënë tënë we aya, wek aa rɛc puɔ̈th ëmën, ku wek aabä bɛn tïŋ, ku wek aabï kuɛth miɛt ë puɔ̈u, kuat miɛt puɔ̈u cïn raan bï ye bɛn nyaai tënë we. ");
INSERT INTO dikNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Na la aköl kënë bɛ̈n ke wek aacïï ɣa bï bɛn thiëëc këdäŋ. Wɛ̈t yic alɛ̈k we, këriëëc ëbën bäk thiëëc ë riɛnkiɛ̈ abï Wä yiëk we. ");
INSERT INTO dikNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ɣet yaköl acïn kë cäk thiëëc ë riɛnkiɛ̈, thiëckë ku abäk yök, bï miɛt puɔ̈u dït tënë we. ");
INSERT INTO dikNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Käkkä aake ya lɛ̈k we waal, ku tɛ̈ cïï ɣɛn bï bɛn jam waal acï thiɔ̈k, ku ɣɛn abï ya jam tënë we wël la gɛi rin Wä. ");
INSERT INTO dikNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Tɛ̈ le aköl kënë bɛ̈n, ke wek aabï Wä thiëëc ë riɛnkiɛ̈. Ku acä bï lɛ̈k we lɔn bï ɣɛn ya röök ë riɛnkun tënë Wä, ");
INSERT INTO dikNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","rin Wä anhiar we rin nhiɛɛr wek ɣa, ku rin cï wek ye gam lɔn ɣɛn a ɣa bɔ̈ tënë Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ɣɛn abɔ̈ tënë Wä ba bɛ̈n pinynhom, ku pinynhom aba puɔ̈l ku dhuɔ̈k tënë Wä.” ");
INSERT INTO dikNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Go kɔcken ye buɔɔth lɛ̈k ye, “Tïŋ, yïn ajam gɛi ëmën ke yï cïï ben jam waal. ");
INSERT INTO dikNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Acuk ŋic ëmën lɔn ŋic yïn këriëëc ëbën, ku yïn aacïï tït bï yï thiëëc, rin wɛ̈t kënë acuk ŋic lɔn bïï yïn tënë Nhialic.” ");
INSERT INTO dikNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Go Jethu bɛ̈ɛ̈r tënë ke, “Cäk jäl gam ëmën? ");
INSERT INTO dikNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Piɛŋkë tɛ̈däŋ abï bɛ̈n, ku acï thiɔ̈k ayic, tɛ̈ bï wek wɛɛr bï ŋɛk ala panden, ku wek aabä nyääŋ piny ɣatök. Ku acie ɣɛn ɣatök rot, rin Wä arɛ̈ɛ̈r kek ɣa. ");
INSERT INTO dikNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Wek aaca lɛ̈k kënë rin bäk aa tök kek ɣɛn, bäk dɔ̈ɔ̈r yök. Kɔc pinynhom aabï we jöör, ku dɛɛtkë wepuɔ̈th ɣɛn acïï kärɛc pinynhom lëu!” ");
INSERT INTO dikNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Nawën cï Jethu wëlkä thöl luɛl, ke ŋɛ̈ɛ̈r yenyin nhial ku lueel, “Wä, akɔ̈l acï ɣëët. Yiëk lɛc Wëndu ku bï Wëndu yï yiëk lɛc. ");
INSERT INTO dikNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Rin yïn acï bääny yiëk ye kɔc nhïïm ëbën, bï pïr akölriëëc ca gäm ye yiëk kɔc ëbën. ");
INSERT INTO dikNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ku pïr akölriëëc akïn, bï kɔc yï ŋic lɔn yïn ë Nhialic la cök, ku ŋickë Jethu raan cï lɔc ku dɔc wäär ca tuɔ̈ɔ̈c pinynhom. ");
INSERT INTO dikNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ɣɛn acï lɛcdu nyuɔɔth pinynhom, ku luɔi ca yiëk ɣa ba looi aca thääp. ");
INSERT INTO dikNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Wä, gäm ɣa lɛcdu yïnhom tɛ̈n ëmën, lɛc wäär rɛ̈ɛ̈r kamkua ɣok yï, wäthɛɛr ke piny këc cak. ");
INSERT INTO dikNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Yïn aca nyuɔɔth tënë kɔc ca yiëk ɣa pinynhom. Keek aake ye kacku, ku ë yïn acï ke gäm ɣa, ku keek aacï wɛ̈tdu gam. ");
INSERT INTO dikNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ke ëmën aŋickë lɔn këriëëc ëbën ca yiëk ɣa abɔ̈ tënë yï. ");
INSERT INTO dikNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Wä ɣɛn acï wɛ̈t ca lɛ̈k ɣa lɛ̈k ke, gokë gam, ku aŋickë ayic yen lɔn bïï ɣɛn tënë yï, ku acïk gam lɔn cï yïn ɣa tooc. ");
INSERT INTO dikNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Ɣɛn ë röök ë riɛnken. Ɣɛn acie röök rin kɔc tɔ̈ pinynhom, ee rin kɔc ca yiëk ɣa rin ye kek kacku. ");
INSERT INTO dikNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Käkkiɛ̈ ëbën aa käkku, ku lɛcdiɛ̈ aye nyuɔɔth keyiic. ");
INSERT INTO dikNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ku ëmën ɣɛn abɔ̈ tënë yï, ɣɛn acïï ben a raan rɛ̈ɛ̈r pinynhom, ku keek aatɔ̈ pinynhom. Wä dhëŋ, tit ke riɛl ë riɛnku, rin wäär ca yiëk ɣa, bïk aa tök cïmën ɣok ɣo yï. ");
INSERT INTO dikNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Wäär rëër ɣɛn ke ke, aaca muk riɛl ë riɛnku, keek aaca ke tiit ku acïn töŋ cïï määr kamken. Arɛ̈k ke raan wäär yen bï dhiɛl määr ë rot, rin bï wɛ̈t cï gɔ̈t athör thɛɛr wël Nhialic yenhom tiɛŋ. ");
INSERT INTO dikNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ku ëmën ɣɛn abɔ̈ tënë yï, ku käkkä aa ya lueel ɣa ŋoot pinynhom bï miɛt piändiɛ̈ rëër kepuɔ̈th ke dït alanden. ");
INSERT INTO dikNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ɣɛn acï wɛ̈t lɛ̈k ke, go kɔc pinynhom ke maan, rin cïï kek ye kɔc pinynhom tɛ̈n. Cïmën cïï ɣɛn ye raan pinynhom tɛ̈n aya. ");
INSERT INTO dikNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Yïn acä bï thiëëc ba ke nyaai pinynhom, ku yïn aya thiëëc ba ke tiit jɔŋrac. ");
INSERT INTO dikNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Keek aacie kɔc piiny tɛ̈n cïmën cïï ɣɛn raan piny tɛ̈n. ");
INSERT INTO dikNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Mac ke wɛ̈t yic, rin wɛ̈tdu ë yic. ");
INSERT INTO dikNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Keek aca ke tuɔɔc pinynhom cïmën cï yïn ɣa tuɔ̈ɔ̈c pinynhom. ");
INSERT INTO dikNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ɣɛn ë rot mac ë riɛnku, ku bïk röt mac aya wɛ̈t yic. ");
INSERT INTO dikNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ɣɛn acïï rɔ̈ɔ̈k riɛnken röt, ɣɛn arɔ̈ɔ̈k aya rin kɔc bï gam rin piɔ̈ɔ̈cden. ");
INSERT INTO dikNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ɣɛn arɔ̈ɔ̈k rin bï kek aa tök. Wä, cɔl ke aaye tök ɣoyiic cïmën tɔ̈ yïn kek ɣa ku ɣɛn kek yï. Cɔl ke aaye tök rin bï kɔc pinynhom ye gam lɔn cï yïn ɣa tooc. ");
INSERT INTO dikNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ɣɛn acï lɛc ca yiëk ɣa, aca yiëk ke bïk aa tök cïmën ye ɣok tök. ");
INSERT INTO dikNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ɣɛn arɛ̈ɛ̈r keyiic cïmën rëër yïn ɣayic bïk aa tök ëbën, bï kɔc pinynhom ŋic lɔn cï yïn ɣa tooc, ku lɔn nhiɛɛr yïn ke cïmën nhiɛɛr yïn ɣa. ");
INSERT INTO dikNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Wä, keek aaca yiëk ɣa, ku awiëc bïk rëër tɛ̈ rëër ɣɛn thïn, bïk lɛcdiɛ̈ tïŋ, lɛc ca yiëk ɣa, rin nhiɛɛr yïn ɣa wäär këc piny guɔ cak. ");
INSERT INTO dikNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Wä raan la cök, kɔc pinynhom aa kuc yï, ku yïn aŋiɛc, ku kɔckä aŋickë lɔn cï yïn ɣa tooc. ");
INSERT INTO dikNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Yïn aca nyuɔɔth tënë ke, ku aba ŋot luɔɔi këya, rin bï nhiɛ̈rdu tënë ɣa tɔ̈ keyiic, ku ba tɔ̈u keyiic aya.” ");
INSERT INTO dikNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Tɛ̈wën cï Jethu röök këya, ke jiël kek kɔcken ye buɔɔth ku teem wär cɔl Kidron. Ku gör ë tɔ̈ thïn tɛ̈ɛ̈në, go Jethu la thïn kek kɔcken ye buɔɔth. ");
INSERT INTO dikNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ku Judath raan gɔɔny ye ë ŋic tɛ̈ cï yen la thïn, rin cï Jethu kaŋ rɔ̈m thïn kek kɔcken ye buɔɔth arak juëc. ");
INSERT INTO dikNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Go Judath la gör yic kek akut apuruuk, ku kɔc kɔ̈k luaŋ Nhialic tiit, cï kɔc käk Nhialic ku kɔc akut Parathï tuɔɔc thïn. Keek aake muk tɔɔŋ ku mermer, ");
INSERT INTO dikNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ku Jethu ë ŋic këriëëc ëbën bï rot looi tënë ye, go ke lor nhïïm ku thiëëc ke, “Yeŋa wiɛ̈ckë?” ");
INSERT INTO dikNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Gokë bɛ̈ɛ̈r, “Ee Jethu raan Nadharet.” Go lueel, “Ee ɣɛn.” Ku Judath, raan gɔɔny ye ë tɔ̈ thïn ke ke. ");
INSERT INTO dikNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Kaam wën lëk Jethu ye ke, “Ee ɣɛn,” Ke riŋ ciëën kekɔ̈th ku wïïkkë piny. ");
INSERT INTO dikNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Go Jethu ke bɛn thiëëc, “Yeŋa wiɛ̈ckë?” Gokë lueel, “Ee Jethu raan Nadharet.” ");
INSERT INTO dikNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Go Jethu lueel, “Aca lɛ̈k we wënthɛɛr lɔn ye yen ɣa. Na wiɛ̈ckë ɣa, ke we päl kɔckä bïk jäl.” ");
INSERT INTO dikNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yeen acï jam këlä bï wɛ̈t cï kaŋ lueel ëlä rot tiɛɛŋ tɛ̈dë, “Wä, na cɔk a raan tökaliŋ kam kɔc ca yiëk ɣa, ka këc muɔ̈r.” ");
INSERT INTO dikNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ku Thaimon Pïtɛr ë muk pal. Go miëët bei ku tök alony raandït käk Nhialic ku teem yïnyden cuëc wei. Ku alony ë cɔl Malko. ");
INSERT INTO dikNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Go Jethu lɛ̈k Pïtɛr, “Dhuɔ̈k paldu jɔkgɔde yic. Ye tak lɔn cï ɣɛn arɛɛm cï Wä yiëk ɣa bï guum.” ");
INSERT INTO dikNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Go akut apuruuk kek bänyden ku kɔc Itharel ke tït, Jethu dɔm ku derkë, ");
INSERT INTO dikNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ku kɔŋkë ɣäth tënë Anath. Ku Anath ë ye wun tiŋ Kaipa, raandït käk Nhialic ye ruɔ̈ɔ̈n kënë. ");
INSERT INTO dikNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ee Kaipa yen ëcï ye kaŋ lɛ̈k kɔc Itharel lɔn ŋuɛ̈ɛ̈n yen bï raan tök thou rin kɔc. ");
INSERT INTO dikNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Go Thaimon Pïtɛr kek raan dɛ̈t Jethu buɔɔth, ku raan Jethu buɔɔth kënë ë ŋic raandït käk Nhialic guɔ̈p apɛi, go la kal pan raandït käk Nhialic yic kek Jethu. ");
INSERT INTO dikNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ku dɔ̈ŋ Pïtɛr aɣeer kal thok. Go atuny wën ŋiɛ̈c kek raandït käk Nhialic dhuk aɣeer, ku jiɛɛm kek nyɛn tit kal thok, ku bïï Pïtɛr alɔŋthïn. ");
INSERT INTO dikNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Go nyɛn tit kal thok Pïtɛr thiëëc, “Cïï ye raan tök kam kɔc mony kënë buɔɔth?” Go Pïtɛr bɛ̈ɛ̈r, “Ɣei, ɣɛn acie raande.” ");
INSERT INTO dikNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ku wiir ë tɔ̈ thïn, go aloony ku kɔc tït many cool took, ku kɛ̈ɛ̈ckë many wën lɔ̈ɔ̈m bïk ɣɔ̈c. Go Pïtɛr la ku kɛ̈ɛ̈c ke ke bï ɣɔ̈c aya. ");
INSERT INTO dikNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Go raandït käk Nhialic Jethu thiëëc rin wɛ̈t kɔcken ye buɔɔth, ku rin wɛ̈t piɔ̈ɔ̈cde. ");
INSERT INTO dikNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Go Jethu bɛ̈ɛ̈r, “Ɣɛn ë cool jam akölaköl tënë raan ëbën kɔc nhïïm, ku piɔ̈ɔ̈cdiɛ̈ ëbën aya looi tɛ̈n amat ku luaŋ Nhialic tɛ̈ ye kɔc Itharel guëër thïn. Ku ɣɛn acïn kë ca kaŋ lueel ke muɔɔny. ");
INSERT INTO dikNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ku yeŋö thiëëc yïn ɣa? Thiëc kɔc cï wɛ̈lkiɛ̈ piŋ. Thiëc ke wël ca lɛ̈k ke, rin aa ŋic wël ca lueel.” ");
INSERT INTO dikNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Tɛ̈wën cï Jethu jam këlä, go raan tök kam kɔc tït ke kääc thïn buɔ̈ɔ̈k nyin ku lueel, “Cïï riɔ̈c ba jam këlä tënë raandït käk Nhialic?” ");
INSERT INTO dikNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Go Jethu bɛ̈ɛ̈r tënë ye, “Na ca kuɔ̈c jam, ke lɛ̈k kɔc tɛ̈ cï ɣɛn kuɔ̈c jiɛɛm thïn. Ku na ye yic yen ca lueel, ke yeŋö mɛŋ yïn ɣa?” ");
INSERT INTO dikNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Go Anath tuɔɔc tënë Kaipa raandït käk Nhialic, ke ŋot dɛr cin. ");
INSERT INTO dikNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pïtɛr ë ŋot kääc tɛ̈wën ke ɣɔ̈c mac. Go kɔc kɔ̈k lueel tënë ye, “Cïï ye raan tök kam abiöth ë mony kënë?” Go Pïtɛr jai ku lueel, “Ɣei, ɣɛn acie raande.” ");
INSERT INTO dikNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Go muɔny tök kam aloony raandït käk Nhialic, ruääi kek raan wën cï Pïtɛr tɔ̈k yïc wei, jam ku thiëëc, “Kɛ̈c yï tïŋ kek ye gör yic?” ");
INSERT INTO dikNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Go Pïtɛr bɛn jai, ku kiu thɔn ajïth nyin yic. ");
INSERT INTO dikNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Gokë Jethu thɛl wei pan Kaipa ku ɣɛ̈thkë pan bɛ̈nydït Roma, Pilato. Ku piny ë ye nhiäknhiäk dur yic. Go kɔc Itharel cïï la alɔŋthïn pan bɛ̈nydït, ku bïk röt tiit ajuɛ̈ɛ̈c rin cï yai thiɔ̈k, ku bïk miëth Yan Ayum cïn yic luɔu cam. ");
INSERT INTO dikNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Go Pilato la aɣeer tënë ke ku thiëëc ke, “Ye awäc ŋö cäk yök ye mony kënë guɔ̈p?” ");
INSERT INTO dikNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Gokë bɛ̈ɛ̈r, “Na cïn awuɔ̈c cï looi ŋuɔ̈t akëcku bɛ̈ɛ̈i tënë yï.” ");
INSERT INTO dikNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Go Pilato lɛ̈k ke, “Week gup lɔ̈mkë ku luɔikë luk kë cït löŋ ciɛɛŋ pandun.” Go kɔc Itharel bɛ̈ɛ̈r, “Akëc puɔ̈l tënë ɣo buk raan tɛ̈m thou.” ");
INSERT INTO dikNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Kënë acï rot looi bï wɛ̈t cï Jethu lueel rot tiɛɛŋ tɛ̈de, wën lueel yen kuat thon bï yen thou. ");
INSERT INTO dikNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Go Pilato dhuk kal yic ku cɔɔl Jethu ku thiëëc, “Ye yïn Bɛ̈nyŋaknhom kɔc Itharel?” ");
INSERT INTO dikNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Go Jethu bɛ̈ɛ̈r, “Wɛ̈t kënë ye wɛ̈tdu aye kɔc kɔ̈k kek cï ye lɛ̈k yï ë riɛnkiɛ̈?” ");
INSERT INTO dikNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Go Pilato bɛ̈ɛ̈r, “Ye tak lɔn ye ɣɛn raan Itharel? Aa kacku guɔ̈p kek kɔcken dït käk Nhialic, kek aa bïï yï tënë ɣa. Yeŋö ca looi?” ");
INSERT INTO dikNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Go Jethu bɛ̈ɛ̈r, “Bäänydiɛ̈ acie bääny pinynhom. Na bäänydiɛ̈ ye kën pinynhom, ŋuɔ̈t kackiɛ̈ aacï thɔ̈r bï ɣɛn cïï tɛ̈ɛ̈u kɔc Itharel cin. Acie këya, bäänydiɛ̈ acie kën pinynhom tɛ̈n.” ");
INSERT INTO dikNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Go Pilato bɛn thiëëc, “Yïïn, ye bɛ̈nyŋaknhom?” Go Jethu bɛ̈ɛ̈r, “Aye lueel lɔn ye ɣɛn bɛ̈nyŋaknhom. Ɣɛn acï dhiëëth ku ɣɛn acï bɛ̈n pinynhom rin wɛ̈t töŋ kënë, ba jam wɛ̈t yic. Ku kuat raan cï yic ŋic ë wɛ̈tdiɛ̈ piŋ.” ");
INSERT INTO dikNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Go Pilato thiëëc, “Ku yic ye kën ŋö?” Ku ben dhuk aɣeer tënë kɔc Itharel ku lëk ke, “Acïn awuɔ̈c ca lëu ba yök yeguɔ̈p bï ye luɔ̈k wei. ");
INSERT INTO dikNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ku yeen ë wɛ̈t piändun ba raan töŋ cï mac lony rin Yan Ayum cïn yic luɔu. Wiɛ̈ckë ba Bɛ̈nyŋaknhom kɔc Itharel luɔ̈ny we?” ");
INSERT INTO dikNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Gokë dhuɔ̈k ye ke loi kiɛɛu, “Acie këya! Acie yen wïcku. Barabath yen awïcku.” Ku Barabath ë ye cuär kɔc rum. ");
INSERT INTO dikNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Go Pilato Jethu dɔm ku cɔl athat. ");
INSERT INTO dikNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ku jɔl apuruuk kër thii tim la kuɔɔth riic yiic ku ŋɛk kek yenhom, ku tɛ̈ɛ̈ukë alanh mathiäŋ yekɔ̈u, ");
INSERT INTO dikNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ku bïkkë tënë ye ku luelkë, “Madho, Bɛ̈nyŋaknhom, Bɛ̈ny kɔc Itharel,” ku maŋkë nyin. ");
INSERT INTO dikNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Go Pilato bɛn dhuk aɣeer ku lëk kɔc wën cï kenhïïm kut, “Yeen aba thɛ̈l aɣeer tënë we tɛ̈në, ku bäk tïŋ lɔn cïn yen tɛ̈ bï ɣɛn awuɔ̈c yök yeguɔ̈p ba luɔ̈k wei.” ");
INSERT INTO dikNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Këya, go Jethu bɛ̈n aɣeer ke ceŋ ŋakŋak cï looi kuɔɔth ku alanh mathiäŋ yekɔ̈u. Ku lueel Pilato tënë ke, “Yen kïn, yen raan!” ");
INSERT INTO dikNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Nawën tïŋkë, ke kɔc käk Nhialic ku kɔc tït kiu ku luelkë, “Piäät tim cï rïïu kɔ̈u.” Go Pilato lɛ̈k ke, “Damkë kek we bäk piäät tim cï rïïu kɔ̈u, ɣɛn akëc awuɔ̈c yök yeguɔ̈p.” ");
INSERT INTO dikNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Gokë wɛ̈t dhuk, “Ɣok aa la löŋ ciɛɛŋda ye lueel lɔn dhil ye nɔ̈k, rin acï lueel lɔn ye yen Wën Nhialic.” ");
INSERT INTO dikNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Nawën piŋ Pilato wɛ̈t kënë, ke riɔ̈c apɛi. ");
INSERT INTO dikNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ku dhuk kal yic ku thiëëc Jethu, “Yïïn bäär tɛ̈nɛn?” Go Jethu biɛt ku cïï bëër thok acïn. ");
INSERT INTO dikNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Go Pilato lɛ̈k ye, “Cïï wïc ba jam kek ɣa? Tak yïnhom lɔn nadë ke ɣɛn ala riɛl ba yï puɔ̈l, ku ɣɛn ala riɛl aya ba yï cɔl apiëët tim cï rïïu kɔ̈u.” ");
INSERT INTO dikNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Go Jethu bɛ̈ɛ̈r, “Yïn ala riɛl tënë ɣa rin cï Nhialic ye yiëk yï, ku ë yen ale raan cä tääu yïcin guɔ̈p awuɔ̈c rac apɛi.” ");
INSERT INTO dikNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Nawën piŋ Pilato wëlkä, ke wïc apɛi bï dhël yök bï yen Jethu puɔ̈l. Go kɔc Itharel kiu tënë ye ku luelkë, “Tɛ̈ lony yïn ye ka ye nyooth lɔn cïï yïn määth kek Bɛ̈nyŋaknhom. Kuat raan rot looi bï ya bɛ̈nyŋaknhom, ee raan ater Bɛ̈nydan ŋaknhom.” ");
INSERT INTO dikNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Nawën piŋ Pilato ë wëlkä, ke thel Jethu aɣeer ku nyuuc thöny luk tɔ̈ laar cɔl, “Piny cï guiir kuɔ̈r,” Ku ë cɔl Gabata thoŋ kɔc Itharel. ");
INSERT INTO dikNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ku aköl kënë yen aköl guiir kɔc röt rin Yan Ayum cïn yic luɔu. Nawën tɛ̈cït akɔ̈l ciɛl yic, ke lëk Pilato kɔc Itharel, “Bɛ̈nydun ŋaknhom akïn!” ");
INSERT INTO dikNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Gokë kiu tënë ye, “Näk! Näk! Piäät tim cï rïïu kɔ̈u!” Go Pilato ke thiëëc, “Wiɛ̈ckë ba Bɛ̈nydun ŋaknhom piäät tim cï rïïu kɔ̈u?” Go kɔc käk Nhialic bɛ̈ɛ̈r, “Bänyda ë tök, ee bɛ̈nyŋaknhom Roma!” ");
INSERT INTO dikNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Go Pilato ke yiëk Jethu bïk la piäät tim cï rïïu kɔ̈u. Gokë Jethu dɔm. ");
INSERT INTO dikNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ku ler aɣeer ke ket timden cï rïïu, ke jiël geeu bï la tɛ̈ cɔl Golgotha. (Ku wɛ̈tde yic, gɔn la gueŋ-ŋeŋ cït apen nhom raan.) ");
INSERT INTO dikNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ku jɔlkë piäät tim cï rïïu kɔ̈u. Ku piɛ̈ɛ̈tkë kɔc karou aya tiim cï rïïu kɔ̈ɔ̈th, raan tök lɔŋ cuëc ku raan dɛ̈t lɔŋ cam. Ku Jethu ciɛl kamken. ");
INSERT INTO dikNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Go Pilato awuɔ̈c gɔ̈t bï tääu tim cï rïïu nhom. Ku kën cï gɔ̈t akïn, “JETHU RAAN NADHARET, BƐNYŊAKNHOM ITHAREL.” ");
INSERT INTO dikNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ku kɔc juëc aake cï kënë kueen, rin tɛ̈n cï Jethu piäät tim cï rïïu kɔ̈u thïn, acïï mec ke gɛu. Ku wɛ̈t ëcï gɔ̈t thoŋ kɔc Itharel ku thoŋ kɔc Roma ku thoŋ Gïrïk. ");
INSERT INTO dikNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Go kɔcdït käk Nhialic Itharel lɛ̈k Pilato, “Duk ye gɔ̈t, ‘Bɛ̈nyŋaknhom kɔc Itharel,’ aŋuɛ̈ɛ̈n ba gɔ̈t, ‘Acï mony kënë lueel, ɣɛn ë bɛ̈nyŋaknhom kɔc Itharel.’ ” ");
INSERT INTO dikNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Go Pilato bɛ̈ɛ̈r, “Kë ca gɔ̈t arɛ̈ɛ̈r ke ca gɔ̈t.” ");
INSERT INTO dikNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Nawën cï apuruuk Jethu piäät tim cï rïïu kɔ̈u, ke löm aläthke ku tekkë keyiic ŋuan, abaŋ tök tënë apuruɔ̈k tök. Ku lömkë alanh kɔ̈u aya cï kɔɔc këdiɛ̈t tök, jɔɔk yeyeth ɣet piny. ");
INSERT INTO dikNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ku luelkë kamken, “Dukku tem kɔ̈u, cuɛtku gɛk buk tïŋ bï lööny tënë ŋa.” Kënë acï rot looi bï wɛ̈t cï gɔ̈t athör thɛɛr wël Nhialic yic rot tiɛɛŋ tɛ̈de, “Keek aacï aläthkiɛ̈ tek kamken, ku cuɛtkë gɛk rin alanhdiɛ̈n kɔ̈u.” Kënë yen acï apuruuk looi ayic. ");
INSERT INTO dikNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ku tɛ̈thiɔ̈k kek tim cï rïïu Jethu, diäär aake kääc thïn, man ku nyankën ë man, Maria tiŋ Klopath ku Maria Magdalena. ");
INSERT INTO dikNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Nawën tïŋ Jethu man ku raan ye buɔɔth nhiɛɛr ke kääc aya ë tɛ̈ɛ̈n, ke lëk man, “Tik manhdu akïn.” ");
INSERT INTO dikNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ku ben lɛ̈k raan ye buɔɔth wën, “Moor akïn.” Ku yaköl guɔ̈p ke wïc raan ye buɔɔth awën piny paande. ");
INSERT INTO dikNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Nawën ŋic Jethu lɔn cï këriëëc ëbën thääp, ke lueel bï wɛ̈t cï gɔ̈t athör thɛɛr wël Nhialic yic rot tiɛɛŋ, “Ɣɛn anɛ̈k rou.” ");
INSERT INTO dikNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ku töny cï thiäŋ muɔ̈n wac ë tɔ̈ thïn, gokë alath luɔ̈t mɔ̈u yic, ku tɛ̈ɛ̈ukë wai thok, ku ɣɔɔkkë yethok. ");
INSERT INTO dikNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Nawën cï Jethu muɔ̈n wac jooc ke lueel, “Wɛ̈t acï thääp.” Ku gut yenhom piny ku thou. ");
INSERT INTO dikNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Go kɔc Itharel Pilato thiëëc bï ke puɔ̈l bïk kɔc cï piäät tiim cï rïïu kɔ̈th dhoŋ kuɔ̈l, ku nyɛɛikë guäpken tiim cï rïïu kɔ̈th. Ku ë loikë këlä rin ye yen aköl niɛ̈n Dhiëc, ku acïk ye wïc bï guäpken rëër tiim cï rïïu kɔ̈th aköl niɛ̈n Dätem, rin yen aköl yandït apɛi. ");
INSERT INTO dikNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Go apuruuk la ku dhoŋkë kuɔ̈l raan tök ku kuɔ̈l raan dɛ̈t, ë kɔc cï piäät tiim cï rïïu kɔ̈th kek Jethu. ");
INSERT INTO dikNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Nawën bïkkë tënë Jethu, ke tïŋkë lɔn cï yen thou ku cïk ben dhoŋ kuɔ̈l. ");
INSERT INTO dikNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Go apuruɔ̈ŋ tök Jethu gut puɔ̈u tɔŋ, go riɛm ku pïu kuër nyin yic. ");
INSERT INTO dikNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ku raan cï kënë tïŋ acï lueel rin bï wek ye gam aya. Wɛ̈t cï lueel ë yic, ku yeen aŋic lɔn ye yen wɛ̈t yic yen lueel. ");
INSERT INTO dikNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Kënë acï rot looi bï wɛ̈t cï gɔ̈t athör thɛɛr wël Nhialic yic rot tiɛɛŋ, “Acïn yuɔɔmden bï dhoŋ.” ");
INSERT INTO dikNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ku ben lueel tɛ̈dɛ̈t athör yic ëlä, “Ku aabï daai raan yen cïk gut.” ");
INSERT INTO dikNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Nawën ë kënë cök ciëën, ke Jothep raan gen Arimatheo bɔ̈ tënë Pilato ku thiëëc bï guɔ̈p Jethu nyaai. (Jothep ë ye raan Jethu buɔɔth cï gam, ku aye moony rin riɔ̈ɔ̈c yen bäny Itharel.) Go Pilato lɛ̈k ye lɔn cï guɔ̈p puɔ̈l tënë ye. Go Jothep la ku le nyaai. ");
INSERT INTO dikNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Go Nikodemo, raan wäär cï kaŋ la tënë Jethu wakɔ̈u, rot mät Jothep ku ë muk miök ŋïr cɔl mira cï liääp wäl dɛ̈t cɔl aloe. ");
INSERT INTO dikNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Go röör wën karou guɔ̈p Jethu lööm ku derkë kɔ̈u alath ke cï wäl ŋïr tääu thïn, rin kënë yen ë tɛ̈ ye kɔc Itharel guiër guɔ̈p raan cï thou bï jäl thiɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ku tɛ̈wën cï Jethu nɔ̈k thïn gör ë tɔ̈ thïn, ku raŋ yam ë tɔ̈ gör yic, ku ë cïn raan cï kaŋ thiɔ̈k thïn. ");
INSERT INTO dikNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ku rin bï yen aköl yan kɔc Itharel nhiäk, ku rin thiɔ̈k raŋ aya, gokë guɔ̈p Jethu tɔ̈ɔ̈u thïn. ");
INSERT INTO dikNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Riɛl yic aköl Nhialic ke piny ŋot la durdur, ke Maria Magdalena la raŋ nhom, go alɛl tïŋ ke cï nyaai raŋ thok. ");
INSERT INTO dikNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Go riŋ tënë Thaimon Pïtɛr, ku tënë raan dɛ̈t Jethu buɔɔth nhiɛɛr Jethu, ku lëk ke, “Kɔc aacï Bɛ̈ny nyaai raŋ yic ku akucku tɛ̈ cï kek ye tääu thïn.” ");
INSERT INTO dikNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Go Pïtɛr ku raan Jethu buɔɔth dɛ̈t wën lööny dhöl, ku lekkë raŋ nhom. ");
INSERT INTO dikNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ku keek aake la ke kat kedhie, go raan Jethu buɔɔth dɛ̈t wën kat apɛi tënë Pïtɛr, ku ye yen kɔŋ ɣet raŋ nhom. ");
INSERT INTO dikNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Go guŋ ku tïŋ alanh wäär cï Jethu der, ku akëc la alɔŋthïn. ");
INSERT INTO dikNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Go Thaimon Pïtɛr guɔ bɛ̈n ku ler raŋ yic. Go alɛ̈th tïŋ ke rɛ̈ɛ̈r piiny, ");
INSERT INTO dikNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ku alanh cï Jethu kum nhom ëcïï rɛ̈ɛ̈r kek alɛ̈th kɔ̈k, ëcï mat yic tɛ̈de rot. ");
INSERT INTO dikNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Go raan Jethu buɔɔth dɛ̈t wën cï kaŋ ɣet raŋ nhom jäl la alɔŋthïn, ku gɛm. ");
INSERT INTO dikNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Ku keek aake ŋot ke këc wɛ̈t athör thɛɛr wël Nhialic deet yic, athör ye lueel lɔn bï yen rot dhiɛl jɔt thou yic.) ");
INSERT INTO dikNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Go kɔc ye buɔɔth jal dhuk bei. ");
INSERT INTO dikNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Kaam wën Maria ë kääc aɣeer tɛ̈thiääk kek raŋ ke dhiau. Ku tɛ̈wën ŋot dhiɛɛu yen ke guɔ̈ŋ ku luiit raŋ yic, ");
INSERT INTO dikNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ku tïŋ atuuc nhial cï ruk alɛ̈th ɣer karou, ke rɛ̈ɛ̈r tɛ̈wäär cï guɔ̈p Jethu tɔ̈ɔ̈u thïn, tök tɛ̈ la yenhom ku dɛ̈t tɛ̈ la yecök. ");
INSERT INTO dikNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Gokë thiëëc, “Tik, ye rin ŋö dhiɛɛu yïn?” Go lueel, “Keek aacï Bänydiɛ̈ nyaai, ku akuɔ̈c tɛ̈ cï kek ye tääu thïn.” ");
INSERT INTO dikNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Kaam wën lueel yen kënë, ku jɔl wel yenyin ke tïŋ Jethu ke kääc yelɔ̈ɔ̈m, ku akëc ŋic lɔn ë yen Jethu. ");
INSERT INTO dikNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Go Jethu thiëëc, “Tik, ye rin ŋö dhiɛɛu yïn? Yeŋa wïc?” Go tak lɔn ë yen raan lui dom yic, ku lëk ye, “Bɛ̈ny, na ye yïn cï ye nyaai, ke lɛ̈k ɣa tɛ̈ cï yïn ye tɔ̈ɔ̈u thïn, ku ɣɛn abï la ba la lööm.” ");
INSERT INTO dikNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Go Jethu lɛ̈k ye, “Maria.” Go yenhom wɛ̈l ye ku lueel thoŋ kɔc Itharel, “Rabuni,” ku wɛ̈tde yic, “Raan piööc.” ");
INSERT INTO dikNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Go Jethu lɛ̈k ye, “Duk ɣa gɔt rin ɣɛn ŋot ɣa këc ɣet nhial tënë Wä. Ku yïïn lɔɔr tënë wämäthkiɛ̈ ku lɛ̈k ke, ‘Ɣɛn adhuk ciëën tënë ye, yen ë Wä, ku ye Wuurdun, Nhialicdiɛ̈ ku ye Nhialicdun.’ ” ");
INSERT INTO dikNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Go Maria Magdalena jäl ku le lɛ̈k kɔc ye buɔɔth lɔn cï yen Bɛ̈ny tïŋ, ku lëk ke wël cï Jethu lɛ̈k ye. ");
INSERT INTO dikNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Naɣɔn thëëi ya aköl Nhialic wën, ke kɔc ye buɔɔth aake cï röt mat ɣön cï riit thok, rin riɔ̈ɔ̈c kek bäny Itharel. Go Jethu bɛ̈n ku kɛ̈ɛ̈c kamken ku lueel, “Bï dɔ̈ɔ̈r rëër kek we.” ");
INSERT INTO dikNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Wën cï yen jam këlä, ke nyuth ke yecin ku yelɔ̈m. Go kɔc ye buɔɔth puɔ̈th miɛt apɛi wën tïŋ kek Bɛ̈ny. ");
INSERT INTO dikNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ku ben Jethu lɛ̈k ke, “Bï dɔ̈ɔ̈r rëër kek we, cïmën cï Wä ɣa tooc, ke wek aa ba tooc aya.” ");
INSERT INTO dikNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Wën cï yen jam këlä, ke jɔl wëëi kenhïïm ku lueel, “Lɔ̈mkë Wëi Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Na pälkë adumuɔ̈ɔ̈m kɔc piny, ka pɛ̈l piny, na cäk ke pɛ̈l piny, ka cïï pɛ̈l piny.” ");
INSERT INTO dikNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ku Thomath, cɔl Acueek, raan tök kam kɔc kathiäär ku rou ye buɔɔth, ee liu thïn wën bïï Jethu. ");
INSERT INTO dikNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Go abiöth kɔ̈k lɛ̈k ye, “Bänyda acuk tïŋ.” Go Thomath lɛ̈k ke, “Na cie tɛ̈töök wäär cï ye piäät kek tiɛ̈ŋ yecin, ku tääu ɣacin ë tɛ̈töökkä yiic, ku tääu ɣacin yeyɔu aya, ka cä kɔŋ gam.” ");
INSERT INTO dikNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nawën nin kabɛ̈t cök, ka abiöth aake cï röt bɛn mat ɣöt ku Thomath ë rɛ̈ɛ̈r thïn ke ke, ku ɣöt ëcï riit thok. Go Jethu bɛn kɔ̈ɔ̈c kamken ku lueel, “Bï dɔ̈ɔ̈r rëër kek we.” ");
INSERT INTO dikNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ku jɔl lɛ̈k Thomath, “Tääu yïcin tɛ̈n, ku tïŋ ciɛnkiɛ̈ ku jɔt yïkök ba yïcin tääu ɣayɔu. Päl kënë yïn käŋ dhɔ̈l yiic, ku gam!” ");
INSERT INTO dikNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Go Thomath bɛ̈ɛ̈r, “Bänydiɛ̈ ku Nhialicdiɛ̈.” ");
INSERT INTO dikNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Go Jethu lɛ̈k ye, “Ca gam rin cï yïn ɣa tïŋ? Ye këpuɔth bï yiëndë tënë kɔc bï gam ke këc ɣa tïŋ!” ");
INSERT INTO dikNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jethu acï kädït jäŋ gɔ̈i looi kɔcken ye buɔɔth nhïïm, ku keek aa këc gɔ̈t athör kënë yic. ");
INSERT INTO dikNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ku käkkä aacï gɔ̈t rin bäk gam lɔn ye Jethu Wën Nhialic cï lɔc, ku bäk pïr yök ë riɛnke tɛ̈ cï wek gam. ");
INSERT INTO dikNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Nawën ë käkkä cök ciëën ke Jethu ben rot nyuɔ̈th kɔcken ye buɔɔth wär Tiberia yɔu. Ku tɛ̈ cï luɔ̈i ye akïn. ");
INSERT INTO dikNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Thaimon Pïtɛr kek Thomath (cɔl Acueek), ku Nathaniel (raan Kana pan Galilia), ku wɛ̈ɛ̈t Dhubedï, ku kɔc kɔ̈k karou Jethu buɔɔth, aake rɛ̈ɛ̈r tɛ̈tök ëbën. ");
INSERT INTO dikNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Go Thaimon Pïtɛr lɛ̈k kɔc wën, “Ɣɛn ala mɛi.” Gokë lɛ̈k ye, “Ɣok aabï cath kek yï.” Gokë la ku lek riäi yic, ku acïn kë cïk dɔm ë wɛ̈ɛ̈r kënë yic ëbën. ");
INSERT INTO dikNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Tɛ̈wën bïï akɔ̈l nyin, ke Jethu ë kääc wär yɔu, ku akëc kɔcken ye buɔɔth ŋic lɔn ë yen Jethu. ");
INSERT INTO dikNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Go lɛ̈k ke, “Riënythii, cïn kë cäk dɔm?” Goke bɛ̈ɛ̈r, “Acïn këdäŋ.” ");
INSERT INTO dikNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Go lɛ̈k ke, “Cuatkë buɔi lɔŋ cuëny riäi, ku käŋ aa bäk dɔm thïn.” Gokë buɔi cuat ku göök ke bïk miit rin juëc rec apɛi. ");
INSERT INTO dikNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Go raan Jethu buɔɔth nhiɛɛr Jethu lɛ̈k Pïtɛr, “Kën ë Bɛ̈ny.” Nawën piŋ Thaimon Pïtɛr lɔn ye yen Bɛ̈ny, ke ruk alanhde yekɔ̈u (rin cï yen aläthke däk bei ëbën) ku thuɛɛt wïïr. ");
INSERT INTO dikNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Go abiöth kɔ̈k lɔ̈k bɛ̈n ke cath riäi, ke thel buɔi ke cï thiäŋ rec. Ku keek aake cïï mec apɛi kek agör, aake cït akääth bian tök. ");
INSERT INTO dikNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Nawën kɛɛckë piny ke tïŋ many ë miim ke dɛ̈p ku rec ke cï tääu mɛɛc kek ayup. ");
INSERT INTO dikNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Go Jethu lɛ̈k ke, “Bɛ̈ɛ̈ikë rec abɛ̈k rec awën cäk dɔm.” ");
INSERT INTO dikNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Go Thaimon Pïtɛr la riäi yic ku miit buɔi wär thok ke cï thiäŋ rec dït, ku rec ëbën aa buɔɔt ku thiärdhiëc ku diäk. Tɛ̈wën cɔk rec juëc këlä, buɔi akëc yic rɛɛt. ");
INSERT INTO dikNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Go Jethu lɛ̈k ke, “Bäk, miëthkë.” Ku acïn raan tök kam kɔc ye buɔɔth cï ye cak thiëëc, “Ye yïn ŋa?” Rin ŋic kek ye lɔn ye yen Bɛ̈ny. ");
INSERT INTO dikNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Go Jethu rot cuɔt ku lööm ayup ku yïk ke ku ben looi këya kek rec. ");
INSERT INTO dikNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Këlä, Jethu acï rot nyuɔ̈th kɔc ye buɔɔth kën yen yic diäk, tɛ̈wën cï yen rot jɔt kam kɔc cï thou. ");
INSERT INTO dikNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Wën cï kek mïth ke lëk Jethu Pïtɛr, “Thaimon wën Joon, nhiar ɣa apɛi tɛ̈n tɛ̈ nhiɛɛr kɔckä ɣa?” Go bɛ̈ɛ̈r, “Ee këya Bɛ̈ny, aŋic lɔn nhiɛɛr ɣɛn yï.” Go Jethu lɛ̈k ye, “Biɔ̈ɔ̈k amälkiɛ̈ apath.” ");
INSERT INTO dikNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ku ben Jethu lɛ̈k ye, “Thaimon, wën Joon nhiar ɣa apɛi?” Go bɛ̈ɛ̈r, “Ee këya Bɛ̈ny aŋic lɔn nhiɛɛr ɣɛn yï.” Go Jethu lɛ̈k ye, “Biɔ̈ɔ̈k amälkiɛ̈ apath.” ");
INSERT INTO dikNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ku ben Jethu thiëëc arak dɛ̈t ye kek diäk, “Thaimon, wën Joon nhiar ɣa?” Go Pïtɛr puɔ̈u dak rin cï Jethu ye thiëëc arak dɛ̈t ye kek diäk, “Nhiar ɣa?” Ku lëk ye, “Bɛ̈ny, yïn aŋic këriëëc ëbën, ku yïn aŋic lɔn nhiɛɛr ɣɛn yï.” Go Jethu lɛ̈k ye, “Biɔ̈ɔ̈k amälkiɛ̈ apath, ");
INSERT INTO dikNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Wɛ̈t yic alɛ̈k yï, wäär ŋot ye yïn riënythii ke yïn ye rot guiir ku lɔɔr tɛ̈ wïc piändu, ku tɛ̈ bï yïn dhiɔp ke yïn abï yïcin ɣaak tueŋ, ku raan dɛ̈t abï der ku thel yï tɛ̈ cïï wïc ba la thïn.” ");
INSERT INTO dikNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Käkkä aacï Jethu lueel bï nyuɔ̈th Pïtɛr tɛ̈ bï yen thou thïn, ku bï kɔc cɔl aaye Nhialic leec thïn. Ku jɔl Jethu lɛ̈k ye, “Buɔth ɣa.” ");
INSERT INTO dikNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Go Pïtɛr yenhom wel ku tïŋ raan dɛ̈t ye buɔɔth nhiɛɛr Jethu ke buɔth ke, raan wäär thiääk kek Jethu wäär mïth kek, cï Jethu bɛ̈n thiëëc ëlä, “Bɛ̈ny, yeŋa bï yï la gaany?” ");
INSERT INTO dikNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Wën tïŋ Pïtɛr ye, ke lëk Jethu, “Bɛ̈ny, na raan dɛ̈të, bï yiëndë?” ");
INSERT INTO dikNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Go Jethu bɛ̈ɛ̈r, tënë ye, “Na wiëc bï pïr ɣet aköl bï ɣɛn bɛ̈n, ke yeŋö tënë yï? Yïïn ëmën buɔth ɣa.” ");
INSERT INTO dikNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Go wɛ̈t thiëi piny kam kɔc buɔth Jethu lɔn raan Jethu buɔɔth kënë acïï bï thou. Ku akëc Jethu lueel lɔn cïï yen bï thou. Acï lueel, “Na wiëc bï pïr ɣet aköl bï ɣɛn bɛ̈n ke yeŋö tënë yï?” ");
INSERT INTO dikNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Raan kënë yen ë raan Jethu buɔɔth jam käk cï tïŋ, ku yen ë gɛ̈t ke aya, ku aŋic lɔn wɛ̈t cï lueel ë wɛ̈t yic. ");
INSERT INTO dikNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ëmën käjuëc kɔ̈k aatɔ̈ thïn, käk cï Jethu looi. Na ke cï gät piny ëbën, tök ku tök, ke ɣɛn aya thɔ̈ɔ̈ŋ lɔn piny ëbën acïï lëu bï athör gät jɔt.");
INSERT INTO dikNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Tënë Thiöpiluth athördiɛ̈n tueŋ yic, ɣɛn acï gɛ̈t käk cï Jethu looi, ku käk cï piɔ̈ɔ̈c tɛ̈wäär jɔɔk yen luɔide cök, agut aköl jɔt ye nhial. Tɛ̈wën këc Jethu guɔ ɣäth nhial, ëcï wɛ̈t than piny ë riɛl cï Wëi Nhialic yiëk ye, tënë kɔc cï lɔc bïk atuɔ̈ɔ̈cke. ");
INSERT INTO dikNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Nïn thiärŋuan thuɔnde cök ciëën, Jethu ëcï rot nyuɔɔth arak juëc tënë atuɔ̈ɔ̈cke, ku bïk ŋic, ke cïn diu, lɔn nadë ke yeen aŋot pïr. Yeen ëcï atuɔ̈ɔ̈cke tïŋ ku jiɛɛm ke ke käk bääny Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ku nawën cä atuɔ̈ɔ̈cke kenhïïm mat tɛ̈tök, ke thɔn ëlä, “Duɔ̈kkë jiël Jeruthalem. Tiɛtkë Wëi Nhialic cï Wä thɔn bï tuɔ̈c we, wäär ca lɛ̈k we. ");
INSERT INTO dikNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Joon acï kɔc muɔɔc nhïïm ë pïu, ku nïn lik, Wëi Nhialic bï we muɔɔc nhïïm abï tuɔ̈c we.” ");
INSERT INTO dikNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Nawën cï Jethu rɔ̈m kek atuɔ̈ɔ̈cke, ke thiëckë, “Bɛ̈ny, ba kɔc Itharel cɔl aa ben mac ëmën?” ");
INSERT INTO dikNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Go Jethu bɛ̈ɛ̈r ëlä, “Aköl le yen kë bï looi, ku käk bï looi, aaye Wä guiir riɛlde, ku acïn këdun thïn bäk ŋic ye nɛn bï kek röt looi. ");
INSERT INTO dikNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ku na la Wëi Nhialic bɛ̈n, ka bï we yiëk riɛl, ku wek aabï jam riɛnkiɛ̈ Jeruthalem ku Judia, ku Thamaria, ku jɔl a pinynhom ëbën.” ");
INSERT INTO dikNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Wën cï yen jam këya, ke jɔt nhial, ku ë dɛɛi kek, ku kum luät bïk cïï ben tïŋ. ");
INSERT INTO dikNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ku jɔlkë lïïth ke döt nhial, ku Jethu ke jiël. Tɛ̈ɛ̈n nyin yic ke röör karou cï ruk alɛ̈th ɣer bɔ̈, ku kɛ̈ɛ̈ckë atuuc lɔ̈m, ");
INSERT INTO dikNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ku luelkë, “Kɔc Galilia, yeŋö ye wek kɔ̈ɔ̈c ke we döt nhial? Yen Jethu, cï nyaai tënë we ku ɣɛ̈th nhial, abï la dhuk tɛ̈cït tɛ̈ cï wek ye tiɛ̈ŋ thïn ke la nhial.” ");
INSERT INTO dikNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Kaam wën, ka atuuc Jethu jiël gɔn Olip nhom thiääk kek gɛu ke cït kilomïter tök, ku dhukkë geeu Jeruthalem. ");
INSERT INTO dikNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Keek aacï jäl ɣet geeu ku lek ɣön yen ciëŋ kek thïn. Atuuc Jethu, aake yï Pïtɛr ku Joon, ku Jemith ku Andria, ku Pilipo, ku Thomath, ku Bartholomeo, ku Matheo, ku Jemith wën Alpawuth, ku Thaimon, raan man kɔc thäi bïk panden mac, ku jɔl a Judath wën Jemith. ");
INSERT INTO dikNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Keek aake ye lac rɔ̈m ku röökkë ke ya akut, kek diäär kɔ̈k ku Maria man Jethu ku wämäthakën. ");
INSERT INTO dikNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nïn lik cök, ke kɔc cï gam cït raan buɔɔt ku thiär-rou ëbën, aake cï kenhïïm mat. Go Pïtɛr rot jɔt ku jiɛɛm, ");
INSERT INTO dikNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Wämäthkiɛ̈, wɛ̈t cï gɔ̈t athör Wël Nhialic yic abï rot dhiɛl tiɛɛŋ. Wëi Nhialic ëcï wɛ̈t lɛ̈k Debit kë bï rot looi aköldä tënë Judath, raan bï Jethu nyuɔ̈th kɔc dɔm ye. ");
INSERT INTO dikNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judath ë ye raan akuɔ̈tda, ku yeen ëcï Jethu kuany bï la abaŋ luɔi bï looi luɔide yic.” ");
INSERT INTO dikNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","19","(Wëëu cï Judath riɔp luɔi rɛc cï looi, aacï yen ke dom ɣɔɔc, dom yen reet yen yeyic thïn ku thou. Kënë, aacï kɔc ke ciëŋ Jeruthalem piŋ ëbën, ku jɔlkë dom kënë aa cɔɔl thuɔŋden, rin cɔl Akeldama, ku wɛ̈tde yic “Ee Dom Riɛm.”) ");
INSERT INTO dikNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Ku acï gɔ̈t athör Waak Nhialic yic ëlä, ‘Bï ɣɔ̈nde yic ciɛ̈n kë tɔ̈ thïn, ku cïn raan ciëŋ thïn.’ “Ku ëcï gɔ̈t aya këlä, ‘Bï raan dɛ̈t nyiɛnde löök yic luɔi yic.’ ");
INSERT INTO dikNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Këya, raan adhil rot mät ɣo, ku bï ŋic cïmënda lɔn cï Jethu Bänyda rot jɔt raŋ yic. Raan buk mät ɣoyiic adhil a raan töŋ akuɔ̈tda. Ku ë raan ŋic käŋ tɛ̈ɣɔn jɔɔk Joon luɔiden miɔ̈c nhom cök, ku jɔl a tɛ̈wäär ye ɣok cath kek Jethu agut aköl jiël yen tënë ɣo bï ɣäth nhial.” ");
INSERT INTO dikNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ku jɔlkë kɔc karou gut rin, Jothep ku ë ŋic aya ke cɔl Barthabath (ë cɔl Juthtuth aya), ku Mathayo. ");
INSERT INTO dikNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ku röökkë ëlä, “Bɛ̈ny, yïn aŋic kë tɔ̈ raan ëbën puɔ̈u, këya, nyuɔ̈th ɣo raan töŋ nhiar kamken karou, ");
INSERT INTO dikNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ku bï luui ke ya atuuc nyin Judath wäär cï nyääŋ piny, ku ler tënë yen ye tɛ̈de.” ");
INSERT INTO dikNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ku jɔlkë cuɛt gɛk, ku bïk raan tök kuany kam ë kɔckä karou. Ku raan yen cïk bɛ̈n lɔc ë ye Mathayo, ku jɔl mɛt akut atuuc kathiäär ku tök yic. ");
INSERT INTO dikNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Na la aköl Yan Ayum cïn yic luɔu bɛ̈n, ka atuuc Jethu kuut kenhïïm ɣɔ̈n tök. ");
INSERT INTO dikNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Kam wën ke pɛ̈k wei arɔ̈ɔ̈l dɛ̈t piŋkë nhial, ku yen arɔ̈ɔ̈l kënë ë cït arɔ̈ɔ̈l yomdït ril. Ku jɔl arɔ̈ɔ̈l ɣön awën rëër kek thïn thiɔ̈ɔ̈ŋ yic. ");
INSERT INTO dikNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ku tïŋkë lɔ̈k mac cït liep ke tek rot piny, ku raan tök kamken ë ye kë cït liem mac nyuc yenhom. ");
INSERT INTO dikNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Keek ëbën, aake cï Wëi Nhialic lööny kegup ku jiɛɛmkë thok kɔ̈k, rin cï Wëi Nhialic ke yiëk riɛl ku bïk jam thok kɔ̈k cie thuɔkken. ");
INSERT INTO dikNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Kɔc juëc Itharel ke ciëŋ wuɔ̈t kɔ̈k yiic pinynhom, kɔc ke ye Nhialic door aake rɛ̈ɛ̈r Jeruthalem ë nïnkä. ");
INSERT INTO dikNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Wën cï kek arɔ̈ɔ̈l piŋ, go kɔc juëc röt kuɔ̈ɔ̈t. Kɔc ke cï röt kuɔ̈ɔ̈t aake cï gäi, kë ye atuuc Jethu jam thuɔkken. ");
INSERT INTO dikNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Wën cï kek gäi apɛidït gokë jam ke cï keröt jɔt apɛi, “Keek kɔc jam këlä aa kɔc Galilia! ");
INSERT INTO dikNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ye këdë, bïk aa jam thuɔkkua? ");
INSERT INTO dikNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ɣook ëbën ɣok aa kɔc wuɔ̈t kɔ̈k cïmën Parthia, Mede ku Elam, ku jɔl aa Methopotamia, Judia, ku Kapadokia, ku Pontuth ku Athia. ");
INSERT INTO dikNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Ku jɔl aa Prigia ku Pampilia. Ku jɔl a Ijip ku bɛ̈ɛ̈i kɔ̈k pan Libia thiääk kek Thirene. Ku kɔc kɔ̈k ɣoyiic aa kɔc wun cɔl Roma. ");
INSERT INTO dikNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Kɔc kɔ̈k aa kuat Itharel. Ku kɔc cie kɔc Itharel cï yäthken waar bïk yanh Itharel gam. Ku kɔc kɔ̈k ɣoyiic aa kɔc pan Kret ku pan Arab. Ku ë yen ŋot ye ɣok ke piŋ ke jam thuɔkkua, ke luel kädït cï Nhialic looi.” ");
INSERT INTO dikNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Aake cï gäi, ku muumkë nhïïm kë bïk lueel, gokë röt aa thiëëc kamken, “Yeŋö ye nyuɔɔth yen kënë?” ");
INSERT INTO dikNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Go kɔc kɔ̈k atuuc Jethu bui, ku luelkë ëlä, “Kɔckä aacï wiɛɛt mɔ̈u!” ");
INSERT INTO dikNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Tɛ̈në, ke Pïtɛr kam atuuc Jethu kathiäär ku tök jɔt rot, ku kɛ̈ɛ̈c ku jɔl jam ke cï yeröl jɔt tënë kɔc Itharel awën cï röt kuɔ̈ɔ̈t, “Wek wärkiɛ̈, wämäthkiɛ̈ Itharel, ku jɔl aa wek kɔc ciëŋ gen Jeruthalem, piɛŋkë wɛ̈tdiɛ̈ apath, ku ba we lɛ̈k kë cï rot looi. ");
INSERT INTO dikNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Kɔc yakë lueel ka cï muɔ̈l mɔ̈u, aa këc wiɛɛt, tɛ̈cït tɛ̈ ye wek ye tak thïn, akɔ̈l akëc tɔ̈ɔ̈ŋ, aŋot ye riɛl. ");
INSERT INTO dikNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ku wɛ̈t cï Juel raan käk Nhialic tïŋ lueel wäär akïn, ");
INSERT INTO dikNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Acï Nhialic lueel, lɔn kë bï looi aköl le nïn thök akïn, Ɣɛn abï Wɛ̈ikiɛ̈ tuɔ̈c kɔc ëbën. Wätkun ku nyiɛ̈rkun aabï kë bï rot looi aköldä lɛ̈k kɔc. Riënythii kun aabï nyuɔ̈ɔ̈th, ku röörkun dït aabï nyuääth arak juëc aya. ");
INSERT INTO dikNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ee yeen, agut aluakkiɛ̈ röör ku diäär, nïnkui bï bɛ̈n. Ɣɛn abï wɛ̈ikiɛ̈ tuɔ̈c kɔc ë nïnkä, ku keek aabï käk bï röt looi aa lɛ̈k kɔc. ");
INSERT INTO dikNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ɣɛn abï kädït jäŋ gɔ̈i looi nhial, ku käjuëc jäŋ gɔ̈i aaba looi pinynhom. Pinynhom abï thiäŋ riɛm, ku mac, ku jɔl a tol dïttet. ");
INSERT INTO dikNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Akɔ̈l abï nïïp nyin, ku pɛɛi abï thiɛth cïmën riɛm ee kaam këc aköldït puɔth bɛ̈n Bänyda guɔ ɣëët. ");
INSERT INTO dikNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ku raan bï Nhialic rɔ̈ɔ̈k ku bï ye kony abï poth bï cïï la pan mac.’ ");
INSERT INTO dikNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Piɛŋkë wëlkä, wek wämäthkiɛ̈n cɔl Itharel! Jethu raan pan Nadharet ë ye raan cï riɛl Bänyda nyuɔɔth ke cïn diu käkken dït jäŋ gɔ̈i cï Nhialic looi riɛnke. Ee kë ŋiɛckë kek we, rin aacï röt looi kamkun. ");
INSERT INTO dikNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Cït tɛ̈ cï Nhialic ye guiɛɛr thïn, Jethu ë bï thɔ̈n we, ku bäk nɔ̈k cïmën cï wek ye puɔ̈l ku bï kɔc rɛc la gup adumuɔ̈ɔ̈m nɔ̈k, ku piɛ̈ɛ̈tkë tim cï rïïu kɔ̈u. ");
INSERT INTO dikNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ku yeen acï Nhialic cɔl aben pïr thou yic, wën cï yen Jethu nyaai riɛlde thou yic, rin ëcïï rot kɔŋ lëu yen lɔn bï Jethu teem thou yic. ");
INSERT INTO dikNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","“Aŋicku lɔn ëcïï rot bï lëu rin ëcï Debit lueel ëlä, ‘Ɣɛn ee Nhialic tïŋ ɣanhom akölriëëc ëbën, ku yen athiɔ̈k kek ɣɛn, ku ɣɛn acïn kë bä diir. ");
INSERT INTO dikNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Rin ee wɛ̈t kënë, ɣɛn amit puɔ̈u. Ku wël ya lueel aa wël raan mit puɔ̈u. Ku cɔk amën bï ɣɛn thou, ke ɣɛn abï thiɔ̈k ke ɣa ŋɔ̈th kë bï Nhialic luɔ̈i ɣɛn, ");
INSERT INTO dikNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","rin Nhialic acïï guäpdiɛ̈ bï puɔ̈l bï rëër kam kɔc cï thou, ku Nhialic acïï ɣa bï puɔ̈l ba dhiäth raŋ yic ɣɛn raande. ");
INSERT INTO dikNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Yïn Nhialic, yïn acä nyuɔ̈th dhël pïïr akölriëëc ëbën, ku jɔl aa rɛ̈ɛ̈rdu kek ɣɛn, abä cɔl amit puɔ̈u.’ ");
INSERT INTO dikNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Wämäthkiɛ̈, wek aaba dhiɛl lɛ̈k kë ŋiɛc rin wädan dït cï wëlkä lueel. Yen Debit acï thou ku thiäk, ku raŋde kïn aa dɛɛi ɣok, agut cï ya aköl. ");
INSERT INTO dikNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Yen Bɛ̈nyŋaknhom wäär pïïr yen ë ye raan käŋ tïŋ, käk bï röt looi aköldä, ku lëk ke kɔc, ku ë ŋic kë cï Nhialic lueel ke bï luɔ̈i ye. Nhialic ëcï yepuɔ̈u tɔɔŋ lɔn nadë ke bï raan tök kuatde yic, looi keye bɛ̈ny cïmënde. ");
INSERT INTO dikNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Debit ëcï kë bï Nhialic looi tïŋ, go jäl jam lɔn bï Raan cï lɔc ku dɔc rot jɔt raŋ yic wën cï yen ye lueel ëlä, ‘Yen ë këc nyääŋ kam kɔc cï thou, guäpde ë këc dhiäth raŋ yic.’ ");
INSERT INTO dikNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“Nhialic ëcï Jethu jɔ̈t bei raŋ yic bï bɛn pïr, ku ɣɛn ku atuuc kɔ̈k Jethu acuk tïŋ yen yiny cï rot looi. ");
INSERT INTO dikNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Jethu acï jat nhial ku nyuuc köŋ cuëc Wun, ku ë yen acï ɣok tuɔ̈c Wëi Nhialic, cït tɛ̈wäär cï Nhialic ye luɛɛl thïn. Ku kë cäk tïŋ ku piɛŋkë ëmën ë ye kën cï Nhialic lueel ka bï tuɔ̈ɔ̈c yen acï lööny ɣogup. ");
INSERT INTO dikNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Acie Debit yen cï la nhial, ee cï lueel, ‘Ee cï Nhialic lɛ̈k Bänydiɛ̈, “Nyuc ë tɛ̈n köŋdiɛ̈n cuëc, ");
INSERT INTO dikNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","agut aköl bï ɣɛn kɔc man yïïn cɔl aloi nhïïm, ku bïk yïcök.” ’ ");
INSERT INTO dikNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Wek kɔc pan Itharel ëbën, dhiɛlkë ŋic alanden lɔn nadë ke Jethu yen cäk piäät tim cï rïïu kɔ̈u, yen acï Nhialic looi bï ya yen Bɛ̈ny, ku ye Raan cï lɔc ku dɔc.” ");
INSERT INTO dikNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Wën cï kɔc cï röt kuɔ̈ɔ̈t wɛ̈t Pïtɛr piŋ, gokë ya tak yic ke diɛɛr kë bïk looi, ku thiëckë Pïtɛr ku atuuc kɔ̈k Jethu, “Buk ŋö looi wämäthakua?” ");
INSERT INTO dikNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Go Pïtɛr bɛ̈ɛ̈r, “Dhuɔ̈kkë wepuɔ̈th ciëën adumuɔ̈ɔ̈mkun yiic, ku calkë röt aa muɔc nhïïm bäk aa kɔc Jethu Krïtho, ku bï Nhialic adumuɔ̈ɔ̈mkun päl piny, ku wek aabï Nhialic muɔɔc wɛ̈ike, ku bï lööny wegup. ");
INSERT INTO dikNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kënë yen cï Nhialic yepuɔ̈u tɔɔŋ, ka bï yiëk we ku miɛ̈thkun, ku kɔc bɛ̈ɛ̈i kɔ̈k mec, ku kɔc ëbën ye Bänyda Nhialic cɔɔl bïk aa kacke.” ");
INSERT INTO dikNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pïtɛr acï kɔc lɛ̈k ku jiëëm kenhïïm ëlä, “Kuɔnykë röt ku bäk liu awuɔ̈c yic, awuɔ̈c yen bï tɛ̈m kɔc rɛc akölë!” ");
INSERT INTO dikNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Kɔc juëc ë kɔc awën yiic aacï kë cï Pïtɛr lɛ̈k ke gam, ku cɔlkë röt amuɔc nhïïm, ku ë cït tɛ̈në raan tiim kadiäk kek aacï bɛ̈n muɔɔc nhïïm aköl kënë, ku mɛtkë akuɔ̈tden yic. ");
INSERT INTO dikNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Keek aacï rëër bï atuuc Jethu ke piɔ̈ɔ̈c, ku yekë atuuc Jethu kony käk yekë looi yiic ku mïthkë tɛ̈tök, ku yekë rɔ̈m ku röökkë tɛ̈tök. ");
INSERT INTO dikNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Käjuëc jäŋ gɔ̈i aacï Nhialic cɔl aa looi atuuc Jethu, ku yen acï kɔc juëc cɔl ariɔ̈c. ");
INSERT INTO dikNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Kɔc cï gam ëbën aacï rëër bïk ceŋ tɛ̈tök, ku yekë röt kony kedhie bïk käŋ aa wɛ̈ɛ̈r kamken. ");
INSERT INTO dikNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Aacï käk tɔ̈ ke ke bɛ̈ɛ̈i yiic aa ɣaac wei, ku yekë wëëu tɛ̈k röt, ku raan tök ë ye yiëk wëëu bï käkken wïc lëu. ");
INSERT INTO dikNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Kek kɔc cï wɛ̈t Jethu gam aake ye rɔ̈m akölaköl luëk Nhialic kɔc Itharel yic, ku yekë rɔ̈m bääiken yiic ku mïthkë ke cïï mïïth bɛ̈th ku rëërkë ke mit puɔ̈th, ");
INSERT INTO dikNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ku yekë Nhialic leec ku lec kɔc kɔ̈k ke aya. Ku ye Nhialic akuɔ̈tden juak yic akölaköl kɔc kek cï Nhialic cɔl aa poth kërac yic. ");
INSERT INTO dikNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ɣɔn akäl tök, tääŋ akɔ̈l, tɛ̈ ye kɔc röök, Pïtɛr ku jɔl a Joon aake cï la kal luaŋ Nhialic ye kɔc Itharel röök thïn bïk la röök. ");
INSERT INTO dikNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Wën cï kek ɣet kal cɔl Kal Dhëŋ thok, ke yök mony cï dhiëëth ke ye aduany. Yen mony kënë ë ye cool tɛ̈ jɔt ye kal thok, ku bï kɔc la kal luaŋ Nhialic ya lim wëëu. ");
INSERT INTO dikNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nawën tïŋ Pïtɛr ku Joon ke la kal yic goke lim. ");
INSERT INTO dikNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Gokë döt nyin ku lëk Pïtɛr ye, “Daai ë ɣook!” ");
INSERT INTO dikNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Goke döt, ku ye yök yepuɔ̈u ciɛ̈t la kë bï yök tënë ke. ");
INSERT INTO dikNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Go Pïtɛr lɛ̈k ye, “Ɣɛn acïn wëëu ba yiëk yï, ku yïn aba yiëk kë tɔ̈ kek ɣa, ‘Yïn aya yɔ̈ɔ̈k, rin Jethu raan Nadharet, jɔt rot ku ba cath!’ ” ");
INSERT INTO dikNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ku dɔm köŋ cuëc, ku kony bï rot jɔt. Kaam wën ke cök ku kuiɛc monytui go guɔ riɛl, ");
INSERT INTO dikNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ku puur rot nhial ku kɛ̈ɛ̈c cɔ̈kke ku ciɛth. Ku ler kal luaŋ Nhialic ke keek ke cath ke thuɛɛt nhial, ke lec Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ku kɔc tɔ̈ luaŋ Nhialic ëbën ë cïk tïŋ ke cath, ke lec Nhialic, ");
INSERT INTO dikNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ku wën cï kek ye ŋic ke mony dhie nyuc kal cɔl Kal Dhëŋ thok ku lïm, gokë gäi apɛidït ku nyamkë kethook, ku yekë röt thiëëc kë cï rot looi tënë ye. ");
INSERT INTO dikNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Wën cï mony aduany Pïtɛr ku Joon kuak yiëth, go kɔc ke tɔ̈ kal luaŋ Nhialic yic gäi ëbën, ku riŋkë tɛ̈wën rëër kek thïn kät cök, Kän Tholomon kal luaŋ Nhialic yic. ");
INSERT INTO dikNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Nawën tïŋ Pïtɛr kɔc, ke lueel, “Wek kɔc Itharel, yeŋö ye wek gäi kë cï rot looi, ku yakë lïïth ɣo? Yakë tak lɔn nadë ke ye riɛlda ku piathda ɣopɛ̈c yen kony ɣok mony kënë bï cath? ");
INSERT INTO dikNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Nhialic wärkuan dït Abaram, ku Ithäk, ku Jakop yen acï riɛl yiëk aluɔnyde Jethu. Ku yen aa cäk gam tënë kɔc kek ke mac baai, ku wek aacï jai bï Pilato cïï lony cɔk alɔn wïc yen ye bï lony. ");
INSERT INTO dikNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Yen Jethu ë ye raan Nhialic ku ë ye raan path, ku wek aacï kuec ye, ku lɛ̈kkë Pilato bï wɛ̈tdun gam bï raan yen cï kɔc nɔ̈k lony, ku ye Jethu yen nɛ̈k. ");
INSERT INTO dikNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ku ë këya, wek aacï raan nɔ̈k raan yen dhël pïr nyooth, ku yeen acï Nhialic jɔt raŋ yic bï pïr ku acuk tïŋ ke cï rot looi. ");
INSERT INTO dikNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ee riɛlde yen Jethu, yen acï mony aduany cɔl acath. Kë cäk tïŋ, ku ŋiɛckë ë loi ku wɛ̈t cï ɣok Jethu gam, ee wɛ̈t cï ɣok wɛ̈t Jethu gam yen acï ye cɔl apuɔl, agut tɛ̈ ciɛth yen wenhïïm cït ëmën. ");
INSERT INTO dikNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Ku ëmën wek wämäthkiɛ̈, aŋiɛckë yen kë cäk looi kek we ku bänykun cï wek Jethu nɔ̈k, ee luɔikë ke kuɔ̈ckë. ");
INSERT INTO dikNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ëcï Nhialic lɛ̈k kɔc käk Nhialic tïŋ thɛɛr lɔn bï raan luäk kɔc gum, ku yen acï rot dhiɛɛl thïn ke ye yic këya. ");
INSERT INTO dikNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ke yeen, pälkë luɔi kärɛc, ku ye wɛ̈t Nhialic yen gamkë, ku bï Nhialic adumuɔ̈ɔ̈m cäk looi päl piny, ");
INSERT INTO dikNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ku na luɔikë këya, ka aköldä ke Nhialic abï we yiëk riɛl Wɛ̈ike, ku abï we tuɔ̈c Jethu yen cï lɔc tënë we ku bï we kony. ");
INSERT INTO dikNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Jethu abï rëër pan Nhialic agut aköl bï käŋ ëbën bɛn waar piiny bïk aa yam, cït tɛ̈ cï Nhialic ye luɛɛl thïn thɛɛr wäär tënë kɔcken käkke tïŋ. ");
INSERT INTO dikNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","“Yeen ëcï Mothith lueel ëlä, ‘Nhialicdun abï we tuɔ̈c raan käŋ tïŋ, cïmën cï yen ɣa tuɔ̈c we, ku yeen abï ya raan kuatdun. ");
INSERT INTO dikNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ku wek aadhil këriëëc ëbën bï lɛ̈k we gam. Ku raan cïï wël raan käŋ tïŋ bï gam, acïï bï mat kɔc Nhialic yiic.’ ");
INSERT INTO dikNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ku kɔc käŋ tïŋ, la kë cïk lueel agut cï Thamuel, ku kɔc cï lɔ̈k bɛ̈n yecök aacï kë loi rot ë nïnkä lueel. ");
INSERT INTO dikNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Käk cï Nhialic lueel ka bï luɔ̈i we, käk cï kɔc käŋ tïŋ lɛ̈k we aa käkkun. Ku week dhiɛlkë röt mat thïn, ku bäk kë cï Nhialic lɛ̈k wärkun dït ka bï yiëk ke tek wedhie. Cïmën ɣɔn cï yen ye lɛ̈k Abaram ëlä, ‘Ku kuatdu yic yen abï ɣɛn kɔc pinynhom dɔɔc.’ ");
INSERT INTO dikNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ke yen Nhialic acï raan bï këde bɛ̈n looi lɔc, cɔl Jethu ku tuuc tueŋ, ku bï we dɔɔc, ku bï we cɔl awel wepuɔ̈th wei luɔi kärɛc yiic.” ");
INSERT INTO dikNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Tɛ̈wën jiɛɛm Pïtɛr tënë kɔc ku Joon ke kääc yelɔ̈ɔ̈m, ke kɔc kɔ̈k käk Nhialic, ku bɛ̈ny apuruuk ɣön Nhialic tiit, ku jɔl aa kɔcdït kɔ̈k, kɔc akut Thaduthï bɔ̈. ");
INSERT INTO dikNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Keek aake cïï puɔ̈th mit wɛ̈t ye Pïtɛr ku Joon kɔc piɔ̈ɔ̈c lɔn nadë ke Jethu acï rot jɔt kam kɔc cï thou. Kënë aye nyuɔɔth lɔn nadë raan cï thou alëu bï bɛn pïr. ");
INSERT INTO dikNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Gokë ke dɔm ku lek ke mac agut ɣɔn nhiäk, rin cï akɔ̈l cuɔl. ");
INSERT INTO dikNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ku kɔc juëc cï wɛ̈t Pïtɛr piŋ aacï gam, ku juakkë röt bïk ciɛ̈t tiim kadhiëc. ");
INSERT INTO dikNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Nawën aköl dɛ̈ɛ̈të ke bäny Itharel ku kɔcdït baai, ku jɔl aa kɔc piööc lööŋ, kuut kenhïïm Jeruthalem. ");
INSERT INTO dikNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Keek aacä amat jäl looi kek raandït käk Nhialic cɔl Anath, ku jɔl aa Kaipa, ku Joon, ku Alekdhändɛ̈r, ku kɔc kɔ̈k many Anath thok. ");
INSERT INTO dikNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Keek aacï Pïtɛr ku Joon cɔl aabï kenhïïm, ku jɔlkë ke thiëëc, “Ee luɔikë këdë ku bï raan aduany cath? Ye riɛl ŋö yen tɔ̈ kek we ku ye rin ŋa yen looi wek ye?” ");
INSERT INTO dikNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Go Pïtɛr ke cï guɔ̈p thiäŋ riɛl Wëi Nhialic, dhuɔ̈k ke, “Wek bäny ku kɔcdït baai. ");
INSERT INTO dikNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Na yakë ɣo thiëëc yaköl këpuɔɔth cï looi tënë raan aduany ku tɛ̈ cï ye kuɔny thïn, ");
INSERT INTO dikNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ka dhiɛlkë ŋic, ku adhil kɔc Itharel ŋic ëbën, lɔn raan kääc wenhïïm ke cï pial, ee riɛl Jethu raan Nadharet wäär cäk piäät tim cï rïïu kɔ̈u, ku jɔt Nhialic raŋ yic. ");
INSERT INTO dikNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jethu ë yen raan cï wɛ̈tde gɔ̈t athör thɛɛr wël Nhialic yic ëlä, ‘Mën yen cï wek kuec wek atëët loi ɣöt, yen acï bɛ̈n yök ke ye mën ril apɛidït.’ ");
INSERT INTO dikNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","“Ee yen Jethu yen abï kɔc cɔl apoth la pan mac, ee yen raan tööŋ yen cï Nhialic yiëk riɛl pinynhom ku bï ɣo kony.” ");
INSERT INTO dikNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Go bäny luk jäl gäi wën cï kek Pïtɛr ku Joon tïŋ tɛ̈ cï kek puɔ̈th ril thïn, ku keek aake ye kɔc ë path këc piöc. Yeen acïk ŋic lɔn nadë ke keek aake ye cath kek Jethu. ");
INSERT INTO dikNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ku acïn kë cïk lueel, rin cï kek raan aduany wën cï kony tïŋ ke kääc kek Pïtɛr ku Joon. ");
INSERT INTO dikNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Go bäny Pïtɛr ku Joon yɔ̈ɔ̈k bïk la aɣeer ɣööt ku lökkë jääm yic kepɛ̈c. ");
INSERT INTO dikNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ku jɔlkë röt jäl thiëëc kamken, “Ye kën ŋö buk luɔ̈i ë kɔckä? Raan ëbën Jeruthalem aŋic kë cï rot looi, këdït jäŋ gɔ̈i cït ë kën cïk looi, ku acïï lëu buk jai. ");
INSERT INTO dikNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ku rin buk cïï päl, bï kë cï rot looi thiëi baai yic, ke keek abuk yɔ̈ɔ̈k bïk cïï ben jam tënë raan dɛ̈t rin Jethu.” ");
INSERT INTO dikNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ku jɔlkë Pïtɛr ku Joon caal ɣöt ku lëkkë ke, cɔk alɔn ben ŋö yiëndë, ke duɔ̈kkë ben jam, duɔ̈kkë kɔc ben piɔ̈ɔ̈c rin Jethu. ");
INSERT INTO dikNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Go Pïtɛr ku Joon dhuɔ̈k ke, “Week nhïïm alɛ̈ukë bäk guɔ luk tɛ̈ ye Nhialic tiɛ̈ŋ ye lɔn bï ya wɛ̈tdun yen buk gam, ku lɔn ye yen wɛ̈t Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ɣook acuk lëu buk kɔ̈ɔ̈c, buk cïï ben jam rin Jethu, rin cï ɣok käkken cï looi tïŋ, ku piŋku wël cï lueel.” ");
INSERT INTO dikNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Go bäny luk ke thɔ̈n apɛi bïk cïï ben jam rin Jethu, ku lonykë ke bïk jäl. Ee cï bäny luk tïŋ lɔn ril yen yic, bïk ke tɛ̈m awuɔ̈c, rin kɔc aake tɔ̈ kelɔ̈m ku aake ye kiu, ku aake lec Nhialic wɛ̈t këpuɔth cï rot looi. ");
INSERT INTO dikNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Mony aduany yen cïk cɔl apuɔl ë ye raandït, ruɔ̈nke aake ye thiärŋuan ku tɛ̈ kac. ");
INSERT INTO dikNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Nyin yic tɛ̈wën cï ke lony, ke Pïtɛr ku Joon dhuk tënë kɔc akuɔ̈tden, ku lëkkë ke kä cï kɔcdït käk Nhialic ku kɔcdït baai lɛ̈k ke. ");
INSERT INTO dikNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nawën piŋkë ë wëlkä, ke röök Nhialic puɔ̈u ëbën ëlä, “Bɛ̈ny, yïn Aciëŋ nhial ku piny ku wër ku käk pïr thïn ëbën! ");
INSERT INTO dikNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Yïn acï Wɛ̈iku tooc bï Wädan dït thɛɛr Debit, raan ye aluɔnydu wɛ̈tdu lɛ̈k kɔc, ku ëcï lueel ëlä, ‘Yeŋö cï kɔc cie kɔc Itharel puɔ̈th riääk apɛi këlä, yeŋö cï kɔc kekɔ̈ɔ̈th wel bïk kärɛc aa looi tënë Nhialic? ");
INSERT INTO dikNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Bänydït ë pinynhom aake cï röt guiir, ku mat kɔc ke mɛc bɛ̈i kenhïïm, bïk kërac luɔ̈i Nhialic ku jɔl a Raan cï lɔc ku dɔc, raan bï Nhialic tuɔ̈ɔ̈c piny.’ ");
INSERT INTO dikNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Ku yeen ë ye yic, Antipäth Ɣërot ku Pilato aake cï mat kedhie Jeruthalem ë tɛ̈n kek kɔc cie kɔc Itharel, ku jɔl aa kɔc Itharel rin Jethu aluaŋdun cïn guɔ̈p acuɔl, ku yeen ë yen ca looi ke ye Raan cï lɔc ku dɔc. ");
INSERT INTO dikNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Keek aake cï kenhïïm mat, ku bïk käkkun ke ca tak riɛldu thɛɛr, ka bï röt looi, bïk ke looi. ");
INSERT INTO dikNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ku yeen ëmën bɛ̈ny, tïŋ ke aacï ɣok cuɛ̈k thook, kony ɣok, ɣok aluakku, ku buk wɛ̈tdu aa lɛ̈k kɔc ke cïn riɔ̈ɔ̈c. ");
INSERT INTO dikNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Kony ɣo, tar yïcin riɛl kɔ̈ŋdu, buk kɔc aa kony ku yiëk ɣo riɛl buk kädït kɔc gɔ̈i aa looi rin aluaŋdun cïn guɔ̈p acuɔl Jethu.” ");
INSERT INTO dikNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Wën cï kek jäl thök röök, ke la kë yiɛ̈ɛ̈k tɛ̈n awën mɛ̈t kek thïn. Keek aake cï Wëi Nhialic bɛ̈n kegup, ku jɔlkë guɔ jɔɔk bïk wɛ̈t Nhialic piɔ̈ɔ̈c tënë kɔc ke cïn riɔ̈ɔ̈c. ");
INSERT INTO dikNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Akut kɔc cï gam ëcï mat ë tök. Ee cïn raan tööŋ ye luel kamken lɔn nadë käk tɔ̈ kek ye aa käkke yetök, ku aake käk rɛ̈ɛ̈r ke ke rɔm. ");
INSERT INTO dikNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Atuuc Jethu aake cï Nhialic yiëk riɛldït, ku bïk aa lueel ke cïï riɔ̈c lɔn cï Jethu Bänyda rot jɔt raŋ yic. Ku keek aya, aake cï Nhialic dɔɔc apɛidït. ");
INSERT INTO dikNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Ë cïn raan töŋ ŋɔ̈ŋ akuɔ̈tden yic. Kɔc ke la dum kamken ku ɣööt aake cïk ɣaac, ku bïïkë wëëu cïk kek käŋ ɣaac, ku yekë ke gäm atuuc Jethu. Ku wëëu aake yekë tɛ̈k röt cït këwïc raan tök kamken. ");
INSERT INTO dikNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","Ku këya, Jothep raan dhiënh Lebï, dhiëth pan Thaipruth, ku yeen ë ye atuuc Jethu cɔɔl, ke cɔl Barnaba (ku wɛ̈tde yic “Ee raan kɔc riɛɛl puɔ̈th”) ecï duɔmde ɣaac wei aya, ku bïï wëëu ëbën ku gɛ̈m ke atuuc Jethu. ");
INSERT INTO dikNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Mony cɔl Ananiath ë tɔ̈ thïn ku jɔl a tiɛŋde Thapira. Keek aake cï abɛ̈k käkken baai ɣaac wei. ");
INSERT INTO dikNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ku yen Ananiath ëcï wɛ̈t mat yic kek tiɛŋde ku bïk wëëu abɛ̈k thiaan, ku yïkkë atuuc Jethu abɛ̈k. ");
INSERT INTO dikNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Go Pïtɛr Ananiath jäl thiëëc ëlä, “Yïn Ananiath, ë rin ŋö cɔl yïn rot alëu jɔŋrac, ku ba Wëi Nhialic bɛ̈n lɛ̈k lueth, ku yïn amuk abɛ̈k wëëu kek cï yïn ke käkku ɣaac wei? ");
INSERT INTO dikNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Tɛ̈wäär këc yïn käk paandu ɣaac, aake ye käkku, ku wëëu cï yïn ke ɣaac aa käkku aya. Ye rin ŋö tɛk yïn kë cït kënë ba looi? Yïïn aacie ɣok ca wëëŋ, ee Nhialic yen aca wëëŋ!” ");
INSERT INTO dikNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Kaam wën piŋ Ananiath ye, ke wiɛ̈ɛ̈k piny ku thou. Ku kɔc ke cï ye piŋ aacï bɛ̈n riɔ̈ɔ̈c. ");
INSERT INTO dikNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Go riënythii ke rɛ̈ɛ̈r ɣööt guäpde kuɔ̈th ku jɔtkë, ku lek thiɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kaam wën looi kënë rot, ke tiŋ Ananiath bɔ̈ ɣön wën tɔ̈ Pïtɛr thïn, ku ë kuc kë cï rot looi. ");
INSERT INTO dikNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Go Pïtɛr thiëëc ëlä, “Lɛ̈k ɣa yic, ye käkkä kek wëëu ëbën cï wek käŋ ɣaac wek muɔnydu?” Go Thapira bɛ̈ɛ̈r, “Ee tɛ̈den, aa kek wëëu ëbën.” ");
INSERT INTO dikNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Go Pïtɛr lɛ̈k Thapira ëlä, “Yeŋö tɛk wek ye wek muɔnydu bäk Wëi Nhialic them? Yeŋö looi wek këcït kënë, ca kɔc bɔ̈ kä piŋ cök? Aa kɔc ke cï muɔnydu la thiɔ̈k, ku ëmën aya aabï jɔt bïk yï la thiɔ̈k.” ");
INSERT INTO dikNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Kaam wën, ke Thapira wiɛ̈ɛ̈k piny ku thou nyin yic. Go riënythii bɛ̈n ɣöt, ku tïŋkë ke cï thou, gokë jɔt ku lek thiɔ̈k muɔnyde lɔ̈ɔ̈m. ");
INSERT INTO dikNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kɔc ke tɔ̈ ɣön Nhialic ku kɔc kɔ̈k cï kë cï rot looi piŋ, aacï bɛ̈n riɔ̈ɔ̈c apɛidït. ");
INSERT INTO dikNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Käkdït jäŋ gɔ̈i apɛi aake cï atuuc Jethu aa looi kam kɔc. Kɔc ke cï wɛ̈t Jethu gam aake ye mat ke ya akut Kän Tholomon cök. ");
INSERT INTO dikNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ee cïn raan tök kam kɔc cie kɔc akuɔ̈tden cï ye tak bï mɛt keyiic, cɔk aa lɔn ye kɔc juëc ke leec. ");
INSERT INTO dikNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ku kɔc juëc apɛidït, yɔ̈ɔ̈m röör ku diäär ke cï wɛ̈t Jethu gam, aake ye röt mat akuɔ̈tden yic. ");
INSERT INTO dikNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Wɛ̈t käpuɔth ye kɔc Jethu looi, aake cï kɔc tuany cɔl aaye kɔc ruääi ke ke jat dhɔ̈l yiic, ke cï tääc biök yiic, ku bï Pïtɛr ke dɔɔc tɛ̈ ciɛth yen. Na cie këya, ku cɔk a atiɛ̈mde ke kum ke piny ku bïk pial. ");
INSERT INTO dikNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ku kɔc juëc bɛ̈ɛ̈i thiääk kek Jeruthalem yiic, aacï kɔcken tuany ku kɔcken kɔ̈k la gup jakrɛc bɛ̈n aa bɛ̈ɛ̈i, ku aacï ke bɛ̈n aa kony. ");
INSERT INTO dikNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Tɛ̈wën, ke raandït käk Nhialic, ku kɔcken rɛ̈ɛ̈r ke ye, ku jɔl aa kɔc ye buɔɔth tɔ̈ akut Thaduthï yic, aake cïï puɔ̈th mit tënë atuuc Jethu. Gokë tak ku bïk kërac looi tënë ke. ");
INSERT INTO dikNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ku dɔmkë atuuc Jethu ku riitkë ke ɣön ye kɔc mac thïn. ");
INSERT INTO dikNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ku ë wɛ̈ɛ̈r kënë, ka atuny Nhialic bɔ̈ ku tuërkë ke bei ɣööt, ku wɛt kenhïïm aɣeer, ku lëk ke ëlä, ");
INSERT INTO dikNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Lakkë luaŋ Nhialic, ku bäk kɔc la piɔ̈ɔ̈c wɛ̈t pïr yam cï Jethu lɛ̈k we.” ");
INSERT INTO dikNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Go atuuc Jethu wɛ̈t cï lɛ̈k ke piŋ, ku lek luaŋ Nhialic durdur yic, ku jɔkkë piööc wɛ̈t Nhialic. Go raandït käk Nhialic kek kacke, kɔcdït baai Itharel cɔɔl ku bïk bɛ̈n luk yic, ku bïk mat. Ku jɔlkë thok tuɔɔc tënë apuruuk tit ɣön mɛ̈c, ku bïk atuuc Jethu kuɛ̈ɛ̈th luk yic. ");
INSERT INTO dikNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Tɛ̈wën ɣeet kɔc wën cï tooc, ke keek akëc atuuc Jethu la yök ɣöt, gokë dhuk ku lek thok lɛ̈k bäny luk ëlä, ");
INSERT INTO dikNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Wën ɣeet ɣok, ɣok aacï ɣöt yök ke riɛɛt thook ku kɔc tït ke kääc yethok. Nawën ŋanyku thok ka cïn raan tööŋ cuk yök alɔŋthïn.” ");
INSERT INTO dikNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nawën piŋ bɛ̈ny apuruuk luaŋ Nhialic tiit ku jɔl aa kɔcdït käk Nhialic, gokë gäi kë cï rot luɔ̈i atuuc Jethu. ");
INSERT INTO dikNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Kaam wën, ke raan bɔ̈ ɣöt ku lëk ke ëlä, “Piɛŋkë këdiɛ̈ɛ̈n, kɔc kek ke cäk riɛɛt ɣöt, aa rɛ̈ɛ̈r luaŋ Nhialic ëmën, ku aa piööc kɔc wɛ̈t Jethu!” ");
INSERT INTO dikNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Tɛ̈ɛ̈n, go bɛ̈ny apuruuk la kek apuruuk bïk ke diëc, ku bïïkë ke luk yic. Keek akëc atuuc Jethu kuaath, wɛ̈t riɔ̈ɔ̈c kek ciɛ̈t ke bï kɔc ke nhiar atuuc Jethu biɔ̈ɔ̈k aleel. ");
INSERT INTO dikNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Tɛ̈wën cï apuruuk atuuc Jethu jäl bɛ̈ɛ̈i luk yic, go raandït käk Nhialic ke thiëëc ëlä, ");
INSERT INTO dikNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Wek aa we cï thɔn apɛidït ku bäk kɔc cïï ben piööc wɛ̈t Jethu. Tiɛ̈ŋkë kë cäk looi! Cï wek kɔc piɔ̈ɔ̈c ëbën Jeruthalem, ku week awiɛ̈ckë ku bï aa ɣok ye gɔ̈k lɔn nadë ka ɣok aa cɔl Jethu anäk.” ");
INSERT INTO dikNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Go Pïtɛr kek atuuc Jethu wɛ̈t raandït käk Nhialic dhuk nhom ëlä, “Ɣook, ee Nhialic yetök yen alëuku buk theek, ku aacie kɔc ë path. ");
INSERT INTO dikNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Wek aacï Jethu nɔ̈k, ku piäätkë tim cï rïïu kɔ̈u, ku yeen acï Nhialic wärkuan dït jɔt thou yic. ");
INSERT INTO dikNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Jethu acï Nhialic jɔ̈t bei raŋ yic, ku le nyuɔ̈ɔ̈c köŋden cuëc ku looi ye bɛ̈ny, ku ë raan bï kɔc kuɔ̈ny bei kärɛc yiic. Ku yeen abï kɔc Itharel päl kaam, ku bïk kenhïïm waar bïk cïï ben luui kärɛc, ku bï Nhialic adumuɔ̈ɔ̈mken päl piny. ");
INSERT INTO dikNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ɣok aacï käk cï Nhialic looi tïŋ, ku Wëi Nhialic aya, yen cï Nhialic tuɔ̈c kɔcken wɛ̈tde gam, ee käk cï Nhialic looi nyuɔ̈th kɔc.” ");
INSERT INTO dikNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Tɛ̈wën piŋ bäny luk wɛ̈t cï atuuc Jethu lɛ̈k ke, gokë puɔ̈th riääk apɛidït, ku wïckë bïk ke nɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Go raan tök kam bäny, Gamaliel, raan akut Parathï. Ku yeen ë ye raan piööc lööŋ. Ku ë ye raan theek kɔc Itharel apɛidït, rot jɔt luk yic ku lëk apuruuk ku bïk atuuc Jethu kuaath aɣeer luk yic. ");
INSERT INTO dikNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ku jɔl bäny luk lɔ̈k jääm nhïïm ëlä, “Wek kɔc wuɔ̈nda Itharel, takkë wenhïïm apath kë wiɛ̈ckë bäk luɔ̈i ë kɔckä. ");
INSERT INTO dikNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Wäär ë run thiɔ̈kkä yiic raan cɔl Theudath ëcï tuɔ̈l, ku nyooth rot ke ya aciëŋ dït ril tör, abï raan buɔt kaŋuan röt mät ye. Yen Theudath acï bɛ̈n nɔ̈k, ku kɔc ke cï wɛ̈tde gam aacï bɛ̈n thiäi, ku ë yen thök wɛ̈tde. ");
INSERT INTO dikNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Raan cɔl Judath ku ë ye raan wun cɔl Galilia, ëcï bɛn tuɔ̈l aya ruɔ̈ɔ̈n ɣɔn kueen kɔc, ku yeen ëcï kɔc rac nhïïm agut bï raan tɛ̈dït wɛ̈tde gam, ku yekë buɔɔth cök. Yeen aya acï bɛ̈n nɔ̈k, ku wɛɛr kɔcken wäär ye buɔɔth. ");
INSERT INTO dikNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ku ëmën alɛ̈k we, aŋuɛ̈ɛ̈n bï ciɛ̈n kërɛɛc luɔikë tënë ke. Aŋuɛ̈ɛ̈n bäk ke puɔ̈l! Na yekë loikë, kë cï raan tak bï looi, ka ŋuɔt bï guɔ yäi. ");
INSERT INTO dikNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ku na ye Nhialic yen cï ke yiëk riɛl, ka cäk bï lëu. Rin wek aabï röt yök ke ye Nhialic yen thär kek we. Go bäny luk wɛ̈t Gamaliel gam.” ");
INSERT INTO dikNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ku cɔ̈ɔ̈lkë atuuc Jethu ɣöt, ku tëmkë ke awuɔ̈c bï ke that, ku thönkë kenhïïm bïk cïï ben jam rin Jethu. Ku jɔlkë ke lony. ");
INSERT INTO dikNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Tɛ̈ɛ̈n atuuc Jethu aacï jal jäl luk yic ke cï puɔ̈th la yum wɛ̈t cï Nhialic ke cɔl agum, rin cï ke that wɛ̈t Jethu. ");
INSERT INTO dikNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ku yekë kɔc piɔ̈ɔ̈c wɛ̈t Puɔth Yam Jethu Krïtho akölaköl luaŋ Nhialic kɔc Itharel, ku bääiken yiic aya. ");
INSERT INTO dikNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Tɛ̈wën cï akuën kɔc biöth rot juak, akɛ̈ɛ̈k ëcï rot looi kamken, kɔc Itharel kek ke ciëŋ Jeruthalem, ku kɔc Itharel jam thoŋ Gïrïk. Kɔc Itharel jam thoŋ Gïrïk ë yekë lueel lɔn nadë ke lɛ̈ɛ̈rken aake cie kuɛ̈ɛ̈c nhïïm, rin cïï ke ye muɔɔc tɛ̈ tek wëëu ye tɛ̈k lëër akölaköl. ");
INSERT INTO dikNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Go atuuc Jethu kathiäär ku rou kɔc cï gam ëbën cɔɔl ku lëkkë ke ëlä, “Yeen acie yic tënë ɣo buk luɔi piööc wɛ̈t Nhialic puɔ̈l ku ye wëëu kek yeku tek. ");
INSERT INTO dikNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ke yen, wek wämäthkua, kuanykë kɔc kadhorou weyiic, kɔc path la gup riɛl Wëi Nhialic ŋic käŋ. Ku keek abuk cɔl aaye wëëu muk, ku yekë ke tek. ");
INSERT INTO dikNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ku ɣok aabï ɣonhïïm yiëk röök ku jɔl a piööc wɛ̈t Nhialic.” ");
INSERT INTO dikNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Kɔc ke cï gam aake cï puɔ̈th miɛt wɛ̈t cï atuuc Jethu lɛ̈k ke, ku kuanykë kɔc. Kɔc ke cïk kuany aake yï Ithipin, raan la gam la guɔ̈p Wëi Nhialic, ku jɔl aa Pilipo, ku Prokoruth, ku Nikanora, ku Timon, ku Parmena, ku Nikola, ku yeen ëcie raan Itharel, ee ye raan pan cɔl Antiök cï yanhde puɔ̈l ku gɛm yanh kɔc Itharel. ");
INSERT INTO dikNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ku jɔl kɔc cï kuany ɣäth tënë atuuc Jethu, gökë röök riɛnken ku tɛ̈ɛ̈ukë kecin kenhïïm bïk ke dɔɔc. ");
INSERT INTO dikNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ku piööc wɛ̈t Nhialic ëcï la tueŋ ke juak rot. Akuën kɔc biöth Jeruthalem ë yic juak akölaköl, ku akuëndït apɛi kɔc käk Nhialic acï bɛ̈n gam. ");
INSERT INTO dikNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ithipin ëcï Nhialic dɔɔc bï cɔl aril apɛi, go käkdït jäŋ gɔ̈i apɛidït looi kam kɔc. ");
INSERT INTO dikNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ku kɔc abɛ̈k akut amat tɛ̈n kɔc Itharel aake cie wɛ̈tde ye gam, ku keek aake ŋic lɔn ye ke cɔl kɔc lääu nhïïm, wɛ̈t ye kek kɔc aa loony cï puɔ̈l. Ku yen akut kënë, ee la yic kɔc wun cɔl Thirene ku Alekdhändria ku Cilicia ku Athia, ee cïk jɔɔk bïk aa teer kek Ithipin. ");
INSERT INTO dikNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ku yen Ithipin ëcï Wëi Nhialic yiëk riɛl ŋic yen ke wël apɛi, na lueel wɛ̈t, ka cïn raan lëu ye bï wɛ̈tde dhɔ̈l yic. ");
INSERT INTO dikNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Gokë kɔc kɔ̈k riɔp, ku bïk aa lɛ̈k kɔc Itharel ëlä, “Ɣok aacï Ithipin piŋ ke jiëëm Mothith ku Nhialic gup!” ");
INSERT INTO dikNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Tɛ̈wën cï kɔc cï riɔp aa jam këya, tɛ̈ɛ̈n ke keek aacï kɔc Itharel, ku kɔcken dït, ku jɔl aa kɔc piööc lööŋ rac nhïïm. Ku dɔm kɔc Itharel Ithipin ku ɣɛ̈thkë luk yic. ");
INSERT INTO dikNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ku bïïkë kɔc kɔ̈k bïk Ithipin bɛ̈n cäk thok ku luelkë ëlä, “Mony kënë, cɔl Ithipin ë luaŋdan Itharel ku lööŋkuan Mothith dhɔ̈l yiic. ");
INSERT INTO dikNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Acuk piŋ ke ye lueel lɔn nadë ke Jethu raan pan Nadharet abï luaŋdan Itharel thuɔ̈r piny, ku wɛɛr ciɛɛŋdan thɛɛr Mothith yic.” ");
INSERT INTO dikNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Go kɔc ke cï nyuc luk yic ëbën Ithipin jäl döt apɛi, ku tïŋkë ke cït nyin atuny Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ku jɔl raandït käk Nhialic Ithipin thiëëc ëlä, “Yekë yith kek käk cï kɔckä yï gaany?” ");
INSERT INTO dikNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Go Ithipin dhuk ku lueel, “Wek wärkiɛ̈ ku wämäthkiɛ̈, piɛŋkë wɛ̈tdiɛ̈! Nhialic Madhɔl yen ye leec raan ëbën, ëcï rot nyuɔ̈th wädan dït Abaram ɣɔn ŋot ciëŋ yen pan Methopotamia, wäär këc yen guɔ kök bï la ceŋ pan Ɣäran. ");
INSERT INTO dikNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ku yen Abaram ëcï Nhialic yɔ̈ɔ̈k ëlä, ‘Nyääŋ paandu ku kacku piny ku lɔɔr piny ba nyooth tënë yï.’ ");
INSERT INTO dikNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Go Abaram wuɔ̈nden nyääŋ piny ku ler bï la ceŋ gen Ɣäran. Na wäär cï wun Abaram thou, go Nhialic Abaram yɔ̈ɔ̈k bï bɛ̈n ceŋ ë wun yen ciëŋ wek thïn ëmën. ");
INSERT INTO dikNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Acïn abaŋ piny cïï Nhialic yiëk Abaram, ku ëcï thɔn lɔn bï yen Abaram gäm ë piny kënë bï ya piɛnyde kek mïthken bï lɔ̈k dhiëëth aköldä. Tɛ̈wäär yen lëk Nhialic Abaram ë wɛ̈t kënë, ke Abaram ë cïn mïth cï dhiëëth. ");
INSERT INTO dikNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nhialic ë cä Abaram yɔ̈ɔ̈k ëlä, ‘Miɛ̈thku aabï ceŋ wun thäi kɔ̈k run buɔt kaŋuan. Ku keek aabï ya aloony kɔc ë wun bï kek ceŋ thïn, ku aabï ya jöör apɛidït. ");
INSERT INTO dikNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ku ɣɛn abï kɔc kek bïk aa luɔ̈ɔ̈i mac, ku na la run juëc thök, ke keek aabï jäl ye wun kënë. Ku aabï bɛ̈n bïk ɣɛn bɛ̈n door ë tɛ̈n.’ ");
INSERT INTO dikNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ku ë tɛ̈ɛ̈n acï Nhialic lëk Abaram bï miɛ̈thke aa ŋoot, ku yen ë kïn ye nyuɔɔth lɔn cï kek dɔ̈ɔ̈r. Ku Abaram acï wënden Ithäk bɛ̈n ŋoot nïn kadhorou cök ciëën wäär dhiëëth ye. Ku ŋot Ithäk Jakop, ku ŋot Jakop wätke kathiäär ku rou. Aa kek wärken dït kuat Itharel ëmën.” ");
INSERT INTO dikNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Wɛ̈ɛ̈t Jakop aake man mɛ̈nhden cɔl Jothep. Gokë ɣaac ku bï a lony pan Ijip. Ku Nhialic ë nhiar Jothep. ");
INSERT INTO dikNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Go Jothep kony bï puut bei kärɛc yiic. Na la Jothep ɣäth bɛ̈nyŋaknhom Ijip nhom, ke yïk Nhialic riɛl bï käŋ ŋic ku ye raan path. Go bɛ̈nyŋaknhom ruɔ̈k bï ya yen bɛ̈ny pan Ijip. Ku looi aya bï a yen tɔ̈ tueŋ käk paande yiic. ");
INSERT INTO dikNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ku cɔk ëcï tuɔ̈l pan Ijip ëbën ku jɔl a Kanaan. Ku yen cɔŋ kënë ëcï kɔc baŋ apɛi. Ee ril yic ku bï wärkuan dït miëth yök. ");
INSERT INTO dikNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Nawën le Jakop piŋ lɔn tɔ̈ rap Ijip, go wätke kek wärkuan dït ëmën tooc ku bïk la. ");
INSERT INTO dikNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Na ben wärkuan dït bɛn dhuk cäth yic rou, go Jothep rot tɛ̈t ke lɔn ë yen mɛ̈nhden ku jɔl bɛ̈nyŋaknhom Ijip manyde ŋic aya. ");
INSERT INTO dikNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ku tuc thok wun Jakop, ku bï lɛ̈k wun kek manyden ëbën kathiärdhorou ku dhiëc bïk bɛ̈n Ijip. ");
INSERT INTO dikNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Go Jakop jäl la, ku ë yen tɛ̈ cï Jakop ku wärkuan dït bɛ̈n la thou thïn. ");
INSERT INTO dikNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Gup wärkuan dït aake cï bɛ̈n la thiɔ̈k tɛ̈ cɔl Cikem, ku tɛ̈ cï ke thiɔ̈k thïn, ee ye piny ɣɔɔc Abaram wëëu tënë thäi cɔl Ɣämor. ");
INSERT INTO dikNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Na la nïn thiɔ̈k, nïn kek ke cï Nhialic ke Abaram yɔ̈ɔ̈k lɔn nadë ka la këpuɔɔth bï luɔ̈i ye, ke akuën kɔckuan ke tɔ̈ Ijip ëcï ye yic juak apɛi. ");
INSERT INTO dikNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ku ëcï rot looi bï bɛ̈ny dɛ̈t kuc Jothep pan Ijip mac. ");
INSERT INTO dikNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ku yen bɛ̈ny kënë ë ye wärkuan dït wëëŋ ku kuc ke ciëëŋ. Ku ye ke cɔl acuɛt miɛ̈thken roor ku bï mïth thou. ");
INSERT INTO dikNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ku tɛ̈ɛ̈n ë yen ë dhiëëth Mothith, ku yen ë ye manh adhɛ̈ŋ tënë Nhialic, ku muk baai pɛ̈i kadiäk. ");
INSERT INTO dikNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ku nawën la cuat wïïr, go nyɛn bɛ̈nyŋaknhom la kuany ku muk ku looi ye manhde. ");
INSERT INTO dikNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Mothith acï piɔ̈ɔ̈c tɛ̈cït tɛ̈ ŋic kɔc Ijip käŋ thïn, agut abï ya raandït tet ku ye raan ŋic käŋ apɛidït jam yith, ku jɔl a luɔi aya. ");
INSERT INTO dikNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Na la run Mothith ɣet thiärŋuan, go yenhom tak ku bï wämäthakën Itharel la tïŋ tɛ̈ ciëŋ kek thïn. ");
INSERT INTO dikNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Tɛ̈wën cï yen wämäthakën la tïŋ, go raan tök keyiic yök ke nɛ̈k raan Ijip, go mɛ̈nhden näk kony, ku guur raande agut tɛ̈ nɛ̈k yen raan awën thär kek raande. ");
INSERT INTO dikNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","(Ee cï Mothith tak lɔn nadë ka bï kacke deet yic, lɔn bï Nhialic ye looi bï ke wɛ̈ɛ̈r bei loony yic. Ku akëckë deet.) ");
INSERT INTO dikNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Naɣɔn nhiäk ke yök kɔc Itharel karou ke thär, go la ku dɔk ke. Ku jɔl ke yɔ̈ɔ̈k ëlä, ‘Piɛŋkë këdiɛ̈ wek röörkä. Wek aa kɔc ruääi. Yeŋö kuc wek ceŋ kamkun?’ ");
INSERT INTO dikNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Go raan töŋ wën cï raan tiaam Mothith piɛ̈k wei, ku thiëëc ëlä, ‘Yeŋa cï looi ba ya bänyda. Ku ye bɛ̈ny dɛ̈t lëu ba luɔ̈ŋda luk? ");
INSERT INTO dikNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Wïc ba ɣa nɔ̈k cïmën wäraköl nɛ̈k yïn ke raan Ijip?’ ");
INSERT INTO dikNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Tɛ̈wën piŋ Mothith ë wɛ̈t kënë, go kat ku le ceŋ Midian. Ku acï bɛ̈n la dhiëth dhäk karou ë tɛ̈ɛ̈n. ");
INSERT INTO dikNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Wën cï Mothith ceŋ ruɔ̈ɔ̈n thiärŋuan Midian, go atuny Nhialic rot nyuɔ̈th ye. Ku atuny nhial ëcï Mothith tïŋ kecït bun dɛ̈p roor liɛɛt tɛ̈thiääk kek gɔn Thinai. ");
INSERT INTO dikNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Go Mothith gäi kë cï tïŋ, ku cot rot but lɔ̈ɔ̈m ku bï tïŋ apath. Go röl Nhialic piŋ ke ye lueel, ");
INSERT INTO dikNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ee ɣɛn Nhialic ye wärkuɔ̈n dït door. Nhialic Abaram, ku Ithäk, ku Jakop.’ Go Mothith riɔ̈ɔ̈c arɛ̈k bï lath ku cïï këwën ben döt. ");
INSERT INTO dikNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Go Nhialic Mothith yɔ̈ɔ̈k, ‘Dɛ̈k war bei, rin tɛ̈ kɛ̈ɛ̈c yïn thïn, ee tɛ̈ thek. ");
INSERT INTO dikNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ɣɛn acï tɛ̈rɛɛc guum kackiɛ̈ thïn pan Ijip tïŋ. Ɣɛn acï dhiënden piŋ. Ku ɣɛn acï bɛ̈n ku ba ke bɛ̈n kony. Bäär ëmën, ba yï tuɔɔc Ijip.’ ” ");
INSERT INTO dikNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Ithipin acï la tueŋ ke jam luk yic ëlä, “Mothith ëcï kɔc Itharel kuec bïk wɛ̈tde cïï piŋ. Ee cïk thiëëc ëlä, ‘Yeŋa looi yï ba ya bänyda ku ye luɔ̈kkua luk?’ Yen Mothith ë yen cï Nhialic tooc ku bï ya bɛ̈ny, ku ye raan kony Itharel. Ku yen abï atuny Nhialic cï rot nyuɔ̈th ye bun dɛ̈p yic, kony luɔide yic. ");
INSERT INTO dikNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Yen Mothith acï kɔc Itharel wɛ̈t nhïïm bei Ijip ke loi käk jäŋ gɔ̈i pan Ijip, ku wäär teem wär aruɔ̈ɔ̈r, ku jɔl a wäär rëër kek ror liɛɛt run kathiärŋuan. ");
INSERT INTO dikNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mothith ëcï kɔc Itharel yɔ̈ɔ̈k, ‘Nhialic abï we tuɔ̈c raan bï we bɛ̈n piɔ̈ɔ̈c wɛ̈tde, raan käk Nhialic tïŋ cïmën cï yen ɣa tuɔ̈c we. Ku yen raan bï tuɔ̈c we abï ya raan kuatdun.’ ");
INSERT INTO dikNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mothith ë yen rɛ̈ɛ̈r kek kɔc Itharel ke ciëŋ ror liɛɛt. Ee rɛ̈ɛ̈r kek wärkuan dït. Ku jɔl a atuny nhial yen cï jam tënë ye gɔn Thinai nhom. Ee yen ye Nhialic yɔ̈ɔ̈k ku bï wɛ̈tden pïr akölriëëc ëbën bɛ̈n lɛ̈k kɔc. ");
INSERT INTO dikNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Ku wärkuan dït aake cï kuec ku bïk wɛ̈t Mothith cïï piŋ, keek aakëc luui wɛ̈tde. Ku wïckë bïk dhuk Ijip. ");
INSERT INTO dikNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Gokë Aron yɔ̈ɔ̈k, ‘Thäth ɣo jak bï ke aa ket tueŋ kɔc wat ɣonhïïm tɛ̈ ciɛth ɣok. Akucku yen kë cï rot looi tënë Mothith yen wäär wët ɣo bei Ijip.’ ");
INSERT INTO dikNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Keek aacï mïläŋ thɔ̈ɔ̈th ke ye jɔŋ cït manh weŋ, ku loikë yai bï kek yanhden cïk looi aa door. Ku yekë jal näk. ");
INSERT INTO dikNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Tɛ̈ɛ̈n Nhialic acï yekɔ̈u bɛ̈n wɛ̈l ke. Ku pɛ̈l ke bïk aa kuɛl tɔ̈ nhial kek yekë door, cïmën cï ye gɔ̈t athör kɔc käk Nhialic tïŋ yic ëlä, ‘Wek kɔc Itharel! Ee cie ɣɛn, ɣɛn yakë näk ɣɔ̈k. Ɣɔn tɔ̈ wek ror liɛɛt run kathiärŋuan. ");
INSERT INTO dikNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ee ye duël jɔŋdun cɔl Molok yakë ket. Ku jɔl atïm ciëër, jɔŋdun cɔl Repan cäk guaŋ. Aa kek ke jakkun cäk ke looi, bäk keek aa door. Ke wek aaba tuɔɔc wei, bäk ɣet Babilon kɔ̈u ciëën.’ ");
INSERT INTO dikNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Wärkuan dït aake la Duël yen ye nyuɔɔth lɔn nadë ke Nhialic arɛ̈ɛ̈r ke ke ror liɛɛt. Duël acï yïk tɛ̈cït tɛ̈ cï Nhialic ye lɛ̈k Mothith thïn, cï looi tɛ̈cït tɛ̈ cï ye nyuɔ̈th Mothith thïn. ");
INSERT INTO dikNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ku yen duël kënë ëcï wärkuan dït aa thɔ̈n miɛ̈thken wäthɛɛr, agut tɛ̈ bïï Jocua ye ë piny cuk bɛ̈n rum tënë kɔc ke la ye. Wäär ye Nhialic ke cuɔp wei tɛ̈ bïï ɣok. Ku jɔl duël rëër agut wäär ye Debit bɛ̈nyŋaknhom. ");
INSERT INTO dikNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Debit ë nhiɛɛr Nhialic. Ku ëcï Nhialic thiëëc ku bï puɔ̈l bï luak yïk, luaŋ bï Nhialic Wundït Jakop ceŋ thïn. ");
INSERT INTO dikNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ku ë Tholomon yen acï luak bɛ̈n buth. ");
INSERT INTO dikNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Ku yen Nhialic Madhɔl acie ceŋ ɣööt yiic ɣööt ke yïk. Cïmën ye kɔc käk Nhialic tïŋ ye luel ëlä, ");
INSERT INTO dikNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Acï Nhialic luel, ke nhial yen tɔ̈ thɔ̈nydiɛ̈ thïn, ku piny yen aye ɣɛn ɣacök tääu thïn. Ye ɣön yïndë yen bäk yïk tënë ɣɛn? Ye tɛ̈nɛn yen lëu bï ɣɛn lɔ̈ŋ thïn! ");
INSERT INTO dikNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Cie ɣɛn ɣa looi käkkä ëbën!’ ");
INSERT INTO dikNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Tɛ̈ril wek nhïïm thïn! Wek aacï kuec bäk wɛ̈t Nhialic cïï piŋ, rin thöŋ wek puɔ̈th kek kɔc këc Nhialic gam cïmën wärkun dït thɛɛr. Wek aacï kuec bäk wɛ̈t cï Wëi Nhialic lɛ̈k we cïï gam. ");
INSERT INTO dikNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","“Le raan käk Nhialic tïŋ cï wärkuɔ̈n dït puɔ̈l ke këckë nɔ̈k? Wärkuɔ̈n dït aacï kɔc cï Nhialic tooc nɔ̈k, kɔc ke cie ya lueel lɔn raan bï kë wïc Nhialic bï looi, abï bɛ̈n. Ku ëmën yen acäk gaany ku acäk cɔl anäk. ");
INSERT INTO dikNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Aa wek cï lööŋ Nhialic thɔn, lööŋ kek ke cï atuny nhial thɔ̈n wärkuɔ̈n dït. Ku keek aa kɛ̈ckë ke gam!” ");
INSERT INTO dikNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Tɛ̈wën piŋ bäny luk wël Ithipin, gokë puɔ̈th riääk apɛidït ku kackë kethook tënë ye. ");
INSERT INTO dikNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ku yen Ithipin ëcï Wëi Nhialic thɔ̈ŋ guɔ̈p, go yenyin wɛl nhial ku dɛɛi, ku tïŋ riɛl dïït Nhialic, ku tïŋ Jethu aya ke kääc Nhialic lɔ̈ɔ̈m köŋ cuëc. ");
INSERT INTO dikNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Go Ithipin bäny luk yɔ̈ɔ̈k jalkë tïŋ, “Ɣɛn acï nhial tïŋ ke liep yethok, ku ɣɛn acï Manh Raan tïŋ ke kääc Nhialic lɔ̈ɔ̈m köŋ cuëc.” ");
INSERT INTO dikNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Go bäny luk keyïth kum ku reelkë apɛi. Ku riŋkë Ithipin guɔ̈p, ");
INSERT INTO dikNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ku ɣɛ̈thkë aɣeer geeu ku lek biɔ̈ɔ̈k aleel agut tɛ̈ thou yen. Kɔc kek ke näk ye aake cä alɛ̈thken nyäŋ riënythii cɔl Thawul ku bï ke lɔ̈k tiit. ");
INSERT INTO dikNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Keek aacï Ithipin jäl biɔ̈ɔ̈k aleel, ku Ithipin ë ye Nhialic cɔɔl, “Bänydiɛ̈ Jethu, lor wɛ̈ikiɛ̈!” ");
INSERT INTO dikNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ithipin ëcï yenhiɔl guɔ̈t piny ku lueel ke cie röl jɔt apɛidït, “Nhialic! Duk ke gäk kërɛɛc cïk luɔ̈i ɣa!” Wɛ̈t kënë acï lueel, ku thou nyin yic. Nääk cï Ithipin nɔ̈k ëcï raan cɔl Thawul gam. Ku mony cɔl Thawul ë tɔ̈ thïn. Ku yeen ëcï lɔn nɛ̈k Ithipin gam. ");
INSERT INTO dikNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Aköl nɛ̈k Ithipin, yen aköl jɔɔk yen rot bï kɔc ke cï wɛ̈t Jethu gam Jeruthalem gum apɛidït. Kɔc ke cï wɛ̈t Jethu gam aake cï kat bïk röt thiäi wuɔ̈t kɔ̈k yiic, wuɔ̈t Judia ku Thamaria, ku atuuc Jethu kek aake cï döŋ Jeruthalem kepɛ̈c. ");
INSERT INTO dikNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Kɔc ke cï wɛ̈t Nhialic gam piänden ëbën, aa kek cï Ithipin bɛ̈n la thiɔ̈k, ku jɔlkë dhiau apɛi riɛnke. ");
INSERT INTO dikNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ku ëcï Thawul them bï kɔc cï wɛ̈t Jethu gam cɔl agum, rin yeen ë ye la panë ku panë, ke kuany bɛ̈ɛ̈i yiic ëbën, ku ë ye kɔc cï wɛ̈t Jethu gam ɣɔ̈c bei ɣööt yiic, röör ku diäär, ku kuɛɛth ke bï ke la mac. ");
INSERT INTO dikNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Kɔc ke cï wɛ̈t Jethu gam, cï thiëi wuɔ̈t kɔ̈k yiic aake cï la cath wuɔ̈t yiic ëbën, ku piööckë kɔc wɛ̈t Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pilipo ëcï cath bï la gen Thamaria ku le kɔc piɔ̈ɔ̈c thïn wɛ̈t Jethu Krïtho. ");
INSERT INTO dikNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Kɔc ke cï kenhïïm aa kuɔ̈ɔ̈t, aake cï kepuɔ̈th aa tääu piny ku bïk kë lueel Pilipo aa piŋ apath. Keek aacï wɛ̈t Pilipo aa piŋ ku tïŋkë käk jäŋ gɔ̈i cï aa looi. ");
INSERT INTO dikNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Kɔc juëc aacï jakrɛc aa bɛ̈n bei kegup ke dhiau apɛi, ku kɔc cï ruai, ku kɔc kɔ̈k cï ŋɔl aacï Pilipo cɔl aa puɔl. ");
INSERT INTO dikNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Këya, kɔc Thamaria aacï puɔ̈th bɛ̈n miɛt apɛidït. ");
INSERT INTO dikNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","10","Ku mony cɔl Thaimon ë ciëŋ gen Thamaria, ku yeen ëcï kɔc cɔl agɛ̈i käkken ye looi. Yeen ëcï rot looi ke ye raandït apɛi, ku kuat kɔc ke ciëŋ geeu ëbën aake cï kepuɔ̈th tääu piny ku piŋkë wɛ̈tde. Ku ë cïk aa lueel ëlä, “Jɔŋ cɔl Riɛldït yen acï bɛ̈n piny cïmën Thaimon.” ");
INSERT INTO dikNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ku ë yic, Thaimon ëcï kɔc Thamaria cɔl agɛ̈i tɛ̈wäär yen käkken kë looi jɔŋ tɔ̈ yeguɔ̈p, ku kɔc aake ye wɛ̈tde buɔɔth yic ku detkë yic. ");
INSERT INTO dikNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Nawën la kɔc Thamaria wɛ̈t Pilipo gam, wɛ̈t piööc yen kɔc Wɛ̈t Puɔth Yam rin bääny Nhialic, ku rin Jethu Krïtho, go röör ku diäär gam bïk röt cɔl aa muɔc nhïïm. ");
INSERT INTO dikNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Yen Thaimon aya ëcï wɛ̈t Nhialic gam, ku cɔl rot amuɔc nhom, ku jɔlkë rëër tök kek Pilipo, ku yeen ëcï bɛ̈n gäi tɛ̈wën tïŋ yen käkdït jäŋ gɔ̈i ye Pilipo looi. ");
INSERT INTO dikNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Go atuuc Jethu ke tɔ̈ Jeruthalem piŋ lɔn nadë ke kɔc Thamaria aake cï wɛ̈t Nhialic ɣet tënë ke. Gokë Pïtɛr ku Joon tooc bïk la tënë ke. ");
INSERT INTO dikNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Nawën cï Pïtɛr ku Joon ɣet Thamaria, gokë röök ku bï Wëi Nhialic lööny kɔc Thamaria gup. ");
INSERT INTO dikNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Kɔc Thamaria aake cï muɔɔc nhïïm rin Jethu Krïtho ku Wëi Nhialic ë ŋuɔt këc lööny kegup. ");
INSERT INTO dikNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Go Pïtɛr ku Joon kecin tääu kenhïïm go Wëi Nhialic lööny kegup. ");
INSERT INTO dikNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Tɛ̈wën cï Thaimon ye tïŋ ke Wëi Nhialic cï lööny kegup, wën cï Pïtɛr ku Joon, atuuc Jethu, keek dɔɔc, go wïc bï Pïtɛr ku Joon gäm wëëu, ");
INSERT INTO dikNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ku jɔl ke yɔ̈ɔ̈k, “Yiëkkë ɣa riɛl kënë aya, rin na le raan daac, ke Wëi Nhialic lööny yeguɔ̈p.” ");
INSERT INTO dikNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Go Pïtɛr wɛ̈t Thaimon dhuk nhom ku lueel, “Aŋuɛ̈ɛ̈n diɛ̈t yï ku wɛ̈ɛ̈uku cuɛt pan mac ëbën, rin ë yïn ye tak diɛ̈t yï ɣɔc miɔ̈c Nhialic wëëu. ");
INSERT INTO dikNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Yïn acie raan akuɔ̈tda ku acïn kën yï mat ke ɣo, rin piändu acïï la cök tënë Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Dhuɔ̈k yïpuɔ̈u ciëën, ku päl luɔi kärɛc, ku rɔ̈ɔ̈k Nhialic ku bï kärɛc ye tak cïmën ë kënë päl piny. ");
INSERT INTO dikNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Yen aye tïŋ yïguɔ̈p lɔn til yïn ɣo apɛidït, ku yïïn acï kärɛc ye ke looi muɔ̈r.” ");
INSERT INTO dikNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Go Thaimon Pïtɛr ku Joon yɔ̈ɔ̈k. “Rɔ̈ɔ̈kkë tënë Nhialic riɛnkiɛ̈, ku bï ciɛ̈n kërɛɛc loi rot tënë ɣa käk cä lueel yiic.” ");
INSERT INTO dikNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Tɛ̈wën cï Pïtɛr ku Joon kɔc Thamaria lɛ̈k lɔn ye wɛ̈t Nhialic ye lɛ̈k ke yic, gokë dhuk Jeruthalem. Ku tɛ̈wën dhuk kek, aake ye kɔc piɔ̈ɔ̈c Wɛ̈t Puɔth Yam Nhialic ë bɛ̈ɛ̈i juëc cïk tëëk yiic pan Thamaria. ");
INSERT INTO dikNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Atuny Nhialic ëcï Pilipo lɛ̈k ëlä, “Guir rot ku kuɛny dhöl yic, dhöl jiël Jeruthalem bï la Gadha.” (Dhöl kën acie bɛn tëëk ëmën.) ");
INSERT INTO dikNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Go Pilipo rot guiir ku lööny dhöl. Ku tɛ̈ɛ̈n, ke yök raan Ithiöpia, raan cï la Jeruthalem bï Nhialic la door. Ku yen mony kënë ëcï roc. Ku ë ye bɛ̈ny wëëu muk wëëu tiŋ cɔl Kandake, tiŋ ye bɛ̈ny Ithiöpia, ");
INSERT INTO dikNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ku yen ë dhuk Ithiöpia riän thel mathiäŋ. Tɛ̈wën ciɛth yen dhöl yic, ee kuen athör Ithaya raan käk Nhialic tïŋ. ");
INSERT INTO dikNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ku ëcï Wëi Nhialic lɛ̈k Pilipo, “Lɔɔr ku cath keyï thiäk rot riän thel mathiäŋ.” ");
INSERT INTO dikNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Go Pilipo jäl riŋ tɛ̈thiääk kek ye ku piŋ ke kuën athör Ithaya yic. Go jal thiëëc, “Ye deet yic yen kë kuen?” ");
INSERT INTO dikNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Go bɛ̈ny tɔ̈ɔ̈u wëëu dhuk nhom, “Ba jal deet yic këdë, ke cïn raan cie tɛ̈t yic ɣa?” Ku yöök Pilipo bï la nhial riäi yic, bï cath kek ye. ");
INSERT INTO dikNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Kënë yen kueen athör thɛɛr wël Nhialic yic akïn, “Yen ee cït amäl thel ku bï la teem röl, acït manh amääl cie dhiau tɛ̈ teem nhiëmde wei, ee cïn wɛ̈t ye lueel. ");
INSERT INTO dikNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Yeen ee cï rac guɔ̈p, ku kɔc aake cïï kuec bïk yiɛnyde cïï gam. Acïn raan mïthken bï döŋ bï lɔ̈k lueel, bï kärɛc riëëc akölë lɔ̈k a lueel, rin cïï piɛ̈rde pinynhom guɔ cɔl athök.” ");
INSERT INTO dikNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ku jɔl bɛ̈ny tɔ̈ɔ̈u wëëu Pilipo yɔ̈ɔ̈k, “Lɛ̈k ɣa, Ithaya jiɛɛm rin ŋa, jiɛɛm riɛnke aye rin raandä?” ");
INSERT INTO dikNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Go Pilipo jal jam, ku jɔɔk jamde këthiɔ̈ɔ̈k awën cï bɛ̈ny tɔ̈ɔ̈u wëëu kueen athör thɛɛr wël Nhialic yic. Ku jɔl lɛ̈k Wël Puɔth Yam rin Jethu. ");
INSERT INTO dikNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Tɛ̈wën ciɛth kek dhöl yic, ke ɣet tɛ̈ tɔ̈u pïu thïn, go bɛ̈ny tɔ̈ɔ̈u wëëu Pilipo jal thiëëc, “Pïu akïk, yeŋö bä pëën ke ɣa cï muɔc nhom?” ");
INSERT INTO dikNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","38","Bɛ̈ny tɔ̈ɔ̈u wëëu pan Ithiöpia acï raan kuath riäi yɔ̈ɔ̈k bï riäi cɔl akääc, ku jɔl Pilipo ku bɛ̈ny wëëu la piny ku lek pïu yiic, ku muɔc Pilipo bɛ̈ny wëëu Ithiöpia nhom. ");
INSERT INTO dikNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Nawën cïk jäl bɛ̈n bei pïu yiic, go Wëi Nhialic Pilipo diër piny. Ku bɛ̈ny tɔ̈ɔ̈u wëëu akëc Pilipo bɛn tïŋ, go lööny dhöl ke dhuk panden, ku yeen ë mit puɔ̈u apɛi. ");
INSERT INTO dikNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pilipo acï rot yök ke cï ɣet gen cɔl Adhotuth, ku ler ku piööc kɔc Wël Puɔth Nhialic gɛɛth yiic ëbën, gut tɛ̈ ɣet yen gen cɔl Cetharia. ");
INSERT INTO dikNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","2","Thawul acï la tueŋ ke riɛ̈ɛ̈c ye yen kɔc buɔth Bɛ̈ny riääc lɔn nɛ̈k yen ke. Ee cï la tënë raandït käk Nhialic, ku bï ye la yiëk athöör tënë bäny akut yanh Itharel rɛ̈ɛ̈r gen Damathkuth, ku aye athörkä lɛ̈k kɔc Itharel tɔ̈ Damathkuth, lɔn na la Thawul kɔc cï wɛ̈t Jethu gam yök, diäär ku röör, ke bï dɔm, ku kuɛɛth ke Jeruthalem. ");
INSERT INTO dikNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Tɛ̈wën ciɛth Thawul dhöl yic ke la Damathkuth, ku wën cï yen jal thiɔ̈k kek gɛu, ke kam thiin wën ke tïŋ mac la biliny nhial, ku ɣer piny ëbën yelɔ̈ɔ̈m. ");
INSERT INTO dikNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ku wïïk piny ku piŋ raan röl ke jam ku lëk ye, “Thawul, Thawul! Ye rin ŋö cɔl yïn ɣa agum?” ");
INSERT INTO dikNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Go Thawul thiëc ëlä, “Ee yïn ŋa Bɛ̈ny?” Go röl wën cï piŋ dhuɔ̈k ye, “Ee ɣɛn Jethu, ɣɛn raan jör. ");
INSERT INTO dikNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ku yïïn jɔt rot ëmën ku lɔɔr geeu, ku yïn abï lɛ̈k kë ba dhiɛl looi.” ");
INSERT INTO dikNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Röör ke cath kek Thawul aake cï kɔ̈ɔ̈c, ke bit, ku keek ë cïn raan cïk tïŋ, ku aake cï röl raan jam piŋ. ");
INSERT INTO dikNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Go Thawul rot jɔt, nawën liep yenyin, ke cie piny ye tïŋ. Go kɔc ke cath kek ye dɔm cin ku thelkë, ke la Damathkuth. ");
INSERT INTO dikNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ku jɔl rëër nïn kadiäk ke cie daai, ku yeen ë nïnkä yiic kadiäk ëcie dek pïu ku ëcie mïth. ");
INSERT INTO dikNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Raan cɔl Ananiath cï wɛ̈t Nhialic gam ë rɛ̈ɛ̈r Damathkuth. Ku ë la kën cï rot nyuɔ̈th ye, ku ë ye tɛ̈n cï Nhialic ye cɔɔl thïn, “Ananiath.” Go Ananiath gam ku bëër, “Ɣɛn akïn Bɛ̈ny.” ");
INSERT INTO dikNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","12","Go Bɛ̈ny lɛ̈k ye, “Jɔt rot, ba la dhöl cɔl, ‘Dhöl la cök,’ ku na ɣɛɛt pan raan cɔl Judath ke yï thiëc raan cɔl Thawul, raan wun Tarthuth. Yen Thawul arɔ̈ɔ̈k, ku yeen ala kë cï rot nyuɔ̈th ye lɔn cï yen ke raan käk Nhialic cɔl Ananiath tïŋ ke bɔ̈ ɣöt, bï ye bɛ̈n dɔɔc, rin bï yen ke piny bɛn tïŋ.” ");
INSERT INTO dikNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Go Ananiath bɛ̈ɛ̈r, “Bɛ̈ny, kɔc juëc aacä lɛ̈k kärɛc apɛi ye raan kënë luɔ̈i kɔc cï wɛ̈tdu gam tɔ̈ Jeruthalem. ");
INSERT INTO dikNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ku yeen acï bɛ̈n Damathkuth tɛ̈në, ke cï raandït käk Nhialic yiëk riɛl, ku bï kɔc yï door bɛ̈n dɔm.” ");
INSERT INTO dikNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Go Nhialic lɛ̈k Ananiath, “Lɔɔr yen aca lɔc, ku bï ya aluaŋdiɛ̈. Yen abï ɣa cɔl aŋic kɔc cie kɔc Itharel, ku jɔl aa bänydït pinynhom ëbën, ku jɔl aa kɔc Itharel. ");
INSERT INTO dikNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ku aba nyuɔ̈th ye, yen ɣɛn, yen tɛ̈ bï yen guum thïn wɛ̈tdiɛ̈.” ");
INSERT INTO dikNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Go Ananiath lööny dhöl ku ler ɣön wën rëër Thawul thïn, ku jɔl dɔɔc. Ku yöök Ananiath ëlä, “Yïn wämääth Thawul, Jethu yen Wën Nhialic nhom, yen cï rot nyuɔ̈th yï dhöl yic wäär bïï yïn acä tooc. Acä tooc, ku ba yï bɛ̈n dɔɔc ku ba bɛn daai, ku bï Wëi Nhialic lööny yïguɔ̈p.” ");
INSERT INTO dikNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Kaam wën, ke kacït kuɛc rɛ̈c lööny piny Thawul nyin ku ben piny tïŋ. Ku jɔt rot bï kɔ̈ɔ̈c ku cɔl rot amuɔc nhom, ");
INSERT INTO dikNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","nawën cï jäl mïth, ke ben riɛl yök. Thawul acï jäl rëër nïn lik Damathkuth kek kɔc cï gam. ");
INSERT INTO dikNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Nawën ke la tɛ̈n amat kɔc Itharel ku jiɛɛm rin Jethu. Ee cï kɔc aa lɛ̈k ëlä, “Jethu ë ye Wën Nhialic.” ");
INSERT INTO dikNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Kɔc ke cï wɛ̈t lueel Thawul piŋ aacï bɛ̈n gäi, ku yekë röt thiëëc kamken, “Cie yen mony kënë wäär tɔ̈ Jeruthalem, yen kɔc cï wɛ̈t Jethu gam nɔ̈k? Ku cie yen bïï yen tɛ̈në ëmën, bï kɔc cï wɛ̈t Jethu gam bɛ̈n dɔm ku kuɛɛth ke tënë raandït käk Nhialic?” ");
INSERT INTO dikNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ku yen Thawul ëcï riɛl piööc yic apɛidït, rin käk ke ye lueel, aaye nyuɔɔth lɔn nadë ke Jethu yen ë raan bï Nhialic tooc bï kɔc bɛ̈n luɔ̈k, aake ye yith kɔc rac nhïïm, ku ë cïn kën ye kɔc Itharel tɔ̈ Damathkuth bɛn bɛ̈ɛ̈r. ");
INSERT INTO dikNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Nawën cï nïn juëc thök, ke kɔc Itharel kuut kenhïïm ku jɔlkë tɛ̈ bï kek Thawul näk thïn cät. ");
INSERT INTO dikNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ku yen Thawul ëcï bɛ̈n lɛ̈k kë cï kɔc Itharel mat yic, kë bïk luɔ̈i ye. Aake cï dhɔ̈l la aɣeer kal geeu yic bɛ̈n aa tiit thook aköl ku wɛ̈ɛ̈r, rin na tëëk thïn ke näk. ");
INSERT INTO dikNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Naɣɔn akäl tök ke tɛ̈ɛ̈u kɔcken ye buɔɔth alom yic, ku luɛ̈ɛ̈ŋkë tɛ̈ɣɔ̈r päny kɔ̈u, ku jɔlkë luaac piny ë wiɛ̈n. ");
INSERT INTO dikNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Thawul acï bɛ̈n dhuk Jeruthalem ku them bï rot mat akut yic, akut abiöth. Ku akëc kɔc ke cï wɛ̈t Jethu gam, gam lɔn cï Thawul rot wel ku bï ya raanden, ku keek aake ye riɔ̈ɔ̈c ë ye. ");
INSERT INTO dikNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Go Barnaba dɔm cin ku ɣɛ̈th tënë atuuc Jethu. Ku jɔl tɛ̈t yic atuuc Jethu yen tɛ̈ cï Thawul Jethu tiɛ̈ŋ thïn dhöl yic ke la Damathkuth, ku lɔn cï Jethu jam tënë ye. Ku yeen aya ëcï tɛ̈t yic atuuc Jethu, yen tɛ̈ cï Thawul kɔc piɔ̈ɔ̈c thïn ke cïï riɔ̈c Damathkuth rin Jethu. ");
INSERT INTO dikNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ku këya Thawul acï bɛ̈n rëër ke ke. Ku jɔl a cath gen Jeruthalem yic ke piööc kɔc rin Jethu ke cie nyin ye riɔ̈ɔ̈c. ");
INSERT INTO dikNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Yeen aya acï ya jam ku teer wël kek kɔc Itharel jam thoŋ Gïrïk, ku ëcï kɔckä duɛ̈r bɛ̈n nɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Nawën le kɔc akuɔ̈tde yök lɔn wïc ye bï nɔ̈k, gokë nyaai ku ɣɛ̈thkë tɛ̈ cɔl Cetharia ku jɔlkë la tuɔɔc Tarthuth. ");
INSERT INTO dikNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ku tɛ̈ɛ̈n, yen ë tɛ̈ cï kɔc cï wɛ̈t Nhialic gam nhïïm bɛ̈n lääu, ku rëërkë ke cïn riɔ̈ɔ̈c gɛɛth yiic ëbën, Judia, ku Galilia ku jɔl a Thamaria. Akut kɔc ke cï wɛ̈t Nhialic gam ëcï yeyic juak, ku ëcï dït rin ye Wëi Nhialic ke kony, rin ë kek rëër ke thek bɛ̈ny Jethu. ");
INSERT INTO dikNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pïtɛr acï bɛ̈ɛ̈i juëc tëëk yiic, na ye ɣɔn akäl tök ke la kɔc cï wɛ̈t Nhialic gam ciëŋ pan cɔl Lida neem. ");
INSERT INTO dikNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Go Pïtɛr mony cɔl Ainiɛth yök Lida, ku yen mony kënë akëc cath run kabɛ̈t rin cï yen ruai. ");
INSERT INTO dikNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Go Pïtɛr lëk Ainiɛth ëlä, “Ainiɛth, Jethu Krïtho acï cɔl apuɔl. Jɔt rot ku löm biɔ̈ŋdu.” Go Ainiɛth rot jɔt nyin yic. ");
INSERT INTO dikNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Go kɔc ke ciëŋ Lida ku Caron Ainiɛth tïŋ ke cath, gokë wɛ̈t bɛ̈ny Jethu gam. ");
INSERT INTO dikNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ku tiŋ cɔl Tabitha cï gam ë ciëŋ Jopa. (Ku riɛnke yen tiŋ kën thoŋ Gïrïk ë cɔl Dorkath, ku wɛ̈tde yic, “Ee lɔ̈ɔ̈c.”) Ku ë ye käpath looi ku kony kɔc ŋɔ̈ŋ. ");
INSERT INTO dikNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ke tɛ̈ɛ̈n ëcï tuany nawën ke thou. Go guäpde lɔɔk ku tɔ̈u ɣön nhial. ");
INSERT INTO dikNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Pan cɔl Jopa ëcï mec apɛi ke Lida. Nawën piŋ kɔc akut cï wɛ̈t Jethu gam lɔn rëër Pïtɛr Lida, gokë kɔc karou tooc bïk la lëk ye ëlä, “Lɔc bɛ̈n tënë ɣo.” ");
INSERT INTO dikNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Go Pïtɛr rot jal guiir ku lööny dhöl kek röör awën karou. Nawën le Jopa, ke ɣɛ̈th ɣön nhial. Ku guɔ̈p ëcï diäär lëër gɔ̈ɔ̈m piny ke dhiau. Ku yekë alɛ̈th cï kɔɔc yen Tabitha ɣɔn pïïr yen jäl aa nyuɔ̈th Pïtɛr. ");
INSERT INTO dikNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Go Pïtɛr kɔc cɔl ala aɣeer ɣööt, ku jɔl yenhiɔl guɔ̈t piny bï röök, ku wël yenhom guɔ̈p raan ku lueel, “Tabitha, jɔt rot!” Go Tabitha ye nyin jäl liep. Nawën tïŋ Pïtɛr go yekɔ̈u jɔt piiny. ");
INSERT INTO dikNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Go Pïtɛr dɔm kök ku kony bï rot jɔt. Ku jɔl Pïtɛr kɔc akut cï wɛ̈t Jethu gam cɔɔl, ku jɔl aa diäär lëër, ku jɔl ke nyuɔ̈th Tabitha ke cï pïr. ");
INSERT INTO dikNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Thoŋ cï Pïtɛr Tabitha cɔl aben pïr acï jäl thiëi Jopa yic ëbën. Ku tɛ̈ɛ̈n kɔc juëc aacï wɛ̈t bɛ̈ny Jethu bɛ̈n gam. ");
INSERT INTO dikNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ku jɔl Pïtɛr ceŋ nïn juëc pan raan biök duny cɔl Thaimon. ");
INSERT INTO dikNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Mony cɔl Kornelio ë tɔ̈ gen Cetharia. Ku yen ë ye bɛ̈ny mac apuruk buɔɔt, “Ke ye cɔl apuruuk Italia.” ");
INSERT INTO dikNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ku yeen ë ye raan path riɔ̈ɔ̈c Nhialic. Yeen ku kacke aake ye Nhialic door. Ee ye kɔc Itharel ŋɔ̈ŋ nyïn kony, ku ë ye lac röök tënë Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Naɣɔn akäl tök, tɔ̈ɔ̈ŋ akɔ̈l, ke këdäŋ bɔ̈ këcït nyuɔ̈th, ku tïŋ atuny nhial ke bɔ̈ ku lueel tënë ye, “Kornelio!” ");
INSERT INTO dikNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Go Kornelio atuny nhial döt ke cï riɔ̈ɔ̈c ku lueel, “Ye kënë ŋö Bɛ̈ny?” Go atuny nhial dhuɔ̈k ye, “Nhialic acï rɔ̈ɔ̈kku piŋ, ku acï kuɔɔny ye looi tënë kɔc ŋɔ̈ŋ nyïn tïŋ aya. Ku awïc bï ke dhuk nhïïm. ");
INSERT INTO dikNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Tuɔɔc kɔc Jopa ëmën bïk mony cɔl Thaimon Pïtɛr la cɔɔl. ");
INSERT INTO dikNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Yeen arɛ̈ɛ̈r pan raan duny biök cɔl Thaimon, wär nhom.” ");
INSERT INTO dikNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Tɛ̈wën cï atuny nhial awën luel ë wëlkä jäl, ke Kornelio cɔl kɔc karou ken lui baai, ku cɔɔl apurukden tïït baai ë Nhialic door, ");
INSERT INTO dikNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ku lëk ke wɛ̈t cï atuny nhial lueel, ku tooc ke Jopa. ");
INSERT INTO dikNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Naɣɔn aköl dɛ̈ɛ̈t, ke röör awën ŋoot dhöl yic, ke cï thiɔ̈k kek Jopa, ke Pïtɛr la ɣön nhial thok tɛ̈cït akɔ̈l ciɛl yic bï la röök. ");
INSERT INTO dikNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ku jɔl cɔk nɔ̈k, ku wïc bï mïth. Tɛ̈wën guiir miëth ke këcït nyuɔ̈th loi rot tënë ye, ");
INSERT INTO dikNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ku tïŋ nhial ke cï rot liep, ku luɛɛc këdäŋ rot piny, këdïït la tɛ̈ɣɛ̈i, la guɔ̈k kaŋuan, ");
INSERT INTO dikNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","la yic kuat lääi ëbën, ku käk wuc keyöth piiny ku diɛt pär nhial. ");
INSERT INTO dikNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ku piŋ röl ke lëk ye, “Jɔt rot Pïtɛr, näk lɛ̈i ku cuet.” ");
INSERT INTO dikNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Go Pïtɛr lueel, “Acie tɛ̈de Bɛ̈ny! Ɣɛn akëc kaŋ mïth käk cie cam cït käkkä.” ");
INSERT INTO dikNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Go röl bɛn jam tënë ye, “Duk tak lɔn le yen ke cïï path bï cam tɛ̈ cï Nhialic ye lueel ka path.” ");
INSERT INTO dikNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Kënë acï röl awën ber yic arak diäk, nawën ke wiɛ̈n mit, ku dhuk nhial. ");
INSERT INTO dikNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ku gɛ̈i Pïtɛr kë wïc Nhialic bï lëk ye ë nyuɔ̈th kënë yic. Ku ë kaam awën ke kɔc cï Kornelio tooc aacï tɛ̈ rëër pan Thaimon thïn ŋic, ka kääc yɔl thok. ");
INSERT INTO dikNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ku cöötkë ku thiëckë, “Le jäl tɔ̈ baai tɛ̈n cɔl Thaimon Pïtɛr?” ");
INSERT INTO dikNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Tɛ̈wën ŋot wïc Pïtɛr ye bï nyuɔ̈th deet yic, ke lëk Wëi Nhialic ye, “Pïtɛr, piɛŋ yïyïc, ala kɔc kadiäk cï bɛ̈n wïc yï. ");
INSERT INTO dikNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Guir rot ku lɔɔr piny, ku duk wɛ̈t ciɛth kek yɔ̈ŋ yic ba cïï la ke ke, ee ɣɛn acɔl ke aabɔ̈.” ");
INSERT INTO dikNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Go Pïtɛr la piny ku lëk ke, “Ee ɣɛn raan wiɛ̈ckë. Yeŋö bïï wek?” ");
INSERT INTO dikNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Gokë bɛ̈ɛ̈r, “Ɣok aacï bɛ̈ny apuruuk Kornelio tooc. Yeen ë raan path Nhialic door, ku yeen atheek kɔc Itharel ëbën. Acï atuny Nhialic lɛ̈k ye bï yï caal paande, rin bï yen wɛ̈t ba la lɛ̈k ye piŋ.” ");
INSERT INTO dikNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Go Pïtɛr ke cɔɔl, “Bäk niɛnkë ë wɛ̈ɛ̈r kënë.” Nawën bak piny ke Pïtɛr jiël ke ke, ku cath kɔc kɔ̈k cï gam Jopa kek ye aya. ");
INSERT INTO dikNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Na aköl dɛ̈ɛ̈t ke ɣet Cetharia tɛ̈ tiit Kornelio ye thïn, kek kacke ku mäthken cï cɔɔl. ");
INSERT INTO dikNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Tɛ̈wën dööt Pïtɛr baai, ke lor Kornelio ku gut yenhiaal piny yenhom. ");
INSERT INTO dikNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Go Pïtɛr cɔl ajɔt rot bï kɔ̈ɔ̈c ku lueel, “Ɣɛn guɔ̈p, ɣɛn ë raan ë path.” ");
INSERT INTO dikNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ku jɔl Pïtɛr jam kek Kornelio agut tɛ̈ ɣeet kek ɣöt, ku yök kɔc juëc ke cï kenhïïm mat, ");
INSERT INTO dikNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ku lueel tënë ke, “Aŋiɛckë lɔn löŋdan Itharel ë raan pëën bï cïï la bɛ̈ɛ̈i kuat dɛ̈t yiic, ku cïï mɛ̈t ke ke. Ku acï Nhialic nyuɔ̈th ɣa lɔn acïn raan luɛɛl ka la guɔ̈p kärɛc. ");
INSERT INTO dikNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Këya, wën cï yïn ɣa tuɔ̈c, ɣɛn acï bɛ̈n ke cïn diu, ku awiëc ba ŋic aya, yeŋö tuc yïn ɣa.” ");
INSERT INTO dikNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Go Kornelio lueel, “Wäär nïn kadiäk cök ɣɛn ɣa rɔ̈ɔ̈k ɣööt ë tɛ̈n, tɛ̈cït mënë tääŋ akɔ̈l, kaam wën ke raan ceŋ alɛ̈th ɣer apɛi bɔ̈ ku kɛ̈ɛ̈c ɣanhom, ");
INSERT INTO dikNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ku lueel, ‘Kornelio! Nhialic acï rɔ̈ɔ̈kku piŋ, ku acï kuɔɔny ye looi tënë kɔc ŋɔ̈ŋ nyïn tïŋ. ");
INSERT INTO dikNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Tuɔɔc raan Jopa bï mony cɔl Thaimon Pïtɛr la cɔɔl. Yeen arɛ̈ɛ̈r pan raan duny biök cɔl Thaimon tɔ̈ wär nhom.’ ");
INSERT INTO dikNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Guɔ yï tuɔ̈c nyin yic. Ku yïn acï këpath looi ba bɛ̈n. Ëmën, ɣok aa rɛ̈ɛ̈r tɛ̈n ëbën ɣo dɛɛi Nhialic, buk kë cï Nhialic lëk yï ba lueel, piŋ.” ");
INSERT INTO dikNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Go Pïtɛr jäl jam ëlä, “Aca deet yic ëmën lɔn ë yic, Nhialic acie kɔc ë poc yiic. ");
INSERT INTO dikNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Kuat raan ye door ku looi käpath, aye gam. Acïn këde kek kuat. ");
INSERT INTO dikNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Yïn aŋic wɛ̈t cï lɛ̈k kɔc Itharel, Wɛ̈t Puɔth Yam cï Jethu Bɛ̈ny mac kɔc ëbën bɛ̈ɛ̈i bï kɔc dɔ̈ɔ̈r ke Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Yïn aŋic käkdït cï röt looi pan Itharel ëbën, jɔɔk wun Galilia, lɔ̈k wëi wäär ye Joon lɛ̈k kɔc cök ciëën. ");
INSERT INTO dikNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Yïn aŋic Jethu raan Nadharet, raan cï Nhialic lɔc ku cɔl Wɛ̈ike abɔ̈ tënë ye ku gɛ̈m riɛl. Jethu ë ye la ɣɔ̈n juëc yiic, ku looi käpath tënë kɔc. Ku kony kɔc la gup jakrɛc. ");
INSERT INTO dikNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ɣok aacï käjuëc cï looi gen Jeruthalem ku pan Itharel ëbën tïŋ, ayï kë cï ye piäät tim cï rïïu kɔ̈u bï nɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ku ben Nhialic cɔl apïr ku jöt bei piiny raŋ yic aköl ye nïn diäk, ku cɔl anyuth rot ɣo. ");
INSERT INTO dikNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ku acie kɔc ëbën aa ɣook kɔc ɣok cï Nhialic lɔc buk ŋic. Ɣok aacï mïth ku dëkku kek ye wäär jön rotde cök ciëën. ");
INSERT INTO dikNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ku lëk ɣo buk wɛ̈tde lɛ̈k kɔc, ku luelku lɔn ë yen acï Nhialic lɔc bï luk looi tënë raan ëbën, kɔc pïr ku kɔc cï thou. ");
INSERT INTO dikNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Kɔc ëbën, kɔc käk Nhialic tïŋ aacï jam riɛnke, ku luelkë na gam raan wɛ̈t Jethu, ke Nhialic apɛ̈l käracke piny riɛnke.” ");
INSERT INTO dikNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Tɛ̈wën ŋot jiɛɛm Pïtɛr, ke Wëi Nhialic lööny kɔc awën pïŋ gup. ");
INSERT INTO dikNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ku kɔc Itharel wäär bɔ̈ Jopa kek Pïtɛr aake cï gäi, rin cï kek Nhialic tïŋ ke cï miɔ̈cde gäm kɔc kuat dɛ̈t cie kɔc Itharel aya. ");
INSERT INTO dikNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Rin aa cïk tïŋ ke jam thok kɔ̈k, ku luelkë, “Nhialic adït.” Go Pïtɛr jam, ");
INSERT INTO dikNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Kɔckä aacï Wëi Nhialic bɛ̈n tënë ke cïmënda aya. Nadë, le raan bï ke pëën bï ke cïï muɔc nhïïm?” ");
INSERT INTO dikNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ku cɔl ke aa muɔc nhïïm rin Jethu Krïtho. Ku lëk Kornelio Pïtɛr bï rëër ke ke nïn lik. ");
INSERT INTO dikNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Atuuc Jethu ku kɔc kɔ̈k cï gam pan Judia yic ëbën, ee cïk piŋ lɔn nadë ke kɔc cie kɔc Itharel aake cï wɛ̈t Nhialic ɣet tënë ke. ");
INSERT INTO dikNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Tɛ̈wën cï Pïtɛr ɣet Jeruthalem, go kɔc ke wïc ye ku bï kɔc cie kuat Itharel aa ŋoot ye jääm guɔ̈p ëlä, ");
INSERT INTO dikNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Yïn yï ye jäl pan kɔc cie ŋoot, ku yïn yï ye rɔm ke ke!” ");
INSERT INTO dikNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Go Pïtɛr ke tɛ̈t këriëëc ëbën cï rot looi, ");
INSERT INTO dikNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Wäär ë la kën ca tïŋ ke ɣa rɔ̈ɔ̈k gen Jopa. Ee la këdïït la tɛ̈ɣɛ̈i, la guɔ̈k kaŋuan, ca tïŋ ke luɛɛc piny nhial, ku tɛ̈ɛ̈u piny ɣalɔ̈ɔ̈m. ");
INSERT INTO dikNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ku jäl luiit yic, guɔ lääi baai ku lääi roor ku jɔl aa lääi wuc keyiic, ku diɛt roor tïŋ thïn. ");
INSERT INTO dikNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ku piɛŋ röl ke ye lɛ̈k ɣa, ‘Jɔt rot Pïtɛr, näk lääi ku cuet!’ ");
INSERT INTO dikNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Guɔ lueel, ‘Acie yic, Bɛ̈ny! Acïn mïïth rɛc ca kaŋ cam cït käkkä.’ ");
INSERT INTO dikNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Guɔ röl bɛn piŋ nhial. ‘Duk tak lɔn le yen kë cïï path bï cam tɛ̈ cï Nhialic ye lueel ka path.’ ");
INSERT INTO dikNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Kënë acï rot looi arak diäk, ku jɔl këdïït la tɛ̈ɣɛ̈i la guɔ̈k kaŋuan awën tɔ̈ lääi thïn, miit ku dhuk nhial. ");
INSERT INTO dikNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Kaam thiin awën ke röör kadiäk cï tuɔ̈c ɣa tɛ̈ cɔl Cetharia ɣëët pan awën rëër ɣɛn thïn. ");
INSERT INTO dikNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ku ëcï Wëi Nhialic lɛ̈k ɣa, ba nhom cïï thiek ba cath ke ke. Ku jɔl kɔckä kadätem akutdan kɔc cï gam yic ɣa ruac, jäl Jopa agut Cetharia, ku lok pan Kornelio. ");
INSERT INTO dikNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ku lëk Kornelio ɣo lɔn cï yen atuny nhial tïŋ ke kääc yenhom ɣɔ̈nde ku lëk ye, ‘Tuɔɔc raan Jopa tënë mony cɔl Thaimon Pïtɛr bï bɛ̈n. ");
INSERT INTO dikNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Yen abï lɛ̈k wël bï yïn ku miɛ̈thku cɔl apoth kërac yic.’ ");
INSERT INTO dikNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Nawën jaam, ke Wëi Nhialic lööny kegup cïmën ɣɔn tueŋ kɔŋ yen lööny ɣogup. ");
INSERT INTO dikNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ku jal kënë cï Bɛ̈ny Jethu lueel ɣɔn tak, ‘Joon ë ye kɔc muɔc nhïïm ë pïu, ku wek aabï muɔc nhïïm Wëi Nhialic.’ ");
INSERT INTO dikNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Acie kë lëu bï baai dhɔ̈l lɔn cï Nhialic kënë yen cï yiëk ɣo, yiëk kɔc cie kɔc Itharel aya, ku ë yïk ɣo wɛ̈t cï ɣok wɛ̈t Bɛ̈ny Jethu gam, ke ɣɛn ya ŋa, ba them ba Nhialic gël nhom!” ");
INSERT INTO dikNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Nawën piŋkë wël cï Pïtɛr lueel, gokë cïï ben jääm guɔ̈p ku leckë Nhialic ëlä, “Kën yen ë wïc Nhialic aya, ku bï kɔc cie kɔc Itharel kärɛc yekë looi puɔ̈l, ku bïk mɛt pïr akölriëëc ëbën yic!” ");
INSERT INTO dikNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Kɔc ke cï gam aake cï wɛɛr rin cï kek riɔ̈ɔ̈c lɔn nɛ̈k ke cïmën wäär cï Ithipin nɔ̈k. Kɔc kɔ̈k ke yiic aacï ɣet pan cɔl Ponicia ku Thaipruth ku Antiök. Ku keek aake ye kɔc Itharel kepɛ̈c kek aake ye lɛ̈k wɛ̈t yam Jethu. ");
INSERT INTO dikNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ku kɔc kɔ̈k ke cï gam, ku aake ye kɔc pan Thaipruth ku Thirene, aake cï la Antiök ku lek Wɛ̈t Puɔth Yam lɛ̈k kɔc cie kɔc Itharel aya. Aa cïk aa lɛ̈k thoŋ puɔth yam rin Bɛ̈ny Jethu. ");
INSERT INTO dikNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Aake cï Nhialic yiëk riɛl. Go kɔc juëc gam ku yekë Nhialic door. ");
INSERT INTO dikNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Thoŋ cï kɔc cie kɔc Itharel gam Antiök acï ɣet tënë kɔc cï gam Jeruthalem. Gokë Barnaba tuɔɔc Antiök. ");
INSERT INTO dikNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Wën cï yen ɣet ku tïŋ tɛ̈ cï Nhialic kɔc Antiök daac thïn, ke jɔl puɔ̈u miɛt ku jiëëm kenhïïm ku bïk aa kɔc path ɣer puɔ̈th, nhiar Nhialic piänden ëbën. ");
INSERT INTO dikNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnaba ë ye raan path cï Nhialic gam piände ëbën, ku ë la guɔ̈p Wëi Nhialic. Kɔc juëc aacï wɛ̈t Bɛ̈ny bɛ̈n gam. ");
INSERT INTO dikNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ku jɔl Barnaba jäl ku ler pan cɔl Tarthuth ku bï Thawul la wïc. ");
INSERT INTO dikNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Nawën le yök, gokë bɛ̈n Antiök. Ku jɔlkë rëër Antiök ë ruɔ̈ɔ̈n, ku keek aake ye rɔ̈m kek kɔc cï gam, ku aacï akut dït apɛi bɛ̈n piɔ̈ɔ̈c. Antiök yen ë tɛ̈n kɔŋ kɔc cï gam aa cɔɔl thïn ka Krïthiaan. ");
INSERT INTO dikNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ruɔ̈ɔ̈n yen rëër Barnaba kek Thawul Antiök, yen ë tɛ̈n jiël kɔc kɔ̈k käk Nhialic tïŋ Jeruthalem ku lek Antiök. ");
INSERT INTO dikNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Raan tök ke yiic cɔl Agabuth ëcï Wëi Nhialic yiëk riɛl, ku bï lɛ̈k kɔc lɔn le yen cɔŋdïït bï bɛ̈n pinynhom ëbën. (Cɔŋ kënë acï bɛ̈n bɛ̈n ɣɔn ye Klaudiöth bɛ̈nyŋaknhom.) ");
INSERT INTO dikNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ku abiöth aacï raan tök keyiic ëbën la kënë cï ya tuɔ̈c wämäthaken cï gam ciëŋ wun Judia. ");
INSERT INTO dikNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ku keek aacï wëëu kuɔ̈ɔ̈t yiic, ku jɔlkë Barnaba ku Thawul tooc bïk ke ɣäth tënë kɔcdït akut kɔc cï gam. ");
INSERT INTO dikNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ë runkä cɔk ëcï baai kööl agut Judia, go bɛ̈ny Judia cɔl Ɣërot Agrïpa kɔc abɛ̈k kɔc cï gam yiic cɔl abaŋ. ");
INSERT INTO dikNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Yeen acï mɛ̈nh Joon cɔl Jemith cɔl atök yeth pal. ");
INSERT INTO dikNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Na le tïŋ ke kɔc Itharel mit puɔ̈th kë cï looi, go Pïtɛr cɔl adɔm ku mac, (yen kënë ë loi rot ɣɔn ciɛm Yan Ayum cïn yic luɔu.) ");
INSERT INTO dikNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Nawën cï Pïtɛr dɔm ku mac, ke thön akuut apuruuk kaŋuan bïk aa tiit. Ku akuɔ̈t tök ë la yic kɔc kaŋuan. Ee cï Ɣërot Agrïpa tak ku bï Pïtɛr ɣäth luk yic aköl Yan Ayum cïn yic luɔu cök ciëën. ");
INSERT INTO dikNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ku Pïtɛr acï jäl rëër mɛ̈c yic. Ku kɔc cï gam aake ye röök riɛnke apɛi tënë Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Wɛ̈ɛ̈r yen bï Ɣërot Agrïpa ye cɔl abïï luk yic rial, Pïtɛr ë nin kam apuruuk karou ke tit ye. Ee cï rek cïn arëk karou, ku ɣön mɛ̈c ë tit thok apuruuk kek ke lui akölë. ");
INSERT INTO dikNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Tɛ̈wën nyin yic ka atuny Nhialic bɔ̈ ku kɛ̈ɛ̈c ɣöt thok ku mer ɣöt yic. Ku mɛŋ Pïtɛr kët ku puɔ̈ɔ̈c bï rot jɔt ku lëk ye, “Lɔc rot jɔt! Ku ban yïkɔ̈u!” Nyin yic, ke luɔ̈ŋ awën cï ye rek lööny wei yecin. ");
INSERT INTO dikNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ku lueel atuny nhial, “Dut yïyic ku ruɔ̈k warku.” Go Pïtɛr yeyic duut ku ruk war, ku lëk atuny nhial ye, “Paat alanhdu yïkɔ̈u ku buɔth ɣa.” ");
INSERT INTO dikNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Go Pïtɛr jäl biaath cök aɣeer, Pïtɛr ë këc kën loi rot deet yic, lɔn nadë ke kë looi atuny nhial ë yic. Ëcï tak ciɛ̈t ye nyuɔ̈th. ");
INSERT INTO dikNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Keek aacï jal tëëk akuɔ̈t tök lɔ̈ɔ̈m, akut apuruuk ke tït, ku benkë rëët akut dɛ̈t ye kek rou lɔ̈ɔ̈m ku jɔlkë ɣet kal thok, kal ye gur thok wëëth cï yethok wɛl geeu. Go kal yethok ŋaany ë rot ku lek aɣeer. Keek aacï jäl la ke cath dhël yic, nawën ka atuny nhial mär. ");
INSERT INTO dikNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ku jɔl Pïtɛr kë lui rot ye deet yic ku lueel, “Ëmën aca jal ŋic lɔn ye yen yic kënë awën ya tïŋ këcït nyuɔ̈th! Nhialic acä tuɔ̈c atuɔ̈nyde bä bɛ̈n kuɔ̈ny bei Ɣërot Agrïpa cin, ku jɔl aa käk ke ye kɔc Itharel tïŋ ke bïk luɔ̈i ɣa.” ");
INSERT INTO dikNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Nawën ŋic lɔn rëër yen tɛ̈rac, go la pan Maria man Joon Marko. Ku kɔc juëc aake cï kenhïïm kut thïn ë ke rɔ̈ɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ku jɔl Pïtɛr ɣöt tɔɔŋ thok aɣeer, go nyan aluaak lui baai cɔl Roda la bï raan ɣöt gut thok la tïŋ. ");
INSERT INTO dikNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ku ëcï Pïtɛr ŋic röl, go puɔ̈u miɛt apɛi, ku go guɔ kat ke këc ɣöt liep thok, ku le lɛ̈k kɔc lɔn yen ke Pïtɛr yen akääc aɣeer. ");
INSERT INTO dikNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Go kɔc awën rɛ̈ɛ̈r ɣöt lɛ̈k ye, “Yïn acï muɔ̈l!” Go lɛ̈k ke lɔn ë yic yen acï lɛ̈k ke. Gokë lueel, “Ka atiɛ̈mde yen acï bɛ̈n.” ");
INSERT INTO dikNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ku la Pïtɛr tueŋ ke tɔŋ ɣöt thok, gokë ɣöt ŋaany thok. Gokë tïŋ ku gɛ̈ikë. ");
INSERT INTO dikNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Go Pïtɛr lɛ̈k ke bïk biɛt, ku jɔl tɛ̈t yic ke yen tɛ̈ cï Nhialic ye bɛ̈ɛ̈i bei thïn ɣööt ë mɛ̈c yic ku lëk ke, “Lɛ̈kkë Jemith ku wämäthkuan kɔ̈k yen kë cï rot looi.” Ku jiël bï la tɛ̈dɛ̈t. ");
INSERT INTO dikNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Na la piny bak, go apuruuk ke tït nhïïm la cɔ̈t, ku yekë röt thiëëc kamken, “Yeŋö cï rot looi tënë Pïtɛr?” ");
INSERT INTO dikNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Go Ɣërot Agrïpa apuruuk yɔ̈ɔ̈k bïk yɔ̈ɔ̈p. Ku akëc kë bɛ̈n yök. Go apuruuk cɔl adet thook, ku lëk kɔc kɔc nɔ̈k bï ke nɔ̈k. Tɛ̈wën cï ë kënë rot looi go Ɣërot Agrïpa jäl Judia, ku ben la ceŋ Cetharia. ");
INSERT INTO dikNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Nawën cï Ɣërot Agrïpa puɔ̈u riääk tënë bäny Tire ku Thidon, gokë la ke ya akut bïk la tïŋ. Ku ë cïk kaŋ lëk Blatuth raan käk pan bɛ̈ny tiit bï wɛ̈tden gam. Ku jɔlkë la tënë Ɣërot Agrïpa ku thiëckë bï dɔ̈ɔ̈r ke ke, rin keek aake ye mïïth yök wun yen mɛc Ɣërot Agrïpa. ");
INSERT INTO dikNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Naɣɔn aköl yen cï Ɣërot Agrïpa lueel bï yen mat ke ke, go ruk alɛ̈thken bääny ku nyuuc thɔ̈nyde nhom ku jiɛɛm ke kɔc. ");
INSERT INTO dikNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ku jɔl kɔc duɔɔt aa looi ëlä, “Acie raan yen jam, Aciëk.” ");
INSERT INTO dikNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ee tɛ̈ɛ̈n, Ɣërot Agrïpa acï atuny Nhialic bɛ̈n cɔl atuany, rin cï yen rot looi bï a yen ye door ku cie Nhialic yen ye door. Nawën ke cuet käm tɔ̈ yeyäc yic, ku thou. ");
INSERT INTO dikNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Wɛ̈t Nhialic acï bɛ̈n la tueŋ ku kɔc juëc aacï bɛ̈n gam. ");
INSERT INTO dikNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ku Barnaba kek Thawul aacï luɔiden bɛ̈n thöl, ku dhukkë Jeruthalem ke cath kek Joon Marko. ");
INSERT INTO dikNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Kɔc ke cï gam Antiök aake la yiic kɔc ke ye käk Nhialic tïŋ, ku jɔl aa kɔc ë kɔc cï gam piɔ̈ɔ̈c, ku keek aake ye yï Barnaba ku Thaimon. (Raan col) ku Lukiöth (raan pan Thirene) ku Maneen (ku yen ë ye mɛ̈thë bɛ̈ny cɔl Antipäth Ɣërot) ku Thawul. ");
INSERT INTO dikNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Tɛ̈wën ye kek röök thïn tënë Bänyda, ku yekë mïïth theek ke ye dhël dɛ̈t dɔ̈ɔ̈r kek Nhialic, go Wëi Nhialic lɛ̈k ke ëlä, “Pälkë Barnaba ku Thawul ku bïk luɔi ca lɔ̈c ke aa looi.” ");
INSERT INTO dikNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ku jɔl kɔc cï gam miëth aa theek ku röökkë ku jɔlkë Barnaba ku Thawul dɔɔc ku jɔlkë ke cɔl ajiël bïk luɔi cï Nhialic lɔ̈c ke la luɔ̈i Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Barnaba ku Thawul aake cï Wëi Nhialic tooc bïk la gen cɔl Theleukia ku lek teem kɔ̈u riäi ku lek gen tɔ̈ gool nhom wär ciɛl yic cɔl Thaipruth. ");
INSERT INTO dikNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Na lek ɣet gen dɛ̈t cɔl Thalamith, gokë kɔc aa piɔ̈ɔ̈c wɛ̈t Nhialic tɛ̈n amat kɔc Itharel. Ku Joon Marko ë cath ke ke rin bï keek aa kony luɔi. ");
INSERT INTO dikNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Keek aacï cath ku temkë Thaipruth kɔ̈u, ku lek gen Papoth yen le kek raan dɛ̈t tiët cɔl Bar-Jethu ke ye raan Itharel, yök thïn. Ku ëcï rot a nyuɔɔth ciɛ̈t ye raan kɔc lɛ̈k wɛ̈t Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Yen Bar-Jethu ë ye mɛ̈thë bɛ̈nydït cɔl Therjiuth Pauluth, bɛ̈ny wun tɔ̈ gool nhom wär ciɛl yic. Ku yeen ë ye raan pel nyin apɛi. Bɛ̈ny ëcï Barnaba kek Thawul tuɔ̈c ku bïk bɛ̈n tënë ye, rin ë wïc bï piɔ̈ɔ̈c wɛ̈t Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ku yen luɔiden bï kek bɛ̈ny piɔ̈ɔ̈c ëcï tiët Elimath (aa kek riɛnke thoŋ Gïrïk) duɛ̈r rac, rin cï yen ye them bï bɛ̈ny rac nhom bï wɛ̈t Nhialic cïï gam. ");
INSERT INTO dikNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ke Thawul, ku aŋic aya lɔn cɔl ye Paulo, ëcï Wëi Nhialic la yeguɔ̈p, go tiët tïŋ ku döt apɛi, ");
INSERT INTO dikNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ku lëk ye, “Yïn mänh jɔŋrac. Yïn raan la ater kek käpath ëbën. Yïn athiäŋ guɔ̈p kärɛc, ku aye them akölaköl ba yith Nhialic wel bïk aa lueth! ");
INSERT INTO dikNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Yïn abïï Nhialic jak guɔ̈p ëmën. Yïn abï cɔɔr ku yïn abï nïn nɔ̈k ke yï cïï piny ben tïŋ.” Nyin yic Elimath, ëcï kën macär guɔ paat nyin piny, ku jɔl cath ke wïc raan bï ye dɔm cin bï thel. ");
INSERT INTO dikNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Nawën tïŋ bɛ̈nydït kë cï rot looi, go wɛ̈t Nhialic gam rin yeen ëcï gäi apɛidït käk cï ke ye piɔ̈ɔ̈c wɛ̈t Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paulo ku jɔl aa kɔcken cath kek ye aacï wär teem riäi ke jiël Papoth ku lek Perga, wun cɔl Pampilia. Tɛ̈wën, Joon Marko acï bɛ̈n puɔ̈k ke ke ku dhuk Jeruthalem. ");
INSERT INTO dikNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ku ben kë jäl Perga ku ɣeetkë Antiök tɔ̈ wun cɔl Pithidia. Nawën aköl lɔ̈ŋ, aköl cïï kɔc ë luui, go Barnaba ku Paulo la tɛ̈n amat ku nyuuckë thïn. ");
INSERT INTO dikNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Nawën cï lööŋ Mothith, ku jɔl aa wël kɔc käk Nhialic tïŋ kueen, go bäny tɛ̈n amat wɛ̈t lɛ̈k Barnaba ku Paulo ëlä, “Wämäthakua wek aa wïcku bäk kɔc jääm nhïïm, tɛ̈ le yen wɛ̈t bï ke riɛɛl puɔ̈th bäk lɛ̈k ke.” ");
INSERT INTO dikNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Go Paulo rot jɔt, ku nyooth yecin bï kɔc biɛt. Ku jɔl jam ëlä, “Wek mɛ̈thkiɛ̈ pan Itharel, ku jɔl aa kɔc cie kɔc Itharel Nhialic door, piɛŋkë wɛ̈tdiɛ̈. ");
INSERT INTO dikNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Nhialic kɔc Itharel ëcï wärkuan dït lɔc ku looi ke ke ye kuatdït ril tör tɛ̈wäär ciëŋ kek ke ye alɛi wun cɔl Ijip. Keek aake cï Nhialic bɛ̈ɛ̈i bei Ijip riɛlde. ");
INSERT INTO dikNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ku acï kärɛc yekë luɔ̈i ye guum roor ruɔ̈ɔ̈n thiärŋuan. ");
INSERT INTO dikNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ku Nhialic acï wuɔ̈t kadhorou cuɔp wei pan Kanaan. Ku looi kacke bï aa kek la piny, ");
INSERT INTO dikNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","tɛ̈cït run buɔt kaŋuan ku thiärdhiëc. “Wën cï kën rot looi, go Nhialic ke yiëk kɔc mac ke agut tɛ̈ tul raan käk Nhialic tïŋ cɔl Thamuel. ");
INSERT INTO dikNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Nawën thiëckë Nhialic bï ke yiëk bɛ̈nyŋaknhom, go Nhialic ke yiëk Thawul raan many Kïc, kuat Benjamin yic, ku bï ya bɛ̈ny ruɔ̈ɔ̈n thiärŋuan. ");
INSERT INTO dikNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","“Nawën cï Thawul nyaai bääny yic, go Nhialic Debit looi ke ye bɛ̈nyŋaknhomden. Ku kën cï Nhialic lueel riɛnke akïn, ‘Aca yök lɔn Debit, wën Jethe yen ë raan yen wiɛ̈c. Ku ë yen raan bï käk wiɛ̈ckë bïk röt looi, aa looi.’ ");
INSERT INTO dikNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Ë ye Jethu raan kuat Debit, yen cï Nhialic looi ke ye raan bï kɔc Itharel luɔ̈k, tɛ̈cït tɛ̈ cï yen ye luɛɛl thïn wäär. ");
INSERT INTO dikNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Wäär këc Jethu luɔide jɔɔk, ke Joon ëcï kɔc Itharel kaŋ lɛ̈k wɛ̈t Nhialic. Ku ye ke yɔ̈ɔ̈k bïk muɔ̈l luɔi kärɛc, ku cɔlkë röt aa muɔc nhïïm pïu. ");
INSERT INTO dikNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Na wäär cï luɔi Joon thiɔ̈k kek thök, go kɔc thiëëc ëlä, ‘Yakë tak ya ŋa? Acie ɣɛn raan tiɛtkë. Raan tiɛtkë abï lɔ̈k bɛ̈n ɣacök. Ku acie ɣɛn raan lëu ye ba warke däk bei yecök.’ ");
INSERT INTO dikNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Wek wämäthkiɛ̈ Itharel, mïth Abaram, ku jɔl aa wek kɔc cie kɔc Itharel rɛ̈ɛ̈r tɛ̈n Nhialic door. Wɛ̈t bï kɔc kony bï kɔc cïï la pan mac acï lɛ̈k ɣo. ");
INSERT INTO dikNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ku yeen akëc kɔc ke ciëŋ Jeruthalem ku bänyken ŋic, lɔn nadë ke yen raan bï kɔc bɛ̈n kony. Ku keek akëc wël deet yiic aya, wël ke ye kɔc käk Nhialic tïŋ lɛ̈k ke wäär ye kueen akölaköl, aköl lɔ̈ŋ. Ku keek aacï wël kɔc käk Nhialic tïŋ cɔl aa tiiŋ kenhïïm, rin cï kek Jethu cɔl anäk. ");
INSERT INTO dikNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Cɔk alɔn cïn yen yiny cïk yök bï ke ye tɛ̈m thou, gokë ŋuɔ̈t ke thiëc Pilato bï dhiɛl nɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ku wën cï kek këriëëc ëbën looi, käk ke cï gɔ̈t athör thɛɛr wël Nhialic yic riɛnke, gokë jat piny tim cï rïïu kɔ̈u ku lek thiɔ̈k raŋ yic. ");
INSERT INTO dikNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ku yeen acï Nhialic cɔl aben pïr. ");
INSERT INTO dikNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ku aacï rot nyuɔ̈th kɔc ke ye cath kek ye kam Galilia ku Jeruthalem nïn juëc yiic. Kek kɔckä, kek aacï käk cï röt looi tïŋ, ku lëkkë ke kɔc Itharel. ");
INSERT INTO dikNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","“Ku ɣok aacï bɛ̈n buk we bɛ̈n lɛ̈k thoŋ path cï Nhialic yepuɔ̈u tɔɔŋ ke bï luɔ̈i wärkuan dït. Acï luɔ̈i ɣo ëmën ɣok miɛ̈thken, rin cï yen Jethu cɔl aben pïr ke cï thou. Cïmën cï ye gɔ̈t ëlä waak rou athör thɛɛr wël Nhialic yic, ‘Yïn ee wëndiɛ̈, ɣɛn acï ya Wuur akölë.’ ");
INSERT INTO dikNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“Ku yen kënë yen ë kë cï Nhialic lueel, lɔn bï yen ye cɔl aben rot jɔt thou yic, ku bï cïï kɔŋ dhiäth raŋ yic, ‘Yïn aba yiëk yath, ku yïn aba dɔɔc cït tɛ̈wäär, cï ɣɛn ɣapuɔ̈u taaŋ thïn tënë Debit.’ ");
INSERT INTO dikNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","“Ku ë yic alanden, ëcï lueel këlä wɛ̈t dɛ̈t cï gɔ̈t yic, ‘Yïn acä aluɔnydu bï puɔ̈l bï dhiäth raŋ yic.’ ");
INSERT INTO dikNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Ku yen Debit ë ye käk Nhialic looi wäär pïïr yen, ku jɔl thou ku thiäk tɛ̈ cï wärken dït thiɔ̈k thïn. Ku guäpde acï bɛ̈n dhiäth raŋ yic. ");
INSERT INTO dikNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ku kën akëc rot looi tënë raan cï Nhialic jɔt bei raŋ yic. ");
INSERT INTO dikNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","“Awiëc bäk ŋic wek wämäthkiɛ̈ Itharel, lɔn nadë ke rin Jethu yen abï kärɛc päl piny tënë kɔc. Raan bï wɛ̈tde gam abï adumuɔ̈ɔ̈mke päl piny tënë ye. Ku kënë ë këc löŋ Mothith looi wäär tënë we. ");
INSERT INTO dikNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Tääukë wenyïn piny apath bï kë cï kɔc käk Nhialic tïŋ, cïk lɛ̈k kɔc ëlä rot cïï lui we, ");
INSERT INTO dikNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Tiɛ̈ŋkë wek kɔc kɔc dɔl gup! Gäikë ku wek aabï liu, rin kë luɔɔi akölë! Acie kë bäk gam, cɔk alɔn bï raandä ye teet yic tënë we!’ ” ");
INSERT INTO dikNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Wën jiël Paulo ku Barnaba tɛ̈n amat, goke yɔ̈ɔ̈k ku bïk bɛn bɛ̈n aköl dɛ̈ɛ̈t amat bïk wɛ̈t lööŋ Nhialic bɛ̈n ber yic. ");
INSERT INTO dikNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Wën cï kɔc jäl amat yic, ke Paulo ku Barnaba ruɛc kɔc juëc Itharel, ku kɔc juëc cie kɔc Itharel cï ciɛɛŋ kɔc Itharel gam. Ku jɔl Paulo kek Barnaba lɛ̈k ke bïk kepuɔ̈th dɛɛt, ku bïk pïr ke ŋɔ̈th piath Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Nawën aköl dɛ̈t amat, ke kɔc juëc apɛi bɔ̈ amat yic aabï ciɛ̈t kɔc ëbën geeu kek cï guëër bïk bɛ̈n piŋ wɛ̈t Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Nawën tïŋ kɔc Itharel akut dïït kënë ke dɔm tiɛɛl ke. Ku yekë wɛ̈t lueel Paulo dhɔ̈l yic ku yekë lat. ");
INSERT INTO dikNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ku Paulo kek Barnaba aacï bɛ̈n jam apɛi këlä ke cïï riɔ̈c, “Kën yen bï rot kaŋ looi tueŋ, ee lɔn bï we lɛ̈k wɛ̈t Nhialic. Ku na cäk kuec bäk wɛ̈t Nhialic cïï gam, ku yakë röt yök ke we cie kɔc wïc pïr akölriëëc ëbën, ke wek aa buk nyääŋ piny ku lok tënë kɔc kɔ̈k cie kɔc Itharel. ");
INSERT INTO dikNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Rin ɣok aacï Nhialic yɔ̈ɔ̈k ëlä, ‘Wek aaca looi ke we cït mermer tënë kɔc cie kɔc Itharel, rin bï raan ëbën pinynhom poth la pan mac.’ ” ");
INSERT INTO dikNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Nawën piŋ kɔc cie kɔc Itharel wɛ̈t kënë, gokë puɔ̈th miɛt ku leckë wɛ̈t Nhialic cïk piŋ. Ku kɔc ke cï lɔc bïk aa kɔc pïr akölriëëc ëbën aake cï bɛ̈n gam. ");
INSERT INTO dikNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Wɛ̈t Nhialic acï bɛ̈n ɣet bɛ̈ɛ̈ikë yiic ëbën. ");
INSERT INTO dikNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Go kɔc Itharel, kɔcdït baai gɛu yic ëbën bɛn rac nhïïm agut diäär kɔcdït cie kɔc Itharel Nhialic door. Ku aacï Paulo ku Barnaba bɛ̈n cuɔp wei panden. ");
INSERT INTO dikNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Go atuuc Jethu mël kuëëŋ ku teŋkë kecök rin cï kek puɔ̈th riääk tënë ke. Ku jiëlkë ku lek pan cɔl Ikonia. ");
INSERT INTO dikNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Kɔc ke cï gam Antiök aake cï Wëi Nhialic la kegup, ku keek aake mit puɔ̈th apɛi. ");
INSERT INTO dikNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Këcït këwäär cï rot looi tënë Paulo ku Barnaba Antiök acie yic bɛn ber aya tënë ke Ikonia. Paulo ku Barnaba aake cï la ɣön ye kɔc Itharel mat thïn, ku jiɛɛmkë arɛ̈k bï kɔc juëc Itharel ku kɔc cie kɔc Itharel wɛ̈t Jethu gam. ");
INSERT INTO dikNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ku kɔc kɔ̈k Itharel cï kuec bïk wɛ̈t cïï gam, aacï kɔc Ikonia luɔ̈m thook bïk kenhïïm wɛ̈l Paulo ku Barnaba. ");
INSERT INTO dikNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ku Paulo kek Barnaba aacï rëër Ikonia nïn juëc. Ku jiɛɛmkë apɛi rin Jethu ke cïï riɔ̈c, ku wɛ̈t yekë lueel ëbën ë yic, rin cï Jethu ke yiëk riɛl bïk käk jäŋ gɔ̈i aa looi. ");
INSERT INTO dikNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ku kɔc juëc tɔ̈ geeu aake cï keyiic tek, kɔc kɔ̈k aake wël kɔc Itharel piŋ ku gam kɔc kɔ̈k wɛ̈t atuuc Jethu. ");
INSERT INTO dikNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Nawën ke mɛt kɔc Itharel yic kek kɔcken dït ku kɔc Konya bïk agaac jɔɔk, ku wïckë bïk ke nɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Nawën la kɔc piööc wɛ̈t cï mat yök cök, gokë riŋ tɛ̈ cɔl Likonia tɔ̈ gɛɛth Lithtra ku Derbe thïn. ");
INSERT INTO dikNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ku piööckë Wɛ̈t Puɔth Yam Bäny Jethu ë gɛɛthkä yiic. ");
INSERT INTO dikNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Mony cï ruai, cie cath, yecök ɣöc piiny tɛ̈wäär dhiëëth ye ë tɔ̈ gen Lithtra. ");
INSERT INTO dikNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ku ë ye wël Paulo piŋ. Go Paulo tïŋ ke cï gam ku pɛth bï kony. Go döt, ");
INSERT INTO dikNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ku lueel, “Jɔt rot ba kɔ̈ɔ̈c!” Go rot wuɔ̈l nhial ku ciɛth. ");
INSERT INTO dikNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Nawën tïŋ kɔc juëc kë cï Paulo looi, gokë jam apɛi thoŋden Likonia, “Aciëëk cït kɔc aacï bɛ̈n piny nhial tënë ɣo!” ");
INSERT INTO dikNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ku ciɛ̈kkë Barnaba ke cɔl Deuth ku ciɛ̈kkë Paulo ke cɔl Ɣërmith rin ë yen raan ye wɛ̈lken lueel. ");
INSERT INTO dikNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Go raandït jɔŋ cɔl Deuth door, jɔŋ rëër yiɛ̈ŋde kal thok miöör la yiëth adir cï cuëëc yɔ̈ɔ̈k bɛ̈ɛ̈i. Ku wïc kek kɔcken juëc rɛ̈ɛ̈r ke ye bïk atuuc door ë ke. ");
INSERT INTO dikNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Nawën piŋ Barnaba ku Paulo ke wïckë bïk looi, gokë aläthken rɛt yiic kekɔ̈th bïk nyuɔɔth lɔn cïï kek këcït kënë wïc, ku riŋkë ciɛl thän awën yic ku lueelkë, ");
INSERT INTO dikNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Yeŋö looi wek kënë? Ɣok aa kɔc ë path cïmëndun. Ɣok aacï bɛ̈n buk Wɛ̈t Puɔth Yam Jethu bɛ̈n lueel, ku buk we nyaai käk yakë doorkä yiic rin cïn kek wɛ̈tden yic, ku bäk aa door Nhialic töŋ pïr, cï nhial ku piny ku wër kek käkkith tɔ̈ thïn ëbën cak. ");
INSERT INTO dikNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Wäthɛɛr Nhialic ëcï kɔc puɔ̈l bïk käkken cïk tak aa door. ");
INSERT INTO dikNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ku Nhialic ë rot nyuɔɔth akölaköl käpuɔth ye looi yiic tënë kɔc. Ee deŋ cɔl atueny ku lok käŋ ëbën cït tɛ̈den ye kek luɔk, ku mitkë puɔ̈th.” ");
INSERT INTO dikNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Cɔk awën këc kɔckä wɛ̈lken lac gam, ka cïk bɛ̈n lëu bïk kɔc dɔk bïk miöör cïï näk. ");
INSERT INTO dikNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Nawën ke kɔc Itharel kɔ̈k bɔ̈ Antiök gen tɔ̈ Pithidia, ku bɔ̈ kɔc kɔ̈k Ikonia, ku rɛckë kɔc nhïïm ku biöökkë Paulo ku ɣöckë aɣeer geeu, ku takkë lɔn cï yen thou. ");
INSERT INTO dikNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Nawën la kɔc cï gam kenhïïm kut yelɔ̈ɔ̈m, ke jɔt rot ku dhuk geeu. Naɣɔn nhiäk ke la Derbe kek Barnaba. ");
INSERT INTO dikNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paulo ku Barnaba aacï Wɛ̈t Puɔth Yam lëk kɔc Derbe ku gam kɔc juëc wɛ̈t Jethu. Nawën ke dhuk Lithtra. Ku lek Ikonia ku jɔl a Antiök tɔ̈ Pithidia. ");
INSERT INTO dikNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ku lëkkë kɔc cï gam bïk gamden muk apath, ku lek tueŋ ke nhiar Jethu. Ku lɛ̈kkë ke piɔ̈ɔ̈cden yic ëlä, “Kɔc cï gam ëbën aa dhil gum ë pïr kënë yic rin bï kek mɛt bääny Nhialic yic aköldä.” ");
INSERT INTO dikNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ku kuanykë kɔcdït akuut kɔc cï gam yiic ëbën, ke cï kaŋ röök tënë Nhialic. Ku thekkë miëth rin bï kek Nhialic kaŋ door. Ku jɔlkë ke than Bɛ̈ny Jethu cin, raan cï kek wɛ̈lke gam. ");
INSERT INTO dikNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Tɛ̈wën kuɛny kek Pithidia yic, gokë bɛ̈n Pampilia. ");
INSERT INTO dikNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ku piööckë Wɛ̈t Puɔth Yam tënë kɔc gen Perga ku lek Atalia. ");
INSERT INTO dikNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ku tɛ̈ɛ̈n ke gër, ku dhukkë Antiök, tɛ̈wäär cï kɔc cï gam ke thön Nhialic thïn rin luɔiden cïk thöl. ");
INSERT INTO dikNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Wën cï kek ɣëët Antiök, ke kuut kɔc cï gam nhïïm ku lëkkë ke käjuëc cïk looi riɛl Nhialic, ku nyooth Nhialic lɔn alëu bï kɔc cie kɔc Itharel gam aya. ");
INSERT INTO dikNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ku rëërkë Antiök pɛ̈i juëc kek kɔc cï gam. ");
INSERT INTO dikNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Kɔc kɔ̈k pan Judia aacï bɛ̈n Antiök, ku piööckë kɔc cï gam ëlä, “Wek aacïï Nhialic bï kony tɛ̈ cïï we dhil ŋoot, cït tɛ̈ cï löŋ Mothith luɛ̈l ye.” ");
INSERT INTO dikNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Go Paulo kek Barnaba jam apɛi rin ë wɛ̈t kënë kek kɔc awën bɔ̈ Judia. Nawën ke mat yic, bï Paulo ku Barnaba ku kɔc kɔ̈k Antiök la Jeruthalem bïk wɛ̈t kënë la jääm yic kek atuuc Jethu ku kɔcdït kɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Go akut kɔc cï gam ke jal tooc, ku wën tëëk kek Ponicia ku Thamaria, ee cïk lɛ̈k kɔc lɔn cï kɔc kɔ̈k cie kɔc Itharel wɛ̈t Nhialic gam. Wɛ̈t kënë acï kɔc cï gam ëbën cɔl amit puɔ̈th. ");
INSERT INTO dikNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Nawën ɣëëtkë Jeruthalem ë ke lor akut kɔc cï gam, ku atuuc Jethu ku kɔcdït, kɔc cïk bɛ̈n lɛ̈k käjuëc cï Nhialic ke kony bïk ke looi. ");
INSERT INTO dikNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Go kɔc kɔ̈k akut Parathï cï gam röt jat nhial ku luelkë, “Keek aa dhil ŋoot ku lëk ke bïk löŋ Mothith dhiɛl theek.” ");
INSERT INTO dikNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Go atuuc Jethu ku kɔcdït kenhïïm mat bïk wɛ̈t kënë tak yic. ");
INSERT INTO dikNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Wën cï kek wɛ̈t jääm yic apɛi, ke Pïtɛr jɔt rot ku lueel, “Wek kackiɛ̈ aŋiɛckë lɔn ɣɛn acï Nhialic lɔc wäär kamkun, ba Wɛ̈t Puɔth Yam lɛ̈k kɔc cie kuat Itharel, rin bï kek wɛ̈t Bɛ̈ny piŋ ku gamkë. ");
INSERT INTO dikNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ku Nhialic aŋic kë tɔ̈ raan ëbën puɔ̈u, acï nyuɔɔth lɔn yeen alëu kɔc kɔ̈k cie kɔc Itharel bïk gam aya cïmën cï yen Wɛ̈ike cɔl abɔ̈ tënë ke, cïmën wäär cï yen ye luɔ̈i ɣo aya. ");
INSERT INTO dikNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Acï nyuɔɔth lɔn ɣok kɔc Itharel ku thäi kɔ̈k, ɣok aa thöŋ ëbën, ku nyɛɛi kärɛc kepuɔ̈th rin cï kek gam. ");
INSERT INTO dikNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","“Na ye këya, ke yeŋö looi wek kë cï Nhialic nyuɔ̈th we bäk cïï loi, rin wïc wek ye ë path bäk tɛ̈ bï yen puɔ̈u riëëk thïn tïŋ. Tɛ̈ jɔ̈t ɣok kɔc cï gam nhïïm këril këc wärkuan dït ku ɣo aya, kaŋ lëu buk ɣääc? ");
INSERT INTO dikNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Acie tɛ̈de! Ayeku gam lɔn bï ɣo kony rin piath Bɛ̈ny Jethu, ku abï ya tɛ̈de aya tënë ke.” ");
INSERT INTO dikNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Go akut ëbën biɛt ku piŋkë käk jäŋ gɔ̈i cï Nhialic cɔl aa looi Barnaba ku Paulo ke, kam kɔc kɔ̈k cie kɔc Itharel. ");
INSERT INTO dikNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Wën cï kek thök jam, ke Jemith jɔt rot ku bëër ëlä, “Piɛŋkë wɛ̈tdiɛ̈ wek kɔc akuɔ̈tda! ");
INSERT INTO dikNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Acï Thaimon tɛ̈t ɣo tɛ̈ cï Nhialic ye nyuɔɔth thïn lɔn ye kɔc cie kuat Itharel kacke aya, rin cï yen kɔc kɔ̈k nyaai keyiic bïk aa kacke. ");
INSERT INTO dikNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ku wël kɔc käk Nhialic tïŋ aacï rɔ̈m kek ë wëlkä alanden. Cïmën cï ye gɔ̈t athör thɛɛr wël Nhialic yic ëlä, ");
INSERT INTO dikNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Ku lueel Bɛ̈ny, ɣɛn abï dhuk, ku ɣɛn abï many Debit cï riääk bɛn jɔt nhom. Ku bɛn käkken cï riääk cɔ̈k piny bïk riɛl. ");
INSERT INTO dikNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ku këya, kɔc ëbën aabï Bɛ̈ny wïc, kɔc cie kɔc Itharel ca cɔɔl bïk aa kackiɛ̈. ");
INSERT INTO dikNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Yen ee wɛ̈t cï Bɛ̈ny lueel akan, Bɛ̈ny yen cï wɛ̈t kënë cɔl aŋic thɛɛr.’ ");
INSERT INTO dikNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Ku la Jemith tueŋ ku lueel, na ye ɣɛn, ke ɣok aacïï kɔc cie kɔc Itharel cï Nhialic dhuɔ̈k rɛ̈ɛ̈m nhïïm. ");
INSERT INTO dikNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Aŋuɛ̈ɛ̈n buk ke gät athör ku lëkku ke, bïk cïï mïth kuat miëth cï ke jakrɛc door, ku titkë röt bïk gup cïï la akɔr. Ku cïk riɛm cam ku cïk cuët rïŋ län këc teem röl bï riɛm kuër. ");
INSERT INTO dikNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Rin löŋ Mothith acï kueen run juëc yiic, ɣɔ̈n ye kɔc Itharel mat thïn akööl cïï kek ë luui yiic, ku wëlkä aaye piɔ̈ɔ̈c gɛɛth yiic ëbën.” ");
INSERT INTO dikNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Nawën ke atuuc Jethu, ku kɔcdït kek kɔc akut kɔc cï gam ëbën, mat wɛ̈t yic bïk röör abɛ̈k akut yic kuany, ku bïk ke tuɔɔc Antiök kek Paulo ku Barnaba. Gokë Judath cɔl Barthabath aya, ku Thilath kɔc theek akut rin luɔiden, kuany. ");
INSERT INTO dikNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ku gɛ̈mkë ke athör kënë tënë kɔc cï gam Antiök, “Ɣok atuuc Jethu ku kɔcdït, miɛ̈thakun, ɣok aacï miäthda tuɔ̈c miɛ̈thakua cie kuat Itharel ciëŋ gen Antiök, ku pan Thiria ku Cilicia. ");
INSERT INTO dikNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Acuk piŋ lɔn cï kɔc kɔ̈k akuɔ̈tda yic la ku rɛckë wepuɔ̈th käk yekë lueel, ku keek aa këcku ke tooc bïk käkkä aala lueel. ");
INSERT INTO dikNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Këya, ɣok aacï ɣonhïïm mat ku gamku buk kɔc kuany ku tucku ke we. Ku aabï la kek wämäthkuan nhiarku Barnaba ku Paulo, ");
INSERT INTO dikNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","cï wëiken gam bïk luui rin Jethu Krïtho. ");
INSERT INTO dikNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Wek aa tucku Judath ku Thilath, bïk we lëk wël cï gɔ̈t athör kën yic aya. ");
INSERT INTO dikNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Acï Wëi Nhialic tääu ɣopuɔ̈th bï ciɛ̈n löŋ ril dɛ̈t mɛtku ë lööŋ cï gät we kä yiic. ");
INSERT INTO dikNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ku wek aa cïï käkkä dhil loi, duɔ̈kkë ye mïth miëth yeke jakrɛc door, duɔ̈kkë riɛm cam, duɔ̈kkë cuët rïŋ län këc teem röl bï riɛm kuër, ku tiɛtkë röt bäk gup cïï la akɔr. Na luɔikë käkkä cït ëmën cï ɣok ke lɛ̈k we, ke luɔidun abï piath. Yenakan.” ");
INSERT INTO dikNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ku toockë atuuc Antiök. Nawën cïk ɣet, ke mat kɔc cï gam ëbën nhïïm ku gɛ̈mkë ke athöör. ");
INSERT INTO dikNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Wën cï kek athöör kueen ë ke mit puɔ̈th rin cï wël cï gɔ̈t athöör yic ke dɛɛt puɔ̈th. ");
INSERT INTO dikNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judath ku Thilath, kɔc ke jam nyin Nhialic aya, aacï jam apɛi kek kɔc cï gam bïk ke dɛɛt puɔ̈th ku rilkë puɔ̈th. ");
INSERT INTO dikNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Tɛ̈wën cï kek nïn nɔ̈k ke ke lony wämäthakua dhöl bïk dhuk ke puɔl gup tënë kɔc ke toc ke.  ");
INSERT INTO dikNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ku Thilath acie nhom bɛ̈n waar ku döŋ. ");
INSERT INTO dikNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paulo ku Barnaba aake cï pɛ̈i nɔ̈k Antiök, ke piööc wɛ̈t Bɛ̈ny kek kɔc juëc kɔ̈k tënë kɔc Antiök. ");
INSERT INTO dikNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Nawën cïk pɛ̈i nɔ̈k Antiök, ke Paulo yöök Barnaba, “Dhukku ciëën gɛɛth wäär yiic cï ɣok Wɛ̈t Puɔth Yam piɔ̈ɔ̈c thïn, buk wämäthakua la neem, ku buk tïŋ lɔn le kek tueŋ apath kek gamden.” ");
INSERT INTO dikNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Ku ë wïc Barnaba bï Joon Marko cath ke ke, ");
INSERT INTO dikNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ku akëc Paulo tak lɔn puɔth yen bï cath ke ke rin acï bɛ̈n dhuk Pampilia, ku cïï rɛ̈ɛ̈r ke ke bïk luɔiden thääp kedhie. ");
INSERT INTO dikNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Wɛ̈t kënë acïk tɛɛr apɛi nawën ke puɔ̈k. Ku jiël Barnaba kek Joon Marko ku geerkë Thaipruth. ");
INSERT INTO dikNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ku cɔl Paulo Thilath bï cath kek ye, ku pɛ̈l miɛ̈thakën ke dhöl bï Nhialic ke cɔl aa cath ke puɔl gup. ");
INSERT INTO dikNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ku jɔlkë la Thiria ku Cilicia kek Thilath, ke deet kɔc cï gam puɔ̈th bïk gamden muk apath. ");
INSERT INTO dikNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulo acï cath bï la Derbe ku Lithtra tɛ̈ ciëŋ Krïthian cɔl Timothï thïn. Man Timothï ëcï gam aya, ku yeen ë ye nyan kuat Itharel, ku wun ë ye Gïrïk. ");
INSERT INTO dikNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Kɔc le ɣok gam tök ëbën Lithtra ku Ikonia, aake ye ŋiɛc jam rin Timothï. ");
INSERT INTO dikNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Go Paulo Timothï cɔl aŋot rin wïc yen ye bïk cath. Ee looi këya rin aŋic kɔc Itharel ke ciëŋ Derbe ku Lithtra ëbën lɔn ye wun Timothï Gïrïk, kuat cie ŋoot. ");
INSERT INTO dikNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Tɛ̈wën ye kek jäl gen ku lek gen, aake lööŋ cï atuuc Jethu ku kɔcdït tɔ̈ Jeruthalem guiir tɛ̈t kɔc cï gam, ku lëkkë ke bïk aa luui cït tɛ̈ wïc atuuc Jethu ku kɔcdït tɔ̈ Jeruthalem ye thïn. ");
INSERT INTO dikNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Këya, kɔc akut kɔc cï gam aacï cök puɔ̈th bïk gamden cïï war, ku kɔc cï gam aacï röt aa juak akölaköl. ");
INSERT INTO dikNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Paulo ku Thilath aacï Prigia ku Galatia bar yic, rin cï Wëi Nhialic ye nyuɔ̈th ke bïk Wɛ̈t Puɔth Yam cïï piööc ë bɛ̈ɛ̈i Athia kä yiic. ");
INSERT INTO dikNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Tɛ̈wën cï kek aken Mithia dööt, ke wïckë bïk la pan cɔl Bithinia, ku keek aacï Wëi Nhialic nyuääth bïk cïï tëk thïn. ");
INSERT INTO dikNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Gokë Mithia bar yic ku lek Troath. ");
INSERT INTO dikNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ku ë wɛ̈ɛ̈r kënë Paulo acï këdäŋ tïŋ këcït raan Mathedonia ke kääc yenhom ku lɛ̈ŋ. “Bäär yïn Paulo Mathedonia ba ɣo bɛ̈n kony.” ");
INSERT INTO dikNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Wën cï Paulo nyuɔ̈th ë kënë, goku röt guiir buk la Mathedonia, rin acuk ŋic lɔn cï Nhialic ɣo cɔɔl buk Wɛ̈t Puɔth Yam la piɔ̈ɔ̈c tënë kɔc Mathedonia. ");
INSERT INTO dikNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Goku jäl Troath ë riäi ku gërku buk teem Thamodhraki, naɣɔn nhiäk dɛ̈ɛ̈t ɣo la Nipolith. ");
INSERT INTO dikNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ku jiëlku Nipolith ku lok Pilipi gen tueŋ ye kaŋ thiɔɔk tɛ̈ le kɔc Mathedonia, ku yen ë ye gen rëër kɔc Roma thïn. Ku näkku nïn juëc geeu. ");
INSERT INTO dikNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Nawën aköl cïï kɔc Itharel ë luui ke ɣo jiël geeu, ku lok wäryɔu tɛ̈ yeku tak lɔn ye kɔc Itharel kenhïïm mat thïn bïk röök. Ku nyuucku piiny ku jiɛɛmku tënë diäär ke cï kenhïïm mat thïn aya. ");
INSERT INTO dikNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Kam kɔc cï wɛ̈lkua piŋ ë kɔc ke tɔ̈ thïn yiic, ee tiŋ gen Thiatira cɔl Lidia, ku ë ye ɣɔɔc wei alɛ̈th mïthiɔ̈ɔ̈ŋ ril ɣɔ̈nyden yic apɛi. Lidia ë ye Nhialic door, ku ëcï Nhialic cök puɔ̈u bï wɛ̈t lueel Paulo piŋ. ");
INSERT INTO dikNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Wën cï ye gäm lɔ̈kwëi kek kɔc ciëŋ baai kek ye, ke cɔl ɣo ku lëk ɣo, “Bäk, rɛ̈ɛ̈rkë paandiɛ̈, tɛ̈ cï wek ye gam lɔn cï ɣɛn gam ayic.” Ku lɛ̈ŋ ɣo buk la baai. ");
INSERT INTO dikNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Naɣɔn akäl tök, tɛ̈wën le ɣok tɛ̈ ye kɔc la röök thïn, ke ɣo räm kek nyan alony la guɔ̈p jɔŋ ye cɔl alëk kɔc kë bï rot looi. Ku yeen ëcï wëëu juëc apɛi bɛ̈ɛ̈i tënë kɔcken cï ye loony. ");
INSERT INTO dikNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Nawën ke buɔth Paulo ku ɣo ëbën ke loi duɔɔt, “Kɔckä aa lui rin Nhialic Madhɔl. Aa yïn lëk tɛ̈ bï Nhialic yï kuɔny thïn.” ");
INSERT INTO dikNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ku looi këya nïn juëc, agut bï Paulo puɔ̈u riääk, ku wel yenhom ku lëk jɔŋ tɔ̈ nya guɔ̈p, “Rin Jethu Krïtho bäär bei ë nya guɔ̈p!” Ee kaam wën, ke jɔŋrac jiël yeguɔ̈p. ");
INSERT INTO dikNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Nawën le kɔc cï yeen loony tïŋ, ke nyan alony cïn wëëu ye bɛn bɛ̈ɛ̈i tënë ke, gokë Paulo dɔm ku Thilath ku thelkë ke luk yic. ");
INSERT INTO dikNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ku ɣɛ̈thkë ke bäny nhïïm ku luelkë, “Röörkä aa kɔc Itharel, ku keek aa loi aliääp gɛnda. ");
INSERT INTO dikNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Aa ɣook piɔ̈ɔ̈c buk käk liu ciɛɛŋda ku lɔ̈ɔ̈ŋkua yiic, aa looi. Ɣok aa kuat Roma. Këya, ɣok aacïï dhil luui käk yekë lɛ̈k ɣo buk ke looi.” ");
INSERT INTO dikNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ku mɛt thän awën kääc luk kɔ̈u wɛ̈tden yic ku biɛ̈kkë ke, ku ret bäny alɛ̈th Paulo ku Thilath yiic kekɔ̈th, ku cɔlkë ke aa that. ");
INSERT INTO dikNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Wën cï apuruuk Paulo ku Thilath that ku biɛ̈kkë ke apɛi, ku riitkë ke ɣön mɛ̈c, ku yöök bɛ̈ny apuruuk ë tïït kɔc cï mac, bï ke der rin bï kek cïï kat. ");
INSERT INTO dikNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Nawën piŋ apuruuk ë wɛ̈t kënë, ke riitkë ɣön tɔ̈ ciëën ku rekkë kecök, ku mɛckë ke gurgurdït thiek kɔ̈u. ");
INSERT INTO dikNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Nawën tɛ̈cït wɛ̈ɛ̈r ciɛl yic, ke Paulo ku Thilath aake rɔ̈ɔ̈k ku ketkë waak door kek Nhialic, ku kɔc kɔ̈k ke cï mac kek keek aake pïŋ. ");
INSERT INTO dikNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Kaam awën ke piny yiɛ̈ɛ̈k rot apɛi, ku yiɛ̈ɛ̈k tɛ̈wën cï ɣön mɛ̈c buth thïn aya. Nyin yic tɛ̈wën ke ɣööt ŋany kethook, ku däk luɔ̈ŋ werwer kecök. ");
INSERT INTO dikNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Go bɛ̈ny apuruuk wën tit ɣöt thok rot puur ku tïŋ ɣööt ke ŋaany thook, ku tɛk lɔn cï kɔc cï mac röt kual, go palde miëët bei, ku wïc bï rot nɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Go Paulo rɛ̈l apɛi, “Duk rot näk! Ɣok aatɔ̈ tɛ̈n ëbën!” ");
INSERT INTO dikNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Go bɛ̈ny apuruuk mac cɔɔl, ku riŋ ɣöt ku wïïk Paulo ku Thilath cök ke lɛth. ");
INSERT INTO dikNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Nawën ke wɛt nhïïm aɣeer ku thiëëc ke, “Wek bäny, yeŋö ba looi bï ɣa kony?” ");
INSERT INTO dikNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Gokë lueel, “Gam wɛ̈t Bɛ̈ny Jethu, ke yïn akony wek kacku.” ");
INSERT INTO dikNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Nawën ke jɔl wɛ̈t Bɛ̈ny Jethu piɔ̈ɔ̈c tënë ye ku tënë kɔc kɔ̈k tɔ̈ paande ëbën. ");
INSERT INTO dikNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ku ë wɛ̈ɛ̈r kënë, ke Paulo ku Thilath nyɛɛi bɛ̈ny apuruuk wën ke bï tɛ̈tɔ̈ɔ̈kken la lɔɔk yiic ku dër keyiic, ku muɔc nhom nyin yic kek kacke ëbën. ");
INSERT INTO dikNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ku ɣɛ̈th Paulo ku Thilath paande ku gɛ̈m ke miëth. Ku jɔl puɔ̈u miɛt kek kacke rin cï yen wɛ̈t Nhialic jal gam. ");
INSERT INTO dikNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Naɣɔn nhiäk ke bäny geeu toc bäny apuruuk, “Lak, lëkkë bɛ̈ny apuruuk tït ɣön mɛ̈c bï Paulo ku Thilath lony.” ");
INSERT INTO dikNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Go bɛ̈ny apuruuk tït lëk Paulo, “Bäny aacï wɛ̈t tooc riɛnkun bï we lony. Këya, wek aacï puɔ̈l bäk jäl ke cïn awuɔ̈c yïk we.” ");
INSERT INTO dikNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Go Paulo lueel tënë bɛ̈ny apuruuk, “Ɣok aa këc ɣäth luk yic, ku ɣok aacï bäny cɔl athat thɛ̈i nhom ku mac ɣo, ku ɣok aa kɔc Roma! Ku ëmën, awïckë buk jäl ɣo cïï ŋic? Acie tɛ̈de! Kek bäny nhïïm, aa dhil bɛ̈n tɛ̈n bïk ɣo bɛ̈n luɔ̈ny bei.” ");
INSERT INTO dikNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Go bäny apuruuk wɛ̈t cï Paulo ku Thilath lɛ̈k ke la kuany yic tënë bäny geeu. Nawën piŋkë lɔn ye Paulo ku Thilath kɔc Roma, gokë riɔ̈ɔ̈c. ");
INSERT INTO dikNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ku lek bïk ke la lɔ̈ŋ, bïk wɛ̈t päl piny tënë ke, ku bïïkë ke bei ɣön mɛ̈c ku lëkkë ke bïk jäl geeu. ");
INSERT INTO dikNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Go Paulo ku Thilath jäl ku lek pan Lidia. Ku matkë kenhïïm thïn kek kɔc cï gam, ku jiɛɛmkë tënë ke wël deet kek kepuɔ̈th ku jiëlkë. ");
INSERT INTO dikNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paulo ku Thilath aacï tëëk gɛɛth karou yiic, gen Ampipoli ku Apolonia, ku jɔlkë bɛ̈n Thethalonika tɛ̈ rëër tɛ̈n ye kɔc Itharel kenhïïm mat thïn bïk röök. ");
INSERT INTO dikNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Go Paulo, cïmënden thɛɛr, la tɛ̈ ye kɔc Itharel kenhïïm mat thïn, ku akööl yiic kadiäk, akööl cïï kɔc Itharel ye luui, ke Paulo jɔl käk cï gɔ̈t athör thɛɛr wël Nhialic yic aa tɛɛr kek kɔc. ");
INSERT INTO dikNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ku nyuth ke kë cï gɔ̈t athör thɛɛr wël Nhialic yic, ee lɔn bï Jethu Krïtho raan cï Nhialic tooc abï dhiɛl gum, ku jɔt rot thou yic. Ku lueel Paulo ëlä, “Jethu jiɛɛm ɣɛn riɛnke tënë we ëmën, yen acï Nhialic lɔc ku dɔɔc.” ");
INSERT INTO dikNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Go kɔc kɔ̈k käk cï Paulo lueel yök ke ye yith, ku mɛ̈tkë röt Paulo ku Thilath, ku yen lan kɔc juëc Gïrïk Nhialic door aya, ku diäär kɔ̈k kɔcdït. ");
INSERT INTO dikNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ku kɔc Itharel aake cï tiɛɛl dɔm rin cï kɔc juëc wɛ̈t Paulo gam, ku kuutkë kɔc aliääp dhɔ̈l yiic, ku matkë keyiic ku loikë duɔɔt, ku mɛkkë pan Jathon ku wïckë Paulo ku Thilath ɣööt yiic bïk ke bɛ̈ɛ̈i aɣeer tënë kɔc. ");
INSERT INTO dikNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Nawën cïk ke yök, gokë Jathon ku kɔc kɔ̈k cï gam thɛl tënë kɔcdït geeu ke loi duɔɔt ëlä, “Röörkä aacä liääp looi gɛɛth juëc yiic, ku ëmën aacï bɛ̈n gɛnda. ");
INSERT INTO dikNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ku aacï Jathon nyuɔ̈ɔ̈c paande. Keek aacï lööŋ bɛ̈nyŋaknhom Roma dhɔ̈l yiic, ku luelkë ka la bɛ̈nyŋaknhom dɛ̈t yam cɔl Jethu.” ");
INSERT INTO dikNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ku wëlken kä, aacï thändït gɛu ku bäny liääp nhïïm. ");
INSERT INTO dikNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ku jɔl bäny Jathon ku wämäth kɔ̈k awën cɔl aa tɛ̈ɛ̈u wëëu piny bïk röt waar, ku pälkë ke bïk jäl. ");
INSERT INTO dikNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Tɛ̈wën cï piny cuɔl, ke kɔc cï gam cɔl Paulo ku Thilath aa la Beria. Nawën cïk ɣet, ke la tɛ̈ ye kɔc Itharel mat thïn. ");
INSERT INTO dikNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Aye kɔc Itharel tɔ̈ Beria nhiaar bïk wɛ̈t Paulo piŋ tënë kɔc Thethalonika. Ku aake wël Nhialic kueen akölaköl, bïk tïŋ lɔn ye käk ye Paulo lueel yith. ");
INSERT INTO dikNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Kɔc juëc aacï wɛ̈t Jethu ye Paulo lɛ̈k kɔc bɛ̈n gam. Ku diäär juëc kɔcdït Gïrïk, ku röör juëc Gïrïk aacï wɛ̈t ye Paulo lueel bɛ̈n gam aya. ");
INSERT INTO dikNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Nawën le kɔc Itharel tɔ̈ Thethalonika piŋ lɔn cï Paulo wɛ̈t Nhialic la piɔ̈ɔ̈c Beria aya, gokë bɛ̈n ku kuutkë kɔc thook bïk aliääp looi. ");
INSERT INTO dikNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Tɛ̈wën nyin yic, ke kɔc cï gam cɔl Paulo ajiël kek kɔc kɔ̈k bïk la wath thok, ku dɔ̈ŋ Thilath ku Timothï Beria. ");
INSERT INTO dikNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ku kɔc awën ruɛc Paulo aacï bɛ̈n ger kek ye, bïk ɣet Athen. Ku dhukkë Beria kek athön Paulo tënë Thilath ku Timothï, bïk röt lac mät ye. ");
INSERT INTO dikNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Tɛ̈wën tiit Paulo Thilath ku Timothï Athen, ee këc puɔ̈u la yum wën tïŋ yen gɛu ke cï thiäŋ yïïk ye kek jakken door thïn. ");
INSERT INTO dikNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Go jäl a teer kek kɔc Itharel, ku kɔc wuɔ̈t kɔ̈k Nhialic door tɛ̈ ye kɔc Itharel mat thïn kek thän dɛ̈t guëër tɛ̈ ye kɔc kenhïïm mat thïn geeu, bïk wëlkä bɛ̈n piŋ. ");
INSERT INTO dikNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Go kɔc kɔ̈k piööc Epikuria ku Ithtɔk jam kek ye aya. Ku lueel kɔc kɔ̈k, “Yeŋö wïc raan kënë këc piöc, bï lueel?” Ku ben kɔc kɔ̈k lueel, “Yen ë ciɛ̈t jam rin jak kucku.” Ee luelkë këya rin Paulo ë piɔ̈ɔ̈c rin Jethu, ku lɔn ye kɔc röt jɔt thou yic. ");
INSERT INTO dikNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Gokë Paulo cɔɔl amat yic, amat ë rɔ̈m gɔn cɔl Ariöpakuth nhom ku luelkë, “Awïcku buk piɔ̈ɔ̈cdun yam ye lueel kënë ŋic. ");
INSERT INTO dikNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Kɔ̈k yeku piŋ ke ye lueel, aacï thöŋ kek käk cuk kaŋ piŋ, ku awïcku buk wɛ̈tden yic, ŋic.” ");
INSERT INTO dikNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Rin anhiɛɛr kɔc ke dhiëth Athen, ku thäi kɔ̈k la rëër thïn, bïk kɔc aa lɛ̈k wël yam cïk piŋ, ku piŋkë käk yam tënë kɔc kɔ̈k aya.) ");
INSERT INTO dikNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Go Paulo rot jɔt ku kɛ̈ɛ̈c amat Ariöpakuth nhom ku lueel. “Kɔc Athen! Aya tïŋ käjuëc yiic lɔn ye wek jak juëc theek. ");
INSERT INTO dikNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Rin tɛ̈ ciɛth ɣɛn gɛndun yic, ku daai käkkun yakë door, ɣɛn ë yïk yök aya ke cï gɔ̈t nhom këlä, ‘Tënë Nhialic kuc.’ Yen kë yakë door kënë, yen ë kënë ya lɛ̈k we, ku acäk ye ŋic. ");
INSERT INTO dikNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Nhialic cï piny cak ku käk tɔ̈ thïn ëbën, yen ë Bɛ̈ny nhial ku piny. Ku acie ceŋ luëk cï buth yiic bï ye aa door thïn. ");
INSERT INTO dikNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ku yeen aya, acie wïc kɔ̈k bï luɔ̈i ye, rin ë yen atɔ̈ pïïr yecin, ku ë yen këriëëc ëbën wïc raan, gäm raan. ");
INSERT INTO dikNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Nhialic acï raan tök kaŋ cak tueŋ, ku raan töŋ kënë yen abïï thäi bei thïn ëbën, ku jɔl ke aa thiëi pinynhom ëbën bï kek ceŋ thïn. Ku tueŋ këc yen ke cak, ëcï guiir, ye nɛn, ku ye tɛ̈nɛn bï kek cieŋ thïn. ");
INSERT INTO dikNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Acï cak rin bï kek ye wïc bïk ŋic, tɛ̈dë abïk yök tɛ̈ wïc kek ye. Ku ë yic Nhialic acï mec kek ɣo. ");
INSERT INTO dikNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Cïmën cï raan dɛ̈t ye lueel ëlä thɛɛr, ‘Yen acɔl ɣo aa pïïr, ku ciëŋku cïmën kënë!’ Ku acï kɔckun wak lueel aya ëlä, ‘Ɣok aa miɛ̈thke aya.’ ");
INSERT INTO dikNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Cïmën ye ɣok mïth Nhialic, acuk dhil tak lɔn Nhialic acït mïläŋ, ayï alel cï atët guaŋ bï thɔ̈ŋ Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Akëc Nhialic kuɛ̈ɛ̈c nhom, bï kɔc tɛ̈m awuɔ̈c wäär këc ye ŋic, ku ëmën ë kɔc lɛ̈k pinynhom ëbën, bïk kärɛc yekë looi puɔ̈l. ");
INSERT INTO dikNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Rin acï guiir bï la aköl töŋ bï raan cï lɔc luk looi tënë kuat raan ëbën pinynhom. Ku yen acï nyuɔ̈th raan ëbën lɔn bï yen kënë looi, jön cï yen raan bï luk looi jɔt raŋ yic!” ");
INSERT INTO dikNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Tɛ̈wën piŋ kek Paulo ke jam jön rot thou yic, ke bui kɔc kɔ̈k, ku lueel kɔc kɔ̈k ëlä, “Awïcku, ba kënë bɛn ber yic, buk piŋ.” ");
INSERT INTO dikNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Go Paulo jäl amat yic. ");
INSERT INTO dikNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ku mɛ̈t röör kɔ̈k röt ye, ku gamkë wɛ̈t cï lueel, kam ë röörkä ë ye raan kɔc amat cɔl Diönithiöth, ku tiŋ cɔl Damarith, ku kɔc kɔ̈k ke cï gam aake tɔ̈ thïn aya. ");
INSERT INTO dikNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Wën cï Paulo jam amat yic, ke jiël Athen ku ler Korinth. ");
INSERT INTO dikNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ku rɛ̈m thïn kek mony Itharel cɔl Akuila, dhiëth Pontuth, ke puɔc bɛ̈n Italia kek Prithkila tiɛŋde, rin cï Klaudiöth, Bɛ̈nyŋaknhom kɔc Itharel cuɔp wei Roma. Go Paulo la bï ke la neem. ");
INSERT INTO dikNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Ku rëër ku luui ke ke, wën cï yen ke yök ke ye cuëc alɛ̈th dhïl ye guɔ̈t piny cït duɛ̈l, ku ɣɔɔckë ke cïmën yen aya. ");
INSERT INTO dikNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ku ë ye jam apɛi tɛ̈ ye kɔc Itharel mat thïn akööl cïï kɔc ye luui yiic, bï ke lɛ̈k yith, rin bï kɔc Itharel ku kɔc Gïrïk wɛ̈t Nhialic gam aya. ");
INSERT INTO dikNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Nawën la Thilath ku Timothï bɛ̈n Mathedonia, ke Paulo päl käkken ke ye looi ku yïk yenhom piööc wɛ̈t Jethu, ku tët kɔc Itharel lɔn Jethu yen aluaŋ bï Nhialic tuɔ̈ɔ̈c pinynhom. ");
INSERT INTO dikNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Nawën ke jɔ̈nykë ku luelkë kärɛc riɛnke, go yecök teŋ ku lëk ke, “Na cäk määr bäk Nhialic kuc, ka wek aabï röt gɔ̈k ë röt! Acïn raan bäk gɔ̈k. Ëmën wek aba puɔ̈l ku la wɛ̈t Jethu piɔ̈ɔ̈c tënë kɔc cie kɔc Itharel.” ");
INSERT INTO dikNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Goke jal nyääŋ piny, ku ler pan raan cie raan Itharel Nhialic door cɔl Titiöth Juthtuth bï la rëër thïn. Ku pan Titiöth ë thiääk kek tɛ̈n amat kɔc Itharel. ");
INSERT INTO dikNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Raandït tɛ̈n amat cɔl Krïthputh ëcï wɛ̈t Nhialic gam, yeen ku kacke ëbën ku kɔc kɔ̈k Korinth aake cï wɛ̈t Jethu piŋ ku gamkë, ku muɔc Paulo kenhïïm. ");
INSERT INTO dikNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Naɣɔn wɛ̈ɛ̈r tök, ke Paulo tïŋ këdäŋ këcït nyuɔ̈th, ku lëk Nhialic ye ëlä, “Duk riɔ̈c ë kɔckä, lɔɔr tueŋ yï jam tënë ke, ku duk dhɔ̈r kë loi yic, ");
INSERT INTO dikNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","rin ɣɛn arɛ̈ɛ̈r kek yï. Acïn raan bï ye lëu bï yiëk tɛ̈tök, rin kɔc juëc rɛ̈ɛ̈r ë tɛ̈n aa kackiɛ̈.” ");
INSERT INTO dikNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Go Paulo rëër geeu ruɔ̈ɔ̈n tök ku abak, ke piööc kɔc wɛ̈t bɔ̈ tënë Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Nawën cï Galio bɛ̈nyŋaknhom Roma, jal looi bï ya bɛ̈nydït pan Gïrïk, ke kɔc Itharel mat keyiic ku dɔmkë Paulo ku ɣɛ̈thkë luk yic tënë Galio. ");
INSERT INTO dikNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ku luelkë tënë ye, “Mony kënë, awïc kɔc bïk Nhialic aa door dhöl cïï thääny kek lɔ̈ŋda.” ");
INSERT INTO dikNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Tɛ̈wën wïc Paulo ye bï jam, ke luel Galio tënë kɔc Itharel ëlä, “Na ye awuɔ̈c yen cï looi, ŋuɔ̈t ɣɛn acä yïc päl piny ku piɛŋ wɛ̈tdun. ");
INSERT INTO dikNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ku ëmën nɛ̈k ater we ë path wɛ̈t rin ku wël ku lɔ̈ɔ̈ŋkun, wek aa dhil këdun lueel wepɛ̈c. Ɣɛn acie bɛ̈ny käk cït käkkä.” ");
INSERT INTO dikNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ku cɔl ke aa nyɛɛi luk yic. ");
INSERT INTO dikNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Gokë Thotheneth, raandït tɛ̈n amat dɔm ku biɛ̈kkë luk yic. Ku kënë akëc Galio kuɛ̈ɛ̈c nhom. ");
INSERT INTO dikNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulo ëcï nïn juëc nɔ̈k Korinth kek kɔc cï gam, nawën ë ke tɔ̈ɔ̈ŋ ke, ku ler riäi yic kek Prithkila ku Akuila, riän la Thiria. Ku wën këc kek guɔ la wïïr bïk ger, ee cï kuëëŋ Kankëria tënë Nhialic, ku cɔl rot amut nhom. ");
INSERT INTO dikNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Nawën ë ke ɣet Epethuth, tɛ̈ cï Paulo Prithkila ku Akuila bɛ̈n nyääŋ thïn. Ku ler tɛ̈n amat kɔc Itharel, ku jiɛɛm apɛi ke ke. ");
INSERT INTO dikNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ku pëën kɔc amat bï lɔ̈k rɛ̈ɛ̈r kek ke, go cïï gam. ");
INSERT INTO dikNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ku lëk ke ëlä wën jiël yen, “Na ye yen kë wïc Nhialic, ke ɣɛn abï dhuk tënë we.” Ku ler riäi yic ku jiëlkë Epethuth. ");
INSERT INTO dikNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Wën le yen ɣëët Cetharia, ke la Jeruthalem ku muɔ̈th akut kɔc cï gam, ku jɔl la Antiök. ");
INSERT INTO dikNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Nawën cï nïn nɔ̈k Antiök ke jiël ku ler wuɔ̈t Galatia ku Prigia ku deet kɔc cï gam thïn ëbën puɔ̈th. ");
INSERT INTO dikNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Go raan Itharel cɔl Apolo, dhiëth Alekdhändria pan Ijip, bɛ̈n Epethuth. Yen ë ŋic wël thɛɛr cï gɔ̈t athör thɛɛr wël Nhialic yic, ku ë ŋic jam apɛi. ");
INSERT INTO dikNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ku ëcï piɔ̈ɔ̈c dhël Bɛ̈ny ku nhiɛɛr ke ku jiɛɛm ku piɔ̈ɔ̈c kɔc yith rin Jethu. Ku käkkä aake pëk thook miɔ̈c nhom wäär ye Joon looi. ");
INSERT INTO dikNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ee ye këriëëc ëbën ŋiɛ̈c teet yiic apath tɛ̈n amat ke cïï riɔ̈c. Tɛ̈wën piŋ Prithkila ku Akuila wëlkä, gokë ɣäth panden ku tëtkë dhöl cï Nhialic nyooth tënë kɔc. ");
INSERT INTO dikNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Ku jɔl Apolo tak bï la pan Gïrïk, go kɔc cï gam Epethuth kony ku gɛ̈tkë athöör tënë kɔc cï gam tɔ̈ pan Gïrïk, ku lëkkë ke bïk ŋiɛc lor apath tɛ̈ ɣeet yen. Ku yeen acï bɛ̈n aa raan cï kɔc cï Nhialic kuɔny dhɛ̈ɛ̈ŋde bïk gam, bɛ̈n kony apɛi wën ɣeet yen. ");
INSERT INTO dikNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Rin wëlken ril cï lueel aacï yen kɔc Itharel thöl nhïïm amat yic, ku nyuth ke yith wël thɛɛr Nhialic cï gɔ̈t yiic lɔn Jethu yen ë raan cï lɔc ku dɔc. ");
INSERT INTO dikNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Tɛ̈wën rëër Apolo Korinth, ke Paulo jɔl cath bï wuɔ̈t kuany yiic ku ɣeet Epethuth. Tɛ̈ɛ̈n, acï kɔc kɔ̈k abiöth yök thïn ");
INSERT INTO dikNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ku thiëëc ke, “Cï Wëi Nhialic lööny wegup wën cï wek gam?” Gokë dhuɔ̈k ye, “Akëcku cak piŋ lɔn tɔ̈ Wëi Nhialic thïn.” ");
INSERT INTO dikNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Go Paulo ke thiëëc, “Na ye këya, ye miɔ̈c nhom ŋö cäk yök?” Gokë bɛ̈ɛ̈r, “Ee miɔ̈c nhom ye Joon gäm kɔc.” ");
INSERT INTO dikNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Go Paulo lëk ke, “Miɔ̈c ye Joon kɔc muɔɔc nhïïm aye looi tënë kɔc cï kepuɔ̈th wɛl wei kärɛc yiic. Ku lëk kɔc Itharel wek aa dhil Jethu raan bï lɔ̈k bɛ̈n ɣacök gam.” ");
INSERT INTO dikNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Wën piŋ kek ë wɛ̈t kënë, ke muɔc nhïïm bïk jäl aa kɔc buɔth Jethu. ");
INSERT INTO dikNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ku tɛ̈ɛ̈u Paulo yecin kenhïïm, ku bɔ̈ Wëi Nhialic kegup, ku jiɛɛmkë thok kɔ̈k, ku jɔlkë wɛ̈t cï bɛ̈n tënë Nhialic aa luɛɛl. ");
INSERT INTO dikNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ku röör aake cït thiäär ku rou ëbën. ");
INSERT INTO dikNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Ku tɛ̈n pɛ̈i kadiäk, Paulo ë ye la tɛ̈ ye kɔc Itharel mat thïn, ku jiɛɛm ke ke apɛi lɔn ye wɛ̈t ye lueel rin bääny Nhialic yic. ");
INSERT INTO dikNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Go kɔc kɔ̈k nhïïm riɛl keyiic ku cïk gɛ̈m, ku luelkë kärɛc apɛi kɔc nhïïm rin dhël pïr cï Bɛ̈ny nyooth. Go Paulo ke nyääŋ piny ku jiël kek kɔc cï gam, ku jɔlkë wɛ̈t aa jaam yic akölaköl, ɣöndït ye mony cɔl Tiranuth jam thïn tënë kɔc juëc. ");
INSERT INTO dikNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ku la Paulo tueŋ run karou ke loi kënë, abï kɔc ke rɛ̈ɛ̈r wun Athia, kɔc Itharel ku kɔc cie kɔc Itharel, wɛ̈t Bɛ̈ny piŋ. ");
INSERT INTO dikNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Nhialic ëcï Paulo cɔl aloi käk kɔc gɔ̈i këc röt kaŋ looi. ");
INSERT INTO dikNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Alanh yen tuc wuuny, ku alanh ye ceŋ tɛ̈n luɔi, aake ye ɣäth tënë kɔc tuany. Ku tɛ̈ cï ke ɣäth, aa tuaany cɔl ajiël ku jiël jakrɛc kegup aya. ");
INSERT INTO dikNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ecï kɔc kɔ̈k Itharel këc gam baai kuany yic ke ye jakrɛc cuɔp wei kɔc gup, aa them aya bïk rin Bɛ̈ny Jethu aa lueel, ku yekë jam tënë jakrɛc ëlä, “Yïn ayɔ̈ɔ̈k rin Jethu, ye Paulo jam riɛnke.” ");
INSERT INTO dikNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Wɛ̈ɛ̈t raandït käk Nhialic cɔl Ithkiba kadhorou kek aake ye kënë looi. ");
INSERT INTO dikNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Go jɔŋrac lueel tënë ke, “Ɣɛn aŋic Jethu, ku ɣɛn acï wɛ̈t Paulo piŋ ku week yakë tak ye wek yï ŋa?” ");
INSERT INTO dikNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Go raan tɔ̈ jɔŋrac yeguɔ̈p thuɛɛt kegup ku yïk ke tɛ̈töök, ku ret aläthken yiic kekɔ̈th. Nawën ke kat paande kecïn kɔ̈th alɛ̈th, ke kuër gup aya. ");
INSERT INTO dikNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Kɔc Itharel ëbën ku kɔc cie kɔc Itharel ke ciëŋ Epethuth, aake cï kë cï raan la guɔ̈p jɔŋrac looi piŋ, gokë riɔ̈ɔ̈c apɛi, ku jɔl rin Bɛ̈ny Jethu aa leec apɛi. ");
INSERT INTO dikNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Go kɔc juëc cï gam bɛ̈n ku lekkë käkken rɛc cïk looi kɔc nhïïm. ");
INSERT INTO dikNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Go acɔ̈r juëc luui ë käkkä athɔ̈rken bɛ̈ɛ̈i ku cuänykë ke ke dɛɛi raan ëbën. Ku matkë wëëu ke ɣɔɔc athör yiic gokë aa wëëu juëc apɛi. ");
INSERT INTO dikNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Käjuëc ril cï röt looikä aacï kɔc cök puɔ̈th apɛi, ku jɔl wɛ̈t Bɛ̈ny la tueŋ ke thiëi piny, ku gɛ̈m kɔc juëc. ");
INSERT INTO dikNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Wën cï käkkä röt looi, ke bɔ̈ Paulo puɔ̈u bï la Jeruthalem ke tëk Mathedonia ku Gïrïk, ku lueel, “Tɛ̈ cï ɣɛn la ë bɛ̈ɛ̈ikä yiic ke ɣɛn abï dhiɛl la Roma aya.” ");
INSERT INTO dikNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Go Timothï ku Eratuth kɔcken ye kony tuɔɔc Mathedonia, ku lɔ̈k rɛ̈ɛ̈r Athia. ");
INSERT INTO dikNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Tɛ̈wën rëër yen Athia yen ëcï aliämdït rot looi Epethuth rin dhël pïïr cï Bɛ̈ny nyooth. ");
INSERT INTO dikNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Mony thɔ̈th mïlɔ̈ɔ̈ŋ cɔl Demetriöth ë tɔ̈ thïn. Ku yeen ë ye käŋ thɔ̈ɔ̈th mïläŋ këcït luëk kor ye ke jɔŋ tik cɔl Artemith door thïn. Ku kɔcken luɔi aake wëëu juëc yök ë luɔiden kënë yic. ");
INSERT INTO dikNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Go kɔcken luɔi cɔɔl ëbën, ku cɔɔl kɔc kɔ̈k mïlɔ̈ɔ̈ŋ thɔ̈ɔ̈th kecït luëk Artemith cïmënden aya, ku lëk ke, “Week, aŋiɛckë lɔn ye ɣok wëëukuan pïïr ɣok yök ë luɔi kënë yic. ");
INSERT INTO dikNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ayakë piŋ ku tiɛ̈ŋkë yen kë looi raan cɔl Paulo. Aye lueel lɔn käk ye thɔ̈ɔ̈th aacie Nhialic acïn, ku yeen acï kɔc juëc wel nhïïm Epethuth ë tɛ̈n, ku jɔl a Athia ëbën. ");
INSERT INTO dikNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Kërac abï rot looi rin kɔc aacïï bï ŋiɛc aa jam ë luɔidan kënë. Ku acie këya rot, acïn kɔc bï ye bɛn aa tak lɔn ye luaŋ jɔŋdan cɔl Artemith kë thiek yic. Ku acïn kɔc bï jɔŋdan cɔl Artemith bɛn aa theek, jɔŋdan ye raan ëbën Athia ku pinynhom, door!” ");
INSERT INTO dikNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Wën piŋ thän awën cï kenhïïm mat kë cï Demetriöth lueel, ke tuuc kegup ku riëëkkë puɔ̈th apɛi, ku loikë wuɔɔu ku yekë lueel ëlä, “Artemith Epethuth adït apɛi alanden!” ");
INSERT INTO dikNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ku jɔl kɔc juëc gɛu yic ëbën, duɔɔt looi. Ku dɔm thän awën Gaiöth ku Arithtarkuth, kɔc pan Mathedonia ke cath kek Paulo, ku riiŋkë ke tɛ̈ ye kɔc geeu kenhïïm mat thïn. ");
INSERT INTO dikNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Go Paulo wïc bï la jam kek kɔc wën cï kenhïïm mat. Go kɔc cï gam pëën bï cïï la. ");
INSERT INTO dikNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ku kɔc kɔ̈k ŋiɛ̈c kek ye kɔcdït geeu yiic aake cï wɛ̈t tooc aya bïk lɛ̈k, bï cïï bɔ̈ bï bɛ̈n jam kɔc nhïïm. ");
INSERT INTO dikNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Tɛ̈wën kɔc ke cï bɛ̈n amat yic aake loi duɔɔt. Ku ye kɔc kɔ̈k jam wël cïï thöŋ kek wël kɔc kɔ̈k, rin kɔc juëc keyiic aake cɔk kënë mɛt kɔc kenhïïm kuc. ");
INSERT INTO dikNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Go kɔc kɔ̈k tak lɔn ë yen Alekdhändɛ̈r yen cï kënë looi, rin cï kɔc Itharel ye cɔl ala kɔc nhïïm tueŋ. Go Alekdhändɛ̈r yecin jɔt bï kɔc cɔl abit, ku bï tɛ̈t ke lɔn cïï kek cök tɔ̈ ë wɛ̈t kënë yic. ");
INSERT INTO dikNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Nawën lek Alekdhändɛ̈r ŋic lɔn ë yen raan Itharel, ë ke ŋot ke loi duɔɔt ku ŋuɔt yekë kiit yic, “Artemith Epethuth aril apɛi alanden.” ");
INSERT INTO dikNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Nawën ke jɔl raandït bɛ̈ny geeu lëu bï kɔc duɔ̈m thook piny ku lueel, “Kɔc Epethuth aŋic raan ëbën, lɔn yen gen Epethuth yen ala riɛl bï luaŋ Artemith tiit, ku jɔl a kuɔ̈r yath cï löny nhial. ");
INSERT INTO dikNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Acïn raan dhäl ë käkkä. Këya, pälkë röt piny, ku duɔ̈kkë lui luɔi mïth. ");
INSERT INTO dikNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Wek aacï röörkä bɛ̈ɛ̈i ë tɛ̈n, cɔk alɔn cïn yen kë yaath cï nyaai luɛɛk, ku lɔn cïn yen kärɛc cïk luɛɛl jaŋda guɔ̈p aya. ");
INSERT INTO dikNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Na la Dimitriöth kek kɔcken luɔi raan yekë gaany, ka akööl ye kɔc luk aatɔ̈ thïn ku bäny aa rëër thïn, alëukë bïk raan wïckë la gaany akölë. ");
INSERT INTO dikNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ku na le këdɛ̈ɛ̈t ŋuɔ̈t wiɛ̈ckë, ka bï luk amatdït yic. ");
INSERT INTO dikNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Rin alëu bäny Roma kuan mac ɣo bïk lueel lɔn cï ɣok aliääp looi rin kë cï rot looi akölë, rin acïn raan lëu ye bï lueel, lɔn ala wɛ̈t puɔth looi aliääp, ku acïn wɛ̈t yic lëuku buk lueel aya rin aliäm kënë.” ");
INSERT INTO dikNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Wën cï yen wɛ̈t kënë lueel, ke däk amat nhom. ");
INSERT INTO dikNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Tɛ̈wën cï kɔc ke wïc Paulo bïk nɔ̈k röt päl piny, go Paulo kɔc cï gam cɔɔl ku mɛ̈t ke ke, ku lëk ke wël deet yen kepuɔ̈th ku jɔl ke tɔ̈ɔ̈ŋ, ku jiël bï la Mathedonia. ");
INSERT INTO dikNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ku jɔl cath wuɔ̈t juëc yiic ku lëk kɔc cï gam wël juëc deet yen kepuɔ̈th bɛ̈ɛ̈i cï ke tëëk yiic. Ku jɔl la wun Gïrïk. ");
INSERT INTO dikNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Ku rëër thïn pɛ̈i kadiäk. Tɛ̈wën guiir yen rot bï la Thiria, go ŋic lɔn cï kɔc Itharel ye thiɛ̈n dhël yic bïk nɔ̈k. Go tak ku dhuk ciëën bï la tëëk Mathedonia bï jäl la Thiria. ");
INSERT INTO dikNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Kɔc cï yen bɛ̈n ruac aayï Thopater, wën Piruth, raan pan Beria, ku Arithtarkuth, ku Thekunduth kɔc Thethalonika, ku Gaiöth, raan Derbe, ku Tikikuth ku Tropimuth, kɔc wun Athia, ku jɔl aa Timothï. ");
INSERT INTO dikNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Keek aacï la tueŋ ku lek ɣa tiit ɣok kɔc kɔ̈k ke cath kek ɣa Troath. ");
INSERT INTO dikNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ku ɣok aacï cath riäi jäl Pilipi ke ɣo cï Yan Ayum cin yic luɔu kaŋ cam. Nawën nïn kadhiëc cök, goku ke jal la dööt Troath, ku ë yen tɛ̈ cï ɣok nïn kadhorou bɛ̈n nɔ̈k thïn. ");
INSERT INTO dikNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Naɣɔn thëëi aköl nin dätem, ke ɣok aa ɣo cï ɣonhïïm kut ku buk ayup bany yic ku camku ɣok kɔc cï gam. Ku jɔl Paulo jam, ku le tueŋ ke jiëëm kɔc nhïïm ɣet wɛ̈ɛ̈r ciɛl yic, rin ë bï jäl ɣɔn nhiäk. ");
INSERT INTO dikNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ku mɛ̈c juëc aake dɛ̈p ɣön nhial tɛ̈wën mɛ̈t ɣok thïn. ");
INSERT INTO dikNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Ku mony riënythii cɔl Eyutikuth ëcï nyuc aluïït nyin. Nawën cï jam Paulo kɔ̈u bɛ̈r apɛi, go nïn nɔ̈k abï nin, ku lööny piny aluïït nyin aɣeer. Ku ɣöt ëcï buth ke cööc nhom arak diäk. Nawën lek jɔt ke yökkë ke cï thou. ");
INSERT INTO dikNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Go Paulo bɛ̈n ku cuɛt rot yekɔ̈u ku pɛɛt yic. Ku lëk kɔc, “Duɔ̈kkë riɔ̈c, aŋot pïïr!” ");
INSERT INTO dikNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ku dhuk nhial, ku le röök ku banykë ayup ku camkë. Nawën cï jam ke ke apɛi agut bï piny bak, ke jiël. ");
INSERT INTO dikNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ku ɣɛ̈thkë riënythii wën baai ke pïïr, ke cï puɔ̈th miɛt apɛi. ");
INSERT INTO dikNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Ɣok aacï la tueŋ buk la riäi yic, ku ger ɣo buk la Athoth tɛ̈n yen bï Paulo la mɛt riäi yic thïn. Ku ëcï lɛ̈k ɣo ku buk looi këya, rin ë wïc bï la Athoth yecök. ");
INSERT INTO dikNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Nawën le rɔ̈m ke ɣo Athoth, go cath kek ɣo riäi ku lokku Mitilene. ");
INSERT INTO dikNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ku tëmku ë riäi ku ɣeetku Kayoth ɣɔn nhiäk dɛ̈t. Na aköl dɛ̈ɛ̈t ke ɣo la Thamoth, nawën ben bak goku ɣet Miletuth. ");
INSERT INTO dikNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Ku ëcï Paulo tak ku bï Epethuth waan thok, rin cï yen ye wïc bï gääu wun Athia. Ku ë ban yekɔ̈u rin ë wïc bï them apɛi bï ɣet Jeruthalem aköl looi Yan Ayum cïn yic luɔu. ");
INSERT INTO dikNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Tɛ̈wën cï Paulo ɣet Miletuth go thok tuɔɔc tënë kɔc Epethuth, ku bï kɔcdït kek bäny kɔc cï gam rɔ̈m kek ye. ");
INSERT INTO dikNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Tɛ̈wën cï kek ɣëët go lɛ̈k ke, “Wek aa ŋic luɔidiɛ̈, ku tɛ̈ cï ɣɛn cieŋ thïn kek we aköl tööŋ ɣɔn ɣëët ɣɛn wun Athia. ");
INSERT INTO dikNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ɣɛn akëc rot looi ke ɣa ye raan nhiam. Ku ɣɛn ɣa loi luɔi ɣa ya aluaŋ Nhialic. Ku ɣɛn ɣa ye rëër ke ɣa dhiau puɔ̈u wɛ̈t pïr ril yic ye kɔc Itharel ye wïc bïk ɣɛn nɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ɣɛn acïn kë ca muɔ̈ny we, kën yen bï we kony tɛ̈wäär ye ɣɛn kɔc lɛ̈k, ku ya kɔc piɔ̈ɔ̈c wɛ̈t Nhialic agut bääikun yiic. ");
INSERT INTO dikNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Kɔc Itharel ku kɔc cie kɔc Itharel, aa ca ke aa lɛ̈k alanden ku bïk kepuɔ̈th dhuɔ̈k ciëën ku gamkë wɛ̈t Bänyda Jethu. ");
INSERT INTO dikNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Ku ëmën, rin theek ɣɛn wɛ̈t cï Wëi Nhialic lɛ̈k ɣa, ke ɣɛn adhuk Jeruthalem, ku akuɔ̈c yeŋö bï rot la looi tënë ɣa tɛ̈tui. ");
INSERT INTO dikNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Kën yen ŋiɛc ë kë cï Wëi Nhialic thɔ̈n ɣɛn gɛɛth ca tëëk yiic ë lɔn bï ɣa mac, ku kärɛc bï luɔ̈i ɣa gɛɛth yiic ëbën aatit ɣa. ");
INSERT INTO dikNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ku piɛ̈rdiɛ̈ acä ye kuɛ̈ɛ̈c nhom lɔn ye yen këpath tënë ɣɛn, ku ë rin wïc ɣɛn ye ku ba luɔi yen cï Bɛ̈ny Jethu yiëk ɣa ba thöl, yen lɔn bï ɣɛn ye aa lɛ̈k kɔc, yen thoŋ path tɛ̈nhiɛɛr Nhialic kɔc thïn. ");
INSERT INTO dikNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Ɣɛn acï cath kamkun, ke ɣa jam wɛ̈t bääny Nhialic. Ku aŋiɛc ëmën lɔn cïn yen raan dɛ̈t kamkun bä bɛn tïŋ. ");
INSERT INTO dikNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Kën yen alɛ̈k we ku bäk muk wenhïïm akölë, tɛ̈ le yen raan bï dhël ca nyooth lɔ̈k puɔ̈l bï määr, ka cïï ɣɛn bï gɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Rin acïn këdɛ̈t ca moony kɛ̈c lɛ̈k we ye kë wïc Nhialic ëbën ku bï looi. ");
INSERT INTO dikNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Tiɛtkë röt apath ku tiɛtkë kɔc cï Wëi Nhialic we looi bäk aa kɔc mɛc ke. Calkë röt aaye abiök kɔc cï wɛ̈t Nhialic gam, kɔc cï looi bïk aa kacke thon Wënde. ");
INSERT INTO dikNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Aŋiɛc na la jäl ke kɔc ater Nhialic, cït gal cï wäth aabï bɛ̈n kamkun, ku keek acïn raan tök kam kɔc cï gam bïk puɔ̈l. ");
INSERT INTO dikNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Nïnkui bï bɛ̈n kɔc kɔ̈k akuɔ̈tdun yic aabï lueth aa lueel na lëukë ka wëŋ kɔc cï gam. ");
INSERT INTO dikNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Tiɛtkë wenhïïm, ku duɔ̈kkë nhïïm mär, aŋiɛc wek aca piɔ̈ɔ̈c pïu nyin aköl ku wɛ̈ɛ̈r tɛ̈n run kadiäk. ");
INSERT INTO dikNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Ku ëmën wek aca päl Nhialic bï we tiit dhëëŋden nhiɛɛr yen we. Yen ala riɛl bï we dɔɔc bäk käpath yök, käpuɔth kek ye yiëk kɔcken cï lɔc. ");
INSERT INTO dikNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Acïn käpuɔth raan dɛ̈t cïmën luŋ thith, ku mïläŋ tɔ̈c, ku alɛ̈th ca tuɔ̈ɔ̈r nyïn. ");
INSERT INTO dikNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Aŋiɛckë wepɛ̈c lɔn ke luɔi ca looi, cï ɣɛn ke wëëu juëc yök thïn aa kek cï ɣɛn käkkiɛ̈ ku käk kɔc rɛ̈ɛ̈r kek ɣɛn ɣɔɔc. ");
INSERT INTO dikNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Aca nyuɔ̈th we käjuëc yiic ëbën, lɔn nadë raan luui apɛi yen ë kɔc niɔp kony, ku wël cï Bɛ̈ny Jethu lueel aake muɔ̈k ɣanhom ɣɔn cï yen ye lueel ëlä, ‘Raan kɔc muɔɔc ë yen puɔ̈u miɛt apɛi tën lɔn bï raan dɛ̈t ye muɔɔc!’ ” ");
INSERT INTO dikNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Tɛ̈wën cï Paulo thök jam, gokë kenhiɔl guɔ̈t piny ku röökkë Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Keek aacï dhiau tɛ̈wën ye kek Paulo paat yic, ku yekë ciɛm ke tɔ̈ŋkë. ");
INSERT INTO dikNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Keek aake rɛc puɔ̈th wɛ̈t cï yen ye lueel ëlä, wek aacï ɣa bï bɛn tïŋ. Ku jɔlkë ruac riäi yic. ");
INSERT INTO dikNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Ɣok aacï kɔc cï gam ke bɔ̈ Epethuth tɔ̈ɔ̈ŋ ku jiëlku. Tɛ̈wën cï ɣok wär teem riäi, goku ɣet tɛ̈ cɔl Koth. Naɣɔn aköl dɛ̈ɛ̈të ke ɣo ɣet pan cɔl Rodeth, ku jiëlku thïn ku lokku tɛ̈ cɔl Patara. ");
INSERT INTO dikNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ee tɛ̈ɛ̈n ɣok aacï riän la Ponicia bɛ̈n yök thïn, goku kɛɛc thïn ku ger ɣo. ");
INSERT INTO dikNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Ɣok aacï bɛ̈n ɣet tɛ̈ ye ɣok Thaipruth tïŋ thïn, ku jɔl riäi cath ke Thaipruth tɔ̈ köŋ cam ke ɣo la Thiria. Ɣok aacï bɛ̈n la piny riäi yic Tire, ku ë yen tɛ̈n bï käk ke tɔ̈ riäi yic la jat piny thïn. ");
INSERT INTO dikNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ɣok aacï kɔc kɔ̈k cï gam bɛ̈n yök Tire, goku rëër ke ke nïn kadhorou. Keek kɔc Tire aake cï Wëi Nhialic yɔ̈ɔ̈k ku bïk Paulo lɛ̈k ku bï cïï la Jeruthalem. ");
INSERT INTO dikNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Na la nïnkuan ke buk nɔ̈k ke ke Tire thök, goku jäl. Keek ëbën agut diäär ku miɛ̈thken aacï ɣo bɛ̈n ruac. Nawën ɣeetku wath thok ke ɣo gut ɣonhiɔl piny agör thok ku röökku Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Ku tɔ̈ŋku ke ku lok riäi yic ku dhukkë baai. ");
INSERT INTO dikNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Ɣok aacï ger jäl Tire agut Ptolimiath, tɛ̈ yen cï ɣok kɔckuan cï gam bɛ̈n la muɔ̈ɔ̈th thïn ku rëërku ke ke niɛ̈n tök. ");
INSERT INTO dikNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Na aköl dɛ̈ɛ̈të ke ɣo jiël ku ɣeetku Cetharia. Tɛ̈ɛ̈në, ɣok aacï bɛ̈n la pan Pilipo raan kɔc piɔ̈ɔ̈c Wɛ̈t Puɔth Yam Nhialic, ku rëërku kek ye. Yeen ë ye raan töŋ kɔc kadhorou ke cï kuany Jeruthalem. ");
INSERT INTO dikNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Yeen ë la nyïïr kaŋuan këc thiaak ku keek aake cït kɔc käk Nhialic tïŋ. ");
INSERT INTO dikNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Tɛ̈wën cï ɣok nïn nɔ̈k paande ke raan käk Nhialic tïŋ cɔl Agabuth bɔ̈ wun Judia, ");
INSERT INTO dikNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","bï ɣo bɛ̈n tïŋ. Ku lööm gɔm ye Paulo yeyic duut, ku duut yecök ku yecin ku lueel, kë cï Wëi Nhialic lɛ̈k ɣa akïn, raan la gɔm kënë abï kɔc Itharel la der Jeruthalem cït ëmën cï ɣɛn ye nyuɔɔth, ku abïk thɔ̈n kɔc cie kɔc Itharel. ");
INSERT INTO dikNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Tɛ̈wën piŋ ɣok ë wɛ̈t kënë, ɣook ku jɔl aa kɔc ë pan wën, goku Paulo lɔ̈ŋ bï cïï la Jeruthalem. ");
INSERT INTO dikNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Go dhuɔ̈k ɣo ëlä, “Yeŋö luɔikë ëmën dhiɛɛu wek këlä, bäk ɣa cɔl akɔ̈c puɔ̈u? Acie lɔn bï ɣɛn la der Jeruthalem yetök yen ca gam, awiëc aya ku ba la thou thïn rin Bɛ̈ny Jethu.” ");
INSERT INTO dikNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Ee këcku lëu buk dɔk, goku puɔ̈l, ku jɔlku lueel, “Pɛ̈lku Nhialic ku bï kë cï tak looi.” ");
INSERT INTO dikNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Tɛ̈wën cï ɣok nin ë tɛ̈ɛ̈n, ke ɣo jɔl röt guiir ku jiëlku buk la Jeruthalem. ");
INSERT INTO dikNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Kɔc kɔ̈k kam abiöth Cetharia aacï ɣo bɛ̈n ruac, ku ɣɛ̈thkë ɣo pan raan bï ɣok la rëër thïn cɔl Mɛnthon, raan Thaipruth, ku ë ye raan tööŋ kam kɔc tueŋ ke kɔŋ wɛ̈t Jethu gam. ");
INSERT INTO dikNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Nawën ɣeetku Jeruthalem go kɔc cï gam ɣo lor ke mit puɔ̈th. ");
INSERT INTO dikNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Na la aköl dɛ̈ɛ̈të bɛ̈n, goku la ɣok Paulo buk la jam kek Jemith, ku kɔcdït käk Nhialic aake tɔ̈ thïn. ");
INSERT INTO dikNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Keek aacï Paulo jäl muɔ̈ɔ̈th ku jɔlke kuɛ̈ny yic käk cï looi ëbën tënë kɔc cie kɔc Itharel riɛl cï Nhialic yiëk ye. ");
INSERT INTO dikNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Nawën cïk käk cï Paulo kuany yiic piŋ, gokë Nhialic leec. Ku jɔlkë lɛ̈k ye, “Alëu ba tïŋ ëmën yïn wämääthda. Kɔc juëc apɛidït ke ye kɔc Itharel aacï gam, ku keek aa thek löŋ Mothith apɛidït. ");
INSERT INTO dikNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ku acïk piŋ lɔn ye yïn kɔc Itharel tɔ̈ wuɔ̈t kɔ̈k yiic piɔ̈ɔ̈c ku bïk Löŋ Mothith puɔ̈l. Ku aca aa lɛ̈k ke bïk miɛ̈thken cïï ye ŋoot ku pälkë tɛ̈cït tɛ̈ ye kɔc Itharel cieŋ thïn. ");
INSERT INTO dikNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Abïk dhiɛl piŋ yen lɔn cï yïn ɣëët. Yeŋö buk looi ëmën? ");
INSERT INTO dikNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Aŋuɛ̈ɛ̈n ba kë buk lɛ̈k yï looi. Ala kɔc kaŋuan ë tɛ̈n cï kuëëŋ. ");
INSERT INTO dikNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Cath ke ke, ku mät rot kɔc bï kegup wuɔ̈ɔ̈ny wei, bäk röt kɔ̈c ë tök ku tääu wɛ̈ɛ̈uken piny, wëëu käk kek bï kek röt kɔ̈c, ku keek aabï kenhïïm muut. Këya, abïk jal ŋic ëbën lɔn wël cï lɛ̈k ke riɛnku aa lueth, ku yïnhom yïn adhil ceŋ tɛ̈cït tɛ̈ ye löŋ Mothith ye luɛɛl thïn. ");
INSERT INTO dikNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ku kɔc cie kɔc Itharel cï gam, aa cuk tuɔ̈c athöör buk lɛ̈k ke bïk mïïth cï ke jakrɛc door cïï ben ya cam, ku jɔl aa riɛm ku län dɛ̈t cï dec, ku titkë röt bïk gup cïï la akɔr.” ");
INSERT INTO dikNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Go Paulo rot mät röör wën, naɣɔn nhiäk ke köc rot ke ke. Ku jɔl la luaŋ Nhialic, ku lëk kɔc tɛ̈ bï nïn köc thök, tɛ̈n yen bï köc jäl a looi tënë raan tök keyiic ëbën. ");
INSERT INTO dikNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Nawën cï nïn kadhorou thiɔ̈k ke thök, go kɔc kɔ̈k Itharel ke bɔ̈ wun Athia Paulo tïŋ luaŋ Nhialic. Gokë kɔc rac nhïïm ëbën ku dɔmkë Paulo. ");
INSERT INTO dikNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Ku luelkë ke cï keröt jɔt, “Kɔc Itharel! Kuɔnykë ɣo! Yen raan kën, ee yen piny kuany yic ke piööc kɔc ku ye lueel kɔc Itharel aa kɔc rɛc, ku ë löŋ Mothith, ku jɔl a luaŋ Nhialic kënë yɔ̈ɔ̈ŋ yiic. Ku ëmën acï kɔc cie kɔc Itharel bɛ̈ɛ̈i luaŋ Nhialic aya, ku bïk bɛ̈n yiëk yic buɔ̈ɔ̈l yen tɛ̈n athɛ̈ɛ̈k Nhialic!” ");
INSERT INTO dikNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(Ee luelkë yen kën, wɛ̈t cï kek Tropimuth raan Epethuth tïŋ ke cath kek Paulo geeu, gokë tak lɔn cï Paulo bɛ̈n kek ye luaŋ Nhialic.) ");
INSERT INTO dikNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Go aliääp thiëi kal yic ëbën, ku jɔl kɔc kat ku lek Paulo dɔm, ku thelkë aɣeer luaŋ Nhialic. Ku thiökkë kal thok nyin yic. ");
INSERT INTO dikNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Tɛ̈wën wïc kek ye bïk Paulo nɔ̈k, ke thok ëcï tuɔɔc tënë bɛ̈ny apuruuk Roma lɔn nadë ke kɔc ëbën Jeruthalem aa loi ariɛɛr. ");
INSERT INTO dikNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Go bɛ̈ny apuruuk lööny dhöl nyin yic kek bäny kɔ̈k apuruuk ku apuruuk, ku riŋkë tɛ̈n tɔ̈ yɔ̈ɔ̈m thïn. Nawën tïŋ thän awën wïc Paulo bïk nɔ̈k apuruuk, gokë puɔ̈l. ");
INSERT INTO dikNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Go bäny apuruuk la tënë Paulo ku dɔmkë, ku yöökkë apuruuk bïk der cïn arëk karou. Ku jɔlkë thiëc, “Yeŋa yen monyë, ku yeŋö cï looi?” ");
INSERT INTO dikNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Go kɔc ke tɔ̈ yɔ̈ɔ̈m yic wël cïï thöŋ aa lueel. Ku jɔl aliääp rot looi agut bï bäny apuruuk ciɛ̈n kë detkë, kë cï rot looi yic. Gokë apuruuk yɔ̈ɔ̈k bïk Paulo kuaath tɛ̈den rëër kek thin. ");
INSERT INTO dikNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Nawën cïk jäl cath ku rëëtkë tɛ̈thöny, ke yɔ̈ɔ̈m juak rot apɛi, go apuruuk Paulo jɔt. ");
INSERT INTO dikNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Gokë buɔɔth ku yekë kiu ëlä, “Bäk, dhilku nɔ̈k.” ");
INSERT INTO dikNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Tɛ̈wën dööt kek tɛ̈ ye apuruuk rëër thin, go Paulo lɛ̈k bɛ̈ny apuruuk, “Cï ɣa päl ku ba yï lɛ̈k wɛ̈t diɛ̈ɛ̈në?” Go bɛ̈ny apuruuk jäl thiëëc, “Ye jam thoŋ Gïrïk? ");
INSERT INTO dikNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ku yïn, cïï ye raan Ijip wäär cï raan tim kaŋuan muk dhɛ̈ŋ wat nhïïm roor, ku wïc ba thɔ̈r kek kɔc mac baai?” ");
INSERT INTO dikNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Go Paulo dhuk nhom, “Ɣɛn ë raan Itharel, dhiëth pan cɔl Tarthuth wun Cilicia, ɣɛn ë raan gen dïït ŋic. Päl ɣa ku ba jam tënë kɔc.” ");
INSERT INTO dikNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Ke yeen acï bɛ̈ny apuruuk bɛ̈n puɔ̈l ku bï kɔc jääm nhïïm, ku jɔl Paulo kɛɛc nhial tɛ̈thöny ku nyooth yecin bï kɔc biɛt. Nawën cïk biɛt, go Paulo jam tënë ke thuɔŋden. ");
INSERT INTO dikNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Kɔckiɛ̈n dït ku wek wämäthkiɛ̈ ku wek wärkua, piɛŋkë apath ɣɛn acïn kërɛɛc ca looi nɛ̈k ɣa.” ");
INSERT INTO dikNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Nawën piŋkë ke jam thuɔŋden, gokë biɛt, abï piny la dïl ku jɔl Paulo la tueŋ ke jam, ");
INSERT INTO dikNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Ɣɛn ë raan Itharel, dhiëth Tarthuth wun Cilicia, ku ɣɛn ɣa dït Jeruthalem tɛ̈n ku ë Gamaliel yen acä piɔ̈ɔ̈c. Ɣɛn acï piɔ̈ɔ̈c tɛ̈ bï ɣɛn lööŋ wärkuan dït thɛɛk thïn, cïmëndun wek kɔc tɔ̈ tɛ̈n akölë. ");
INSERT INTO dikNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ɣɛn acï kɔc ke buɔth dhël kën yic cɔl agum. Ɣɛn acï röör ku diäär cɔl amac. ");
INSERT INTO dikNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Raandït käk Nhialic ku kɔc akut luk ëbën alëukë ku bïk lueel lɔn nadë ke yic yen kë ya lueel. Keek aacä yiëk athör ku ba ke la yiëk kɔckuan Itharel tɔ̈ Damathkuth. Ke ɣɛn acï kɔc cï gam bɛ̈n la dɔm ku rɛk kecin, ku kuɛ̈ɛ̈th ke ciëën Jeruthalem rin bï ke bɛ̈n tɛ̈m awuɔ̈c.” ");
INSERT INTO dikNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Ɣɔn akɔ̈l ciɛl yic ke ɣa cath, ɣa cï thiɔ̈k kek Damathkuth, ke këcït mac la biliny nhial ku go ɣa guɔ gɔ̈ɔ̈l piny. ");
INSERT INTO dikNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ku wiɛ̈ɛ̈k piny ku piɛŋ röl raan ke jam ku lëk ɣa, ‘Thawul! Thawul! Ë rin ŋö cɔl yïn ɣa agum?’ ");
INSERT INTO dikNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Guɔ thiëc, ‘Ye yïn ŋa Bɛ̈ny?’ Go lɛ̈k ɣa, ‘Ee ɣɛn Jethu raan Nadharet, ë rin ŋö cɔl yïn ɣa agum.’ ");
INSERT INTO dikNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Kɔc ke cath kek ɣa aake cï mac tïŋ, ku aa këc röl jam tënë ɣa piŋ. ");
INSERT INTO dikNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Guɔ thiëc, ‘Yeŋö ba looi, Bɛ̈ny?’ Ku acï Bɛ̈ny bɛ̈n lɛ̈k ɣa, ‘Jɔt rot ku lɔɔr Damathkuth, ku yïn abï la lɛ̈k këriëëc ëbën yen cï Nhialic tak ku ba looi tënë ye.’ ");
INSERT INTO dikNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ɣɛn ɣa cï many cä bir nyin cɔɔr, go kɔc ke cath kek ɣɛn ɣa thel ku ɣɛ̈thkë ɣa Damathkuth. ");
INSERT INTO dikNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Ku mony cɔl Ananiath ë tɔ̈ Damathkuth, ku ë ye raan Nhialic door ku ë thek löŋ kɔc Itharel, ku yeen ë thekkë apɛi. ");
INSERT INTO dikNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Yeen ëcï bɛ̈n tënë ɣa, ku kɛ̈ɛ̈c ɣalɔ̈ɔ̈m ku lueel, ‘Wämääth Paulo, ba pial ba bɛn daai!’ Nyin yic nyiɛndiɛ̈ acï rot bɛ̈n liep ku tiɛ̈ŋ piny. ");
INSERT INTO dikNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ku lueel, ‘Nhialic ye wärkuan dït door acï lɔc ku ba kë wïc ba looi tënë ye ŋic, ku tïŋ Aluaŋdeen puɔth käkkä looi, ku piŋ rɔ̈lde ke jam. ");
INSERT INTO dikNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ku yïn abï ya raan ŋic ë wɛ̈t kënë, ku ba raan ëbën lɛ̈k kë ca tïŋ ku käk ca piŋ. ");
INSERT INTO dikNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ku ëmën, yeŋö ŋuɔ̈t tit? Jɔt rot ku bï yï muɔɔc nhom, ku cɔl adumuɔ̈ɔ̈mku aa lɔɔk wei, ku ba Nhialic ya rɔ̈ɔ̈k.’ ");
INSERT INTO dikNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Ku jal dhuk Jeruthalem, ku wën cï ɣɛn la ba la röök luaŋ Nhialic, ke ɣa tïŋ kecït nyuɔ̈th, ");
INSERT INTO dikNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ku tiɛ̈ŋ Jethu ke lëk ɣa, ‘Jäl ëmën Jeruthalem ku ban yïkɔ̈u, rin kɔc tɔ̈ tɛ̈n, aacï wɛ̈lkun ba ya lueel riɛnkiɛ̈ bï gam.’ ");
INSERT INTO dikNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Guɔ dhuk nhom, ‘Bɛ̈ny, aŋickë apath lɔn cï ɣɛn a la ɣɔ̈n amat Itharel yiic, ku dam kɔc cï gam ku cal ke aa that. ");
INSERT INTO dikNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ku ë ca gam wäär ku bï Ithipin nɔ̈k raan ye kɔc piɔ̈ɔ̈c wɛ̈tdu, ku ë ɣɛn ɣa cä alɛ̈th kɔc ke nɛ̈k ye lɔ̈k tiit.’ ");
INSERT INTO dikNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Go Jethu lɛ̈k ɣa, ‘Lɔɔr, rin yïn aba tuɔɔc tɛ̈mec tënë kɔc cie kɔc Itharel.’ ” ");
INSERT INTO dikNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Go kɔc wën wël Paulo piŋ, agut lɔn lueel yen wɛ̈t bï ye tuɔɔc tënë kɔc cie kɔc Itharel. Gokë duɔɔt bɛn looi, “Nyaaikë raan cït kën ë pinynhom! Näkkë! Acie raan path bï pïr!” ");
INSERT INTO dikNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ku jɔlkë aa kiu, ke ya alɛ̈thken piɛɛr nhial ku yekë liɛɛt wɛɛr nhial. ");
INSERT INTO dikNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Go bɛ̈ny apuruuk Roma apuruuk yɔ̈ɔ̈k bïk Paulo ɣäth ɣöt tɛ̈ ye apuruuk tïït thïn, ku lëkkë ke ku bïk that, rin bï Paulo wɛ̈t ye kɔc Itharel ye jääm guɔ̈p lek. ");
INSERT INTO dikNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ku wën cï kek ye der ku bïk that, go Paulo lɛ̈k bɛ̈ny apuruuk wën kääc kelɔ̈m ëlä, “Ye löŋ lueel lɔn nadë ke raan Roma that ë path ke këc ɣäth luk yic, bï la awuɔ̈c yök yeguɔ̈p?” ");
INSERT INTO dikNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Nawën piŋ bɛ̈ny apuruuk wɛ̈t cï Paulo lɛ̈k ye, go la tënë bɛ̈nydït apuruuk ku thiëëc, “Yeŋö loi? Yen monyë ë raan kɔc pan Roma.” ");
INSERT INTO dikNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Go bɛ̈nydït apuruuk la tënë Paulo ku thiëëc, “Lɛ̈k ɣa, ye raan Roma?” Go Paulo bɛ̈ɛ̈r, “Ee yic.” ");
INSERT INTO dikNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Go bɛ̈nydït apuruuk lueel, “Ɣɛn ë raan kɔc pan Roma rin cï ɣɛn wëëu juëc tääu piny tënë kɔc mac baai.” Go Paulo bɛ̈ɛ̈r, “Ɣɛn ë raan pan Roma rin ye kɔc ke dhiëth ɣa kɔc pan Roma.” ");
INSERT INTO dikNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Go kɔc kɔ̈k ke bï Paulo bɛ̈n thiëëc, dhuk ciëën ku nyiëëŋkë thïn, ku bɛ̈nydït apuruuk ëcï riɔ̈ɔ̈c wën cï yen ye ŋic lɔn ye Paulo raan kɔc Roma, ku rin cï yen ye cɔl ader aya. ");
INSERT INTO dikNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Na aköl dɛ̈ɛ̈t, wën wïc bɛ̈ny apuruuk Roma ye bï awuɔ̈c ye kɔc Itharel Paulo gaany ŋic, go Paulo cɔl adɛ̈k apuruuk cin, tɛ̈wën cï ye rek ku yöök kɔcdït käk Nhialic ku kɔc amat ëbën bïk rɔ̈m. Ku bïï Paulo kenhïïm. ");
INSERT INTO dikNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Go Paulo kɔc amat döt ku lueel, “Kackiɛ̈, acïn käk tɔ̈ ɣapuɔ̈u, ba ke thiëëc rin piɛ̈rdiɛ̈, ɣa dɛɛi Nhialic agut cït akölë.” ");
INSERT INTO dikNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ee tɛ̈ɛ̈n, ke raandït käk Nhialic cɔl Ananiath yöök kɔc wën kääc tɛ̈thiɔ̈k kek Paulo bïk buɔ̈ɔ̈k thok. ");
INSERT INTO dikNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Go Paulo lëk ye, “Nhialic abï dhiɛl buɔ̈ɔ̈k aya, yïn kë cie guɔ̈p ye yär! Yïn acï nyuc ba luk looi tënë ɣa cït tɛ̈ ye löŋ ye luɛɛl thïn, ku yïn aŋot yï cïï löŋ dhoŋ kɔ̈u rin cï yïn kɔc yɔ̈ɔ̈k bïk ɣa biäk!” ");
INSERT INTO dikNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Go kɔc thiääk kek Paulo lëk ye, “Yïn alat raandït käk Nhialic!” ");
INSERT INTO dikNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Go Paulo bɛ̈ɛ̈r, “Acä ŋic, kackiɛ̈ lɔn ye yen raandït käk Nhialic. Aye athör thɛɛr wël Nhialic lueel, ‘Yïn acï kërac dhil luɛɛl bɛ̈ny mac kacku guɔ̈p.’ ” ");
INSERT INTO dikNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Nawën tïŋ Paulo, ke kɔc kɔ̈k aa kɔc akut Thaduthï ku kɔc kɔ̈k ke ye kɔc akut Parathï, ke jam apɛi röldït tënë kɔc luk, “Kackiɛ̈! Ɣɛn ë raan akut Parathï, kɔc ke dhiëth ɣa aake kɔc akut Parathï. Ɣɛn acï bɛ̈ɛ̈i luk yic rin ye ɣɛn ye ŋɔ̈ɔ̈th lɔn bï kɔc cï thou röt jɔt aköldä!” ");
INSERT INTO dikNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Nyin yic tɛ̈wën lueel yen wɛ̈t kënë, ka agɔ̈th la nhial kam Parathï ku Thaduthï ku tekkë keyiic. ");
INSERT INTO dikNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Rin aye Thaduthï lueel lɔn cïï kɔc röt bï jɔt thou yic, ku acïn atuuc nhial ayï atïïp kɔc cï thou. Ku Parathï aa käkkä gam ëbën kadiäk. ");
INSERT INTO dikNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ku juak jam rot apɛi kam Parathï ku Thaduthï. Go kɔc kɔ̈k piööc lööŋ, ke ye kɔc akut Parathï, röt jɔt ke cï puɔ̈th riääk apɛi ku luelkë, “Acïn kërɛɛc cï yök ke cï looi! Tɛ̈dë, ke atuny nhial, yen acï diɛ̈t jam tënë ye!” ");
INSERT INTO dikNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Ku la agɔ̈th nhial apɛi, nawën ke bɛ̈ny apuruuk riɔ̈c ciɛ̈t ke bï Paulo cak nɔ̈k. Go apuruɔ̈ɔ̈kke tooc bïk Paulo la nyaai luk yic, ku ɣɛ̈thkë tɛ̈den ye kek rëër thïn. ");
INSERT INTO dikNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Naɣɔn akɔ̈u ke Bɛ̈ny kääc Paulo lɔ̈ɔ̈m ku lueel, “Dɛɛt yïpuɔ̈u! Aca nyuɔɔth Jeruthalem, lɔn ë yïn raandiɛ̈, ku yïn adhil këcït ë kënë looi Roma aya.” ");
INSERT INTO dikNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Naɣɔn nhiäk ke kɔc kɔ̈k Itharel mat kenhïïm, ku kuëëŋkë lɔn cïï kek kuat miëth bï kaŋ cam ku dëkkë tɛ̈ këc kek Paulo kaŋ nɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Kɔc ke mat kënë yic, aake thiärŋuan ku tɛ̈ kac. ");
INSERT INTO dikNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ku lek tënë kɔc käk Nhialic ku kɔcdït baai ku luelkë, “Ɣok aacï kuëëŋ apɛi ɣodhie buk cïï mïth, ɣet tɛ̈ bï ɣok Paulo kaŋ nɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Ku ëmën, week ku kɔc kɔ̈k akut, tuɔɔckë wɛ̈t tënë bɛ̈nydït apuruuk raan Roma bï Paulo bɛ̈ɛ̈i tënë we, ku luɛlkë lɔn wïc wek ye bäk kë cï looi bɛ̈n deet, ku ɣok aabï röt guiir buk nɔ̈k kë këc ɣëët wenhïïm.” ");
INSERT INTO dikNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ku wën nyankën ë Paulo ëcï wɛ̈t nɛ̈k nɛ̈r piŋ, go riŋ tɛ̈ rëër apuruuk thïn ku le wɛ̈t lɛ̈k Paulo. ");
INSERT INTO dikNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Go Paulo raan tök kam bäny apuruuk cɔɔl ku lëk ye, “Ɣäth riënythii kënë tënë bɛ̈nydït apuruuk, ala wɛ̈t wïc bï lɛ̈k ye.” ");
INSERT INTO dikNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Go bɛ̈ny apuruuk riënythii wën ɣäth tënë bɛ̈nydït apuruuk ku lueel, “Ɣɛn acï Paulo, raan mac, cɔɔl ku lëk ɣa ba riënythii kënë bɛ̈ɛ̈i tënë yï, rin ala wɛ̈t bï bɛ̈n lɛ̈k yï.” ");
INSERT INTO dikNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Go bɛ̈nydït apuruuk dɔm cin ku ɣɛ̈th tɛ̈den röt ku thiëëc, “Yeŋö wïc ba lɛ̈k ɣa?” ");
INSERT INTO dikNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Go lueel, “Acï kɔcdït Itharel mat yic bïk yï thiëëc bï Paulo ɣäth luk yic nhiäk, rin wïc kɔc luk ye bïk käk juëc cï Paulo looi la deet. ");
INSERT INTO dikNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ku duk wɛ̈tden piŋ, rin abï la raan thiärŋuan ku tɛ̈ kac bï ye thiɛ̈n bïk nɔ̈k. Aacï kuëëŋ bïk cïï mïth ku dëkkë ɣet tɛ̈ bï kek ye nɔ̈k. Ku ëmën aacï röt guiir bïk looi, ku aa tit wɛ̈tdu bïk piŋ.” ");
INSERT INTO dikNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Go bɛ̈nydït apuruuk lɛ̈k ye, “Duk ben lɛ̈k raan dɛ̈t lɔn cï yïn ɣa lɛ̈k wɛ̈t kënë.” Ku cɔl riënythii ajiël. ");
INSERT INTO dikNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Nawën ke bɛ̈nydït apuruuk cɔl bänyken apuruuk karou ku lueel, “Kuanykë apuruuk buɔt karou ku jɔl aa raan thiärdhorou cath mathiäŋ, ku raan buɔt karou ke muk tɔɔŋ bïk la Cetharia, ku rëërkë ke cï röt guiir bïk lööny dhöl ëmën akäu. ");
INSERT INTO dikNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Ku wiɛ̈ckë mïthiɔ̈ɔ̈ŋ bï Paulo ke cath, ku ɣäthkë tënë bɛ̈nydït Pelik ke cïn kërɛɛc yök ye dhël yic.” ");
INSERT INTO dikNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ku jɔl bɛ̈nydït apuruuk athör gɔ̈t ëlä, ");
INSERT INTO dikNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Ɣɛn, Klaudiöth Lithiath ɣɛn agɛ̈t athör kënë tënë yï bɛ̈nydït Pelik path apɛi. Yïn aca muɔ̈th. ");
INSERT INTO dikNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Kɔc Itharel aake cï mony kënë dɔm ku duërkë nɔ̈k. Ku aca piŋ lɔn ye yen raan Roma, guɔ la kek apuruɔ̈ɔ̈kkiɛ̈ bïk la kony. ");
INSERT INTO dikNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ë wiëc ba awuɔ̈c ye kek ye gaany ŋic, guɔ ɣäth amat yic tënë ke. ");
INSERT INTO dikNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Aca yök lɔn acïn awuɔ̈c cïï looi bï ɣok ye nɔ̈k, nadë ke macku. Ayekë gaany käk la thiääk kek lɔ̈ɔ̈ŋken. ");
INSERT INTO dikNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Nawën la lɛ̈k ɣa lɔn cï kɔc kɔ̈k Itharel wɛ̈t mat yic bïk mony kënë nɔ̈k, guɔ tak ba tuɔɔc tënë yï. Ku lɛ̈k kɔc awën gɔɔny ye, week lak tënë Bɛ̈nydan dït bäk awuɔ̈c cï monyë looi la lueel yenhom.” ");
INSERT INTO dikNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Go apuruuk këwën cï lëk ke looi. Ku nyɛɛikë Paulo ë wɛ̈ɛ̈r kën bïk ɣɛɛt Antipatrith. ");
INSERT INTO dikNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Nawën bak piny, ka apuruuk ke cath kecök dhuk Jeruthalem, ku nyiëŋkë Paulo apuruuk cath mïthiɔ̈ɔ̈ŋ bïk la kek ye. ");
INSERT INTO dikNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Ku ɣɛ̈thkë Cetharia, ku gɛmkë athöör tënë bɛ̈ny Pelik ku thönkë Paulo. ");
INSERT INTO dikNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Nawën cï bɛ̈nydït Pelik athöör kueen, ke thiëc Paulo, “Ye raan wun nɛn?” Nawën yök lɔn ë yen raan wun Cilicia ");
INSERT INTO dikNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ke lueel, “Ɣɛn abï wɛ̈tdu piŋ tɛ̈ le kɔc gɔɔny yï ɣëët.” Ku yöök apuruuk bïk Paulo la muk ku titkë pan wäär buth Antipäth Ɣërot. ");
INSERT INTO dikNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Nawën nïn kadhiëc cök ciëën, ka Ananiath raandït käk Nhialic la Cetharia kek kɔcdït kɔ̈k ë baai, ku jɔl a raan bï wɛ̈tden ŋiɛc la kuany yic luk yic cɔl Tertuluth. Ku lek bɛ̈nydït Pelik nhom ku lëkkë wëlken gɔɔny kek Paulo. ");
INSERT INTO dikNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Go Tertuluth cɔɔl ku jɔl Paulo gaany ëlä, “Yïn bɛ̈nydït! Wɛ̈t ye yïn raan ŋic kɔc mac ë yen acï ɣok rëër run juëc dɔ̈ɔ̈r yic ke cïn aliääp. Ku käjuëc pɛth ca looi kek aacï wuɔ̈nda ɣäth tueŋ. ");
INSERT INTO dikNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Käpuɔthkä aa nhiarku ke ëbën akölaköl. Ku yïn acuk leec ɣopuɔ̈th apɛi. ");
INSERT INTO dikNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Acä wïc ku ba jam apɛi, ku yïn aläŋ ba wël kuënku yï piŋ. ");
INSERT INTO dikNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Ɣok aacï mony kënë yök ke ye raan rac. Yen acä aliääp a looi kam kɔc Itharel pinynhom ëbën. Ku yeen ë bɛ̈ny kɔc akut Nadharet. ");
INSERT INTO dikNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Yeen awïc bï luaŋ Nhialic yiëk yic buɔ̈ɔ̈l. Ku yeen acuk dɔm. Acuk them buk tɛ̈m awuɔ̈c tɛ̈cït tɛ̈ ye lööŋ panda ye luɛɛl thïn. ");
INSERT INTO dikNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Ke yeen acï bɛ̈nydït apuruuk Lithiath bɛ̈n dɔ̈m bei ɣocin riɛl ku nyiɛɛi. ");
INSERT INTO dikNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ku yöök kɔc cï Paulo gaany ku bïk bɛ̈n luk yic yïnhom. Tɛ̈ thiëëc yïn ye, ka ba guɔ ŋic kek käk cï ɣok ye gaany.” ");
INSERT INTO dikNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ku mɛt kɔc Itharel thïn aya ku luelkë lɔn käk cï Paulo gaany aa yith. ");
INSERT INTO dikNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Go bɛ̈nydït baai Paulo jäl yɔ̈ɔ̈k bï jam, ku jɔl Paulo lueel ëlä, “Aŋiɛc lɔn ye yïn raan cï luk luɔ̈k run juëc ë wundaan. Ke ɣɛn amit puɔ̈u ku ba rot kony yïnhom. ");
INSERT INTO dikNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Tɛ̈ lëu yïn ye ba yic ŋic, ke wäär tɛ̈cït nïn kathiäär ku rou ëmën, yen ë le ɣɛn Jeruthalem ba la röök thïn. ");
INSERT INTO dikNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ku kɔc Itharel acïn raan cïk yök ke gɔ̈th ke ɣɛn luaŋ Nhialic. Ku keek aakëc ɣa yök ke ɣa ye kɔc rac nhïïm tɛ̈n amat Itharel. Ku jɔl aa ɣɔ̈n kɔ̈k yiic aya. ");
INSERT INTO dikNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ku keek acïk bï lëu bïk yï lɛ̈k kën ye nyuɔɔth lɔn ye käk cïk kuɛɛn ɣaguɔ̈p yith. ");
INSERT INTO dikNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Wɛ̈t lɛ̈u ba gam akïn. Ɣɛn ë Nhialic ye wärkuan dït door, door aya dhël yen yekë lueel ka cie yic. Ku ɣɛn ë këriëëc ëbën cï gɔ̈t lööŋ Mothith ku athör kɔc käk Nhialic tïŋ yiic gam. ");
INSERT INTO dikNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Ɣɛn ala ŋɔ̈th cït ŋäthden aya tënë Nhialic lɔn bï kɔc ëbën, kɔc path ku kɔc rac röt jɔt thou yic aköldä. ");
INSERT INTO dikNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ke yeen aya them ku ba kë la cök looi tënë Nhialic ku kɔc ëbën. ");
INSERT INTO dikNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Ɣɛn acï run nɔ̈k wei Jeruthalem, ke ɣɛn ɣa cï la wëëu ba ɣäth tënë kackiɛ̈ ku la rot kɔ̈c. ");
INSERT INTO dikNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Ee wën looi ɣɛn ë kënë yen ë yök kek ɣa luaŋ Nhialic ke ɣa cä guɔ̈p wuɔ̈ɔ̈ny wei kärɛc. Ee cïn yɔ̈ɔ̈m rɛ̈ɛ̈r kek ɣa, ku ë cïn aliäm cï rot looi. ");
INSERT INTO dikNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Ku kɔc Itharel ke bɔ̈ wun Athia aake rɛ̈ɛ̈r thïn. Ku keek nhïïm, ŋuɔ̈t aacï dhiɛl bɛ̈n yïnhom ku bïk kë ca wuɔ̈ɔ̈c bɛ̈n lueel. ");
INSERT INTO dikNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Na cie këya, ke ë röör rɛ̈ɛ̈r ë tɛ̈n, ka luel awuɔ̈c cïk yök ca looi wäär cï ɣa ɣäth luk yic. ");
INSERT INTO dikNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Kë ŋiɛc ë kë töŋ ca lueel ëlä ke ɣa kääc kenhïïm, ‘Ɣɛn acï bɛ̈ɛ̈i luk yic aköl wɛ̈t cï ɣɛn ye gam lɔn nadë ke kɔc cï thou aabï röt jɔt bïk pïr.’ ” ");
INSERT INTO dikNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Ku ë ŋic Pelik apath yen tɛ̈ ye dhël pïr kɔc Itharel thɛɛk thïn. Go luk puɔ̈l ku lëk ke ëlä, “Na la bɛ̈nydït apuruuk Lithiath ɣëët ke luɔ̈ŋdun aba tïŋ.” ");
INSERT INTO dikNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ku lëk bɛ̈ny apuruuk rɛ̈ɛ̈r apuruuk Paulo tiit nhïïm ku bï Paulo cïï tiit apil yic, ku yekë kɔc määth kek ye puɔ̈l bïk käkken wïc aa bɛ̈ɛ̈i tënë ye. ");
INSERT INTO dikNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Na la nïn lik thök, ke Pelik bɔ̈ kek tiɛŋde Druthila, ku ë nyan kɔc Itharel. Ku tuc Paulo bï bɛ̈ɛ̈i bï wɛ̈t ye Paulo gam rin Jethu Krïtho bɛ̈n piŋ. ");
INSERT INTO dikNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Nawën la Paulo tueŋ ke jam wɛ̈t path ku lɔn bï raan rot tiit kärɛc, ku jɔl a bɛ̈n aköl luŋdït, go Pelik riɔ̈ɔ̈c ku lueel, “Yïïn alëu ba jäl ëmën. Yïn aba bɛn cɔɔl tɛ̈ cï ɣɛn nhom bɛn lääu.” ");
INSERT INTO dikNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ku ye ŋɔ̈ɔ̈th lɔn bï Paulo ye riɔp wëëu. Ku rin ë wɛ̈t kënë acï bɛ̈n a tuɔ̈c akölaköl ku jiɛɛm kek ye. ");
INSERT INTO dikNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Na la run karou thök, ke Porkiöth Pethtuth wëër nyin bɛ̈nydït Pelik ke ye bɛ̈ny. Pelik ë wïc ku bï kɔc Itharel nhiaar, go Paulo nyääŋ mɛ̈c yic. ");
INSERT INTO dikNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Nin kadiäk cök ciëën wën cï Pethtuth ɣëët Cetharia, ke jiël thïn bï la Jeruthalem. ");
INSERT INTO dikNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Tɛ̈wën ke kɔcdït käk Nhialic ku jɔl aa bäny Itharel ke gɔɔny Paulo la tënë ye, ku lëkkë wɛ̈tden. Ku läŋkë Pethtuth, ");
INSERT INTO dikNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ku bï ke luɔ̈i kë wïckë kepuɔ̈th ku bï Paulo bɛ̈ɛ̈i Jeruthalem, rin ë cïk mat yic ku bïk Paulo nɔ̈k dhël yic. ");
INSERT INTO dikNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Go Pethtuth bɛ̈ɛ̈r, “Paulo abï rëër ke mac Cetharia, rin ɣɛn adhuk ë nïnkä. ");
INSERT INTO dikNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Calkë bänykun aa la Cetharia kek ɣa, ku bïk jäl la kuɛ̈n guɔ̈p tɛ̈ le yen awuɔ̈c cï looi.” ");
INSERT INTO dikNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Go Pethtuth nïn kabɛ̈t aduërkë aa thiäär kaŋ nɔ̈k ke ke, ku jɔl la Cetharia. Na aköl dɛ̈ɛ̈të ke la luk yic, ku jɔl apuruuk yɔ̈ɔ̈k ku bïk Paulo kuɛ̈ɛ̈th yenhom. ");
INSERT INTO dikNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Na la Paulo ɣëët, go kɔc Itharel ke bɔ̈ Jeruthalem ke kääc, ke cïk gɔ̈ɔ̈m piny, jɔɔk bïk kärɛc apɛi luɛɛl yeguɔ̈p, ku acïn kë cie nyuɔɔth lɔn ye käkkä yith. ");
INSERT INTO dikNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Go Paulo rot kony ëlä, “Ɣɛn acïn kë ca wuɔ̈ɔ̈c lööŋ kɔc Itharel yiic, ku acïn aliäm ca looi luaŋ Nhialic, agut Bɛ̈nyŋaknhom Roma acïn wɛ̈t rɛɛc ca luɛɛl yeguɔ̈p.” ");
INSERT INTO dikNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Ku wën wïc Pethtuth ye bï nyuɔ̈th kɔc Itharel lɔn nhiɛɛr yen ke, go Paulo thiëëc, “Cï lëu ba la Jeruthalem ku ba luɔ̈ŋdu la luk thïn lɔn ye käk cï kuɛɛn yïguɔ̈p yith?” ");
INSERT INTO dikNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Go Paulo lueel, “Tɛ̈ kɛ̈ɛ̈c ɣɛn thïn ë luŋ bɛ̈ny yic, ku ë yen tɛ̈ lëu ye bï luɔ̈ŋdiɛ̈ tïŋ thïn. Acïn kërɛɛc ca looi tënë kɔc Itharel, cïmën ŋic yïn ye apath. ");
INSERT INTO dikNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Na ca löŋ dhoŋ kɔ̈u, ku le kërɛɛc ca looi lëu bï ɣa tɛ̈m awuɔ̈c bï ɣa nɔ̈k, ka cä lëu ku ba thiëc bï ɣɛn puɔ̈l. Ku na cïn yiny tɔ̈ thïn käk cï kuɛɛn ɣaguɔ̈p, ka cïn raan lëu ye bä thɔ̈n ke bïk ɣa nɔ̈k. Ke yeen awiëc ku bï ya bɛ̈ny yen bï luɔ̈ŋdiɛ̈ la luk.” ");
INSERT INTO dikNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Go Pethtuth wɛ̈t cï Paulo lueel kaŋ guëëk yic kek kɔc akutden luk, ku jɔl dhuk nhom, “Wɛ̈t cï yïn ye lueel ke Bɛ̈ny Agrïpa yen abï luɔ̈ŋdu luk, ke yïn abuk tuɔ̈c ye.” ");
INSERT INTO dikNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Nin lik cök ciëën ke Bɛ̈ny Agrïpa kek Bernike bɔ̈ Cetharia bïk Pethtuth kɛ̈ny, bïk la lɛ̈k ye lɔn mit kek puɔ̈th wɛ̈t cï yen ɣëët. ");
INSERT INTO dikNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Tɛ̈wën cï kek rëër nïn juëc, ke Pethtuth jɔl wɛ̈t Paulo kuɛ̈ny yic bɛ̈ny, “Ala raan rɛ̈ɛ̈r ë tɛ̈n cï Pelik nyääŋ piny ke mac. ");
INSERT INTO dikNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Na wäär lar Jeruthalem, go raandït käk Nhialic kɔc Itharel ku bänyken, gaany tënë ɣa ku wïckë ba tɛ̈m awuɔ̈c. ");
INSERT INTO dikNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Guɔ lɛ̈k ke lɔn nadë kɔc pan Roma aacie raan cï gaany ye gam, wɛ̈t kërɛɛc cï looi ke këc kaŋ tuɔ̈ɔ̈m nhom kek kɔc cï ye gaany, ku bï rot kony awuɔ̈c cï ye gaany. ");
INSERT INTO dikNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Na wäär ca bɛ̈n ë tɛ̈n, ke ɣɛn akëc bɛ̈n gääu. Ɣɛn acï bɛ̈n la luk yic aköl bï niɛ̈nkiɛ̈ aa rou ë tɛ̈n, ku yɔ̈ɔ̈k apuruuk ku bïk ë mony kënë bɛ̈ɛ̈i ba luɔ̈ŋde tïŋ. ");
INSERT INTO dikNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Kɔc atɛrde aacï röt bɛ̈n jɔt, ku acïn kërɛɛc dïït cïk bɛ̈n kuɛɛn yeguɔ̈p tɛ̈cït tɛ̈n ye ɣɛn ye tiɛ̈ŋ thïn. ");
INSERT INTO dikNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Kë ca bɛ̈n yök ë lɔn ye kek teer kek ye tɛ̈ ye yen Nhialic duɔɔr thïn, ku jɔl aa mony dɛ̈ɛ̈t cɔl Jethu cï thou, ku yen ë mony kënë aye Paulo lueel ka pïr. ");
INSERT INTO dikNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ee cä dhal ba yic yök rin ë wëlkä, guɔ Paulo thiëëc bï la Jeruthalem ku ba luɔ̈ŋde la looi thïn. ");
INSERT INTO dikNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Go Paulo lueel ka wïc bï puɔ̈l ke tiit apuruuk agut tɛ̈ bï bɛ̈nyŋaknhom luɔ̈ŋde tïŋ. Guɔ apuruuk yɔ̈ɔ̈k ku bïk tiit agut tɛ̈ bï ɣɛn ye tuɔɔc tënë bɛ̈nyŋaknhom.” ");
INSERT INTO dikNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Go Agrïpa lɛ̈k Pethtuth, “Luŋ ë mony kënë aba luk yen ɣa nhom.” Go Pethtuth dhuk nhom ëlä, “Abï bɛ̈ɛ̈i yïnhom nhiäk.” ");
INSERT INTO dikNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Nawën bak piny ke Agrïpa ku Bernike bɔ̈ ku lor ke yai, ku luɛ̈ŋkë ɣön luk kek bänydït apuruuk ku jɔl aa bäny ë gɛu. Ku yöök Pethtuth apuruuk bïk Paulo kuɛ̈ɛ̈th luk yic alɔŋ thïn. ");
INSERT INTO dikNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Ku lueel, “Yïn bɛ̈ny Agrïpa, ku jɔl aa wek kɔc rɛ̈ɛ̈r tɛ̈n kek ɣo. Mony yen dɛɛi wek kënë ë yen raan cï kɔc Itharel rɛ̈ɛ̈r ë tɛ̈n ku jɔl aa Jeruthalem gaany tënë ɣa. Ayekë lueel ke loi duɔɔt lɔn nadë ka cïï päl ke pïr. ");
INSERT INTO dikNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ku yeen acïn awuɔ̈c ca yök cï looi lëu bï ye tɛ̈m awuɔ̈c bï nɔ̈k. Ku yeen nhom acï wïc bï ya bɛ̈ny yen luk luɔ̈ŋde, guɔ gam ku ba tuɔɔc tënë ye. ");
INSERT INTO dikNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ku ɣɛn acïn yiny puɔth ca yök ba gɔ̈t ë riɛnke tënë bɛ̈ny. Ke yeen aca bɛ̈ɛ̈i yïnhom, ku ë yïn bɛ̈ny Agrïpa, rin ba wɛ̈tde wïc yic, rin ku bï la kë jäl gɔ̈t. ");
INSERT INTO dikNT_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Aya tïŋ lɔn cïï yen path ku bï raan cï mac tooc ke cïn kën wën cï rot deet ye nyuɔɔth, kek käk cï ye gaany.” ");
INSERT INTO dikNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Go Agrïpa Paulo yɔ̈ɔ̈k, “Yïn aca puɔ̈l ku ba jam ba rot kony.” Go Paulo yecin nyuɔɔth bï kɔc biɛt ku jɔl jam ëlä bï rot kony. ");
INSERT INTO dikNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Bɛ̈ny Agrïpa! Ɣɛn ë rot yök aköl kënë ke ɣa mit guɔ̈p rin bï ɣɛn rot kony yïnhom käk cï kɔc Itharel ɣa gaany ëbën. ");
INSERT INTO dikNT_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Kënë adhil a yic alanden rin yïïn aŋic apath, yen tɛ̈ ye kɔc Itharel cieŋ thïn, ku käk ye kek wääc thïn. Yïn aba lɔ̈ŋ ëmën ku ba yïguɔ̈p päl piny ku ba wɛ̈lkiɛ̈ piŋ. ");
INSERT INTO dikNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Kɔc Itharel ëbën aŋickë yen tɛ̈n pïïr ɣɛn thïn tɛ̈ɣɔn koor ɣɛn. Aŋickë tɛ̈ cï ɣɛn piɛ̈rdiɛ̈ jaak thïn ɣɔn tueŋ panda ku jɔl a Jeruthalem. ");
INSERT INTO dikNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Aŋickë akölaköl, ku acïk bï dhɔ̈l lɔn nadë ke ɣɛn acï kaŋ cieŋ ke ɣa ye raan akut Parathï kɔc ke muk lööŋ Nhialic cök apɛi. ");
INSERT INTO dikNT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ku ëmën ɣɛn a kääc luk yic ë tɛ̈n rin ye ɣɛn wɛ̈t cï Nhialic lɛ̈k wärkuan dït ŋɔ̈ɔ̈th, ");
INSERT INTO dikNT_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","kën yen ye kuat kackua kathiäär ku rou ŋɔ̈ɔ̈th ka bïk yök, tɛ̈ ye kek Nhialic door aköl ku wɛ̈ɛ̈r. Ku ë rin ŋɔ̈th kënë, yïn Bɛ̈nydït, yen acï kɔc Itharel ɣa gaany! ");
INSERT INTO dikNT_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Yeŋö ye wek ye yök wek kɔc Itharel ke ril yic bäk gam lɔn ye Nhialic raan cï thou jɔt bei thou yic? ");
INSERT INTO dikNT_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Aca them yen ɣɛn ku ba këriëëc ëbën looi, käk bï rin Jethu raan Nadharet rac guɔ̈p. ");
INSERT INTO dikNT_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Yen ë kën aca looi Jeruthalem. Ɣɛn ɣa ye bɛ̈nydït käk Nhialic yiëk riɛl ku ba kɔc juëc cï wɛ̈t Jethu gam aa dɔm ku mac ke. Ku aca ya gam aya, yen lɔn nɛ̈k kɔc cï tɛ̈m awuɔ̈c bï ke tɛ̈m thou. ");
INSERT INTO dikNT_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Aaca cɔl aaye tɛ̈m awuɔ̈c arak juëc ɣɔ̈n amat kɔc Itharel yiic, ku aca them ba ke cɔl abaŋ bïk wɛ̈t Jethu puɔ̈l, ku riääk puɔ̈u apɛi tënë ke, agut ba ke aa luɔɔp wuɔ̈t kɔ̈k yiic ku cal ke agum apɛi. ");
INSERT INTO dikNT_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Ee rin ë wɛ̈t kënë yen ë ler ɣɛn Damathkuth ke ɣa cï raandït käk Nhialic yiëk riɛl. ");
INSERT INTO dikNT_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Nawën akɔ̈l ciɛl yic, Bɛ̈nydït, ke ɣa ŋoot dhël yic, ke ɣa tïŋ many ɣer apɛi, wär akɔ̈l, ke ruel nhial ke cä gɔ̈ɔ̈m piny kek kɔc ke cath kek ɣa. ");
INSERT INTO dikNT_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Ku wïïkku piny ëbën, ku piɛŋ röl ke ye lɛ̈k ɣa thuɔŋdiɛ̈, ‘Thawul, Thawul! Yeŋö cɔl yïn ɣa agum? Yïn acï rot baŋ, rin ye yïn ye wïc ku ba këcït këdhie ye akaja looi, kë ye yen wai ye raan la ye ye yup ke kuɛɛth, wɛc ciëën.’ ");
INSERT INTO dikNT_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Guɔ thiëëc, ‘Ye yïn ŋa Bɛ̈ny?’ Go Bɛ̈ny lueel, ‘Ee ɣɛn Jethu, raan ca cɔl agum. ");
INSERT INTO dikNT_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Ke yeen jɔt rot ku kääc cɔ̈kku. Ɣɛn acï rot nyuɔ̈th yï, rin yïn aca lɔc ku ba ya aluaŋdiɛ̈, yïn abï kɔc kɔ̈k lɛ̈k kë ca tïŋ tënë ɣa akölë, ku kë ba nyuɔ̈th yï aköldä. ");
INSERT INTO dikNT_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Yïn aba tiit bï ciɛ̈n kërɛɛc yï yök kɔc Itharel ku kɔc cie kɔc Itharel cin, kɔc bï ɣɛn yï tuɔɔc thïn. ");
INSERT INTO dikNT_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Keek aaba piɔ̈ɔ̈c bïk käŋ ŋic, ku bïk luɔi kärɛc puɔ̈l, ku jiëlkë riɛl jɔŋrac yic ku lek tënë Nhialic, rin gäm bï kek wɛ̈tdiɛ̈ gam, yen aabï kärɛc cïk looi päl piny ku tɛ̈ɛ̈u ke kam kɔc cï Nhialic lɔc.’ ");
INSERT INTO dikNT_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Këya, Bɛ̈ny Agrïpa, ɣɛn akëc wɛ̈t kë ca tïŋ nhial cït nyuɔ̈th dhɔ̈l yic. ");
INSERT INTO dikNT_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Wäär tueŋ Damathkuth ku Jeruthalem, ku jɔl aa wuɔ̈t kɔc Itharel yiic ëbën, ku kam kɔc cie kɔc Itharel, aake ya lɛ̈k lɔn bïk luɔi kärɛc puɔ̈l ku dhukkë Nhialic, ku yekë luui käpath ye nyooth lɔn cï kek muɔ̈l kärɛc. ");
INSERT INTO dikNT_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Ee rin ë wɛ̈t kënë, yen aa dɔm kɔc Itharel ɣa ke ɣa tɔ̈ kal luaŋ Nhialic, ku wïckë bïk ɣa nɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ku agut cï aköl kënë Nhialic acä kony, ku ë wɛ̈t kën, yen akɛ̈ɛ̈c ɣɛn ë tɛ̈n ku ba kë ŋiɛc lɛ̈k raan ëbën, kɔckor ku kɔcdït. Käk ya lueel ka bï röt looi aa thöŋ kek käk ye kɔc käk Nhialic tïŋ ku Mothith lueel, ");
INSERT INTO dikNT_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","lɔn nadë Raan cï lɔc ku dɔc abï gum, ku ë yen bï rot kaŋ jɔt thou yic, ku ë yen abï kɔc Itharel ku kɔc cie kɔc Itharel lɛ̈k wɛ̈t bï kɔc kuɔ̈ny bei kärɛc yiic.” ");
INSERT INTO dikNT_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Tɛ̈wën jiɛɛm Paulo ke kony rot ë wëlkä, go Pethtuth rɛ̈l, “Paulo! Yïn acï muɔ̈l. Piöc cï yïn piöc acï cɔl amuɔ̈l!” ");
INSERT INTO dikNT_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Go Paulo bɛ̈ɛ̈r, “Bɛ̈nydït! Ɣɛn akëc muɔ̈l. Wël ya lueel aa yith cïn yic muɔ̈l. ");
INSERT INTO dikNT_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Bɛ̈ny Agrïpa! Alɛ̈u ku ba jam tënë yï ke ɣa cïï riɔ̈c, rin yïn aŋic käkkä ëbën. Aŋiɛc alanden lɔn nadë ke keek aaca lɛ̈k yï ëbën rin kënë acie kë cïï thiaan, aa käk ŋic jäŋ ëbën. ");
INSERT INTO dikNT_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Bɛ̈ny Agrïpa! Cï wël kɔc käk Nhialic tïŋ ye gam? Aŋiɛc lɔn ye yïn ke gam!” ");
INSERT INTO dikNT_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Go Agrïpa lɛ̈k Paulo, “Ye yök yïpuɔ̈u ë kaam thïn lɔn bï yïn ɣa wel ba ya Krïthian?” ");
INSERT INTO dikNT_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Go Paulo bɛ̈ɛ̈r, “Na cɔk aa kaamkoor ku kaamdït, rɔ̈ɔ̈kdiɛ̈ tënë Nhialic ë lɔn bï yïn ku kɔc kɔ̈k piŋ käk luɛɛl ke aköl röt wel bïk ciɛ̈t ɣa, ku acie rin bï ke mac.” ");
INSERT INTO dikNT_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Go bɛ̈ny ku Pethtuth ku Bernike, ku kɔc kɔ̈k ke cï nyuc luk yic röt jɔt, ");
INSERT INTO dikNT_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ku wën cï kek jäl aacï jal aa jam kamken, ëlä, “Acïn kë cï ë mony kënë looi, kë lëu bï ye cɔl anäk ku mac aya.” ");
INSERT INTO dikNT_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Ku jɔl Agrïpa lɛ̈k Pethtuth, “Yen ë mony kënë ŋuɔ̈t acï lony, ke rin cï yen ye wïc ku bï ya Bɛ̈nyŋaknhom yen bï luɔ̈ŋde la tïŋ.” ");
INSERT INTO dikNT_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Tɛ̈wën cï ye mat ku buk cath riäi buk la Italia, gokë Paulo ku jɔl aa kɔc kɔ̈k cï mac thɔ̈n Juliöth, bɛ̈ny akut apuruuk Roma, akut cɔl, “Akut Bɛ̈nyŋaknhom.” ");
INSERT INTO dikNT_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Ku lok riän bɔ̈ Adramitiöm, riän cï guiir bï jäl wath thok wun Athia. Arithtarkuth raan pan Mathedonia wun cɔl Thethalonika ë cath kek ɣo. ");
INSERT INTO dikNT_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Na aköl dɛ̈ɛ̈të ke ɣo ɣet Thidon. Juliöth ë ye raan path, ee cï Paulo puɔ̈l ku bï kɔc määth kek ye la tïŋ, rin bïk la yiëk käk wïc. ");
INSERT INTO dikNT_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Ɣok acï bar, ku rin cï ɣok ɣonhïïm wɛ̈l yom, goku riäi gɛɛr tɛ̈ bï yen cath thïn apath, ku ë ye alɔŋ ye akɔ̈l bɛ̈n thïn rial pan tɔ̈ gool nhom wär ciɛl yic cɔl Thaipruth. ");
INSERT INTO dikNT_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Ku jɔlku wär teem buk la Cilicia ku Pampilia ku lok Mira pan tɔ̈ wun cɔl Likia. ");
INSERT INTO dikNT_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Tɛ̈në, ke bɛ̈ny apuruuk yök riän jäl Alekdhändria ke la Italia, go ɣo ɣäth thïn. ");
INSERT INTO dikNT_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Ku riäi ë cath amääth rin yom ë dït apɛi. Ku ɣok aacï nïn juëc bɛ̈n nɔ̈k dhël yic buk jäl ɣet gen cɔl Kniduth. Yom ë këc ɣo puɔ̈l ku buk la dhëldan yen buɔthku yic, goku ret wanh cɔl Thalmone tɛ̈n yen bï pan thiin tɔ̈ gool nhom cɔl Kret ɣook kɔl ë yom. ");
INSERT INTO dikNT_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Ku ciɛthku ke ɣo göök yom ke ɣo kuany agör yɔu, ku ɣok aacï bɛ̈n ɣet tɛ̈ cɔl Wanh Path ë riɛl, ku ë tɛ̈n cïï mec kek gen cɔl Lathia. ");
INSERT INTO dikNT_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Ku ciëŋku thïn nïn juëc, ku ril yic buk la tueŋ ɣo cath wïïr, rin ë nïnkä aköl Yan lɔɔk kɔc kegup wïïr ëcï bar, tɛ̈n yen ye yom rut rot jɔt apɛi. Go Paulo ke lɛ̈k ëlä, ");
INSERT INTO dikNT_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Kackiɛ̈, aya tïŋ lɔn cäthda jäl ë tɛ̈n abï yic riɛl, riäi abï riääk ku käk tɔ̈ thïn aabï puk wïïr, ku kɔc aabï mou aya.” ");
INSERT INTO dikNT_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ku bɛ̈ny apuruuk ë wɛ̈t raan kuath riäi ku raan la riäi yen aye piŋ, ku kueec wɛ̈t cï Paulo lueel. ");
INSERT INTO dikNT_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ku wath thok tɛ̈ ye riäi mac thïn ëcï path bï kɔc mäi thïn. Go kɔc juëc keyiic wïc ku bïk la tueŋ bïk ɣet Ponik tɛ̈ lëu yen rot. Yen ë wanh tɔ̈ Kret, ku ëcie yethok wɛl lɔŋ bër tɛ̈ ye akɔ̈l lööny piny thïn. ");
INSERT INTO dikNT_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Yom thööŋ rot ëcï jɔt ke bɔ̈ ciɛɛm tɛ̈ cï raan yenhom wɛl tɛ̈ ye akɔ̈l lööny piny thïn, go kɔc ke cath riäi tak lɔn nadë ka lëukë bïk la tueŋ ke cath, gokë riäi lony ku gerkë ke kuënykë agör Kret yɔu. ");
INSERT INTO dikNT_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Ku kaam thiin awën ke yomdït ril apɛi bɔ̈ cuëëc tɛ̈ cï raan yenhom wɛl tɛ̈ ler akɔ̈l thïn, ben bɛ̈n ke ye pïu apɛi. ");
INSERT INTO dikNT_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Ku yiɛ̈ɛ̈k riäi bï la bëëŋbëëŋ, ku ril yic apɛi bï gɛɛr tueŋ tɛ̈ bï yom thïn, goku puɔ̈l buk cɔl akuɛɛth yom. ");
INSERT INTO dikNT_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Ɣok aacï bɛ̈n lɔŋ wën tëëk ɣok lɔŋ ye yom rut yenhom wɛl thïn, pan thiin tɔ̈ gool nhom cɔl Kauda. Tɛ̈ɛ̈n, acuk bɛ̈n lëu buk riän koor duɔ̈ɔ̈t riändït cök. ");
INSERT INTO dikNT_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Ku rin dïït yom apɛi, gokë duɔ̈ɔ̈t riändït kɔ̈u rin bï yom tiim cï ke riäi looi cïï piir wei, ku jɔlku duɔ̈ɔ̈t piny wïïn. Keek aake riɔ̈c ciɛ̈t riänden bï la döt liɛɛt yic wanh Libia thok, gokë alɛ̈th ye yom ke riäi kuaath däk bei, ku cɔlkë riäi ajɔl yom kuaath. ");
INSERT INTO dikNT_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Yomdït ril awën acï la tueŋ ke pïu apɛi, nawën aköl dɛ̈ɛ̈të ke jɔkkë bïk käk tɔ̈ riäi yic cuat wïïr. ");
INSERT INTO dikNT_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Nawën aköl ye nïn diäk ke cuɛt abɛ̈k käk gɛ̈r wïïr ciɛnken. ");
INSERT INTO dikNT_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Ku cuk akɔ̈l ku kuɛl tïŋ nïn juëc, ku yom acï la tueŋ ke pïu apɛi. Akëcku bɛn bɛ̈n ŋɔ̈ɔ̈th lɔn bï ɣok pïïr. ");
INSERT INTO dikNT_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Nawën cï kɔc nïn juëc nɔ̈k ke cïn miëth cïk cam, go Paulo rot jɔt ku kɛ̈ɛ̈c kenhïïm ku lueel, “Kackiɛ̈, na we cï wɛ̈tdiɛ̈ piŋ wäär bäk riäi cïï geer wei Kret ŋuɔ̈t ɣok aa këc mam këlä. ");
INSERT INTO dikNT_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ku ë mënë wek aa läŋ, dɛɛtkë wepuɔ̈th! Acïn raan töŋ bï thou weyiic, ë riäi yetök yen abï riääk. ");
INSERT INTO dikNT_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ku wën akɔ̈u atuny Nhialic yen ye ɣɛn raande, ku yen ya door acï bɛ̈n tënë ɣa, ");
INSERT INTO dikNT_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ku lueel, ‘Duk riɔ̈c, Paulo! Yïn abï ɣet Bɛ̈nyŋaknhom nhom, ku rin ë wɛ̈t kënë Nhialic acïï yï pɛ̈l wei, ku kɔc cath kek yï riäi yic aabï pïïr.’ ");
INSERT INTO dikNT_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Këya, kackiɛ̈, dɛɛtkë wepuɔ̈th! Nhialic aca deet puɔ̈u, abï këpath looi tɛ̈cït tɛ̈ cï ye lɛ̈k ɣa thïn wënakɔ̈u. ");
INSERT INTO dikNT_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Ku yom abï riäi kuaath bï cɔl ala gool nhom cɔk alɔn bï yen la riääk thïn.” ");
INSERT INTO dikNT_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Ku nïn aake cï ya thiäär ku ŋuan, ku yomdït apɛi ë kuath riända wärdït Adɛ̈kdiɛɛt yic. Na ye tɛ̈cït wɛ̈ɛ̈r ciɛl yic, ke ye kɔc ger riäi yök kepuɔ̈th ciɛ̈t ɣo cï thiɔ̈k buk ɣet agör thok. ");
INSERT INTO dikNT_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Gokë wïn cï duɔ̈t thok këthiek luaac piny pïu yiic, ku wën ye kek ye luaac piny ëmën ku mën, ke yökkë lɔn thiɔ̈k wär yic. ");
INSERT INTO dikNT_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Gokë riɔ̈ɔ̈c ciɛ̈t riäi bï rot dɛɛny kuɔ̈r tɔ̈ pïu yiic, gokë wïïn cï duɔ̈t thook aleeldït ye riäi dɔm luaac piny riäi thar ciëën, ku jɔlkë bak piny ŋɔ̈ɔ̈th. ");
INSERT INTO dikNT_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Ëcï agër kɔ̈k them ku bïk röt kuɛ̈l bei riäi yic. Ku jötkë riän thiin koor tɔ̈ riändït yic bei, ku tɛ̈ɛ̈ukë wïïr ke ye kɔc ciɛ̈t ke la wïïn cï duɔ̈t thook aleel luaac piny riäi nhom tueŋ. ");
INSERT INTO dikNT_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Go Paulo lɛ̈k bɛ̈ny apuruuk kek apuruɔ̈ɔ̈kke, “Na cä agër rɛ̈ɛ̈r riäi yic, ke kɔc tɔ̈ riäi yic aacïï bï pïïr.” ");
INSERT INTO dikNT_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Go apuruuk wïïn cï riäi mac piny teem kɔ̈ɔ̈th ku cɔlkë ke aa buɔk kuëër. ");
INSERT INTO dikNT_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Nawën bak piny, go Paulo ke lɔ̈ŋ bïk mïth ku lëk ke, “Wek aacï tïït nïn thiäär ku ŋuan ëmën, ku keek ë nïnkä yiic acïn kë cäk cam. ");
INSERT INTO dikNT_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Wek ya lɔ̈ŋ, ku bäk la miëth camkë, wek aa wïc miëth rin ku bäk pïïr. Acïn raan tök weyiic la kë bï ye gɔɔt.” ");
INSERT INTO dikNT_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Tɛ̈wën cï yen wɛ̈t kënë lueel, go Paulo ayup lööm, ku röök ke lec Nhialic kenhïïm ëbën, ku bɛny ayup yic, ku kɔŋ jɔɔk bï mïth. ");
INSERT INTO dikNT_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Keek aacï kepuɔ̈th bɛ̈n dɛɛt, ku mïthkë ëbën. ");
INSERT INTO dikNT_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Ɣok kɔc ɣo tɔ̈ riäi yic, ɣok aa ɣo ye buɔt karou ku thiärdhorou ku dätem. ");
INSERT INTO dikNT_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Nawën cï raan ëbën mïth, gokë rap ke tɔ̈ riäi yic dhɛ̈ɛ̈th wïïr rin bï riäi pial. ");
INSERT INTO dikNT_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Nawën cï piny bak, ke kɔc ger riäi aake këc tɛ̈ cï kek ɣëët thïn ŋic, keek aacï tɛ̈ cï wär yekɔ̈u tot thïn, la yic liɛɛt tïŋ, gokë tak bïk riäi gɛɛr thïn bïk la mac. ");
INSERT INTO dikNT_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Gokë wïïn yeke riäi mac piny tɛɛm wei bïk dïïr piny, ku däkkë wïïn cï ke alau duɔ̈ɔ̈t piny. Ku jɔtkë alɛ̈th nhial ku bï yom riäi kuaath tueŋ, bï la agör thok. ");
INSERT INTO dikNT_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ku riäi acï bɛ̈n la tɛ̈ cääl ku dööt liɛɛt yic bï ciɛ̈n tɛ̈ ben yen rot nyooŋ, ku cï abaŋ ciëën dhoŋ atiaktiak abï döŋ ke ya apet. ");
INSERT INTO dikNT_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Ecï apuruuk tak bïk kɔc cï mac ëbën nɔ̈k, bï ciɛ̈n raan tööŋ kuɛɛŋ aɣeer bï kat. ");
INSERT INTO dikNT_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Ku ë wïc bɛ̈ny apuruuk bï Paulo kony bï cïï näk, go apuruuk yɔ̈ɔ̈k bïk ciɛ̈n kë loikë tënë kɔc mac. Ku yöök kɔc ŋic kuaŋ bïk kaŋ thuɛɛt wïïr tueŋ ku bïk kuɛɛŋ aɣeer, ");
INSERT INTO dikNT_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","ku kɔc kɔ̈k aake bï jal lɔ̈k kuaŋ, ke cï tiim riäi cï duɔɔny kuɔ̈k bïk ke ɣäth aɣeer. Ku ë yen tɛ̈ cï ɣok bɛ̈n kuɛɛŋ aɣeer thïn akan ke ɣo puɔl gup. ");
INSERT INTO dikNT_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Wën cï ɣok ɣet wär alɔŋtui ɣo puɔl gup, ke jɔlku ŋic lɔn cɔl pan tɔ̈ gool nhom Malta ");
INSERT INTO dikNT_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","ku kɔc ke ciëŋ thïn aacï ɣo lor, ku nyuuckë ɣo apath. Tɛ̈wën ke deŋ tueny ku lir piny apɛi, gokë mac took ku cɔlkë ɣo buk ɣɔ̈c. ");
INSERT INTO dikNT_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Go Paulo tiim kuar piiny ku tɛ̈ɛ̈u ke mɛɛc, tɛ̈wën ke këpiiny bɔ̈ bei tiim yiic, ku kɛc cin abï nuɛt thïn. ");
INSERT INTO dikNT_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Ku tïŋ kɔc awën tɔ̈ thïn këpiiny ke cï nuɛt Paulo cin, ku jiɛɛmkë kamken, “Mony kënë ala cin rim. Ku kënë acïï yen bï pïr, cɔk alɔn cï yen poth wïïr ke këc mou.” ");
INSERT INTO dikNT_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Ku tɛ̈n awën ke Paulo yïr këpiiny mɛɛc, ke cïn kërɛɛc cïï rot looi tënë ye acïn. ");
INSERT INTO dikNT_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Ku ë titkë bïk tïŋ ke cï but cin, nadë ke wiɛ̈ɛ̈k piny nyin yic ke cï thou. Ku tɛ̈wën cï kek tïït apɛi ku cïn kë tïŋkë ke cï rot looi tënë Paulo, ke war kenhïïm ku luelkë, “Yeen ala guɔ̈p jɔŋril apɛi.” ");
INSERT INTO dikNT_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Dum raandït baai cɔl Publiöth, aake cï mec kek tɛ̈wën looi kënë rot thïn tënë Paulo. Ku yeen acï ɣo ŋiɛc lor aya, ku rëërku ɣo ye jäälke nïn kadiäk. ");
INSERT INTO dikNT_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Wun Publiöth ë rɛ̈ɛ̈r biöök yic ke cï juäi dɔm ku yiäny riɛm. Go Paulo la ɣöt tënë ye, ku röök ku dɔɔc, go pial. ");
INSERT INTO dikNT_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Wën cï kënë rot looi, go kɔc juëc ke tuany bɛ̈n, go Paulo ke dɔɔc bïk pial. ");
INSERT INTO dikNT_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Ku gɛ̈mkë ɣo käjuëc, ku wën jiël ɣok, gokë käk bï ɣok dhël tëëk tääu riäi yic. ");
INSERT INTO dikNT_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Nawën pɛ̈i kadiäk cök, ke ɣo jiël riän cɔl, “Jak Acuek,” bɔ̈ wanh cɔl Alekdhändria ku yen acï pɛ̈i bɛ̈n nɔ̈k ke kääc Malta rin yom ë dït apɛi. ");
INSERT INTO dikNT_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Ku ɣeetku gen cɔl Thirakuthe, ku näkku nïn kadiäk thïn. ");
INSERT INTO dikNT_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Ku jiëlku thïn, ku lok gen cɔl Regium. Nawën bak piny ke wel yom nhom, ku ɣeetku gen cɔl Putöli nïn karou cök. ");
INSERT INTO dikNT_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ku yökku kɔc cï gam thïn, ku thiëckë ɣo buk rëër ke ke nïn kadhorou. Ku jɔlku jäl tɛ̈n ku lok Roma ɣocök. ");
INSERT INTO dikNT_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Wämäthkuan tɔ̈ Roma aake cï ɣo piŋ lɔn bïï ɣok, go kɔc kɔ̈k bɛ̈n gen ɣɔɔc cɔl Apiöth ye jɔ̈ɔ̈l nïn thin bïk ɣo lor. Wën tïŋ Paulo ke, ke lec Nhialic, ku riil kënë puɔ̈u. ");
INSERT INTO dikNT_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Wën cï ɣok ɣëët Roma, Paulo acï bɛ̈ny mac Roma puɔ̈l bï rëër ë rot kek apuruk töŋ tit ye. ");
INSERT INTO dikNT_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Nawën nïn kadiäk cök, ke Paulo cɔl kɔcdït Itharel rɛ̈ɛ̈r Roma bïk rɔ̈m kek ye. Nawën cïk kenhïïm mat, ke lueel tënë ke, “Wämäthkiɛ̈! Wën cɔk yen ciɛ̈n kërɛɛc ca looi tënë kackua, ayï lɔn këc ɣɛn ciɛɛŋ wärkuandït dhɔ̈l yic, ɣɛn acï mac Jeruthalem ku thön ɣa apuruuk Roma. ");
INSERT INTO dikNT_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Gokë ɣɛn thiëëc awuɔ̈c ca looi, ku wïckë bïk ɣa lony, rin acïk yök ke cïn kë ca looi lëu ye bï ɣa nɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Nawën la kɔc Itharel kuec wɛ̈t bï ɣa lony, guɔ luɔ̈ŋdiɛ̈ cɔl aɣɛ̈th tënë bɛ̈nyŋaknhom Roma mac wuɔ̈nda aya, cɔk a lɔn cïn yen kë gɔɔny ɣɛn ë kackua. ");
INSERT INTO dikNT_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Yen ë kë wïc ɣɛn we buk rɔ̈m, ku jaam kek we, rin ɣɛn acath ɣa mac rin wɛ̈t raan yen ŋɔ̈ɔ̈th kɔc Itharel.” ");
INSERT INTO dikNT_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Gokë lueel tënë ye, “Acïn athör cï ɣëët tënë ɣo Judia riɛnku, ku acïn wämäthdan cï bɛ̈n kek wɛ̈t, lɔn le yen kërɛɛc ca looi. ");
INSERT INTO dikNT_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Anhiarku buk wɛ̈lku piŋ rin aŋicku lɔn ye kɔc juëc akut tɔ̈ yïn thïn, jääm guɔ̈p.” ");
INSERT INTO dikNT_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Këya, gokë aköl bï kek rɔ̈m kek Paulo mat yic, ku kɔc juëc aacï bɛ̈n aköl kënë tɛ̈ rëër Paulo thïn. Ku jɔl Paulo wɛ̈t bääny Nhialic teet yic tënë ke, jɔɔk riɛl ɣet thëëi. Ëcï them bï nyooth tënë ke lɔn kë ye lueel rin Jethu ë yic, ku nyooth lɔn thöŋ löŋ Mothith ku käk kɔ̈k cï gɔ̈t kɔc käk Nhialic tïŋ, kek wɛ̈t ye lueel. ");
INSERT INTO dikNT_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Go kɔc kɔ̈k wɛ̈t ye lueel gam, ku kuec kɔc kɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Gokë jäl ke tɛɛr kamken, wën cï Paulo ye lëk ke ëlä, “Ee yic apɛi, yen tɛ̈ cï Wëi Nhialic raan käk Nhialic tïŋ cɔl Ithaya lɛ̈k thïn bï lueel ëlä tënë wärkuan dït. ");
INSERT INTO dikNT_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Rin acï lueel ëlä, ‘Lɔɔr luel tënë kɔc Itharel, Wek aabï weyïth diël piny apɛi ku acäk bï deet, wek aabï wenyïn päl piny apath, ku acäk bï tïŋ. ");
INSERT INTO dikNT_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Rin kɔckä aa ril nhïïm, keek aacï keyïth cuɔ̈k, ku keek aacï kenyïn niɛɛn. Ŋuɔ̈t keek aa daai, ku ŋuɔ̈t keek aa piŋ, ku detkë käŋ yiic, ku lueel Nhialic. Na cï rot looi këya, ŋuɔ̈t aacï kepuɔ̈th wɛ̈l ɣɛn ku kuɔny ke.’ ” ");
INSERT INTO dikNT_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Ku wit Paulo wɛ̈tde ëlä, “Alɛ̈ukë bäk dhiɛl ŋic, lɔn wɛ̈t bï kɔc kony bï kɔc pïr, bɔ̈ tënë Nhialic, acï lɛ̈k kɔc cie kɔc Itharel. Ku abïk piŋ.”  ");
INSERT INTO dikNT_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Wën cï Paulo ë wɛ̈t kënë lueel, ke kɔc Itharel jiël ke tɛɛr apɛidït kamken. ");
INSERT INTO dikNT_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Ku jɔl Paulo rëër run karou pan ye riɔp yic, ku ë ye kɔc bɛ̈n bïk ye bɛ̈n tïŋ lor ku nyuuc ke. ");
INSERT INTO dikNT_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Ee ye piööc wɛ̈t bääny Nhialic, rin Bɛ̈ny Jethu Krïtho, ku jiɛɛm tënë kuat raan ëbën ke cïï riɔ̈c, ku acïn kënë ye gël bï cïï ye piööc.");
INSERT INTO dikNT_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Ee ɣɛn Paulo alony Jethu Krïtho. Ɣɛn raan cï Nhialic cɔɔl ba ya atuuc ba Wɛ̈t Puɔth Yam luɛɛl. ");
INSERT INTO dikNT_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Wɛ̈t Puɔth Yam, ee wɛ̈t cï Nhialic thɔn thɛɛr, ku ëcï kɔc käkke tïŋ lueel tɛ̈cït tɛ̈ cï gät ye wël thɛɛr Nhialic yiic. ");
INSERT INTO dikNT_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Wɛ̈t yam kënë ë wɛ̈t Wën Nhialic cï bɛ̈n a raan kuat Bɛ̈nyŋaknhom Debit. ");
INSERT INTO dikNT_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Ku Jethu acï nyuɔɔth ë Wëi Nhialic ke ye Bänyda, Wën ril Nhialic, wäär jöt ye bei raŋ yic. ");
INSERT INTO dikNT_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Ku ë riɛnke yen acï Nhialic ɣɛn yiëk dhɛ̈ɛ̈ŋde ku cɔl ɣɛn aye atuny Jethu, ku ba kɔc pinynhom ëbën cie kɔc Itharel cɔɔl bïk gam ku thekkë Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Ku wek kɔc cï gam tɔ̈ Roma aya, wek aacï Nhialic cɔɔl bäk aa kɔc Jethu raan cï lɔc ku dɔc. ");
INSERT INTO dikNT_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Këya, ɣɛn agɛ̈t tënë we ëbën, wek kɔc nhiɛɛr Nhialic, cï ke cɔɔl bäk aa kacke, Bï Nhialic Wäda ku Bɛ̈ny Jethu we tuɔ̈c dhëëŋ ku dɔ̈ɔ̈r. ");
INSERT INTO dikNT_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Tueŋ, ɣɛn alec Nhialicdiɛ̈ rin Jethu raan cï lɔc ku dɔc ë riɛnkun, rin kɔc ëbën pinynhom aacï gamdun ŋic ëbën. ");
INSERT INTO dikNT_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Nhialic yen luɔ̈ɔ̈i piändiɛ̈ ye ɣɛn kɔc lɛ̈k Wɛ̈t Puɔth Yam cï Wënde lɛ̈k kɔc, aŋic tɛ̈ ye ɣɛn we ");
INSERT INTO dikNT_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","tak thïn akölaköl ë rɔ̈ɔ̈kkiɛ̈ yiic. Ɣɛn ë röök lɔn bï Nhialic ɣa puɔ̈l tɛ̈ wïc yen ye ba we la neem. ");
INSERT INTO dikNT_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Rin awiëc apɛidït ba we la tïŋ ku ba we gäm athiɛɛi Wëi Nhialic bäk riɛl ë gamdun yic. ");
INSERT INTO dikNT_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Ku kë luɛɛl akïn, rin bï gamda we ku ɣɛn ɣo dɛɛt puɔ̈th ɣodhie. ");
INSERT INTO dikNT_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Awiëc bäk ŋic miɛ̈thakäi lɔn ë ca guiir arak juëc ba la tënë we, ku ala kën ye ɣɛn gël ba cïï la. Ee wiëc ba la tënë we ba kɔc kɔ̈k lɛ̈k bïk gam kamkun aya, cïmën le ɣɛn kɔc kɔ̈k pinynhom cï gam cie kɔc Itharel. ");
INSERT INTO dikNT_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Rin ala kë cï yiëk ɣa ba dhiɛl looi tënë kɔc ëbën, kɔc pɛth ciɛɛŋ ku kɔc rɛɛc ciɛɛŋden, ku tënë kɔc cï piöc ku kɔc këc piöc. ");
INSERT INTO dikNT_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Ku ë wɛ̈t kënë yen awïc ɣɛn ye apɛi ba we dhiɛl lɛ̈k Wɛ̈t Puɔth Yam wek kɔc rɛ̈ɛ̈r Roma aya. ");
INSERT INTO dikNT_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Ɣɛn acie guɔ̈p ë yär Wɛ̈t Puɔth Yam, rin ë yen riɛl Nhialic kɔc cï ye gam kony, kɔc Itharel ku kɔc pinynhom cie kɔc kɔ̈k Itharel aya. ");
INSERT INTO dikNT_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Ku Wɛ̈t Puɔth Yam aye nyuɔɔth tɛ̈ ye Nhialic kɔc kuɔny thïn bïk la cök yenhom. Ku kënë aye Nhialic jɔɔk ku rëër thïn këya rin gam ë raan, cïmën ye athör thɛɛr wël Nhialic ye lueel ëlä, “Ku raan la cök Nhialic nhom abï pïr ë gam.” ");
INSERT INTO dikNT_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Rɛ̈ɛ̈c puɔ̈u ë Nhialic ë rot nyuɔɔth pan Nhialic tënë kɔc man Nhialic. Ku kärɛc yekë ke looi aa yic gël bï cïï cɔl aŋic. ");
INSERT INTO dikNT_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Nhialic ë puɔ̈u rɛ̈ɛ̈c tënë ke rin kë lëu raan bï ŋic rin Nhialic ala gɛi apɛi, acï Nhialic tääu raan ëbën puɔ̈u bï ŋic. ");
INSERT INTO dikNT_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Tɛ̈thɛɛr ɣɔn cɛk Nhialic nhial ku piny, alëu raan ëbën bï ŋic ë gai lɔn riɛl Nhialic ë rëër thïn akölriëëc ëbën, ku yeen ë Nhialic alanden. Käjuëckä aacie tïŋ ku aaye ŋic rin käjuëc cï Nhialic cak. Këya, acïn kë kɔŋ kek röt kony. ");
INSERT INTO dikNT_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Keek aake ŋic Nhialic ku ŋot ke kuec bïk cïï dor. Ku kueeckë bïk cïï gɛ̈m alɛɛcden ë yen Nhialic. Ku jɔl käkken yekë tak ciɛ̈nkë konykë ku la piäthken bïth. ");
INSERT INTO dikNT_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Na cɔk alɔn ye kek ye lueel lɔn ŋic kek käŋ, ku acïn kë ŋickë. ");
INSERT INTO dikNT_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Ku lɔn bï kek ye aa door ë Nhialic pïr akölriëëc ëbën, ka yekë ke door käk cïï pïr ku raan ë thou. Ku kɔ̈k cï kiɛ̈ɛ̈t ke cït diɛt ku lääi. Ku käkkɔ̈k wuc piiny keyöth cïmën käpiɛny. ");
INSERT INTO dikNT_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Ku rin ë kënë, aacï Nhialic ke puɔ̈l bïk aa luui kärɛc wïc piäthken, käk la bïth. Ku wïcwïc ë diäär ku käkkɔ̈k yekë ke looi kamken käk kɔc cɔl ayär gup. ");
INSERT INTO dikNT_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Ku lɔn bï kek kën yic ŋickë rin Nhialic gam, ka yekë gam ë lueth ku yekë ke door käk ke cɛk Nhialic, ku kueeckë Aciëŋ yen cak käkkä yen dhil ya door akölriëëc ëbën. Yenakan. ");
INSERT INTO dikNT_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Ku ë yen acï Nhialic ke puɔ̈l bïk aa luui kärɛc kɔc yɔ̈ɔ̈r gup. Ayï diäärken aya aacï tɛ̈ cï kɔc cak thïn puɔ̈l, ku aa röt lööm ë röt. ");
INSERT INTO dikNT_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Këlä aya, röör aacï tɔ̈c ye kek tɔ̈c kek diäär, cït tɛ̈ cï kɔc cak thïn puɔ̈l, ku rum bal kepuɔ̈th bïk ke aa lööm röör kɔ̈k cït ke. Röör tuil röör kɔ̈k, ku yekë kärɛc cït käkkä looi, aaye tɛ̈m awuɔ̈c thöŋ kek kärɛc yekë ke looi. Käk këc puɔ̈l bï ke aa looi këya. ");
INSERT INTO dikNT_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Ku yeen aya rin cï kek kuec bïk yiny Nhialic cïï ŋic, aacï Nhialic puɔ̈l aya bïk aa tak kärɛc ku yekë luui kärɛc cïï ke lëu bï raan ke looi. ");
INSERT INTO dikNT_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Ku aacï puɔ̈th thiäŋ kuat kärɛc apɛi, adumuɔ̈ɔ̈m, kook ku kɔɔr. Ku aacï puɔ̈th thiäŋ aya ë tiɛɛl, nääk, thɔ̈r, ruëëny ku kuith, ku aa luum. ");
INSERT INTO dikNT_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Ku aa kegup tɔ̈r lueth ku aa man Nhialic. Aa kɔc nhiam, kɔc dhäl kɔc gup cïn gup athɛ̈ɛ̈k. Kɔc tak dhɔ̈l juëc bï kek kärɛc looi. Kɔc cie kɔc ke dhiëth ke ë theek. ");
INSERT INTO dikNT_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Kɔc cïn gup nhïm, kɔc këdäŋ gam ku cïk loi. Kɔc cïn puɔ̈th cie yiic ë ŋɛɛr raandä. ");
INSERT INTO dikNT_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Cɔk alɔn ŋic kek ye lɔn kärɛc yekë ke looi, alëu ke bï Nhialic ke tɛ̈m thou, ke keek aacie käkkä ë looi kepɛ̈c, aa kɔc kɔ̈k ke looi lɛc nhïïm aya. ");
INSERT INTO dikNT_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Yïn acïn tɛ̈ bï yïn rot kony tɛ̈ luk yïn kɔc kɔ̈k wei. Rin tɛ̈ ye yïn kɔc kɔ̈k luɔ̈k wei, ku loi käwën yekë ke looi aya, ke yïn ë rot dɔm ë rot. ");
INSERT INTO dikNT_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Ku ëmën aŋicku lɔn Nhialic ala yic tɛ̈ luk yen kɔc wei, kɔc käkkä looi. ");
INSERT INTO dikNT_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Ku na ye kɔc luɔ̈k wei, yïn raan ë path, ku ŋot yï loi ë käkkä, ke ye tak lɔn bï yïn luŋ Nhialic ban? ");
INSERT INTO dikNT_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Tɛ̈dɛ̈t aya, yïn ë käjuëc rɛ̈ɛ̈r piath Nhialic yiic cïmën piathden dït, gum, ku lääu ë puɔ̈u yɔ̈ɔ̈ŋ yiic, rin akuc lɔn aye piath Nhialic nyooth ba yïpuɔ̈u dhuɔ̈k ciëën. ");
INSERT INTO dikNT_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Ku riɛl ë nhom, ku rin cï yïn kuec ba yïpuɔ̈u cïï dhuk ciëën abä awäcdu juak yic aköl bïï riääk puɔ̈u Nhialic, ku tɛ̈ bï yen ŋiɛc luk thïn abï rot nyuɔɔth. ");
INSERT INTO dikNT_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Rin Nhialic abï ŋɛk a gäm kë thöŋ kek tɛ̈ cï yen luui thïn. ");
INSERT INTO dikNT_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Kɔc bï kepuɔ̈th dɛɛt ku luuikë käpath ku wïckë duaar, lɛc ku pïr akölaköl, aabï Nhialic gäm pïr akölriëëc ëbën. ");
INSERT INTO dikNT_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Ku kɔc ke looi käk wïc piäthken ku kueckë yic ku buɔthkë kärɛc jɔŋrac, aabï Nhialic puɔ̈u riääk tënë ke. ");
INSERT INTO dikNT_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Kɔc ëbën ë luui kärɛc aaba arɛɛm ku gum rac apɛi yök. Ku abï rot kaŋ looi tënë kɔc Itharel, ku tënë kɔc cie kɔc Itharel aya. ");
INSERT INTO dikNT_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Ku Nhialic abï duaar ku lɛc ku dɔ̈ɔ̈r gäm kɔc luui käpath, tueŋ tënë kɔc Itharel ku jɔl aa kɔc kɔ̈k cie kɔc Itharel, ");
INSERT INTO dikNT_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","rin Nhialic ë luk ŋiɛc looi tënë kɔc ëbën. ");
INSERT INTO dikNT_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Ku kɔc cie kɔc Itharel kuc löŋ Mothith, ku aa kärɛc looi luk abï looi tënë ke cɔk alɔn kuc kek löŋ. Ku kɔc Itharel aa ŋic löŋ Mothith, aa kärɛc looi ku luk aye looi tënë ke tɛ̈cït tɛ̈ ye löŋ ye luɛɛl thïn. ");
INSERT INTO dikNT_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Rin acie pïŋ ë löŋ yen kɔc cɔl aye kɔc path tënë Nhialic, aa kɔc ye looi kë ye löŋ lueel kek aabï ya kɔc la cök Nhialic nhom. ");
INSERT INTO dikNT_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Ku ë yic, kɔc kɔ̈k cie kɔc Itharel cïn löŋ, tɛ̈ looi kek këdäŋ tɛ̈cït tɛ̈ ye löŋ tɔ̈ kepuɔ̈th ë path ye luɛɛl thïn, ke keek aa cït kɔc la löŋ cɔk alɔn cïn kek löŋ Mothith. ");
INSERT INTO dikNT_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Tɛ̈ ye kek luui thïn aye nyuɔɔth lɔn käk wïc löŋ aacï gɔ̈t kepuɔ̈th, aa käpath ku kärɛc yekë ke looi ŋic rin aaye piäthken nyuɔ̈th ke. ");
INSERT INTO dikNT_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Ku këlä aya, cïmën Wɛ̈t Puɔth Yam ya lɛ̈k we, yen ë kë bï rot looi aköl luk tɛ̈ bï Jethu Krïtho luk looi rin Nhialic tënë kɔc ëbën, ŋɛk kek këden cï thiaan yeyic. ");
INSERT INTO dikNT_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Ku yïïn ëmën, yïn ë rot cɔl aye raan Itharel, ku yïn ë rot cɔl aye raan muk löŋ, ku ye jam nhiaam lɔn ye yïn raan Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Yïn aŋic kë wïc Nhialic ba looi ku yïn aŋic yic rin cï löŋ ye lɛ̈k yï. ");
INSERT INTO dikNT_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Aca gam lɔn yïn awat kɔc cï cɔɔr nhïïm, ku yïn ë ruɛl tënë kɔc tɔ̈ muɔ̈ɔ̈th yic, ");
INSERT INTO dikNT_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","ku yïn ë kɔc piɔ̈ɔ̈c, kɔc kuc käŋ, ku yïn ë raan piööc mïth. Ku rin le yïn löŋ aye tak lɔn ŋic yïn käŋ ëbën. ");
INSERT INTO dikNT_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Yïn ë kɔc kɔ̈k piɔ̈ɔ̈c yeŋö cïï yïn rot ye piɔ̈ɔ̈c? Yïn ë kɔc wɛ̈ɛ̈t ëlä, “Duɔ̈kkë ye cuëër.” Ku yïn cïï ë cuär ë yiɛnhdu? ");
INSERT INTO dikNT_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Aye lueel, “Duɔ̈kkë ye köör.” Cïï akɔr ye looi? Yïn aman jak cï kiɛ̈ɛ̈t, cïï käpuɔth tɔ̈ yïïk jak cï kiɛ̈ɛ̈t yiic ye rum? ");
INSERT INTO dikNT_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Yïn ë jam nhiaam lɔn ŋic yïn löŋ Nhialic, cïï Nhialic ye dhɔ̈l guɔ̈p tɛ̈ cïï yïn lɔ̈ŋde loi? ");
INSERT INTO dikNT_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Aye athör thɛɛr wël Nhialic lueel ëlä, “Kɔc cie kɔc Itharel aa kärɛc luɛɛl Nhialic guɔ̈p ë riɛnkun.” ");
INSERT INTO dikNT_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Ciɛɛŋ kɔc Itharel ye ke ŋoot ë piath tɛ̈ theek kek löŋ, ku na cïï löŋ thek ke yïn acït raan këc ŋoot. ");
INSERT INTO dikNT_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Na raan cie raan Itharel këc ŋoot, raan cïï kë wïc löŋ ë dhɔ̈l yic, cïï bï ciɛ̈t kɔc cï ŋoot? ");
INSERT INTO dikNT_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Ke wek kɔc Itharel wek aabï kɔc këc ë ŋoot, ku aa löŋ theek ya yɔ̈ɔ̈k lɔn acïn raan bäk gɔ̈k, tɛ̈ le we tɛ̈m awuɔ̈c rin wek aacie löŋ ye theek, cɔk alɔn ŋic wek kë cï gɔ̈t ku ŋot we. ");
INSERT INTO dikNT_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Yeŋa yen raan Itharel ayic, yen cï ŋoot? Acie raan yeke ŋuɔ̈t tïŋ yeguɔ̈p ë path yen ya raan Itharel. ");
INSERT INTO dikNT_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Raan Itharel guɔ̈p, ee ya raan yepuɔ̈u alɔŋthïn cï piände ŋoot Wëi Nhialic, ku acie löŋ cï gɔ̈t. Ku raan kënë acie lɛc yök tënë kɔc, aye yök tënë Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Ye këpuɔth nɛn wɛ̈r kɔc Itharel kɔc cie kɔc Itharel? Tɛ̈dɛ̈t ye këpiath ŋö ye yök ŋuɔ̈t yic? ");
INSERT INTO dikNT_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Käjuëc aaye yök ayic! Tueŋ, kɔc Itharel aacï Nhialic thɔ̈n wɛ̈tde bïk muk apath. ");
INSERT INTO dikNT_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Ku yeŋö bï yiëndë tɛ̈ cïn kɔc kɔ̈k Itharel gam? Bï kë cïn kek gam Nhialic cɔl awar athɔ̈nde yic? ");
INSERT INTO dikNT_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Acïï bï waar yic! Yiny Nhialic adhil tɔ̈ thïn akölaköl cɔk alɔn ye kɔc alueth. Cïmën ye athör thɛɛr wël Nhialic ye lueel ëlä, “Këya, bï ŋic lɔn le yïn yic, wël ye lueel yiic, ku luk yïïn yic.” ");
INSERT INTO dikNT_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Ku na kärɛc yeku ke looi ye Nhialic nyuɔɔth lɔn le yen cök alanden, ke yeŋö buk lueel? Buk lueel Nhialic acïn yic tɛ̈ tëm yen ɣo awuɔ̈c? (Ee tɛ̈ ye kɔc jiɛɛm thïn yen aluɛɛl.) ");
INSERT INTO dikNT_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Acie tɛ̈de! Na Nhialic cïï la cök ke lëu bï luk looi tënë kɔc pinynhom? ");
INSERT INTO dikNT_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Alëu raan dɛ̈t bï lueel ëlä, “Na ye lueth ya ke lueel yic Nhialic nyuɔɔth thïn alanden ku juɛk duaarde yic, ke yeŋö ŋot ye ɣa cɔl aye raan cï kërac looi ku tëm ɣa awuɔ̈c?” ");
INSERT INTO dikNT_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Yeŋö cïï ye luel, cïmën ye kɔc kɔ̈k ɣa cäk thok ku luelkë lɔn cï ɣɛn ye lueel ëlä, “Loiku kërac bï këpath bɛ̈n.” Ee yic bï kɔckä tɛ̈m awuɔ̈c. ");
INSERT INTO dikNT_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Këya, ye ɣok ŋuɛ̈ɛ̈n tënë kɔc cie kɔc ë kuatda ɣok kɔc Itharel? Acie yic! Aca nyooth wënthɛɛr lɔn ɣok kɔc Itharel ku kɔc cie kuatda ɣok arɛ̈ɛ̈r adumuɔ̈ɔ̈m yic ɣodhie, ");
INSERT INTO dikNT_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","cïmën ye athör thɛɛr wël Nhialic ye lueel ëlä, “Acïn raan töŋ la cök, ");
INSERT INTO dikNT_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","acïn raan käŋ deet yiic, acïn raan wïc yeen bï Nhialic ŋic. ");
INSERT INTO dikNT_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Kɔc aacï kekɔ̈th wɛ̈l Nhialic, keek aacï rɛ̈ɛ̈c ëbën ka cï la bïth, acïn raan këpath looi, acïn mën raan tök.” ");
INSERT INTO dikNT_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","“Wël yekë keek lueel aa nhiany, aa cït raŋ cï ŋaany nhom, liëpken aacï luɛl lueth ŋic.” “Wël yekë keek lueel aa cït wäl këpiiny kɔc luaaŋ.” ");
INSERT INTO dikNT_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","“Aa wël ye kɔc lam ku wël rem apɛi kek aatɔ̈ kethook.” ");
INSERT INTO dikNT_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","“Aa kɔc lac nɔ̈k path, ");
INSERT INTO dikNT_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","riääk ku mam aa döŋ tɛ̈ cï kek tëëk thïn, ");
INSERT INTO dikNT_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","ku keek aacïï dhël dɔ̈ɔ̈r ŋic.” ");
INSERT INTO dikNT_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","“Ku riɔ̈ɔ̈c, riɔ̈ɔ̈c kek Nhialic aliu käk yekë looi yiic.” ");
INSERT INTO dikNT_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Ku aŋicku kuat kë ye löŋ lueel, aye lueel tënë kɔc la ye rin bï ciɛ̈n raan la kë kony yen rot, ku bï raan ëbën kɔ̈ɔ̈c Nhialic nhom. ");
INSERT INTO dikNT_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Këya, acïn raan bï la cök Nhialic nhom tɛ̈ cɔk yen ye them bï kë wïc löŋ looi. Kë ye löŋ looi ë lɔn bï nyuɔ̈th raan lɔn cï yen kërac looi. ");
INSERT INTO dikNT_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Ku ëmën tɛ̈ ye Nhialic kɔc cɔ̈k thïn yenhom acï nyooth. Acï löŋ ku kɔc käk Nhialic tïŋ lueel thɛɛr. ");
INSERT INTO dikNT_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Nhialic ë kɔc cök tɛ̈ le kek gam tënë Jethu Krïtho. Ee kënë looi tënë kuat raan ëbën cï Raan cï lɔc ku dɔc gam, kɔc Itharel ku kɔc cie kɔc Itharel aa thöŋ ëbën. ");
INSERT INTO dikNT_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Ku rin cï kek ëbën kärɛc looi, ee keek cɔl amec tënë duaar Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Ku keek aacï Nhialic muɔɔc dhɛ̈ɛ̈ŋde piände ëbën bïk la cök tënë ye. Ku dhëëŋ ye yök tënë Raan cï lɔc ku dɔc Jethu yen ë kɔc kony bïk kärɛc cïï loi. ");
INSERT INTO dikNT_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Jethu acï Nhialic gam rin bï thuɔnde a kë ye adumuɔ̈ɔ̈m päl piny tɛ̈ le raan gam tënë ye. Kënë acï Nhialic looi bï nyuɔɔth thïn lɔn le yen cök. Ku wäthɛɛr Nhialic ë lir puɔ̈u, ëcie kɔc ye tëm awuɔ̈c rin kärɛc cïk looi. ");
INSERT INTO dikNT_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Ku ëmën acï adumuɔ̈ɔ̈m cï looi ëbën päl piny bï nyuɔɔth lɔn le yen cök. Nhialic acï kënë looi rin le yen cök. Ku tɛ̈ looi yen kënë ë raan ëbën cï Jethu gam cɔl ala cök. ");
INSERT INTO dikNT_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Na ye këya, yeŋö ye ɣok jam nhiaam ë path? Acïn këdäŋ! Ku ye wɛ̈t nɛn ye ɣok nhiam? Ye rin cï ɣok löŋ theek? Acie tɛ̈de, ee tɛ̈ cï ɣok gam. ");
INSERT INTO dikNT_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Rin aŋicku raan ë la cök tënë Nhialic rin gam ku acie thɛ̈k löŋ ë rot. ");
INSERT INTO dikNT_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Ye Nhialic, Nhialic kɔc Itharel kepɛ̈c? Yeen cïï ye Nhialic kɔc cie kɔc Itharel aya? Ee yic ë Nhialic kɔc cie kɔc Itharel aya, ");
INSERT INTO dikNT_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","rin yen Nhialic töŋ bï kɔc Itharel cɔl ala cök ë gamden, ku cɔl kɔc cie kɔc Itharel aala cök rin gamden aya. ");
INSERT INTO dikNT_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Yeku löŋ dhɔ̈l yic tɛ̈ le ɣok gam kënë? Acie tɛ̈de acïn, ɣok aa löŋ juak bï riɛl. ");
INSERT INTO dikNT_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Yeŋö buk jäl lueel rin Abaram wundït thɛɛr kɔc Itharel? Yeŋö cï rot looi tënë ye? ");
INSERT INTO dikNT_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Na Abaram la kënë cï looi bï yen la cök tënë Nhialic, ŋuɔ̈t ala kënë ye yen nhiam. Ku acïï loi këlä tënë Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Cïmën ye wël cï gɔ̈t athör thɛɛr wël Nhialic yic ye lueel ëlä, “Abaram acï Nhialic gam ku rin gamde acï Nhialic cɔl ala cök tënë ye.” ");
INSERT INTO dikNT_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Raan luui aye riɔp, ku wëëu ye ye riɔp aacie miɔ̈c, ariöpden cï yen luui. ");
INSERT INTO dikNT_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Ku raan cie luui la gam tënë Nhialic, Nhialic yen kɔc cï kärɛc looi cɔl aala cök, ke gamde yen ë ye cɔl ala cök tënë Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Ku Debit acï wɛ̈t thöŋ kek ë wɛ̈t kënë lueel wäär yen jam rin raan mit puɔ̈u cï Nhialic gam ke la cök tënë ye, ke cie luɔi puɔth ye looi, ");
INSERT INTO dikNT_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Kɔc mit puɔ̈th aa kɔc cï Nhialic awäcken päl piny, ku wuuny adumuɔ̈ɔ̈mken wei. ");
INSERT INTO dikNT_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Raan mit puɔ̈u ee raan cï Bɛ̈ny bï kuɛ̈n guɔ̈p kärɛc cï looi.” ");
INSERT INTO dikNT_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Ye miɛt puɔ̈u cï Debit jam kën kɔc Itharel ë röt? Acie këden kepɛ̈c. Ee kën kɔc cie kɔc Itharel aya, ku wek aa we yeku lɛ̈k kë cuk yök athör wël Nhialic yic, rin acï wɛ̈t cï gɔ̈t thɛɛr lueel lɔn, “Abaram acï Nhialic gam, ku gamde acï yen a raan la cök tënë Nhialic.” ");
INSERT INTO dikNT_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Ye nɛn yen looi kënë rot? Loi rot tueŋ wäär këc Abaram ŋoot aye wäär cï ye ŋoot? Ee tueŋ, acie ŋuɔ̈t cök ciëën. ");
INSERT INTO dikNT_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Ku ŋuɔ̈tden jɔl ye lɔ̈k ŋoot ciëën, aye nyuɔɔth lɔn gam Abaram acï Nhialic ye gam ke ye raan la cök tënë ye tueŋ wäär këc ye cak ŋoot. Ku këlä, Abaram ë wundït kɔc cï Nhialic gam, ku aaye gam ke ye kɔc la cök tënë ye cɔk alɔn këc ke ŋoot. ");
INSERT INTO dikNT_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Ku yen ë wundït kɔc cï ŋoot aya. Ku acie rin cï ke ŋoot, ee rin cï kek dhël pïr gam thöŋ ke pïr wäda Abaram buɔɔth yic wäär këc ye cak ŋoot. ");
INSERT INTO dikNT_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Nhialic acä Abaram thɔn ku mïth bï lɔ̈k dhiëëth lɔn bï pinynhom a këden. Nhialic akëc athön kënë looi rin theek Abaram löŋ, ee rin cï yen gam, ku gam yen acï yen a raan la cök tënë Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Rin na ye kë ye Nhialic thɔ̈n kɔc gäm kɔc löŋ theek, ke gam acïn wɛ̈tde yic, ku cïn këpuɔth tɔ̈ athön Nhialic yic. ");
INSERT INTO dikNT_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Löŋ ë rɛ̈ɛ̈c puɔ̈u Nhialic bɛ̈ɛ̈i, ku tɛ̈ cïn yic löŋ, acïn löŋ ye dhɔ̈l yic. ");
INSERT INTO dikNT_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Nhialic ë loi athɔ̈nde rin gam ku rin dhɛ̈ɛ̈ŋde, bï athɔ̈nde a kën yic tënë mïth bï lɔ̈k dhiëëth tënë Abaram ëbën. Ku acie tënë kɔc la löŋ ë röt, ee tënë kɔc cï gam aya cïmën Abaram. Rin Abaram yen ë wädan wɛ̈ikua ɣodhie, ");
INSERT INTO dikNT_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","cïmën cï ye gɔ̈t athör thɛɛr wël Nhialic yiic ëlä, “Yïn aca looi ba ya wun kɔc wuɔ̈t juëc.” Abaram acï ya Wäda Nhialic nhom, Nhialic cï gam, Nhialic yen kɔc cï thou cɔl aben pïr, ku wɛ̈t ye lueel ke liu thïn cɔl aloi rot. ");
INSERT INTO dikNT_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Abaram acï gam ku ŋɛ̈ɛ̈th kë cïn kë ŋɔ̈th thïn, ku yen acï yen bɛ̈n a wun kɔc wuɔ̈t juëc cïmën cï Nhialic ye lɛ̈k ye ëlä, “Kɔckun bï lɔ̈k dhiëëth aabï juëc ka bï ciɛ̈t kuɛl.” ");
INSERT INTO dikNT_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Wën cï Abaram cak dhiɔp ë ruɔ̈nke aa cït buɔɔt, ku ŋic lɔn tiɛŋde Thara ke cï dhiɔp ke këc dhiëth, ke ŋot këc dhɔ̈r gamde yic. ");
INSERT INTO dikNT_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Ku rëër ke ŋɔ̈th ku cïï diu athön Nhialic, ku gamde acï ye bɛ̈n yiëk riɛl ku leec Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Ee ŋic, ke cïn diu lɔn bï Nhialic la riɛl bï kë cï thɔn dhiɛl looi. ");
INSERT INTO dikNT_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Ku ë yen acï Nhialic Abaram gam ke ye raan la cök tënë ye. ");
INSERT INTO dikNT_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Ku wëlkä, “Yen acï gam ke ye raan la cök,” aa këc gɔ̈t riɛnke ë rot. ");
INSERT INTO dikNT_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Aake gɛ̈t riɛnkua ɣok kɔc bï Nhialic gam aya ke ɣo la cök, ɣok kɔc ye gam lɔn yen Nhialic yen cï Jethu Bänyda jɔt thou yic. ");
INSERT INTO dikNT_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Yen acï cɔl athou rin adumuɔ̈ɔ̈mkua, ku jɔt bï pïr bï ɣo cɔl aala cök tënë Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Këya rin gamda Nhialic acï ɣo cɔl ala cök tënë ye, ku ɣok aala dɔ̈ɔ̈r kek ye rin Bänyda Jethu raan cï lɔc ku dɔc. ");
INSERT INTO dikNT_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Ɣok aacï gamda cɔl abïï Jethu dhëëŋ Nhialic yic, dhëëŋ yen rëër ɣok thïn ëmën. Ku ayeku ŋɔ̈ɔ̈th ɣo mit puɔ̈th lɔn ɣok aa duaar Nhialic rɔm kek ye. ");
INSERT INTO dikNT_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Ku acie këlä rot, ɣok aa puɔ̈th miɛt aya tɛ̈ guum ɣok, rin gum ë deet puɔ̈u bɛ̈ɛ̈i, ");
INSERT INTO dikNT_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ku gum ku deet ë puɔ̈u aye Nhialic gam. Ku gɛm ye Nhialic ye gam yen ë ŋɔ̈th bɛ̈ɛ̈i. ");
INSERT INTO dikNT_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Ku ŋɔ̈th acie ɣo cɔl ayär gup rin cï Nhialic nhiërde cɔl athiɔ̈ŋ ɣopuɔ̈th, Wɛ̈iken cï gäm ɣo. ");
INSERT INTO dikNT_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Rin wäär ŋot cïn yen tɛ̈ ye ɣok röt kuɔny thïn, ke Raan cï lɔc ku dɔc thou rin kɔc kuc Nhialic aköl cï Nhialic lɔc. ");
INSERT INTO dikNT_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Aril yic bï raan thou rin raan la cök, cɔk alɔn lëu yen rot bï raan dɛ̈t thou rin raan path. ");
INSERT INTO dikNT_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Ku Nhialic acï nhiër nhiɛɛr yen ɣo nyuɔɔth ë kënë yic, rin tɛ̈wäär ŋot ye ɣok kɔc la gup adumuɔ̈ɔ̈m, Raan cï lɔc ku dɔc acï thou riɛnkua. ");
INSERT INTO dikNT_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Ku ëmën thuɔnde acï ɣo cɔl ala cök tënë Nhialic. Ku na cï kënë looi, ke cïï ɣo bï wɛ̈ɛ̈r bei ayic riäŋ puɔ̈u Nhialic yic aköl ciëën? ");
INSERT INTO dikNT_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Ku wäär ye ɣok kɔc ater tënë Nhialic, ɣok aacï thon Wënde cɔl aben dɔ̈ɔ̈r kek ye. Ku na ye këya, ke pïr Raan cï lɔc ku dɔc cïï ɣo bï kony? ");
INSERT INTO dikNT_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Ku acie kënë ë rot, ɣok amit puɔ̈th aya tënë Nhialic rin Bänyda Jethu raan cï lɔc ku dɔc acï ɣo dɔ̈ɔ̈r ke Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Adumuɔ̈ɔ̈m acï bɛ̈n pinynhom rin raan tök, ku adumuɔ̈ɔ̈m cï looi yen acï bɛ̈n ke thou. Ku këlä, thou acï bɛ̈n tënë raan ëbën rin cï kek adumuɔ̈ɔ̈m looi ëbën. ");
INSERT INTO dikNT_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Adumuɔ̈ɔ̈m ë tɔ̈ pinynhom wäär këc löŋ Mothith gäm kɔc, ku tɛ̈ cïn yic löŋ tɔ̈ thïn, adumuɔ̈ɔ̈m acie kuɛ̈ɛ̈c nhom. ");
INSERT INTO dikNT_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Ku jɔɔk Adam bï bɛ̈n Mothith, thou ë ŋot ye tɛ̈m kɔc agut kɔc këc löŋ Nhialic dhɔ̈l yic, cïmën wäär cï Adam wɛ̈t cï Nhialic lɛ̈k ye dhɔ̈l yic. Adam yen ë ye kïn raan yen bï bɛ̈n. ");
INSERT INTO dikNT_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Ku keek karou aacïï thöŋ, rin miɔ̈c Nhialic cï gäm kɔc ë path acïï thöŋ kek adumuɔ̈ɔ̈m Adam. Raan tök, Adam, acä adumuɔ̈ɔ̈m looi, ku acï thou bɛ̈ɛ̈i tënë kɔc juëc. Ku këdït apɛi aya, raan tök, Jethu raan cï lɔc ku dɔc acï miɔ̈cdït dhëëŋ Nhialic bɛ̈ɛ̈i tënë kɔc juëc. ");
INSERT INTO dikNT_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Ku miɔ̈c Nhialic acï thöŋ kek adumuɔ̈ɔ̈m ë raan kënë. Ku adumuɔ̈ɔ̈m töŋ kënë cök kɔc juëc aacï tëm awuɔ̈c, ku adumuɔ̈ɔ̈m juëckä cök, miɔ̈c töŋ Raan cï lɔc ku dɔc Nhialic acï bɛ̈n ku cɔl kɔc aa ben la cök yenhom. ");
INSERT INTO dikNT_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Rin adumuɔ̈ɔ̈m raan tök thou acï bɛ̈n pinynhom. Ku këdït apɛi kɔc cï miɔ̈cdït Nhialic yök cï jäl la cök, aabï mac ku pïïrkë akölriëëc rin Raan cï lɔc ku dɔc. ");
INSERT INTO dikNT_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Këya, cïmën ye adumuɔ̈ɔ̈m tök kɔc cɔl aa tëm awuɔ̈c ëbën, ke këlä aya, luɔi töŋ la cök ë kɔc ëbën cɔl aala cök Nhialic nhom, ku bïï pïr akölriëëc tënë raan ëbën. ");
INSERT INTO dikNT_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Ku cïmën cï raan tök wɛ̈t Nhialic dhɔ̈l yic, ku bï kɔc juëc cɔl aala gup adumuɔ̈ɔ̈m, ke këlä aya, rin cï raan tök wɛ̈t Nhialic theek, kɔc juëc aabï la cök. ");
INSERT INTO dikNT_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Löŋ ë gɛm ë rin bï luɔi kärɛc rot juak, ku tɛ̈ ye kärɛc röt juak thïn, dhëëŋ Nhialic ë rot jäl juak apɛi. ");
INSERT INTO dikNT_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Ku cït lɔn ye adumuɔ̈ɔ̈m kɔc mac ku bïï thou tënë raan ëbën, ke yeen aya awïc Nhialic bï dhɛ̈ɛ̈ŋde kɔc mac ku looi ke bïk la cök tënë ye. Ku gɛ̈m ke pïr akölriëëc ëbën rin Jethu raan cï lɔc ku dɔc, Bänyda. ");
INSERT INTO dikNT_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Yeŋö buk lueel ëmën? Buk la tueŋ ke ɣo loi adumuɔ̈ɔ̈m rin bï dhëëŋ Nhialic yeyic juak? ");
INSERT INTO dikNT_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Acie tɛ̈dë! Acït kë cï thou tënë ɣo, aacïï ɣo bï bɛn mac. Ye këdë bï ɣok la tueŋ ɣo pïr këlä? ");
INSERT INTO dikNT_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Rin aŋiɛckë ayic lɔn riɛl adumuɔ̈ɔ̈m acï dhoŋ kɔ̈u wäär muɔɔc ɣonhïïm buk aa kɔc Jethu raan cï lɔc ku dɔc, ku ɣok aacï muɔɔc nhïïm ë thuɔnde. ");
INSERT INTO dikNT_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Ku yeen aya, wäär muɔɔc ɣonhïïm, ɣok aa ɣo cït kɔc cï la raŋ tök yic kek ye thuɔnde yic. Ku cïmën wäär cï Raan cï lɔc ku dɔc jɔt thou yic duaar Wun, ke ɣok aabï pïr ë pïr yam aya. ");
INSERT INTO dikNT_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Na cuk röt mat kek ye thuɔnde yic, ke ɣok aabï röt dhiɛl jɔt thou yic kek ye aya. ");
INSERT INTO dikNT_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Rin ɣok aa ɣo ye kɔc adumuɔ̈ɔ̈m, pïrdan thɛɛr ëcï thou tim cï rïïu kɔ̈u kek Raan cï lɔc ku dɔc, bï tɛ̈ ye ɣok kɔc adumuɔ̈ɔ̈m ciɛ̈n kë ben lëu tënë ɣo. Ku buk cïï ben aa kɔc tɔ̈ adumuɔ̈ɔ̈m yic, ");
INSERT INTO dikNT_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","rin raan cï thou acïï ben rëër riɛl adumuɔ̈ɔ̈m yic. ");
INSERT INTO dikNT_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Na ɣo cï thou kek Raan cï lɔc ku dɔc, ka yeku gam aya lɔn bï ɣok pïr kek ye. ");
INSERT INTO dikNT_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Rin aŋicku lɔn na cï Raan cï lɔc ku dɔc jɔt thou yic, ka cïï ben thou, rin thou acïï ben la riɛl tënë ye. ");
INSERT INTO dikNT_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Acï thou arak tök rin kɔc ëbën bï riɛl adumuɔ̈ɔ̈m nyaai, ku piɛ̈rde ëmën ë pïr mit Nhialic puɔ̈u tënë ye. ");
INSERT INTO dikNT_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Këlä aya, yakë röt cɔl aacït kɔc cï thou tënë adumuɔ̈ɔ̈m, ku wek aacï pïr tënë Nhialic rin Raan cï lɔc ku dɔc Jethu. ");
INSERT INTO dikNT_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Duɔ̈kkë adumuɔ̈ɔ̈m cɔl amɛc piɛ̈rdun bäk ke aa theek kärɛc wïc guäpkun. ");
INSERT INTO dikNT_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Ku duɔ̈kkë guäpkun pɛ̈l adumuɔ̈ɔ̈m bï ya kärɛc kek yakë ke looi. Wek aa dhil röt thɔ̈n Nhialic, ciɛ̈t we kɔc cï thou cï bɛn pïr. Wek aa dhil guäpkun thɔ̈n Nhialic ku bäk aa kɔcken ye looi kë la cök. ");
INSERT INTO dikNT_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Adumuɔ̈ɔ̈m acïï we dhil mac rin wek aacïï ŋoot löŋ thɛɛr yic, wek aatɔ̈ dhëëŋ Nhialic yic. ");
INSERT INTO dikNT_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Ye kë pïïr ɣok ë dhëëŋ Nhialic ke cie löŋ, ɣook puɔ̈l buk adumuɔ̈ɔ̈m aa looi ë path? Acie tɛ̈de! ");
INSERT INTO dikNT_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Aŋiɛckë alanden lɔn na thɔ̈nkë röt raan dɛ̈t ku yakë theek we cït aloony, ke wek aa loony ë raan kënë cɔk bɛn adumuɔ̈ɔ̈m we ɣäth thou yic, ku këya, thɛkkë Nhialic bäk la cök tënë ye. ");
INSERT INTO dikNT_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Lecku Nhialic, rin wek aa we ye aloony adumuɔ̈ɔ̈m, ke wek aacï yith yakë yök käk ye piɔ̈ɔ̈c tënë we yiic, gam piäthkun ëbën. ");
INSERT INTO dikNT_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Wek aacï wɛ̈ɛ̈r bei adumuɔ̈ɔ̈m yic, ku wek aacï ya aloony luɔi käk la cök. ");
INSERT INTO dikNT_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Ɣɛn ajam këlä ë path cïmën tɛ̈dun ye wek jiɛɛm thïn, rin bï wek kë luɛɛl deet yic. Cïmën wek aa we ye guäpkun ëbën thɔ̈n luɔi kärɛc rin cï luɔiden we rum puɔ̈th. Ëmën, wek aa dhil röt cɔl aaye aloony käk la cök rin luɔi këpath. ");
INSERT INTO dikNT_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Wäär ye wek aloony adumuɔ̈ɔ̈m, wek aa we cie diɛɛr luɔi la cök. ");
INSERT INTO dikNT_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Yeŋö kën cäk yök luɔi ë käkkä yiic, käk ye wek gup yär thïn ëmën? Käkkä, ee thou yen ë yakë yök thïn. ");
INSERT INTO dikNT_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Ku ëmën, wek aacï wɛ̈ɛ̈r bei adumuɔ̈ɔ̈m yic, ku wek aacï ya aloony Nhialic. Ku piɛ̈rdun ëbën ë këde, ku kë yakë yök thïn ë pïr akölriëëc ëbën. ");
INSERT INTO dikNT_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Rin kë ye yök luɔi adumuɔ̈ɔ̈m yic, ee thou. Ku miɔ̈c Nhialic ë pïr akölriëëc ëbën rin Raan cï lɔc ku dɔc, Jethu Bänyda. ");
INSERT INTO dikNT_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Aŋiɛc, wek aa kë luɛɛl deet yic miɛ̈thakäi cï gam rin wek aa ŋic löŋ. Löŋ ë la riɛl bï raan dɔm tɛ̈ ŋot pïïr yen. ");
INSERT INTO dikNT_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Tɛ̈ thööŋ ɣok ye, ke tiŋ cï thiaak acïï löŋ ye puɔ̈l bï wïc mony dɛ̈t. Ku na thou muɔnyde ka cïn löŋ ben ye gël. ");
INSERT INTO dikNT_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Na wïc mony dɛ̈t ke muɔnyde pïr, ka cï ya tiŋ cï kɔɔr. Ku na cï moc thou, ke löŋ gël yeen aliu. Na thiɛɛk mony dɛ̈t ka cïn akɔr. ");
INSERT INTO dikNT_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Ku ë yen tɛ̈de aya tënë we miɛ̈thakäi cï gam. Tɛ̈ thöŋ ɣok ye löŋ, ke wek aa cït kɔc cï thou tënë löŋ rin wek abaŋ guɔ̈p Raan cï lɔc ku dɔc. Ku ëmën wek aa kacke yen raan cï jɔt thou yic, rin bï wek aa kɔc puɔth loi wɛ̈t Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Wäär ŋot pïïr ɣok ciɛɛŋdan thɛɛr cï ɣo cak thïn, kärɛc ke cï löŋ tääu ɣopuɔ̈th aake lui apɛi ɣogup. Ku aa käk thou kek aake yeku ke looi ëbën. ");
INSERT INTO dikNT_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Ku ëmën ɣok aacï bɛ̈n bei löŋ thɛɛr yic rin cï ɣok thou tënë löŋ wäär yen mɛc ɣo. Ku ɣok aa jɔl luui dhël yam Wëi Nhialic, ku acie löŋ thɛɛr cï gɔ̈t. ");
INSERT INTO dikNT_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Yeŋö buk jäl lueel ëmën? Ye löŋ yen adumuɔ̈ɔ̈m? Acie tɛ̈de! Na ye këya ayic, ŋuɔ̈t ɣɛn akëc adumuɔ̈ɔ̈m ŋic tɛ̈n cïï yen ye löŋ. Rin ŋuɔ̈t akëc ŋic yen kërɛɛc wïny kënë raandä yïpuɔ̈u tën këc löŋ ye lɛ̈k ɣɛn ëlä, “Duk kën raandä wïc ɣapuɔ̈u.” ");
INSERT INTO dikNT_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Ku adumuɔ̈ɔ̈m acï löŋ wel bï yen ɣɛn a duɔ̈ɔ̈ŋ ba puɔ̈u ayiëk käkkɔ̈k. Ku na cie löŋ ŋuɔ̈t acïn adumuɔ̈ɔ̈m. ");
INSERT INTO dikNT_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Wäthɛɛr, ɣɛn a ɣa ciëŋ ke ɣa kuc kë ye löŋ lueel. Ku wäär le ɣɛn löŋ ŋic, aca bɛ̈n yök ɣapuɔ̈u lɔn cï ɣɛn löŋ dhoŋ kɔ̈u ku ya raan ë thou. ");
INSERT INTO dikNT_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Aca bɛ̈n yök lɔn löŋ puɔth wën ŋiɛc ke yen bï pïr bɛ̈ɛ̈i, acï bɛ̈n a kën thou bɛ̈ɛ̈i. ");
INSERT INTO dikNT_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Ku adumuɔ̈ɔ̈m acï löŋ wel bï yen ke ɣɛn a duɔ̈ɔ̈ŋ, ku rin löŋ, ɣɛn acï adumuɔ̈ɔ̈m cɔl athou. ");
INSERT INTO dikNT_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Ku ë cïn kërɛɛc tɔ̈ löŋ yic, ee ye löŋ Nhialic la cök ku pɛth. ");
INSERT INTO dikNT_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Ye këlä, lɔn nadë ke këpath yen acï thou bɛ̈ɛ̈i tënë ɣa? Acie këya! Adumuɔ̈ɔ̈m yen ë looi ye. Acï këpath lööm bï yen thou bɛ̈ɛ̈i tënë ɣa rin bï tɛ̈rɛɛc yen thin, yen adumuɔ̈ɔ̈m tïc. Ku këlä, rin ë löŋ, adumuɔ̈ɔ̈m aye nyuɔɔth ke ye kërac apɛidït. ");
INSERT INTO dikNT_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Aŋicku löŋ ë bɛ̈n tënë Wëi Nhialic, ku ɣɛn ë raan ë path, alony adumuɔ̈ɔ̈m. ");
INSERT INTO dikNT_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Ɣɛn acie kë ya looi ye deet yic, rin ɣɛn acie kë wiëc ba looi ye looi, ku aya looi ë kë maan ba looi. ");
INSERT INTO dikNT_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Ku na luɔɔi kë cä wïc ba looi, ka ya gam lɔn löŋ apath. ");
INSERT INTO dikNT_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Këya, acie ɣɛn ë kënë looi ayic, ku adumuɔ̈ɔ̈m rɛ̈ɛ̈r ke ɣa. ");
INSERT INTO dikNT_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Aŋiɛc, acïn këpuɔth rɛ̈ɛ̈r ke ɣa, rin cït tɛ̈ cï ɣa cak thïn kek adumuɔ̈ɔ̈m. Rin na cɔk alɔn wïc ɣɛn ye ba këpath looi, ka cä ë lëu ba looi. ");
INSERT INTO dikNT_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Rin kë ya looi acie këpuɔth ya wïc ba looi, ku këya kë cïï path cä ë wïc ba looi, yen aya looi. ");
INSERT INTO dikNT_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Ëmën na ya looi kë cä wïc ba looi, ka cie ɣɛn ye looi, adumuɔ̈ɔ̈m rɛ̈ɛ̈r ke ɣɛn yen ë ye looi. ");
INSERT INTO dikNT_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Këya, aya yök lɔn luui löŋ kënë. Tɛ̈ wïc ɣɛn ye ba këpath looi, ke kë cïï path yen ë rot tɛ̈ɛ̈m thïn. ");
INSERT INTO dikNT_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Ku piändiɛ̈ guɔ̈p anhiar löŋ Nhialic, ");
INSERT INTO dikNT_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","ku ɣɛn ë löŋ dɛ̈t tïŋ ke lui ɣaguɔ̈p, löŋ cie la piny kek löŋ cï piändiɛ̈ gam. Ku yen ë ɣa cɔl aye alony adumuɔ̈ɔ̈m yen löŋ lui ɣaguɔ̈p kënë. ");
INSERT INTO dikNT_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Yeŋö be kërac ɣa yök këlä! Yeŋa bä kony guɔ̈p ɣa ɣäth thou yic? ");
INSERT INTO dikNT_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Lecku Nhialic rin cï yen Bänyda Jethu raan cï lɔc ku dɔc, cɔl akony ɣa. Këya, kënë yen ë tɛ̈diɛ̈, ɣɛn nhom piändiɛ̈ yic alony löŋ Nhialic, ku cït tɛ̈ cï ɣa cak thïn alony adumuɔ̈ɔ̈m. ");
INSERT INTO dikNT_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Ku këya, acïn awuɔ̈c ye tɛ̈m kɔc cï ya tök kek Raan cï lɔc ku dɔc Jethu, ");
INSERT INTO dikNT_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","rin löŋ yam, Wëi Nhialic ë pïr bɛ̈ɛ̈i rin Jethu raan cï lɔc ku dɔc, acä wɛ̈ɛ̈r bei löŋ adumuɔ̈ɔ̈m yic, löŋ thou. ");
INSERT INTO dikNT_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Kën këc löŋ lëu bï looi rin tɛ̈ cï ɣo cak thïn ke ɣo cïï ril rin adumuɔ̈ɔ̈m, acï Nhialic looi ë tuuc cï yen Wënde nhom tuɔ̈ɔ̈c ke ye raan cïmënda, ku bï nɔ̈k bä adumuɔ̈ɔ̈m nyaai. Ku tɛ̈ looi yen kënë, acä adumuɔ̈ɔ̈m tɔ̈ kɔc gup cɔl acïn riɛl. ");
INSERT INTO dikNT_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Kënë acï Nhialic looi rin bï luɔi wïc löŋ dhiɛl la cök ɣogup ɣok kɔc pïr Wëi Nhialic, ku acie tɛ̈ cï ɣo cak thïn. ");
INSERT INTO dikNT_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Kɔc pïr cït tɛ̈ cï ke cak thïn kek adumuɔ̈ɔ̈m, aake nhïïm yiëk käk ye tɛ̈ cï cäk ke wïc, ku kɔc pïr cït tɛ̈ wïc löŋ Wëi, aake nhïïm tääu käk wïc löŋ Wëi yiic. ");
INSERT INTO dikNT_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Tɛ̈ yïk raan yenhom luɔi käk adumuɔ̈ɔ̈m, ka thou. Ku na yïk raan yenhom kë wïc löŋ Wëi, ka yök pïr ku dɔ̈ɔ̈r. ");
INSERT INTO dikNT_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Ku raan ë la ater kek Nhialic tɛ̈ yïk yen yenhom käk luɔi adumuɔ̈ɔ̈m rin acie löŋ Nhialic ye theek, ku acïï lëu bï löŋ Nhialic theek. ");
INSERT INTO dikNT_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Ku kɔc ye theek tɛ̈ cï ɣo cak thïn aacie Nhialic cɔl amit puɔ̈u. ");
INSERT INTO dikNT_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Ku këya wek aacïï ciëŋ cït tɛ̈ cï we cak thïn, wek aa ciëŋ cït tënë löŋ Wëi tɛ̈ rëër Wëi Nhialic ke we ayic. Ku na ye raan cïï rɛ̈ɛ̈r kek Wëi Jethu raan cï lɔc ku dɔc, ka cie raande. ");
INSERT INTO dikNT_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Ku na rɛ̈ɛ̈r Raan cï lɔc ku dɔc kek we, ke guäpkun aacï thou rin adumuɔ̈ɔ̈m ku wɛ̈ikun aŋot ke pïr rin cï ke looi bïk la cök tënë Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Na Wëi Nhialic yen jɔt Jethu thou yic rɛ̈ɛ̈r kek we, ke raan jɔt Raan cï lɔc ku dɔc thou yic, ka bï guɔ̈pkun thou cɔl aa pïr rin rëër Wɛ̈ike wegup. ");
INSERT INTO dikNT_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Këya, miɛ̈thakäi ɣok aala kë dhilku looi, ku acie lɔn bï ɣok rëër pïrdan thɛɛr cï ɣo cak thïn yic. ");
INSERT INTO dikNT_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Rin na piɛ̈ɛ̈rkë cït tɛ̈ cï we cak thïn, ke wek aabï thou, ku na pälkë kärɛc yakë ke looi rin Wëi Nhialic, ke wek aabï pïr yök. ");
INSERT INTO dikNT_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Kɔc ye Wëi Nhialic nyuɔ̈ɔ̈th, aa mïth Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Rin Wëi cï Nhialic gäm we acie we cɔl aye bɛn ya aloony adumuɔ̈ɔ̈m, ku looi we bäk riɔ̈ɔ̈c. Ku Wëi Nhialic ë ɣo cɔl aye mïth Nhialic, ku wek aacï Wëi Nhialic cï we looi bäk aa miɛ̈thke yök. Ku Wëi acï ɣo cɔl aye Nhialic lɔ̈ŋ, “Wä! Wä!” ");
INSERT INTO dikNT_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Aye Wëi Nhialic guɔ̈p kek wɛ̈ikua lueel lɔn ye ɣok mïth Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Ëmën ye ɣok miɛ̈thke, ɣok aabï käkken muk tënë kacke thɔn. Ku käpuɔth muk rin Raan cï lɔc ku dɔc aya rin tɛ̈ guum ɣok cïmënde, ke duaarde abï ya këda aya. ");
INSERT INTO dikNT_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Aya tak lɔn käk yeku guum piɛ̈rda yic ëmën, aacïï kɔŋ thɔ̈ɔ̈ŋ kek duaar bï Nhialic nyuɔ̈th ɣo, duaar bï rëër kek ɣo aköldä. ");
INSERT INTO dikNT_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Käk cï Nhialic cak pinynhom ëbën aa rɛ̈ɛ̈r ke ŋɔ̈th apɛi, ke tit aköl bï Nhialic miɛ̈thke nyuɔɔth. ");
INSERT INTO dikNT_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Ku käk cï cak, kɔc pinynhom aake bï rëër ke cï puɔ̈th mum, ku aacie kek ke cïï yen tak, ee Nhialic yen loi ye këya. Ku ŋɔ̈th kënë ë ŋot tɔ̈ thïn. ");
INSERT INTO dikNT_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","Ku käk cï cak aabï waar aköldä rin bïk cïï riääk, ku bïk lääu nhomdït mïth Nhialic rɔm ke ke. ");
INSERT INTO dikNT_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Rin aŋicku agut cït ëmën, käk cï cak aa rɛ̈ɛ̈r ke dhiau ke rem, arɛɛm cït arɛɛm tiŋ rɔ̈p. ");
INSERT INTO dikNT_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Ku aacie käk cï cak ë röt, ɣok kɔc cï Wëi yök ke ye miɔ̈c tueŋ ë Nhialic, ɣok aa rëër ɣo dhiau ɣo rem puɔ̈th aya, ke ɣo tït apɛi tɛ̈ bï Nhialic ɣo luɔɔi thïn buk aa miɛ̈thke, ku cɔl guäpkua aa waar röt bïk aa yam. ");
INSERT INTO dikNT_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Rin ë ŋɔ̈th yen ë cɔl ɣo apoth, ku na yeku kë ŋɔ̈thku tïŋ, ka cie ŋɔ̈th acïn. Rin ye ŋa kë tɔ̈ kek ye ŋɔ̈ɔ̈th? ");
INSERT INTO dikNT_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Ku na yeku ŋɔ̈ɔ̈th kë cïï tɔ̈ ke ɣo, ka yeku tiit ke ɣo lir puɔ̈th. ");
INSERT INTO dikNT_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Ku cït mën aya, Wëi Nhialic ë bɛ̈n aya ku kony ɣo rin ye ɣok cïï ril, rin kuc ɣok tɛ̈ dhil ɣok Nhialic rɔ̈ɔ̈k thïn, ke yeen ë Nhialic lɔ̈ŋ riɛnkua, ku lɛ̈ŋ ke dhiau dhiën cïn wël ye teet. ");
INSERT INTO dikNT_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Ku Nhialic yen kë rɛ̈ɛ̈r raan puɔ̈u tïŋ, aŋic kë lueel Wɛ̈ike, rin Wɛ̈ike ë röök rin kacke cït tɛ̈ wïc Nhialic ye thïn. ");
INSERT INTO dikNT_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Ku aŋicku këriëëc ëbën yic, Nhialic ë luui käpath rin kɔc nhiar ye, kɔc cï cɔɔl bïk këden wïc looi. ");
INSERT INTO dikNT_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Kɔc kek cï Nhialic lɔc thɛɛr, aacï looi aya bïk ciɛ̈t Wënde, ku bï Wënde a kaai wämäthakën juëc yiic. ");
INSERT INTO dikNT_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Këya, Nhialic acï kɔc cï lɔc cɔɔl ku looi ke bïk la cök tënë ye, ku kɔc cï cɔl aala cök tënë ye aacï la duaarde aya. ");
INSERT INTO dikNT_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Këya, yeŋö buk lueel rin ë kënë? Na Nhialic akääc kek ɣo, ke yeŋa bï ɣo maan? ");
INSERT INTO dikNT_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Na Nhialic akëc Wënde nhom guɔ̈p ŋuään wäär ku cɔl athou riɛnkua ëbën. Na cï ɣo gäm Wënde, ke cïï ɣo bï gäm käŋ ëbën ë path aya? ");
INSERT INTO dikNT_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Yeŋa bï la wɛ̈t bï luɛɛl kɔc cï Nhialic lɔc gup? Ee Nhialic nhom guɔ̈p yen acï ye lueel lɔn le kek cök tënë ye. ");
INSERT INTO dikNT_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Le raan dɛ̈t lëu ye bï ke tɛ̈m awuɔ̈c? Acïn raan agut Jethu aya raan cï lɔc ku dɔc cï thou, ku jɔt raŋ yic bï bɛn pïr, ku arɛ̈ɛ̈r köŋ cuëc Nhialic, ee Nhialic lɔ̈ŋ riɛnkua. ");
INSERT INTO dikNT_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Yeŋa bï ɣo tɛ̈k bei nhiër Raan cï lɔc ku dɔc yic? Lëu aliääp, tɛ̈dë ba gum rin ye yïn raan cï gam, ayï ŋɔ̈ɔ̈ŋ, ayï riɔ̈ɔ̈c rin kärɛc, ayï lɔn bï yï nɔ̈k ba thou? ");
INSERT INTO dikNT_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Cïmën cï ye gɔ̈t athör thɛɛr wël Nhialic yic ëlä, “Rin wɛ̈tdu ɣok aa rëër käk näk ɣook yiic akɔ̈l thok ëbën, ɣok aaye looi cïmën amɛ̈l la teem röt.” ");
INSERT INTO dikNT_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Acie tɛ̈de, käkkä yiic ëbën ɣok aala riɛl dït ye ɣok käŋ tiaam rin raan yen nhiar ɣo. ");
INSERT INTO dikNT_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Rin aŋiɛc alanden lɔn acïn ke tëk ɣo bei nhiërde yic. Cɔk athou ayi pïr, cɔk atuuc nhial ayï jakrɛc, cɔk aa käk loi röt ëmën, ayi käk bï röt looi aköldä, ayï käkkɔ̈k ril. ");
INSERT INTO dikNT_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","Ayï nhial, tɛ̈dɛ̈t wërdït cök piiny, acïn kë lëu ye kuat käkkä yiic ëbën bï ɣo tɛ̈k bei nhiër Nhialic yic, yeen ë këda rin Raan cï lɔc ku dɔc, Jethu Bänyda. ");
INSERT INTO dikNT_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Kë ya lueel ë yic. Ɣɛn acie jam lueth rin ɣɛn ë raan, Raan cï lɔc ku dɔc. Aye puɔ̈ndiɛ̈n mɛc Wëi Nhialic lɛ̈k ɣa apɛi lɔn ɣɛn acïï lueth luel. ");
INSERT INTO dikNT_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Rin dak piändiɛ̈ adït apɛi, ku tɛ̈ reem piändiɛ̈ thïn rin kackiɛ̈ acie yop. Ɣɛn ajam rin kɔc kuatdiɛ̈, kɔc Itharel. ");
INSERT INTO dikNT_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Ku na lëu rot ba ke kony, ŋuɔ̈t awiëc bï Nhialic ɣa tɛ̈m awuɔ̈c ku cä ben a raan Raan cï lɔc ku dɔc. ");
INSERT INTO dikNT_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Keek aa kɔc cï Nhialic lɔc ku cɔl ke aaye kacke, ku nyuth ke duaarde ku looi dɔ̈ɔ̈r ke ke ku gɛ̈m ke löŋ. Ku nyuth ke tɛ̈ bï kek ye aa duɔɔr thïn apath. Ku yökkë käk cï Nhialic thɔ̈n ke. ");
INSERT INTO dikNT_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Keek aa ke ye kuat kɔc ŋic thɛɛr. Ku Raan cï lɔc ku dɔc, wäär cï yen jäl a raan cïmënda ë ye raan kuatden. Raan ëbën adhil Nhialic yen mɛc käŋ ëbën a leec akölriëëc ëbën. Yenakan. ");
INSERT INTO dikNT_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Acä ye lueel lɔn kë cï Nhialic thɔn akëc rot looi. Kë cï Nhialic thɔn acï rot dhiɛl looi, rin acie kɔc Itharel kek ke cï Nhialic lɔc ëbën. ");
INSERT INTO dikNT_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Acï Nhialic lueel tënë Abaram, “Aacie mïth ëbën bï dhiëëth tënë yï kek bï ya mïth Nhialic, aa mïth bï dhiëëth many Itharel kek aabï ya miɛ̈thku kek ca thɔ̈n yï.” ");
INSERT INTO dikNT_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Këya, aye kënë nyooth lɔn aacie mïth bï dhiëëth Abaram ëbën kek ke bï ya mïth Nhialic, aa mïth ke cï Nhialic thɔ̈n ye kek aake bï ya miɛ̈thke. ");
INSERT INTO dikNT_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Kënë cï Nhialic lueel akïn wäär thɔn yen wɛ̈t tënë Abaram, “Tɛ̈ le akälde bɛ̈n, ke ɣɛn abï dhuk ku Thara abï manh moc yök.” ");
INSERT INTO dikNT_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Kë cït ë wɛ̈t kënë aya, mïth Rabeka karou, wunden ë ye tök, wädïtda Ithäk. ");
INSERT INTO dikNT_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","12","Acï Nhialic lueel tënë Rabeka, “Wëndun dït yen abï ya luui tënë wëndun koor.” Acï kënë lueel rin bï nyooth lɔn kë cï yen raan tök lɔc keyiic ku pɛ̈l raan dɛ̈t, ee wïc piände ë rot bï looi këya. Nhialic ë luel wɛ̈t kënë tënë Rabeka, ke Rabeka këc mïth cak dhiëëth, ke cïn këpath ku kërɛɛc cï ŋɛk looi. Kënë cï rot looi ë kë cï Nhialic raan tök cɔɔl ku pɛ̈l raan dɛ̈t. Ku acie kënë cï ŋɛk looi kamken. ");
INSERT INTO dikNT_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Cïmën ye athör thɛɛr wël Nhialic ye lueel ëlä, “Jakop aca lɔc ku kuɛɛc Ethau.” ");
INSERT INTO dikNT_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Abï kɔc kɔ̈k aa lueel lɔn Nhialic acïn yic, ku acie tɛ̈de. ");
INSERT INTO dikNT_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Rin acï Nhialic lueel tënë Mothith ëlä, “Na wiëc ba raan dɛ̈t ŋuään, ka luɔɔi, na wiëc ba puɔ̈u löny tënë raan dɛ̈t, ka luɔɔi aya.” ");
INSERT INTO dikNT_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Këya, acie kë wïc raan, tɛ̈de kë ye looi, ee liɛr puɔ̈u ë Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Rin acï Nhialic lueel wël thɛɛr cï gɔ̈t yiic tënë bɛ̈ny Ijip ëlä, “Yïn aca looi ba ya bɛ̈ny rin bï riɛldiɛ̈ yï nyuɔɔth, rin bï kɔc pinynhom ëbën ɣa piŋ.” ");
INSERT INTO dikNT_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Këya, na wïc Nhialic bï raan ŋuään, ka looi. Ku na wïc raan dɛ̈t bï cɔl aril nhom, ka looi aya. ");
INSERT INTO dikNT_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Tɛ̈dɛ̈t ɣɛn abï raan dɛ̈t thiëëc ëlä, “Na ye yen tɛ̈ ye Nhialic luui thïn akan, ke yeŋö ye yen raan tɛ̈m awuɔ̈c? Ku yeŋa lëu ye ku bï kë wïc Nhialic jɔ̈ɔ̈ny?” ");
INSERT INTO dikNT_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Ye tak ye yïn ë ŋa ba yïnhom jääm kë cï Nhialic looi? Töny acie tiŋ cuëc ye ye thiëëc, “Yeŋö cuëëc yïn ɣa këlä?” ");
INSERT INTO dikNT_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Tiŋ cuëc töny ala yic bï tiɔp cuɛ̈ɛ̈c tɛ̈den wïc yepuɔ̈u, ee töny karou cuëëc ë tiɔm töŋ yic, amuc yen jɔ̈ɔ̈l muɔɔc ku tööny ye yen luui baai ë path. ");
INSERT INTO dikNT_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Kë cï Nhialic looi athöŋ kek ë kënë. Awïc bï riääk piände nyuɔɔth ku cɔl riɛlde aŋic. Ku ŋot pɛ̈l yepuɔ̈u piny tënë kɔc rɛɛc yen puɔ̈u thïn, kɔc rɛ̈ɛ̈r ke bï tɛ̈m awuɔ̈cdït apɛi. ");
INSERT INTO dikNT_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Ku ee wïc aya bï duaarden dït nyuɔ̈th ɣo, duaarden dït cï yen ɣo mat thïn ɣok kɔcken cï ŋuään. Ɣok kɔcken cï guiir thɛɛr buk duaarde yök. ");
INSERT INTO dikNT_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Ku ɣok kɔc cï cɔɔl ɣok aa ɣo la yiic kɔc Itharel ku kɔc cie kɔc Itharel aya. ");
INSERT INTO dikNT_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Ku kënë cï Nhialic lueel akïn, kë cï gɔ̈t athör Ɣocia yic raan käk Nhialic tïŋ, “Aba cɔɔl kackiɛ̈, tɛ̈ jiɛɛm ɣɛn kɔc cie kackiɛ̈ ayic. Aba cɔɔl kɔckiɛ̈n nhiaar, tɛ̈ jiɛɛm ɣɛn rin kɔc cä ke nhiar.” ");
INSERT INTO dikNT_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Ku tɛ̈në yen acï Nhialic ye lueel thïn ëlä, “Wek aacie kackiɛ̈, tɛ̈ɛ̈n aabï cɔɔl ka wɛ̈ɛ̈t Nhialic tɔ̈ pïr yecin.” ");
INSERT INTO dikNT_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","28","Ku Ithaya raan käk Nhialic tïŋ acï jam apɛi thɛɛr rin kɔc Itharel ëlä, “Na cɔk kɔc Itharel juëc abïk ciɛ̈t liɛɛt agör, ka kɔc lik keyiic kek aabï poth, rin Nhialic abï luk lac looi luŋ cïï yeyic dhuk tënë kɔc pinynhom ëbën.” ");
INSERT INTO dikNT_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Acït wɛ̈t cï Ithaya raan käk Nhialic tïŋ lueel wäthɛɛr ëlä, “Na Nhialic Madhɔl këc ɣook nyäŋ kɔc ë kuatda yic, ŋuɔ̈t ɣok aacï ciɛ̈t kɔc gen Thodom ku Gomora.” ");
INSERT INTO dikNT_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Kënë yen ë luɛɛl, “Ee këc kɔc cie kɔc Itharel them bïk la cök tënë Nhialic. Ku aacï Nhialic bɛ̈n cɔl aa la cök rin cï kek ye gam. ");
INSERT INTO dikNT_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Ku ëcï kɔc Itharel them bïk la cök Nhialic nhom rin thɛ̈k ë löŋ, ku acïn kë cïk bɛ̈n yök.” ");
INSERT INTO dikNT_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Ku raan dɛ̈t abï thiëc ëlä, “Yeŋö cïn yen kë cïk yök?” Acïn kë cïk yök rin acïk them bïk looi ë röt ku cïk Nhialic gam. Këya, aa cït kɔc cï kecök dɛɛny alɛl, ");
INSERT INTO dikNT_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","alel yen ye athör thɛɛr wël Nhialic jam ye ëlä, “Piɛŋkë apath, ɣɛn abä alel bï kɔc cɔl aaye kecök dɛɛny. Tɔ̈ɔ̈u Jeruthalem, alel bï kɔc cɔl awiɛ̈ɛ̈k. Ku raan bï wɛ̈tde gam acïï bï rac puɔ̈u.” ");
INSERT INTO dikNT_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Miɛ̈thakäi, kë wïc piändiɛ̈ ku rɔ̈ɔ̈kkiɛ̈ tënë Nhialic riɛnken, ee lɔn bï kɔckiɛ̈n Itharel ŋic tɛ̈ bï Nhialic ke kuɔny thïn. ");
INSERT INTO dikNT_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Alɛ̈u ba ya raan ŋic ye lɔn awïckë bïk luui apɛi bïk Nhialic cɔl amit puɔ̈u tënë ke. Ku dhël ye kek ye wïc bïk Nhialic cɔl amit puɔ̈u, acïk ye deet yic apath. ");
INSERT INTO dikNT_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Ku rin këc kek dhël ye Nhialic kɔc cɔl aala cök tënë ye deet, acïk them bïk dhël yök ë röt, dhël bï ke cɔl aala cök tënë Nhialic. Ku aa këc dhël ye Nhialic kɔc cɔl aala cök tënë ye gam. ");
INSERT INTO dikNT_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Ku Raan cï lɔc ku dɔc yen aye löŋ thök thïn. Ku këya, Nhialic ë kuat raan cï gam ëbën cɔl ala cök tënë ye. ");
INSERT INTO dikNT_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Mothith acï tɛ̈ ye kɔc la cök thïn tënë Nhialic tɛ̈ theek ë löŋ gɔ̈t ëlä, “Na loi raan kë ye löŋ lueel, ke yeen abï löŋ cɔl apïr.” ");
INSERT INTO dikNT_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Kë ye wël Nhialic cï gɔ̈t thɛɛr lueel rin bï raan la cök tënë Nhialic rin gam akïn, “Duk rot ye thiëëc, yeŋa bï la pan Nhialic.” Rin bï yen Raan cï lɔc ku dɔc la thiëëc bï bɛ̈n piny tënë ɣo. ");
INSERT INTO dikNT_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","“Duk rot ye thiëëc aya, yeŋa bï la piny.” Ku wɛ̈tde yic bï Raan cï lɔc ku dɔc la bɛ̈ɛ̈i bei kam kɔc cï thou. ");
INSERT INTO dikNT_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Kë ye wël Nhialic cï gɔ̈t thɛɛr lueel akïn, “Wɛ̈t Nhialic athiɔ̈k kek yï, arɛ̈ɛ̈r yïthok ku yïpuɔ̈u.” Ku kënë yen ë wɛ̈t töŋ yeku lɛ̈k we. ");
INSERT INTO dikNT_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Na ye lueel kɔc nhïïm ëlä, “Jethu ë Bɛ̈ny ku gam yïpuɔ̈u lɔn cï Nhialic ye jɔt thou yic, ke Nhialic abï kony. ");
INSERT INTO dikNT_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Gam ë bɛ̈n bei ɣopuɔ̈th ku cɔl ɣo aala cök tënë Nhialic, ku luɛl ye ɣok gam lueel ɣothook kɔc nhïïm aye Nhialic ɣo kony.” ");
INSERT INTO dikNT_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Cïmën cï ye gɔ̈t athör thɛɛr wël Nhialic yic ëlä, “Ku raan bï wɛ̈tde gam acïï bï rac puɔ̈u.” ");
INSERT INTO dikNT_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Kënë atɔ̈ raan ëbën thïn, rin Nhialic Bɛ̈ny athöŋ tënë kɔc ëbën, kɔc Itharel ku cie kɔc Itharel aya. Ku ë kɔc röök tënë ye ëbën gäm käjuëc path apɛi. ");
INSERT INTO dikNT_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Cïmën ye wël Nhialic cï gɔ̈t thɛɛr ye lueel ëlä, “Na le raan Bɛ̈ny cɔɔl ke yen akony Bɛ̈ny.” ");
INSERT INTO dikNT_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Ku yeen acïk bï cɔɔl ayic tɛ̈ këc kek gam. Ku keek aacïï bï gam tɛ̈ këc kek wɛ̈t piŋ. Ku wɛ̈t acïk bï piŋ tɛ̈ këc ye lɛ̈k ke. ");
INSERT INTO dikNT_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Ku bïk wɛ̈t piŋ këdë tɛ̈ cïn yen raan cï tuɔ̈c ke. Cïmën cï ye gɔ̈t athör thɛɛr wël Nhialic yic ëlä, “Ee këpath apɛi, kɔc bïï wɛ̈t puɔth yam aa bɔ̈.” ");
INSERT INTO dikNT_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Ku acie raan ëbën yen cï Wɛ̈t Puɔth Yam gam. Acï Ithaya nhom guɔ̈p lueel ëlä, “Bɛ̈ny yeŋa cï wɛ̈tda gam?” ");
INSERT INTO dikNT_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Këya, keek aa wɛ̈t kaŋ piŋ tueŋ ku jɔlkë gam. Ku wɛ̈t kënë aye piŋ tɛ̈ piööc kɔc rin Raan cï lɔc ku dɔc. ");
INSERT INTO dikNT_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Ku ë yic alanden, keek aacï wɛ̈t piŋ. Cïmën cï ye gɔ̈t athör thɛɛr wël Nhialic yic ëlä, “Wël cïk lueel apɛi aacï thiëi piny. Wël thuɔŋden aacï ɣet pinynhom ëbën.” ");
INSERT INTO dikNT_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Ku kɔc Itharel guɔ̈p ë ŋickë. Mothith nhom ke jam nyin Nhialic, yen abï ye kaŋ lueel, “Wek wundiɛ̈n Itharel, wek aaba cɔl adɔm tiɛɛl. Rin kɔc cïï cɔk a wut, wek aaba cɔl ariääk puɔ̈th rin kɔc wun cïn kë cïk deet.” ");
INSERT INTO dikNT_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Ku jam Ithaya nyin Nhialic, ku gɛi yic ëlä, “Ɣɛn acï kɔc ke cïï ɣɛn wïc yök. Ɣɛn acï rot nyuɔ̈th kɔc ke cie ɣɛn ë thiëëc.” ");
INSERT INTO dikNT_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Ku acï lɛ̈k ɣo lɔn cï Nhialic ye lueel rin kɔc Itharel ëlä, “Ɣɛn acä cin taar akɔ̈l thok ëbën tënë kɔc dhɛ̈l ɣɛn, kɔc cie wɛ̈tdiɛ̈ ye piŋ.” ");
INSERT INTO dikNT_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Kë thiëëc, cïï Nhialic kuec kacke? Acie tɛ̈de. Ɣɛn nhom guɔ̈p, ɣɛn ë raan Itharel, ɣɛn ë raan kuat Abaram, raan many Benjamin. ");
INSERT INTO dikNT_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Nhialic akëc kuec kacke, kɔc yen lɔc ke thɛɛr. Wek aa ŋic käk cï gɔ̈t athör thɛɛr wël Nhialic yic, käwäär ye Elija Nhialic cɔɔl rin kärɛc cï kɔc Itharel looi, ");
INSERT INTO dikNT_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“Bɛ̈ny, keek aacï kɔc käkku tïŋ nɔ̈k ku thurkë ariäkku piny, ee ɣɛn raan töŋ käkku tïŋ cï döŋ, ku keek awïckë bïk ɣa nɔ̈k.” ");
INSERT INTO dikNT_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Ku tɛ̈ cï Nhialic ye bɛ̈ɛ̈r thïn tënë ye akïn, “Ku ɣɛn acï röör tiim kadhorou cɔl arɛ̈ɛ̈r kek ɣa, röör këc jɔŋ cɔl Baal ye kɔc kɔ̈k cɔl aye Nhialicden kaŋ door.” ");
INSERT INTO dikNT_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Ëmën kë thöŋ kek ë kënë acï rot looi, Nhialic acï kɔc lik lɔc rin dhɛ̈ɛ̈ŋde. ");
INSERT INTO dikNT_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Nhialic acie kɔc ë lɔc rin käk cïk looi. Rin na Nhialic ë kɔc lɔc rin käk cïk ke looi, ke ŋuɔ̈t acïï dhɛ̈ɛ̈ŋde ye nyuɔɔth acïn. ");
INSERT INTO dikNT_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Ku ë yic kɔc Itharel aa këc kënë yen wïckë apɛi yök, ku aa kɔc ke cï Nhialic lɔc kek aacï ye yök. Ku Nhialic acï kɔc kɔ̈k looi bïk kë ye lueel cïï piŋ. ");
INSERT INTO dikNT_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Cïmën cï ye gɔ̈t athör thɛɛr wël Nhialic yic ëlä, “Keek aacï Nhialic looi bïk käŋ cïï ye deet yiic agut cït akölë, aacït kɔc cie piŋ ku cɔɔrkë.” ");
INSERT INTO dikNT_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Ku aye Debit lueel, “Ɣɛn ee röök tënë Nhialic lɔn bï yen ke deep ku dɔm keek yäiken yiic. Bïk wïïk bï keek tɛ̈m awuɔ̈c. ");
INSERT INTO dikNT_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Ku cɔl Nhialic keek aa la nyïn dum bïk ciɛ̈n kë yekë tïŋ. Bï käkken rɛc yekë keek looi ciɛ̈t käthiek kekɔ̈th.” ");
INSERT INTO dikNT_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Aluɛɛl piändiɛ̈ ëbën lɔn na cɔk alɔn cï kɔc Itharel kecök dɛɛny bïk wïïk, ke keek aa këc gɛ̈ɛ̈k piny. Ku rin cï kek adumuɔ̈ɔ̈m looi, ke kuɔɔny Nhialic acï bɛ̈n tënë kɔc cie kɔc Itharel. Kënë acï rot looi rin bï tiɛɛl kɔc Itharel nɔ̈k ë riɛnken. ");
INSERT INTO dikNT_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Ku rin cï kɔc Itharel adumuɔ̈ɔ̈m looi, ke kɔc kɔ̈k pinynhom aacï dɔɔc. Ku rin këc kɔc Itharel kepuɔ̈th yiëk dhël pïr, dɔ̈cdït acï gam tënë kɔc cie kɔc Itharel. Ku bï dɔ̈c jäl dït këdë tɛ̈ jɔl kɔc Itharel mɛt thïn. ");
INSERT INTO dikNT_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Kë luɛɛl ëmën ë kë lɛ̈k kɔc cie kɔc Itharel. Cïmën ye ɣɛn atuny kɔc cie kɔc Itharel, ɣɛn abï nhiam luɔi cï Nhialic yiëk ɣa ba looi. ");
INSERT INTO dikNT_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Tɛ̈dë, ke ɣɛn abï kɔc kuatdiɛ̈ cɔl adɔm tiɛɛl, ku rin luɔidiɛ̈n ca looi, Nhialic abï kɔc kɔ̈k kony keyiic. ");
INSERT INTO dikNT_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Tɛ̈wën cï Nhialic kuec ke, go kɔc kɔ̈k pinynhom cɔl aala dɔ̈ɔ̈r kek ye. Ku tɛ̈ le kɔc Itharel gam aya, ka bï ciɛ̈t kɔc cï thou cï bɛn pïr. ");
INSERT INTO dikNT_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Na gɛm raan abaŋ ayup tënë Nhialic, ka ayup ëbën ë kënë Nhialic aya. Ku na ye mei tim käk Nhialic ke kër aa käkke aya. ");
INSERT INTO dikNT_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Kër kɔ̈k tim ye com cɔl Olip aacï yɛp wei, ku nuet kër Olip cil roor ë rot tɛ̈den wën, ku jɔl dït apɛi abï ciɛ̈t Olip ye com baai, ye ŋiɛc muk apath. Këya, wek kɔc cie kɔc Itharel kɔ̈k bɛ̈n tënë kɔc Itharel, wek aa käpath yök thïn aya cïmën ye kër Olip piɛ̈rden yök tënë Olip dɛ̈t cï ye nuɛt yekɔ̈u. ");
INSERT INTO dikNT_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Këya, duɔ̈kkë kɔc cï Nhialic yɛp wei cïmën kër tim ye bui. Acïn kënë yï cɔl anhiam, acie yïn meei looi bï riɛl, ee meei yen ë yï looi ba riɛl. ");
INSERT INTO dikNT_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Abï raan dɛ̈t kamkun lueel ëlä, “Kër aacï yɛp wei rin bï ɣo nuɛt nyiɛ̈nken yiic.” ");
INSERT INTO dikNT_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Kënë ë yic. Aacï yɛp wei rin këc kek gam, ku dɔ̈ŋkë nyiɛ̈nken yiic alanden rin cï wek gam. Ku duɔ̈kkë nhiam ë kënë, riääckë kë bï bɛ̈n. ");
INSERT INTO dikNT_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Na këc Nhialic kɔc Itharel puɔ̈l bï ke cï tɛ̈m awuɔ̈c, kɔc cït kër tim cï com baai ka cïï we bï puɔ̈l aya. ");
INSERT INTO dikNT_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Ayeku tïŋ ëmën yen tɛ̈ pɛth Nhialic thïn, ku tɛ̈ yen kɔc tɛ̈m awuɔ̈c thïn. Ee kɔc ca adumuɔ̈ɔ̈m looi tɛ̈m awuɔ̈c. Ku ë piath tënë yï tɛ̈ ye yïn rëër ke yï ŋɔ̈th piathde ku looi käk ye cɔl apath puɔ̈u tënë yï. Ku na cïï kënë loi, ke Nhialic abï yï yɛp wei aya. ");
INSERT INTO dikNT_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Ku na dhuk kɔc Itharel kepuɔ̈th ciëën ku gamkë wɛ̈t Nhialic, ka dhuk tɛ̈den thɛɛr wäär yep ke wei thïn, rin alëu Nhialic bï ke bɛn dhuɔ̈k thïn. ");
INSERT INTO dikNT_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Këya, wek kɔc cie kɔc Itharel wek aa cït kër tim Olip cï yëp bei Olip cil roor kɔ̈u, ku nuëët ke kek tim Olip ye com. Kɔc Itharel aa cït tim cï com kënë, ku abï yic pial tënë Nhialic bï kër cï yɛp wei bɛn nuɛ̈ɛ̈t kek tim yëp ke bei thïn. ");
INSERT INTO dikNT_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Ala yic kɛ̈ckë kaŋ ŋic wämäthkiɛ̈ wiëc ku bäk ŋic. Na ŋiɛckë ë yiny kënë, ka cäk bï ya tak piäthkun ku luɛlkë, “Ɣok aa ŋic käŋ.” Ku yiny kënë akïn. Wɛ̈t cï kɔc kɔ̈k Itharel kuec bïk cïï gɛ̈m acïï bï tɔ̈ thïn akölaköl, abï rëër thïn ɣet aköl bï akuën kɔc cie kɔc Itharel wïc Nhialic bɛ̈n bäänyde yic tënë ye. ");
INSERT INTO dikNT_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Ku ë yen tɛ̈ bï Nhialic kɔc Itharel ëbën kuɔny thïn, cïmën ye athör thɛɛr wël Nhialic ye lueel ëlä, “Raan luäk kɔc abï bɛ̈n Jeruthalem ku nyɛɛi adumuɔ̈ɔ̈m kɔc Itharel gup. ");
INSERT INTO dikNT_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Ku lueel Nhialic, ɣɛn abï dɔ̈ɔ̈r kënë looi ke keek, tɛ̈ le ɣɛn adumuɔ̈ɔ̈mken nyaai.” ");
INSERT INTO dikNT_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Rin cï kek kuec Wɛ̈t Puɔth Yam, aacï ya kɔc ater tënë Nhialic, ku kënë acï rot wel ke ye kuɔɔny tënë we, wek kɔc cie kɔc Itharel. Ku rin cï Nhialic ke lɔc, acï wärken dït thɔn lɔn kuatden aabï ya mäthke akölaköl. ");
INSERT INTO dikNT_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Rin Nhialic acie yenhom ë waar tënë kɔc cï lɔc ku dɔɔc ke. ");
INSERT INTO dikNT_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Ku wek kɔc cie kɔc Itharel, wek aa we cï kuec Nhialic wäthɛɛr, ku ëmën wek aacï Nhialic ŋuään rin cï kɔc Itharel Nhialic dhɔ̈l. ");
INSERT INTO dikNT_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Këlä aya, rin ŋuɛ̈ɛ̈n cäk yök, ke kɔc Itharel aa dhäl Nhialic ëmën, rin bï kek ŋuɛ̈ɛ̈n yök ëmën aya. ");
INSERT INTO dikNT_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Nhialic acï kɔc ëbën cɔl aa cït kɔc cï mac rin cï kek ye dhɔ̈l guɔ̈p, ku bï ŋuäände nyuɔ̈th ke ëbën. ");
INSERT INTO dikNT_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Käpuɔth Nhialic aa juëc apɛi. Ku yeen acïn kënë ye wuɔ̈ɔ̈ŋ, aŋic käŋ ëbën. Yeŋa lëu ye bï tɛ̈ yen tɛk thïn teet yic? Acïn raan lëu ye bï tɛ̈ yen käkke luɔɔi thïn deet yic. ");
INSERT INTO dikNT_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Cïmën ye athör thɛɛr wël Nhialic ye lueel ëlä, “Acïn raan ŋic tɛ̈ ye Bɛ̈ny tɛk thïn, acïn raan lëu yeen bï Bɛ̈ny wɛ̈ɛ̈t?” ");
INSERT INTO dikNT_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","“Acïn raan lëu yeen bï Nhialic gäm këdäŋ, rin bï Nhialic yeen kɔ̈ɔ̈ny.” ");
INSERT INTO dikNT_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Rin ë Nhialic yen ë cak këriëëc ëbën, ku ë yen amuk këriëëc ëbën, ku käriëëc ëbën aa tɔ̈ thïn ë riɛnke. Ɣok aa dhil Nhialic leec akölriëëc ëbën! Yenakan. ");
INSERT INTO dikNT_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Këya miɛ̈thakäi, rin cï Nhialic ɣo nyuɔ̈th liɛr ë piände, alɛ̈k we piändiɛ̈ ëbën, tɛ̈ juër wek röt Nhialic bäk ciɛ̈t kë nɛ̈k ye, ku week ke we pïïr, ke we loi ë kënë bäk aa käkke alanden. Kënë yen ë dhël dhil wek Nhialic door wepuɔ̈th. ");
INSERT INTO dikNT_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Duɔ̈kkë tɛ̈ ye kɔc pinynhom ë tɛ̈n luui thïn ye buɔɔth yic, calkë Nhialic awar wepuɔ̈th papot, bï we gäm nhom yam ku bäk kë wïc Nhialic ŋic, ku kë wïc Nhialic ë këpɛth ye cɔl amit puɔ̈u, ku le cök. ");
INSERT INTO dikNT_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Ku rin dhëëŋ puɔth cï Nhialic yiëk ɣa, alɛ̈k we ëbën. Duɔ̈kkë ye tak lɔn ye wek kɔcdït wɛ̈r kɔc kɔ̈k ŋïny käŋ, tɛ̈n tɛ̈ rëër wek thïn ëmën wek kɔc ë path, ku ye ŋɛk rot tɔ̈ɔ̈u tɛ̈den thöŋ kek gam cï Nhialic yiëk ye. ");
INSERT INTO dikNT_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Ɣok aa le ŋɛk ke guɔ̈p, ku guɔ̈p ala käjuëc, ku käkkä aa ye tök la këden ye looi. ");
INSERT INTO dikNT_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Këlä aya, ɣok aa juëc, ku ɣok aa cït guäp tök rin ɣok aa tök kek Raan cï lɔc ku dɔc, ɣok aacï mat ë tök cïmën käk cïï thöŋ tɔ̈ guäp tök yic. ");
INSERT INTO dikNT_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Këya, ŋɛk kamkua adhil kë cï gäm ye luɔɔi tɛ̈cït tɛ̈ cï Nhialic ye gäm ye bï looi. Na ye kë cï Nhialic gäm ɣo lɔn bï ɣok wɛ̈tde lɛ̈k kɔc, ka dhilku looi tɛ̈cït tɛ̈ dïït gamdan cï Nhialic yiëk ɣo thïn. ");
INSERT INTO dikNT_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Na cï Nhialic ɣo cɔl aye kɔc luɔ̈ɔ̈i, ka dhilku kony. Na cï ɣo cɔl aye piööc, ke ɣok aa piɔ̈ɔ̈c. ");
INSERT INTO dikNT_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Na cï ɣo looi buk kɔc kɔ̈k aa dɛɛt puɔ̈th, ka dhil looi këya. Raan kë tɔ̈u kek ye tek kek kɔc kɔ̈k, adhil looi puɔ̈n biökruɛɛl. Raan cï Nhialic yiëk riɛl bï yen kɔc mac adhil looi puɔ̈u ëbën, ku raan liɛr puɔ̈u nyuɔɔth tënë kɔc kɔ̈k, adhil looi ke dal, ke mit puɔ̈u. ");
INSERT INTO dikNT_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Duɔ̈kkë röt ye nyuɔɔth ciɛ̈t we nhiar kɔc, dhiɛlkë kɔc nhiaar puɔ̈u ëbën. Mankë kërac ku muɔ̈kkë këpath riɛl. ");
INSERT INTO dikNT_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Nhiarkë röt piäthkun ëbën cïmën ŋɛk ke wämënh, ku nyuɔɔth tɛ̈ ye yïn raan dɛ̈t thɛɛk thïn, ku duk tɛ̈ bï yï thɛɛk thïn yïk yïnhom. ");
INSERT INTO dikNT_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Duɔ̈kkë röt dak, luɔ̈ɔ̈ikë apɛi. Luɔ̈ɔ̈ikë Bɛ̈ny piän tök. ");
INSERT INTO dikNT_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Rɛ̈ɛ̈rkë we mit puɔ̈th tɛ̈ cɔk kɔc kɔ̈k we jöör rin le wek ŋɔ̈th, ku rɔ̈ɔ̈kkë Nhialic akölaköl. ");
INSERT INTO dikNT_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Gämkë kɔc cï gam kë wïckë muɔ̈kkë liu tënë ke. Ku luɔrkë jɔ̈ɔ̈l bɔ̈ bääikun yiic. ");
INSERT INTO dikNT_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Rɔ̈ɔ̈kkë Nhialic rin bï yen kɔc jör we dɔɔc, ku duɔ̈kkë rɔ̈ɔ̈k tënë ye rin bï yen ke tɛ̈m awuɔ̈c. ");
INSERT INTO dikNT_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Miɛt puɔ̈u kek kɔc kɔ̈k mit puɔ̈th, ku dhiaaukë kek kɔc dhiau. ");
INSERT INTO dikNT_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Calkë ɣɛr piändun athöŋ tënë kɔc ëbën. Duɔ̈kkë nhiam, dhuɔ̈kkë röt piny ku luɔ̈ɔ̈ikë tënë kɔc kor tënë we. Ku duɔ̈kkë ye tak lɔn ë wek ŋic käŋ. ");
INSERT INTO dikNT_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Na loi raan dɛ̈t kërac tënë we, ke duɔ̈kkë col kërɛɛc dɛ̈t. Loi kë ye raan ëbën tak ke path. ");
INSERT INTO dikNT_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Luɔikë käpuɔth lɛ̈ukë ke bäk ke looi rin bï wek ŋiɛc ceŋ kek kɔc. ");
INSERT INTO dikNT_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Duɔ̈kkë këdäŋ guur mäthkiɛ̈, calkë aguur Nhialic. Rin aye Bɛ̈ny lueel athör wël thɛɛr yic ëlä, “Ɣɛn abï kërɛɛc cï kɔc kɔ̈k looi guɔ̈ɔ̈r.” ");
INSERT INTO dikNT_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Duɔ̈kkë kënë kɔŋ looi, luɔikë kë ye athör thɛɛr wël Nhialic lueel, “Na raan atɛrdu anɛ̈k cɔk, ke gäm miëth, na nɛ̈k rou, ke gäm kë dek, rin tɛ̈ looi yïn käkkä ka ba cɔl ayär guɔ̈p.” ");
INSERT INTO dikNT_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Duɔ̈kkë kërac cɔl arum wepuɔ̈th, luɔikë këpath bï wek kärɛc gɛ̈l wei. ");
INSERT INTO dikNT_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Week ëbën wek aa dhil bäny mɛc baai theek rin acïn raan kɔc mac tɛ̈ këc Nhialic ye gam bï kɔc mac. Ee Nhialic yen ë kɔc yiëk bääny. ");
INSERT INTO dikNT_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Këya, raan cie wɛ̈t bɛ̈ny mɛc baai ë gam, ee bääny cï Nhialic gam dhɔ̈l yic, ku raan loi kë cït kënë abï tɛ̈m awuɔ̈c. ");
INSERT INTO dikNT_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Rin bäny aacïï kɔc käpath looi ye riɔ̈ɔ̈c, aa kɔc kärɛc looi kek aa riɔ̈ɔ̈c ke. Ye looi këpath yen abï bɛ̈ny yï aleec. ");
INSERT INTO dikNT_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Rin yen aluui Nhialic käpath kony yen yï, ku na loi kärɛc, ke yï riɔ̈c ye rin riɛl tɔ̈ kek ye acïï muk ë path. Rin bɛ̈ny ë Nhialic luɔ̈ɔ̈i ku nyooth riääk puɔ̈u Nhialic, ku tɛ̈m kɔc kärɛc looi awuɔ̈c. Ee kɔc awuɔ̈c looi cɔl agum. ");
INSERT INTO dikNT_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Këya, wek aa dhil bäny theek ku acie rin ë wɛ̈t kënë rot, ku yeen aya aŋiɛckë wepuɔ̈th lɔn ë kë dhiɛlkë looi. ");
INSERT INTO dikNT_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Kënë yen ë wɛ̈t dhil wek ajuër tääu piny aya, rin bäny aa luui tënë Nhialic tɛ̈ looi kek luɔiden ë cök bïk kɔc mac. ");
INSERT INTO dikNT_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Tääu ajuër piny ajuër yen ba juaar tënë ke, ku nyuɔɔthkë athɛ̈ɛ̈kdun ëbën tënë bäny. ");
INSERT INTO dikNT_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Duɔ̈kkë röt cɔl akɔ̈ɔ̈ny raan dɛ̈t, kë tɔ̈ thïn ë tök yen adhil looi, ku ë kë bï wek röt nhiaar kamkun, ku raan nhiar kɔc ëbën ë kë wïc löŋ yen aye looi. ");
INSERT INTO dikNT_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Lööŋkä, “Duk akɔr loi, duk raan näk, duk cuëër, duk kënë raandä wïc yïpuɔ̈u,” lööŋkä ku lööŋ kɔ̈k aa mɛt löŋ töŋ ye lueel ëlä, “Yïn adhil kɔc ëbën nhiaar cïmën nhiɛɛr yïn rot.” ");
INSERT INTO dikNT_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Raan nhiar raan dɛ̈t ka cïn kërɛɛc ye raan kënë looi tënë ye. Këya raan nhiar kɔc kɔ̈k, ee kë wïc löŋ yen aye looi. ");
INSERT INTO dikNT_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Wek aa dhil kënë looi rin aŋiɛckë lɔn aköl dhil wek nhïïm tïr acï bɛ̈n. Rin aköl bï Nhialic ɣo kony acï thiɔ̈k ëmën tɛ̈n tɛ̈wäär tueŋ gɛm ɣok wɛ̈t. ");
INSERT INTO dikNT_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Acït lɔn nadë ke wakɔ̈u athök ku aköl abɔ̈, pälku kärɛc yeke looi muɔ̈ɔ̈th yic wakɔ̈u, ku këya lɔ̈mkë käk bï ɣo cɔl apïr apath aköl bï Jethu dhuk. ");
INSERT INTO dikNT_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Ɣok aa dhil röt mac apath cïmën kɔc ë rëër ɣɛr yic aköl cïn kë yekë thiaan. Wek aacïï röt mɛt akut luui kärɛc yic, kärɛc cïmën wiɛɛt ë määu ku wïny ë diäär. Ku duɔ̈kkë ater ye looi ku tiɛlkë röt kamkun. ");
INSERT INTO dikNT_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Lɔ̈mkë Bɛ̈ny Jethu Krïtho, bï thiääk ke we. Duɔ̈kkë wepuɔ̈th ye yiëk käk we cɔl aloi adumuɔ̈ɔ̈m, bäk kënë yen wïc piändun looi. ");
INSERT INTO dikNT_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Gamkë raan koor gamde bï rëër ke we, ku duɔ̈kkë ye teer ke ke käk yekë tak, käk cïï ril. ");
INSERT INTO dikNT_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Gam raan dɛ̈t, ee ye cɔl acam kuat miëth ë path, ku raan koor gamde acïn kuat rïŋ ye cuet. ");
INSERT INTO dikNT_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Ku raan cïn kën ye yen ke kuec bï cam, acïï raan kuec mïïth kɔ̈k dhäl guɔ̈p. Ku raan kuec mïïth kɔ̈k acïï raan cïn kën ë yen kuec bï cam ye yɔ̈ɔ̈k lɔn ë yen kërac looi, rin kë ye raan cïn kën ye yen kuec looi acï Nhialic gam. ");
INSERT INTO dikNT_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Ye yïn ë ŋa, ba kë cï alony raan dɛ̈t looi, lueel ke yic, tɛ̈dë ke cie yic? Ee wun alony yen alëu ye bï lueel lɔn le aluɔnyde cök ku lɔn cïï yen la cök. Ku yen abï la cök rin abï Bɛ̈ny cɔl ala cök. ");
INSERT INTO dikNT_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Aye kɔc kɔ̈k tak lɔn ala aköl dït tɛ̈në aakööl kɔ̈k, ku aye kɔc kɔ̈k tak lɔn akööl aa thöŋ ëbën. Ŋɛk adhil kë ye yen ye tak këya ŋic apath. ");
INSERT INTO dikNT_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Raan kën looi aye looi rin wïc yen Bɛ̈ny bï theek. Ku raan cïn kënë ë yen ke kuec bï cam, aye looi rin wïc yen ye bï athɛ̈ɛ̈k nyuɔɔth tënë Bɛ̈ny, rin ë Nhialic leec rin miëth. Ku raan kuec bï mïïth kɔ̈k cïï cam aye looi këya rin athɛ̈ɛ̈k tënë Bɛ̈ny, ku athɛ̈ɛ̈k gäm Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Acïn raan tök kamkua pïr riɛnke ë rot, ku na thou raan acie thou riɛnke ë rot. ");
INSERT INTO dikNT_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Na pïïrku ke rin Bɛ̈ny, ku na thouku, ke rin Bɛ̈ny aya. Tɛ̈ pïïr ɣok ayï tɛ̈ thou ɣok, ke ɣok aa kɔc ë Bɛ̈ny. ");
INSERT INTO dikNT_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Rin Raan cï lɔc ku dɔc acï thou ku jɔt rot bï pïr rin bï yen a Bɛ̈ny kɔc pïr ku kɔc cï thou. ");
INSERT INTO dikNT_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Ku këya, yeŋö ye wek miɛ̈thakun luɔ̈k wei, tɛ̈dë ke dhälkë gup, rin ɣook ɣodhie ɣok aabï kɔ̈ɔ̈c Nhialic nhom luk yic aköldä. ");
INSERT INTO dikNT_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Cïmën ye athör thɛɛr wël Bɛ̈ny cï gɔ̈t ye lueel ëlä, “Cïmën pïïr ɣɛn ayic, aluɛɛl alanden lɔn raan ëbën abä door. Ku abï raan ëbën lueel lɔn ye ɣɛn Nhialic.” ");
INSERT INTO dikNT_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Këya, ŋɛk ɣoyiic abï Nhialic ya tɛ̈t këden cï looi, ku ye rin ŋö yen looi yen ye. ");
INSERT INTO dikNT_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Ɣok aacïï röt dhil tëm awuɔ̈c kamkua, ku duk kë bï raan dɛ̈t cɔl aloi awuɔ̈c loi. ");
INSERT INTO dikNT_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Ku rin ye ɣɛn raan buɔth Bɛ̈ny Jethu aŋiɛc alanden lɔn acïn miëth rɛ̈ɛ̈c yetök ë rot. Ku na gɛm raan lɔn miëth arac, ka rac tënë ye. ");
INSERT INTO dikNT_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Na cɔl wämuuth arac puɔ̈u rin ciɛm yïn miëth ye tak lɔn rɛɛc yen, ka ye kë loi nyuɔɔth lɔn yeen acïï nhiar. Ku duk wämuuth cï Raan cï lɔc ku dɔc thou riɛnke rɛc miëth ye cam. ");
INSERT INTO dikNT_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Duk tɛ̈ ye yïn käkkun path luɔɔi thïn cɔl aye kɔc kɔ̈k tak lɔn rɛɛc yen. ");
INSERT INTO dikNT_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Rin bääny Nhialic acie cäm ku dëk, ee la cök ku dɔ̈ɔ̈r ku miɛt puɔ̈u ye Wëi Nhialic gam. ");
INSERT INTO dikNT_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Ku kuat raan, Raan cï lɔc ku dɔc luɔ̈ɔ̈i këlä ë Nhialic cɔl amit puɔ̈u, ku cɔl raan ëbën agam këden ye looi. ");
INSERT INTO dikNT_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Këya, adhilku them buk käk kɔc kɛ̈ɛ̈k nyaai ku loiku käk kɔc kɔ̈k kony bïk riɛl gamden yic. ");
INSERT INTO dikNT_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Na ye këya, duk kë cï Nhialic looi rɛc rin miëth, mïïth aa path ëbën. Ku na ye raan dɛ̈t cɔl aloi adumuɔ̈ɔ̈m rin kë ye cam, ka cïï path. ");
INSERT INTO dikNT_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Këpath akïn, duk rïŋ cuet ku duk mɔ̈u dek, ku duk kuat kë bï wämuuth cɔl aloi adumuɔ̈ɔ̈m loi. ");
INSERT INTO dikNT_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Këya, kë ye tak ke path ë käkkä, muk kamkun wek Nhialic. Na cïï raan ye lueel lɔn kë cï looi awuɔ̈c, tɛ̈ looi yen kë ye tak ke ye yic, ke yeen amit puɔ̈u. ");
INSERT INTO dikNT_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Ku na ye raan puɔ̈u rou tɛ̈ cɛm yen kuat mïïth kɔ̈k, ka ye Nhialic cɔl aye kërac yen looi tɛ̈ cɛm yen ye, rin acie gam yen cɔl ye aloi ë kënë. Ku na yeku këdäŋ looi ëbën ke cïn gam, ke yeen adumuɔ̈ɔ̈m. ");
INSERT INTO dikNT_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Ɣok kɔc ril ë gamda yic, ɣok aadhil kɔc cïï ril kony bïk la tueŋ kek gamden apath, ku acie kënë ɣo cɔl amit puɔ̈th yen dhilku aa looi. ");
INSERT INTO dikNT_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Ŋɛk ɣoyiic adhil wämääthdan cï gam luɔ̈i këpath, kë bï yeen cɔl amit puɔ̈u. Ɣok aa dhil kënë looi rin bï ɣok gamde cɔl adhil riɛl. ");
INSERT INTO dikNT_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Rin Raan cï lɔc ku dɔc akëc kë cï looi looi rin bï yen ke puɔ̈u miɛt, cïmën ye athör thɛɛr wël Nhialic ye lueel ëlä, “Wäär lɛt yï, lɛ̈ɛ̈t aacï bɛ̈n aa käkkiɛ̈.” ");
INSERT INTO dikNT_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Këriëëc ëbën cï gɔ̈t athör thɛɛr wël Nhialic yic ë ɣo piɔ̈ɔ̈c, rin wël thɛɛr Nhialic aa ɣo cɔl aŋɔ̈th, ku aa ɣo dɛɛt puɔ̈th. ");
INSERT INTO dikNT_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Bï Nhialic yen kɔc cɔl agum, ku deet kepuɔ̈th we yiëk dɔ̈ɔ̈r kamkun, cïmën ye wek kɔc buɔth Raan cï lɔc ku dɔc Jethu. ");
INSERT INTO dikNT_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","Rin week ëbën bäk Nhialic wun Bänyda Jethu Krïtho aa leec. ");
INSERT INTO dikNT_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Nhiarkë röt kamkun rin bï kɔc ëbën Nhialic leec, luɔikë kënë cïmën tɛ̈ cï Jethu we nhiaar thïn. ");
INSERT INTO dikNT_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Rin alɛ̈k we lɔn cï Raan cï lɔc ku dɔc a raan luui kɔc Itharel, ku nyuth ke lɔn kë cï Nhialic lueel ë yic, rin bï käk cï thɔ̈n wärkuan dït aa yith. ");
INSERT INTO dikNT_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","Ku dɛ̈t aya, bï kɔc cie kɔc Itharel cɔl aa lec Nhialic rin liɛr piände, cïmën cï ye gɔ̈t athör thɛɛr wël Nhialic yic ëlä, acï Bɛ̈ny Debit lueel, “Këya, tɛ̈ rëër ɣɛn kam kɔc cie kɔc Itharel ke wek ba gäm lɛc. Ku waak alɛɛc aba ket tënë yïïn.” ");
INSERT INTO dikNT_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Ku ben athör thɛɛr wël Nhialic lueel ëlä, “Miɛtkë puɔ̈th wek kɔc cie kɔc Itharel kek kɔc cï Nhialic lɔc.” ");
INSERT INTO dikNT_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Ku ben athör thɛɛr wël Nhialic lueel aya, “Wuɔ̈t ëbën aa dhil Bɛ̈ny leec, ku kɔc ëbën aa dhil ye leec apɛi.” ");
INSERT INTO dikNT_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Ku ben Ithaya lueel athör thɛɛr wël Nhialic yic ëlä, “Ala raan many Jethe wun Debit bï bɛ̈n. Abï Nhialic looi bï ya Bɛ̈ny kɔc cie kɔc Itharel. Ku ŋäthden abï tɔ̈ tënë yeen.” ");
INSERT INTO dikNT_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Bï Nhialic ŋɔ̈th bɛ̈ɛ̈i ku cɔl we athiäŋ miɛt puɔ̈u dït apɛi ku dɔ̈ɔ̈r, cïmën ye wek ye gam bï Wëi Nhialic we cɔl aala ŋɔ̈th dït apɛi. ");
INSERT INTO dikNT_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Wämäthkiɛ̈n cï gam, ɣɛn nhom, aŋiɛc alanden lɔn week nhïïm wek aa path apɛi, wek aa ŋic kë bäk dhiɛl looi ku alɛ̈ukë bäk röt piɔ̈ɔ̈c kamkun. ");
INSERT INTO dikNT_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Wek aca gät athöör puɔ̈u ëbën ke cïn kë muɔɔny rin käk wiëc ba ke bɛn lɛ̈k we, rin dhëëŋ cï Nhialic gäm ɣa, ");
INSERT INTO dikNT_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","ba ya raan luui Jethu Krïtho, ba luui rin kɔc cie kɔc Itharel. Ɣɛn ë luɔi käk raan Nhialic looi tɛ̈ lëk ɣɛn kɔc Wɛ̈t Puɔth Yam. Rin bï kɔc cie kɔc Itharel ciɛ̈t kë cï Nhialic door, kë cï Nhialic gam apɛi. Ku bï Wëi Nhialic ke cɔl aye kacke. ");
INSERT INTO dikNT_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Ɣɛn anhiam luɔidiɛ̈n ya luɔ̈i Nhialic, rin cï ɣɛn mat kek Raan cï lɔc ku dɔc Jethu. ");
INSERT INTO dikNT_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Ɣɛn abï jam käk cï Raan cï lɔc ku dɔc cɔl aluɔɔi ë röt, käk ya lueel ku käk ya looi aacï kɔc cie kɔc Itharel cɔl athek Nhialic, ");
INSERT INTO dikNT_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","rin käril ku käk kɔc gɔ̈i, cï Wëi looi dhël ril. Këya, ɣɔ̈n ca ke tëëk ëbën jäl Jeruthalem ku wun cɔl Dalmatia, ɣɛn acï kɔc lɛ̈k Wɛ̈t Puɔth Yam rin Raan cï lɔc ku dɔc. ");
INSERT INTO dikNT_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Kën yen tɔ̈ ɣapuɔ̈u ë tök ë path, ee lɔn ku ba kɔc lɛ̈k Wɛ̈t Puɔth Yam tɛ̈ këc rin Raan cï lɔc ku dɔc kaŋ piŋ thïn, rin bï ye cïï luel lɔn ye yen luɔi cï kɔc kɔ̈k jɔɔk yen luɔɔi. ");
INSERT INTO dikNT_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Cïmën cï ye gɔ̈t athör thɛɛr wël Nhialic yic ëlä, “Kɔc këc kaŋ lɛ̈k wɛ̈tde abïk tiŋ. Ku kɔc këc ye piŋ abïk deet yic.” ");
INSERT INTO dikNT_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Ku rin ë wɛ̈t kënë, aca them ku ɣɛn acï pëën arak juëc ba la tënë we. ");
INSERT INTO dikNT_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Ku ëmën cï ɣɛn kë luɔɔi thöl tɛ̈ rëër ɣɛn thïn tɛ̈n, ku tɛ̈ɣɔn wïc ɣɛn ye run juëc ba we la tïŋ, ");
INSERT INTO dikNT_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","aŋääth ba jäl looi ëmën. Ku ëmën le ɣɛn Ithpeen, wek aa bar ba we tïŋ. Ku awiëc bäk ɣa kony ba ɣet thïn, tɛ̈ cï ɣɛn kaŋ rëër ke we tɛ̈thin-nyɔɔt. ");
INSERT INTO dikNT_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Ëmën thiin ɣɛn ala Jeruthalem ba kuɔɔny la gam tënë kɔc Nhialic rɛ̈ɛ̈r thïn. ");
INSERT INTO dikNT_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Ku akuut kɔc cï gam tɔ̈ Mathedonia ku Gïrïk aacï puɔ̈th miɛt, ku matkë bïk wëëu juaar tënë kɔc ŋɔ̈ŋ kam kɔc Nhialic tɔ̈ Jeruthalem. ");
INSERT INTO dikNT_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Kek aa mat yeyic ë röt bïk looi këya, ku ë yic keek aa dhil kɔc ŋɔ̈ŋkä kony. Kɔc Itharel aa käpuɔth yekë yök tënë Nhialic rin wëiken rɔm kek kɔc cie kɔc Itharel. Këya, kɔc cie kɔc Itharel cï gam aa dhil kɔc Itharel cï gam kony bïk ke yiëk käk yekë wïc akölaköl rin piɛ̈rden. ");
INSERT INTO dikNT_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Tɛ̈ cï ɣɛn kënë thöl, ba ke gäm wëëu ke cï kuɔ̈ɔ̈t yiic riɛnken, ke ɣɛn abï la Ithpeen, ku wek aaba kaŋ neem ba jäl la Ithpeen. ");
INSERT INTO dikNT_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Tɛ ɣeet ɣɛn tënë we, aŋiɛc ɣɛn abï dɔ̈cdït Raan cï lɔc ku dɔc la rɔm ke we. ");
INSERT INTO dikNT_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Rin gamda tënë Bɛ̈ny Jethu raan cï kɔc ku dɔc, ku rin nhiër cï Wëi Nhialic gäm ɣo, wek aa läŋ mätkë röt ɣɛn atɛrdiɛ̈ yic bäk röök kek ɣɛn apɛi tënë Nhialic riɛnkiɛ̈. ");
INSERT INTO dikNT_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Ɣɛn arɔ̈ɔ̈k bï kɔc Judia këc wɛ̈t Jethu Krïtho gam ɣɛn cïï baŋ, ku bï kɔc Nhialic tɔ̈ Jeruthalem puɔ̈th miɛt bïk kë ca looi bï ɣɛn ke kony gam. ");
INSERT INTO dikNT_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Ku këya, na wïc Nhialic, ke ɣɛn abï bɛ̈n tënë we ke miɛt puɔ̈u, ku mitku puɔ̈th nɛ̈m bï ɣo bɛn puɔ̈ɔ̈c. ");
INSERT INTO dikNT_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Ɣɛn arɔ̈ɔ̈k bï Nhialic yen ye ɣok dɔ̈ɔ̈r yök thïn, rëër kek we ëbën. Yenakan. ");
INSERT INTO dikNT_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Awiëc ba lɛ̈k we, lɔn nyankäida Pobï luui akut kɔc cï gam Kankëria ë raan path. ");
INSERT INTO dikNT_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","Luɔrkë cïmën raan Bänyda, ku cït tɛ̈ ye kɔc Nhialic röt luɔr thïn kamken, ku yiëkkë kuat kuɔɔny bï thiëëc tënë we. Yeen ë path tënë kɔc juëc, ayï ɣɛn aya. ");
INSERT INTO dikNT_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Ɣɛn ë Prithkila ku Akuila, kɔc cï röt mät ɣa buk luui rin Jethu raan cï lɔc ku dɔc, muɔ̈ɔ̈th apɛi, ");
INSERT INTO dikNT_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","kɔc këc diɛɛr kë bï ke nɔ̈k riɛnkiɛ̈. Ɣɛn amit puɔ̈u tënë ke apɛi. Ku acie ɣɛn ë rot, akuut kɔc cie kɔc Itharel cï gam aa mit puɔ̈th aya. ");
INSERT INTO dikNT_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Ɣɛn akut kɔc cï gam, yenhom mat panden, muɔ̈ɔ̈th aya. Ɣɛn ë mäthdiɛ̈ Epanetuth, raan cï Raan cï lɔc ku dɔc kaŋ gam wun Athia, ");
INSERT INTO dikNT_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","ku Maria raan cï luui apɛi riɛnkun, aaca muɔ̈ɔ̈th aya. ");
INSERT INTO dikNT_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Andronikuth ku Juniɛth, kɔc Itharel cïmëndiɛ̈, wäär cï mac ke ɣa aaca muɔ̈th aya. Keek aa ŋic apɛi rin ye kek atuuc aya, ku kek aake kɔŋ gam tënë ɣa. ");
INSERT INTO dikNT_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Miäthdiɛ̈ tënë Ampliatuth, yeen ë mäthdiɛ̈ apɛi, ku yeen acï rot mät Bɛ̈ny. ");
INSERT INTO dikNT_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Muɔ̈th tënë Urbano, raandan lui rin Raan cï lɔc ku dɔc. Ku muɔ̈th aya tënë mäthdiɛ̈ apɛi, Ithakith. ");
INSERT INTO dikNT_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Muɔ̈th tënë Apeleth, raan cï tɛ̈ kɛ̈ɛ̈c yen thïn kek Raan cï lɔc ku dɔc nyuɔɔth käril yiic. Ku muɔ̈th tënë kɔc many Arithtobuluth. ");
INSERT INTO dikNT_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Muɔ̈th tënë Ɣërodiön raandan Itharel ku wämäthakua, kɔc cï gam many Narkithuth. ");
INSERT INTO dikNT_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Miäthdiɛ̈ tënë Tripina ku Tripotha, diäär cï luui rin Bɛ̈ny ku tënë mäthdiɛ̈ apɛi Perthith raan cï luɔidït looi rin Bɛ̈ny. ");
INSERT INTO dikNT_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Ɣɛn ë muɔ̈th tuɔ̈c Ruputh raan ŋic luɔide apɛi rin Bɛ̈ny ku tënë man, raan ɣɛn kony akölaköl ciɛ̈t ɣa ye manhde. ");
INSERT INTO dikNT_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Miäthdiɛ̈ tënë Athinkrituth, Plegon, Ɣermath, Patrobath, Ɣermath ku wämäthakua ëbën cï gam rɛ̈ɛ̈r ke ke. ");
INSERT INTO dikNT_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Muɔ̈th tënë Pilologuth ku Julia ku tënë Nerioth kek nyankën, ku tënë Olimbath ku tënë kɔc cï gam rëër kek ë tök. ");
INSERT INTO dikNT_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Miäthkë röt kamkun puɔ̈u ëbën. Akuut kɔc cï gam ëbën aa we tuɔ̈c miäthden wek akut kɔc cï gam Roma. ");
INSERT INTO dikNT_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Wek aa lɛ̈k apɛi wämäthkiɛ̈ bäk nhïïm tïr kɔc ë kɔc tek yiic, ku rɛckë kɔc nhïïm bïk gamden cïï muk apath, kɔc cïï piɔ̈ɔ̈cden ë thöŋ kek tɛ̈ cï we piɔ̈ɔ̈c thïn, duɔ̈kkë röt ye thiäk ke. ");
INSERT INTO dikNT_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Rin kɔc käkkä looi aacie luui rin Raan cï lɔc ku dɔc Bänyda, aa lui riɛnken ë röt. Aa wël mit apɛi lueel, ku aa kɔc cïn kärɛc yekë ke looi wëëŋ. ");
INSERT INTO dikNT_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Acï raan ëbën piŋ yen tɛ̈ muk wek wɛ̈t yam cäk gam thïn. Këya wek aa ɣa cɔl amit puɔ̈u apɛi. Awiëc bäk käpath ku kärɛc kaŋ ŋic, ku bäk käpath aa ŋic ku duɔ̈kkë röt cɔl aaye tɔ̈u luɔi kërac yic. ");
INSERT INTO dikNT_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Ku Nhialic yen ye ɣok dɔ̈ɔ̈r yök thïn abï riɛl jɔŋrac rac, ku cɔl adhuk wecök ciëën. Ɣɛn arɔ̈ɔ̈k bï Bänyda Jethu raan cï lɔc ku dɔc la tueŋ ke nyuth we dhɛ̈ɛ̈ŋde. ");
INSERT INTO dikNT_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Timothï, raandiɛ̈n luui ɣok ë tök, ee we tuɔ̈c miäthde, ku yen lan Lukiöth, Jathon ku Thothipater kɔckiɛ̈n Itharel. ");
INSERT INTO dikNT_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Ɣɛn Tertiath, ɣɛn raan ɣa gät wël cï Paulo lueel athör kënë yic, wek aa ya tuɔ̈c miäthdiɛ̈ ke ɣa ye raan cï gam aya. ");
INSERT INTO dikNT_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Gaiöth, raan rëër ɣɛn paande, ku yen ye akut kɔc cï gam rɔ̈m thïn, ee we tuɔ̈c miäthde. Eratuth, raan wëëu mir (akuma) mɛc gɛu muk ku wämääthda Kuartuth, aa week tuɔ̈c miäthden.  ");
INSERT INTO dikNT_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","Bï dhëëŋ Bänyda Jethu raan cï lɔc ku dɔc rëër kek week ëbën. Yenakan. ");
INSERT INTO dikNT_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Lecku Nhialic bï we looi bï gamdun riɛl. Yen ë kë ya lueel tɛ̈ lëk ɣɛn kɔc Wɛ̈t Yam rin Jethu raan cï lɔc ku dɔc, ku ë yen acï yic cï moony run juëc apɛi nyuɔɔth. ");
INSERT INTO dikNT_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","Ku ëmën käk cï kɔc käk Nhialic tïŋ gɔ̈t aacï yiny kënë cɔl aŋic kɔc juëc, acï Nhialic tɔ̈ thïn tɛ̈ɣɔn ku abï rëër thïn athɛɛr lueel bï wuɔ̈t pinynhom ëbën yic kënë dhiɛl ŋic. Këya, rin bï kɔc ëbën Nhialic gam ku thekkë. ");
INSERT INTO dikNT_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Tënë Nhialic tök, Nhialic këriëëc ëbën yic, yen ŋic käŋ, aa leec. Kënë adhil rot looi akölriëëc ëbën rin kë cï Jethu raan cï lɔc ku dɔc looi. Yenakan.");
INSERT INTO dikNT_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Athör kënë abɔ̈ tënë Paulo, raan cï cɔɔl ë wɛ̈t Nhialic bï ya atuny Jethu Krïtho, ku tënë wämääthdan cï gam Thotheneth. ");
INSERT INTO dikNT_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","Ɣɛn agɛ̈t tënë Krïthiaan rɛ̈ɛ̈r gen Korinth, kɔc cï Nhialic cɔɔl bïk aa kacke, rin cï kek mat kek Jethu Krïtho, cïmën kɔc kɔ̈k cï gam, kɔc ë Jethu door, Bänyden ku Bänyda aya. ");
INSERT INTO dikNT_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Bï Nhialic Wäda ku Bɛ̈ny Jethu Krïtho, we yiëk dhëëŋ ku dɔ̈ɔ̈r. ");
INSERT INTO dikNT_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Ɣɛn ë Nhialic ya door leec ë riɛnkun akölaköl, rin kë cï looi tënë we. Acï we nyuɔ̈th piathde, ku gɛ̈m we käjuëc yakë yök rin Jethu Krïtho. ");
INSERT INTO dikNT_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","Rin rëër wek ke we ye tök kek Raan cï lɔc ku dɔc, Nhialic acï we muɔɔc bäk käjuëc ŋiɛc aa looi cïmën ye wek kɔc lɛ̈k wɛ̈tde, ku ŋiɛckë käjuëc. ");
INSERT INTO dikNT_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","Nhialic acï wɛ̈t Raan cï lɔc ku dɔc cɔl awɛ̈i wepuɔ̈th apɛi, ");
INSERT INTO dikNT_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","ku këya acïn miɔ̈c töŋ Nhialic liu tënë we ëmën rëër wek ke we tït aköl bï Nhialic Bänyda Jethu Krïtho cɔl aben dhuk. ");
INSERT INTO dikNT_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","Ku Jethu abï we kony bï gamdun riɛl bï Nhialic we tïŋ ke we cïn gup awuɔ̈c aköl le Bänyda Jethu Krïtho dhuk. ");
INSERT INTO dikNT_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Aŋiɛckë kecïn diu, lɔn Nhialic akölaköl ë kë cï thɔn ke bï looi, looi. Ee yen acï we cɔɔl bäk aa tök kek Wënde Jethu Krïtho Bänyda. ");
INSERT INTO dikNT_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Wek aa läŋ wämäthakua rin riɛl Jethu Krïtho, bï ya wɛ̈t tök yen yakë lueel, ku bäk weyiic cïï ye tek. Matkë röt ëbën ku calkë täktäkdun aye tök. ");
INSERT INTO dikNT_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Acï kɔc kɔ̈k ë many Kulowi lɛ̈k ɣa lɔn wek aa gɔ̈th ë kamkun. ");
INSERT INTO dikNT_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Kë wiëc ba lueel akïn, aye kɔc kɔ̈k ë kamkun lueel ëlä, “Ɣok buɔth Paulo.” Ku lueel kɔc kɔ̈k, “Ɣok aa buɔth Apolo.” Ku lueel kɔc kɔ̈k, “Ɣok aa buɔth Pïtɛr.” Ku kɔc kɔ̈k, “Ɣok aa buɔth Raan cï lɔc ku dɔc.” ");
INSERT INTO dikNT_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Ye tɛ̈de bï Raan cï lɔc ku dɔc ya tek yic akuut? Ye ɣɛn Paulo ɣɛn cï thou tim cï rïïu kɔ̈u ë riɛnkun? Nadë le raan cï we muɔɔc nhïïm rin bï wek aa kɔc buɔth ɣɛn Paulo? ");
INSERT INTO dikNT_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Ɣɛn alec Nhialic rin acïn raan ca muɔɔc nhom ë kamkun, ee Krïthputh ku Gaiöth kepɛ̈c. ");
INSERT INTO dikNT_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","Këya, acï raan luel ye lɔn cï we muɔɔc nhïïm bäk aa kɔc buɔth ɣa. ");
INSERT INTO dikNT_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","(Aca bɛn tak, ɣɛn acï Ithipanath kek kacke muɔɔc nhïïm. Ku acä ye tak lɔn le yen raan dɛ̈t ca muɔɔc nhom.) ");
INSERT INTO dikNT_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Raan cï lɔc ku dɔc akëc ɣa tooc ba kɔc aa muɔɔc nhïïm. Acä tooc ba kɔc aa lɛ̈k Wɛ̈t Puɔth ë Yam. Ku lɛ̈k ke ë cök ke cie wël raan ŋic käŋ ë path, rin ba nyuɔɔth lɔn thon cï Krïtho thou tim cï rïïu kɔ̈u, ala riɛldït apɛi. ");
INSERT INTO dikNT_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Aye kɔc mär, kɔc kuc tɛ̈ bï ke kuɔny thïn tak lɔn thon cï Raan cï lɔc ku dɔc thou tim cï rïïu kɔ̈u, acïn kë ye kony tënë ke. Ku ɣook, kɔc cï luɔ̈k thon cï Raan cï lɔc ku dɔc thou tim cï rïïu kɔ̈u, ee Nhialic nyuɔɔth tɛ̈ ril yen thïn. ");
INSERT INTO dikNT_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Ku yeen acï gɔ̈t athör thɛɛr wël Nhialic yiic ëlä, “Ɣɛn abï käŋ gël bïk röt cïï loi tënë kɔc ŋic käŋ ku kɔc cï piöc apɛi.” ");
INSERT INTO dikNT_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Na ye këlä, yeŋö buk lueel rin kɔc ŋic käŋ ku kɔc cï piöc apɛi, ku kɔc ŋic teer wël ë riëëc aköl yic? Acï Nhialic nyuɔɔth lɔn ŋïny ë käŋ ë kɔckä acïn wɛ̈tde yic! ");
INSERT INTO dikNT_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Rin ŋiɛ̈ɛ̈c ë käŋ tɔ̈u kek Nhialic, akëc kɔc pinynhom ye lëu ku bïk ye ŋic cɔk alɔn ŋic kek käŋ. Ku Nhialic acï wɛ̈t yeku lɛ̈k kɔc, wɛ̈t yen ye yɔ̈ɔ̈ŋ yic, looi bï yen kɔc ye gam kony. ");
INSERT INTO dikNT_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Ku awïc kɔc Itharel bïk käril ë kɔc gɔ̈i tïŋ, käk bï ye nyuɔɔth lɔn Nhialic alui. Ku kɔc cie kɔc Itharel ë wïckë bïk käŋ aa ŋic. ");
INSERT INTO dikNT_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","Ku ɣook wɛ̈t yeku luɛɛl, ee Raan cï lɔc ku dɔc cï thou tim cï rïïu kɔ̈u cïï kɔc Itharel ye lëu bïk gam. Ku yɔ̈ɔ̈ŋ kɔc cie kɔc Itharel yic lɔn cïn yen wɛ̈tde yic. ");
INSERT INTO dikNT_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","Ku tënë kɔc cï Nhialic cɔɔl, kɔc Itharel ku kɔc cie kɔc Itharel, wɛ̈t cï Raan cï lɔc ku dɔc thou, ee riɛl Nhialic ku ŋiɛ̈ɛ̈c käŋ Nhialic nyuɔɔth. ");
INSERT INTO dikNT_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Rin kë ye tïŋ ciɛ̈t Nhialic cïn kë ŋic, aŋic käŋ apɛi ka wär raan ŋic käŋ. Ku kë ye tïŋ ciɛ̈t Nhialic cïï ril, aril apɛi ka wär riɛl ë raan. ");
INSERT INTO dikNT_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Takkë ëmën miɛ̈thakäi, we ye kɔc yïndë wäär këc Nhialic we cɔɔl bäk aa kɔc buɔth Jethu. Cït tɛ̈ cï raan cak thïn, aa kɔc lik ë kamkun kek aake ŋic käŋ, tɛ̈dë ke kek la riɛl, tɛ̈dë ke ye kɔc ke dhiëëth kɔc cï jak. ");
INSERT INTO dikNT_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Nhialic acï kɔc ye tïŋ kecïn këpɛth tɔ̈ ke ke lɔc, rin bï yen kɔc röt cɔɔl ka kɔc ŋic käŋ cɔl ayär gup. Ku lɔc kɔc ye yök ciɛ̈t ke niɔp, rin bï yen kɔc röt yök ke ril cɔl ayär gup. ");
INSERT INTO dikNT_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","Ku Nhialic acï kɔc cïï ke ye kuɛ̈ɛ̈c nhïïm lɔc, rin bï yen riɛl kɔc röt yök ke kek ye kɔc ril rac. ");
INSERT INTO dikNT_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","Ku aye kënë nyuɔɔth lɔn acïn raan lëu ye bï nhiam Nhialic nhom. ");
INSERT INTO dikNT_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Ku ë rin Nhialic yen acï wek ya kɔc Jethu Krïtho. Ku ŋiɛ̈ɛ̈c ë käŋ tɔ̈u kek Nhialic, ayeku yök tënë Jethu. Ee riɛnke yen aye ɣok la cök tënë Nhialic ku yeku kɔcken path, ku wëër ɣo bei adumuɔ̈ɔ̈mkua yiic. ");
INSERT INTO dikNT_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","Këya, acï gɔ̈t athör thɛɛr wël Nhialic yic ëlä, “Na ye raan wïc ye bï nhiam rin kë cï ye cɔl amit puɔ̈u, ka dhil nhiam rin kë cï Bɛ̈ny looi.” ");
INSERT INTO dikNT_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Wäär cï ɣɛn bɛ̈n tënë we miɛ̈thakäi, ba we bɛ̈n lɛ̈k wɛ̈t ë Nhialic cï moony, wek aa kɛ̈c bɛ̈n aa jääm wël ril ye nyooth ciɛ̈t ɣa ye raan cï piöc apɛi tënë we. ");
INSERT INTO dikNT_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Rin wäär rëër ɣɛn kek we, aca bɛ̈n tak bï ciɛ̈n dɛ̈t lɛ̈k we, ee wɛ̈t rin Jethu Krïtho, wɛ̈t cï yen thou tim cï rïïu kɔ̈u. ");
INSERT INTO dikNT_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Këya, wäär bïï ɣɛn tënë we, ɣɛn ë ɣa bɔ̈ ke ɣa cï riɔ̈ɔ̈c rin cïï ɣɛn ril. Ɣɛn ë ɣa ye lath. ");
INSERT INTO dikNT_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","Ku ɣɛn akëc piööc ku lɛ̈k kɔc Wɛ̈t Puɔth ë Yam wël puɔth ŋiɛc. Ee Nhialic yen acï ye looi bï piɔ̈ɔ̈cdiɛ̈ ku tɛ̈ ye ɣɛn kɔc lɛ̈k thïn la cök ë riɛl Wëi Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","Këya, acie wël puɔth yakë ke piŋ kek cɔl we aa gam Raan cï lɔc ku dɔc, ee riɛl Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Kë ya piɔ̈ɔ̈c ë wɛ̈t ŋiɛ̈ɛ̈c tënë kɔcdït cï gam. Ku acie ŋiɛ̈ɛ̈c tɔ̈u kek kɔc pinynhom. Tɛ̈dë ke ŋiɛ̈ɛ̈c ë käŋ tɔ̈u kek kɔc mɛ̈c ëmën, kɔc la riɛl bï riɛlden guɔ liukä. ");
INSERT INTO dikNT_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","Ŋiɛ̈ɛ̈c ë käŋ ya lueel, ee ŋiɛ̈ɛ̈c tɔ̈u kek Nhialic këc cɔl alɔc tïc tënë kɔc. Ku acï Nhialic guiir thɛɛr këc piny cak lɔn ŋiɛ̈ɛ̈c ë käŋ kënë yen abï duaar bɛ̈ɛ̈i tënë ɣo. ");
INSERT INTO dikNT_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Ku ŋiɛ̈ɛ̈c käk Nhialic kënë ë këc kɔc mɛ̈c ëmën ŋic. Na cïk ŋic ŋuɔ̈t aa këc Bɛ̈ny rɔm duaar kek Nhialic piäät tim cï rïïu kɔ̈u. ");
INSERT INTO dikNT_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Ku ë yen kë ye athör thɛɛr wël Nhialic lueel ëlä, “Acïn raan cï ye kaŋ tïŋ, acïn raan cï ye kaŋ piŋ, lɔn bï yen rot looi, yen kë cï Nhialic guiir tënë kɔc nhiar ye.” ");
INSERT INTO dikNT_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Ku aa ɣok acï Nhialic bɛ̈n cɔl aŋic käkken këc cɔl alɔc tïc riɛl ë Wɛ̈ike. Wëi Nhialic aŋic këriëëc ëbën agut käk cï Nhialic moony. ");
INSERT INTO dikNT_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Ee puɔ̈n raan rot yen ë käk ye raan tak ŋic. Këlä aya, ee Wëi Nhialic yen aŋic tɛ̈ktɛ̈k ë Nhialic ëbën. ");
INSERT INTO dikNT_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Ɣok kɔc cï gam, ɣok aacie käŋ ye tak tɛ̈cït tɛ̈ ye kɔc pinynhom, kɔc cie kɔc cï gam ke tak thïn. Ɣok aacï Wëi cï Nhialic tuɔ̈c ɣo yök. Ku acï ɣook kony buk käk cï Nhialic yiëk ɣo ya deet yiic apath. ");
INSERT INTO dikNT_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Këya, tɛ̈ jiɛɛm ɣok, ɣok aacie jam wël cï ɣo piööc tɛ̈cït tɛ̈ ŋic käŋ thïn pinynhom. Ɣok aa jam ë wël ye gäm ɣo ë Wëi Nhialic, tɛ̈ jiɛɛm ɣok käk Nhialic tënë kɔc rëër Wëi Nhialic ke ke. ");
INSERT INTO dikNT_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Raan liiu Wëi Nhialic tënë ye, acie käk ye Wëi Nhialic piɔ̈ɔ̈c ye gam, aa cïn wɛ̈tde yic tënë ye. Ku aacïï ke ye deet yiic, rin alëu raan bï piath ë käkkä ŋic tɛ̈ rëër Wëi Nhialic kek ye. ");
INSERT INTO dikNT_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Raan rëër Wëi Nhialic kek ye, alëu bï kërac ku këpath deet yic, ku acïn raan lëu bï ye jɔ̈ɔ̈ny. ");
INSERT INTO dikNT_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","Cïmën cï ye gɔ̈t athör thɛɛr wël Nhialic yic ëlä, “Yeŋa ŋic kë tɛk Bɛ̈ny? Yeŋa lëu bï yeen wɛ̈ɛ̈t?” Ku ɣok aa tak cïmën Raan cï lɔc ku dɔc. ");
INSERT INTO dikNT_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Miɛ̈thakäi le ɣok gam tök, akɛ̈c lëu ba jam tënë we tɛ̈cït tɛ̈n bï ɣɛn jiɛɛm thïn tënë kɔc rëër Wëi Nhialic ke ke. Ɣɛn a ɣa ye jam tënë we ciɛ̈t ye käk pinynhom kek yakë ke tak kepɛ̈c. Ku ciɛ̈t we ye kɔc cït mïth ë tɛ̈dun ye wek piööc kɔc cï gam dɛɛt yic thïn. ");
INSERT INTO dikNT_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Wek aa we cä gäm käk bäk ke dek ku acie miëth ril kɔ̈u, rin wek aa we këc guɔ cam miëth ril kɔ̈u. Agut cït ëmën, acäk lëu bäk liek, ");
INSERT INTO dikNT_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","rin wek aŋot we ciëŋ cïmën kɔc pinynhom kepuɔ̈th yiëk käk ye piäthken wïc. Tɛ̈ rëër tiɛɛl ë kamkun, ku yakë rëër ke ŋɛk göth ke ŋɛk cïï ye nyuɔɔth lɔn ciëŋ wek cïmën kɔc pinynhom? ");
INSERT INTO dikNT_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Ɣɛn aŋic ë kënë tɛ̈ ye ŋɛk kamkun ye lueel, “Ɣɛn abuɔth Paulo.” Ku raan dɛ̈t. “Ɣɛn abuɔth Apolo,” Ke wek aa tak cïmën kɔc këc gam. ");
INSERT INTO dikNT_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","Yeŋö Apolo ku Paulo cɔl aaye kɔc ril apɛi? Nhialic acï ɣo luɔ̈ɔ̈i buk we kony bäk gam. Ŋɛk ë kamkua ë luɔi cï Bɛ̈ny tɛ̈k ye looi. ");
INSERT INTO dikNT_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Ɣɛn acï käu com ku yor Apolo, ku ë Nhialic yen acɔl ye acil. ");
INSERT INTO dikNT_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","Raan cï këdäŋ com ku raan cï ye yor aacie kek ril. Ee Nhialic yen aril apɛi, rin ë yen acï käu cɔl acil. ");
INSERT INTO dikNT_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","Raan cï käu com ku raan cï ye yor aa thöŋ rin ɣok aa loi luɔi tök ɣodhie rin ë Nhialic. Ku Nhialic abï ŋɛk ya gäm ariöp thöŋ kek luɔiden cï looi. ");
INSERT INTO dikNT_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Rin ɣok aa cït dom luui Nhialic thïn. Wek aa cït ɣön buth Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Ɣɛn acï Nhialic gäm tëët ye ɣɛn ŋiɛc buth. Ku ë yen aye ɣɛn atën käk buth ŋiɛc jɔɔk cök, käk ye raan dɛ̈t buth thïn aya. Ku ŋɛk adhil yenhom tääu piny apath tɛ̈ buth yen thïn. ");
INSERT INTO dikNT_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","Rin Nhialic acï Jethu Krïtho yetök looi bï a yen ë jɔ̈k ë cök. Këya, acïn raan dɛ̈t ben jɔ̈k ë cök dɛ̈t bɛn yam. ");
INSERT INTO dikNT_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Kɔc aabï aleel ril apɛi lööm ku bï kek kë cï jɔɔk cök buth, ku kɔc kɔ̈k aabï luui ë tiim ku bel. ");
INSERT INTO dikNT_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","Ku kɔc aabï kë yen puɔth luɔi ë ŋɛk tïŋ aköl le Raan cï lɔc ku dɔc dhuk. Rin aköl kënë, mac abï luɔi cï looikä them ëbën, ku luɔi bï mac göök abï tïŋ. ");
INSERT INTO dikNT_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Nhialic abï raan buth kë cï jɔɔk cök ë käk cïï mac ye rac, yiëk ariöp. ");
INSERT INTO dikNT_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","Ku na le raan rɛc mac luɔide, ka cïn ariöp yök. Ku yeen nhom abï poth cïmën raan ɣööt rot bei mac yic. ");
INSERT INTO dikNT_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Cäk ŋic lɔn wek aa cït luaŋ ë Nhialic, ku Wëi arɛ̈ɛ̈r kek we? ");
INSERT INTO dikNT_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Na ye raan loi luaŋ ë Nhialic bï yic la buɔ̈ɔ̈l, ke raan kënë arɛc Nhialic. Rin luaŋ Nhialic ë këde ë rot. Ku aa wek aa ye ŋɛk ke luaŋ ë Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Acïn raan mɛth rot. Na ye raan ye tak ka wär we ŋïny ë käŋ, ka dhil rot cɔl acït raan cïï käŋ ŋic ë riëëc akölë yic, rin bï yen a raan ŋic käŋ. ");
INSERT INTO dikNT_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Kë ye kɔc akölë pinynhom tɛ̈n tak kepuɔ̈th ciɛ̈t ke ŋic käŋ, acïn ŋïny ë käŋ tɔ̈u thïn cït tɛ̈ ye Nhialic tiɛ̈ŋ ye. Cïmën cï ye gɔ̈t athör thɛɛr wël Nhialic yic ëlä, “Nhialic ë kɔc deep ŋïnyden ë käŋ yic.” ");
INSERT INTO dikNT_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","Ku acï gɔ̈t alɔŋ dɛ̈t yic ëlä, “Aŋic Bɛ̈ny lɔn tɛ̈ktɛ̈k kɔc ŋic käŋ acïn këpuɔth tɔ̈ thïn.” ");
INSERT INTO dikNT_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","Duɔ̈kkë ye nhiam lɔn buɔɔth wek ŋɛk ku ŋɛk. Käk piööc ëbën aa käkkun. ");
INSERT INTO dikNT_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","Paulo, Apolo ku Pïtɛr, këriëëc ëbën pinynhom, pïr ku thou, käk tɔ̈u thïn ëmën ku käk aköldä, käkkä ëbën, aa käkkun bï wek käpath yök thïn. ");
INSERT INTO dikNT_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","Ku week ku ɣook aatɔ̈ Raan cï lɔc ku dɔc cök. Ku Raan cï lɔc ku dɔc atɔ̈ Nhialic cök. ");
INSERT INTO dikNT_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Wek aadhil ɣo ya tïŋ ke ɣok kɔc lui rin Raan cï lɔc ku dɔc, kɔc cï Nhialic looi buk yithken cï moony luɛɛl. ");
INSERT INTO dikNT_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Kë töŋ ye wïc tënë raan lui, ee lɔn bï käk wïc bänyde ëbën bï ke looi, looi. ");
INSERT INTO dikNT_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","Ɣɛn acie diɛɛr rin acie wek la yic pinynhom tɛ̈n, tɛ̈ looi wek luk tënë ɣɛn tɛ̈dë ke ye kɔc kɔ̈k ku bäk ŋic lɔn puɔth luɔidiɛ̈ tɛ̈dë ke rac. Ku ɣɛn acie rot ye luɔ̈k yic ë rot. ");
INSERT INTO dikNT_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","Acïn kë ya tak ke ca kuɔ̈c looi. Ku kënë acie ɣɛn cɔl acïn guɔ̈p awuɔ̈c. Ee Bɛ̈ny ë rot yen abï luk looi tënë ɣa. ");
INSERT INTO dikNT_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Këya, duk raan dɛ̈t luk wei ke tɛ̈ bï ye luɔ̈k wei këc bɛ̈n. Luŋ ciëën adhil Bɛ̈ny tiit bï dhuk, yen abï kärɛc ye thiaan cɔl atiɛ̈c ku nyooth kärɛc ye puɔ̈n ŋɛk tak. Ku tɛ̈në, ŋɛk abï lɛc a yök tënë Nhialic rin käpuɔth cï looi. ");
INSERT INTO dikNT_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","Ëmën miɛ̈thakäi, käk ca ke lueel ëbën, ee ciɛ̈t ɣa jam riɛnkiɛ̈ ku Apolo, rin bï wek käk cï gɔ̈t ëlä deet yiic, “Duk käk cï gɔ̈t thɛɛr lïr nhïïm yïpuɔ̈u.” Acïn raan kamkun loi rot bï nhiam rin ë yen raan buɔth ŋɛk ku dhɛ̈l raan cïï buɔth guɔ̈p. ");
INSERT INTO dikNT_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","Yeŋa cɔl yï aye raan ŋic käŋ tënë kɔc kɔ̈k? Cie Nhialic yen gɛ̈m yï këriëëc ëbën tɔ̈ kek yï? Na ye këya, yeŋö yï cɔl anhiam ciɛ̈t käk tɔ̈ ke yï cie käk ke gɛ̈m yï. ");
INSERT INTO dikNT_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","Cäk käjuëc wiɛ̈ckë ke yök ëbën? Cï Wëi Nhialic we yiëk miɔ̈c wiɛ̈ckë ke ëbën? Cäk aa bäny mac kɔc, cɔk alɔn cïï ɣok mɛ̈c? Ee tɛ̈de, aya wïc bäk aa bäny mɛ̈c ayic, rin ku buk aa bäny ɣodhie ke we. ");
INSERT INTO dikNT_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","Aya yök ɣapuɔ̈u lɔn cï Nhialic ɣo tɔ̈ɔ̈u ciëën ɣok atuuc, cïmën kɔc cï tɛ̈m awuɔ̈c bï ɣo nɔ̈k bï käk cï cak ëbën, kɔc ku atuuc nhial aa daai ë ɣo. ");
INSERT INTO dikNT_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","Rin ye ɣok kɔc Raan cï lɔc ku dɔc, ɣok aa cïn kë ŋicku, ku wek aa ŋic käŋ tɛ̈ ye wek tök kek Raan cï lɔc ku dɔc. Ɣok aacïï ril ku wek aa ril! Ɣok aaye bui ku wek aaye leec. ");
INSERT INTO dikNT_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","Agut cït akölë, ɣok aa rɛ̈ɛ̈r ke ɣo nɛ̈k cɔk ku ɣok aa rɛ̈ɛ̈r ke ɣo nɛ̈k rou. Ɣok aa ciëŋ alɛ̈th cï riääk cï la yuɛryuɛr, ɣok aa ye biäk, ɣok aa cïn nhïïm tɛ̈ ceŋku, ɣok aa rëër ɣo kuany baai yic. ");
INSERT INTO dikNT_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","Ɣok aa luui apɛi ɣocin. Tɛ̈ wëi kɔc ɣo kärɛc, ɣok aa Nhialic thiëëc bï ke dɔɔc. Tɛ̈ bɛŋ ɣo ka yeku guum, ");
INSERT INTO dikNT_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","tɛ̈ bui ɣo, ɣok aa kɔc jääm ë wël path. Ɣok aa cït kädhie cïn këpuɔth tɔ̈u kegup ye cuat wei. ");
INSERT INTO dikNT_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","Ɣɛn acïï käkkä gɛ̈t rin bï ɣɛn we cɔl ayär gup, ë rin bï ɣɛn we lɛ̈k cïmën mïthkiɛ̈n nhiaar. ");
INSERT INTO dikNT_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","Rin na cɔk alɔn le wek kɔc juëc apɛi kony we pïrdun kɔc cï gam yic, ke wek aa cïn wurkun juëc. Rin pïrdun ye wek tök kek Raan cï lɔc ku dɔc, Jethu, ɣɛn acït wuurdun rin cï ɣɛn Wɛ̈t Puɔth Yam bɛ̈ɛ̈i tënë we. ");
INSERT INTO dikNT_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","Wek aa yɔ̈ɔ̈k bäk ɣa aa kiɛ̈ɛ̈t. ");
INSERT INTO dikNT_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","Ku rin ë wɛ̈t kënë yen atooc ɣɛn Timothï tënë we. Rin ë manhdiɛ̈ apɛi, ku aca deet puɔ̈u. Abï we cɔl aa tak yith rin tɛ̈ pïïr ɣɛn thïn, ke ɣa ye tök kek Raan cï lɔc ku dɔc, Jethu. Yithkä, kek aa ya piɔ̈ɔ̈c tënë akuut kɔc cï gam ɣɔ̈n juëc yiic. ");
INSERT INTO dikNT_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","Kɔc kɔ̈k kamkun aa tak lɔn cïï ɣɛn we bï la neem, ku këya, aacï nhiam. ");
INSERT INTO dikNT_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","Na wïc Bɛ̈ny, ke ɣɛn abï lac la ba we la neem, ku ba riɛl cï kɔckä nhiam la yök, ke cie wɛ̈t yekë lueel ë path. ");
INSERT INTO dikNT_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","Nhialic ë määcde nyuɔɔth tɛ̈ ye kɔc luui thïn ë piɛ̈rden yic, ku acie tɛ̈ ye kek jiɛɛm thïn ");
INSERT INTO dikNT_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","Yeŋö wiɛ̈ckë ba looi tɛ̈ le ɣɛn ba we la neem, bï dhiɛl a yic ba we tëm awuɔ̈c, kua ba nhiɛ̈rdiɛ̈ nyuɔ̈th we ku ŋiɛc we aa jääm. ");
INSERT INTO dikNT_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","Ëmën, yic acï kɔc kɔ̈k lɛ̈k ɣɛn lɔn raan tök akuɔ̈tdun yic, aloi adumuɔ̈ɔ̈m rac apɛi, rin ë yen tɔ̈c kek tiŋ ruɛ̈ɛ̈i kek. Na cɔk aa kɔc cie Nhialic la cök ë door, ka cïï adumuɔ̈ɔ̈m cït kënë nhiar. ");
INSERT INTO dikNT_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","Yeŋö ye wek nhiam? Kënë adhiɛlkë maan, ku wek aa dhil raan adumuɔ̈ɔ̈m cït kënë looi cuɔp wei akuɔ̈tdun yic. ");
INSERT INTO dikNT_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","Na cɔk alɔn cïï ɣɛn rɛ̈ɛ̈r kek we ke piändiɛ̈ arɛ̈ɛ̈r ke we, ku ɣɛn acï raan cï kënë looi tɛ̈m awuɔ̈c ciɛ̈t ɣa rɛ̈ɛ̈r ke we. ");
INSERT INTO dikNT_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","Tɛ̈ rɛ̈m wek rin Bänyda Jethu ke piändiɛ̈ arɛ̈ɛ̈r kek we, ku riɛl Bänyda Jethu arɛ̈ɛ̈r thïn. ");
INSERT INTO dikNT_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","Cuɔpkë raan kënë wei bï la rëër jɔŋrac cin, na cɔk alɔn rɛc yen guäpde, ke wɛ̈ike abï kony aköl bï Bänyda dhuk. ");
INSERT INTO dikNT_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","Acïï rot lëu bäk nhiam. Wek aacï kë cï lueel ëlä thɛɛr piŋ, “Lon thin koor ayup cɔl apiäär ëbën.” ");
INSERT INTO dikNT_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","Këya, nyaaikë adumuɔ̈ɔ̈m cït luɔu ku bäk bɛn aa kɔc ë gam. Ku wek aabï jäl ciɛ̈t ayum ë yam cïn yic luɔu, cïmën ŋic ɣɛn ye lɔn wek aa cït kënë alanden. Rin Raan cï lɔc ku dɔc, amiöcdan Yan ayum cïn yic luɔu acï nɔ̈k. ");
INSERT INTO dikNT_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","Tɛ̈ cɛm ɣok ayumdan Yan ayum cïn yic luɔu, ka cuk cam ke ɣo la puɔ̈th luɔi kärɛc ku adumuɔ̈ɔ̈m, käk cït ayum këc yiëk yic luɔu. Apath buk ciɛ̈n ruëëny ku loiku yic, käk cït ayum këc yiëk yic luɔu. ");
INSERT INTO dikNT_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","Aca lɛ̈k we athör wäär ca gät we yic bäk ciɛ̈n buro kek kɔc ë rëër ke wïc diäär. ");
INSERT INTO dikNT_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","Ku aacie kɔc cïï Nhialic la cök ye door, ayï kɔc dït puɔ̈th nhiar käjuëc ku cuɛ̈r, kek luɛɛl. Na ye kat tënë kɔc cït ë kɔckä, ke yïn acïï cït raan pinynhom tɛ̈n ceŋ. ");
INSERT INTO dikNT_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","Kën yen luɛɛl ë lɔn bäk ciɛ̈n buro kek wämuuth cï gam wïc ë diäär, ku nhiɛɛr kajuëc ku ye jak cï kiɛ̈ɛ̈t door, ku ye kɔc jääm gup ë lueth, ku ye wiɛɛt ë määu ku ye cuär. Duk cɔk mïth ke wämuuth cït ë kënë. ");
INSERT INTO dikNT_vpl VALUES ("C15_12","076_5_12","1CO","5","12","13","Yic akïn, acie luɔidiɛ̈ ba luk looi tënë kɔc këc gam. Ee Nhialic yen abï luk looi tënë ke. Ku cïï ye luɔidun bäk luk looi tënë kɔckun cï gam? Cïmën cï ye gɔ̈t athör thɛɛr yic ëlä, “Nyaaikë raan rac akuɔ̈tdun yic.” ");
INSERT INTO dikNT_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","Na cï raan gɔ̈th ë kamkun kek wämënhë dɛ̈t cï gam, ke ye yiɛc ŋö tɔ̈ kek ye bï yen raan la gaany tënë kɔc cie Nhialic la cök ë door, ku cïï ɣɛ̈th tënë kɔc cï gam bïk luk looi? ");
INSERT INTO dikNT_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","Cäk ŋic lɔn bï kɔc cï gam la riɛl bï kek luk looi tënë kɔc ë pinynhom? Ku na luɔikë luk tënë kɔc pinynhom, ke cäk lëu bäk käthii tɔ̈ kamkun luk? ");
INSERT INTO dikNT_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","Cäk ŋic lɔn bï ɣok luk looi tënë atuuc jɔŋrac? Na ye këya, alëuku aya buk käk röt looi piɛ̈rda yic akölë aa luk. ");
INSERT INTO dikNT_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","Na yakë la luɔ̈k cït käkkä, ke yeŋö ye wek ke ɣäth tënë kɔc këc gam bï ya kek luɔ̈kkun la looi? ");
INSERT INTO dikNT_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","Calkë röt aa thiëëc löŋ bï we rac gup. Cïn raan ŋic käŋ tɔ̈ weyiic bï käk cï wääc kam kɔc cï gam ya luk? ");
INSERT INTO dikNT_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","Ku Krïthian ë wämënh dɛ̈t ë Krïthian ɣäth tënë kɔc këc gam, bï ya kek la luk looi. ");
INSERT INTO dikNT_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","Ku rin ye wek röt ɣäth luk yic ë röt bäk käk we kɛ̈ɛ̈k la luk, aye nyooth lɔn cï ciɛɛŋ path we göök. Ee bï ŋuɛ̈ɛ̈n tënë we bäk kërɛɛc cï luɔ̈i we ya guum. Ku ë bï ŋuɛ̈ɛ̈n tënë we bäk kɔc kɔ̈k cɔl aa löm käkkun. ");
INSERT INTO dikNT_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","Alëuku buk ŋic aya lɔn ye ɣok kärɛc looi tënë kɔc kɔ̈k, agut tënë miɛ̈thakäi kuan cï gam. ");
INSERT INTO dikNT_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","Aya dhiɛl tak lɔn ŋic wek ye lɔn Nhialic acïï kɔc rɛc bï puɔ̈l bïk bäänyde rɔm kek ye. Wek aa dhil ë kënë ŋic. Kɔc luui käk bal, tɛ̈dë kɔc diäär kɔɔr, tɛ̈dë kɔc jak cï kiɛ̈ɛ̈t door, ku kɔc lööm röör kɔ̈k cït ke. ");
INSERT INTO dikNT_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","Cuɛ̈r ku kɔc kepuɔ̈th yiëk käjuëc. Kɔc wiɛɛt ë määu, ku kɔc kɔc kɔ̈k jääm gup ku kɔc käŋ tuɔ̈ɔ̈r nyïn. Kɔckä ëbën aacïï Nhialic bï puɔ̈l bïk bäänyde rɔm ke ye. ");
INSERT INTO dikNT_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","Kɔc kɔ̈k ë kamkun aake cït ë kɔckä. Bɛ̈ny Jethu Krïtho ku Wëi Nhialic acä adumuɔ̈ɔ̈m nyaai wegup, ku wek aacï jäl aa kɔc ë Nhialic, ku cɔl we aala cök kek Nhialic. ");
INSERT INTO dikNT_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","Abï raan dɛ̈t lueel ëlä, “Acïn löŋ ɣa gël ba kë wiëc cïï loi.” Ee tɛ̈de, ku këriëëc ëbën acïï path tënë yï. Alɛ̈u ba lueel lɔn cï ɣa puɔ̈l ba kuat kë wiëc looi, ku ɣɛn acïï rot loi ba ya alony käk ya ke looi. ");
INSERT INTO dikNT_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","Abï raan dɛ̈t lueel, “Miëth ë kën yäc ku yäc ë kën miëth.” Ee tɛ̈de, ku keek aabï Nhialic rac kedhie. Guɔ̈p acie luɔ̈ɔ̈i wɛ̈t bal ë path, aye luɔ̈ɔ̈i kë wïc Bɛ̈ny rin guɔ̈p ë këde. ");
INSERT INTO dikNT_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","Nhialic acï Bɛ̈ny jɔt thou yic ë riɛlde, ku abï ɣook jɔt aya ë riɛlde. ");
INSERT INTO dikNT_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","Aŋiɛckë lɔn ye guäpkun tök kek Raan cï lɔc ku dɔc. Lëu ba guɔ̈p abaŋ Raan cï lɔc ku dɔc looi bï ya guɔ̈p abaŋ a dëjök? Acïï rot lëu. ");
INSERT INTO dikNT_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","Cäk lëu bäk ŋic, mony guäpde cɔl aye kën adëjök lɔn guäpken aabï ya tök? Acï gɔ̈t athör thɛɛr wël Nhialic yic ëlä, “Ku keek karou aabï ya guäp tök.” ");
INSERT INTO dikNT_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","Ku raan rot mat kek Bɛ̈ny, ee ya tök kek ye wɛ̈ike y