﻿USE sofia;
DROP TABLE IF EXISTS sofia.dig_vpl;
CREATE TABLE dig_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES dig_vpl WRITE;
INSERT INTO dig_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Hipho mwandzo, Mlungu waumba dzulu mlunguni na dunia. ");
INSERT INTO dig_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Dunia kala taina umbo rorosi wala chitu chochosi. Seemu mbaha ya madzi kala ni jiza huphu. Na Roho wa Mlungu kala ahurire dzulu ya madzi. ");
INSERT INTO dig_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Halafu Mlungu achiamba, “Nakukale na mwanga,” na kuchikala na mwanga. ");
INSERT INTO dig_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Mlungu achiona kukala nyo mwanga ni mnono. Achiganya mwanga na jiza, ");
INSERT INTO dig_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","mwanga achiwiiha “mutsi,” na jiza achiriiha “usiku.” Kuchikala dziloni, na kuchikala ligundzu siku ya kpwandza. ");
INSERT INTO dig_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Chisha Mlungu achiamba, “Nakukale na utu ndioganya madzi ga duniani na ga dzulu.” ");
INSERT INTO dig_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Sambi Mlungu achitengeza dari yoganya madzi gokala dzulu ya dari iyo na madzi garigo photsi. Na vichikala vivyo. ");
INSERT INTO dig_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Achikuiha kura kpwahali dza dari “mlunguni.” Kuchikala ligundzu na kuchikala dziloni, na iyo ichikala ni siku ya phiri. ");
INSERT INTO dig_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Chisha Mlungu achiamba, “Madzi garigo tsini ya mlunguni nagakusanyike phamwenga, na tsi kavu ionekane.” Na vichikala vivyo. ");
INSERT INTO dig_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Mlungu achiyiiha yo tsi kavu “tsi,” na go madzi garigokala gakakusanyika phamwenga achigaiha “bahari.” Mlungu achiona vivyo ni vinono. ");
INSERT INTO dig_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Chisha Mlungu achiamba, “Tsi naimere chila aina ya mimea, mimea ivyalayo mbeyu na mihi ivyalayo matunda garigo na mbeyu.” Nayo ichikala vivyo, ");
INSERT INTO dig_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","tsi ichimera chila aina ya mimea na mihi ya matunda. Mlungu achiona vivyo ni vinono. ");
INSERT INTO dig_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Phahi kpwakala dziloni na kuchikala ligundzu siku ya hahu. ");
INSERT INTO dig_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Mlungu achiamba, “Nakukale na mianga ko mlunguni iganye mutsi na usiku ionyese ishara ya minga, siku na miaka, ");
INSERT INTO dig_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","na ingʼarire dunia kula ko mlunguni.” Na vichikala vivyo. ");
INSERT INTO dig_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Mlungu achitengeza mianga miiri mikulu. Dzuwa riale mutsi na mwezi uale usiku, na chisha achitengeza nyenyezi. ");
INSERT INTO dig_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Mlungu achiyiika mianga iyo dzulu mlunguni imwirike dunia, ");
INSERT INTO dig_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","dzuwa riale mutsi na mwezi uale usiku na piya kuganya wakati wa mwanga na wakati wa jiza. Mlungu achiviona vivyo ni vinono. ");
INSERT INTO dig_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Huno uchikala mwandzo na mwisho wa siku ya ne. ");
INSERT INTO dig_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Chisha Mlungu achiamba, “Namukale na chila aina ya viumbe mo madzini na nyama a mapha auruke ko mlunguni.” ");
INSERT INTO dig_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ndipho Mlungu achiumba madzinyama makulu ga baharini na chila aina ya chiumbe chikalacho madzini na chila aina ya nyama wa mapha. Naye Mlungu achiona kukala vivyo ni vinono. ");
INSERT INTO dig_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Achivijaliya, achiviambira, “Vyalanani muenjerezeke ili mkale anji mo baharini.” Piya Mlungu achiaambira nyama a mapha, “Namwi vyalanani muenjerezeke duniani.” ");
INSERT INTO dig_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Kuchikala dziloni na ligundzu, na iyo ichikala siku ya tsano. ");
INSERT INTO dig_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Chisha Mlungu achiamba, “Tsi naikale na viumbe virivyo moyo vya chila aina: Mifugo, viumbe vya kuhambala na nyama a tsakani.” Na vichikala vivyo. ");
INSERT INTO dig_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Mlungu achiumba nyama a tsakani a chila aina, nyama a kufuga a chila aina na viumbe vihambalavyo photsi vya chila aina. Mlungu achiona kukala vivi ni vinono. ");
INSERT INTO dig_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Chisha Mlungu achiamba, “Nahuumbe mutu kpwa mfwano wehu, ndiyeigana naswi atawale ngʼonda, nyama a mapha, nyama a kufuga dunia yosi na atawale viumbe vyosi vihambalavyo photsi.” ");
INSERT INTO dig_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Phahi Mlungu waumba mwanadamu kpwa mfwanowe mwenye, kpwa mfwanowe, Mlungu waumba mlume na mchetu. ");
INSERT INTO dig_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Mlungu achiajaliya na achiaambira, “Vyalani muenjerezeke, muyiodzaze yo tsi na muihende ikuogopheni. Mkatawale ngʼonda a baharini, nyama a mapha na chila chiumbe chiricho phapha tsi.” ");
INSERT INTO dig_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Chisha Mlungu achiamba, “Nakuphani chila aina ya mimea ilavyayo mbeyu phapha duniani na mihi ivyalayo matunda garigo na mbeyu gakale chakurya chenu. ");
INSERT INTO dig_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Viumbe vyosi virivyo duniani, nyama a mapha, na viumbe vyosi vihambalavyo, naapha nyasi na makodza maitsi ikale chakurya chao.” Navyo vichikala vivyo. ");
INSERT INTO dig_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Mlungu achilola vitu vyosi vyokala akaviumba achiona ni vinono sana. Kuchikala dziloni na kuchikala ligundzu siku ya sita. ");
INSERT INTO dig_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","2","Phahi Mlungu wamarigiza kuumba mlunguni na dunia na vyosi virivyo mumo. Kpwa hivyo, yo siku ya sabaa, waoya, bada ya kukala akamala kuhenda kazize zosi arizohenda. ");
INSERT INTO dig_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Mlungu waijaliya yo siku ya sabaa na achiihenda kukala ni takatifu, mana waoya bada ya kumala kaziye ya kuumba na kuhenda vyosi arivyokala akavihenda. ");
INSERT INTO dig_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Hivyo ndivyo vyokala wakati Mlungu phoumba dzulu mlunguni na dunia. Mwenyezi Mlungu ariphoumba mlunguni na dunia, ");
INSERT INTO dig_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","tsi kala taidzangbwemera chitu chochosi kpwa sababu Mwenyezi Mlungu kala kadzangbwereha mvula na kala takuna mutu wa kuirima. ");
INSERT INTO dig_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Ela guro kala nkutsembuka kula tsi na richitiya chinemi yo tsi. ");
INSERT INTO dig_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Mwenyezi Mlungu achiumba mwanadamu kula vumbini, achimvuvurira pumuzi za uzima pulani na yuya mutu achikala chiumbe chiricho moyo. ");
INSERT INTO dig_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Mwenyezi Mlungu achiphanda chunga phatu phoihwa Edeni, uphande wa mlairo wa dzuwa, na achimuika himo yuya mutu yemuumba. ");
INSERT INTO dig_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Mwenyezi Mlungu wameza chila aina ya mihi mizuri ivyalayo matunda manono ga kuriwa himo mundani. Kahi-kahi ya munda kala phana mihi miiri, wa uzima na muhi wa kumanyisa manono na mai. ");
INSERT INTO dig_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Phapho Edeni phatuluka muho ambao watiya chinemi mundani, halafu hiko mbere muho hinyo waganyika myuho mine. ");
INSERT INTO dig_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Muho wa kpwandza unaihwa Pishoni, muho huno unazunguluka tsi ndzima ya Havila kuriko na zahabu. ");
INSERT INTO dig_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Zahabu ya tsi iyo ni zahabu nono. Piya kuna uvumba uihwao bedola na mawe ga samani gaihwago shohamu. ");
INSERT INTO dig_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Muho wa phiri unaihwa Gihoni; unazunguluka tsi yosi ya Kushi. ");
INSERT INTO dig_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Muho wa hahu unaihwa Tigirisi, nao unatsapa na uphande wa mlairo wa dzuwa wa tsi ya Ashuru. Na muho wa ne unaihwa Yufurati. ");
INSERT INTO dig_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Mwenyezi Mlungu kala akamuika hiye mutu ndani ya munda wa Edeni ili aurime na kuumanyirira. ");
INSERT INTO dig_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Phahi Mwenyezi Mlungu wamlagiza ye mutu achimuamba, “Matunda ga mihi ya aina zosi mundani unaweza kurya, ");
INSERT INTO dig_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ela matunda ga muhi wa kumanyisa manono na mai usigarye, kpwa mana siku ndiphogarya, kpwa kpweli undafwa.” ");
INSERT INTO dig_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Chisha Mwenyezi Mlungu achiamba, “Siyo vinono ye mutu kukala macheye, nindamutengezera myawe afwahaye kumterya.” ");
INSERT INTO dig_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Mwenyezi Mlungu kala akaumba nyama osi a tsakani na chila aina ya nyama a mapha na achimrehera hiyu mutu ili aaphe madzina. Na dzina rorosi ambaro waripha chila chiumbe chiricho moyo, ndiro rokala dzinare. ");
INSERT INTO dig_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Phahi Adamu waapha madzina nyama osi a kufuga, nyama a mapha na nyama osi a tsakani. Ela taphayaphahikana yeyesi wa kukala myawe afwahaye kumterya. ");
INSERT INTO dig_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Ndipho Mwenyezi Mlungu achimuhenda yuya mutu alale usingizi wa fungo. Na wakati kala arere, wamlavya mbavuye mwenga na achiphaziba na nyama. ");
INSERT INTO dig_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Iyo mbavu, Mwenyezi Mlungu waitengeza mchetu, achimreha kpwa yuya mlume. ");
INSERT INTO dig_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Adamu ariphomuona yuya mchetu waamba, “Ee! Sambi hiyu ni mfupha kula mwangu mifuphani, na ni mwiri kula mwangu mwirini. Yuyu andaihwa mchetu.” ");
INSERT INTO dig_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Kpwa sababu iyo, mlume andaricha ise na nine, agbwirane na mchewe, nao osi airi andakala mwiri mmwenga. ");
INSERT INTO dig_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Hiyu mutu na mchewe kala a chitsaha, ela taaonere haya. ");
INSERT INTO dig_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Kahi ya nyama osi a tsakani arioumbwa ni Mwenyezi Mlungu, nyoka ndiye yekala mlachu kuriko nyama anjina osi. Nyoka yamuuza yuya mchetu, “Hangbwe, Mlungu wakuambirani msirye matunda ga muhi wowosi muno mundani?” ");
INSERT INTO dig_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Yuya mchetu achiijibu yo nyoka achiiamba, “Hunaweza kurya matunda ga muhi wowosi phapha mundani, ");
INSERT INTO dig_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ela Mlungu waamba, ‘Msirye matunda ga muhi urio kahi-kahi ya chunga wala msiugute, mana mchirya mundafwa.’ ” ");
INSERT INTO dig_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Nyoka ichimuambira ye mchetu, “Kpweli tamundafwa! ");
INSERT INTO dig_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Mana Mlungu anamanya kukala siku mndiphorya matunda ga muhi hinyo, mundangʼalwa ni matso dza iye mmanye manono na mai.” ");
INSERT INTO dig_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Yuya mchetu ariphoona kukala nyo muhi una matunda manono ga kurya, na unatamanika kpwa kumupha mutu ikima. Phahi, wahunda matundage achirya, chisha achimupha mlumewe yekala a phamwenga, naye achirya. ");
INSERT INTO dig_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Phapho kare angʼalwa ni matso, achidzimanya kukala a chitsaha, hipho ashona makodza ga muhi uihwao mtini, achivwala. ");
INSERT INTO dig_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Iriphofika dziloni amsikira Mwenyezi Mlungu ananyendeka mo mundani. Yuya mutu na mchewe achidzifwitsa kahi ya mihi mo mundani ili Mwenyezi Mlungu asiaone. ");
INSERT INTO dig_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Mwenyezi Mlungu achimuiha yuya mutu achimuamba, “U kuphi?” ");
INSERT INTO dig_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Yuya mutu achijibu achiamba, “Nkasikira misindoyo unanyendeka mo mundani, nkaogopha, nkadzifwitsa mana ni chitsaha.” ");
INSERT INTO dig_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Mwenyezi Mlungu achimuamba, “Ni ani achiyekuambira kukala u chitsaha? Ama ukarya go matunda ga muhi nriokukahaza usirye?” ");
INSERT INTO dig_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ye mutu achiamba, “Ye mchetu uriyenipha nikale naye, ndiye achiyenipha ro tunda ra nyo muhi, nami nkarya.” ");
INSERT INTO dig_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ndipho Mwenyezi Mlungu achimuamba ye mchetu, “Ni maneno gani gano uchigohenda?” Ye mchetu achiamba, “Nyoka ndiyo ichiyonichenga, nami nikarya.” ");
INSERT INTO dig_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Ndipho Mwenyezi Mlungu achiiambira nyoka, “Kpwa kukala ukahenda hivyo, ukalaniwa kuriko nyama osi a kufuga, na kutsupa nyama osi a tsakani. Undaambala na ndani, na undarya vumbi maishago gosi. ");
INSERT INTO dig_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Nindakuhenda uwe na hiye mchetu mkale maadui, na uvyazio na uvyaziwe undakala maadui vivyo. Uvyaziwe undakufyanda chitswa, nawe undaondza jimbe.” ");
INSERT INTO dig_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Chisha Mwenyezi Mlungu achigomba na ye mchetu achimuamba, “Uwe undagaya sana wakati wa kudzivugula. Kpwa utsungu undavyala, tamaayo indakala kpwa mlumeo, naye andakutawala.” ");
INSERT INTO dig_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Chisha achimuamba yuya mlume, “Kpwa vira ukagbwira maneno ga mcheo, na ukarya tunda ra muhi ambao nákukahaza usirye matundage, vivi tsi ikalaniwa kpwa sababuyo. Kpwa jasho undarya mavunoge maishago gosi. ");
INSERT INTO dig_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Tsi indamera miya na kpwekpwe, na uwe undarya mimea ya mundani. ");
INSERT INTO dig_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Undarya jashoro, hadi ndiphofwa na kukala mitsanga tsona, kpwa mana wala mtsangani. Uwe waumbwa na mitsanga na mtsangani undauya.” ");
INSERT INTO dig_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Hiye mlume dzinare kala ndiye Adamu; naye wamuiha mchewe Hawa, mana iye ndiye ninengbwa wa anadamu osi. ");
INSERT INTO dig_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Chisha Mwenyezi Mlungu achimtengezera Adamu na mchewe nguwo za chingo na achiavwika. ");
INSERT INTO dig_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Chisha Mwenyezi Mlungu achiamba, “Sambi hiyu mwanadamu akakala dza swiswi, anamanya manono na mai. Husimriche akahunda matunda ga muhi wa uzima akarya, na akakala moyo hata kare na kare.” ");
INSERT INTO dig_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Kpwa hivyo, Mwenyezi Mlungu achimzola Adamu asikale mura munda wa Edeni, kpwa akarime tsi iyo ariyoumbirwa. ");
INSERT INTO dig_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ariphoazola, Mwenyezi Mlungu waika makerubi ko mlairo wa dzuwa wa Edeni. Chisha achiika upanga wa moho ugalukao hiku na hiku, ili kurinda njira iphiyayo kura kuriko na hura muhi wa uzima. ");
INSERT INTO dig_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adamu achikala na mchewe naye achigbwira mimba, achivyala Kaini. Hawa achiamba, “Nkaphaha mwana mlume kpwa msada wa Mwenyezi Mlungu.” ");
INSERT INTO dig_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Badaye Hawa wavyala mwana wanjina mlume, achimuiha Abeli. Ariphokala avyere, Abeli achikala mfugi wa mbuzi na mangʼondzi na Kaini achikala mkurima. ");
INSERT INTO dig_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Siku mwenga Kaini wamlavira Mwenyezi Mlungu sadaka ya mavuno ga kula mwakpwe mundani. ");
INSERT INTO dig_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abeli naye achilavya sadaka ya ana a kpwandza a kunona a mifugoye. Mwenyezi Mlungu achimkubali Abeli na sadakaye, ");
INSERT INTO dig_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ela kayamkubali Kaini na sadakaye. Gago gachimtsukiza sana Kaini naye achikundza nyusi. ");
INSERT INTO dig_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Halafu Mwenyezi Mlungu achimuamba Kaini, “Ukatsukizwa nini? Kpwa utu wani ukakundza nyusi? ");
INSERT INTO dig_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Uwe uchihenda manono, undakubaliwa. Ela usiphohenda manono, phahi dambi inakunyapira pho mryangoni. Nayo inalonda ikuvwamiye, ela uwe lazima uiturye.” ");
INSERT INTO dig_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ndipho Kaini achimuamba nduguye Abeli, “Huphiye hukawehe hiko weruni.” Ariphokala hiko weruni, Kaini achimgalukira nduguye, achimuolaga. ");
INSERT INTO dig_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Chisha Mwenyezi Mlungu achimuuza Kaini achimuamba, “Akuphi mwenenu Abeli?” Kaini achijibu achiamba, “Simanya. Kpwani mino ni mrindzi wa mwenehu?” ");
INSERT INTO dig_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Mwenyezi Mlungu achimuamba, “Mbona ukahenda dzambo dzii vino? Mlatso wa mwenenu unaniririra kula ko photsi. ");
INSERT INTO dig_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Sambi uwe ukalaniwa. Kundarima tsona tsi ambayo ikaphokera mlatso wa mwenenu, uriyemuolaga. ");
INSERT INTO dig_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Uchirima munda, kundaphaha rorosi. Undadengereka na kundakala na makalo phapha duniani.” ");
INSERT INTO dig_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kaini achimuambira Mwenyezi Mlungu, “Adabu uchiyonipha ni ngumu, sindaiweza. ");
INSERT INTO dig_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Rero unanizola phangu mundani. Unanizola nisikale phephi na uwe. Nindadengereka na sindakala na mudzi duniani, lola, yeyesi ndiyeniona andaniolaga!” ");
INSERT INTO dig_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Ela Mwenyezi Mlungu achiamba, “Si hivyo. Mutu yeyesi ndiyekuolaga, adabuye nindamriphiza kano sabaa.” Hipho, Mlungu wamtiya mola ili mutu asimuolage. ");
INSERT INTO dig_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kaini wauka matsoni pha Mwenyezi Mlungu na achendasagala tsi ya Nodi ambayo i mlairo wa dzuwa wa Edeni. ");
INSERT INTO dig_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kaini wakala na mchewe na achihenda mimba, achivyala mwana mlume, achimuiha Enoko. Kaini achidzenga mudzi achiuiha na dzina ra mwanawe, Enoko. ");
INSERT INTO dig_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enoko wavyala mwana mlume, achimuiha Iradi; na Iradi achikala isengbwa wa Mehuyaeli. Mehuyaeli wavyala mwana mlume, achimuiha Metushaeli ambaye naye wakala ni isengbwa wa Lameki. ");
INSERT INTO dig_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lameki walóla achetu airi, Ada na Sila. ");
INSERT INTO dig_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada wavyala Jabali ambaye wakala wa mwandzo wa afugi akalao mahemani. ");
INSERT INTO dig_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Nduguye kala ni Jubali; hiyu wakala wa mwandzo wa atu a kupiga ngephephe na chivoti. ");
INSERT INTO dig_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Sila naye wavyala mwana mlume aihwaye Tubali-Kaini, yekala wa kpwandza wa kuhenda chanda cha kutengeza miyo yosi ya shaba na chuma. Tubali-Kaini wakala na nduguye mchetu aihwaye Naama. ");
INSERT INTO dig_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Siku mwenga Lameki waambira achee, “Ada na Sila niphundzani! Niphundzani vinono, akazangu. Naolaga mutu yenilumiza, barobaro yenitiya chironda. ");
INSERT INTO dig_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Mutu yeyesi ndiyemuolaga Kaini andariphizwa kano sabaa, ela ndiyeniolaga mimi Lameki andariphizwa kano mirongo sabaa na sabaa.” ");
INSERT INTO dig_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adamu na Hawa avyala mwana wanjina mlume. Hawa achiamba, “Mlungu akanipha mwana wanjina badala ya Abeli yeolagbwa ni Kaini,” achimuiha Sethi. ");
INSERT INTO dig_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Sethi naye waphaha mwana mlume, achimuiha Enoshi. Hipho ndipho atu phoandza kumvoya Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","2","Hichi ndicho chivyazi cha Adamu. Mlungu ariphoumba anadamu, waaumba kpwa mfwanowe mwenye. Waumba mlume na mchetu na achiajaliya. Ariphomala kuaumba waaiha anadamu. Hivi ndivyo vivyazi vya Adamu. ");
INSERT INTO dig_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adamu ariphokala na miaka gana mwenga na mirongo mihahu, wavyala mwana mlume yeigana naye, achimuiha Sethi. ");
INSERT INTO dig_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Bada ya kuvyala Sethi, Adamu wasagala miaka magana manane na achikala akavyala ana anjina, alume na achetu. ");
INSERT INTO dig_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adamu wafwa kala ana miaka magana tisiya na mirongo mihahu. ");
INSERT INTO dig_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Sethi phofika miaka gana mwenga na tsano, wavyala mwana mlume, Enoshi. ");
INSERT INTO dig_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Bada ya kuvyala Enoshi, Sethi wasagala miaka magana manane na sabaa na achikala akavyala ana anjina, alume na achetu. ");
INSERT INTO dig_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Sethi wafwa kala ana miaka magana tisiya na kumi na mbiri. ");
INSERT INTO dig_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enoshi phofika miaka mirongo tisiya, wavyala Kenani. ");
INSERT INTO dig_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Bada ya kuvyala Kenani, Enoshi wasagala miaka magana manane na kumi na tsano na achikala akavyala ana anjina, alume na achetu. ");
INSERT INTO dig_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enoshi wafwa kala ana miaka magana tisiya na tsano. ");
INSERT INTO dig_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenani ariphokala na miaka mirongo sabaa, wavyala Mahalaleli. ");
INSERT INTO dig_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Bada ya kuvyala Mahalaleli, Kenani wasagala miaka magana manane na mirongo mine na achikala akavyala ana anjina, alume na achetu. ");
INSERT INTO dig_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenani wafwa kala ana miaka magana tisiya na kumi. ");
INSERT INTO dig_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalaleli ariphokala na miaka mirongo sita na tsano, wavyala Jaredi. ");
INSERT INTO dig_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Bada ya kuvyala Jaredi, Mahalaleli wasagala miaka magana manane na mirongo mihahu na achikala akavyala ana anjina, alume na achetu. ");
INSERT INTO dig_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalaleli wafwa kala ana miaka magana manane mirongo tisiya na tsano. ");
INSERT INTO dig_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jaredi ariphokala na miaka gana mwenga mirongo sita na mbiri, wavyala Enoko. ");
INSERT INTO dig_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Bada ya kuvyala Enoko, Jaredi wasagala miaka magana manane na achikala akavyala ana anjina, alume na achetu. ");
INSERT INTO dig_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Jaredi wafwa kala ana miaka magana tisiya mirongo sita na mbiri. ");
INSERT INTO dig_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enoko ariphokala na miaka mirongo sita na tsano, wavyala Methusela. ");
INSERT INTO dig_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Bada ya kuvyala Methusela, Enoko wasagala miaka magana mahahu, achikala na uhusiano mnono na Mlungu na kumuogopha. Naye achikala akavyala ana anjina, alume na achetu. ");
INSERT INTO dig_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Enoko wasagala miaka magana mahahu na mirongo sita na tsano. ");
INSERT INTO dig_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enoko wakala na uhusiano mnono na Mlungu. Naye kayaonekana tsona mana Mlungu wamuhala. ");
INSERT INTO dig_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Methusela ariphokala na miaka gana mwenga na mirongo minane na sabaa, wavyala Lameki. ");
INSERT INTO dig_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Bada ya kuvyala Lameki, Methusela wasagala miaka magana sabaa mirongo minane na mbiri na achikala akavyala ana anjina, alume na achetu. ");
INSERT INTO dig_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Methusela wafwa kala ana miaka magana tisiya mirongo sita na tisiya. ");
INSERT INTO dig_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lameki ariphokala na miaka gana mwenga na mirongo minane na mbiri, wavyala mwana mlume. ");
INSERT INTO dig_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Achimuiha Nuhu achiamba, “Mwana hiyu ndiye ndiyehuphoza maroho kpwa kazi zehu ngumu huzihendazo na mikono yehu kpwenye tsi yolaniwa ni Mwenyezi Mlungu.” ");
INSERT INTO dig_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Bada ya kuvyala Nuhu, Lameki wasagala miaka magana matsano mirongo tisiya na tsano na achikala akavyala ana anjina, alume na achetu. ");
INSERT INTO dig_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lameki wafwa kala ana miaka magana sabaa mirongo sabaa na sabaa. ");
INSERT INTO dig_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nuhu ariphokala na miaka magana matsano, wavyala ana ahahu alume, Shemu, Hamu na Jafeti. ");
INSERT INTO dig_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Anadamu ariphoenjerezeka duniani na kuvyarirwa ana achetu, ");
INSERT INTO dig_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","malaika aaona anono hano ana achetu a atu na achikala analóla yeyesi ndiyemtsambula. ");
INSERT INTO dig_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Mwenyezi Mlungu wagomba achiamba, “Roho yangu taindakala ndani ya mwanadamu hata kare na kare, mana iye andafwa. Kpwa hivyo sikuze zindakala miaka gana mwenga na mirongo miiri.” ");
INSERT INTO dig_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Siku zizo, na hata badaye, kpwakala na Anefili phapha duniani, madzitu gokala ni uvyazi wa malaika na ana achetu a atu. Madzitu gago ndigo gokala masujaa na genye nguma pho kare. ");
INSERT INTO dig_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Mwenyezi Mlungu ariphoona uyi wa atu unazidi phapha duniani na chila apangago mwao mioyoni ni mai wakati wosi, ");
INSERT INTO dig_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","naye Mwenyezi Mlungu wajuta kpwa kumuumba binadamu duniani. Achisikira utsungu sana mwakpwe moyoni ");
INSERT INTO dig_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","na Mwenyezi Mlungu achiamba, “Nindaangamiza anadamu nrioaumba himu duniani, na piya nyama, nyama a kuambala na nyama a mapha, kpwa mana baha kala siaumbire.” ");
INSERT INTO dig_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ela Mwenyezi Mlungu wahamirwa ni maisha ga Nuhu. ");
INSERT INTO dig_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Hino ni simurizi kuhusu Nuhu na chivyaziche. Nuhu kala ni mwenye haki na kala kana lawama kahi za atu a wakatiwe. Tsona kala anauhusiano mnono na Mlungu. ");
INSERT INTO dig_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nuhu wavyala ana ahahu alume ambao ni Shemu, Hamu na Jafeti. ");
INSERT INTO dig_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ela atu anjina osi kala ni ayi matsoni pha Mlungu, dunia kala i tele kuonerana na fujo. ");
INSERT INTO dig_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Mlungu wailola dunia na achiiona kukala ikabanangika kpwa mana chila mutu kala analunga njiraze mbii. ");
INSERT INTO dig_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Mlungu achimuambira Nuhu, “Nkakata shauri kuolaga atu osi. Nindaangamiza tse kpwa sababu dunia ikaodzala fujo, nindaangamiza na niangamize yo tsi. ");
INSERT INTO dig_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Dzitengezere meli ya mbao za mvinde, uiganye vyumba himo ndani na uipake lami ndani na kondze. ");
INSERT INTO dig_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Undaitengeza hivi: Urewe ukale mita gana mwenga na mirongo mihahu na tahu, upanawe mita mirongo miiri na mbiri na chimoche mita kumi na tahu. ");
INSERT INTO dig_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Itengeze na paa, tsona richa nafwasi ya nusu mita kahi-kahi ya paa na ubavu na chombo. Ikale ya gorofa tahu na mryangowe ukale ubavuni. ");
INSERT INTO dig_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Mimi nindareha mafuriko makulu duniani kuolaga viumbe vyosi virivyo moyo. Vitu vyosi duniani vindafwa, ");
INSERT INTO dig_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","ela nindaika ahadi yangu na uwe. Undamenya mo melini, uwe na mcheo, anao na akaza anao. ");
INSERT INTO dig_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Nawe uinjize melini viumbe viiri-viiri vya chila aina, vya chilume na vya chichetu, ili vikale moyo phamwenga na uwe. ");
INSERT INTO dig_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Chila aina ya nyama wa mapha, chila aina ya nyama, chila aina ya nyama a kuhambala andakpwedzera airi-airi ili akale moyo. ");
INSERT INTO dig_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Chisha, hala aina zosi za vyakurya, vyenu mwimwi na vya nyama.” ");
INSERT INTO dig_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nuhu achihenda chila chitu aricholagizwa ni Mlungu. ");
INSERT INTO dig_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Halafu Mwenyezi Mlungu achimuambira Nuhu, “Injira melini uwe, mcheo na anao osi ili nikutivyeni, mana nkaona uwe ndiwe mutu uhendaye haki kahi ya chivyazi chichi. ");
INSERT INTO dig_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Kahi ya nyama a kuriwa, hala nyama sabaa a chilume na sabaa a chichetu. Na nyama asioriwa, hala airi, mlume na mchetu. ");
INSERT INTO dig_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Piya hala nyama a mapha a chila aina sabaa alume na sabaa achetu ili aina zao zisiangamike phapha duniani. ");
INSERT INTO dig_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Siku sabaa kuandzira rero nindareha mvula, na indanya siku mirongo mine, usiku na mutsi, ili niangamize chila chiumbe nrichochiumba phapha duniani.” ");
INSERT INTO dig_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nuhu wahenda chila chitu ambacho walagizwa ni Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nuhu kala ana miaka magana sita wakati Mlungu phoreha mafuriko duniani. ");
INSERT INTO dig_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Iye na mchewe, anae na akaza anae ainjira melini ili asedze akahoswa ni go mafuriko. ");
INSERT INTO dig_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Nyama a kuriwa, nyama asioriwa, nyama a mapha na chila aina ya chiumbe chiambalacho photsi, akpwedza kpwa Nuhu, ");
INSERT INTO dig_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","airi-airi, mlume na mchetu, achiinjira melini viratu Mlungu vyolagiza. ");
INSERT INTO dig_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Bada ya siku sabaa kusira, mafuriko gachiandza. ");
INSERT INTO dig_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nuhu phokala ana miaka magana sita, siku ya kumi na sabaa ya mwezi wa phiri, pula za madzi za kuzimu zasodoka kpwa nguvu na zichiandza kulavya madzi. Na dzulu mlunguni kpwauduka mvula ya komesha. ");
INSERT INTO dig_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Kuchinya mvula duniani siku mirongo mine, usiku na mutsi. ");
INSERT INTO dig_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Siku iyo-iyo, Nuhu na mchewe, anae ahahu, Shemu, Hamu na Jafeti, phamwenga na achetu ao, ainjira melini. ");
INSERT INTO dig_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Ainjira aho, phamwenga na chila aina ya nyama wa tsakani na wa kufugbwa na chila aina ya nyama a kuhambala na chila aina ya nyama a mapha. ");
INSERT INTO dig_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Chila aina ya viumbe vyakpwedza kpwa Nuhu viiri-viiri, chilume na chichetu na vichiinjira melini, ");
INSERT INTO dig_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","viratu vyolagizwa ni Mlungu. Chisha Mwenyezi Mlungu achisindika nyo mryango wa meli. ");
INSERT INTO dig_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Madzi gakala manji hadi meli ichikala inaengelela dzulu-dzulu, mafuriko gaenderera siku mirongo mine. ");
INSERT INTO dig_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Madzi gachienjerezeka sana duniani, na meli ichielea dzulu ya madzi. ");
INSERT INTO dig_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Gachiodzala sana hadi gachiziba myango mire yosi; ");
INSERT INTO dig_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","gazidi kuodzala hadi gachifika mita ne dzulu kutsapa virere vya myango. ");
INSERT INTO dig_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Viumbe vyosi duniani vyafwa — nyama, nyama a mapha nyama a kufugbwa, nyama a tsakani, viumbe vyosi vinyendekavyo maipho-maipho duniani phamwenga na atu. ");
INSERT INTO dig_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Viumbe vyosi vyokala moyo kpwenye tsi kavu vyafwa. ");
INSERT INTO dig_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Mlungu waangamiza chila chiumbe chokala moyo duniani — anadamu, nyama, viumbe vihambalavyo na nyama a mapha. Achisala Nuhu tu phamwenga na hara okala naye melini. ");
INSERT INTO dig_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Kuchikala na madzi manji duniani kpwa siku gana mwenga na mirongo mitsano. ");
INSERT INTO dig_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Halafu Mlungu wamtambukira Nuhu na nyama osi okala nao himo melini; achireha phuto duniani na gara madzi gachiandza kuphunguka. ");
INSERT INTO dig_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Pula za madzi za kuzimu kala zikazibwa na hira mvula kula dzulu mlunguni ichikala ikacha ");
INSERT INTO dig_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","na madzi gachienderera kuphunguka chila siku. Mwisho wa zira siku gana mwenga na mirongo mitsano madzi gachikala gakaphunguka. ");
INSERT INTO dig_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Siku ya kumi na sabaa ya mwezi wa sabaa meli ichigama dzulu ya mwango mmwengawapho wa myango ya Ararati. ");
INSERT INTO dig_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Madzi gachienderera kuphunguka, hadi siku ya kpwandza ya mwezi wa kumi, virere vya myango vichikala vinaonekana. ");
INSERT INTO dig_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Bada ya siku mirongo mine, Nuhu wavugula dirisha ra meli rokala akaritengeza ");
INSERT INTO dig_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","na achilavya kunguru. Achikala wa kuuruka hiku na hiku hadi madzi gachiuma. ");
INSERT INTO dig_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Ndipho Nuhu achilavya njiya akalole madzi ichikala gakauma, ");
INSERT INTO dig_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","ela kpwa vira madzi kala bado gakafwinika tsi yosi kayaphaha phatu pha kugbwa, achiuya melini. Nuhu achituluza mkpwono na dirishani achimuhala njiya achimuuyiza ndani. ");
INSERT INTO dig_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Achigodza sabaa mwenga, halafu achimlavya tsona yuya njiya. ");
INSERT INTO dig_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Njiya hiye wauya melini dzuwa ra dziloni. Aa, lola, anakodza itsi ra mzaituni mwakpwe mlomoni. Hipho Nuhu achimanya kukala madzi gakaswena. ");
INSERT INTO dig_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Halafu achigodza siku sabaa zanjina, chisha achimlavya tsona yuya njiya, ela siku iyo kauyire. ");
INSERT INTO dig_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Siku ya kpwandza ya mwezi wa kpwandza ya mwaka uriolungira, phokala Nuhu ana miaka magana sita na mwenga, madzi gakala gakauma duniani. Achiusa chifwiniko, achilola kondze na achiona kukala tsi ikauma. ");
INSERT INTO dig_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Iriphofika siku ya mirongo miiri na sabaa ya mwezi wa phiri tsi ichikala ikauma kabisa. ");
INSERT INTO dig_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Hipho Mlungu wamuambira Nuhu, ");
INSERT INTO dig_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Unaweza kutuluka himo melini, uwe na mcheo, na akaza anao. ");
INSERT INTO dig_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Vituluze viumbe vyosi urivyo navyo — nyama, nyama a mapha na viumbe vyosi vihambalavyo — ili vivyalane kpwa unji na vikale vichienjerezeka na kuenea chila phahali duniani.” ");
INSERT INTO dig_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Phahi, Nuhu watuluka iye na mchewe, anae na akaza anae. ");
INSERT INTO dig_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Nyama, viumbe vihambalavyo na nyama a mapha, osi atuluka kondze kulengana na aina zao. ");
INSERT INTO dig_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Phahi Nuhu wamdzengera Mwenyezi Mlungu phatu pha kulavira sadaka za kuochwa, achihala nyama mmwenga wa chila aina ya nyama wa kuriwa na mmwenga kahi ya nyama a mapha wa kuriwa, achialavya sadaka ya kuochwa pho phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Mwenyezi Mlungu ariphosikira nyo mzingo mnono, wagomba chimoyo-moyo achiamba, “Sindailani tsona dunia wakati wowosi kpwa sababu ya mambo ga mwanadamu. Namanya kukala maazoge ni mai hangu wanachewe. Sindaviangamiza tsona viumbe vyosi wakati wowosi dza vira vyohenda. ");
INSERT INTO dig_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Muda wosi dunia ndiphokalako kundakala na minga ya kuphanda na kuvuna. Muda wosi kundakala na minga ya mnyevu na dzoho, minga ya mwaka na vuri, usiku na mutsi, vivyo vindakalako hata kare na kare.” ");
INSERT INTO dig_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Mlungu wamjaliya Nuhu na anae alume achiamba, “Vyalanani, mkale anji, uvyazi wenu uodzaze dunia. ");
INSERT INTO dig_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Sambi nyama osi, nyama a mapha, viumbe vihambalavyo na ngʼonda andakuogophani; osi mkahewa akale tsini yenu. ");
INSERT INTO dig_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Chila chiumbe chiricho moyo na chinyendekacho chindakala chakurya chenu. Chila chitu nkakuphani dza viratu nrivyokuphani aina zosi za mitsunga. ");
INSERT INTO dig_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Ela msirye nyama ambayo taimwagirwe mlatso, mana mlatso ni uhai. ");
INSERT INTO dig_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Yeyesi ndiyemuolaga myawe, kpwa kpweli nindamriphiza. Nyama yeyesi achiolaga mutu, au mutu aolage myawe, naye ni aolagbwe. ");
INSERT INTO dig_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Yeyesi ndiyemuolaga mutu naye andaolagbwa ni mutu mana mutu námuumba kpwa mfwano wangu. ");
INSERT INTO dig_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","“Namwi, vyalanani, mkale anji, uvyazi wenu uodzaze dunia.” ");
INSERT INTO dig_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Chisha Mlungu wagomba na Nuhu na anae achiamba, ");
INSERT INTO dig_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Sambi naika chilagane changu na mwimwi phamwenga na vivyazi vyenu, ");
INSERT INTO dig_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","na chila chiumbe mrichokala nacho melini, yani nyama a mapha, nyama a kufuga na chila nyama wa tsakani, yani viumbe vyosi virivyotuluka melini. ");
INSERT INTO dig_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ninaika chilagane changu namwi kukala takuna viumbe ndivyohoswa ni mafuriko tsona, yani takundakala na mafuriko ndigoangamiza dunia.” ");
INSERT INTO dig_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Mlungu achienderera kugomba achiamba, “Hino ndiyo ishara ya chilagane changu namwi, na chila chiumbe chiricho moyo chiricho phamwenga namwi hadi vivyazi vyedzavyo. ");
INSERT INTO dig_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Naika chisichi cha mvula mainguni, nacho chindakala ishara ya chilagane changu kahi yangu na dunia. ");
INSERT INTO dig_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Chila nchifwinika mlunguni na maingu, na hicho chisichi cha mvula chichionekana mainguni, ");
INSERT INTO dig_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","nindatambukira chilagane changu na mwimwi na viumbe vyosi, kukala wakati wowosi madzi tagandakala tsona mafuriko ga kuhosa viumbe vyosi virivyo moyo. ");
INSERT INTO dig_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Chisichi chichikala mainguni, nindachiona na nindatambukira chilagane changu cha kare na kare kahi ya Mlungu na viumbe vyosi vya chila aina duniani.” ");
INSERT INTO dig_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Mlungu achimuambira Nuhu, “Chisichi chichi ndiyo ishara ya chilagane ambacho náchiika na viumbe vyosi duniani.” ");
INSERT INTO dig_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Anangbwa alume a Nuhu ariotuluka melini kala ni Shemu, Hamu na Jafeti. (Hamu kala ni isengbwa wa Kanani.) ");
INSERT INTO dig_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Hano ndio ana ahahu a Nuhu, na aho ndio akare a atu osi phapha duniani. ");
INSERT INTO dig_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nuhu waandza kurima, achiphanda mizabibu. ");
INSERT INTO dig_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Bada ya kunwa uchi wa zabibu, walewa na achilala chitsaha mwakpwe hemani. ");
INSERT INTO dig_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Hamu, isengbwa wa Kanani, walola chitsaha cha ise na achendaambira nduguze airi okala kondze. ");
INSERT INTO dig_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Ela Shemu na Jafeti ahala vwazi, achirigbwiririra mwao mafuzini, achiinjira chinyume-nyume na achendabwingiza ise yao. Aloza nyuso zao kanda, ili asione chitsaha cha ise yao. ");
INSERT INTO dig_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nuhu phokala uchi ukamkutika na kumanya achigohenderwa ni mwanawe mdide, ");
INSERT INTO dig_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","waamba, “Naalaniwe Kanani! Andakala mtumwa mkpwulu wa nduguze.” ");
INSERT INTO dig_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Nuhu achienderera kugomba achiamba, “Naajaliwe ni Mwenyezi Mlungu, Mlungu wa Shemu! Kanani akale mtumwa wa Shemu. ");
INSERT INTO dig_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Mlungu naenjereze lalo ra Jafeti, Jafeti naasagale kahi ya mahema ga Shemu, na Kanani naakale mtumwawe.” ");
INSERT INTO dig_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Bada ya mafuriko Nuhu wasagala miaka magana mahahu na mirongo mitsano. ");
INSERT INTO dig_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Miaka ariyoishi Nuhu ni miaka magana tisiya na mirongo mitsano, ndipho achifwa. ");
INSERT INTO dig_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Huno ndio uvyazi wa ana alume a Nuhu: Shemu, Hamu na Jafeti. Aha nao aphaha ana a chilume bada ya mafuriko. ");
INSERT INTO dig_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Ana alume a Jafeti kala ni Gomeri, Magogu, Madai, Javani, Tubali, Mesheki na Tirasi. ");
INSERT INTO dig_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Ana alume a Gomeri kala ni Ashikenazi, Rifathi na Togarima. ");
INSERT INTO dig_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Ana alume a Javani kala ni Elisha, Tarishishi, Kitimu na Rodanimu. ");
INSERT INTO dig_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Hinyo ndio akarengbwa a atu ariomwagikana seemu za pwani. Huno ni uvyazi wa Jafeti ariokala chila atu na tsi yao na makabila gao na mbari zao. ");
INSERT INTO dig_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ana alume a Hamu kala ni Kushi, Misiri, Puti na Kanani. ");
INSERT INTO dig_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Ana alume a Kushi kala ni Seba, Havila, Sabuta, Raama na Sabuteka. Ana alume a Raama kala ni Sheba na Dedani. ");
INSERT INTO dig_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","9","Kushi wavyala Nimurodi. Nimurodi wakala sujaa mkpwulu wa kpwandza duniani. Iye wakala ni muindza mkpwulu mbere za Mwenyezi Mlungu, ndiyo mana atu nkuamba, “Mutu yuyu ni dza Nimurodi, yemuindza mkpwulu mbere za Mwenyezi Mlungu.” ");
INSERT INTO dig_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Ufalumewe waandza na midzi ya Babeli, Ereku, Akadi na Kaline, iriyokala tsi ya Shinari. ");
INSERT INTO dig_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Halafu waenjereza tsi ya Ashuru kukala seemu ya ufalumewe, achidzenga midzi ya Ninawi, Rehobothi-Iri, Kala ");
INSERT INTO dig_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","na Reseni urio kahi-kahi ya Ninawi na mudzi mkpwulu wa Kala. ");
INSERT INTO dig_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Uvyazi wa Misiri kala ni Aludi, Aanami, Alehabi, Anafutuhi, ");
INSERT INTO dig_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Apathirusi, Akasiluhi ambao ni avyazi a Afilisti, na Akafutori. ");
INSERT INTO dig_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Ana alume a Kanani kala ni Sidoni, mwanawe wa kpwandza na Hethi, ambao akala akarengbwa a makabila garigoihwa na madzina gao. ");
INSERT INTO dig_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Piya wakala mkarengbwa wa Ajebusi, Aamori, Agirigashi, ");
INSERT INTO dig_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Ahivi, Aariki, Asini, ");
INSERT INTO dig_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Aarivadi, Asemari na Ahamathi. Badaye mbari za Akanani zatsamukana-tsamukana. ");
INSERT INTO dig_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Mphaka wa Akanani waandza Sidoni hadi Gerari phephi na Gaza, na uchiphiya mlairo wa dzuwa hadi Sodoma, Gomora, Adima na Seboimu phephi na Lasha. ");
INSERT INTO dig_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Aha ndio uvyazi wa Hamu kulengana na mbari zao, luga zao na tsi zao. Chila kundi kala rinagomba kabilaye. ");
INSERT INTO dig_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Shemu, kala ni mvyerengbwa wa Jafeti, na ndiye mkarengbwa wa Aeburania osi. ");
INSERT INTO dig_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Ana a Shemu kala ni Elamu, Ashuru, Arifakisadi, Ludi na Aramu. ");
INSERT INTO dig_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Ana a Aramu kala ni Usi, Huli, Getheri na Mashi. ");
INSERT INTO dig_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arifakisadi wavyala Shela, naye Shela achivyala Eberi. ");
INSERT INTO dig_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eberi wavyala ana airi alume, wa kpwandza achimuiha Pelegi kpwa sababu endzize atu kala akaganyana, na wa phiri kala aihwa Jokitani. ");
INSERT INTO dig_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Jokitani wavyala Alimodadi, Shelefu, Hasarimawethi, Jera, ");
INSERT INTO dig_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoramu, Uzali, Dikila, ");
INSERT INTO dig_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obali, Abimaeli, Sheba, ");
INSERT INTO dig_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofiri, Havila na Jobabu. Hinya osi kala ni ana a Jokitani. ");
INSERT INTO dig_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Tsi ariyosagala yahala kula Mesha hadi Sefari ambayo i mwango wa mlairo wa dzuwa. ");
INSERT INTO dig_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Hinyo ndio atu a chivyazi cha Shemu kulengana na mbari zao, luga zao, tsi yao na makabila gao. ");
INSERT INTO dig_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Aha osi ni mbari za ana a Nuhu kulengana na vivyazi vyao, kahi ya mataifa gao. Kula kpwa aha, makabila gaenea duniani bada ya mafuriko. ");
INSERT INTO dig_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Siku hizo duniani atu kala anagomba luga mwenga na maneno gao kala ni mamwenga. ");
INSERT INTO dig_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Atu ariphokala anatsama uphande wa mlairo wa dzuwa, afika tsi ya kugbwa hiko Shinari na achisagala kuko. ");
INSERT INTO dig_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Achiambirana, “Haya! Nahutengezeni matofali, hugaocheni vinono gakale mafu.” Ahumira matofali badala ya mawe na lami badala ya simiti. ");
INSERT INTO dig_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Achiamba, “Sambi, nahudzengeni mudzi na mnara ambao chirereche chifike mlunguni, ili huphaheni dzina na husedze hukatsamukana dunia ndzima.” ");
INSERT INTO dig_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Phapho Mwenyezi Mlungu watserera kpwedzalola nyo mudzi na nyo mnara ambao atu kala anadzenga. ");
INSERT INTO dig_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Mwenyezi Mlungu achiamba, “Aah! Atu aha ni amwenga na osi anagomba luga mwenga na chichi ni chandzo cha maneno makulu ambago andagahenda. Na takuna rorosi ambaro andaripanga ambaro tarindakala. ");
INSERT INTO dig_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Nahutserere photsi na hukabanange luga yao ili achigomba asielewane.” ");
INSERT INTO dig_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Kpwa hivyo Mwenyezi Mlungu achiatsamula dunia ndzima na achiricha kudzenga nyo mudzi. ");
INSERT INTO dig_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ndiyo mana mudzi hinyo waihwa Babeli, kpwa kukala phapho ndipho Mwenyezi Mlungu ariphotsanganya luga yokala ichigombwa ni atu duniani kosi, achiatsamula dunia yosi. ");
INSERT INTO dig_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Higa ni maneno ga kuhusu Shemu na uvyaziwe. Miaka miiri bada ya mafuriko Shemu kala ana miaka gana mwenga, achivyala mwana mlume, Arifakisadi. ");
INSERT INTO dig_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Bada ya kuvyala Arifakisadi, Shemu wasagala miaka magana matsano na achikala akavyala ana anjina, alume na achetu. ");
INSERT INTO dig_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arifakisadi ariphofika miaka mirongo mihahu na mitsano wavyala Shela. ");
INSERT INTO dig_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Bada ya kuvyala Shela, Arifakisadi wasagala miaka magana mane na tahu na achikala akavyala ana anjina, alume na achetu. ");
INSERT INTO dig_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Shela ariphofika miaka mirongo mihahu wavyala Eberi. ");
INSERT INTO dig_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Bada ya kuvyala Eberi, Shela wasagala miaka magana mane na tahu na achikala akavyala ana anjina, alume na achetu. ");
INSERT INTO dig_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eberi ariphofika miaka mirongo mihahu na ne wavyala Pelegi. ");
INSERT INTO dig_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Bada ya kuvyala Pelegi, Eberi wasagala miaka magana mane na mirongo mihahu na achikala akavyala ana anjina, alume na achetu. ");
INSERT INTO dig_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelegi ariphofika miaka mirongo mihahu wavyala Reu. ");
INSERT INTO dig_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Bada ya kuvyala Reu, Pelegi wasagala miaka magana mairi na tisiya na achikala akavyala ana anjina, alume na achetu. ");
INSERT INTO dig_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu ariphofika miaka mirongo mihahu na miiri wavyala Serugi. ");
INSERT INTO dig_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Bada ya kuvyala Serugi, Reu wasagala miaka magana mairi na sabaa na achikala akavyala ana anjina, alume na achetu. ");
INSERT INTO dig_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serugi ariphofika miaka mirongo mihahu wavyala Nahori. ");
INSERT INTO dig_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Bada ya kuvyala Nahori, Serugi wasagala miaka magana mairi na achikala akavyala ana anjina, alume na achetu. ");
INSERT INTO dig_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahori ariphofika miaka mirongo miiri na tisiya wavyala Tera. ");
INSERT INTO dig_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Bada ya kuvyala Tera, Nahori wasagala miaka gana mwenga na kumi na tisiya na achikala akavyala ana anjina, alume na achetu. ");
INSERT INTO dig_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tera ariphokala na miaka mirongo sabaa, wavyala Buramu, Nahori na Harani. ");
INSERT INTO dig_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Hano ndio atu a chivyazi cha Tera. Tera wavyala Buramu, Nahori na Harani. Harani wavyala Lutu. ");
INSERT INTO dig_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Harani wafwa Uru mudzi wa Akalidayo, ambako ndiko kovyalwa, na ariphofwa iseye Tera kala achere moyo. ");
INSERT INTO dig_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Buramu walóla Sarai na Nahori walóla Milika mwana wa Harani, ambaye piya kala ni ise wa Isika. ");
INSERT INTO dig_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai kala ni tasa, kala kana mwana. ");
INSERT INTO dig_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tera wamuhala mwanawe Buramu na mdzukuluwe Lutu, mwana mlume wa Harani na mkpwaza-mwanawe Sarai, mkpwaza Buramu. Osi atuluka Uru, mudzi wa Akalidayo achitaka kuphiya tsi ya Kanani. Ela ariphofika Harani, achisagala phapho. ");
INSERT INTO dig_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera wafwa ko Harani. Wakati ariphofwa, kala ana miaka magana mairi na mitsano. ");
INSERT INTO dig_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Siku mwenga, Mwenyezi Mlungu wamuamba Buramu, “Uka kpwenye tsi yenu, uriche mbarizo na nduguzo na uphiye tsi ambayo nindakuonyesa. ");
INSERT INTO dig_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Nindakuhenda ukale taifa kulu na ndakujaliya. Nindakuhenda umanyikane, nawe undakala baraka. ");
INSERT INTO dig_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Nindaabariki aho akubarikio, yeyesi ndiyekulani, nindamlani, na atu osi duniani andajaliwa kutsupira uwe.” ");
INSERT INTO dig_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Phahi, Buramu wauka dza arivyolagizwa ni Mwenyezi Mlungu, na Lutu achiphiya naye. Buramu kala ana miaka mirongo sabaa na mitsano ariphouka Harani. ");
INSERT INTO dig_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Buramu wahala mchewe Sarai, na Lutu, mwana wa nduguye, mali zosi arizophaha na atumwa osi arioaphaha pho Harani, achiuka achiphiya Kanani. ");
INSERT INTO dig_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Buramu watsupira kahi-kahi ya yo tsi hadi achifika Shekemu, phatu phokala na muhi wa mwaloni urio More. Siku zizo Akanani kala anasagala tsi iyo. ");
INSERT INTO dig_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Mwenyezi Mlungu wamtsembukira Buramu, achimuamba, “Hino ndiyo tsi ndiyoipha uvyazio.” Hipho Buramu wadzenga phatu pha kulavira sadaka Mwenyezi Mlungu, ambaye kala akamtsembukira. ");
INSERT INTO dig_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Kula hipho waphiya uphande wa myango ya mlairo wa dzuwa wa Betheli na achichita hemare. Betheli ichikala i mtswerero wa dzuwa na Ai ichikala i mlairo wa dzuwa. Phapho wamdzengera Mwenyezi Mlungu phatu pha kulavira sadaka na achimuabudu. ");
INSERT INTO dig_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Chisha Buramu wazidi kuphiya uphande wa Negebu. ");
INSERT INTO dig_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Halafu kpwakala na ndzala hiko Kanani, na ndzala iyo yakala kulu hata ichibidi Buramu atsame, waphiya Misiri achendasagala kuko kpwa muda. ");
INSERT INTO dig_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Buramu ariphokala a phephi kufika Misiri, wamuambira mchewe Sarai, “Ninamanya kukala uwe u mnono? ");
INSERT INTO dig_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Amisiri achikuona andaamba, ‘Yuyu ni mchewe,’ na phapho aniolage ela uwe akuriche moyo. ");
INSERT INTO dig_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Nakuvoya uaambire kukala uwe u mwenehu, ili nisiolagbwe na nihenderwe mambo manono kpwa sababuyo.” ");
INSERT INTO dig_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Sambi Buramu ariphofika Misiri, Amisiri achimuona kukala ye mchetu ni mnono sana. ");
INSERT INTO dig_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Maofisaa a Farao ariphomuona, achendamtogola mbere za Farao, halafu ye mchetu achihalwa achiphirikpwa dzumbani kpwa Farao. ");
INSERT INTO dig_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Buramu wahenderwa mambo manono-manono ni Farao kpwa sababu ya Sarai na achihewa mangʼondzi na mbuzi, ngʼombe, punda, atumwa alume na achetu na ngamia. ");
INSERT INTO dig_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ela Mwenyezi Mlungu waagayisa na achiatiya makongo makali-makali Farao na atu a nyumbaye yosi kpwa sababu ya Sarai, mkpwaza Buramu. ");
INSERT INTO dig_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Hipho Farao achimlagizira Buramu, achimuamba, “Ni neno rani rino ronihendera? Kpwa utu wani kuyaniambira kukala yuno ni mcheo? ");
INSERT INTO dig_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Kpwa utu wani waniamba ni mwenenu, na uchinihenda nimuhale akale mkpwazangu? Sambi mcheo hiyu; muhale na muuke!” ");
INSERT INTO dig_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Chisha Farao achilagiza atue amsindikize Buramu na mchewe na mali zosi zokala nazo. ");
INSERT INTO dig_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Buramu waambuka hadi Negebu kula Misiri, iye na mchewe na vituvye vyosi, phamwenga na Lutu. ");
INSERT INTO dig_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Buramu kala akakala tajiri wa mifugo, feza na zahabu. ");
INSERT INTO dig_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Buramu waenderera na charoche kula Negebu hadi achifika Betheli, phatu ariphokala akachita hemare pho mwandzo, kahi-kahi ya Betheli na Ai. ");
INSERT INTO dig_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Phatu phapho ndipho phokala phatu pha kulavira sadaka ariphokala akaphadzenga pho mwandzo. Phapho Buramu achimuabudu Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lutu kala achiphiya phamwenga na Buramu, naye kala ana vyaa vya ngʼombe, mangʼondzi na mbuzi na mahema. ");
INSERT INTO dig_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Akala ana mifugo minji hata ichikala taaweza kusagala phamwenga mana weru wa kurisa kala tautosha. ");
INSERT INTO dig_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Achikala, arisa a Buramu na a Lutu anaheha. Piya siku zizo Akanani na Aperizi kala anasagala tsi iyo. ");
INSERT INTO dig_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Halafu Buramu wamuamba Lutu, “Nahusihehe wala arisa ehu naasihehe, mana swiswi hu amwenga. ");
INSERT INTO dig_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Lola, weru wosi huno. Sambi nahuganyane. Uchitsambula kumotso nami nindahala kulume; uchitsambula kulume mino nindaphiya kumotso.” ");
INSERT INTO dig_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lutu waona kukala dete ra muho Joridani rina madzi manji chila phatu hadi Soari, dza viratu munda wa Mwenyezi Mlungu ama tsi ya Misiri. Wakati hinyo Mwenyezi Mlungu kala kadzangbweangamiza midzi ya Sodoma na Gomora. ");
INSERT INTO dig_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Phahi, Lutu wadzitsamburira dete rosi ra muho Joridani na achiphiya uphande wa mlairo wa dzuwa. Hivyo ndivyo ambavyo hano atu airi aganyana. ");
INSERT INTO dig_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Buramu wakala phapho Kanani, na Lutu achendasagala hira midzi ya deteni, achichita mahemage phephi na Sodoma. ");
INSERT INTO dig_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ela atu a Sodoma kala ni ayi, na akala anamuhendera Mwenyezi Mlungu dambi nyinji. ");
INSERT INTO dig_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lutu ariphouka, Mwenyezi Mlungu wagomba na Buramu, achimuamba, “Kula pho uripho, lola uphande wa vurini, wa mwakani, wa mlairo wa dzuwa na wa mtswerero wa dzuwa. ");
INSERT INTO dig_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Tsi yosi iyo uionayo nindakupha uwe na vivyazivyo ikale yenu hata kare na kare. ");
INSERT INTO dig_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Nindahenda atu a chivyazicho akale anji asioolangika dza mtsanga. ");
INSERT INTO dig_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Sambi phiya ukainyendeke iyo tsi kahi ya marege na mapanage mana mino nindakupha.” ");
INSERT INTO dig_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Phahi Buramu wangʼola mahemage na achitsama, achendasagala phephi na mihi ya mialoni ya Mamre, iriyo Heburoni, na phapho achimdzengera Mwenyezi Mlungu phatu pha kumlavira sadaka. ");
INSERT INTO dig_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Wakati uho, Amurafeli mfalume wa Shinari, Arioko mfalume wa Elasari, Kedorilaoma mfalume wa Elamu na Tidali mfalume wa Goimu, ");
INSERT INTO dig_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","apigana viha na afalume atsano, Bera mfalume wa Sodoma, Birisha mfalume wa Gomora, Shinabu mfalume wa Adima, Shemeberi mfalume wa Seboimu, na mfalume wa Bela ambayo piya yaihwa Soari. ");
INSERT INTO dig_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Hano afalume atsano ahala asikari aho a viha na achiahenda kundi mwenga hiko Dete ra Sidimu, ambaro vivi ni Bahari ya Munyu. ");
INSERT INTO dig_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Kpwa miaka kumi na miiri alazimishwa kuhumikira mfalume Kedorilaoma ela mwaka wa kumi na tahu achimuasi. ");
INSERT INTO dig_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Mwaka wa kumi na ne Kedorilaoma na hara afalume ayae akpwedzaapiga Arafa hiko Ashiterothi-Karinaimu, Azuzi hiko Hamu, Aemi hiko Shawe-Kiriathaimu, ");
INSERT INTO dig_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","na Ahori hiko mwango wa Seiri, achiazoresa hadi Eli-Parani kanda-kanda ya jangbwa. ");
INSERT INTO dig_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Chisha achiuya nyuma hadi Eni-Mishipati (yani Kadeshi), achipiga na achihala tsi yosi ya Aamaleki na achiashinda Aamori ariokala Hazazoni-Tamari. ");
INSERT INTO dig_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Ndipho afalume a Sodoma, Gomora, Adima, Seboimu na Bela (dzinare ranjina ni Soari) atuluka achendadzipanga ko Dete ra Sidimu. Ahenda vivi ");
INSERT INTO dig_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","ili apigane na Kedorilaoma mfalume wa Elamu, Tidali mfalume wa Goimu, Amurafeli mfalume wa Shinari na Arioko mfalume wa Elasari, afalume atsano chinyume cha afalume a ne. ");
INSERT INTO dig_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Dete ra Sidimu kala ri tele madibwa ga lami na afalume a Sodoma na Gomora na asikari aho phokala anachimbira viha, anjina agbwa mo madibwani, na hara anjina ariosala azorera myangoni. ");
INSERT INTO dig_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Hara afalume ane ahala mali zosi za Sodoma na Gomora, piya vyakurya, na achiphiya vyao. ");
INSERT INTO dig_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Lutu, mwana wa ndugungbwa wa Buramu, ambaye kala anasagala Sodoma, piya wahalwa mateka phamwenga na malize zosi. ");
INSERT INTO dig_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Mutu mmwenga yekala akachimbira, wakpwendamuambira Buramu, Mueburania kuhusu gosi gokala gakahendeka kuko. Wakati uho Buramu kala anasagala phephi na mihi ya mialoni ya Mamre, yuya Muamori, ndugungbwa wa Eshikoli na Aneri, osi ambao kala akaphahana na Buramu kuteryana siku za shida. ");
INSERT INTO dig_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Buramu ariphophaha habari kukala mwanawe akahalwa kpwa nguvu, wahala alume osi magana mahahu na kumi na nane a phakpwe kambini okala anaweza kuphiya vihani na achialunga-lunga hara maadui hadi Dani. ");
INSERT INTO dig_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Hiko waaganya atue madiba-madiba; usiku achipigana na hara maadui na achiashinda. Achiazoresa hadi Hoba ambako ni uphande wa vurini wa mudzi wa Damasikasi. ");
INSERT INTO dig_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Achiphaha mali zosi zokala zikahalwa zewe. Piya wamphaha Lutu mwana wa nduguye na achimuuyiza na malize, phamwenga na alume na achetu anjina ambao kala akatsamizwa kpwa lazima. ");
INSERT INTO dig_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Buramu ariphouya kula vihani ambako washinda mfalume Kedorilaoma na afalume ayae, mfalume wa Sodoma wakpwedzamchinjira Buramu Dete ra Shawe (yani Dete ra Mfalume). ");
INSERT INTO dig_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Naye Melikisedeki, mfalume wa Salemu, wareha mabofulo na uchi. Wakala mkpwulu wa dini, mlavyadzi-sadaka wa Ariye Dzulu Kuriko Vyosi, ");
INSERT INTO dig_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","na achimjaliya Buramu achiamba, “Buramu naajaliwe ni Mlungu, Ariye Dzulu Kuriko Vyosi, Muumba wa dzulu mlunguni na dunia. ");
INSERT INTO dig_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Naatogolwe Mlungu Ariye Dzulu Kuriko Vyosi, ariyekupha nguvu za kushinda maaduigo.” Naye Buramu wamupha Melikisedeki seemu mwenga ya kumi ya vitu vyosi arivyovihala zewe vihani. ");
INSERT INTO dig_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Mfalume wa Sodoma achimuambira Buramu, “Nipha atu, ela mali hala mwenye.” ");
INSERT INTO dig_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ela Buramu achimuamba mfalume wa Sodoma, “Naapa kpwa Mwenyezi Mlungu Ariye Dzulu Kuriko Vyosi, Muumba wa dzulu mlunguni na dunia, ");
INSERT INTO dig_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","kukala sindahala chitucho chochosi, hata wuuzi wala kowa ya chirahu, usedze ukaamba, ‘Mimi ndimi yemtajirisha Buramu.’ ");
INSERT INTO dig_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Sindakubali kuhala chitu chochosi isiphokala chira chakurya ambacho atu angu arya. Ela ariche ahale hano ayangu nriophiya nao, Aneri, Eshikoli na Mamre na atu ao. Aho naahale mtalo wao.” ");
INSERT INTO dig_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Bada ya mambo higo Mwenyezi Mlungu wagomba na Buramu ruwiyani achimuamba, “Buramu usiogophe. Mimi ni ngaoyo na zawadiyo indakala kulu sana.” ");
INSERT INTO dig_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Ela Buramu achiamba, “Ee Mwenyezi Mlungu, mkpwulu wa dunia yosi, zawadi iyo indanifwahani mana mino sina mwana. Lola, kuniphere mwana, nindafwa bila mwana na Eliezeri kula Damasikasi, mmwenga wa atumwa angu, ndiye ndenirisi.” ");
INSERT INTO dig_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ndipho Mwenyezi Mlungu achimuamba Buramu, “Hiye Eliezeri siye ndiyekurisi; mwanao mwenye mlume ndiye ndekurisi.” ");
INSERT INTO dig_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Achimlavya kondze Buramu, achimuamba, “Lola, hiko dzulu mlunguni na uolange zira nyenyezi ichikala undaweza kuziolanga.” Chisha achimuamba, “Atu a chivyazicho taandaolangika dza viratu nyenyezi.” ");
INSERT INTO dig_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Buramu achimkuluphira Mwenyezi Mlungu na kpwa sababu iyo Mwenyezi Mlungu achimuhenda akale mutu wa haki. ");
INSERT INTO dig_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Chisha Mlungu achimuamba, “Mimi ndimi Mwenyezi Mlungu yekulavya Uru mudzi wa Akalidayo ili nikuphe tsi ihi ikale yako.” ");
INSERT INTO dig_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ela Buramu achiamba, “Ee Mwenyezi Mlungu, Mlungu nindamanyadze kukala tsi hino indakala yangu?” ");
INSERT INTO dig_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Mlungu achimuamba, “Nirehera ndama, goma ra mbuzi na turume, osi akale na miaka mihahu-mihahu. Piya urehe ninga na mwana njiya.” ");
INSERT INTO dig_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Buramu wamrehera Mlungu hara nyama, achiaahula pande mbiri-mbiri na achiapanga misitari kulolana. Ela hara nyama a mapha kayaahula. ");
INSERT INTO dig_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Makozi gariphogbwa phara kurya zira nyama, Buramu wagainga. ");
INSERT INTO dig_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Dzuwa ririphotsotsomera gamba, Buramu wagbwirwa ni usingizi wa fungo na chilungulungu cha jiza ra kutisha chichimfwinika. ");
INSERT INTO dig_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Halafu Mwenyezi Mlungu achimuamba, “Umanye hakika kukala uvyazio undakala ujenini tsi ambayo siyo yao, nao andahendwa akale atumwa na andateswa kpwa miaka magana mane. ");
INSERT INTO dig_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ela nindaatiya adabu hara atu ndioahenda atumwa na chisha badaye andauka achikala na utajiri munji. ");
INSERT INTO dig_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ela uwe mwenye undakala mtumia na undafwa na amani. ");
INSERT INTO dig_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Kahi ya chivyazi cha ne, atu a chivyazicho andauya phapha, mana sindaatuluza Aamori hadi uyi wao ukale ni wa kutiywa adabu.” ");
INSERT INTO dig_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Dzuwa ririphotswa na kuinjira jiza, nyungu yokala inafuka mosi, na chimwindi chokala chinaaka chichitsupa kahi-kahi ya vira vipande vya nyama. ");
INSERT INTO dig_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Siku iyo Mwenyezi Mlungu waika chilagane na Buramu achimuamba, “Tsi ihi naipha atu a chivyazicho kula muho wa Misiri hadi muho mkpwulu wa Yufurati, ");
INSERT INTO dig_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","yani, tsi za makabila ga Akeni, Akenizi, Akadimoni, ");
INSERT INTO dig_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Ahiti, Aperizi, Arafa, ");
INSERT INTO dig_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Aamori, Akanani, Agirigashi na Ajebusi.” ");
INSERT INTO dig_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Phahi Sarai, mkpwaza Buramu, kala kadzangbwevyala naye ana. Ela kala ana mtumwawe mchetu kula Misiri, yeihwa Hagari. ");
INSERT INTO dig_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Ndipho Sarai achimuamba Buramu, “Unamanya kukala Mwenyezi Mlungu kakanijaliya ana. Phiya ukalale na muhendi kazi wangu, chahi nindaphaha mwana kutsupira iye.” Buramu achikubali go maneno ga Sarai. ");
INSERT INTO dig_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Phahi Sarai wamuhala Hagari, mhendiwe wa kazi kula Misiri achimupha mlumewe akale mchewe. (Higa gahendeka bada ya Buramu kusagala Kanani miaka kumi.) ");
INSERT INTO dig_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Buramu achimmanya chimwiri, naye achigbwira mimba. Ariphomanya kukala ana mimba waandza kumʼbera tajiriwe. ");
INSERT INTO dig_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Halafu Sarai achimuamba Buramu, “Gaga mai nihenderwago gasababishwa ni uwe. Nakupha muhendi kazi wangu, ela kpwa kukala anamanya wagbwira mimba vivi ananibera. Mwenyezi Mlungu andalamula kahi ya uwe na mimi!” ");
INSERT INTO dig_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Buramu wamuamba Sarai, “Hiyu ni mhendio wa kazi, muhende vyo uonavyo ni sawa.” Phahi Sarai wamtesa Hagari hadi achichimbira. ");
INSERT INTO dig_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Malaika wa Mwenyezi Mlungu wamuona Hagari kanda-kanda ya pula ya madzi jangbwani, yokala kanda-kanda ya njira ya kuphihira Shuri. ");
INSERT INTO dig_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ye malaika achimuamba, “Hagari, mhendikazi wa Sarai, ulaphi na unaphiyaphi?” Hagari achijibu achiamba, “Namchimbira tajiri wangu Sarai.” ");
INSERT INTO dig_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Yuya malaika wa Mwenyezi Mlungu achimuamba, “Uya kpwa tajirio na ukadziike tsinize.” ");
INSERT INTO dig_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Chisha ye malaika wa Mwenyezi Mlungu achimuamba, “Nindakupha uvyazi munji hata mutu asiweze kuuolanga.” ");
INSERT INTO dig_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ye malaika wa Mwenyezi Mlungu achimuamba, “Lola, hipha sambi una mimba, undavyala mwana mlume. Undamuiha Isimaili kpwa sababu Mwenyezi Mlungu akasikira chirirocho cha mateso. ");
INSERT INTO dig_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Kpwa kpweli maishage gandakala dza punda wa tsakani; andakala mpindzani wa atu osi na atu osi andakala apindzanie. Andaishi achikala kaphahana na nduguze.” ");
INSERT INTO dig_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hagari wamupha dzina hiri ye Mwenyezi Mlungu yegomba naye, “Uwe u Mlungu unionaye,” kpwa sababu waamba, “Hata phapha napho nikamuona Mlungu anionaye.” ");
INSERT INTO dig_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Ndiyo mana hicho chisima chaihwa Beeri-Lahai-Roi nacho chi kahi-kahi ya Kadeshi na Beredi. ");
INSERT INTO dig_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hagari wamvyarira Buramu mwana mlume naye Buramu achimuiha Isimaili. ");
INSERT INTO dig_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Buramu kala ana miaka mirongo minane na sita Hagari ariphovyala Isimaili. ");
INSERT INTO dig_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Buramu ariphokala ana miaka mirongo tisiya na tisiya, Mwenyezi Mlungu wamtsembukira tsona na achimuamba, “Mimi ndimi Mlungu Mwenye Nguvu Zosi. Maishago niogopha na ukale bila ya lawama. ");
INSERT INTO dig_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Nindatimiza chilagane changu na uwe na chivyazicho chindakala chinji sana.” ");
INSERT INTO dig_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Buramu wagbwa chimabumabu na Mlungu achimuamba, ");
INSERT INTO dig_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Lola, chichi ndicho chilagane changu na uwe: Ninakuahidi kukala undakala mkarengbwa wa mataifa manji. ");
INSERT INTO dig_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Kundaihwa Buramu tsona, ela dzinaro undaihwa Burahimu, kpwa sababu ninakuhenda mkarengbwa wa mataifa manji. ");
INSERT INTO dig_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Nindakuhenda ukale na chivyazi chinji, nindakuhenda ukale mkarengbwa wa makabila manji, chisha afalume andala kpwako. ");
INSERT INTO dig_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Nindaika chilagane cha kare na kare na uwe na chivyazicho bada ya uwe, kukala nikale Mlunguo na Mlungu wa vivyazivyo bada ya uwe. ");
INSERT INTO dig_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Tsi yosi ya Kanani ambayo vivi unasagala dza mjeni, nindakupha uwe na chivyazicho bada ya uwe, ikale yenu hata kare na kare. Nami ndakala Mlungu wao.” ");
INSERT INTO dig_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Chisha Mlungu achimuambira Burahimu, “Uwe gbwira chilagane changu phamwenga na uvyazio bada ya uwe na vivyazi vyao vyedzavyo. ");
INSERT INTO dig_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Chichi ndicho chilagane changu undichochiika uwe na chivyazicho bada ya uwe: Chila mlume kahi yenu ni lazima adekpwe. ");
INSERT INTO dig_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Ni lazima mdekpwe, yani kukatwa masunyu genu, nayo indakala ishara ya chilagane changu na mwimwi. ");
INSERT INTO dig_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Kpwa vivyazi vyedzavyo chila mwana mlume wa siku nane lazima adekpwe vivyazi vyenu vyosi, akale wavyalwa mwako nyumbani, au mukamgula kula kpwa ajeni ambao sio a chivyazicho. ");
INSERT INTO dig_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Chila mmwenga lazima adekpwe, na hino indakala ishara ya chimwiri kuonyesa chilagane changu namwi ni cha kare na kare. ");
INSERT INTO dig_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Mlume yeyesi ambaye kandadekpwa, andatengbwa na atue kpwa kuvundza chilagane changu.” ");
INSERT INTO dig_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Mlungu achienderera kugomba na Burahimu achimuamba, “Ye mcheo kundamuiha Sarai tsona, ela undamuiha Sara. ");
INSERT INTO dig_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Naye nindamjaliya na kpweli nindakuhenda uvyale naye mwana mlume. Nindamjaliya na andakala ninengbwa wa makabila, afalume a atu andala kpwakpwe.” ");
INSERT INTO dig_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Burahimu wagbwa chimabumabu; achitseka na achigomba mwakpwe rohoni, “Mimi, mtumia wa miaka gana mwenga na Sara, mchetu wa miaka mirongo tisiya, kpwa kpweli tahuweza kuvyala mwana.” ");
INSERT INTO dig_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Naye Burahimu achimuamba Mlungu, “Baha Isimaili akale ndiye mrisi wangu.” ");
INSERT INTO dig_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Mlungu achiamba, “Aa, undavyala mwana mlume na mcheo Sara, na undamuiha Isaka. Nindatimiza chilagane changu naye na vivyazivye bada ya iye hata kare na kare. ");
INSERT INTO dig_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Kuhusu Isimaili, nkasikira mavoyogo. Nindamjaliya na nimuhende avyale ana anji na akale na chivyazi chinji. Andakala isengbwa wa vilongozi kumi na airi, na nindamuhenda akale taifa kulu. ");
INSERT INTO dig_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ela nindaika chilagane changu na Isaka, ambaye undamvyala na Sara mwaka wedzao muda dza uhu.” ");
INSERT INTO dig_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Mlungu phomala kugomba na Burahimu, wauka. ");
INSERT INTO dig_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Siku iyo-iyo, Burahimu wamuogopha Mlungu, achimdeka mwanawe Isimaili na atumwa osi ariovyalwa phakpwe kaya na osi ariogulwa, alume osi a kaya pha Burahimu adekpwa siku mwenga dza Mlungu arivyolagiza. ");
INSERT INTO dig_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Burahimu kala ana miaka mirongo tisiya na tisiya ariphodekpwa, ");
INSERT INTO dig_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","na mwanawe Isimaili kala ana miaka kumi na mihahu. ");
INSERT INTO dig_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Burahimu na mwanawe Isimaili adekpwa osi siku yo mwenga, ");
INSERT INTO dig_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Alume osi a nyumbani mwa Burahimu, na ariogulwa kula kpwa ajeni, nao adekpwa phamwenga na Burahimu. ");
INSERT INTO dig_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Siku yanjina Mwenyezi Mlungu wamtsembukira tsona Burahimu phephi na mihi ya mialoni ya Mamre. Wakati uho, Burahimu kala asegere mryangoni pha hemare na dzuwa kala ringerengere, ");
INSERT INTO dig_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","watsupha matso na achiona alume ahahu aimire mbereze. Ariphoaona wazola kpwendaachinjira. Achivumbama hadi chilanguche chichiguta photsi, ");
INSERT INTO dig_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","na achiamba, “Mabwana, karibuni phangu kaya, mimi ni mtumishi wenu. ");
INSERT INTO dig_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Godzani nikurehereni madzi muoge magulu, munaweza kuoya hipha kolo ya muhi. ");
INSERT INTO dig_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Piya naweza kukureherani chakurya chidide ili mphahe nguvu za kpwenderera na charo chenu, mana mkedza kpwa mtumishi wenu.” Hara mabwana achimuamba, “Haya, henda kama uchivyogomba.” ");
INSERT INTO dig_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Phahi Burahimu wakpwendamlagiza Sara ko hemani, achimuamba, “Upesi, hala pishi kumi na mbiri za unga mnono wa nganu, uukande na uoche mikahe.” ");
INSERT INTO dig_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Halafu Burahimu waphiya wangbwi chaani na achendatsambula mtamba wa ngʼombe mnono wa kunona, achimupha mtumishi, yeutengeza upesi. ");
INSERT INTO dig_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Wahala maziya maivu, maziya maitsi, na zira nyama za ngʼombe, achiapha arye. Ariphokala anarya, Burahimu waima phephi nao pho kolo ya muhi. ");
INSERT INTO dig_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Nyo ajeni amuuza Burahimu, “Mcheo Sara a kuphi?” Burahimu achijibu achiamba, “Akuratu hemani.” ");
INSERT INTO dig_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Mmwenga wao achiamba, “Kpweli, nindauya tsona wakati dza uhu mwaka wedzao naye mcheo Sara andakala ana mwana mlume.” Wakati uho Sara kala a pho nyuma ya mryango wa hema, anaphundza. ");
INSERT INTO dig_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Burahimu na Sara kala ni atumia sana, na Sara kala kaona ga chichetu tsona. ");
INSERT INTO dig_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Sara watseka chimoyo-moyo achiamba, “Mino ndipho ni mtumia sana, tsona mlume wangu ni mtumia. Kpweli nindasikira mtswano wakati wa kuonana chimwiri?” ");
INSERT INTO dig_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Mwenyezi Mlungu achimuamba Burahimu, “Mbona Sara anatseka na anaamba, ‘Pho mino naweza kuphaha mwana kpweli vivi nrivyo mtumia?’ ");
INSERT INTO dig_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Dze, kuna utu wani ambao tauwezekana kpwa Mwenyezi Mlungu? Kama nchivyoamba, nindauya tsona mwaka wedzao wakati nchiopanga, na Sara andakala ana mwana mlume.” ");
INSERT INTO dig_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sara waogopha, kpwa hivyo achikanuka achiamba, “Mino sitsekere.” Ela Mlungu achiamba, “Ukatseka.” ");
INSERT INTO dig_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Hara mabwana auka na achilenga phatu ambapho anaweza kuona mudzi wa Sodoma; Burahimu waasindikiza. ");
INSERT INTO dig_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Mwenyezi Mlungu achigomba mo rohoni achiamba, “Sindamfwitsa Burahimu gara ndigogahenda, ");
INSERT INTO dig_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","mana Burahimu andakala taifa kulu ra atu enye nguvu. Mataifa gosi duniani gandajaliwa kutsupira iye. ");
INSERT INTO dig_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Námtsambula ili aambire anae na vivyazivye bada ya iye alunge njira ya Mwenyezi Mlungu kpwa kuhenda ga haki na garigo ga sawa mbere zangu. Achihenda vivyo, mimi Mwenyezi Mlungu nindamuhendera Burahimu gosi ambago námlaga.” ");
INSERT INTO dig_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Chisha Mwenyezi Mlungu achimuamba Burahimu, “Mimi nkasikira malalamiko chinyume cha atu a Sodoma na Gomora mana dambi zao zikaenjerezeka sana. ");
INSERT INTO dig_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Nindatserera nkalole ichikala ahendago ni mai dza nrivyosikira. Ichikala sivyo, nindamanya.” ");
INSERT INTO dig_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Phahi hara mabwana airi auka kuphiya uphande wa Sodoma, ela Burahimu achikala akasala aimire mbere za Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Chisha Burahimu achisengera phephi na achiamba, “Dze, undaangamiza atu a haki phamwenga na nyo ayi? ");
INSERT INTO dig_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Nakuvoya, ichikala hura mudzi una atu a haki mirongo mitsano, uuonere mbazi, usiuangamize ili utivye hara atu a haki mirongo mitsano. ");
INSERT INTO dig_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Kpwa kpweli taifwaha kuolaga atu a haki phamwenga na atu ayi! Taiwezekana! Taifwaha kuhenda atu a haki sawa na atu ayi. Uwe u muamuli wa dunia yosi, kundakosa kuhenda haki.” ");
INSERT INTO dig_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Mwenyezi Mlungu achiamba, “Ichikala nindaphaha atu a haki mirongo mitsano hiko Sodoma, mudzi wosi nindauricha kpwa sababu yao.” ");
INSERT INTO dig_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Burahimu achijibu achiamba, “Hai, Mwenyezi Mlungu, kpwa kukala jasiri wa kugomba nawe dzagbwe mimi ni vumbi tu. ");
INSERT INTO dig_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Dze, kala yo isabu ikaphunguka atu atsano kahi ya nyo enye haki mirongo mitsano, undauangamiza nyo mudzi kpwa kukala ukaphunguka atu atsano?” Achiamba, “Ichikala nindaphaha atu mirongo mine na atsano hiko, sindauangamiza.” ");
INSERT INTO dig_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Burahimu achigomba naye tsona achiamba, “Dze, ichikala kuna atu mirongo mine tu?” Mlungu achijibu achiamba, “Kpwa sababu ya nyo atu mirongo mine, sindauangamiza.” ");
INSERT INTO dig_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Chisha Burahimu achiamba, “Usitsukirwe Mwenyezi Mlungu, dze, ichikala kuna atu mirongo mihahu?” Achiamba, “Sindahenda hivyo nchiphaha atu mirongo mihahu.” ");
INSERT INTO dig_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Burahimu achiamba, “Mimi nkadzilavya kugomba na uwe Mwenyezi Mlungu, dze muchiphahikana atu mirongo miiri?” Mlungu achijibu achiamba, “Kpwa sababu ya atu mirongo miiri, sindauangamiza.” ");
INSERT INTO dig_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Chisha Burahimu achiamba, “Usitsukirwe ee Mwenyezi Mlungu, navoya nigombe tsona limwenga. Dze, muchiphahikana atu kumi?” Naye achijibu achiamba, “Kpwa sababu ya nyo atu kumi, sindauangamiza.” ");
INSERT INTO dig_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Mwenyezi Mlungu ariphomala kugomba na Burahimu, wauka, naye Burahimu achiuya kaya. ");
INSERT INTO dig_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Hara malaika airi afika Sodoma dziloni, Lutu kala asegere ryangoni, ryango ra Sodoma. Ariphoaona, wangʼoka achendaachinjira, chisha achizama hadi usowe uchiguta photsi ");
INSERT INTO dig_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","na achiamba, “Mabwana karibuni kpwangu kaya; mimi ni mtumishi wenu. Munaweza kusinga magulu na kulala hiko rero usiku, ligundzu chiti mundalamuka na mphiye charo chenu.” Ela aho achiamba, “Aa, swino hundalala phapha muhalani.” ");
INSERT INTO dig_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ela Lutu achiabembeleza hadi mwisho achiphiya nao kpwakpwe kaya. Achiatengezera chakurya chinono, yani mikahe isiyotiywa hamira. Chiriphoivwa waapha achirya. ");
INSERT INTO dig_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Kabila taadzangbwekpwendalala, alume a mudzi wa Sodoma — avyere kpwa adide — akpwedzazunguluka nyumba ya Lutu. ");
INSERT INTO dig_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Achimuiha Lutu, achimuamba, “A kuphi hara alume achiokpwedza kpwako dziloni? Atuluze kondze, hunalonda huahende achetu.” ");
INSERT INTO dig_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lutu watuluka kondze na achifunga mryango. ");
INSERT INTO dig_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Achiaamba, “Enehu, nakuvoyani msihende mambo mai! ");
INSERT INTO dig_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Lolani! Nina ana airi achetu ambao taadzangbwelala na alume. Godzani nikurehereni muahende mlondavyo. Ela musiahendere mai hano, mana ni ajeni angu, ni lazima niarinde.” ");
INSERT INTO dig_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ela aho achiamba, “Hebu, huphise hipha njirani! Uwe u mjeni tu na kuweza kuhuambira ra kuhenda. Phahi, hundakuhenda vibaya kushinda aho ajenio.” Achimsukuma-sukuma sana Lutu, achisengera ili avundze mryango. ");
INSERT INTO dig_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ela hara alume airi mura nyumbani agolosa mikono, achimuhala Lutu, achimuinjiza ndani na achifunga mryango. ");
INSERT INTO dig_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Chisha achiahenda vipofu gafula atu osi okala kondze mryangoni, avyere kpwa adide, na achidziremweza kuendza mryango, ela tauonere. ");
INSERT INTO dig_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Hara alume airi amuambira Lutu, “Dze, una mutu wanjina yeyesi hipha, mwana mlume ama mchetu, mkpwaza-mwana, mtsedza ama mʼbario yeyesi akalaye mudzi huno? Atsamize, ");
INSERT INTO dig_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","mana swino hundauangamiza kpwa kukala chiriro kuhusu atu aha chikazidi nacho chikafikira Mwenyezi Mlungu naye akahuhuma hubanange uhu mudzi.” ");
INSERT INTO dig_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Hipho, Lutu watuluka achendaambira achumba a anae achetu, achiaambira, “Upesi, ukani hipha; Mwenyezi Mlungu a phephi auangamize huno mudzi.” Ela aho achiona ni machani. ");
INSERT INTO dig_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Kuriphokala kunangʼala-ngʼala, nyo malaika amuhimiza Lutu achimuamba, “Henda wangbwi uhale mcheo na anao, muuke, sedze mkafwa wakati mudzi unatiywa adabu.” ");
INSERT INTO dig_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Lutu achikala anasita-sita, hipho hara malaika amgbwira mkpwono iye, mchewe na hara anae airi achetu achialongoza kondze ya mudzi, mana Mwenyezi Mlungu waaonera mbazi. ");
INSERT INTO dig_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ariphokala akaatuluza kondze, mmwenga wao waamba, “Chimbirani mtivye maisha genu! Msilole nyuma wala musiime phophosi kpwenye tsi ya kugbwa! Chimbirirani myangoni ili sedze mkafwa.” ");
INSERT INTO dig_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Ela Lutu achiaambira, “Hata nagasikale mabwana. ");
INSERT INTO dig_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Ni kpweli mimi mtumishi wenu mkanitsunuka na mkanionera mbazi kpwa kunitivya, ela siweza kufika myangoni mana ni kure sana. Nchihenda vivyo, nindaphahwa ni go mai na nifwe. ");
INSERT INTO dig_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Lolani, phapha phana mudzi mdide niwezao kuuchimbirira. Dza muonavyo ni mdide, ela nirichani nchimbirire hiko nami ndakala moyo.” ");
INSERT INTO dig_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ye malaika achimuamba, “Haya, ni sawa-sawa, nkakubali. Sindauangamiza mudzi hinyo uchiouhadza. ");
INSERT INTO dig_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Henda wangbwi uchimbirire kuko, mana sindahenda rorosi hadi ufike kuko.” Kpwa sababu Lutu waamba ni mdide, hura mudzi waihwa Soari. ");
INSERT INTO dig_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lutu ariphofika Soari dzuwa kala rikatuluka. ");
INSERT INTO dig_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Ndipho Mwenyezi Mlungu achihenda Sodoma na Gomora kunye mvula ya moho wa chibiriti kula mlunguni. ");
INSERT INTO dig_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Achiangamiza midzi iyo, tsi yosi ya kugbwa, atu osi ariokala mumo na chila chitu chomera hiko. ");
INSERT INTO dig_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ela mkpwaza Lutu walola nyuma na achigaluka nguzo ya munyu. ");
INSERT INTO dig_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Siku iyo-iyo ligundzu Burahimu wauya phara ariphokala akaima mbere za Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Achilola uphande wa Sodoma na Gomora na tsi yosi ya kugbwa na achiona mosi unafuka kula photsi, dza mosi wa tanu. ");
INSERT INTO dig_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Phahi, siku hira Mlungu ariphoangamiza midzi ya tsi ya kugbwa mokala Lutu achisagala, watambukira voyo ra Burahimu na achimlavya Lutu wakati ariphobananga yo midzi. ");
INSERT INTO dig_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Kpwa sababu Lutu kala ni muoga wa kusagala Soari, iye na anae airi achetu wapanda myangoni na achendasagala pangani. ");
INSERT INTO dig_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Siku mwenga mwanawe mvyere wamuamba mdidewe, “Baba yehu ni mtumia na takuna alume a kuhulóla tsi ihi dza vihendekavyo duniani kosi. ");
INSERT INTO dig_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Sambi nahumlevye baba yehu na hulale naye, ili huendeleze chivyazi chehu kutsupira kpwakpwe.” ");
INSERT INTO dig_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Usiku uho achimlevya ise yao na uchi, na yuya mvyere achilala naye. Ela Lutu kamanyire wakati mwanawe aripholala naye wala wakati ariphouka. ");
INSERT INTO dig_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Siku yolungira, yuya mvyere wamuamba mdidewe, “Dzana usiku mino nálala na baba. Rero usiku piya nahumlevye tsona, nawe ukalale naye ili huendeleze chivyazi chehu naye.” ");
INSERT INTO dig_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Phahi kuriphofika usiku, amlevya ise yao na yuya mdide achendalala naye. Lutu kamanyire tsona wakati mwanawe aripholala naye wala wakati ariphouka. ");
INSERT INTO dig_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Kpwa njira iyo anangbwa osi airi a Lutu agbwira mimba kula kpwa ise yao. ");
INSERT INTO dig_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Mwanawe mchetu mvyere wadzivugula mwana mlume na achimuiha Moabu. Iye ndiye mkarengbwa wa Amoabu hadi rero. ");
INSERT INTO dig_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Yuya mwanawe mchetu mdide naye wavyala mwana mlume, achimuiha Beni-Ammi. Beni-Ammi ndiye mkarengbwa wa Aamoni hadi rero. ");
INSERT INTO dig_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Burahimu watsama Mamre, achiphiya seemu za Negebu achendasagala kahi-kahi ya Kadeshi na Shuri. Badaye, wakpwendasagala Gerari dza mjeni. ");
INSERT INTO dig_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Kuko Burahimu wakala achiaambira atu Sara ni nduguye. Phahi Abimeleki, mfalume wa Gerari, wahuma atu akamuhale Sara, naye achimuhala. ");
INSERT INTO dig_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ela Mlungu wagomba na Abimeleki usiku ndosoni, achimuamba, “Undafwa kpwa kuhala mchetu hiyu, mana iye ni mkpwaza mutu.” ");
INSERT INTO dig_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Ela Abimeleki kala kadzangbwelala naye achiamba, “Vino Mwenyezi Mlungu, undabananga taifa risiro na kosa? ");
INSERT INTO dig_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Burahimu mwenye waamba Sara ni nduguye naye Sara waamba dza vivyo. Neno hiri nárihenda na moyo mmwenga nami sina makosa.” ");
INSERT INTO dig_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Ndipho Mlungu achimuambira Abimeleki mo ndosoni, “Ee, namanya kala wahenda neno hiri na moyo mmwenga, ndiyo mana nákuzuwiya usihende dambi na siyakuricha ukalala naye. ");
INSERT INTO dig_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Sambi, iye mchetu muuyize kpwa mlumewe na ye mlumewe andakuvoyera nawe undaishi kpwa kukala iye ni nabii. Ela ichikala kundamuuyiza, kpwa kpweli umanye undafwa, uwe na atuo osi.” ");
INSERT INTO dig_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Kuriphocha, Abimeleki walamuka ligundzu chiti achiiha atumishie osi na achiaambira achigogaona ndosoni, nao achitishirwa sana. ");
INSERT INTO dig_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Halafu Abimeleki wamuiha Burahimu na achimuamba, “Kpwa utu wani ukahuhendera vino? Nakukosani hata yenirehera nduni hino na ufalume wangu? Ukanihenda utu ambao taufwaha.” ");
INSERT INTO dig_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Chisha Abimeleki achimuamba Burahimu, “Kala unaazani hata uchihenda vino?” ");
INSERT INTO dig_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Burahimu achijibu achiamba, “Náhenda vivyo kpwa kukala náona kukala kuku kosi atu taamuogopha Mlungu na nchiona kukala andaniolaga kpwa sababu ya mkpwazangu. ");
INSERT INTO dig_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Piya ni mwenehu kpweli, ni mwenehu mana baba yehu ni mmwenga, ela chila mmwenga ana nine. Ela namlóla akale mkpwazangu. ");
INSERT INTO dig_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Mlungu ariphonihenda nituluke nyumbani mwa baba, namuamba Sara, ‘Hivi ndivyo ambavyo undanionyesa mendzwayo, kukala chila phatu ndiphophiya, amba mimi ni mwenenu.’ ” ");
INSERT INTO dig_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Phahi Abimeleki wahala mangʼondzi, ngʼombe na atumwa, alume na achetu achimupha Burahimu, chisha achimuuyizira mchewe Sara. ");
INSERT INTO dig_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimeleki achimuambira, “Hino yosi ni tsi yangu, lola phatu phophosi ulondapho usagale.” ");
INSERT INTO dig_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Piya wagomba na Sara achiamba, “Námupha mwenenu vipande elufu mwenga vya feza kuonyesa atu osi urio nao kukala kuna makosa. Vivi chila mutu andamanya kukala kuhendere makosa.” ");
INSERT INTO dig_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Mwenyezi Mlungu kala akaafunga chivyazi achetu osi a kaya pha Abimeleki, kpwa sababu ya gara gohenderwa Sara, mkpwaza Burahimu. Hipho, Burahimu wamuvoyera Abimeleki na Mlungu achimphoza. Piya achimvugula chivyazi mchewe na atumwae achetu, achikala anavyala tsona. ");
INSERT INTO dig_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Mwenyezi Mlungu wamuhendera Sara dza viratu arivyogomba, na achimuhendera garatu arigokala akalaga. ");
INSERT INTO dig_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sara wagbwira mimba na achimuvyarira Burahimu mwana mlume wakati wa utumiawe. Gaga gahendeka wakati uratu ambao Mlungu kala akaamba. ");
INSERT INTO dig_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Burahimu wamuiha Isaka ye mwana ariyevyarirwa ni Sara. ");
INSERT INTO dig_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Na mwanawe Isaka ariphokala akafisa siku nane, Burahimu wamdeka kama Mlungu arivyokala akamlagiza. ");
INSERT INTO dig_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Isaka ariphovyalwa, Burahimu kala ana miaka gana mwenga. ");
INSERT INTO dig_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Ndipho Sara achiamba, “Mlungu akanihenda ntseke na raha, na yeyesi ndiyesikira dzambo hiri andatseka phamwenga nami.” ");
INSERT INTO dig_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Chisha achiamba, “Ni ani angemuambira Burahimu kukala Sara andaamwisa ana? Ela nikamvyarira mwana mlume kahi ya utumiawe.” ");
INSERT INTO dig_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Isaka wakula na siku ariphorikiswa, Burahimu wahenda sharee kulu. ");
INSERT INTO dig_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Siku mwenga Sara wamuona ye mwana mlume wa Hagari, Mmisiri yemvyala na Burahimu anamuifya Isaka. ");
INSERT INTO dig_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Ariphoona wamuambira Burahimu, “Mzole hiyu mchetu mtumwa na mwanawe. Mana mwana wa mtumwa hiyu kandarisi phamwenga na mwanangu Isaka.” ");
INSERT INTO dig_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Neno hiri ramsononesa sana Burahimu mana Isimaili piya kala ni mwanawe. ");
INSERT INTO dig_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ela Mlungu achimuamba, “Usisononeke kuhusu hiye mvulana na mtumwao mchetu. Rorosi ndirokuambira Sara uhende, henda, mana uvyazio nriokulaga undatalwa kukala ula kpwa Isaka. ");
INSERT INTO dig_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Piya iye mwana wa mtumwao mchetu nindamupha vivyazi vinji, nindamuhenda akale taifa kpwa kukala iye piya ni mwanao.” ");
INSERT INTO dig_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Kuriphocha, ligundzu chiti wahala chakurya na chiriba cha madzi, achimhika Hagari fuzini na achimzola na mwanawe. Hagari wauka, achikala anadengereka weru wa Beeri-Sheba. ");
INSERT INTO dig_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Chiriba chiriphosira madzi, Hagari wamlaza ye mwana kahi ya chitsaka chimwengachapho. ");
INSERT INTO dig_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Achisagala hatuwa naye, kama hatuwa ya kutsupha hondza mana waamba, “Simendze nimuone mwanangu afwavyo.” Phokala asegere kanda achiandza kurira na raka ra dzulu. ");
INSERT INTO dig_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Mlungu wamsikira yuya mvulana anarira, na malaika wa Mlungu achigomba na Hagari kula mlunguni achimuamba, “Unani Hagari? Usiogophe, mana Mlungu akamsikira hiye mvulana anarira pho aripho. ");
INSERT INTO dig_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Phiya ukamuunule ye mwana, umugbwire mkpwono, mana iye ndamuhenda taifa kulu.” ");
INSERT INTO dig_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Chisha Mlungu wamngʼaza matso na achiona chisima cha madzi. Achendaodzaza chiribache na achimnwesa ye mwana. ");
INSERT INTO dig_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Mlungu wakala phamwenga na yuya mwana naye achienderera kukula. Wasagala ko weruni na achikala muindza mzuri wa kuindza na maha. ");
INSERT INTO dig_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Iye wasagala weru wa Parani na nine achimloza mchetu kula tsi ya Misiri. ");
INSERT INTO dig_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Wakati uho Abimeleki na Fikoli, ariyekala mkpwulu wa majeshi, aphiya kpwa Burahimu, achendamuamba, “Mlungu a phamwenga nawe kahi ya chila chitu uhendacho. ");
INSERT INTO dig_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Phahi niapira kpwa Mlungu kukala kundanichenga, ama kuchenga anangu wala uvyazi wangu. Mimi vyokala muaminifu kpwako, apa kukala nawe undakala muaminifu kpwangu, na kpwa tsi ihi usagalayo dza mjeni.” ");
INSERT INTO dig_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Burahimu achiamba, “Naapa.” ");
INSERT INTO dig_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Burahimu achimlalamira Abimeleki kuhusu chisima ambacho atumishi a Abimeleki kala akamfuta. ");
INSERT INTO dig_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimeleki achiamba, “Simanya ariyehenda hivyo, mana kudzangbweniambira wala sidzangbwegasikira isiphokala rero.” ");
INSERT INTO dig_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Hipho Burahimu wamupha Abimeleki mangʼondzi na ngʼombe na osi airi achiika chilagane. ");
INSERT INTO dig_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Burahimu watanya ana ngʼondzi sabaa achetu. ");
INSERT INTO dig_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimeleki achimuuza Burahimu, “Kpwadze ukahenda hivyo?” ");
INSERT INTO dig_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Burahimu achiamba, “Phokera hano ana ngʼondzi sabaa achetu. Huno ni ushaidi kuonyesa kukala ukakubali mimi ndimi yetsimba chisima hicho.” ");
INSERT INTO dig_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Phahi, hipho phaihwa Beeri-Sheba, mana hipho ndipho ariphoapirana. ");
INSERT INTO dig_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Bada ya kuika chilagane hipho Beeri-Sheba, Abimeleki na Fikoli mkpwulu wa majeshi auya kpwao tsi ya Filisti. ");
INSERT INTO dig_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Burahimu waphanda mkpwadzu ko Beeri-Sheba na achimuabudu Mwenyezi Mlungu, Mlungu wa kare na kare. ");
INSERT INTO dig_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Burahimu wasagala siku nyinji dza mjeni kuko tsi ya Afilisti. ");
INSERT INTO dig_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Bada ya gaga, Mlungu wamjeza Burahimu, achimuamba, “Burahimu!” Naye Burahimu achiihika achiamba, “Hee, himi!” ");
INSERT INTO dig_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Mlungu achimuambira, “Muhale mwanao, mwanao wa macheye Isaka, ummendzaye na uphiye naye hadi tsi ya Moriya. Ukamulavye dza sadaka ya kuochwa dzulu ya mwango mmwenga wa myango ndiokuonyesa.” ");
INSERT INTO dig_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Siku ya phiriye Burahimu warauka chiti, achikata kuni za kutosha kuochera sadaka ya kuochwa, achizipakiya dzulu ya pundawe, achihala mwanawe Isaka na atumishie airi. Achiandza charo cha kuphiya kura ambako Mlungu kala akamuambira. ");
INSERT INTO dig_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Siku ya hahu ya charoche, Burahimu waona pho phatu kpwa kure. ");
INSERT INTO dig_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Achiambira hara atumishie, “Mwimwi hugodzereni phapha na hiyu punda; mimi na hiyu mvulana hunaphiya kura hukaabudu Mlungu, chisha hundakuuyirani.” ");
INSERT INTO dig_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Burahimu wahala zira kuni za kuochera sadaka na achimhika mwanawe Isaka, na iye mwenye achitsukula makala ga moho na rumu. Ariphokala anaphiya, ");
INSERT INTO dig_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isaka wamuiha ise, “Baba?” Burahimu achiihika, “Hee mwanangu?” Isaka achiamba, “Swiswi huna moho na kuni, ela ri kuphi ro ngʼondzi ra sadaka ya kuochwa?” ");
INSERT INTO dig_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Burahimu achimuamba, “Mwanangu, Mlungu mwenye andadziphahira ro ngʼondzi ra sadaka ya kuochwa.” Nao achienderera na charo chao. ");
INSERT INTO dig_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ariphofika phatu ambapho Mlungu kala akamuambira, Burahimu wadzenga phatu pha kulavira sadaka na achipanga zira kuni dzuluye. Achimfunga mwanawe Isaka na achimlaza pho dzulu ya kuni. ");
INSERT INTO dig_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Chisha achihala rumure ili amtsindze mwanawe. ");
INSERT INTO dig_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ela malaika wa Mwenyezi Mlungu achimuiha Burahimu kula mlunguni, achimuamba, “Burahimu! Burahimu!” Naye achiihika achiamba, “Hee, himi!” ");
INSERT INTO dig_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Achiambwa, “Usimgute iye mvulana wala usimuhende rorosi, mana vivi nkamanya kukala unamuogopha Mlungu, kpwa kukala kukarema kumlavya mwanao, mwana wa macheye.” ");
INSERT INTO dig_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Burahimu watsupha matso na achiona turume rikagbwirwa pembe ni mihi chitsakani. Achendarihala na achirilavya sadaka ya kuochwa badala ya mwanawe. ");
INSERT INTO dig_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Phahi, Burahimu phatu phapho waphaiha, “Mwenyezi Mlungu andalavya.” Na hadi sambi atu nkuamba, “Dzulu ya mwango wa Mwenyezi Mlungu, Mlungu andalavya.” ");
INSERT INTO dig_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Malaika wa Mwenyezi Mlungu wamuiha Burahimu tsona kula mlunguni ");
INSERT INTO dig_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","achimuamba, “Mwenyezi Mlungu anaamba hivi, ‘Naapa kpwa dzina rangu mwenye, kpwa kukala ukahenda hivyo na kukaniremeza mwanao wa macheye, ");
INSERT INTO dig_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","hakika nindakujaliya na nindahenda vivyazivyo vikale vinji sana dza viratu nyenyezi za mlunguni na dza viratu mtsanga wa pwani. Uvyazio undamiliki midzi ya maadui gao. ");
INSERT INTO dig_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Mataifa gosi duniani gandaphaha baraka kpwa sababu ya uvyazio. Higa gosi gandakala kpwa kukala ukanitii.’ ” ");
INSERT INTO dig_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Phahi Burahimu wauyira atumishie nao achiuka phamwenga kuuya Beeri-Sheba, ambako Burahimu kala achisagala. ");
INSERT INTO dig_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Bada ya muda Burahimu waambirwa kukala, “Milika wavyarira mwenenu Nahori ana alume. ");
INSERT INTO dig_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Wa kpwandza ni Usi, mdidewe ni Buzi, Kemueli ambaye ni mkare wa Aaramu, ");
INSERT INTO dig_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesedi, Hazo, Pilidashi, Jidilafu na Bethueli.” ");
INSERT INTO dig_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bethueli wavyala Rebeka. Aha ndio ana anane ambao Milika wamvyarira Nahori, nduguye Burahimu. ");
INSERT INTO dig_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Mwanachetu wa Nahori aihwaye Reuma piya wavyala ana. Aho ni Teba, Gahamu, Tahashi na Maaka. ");
INSERT INTO dig_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","2","Sara wasagala miaka gana mwenga mirongo miiri na sabaa ndipho achifwa. Wafwa Kiriathi-Ariba (yani Heburoni), kahi ya tsi ya Kanani. Burahimu wamsononekera na achimririra Sara. ");
INSERT INTO dig_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Burahimu waricha lufu ra mchewe nyumbani achendagomba na Ahiti achiamba, ");
INSERT INTO dig_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Mimi ni mjeni na mcharo nisagalaye kahi yenu. Niguzirani phatu phakale vikurani ili nizike mkpwazangu.” ");
INSERT INTO dig_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Nyo Ahiti achimjibu Burahimu achimuamba, ");
INSERT INTO dig_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Hebu huphundze bwana. Uwe u mutu mkpwulu sana himu mwehu. Zika mcheo mbira yoyosi nono zaidi ndiyoitsambula. Takuna mutu yeyesi kahi yehu ndiyekukahaza usizike mcheo.” ");
INSERT INTO dig_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Burahimu waunuka na achizama kulavya ishima mbere za nyo Ahiti, enyezi a tsi iyo, ");
INSERT INTO dig_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","achiaambira, “Ichikala mukakubali nizike mkpwazangu hipha, phahi muambireni Efuroni mwana wa Sohari ");
INSERT INTO dig_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","aniguzire pangore riihwaro Makipela ririro mwisho wa mundawe. Muambireni aniguzire hiro pango kpwa bei kamili, ili phakale phangu vikurani.” ");
INSERT INTO dig_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efuroni mwenye kala asegere pho mkpwutanoni, ryango ra kuinjirira mudzini, phamwenga na Ahiti anjina; wamuambira Burahimu na Ahiti osi ariokala akedza pho ryango ra kumenyera mudzini achisikira, ");
INSERT INTO dig_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Hata, bwana wangu, phundza. Nakupha munda na pangore ririro himo mundani. Nakupha mbere za atu angu ili uzike mcheo.” ");
INSERT INTO dig_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Burahimu wazama tsona mbere za nyo atu a yo tsi. ");
INSERT INTO dig_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Achimuambira Efuroni kuno atu a yo tsi anasikira achiamba, “Navoya unisikize. Nindaripha bei ya munda. Kubali nikuriphe ili phakale phangu vikurani.” ");
INSERT INTO dig_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efuroni achimjibu Burahimu achimuamba, ");
INSERT INTO dig_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Bwana wangu niphundza. Munda ambao samaniye ni vipande magana mane vya feza tu, ni chitu chani kpwehu, mimi na uwe? Mzike mcheo himo.” ");
INSERT INTO dig_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Burahimu wakubali bei ya Efuroni na achimpimira chiasi arichohadza mbere za Ahiti anjina. Vivyo vipande magana mane vya feza avipima kulengana na vipimo vyokala vichihumirwa ni achuuzi a wakati uho. ");
INSERT INTO dig_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Hivyo ndivyo ambavyo munda wa Efuroni okala Makipela, mlairo wa dzuwa wa Mamre, wakala mali ya Burahimu. Munda, pango na mihi yosi yokala himo mundani hadi muphakani ");
INSERT INTO dig_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","vyakala vya Burahimu kulengana na shariya mbere za nyo Ahiti na atu osi okala akedza kpwenye ryango ra kuinjirira mudzini. ");
INSERT INTO dig_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Bada ya gago, Burahimu wazika mchewe Sara ndani ya pango rokala mo mundani, ko Makipela, mlairo wa dzuwa wa Mamre, yani Heburoni ko tsi ya Kanani. ");
INSERT INTO dig_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Kpwa hivyo, munda na pango rokala mo mundani vyahendwa mali ya Burahimu ni Ahiti kulengana na shariya, ili phakale phakpwe vikurani. ");
INSERT INTO dig_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Burahimu wakala mtumia, na Mwenyezi Mlungu kala akamjaliya na chila chitu arichochihenda. ");
INSERT INTO dig_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Burahimu wagomba na mtumishiwe mvyere wa osi pho phakpwe kaya ambaye kala ndiye muimirizi wa malize zosi achimuamba, “Ika mkpwonoo tsini ya nyonga yangu. ");
INSERT INTO dig_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Nalonda nikuapize kpwa dzina ra Mwenyezi Mlungu, Mlungu yeumba mlunguni na tsi, kukala kundamuendzera mwanangu msichana kula kpwa Akanani. ");
INSERT INTO dig_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ela undaphiya kpwehu kpwa mbari zangu na ukamuendzere mchetu mwanangu Isaka.” ");
INSERT INTO dig_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Yuya mtumishi achiamba, “Dze, ye mchetu achirema kpwedza tsi hino, nimuuyize mwanao kpwenu tsi uriyola?” ");
INSERT INTO dig_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Burahimu achiamba, “Hakikisha kukala kundamuuyiza mwanangu kuko. ");
INSERT INTO dig_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Mwenyezi Mlungu, Mlungu wa mlunguni ariyeniusa kula kahi ya kaya pha baba, tsi niriyovyalwa, ariyegomba nami na achiniahidi kpwa kuniapira na kuamba, ‘Tsi ihi nindaipha chivyazicho,’ andahuma malaikawe akutanguliye, ili umphahire mwanangu mchetu kula kuko. ");
INSERT INTO dig_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Ichikala mchetu andarema kpwedza, phahi kundagbwirwa ni chirapho changu. Ela kpwa vyovyosi usimuuyize mwanangu kuko.” ");
INSERT INTO dig_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Ndipho ye mtumishi waika mkpwonowe tsini ya nyonga ya bwanawe Burahimu, na achimuapira kuhusu dzambo riro. ");
INSERT INTO dig_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Halafu yuya mtumishi wahala ngamia kumi a tajiriwe na zawadi nono za chila aina na achiuka kuphiya seemu za Mesopotamia, hadi mudzi wa Nahori. ");
INSERT INTO dig_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ariphofika, waahenda ngamia asagale kondze ya mudzi kanda-kanda ya chisima. Kala ni dzuwa ra kuvunga, wakati wa achetu kpwedzaheka madzi. ");
INSERT INTO dig_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Halafu achivoya Mlungu, “Ee Mwenyezi Mlungu, Mlungu wa bwana wangu Burahimu, nakuvoya mambo gangu ganiphihireto rero na umuonyese bwana wangu mendzwayo isiyosika. ");
INSERT INTO dig_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Lola, niimire kanda-kanda ya chisima hichi na asichana a mudzi huno aredza kuheka madzi. ");
INSERT INTO dig_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Phahi ye msichana ndiyemuamba, ‘Nakuvoya uhule nyunguyo uniphe madzi ninwe,’ na aambe, ‘Nwa, na nyo ngamiao nao ndaatiira madzi anwe,’ iye naakale ndiye nchiyemtsamburira mtumishio Isaka. Ichikala hivyo, nindamanya kukala ukamuonyesa bwana wangu mendzwayo isiyosika.” ");
INSERT INTO dig_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Kabila kadzangbwemala kuvoya, Rebeka watuluka mudzini na nyunguye ya madzi fuzini. Kala ni mwana mchetu wa Bethueli, mdzukulu wa Nahori na mchewe Milika. Nahori kala ni ndugungbwa wa Burahimu. ");
INSERT INTO dig_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Rebeka kala ni msichana mnono sana na kala kadzangbwelala na mlume. Watserera chisimani, achendaodzaza nyunguye na achiuya. ");
INSERT INTO dig_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Yuya mtumishi wahenda mwendo kukutana naye, achimuamba, “Tafadhali nipha madzi kula mo mwako nyunguni ninwe.” ");
INSERT INTO dig_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Msichana achiamba, “Haya nwa, bwana,” achihula nyunguye upesi, achiigbwiririra mikononi ili anwe. ");
INSERT INTO dig_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ariphomala kumupha madzi, waamba, “Piya nindahekera madzi ngamiao anwe hadi akolwe.” ");
INSERT INTO dig_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Hipho wakupula madzi upesi ndani ya mwiyo wa kunwesera nyama kula mwakpwe nyunguni; achizola chisimani kuheka madzi tsona na achienderera kuheka hadi ngamiae osi achitosheka. ");
INSERT INTO dig_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Yuya mutu wamlolato bila ya kugomba rorosi, ili kuona ichikala Mwenyezi Mlungu akajaliya charoche. ");
INSERT INTO dig_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ngamia ariphomala kunwa madzi, yuya mutu wamtuluzira chishaufu cha pulani cha zahabu chokala na samani kulu, piya wamtuluzira bangili mbiri kulu za zahabu zirizo na uziho wa giramu gana mwenga na kumi. ");
INSERT INTO dig_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Halafu achimuuza, “U mwana wa ani? Dze, nyumba ya sowe ina nafwasi ya swiswi kulala?” ");
INSERT INTO dig_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Msichana achiamba, “Mimi ni mwana wa Bethueli, mdzukulu wa Nahori na Milika.” ");
INSERT INTO dig_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Chisha achienderera kugomba achiamba, “Kpwehu kuna mabuwa manji ga kuuma ga kurarira ngamia na chakurya chao cha kutosha, piya kuna nafwasi ya mwimwi kulala.” ");
INSERT INTO dig_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Hipho yuya mutu wazama achimuabudu Mwenyezi Mlungu, ");
INSERT INTO dig_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","achiamba, “Naatogolwe Mwenyezi Mlungu, Mlungu wa bwana wangu Burahimu, ambaye anaenderera kumuonyesa mendzwa isiyosika na uaminifu. Uphande wangu, Mwenyezi Mlungu akalongoza charo changu hadi kufika mudzini pha mbari za bwana wangu.” ");
INSERT INTO dig_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Msichana wazola nyumbani kpwa nine na achendaambira nduguze chigohendeka. ");
INSERT INTO dig_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebeka kala ana nduguye mlume aihwaye Labani, naye wazola chisimani kokala yuya mutu. ");
INSERT INTO dig_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Labani kala akaona chipuli na bangili mikononi mwa Rebeka na kala akamsikira anasemurira vira chivyoambirwa ni yuya mutu. Achiphiya kpwa yuya mutu ambaye kala aimire na ngamiae chisimani, ");
INSERT INTO dig_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","achiamba, “Karibu kaya, uwe yejaliwa ni Mwenyezi Mlungu. Usiime kondze, mana nkatayarisha chumba mwangu nyumbani na phatu pha nyo ngamia.” ");
INSERT INTO dig_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Hipho yuya mutu waphiya kaya kpwa ano Labani na Labani achiatsereza mizigo ngamia, achiarehera mabuwa ga kuuma ga kurarira na chakurya. Chisha achimrehera ye mtumishi wa Burahimu na atue madzi ga kuoga magulu. ");
INSERT INTO dig_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Chakurya chiriphorehwa yuya mutu waamba, “Sindarya hadi niseme gachigonireha.” Labani achiamba, “Haya huambire.” ");
INSERT INTO dig_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Hipho achiamba, “Mimi ni mtumishi wa Burahimu. ");
INSERT INTO dig_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Mwenyezi Mlungu wamjaliya sana bwana wangu na wamtajirisha. Wamupha unji wa mangʼondzi na ngʼombe, feza na zahabu, atumwa alume na achetu, ngamia na punda. ");
INSERT INTO dig_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sara, mkpwaza tajiri wangu wavyala naye mwana mlume utumiani na bwana wangu wamupha malize zosi hiye mwanawe. ");
INSERT INTO dig_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Bwana wangu wanihenda niape kukala nisimuendzere mwanawe wa chilume mchetu kula kpwa ana achetu a Akanani, aishio nao, ");
INSERT INTO dig_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","ela niphiye kpwa ise na mbarize, nimphahire mchetu mwanawe. ");
INSERT INTO dig_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Halafu nchimuuza bwana wangu, ‘Dze, ye mchetu achirema kpwedza?’ ");
INSERT INTO dig_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Naye achiniamba, ‘Mwenyezi Mlungu ambaye namuogopha andahuma malaikawe uphiye naye na andajaliya charocho ili umphahire mchetu mwanangu kula kpwa baba na mbari zangu. ");
INSERT INTO dig_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Nawe ndiphofika kpwa mbari zangu, hata achikukahaza mchetu undakala huru, kundagbwirwa ni chirapho changu.’ ” ");
INSERT INTO dig_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Rero nchiphofika chisimani nkavoya, ‘Ee, Mwenyezi Mlungu, Mlungu wa bwana wangu Burahimu, nakuvoya charo changu chiniphihireto. ");
INSERT INTO dig_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Lola, niimire kanda-kanda ya chisima hichi; msichana achedzaheka madzi nindamuamba, “Nakuvoya uniphe madzi ga kunwa machache kula mwako nyunguni.” ");
INSERT INTO dig_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Achiamba, “Haya nwa, na piya nindaahekera ngamiao,” iye naakale ndiye msichana ariyetsambulwa ni Mwenyezi Mlungu, akale mkpwaza-mwana wa bwana wangu.’ ");
INSERT INTO dig_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Kabila sidzangbwemala kuvoya mwangu rohoni, akatsoloka Rebeka na nyunguye fuzini. Akatserera chisimani achaheka madzi na nkamuamba, ‘Navoya uniphe madzi ninwe.’ ");
INSERT INTO dig_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Phahi akahula upesi nyunguye kula fuzini na akaniamba, ‘Haya nwa na nindaahekera ngamiao piya.’ Phahi nkanwa na akaahekera ngamia piya. ");
INSERT INTO dig_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Nkamuuza, ‘U mwana wa ani?’ Akaniamba, ‘Ni mwana wa Bethueli yevyalwa ni Nahori na Milika.’ Ndipho nkamtiya chipuli cha pulani na bangili za mikononi ");
INSERT INTO dig_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","na nkazama nkamuabudu Mwenyezi Mlungu. Nikamtogola Mwenyezi Mlungu, Mlungu wa bwana wangu Burahimu ambaye wanilongoza njira ya sawa ya kumphaha msichana, mʼbari wa bwana wangu wa kumloza mwanawe. ");
INSERT INTO dig_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Sambi ichikala mundamuonyesa mendzwa isiyosika na uaminifu bwana wangu, niambirani, na ichikala sivyo, piya niambirani, nimanye ra kuhenda.” ");
INSERT INTO dig_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Labani na Bethueli achimjibu achimuamba, “Higa gala kpwa Mwenyezi Mlungu, siyo dzulu yehu kulavya uamuzi. ");
INSERT INTO dig_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka hiyu, muhale uphiye naye akakale mchetu wa mwana wa bwanao dza Mwenyezi Mlungu vyogomba.” ");
INSERT INTO dig_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Mtumishi wa Burahimu ariphosikira hivyo wazama achiabudu mbere za Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Chisha watuluza vitu vya feza na vya zahabu na nguwo achimupha Rebeka. Piya walavya zawadi za samani kpwa nduguye na ye nine. ");
INSERT INTO dig_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Halafu yuya mtumishi na atue arya na achinwa, usiku achilala phapho. Aripholamuka ligundzu, mtumishi wa Burahimu waamba, “Nirichani niuye kpwa bwana wangu.” ");
INSERT INTO dig_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Ela nduguye na nine wa Rebeka achimuamba, “Mriche ye msichana akale naswi siku chache, angaa siku kumi, badaye munaweza kuuka.” ");
INSERT INTO dig_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ela mtumishi achiaambira, “Msinizuwiye kuuka, bada Mwenyezi Mlungu akajaliya charo changu, nirichani niphiye kpwa bwana wangu.” ");
INSERT INTO dig_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Aho achiamba, “Humuiheni ye msichana humuuzeni humusikire anaambadze.” ");
INSERT INTO dig_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Phahi amuiha Rebeka, achimuuza, “Dze, undauka na mutu yuno?” Rebeka achiamba, “Ee, nindauka.” ");
INSERT INTO dig_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Hipho amricha Rebeka na mtumishiwe mchetu achiuka na mtumishi wa Burahimu na atue. ");
INSERT INTO dig_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Achimjaliya Rebeka achiamba, “Uwe ndugu yehu, ujaliwe, ukale ninengbwa wa atu anji sana; vivyazivyo vimiliki midzi ya maadui gao.” ");
INSERT INTO dig_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Chisha Rebeka na atumishie achetu adzitayarisha, achipanda ngamia achiuka na mtumishi wa Burahimu. Vivyo ndivyo ye mtumishi wa Burahimu arivyomuhala Rebeka achiuka naye. ");
INSERT INTO dig_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Wakati hinyo Isaka kala akedza kula Beeri-Lahai-Roi mana kala achisagala Negebu. ");
INSERT INTO dig_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Siku mwenga dziloni, wakati kala anaweha-weha weruni, waona ngamia aredza. ");
INSERT INTO dig_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeka walola achimuona Isaka, achitserera kula dzulu ya ngamia ");
INSERT INTO dig_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","na achimuuza yuya mtumishi wa Burahimu, “Ni ani yuya edzaye kuhuchinjira kuno weruni?” Ye mtumishi achimuamba, “Ni bwana wangu.” Hipho Rebeka wahala mtandiyowe na achidzifwinika uso. ");
INSERT INTO dig_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Yuya mtumishi achimsemurira Isaka chila chitu arichohenda. ");
INSERT INTO dig_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isaka wamuinjiza Rebeka hemani, hema rosagala nine Sara, wamlóla achikala mchewe. Isaka wammendza Rebeka na achikala anaphozwa roho kuhusu chifo cha nine. ");
INSERT INTO dig_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Burahimu wahala mchetu wanjina, yeihwa Ketura. ");
INSERT INTO dig_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ketura wamvyarira Burahimu Zimurani, Jokishani, Medani, Midiani, Ishibaki na Shuwa. ");
INSERT INTO dig_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jokishani wakala isengbwa wa Sheba na Dedani; uvyazi wa Dedani kala ni Aashuri, Aletushi na Aleumi. ");
INSERT INTO dig_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Ana a Midiani kala ni Efa, Eferi, Hanoki, Abida na Elidaa. Aho osi kala ni atu a chivyazi cha Ketura. ");
INSERT INTO dig_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Burahimu wamrisiza Isaka malize zosi arizokala anazo. ");
INSERT INTO dig_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Ela ariphokala achere moyo, waapha zawadi anae alume a anachetue na achiausa aphiye tsi ya mlairo wa dzuwa kpwa asisagale na mwanawe Isaka. ");
INSERT INTO dig_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Burahimu waishi miaka gana mwenga na mirongo sabaa na mitsano. ");
INSERT INTO dig_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Chisha achifwa, naye kala akakala mtumia sana. Achizikpwa phamwenga na akaree. ");
INSERT INTO dig_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Anae Isaka na Isimaili amzika ndani ya pango riihwaro Makipela, mundani mwa Efuroni, mwana wa Sohari, Muhiti, phephi na Mamre, ");
INSERT INTO dig_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","munda ambao Burahimu kala akaugula kpwa Ahiti. Osi Burahimu na mchewe Sara azikpwa phapho. ");
INSERT INTO dig_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Bada ya chifo cha Burahimu, Mlungu wamjaliya mwanawe Isaka. Hiyu kala asagala phephi na Beeri-Lahai-Roi. ");
INSERT INTO dig_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Higa ni maneno kumuhusu Isimaili mwana wa Burahimu na Hagari, Mmisiri, ambaye kala ni mtumwa mchetu wa Sara, mkpwaza Burahimu. ");
INSERT INTO dig_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Higa ni madzina ga ana alume a Isimaili, mwana mvyere kala ni Nebayothi, na anjina kala ni Kedari, Adibeeli, Mibusamu, ");
INSERT INTO dig_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishima, Duma, Masa, ");
INSERT INTO dig_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadadi, Tema, Jeturi, Nafishi na Kedema. ");
INSERT INTO dig_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Hano ndio anangbwa a Isimaili na gano ndigo madzina gao kahi ya midzi yao, na kambi zao, vilongozi kumi na airi kulengana na mbari zao. ");
INSERT INTO dig_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Isimaili kala ana miaka gana mwenga mirongo mihahu na sabaa ndipho achifwa na kuzikpwa phamwenga na akaree. ");
INSERT INTO dig_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Vivyazivye vyasagala Havila hadi Shuri uphande wa mlairo wa dzuwa wa Misiri kuphiya Ashuru. Aha asagala kanda na atu anjina a chivyazi cha Burahimu. ");
INSERT INTO dig_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Higa ni madzina ga atu a chivyazi cha Isaka, mwana wa Burahimu. Burahimu wamvyala Isaka. ");
INSERT INTO dig_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaka ariphokala ana miaka mirongo mine walóla Rebeka, mwana wa Bethueli, Muaramu kula Padani-Aramu na ni ndugungbwa mchetu wa Labani. ");
INSERT INTO dig_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isaka wamvoya Mwenyezi Mlungu kpwa kukala mchewe kala ni tasa. Mlungu achimsikira na mchewe Rebeka achigbwira mimba. ");
INSERT INTO dig_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Mimba iyo yakala ni ya patsa, na hinyo ana achikala anasukumana mo mwakpwe ndanini. Achiamba, “Kpwa utu wani mambo higa ganahendeka kpwangu?” Hipho wakpwendamuuza Mwenyezi Mlungu manage. ");
INSERT INTO dig_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Mwenyezi Mlungu achimuamba, “Una chandzo cha makundi mairi ga atu mo mwako ndanini, higo makundi mairi ndigovyala tagandagbwirana. Kundi mwenga rindakala na nguvu kuriko ranjina, mvyere andamuhumikira mdide.” ");
INSERT INTO dig_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Siku za kuvyala ziriphofika, Rebeka wadzivugula patsa ya ana alume. ");
INSERT INTO dig_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Mwana wa kpwandza kala a kundu-kundu na mwiriwe wosi kala una malalaika manji dza nguwo yotengezwa na nyoya. Kpwa hivyo, amuiha Esau. ");
INSERT INTO dig_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Wa phiri wavyalwa kala akamgbwira Esau jimbe, kpwa hivyo achiihwa Jakobo. Rebeka ariphovyala nyo anae a patsa, Isaka kala ana miaka mirongo sita. ");
INSERT INTO dig_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Hara anache akula; Esau wakala hodari wa kuindza, mutu wa kumendza weru-weru, ela Jakobo kala ni mpole wa kumendza kusagala kaya. ");
INSERT INTO dig_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaka wammendza Esau zaidi, kpwa sababu kala achimendza kurya nyama zoindzwa ni Esau; ela Rebeka wammendza Jakobo zaidi. ");
INSERT INTO dig_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Siku mwenga Jakobo kala anajita dengu. Esau achedza kula weruni na achikala anahirika na ndzala. ");
INSERT INTO dig_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Esau achimuambira Jakobo, “Nipha iyo supu ya kundu, ninwe mana nahirika na ndzala!” (Gago ndigogomuhenda aihwe Edomu, manage ni “kundu”). ");
INSERT INTO dig_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Jakobo achimuamba, “Niguzira haki ya uvyereo kpwandza.” ");
INSERT INTO dig_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau achiamba, “Lola, mimi ni phephi nakufwa na ndzala, nyo uvyere wangu undanifwahani?” ");
INSERT INTO dig_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Ela Jakobo achiamba, “Niapira kpwandza.” Phahi Esau achimuapira Jakobo, na achimguzira haki ya uvyerewe. ");
INSERT INTO dig_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Jakobo achimupha Esau mkpwahe na dengu, achirya na achinwa chisha achiunuka na achiuka. Vivyo ndivyo Esau vyobera haki ya uvyerewe. ");
INSERT INTO dig_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Kpwakala na ndzala kali yanjina tsi iyo, richa hira ya kpwandza ya wakati wa Burahimu. Isaka waphiya Gerari kpwa Abimeleki, mfalume wa Afilisti. ");
INSERT INTO dig_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Mwenyezi Mlungu kala akamtsembukira Isaka ruwiyani na kala akamuamba, “Usitserere kuphiya Misiri, sagala kahi ya tsi ndiyokuambira usagale. ");
INSERT INTO dig_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Sagala kahi za tsi hino nami nindakala phamwenga nawe na nindakujaliya. Nindakupha uwe na vivyazivyo tsi hizi zosi na nindatimiza ahadi yoyiika na sowe Burahimu. ");
INSERT INTO dig_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Nindauhenda uvyazio ukale munji dza nyenyezi za mlunguni na nindaapha tsi hizi zosi. Atu a makabila gosi duniani andanivoya niajaliye dza viratu vyoujaliya uvyazio. ");
INSERT INTO dig_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Higa gandakala kpwa sababu Burahimu waphundza maneno gangu, achigbwira malagizo gangu na shariya zangu.” ");
INSERT INTO dig_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Phahi Isaka achisagala Gerari. ");
INSERT INTO dig_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Hara atu a kura ariphomuuza kuhusu mchewe, waamba, “Ni mwenehu,” mana waogopha kuamba, “Ni mkpwazangu.” Iye wadziamba, “Hano atu labuda andaniolaga ili amuphahe Rebeka,” kpwa vira ni mnono. ");
INSERT INTO dig_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isaka wasagala hiko muda mure. Siku mwenga, Abimeleki mfalume wa Afilisti watsungurira na dirishani, achimuona Isaka anamguta-guta Rebeka, mchewe. ");
INSERT INTO dig_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Hipho Abimeleki walagiza Isaka aihwe, achimuamba, “Kpwa kpweli hiyu ni mcheo! Kpwa utu wani waamba kala ni mwenenu?” Isaka achimuamba, “Kala naona labuda nindaolagbwa kpwa ye mchetu.” ");
INSERT INTO dig_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimeleki achimuamba, “Ni shaka rani rino rohurehera? Kala atu angu, mmwenga walala na mcheo, kungekala wahutiya dambini?” ");
INSERT INTO dig_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Hipho Abimeleki waatangazira atu osi achiamba, “Yeyesi ndiyemguta mutu hiyu hebu mchewe andaolagbwa.” ");
INSERT INTO dig_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isaka warima munda tsi iyo na mwaka hinyo-hinyo wavuna kano gana ya chipimo chophanda, mana Mwenyezi Mlungu wamjaliya. ");
INSERT INTO dig_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Waenderera kuongokerwa na achikala tajiri sana. ");
INSERT INTO dig_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Iye wakala na vyaa vinji vya mangʼondzi na mbuzi na ngʼombe na atumishi anji hata Afilisti achimuonera chidzitso. ");
INSERT INTO dig_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Phahi nyo Afilisti asirira visima vyosi vyotsimbwa ni atumishi a ise Burahimu phokala achere moyo. ");
INSERT INTO dig_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ndipho Abimeleki achimuambira Isaka, “Tsama hipha phehu, mana uwe una uwezo kuriko swiswi.” ");
INSERT INTO dig_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Phahi Isaka watsama na achendachita kambi Dete ra Gerari na achiishi kuko. ");
INSERT INTO dig_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Isaka wafukula visima vyotsimbwa wakati ise Burahimu kala achere moyo, na achivipha madzina garatu ambago ise kala akavipha. Visima hivi kala vikasirirwa ni Afilisti ise ariphofwa. ");
INSERT INTO dig_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Atumishi a Isaka atsimba chisima mo deteni na achiphaha pula za madzi. ");
INSERT INTO dig_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Ela arisa a Gerari aheha na arisa a Isaka achiamba, “Higa ni madzi gehu.” Ndipho Isaka achichiiha Eseki, yani “Malau,” mana kala akaheha. ");
INSERT INTO dig_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Halafu atsimba chisima chanjina, ela achiheha kuhusu chisima chichi piya; phahi achichiiha Sitina. ");
INSERT INTO dig_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Isaka watsama na achitsimba chisima chanjina, na taayaheha naye tsona. Phahi achichiiha, Rehobothi manaye ni “Nafwasi Pana,” mana waamba, “Sambi Mwenyezi Mlungu akahupha nafwasi pana naswi hundaendererato kahi za tsi ihi.” ");
INSERT INTO dig_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Badaye Isaka watsama, achiphiya Beeri-Sheba. ");
INSERT INTO dig_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Nyo usiku ariotsolokera, Mwenyezi Mlungu wamtsembukira na achimuamba, “Mimi ndimi Mlungu wa sowe Burahimu. Usiogophe mana ni phamwenga nawe; nindakujaliya na nindakupha vivyazi vinji kpwa sababu ya ahadi yangu kpwa mtumishi wangu Burahimu.” ");
INSERT INTO dig_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Isaka wadzenga phatu pha kulavira sadaka phapho na achimuabudu Mwenyezi Mlungu. Halafu wachita kambiye phapho na atumishie atsimba chisima chanjina. ");
INSERT INTO dig_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Abimeleki wala Gerari kpwedzamuona Isaka; wakpwedza na Ahuzathi, mshauriwe, na Fikoli, mkpwulu wa majeshi. ");
INSERT INTO dig_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isaka wauza, “Mkalungani mana mwanimena na mchinizola?” ");
INSERT INTO dig_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Achimuamba, “Swino hwaona wazi kukala Mwenyezi Mlungu a phamwenga nawe, kpwa hivyo hunaona baha hurye chirapho na uwe na huike chilagane kukala ");
INSERT INTO dig_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","kundahuhenda mai dza viratu ambavyo tahuyakuhenda mai. Swiswi hwakuhendera manono na huchikuricha utsame na amani. Sambi ni wazi kukala Mwenyezi Mlungu wakujaliya.” ");
INSERT INTO dig_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Phahi Isaka waatengezera chakurya chinono, achirya na achinwa. ");
INSERT INTO dig_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Ligundzu chiti kuriphocha arya chirapho. Halafu Isaka achiasindikiza, achiphiya kpwao salama. ");
INSERT INTO dig_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Siku iyo-iyo atumishi a Isaka akpwedzamuambira kuhusu chisima chokala akachitsimba. Achiamba, “Hukaphaha madzi!” ");
INSERT INTO dig_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Phahi, Isaka wachiiha Shiba, manaye ni chirapho. Hangu phapho mudzi uho waihwa Beeri-Sheba hata rero. ");
INSERT INTO dig_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esau ariphokala ana miaka mirongo mine, walóla achetu airi Ahiti. Walóla Judithi mwana wa Beeri na Basemathi mwana wa Eloni. ");
INSERT INTO dig_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Achetu aha, ahenda maisha ga Isaka na Rebeka gakale ga sonono. ");
INSERT INTO dig_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Wakati Isaka kala ni mtumia na matsoge tagaona tsona, wamuiha Esau, mwanawe mvyere, achimuamba, “Mwanangu.” Esau waihika, “Hee!” ");
INSERT INTO dig_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isaka achimuamba, “Lola, mino ndipho ni mtumia na siku zangu za kufwa sizimanya. ");
INSERT INTO dig_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Sambi, phahi, hala uhao na ryakaro, uphiye weruni ukaniindzire nyama wa weruni. ");
INSERT INTO dig_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Halafu unitengezere chakurya cha mtswano chira nchimendzacho, unirehere nirye ili nikujaliye kabila sidzangbwefwa.” ");
INSERT INTO dig_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Mbavi, Isaka ariphokala anabisha na mwanawe Esau, Rebeka kala anaphundza. Esau ariphouka kuphiya windzani, ");
INSERT INTO dig_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeka wamuambira mwanawe Jakobo, “Nkasikira sowe anamuamba mwenenu Esau, ");
INSERT INTO dig_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Kaniindzire nyama wa weruni, unijitire chakurya cha mtswano nirye, ili nikujaliye mbere za Mwenyezi Mlungu kabila sidzangbwefwa.’ ");
INSERT INTO dig_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Sambi, mwanangu, niphundza na uhende vira ndivyokulagiza: ");
INSERT INTO dig_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Phiya chaani na ukatsambule mvarika airi anono, nimjitire sowe chakurya cha mtswano, dza amendzavyo. ");
INSERT INTO dig_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Halafu undamphirikira sowe akarye, ili akujaliye kabila kadzangbwefwa.” ");
INSERT INTO dig_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Jakobo achimuamba nine, “Lola, mwenehu Esau ana malalaika na mino sina. ");
INSERT INTO dig_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Chahi baba andaniphaphasa na andaona kukala namchenga; hipho naweza kudzipha lana badala ya baraka.” ");
INSERT INTO dig_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Nine achimuamba, “Mwanangu, lana iyo nainigbwire mimi, henda nikulagizavyo tu, phiya ukanirehere zo mbuzi.” ");
INSERT INTO dig_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ndipho Jakobo wakpwendazihala na achimrehera nine, naye achitengeza chakurya cha mtswano, kama ise amendzavyo. ");
INSERT INTO dig_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Halafu Rebeka achihala nguwo nono kabisa za Esau mwanawe mvyere, ambazo kala anazo nyumbani, achimvwika Jakobo, mwanawe mdide. ");
INSERT INTO dig_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Piya wamvwika chingo za zira mbuzi mikononi na singoni ambamo kala tamuna malalaika. ");
INSERT INTO dig_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Halafu achimupha Jakobo chira chakurya cha mtswano na mabofulo gokala akagaocha. ");
INSERT INTO dig_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Chisha Jakobo achiphiya kpwa ise na achimuiha, “Baba.” Ise achiihika, “Hee! Ni mwanangu yuphi ye?” ");
INSERT INTO dig_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jakobo achimuambira ise, “Ni mimi Esau, mwanao mvyere. Nkahenda kama uchivyoniambira. Tafadhali baba, sagalato urye nyama zangu za windzani ili unibariki.” ");
INSERT INTO dig_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isaka achimuuza mwanawe, “Ikakaladze rero mwanangu, hata ukaphaha nyama mara mwenga?” Achimuambira ise, “Ni kpwa sababu Mwenyezi Mlungu, Mlunguo akaniterya kuphaha nyama.” ");
INSERT INTO dig_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ndipho Isaka achimuambira Jakobo, “Ndzo phephi, mwanangu nikuphaphase ili nihakikishe napho u Esau kpweli au siwe.” ");
INSERT INTO dig_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jakobo wamsengerera ise naye achimphaphasa, na achiamba, “Raka ni raka ra Jakobo, ela mikono ni ya Esau.” ");
INSERT INTO dig_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Kamanyire kukala ni Jakobo mana mikonoye kala ina malalaika dza ga nduguye Esau. Phokala a phephi na kumjaliya, ");
INSERT INTO dig_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","wamuuza tsona, “We u Esau kpweli?” Achiamba, “Ee, ni mimi.” ");
INSERT INTO dig_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Halafu achimuambira, “Mwanangu nirehera hizo nyamazo za windzani nirye, ili nikubariki.” Jakobo wamupha ise chakurya achirya, na achimupha uchi achinwa. ");
INSERT INTO dig_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Chisha ise achiamba, “Ndzo mwanangu unidonere.” ");
INSERT INTO dig_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Hipho wasengera na achimdonera. Isaka ariphosikira kungu ya nguwoze, wamjaliya achiamba, “Ehe, kungu nono ya mwanangu ni dza kungu ya munda uriojaliwa ni Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Mlungu akuphe mvula nyinji na minda ya rutuba ili uphahe mavuno manji na uchi munji. ");
INSERT INTO dig_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Makabila gosi nagakuhumikire, atu osi naakugbwerere maguluni. Ukale mkpwulu wa nduguzo, nao naakugbwerere maguluni. Yeyesi ndiyekulani naye naalaniwe, ndiyekuazira manono naajaliwe.” ");
INSERT INTO dig_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Bada ya Isaka kumala kumjaliya Jakobo, Jakobo wauka. Ariphouka tu, nduguye Esau achedza kula windzani. ");
INSERT INTO dig_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Piya naye watengeza chakurya cha mtswano na achimphirikira ise. Achendamuamba, “Baba, tafadhali sagalato, urye nyama nchizokurehera kula weruni, ili unijaliye.” ");
INSERT INTO dig_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Ise Isaka achiamba, “U ani we?” Naye achiamba, “Ni mimi, mwanao mvyere Esau.” ");
INSERT INTO dig_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isaka wagbwirwa ni mchecheta, achikakama na achiamba, “Vino akale ni ani yuya chiyeniindzira nyama na akanirehera? Nkarya sambi yenye kabila kudzangbwekpwedza; nami nkamjaliya na indakala hivyo!” ");
INSERT INTO dig_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esau ariphosikira hivyo, wasikira utsungu sana na achirira kpwa raka ra dzulu kuno anamuambira ise, “Ee baba nijaliya nami piya!” ");
INSERT INTO dig_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ela ise achiamba, “Mwenenu akedzanichenga na akahala barakazo.” ");
INSERT INTO dig_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esau achiamba, “Ndiyo mana aihwa Jakobo! Wanichenga kano mbiri: Ra kpwandza wahala uvyere wangu na vino lola, akahala baraka zangu.” Halafu achiamba, “Dze, kunisazirire baraka yoyosi?” ");
INSERT INTO dig_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaka achimuambira Esau, “Lola, nkamuhenda dzumbeo na nkamupha nduguze osi akale atumishie, na nkamupha mavuno na uchi. Sambi siweza kukuhendera rorosi mwanangu.” ");
INSERT INTO dig_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau achimuambira ise, “Kpwani che una baraka mwenga bahi, baba? Nijaliya nami baba!” Esau wakota kululu achirira. ");
INSERT INTO dig_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Ndipho ise achimuamba, “Makalogo gandakala kure na minda yenye rutuba, kusikogbwa manena kula mlunguni. ");
INSERT INTO dig_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Undaishi kpwa upanga, na undamhumikira mwenenu. Ela undiphovundza gogolore undakala huru, na kundamhumikira mwenenu tsona.” ");
INSERT INTO dig_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Phahi, Esau wamzira Jakobo kpwa sababu ya baraka ambazo ise kala akamjaliya. Achidziamba mwakpwe moyoni, “Baba a phephi na kufwa, badaye nindamuolaga mwenehu Jakobo.” ");
INSERT INTO dig_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Rebeka ariphoambirwa mpango wa Esau, mwanawe mvyere, walagiza aihirwe Jakobo, mwanawe mdide, naye achimuamba, “Mwenenu Esau anapanga kudziriphiza kpwa kukuolaga. ");
INSERT INTO dig_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Kpwa hivyo mwanangu, phundza gaga nikuambirago. Chimbira uphiye kpwa aphuyo Labani hiko Harani, ");
INSERT INTO dig_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","ukasagale naye kpwa muda hadi tsukizi za mwenenu ndiphodigirika. ");
INSERT INTO dig_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Utsunguwe ndiphosira na ndiphoyala gara gomuhenda, nindalagiza muhumwa akulunge. Sitaki niangamikirwe ni mosi airi siku mwenga.” ");
INSERT INTO dig_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Chisha Rebeka wamuambira Isaka, “Nasikira kusinywa sana mwangu moyoni kpwa sababu ya hano achetu a Chihiti. Ichikala Jakobo andalóla mchetu kula tsi ihi, yani Muhiti dza aha, phahi baha nifwe.” ");
INSERT INTO dig_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Phahi Isaka wamuiha Jakobo, achimjaliya na achimlagiza, achimuambira, “Simendze ulóle mchetu wa Chikanani. ");
INSERT INTO dig_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Ela nalonda uphiye Padani-Aramu kpwa Bethueli, tsaweyo mvyala mayoo, ukalóle mkoio mmwenga, kpwa aphuyo Labani. ");
INSERT INTO dig_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Mlungu Mwenye Nguvu Zosi akujaliye na akuphe chivyazi sana ili ukale mkarengbwa wa atu anji. ");
INSERT INTO dig_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Naakujaliye uwe na uvyazio dza arivyomjaliya tsaweyo Burahimu, ili uihale tsi hino ambayo unaisagala kama mjeni, tsi ambayo Mlungu wamupha tsaweyo.” ");
INSERT INTO dig_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Isaka wamricha Jakobo aphiye. Jakobo waphiya Padani-Aramu, kpwa aphuye Labani, mwana wa Bethueli, Muaramu, ndugu mlume wa Rebeka nine wa Jakobo na Esau. ");
INSERT INTO dig_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Badaye Esau wamanya kukala Isaka wamjaliya Jakobo na achimuambira aphiye Padani-Aramu akaendze mchetu alóle. Piya wamanya kukala Isaka wamlagiza Jakobo asilóle mchetu wa Chikanani ");
INSERT INTO dig_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","na kukala Jakobo wamtii ise na nine na achiphiya Padani-Aramu. ");
INSERT INTO dig_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Esau wamanya kukala ise kahamirwa ni achetu a Chikanani; ");
INSERT INTO dig_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","kpwa hivyo waphiya kpwa Isimaili, achendalóla Mahalathi ndugungbwa wa Nebayothi, dzagbwe kala ana achetu anjina. Mahalathi kala ni mwana mchetu wa Isimaili mwana wa Burahimu. ");
INSERT INTO dig_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jakobo wauka Beeri-Sheba kuphiya Harani. ");
INSERT INTO dig_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Ariphofika phatu fulani walala phapho kpwa mana dzuwa kala rikatswa. Wahala dziwe mwenga ra phatu hipho, achirihenda muto na achilala. ");
INSERT INTO dig_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Waloha ngazi ikaimiswa duniani na dzulu ikafika mlunguni. Malaika a Mlungu kala anapanda na kutserera. ");
INSERT INTO dig_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Mwenyezi Mlungu waima dzulu ya ngazi na achiamba, “Mimi ndimi Mwenyezi Mlungu, Mlungu wa tsaweyo Burahimu na sowe Isaka. Nindakupha uwe na vivyazivyo tsi hino ambayo ukadziambalaza. ");
INSERT INTO dig_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Na uvyazio undakala munji dza mitsanga ya duniani, na mundaenea kosi, mlairo wa dzuwa, mtswerero wa dzuwa, vurini na mwakani. Makabila gosi duniani gandajaliwa kutsupira uwe na vivyazivyo. ");
INSERT INTO dig_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Mimi ni phamwenga nawe na nindakurinda phophosi ndiphophiya na nindakuuyiza tsona kahi ya tsi hino. Sindakuricha hadi nikuhendere gosi nchigokulaga.” ");
INSERT INTO dig_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Jakobo aripholamuka waamba, “Kpwa kpweli Mwenyezi Mlungu a phatu hipha nami simanyire!” ");
INSERT INTO dig_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Wagbwirwa ni wuoga na achiamba, “Phatu phano mbona phanatisha hivi! Hino lazima ni Nyumba ya Mlungu na ni mryango wa kuinjirira mlunguni.” ");
INSERT INTO dig_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Jakobo walamuka ligundzu chiti na achihala rira dziwe ambaro kala akariika chitswani, achiriimisa rikale dziwe ra kumbukumbu na achirimwagira mafuha kuonyesa kukala ni phatu malumu pha Mlungu. ");
INSERT INTO dig_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Phatu hipho waphaiha Betheli. Dzagbwe mudzi hinyo kala unaihwa Luzu hangu kare. ");
INSERT INTO dig_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Chisha Jakobo waika naziri achiamba, “Mlungu, ichikala undanilongoza na kunirinda mwangu charoni, uniphe chakurya na nguwo ");
INSERT INTO dig_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","hadi niuye kaya kpwa baba salama, phahi uwe Mwenyezi Mlungu undakala Mlungu wangu. ");
INSERT INTO dig_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Dziwe hiri ra kumbukumbu nchiroriimisa, rindakala phatu pha kukuabudu Mlungu, na nindakupha fungu ra kumi ra vitu vyosi ndivyonipha.” ");
INSERT INTO dig_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Chisha Jakobo waenderera na charoche hadi achifika tsi ya atu a mlairo wa dzuwa. ");
INSERT INTO dig_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Waona chisima pho weruni, na kanda-kanda ya cho chisima kala phana makundi mahahu ga mangʼondzi gasegere, mana kala nkunwesa phapho. Mlomo wa cho chisima kala ukabwiningizwa na dziwe kulu. ");
INSERT INTO dig_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Desturi yao kala makundi gosi ga mangʼondzi gachikusanyika phara chisimani, arisa kala nkuusa rira dziwe na akahekera madzi mangʼondzi gao gakanwa. Chisha akachibwiningiza cho chisima na ro dziwe. ");
INSERT INTO dig_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jakobo wauza hara arisa, “Enehu, mlaphi?” Nao achimuamba, “Hula Harani.” ");
INSERT INTO dig_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Achiuza, “Munammanya Labani, mdzukulu wa Nahori?” Achimuamba, “Ehe, hunammanya.” ");
INSERT INTO dig_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Chisha Jakobo achiauza, “Kana neno?” Arisa achimuamba, “Kana neno; lola, yuya edzaye ni Raheli, mwanawe mchetu, aredza na mangʼondzi ga ise.” ");
INSERT INTO dig_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Jakobo achiamba, “Naona dzuwa richere dzulu, saa ya kukusanya mangʼondzi na kugaphirika kaya taidzangbwefika. Ganweseni na gauye marisani.” ");
INSERT INTO dig_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Aho achimuamba, “Tahuweza, hadi makundi gosi ga mangʼondzi gedze na hiri dziwe riuswe hipha chisimani; ndipho huganwese.” ");
INSERT INTO dig_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Wakati Jakobo acherebisha na hara arisa, Raheli watsoloka na mangʼondzi ga ise, mana kala ndiye mrisa. ");
INSERT INTO dig_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Jakobo ariphomuona Raheli, mwana wa aphuye Labani, na mangʼondzi ga ise, wakpwendaripingilisa rira dziwe phara chisimani na achinwesa mangʼondzi ga aphuye Labani. ");
INSERT INTO dig_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Chisha Jakobo wamdonera Raheli na achirira kpwa raka ra dzulu kpwa raha. ");
INSERT INTO dig_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Chisha achimuambira, “Mimi ni mʼbari wa sowe, ni mwana wa shangaziro Rebeka.” Raheli wazola mairo, achendamuambira ise. ");
INSERT INTO dig_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Labani ariphosikira habari za muwawe Jakobo, wazola kpwendamchinjira, achimtiya chifuwani, achimdonera na achiphiya naye kaya. Jakobo wamsemurira aphuye gosi garigohendeka, ");
INSERT INTO dig_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","ndipho Labani achimuambira Jakobo, “Kpwa kpweli uwe u mlatso wangu!” Jakobo ariphokala akasagala na Labani mwezi mmwenga, ");
INSERT INTO dig_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Labani wamuambira, “Sivyo vinono unihendere kazi bure ati kpwa sababu u muwangu. Niambira unalonda nikuriphe utu wani.” ");
INSERT INTO dig_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Sambi, Labani kala ana ana airi asichana; mvyere kala ni Lea na mdide kala ni yuya Raheli. ");
INSERT INTO dig_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea kala ana matso ga pozi ela Raheli kala ana umbo zuri tsona kala ni mnono. ");
INSERT INTO dig_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jakobo kala akammendza Raheli, kpwa hivyo achimuamba Labani, “Nindakuhendera kazi miaka sabaa ili uniloze mwanao mdide, Raheli.” ");
INSERT INTO dig_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Labani achiamba, “Baha nikuloze uwe kuriko mutu wanjina, uwe kala phapha phangu.” ");
INSERT INTO dig_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Phahi Jakobo wahenda kazi miaka sabaa kpwa alóle Raheli, ela waiona kama siku chache tu, kpwa vira arivyokala anammendza Raheli. ");
INSERT INTO dig_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Ndipho Jakobo achimuambira Labani, “Miaka yangu ya kuhenda kazi ikasira kpwa hivyo nipha mkpwazangu.” ");
INSERT INTO dig_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Phahi Labani waalika atu osi a hiko na achihenda karamu. ");
INSERT INTO dig_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ela usiku Labani wamuhala Lea, badala ya Raheli, achimphirikira Jakobo, na achilala naye. ");
INSERT INTO dig_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(Labani walavya mtumishiwe mchetu aihwaye Zilipa, achimupha mwanawe Lea akale mtumishiwe.) ");
INSERT INTO dig_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Ligundzu kuriphocha Jakobo wamanya kukala yuya mchetu mbavi ni Lea! Ndipho achimuuza Labani, “Mbona ukanihendera hivi? Avi nahenda kazi kpwa niphahe Raheli? Mbona ukanigaluka?” ");
INSERT INTO dig_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Labani achimuamba, “Swino mila yehu tahulóza mdide kabila ya mvyere kulólwa. ");
INSERT INTO dig_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Mala naye sabaa mwenga, halafu nikulóze Raheli, chisha unihendere kazi miaka yanjina sabaa.” ");
INSERT INTO dig_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jakobo wakubali. Ariphomala sabaa mwenga na Lea, Labani wamlóza Jakobo mwanawe Raheli. ( ");
INSERT INTO dig_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Labani walavya mtumishiwe mchetu aihwaye Biliha, achimupha Raheli akale mtumishiwe.) ");
INSERT INTO dig_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Jakobo walala na Raheli piya, na achimmendza Raheli kuriko Lea. Chisha achimuhendera kazi Labani miaka yanjina sabaa. ");
INSERT INTO dig_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Mwenyezi Mlungu ariphoona kukala Lea kamendzwa, wamjaliya chivyazi, ela Raheli achikala tasa. ");
INSERT INTO dig_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea wagbwira mimba na achivyala mwana mlume. Achimuiha Rubini, mana waamba, “Mwenyezi Mlungu akaona ugayi wangu, vivi mlume wangu andanimendza.” ");
INSERT INTO dig_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Lea wagbwira mimba tsona na achidzivugula mwana mlume, achimuiha Simioni, mana waamba, “Mwenyezi Mlungu akanipha mwana mlume wanjina, kpwa sababu wasikira simendzwa.” ");
INSERT INTO dig_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Chisha wagbwira mimba yanjina tsona na ariphovyala mwana mlume wamuiha Lawi, mana waamba, “Sambi ndipho mlume wangu andanimendza mana námvyarira ana ahahu alume.” ");
INSERT INTO dig_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Halafu wagbwira mimba yanjina tsona na ariphovyala mwana mlume achiamba, “Sambi charo chino nindamtogola Mwenyezi Mlungu,” kpwa hivyo achimuiha Juda. Chisha Lea achisika kuvyala. ");
INSERT INTO dig_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Phahi Raheli ariphoona kavyala, wamuonera wivu mwanáo na achimuambira Jakobo, “Nipha ana, napho kundanipha nindafwa!” ");
INSERT INTO dig_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jakobo wamreyera Raheli na achimuamba, “Kpwani mino ni Mlungu yekufunga chivyazi?” ");
INSERT INTO dig_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Raheli achiamba, “Hala mtumishi wangu Biliha, ulale naye ili anivyarire ana. Nami piya niihwe mayo kutsupira iye.” ");
INSERT INTO dig_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Ndipho Raheli wamupha Jakobo mtumwawe Biliha akale mchewe. Jakobo achilala naye. ");
INSERT INTO dig_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Biliha wagbwira mimba na achimuvyarira Jakobo mwana mlume. ");
INSERT INTO dig_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Raheli achiamba, “Mlungu akanihendera haki, akasikira mavoyo gangu na akanipha mwana mlume,” kpwa hivyo achimuiha Dani. ");
INSERT INTO dig_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Biliha wagbwira mimba tsona na achimuvyarira Jakobo mwana wa phiri mlume. ");
INSERT INTO dig_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Raheli achimuiha Nafutali, mana waamba, “Náheha sana na mwenehu ela nikashinda.” ");
INSERT INTO dig_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lea ariphoona akasika kuvyala, wahala mtumishiwe Zilipa, achimupha Jakobo ili akale mchewe. ");
INSERT INTO dig_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Zilipa wavyala naye mwana mlume. ");
INSERT INTO dig_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lea achiamba, “Nina bahati!” Na achimuiha Gadi. ");
INSERT INTO dig_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Zilipa wavyala na Jakobo mwana wa phiri mlume. ");
INSERT INTO dig_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Lea achiamba, “Nina raha mimi! Achetu andaniiha mwenye raha,” phahi achimuiha Asheri. ");
INSERT INTO dig_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Wakati wa kuvuna mtsere, Rubini waphiya mundani, achendaphaha tungudza, achimrehera nine Lea. Raheli wamuamba Lea, “Tafadhali, nipha tungudza chache chizokpwedza na mwanao.” ");
INSERT INTO dig_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ela Lea achimuamba, “Kpwani vyo vya kukala wanifuta mlume wangu tavitosha hata unalonda unifute tungudza za mwanangu?” Raheli achimuamba, “Ni sawa, napho undanipha tungudza za mwanao, Jakobo andalala kpwako rero usiku.” ");
INSERT INTO dig_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Dziloni Jakobo ariphouya kaya kula weruni, Lea wamchinjira na achimuamba, “Rero usiku undalala kpwangu mana nikakukodisha na tungudza za mwanangu.” Phahi usiku hinyo Jakobo walala na Lea. ");
INSERT INTO dig_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Mlungu wasikira mavoyo ga Lea, achigbwira mimba na achimuvyarira Jakobo mwana wa tsano mlume. ");
INSERT INTO dig_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Lea wamuiha yuya mwanawe Isakari, mana waamba, “Mlungu akanituza kpwa sababu nálavya mtumwa wangu mchetu nchimupha mlume wangu.” ");
INSERT INTO dig_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lea wagbwira mimba yanjina na achimuvyarira Jakobo mwana wa sita mlume. ");
INSERT INTO dig_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Achiamba, “Mlungu akanipha zawadi nono. Sambi mlume wangu andaniishimu sababu námvyarira ana sita alume.” Kpwa hivyo achimuiha Zabuloni. ");
INSERT INTO dig_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Bada ya muda, Lea wavyala mwana mchetu, achimuiha Dina. ");
INSERT INTO dig_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Chisha Mlungu achimuonera mbazi Raheli, achimjibu mavoyoge, achimvugula chivyazi. ");
INSERT INTO dig_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Wagbwira mimba achivyala mwana mlume. Achiamba, “Mlungu akaniusira waibu kpwa kunipha mwana mlume.” ");
INSERT INTO dig_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Mwana iye wamuiha Yusufu, mana waamba, “Mwenyezi Mlungu naaniphe mwana wanjina mlume.” ");
INSERT INTO dig_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Bada ya Raheli kuvyala Yusufu, Jakobo wamuamba Labani, “Niricha niuye kpwehu kovyalwa. ");
INSERT INTO dig_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Nipha akazangu na anangu urioniphaha kpwa kukuhendera kazi na niuke. Unamanya nákuhendera kazi vinono.” ");
INSERT INTO dig_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Ela Labani achimuamba, “Godza nami nigombe. Nionera mbazi na usiuke, mana bada ya kuphiya mburugani nkaona kukala Mwenyezi Mlungu wanijaliya kpwa sababuyo. ");
INSERT INTO dig_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Niambira mshahara ulondao nami nindakuripha.” ");
INSERT INTO dig_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jakobo achimuamba, “Uwe mwenye unamanya nirivyokuhendera kazi na mifugoyo irivyoenjerezeka mwangu mikononi. ");
INSERT INTO dig_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Kabila sidzangbwekpwedza, kala una mali chache ela hangu nedze yaenjerezeka sana na Mwenyezi Mlungu akakujaliya chila urikophiya. Ela vivi, ni wakati wa kulola mambo ga mwangu nyumbani.” ");
INSERT INTO dig_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Labani achimuuza, “Nikuripheni?” Jakobo achiamba, “Simendze mshahara wowosi. Ela nindaenderera kurisa mifugoyo ichikala undakubali dzambo hiri: ");
INSERT INTO dig_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Niruhusu nilole mifugoyo yosi rero na nitenge mangʼondzi gosi ga madowa-dowa ama ga mabara-mabara, ana ngʼondzi iru osi na mbuzi zosi za madowa-dowa ama za mabara-mabara. Hinyo ndio ndiokala mshahara wangu. ");
INSERT INTO dig_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Hizo siku zedzazo uaminifu wangu undaonekana wazi, siku uchedzalola mshahara wangu kama ni sawa, uchiona mbuzi yoyosi isiyo na madowa-dowa ama mabara-mabara, piya mwana ngʼondzi yeyesi ambaye si mwiru, phahi manya nyama hiye ni wa wiivi.” ");
INSERT INTO dig_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Labani achiamba, “Ni sawa. Nauhende kama uchivyoamba.” ");
INSERT INTO dig_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Ela siku iyo-iyo Labani watsamiza ndenje na mbuzi chetu zosi za mijora-mijora, madowa-dowa ama mabara-mabara, piya watsamiza ana ngʼondzi iru osi. Achiapha anae alume akale nao. ");
INSERT INTO dig_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Labani wauka na hira mifugo mwendo wa siku tahu kure na Jakobo. Jakobo waenderera kurisa hira mifugo yanjina ya Labani yosala. ");
INSERT INTO dig_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Phahi Jakobo wahala fwiho mbitsi za aina tahu ya mihi, achiziguwa makanda mijora-mijora ili hura wereru wa zira fwiho uoneke. ");
INSERT INTO dig_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Zira fwiho zoziguwa waziimisa ndani ya mabirika ga kunwesera nyama madzi, ili hira mifugo ione zira fwiho mbere zao wakati wa kunwa madzi. Kpwa kukala yo mifugo kala inaphekana wakati ikedzanwa madzi, ");
INSERT INTO dig_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","ana ariovyalwa hipho kala ni a madowa-dowa, mabara-mabara na mijora-mijora. ");
INSERT INTO dig_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Jakobo watenga hara ana ngʼondzi a madowa-dowa na a mabara-mabara na achialoza kpwa hara nyama anjina ili aaone. Phahi Jakobo achikala na nyamae mwenye na chaache. ");
INSERT INTO dig_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Wakati nyama a kunona phophekana, Jakobo waaikira zira fwiho chimbere-mbere, ili aphekane mbere ya zira fwiho. ");
INSERT INTO dig_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ela kala kaziika zira fwiho ichikala ni nyama a kuonda. Phahi hara nyama a kuonda akala a Labani na hara a kunona achikala a Jakobo. ");
INSERT INTO dig_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Kpwa sababu hino Jakobo wakala tajiri sana na wakala na mifugo minji; atumwa, ngamia na punda. ");
INSERT INTO dig_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Siku mwenga Jakobo wasikira ana alume a Labani ananungʼunika, anaamba, “Jakobo wahala mali yosi ya baba, wadzitajirisha na mali ya baba.” ");
INSERT INTO dig_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Piya waona kukala Labani kamjali dza phara dzuzi na dzana. ");
INSERT INTO dig_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Ndipho Mwenyezi Mlungu achimuamba Jakobo, “Uya kpwenu kpwa sowe na mayoo na mbarizo nami nindakala phamwenga nawe.” ");
INSERT INTO dig_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Jakobo wahuma mutu akaihirwe Raheli na Lea, edze ko weruni marisani kuriko na mifugoye. ");
INSERT INTO dig_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Achiaambira, “Naona siku hizi sowe yenu kaniona dza chitu dza phara mwandzo, ela Mlungu akakala phamwenga nami. ");
INSERT INTO dig_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Mwimwi mnamanya namuhendera sowe yenu kazi kpwa nguvu zangu zosi, ");
INSERT INTO dig_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","na bado sowe yenu wanichenga na achigaluza mshahara wangu kano kumi. Ela Mlungu wamzuwiya asinihende chitu chochosi chii. ");
INSERT INTO dig_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Chila ariphoamba, ‘Nyama osi a madowa-dowa andakala mshaharao,’ phahi, mifugo yosi yavyala ana a madowa-dowa. Na ariphoamba, ‘Nyama a mijora-mijora andakala mshaharao,’ phahi, mifugo yosi yavyala ana a mijora-mijora. ");
INSERT INTO dig_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Hivyo ndivyo Mlungu vyoenjereza mifugo yangu badala ya sowe yenu. ");
INSERT INTO dig_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Wakati wa minga ya mifugo kuphekana, náloha ndoso, náona ndenje zophekana ni za mijora-mijora, madowa-dowa ama mabara-mabara. ");
INSERT INTO dig_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Malaika wa Mlungu waniiha mo ndosoni, ‘Jakobo.’ Nchiihika, ‘Hee!’ ");
INSERT INTO dig_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Naye achiamba, ‘Lola, ndenje zosi ziphekazo ni za mijora-mijora, madowa-dowa na za mabara-mabara. Higa ninagahenda kpwa sababu nkaona gosi uhenderwago ni Labani. ");
INSERT INTO dig_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Mimi ndimi Mlungu yekutsembukira kura Betheli, komwagira mafuha dziwe ra kumbukumbu na kuniikira hati. Vivi uka tsi hino na uuye kpwenu kovyalwa.’ ” ");
INSERT INTO dig_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Raheli na Lea amuamba Jakobo, “Takuna mtalo wa urisi uriosala ko kpwa baba. ");
INSERT INTO dig_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Anahuharira avi hu ajeni. Mana wahuguza na mali ariyoriphiwa waihumira kare yosi. ");
INSERT INTO dig_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Mali zosi ambazo Mlungu wakupha kula kpwa baba ni haki yehu na ana ehu. Sambi henda rorosi ambaro Mlungu akakuambira uhende.” ");
INSERT INTO dig_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Phahi Jakobo wadzifunganya, achipandiza anae na achee dzulu ya ngamia, ");
INSERT INTO dig_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","achitsunga mifugoye yosi, achihala malize zosi arizozitsuma Padani-Aramu na achiphiya kpwao, tsi ya Kanani, kpwa ise Isaka. ");
INSERT INTO dig_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Wakati wa kuuka, Raheli waiya vizuka ambavyo kala ni milungu ya ise. Labani mwenye kala achakata mangʼondzige nyoya. ");
INSERT INTO dig_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Jakobo wamviringa Labani, Muaramu, mana kayamuambira kala anamchimbira. ");
INSERT INTO dig_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Jakobo wahala malize zosi na achichimbira. Ariphovuka muho wa Yufurati waphiya uphande wa tsi ya myango ya Giliadi. ");
INSERT INTO dig_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Siku ya hahu Labani waambirwa kukala Jakobo akachimbira. ");
INSERT INTO dig_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Phahi, Labani wahala nduguze na achimlunga-lunga Jakobo mwendo wa siku sabaa. Wakpwendamgbwira tsi ya myango ya Giliadi. ");
INSERT INTO dig_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Usiku Mlungu wamwedzera Labani ndosoni, achimuambira, “Dzikanye, usimuambire Jakobo neno rorosi nono au iyi.” ");
INSERT INTO dig_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Jakobo kala akachita kambiye tsi ya myango ya Giliadi wakati Labani ariphomgbwira. Labani na nduguze piya achita kambi yao kuko. ");
INSERT INTO dig_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Labani wamuambira Jakobo, “Mbona ukanihenda vino? Uwe ukanichenga na ukachimbira na anangu avi ni achetu chiotekpwa vihani. ");
INSERT INTO dig_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Kpwa utu wani wanichenga na uchichimbira chisiri? Mbona kuyanilaga nkakusindikizani na raha, mawira na ngoma? ");
INSERT INTO dig_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Wanilafya hata nafwasi ya kudonera anangu na adzukulu angu kpwa nialage. Uwe ukahenda mambo ga chizuzu. ");
INSERT INTO dig_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Nina uwezo wa kukuhenda vii, ela Mlungu wa sowe akanikanya usiku wa kulamukira rero, akaniamba, ‘Dzikanye, usimuambire Jakobo neno rorosi nono wala iyi.’ ");
INSERT INTO dig_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Namanya ukachimbira kpwa kuaza kpwenu kpwa sowe, ela mbona waiya milungu yangu?” ");
INSERT INTO dig_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jakobo achiamba, “Náogopha kpwa sababu náona undanifuta anao. ");
INSERT INTO dig_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Ela kuhusu milunguyo, yeyesi ndiyemgbwira nayo naaolagbwe. Tsona endza chochosi chiricho chako mbere za hano ndugu zehu na uchichiphaha chihale.” Jakobo kamanyire kulala Raheli kala akaiya milungu ya ise, Labani. ");
INSERT INTO dig_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Phahi Labani waendza milunguye ndani ya hema ra Jakobo, halafu hema ra Lea na ra ahendadzi-kazi airi, ela kaiphahire. Ndipho achendaendza hema ra Raheli. ");
INSERT INTO dig_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Mbavi Raheli kala akaihala hira milungu na akaifwitsa ndani ya tandiko ra ngamia na akaisagarira. Labani waendza hema rosi ela kaionere. ");
INSERT INTO dig_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Phokala achere endza, Raheli wamuambira ise, “Hai baba, usinireyere ela siweza kuima phako matsoni mana nina ga chichetu.” Labani waendza ela kayaphaha chitu. ");
INSERT INTO dig_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Ndipho Jakobo phohenda ngoro na achimuuza na usiru, “Kosa rangu nini? Náhenda dambi yani hata unilunge-lunge hivi? ");
INSERT INTO dig_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Hebu lola, ukapekula-pekula miyo yangu yosi, dze, ukaphahani ambacho ni chako? Chituluze hipha phereru ili ndugu zehu achione na ahuambire mkpweli ni ani. ");
INSERT INTO dig_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Kufikira sambi, nikasagala kpwako miaka mirongo miiri. Muda wosi hinyo taphana mbuzi wala ngʼondzi ro voromosa, wala siyarya turume rorosi ra mifugoyo. ");
INSERT INTO dig_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Chila ngʼondzi ama mbuziyo phoolagbwa ni nyama a tsakani, hasara iyo yakala dzulu yangu. Siyakurehera kuonyesa kukala si makosa gangu. Waniisa chochosi choiywa, ikale chaiywa usiku au mutsi. ");
INSERT INTO dig_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Niriphokala kpwako, mutsi kala nchigaya na dzuwa na usiku kala siphaha usingizi kpwa mnyevu. ");
INSERT INTO dig_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Nikakala kpwako kpwa miaka mirongo miiri. Miaka kumi na mine náhenda kazi ili uniloze anao airi, na miaka sita nchihenda kazi ili uniriphe na mifugo. Ela wanigaluzira mshahara wangu kano kumi. ");
INSERT INTO dig_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Mlungu wa akare angu, Mlungu wa Burahimu na ambaye waabudiwa ni Isaka, wanirinda. Kalapho si Mlungu, kpwa kpweli ungeniusa mikono mihuphu. Ela Mlungu waona kugaya kpwangu na chadi changu cha kazi, ndiyo mana akakudemurira rero usiku.” ");
INSERT INTO dig_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Labani wamuamba Jakobo, “Hano achetu ni anangu na ana aho nao ni uvyazi wangu. Mifugo hino ni yangu. Mali yosi uionayo ni yangu. Ela siweza kuahenda rorosi anangu wala adzukulu angu. ");
INSERT INTO dig_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Sambi nahuike chilagane mimi na uwe, nahuike tsumbi ya mawe ili ikale ushahidi wa mapatano gehu.” ");
INSERT INTO dig_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Phahi Jakobo wahala dziwe, achiriimisa rikale alama ya kumbukumbu. ");
INSERT INTO dig_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Chisha Jakobo achiaambira nduguze, “Kusanyani mawe.” Aho akusanya mawe achiika tsumbi na achirya chakurya kanda-kanda ya hira tsumbi ya mawe. ");
INSERT INTO dig_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","48","Labani waamba, “Tsumbi hino ni ushaidi wa mimi na uwe hipha rero,” na achiyiiha Yegari Sahaduta. Naye Jakobo wayiiha Galedi, ndiyo mana nkuihwa Galedi. ");
INSERT INTO dig_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Piya hira tsumbi yaihwa Mizipa, mana Labani waamba, “Mwenyezi Mlungu naahuone wakati hu kure na kure. ");
INSERT INTO dig_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Uchigayisa anangu ama uchilóla achetu anjina, hata ichikala taphana ahuonaye, umanye Mlungu ni shaidi wehu.” ");
INSERT INTO dig_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Labani achienderera kumuamba Jakobo, “Lola, unayoona hino tsumbi ya mawe na hiri dziwe ra kumbukumbu, ");
INSERT INTO dig_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","tsumbi hino na hiri dziwe ra kumbukumbu ni ushaidi kukala mimi sindavuka kpwedza kpwako kukuhenda mai, wala nawe kundavuka tsumbi hino na dziwe hiri kpwedza kpwangu kunihenda mai. ");
INSERT INTO dig_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Mlungu wa Burahimu, Nahori na ise yao naahuamule.” Ndipho Jakobo achiapa kpwa dzina ra Mlungu yeabudiwa ni ise Isaka, ");
INSERT INTO dig_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","na Jakobo achilavya sadaka ko myangoni. Chisha achiiha nduguze achedzarya chakurya. Arya na achikala kuko myangoni usiku wosi. ");
INSERT INTO dig_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Ligundzu chiti Labani waadonera adzukulue na anae achetu, na achiabariki. Chisha achiuka achiuya kpwakpwe kaya. ");
INSERT INTO dig_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Badaye Jakobo naye wauka. Mo njirani wakutana na malaika a Mlungu. ");
INSERT INTO dig_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Ariphoaona hara malaika waamba, “Hiri ni jeshi ra Mlungu.” Phahi phatu hipho achiphaiha Mahanaimu. ");
INSERT INTO dig_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jakobo wahuma ajumbe chimbere kuphiya kpwa Esau hiko Seiri, kahi za tsi ya Edomu. ");
INSERT INTO dig_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Waalagiza achiaamba, “Muambireni bwana wangu Esau hivi: Mtumishio Jakobo anaamba, ‘Násagala na aphu Labani miaka iyo yosi hadi rero. ");
INSERT INTO dig_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Vivi nina ngʼombe, punda, mbuzi na mangʼondzi na atumwa alume na achetu. Nikakuhumira ujumbe uhu bwana wangu, ili ukubali kunikaribisha.’ ” ");
INSERT INTO dig_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Hara ahumwa ariphouya kpwa Jakobo, amuamba, “Hwafika kpwa mwenenu Esau na vivi a njirani aredza mkutane; aredza na alume magana mane.” ");
INSERT INTO dig_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Jakobo waogopha sana na achikala na wasiwasi. Achiganya atue, mbuzi, ngʼombe, mangʼondzi na ngamia makundi mairi-mairi. ");
INSERT INTO dig_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Waaza achiamba, “Esau achedzapigana na kundi mwenga, rira ndirosala rinaweza kuchimbira.” ");
INSERT INTO dig_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Chisha Jakobo wavoya Mlungu achiamba, “Ee Mlungu wa tsawe Burahimu na baba Isaka. Mwenyezi Mlungu yeniamba, ‘Uya kpwenu kpwa mbarizo nami nindakuhendera manono.’ ");
INSERT INTO dig_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Sifwaha kuonyeswa mendzwa isiyosika, wala uaminifu ambao ukanionyesa mimi mtumishio. Awali nriphovuka huno muho Joridani navuka na fwimbo tu, ela vivi hu makundi mairi. ");
INSERT INTO dig_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Nakuvoya unitivye na uyi wa mwenehu Esau, mana naogopha asedze akahupiga na kuhuangamiza hosi, hata anache na nine zao. ");
INSERT INTO dig_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Uwe mwenye waniahidi uchiniamba, ‘Nindakujaliya na nindakupha uvyazi munji dza mtsanga wa pwani ambao mutu kaweza kuuolanga.’ ” ");
INSERT INTO dig_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Usikuwe Jakobo wakala phapho hipho na achitenga mifugoye yanjina ikale zawadi ya nduguye Esau. ");
INSERT INTO dig_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Watenga vitu hivi: Magoma ga mbuzi magana mairi, ndenje mirongo miiri, mangʼondzi machetu magana mairi, turume mirongo miiri, ");
INSERT INTO dig_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ngamia aamwisao mirongo mihahu na ana ao, ngʼombe chetu mirongo mine, ndzau kumi, punda achetu mirongo miiri na punda alume kumi. ");
INSERT INTO dig_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Waika chila mfugo kundire na chila kundi waririchira mtumishiwe arimanyirire. Achiaambira, “Tanguliyani, na chila kundi narikale hatuwa na kundi ranjina.” ");
INSERT INTO dig_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Wamlagiza yuya ariye mbere, achimuamba, “Wakati uchikutana na mwenehu Esau, na achikuuza, ‘Tajirio ni ani? Unaphiyaphi? Huno mfugo ni wa ani?’ ");
INSERT INTO dig_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Uwe undamjibu umuambe, ‘Huno mfugo ni mali ya mtumishio Jakobo na ni zawadiyo uwe bwana wangu Esau; na ye mwenye aredza ko nyuma.’ ” ");
INSERT INTO dig_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Piya wamlagiza vivyo mtumishi wa kundi ra phiri, ra hahu na osi ariokala nyuma ya go makundi achiaamba, “Muambireni Esau vivyo hivyo mchikutana naye. ");
INSERT INTO dig_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Tsona, msiyale kumuambira Esau, ‘Mtumishio Jakobo aredza ko nyuma.’ ” Jakobo waona andamhuriza na zira zawadi na achikutana naye mendzerepho andamswamehe. ");
INSERT INTO dig_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Kpwa hivyo, Jakobo watanguliza zira zawadi ela ye mwenye walala pho kambini usiku uho. ");
INSERT INTO dig_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Usiku uho, Jakobo walamuka na achihala achee osi airi, hara atumishie a chichetu airi na anae kumi na mwenga, achiavusa riko ra Jaboki. ");
INSERT INTO dig_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Bada ya kuavusa, wavusa malize zosi. ");
INSERT INTO dig_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Ela iye mwenye, wasala macheye phapho, watsembukirwa ni mutu, achibwagana naye hadi pepho za kucha. ");
INSERT INTO dig_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Yuya mutu ariphoona kaweza kumshinda Jakobo, wampiga chibiruni achihemuka nyonga wakati achere minyana naye. ");
INSERT INTO dig_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Chisha yuya mutu achiamba, “Nirichira niphiye mana kunacha.” Ela Jakobo achimuamba, “Sikurichira hadi unibariki.” ");
INSERT INTO dig_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Yuya mutu achimuuza, “Ndiwe ani?” Jakobo achimuamba, “Ndimi Jakobo.” ");
INSERT INTO dig_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Yuya mutu achiamba, “Vivi kundaihwa tsona Jakobo, undaihwa Iziraeli, mana ukabwagana na Mlungu na anadamu na ukashinda.” ");
INSERT INTO dig_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Jakobo achimuamba, “Tafadhali, niambira dzinaro.” Ela yuya mutu achiamba, “Kpwa utu wani unalonda umanye dzina rangu?” Chisha achimʼbariki Jakobo. ");
INSERT INTO dig_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Jakobo waphaiha phatu hipho Penieli mana waamba, “Nkaonana na Mlungu uso kpwa uso na nchere moyo.” ");
INSERT INTO dig_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Jakobo wauka Penieli wakati dzuwa rinatuluka naye kala anagutsira kpwa sababu ya yo nyongaye iriyohemulwa. ");
INSERT INTO dig_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ndiyo mana Aiziraeli hadi rero taarya nyama ya chibiruni mwandzo wa nyonga, kpwa sababu hipho ndipho ambapho Jakobo wapigbwa. ");
INSERT INTO dig_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jakobo watsupha matso achimuona Esau aredza na alume magana mane. Phahi, waganya achee na anae makundi mane, chila mchetu na anae. ");
INSERT INTO dig_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Waaika hara atumishi a chichetu na ana aho mbere, halafu Lea na anae, mwisho achimuika Raheli na Yusufu. ");
INSERT INTO dig_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Jakobo mwenye watanguliya mbere zao, achisujudu kano sabaa kuno anamsengerera nduguye. ");
INSERT INTO dig_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ela Esau achizola kpwedzamchinjira, achimtiya chifuwani na achimdonera; chisha osi achirira. ");
INSERT INTO dig_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Esau ariphotsupha matso na kuona hara achetu na ana ao, waamba, “Hano urio nao ni ano ani?” Jakobo achiamba, “Hano ni ana ambao Mlungu wanipha mimi mtumishio kpwa mbazize.” ");
INSERT INTO dig_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Ndipho hara anachetu na ana aho asengera na achimgbwerera maguluni. ");
INSERT INTO dig_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Chisha Lea na anae, nao akpwedza achimgbwerera maguluni. Mwisho, Yusufu na nine Raheli, nao akpwedza piya achimgbwerera maguluni. ");
INSERT INTO dig_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ndipho Esau achiuza, “Hira mifugo nchiyoiona kura njirani ni yaani?” Jakobo achiamba, “Bwana, ni zawadizo ili ukubali kunikaribisha.” ");
INSERT INTO dig_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ela Esau achiamba, “Nina mali ya kutosha mwenehu, maliyo naikale yako.” ");
INSERT INTO dig_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Jakobo achiamba, “Tafadhali bwana, nakuvoya! Ichikala kpweli ukanikubali, phahi phokera zawadi zangu nikuphazo. Kuona usoo ni kama kuona uso wa Mlungu, mana ukaniphokera vinono. ");
INSERT INTO dig_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Nakuvoya uphokere zawadi chizokurehera, mana Mlungu wanionera mbazi na achinipha chila chitu nilondacho.” Jakobo waenderera kumshurutisha Esau hadi achikubali. ");
INSERT INTO dig_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Esau achiamba, “Haya, nahuphiyeni; hundaphiyani phamwenga, mino nindakala mbere.” ");
INSERT INTO dig_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Ela Jakobo achimuamba, “Bwana wangu, unamanya kukala anache taana nguvu, na ni lazima nimanyirire higa mangʼondzi na ngʼombe ambazo zinaamwisa. Ichikala hino mifugo indatsungbwa mairo kpwa mairo, hata kpwa siku mwenga tu, phahi, mifugo indafwa. ");
INSERT INTO dig_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Kpwa hivyo, nakuvoya bwana wangu, utanguliye nami nredza pore-pore, mwendo wa hano anache na hino mifugo hadi hufike kpwako hiko Seiri.” ");
INSERT INTO dig_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esau achiamba, “Phahi nkurichire atu angu anjina akuterye.” Ela Jakobo achiamba, “Taina haja bwana wangu, vyo uchivyonionera mbazi, vinatosha.” ");
INSERT INTO dig_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Phahi siku iyo-iyo Esau wagbwira njira achiuya Seiri. ");
INSERT INTO dig_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Jakobo ariphofika Sukothi wadzidzengera nyumba na vibanda vya mifugoye. Ndiyo mana phatu hipho phaihwa Sukothi. ");
INSERT INTO dig_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Mwisho wa charoche, kula Padani-Aramu hadi tsi ya Kanani, Jakobo wafika salama mudzi wa Shekemu; achichita kambiye kondze chidide ya mudzi hinyo. ");
INSERT INTO dig_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Jakobo wagula hira seemu yokala akachita hemare kula kpwa ana a Hamori, ise wa Shekemu na vipande gana mwenga vya feza. ");
INSERT INTO dig_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Wadzenga phatu pha kulavira sadaka pho hipho na achiphaiha Eli-Elohe-Iziraeli, manaye ni “Mlungu, Mlungu wa Iziraeli.” ");
INSERT INTO dig_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Siku mwenga, Dina, mwana msichana wa Jakobo yemvyala na Lea, wakpwendaweha kpwa asenae achetu a tsi iyo. ");
INSERT INTO dig_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Mkpwulu wa seemu iyo kala ndiye Hamori, Mhivi, naye kala mwana mlume yeihwa Shekemu. Shekemu ariphomuona Dina wamgbwavukira. ");
INSERT INTO dig_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Moyowe kala ukamtsunuka Dina, mwana mchetu wa Jakobo na achikala anamchenga-chenga. ");
INSERT INTO dig_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ndipho Shekemu wamuambira ise aihwaye Hamori, “Baba, kaniuzire ulozi ili nilóle hiyu msichana.” ");
INSERT INTO dig_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Jakobo ariphophaha habari kukala mwanawe msichana akagbwavukirwa, anae alume kala a marisani na mifugoye; kpwa hivyo wanyamala hadi ariphouya kula marisani. ");
INSERT INTO dig_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hamori, isengbwa wa Shekemu wakpwedzabisha na Jakobo. ");
INSERT INTO dig_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Anangbwa a Jakobo ariphosikira mai gaga, auya kula marisani mara mwenga. Areya na achisikira utsungu sana, kpwa sababu Shekemu kala akatiya waibu atu a Iziraeli kpwa kulala na mwanáo wao, mana dzambo hiro ni mviga! ");
INSERT INTO dig_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamori wamuambira Jakobo, “Mwanangu Shekemu akamtsunuka yuya mwanao msichana, tafadhali kubali amlóle. ");
INSERT INTO dig_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Nahulózaneni, swiswi hulóle ana enu namwi mlóle ana ehu. ");
INSERT INTO dig_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Huchihenda hivyo, mundasagala phophosi mlondapho kahi za tsi hino, mundahenda bishara na mundakala na minda.” ");
INSERT INTO dig_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Chisha, Shekemu mwenye achimuambira Jakobo na anae alume, “Tafadhali nikubalini nami nindakuphani chochosi mlondacho. ");
INSERT INTO dig_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Niambirani chiasi chochosi cha mali na zawadi mlondazo, nindalavya chiasi chira ndichoniambira, bora tu mniloze Dina.” ");
INSERT INTO dig_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Ela ana a Jakobo amzunguluka Shekemu na ise Hamori kpwa sababu mwanao wao Dina kala akagbwavukirwa. ");
INSERT INTO dig_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Aambira, “Tahuweza kumloza mwenehu mutu ambaye kayadekpwa, mana chikpwehu uho ni waibu. ");
INSERT INTO dig_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Ela hundakukubalini ichikala mundakala dza swiswi, yani chila mlume adekpwe. ");
INSERT INTO dig_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Muchihenda hivyo, hundalozanani ana ehu achetu, na hundalóla ana enu achetu, naswi hundasagalani phamwenga na hundakala atu amwenga. ");
INSERT INTO dig_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ela napho tamundakubali kudekpwa, phahi, hundamhala mwenehu mchetu na huuke hipha.” ");
INSERT INTO dig_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Maneno higa gamhamira Hamori na mwanawe Shekemu. ");
INSERT INTO dig_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Barobaro hiyu Shekemu kayahenda chiziyaindi mana kala anammendza mwana wa Jakobo. Naye ndiye ambaye kala anaishimiwa sana kpwao kaya. ");
INSERT INTO dig_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Phahi, Hamori na Shekemu aphiya hadi ryango ra kuinjirira mudzini, phatu pha kuhenda mikutano na achibisha na ayawao. ");
INSERT INTO dig_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Achiaamba, “Atu hano ni asena ehu, aricheni asagale kahi za tsi na ahende bishara, mana tsi hino ni kulu ya kuatosha. Hunaweza kulóla ana aho nao akalóla ana ehu. ");
INSERT INTO dig_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ela atu hano andakubali kukala phamwenga naswi, na hukale atu amwenga napho chila mlume hiku kpwehu andadekpwa dza vivyo aho. ");
INSERT INTO dig_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Huchikubali hivyo, mifugo yao na mali zao zanjina zosi zindakala ni zehu. Phahi, nahukubalini ili asagale phamwenga naswi.” ");
INSERT INTO dig_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Hipho, atu osi okala pho mkpwutanoni akubali maneno ga Hamori na Shekemu, na alume osi a mudzi hinyo achitiywa tsatsani. ");
INSERT INTO dig_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Bada ya siku tahu, wakati vironda vya tsatsa vichereluma, ana airi a Jakobo, Simioni na Lawi, ndugungbwa airi a Dina, ainjira chisiri mudzi hinyo, chila mmwenga na upangawe, na achiolaga alume osi ");
INSERT INTO dig_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","phamwenga na Hamori na Shekemu. Chisha achimuhala Dina kula nyumbani mwa Shekemu na achiuka. ");
INSERT INTO dig_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Badaye ana alume osi a Jakobo akpwendahala zewe mali yosi ya mudzi hinyo, kudziriphiza kpwa waibu uriotiywa mwanáo wao msichana. ");
INSERT INTO dig_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ahala zewe ngʼombe, mbuzi, mangʼondzi na punda, nyama osi okala mo mudzini na okala kondze weruni. ");
INSERT INTO dig_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Ateka achetu osi na anache na chila chitu cha samani, ahala vitu vyosi vyokala madzumbani. ");
INSERT INTO dig_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Halafu Jakobo waambira Simioni na Lawi, “Mkanibwagira likuni ra adudu; sambi Akanani na Aperizi, ambao ni enyezi a tsi hino, andanizira. Swiswi hu achache tu, ichikala andagbwirana edze ahupige, phahi, andahuangamiza hosi.” ");
INSERT INTO dig_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ela aho achimuambira ise yao, “Kpwani che unalonda huariche amuhende mwenehu wehu avi ni malaya?” ");
INSERT INTO dig_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Halafu Mlungu wamuambira Jakobo, “Mimi ndimi Mlungu yekutsembukira wakati kala unamchimbira mwenenu Esau. Tsama ukasagale Betheli, na kuko ukanidzengere phatu pha kulavira sadaka.” ");
INSERT INTO dig_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Ndipho Jakobo achiambira achee, anae na atu osi ariokala nao, “Richani milungu ya chijeni mriyo nayo, dzitakaseni na mvwale nguwo swafi. ");
INSERT INTO dig_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Hundatsamani kuphiya Betheli ili nikamdzengere Mlungu phatu pha kulavira sadaka, Mlungu yeniterya wakati wa tabu na ambaye wanirinda chila nriphophiya.” ");
INSERT INTO dig_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Phahi amupha Jakobo milungu ya chijeni yosi ariyokala nayo na vipuli vyokala akavwala masikironi, naye achivizika kolo ya mwaloni phephi na mudzi wa Shekemu. ");
INSERT INTO dig_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Jakobo na anae ariphokala anauka, atu a midzi ya jirani atiywa wuoga munji ni Mlungu hata taawezere kuavamia. ");
INSERT INTO dig_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jakobo na atue osi atsoloka Betheli tsi iyo-iyo ya Kanani. (Mwandzo Betheli kala yiihwa Luzu.) ");
INSERT INTO dig_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Wamdzengera Mlungu phatu pha kulavira sadaka phapho na achiphaiha Eli-Betheli, mana hipho ndipho Mlungu phomtsembukira wakati anamchimbira mwanáo. ");
INSERT INTO dig_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Debora, mtumishi mchetu wa Rebeka, wafwa na achizikpwa kolo ya mwaloni, uphande wa mwakani wa Betheli. Kpwa hivyo, muhi hinyo uchiihwa “Mwaloni wa Chiriro.” ");
INSERT INTO dig_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Jakobo ariphouya kula Padani-Aramu, Mlungu kala akamtsembukira tsona na kala akambariki. ");
INSERT INTO dig_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Mlungu kala akamuamba, “Uwe ndiwe Jakobo, ela kundaihwa Jakobo tsona, undaihwa Iziraeli.” Kpwa hivyo achimuiha Iziraeli. ");
INSERT INTO dig_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Chisha Mlungu kala akamuamba, “Mimi ndimi Mlungu Mwenye Nguvu Zosi; vyala ana anji na uenjerezeke. Undakala mkarengbwa wa makabila na afalume. ");
INSERT INTO dig_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Tsi yomlaga Burahimu na Isaka nindakupha uwe na vivyazivyo.” ");
INSERT INTO dig_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Ariphomala kugomba na Jakobo, Mlungu wauka achipaa dzulu. ");
INSERT INTO dig_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Jakobo kala akaimisa dziwe ra kumbukumbu phara ambapho Mlungu kala akagomba naye. Piya kala akarimwagira uchi wa zabibu na mafuha. ");
INSERT INTO dig_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Jakobo waphaiha Betheli pho phatu ariphokala akagomba na Mlungu. ");
INSERT INTO dig_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Halafu Jakobo na atue auka Betheli; ariphokala achere hatuwa na Efuratha, Raheli wagbwirwa ni utsungu mkali wa uvyazi. ");
INSERT INTO dig_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Na wakati kala akavyala na ndani inazingizi, mvyalusadzi wamuamba, “Usiogophe, ukaphaha mwana mlume wanjina.” ");
INSERT INTO dig_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Ela kala anafwa, na wakati wa kudosa yuya mwanawe wamuiha Beni-Oni, ela ise achimuiha Benjamini. ");
INSERT INTO dig_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Phahi Raheli wafwa na achizikpwa kanda-kanda ya njira ya kuphiya Efuratha (yani Bethilehemu). ");
INSERT INTO dig_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jakobo waika dziwe ra kumbukumbu pho mbirani, na richere phapho hata rero. ");
INSERT INTO dig_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Jakobo wasengera tsona na achendachita hemare kutsapa gorofa ya Ederi. ");
INSERT INTO dig_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Wakati Iziraeli kala asagala tsi iyo, mwanawe Rubini walala na Biliha, mwanachetu wa ise, na Iziraeli achigasikira. Jakobo kala ana kumi na airi alume. ");
INSERT INTO dig_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Ana alume a Lea kala ni: Rubini (mwana mvyere wa Jakobo), Simioni, Lawi, Juda, Isakari na Zabuloni. ");
INSERT INTO dig_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Ana alume a Raheli kala ni Yusufu na Benjamini. ");
INSERT INTO dig_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Ana alume ariovyalwa ni Biliha, mtumishi mchetu wa Raheli, kala ni Dani na Nafutali. ");
INSERT INTO dig_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Ana alume ariovyalwa ni Zilipa, mtumishi mchetu wa Lea, kala ni Gadi na Asheri. Hinya ndio ana alume a Jakobo, ariovyalwa Padani-Aramu. ");
INSERT INTO dig_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jakobo waphiya kpwa ise Isaka hiko Mamre, phephi na Kiriathi-Ariba (yani Heburoni), ambako Burahimu na Isaka asagala. ");
INSERT INTO dig_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaka waishi miaka gana mwenga na mirongo minane. ");
INSERT INTO dig_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Wafwa mtumia sana, warya munyu munji. Anae Esau na Jakobo amzika phao vikurani, phozikpwa tsawe yao Burahimu. ");
INSERT INTO dig_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Hivi ndivyo vivyazi vya Esau (yani Edomu). ");
INSERT INTO dig_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau walóla achetu a Chikanani: Ada mwana wa Eloni, Muhiti, na Oholibama, mwana wa Ana, mdzukulu wa Sibeoni, Mhivi. ");
INSERT INTO dig_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Piya walóla Basemathi, mwana wa Isimaili, ndugungbwa mchetu wa Nebayothi. ");
INSERT INTO dig_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada wavyala Elifazi na Basemathi achivyala Reueli; ");
INSERT INTO dig_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama wavyala Jeushi, Jalamu na Kora. Hano ni ana alume a Esau, ambao avyalwa tsi ya Kanani. ");
INSERT INTO dig_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Halafu Esau wahala achee, anae alume na achetu na atue osi a phakpwe kaya, phamwenga na mifugoye yosi na malize zosi arizozitsuma tsi ya Kanani, achitsama tsi yanjina kure na nduguye Jakobo. ");
INSERT INTO dig_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Watsama kpwa sababu tsi yosagala kala taiatosha iye na Jakobo. Taayaweza kpwenderera kusagala phamwenga, mana osi kala ana mifugo minji. ");
INSERT INTO dig_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Kpwa hivyo Edomu (yani Esau) achendasagala tsi ya myango ya Seiri. ");
INSERT INTO dig_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Hivi ndivyo vivyazi vya Esau, mkarengbwa wa Aedomu, hiko kpwenye myango ya Seiri: ");
INSERT INTO dig_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Ada, mkpwaza Esau, wavyala mwana mlume Elifazi naye wavyala ana atsano alume: Temani, Omari, Sefo, Gatamu na Kenazi. Piya wavyala mwana mlume wanjina na mwanachetuwe yeihwa Timuna; mwana hiyu waihwa Amaleki. Naye Basemathi, mkpwaza Esau, wavyala mwana mlume yemuiha Reueli. Hiyu Reueli wavyala ana a ne alume: Nahathi, Zera, Shama na Miza. ");
INSERT INTO dig_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Mchetu wanjina wa Esau kala ni Oholibama, mwana wa Ana, mdzukulu wa Sibeoni. Oholibama wavyala ana ahahu alume: Jeushi, Jalamu na Kora. ");
INSERT INTO dig_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Hano kala ndio madzumbe a chivyazi cha Esau: Ana alume a Elifazi, mwana mvyere wa Esau, kala ni madzumbe hano: Temani, Omari, Sefo, Kenazi, ");
INSERT INTO dig_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Gatamu na Amaleki. Hano kala ni atu kula Edomu, adzukulu a Ada, mkpwaza Esau. ");
INSERT INTO dig_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Ana alume a Reueli kpwenye tsi ya Edomu kala ni madzumbe hano: Nahathi, Zera, Shama na Miza. Hano kala ni adzukulu a Basemathi, mkpwaza Esau. ");
INSERT INTO dig_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Ana alume a Oholibama, mkpwaza Esau, kala ni madzumbe hinya: Jeushi, Jalamu na Kora. ");
INSERT INTO dig_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Phahi, huno ndio uvyazi wa Esau (yani Edomu), chila mmwenga kala ni dzumbe wa mbariye. ");
INSERT INTO dig_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Seiri, mutu wa kabila ra Ahori, kala ni mwenyezi wa tsi iyo. Hano ndio anae alume: Lotani, Shobali, Sibeoni, Ana, ");
INSERT INTO dig_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishoni, Eseri na Dishani. Hinya kala ni madzumbe a Ahori, ana a Seiri hiko tsi ya Edomu. ");
INSERT INTO dig_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Ana alume a Lotani kala ni Hori na Hemani. (Lotani kala ana nduguye mchetu yeihwa Timuna). ");
INSERT INTO dig_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Ana alume a Shobali kala ni Alivani, Manahathi, Ebali, Shefo na Onamu. ");
INSERT INTO dig_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Ana alume a Sibeoni kala ni Aya na Ana. (Ana hiyu ndiye yekala wa kpwandza kuona madzi ga moho galago kuzimu ko weruni phokala anarisa punda a ise Sibeoni). ");
INSERT INTO dig_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Anangbwa a Ana kala ni airi Dishoni, mwana mlume, na Oholibama, mwana mchetu. ");
INSERT INTO dig_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Ana alume a Dishoni kala ni Hemudani, Eshibani, Ithirani na Kerani. ");
INSERT INTO dig_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ana alume a Eseri kala ni Bilihani, Zaawani na Akani. ");
INSERT INTO dig_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Ana alume a Dishani kala ni Usi na Arani. ");
INSERT INTO dig_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Kuuyira, naamba, madzumbe ga Ahori kala ni Lotani, Shobali, Sibeoni, Ana, ");
INSERT INTO dig_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dishoni, Eseri na Dishani. Aha kala ni vilongozi a Ahori kulengana na mbari zao hiko tsi ya Seiri. ");
INSERT INTO dig_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Hinya ndio afalume ariotawala tsi ya Edomu kabila ya mfalume yeyesi kutawala atu a Iziraeli. ");
INSERT INTO dig_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela mwana wa Beori watawala tsi ya Edomu, na mudziwe kala unaihwa Dinihaba. ");
INSERT INTO dig_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela ariphofwa, Jobabu mwana wa Zera, watawala badalaye kula mudzi wa Bosira. ");
INSERT INTO dig_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Bada ya Jobabu, wakpwedza Hushamu kula tsi ya Atemani. ");
INSERT INTO dig_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Chisha achedza Hadadi mwana wa Bedadi, kula mudzi wa Avithi (iye wapiga Amidiani na achiashinda kahi za tsi ya Amoabu). ");
INSERT INTO dig_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadadi ariphofwa, yetawala badaye ni Samula kula mudzi wa Masireka, ");
INSERT INTO dig_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","alafu achilungirwa ni Shauli kula mudzi wa Rehobothi phephi na muho. ");
INSERT INTO dig_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Shauli ariphofwa, Baali-Hanani, mwana wa Akibori watawala. ");
INSERT INTO dig_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baali-Hanani ariphofwa walungirwa ni Hadadi kula mudzi wa Pau mchewe kala aihwa Mehetabeli, mwana wa Matiredi mwana mchetu wa Mezahabu. ");
INSERT INTO dig_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Higa ni madzina ga madzumbe ga atu a chivyazi cha Esau, ambao madzina gao ndigo gokala madzina ga miryango yao na malalo gao gosagala: Timuna, Aliva, Jethethi, Oholibama, Ela, Pinoni, Kenazi, Temani, Mibusari, Magidieli, na Iramu. Hinyo ndio atu a chivyazi cha Esau, mkarengbwa wa Aedomu. ");
INSERT INTO dig_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","2","Hizi ni habari kuhusu Jakobo na anae. Jakobo na anae aenderera kusagala Kanani, tsi yosagala ise. Yusufu ariphokala ni mvulana wa miaka kumi na sabaa, kaziye kala nkurisa mbuzi na mangʼondzi ga ise Jakobo; kala achirisa na nduguze alume, nduguze anababa. Ana a Biliha na Zilipa, akaza ise. Yusufu wakpwedzamuambira ise mambo mai gohendwa ni nduguze. ");
INSERT INTO dig_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Phahi, Iziraeli kala anammendza sana Yusufu kuriko anae anjina osi, mana kala ni mwanawe wa utumiani. Wamshonera kandzu maridadi. ");
INSERT INTO dig_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Nduguze ariphoona ise yao anammendza sana kuriko aho osi, amzira na achikala taagomba naye vinono. ");
INSERT INTO dig_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Siku mwenga usiku, Yusufu waloha ndoso, na ariphoisemurira nduguze, aho azidi kumzira. ");
INSERT INTO dig_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Waambira, “Phundzani nikuambireni ndoso nchiyoloha: ");
INSERT INTO dig_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Nkaloha hu mundani hunafunga mabutsa, gafula butsa rangu rikaunuka rikaima, genu gakarizunguluka rira rangu na gakarizamira kuripha ishima.” ");
INSERT INTO dig_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Nduguze achimuamba, “Hivi unaona undakala mfalume wehu, uhutawale?” Ndipho nduguze achizidi kumzira kpwa hira ndosoye na manenoge. ");
INSERT INTO dig_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Halafu siku yanjina waloha tsona na achiasemurira nduguze achiamba, “Lolani! Nkaloha ndoso yanjina, dzuwa, mwezi na nyenyezi kumi na mwenga zikanigbwerera maguluni kunipha ishima.” ");
INSERT INTO dig_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Yusufu piya wamuambira ise ndoso iyo, ela ise achimdemurira, achimuamba, “Ni ndoso ya viphi yo! Yani unaona mayoo, enenu na mimi kpweli hunaweza kukugbwerera maguluni?” ");
INSERT INTO dig_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Nduguze amuonera wivu, ela ise wagaika moyoni. ");
INSERT INTO dig_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Phahi, siku mwenga, ndugungbwa a Yusufu kala a marisani phephi na Shekemu, anarisa mbuzi na mangʼondzi ga ise yao. ");
INSERT INTO dig_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Iziraeli wamuambira Yusufu, “Nduguzo anarisa hiko phephi na Shekemu, nalonda nikuhume kuko.” Naye achiamba, “Haya, baba.” ");
INSERT INTO dig_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Ise achiamba, “Phiya ukalole nduguzo napho taana neno, na mifugo ichikala i salama, chisha wedze uniambire.” Ndipho achiuka kaya, Dete ra Heburoni, kuphiya Shekemu. ");
INSERT INTO dig_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Yusufu ariphofika Shekemu wadengereka mo weruni kuendza nduguze; mutu mmwenga achimuona achimuuza, “Unaendzani?” ");
INSERT INTO dig_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yusufu achimuamba, “Naendza enehu, tafadhali niambira arisako.” ");
INSERT INTO dig_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Yuya mutu achimuamba, “Auka hipha, mana náasikira anaamba, ‘Huphiyeni Dothani.’ ” Kpwa hivyo, Yusufu walunga-lunga nduguze na achendaaona Dothani. ");
INSERT INTO dig_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Mbavi nduguze amuona hangu achere kure, na kabila kadzangbwefika ampangira njama ili amuolage. ");
INSERT INTO dig_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Abisha nyo enye kpwa enye achiamba, “Hiye mlohadzi wa ndoso aredza! ");
INSERT INTO dig_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Sambi nahumuolageni na humtsupheni ndani ya chisima chimwengachapho; halafu hundaamba akariwa ni nyama mʼbaya. Hulole hizo ndosoze zindahendadze.” ");
INSERT INTO dig_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Rubini ariphoona hivyo, walonda kumtivya Yusufu asiolagbwe ni nduguze achiamba, “Nahusimuolage. ");
INSERT INTO dig_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Msimwage mlatso. Mtsupheni mu chisimani phapha weruni, ela msimgute.” Rubini waamba hivyo ili amtivye na badaye amuuyize kaya kpwa ise. ");
INSERT INTO dig_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Phahi, Yusufu ariphofika kura kpwa nduguze, hara nduguze amgbwira na achimvula kandzuye, hira kandzu maridadi yokala akavwala, ");
INSERT INTO dig_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","achimuhala achimtsupha chisimani, ela kala tachina madzi. ");
INSERT INTO dig_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Wakati nduguze Yusufu kala asegere anarya, aona likongo ra atu a Isimaili, ahendadzi-bishara ala Giliadi anaphiya Misiri. Ngamia aho kala akatsukula vilungo vya kujitira, dawa ya mavune na uvumba. ");
INSERT INTO dig_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Juda waambira nduguze, “Pho swino hundaphahani huchimuolaga ndugu yehu na kufwitsa chifoche? ");
INSERT INTO dig_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Nahumguzeni kpwa hinya atu a Isimaili ela nahusimguteni, mana ni ndugu yehu, ni mlatso wehu kabisa.” Nduguze achikubali. ");
INSERT INTO dig_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Hipho, rira likongo ra ahendadzi-bishara a Chimidiani ariphofika phara, hara nduguze Yusufu amtuluza mo chisimani na achimguza na atu a Isimaili kpwa vipande mirongo miiri vya feza, nao achimphirika Misiri. ");
INSERT INTO dig_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Wakati wa kuguzwa Yusufu, Rubini kala kapho na kamanyire kukala nduguze akamguza. Ariphouya, chisimani na achiona Yusufu kamo, wakpwanyula nguwoze kpwa utsungu. ");
INSERT INTO dig_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Achiauyira nduguze achendaambira, “Yuya mvulana kamo mo chisimani! Simanya nihendedze?” ");
INSERT INTO dig_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Halafu nyo nduguze atsindza mbuzi na achihala hira kandzu ya Yusufu achiivwika mo mlatsoni. ");
INSERT INTO dig_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Chisha aihala hira kandzu maridadi hadi kpwa ise yao na achendamuamba, “Lola, baba, hukatsola kandzu, hebu ilole ichikala ni ya Yusufu.” ");
INSERT INTO dig_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ise yao waitambukira na achiamba, “Ni kandzu ya mwanangu, nyama mbaya wamurya! Hakika Yusufu wagbwirwa achiriwa!” ");
INSERT INTO dig_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Jakobo wakpwanyula nguwoze achivwala magunia kpwa utsungu. Wamririra mwanawe siku nyinji. ");
INSERT INTO dig_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Anae osi alume na achetu amʼbembeleza, ela achirema. Achiamba, “Aa, nindamririra mwanangu hadi ndiphophiya ko kuzimu ariko.” Phahi, waenderera kumririra mwanawe. ");
INSERT INTO dig_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Wakati hinyo-hinyo, hiko Misiri, hara ahendadzi-bishara a Chimidiani amguza Yusufu kpwa Potifa, mmwenga wa atumishi a Farao, ambaye kala ni mkpwulu wa asikari a urindzi. ");
INSERT INTO dig_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Wakati hinyo, Juda watsama pha nduguze na achendasagala na mutu mmwenga aihwaye Hira, kula mudzi wa Adulamu. ");
INSERT INTO dig_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Juda ariphokala hiko, wakutana na msichana wa Chikanani, mwana wa Shuwa, na achimlóla. ");
INSERT INTO dig_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Wagbwira mimba na achivyala naye mwana mlume, achimuiha Eri. ");
INSERT INTO dig_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Wagbwira mimba tsona na achivyala mwana mlume wanjina, nine achimuiha Onani. ");
INSERT INTO dig_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Chisha wavyala mwana mlume wanjina achimuiha Shela. Juda kala asagala Kezibu mwanawe hiyu phovyalwa. ");
INSERT INTO dig_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Juda wamlóza Eri, mwanawe mvyere; mchetu yeihwa Tamari. ");
INSERT INTO dig_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ela Eri, mwana wa kpwandza wa Juda, kala ni mutu mui, uyiwe wamreyeza Mwenyezi Mlungu, na Mwenyezi Mlungu achimuolaga. ");
INSERT INTO dig_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Ndipho Juda achimuambira Onani, “Muhale hiyu gungu wa mfwadzi mwenenu, ili umvyarire mwenenu mrisi, mana ndiyo shariya.” ");
INSERT INTO dig_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ela Onani wamanya kukala mwana ndiyevyalwa, siye wakpwe, kpwa hivyo chila aripholala naye, mbeyu wazimwaga photsi, ili nduguye asiphahe mwana. ");
INSERT INTO dig_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Gaga arigogahenda kala ni mai matsoni pha Mwenyezi Mlungu, naye piya achimuolaga. ");
INSERT INTO dig_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Ndipho Juda achimuambira mkpwaza-mwanawe Tamari, “Mayo, uya kaya kpwa sowe, na ukasale gungu hadi mwanangu Shela ndiphokala mvyere.” Waamba hivyo, mana waogopha kukala mwanawe naye andafwa dza nduguze. Kpwa hivyo, Tamari wauya kpwa ise. ");
INSERT INTO dig_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Bada ya muda mure mkpwaza Juda, mwana wa Shuwa wafwa. Ariphokala rohore rikadigirika kuhusu chifo cha mchewe, wauka na msenawe Hira kula Adulamu, na achiphiya Timuna ambako mangʼondzige kala ganakatwa nyoya. ");
INSERT INTO dig_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tamari ariphoambwa, “Sowe-vyala anaphiya Timuna kpwendakata nyoya mangʼondzige,” ");
INSERT INTO dig_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","wavula nguwoze za ugungu, achidzibwiningiza utaji ili asimanyikane, halafu achendasagala ryango ra kuinjirira Enaimu, ririro njira ya kuphiya Timuna. Mana waona kukala Shela akakula, ela Juda kamloza akakala mkpwaza Shela. ");
INSERT INTO dig_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Juda ariphomuona Tamari, waona labuda ni malaya, mana kala akadziziba uso. ");
INSERT INTO dig_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Juda kamanyire kukala ni mkpwaza-mwanawe. Juda waphiya pho kanda-kanda ya njira ariphokala, achimuamba, “Nalonda nlale na uwe.” Achimuamba, “Undaniphani uchilala na mimi?” ");
INSERT INTO dig_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Achimuamba, “Nindakurehera mwana mbuzi kula kpwangu chaani.” Naye achiamba, “Ika chitu mzamana hadi ndiphoreha mwana mbuzi.” ");
INSERT INTO dig_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Juda achiamba, “Niike utu wani mzamana?” Naye achiamba, “Nipha yo peheyo ya muhuri, lugbwero na bakorayo.” Ndipho Juda achimupha vira vitu na achilala naye, naye achigbwira mimba. ");
INSERT INTO dig_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Tamari ariphouya kaya, wavula hura utaji na achivwala tsona nguwoze za ugungu. ");
INSERT INTO dig_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Badaye Juda wahuma msenawe Hira kula Adulamu amphirikire yuya mchetu mwana mbuzi ili auyizirwe vituvye vyoviika mzamana, ela Hira kamuonere yuya mchetu. ");
INSERT INTO dig_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Hira wauza enyezi alume achiamba, “A kuphi yuya malaya yekala hipha Enaimu kanda-kanda ya njira?” Aho achiamba, “Taphadzangbwekala na malaya yeyesi hipha.” ");
INSERT INTO dig_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Ndipho, Hira wauya kpwa Juda na achendamuamba, “Sikamphaha, tsona atu a hiko anaamba taphadzangbwekala na malaya yeyesi.” ");
INSERT INTO dig_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Juda achiamba, “A! Nahumriche navyo, sedze akahuricha hukatsekpwa. Mino nkamuhumira mwana mbuzi umphirikire, ela kumuonere.” ");
INSERT INTO dig_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Bada ya kama miezi mihahu, Juda waambirwa, “Mkpwaza-mwanao Tamari wahenda umalaya vino ana mimba.” Juda achiamba, “Kamtuluzeni kondze mmutiye moho afwe.” ");
INSERT INTO dig_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ariphotuluzwa kondze, walavya muhumwa kpwa ise-vyala akamuambe, “Mwenye vitu hivi ndiye yenitiya mimba. Tafadhali vilole ichikala undamanya ni vya ani; Pehe ihi ya muhuri, mkowa uhu na bakora ihi.” ");
INSERT INTO dig_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Juda ariphoviona, wavitambukira na achiamba, “Mchetu hiyu ana haki kuriko mimi, mana siyamlóza mwanangu Shela.” Juda kayalala naye tsona. ");
INSERT INTO dig_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Wakatiwe wa kudzivugula uriphofika, wavyala patsa ya alume ahuphu. ");
INSERT INTO dig_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Saa ya kudzivugula, mmwenga watuluza mkpwono phondze, halafu mvyalusadzi achihala wuuzi wa kundu achimfunga mkpwononi na achiamba, “Hiyu ndiye chiyevyalwa na mbere.” ");
INSERT INTO dig_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ela ariphouyiza mkpwonowe ndani, nduguye wavyalwa, chisha yuya mvyalusadzi achiamba, “Mbona we ukatsapa kpwa nguvu!” Phahi hiyu waihwa Peresi. ");
INSERT INTO dig_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Badaye, nduguye yekala ana wuuzi wa kundu mkpwononi wavyalwa, achiihwa Zera. ");
INSERT INTO dig_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Phahi, atu a Isimaili kala akamphirika Yusufu Misiri na kala akamguza kpwa Potifa, mmwenga wa atumishi a mfalume, ambaye kala ni mkpwulu wa arindzi. ");
INSERT INTO dig_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Mwenyezi Mlungu wamjaliya Yusufu na achiongokerwa kahi ya chila arirohenda. Naye kala asagala nyumbani mwa tajiriwe, Mmisiri. ");
INSERT INTO dig_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Potifa wamanya kukala Mwenyezi Mlungu a phamwenga na Yusufu na nkumuhenda afwanikiwe kahi za chila ahendaro. ");
INSERT INTO dig_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Phahi, Potifa wahamirwa ni Yusufu hata achimuhenda mtumishiwe binafsi. Wamuhenda muimirizi wa mudziwe na achimuamini kuimirira malize zosi. ");
INSERT INTO dig_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Hangu siku ambayo Potifa wamuhenda Yusufu muimirizi wa nyumbaye na malize zosi, Mwenyezi Mlungu waujaliya mudzi wa Potifa kpwa sababu ya Yusufu. Mwenyezi Mlungu wabariki chila chitu cha Potifa, hangu vitu vya nyumbani hadi vya mundani. ");
INSERT INTO dig_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Ndipho Potifa achimrichira Yusufu vituvye vyosi mwakpwe mikononi, na iye mwenye kayadzishuulisha na chitu chochosi isiphokala chakurya chorya. Yusufu kala ni barobaro mnono wa sura na umbo. ");
INSERT INTO dig_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Bada ya muda mkpwaza tajiriwe wagbwirwa ni tamaa kpwa ajili ya Yusufu, na achimuamba, “Ndzo ulale na mimi.” ");
INSERT INTO dig_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ela iye warema na achimuamba, “Lola, tajiri wangu kadzishuulisha na chitu chochosi himu nyumbani, waniamini, vituvye vyosi vi mwangu mikononi. ");
INSERT INTO dig_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Hipha kaya, uchiusa Potifa, taphana mkpwulu wanjina kuriko mimi; tajiri wangu kadzangbwenikahaza chitu chochosi isiphokala uwe, mana u mchewe. Indakaladze sambi, nihende chitu chii dza hichi ambacho ni dambi kpwa Mlungu?” ");
INSERT INTO dig_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Dzagbwe wamchenga-chenga Yusufu chila siku, ela Yusufu kayakubali kulala naye wala kukala phephi naye. ");
INSERT INTO dig_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Siku mwenga Yusufu wamenya nyumbani ili ahende kazize, namo kala tamuna mtumishi wanjina. ");
INSERT INTO dig_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Mkpwaza Potifa wamgbwira vwazi achimuamba, “Ndzo, ulale na mimi!” Ela Yusufu wachimbira kondze, achimrichira vwazire. ");
INSERT INTO dig_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Yuya mchetu ariphomanya kukala Yusufu akamrichira vwazire na kuzola kondze, ");
INSERT INTO dig_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","waiha atumishie a nyumbani na achiaambira, “Lolani! Hwareherwa hiyu Mueburania kpwedzahuifya. Akedza himu nyumbani kpwedzanigbwavukira, ela nkakota kululu. ");
INSERT INTO dig_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Achiphoona nakota kululu, akazola kondze, akaricha vwazire phapha.” ");
INSERT INTO dig_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Mkpwaza Potifa wakala na rira vwazi ra Yusufu hadi mlumewe ariphouya kaya. ");
INSERT INTO dig_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Wamsemurira gago, achimuamba, “Yuya mtumwa wa Chieburania uriyehurehera che analonda kunigbwavukira. ");
INSERT INTO dig_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ela, nchiphokota kululu, akazola kondze na akaricha vwazire.” ");
INSERT INTO dig_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Tajiriwe ariphosikira vira mchewe chivyohendwa ni mtumwawe, watsukirwa sana. ");
INSERT INTO dig_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Wamuhala Yusufu achendamtiya jela, phatu ambapho mabusu ga mfalume kala gachifungbwa. Ela wakati Yusufu kala a hiko jela, ");
INSERT INTO dig_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Mwenyezi Mlungu kala a phamwenga naye. Wamuonyesa mendzwaye isiyosika kpwa kumuhenda amendzwe ni muimirizi wa jela. ");
INSERT INTO dig_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ye muimirizi wa jela wamuika Yusufu akale mkpwulu wa mabusu ganjina gosi na aimirire chila chitu chohendwa himo. ");
INSERT INTO dig_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Mkpwulu wa jela kala kadzishuulisha na chitu chochosi ambacho kala chi tsini ya Yusufu, kpwa sababu Mwenyezi Mlungu kala a phamwenga naye, na chila arihendaro kala rinaongokerwa. ");
INSERT INTO dig_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Bada ya muda, mlavyadzi uchi mkpwulu na mkpwulu wa apishi amkosera tajiri wao, mfalume wa tsi ya Misiri. ");
INSERT INTO dig_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Mfalume watsukizwa sana ni hano atumishi airi, ");
INSERT INTO dig_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","na achiafunga jela yokala akafungbwa Yusufu. Jela iyo kala i tsini ya Potifa, mkpwulu wa arindzi. ");
INSERT INTO dig_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Potifa wamuika Yusufu akale mtumishi wao. Nao akala mo jela kpwa muda. ");
INSERT INTO dig_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Siku mwenga usiku, mo jela, mlavyadzi wa uchi na mpishi a mfalume wa Misiri, aloha ndoso na chila ndoso kala ina manage. ");
INSERT INTO dig_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Ligundzure Yusufu ariphokpwedza, waaona kukala taana raha. ");
INSERT INTO dig_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Phahi waauza maofisaa a Farao, “Mbona rero tamuna raha?” ");
INSERT INTO dig_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Achimuamba, “Chila mmwenga wehu akaloha ndosoye ela taphana amanyaye manage.” Yusufu achiamba, “Dze, si Mlungu avugulaye ndoso? Haya, niambirani ndoso zenu.” ");
INSERT INTO dig_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Phahi, yuya mlavyadzi uchi mkpwulu wamuambira Yusufu ndosoye, achimuamba, “Mwangu ndosoni, nkaona mzabibu mbere zangu, ");
INSERT INTO dig_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","nao che una panda tahu. Uriphotuluza makodza tu, ukatuluza maruwa na gara maruwa gakavyala zabibu, na zikaivwa. ");
INSERT INTO dig_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Mimi che Nkagbwiririra chikombe cha mfalume mwangu mkpwononi. Phahi nkahala zira zabibu, nkaziminya chikombeni mwa mfalume na nkamupha mkpwononi.” ");
INSERT INTO dig_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yusufu achimuamba, “Higa ndigo manage. Mana ga zira panda tahu ni siku tahu. ");
INSERT INTO dig_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Kabila ya siku tahu mfalume andakuswamehe, akutuluze jela na akuuyize phako kazini. Undakala uchimupha chikombeche, dza vira mwandzo, wakati kala u mlavyadzi wa uchi. ");
INSERT INTO dig_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ela nakuvoya mambo gachikuphihirato unitambukire na unionere mbazi, rihadze dzina rangu mbere za mfalume ili unihende nituluzwe jela. ");
INSERT INTO dig_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Mana náhendatekpwa kula tsi ya Aeburania, na hata phapha sidzangbwehenda rorosi ra kunihenda nifungbwe jela.” ");
INSERT INTO dig_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Mpishi mkpwulu ariphoona mana ga ndoso hira ni manono, wamuambira Yusufu, “Hata mimi piya nkaloha! Mo ndosoni che nkadzihika nyungo tahu za mabofulo. ");
INSERT INTO dig_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Lungo ra dzulu che rina vyakurya aina tafwauti-tafwauti vya kuochwa dza mabofulo. Vyakurya hivyo che ni vya mfalume. Ela nyama a mapha che anavirya mo lungoni phangu chitswani.” ");
INSERT INTO dig_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yusufu achimuamba, “Ndosoyo manage ni hino: Zira nyungo tahu ni siku tahu. ");
INSERT INTO dig_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Kabila ya siku tahu mfalume andakukata chitswa na mwirio andautsomeka dzulu gongoni, na nyama a mapha andaurya.” ");
INSERT INTO dig_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Sambi, siku ya hahu mfalume kala anasherekeya sikuye ya kuvyalwa, waalika karamu atumishie osi. Achituluza jela mlavyadzi uchi mkpwulu na mkpwulu wa apishi na achiareha phara phokala phana atumishie. ");
INSERT INTO dig_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Achimuuyiza kazini mlavyadzi uchi mkpwulu, na achikala analavya uchi tsona kpwa mfalume. ");
INSERT INTO dig_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Ela mfalume wamuolaga yuya mkpwulu wa apishi, na mwiriwe achiutsomeka dzulu gongoni viratu Yusufu vyomvugurira ndosoye. ");
INSERT INTO dig_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ela yuya mlavyadzi uchi mkpwulu wayala gara goambirwa ni Yusufu. ");
INSERT INTO dig_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Bada ya miaka miiri, Farao waloha aimire kanda-kanda ya muho wa Naili. ");
INSERT INTO dig_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Pho muhoni phatuluka ngʼombe sabaa za kunona, zichiandza kurisa pho kanda-kanda ya muho. ");
INSERT INTO dig_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Halafu phachituluka ngʼombe zanjina sabaa; hizi kala zikaonda hata zinatisha, zichiima kanda ya nyo muho Naili phephi na zira nono za kunona. ");
INSERT INTO dig_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Zira ngʼombe za kuonda zichirya zira za kunona, Farao achilamuka. ");
INSERT INTO dig_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Achigbwirwa ni usingizi tsona, na achiloha ndoso yanjina. Waona mʼbuwa mmwenga wa muhama ukavyala masuche sabaa manono garigo tele tembe. ");
INSERT INTO dig_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Badaye, waona mʼbuwa wanjina ukatsephuza masuche ganjina sabaa madide, garigonyala kpwa dzuwa na phuto. ");
INSERT INTO dig_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Gara masuche sabaa madide ga kunyala gamiza gara sabaa manono. Mfalume achilamuka, na achimanya mbavi che analoha. ");
INSERT INTO dig_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ligundzure mfalume achikala ana wasiwasi, phahi achilagiza aganga na atu osi a ikima a Misiri aihwe. Waasemurira ndosoze ela taphana hata mmwenga yeweza kuzivugula. ");
INSERT INTO dig_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Phahi yuya mlavyadzi-uchi mkpwulu wamuamba mfalume, “Rero natambukira makosa gangu! ");
INSERT INTO dig_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Wakati mmwenga uwe Farao uriphokala ukahureyera swiswi atumishio, mimi na mkpwulu wa apishi, wahufunga jela ambayo kala i tsini ya mkpwulu wa arindzi. ");
INSERT INTO dig_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Siku mwenga usiku, chila mmwenga wehu waloha ndosoye, na chila ndoso ichikala na manaye. ");
INSERT INTO dig_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Sambi, kala phana mvulana wa Chieburania aihwaye Yusufu, mtumishi wa mkpwulu wa arindzi. Hwamsemurira ndoso zehu na achihuvugurira, chila mmwenga ndosoye. ");
INSERT INTO dig_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Mambo gachikala vivyo vyovugula ndoso zehu: Mino nchiuyizwa phangu kazini na myangu achiolagbwa.” ");
INSERT INTO dig_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Hipho, Farao walagiza hiye mvulana arehwe, na mara mwenga achirehwa kula jela. Bada ya kunyola na kuvwala nguwo zanjina, Yusufu wakpwedza mbere za Farao. ");
INSERT INTO dig_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Farao achimuamba Yusufu, “Nkaloha ndoso na taphana awezaye kuzivugula, ela nasikira uwe unaweza kuvugula ndoso.” ");
INSERT INTO dig_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yusufu achimuamba Farao, “Mimi sina uwezo hinyo, ela Mlungu andakupha mana gakufwahago.” ");
INSERT INTO dig_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Ndipho mfalume waandza kumsemurira Yusufu ndosoze, “Nkaloha che niimire kanda-kanda ya muho wa Naili, ");
INSERT INTO dig_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","na mo muhoni mkatuluka ngʼombe sabaa za kunona na zikaandza kurisa pho kanda-kanda ya muho. ");
INSERT INTO dig_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Halafu mkatuluka ngʼombe zanjina sabaa, mbii, za kuonda hata zinatisha, yani mifupha mihuphu. Sidzangbweona ngʼombe dza zizo kahi za tsi ya Misiri. ");
INSERT INTO dig_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Zira ngʼombe za kuonda zarya zira ngʼombe sabaa za kunona chizotuluka kpwandza. ");
INSERT INTO dig_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ela hata bada ya zira ngʼombe za kuonda kurya zira za kunona, zasala vivyo za kuonda. Mutu asingemanya kukala zikarya yawe. Halafu nchilamuka. ");
INSERT INTO dig_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Nágbwirwa ni usingizi tsona, nchiloha mʼbuwa mmwenga wa muhama ukavyala masuche sabaa manono garigo tele tembe. ");
INSERT INTO dig_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Chisha nchiona mʼbuwa wanjina ukavyala masuche sabaa madide chigonyala kpwa dzuwa na phuto. ");
INSERT INTO dig_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Gara ga kunyala gamiza gara manono. Ligundzure náasemurira aganga ndoso hizi ela, taphana ariyeweza kunivugurira.” ");
INSERT INTO dig_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Yusufu wamuambira mfalume, “Ndosozo zosi mbiri zina mana mwenga. Mlungu akakuonyesa mambo ambago a phephi na kugahenda. ");
INSERT INTO dig_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Zira ngʼombe sabaa za kunona ni miaka sabaa, na gara masuche sabaa manono ga muhama piya ni miaka sabaa; ndoso zosi zina mana mwenga. ");
INSERT INTO dig_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Zira ngʼombe sabaa za kuonda chizotuluka bada ya zira za kunona, na gara masuche sabaa ga kunyala, manaye ni miaka sabaa ya ndzala. ");
INSERT INTO dig_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Ni kama nchivyokuambira uwe Farao, kukala, Mlungu akakuonyesa mambo ambago a phephi na kugahenda. ");
INSERT INTO dig_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Kundakala na miaka sabaa ya mavuno manji sana kahi za tsi ya Misiri. ");
INSERT INTO dig_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Bada ya iyo, kundakala na miaka sabaa ya ndzala, ndzala kulu hata yo miaka ya shibe iyalwe ko tsi ya Misiri. Ndzala iyo indaiangamiza tsi. ");
INSERT INTO dig_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Yo shibe taandaitambukira mana yo ndzala ndiyokpwedza indakala kali sana. ");
INSERT INTO dig_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Sababu ya Farao kuloha ndoso mbiri zenye mana mwenga, ni kukala Mlungu akakata shauri na a phephi na kugahenda. ");
INSERT INTO dig_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Sambi, uwe Farao, ni utsambule mutu wa achili na marifwa, umuike muimirizi wa tsi ya Misiri ili akusanye chakurya cha akiba. ");
INSERT INTO dig_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Piya Farao ni uike atu anjina ili akusanye seemu mwenga ya tsano ya mavuno ga Misiri, wakati wa miaka sabaa ya shibe. ");
INSERT INTO dig_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Alagize akusanye chakurya chosi cha miaka ya shibe yedzayo na achiike akiba kahi za midzi tsini ya uimirizio uwe Farao. ");
INSERT INTO dig_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Chakurya hichi chindakala akiba ya tsi wakati wa miaka sabaa ya ndzala ndiyokpwedza Misiri, ili atu asedze akagaya na ndzala.” ");
INSERT INTO dig_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Farao na atumishie osi aukubali mpango huno, ");
INSERT INTO dig_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","na Farao achiaambira, “Kpwa kpweli tahuweza kuphaha mutu wanjina dza Yusufu ambaye ana Roho wa Mlungu ndaniye.” ");
INSERT INTO dig_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Chisha Farao achimuambira Yusufu, “Kpwa vira Mlungu wakuonyesa uwe mambo gosi higa, takuna mutu wanjina wa achili na marifwa dza uwe. ");
INSERT INTO dig_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Kpwa hivyo, nindakuhenda mkpwulu wa tsi yangu, na atu angu osi andalunga malagizogo. Kpwa sababu ya ishima ya chihi cha utawala, mimi tu ndimi ndiyekala mkpwulu kuriko.” ");
INSERT INTO dig_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Farao achimuambira Yusufu, “Vivi nakuika mkpwulu wa tsi yosi ya Misiri.” ");
INSERT INTO dig_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Farao wavula peheye ya chifalume yenye muhuriwe na achimvwika Yusufu. Piya wamupha kandzu nono, na achimvwika mkpwufu wa zahabu. ");
INSERT INTO dig_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Achimupha garire ra phiri ra chifalume ra kuvwehwa ni farasi. Arindzi achimtanguliya kuno anagomba na raka ra dzulu, “Kalani kanda, kalani kanda.” Hivyo ndivyo Farao arivyomuhenda Yusufu mkpwulu wa Misiri yosi. ");
INSERT INTO dig_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Piya Farao wamuamba Yusufu, “Mimi mfalume wa Misiri natangaza kukala takuna mutu yeyesi ndiyegomba wala kuhenda rorosi bila ya ruhusayo.” ");
INSERT INTO dig_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Farao wamupha Yusufu dzina ranjina, Safenathi-Panea. Piya wamlóza mchetu, yeihwa Asenathi, mwana wa Potifera, mlavyadzi-sadaka wa Oni. Phahi, Yusufu wakala mkpwulu wa tsi yosi ya Misiri. ");
INSERT INTO dig_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yusufu kala ana miaka mirongo mihahu ariphoandza kumuhumikira Farao, mfalume wa Misiri. Yusufu wauka dzumba ra mfalume na achizunguluka tsi ndzima. ");
INSERT INTO dig_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Wakati hura wa miaka sabaa ya shibe, tsi yaphaha mavuno manji sana. ");
INSERT INTO dig_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yusufu wakusanya chakurya chosi choambwa wakati wa miaka sabaa ya shibe ko Misiri na achichiika akiba midzini. Chila mudzi waika akiba ya chakurya kula minda iriyokala phephi na mudzi hinyo. ");
INSERT INTO dig_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Waika akiba ya mavuno kpwa unji sana, gachikala manji dza mtsanga wa pwani; gakala manji hata achikala kaandika isabuye tsona, gakala zaidi ya chipimo. ");
INSERT INTO dig_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Kabila miaka ya ndzala kufika, Yusufu kala akavyala ana airi alume na mchewe Asenathi, mwana wa mlavyadzi-sadaka wa Oni. ");
INSERT INTO dig_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yusufu wamuiha mwanawe wa mwandzo Manase mana waamba, “Mlungu akanihenda niyale tabu zangu zosi na nyumba ya baba.” ");
INSERT INTO dig_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Mwanawe wa phiri wamuiha Efuraimu, achiamba, “Mlungu akanipha chivyazi tsi niriyogaya.” ");
INSERT INTO dig_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Yo miaka sabaa ya shibe hiko Misiri yatsapa, ");
INSERT INTO dig_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","halafu miaka sabaa ya ndzala ichiandza viratu vyogomba Yusufu. Tsi zanjina zosi kala zina ndzala ela Misiri yosi kala ina chakurya. ");
INSERT INTO dig_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Amisiri ariphoandza kuphaha tabu ya chakurya, amririra Farao aaphe chakurya. Na Farao achiaambira Amisiri osi, “Phiyani kpwa Yusufu na vyo ndivyokuambirani, hendani.” ");
INSERT INTO dig_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ndzala iriphozidi kuenea tsi ndzima, Yusufu wavugula madzumba goikpwa chakurya na achiaguzira Amisiri. ");
INSERT INTO dig_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Tsi zosi zakpwedza Misiri kugula chakurya kpwa Yusufu, sababu ndzala kala ni kali chila phatu. ");
INSERT INTO dig_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Jakobo phosikira kukala Misiri kuna chakurya, waambira anae alume, “Mbona mukadangana tu mnalolana matsoni? ");
INSERT INTO dig_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Nasikira Misiri kuna chakurya. Phiyani mkagule sedze hukahirikani na ndzala.” ");
INSERT INTO dig_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ndipho hinyo ndugu kumi a Yusufu aphiya Misiri kpwendagula chakurya. ");
INSERT INTO dig_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ela Jakobo kayaruhusu Benjamini, mwanáo ndani mwenga na Yusufu, aphiye na nduguze, mana kala anaogopha sedze akaphahwa ni mai. ");
INSERT INTO dig_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Phahi ana a Jakobo aphiya Misiri na atu anjina okala anaphiya kpwendagula chakurya, mana Kanani nako kala kuna ndzala. ");
INSERT INTO dig_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Wakati hinyo Yusufu kala ndiye mkpwulu wa Misiri na kala ndiye aguziraye atu osi chakurya. Phahi nduguze Yusufu ariphofika, amgbwerera maguluni. ");
INSERT INTO dig_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yusufu ariphoona nduguze, waatambukira ela achidzihenda avi kaamanya, achigomba nao na usiru. Achiauza, “Mlaphi mwino?” Nao achimuamba, “Hula Kanani hukedzagula chakurya.” ");
INSERT INTO dig_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Dzagbwe Yusufu waatambukira nduguze, ela aho taayamtambukira. ");
INSERT INTO dig_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Iye watambukira ndosoze zoloha kuhusu nduguze na achiaambira, “Mu makachero mwimwi! Mkedzachunguza tsi yehu ili mmanye unyonje wa tsi yehu!” ");
INSERT INTO dig_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Aho achiamba, “Hata bwana, swiswi atumishio hukedzagula chakurya. ");
INSERT INTO dig_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Swiswi hosi hu ana a baba mmwenga. Bwana, swiswi sio makachero, hu atu aaminifu.” ");
INSERT INTO dig_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Achiaambira, “Hata! Mwimwi mkedzalola tsi yehu ili mmanye unyonje wa tsi yehu.” ");
INSERT INTO dig_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Achimuamba, “Swiswi atumishio kala hu ndugu kumi na airi a baba mmwenga akalaye tsi ya Kanani. Mwenehu wehu mmwenga tahunaye na chiziyanda akasala kaya na baba.” ");
INSERT INTO dig_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Ela Yusufu achiaambira, “Kama nchivyokuambirani, mwimwi mu makachero! ");
INSERT INTO dig_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Na hivi ndivyo ambavyo mundahakikisha kukala simwi makachero: Ninaapa kpwa dzina ra mfalume, kukala tamundauka hadi mdide wenu arehwe hipha. ");
INSERT INTO dig_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Muhumeni mmwenga wenu akamuhale amrehe. Anjina mundatiywa jela hadi huhakikishe napho maneno genu ni ga kpweli. Na ichikala tamuna chiziyanda, phahi kama Farao arivyo moyo mwimwi mu makachero.” ");
INSERT INTO dig_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Phahi Yusufu waatiya jela osi kpwa siku tahu. ");
INSERT INTO dig_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Siku ya hahu, Yusufu waambira, “Mimi namuogopha Mlungu, na ichikala mundahenda dzambo ndirokuambirani sindakuolagani. ");
INSERT INTO dig_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Napho mu atu aaminifu, mmwenga naasale mu jela, na anjina aphirike chakurya kaya kpwa atu enu agayao na ndzala. ");
INSERT INTO dig_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Ela ni lazima munirehere chiziyanda wenu ili nihakikishe kukala mnagomba kpweli. Na ichikala ni kpweli sindakuolagani.” Nao akubali kuhenda vira arivyoambirwa. ");
INSERT INTO dig_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Chisha abisha nyo enye kpwa enye achiamba, “Kpweli hunatiywa adabu kpwa sababu ya hurivyomuhendera mwenehu wehu. Mana hwamuona vira arivyosononeka phohuvoya humrichire, ela tahuyamphundza; na ndiyo tabu hino huiphahayo.” ");
INSERT INTO dig_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Rubini achiamba, “Dze! Siyakuambirani msimuhendere dambi yuya mvulana? Ela tamuyaniphundza. Sambi hunariphizwa kpwa sababu ya chifoche.” ");
INSERT INTO dig_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Taamanyire kukala Yusufu anasikira gara agombago, mana kala achigomba naye na mtafusiri. ");
INSERT INTO dig_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Yusufu wauka achendarira, chisha achiuya kpwedzagomba nao tsona. Wamuhala Simioni na achifungbwa mikono mbere zao. ");
INSERT INTO dig_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yusufu walagiza magunia ga nduguze gaodzazwe chakurya, na chila mmwenga auyizirwe pesaze mwakpwe guniani na ahewe chakurya cha kurya njirani. Na gachihendwa. ");
INSERT INTO dig_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Nduguze apandiza mizigo yao ya mtsere pundani na achiuka. ");
INSERT INTO dig_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Ariphofika phatu phokala andalala usiku uho, mmwenga wavugula guniare ili amuphe pundawe chakurya, na achikuta pesaze mo mwakpwe guniani. ");
INSERT INTO dig_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Achiaambira nduguze, “Pesa zangu zikauyizwa, mu mwangu guniani!” Maroho gaaguguta na achiuzana kpwa wuoga, “Ni shaka rani rino Mlungu?” ");
INSERT INTO dig_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ariphofika kaya kpwa ise yao Jakobo, ko Kanani, amsemurira mambo gosi gohendeka. ");
INSERT INTO dig_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Amuambira, “Mkpwulu wa Misiri wahugombera kpwa usiru na achiuhenda avi hu makachero, hunachunguza unyonje wa tsi yao. ");
INSERT INTO dig_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ela swino huchimuambira, ‘Swiswi hu atu aaminifu, sio makachero. ");
INSERT INTO dig_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Kukala hu ndugu kumi na airi, ana a baba mmwenga. Mmwenga tahunaye na chiziyanda wehu wasala kaya na baba hiko Kanani.’ ");
INSERT INTO dig_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Halafu yuya mkpwulu wa Misiri achihuamba, ‘Hivi ndivyo ambavyo nindamanya kukala mu atu aaminifu. Mmwenga andasala phapha na anjina aphirike chakurya kaya kpwa atu enu agayao na ndzala. ");
INSERT INTO dig_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ela ni munirehere mwenenu wenu chiziyanda, ili nimanye kukala simwi makachero, bali mu atu aaminifu; ndipho nindakuuyizirani mwenenu wenu na mundakala huru tsi hino.’ ” ");
INSERT INTO dig_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ariphokala anakupula magunia gao, chila mmwenga wakuta mfukowe wa pesa mwakpwe guniani! Aho na ise yao ariphoona yo mifuko ya pesa agbwirwa ni uoga. ");
INSERT INTO dig_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ise yao Jakobo achiamba, “Mnalonda kunimarira anangu! Yusufu kapho, Simioni kapho; na sambi mnalonda muhale Benjamini. Chila chitu chinahendeka chinyume changu!” ");
INSERT INTO dig_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Rubini achimuamba ise, “Ichikala sindamuuyiza Benjamini, olaga anangu airi alume. Nipha Benjamini nami nindamrinda na nindamuuyiza.” ");
INSERT INTO dig_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ela Jakobo achiamba, “Sindalavya mwanangu mkaphiya naye; nduguye wafwa na wasala iye tu. Achiphahwa ni utu uyi mo njirani nindafwa na mkunguru mana mimi ndipho ni mtumia.” ");
INSERT INTO dig_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Ndzala yazidi kukala kali ko Kanani, ");
INSERT INTO dig_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","na atu a Jakobo ariphokala akamala mtsere uriogulwa Misiri, Jakobo waambira anae, “Uyani mkahugurire mtsere tsona.” ");
INSERT INTO dig_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ela Juda achimuamba ise, “Yuya mkpwulu wa Misiri wagomba wazi kabisa kukala kandabisha naswi tsona napho tahundaphiya na mdide wehu! ");
INSERT INTO dig_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Uchikubali huphiye na Benjamini, phahi hundaphiya hukakugurireni chakurya. ");
INSERT INTO dig_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ela uchirema na Benjamini, baba swino tahundaphiya, mana yuya mutu waamba, ‘Sindabisha namwi tsona hadi mwedze na mdide wenu!’ ” ");
INSERT INTO dig_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Jakobo achiamba, “Mwanitiya mashakani, kpwa utu wani mwanihendera uyi huno wa kumuambira hiye mutu kukala muna mwenenu wenu wanjina?” ");
INSERT INTO dig_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Nao achimuamba, “Yuya mutu wahuuza kuhusu swi enye na kuhusu abari ehu anjina pha kaya. Wahuuza achiamba, ‘Dze, sowe yenu ni mzima? Muna mwenenu wenu wanjina?’ Naswi kala hunamjibu go maswalige tu. Sambi kala hundamanyadze kukala andaamba, ‘Ndzoni na mwenenu wenu’?” ");
INSERT INTO dig_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Juda achimuambira ise, “Niricha niphiye naye hiyu mvulana ili huuke mara mwenga, hukagule chakurya husedze hukahirikani phamwenga na achetu ehu na ana ehu. ");
INSERT INTO dig_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Mimi mwenye nindakala mzamana. Undaniisa mimi baba. Ichikala sindakpwedza naye mzima, phahi lawama naikale dzulu yangu maisha. ");
INSERT INTO dig_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Kalapho wakubali hangu mwandzo, hungekala hwahenda vyaro viiri vya kuphiya na kuuya.” ");
INSERT INTO dig_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ndipho ise yao achiamba, “Ichikala ni lazima aphiye, phahi hendani hivi: Halani vitu vinono-vinono kula ku kpwehu, mumphirikire zawadi hiye mkpwulu. Halani dawa chache ya mavune, asali chache, vilungo vya kujitira, uvumba na mbeyu za mtswano, yani jozi na lozi. ");
INSERT INTO dig_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Halani pesa kano mbiri ya zira zitakpwazo, mana ni lazima muuyize zira pesa zouyizwa mwenu maguniani. Mendzerepho zauyizwa bahati mbaya. ");
INSERT INTO dig_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Mhaleni mwenenu wenu na mphiye mara mwenga. ");
INSERT INTO dig_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Mlungu Mwenye Nguvu Zosi naamuhende hiye akuonereni mbazi ili amrichire Benjamini na hiye mwenenu wenu wanjina muuye nao kaya. Ichikala naandikirwa anangu aangamike, haya, naangamike, taphana neno.” ");
INSERT INTO dig_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Phahi ahala zira zawadi, pesa za kano mbiri na Benjamini, na achiuka mara mwenga. Ariphofika Misiri, akpwendamuona Yusufu. ");
INSERT INTO dig_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yusufu ariphomuona Benjamini phamwenga nao, wamuambira mtumishiwe mkpwulu wa nyumbaye, “Aphirike kpwangu kaya hano ajeni na ukatsindze nyama umtengeze, mana nindarya nao mutsi.” ");
INSERT INTO dig_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Yuya mtumishi wahenda kama arivyolagizwa ni Yusufu, waaphirika kpwa Yusufu. ");
INSERT INTO dig_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Wakati ariphokala anaphirikpwa kpwa Yusufu agbwirwa ni wuoga na achiamba, “Hunaphirikpwa hiko kpwa sababu ya zira pesa zouyizwa mwehu maguniani kano ya mwandzo. Analonda kuhugbwira kpwa nguvu, ahuhende atumwa na ahufute punda ehu.” ");
INSERT INTO dig_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Ariphofika mryangoni nyumbani kpwa Yusufu, amuuza yuya mtumishi mkpwulu wa Yusufu, ");
INSERT INTO dig_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","achimuamba, “Bwana, swino hwakpwedza hipha kano ya kpwandza kpwedzagula chakurya. ");
INSERT INTO dig_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Ela huriphokala hunauya kaya, hwakpwendaima phatu ambapho kala hundalala usiku. Huriphovugula magunia gehu, chila mmwenga wakuta pesaze zosi mwakpwe guniani. Phahi, hizo pesa swino hukaziuyiza. ");
INSERT INTO dig_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Tahumanya yeuyiza pesa zira maguniani. Piya hukedza na pesa zanjina ili hugule chakurya zaidi.” ");
INSERT INTO dig_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Yuya bwana achiamba, “Ni sawa-sawa mchivyoniambira, msiogophe wala msikale na wasiwasi. Mlungu wenu ndiye yekutiirani pesa mwenu maguniani. Mimi ndimi yephokera pesa zenu.” Chisha achiatuluzira mwanáo wao Simioni. ");
INSERT INTO dig_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Yuya mtumishi achiakaribisha nyumbani mwa Yusufu, achiapha madzi ga kusinga magulu, na achiapha punda aho chakurya. ");
INSERT INTO dig_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Hara nduguze Yusufu a tayarisha zawadi zao ili amuphe Yusufu pho mutsi ndiphokpwedza, mana kala akasikira kukala andarya phamwenga naye. ");
INSERT INTO dig_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yusufu ariphokpwedza phara kaya, nduguze amupha zira zawadi zokpwedza nazo, na achimgbwerera maguluni. ");
INSERT INTO dig_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Yusufu waauza hali zao, halafu achiaamba, “Ye sowe yenu mtumia mriyeniamba, a viphi? Achere moyo?” ");
INSERT INTO dig_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Nduguze achimuamba, “Mtumishio, baba yehu achere moyo na kana neno.” Chisha achizamisa vitswa vyao kuonyesa ishima. ");
INSERT INTO dig_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Yusufu ariphomuona Benjamini, mwanao ndani mwenga, waamba, “Yuno ndiye mwenenu wenu chiziyanda mriyeniambira?” Chisha achimuamba Benjamini, “Mlungu naakuonere mbazi, mwanangu!” ");
INSERT INTO dig_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Halafu Yusufu wauka gafula, mana matsozi kala ganamrengarenga kpwa sababu ya kumuona nduguye. Achiinjira mwakpwe chumbani na achirira. ");
INSERT INTO dig_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Bada ya kusinga uso watuluka kondze, achidzidinisa chilume na achiamba, “Reheni chakurya.” ");
INSERT INTO dig_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Yusufu warya macheye na nduguze nao achirya machiyao. Amisiri okala hipho nao achirya machiyao, mana aho kurya na Aeburania kala ni utu wa kutsukiza. ");
INSERT INTO dig_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Aho asagala mezani kulolana na Yusufu, na apangbwa kulengana na miaka yao, kula mvyere hadi mdide; hino yaahenda alolane kpwa kuangalala. ");
INSERT INTO dig_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Chakurya kala chichihalwa mezani pha Yusufu na akahewa. Benjamini wahewa chakurya kano tsano ya chira cha ayae. Anwa, achirya vyakurya vinono-vinono na achifwahirwa phamwenga na Yusufu. ");
INSERT INTO dig_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Yusufu wamlagiza mtumishiwe mkpwulu wa phakpwe kaya, achimuamba, “Aodzazire chakurya mwao maguniani chiasi awezacho kutsukula. Na chila mmwenga mtiire pesaze mwakpwe guniani. ");
INSERT INTO dig_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Halafu tiya chikombe changu cha feza ndani ya gunia ra yuya mwanao wao chiziyanda, phamwenga na pesaze achizogurira chakurya.” Yuya mtumishi wahenda viratu vyolagizwa ni Yusufu. ");
INSERT INTO dig_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Ligundzu kuriphocha hara atu asindikizwa na punda aho achiphiya vyao. ");
INSERT INTO dig_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ariphokala akauka hatuwa chache kondze ya mudzi, Yusufu wamuambira mtumishiwe mkpwulu wa nyumbani, “Henda wangbwi ualunge hara atu na ndiphoaona auze, ‘Mbona mkariphiza mai kpwa manono? ");
INSERT INTO dig_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Kpwadze mkaiya chikombe cha feza cha tajiri wangu? Ndicho anwereracho na ndicho apigiracho mburuga. Mkahenda utu uyi kuiya chikombeche.’ ” ");
INSERT INTO dig_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Yuya mtumishi wauka; ariphoagbwira hiko njirani, waauza maneno garatu gara. ");
INSERT INTO dig_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Nao achimuamba, “Bwana, ni maneno gani go uhuambirago? Swiswi tahuweza kuhenda neno hiro hata chidide! ");
INSERT INTO dig_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Bwana, unatambukira kukala swino hwauyiza pesa kula Kanani ambazo kala zikatiywa mwehu maguniani! Dze, hungeiyadze zahabu ama feza nyumbani mwa tajirio? ");
INSERT INTO dig_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Bwana, ye ndiyephahikana na hicho chikombe naaolagbwe, na siswi anjina uhende atumwao.” ");
INSERT INTO dig_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Yuya mtumishi achiamba, “Nakubali muchivyoamba, ela ye ndiyephahikana na chikombe ndiye ndiyekala mtumwa wangu, mwi anjina mundakala tamuna makosa.” ");
INSERT INTO dig_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Hipho, ahula magunia gao upesi na chila mmwenga achivugula guniare. ");
INSERT INTO dig_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Yuya mtumishi wa Yusufu waendza chila gunia kuandzira ra mvyere hadi mdide kabisa. Chikombe chazembuka guniani mwa Benjamini. ");
INSERT INTO dig_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Nduguze akpwanyula nguwo zao kpwa sonono, na chila mmwenga achipandiza mizigoye pundani na achiuya. ");
INSERT INTO dig_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yusufu kala achere pho kaya wakati Juda na nduguze ariphouya. Achidzibwaga photsi mbere za Yusufu. ");
INSERT INTO dig_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yusufu achiamba, “Mkahendani mwino? Tammanya kukala mutu kama mimi naweza kumanya mambo na mburuga?” ");
INSERT INTO dig_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Juda achiamba, “Hukuambireni, bwana? Huambedze? Hudziusiredze lawama? Mlungu akagaonyesa makosa gehu. Sambi, swiswi hosi hu atumwao, wala si yuya chiyegbwirwa na chikombe bahi.” ");
INSERT INTO dig_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Yusufu achiamba, “Aa, mino siweza kuhenda hivyo kabisa! Ni yuyatu achiyegbwirwa na chikombe changu tu, ndiye ndiyekala mtumwa wangu. Mwimwi anjina, phiyani kaya kpwa sowe yenu salama.” ");
INSERT INTO dig_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Phahi, Juda wamsengerera Yusufu na achimuamba, “Tafadhali bwana, nakuvoya nigombe maneno machache, dzagbwe u sawa na mfalume ela nakuvoya usireye. ");
INSERT INTO dig_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Bwana uwe wahuuza, ‘Dze, sowe yenu achere moyo? Muna mwenenu wenu wanjina?’ ");
INSERT INTO dig_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Naswi huchikuamba, ‘Huna baba, naye ni mtumia, na huna mdide wehu, ambaye wavyalwa wakati baba ni mtumia kare. Ndugungbwa wa hiye mvulana ndani mwenga wafwa na sere iye tu kpwa nine. Baba anammendza sana mwanache hiyu.’ ");
INSERT INTO dig_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Bwana, halafu wahuamba, ‘Mreheni mdide wenu ili nimuone.’ ");
INSERT INTO dig_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Naswi huchikuambira uwe bwana wangu, ‘Hiye mwanache kaweza kumricha ise, mana achihenda hivyo, ise andafwa.’ ");
INSERT INTO dig_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ela bwana uchiamba, ‘Sindabisha na mwimwi tsona hadi mwedze na mdide wenu.’ ");
INSERT INTO dig_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","“Huriphouya kaya kpwa baba, hwakpwendamuambira gara uchigohuambira uwe bwana wangu. ");
INSERT INTO dig_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Baba ariphohuamba, ‘Uyani Misiri mkahugurire chakurya chanjina.’ ");
INSERT INTO dig_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Swino hwamuamba, ‘Tahuweza kuphiya, mana tahundaruhusiwa kumuona hiye mutu hadi mdide wehu akalepho. Hundaphiya ichikala mdide wehu andaphiya piya.’ ");
INSERT INTO dig_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Bwana, baba wahuamba, ‘Mnamanya kukala mayo yenu Raheli navyala naye ana airi. ");
INSERT INTO dig_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Mmwenga waniricha na ni lazima akale wagbwirwa ni nyama mʼbaya achiriwa. Na sidzangbwemuona hangu siku hizo. ");
INSERT INTO dig_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ichikala mundamuhala hiyu piya na akaphahwe ni mai, hivi nirivyo mtumia mundaniolaga na mkunguru.’ ");
INSERT INTO dig_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Kpwa hivyo bwana, ichikala nindauya kaya kpwa baba bila ya hiyu mwanache, baba ndiphoona mwanawe kapho, andafwa. Mana uzima wa baba unategemea uzima wa mwanache hiyu. Ichikala hivyo, hundamuolaga mtumia na mkunguru. ");
INSERT INTO dig_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Tsona bwana, nádzilavya mzamana wa hiyu mwanache kpwa baba, námuamba, ‘Ichikala sindauya naye mzima, phahi baba, lawama naikale dzulu yangu maisha gangu gosi.’ ");
INSERT INTO dig_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Sambi phahi, nakuvoya badalaye nisale mimi kama mtumwao, yuno mwanache umrichire aphiye kaya na hano ayae. ");
INSERT INTO dig_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Nindamloladze baba mino bila mwanache hiyu? Sindaweza kuvumirira mai ndigomphaha baba.” ");
INSERT INTO dig_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Kufikira hipho, Yusufu kayaweza kudzizuwiya tsona mbere za atumishie, phahi wakota kululu achiamba, “Tulukani himu chumbani.” Taphayakala na mutu wanjina yeyesi Yusufu ariphokala anadzimanyisa kpwa nduguze. ");
INSERT INTO dig_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Warira kpwa sauti hadi Amisiri achisikira. Badaye habari zafika kpwa mfalume. ");
INSERT INTO dig_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yusufu achiaambira nduguze, “Enehu, mimi ni Yusufu! Dze, baba achere moyo?” Ela nduguze ariphosikira, aogopha hata achikala taana ra kugomba. ");
INSERT INTO dig_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Yusufu achiaambira nduguze, “Tafadhalini sengerani phephi.” Nao ariphosengera waambira, “Mimi ndiye yuya mwenenu wenu mriyemguza Misiri! ");
INSERT INTO dig_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Sambi msihende wasiwasi wala msidzilaumu kpwa sababu ya kuniguza hiku, mana ni Mlungu yenitanguliza hiku ili nitivye maisha ga atu. ");
INSERT INTO dig_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Huno ni mwaka wa phiri wa ndzala himu, na ko mbere kuchere na miaka mitsano ambapho takundakala na kurima wala kuvuna. ");
INSERT INTO dig_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Ela Mlungu wanitanguliza mbere zenu kukutivyani kpwa njira hino ya ajabu, na vivyazi vyenu vienderere kuishi himu duniani. ");
INSERT INTO dig_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Kpwa hivyo, sio mwimwi murionireha hiku, bali ni Mlungu. Naye wanihenda dzumbe kpwa mfalume, muimirizi wa phakpwe kaya na mkpwulu wa tsi yosi ya Misiri. ");
INSERT INTO dig_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Sambi, hendani wangbwi mphiye kpwa baba mkamuambe, ‘Mwanao Yusufu anakuamba: Mlungu wanihenda mkpwulu wa tsi yosi ya Misiri. Phahi, ndzo upesi, usikae. ");
INSERT INTO dig_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Undasagala seemu za Gosheni, ambapho undakala phephi nami, uwe, anao, adzukuluo, mifugoyo na malizo zosi urizo nazo. ");
INSERT INTO dig_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Uchikala Gosheni, nindakurisa, mana kusere miaka mitsano ya ndzala. Uwe na atuo, phamwenga na mifugoyo sedze mkagaya.’ ” ");
INSERT INTO dig_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Yusufu waenderera kuaambira nduguze, “Mwimwi enye na hata mwenehu Benjamini mkaniona na matso genu kukala mimi nchiyebisha namwi ni Yusufu. ");
INSERT INTO dig_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Msemurireni baba nrivyo mkpwulu na niogophewavyo hiku Misiri, na muambireni kuhusu chila chitu mchichochiona. Phahi hendani wangbwi mkamrehe baba.” ");
INSERT INTO dig_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Yusufu wamtiya nduguye Benjamini chifuwani na achirira, Benjamini naye warira chifuwani mwa mwanáo. ");
INSERT INTO dig_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Chisha waatiya nduguze osi chifuwani, achiadonera kuno anarira. Bada ya higo nduguze abisha naye. ");
INSERT INTO dig_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Mfalume ariphoambirwa kukala ndugungbwa a Yusufu akedza, iye na atumishie osi aonato. ");
INSERT INTO dig_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Mfalume wamuambira Yusufu, “Aambire enenu, ‘Pandizani mizigo yenu pundani na mphiye kaya tsi ya Kanani. ");
INSERT INTO dig_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Mkamuhale baba na atu enu. Nami nindakuphani seemu nono kabisa ya tsi ya Misiri na mundafwaidi vya kunona kahi ya yo tsi.’ ");
INSERT INTO dig_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Tsona aambire, ‘Halani magari ga kuvwehwa ni farasi kula ku Misiri mkatsukurire anache na achetu enu na msikose kumreha sowe yenu. ");
INSERT INTO dig_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Msione tabu kuricha mali zenu, mana mundaphaha vinono kabisa vya hiku Misiri.’ ” ");
INSERT INTO dig_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Phahi Yusufu walavya magari ga kuvwehwa ni farasi kama mfalume arivyolagiza, na achiapha chakurya cha kurya njirani. Ana a Iziraeli (yani ana a Jakobo) adzifunganya na achihenda kama arivyolagizwa. ");
INSERT INTO dig_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Piya Yusufu wamupha chila mmwenga nguwo nyiphya, ela Benjamini achimupha nguwo tsano na vipande magana mahahu vya feza. ");
INSERT INTO dig_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Achimphirikira ise punda kumi alume ariotsukula vitu vinono-vinono kula Misiri na punda kumi achetu ariotsukula mtsere, mabofulo na vitu vyanjina ambavyo ise andahumira njirani. ");
INSERT INTO dig_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Chisha Yusufu waasindikiza nduguze, na wakati analagana nao, waambira, “Msihehe mo njirani.” ");
INSERT INTO dig_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Aho auka Misiri na achiuya Kanani kpwa ise yao Jakobo. ");
INSERT INTO dig_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ariphofika amuambira ise yao, “Baba, Yusufu achere moyo! Iye ndiye mkpwulu wa Misiri yosi!” Phahi ise yao waangalala, na achikala kaamini maneno higo. ");
INSERT INTO dig_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ela ariphomueleza gosi goambirwa ni Yusufu, na ariphoona magari ga kuvwehwa ni farasi achigoreherwa ni Yusufu gamhale, roho ra ise yao Jakobo radigirika. ");
INSERT INTO dig_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Achiamba, “Kpwa kpweli mwanangu Yusufu achere moyo! Nindaphiya nikamuone kabila sidzangbwefwa.” ");
INSERT INTO dig_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Phahi, Jakobo wahala malize zosi na achiuka achiphiya Misiri. Ariphofika Beeri-Sheba wamlavira sadaka Mlungu wa ise Isaka. ");
INSERT INTO dig_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Mlungu wagomba na Jakobo usiku ruwiyani, wamuiha, “Jakobo! Jakobo!” Naye achiihika, “Hee!” ");
INSERT INTO dig_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Achimuamba, “Mimi ndimi Mlungu, Mlungu wa sowe. Usiogophe kuphiya Misiri, mana hiko nindahenda uvyazio ukale taifa kulu. ");
INSERT INTO dig_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Piya mimi nindaphiya Misiri phamwenga na uwe na hakika nindaviuyiza vivyazivyo hiku Kanani. Wakati wa chifocho, Yusufu andakala kanda-kanda ya chitandacho.” ");
INSERT INTO dig_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Chisha Jakobo wauka Beeri-Sheba. Anae amuhala iye, adzukulue na akaza anae, achiapandiza magarini, magari golaviwa ni mfalume gamtsukule. ");
INSERT INTO dig_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Phahi Jakobo na uvyaziwe wosi aphiya Misiri na mifugo yao na mali zao zosi arizozitsuma tsi ya Kanani. ");
INSERT INTO dig_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Jakobo waphiya Misiri na anae alume na achetu na adzukulue alume na achetu, yani uvyaziwe wosi. ");
INSERT INTO dig_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Higa ni madzina ga anangbwa a Iziraeli yani uvyazi wa Jakobo ariophiya nao Misiri: Rubini mwana mvyere wa Jakobo. ");
INSERT INTO dig_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ana alume a Rubini kala ni Hanoki, Palu, Hezironi na Karimi. ");
INSERT INTO dig_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Ana alume a Simioni kala ni Jemueli, Jamini, Ohadi, Jakini, Sohari, na Shauli (yemvyala na mchewe wa Chikanani). ");
INSERT INTO dig_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Ana alume a Lawi kala ni Gerishoni, Kohathi na Merari. ");
INSERT INTO dig_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Juda na anae alume yani ano Eri, Onani, Shela, Peresi na Zera. (Ela Eri na Onani afwa Kanani.) Ana alume a Peresi kala ni Hezironi na Hamuli. ");
INSERT INTO dig_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isakari na anae alume, yani Tola, Puwa, Jashubu na Shimuroni. ");
INSERT INTO dig_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zabuloni na anae alume, ano Seredi, Eloni na Jaleeli. ");
INSERT INTO dig_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Hinyu kala ni uvyazi wa Jakobo ariouvyala na mchewe Lea hiko Padani-Aramu, mbali na mwana wao mchetu yeihwa Dina. Jumula yao kala ni mirongo mihahu na ahahu. ");
INSERT INTO dig_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gadi na anae alume, yani Sefoni, Hagi, Shuni, Esiboni, Eri, Arodi na Areli. ");
INSERT INTO dig_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asheri na anae alume yani Imuna, Ishiva, Ishivi, Beriya. Ndugu yao mchetu kala ni Sera. Ana alume a Beriya kala ni Heberi na Malikieli. ");
INSERT INTO dig_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Hinya atu kumi na sita ni ana a Jakobo na Zilipa, mtumwa ambaye Labani kala akamupha mwanawe Lea. ");
INSERT INTO dig_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Ana a Jakobo ario wavyala na mchewe Raheli kala ni Yusufu na Benjamini. ");
INSERT INTO dig_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Hiko Misiri Yusufu kala akavyala na Asenathi ana airi alume, yani Manase na Efuraimu. Asenathi kala ni mwana wa Potifera, mkpwulu wa dini kula mudzi wa Oni. ");
INSERT INTO dig_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Ana alume a Benjamini kala ni Bela, Bekeri, Ashibeli, Gera, Naamani, Ehi, Roshi, Mupimu, Hupimu na Aridi. ");
INSERT INTO dig_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Hinya atu kumi na a ne kala ni uvyazi wa Jakobo ariouvyala na Raheli. ");
INSERT INTO dig_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dani na mwanawe mlume Hushimu. ");
INSERT INTO dig_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Nafutali na anae alume ano Jahiseeli, Guni, Jeseri na Shilemu. ");
INSERT INTO dig_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Hinya atu sabaa kala ni uvyazi wa Jakobo ariouvyala na Biliha, mtumwa ambaye Labani kala akamupha mwanawe Raheli. ");
INSERT INTO dig_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Isabu ya uvyazi wa Jakobo uriophiya Misiri, bila ya kuolanga akaza anae, kala ni atu mirongo sita na sita. ");
INSERT INTO dig_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Phamwenga na ana airi a Yusufu ariovyalwa Misiri, atu a chivyazi cha Jakobo ariophiya Misiri kala ni mirongo sabaa. ");
INSERT INTO dig_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Jakobo wamtanguliza Juda kpwa Yusufu ili akamuonyese njira ya kuphiya Gosheni. Jakobo na anae ariphofika Gosheni, ");
INSERT INTO dig_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yusufu wapanda garire ra kuvwehwa ni farasi achiphiya Gosheni kpwendamchinjira ise, Iziraeli. Yusufu ariphomuona ise wadzitsupha chifuwani mwa ise na achirira kpwa muda mure. ");
INSERT INTO dig_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Iziraeli achimuambira Yusufu, “Hata nkafwa dza sambi, ni razi, mana nkakuona na nkamanya kukala uchere moyo.” ");
INSERT INTO dig_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Ndipho Yusufu achimuambira ise na nduguze, “Naphiya nkamuambire mfalume, ‘Baba na enehu okala asagala tsi ya Kanani, akedza. ");
INSERT INTO dig_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Aho ni afugi, anafuga mangʼondzi, ngʼombe na mbuzi, na akedza na mifugo yao na mali zao zosi.’ ");
INSERT INTO dig_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Mfalume achikuihani ili akuuzeni, ‘Muhenda kazi yani?’ ");
INSERT INTO dig_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Muambeni, ‘Bwana, swino hu afugi a mangʼondzi hangu jadi, dza arivyokala akare ehu,’ ili mfalume akukubalini kusagala Gosheni mana afugi a mangʼondzi ni tsukizo kpwa Amisiri.” ");
INSERT INTO dig_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Phahi Yusufu wahala nduguze atsano na achiphiya kpwa Farao, achendamuamba, “Baba na enehu akedza kula Kanani na mifugo yao na chila chitu aricho nacho, na vivi a Gosheni.” ");
INSERT INTO dig_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Chisha achimuonyesa mfalume hara nduguze. ");
INSERT INTO dig_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Mfalume achiauza, “Muhenda kazi yani?” Nao achimuamba, “Bwana, swino hu afugi a mangʼondzi hangu wanache wehu kama vyokala akare ehu.” ");
INSERT INTO dig_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Chisha achimuamba Farao, “Hukedzasagala hiku kpwa muda, mana hiko Kanani ndzala ni kali, hata mifugo taina mwatu mwa kurisa. Tafadhali hunakuvoya uhukubali swiswi atumishio husagale Gosheni.” ");
INSERT INTO dig_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Mfalume achimuambira Yusufu, “Sowe na enenu akakulunga uwe, ");
INSERT INTO dig_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","na tsi ya Misiri ni yako; muphe sowe na enenu phatu phanono kabisa. Ariche asagale hiko seemu za Gosheni. Na ichikala nduguzo anjina ni afugi enye ujuzi mkpwulu zaidi, naaimirire mifugo yangu.” ");
INSERT INTO dig_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Halafu Yusufu wamreha ise Jakobo kpwa mfalume ili amanyane, naye Jakobo achimʼbariki mfalume. ");
INSERT INTO dig_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Farao achimuuza Jakobo, “Una miaka mingaphi?” ");
INSERT INTO dig_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jakobo achimuambira mfalume, “Miaka ya charo changu himu duniani ni gana mwenga na mirongo mihahu. Miaka hino ni michache na taidzangbwefika miaka yoishi akare angu, tsona yakala ya kugaya.” ");
INSERT INTO dig_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Halafu Jakobo wamʼbariki mfalume na achiuka. ");
INSERT INTO dig_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Phahi Yusufu wamupha ise na nduguze phatu phanono kabisa Misiri, seemu za Ramesesi, kama vyolagiza mfalume. ");
INSERT INTO dig_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Piya Yusufu kala achimupha ise chakurya, phamwenga na nduguze na atu osi pho kaya kulengana na ana ario nao. ");
INSERT INTO dig_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Ndzala yazidi kukala kali sana hata kuchikala takuna chakurya chila phatu. Amisiri na Akanani achikala anagaya. ");
INSERT INTO dig_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yusufu kala akaphokera pesa zosi ambazo atu a Misiri na Kanani kala akagurira chakurya na achiziphirika dzumba ra mfalume. ");
INSERT INTO dig_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Atu aho ariphomala pesa zao, Amisiri osi aphiya kpwa Yusufu achendamuamba, “Huphe chakurya! Usihuriche hukahirika. Lola, pesa zehu zosi zasira!” ");
INSERT INTO dig_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yusufu achiaambira, “Ichikala pesa zenu zikasira, phahi, niphani mifugo yenu, hukakanizaneni chakurya kpwa mifugo.” ");
INSERT INTO dig_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ndipho achimrehera Yusufu mifugo yao na Yusufu achiapha chakurya. Aho areha farasi, punda, ngʼombe, mangʼondzi na mbuzi. Mwaka hinyo Yusufu waapha chakurya kpwa kukakanizana na mifugo yao yosi. ");
INSERT INTO dig_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Mwaka uriphosira, amuuyira Yusufu achendamuamba, “Bwana, pore ela ni lazima hukuambire shida yehu. Pesa zehu zosi zasira na mifugo yehu yosi ni maliyo. Sambi tahukasala na chochosi huwezacho kukupha isiphokala swiswi enye na minda yehu. ");
INSERT INTO dig_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Usihuriche hukahirika na minda yehu ikabanangika. Hugule phamwenga na minda yehu, bora tu huphahe chakurya; hukale atumwa a mfalume na minda yehu ikale maliye. Huphe mtsere ili huenderere kukala moyo sedze hukafwa, tsi ikakala wekee bila atu.” ");
INSERT INTO dig_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Ndipho Yusufu achigula minda yosi ya Amisiri, na ichikala mali ya mfalume. Chila Mmisiri waguza mundawe kpwa sababu ndzala kala ni kali sana. Minda yosi yakala mali ya mfalume ");
INSERT INTO dig_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","na Amisiri osi achikala atumwa, kula pembe hadi pembe. ");
INSERT INTO dig_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ela Yusufu kayagula minda ya alavyadzi-sadaka, mana taayakala na lazima ya kuguza minda yao kpwa sababu mfalume kala achiapha posho. ");
INSERT INTO dig_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Chisha Yusufu achiaambira atu, “Sambi phundzani, nkakugulani na minda yenu na mosi mu mali ya mfalume. Vivi nakuphani mbeyu mkaphande mwenu mindani. ");
INSERT INTO dig_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Ela siku muchivuna, seemu mwenga ya tsano ya mavuno genu mundamupha mfalume. Seemu ndiyosala indakala ya mbeyu na ya chakurya chenu na ana enu.” ");
INSERT INTO dig_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Nao achimuambira Yusufu, “Wativya maisha gehu, bwana. Ni sawa kukala atumwa a mfalume.” ");
INSERT INTO dig_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Phahi Yusufu waika shariya Misiri, kukala chila Mmisiri lazima alavye seemu mwenga ya tsano ya mavunoge kpwa mfalume. Shariya hino inahumika hadi rero. Minda ya alavyadzi-sadaka tu ndiyo ambayo taiyagulwa ni mfalume. ");
INSERT INTO dig_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Phahi, ana a Iziraeli asagala Misiri seemu za Gosheni, ambako atsuma mali, achivyalana na achienjerezeka sana. ");
INSERT INTO dig_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jakobo wasagala Misiri miaka kumi na sabaa, kpwa hivyo achikala akafika miaka gana mwenga na mirongo mine na sabaa. ");
INSERT INTO dig_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Ariphokala a phephi na kufwa, wamuiha mwanawe Yusufu, achimuamba, “Sambi uchikala unanimendza kpweli, tiya mkpwonoo phangu magoni na uape kukala undaishimu na kuhenda nilondago. Usinizike hiku Misiri, ");
INSERT INTO dig_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","ela siku nchifwa, nitsukulani kula Misiri, mkanizike kpwehu vikurani.” Yusufu achiamba, “Nindahenda kama uchivyoniamba, baba.” ");
INSERT INTO dig_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Ise achiamba, “Apa,” naye Yusufu achimuapira. Chisha ise achiuyiza chitswache chitandani. ");
INSERT INTO dig_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Badaye Yusufu waambwa, “Sowe analumwa.” Phahi wahala anae, Manase na Efuraimu, achiphiya nao kpwendamlola ise. ");
INSERT INTO dig_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Jakobo ariphoambirwa kukala mwanawe Yusufu akedzamlamusa, wadzilazimisha kungʼoka phara chitandani na achisagala. ");
INSERT INTO dig_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Chisha Jakobo achimuamba Yusufu, “Mlungu Mwenye Nguvu Zosi wanitsembukira Luzu, tsi ya Kanani na achinibariki. ");
INSERT INTO dig_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Waniamba, ‘Atu a chivyazicho andakala anji, uwe undakala mkare wa makabila. Na atu a chivyazicho nindaapha tsi hino ikale yao hata kare na kare.’ ");
INSERT INTO dig_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Anao airi ambao waavyala hipha Misiri kabila sidzangbwekpwedza, ni anangu. Efuraimu na Manase andakala anangu dza viratu Rubini na Simioni. ");
INSERT INTO dig_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Badaye uchiphaha ana anjina andakala ako, na urisi wao undala kpwako. ");
INSERT INTO dig_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Niriphokala nauya kula Padani, mayoo wanifwerera njirani, tsi ya Kanani, phephi na Efuratha. Námzika kanda-kanda ya njira iphiyayo mudzi wa Efuratha yani Bethilehemu.” ");
INSERT INTO dig_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Jakobo ariphoona ana a Yusufu wauza, “Ni ano ani hano?” ");
INSERT INTO dig_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yusufu achimuamba, “Ni anangu ambao Mlungu wanipha kuku hiku.” Jakobo achiamba, “Arehe hipha ili niabariki.” ");
INSERT INTO dig_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Matso ga Jakobo kala tagaonato kpwa sababu ya utumia. Phahi Yusufu waahala hara anache achimsengezera ise. Ise achiatiya chifuwani na achiadonera. ");
INSERT INTO dig_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Jakobo achimuambira Yusufu, “Kala naona sindakuona tsona mwanangu, ela mbavi Mlungu andanijaliya nione hata anao.” ");
INSERT INTO dig_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Halafu Yusufu waausa magoni pha ise na achimgbwerera ise maguluni. ");
INSERT INTO dig_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Wahala anae osi airi achimsengezera ise Iziraeli. Wamgbwira Efuraimu na mkpwonowe wa kulume, Manase na mkpwono wa kumotso. Efuraimu achimuika mkpwono wa kumotso wa ise na Manase mkpwono wa kulume. ");
INSERT INTO dig_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ela Iziraeli watikanyiza mikonoye, mkpwonowe wa kulume achiubandika chitswani pha Efuraimu dzagbwe kala ndiye mdide na mkpwonowe wa kumotso achiubandika chitswani pha Manase ambaye kala ndiye mvyere. ");
INSERT INTO dig_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Achimʼbariki Yusufu, achiamba, “Mlungu wa tsawe Burahimu na baba Isaka, naabariki avulana hano. Mlungu yekala mrindzi wangu hadi rero, ");
INSERT INTO dig_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","na ye Malaika yenitivya na mai gosi, naabariki ana hano. Maisha gao nagahende dzina rangu na madzina ga akare angu, Burahimu na Isaka gatambukirwe. Navoya aenjerezeke sana himu duniani.” ");
INSERT INTO dig_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yusufu ariphoona ise akaika mkpwonowe wa kulume chitswani pha Efuraimu, kayahamirwa. Kpwa hivyo wagbwira ise mkpwono ili awuuse chitswani pha Efuraimu auike pha Manase. ");
INSERT INTO dig_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Yusufu achimuambira ise, “Sivyo baba, hiyu hipha ndiye mvyere. Tafadhali baba, ika mkpwonoo wa kulume phakpwe chitswani.” ");
INSERT INTO dig_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ela ise achirema achiamba, “Ninamanya mwanangu, ninamanya. Iye piya uvyaziwe undakala atu anji na a kumanyikana. Ela mdidewe andakala mkpwulu kuriko iye na vivyazivye vindakala atu anji sana.” ");
INSERT INTO dig_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Kpwa hivyo achienderera kuabariki achiamba, “Aiziraeli andahumira madzina genu achitaka kubariki mutu, aho andaamba, ‘Mlungu naakuhende dza Efuraimu na Manase.’ ” Hivyo ndivyo Jakobo arivyoabariki siku iyo. Hivyo ndivyo Jakobo arivyomupha Efuraimu uvyere badala ya Manase. ");
INSERT INTO dig_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Chisha Iziraeli achimuambira Yusufu, “Lola, siku zangu za kufwa zi phephi, ela Mlungu andakala phamwenga namwi na kukuuyizani tsi ya akare ehu. ");
INSERT INTO dig_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Nami nakupha uwe wala sio nduguzo seemu ya Shekemu, ambayo náifuta Aamori na upanga na uha.” ");
INSERT INTO dig_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Bada ya higo Jakobo waiha anae aaphe wasiya; ariphokpwedza waambira, “Anangu mosi ndzoni phano ili nikuambireni mambo ndigokuphahani siku zedzazo. ");
INSERT INTO dig_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Ndzoni phamwenga mnisikize mwi ana a Jakobo, niphundzani vinono mimi sowe yenu. ");
INSERT INTO dig_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Rubini, u mwanangu wa mwandzo, u nguvu yangu na u mwanangu wa mwandzo wa uvulanani. Unaishimika sana na una uwezo mkpwulu. ");
INSERT INTO dig_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","U dza maimbi, kuzuwiyika, vivi kundaishimika kuriko osi tsona, mana walala chitanda cha sowe, uchichitiya najisi kpwa kulala na mkpwaza sowe. ");
INSERT INTO dig_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simioni na Lawi, renu ni mwenga, munahumira silaha zenu kuhenda mai. ");
INSERT INTO dig_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Mimi sindakala phamwenga na njama zenu, wala kudziunga mwenu mikutanoni. Mana mwaolaga atu kpwa tsukizi zenu, na mvumbo zenu ni kukata ngʼombe magulu. ");
INSERT INTO dig_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Tsukizi zenu nazilaniwe mana zikahenda na muno, usiru wenu naulaniwe mana ni ukatili. Nindatsamula atu a vivyazi vyenu kosi Iziraeli, niaganye kahi ya mbari zanjina za Jakobo. ");
INSERT INTO dig_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Juda, nduguzo andakulika, uwe undashinda avihao. Nduguzo andakugbwerera maguluni kukuishimu. ");
INSERT INTO dig_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Juda, u dza simba makamo ambaye achimala kurya nyamawe, nikuuya phakpwe alalapho. Ukudziambalaza photsi dza simba. U dza simba marara, takuna awezaye kukuondosa. ");
INSERT INTO dig_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Chila wakati mfalume andala chivyazi cha Juda hadi ye mtawala mwenye ndiphokpwedza ambaye makabila gosi gandamuogopha. ");
INSERT INTO dig_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Uwe undafunga pundao mzabibuni na mwana pundao kpwenye mzabibu mnono sana, undafula nguwozo na uchi wa zabibu uchi wa kundu dza mlatso. ");
INSERT INTO dig_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Matsogo gadobera kundu kpwa kunwa uchi wa zabibu, na menogo gandakala mereru kpwa kunwa maziya manji. ");
INSERT INTO dig_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zabuloni undasagala pwani. Na iyo pwaniyo indakala bandari salama. Mphakawe undafika hadi Sidoni. ");
INSERT INTO dig_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakari u dza punda mwenye mkpwotse, achiyedziambalaza kahi-kahi ya mizigo. ");
INSERT INTO dig_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Achiona phatu pha kuoya ni phanono, na yo tsi ni nono, nkuzamisa mongowe kutsukula mizigo, na kuhendeswa kazi za shokowa dza mtumwa. ");
INSERT INTO dig_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dani undakala muamuli wa haki wa atuo, dza mbari zanjina za Iziraeli. ");
INSERT INTO dig_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dani undakala dza nyoka njirani, nyoka ya sumu kali kanda-kanda ya njira, ingʼatayo majimbe ga farasi ili ariye dzulu ya farasi agbwe chingari-ngari. ");
INSERT INTO dig_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“Ee, Mwenyezi Mlungu, nagodza wokofuo. ");
INSERT INTO dig_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gadi undavwamukirwa ni kundi ra akora, ela undaazoresa. ");
INSERT INTO dig_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asheri, mavunogo gandakala manji na manono, gamfwahago mfalume. ");
INSERT INTO dig_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Nafutali u dza kulungu awehaye huru, na ambaye anavyala ana anono. ");
INSERT INTO dig_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yusufu u dza mzabibu uvyalao sana, mzabibu urio kanda-kanda ya pula za madzi, ambao pandaze zinaambala dzulu ya ukuta. ");
INSERT INTO dig_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Anajeshi a maha akushambulia na usiru, achikulatsa kuno anakuzoresa. ");
INSERT INTO dig_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ela uhawe tausumbire mwakpwe mikononi, mikonoye yatiywa nguvu, ni Iye Mwenye Nguvu Zosi wa Jakobo; Mlungu ambaye ni Mrindzi na Mwamba wa Iziraeli, ");
INSERT INTO dig_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Mlungu wangu naakuterye, Mwenye Nguvu Zosi akujaliyaye na baraka ya mvula kula mlunguni na madzi kula photsi, akujaliyaye na mifugo minji na vivyazi vinji. ");
INSERT INTO dig_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Baraka hizi za sowe ni kulu zinatsapa baraka zojaliwa mimi ni akare angu. Baraka zosi hizi nazikale zako uwe, Yusufu, uwe uriyetsambulwa kahi ya nduguzo. ");
INSERT INTO dig_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamini u dza bawa ra kumendza kurya sana; ligundzu nkumpiga aduiwe na dziloni akaganya zewe.” ");
INSERT INTO dig_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Higo ndigo maneno arigogomba Iziraeli, ariphokala anabariki anae, chila mmwenga na barakaze. Hinya ana kumi na airi a Iziraeli ndio okala mbari kumi na mbiri. ");
INSERT INTO dig_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Halafu Jakobo walagiza anae achiamba, “Siku zangu za kufwa zi phephi. Siku nchifwa kanizikeni vikurani pha ano baba, nizikani pango ra munda wa Efuroni, yuya Muhiti, ");
INSERT INTO dig_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","pango ririro hiko Makipela, mlairo wa dzuwa wa Mamre, tsi ya Kanani. Burahimu wagula pango hiro na mundawe kula kpwa Efuroni, ili phakale vikurani. ");
INSERT INTO dig_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Hiko ndiko kozikpwa Burahimu na mchewe Sara, ndiko kozikpwa Isaka na mchewe Rebeka. Na kuko ndiko kozika mkpwazangu Lea. ");
INSERT INTO dig_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Munda hinyo na pangore wagulwa kula kpwa Ahiti.” ");
INSERT INTO dig_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Jakobo ariphomala kuausiya anae, wapandiza maguluge chitandani, achidzilaza na achifwa. ");
INSERT INTO dig_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Jakobo ariphofwa, Yusufu wazama pho chitswani pha ise achirira na achimdonera. ");
INSERT INTO dig_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Halafu walagiza atumishie ariokala ni aganga apake dawa nyo mwiri wa ise ili usiole, nao achihenda vivyo. ");
INSERT INTO dig_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Ahala siku mirongo mine, ambazo kala ndio muda wa kawaida wa kupaka lufu dawa. Na Amisiri amuikira hanga ra siku mirongo sabaa. ");
INSERT INTO dig_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Hanga phosira, Yusufu waambira atumishi a mfalume, “Tafadhalini, ichiwezekana, bishani na mfalume badala yangu. Muambireni kukala ");
INSERT INTO dig_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","baba phokala a phephi na kufwa, wanirisa chirapho achiamba, ‘Siku nchifwa kanizike kpwenye mbira yoitayarisha hiko tsi ya Kanani.’ Phahi nirichani nikazike baba, chisha nindauya.” ");
INSERT INTO dig_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Mfalume achiamba, “Phiya ukamzike sowe vyo urivyomuapira.” ");
INSERT INTO dig_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Phahi Yusufu waphiya kpwendazika ise. Waphiya phamwenga na atumishi osi muhimu a mfalume, yani, mawaziri na atu muhimu a tsi ndzima ya Misiri. ");
INSERT INTO dig_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Piya waphiya na atu osi a phakpwe kaya, nduguze na ana ao. Ko Gosheni aricha anache na mangʼondzi, mbuzi na ngʼombe bahi. ");
INSERT INTO dig_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Waphiya na magari ga kuvwehwa ni farasi na aphirikie, kala ni kundi kulu sana ra atu. ");
INSERT INTO dig_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ariphofika Atadi, phatu pha kuwagira mtsere, ngʼambo ya muho Joridani, afwererwa arira na raka ra dzulu kpwa sonono, na Yusufu achiika hanga siku sabaa. ");
INSERT INTO dig_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Enyezi a Kanani ariphoona hara atu ana hanga hipho Atadi, aamba, “Hanga hiri ra Amisiri kpwa kpweli ni kulu sana.” Ndiyo mana phatu hipho phokala phephi na Joridani phaihwa Abeli Miziraimu. ");
INSERT INTO dig_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Ana a Jakobo amuhendera ise yao viratu vyoalagiza. ");
INSERT INTO dig_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Amtsukula hadi tsi ya Kanani achendamzika pangoni munda wa Makipela, mlairo wa dzuwa wa Mamre. Burahimu wagula pango hiro na mundawe kula kpwa Efuroni, Muhiti, ili phakale vikurani. ");
INSERT INTO dig_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yusufu ariphozika ise, wauya Misiri na nduguze na atu osi okala akaphiya nao mazishini. ");
INSERT INTO dig_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Bada ya chifo cha ise yao, nduguze Yusufu aamba, “Hundahendadze ichikala Yusufu achere na utsungu naswi na atake kudziriphiza kpwa mai gosi gomuhenda?” ");
INSERT INTO dig_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Phahi ahuma mutu kpwa Yusufu, achendamuamba, “Kabila baba kadzangbwefwa wahulagiza hukuambe, ");
INSERT INTO dig_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Nakuvoya uaswamehe nduguzo uasi wao na makosa gao arigokukosera, mana wakati hinyo akugayisa sana.’ Phahi hunakuvoya uhuswamehe uasi wehu, swiswi atumishi a Mlungu wa baba.” Yusufu ariphophaha salamu hizo, warira. ");
INSERT INTO dig_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Chisha nduguze akpwedzamgbwerera maguluni achiamba, “Swiswi hu atumwao.” ");
INSERT INTO dig_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ela Yusufu achiaambira, “Msiogophe, mino siweza kuhala nafwasi ya Mlungu. ");
INSERT INTO dig_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Mwimwi mwakusudiya mai ela Mlungu wakusudiya manono, ili nitivye maisha ga atu anji kama irivyo rero. ");
INSERT INTO dig_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Kpwa hivyo, msiogophe! Mimi nindakutundzani, mwimwi na ana enu.” Achiausa wasiwasi na achiaphoza marenda. ");
INSERT INTO dig_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yusufu waenderera kusagala tsi ya Misiri phamwenga na nduguze na ana ao. Yusufu waishi miaka gana mwenga na kumi ");
INSERT INTO dig_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","na achiona chivyazi cha hahu cha Efuraimu. Piya wajaliwa kuona uvyazi wa Makiri, mwana mlume wa Manase. ");
INSERT INTO dig_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Siku mwenga Yusufu waambira nduguze, “Mimi ni phephi na kufwa, ela kpwa kpweli Mlungu andakuteryani na andakulongozani kuphiya tsi yolaga kuapha Burahimu, Isaka na Jakobo.” ");
INSERT INTO dig_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Chisha Yusufu waarisa chirapho nduguze achiamba, “Hakika Mlungu andakuteryani kuphiya tsi ya Kanani. Apani kukala, ndiphokala munauka hipha, mundahala mifupha yangu mphiye nayo.” ");
INSERT INTO dig_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Phahi Yusufu wafwa wakati ana miaka gana mwenga na kumi. Amisiri autiya dawa nyo mwiriwe ili usiole na achiutiya ndani ya sanduku ra kuzikira ko Misiri.");
INSERT INTO dig_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Ana a Jakobo ariophiya Misiri phamwenga naye, ambapho chila mmwenga waphiya na atue: ");
INSERT INTO dig_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rubini, Simioni, Lawi, Juda, ");
INSERT INTO dig_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isakari, Zabuloni, Benjamini, ");
INSERT INTO dig_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dani, Nafutali, Gadi na Asheri. ");
INSERT INTO dig_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Jumula ya uvyazi wa Jakobo kala ni atu mirongo sabaa. Ela mwanawe Yusufu kala a kuko Misiri kare. ");
INSERT INTO dig_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Badaye Yusufu na nduguze na chivyazi chosi cha wakati wao chafwa, ");
INSERT INTO dig_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","ela uvyazi wa Aiziraeli wavyalana, na uchienjerezeka sana. Akala anji, hata tsi yosi ichiodzala aho. ");
INSERT INTO dig_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Phahi kpwazuka mfalume muphya ambaye kala kamanya rorosi kuhusu Yusufu, achitawala Misiri. ");
INSERT INTO dig_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Hiye mfalume waambira atue, “Hinya Aiziraeli ni anji sana na ana nguvu kuhushinda. ");
INSERT INTO dig_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Kuchigbwa viha, halafu achigbwirana na maadui gehu kuhupiga, anaweza kuphaha nafwasi ya kuhutawala. Kpwa hivyo, ni lazima huendzeni njira ya chiwerevu kuazuwiya ili asienjerezeke zaidi.” ");
INSERT INTO dig_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Phahi Amisiri aaikira Aiziraeli aimirizi achiahenda atumwa kpwa kuatsukuza mizigo miziho. Aiziraeli amdzengera Farao midzi ya kuikira akiba ya chakurya, yani Pithomu na Ramesesi. ");
INSERT INTO dig_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Ela vira arivyozidi kugayiswa, ndivyo arivyozidi kuenjerezeka na achigota tsi yosi. Phahi Amisiri atishirwa sana ni nyo Aiziraeli. ");
INSERT INTO dig_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","O Amisiri aalazimisha Aiziraeli kuhenda kazi ngumu zaidi tsona bila ya mbazi. ");
INSERT INTO dig_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Ahenda maisha gao gakale ga kugaya sana kpwa kazi ngumu dza kutengeza chokaa na kutengeza matofali, chisha ahenda kazi zosi za mindani. Kazi hizi arizohenda ahendeswa chisiru. ");
INSERT INTO dig_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Mfalume wa Misiri wabisha na avyalusadzi airi a Chieburania, arioihwa Shifura na Puwa. Achiaambira, ");
INSERT INTO dig_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Muchikala munavyalusa mchetu wa Chieburania, mlolenito vyo avyalavyo, achikala ye mwana ni mchetu, mricheni aishi, ela achivyala mlume, muolageni ye mwana.” ");
INSERT INTO dig_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Ela hara avyalusadzi kala anamuogopha Mlungu wala taayahenda vira arivyolagizwa ni mfalume wa Misiri, ela aaricha ana alume aishi. ");
INSERT INTO dig_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Badaye hiye mfalume wa Misiri waiha hara avyalusadzi na achiauza, “Kpwadze munahenda vino vya kuricha ana a chilume aishi?” ");
INSERT INTO dig_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Hara avyalusadzi amjibu Farao achimuamba, “Achetu a Chieburania sio dza achetu a Chimisiri mana ana nguvu na avyala machiyao kabila ya swiswi kufika.” ");
INSERT INTO dig_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Phahi, Mlungu waaonera mbazi hara avyalusadzi kpwa vira kala nkumuogopha Mlungu, achiajaliya nao piya achiphaha ana. Nao Aiziraeli achizidi kuenjerezeka na achikala na nguvu sana. ");
INSERT INTO dig_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Chisha Farao walavya malagizo kpwa atu osi achiamba, “Mwana wa chilume ndiyevyalwa ni Mueburania, mtsupheni muho wa Naili, ela mwana mchetu mricheni akale moyo.” ");
INSERT INTO dig_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Siku zizo kpwakala na mutu mmwenga wa mbari ya Lawi ariyephiya kpwendalóla mchetu wa chivyazi cha Lawi. ");
INSERT INTO dig_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Mchetu hiye wagbwira mimba na achivyala mwana mlume. Ariphoona yuya mwana ni mnono, wamfwitsa nyumbani miezi mihahu. ");
INSERT INTO dig_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Ela yuya mwana ariphokala kaweza kufwitsika tsona, watengeza chidau cha nyasi na achichisaka lami. Wamlaza yuya mwana mo ndani halafu achendachiika guguni, kanda-kanda ya muho wa Naili. ");
INSERT INTO dig_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Ndugu wa chichetu wa yuya mwana waima kanda kulola ndiromphaha nduguye. ");
INSERT INTO dig_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Halafu mwana mchetu wa Farao wakpwedzaoga muhoni, na atumishie kala ananyendeka-nyendeka ko muhoni. Gafula yuya mwana wa Farao achiona chira chidau chinaengelela ndani-ndani ya gugu, achimuhuma mtumwawe mmwenga akachihale. ");
INSERT INTO dig_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Ariphochireha, mwana wa Farao wachifwenula achiona mwana. Yuya mwana kala anarira, achimuonera mbazi na achiamba, “Hiyu ni mmwenga wa nyo ana a Chieburania.” ");
INSERT INTO dig_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Halafu ndugungbwa wa yuya mwana achedzamuamba mwana wa Farao, “Nkakuendzere mchetu wa Chieburania edze akuamwisire hiyu mwana?” ");
INSERT INTO dig_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Ye mwana wa Farao achimjibu achiamba, “Aya phiya ukaniendzere.” Phahi, yuya msichana wakpwendahala nine mwenye wa yuya mwana. ");
INSERT INTO dig_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Yuya mwana wa Farao achimuamba yuya mchetu, “Muhale hiyu mwana ukaniamwisire, nami nindakuripha.” Phahi wamuhala yuya mwana na achendamuamwisa. ");
INSERT INTO dig_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Yuya mwana ariphofuhuka, wamphirika kpwa mwana wa Farao, naye achimuhala achimuhenda mwanawe mwenye. Achiamba, “Kpwa vira námtsola madzini, nindamuiha Musa.” ");
INSERT INTO dig_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Siku mwenga, Musa ariphokala mvyere, wakpwendalola nduguze Aeburania, na achiona vira alazimishwavyo kuhenda kazi ngumu. Phahi wamuona Mueburania myawe anapigbwa ni Mmisiri. ");
INSERT INTO dig_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Waphelephesa hiku na hiku, na ariphoona takuna mutu, wamuolaga yuya Mmisiri na achimfwitsa difwirini. ");
INSERT INTO dig_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Kuriphocha, Musa wakpwendaweha tsona, achiona Aeburania airi anapigana. Phahi wamuamba yuya achiyemkosera myawe, “Mbona unampiga Mueburania myao?” ");
INSERT INTO dig_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Yuya mutu achimuamba Musa, “Ni ani yekuhenda mtawala wehu na muamuli? Hebu unalonda uniolage dza vira vyomuolaga yuya Mmisiri?” Musa ariphosikira hivyo waogopha na achidziamba, “Higa mambo nrigohenda ni lazima gakale ganamanyikana!” ");
INSERT INTO dig_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Phahi Farao ariphogasikira, walonda kumuolaga Musa, ela Musa wachimbira hipho pha Farao, achendasagala tsi ya Midiani. Siku mwenga Musa ariphokala asegere kanda-kanda ya chisima, ");
INSERT INTO dig_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","phakpwedza asichana sabaa ana a mlavyadzi-sadaka wa Midiani. Achedzaheka madzi achiodzaza mabirika ili kunwesa mangʼondzi na mbuzi za ise yao. ");
INSERT INTO dig_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Ela kabila taadzangbwenwesa, kuchedza arisa anjina achiazoresa, phahi Musa waunuka achendaaterya na achinwesa go mangʼondzi na mbuzi zao. ");
INSERT INTO dig_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Hara asichana ariphouya kaya, Reueli ise yao waauza achiamba, “Mbona rero mkedza mapema?” ");
INSERT INTO dig_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Nao achimjibu achiamba, “Kukedza arisa anjina akakala anahuzoresa, halafu Mmisiri mmwenga akahuokola, chisha akahuhekera madzi akanwesa mangʼondzi na mbuzi zehu.” ");
INSERT INTO dig_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Naye Reueli achiauza, “Sambi akuphi ye mutu? Kpwa utu wani mkamricha kuko? Kamuiheni edze arye chakurya.” ");
INSERT INTO dig_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Musa wakubali kpwendasagala kaya pha Jethiro. Badaye Jethiro wamupha Musa mwanawe yeihwa Zipora, akale mchewe. ");
INSERT INTO dig_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Zipora wavyala mwana mlume na Musa achimuiha Gerishomu, mana waamba, “Nachimbira kuphiya tsi ambako ni mjeni.” ");
INSERT INTO dig_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Bada ya miaka minji, yuya mfalume wa Misiri wafwa. Aiziraeli alalamika kpwa sababu ya kazi za utumwa na achirira kulonda msada. Hicho chiriro chao chafika dzulu kpwa Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Mlungu wasikira kururumika kpwao na achitambukira chilagane arichoika na Burahimu, Isaka na Jakobo. ");
INSERT INTO dig_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Mlungu waona vira Aiziraeli arivyokala anagayiswa, na achiaonera mbazi. ");
INSERT INTO dig_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Siku mwenga, Musa kala anarisa mangʼondzi na mbuzi za mtsedzawe Jethiro, mlavyadzi-sadaka wa Midiani. Phahi waphirika mangʼondzige na mbuzize jangbwani mwendo wa kukola hata achifika Horebu, mwango wa Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Malaika wa Mwenyezi Mlungu wamtsembukira na mfwano wa jimbijimbi ra moho kpwenye chitsaka cha miya. Phahi Musa walola, lo! Chitsaka chinaaka, ela tachiphya. ");
INSERT INTO dig_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Hipho, Musa waangalala, achidziuza, “Mbona chira chitsaka chinaaka moho lakini tachiphya? Godza nsengere phephi, nlole chilinje hichi.” ");
INSERT INTO dig_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Mwenyezi Mlungu ariphoona Musa anasengera phephi, wamuiha kula pho kahi-kahi ya chitsaka, “Musa! Musa!” Musa achiihika, “Ee, himi.” ");
INSERT INTO dig_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Mwenyezi Mlungu achimuamba, “Usisengere phephi. Vula virahuvyo, mana pho uimirepho ni phatu phatakatifu.” ");
INSERT INTO dig_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Chisha achiamba, “Mimi ndimi Mlungu wa akareo, ni Mlungu wa Burahimu, wa Isaka na wa Jakobo.” Musa ariphosikira hivyo, waziba usowe mana kala anaogopha kumlola Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Chisha Mwenyezi Mlungu achiamba, “Kpwa kpweli nkaona kugaya kpwa atu angu hiko Misiri. Nkasikira chiriro chao kpwa sababu ya aimirizi aho anavyoagayisa, nami namanya mashaka gao. ");
INSERT INTO dig_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Kpwa hivyo, nkatserera kpwedzaativya na kugaya anakogayiswa ni Amisiri na niatuluze tsi iyo, chisha niaphirike tsi nono ya nafwasi, tsi yenye rutuba. Tsi iyo inasagala Akanani, Ahiti, Aamori, Aperizi, Ahivi na Ajebusi. ");
INSERT INTO dig_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Vivi nkasikira chiriro cha Aiziraeli na nkaona vira Amisiri aagayisavyo. ");
INSERT INTO dig_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Phahi nakuhuma kpwa Farao ukatsamize atu angu Aiziraeli kula Misiri.” ");
INSERT INTO dig_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Ela Musa achimuamba Mlungu, “Mino ni ani hata niphiye kpwa Farao nikatuluze Aiziraeli kula Misiri?” ");
INSERT INTO dig_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Mlungu achimjibu achimuamba, “Kpwa kpweli nindakala phamwenga nawe, na uchiatuluza Aiziraeli kula Misiri, mundaniabudu dzulu ya mwango huno. Hino indakala ishara kuonyesa kukala nkakuhuma.” ");
INSERT INTO dig_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Musa achimuuza Mlungu, “Mendzerepho niphiye nkaambire hinyo Aiziraeli, ‘Mlungu wa akare enu akanihuma kpwenu,’ nao achiniuza ‘Dzinare ndiye ani?’ niaambedze?” ");
INSERT INTO dig_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Mlungu achimuamba Musa, “MIMI NDIMI NRIYEKO HATA KARE NA KARE. Ni lazima ukaambire Aiziraeli kukala, ‘ARIYEKO HATA KARE NA KARE, akanihuma kpwenu.’ ” ");
INSERT INTO dig_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Chisha Mlungu achimuamba Musa, “Aambire Aiziraeli, ‘Mwenyezi Mlungu, Mlungu wa akare enu, yani Mlungu wa Burahimu, wa Isaka na wa Jakobo, akanihuma kpwenu.’ Hiri ndiro dzina rangu hata kare na kare, dzina ambaro nindaihirwa ni vivyazi na vivyazi. ");
INSERT INTO dig_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Phiya ukaakusanye atumia a Iziraeli na uaambire, ‘Mwenyezi Mlungu, Mlungu wa akare enu Burahimu, Isaka na Jakobo wanitsembukira na achiniamba kukala akaona vyo muhendwavyo kuko Misiri. ");
INSERT INTO dig_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Nami naahidi kukala nindakutuluzani kpwenye go mateso ga Misiri nikuphirikeni tsi ya Akanani, Ahiti, Aamori, Aperizi, Ahivi na Ajebusi, tsi nono yenye rutuba.’ ");
INSERT INTO dig_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Nyo atumia a Iziraeli andakusikira. Chisha uwe na hinyo atumia mphiye kpwa mfalume wa Misiri mkamuambe, ‘Swino hukakutana na Mwenyezi Mlungu, Mlungu wa Aeburania. Hebu huriche huphiye charo cha siku tahu jangbwani hukamlavire sadaka Mwenyezi Mlungu, Mlungu wehu.’ ");
INSERT INTO dig_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Ela namanya mfalume wa Misiri kandakurichani mphiye hadi ashurutishwe chinguvu-nguvu. ");
INSERT INTO dig_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Phahi nindahumira uwezo wangu kuhenda vilinje vya chila aina, kuatiya adabu Amisiri. Bada ya higo andakurichani muuke. ");
INSERT INTO dig_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Nindahenda Amisiri akumendzeni na ichikala munauka, msiuke mikono mihuphu. ");
INSERT INTO dig_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Chila mchetu wa Chieburania ni aphiye akavoye vitu vya feza na vya zahabu na nguwo kula mchetu myawe wa Chimisiri na kula kpwa mchetu yeyesi asagalaye nyumbani mwa ye Mmisiri. Muchihewa vitu vivyo mundaavwika ana enu a chilume na a chichetu. Namwi mundakala mukaafuta Amisiri utajiri wao.” ");
INSERT INTO dig_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Phahi Musa wamuamba Mwenyezi Mlungu, “Dze, achirema kuniamini ama achirema kuniphundza na aambe, ‘Mwenyezi Mlungu kayakutsembukira?’” ");
INSERT INTO dig_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Mwenyezi Mlungu wamuuza Musa, “Ukagbwirani mo mkpwononi?” Achiamba, “Nkagbwira ndata.” ");
INSERT INTO dig_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Mwenyezi Mlungu achimuamba, “Hebu ibwage photsi.” Musa achiibwaga na ichigaluka nyoka, hata ye Musa mwenye achiichimbira. ");
INSERT INTO dig_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Halafu Mwenyezi Mlungu achimuamba, “Golosa mkpwonoo uitsole na ko mchirani.” Phahi Musa wagolosa mkpwonowe achiitsola, nayo achigaluka ndata tsona. ");
INSERT INTO dig_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Mwenyezi Mlungu achimuamba Musa, “Vivi ndivyo andaweza kuamini kukala Mwenyezi Mlungu, Mlungu wa akare ao, Burahimu, Isaka na Jakobo, wakutsembukira kpweli.” ");
INSERT INTO dig_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Chisha Mwenyezi Mlungu achienderera kugomba na Musa achimuamba, “Tiya mkpwonoo mwako johoni.” Musa wautiya, na ariphoutuluza, lo! Uchikala u tele mahana hata uchikala ni mwereru dza bafuta. ");
INSERT INTO dig_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Halafu achimuamba, “Wuuyize tsona johoni.” Phahi Musa wawuuyiza johoni, na ariphoutuluza, uchikala ukauyato dza viratu mwiriwe urivyo. ");
INSERT INTO dig_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Mwenyezi Mlungu achimuamba, “Ichikala taandakuamini uwe wala hicho chilinje cha kpwandza, chahi andaamini hichi cha phiri. ");
INSERT INTO dig_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ela ichikala taandaamini vilinje vyosi viiri wala kukuphundza, heka madzi kula muho wa Naili, ugamwage tsi kavu, nago gachiguta yo tsi kavu tu, gandagaluka milatso.” ");
INSERT INTO dig_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Musa achimuamba Mwenyezi Mlungu, “Ee Bwana wangu, mino hangu kare simi mgombadzi mnono, na hangu uchiphoandza kugomba bado mimi mtumishio siweza. Maneno gangu ni ga pore-pore na ga chigugumiza.” ");
INSERT INTO dig_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Ndipho Mwenyezi Mlungu achimuamba, “Ni ani yemupha mwanadamu mromo? Ni ani amuhendaye mutu akale masito ama bwibwi? Ni ani yemupha mwanadamu matso ama ni ani amuhendaye chipofu? Dze, siye mimi, Mwenyezi Mlungu? ");
INSERT INTO dig_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Sambi phiya, nindakuterya kugomba na nindakufundza ndigogomba.” ");
INSERT INTO dig_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Ela Musa achiamba, “Bwana wangu, nakuvoya uhume mutu wanjina.” ");
INSERT INTO dig_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Mwenyezi Mlungu achitsukirwa sana, achimuamba Musa, “Dze, ye nduguyo Aruni ambaye ni Mlawi kapho? Ninamanya kukala iye anagombato. Vivi iye a njirani aredza akuchinjire, na ndiphokuona andahererwa sana. ");
INSERT INTO dig_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Uwe undakala uchimuambira ga kugomba mana nindakala phamwenga namwi kahi ya kugomba kpwenu na kukufundzani go mufwahago kuhenda. ");
INSERT INTO dig_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Aruni andagomba na atu badala ya uwe, nawe undakala dza Mlungu kpwakpwe kpwa sababu undakala unamlagiza ndigogomba. ");
INSERT INTO dig_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Ela tsukula hino ndata ili ukahendere vilinje nchivyokuonyesa.” ");
INSERT INTO dig_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Phahi Musa wauya kpwa mtsedzawe, Jethiro achendamuamba, “Nakuvoya uniruhusu niuye Misiri nkalole napho atu angu achere moyo.” Naye Jethiro achimuamba, “Phiya salama.” ");
INSERT INTO dig_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Kabila Musa kadzangbwetuluka Midiani, Mwenyezi Mlungu wamuamba, “Uya Misiri mana atu osi okala analonda kukuolaga afwa.” ");
INSERT INTO dig_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Musa wahala mchewe na anae, achiapandiza dzulu ya punda na achiandza charo cha kuuya Misiri, kuno akagbwiririra ndata ya Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Tsona Mwenyezi Mlungu achimuamba Musa, “Uchifika Misiri, hakikisha ukahenda mbere za Farao vilinje vyosi nrivyokupha uwezo wa kuvihenda. Ela nindamtiya moyo mufu ili asiruhusu Aiziraeli kuuka. ");
INSERT INTO dig_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Chisha umuambe vivi ye Farao, ‘Mwenyezi Mlungu anaamba kukala, Iziraeli ni mwanangu mvyere wa chilume. ");
INSERT INTO dig_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Nákuambira umriche mwanangu auke ili akaniabudu. Ela uchirema kumrichira mwanangu aphiye vyakpwe, phahi nindaolaga mwanao mvyere wa chilume.’ ” ");
INSERT INTO dig_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Musa ariphokala anaphiya Misiri, mo njirani waphaha phatu pha kulala ajeni, Mwenyezi Mlungu achitaka kumuolaga. ");
INSERT INTO dig_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Ela Zipora mkpwaza Musa achihala rumu ra dziwe achimdeka mwanawe mlume na achihala ro sunyu achimgutiza mlumewe maguluni. Chisha achiamba, “Kpwa kpweli u mlume wangu wa mlatso!” ");
INSERT INTO dig_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Hipho Mwenyezi Mlungu achimricha Musa sebu amuolage. Zipora waamba hivi, “Mlume wangu wa mlatso,” mana kala akatambukira tsatsa. ");
INSERT INTO dig_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Wakati uho, Mwenyezi Mlungu wamuamba Aruni, “Phiya jangbwani ukamchinjire Musa.” Phahi Aruni wakpwendakutana naye mwango wa Mlungu na achilamusana kpwa kumdonera. ");
INSERT INTO dig_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Chisha Musa achimsemurira Aruni chila chitu arichokala Mwenyezi Mlungu akamuhuma, phamwenga na vyo vilinje vyosi vyolagizwa avihende. ");
INSERT INTO dig_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Phahi Musa na Aruni aphiya Misiri phamwenga na achendakusanya atumia osi a Iziraeli. ");
INSERT INTO dig_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Na Aruni achiaambira chila chitu ambacho Mwenyezi Mlungu wamuambira Musa, chisha achihenda vilinje vyosi mbere za nyo atu. ");
INSERT INTO dig_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Atumia osi akuluphira, nao ariphosikira kala Mwenyezi Mlungu waona kugaya kpwa atu a Iziraeli na achisononeka, azamisa vitswa vyao na achimuabudu Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Bada ya kukutana na atumia, Musa na Aruni aphiya kpwa Farao achendamuamba, “Mwenyezi Mlungu, Mlungu wa Iziraeli anaamba, ‘Ariche atu angu aphiye jangbwani ili akahende sharee ya kuniabudu.’ ” ");
INSERT INTO dig_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Farao achiamba, “Kpwani ye Mwenyezi Mlungu ni ani hata nimusikize na niriche Aiziraeli auke? Ye Mwenyezi Mlungu simmanya, na nyo Aiziraeli sindaaruhusu auke.” ");
INSERT INTO dig_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Musa na Aruni achimjibu achimuamba, “Mlungu wa Aeburania wahutsembukira. Sambi huriche huuke charo cha siku tahu kuphiya jangbwani hukamlavire sadaka Mwenyezi Mlungu, Mlungu wehu. Mana husiphohenda hivyo, andahuolaga na makongo ama kpwa upanga.” ");
INSERT INTO dig_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Ela mfalume wa Misiri achiamba, “Musa na Aruni, kpwa utu wani mnalonda muause atu kazini mwao? Haya, uyani kpwenu makazini!” ");
INSERT INTO dig_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Chisha Farao achienderera kuamba, “Lolani, nyo atu enu ndio anji kuriko nyo enye tsi, tsona mnalonda asihende kazi!” ");
INSERT INTO dig_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Siku iyo-iyo kare ye Farao waambira aimirizi a Chiiziraeli na akulu aho a Chimisiri achiamba, ");
INSERT INTO dig_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Hangu rero hinya atu msiaphe nyasi mbifu za kutengezera matofali, aricheni akaendze enye. ");
INSERT INTO dig_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Ela aambireni atengeze chiasi cha matofali dza chiratu cha mwandzo, kpwa vyovyosi msigaphunguze hata vichache. Hinya atu ni avivu ndiyo mana anarira anaamba, ‘Huricheni huphiye hukamlavire sadaka Mlungu.’ ");
INSERT INTO dig_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Apheni kazi ngumu zaidi hinyo alume ili aenderere kuhenda kazi na asiphahe wakati wa kuphundza mambo ga handzo.” ");
INSERT INTO dig_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Ndipho aimirizi na akulu aho ariphophiya ko kpwa Aiziraeli achendaambira, “Farao anaamba kala kandalavya tsona nyasi mbifu. ");
INSERT INTO dig_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Phiyani mkaendze enye nyasi mbifu kokosi ambako mundaziphaha, ela chiasi cha matofali muhendacho tachindaphunguzwa bii.” ");
INSERT INTO dig_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Phahi atu osi atsamukana chila phatu Misiri kuendza nyasi mbifu. ");
INSERT INTO dig_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Akulu a aimirizi azidi kualazimisha kuhenda kazi, kala achiaambira, “Ni mmale chiasi cha matofali chiratu chitakiwacho kpwa siku, dza pharatu phokala munahewa nyasi mbifu.” ");
INSERT INTO dig_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Aimirizi a Chiiziraeli kala achipigbwa ni akulu a Farao na kuambwa, “Mbona dzana na rero tamyahenda chiasi cha matofali dza phara mwandzo?” ");
INSERT INTO dig_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Halafu aimirizi a Aiziraeli akpwendalalama kpwa Farao achiamba, “Mfalume, mbona swino atumishio unahugayisa? ");
INSERT INTO dig_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Swino tahuhewa tsona nyasi mbifu, ela bado hunaambwa, ‘Tengezani matofali.’ Tsona swiswi atumishio hunapigbwa. Ela makosa gana uwe na atuo.” ");
INSERT INTO dig_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Farao achiajibu achiamba, “Mu avivu na tamlonda kuhenda kazi! Ndiyo mana munaamba, ‘Huriche hukamlavire sadaka Mwenyezi Mlungu.’ ");
INSERT INTO dig_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Sambi, uyani kazini. Tamundahewa nyasi mbifu, na ni lazima mtengeze chiasi kamili cha matofali.” ");
INSERT INTO dig_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Aimirizi a Aiziraeli amanya a mashakani ariphoambwa, “Kpwa vyovyosi msiphunguze isabu ya matofali galondwago kpwa siku.” ");
INSERT INTO dig_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Ariphouka phara pha Farao, akuta Musa na Aruni anaagodza. ");
INSERT INTO dig_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Aambira Musa na Aruni, “Mwenyezi Mlungu naalole neno hiri. Naakuamuleni kpwa kuhuhenda swiswi huzirwe ni Farao na atumishie. Maneno genu ndigo goahenda aphahe chisa cha kuhuolagira.” ");
INSERT INTO dig_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Musa ariphosikira hivyo wauya kpwa Mwenyezi Mlungu achendamuamba, “Aa, Mwenyezi Mlungu, mbona hano atu ukaahendera uyi vino? Dze, gano ndigo goniihira? ");
INSERT INTO dig_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Kula mwandzo nriphophiya kpwa Farao kpwendagomba manenogo, waatiya mashakani hinya atu, na wala kudzangbwetivya atuo hata vivi.” ");
INSERT INTO dig_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Phahi Mwenyezi Mlungu achimuamba Musa, “Sambi undaona ndivyo muhenda Farao. Kpwa uwezo wangu nindamuhenda aariche nyo atu auke, na kpwa uwezo wangu andaazola kpwenye tsiiye.” ");
INSERT INTO dig_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Mlungu piya wamuamba Musa, “Mimi, ndimi Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Námtsembukira Burahimu, Isaka na Jakobo dza Mlungu Mwenye Nguvu Zosi, ela siamanyisire dzina rangu ra Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Ela náika nao chilagane kukala nindaapha tsi ya Kanani, tsi ambayo asagala dza ajeni. ");
INSERT INTO dig_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Zaidi ya gago, násikira chiriro cha Aiziraeli ambapho Amisiri anaahumira dza atumwa, ndipho nchitambukira chilagane changu. ");
INSERT INTO dig_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Kpwa hivyo aambire Aiziraeli, ‘Mimi, ndimi Mwenyezi Mlungu, nami nindakutuluzani kula kahi ya utumwa wa Amisiri, nikuhendeni mkale huru. Nindagolosa mkpwono wangu wenye uwezo kuatiya adabu nyo Amisiri. ");
INSERT INTO dig_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Nindakuhendani mkale atu angu, nami nindakala Mlungu wenu. Ndipho namwi mundamanya kala mimi, ndimi Mwenyezi Mlungu, Mlungu wenu, nriyekutuluzani utumwani hiko Misiri. ");
INSERT INTO dig_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Nindakuphirikani tsi yoapira kuapha Burahimu, Isaka na Jakobo. Nindakuphani ikale yenu. Kpwa kukala mimi, ndimi Mwenyezi Mlungu.’ ” ");
INSERT INTO dig_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Musa wakpwendaambira Aiziraeli gara goambirwa ni Mlungu. Ela taayaphundza, kpwa sababu kala akavundzika mioyo kpwa kuhendeswa kazi ngumu. ");
INSERT INTO dig_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Chisha Mwenyezi Mlungu achigomba na Musa achimuamba, ");
INSERT INTO dig_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Phiya ukamuambe Farao, mfalume wa Misiri, aarichire Aiziraeli auke tsiiye.” ");
INSERT INTO dig_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Ela Musa achimuamba Mwenyezi Mlungu, “Ichikala Aiziraeli taakaniphundza, dze, ye Farao andaniphundzadze mino mutu wa chigugumiza?” ");
INSERT INTO dig_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Hata hivyo Mwenyezi Mlungu wagomba na Musa na Aruni kuhusu Aiziraeli na Farao, mfalume wa Misiri, kukala aaruhusu Aiziraeli atuluke kula Misiri. ");
INSERT INTO dig_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Hinya ni akulu a miryango ya mbari za Aiziraeli: Ana a Rubini, mwana mvyere wa Iziraeli, kala ni Hanoki, Palu, Hezironi na Karimi. Hinya ndio okala mwandzo wa miryango ya Rubini. ");
INSERT INTO dig_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Ana a Simioni kala ni Jemueli, Jamini, Ohadi, Jakini, Sohari na Shauli ambaye nine kala ni mchetu wa Chikanani. Hinya ndio okala mwandzo wa miryango ya Simioni. ");
INSERT INTO dig_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Higa ni madzina ga uvyazi wa Lawi: Ana a Lawi kala ni Gerishoni, Kohathi na Merari. (Lawi waishi miaka gana mwenga na mirongo mihahu na sabaa.) ");
INSERT INTO dig_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Ana a Gerishoni kala ni Libuni na Shimei. ");
INSERT INTO dig_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Ana a Kohathi kala ni Amuramu, Ishari, Heburoni na Uzieli. (Kohathi waishi miaka gana mwenga na mirongo mihahu na mihahu.) ");
INSERT INTO dig_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Ana a Merari kala ni Mahili na Mushi. Hinya ndio okala mwandzo wa miryango ya Lawi. ");
INSERT INTO dig_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amuramu walóla shangazire tu yeihwa Jokebedi, achivyala naye Aruni na Musa. (Amuramu waishi miaka gana mwenga na mirongo mihahu na sabaa.) ");
INSERT INTO dig_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Ana a Ishari kala ni Kora, Nefegi na Zikiri. ");
INSERT INTO dig_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Ana a Uzieli kala ni Mishaeli, Elizafani na Sithiri. ");
INSERT INTO dig_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aruni walóla Elisheba mwana wa Aminadabu. Elisheba kala ni ndugungbwa wa Nashoni. Mchetu yuyu wamvyarira Aruni ana a chilume ane, nao ni Nadabu, Abihu, Eliazari na Ithamari. ");
INSERT INTO dig_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Ana a Kora kala ni Asiri, Elikana na Abiasafu. Hinya ndio okala mwandzo wa miryango ya Kora. ");
INSERT INTO dig_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eliazari mwana wa Aruni walóla mmwenga wa ana achetu a Putieli na achivyala naye Finehasi. Hinya ndio okala akarengbwa a miryango ya Lawi. ");
INSERT INTO dig_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Aruni yuyu na Musa yuyu ndio aratu arioambwa ni Mwenyezi Mlungu, “Atuluzeni Aiziraeli kula Misiri kulengana na makundi ga miryango yao.” ");
INSERT INTO dig_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Aruni yuyu na Musa yuyu ndio ariokpwendagomba na Farao, mfalume wa Misiri, kuhusu kutuluza Aiziraeli kula tsi ya Misiri. ");
INSERT INTO dig_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Siku Mwenyezi Mlungu ariphogomba na Musa kuko Misiri, ");
INSERT INTO dig_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","wamuamba Musa, “Mimi, ndimi Mwenyezi Mlungu. Muambire Farao, mfalume wa Misiri chila chitu nikuambiracho.” ");
INSERT INTO dig_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Ela Musa achimuamba Mwenyezi Mlungu, “Lola, mino nina chigugumiza, vyo kpweli Farao andaniphundza?” ");
INSERT INTO dig_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Chisha Mwenyezi Mlungu achimuamba Musa, “Sikiza, uwe ndakuhenda ukale dza Mlungu kpwa Farao na mwenenu Aruni andakala nabiio. ");
INSERT INTO dig_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Undakala uchimuambira nduguyo Aruni gosi ndigokulagiza, naye andamuambira Farao kukala aarichire ana a Iziraeli auke kpwenye tsiiye. ");
INSERT INTO dig_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Ela nindamtiya Farao moyo mufu, na hata dzagbwe nindazidisha vilinje vyangu na vituko ko tsi ya Misiri, ");
INSERT INTO dig_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","ela Farao kandakuphundza. Chisha nindagolosa mkpwono wangu chinyume cha Misiri na nituluze atu angu Aiziraeli madiba-madiba kula tsi ya Misiri, na niatiye adabu Amisiri kpwa uwezo wangu mkpwulu wa kuangalaza. ");
INSERT INTO dig_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Nao Amisiri andamanya kukala mimi, ndimi Mwenyezi Mlungu hipho ndiphoaonyesa uwezo wangu na kuatuluza Aiziraeli kula kahi yao.” ");
INSERT INTO dig_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Musa na Aruni ahenda vyo arivyolagizwa ni Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Wakati uho ariphogomba na Farao, Musa wakala ana miaka mirongo minane na Aruni wakala ana miaka mirongo minane na mihahu. ");
INSERT INTO dig_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Phahi Mwenyezi Mlungu wagomba na Musa na Aruni achiamba, ");
INSERT INTO dig_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Farao achendamuamba muhende vilinje ili ahakikishe, muambe Aruni abwage ndataye mbere za farao, nayo indagaluka nyoka.” ");
INSERT INTO dig_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Phahi Musa na Aruni aphiya kpwa Farao na achendahenda dza arivyolagizwa ni Mwenyezi Mlungu. Aruni wabwaga ndataye mbere za Farao na atumishie, nayo ichigaluka nyoka. ");
INSERT INTO dig_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Farao ariphoona vivyo, waiha atu enye ikima, atsai na aganga a Misiri, nao achedzahenda dza vivyo kpwa kuhumira uganga wao. ");
INSERT INTO dig_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Chila mmwenga wabwaga ndataye na ichigaluka nyoka. Ela yo ndata ya Aruni ichimiza zo ndata zao. ");
INSERT INTO dig_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Hata vivyo, moyo wa Farao wazidi kukala mufu, kayaphundza dza Mwenyezi Mlungu arivyokala akaatanguliya kuambira. ");
INSERT INTO dig_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Chisha, Mwenyezi Mlungu wamuamba Musa, “Farao ana moyo mufu, kamendze kuarichira atu angu auke. ");
INSERT INTO dig_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Phahi, phiya ukakutane na Farao ligundzu achikala anaphiya muhoni, phiya ukamgodzere kanda-kanda ya muho wa Naili kuno ukagbwiririra yo ndata iriyogaluka nyoka. ");
INSERT INTO dig_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Nawe undamuamba, ‘Mwenyezi Mlungu, Mlungu wa Aeburania wanihuma nedze nikuambire kukala waarichire atue auke, ili akamuabudu ko jangbwani, ela uwe kudzangbwesikira hadi rero. ");
INSERT INTO dig_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Phahi Mwenyezi Mlungu anaamba kukala kpwa sababu iyo, undamanya kukala iye ndiye Mwenyezi Mlungu. Lola, nindapiga madzi ga muho wa Naili na hino ndata nchiyogbwiririra, nago madzi gandagaluka mlatso. ");
INSERT INTO dig_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Nyo ngʼonda ario mumo muhoni andafwa na higo madzi gandanuka lovu hata Amisiri ashindwe kuganwa.’ ” ");
INSERT INTO dig_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Mwenyezi Mlungu wamuamba Musa, “Muambire Aruni ahale ndataye aolohe madzi ga Misiri, yani madzi ga myuho, vidzuho, maziya na mitsara yao yosi ili gagaluke milatso. Tsi ndzima indakala na milatso, hata madzi garigo ndani ya miyo ya mbao na ya mawe.” ");
INSERT INTO dig_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Musa na Aruni ahenda vyo arivyolagizwa ni Mwenyezi Mlungu. Aruni wahala ndataye mbere za Farao na atumishie, na achipiga madzi ga muho wa Naili, na madzi gosi gachigaluka milatso. ");
INSERT INTO dig_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Ngʼonda a muho wa Naili afwa, na madzi gachikala gananuka lovu hata Amisiri achikala taaweza kuganwa. Madzi gachigaluka milatso chila phatu kuko tsi ya Misiri. ");
INSERT INTO dig_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Ela nyo atsai a Misiri nao achihenda dza vyo vya Musa na Aruni kpwa kuhumira utsai wao. Phahi moyo wa Farao wazidi kukala mufu, naye kayakubali ga Musa na Aruni, dza vivyo arivyogomba Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Farao wauya kpwakpwe kaya, dzumba ra chifalume, wala kayagatiya manani higo garigohendeka. ");
INSERT INTO dig_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Amisiri atsimba kanda-kanda ya muho wa Naili ili aphahe madzi ga kunwa, mana madzi ga muho wa Naili kala taganweka. ");
INSERT INTO dig_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Zatsapa siku sabaa bada siku Mwenyezi Mlungu ariphogaluza madzi ga Naili kukala mlatso. ");
INSERT INTO dig_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Phahi Mlungu wamuamba Musa, “Phiya kpwa Farao ukamuambe, Mwenyezi Mlungu anakuamba ‘Ni lazima urichire atu angu auke ili akaniabudu. ");
INSERT INTO dig_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Ela uchirema kuarichira, nindapiga tsiiyo yosi kpwa kuiodzaza na magula. ");
INSERT INTO dig_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Muho wa Naili undaodzala magula hadi gedze mwako nyumbani, dzumba ra chifalume, hadi mwako chumbani, na gapande mwako chitandani. Gandainjira nyumbani mwa mawazirigo, na kpwa atuo osi, piya madzikoni na ndani ya mabakuli ga kukandira unga. ");
INSERT INTO dig_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Higo magula gandatina hadi mwako mwirini, mwa atuo na mawazirigo gosi.’ ” ");
INSERT INTO dig_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Mwenyezi Mlungu wamuamba Musa, “Muambire Aruni ahale ndataye aolohe madzi ga myuhoni, ga mitaruni, na ga madimbwini ili mtuluke magula na gagote tsi yosi ya Misiri!” ");
INSERT INTO dig_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Phahi Aruni wagolosa mkpwono achioloha madzi ga Misiri, na magula gachituluka hadi gachifwinika tsi kavu. ");
INSERT INTO dig_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Ela atsai a Misiri ahumira utsai wao kuhenda dza vivyo. Nao piya achihenda magula gagote tsi yosi. ");
INSERT INTO dig_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Farao waiha Musa na Aruni achiaambira, “Mvoyeni Mwenyezi Mlungu aniusire higa magula na aausire atu angu piya. Nami nindaaricha atue aphiye akamlavire sadaka.” ");
INSERT INTO dig_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Musa achimuambira Farao, “Niambira wakati ulondao nikuvoyereni ili magula gauke kpwako, kpwa mawazirigo na atuo. Nago magula gosi gandauka himu mwenu madzumbani, na gandasala ga muho wa Naili bahi.” ");
INSERT INTO dig_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Farao achimuamba Musa, “Nalonda uvoye muhondo.” Naye Musa achiamba, “Nindahenda utakavyo ili umanye kukala takuna mlungu wanjina dza Mwenyezi Mlungu, Mlungu wehu. ");
INSERT INTO dig_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Magula gosi gandauka kpwako na kpwenu madzumbani, gandauka kpwa mawazirigo na kpwa atuo, gandasala ga muho wa Naili bahi.” ");
INSERT INTO dig_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Phahi Musa na Aruni amricha Farao, Musa wamririra Mwenyezi Mlungu kuhusu go magula ambago kala akamrehera Farao. ");
INSERT INTO dig_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Mwenyezi Mlungu wahenda vivyo Musa arivyomvoya. Go magula gosi gachifwa mo madzumbani, mihalani na mindani. ");
INSERT INTO dig_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Atu agakusanya ndulu-ndulu, na tsi ndzima ichikala inanuka lovu. ");
INSERT INTO dig_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Ela Farao ariphoona takuna magula, wauya tsona kukala na moyo mufu, achirema maneno ga Musa na Aruni, dza Mwenyezi Mlungu arivyokala akagomba. ");
INSERT INTO dig_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Mwenyezi Mlungu wamuamba Musa, “Muambire Aruni, ‘Hala ndatayo upige photsi na vumbi rindatifuka.’ Na vumbi rosi rindagaluka tsaha tsi ndzima ya Misiri!” ");
INSERT INTO dig_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Phahi, Aruni wapiga photsi na ndataye ichitifula vumbi, na vumbi richigaluka tsaha nao achivamia atu na nyama Misiri ndzima. ");
INSERT INTO dig_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Atsai ahenda utsai wao, ela achishindwa kuhenda tsaha. Kpwa hivyo atu na nyama achikala a tele tsaha. ");
INSERT INTO dig_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Ndipho hinyo atsai achimuamba Farao, “Hino ni kazi ya Mlungu.” Ela moyo wa Farao uchizidi kukala mufu, wala kayakubali maneno ga Musa na Aruni, dza viratu Mwenyezi Mlungu arivyogomba. ");
INSERT INTO dig_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Halafu Mwenyezi Mlungu achimuamba Musa, “Muhondo lamuka ligundzu chiti ukakutane na Farao achikala anaphiya muhoni, umuambe kukala Mwenyezi Mlungu anaamba hivi: ‘Ariche atu angu auke, ili akaniabudu. ");
INSERT INTO dig_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Uchikala kundaricha atu angu auke, nindakurehera maindzi uwe, mawazirigo na atuo, na mwenu madzumbani. Nyumba za Amisiri zindaodzala maindzi na hata yo tsi indafwinikpwa ni maindzi. ");
INSERT INTO dig_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Ela siku iyo sindamwaga maindzi tsi ya Gosheni, kusagalako atu angu. Hiko Gosheni takundakala na maindzi, ili umanye kala mimi, ndimi Mwenyezi Mlungu na nina uwezo wa kuhenda rorosi nimendzaro phapha phenye tsiiyo. ");
INSERT INTO dig_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Nindaonyesa tafwauti ya atu angu na atuo. Ishara ihi indahendeka muhondo.’ ” ");
INSERT INTO dig_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Mwenyezi Mlungu wahenda dza arivyogomba. Maindzi gamwagika mabutsa-mabutsa dzumbani mwa Farao na nyumbani mwa atumishie. Tsi yosi ya Misiri ichibanangbwa ni maindzi. ");
INSERT INTO dig_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Halafu Farao achiiha Musa na Aruni, achiaamba, “Phiyani mkamlavire Mlungu wenu sadaka, mumu Misiri.” ");
INSERT INTO dig_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Ela Musa achiamba, “Iyo si sawa! Kpwa sababu Amisiri andatsukizwa ni sadaka ndizomlavira Mwenyezi Mlungu, Mlungu wehu. Dze, huchilavya sadaka phatu anaphouona, taandahupiga mawe? ");
INSERT INTO dig_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Ni lazima huuke charo cha siku tahu kuphiya jangbwani na hukamlavire sadaka Mwenyezi Mlungu, Mlungu wehu, dza arivyohulagiza.” ");
INSERT INTO dig_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Farao achiamba, “Nindakurichani mphiye jangbwani mkamlavire sadaka Mwenyezi Mlungu, Mlungu wenu, ela musiphiye kure. Sambi nivoyera.” ");
INSERT INTO dig_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Musa achiamba, “Vi sambi nchiuka hipha tu, nindavoya Mwenyezi Mlungu, na muhondo maindzi gandauka kpwako, kpwa mawazirigo na kpwa atuo osi. Ela Farao naasikale anahuchenga tsona, mwisho akahukahaza kuphiya kpwendamlavira sadaka Mwenyezi Mlungu.” ");
INSERT INTO dig_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Phahi Musa wauka hipho pha Farao na achendavoya Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Naye Mwenyezi Mlungu achihenda sawa na vyo arivyovoya Musa. Maindzi gauka kpwa Farao, kpwa mawazirige na kpwa atu osi, takusarire hata indzi mwenga. ");
INSERT INTO dig_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Ela phapho piya Farao wahenda moyo mufu na kayaaricha Aiziraeli auke. ");
INSERT INTO dig_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Phahi, Mwenyezi Mlungu wamuamba Musa, “Phiya kpwa Farao ukamuambe, ‘Mwenyezi Mlungu, Mlungu wa Aeburania anakuamba: Arichire atu angu auke ili akaniabudu. ");
INSERT INTO dig_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Mana uchirema kuarichira auke na kpwenderera kuazuwiya, ");
INSERT INTO dig_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Mwenyezi Mlungu andaitiya mifugo yenu makongo mai ko weruni, akale ni farasi, punda, ngamia, ngʼombe, mangʼondzi na mbuzi. ");
INSERT INTO dig_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Ela Mwenyezi Mlungu andatofwautisha mifugo ya Aiziraeli na ya Amisiri, ili nyama a Aiziraeli asedze akafwa, hata mmwenga.’ ” ");
INSERT INTO dig_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Na Mwenyezi Mlungu achipanga wakati achiamba, “Muhondo, Mwenyezi Mlungu andahenda gaga kpwenye yo tsi.” ");
INSERT INTO dig_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Kuriphocha, Mwenyezi Mlungu wahenda vyokala akagomba. Mifugo yosi ya Amisiri yafwa, ela takuna hata nyama mmwenga wa Aiziraeli ariyefwa. ");
INSERT INTO dig_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Farao wahuma atue akapeleleze na achikuta kala takuna hata nyama mmwenga wa Aiziraeli yefwa. Ela wakala na moyo mufu na achiakahaza Aiziraeli kuuka. ");
INSERT INTO dig_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Chisha Mwenyezi Mlungu achimuamba Musa na Aruni, “Chila mmwenga wenu naaheke fumba ra ivu kula pho chandani, na Musa akaritsuphe dzulu mbere za Farao. ");
INSERT INTO dig_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Ivu hiro rindakala vumbi dzembamba ndirogota tsi yosi ya Misiri, vumbi riri rindaarehera maphu atu na nyama kahi ya tsi yosi. Maphu gago gandahumbuka gakale vironda.” ");
INSERT INTO dig_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Ndipho Musa na Aruni achiheka ivu ra chandani na achendaima mbere za Farao. Musa achirihala, achiritsupha dzulu, phahi Amisiri na mifugo yao ahenda maphu na gachihumbuka gachikala vironda. ");
INSERT INTO dig_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Hata atsai nao aodzala maphu dza Amisiri ayawao. Kpwa sababu kala a tele maphu, ashindwa ni Musa na achikala taana ra kumuhenda. ");
INSERT INTO dig_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Ela Mwenyezi Mlungu wamtiya Farao moyo mufu na achirema kuphundza Musa na Aruni, dza vyo Mwenyezi Mlungu kala akamuambira Musa. ");
INSERT INTO dig_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Gariphohendeka gago, Mwenyezi Mlungu wamuamba Musa, “Muhondo rauka chiti ukakutane na Farao umuambe, Mwenyezi Mlungu, Mlungu wa Aeburania anaamba hivi: Aarichire atu angu auke, ili akaniabudu. ");
INSERT INTO dig_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Mana ichikala kumendze, phahi nindahuma mashaka makali ambago gandakutiya adabu uwe, mawazirigo na atuo osi, ili umanye kala takuna mwenye uwezo dza mimi duniani kosi. ");
INSERT INTO dig_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Kpwa mana kalapho náhumira uwezo wangu nkakupigani na makongo mai, mngekala mwafwa mosi, takuna hata mmwenga angesala himu duniani. ");
INSERT INTO dig_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Ela nkakuricha moyo makusudi nkuonyese uwezo wangu, na dzina rangu ritangazwe dunia ndzima. ");
INSERT INTO dig_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Ela bado wadzihenda una ngulu na kumendze kuricha atu angu auke. ");
INSERT INTO dig_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Kpwa hivyo, muhondo saa dza zizi nindareha mvula kali ya mawe, ambayo taidzangbwenya Misiri hangu iandze hata rero. ");
INSERT INTO dig_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","“ ‘Sambi lagiza ili mifugoyo iriyo kondze na chochosi chiricho kondze weruni chirehwe na kutiywa phatu pharipho salama. Mana mutu yeyesi au nyama yeyesi ambaye kandarehwa mudzini, andasala ko weruni, andapigbwa ni yo mvula kulu ya mawe hata afwe.’ ” ");
INSERT INTO dig_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Mawaziri ganjina ga Farao aogopha neno ra Mwenyezi Mlungu, ahenda wangbwi kuareha atumwa aho na mifugo yao. ");
INSERT INTO dig_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Ela anjina abera maneno ga Mwenyezi Mlungu na achiricha atumwa aho na mifugo yao kondze weruni. ");
INSERT INTO dig_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Chisha Mwenyezi Mlungu achimuamba Musa, “Golosa mkpwonoo kuelekeza mlunguni ili mvula ya mawe inye tsi yosi ya Misiri, ipige atu, nyama na mimea yosi ya mindani kahi ya tsi yosi ya Misiri.” ");
INSERT INTO dig_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Musa ariphogolosa ndataye kuelekeza mlunguni, Mwenyezi Mlungu wareha mvula ya mawe na chiguruguru, na limeme richipiga photsi. Phahi Mwenyezi Mlungu achireha mvula kulu ya mawe inye tsi ya Misiri yosi, ");
INSERT INTO dig_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","na limeme richikala vivyo kpwa vivyo. Kala ndiyo mvula ya mawe kulu zaidi ambayo taidzangbwenya wakati wowosi hangu Misiri ikale taifa. ");
INSERT INTO dig_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Iyo mvula ya mawe yavundza-vundza chila chitu chokala kpwereru kahi ya tsi yosi ya Misiri, si atu si nyama. Chisha ichivundza-vundza mimea yosi ya mindani na chila muhi. ");
INSERT INTO dig_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Phatu ambapho mvula ya mawe taiyafika ni Gosheni bahi ambako Aiziraeli kala anasagala. ");
INSERT INTO dig_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Phahi Farao walagiza Musa na Aruni aihwe na achedzaambira, “Charo hichi nkahenda dambi. Mwenyezi Mlungu ana haki ela mimi na atu angu huna makosa. ");
INSERT INTO dig_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Kpwa hivyo mvoyeni Mwenyezi Mlungu mana yo mvula ya mawe na cho chiguruguru chikatosha. Nindakurichani muuke na wala sindakuzuwiyani tsona.” ");
INSERT INTO dig_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Musa achimuamba, “Nchituluka kondze ya mudzi uhu, nindaunula mikono yangu, nimvoye Mwenyezi Mlungu, nacho chiguruguru chindaricha na yo mvula ya mawe taindakalako tsona, ili umanye kukala dunia ni ya Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Ela ninamanya kukala uwe na atumishio tamdzangbwemuogopha Mwenyezi Mlungu.” ");
INSERT INTO dig_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(Mimea ya katani na shayiri yabanangika, mana shayiri kala ikaphera na katani kala ikatuluza maruwa. ");
INSERT INTO dig_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Ela nganu na mimea yanjina yoigana nayo taibanangirwe, kpwa sababu wakatiwe wa kuphera kala taudzangbwe). ");
INSERT INTO dig_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Phahi Musa wamricha Farao na achituluka kondze ya mudzi, achendaunula mikonoye kpwa Mwenyezi Mlungu na cho chiguruguru na yo mvula ya mawe ichiricha kunya, na yo mvula tainyire tsona. ");
INSERT INTO dig_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Farao ariphoona kukala yo mvula ya mawe na chiguruguru chikaricha, wahenda dambi tsona. Iye phamwenga na atumishie aenderera kukala na mioyo mifu. ");
INSERT INTO dig_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Phahi Farao wahenda moyowe ukale mufu na achiakahaza Aiziraeli kuuka, dza Mwenyezi Mlungu arivyokala akagomba kutsupira Musa. ");
INSERT INTO dig_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Phahi Mwenyezi Mlungu achimuamba Musa, “Phiya kpwa Farao, sababu mino nkamuhenda akale na moyo mufu iye na atumishie ili niaonyese ishara za vilinje vyangu; ");
INSERT INTO dig_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","namwi piya muweze kuasemurira ana enu na adzukulu enu vira nrivyohenda vilinje na nrivyopambana na Amisiri chisiru, ili mmanye kala mimi, ndimi Mwenyezi Mlungu.” ");
INSERT INTO dig_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Phahi Musa na Aruni aphiya kpwa Farao achendamuamba, “Mwenyezi Mlungu, Mlungu wa Aeburania, anakuamba, ‘Kundagbwa maguluni mbere zangu hadi rini? Ariche atu angu auke ili akaniabudu. ");
INSERT INTO dig_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Uchiaremeza kuuka, rorera! Muhondo nindareha ndzije kpwenye tsiiyo. ");
INSERT INTO dig_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Andafwinika yo tsi hata ikale taionekana. Nao andarya chila chitu ambacho chasazwa ni mvula ya mawe, na hata iyo mihi imerayo mwenu mindani. ");
INSERT INTO dig_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Andaodzala mwako madzumbani na nyumbani mwa atumishio na za Amisiri osi. Andakala anji sana. Utu ambao sowe zenu au tsawe zenu taawuonere hangu asagale tsi ihi hadi rero.’ ” Musa ariphomala kugomba higo, wagaluka na achiuka hipho pha Farao. ");
INSERT INTO dig_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Halafu Mawazirige gamuamba Farao, “Mutu yuno andahuyuga na mashaka hata rini? Arichire atu hano auke, ili akamuabudu Mwenyezi Mlungu, Mlungu wao. Dze, kudzangbwemanya kala Misiri ikabanangbwa?” ");
INSERT INTO dig_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Phahi Musa na Aruni aihwa achiuya kpwa Farao, naye achiaambira, “Phiyani mkamuabudu Mwenyezi Mlungu, Mlungu wenu. Ela nalonda nimanye, anjina ni ano ani ambao andaphiya namwi?” ");
INSERT INTO dig_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Musa achiamba, “Hosi hundaphiya avyere kpwa adide. Hundahala ana ehu alume na achetu, phamwenga na mifugo yehu yosi, kpwa sababu ni lazima hukasherekee karamu kpwa kumuabudu Mwenyezi Mlungu.” ");
INSERT INTO dig_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Farao achiamba, “Naapa kpwa dzina ra Mwenyezi Mlungu sindakuruhusuni muuke na ana enu! Mana naona wazi kukala muna nia mbii. ");
INSERT INTO dig_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Hata! Taiwezekana! Aricheni alume machiyao aphiye kpwendamuabudu Mwenyezi Mlungu, mana hivyo ndivyo kala mlondavyo.” Chisha Musa na Aruni azolwa phara mbere za Farao. ");
INSERT INTO dig_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Mwenyezi Mlungu achimuambira Musa, “Unula mikonoyo dzulu ya tsi ya Misiri ili ndzije amwagikane tsi ndzima na arye chila chitu chimeracho, na chochosi chosazwa mo mindani ni yo mvula ya mawe.” ");
INSERT INTO dig_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Phahi Musa waunula ndataye dzulu ya yo tsi ya Misiri, na Mwenyezi Mlungu achireha phuto kula mlairo wa dzuwa, richipiga mutsi wosi na richichesa kupiga. Kuriphocha, rira phuto richikala rikareha ndzije. ");
INSERT INTO dig_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Amwagikana tsi yosi ya Misiri, achigbwa na achibwiningiza tsi yosi ya Misiri. Kala takudzangbweoneka maipho ga ndzije dza gago, na takundaoneka tsona ganjina dza gago. ");
INSERT INTO dig_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Afwinika tsi yosi hadi kuchikala kpwiru. Achirya mimea yosi na matunda gosi gosazwa ni yo mvula ya mawe. Taphana hata kodza rosala muhini, au kpwenye mimea kahi ya tsi yosi ya Misiri. ");
INSERT INTO dig_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Phahi Farao achilagiza Musa na Aruni aihwe na achedzaambira, “Nikamuhendera dambi Mwenyezi Mlungu, Mlungu wenu na hata mwimwi. ");
INSERT INTO dig_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Sambi nakuvoyani mniswamehe dambi zangu mara mwenga ihi tu, na mumvoye Mwenyezi Mlungu, Mlungu wenu aniusire shaka riri.” ");
INSERT INTO dig_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Phahi Musa wauka kpwa Farao achendamvoya Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Hipho Mwenyezi Mlungu wagaluza rira phuto richikala phuto kali sana, ra kula mtswerero wa dzuwa. Phuto hiro rakusanya ndzije na richiaphirika Bahari ya Shamu. Takuna hata ndzije mmwenga yesala tsi yosi ya Misiri. ");
INSERT INTO dig_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ela Mwenyezi Mlungu wamtiya Farao moyo mufu, na achirema kuarichira nyo Aiziraeli auke. ");
INSERT INTO dig_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Chisha Mwenyezi Mlungu achimuamba Musa, “Unula mikonoyo kulekeza dzulu mlunguni, ili kukale na jiza tsi yosi ya Misiri, chilungulungu cha jiza ambacho chindahenda atu akale ahenda phaphasa.” ");
INSERT INTO dig_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Phahi Musa waunula mikonoye kulekeza dzulu mlunguni, na Misiri ndzima ichifwinikpwa ni chilungulungu cha jiza kpwa muda wa siku tahu. ");
INSERT INTO dig_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Kuchikala takuna Mmisiri awezaye kumuona myawe wala kuuka aripho, kpwa muda wa siku tahu. Ela Aiziraeli osi achikala na mwanga kahi ya ko kpwatu arikokala anasagala. ");
INSERT INTO dig_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Farao ariphoona vivyo achimwiiha Musa, achimuamba, “Phiyani mkamuabudu Mwenyezi Mlungu. Phiyani mosi phamwenga na anache, ela mangʼondzi na mifugo yenu iricheni phapha.” ");
INSERT INTO dig_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Ela Musa achiamba, “Ni uhuriche hutsukule nyama a kumlavira sadaka na sadaka za kuochwa Mwenyezi Mlungu, Mlungu wehu. ");
INSERT INTO dig_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Ni lazima huuke na mifugo yehu, na tahundaricha hata kpwatsa. Nyama anjina hukahumire kumuabudira Mwenyezi Mlungu, Mlungu wehu. Ela hadi ndiphofika hiko tahumanya hundahumira nyama wani kumlavira sadaka.” ");
INSERT INTO dig_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Ela Mwenyezi Mlungu wamuhenda Farao akale na moyo mufu, na achirema kuricha Aiziraeli auke. ");
INSERT INTO dig_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Farao wamuamba Musa, “Phauke hipha! Sitaki kukuona tsona, mana siku ndiphokpwedzaona uso wangu, undafwa!” ");
INSERT INTO dig_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Musa achimjibu achiamba, “Ni sawa, kama uchivyogomba, kundaniona tsona.” ");
INSERT INTO dig_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Phahi Mwenyezi Mlungu wamuamba Musa, “Nindareha shaka mwenga ra mwisho kpwa Farao na tsiiye ya Misiri, badaye andakurichani muuke. Ndiphokurichani muuke, andakuzolani kamare. ");
INSERT INTO dig_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Sambi aambire Aiziraeli osi alume na achetu chila mmwenga ni lazima avoye jiraniwe wa Chimisiri vitu vya feza na vya zahabu.” ");
INSERT INTO dig_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Phahi Mwenyezi Mlungu waahenda Aiziraeli amendzwe ni Amisiri. Musa achikala anaishimiwa sana kuko tsi ya Misiri ni nyo mawaziri a Farao na atu osi. ");
INSERT INTO dig_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Phahi Musa achimuamba Farao, “Mwenyezi Mlungu, anaamba: Vivi rero usiku wa manane nindazunguluka tsi ya Misiri. ");
INSERT INTO dig_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Na ana avyere a chilume a Misiri andafwa, hangu mwana mvyere wa chilume wa mfalume atawalaye, hadi mwana mvyere wa chilume wa mtumwa wa chichetu, ambaye kaziye ni kusaga mtsere, phamwenga na nyo ana avyere osi a mifugo. ");
INSERT INTO dig_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Kundakala na chiriro chikulu tsi ndzima ya Misiri ambacho tachidzangbwesikirwa na wala tachindasikirwa tsona. ");
INSERT INTO dig_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Ela ko kpwa Aiziraeli, takundakala diya ndiropheka mutu wala nyama. Ndipho mundamanya kukala vyo Mwenyezi Mlungu ahenderavyo Amisiri sivyo ahenderavyo Aiziraeli. ");
INSERT INTO dig_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Higa mawazirigo gosi gandakpwedza kpwangu gedze ganigbwerere maguluni na ganiambe, ‘Phiya vyako, tsona hala atuo osi.’ Na bada ya vivyo, mino nindauka.” Phahi, Musa wauka phara pha Farao akareya sana. ");
INSERT INTO dig_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Mwenyezi Mlungu kala akamuamba Musa, “Farao andarema kukuphundza ili niphahe nafwasi ya kuhenda vilinje vyangu vienjerezeke kahi ya tsi ya Misiri.” ");
INSERT INTO dig_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Phahi Musa na Aruni ahenda vilinje vyosi hivyo mbere za Farao, ela Mwenyezi Mlungu kala akamtiya moyo mufu, na achirema kuarichira nyo Aiziraeli atuluke kahi ya tsiiye. ");
INSERT INTO dig_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Ariphokala Musa na Aruni bado achere ko Misiri, Mwenyezi Mlungu wagomba achiamba, ");
INSERT INTO dig_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Mwezi uhu undakala mwezi wa kpwandza kpwenu, yani mwezi wa kpwandza wa mwaka. ");
INSERT INTO dig_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Aambire atu osi a Iziraeli kukala ichifika siku ya kumi ya mwezi uhu, chila mlume andahala ngʼondzi ra kutosha atue. Yani ngʼondzi mwenga kpwa chila nyumba. ");
INSERT INTO dig_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Ichikala nyumba ina atu achache ambao taaweza kumala mwana ngʼondzi, nyo atu a nyumba iyo naagbwirane na ayawao ario phephi nao, kulengana na isabu ya atu na chiasi cha nyama awezacho kurya. ");
INSERT INTO dig_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Unaweza kutsambula ngʼondzi ama mbuzi, mlume wa mwaka mmwenga, ela ni lazima akale kana ila. ");
INSERT INTO dig_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Chila mmwenga wenu naamtundze hadi siku ya kumi na ne ya mwezi. Siku iyo Aiziraeli osi andatsindza nyo nyama dziloni. ");
INSERT INTO dig_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","“Chisha mundahala seemu ya yo milatso mupake mimo na vizingiti vya dzulu vya yo miryango ya nyumba ndimorya. ");
INSERT INTO dig_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Zo nyama ni ziochwe na ziriwe zosi usiku uho, na ni ziriwe na mikahe isiyotiywa hamira na mboga za utsungu. ");
INSERT INTO dig_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Chisha nyama zizo msizirye mbitsi wala za kujita, ela ni lazima ziochwe zosi phamwenga na chitswa, marondo na vya ndani. ");
INSERT INTO dig_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Msisaze nyama hadi ligundzu, ela ichisala bada ya kurya ni lazima iochwe iphye tsetsetse. ");
INSERT INTO dig_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Wakati munarya, mkale tayari kuuka. Vwalani virahu na mkale na ndata zenu mikononi, tsona muirye mairo-mairo. Mana ni Pasaka ya Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Usiku hinyo-hinyo nindazunguluka tsi yosi ya Misiri, niolage ana avyere osi a chilume a anadamu na a nyama. Nindaitiya adabu milungu yosi ya Misiri, mana mimi, ndimi Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Yo milatso ndiyopaka mimo na vizingiti vya miryango yenu ni ishara ya nyumba mundimokala. Nchiona iyo milatso, nyumba zenu ndazitsapika. Takuna shaka ndiroaphaha Aiziraeli wakati nchikala napiga tsi ya Misiri. ");
INSERT INTO dig_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Siku ihi mundakala muchiitambukira, na mundakala muchiisherekeya sikukuu ihi kpwa ajili ya Mwenyezi Mlungu. Mwimwi na vivyazi vyenu mundakala mchisherekeya siku ihi, hiri ni lagizo hata kare na kare.” ");
INSERT INTO dig_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","“Kpwa muda wa siku sabaa mundarya mikahe isiyotiywa hamira. Siku ya kpwandza ni muuse hamira mwenu madzumbani. Mutu yeyesi ndiyerya chitu chochosi chotiywa hamira kula yo siku ya kpwandza hadi yo siku ya sabaa, andatengbwa na Aiziraeli. ");
INSERT INTO dig_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Mundakusanyika siku ya kpwandza na ya sabaa muniabudu. Na kahi ya siku zizo msihende kazi yoyosi, isiphokala kujita chakurya chenu bahi. ");
INSERT INTO dig_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Mundakala mchisherekeya sikukuu ihi ya mikahe isiyotiywa hamira, ili muweze kutambukira kukala, iyo ndiyo siku niriyotuluza makundi genu kula tsi ya Misiri. Kpwa hivyo vivyazi vyenu vyosi ni lazima vitambukire siku ihi, na lagizo riri rindaenderera hata kare na kare. ");
INSERT INTO dig_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Mundarya mikahe isiyotiywa hamira kula siku ya kumi na ne dziloni hadi dziloni ya siku ya mirongo miiri na mwenga ya nyo mwezi wa kpwandza. ");
INSERT INTO dig_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Kpwa siku sabaa musiike hamira mwenu madzumbani, na mutu yeyesi ndiyerya chochosi chirichotiywa hamira, ni atengbwe na Aiziraeli, akale ni mjeni ama ni mvyalwa wa Iziraeli. ");
INSERT INTO dig_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Msirye chitu chochosi cha kutiywa hamira. Phophosi mndiphokala munaishi, msirye mikahe ya kutiywa hamira.” ");
INSERT INTO dig_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Ndipho Musa achiaiha atumia osi a Iziraeli na achiaambira, “Ni lazima chila mmwenga atsambule mwana ngʼondzi wa kutosha atue, atsindze ili asherekee Pasaka. ");
INSERT INTO dig_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Halani maphungo ga muhisopo, mugavwike ndani ya dzaya ra milatso na mupake chizingiti cha dzulu na mimo yosi miiri ya mryango. Ni lazima atu asale ndani ya nyumba, asituluke kondze usiku hadi ligundzu. ");
INSERT INTO dig_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Mwenyezi Mlungu andazunguluka tsi ndzima ili aolage Amisiri. Wakati achiona milatso dzulu ya chizingiti na mimo, kandamricha malaika aangamizaye ainjire mwenu madzumbani akuolageni. ");
INSERT INTO dig_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Malagizo gaga gagbwireni, mwimwi na vivyazi vyenu hata kare na kare. ");
INSERT INTO dig_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Mundiphofika kpwenye yo tsi ndiyohewa ni Mwenyezi Mlungu, dza arivyoahidi, lagizo riri rigbwireni. ");
INSERT INTO dig_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Na ana enu ndiphokuuzani, ‘Sheree hino manage nini?’ ");
INSERT INTO dig_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Mundaambira, ‘Ni sadaka ya Pasaka kpwa kumuabudu Mwenyezi Mlungu. Mana iye watsupa nyumba za Aiziraeli ko Misiri, na achihutivya wakati ariphoolaga Amisiri.’ ” O Aiziraeli azamisa vitswa achimuabudu. ");
INSERT INTO dig_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Phahi, Aiziraeli ahenda dza Mwenyezi Mlungu arivyolagiza Musa na Aruni. ");
INSERT INTO dig_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Phofika usiku wa manane Mwenyezi Mlungu waolaga ana avyere a chilume osi a Amisiri. Waolaga mwana mvyere wa Farao, ambaye kala achitawala, hadi mwana wa mateka yekala jela. Hata ana avyere a mifugo piya afwa. ");
INSERT INTO dig_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Farao, mawazirige na atu osi a Misiri alamuka usiku, na kuchikala kuna chiriro chikulu Misiri, mana chila nyumba kala ikafwewa. ");
INSERT INTO dig_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Farao ariphoona vivyo, walagizira Musa na Aruni achendaihwa nyo usiku achedzaamba, “Ukani! Tulukani himu Misiri, mwimwi na nyo Aiziraeli! Phiyani mkamuabudu Mwenyezi Mlungu, dza murivyogomba. ");
INSERT INTO dig_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Halani mangʼondzi genu, mbuzi na ngʼombe zenu muuke. Tsona nivoyerani Mlungu anijaliye.” ");
INSERT INTO dig_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Amisiri aahimiza Aiziraeli auke upesi mura tsi ya Misiri mana adziambira mwao mioyoni kukala, “Hano asiphouka swiswi hosi hundafwa.” ");
INSERT INTO dig_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Phahi, Aiziraeli ahala mabeseni gao gokala gana madonje ga nganu ambago tagadzangbwetsanganywa na hamira. Chisha achigafunga mabahasha na achigakuwa. ");
INSERT INTO dig_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Aiziraeli kala akahenda kare vira vyokala akalagizwa ni Musa, nao kala akavoya Amisiri vitu vya zahabu, vya feza na nguwo. ");
INSERT INTO dig_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Mwenyezi Mlungu kala akaahenda Amisiri aamendze Aiziraeli na kala akaapha chila chitu aricholonda. Vivyo ndivyo Aiziraeli arivyoafuta Amisiri utajiri wao. ");
INSERT INTO dig_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Aiziraeli auka na magulu kula mudzi wa Ramesesi hadi mudzi wa Sukothi. Alume machiyao kala ni kama elufu magana sita bila ya kuolanga achetu na anache. ");
INSERT INTO dig_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Na kundi kulu ra atu ambao kala sio Aiziraeli piya rauka phamwenga nao, phamwenga na vyaa vya ngʼombe, vya mangʼondzi na mbuzi na vyaa vya mifugo yanjina. ");
INSERT INTO dig_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Atengeza mikahe isiyotiywa hamira na gara madonje ga unga uriokala akaukanda ariphokala anatuluka Misiri. Unga uho kala tautiirwe hamira mana kala ahendazolwa ko Misiri, na taaphahire nafwasi ya kujita chakurya. ");
INSERT INTO dig_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Muda ambao O Aiziraeli kala akasagala Misiri kala ni miaka magana mane na mirongo mihahu. ");
INSERT INTO dig_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Pho mwisho wa yo miaka magana mane na mirongo mihahu, yo siku ya mwisho yenye, atu osi a Mwenyezi Mlungu atuluka kula tsi ya Misiri. ");
INSERT INTO dig_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Kpwa kukala Mwenyezi Mlungu wachesa usiku hinyo kutuluza Aiziraeli kula Misiri. Na usiku uho Aiziraeli osi anafwaha kuchesa ili kuika ishima kpwa Mwenyezi Mlungu. Kpwa hivyo usiku uho ni wa kutambukirwa ni Aiziraeli osi na vivyazi vyao. ");
INSERT INTO dig_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Badaye Mwenyezi Mlungu waamba Musa na Aruni, “Gaga ndigo malagizo ga Pasaka: Takuna mjeni yeyesi ndiyeruhusiwa kurya chakurya cha Pasaka. ");
INSERT INTO dig_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Ela mtumwao ambaye wamgula anaweza kurya uchikala wamtiya tsatsani. ");
INSERT INTO dig_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Ela mjeni ama mchibaruwa asirye chakurya hichi. ");
INSERT INTO dig_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Ni lazima iriwe ndani ya nyumba mwenga, msitsukule nyama yoyosi kondze, wala msivundze mfuphawe hata mmwenga. ");
INSERT INTO dig_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Aiziraeli osi ni asherekee sikukuu ihi. ");
INSERT INTO dig_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Mjeni yeyesi asagalaye namwi, achitaka kusherekeya Pasaka ya Mwenyezi Mlungu, ni lazima alume osi a mwakpwe nyumbani atiywe tsatsani. Ndipho andaweza kurya dza mvyalwa wa Iziraeli. Ela mutu ambaye katiirwe tsatsani kandarya Pasaka ya Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Hino ndiyo shariya ambayo ni lazima ilungbwe ni enyezi na mjeni asagalaye kahi yenu.” ");
INSERT INTO dig_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Phahi, Aiziraeli osi ahenda dza Mwenyezi Mlungu arivyolagiza Musa na Aruni. ");
INSERT INTO dig_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Na siku iyo-iyo Mwenyezi Mlungu waatuluza Aiziraeli kula tsi ya Misiri, madiba-madiba. ");
INSERT INTO dig_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Mwenyezi Mlungu wamuambira Musa, ");
INSERT INTO dig_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Nitengerani ana osi avyere a chilume a Aiziraeli na ana a kpwandza alume a mifugo yao. Mana aho osi ni angu.” ");
INSERT INTO dig_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Phahi Musa achiaambira nyo atu, “Itambukireni siku ihi, siku mriyotuluka Misiri. Siku mriyotuluka kula kahi ya tsi murikokala mu atumwa, mana Mwenyezi Mlungu wakutuluzani kula mumo kpwa kuhumira uwezowe. Msirye mikahe ya kutiywa hamira. ");
INSERT INTO dig_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Munatuluka Misiri siku ihi ya rero ya mwezi wa Abibu. ");
INSERT INTO dig_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Mwenyezi Mlungu ndiphokurehani kpwenye tsi ya Akanani, Ahiti, Aamori, Ahivi na Ajebusi, tsi ariyoapira akare enu kukala andakuphani, tsi yenye rutuba, mundakala muchiisherekeya kahi ya mwezi uhu. ");
INSERT INTO dig_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Kpwa siku sabaa, mundarya mikahe isiyotiywa hamira, na yo siku ya sabaa mundamuhendera Mwenyezi Mlungu sharee. ");
INSERT INTO dig_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Kahi ya zo siku sabaa, ni murye mikahe isiyotiywa hamira. Phasionekane mkpwahe wa kutiywa hamira kahi yenu na kahi ya seemu yenu yosi msagalayo. ");
INSERT INTO dig_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Siku iyo ya Sikukuu mutu andaambira anae, ‘Ninahenda sharee kpwa sababu ya go Mwenyezi Mlungu arigonihendera nriphokala natuluka kula tsi ya Misiri.’ ");
INSERT INTO dig_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Sharee ihi indakala dza alama phako mkpwononi, na utu wa kukutambukiza phako chilanguni, ili shariya ya Mwenyezi Mlungu ikale mwako kanwani. Mana Mwenyezi Mlungu wakutuluzani Misiri kpwa nguvu. ");
INSERT INTO dig_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Phahi gbwirani lagizo hiri chila mwaka kahi za wakatiwe uriopangbwa. ");
INSERT INTO dig_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Mwenyezi Mlungu ndiphokurehani kpwenye tsi ya Akanani, na kukuphani tsi iyo dza arivyoapira akare enu kukala andakuphani, ");
INSERT INTO dig_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","mundamtengera Mwenyezi Mlungu ana enu a kpwandza a chilume na ana a kpwandza alume a mifugo yenu. ");
INSERT INTO dig_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Chila punda wa mwandzo unaweza kumkombola na mwana ngʼondzi, au ichikala kundamkombola, msongole. Ela chila mwana mvyere wa chilume wa mwanadamu ni mumkombole. ");
INSERT INTO dig_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Siku zedzazo, ana enu achikuuzani, ‘Mana ya kuhenda vino nini?’ Hipho mundaajibu muambe, ‘Mwenyezi Mlungu wautuluza kula Misiri kpwa uwezowe mkpwulu, kula kahi ya tsi hurikokala atumwa. ");
INSERT INTO dig_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Farao ariphorema kuhurichira huuke kpwa moyo mufu, Mwenyezi Mlungu waolaga chila mwana wa kpwandza mlume wa mwanadamu, na wa nyama kahi ya tsi ya Misiri. Ndiyo mana hunamlavira Mwenyezi Mlungu ana a kpwandza osi a chilume a nyama na kukombola ana ehu a kpwandza.’ ");
INSERT INTO dig_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Lagizo riri rindakala dza alama mikononi mwehu, na utu wa kuhutambukiza vilanguni mwehu. Mana Mwenyezi Mlungu wahutuluza Misiri kpwa uwezo mkpwulu.” ");
INSERT INTO dig_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Farao ariphoaruhusu Aiziraeli auke, Mlungu kayaatsapiza na njira ya Filisti hata dzagbwe iyo kala ndiyo njira ya mkato. Mana Mlungu waamba, “Hinya atu achendakuta viha, anaweza kugalukpwa ni mioyo akauya Misiri.” ");
INSERT INTO dig_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Phahi Mlungu waalongoza na njira ya kuzunguluka ya kutsupira jangbwani, kuphiya uphande wa Bahari ya Shamu. Chisha Aiziraeli atuluka Misiri kuno akagbwiririra silaha tayari kpwa viha. ");
INSERT INTO dig_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Musa wahala mifupha ya Yusufu achiphiya nayo, kpwa kukala Yusufu kala akahenda Aiziraeli aape. Iye waamba, “Kpwa kpweli Mlungu andakutivyani, achikutivyani, halani mifupha yangu mphiye nayo.” ");
INSERT INTO dig_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Phahi Aiziraeli atuluka Sukothi na achendachita kambi mudzi wa Ethamu, ko kanda-kanda ya jangbwa. ");
INSERT INTO dig_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Mwenyezi Mlungu waatanguliya. Wakati wa mutsi waalongoza njirani kpwa kuhumira nguzo ya ingu, na wakati wa usiku wakala achialongoza na nguzo ya moho ili aphahe mwanga, kpwa hata aenderere na charo usiku na mutsi. ");
INSERT INTO dig_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Yo nguzo ya ingu ya wakati wa mutsi, na yo nguzo ya moho, taziukire mbere za Aiziraeli. ");
INSERT INTO dig_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Ndipho Mwenyezi Mlungu achimuamba Musa, ");
INSERT INTO dig_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Aambire Aiziraeli agaluke nyuma uphande wa Pi-Hahirothi, kahi-kahi ya Migidoli na Bahari ya Shamu, achite kambi mbere ya Baali-Sefoni, kanda-kanda ya bahari. ");
INSERT INTO dig_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Farao andafikiri, ‘Aiziraeli anazunguluka-zunguluka nao taamanya ahendaro mana jangbwa rikaazuwiya.’ ");
INSERT INTO dig_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Nindauhenda moyo wa Farao ukale mufu, na andakulungani-lungani. Na nkapanga hivi ili ushindi wangu kpwa Farao na jeshire unirehere nguma. Hipho atu a Misiri andamanya kukala mimi, ndimi Mwenyezi Mlungu.” Phahi Aiziraeli achihenda dza arivyolagizwa. ");
INSERT INTO dig_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Mfalume wa Misiri ariphoambirwa kukala Aiziraeli akachimbira, iye na atumishie agaluza nia na achiamba, “Hukahendani swino? Hukaaricha Aiziraeli kpwa hivyo taandahuhumikira tsona!” ");
INSERT INTO dig_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Kpwa hivyo Farao watayarisha garire ra kuvwehwa ni farasi na achiphiya na jeshire. ");
INSERT INTO dig_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Wahala magari ga kuvwehwa ni farasi magana sita garigo bora, phamwenga na magari ga kuvwehwa ni farasi ganjina ga Misiri yosi. Gachilongozwa ni akulu a viha. ");
INSERT INTO dig_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Mwenyezi Mlungu wauhenda moyo wa Farao, mfalume wa Misiri ukale mufu, hata achialunga Aiziraeli, ambao kala anaphiya vyao bila wuoga. ");
INSERT INTO dig_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Jeshi ra Amisiri, phamwenga na farasi osi a Farao, magari ga kuvwehwa ni farasi, na anajeshie akuhumira farasi, aalunga Aiziraeli hadi achifika phephi na phara ariphokala akachita kambi kanda-kanda ya Bahari ya Shamu phephi na Pi-Hahirothi mbere ya Baali-Sefoni. ");
INSERT INTO dig_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Phokala Farao na jeshire ariphofika phephi, Aiziraeli aaona Amisiri anaalunga, na hipho achigbwirwa ni wuoga, achimririra Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Aiziraeli amuamba Musa, “Kpwadze wahutuluza kula Misiri? Kpwani takuna mbira ko Misiri? Kpwadze waureha hiku jangbwani ili hufwe? ");
INSERT INTO dig_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Kura Misiri hwakuamba, ‘Huriche huahumikire atu a Misiri.’ Baha kuahumikira Amisiri kuriko kufwa mumu jangbwani!” ");
INSERT INTO dig_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Musa wajibu achiamba, “Msiogophe! Hurirani hu, namwi mundaona ambaro Mwenyezi Mlungu akaripanga kukutivyani vivi rero, Kpwa kukala aha Amisiri muaonao vivi rero, tamundaaona tsona. ");
INSERT INTO dig_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Mwimwi hurirani tu na Mwenyezi Mlungu andakupigirani viha.” ");
INSERT INTO dig_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Ndipho Mwenyezi Mlungu achimuamba Musa, “Kpwadze munaniririra? Aambire Aiziraeli aenderere na charo. ");
INSERT INTO dig_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Unula yo ndatayo na ugolose mkpwonoo dzulu ya yo bahari, iganye go madzi. Nao Aiziraeli andaweza kuvuka bahari kpwenye tsi kavu. ");
INSERT INTO dig_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Nindaahenda Amisiri akale na mioyo mifu hata ainjire mumo kukulungani. Hipho ndipho ndiphodziphahira nguma kpwa kushinda Farao, jeshire, magarige ga kuvwehwa ni farasi, na anajeshi akuhumira farasi. ");
INSERT INTO dig_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Nchishinda Farao na magarige ga kuvwehwa ni farasi na anajeshie akuhumira farasi, nindaphaha nguma matsoni pha Amisiri nao andamanya kukala mimi, ndimi Mwenyezi Mlungu.” ");
INSERT INTO dig_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Ndipho malaika wa Mlungu ambaye kala a mbere analongoza jeshi ra Aiziraeli wauya nyuma yao. Na yo nguzo ya ingu nayo yauka kula mbere ichiuya nyuma, ");
INSERT INTO dig_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","ichikala kahi-kahi ya jeshi ra Misiri na ra Iziraeli. Usiku wosi rira ingu rareha jiza kpwa Amisiri na mwanga kpwa Aiziraeli, kpwa hivyo Amisiri taayaweza kuafikira phephi. ");
INSERT INTO dig_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Ndipho Musa wagolosa mkpwonowe dzulu ya bahari, na usiku wosi Mwenyezi Mlungu wareha phuto kali kula mlairo wa dzuwa. Phuto hiro rahendesa madzi ga bahari gaganyike hiku na hiku, na pho kahi-kahi phachikala tsi kavu. ");
INSERT INTO dig_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Aiziraeli achivuka na pho kahi-kahi ya bahari phokala phakagaluka tsi kavu, na madzi gahendwa kuta uphande wa kulume na uphande wa kumotso. ");
INSERT INTO dig_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Ariphoona vivyo, nyo Amisiri aalunga-lunga nyo Aiziraeli na pho kahi-kahi ya bahari, phamwenga na farasi a Farao, magarige ga kuvwehwa ni farasi na aphirikie. ");
INSERT INTO dig_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Kuriphofika pepho za kucha, Mwenyezi Mlungu walola jeshi ra Amisiri kula kahi-kahi ya iratu nguzo ya moho na ya ingu naye achiatiya wuoga jeshi ra Amisiri. ");
INSERT INTO dig_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Wahendesa magurudumo ga magari gao ga kuvwehwa ni farasi gagame, ichiahendesa aphiye kpwa shida sana. Amisiri achiamba, “Nahuchimbireni mana Mwenyezi Mlungu anaahehera nyo Aiziraeli chinyume cha Amisiri.” ");
INSERT INTO dig_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Hipho Mwenyezi Mlungu wamuamba Musa, “Golosa mkpwonoo dzulu ya bahari ili madzi gauyirane, gaahose nyo Amisiri phamwenga na farasi aho na magari gao ga kuvwehwa ni farasi na aphirikie.” ");
INSERT INTO dig_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Phahi Musa wagolosa mkpwonowe dzulu ya bahari, na kuriphocha bahari yauyirana dza hipho mwandzo. Amisiri ajeza kutuluka mo madzini kpwa achimbire, ela Mwenyezi Mlungu achiasukuma, achiauyiza pho kahi-kahi ya bahari. ");
INSERT INTO dig_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Madzi gauyirana na gachibwiningiza magari ga kuvwehwa ni farasi, aphirikie na jeshi rosi ra Farao rokala rinalunga Aiziraeli himo baharini. Taphana hata Mmisiri mmwenga yesala. ");
INSERT INTO dig_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Ela Aiziraeli anyendeka tsi kavu kahi-kahi ya bahari ambapho madzi kala gakahendwa kuta uphande wa kulume na uphande wa kumotso. ");
INSERT INTO dig_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Siku iyo Mwenyezi Mlungu wativya atu a Iziraeli kula kpwa Amisiri, na Aiziraeli achiona nyufu za Amisiri mo kanda-kanda ya bahari. ");
INSERT INTO dig_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Aiziraeli aona hendo hiro ra ajabu arirohenderwa Amisiri. Phahi achimuogopha Mwenyezi Mlungu na achimuamini phamwenga na mtumishiwe Musa. ");
INSERT INTO dig_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Phahi Musa na Aiziraeli amuimbira Mlungu wira hinyu: “Nindamuimbira Mwenyezi Mlungu mana vyo chivyoshinda iye vina nguma. Akahosa farasi na apandadzi-farasi aho baharini. ");
INSERT INTO dig_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Mwenyezi Mlungu ndiye mkpwotse na nguvu yangu iye ndiye achiyenitivya. Iye ni Mlungu wangu, nami ndamtogola kpwa mawira. Iye ni Mlungu wa akare angu, nami nindaimba kumtogola. ");
INSERT INTO dig_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Mwenyezi Mlungu ni sujaa wa viha, na dzinare ndiye Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Magari ga kuvwehwa ni farasi ga Farao na anajeshie akaahosa baharini. Akulu a jeshi a kumanyikana vihani akafwa madzi Bahari ya Shamu. ");
INSERT INTO dig_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Vivwa vya madzi vyaabwiningiza, azama tsini ya bahari dza mawe. ");
INSERT INTO dig_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Mkpwonoo wa kulume uwe Mwenyezi Mlungu una nguvu za nguma. Mkpwonoo wa kulume nkuvundza-vundza adui vipande-vipande. ");
INSERT INTO dig_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Kpwa ukuluo wa nguma ukuangamiza akupingao, uwe uchitsukirwa u dza moho uochao, na ni kuocha maaduigo dza nyasi mbifu. ");
INSERT INTO dig_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Wakuta pulayo, nago madzi gachidzipanga dzulu gachiima wima dza kuta. Vivwa vya madzi ga bahari vichiganda. ");
INSERT INTO dig_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Adui wadzikarya achiamba, ‘Nindaalunga-lunga na nindaagbwira, ndaafuta vitu vyao niviganye zewe na niahende nilondavyo; nindatsomola upanga wangu na mkpwono wangu undaangamiza.’ ");
INSERT INTO dig_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Ela wareha phutoro naro richipiga, nago madzi ga bahari gachiabwiningiza, aho azama vilindi vya bahari dza chuma chiziho cha risasi chizamavyo kpwenye madzi manji. ");
INSERT INTO dig_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Kahi za milungu, ni mlungu yuphi ariye dza uwe, Mwenyezi Mlungu? Utakatifuo tauwezekana, mahendogo ga nguma ganahutishira, mambo makulu uhendago uwe, ganahuangalaza. ");
INSERT INTO dig_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Wahumira nguvuzo na tsi ichimiza maadui gehu. ");
INSERT INTO dig_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Kpwa mendzwayo isiyosika undalongoza nyo atu urioakombola. Undaalongoza kpwa nguvuzo kuphiya kpwenye makalogo matakatifu. ");
INSERT INTO dig_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Mataifa gakasikira na ganakakama kpwa wuoga; atu asagalao Filisti akainjira wuoga. ");
INSERT INTO dig_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Akulu a Edomu akaogofyerwa. Vilongozi a Moabu akagbwirwa ni wuoga mkpwulu; atu osi asagalao Kanani akavundzika moyo. ");
INSERT INTO dig_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Ao akagbwirwa ni wuoga na wasiwasi. Kpwa sababu ya ukulu wa nguvuzo anyemere zii dza dziwe, hadi atuo urioakombola atsupe, ee Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Undaareha wedze uaike dzulu ya mwangoo mwenye, phatu ambapho uwe waphatsambula phakale makalogo, phatu phatakatifu ambapho waphadzenga kpwa mikonoyo, uriphophatenga kpwa kukuabudu, uwe Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Nawe Mwenyezi Mlungu utawale hata kare na kare!” ");
INSERT INTO dig_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Aiziraeli avyoga tsi kavu pho kahi-kahi ya bahari hata achivuka. Ela farasi a Farao, magarige ga kuvwehwa ni farasi na aphirikie, ariphokala kahi-kahi ya bahari, Mwenyezi Mlungu wauyiza madzi ga bahari gachiabwiningiza. ");
INSERT INTO dig_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Phahi Miriamu, nabii wa chichetu, ndugungbwa wa Aruni wagbwira tamburini mwakpwe mkpwononi, na achetu anjina osi achihala tamburini zao achimlunga kuno anazipiga na kuvwina. ");
INSERT INTO dig_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Na Miriamu achiaimbira wira uambao, “Muimbireni Mwenyezi Mlungu, sababu akashinda kpwa nguma, Amisiri na farasi aho akaahosa baharini.” ");
INSERT INTO dig_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Ariphouka Bahari ya Shamu, Musa waalongoza Aiziraeli hadi achiinjira jangbwa ra Shuri. Asafiri siku tahu ko jangbwani, bila kuona madzi. ");
INSERT INTO dig_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Aphiya hadi achifika phatu phoihwa Mara, ambako aona madzi, ela gakala ga utsungu, kpwa hivyo taayaweza kuganwa. (Hicho ndicho chisa cha phatu hipho phaihwa Mara, manage Chieburania ni utsungu.) ");
INSERT INTO dig_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Aiziraeli amnungʼunikira Musa na achimuuza, “Vino hundanwani?” ");
INSERT INTO dig_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Musa wamvoya Mwenyezi Mlungu kpwa moyowe wosi, naye achimuonyesa Musa chipande cha muhi, ambacho wachitabwisa ndani ya madzi, nago gachikala manono kunwa. Hipho Mara, Mwenyezi Mlungu waapha Aiziraeli amuri na malagizo. Achiapima, ");
INSERT INTO dig_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","achiamba, “Mchiphundza sauti yangu kpwa makini na kuhenda garigo sawa, na mchiphundza amuri na kulunga malagizo gangu, sindakureherani makongo dza nrigoarehera Amisiri. Mana mimi, ndimi Mwenyezi Mlungu, Mlungu wenu, ambaye nkukuphozani.” ");
INSERT INTO dig_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Bada ya kuuka Mara, Aiziraeli afika Elimu, ambako kala kuna vidzuho kumi na viiri na mitende mirongo sabaa na achichita kambi phephi na go madzi. ");
INSERT INTO dig_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Aiziraeli osi auka Elimu, na siku ya kumi na tsano ya mwezi wa phiri bada ya kutuluka Misiri, afika jangbwa ra Sini, ambaro ri kahi-kahi ya Elimu na Sinai. ");
INSERT INTO dig_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Hiko jangbwani Aiziraeli osi amnungʼunikira Musa na Aruni ");
INSERT INTO dig_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","nyo Aiziraeli achiaambira, “Baha kala Mwenyezi Mlungu wahuolaga ko Misiri. Kuko kala hunaweza hukarya nyama na chakurya chinji hutakavyo. Ela mwahureha hiku jangbwani muuhirise na ndzala.” ");
INSERT INTO dig_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Ndipho Mwenyezi Mlungu achimuamba Musa, “Nindakutsopozerani chakurya kula mlunguni dza mvula. Ni lazima atu atuluke chila siku akahale chakurya cha kutosha siku iyo. Hivyo nindakala naapima ili nimanye ichikala andalunga malagizo gangu. ");
INSERT INTO dig_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ela chila siku ya sita, atu atsole chakurya cha kutosha siku mbiri, na achitayarishe.” ");
INSERT INTO dig_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Phahi Musa na Aruni aambira Aiziraeli osi, “Rero dziloni mundamanya kala Mwenyezi Mlungu ndiye ariyekutuluzani kula Misiri. ");
INSERT INTO dig_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Ligundzu mundaona mwanga wa Mwenyezi Mlungu, kpwa sababu akasikira chiriro chenu mrichomririra. Msihuririre swiswi, mana naswi si chochosi mbere za Mlungu.” ");
INSERT INTO dig_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Tsona Musa achiamba, “Dziloni Mwenyezi Mlungu andakuphani nyama, na ligundzu andakuphani chakurya chanjina murye mvune. Mlungu wasikira chiriro mrichomririra. Kpwa sababu swino si chochosi, mwimwi kala tamnungʼunikira swiswi, ela kala munamnungʼunikira Mwenyezi Mlungu.” ");
INSERT INTO dig_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Ndipho Musa achimuambira Aruni, “Aambire Aiziraeli osi edze aime mbere za Mwenyezi Mlungu, mana akasikira chiriro chao.” ");
INSERT INTO dig_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Aruni ariphokala anagomba na Aiziraeli, osi agaluka uphande wa jangbwani, na achiona mwanga wa Mwenyezi Mlungu ukatsembuka inguni. ");
INSERT INTO dig_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Mwenyezi Mlungu achigomba na Musa achimuamba, ");
INSERT INTO dig_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Nikasikira manungʼuniko ga Aiziraeli, kpwa hivyo aambire kukala dziloni andarya nyama na ligundzu andarya chakurya hata amvune. Ndipho andamanya kukala mimi, ndimi Mwenyezi Mlungu, Mlungu wao.” ");
INSERT INTO dig_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Dziloni riro, makpware gakpwedza kpwa unji gachibwiningiza kambi yosi, na ligundzure kuchikala na manena kuzunguluka kambi. ");
INSERT INTO dig_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Manena higo gariphouka pho photsi phasala utu wembamba urioonekana dza vipande vya barafu. ");
INSERT INTO dig_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Aiziraeli ariphouona auzana, “Ura ni utu wani?” Sababu kala taamanya nini. Musa achiaambira, “Hichi ni chakurya ambacho Mwenyezi Mlungu akakuphani murye. ");
INSERT INTO dig_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Mwenyezi Mlungu akalagiza muhende hivi, ‘Chila mutu naakatsole chakurya cha kutosha nyumbaye. Naatsole pishi mwenga ya chakurya kpwa chila mutu ariye mwakpwe hemani.’ ” ");
INSERT INTO dig_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Aiziraeli ahenda dza arivyoambirwa. Anjina atsola chinji na anjina achitsola chichache. ");
INSERT INTO dig_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Yuya ariyekusanya vinji, kayakala na masaza, na yuya ariyekusanya vichache, kayaphungukirwa. Chila mutu watsola chiasi cha kumkola, kpwa sababu wachipima na pishi. ");
INSERT INTO dig_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Ndipho Musa achiaambira, “Takuna mutu yeyesi ndiyeruhusiwa kuika chakurya hadi ligundzu.” ");
INSERT INTO dig_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Ela anjina taayaphundza malagizo ga Musa. Asaza chakurya hadi ligundzu, ela iriphofika ligundzu chichikala chikavunda na china mabulu. Musa ariphogamanya watsukirwa sana. ");
INSERT INTO dig_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Chila mutu ligundzu-ligundzu kala achiphiya achatsola chakurya chiasi alondacho. Dzuwa ririphokala kali, chakurya ambacho kala tachitsorerwe, chabubudzika. ");
INSERT INTO dig_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Siku ya sita Aiziraeli atsola-tsola kano mbiri zaidi, atsola pishi mbiri kpwa chila mutu. Vilongozi a Aiziraeli akpwendasema na Musa, ");
INSERT INTO dig_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","naye achiaambira, “Mwenyezi Mlungu walagiza hivi, ‘Muhondo ni Siku ya Kuoya, siku takatifu ya Mlungu. Phahi, rero ochani mlondacho kuocha na mjite mlondacho kujita. Chochosi ndichosala, chiikeni hadi muhondo.’ ” ");
INSERT INTO dig_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Phahi, aika chakurya chosala hadi siku ya phiri, viratu Musa arivyolagiza, tachiyavunda wala kuhenda mabulu. ");
INSERT INTO dig_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Musa achiamba, “Ryani chakurya chosala, kpwa sababu rero ni Siku ya Kuoya, yotengbwa ya Mwenyezi Mlungu, na tamundaphiya mchaona chakurya hiko jangbwani rero. ");
INSERT INTO dig_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Ni lazima mtsole chakurya siku sita, ela siku ya sabaa ni Siku ya Kuoya, na takundakala na chakurya.” ");
INSERT INTO dig_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Siku ya sabaa atu anjina aphiya vivyo kpwendalola chakurya, ela taayaona chitu. ");
INSERT INTO dig_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Ndipho Mwenyezi Mlungu achimuamba Musa, “Hadi rini tamundalunga amuri na malagizo gangu? ");
INSERT INTO dig_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Kalani mchimanya Mwenyezi Mlungu wakuphani Siku ya Kuoya. Ndiyo mana siku ya sita nkukuphani chakurya cha siku mbiri. Chila mmwenga ni ahurire phakpwe kaya siku ya sabaa; mutu naasiuke phakpwe kaya siku ya sabaa.” ");
INSERT INTO dig_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Kpwa hivyo Aiziraeli aoya siku ya sabaa. ");
INSERT INTO dig_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Chira chakurya Aiziraeli achiiha “Manna,” ambacho kala ni chereru dza mbeyu ya muhama mwereru na mtswanowe kala ni dza vipande vya mkpwahe uriotiywa asali. ");
INSERT INTO dig_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Musa achigomba na Aiziraeli achiamba, “Mwenyezi Mlungu akalagiza kukala huike pishi mwenga ya mana huyiikire vivyazi vyedzavyo, ili edze aone chakurya hurichohewa ni Mlungu hiko jangbwani hipho ariphohutuluza kula Misiri.” ");
INSERT INTO dig_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Phahi, Musa wamuamba Aruni, “Hala nyungu na utiye pishi mwenga ya manna, na uyiike mbere za Mwenyezi Mlungu ikale kumbukumbu kpwa vivyazi vyedzavyo.” ");
INSERT INTO dig_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Phahi, Aruni wahala manna achiyiika, dza Mwenyezi Mlungu arivyomlagiza Musa. Badaye achiitiya ndani ya Sanduku ra Ushaidi, ili ikale indaikpwato. ");
INSERT INTO dig_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Aiziraeli arya manna kpwa miaka mirongo mine, hadi achifika tsi yohenda makalo. Arya manna hadi ariphofika miphaka ya Kanani, ambako akpwendahenda makalo. ");
INSERT INTO dig_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Chipimo chiihwacho efa ni sawa na pishi kumi.) ");
INSERT INTO dig_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Aiziraeli osi auka kula jangbwa ra Sini, achinyendeka kula phatu phamwenga hadi phanjina dza Mwenyezi Mlungu arivyolagiza. Achita kambi Refidimu, ela kala taphana madzi ga kunwa. ");
INSERT INTO dig_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Kpwa hivyo atu amugombera Musa achimuamba, “Huphe madzi ga kunwa hunafwa na chiru.” Musa achiamba, “Kpwa utu wani munanidemurira mimi? Mbona munamjeza Mwenyezi Mlungu?” ");
INSERT INTO dig_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Ela Aiziraeli akala na chiru kuko, na achinungʼunikira Musa. Amuamba, “Kpwadze wahutuluza Misiri phamwenga na ana ehu na mifugo yehu ili wedze huolage na chiru?” ");
INSERT INTO dig_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Ndipho Musa achimririra Mwenyezi Mlungu achiamba, “Atu hano mino nindaahendadze? Mana phapho achiphofika taakure na kunipiga mawe.” ");
INSERT INTO dig_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Mwenyezi Mlungu wamjibu Musa achimuamba, “Tsupa mbere za atu osi, uphiye phamwenga na atumia anjina a Iziraeli chisha tsukula mwako mkpwononi ndatayo uriyoihumira kupigira madzi ga muho wa Naili. ");
INSERT INTO dig_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Nindaima mbere zenu kpwenye mbarara hiko mwango wa Horebu. Nawe piga iyo mbarara na madzi gandatuluka ili atu anwe.” Phahi, Musa wahenda hivyo mbere za atumia a Iziraeli. ");
INSERT INTO dig_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Phatu hipho phatungbwa dzina phachiihwa Masa na Meriba, sababu Aiziraeli anungʼunika na achimjeza Mwenyezi Mlungu ariphouza, “Ela kpweli ye Mwenyezi Mlungu a phamwenga naswi?” ");
INSERT INTO dig_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Wakati uho, kpwakpwedza atu aihwao Aamaleki achedzapigana na Aiziraeli pho Refidimu. ");
INSERT INTO dig_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Musa achimuamba Joshuwa, “Tsambula alume kahi-kahi yehu akapigane viha na Aamaleki. Nami muhondo nindaima dzulu ya chirere cha mwango, kuno nkagbwira hira ndata ya kuhendera vilinje vya Mlungu mwangu mkpwononi.” ");
INSERT INTO dig_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Kpwa hivyo Joshuwa wahenda dza Musa arivyomlagiza na achipigana na Aamaleki. Musa, Aruni na Huri achikpwera dzulu ya hura mwango. ");
INSERT INTO dig_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Ichikala wakati wosi Musa ariphounula mkpwonowe dzulu, Aiziraeli kala anaturya na ariphoutsereza Aamaleki kala anaturya. ");
INSERT INTO dig_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Ela mikono ya Musa yaremwa. Hipho Aruni na Huri amsengezera dziwe naye achirisagarira. Nao achiima hiku na hiku achimgbwira mikonoye na achiyiunula hadi dzuwa richitswa. ");
INSERT INTO dig_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Kpwa njira iyo Joshuwa waashinda Aamaleki osi tsetsetse. ");
INSERT INTO dig_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Chisha Mwenyezi Mlungu achimuamba Musa, “Dzambo hiri chirohendeka rero riandike chitabuni, ili rikale kumbukumbu kpwa atu. Tsona hakikisha Joshuwa akasikira kukala nindaangamiza Aamaleki duniani hata ayalwe tsetsetse.” ");
INSERT INTO dig_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Musa wadzenga phatu pha kulavira sadaka achiphaiha, “Mwenyezi Mlungu ndiye bendera yangu.” ");
INSERT INTO dig_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Musa achiamba, “Iunuleni dzulu yo bendera ya Mwenyezi Mlungu. Mwenyezi Mlungu andaenderera kupigana na Aamaleki chivyazi hadi chivyazi.” ");
INSERT INTO dig_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","4","Kabila ya kuuya Misiri kutsamiza Aiziraeli, Musa kala asegere hiko Midiani phamwenga na mtsedzawe Jethiro, ariyekala mlavyadzi-sadaka wa Midiani. Wakati hinyo Musa waphaha ana airi a chilume na mchewe Zipora. Mwana mmwenga, achimuiha Gerishomu, mana waamba, “Nákala mjeni tsi ambayo siyo yehu.” Yuya wanjina achimuiha Eliezeri, sababu ariphomphaha Musa waamba, “Mlungu wa baba wakala mteryadzi wangu, waniokola na upanga wa Farao.” Musa ariphouya Misiri kpwendagomba na Farao, kala akamuuyiza Zipora na anae akaishi na mtsedzawe Jethiro. Ela sambi Jethiro kala akasikira gohendwa ni Mwenyezi Mlungu kpwa kuterya Musa na atu a Iziraeli ariphotuluzwa kula Misiri. ");
INSERT INTO dig_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Phahi Jethiro, phamwenga na anangbwa a Musa na nine yao, akpwedza kpwa Musa kuko jangbwani, ambako kala akachita kambi phephi na mwango wa Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Musa ariphoambwa kukala mtsedzawe phamwenga na mchewe na anae airi aredza, ");
INSERT INTO dig_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Musa wakpwendamchinjira mtsedzawe, achimzamira kumupha ishima na achilamusana vinono. Achiuzana hali na badaye achimenya hemani. ");
INSERT INTO dig_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Ndipho Musa achimsemurira mtsedzawe kuhusu chila chitu Mlungu arichomuhendera Farao na Amisiri kpwa ajili ya Aiziraeli. Chisha achimsemurira kuhusu tabu zoaphaha njirani na vira Mwenyezi Mlungu arivyoativya. ");
INSERT INTO dig_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Jethiro wahererwa sana ariphosikira mambo gosi manono ambago Mwenyezi Mlungu waahendera Aiziraeli kpwa kuativya kula mikononi mwa Amisiri. ");
INSERT INTO dig_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Naye Jethiro achiamba, “Naatogolwe Mwenyezi Mlungu yekutivya kula mikononi mwa Amisiri na mikononi mwa Farao, chisha achiativya atu kula mikononi mwa Amisiri. ");
INSERT INTO dig_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Vivi sambi ninamanya kukala Mwenyezi Mlungu ni mkpwulu kuriko milungu yosi yanjina. Waonyesa higa kpwa kuativya Aiziraeli na mateso ga Amisiri, ambao kala akaabera.” ");
INSERT INTO dig_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Chisha Jethiro, mtsedza wa Musa wamlavira Mlungu sadaka ya kuochwa na sadaka zanjina. Aruni na atumia a Iziraeli akpwedzarya mikahe phamwenga naye mbere za Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Kuriphocha, Musa kama kawaidaye wasagala kuamula kesi za atu. Atu kala achimzunguluka kumgodzera hangu ligundzu hadi dziloni. ");
INSERT INTO dig_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Jethiro ariphoona chila chitu ambacho Musa kala anahendera atu, wauza, “Ni mambo gaphi gano uhenderago atu? Kpwadze unasagala na atu anakuzunguluka kula ligundzu hadi dziloni?” ");
INSERT INTO dig_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Musa wamjibu achimuamba, “Nkuhenda hivi kpwa sababu atu nkpwedza kpwangu ili aphahe kumanya Mlungu alondavyo. ");
INSERT INTO dig_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Wakati achikosana nkpwedza kpwangu, nami nkulavya uamuli wa mutu na myawe, na nkuafundza malagizo na shariya za Mlungu.” ");
INSERT INTO dig_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Jethiro wamjibu Musa achimuamba, “Higo uhendago ni manono ela tagahendwa hivyo. ");
INSERT INTO dig_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Uwe na hinya atu akulungao mundadziremweza, mana kazi hino ni ngumu kundaiturya macheyo. ");
INSERT INTO dig_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Sambi niphundza nikuphe ushauri wangu, naye Mlungu naakale phamwenga nawe. Uwe undakala mgombadzi wa atu hinya mbere za Mlungu, na undareha matatizo gao kpwa Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Ni lazima uafundze amuri na malagizo ga Mlungu, na uaambire vyo alondwavyo kusagala na kuhenda. ");
INSERT INTO dig_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Ela tsambula atu ambao ana uwezo wa kulongoza ayawao kahi ya aha atu, atu amuogophao Mlungu, atu aaminifu asiolonda kuhongbwa, atu dza hinyo aike akale vilongozi a makundi ga atu elufu-elufu, ga atu gana-gana, ga atu mirongo mitsano-mitsano na ga atu kumi-kumi. ");
INSERT INTO dig_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Hinyo ndio ndiokala aamuli kukata kesi za atu chila wakati, naakurehere kesi ngumu, ela kesi ndide-ndide naazimale enye. Kpwa njira hino andaweza kukuterya kaziyo. ");
INSERT INTO dig_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Uchihenda hivyo na ikale ndivyo Mlungu alondavyo, kundadziremweza na atu osi andaweza kuuya madzumbani na amani.” ");
INSERT INTO dig_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Musa waphundza arigoambirwa ni mtsedzawe na achilunga dza arivyoshauriwa ni mtsedzawe. ");
INSERT INTO dig_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Musa watsambula atu ario na uwezo kula kpwa Aiziraeli osi, na achiahenda akulu a makundi ga atu elufu-elufu, ga atu gana-gana, ga atu mirongo mitsano-mitsano na ga atu kumi-kumi. ");
INSERT INTO dig_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Nao ahenda kazi iyo ya kuamula wakati wosi. Malau makulu agarehera Musa ela madide agaamula enye. ");
INSERT INTO dig_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Badaye Musa walagana na mtsedzawe, na phapho Jethiro achiuya kpwao Midiani. ");
INSERT INTO dig_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Aiziraeli ariphovundza kambi yao Refidimu, anyendeka hata achiinjira jangbwa ra Sinai, na achichita kambi mbere ya nyo mwango Sinai. Phapho afika siku ya kpwandza ya mwezi wa hahu, hangu ariphotuluka tsi ya Misiri. ");
INSERT INTO dig_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Phahi Musa wakpwera dzulu ya mwango kpwendakutana na Mlungu. Mwenyezi Mlungu achimuiha kula ko mwangoni, achimuamba, “Phiya ukaambire uvyazi wa Jakobo, hinyo Aiziraeli, hivi: ");
INSERT INTO dig_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Mwimwi mwaona nrivyoahendera Amisiri, na vira vyokutsukulani dza kozi ritsukulavyo anae wakati rinauruka, na nchikurehani hiku kpwangu. ");
INSERT INTO dig_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Sambi muchiniogopha chikamilifu na kugbwira chilagane changu, mundakala hazina yangu ya samani kahi ya mataifa gosi. Dzagbwe dunia yosi hino ni yangu, ");
INSERT INTO dig_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","ela mwimwi kpwangu mundakala ufalume wa alavyadzi-sadaka, taifa takatifu.’ Haya kaabaze maneno higa nyo Aiziraeli.” ");
INSERT INTO dig_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Phahi Musa watserera kula mwangoni na achendakusanya phamwenga vilongozi a Aiziraeli na achiaambira chila chitu dza arivyolagizwa ni Mwenyezi Mlungu edze aambire. ");
INSERT INTO dig_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Ndipho atu osi achijibu, chivyamwenga achiamba, “Hundahenda chila chitu ambacho Mwenyezi Mlungu akahulagiza.” Naye Musa achendasema kpwa Mwenyezi Mlungu vyokala atu akagomba. ");
INSERT INTO dig_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Mlungu achimuamba Musa, “Nindakpwedza kpwenu ndani ya ingu ziho, ili anisikire nigombago nawe na akukuluphire siku zosi.” Musa ariphophiya kpwendamuambira Mwenyezi Mlungu gara garigogombwa ni atu, ");
INSERT INTO dig_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","na Mwenyezi Mlungu achimuamba Musa, “Uya kpwa nyo atu ukaatakase hino rero na muhondo, na afule nguwo zao ");
INSERT INTO dig_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","ili akale tayari kukutana nami, mana kesho kutwa mimi Mwenyezi Mlungu ndatserera dzulu ya Mwango Sinai, kuno atu osi ananiona. ");
INSERT INTO dig_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Kaike mphaka kuzunguluka mwango ili atu asiutsapike na uaambire, asiambuke mwango wala asiugute. Mutu yeyesi ndiyeguta nyo mwango, ni lazima aolagbwe. ");
INSERT INTO dig_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Andapigbwa mawe ama alatswe, bila ya mwiriwe kugutwa ni yeyesi. Shariya hino ni ya binadamu osi na nyama, ni apigbwe mawe hata afwe. Ela gunda richipigbwa vivyo kpwa vivyo, atu ni edze pho mphakani.” ");
INSERT INTO dig_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Ndipho Musa achitserera kula ko mwangoni, achendaatakasa atu, nao achifula nguwo zao, ");
INSERT INTO dig_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","na Musa achiaambira, “Dzitayarisheni kpwa yo siku ya wairya, na muda hinyo alume asilale na achetu ao.” ");
INSERT INTO dig_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Kuriphocha yo siku ya hahu kpwakala na chiguruguru na limeme, na ingu ziho richibwiningiza nyo mwango. Gunda richipigbwa kpwa raka ra dzulu sana hata atu osi pho kambini achikakama. ");
INSERT INTO dig_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Phahi Musa waalongoza kula kambini ili akutane na Mlungu, nao achiima tsini ya mwango. ");
INSERT INTO dig_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Mwango Sinai kala ukabwiningizwa ni mosi, sababu Mwenyezi Mlungu kala akatserera dzuluye dza moho. Mosi wa moho hinyo wafuka kuphiya dzulu dza mosi wa iyi kulu sana na mwango wosi uchikakama kpwa nguvu. ");
INSERT INTO dig_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Nyo mriro wa gunda uriphozidi kukala mkpwulu, Musa wagomba na Mlungu, na Mlungu achimjibu na sauti ya chiguruguru. ");
INSERT INTO dig_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Mwenyezi Mlungu ariphotserera dzulu ya Mwango Sinai, wamuiha Musa, naye achiphiya ko dzulu ya mwango. ");
INSERT INTO dig_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Musa ariphofika kuko, Mwenyezi Mlungu achimuamba, “Tserera ko tsini ukaambire nyo atu asitsupe mphaka ili kpwedzanilola mimi Mwenyezi Mlungu, mana achihenda vivyo anji aho andafwa. ");
INSERT INTO dig_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Hata nyo alavyadzi-sadaka ambao nkpwedza phephi na Mwenyezi Mlungu, ni adzitakase, bila ya kuhenda vivyo nindaatiya adabu.” ");
INSERT INTO dig_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Na Musa achimuamba Mwenyezi Mlungu, “Atu taaweza kuufikira Mwango Sinai, kpwa sababu uwe mwenye wahukanya uchiamba, ‘Ikani miphaka kuzunguluka mwango, ukale mwango wangu mtakatifu.’ ” ");
INSERT INTO dig_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Mlungu achimjibu achimuamba, “Haya tserera ukamuhale Aruni wedze naye. Ela alavyadzi-sadaka na atu osi asikale na lazima kutsupa mphaka, kpwedza hiku dzulu niriko mimi Mwenyezi Mlungu, ama nindaatiya adabu.” ");
INSERT INTO dig_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Kpwa hivyo Musa watserera hata ko tsini kokala na nyo atu achendaambira atu vyokala akalagizwa ni Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Mlungu wagomba maneno higa achiamba, ");
INSERT INTO dig_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Mimi, ndimi Mwenyezi Mlungu, Mlunguo, nriyekutuluza tsi ya Misiri, urikokala u mtumwa. ");
INSERT INTO dig_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Usiabudu milungu yanjina isiphokala mimi. ");
INSERT INTO dig_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Usidzitengezere chizuka cha kutsonga au chitu cha kuiga chitu chochosi chiricho dzulu mlunguni ama photsi duniani ama chikalacho madzini. ");
INSERT INTO dig_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Usivisujudiye wala kuviabudu, kpwa sababu mimi, Mwenyezi Mlungu, Mlunguo, ni Mlungu mwenye wivu. Nindatiya adabu ana kpwa dambi za ise zao, hadi chivyazi cha hahu na cha ne cha hara arionimena. ");
INSERT INTO dig_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Ela nkuonyesa mendzwa isiyosika kpwa maelufu na elufu ga hara animendzao na kugbwira amuri zangu. ");
INSERT INTO dig_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Usirihadze dzina ra Mwenyezi Mlungu, Mlunguo bure. Mana yeyesi anayehadza dzina rangu bure, mimi Mwenyezi Mlungu nindakuolanga kukala u mkpwosa. ");
INSERT INTO dig_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Itambukire Siku ya Kuoya na uihende takatifu. ");
INSERT INTO dig_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Henda kazizo zosi na mambogo gosi kpwa muda wa siku sita, ");
INSERT INTO dig_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","ela siku ya sabaa ni Siku ya kuoya kpwa ajili ya Mwenyezi Mlungu, Mlunguo. Siku iyo usihende kazi yoyosi, uwe phamwenga na mwanao mlume au mwanao mchetu, mtumishio mlume au mtumishio mchetu, ngʼombeyo, pundao au nyamao yeyesi, piya mjeni asagalaye phako kaya. ");
INSERT INTO dig_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Mana kpwa siku sita, Mwenyezi Mlungu waumba mlunguni, duniani, baharini na vyosi virivyo mumo. Achioya siku ya sabaa, ndiyo mana Mlungu wajaliya yo Siku ya Kuoya na achiihenda takatifu. ");
INSERT INTO dig_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Ishimu sowe na mayoo, dza vira mimi Mwenyezi Mlungu, Mlunguo, nrivyokulagiza, ili maishago gakale mare na uongokerwe kpwenye tsi ambayo mimi Mwenyezi Mlungu, Mlunguo nakupha. ");
INSERT INTO dig_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Usiolage. ");
INSERT INTO dig_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Usizini. ");
INSERT INTO dig_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Usiiye. ");
INSERT INTO dig_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Usimzige myao na dzambo ra handzo. ");
INSERT INTO dig_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Usimizire mahe nyumba ya myao. Usimizire mahe mkpwaza myao, wala mtumishiwe mlume au mtumishiwe mchetu, au ngʼombeye, au pundawe, au chitu chochosi aricho nacho jiranio.” ");
INSERT INTO dig_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Atu ariphosikira chiguruguru na gunda na kuona limeme na mwango unatuluza mosi, akakama kpwa wuoga, achiima kure ");
INSERT INTO dig_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","na achimuamba Musa, “Huambire gosi agombago Mlungu, naswi hundasikira, ela usiriche Mlungu akagomba naswi sedze hukafwa.” ");
INSERT INTO dig_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Phapho Musa achiajibu hara atu achiamba, “Msiogophe! Mlungu akedza kukujezani ili mdine kumuogopha na akuhendeni msihende dambi.” ");
INSERT INTO dig_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Phahi atu aima kure sana, wakati Musa ariphorisengerera rira ingu dziru ziho, arimokala Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Phahi Mwenyezi Mlungu achimuamba Musa, “Kaambire Aiziraeli kukala, ‘Si mkaona enye vyo nchivyogomba namwi kula mlunguni! ");
INSERT INTO dig_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Haya phahi, sedze mkadzitengezera milungu yanjina ya feza na ya zahabu mkanitsanganya nayo. ");
INSERT INTO dig_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“ ‘Nidzengerani phatu pha kulavira sadaka pha ulongo, na muhale ngʼombe na mbuzi na mangʼondzi genu mkanilavire sadaka za kuochwa na sadaka za amani dzulu ya hipho phatu pha kulavira sadaka. Nami phatu phophosi ndiphophatsambula ili niabudiwe nindakpwedza kpwenu nikujaliyeni. ");
INSERT INTO dig_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Ela phahi chitu chimwenga ni hichi, mndiphokala munanidzengera phatu pha kulavira sadaka pha mawe, msihumire mawe ga kutsongbwa, mana mchihumira chifwaya chochosi dzulu ya hipho phatu pha kulavira sadaka mundaphahenda phakale najisi. ");
INSERT INTO dig_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Tsona mchidzenga phatu pha kulavira sadaka msiphadzenge ngazi za kupandira dzulu, sedze kala mutu anapanda nguwoze zikafwenuka akakala chitsaha hipho phatu pha kulavira sadaka.’ ” ");
INSERT INTO dig_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Phahi Mwenyezi Mlungu achienderera kugomba na Musa achiamba, “Higa ndigo malagizo ndigoaphirikira ana a Iziraeli: ");
INSERT INTO dig_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Mutu achigula Mueburania myawe akale mtumwa, phahi mtumwa hiye andahumika miaka sita, ela mwaka wa sabaa uchiinjira ni arichwe akale huru bila kuripha chochosi. ");
INSERT INTO dig_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Ichikala wakati unamgula kala ni mndzaka andauka macheye, ela ichikala kala ana mchetu kare andauka na mchewe. ");
INSERT INTO dig_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Na ichikala wakati unamgula kala ni mndzaka, ela uchedza mlóza uwe hata achivyala ana, hiye mchetu phamwenga na anae osi ni ako, hiye mlume andauka macheye. ");
INSERT INTO dig_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Ela hiye mtumwa achigomba wazi kukala, anakumendza uwe tajiriwe, phamwenga na mchewe na anae hata kalonda kuuka pho phako akakala huru, ");
INSERT INTO dig_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","undamuhala uphiye naye mbere za Mlungu. Uchifika hiko muimise mryangoni ama chizingiti cha mryango, uhale mwityo umuombole sikiro, naye andakala mtumwao maishage gosi. ");
INSERT INTO dig_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Mutu achikuguzira mwanawe mchetu akale mtumwao, usimrichire huru dza vira atumwa alume arichirwavyo. ");
INSERT INTO dig_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Ichikala uwe uchiyemgula kala unalonda akale mcheo, halafu asikuhamire, undamricha akombolwe ni ise. Uwe tajiriwe kuna ruhusa ya kumguza kpwa makabila, kpwa sababu undakala ukamvundzira ishimaye. ");
INSERT INTO dig_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Ela napho wamgula ili umlóze mwanao, phahi undamharira avi ni mwanao mchetu. ");
INSERT INTO dig_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Mutu achilóla mchetu wa phiri, ni ahakikishe kukala ye wa kpwandza anamrisa, na kumvwika, na kumtimizira hakize zosi za ndowa. ");
INSERT INTO dig_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Na ichikala kandahenda hivyo, phahi hiye mchewe wa mwandzo ana uhuru wa kumricha hiye mlume bila kuripha chitu chochosi.” ");
INSERT INTO dig_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Chisha Mwenyezi Mlungu achienderera kugomba na Musa achimuamba, “Mutu achimpiga myawe achimuolaga, naye naaolagbwe. ");
INSERT INTO dig_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Ela ichikala kamuolagire kusudi, ela Mlungu akarikubaliya, naachimbire aphiye kpwatu ndikoatsamburira atu dza hinyo. ");
INSERT INTO dig_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Ela ichikala akamuolaga myawe kusudi, hata akachimbirira phatu nilavirwapho sadaka, mtuluzeni mkamuolage vivyo. ");
INSERT INTO dig_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Ndiyempiga ise au nine naaolagbwe. ");
INSERT INTO dig_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Mutu achimteka myawe achimguza akale mtumwa, au agbwirwe achere naye, naaolagbwe. ");
INSERT INTO dig_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Amlaphizaye ise au nine ni aolagbwe. ");
INSERT INTO dig_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Napho atu airi akakosana, na mmwenga atsole dziwe ampige myawe, au ampige ngumi amlumize hata akale kaweza kutuluka kondze, ");
INSERT INTO dig_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","chisha aweze kugbwira fwimbo atuluke kondze, iye chiyempiga kandatiywa adabu. Ela ni amriphe hizo siku zosi arizokala chitandani na ahakikishe kukala andamrarisa hadi aphole tsetsetse. ");
INSERT INTO dig_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Mutu achimpiga fwimbo mtumwawe mlume au mchetu hata afwe. Iye ni atiywe adabu. ");
INSERT INTO dig_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Ela hiye mtumwa achikala kpwa siku mwenga au mbiri ndipho achifwa, hiye mwenye mtumwa asitiywe adabu kpwa sababu iye mtumwa ni maliye mwenye. ");
INSERT INTO dig_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Napho alume anaheha, na katika kuheha kpwao amlumize mchetu mwenye mimba hata avoromose, ela akale taamlumizire zaidi ya hiko kuvoromosa, ye mkosa andaripha ndivyoambwa ni mlume wa hiye mchetu, na kulengana na aamuli ndivyoamula. ");
INSERT INTO dig_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Ela ichikala hiye mchetu akalumira kutsupa hiko kuvoromosa, phahi hiye achiyegahenda andaripha uhai kpwa uhai, ");
INSERT INTO dig_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","dzitso kpwa dzitso, dzino kpwa dzino, mkpwono kpwa mkpwono, lwayo kpwa lwayo, ");
INSERT INTO dig_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","chironda cha moho kpwa chironda cha moho, jaraha kpwa jaraha, kuvwarurwa kpwa kuvwarurwa. ");
INSERT INTO dig_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Mutu achimpiga mtumwawe mchetu au mlume hadi achimuombola dzitso, naamrichire huru kpwa sababu ya hiro dzitsore. ");
INSERT INTO dig_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Tsona mutu achimpiga mtumwawe mchetu au mlume hata achimngʼola dzino, iye naye naamrichire huru kpwa sababu ya hiro dzinore.” ");
INSERT INTO dig_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Phahi Mwenyezi Mlungu achienderera kugomba na Musa achiamba “Ngʼombe ichipiga mutu hadi ichimuolaga, naipigbwe mawe hata ifwe, na msiirye; ela iye mwenye ngʼombe andakala kana makosa. ");
INSERT INTO dig_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Ela ichikala iyo ngʼombe ikabara kupiga atu na iye mwenye wakanywa ela kashuulika, ichipiga mutu tsona ichimuolaga, naipigbwe mawe ifwe, na ye mwenye ngʼombe naye ni aolagbwe. ");
INSERT INTO dig_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Ela ichikala hinyo achioolagirwa mutu wao andalonda kuriphiwa, phahi ye mwenye ngʼombe ni aariphe mara mwenga naye andakala akativya rohoye. ");
INSERT INTO dig_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Lagizo hiri mundarilunga hata wakati ngʼombe ndiphokala ikaolaga mwanache. ");
INSERT INTO dig_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Ngʼombe ichiolaga mtumwa mchetu au mlume, hiye mwenye ngʼombe andamripha hiye mwenye mtumwa vipande mirongo mihahu vya feza, halafu yo ngʼombe ipigbwe mawe hata ifwe. ");
INSERT INTO dig_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Mutu achiricha dibwa bila kuribwiningiza, au achitsimba dibwa halafu achiriricha laza, alafu ngʼombe au punda wa myawe edze agbwe na afwe mumo, ");
INSERT INTO dig_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","hiye mwenye hiro dibwa naamriphe pesa hiye mwenye nyama halafu iye ahale ye nyama wa kufwa. ");
INSERT INTO dig_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Ngʼombe ya mutu ichipiga ngʼombe ya mutu wanjina, ichiiolaga, yo ngʼombe iriyo moyo naihalwe iguzwe, na hinyo enye ngʼombe zichizopigana aganye zo pesa, na yo ngʼombe ya kufwa nayo aiganye sawa-sawa. ");
INSERT INTO dig_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Ela ichikala iyo ngʼombe inamanyikana kukala kaziye ni kupiga ngʼombe zanjina na kuziolaga, na hiye mwenye akashindwa ni kuifunga, phahi iyo ngʼombe andairipha na ngʼombe, halafu ahale iyo ngʼombe ya kufwa.” ");
INSERT INTO dig_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Tsona Mwenyezi Mlungu achienderera kugomba na Musa achiamba, “Mutu achigbwirwa akaiya ngʼombe, au ngʼondzi, au mbuzi na akaitsindza au akaiguza, ni ariphe ngʼombe tsano badala ya mwenga, napho ni ngʼondzi, ni ariphe mangʼondzi mane badala ya mwenga. ");
INSERT INTO dig_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","4","“Ela ye muivi achigbwirwa naye ye nyama, andaripha kano mbiri. Napho ni ngʼombe, ni ariphe ngʼombe mbiri, napho ni ngʼondzi ni ariphe mangʼondzi mairi, na ichikala ni punda andaripha punda airi. Muivi achigbwirwa ni ariphe, na achikala kana cha kuripha, naaguzwe kama mtumwa na hizo pesa ziriphe hiro deni. Mutu achigbwirwa anavundza nyumba ya myawe usiku na achipigbwa achiolagbwa, hiye muolagi kana makosa. Ela mutu achigbwira muivi na mutsi halafu amuolage ana makosa na andaisabiwa kama muolagi. ");
INSERT INTO dig_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Mutu achendarisa mundani au kpwenye munda wa mizabibu halafu hinyo nyama amenye mundani mwa myawe, andaripha hasara yosi ndiyokala akamtiya hiye myawe. Andatsambula vitu vinono zaidi vya mwakpwe mundani kulengana na vitu chivyoriwa, amuphe hiye myawe. ");
INSERT INTO dig_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Mutu achitiya moho mwakpwe mundani, nao ugbwize munda wa jiraniwe uoche mtsere ambao uchere mundani, au chiofungbwa mabutsa-mabutsa, hiye achiyegbwiza moho ni ariphe hivyo vitu ndivyokala vikaphya. ");
INSERT INTO dig_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Mutu achimupha myawe pesa au vitu aikirweto, halafu hizo pesa au hivyo vitu viiywe, hiye muivi achigbwirwa au achimanyikana, andaripha kano mbiri ya vitu hivyo. ");
INSERT INTO dig_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Ela ichikala hiye muivi kagbwirirwe na kamanyikanire, hiye muiki naaphiye hata mbere za Mlungu na alaphe kukala kakahusika kahi za wivi hinyo. ");
INSERT INTO dig_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Tsona atu airi achiheha kuhusu chitu, ikale ni ngʼombe, punda, ngʼondzi, nguwo, au chitu chochosi chirichoangamika, ambapho chila mmwenga wao anaamba nchakpwe, ahaleni muarehe mbere za Mlungu. Iye ndiyehukumiwa ni Mlungu kukala ndiye wa handzo andamripha iye myawe kano mbiri ya hicho chitu. ");
INSERT INTO dig_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Mutu achimfugira myawe mfugo wowosi ikale ni punda, ngʼondzi, au ngʼombe halafu mfugo hura ufwe, au ulumizwe phatu, au uiywe bila kuonewa ni mutu yeyesi, ");
INSERT INTO dig_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","hiye mfugi ni aphirikpwe mbere za Mwenyezi Mlungu akaape kukala iyo mali ya myawe kayaiguta, na hiye mwenye mali naatosheke na asitake kuriphiwa. ");
INSERT INTO dig_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Ela hiye nyama achiiywa kula hiko kpwakpwe, naamriphe iye mwenye. ");
INSERT INTO dig_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Napho achagbwirwa na akaolagbwa ni nyama a tsakani, naamuhale amrehe dza ushaidi, na asiriphe chochosi. ");
INSERT INTO dig_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Mutu achimvoya myawe nyama akamuhendere kazi, halafu hiye nyama arumire phatu au afwe kuno mwenye kapho, hiye mvoyi ni amriphe myawe. ");
INSERT INTO dig_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Ela napho wakati hiye nyama analumira au anafwa mwenye kala a phapho, hiye mvoyi kandaripha chochosi. Na ichikala kala akahenda kukodishwa, hiye mvoyi andaripha pesa za kukodisha macheye.” ");
INSERT INTO dig_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Mutu achimrusa msichana ambaye kadzangbwelólwa na achimchenga-chenga hata achikala naye, naamlavire mali na amlóle. ");
INSERT INTO dig_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Ela ichikala ise wa msichana kataki tsetsetse mwanawe alólwe ni hiye, hiye mlume naaisabu mali ya msichana amuphe ise. ");
INSERT INTO dig_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Musiriche mchetu mtsai akakala moyo bii. ");
INSERT INTO dig_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Mutu yeyesi ndiyelala nyama, ni aolagbwe. ");
INSERT INTO dig_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Mutu yeyesi ndiyemlavira sadaka mlungu wanjina isiphokala Mwenyezi Mlungu ni aolagbwe. ");
INSERT INTO dig_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Musiahendere mai ajeni, wala kuaonera, mana mwimwi namwi mwakala ajeni kpwenye tsi ya Misiri. ");
INSERT INTO dig_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Usimuhendere mai gungu au mwanachiya. ");
INSERT INTO dig_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Mchiahendera mai gogosi na achiniririra kuhusu munagoahendera nindaphundza chiriro chao, ");
INSERT INTO dig_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","nindatsukirwa na nikuolageni kpwa upanga, ili achetu enu nao akale magungu na ana enu nao akale anachiya. ");
INSERT INTO dig_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Uchimuaphasa mchiya kahi za atu angu, muaphase kare tu, wala usimtake fwaida dza vira aguzi a pesa ahendavyo. ");
INSERT INTO dig_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Uchihala nguwo ya myao ikale mzamana, lazima umuuyizire kabila dzuwa kutswa. ");
INSERT INTO dig_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Mana kana nguwo yanjina ya kudzibwiningiza hata ni iyo bahi, na usiphomuuyizira andadzibwiningizani? Manya kukala achiniririra kpwa sababu ukasala na nguwoye, nindamphundza kpwa sababu mimi ni Mlungu wa mbazi. ");
INSERT INTO dig_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Usimkufuru Mlungu, wala kumlani mtawala wa atuo. ");
INSERT INTO dig_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Msihende vwende kunilavira mtalo wangu kahi za mavuno genu, na uchi wenu wa zabibu. Tsona mundanipha ana enu a mwandzo alume. ");
INSERT INTO dig_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Na chila mwana ngʼombe wa kpwandza mlume, au mwana ngʼondzi, achivyalwa mricheni na nine sabaa mwenga, ela siku ya nane ichifika nlavirani. ");
INSERT INTO dig_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Mwimwi mundakala atu angu atakatifu, kpwa hivyo, msirye kabisa nyama chiyeolagbwa ni nyama wa vuweni, nyama dza hinyo mundaatsuphira madiya. ");
INSERT INTO dig_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Usitangaze maneno ga handzo, tsona usimkanire mutu mui kpwa kumlavira ushaidi wa handzo. ");
INSERT INTO dig_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Usihende mambo mai kpwa sababu atu anji anagahenda, tsona napho unalavya ushaidi kesini, usipinge kpweli kpwa kukala atu anji anahenda vivyo. ");
INSERT INTO dig_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Na unaphoamula kesi ya mchiya usimpendelee. ");
INSERT INTO dig_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Uchiona ngʼombe au punda wa mutu usiyephahana naye akaangamika, mphirikire mwenye. ");
INSERT INTO dig_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Uchimuona punda wa aduio akagbwa na mizigo na kaweza kungʼoka, usimpaze ukamtsupa, phiya ukamterye kumuimisa. ");
INSERT INTO dig_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Ichikala unaamula kesi ya mchiya usimlafye hakiye. ");
INSERT INTO dig_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Dzitenge na maneno ga handzo tsona usiolage mutu asiye na kosa au mutu wa haki, kpwa sababu mutu mui dza iye, sindamuonera mbazi tse. ");
INSERT INTO dig_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Usikubali kuhongbwa hata chidide, kpwa sababu hongo rinahenda akulu akale vipofu na kugaluza kpweli ya enye haki kukala handzo. ");
INSERT INTO dig_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Musiahendere ajeni mai, mana mwimwi namwi kala mu ajeni kahi za tsi ya Misiri na mnamanya ujeni urivyo. ");
INSERT INTO dig_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Kpwa miaka sita rimani mchiguwa tu. ");
INSERT INTO dig_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Ela mwaka wa sabaa sirimeni bii ili yo minda ioye. Na chitu chochosi ndichomera na kuivwa himo mundani msichivune ili achiya aphahe chakurya, na ndivyosala arichireni nyama a tsakani amarigize. Hendani vivyo hata kpwa minda yenu ya mizabibu na ya mizaituni. ");
INSERT INTO dig_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Hendani kazi kpwa siku sita, ela siku ya sabaa msihende kazi ili atumwa enu, na nyama enu, na ajeni anaokuhenderani kazi nao aphahe kuoya siku iyo. ");
INSERT INTO dig_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Gaga nchigokuambirani gagbwirenito sana. Msiabudu Milungu yanjina tsetsetse, na hata kuihadza piya msiihadze. ");
INSERT INTO dig_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Mundaniusira sikukuu tahu chila mwaka. ");
INSERT INTO dig_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Ya mwandzo ni sikukuu ya mikahe isiyotiywa hamira. Sikukuu ihi mundayiusa mwezi wa Abibu, kpwa sababu uho ndio mwezi muriotulukira Misiri. Wakati wa sikukuu ihi mundarya mikahe isiyotiywa hamira kpwa muda wa siku sabaa, kahi za wakati urioikpwa, kama nrivyolagiza. Mutu asedze mbere zangu mikono mihuphu bii. ");
INSERT INTO dig_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Sikukuu ya phiri ni sikukuu ya mavuno. Sikukuu hino mundayiusa wakati mndiphovuna mavuno genu ga mwandzo ga kazi ya mikono yenu, kula mwenu mindani. Na sikukuu ya mwisho ni sikukuu ya kuvuna vitu vyosi murivyorima mwenu mindani na kuvireha kaya chila mwisho wa mwaka. ");
INSERT INTO dig_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Na kahi ya hizi sikukuu tahu, alume osi ni edze mbere za Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Mchitsindza nyama enu ili kunilavira sadaka ya milatso, msiilavye phamwenga na mikahe ya kutiywa hamira. Tsona higo marunya ga nyama mndionilavira dza sadaka kahi ya sikukuu hizo, gasisale hadi ligundzu. ");
INSERT INTO dig_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Chila mwaka reheni mavuno genu ga mwandzo ga mwenu mindani nyumbani mwa Mwenyezi Mlungu, Mlungu wenu. Msijite mwana mbuzi na maziya ga nine.” ");
INSERT INTO dig_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Phahi Mwenyezi Mlungu achienderera kugomba na Musa achiamba, “Lola, mimi nindahuma malaika edze akulongozeni. Naye andakurindani mwenu charoni hadi akufiseni kpwahali nirikokuikirani. ");
INSERT INTO dig_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Phahi mphundzeni na muhende chila ndirokuambirani. Msimuasi, kpwa sababu iye kandakuswameheni, mana andahenda chila chitu kpwa ajili yangu. ");
INSERT INTO dig_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Mchimphundza na kuhenda higa ninagokuambirani, nindakala mviha wa aviha enu na nindapinga anaokupingani. ");
INSERT INTO dig_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Phahi malaika wangu achikulongozani hadi mchifika tsi ya Aamori, Ahiti, Aperizi, Akanani Ahivi na Ajebusi, nami nchiausa, ");
INSERT INTO dig_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","msisubutu kuzamira au kuhumikira iyo milungu yao, au kuiga higo mambo gao ahendago. Mwimwi ni mvundze-vundze milungu yao phamwenga na nguzo zao. ");
INSERT INTO dig_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Mchinihumikira mimi, Mwenyezi Mlungu, Mlungu wenu, nindabariki chakurya chenu, nibariki madzi genu na nindakurindani na makongo. ");
INSERT INTO dig_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Takuna mchetu hata mmwenga kpwenye tsi yenu ndiyevoromosa au ndiyekala tasa. Tsona nindakuhendani muishi miaka minji hipha duniani. ");
INSERT INTO dig_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Atu osi mndioheha nao nindaatiya wuoga na niahende atsanganyikirwe. Nindaahenda aviha enu akuchimbireni. ");
INSERT INTO dig_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Wakati munaphiya, nindahuma mivi mbere zenu ikatuluze hinyo Ahivi, Akanani, na Ahiti kula kahi ya iyo tsi. ");
INSERT INTO dig_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Ela atu hinyo sindaazola osi ndani ya mwaka mmwenga, sedze iyo tsi ikasala wekee bila atu, nyama a tsakani akakukarirani anji akakuyugani. ");
INSERT INTO dig_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Nindaausa pore-pore vivii hadi mkale anji a kutosha kumiliki yo tsi. ");
INSERT INTO dig_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Iyo tsi ndiyokuphani indaphakana na nyika uphande wa mlairo wa dzuwa. Na uphande wa mtswerero wa dzuwa indaphakana na bahari ya kahi-kahi, Bahari ya Shamu, na muho Yufurati. Hinyo enye tsi nindaatiya mwenu mikononi namwi mundaazola auke mbere zenu. ");
INSERT INTO dig_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Musiike chilagane nao wala na milungu yao. ");
INSERT INTO dig_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Msiariche akasagala phamwenga namwi kahi ya iyo tsi, sedze akakuhendani mkahenda dambi. Mana mchiabudu milungu yao phahi hinyo muhego undakala ukakugbwirani.” ");
INSERT INTO dig_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Mwenyezi Mlungu achimuamba Musa, “Ndzoni hiku kpwangu, uwe phamwenga na Aruni, Nadabu, na Abihu, na atumia mirongo sabaa kahi za atumia a Iziraeli. Mchedza mundaima kure nami muniabudu. ");
INSERT INTO dig_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Uwe Musa macheyo ndiwe ndiwesengera phephi na Mwenyezi Mlungu. Atumia osi asisengere phephi, na Aiziraeli asikpwere mwango kamare.” ");
INSERT INTO dig_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Phahi, Musa wakpwendaambira atu maneno na malagizo ga Mlungu. Atu osi achijibu chivyamwenga achiamba, “Mambo gosi ambago Mwenyezi Mlungu akagagomba hundagahenda.” ");
INSERT INTO dig_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Musa waandika malagizo gosi ga Mwenyezi Mlungu. Chisha achilamuka chiti na achidzenga phatu pha kulavira sadaka tsini ya mwango na achiika nguzo kumi na mbiri za mawe. Chila nguzo kala ichiimirira mbari mwenga kahi ya mbari kumi na mbiri za Aiziraeli. ");
INSERT INTO dig_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Na achiahuma barobaro a Chiiziraeli amlavire Mwenyezi Mlungu sadaka za kuochwa na sadaka za amani za ana ndzau. ");
INSERT INTO dig_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Musa wahala nusu ya mlatso wa nyama achiutiya madzayani na nusu yanjina achiutimvya-timvya phara phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Chisha achihala Chitabu cha chilagane ambacho malagizo ga Mlungu kala gakaandikpwa, na achichisoma kuno atu anaphundza, nao achiamba, “Hundamuogopha Mwenyezi Mlungu na hundahenda chila chitu ambacho walagiza.” ");
INSERT INTO dig_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Phahi Musa wahala hura mlatso mura madzayani achitimvira-timvira hara atu. Achiamba, “Huno ni mlatso wa chilagane cha Mwenyezi Mlungu ambacho akachihenda na mwimwi kulengana na maneno higa gosi.” ");
INSERT INTO dig_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Musa, Aruni, Nadabu, Abihu na atumia mirongo sabaa a Iziraeli akpwera ko mwangoni ");
INSERT INTO dig_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","na achimuona Mlungu wa Iziraeli. Phakpwe maguluni kala phana utu dza mbarara ya mawe ga samani gaihwago yakuti. Kala phanangʼala dza ko mlunguni kurivyo. ");
INSERT INTO dig_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Vilongozi hinya a Iziraeli amuona Mlungu ela waaricha moyo bila kuahenda chitu chochosi chii. Chisha hara vilongozi arya na kunwa phamwenga phapho mbere za Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Mwenyezi Mlungu achimuamba Musa, “Ndzo hiku kpwangu mwangoni, wedze ukale hiku nriko. Nindakupha myalawe niriyoandika malagizo na shariya ili ukaafundze Aiziraeli.” ");
INSERT INTO dig_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Phahi Musa na Joshuwa msaidiziwe auka, na Musa achikpwera mwango wa Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Kabila ya Musa kukpwera mwangoni, waambira hara atumia, “Hugodzereni phapha hadi hundiphouya. Aruni na Huri a phamwenga namwi, phahi chila ndiyekala na dzambo naambire aho.” ");
INSERT INTO dig_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Musa ariphophiya hiko mwangoni, ingu ziho raubwiningiza, ");
INSERT INTO dig_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","na mwanga wa Mwenyezi Mlungu uchingʼala dzulu ya mwango Sinai. Kpwa siku sita rira ingu raubwiningiza hura mwango, na iriphofika siku ya sabaa, Mlungu wamuiha Musa mumo inguni. ");
INSERT INTO dig_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Aiziraeli kala anaona mwanga wa Mwenyezi Mlungu, dza moho uochao tsetsetse dzulu ya mwango. ");
INSERT INTO dig_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Musa waenderera kukpwera dzulu ya mwango, achiinjira inguni. Naye wasala kuko mwangoni siku mirongo mine, usiku na mutsi. ");
INSERT INTO dig_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Chisha Mwenyezi Mlungu achigomba na Musa achimuamba, ");
INSERT INTO dig_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Phiya ukaambire Aiziraeli anilavire sadaka ya vitu. Chila mutu ndiyelavya chituche kpwa hiyari, chiphokere. ");
INSERT INTO dig_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Na hivi ndivyo vitu ndivyophochera kula kpwao: Zahabu, feza, shaba, ");
INSERT INTO dig_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","uzi wa buluu, wa zambarau na wa kundu, nguwo ya katani swafi, nyoya za mbuzi; ");
INSERT INTO dig_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","chingo za maturume chizotiywa rangi ya kundu, chingo za nyama wa pwani aihwaye pomboo, na mbao za muhi uihwao mshita. ");
INSERT INTO dig_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","Tsona asikose kureha mafuha ga zaituni ga kuasira taa, vilungo vya kutsanganyira mafuha ga utakaso na vya uvumba wa kunukato. ");
INSERT INTO dig_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Tsona undaphokera mawe ga samani gaihwago shohamu na mawe ganjina ga samani kulu ndigopamba hicho chisibao cha mlavyadzi-sadaka na chifuko cha phakpwe chifuwani. ");
INSERT INTO dig_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“Achimala kureha vitu hivyo, naanitengezere Phatu Phatakatifu ili niweze kusagala phamwenga nao. ");
INSERT INTO dig_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Hema hiro ridzenge na uritiye miyo kulengana na mfwano ndiokuonyesa.” ");
INSERT INTO dig_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Mwenyezi Mlungu waenderera kugomba na Musa achimuamba, “Aambire anitengezere sanduku ra mbao za mshita. Ure wa sanduku hiro undakala mikono mihahu na nusu, upanawe ukale mkpwono mmwenga na nusu, na chimoche nacho chikale mkpwono mmwenga na nusu. ");
INSERT INTO dig_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Mundaripaka zahabu swafi kondze na ndani, halafu mrizungulusire mkpwungo wa marembo-marembo wa zahabu. ");
INSERT INTO dig_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Mchimala hivyo tengezani bangili kulu ne za zahabu, mzigbwizanye na hizo pembe za tsini za hiro sanduku, chila pembe bangili mwenga, uphande huno mbiri na uphande wanjina mbiri. ");
INSERT INTO dig_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Mchila hipho, tsongani migongo ya mshita na muipake zahabu hata tse, ");
INSERT INTO dig_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","halafu myiinjize kahi za hizo bangili, lavu hiri mgongo, na lavu hiri mgongo. Iyo ndiyo mndiyotsukurira hiro sanduku. ");
INSERT INTO dig_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Muchikala mkainjiza iyo migongo himo vihundeni siituluzeni tsona kabisa, iricheni ikale mumo. ");
INSERT INTO dig_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Phahi nchikupha iyo myalawe miiri nriyoiandika hizo shariya, kayiike ndani ya hiro sanduku ra chilagane. ");
INSERT INTO dig_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Uchimala kuhenda hivyo, undatengeza chihi cha mbazi na zahabu swafi nacho chindakala mfwiniko wa hiro sanduku. Hicho chindakala na ure wa mikono miiri na nusu, na upana wa mkpwono mmwenga na nusu. ");
INSERT INTO dig_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Tsona undaunda makerubi airi a zahabu yobandwa, uaimise dzulu ya hicho chihi cha mbazi, mmwenga mkpwono wa kulume na wanjina mkpwono wa kumotso. ");
INSERT INTO dig_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Kerubi mmwenga undamuika kanda hino, na kerubi wanjina undamuika kanda hira. Hinyo makerubi na hicho chihi cha mbazi undavigbwizanya vikale chitu chimwenga. ");
INSERT INTO dig_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Hinyo makerubi andakala akaandzula mapha gao, ili achifwinikire hicho chihi cha mbazi tsona andakala analolana kuno akabwaga matso kulola hicho chihi cha mbazi. ");
INSERT INTO dig_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Phahi undahala iyo myalawe yoandikpwa hizo shariya za ushaidi ndiokupha, uyiinjize ndani ya hiro sanduku ra chilagane, halafu uhale hicho chihi cha mbazi ubwiningize. ");
INSERT INTO dig_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Nami nindakala nchikutana na kugomba nawe pho dzulu ya cho chihi cha mbazi, kahi-kahi za hinyo makerubi airi aimireo dzulu ya hiro sanduku ra chilagane na hipho ndakupha shariya zosi za Aiziraeli.” ");
INSERT INTO dig_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Chisha Mlungu achienderera kugomba na Musa achiamba, “Tsona undatengeza meza ya mbao za mshita. Urewe undakala mikono miiri, na upanawe ukale mkpwono mmwenga na chimoche chikale mkpwono mmwenga na nusu. ");
INSERT INTO dig_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Undaipaka zahabu swafi yosi tsetsetse, halafu uizungulusire mkpwungo wa marembo-marembo wa zahabu pande zosi. ");
INSERT INTO dig_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Chisha undaitengezera mimo ya upana wa inchi tahu, tsona iyo mimo nayo undaizungulusira mkpwungo wa marembo-marembo wa zahabu. ");
INSERT INTO dig_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Undaitengezera bangili kulu ne za zahabu na chila bangili uigbwizanye na pembe mwenga ya chigulu cha yo meza. ");
INSERT INTO dig_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Zo bangili undaziika phephi na yo mimo mana ndiyo ndiyogbwiririra yo migongo ya kutsukurira yo meza. ");
INSERT INTO dig_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Uchimala kuhenda hivyo, tsonga migongo ya mshita na uipake zahabu. Iyo indakala ya kutsukurira yo meza. ");
INSERT INTO dig_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Undatengeza sahani, vikombe, majagi na vibakuli vya kulavira sadaka ya chinwadzi. Miyo hino yosi undaitengeza na zahabu swafi. ");
INSERT INTO dig_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Phahi undahala iyo meza uyiike mbere za hiro sanduku ra chilagane, halafu ukale uchiika iyo mikahe chiyolaviwa sadaka mbere zangu dzulu ya iyo meza siku zosi.” ");
INSERT INTO dig_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Chisha Mwenyezi Mlungu achienderera kugomba na Musa achimuamba, “Undaunda chinara cha kuikira taa cha zahabu swafi yobandwa. Hako ra cho chinara, mgongowe wa kahi-kahi, mafundoge na maruwage ga kuchitiya marembo, naikale chitu chimwenga. ");
INSERT INTO dig_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Chinara hicho chindakala na panda sita, uphande huno panda tahu na uphande huno panda tahu. ");
INSERT INTO dig_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Kahi ya hizo panda sita, chila panda indakala na maruwa mahahu chigoigana na ruwa ra mlozi. Na chila ruwa, rindakala na chigongo cha kurigbwiririra. ");
INSERT INTO dig_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Hinyo mgongo wa kahi-kahi wa cho chinara cha kuikira taa undakala na maruwa mane chigoigana na maruwa ga mlozi. Chila ruwa rindakala na chigongo cha kurigbwiririra. ");
INSERT INTO dig_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Undatengeza mafundo mahahu chigoigana na ruwa ambaro taridzangbwebumula, fundo mwenga tsini ya chila panda. ");
INSERT INTO dig_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Higo mafundo, na zo panda na cho chinara navigbwizanywe phamwenga ikale chitu chimwenga ambacho chikaundwa na zahabu swafi. ");
INSERT INTO dig_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Phahi uchimala kutengeza cho chinara, tengeza taa sabaa uziike dzuluye, ili zilavye mwanga seemu iriyo mbere za hicho chinara. ");
INSERT INTO dig_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Vifwaya vya kukatira utambi wa hizo taa phamwenga na visahanivye navyo navitengezwe na zahabu swafi. ");
INSERT INTO dig_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Hicho chinara cha kuikira zo taa phamwenga na vifwayavye vyosi navitengezwe na kilo mirongo mihahu na tsano ya zahabu swafi. ");
INSERT INTO dig_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Vitu vivi vyosi ni uvitengeze kulengana na hinyo mfwano urioonyeswa ko dzulu mwangoni.” ");
INSERT INTO dig_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Phahi Mwenyezi Mlungu achienderera kugomba na Musa achiamba, “Tengeza hema ra mkpwutano kuhumira shuka kumi za katani swafi za kuhendasukpwa na nyuzi za buluu, za zambarau, na za kundu. Chisha marembo ga makerubi gafumwe kahi za hizo shuka ni mafundi amanyao vinono. ");
INSERT INTO dig_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Hizo shuka zosi ni zikale sawa-sawa. Chila shuka ikale na ure wa mikono mirongo miiri na minane, na upana wa mikono mine. ");
INSERT INTO dig_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Hizo shuka mundazigbwizanya tsano-tsano. ");
INSERT INTO dig_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Na chila shuka ya kanda kahi ya hizo shuka tsano-tsano mndizogbwizanya, mundaishonera mahandzi ga uzi wa buluu kpwenye pindore. ");
INSERT INTO dig_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Halani iyo shuka ya mwandzo kabisa kahi ya hizo shuka tsano za mwandzo, na iyo shuka ya mwisho kahi ya hizo shuka zanjina tsano, mziinjize mahandzi mirongo mitsano na tsano, mahandzi gaga nagalolane. ");
INSERT INTO dig_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Uchila phapho tengeza vihunde mirongo mitsano vya zahabu, ndivyokala vya kugbwizanyira zo shuka. Chila shuka naigbwizanywe na yawe ili ro hema rosi rikale chitu chimwenga.” ");
INSERT INTO dig_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Phahi Mlungu achienderera kugomba na Musa achiamba, “Tengeza shuka kumi na mwenga za nyoya za mbuzi. Shuka hizo undazihumira kutengezera chandaruwa chanjina ndichobwiningiza ro hema ra mkpwutano. ");
INSERT INTO dig_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Zo shuka kumi na mwenga, ni zikale sawa zosi. Chila shuka ikale na ure wa mikono mirongo mihahu na upana wa mikono mine. ");
INSERT INTO dig_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Undahala shuka tsano uzigbwizanye lwakpwe, na hizo shuka sita nazo uzigbwizanye lwakpwe. Iyo shuka ya sita undaikundza kano mbiri hipho mbere za ro hema. ");
INSERT INTO dig_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Undashona mahandzi mirongo mitsano dzulu ya pindo ra iyo shuka ya mwisho kahi ya hizo shuka tsano za mwandzo, na mahandzi mirongo mitsano dzulu ya pindo ra iyo shuka ya mwisho ya zo shuka zanjina. ");
INSERT INTO dig_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Uchimala, tengeza vihunde mirongo mitsano vya shaba, na uviinjize kahi ya go mahandzi, ili ugbwizanye shuka zosi zikale dziyamba dzimwenga ra ro hema. ");
INSERT INTO dig_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Iyo nusu shuka ndiyosala indalewalewa uphande wa nyuma wa hiro hema ra mkpwutano. ");
INSERT INTO dig_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Hizo futi mwenga na nusu za nguwo ndizosala kahi ya hizo pande mbiri za hema iyo, ziriche zilewelewe zibwiningize hiro hema, futi mwenga na nusu lavu hiri na futi mwenga na nusu zanjina lavu hiri. ");
INSERT INTO dig_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Ro hema undaritengezera vyandaruwa viiri. Chandaruwa chimwenga chindakala cha chingo za maturume ndizotiywa rangi ya kundu, na chandaruwa cha phiri, ndichokala dzulu ya cho cha mwandzo chindatengezwa na chingo swafi za nyama wa pwani aihwaye pomboo.” ");
INSERT INTO dig_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Phahi Mlungu achienderera kugomba achiamba, “Hiro hema undaritengezera mimo ya mbao za mshita, uziimise. ");
INSERT INTO dig_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Ure wa chila mwimo undakala mikono kumi, na upana wa mkpwono mmwenga na nusu. ");
INSERT INTO dig_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Chila mwimo undakala na vihunde viiri chivyotulukiza ndivyohumirwa kugbwizanyira yo mimo. ");
INSERT INTO dig_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Uphande wa mwakani wa ro hema undautengezera mimo mirongo miiri, ");
INSERT INTO dig_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","na vihunde vya koloni vya kuimisira vya feza, mirongo mine. Chila mwimo undakala na seemu za koloni mbiri za feza ndizotiywa vyo vihundevye viiri chivyotulukiza. ");
INSERT INTO dig_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Uphande wa vurini wa ro hema nako, undatengezera mimo mirongo miiri, ");
INSERT INTO dig_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","na vihunde vya koloni vya kuimisira vya feza, mirongo mine. Chila mwimo undakala na seemu za koloni mbiri ndizotiywa vyo vihundevye viiri chivyotulukiza. ");
INSERT INTO dig_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Uphande wa nyuma wa ro hema uchioloza mtswerero wa dzuwa undautengezera mimo sita, ");
INSERT INTO dig_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","na mimo zanjina mbiri za pembe na pembe. Mwenga pembe hino na yanjina pembe hira ko nyuma ya hema. ");
INSERT INTO dig_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Mimo hino ya pembe na pembe zisigbwizanywe ko tsini, indagbwizanywa phamwenga idiniswe ni cho chihunde cha mviringo ko dzulu kpwenye. Zosi mbiri mundazitengeza za kuigana. ");
INSERT INTO dig_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Kpwa jumula, ko mtswerero wa dzuwa kala una mimo minane, na seemu za koloni kumi na sita za feza. Chila mwimo seemu za koloni mbiri.” ");
INSERT INTO dig_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Mlungu achienderera kugomba achiamba, “Uchimala hivyo undatengeza maphalu kumi na tsano ga muhi wa mshita. Maphalu matsano gandakala ga kugbwizanyira iyo mimo ya uphande wa mwakani wa ro hema, ");
INSERT INTO dig_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","matsano gakale ga kugbwizanyira iyo mimo ya uphande wa vurini, na matsano gakale ga kugbwizanyira yo mimo ya uphande wa mtswerero wa dzuwa, ambako ni nyuma ya ro hema. ");
INSERT INTO dig_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Phalu ra kahi-kahi rindatsupa mo kahi-kahi ya yo mimo kula kanda hadi kanda. ");
INSERT INTO dig_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Yo mimo phamwenga na go maphalu, undagapaka zahabu. Chisha iyo mimo undaitengezera bangili za zahabu ndizofunga go maphalu. ");
INSERT INTO dig_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Ro hema ni uritengeze dza viratu nrivyokuonyesa hiko dzulu mwangoni.” ");
INSERT INTO dig_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Mlungu waenderera kugomba achiamba, “Tsona undatengeza paziya. Paziya iyo undaitengeza na katani swafi ya kuhendasukpwa na nyuzi za buluu, za zambarau na za kundu. Paziya iyo naishonerwe marembo ga makerubi, chisha gafumwe vinono ni fundi avimanyaye. ");
INSERT INTO dig_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Paziya iyo ichisira kushonwa, undaitsomeka dzulu ya milingoti mine ya mshita. Milingoti iyo indakala yapakpwa zahabu yosi na i kahi za vihunde vya kuimisira vya feza, na indakala ikainjizwa vihunde vya kutsomekera virivyotengezwa na zahabu. ");
INSERT INTO dig_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Phahi undahala iyo paziya uitsomeke kpwenye hivyo vihunde vya kutsomekera, halafu ukahale hiro sanduku ra ushaidi wedze uriike nyuma ya iyo paziya, ndani ya hipho Phatu Phatakatifu Zaidi, ili iyo paziya iganye na itenge Phatu Phatakatifu kula Phatu Phatakatifu Zaidi. ");
INSERT INTO dig_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Uchila phapho, undahala hicho chihi cha mbazi ubwiningize hiro sanduku ra ushaidi ririro Phatu Phatakatifu Zaidi. ");
INSERT INTO dig_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Iyo meza ya kulavira sadaka ya mikahe, undayiika kondze ya iyo paziya, uphande wa vurini wa iyo hema, ilolane na hicho chinara cha kuikira taa hiko uphande wa mwakani wa hiro hema. ");
INSERT INTO dig_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Hinyo mryango wa hema, undautengezera paziya ikale ndio mryango. Paziya hino indatengezwa na katani ya kusukpwato ya nyuzi za buluu, za zambarau na za kundu. Kazi iyo yosi indahendafumwa na sindano. ");
INSERT INTO dig_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Tsona paziya hino undaitengezera viguzo vitsano vya mshita uvipake zahabu na uviinjize kahi za vihunde vya kuimisira vya shaba. Viguzo vino undaviinjiza vihunde vya kutsomekera vya zahabu. ");
INSERT INTO dig_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Tsona undatengeza phatu pha kulavira sadaka kuhumira mbao za mshita. Ure phamwenga na upana wa phatu hipho undakala sawa-sawa, ure mikono mitsano na upana mikono mitsano. Chimoche chindakala mikono mihahu. ");
INSERT INTO dig_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Undatengeza vihunde vine chivyotulukiza avi ni pembe kpwenye pembe ne za hipho phatu pha kulavira sadaka. Vihunde hivyo vyakutulukiza navikale chitu chimwenga na pho phatu pha kulavira sadaka. Uchimala, phosi phapake shaba. ");
INSERT INTO dig_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Halafu, undatengeza nyungu za kutiira ivu, miko, mabakuli ga shaba, uma za kudungira nyama, na visahani vya kuharira moho. Vitu hivi vyosi undavitengeza na shaba. ");
INSERT INTO dig_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Tsona undatengeza waya wa shaba ndiokala na vyumba-vyumba avi ni chimia. Waya hinyo undautengezera vihunde vine vya mviringo vya shaba uvigbwizanye na zo pembe ne za nyo waya. ");
INSERT INTO dig_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Uchimala hivyo, hala nyo waya uuinjize pho phatu pha kulavira sadaka hata ufike kahi-kahi. ");
INSERT INTO dig_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Chisha tengeza migongo ya mshita uipake shaba. Iyo ndiyo ndiyohumira kutsukurira hipho phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Undaitsomeka yo migongo mo mwenye bangili, mmwenga hiku na mmwenga hiku wakati mnaphotsukula. ");
INSERT INTO dig_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Phahi pho phatu pha kulavira sadaka undaphatengeza na mbao, tsona phandakala taphana hako wala mfwiniko. Phatengeze dza viratu urivyoonyeswa ko dzulu mwangoni.” ");
INSERT INTO dig_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Phahi Mwenyezi Mlungu achienderera kugomba na Musa achimuamba, “Ro hema ra mkpwutano ritengezere muhala. Uphande wa mwakani kundakala na shuka ambazo zichigbwizanywa jumula zindakala na ure wa mikono gana mwenga za kuzibira uphande uho wa muhala. Shuka zizo zindatengezwa na katani swafi ya kuhendasukpwa. ");
INSERT INTO dig_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Zo shuka zindatsomekpwa kpwenye viguzo mirongo miiri, ndivyoinjizwa kpwenye vihunde vya kuimisira mirongo miiri vya shaba. Ela vihunde vya kutsomekera na bangili za vyo viguzo vindakala vya feza. ");
INSERT INTO dig_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Uphande wa vurini nao undakala dza uho wa mwakani. Hizo shukaze zindakala na jumula ya ure wa mikono gana mwenga na zindagbwiririrwa ni viguzo mirongo miiri vya shaba ndivyoinjizwa kpwenye vihundevye vya kuimisira vya shaba. Ela vihundevye vya kutsomekera na vihunde vya mviringo vindakala vya feza. ");
INSERT INTO dig_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Uphande wa mtswerero wa dzuwa wa hinyo uwa, undazibwa na shuka ambazo zichigbwizanywa zindakala na ure wa mikono mirongo mitsano. Shuka hizo zindagbwiririrwa ni viguzo kumi ndivyoinjizwa kpwenye vihundevye vya kuimisira. ");
INSERT INTO dig_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Hiko uphande wa mlairo wa dzuwa wa hinyo muhala, ambako ndiko ndikokala kpwakumenyera, nako kundakala na upana wa mikono mirongo mitsano. ");
INSERT INTO dig_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","Mryango undakala wa shuka mbiri zoganywa sawa-sawa, uphande mmwenga kundakala na shuka ndiyoziba ure wa mikono kumi na mitsano, na uphande wa phiri nao dza vivyo. Chila uphande, kundakala na viguzo vihahu ndivyokala vikainjizwa kpwenye makolo mahahu ga kuimisira. Viguzo hivyo ndivyo ndivyogbwiririra hizo shuka. ");
INSERT INTO dig_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Hipho phatu pha kumenyera pha nyo muhala phandakala na paziya ya katani swafi ya kuhendasukpwa na nyuzi za buluu, za zambarau na za kundu. Paziya iyo indakala na ure wa mikono mirongo miiri, tsona indagbwiririrwa na viguzo vine ndivyoinjizwa kpwenye makolo mane ga kuimisira. ");
INSERT INTO dig_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Viguzo vyosi vya hinyo muhala vindagbwizanywa na vihunde vya mviringo na vihunde vya kutsomekera, na vyosi vindakala vya feza, ela vihunde vya kolo vya kuimisira vya vyo viguzo vindakala vya shaba. ");
INSERT INTO dig_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Kpwa hivyo muhala hinyo undakala na ure wa futi gana mwenga na mirongo mitsano, na upana wa futi mirongo sabaa na tsano, na chimoche chindakala futi sabaa na nusu. Undakala na shuka zoshonwato za katani swafi ya kuhendasukpwa, na makolo ga shaba ga kuimisira vyo viguzo. ");
INSERT INTO dig_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Miyo yanjina yosi ndiyohumika hipho hemani, hata vigingi vya hema na vya nyo muhala, vyosi vindakala vya shaba.” ");
INSERT INTO dig_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Mlungu waenderera kugomba na Musa achimuamba, “Lagiza atu a Iziraeli akurehere mafuha swafi ga zaituni kpwa ajili ya taa, ili taa hizo zienderere kuaka. ");
INSERT INTO dig_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Aruni na anae ndio ndiokala achiasa hizo taa na kuziika kpwenye hema ra mkpwutano kondze ya paziya ya sanduku ra chilagane. Hivi andavihenda mbere za Mwenyezi Mlungu kula dziloni hadi ligundzu. Lagizo hiri ni ra kare na kare kpwa vivyazi vyosi vya ana a Iziraeli.” ");
INSERT INTO dig_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Phahi Mlungu achienderera kugomba na Musa achimuamba, “Niihira mwenenu Aruni phamwenga na anae osi alume, Nadabu, Abihu, Eliazari na Ithamari, kula kahi za hinyo atu a Iziraeli, ili edze ahende kazi ya ulavyadzi-sadaka. ");
INSERT INTO dig_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Undamshonera mwenenu Aruni mavwazi matakatifu ga mlavyadzi-sadaka. Mavwazi higo gandamuhenda akale mnono na mwenye ishima. ");
INSERT INTO dig_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Kaambire atu osi nrioapha ufundi wa kutengeza nguwo amshonere Aruni mavwazi ndigoikirwa mbere ili ahumike kama mlavyadzi-sadaka. ");
INSERT INTO dig_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Vitu ndivyotengeza ni hivi: Chifuko cha chifuwani, chisibao chire, joho, kandzu, chiremba, na mkumbuu. Hivi ndivyo vitu ndivyomtengezera nduguyo Aruni phamwenga na anae alume mavwazi matakatifu, ili anihumikire kama alavyadzi-sadaka. ");
INSERT INTO dig_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Kpwa hivyo andahumira nyuzi za rangi ya zahabu, za buluu, za zambarau, na piya za kundu phamwenga na katani swafi.” ");
INSERT INTO dig_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Mlungu achienderera kugomba na Musa achiamba, “Cho chisibao chire andachitengeza na nyuzi za zahabu, za buluu, za zambarau, na za kundu, na katani swafi yofumwato ni mfumi amanyaye. ");
INSERT INTO dig_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Chisibao hicho chindakala vipande viiri, cha mbere na cha nyuma. Vipande hivyo vindashonwa na mikowa miiri ndiyohumirwa kuvifungira mo mafuzini wakati wa kuvwala. ");
INSERT INTO dig_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Nyo mkumbuu wa cho chisibao, naushonweto dza cho chisibao. Uho nao undatengezwa na nyuzi za rangi ya zahabu, za buluu, za zambarau na piya za kundu, na katani swafi ya kuhendasukpwa. Cho chisibao undachigbwizanya na nyo mkumbuu vikale chitu chimwenga. ");
INSERT INTO dig_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Chisha undahala mawe mairi ga samani gaihwago shohamu uandike madzina ga ana kumi na airi a Iziraeli dzuluye. ");
INSERT INTO dig_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Higo madzina undagaandika kuandzira mvyere hadi mdide. Madzina sita kpwenye dziwe mwenga na sita ganjina kpwenye hiro ranjina. ");
INSERT INTO dig_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Madzina higo ga ana a Iziraeli undagaandika dza vira mutu anayetsusa zahabu atengezavyo muhuri, halafu ugazungulusire marembo ga zahabu. ");
INSERT INTO dig_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Uchimala kuandika go mawe, gagbwizanye na yo mikowa ya mafuzini mwa cho chisibao, gaimirire ana osi a Iziraeli. Kpwa njira ino, Aruni andakala achireha mwakpwe mafuzini madzina gao mbere za Mwenyezi Mlungu, nago gandakala gachinitambukiza atu angu siku zosi. ");
INSERT INTO dig_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Phahi uchila phapho, tengeza vifwiniko vidide viiri vya zahabu, ");
INSERT INTO dig_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","na mikufu miiri ya zahabu swafi ya kuhendasukpwa avi ni lugbwe. Chisha undahala iyo mikufu uilundzanye na hivyo vifwiniko.” ");
INSERT INTO dig_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Chisha Mwenyezi Mlungu achienderera kugomba achiamba, “Tsona undatengeza chifuko cha chifuwani cha mlavyadzi-sadaka. Chifuko hicho ni cha kumanyisira mendzwa ya Mlungu. Undachitengeza na nyuzi za zahabu, za buluu, za zambarau, za kundu na katani swafi ya kusukpwa, dza cho chisibao. Kazi hino ni ihendwe ni mutu aimanyaye. ");
INSERT INTO dig_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Chifuko hicho chindatengezwa na chitambaa cha kukundzwa kano mbiri. Urewe undakala sawa-sawa na upanawe, kuno robo ya mkpwono, kuno robo ya mkpwono. ");
INSERT INTO dig_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Chichisira kushonwa undachibandika miraba mine ya mawe ga samani. Mraba wa mwandzo undakala na mawe gaihwago akiki, topazi na alimasi ya kundu. ");
INSERT INTO dig_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Mraba wa phiri undakala na mawe gaihwago zumaridi, yakuti ya buluu na alimasi, ");
INSERT INTO dig_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","mraba wa hahu, undakala na mawe gaihwago jasinitho, akiki ya kundu na amethisito, ");
INSERT INTO dig_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","na mraba wa ne, undakala na mawe ga zabarajadi, shohamu na jasipa. Mawe gaga gosi gandabandikpwa kpwenye vihunde vya zahabu vya mviringo. ");
INSERT INTO dig_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Chila dziwe, kahi za higo mawe kumi na mairi, rindaandikpwa dzina mwenga ra madzina kumi na mairi ga ana a Iziraeli. Madzina higo gandaandikpwa dza vira mutu anayetsusa zahabu atengezavyo muhuri, na gandaimirira mbari zosi za Iziraeli. ");
INSERT INTO dig_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Tsona, undatengeza mikufu miiri ya zahabu swafi ya kuhendasukpwa dza lugbwe, kpwa ajili ya cho chifuko. ");
INSERT INTO dig_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Uchimala hivyo undatengeza pete mbiri za zahabu uzigbwizanye na iyo mitse miiri ya dzulu ya cho chifuko, chimwenga mutse hinyu, chimwenga mutse hinyu. ");
INSERT INTO dig_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Chisha undahala iyo mikufu miiri uilundzanye na hizo pete mbiri zirizo katika iyo mitse miiri ya cho chifuko. ");
INSERT INTO dig_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Hizo tsa za mikufu ziserezo undazifunga na hizo pete za marembo zirizogbwizanywa na higo mawe mairi ga shohamu himo tsani. Nawe uchihenda hivyo undakala iyo mikufu ukaigbwizanya na iyo mikowa ya mbere ya cho chisibao mo mafuzini. ");
INSERT INTO dig_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Uchila phapho tengeza pete mbiri za zahabu uzigbwizanye na iyo mitse miiri ya tsini ya cho chifuko. Mitse iyo ni ya cho chiseemu cha ndani ndicholarira cho chisibao. ");
INSERT INTO dig_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Chisha undatengeza pete mbiri tsona za zahabu, uzigbwizanye na hizo tsa mbiri za mbere, zirizo tsini ya cho chisibao, dzulu ya hinyo mkumbuu wa kushonwato. ");
INSERT INTO dig_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Phahi undahala zo pete za cho chifuko cha chifuwani uzifunge na zo pete za chisibao ili cho chifuko chisikale rejereje, ela chikaleto dzulu ya hinyo mkumbuu. Pete hizo undazifunga na uzi wa buluu. ");
INSERT INTO dig_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Kpwa hivyo, chila wakati Aruni ndiphoinjira hipho Phatu Phatakatifu, andakala phakpwe chifuwani akavwala hicho chifuko cha kumanyisira mendzwa ya Mlungu, na chihivyo andakala achinitambukiza mimi Mwenyezi Mlungu kuhusu ana a Iziraeli tsona na tsona kutsupira higo madzina garigo himo chifukoni. ");
INSERT INTO dig_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Phahi undahala higo mawe ga kumanyisira mendzwa ya Mlungu, ugainjize himo chifukoni, ili chila wakati Aruni edzapho mbere za Mwenyezi Mlungu gakale hipho phakpwe chifuwani. Kpwa hivyo siku zosi Aruni andakala achitsukula phakpwe chifuwani mendzwa ya Mlungu kuhusu atu a Iziraeli.” ");
INSERT INTO dig_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Mlungu achienderera kugomba achiamba, “Iyo kandzu ndiyovwalwa na cho chisibao naishonwe na uzi wa buluu yosi. ");
INSERT INTO dig_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Kandzu iyo indakala na singo ya kahi-kahi, na iyo singo yosi indazungulusirwa mshono wa nyuzi sedze ikatsanika-tsanika. ");
INSERT INTO dig_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","34","Uchimala hivyo tengeza kengele za zahabu na marembo ga makomamanga ga kufumwa na nyuzi za buluu, za zambarau na za kundu, uziinjize kpwenye ro pindo ra tsini ra iyo kandzu. Hipha kengele hipha komamanga, hipha kengele hipha komamanga, hata ro pindo rosi urimale kurizungulusira kengele na makomamanga. ");
INSERT INTO dig_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Phahi indakala chila wakati Aruni ainjirapho kahi za Phatu Phatakatifu kuhumika mbere zangu mimi Mwenyezi Mlungu, andakala akavwala hiro vwazi ra uzi wa fulana, na atu andamsikira vyo ainjiravyo na vyo atulukavyo, sedze akafwa. ");
INSERT INTO dig_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Tsona undatengeza chibamba cha zahabu swafi na uchiandike dza vira mutu anayesuwa zahabu atengezavyo muhuri, MTAKATIFU WA MWENYEZI MLUNGU. ");
INSERT INTO dig_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Uchimala hivyo hala hicho chibamba uchifunge mbere za cho chiremba na mkpwowa wa buluu. ");
INSERT INTO dig_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Phahi Aruni andakala achivwala chibamba hicho phakpwe chilanguni wakati wosi, ili akale achihala makosa ndigohendwa ni Aiziraeli dzulu ya vitu vyosi ndivyolavya sadaka takatifu kpwa Mlungu, ili Mwenyezi Mlungu aweze kuvikubali.” ");
INSERT INTO dig_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Chisha Mlungu achienderera kugomba na Musa achimuamba, “Uchimala hivyo mfumire Aruni kandzu na chiremba na mkumbuu. Iyo kandzu na cho chiremba vindafumwa na katani swafi, nyo mkumbuu undafumwa na marembo-marembo. ");
INSERT INTO dig_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Uchimala kumshonera hiye ise yao, hinyo ana nao undaashonera kandzu za kufika pazini, mikanda, na kofiya, ili akale anono na akale na ishima. ");
INSERT INTO dig_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Phahi higo mavwazi gosi undamvwika mwenenu Aruni na anae, halafu uamwagire mafuha na uabandikire mikono, uaike mbere zangu na uatakase ili anihendere kazi ya ulavyadzi-sadaka. ");
INSERT INTO dig_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Tsona undaashonera suruwale fupi za ndani za katani avwale sedze akakala chitsaha. Suruwale hizo zindaandzira chibiruni hadi nyongani. ");
INSERT INTO dig_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aruni na anae andavwala suruwale hizo chila ndiphoinjira kpwenye hema ra mkpwutano, au kpwedza phatu pha kulavira sadaka kuhenda kazi ya ulavyadzi-sadaka kahi za Phatu Phatakatifu. Nao andahenda hivi sedze akamkosera Mlungu kpwa kukala chitsaha mbereze, naye akaaolaga. Na Aruni na chivyaziche chosi andalunga lagizo hiri siku zosi.” ");
INSERT INTO dig_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Phahi Mlungu achienderera kugomba na Musa achimuamba, “Wakati ndiphofika wa kuika mbere Aruni na anae alume, ili anihendere kazi ino ya ulavyadzi-sadaka, hala mwana ndzau na maturume mairi ambago taganavirema ugaike kanda. ");
INSERT INTO dig_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Chisha uphahe mikahe isiyo hamira, na keki zisizo hamira zirizovugbwa na mafuha, na bisikuti zisizo hamira, zakuhenda kupakpwa mafuha. Vitu hivi vyosi vikale vya kukandwa na unga wa tsiki wa nganu. ");
INSERT INTO dig_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Undahala iyo mikahe, na hizo keki, na zo bisikuti uziinjize kaphuni, wedze nazo phamwenga na hiye mwana ndzau, na higo maturume mairi. ");
INSERT INTO dig_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Tsona, uchila phapho, undamuhala Aruni na anae alume, wedze utiye madzi uaogese hipho mryango wa hiro hema ra mkpwutano. ");
INSERT INTO dig_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Uchimala kuaogesa, muhale Aruni umvwike hizo nguwoze. Kpwandza kabisa undamvwika joho na kandzu ya uzi wa fulana ivwalwayo na hicho chisibao chire, halafu umvwike hicho chisibao chenye, na hicho chifuko cha lagani. Uchimala hivyo hala hinyo mkumbuu wa kushonwato umfunge himo chibiruni. ");
INSERT INTO dig_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Uchila phapho hala hicho chiremba umvwike chitswani, halafu uhale hicho chibamba cha chilanguni chirichoandikpwa maneno gaambago, mtakatifu kpwa Mwenyezi Mlungu uchifunge himo chirembani. ");
INSERT INTO dig_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Phahi uchimala kuhenda hivyo vyosi, hala higo mafuha ga utakaso ummwagire Aruni chitswani umuinjize kpwenye kazi yangu. ");
INSERT INTO dig_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","“Uchila phapho, nyo ana nao ahendere dza vivyo, avwike kandzu, ");
INSERT INTO dig_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","uafunge mikumbuu vibiruni na viremba. Na hivyo ndivyo ndivyotenga Aruni na anae kpwa kuabandikira mikono ili akale alavyadzi-sadaka siku zosi. ");
INSERT INTO dig_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Phahi uchikala ukamala kuavwika, hala hiye mwana ndzau umrehe hipho mryango wa hema ra mkpwutano ndimokala Aruni na anae, edze aike mikono yao dzulu ya chitswache, ");
INSERT INTO dig_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","halafu umtsindze phapho mbere za Mwenyezi Mlungu phapho mryango wa hema ra mkpwutano. ");
INSERT INTO dig_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Chisha undahala iyo milatso ya hiye mwana ndzau uigute na chala, upake pembe za phatu pha kulavira sadaka, iyo ndiyosala yosi uimwage hipho tsini ya phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Halafu undahala higo marunya, chala cha ini, figo zosi mbiri phamwenga na marunyage, uvioche vyosi dzulu ya pho phatu pha kulavira sadaka hadi viphye tse. ");
INSERT INTO dig_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Ela hizo nyama, chingo na ufumba wa ndzau hiye, undavihala ukavioche kondze ya iyo kambi; na iyo ndiyo sadaka ya kuusa makosa. ");
INSERT INTO dig_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Uchimala hivyo hala turume mwenga urirehe mbere za Aruni na anae ili aweze kuika mikono yao dzulu ya chitswa cha turume hiro. ");
INSERT INTO dig_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Uchimala kuhenda hivyo, hala hiro turume uritsindze halafu uhale iyo milatsoye uitimvye-timvye chila uphande wa pho phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Hiro turume renye naro, undarikata-kata vipande-vipande, uhale hivyo vya ndani na marondo uvitsukutse hata viere, halafu uvihale uvikusanye phamwenga na hicho chitswa, na hivyo vipande vya nyama uviike ");
INSERT INTO dig_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","dzulu ya hipho phatu pha kulavira sadaka uvioche, mana hino ndiyo sadaka ya kuochwa ndiyonilavira kpwa kuhendaiocha nayo ni zawadi yenye kungu nono kpwangu mimi Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Uchila phapho, Aruni na anae naaike mikono yao dzulu ya chitswa cha hiro turume ranjina, kabila ya kuritsindza. ");
INSERT INTO dig_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Alafu uchikala ukaritsindza, hala seemu ya milatso umpake Aruni phamwenga na anae, chila mmwenga mupake kpwenye ndewe ya sikirore ra kulume, dzalagumbe ra mkpwonowe wa kulume, na dzalagumbe ra chiguluche cha kulume. Iyo milatso ndiyosala undaihala utimvire-timvire hipho phatu pha kulavira sadaka chila uphande. ");
INSERT INTO dig_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Chisha undahala milatso michache kula katika hipho phatu pha kulavira sadaka na mafuha machache ga kupaka, umtimvire-timvire Aruni na anae, phamwenga na nguwo zao, ili iye, na anae akale atakatifu phamwenga na nguwo zao. ");
INSERT INTO dig_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Phahi uchila phapho, hala higo marunya gosi ga hiro turume, yani mchira wenye marunya, na marunya ga ndanini, chala cha ini, hizo figo na marunyage na hicho chiga cha kulume (mana hiyu ndiye turume wa kuikira mbere alavyadzi-sadaka.) ");
INSERT INTO dig_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Tsona undafwenula iyo kaphu ya mikahe isiyotiywa hamira, iriyo pho mbere za Mwenyezi Mlungu, utuluze mkpwahe mmwenga uriokandwa na mafuha, keki mwenga, na bisikuti mwenga. ");
INSERT INTO dig_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Vitu hivi undaagbwiza Aruni na anae mwao mikononi, aviunule dzulu ili amlavire Mwenyezi Mlungu sadaka ya kuunulwa. ");
INSERT INTO dig_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Achimala kuviunula vihale uvioche phamwenga na iyo sadaka ya kuochwa dzulu ya hipho phatu pha kulavira sadaka. Hino ni zawadi yenye kungu nono imuhamirayo Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Chisha, undahala iyo laga ya hiro turume ra kumuikira mbere Aruni, uchiunule dzulu ulavye sadaka ya kuunulwa kpwa Mwenyezi Mlungu. Na uho ndio ndiokala mtaloo.” ");
INSERT INTO dig_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Chisha phahi Mlungu achienderera kugomba na Musa achimuamba, “Undatakasa hiro laga ndirokala rikalaviwa sadaka ya kuunula, na hicho chiga cha hiye turume wa kuaikira mbere Aruni na anae, uviike mbere ili vikale mtalo wa Aruni na anae. ");
INSERT INTO dig_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Nao ana a Iziraeli andaenderera kulavya vitu hivi kpwa Aruni na anae siku zosi. Kpwa sababu hinyu ndio ndiokala mtalo wa alavyadzi-sadaka ndiolaviwa ni Aiziraeli dza mtsango wao wa iyo sadaka ya amani kpwa Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Siku Aruni achifwa, nguwoze takatifu za kulavira sadaka zindahalwa ufwa ni anae, nao andazivwala wakati wa kumwagirwa mafuha na kuikpwa mbere za Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Iye mwana wa Aruni ndiyehala phatu pha ise, andakala achivwala hizo nguwo siku sabaa wakati ainjirapho hema ra mkpwutano na kumuhumikira Mwenyezi Mlungu katika hipho Phatu Phatakatifu. ");
INSERT INTO dig_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Phahi uchikala ukamala kuika mbere hizo nyama za hiye turume wa kuikirwa mbere Aruni na anae, zijite kahi za pho Phatu Phatakatifu ");
INSERT INTO dig_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","halafu Aruni na anae azirye phamwenga na mikahe iriyo mo kaphuni, kahi za phatu pha kumenyera hema ra mkpwutano. ");
INSERT INTO dig_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Navyo hivyo ndivyorya ni vitu vitakatifu, kpwa hivyo phahi, visiriwe ni mutu wanjina yeyesi isiphokala aho kare ndiokala akavihumira kuusirwa makosa na kuikirwa mbere. ");
INSERT INTO dig_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Na kpwa sababu vitu hivyo ni vitakatifu, chitu chochosi ndichosala hata ligundzu, ikale mkpwahe au nyama nachiochwe, isiriwe. ");
INSERT INTO dig_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Iyo shuuli ya kumuika mbere Aruni na anae undaihenda kpwa siku sabaa. Nawe undaaika mbere kulengana na hivyo nrivyolagiza. ");
INSERT INTO dig_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Katika hizo siku sabaa undakala uchilavya ndzau chila siku ili ikale sadaka ya makosa. Sadaka hino ndiyo ndiyotakasa hipho phatu pha kulavira sadaka, halafu undaphatenga kpwa kuphamwagira mafuha. ");
INSERT INTO dig_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Undahenda hivi chila siku hadi hizo siku sabaa zisire. Nawe uchimala hivyo, hipho phatu pha kulavira sadaka phandakala phatakatifu sana hata chitu chochosi ndichoikpwa hipho dzuluye nacho chindakala chitakatifu. ");
INSERT INTO dig_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Chila siku undakala uchilavya ana turume airi a mwaka mmwenga-mmwenga, ili akale sadaka hipho phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Mwana turume mmwenga undamlavya sadaka ligundzu na hiye wanjina undamlavya dziloni. ");
INSERT INTO dig_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","41","Chila mwana turume ndiyemlavya ligundzu na dziloni, undamlavya phamwenga na pishi mwenga ya unga wa tsiki wa mtsere, ndioutsanganya na tupa mwenga ya mafuha ga zaituni. Tsona ulavye tupa mwenga ya uchi wenu wa zabibu ikale sadaka ya chinwadzi. Vitu hivi undaviocha ili vikale sadaka yenye kungu nono kpwangu mimi Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Sadaka hino ya kuocha, indakala ichilaviwa mbere zangu mimi Mwenyezi Mlungu, pho mryango wa hema ra mkpwutano, siku zosi. Na phapho ndipho ndiphoonana namwi na kugomba nawe, ");
INSERT INTO dig_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Tsona phapho ndipho ndiphoonana na Aiziraeli na mwanga wangu undaphahenda phatakatifu. ");
INSERT INTO dig_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Nindahala hiro hema ra mkpwutano, na hipho phatu pha kulavira sadaka, nivihende vitakatifu phamwenga na Aruni na anae, ili anihendere kazi ya kulavya sadaka. ");
INSERT INTO dig_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Phahi chihivyo, nindasagala phamwenga na ana a Iziraeli nami nindakala Mlungu wao. ");
INSERT INTO dig_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Na phapho ndipho ndiphomanya kukala mimi, ndimi Mwenyezi Mlungu, Mlungu wao niriyeatuluza tsi ya Misiri, ili nisagale phamwenga nao. Mimi, ndimi Mwenyezi Mlungu, Mlungu wao.” ");
INSERT INTO dig_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Chisha phahi Mlungu achienderera kugomba na Musa achimuamba, “Undatsonga phatu pha kulavira sadaka pha muhi wa mshita pha kufukizira uvumba. ");
INSERT INTO dig_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Ure phamwenga na upana wa phatu hipho pha kulavira sadaka undakala sawa-sawa tse, kuno mkpwono, kuno mkpwono. Chimoche chindakala mikono miiri. Hizo pembe za hipho phatu pha kulavira sadaka zindakala chitu chimwenga na hipho phatu phenye pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Uchimala kuchitsonga, chipake zahabu swafi chosi, kuandzira dzulu, na pande zosi ne na pembe zosi. Uchimala hivyo chitengezere mkpwungo wa marembo-marembo ga zahabu kuchizunguluka. ");
INSERT INTO dig_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Uchila phapho tengeza bangili ne za mviringo za zahabu uzigbwizanye na hipho phatu pha kulavira sadaka tsini ya hinyo mkpwungo, uphande huno mbiri, uphande huno mbiri. Bangili zizi ndizo ndizotiywa iyo migongo ya kutsukurira hipho phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Uchimala hivyo, tengeza iyo migongo ya muhi wa mshita ndiyoinjizwa himo mwenye bangili za mviringo, yosi uipake zahabu. ");
INSERT INTO dig_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Uchimala kutengeza hipho phatu pha kulavira sadaka, phahale uphaike mbere za iyo paziya iriyo phephi na hiro sanduku ra chilagane, mbere za hicho chihi cha mbazi ambapho ndipho hundiphokala huchionana. ");
INSERT INTO dig_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","8","Phahi Aruni andakala achifukiza uvumba ligundzu-ligundzu aphiyapho kpwendatayarisha taa, na dziloni-dziloni aphiyapho kpwendaziasa. Na sadaka hino ya uvumba kpwa Mwenyezi Mlungu, indakala ichilaviwa wakati wosi katika vivyazi vyenu vyosi. ");
INSERT INTO dig_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Ela phahi, msifukize uvumba wowosi usioruhusiwa, au kulavya sadaka ya chakurya au ya madzi dzulu ya hipho phatu pha kufukizira uvumba. ");
INSERT INTO dig_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Na kpwa sababu phatu hipho pha kulavira sadaka phandakala phatakatifu sana kpwangu mimi Mwenyezi Mlungu, Aruni andakala achiphatakasa limwenga chila mwaka kahi ya vivyazi vyenu vyosi. Andahumira milatso ya sadaka ya kuusa makosa kuphatakasa.” ");
INSERT INTO dig_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Phahi Mwenyezi Mlungu achienderera kugomba na Musa achimuamba, ");
INSERT INTO dig_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Undiphoaolanga ana a Iziraeli, chila mutu andalavya sadakaye kpwa Mwenyezi Mlungu kpwa sababu ya kuolangbwa sedze akagbwirwa ni makongo mai. ");
INSERT INTO dig_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Na chila mutu ndiyemuolanga, andalavya nusu shekeli yani kama giramu sita za feza kpwa Mwenyezi Mlungu, kulengana na chipimo cha Phatu Phatakatifu (shekeli mwenga ambayo ni sawa na gera mirongo miiri). ");
INSERT INTO dig_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Chila mutu ndiyekala akafisa miaka mirongo miiri kpwenderera mbere, uchimuolanga sharuti anilavire mimi Mwenyezi Mlungu sadaka iyo. ");
INSERT INTO dig_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Chila mutu, akale ni tajiri au mchiya, andalavya hizo giramu sita za feza kpwa Mwenyezi Mlungu. Sedze matajiri akalavya zaidi au achiya akalavya tsini ya chipimo hicho cha sadaka ya kudzikombola. ");
INSERT INTO dig_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Undaphokera pesa za sadaka ya kudzikombola kula kpwa Aiziraeli, nawe uchimala kuziphokera, zihumire kpwa kazi katika hiro hema ra mkpwutano. Na lola, sadaka iyo indaatambukiza Aiziraeli mbere za Mwenyezi Mlungu kukala, ni sadaka ya kukombola maisha gao.” ");
INSERT INTO dig_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Phahi Mwenyezi Mlungu achienderera kugomba na Musa achimuamba, ");
INSERT INTO dig_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Tsona undaunda simikiro ya kutawazira. Hiro birika renye phamwenga na maguluge gandakala ga shaba. Uchimala kuritengeza undaritiya madzi uriike kahi-kahi ya hiro hema ra mkpwutano, na hipho phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Phahi Aruni na anae andakala achioga mikono na magulu gao hipho birikani ");
INSERT INTO dig_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","chila ndiphokala analonda kuinjira kpwenye hema ra mkpwutano, au ndiphokala analonda kumlavira Mwenyezi Mlungu sadaka ya kuochwa, sedze akafwa. ");
INSERT INTO dig_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Na hino indakala shariya kpwa Aruni, na anae, na chivyaziche chosi kukala, sharuti asinge mikono yao na magulu gao mana asiphohenda hivyo phahi andafwa.” ");
INSERT INTO dig_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Chisha Mwenyezi Mlungu achienderera kugomba na Musa, achimuamba, ");
INSERT INTO dig_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Hivi phahi ndivyo vilungo vinono ndivyohumira kutengezera mafuha ga utakaso: Manemane ga madzi ga chiasi cha kilo sita, mdalasini wa kunukato wa chiasi cha kilo tahu, na miwa ya kunukato, kilo tahu, ");
INSERT INTO dig_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","na kilo sita za kasiya na lita ne za mafuha ga zaituni. Vipimo vyosi vindakala kulengana na chipimo cha Phatu Phatakatifu. ");
INSERT INTO dig_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Uchiphaha vilungo hivi vyosi vitsanganye chiufundi ili uphahe mafuha matakatifu kula kpwa nyo mtsanganyiko wa vyo vilungo. ");
INSERT INTO dig_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Kpwa kuhumira higo mafuha matakatifu, undarimwagira mafuha hema ra mkpwutano na sanduku ra chilagane, ");
INSERT INTO dig_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","na iyo meza phamwenga na miyoye yosi; na hicho chinara cha kuikira taa phamwenga na miyoye; na hipho phatu pha kufukizira uvumba. ");
INSERT INTO dig_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","Tsona undamwagira mafuha hipho phatu pha kulavira sadaka ya kuochwa, na miyoye yosi; na yo simikiro ya kutawazira phamwenga na maguluge. ");
INSERT INTO dig_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","“Phahi vitu hivi undavihala uviike mbere ili vikale vitakatifu kabisa, hata chitu chochosi ndichoviguta nacho chikale chitakatifu. ");
INSERT INTO dig_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Uchimala hivyo undamuhala Aruni na anae uamwagire mafuha nao na uaike mbere, uahende atakatifu ili anihendere kazi ya kulavya sadaka. ");
INSERT INTO dig_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Phahi undaambira ana a Iziraeli kukala higo ndigo mafuha matakatifu ga kupaka ndigohumirwa siku zosi. ");
INSERT INTO dig_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Mafuha higo phahi msigahumire kuamwagira atu bure au kudzipaka dza mafuha ga kawaida. Wala mutu asidzitengezere dza gago kpwa sababu mafuha higo gandakala ni matakatifu kpwenu. ");
INSERT INTO dig_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Na mutu yeyesi ndiyetengeza mafuha dza higo, au ndiyemmwagira, au kupaka mutu asiye mlavyadzi-sadaka, andatengbwa na ana a Iziraeli tsetsetse.” ");
INSERT INTO dig_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Chisha phahi Mwenyezi Mlungu achienderera kugomba, achimuamba Musa, “Uchila phapho tengeza uvumba wa kufukiza, kpwa kuhumira chipande cha kunukato cha muhi uihwao natafi, na cha muhi uihwao shekeleti, na cha kelibina na ubani wenye. Vipimo vya vilungo hivi vyosi navikale sawa-sawa tsetsetse. ");
INSERT INTO dig_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Chisha endza fundi avitsanganye hivi vilungo vyosi atengeze uvumba. Mtsanganyiko huno andautiya munyu autsunge ili ukale mswafi na mtakatifu. ");
INSERT INTO dig_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Phahi uchimala hivyo nyaha mchache uusage tsikitsiki kabisa, halafu uuhale uwiike mbere za hiro sanduku ra chilagane katika hiro hema ra mkpwutano hundiphokala huchionana. Na lola, uvumba hinyo undakala mtakatifu sana kpwenu mwimwi. ");
INSERT INTO dig_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Na kpwa kukala uvumba hinyo kpwenu mwimwi undakala ni mtakatifu kpwa Mwenyezi Mlungu, mutu asitengeze uvumba dza hinyo mkauhumira enye. ");
INSERT INTO dig_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Na mutu yeyesi ndiyetengeza uvumba dza hinyo kpwa mahumizige mwenye, andatengbwa kabisa na ana a Iziraeli.” ");
INSERT INTO dig_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Mwenyezi Mlungu wamuamba Musa, ");
INSERT INTO dig_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Nikamtsambula Bezaleli mwana wa Uri, mdzukulu wa Huri, wa mbari ya Juda. ");
INSERT INTO dig_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Nkamuodzaza na Roho wangu ili akale na uwezo wa kumanya aina zosi za ufundi, ");
INSERT INTO dig_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","ili aweze kutengeza miundo minji ya vitu vya zahabu, feza na shaba. ");
INSERT INTO dig_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Nkamupha ujuzi wa kutsonga mawe ga marembo, kutsonga vitu vya muhi na kutengeza vitu vya chila aina ya ufundi. ");
INSERT INTO dig_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Piya nikamtsambula Oholiabu mwana wa Ahisamaki wa mbari ya Dani akale msaidiziwe. Tsona nkagapha ujuzi mafundi gosi ili gahende chila chitu nrichokulagiza. ");
INSERT INTO dig_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","“Tengeza Hema ra Mkpwutano; Sanduku ra Ushaidi phamwenga na chihi cha mbazi dzuluye; na vitu vyosi ni vikale ndani ya Hema. ");
INSERT INTO dig_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","“Piya tengeza meza na miyoye yosi; chinara cha kuikira taa cha zahabu swafi na miyoye yosi; na phatu pha kulavira sadaka pha kufukizira uvumba. ");
INSERT INTO dig_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","Chisha utengeneze phatu pha kulavira sadaka za kuochwa na miyoye yosi, na simikiro ya kutawazira phamwenga na phatuphe pha kuikira. ");
INSERT INTO dig_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Tayarisha nguwo zoshonwa vinono, chisha ushone mavwazi matakatifu ga Aruni mlavyadzi-sadaka na anae kpwa kazi zao kama alavyadzi-sadaka. ");
INSERT INTO dig_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Na mwisho tayarisha higo mafuha ga utakaso; na uvumba unukao vinono kpwa ajili ya phatu phatakatifu. Atu hinyo ni ahende kulengana na nrivyokulagiza.” ");
INSERT INTO dig_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Phahi Mwenyezi Mlungu wamuamba Musa, ");
INSERT INTO dig_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Aambire atu a Iziraeli: Ni lazima mlunge shariya ya Siku yangu ya Kuoya, sababu iyo ndiyo ishara yangu na mwimwi na vivyazi vyenu vyosi, ili mmanye kukala ndimi Mwenyezi Mlungu ninayekutakasani. ");
INSERT INTO dig_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Ni lazima mlunge shariya ya Siku ya Kuoya, kpwa sababu ni takatifu. Mutu yeyesi ndiyeivundza ni aolagbwe, na ndiyehenda kazi siku iyo ya kuoya, naatengbwe kure na ana a Iziraeli. ");
INSERT INTO dig_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Kuna siku sita ambazo munaweza kuhenda kazi zenu, ela siku ya sabaa ni Siku ya Kuoya, siku iriyotengbwa kpwa sababu ya Mwenyezi Mlungu. Mutu yeyesi ndiyehenda kazi ya aina yoyosi siku iyo, ni aolagbwe. ");
INSERT INTO dig_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Atu a Iziraeli ni alunge shariya za Siku ya Kuoya. Andaisherekeya hata vivyazi vyosi vyedzavyo dza ishara ya chilagane cha kare na kare. ");
INSERT INTO dig_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Ni ishara ya kudumu kahi-kahi ya atu a Iziraeli na mimi, Mwenyezi Mlungu. Kpwa sababu náumba mlunguni na tsi siku sita, na nchiricha kuhenda kazi siku ya sabaa, ichikala ya kuoya.” ");
INSERT INTO dig_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Mwenyezi Mlungu ariphomala kugomba na Musa hiko Mwango Sinai, wamupha Musa myalawe miiri ya ushaidi, ambayo ye mwenye kala akaiandika shariyaze. ");
INSERT INTO dig_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Aiziraeli ariphoona Musa akakala muda munji hiko mwangoni bila ya kutserera, akusanyika phamwenga na Aruni na achimuamba, “Tahumanya ririromphaha ye Musa ariyehutuluza Misiri. Phahi, huumbire milungu ambayo indahulongoza.” ");
INSERT INTO dig_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Naye Aruni achiaamba, “Avuleni achetu enu na ana enu vipuli vya zahabu virivyo masikironi mwao, munirehere.” ");
INSERT INTO dig_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Kpwa hivyo atu osi avula vipuli vya zahabu virivyokala mwao masikironi, na achivireha kpwa Aruni. ");
INSERT INTO dig_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Aruni wahala zahabu zohewa achiziyayusha na achizitengeza chizuka mfwano wa mwana ndzau, kuhumira chifwaya. Ndipho Aiziraeli achiambirana, “Enehu, hino ni milungu yehu iriyohulavya Misiri.” ");
INSERT INTO dig_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Aruni ariphoona higa, wadzenga phatu pha kulavira sadaka mbere za chira chizuka cha mwana ndzau na achitangaza achiamba, “Muhondo indakala sikukuu ya kumtogola Mwenyezi Mlungu.” ");
INSERT INTO dig_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Phahi siku ya phiriye ligundzu Aiziraeli arauka chiti na achilavya sadaka za kuochwa na sadaka za amani. Halafu achirya na achinwa, chisha achiunuka achivwina. ");
INSERT INTO dig_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Hipho Mwenyezi Mlungu wamuamba Musa, “Tserera, sababu atuo, urioatuluza kula Misiri, akahenda dambi na akadzitiya uyi. ");
INSERT INTO dig_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Akaricha malagizo gangu ambago naalagiza na akadzitengezera chizuka chiricho na umbo ra mwana ndzau. Achichiabudu na kuchilavira sadaka na kuamba, ‘Enehu, hino ni milungu yehu, mwimwi Aiziraeli iriyokutuluzani kula Misiri.’ ” ");
INSERT INTO dig_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Na Mwenyezi Mlungu achimuamba Musa, “Nikaaona hinya atu. Ni atu a vitswa vigumu, asiosikira. ");
INSERT INTO dig_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Hivi sambi niricha nikareya sana na nindaangamiza. Ela sindakuangamiza, ela vivyazivyo nindavihenda taifa kulu.” ");
INSERT INTO dig_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Ela Musa wamlalamikira Mwenyezi Mlungu, Mlunguwe, na achiamba, “We Bwana, wahuokola kula Misiri na nguvu na uwezo mkpwulu. Kpwa utu wani ukatsukizwa ni atuo? ");
INSERT INTO dig_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Usiriche Amisiri aambe kukala waalongoza atuo kula Misiri, uchikala na maazo ga kuaolaga hiku mwangoni na kuaangamiza tsetsetse. Richa kukala msiru! Galuza nia na usiarehere atuo shaka. ");
INSERT INTO dig_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Tambukira urichoapira atumishio Burahimu, Isaka na Jakobo. Uchiamba undaapha vivyazi vinji dza zirivyo nyenyezi hiko mlunguni na kuapha vivyazi vyao vyosi tsi uriyoahidi ikale yao hata kare na kare.” ");
INSERT INTO dig_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Phahi Mwenyezi Mlungu wagaluza nia na kayaarehera shaka ambaro kala akatishira kurehera atue. ");
INSERT INTO dig_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Musa watserera kula ko mwangoni kuno akatsukula myalawe miiri ya ushaidi ambayo kala ikaandikpwa pande zosi. ");
INSERT INTO dig_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Mlungu mwenye kala akaihenda na achiiandika kpwa kutsonga shariyaze. ");
INSERT INTO dig_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Joshuwa ariphosikira hoyo ra hara atu anapiga kululu, wamuamba Musa, “Kuna hoyo ra viha hiko kambini.” ");
INSERT INTO dig_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Musa wajibu achiamba, “Sisikira hoyo ra ushindi ama kushindwa. Ela nasikira dza hoyo ra kusherekeya.” ");
INSERT INTO dig_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Musa ariphofika phephi na kambi, waona chizuka cha mwana ndzau na hara atu anavwina, achitsukirwa sana. Achiibwaga photsi hira myalawe, ichivundzika tsini ya mwango. ");
INSERT INTO dig_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Na Musa achihala yuya mwana ndzau ambaye amtengeza achimuocha na moho. Halafu achimsaga hadi achikala unga, achiunyunyizira madzini na achiahendesa Aiziraeli anwe gara madzi. ");
INSERT INTO dig_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Musa wamuamba Aruni, “Atu hano akakuhendani? Akakuhendadze, hata ukaatiya dambi kulu vino?” ");
INSERT INTO dig_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aruni achijibu achiamba, “Usinitsukirirwe bwana wangu, kpwa sababu unamanya vira atu arivyo. Chila mara nkulonda kuhenda mai. ");
INSERT INTO dig_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Aniamba, ‘Tahumanya ririromphaha Musa ariyehutuluza Misiri. Phahi, huumbire milungu ambayo indahulongoza.’ ");
INSERT INTO dig_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Ndipho nchiaambira, ‘Ariye na marembo ga zahabu naagalavye.’ Hipho anipha ira zahabu nami nchiitiya mohoni, nayo ichituluka hiyu mwana ndzau.” ");
INSERT INTO dig_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Musa waona kukala Aruni kala akaricha atu ahende mambo mai amendzavyo na achikala chitu cha kutsekpwa ni maadui gao. ");
INSERT INTO dig_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Phahi Musa waima ryango ra kuinjirira kambini na achiamba, “Ariye uphande wa Mwenyezi Mlungu naedze hipha niripho.” Nao Alawi osi achimlunga. ");
INSERT INTO dig_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Hipho wagomba nao achiaambira, “Hivi ndivyo Mwenyezi Mlungu, Mlungu wa Iziraeli, aambavyo: ‘Chila mutu naahale upangawe. Aphiye kula ryango hiri hadi rira ranjina muaolage ndugu zenu a chilume, asena enu na majirani genu.’ ” ");
INSERT INTO dig_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Alawi ahenda dza arivyolagizwa ni Musa na karibu atu elufu tahu afwa siku iyo. ");
INSERT INTO dig_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Ndipho Musa achiambira Alawi, “Hino rero mukamuogopha Mwenyezi Mlungu kpwa hivyo mukatengbwa kpwa ajili ya Mlungu. Ikakala vigumu kusaonera mbazi ana enu na ndugu zenu a chilume, ela vivi sambi Mlungu akakujaliyani.” ");
INSERT INTO dig_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Siku ya phiri Musa waambira Aiziraeli, “Mkahenda dambi kulu sana. Ela phahi nindauya hiko dzulu mwangoni kpwa Mwenyezi Mlungu na labuda andanikubali akuswameheni dambi zenu.” ");
INSERT INTO dig_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Phahi Musa wauya kura mwangoni kpwa Mwenyezi Mlungu na achendaamba, “Atu hinya akahenda dambi kulu sana. Akadziumbira milungu ya zahabu. ");
INSERT INTO dig_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Ela sambi, nakuvoya uaswamehe dambi zao. Ela ichikala taindakala hivyo, nifuta, kula mwako chitabuni urimoandika madzina ga atuo.” ");
INSERT INTO dig_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Ela Mwenyezi Mlungu achimuamba Musa, “Mutu yeyesi achiyenihendera dambi, iye ndiye ndiyefutwa kula chitabuni mwangu. ");
INSERT INTO dig_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Vivi sambi uka, kaalongoze atu hadi phatu phara phokuambira, na malaika wangu andakutanguliyani. Ela wakati undakpwedza, ndiphoatiya adabu kpwa sababu ya dambi zao.” ");
INSERT INTO dig_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Mwenyezi Mlungu achiarehera ukongo hinyo atu chisa amuhenda Aruni aumbe mwana ndzau wa zahabu. ");
INSERT INTO dig_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Mwenyezi Mlungu achimuamba Musa, “Waatsamiza hinya atu kula Misiri. Sambi ukani hipha mphiye tsi ambayo námuahidi Burahimu, Isaka na Jakobo. Náapira nchiamba, ‘Tsi ihi nindaipha chivyazicho.’ ");
INSERT INTO dig_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Nindahuma malaika akulongozeni na nindazola Akanani, Aamori, Ahiti, Aperizi, Ahivi na Ajebusi. ");
INSERT INTO dig_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Phiyani kpwenye tsi yenye rutuba. Ela sindaphiya phamwenga namwi, sababu mu atu a likakado, musiosikira. Nchedza phamwenga namwi nindaweza kukuangamizani mo njirani.” ");
INSERT INTO dig_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Atu ariphosikira maneno higo mai, asononeka na taphana hata mmwenga ariyevwala tsona marembo. ");
INSERT INTO dig_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Mana Mwenyezi Mlungu kala akamuambira Musa, “Aambire Aiziraeli: Mana mu visoto tamsikira. Nchiphiya phamwenga namwi hata kpwa dakika mwenga, ninaweza kukuangamizani. Sambi vulani marembo genu nami nindafikiriya nikuhendenidze.” ");
INSERT INTO dig_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Phahi kuandzira mwango wa Horebu na kpwenderera Aiziraeli avula mapambo gao. ");
INSERT INTO dig_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Phahi Musa kala nkuhala hema na akarichita kondze ya kambi kure chidide, naye kala achiriiha “Hema ra Mkpwutano.” Mutu yeyesi ambaye kala analonda ushauri wa Mwenyezi Mlungu kala achiphiya kuriko na hiro hema kondze ya kambi. ");
INSERT INTO dig_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Wakati wosi Musa ariphophiya hiko hemani, atu osi kala achiima miryangoni mwa mahema gao, kuno analola Musa hadi ainjire hemani. ");
INSERT INTO dig_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Bada ya Musa kuinjira hemani, ingu ziho kala richitserera na kuziba mryango, wakati Mlungu anagomba na Musa. ");
INSERT INTO dig_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Na atu, ariphoona ingu ziho riimire phara mryango wa hema ra mkpwutano, kala achiphiya achichita mavwindi achiabudu miryangoni mwa mahema gao. ");
INSERT INTO dig_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Mwenyezi Mlungu kala anaweza kubisha na Musa bila kumfwitsa chitu, dza viratu mutu abishavyo na msenawe. Halafu Musa kala achiuya kambini, ela msaidiziwe barobaro, Joshuwa mwana wa Nuni, kala katuluka himo hemani. ");
INSERT INTO dig_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Musa wamuamba Mwenyezi Mlungu, “Che uchiniambira, ‘Alongoze atu hano.’ Ela nalonda nimanye ichikala undakala phamwenga naswi ama undahuma mutu wanjina. Chisha uchiamba, ‘Ninakumanya vinono, yani namanya dzinaro, na unanihamira.’ ");
INSERT INTO dig_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ela ichikala kpweli unahamirwa ni mimi, nifundza mipangoyo ili nikumanye na nienderere kuphaha mendzwayo. Tsona tambukira kukala watsambula kundi rosi hiri rikale atuo.” ");
INSERT INTO dig_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Ndipho Mlungu achimuamba, “Mi mwenye nindaphiya phamwenga namwi na nindakuhenda ukale na amani.” ");
INSERT INTO dig_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Phahi Musa achimuamba, “Ichikala kundaphiya phamwenga naswi, usihuuse kula hipha huripho. ");
INSERT INTO dig_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Ichikala kundaphiya naswi, atu andamanyadze kukala mimi phamwenga na atuo hunakuhamira? Ni chitu chani ambacho chindatafwautisha atuo kula kpwa kundi ra atu ririro duniani?” ");
INSERT INTO dig_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Na Mwenyezi Mlungu achimuamba Musa, “Nindahenda chitu chicho ambacho ukachilonda, chisa ni nakumanya vinono na ninakumendza.” ");
INSERT INTO dig_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Phahi Musa achiamba, “Sambi nionyesa mwanga ungʼalao wakati u phapho.” ");
INSERT INTO dig_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Naye Mlungu achimuamba, “Nindakpwedza kpwako nawe undaona unono wangu. Nindagomba dzina rangu, ‘Mwenyezi Mlungu,’ nawe undasikira. Nkumjaliya na kuonyesa mbazi mutu yeyesi nimlondaye. ");
INSERT INTO dig_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Ela kuruhusiwa kuona uso wangu, sababu takuna mwanadamu anionaye, akaishi.” ");
INSERT INTO dig_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Phahi Mwenyezi Mlungu achienderera kugomba achiamba, “Undaima dzulu ya mwamba phapha phephi nami, ");
INSERT INTO dig_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","ili mwanga wangu unaphotsupa, nindakutiya pango ra hinyo mwamba na nindakuziba na fumba ra mkpwono wangu hadi nkale nkatsupa. ");
INSERT INTO dig_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Halafu nindausa fumba ra mkpwono wangu nawe undaona mongo wangu, ela uso wangu kundauona.” ");
INSERT INTO dig_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Mwenyezi Mlungu achimuamba Musa, “Tsonga myalawe miiri dza iratu ya kpwandza, nami nindaiandika maneno garatu nrigokala nkaandika myalawe ya mwandzo, ambayo waivundza. ");
INSERT INTO dig_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Kala tayari muhondo ligundzu, na wedze hukutane hiko dzulu ya Mwango Sinai. ");
INSERT INTO dig_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Usedze na mutu wanjina wala mutu yeyesi asionekane phophosi hipha mwangoni, na hata mifugo isirise phephi na mwango.” ");
INSERT INTO dig_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Phahi Musa watsonga myalawe miiri dza iratu ya kpwandza. Achiambuka nayo Mwango Sinai chiti siku ya phiri, dza arivyolagizwa ni Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Phahi Mlungu watserera ndani ya ingu na achiima phamwenga naye hiko, na achitangaza dzinare mwenye, “Mwenyezi Mlungu.” ");
INSERT INTO dig_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Mwenyezi Mlungu achitsupa mbere za Musa, na achiamba, “Dzina rangu ni Mwenyezi Mlungu. Mimi, ndimi Mwenyezi Mlungu, Mlungu mwenye mbazi, asiyetsukirwa upesi. Nina mendzwa nyinji isiyosika, na uaminifu. ");
INSERT INTO dig_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Nindaaonyesa mendzwa isiyosika maelufu na maelufu ga vivyazi na niaswamehe uasi na dambi zao. Ela piya sindaricha kuatiya adabu atu arionikosa, ana na ana aho a chivyazi cha hahu na cha ne kpwa dambi za avyazi ao.” ");
INSERT INTO dig_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Mara mwenga Musa achizama photsi na achimuabudu Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Achiamba, “Mwenyezi Mlungu, ichikala ninakuhamira, phahi nakuvoya uphiye phamwenga naswi. Ninamanya kala atu hinya ni visoto na taasikira, ela huswamehe uyi wehu na dambi zehu! Hukubali hukale atuo.” ");
INSERT INTO dig_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Ndipho Mwenyezi Mlungu achiamba, “Ninaika chilagane phamwenga na atu a Iziraeli. Na mbere zao osi nindahenda vilinje ambavyo tavidzangbwehendwa kpwenye taifa rorosi duniani. Atu urio nao andaona vilinje ambavyo nindakuhendera nao andaogopha uwezo wangu mkpwulu. ");
INSERT INTO dig_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Lungani higa ninagokuamuruni hino rero na nindaausa atu mwenu njirani: Aamori, Akanani, Ahiti, Aperizi, Ahivi na Ajebusi. ");
INSERT INTO dig_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Kalani matso musiike chilagane na atu ambao tsi yao mundaphiya mkaisagale, kpwa sababu anaweza kukuhegani mlunge njira mbii. ");
INSERT INTO dig_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Phahi kabomoleni mwatu mwao mwa kulavira sadaka, phamwenga na nguzo zao anazoziabudu na vizuka vyao vya mlungu wao mchetu aihwaye Ashera. ");
INSERT INTO dig_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Msiabudu mlungu wanjina, sababu mimi, Mwenyezi Mlungu, ninalonda mendzwa yenu yosi. Mana dzina rangu naihwa ‘Mlungu mwenye wivu.’ ");
INSERT INTO dig_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Kalani matso musiike chilagane na enyezi a tsi iyo sedze anaphoabudu milungu yao, achikpwalikani mkarye vyakurya vyao chivyolaviwa sadaka. ");
INSERT INTO dig_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Chisha musihale asichana aho mukaalóza ana enu, ili akaza-ana enu aandzapho kuhumikira milungu yao, akaahenda ana enu akaabudu milungu ya chijeni piya. ");
INSERT INTO dig_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Msidzitengezere milungu ya chuma na kuiabudu. ");
INSERT INTO dig_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Sherekeyani Sikukuu ya mikahe isiyotiywa hamira. Kpwa siku sabaa ryani mikahe isiyokala na hamira, kama nrivyokulagizani. Hendani hivi chila wakati wa mwezi wa Abibu, sababu ndio mwezi muriotsama Misiri. ");
INSERT INTO dig_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Chila mvyalwa wa kpwandza mlume ni wangu. Vivyo hivyo avyalwa a kpwandza a chilume a nyamao osi, ngʼombe na mangʼondzi, ni angu. ");
INSERT INTO dig_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Mvyalwa wa kpwandza wa punda munaweza kumkombola na mwana ngʼondzi. Ela ichikala kundamkombola undamuolaga kpwa kumvundza singo. Ana enu a kpwandza a chilume akomboleni. “Chisha mutu asedze mbere zangu mikono mihuphu. ");
INSERT INTO dig_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Siku sita mundahenda kazi, ela siku ya sabaa mundaoya. Ikale wakati wa kurima minda yenu, ama wakati wa kuvuna ni lazima muoye. ");
INSERT INTO dig_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Mundasherekeya Sikukuu ya mavuno mwandzo-mwandzo wa minga ya kuvuna nganu, na kusherekeya sikukuu ya kukusanya mwisho wa mwaka. ");
INSERT INTO dig_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Alume osi andakutana mbere za Mwenyezi Mlungu, Mlungu wa Aiziraeli, kano tahu kpwa mwaka. ");
INSERT INTO dig_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Takuna mutu ndiye mizira mahe tsi yenu wakati mchisherekeya sikukuu hizi tahu mbere za Mwenyezi Mlungu, Mlungu wenu. Kpwa sababu nindazola mataifa ganjina manji mbere zenu na nindapanula miphaka yenu. ");
INSERT INTO dig_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Msinilavire mlatso wa sadaka phamwenga na chochosi chichotiywa hamira. Sikukuu ya Pasaka msisaze nyama yoyosi ya sadaka hadi ligundzu. ");
INSERT INTO dig_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Reheni mavuno genu ga mwandzo ga mwenu mindani nyumbani mwa Mwenyezi Mlungu, Mlungu wenu chila mwaka. Msijite mwana mbuzi na maziya ga nine.” ");
INSERT INTO dig_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Phahi Mwenyezi Mlungu wamuamba Musa, “Andika maneno higa sababu kulengana na maneno higa nikaika chilagane na uwe na atu a Iziraeli.” ");
INSERT INTO dig_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Musa wakala hiko mwangoni phamwenga na Mwenyezi Mlungu siku mirongo mine, usiku na mutsi bila ya kurya chochosi wala kunwa madzi. Naye achiandika hira myalawe maneno ga chilagane, yani zo Shariya Kumi. ");
INSERT INTO dig_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Musa watserera kula Mwango Sinai na hira myalawe miiri ya ushaidi mwakpwe mikononi. Kpwa sababu kala akagomba na Mwenyezi Mlungu, usowe kala unangʼala-ngʼala, ela kadzimanyire. ");
INSERT INTO dig_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Aruni na atu osi a Iziraeli ariphoona uso wa Musa unangʼala-ngʼala, aogopha kumsengerera. ");
INSERT INTO dig_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Ela Musa waaiha Aruni na vilongozi osi a Aiziraeli, nao amsengerera naye achigomba nao. ");
INSERT INTO dig_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Bada ya kuona Aruni na vilongozi anagomba naye, Aiziraeli achimsengerera. Musa achiapha malagizo gosi arigolagizwa ni Mwenyezi Mlungu hiko dzulu ya Mwango Sinai. ");
INSERT INTO dig_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Musa ariphomala kugomba nao, wabwiningiza usowe na nguwo. ");
INSERT INTO dig_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Wakati Musa kala achiphiya hemani mbere za Mwenyezi Mlungu akagombe naye, kala achiusa nguwo phakpwe usoni. Na ariphotuluka Hemani, kala achiambira atu a Iziraeli gosi arigolagizwa, ");
INSERT INTO dig_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","nao Aiziraeli auona usowe unangʼala-ngʼala. Hipho Musa waubwiningiza tsona nguwo hadi ariphouya kugomba na Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Phahi Musa achiakusanya ana a Iziraeli osi na achigomba nao achiamba, “Mwino ana a Iziraeli, higa ndigo mambo arigolagiza Mwenyezi Mlungu mgahende. ");
INSERT INTO dig_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Siku sita hendani kazi zenu zosi, ela siku ya sabaa ni siku ya kuoya, siku iriyotengbwa kpwa mambo ga Mwenyezi Mlungu. Na mutu yeyesi ndiyehenda kazi siku iyo, andaolagbwa. ");
INSERT INTO dig_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Siku ya Kuoya, hata moho wenye msiase bii himo mwenu madzumbani.” ");
INSERT INTO dig_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Chisha phahi Musa achienderera kugomba na ana Aiziraeli osi achiamba, “Hivi ndivyo Mwenyezi Mlungu arivyolagiza muhende. ");
INSERT INTO dig_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Lavyani sadaka ya vitu kpwa Mwenyezi Mlungu. Atu osi alondao kumlavira Mlungu na moyo mmwenga naalavye chitu chochosi kahi za zahabu na feza na shaba, ");
INSERT INTO dig_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","nyuzi za buluu, za zambarau na za kundu; katani swafi na nyoya za mbuzi; ");
INSERT INTO dig_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","chingo za turume zakutiywa rangi ya kundu, chingo swafi za nyama wa pwani aihwaye pomboo na mbao za muhi wa mshita. ");
INSERT INTO dig_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","Tsona asikose kureha mafuha ga zaituni ga kuasira taa, na vilungo vya uvumba wakutsanganywa na mafuha ga utakaso, na ga kufukizira kungu nono. ");
INSERT INTO dig_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","Tsona naarehe mawe gaihwago shohamu, na mawe ganjina ga samani kulu ndigopamba hicho chisibao chire cha mlavyadzi-sadaka na chifukoche cha chifuwani.” ");
INSERT INTO dig_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Chisha Musa achienderera kugomba na ana a Iziraeli achiamba, “Fundi mangungu osi awezao kutengeza vitu hivi virivyolagizwa ni Mwenyezi Mlungu vitengezwe, naatuluke edze atengeze ");
INSERT INTO dig_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","hema ra mkpwutano na vyandaruwavye, paziya na vihundevye vya kufwinikira, vya kugbwizanyira na kutsomekera, na mimoye, vibaovye vya kuphisana, viguzovye na seemuze za koloni. ");
INSERT INTO dig_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Tsona andatengeza Sanduku ra chilagane na migongoye ya kutsukurira, chifwinikoche ambacho ni chihi cha mbazi, na paziyaye ya kurizibira. ");
INSERT INTO dig_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","Achimala hivyo andatengeza Meza ya kulavira sadaka ya mikahe na migongoye ya kutsukurira, na miyoye yosi, na mikahe ya kuikpwa mbere za Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","Achila hipho andatengeza chinara cha kuikira taa phamwenga na miyoye, na taa na mafuha; ");
INSERT INTO dig_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","phatu pha kufukizira uvumba na migongoye ya kutsukurira, mafuha ga utakaso, uvumba na paziya ya mryango wa hema. ");
INSERT INTO dig_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","Tsona andatengeza phatu pha kulavira sadaka za kuochwa, na wayawe wa shaba wa kuigana na chimia, na migongoye ya kutsukurira, na miyoye yosi, na birika ra shaba na maguluge; ");
INSERT INTO dig_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","shuka za muhala wa hema ra mkpwutano, viguzovye na seemu za kolo za vyo viguzo, na paziya ndiyokala mryango wa nyo muhala; ");
INSERT INTO dig_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","Aho vivyo andatengeza vigingi vya kuchitira na nyugbwe za hema ra mkpwutano na muhalawe; ");
INSERT INTO dig_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","na nguwo nono za kufumwato ndizo vwalwa ni alavyadzi-sadaka ndiphokala anamuhumikira Mlungu pho Phatu Phatakatifu; nguwo zizi takatifu ndizo ndizo vwalwa ni Aruni, mlavyadzi-sadaka mkpwulu na anae, ndiphokala anahenda kazi ya kulavya sadaka.” ");
INSERT INTO dig_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Phahi Musa ariphomala kugomba hivyo, lola hinyo mkpwutano wa ana a Iziraeli, wosi uchitsamukana, hata achisala Musa macheye. ");
INSERT INTO dig_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Wee, richa sambi vitu virehwe! Atu osi ariokala mioyo yao inaahimiza edze amlavire Mwenyezi Mlungu, amlavira Mlungu vitu vya kutosha kudzengera hiro hema ra mkpwutano, na vya kuhumika kpwenye kazi ya Mlungu himo hemani, na vya kushonera hizo nguwo nono, takatifu za alavyadzi-sadaka. ");
INSERT INTO dig_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Mwenga kpwa mwenga, atu osi, alume kpwa achetu ariodzisikira kumlavira Mwenyezi Mlungu, areha pini, vipuli, pete, mikufu na chila aina ya vitu vya zahabu, hata chila mutu achikala akamlavira Mlungu chitu cha zahabu. ");
INSERT INTO dig_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Chila mutu ariyekala na nyuzi za buluu, au za zambarau, au za kundu; au ariyekala na katani swafi, au nyoya za mbuzi, au chingo za turume zakutiywa rangi ya kundu au ariyekala na chingo za pomboo kpwakpwe kaya wazireha. ");
INSERT INTO dig_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Atu osi ariokala na uwezo wa kulavya vitu vya feza na shaba avireha dza sadaka zao kpwa Mwenyezi Mlungu, tsona mutu yeyesi ariyekala na mbao za mshita zokala zinaweza kuhumika katika iyo kazi, ye wazireha. ");
INSERT INTO dig_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Ana achetu osi ariokala ni mafundi a kusuka na mikono areha nyuzi za buluu, za zambarau, za kundu, na katani swafi arizokala akazisuka na mikono yao enye. ");
INSERT INTO dig_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Ana achetu osi ariokala ni mafundi a kusuka nyoya za mbuzi nao achizisuka. ");
INSERT INTO dig_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Chisha phahi mambo gariphokala ganaenderera kuphiyato, akulu a Iziraeli nao taayalala, areha mawe ga shohamu na namuna yanjina ya mawe ga kupamba hicho chisibao cha mlavyadzi-sadaka na chifukoche cha chifuwani, ");
INSERT INTO dig_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","chisha achireha vilungo vya uvumba, na mafuha ga kuasira taa, na ga kupaka, na ga kutsanganywa na uvumba. ");
INSERT INTO dig_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Phahi hinyo ana a Iziraeli osi, achetu kpwa alume ariphodzisikira kukala mioyo yao inaahimiza amlavire Mwenyezi Mlungu sadaka, kpwa ajili ya kazi ariyokala akamlagiza Musa aihende, alavya sadaka hizo kpwa moyo mmwenga na kpwa kumendza enye. ");
INSERT INTO dig_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Phahi Musa achigomba na ana a Iziraeli achiamba, “Lolani, Mwenyezi Mlungu akamtsambula Bezaleli mwana Uri, mdzukulu wa Huri, wa mbari ya Juda. ");
INSERT INTO dig_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Na akamuodzaza Roho wa Mlungu ili akale na uwezo wa kumanya aina zosi za ufundi, ");
INSERT INTO dig_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","ili aweze kuhumira mitindo minji ya ufundi katika kazi ya zahabu, feza na shaba; ");
INSERT INTO dig_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","na kazi za kutsonga mawe ga kupambira marembo, kutsonga vitu vya muhi na kutengeza vitu kuhumira mitindo yosi ya ufundi. ");
INSERT INTO dig_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Tsona akamtiya mkpwotse iye Bezaleli phamwenga na Oholiabu wa Ahisamaki, wa mbari ya Dani kukala aafundze na kualongoza ayawao. ");
INSERT INTO dig_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Kpwa hivyo phahi atu hinya akawewa werevu munji katika mioyo yao, wa kuweza kutengeza chila kazi ya kuunda, ya kutsonga mbao, ya kulavya muundo, ya kushona nyuzi za buluu, na za zambarau, na piya za kundu, au ya kushona katani swafi ya kuhendasukpwa, au kazi ya kusuka kpwa kuhumira muundo wowosi wa ufundi.” ");
INSERT INTO dig_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Chisha Musa achienderera kugomba achiamba, “Kpwa hivyo Bezaleli, Oholiabu na atu osi ambao Mwenyezi Mlungu waapha ujuzi wa kumanya na kuhenda kazi zosi zilondwazo katika kutengeza hiro hema ra mkpwutano, andahenda kazi iyo kulengana na Mlungu arivyolagiza.” ");
INSERT INTO dig_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Phahi Musa achimuiha Bezaleli na Oholiabu, na atu osi ambao Mwenyezi Mlungu kala akaapha ujuzi na kumanya, na ariokala analonda kuhenda kazi iyo, ");
INSERT INTO dig_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","nao achiphaha kula kpwa Musa vifwaya vyosi vyokala vikalaviwa ni ana a Iziraeli kpwa ajili ya kutengeza hiro hema takatifu. Ela phahi hinyo atu taarichire kureha vifwaya, aenderera kureha sadaka zao chila ligundzu kpwa kumendza enye. ");
INSERT INTO dig_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Phahi hara mafundi a hema ariphoona vira, aricha kazi iyo na achiphiya hata kpwa Musa ");
INSERT INTO dig_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","achendamuamba Musa, “Kuratu phahi atu acherereha vifwaya tu, hata vikatsupa vyo hulondavyo kuhendera yo kazi huriyolagizwa ni Mwenyezi Mlungu huihende.” ");
INSERT INTO dig_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Phahi ariphosikira vira, Musa achilavya shariya na ichitangazwa kambi ndzima kukala, “Sadaka za kudzengera hema zikatosha, kpwa hivyo atu osi achetu kpwa alume msirehe tsona.” Ndipho hinyo atu achiricha kureha vifwaya. ");
INSERT INTO dig_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Mana hivyo arivyokala akavireha kala vikatsupa vira vyokala vinalondwa ili kuhenderwa kazi iyo. ");
INSERT INTO dig_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Phahi alume mafundi mangungu zaidi kahi za hinyo ariokala hipho achitengeza hiro hema na shuka kumi, zofumwa na katani swafi ya kuhendasukpwa, na nyuzi za buluu, za zambarau na za kundu. Tsona hizo shuka kala zina marembo ga makerubi garigofumwa vinono. ");
INSERT INTO dig_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Shuka zosi kala zi sawa-sawa tsetsetse, mana chila shuka kala ina ure wa mikono mirongo miiri na minane, na upana wa mikono mine. ");
INSERT INTO dig_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Phahi achihala hizo shuka achizigbwizanya tsano-tsano. ");
INSERT INTO dig_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Achihala hizo shuka za mwisho kahi za hizo shuka tsano-tsano, achizishonera mahandzi ga uzi wa buluu himo mapindoni. ");
INSERT INTO dig_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Ariphomala hivyo, achitengeza mahandzi mirongo mitsano dzulu ya shuka ya mwandzo, kahi za hizo shuka tsano za mwandzo na mahandzi mirongo mitsano tsona, dzulu ya shuka ya mwisho kahi za shuka tsano za phiri. Mahandzi gago kala ganalolana. ");
INSERT INTO dig_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Ariphola hipho, achitengeza vihunde mirongo mitsano vya zahabu, vya kutsomekera, achigbwizanyira zo shuka zosi hata zichikala dziyamba dzimwenga ra hema. ");
INSERT INTO dig_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Ariphomala hivyo achitengeza shuka kumi na mwenga tsona za nyoya za mbuzi za kutengezera chandaruwa cha kubwiningizira ro hema. ");
INSERT INTO dig_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Zo shuka kumi na mwenga, zakala sawa zosi. Chila shuka kala ina ure wa mikono mirongo mihahu na upana wa mikono mine. ");
INSERT INTO dig_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Phahi achihala shuka tsano achizigbwizanya lwakpwe na zo shuka sita nazo achizigbwizanya lwakpwe. ");
INSERT INTO dig_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Chisha phahi achishona mahandzi mirongo mitsano dzulu ya pindo ra shuka ya mwandzo ya zira shuka tsano na mahandzi ganjina mirongo mitsano dzulu ya pindo ra shuka ya mwisho, ya zo shuka zanjina. ");
INSERT INTO dig_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Ariphomala hivyo achitengeza vihunde mirongo mitsano vya shaba, vya kutsomekera ili agbwizanyire zo shuka ili zikale dziyamba dzimwenga ra ro hema. ");
INSERT INTO dig_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Tsona achitengeza vyandaruwa viiri vya ro hema, chimwenga cha chingo za maturume zotiywa rangi ya kundu, na chanjina cha chingo swafi ya pomboo chokala ndicho ndichoikpwa dzulu. ");
INSERT INTO dig_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Ariphokala akamala hivyo achitengeza mimo ya hiro hema za mbao za mshita achiyiimisa. ");
INSERT INTO dig_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Chila mwimo kala ina ure wa mikono kumi na upana wa mkpwono mmwenga na nusu. ");
INSERT INTO dig_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Chila mwimo kahi ya ro hema kala ina vigbwadziko viiri chivyotulukiza virivyohumirwa kugbwizanyira yo mimo. ");
INSERT INTO dig_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Uphande wa mwakani wa ro hema atengeza mimo mirongo miiri, ");
INSERT INTO dig_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","na seemu za kolo mirongo mine ya feza, chila mwimo seemu za koloni mbiri ya kuinjizira vyo vigbwadziko viiri chivyotulukiza. ");
INSERT INTO dig_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Uphande wa vurini wa ro hema nako, achitengeza mimo mirongo miiri, ");
INSERT INTO dig_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","na seemu za koloni mirongo mine vya feza chila furemu seemu za koloni mbiri za kuinjizira vyo vihundevye viiri chivyotulukiza. ");
INSERT INTO dig_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Uphande wa nyuma wa ro hema uchioloza mtswerero wa dzuwa, achitengeza mimo sita; ");
INSERT INTO dig_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","tsona achitengeza mimo yanjina mbiri za pembe na pembe, mwenga pembe hino na mwenga pembe hira, ko nyuma ya hema. ");
INSERT INTO dig_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Mimo ihi taayaigbwizanya bii ko tsini ela ko dzulu zadiniswa ni cho chihunde cha mviringo ko dzulu kpwenye. Zosi mbiri zatengezwa za kuigana. ");
INSERT INTO dig_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Kpwa hivyo, uphande uho wa mtswerero wa dzuwa kala una mimo minane, na seemu za koloni kumi na sita za feza. Chila mwimo seemu za koloni mbiri. ");
INSERT INTO dig_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Phahi ariphola hipho achitengeza maphalu kumi na tsano ga muhi wa mshita. Maphalu matsano ga kugbwizanyira iyo mimo ya uphande wa mwakani wa ro hema, ");
INSERT INTO dig_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","maphalu matsano ga kugbwizanyira iyo mimo ya uphande wa vurini, na matsano ganjina ga kugbwizanyira iyo mimo ya uphande wa mtswerero wa dzuwa, ambako ni nyuma ya ro hema. ");
INSERT INTO dig_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Ariphomala hivyo achiinjiza ro phalu mo kahi-kahi ya yo mimo kula kanda hadi kanda. ");
INSERT INTO dig_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Kumala hivyo achihala yo mimo phamwenga na go maphalu achigapaka zahabu hata tse, na ariphomala achitengeza bangili za zahabu za kufungira go maphalu. ");
INSERT INTO dig_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Phahi ariphomala kutengeza go maphalu, achitengeza paziya ya kushonwa na nyuzi za buluu, za zambarau na za kundu za katani swafi ya kuhendasukpwa. Paziya iyo ayiinjiza marembo ga makerubi garigofumwa vinono sana. ");
INSERT INTO dig_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Iyo paziya nayo achiitengezera nguzo ne za mshita achiipaka zahabu hata tse, halafu achiitengezera vihunde vya kutsomekera vya zahabu na seemu za kolo ne za feza. ");
INSERT INTO dig_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Hinyo mryango wa hiro hema nao achiutengezera paziyaye ya kuzibira iriyoshonwa na nyuzi za buluu, za zambarau na za kundu za katani swafi ya kuhendasukpwa. Kazi iyo yosi ya kushona phahi yahendafumwa na sindano. ");
INSERT INTO dig_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Chisha phahi kula phapho achitengeza viguzo vitsano vyenye vihunde vya kutsomekera, achivipaka zahabu vyosi, ela seemu tsano za koloni achizitengeza za shaba. ");
INSERT INTO dig_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Chisha Bezaleli naye achitengeza hiro sanduku ra mbao za mshita. Sanduku hiro kala rina ure wa mikono miiri na nusu, na upana wa mkpwono mmwenga na nusu, na chimo cha mkpwono mmwenga na nusu. ");
INSERT INTO dig_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Achiripaka zahabu swafi rosi, kondze na ndani hata achimala, tsona achirizungulusira mkpwungo wa marembo-marembo wa zahabu. ");
INSERT INTO dig_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Ariphomala hivyo achitengeza bangili ne za zahabu achizigbwizanya na hizo pembe za tsini za hiro sanduku, chila pembe bangili mwenga, uphande huno mbiri, na uphande huno mbiri. ");
INSERT INTO dig_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Chisha ariphola phapho achitsonga migongo miiri ya mshita, achiipaka zahabu hata tse, ");
INSERT INTO dig_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","halafu achiyiinjiza kahi za hizo bangili arizozigbwizanya na hiro sanduku ili ikahumike kuritsukurira hiro sanduku. ");
INSERT INTO dig_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Phahi ariphokala akamala hivyo, achitengeza chihi cha mbazi chokala ndo chifwiniko cha hiro sanduku. Hichi nacho achichitengeza na zahabu swafi. Urewe kala ni mikono miiri na nusu, na upanawe mkpwono mmwenga na nusu. ");
INSERT INTO dig_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Ariphola hipho achiunda makerubi airi a zahabu yobandwa, ");
INSERT INTO dig_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","achiagbwizanya na cho chihi cha mbazi, yuno kanda hino, na yuya kanda hira. ");
INSERT INTO dig_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Makerubi hinyo kala analolana kuno akabwaga matso photsi kulola hicho chihi cha mbazi, tsona kala akaandzula mapha gao kubwiningiza hicho chihi cha mbazi. ");
INSERT INTO dig_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Chisha phahi ariphomala kutengeza hiro sanduku ra chilagane, phamwenga na chifwinikoche, Bezaleli achitengeza iyo meza ya mbao za mshita. Urewe kala ni mikono miiri, na upanawe kala ni mkpwono mmwenga na chimoche chakala ni mkpwono mmwenga na nusu. ");
INSERT INTO dig_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Ariphomala kuitsonga, achiihala achiipaka zahabu swafi, halafu achiizungulusira mkpwungo wa marembo-marembo wa zahabu pande zosi. ");
INSERT INTO dig_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Ariphola hipho, iyo meza achiitengezera mimo ya kama inchi tahu, tsona iyo nayo achiizungulusira mkpwungo wa marembo-marembo wa zahabu. ");
INSERT INTO dig_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Kumala hivyo achitengeza bangili kulu ne za zahabu, na chila bangili achiigbwizanya na pembe mwenga ya gunguhi ra meza. ");
INSERT INTO dig_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Zo bangili kala zi phephi na yo mimo mana ndizo ndizogbwiririra yo migongo ya kutsukurira yo meza. ");
INSERT INTO dig_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Migongo iyo ya kutsukurira, Bezaleli waitengeza na muhi wa mshita na achiipaka zahabu yosi. ");
INSERT INTO dig_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Kula hipho achitengeza masahani, na vikombe vya kuinjizira uvumba, na vibakuli na tupa za kulavira sadaka ya chinwadzi, vyosi vya zahabu swafi. Miyo hino yosi waitengeza na zahabu swafi, na kala ni ya kuikpwa hipho dzulu ya meza. ");
INSERT INTO dig_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Phahi ariphomala kutengeza meza, Bezaleli achitengeza chinara cha kuikira taa cha zahabu swafi. Hiro hako ra cho chinara na mgongowe wa kahi-kahi, na mafundoge, na maruwage ga kuchitiya marembo, achivigbwizanya na hicho chinara vichikala chitu chimwenga. ");
INSERT INTO dig_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Kula phapho achitengeza panda sita za chinara hicho, uphande huno panda tahu na uphande huno panda tahu. ");
INSERT INTO dig_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Chila panda kala ina maruwa mahahu ga zahabu ga kuigana na ruwa ra muhi uihwao mlozi, na chila ruwa, kala rina chigongo cha kurigbwiririra. ");
INSERT INTO dig_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Nyo mgongo wa kahi-kahi wakala una maruwa mane ga kuigana na maruwa ga mlozi; na chila ruwa kala rina chigongo cha kurigbwiririra. ");
INSERT INTO dig_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Tsona nyo mgongo kala una mafundo mahahu, fundo mwenga-mwenga tsini ya chila panda. ");
INSERT INTO dig_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Kpwa hivyo higo mafundo, na zo panda na cho chinara chenye waviunda na zahabu swafi yobandwa, na achivihenda chitu chimwenga. ");
INSERT INTO dig_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Kula phapho achitengeza taa sabaa na vifwaya vya kuzizimira, na visahani, vyosi vya zahabu swafi. ");
INSERT INTO dig_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Phahi hicho chinara cha kuikira taa phamwenga na vifwayavye vyosi, wavitengeza na kilo mirongo mihahu na tsano ya zahabu swafi. ");
INSERT INTO dig_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Bada ya kumala hicho chinara cha taa, Bezaleli achiinjirira kutengeza hipho phatu pha kufukizira uvumba. Phatu hipho waphatsonga na mbao za mshita, na urewe kala u sawa na upanawe, ure phamwenga na upana wa phatu hipho pha kulavira sadaka wakala u sawa-sawa, kuno mkpwono, kuno mkpwono, ela chimoche kala ni mikono miiri. Hizo pembe za hipho phatu pha kulavira sadaka na hipho phatu phenye, wavitengeza dza chitu chimwenga. ");
INSERT INTO dig_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Ariphomala kuchitsonga achichihala achichipaka zahabu swafi chosi, kuandzira dzulu, na pande zosi ne, hata pembe zosi, tsona achichizungulusira mkpwungo wa marembo-marembo ga zahabu. ");
INSERT INTO dig_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Chisha, achitengeza bangili ne za zahabu na achizigbwizanya na hizo pembe za hipho phatu pha kulavira sadaka tsini ya hinyo mkpwungo wa zahabu, uphande huno mbiri, na uphande huno mbiri. Bangili hizi kala ndizo zotiywa iyo migongo ya kutsukurira hipho phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Anala phapho, achitsonga iyo migongo ya muhi wa mshita ya kutsukurira, na achiipaka zahabu yosi. ");
INSERT INTO dig_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Tsona achitengeza mafuha matakatifu na achitsanganya uvumba vinono sana dza viratu fundi wa kutengeza uvumba ahendavyo. ");
INSERT INTO dig_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Chisha ariphokala akamarigiza kutengeza mavumba, Bezaleli achitengeza phatu pha kulavira sadaka za kuochwa, pha mbao za mshita. Urewe kala u sawa na upanawe, kuno mikono mitsano kuno mikono mitsano ela chimoche kala ni mikono mihahu. ");
INSERT INTO dig_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Anala phapho achitengeza vihunde vine vyotulukiza dzulu ya zo pembe ne za pho phatu pha kulavira sadaka, vichikala chitu chimwenga na vyosi achivipaka shaba. ");
INSERT INTO dig_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Kula phapho, achitengeza miyo yosi ya kuhumirwa pho phatu pha kulavira sadaka; nyungu, miko, uma za kudungira nyama, visahani vya kuharira moho na vitu vyosi vya kuhumirwa pho phatu pha kulavira sadaka achivitengeza na shaba. ");
INSERT INTO dig_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Ariphomala, achitengeza waya wa shaba wenye vyumba-vyumba dza viratu chimia, achiuinjiza pho phatu pha kulavira sadaka hata uchifika kahi-kahi, ");
INSERT INTO dig_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","halafu achitengeza vihunde vine, na achivigbwizanya na zo pembe za pho phatu pha kulavira sadaka hipho hinyo waya uriphofika ili vigbwirire yo migongo ya kutsukurira. ");
INSERT INTO dig_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Ariphola phapho achitengeza iyo migongo ya mshita ya kutsukurira, achiipaka shaba hata tse, ");
INSERT INTO dig_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","na achiyiinjiza mo mwenye bangili uphande huno mmwenga na uphande huno mmwenga. Phatu hipho phachikala taphana hako wala mfwiniko. ");
INSERT INTO dig_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Chisha ariphomala kutengeza hipho phatu pha kulavira sadaka, achitengeza birika ra shaba, na maguluge ga shaba vivyo. Phahi watengeza hivi kpwa kuhumira vitu vya shaba virivyohumirwa dza vilolo ni hinyo ana achetu ariokala achihumika hipho mryango wa hiro hema ra mkpwutano. ");
INSERT INTO dig_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Phahi ariphomala kutengeza hiro birika, achiandza kutengeza muhala wa hema ra mkpwutano. Muhala uho, wazibwa na shuka za katani swafi za kuhendasukpwa. Shuka zirizohumika uphande wa mwakani, kala urewe kpwa jumula ni mikono gana mwenga. ");
INSERT INTO dig_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Shuka hizo kala zikagbwirirwa ni viguzo mirongo miiri virivyokala kahi za seemu za kolo mirongo miiri za shaba, ela vigbwadziko vya kutsomekera na bangili za viguzo kala ni vya feza. ");
INSERT INTO dig_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Uphande wa vurini wa hinyo uwa, nao kala una shuka zirizokala zosi phamwenga zina ure wa mikono gana mwenga. Shuka hizo nazo zagbwirirwa ni viguzo mirongo miiri virivyoinjizwa kahi za makolo ga kuimisira mirongo miiri ga shaba, ela vigbwadzikovye vya kutsomekera na vihundevye vya mviringo kala ni vya feza. ");
INSERT INTO dig_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Mtswerero wa dzuwa, kpwadzengbwa na shuka zirizokala zosi phamwenga zina ure wa mikono mirongo mitsano. Shuka hizo nazo zagbwiririrwa ni viguzo kumi, virivyoinjizwa kahi za seemu za kolo kumi za shaba, ela hivyo vigbwadziko vya kutsomekera na pete za viguzo kala ni vya feza. ");
INSERT INTO dig_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Uphande wa mlairo wa dzuwa ambako kala ndiko kpwenye mryango, nako kala kuna shuka ambazo zosi phamwenga zina ure wa mikono mirongo mitsano, ");
INSERT INTO dig_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","Mikono kumi na mitsano uphande huno wa mryango wa nyo muhala na mikono kumi na mitsano mryango wa uphande wanjina. Chila uphande, kala kuna viguzo vihahu ambavyo kala vikainjizwa kpwenye makolo mahahu ga kuimisira. ");
INSERT INTO dig_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Shuka zosi zirizodzengerwa hinyo muhala wa hema kala zikafumwa na katani swafi ya kuhendasukpwa. ");
INSERT INTO dig_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Seemu za koloni za vyo viguzo vyosi kala ni vya shaba, vigbwadziko vya kutsomekera na pete za viguzo kala ni vya feza, kpwa hivyo feza ndiyo iriyohumika kutengezera ko dzulu ya viguzo, na hata kutengezera zo fwiho zirizohumirwa kugbwizanyira vyo viguzo vya nyo muhala. ");
INSERT INTO dig_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Shuka ya Paziya ya phatu pha kumenyera nyo muhala, zahenda shonwa na nyuzi za buluu, za zambarau na piya za kundu za katani swafi ya kuhendasukpwa. Shuka iyo kala ina ure wa mikono mirongo miiri na upana wa mikono mitsano dza vyo vya shuka zanjina za nyo muhala. ");
INSERT INTO dig_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Nayo kala ikadiniswa ni viguzo vine virivyokala ndani ya seemu za kolo ne za shaba, ela vigbwadziko vya kutsomekera na bangili za viguzo kala ni vya feza. Viguzo hivyo vyapakpwa feza hiko dzulu kpwenye. ");
INSERT INTO dig_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Vigingi vyosi vya kuchitira hiro hema ra mkpwutano na vya nyo muhalawe kala ni vya shaba. ");
INSERT INTO dig_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Phahi hema ra ushaidi ririphoivwa, Musa achiaambira nyo Alawi aviinjize tsona isabuni vitu vyosi virivyohumika katika hiro dzengo, na achimtsambula Ithamari mwana wa Aruni mlavyadzi-sadaka aimirire kazi iyo. ");
INSERT INTO dig_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","23","Phahi, Musa walavya shariya iyo wakati Bezaleli mwana wa Uri mdzukulu wa Huri, wa mbari ya Juda, na myawe Oholiabu wa Ahisamaki, wa mbari ya Dani, ariphomarigiza kabisa hira kazi ambayo Mwenyezi Mlungu kala akamlagiza Musa aihende. Oholiabu kala ni mtsongi, na mtuluzadzi wa miundo, na mshonadzi wa katani swafi, na nyuzi za buluu, za zambarau na za kundu. ");
INSERT INTO dig_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Phahi zahabu iriyohumika katika dzengo ra hema ra mkpwutano, iriyotanywa kula kpwa hizo zahabu zirizolaviwa sadaka ni Aiziraeli, kala ni kilo magana manane na mirongo sabaa na sabaa, na giramu magana mahahu, kulengana na chipimo cha hipho hemani. ");
INSERT INTO dig_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","26","Atu osi ariokala na miaka mirongo miiri na kpwenderera arioisabiwa ni Musa, atuluka alume elufu magana sita na tahu, na magana matsano na mirongo mitsano. Chila mmwenga kahi ya hano walavya giramu tsano za feza. Phahi, zosi zichituluka kilo elufu tahu, na kumi na nane kasorobo za feza kulengana na chipimo cha hipho hemani. ");
INSERT INTO dig_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Kilo elufu tahu za feza zahumirwa kutengezera seemu za kolo gana mwenga za hiro hema na za paziya. Kilo mirongo mihahu chila dibwa. ");
INSERT INTO dig_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Hizo kilo kumi na nane kasorobo zirizosala Bezaleli achizihumira kutengezera vigbwadziko vya kutsomekera na pete za hivyo viguzo, tsona achizitengezera hivyo viguzo hiko dzulu kpwenye. ");
INSERT INTO dig_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Sadaka ya shaba yatuluka kilo elufu mbiri, gana, mirongo miiri na ne. ");
INSERT INTO dig_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","31","Naye Bezaleli achiihumira kutengezera seemu zosi za makolo za shaba za mryango wa hiro hema ra mkpwutano, za hinyo muhala wa hema, za mryango wa hinyo muhala, na vigingi vyosi vya kuchitira hema na vya muhalawe. Tsona achiihumira kutengezera hipho phatu pha kulavira sadaka pha shaba na wayawe wa shaba, na miyo yosi ya kuhumika hipho phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Hinyo mafundi ahumira hizo nyuzi za buluu, za zambarau na za kundu, kushona mavwazi ga kuhendera kazi kpwenye hiro hema ra mkpwutano. Phahi amshonera Aruni mavwazi dza viratu Musa arivyolagizwa ni Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Hicho chisibao chire achishona na zahabu, na nyuzi za buluu, za zambarau na za kundu, na katani swafi ya kuhendasukpwa dza lugbwe. ");
INSERT INTO dig_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Chisha ahala iyo zahabu achiipiga na nyundo hata ichikala bambasha, chisha achirikata waya ndide-ndide. Waya zira achizishona phamwenga na hizo nyuzi za buluu, na za zambarau, na za kundu na iyo katani swafi ya kusukpwa. Kazi ihi yosi aihenda chiufundi. ");
INSERT INTO dig_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Alafu, aho vivyo achitengeza mikowa miiri ya kufungira cho chisibao na achiishona mo mafuzini. Chila fuzi mkpwowa mmwenga. ");
INSERT INTO dig_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Nyo mkumbuu wa cho chisibao nao achiushonato na nyuzi za zahabu, na za buluu, na za zambarau, na za kundu, na katani swafi ya kuhendasukpwa, dza viratu vya chisibao, achiugbwizanya na cho chisibao vichikala chitu chimwenga. Chila chitu achichitengeza dza viratu Mwenyezi Mlungu arivyomlagiza Musa. ");
INSERT INTO dig_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Kula phapho, achitengeza higo mawe ga shohamu, achigaandika madzina ga hinyo ana kumi na airi a Iziraeli dza viratu mutu anayetsusa zahabu atengezavyo muhuri, halafu achigazungulusira marembo ga zahabu. ");
INSERT INTO dig_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Ariphomala, achigahala go mawe achigafunga na yo mikowa mo mafuzini mwa cho chisibao ili gakale gachimtambukiza Mlungu kuhusu ana a Iziraeli, dza viratu Mwenyezi Mlungu arivyomlagiza Musa. ");
INSERT INTO dig_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Phahi ariphomala kutengeza hicho chisibao, achiandza kutengeza hicho chifuko cha chifuwani. Hicho nacho achitengeza na zahabu, na nyuzi za buluu, za zambarau na za kundu na katani swafi ya kusukpwa dza vyokala hicho chisibao. Kazi hino yahendwa ni mutu aimanyaye. ");
INSERT INTO dig_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Chifuko hicho achitengeza na chitambaa cha kuhenda kundzwa kano mbiri. Urewe na upanawe kala visawa-sawa tse, hiku robo ya mkpwono, kuno robo ya mkpwono. ");
INSERT INTO dig_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Ariphomala kuchishona achichiinjiza mistari mine ya marembo ga mawe ga samani. Msitari wa mwandzo kala una mawe gaihwago akiki, topazi na alimasi ya kundu; ");
INSERT INTO dig_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Msitari wa phiri kala una mawe gaihwago zumaridi, yakuti ya buluu na alimasi. ");
INSERT INTO dig_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Msitari wa hahu kala una mawe gaihwago jasinitho, akiki ya kundu na amethisito. ");
INSERT INTO dig_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Na mraba wa ne uchikala na mawe gaihwago zabarajadi, na shohamu, na jasipa. Phahi mawe gaga gosi gazungulusirwa marembo ga zahabu. ");
INSERT INTO dig_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Kpwa jumula, mawe gosi garigohumika kala ni mawe kumi na mairi. Na chila namuna ya dziwe kahi za higo kumi na mairi, raandikpwa dzina mwenga kahi za higo madzina kumi na mairi ga ana a Iziraeli. Madzina higa gaandikpwa dza viratu fundi atsongavyo muhuri, na gachihala phatu pha mbari zosi za Iziraeli. ");
INSERT INTO dig_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Phahi ariphomala hivyo, cho chifuko achichitengezera mikufu miiri ya zahabu swafi, ya kuhendasukpwa avi ni lugbwe. ");
INSERT INTO dig_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Kula phapho, achitengeza pete mbiri za marembo za zahabu na pete zanjina mbiri za zahabu. Achihala hizo pete mbiri achizigbwizanya na iyo mitse miiri ya cho chifuko ");
INSERT INTO dig_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","halafu hira mikufu miiri ya zahabu achiilundziza na zira pete katika iyo mitse ya cho chifuko. ");
INSERT INTO dig_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Hizo tsa zanjina mbiri za iyo mikufu, achizilundzanya na hizo pete za marembo, halafu hizo pete achizigbwizanya na hizo kowa za mbere ya cho chisibao mo mafuzini. ");
INSERT INTO dig_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Ariphomala hivyo, achitengeza pete mbiri za zahabu, achizigbwizanya na iyo mitse ya tsini ya cho chifuko cha ndani, chirichokala chikalarira cho chisibao. ");
INSERT INTO dig_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Anamala hipho, achitengeza bangili mbiri tsona, za zahabu achizigbwizanya na hizo tsa mbiri za mbere zirizo tsini ya cho chisibao, phephi na cho chirichogbwizanyirwa, na dzulu chidide ya hinyo mkumbuu wa kushonwato. ");
INSERT INTO dig_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Ariphomala hivyo, achihala zo bangili za cho chifuko achizifunga na zo za chisibao na uzi wa buluu, ili cho chifuko chisikale rejereje, ela chidine hipho dzulu ya nyo mkumbuu wa kushonwato dza viratu Mwenyezi Mlungu arivyomlagiza Musa. ");
INSERT INTO dig_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Chisha phahi ariphokala akamarigiza kutengeza cho chifuko cha chifuwani, Bezaleli wahumira uzi wa buluu macheye kufuma yo kandzu phamwenga na cho chisibao chire. ");
INSERT INTO dig_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Kandzu iyo kala ina singo ya kahi-kahi, iriyozungulusirwa mshono wa nyuzi, sedze ikatsanika-tsanika. ");
INSERT INTO dig_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","25","Na ariphomala, ro pindo ra tsini ra iyo kandzu, warizungulusira kengele za zahabu na marembo ga makomamanga garigoshonwa na nyuzi za buluu, za zambarau, za kundu na za katani swafi ya kusukpwa. ");
INSERT INTO dig_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Kpwa hivyo ro pindo rosi achirizungulusira makomamanga na kengele za zahabu dza viratu Mwenyezi Mlungu arivyomlagiza Musa. Hipha kengele, hipha komamanga, hipha kengele hipha komamanga, hata pindo rosi achirimala kurizungulusira kengele na makomamanga. ");
INSERT INTO dig_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","28","Chisha phahi ariphomala kufuma yo kandzu, achimfumira Aruni na anae majoho, na kofiya, na viremba, vyosi vya katani swafi. Chisha achiafumira suruwale fupi za ndani za katani swafi ya kuhendasukpwa. ");
INSERT INTO dig_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Tsona achiafumira mikanda ya katani swafi iriyosokotwato na nyuzi za buluu, za zambarau na za kundu dza viratu Mwenyezi Mlungu arivyomlagiza Musa. ");
INSERT INTO dig_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Anala phapho, achitengeza hicho chibamba cha kufunga chirembani, na zahabu swafi, na achiandika dza viratu fundi atsongavyo muhuri, MTAKATIFU WA MWENYEZI MLUNGU, ");
INSERT INTO dig_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","achichihala achichifunga dzulu ya cho chiremba na mkpwowa wa buluu dza Mwenyezi Mlungu arivyomlagiza Musa. ");
INSERT INTO dig_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Sambi, hinyo ana a Iziraeli ariphomala kuihenda iyo kazi ya hema ra mkpwutano, dza viratu Mwenyezi Mlungu arivyomlagiza Musa, ");
INSERT INTO dig_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","achirihala hiro hema phamwenga na miyoye, vyosi achimrehera Musa. Phahi amrehera chila chitu. Vihundevye vya kufwinikira vya kugbwizanyira na kutsomekera, na mimo, na maphalu, na viguzo na seemuze za koloni. ");
INSERT INTO dig_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","Tsona achimrehera vyandaruwa vya hiro hema, chimwenga cha chingo za turume za kutiywa rangi ya kundu, na chanjina cha chingo za pomboo, na shuka za paziya. ");
INSERT INTO dig_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Chisha achimrehera hiro sanduku ra chilagane na migongoye ya kutsukurira, na chifwinikoche ambacho ni chihi cha mbazi. ");
INSERT INTO dig_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","Tsona achimrehera meza ya kulavira sadaka za mikahe na miyoye yosi, na mikahe ya kuikpwa mbere za Mwenyezi Mlungu, ");
INSERT INTO dig_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","na chinara cha kuikira taa cha zahabu swafi na miyoye yosi, na taa phamwenga na mafuha. ");
INSERT INTO dig_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Halafu, achimrehera phatu pha kulavira sadaka pha kufukizira uvumba pha zahabu, na mafuha ga utakaso, na uvumba, na shuka za paziya ya mryango wa hema. ");
INSERT INTO dig_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Tsona achimrehera hipho phatu pha kulavira sadaka pha shaba, na wayawe wa shaba, na miyoye yosi, birika phamwenga na maguluge, na migongoye ya kutsukurira. ");
INSERT INTO dig_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Chisha taasikire hipho, amrehera shuka za paziya za muhala wa hema, na viguzovye, na vizingitivye, na shuka za paziya ya mryango wa uwa, na nyugbweze, na vigingivye vya kuchitira, na miyo yanjina yosi ya kuhumirwa kpwenye utumishi kahi za hema ra mkpwutano. ");
INSERT INTO dig_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Tsona achimrehera mavwazi ga kufumwato ga kuhendera kazi pho Phatu Phatakatifu, mavwazi matakatifu ga mlavyadzi-sadaka Aruni, na mavwazi ga anae alume ga kuhendera kazi ya ulavyadzi-sadaka. ");
INSERT INTO dig_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Kpwa hivyo hinyo Aiziraeli achikala akamala kutengeza chila chitu arichokala Mwenyezi Mlungu akamlagiza Musa achihende. ");
INSERT INTO dig_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Phahi Musa ariphoilola iyo kazi achiona kukala hinyo atu akaihenda sawa-sawa, dza viratu vira Mwenyezi Mlungu arivyomlagiza. Kpwa hivyo achiabariki. ");
INSERT INTO dig_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Mwenyezi Mlungu wamuamba Musa, ");
INSERT INTO dig_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Ifikapho siku ya kpwandza ya mwezi wa mwandzo, chita Hema ra Mkpwutano. ");
INSERT INTO dig_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Injiza Sanduku ra Ushaidi, chisha uriike ndani ya paziya inayotenga phatu photengbwa kpwa ajili ya Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Uinjize meza na upange vyosi ambavyo ni vikale dzuluye. Tsona chitiye Hemani chira chinara cha kuikira taa na uike taaze dzuluye. ");
INSERT INTO dig_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Mbere za Sanduku ra Ushaidi kondze ya paziya ya ndani undaika phatu pha kufukizira uvumba. Chisha uzibe na paziya yanjina mryango wa kuinjirira Hemani. ");
INSERT INTO dig_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Alafu pho phatu pha kulavira sadaka za kuochwa phaike mbere ya mryango wa hema ra mkpwutano, ");
INSERT INTO dig_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","na yo simikiro ya kutawazira yiikpwe kahi-kahi ya ro hema ra mkpwutano na phatu pha kulavira sadaka, chisha yiodzazwe madzi. ");
INSERT INTO dig_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Undadzenga muhala wa paziya kuzunguluka Hema na phatu pha kulavira sadaka, na uike paziya ryangoni mwa hinyo muhala. ");
INSERT INTO dig_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Chisha undahala gara mafuha na upake hema na miyo yosi iriyo ndani na indakala ikatengbwa kpwa Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Badaye paka mafuha phatu pha kulavira sadaka za kuochwa na miyoye yosi, na indakala ikatengbwa kpwa Mlungu kamare. ");
INSERT INTO dig_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Uchila hipho, hala yo simikiro phamwenga na maguluge, uimwagire mafuha uyiike mbere zangu. ");
INSERT INTO dig_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Halafu rehe Aruni na anae ryango ra Hema ra Mkpwutano na uatawaze na madzi. ");
INSERT INTO dig_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Chisha umvwike Aruni vwazi ra mlavyadzi-sadaka, umpake mafuha, na umtenge, ili aweze kunihumikira dza mlavyadzi-sadaka. ");
INSERT INTO dig_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Arehe anae nao uavwise zira kandzu. ");
INSERT INTO dig_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Tsona apake mafuha dza uchivyohenda ise yao, ili nao anihumikire dza alavyadzi-sadaka. Kupakpwa kpwao mafuha kundaahenda akale alavyadzi-sadaka a maisha na hata vivyazi vyao vyosi.” ");
INSERT INTO dig_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Musa wahenda chila chitu ambacho Mwenyezi Mlungu kala akamlagiza. ");
INSERT INTO dig_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Phahi siku ya kpwandza ya mwezi wa mwandzo wa mwaka wa phiri bada ya kutuluka Misiri, Hema ra Mkpwutano rachitwa. ");
INSERT INTO dig_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Musa wadzenga ziyo ra Hema: Achiika vyuma vya tundu kugbwirira nguzo, achiimisa nguzo, vizingiti, na achipanga boriti. ");
INSERT INTO dig_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Ndipho achizungulusa nguwo kubwiningiza ziyo ra Hema, na dzulu ya iyo nguwo achibwiningiza chingo, dza Mwenyezi Mlungu arivyomlagiza. ");
INSERT INTO dig_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Chisha achihala hira myalawe miiri, achiyiika ndani ya Sanduku ra Ushaidi. Alafu achihala migongo miiri ya kutsukurira Sanduku, achiitsomeka kpwenye bangili za Sanduku, na achifwinika na chihi cha mbazi pho dzuluye. ");
INSERT INTO dig_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Phahi wainjiza rira Sanduku ra Ushaidi ndani ya Hema. Naye achiika paziya mbere ya hiro Sanduku na richikala tarionekana, dza Mwenyezi Mlungu arivyomlagiza Musa. ");
INSERT INTO dig_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Musa waika meza ndani ya hema ra mkpwutano, uphande wa vurini wa Hema, kondze ya hira paziya ya ndani. ");
INSERT INTO dig_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Na achiika mkpwahe dzulu ya meza mbere za Mwenyezi Mlungu, dza Mlungu arivyomlagiza. ");
INSERT INTO dig_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Achiika chinara cha kuikira taa ndani ya hema ra mkpwutano, uphande wa mwakani kulolana na meza. ");
INSERT INTO dig_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Naye mbere za Mwenyezi Mlungu, achiika taa dza Mwenyezi Mlungu arivyomlagiza Musa. ");
INSERT INTO dig_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Musa waika phatu pha kulavira sadaka photengezwa na zahabu mura ndani ya hema ra mkpwutano mbere ya paziya, ");
INSERT INTO dig_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","na achifukiza uvumba unukao vinono dzuluye, dza viratu arivyolagizwa ni Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Badaye Musa waika paziya mryango wa Hema. ");
INSERT INTO dig_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Achiika phatu pha kulavira sadaka za kuochwa kondze, phephi na mryango wa ro hema ra mkpwutano. Na achilavya sadaka ya kuochwa na sadaka ya unga, dza Mwenyezi Mlungu arivyomlagiza. ");
INSERT INTO dig_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Waika simikiro ya kutawazira kahi-kahi ya ro hema ra mkpwutano na phatu pha kulavira sadaka, na achiitiya madzi. ");
INSERT INTO dig_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Musa, Aruni na anae aihumira hira simikiro kutawaza mikono na magulu gao. ");
INSERT INTO dig_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Atawaza wakati kala anainjira Hemani ama wakati anasengerera phatu pha kulavira sadaka, dza Mwenyezi Mlungu arivyomlagiza Musa. ");
INSERT INTO dig_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Phahi Musa wadzenga uwa wa paziya kuzunguluka Hema na phatu pha kulavira sadaka, na achiziba paziya mryango wa hinyo muhala. Hipho Musa achikala akamala kazi yosi. ");
INSERT INTO dig_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Phahi ingu ratserera, na ririphobwiningiza Hema ra Mkpwutano, mwanga wa Mwenyezi Mlungu wangʼala himo ndani. ");
INSERT INTO dig_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Musa kayaweza kuinjira ndani ya hema ra mkpwutano kpwa sababu ingu kala rikatserera dzuluye, na mwanga wa Mwenyezi Mlungu kala ukangʼala himo ndani. ");
INSERT INTO dig_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Vyaro vyao vyosi Aiziraeli kala achiandza wakati rira ingu kala rikaunulwa kula dzulu ya Hema. ");
INSERT INTO dig_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Ro ingu siku zosi kala nkukala dzulu za hema ra mkpwutano. Kahi ya vyaro vyao, nyo ana a Iziraeli kala taaweza kuvundza kambi na kpwenderera na charo, hadi ro ingu riuke pho dzulu ya hema. ");
INSERT INTO dig_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Aiziraeli kala achiona ingu ra Mwenyezi Mlungu dzulu ya Hema wakati wa mutsi na usiku kala achiona moho unaaka dzuluye. Higo gaenderera wakati wosi wa vyaro vyao.");
INSERT INTO dig_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Mwenyezi Mlungu wamuiha Musa na achibisha naye kula mo hema ra mkpwutano achimuamba, ");
INSERT INTO dig_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Aambire Aiziraeli kukala mutu yeyesi kahi yenu achilonda kumlavira Mwenyezi Mlungu sadaka ya nyama, nyama hiye andamtsambula kula kpwenye mfugowe wa ngʼombe, mangʼondzi au mbuzi. ");
INSERT INTO dig_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“Napho sadaka anayoreha ni ya kuochwa, andatsambula ndzau isiyo na chirema kula kpwa mfugowe; andaireha pho ryangoni pha hema ra mkpwutano ili akubaliwe ni Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Naye andabandika mkpwonowe dzulu ya chitswa cha hiye nyama wa sadaka za kuochwa, ambayo indakubaliwa kpwa ajili ya kumuhenda hiye mutu ausirwe dambi. ");
INSERT INTO dig_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Chisha, andatsindza hiye mwana ndzau mbere za Mwenyezi Mlungu. Nao alavyadzi-sadaka, ana a Aruni andahala milatso na kumwagira-mwagira pande zosi ne za phatu pha kulavira sadaka hipho ryangoni pha hema ra mkpwutano. ");
INSERT INTO dig_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Hiye mutu andayula ye nyama wa sadaka ya kuochwa na amkate-kate vipande-vipande. ");
INSERT INTO dig_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Hinyo alavyadzi-sadaka ana a Aruni andapanga kuni dzulu ya makala ga moho garigo pho phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Alafu alavyadzi-sadaka hinyo andahala vira vipande vya nyama, chitswa na marunya, na kuviika dzulu ya kuni pho dzulu ya phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Ela ye achiyereha ye nyama wa sadaka, naatsukutse mahumbo na marondo na madzi. Naye mlavyadzi-sadaka andaocha sadaka yosi dzulu ya phatu pha kulavira sadaka dza sadaka ya kuochwa. Iyo ni zawadi yenye kungu nono imuhamirayo Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“Napho sadakaye ya kuochwa ni ya ngʼondzi au mbuzi, phahi andatsambula nyama mlume asiyekala na chirema. ");
INSERT INTO dig_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Andamwagira-mwagira uphande wa vurini wa phatu pha kulavira sadaka, mbere za Mwenyezi Mlungu. Hinyo alavyadzi-sadaka ana a Aruni andamwagira-mwagira milatsoye pande zosi za hipho phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Chisha ye chiyereha ye nyama andamkata-kata, na ye mlavyadzi-sadaka andavipanga vyo vipande vya nyama phamwenga na marunya dzulu ya kuni ziakazo moho pho phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Ye chiyereha yo sadaka andatsukutsa go mahumbo na marondoge na madzi, naye mlavyadzi-sadaka andaviocha vyosi dzulu ya phatu pha kulavira sadaka dza sadaka ya kuochwa. Iyo ni zawadi yenye kungu nono imuhamirayo Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“Ichikala anamlavira Mwenyezi Mlungu sadaka ya kuochwa ya nyama wa mapha, phahi, andareha sadakaye ya njiya au mwana njiya manga. ");
INSERT INTO dig_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Mlavyadzi-sadaka andareha hiye nyama wa mapha hipho phatu pha kulavira sadaka, andammwamula chitswa na umuoche dzulu ya phatu pha kulavira sadaka. Milatsoye indachururizwa kpwenye lavu ra phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Ifure phamwenga na uchafuwe andawuusa na kuutsupha kuikpwako ivu kuriko uphande wa mlairo wa dzuwa wa phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Andamgbwira mapha na kumuahula, ela asimganye vipande viiri. Alafu, mlavyadzi-sadaka andamuocha kpwenye phatu pha kulavira sadaka dza sadaka ya kuochwa, dzulu ya kuni. Iyo ni zawadi yenye kungu nono imuhamirayo Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“Mutu yeyesi achireha sadaka ya mtsere kpwa Mwenyezi Mlungu, sadaka iyo ni ikale ya unga mnono. Naye andaumwagira mafuha na kuutiya ubani dzuluye. ");
INSERT INTO dig_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Alafu, andaarehera hinyo alavyadzi-sadaka, ana a Aruni. Ye mlavyadzi-sadaka andahala fumba mwenga ra hinyo unga mnono wenye mafuha na ubani wosi na auoche dzulu ya phatu pha kulavira sadaka ili kuonyesa kukala sadaka yosi ni ya Mwenyezi Mlungu. Iyo ni zawadi yenye kungu nono imuhamirayo Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Seemu ndiyosala ya sadaka iyo ni ya Aruni na anae. Iyo ni seemu takatifu kabisa ya sadaka yenye kungu nono ilaviwayo kpwa Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“Napho mutu anamlavira Mlungu sadaka ya mtsere iriyoochwa kpwenye dziko ra kuochera mikahe, iyo indakala ya mikahe isiyotiywa hamira ya unga mnono uriotsanganywa na mafuha, au ya mikahe myembamba iriyopakpwa mafuha isiyokala na hamira. ");
INSERT INTO dig_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Ichikala sadaka unayolavya ni ya mkpwahe uriokalangbwa kpwenye chuma, iyo indakala ya unga mnono uriotsanganywa na mafuha ela bila hamira. ");
INSERT INTO dig_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Mikahe iyo ni imogolwe-mogolwe vipande vidide-vidide na uvimwagire mafuha. Iyo ni sadaka ya mtsere. ");
INSERT INTO dig_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Napho sadakayo ya mtsere ni ya kujitwa na nyungu, iyo indakala ya unga mnono wa kutiywa mafuha. ");
INSERT INTO dig_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Undareha sadaka ya unga mnono yotengezwa kpwa vitu hivyo mbere za Mwenyezi Mlungu na kuvilavya kpwa mlavyadzi-sadaka naye andavireha phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Mlavyadzi-sadaka andahala seemu ya sadaka iyo na kuiocha dzulu ya phatu pha kulavira sadaka ili kuonyesa kukala sadaka yosi ni ya Mwenyezi Mlungu. Iyo ni zawadi yenye kungu nono imuhamirayo Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Seemu ndiyosala ya sadaka ya mtsere, indakala ya Aruni na anae. Iyo ni seemu takatifu kabisa ya sadaka yenye kungu nono ilaviwayo kpwa Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“Sadaka yoyosi ya mtsere ambayo mundamlavira Mwenyezi Mlungu inalondwa ikale ikatengezwa bila hamira, mana taphana ruhusa hata chidide ya kuhumira hamira wala asali kpwenye sadaka ilaviwayo kpwa Mwenyezi Mlungu kpwa kuochwa. ");
INSERT INTO dig_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Ela phahi munaweza kumrehera Mwenyezi Mlungu vitu hivyo phamwenga na mavuno genu ga mwandzo ga mtsere dza sadaka. Ela vitu hivyo tavindalaviwa dzulu ya phatu pha kulavira sadaka dza kungu nono imuhamirayo. ");
INSERT INTO dig_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Sadaka zenu zosi za mtsere mundazitiya munyu. Musiriche hata chidide kutiya munyu sadaka zenu za mtsere, mana munyu ni ishara ya chilagane Mlungu wenu arichoika namwi. Msikose kutiya munyu sadaka zenu zosi. ");
INSERT INTO dig_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“Wakati munamlavira Mwenyezi Mlungu sadaka ya mtsere ya mavuno genu ga mwandzo, mlavireni masuche chigoochwa na kubundugbwa. ");
INSERT INTO dig_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Mundaitiya mafuha na kutiya ubani. Iyo ni sadaka ya mtsere. ");
INSERT INTO dig_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Mlavyadzi-sadaka andaocha seemu ya sadaka iyo ya mtsere iriyobundugbwa na mafuha phamwenga na ubaniwe wosi, ili kuonyesa kukala sadaka yosi ni ya Mwenyezi Mlungu. Iyo ni sadaka ilaviwayo kpwa Mwenyezi Mlungu kpwa kuochwa. ");
INSERT INTO dig_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“Napho mutu analavya sadaka ya amani kpwa Mwenyezi Mlungu na sadakaye ni ngʼombe lume au chetu, nyama hiye asikale na chirema. ");
INSERT INTO dig_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Andaika mkpwonowe dzulu ya chitswa cha nyama hiye na kumtsindza kpwenye phatu pha kumenyera hema ra mkpwutano. Chisha alavyadzi-sadaka, ana a Aruni andahala milatso na kumwagira-mwagira pande zosi ne za pho phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Marunya gosi ganagofwinika mahumbo na garigo dzulu ya mahumbo ga nyama wa sadaka iyo ya amani gandalaviwa dza sadaka kpwa Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","Viratu vira andalavya figo zosi mbiri na marunyage phamwenga na chala cha ini. ");
INSERT INTO dig_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Ana a Aruni andaviocha hivyo vyosi dzulu ya phatu pha kulavira sadaka phamwenga na sadaka za kuochwa zinazokala dzulu ya kuni ziakazo pho dzulu ya phatu pha kulavira sadaka. Iyo ni zawadi yenye kungu nono imuhamirayo Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“Napho sadaka iyo ya amani anayomlavira Mwenyezi Mlungu ni kula kundi ra mangʼondzi na mbuzi, phahi ni atsambulwe lume au chetu risirokala na chirema. ");
INSERT INTO dig_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Napho mutu andalavya ngʼondzi rikale sadakaye, phahi naarirehe mbere za Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Naye ni aike mkpwonowe dzulu ya chitswa cha nyama hiye na amtsindze mbere ya hema ra mkpwutano. Ana a Aruni andamwagira-mwagira milatsoye chila uphande wa phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Chisha, kula kpwenye sadaka iyo ya amani inayolaviwa kpwa Mwenyezi Mlungu, mutu ni arehe seemu za marunya zilungirazo, mchira wosi wenye marunya okatwa phephi kabisa na mongomongo phamwenga na marunya gosi ganagofwinika mahumbo na marunya gosi garigo dzulu ya mahumbo, ");
INSERT INTO dig_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","piya figo zosi mbiri na marunyage phamwenga na chala cha ini. ");
INSERT INTO dig_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Achimala kuhenda hivyo, mlavyadzi-sadaka andaviocha hivyo vyosi dzulu ya phatu pha kulavira sadaka. Ni chakurya chinacholavirwa Mwenyezi Mlungu kpwa kuochwa. ");
INSERT INTO dig_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“Napho sadakaye ni mbuzi, phahi naairehe mbere za Mwenyezi Mlungu ");
INSERT INTO dig_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","kuno akabandika mkpwonowe dzulu ya chitswa cha nyama hiye na kumtsindza mbere ya hema ra mkpwutano. Ana a Aruni andahala milatso na kuimwagira-mwagira pande zosi ne za pho phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Alafu, andamlavira Mwenyezi Mlungu marunya gosi ganagofwinika mahumbo na gara garigo dzulu ya mahumbo, ");
INSERT INTO dig_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","na figo zosi mbiri na marunyage phamwenga na chala cha ini. ");
INSERT INTO dig_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Mlavyadzi-sadaka andaviocha dzulu ya phatu pha kulavira sadaka dza chakurya chinacholaviwa kpwa Mwenyezi Mlungu chenye kungu nono imuhamirayo Mwenyezi Mlungu. Marunya gosi ni ga Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“Msirye marunya wala milatso hata chidide. Hiri ni lagizo ra kare na kare kula chivyazi hadi chivyazi ta kare na kare phatu phophosi mndiphokala.” ");
INSERT INTO dig_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Chisha Mwenyezi Mlungu wamuamba Musa, ");
INSERT INTO dig_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Aambire atu a Iziraeli kukala ichikala mutu akahenda dambi bila kumanya, naye achihenda chitu chochosi chokahazwa kahi za malagizo ga Mwenyezi Mlungu, andahenda hivi: ");
INSERT INTO dig_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“Ichikala mlavyadzi-sadaka mkpwulu ndiye achiyehenda dambi hata akatiya atu makosani, phahi hiye andamlavira Mwenyezi Mlungu mwana ndzau asiyekala na chirema akale sadaka ya kuusa dambi. ");
INSERT INTO dig_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Andareha mwana ndzau phatu pha kumenyera hema ra mkpwutano, mbere za Mwenyezi Mlungu. Andaika mkpwonowe dzulu ya chitswa cha ye mwana ndzau na kumtsindza mbere za Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Hiye mlavyadzi-sadaka mkpwulu andahala seemu ya milatso na kuinjira nayo ndani ya hema ra mkpwutano. ");
INSERT INTO dig_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Andadyoga chalache kpwenye milatso iyo na kuitimvya-timvya kano sabaa mbere za Mwenyezi Mlungu, mbere ya paziya yo ganya Phatu Phatakatifu na Phatu Phatakatifu Zaidi. ");
INSERT INTO dig_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Mlavyadzi-sadaka andahala seemu ya milatso na kuipaka kpwenye hizo pembe zirizo kpwenye pembe za phatu pha kufukiza uvumba wenye kungu nono, mbere za Mwenyezi Mlungu kpwenye hema ra mkpwutano. Milatso ndiyosala andaimwaga photsi kpwenye hako ra phatu pha kulavira sadaka ya kuochwa ambapho ni phephi na phatu pha kumenyera hema ra mkpwutano. ");
INSERT INTO dig_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Alafu andausa marunya gosi ga hiye mwana ndzau wa sadaka ya kuusa dambi: Marunya gosi ganagofwinika mahumbo na garigo dzulu ya mahumbo, ");
INSERT INTO dig_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","figo mbiri na marunya garigo dzuluye na gara garigo kpwenye seemu ya phephi na chibiruni na gara ganagogbwirana na figo na maini. ");
INSERT INTO dig_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Hizi ni seemu ziratu zira zinazouswa kpwenye nyama wa sadaka ya amani. Mlavyadzi-sadaka andaziocha dzulu ya phatu pha kulavira sadaka ya kuochwa. ");
INSERT INTO dig_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Ela chingo ya hiye mwana ndzau, nyama, chitswa, marondo, mahumbo na ufumbawe, ");
INSERT INTO dig_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","jibu seemu zosi za mwana ndzau chizosala ni lazima aziphirike kondze ya kambi akazioche na moho wa kuni, phatu swafi phatsuphiwapho ivu ra phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“Ichikala Aiziraeli osi phamwenga akahenda dambi bila kumanya kpwa kuhenda chitu chiricho kahazwa kpwenye lagizo mwengarapho ra Mwenyezi Mlungu, andakala akahenda makosa vivyo. ");
INSERT INTO dig_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Mara tu dambi iyo ndiphomanyikana, aho Aiziraeli andalavya mwana ndzau akale sadaka ya kuusira dambi. Andamreha kpwenye hema ra mkpwutano. ");
INSERT INTO dig_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Vilongozi a Aiziraeli andabandika mikono yao dzulu ya chitswa cha hiye mwana ndzau, alafu mmwenga wao andamtsindza mbere za Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Yuya mlavyadzi-sadaka mkpwulu yetsambulwa kpwa kumwagirwa mafuha andareha seemu ya milatso ya hiye mwana ndzau ndani ya hema ra mkpwutano. ");
INSERT INTO dig_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Andadyoga chalache kpwenye iyo milatso na kuitimvya-timvya mbere ya paziya kano sabaa, mbere za Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Alafu, seemu ya milatso andaipaka kpwenye hizo pembe zirizo kpwenye pembe za phatu pha kufukizira uvumba himo ndani ya hema ra mkpwutano mbere za Mwenyezi Mlungu. Milatso ndiyosala andaimwaga photsi kpwenye hako ra phatu pha kulavira sadaka ya kuochwa phephi na phatu pha kumenyera hema ra mkpwutano. ");
INSERT INTO dig_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Marunya gosi ga nyama hiye andagahala na kugaocha phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Kpwa hivyo andahenda hiye mwana ndzau dza arivyohenda yuya wanjina wa sadaka ya kuusira dambi. Chihivyo mlavyadzi-sadaka andakala akaahendera atu upatanisho kpwa kuausira dambi, nao andaswamehewa. ");
INSERT INTO dig_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Alafu andahala seemu za ye mwana ndzau chizosala aziphirike kondze ya kambi na kuziocha dza vira arivyohenda yuya wanjina. Iyo ni sadaka ya kuausira dambi Aiziraeli osi. ");
INSERT INTO dig_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“Ichikala chilongozi akahenda dambi bila kumanya kpwa kuvundza lagizo mwengarapho ra Mwenyezi Mlungu, Mlunguwe, andakala akahenda kosa vivyo, ");
INSERT INTO dig_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","naye achimanyiswa dambi ariyoihenda, andareha sadakaye ya ndenje asiyekala na chirema. ");
INSERT INTO dig_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Andaika mkpwonowe dzulu ya chitswa cha ndenje na kuitsindzira phatu atsindzirapho sadaka za kuochwa mbere za Mwenyezi Mlungu. Iyo ni sadaka ya kuusa dambi. ");
INSERT INTO dig_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Mlavyadzi-sadaka andadyoga chalache kpwenye milatso ya sadaka ya kuusa dambi na kuipaka kpwenye hizo pembe zirizo kpwenye pembe za phatu pha kulavira sadaka za kuochwa. Milatso ndiyosala andaimwaga photsi kpwenye hako ra phatu pha kulavira sadaka za kuochwa. ");
INSERT INTO dig_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Marunya gosi ga ndenje hiye andagaocha dzulu ya phatu pha kulavira sadaka, dza vira arivyohenda marunya ga nyama wa sadaka ya amani. Kpwa hivyo mlavyadzi-sadaka andamuhendera chilongozi upatanisho kpwa kumuusira dambi, naye andaswamehewa. ");
INSERT INTO dig_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“Napho mutu wa kawaida akahenda dambi bila kumanya kpwa kuvundza lagizo mwengarapho ra Mwenyezi Mlungu, iye ana kosa. ");
INSERT INTO dig_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Na ndiphomanyiswa kukala akahenda dambi, andareha sadaka ya mbuzi chetu isiyokala na chirema kpwa ajili ya kuusira dambi ariyohenda. ");
INSERT INTO dig_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Andaika mkpwonowe dzulu ya chitswa cha mbuzi iyo ya sadaka ya kuusa dambi na kuitsindzira phatu atsindzirapho nyama a sadaka za kuochwa. ");
INSERT INTO dig_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Mlavyadzi-sadaka andadyoga chalache kpwenye milatso ya sadaka ya kuusa dambi na kuipaka kpwenye hizo pembe zirizo kpwenye pembe za phatu pha kulavira sadaka ya kuochwa. Milatso ndiyosala andaimwaga photsi kpwenye hako ra phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Ye mutu achiyereha yo sadaka andausa marunya gosi ga mbuzi hiye dza vira anavyousa marunya ga nyama a sadaka ya amani, naye mlavyadzi-sadaka andagaocha dzulu ya phatu pha kulavira sadaka, na harufuye nono indamhamira Mwenyezi Mlungu. Phahi, mlavyadzi-sadaka andamuhendera yuya mutu upatanisho kpwa kumuusira dambi, naye andaswamehewa. ");
INSERT INTO dig_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“Ichikala mutu hiye andareha ngʼondzi kpwa ajili ya sadaka ya kuusa dambi, phahi, andareha ngʼondzi chetu risiro na chirema. ");
INSERT INTO dig_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Andaika mkpwonowe dzulu ya chitswa cha ngʼondzi hiro ra sadaka ya kuusa dambi na kuritsindzira phatu atsindzirapho nyama a sadaka za kuochwa. ");
INSERT INTO dig_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Alafu mlavyadzi-sadaka andadyoga chalache kpwenye milatso ya sadaka ya kuusa dambi na kuipaka kpwenye hizo pembe zirizo kpwenye pembe za phatu pha kulavira sadaka za kuochwa. Milatso ndiyosala andaimwaga photsi phenye hako ra phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Alafu ye mutu achiyereha yo sadaka andausa marunya gosi dza vira anavyousa marunya ga ngʼondzi ra sadaka ya amani na mlavyadzi-sadaka andagaocha dzulu ya phatu pha kulavira sadaka, phamwenga na sadaka zilaviwazo kpwa Mwenyezi Mlungu kpwa kuochwa. Mlavyadzi-sadaka andamuhendera upatanisho kpwa kumuusira dambi, naye andaswamehewa. ");
INSERT INTO dig_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“Napho mutu yeyesi akalondwa kulavya ushaidi kpwenye baraza dzulu ya dzambo ariroriona au kusikira, na achirema kugomba chitu, andakala akahenda dambi na andaripha kpwa ajili ya dambi hiro. ");
INSERT INTO dig_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Au napho mutu yeyesi kahi yenu achidzinajisi bila kumanya kpwa kuguta chitu chochosi chiricho najisi, ikale ni lufu ra nyama wa tsakani au ra mfugo au ra nyama a kuambala na photsi, andakala najisi, na ni mkosa. ");
INSERT INTO dig_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Au mutu achiguta chitu chochosi kula kpwa mwanadamu chinachoisabiwa kukala najisi bila kumanya, chindamuhenda akale najisi, phahi, ndiphomanya andakala na makosa. ");
INSERT INTO dig_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Au, napho mutu achiapa kuhenda chitu chochosi, chinono au chii, dza vira atu ahendavyo bila kufikiriya, ndiphomanya andakala mkpwosa. ");
INSERT INTO dig_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Phahi, mutu achikala mkpwosa kuhusu dzambo mwengarapho ra higo ni lazima akubali dambiye ariyohenda. ");
INSERT INTO dig_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Naye ni amrehere Mwenyezi Mlungu ngʼondzi chetu au mbuzi chetu kula kpwenye mifugoye dza maripho kpwa ajili ya dambi ariyohenda ailavye ikale sadaka ya kuusa dambi. Naye mlavyadzi-sadaka andamuhendera upatanisho kpwa kumuusira dambi. ");
INSERT INTO dig_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“Ela napho kana uwezo wa kulavya ngʼondzi au mbuzi dza maripho kpwa dambi ariyohenda, phahi andamrehera Mwenyezi Mlungu njiya airi au ana njiya manga airi, mmwenga kpwa ajili ya sadaka ya kuusa dambi na wanjina kpwa ajili ya sadaka ya kuochwa. ");
INSERT INTO dig_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Andaareha kpwa mlavyadzi-sadaka, naye mlavyadzi-sadaka andamlavya mmwenga kpwandza akale sadaka ya kuusa dambi kpwa kummwamula chitswa bila kuusa chitswache kabisa. ");
INSERT INTO dig_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Seemu ya milatsoye andaitimvya-timvya uphande mmwenga wa phatu pha kulavira sadaka na hira yanjina andaitweneza-tweneza photsi kpwenye hako ra phatu pha kulavira sadaka. Iyo ni sadaka ya kuusa dambi. ");
INSERT INTO dig_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Alafu andamlavya yuya wa phiri kukala sadaka ya kuochwa kulengana na malagizo. Mlavyadzi-sadaka andamuhendera yuya mutu upatanisho kpwa kumuusira dambiye, naye andaswamehewa. ");
INSERT INTO dig_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“Ichikala kana uwezo wa kulavya hata njiya airi au ana njiya manga airi dza sadakaye ya kuusa dambi ariyohenda, phahi, andareha unga mnono kilo mwenga. Ela kandautiya mafuha wala ubani mana ni sadaka ya kuusa dambi. ");
INSERT INTO dig_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Andamrehera mlavyadzi-sadaka, naye andahala unga hinyo fumba mwenga na kuuocha dzulu ya phatu pha kulavira sadaka kuonyesa kukala sadaka yosi ni ya Mwenyezi Mlungu phamwenga na sadaka alavirwazo Mwenyezi Mlungu kpwa kuochwa. Iyo ni sadaka ya kuusa dambi. ");
INSERT INTO dig_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Phahi, mlavyadzi-sadaka andamuhendera yuya mutu upatanisho kpwa kumuusira dambi, naye andaswamehewa. Unga uchiosala undakala wa mlavyadzi-sadaka dza vira inavyohendeka wakati wa kulavya sadaka ya mtsere.” ");
INSERT INTO dig_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Mwenyezi Mlungu waenderera kugomba na Musa achiamba, ");
INSERT INTO dig_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Napho mutu yeyesi akakosa kpwa kuhenda dambi bila kumanya kuhusu kusalavya vitu ambavyo ni vilavirwe Mwenyezi Mlungu, andamrehera turume risirokala na chirema dza maripho kpwa makosage kula kpwa mifugoye. Au undapima beiye kulengana na chipimo cha Phatu Phatakatifu. Iyo ni sadaka ya kuusa makosa. ");
INSERT INTO dig_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Zaidi ya higo, yuya mutu andaripha vitu ambavyo kala ni alavye kpwa Mwenyezi Mlungu ambavyo kavilavire na aenjereze seemu mwenga ya tsano ya beiye na kumupha mlavyadzi-sadaka. Phahi, mlavyadzi-sadaka andamuhendera upatanisho kpwa kumuusira dambi kuhumira hiro turume ambaro rindakala sadaka ya kuusa makosa, naye andaswamehewa. ");
INSERT INTO dig_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“Mutu yeyesi achihenda dambi bila kumanya, kpwa kuvundza lagizo mwengarapho ra Mwenyezi Mlungu, iye ni mkpwosa, na andaripha kpwa ajili ya kosare. ");
INSERT INTO dig_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Andamrehera mlavyadzi-sadaka turume risirokala na chirema kula kpwa mifugoye au samaniye ya pesa kpwa ikale sadaka ya kuusa makosa. Naye mlavyadzi-sadaka andamuhendera upatanisho kpwa kumuusira dambi ariyohenda bila kumanya, naye andaswamehewa. ");
INSERT INTO dig_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Iyo ni sadaka ya kuusa makosa, kpwa kukala iye ni mkpwosa mbere za Mwenyezi Mlungu.” ");
INSERT INTO dig_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Mwenyezi Mlungu waenderera kumuamba Musa, ");
INSERT INTO dig_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Ichikala mutu yeyesi ana kosa na si muaminifu mbere za Mwenyezi Mlungu kpwa sababu ya kumchenga myawe kuhusu chitu arichomuikira mzamana kpwa kuika naziri au kuhusu kumuiyira au kumuonera myawe, ");
INSERT INTO dig_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","au akaphaha chitu cha myawe choangamika na aambe kayachiona, au agombe handzo kpwa kuapa, au kuhenda dambi dza zizo zihendwazo ni atu. ");
INSERT INTO dig_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Napho mutu akahenda dambi dza hizo na kukala mkpwosa, ni lazima auyize chira arichoiya au arichophaha kpwa kuonera, au chira arichoikirwa mzamana kpwa kuika naziri au chitu cha myawe arichotsola, ");
INSERT INTO dig_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","au chitu chochosi choapa kpwa kuchenga. Andamuuyizira mwenye chila chitu chikamilifu na kuenjereza seemu mwenga ya tsano ya samaniye siku ndipholavya sadaka ya kuusa makosa. ");
INSERT INTO dig_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Piya andamrehera mlavyadzi-sadaka turume risirokala na chirema kula kpwa mifugoye dza maripho kpwa ajili ya dambize, amlavire Mwenyezi Mlungu sadaka ya kuusa makosa. Samani ya nyama hiye ni ikale sawa na chipimo cha kawaida cha bei ya turume wa sadaka ya kuusa dambi. ");
INSERT INTO dig_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Mlavyadzi-sadaka andamuhendera upatanisho kpwa kumuusira dambiye mbere za Mwenyezi Mlungu, naye andaswamehewa kosa arirorihenda.” ");
INSERT INTO dig_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Mwenyezi Mlungu achimuambira Musa, ");
INSERT INTO dig_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Muphe Aruni na anae malagizo higa kuhusu sadaka ya kuochwa. Sadaka ya kuochwa indakala kpwenye moho dzulu ya phatu pha kulavira sadaka usiku kucha hadi ligundzu na mohowe ukusanyirwe, usifwe. ");
INSERT INTO dig_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Alafu mlavyadzi-sadaka andavwala nguwoye ya katani na suruwaleye ya ndani ya katani, andahala ivu ra hira sadaka kula dzulu ya phatu pha kulavira sadaka na kuriika kanda ya phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Alafu andavula nguwoze avwale zanjina, ahale rira ivu ariphirike kondze ya kambi phatu phasipho najisi. ");
INSERT INTO dig_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Moho wa phatu pha kulavira sadaka lazima uenderere kuaka usifwe. Chila siku ligundzu mlavyadzi-sadaka andatiya kuni kpwenye moho hinyo na dzuluye andapanga sadaka ya kuochwa, na kuocha marunya ga sadaka ya amani dzuluye. ");
INSERT INTO dig_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Moho undarorerwa uenderere kuaka siku zosi dzulu ya phatu pha kulavira sadaka bila kufwa. ");
INSERT INTO dig_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“Higa ni malagizo ganjina kuhusu sadaka ya mtsere. Ana a Aruni ndio ndioreha sadaka hizo mbere za Mwenyezi Mlungu, mbere ya phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Mmwenga wa alavyadzi-sadaka andahala fumba mwenga ra unga mnono wa mtsere phamwenga na mafuha na ubani wosi dzulu ya sadaka ya mtsere na kuviocha dzulu ya phatu pha kulavira sadaka ili kuonyesa kukala sadaka yosi ni ya Mwenyezi Mlungu, na harufuye nono indamhamira. ");
INSERT INTO dig_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Unga ndiosala undakala wa Aruni na anae. Aho andatengeza mkpwahe bila kutiywa hamira, nao andaurya Phatu Phatakatifu, yani pho muhala wa hema ra mkpwutano. ");
INSERT INTO dig_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Usitengezwe na hamira hata chidide, mimi nkaapha dza mtalo wao kula sadaka nilavirwazo. Ni sadaka takatifu kabisa dza vira sadaka ya kuusa dambi na ya kuusa makosa zikalavyo. ");
INSERT INTO dig_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Alume a chivyazi cha Aruni machiyao ndio anaoruhusiwa kurya seemu iyo mana iyo yatengbwa siku zosi kpwa ajili yao kula sadaka alavirwazo Mwenyezi Mlungu kpwa kuochwa. Yeyesi ndiyeguta sadaka iyo ni akale mtakatifu.” ");
INSERT INTO dig_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Mwenyezi Mlungu achimuambira Musa, ");
INSERT INTO dig_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Siku ya kumwagirwa mafuha kpwa Aruni na anae, aho analondwa kumlavira Mwenyezi Mlungu kilo mwenga ya unga mnono dza sadaka ya mtsere ya chila siku; nusu mwenga andailavya ligundzu na yanjina dziloni. ");
INSERT INTO dig_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Unga hinyo undatsanganywa vinono na mafuha na kujitwa dzulu ya chuma cha kukalangira. Alafu undaureha hali u vipande-vipande na kumlavira Mwenyezi Mlungu na kungu nono ya sadakaye indamhamira. ");
INSERT INTO dig_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Ye mlavyadzi-sadaka wa chivyazi cha Aruni ndiyemwagirwa mafuha ili ahale nafwasi ya Aruni, ndiye ndiyeilavya. Sadaka yosi ni iochwe kabisa kpwa ajili ya Mwenyezi Mlungu. Hiro ni lagizo ta kare na kare. ");
INSERT INTO dig_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Sadaka yoyosi ya mtsere ilaviwayo ni mlavyadzi-sadaka indaochwa yosi; taindariwa hata chidide.” ");
INSERT INTO dig_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Mwenyezi Mlungu achimuambira Musa, ");
INSERT INTO dig_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Muambire Aruni na anae kukala higa ni malagizo ganjina kuhusu sadaka ya kuusa dambi. Nyama wa sadaka ya kuochwa ni atsindzwe hipho atsindzirwapho nyama a sadaka ya kuusa dambi, mbere za Mwenyezi Mlungu. Iyo ni sadaka takatifu kabisa. ");
INSERT INTO dig_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Mlavyadzi-sadaka alavyaye sadaka iyo ndiye ndiyeirya. Indariwa Phatu Phatakatifu, yani pho muhalani pha hema ra mkpwutano. ");
INSERT INTO dig_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Mutu yeyesi au chochosi ndichoguta nyama iyo chindakala chitakatifu. Nguwo yoyosi ichitwenerwa ni milatso ya sadaka iyo, phahi, nguwo iyo indafulwa Phatu Phatakatifu. ");
INSERT INTO dig_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Sadaka iyo ichijitwa kpwenye nyungu, nyungu iyo ni ivundzwe. Ela ichikala miyo iyo ni ya shaba, phahi, indatsukutswa vinono na kusuzwa na madzi. ");
INSERT INTO dig_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Chila mlume osi kahi ya nyumba ya alavyadzi-sadaka anaruhusiwa kurya iyo sadaka takatifu kabisa. ");
INSERT INTO dig_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Ela sadaka yoyosi ya dambi ambayo milatsoye ikarehwa ndani ya hema ra mkpwutano kpwa kuhenda upatanisho kpwa kuusa dambi Phatu Phatakatifu ni isiriwe, sadaka iyo ni iochwe. ");
INSERT INTO dig_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“Higa ni malagizo ganjina kuhusu sadaka ya kuusa makosa. Sadaka iyo ni takatifu kabisa. ");
INSERT INTO dig_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Nyama wa sadaka ya kuusa makosa ni atsindzwe phatu phatsindzwapho nyama wa sadaka ya kuochwa na milatsoye indamwagirwa-mwagirwa pande zosi za phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Marunyage gosi gandalaviwa na kuochwa, yani mchira wenye marunya, marunya ganagofwinika mahumbo, ");
INSERT INTO dig_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","figo zosi mbiri phamwenga na marunyage na chala cha ini. ");
INSERT INTO dig_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Mlavyadzi-sadaka andaviocha dzulu ya phatu pha kulavira sadaka dza zawadi zilaviwazo kpwa Mwenyezi Mlungu kpwa kuochwa. Iyo ni sadaka ya kuusa makosa. ");
INSERT INTO dig_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Anaoruhusiwa kurya sadaka iyo ni alume a nyumba ya alavyadzi-sadaka machiyao; ni iriwe Phatu Phatakatifu mana ni sadaka takatifu kabisa. ");
INSERT INTO dig_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Malagizo kuhusu sadaka ya kuusa makosa na sadaka ya kuusa dambi ni mwenga. Mlavyadzi-sadaka ndiyehenda upatanisho kpwa kuusa dambi ndiye ndiyehala zo nyama. ");
INSERT INTO dig_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Mlavyadzi-sadaka anayelavira mutu yeyesi sadaka ya kuochwa, andahala chingo ya nyama chiyelaviwa. ");
INSERT INTO dig_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Sadaka yoyosi ya mtsere yoochwa kpwenye dziko ra kuochera mikahe au chuma cha kuochera mikahe au kalango indakala ya mlavyadzi-sadaka anayeilavya. ");
INSERT INTO dig_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Chila sadaka yanjina ya mtsere, ikale ikatsanganywa na mafuha au kavu, indakala ya chivyazi cha Aruni na osi aganyirwe sawa kpwa sawa. ");
INSERT INTO dig_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“Higa ni malagizo ganjina kuhusu sadaka ya amani ambayo mutu anaweza kumlavira Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Ichikala mutu analavya sadaka iyo kpwa kumshukuru Mlungu, phahi, andailavya phamwenga na mikahe iriyotsanganywa na mafuha, mikahe myembamba yopakpwa mafuha na mikahe ya unga mnono uriotsanganywa na mafuha, yosi isiyotiywa hamira. ");
INSERT INTO dig_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Phamwenga na sadakaye ya amani ya kumshukuru Mlungu, andareha mikahe chiyotiywa hamira. ");
INSERT INTO dig_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Kula chila aina ya mikahe iyo, andamrehera Mwenyezi Mlungu mkpwahe mmwenga dza zawadi. Mikahe iyo indakala ya mlavyadzi-sadaka anayemwaga-mwaga milatso ya nyama wa sadaka ya amani hipho phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Nyama ya sadaka iyo ya amani ya kumshukuru Mlungu ni iriwe siku iyo-iyo ya kulaviwa. Ni isisazwe hata chidide hadi ligundzu. ");
INSERT INTO dig_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Ela napho sadaka iyo ya amani ni ya kuusa naziri au ya hiyari, indariwa siku iyo-iyo ndiyolaviwa na seemu ndiyosala inaweza kuriwa siku ya phiriye. ");
INSERT INTO dig_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Ela nyama yoyosi ya sadaka iyo ndiyosala hadi siku ya hahu ni iochwe. ");
INSERT INTO dig_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Napho nyama yoyosi ya sadaka ya amani indariwa siku ya hahu, yo sadaka iyo taindakubaliwa, wala hiye achiyeilavya kandaisabiwa kukala akahenda chitu. Nyama iyo ni tsukizo na mutu ndiyeirya andakala akahenda dambi na andaripha kpwa ajili ya dambi hiro. ");
INSERT INTO dig_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“Nyama yoyosi ndiyoguta chitu chinachoisabiwa kukala najisi isiriwe, ni iochwe. Na yo nyama yanjina, inaweza kuriwa ni osi ambao taakadzitiya najisi. ");
INSERT INTO dig_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Ela mutu yeyesi anayeisabiwa kukala najisi achirya nyama iyo yolaviwa dza sadaka ya amani kpwa Mwenyezi Mlungu, andatengbwa na atue. ");
INSERT INTO dig_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Mutu yeyesi achiguta chitu chochosi chinachoisabiwa kukala najisi, ikale ni mutu, nyama, au chitu chanjina chochosi chisha arye nyama ya sadaka ya amani iriyolaviwa kpwa Mwenyezi Mlungu mutu hiye andatengbwa na atue.” ");
INSERT INTO dig_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Mwenyezi Mlungu achimuambira Musa, ");
INSERT INTO dig_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Aambire Aiziraeli hivi, ‘Msirye marunya ga ngʼombe, ga mangʼondzi wala ga mbuzi. ");
INSERT INTO dig_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Marunya ga nyama yeyesi yefwa mwenye au ga nyama yeolagbwa ni nyama wa tsakani msigarye ela ganaweza kuikpwa kpwa mahumizi ganjina. ");
INSERT INTO dig_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Mutu yeyesi achirya marunya ga nyama chiyelaviwa kpwa Mwenyezi Mlungu kpwa kuochwa, andatengbwa na atue. ");
INSERT INTO dig_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Piya, msirye milatso yoyosi, ikale ni ya nyama wa mapha au ya nyama wa kufuga phophosi msagalapho. ");
INSERT INTO dig_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Mutu yeyesi achirya milatso, andatengbwa na atue.’ ” ");
INSERT INTO dig_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Mwenyezi Mlungu achimuambira Musa, ");
INSERT INTO dig_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Aambire atu a Iziraeli hivi, ‘Mutu yeyesi achilavya sadaka ya amani, ni arehe seemu ya sadaka iyo kpwa Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Andamrehera sadaka iyo na mikonoye dza zawadi. Andareha marunyage phamwenga na laga ambayo andaiunula dzulu mbere za Mwenyezi Mlungu dza sadaka ya kuunulwa. ");
INSERT INTO dig_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Mlavyadzi-sadaka andaocha marunya gosi dzulu ya phatu pha kulavira sadaka, ela laga indakala ya Aruni na anae. ");
INSERT INTO dig_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Chiga cha kulume cha nyama wa sadaka zenu za amani mundamupha mlavyadzi-sadaka. ");
INSERT INTO dig_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Chiga hicho chindakala cha mutu wa chivyazi cha Aruni ndiyemwaga-mwaga milatso na kulavya marunya ga sadaka ya amani. ");
INSERT INTO dig_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Kpwa kukala yo laga ichiyounulwa dzulu na cho chiga chirehwacho mbere yangu nkachihala kula kpwa sadaka za amani za Aiziraeli na nkachipha mlavyadzi-sadaka Aruni na chivyaziche, seemu hizo nkaapha hinyo alavyadzi-sadaka zikale mtalo wao hata kare na kare. ");
INSERT INTO dig_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Hizo ndizo seemu zotengbwa kpwa ajili ya Aruni na anae kahi ya sadaka za kuochwa areherwazo Mwenyezi Mlungu, hangu siku ariphoikpwa kukala alavyadzi-sadaka a Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Ariphotakaswa kpwa kumwagirwa mafuha, Mwenyezi Mlungu waalagiza Aiziraeli aaphe seemu iyo ya sadaka; iyo indakala dza mtalo wao siku zosi.’ ” ");
INSERT INTO dig_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Phahi, higa ndigo malagizo kuhusu sadaka ya kuochwa, sadaka ya mtsere, sadaka ya kuusa dambi, sadaka ya kuusa makosa, sadaka ya kutenga mutu kpwa ajili ya Mlungu na kuhusu sadaka ya amani. ");
INSERT INTO dig_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Mwenyezi Mlungu wamupha Musa shariya hizi dzulu ya mwango Sinai siku iyo ariphoaamuru Aiziraeli amrehere sadaka zao, hiko jangbwa ra Sinai. ");
INSERT INTO dig_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Mwenyezi Mlungu achimuambira Musa, ");
INSERT INTO dig_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Rehe Aruni na anae na nguwo zao, mafuha ga utakaso, ndzau ya sadaka ya kuusa dambi, maturume mairi na kaphu ya mikahe isiyotiywa hamira. ");
INSERT INTO dig_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Alafu, ukusanye Aiziraeli osi phamwenga mbere ya phatu pha kumenyera hema ra mkpwutano.” ");
INSERT INTO dig_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Musa achihenda dza arivyolagizwa ni Mwenyezi Mlungu. Aiziraeli osi akusanyika phamwenga mbere ya phatu pha kumenyera hema ra mkpwutano. ");
INSERT INTO dig_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Musa achiaambira gara ambago Mwenyezi Mlungu kala akamlagiza ahende. ");
INSERT INTO dig_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Alafu Musa achiiha Aruni na anae edze mbere na achiaogesa. ");
INSERT INTO dig_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Alafu achimvwika Aruni kandzu na achimfunga mkumbuu chibiruni, achimvwika joho, achimvwika chisibao na achichifunga na mkumbuu uriofumwa chiufundi mwakpwe chibiruni. ");
INSERT INTO dig_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Alafu achimvwika Aruni chifuko cha lagani na ndani ya hicho chifuko achitiya Urimu na Thumimu. ");
INSERT INTO dig_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Chisha achimvwika Aruni chiremba na uphande wa mbere wa hicho chiremba wachibandika chibamba cha zahabu, yani tadzi takatifu, dza Mwenyezi Mlungu arivyomlagiza Musa. ");
INSERT INTO dig_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Alafu Musa achihala mafuha ga utakaso, achiripaka rira hema ra mkpwutano na vitu vyosi virivyokala mumo achivitakasa. ");
INSERT INTO dig_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Achitimvya-timvya kano sabaa seemu ya mafuha higo dzulu ya phatu pha kulavira sadaka, na miyoye yosi, birika na hakore ili aitakase. ");
INSERT INTO dig_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Chisha Musa achimmwagira Aruni mafuha chitswani ili amtakase. ");
INSERT INTO dig_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Alafu Musa achiareha ana a Aruni achiavwika kandzu, achiafunga mikumbuu vibiruni na kuavwika viremba dza viratu arivyolagizwa ni Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Chisha Musa achireha ndzau ya sadaka ya kuusa dambi, naye Aruni na anae achiika mikono yao dzulu ya chitswa cha yo ndzau. ");
INSERT INTO dig_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Musa achitsindza yo ndzau, achihala seemu ya milatso achiipaka kpwenye hizo pembe zirizo kpwenye pembe za phatu pha kulavira sadaka kpwa chalache ili kuphatakasa. Alafu achihala milatso chiyosala achiimwaga photsi phenye hako ra phatu pha kulavira sadaka, chihivyo achiphatakasa ili aphahumire kpwa kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Alafu, Musa achihala marunya gosi gokala kpwenye mahumboge, chala cha ini phamwenga na figo zosi mbiri na marunyage na achiviocha dzulu ya phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Ela nyama, chingo na ufumba wa ndzau hiye, achiviocha kondze ya kambi dza Mwenyezi Mlungu arivyomlagiza Musa. ");
INSERT INTO dig_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Alafu, Musa achireha turume ra sadaka ya kuochwa. Aruni na anae achiika mikono yao dzulu ya chitswa cha turume hiro. ");
INSERT INTO dig_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Musa achiritsindza na milatsoye achiitimvya-timvya chila uphande wa pho pha phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Achikata-kata hiro turume vipande-vipande na Musa achiviocha phamwenga na chitswache na marunyage. ");
INSERT INTO dig_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Alafu gara mahumbo na marondo achigatsukutsa na madzi, Musa achigaocha gosi dzulu ya phatu pha kulavira sadaka phamwenga na seemu zanjina za ro turume dza sadaka ya kuochwa. Iyo ni zawadi yenye kungu nono imuhamirayo Mwenyezi Mlungu. Musa achihenda kama arivyolagizwa ni Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Alafu achireha turume ranjina, dza sadaka ya kuatenga kpwa ajili ya Mwenyezi Mlungu. Aruni na anae achiika mikono yao dzulu ya chitswa cha turume hiro. ");
INSERT INTO dig_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Musa achiritsindza. Achihala seemu ya milatso ya hiro turume na achimpaka Aruni kpwenye ndewe ya sikirore ra kulume, dzalagumbe ra mkpwonowe wa kulume na ra chiguluche cha kulume. ");
INSERT INTO dig_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Ana a Aruni nao achedza, naye Musa achiapaka seemu ya milatso kpwenye ndewe za masikiro gao ga kulume, madzalagumbe ga mikono yao ya kulume na ga magulu gao ga kulume. Milatso yanjina achiitimvira-timvira pho phatu pha kulavira sadaka chila uphande. ");
INSERT INTO dig_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Alafu, achihala marunya gosi, yani mchira wenye marunya, marunya gosi ganagofwinika mahumbo, chala cha ini, phamwenga na figo zosi mbiri na marunyage na chiga cha kulume. ");
INSERT INTO dig_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Alafu, achihala mkpwahe mmwenga uriokandwa na mafuha, keki mwenga na bisikuti mwenga kula kpwenye kaphu ya mikahe isiyotiywa hamira iriyo mbere za Mwenyezi Mlungu achiviika vyosi dzulu ya vipande vya marunya na chira chiga. ");
INSERT INTO dig_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Musa achiviika mikononi mwa Aruni na anae, nao achiviunula dzulu kuonyesa akamlavira Mwenyezi Mlungu dza sadaka ya kuunulwa. ");
INSERT INTO dig_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Alafu Musa achihala vitu hivyo vyosi kula mwao mikononi achiviocha dzulu ya phatu pha kulavira sadaka phamwenga na sadaka za kuochwa. Hino ni sadaka ya kuikpwa mbere za Mwenyezi Mlungu, yenye kungu nono imuhamirayo Mwenyezi Mlungu, hino ni zawadi yenye kungu nono imuhamirayo Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Chisha Musa achihala ira laga na achiiunula dzulu achilavya sadaka ya kuunulwa mbere za Mwenyezi Mlungu. Seemu iyo ya turume ra kutengera alavyadzi-sadaka kpwa ajili ya Mwenyezi Mlungu ni mtalo wa Musa dza arivyolagizwa ni Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Alafu Musa wahala chiasi cha mafuha ga utakaso na milatso kula phatu pha kulavira sadaka achimtimvira-timvira Aruni na anae na nguwo zao piya. Chihivyo Musa achimtenga Aruni na anae na nguwo zao kpwa ajili ya Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Musa achimuambira Aruni na anae, “Jitani hira nyama pho phatu pha kumenyera hema ra mkpwutano, muirye phapho hipho phamwenga na mikahe iriyo mo kaphuni mwenye sadaka za kutenga alavyadzi-sadaka kpwa ajili ya Mwenyezi Mlungu. Hendani dza vira nirivyokulagiza uwe na anao kukala seemu iyo ni iriwe ni mwimwi. ");
INSERT INTO dig_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Nyama yoyosi au mkpwahe wowosi ndiosala ni uochwe. ");
INSERT INTO dig_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Tamundatuluka kondze ya phatu pha kumenyera hema ra mkpwutano kpwa muda wosi wa siku sabaa, yani hadi muda wenu wa kutengbwa kpwa ajili ya Mwenyezi Mlungu usire. ");
INSERT INTO dig_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Mwenyezi Mlungu akalagiza huhende dza vira huchivyohenda rero kusudi hukuhendereni upatanisho kpwa kukuusirani dambi. ");
INSERT INTO dig_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Ni msale pho phatu pha kumenyera hema ra mkpwutano usiku na mutsi kpwa muda wa siku sabaa, na muhende gara mrigolagizwa ni Mwenyezi Mlungu, ili msifwe. Hivi ndivyo nirivyolagizwa ni Mwenyezi Mlungu.” ");
INSERT INTO dig_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Phahi, Aruni na anae achihenda gosi ambago Mwenyezi Mlungu walagiza kutsupira Musa. ");
INSERT INTO dig_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Siku sabaa za kutakaswa ziriphosira, Musa achimuiha Aruni na anae phamwenga na atumia a Iziraeli. ");
INSERT INTO dig_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Achimuambira Aruni, “Hala mwana ndzau kpwa ajili ya sadaka ya kuusa dambi na turume kpwa ajili ya sadaka ya kuochwa, nyama osi hinyo asikale na virema, uarehe mbere za Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Aambire Aiziraeli ahale ndenje mwenga kpwa ajili ya sadaka ya kuusa dambi, mwana ndzau mmwenga wa mwaka mmwenga na turume mwenga ra mwaka mmwenga, kpwa ajili ya sadaka ya kuochwa, osi asiokala na virema. ");
INSERT INTO dig_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Ndzau mmwenga na turume mmwenga kpwa ajili ya sadaka ya amani, alavye mbere za Mwenyezi Mlungu phamwenga na sadaka ya mtsere uriotsanganywa na mafuha, mana rero Mwenyezi Mlungu andaatsembukira.” ");
INSERT INTO dig_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Aiziraeli achireha vyosi hivyo mbere ya hema ra mkpwutano dza vira Musa arivyolagiza na osi phamwenga achisengera phephi mbere za Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Musa achiaambira, “Mwenyezi Mlungu akakulagizani muhende dzambo hiri ili muone ngumaye.” ");
INSERT INTO dig_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Alafu Musa achimuambira Aruni, “Phiya pho phatu pha kulavira sadaka, ukalavye sadakayo ya kuusa dambi na sadaka ya kuochwa. Piya ulavye sadaka za kuusa dambi chizorehwa ni atu na za kuochwa na uhende upatanisho kpwa kuusa dambiyo na za atu dza vira Mwenyezi Mlungu arivyolagiza.” ");
INSERT INTO dig_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Phahi, Aruni achisengerera phatu pha kulavira sadaka, achitsindza yuya mwana ndzau dza sadaka ya kuusa dambiye mwenye. ");
INSERT INTO dig_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Anae achimrehera milatso, naye Aruni achidyoga chalache kpwenye milatso iyo na kuipaka kpwenye hizo pembe zirizo kpwenye pembe za phatu pha kulavira sadaka. Milatso yosala achiimwaga kpwenye hako ra phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Achihala marunya, figo na chala cha ini cha yo sadaka ya kuusa dambi achiviocha vyosi dzulu ya phatu pha kulavira sadaka dza vira Mwenyezi Mlungu arivyolagiza Musa. ");
INSERT INTO dig_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Ela nyama na chingo achiviocha mohoni kondze ya kambi. ");
INSERT INTO dig_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Alafu Aruni achitsindza nyama wa sadaka ya kuochwa. Anae achimrehera milatso, naye achiimwagira-mwagira phatu pha kulavira sadaka pande zosi. ");
INSERT INTO dig_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Chisha achimrehera sadaka za kuochwa, chipande chimwenga-chimwenga, na chitswa, naye achiviocha dzulu ya phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Achitsukutsa mahumbo na marondo na achigaocha dzulu ya zo seemu zanjina za sadaka ya kuochwa pho phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Alafu, Aruni achireha sadaka ya atu. Achihala ndenje ya sadaka ya kuusira atu dambi, achiitsindza na kuilavya sadaka ya kuusa dambi, dza viratu arivyohenda kpwa hira ya mwandzo. ");
INSERT INTO dig_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Alafu achireha hira sadaka ya kuochwa na achiilavya kulengana na lagizo. ");
INSERT INTO dig_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Kanda na sadaka ya mtsere ariyoitiya kpwenye sadaka ya kuochwa ya chila ligundzu, wanyaha fumba mwenga ra mtsere na kuriocha dzulu ya phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Viratu vira Aruni, achitsindza hira ndzau na rira turume ra sadaka ya amani kpwa ajili ya atu. Anae achimrehera milatso ambayo waimwagira-mwagira pande zosi za phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Wahala marunya gosi ga ndzau hiye na turume hiro, yani mchira wenye marunya wa turume, marunya gofwinika mahumbo, figo na chala cha ini, ");
INSERT INTO dig_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","achigaika dzulu ya vidari, na achigatsukula hadi phatu pha kulavira sadaka achigaocha. ");
INSERT INTO dig_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Ela vira vidari na vira viga vya kulume, Aruni waviunula dzulu kuonyesa akamlavira Mwenyezi Mlungu dza sadaka ya kuunulwa, kulengana na vira Musa arivyolagiza. ");
INSERT INTO dig_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Aruni ariphomala kulavya sadaka zosi, yani sadaka ya kuusa dambi, sadaka za kuochwa na sadaka za amani, achiaunurira atu mikono, achiabariki, alafu achitserera photsi. ");
INSERT INTO dig_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Chisha Musa na Aruni achiinjira ndani ya hema ra mkpwutano. Ariphotuluka achiabariki atu, na nguma ya Mwenyezi Mlungu ichiatsembukira atu osi. ");
INSERT INTO dig_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Moho wala mbere za Mwenyezi Mlungu uchiocha sadaka za kuochwa na marunya gokala dzulu ya phatu pha kulavira sadaka. Atu osi ariphoona hinyo moho apiga njerejere na achisujudu. ");
INSERT INTO dig_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Nadabu na Abihu, ana a Aruni, ahala chila mmwenga chetezoche, achiika moho na uvumba, achimlavira Mwenyezi Mlungu moho usioruhusiwa, ambao tauyalengana na lagizo ra Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Phahi, moho wala mbere za Mwenyezi Mlungu, uchiaocha hinyo barobaro nao achifwa mbereze. ");
INSERT INTO dig_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Kpwa hivyo, Musa achimuambira Aruni, “Higa ndigo gara Mwenyezi Mlungu arigogomba ariphoamba, ‘Nindadzionyesa kukala ni mtakatifu kahi ya hara ario phephi nami, nindahewa nguma mbere za atu osi!’ ” Aruni achinyamala zii. ");
INSERT INTO dig_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Phahi, Musa achiiha Mishaeli na Elizafani, ana a Uzieli, ise mdide wa Aruni, achiaambira edze ause nyufu za ndugu zao kula Phatu Phatakatifu na kuziphirika kondze ya kambi. ");
INSERT INTO dig_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Achigbwira kandzu za zo nyufu za ndugu zao achiaguruta hadi kondze ya kambi, dza vira Musa arivyoamuru. ");
INSERT INTO dig_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Alafu Musa achimuambira Aruni na anae, Eliazari na Ithamari, “Msidimule nyere zenu wala kukpwanyula nguwo zenu kpwa chiriro, la sivyo mundafwa na kuarehera Aiziraeli osi chivyamwenga tsukizi za Mwenyezi Mlungu. Ela ndugu zenu, yani nyumba yosi ya Iziraeli, anaweza kurira kpwa sababu ya moho hinyo Mwenyezi Mlungu achioreha. ");
INSERT INTO dig_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Msituluke kondze ya phatu pha kumenyera hema ra mkpwutano, ama sivyo mundafwa. Mana mafuha ga kutengbwa kpwa ajili ya Mwenyezi Mlungu ga dzulu yenu.” Aruni na anae achihenda kama vira Musa arivyoamba. ");
INSERT INTO dig_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Mwenyezi Mlungu achimuambira Aruni, ");
INSERT INTO dig_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Munaphomenya ndani ya hema ra mkpwutano, uwe na anao msinwe uchi wa zabibu wala uchi wowosi, ama sivyo mundafwa. Hiri rindakala lagizo ambaro vivyazi vyenu vyosi vinalondwa virilunge siku zosi. ");
INSERT INTO dig_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Mnalondwa kuika tafwauti kahi ya mambo matakatifu na mambo ga kawaida, kahi ya mambo garigo najisi na sigokala najisi. ");
INSERT INTO dig_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Mundaafundza Aiziraeli malagizo gosi ambago Mwenyezi Mlungu wakuambirani kutsupira Musa.” ");
INSERT INTO dig_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Musa achimuambira Aruni na anae ariosala, Eliazari na Ithamari, “Halani hira seemu ya sadaka ya mtsere yosala kula sadaka anazolavirwa Mwenyezi Mlungu. Mtengeze mikahe isiyotiywa hamira na muirye kanda-kanda ya phatu pha kulavira sadaka mana sadaka iyo ni takatifu kabisa. ");
INSERT INTO dig_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Mundairya Phatu Phatakatifu kpwa sababu hinyo ni mtaloo na chivyazicho kahi za sadaka zireherwazo Mwenyezi Mlungu kpwa kuochwa. Hivi ndivyo nirivyoamriwa. ");
INSERT INTO dig_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Ela laga chiyounulwa mbere za Mwenyezi Mlungu na chiga chinacholaviwa dza sadaka kpwa kuunulwa mbere za Mwenyezi Mlungu, munaweza kuvirya phatu phophosi ambapho si najisi. Undarya uwe na anao alume na achetu. Vitu hivyo ukahewa kama mtaloo na wa chivyazicho kula sadaka za amani za atu a Iziraeli. ");
INSERT INTO dig_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Chira chiga chiricholaviwa na laga chiyounulwa mbere za Mwenyezi Mlungu andavireha phamwenga na sadaka za marunya ganagolaviwa kpwa kuochwa. Hivyo vindakala vyako phamwenga na anao, hinyo ni mtalo wenu hata kare na kare dza vira Mwenyezi Mlungu arivyolagiza.” ");
INSERT INTO dig_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Phahi, Musa wauza-uza sana kuhusu hira ndenje ya sadaka ya kuusa dambi, naye achimanya kukala ikaochwa kare. Hivyo achiareyera sana Eliazari na Ithamari, ana a Aruni ariosala, achiauza, ");
INSERT INTO dig_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Kpwa utu wani tamyairya Phatu Phatakatifu? Iyo kala ni chitu chitakatifu kabisa na kala mkaihewa ili kuusa makosa ga Aiziraeli osi phamwenga na kuahendera upatanisho kpwa kuausira dambi mbere za Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Tsona, kpwa vira mlatsowe tauyarehwa ndani ya Phatu Phatakatifu, mwalondwa mumurye muhalani mbere ya hema ra mkpwutano dza nrivyolagiza.” ");
INSERT INTO dig_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Aruni achimuambira Musa, “Lola, rero akalavya sadaka yao ya kuusa dambi na sadaka yao ya kuochwa mbere za Mwenyezi Mlungu, na mambo higa gakahendeka. Dze, kalapho nkarya iyo sadaka ya kuusa dambi hivi rero, ingekubalika mbere za Mwenyezi Mlungu?” ");
INSERT INTO dig_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Musa ariphosikira higo, achihamirwa. ");
INSERT INTO dig_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Mwenyezi Mlungu achiaambira Musa na Aruni, ");
INSERT INTO dig_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Aambire Aiziraeli hivi: Kahi ya nyama osi kpwenye tsi, ambao munaweza kurya ni hano. ");
INSERT INTO dig_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Munaweza kurya nyama yeyesi mwenye makpwatsa goganyika seemu mbiri na anatserura. ");
INSERT INTO dig_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Ela kahi ya nyama atserurao, au ario na makpwatsa ga kuganyika seemu mbiri, msirye ngamia. Iye kpwenu ni najisi, mana anatserura ela kana makpwatsa ga kuganyika seemu mbiri. Msirye kpwangʼa mana ni najisi kpwenu. Anatserura, ela kana makpwatsa ga kuganyika seemu mbiri. Msirye tsungula mana ni najisi kpwenu. Anatserura, ela kana makpwatsa ga kuganyika seemu mbiri. ");
INSERT INTO dig_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Msirye kpwangʼa kpwa kukala iye anatserura ela makpwatsage tagayaganyika, hiye kpwenu ni najisi. ");
INSERT INTO dig_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Msirye tsungula, iye anatserura ela makpwatsage tagayaganyika, iye naye kpwenu ni najisi. ");
INSERT INTO dig_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Msirye nguluwe, iye ana makpwatsa garigoganyika ela katserura, hiye kpwenu ni najisi. ");
INSERT INTO dig_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Kpwa sababu nyama aha ni najisi, msirye nyama yao wala msigute nyufu zao. ");
INSERT INTO dig_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“Kahi ya viumbe vyosi vya madzini, munaweza kurya chiumbe chochosi chiricho na mapezi na mamba, chiricho baharini au myuhoni. ");
INSERT INTO dig_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Ela chochosi chiishicho baharini au myuhoni, ambacho tachina mapezi wala mamba, yani viumbe vyanjina vyosi viishivyo madzini ni najisi kpwenu. ");
INSERT INTO dig_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Viumbe hivyo vindakala najisi kpwenu. Msirye nyama yao, wala msigute nyufu zao mana ni najisi. ");
INSERT INTO dig_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Chiumbe chochosi chiishicho ndani ya madzi ambacho tachina mapezi na mamba ni najisi kpwenu. ");
INSERT INTO dig_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“Hinya ndio nyama a mapha ambao ni najisi kpwenu. Kpwa hivyo, msiarye: Kozi, furukombe, pungu, ");
INSERT INTO dig_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","mweko, aina zosi za nderi, ");
INSERT INTO dig_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","aina zosi za kunguru, ");
INSERT INTO dig_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","mbuni, bweka, dudumizi, aina zosi za chiphanga, ");
INSERT INTO dig_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","chororo, aina zosi za vimburu, aina zosi za manjera, korongo, koikoi, hudihudi na chila aina ya nundu, ");
INSERT INTO dig_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","mumbi, mwari, nderi, ");
INSERT INTO dig_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","manjera, aina zosi za koikoi, hudihudi na nundu. ");
INSERT INTO dig_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“Adudu osi enye mapha aambalao na magulu mane, ni najisi kpwenu. ");
INSERT INTO dig_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Ela, kahi ya adudu enye mapha anyendekao kpwa magulu mane mare ga kutiniratinira dzulu ya tsi munaweza kurya. ");
INSERT INTO dig_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Hinyo ni: Chila aina ya ndzije, ya nyoe, ya vyenene na ya mabandzi. ");
INSERT INTO dig_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Ela adudu anjina osi enye mapha na magulu mane ni najisi kpwenu. ");
INSERT INTO dig_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“Unaweza kudzinajisi kpwa kurya au kuguta nyama hinya; yeyesi ndiyeguta nyufu za nyama hinya andakala najisi hadi dziloni. ");
INSERT INTO dig_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Yeyesi ndiyetsukula nyufu zao ni afule nguwoze naye andakala najisi hadi dziloni. ");
INSERT INTO dig_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Nyama enye ni hara arioahulwa makpwatsa ela tagayaganyika kano mbiri na taatserura. Mutu yeyesi ndiyeguta nyufu za nyama hinyo andakala najisi. ");
INSERT INTO dig_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Nyama osi anyendekao kpwa mafumba gao kahi za osi anyendekao na magulu mane, ni najisi kpwenu na yeyesi ndiyeguta lufu ra nyama dza hiye andakala najisi hadi dziloni. ");
INSERT INTO dig_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Mutu yeyesi ndiyetsukula nyufu za nyama hinyo andakala najisi hadi dziloni, naye andafula nguwoze. Hinyo kpwenu ni najisi. ");
INSERT INTO dig_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“Kahi ya viumbe vinyendekavyo photsi hivi ni najisi kpwenu: Kala, kotso, chila aina ya mjusi, ");
INSERT INTO dig_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","phalaphala, mbulu kenge, chijenje, mbulu na lumbwi. ");
INSERT INTO dig_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Hinyo osi ni najisi kpwenu na yeyesi ndiyeguta nyufu zao, andakala najisi hadi dziloni. ");
INSERT INTO dig_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Napho lufu ra viumbe hivyo rikagbwerera chitu chochosi, ikale ni chifwaya cha muhi, nguwo, chingo, gunia au mwiyo wowosi unaohumirwa kpwa kazi yoyosi, mwiyo hinyo undakala najisi hadi dziloni. Ili kuchihenda chikale swafi chinalondwa kutsukutswa na madzi. ");
INSERT INTO dig_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Napho lufure rikagbwerera mwiyo wa ulongo, phahi, chitu chochosi chiricho ndani ya mwiyo hinyo ni najisi na mwiyo hinyo ni uvundzwe. ");
INSERT INTO dig_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Chakurya au chinwadzi chochosi chichiguta madzi kula mwiyo hinyo chindakala najisi. ");
INSERT INTO dig_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Chila chitu ambacho chikagbwererwa ni lufu, chindakala najisi. Ichikala ni dziko ra ulongo ra kuochera mikahe au nyungu ni ivundzwe. Vindakala najisi navyo ni vinajisi kpwenu. ");
INSERT INTO dig_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Pula za madzi au Chisima cha kudzengerwa tachindanajisika. Ela chochosi ndichoguta nyufu hizi chindakala najisi. ");
INSERT INTO dig_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Ichikala lufu rikagbwerera mbeyu za kuphanda, mbeyu hizo tazindakala najisi. ");
INSERT INTO dig_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Ela napho mbeyu zikatiywa madzini na zikagbwererwa ni lufu, phahi, mbeyu hizo ni najisi kpwenu. ");
INSERT INTO dig_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“Ichikala nyama yeyesi munayeruhusiwa kurya, akafwa mwenye, yeyesi ndiyeguta lufure, andakala najisi hadi dziloni. ");
INSERT INTO dig_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Mutu yeyesi achirya nyama ya lufu hiro andafula nguwoze na andakala najisi hadi dziloni. Na yeyesi ndiyetsukula lufu hiro, andafula nguwoze, naye andakala najisi hadi dziloni. ");
INSERT INTO dig_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“Chiumbe chochosi chinachonyendeka photsi ni tsukizo kpwenu, msichirye. ");
INSERT INTO dig_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Chochosi chinachoambala na ndani, chochosi chinachonyendeka photsi kpwa magulu mane au magulu manji, msichirye kpwa mana ni tsukizo. ");
INSERT INTO dig_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Kpwa hivyo msidzihende kukala tsukizo kpwa njira ya kurya au kuguta viumbe vihambalavyo mndadzinajisi. ");
INSERT INTO dig_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Kpwa sababu mimi, ndimi Mwenyezi Mlungu, Mlungu wenu, dzitakaseni na mkale atakatifu kpwa mana mimi ni mtakatifu. Wala msidzinajisi na chochosi chinachoambala photsi. ");
INSERT INTO dig_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Kpwa sababu mimi Mwenyezi Mlungu, ndimi yekutuluzani kula tsi ya Misiri kusudi nikale Mlungu wenu; kpwa hivyo kalani atakatifu kpwa mana mimi ni mtakatifu. ");
INSERT INTO dig_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“Iyo phahi, ndiyo shariya kuhusu nyama, nyama a mapha na viumbe vyosi virivyo moyo viishivyo ndani ya madzi na vinavyonyendeka photsi, ");
INSERT INTO dig_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","ili kutafwautisha kahi ya chiricho najisi na chisichokala najisi, chiwezacho kuriwa na sichoweza kuriwa.” ");
INSERT INTO dig_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Mwenyezi Mlungu achimuambira Musa, ");
INSERT INTO dig_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Aambire atu a Iziraeli hivi: Mchetu achiphaha mimba na kudzivugula mwana mlume, andakala najisi kpwa muda wa siku sabaa sawa na anavyokala wakati ana ga chichetu. ");
INSERT INTO dig_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Mwana hiye andatiywa tsatsani sikuye ya nane. ");
INSERT INTO dig_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Alafu mchetu hiye andaenderera kukala najisi kpwa muda wa siku mirongo mihahu na tahu ndipho akale si najisi bada ya kutuma. Wakati hinyo, asigute chochosi chitakatifu wala kuinjira Phatu Phatakatifu hadi siku za kutakasikakpwe ndiphotimiya. ");
INSERT INTO dig_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Ela, napho akadzivugula mwana mchetu, phahi, andakala najisi kpwa muda wa wiki mbiri dza vira inavyokala wakati ana ga chichetu. Andaenderera kukala najisi kpwa muda wa siku mirongo sita na sita. ");
INSERT INTO dig_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“Siku za kutakaswakpwe ndiphotimiya, ikale akaphaha mwana mlume au mchetu, andamrehera mlavyadzi-sadaka hipho phatu pha kumenyera hema ra mkpwutano turume ra mwaka mmwenga kpwa ajili ya sadaka ya kuochwa na mwana njiya manga au njiya, kpwa ajili ya sadaka ya kuusa dambi. ");
INSERT INTO dig_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Mlavyadzi-sadaka andamreha mbere za Mwenyezi Mlungu na kumuhendera mchetu hiye upatanisho kpwa kumuusira najisi naye andakala si najisi tsona. Hiri ni lagizo ra kuelekeza mchetu yeyesi ndiyedzivugula mwana mlume au mchetu. ");
INSERT INTO dig_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","“Napho kaweza kulavya turume, phahi, andareha njiya airi au ana njiya manga airi; mmwenga kpwa ajili ya sadaka ya kuochwa na wanjina kpwa ajili ya sadaka ya kuusa dambi. Mlavyadzi-sadaka andamuhendera mchetu hiye upatanisho kpwa kumuusira najisi, naye andakala swafi.” ");
INSERT INTO dig_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Mwenyezi Mlungu achimuambira Musa na Aruni, ");
INSERT INTO dig_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Ichikala mutu yeyesi andakala na kufutuka au viphere au vyoga dzulu ya mwiriwe, ambavyo vinaweza kukala ukongo wa ngozi wa kuambukiza, phahi, ni lazima arehwe kpwa mlavyadzi-sadaka Aruni au mmwenga wa anae ndiyekala mlavyadzi-sadaka. ");
INSERT INTO dig_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Mlavyadzi-sadaka andachunguza phatu pharipho ukongo na ichikala nyere za phatu phara zikagaluka nyereru na ukongo wenye uchionekana kukala u ndani zaidi ya ngozi ya mwiriwe, phahi, hinyo ni ukongo wa ngozi wa kuambukiza. Mlavyadzi-sadaka achimala kumchunguza hivyo, andatangaza kukala mutu yuya ni najisi. ");
INSERT INTO dig_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Ela ichikala seemu hiyo, dzagbwe ni nyereru ela nyo wereruwe taudzangbwemenya sana ndani ya chingo na wala nyere za phatu phara taziyabadilika kukala nyereru, phahi, mlavyadzi-sadaka andamtenga mutu yuya kpwa muda wa siku sabaa. ");
INSERT INTO dig_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Siku ya sabaa, mlavyadzi-sadaka andamchunguza tsona yuya mutu, na ichikala, kulengana na uchunguziwe akaona hinyo ukongo taudzangbwebadilika na taudzangbwegota kpwenye ngoziye, phahi, andamtenga mutu hiye kpwa siku zanjina sabaa. ");
INSERT INTO dig_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","“Mlavyadzi-sadaka andamchunguza tsona mutu hiye siku ya sabaa. Napho kulengana na uchunguziwe, hira seemu ya ukongo inayaya na ukongo taudzangbwegota, phahi, mlavyadzi-sadaka andatangaza kukala mutu yuya ni swafi, hinyo ni uphere tu. Mutu hiye ni afule nguwoze, naye andakala swafi. ");
INSERT INTO dig_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Ela viphere vira vichigota kpwenye ngozi, bada ya mutu hiye kudzionyesa kpwa mlavyadzi-sadaka kpwa ajili ya kutangazwa kukala ni swafi, phahi, andakpwedza tsona kpwa mlavyadzi-sadaka. ");
INSERT INTO dig_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Mlavyadzi-sadaka andamchunguza tsona, na napho ukongo wa ngozi ukagota kpwenye ngozi, phahi, mlavyadzi-sadaka andatangaza kukala mutu yuya ni najisi mana hinyo ni mahana. ");
INSERT INTO dig_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Napho mutu akagbwirwa ni mahana, andarehwa kpwa mlavyadzi-sadaka. ");
INSERT INTO dig_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Mlavyadzi-sadaka andamchunguza na napho akafutuka utu wereru ambao ukahenda malalaikage gakale mereru na kufutuka kura kukagaluka kukala chironda chiitsi, ");
INSERT INTO dig_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","higo ni mahana ga muda mure. Mlavyadzi-sadaka andatangaza kukala mutu hiye ni najisi. Kandamtenga mutu hiye kpwa amchunguze tsona mana ni najisi kare. ");
INSERT INTO dig_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Napho ukongo wa kuambukiza ukamgbwira na ukagota mwiri mzima, kula chitswani hadi maguluni, hata ikale mlavyadzi-sadaka anaweza kuona, ");
INSERT INTO dig_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","phahi mlavyadzi-sadaka andamchunguza. Naye achiona kukala ukongo hinyo ukagota mwiri mzima, phahi, andatangaza kukala mutu hiye ni swafi kpwa sababu mwiri ukagaluka kukala mwereru na hivyo mutu hiye ni swafi. ");
INSERT INTO dig_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Ela achionekana na chironda chiitsi, phahi, mutu hiye andakala ni najisi. ");
INSERT INTO dig_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Mlavyadzi-sadaka andachunguza hicho chironda chiitsi na kumtangaza kukala ni najisi kpwa sababu hinyo ni ukongo wa ngozi wa kuambukiza. ");
INSERT INTO dig_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Ela hicho chironda chichigaluka tsona kukala chereru, mutu hiye andauya kpwa mlavyadzi-sadaka. ");
INSERT INTO dig_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Mlavyadzi-sadaka andamchunguza na achiona kukala chikagaluka kukala chereru, phahi, andatangaza kukala mutu hiye ni swafi. ");
INSERT INTO dig_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Napho mutu akagbwirwa ni iphu, naro rikaphola, ");
INSERT INTO dig_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","ela pho phariphokala na iphu phafutuka na phachikala phereru au avi phereru avi phakundu, analondwa kumuonyesa mlavyadzi-sadaka. ");
INSERT INTO dig_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Mlavyadzi-sadaka andamchunguza hiye mutu, naye achiona kukala ukongo hinyo u ndani zaidi ya ngozi na go malalaika ga phatu phara gakagaluka kukala mereru, phahi, mlavyadzi-sadaka andatangaza kukala mutu hiye ni najisi. Higo ni mahana ambago gakaandza kpwenye iphu. ");
INSERT INTO dig_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Ela napho mlavyadzi-sadaka akamchunguza hiye mutu na kuona kukala malalaika ga phatu phara sigo mereru wala ukongo hinyo taundani sana ya ngozi, ela phanayaya, phahi, andamtenga hiye mutu kpwa muda wa siku sabaa. ");
INSERT INTO dig_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Napho ukongo hinyo ukagota kpwenye ngozi, phahi, mlavyadzi-sadaka andatangaza kukala mutu hiye ni najisi, seemu iyo ina ukongo wa kuambukiza. ");
INSERT INTO dig_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Ela, napho hinyo ukongo taudzangbwebadilika na taudzangbwegota kpwenye ngoziye, phahi, hiro ni kuphyu ra iphu tu. Mlavyadzi-sadaka andatangaza kukala mutu hiye ni swafi. ");
INSERT INTO dig_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Au, ichikala mutu waphya na cho chironda chiitsi chikagaluka kukala kundu na wereru, ");
INSERT INTO dig_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","mlavyadzi-sadaka andachichunguza. Naye achiona kukala malalaika gakagaluka kukala mereru na ukongo ukamenya ndani sana, phahi, hinyo ni ukongo wa kuambukiza. Ukongo hinyo ukadzituluza kpwa njira ya phatu phara phophya. Mlavyadzi-sadaka andatangaza kukala mutu hiye ni najisi, mana ana mahana. ");
INSERT INTO dig_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Ela napho mlavyadzi-sadaka achiona kukala malalaika ga phatu phara si mereru na nyo ukongo taundani sana ela ura wereru unayaya, phahi, mlavyadzi-sadaka andamtenga mutu hiye kpwa muda wa siku sabaa. ");
INSERT INTO dig_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Siku ya sabaa, mlavyadzi-sadaka andamchunguza. Napho cho chironda chikatsatsamuka, phahi, mlavyadzi-sadaka andatangaza kukala mutu yuya ni najisi, mana ana ukongo wa ngozi wa kuambukiza. ");
INSERT INTO dig_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Ela, napho hicho chironda tachikatsatsamuka, ela nyo wereru unayaya, hiko ni kufutuka chikorehwa ni kuphya. Phahi, mlavyadzi-sadaka andatangaza kukala mutu hiye ni swafi, mana hiro ni kuphyu ra kuphya. ");
INSERT INTO dig_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Napho mutu yeyesi mlume au mchetu, ana ukongo phakpwe chitswani au cheruni, ");
INSERT INTO dig_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","mlavyadzi-sadaka andachunguza ukongo hinyo. Ichikala andaona kukala ukongo u ndani sana na nyere zi mandano na ni nyembamba, phahi, andatangaza kukala mutu hiye ni najisi, mana higo ni mahana ga chitswa au ga cheru. ");
INSERT INTO dig_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Napho mlavyadzi-sadaka andachunguza pho phakongo na aone kukala taundani sana ya ngozi na nyere si nyiru, phahi mlavyadzi-sadaka andamtenga mutu hiye kpwa muda wa siku sabaa. ");
INSERT INTO dig_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Siku ya sabaa mlavyadzi-sadaka andaphachunguza pho phenye ukongo hinyo. Achiona taphaenjerezekere na taphana nyere za rangi ya mandano wala nyo ukongo taundani sana ya ngozi, ");
INSERT INTO dig_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","phahi mutu hiye andanyola chitswache au cheruche. Ela phatu phara phenye ukongo kandaphanyola. Alafu mlavyadzi-sadaka andamtenga mutu hiye kpwa muda wanjina wa siku sabaa. ");
INSERT INTO dig_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Siku ya sabaa, mlavyadzi-sadaka andachunguza pho phatu phakongo. Ichikala mlavyadzi-sadaka andaona kukala ukongo hinyo taukaenjerezeka wala kumenya ndani ya ngozi, phahi, andatangaza kukala mutu yuya ni swafi. Mutu hiye andafula nguwoze, naye andakala swafi. ");
INSERT INTO dig_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Ela ichikala ukongo hinyo ukaenjerezeka bada ya kutangazwa kukala swafi, ");
INSERT INTO dig_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","mutu hiye andachunguzwa ni mlavyadzi-sadaka na ichikala ukaenjerezeka, mlavyadzi-sadaka kandakala na haja ya kuendza nyere zenye rangi ya mandano. Mutu hiye andakala najisi. ");
INSERT INTO dig_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Ela ichikala mlavyadzi-sadaka andaona kukala hira seemu iriyo kongo taikabadilika na nyere nyiru zikamera phatu hipho, phahi, ukongo undakala ukaphola, na mutu hiye ni swafi. Mlavyadzi-sadaka andatangaza kukala mutu hiye ni swafi. ");
INSERT INTO dig_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Napho mutu yeyesi, akale mlume au mchetu, ana alama nyereru mwakpwe mwirini, ");
INSERT INTO dig_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","mlavyadzi-sadaka andamchunguza mutu hiye. Ichikala mlavyadzi-sadaka andaona kukala alama hizo ni nyereru chidide, hinyo ni ukongo wa kawaida, mutu hiye ni swafi. ");
INSERT INTO dig_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Napho mutu akahenda lilazi ra kogoni, iye ni swafi mana ana lilazi tu. ");
INSERT INTO dig_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Ichikala mutu nyereze zikauka lihosini, mutu hiye ana lilazi tu naye aswafi. ");
INSERT INTO dig_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Ela napho phakpwe chitswani phenye lilazi phana alama ya kundu na wereru, hinyo ni ukongo wa ngozi wa kuambukiza unaoandza kpwenye lilazire hipho kogoni au kpwenye lihosi. ");
INSERT INTO dig_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Mlavyadzi-sadaka andamchunguza na ichikala andaona kukala hiko kufutuka kuna rangi ya kundu na wereru kpwenye lilazi kogoni au kpwenye lihosi na ambao u dza ukongo wa ngozi wa kuambukiza kpwenye ngozi, ");
INSERT INTO dig_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","phahi, mutu hiye ana ukongo wa kuambukiza, na ni najisi. Mlavyadzi-sadaka andamtangaza kukala ni najisi, kpwa sababu ya ukongo urio phakpwe chitswani. ");
INSERT INTO dig_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“Mwenye ukongo wa kuambukiza yeyesi andavwala mademu, nyereze kandazitsana, andabwiningiza mromowe na mkpwonowe na kugomba kpwa sauti kuamba, ‘Mino ni najisi, mino ni najisi.’ ");
INSERT INTO dig_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Andaenderera kukala najisi kpwa muda wosi ndiokala na ukongo hinyu. Iye ni najisi, naye ni lazima asagale macheye kondze ya kambi. ");
INSERT INTO dig_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“Napho nguwo ina aina ya madowa ga koga, ikale ya nyoya za mangʼondzi au katani, ");
INSERT INTO dig_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","nguwo iyo ikale ikafumwa au kusukpwa na katani au nyoya za mangʼondzi au ni nguwo ya chingo ya aina yoyosi, ");
INSERT INTO dig_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","ichikala hiro dowa ra koga ri rangi ya nyasi mbitsi au ya kundu kpwenye nguwo hiyo, phahi, nguwo iyo ina koga ya kuambukiza. Kpwa hivyo ni lazima mlavyadzi-sadaka aonyeswe iyo nguwo. ");
INSERT INTO dig_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Mlavyadzi-sadaka andachunguza hiro dowa ra koga iyo naike nguwo iyo kanda kpwa muda wa siku sabaa. ");
INSERT INTO dig_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Siku ya sabaa andachunguza dowa hiro ra koga. Ichikala hiro dowa ra koga rikagota kpwenye nguwo hiyo, ikale ni ya kufumwa, kusukpwa, ya chingo au ya chitu chanjina chochosi chotengezwa na chingo, nguwo iyo indakala na koga inayogota. ");
INSERT INTO dig_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Mlavyadzi-sadaka andaiocha nguwo iyo mana ina aina ya koga inayogota. ");
INSERT INTO dig_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“Ela mlavyadzi-sadaka achiona hiro dowa ra koga tarikagota kpwenye nguwo, ");
INSERT INTO dig_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","phahi, andalagiza nguwo iyo ifulwe na kuikpwa kanda kpwa muda wanjina wa siku sabaa. ");
INSERT INTO dig_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Mlavyadzi-sadaka andachunguza nguwo iyo bada ya kufulwa. Ichikala dowa hiro taridzangbwegaluka rangiye hata dzagbwe tarikagota, phahi, nguwo iyo ni najisi nayo ni iochwe, ikale dowa hiro ri ndani au kondze ya nguwo hiyo. ");
INSERT INTO dig_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Napho mlavyadzi-sadaka andaona kukala hiro dowa rinayaya bada ya kufulwa, phahi andakata iyo seemu iriyo na aina ya koga igotayo. ");
INSERT INTO dig_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Alafu, ichikala hiro dowa rindaonekana tsona kpwenye nguwo yofumwa, yosukpwa au kpwenye chitu chochosi cha chingo, phahi inakoga inayogota. Kpwa hivyo nguwo iyo andaiocha. ");
INSERT INTO dig_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Ela nguwo ambayo dowa ra koga rikauka bada ya kufulwa, indafulwa kano ya phiri na hivyo indakala swafi. ");
INSERT INTO dig_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","“Higa ndigo malagizo kuhusu madowa ga koga ndigokala kpwenye nguwo za nyoya za mangʼondzi, za katani yofumwa, yosukpwa au za chingo. Kpwa njira iyo mundaweza kutafwautisha kahi ya nguwo isiyokala najisi na hira inayokala najisi.” ");
INSERT INTO dig_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Mwenyezi Mlungu achimuambira Musa, ");
INSERT INTO dig_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Higa ndigo malagizo kuhusu enye mahana katika siku za kutakaswa kpwao, bada ya kuphola ndiphorehwa kpwa mlavyadzi-sadaka. ");
INSERT INTO dig_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Mlavyadzi-sadaka andaphiya akamchunguze yuya mutu kondze ya kambi. Ichikala ukongo hinyo ukaphola, ");
INSERT INTO dig_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","phahi, mlavyadzi-sadaka andaamuru areherwe nyama airi a mapha ario swafi na azima, chigongo cha muhi wa muerezi, sufi ya kundu na chiphungo cha muhisopo kpwa ajili ya yuya mutu ndiyetakaswa. ");
INSERT INTO dig_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Mlavyadzi-sadaka andaamuru nyama wa mapha mmwenga atsindzwe dzulu ya nyungu yenye madzi swafi ga muhoni gajerago. ");
INSERT INTO dig_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Mlavyadzi-sadaka andahala yuya nyama wa mapha chiyesala, chira chigongo cha muerezi, sufi ya kundu na chira chiphungo cha muhisopo na kuvivwika vyosi kpwenye madzi chigotsanganyika na milatso ya yuya nyama wa mapha chiyetsindzwa. ");
INSERT INTO dig_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Alafu, andamtimvira-timvira yuya mwenye kutakaswa hira milatso kano sabaa, alafu andatangaza kukala mutu hiye ni swafi. Andamricha yuya nyama wa mapha mzima aphiye vyakpwe weruni. ");
INSERT INTO dig_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Hiye mutu andafula nguwoze, andanyola nyereze, na aoge, naye andakala swafi. Bada ya higo andauya ndani ya kambi, ela andasagala kondze ya hemare kpwa muda wa siku sabaa. ");
INSERT INTO dig_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Siku ya sabaa andanyola nyereze zosi za chitswache, cheruche, nyusi na nyere zosi za mwirini. Alafu andafula nguwoze na kuoga, naye andakala swafi. ");
INSERT INTO dig_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“Siku ya nane andareha ana turume airi, mwati wa mwaka mmwenga osi asiokala na virema, kilo tahu za unga mnono uriotsanganywa na mafuha kpwa ajili ya sadaka ya mtsere phamwenga na mafuha seemu mwenga ya tahu ya lita. ");
INSERT INTO dig_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Mlavyadzi-sadaka ndiyetakasa mutu hiye andamreha mbere za Mwenyezi Mlungu phephi na phatu pha kumenyera hema ra mkpwutano phamwenga na vitu chivyoreha. ");
INSERT INTO dig_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Mlavyadzi-sadaka andahala mwana turume mmwenga na kumlavya dza sadaka ya kuusa makosa phamwenga na gara mafuha. Andaviunula mbere za Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Alafu andatsindza yuya mwana ngʼondzi Phatu Phatakatifu, anaphotsindza nyama wa sadaka ya kuusa dambi na sadaka za kuochwa. Sadaka hino ya kuusa makosa na sadaka ya kuusa dambi, ni za mlavyadzi-sadaka. Ni sadaka takatifu kabisa. ");
INSERT INTO dig_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Mlavyadzi-sadaka andahala seemu ya milatso ya sadaka ya kuusa makosa na kupaka ye mutu atakaswaye ndewe ya sikirore ra kulume na dzalagumbe ra mkpwonowe wa kulume na ra chiguluche cha kulume. ");
INSERT INTO dig_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Alafu, mlavyadzi-sadaka andahala seemu ya mafuha na kugatiya kpwenye fumba ra mkpwonowe wa kumotso. ");
INSERT INTO dig_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Andadyoga chala cha mkpwonowe wa kulume kpwenye mafuha higo na amtimvire-timvire kano sabaa mbere za Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Seemu ya mafuha ndigosala mwakpwe fumbani andapaka ye mutu atakaswaye ndewe ya sikirore ra kulume na dzalagumbe ra mkpwonowe wa kulume na ra chiguluche cha kulume, phatu pharatu ariphopaka milatso ya sadaka ya kuusa makosa. ");
INSERT INTO dig_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Gara mafuha ndigosala andapaka yuya mutu chitswani. Hivyo andamuhendera utakaso kpwa kumuusira najisi mbere za Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Mlavyadzi-sadaka andalavya sadaka ya kuusa dambi na kumuhendera yuya mutu utakaso kpwa kumuusira najisi. Alafu andatsindza mwana turume wa sadaka ya kuochwa. ");
INSERT INTO dig_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Mlavyadzi-sadaka andalavya hira sadaka ya kuochwa phamwenga na sadaka ya mtsere dzulu ya phatu pha kulavira sadaka. Hivyo andamuhendera yuya mutu utakaso kpwa kumuusira najisi, naye andakala swafi. ");
INSERT INTO dig_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“Ela ichikala mutu yuya ni mchiya, kana uwezo wa kulavya vitu hivyo, phahi andareha mwana turume mmwenga dza sadaka ya kuusa makosa ambaye andaunulwa dza sadaka ya kuunulwa kpwa kumuhendera yuya mutu utakaso kpwa kumuusira najisi. Andareha viratu vira, kilo mwenga ya unga mnono uriotsanganywa na mafuha kpwa ajili ya sadaka ya mtsere na mafuha seemu mwenga ya tahu ya lita. ");
INSERT INTO dig_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Piya andareha njiya airi au ana njiya manga airi chiasi awezacho, mmwenga andakala kpwa ajili ya sadaka ya kuusa dambi na wanjina kpwa ajili ya sadaka ya kuochwa. ");
INSERT INTO dig_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Siku ya nane andamrehera mlavyadzi-sadaka vitu hivyo kpwa ajili ya utakasowe mbere za Mwenyezi Mlungu hipho phatu pha kumenyera hema ra mkpwutano. ");
INSERT INTO dig_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Mlavyadzi-sadaka andahala yuya mwana turume wa sadaka ya kuusa makosa phamwenga na gara mafuha seemu mwenga ya tahu za lita na kuviunula dza sadaka ya kuunulwa mbere za Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Ye mutu ndiyereha yuya mwana turume wa sadaka ya kuusa makosa andamtsindza. Mlavyadzi-sadaka andahala seemu ya milatso na kupaka yuya mutu atakaswaye ndewe ya sikirore ra kulume, dzalagumbe ra mkpwonowe wa kulume na ra chiguluche cha kulume. ");
INSERT INTO dig_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Mlavyadzi-sadaka andatiya seemu ya mafuha higo kpwenye fumba ra mkpwonowe wa kumotso. ");
INSERT INTO dig_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Alafu amtimvire-timvire na chala cha mkpwonowe wa kulume seemu ya higo mafuha garigo kpwenye fumbare ra kumotso kano sabaa mbere za Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Mlavyadzi-sadaka andapaka mafuha yuya mutu atakaswaye ndewe ya sikirore ra kulume, kpwenye dzalagumbe ra mkpwonowe wa kulume, na ra chiguluche cha kulume. Andapaka phatu phara ambapho akapaka hira milatso ya sadaka ya kuusa makosa. ");
INSERT INTO dig_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Mafuha ndigosala mwakpwe mkpwononi andapaka yuya mutu chitswani, ili kumuhendera utakaso kpwa kumuusira najisi mbere za Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Alafu mlavyadzi-sadaka andahala chira ambacho yuya mutu akaweza kureha ikale ni njiya au ana njiya manga. ");
INSERT INTO dig_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Njiya mmwenga andakala kpwa ajili ya sadaka ya kuusa dambi na wanjina kpwa ajili ya sadaka ya kuochwa phamwenga na sadaka ya mtsere. Mlavyadzi-sadaka andamuhendera mutu yuya utakaso kpwa kumuusira najisi mbere za Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","“Higa ndigo malagizo kuhusu mutu wa mahana asiyekala na uwezo wa kulavya sadaka ya utakaso ya kawaida.” ");
INSERT INTO dig_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Chisha Mwenyezi Mlungu achimuambira Musa na Aruni, ");
INSERT INTO dig_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Mndiphoinjira tsi ya Kanani ambayo nindakuphani ikale yenu, nami nchihenda aina yoyosi ya koga kpwenye ukuta wa nyumba fulani kpwenye tsi yenu. ");
INSERT INTO dig_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","Phahi, mwenye nyumba iyo analondwa amuambire mlavyadzi-sadaka kukala, ‘Nikaona utu dza koga kpwenye nyumba yangu.’ ");
INSERT INTO dig_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Mlavyadzi-sadaka andaamuru vitu vyosi ndani ya nyumba iyo vituluzwe kabila ya iye mwenye kadzangbweandza uchunguzi wa rira dowa, sedze vikatangazwa vyosi kukala najisi. Alafu andamenya na achunguze nyumba hiyo. ");
INSERT INTO dig_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Andachunguza koga mo kutani, na achiona ikasababisha madowa-madowa ga rangi ya nyasi mbitsi au ya kundu na kuonekana kukala gakamenya ndani ya kuta, ");
INSERT INTO dig_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","hiye andatuluka kondze na kufunga nyumba iyo kpwa muda wa siku sabaa. ");
INSERT INTO dig_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Siku ya sabaa, mlavyadzi-sadaka andauya na kuchunguza tsona nyumba hiyo. Ichikala dowa hiro rikagota kpwenye kuta za nyumba hiyo, ");
INSERT INTO dig_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","andalagiza mawe garigo kpwenye seemu zenye koga zibomolwe na kutsuphiwa phatu pharipho najisi kondze ya mudzi. ");
INSERT INTO dig_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Palasta ya ndani ya nyumba iyo yosi indakpwangulwa-kpwangulwa na uchafu utsuphiwe phatu pharipho najisi kondze ya mudzi. ");
INSERT INTO dig_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Alafu ukuta hinyo undadzengbwa na mawe maphya mo mwatu murimobomolwa. Nayo iyo nyumba indapigbwa palasta luphya. ");
INSERT INTO dig_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Ichikala dowa rira rindatsembuka tsona bada ya kulavya mawe higo na kukpwangula palasta na kuipiga luphya, ");
INSERT INTO dig_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","inalondwa mlavyadzi-sadaka edze aichunguze. Ichikala koga ikagota kpwenye nyumba hiyo, phahi iyo ni koga isiyouka, nyumba iyo ni najisi. ");
INSERT INTO dig_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Nyumba iyo inalondwa ibomolwe na mawege, mbaoze na palastaye viphirikpwe phatu pharipho najisi kondze ya mudzi. ");
INSERT INTO dig_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Zaidi ya higo, yeyesi ndiyemenya ndani ya nyumba iyo wakati ndiphokala ikafungbwa, andakala najisi hadi dziloni. ");
INSERT INTO dig_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Yeyesi ndiyelala kpwenye nyumba iyo au kurya chakurya himo, analondwa afule nguwoze. ");
INSERT INTO dig_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Ela ichikala bada ya kuchunguza nyumba hiyo, mlavyadzi-sadaka achiona kukala koga taikagota bada ya kupigbwa palasta, phahi, mlavyadzi-sadaka andatangaza kukala nyumba iyo ni swafi mana koga ikasira. ");
INSERT INTO dig_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Phahi kuonyesa nyumba ikakala swafi tsona, mwenye nyumba andareha nyama airi a mapha phamwenga na chipande cha muerezi, sufi ya kundu na chiphungo cha muhisopo. ");
INSERT INTO dig_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Andatsindza nyama mmwenga wa mapha dzulu ya nyungu yenye madzi swafi ga muhoni. ");
INSERT INTO dig_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Andahala chipande cha muerezi, chiphungo cha muhisopo na hira sufi ya kundu phamwenga na yuya nyama wa mapha chiyesala mzima na kuvivwika vyosi madzini chigotsanganyika na milatso ya yuya nyama wa mapha chiyetsindzwa. Alafu andatimvira-timvira nyumba iyo milatso kano sabaa. ");
INSERT INTO dig_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Hivi ndivyo ndivyotakasa nyumba iyo kpwa milatso ya nyama wa mapha, madzi swafi ga muhoni gajerago, nyama wa mapha ariye moyo, chipande cha muerezi, chiphungo cha muhisopo na hira sufi ya kundu. ");
INSERT INTO dig_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Yuya nyama wa mapha ariye mzima andamricha aphiye vyakpwe weruni kondze ya mudzi. Hivi ndivyo ndivyotakasa nyumba hiyo, nayo indakala swafi.” ");
INSERT INTO dig_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Higa ndigo malagizo kuhusu aina yoyosi ya ukongo wa kuambukiza, ukongo wa ngozi wa chitswa na cheru, ");
INSERT INTO dig_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","Koga kpwenye nguwo au nyumba, ");
INSERT INTO dig_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","kufutuka, viphere au vyoga, ");
INSERT INTO dig_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","kpwa kuonyesa ni chitu chani chinachokala najisi na chisichokala najisi. Higo ndigo malagizo kuhusu ukongo wa kuambukiza. ");
INSERT INTO dig_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Mwenyezi Mlungu achimuambira Musa na Aruni, ");
INSERT INTO dig_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Aambire Aiziraeli hivi: Mlume yeyesi ariye na ukongo wa kutulukpwa ni madzi-madzi ga mbere, madzi higo gandamuhenda akale najisi. ");
INSERT INTO dig_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Ikale anatulukpwa ni madzi-madzi muda wosi au gakaziba ndaniye, mutu hiye ni najisi. Na madzi-madzige gandasababisha unajisi wa vitu vyanjina kpwa njira zilungirazo: ");
INSERT INTO dig_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Chitanda chochosi ndicholarira au chitu chochosi ndichosagarira, chindakala najisi. ");
INSERT INTO dig_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Mutu yeyesi ndiyeguta chitanda cha mutu hiye ni afule nguwoze na aoge, naye andakala najisi hadi dziloni. ");
INSERT INTO dig_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Mutu yeyesi ndiyesagarira chitu chochosi chirichosagarirwa ni mutu mwenye kutulukpwa ni madzi-madzi, ni afule nguwoze na aoge, naye andakala najisi hadi dziloni. ");
INSERT INTO dig_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Mutu yeyesi ndiyeguta mutu atulukpwaye ni madzi-madzi, ni afule nguwoze na aoge, naye andakala najisi hadi dziloni. ");
INSERT INTO dig_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Mutu yeyesi achitsitsirwa mahe ni mutu atulukpwaye ni madzi-madzi, ni afule nguwoze na aoge naye andakala najisi hadi dziloni. ");
INSERT INTO dig_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Tandiko rorosi ambaro nkuandikpwa dzulu ya nyama, mutu akasagarira, richisagarirwa ni mutu atulukpwaye ni higo madzi-madzi rindakala najisi. ");
INSERT INTO dig_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Mutu yeyesi ndiyeguta tandiko hiro andakala najisi hadi dziloni. Mutu yeyesi ndiyetsukula vitu hivyo ni afule nguwoze na aoge naye andakala najisi hadi dziloni. ");
INSERT INTO dig_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Mutu yeyesi ndiyegutwa ni mutu atulukpwaye ni madzi-madzi kabila ya kutsukutsa mikonoye, ni afule nguwoze, aoge naye andakala najisi hadi dziloni. ");
INSERT INTO dig_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Mwiyo wowosi wa ulongo chiogutwa ni mutu hiye ni uvundzwe-vundzwe. Ela mwiyo wowosi wa muhi undatsukutswa na madzi. ");
INSERT INTO dig_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“Mlume yeyesi atulukpwaye ni madzi-madzi achiphola ukongowe, mutu hiye ni agodze siku sabaa kabila ya kuusirwa najisiwe. Andafula nguwoze chisha aoge na madzi ga muhoni, naye andakala swafi. ");
INSERT INTO dig_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Siku ya nane, ni arehe njiya airi au ana njiya manga airi mbere za Mwenyezi Mlungu hipho phatu pha kumenyera hema ra mkpwutano na kumupha mlavyadzi-sadaka. ");
INSERT INTO dig_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Mlavyadzi-sadaka andalavya njiya mmwenga kpwa ajili ya sadaka ya kuusa dambi na wanjina kpwa ajili ya sadaka ya kuochwa. Mlavyadzi-sadaka andamuhendera mutu hiyu utakaso wa kumuusira unajisiwe wa kutulukpwa ni madzi-madzi mbere za Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“Mlume yeyesi achitulukpwa ni minya, analondwa kuoga mwiri mzima, naye andakala najisi hadi dziloni. ");
INSERT INTO dig_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Nguwo yoyosi au ngozi yoyosi chiyododerwa ni minya inalondwa ifulwe nayo indakala najisi hadi dziloni. ");
INSERT INTO dig_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Napho mlume akalala na mchetu na kutulukpwa ni minya, phahi ni lazima osi airi aoge, nao andakala najisi hadi dziloni. ");
INSERT INTO dig_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“Mchetu yeyesi ndiphokala mwezini, andakala najisi kpwa muda wa siku sabaa. Mutu yeyesi ndiyemguta andakala najisi hadi dziloni. ");
INSERT INTO dig_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Chitu chochosi ndicholarira au kusagarira wakati a kpwenye mambo ga chichetu chindakala najisi. ");
INSERT INTO dig_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Mutu yeyesi ndiyeguta chitanda cha mchetu hiye ni afule nguwoze na aoge naye andakala najisi hadi dziloni. ");
INSERT INTO dig_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Mutu yeyesi ndiyeguta chitu chochosi chirichosagarirwa ni mchetu hiye ni afule nguwoze na aoge, naye andakala najisi hadi dziloni. ");
INSERT INTO dig_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Mlume yeyesi ndiyeguta chitu chochosi chicholarirwa au kusagarirwa ni mchetu hiye, andakala najisi hadi dziloni. ");
INSERT INTO dig_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Napho mlume akalala na mchetu hiye na milatsoye ikamdodera, phahi, mlume hiye andakala najisi kpwa muda wa siku sabaa. Chitanda chochosi ndicholarira hiye mlume chindakala najisi. ");
INSERT INTO dig_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“Napho mchetu anatulukpwa ni milatso kpwa muda wa siku nyinji na sizo sikuze au anatulukpwa ni milatso kpwa siku nyinji kuriko kawaida ya sikuze, phahi, andaenderera kukala najisi muda wosi ambao anatulukpwa ni milatso. ");
INSERT INTO dig_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Chitanda chochosi anacholarira au chochosi asagariracho, chindakala najisi sawa na wakati wa sikuze. ");
INSERT INTO dig_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Mutu yeyesi ndiyeguta vitu hivyo, andakala najisi na ni afule nguwoze na aoge naye andakala najisi hadi dziloni. ");
INSERT INTO dig_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Bada ya milatsoye kutuma, mchetu hiye andagodza siku sabaa, na bada ya muda hinyo andakala swafi. ");
INSERT INTO dig_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Siku ya nane andahala njiya airi au ana njiya manga airi na amrehere mlavyadzi-sadaka pho phatu pha kumenyera hema ra mkpwutano. ");
INSERT INTO dig_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Mlavyadzi-sadaka andalavya mmwenga kpwa ajili ya sadaka ya kuusa dambi na wanjina kpwa ajili ya sadaka ya kuochwa. Hivyo andamuhendera hiye mchetu utakaso wa kumuusira unajisiwe wa kutulukpwa ni milatso mbere za Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“Hivyo ndivyo ndivyotenga Aiziraeli na unajisi wao, kusudi asifwe kpwenye unajisi wao kpwa kutiya najisi hema rangu rinarokala kahi yao.” ");
INSERT INTO dig_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Higa ndigo malagizo kuhusu mlume ariyenajisi kpwa kutulukpwa ni madzi-madzi au kutulukpwa ni minya, ");
INSERT INTO dig_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","mchetu atulukpwaye ni milatso, mlume au mchetu yeyesi atulukpwaye ni madzi-madzi au mlume alalaye na mchetu ambaye ni najisi. ");
INSERT INTO dig_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Mwenyezi Mlungu achigomba na Musa, bada ya chifo cha ana airi a Aruni ariofwa wakati ariphomsengerera Mwenyezi Mlungu kpwa njira isiyokubalika. ");
INSERT INTO dig_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Mwenyezi Mlungu wamuamba Musa, “Muambire nduguyo Aruni asiinjire Phatu Phatakatifu Zaidi nyuma ya paziya mbere ya chihi cha mbazi chiricho dzulu ya sanduku ra chilagane wakati wowosi anaolonda kuinjira. Asiphosikira, andafwa mana hipho ndipho ntsembukirapho kpwenye ingu dzulu ya chihi cha mbazi. ");
INSERT INTO dig_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Napho Aruni anamenya Phatu Phatakatifu ni akale na ndzau kpwa ajili ya sadaka ya kuusa dambi na turume kpwa ajili ya sadaka ya kuochwa. ");
INSERT INTO dig_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Ni aoge na avwale nguwo takatifu. Zo nguwo takatifu ni: Kandzu ya katani, suruwale fupi ya katani, mkumbuu wa katani na afunge chiremba cha katani. ");
INSERT INTO dig_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Ni ahale kula kpwa Aiziraeli, ndenje mbiri kpwa ajili ya sadaka ya kuusa dambi na turume mwenga kpwa ajili ya sadaka ya kuochwa. ");
INSERT INTO dig_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“Aruni andalavya iyo ndzau dza sadaka ya kuusa dambi kpwa ajiliye mwenye na kuhenda upatanisho kpwa kuusa dambize na za atu a nyumbaye. ");
INSERT INTO dig_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Alafu, andahala zira ndenje mbiri na azirehe mbere za Mwenyezi Mlungu pho phatu pha kumenyera hema ra mkpwutano. ");
INSERT INTO dig_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Andazipigira kura hizo ndenje mbiri, kura mwenga kpwa ajili ya Mwenyezi Mlungu na yanjina kpwa ajili ya Azazeli. ");
INSERT INTO dig_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Andareha hira ndenje ambayo kura ikamgbwerera kpwa ajili ya Mwenyezi Mlungu na kumlavya sadaka ya kuusa dambi. ");
INSERT INTO dig_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Ela hira ndenje ndiyogbwererwa ni kura kpwa ajili ya Azazeli indarehwa ichere moyo mbere za Mwenyezi Mlungu. Ili ihumirwe kuhenda upatanisho wa kuusa dambi kpwa kuiphirika jangbwani dza ndenje ya Azazeli. ");
INSERT INTO dig_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Aruni andareha ndzau ya sadaka ya kuusa dambi kpwa ajiliye, na kuhenda upatanisho kpwa kuusa dambize na za atu a nyumbaye, naye andatsindza hira ndzau ya sadakaye ya kuusa dambi. ");
INSERT INTO dig_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Alafu andahala chetezo chenye makala kula phatu pha kulavira sadaka mbere za Mwenyezi Mlungu na mafumba mairi tele ga uvumba uchiosagbwa vinono wenye kungu nono, naye andaureha ndani ya paziya. ");
INSERT INTO dig_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Kusudi asifwe, andareha uvumba hura mbere za Mwenyezi Mlungu na kuutiya mohoni ili mosiwe ufwinike chihi cha mbazi dzulu ya sanduku ra chilagane. ");
INSERT INTO dig_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Andahala seemu ya milatso ya iyo ndzau na atimvye-timvye na chalache seemu ya mbere ya chihi cha mbazi; piya aitimvye-timvye mbere ya sanduku ra chilagane kano sabaa. ");
INSERT INTO dig_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Alafu andatsindza iyo ndenje ya sadaka ya kuusa dambi kpwa ajili ya atu. Milatso ya ndenje iyo andaireha nyuma ya paziya ndani ya Phatu Phatakatifu Zaidi na kuhenda dza vira arivyohenda na milatso ya hira ndzau; andaitimvya-timvya dzulu na mbere ya chihi cha mbazi. ");
INSERT INTO dig_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Kpwa hivyo, andahenda upatanisho kpwa kuusa dambi hipho Phatu Phatakatifu Zaidi kpwa sababu ya najisi, makosa na dambi zanjina za Aiziraeli. Ni ahende vivyo kpwa ajili ya hema ra mkpwutano ririro kahi yao kahi za unajisi wao. ");
INSERT INTO dig_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Wakati Aruni anahenda upatanisho ndani ya Phatu Phatakatifu kpwa ajiliye mwenye, nyumbaye na taifa zima ra Iziraeli, kusikale na mutu yeyesi ndani ya hema ra mkpwutano hadi ndiphomala na kutuluka kondze. ");
INSERT INTO dig_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Alafu andatuluka na aphiye hipho phatu pha kulavira sadaka pharipho mbere za Mwenyezi Mlungu na kuphahendera upatanisho wa kuusa dambi. Andahala seemu ya milatso ya hira ndzau na ya hira ndenje na kupaka pembe za phatu pha kulavira sadaka pande zosi. ");
INSERT INTO dig_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Andatimvira-timvira hipho phatu pha kulavira sadaka seemu ya milatso na chalache kano sabaa, chihivyo andaphatakasa na unajisi wa atu a Iziraeli. ");
INSERT INTO dig_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Bada ya Aruni kumala kutakasa Phatu Phatakatifu Zaidi, hema ra mkpwutano na phatu pha kulavira sadaka, ndipho andareha hira ndenje iriyo moyo. ");
INSERT INTO dig_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Aruni andabandika mikonoye dzulu ya chitswa cha iyo ndenje iriyo moyo na kukubali na kugomba dambi zosi za atu a Iziraeli na makosa gao gosi; naye andaziika zosi dzulu ya chitswa cha iyo ndenje. Alafu andairicha iyo ndenje iphirikpwe jangbwani ni mutu ndiye dzitolea. ");
INSERT INTO dig_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Iyo ndenje indatsukula dambi zao zosi ko kusikokala atu. Nayo indarichirwa hiko jangbwani. ");
INSERT INTO dig_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Alafu Aruni andauya ndani ya hema ra mkpwutano, avule zira nguwo za katani aziriche mumo. Nguwo zira ambazo akavwala ariphomenya Phatu Phatakatifu Zaidi. ");
INSERT INTO dig_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Andaoga Phatu Phatakatifu na avwale nguwoze za kawaida. Chisha andatuluka na alavye sadakaye ya kuochwa, na sadaka za kuochwa za atu a Iziraeli, ili kuhenda upatanisho kpwa ajiliye mwenye na kpwa ajili ya atu osi. ");
INSERT INTO dig_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Andaocha marunya ga sadaka ya kuusa dambi dzulu ya phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Hiye mutu ndiyephirika iyo ndenje ya Azazeli ni afule nguwoze na aoge ndipho aweze kuinjira kambini. ");
INSERT INTO dig_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Hira ndzau na ndenje ya sadaka ya kuusa dambi ambazo milatso yao indaphirikpwa Phatu Phatakatifu Zaidi kpwa kuhenda upatanisho kpwa kuusa dambi, andatsukulwa kondze ya kambi na ziochwe phamwenga na chingo zao, nyama na ufumba wao. ");
INSERT INTO dig_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Hiye mutu ndiyeaocha ni afule nguwoze na aoge, ndipho aweze kuinjira kambini. ");
INSERT INTO dig_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“Hiri ni lagizo ra kare na kare kpwa enyezi na hata ajeni asagalao kahi zenu. Siku ya kumi ya mwezi wa sabaa, ni mfunge na msihende kazi. ");
INSERT INTO dig_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Mundahenda hivyo kpwa sababu siku iyo ndiyo siku ambayo mundahenderwa upatanisho, mtakaswe dambi zenu, namwi mundakala swafi mbere za Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Siku iyo ni Siku ya Kuoya kabisa, namwi ni mfunge; hiri ni lagizo ra kare na kare. ");
INSERT INTO dig_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Mlavyadzi-sadaka mkpwulu ariyemwagirwa mafuha na kutengbwa ili agbwire nafwasi ya ise, yani mlavyadzi-sadaka mkpwulu, ndiye ndiyehenda upatanisho kpwa kuusa dambi. Naye andavwala nguwo takatifu za katani, ");
INSERT INTO dig_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","na ahende upatanisho kpwa kuusa dambi Phatu Phatakatifu Zaidi, hema ra mkpwutano, phatu pha kulavira sadaka, alavyadzi-sadaka na kpwa ajili ya taifa zima ra Iziraeli. ");
INSERT INTO dig_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Hiri ni lagizo ra kare na kare; upatanisho wa kuusa dambi za atu a Iziraeli ni uhendwe mara mwenga chila mwaka.” Naye achihenda gosi dza Mwenyezi Mlungu arivyomlagiza Musa. ");
INSERT INTO dig_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Mwenyezi Mlungu achimuambira Musa, ");
INSERT INTO dig_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Muambire Aruni, anae na atu osi a Iziraeli uambe, Mwenyezi Mlungu walagiza hivi: ");
INSERT INTO dig_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Mutu yeyesi kahi ya Aiziraeli achitsindza ngʼombe, ngʼondzi au mbuzi ndani au kondze ya kambi, ");
INSERT INTO dig_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","bila kumreha nyama hiye phatu pha kumenyera hema ra mkpwutano, ili amulavye dza sadaka kpwa Mwenyezi Mlungu mbere ya hema ra Mwenyezi Mlungu, mutu hiye andakala na kosa ra kuolaga naye ni atengbwe na atue. ");
INSERT INTO dig_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Lagizo hiri rinalazimisha Aiziraeli kumrehera Mwenyezi Mlungu nyama ambao anaatsindza weruni. Andareha nyama hara kpwa mlavyadzi-sadaka phatu pha kumenyera hema ra mkpwutano, nao andatsindza na kumlavira Mwenyezi Mlungu sadaka za amani. ");
INSERT INTO dig_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Phahi, mlavyadzi-sadaka andamwagira-mwagira milatso phatu pha kulavira sadaka pha Mwenyezi Mlungu kahi za phatu pha kumenyera hema ra mkpwutano, na kuocha gara marunya gakale kungu nono imuhamirayo Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Kpwa hivyo Aiziraeli andakoma kabisa kulavira sadaka vizuka vyenye umbo ra ndenje, dzambo ambaro rikaahenda akose kukala aaminifu kpwangu. Hiri ni lagizo ra kare na kare kpwao na vivyazi vyao vyosi. ");
INSERT INTO dig_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“Aambire kukala Muiziraeli yeyesi au mjeni asagalaye kahi yao, ndiyelavya sadaka ya kuochwa au sadaka yanjina, ");
INSERT INTO dig_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","ela asiirehe phatu pha kumenyera hema ra mkpwutano ili kumlavira Mwenyezi Mlungu, mutu hiye andatengbwa na atue. ");
INSERT INTO dig_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“Mutu yeyesi akale Muiziraeli au mjeni, asagalaye kahi yenu achirya milatso yoyosi, nindamtsukirirwa naye ni atengbwe kure na atue. ");
INSERT INTO dig_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Indakala hivyo kpwa mana uzima wa chiumbe u ndani ya milatso. Nkakulagizani kulavya milatso phatu pha kulavira sadaka ili kudzihendera upatanisho, kpwa kukala milatso ndiyo ihenderayo mutu upatanisho wa kumuusira dambi. ");
INSERT INTO dig_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Ndiyo mana nkakulagizani hivi mwi Aiziraeli nchiamba, ‘Mutu yeyesi kahi yenu au mjeni asagalaye kahi yenu asirye milatso.’ ");
INSERT INTO dig_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“Mutu yeyesi akale Muiziraeli au mjeni, asagalaye kahi yenu achendaindza nyama au nyama wa mapha ambao ni a kuriwa, analondwa kumwaga milatso photsi na kuisirira na mtsanga. ");
INSERT INTO dig_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Mana, uzima wa chila chiumbe u ndani ya milatsoye. Ndiyo mana nkakulagizani mwimwi Aiziraeli, ‘Msirye milatso ya chiumbe chochosi mana uzima wa chiumbe chochosi u ndani ya milatsoye. Yeyesi ndiyerya milatso ni atengbwe.’ ");
INSERT INTO dig_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“Mutu yeyesi akale mwenyezi au mjeni, ndiyerya nyama achiyefwa mwenye au achiyeolagbwa ni nyama wa tsakani ni afule nguwoze na aoge naye andakala najisi hadi dziloni, chisha andakala swafi. ");
INSERT INTO dig_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Ela napho kafurire nguwoze na kaogere, mutu hiye andaripha kpwa ajili ya dambi hiro.” ");
INSERT INTO dig_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Mwenyezi Mlungu achimuambira Musa, ");
INSERT INTO dig_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Aambire atu a Iziraeli hivi: Mimi, ndimi Mwenyezi Mlungu, Mlungu wenu. ");
INSERT INTO dig_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Msihende dza vira ahendavyo atu a tsi ya Misiri mrikosagala, wala msihende dza vira ahendavyo atu a tsi ya Kanani ambako nakuphirikani. Msilunge mila zao hata chidide. ");
INSERT INTO dig_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Mwimwi mundalunga malagizo gangu na kugbwira shariya zangu. Mimi, ndimi Mwenyezi Mlungu, Mlungu wenu. ");
INSERT INTO dig_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Gbwirani shariya zangu na malagizo gangu; mana mutu ndiyegbwira malagizo andaishi kpwa kugalunga. Mimi, ndimi Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“Mutu yeyesi kahi yenu naasilale na mʼbariwe wa phephi. Mimi, ndimi Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Usimvundzire ishima sowe kpwa kulala na mayoo. Usilale naye, iye ni mayoo. ");
INSERT INTO dig_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Usimvundzire ishima sowe kpwa kulala na mmwenga wa achee anjina. ");
INSERT INTO dig_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Usilale na mwenenu mchetu, akale ni mwana baba wala mwana mayo, akale wavyalwa pho kaya au kpwanjina. ");
INSERT INTO dig_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Usilale na mdzukuluo, mwana wa mwanao mlume wala wa mchetu, mana undadzivundzira ishima mwenye. ");
INSERT INTO dig_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Usilale na mwana mchetu yevyalwa ni sowe na mchetu wanjina. Mwana mchetu hiye ni mwenenu. ");
INSERT INTO dig_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Usilale na shangaziro, mana hiye ni ndugu wa phephi wa sowe. ");
INSERT INTO dig_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Usilale na ndugu mchetu wa mayoo, mana iye ni ndugu wa phephi wa mayoo. ");
INSERT INTO dig_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Usilale na mkpwaza sowe mvyere wala sowe mdide; hinyo ni mayozo. ");
INSERT INTO dig_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Usilale na mkpwaza-mwanao, hiye ni mchetu wa mwanao mlume. ");
INSERT INTO dig_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Usilale na mkpwaza nduguyo, iye ni mlamuo, undamvundzira ishima mwenenu. ");
INSERT INTO dig_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Usilale na mchetu, chisha ukalala na mwanawe mchetu wala mdzukuluwe. Hinyo ni abarie a phephi, kuatsanganya ni kuhenda uyi. ");
INSERT INTO dig_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Usilóle mlamuo wakati mcheo achere moyo, iyo indasababisha viha. ");
INSERT INTO dig_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“Usilale na mchetu napho ana mambo ga chichetu. ");
INSERT INTO dig_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Usilale na mkpwaza jirani na ukadzitiya unajisi naye. ");
INSERT INTO dig_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“Usilavye mwanao hata mmwenga akale sadaka kpwa Moleki, mana kuhenda hivyo ni kubera dzina rangu mimi Mlunguo. Mimi, ndimi Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“Usimuhende mlume myao mchetu. Hiro ni dzambo ra kutsukiza. ");
INSERT INTO dig_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Usilale na nyama sedze ukadzitiya najisi. Mlume au mchetu yeyesi asihende hivyo. Kuhenda hivyo ni chinyume cha maumbile. ");
INSERT INTO dig_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“Msidzitiye najisi kpwa kuhenda mambo higo kpwa sababu mataifa ganjina ambago ndagazola mbere zenu gadzinajisi kpwa njira hiyo. ");
INSERT INTO dig_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Tsi yao yatiywa najisi nami nchiitiya adabu kpwa ajili ya dambize, nayo tsi ichirema enyezie. ");
INSERT INTO dig_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Ela mwimwi na ajeni asagalao kahi zenu ni mgbwire masharuti gangu na malagizo gangu chisha msihende mambo higo ga kutsukiza. ");
INSERT INTO dig_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Mambo higo ga kutsukiza gahendwa ni atu ariosagala tsi ya Kanani kabila ya mwimwi, nao achiinajisi. ");
INSERT INTO dig_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Phahi, mwimwi msihende mambo higo mkaitiya najisi yo tsi, sedze ikakuremani dza irivyorema taifa ririrokala kabila yenu. ");
INSERT INTO dig_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Atu osi ndiohenda mambo higo ga kutsukiza ni atengbwe kure na atu ao. ");
INSERT INTO dig_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Kpwa hivyo gbwirani malagizo gangu gosi. Msilunge mila za hinyo ariosagala kpwenye tsi kabila mwimwi, sedze mkadzitiya najisi kpwa njira hiyo. Mimi, ndimi Mwenyezi Mlungu, Mlungu wenu.” ");
INSERT INTO dig_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Mwenyezi Mlungu achimuambira Musa, ");
INSERT INTO dig_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Aambire Aiziraeli osi hivi: Kalani atakatifu mana mimi Mwenyezi Mlungu, Mlungu wenu, ni mtakatifu. ");
INSERT INTO dig_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Chila mmwenga wenu ni aishimu ise na nine, na kugbwira malagizo ga Siku zangu za Kuoya. Mimi, ndimi Mwenyezi Mlungu, Mlungu wenu. ");
INSERT INTO dig_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Msiabudu vizuka, wala kudzitengezera milungu ya vizuka vya chuma vya kuyayusha. Mimi, ndimi Mwenyezi Mlungu, Mlungu wenu. ");
INSERT INTO dig_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“Mnaphonilavira mimi Mwenyezi Mlungu sadaka za amani, nilavirani kpwa njira ambayo indakubalika. ");
INSERT INTO dig_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Sadaka iyo ni iriwe siku iyo-iyo inayolaviwa au siku ya phiriye. Chochosi ndichosala hadi siku ya hahu ni chiochwe. ");
INSERT INTO dig_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Napho seemu ya nyamaye indariwa siku ya hahu indakala tsukizo na yo sadaka taindakubaliwa. ");
INSERT INTO dig_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Naye ndiyerya nyama iyo andakala akahenda dambi na andaripha kpwa ajili ya dambiye kpwa sababu akatiya najisi chitu chitakatifu cha Mwenyezi Mlungu. Mutu hiye ni atengbwe na atue. ");
INSERT INTO dig_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“Mvunapho mavuno ga mwenu mindani, msivune kabisa hadi kpwenye miphaka ya minda wala msiuye kpwendatsembwesa. ");
INSERT INTO dig_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Na mvunapho zabibu, msiuye mchatsolatsola chizosala mo mindani, na zo zichizogbwa photsi msizitsole. Zirichireni achiya na ajeni asagalao kahi yenu. Mimi, ndimi Mwenyezi Mlungu, Mlungu wenu. ");
INSERT INTO dig_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“Msiiye, msigombe handzo wala kuchengana. ");
INSERT INTO dig_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Msiape kpwa kuhadza dzina rangu wakati mnagomba handzo sedze mkanajisi dzina ra Mlungu wenu. Mimi, ndimi Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“Usimuonere wala kumnyangʼanya myao vituvye. Usilale bila kumripha mchibaruwao. ");
INSERT INTO dig_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Usimlani masito wala kumuikira chipofu chitu cha kumuhenda akpwale, ela muogophe Mlunguo. Mimi, ndimi Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“Unaphoamula, amula kpwa haki. Usimpendelee mchiya wala kumuogopha tajiri, ela amulani ayawenu kpwa haki. ");
INSERT INTO dig_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Usiphiye hiku na hiku kusengenya ayao. Usitiye myao kpwenye hatari ya chifo kpwa kulavya ushaidi wa handzo. Mimi, ndimi Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“Usimzire nduguyo mwako moyoni, ela mdemurire chingʼangʼa siku zosi ili usishiriki dambiye. ");
INSERT INTO dig_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Usiriphize chisasi wala kumena mutuo yeyesi, ela mmendze myao dza vira udzimendzavyo mwenye. Mimi, ndimi Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“Gbwirani malagizo gangu. Musiriche nyama enu akaphekpwa ni nyama a aina yanjina. Msiphande mbeyu za aina mbiri kpwenu mindani. Msivwale nguwo zosukpwa na nyuzi aina mbiri. ");
INSERT INTO dig_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“Mlume achilala na mtumwa mchetu ambaye akachumbiwa ni mlume wanjina, ela kadzangbwekombolwa wala kurichirwa huru ni amriphe yuya mwenye mtumwa hiye, osi ni atiywe adabu. Ela aho naasiolagbwe kpwa sababu mchetu hiye kala kahuru. ");
INSERT INTO dig_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Mlume hiye andareha turume phatu pha kumenyera hema ra mkpwutano na arilavye kpwa Mwenyezi Mlungu dza sadakaye ya kuusa makosa. ");
INSERT INTO dig_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Mlavyadzi-sadaka andamuhendera upatanisho kpwa kuhumira turume hiro mbere za Mwenyezi Mlungu kpwa ajili ya kuusa dambi ariyohenda, naye andaswamehewa. ");
INSERT INTO dig_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“Mundiphofika kpwenye tsi iyo na kuphanda aina yoyosi ya mihi ya matunda, msirye matunda higo kpwa muda wa miaka mihahu. ");
INSERT INTO dig_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Mwaka wa ne, matundage gosi gandakala matakatifu, gandalaviwa ikale sadaka ya shukurani kpwa Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Ela matunda ga kuandzira mwaka wa tsano higo munaweza kurya na mavuno genu gandaenjerezeka. Mimi, ndimi Mwenyezi Mlungu, Mlungu wenu. ");
INSERT INTO dig_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“Msirye nyama yoyosi iriyo na milatso. Msiloge wala kupiga mburuga. ");
INSERT INTO dig_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Msinyole nyere za pembeni za chitswa wala kunyola pembe za vyeru vyenu, ");
INSERT INTO dig_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","wala msitsodzwe kpwa ajili ya kufwererwa wala kuika alama yoyosi mwenu mirini. Mimi, ndimi Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“Usisababishe mwanao mchetu akakala malaya, sedze tsi ndzima ikamenya katika udiya na hivyo kuodzala uyi. ");
INSERT INTO dig_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Gbwirani malagizo ga Siku zangu za Kuoya na kuishimu phatu phangu phatakatifu. Mimi, ndimi Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“Musiphiye kpwa apigadzi mburuga wala atsai kpwendaendza msada. Muchihenda hivyo, mundanajisika. Mimi, ndimi Mwenyezi Mlungu, Mlungu wenu. ");
INSERT INTO dig_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“Napho u phephi na mtumia mwenye komvwi ima ili umuphe ishima; muogophe Mlunguo. Mimi, ndimi Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“Msimuhendere mai mjeni asagalaye kahi yenu kpwenye tsi. ");
INSERT INTO dig_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Hinyo ajeni asagalao namwi aharireni dza enyezi na muamendze dza vira munavyodzimendza enye, kpwa sababu mwimwi piya mwakala ajeni hiko tsi ya Misiri. Mimi, ndimi Mwenyezi Mlungu, Mlungu wenu. ");
INSERT INTO dig_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“Msihumire vipimo vya kuiyira wakati munapima ure, uziho na unji. ");
INSERT INTO dig_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Mnalondwa kuhumira mizani zirizo za sawa na vipimo vya kpweli. Mimi, ndimi Mwenyezi Mlungu, Mlungu wenu, yekutuluzani kula tsi ya Misiri. ");
INSERT INTO dig_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Gbwirani na mtimize shariya zangu na malagizo gangu. Mimi, ndimi Mwenyezi Mlungu.” ");
INSERT INTO dig_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Mwenyezi Mlungu achimuambira Musa, ");
INSERT INTO dig_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Aambire Aiziraeli hivi: Mutu yeyesi kahi ya Aiziraeli au mjeni asagalaye kahi yenu, achimlavya mwanawe hata mmwenga kukala sadaka kpwa mlungu aihwaye Moleki, mutu hiye ni aolagbwe. Atu asagalao hipho andamuolaga kpwa kumpiga mawe. ");
INSERT INTO dig_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Mimi mwenye nindamtsukirirwa mutu hiye na kumtenga na atue kpwa sababu walavya mmwenga wa anae dza sadaka kpwa Moleki na hivyo akanajisi phatu phangu phatakatifu na dzina rangu takatifu. ");
INSERT INTO dig_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Napho atu asagalao phatu hipho taandamuolaga, ");
INSERT INTO dig_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","mimi mwenye nindamtsukirirwa mutu hiye na nyumbaye. Nindaatenga na atu ao, iye phamwenga na osi ariokosa uaminifu kpwangu kpwa kuphiya kpwa Moleki. ");
INSERT INTO dig_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“Napho mutu yeyesi akakosa uaminifu kpwangu kpwa kuphiya kpwa aganga a kupiga mburuga na atsai, nindamtsukirirwa mutu hiye na kumtenga na atue. ");
INSERT INTO dig_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Kpwa hivyo, dzitakaseni, kalani atakatifu mana mimi, ndimi Mwenyezi Mlungu, Mlungu wenu. ");
INSERT INTO dig_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Gbwirani malagizo gangu na mgalunge. Mimi, ndimi Mwenyezi Mlungu ninayekuhendani mkale atakatifu. ");
INSERT INTO dig_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“Mutu yeyesi ndiyemlani ise au nine, ni aolagbwe. Lawama ra chifoche ri dzuluye mwenye kpwa mana akalani avyazie. ");
INSERT INTO dig_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“Napho mlume akazinga na mkpwaza myawe, osi airi ni aolagbwe. ");
INSERT INTO dig_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Mlume alalaye na mkpwaza ise, anamtiya waibu ise, osi airi ni aolagbwe. Na lawama ra chifo chao ri dzulu yao enye. ");
INSERT INTO dig_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Mlume achilala na mkpwaza-mwanawe, osi airi ni aolagbwe. Higo ni maphingane na lawama ra chifo chao rindakala dzulu yao enye. ");
INSERT INTO dig_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Napho mlume akahenda mlume myawe mchetu, phahi, osi airi ni aolagbwe mana akahenda dzambo ra kutsukiza na milatso yao indakala dzulu yao enye. ");
INSERT INTO dig_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Napho mlume akalóla mchetu chisha amlóle nine wa hiye mchetu, hinyo ni uyi; osi ahahu ni aochwe. Mundahenda hivyo ili kusisa uyi dza hinyo kahi yenu. ");
INSERT INTO dig_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Napho mlume yeyesi akalala na nyama phahi hiye mlume na ye nyama ni aolagbwe. ");
INSERT INTO dig_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Au napho mchetu akasengerera nyama na kulala naye, mchetu hiye na nyama hiye ni aolagbwe. Lawama ra vifo vya mlume hiye na mchetu hiye rindakala dzulu yao. ");
INSERT INTO dig_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“Napho mlume akamlóla mwanao mchetu, mwana baba au mwana mayo na kulala naye, hiro ni dzambo ra kutsukiza na ni atengbwe na atu aho mana akahenda dzambo iyi. Hiye mlume andatsukula lawama ra uyiwe, mana akamvundzira ishima mwanao mchetu. ");
INSERT INTO dig_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Napho mlume akalala na mchetu ariye kpwenye mambo ga chichetu, osi airi ni atengbwe na atu ao. Hiye mlume akafwenula mjero wa hiye mchetu naye mchetu akadzifwenula mjerowe. ");
INSERT INTO dig_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Usilale na mayoo mvyere, mayoo mdide wala shangaziro, mana hinyo ni atuo a phephi. Osi ndiohenda hivyo andatsukula lawama ra uyi wao. ");
INSERT INTO dig_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Mutu achilala na mkpwaza ise mvyere au mdide, anamtiya waibu ise mvyere au mdide. Osi airi andatsukula lawama ra dambi yao. Osi airi andafwa bila ya kuphaha ana. ");
INSERT INTO dig_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Mutu achilóla mlamuwe andamvundzira ishima nduguye, higo ni maphingane, osi airi taandaphaha ana. ");
INSERT INTO dig_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“Gbwirani na kutimiza shariya zangu na malagizo gangu gosi. Ama sivyo tsi hira ambamo ninakuphirikani indakuzolani. ");
INSERT INTO dig_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Msilunge mila za mataifa ambago ndagazola mbere zenu, mana nágazira sana kpwa kuhenda higo gosi. ");
INSERT INTO dig_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Ela, nkakuambirani kare, ‘Mundahala tsi yao yenye rutuba ikale yenu, mana mimi nkakuphani. Mimi, ndimi Mwenyezi Mlungu, Mlungu wenu, niriyekutengani na mataifa ganjina.’ ");
INSERT INTO dig_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Kpwa hivyo, ni mtafwautishe kahi ya nyama ario najisi na asiokala najisi, kahi ya nyama a mapha ario najisi na asiokala najisi. Msidzinajisi kpwa nyama au nyama wa mapha au chochosi chiambalacho dzulu ya tsi ambacho nkachitenga kukala ni najisi kpwenu. ");
INSERT INTO dig_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Kalani atakatifu kpwa sababu mimi Mwenyezi Mlungu ni mtakatifu, nami nkakutengani mwimwi na mataifa ganjina ili mkale angu. ");
INSERT INTO dig_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“Mlume au mchetu yeyesi ambaye anapiga mburuga au mtsai, ni aolagbwe kpwa kupigbwa mawe. Milatsoye indakala dzuluye.” ");
INSERT INTO dig_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Mwenyezi Mlungu achimuambira Musa, “Aambire alavyadzi-sadaka, ana a Aruni, kukala kusikale mutu yeyesi kahi yao ndiyedzitiya najisi kpwa kuguta lufu ra mʼbariwe, ");
INSERT INTO dig_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","isiphokala napho ni mʼbariwe wa phephi sana dza vira nine, ise, mwanawe mlume au mchetu, mwanao mlume ");
INSERT INTO dig_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","au mwanao mchetu ambaye kadzangbwelólwa, anayemtegemea iye. (Mlavyadzi-sadaka anaweza kudzitiya najisi kpwa ajili ya atu dza hinya.) ");
INSERT INTO dig_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Iye naasidzitiye najisi hata anaphofwererwa ni ndugu za mchewe. ");
INSERT INTO dig_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Alavyadzi-sadaka asidzinyole mabato vitswani wala seemu za vyeru vyao wala kudzitsodza ndembo mwao mirini kpwa sababu ya chiriro. ");
INSERT INTO dig_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Ni akale atakatifu kpwa Mlungu wao wala asitiye najisi dzina ra Mlungu wao. Mana aho ndio arehao sadaka za kuochwa kpwa Mwenyezi Mlungu, yani chakurya cha Mlungu wao. Kpwa hivyo, ni akale atakatifu. ");
INSERT INTO dig_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Aho ni asilóle malaya, mchetu asiyekala mwanamwali wala yezolwa ni mlumewe, mana alavyadzi-sadaka ni atakatifu kpwa Mlungu wao. ");
INSERT INTO dig_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Isabuni alavyadzi-sadaka kukala ni atakatifu, mana aho ndio anaolavya sadaka ya chakurya kpwa Mlungu wenu. Aho ni atakatifu kpwenu, mana mimi Mwenyezi Mlungu ndimi ninayekuhendani mkale atakatifu. ");
INSERT INTO dig_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Mwana mchetu wa mlavyadzi-sadaka yeyesi achikala malaya ni aochwe mana anamvundzira ise ishima. ");
INSERT INTO dig_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“Mlavyadzi-sadaka mkpwulu yemwagirwa mafuha na kutengbwa kusudi avwale nguwo takatifu, asidimule nyereze wala asiahule nguwoze kpwa sababu ya chiriro. ");
INSERT INTO dig_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Asimenye nyumba yenye lufu hata napho ni ra ise au ra nine sedze akadzitiya najisi. ");
INSERT INTO dig_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Kpwa sababu akatengbwa kpwa kumwagirwa mafuha naasituluke Phatu Phatakatifu pha Mlunguwe ili asiphatiye najisi. Mimi, ndimi Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Mlavyadzi-sadaka mkpwulu anaweza kulóla mwanamwali tu, ");
INSERT INTO dig_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","iye karuhusiwa kulóla mchetu gungu, mchetu chiyerichwa ni mlumewe wala malaya. Ni alóle mwanamwali wa mbariye, ");
INSERT INTO dig_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","ili asitiye anae najisi. Mimi ndimi Mwenyezi Mlungu yemuhenda akale mtakatifu.” ");
INSERT INTO dig_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Mwenyezi Mlungu achienderera kumuambira Musa, ");
INSERT INTO dig_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Muambire Aruni hivi, ‘Yeyesi wa chivyazicho kahi ya vivyazi vyosi vyedzavyo ambaye ana chirema, kandaruhusiwa kusengera na kunilavira mimi Mlunguwe chakurya changu. ");
INSERT INTO dig_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Mutu yeyesi ariye na chirema na asisengere kumlavira Mlungu chakuryache; akale ni chipofu, chiwete, mwenye uso uriokatwakatwa, agutsiraye, ");
INSERT INTO dig_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","mwenye chigulu au mkpwono uriovundzika, ");
INSERT INTO dig_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","mwenye chinundu, mutu mfupi kuriko kawaida, asiyeona sawa-sawa, ariyefutuka, mwenye uphere au mutu yetulwa. ");
INSERT INTO dig_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Yeyesi wa chivyazi cha mlavyadzi-sadaka Aruni mwenye chirema asisengere phephi kulavya sadaka za kuochwa zilavirwazo Mwenyezi Mlungu. Mutu iye na asisengere na kulavya chakurya cha Mlunguwe, kpwa kukala ana chirema. ");
INSERT INTO dig_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Mutu hiye anaweza kurya chakurya chitakatifu cha Mlunguwe na chakurya chitakatifu zaidi. ");
INSERT INTO dig_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Ela asisengerere iyo paziya wala hipho phatu pha kulavira sadaka mana ana chirema, sedze akanajisi Phatu Phatakatifu, kpwa sababu mimi Mwenyezi Mlungu ndimi ninaye ahenda akale atakatifu.’ ” ");
INSERT INTO dig_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Musa achiambira Aruni, anae na Aiziraeli osi mambo higo gosi. ");
INSERT INTO dig_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Mwenyezi Mlungu achimuambira Musa, ");
INSERT INTO dig_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Muambire Aruni na anae aishimu sadaka takatifu ambazo Aiziraeli akazitenga kpwa ajili yangu, kusudi asibere dzina rangu takatifu. Mimi, ndimi Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Aambire hivi, ‘Mmwenga wenu kahi za vivyazi vyenu vyosi ndiyesengerera sadaka takatifu ambazo Aiziraeli akazitenga kpwa ajili yangu mimi Mwenyezi Mlungu wakati akanajisika, mutu hiye ni atengbwe nami. Mimi, ndimi Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Mutu yeyesi wa chivyazi cha Aruni ndiyekala na mahana au ndiyekala anatulukpwa ni madzi-madzi ni asirye sadaka takatifu hadi ndiphokala swafi. Mutu yeyesi ndiyeguta mutu achiyedzitiya najisi kpwa kuguta lufu, mutu achiyetulukpwa ni minya, ");
INSERT INTO dig_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","chiumbe chochosi chiambalacho ambacho ni najisi au mutu ariye na unajisi wa aina yoyosi; ");
INSERT INTO dig_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","mutu hiye, kandaruhusiwa kurya vyakurya vitakatifu hadi ndiphooga naye andakala najisi hadi dziloni, ");
INSERT INTO dig_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","dzuwa ndiphotswa ndipho andakala swafi. Bada ya hipho andaweza kurya chakurya chitakatifu mana hicho ndicho chakuryache. ");
INSERT INTO dig_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Mlavyadzi-sadaka asirye nyama wa kufwa mwenye wala wa kuolagbwa ni nyama wa tsakani, sedze akadzitiya najisi. Mimi, ndimi Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Kpwa hivyo, alavyadzi-sadaka ni agbwire malagizo gangu, ili asihende dambi akafwa kpwa kugabera. Mimi Mwenyezi Mlungu ndimi niahendaye akale atakatifu.’ ");
INSERT INTO dig_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“Atu a nyumba ya alavyadzi-sadaka machiyao ndio anaoruhusiwa kurya chakurya chitakatifu. Mjeni au mchibaruwa wa mlavyadzi-sadaka karuhusiwa kurya. ");
INSERT INTO dig_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Ela napho mtumwa akagulwa ni mlavyadzi-sadaka kpwa kuhumira pesaze au ariyevyalwa pho pha mlavyadzi-sadaka, anaruhusiwa kurya chakurya hicho. ");
INSERT INTO dig_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Napho mwana mchetu wa mlavyadzi-sadaka akalólwa ni mutu asiyekala mlavyadzi-sadaka, karuhusiwa kurya sadaka takatifu. ");
INSERT INTO dig_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Ela napho hiye mwana mchetu wa mlavyadzi-sadaka ni gungu au akazolwa ni mlumewe na kana mwana, naye akauya kpwa ise na anasagala phapho dza wakati ariphokala msichana, phahi, anaweza kurya chakurya cha ise. Ela phahi, mutu wanjina yeyesi karuhusiwa kurya chakurya hicho. ");
INSERT INTO dig_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Napho mutu akarya chakurya chitakatifu bila kumanya, phahi, andamripha mlavyadzi-sadaka chakurya hicho na aenjereze seemu mwenga ya tsano ya samani ya chakurya hicho. ");
INSERT INTO dig_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Alavyadzi-sadaka asibere sadaka takatifu ambazo Aiziraeli nkuziunula mbere za Mwenyezi Mlungu na kuzipha alavyadzi-sadaka dza mtalo wao ");
INSERT INTO dig_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","kpwa kuricha atu asioruhusiwa azirye. Chihivyo andahenda atu aho akale akosa na alondwe kuiripha. Mimi Mwenyezi Mlungu ndimi nihendaye vitu hivyo kukala vitakatifu.” ");
INSERT INTO dig_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Mwenyezi Mlungu achimuambira Musa, ");
INSERT INTO dig_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Muambire Aruni, anae na Aiziraeli osi hivi, ‘Muiziraeli yeyesi au mjeni asagalaye kahi yenu achireha zawadiye dza sadaka ya kuochwa kpwa Mwenyezi Mlungu, ikale ni ya kuusa naziri au ya hiyari; ");
INSERT INTO dig_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","ni alavye ndzau, turume au ndenje isiyo na chirema ili ikubalike. ");
INSERT INTO dig_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Si ruhusa kulavya chochosi chiricho na chirema mana tachindakubaliwa kpwa fwaida yenu. ");
INSERT INTO dig_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Mutu yeyesi ndiyemlavira Mwenyezi Mlungu sadaka ya amani ili kuusa naziri au sadaka ya hiyari kula kpwenye mfugowe, ni alavye nyama asiye na chirema ndipho akubaliwe. ");
INSERT INTO dig_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Usimlavire Mwenyezi Mlungu nyama yeyesi ariye chipofu, yevundzika chigulu, chigurye, atulukpwaye ni madzi-madzi, mwenye uphere au chironda chidodacho. Msilavye mmwenga wa hinyo kukala sadaka ya kuochwa kpwa Mwenyezi Mlungu dzulu ya phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Munaweza kulavya ndzau, ngʼondzi au mbuzi ariye na chirema dza sadaka ya hiyari, ela kandakubalika kuusira hati. ");
INSERT INTO dig_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Usimlavire Mwenyezi Mlungu nyama ambaye chilungoche cha uvyazi chalumizwa, chabundwa, chavundzwa au chakatwa. Msihendere nyama enu mambo higo kpwenye tsi yenu. ");
INSERT INTO dig_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Wala usikubali kugula nyama a aina iyo kula kpwa ajeni na kunilavira mimi Mlunguo dza chakurya. Nyama hinyo taandakubaliwa kpwa fwaida yenu mana ana virema.’ ” ");
INSERT INTO dig_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Mwenyezi Mlungu achimuambira Musa, ");
INSERT INTO dig_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Mwana ngʼombe, mwana ngʼondzi au mwana mbuzi achivyalwa andasala na nine kpwa siku sabaa. Ela kuandzira siku ya nane anaweza kulaviwa kpwa Mwenyezi Mlungu dza sadaka ya kuochwa. ");
INSERT INTO dig_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Ela usitsindze ngʼombe, ngʼondzi au mbuzi siku mwenga phamwenga na mwanawe. ");
INSERT INTO dig_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Ndiphonirehera mimi Mwenyezi Mlungu sadaka ya shukurani, undailavya kpwa aina ambayo indakuhenda ukubaliwe. ");
INSERT INTO dig_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Nyama hiye ni lazima ariwe siku iyo-iyo. Musiriche chitu hadi ligundzu siku ya phiri. Mimi, ndimi Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Gbwirani na kutimiza malagizo gangu. Mimi, ndimi Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Msiritiye najisi dzina rangu takatifu, mana ni lazima niishimiwe kahi ya atu a Iziraeli. Mimi Mwenyezi Mlungu ndimi ninayekuhendani mkale atakatifu. ");
INSERT INTO dig_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Mimi ndimi yekutuluzani kula tsi ya Misiri kpwa nikale Mlungu wenu. Mimi, ndimi Mwenyezi Mlungu.” ");
INSERT INTO dig_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Mwenyezi Mlungu achimuambira Musa, ");
INSERT INTO dig_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Aambire Aiziraeli hivi: Hizi ndizo sikukuu zangu ambazo mimi Mwenyezi Mlungu nkazipanga mundazitangaza kpwenye mikutano yenu mitakatifu kpwa ishima yangu. ");
INSERT INTO dig_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“Mundahenda kazi siku sita bahi, ela siku ya sabaa ni Siku ya Kuoya. Siku hiyo, mundakala na mkpwutano mtakatifu. Siku iyo ni takatifu kpwa Mwenyezi Mlungu namwi tamundahenda kazi kokosi msagalako. ");
INSERT INTO dig_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“Hizi ndizo sikukuu zanjina za Mwenyezi Mlungu ambazo ni mzitangaze kpwa wakatiwe uriopangbwa chisha mkale na mkpwutano mtakatifu. ");
INSERT INTO dig_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","“Dziloni wakati jiza rinahanda siku ya kumi na ne ya mwezi wa mwandzo, mundamuishimu Mwenyezi Mlungu kpwa kusherekeya sikukuu ya Pasaka. ");
INSERT INTO dig_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Alafu sikukuu ya Mikahe Isiyotiywa Hamira ya kuishimu Mwenyezi Mlungu indaandza siku ya kumi na tsano ya mwezi uho. Kpwa muda wa siku sabaa, mundarya mikahe isiyotiywa hamira. ");
INSERT INTO dig_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Siku ya kpwandza mundakala na mkpwutano mtakatifu na msihende kazi zozosi za kawaida. ");
INSERT INTO dig_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Mundanilavira mimi Mwenyezi Mlungu sadaka za kuochwa kpwa siku sabaa. Siku ya sabaa mundahenda mkpwutano mtakatifu na msihende kazi za kawaida.” ");
INSERT INTO dig_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Mwenyezi Mlungu achimuambira Musa, ");
INSERT INTO dig_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Aambire Aiziraeli hivi: Mndiphoinjira tsi ambayo ninakuphani na kuvuna mavunoge, mundamrehera mlavyadzi-sadaka butsa ra kpwandza ra mavunogo. ");
INSERT INTO dig_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Mlavyadzi-sadaka andariunula mbere za Mwenyezi Mlungu siku inayolungira Siku ya Kuoya ili mphahe kukubaliwa. ");
INSERT INTO dig_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Siku iyo ndiphoriounula hiro butsa mbere za Mwenyezi Mlungu mundamlavira sadaka ya kuochwa ya turume ra mwaka mmwenga risirokala na chirema. ");
INSERT INTO dig_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Phamwenga na sadaka hiyo, mundamlavira Mwenyezi Mlungu sadaka ya mtsere ya kilo mbiri za unga mnono uriotsanganywa na mafuha yenye kungu nono imuhamirayo, na sadakaye ya chinwadzi cha lita mwenga ya uchi wa zabibu. ");
INSERT INTO dig_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Kabila ya siku iyo ya kumrehera Mwenyezi Mlungu wenu sadaka hiyo, tamruhusiwa kurya mavuno ga matsere, gakale maphya, gakale gakukalangbwa au gakujitwa kukala mikahe. Hiri ni lagizo ra kare na kare kpwa vivyazi vyenu vyosi phatu phophosi mndiphosagala. ");
INSERT INTO dig_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“Mundaolanga majuma sabaa hangu siku inayolunga Siku ya Kuoya ambayo mwareha butsa ra sadaka ya kuunulwa mbere za Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Ligundzure bada ya higo majuma sabaa, yani siku ya mirongo mitsano mundamlavira Mwenyezi Mlungu sadaka ya mtsere muphya. ");
INSERT INTO dig_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Chila nyumba indareha mikahe miiri ya sadaka ya kuunulwa mbere za Mwenyezi Mlungu. Mikahe iyo indatengezwa na kilo mbiri za unga mnono uriotiywa hamira, iyo ni sadaka ya mavuno genu ga mwandzo ndiyo mundamlavira Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Phamwenga na hiyo, mundareha maturume sabaa ga mwaka mmwenga-mmwenga, ndzau mmwenga, na maturume mairi gosi gasigokala na virema. Nyama hinyo andakala sadaka za kuochwa ambazo zindalaviwa phamwenga na sadaka zao za mtsere na sadaka zao za chinwadzi, zikale sadaka yenye kungu nono imuhamirayo Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Mundalavya ndenje mmwenga ikale sadaka ya kuusa dambi na maturume mairi ga mwaka mmwenga-mmwenga kpwa ajili ya sadaka ya amani. ");
INSERT INTO dig_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Mlavyadzi-sadaka andareha hura mkpwahe wa mavuno ga mwandzo na gara maturume mairi mbere za Mwenyezi Mlungu gakale sadaka ya kuunulwa. Hizo ni sadaka takatifu kpwa Mwenyezi Mlungu nazo zindakala za mlavyadzi-sadaka. ");
INSERT INTO dig_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Siku iyo-iyo mundatangaza mkpwutano mtakatifu namwi msihende kazi za kawaida. Hiri ni lagizo ra kare na kare kpwa vivyazi vyenu vyosi phatu phophosi mndiphosagala. ");
INSERT INTO dig_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“Ndiphovuna mavunogo mwako mundani, usivune tsetsetse hadi muphakani wala usiuye uchatsembwesa. Higo undagarichira achiya na ajeni. Mimi, ndimi Mwenyezi Mlungu, Mlungu wenu.” ");
INSERT INTO dig_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Mwenyezi Mlungu achimuambira Musa, ");
INSERT INTO dig_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Aambire atu a Iziraeli hivi, ‘Siku ya kpwandza ya mwezi wa sabaa indakala Siku ya Kuoya, siku ya kutambukirwa ndiyotangazwa kpwa kupiga gunda na kuhenda mkpwutano mtakatifu. ");
INSERT INTO dig_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Msihende kazi yoyosi ya kawaida siku iyo ela mumrehere Mwenyezi Mlungu sadaka za kuochwa.’ ” ");
INSERT INTO dig_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Mwenyezi Mlungu achimuambira Musa, ");
INSERT INTO dig_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Siku ya kumi ya mwezi uhu wa sabaa ni siku ya upatanisho wa kuusira dambi. Siku iyo mundakala na mkpwutano mtakatifu. Mundafunga na kumrehere Mwenyezi Mlungu za kuochwa sadaka. ");
INSERT INTO dig_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Msihende kazi zenu zozosi za kawaida siku hiyo. Siku iyo ni siku ya upatanisho wa kuusira dambi, siku ya kukuhenderani mwimwi upatanisho mbere za Mwenyezi Mlungu, Mlungu wenu. ");
INSERT INTO dig_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Mutu yeyesi ambaye kandafunga siku iyo ni lazima andatengbwa na atue. ");
INSERT INTO dig_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Mutu yeyesi ndiyehenda kazi yoyosi siku iyo ndamuolaga. ");
INSERT INTO dig_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Msihende kazi: hiri ni lagizo ra kare na kare kpwa vivyazi vyenu vyosi, kokosi ndikosagala. ");
INSERT INTO dig_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Siku ya tisiya dziloni ya mwezi hinyo hadi dziloni ra siku ya kumi, indakala Siku ya Kuoya namwi mundafunga.” ");
INSERT INTO dig_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Mwenyezi Mlungu achimuambira Musa, ");
INSERT INTO dig_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Aambire Aiziraeli hivi, Kuandzira siku ya kumi na tsano ya mwezi hinyo wa sabaa, mundamuishimu Mwenyezi Mlungu kpwa kusherekeya Sikukuu ya Vibanda kpwa muda wa siku sabaa. ");
INSERT INTO dig_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Siku ya kpwandza ya iyo sikukuu, mundakala na mkpwutano mtakatifu na msihende kazi yoyosi ya kawaida. ");
INSERT INTO dig_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Mundamrehera Mwenyezi Mlungu sadaka za kuochwa kpwa siku sabaa. Siku ya nane mundakala na mkpwutano mtakatifu na mrehere Mwenyezi Mlungu sadaka za kuochwa. Hinyo ndio ndiokala mkpwutano wa mwisho, namwi msihende kazi yoyosi ya kawaida siku hiyo. ");
INSERT INTO dig_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“Hizo ndizo sikukuu za Mwenyezi Mlungu zirizopangbwa ambazo mundazitangaza na muhende mikutano mitakatifu ya kumrehera Mwenyezi Mlungu sadaka zilungirazo; sadaka za kuochwa, sadaka za mtsere, sadaka za vinwadzi na sadaka zanjina, chila siku na sadakaye. ");
INSERT INTO dig_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Sadaka hizo ni mbali na zira za Siku za Kuoya ya Mwenyezi Mlungu, sadaka zenu za kawaida, sadaka za kuusa naziri zenu na sadaka zenu za hiyari munazomrehera Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“Kpwa hivyo bada ya kuvuna mavuno ga mwenu mindani, mundasherekeya sikukuu ya Mwenyezi Mlungu kpwa muda wa siku sabaa, kuandzira siku ya kumi na tsano ya mwezi wa sabaa. Siku ya kpwandza na siku ya nane zindakala Siku za Kuoya. ");
INSERT INTO dig_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Iyo siku ya kpwandza mundahala aina-aina za matunda ga mihi yenu minono, makandza ga mitende, panda zenye makodza manji na panda za mihi imerayo kanda-kanda ya muho, namwi mundasherekeya kpwa siku sabaa mbere za Mwenyezi Mlungu, Mlungu wenu. ");
INSERT INTO dig_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Chila mwezi wa sabaa ni mumuishimu Mwenyezi Mlungu kpwa kusherekeya sikukuu hino kpwa siku sabaa. Hiri ni lagizo ra kare na kare kpwa vivyazi vyenu vyosi. ");
INSERT INTO dig_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Kpwa muda wa siku sabaa mundasagala vibandani, osi ariovyalwa Iziraeli andaishi vibandani wakati hinyo. ");
INSERT INTO dig_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Chihivyo vivyazi vyenu vindamanya kukala náhenda Aiziraeli aishi vibandani, nriphoatuluza tsi ya Misiri. Mimi, ndimi Mwenyezi Mlungu, Mlungu wenu.” ");
INSERT INTO dig_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Kpwa hivyo Musa achiatangazira Aiziraeli osi sikukuu za Mwenyezi Mlungu zirizopangbwa. ");
INSERT INTO dig_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Mwenyezi Mlungu achimuambira Musa, ");
INSERT INTO dig_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Lagiza atu a Iziraeli akurehere mafuha swafi ga zaituni kpwa ajili ya taa, ili taa hizo zienderere kuaka. ");
INSERT INTO dig_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Aruni andaika taa hizo ndani ya hema ra mkpwutano, kondze ya paziya ya sanduku ra chilagane kusudi ziphahe kuaka mbere za Mwenyezi Mlungu kula dziloni hadi ligundzu. Lagizo hiri ni ra kare na kare kpwa vivyazi vyenu vyosi. ");
INSERT INTO dig_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Aruni andapanga taa hizo dzulu ya chinara cha kuikira taa cha zahabu swafi na ahakikishe zinaaka chila usiku mbere za Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“Undahala unga mnono na utengeze mikahe kumi na miiri, chila mkpwahe undatengezwa na unga kilo mbiri. ");
INSERT INTO dig_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Mikahe iyo indapangbwa misitari miiri dzulu ya meza ya zahabu swafi mbere za Mwenyezi Mlungu, chila msitari mikahe sita. ");
INSERT INTO dig_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Ika ubani swafi kpwenye chila msitari ambao undaochwa ili kuonyesa kukala iyo mikahe ikalaviwa kpwa Mwenyezi Mlungu kpwa kuochwa. ");
INSERT INTO dig_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Chila Siku ya Kuoya, Aruni andapanga mikahe kpwenye misitari mbere za Mwenyezi Mlungu kpwa ajili ya atu a Iziraeli. Hinyo ni wajibu wa Aiziraeli hata kare na kare. ");
INSERT INTO dig_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Aruni na anae a chilume machiyao ndio ndioruhusiwa kurya mikahe hiyo. Nao ni airye Phatu Phatakatifu mana ni seemu takatifu kabisa ya sadaka inayolavirwa Mwenyezi Mlungu kpwa kuochwa. Hinyo ni mtalo wao hata kare na kare.” ");
INSERT INTO dig_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Kpwahenda mutu mmwenga ambaye nine kala ni Muiziraeli na ise ni Mmisiri kahi ya Aiziraeli. Siku mwenga wabwaga kondo na Muiziraeli mo kambini. ");
INSERT INTO dig_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Naye wakufuru Mlungu kpwa kumlani, nao atu achimphirika kpwa Musa. Mutu hiye nine kala ni Shelomithi, mwana mchetu wa Dibiri wa mbari ya Dani. ");
INSERT INTO dig_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Amtiya jela hadi Mwenyezi Mlungu ariphoafwenurira ra kumuhenda. ");
INSERT INTO dig_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Phahi, Mwenyezi Mlungu achimuambira Musa, ");
INSERT INTO dig_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Mtuluze kondze ya kambi mutu yekufuru, alafu Aiziraeli osi ariokala phapho aike mikono yao dzulu ya chitswache na osi ampige mawe hadi afwe. ");
INSERT INTO dig_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Nawe aambire Aiziraeli kukala, mutu yeyesi ndiyemkufuru Mlunguwe andaripha kpwa ajili ya dambiye. ");
INSERT INTO dig_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Mutu yeyesi akale ni mwenyezi au mjeni ndiyekufuru dzina ra Mwenyezi Mlungu, ni apigbwe mawe ni atu osi hadi afwe. ");
INSERT INTO dig_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“Mutu yeyesi ndiyeolaga myawe ni aolagbwe. ");
INSERT INTO dig_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Mutu yeyesi ndiyeolaga nyama wa myawe, ni amriphe na nyama wanjina. ");
INSERT INTO dig_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Mutu yeyesi ndiyemlumiza myawe, naye ni alumizwe sawa-sawa na vira achivyomlumiza myawe: ");
INSERT INTO dig_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","achimvundza mfupha naye andavundzwa mfupha, dzitso kpwa dzitso, dzino kpwa dzino. Chila mutu ndiyemlumiza myawe naye ni alumizwe dza vivyo. ");
INSERT INTO dig_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Ndiyeolaga nyama wa myawe ni amriphe, ela mutu yeyesi ndiyeolaga mutu wanjina ni aolagbwe. ");
INSERT INTO dig_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Mwimwi mosi mundalunga shariya hiyo, mjeni au mwenyezi. Mimi, ndimi Mwenyezi Mlungu, Mlungu wenu.” ");
INSERT INTO dig_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Chisha Musa achiaambira Aiziraeli lagizo hiri, nao achimphirika yuya mutu yekufuru Mwenyezi Mlungu kondze ya kambi, achendampiga mawe hadi achifwa. Aiziraeli ahenda dza vira Mwenyezi Mlungu arivyomlagiza Musa. ");
INSERT INTO dig_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Mwenyezi Mlungu wamuamba Musa hiko dzulu ya mwango Sinai, ");
INSERT INTO dig_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Aambire Aiziraeli hivi: Mundiphofika yo tsi ambayo nindakuphani, chila mwaka wa sabaa tsi ni ioyezwe yani isirimwe, ili kumuishimu Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Kpwa muda wa miaka sita mundarima, mundaphanda minda yenu, mundatsatsula panda za mizabibu yenu na kuvuna mavuno genu. ");
INSERT INTO dig_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Ela mwaka wa sabaa undakala ni mwaka wa kuoyeza tsi, ni Mwaka wa Kuoya wa Mwenyezi Mlungu. Msiphande chochosi wala kutsatsula panda za mizabibu yenu. ");
INSERT INTO dig_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Msivune chochosi ndichomera chenye, na msidole zabibu kula mihi isiyotsatsulwa. Hinyo undakala mwaka wa kuoyeza tsi. ");
INSERT INTO dig_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Dzagbwe minda taindarimwa mwaka hinyo wa kuoya, ela indalavya chakurya kpwa ajili yenu mwimwi enye, atumwa enu, vibaruwa enu na ajeni asagalao kahi yenu, ");
INSERT INTO dig_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","nyama enu a kufugbwa na nyama a tsakani ario kahi za tsi yenu. ");
INSERT INTO dig_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“Mundaisabu miaka sabaa kano sabaa na jumulaye ni miaka mirongo mine na tisiya. ");
INSERT INTO dig_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Alafu siku ya kumi ya mwezi wa sabaa ambayo ni siku ya kuusirwa dambi mundapiga magunda kahi za tsi yenu yosi. ");
INSERT INTO dig_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Mundautenga mwaka wa mirongo mitsano na kutangazira uhuru atu osi asagalao kpwenye yo tsi. Mwaka hinyo undakala ni mwaka wa kuikpwa huru. Chochosi ambacho chaguzwa ni chiuyizirwe mwenye na yeguzwa dza mtumwa ni auye kpwao. ");
INSERT INTO dig_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Kpwa hivyo kahi za mwaka wa kuikpwa huru msirime, msiphande, na msivune chochosi chinachomera chenye, piya msidole zabibu kula mihi msiyoitsatsula. ");
INSERT INTO dig_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Mwaka hinyo undakala mwaka mtakatifu. Hivyo mundarya mavuno ambago gamera genye bila kuphandwa mo mindani. ");
INSERT INTO dig_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“Mwaka hinyo, chochosi ambacho chaguzwa ni chiuyizirwe mwenye. ");
INSERT INTO dig_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Unaphogula au kuguzira myao munda usimuonere. ");
INSERT INTO dig_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Bei ya munda indalengana na isabu ya miaka ya mavuno chiyosala kabila ya mwaka wanjina wa kuikpwa huru. ");
INSERT INTO dig_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Napho miaka ni minji bei indapanda na ichikala michache bei indatserera, mana beiye indapimwa kulengana na isabu ya minga ya mavuno. ");
INSERT INTO dig_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Msionerane, ela muogopheni Mlungu wenu. Mimi, ndimi Mwenyezi Mlungu, Mlungu wenu. ");
INSERT INTO dig_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“Kpwa hivyo, mundalunga shariya zangu na kutimiza malagizo gangu, ili msagale salama kpwenye tsi hiyo. ");
INSERT INTO dig_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Namwi mundarya na kumvuna mavuno ga yo tsi na msagale salama mumo. ");
INSERT INTO dig_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Ela chahi mundadziuza, ‘Hundaryani mwaka wa sabaa naswi tauruhusiwa kuphanda wala kuvuna?’ ");
INSERT INTO dig_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Mwaka wa sita ndabariki tsi yenu nayo indavyala mavuno ga kukutoshani kpwa miaka mihahu. ");
INSERT INTO dig_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Mndiphophanda mwaka wa nane mundakala munarya mavuno govunwa mwaka wa sita. Namwi mundaenderera kurya mavuno gago hadi ndiphovuna mavuno ga mwaka wa tisiya. ");
INSERT INTO dig_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“Msiguze tsi kabisa-kabisa, mana iyo ni mali yangu na mwimwi mu ajeni na apangadzi angu. ");
INSERT INTO dig_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Ndiyo mana kahi za tsi yenu yosi ni lazima mwenye munda akale na haki ya kuukombola. ");
INSERT INTO dig_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“Napho Muiziraeli myawenu akakala mchiya na kuguza mundawe, phahi, mʼbariwe wa phephi ni aukombole. ");
INSERT INTO dig_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Ichikala mutu yuya kana mʼbari wa kuukombola, ela badaye aongokerwe na kuphaha uwezo wa kukombola mundawe, ");
INSERT INTO dig_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","phahi, andaripha kulengana na isabu ya miaka ichiyosala kufikira mwaka wa kurichirwa huru. Yuya mutu ariyeugula ni amuuyizire. ");
INSERT INTO dig_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Ela ichikala kana uwezo wa kuukombola, phahi, undasala mikononi mwa yuya ariyeugula hadi mwaka wa kuikpwa huru. Mwaka hinyo, mali iyo indauyizwa kpwa yuya mutu ariyeiguza. ");
INSERT INTO dig_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“Mutu achiguza nyumbaye ya kusagala iriyo ndani ya mudzi uriodzengerwa ngome, ana haki ya kuikombola ndani ya mwaka mmwenga hangu ariphoiguza. ");
INSERT INTO dig_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Napho iyo nyumba iriyo ndani ya mudzi uriodzengerwa ngome taiyakombolwa kpwa muda wa mwaka mmwenga, phahi, indakala mali ya yuya ariyeigula na vivyazivye vyosi, nayo taindauyizwa mwaka wa kuikpwa huru uchifika. ");
INSERT INTO dig_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Ela nyumba za malalo ambago tagayazungulusirwa ukuta zindakala tsini ya shariya iratu hira ya minda. Nyumba hizo zinaweza kukombolwa ela ni lazima ziuyizirwe enye mwaka wa kuikpwa huru. ");
INSERT INTO dig_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Ela, Alawi ana haki ya kukombola nyumba zao zirizo mwao midzini wakati wowosi. ");
INSERT INTO dig_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Ichikala mmwenga wa Alawi kahumira hakiye ya kukombolwa, phahi, nyumba iriyoguzwa ni lazima iuyizwe kpwa mwenye mwaka wa kuikpwa huru, mana nyumba za Alawi zirizo mwao midzini, akahewa kama mtalo wao kahi ya atu a Iziraeli. ");
INSERT INTO dig_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Ela seemu za kurisa zinazozunguluka midzi ya Alawi tazindaguzwa, mana hinyo ni mtalo wao hata kare na kare. ");
INSERT INTO dig_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“Napho Muiziraeli myao akakala mchiya hata kaweza kudziendzera mwenye na asagala phamwenga nawe, ni umrorome dza unavyororoma mjeni au mutu asagalaye kpwako kpwa muda, ili aweze kpwenderera kusagala kahi yenu. ");
INSERT INTO dig_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Usimtake akuriphe fwaida ya aina yoyosi. Ela muogophe Mlungu, ili nduguyo aphahe kusagala phamwenga namwi. ");
INSERT INTO dig_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Usimuaphase feza na ukalonda akuriphe na fwaida au uchimguzira chakurya usimtoze zaidi. ");
INSERT INTO dig_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Mimi, ndimi Mwenyezi Mlungu, Mlungu wenu, nriyekutuluzani kula tsi ya Misiri ili nikupheni tsi ya Kanani, na nikale Mlungu wenu. ");
INSERT INTO dig_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“Mueburania myao achidziguza kpwako kpwa kukala ni mchiya, usimuhende akuhumikire dza mtumwa. Muhende dza mchibaruwa au mcharo. ");
INSERT INTO dig_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Andasagala nawe dza mchibaruwa au kama mcharo. Andakuhumikira hadi mwaka wa kuikpwa huru. ");
INSERT INTO dig_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Mwaka hinyo ni umrichire huru iye na anae auye kpwao kpwa mbarize kpwenye munda wa akaree. ");
INSERT INTO dig_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Kpwa kukala Aiziraeli ni atumishi angu ambao naatuluza kula tsi ya Misiri, phahi, asiguzwe dza atumwa. ");
INSERT INTO dig_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Usimuhendese kazi chisiru nduguyo, ela muogophe Mlunguo. ");
INSERT INTO dig_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Munaweza kugula atumwa kula kpwa mataifa ganjina jirani. ");
INSERT INTO dig_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Piya unaweza kugula atumwa kula kpwa ajeni asagalao phamwenga nawe na jamaa zao ariovyalwa kpwenye tsi yenu, nao andakala maliyo. ");
INSERT INTO dig_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Hinyo unaweza kuahenda atumwao na kuapha anao akale mali yao hata kare na kare, ela usimuhendere mai nduguyo Muiziraeli. ");
INSERT INTO dig_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“Napho mjeni au mcharo asagalaye kahi yenu akakala tajiri na Muiziraeli myao achikala mchiya na kudziguza kpwa hiye mjeni au hiye mcharo au kpwa mmwenga wa jamaaze, ");
INSERT INTO dig_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","ana haki ya kukombolwa, mmwenga wa abarie anaweza kumkombola. ");
INSERT INTO dig_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Akale ni aphuye, mkpwoiwe au mbariwe. Piya anaweza kudzikombola mwenye napho akaongokerwa. ");
INSERT INTO dig_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Iye na yuya ariyemgula, andaisabu miaka hangu ariphodziguza hadi mwaka wa kurichirwa huru. Maripho ga kukombolwakpwe gandalengana na maripho ga mchibaruwa kpwa miaka ichiyosala kufikira mwaka wa kuikpwa huru. ");
INSERT INTO dig_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Napho isabu ya miaka ichiyosala ni minji, andadzikombola kpwa kuripha seemu kulu ya bei ariyogurirwa. ");
INSERT INTO dig_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Napho ikasala miaka michache kabila kufikira mwaka wa kuikpwa huru, andapiga isabu na ariphe kulengana na miaka ichiyosala ili kudzikombola. ");
INSERT INTO dig_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Muda wosi anaphokala kpwa tajiriwe analondwa kuhenderwa kama mtumishi wa mshahara chila mwaka. Hiye ariyemgula asimuhendese kazi chisiru. ");
INSERT INTO dig_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Ela ichikala mutu hiyu kakakombolwa kpwa njira hizo, phahi mwaka wa kuikpwa huru uchifika naarichirwe huru phamwenga na anae. ");
INSERT INTO dig_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Aiziraeli ni atumishi angu, mana náatuluza kula tsi ya Misiri. Mimi, ndimi Mwenyezi Mlungu, Mlungu wenu. ");
INSERT INTO dig_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“Msidzitengezere vizuka, msidziimisire vizuka vya kutsongbwa au nguzo wala mawe ga kutsongbwa kpwenye tsi yenu na kugaabudu. Mimi, ndimi Mwenyezi Mlungu, Mlungu wenu. ");
INSERT INTO dig_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Gbwirani Siku zangu za Kuoya na muishimu phatu phangu phatakatifu. Mimi, ndimi Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“Ichikala mundalunga malagizo gangu na kugbwira shariya zangu, ");
INSERT INTO dig_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","nindakureherani mvula kpwa wakatiwe, tsi ivyale mavuno, na mihi ivyale matunda. ");
INSERT INTO dig_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Kuwaga mtsere kundaendelea hadi wakati wa kuvuna zabibu, na kuvuna zabibu hadi wakati wa kuphanda. Mundakala na chakurya cha kutosha na msagale salama kpwenye tsi yenu. ");
INSERT INTO dig_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Nindakuphani amani kpwenye tsi ili muweze kulala bila kutishirwa ni yeyesi. Nindausa nyama asiru kpwenye tsi yenu nayo taindakala na viha tsona. ");
INSERT INTO dig_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Mundazola maadui genu na kugaolaga kpwa mufyu. ");
INSERT INTO dig_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Atsano enu andazola maadui gana mwenga na atu enu gana mwenga andazola maadui elufu kumi. Mundaolaga maadui genu. ");
INSERT INTO dig_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Nindakujaliyani na kukuhendani muvyalane na muenjerezeke. Nami nindatimiza chilagane changu namwi. ");
INSERT INTO dig_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Mundakala na mavuno manji chiasi cha kukala ni mtuluze ga kare ambago tagadzangbwesira ili mtiye maphya. ");
INSERT INTO dig_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Nindaika makalo gangu kahi yenu, wala sindakurichani. ");
INSERT INTO dig_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Nindakala kahi yenu na nkale Mlungu wenu, namwi mundakala atu angu. ");
INSERT INTO dig_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Mimi, ndimi Mwenyezi Mlungu, Mlungu wenu, yekutuluzani kula tsi ya Misiri ili msihendwe atumwa tsona. Nami nchivundza magogolo mrigokala mkafungbwa mwenu singoni na kukuhendani mnyendeke huru. ");
INSERT INTO dig_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“Ela napho tamundanisikira wala kulunga malagizo gangu, ");
INSERT INTO dig_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","napho mundavundza chilagane changu kpwa kurema shariya yangu, kumena na kuricha kulunga malagizo gangu, ");
INSERT INTO dig_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","phahi nindakuhendani hivi: Nindakutiyani wuoga mkpwulu gafula, ukongo wa nyerenyere na homa ndirokuhendani vipofu na anyonje. Mundaphanda bure mana mavuno gandariwa ni maadui genu. ");
INSERT INTO dig_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Nindakulozerani kogo ili mpigbwe ni maadui genu. Hara anaokutsukirirwani andakutawalani namwi mundachimbira kpwa wuoga hata napho taphana anayekuzoresani. ");
INSERT INTO dig_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“Na ichikala tamundanisikira hata bada ya kutiywa adabu hiyo, phahi, nindakutiyani adabu kano sabaa kpwa ajili ya dambi zenu. ");
INSERT INTO dig_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Kudzikarya kpwenu ndakuusa tsetsetse kpwa kuhenda dzulu mlunguni kusirehe mvula kukale kufu dza chuma na tsi yenu ikale nyifu bila madzi dza shaba. ");
INSERT INTO dig_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Mundahumira nguvu zenu bure mana minda yenu taindalavya mavuno na mihi taindavyala matunda. ");
INSERT INTO dig_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“Namwi mchienderera kunipinga na kurema kuniphundza, nindazidisha mashaka genu kano sabaa kulengana na dambi zenu. ");
INSERT INTO dig_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Nindareha nyama a tsakani kahi yenu ambao andaolaga ana enu na kurya mifugo yenu na kuphunguza isabu yenu hadi njira zenu zikale wekee bila atu. ");
INSERT INTO dig_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“Napho bada ya adabu iyo bado tamundaniuyira, ela mzidi kupingana nami, ");
INSERT INTO dig_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","phahi, nindakupingani mimi mwenye na nikupigeni na mashaka kano sabaa kpwa ajili ya dambi zenu. ");
INSERT INTO dig_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Nindakureherani viha ili nkutiyeni adabu kpwa kuvundza chilagane. Mchizorera kpwenye midzi yenu, nindakureherani ukongo mui namwi mundatiywa mikononi mwa maadui genu. ");
INSERT INTO dig_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Chakurya chenu ndachiphunguza hadi achetu kumi ahumire figa mwenga tu kujita mikahe na akuganyireni kpwa chipimo. Namwi mundarya ela tamundamvuna. ");
INSERT INTO dig_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“Napho tamundanisikira ela mundaenderera kunipinga hata bada ya higo gosi, ");
INSERT INTO dig_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","phahi nami nindakupingani kpwa tsukizi kali, na kukutiyani adabu kano sabaa zaidi kpwa ajili ya dambi zenu. ");
INSERT INTO dig_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Ndzala indakala kali hadi murye ana enu. ");
INSERT INTO dig_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Ndabananga mwatu mwenu mwa dzulu mwa kuabudu, nibomole mwatu mwenu mwa kufukizira uvumba, na kutsupha nyufu zenu dzulu ya vizuka vyenu visivyokala na uhai, nami nindakumenani kabisa. ");
INSERT INTO dig_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Ndaihenda midzi yenu ikale magandzo, na kubananga mwatu mwenu mwa kuabudu. Na kungu nono ya sadaka zenu taindanihamira. ");
INSERT INTO dig_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Ndahenda tsi yenu ikale tuphu hadi maadui genu gasagalago himo gaangalale. ");
INSERT INTO dig_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Nindakutsamulani kahi za mataifa na kukureherani viha. Tsi yenu indakala bila chitu na midzi yenu indabanangbwa. ");
INSERT INTO dig_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","“Wakati tamupho mkaphirikpwa tsi ya maadui genu na tsi yenu ikarichwa gandzo; ndipho tsi indaoya na kuhererwa na Miakaye ya Kuoya. ");
INSERT INTO dig_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Wakati tsi ndiphokala ikarichwa bila chitu, indaoya kpwa kukala taiyioyezerwe wakati wa Miaka ya Kuoya mriphokala munasagala himo. ");
INSERT INTO dig_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Na hinyo ayawenu ndiosala ndaatiya wuoga kpwenye tsi ya maadui gao chiasi cha kukala hata sauti ya kodza rinarophepheruswa indaaondosa azole. Phahi aho andazola dza mutu anayechimbira viha. Andazola na kugbwa hata napho taphana mutu anayeazoresa. ");
INSERT INTO dig_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Andagbwererana ovyo-ovyo dza atu anaochimbira viha hata napho taphana anayeazoresa. Taandaweza kudzihehera napho akavwamiywa ni maadui gao. ");
INSERT INTO dig_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Andafwa kahi za mataifa nao andazikpwa tsi ya maadui gao. ");
INSERT INTO dig_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Hara ndiosala kahi yenu, andasirirwa ni mkpwotse kpwenye tsi ya maadui genu kpwa sababu ya dambi zao na za akare ao. ");
INSERT INTO dig_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“Ela achikubali dambi zao na dambi za akare ao, arivyokosa uaminifu na achiniasi, ");
INSERT INTO dig_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","chiasi cha kunihenda niapinge na kuaphirika tsi ya maadui gao. Ichikala mioyo yao mifu indagbwa maguluni na kukubali kutiywa adabu, ");
INSERT INTO dig_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","phahi, hipho nami nindatambukira chilagane changu nrichoika na Jakobo, Isaka na Burahimu, na kutambukira nrivyoalaga kuhusu tsi hiyo. ");
INSERT INTO dig_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","“Ela yo tsi ni ikale wekee bila atu kpwandza ili ihererwe na Miakaye ya Kuoya. Nao ni ariphe kpwa ajili ya dambi zao kpwa kurema shariya zangu na kumena malagizo gangu. ");
INSERT INTO dig_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Ela, phamwenga na higo gosi, ndiphokala tsi ya maadui gao, mimi sindaaricha wala kuamena hadi niaolage tsetsetse na kuvundza chilagane changu nao. Mimi, ndimi Mwenyezi Mlungu, Mlungu wao. ");
INSERT INTO dig_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Ela kpwa ajili yao nindatambukira chilagane nrichoika na akare aho ambao naatuluza kula tsi ya Misiri kuno mataifa ganalola, ili mimi nikale Mlungu wao. Mimi, ndimi Mwenyezi Mlungu.” ");
INSERT INTO dig_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Hizo ndizo shariya, malagizo na masharuti ambago Mwenyezi Mlungu waapha atu a Iziraeli hiko mwango Sinai kutsupira Musa. ");
INSERT INTO dig_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Mwenyezi Mlungu achimuambira Musa, ");
INSERT INTO dig_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Aambire Aiziraeli hivi: Mutu achiika naziri ya kumtenga mutu kpwa ajili ya Mwenyezi Mlungu, mutu hiye anaweza kukombolwa kpwa kuripha chipimo cha feza chinachokadiriwa dza hivi: ");
INSERT INTO dig_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Mlume wa miaka mirongo miiri hadi miaka mirongo sita andakombolwa kpwa vipande mirongo mitsano vya feza kulengana na chipimo cha Phatu Phatakatifu. ");
INSERT INTO dig_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Napho ni mchetu, andakombolwa kpwa vipande mirongo mihahu vya feza. ");
INSERT INTO dig_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Napho mutu hiye ni wa miaka kahi ya mitsano na mirongo miiri andakombolwa kpwa vipande mirongo miiri vya feza napho ni mlume, na vipande kumi vya feza napho ni mchetu. ");
INSERT INTO dig_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Ichikala ni mwana wa umuri wa kahi ya mwezi mmwenga na miaka mitsano andakombolwa kpwa vipande vitsano vya feza napho ni mlume na vipande vihahu vya feza napho ni mchetu. ");
INSERT INTO dig_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Ichikala mutu hiye umriwe ni zaidi ya miaka mirongo sita, beiye indakala ni vipande kumi na tsano vya feza, napho ni mlume, na vipande kumi vya feza napho ni mchetu. ");
INSERT INTO dig_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Ela ichikala mutu hiye ni mchiya na kaweza kuripha mariphoge, phahi, mutu hiye andaphirikpwa kpwa mlavyadzi-sadaka. Mlavyadzi-sadaka andapima beiye kulengana na uwezo wa hiye ariyeika hati. ");
INSERT INTO dig_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“Ichikala yo hatiye ni ya nyama anayekubalika kumlavira Mwenyezi Mlungu sadaka, phahi nyama hiye akakala chitu chitakatifu. ");
INSERT INTO dig_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Tairuhusiwa kumʼbadilisha nyama hiye na wanjina yeyesi, mnono kpwa mui au mui kpwa mnono. Napho akamʼbadilisha na nyama wanjina, osi airi andakala atakatifu. ");
INSERT INTO dig_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","“Ichikala yo naziri inahusu nyama najisi, ambaye karuhusiwa kulavirwa Mwenyezi Mlungu, phahi, mutu amlavyaye, andamreha kpwa mlavyadzi-sadaka. ");
INSERT INTO dig_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Hiye mlavyadzi-sadaka andalavya beiye kulengana na unonowe au uyiwe. Ndivyoamua mlavyadzi-sadaka, ndivyo ndivyokala. ");
INSERT INTO dig_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Ela ichikala mwenye analonda kumkombola, phahi, andaenjereza seemu mwenga ya tsano ya bei ya nyama hiye. ");
INSERT INTO dig_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“Mutu achitenga nyumbaye ikale takatifu kpwa Mwenyezi Mlungu, mlavyadzi-sadaka andalavya beiye kulengana na unono au uyiwe. Vira ndivyoamua, ndivyo ndivyokala. ");
INSERT INTO dig_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Napho hiye mutu ariyeitenga analonda kuikombola, phahi, andaenjereza seemu mwenga ya tsano ya bei ya nyumba hiyo, nayo indakala yakpwe. ");
INSERT INTO dig_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“Mutu achitenga seemu ya mundawe, kpwa ajili ya Mwenyezi Mlungu, phahi, beiye indapimwa kulengana na chiasi cha mbeyu zinazohumirwa kuphanda munda hinyo. Kpwa chila kilo gana mwenga za shayiri beiye indakala vipande mirongo mitsano vya feza. ");
INSERT INTO dig_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Mutu achitenga mundawe mwaka wa kuikpwa huru, beiye indakala ni iyo-iyo. ");
INSERT INTO dig_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Ela achiutenga bada ya mwaka hinyo, phahi, mlavyadzi-sadaka andalavya beiye kulengana na miaka ichiyosala kufikira mwaka wa kuikpwa huru na beiye indaphunguzwa. ");
INSERT INTO dig_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Napho mwenye akalonda kuukombola, phahi, aenjereze seemu mwenga ya tsano ya bei ya munda hinyo, nao undakala maliye. ");
INSERT INTO dig_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Ela napho akauguzira mutu wanjina bila kuukombola, phahi kaweza kuukombola tsona. ");
INSERT INTO dig_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Wakati wa mwaka wa kuikpwa huru munda hinyo undarichirwa, nao undakala mtakatifu kpwa Mwenyezi Mlungu hata kare na kare. Nao undakala wa alavyadzi-sadaka. ");
INSERT INTO dig_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“Mutu achitengera Mwenyezi Mlungu munda ariougula, ambao sio wa kurisi, ");
INSERT INTO dig_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","mlavyadzi-sadaka andalavya bei ya munda hinyo kpwa kulengana na miaka ichiyosala kufikira mwaka wa kuikpwa huru na mutu hiye andaripha beiye kama chitu chitakatifu kpwa Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Ela mwaka wa kuikpwa huru, munda hinyo ni auyizirwe yuya mutu ariyeuguza. ");
INSERT INTO dig_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Chila bei indapimwa kulengana na chipimo cha Phatu Phatakatifu: uziho wa gera mirongo miiri ni sawa na uziho wa chipande chimwenga cha feza. ");
INSERT INTO dig_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“Tairuhusiwa kumtenga mwana wa mwandzo wa mfugo kpwa kukala hiye ni wa Mwenyezi Mlungu kare, akale ni ngʼombe, ngʼondzi au mbuzi. ");
INSERT INTO dig_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Napho ni nyama ariyenajisi, mwenye andamgula kpwa kulengana na vira munavyompima na andaenjereza seemu mwenga ya tsano ya bei ya nyama hiye. Napho kakombolwa, phahi andaguzwa kulengana na vipimo virivyoikpwa. ");
INSERT INTO dig_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“Ela chitu chochosi chirichotengbwa kabisa-kabisa kpwa Mwenyezi Mlungu, tachindaguzwa wala kukombolwa; ikale ni mutu, nyama au munda wa urisi. Chitu hicho ni cha Mwenyezi Mlungu na ni chitakatifu kabisa. ");
INSERT INTO dig_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Mutu yeyesi yetengbwa kpwa ajili ya Mwenyezi Mlungu asikombolwe; hiye ni aolagbwe. ");
INSERT INTO dig_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“Zaka za mavuno gakale ni mtsere au matunda, gosi ni mali ya Mwenyezi Mlungu. Gosi ni matakatifu kpwa Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Napho mutu anakombola seemu ya zakaye, ni ariphe samaniye na aenjereze seemu mwenga ya tsano ya zaka hiyo. ");
INSERT INTO dig_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Kuhusu mifugo, chila nyama wa kumi ni mtakatifu kpwa Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Mutu asiuze napho nyama hiye ni mnono au mui wala nyama hiye kandakakanizwa na wanjina. Ichikala andakakanizwa na wanjina, phahi nyama osi airi andakala atakatifu; taandakombolwa.” ");
INSERT INTO dig_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Higa ndigo malagizo ambago Mwenyezi Mlungu wamupha Musa hiko mwango Sinai ili aambire Aiziraeli.");
INSERT INTO dig_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Siku ya kpwandza ya mwezi wa phiri, mwaka wa phiri bada ya atu a Iziraeli kuuka Misiri, Mwenyezi Mlungu wagomba na Musa ndani ya hema ra mkpwutano hiko kpwenye jangbwa ra Sinai. Iye achiamba, ");
INSERT INTO dig_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Aolangeni Aiziraeli osi kulengana na miryango yao, na nyumba zao, chila mlume mmwenga-mmwenga kulengana na dzinare, ");
INSERT INTO dig_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","ariye na miaka mirongo miiri na kpwenderera mumu Iziraeli anaoweza kuphiya vihani. Uwe na Aruni mundaandikisha kulengana na makundi gao. ");
INSERT INTO dig_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Mlume mmwenga kula chila mbari ambaye ni chilongozi wa nyumbaye andakala phamwenga namwi. ");
INSERT INTO dig_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Higa ni madzina ga atu ambao andakuterya: Elisuri, mwana wa Shedeuri kula mbari ya Rubini; ");
INSERT INTO dig_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Shelumieli, mwana wa Surishadai kula mbari ya Simioni; ");
INSERT INTO dig_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Nashoni, mwana wa Aminadabu kula mbari ya Juda; ");
INSERT INTO dig_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Nethaneli, mwana wa Suari kula mbari ya Isakari; ");
INSERT INTO dig_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Eliabu, mwana wa Heloni kula mbari ya Zabuloni; ");
INSERT INTO dig_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Kula kahi za ana a Yusufu: Elishama, mwana wa Amihudi kula mbari ya Efuraimu; Gamalieli, mwana wa Pedasuri kula mbari ya Manase; ");
INSERT INTO dig_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Abidani, mwana wa Gidioni kula mbari ya Benjamini; ");
INSERT INTO dig_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Ahiezeri, mwana wa Amishadai kula mbari ya Dani; ");
INSERT INTO dig_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Pagieli, mwana wa Okirani kula mbari ya Asheri; ");
INSERT INTO dig_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Eliasafu, mwana wa Deueli kula mbari ya Gadi; ");
INSERT INTO dig_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Ahira, mwana wa Enani kula mbari ya Nafutali.” ");
INSERT INTO dig_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Hinya ndio atu ariotsambulwa kula kpwa atu osi, dza vilongozi a mbari za akare aho na vilongozi a mryango ya Iziraeli. ");
INSERT INTO dig_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","18","Kpwa usaidizi wa hinya atu kumi na airi, Musa na Aruni aiha phamwenga atu osi siku ya kpwandza ya mwezi wa phiri na achiaandikisha kulengana na miryango yao na nyumba zao. Hara ariokala akafisa miaka mirongo miiri na kpwenderera aandikpwa madzina mmwenga-mmwenga, ");
INSERT INTO dig_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","dza Mwenyezi Mlungu arivyomlagiza Musa. Naye achiaolanga hiko jangbwa ra Sinai. ");
INSERT INTO dig_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Alume osi kula chivyazi cha Rubini yekala mwana wa mwandzo wa Iziraeli, ariokala akafisa miaka mirongo miiri na kpwenderera aambao kala anaweza kuphiya vihani, aandikpwa madzina chila mmwenga kulengana na mryangowe na nyumbaye. ");
INSERT INTO dig_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Atu arioolangbwa kula mbari ya Rubini kala ni elufu mirongo mine na sita na magana matsano. ");
INSERT INTO dig_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Alume osi kula chivyazi cha Simioni ariokala akafisa miaka mirongo miiri na kpwenderera ambao kala anaweza kuphiya vihani, aandikpwa madzina chila mmwenga kulengana na mryangowe na nyumbaye. ");
INSERT INTO dig_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Jumula ya atu arioolangbwa kula mbari ya Simioni kala ni elufu mirongo mitsano na tisiya na magana mahahu. ");
INSERT INTO dig_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Alume osi kula chivyazi cha Gadi kuandzira miaka mirongo miiri na kpwenderera ambao kala anaweza kuphiya vihani, aandikpwa madzina kulengana na mryangowe na nyumbaye. ");
INSERT INTO dig_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Jumula ya atu arioolangbwa kula mbari ya Gadi kala ni elufu mirongo mine na tsano na magana sita na mirongo mitsano. ");
INSERT INTO dig_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Alume osi kula chivyazi cha Juda kuandzira miaka mirongo miiri na kpwenderera ambao kala anaweza kuphiya vihani, aandikpwa madzina kulengana na mryangowe na nyumbaye. ");
INSERT INTO dig_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Jumula ya atu arioolangbwa kula mbari ya Juda kala ni elufu mirongo sabaa na ne na magana sita. ");
INSERT INTO dig_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Alume osi kula chivyazi cha Isakari kuandzira miaka mirongo miiri na kpwenderera ambao kala anaweza kuphiya vihani, aandikpwa madzina kulengana na mryango wao na nyumba zao. ");
INSERT INTO dig_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Jumula ya atu arioolangbwa kula mbari ya Isakari kala ni elufu mirongo mitsano na ne na magana mane. ");
INSERT INTO dig_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Alume osi kula chivyazi cha Zabuloni a kuandzira miaka mirongo miiri na kpwenderera ambao kala anaweza kuphiya vihani, aandikpwa madzina kulengana na miryango yao na nyumba zao. ");
INSERT INTO dig_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Jumula ya atu arioolangbwa kula mbari ya Zabuloni kala ni elufu mirongo mitsano na sabaa na magana mane. ");
INSERT INTO dig_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Kula kahi za ana a Yusufu: Atu a mbari ya Efuraimu: Alume osi a kuandzira miaka mirongo miiri na kpwenderera ambao kala anaweza kuphiya vihani, aandikpwa madzina kulengana na miryango yao na nyumba zao. ");
INSERT INTO dig_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Jumula ya atu arioolangbwa kula mbari ya Efuraimu kala ni elufu mirongo mine na magana matsano. ");
INSERT INTO dig_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Alume osi kula chivyazi cha Manase a miaka mirongo miiri na kpwenderera ambao kala anaweza kuphiya vihani, aandikpwa madzina kulengana na miryango yao na nyumba zao. ");
INSERT INTO dig_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Jumula ya atu arioolangbwa kula mbari ya Manase kala ni elufu mirongo mihahu na mbiri na magana mairi. ");
INSERT INTO dig_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Alume osi kula chivyazi cha Benjamini ariokala akafisa miaka mirongo miiri na kpwenderera ambao kala anaweza kuphiya vihani, andikpwa madzina kulengana na miryango yao na nyumba zao. ");
INSERT INTO dig_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Jumula ya atu arioolangbwa kula mbari ya Benjamini kala ni elufu mirongo mihahu na tsano na magana mane. ");
INSERT INTO dig_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Alume osi kula chivyazi cha Dani ariokala akafisa miaka mirongo miiri na kpwenderera ambao kala anaweza kuphiya vihani, aandikpwa madzina chila mmwenga kulengana na miryango yao na nyumba zao. ");
INSERT INTO dig_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Jumula ya atu arioolangbwa kula mbari ya Dani kala ni elufu mirongo sita na mbiri na magana sabaa. ");
INSERT INTO dig_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Alume osi kula chivyazi cha Asheri a kuandzira miaka mirongo miiri na kpwenderera ambao kala anaweza kuphiya vihani, aandikpwa madzina chila mmwenga kulengana na miryango yao na nyumba zao. ");
INSERT INTO dig_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Jumula ya atu arioolangbwa kula mbari ya Asheri kala ni elufu mirongo mine na mwenga na magana matsano. ");
INSERT INTO dig_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Alume osi kula chivyazi cha Nafutali kuandzira miaka mirongo miiri na kpwenderera ambao kala anaweza kuphiya vihani, aandikpwa madzina chila mmwenga kulengana na miryango yao na nyumba zao. ");
INSERT INTO dig_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Jumula ya atu arioolangbwa kula mbari ya Nafutali kala ni elufu mirongo mitsano na tahu na magana mane. ");
INSERT INTO dig_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Hinya ndio hara atu arioolangbwa ni Musa na Aruni phamwenga na vilongozi kumi na airi a Iziraeli. Chila chilongozi kala anawakilisha nyumba ya mkarewe. ");
INSERT INTO dig_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Phahi jumula ya Aiziraeli osi oandikpwa kulengana na nyumba zao, a kuandzira miaka mirongo miiri na kpwenderera na ambao kala anaweza kuphiya vihani ");
INSERT INTO dig_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","kala ni atu elufu magana sita na tahu, magana matsano na mirongo mitsano. ");
INSERT INTO dig_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Ela Alawi taaolangirwe phamwenga na zira mbari zanjina, ");
INSERT INTO dig_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","kpwa sababu Mwenyezi Mlungu kala akamuamba Musa, ");
INSERT INTO dig_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Usiaandikishe atu a mbari ya Lawi wala kuaolanga phamwenga na Aiziraeli anjina. ");
INSERT INTO dig_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Badalaye aike Alawi akale aimirizi a hema ra ushaidi, miyoye yosi na vyosi virivyo himo. Aho andahala hiro hema na miyoye yosi, andaritundza nao andachita kambi kuzunguluka ro hema. ");
INSERT INTO dig_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Wakati wa hema kungʼolwa uchifika, Alawi ndio ambao andaringʼola na wakati wa hema kuchitwa aho Alawi ndio ambao andarichita. Mutu yeyesi wanjina ndiyesengera phephi na ro hema andaolagbwa. ");
INSERT INTO dig_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Nyo Aiziraeli anjina osi andachita kambi zao madiba-madiba, chila mutu na kundire na tsini ya benderaye. ");
INSERT INTO dig_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Ela Alawi andachita mahema gao kuzunguluka hema ra ushaidi, ili kuririnda sedze mutu akarisengerera na kuhenda niatsukirirwe sana atu osi a Iziraeli.” ");
INSERT INTO dig_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Phahi atu a Iziraeli ahenda chila chitu ambacho Mwenyezi Mlungu kala akamlagiza Musa. ");
INSERT INTO dig_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Mwenyezi Mlungu wagomba na Musa na Aruni achiamba: ");
INSERT INTO dig_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Aiziraeli andachita kambi zao, tsini ya bendera ya makundi gao na chila mbari hipho kundini, tsini ya benderaye. Andachita kambi hatuwa chache kuzunguluka hema ra mkpwutano. ");
INSERT INTO dig_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Hara ambao andachita kambi tsini ya bendera yao uphande wa mlairo wa dzuwa andakala ni makundi ga kambi ya Juda. Chilongozi wa atu a mbari ya Juda andakala ni Nashoni mwana wa Aminadabu. ");
INSERT INTO dig_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Jumula ya alume a mbari ya Juda arioandikpwa ni elufu mirongo sabaa na ne na magana sita. ");
INSERT INTO dig_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Hara ndiolungizira kuchita kambi phephi nao ni mbari ya Isakari na chilongozi wao andakala ni Nethaneli mwana wa Suari. ");
INSERT INTO dig_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Jumula ya alume a mbari ya Isakari arioandikpwa ni elufu mirongo mitsano na ne na magana mane. ");
INSERT INTO dig_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Chisha andalungirwa ni mbari ya Zabuloni na chilongozi wao andakala ni Eliabu mwana wa Heloni. ");
INSERT INTO dig_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Jumula ya alume a mbari ya Zabuloni arioandikpwa ni atu elufu mirongo mitsano na sabaa na magana mane. ");
INSERT INTO dig_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Jumula ya atu osi arioolangbwa kula kambi ya Juda kulengana na makundi gao ni elufu gana mwenga na mirongo mihahu na sita na magana mane. Makundi higa ndigo ndigokala ga kpwandza kuuka chila wakati wa kuvundza kambi. ");
INSERT INTO dig_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Uphande wa mwakani kundakala na makundi ga kambi ya Rubini tsini ya bendera yao. Chilongozi wa mbari ya Rubini andakala Elisuri mwana wa Shedeuri. ");
INSERT INTO dig_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Jumula ya alume a mbari ya Rubini arioandikpwa ni atu elufu mirongo mine na sita na magana matsano. ");
INSERT INTO dig_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Atu a mbari ya Simioni andachita kambi phephi na atu a Rubini na chilongozi wao andakala ni Shelumieli mwana wa Surishadai. ");
INSERT INTO dig_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Jumula ya alume a mbari ya Simioni arioandikpwa ni atu elufu mirongo mitsano na tisiya na magana mahahu. ");
INSERT INTO dig_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Chisha mbari ya Gadi ambayo indalongozwa ni Eliasafu mwana wa Deueli, ");
INSERT INTO dig_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","naye kundire kala rina alume arioandikpwa elufu mirongo mine na tsano na magana sita na mirongo mitsano. ");
INSERT INTO dig_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Jumula ya atu osi arioolangbwa kula kambi ya Rubini kulengana na makundi gao ni atu elufu gana mwenga mirongo mitsano na mwenga, magana mane na mirongo mitsano. Makundi higa ndigo ndigokala ga phiri kuuka chila wakati wa kuvundza kambi. ");
INSERT INTO dig_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Nyo atu andauka kulengana na vyo arivyochita kambi zao. Wakati wa kuvundza kambi, atu a kambi ya Lawi andakala kahi-kahi ya zo kambi, mbiri mbere mbiri nyuma kuno akatsukula hema ra mkpwutano. ");
INSERT INTO dig_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Uphande wa mtswerero wa dzuwa kundakala ni makundi ga kambi ya Efuraimu tsini ya bendera yao. Chilongozi wa mbari ya Efuraimu andakala Elishama mwana wa Amihudi ");
INSERT INTO dig_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","na jumula ya alume osi arioandikpwa kula mbari hino ni atu elufu mirongo mine na magana matsano. ");
INSERT INTO dig_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Nao andalungirwa ni mbari ya Manase ambayo chilongozi wao andakala Gamalieli mwana wa Pedasuri ");
INSERT INTO dig_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","na jumula ya alume osi arioandikpwa kula mbari hino ni elufu mirongo mihahu na mbiri na magana mairi. ");
INSERT INTO dig_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Aho andalungirwa ni mbari ya Benjamini ambao chilongozi wao ni Abidani mwana wa Gidioni. ");
INSERT INTO dig_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Jumula ya alume osi arioandikpwa kula mbari hino ni elufu mirongo mihahu na tsano na magana mane. ");
INSERT INTO dig_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Jumula ya atu osi arioolangbwa kula kambi ya Efuraimu na makundi gao ni elufu gana mwenga na nane na gana. Hinya andakala kpwenye kundi ra hahu kuuka. ");
INSERT INTO dig_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Uphande wa vurini kundakala na makundi ga kambi ya Dani tsini ya bendera yao. Chilongozi wa mbari ya Dani andakala Ahiezeri mwana wa Amishadai ");
INSERT INTO dig_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","na jumula ya alume osi arioandikpwa kula mbari hino ni elufu mirongo sita na mbiri na magana sabaa. ");
INSERT INTO dig_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Nao alungirwa ni atu a mbari ya Asheri ambao chilongozi wao ni Pagieli mwana wa Okirani. ");
INSERT INTO dig_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Na jumula ya alume arioandikpwa kula mbari hino ni elufu mirongo mine na mwenga na magana matsano. ");
INSERT INTO dig_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Chisha andalungirwa ni mbari ya Nafutali ambayo chilongoziwe ni Ahira mwana wa Enani. ");
INSERT INTO dig_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Jumula ya alume arioandikpwa kula mbari hino ni elufu mirongo mitsano na tahu na magana mane. ");
INSERT INTO dig_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Jumula ya alume arioandikpwa kula kambi ya Dani ni elufu gana mwenga na mirongo mitsano na sabaa na magana sita. Hinya andakala kundi ra mwisho kuuka tsini ya bendera yao. ");
INSERT INTO dig_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Jumula ya Aiziraeli osi okala kpwenye kambi zao kulengana na nyumba zao na makundi gao kala ni elufu magana sita na tahu na magana matsano na mirongo mitsano. ");
INSERT INTO dig_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Ela atu kula mbari ya Lawi taayaolangbwa phamwenga na Aiziraeli anjina dza Mwenyezi Mlungu arivyomlagiza Musa. ");
INSERT INTO dig_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Kpwa hivyo Aiziraeli ahenda dza Mwenyezi Mlungu arivyokala akamlagiza Musa. Hivyo ndivyo arivyochita kambi tsini ya bendera zao na achisafiri chila mmwenga na atu a mryangowe na atu a nyumbaye. ");
INSERT INTO dig_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Hichi ndicho chivyazi cha Aruni na Musa wakati Mwenyezi Mlungu ariphogomba na Musa hiko Mwango Sinai. ");
INSERT INTO dig_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Higa ndigo madzina ga ana a chilume a Aruni: Nadabu yekala mwana mvyere, Abihu, Eliazari na Ithamari. ");
INSERT INTO dig_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Aha ndio ana a Aruni ariomwagirwa mafuha na achitengbwa akale alavyadzi-sadaka. ");
INSERT INTO dig_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Ela Nadabu na Abihu aolagbwa ariphoreha moho uriokahazwa mbere za Mwenyezi Mlungu hiko jangbwa ra Sinai. Akala bado taadzangbwephaha ana ndipho Eliazari na Ithamari achihumika dza alavyadzi-sadaka wakati wosi ise yao Aruni ariphokala achere moyo. ");
INSERT INTO dig_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Mwenyezi Mlungu achigomba na Musa achimuamba, ");
INSERT INTO dig_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Arehe nyo atu a mbari ya Lawi na uahende aime phephi na mlavyadzi-sadaka Aruni ili amuhumikire. ");
INSERT INTO dig_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Andahenda kazi kpwa niaba ya Aruni na Aiziraeli osi mbere za hema ra mkpwutano kuno anahumika hipho Phatu Phatakatifu. ");
INSERT INTO dig_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Andakala aimirizi a vitu vyosi vya hema ra mkpwutano na andaahendera kazi Aiziraeli osi kuno anahumika hipho Phatu Phatakatifu. ");
INSERT INTO dig_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Undaika Alawi amuhumikire Aruni na anae, kpwa kukala atu aha atengbwa kula kpwa Aiziraeli osi aahumikire. ");
INSERT INTO dig_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Chisha undaaika Aruni na anae ahende kazi za ulavyadzi-sadaka, ela mutu wanjina yeyesi ndiye jeza kuhenda zo kazi za ulavyadzi-sadaka, au kusengera pho phatu phatakatifu ni aolagbwe.” ");
INSERT INTO dig_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Chisha Mwenyezi Mlungu achigomba na Musa achiamba, ");
INSERT INTO dig_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Lola, nikadzitengera Alawi kula kpwa Aiziraeli osi badala ya chila mwana wa kpwandza mlume ndiyevyalwa kahi ya Aiziraeli. Nyo Alawi andakala angu, ");
INSERT INTO dig_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","mana avyalwa osi a mwandzo ni angu. Niriphoolaga avyalwa osi a mwandzo hiko Misiri, nadzitengera avyalwa osi a mwandzo a Iziraeli, kula kpwa anadamu hadi nyama. Osi andakala angu. Mimi, ndimi Mwenyezi Mlungu.” ");
INSERT INTO dig_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Ndipho Mwenyezi Mlungu achigomba na Musa hiko jangbwa ra Sinai achiamba, ");
INSERT INTO dig_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Aandikishe Alawi osi kulengana na nyumba zao na miryango yao. Undaandikisha chila mwana mlume wa umuri wa mwezi mmwenga na kpwenderera.” ");
INSERT INTO dig_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Phahi Musa waandikisha kulengana na neno ra Mwenyezi Mlungu, dza arivyolagizwa. ");
INSERT INTO dig_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Higa ni madzina ga ana a chilume a Lawi: Gerishoni, Kohathi na Merari. ");
INSERT INTO dig_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Ana a chilume a Gerishoni kulengana na miryango yao kala ni Libuni na Shimei. ");
INSERT INTO dig_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Ana a chilume a Kohathi kulengana na miryango yao kala ni Amuramu, Ishari, Heburoni na Uzieli. ");
INSERT INTO dig_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Ana a chilume a Merari kulengana na miryango yao kala ni Mahili na Mushi. Hino ndiyo miryango ya Alawi kulengana na nyumba zao. ");
INSERT INTO dig_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Kpwakala na mryango wa atu a Libuni na wa atu a Shimei kula kpwa Gerishoni, ");
INSERT INTO dig_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","na jumula ya alume osi a umuri wa mwezi mmwenga na kpwenderera kala ni elufu sabaa na magana matsano. ");
INSERT INTO dig_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Atu aha a miryango ya Gerishoni kala ni achite kambi uphande wa mtswerero wa dzuwa, ndzingo ya hema ra mkpwutano, ");
INSERT INTO dig_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","na chilongozi wao kala ni Eliasafu mwana wa Laeli. ");
INSERT INTO dig_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Kazi yao pho hemani kala ni kumanyirira ro hema, vyandaruwavye, paziya ya mryango wa ro hema ra mkpwutano, ");
INSERT INTO dig_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","paziya za muhala, paziya za phatu pha kumenyera uwani ambazo zikazunguluka hema na phatu pha kulavira sadaka, kowa na vyosi virivyolondwa kpwa kazi za hipho. ");
INSERT INTO dig_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Kohathi wakala na miryango mine ambayo ni mryango wa Amuramu, wa Ishari, wa Heburoni na wa Uzieli. ");
INSERT INTO dig_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Jumula ya alume osi, a umuri wa mwezi mmwenga na kpwenderera kala ni atu elufu nane na magana sita. Akohathi kazi yao kala ni kumanyirira pho Phatu Phatakatifu. ");
INSERT INTO dig_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Hinyo atu a mryango wa Kohathi kala ni achite kambi uphande wa mwakani wa ro hema ra mkpwutano, ");
INSERT INTO dig_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","naye Elizafani mwana wa Uzieli achikala ndiye chilongozi wa miryango ya atu a Kohathi. ");
INSERT INTO dig_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Kazi yao kala ni kuimirira ro sanduku ra chilagane, meza, chinara cha kuikira taa, mwatu mwa kulavira sadaka, miyo ya phatu phatakatifu ambayo nkuhumirwa ni alavyadzi-sadaka, paziya na kazi zanjina zosi zihusuzo mahumizi ga vitu hivi. ");
INSERT INTO dig_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Eliazari mwana wa mlavyadzi-sadaka Aruni kala ndiye chilongozi wa Alawi osi, naye kala ni muimirizi wa ahendadzi-kazi osi a pho Phatu Phatakatifu. ");
INSERT INTO dig_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Kpwakala na miryango miiri kula kpwa Merari ambayo ni mryango wa Mahili na wa Mushi. ");
INSERT INTO dig_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Jumula ya alume osi a umuri wa mwezi mmwenga na kpwenderera kala ni atu elufu sita na magana mairi. ");
INSERT INTO dig_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Chilongozi wa mryango wa Merari kala ni Surieli mwana wa Abihaili, nao kala ni achite kambi uphande wa vurini wa ro hema. ");
INSERT INTO dig_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Atu a mryango wa Merari aikpwa aimirire mimo ya hema, mgamba, milingoti, seemu za koloni na miyoye yosi ya kugbwiririra ro hema nao kala achihenda kazi zosi zohusu vyo vitu. ");
INSERT INTO dig_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Piya kala ni aimirire vyatsi vya uwa vyozunguluka muhala na seemuze za koloni, vigingivye vya kuchitira na kowaze. ");
INSERT INTO dig_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Musa, Aruni na anae kala ni achite kambi mbere za hema ra mkpwutano uphande wa mlairo wa dzuwa. Kazi yao kala ni kuahendera Aiziraeli kazi zosi za pho Phatu Phatakatifu. Mutu wanjina yeyesi ambaye wasengerera phatu hipho kala ni aolagbwe. ");
INSERT INTO dig_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Jumula ya Alawi osi arioandikpwa kulengana na miryango yao, alume osi a kuandzira umuri wa mwezi mmwenga kpwenderera ambao Musa na Aruni aaolanga kpwa lagizo ra Mwenyezi Mlungu kala ni atu elufu mirongo miiri na mbiri. ");
INSERT INTO dig_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Chisha Mwenyezi Mlungu achigomba na Musa achiamba, “Andikisha ana osi a kpwandza a chilume a Aiziraeli a umuri wa mwezi mmwenga na kpwenderera na uaolange. ");
INSERT INTO dig_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Undanitengera Alawi badala ya avyalwa osi a kpwandza kahi ya Aiziraeli, piya undanitengera nyama osi a Alawi badala ya avyalwa osi a kpwandza a mifugo ya Aiziraeli. Mimi, ndimi Mwenyezi Mlungu.” ");
INSERT INTO dig_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Kpwa hivyo Musa waandikisha avyalwa osi a kpwandza kahi ya Aiziraeli dza arivyolagizwa ni Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Jumula ya avyalwa osi a kpwandza a chilume a umuri wa mwezi mmwenga kpwenderera arioandikpwa kulengana na madzina gao kala ni elufu mirongo miiri na mbiri magana mairi na mirongo sabaa na tahu. ");
INSERT INTO dig_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Chisha Mwenyezi Mlungu achigomba na Musa achimuamba, ");
INSERT INTO dig_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Sambi, atenge Alawi akale angu badala ya avyalwa osi a kpwandza kahi ya Aiziraeli, piya atenge mifugo ya Alawi badala ya avyalwa osi a kpwandza a mifugo ya Aiziraeli, nao Alawi andakala angu. Mimi, ndimi Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Kpwa kukala jumula ya avyalwa a kpwandza a chilume a Iziraeli ikatsupa isabu ya Alawi na atu magana mairi na mirongo sabaa na tahu, ni lazima ugule hinyo achiozidi. ");
INSERT INTO dig_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Kpwa chila mmwenga wao waripha vipande vitsano vya feza kulengana na chipimo cha pho Phatu Phatakatifu (ambayo chipande chimwenga cha feza ni sawa na gera mirongo miiri), ");
INSERT INTO dig_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","na umuphe Aruni na anae a chilume hizo feza chizohumirwa kuakombola hara avyalwa a kpwandza a chilume a Iziraeli achiotsupa isabu ya Alawi.” ");
INSERT INTO dig_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Phahi Musa wahala zo feza zokala zikalaviwa ili kukombola hara avyalwa a kpwandza a chilume a Iziraeli achiotsupa isabu ya Alawi. ");
INSERT INTO dig_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Wahala vipande elufu mwenga magana mahahu na mirongo sita na tsano vya feza kulengana na chipimo cha Phatu Phatakatifu kula kpwa avyalwa a kpwandza a Iziraeli. ");
INSERT INTO dig_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Naye Musa wamupha Aruni na anae zo feza kulengana na Mwenyezi Mlungu arivyomlagiza. ");
INSERT INTO dig_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Mwenyezi Mlungu wagomba na Musa na Aruni achiaambira, ");
INSERT INTO dig_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Olanga atu a mryango wa Kohathi kula mbari ya Lawi kulengana na miryango yao na nyumba zao. ");
INSERT INTO dig_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Olanga alume osi a kuandzira miaka mirongo mihahu hadi mirongo mitsano, osi ambao anaweza kuhenda kazi ndani ya hema ra mkpwutano. ");
INSERT INTO dig_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Kazi ya atu a mryango wa Kohathi kpwenye hema ra mkpwutano indakala kutsukula miyo mitakatifu zaidi. ");
INSERT INTO dig_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Wakati wa atu kuuka uchifika, Aruni na anae andamenya mo ndani ya hema ra mkpwutano, ause yo paziya iriyo mbere ya sanduku ra chilagane na aibwiningizire ro sanduku. ");
INSERT INTO dig_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Chisha dzuluye andarilingalinga na chingo ya nyama wa pwani aihwaye pomboo na ahandike nguwo ya rangi ya buluu ndipho atiye migongoye ya kutsukurira. ");
INSERT INTO dig_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Andahandika nguwo ya rangi ya buluu dzulu ya meza ya kulavira sadaka ya mikahe na dzuluye aike sahani, miyo ya uvumba, vibakuli na tupa za sadaka ya chinwadzi. Chila siku phandakala na mkpwahe pho dzulu ya meza. ");
INSERT INTO dig_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Chisha andahandika nguwo ya kundu dzulu ya hivi vyosi, na kubwiningiza chingo ya pomboo, na atiye migongoye ya kutsukurira. ");
INSERT INTO dig_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Andahala nguwo ya buluu na abwiningize chinara cha kuikira taa na taaze, makasige, visahanivye na miyoye yosi ya kutiira mafuha. ");
INSERT INTO dig_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Chisha andachilingalinga phamwenga na miyoye yosi kahi ya chingo ya pomboo na achiike dzulu-dzulu ya machela ya mihi ya kutsukurira. ");
INSERT INTO dig_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Halafu andahandika nguwo ya buluu dzulu ya phatu pha kufukizira uvumba pha zahabu, na aphabwiningize chingo ya pomboo na atiye migongoye ya kutsukurira. ");
INSERT INTO dig_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“Andahala miyo yosi ihumirwayo pho Phatu Phatakatifu na ailingelinge na nguwo ya buluu na kuibwiningiza na chingo ya pomboo na ayiike dzulu-dzulu ya migongo ya kutsukurira. ");
INSERT INTO dig_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“Andausa ivu kula pho phatu pha kulavira sadaka na aphabwiningize na nguwo ya zambarau. ");
INSERT INTO dig_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Dzuluye andaika miyo yosi ihumikayo phatu pha kulavira sadaka ambayo ni vyetezo, uma za kudungira nyama, miko na mabeseni. Chisha andabwiningiza chingo ya pomboo na atiye migongoye ya kutsukurira. ");
INSERT INTO dig_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“Wakati Aruni na anae ndiphomarigiza kubwiningiza miyo yosi mitakatifu, mibaha na midide na atu ndiphokala tayari kuuka, atu a mryango wa Kohathi andakpwedza aitsukule yo miyo ya hema ra mkpwutano. Ela taaruhusiwa kuiguta, mana yo miyo ni mitakatifu, na achiiguta andafwa. ");
INSERT INTO dig_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Eliazari mwana wa mlavyadzi-sadaka Aruni andaimirira mafuha ga taa, uvumba, sadaka za mtsere zolaviwa chila siku na mafuha ga utakaso. Iye ni aimirire hema na vitu vyosi virivyo mumo phamwenga na vitu vitakatifu.” ");
INSERT INTO dig_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Chisha Mwenyezi Mlungu achigomba na Musa na Aruni achiamba, ");
INSERT INTO dig_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Musiriche atu a mryango wa Kohathi kahi za mbari ya Lawi aangamizwe. ");
INSERT INTO dig_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Aruni na anae ni ainjire mo ndani na aapangire chila mmwenga kaziye na mzigowe. Ahendereni hivi kpwa asifwe ndiphosengerera vyo vitu vitakatifu zaidi. ");
INSERT INTO dig_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Ela atu a mryango wa Kohathi naasiinjire kpwendalola vyo vitu vitakatifu hata chidide sedze akafwa.” ");
INSERT INTO dig_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Chisha Mwenyezi Mlungu achigomba na Musa achimuamba, ");
INSERT INTO dig_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Hala isabu ya atu a mryango wa Gerishoni piya, kula nyumba zao na miryango yao. ");
INSERT INTO dig_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Undaolanga atu osi a miaka mirongo mihahu hadi mirongo mitsano ambao anaweza kuhenda kazi kahi ya hema ra mkpwutano. ");
INSERT INTO dig_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Hino ndiyo kazi ya atu a mryango wa Gerishoni, kuhumika na kutsukula mizigo. ");
INSERT INTO dig_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Andatsukula ro hema ra mkpwutano; vyandaruwavye vya ndani, chandaruwache cha kondze cha chingo ya pomboo na paziya za mryangowe. ");
INSERT INTO dig_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","Piya ni atsukule nguwo za kuzibira uwa na kowaze, paziya ya phatu pha kuinjirira nyo uwa uriozunguluka ro hema na pho phatu pha kulavira sadaka na miyo yosi ndiyohumika kpwenye utumishi wao, nao andahenda mambo gosi ambago ni agahende. ");
INSERT INTO dig_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Aruni na anae ndio ndiolagiza kazi zosi za atu a mryango wa Gerishoni kuhusu vitu ndivyotsukula na kazi ndizohenda. Aho andaapangira vitu vyosi ambavyo ni atsukule. ");
INSERT INTO dig_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Hino ndiyo kazi ya atu a mryango wa Gerishoni kahi ya hema ra mkpwutano, na andakala tsini ya uimirizi wa Ithamari, mwana wa mlavyadzi-sadaka Aruni.” ");
INSERT INTO dig_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Mwenyezi Mlungu waenderera kugomba na Musa achimuamba, “Hala isabu ya atu a mryango wa Merari kulengana na miryango yao na nyumba zao, ");
INSERT INTO dig_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","nawe undaandikisha atu osi a kuandzira miaka mirongo mihahu hadi miaka mirongo mitsano, osi awezao kuhenda kazi za hema ra mkpwutano. ");
INSERT INTO dig_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Kahi za hema ra mkpwutano, kazi yao indakala kutsukula mimo ya ro hema phamwenga na maphaluge, milingotiye na seemuze za koloni. ");
INSERT INTO dig_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","Piya andatsukula vyatsi vya kuzunguluka muhala phamwenga na seemuze za koloni, vigingivye vya kuchitira, kowaze na miyoye yosi na chila chitu chihumirwacho mumo. Nawe undaapangira vitu ndivyotsukula chila mutu kulengana na dzinare. ");
INSERT INTO dig_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Hino ndiyo kazi ya atu a mryango wa Merari kahi ya hema ra mkpwutano tsini ya ulongozi wa Ithamari, mwana wa mlavyadzi-sadaka Aruni.” ");
INSERT INTO dig_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Phahi Musa, Aruni na vilongozi a Aiziraeli, aandikisha atu a mryango wa Kohathi kulengana na miryango yao na nyumba zao, ");
INSERT INTO dig_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","kuandzira miaka mirongo mihahu hadi miaka mirongo mitsano, osi awezao kuhenda kazi za ndani ya hema ra mkpwutano. ");
INSERT INTO dig_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Jumula ya Alawi arioandikpwa kulengana na miryango yao kala ni atu elufu mbiri magana sabaa na mirongo mitsano. ");
INSERT INTO dig_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Hino ndiyo jumula yosi ya atu a miryango ya Kohathi ariohenda kazi kpwenye hema ra mkpwutano ambao aandikpwa ni Musa na Aruni kulengana na lagizo ra Mwenyezi Mlungu, kutsupira Musa. ");
INSERT INTO dig_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Isabu ya atu a mryango wa Gerishoni, kulengana na miryango yao na nyumba zao, ");
INSERT INTO dig_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","kuandzira miaka mirongo mihahu hadi miaka mirongo mitsano, osi awezao kuhenda kazi za ro hema ra mkpwutano. ");
INSERT INTO dig_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Osi kulengana na miryango yao na nyumba zao kala ni atu elufu mbiri magana sita na mirongo mihahu. ");
INSERT INTO dig_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Hino ndiyo yokala isabu ya atu a mryango wa Gerishoni, osi ariohenda kazi kpwenye hema ra mkpwutano ambao Musa na Aruni aandikisha kulengana na lagizo ra Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Isabu ya atu a mryango wa Merari, kulengana na miryango yao na nyumba zao, ");
INSERT INTO dig_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","kuandzira miaka mirongo mihahu hadi miaka mirongo mitsano, osi awezao kuhenda kazi za ro hema ra mkpwutano ");
INSERT INTO dig_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","kala ni atu elufu tahu na magana mairi. ");
INSERT INTO dig_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Hino ndiyo jumula ya atu a mryango wa Merari, ambao Musa na Aruni aandikisha kulengana na lagizo ra Mwenyezi Mlungu kutsupira Musa. ");
INSERT INTO dig_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Phahi, Alawi osi arioolangbwa ni Musa, Aruni na vilongozi a Iziraeli kulengana na miryango yao na nyumba zao, ");
INSERT INTO dig_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","kuandzira miaka mirongo mihahu hadi miaka mirongo mitsano, chila mmwenga ariyekala ana uwezo wa kuhenda kazi ya utumishi na kutsukula ro hema ra mkpwutano rinaphovugulwa na miyoye yosi, ");
INSERT INTO dig_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","kala ni atu elufu nane magana matsano na mirongo minane. ");
INSERT INTO dig_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Kulengana na lagizo ra Mwenyezi Mlungu kutsupira Musa, chila mutu wahewa kaziye ya kuhumika ama kutsukula mizigo. Kpwa hivyo, chila mmwenga waandikpwa dza Mwenyezi Mlungu arivyomlagiza Musa. ");
INSERT INTO dig_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Mwenyezi Mlungu wagomba na Musa achiamba, ");
INSERT INTO dig_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Aamuru Aiziraeli atuluze kondze ya kambi chila mmwenga ariye na mahana, ama ukongo wa kutulukpwa ni madzi-madzi, na chila mutu ariye najisi kpwa kuguta lufu. ");
INSERT INTO dig_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Mundaatuluza kondze ya kambi atu osi alume kpwa achetu ario najisi ili asiitiye najisi kambi yao ambayo nasagala kahi yao.” ");
INSERT INTO dig_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Aiziraeli ahenda hivyo, achiatuluza kondze ya kambi dza vyo Mwenyezi Mlungu arivyomlagiza Musa. ");
INSERT INTO dig_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Mwenyezi Mlungu achigomba na Musa achimuamba, ");
INSERT INTO dig_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Aambire Aiziraeli kukala wakati mutu yeyesi, akale mlume hebu mchetu ndiphomkosera myawe na kpwa kuhenda hivyo asikale muaminifu kpwa Mwenyezi Mlungu, mutu hiye andakala na makosa ");
INSERT INTO dig_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","na ni akubali kukala wahenda dambi. Mutu hiye ni ariphire higo makosa chikamilifu na aenjereze seemu mwenga ya tsano ya higo maripho dzuluye, na amuphe ye mutu ariyemkosera. ");
INSERT INTO dig_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Ela ichikala ye mutu akafwa na kana mutu wa phephi ambaye anaweza kuhewa higo maripho, phahi maripho higo gandakala ga Mwenyezi Mlungu nago ni gahewe mlavyadzi-sadaka phamwenga na turume rinarohumirwa kpwenye upatanisho wa kumuusira dambi. ");
INSERT INTO dig_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Na tsona chila mtsango wa vitu vitakatifu ambavyo Aiziraeli andalavya kpwa Mwenyezi Mlungu vindakala vya mlavyadzi-sadaka ndiyeviphokera. ");
INSERT INTO dig_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Na chila chitu cha mutu chiricho chitakatifu chindakala chakpwe, ela chira ndichomupha mlavyadzi-sadaka chindakala cha mlavyadzi-sadaka.” ");
INSERT INTO dig_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Chisha Mwenyezi Mlungu achigomba na Musa achimuamba, ");
INSERT INTO dig_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Gomba na Aiziraeli na uaambire kukala, napho mkpwaza mutu akamkosera mlumewe kpwa kusakala muaminifu, ");
INSERT INTO dig_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","kpwa kulala na mlume wanjina bila mlumewe kumanya, dzagbwe takuna mutu amanyaye wala shaidi achiyemuona wakati anahenda dzambo hiro, andakala najisi vivyo. ");
INSERT INTO dig_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","Ye mlume achimenywa ni roho ya wivu na ashuku mchewe ariyedzitiya najisi, au mlume achimenywa ni roho ya wivu na ashuku mchewe ambaye kadzangbwedzitiya najisi, ");
INSERT INTO dig_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","iye mlume andamreha mchewe kpwa mlavyadzi-sadaka. Piya ni aphirike sadaka ya kilo mwenga ya unga wa shayiri, ela ni asiitiye mafuha wala ubani kpwa sababu ni sadaka ya mtsere ya wivu, sadaka ya kumanyisa kukala ye mchetu akahenda dambi au kahendere. ");
INSERT INTO dig_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“Chisha mlavyadzi-sadaka andamreha ye mchetu phephi, na aime mbere za Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Alafu ye mlavyadzi-sadaka andatiya madzi matakatifu ndani ya nyungu na ahale vumbi ra photsi mo ndani ya hema ra mkpwutano na aritiye mo madzini. ");
INSERT INTO dig_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Mlavyadzi-sadaka andamuika ye mchetu mbere za Mwenyezi Mlungu, amdimule nyereze na amuphe mikononi sadaka ya mtsere ya wivu ya kumanyisa napho ye mchetu akahenda dambi au kahendere. Mlavyadzi-sadaka naye andagbwiririra hura mwiyo urio na madzi ga utsungu garehago lana. ");
INSERT INTO dig_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Ndipho ye mlavyadzi-sadaka andamrisa chirapho ye mchetu amuambe, ‘Ichikala kularire na mlume wanjina, wala kugalukire ukadzitiya najisi wakati uchere kpwa mlumeo, kundazurika na lana irehwayo ni higa madzi ga utsungu. ");
INSERT INTO dig_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Ela ichikala wakosera wakati bado u tsini ya mlumeo, na uchidzitiya najisi na kulala na mlume wanjina,’ ");
INSERT INTO dig_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","hipha ye mlavyadzi-sadaka andamrisa chirapho ye mchetu cha yo lana, naye andamuambira ye mchetu, ‘Mwenyezi Mlungu na akutiye adabu hata ukale lana na tsukizo kahi ya atuo, ukale tasa na uchigbwira mimba imwagike. ");
INSERT INTO dig_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Madzi higa garehago lana na gakuinjire ndanini na gakuhende tasa na uchigbwira mimba imwagike.’ Chisha ye mchetu andajibu, ‘Amina, navikale vivyo.’ ");
INSERT INTO dig_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Chisha ye mlavyadzi-sadaka andaandika lana hizi kpwenye karatasi na kuzitsukutsa ndani ya madzi ga utsungu. ");
INSERT INTO dig_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Kabila amnwese hiye mchetu higo madzi ga utsungu garehago lana ambago gachimuinjira ndanini gandamrehera maumivu makali, ");
INSERT INTO dig_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","mlavyadzi-sadaka andahala hira sadaka ya wivu ya mtsere kula mikononi mwa ye mchetu, aunule dzulu mbere za Mwenyezi Mlungu na kuyiika phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Chisha mlavyadzi-sadaka andahala fumba mwenga ra iyo sadaka ya mtsere ili kuonyesa kukala sadaka yosi ni ya Mwenyezi Mlungu na aioche dzulu ya phatu pha kulavira sadaka. Mwishirowe andamnwesa ye mchetu higo madzi. ");
INSERT INTO dig_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Ndiphomuhenda anwe higo madzi, ichikala akadzitiya najisi na kayakala muaminifu kpwa mlumewe, madzi higo garehago lana gandamrehera maumivu makali sana gamuhende akale tasa na achigbwira mimba imwagike, naye andakala akalaniwa kahi ya atu a kpwao. ");
INSERT INTO dig_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Ela ichikala ye mchetu kayadzitiya najisi na kana hatiya, phahi andakala huru na anaweza kuphaha ana. ");
INSERT INTO dig_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Hino ndiyo shariya ya kesi za wivu, wakati mchetu achere na mlumewe ndiphohenda makosa na kudzitiya najisi ");
INSERT INTO dig_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ama wakati roho ya wivu ndiphomwedzera mlume, na akale na wivu na mchewe, phahi andamuimisa mchewe mbere za Mwenyezi Mlungu naye mlavyadzi-sadaka andamuhendera hino shariya yosi. ");
INSERT INTO dig_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Iye mlume kandaisabiwa kukala na makosa, ela ye mchetu andatsukula lawama ra dambiye napho ana makosa.” ");
INSERT INTO dig_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Mwenyezi Mlungu wagomba na Musa achimuamba, ");
INSERT INTO dig_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Gomba na Aiziraeli uaambire: Wakati mlume au mchetu andaika naziri malumu, naziri ya kutengbwa kpwa ajili ya Mwenyezi Mlungu, ");
INSERT INTO dig_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","phahi ni asinwe uchi wa aina yoyosi, ni asinwe digbwa ririrotengezwa na uchi wa aina yoyosi. Ni asinwe chinwadzi chochosi cha zabibu na asirye zabibu za kuivwa wala za kuuma. ");
INSERT INTO dig_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Muda wosi ndiokala akatengbwa ni asirye chitu chochosi kula kpwa zabibu, tembe wala makandage. ");
INSERT INTO dig_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Siku zosi za hatiye ya kudzitenga naasinyolwe; hadi sikuze za kudzitenga kpwa ajili ya Mwenyezi Mlungu zisire, ni akale mtakatifu na ariche nyereze zikule. ");
INSERT INTO dig_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Siku zosi ambazo andakala akadzitenga kpwa ajili ya Mwenyezi Mlungu ni asisengerere lufu. ");
INSERT INTO dig_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Hata napho chiyefwa ni ise, nine, nduguye mlume au mchetu, ni asidzitiye najisi kpwa kukala nyere ambazo ni ishara ya kudzitengakpwe kpwa ajili ya Mwenyezi Mlungu zichere mwakpwe chitswani. ");
INSERT INTO dig_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Siku zosi za kutengbwakpwe andakala mtakatifu kpwa Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Ichikala nyere za mutu achiyetengbwa zindatiywa najisi, mutu afwapho gafula phephi naye, phahi ni anyole chitswache siku ya kutakaswakpwe, yani siku ya sabaa. ");
INSERT INTO dig_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Alafu siku ya nane ni arehe njiya airi au ana njiya manga airi kpwa mlavyadzi-sadaka ariye phatu pha kumenyera hema ra mkpwutano. ");
INSERT INTO dig_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Mlavyadzi-sadaka andalavya mmwenga akale sadaka ya kuusa dambi na wanjina akale sadaka ya kuochwa na amuhendere upatanisho kpwa kukala wadzitiya najisi kpwa kukala phephi na lufu. Naye ni atakase tsona chitswache siku iyo-iyo. ");
INSERT INTO dig_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Ni atenge tsona sikuze za kudzitenga kpwa ajili ya Mwenyezi Mlungu, na ni arehe turume ra mwaka mmwenga dza sadaka ya kuusa makosa, ela siku za nyuma tazindaisabiwa kpwa sababu wakala najisi kpwa kuguta lufu wakati kala akatengbwa. ");
INSERT INTO dig_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“Napho muda wa mutu achiyetengbwa kpwa ajili ya Mwenyezi Mlungu ukasira, shariyaye ni hino: ni arehwe pho phatu pha kumenyera hema ra mkpwutano, ");
INSERT INTO dig_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","na andalavya sadakaze kpwa Mwenyezi Mlungu. Sadaka hizi ni turume ra mwaka mmwenga risiro na chirema kpwa ajili ya sadaka ya kuochwa, na mwati mmwenga wa mwaka mmwenga asiye na chirema kpwa ajili ya sadaka ya kuusa dambi, na turume mwenga risiro na chirema kpwa ajili ya sadaka ya amani, ");
INSERT INTO dig_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","phamwenga na chikaphu cha mikahe isiyotiywa hamira: mikahe ya unga mnono uriotsanganywa na mafuha na bisikuti zopakpwa mafuha. Piya andalavya sadaka zao za mtsere na sadaka zao za vinwadzi. ");
INSERT INTO dig_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Na mlavyadzi-sadaka andavireha mbere za Mwenyezi Mlungu na alavye iyo sadaka ya kuusa dambi na ya kuochwa, ");
INSERT INTO dig_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","chisha ni alavye hiro turume rikale sadaka ya amani kpwa Mwenyezi Mlungu, phamwenga na chikaphu cha mikahe isiyotiywa hamira, chisha andalavya sadaka ya mtsere na sadaka ya chinwadzi. ");
INSERT INTO dig_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Naye ariyetengbwa ni anyole chitswache pho phatu pha kumenyera hema ra mkpwutano, chisha ahale zo nyere azitiye mohoni, moho urio tsini ya sadaka ya amani. ");
INSERT INTO dig_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Ye mlavyadzi-sadaka andahala mkpwono wa turume uchiojitwa, na mkpwahe usiotiywa hamira kula kaphuni, na bisikuti mwenga na aviike mikononi mwa hiye ariyetengbwa bada ya kukala akanyola chitswache. ");
INSERT INTO dig_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Chisha mlavyadzi-sadaka andaviunula vikale sadaka ya kuunula mbere za Mwenyezi Mlungu, navyo ni vitakatifu na ni vya mlavyadzi-sadaka, phamwenga na laga na chiga cha turume ambacho ni cha mlavyadzi-sadaka kulengana na shariya. Chisha badaye ye ariyetengbwa anaweza kunwa uchi. ");
INSERT INTO dig_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“Hino ndiyo shariya ya mutu ariyetengbwa, iye ariyeika naziri kpwa Mwenyezi Mlungu kulengana na kutengbwakpwe. Mutu iye ni ause hatiye kulengana na shariya ya mutu ariyetengbwa, napho ana uwezo wa kulavya zaidi anaweza kulavya.” ");
INSERT INTO dig_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Mwenyezi Mlungu wagomba na Musa achimuamba, ");
INSERT INTO dig_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Gomba na Aruni na anae, ‘Uaambire, mundabariki Aiziraeli hivi, mundaambira, ");
INSERT INTO dig_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Mwenyezi Mlungu akubariki na akurinde, ");
INSERT INTO dig_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Mwenyezi Mlungu naakulole na mbazi, na akuhendere manono, ");
INSERT INTO dig_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Mwenyezi Mlungu akukubali, na akuphe amani. ");
INSERT INTO dig_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“ ‘Phahi chila wakati Aruni na anae ndiphoabariki Aiziraeli kpwa dzina rangu, nami nindaabariki.’ ” ");
INSERT INTO dig_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Yo siku Musa ariphomala kuriimisa ro hema na kurimwagira mafuha na kuritakasa phamwenga na miyoye yosi, na kumwagira mafuha na kutakasa pho phatu pha kulavira sadaka phamwenga na miyoye yosi, ");
INSERT INTO dig_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","vilongozi a Iziraeli, vilongozi a nyumba zao, vilongozi a mbari ambao kala ni aimirizi a hara ariotalwa, ");
INSERT INTO dig_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","areha sadaka zao mbere za Mwenyezi Mlungu. Sadaka hizi kala ni marukpwama sita garigobwiningizwa na ndewa kumi na mbiri za kugavweha, yani chila chilongozi ndewa mwenga-mwenga na rukpwama mwenga kpwa chila vilongozi airi. Nao avireha mbere za ro hema. ");
INSERT INTO dig_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Chisha Mwenyezi Mlungu achigomba na Musa achimuamba, ");
INSERT INTO dig_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Phokera sadaka hino ya marukpwama kula kpwao, ili gahumike kutsukurira hema ra mkpwutano, uaphe Alawi, chila mmwenga kulengana na kaziye.” ");
INSERT INTO dig_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Phahi Musa wahala gara marukpwama na ndewa na achiapha Alawi. ");
INSERT INTO dig_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Achiapha atu a mryango wa Gerishoni marukpwama mairi na ndewa ne, kulengana na kazi zao, ");
INSERT INTO dig_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","na achiapha atu a mryango wa Merari marukpwama mane na ndewa nane, kulengana na kazi zao. Aha osi chilongozi wao kala ni Ithamari mwana wa mlavyadzi-sadaka Aruni. ");
INSERT INTO dig_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Ela kaaphere chochosi atu a mryango wa Kohathi, kpwa sababu arichirwa kazi ya kuimirira miyo mitakatifu ambayo kala ni itsukulwe mafuzini. ");
INSERT INTO dig_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Chisha nyo vilongozi areha sadaka mbere ya phatu pha kulavira sadaka, siku hira phariphomwagirwa mafuha wakati phanatengbwa kpwa ajili ya Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Mwenyezi Mlungu achigomba na Musa achimuamba, “Chila chilongozi andakala na sikuye ya kureha sadakaye kpwa ajili ya kutenga phatu pha kulavira sadaka.” ");
INSERT INTO dig_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Phahi Nashoni mwana wa Aminadabu kula mbari ya Juda ndiye ariyereha sadakaze siku ya kpwandza. ");
INSERT INTO dig_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Sadakaze kala ni sahani mwenga ya feza yenye uziho wa kilo mwenga na nusu, bakuli mwenga ra feza renye uziho wa giramu magana manane kulengana na vipimo vya Phatu Phatakatifu. Yo miyo yosi miiri kala i tele unga mnono uriotsanganywa na mafuha kpwa ajili ya sadaka ya mtsere. ");
INSERT INTO dig_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Chisha achireha chikombe chimwenga cha zahabu chenye uziho wa giramu gana na kumi, chirichoodzala uvumba, ");
INSERT INTO dig_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","mwana ndzau mmwenga, turume mwenga, mwana turume mmwenga wa mwaka mmwenga kpwa ajili ya sadaka ya kuochwa, ");
INSERT INTO dig_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","ndenje mwenga ikale sadaka ya kuusa dambi, ");
INSERT INTO dig_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","ndzau mbiri, maturume matsano, ndenje tsano na ana turume atsano a mwaka mmwenga-mmwenga kpwa ajili ya sadaka ya amani. Hino ndiyo yokala sadaka ya Nashoni mwana wa Aminadabu. ");
INSERT INTO dig_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Siku ya phiri, Nethaneli mwana wa Suari, chilongozi wa mbari ya Isakari wareha sadakaze. ");
INSERT INTO dig_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Sadakaze kala ni sahani mwenga ya feza yenye uziho wa kilo mwenga na nusu, bakuli mwenga ra feza renye uziho wa giramu magana manane kulengana na vipimo vya Phatu Phatakatifu. Yo miyo yosi miiri kala i tele unga mnono uriotsanganywa na mafuha kpwa ajili ya sadaka ya mtsere. ");
INSERT INTO dig_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Chisha achireha chikombe chimwenga cha zahabu chenye uziho wa giramu gana na kumi, chirichoodzala uvumba, ");
INSERT INTO dig_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","mwana ndzau mmwenga, turume mwenga, mwana turume mmwenga wa mwaka mmwenga kpwa ajili ya sadaka ya kuochwa, ");
INSERT INTO dig_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","ndenje mwenga ikale sadaka ya kuusa dambi, ");
INSERT INTO dig_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","ndzau mbiri, maturume matsano, ndenje tsano na ana turume atsano a mwaka mmwenga-mmwenga kpwa ajili ya sadaka ya amani. Hino ndiyo yokala sadaka ya Nethaneli mwana wa Suari. ");
INSERT INTO dig_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Eliabu mwana wa Heloni, chilongozi wa mbari ya Zabuloni wareha sadakaze siku ya hahu. ");
INSERT INTO dig_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Sadakaze kala ni sahani mwenga ya feza yenye uziho wa kilo mwenga na nusu, bakuli mwenga ra feza renye uziho wa giramu magana manane kulengana na vipimo vya Phatu Phatakatifu. Yo miyo yosi miiri kala i tele unga mnono uriotsanganywa na mafuha kpwa ajili ya sadaka ya mtsere. ");
INSERT INTO dig_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","Chisha achireha chikombe chimwenga cha zahabu chenye uziho wa giramu gana na kumi, chirichoodzala uvumba, ");
INSERT INTO dig_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","mwana ndzau mmwenga, turume mwenga, mwana turume mmwenga wa mwaka mmwenga kpwa ajili ya sadaka ya kuochwa, ");
INSERT INTO dig_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","ndenje mwenga ikale sadaka ya kuusa dambi, ");
INSERT INTO dig_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","ndzau mbiri, maturume matsano, ndenje tsano na ana turume atsano a mwaka mmwenga-mmwenga kpwa ajili ya sadaka ya amani. Hino ndiyo yokala sadaka ya Eliabu mwana wa Heloni. ");
INSERT INTO dig_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Elisuri mwana wa Shedeuri, chilongozi wa mbari ya Rubini wareha sadakaze siku ya ne. ");
INSERT INTO dig_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Sadakaze kala ni sahani mwenga ya feza yenye uziho wa kilo mwenga na nusu, bakuli mwenga ra feza renye uziho wa giramu magana manane kulengana na vipimo vya Phatu Phatakatifu. Yo miyo yosi miiri kala i tele unga mnono uriotsanganywa na mafuha kpwa ajili ya sadaka ya mtsere. ");
INSERT INTO dig_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Chisha achireha chikombe chimwenga cha zahabu chenye uziho wa giramu gana na kumi, chirichoodzala uvumba, ");
INSERT INTO dig_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","mwana ndzau mmwenga, turume mwenga, mwana turume mmwenga wa mwaka mmwenga kpwa ajili ya sadaka ya kuochwa, ");
INSERT INTO dig_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","ndenje mwenga ikale sadaka ya kuusa dambi, ");
INSERT INTO dig_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","ndzau mbiri, maturume matsano, ndenje tsano na ana turume atsano a mwaka mmwenga-mmwenga kpwa ajili ya sadaka ya amani. Hino ndiyo yokala sadaka ya Elisuri mwana wa Shedeuri. ");
INSERT INTO dig_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Shelumieli mwana wa Surishadai, chilongozi wa mbari ya Simioni wareha sadakaze siku ya tsano. ");
INSERT INTO dig_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Sadakaze kala ni sahani mwenga ya feza yenye uziho wa kilo mwenga na nusu, bakuli mwenga ra feza renye uziho wa giramu magana manane kulengana na vipimo vya Phatu Phatakatifu. Yo miyo yosi miiri kala i tele unga mnono uriotsanganywa na mafuha kpwa ajili ya sadaka ya mtsere. ");
INSERT INTO dig_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Chisha achireha chikombe chimwenga cha zahabu chenye uziho wa giramu gana na kumi, chirichoodzala uvumba, ");
INSERT INTO dig_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","mwana ndzau mmwenga, turume mwenga, mwana turume mmwenga wa mwaka mmwenga kpwa ajili ya sadaka ya kuochwa, ");
INSERT INTO dig_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","ndenje mwenga ikale sadaka ya kuusa dambi, ");
INSERT INTO dig_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","ndzau mbiri, maturume matsano, ndenje tsano na ana turume atsano a mwaka mmwenga-mmwenga kpwa ajili ya sadaka ya amani. Hino ndiyo yokala sadaka ya Shelumieli mwana wa Surishadai. ");
INSERT INTO dig_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Eliasafu mwana wa Deueli, chilongozi wa mbari ya Gadi wareha sadakaze siku ya sita. ");
INSERT INTO dig_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Sadakaze kala ni sahani mwenga ya feza yenye uziho wa kilo mwenga na nusu, bakuli mwenga ra feza renye uziho wa giramu magana manane kulengana na vipimo vya Phatu Phatakatifu. Yo miyo yosi miiri kala i tele unga mnono uriotsanganywa na mafuha kpwa ajili ya sadaka ya mtsere. ");
INSERT INTO dig_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Chisha achireha chikombe chimwenga cha zahabu chenye uziho wa giramu gana na kumi, chirichoodzala uvumba, ");
INSERT INTO dig_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","mwana ndzau mmwenga, turume mwenga, mwana turume mmwenga wa mwaka mmwenga kpwa ajili ya sadaka ya kuochwa, ");
INSERT INTO dig_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","ndenje mwenga ikale sadaka ya kuusa dambi, ");
INSERT INTO dig_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","ndzau mbiri, maturume matsano, ndenje tsano na ana turume atsano a mwaka mmwenga-mmwenga kpwa ajili ya sadaka ya amani. Hino ndiyo yokala sadaka ya Eliasafu mwana wa Deueli. ");
INSERT INTO dig_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Elishama mwana wa Amihudi, chilongozi wa mbari ya Efuraimu wareha sadakaze siku ya sabaa. ");
INSERT INTO dig_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Sadakaze kala ni sahani mwenga ya feza yenye uziho wa kilo mwenga na nusu, bakuli mwenga ra feza renye uziho wa giramu magana manane kulengana na vipimo vya Phatu Phatakatifu. Yo miyo yosi miiri kala i tele unga mnono uriotsanganywa na mafuha kpwa ajili ya sadaka ya mtsere. ");
INSERT INTO dig_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Chisha achireha chikombe chimwenga cha zahabu chenye uziho wa giramu gana na kumi, chirichoodzala uvumba, ");
INSERT INTO dig_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","mwana ndzau mmwenga, turume mwenga, mwana turume mmwenga wa mwaka mmwenga kpwa ajili ya sadaka ya kuochwa, ");
INSERT INTO dig_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","ndenje mwenga ikale sadaka ya kuusa dambi, ");
INSERT INTO dig_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","ndzau mbiri, maturume matsano, ndenje tsano na ana turume atsano a mwaka mmwenga-mmwenga kpwa ajili ya sadaka ya amani. Hino ndiyo yokala sadaka ya Elishama mwana wa Amihudi. ");
INSERT INTO dig_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Gamalieli mwana wa Pedasuri, chilongozi wa mbari ya Manase wareha sadakaze siku ya nane. ");
INSERT INTO dig_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Sadakaze kala ni sahani mwenga ya feza yenye uziho wa kilo mwenga na nusu, bakuli mwenga ra feza renye uziho wa giramu magana manane kulengana na vipimo vya Phatu Phatakatifu. Yo miyo yosi miiri kala i tele unga mnono uriotsanganywa na mafuha kpwa ajili ya sadaka ya mtsere. ");
INSERT INTO dig_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","Chisha achireha chikombe chimwenga cha zahabu chenye uziho wa giramu gana na kumi, chirichoodzala uvumba, ");
INSERT INTO dig_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","mwana ndzau mmwenga, turume mwenga, mwana turume mmwenga wa mwaka mmwenga kpwa ajili ya sadaka ya kuochwa, ");
INSERT INTO dig_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","ndenje mwenga ikale sadaka ya kuusa dambi, ");
INSERT INTO dig_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","ndzau mbiri, maturume matsano, ndenje tsano na ana turume atsano a mwaka mmwenga-mmwenga kpwa ajili ya sadaka ya amani. Hino ndiyo yokala sadaka ya Gamalieli mwana wa Pedasuri. ");
INSERT INTO dig_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Abidani mwana wa Gidioni, chilongozi wa mbari ya Benjamini wareha sadakaze siku ya tisiya. ");
INSERT INTO dig_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Sadakaze kala ni sahani mwenga ya feza yenye uziho wa kilo mwenga na nusu, bakuli mwenga ra feza renye uziho wa giramu magana manane kulengana na vipimo vya Phatu Phatakatifu. Yo miyo yosi miiri kala i tele unga mnono uriotsanganywa na mafuha kpwa ajili ya sadaka ya mtsere. ");
INSERT INTO dig_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Chisha achireha chikombe chimwenga cha zahabu chenye uziho wa giramu gana na kumi, chirichoodzala uvumba, ");
INSERT INTO dig_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","mwana ndzau mmwenga, turume mwenga, mwana turume mmwenga wa mwaka mmwenga kpwa ajili ya sadaka ya kuochwa, ");
INSERT INTO dig_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","ndenje mwenga ikale sadaka ya kuusa dambi, ");
INSERT INTO dig_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","ndzau mbiri, maturume matsano, ndenje tsano na ana turume atsano a mwaka mmwenga-mmwenga kpwa ajili ya sadaka ya amani. Hino ndiyo yokala sadaka ya Abidani mwana wa Gidioni. ");
INSERT INTO dig_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Ahiezeri mwana wa Amishadai, chilongozi wa mbari ya Dani wareha sadakaze siku ya kumi. ");
INSERT INTO dig_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Sadakaze kala ni sahani mwenga ya feza yenye uziho wa kilo mwenga na nusu, bakuli mwenga ra feza renye uziho wa giramu magana manane kulengana na vipimo vya Phatu Phatakatifu. Yo miyo yosi miiri kala i tele unga mnono uriotsanganywa na mafuha kpwa ajili ya sadaka ya mtsere. ");
INSERT INTO dig_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","Chisha achireha chikombe chimwenga cha zahabu chenye uziho wa giramu gana na kumi, chirichoodzala uvumba, ");
INSERT INTO dig_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","mwana ndzau mmwenga, turume mwenga, mwana turume mmwenga wa mwaka mmwenga kpwa ajili ya sadaka ya kuochwa, ");
INSERT INTO dig_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","ndenje mwenga ikale sadaka ya kuusa dambi, ");
INSERT INTO dig_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","ndzau mbiri, maturume matsano, ndenje tsano na ana turume atsano a mwaka mmwenga-mmwenga kpwa ajili ya sadaka ya amani. Hino ndiyo yokala sadaka ya Ahiezeri mwana wa Amishadai. ");
INSERT INTO dig_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Pagieli mwana wa Okirani, chilongozi wa mbari ya Asheri wareha sadakaze siku ya kumi na mwenga. ");
INSERT INTO dig_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Sadakaze kala ni sahani mwenga ya feza yenye uziho wa kilo mwenga na nusu, bakuli mwenga ra feza renye uziho wa giramu magana manane kulengana na vipimo vya Phatu Phatakatifu. Yo miyo yosi miiri kala i tele unga mnono uriotsanganywa na mafuha kpwa ajili ya sadaka ya mtsere. ");
INSERT INTO dig_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","Chisha achireha chikombe chimwenga cha zahabu chenye uziho wa giramu gana na kumi, chirichoodzala uvumba, ");
INSERT INTO dig_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","mwana ndzau mmwenga, turume mwenga, mwana turume mmwenga wa mwaka mmwenga kpwa ajili ya sadaka ya kuochwa, ");
INSERT INTO dig_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","ndenje mwenga ikale sadaka ya kuusa dambi, ");
INSERT INTO dig_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","ndzau mbiri, maturume matsano, ndenje tsano na ana turume atsano a mwaka mmwenga-mmwenga kpwa ajili ya sadaka ya amani. Hino ndiyo yokala sadaka ya Pagieli mwana wa Okirani. ");
INSERT INTO dig_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Ahira mwana wa Enani, chilongozi wa mbari ya Nafutali wareha sadakaze siku ya kumi na mbiri. ");
INSERT INTO dig_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Sadakaze kala ni sahani mwenga ya feza yenye uziho wa kilo mwenga na nusu, bakuli mwenga ra feza renye uziho wa giramu magana manane kulengana na vipimo vya Phatu Phatakatifu. Yo miyo yosi miiri kala i tele unga mnono uriotsanganywa na mafuha kpwa ajili ya sadaka ya mtsere. ");
INSERT INTO dig_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","Chisha achireha chikombe chimwenga cha zahabu chenye uziho wa giramu gana na kumi, chirichoodzala uvumba, ");
INSERT INTO dig_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","mwana ndzau mmwenga, turume mwenga, mwana turume mmwenga wa mwaka mmwenga kpwa ajili ya sadaka ya kuochwa, ");
INSERT INTO dig_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","ndenje mwenga ikale sadaka ya kuusa dambi, ");
INSERT INTO dig_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","ndzau mbiri, maturume matsano, ndenje tsano na ana turume atsano a mwaka mmwenga-mmwenga kpwa ajili ya sadaka ya amani. Hino ndiyo yokala sadaka ya Ahira mwana wa Enani. ");
INSERT INTO dig_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Sadaka za vilongozi a Iziraeli kpwa ajili ya kutenga phatu pha kulavira sadaka wakati pho phatu phariphomwagirwa mafuha kala ni hizi: sahani kumi na mbiri za feza, mabakuli kumi na mairi ga feza, vikombe kumi na viiri vya zahabu, ");
INSERT INTO dig_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","chila sahani ya feza kala ina uziho wa kilo mwenga na nusu na chila bakuli uziho wa giramu magana manane. Uziho wa miyo yosi ya feza kala ni kama kilo mirongo miiri na nane hivi kulengana na vipimo vya Phatu Phatakatifu. ");
INSERT INTO dig_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Chila chikombe kahi ya vikombe kumi na viiri vya zahabu virivyokala vi tele uvumba kala china uziho wa giramu gana mwenga na kumi kulengana na vipimo vya Phatu Phatakatifu. Uziho wa vikombe vyosi vya zahabu kala ni giramu elufu mwenga magana mahahu na mirongo miiri. ");
INSERT INTO dig_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Nyama osi a sadaka ya kuochwa kala ni ndzau kumi na mbiri, maturume kumi na mbiri, ana turume kumi na airi a mwaka mmwenga-mmwenga, phamwenga na sadaka zao za mtsere, na ndenje kumi na mbiri za sadaka ya kuusa dambi. ");
INSERT INTO dig_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Nyama osi a sadaka ya amani kala ni ndzau mirongo miiri na ne, maturume mirongo sita, ndenje mirongo sita, ana turume mirongo sita a mwaka mmwenga-mmwenga. Hino yakala ni sadaka ya kutenga phatu pha kulavira sadaka bada ya pho phatu kumwagirwa mafuha. ");
INSERT INTO dig_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Musa ariphoinjira mo ndani ya hema ra mkpwutano kugomba na Mwenyezi Mlungu, wasikira sauti inagomba naye kula dzulu ya chihi cha mbazi chirichokala dzulu ya sanduku ra chilagane, kahi-kahi ya makerubi mairi. ");
INSERT INTO dig_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Mwenyezi Mlungu wagomba na Musa achimuamba, ");
INSERT INTO dig_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Gomba na Aruni na umuambire, ‘Ndiphoika zo taa sabaa, ni zingʼaze seemu iriyo mbere ya cho chinara cha kuikira taa.’ ” ");
INSERT INTO dig_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Aruni achihenda hivyo, achiika zo taa kpwa zingʼaze pho mbere ya chinara cha kuikira taa, dza Mwenyezi Mlungu arivyomlagiza Musa. ");
INSERT INTO dig_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Cho chinara cha kuikira taa chatengezwa hivi: Chatengezwa na zahabu yobandwa-bandwa, kula hakore hadi dzulu kpwenye maruwa. Chatengezwa kulengana na mfwano Mwenyezi Mlungu ariomuonyesa Musa. ");
INSERT INTO dig_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Chisha Mwenyezi Mlungu achigomba na Musa achimuamba, ");
INSERT INTO dig_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Hala Alawi kula kahi ya Aiziraeli na uatakase. ");
INSERT INTO dig_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Nawe undaahendera higa ili uatakase: atimvire-timvire go madzi ga utakaso, nao adzinyole na wembe mwiri wosi na afule nguwo zao, ndipho adzitakase. ");
INSERT INTO dig_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Chisha na ahale mwana ndzau na sadakaye ya mtsere ya unga mnono uriotsanganywa na mafuha, nawe undahala mwana ndzau wanjina kpwa ajili ya sadaka ya kuusa dambi. ");
INSERT INTO dig_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Undareha Alawi mbere za hema ra mkpwutano, na ukusanye Aiziraeli osi. ");
INSERT INTO dig_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Ndiphoareha Alawi mbere za Mwenyezi Mlungu, Aiziraeli ni aaikire mikono, ");
INSERT INTO dig_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","na Aruni andaareha Alawi mbere za Mwenyezi Mlungu dza sadaka ya kuunulwa kula kpwa Aiziraeli, ili aweze kuhenda kazi ya Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“Chisha nyo Alawi andabandika mikono yao dzulu ya vitswa vya zo ndzau, nawe undalavya mwenga ikale sadaka ya kuusa dambi na yanjina ikale sadaka ya kuochwa kpwa Mwenyezi Mlungu, ili kuahendera Alawi upatanisho. ");
INSERT INTO dig_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Chisha undaaika Alawi mbere ya Aruni na anae, nawe undaalavya dza sadaka ya kuunulwa kpwa Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Kpwa njira ihi, undaatenga Alawi kula kpwa Aiziraeli anjina, nao Alawi andakala angu. ");
INSERT INTO dig_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“Ndiphoatakasa Alawi na kualavya dza sadaka ya kuunulwa, aho ni edze na ahende kazi mo ndani ya hema ra mkpwutano. ");
INSERT INTO dig_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Kpwa kukala nkahewa aho akale angu kula kahi ya Aiziraeli, badala ya ana a kpwandza osi a Aiziraeli, mana nikahala avyalwa a kpwandza osi a chilume a Aiziraeli akale angu. ");
INSERT INTO dig_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Kpwa kukala avyalwa osi a kpwandza kahi ya Aiziraeli ni angu, akale a mwanadamu au a nyama. Náatenga kpwa ajili yangu wakati niriphoaolaga avyalwa osi a kpwandza a chilume kahi ya tsi ya Misiri. ");
INSERT INTO dig_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Nami nkahala Alawi badala ya avyalwa osi a kpwandza a chilume kahi ya Aiziraeli. ");
INSERT INTO dig_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Kula kahi ya Aiziraeli osi, nkamupha Aruni na anae nyo Alawi dza zawadi ili ahende kazi kahi ya hema ra mkpwutano, na kuahendera Aiziraeli upatanisho wa kuausira dambi ili kusikale na mashaka kahi yao ndiphophiya phephi na Phatu Phatakatifu.” ");
INSERT INTO dig_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Phahi Musa, Aruni na Aiziraeli osi phamwenga na Alawi ahenda dza Mwenyezi Mlungu arivyomlagiza Musa. ");
INSERT INTO dig_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Alawi adzitakasa na achifula nguwo zao. Chisha Aruni achialavya dza sadaka ya kuunulwa mbere za Mwenyezi Mlungu na achiausira dambi zao ili aatakase. ");
INSERT INTO dig_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","O Alawi ainjira na kuhumika kahi ya hema ra mkpwutano kuno akaimirirwa ni Aruni na anae. Aho ahenda gosi Mwenyezi Mlungu arigomlagiza Musa kuhusu Alawi. ");
INSERT INTO dig_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Chisha Mwenyezi Mlungu achigomba na Musa achimuamba, ");
INSERT INTO dig_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Hiri ndiro lagizo kuhusu nyo Alawi: Osi achiofisa umuri wa miaka mirongo miiri na mitsano na kpwenderera andaandza kuhumika kahi ya ro hema ra mkpwutano, ");
INSERT INTO dig_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","na kuandzira umuri wa miaka mirongo mitsano ni ariche kuhumika na asihende kazi tsona. ");
INSERT INTO dig_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Anaweza kuaterya ndugu zao kuhenda kazi zao kahi ya ro hema ra mkpwutano, ela aho enye ni asihende kazi. Phahi vivi ndivyo ndivyoapangira kazi nyo Alawi.” ");
INSERT INTO dig_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Kahi ya mwezi wa kpwandza wa mwaka wa phiri bada ya Aiziraeli kula tsi ya Misiri, Mwenyezi Mlungu wagomba na Musa kahi ya jangbwa ra Sinai achimuamba, ");
INSERT INTO dig_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Aambire Aiziraeli asherekee sikukuu ya Pasaka wakatiwe uriopangbwa. ");
INSERT INTO dig_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Isherekeeni wakatiwe uriopangbwa, yani dziloni wakati jiza rinahanda siku ya kumi na ne kulengana na shariyaze zosi na malagizoge gosi.” ");
INSERT INTO dig_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Phahi Musa achiaambira Aiziraeli asherekee sikukuu ya Pasaka. ");
INSERT INTO dig_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Nao achiisherekeya yo Pasaka dziloni wakati jiza rinahanda siku ya kumi na ne ya mwezi wa kpwandza ko jangbwa ra Sinai. Aiziraeli ahenda gosi dza viratu Mwenyezi Mlungu arivyomlagiza Musa. ");
INSERT INTO dig_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Ela kpwakala na atu fulani okala taaweza kusherekeya yo Pasaka siku iyo kpwa sababu kala akakala najisi kpwa kuguta lufu. Nao achiphiya mbere za Musa na Aruni, ");
INSERT INTO dig_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","na achendamuambira Musa, “Swiswi hukakala najisi kpwa kuguta lufu, ela ni kpwa utu wani hukahazwe kumlavira Mwenyezi Mlungu sadakaze kpwa wakati uriopangbwa kahi ya Aiziraeli?” ");
INSERT INTO dig_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Musa achiajibu achiamba, “Godzani hadi ndiphosikira Mwenyezi Mlungu ndigolagiza kukuhusuni.” ");
INSERT INTO dig_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Chisha Mwenyezi Mlungu achigomba na Musa achimuamba, ");
INSERT INTO dig_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Gomba na Aiziraeli uaambe: Mmwenga wenu ama wa chivyazi chenu ariye najisi kpwa kuguta lufu, ama napho a charoni anaweza kusherekeya Pasaka ya Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Ao andasherekeya dziloni wakati jiza rinahanda siku ya kumi na ne ya mwezi wa phiri. Nao andasherekeya kpwa kurya nyama ya mwana ngʼondzi, mkpwahe usiotiywa hamira na mtsunga wa utsungu. ");
INSERT INTO dig_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Ni asisaze chochosi hadi ligundzu, wala asivundze hata mfupha mmwenga. Ni ahende hivyo kulengana na shariya zosi za Pasaka. ");
INSERT INTO dig_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Ela mutu asiphosherekeya yo Pasaka na si najisi wala ka charoni, ni atengbwe na atue kpwa kukala kamlavirire Mwenyezi Mlungu sadaka wakatiwe uriopangbwa. Mutu hiye andatiywa adabu kpwa ajili ya dambiye. ");
INSERT INTO dig_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“Na hata ichikala kuna mjeni asagalaye phamwenga namwi ambaye angemendza kusherekeya Pasaka ya Mwenyezi Mlungu, ni ahende hivyo kulengana na shariya na malagizo ga Pasaka. Mosi ni mkale na shariya mwenga, akale ni mjeni au mwenyezi.” ");
INSERT INTO dig_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Siku hira hema ririphochitwa, rabwiningizwa ni ingu, yani ro hema ra ushaidi. Ro ingu rakala mfwano wa moho pho dzulu ya ro hema, hangu dziloni wakati jiza rinahanda hadi ligundzu. ");
INSERT INTO dig_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Phahi yakala hivi chila siku, ro hema rabwiningizwa ni ingu mutsi na usiku richibwiningizwa ni rira ingu ra mfwano wa moho. ");
INSERT INTO dig_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Chila wakati ro ingu ririphouka pho dzulu ya hema, Aiziraeli nao auka, na phatu ambapho ro ingu raima, nao Aiziraeli achita kambi phapho. ");
INSERT INTO dig_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Aiziraeli avundza kambi kpwa lagizo ra Mwenyezi Mlungu na kpwa lagizore, achita kambi. Aenderera kukala kambini wakati wosi ro ingu ririphokala dzulu ya ro hema. ");
INSERT INTO dig_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Ro ingu ririphobwiningiza ro hema kpwa muda wa siku nyinji, Aiziraeli aenderera kumtii Mwenyezi Mlungu, nao taaukire. ");
INSERT INTO dig_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Wakati wanjina ro ingu rabwiningiza ro hema kpwa muda mchache. Phahi atu aenderera kusala phapho kambini au kuuka kpwa lagizo ra Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Wakati wanjina ro ingu kala nkubwiningiza ro hema kula dziloni hadi ligundzu bahi, ririphouka, nyo atu nao kala nkuuka. Aho kala achiuka wakati wowosi ingu ririphouka, ikale usiku au mutsi. ");
INSERT INTO dig_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Muda wosi ro ingu kala richienderera kukala pho dzulu ya hema ikale siku mbiri, mwezi au mwaka, Aiziraeli asala kambini, taaukire bii. Ela auka tu wakati ro ingu ririphounuka dzulu. ");
INSERT INTO dig_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Kpwa lagizo ra Mwenyezi Mlungu achita kambi, na kpwa lagizo ra Mwenyezi Mlungu auka. Aho aenderera kulunga lagizo ambaro Mwenyezi Mlungu wamupha Musa. ");
INSERT INTO dig_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Mwenyezi Mlungu achigomba na Musa achimuamba, ");
INSERT INTO dig_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Hala feza uibande-bande na utengeze tarumbeta mbiri, ambazo undazihumira kuiha Aiziraeli osi phamwenga na kuvundza kambi. ");
INSERT INTO dig_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Tarumbeta zosi mbiri zichipigbwa chivyamwenga, atu osi andakusanyika mberezo pho phatu pha kumenyera hema ra mkpwutano. ");
INSERT INTO dig_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Ela ichipigbwa mwenga bahi, phahi vilongozi a mbari za Iziraeli, andakusanyika mberezo. ");
INSERT INTO dig_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Tarumbeta ndiphopigbwa mriro dza hura wa kuvundza kambi, mbari zirizochita kambi uphande wa mlairo wa dzuwa zindauka. ");
INSERT INTO dig_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Uchipiga tsona kano ya phiri, mbari zirizochita kambi uphande wa mwakani zindauka. Tarumbeta ichipigbwa tsona chila wakati ambapho atu ni avundze kambi. ");
INSERT INTO dig_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Ela ichikala ni atu akusanyike phamwenga, mundapiga zo tarumbeta mriro tafwauti na hura wa kuvundza kambi. ");
INSERT INTO dig_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“Tarumbeta hizo zindakala zichipigbwa ni ana a Aruni ario ni alavyadzi-sadaka. Hino indakala shariya kpwenu na vivyazi vyenu vyosi ta kare na kare. ");
INSERT INTO dig_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Mndiphokala vihani kahi ya tsi yenu kupigana na maadui genu, mundapiga mriro dza hura wa kuvundza kambi, kpwa hata mtambukirwe ni Mwenyezi Mlungu, Mlungu wenu na mtivywe kula kpwa maadui genu. ");
INSERT INTO dig_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Piya mundapiga zo tarumbeta wakati ndiphokala na raha, wakati wa sikukuu zenu zopangbwa na wakati wa kulumbwa kpwa mwezi. Mundapiga zo tarumbeta ndiphokala munalavya sadaka zenu za kuochwa na sadaka zenu za amani, nazo zindakala kpwenu ni ukumbusho mbere za Mwenyezi Mlungu. Mimi, ndimi Mwenyezi Mlungu, Mlungu wenu.” ");
INSERT INTO dig_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Kahi ya siku ya mirongo miiri ya mwezi wa phiri ya mwaka wa phiri, ro ingu raunuka pho dzulu ya hema ra ushaidi. ");
INSERT INTO dig_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Nao Aiziraeli achiuka kula jangbwa ra Sinai na achiphiya phatu hadi phatu, hadi ro ingu ririphoima ko jangbwa ra Parani. ");
INSERT INTO dig_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Aho auka kpwa kano ya kpwandza kpwa lagizo ra Mwenyezi Mlungu kutsupira Musa. ");
INSERT INTO dig_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Ariokala a kpwandza kuvundza kambi kala ni makundi ga kambi ya Juda tsini ya bendera yao. Na chilongozi wa kundi ra mbari ya Juda kala ni Nashoni mwana wa Aminadabu. ");
INSERT INTO dig_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Chilongozi wa kundi ra mbari ya Isakari kala ni Nethaneli mwana wa Suari, ");
INSERT INTO dig_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","na chilongozi wa kundi ra mbari ya Zabuloni kala ni Eliabu mwana wa Heloni. ");
INSERT INTO dig_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Chisha ro hema ratserezwa, na atu a mryango wa Gerishoni na wa Merari aritsukula achiuka. ");
INSERT INTO dig_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Alafu makundi ga kambi ya Rubini tsini ya bendera yao gavundza kambi gachiuka. Chilongozi wa kundi ra mbari ya Rubini kala ni Elisuri mwana wa Shedeuri. ");
INSERT INTO dig_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Na chilongozi wa kundi ra mbari ya Simioni kala ni Shelumieli mwana wa Surishadai, ");
INSERT INTO dig_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","na chilongozi wa kundi ra mbari ya Gadi kala ni Eliasafu mwana wa Deueli. ");
INSERT INTO dig_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Chisha atu a mryango wa Kohathi achiuka kuno akatsukula miyo mitakatifu; ro hema kala ni richitwe kabila taadzangbwefika. ");
INSERT INTO dig_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Alafu makundi ga kambi ya Efuraimu tsini ya bendera yao gavundza kambi gachiuka. Na chilongozi wa kundi ra mbari ya Efuraimu kala ni Elishama mwana wa Amihudi. ");
INSERT INTO dig_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Chilongozi wa kundi ra mbari ya Manase kala ni Gamalieli mwana wa Pedasuri, ");
INSERT INTO dig_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","na chilongozi wa kundi ra mbari ya Benjamini kala ni Abidani mwana wa Gidioni. ");
INSERT INTO dig_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Okala a mwisho kuvundza kambi kala ni makundi ga kambi ya Dani tsini ya bendera yao. Na chilongozi wa kundi ya mbari ya Dani kala ni Ahiezeri mwana wa Amishadai. ");
INSERT INTO dig_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Chilongozi wa kundi ra mbari ya Asheri kala ni Pagieli mwana wa Okirani, ");
INSERT INTO dig_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","na chilongozi wa kundi ra mbari ya Nafutali kala ni Ahira mwana wa Enani. ");
INSERT INTO dig_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Hivi ndivyo higo makundi ga Aiziraeli garivyovundza kambi na kuuka. ");
INSERT INTO dig_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Chisha Musa achigomba na mlamuwe Hobabu yekala mwana wa mtsedzawe Reueli, Mmidiani achimuamba, “Swiswi hunaphiya ko kpwatu ambako Mwenyezi Mlungu waamba, ‘Nindakuphani,’ ndzo huphiye naswi, naswi hundakuhendera manono, mana Mwenyezi Mlungu akaahidi manono kpwa Iziraeli.” ");
INSERT INTO dig_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Ela Hobabu achimjibu achimuamba, “Mino sindaphiya, ela nindauya kpwehu, kpwa mbari zangu.” ");
INSERT INTO dig_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Naye Musa achimuamba, “Hunakuvoya usihuriche, mana uwe ndiwe umanyaye phatu hunaphoweza kuchita kambi jangbwani, nawe undahuelekeza. ");
INSERT INTO dig_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Tsona, uchiphiya phamwenga naswi, nono rorosi ambaro Mwenyezi Mlungu andahuendera, naswi undakuhendera dza vivyo.” ");
INSERT INTO dig_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Phahi nyo Aiziraeli auka kula mwango wa Mwenyezi Mlungu na achiphiya charo cha siku tahu. Naro ro sanduku ra chilagane ra Mwenyezi Mlungu raatanguliya ili rikaalorere phatu pha kuoya. ");
INSERT INTO dig_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Wakati ariphovundza kambi na kuuka wakati wa mutsi ro ingu ra Mwenyezi Mlungu rakala ri dzulu yao. ");
INSERT INTO dig_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Wakati wowosi ro sanduku ririphouka, Musa waamba, “Unuka uwe Mwenyezi Mlungu! Richa maaduigo gatsamukane, na avihao achimbire mberezo.” ");
INSERT INTO dig_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Na wakati wowosi ro sanduku ririphoima, Musa waamba, “Ee Mwenyezi Mlungu, auyire hinya maelufu na maelufu ga atu a Iziraeli.” ");
INSERT INTO dig_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Chisha Aiziraeli aandza kumnungʼunikira Mwenyezi Mlungu kuhusu tabu zao. Mwenyezi Mlungu ariphoasikira, waatsukirirwa sana na achiahumira moho, uchiocha seemu za kanda-kanda ya yo kambi. ");
INSERT INTO dig_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Ndipho nyo atu achimririra Musa, naye Musa achimvoya Mwenyezi Mlungu na moho uchifwa. ");
INSERT INTO dig_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Phahi pho phatu phachiihwa Tabera, mana hipho moho wa Mwenyezi Mlungu waaka kahi yao. ");
INSERT INTO dig_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Kahi za Aiziraeli kpwakala na kundi ra mtsanganyiko wa atu ario si Aiziraeli. Atu aha akala na hamu kulu ya kurya vyakurya vyanjina. Phahi nyo Aiziraeli nao achiandza kurira vyenye achiamba, “Hundaphahaphi nyama swino hurye? ");
INSERT INTO dig_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Hunatambukira ngʼonda huriokala huchirya Misiri bila maripho, na aina ya matango-tango, matikiti, mtsunga, vitunguu na vitunguu saumu. ");
INSERT INTO dig_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Ela vivi tahuna tsona hamu ya kurya kpwa kukala taphana chakurya chanjina isiphokala manna.” ");
INSERT INTO dig_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Yo manna yakala avi ni tembe za muhama, na yakala na rangi ya mandano dza uvumba uihwao bedola. ");
INSERT INTO dig_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Atu azunguluka na achiihala, achiisaga na mawe ga kusagira au kuiphonda na vinu, chisha achiitiya nyunguni iokohe na achiitengeza mikahe, na ladhaye yakala kama ya keki ichiyojitwa na mafuha. ");
INSERT INTO dig_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Manna ihi yagbwa kambini usiku phamwenga na manena. ");
INSERT INTO dig_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Musa achisikira atu a nyumba zosi anarira, chila mmwenga phenye mryango wa hemare. Mwenyezi Mlungu achitsukirwa sana, naye Musa kayahamirwa. ");
INSERT INTO dig_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Musa achigomba na Mwenyezi Mlungu achimuamba, “Kpwa utu wani unanihendera mai mino mtumishio? Kpwa utu wani sidzangbwekubalika mberezo, hata unihike mzigo wa kulongoza atu hinya osi? ");
INSERT INTO dig_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Dze, ndimi niriyeaumba atu osi hinya? Kpwani, ndimi nriyeatsukula ndanini, hata uniambe, ‘Aunule phako lagani dza mrezi aunulavyo mwana mtsanga,’ na niaphirike tsi uriyoapa kuapha akare ao? ");
INSERT INTO dig_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Niphahephi nyama za kurisa atu osi hinya? Mana aredza kpwangu na ndiro kuno anaamba, ‘Huphe nyama hurye!’ ");
INSERT INTO dig_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Sina uwezo wa kutsukula atu osi hinya machiyangu, mana ni mzigo kpwangu. ");
INSERT INTO dig_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Ichikala vivi ndivyo ndivyoenderera kunihenda, phahi niolaga vivi kare, ichikala nikakubalika mberezo usiniriche niphahwe ni higa mai.” ");
INSERT INTO dig_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Phahi Mwenyezi Mlungu achimuambira Musa, “Nikusanyira atumia mirongo sabaa a Iziraeli, unaomanya kukala ni atu a kuishimika na ni vilongozi ao. Arehe kpwenye hema ra mkpwutano, na uime phamwenga nao. ");
INSERT INTO dig_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Nindatserera na nigombe nawe phapho. Nindahala seemu ya ye roho ariyedzuluyo, niaphe, nao andatsukula mzigo wa atu aha phamwenga na uwe kpwa usiutsukule macheyo. ");
INSERT INTO dig_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“Chisha uaambire nyo atu: ‘Dzitakaseni na mkale tayari kpwa kukala muhondo mundarya nyama. Mwenyezi Mlungu wasikira chiriro chenu wakati mriphoamba, “Hundaphahaphi nyama hurye swino? Kpwa kpweli baha pho huriphokala Misiri.” Phahi Mwenyezi Mlungu andakuphani nyama murye. ");
INSERT INTO dig_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Namwi tamundazirya kpwa siku mwenga, wala mbiri, wala tsano, wala kumi, wala mirongo miiri, ");
INSERT INTO dig_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","ela mundazirya kpwa mwezi mzima, hadi zikusinyeni. Gaga gosi gandahendeka kpwa sababu mkamrema Mwenyezi Mlungu ariye phamwenga namwi na kurira mbereze mchiamba, “Kpwa utu wani swino hwatuluka Misiri?” ’ ” ");
INSERT INTO dig_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Ela Musa achigomba na Mwenyezi Mlungu achiamba, “Nina atu elufu magana sita hipha, nawe unaamba, ‘Nindaapha nyama za kuatosha kurya mwezi mzima!’ ");
INSERT INTO dig_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Dze, hata hukatsindza ngʼombe zosi, mangʼondzi gosi na mbuzi zosi kpweli zindaatosha? Hata hukagbwira ngʼonda osi a baharini, kpweli andatosha?” ");
INSERT INTO dig_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Mwenyezi Mlungu achigomba na Musa, achimuuza, “Vino unaona siweza kukuphani nyama? Phahi undaona ichikala neno rangu tarindatimiya.” ");
INSERT INTO dig_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Phahi Musa watuluka achendaambira atu maneno ga Mwenyezi Mlungu, naye achiakusanya atumia mirongo sabaa a nyo Aiziraeli na achiaimisa kuzunguluka ro hema. ");
INSERT INTO dig_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Chisha Mwenyezi Mlungu achitserera kahi-kahi ya ingu, achigomba naye, achihala seemu ya roho ariyekala dzulu ya Musa achiapha hara atumia mirongo sabaa. Na ye roho ariphohurira dzulu yao, aandza kutabiri dza manabii, ela taayaenderera kuhenda hivyo tsona. ");
INSERT INTO dig_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Kpwakala na atumia airi, Elidadi na Medadi ariokala ni seemu ya hara atumia mirongo sabaa, ela aho asala kambini ayawao ariphophiya hemani. Phahi roho wakpwedza dzulu yao mo kambini na achiandza kutabiri dza manabii mumo. ");
INSERT INTO dig_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Mvulana mmwenga wazola achendamuambira Musa, “Elidadi na Medadi akaandza kutabiri dza manabii ko kambini.” ");
INSERT INTO dig_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Hipho Joshuwa mwana wa Nuni, yekala msaidizi wa Musa hangu uvulanawe achimuambira Musa, “Akahaze, bwana wangu!” ");
INSERT INTO dig_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Ela Musa achimuamba, “Kpwani unaona vyo ahendavyo ni vii? Mi mwenye naaza kukala atu osi a Mwenyezi Mlungu angekala manabii na Mwenyezi Mlungu angeatiya Rohowe!” ");
INSERT INTO dig_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Bada ya higo Musa na atumia a Iziraeli auya kambini. ");
INSERT INTO dig_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Chisha Mwenyezi Mlungu achihuma phuto, richireha makpware kula baharini na kugahenda gauruke photsi-photsi chimo cha kama mita mwenga. Nago gazunguluka kambi yosi hatuwa ya mwendo wa siku mwenga pande zosi. ");
INSERT INTO dig_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Phahi nyo atu asinda na achichesa kugbwira higo makpware na yo siku ya phiriye achisinda kugagbwira. Taphana mutu yegbwira tsini ya kilo elufu mwenga. Nao achigaanika kuzunguluka yo kambi. ");
INSERT INTO dig_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Ela ariphoandza kutiya zo nyama mromoni tu, Mwenyezi Mlungu achiatsukirirwa sana na achiapiga na shaka kulu. ");
INSERT INTO dig_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Kpwa hivyo phatu hipho phachiihwa Kiburothi-Hataava, kpwa kukala ndipho phariphozikpwa atu ariokala na kpwiru. ");
INSERT INTO dig_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Kula hipho Kiburothi-Hataava atu aphiya Haserothi na achendasagala hiko. ");
INSERT INTO dig_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Miriamu na Aruni agomba mai kuhusu Musa kpwa sababu kala akalóla mchetu wa Chikushi. ");
INSERT INTO dig_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Nao agomba achiamba, “Kpwani ye Mwenyezi Mlungu anagomba kutsupira Musa macheye? Avi nkugomba kutsupira swiswi naswi piya?” Naye Mwenyezi Mlungu achigasikira. ");
INSERT INTO dig_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Phahi Musa wakala ni mutu mpore sana kuriko mutu wanjina yeyesi duniani. ");
INSERT INTO dig_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Gafula Mwenyezi Mlungu achigomba na Musa, Aruni na Miriamu achiaambira, “Tulukani mwi ahahu, mwedze kpwenye hema ra mkpwutano.” Phahi osi ahahu atuluka. ");
INSERT INTO dig_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Chisha Mwenyezi Mlungu achitserera kahi ya nguzo ya ingu achiima phatu pha kumenyera hemani, naye achiiha Aruni na Miriamu, osi airi achedza mbere. ");
INSERT INTO dig_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Naye achiamba, “Hebu niphundzani: Ichikala kuna nabii kahi yenu, mimi Mwenyezi Mlungu nkudzionyesa kpwakpwe kutsupira ruwiya, na kugomba naye ndosoni. ");
INSERT INTO dig_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Ela sivyo nihendavyo na mtumishi wangu Musa, iye ni muaminifu kahi za atu angu Aiziraeli. ");
INSERT INTO dig_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Nkugomba naye uso kpwa uso, chingʼangʼa wala si kpwa mafumbo, iye nkuona umbo ra Mwenyezi Mlungu. Mbona phahi tamyaogopha kugomba mai kuhusu mtumishi wangu Musa?” ");
INSERT INTO dig_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Mwenyezi Mlungu achiatsukirirwa sana, chisha achiuka. ");
INSERT INTO dig_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Ro ingu ririphouka pho dzulu ya ro hema, Miriamu achikala na mahana, mwereru dza bafuta. Aruni achilola Miriamu na achimuona ana mahana. ");
INSERT INTO dig_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Chisha Aruni achigomba na Musa achimuamba, “Nakuvoya bwana wangu, usihutiye adabu kpwa dambi huchiyoihenda kpwa uzuzu. ");
INSERT INTO dig_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Usimuhende Miriamu akale dza mutu ariyevyalwa wa kufwa, ariye nyama ya mwiriwe yariwa nusu wakati anavyalwa.” ");
INSERT INTO dig_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Ndipho Musa achimririra Mwenyezi Mlungu achimuamba, “Ee Mlungu, nakuvoya umuphoze.” ");
INSERT INTO dig_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Mwenyezi Mlungu achimjibu Musa achimuamba, “Kalapho Miriamu watsitsirwa mahe usoni ni ise, si angegbwirwa ni waibu kpwa siku sabaa? Mtuluzeni kondze ya kambi na akale kuko kpwa siku sabaa chisha mumuuyize kambini.” ");
INSERT INTO dig_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Phahi Miriamu watuluzwa kondze ya kambi kpwa muda wa siku sabaa, na nyo atu taaukire hadi Miriamu ariphouyizwa. ");
INSERT INTO dig_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Bada ya higo Aiziraeli auka kula Haserothi, na achendachita kambi kahi ya jangbwa ra Parani. ");
INSERT INTO dig_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Mwenyezi Mlungu achigomba na Musa achimuamba, ");
INSERT INTO dig_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Huma atu, chilongozi mmwenga kahi ya chila mbari, aphiye akapeleleze tsi ya Kanani, ambayo nindaapha Aiziraeli,” ");
INSERT INTO dig_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Phahi, Musa achiahuma kula jangbwa ra Parani dza Mwenyezi Mlungu arivyomlagiza. Osi kala ni akulu a Aiziraeli. ");
INSERT INTO dig_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Na higa ndigo madzina ga nyo atu: Shamua mwana wa Zakuri, kula mbari ya Rubini, ");
INSERT INTO dig_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Shafati mwana wa Hori, kula mbari ya Simioni, ");
INSERT INTO dig_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Kalebu mwana wa Jefune, kula mbari ya Juda, ");
INSERT INTO dig_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Igali mwana wa Yusufu, kula mbari ya Isakari, ");
INSERT INTO dig_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Hoshea mwana wa Nuni, kula mbari ya Efuraimu, ");
INSERT INTO dig_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Paliti mwana wa Rafu, kula mbari ya Benjamini, ");
INSERT INTO dig_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Gadieli mwana wa Sodi, kula mbari ya Zabuloni, ");
INSERT INTO dig_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Gadi mwana wa Susi, kula mbari ya Yusufu, yani mbari ya Manase, ");
INSERT INTO dig_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Amieli mwana wa Gemali, kula mbari ya Dani, ");
INSERT INTO dig_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Sethuri mwana wa Mikaeli, kula mbari ya Asheri, ");
INSERT INTO dig_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Nabi mwana wa Wofusi, kula mbari ya Nafutali, ");
INSERT INTO dig_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Geueli mwana wa Maki, kula mbari ya Gadi. ");
INSERT INTO dig_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Higa ndigo madzina ga atu ariohumwa ni Musa kupeleleza tsi ya Kanani. Musa achimgaluza dzina Hoshea mwana wa Nuni achimuiha Joshuwa. ");
INSERT INTO dig_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Musa ariphoahuma nyo atu kpwendaipeleleza tsi ya Kanani, waambira, “Ambukani kutsupira uphande wa mwakani wa tsi ya Kanani na mphiye uphande wa vurini kuriko na vidzango. ");
INSERT INTO dig_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Phiyani mkailole yo tsi vyo irivyo. Mlole hinyo atu asagalao himo ichikala ana mkpwotse hebu taana, ichikala ni anji au ni achache. ");
INSERT INTO dig_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Na ichikala yo tsi asagalayo ni nono au ni mbii, na ichikala yo midzi asagalayo yadzengerwa ngome au taidzengererwe. ");
INSERT INTO dig_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Piya mmanye ichikala mtsanga wa yo tsi ni mnono au si mnono, napho kuna mihi au takuna. Hendani dzulu tsini mrehe seemu ya matunda ga yo tsi.” Uho wakala ni wakati wa zabibu za mwandzo-mwandzo kuivwa. ");
INSERT INTO dig_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Phahi nyo atu aambuka na achendaipeleleza yo tsi kula jangbwa ra Sini ririro uphande wa mwakani hadi Rehobu iriyo uphande wa vurini, phephi na phatu pha kumenyera Hamathi. ");
INSERT INTO dig_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Aho aambuka kutsupira uphande wa mwakani wa tsi ya Kanani hadi achifika Heburoni, phatu phariphosagala atu a chivyazi cha Anaki yani Ahimani, Sheshai na Talimai. (Mudzi wa Heburoni kala ukadzengbwa miaka sabaa kabila mudzi wa Soani kudzengbwa ko Misiri.) ");
INSERT INTO dig_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Ariphofika Dete ra Eshikoli, achikata phungo rokala na lihungo kulu ra zabibu naro richitsukulwa dzulu ya gongo ni atu airi. Piya achitsukula makomamanga na tini. ");
INSERT INTO dig_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Pho phatu phaihwa Dete ra Eshikoli, kpwa sababu ya ro lihungo ririrokatwa phapho ni nyo apelelezi a Iziraeli. ");
INSERT INTO dig_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","O apelelezi auya bada ya kuipeleleza yo tsi kpwa muda wa siku mirongo mine. ");
INSERT INTO dig_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Nyo apelelezi auya kpwa Musa, Aruni na mkpwutano wa Aiziraeli osi hiko Kadeshi kahi ya jangbwa ra Parani. Phapho aasemurira phamwenga na nyo mkpwutano wosi na achiaonyesa go matunda ga yo tsi. ");
INSERT INTO dig_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Nao achimuambira Musa, “Hwafika yo tsi uriyouhuma hukaipeleleze, na huchendaipeleleza. Tsi iyo ni nono na i tele maziya na asali hata higa ndigo bazi ya matundage. ");
INSERT INTO dig_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Ela nyo atu asagalao kuko ana mkpwotse na yo midzi yao ni mikulu na yadzengerwa ngome. Phamwenga na gago huchiona atu a chivyazi cha Anaki. ");
INSERT INTO dig_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Aamaleki anasagala uphande wa mwakani mwa tsi ya Kanani, na Ahiti, Ajebusi na Aamori anasagala seemu zenye vidzango. Akanani nao anasagala phephi na bahari na kanda-kanda ya muho Joridani.” ");
INSERT INTO dig_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Chisha Kalebu achiahuriza nyo atu mbere za Musa achiamba, “Nahuambukeni hukaihale yo tsi, mana kpwa kpweli huna uwezo wa kuiturya.” ");
INSERT INTO dig_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Ela nyo atu anjina ariophiya phamwenga naye achiamba, “Tahuweza kuashambuliya nyo atu mana ana mkpwotse kuriko swiswi.” ");
INSERT INTO dig_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Kpwa hivyo achieneza habari mbii kahi ya Aiziraeli kuhusu yo tsi ariyoipeleleza achiamba, “Yo tsi huriyoipeleleza ni tsi ya ndzala, na nyo atu osi hurioaona kuko ni akulu. ");
INSERT INTO dig_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Chisha hwaona madzitu kuko, yani Anefili (atu a chivyazi cha Anaki ala kpwa Anefili). Huchidziona avi hu mabandzi mbere zao, nao ndivyo arivyohuona.” ");
INSERT INTO dig_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Phahi usiku wosi, Aiziraeli osi akota kululu achirira. ");
INSERT INTO dig_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Atu osi a Iziraeli arurumikira Musa na Aruni achiamba, “Baha kala hwafwa Misiri au phapha weruni! ");
INSERT INTO dig_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Kpwa utu wani Mwenyezi Mlungu anaureha kahi ya tsi ihi huolagbwe kpwa upanga? Achetu ehu na ana ehu andahalwa mateka. Si baha huuye Misiri?” ");
INSERT INTO dig_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Achiambirana, “Nahutsambuleni chilongozi, huuye Misiri.” ");
INSERT INTO dig_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Chisha Musa na Aruni achidzibwaga chimabumabu mbere za Aiziraeli osi. ");
INSERT INTO dig_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Joshuwa mwana wa Nuni na Kalebu mwana wa Jefune, ariokala ni kahi ya hara atu ariokpwendapeleleza yo tsi, akpwanyula nguwo zao ");
INSERT INTO dig_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","na achiaambira nyo Aiziraeli osi, “Yo tsi huriyophiya kuipeleleza ni nono sana. ");
INSERT INTO dig_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Mwenyezi Mlungu achifwahirwa naswi, andahureha huinjire tsi ihi iriyo na maziya na asali na ahuphe ikale yehu. ");
INSERT INTO dig_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Ela tu msimuasi Mwenyezi Mlungu, na msiaogophe atu a yo tsi, kpwa kukala aho si chochosi kpwehu, mana urindzi wao ukauswa na Mwenyezi Mlungu a phamwenga naswi. Msiaogophe.” ");
INSERT INTO dig_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Ela Aiziraeli osi achilonda kuapiga mawe. Chisha utukufu wa Mwenyezi Mlungu uchiatsembukira Aiziraeli osi kahi za hema ra mkpwutano. ");
INSERT INTO dig_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Mwenyezi Mlungu achimuuza Musa achimuamba, “Ano Aiziraeli andanibera hadi rini? Na taandaniamini hadi rini, hata bada ya ishara zosi nirizoahendera kahi yao? ");
INSERT INTO dig_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Nindaangamiza na makongo, nami nindakuhenda taifa kulu renye mkpwotse kushinda aho.” ");
INSERT INTO dig_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Ela Musa achigomba na Mwenyezi Mlungu achimuamba, “Uwe ndiwe uriyeatuluza atu aha kula Misiri kpwa nguvuzo. Amisiri ndiphosikira kukala ukaahendera atuo hivyo, ");
INSERT INTO dig_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","andaambira enyezi a tsi ihi. Mana nyo enyezi a tsi ihi asikira kare kukala uwe Mwenyezi Mlungu u phamwenga na Aiziraeli, kpwa kukala unaonekana chingʼangʼa na inguro rinaima dzulu yao. Chisha ukualongoza na nguzo ya ingu wakati wa mutsi na nguzo ya moho wakati wa usiku. ");
INSERT INTO dig_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Phahi uchiaolaga atu aha osi mara mwenga, go mataifa ganjina ndiphosikira sifwazo gandaamba, ");
INSERT INTO dig_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Mwenyezi Mlungu waaolaga atu aha ko weruni kpwa kukala washindwa ni kuaphirika kahi za tsi ariyoapa kuapha.’ ");
INSERT INTO dig_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“Phahi vivi Mwenyezi Mlungu onyesa kukala una uwezo mkpwulu dza urivyohulaga, uriphoamba, ");
INSERT INTO dig_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Mimi Mwenyezi Mlungu sina tsukizi za phephi, nina mendzwa nyinji isiyosika, na ninaswamehe dambi na uasi. Ela sindaricha kuatiya adabu anikoserao. Nindaatiya adabu ana kpwa dambi za ise zao hata chivyazi cha hahu na cha ne.’ ");
INSERT INTO dig_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Kulengana na mendzwayo isiyosika irivyo kulu, nakuvoya uswamehe dambi za atu aha, dza urivyoaswamehe atu aha wakati ariphotuluka kula Misiri hadi rero.” ");
INSERT INTO dig_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Mwenyezi Mlungu achimjibu achimuamba, “Nikaaswamehe dza uchivyovoya. ");
INSERT INTO dig_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Ela kpwa kpweli dza niishivyo na dza dunia yosi ndivyoodzala utukufu wa Mwenyezi Mlungu, ");
INSERT INTO dig_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","taphandakala hata mutu mmwenga ariyeona utukufu wangu na vilinje nirivyovihenda ko Misiri na ko weruni chisha akazidi kunijeza kano hizi kumi bila ya kunisikira, ");
INSERT INTO dig_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","ndiyeiona tsi niriyoapa kuapha akare ao, wala taphana kahi za aho arionibera ndiyeiona yo tsi. ");
INSERT INTO dig_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Ela kpwa kukala mtumishi wangu Kalebu atafwauti na akanilunga moyo kutsuka, nindamreha kahi za yo tsi ariyophiya, na andaimiliki phamwenga na chivyaziche. ");
INSERT INTO dig_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Phahi kpwa kukala Aamaleki na Akanani anasagala madeteni, muhondo galukani mphiye weruni kuhumira njira ya Bahari ya Shamu.” ");
INSERT INTO dig_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Mwenyezi Mlungu achigomba na Musa na Aruni achiamba, ");
INSERT INTO dig_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Uno mkpwutano wa atu ayi undaenderera kunirurumikira ta rini? Nikasikira Aiziraeli anavyonirurumikira. ");
INSERT INTO dig_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Aambireni hivi: ‘Mwenyezi Mlungu anaamba, kpwa kpweli dza niishivyo, nindakuhenderani gara nirigokusikirani mnagagomba. ");
INSERT INTO dig_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Mundafwa na nyufu zenu zindagota chila phatu mumu weruni. Kpwa sababu mkanirurumikira, takuna hata mutu mmwenga kahi yenu ariyekala na umuri wa miaka mirongo miiri na kpwenderera wakati mriphoolangbwa, ");
INSERT INTO dig_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","ndiyeinjira iyo tsi niriyoapa kuapha ikale yenu, isiphokala Kalebu na Joshuwa. ");
INSERT INTO dig_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Nyo ana enu murioamba andahalwa mateka, nindaafisa nao andaifwaidi yo tsi mriyoibera. ");
INSERT INTO dig_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Ela mwimwi, nyufu zenu zindagota chila phatu mumu weruni. ");
INSERT INTO dig_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Ana enu andakala arisa mumu weruni kpwa muda wa miaka mirongo mine hadi mwimwi mosi mufwe mumu, kpwa kukala mwakosa uaminifu. ");
INSERT INTO dig_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Dza viratu murivyoipeleleza yo tsi kpwa siku mirongo mine, mundateseka kpwa sababu ya dambi zenu kpwa muda wa miaka mirongo mine, yani siku mwenga kpwa mwaka mmwenga. Namwi mundamanya kukala taifwaha kunihenda mimi nikale adui wenu.’ ");
INSERT INTO dig_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Mimi Mwenyezi Mlungu nkaamba, na kpwa kpweli gaga gosi ndigohendera mkpwutano uhu wosi mui uriokusanyika phamwenga kunipinga. Osi andafwa mumu weruni hadi asire.” ");
INSERT INTO dig_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Phahi hara atu ambao kala akahumwa ni Musa akaipeleleze yo tsi na achedzalavya habari za kuvundza moyo ariphouya hadi nyo mkpwutano wosi uchimrurumikira Musa, ");
INSERT INTO dig_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","agbwirwa ni ukongo na achifwa mbere za Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Ela kahi za hara ariophiya kuipeleleza yo tsi, Joshuwa na Kalebu ndio ariosala moyo machiyao. ");
INSERT INTO dig_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Musa ariphoaambira Aiziraeli osi mambo higo, asononeka sana. ");
INSERT INTO dig_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Ligundzure achilamuka na achiambuka hadi dzulu kabisa hiko tsi ya myango mire achiamba, “Vivi hu tayari, hundaambuka hadi phatu huriphoahidiwa ni Mwenyezi Mlungu. Hunakubali kukala hukahenda dambi.” ");
INSERT INTO dig_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Ela Musa achiamba, “Kpwa utu wani tamlunga lagizo ra Mwenyezi Mlungu? Tamundaongokerwa bii! ");
INSERT INTO dig_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Msiambuke, mana mchiphiya, mundashindwa ni maadui genu kpwa kukala Mwenyezi Mlungu kaphamwenga namwi. ");
INSERT INTO dig_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Kuko mundakutana na Aamaleki na Akanani namwi mundaolagbwa na upanga. Kpwa kukala mkaricha kumlunga Mwenyezi Mlungu, naye kandakala phamwenga namwi.” ");
INSERT INTO dig_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Ela aho aambuka vivyo kuphiya hadi dzulu ya yo tsi ya myango, dzagbwe Musa kaukire wala sanduku ra chilagane ra Mwenyezi Mlungu tariusirwe pho kambini. ");
INSERT INTO dig_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Chisha Aamaleki na Akanani ariosagala kahi za tsi iyo ya myango achitserera, achiashambuliya Aiziraeli, achiapiga na achiazoresa hadi phatu phoihwa Horima. ");
INSERT INTO dig_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Mwenyezi Mlungu wagomba na Musa achimuamba, ");
INSERT INTO dig_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Gomba na Aiziraeli uambire: Wakati mchiinjira yo tsi ambayo nindakuphani ikale makalo genu, ");
INSERT INTO dig_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","namwi mumrehere Mwenyezi Mlungu sadaka za kuochwa, sadaka za kuusira hati, sadaka za hiyari, au za sikukuu zirizopangbwa kpwa ikale kungu nono imuhamirayo Mwenyezi Mlungu ikale ni ngʼombe, ngʼondzi au mbuzi mundahenda hivi: ");
INSERT INTO dig_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","yeyesi alavyaye sadaka dza iyo kpwa Mwenyezi Mlungu ni alavye sadaka ya mtsere ya kilo mwenga ya unga mnono uriotsanganywa na lita mwenga ya mafuha, ");
INSERT INTO dig_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","phamwenga na sadaka ya chinwadzi cha lita mwenga ya uchi wa zabibu kpwa chila ngʼondzi ambaro mundarilavya dza sadaka ya kuochwa au sadaka yanjina. ");
INSERT INTO dig_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“Ichikala yo sadaka ni ya turume, mundalavya sadaka ya mtsere ya kilo mbiri za unga mnono uriotsanganywa na lita mwenga na nusu ya mafuha, ");
INSERT INTO dig_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","phamwenga na sadaka ya chinwadzi cha uchi wa zabibu lita mwenga na nusu. Lavya sadaka ihi ikale kungu nono imuhamirayo Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“Mutu achilavya mwana ndzau dza sadaka ya kuochwa au ya kuusira naziri au dza sadaka ya amani kpwa Mwenyezi Mlungu, ");
INSERT INTO dig_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","andailavya na sadaka ya mtsere ya kilo tahu za unga mnono uriotsanganywa na lita mbiri za mafuha, ");
INSERT INTO dig_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","phamwenga na sadaka ya chinwadzi cha uchi wa zabibu lita mbiri. Sadaka ihi indalaviwa ili ikale kungu nono ya kuhamira Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Na hivi ndivyo ndivyokala kpwa chila ndzau, turume, mwana turume au mbuzi. ");
INSERT INTO dig_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Namwi mundahenda hivyo kpwa chila ndiyelavya kulengana na hara nyama ambao andalavya. ");
INSERT INTO dig_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“Chila Muiziraeli ni ahende mambo gaga kpwa njira ihi anapholavya sadaka yenye kungu nono imuhamirayo Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Na siku zedzazo phachikala na mjeni au mutu wanjina yeyesi ambaye andakala anasagala phamwenga namwi ndiyelonda kulavya sadaka yenye kungu nono imuhamirayo Mwenyezi Mlungu, iye ni ahende dza muhendavyo mwimwi. ");
INSERT INTO dig_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Kahi ya vivyazi vyosi vyedzavyo, malagizo ambago mundagalunga mwimwi Aiziraeli ndigo ambago gandalungbwa ni mjeni yeyesi ndiyesagala phamwenga namwi. Mwimwi enyezi na hinyo ajeni mundakala musawa-sawa mbere za Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Shariya na malagizo ndigohumira mwimwi na nyo ajeni asagalao phamwenga namwi gandakala ni mamwenga.” ");
INSERT INTO dig_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Mwenyezi Mlungu achigomba na Musa achimuamba, ");
INSERT INTO dig_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Gomba na Aiziraeli uaambire: Ndiphoinjira tsi ambayo nakuphirikani, ");
INSERT INTO dig_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","chila chakurya ambacho mundachirya cha tsi iyo, mundalavya seemu ikale sadaka kpwa Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Mundatengeza mkpwahe wa unga wa kpwandza ndiosaga, munirehere dza sadaka ya kuunulwa dza viratu mlavyavyo sadaka kula phatu pha kuwagira. ");
INSERT INTO dig_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Mundalavya seemu ya unga wenu mnono wa kpwandza kpwa Mwenyezi Mlungu dza sadaka ya kuunulwa vivyazi vyenu vyosi. ");
INSERT INTO dig_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“Ela muchihenda dambi bila kumanya na mkose kulunga hata mwengarapho ra malagizo mrigohewa ni Mwenyezi Mlungu kutsupira Musa, ");
INSERT INTO dig_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","gosi ambago Mwenyezi Mlungu wakulagizani kutsupira Musa, kuandzira siku ambayo Mwenyezi Mlungu walavya malagizo hata vivyazi vyedzavyo, ");
INSERT INTO dig_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","napho ni kosa ririrohendwa bila kumanya kpwa sababu mkpwutano taumanyire, nyo mkpwutano undalavya sadaka ya kuochwa ya mwana ndzau mmwenga ikale kungu nono ya kuhamira Mwenyezi Mlungu, phamwenga na sadakaye ya mtsere na ya chinwadzi kulengana na malagizoge. Chisha nyo mkpwutano undalavya ndenje mwenga ikale sadaka ya kuusa dambi. ");
INSERT INTO dig_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Mlavyadzi-sadaka andaapatanisha Aiziraeli osi na Mlungu, nao andaswamehewa kpwa sababu kala ni kosa ririrohendwa bila kumanya, nao akareha sadaka yao ya kuochwa na ya dambi kpwa Mwenyezi Mlungu, kpwa sababu ya makosa gao. ");
INSERT INTO dig_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Aiziraeli osi phamwenga na ajeni asagalao nao andaswamehewa mana osi ahenda makosa bila kumanya. ");
INSERT INTO dig_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“Mutu mmwenga achihenda dambi bila kumanya, ni arehe sadaka ya mvarika wa mwaka mmwenga ikale sadaka ya kuusa dambi. ");
INSERT INTO dig_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Mlavyadzi-sadaka andampatanisha na Mwenyezi Mlungu ye mutu achiyehenda dambi, na kpwa kuhenda hivyo ye mutu andaswamehewa. ");
INSERT INTO dig_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Mundakala na shariya mwenga ndiyohumika kpwa yeyesi ndiyehenda dambi bila kumanya, akale ni Muiziraeli mwenyezi au ni mjeni asagalaye phamwenga namwi. ");
INSERT INTO dig_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“Ela mutu yeyesi ndiyehenda dambi kusudi, akale Muiziraeli au mjeni, anamkufuru Mwenyezi Mlungu, naye ni atengbwe na atue. ");
INSERT INTO dig_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Mutu dza hiye ni atengbwe tsetsetse na atsukule lawama ra uyiwe, kpwa sababu akabera neno ra Mwenyezi Mlungu na kuvundza amurize.” ");
INSERT INTO dig_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Siku mwenga Aiziraeli ariphokala achere weruni aona mutu anatsola-tsola kuni Siku ya Kuoya. ");
INSERT INTO dig_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Hara ariomuona amreha kpwa Musa, Aruni na Aiziraeli osi. ");
INSERT INTO dig_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Nao achimtiya chifungoni mana kala taamanya ra kumuhenda. ");
INSERT INTO dig_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Chisha Mwenyezi Mlungu achigomba na Musa achimuamba, “Mutu iye ni aolagbwe. Atu osi ni ampige mawe kondze ya mudzi hadi afwe.” ");
INSERT INTO dig_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Phahi nyo atu osi amtuluza kondze ya yo kambi na achimpiga mawe hadi achifwa, dza Mwenyezi Mlungu arivyomlagiza Musa. ");
INSERT INTO dig_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Mwenyezi Mlungu achigomba na Musa achimuamba, ");
INSERT INTO dig_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Gomba na Aiziraeli na uaambe adzisukire midzele kpwenye michindo ya mavwazi gao kahi za vivyazi vyao vyosi. Chila mdzele ukale na wuuzi wa rangi ya buluu. ");
INSERT INTO dig_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Midzele hino mundakala nayo ili ndiphoilola mtambukire na kulunga malagizo gosi ga Mwenyezi Mlungu, sedze mkakosa kuhenda uaminifu kpwa kulunga tamaa za mioyo yenu na matso genu. ");
INSERT INTO dig_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Yo midzele indakuhendani mtambukire na mlunge amuri zangu zosi, namwi mundakala atakatifu kpwa Mlungu wenu. ");
INSERT INTO dig_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Mimi, ndimi Mwenyezi Mlungu, Mlungu wenu, niriyekutuluzani Misiri, kpwa nikale Mlungu wenu. Mimi, ndimi Mwenyezi Mlungu, Mlungu wenu.” ");
INSERT INTO dig_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Siku mwenga Kora mwana wa Ishari, mwana wa Kohathi, mwana wa Lawi na atu a chivyazi cha Rubini, yani Dathani na Abiramu ana a Eliabu na Oni mwana wa Pelethi, ");
INSERT INTO dig_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","phamwenga na vilongozi magana mairi na mirongo mitsano a Iziraeli ariotsambulwa ni nyo mkpwutano, amanyikanao sana, amkosera Musa. ");
INSERT INTO dig_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Akusanyika chinyume cha Musa na Aruni achiamba, “Mwimwi mkazidi sana! Chila mmwenga ni mtakatifu, Mwenyezi Mlungu a phamwenga na utsi wosi. Kpwa utu wani munadzihenda kukala bora kuriko utsi wosi wa Mwenyezi Mlungu?” ");
INSERT INTO dig_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Musa ariphogasikira maneno higo, wadzibwaga photsi chimabumabu. ");
INSERT INTO dig_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Chisha achimuambira Kora na afuasie osi, “Muhondo ligundzu Mwenyezi Mlungu andahuonyesa ariye wakpwe, ariye mtakatifu na ndiyeruhusiwa kuphiya phephi naye. Iye ndiyemtsambula andamruhusu aphiye phephi naye. ");
INSERT INTO dig_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","7","Uwe Kora na afuasio osi mundahenda hivi: Muhondo mundahala vyetezo vya kufukizira uvumba, mvitiye makala ga moho na muike uvumba dzuluye mbere za Mwenyezi Mlungu. Mutu ndiyetsambulwa ni Mwenyezi Mlungu andakala ndiye mtakatifu. Mwimwi Alawi mkazidi sana!” ");
INSERT INTO dig_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Chisha Musa achimuambira Kora, “Phundzani mwi Alawi! ");
INSERT INTO dig_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Dze, munaona kukala ni dzambo dide ro ra Mlungu wa Iziraeli kukutengani kula kpwa Aiziraeli osi, na kukurehani phephi naye ili muhende kazi kahi za hema ra Mwenyezi Mlungu na kuima mbere za mkpwutano na kuahumikira nyo atu? ");
INSERT INTO dig_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Akakuphani ruhusa uwe phamwenga na Alawi anjina osi ya kuphiya phephi naye. Vino mnalonda kuhala ulavyadzi-sadaka piya? ");
INSERT INTO dig_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Kpwa hivyo uwe na nyo afuasio mkagbwirana ili kumpinga Mwenyezi Mlungu. Kpwani Aruni ni ani ta mumrurumikire?” ");
INSERT INTO dig_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Chisha Musa achilagiza aihirwe Dathani na Abiramu ana a Eliabu, ela nyo achiamba, “Tahwedza bii! ");
INSERT INTO dig_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Dze, ni dzambo dide kukala wahutuluza kula tsi, tsi yenye rutuba wedze uhuolage himu weruni? Na vino unalonda uhutawale. ");
INSERT INTO dig_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Zaidi ya gago kuyahureha kahi za tsi, tsi yenye rutuba, wala kuhupha urisi wa minda na vyunga vya mizabibu. Vino undaahenda atu hano akale azuzu? Tahwedza bii!” ");
INSERT INTO dig_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Musa achitsukirwa sana na achimuambira Mwenyezi Mlungu, “Usiikubali sadaka yao. Mimi sidzangbwehala hata punda mmwenga kula kpwao na sidzangbwemuhendera mai mutu hata mmwenga kahi yao.” ");
INSERT INTO dig_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Chisha Musa achimuambira Kora, “Muhondo, uwe phamwenga na afuasio osi na Aruni ndzoni mbere za Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Chila mmwenga wenu andahala chetezoche na achitiye uvumba chisha achiphirike mbere za Mwenyezi Mlungu. Kpwa jumula vindakala vyetezo magana mairi na mirongo mitsano. Uwe nawe phamwenga na Aruni mundahenda dza vivyo.” ");
INSERT INTO dig_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Phahi chila mmwenga achihala chetezoche, achichitiya makala ga moho, achiika uvumba dzuluye na achiima pho phatu pha kumenyera hema ra mkpwutano phamwenga na Musa na Aruni. ");
INSERT INTO dig_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Chisha Kora achiakusanya atu osi kumpinga Musa na Aruni okala phatu pha kumenyera hema ra mkpwutano. Na utukufu wa Mwenyezi Mlungu uchitsembukira mkpwutano wosi. ");
INSERT INTO dig_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Chisha Mwenyezi Mlungu achigomba na Musa na Aruni achiamba, ");
INSERT INTO dig_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Dzitengeni na kundi ra atu aha ili niaangamize mara mwenga.” ");
INSERT INTO dig_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Ela Musa na Aruni adzibwaga chimabumabu achiamba, “Ee Mlungu, Mlungu uphaye viumbe vyosi pumuzi ya uhai, dze, ikale undatsukirirwa atu osi kpwa dambi ya mutu mmwenga?” ");
INSERT INTO dig_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Mwenyezi Mlungu achigomba na Musa achimuamba, ");
INSERT INTO dig_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Aambire nyo atu aphiye kure na mahema ga Kora, Dathani na Abiramu.” ");
INSERT INTO dig_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Musa achiunuka na achiphiya kpwa Dathani na Abiramu na nyo atumia a Iziraeli achimlunga-lunga. ");
INSERT INTO dig_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Achiaambira nyo atu, “Sengerani kure na mahema ga aha atu ayi na msigute chitu chao chochosi, sedze mkaangamizwa kpwa dambi zao zosi.” ");
INSERT INTO dig_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Phahi nyo atu achiphiya kure na mahema ga Kora, Dathani na Abiramu. Dathani na Abiramu achituluka kondze na achiima miryangoni mwa mahema gao phamwenga na achetu ao, ana aho na ana aho atsanga. ");
INSERT INTO dig_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Musa achiamba, “Vivi ndivyo ndivyomanya kukala Mwenyezi Mlungu akanihuma kuhenda gaga mambo gosi na kukala sigahendere kpwa kulonda kpwangu mwenye. ");
INSERT INTO dig_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Atu aha achifwa chifo cha kawaida, au achiphahwa ni mambo ga kawaida gaaphahago atu, phahi Mwenyezi Mlungu andakala kanihumire. ");
INSERT INTO dig_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Ela Mwenyezi Mlungu achihenda dzambo dziphya ambaro taridzangbwehendeka, na tsi ifwenuke dza kanwa iamize phamwenga na vitu vyao, na atserere kuzimu kuno achere moyo, phahi mundamanya kukala atu aha akamʼbera Mwenyezi Mlungu.” ");
INSERT INTO dig_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Musa ariphomala kugomba go maneno tu, pho ambapho Dathani na Abiramu kala aimire phaahuka. ");
INSERT INTO dig_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Na yo tsi ichifwenuka dza kanwa ichiamiza phamwenga na abari aho yani afuasi a Kora ariokala phapho na vitu vyao vyosi. ");
INSERT INTO dig_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Phahi aho phamwenga na vitu vyao vyosi achivoromoka kuzimu kuno achere moyo. Tsi ichiabwiningiza na achiangamizwa kula kahi ya mkpwutano. ");
INSERT INTO dig_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Aiziraeli osi ariokala phephi nao achimbira ariphoasikira anarira, mana aamba, “Sedze yo tsi ikahumiza piya swiswi!” ");
INSERT INTO dig_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Chisha moho wala kpwa Mwenyezi Mlungu na uchiaocha nyo atu magana mairi na mirongo mitsano ariokala anafukiza uvumba. ");
INSERT INTO dig_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Bada ya higa Mwenyezi Mlungu achigomba na Musa achimuamba, ");
INSERT INTO dig_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Muambire Eliazari mwana wa mlavyadzi-sadaka Aruni ahale vyo vyetezo kula kahi ya pho phatu phariphophya nyo atu mana ni vitakatifu chisha higo makala mkagamwage kure. ");
INSERT INTO dig_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Vihaleni vyo vyetezo vya aha atu arioolagbwa kpwa dambi zao enye, mvibande-bande muvitengeze vikale dza mfwiniko, ndizohumirwa kubwiningizira phatu pha kulavira sadaka, mana avireha mbere za Mwenyezi Mlungu, vichikala vitakatifu. Navyo vindakala ishara kpwa Aiziraeli.” ");
INSERT INTO dig_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Phahi mlavyadzi-sadaka Eliazari achihala vira vyetezo vya shaba vyokala vikarehwa ni hara atu ariokala akaochwa, navyo vichitengezerwa mfwiniko wa kubwiningizira phatu pha kulavira sadaka, ");
INSERT INTO dig_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","ili viatambukize Aiziraeli kukala takuna mutu yeyesi ariye si wa chivyazi cha Aruni ndiyesengera kumfukizira Mwenyezi Mlungu uvumba, sedze akakala dza Kora na afuasie. Eliazari wahenda kama arivyolagizwa ni Mwenyezi Mlungu kutsupira Musa. ");
INSERT INTO dig_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Siku ya phiriye, Aiziraeli osi arurumikira Musa na Aruni achiamba, “Mukaolaga atu a Mwenyezi Mlungu.” ");
INSERT INTO dig_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Ela nyo atu ariphokala akakusanyika kupinga Musa na Aruni, ariphogaluka kulola hema ra mkpwutano, gafula ro hema rabwiningizwa ni ingu na utukufu wa Mwenyezi Mlungu uchitsembuka. ");
INSERT INTO dig_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Chisha Musa na Aruni achedza mbere za hema ra mkpwutano, ");
INSERT INTO dig_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","naye Mwenyezi Mlungu achigomba na Musa achiamba, ");
INSERT INTO dig_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Dzitengeni na atu aha ili niaangamize mara mwenga.” Ela Musa na Aruni achidzibwaga chimabumabu. ");
INSERT INTO dig_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Chisha Musa achimuambira Aruni, “Hala chetezocho cha kufukizira, uchitiye uvumba na moho kula phatu pha kulavira sadaka, chisha uphiye nao mairo kpwa nyo atu na uahendere upatanisho kpwa kuausira dambi, mana Mwenyezi Mlungu akaatsukirirwa na mashaka gakaandza.” ");
INSERT INTO dig_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Phahi Aruni wahenda dza arivyoambirwa ni Musa na achiphiya mairo hadi kahi-kahi ya ro kusanyiko ra atu phatu ambapho shaka kala rikaandza kuaphaha. Achifukiza uvumba na achiapatanisha nyo atu na Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Achiima kahi-kahi ya atu ariofwa na ario moyo na pigo richisika. ");
INSERT INTO dig_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Arioolagbwa ni ro shaka kala ni atu elufu kumi na ne na magana sabaa, mbali na hara ariofwa wakati wa uasi wa Kora. ");
INSERT INTO dig_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Shaka ririphosira, Aruni achiuya kpwa Musa pho phatu pha kumenyera hema ra mkpwutano. ");
INSERT INTO dig_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Mwenyezi Mlungu wagomba na Musa achimuamba, ");
INSERT INTO dig_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Aambire Aiziraeli akuphe ndata kumi na mbiri, chilongozi wa chila mbari, ndata mwenga. Andika dzina ra chila chilongozi dzulu ya ndataye. ");
INSERT INTO dig_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Dzulu ya ndata ya mbari ya Lawi undaandika dzina ra Aruni, mana chila chilongozi wa mbari ni akale na ndata mwenga. ");
INSERT INTO dig_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Nawe undahala zo ndata uziike ndani ya hema ra mkpwutano mbere ya sanduku ra chilagane, phatu hunaphokutana mimi na mwimwi. ");
INSERT INTO dig_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Na ndata ya mutu nriyemtsambula indatsephula. Kpwa njira ihi nindasisa kururumika kpwa Aiziraeli ambako anakururumikirani.” ");
INSERT INTO dig_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Phahi Musa wagomba na Aiziraeli, na nyo vilongozi aho amupha chila mmwenga ndataye kulengana na mbariye, zosi zakala ndata kumi na mbiri. Kahi ya zo ndata za vilongozi kpwakala na ndata ya Aruni. ");
INSERT INTO dig_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Musa achiika zo ndata mbere za Mwenyezi Mlungu ndani ya hema ra ushaidi. ");
INSERT INTO dig_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Siku ya phiriye Musa ariphomenya ndani ya hema ra ushaidi, ndata ya Aruni kula mbari ya Lawi kala ikatsephula makodza matsanga, ikabumula maruwa na kuvyala matunda maivu ga mlozi. ");
INSERT INTO dig_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Chisha Musa achizihala zo ndata zosi kula mbere za Mwenyezi Mlungu na achiziika mbere za Aiziraeli osi, nao achizilola na chila chilongozi achihala ndataye. ");
INSERT INTO dig_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Chisha Mwenyezi Mlungu achigomba na Musa achimuamba, “Yiuyize yo ndata ya Aruni mbere ya sanduku ra chilagane, kpwa ikale ushaidi kpwa aasi, ili usise ko kururumika kpwao arikonirurumikira, sedze akafwa.” ");
INSERT INTO dig_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Musa achihenda vira arivyolagizwa ni Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Aiziraeli achimuambira Musa, “Lola, sambi! Hunafwa! Hunaangamia! Hosi hunaangamia! ");
INSERT INTO dig_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Mutu yeyesi ndiyesengerera hema ra Mwenyezi Mlungu andafwa. Vino tahundafwa hosi bu?” ");
INSERT INTO dig_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Mwenyezi Mlungu achimuambira Aruni, “Uwe na anao phamwenga na atu a mbariyo mundaisabiwa kukala akosa kpwa mai ndigohenderwa Phatu Phatakatifu. Ela ndioisabiwa kukala akosa kpwa mai ndigohenderwa ulavyadzi-sadaka ni uwe na anao machiyenu. ");
INSERT INTO dig_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Phahi aambire atu a mbariyo, yani Alawi edze ili mugbwirane na akuteryeni wakati uwe na anao munahumika kahi ya hema ra ushaidi. ");
INSERT INTO dig_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Andakuhumikira na ahende kazi zao zosi za pho hemani. Ela ni asisengerere miyo iriyo ndani ya Phatu Phatakatifu wala phatu pha kulavira sadaka sedze mkafwa phamwenga nao. ");
INSERT INTO dig_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Ni agbwirane namwi, na kazi yao indakala ni kuimirira hema ra mkpwutano na kazi zosi za hemani, na kusikale na mutu wanjina yeyesi ndiyekusengererani. ");
INSERT INTO dig_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“Uwe na anao mundahumika ndani ya pho Phatu Phatakatifu na phatu pha kulavira sadaka sedze Mwenyezi Mlungu akaatsukirirwa tsona Aiziraeli. ");
INSERT INTO dig_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Mimi mwenye ndimi niriyeatsambula ndugu zenu, yani Alawi kula kahi za Aiziraeli. Aho ni zawadi kpwenu, ariotengbwa kpwa ajili ya Mwenyezi Mlungu, ili ahumike kahi za hema ra mkpwutano. ");
INSERT INTO dig_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Ela uwe na anao tu, ndimwi ndiohenda kazi ya ulavyadzi-sadaka, mundaimirira chila chitu cha pho phatu pha kulavira sadaka na ndani ya paziya. Nakuphani ulavyadzi-sadaka dza zawadi, mutu wanjina yeyesi ndiyesengerera pho Phatu Phatakatifu ni aolagbwe.” ");
INSERT INTO dig_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Mwenyezi Mlungu achigomba na Aruni achimuamba, “Nikakuika ukale muimirizi wa sadaka nireherwazo, mtsango wa vitu vyosi vitakatifu nireherwavyo ni Aiziraeli, nkakupha uwe na anao ili vikale mtaloo ta kare na kare. ");
INSERT INTO dig_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Mundahala seemu ya sadaka takatifu zaidi ambayo taiocherwe kula kpwa sadaka zosi takatifu sana anireherazo, zikale ni za mtsere, za kuusa dambi au za kuusa makosa, hizo zindakala seemu yenu phamwenga na ana enu. ");
INSERT INTO dig_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Iryeni dza seemu iriyo takatifu zaidi, chila mlume anaweza kurya seemu hiyo, nayo ni muiharire kukala takatifu kpwenu. ");
INSERT INTO dig_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“Vitu vyanjina ndivyovihala ni hivi: chochosi chotengbwa kula kpwa zawadi za sadaka za kuunulwa za Aiziraeli, nakupha uwe na anao alume na achetu ikale mtalo wenu ta kare na kare. Chila mutu wa nyumbayo ambaye si najisi anaweza kurya vitu hivi. ");
INSERT INTO dig_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“Ninakuphani mavuno gosi ga kpwandza ambago Aiziraeli anamlavira Mwenyezi Mlungu, ga mafuha gosi manono-manono ga zaituni, ga uchi muphya na ga mtsere. ");
INSERT INTO dig_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Mavuno gosi ga kpwandza ga minda yao anagomrehera Mwenyezi Mlungu, gandakala genu. Chila mutu wa nyumbayo ambaye si najisi anaweza kurya. ");
INSERT INTO dig_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Chila chitu chirichotengbwa kpwa ajili ya Mwenyezi Mlungu mumu Iziraeli chindakala chenu. ");
INSERT INTO dig_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Chila mwana yevyalwa kpwandza wa mwanadamu au nyama ndiyelavirwa Mwenyezi Mlungu andakala wenu. Ela ni mkombole chila mwana yevyalwa kpwandza akale ni wa mwanadamu au wa nyama asiye swafi. ");
INSERT INTO dig_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Na nyo avyalwa a kpwandza a chilume ni akombolwe wakati ana umuri wa mwezi mmwenga na maripho gao gandakala vipande vitsano vya feza ambapho chipande chimwenga ni sawa na gera mirongo miiri kulengana na vipimo vya Phatu Phatakatifu. ");
INSERT INTO dig_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“Ela ni msikombole avyalwa a kpwandza a ngʼombe, ngʼondzi wala mbuzi kpwa kukala ni atakatifu. Undamwaga-mwaga milatso yao pande zosi ne za phatu pha kulavira sadaka na kuocha marunya gao dza zawadi yenye kungu nono imuhamirayo Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Nyama za nyama aha zindakala zako, dza laga na chiga cha kulume vilaviwavyo dza sadaka ya kuunulwa. ");
INSERT INTO dig_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Sadaka zosi za kuunulwa kahi ya sadaka zo takatifu ndizorehwa mbere za Mwenyezi Mlungu ni Aiziraeli, ninakupha uwe phamwenga na anao alume na achetu ikale mtalo wenu ta kare na kare. Ni chilagane cha munyu yani ambacho tachivundzika hata kare na kare mbere za Mwenyezi Mlungu, kpwako uwe na chivyazicho.” ");
INSERT INTO dig_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Chisha Mwenyezi Mlungu achimuambira Aruni, “Uwe kundakala na urisi kahi ya yo tsi, wala kundakala na mtalo kahi ya Aiziraeli. Mimi ndimi mtaloo na urisio kahi yao. ");
INSERT INTO dig_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“Ninaapha Alawi mafungu gosi ga kumi mo Iziraeli gakale mtalo wao. Na gandakala ndigo maripho gao kpwa kuhumika kpwao kahi za hema ra mkpwutano. ");
INSERT INTO dig_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Kuandzira sambi na kpwenderera Aiziraeli anjina ni asisengerere tsona hema ra mkpwutano sedze akatsukula lawama ra dambi zao, akafwa. ");
INSERT INTO dig_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Ela nyo Alawi andahumika kahi za ro hema ra mkpwutano na andatsukula lawama ra makosa gao. Lagizo riri rindadumu hata kare na kare kahi ya vivyazi vyenu vyosi. Aho taandakala na urisi wowosi kahi za Aiziraeli. ");
INSERT INTO dig_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Kpwa kukala nikaapha Alawi mafungu ga kumi galaviwago sadaka mbere za Mwenyezi Mlungu ni Aiziraeli kukala mtalo wao, phahi, nikaambira kukala taandakala na urisi kahi za Aiziraeli.” ");
INSERT INTO dig_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Chisha Mwenyezi Mlungu achigomba na Musa achiamba, ");
INSERT INTO dig_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Undaambira Alawi: Mphokerapho ro fungu ra kumi ambaro nakuphani dza mtalo kula kpwa Aiziraeli, ni mumlavire Mwenyezi Mlungu fungu ra kumi ra vitu hivyo. ");
INSERT INTO dig_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Mitsango yenu ambayo mundailavya indaisabiwa dza mtsere kula phatu pha kuwagira mtsere au dza uchi muphya kula phatu pha kuminyira zabibu. ");
INSERT INTO dig_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Phahi, mwimwi namwi piya mundamlavira Mwenyezi Mlungu sadaka kula kpwa mafungu ga kumi gosi mgaphokerago kula kpwa Aiziraeli. Ni mumuphe mlavyadzi-sadaka Aruni iyo seemu ya Mwenyezi Mlungu (mafungu ga kumi). ");
INSERT INTO dig_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Ni mumtengere vitu vinono zaidi na virivyo vitakatifu zaidi kpwa ajili ya Mwenyezi Mlungu kula kpwa vitu vyosi mundivyohewa. ");
INSERT INTO dig_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“Aambire nyo Alawi: Ndiphotenga vitu vinono zaidi, phahi vyo vyanjina vindakala vyenu dza mavuno ga phatu pha kuwagira mtsere na dza mavuno ga phatu pha kuminyira zabibu. ");
INSERT INTO dig_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Mwimwi na atu a nyumbani mwenu munaweza kurya ndivyokala vikasala phatu phophosi mana ni maripho genu kpwa kuhumika kahi za hema ra mkpwutano. ");
INSERT INTO dig_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Napho mkalavya seemu nono zaidi ya mafungu ga kumi mundakala tamuna makosa dzulu ya dzambo hiro. Ela musivitiye najisi vitu vitakatifu vya Aiziraeli, sedze mkafwa.” ");
INSERT INTO dig_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Mwenyezi Mlungu wagomba na Musa na Aruni achiamba, ");
INSERT INTO dig_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Hino ndiyo amuri ya shariya ambayo Mwenyezi Mlungu akalagiza: Aambire Aiziraeli akurehere ndama ya kundu isiyo na chirema yoyosi, na ambayo taidzangbwefungbwa gogolo. ");
INSERT INTO dig_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Ni muirehe kpwa mlavyadzi-sadaka Eliazari, nayo indaphirikpwa kondze ya kambi na kuko ni itsindzwe mbereze. ");
INSERT INTO dig_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Ye mlavyadzi-sadaka Eliazari ni adyoge na chala seemu ya milatso ya yo ndama, na aitimvye-timvye kano sabaa kpwerekeza mbere za hema ra mkpwutano. ");
INSERT INTO dig_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Chisha yo ndama ni iochwe mbereze phamwenga na chingoye, nyamaye, milatsoye na ufumbawe. ");
INSERT INTO dig_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Alafu ye mlavyadzi-sadaka andahala chipande cha muhi wa muerezi, na chiphungo cha muhisopo, na nyoya za kundu za mangʼondzi, avitsuphe mohoni, moho uochao yo ndama. ");
INSERT INTO dig_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Bada ya higo, ye mlavyadzi-sadaka ni afule nguwoze na aoge, ndipho akale anaweza kpwedza kambini, ela andakala najisi hadi dziloni. ");
INSERT INTO dig_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Ye mutu ndiyeocha yo ndama piya ni afule nguwoze na aoge, naye andakala najisi hadi dziloni. ");
INSERT INTO dig_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“Chisha mutu ariye swafi ni azole ro ivu ra yo ndama akarimwage phatu phaswafi kondze ya kambi. Ro ivu rindaikpwa ni Aiziraeli ili rihumirwe kutengeza madzi ga utakaso. Rindakala ra kuausira atu najisi. ");
INSERT INTO dig_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Ye mutu ndiyekusanya ivu ra yo ndama ni afule nguwoze naye andakala najisi hadi dziloni. Hiri rindakala lagizo ra kudumu kpwa Aiziraeli na ajeni asagalao phamwenga nao. ");
INSERT INTO dig_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“Mutu yeyesi ndiyeguta lufu andakala najisi kpwa siku sabaa. ");
INSERT INTO dig_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Iye ni atakaswe na go madzi ga utakaso siku ya hahu na siku ya sabaa ndipho akale swafi. Ela asiphotakaswa siku ya hahu na siku ya sabaa, kandakala swafi. ");
INSERT INTO dig_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Mutu yeyesi ndiyeguta lufu na asitakaswe, andanajisi hema ra Mwenyezi Mlungu naye ni atengbwe na Aiziraeli. Mutu iye andasala kukala najisi kpwa sababu bado kadzangbwetimvirwa-timvirwa madzi ga utakaso. ");
INSERT INTO dig_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“Ihi ndiyo shariya ndiyohumirwa napho mutu akafwa ndani ya hemare: Chila mutu ariye mo hemani na ndiyemenya andakala najisi kpwa siku sabaa. ");
INSERT INTO dig_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Na mwiyo wowosi urio laza bila ya mfwiniko undakala najisi. ");
INSERT INTO dig_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“Mutu yeyesi ko weruni ndiyeguta mutu achiyeolagbwa na upanga, au achiyefwa mwenye, au mfupha wa mutu au mbira andakala najisi kpwa siku sabaa. ");
INSERT INTO dig_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“Kuhusu kumuusira najisi mutu ariye najisi, ni muhale mwiyo mtiye seemu ya ivu ra sadaka ya kuochwa ya utakaso, na mritsanganye na madzi swafi ga muhoni gajerago. ");
INSERT INTO dig_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Alafu mutu ariye swafi ni ahale chiphungo cha muhisopo, achitiye madzini, na atimvire-timvire ro hema, miyo yosi na atu osi ndiokala mumo. Piya ni atimvire-timvire chila mutu ndiyekala akaguta mfupha wa mutu au mwiri wa mutu ariyeolagbwa, au ariyefwa mwenye, au mbira. ");
INSERT INTO dig_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Ye mutu ariye swafi ni amtimvire-timvire ye ariye najisi siku ya hahu na siku ya sabaa, naye andatakasika siku ya sabaa. Na iye mutu ndiyetakaswa ni afule nguwoze na aoge, na ichifika dziloni andakala swafi. ");
INSERT INTO dig_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Ela mutu ariye najisi achirema kutakaswa, ni atengbwe na Aiziraeli, kpwa sababu akanajisi hema ra Mwenyezi Mlungu. Mutu hiye ni najisi kpwa sababu katimvirirwe madzi ga utakaso. ");
INSERT INTO dig_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Hino indakala shariya yao ta kare na kare. Ye mutu ndiyetimvya go madzi ga utakaso ni afule nguwoze, na yeyesi ndiyeguta go madzi ga utakaso andakala najisi ta dziloni. ");
INSERT INTO dig_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Chitu chochosi ndichogutwa ni mutu ariye najisi chindakala najisi, na yeyesi ndiyechiguta andakala najisi hadi dziloni.” ");
INSERT INTO dig_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Kahi ya mwezi wa kpwandza, Aiziraeli osi afika jangbwa ra Sini na achichita kambi yao phephi na mudzi uihwao Kadeshi. Miriamu wafwa na achizikpwa kuko. ");
INSERT INTO dig_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Pho phatu ariphochita kambi kala taphana madzi, kpwa hivyo atu achigbwirana kumpinga Musa na Aruni. ");
INSERT INTO dig_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Achiheha na Musa achimuamba, “Baha kala hwafwa phamwenga na ndugu zehu ariofwa mbere za Mwenyezi Mlungu! ");
INSERT INTO dig_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Ni kpwa utu wani swino atu a Mwenyezi Mlungu waureha jangbwani? Dze, waureha ili hufwe phamwenga na mifugo yehu? ");
INSERT INTO dig_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Kpwa utu wani wahutuluza kula Misiri na kuhureha phatu phai namuna hino? Phatu hipha taphamera mtsere, tini, zabibu, makomamanga na taphana madzi ga kunwa.” ");
INSERT INTO dig_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Musa na Aruni achiuka pho phariphokala na atu, achiphiya hadi phatu pha kumenyera hema ra mkpwutano, achidzibwaga chimabumabu na utukufu wa Mwenyezi Mlungu uchiatsembukira. ");
INSERT INTO dig_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Mwenyezi Mlungu achigomba na Musa achimuamba, ");
INSERT INTO dig_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Hala yo ndata, chisha uwe na Aruni muakusanye phamwenga Aiziraeli osi. Na ugombe na nyo mwamba urio mbere zao, nao undatuluza madzi. Kpwa njira ihi undahenda mwamba utuluze madzi, ili atu osi na nyama aho anwe.” ");
INSERT INTO dig_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Phahi Musa wahala yo ndata kula mbere za Mwenyezi Mlungu, dza arivyolagizwa. ");
INSERT INTO dig_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Musa na Aruni achiakusanya atu osi mbere za nyo mwamba na Musa achiaambira, “Hegani masikiro musikire mwi aasi, dze, ni lazima hukutuluzireni madzi kula mwamba uhu?” ");
INSERT INTO dig_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Chisha Musa achiunula mkpwonowe na achipiga nyo mwamba kano mbiri na yo ndata yokala mwakpwe mkpwononi. Madzi manji gachituluka, na nyo atu phamwenga na mifugo yao achinwa. ");
INSERT INTO dig_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Ela Mwenyezi Mlungu achimuambira Musa na Aruni, “Kpwa kukala tamukanikuluphira vya kutosha kpwa kuniishimu, na kuonyesa nirivyo mtakatifu mbere za Aiziraeli, phahi tamundaafisa atu aha kpwenye yo tsi niriyoapa kuapha.” ");
INSERT INTO dig_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Higa ni madzi ga Meriba, kpwa sababu Aiziraeli aheha na Mwenyezi Mlungu, naye achidzionyesa kukala mtakatifu kahi yao. ");
INSERT INTO dig_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Musa wahuma ajumbe kula Kadeshi aphiye kpwa mfalume wa Edomu, akamuambire, “Nduguyo Iziraeli anaamba hivi: Uwe unamanya zo tabu zosi zirizouphaha. ");
INSERT INTO dig_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Vira ambavyo akare ehu aphiya Misiri na huchisagala kuko kpwa muda mure, na Amisiri achihugayisa swiswi na akare ehu. ");
INSERT INTO dig_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Ela huriphomririra Mwenyezi Mlungu, achihusikira, achihuma malaika na achihutuluza Misiri. Vi sambi huphapha Kadeshi, mudzi urio muphakani mwa tsiiyo. ");
INSERT INTO dig_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Hunakuvoya uhuruhusu hutsupire kahi ya tsiiyo. Tahundatsupira na mindani, minda ya mizabibu wala kunwa madzi ga chisima chochosi. Hundatsupira na njira kulu ya mfalume, bila ya kubeta uphande wa kulume wala wa kumotso hadi hundiphotuluka tsiiyo.” ");
INSERT INTO dig_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Ela mfalume wa Edomu achimjibu achiamba, “Mwimwi msitsupe na himu, na mchijeza tu, hundatuluka hukushambuliyeni na upanga.” ");
INSERT INTO dig_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Aiziraeli achimuambira, “Hundalunga njira kulu, na ichikala swiswi au mifugo yehu indanwa madzigo, hundakuripha. Hunakuvoya uhuruhusu hutsupe na magulu.” ");
INSERT INTO dig_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Ela ye mfalume wa Edomu achiajibu achiamba, “Tahundakuruhusuni bii.” Phahi jeshi kulu ra Aedomu renye mkpwotse richituluka kpwedzapigana na Aiziraeli. ");
INSERT INTO dig_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Kpwa kukala Aedomu aakahaza Aiziraeli kutsupa kahi ya tsi yao, Aiziraeli agaluka na achihumira njira yanjina. ");
INSERT INTO dig_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Chisha Aiziraeli osi achiuka kula Kadeshi, achiphiya hadi mwango wa Hori, ");
INSERT INTO dig_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","urio phephi na mphaka wa tsi ya Edomu. Phapho Mwenyezi Mlungu achigomba na Musa na Aruni achiamba, ");
INSERT INTO dig_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Aruni andafwa. Iye kandainjira yo tsi ambayo nindaapha Aiziraeli kpwa kukala mwimwi mosi airi tamlungire lagizo rangu hiko kpwenye madzi ga Meriba. ");
INSERT INTO dig_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Hala Aruni na mwanawe Eliazari, uambuke nao mwango wa Hori. ");
INSERT INTO dig_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Chisha, mvule Aruni nguwoze za ulavyadzi-sadaka na umvwise mwanawe Eliazari, mana Aruni andafwa kuko.” ");
INSERT INTO dig_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Phahi Musa wahenda dza arivyolagizwa ni Mwenyezi Mlungu. Nao achiambuka mwango wa Hori kuno Aiziraeli osi analola. ");
INSERT INTO dig_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Musa achimvula Aruni nguwoze na achimvwisa mwanawe Eliazari. Naye Aruni achifwa kuko dzulu ya mwango. Bada ya higo Musa na Eliazari atserera kula dzulu ya mwango. ");
INSERT INTO dig_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Aiziraeli osi ariphomanya kukala Aruni akafwa, amsononekera kpwa siku mirongo mihahu. ");
INSERT INTO dig_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Mfalume mmwenga Mkanani wa mudzi wa Aradi yekala achisagala uphande wa mwakani wa tsi ya Kanani ariphosikira kukala Aiziraeli aredza na njira ya Atharimu, achiavamia na achihala anjina aho mateka. ");
INSERT INTO dig_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Chisha Aiziraeli achiika naziri mbere za Mwenyezi Mlungu achiamba, “Ichikala undaatiya atu aha mwehu mikononi, phahi hundaangamiza midzi yao tsetsetse.” ");
INSERT INTO dig_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Mwenyezi Mlungu achisikira mavoyo ga Aiziraeli na achiatiya Akanani mwao mikononi nao achiaangamiza tsetsetse aho phamwenga na midzi yao. Phahi phatu hipho phachiihwa Horima. ");
INSERT INTO dig_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Aiziraeli achiuka kula mwango wa Hori, achiphiya na njira ya Bahari ya Shamu ili aizunguluke tsi ya Edomu, ela nyo atu achisinywa mo njirani, ");
INSERT INTO dig_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","achiandza kururumikira Mlungu na Musa achiamba, “Ni kpwa utu wani mwahutuluza Misiri hwedze hufwe hiku jangbwani? Mana hiku takuna chakurya wala madzi, na hukasinywa ni chakurya hichi ambacho tachina mana.” ");
INSERT INTO dig_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Phapho Mwenyezi Mlungu achiahumira Aiziraeli nyoka za sumu kali nao achiondzwa na anji aho achifwa. ");
INSERT INTO dig_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Phahi nyo atu achedza kpwa Musa achimuamba, “Swiswi hwahenda dambi kpwa kururumikira Mwenyezi Mlungu phamwenga na uwe. Mvoye Mwenyezi Mlungu ahuusire nyoka aha.” Kpwa hivyo Musa achiavoyera nyo atu. ");
INSERT INTO dig_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Mwenyezi Mlungu achigomba na Musa achimuamba, “Tengeza nyoka ya shaba na uigbwadzike dzulu ya chatsi. Mutu yeyesi ndiyeondzwa ni nyoka, achilola yo nyoka ya shaba, andakala moyo.” ");
INSERT INTO dig_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Phahi Musa achitengeza nyoka ya shaba na achiigbwadzika dzulu ya chatsi. Ichikala chila mutu ariyeondzwa ni nyoka aripholola yo nyoka ya shaba, wakala moyo. ");
INSERT INTO dig_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Aiziraeli achienderera na charo chao na achendachita kambi Obothi. ");
INSERT INTO dig_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Chisha achituluka Obothi na achendachita kambi Iye-Abarimu, mudzi urio jangbwa rinarophakana na Moabu uphande wa mlairo wa dzuwa. ");
INSERT INTO dig_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Kula phapho auka na achendachita kambi Dete ra Zeredi. ");
INSERT INTO dig_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Chisha achiuka phapho na achendachita kambi kahi ya jangbwa rokala uphande wa vurini wa muho Arinoni. Muho Arinoni ndio mphaka wa tsi ya Moabu na ya Amori. ");
INSERT INTO dig_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Kpwa sababu hiyo, chitabu cha viha vya Mwenyezi Mlungu chinaamba, “Mudzi wa Wahebu urio kahi ya tsi ya Sufa na madete, Arinoni, ");
INSERT INTO dig_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","na miteremuko ya madete ifikayo hadi mudzi wa Ari, na kuphiya hadi mphaka wa Moabu.” ");
INSERT INTO dig_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Kula phapho achiphiya hadi Beeri, yani chisima ambacho Mwenyezi Mlungu wamuambira Musa, “Akusanye phamwenga nyo atu, nami nindaapha madzi.” ");
INSERT INTO dig_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Phapho Aiziraeli achiimba wira hinyu: “We chisima, lavya madzi! Imbani kuhusu chisima chichi. ");
INSERT INTO dig_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Chisima chirichotsimbwa ni akulu, chirichotsimbwa ni vilongozi a nyo atu, kuhumira ndata zao.” Na achiuka kula kahi ya jangbwa hiro achiphiya Matana, ");
INSERT INTO dig_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","kula Matana achiphiya hadi Nahalieli na kula Nahalieli achiphiya hadi Bamothi. ");
INSERT INTO dig_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Na kula Bamothi achiphiya hadi dete ririro kahi ya tsi ya Moabu, phatu pharipho chirere cha mwango Pisiga chinalolana na jangbwa. ");
INSERT INTO dig_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Chisha Aiziraeli achihuma ajumbe kpwa Sihoni, mfalume wa Aamori achiamba, ");
INSERT INTO dig_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Hunakuvoya uhuruhusu hutsupire kahi ya tsiiyo, tahundaaphuka kuinjira mindani, minda ya mizabibu, wala kunwa madzi ga chisima chochosi. Hundatsupa na njira kulu ya mfalume hadi hutuluke tsiiyo.” ");
INSERT INTO dig_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Ela mfalume Sihoni achirema. Naye achikusanya jeshire rosi, achiphiya hiko jangbwani kushambuliya Aiziraeli. Ariphofika phatu phoihwa Jahazi wapigana na nyo Aiziraeli. ");
INSERT INTO dig_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Ela nyo Aiziraeli achimuolaga kpwa upanga, na achihala yo tsiiye kula muho Arinoni hadi muho Jaboki na kpwenderera hadi muphakani mwa tsi ya Aamoni, mana iyo miphaka kala ikadzengerwa kuta. ");
INSERT INTO dig_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Aiziraeli ateka midzi yosi ya Aamori hata Heshiboni na vidzidzivye vyosi na achisagala mumo. ");
INSERT INTO dig_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Heshiboni wakala ni mudzi mkpwulu wa Sihoni, mfalume wa Aamori. Sihoni kala akapigana na mfalume mmwengawapho ariyetawala Moabu na achiihala tsiiye yosi hadi muho wa Arinoni. ");
INSERT INTO dig_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Ndiyo mana atungi a mashairi nkuamba, “Ndzoni Heshiboni, na muudzenge tsona, mudzi wa Sihoni uimarishwe na uikpwe mazubuti. ");
INSERT INTO dig_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Mana kpwaaka moho kula Heshiboni, moho kula mudzi wa Sihoni. Uchiocha Ari, mudzi wa Moabu, na uchiangamiza vilongozi a vidzango vyokala kanda-kanda ya muho Arinoni. ");
INSERT INTO dig_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Undamanya mwenye uwe Moabu! Mkaangamizwa mwimwi muabuduo Kemoshi! Akaahenda ana enu alume kukala achimbizi, na ana enu achetu ahalwe mateka, ni Sihoni mfalume wa Aamori. ");
INSERT INTO dig_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Ela vivi vivyazi vyenu vikaangamizwa, kula Heshiboni hadi Diboni, chisha hukaabananga osi kufikira Nofa na Medeba.” ");
INSERT INTO dig_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Phahi Aiziraeli asagala kahi ya tsi ya Aamori. ");
INSERT INTO dig_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Bada ya Musa kuhuma apelelezi kuupeleleza mudzi wa Jazeri, Aiziraeli auteka phamwenga na vidzidzivye na achiazola Aamori ariokala anasagala mumo. ");
INSERT INTO dig_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Chisha nyo Aiziraeli achigaluza njira achiambuka na njira ya kuphiya Bashani. Naye Ogi mfalume wa Bashani achituluka na jeshire kpwendapigana ko Edirei. ");
INSERT INTO dig_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Ela Mwenyezi Mlungu achigomba na Musa achimuamba, “Usimuogophe, mana nikamtiya mwako mikononi, phamwenga na atue na tsiiye. Undamuhenda dza urivyomuhenda Sihoni mfalume wa Aamori, yekala anasagala Heshiboni.” ");
INSERT INTO dig_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Phahi achimuolaga ye mfalume phamwenga na anae alume na jeshire rosi. Taphasarire hata mutu mmwenga, nao achiihala yo tsiiye. ");
INSERT INTO dig_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Chisha Aiziraeli achienderera na charo chao na achendachita kambi kahi ya tsi ya kugbwa ya Moabu iriyo uphande wa mlairo wa dzuwa wa Joridani, yani ngʼambo ya phiri ya nyo muho napho ula Jeriko. ");
INSERT INTO dig_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Balaki mwana wa Sipori wasikira gosi ambago Aiziraeli kala akaahendera Aamori. ");
INSERT INTO dig_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Amoabu achiaogopha Aiziraeli sana mana kala ni anji sana. ");
INSERT INTO dig_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Amoabu achiambira nyo vilongozi a Midiani, “Riri kundi ra atu rindaangamiza chila chitu chirichohuzunguluka, dza viratu ngʼombe iryavyo nyasi weruni.” Balaki mwana wa Sipori kala ndiye mfalume wa Moabu wakati uho, ");
INSERT INTO dig_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","naye achihuma ahumwa kpwa Balaamu mwana wa Beori yekala achisagala Pethori, phephi na muho wa Yufurati kahi ya tsiiye ya kuvyalwa. Balaki achimuamba, “Kuna atu ariola Misiri, nao akatsamukana chila phatu kahi ya tsi, na akedzasagala phephi na pho nikalapho. ");
INSERT INTO dig_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Phahi ninakuvoya wedze unilanire atu aha mana akanizidi mkpwotse, mendzerepho nindaweza kuaturya na kuazoresa kula kahi ya tsi yangu, mana ninamanya kukala yeyesi ndiyemʼbariki andabarikiwa, na yeyesi ndiyemlani andalaniwa.” ");
INSERT INTO dig_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Phahi nyo vilongozi a Moabu na Midiani achihala ro fungu ra kumripha Balaamu na achiuka. Ariphofika kpwa Balaamu achimuambira vira arivyokala akaambirwa ni Balaki. ");
INSERT INTO dig_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Balaamu achiamba, “Lalani phapha rero, nami nindakuambirani gara ambago Mwenyezi Mlungu andaniambira.” Phahi nyo vilongozi a Moabu achikala phamwenga naye. ");
INSERT INTO dig_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Mlungu achimwedzera Balaamu achimuuza, “Ano atu ario phamwenga nawe ni ano ani?” ");
INSERT INTO dig_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balaamu achimjibu Mlungu achimuamba, “Balaki mwana wa Sipori, mfalume wa Moabu wanihumira ujumbe huno: ");
INSERT INTO dig_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘Lola, kukedza atu kula Misiri nao akatsamukana tsi yosi. Vino ndzo unilanire atu aha, mendzerepho nindaweza kupigana nao na niazole.’ ” ");
INSERT INTO dig_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Ela Mlungu achimuambira Balaamu, “Ni usiphiye phamwenga nao, wala usilani Aiziraeli mana ni atu ariobarikiwa.” ");
INSERT INTO dig_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Ligundzure Balaamu walamuka, achiaambira vilongozi a Balaki, “Uyani kpwenu, mana Mwenyezi Mlungu akanikahaza kuphiya phamwenga namwi.” ");
INSERT INTO dig_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Phahi nyo vilongozi a Moabu achiuya kpwa Balaki achendamuamba, “Balaamu akarema kpwedza phamwenga naswi.” ");
INSERT INTO dig_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Chisha Balaki achihuma vilongozi anjina kano ya phiri, anji zaidi tsona enye vyeo kuriko nyo a kpwandza. ");
INSERT INTO dig_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Nao achiphiya kpwa Balaamu, achendamuamba, “Balaki mwana wa Sipori anaamba hivi: ‘Usiriche utu wowosi ukuhende usedze kpwangu, ");
INSERT INTO dig_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","mana nindakuriphato na nindakuhendera chochosi ndichoniambira. Ndzo unilanire atu hinya.’ ” ");
INSERT INTO dig_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Balaamu achiajibu achiamba, “Hata Balaki achinipha nyumbaye iriyoodzazwa feza na zahabu, tsona sindahenda utu wowosi ambao Mwenyezi Mlungu, Mlungu wangu kanilagizire. ");
INSERT INTO dig_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Ela nakuvoyani mlale phapha rero dza vyo anjina arivyohenda ili nimanye ndichoambirwa tsona ni Mwenyezi Mlungu.” ");
INSERT INTO dig_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Usiku uho Mlungu achimtsembukira Balaamu na achimuamba, “Kpwa kukala aha atu akedza kulunga, phiya phamwenga nao, ela henda ndivyokuambira tu.” ");
INSERT INTO dig_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Na kuriphocha, Balaamu watayarisha pundawe na achiphiya phamwenga na nyo vilongozi a Moabu. ");
INSERT INTO dig_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Ela Mlungu watsukirwa sana kpwa kukala Balaamu kala anaphiya. Balaamu ariphokala anaphirika pundawe kuno a phamwenga na atumishie airi, malaika wa Mwenyezi Mlungu achiima pho njirani ili amzuwiye. ");
INSERT INTO dig_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Ye punda ariphoona ye malaika wa Mwenyezi Mlungu aimire pho njirani na kuno akagbwira upanga, achiaphuka achimenya weruni. Balaamu achimpiga ye punda ili auye njirani. ");
INSERT INTO dig_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Chisha ye malaika wa Mwenyezi Mlungu achiima phatu phenye chidzinjira chidide kahi-kahi ya minda ya mizabibu na kuta pande zosi mbiri. ");
INSERT INTO dig_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Ye punda ariphomuona malaika wa Mwenyezi Mlungu achidzifyeha na ukuta, na achifyeha chigulu cha Balaamu pho ukutani. Phahi Balaamu achimpiga tsona ye punda. ");
INSERT INTO dig_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Chisha malaika wa Mwenyezi Mlungu wasengera tsona mbere na achendaima phatu phembamba, phokala taphana nafwasi ya kutsupa uphande wa kulume wala wa kumotso wa ye malaika. ");
INSERT INTO dig_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Ye punda ariphomuona ye malaika wa Mwenyezi Mlungu, achisagala photsi kuno Balaamu achere dzuluye. Balaamu achitsukirwa sana na achimpiga ye punda na ndataye. ");
INSERT INTO dig_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Chisha Mwenyezi Mlungu wamupha ye punda uwezo wa kugomba. Punda achigomba na Balaamu achimuamba, “Nkakuhendani mino hata unipige kano hizi tahu?” ");
INSERT INTO dig_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaamu achimjibu achimuamba, “Ukanihenda mzuzu! Kala nina upanga ningekuolaga vi sambi.” ");
INSERT INTO dig_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Punda naye achimuambira Balaamu, “Avi mino ni pundao ninayekutsukula wakati wosi hata vivi rero? Nákuhendera utu dza huno rini?” Balaamu achiamba, “Hata, bado kudzangbwenihendera utu dza uhu.” ");
INSERT INTO dig_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Chisha Mwenyezi Mlungu achimvugula matso Balaamu, naye achimuona ye malaika wa Mwenyezi Mlungu aimire pho njirani kuno akagbwira upangawe. Balaamu achizama hata chilangu chichiguta photsi. ");
INSERT INTO dig_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Malaika wa Mwenyezi Mlungu achimuuza, “Mbona ukampiga pundao kano zizi tahu? Mimi nikedza nikukahaze ili usiphiye, mana ugahendago ni mai mbere zangu. ");
INSERT INTO dig_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Ye pundao akaniona akanihepa kano hizi tahu, ela kala kanihepere ningekala nkakuolaga na nikamuricha pundao akale moyo.” ");
INSERT INTO dig_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balaamu achimuamba ye malaika wa Mwenyezi Mlungu, “Nkahenda dambi. Simanyire kukala che uimire njirani kunizuwiya. Phahi ichikala ni vii kpwako, ndauya kaya.” ");
INSERT INTO dig_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Malaika wa Mwenyezi Mlungu achimuamba Balaamu, “Phiya phamwenga na nyo atu, ela undagomba tu gara ndigokuambira ugombe.” Phahi Balaamu achiphiya phamwenga na vilongozi a Balaki. ");
INSERT INTO dig_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Balaki ariphosikira kukala Balaamu akedza watuluka kpwendamchinjira ko Ari, mudzi wa Amoabu urio kpwenye mphaka wa Arinoni, kanda-kanda ya tsi ya Amoabu. ");
INSERT INTO dig_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balaki achimuuza Balaamu, “Avi nákulagizira wedze upesi? Mbona kpwedzere? Kpwani kala unaona siweza kukuripha?” ");
INSERT INTO dig_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balaamu achimjibu Balaki achimuamba, “Vivi nikedza, ela sina uwezo wa kugomba rorosi. Ni nigombe ro ndiroambirwa ni Mwenyezi Mlungu bahi.” ");
INSERT INTO dig_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Phahi Balaamu achiphiya phamwenga na Balaki hadi Kiriathi-Husothi. ");
INSERT INTO dig_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Ariphofika hiko, Balaki walavya sadaka ya ngʼombe na ngʼondzi, achiapha seemu Balaamu na nyo vilongozi okala phamwenga naye. ");
INSERT INTO dig_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Ligundzure Balaki waambuka na Balaamu hadi Bamothi-Baali. Kula kuko Balaamu achiweza kuona seemu ya Aiziraeli. ");
INSERT INTO dig_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balaamu achigomba na Balaki achimuamba, “Nidzengera mwatu sabaa mwa kulavira sadaka, na unitayarishire ndzau sabaa na maturume sabaa hipha.” ");
INSERT INTO dig_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balaki wahenda dza arivyoambirwa ni Balaamu, na Balaki na Balaamu achilavya ndzau mwenga na turume mwenga dzulu ya chila phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Chisha Balaamu achimuamba Balaki, “Kala phapha phephi na sadakayo ya kuochwa. Mimi nauka chahi Mwenyezi Mlungu andakpwedza huonane. Chochosi ndichoniambira nindakuambira.” Phahi Balaamu achiphiya phatu pha dzulu phasiphomera chitu. ");
INSERT INTO dig_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Mlungu achikutana naye. Balaamu achigomba na Mlungu achimuamba, “Nikatayarisha kare mo mwatu sabaa mwa kulavira sadaka, na nikalavya ndzau mwenga na turume mwenga dzulu ya chila phatu pha kulavira sadaka.” ");
INSERT INTO dig_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Mwenyezi Mlungu achimupha Balaamu ujumbe, achimuamba, “Uya kpwa Balaki, ukamuambire gara nchigokuambira.” ");
INSERT INTO dig_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Phahi wauya na achendamuona Balaki aimire kanda-kanda ya yo sadakaye ya kuochwa phamwenga na vilongozi osi a Moabu. ");
INSERT INTO dig_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Chisha Balaamu achilavya nyo ujumbe achiamba, “Balaki akanireha kula Aramu, mfalume wa Moabu, akanireha kula myango ya uphande wa mlairo wa dzuwa. Waniamba, ‘Ndzo unilanire Jakobo, ndzo uavoyere mai Iziraeli!’ ");
INSERT INTO dig_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Ela nindaalanidze atu ambao Mlungu kayaalani? Nindaavoyeradze mai atu ambao Mwenyezi Mlungu kaatakira mai? ");
INSERT INTO dig_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Kula kpwenye virere vya myamba ninaona atu, ninaaona kula vidzangoni. Ninaona atu asagalao machiyao, anaodziona kukala atafwauti na mataifa ganjina. ");
INSERT INTO dig_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Atu a chivyazi cha Jakobo ni anji dza vumbi, ni anji ta taphana awezaye kumanya isabu ya robo yao. Richa nifwe chifo dza cha atu ahendao haki, na maisha gangu gafike mwisho dza go gao.” ");
INSERT INTO dig_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balaki achimuambira Balaamu, “Ukanihendadze we? Nákureha unilanire maadui gangu ela badalaye ukaabariki!” ");
INSERT INTO dig_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Balaamu achimjibu achimuamba, “Dze, che nigombe utu ambao Mwenyezi Mlungu kaniambirire niugombe?” ");
INSERT INTO dig_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Chisha Balaki achimuamba Balaamu, “Ndzo huphiye phatu phanjina ambapho undaona achache tu, kundaweza kuaona nyo atu osi. Nawe undanilanira nyo atu kula phapho.” ");
INSERT INTO dig_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Phahi Balaki achimuhala Balaamu achimphirika hadi weru wa Sofimu, dzulu ya mwango wa Pisiga. Hipho achidzenga mwatu sabaa mwa kulavira sadaka, na achilavya sadaka ya ndzau mwenga na turume mwenga dzulu ya chila phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Balaamu achimuamba Balaki, “Ima phapha kanda-kanda ya sadakayo ya kuochwa, nami niphiye kura nkaonane na Mwenyezi Mlungu.” ");
INSERT INTO dig_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Mwenyezi Mlungu achikutana na Balaamu, naye achimupha ujumbe achimuamba, “Uya kpwa Balaki ukamuambire gaga nchigokuambira.” ");
INSERT INTO dig_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Phahi achiuya na achendamuona Balaki aimire kanda-kanda ya yo sadakaye ya kuochwa phamwenga na vilongozi a Moabu. Balaki achimuuza achiamba, “Mwenyezi Mlungu akaambadze?” ");
INSERT INTO dig_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Ndipho Balaamu achilavya ujumbe hinyu achiamba, “Balaki, unuka na uphundze, niphundza uwe mwana wa Sipori. ");
INSERT INTO dig_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Mlungu si mutu, ta agombe handzo, wala si mwanadamu, ta agaluze maazoge. Achiahidi chitu, andachihenda, achigomba utu, andautimiza. ");
INSERT INTO dig_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Nikalagizwa nibariki, iye akabariki, nami siweza kugaluza. ");
INSERT INTO dig_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Iye kadzangbweona uyi wowosi kahi za Jakobo, wala mashaka kahi za Iziraeli. Mwenyezi Mlungu, Mlungu wao a phamwenga nao, akatangaza kukala iye ndiye mfalume wao. ");
INSERT INTO dig_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Mlungu waatuluza Misiri, naye anaapigania dza nyahi. ");
INSERT INTO dig_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Taphana utsai unaoweza kuloga Jakobo, wala muhaso unaoweza kuhumirwa chinyume cha Iziraeli. Atu andaamba kuhusu Jakobo yani Iziraeli, ‘Lolani vyo Mlungu arivyohenda!’ ");
INSERT INTO dig_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Lolani nyo Aiziraeli anaunuka dza simba mchetu, anadziunula dza simba mlume, ambaye kaoya hadi aolage na arye nyama ya ye amuindzaye na kunwa milatsoye.” ");
INSERT INTO dig_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Chisha Balaki achimuamba Balaamu, “Ichikala kundaalani, phahi piya usiabariki.” ");
INSERT INTO dig_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Ela Balaamu achimjibu Balaki achimuamba, “Dze siyakuambira kukala nindahenda chochosi Mwenyezi Mlungu ndichoniambira?” ");
INSERT INTO dig_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Balaki achimuambira Balaamu, “Ndzo, nkuphirike phatu phanjina, chahi Mwenyezi Mlungu andakuruhusu unilanire nyo atu kula phapho.” ");
INSERT INTO dig_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Phahi Balaki achimuhala Balaamu na achiphiya naye hadi dzulu ya mwango wa Peori, phatu ambapho uchikala dzuluze unaweza kuona ro jangbwa. ");
INSERT INTO dig_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balaamu achimuambira Balaki, “Nidzengera mwatu sabaa mwa kulavira sadaka, na unitayarishire ndzau sabaa na maturume sabaa hipha.” ");
INSERT INTO dig_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Phahi Balaki achihenda dza arivyoambirwa ni Balaamu, na achilavya ndzau mwenga na turume mwenga dzulu ya chila phatu pha kulavira sadaka. ");
INSERT INTO dig_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Phahi Balaamu waona kukala inamfwahira Mwenyezi Mlungu kuabariki Aiziraeli, achiamua kusaphiya kuhumira dawa dza vyo arivyohenda pho mwandzo, achigaluza usowe kulola jangbwani. ");
INSERT INTO dig_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Balaamu achilola dzulu na achiona Aiziraeli akachita kambi chila mbari phatuphe. Chisha Roho wa Mlungu achimwedzera, ");
INSERT INTO dig_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","achilavya ujumbe huno achiamba, “Hinyu ni ujumbe wa Balaamu mwana wa Beori, wa mutu ambaye matsoge ganaonato, ");
INSERT INTO dig_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","ujumbe wa mutu asikiraye maneno ga Mlungu, aonaye ruwiya za iye Mwenye Nguvu Zosi, adzibwagaye chimabumabu, ela matsoge ga wazi. ");
INSERT INTO dig_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","‘Mahemago ni manono sana, uwe Jakobo, makalogo ni manono, uwe Iziraeli! ");
INSERT INTO dig_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Gakagota dza madete, dza minda iriyo kanda-kanda ya muho, dza mihi mire iriyophandwa ni Mwenyezi Mlungu, dza mierezi iriyophandwa kanda-kanda ya madzi. ");
INSERT INTO dig_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Madzi gandamwagika kula kpwenye ndoo zao, na vivyazi vyao vindakala dza madzi manji. Mfalume wao andakala mkpwulu kuriko Agagi, na utawala wao undatogolwa. ");
INSERT INTO dig_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Ye Mlungu yeatuluza Misiri, ana mkpwotse dza nyahi. Andaangamiza mataifa ganjina ambago ni maaduige, na kuvundza-vundza mifupha yao. Andaashambuliya na miviye. ");
INSERT INTO dig_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Andanyapa-nyapa na kupweka dza simba, dza simba mchetu, ni ani awezaye kumlamusa? Naabarikiwe yeyesi ndiyekubariki, na alaniwe yeyesi ndiyekulani.’ ” ");
INSERT INTO dig_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Phahi Balaki achitsukizwa sana ni Balaamu, naye achipiga ngumi fumbare kpwa tsukizi na achimuamba, “Nákuiha ulani maadui gangu, ela badalaye ukagabariki kano tahu. ");
INSERT INTO dig_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Náamba nindakuriphato, ela Mwenyezi Mlungu akakuhenda usiphahe zawadi. Sambi, phauke mara mwenga uuye kpwenu!” ");
INSERT INTO dig_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balaamu achimjibu achimuamba, “Dze, siyaambira ajumbe urionihumira kukala, ");
INSERT INTO dig_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘Hata Balaki akanipha nyumbaye iriyoodzazwa feza na zahabu, chisha sindaweza kuphiya chinyume na neno ra Mwenyezi Mlungu na kudzihendera dzambo rorosi nono au iyi. Ni nigombe vira Mwenyezi Mlungu ndivyoniambira?’ ");
INSERT INTO dig_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Phahi vivi ninauya kpwehu, ela kabila sidzangbweuka richa nikuambire chimbere mambo ambago atu aha andaahendera atuo siku zedzazo.” ");
INSERT INTO dig_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Chisha achilavya ujumbe uhu achiamba, “Hinyu ni ujumbe wa Balaamu mwana wa Beori, mutu ambaye matsoge ganaonato, ");
INSERT INTO dig_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","ujumbe wa mutu asikiraye maneno ga Mlungu, na ambaye ana marifwa ga Mlungu Ariye Dzulu Kuriko Vyosi, aonaye ruwiya za iye Mwenye Nguvu Zosi, adzibwagaye chimabumabu, ela matsoge ga wazi. ");
INSERT INTO dig_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Nrigoona kpwenye ruwiya tagadzangbwetimiya. Ela siku mwenga kundatsembuka mfalume dza nyenyezi, kula kpwa Jakobo, fwimbo ya utawala hiko Iziraeli. Iye andakuolagani mwimwi Amoabu, na kuangamiza atu osi a Sethi. ");
INSERT INTO dig_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Hiye andashinda Edomu aitawale, Seiri, aduiwe, andakala maliye, ela Iziraeli indazidi kuphaha mkpwotse. ");
INSERT INTO dig_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Mmwenga kula chivyazi cha Jakobo andatawala, naye andaangamiza ndiosala mo mudzini.” ");
INSERT INTO dig_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Chisha Balaamu achiona Amaleki kpwenye ruwiya na achilavya ujumbe huno achiamba, “Aamaleki kala ndiro taifa ra kpwandza kahi ya mataifa ganjina, ela mwishowe ni kuangamizwa.” ");
INSERT INTO dig_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Chisha Balaamu achiona Akeni, achilavya ujumbe huno achiamba, “Makalo genu ga salama, dza chidzumba cha nyama a mapha chirichodzengbwa dzulu ya mwamba urio gambani. ");
INSERT INTO dig_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Hata hivyo mwimwi Akeni mundaangamizwa, Ashuru ndiphokuhala mateka.” ");
INSERT INTO dig_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Balaamu achilavya ujumbe huno tsona achiamba, “Ni ani awezaye kukala moyo ichikala Mlungu ndiye chiyehenda hivi? ");
INSERT INTO dig_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Meli zindakpwedza kula Kupuro, nazo zindashambuliya Ashuru na Eberi, ela zizo nazo zindaangamizwa.” ");
INSERT INTO dig_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Phahi, Balaamu achiuka na achiuya kpwao, na Balaki naye achiphiya vyakpwe. ");
INSERT INTO dig_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Wakati Aiziraeli ariphokala Shitimu, alume ahenda udiya na achetu a Moabu. ");
INSERT INTO dig_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Achetu aha aalika Aiziraeli kpwenye sharee za kulavira milungu yao sadaka, nao Aiziraeli arya na achiabudu milungu ya Amoabu. ");
INSERT INTO dig_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Phahi Aiziraeli adziunga kuabudu Baali wa Peori, naye Mwenyezi Mlungu achiatsukirirwa sana. ");
INSERT INTO dig_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Mwenyezi Mlungu achigomba na Musa achimuamba, “Gbwira hinyo atu ariolongoza atu kuhenda dzambo hiri, uaolage na uagbwadzike dzulu ya nguzo mutsi mbere zangu, ili tsukizi zangu siru ziaukire Aiziraeli.” ");
INSERT INTO dig_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Phahi Musa wagomba na aamuli a Iziraeli achiaamba, “Chila mmwenga wenu ni aolage atue ariodziunga kuabudu Baali wa Peori.” ");
INSERT INTO dig_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Aiziraeli ariphokala anarira mbere za hema ra mkpwutano, Muiziraeli mmwenga wareha mchetu wa Chimidiani mwakpwe hemani mbere za Musa na kundi rosi ra Iziraeli. ");
INSERT INTO dig_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Finehasi mwana wa Eliazari, mdzukulu wa mlavyadzi-sadaka Aruni ariphoona hivi, wauka pho mkpwutanoni achendahala fumo. ");
INSERT INTO dig_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","Iye achimlunga yuya Muiziraeli mo hemani, achiadunga osi airi. Hiro fumo ramdunga ye Muiziraeli hadi richidunga ye mchetu ndanini. Phahi ro shaka rauswa kula kahi za Aiziraeli. ");
INSERT INTO dig_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Ela atu arioolagbwa ni ro shaka kala ni atu elufu mirongo miiri na ne. ");
INSERT INTO dig_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Badaye Mwenyezi Mlungu achigomba na Musa achimuamba, ");
INSERT INTO dig_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Finehasi mwana wa Eliazari, mdzukulu wa mlavyadzi-sadaka Aruni akanihenda nriche kuatsukirirwa Aiziraeli kpwa kukala iye ana wivu kpwa ajili yangu mimi, kayavumirira kuona atu anahenda dambi. Ndiyo mana siaangamizire Aiziraeli. ");
INSERT INTO dig_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Kpwa hivyo muambire kukala ninamuikira chilagane changu cha amani. ");
INSERT INTO dig_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Ninaika chilagane naye kukala iye na chivyaziche andakala alavyadzi-sadaka ta kare na kare mana iye waahenda Aiziraeli apatanishwe na Mlungu kpwa wivu ariokala nao kpwa ajili ya Mwenyezi Mlungu na kusavumirira kuona atu anahenda dambi.” ");
INSERT INTO dig_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Iye Muiziraeli ariyeolagbwa phamwenga na yuya mchetu Mmidiani kala anaihwa Zimuri mwana wa Salu, yekala chilongozi wa mryango mmwenga kahi ya mbari ya Simioni. ");
INSERT INTO dig_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Na ye mchetu Mmidiani ariyeolagbwa kala anaihwa Kozibi mwana wa Suri, yekala chilongozi wa mbari mwenga hiko Midiani. ");
INSERT INTO dig_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Mwenyezi Mlungu achigomba na Musa achimuamba, ");
INSERT INTO dig_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Aharireni dza maadui nyo Amidiani, na muaangamize, ");
INSERT INTO dig_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","kpwa sababu ya mai arigokuhenderani ariphokuchengani hiko Peori. Na kpwa sababu ya Kozibi, mwana wa chilongozi wa Midiani ariyeolagbwa wakati wa shaka ririrokuphahani ko Peori.” ");
INSERT INTO dig_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Bada ya ro shaka kuuka, Mwenyezi Mlungu wagomba na Musa na mlavyadzi-sadaka Eliazari mwana wa Aruni achiaambira, ");
INSERT INTO dig_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Olangani Aiziraeli osi kulengana na miryango yao a kuandzira miaka mirongo miiri na kpwenderera ario na uwezo wa kuphiya vihani.” ");
INSERT INTO dig_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Musa na mlavyadzi-sadaka Eliazari achigomba nao kahi ya tsi ya kugbwa ya Moabu iriyo kanda-kanda ya muho Joridani, ngʼambo ya phiri napho ula Jeriko, ");
INSERT INTO dig_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","achiaambira, “Halani isabu ya atu a miaka mirongo miiri na kpwenderera, dza Mwenyezi Mlungu arivyomlagiza Musa.” Hichi ni chivyazi cha Aiziraeli ariotuluka kula tsi ya Misiri: ");
INSERT INTO dig_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Kula mbari ya Rubini, yekala mwana mvyere wa chilume wa Iziraeli kala ni: atu a mryango wa Hanoki, atu a mryango wa Palu, ");
INSERT INTO dig_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","atu a mryango wa Hezironi na atu a mryango wa Karimi. ");
INSERT INTO dig_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Atu a mbari ya Rubini arioolangbwa kala ni elufu mirongo mine na tahu na magana sabaa na mirongo mihahu. ");
INSERT INTO dig_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Mwana wa Palu kala ni Eliabu, ");
INSERT INTO dig_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","na ana a Eliabu kala ni Nemueli, Dathani, na Abiramu. Dathani na Abiramu kala ni vilongozi a nyo mkpwutano ariompinga Musa na Aruni na kala ni kahi za nyo afuasi a Kora arioasi Mwenyezi Mlungu, ");
INSERT INTO dig_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","ela tsi ichiahuka ichiamiza. Chihivyo achifwa siku mwenga na Kora na afuasie wakati moho uriphoocha na uchiolaga atu magana mairi na mirongo mitsano, naro richikala fundzo kpwa atu. ");
INSERT INTO dig_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Hata vivyo ana a Kora taolagirwe. ");
INSERT INTO dig_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Atu a mbari ya Simioni kulengana na miryango yao kala ni: atu a mryango wa Nemueli, atu a mryango wa Jamini, atu a mryango wa Jakini, ");
INSERT INTO dig_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","atu a mryango wa Zera na atu a mryango wa Shauli. ");
INSERT INTO dig_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Atu a mbari ya Simioni arioolangbwa kala ni elufu mirongo miiri na mbiri na magana mairi. ");
INSERT INTO dig_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Atu a mbari ya Gadi kulengana na miryango yao kala ni: atu a mryango wa Sefoni, atu a mryango wa Hagi, atu a mryango wa Shuni, ");
INSERT INTO dig_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","atu a mryango wa Ozini, atu a mryango wa Eri, ");
INSERT INTO dig_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","atu a mryango wa Arodi na atu a mryango wa Areli. ");
INSERT INTO dig_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Atu a mbari ya Gadi arioolangbwa kala ni elufu mirongo mine na magana matsano. ");
INSERT INTO dig_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Eri na Onani kala ni ana anjina a Juda ela afwa tsi ya Kanani. ");
INSERT INTO dig_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Atu a mbari ya Juda kulengana na miryango yao kala ni: atu a mryango wa Shela, atu a mryango wa Peresi na atu a mryango wa Zera. ");
INSERT INTO dig_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Atu a chivyazi cha Peresi kala ni: atu a mryango wa Hezironi na atu a mryango wa Hamuli. ");
INSERT INTO dig_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Atu a mbari ya Juda arioolangbwa kala ni elufu mirongo sabaa na sita na magana matsano. ");
INSERT INTO dig_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Atu a mbari ya Isakari kulengana na miryango yao kala ni: atu a mryango wa Tola; atu a mryango wa Puwa, ");
INSERT INTO dig_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","atu a mryango wa Jashubu na atu a mryango wa Shimuroni. ");
INSERT INTO dig_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Atu a mbari ya Isakari arioolangbwa kala ni elufu mirongo sita na ne na magana mahahu. ");
INSERT INTO dig_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Atu a mbari ya Zabuloni kulengana na miryango yao kala ni: atu a mryango wa Seredi, atu a mryango wa Eloni na atu a mryango wa Jaleeli. ");
INSERT INTO dig_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Atu a mbari ya Zabuloni arioolangbwa kala ni elufu mirongo sita na magana matsano. ");
INSERT INTO dig_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Aha ni atu a chivyazi cha Yusufu kulengana na mbari zao kutsupira anae airi, Manase na Efuraimu: ");
INSERT INTO dig_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Atu a mbari ya Manase kala ni: atu a mryango wa Makiri (Makiri wakala ndiye ise wa Giliadi) na atu a mryango wa Giliadi. ");
INSERT INTO dig_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Atu a chivyazi cha Giliadi kala ni: atu a mryango wa Iyezeri, atu a mryango wa Heleki, ");
INSERT INTO dig_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","atu a mryango wa Asirieli, atu a mryango wa Shekemu, ");
INSERT INTO dig_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","atu a mryango wa Shemida na atu a mryango wa Heferi. ");
INSERT INTO dig_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Selofehadi mwana wa Heferi kala kana ana a chilume. Wakala na ana achetu tu, nao kala ni Mahala, Noa, Hogila, Milika na Tirisa. ");
INSERT INTO dig_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Atu a mbari ya Manase arioolangbwa kala ni elufu mirongo mitsano na mbiri na magana sabaa. ");
INSERT INTO dig_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Atu a mbari ya Efuraimu kulengana na miryango yao kala ni: atu a mryango wa Shuthela, atu a mryango wa Bekeri na atu a mryango wa Tahani. ");
INSERT INTO dig_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Atu a chivyazi cha Shuthela kala ni: atu a mryango wa Erani. ");
INSERT INTO dig_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Atu a mbari ya Efuraimu arioolangbwa kala ni atu elufu mirongo mihahu na mbiri na magana matsano. Aha ndio atu a chivyazi cha Yusufu kulengana na mbari zao. ");
INSERT INTO dig_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Atu a mbari ya Benjamini kulengana na miryango yao kala ni: atu a mryango wa Bela, atu a mryango wa Ashibeli, atu a mryango wa Ahiramu, ");
INSERT INTO dig_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","atu a mryango wa Shufamu na atu a mryango wa Hufamu. ");
INSERT INTO dig_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Ana a Bela kala ni Aridi na Naamani: atu a mryango wa Aridi na atu a mryango wa Naamani. ");
INSERT INTO dig_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Atu a mbari ya Benjamini arioolangbwa kala ni elufu mirongo mine na tsano na magana sita. ");
INSERT INTO dig_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Atu a mbari ya Dani kulengana na miryango yao kala ni: atu a mryango wa Shuhamu. Aha ndio ariokala atu a mbari ya Dani. ");
INSERT INTO dig_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Atu a mryango wa Shuhamu osi arioolangbwa kala ni elufu mirongo sita na ne na magana mane. ");
INSERT INTO dig_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Atu a mbari ya Asheri kulengana na miryango yao kala ni: atu a mryango wa Imuna, atu a mryango wa Ishivi na atu a mryango wa Beriya. ");
INSERT INTO dig_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Atu a chivyazi cha Beriya kala ni: atu a mryango wa Heberi na atu a mryango wa Malikieli. ");
INSERT INTO dig_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Asheri wakala na mwana wa mchetu aihwaye Sera. ");
INSERT INTO dig_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Atu a mbari ya Asheri arioolangbwa kala ni elufu mirongo mitsano na tahu na magana mane. ");
INSERT INTO dig_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Atu a mbari ya Nafutali kulengana na miryango yao kala ni: atu a mryango wa Jahiseeli, atu a mryango wa Guni, ");
INSERT INTO dig_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","atu a mryango wa Jeseri na atu a mryango wa Shilemu. ");
INSERT INTO dig_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Atu a mbari ya Nafutali arioolangbwa kulengana na mbari zao kala ni elufu mirongo mine na tsano na magana mane. ");
INSERT INTO dig_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Aiziraeli osi arioolangbwa kala ni atu elufu magana sita na mwenga, magana sabaa na mirongo mihahu. ");
INSERT INTO dig_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Mwenyezi Mlungu achigomba na Musa achimuamba, ");
INSERT INTO dig_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Yo tsi iganyire mbari hizi dza urisi kulengana na isabu ya madzina gao. ");
INSERT INTO dig_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Ichikala mbari nkulu, aphe seemu kulu na ichikala mbari ni ndide aphe seemu ndide. Chila mbari naiphahe urisiwe kulengana na isabu ya atu arioandikpwa. ");
INSERT INTO dig_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Ela yo tsi indaganywa kpwa njira ya kupiga kura. Chila kundi rindaganyirwa kulengana na madzina ga mbari za akare ao. ");
INSERT INTO dig_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Urisi wao undaganywa kuhumira njira ya kupiga kura kahi za makundi ga atu anji na ga atu achache.” ");
INSERT INTO dig_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Alawi arioolangbwa kulengana na miryango yao ni hinya: atu a mryango wa Gerishoni, atu a mryango wa Kohathi na atu a mryango wa Merari. ");
INSERT INTO dig_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Ihi nayo ni miryango ya Alawi: atu a mryango wa Libuni, atu a mryango wa Heburoni, atu a mryango wa Mahili, atu a mryango wa Mushi na atu a mryango wa Kora. (Kohathi ndiye mkarengbwa wa Amuramu. ");
INSERT INTO dig_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Mkpwaza Amuramu kala anaihwa Jokebedi. Iye kala ni wa chivyazi cha Lawi naye wavyalwa Misiri. Jokebedi achimuvyarira Amuramu ana ahahu: Aruni, Musa na mwanao wao mchetu aihwaye Miriamu. ");
INSERT INTO dig_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Aruni achivyala Nadabu, Abihu, Eliazari na Ithamari. ");
INSERT INTO dig_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Ela Nadabu na Abihu afwa wakati ariphoreha moho usioruhusiwa mbere za Mwenyezi Mlungu.) ");
INSERT INTO dig_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Alawi alume ario na umuri wa mwezi mmwenga na kpwenderera kala ni atu elufu mirongo miiri na tahu. Aha taayaolangbwa phamwenga na nyo Aiziraeli anjina kpwa kukala aho taahewerwe urisi wowosi kahi za Aiziraeli. ");
INSERT INTO dig_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Aha ndio arioolangbwa ni Musa na mlavyadzi-sadaka Eliazari, ariphoolanga Aiziraeli kahi za tsi ya kugbwa ya Moabu iriyo kanda-kanda ya Joridani, ngʼambo ya phiri napho ula Jeriko. ");
INSERT INTO dig_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Taphana hata mmwenga kahi za aha ambaye kala akaolangbwa ni Musa na mlavyadzi-sadaka Aruni wakati Aiziraeli ariphoolangbwa hiko weru wa Sinai. ");
INSERT INTO dig_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Kpwa kukala Mwenyezi Mlungu kala akaambira nyo Aiziraeli, “Kpwa kpweli andafwa ko weruni,” nao taphana hata mmwenga yesala isiphokala Kalebu mwana wa Jefune na Joshuwa mwana wa Nuni. ");
INSERT INTO dig_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Selofehadi mwana wa Heferi, mwana wa Giliadi, mwana wa Makiri, mwana wa Manase kula mbari ya Manase mwana wa Yusufu kala ana ana atsano achetu ambao madzina gao ni, Mahala, Noa, Hogila, Milika na Tirisa. ");
INSERT INTO dig_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Phahi asichana aha aphiya achendaima mbere za Musa, mlavyadzi-sadaka Eliazari, vilongozi na mkpwutano wosi wa Aiziraeli ariokala pho phenye mryango wa hema ra mkpwutano, nao achiamba, ");
INSERT INTO dig_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Baba wafwa hiko jangbwani. Kayakala mmwenga wa afuasi a Kora ariokusanyika phamwenga chinyume na Mwenyezi Mlungu, ela iye wafwa kpwa ajili ya dambiye mwenye naye kayakala na mwana wa chilume. ");
INSERT INTO dig_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Kpwa utu wani phahi dzina ra baba riuswe kula kahi za mbariye kpwa sababu kayakala na mwana wa chilume? Hunavoya uhuphe seemu ya tsi hurisi phamwenga na ano baba.” ");
INSERT INTO dig_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Phahi Musa achireha ro voyo rao mbere za Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Naye Mwenyezi Mlungu achigomba na Musa achimuamba, ");
INSERT INTO dig_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Hivyo aambavyo nyo ana achetu a Selofehadi ni sawa. Ni uaphe seemu ya tsi arisi phamwenga na adugu a ise yao. Aphe urisi wa ise yao ukale wao. ");
INSERT INTO dig_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","“Aambire Aiziraeli, ‘Mutu achifwa na achikala kana mwana wa chilume, urisiwe undahewa mwanawe mchetu. ");
INSERT INTO dig_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Ichikala kana mwana mchetu, urisiwe undahewa nduguze a chilume. ");
INSERT INTO dig_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Ichikala kana ndugu a chilume phahi urisiwe undahewa iseze avyere na adide. ");
INSERT INTO dig_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Na ichikala ise kana ndugu a chilume, phahi urisiwe undahewa mutuwe wa phephi wa mbariye, naye andaumiliki. Hiri rindakala lagizo ra chishariya kpwa Aiziraeli, dza Mwenyezi Mlungu arivyomlagiza Musa.’ ” ");
INSERT INTO dig_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Mwenyezi Mlungu achigomba na Musa achimuamba, “Ambuka mwango uhu urio kahi ya myango ya Abarimu ulole yo tsi ndiyoapha Aiziraeli. ");
INSERT INTO dig_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Ndiphokala ukaiona, nawe piya undafwa dza nduguyo Aruni, ");
INSERT INTO dig_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","kpwa kukala uwe na nduguyo Aruni mwarema kulunga lagizo rangu ko jangbwa ra Sini wakati Aiziraeli ariphonirurumikira. Mwimwi tamuonyesere utakatifu wangu mbere zao pho madzini.” (Higa ni madzi ga Meriba hiko Kadeshi kahi za weru wa Sini.) ");
INSERT INTO dig_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Musa achigomba na Mwenyezi Mlungu achiamba, ");
INSERT INTO dig_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Nakuvoya Mwenyezi Mlungu, Mlungu uriye chandzo cha anadamu osi kukala moyo, utsambule mutu ndiyelongoza atu aha, ");
INSERT INTO dig_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","wakati anatuluka na kuinjira, ndiyealongoza phatu phophosi ndiphophiya atu a Mwenyezi Mlungu, ili asikale dza mangʼondzi gasigokala na mrisa.” ");
INSERT INTO dig_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Phahi Mwenyezi Mlungu achimjibu Musa achimuamba, “Hala Joshuwa mwana wa Nuni mutu ariye na moyo na umuikire mikono. ");
INSERT INTO dig_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Muike mbere za mlavyadzi-sadaka Eliazari na Aiziraeli osi na umuhende akale chilongozi mbere zao. ");
INSERT INTO dig_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Muphe seemu ya mamlakago ili nyo Aiziraeli osi amuishimu. ");
INSERT INTO dig_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Joshuwa andakala achiima mbere za mlavyadzi-sadaka Eliazari, ndiyekala achimuuzira ushauri kula kpwa Mwenyezi Mlungu kpwa kuhumira Urimu. Kpwa kuhumira njira ihi Eliazari andalongoza Joshuwa na Aiziraeli osi katika mambo gosi.” ");
INSERT INTO dig_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Musa achihenda dza Mwenyezi Mlungu arivyomlagiza. Achimuhala Joshuwa achimuika mbere za mlavyadzi-sadaka Eliazari na Aiziraeli osi. ");
INSERT INTO dig_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Chisha achimuikira mikono ili edze akale chilongozi bada ya Musa dza Mwenyezi Mlungu arivyomlagiza. ");
INSERT INTO dig_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Mwenyezi Mlungu achigomba na Musa achimuamba, ");
INSERT INTO dig_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Lagiza Aiziraeli uaambire, ‘Hakikishani munanilavira sadaka ya chakurya yenye kungu nono kpwa wakati uriopangbwa.’ ");
INSERT INTO dig_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Aambire: Sadaka ndizomlavira Mwenyezi Mlungu ni hizi: ana turume airi a mwaka mmwenga-mmwenga asio na chirema dza sadaka ya kuochwa ya chila siku. ");
INSERT INTO dig_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Mundalavya mwana turume mmwenga ligundzu, na ye wanjina mundamlavya dziloni, ");
INSERT INTO dig_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","phamwenga na sadaka ya mtsere ya kilo mwenga ya unga wa tsiki uriotsanganywa na lita mwenga ya mafuha manono ga zaituni. ");
INSERT INTO dig_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Ihi ni sadaka ya kuochwa ya chila siku kpwa Mwenyezi Mlungu, ambayo yalaviwa kano ya kpwandza kahi ya Mwango Sinai ikale sadaka yenye kungu nono. ");
INSERT INTO dig_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Chila mwana turume ndiyelaviwa andalungizirwa ni sadaka ya lita mwenga ya uchi wa zabibu. Yo sadaka ya uchi wa zabibu indamwagirwa Mwenyezi Mlungu kahi ya pho Phatu Phatakatifu. ");
INSERT INTO dig_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Wakati wa jiza rinahanda undalavya ye mwana turume wanjina phamwenga na sadaka ya unga wa mtsere na ya chinwadzi dza hira ya ligundzu. Ihi ni sadaka yenye kungu nono imuhamirayo Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“Na Siku za Kuoya mundalavya ana turume airi a mwaka mmwenga-mmwenga asio na chirema phamwenga na sadakaye ya mtsere ya kilo mbiri za unga mnono uriotsanganywa na mafuha na sadaka ya chinwadzi. ");
INSERT INTO dig_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Ihi ndiyo sadaka ya kuochwa ndiyolaviwa chila Siku ya Kuoya mbali na sadaka ya kuochwa ya kawaida na sadakaye ya chinwadzi. ");
INSERT INTO dig_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“Chila mwandzo wa mwezi mundamlavira Mwenyezi Mlungu sadaka ya kuochwa ya ndzau mbiri, turume mwenga na ana turume sabaa a mwaka mmwenga-mmwenga, asio na chirema. ");
INSERT INTO dig_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Chisha chila ndzau mundailavya phamwenga na sadaka ya mtsere ya kilo tahu za unga mnono uriotsanganywa na mafuha, na sadaka ya mtsere ya kilo mbiri za unga mnono uriotsanganywa na mafuha kpwa hiro turume, ");
INSERT INTO dig_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","na kpwa chila turume mundalavya sadaka ya mtsere ya kilo mwenga ya unga mnono uriotsanganywa na mafuha. Sadaka hizi ni za kuochwa za kulaviwa kpwa Mwenyezi Mlungu tsona zenye kungu nono zimuhamirazo. ");
INSERT INTO dig_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Chila ndzau andalaviwa phamwenga na sadaka ya chinwadzi cha uchi wa zabibu lita mbiri, lita mwenga na nusu ya uchi wa zabibu kpwa chila turume, na lita mwenga ya uchi wa zabibu kpwa chila mwana turume. Ihi ndiyo sadaka ya kuochwa ya chila siku ya kpwandza bada ya kulumbwa kpwa mwezi, mwaka wosi. ");
INSERT INTO dig_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Mbali na sadaka ya kawaida ya kuochwa na sadakaye ya chinwadzi, mundamlavira Mwenyezi Mlungu ndenje ikale sadaka ya kuusa dambi. ");
INSERT INTO dig_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“Mundasherekeya sikukuu ya Pasaka ya Mwenyezi Mlungu siku ya kumi na ne ya mwezi wa kpwandza. ");
INSERT INTO dig_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Na yo siku ya kumi na tsano mundasherekeya sikukuu ya kurya mikahe isiyotiywa hamira ndiyokala kpwa muda wa siku sabaa. ");
INSERT INTO dig_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Siku ya kpwandza ya sikukuu mundahenda mkpwutano mtakatifu, namwi msihende kazi za kawaida siku hiyo. ");
INSERT INTO dig_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Mundamlavira Mwenyezi Mlungu sadaka ya kuochwa ya ana ndzau airi, turume mwenga na ana turume sabaa a mwaka mmwenga-mmwenga asio na chirema. ");
INSERT INTO dig_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Chila ndzau mundailavya na sadaka ya mtsere ya kilo tahu za unga wa tsiki uriotsanganywa na mafuha, na mundalavya kilo mbiri za unga mnono uriotsanganywa na mafuha phamwenga na ro turume, ");
INSERT INTO dig_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","na kilo mwenga kpwa chila mmwenga wa hara ana turume sabaa. ");
INSERT INTO dig_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Piya mundalavya sadaka ya kuusa dambi ya ndenje ili muhenderwe upatanisho wa kuusirwa dambi. ");
INSERT INTO dig_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Mundalavya sadaka hizi mbali na zira sadaka za kuochwa za chila ligundzu. ");
INSERT INTO dig_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Chihivi, mundalavya sadaka ya chakurya yenye kungu nono imuhamirayo Mwenyezi Mlungu kpwa muda wa siku sabaa. Sadaka ihi mundailavya mbali na sadaka ya kawaida phamwenga na sadakaye ya chinwadzi. ");
INSERT INTO dig_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Siku ya sabaa mundahenda mkpwutano mtakatifu, na msihende kazi za kawaida. ");
INSERT INTO dig_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“Siku ya kpwandza ya sikukuu ya mavuno, wakati mlavyapho sadaka za malumbuko ga mtsere kpwa Mwenyezi Mlungu, mundahenda mkpwutano mtakatifu namwi tamundahenda kazi za kawaida. ");
INSERT INTO dig_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Mundamlavira Mwenyezi Mlungu sadaka za kuochwa zenye kungu nono imuhamirayo. Mundalavya ana ndzau airi, turume mwenga na ana turume sabaa a mwaka mmwenga-mmwenga asio na chirema. ");
INSERT INTO dig_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Chisha chila ndzau mundamlavya phamwenga na sadaka ya mtsere ya kilo tahu za unga mnono uriotsanganywa na mafuha, na ro turume mundarilavya phamwenga na kilo mbiri za sadaka ya mtsere ya unga mnono uriotsanganywa na mafuha, ");
INSERT INTO dig_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","na kpwa chila mwana turume kahi ya hara ana turume sabaa mundaalavya phamwenga na sadaka ya mtsere ya kilo mwenga ya unga mnono uriotsanganywa na mafuha. ");
INSERT INTO dig_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Piya mundalavya sadaka ya kuusa dambi ya ndenje mwenga ili muhenderwe upatanisho. ");
INSERT INTO dig_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Kanda na sadaka za kawaida za kuochwa na sadakaze za mtsere sadaka hizi mundazilavya phamwenga na sadakaze za vinwadzi. Hakikishani kukala munalavya nyama asio na virema. ");
INSERT INTO dig_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“Siku ya kpwandza ya mwezi wa sabaa mundakala na mkpwutano mtakatifu chisha tamundahenda kazi za kawaida. Iyo ni siku ya kupiga magunda, ");
INSERT INTO dig_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","namwi mundalavya sadaka ya kuochwa yenye kungu nono imuhamirayo Mwenyezi Mlungu. Mwimwi mundalavya ndzau mmwenga, turume mwenga na ana turume sabaa a mwaka mmwenga-mmwenga asio na virema. ");
INSERT INTO dig_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Mundalavya phamwenga na sadaka ya mtsere. Yo ndzau mundailavya phamwenga na kilo tahu za unga mnono uriotsanganywa na mafuha na ro turume mundarilavya phamwenga na kilo mbiri za unga mnono uriotsanganywa na mafuha, ");
INSERT INTO dig_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","na kpwa chila mwana turume mundamlavya phamwenga na kilo mwenga ya unga mnono uriotsanganywa na mafuha. ");
INSERT INTO dig_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Chisha mundalavya sadaka ya ndenje mwenga ya kuusa dambi ili muhenderwe upatanisho. ");
INSERT INTO dig_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Mbali na sadaka hizo, mundaenderera kulavya sadaka za kuochwa za chila siku na za chila mwezi kpwa Mwenyezi Mlungu. Chila sadaka mundailavya phamwenga na sadakaye ya mtsere na ya chinwadzi dza irivyolagizwa. Hizi ni sadaka zenye kungu nono zimuhamirazo Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“Siku ya kumi ya mwezi wa sabaa mundakala na mkpwutano mtakatifu. Ni mfunge na msihende kazi yoyosi. ");
INSERT INTO dig_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Mundamlavira Mwenyezi Mlungu sadaka ya kuochwa yenye kungu nono imuhamirayo. Mundalavya ndzau mmwenga, turume mwenga na ana turume sabaa a mwaka mmwenga-mmwenga na asikale na chirema yoyosi. ");
INSERT INTO dig_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Yo ndzau mundailavya phamwenga na sadaka ya mtsere ya kilo tahu za unga mnono uriotsanganywa na mafuha na ro turume mundarilavya phamwenga na kilo mbiri za unga mnono uriotsanganywa na mafuha, ");
INSERT INTO dig_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","na chila mwana turume mundamlavya phamwenga na kilo mwenga ya unga mnono uriotsanganywa na mafuha. ");
INSERT INTO dig_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Chisha mundalavya sadaka ya kuusa dambi ya ndenje mwenga mbali na sadaka ya kuusa dambi ya kukuhenderani upatanisho, na sadaka ya kuochwa ya chila siku phamwenga na sadakaye ya mtsere na ya chinwadzi. ");
INSERT INTO dig_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“Siku ya kumi na tsano ya mwezi wa sabaa mundakala na mkpwutano mtakatifu namwi tamundahenda kazi za kawaida. Mundamuhendera Mwenyezi Mlungu sikukuu kpwa muda wa siku sabaa. ");
INSERT INTO dig_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Mundalavya sadaka ya kuochwa yenye kungu nono imuhamirayo Mwenyezi Mlungu. Mundalavya ndzau kumi na tahu, maturume mairi na ana turume kumi na a ne a mwaka mmwenga-mmwenga na asikale na chirema chochosi. ");
INSERT INTO dig_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Sadaka zizi mundazilavya phamwenga na sadakaze za mtsere. Chila ndzau kahi ya zo ndzau kumi na tahu mundailavya phamwenga na kilo tahu za unga mnono uriotsanganywa na mafuha, na kpwa chila turume mundarilavya phamwenga na kilo mbiri za unga mnono uriotsanganywa na mafuha, ");
INSERT INTO dig_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","na chila mwana turume kahi za hara ana turume kumi na ane, mundamlavya phamwenga na kilo mwenga ya unga mnono uriotsanganywa na mafuha. ");
INSERT INTO dig_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Mbali na sadaka ya kuochwa ya chila siku phamwenga na sadakaye ya mtsere na ya chinwadzi, mundalavya sadaka ya kuusa dambi ya ndenje mwenga. ");
INSERT INTO dig_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“Siku ya phiriye mundalavya ndzau kumi na mbiri, maturume mairi na ana turume kumi na a ne a mwaka mmwenga-mmwenga asio na virema. ");
INSERT INTO dig_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Mundalavya zo ndzau, go maturume na nyo ana turume phamwenga na sadaka zao za mtsere na za chinwadzi kulengana na isabu yao dza shariya iambavyo. ");
INSERT INTO dig_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Chisha mbali na sadaka ya kuochwa ya chila siku na sadakaye ya mtsere na chinwadzi, mundalavya sadaka ya kuusa dambi ya ndenje mwenga. ");
INSERT INTO dig_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“Siku ya hahu mundalavya ndzau kumi na mwenga, maturume mairi na ana turume kumi na a ne a mwaka mmwenga-mmwenga asio na virema. ");
INSERT INTO dig_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Mundalavya zo ndzau, go maturume na nyo ana turume phamwenga na sadaka zao za mtsere na za chinwadzi kulengana na isabu yao dza shariya iambavyo. ");
INSERT INTO dig_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Mbali na sadaka ya kuochwa ya chila siku na sadakaye ya mtsere na chinwadzi, mundalavya sadaka ya kuusa dambi ya ndenje mwenga. ");
INSERT INTO dig_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“Siku ya ne mundalavya ndzau kumi, maturume mairi na ana turume kumi na a ne a mwaka mmwenga-mmwenga asio na virema. ");
INSERT INTO dig_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Mundalavya zo ndzau, go maturume na nyo ana turume phamwenga na sadaka zao za mtsere na za chinwadzi kulengana na isabu yao dza shariya iambavyo. ");
INSERT INTO dig_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Kanda na sadaka ya kuochwa ya chila siku na sadakaye ya mtsere na chinwadzi, mundalavya sadaka ya kuusa dambi ya ndenje mwenga. ");
INSERT INTO dig_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“Siku ya tsano mundalavya ndzau tisiya, maturume mairi na ana turume kumi na a ne a mwaka mmwenga-mmwenga asio na virema. ");
INSERT INTO dig_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Mundalavya zo ndzau, go maturume na nyo ana turume phamwenga na sadaka zao za mtsere na za chinwadzi kulengana na isabu yao dza shariya iambavyo. ");
INSERT INTO dig_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Kanda na sadaka ya kuochwa ya chila siku na sadakaye ya mtsere na chinwadzi, mundalavya sadaka ya kuusa dambi ya ndenje mwenga. ");
INSERT INTO dig_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“Siku ya sita mundalavya ndzau anane, maturume mairi na ana turume kumi na a ne a mwaka mmwenga-mmwenga asio na virema. ");
INSERT INTO dig_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Mundalavya zo ndzau, go maturume na nyo ana turume phamwenga na sadaka zao za mtsere na za chinwadzi kulengana na isabu yao dza shariya iambavyo. ");
INSERT INTO dig_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Kanda na sadaka ya kuochwa ya chila siku na sadakaye ya mtsere na chinwadzi, mundalavya sadaka ya kuusa dambi ya ndenje mwenga. ");
INSERT INTO dig_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“Siku ya sabaa mundalavya ndzau sabaa, maturume mairi na ana turume kumi na a ne a mwaka mmwenga-mmwenga asio na virema. ");
INSERT INTO dig_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Mundalavya zo ndzau, go maturume na nyo ana turume phamwenga na sadaka zao za mtsere na za chinwadzi kulengana na isabu yao dza shariya iambavyo. ");
INSERT INTO dig_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Kanda na sadaka ya kuochwa ya chila siku na sadakaye ya mtsere na chinwadzi, mundalavya sadaka ya kuusa dambi ya ndenje mwenga. ");
INSERT INTO dig_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“Siku ya nane mundakala na mkpwutano mtakatifu na tamundahenda kazi za kawaida. ");
INSERT INTO dig_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Mundalavya sadaka ya kuochwa yenye kungu nono imuhamirayo Mwenyezi Mlungu. Mundalavya ndzau mwenga, turume mwenga na ana turume sabaa a mwaka mmwenga-mmwenga asio na virema. ");
INSERT INTO dig_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Mundalavya yo ndzau, ro turume na nyo ana turume phamwenga na sadaka zao za mtsere na za chinwadzi kulengana na isabu yao dza shariya iambavyo. ");
INSERT INTO dig_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Kanda na sadaka ya kuochwa ya chila siku na sadakaye ya mtsere na chinwadzi, mundalavya sadaka ya kuusa dambi ya ndenje mwenga. ");
INSERT INTO dig_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“Sadaka hizi mundamlavira Mwenyezi Mlungu wakati wa sikukuu zenu zirizopangbwa. Mundazilavya mbali na sadaka zenu za naziri na za kumendza kpwenu enye dza sadaka zenu za kuochwa, za mtsere, za chinwadzi na za amani.” ");
INSERT INTO dig_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Phahi Musa achiambira Aiziraeli vyosi arivyokala akalagizwa ni Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Chisha Musa achigomba na vilongozi a mbari za Aiziraeli, achiaambira, “Hivi ndivyo Mwenyezi Mlungu arivyolagiza: ");
INSERT INTO dig_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Mutu achiika naziri kpwa Mwenyezi Mlungu, ama achiahidi utu kpwa kuapa, ni ahende gosi arigoahidi kulengana na gosi arigogomba. ");
INSERT INTO dig_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“Msichana ambaye bado anasagala na ise achiika naziri kpwa Mwenyezi Mlungu, ama achidzifunga na ahadi, ");
INSERT INTO dig_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","na ise asikire yo hatiye ama ahadiye naye asimuambire rorosi, phahi naziri zosi arizoziika na ahadi zosi zindadumu. ");
INSERT INTO dig_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Ela ise achimkahaza wakati ndiphosikira, takuna naziri wala ahadi ndiyodumu. Na Mwenyezi Mlungu andamswamehe kpwa sababu ise wamkahaza. ");
INSERT INTO dig_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“Ye msichana achilólwa bada ya kuika naziri ama kugomba neno bila ya kufikiriya na akadzifungira, ");
INSERT INTO dig_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","na mlumewe edze asikire na anyamale, phahi naziri arizoziika na ahadi zindadumu. ");
INSERT INTO dig_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Ela ye mlumewe achimkahaza wakati ndiphosikira, phahi yo naziri ariyoika mchewe, ama ro neno arirogomba bila kufikiriya rindakala ni bahi na Mwenyezi Mlungu andamswamehe. ");
INSERT INTO dig_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“Chila naziri iriyoikpwa ni mchetu gungu ama mchetu ariyehewa talaka, indadumu. ");
INSERT INTO dig_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“Mchetu asagalaye na mlumewe achiika naziri ama adzifungire kpwa kuika ahadi na chirapho, ");
INSERT INTO dig_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","na mlumewe asikire na anyamale wala asimkahaze, phahi naziri zosi na ahadi zosi zindadumu. ");
INSERT INTO dig_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Ela ye mlumewe achimkahaza wakati ndiphosikira, phahi hatize ama ahadiye chiyoigomba indakala ni bahi na Mwenyezi Mlungu andamswamehe. ");
INSERT INTO dig_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Ye mlumewe anaweza kukubali au kukahaza naziri yoyosi na chirapho chochosi aikacho. ");
INSERT INTO dig_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Napho ye mlumewe kandamuambira chitu kula yo siku ariphogasikira, andakala akakubali hatize na ahadize zosi arizoziika. ");
INSERT INTO dig_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Ela ye mlume achigasikira na amkahaze badaye, go makosa ga ye mchetu gandakala dzulu ya ye mlume.” ");
INSERT INTO dig_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Higa ni malagizo ambazo Mwenyezi Mlungu wamupha Musa kuhusu uhusiano wa mutu na mchewe, na mutu na mwanawe mchetu ambaye kadzangbwelólwa. ");
INSERT INTO dig_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Mwenyezi Mlungu achigomba na Musa achimuamba, ");
INSERT INTO dig_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Kabila kudzangbwefwa, ariphize Amidiani kpwa gara arigohendera Aiziraeli.” ");
INSERT INTO dig_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Phahi Musa achigomba na nyo atu achiaambira, “Tayarishani seemu ya atu enu kpwa ajili ya viha akashambuliye Amidiani ili amuriphizire Mwenyezi Mlungu chisasi. ");
INSERT INTO dig_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Chila mbari ya Iziraeli nailavye atu elufu mwenga aphiye vihani.” ");
INSERT INTO dig_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Phahi chila mbari ya Iziraeli ichilavya atu elufu mwenga, na osi jumula achikala ni atu elufu kumi na mbiri. ");
INSERT INTO dig_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Musa achiahuma aha aphiye vihani phamwenga na Finehasi mwana wa mlavyadzi-sadaka Eliazari. Finehasi achihala miyo ya pho Phatu Phatakatifu na tarumbeta za kumanyisira atu kuhusu viha. ");
INSERT INTO dig_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Aiziraeli achipigana na Amidiani dza Mwenyezi Mlungu arivyomlagiza Musa na achiolaga alume osi. ");
INSERT INTO dig_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Kahi ya hinyo arioolagbwa kala ni phamwenga na afalume atsano a Midiani: Evi, Rekemu, Suri, Huri na Reba. Piya Balaamu mwana wa Beori amuolaga kpwa upanga. ");
INSERT INTO dig_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Aiziraeli achihala mateka achetu a Chimidiani na ana ao, phamwenga na ngʼombe zao, mangʼondzi gao, mbuzi zao na mali zao zosi. ");
INSERT INTO dig_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Achiocha midzi yosi ambayo Amidiani kala achiisagala na kambi zao zosi. ");
INSERT INTO dig_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Achihala zewe zosi na achihala mateka atu na nyama, ");
INSERT INTO dig_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","achireha nyo atu ariotsamizwa kpwa lazima, nyama na zewe zosi mbere za Musa, mlavyadzi-sadaka Eliazari na Aiziraeli osi ariokala akachita kambi kahi ya tsi ya kugbwa ya Moabu iriyo kanda-kanda ya muho Joridani, ngʼambo ya phiri napho ula Jeriko. ");
INSERT INTO dig_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Musa, mlavyadzi-sadaka Eliazari na vilongozi osi a Aiziraeli aphiya kpwendakutana nao kondze ya yo kambi. ");
INSERT INTO dig_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Musa achiatsukirirwa sana nyo maofisaa a jeshi, yani akulu a vikosi vya anajeshi elufu-elufu na akulu a vikosi vya anajeshi gana-gana ariokala akauya kula vihani. ");
INSERT INTO dig_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Musa achiauza achiamba, “Mbona mwaaricha moyo achetu osi? ");
INSERT INTO dig_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Aho ndio ariolunga ushauri wa Balaamu, achihenda Aiziraeli amuhendere dambi Mwenyezi Mlungu hiko Peori hadi achiphahwa ni shaka. ");
INSERT INTO dig_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Sambi aolageni nyo anache osi a chilume na chila mchetu ariyelala na mlume, ");
INSERT INTO dig_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","ela dziikireni enye asichana osi ambao taadzangbwelala na mlume. ");
INSERT INTO dig_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","“Chila mmwenga wenu ariyeolaga mutu ama kuguta lufu ni akale kondze ya kambi kpwa siku sabaa. Siku ya hahu na ya sabaa ni mtakaswe phamwenga na nyo atu murioatsamiza kpwa lazima. ");
INSERT INTO dig_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Mundatakasa chila nguwo na chila chitu chirichotengezwa na chingo, nyoya za mbuzi au mbao.” ");
INSERT INTO dig_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Chisha mlavyadzi-sadaka Eliazari achigaambira go majeshi garigokala gala vihani, “Hiri ndiro lagizo ra shariya ambaro Mwenyezi Mlungu wamlagiza Musa: ");
INSERT INTO dig_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Zahabu, feza, shaba, chuma, bamba na aina ya chuma chiihwacho risasi ");
INSERT INTO dig_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","na chitu chochosi sichophya chichitsupizwa mohoni, ni chitakaswe kpwa kutsupizwa na mohoni. Ela piya ni chitakaswe na madzi ga utakaso. Na chochosi ambacho chichitsupizwa mohoni chinaphya ni chitakaswe na madzi ga utakaso bahi. ");
INSERT INTO dig_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Siku ya sabaa mundafula nguwo zenu namwi mundakala swafi. Chisha mundakala munaweza kuinjira kambini.” ");
INSERT INTO dig_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Mwenyezi Mlungu achigomba na Musa achimuamba, ");
INSERT INTO dig_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Uwe na mlavyadzi-sadaka Eliazari na vilongozi a Aiziraeli mundaaolanga atu osi ariotsamizwa kpwa lazima na nyama. ");
INSERT INTO dig_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Viganyeni kano mbiri, seemu ya kpwandza muiphe go majeshi garigophiya vihani na seemu ya phiri muiphe nyo atu anjina osi. ");
INSERT INTO dig_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Kula kpwa mtalo wa anajeshi ariophiya vihani, tenga seemu kpwa ajili ya Mwenyezi Mlungu; chitu chimwenga kula kpwa chila vitu magana matsano, ikale ni mutu, ngʼombe, punda, mangʼondzi na mbuzi, ");
INSERT INTO dig_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","umuphe mlavyadzi-sadaka Eliazari ikale seemu ya Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Kula kpwa fungu ra Aiziraeli hala seemu mwenga ya seemu mirongo mitsano, ikale ni atu, ngʼombe, punda, mangʼondzi, mbuzi yani chila aina ya nyama. Mtalo uhu aphe Alawi, yani aimirizi a hema ra Mwenyezi Mlungu.” ");
INSERT INTO dig_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Phahi Musa na mlavyadzi-sadaka Eliazari achihenda dza vira Mwenyezi Mlungu arivyomlagiza Musa. ");
INSERT INTO dig_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Vitu virivyosala kula kpwa vyo virivyohalwa mateka ni go majeshi kala ni mangʼondzi phamwenga na mbuzi elufu magana sita, mirongo sabaa na tsano, ");
INSERT INTO dig_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","ngʼombe elufu mirongo sabaa na mbiri, ");
INSERT INTO dig_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","punda elufu mirongo sita na mwenga ");
INSERT INTO dig_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","na achetu elufu mirongo mihahu na airi ambao kala taadzangbwelala na mlume. ");
INSERT INTO dig_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Na nusu ambayo yakala ni mtalo wa hara ariophiya vihani kala ni: mangʼondzi phamwenga na mbuzi elufu magana mahahu na mirongo mihahu na sabaa, na magana matsano, ");
INSERT INTO dig_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","na kula kpwa gaga, mangʼondzi phamwenga na mbuzi magana sita na mirongo sabaa na matsano gakala maripho kpwa Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","Ngʼombe elufu mirongo mihahu na sita, na kula kpwa zizo ngʼombe mirongo sabaa na mbiri zakala maripho kpwa Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","Punda elufu mirongo mihahu na magana matsano, na kula kpwa aha punda mirongo sita na mwenga akala maripho kpwa Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Atu elufu kumi na sita, na kula kpwa aha atu mirongo mihahu na mbiri akala maripho kpwa Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Musa achimupha mlavyadzi-sadaka Eliazari seemu ya Mwenyezi Mlungu dza Mwenyezi Mlungu arivyomlagiza. ");
INSERT INTO dig_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Ira nusu ya mtalo wa Aiziraeli ambayo Musa waitenga kula kpwa hura mtalo wa ariophiya vihani ");
INSERT INTO dig_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","yakala ni mangʼondzi phamwenga na mbuzi elufu magana mahahu na mirongo mihahu na sabaa na magana matsano, ");
INSERT INTO dig_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","ngʼombe elufu mirongo mihahu na sita, ");
INSERT INTO dig_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","punda elufu mirongo mihahu na magana matsano ");
INSERT INTO dig_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","na atu elufu kumi na sita. ");
INSERT INTO dig_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Musa achihala mutu mmwenga kula kpwa chila atu mirongo mitsano na nyama mmwenga kula kpwa chila nyama mirongo mitsano kula kpwa hura mtalo wa Aiziraeli na achiapha Alawi ariokala achiimirira hema ra Mwenyezi Mlungu, dza Mwenyezi Mlungu arivyomlagiza Musa. ");
INSERT INTO dig_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Chisha maofisaa ambao kala anaimirira vikosi vya jeshi, yani akulu a vikosi vya anajeshi elufu-elufu na a vikosi vya anajeshi gana-gana aphiya kpwa Musa ");
INSERT INTO dig_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","achimuamba Musa, “Swiswi atumishio hukaolanga anajeshi osi ario tsini yehu na taphana hata mmwenga ambaye kapho. ");
INSERT INTO dig_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Vivi hukamrehera Mwenyezi Mlungu sadaka vitu vya zahabu hurivyoviphaha: mikufu, bangili, pehe, vipuli na shanga hupatanishwe na Mwenyezi Mlungu.” ");
INSERT INTO dig_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Musa na mlavyadzi-sadaka Eliazari achiphokera yo miyo ya zahabu. ");
INSERT INTO dig_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Na zahabu yosi iriyolaviwa kpwa Mwenyezi Mlungu dza sadaka ni akulu a vikosi vya anajeshi elufu-elufu na akulu a vikosi vya anajeshi gana-gana kala ina uziho wa kama kilo magana mairi. ");
INSERT INTO dig_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","(Chila mwanajeshi kala akadziharira vitu.) ");
INSERT INTO dig_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Musa na mlavyadzi-sadaka Eliazari achiphokera iyo zahabu kula kpwa akulu a vikosi vya anajeshi na achiiphirika kahi ya hema ra mkpwutano kpwa ikale ukumbusho wa Aiziraeli mbere za Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Atu a mbari ya Rubini na ya Gadi akala na mifugo minji sana. Phahi, ariphoona kukala tsi ya Jazeri na Giliadi kala inafwaha kpwa mifugo yao, ");
INSERT INTO dig_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","aphiya kpwa Musa, mlavyadzi-sadaka Eliazari na vilongozi a Aiziraeli, achiaambira, ");
INSERT INTO dig_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“Atarothi, Diboni, Jazeri, Nimura, Heshiboni, Eleale, Sebamu, Nebo na Beoni, ");
INSERT INTO dig_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","midzi ya yo tsi ambayo Mwenyezi Mlungu waahenda Aiziraeli aishinde, inafwaha kpwa mifugo, naswi atumishio huna mifugo. ");
INSERT INTO dig_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Hunakuvoya, ichikala undahukubali uhuphe tsi ihi ikale yehu swiswi atumishio yani husivuke Joridani.” ");
INSERT INTO dig_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Musa achigomba na atu a Gadi na a Rubini achiamba, “Dze, mundasagala phapha wakati ayawenu ndiphophiya vihani? ");
INSERT INTO dig_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Kpwa utu wani munaavundza moyo Aiziraeli ayawenu asilonde kuvuka na kuinjira tsi ariyohewa ni Mwenyezi Mlungu? ");
INSERT INTO dig_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Akare enu ahenda dza vivyo, wakati niriphoahuma anjina aho kula Kadeshi-Barinea aphiye akapeleleze yo tsi. ");
INSERT INTO dig_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Ariphophiya hadi Dete ra Eshikoli na kuiona yo tsi, aavundza moyo Aiziraeli hata achirema kuinjira yo tsi ambayo Mwenyezi Mlungu kala akalaga kuapha. ");
INSERT INTO dig_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Siku iyo Mwenyezi Mlungu achiatsukirirwa sana na achiapa achiamba, ");
INSERT INTO dig_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘Kpwa kpweli taphana hata mutu mmwenga ariye na miaka mirongo miiri na kpwenderera yekpwedza kula Misiri ndiyeiona tsi niriyoapa kuapha Burahimu, Isaka na Jakobo kpwa kukala taanilungire chikamilifu, ");
INSERT INTO dig_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","isiphokala Kalebu mwana wa Jefune, wa mryango wa Kenazi, na Joshuwa mwana wa Nuni, mana aho akamlunga Mwenyezi Mlungu chikamilifu.’ ");
INSERT INTO dig_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Phahi Mwenyezi Mlungu achiatsukirirwa Aiziraeli na achiahenda atange-tange ko weruni kpwa miaka mirongo mine, hadi chivyazi chosi cha okala akahenda mai mbere za Mwenyezi Mlungu chiriphoangamia. ");
INSERT INTO dig_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","“Mwi atu msio na mana, mukakala dza sowe zenu kpwa kumuhendera dambi Mwenyezi Mlungu na kusababisha akutsukirirweni sana mwi Aiziraeli! ");
INSERT INTO dig_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Muchiricha kumlunga Mwenyezi Mlungu, naye andaaricha atu aha ko weruni, namwi mundaahenda aangamizwe osi.” ");
INSERT INTO dig_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Phahi achimsengerera phephi Musa achimuamba, “Hundaitengezera vyaa mifugo yehu, na kuadzengera midzi achetu ehu na ana ehu. ");
INSERT INTO dig_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Ela hu tayari kuhala silaha na kuatanguliya Aiziraeli ayawehu vihani hadi huone akaphaha mwatu mwao kuno achetu ehu na ana ehu andakala anasagala kpwenye midzi yenye ngome ili kuarinda na enyezi a tsi ihi. ");
INSERT INTO dig_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Tahundauya kpwehu midzini hadi Aiziraeli osi ndiphophaha chila mmwenga seemuye ya tsi. ");
INSERT INTO dig_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Tahundarisi chochosi phamwenga nao hiko ngʼambo ya phiri ya Joridani, kpwa kukala hukaphaha seemu yehu ya tsi uphande huno wa mlairo wa dzuwa.” ");
INSERT INTO dig_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Musa achiaambira, “Ichikala mundahenda hivyo, na muhale silaha mbere za Mwenyezi Mlungu na mphiye vihani, ");
INSERT INTO dig_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","na chila mmwenga wenu ariye na silaha avuke Joridani mbere za Mwenyezi Mlungu, hadi Mwenyezi Mlungu azole maaduige, ");
INSERT INTO dig_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","na akuhendeni muatawale nyo atu a yo tsi, hipho mundakala munaweza kuuya, mana mundakala mkamala kazi yenu kpwa Mwenyezi Mlungu na kpwa Aiziraeli. Ndipho tsi ihi indakala yenu mbere za Mwenyezi Mlungu. ");
INSERT INTO dig_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","“Ela ichikala tamundahenda hivyo mundakala munahenda dambi mbere za Mwenyezi Mlungu; namwi mmanye hakika mundatiywa adabu. ");
INSERT INTO dig_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Adzengereni midzi achetu enu, ana enu na muidzengere vyaa mifugo yenu, ela hendani dza mchivyoahidi.” ");
INSERT INTO dig_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Chisha atu a mbari ya Gadi na ya Rubini achimuambira Musa, “Swiswi atumishio hundahenda dza uchivyohulagiza uwe bwana wehu. ");
INSERT INTO dig_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Ana ehu, achetu ehu na mifugo yehu yosi indasala kuku kahi za midzi ya Giliadi. ");
INSERT INTO dig_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Ela swiswi atumishio, osi hurio na silaha tayari kuphiya vihani hundavuka hukapige viha mbere za Mwenyezi Mlungu dza uwe bwana wehu unavyohulagiza.” ");
INSERT INTO dig_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Phahi Musa achilavya malagizo kpwa mlavyadzi-sadaka Eliazari, Joshuwa mwana wa Nuni na vilongozi a mbari za Aiziraeli kuhusu nyo atu a Gadi na a Rubini. ");
INSERT INTO dig_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Musa achiambira, “Ichikala atu a Gadi na a Rubini andavuka Joridani phamwenga namwi kuno ana silaha zao na Mwenyezi Mlungu akuhendeni muashinde atu a tsi iyo, phahi mundaapha tsi ya Giliadi ikale yao. ");
INSERT INTO dig_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Ela ichikala taandagbwira silaha zao na kuvuka phamwenga namwi, ni aphahe mtalo wao phamwenga namwi kahi za tsi ya Kanani.” ");
INSERT INTO dig_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Atu a Gadi na a Rubini achiamba, “Swiswi atumishio hundahenda dza Mwenyezi Mlungu arivyoamba. ");
INSERT INTO dig_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Hundahala silaha huvuke Mwenyezi Mlungu achihulongoza kuinjira Kanani, ela seemu ya urisi wehu indakala kahi za ngʼambo ihi ya Joridani.” ");
INSERT INTO dig_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Phahi Musa achiapha atu a mbari ya Gadi na ya Rubini, na nusu ya atu a mbari ya Manase mwana wa Yusufu, ufalume wosi wa Sihoni, mfalume wa Aamori na wa Ogi, mfalume wa Bashani, tsi yao, midzi yao na seemu zirizokala zikaizunguluka. ");
INSERT INTO dig_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Atu a Gadi achidzenga tsona midzi ya Diboni, Atarothi, Aroeri, ");
INSERT INTO dig_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atirothi-Shofani, Jazeri, Jogibeha, ");
INSERT INTO dig_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Bethi-Nimura na Bethi-Harani, midzi yenye ngome; chisha achidzenga vyaa vya mangʼondzi. ");
INSERT INTO dig_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Atu a Rubini achidzenga tsona midzi ya Heshiboni, Eleale, Kiriathaimu, ");
INSERT INTO dig_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nebo na Baali-Meoni (madzina ga midzi ihi gagaluzwa), na Sibuma. Midzi ariyoidzenga tsona achiipha madzina. ");
INSERT INTO dig_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Atu a chivyazi cha Makiri mwana wa Manase achiphiya Giliadi, achendaiteka na achiazola Aamori ariokala himo. ");
INSERT INTO dig_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Phahi Musa achiapha yo tsi ya Giliadi atu a chivyazi cha Makiri mwana wa Manase, nao achisagala mumo. ");
INSERT INTO dig_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Jairi kula chivyazi cha Manase achendahala mateka vidzidzi vya Giliadi na achivigaluza dzina achiviiha Havothi-Jairi. ");
INSERT INTO dig_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Naye Noba achendateka mudzi wa Kenathi na vidzidzivye na achiuiha Noba, dzinare mwenye. ");
INSERT INTO dig_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Hivi ndivyo vituwo vya Aiziraeli ariphokala a charoni wakati ariphola Misiri madiba-madiba kuno analongozwa ni Musa na Aruni. ");
INSERT INTO dig_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Kpwa lagizo ra Mwenyezi Mlungu, Musa achiandika madzina ga vituwo arivyochita kambi. Vyo vituwo vyao kala ni hivi: ");
INSERT INTO dig_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Aiziraeli auka Ramesesi siku ya kumi na tsano ya mwezi wa kpwandza, siku mwenga bada ya Pasaka. Aho auka kpwa usujaa mbere za Amisiri osi, ");
INSERT INTO dig_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","Amisiri ariphokala anazika ana aho alume a kpwandza ariokala akaolagbwa ni Mwenyezi Mlungu, mana Mwenyezi Mlungu kala akaamula milungu yao. ");
INSERT INTO dig_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Aiziraeli auka Ramesesi na achendachita kambi Sukothi. ");
INSERT INTO dig_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Achiuka Sukothi, achendachita kambi Ethamu, kanda-kanda ya weru. ");
INSERT INTO dig_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Achiuka Ethamu, achigaluka achiuya Pi-Hahirothi, uphande wa mlairo wa dzuwa wa Baali-Sefoni, na achichita kambi phephi na Migidoli. ");
INSERT INTO dig_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Achiuka Pi-Hahirothi achiphiya kutsupira kahi-kahi ya bahari hadi achifika weruni, achiphiya charo cha siku tahu kahi za jangbwa ra Ethamu na achichita kambi Mara. ");
INSERT INTO dig_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Achiuka Mara, achiphiya Elimu na achendachita kambi kuko. Elimu kala kuna pula za madzi kumi na mbiri na mitende mirongo sabaa. ");
INSERT INTO dig_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Achiuka Elimu na achendachita kambi kanda-kanda ya Bahari ya Shamu. ");
INSERT INTO dig_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Achiuka Bahari ya Shamu, achendachita kambi kahi za jangbwa ra Sini. ");
INSERT INTO dig_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Achiuka jangbwa ra Sini, achendachita kambi Dofuka. ");
INSERT INTO dig_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Achiuka Dofuka, achendachita kambi Alushi. ");
INSERT INTO dig_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Achiuka Alushi, achendachita kambi Refidimu, phatu phokala taphana madzi ga atu kunwa. ");
INSERT INTO dig_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Achiuka Refidimu, achendachita kambi jangbwa ra Sinai. ");
INSERT INTO dig_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Achiuka jangbwa ra Sinai, achendachita kambi Kiburothi-Hataava. ");
INSERT INTO dig_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Achiuka Kiburothi-Hataava, achendachita kambi Haserothi. ");
INSERT INTO dig_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Achiuka Haserothi, achendachita kambi Rithima. ");
INSERT INTO dig_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Achiuka Rithima, achendachita kambi Rimoni-Peresi. ");
INSERT INTO dig_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Achiuka Rimoni-Peresi, achendachita kambi Libuna. ");
INSERT INTO dig_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Achiuka Libuna, achendachita kambi Risa. ");
INSERT INTO dig_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Achiuka Risa, achendachita kambi Kehelatha. ");
INSERT INTO dig_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Achiuka Kehelatha, achendachita kambi mwango wa Sheferi. ");
INSERT INTO dig_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Achiuka mwango wa Sheferi, achendachita kambi Harada. ");
INSERT INTO dig_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Achiuka Harada, achendachita kambi Makelothi. ");
INSERT INTO dig_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Achiuka Makelothi, achendachita kambi Tahathi. ");
INSERT INTO dig_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Achiuka Tahathi, achendachita kambi Tera. ");
INSERT INTO dig_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Achiuka Tera, achendachita kambi Mithika. ");
INSERT INTO dig_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Achiuka Mithika, achendachita kambi Hashimona. ");
INSERT INTO dig_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Achiuka Hashimona, achendachita kambi Moserothi. ");
INSERT INTO dig_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Achiuka Moserothi, achendachita kambi Bene-Jaakani. ");
INSERT INTO dig_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Achiuka Bene-Jaakani, achendachita kambi Hori-Hagidigadi. ");
INSERT INTO dig_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Achiuka Hori-Hagidigadi, achendachita kambi Jotibatha. ");
INSERT INTO dig_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Achiuka Jotibatha, achendachita kambi Aburona. ");
INSERT INTO dig_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Achiuka Aburona, achendachita kambi Esioni-Geberi. ");
INSERT INTO dig_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Achiuka Esioni-Geberi, achendachita kambi Kadeshi, ko jangbwa ra Sini. ");
INSERT INTO dig_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Achiuka Kadeshi, achendachita kambi mwango wa Hori, kuphakana na tsi ya Edomu. ");
INSERT INTO dig_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Kpwa lagizo ra Mwenyezi Mlungu, mlavyadzi-sadaka Aruni achiambuka mwango wa Hori na achifwa kuko siku ya kpwandza ya mwezi wa tsano ya mwaka wa mirongo mine, bada ya Aiziraeli kutuluka tsi ya Misiri. ");
INSERT INTO dig_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Wakati Aruni anafwa kala ana miaka gana mwenga mirongo miiri na tahu. ");
INSERT INTO dig_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Wakati uho mfalume Mkanani wa Aradi, yesagala uphande wa mwakani wa tsi ya Kanani, wasikira kukala Aiziraeli aredza kuko. ");
INSERT INTO dig_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Aiziraeli achiuka mwango wa Hori, achendachita kambi Salimona. ");
INSERT INTO dig_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Achiuka Salimona, achendachita kambi Punoni. ");
INSERT INTO dig_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Achiuka Punoni, achendachita kambi Obothi. ");
INSERT INTO dig_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Achiuka Obothi, achendachita kambi Iye-Abarimu, muphakani mwa tsi ya Moabu. ");
INSERT INTO dig_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Achiuka Iye-Abarimu, achendachita kambi Diboni-Gadi. ");
INSERT INTO dig_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Achiuka Diboni-Gadi, achendachita kambi Alimoni-Dibulathaimu. ");
INSERT INTO dig_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Achiuka Alimoni-Dibulathaimu, achendachita kambi kahi za myango ya Abarimu, phephi na Nebo. ");
INSERT INTO dig_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Achiuka myango ya Abarimu, achendachita kambi kahi za tsi ya kugbwa ya Moabu iriyo kanda-kanda ya muho Joridani, ngʼambo ya phiri napho ula Jeriko. ");
INSERT INTO dig_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Achita kambi kanda-kanda ya Joridani kula Bethi-Jeshimothi hata Abeli-Shitimu kahi za tsi ya kugbwa ya Moabu. ");
INSERT INTO dig_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Mwenyezi Mlungu achigomba na Musa kahi za tsi ya kugbwa ya Moabu iriyo kanda-kanda ya muho Joridani, ngʼambo ya phiri napho ula Jeriko achimuamba, ");
INSERT INTO dig_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“Gomba na Aiziraeli uaambe, ‘Mndiphovuka Joridani na kuinjira tsi ya Kanani, ");
INSERT INTO dig_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","azoleni enyezi osi a tsi hiyo. Mubanange-banange vizuka vyao vyosi vya kutsongbwa na vya chuma cha kuyayushwa chisha mʼbomole mwatu mwao mosi mwa dzulu mwa ibada. ");
INSERT INTO dig_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Namwi mundaihala yo tsi na msagale mumo, mana nikakuphani mwimwi ikale yenu. ");
INSERT INTO dig_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Mundaiganya yo tsi kpwa kupiga kura kulengana na mbari zenu. Mbari kulu mundaipha phatu phakulu na mbari ndide mundaipha phatu phadide. Ndichomgbwerera mutu kpwa njira ya kura ni chakpwe. Mundaganya kulengana na mbari za akare enu. ");
INSERT INTO dig_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","“ ‘Ela ichikala tamundaazola nyo enyezi a yo tsi, aho ndiosala andakala dza miya mwenu matsoni na mwityo wa mbavuni. Andakureherani matatizo kahi za yo tsi ambayo mundasagala. ");
INSERT INTO dig_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Nami nindakuhendani mwimwi vyo nirivyopanga kuahenda aho.’ ” ");
INSERT INTO dig_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Mwenyezi Mlungu wagomba na Musa achimuamba, ");
INSERT INTO dig_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“Alagize nyo Aiziraeli na uaambire: Mndiphoinjira tsi ya Kanani, tsi ambayo nakuphani ikale yenu, miphakaye indakala ni hino: ");
INSERT INTO dig_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","“Mphaka wenu wa uphande wa mwakani undakala ni kula jangbwa ra Sini, kulunga-lunga mphaka wa Edomu. Uphande wa mlairo wa dzuwa, mphaka hinyo undaandzira mwisho wa Bahari ya Munyu, ");
INSERT INTO dig_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","nao undagaluka uphiye uphande wa mwakani wa muambuko wa Akirabimu, uphiye hadi Sini hata uphande wa mwakani wa Kadeshi-Barinea. Kula phapho undaphiya hadi Hasari-Adari hadi Asimoni. ");
INSERT INTO dig_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Chisha nyo mphaka undagaluka phapho Asimoni na uphiye hadi chidzuho cha Misiri na usike baharini. ");
INSERT INTO dig_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","“Mphaka wenu wa uphande wa mtswerero wa dzuwa undakala pwani ya Bahari Kulu. ");
INSERT INTO dig_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","“Mphaka wenu wa uphande wa vurini undakala huno: Kula Bahari Kulu hadi mwango wa Hori. ");
INSERT INTO dig_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","Na kula mwango wa Hori hadi phatu pha kumenyera Hamathi, chisha hadi Sedadi. ");
INSERT INTO dig_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","Na kula phapho undaenderera hadi Zifuroni na umarigizike Hasari-Enani. Huno ndio ndiokala mphaka wenu wa uphande wa vurini. ");
INSERT INTO dig_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","“Mphaka wenu wa mlairo wa dzuwa undakala kula Hasari-Enani hadi Shefamu. ");
INSERT INTO dig_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Kula Shefamu, undatserera hadi Ribula, uphande wa mlairo wa dzuwa wa Aini na uenderere hadi miteremuko ya uphande wa mlairo wa dzuwa wa ziya ra Kinerethi, ");
INSERT INTO dig_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","utserere kulunga-lunga Joridani na usike Bahari ya Munyu. Ihi ndio ndiyokala tsi yenu na miphakaye ya chila uphande.” ");
INSERT INTO dig_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Phahi Musa achialagiza Aiziraeli achiamba, “Hino ndio tsi mundiyorisi kpwa kupiga kura, ambayo Mwenyezi Mlungu akalagiza ihewe zo mbari tisiya na nusu, ");
INSERT INTO dig_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","kpwa kukala atu a mbari ya Rubini, ya Gadi na nusu ya mbari ya Manase akahewa kare urisi wao kulengana na nyumba za akare ao. ");
INSERT INTO dig_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Mbari hizi mbiri na nusu zahewa kare phatu pha kurisi kuko ngʼambo ya phiri ya Joridani iriyo mlairo wa dzuwa napho ula Jeriko.” ");
INSERT INTO dig_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Mwenyezi Mlungu achigomba na Musa achimuamba, ");
INSERT INTO dig_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“Atu ndiokuganyirani yo tsi ni mlavyadzi-sadaka Eliazari na Joshuwa mwana wa Nuni. ");
INSERT INTO dig_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Chisha mundatsambula chilongozi mmwenga-mmwenga kula kpwa chila mbari ili akuteryeni kuganya yo tsi. ");
INSERT INTO dig_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Higa ndigo madzina gao: Kalebu mwana wa Jefune kula mbari ya Juda, ");
INSERT INTO dig_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Shemueli mwana wa Amihudi kula mbari ya Simioni, ");
INSERT INTO dig_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Elidadi mwana wa Kisiloni kula mbari ya Benjamini, ");
INSERT INTO dig_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Buki mwana wa Jogili kula mbari ya Dani, ");
INSERT INTO dig_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Hanieli mwana wa Efodi kula mbari ya Manase mwana wa Yusufu, ");
INSERT INTO dig_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Kemueli mwana wa Shifutani mbari ya Efuraimu, ");
INSERT INTO dig_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Elizafani mwana wa Parinaki kula mbari ya Zabuloni, ");
INSERT INTO dig_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Palitieli mwana wa Azani mbari ya Isakari, ");
INSERT INTO dig_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Ahihudi mwana wa Shelomi kula mbari ya Asheri ");
INSERT INTO dig_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","na Pedaheli mwana wa Amihudi, kula mbari ya Nafutali.” ");
INSERT INTO dig_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Hinya ndio atu Mwenyezi Mlungu arioalagiza aganye yo tsi ya Kanani ikale urisi wa Aiziraeli. ");
INSERT INTO dig_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Mwenyezi Mlungu achigomba na Musa kahi ya tsi ya kugbwa ya Moabu iriyo kanda-kanda ya muho Joridani, ngʼambo ya phiri napho ula Jeriko achimuamba, ");
INSERT INTO dig_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“Alagize Aiziraeli aaphe Alawi midzi ya kusagala kahi ya tsi ndiyokala yao, phamwenga na seemu zozunguluka yo midzi ikale mwatu mwa kurisa. ");
INSERT INTO dig_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Yo midzi indakala yao, nao andasagala mumo, namo mundakala na mwatu mwao mwa kurisa mifugo yao. ");
INSERT INTO dig_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","“Pho phatu pha kurisa mundiphoapha Alawi ni phakale phana ure wa mita magana mane na mirongo mitsano kula ukuta wa mudzi, kuzunguluka pande zosi za chila mudzi. ");
INSERT INTO dig_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Ko kondze ya nyo mudzi mundapima mita magana tisiya uphande wa mlairo wa dzuwa, mita magana tisiya uphande wa mtswerero wa dzuwa, mita magana tisiya uphande wa vurini, na mita magana tisiya uphande wa mwakani, kuzunguluka nyo mudzi. Hipho phandakala phatu phao pha kurisa. ");
INSERT INTO dig_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","“Midzi sita kahi ya yo midzi mundiyoipha Alawi indakala midzi ya kuchimbirira, ambayo mutu ndiyeolaga myawe bila kumanya andachimbirira. Chisha mundaenjereza midzi yanjina mirongo mine na miiri. ");
INSERT INTO dig_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Kpwa jumula ni muaphe Alawi midzi mirongo mine na nane phamwenga na phatu pha kurisa. ");
INSERT INTO dig_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Midzi ambayo mundaipha Alawi kula tsi ndiyohalwa ni Aiziraeli indalaviwa kulengana na urisi wa chila mbari. Kula mbari iriyo na midzi minji, mundahala midzi minji na kula mbari iriyo na midzi michache mundahala michache.” ");
INSERT INTO dig_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Chisha Mwenyezi Mlungu achigomba na Musa achimuamba, ");
INSERT INTO dig_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“Gomba na Aiziraeli uaambe: Mndiphovuka Joridani kuinjira tsi ya Kanani, ");
INSERT INTO dig_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","mundatsambula midzi ya kuchimbirira, ambayo mutu ndiyeolaga myawe bila kumanya andachimbirira. ");
INSERT INTO dig_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Kuko kundakala ni kpwatu kpwa kuchimbirira ili kudzitivya na mutu ambaye analonda kuriphiza chisasi, ili ye mutu ariyeolaga asiolagbwe hadi ahukumiwe mbere za mkpwutano. ");
INSERT INTO dig_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Midzi sita ndiyoilavya indakala ni midzi yenu ya kuchimbirira. ");
INSERT INTO dig_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Mundalavya midzi mihahu kula ngʼambo ihi ya Joridani na yo midzi yanjina mihahu kula tsi ya Kanani. ");
INSERT INTO dig_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Midzi ihi sita indakala ni midzi ya kuchimbirira kpwa Aiziraeli, ajeni asagalao phamwenga namwi kpwa muda mfupi au mure, ili mutu ndiyeolaga myawe bila kumanya aphahe kuchimbirira kuko. ");
INSERT INTO dig_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“Ela mutu achimpiga myawe na chifwaya cha chuma ili amuolage, mutu iye ni muolagadzi naye ni aolagbwe. ");
INSERT INTO dig_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Na mutu achimpiga dziwe myawe hata achimuolaga, mutu iye ni muolagadzi na ni lazima aolagbwe. ");
INSERT INTO dig_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Ama mutu achimpiga myawe na chifwaya cha muhi chiwezacho kuolaga na afwe, mutu iye ni muolagadzi na ni lazima aolagbwe. ");
INSERT INTO dig_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Ye muolagadzi andaolagbwa ni mutu wa phephi wa ye mutu ariyeolagbwa. Achikutana naye andamuolaga kumuriphizira chisasi mʼbariwe. ");
INSERT INTO dig_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Mutu achireyera myawe na amsukume au amtsuphire utu kusudi naye afwe, ");
INSERT INTO dig_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","au kpwa uadui ampige ngumi hata ye myawe afwe, mutu iye ni muolagadzi na ni lazima aolagbwe. Mutu wa phephi wa ye achiyeolagbwa andamuolaga ndiphokutana naye. ");
INSERT INTO dig_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“Ela mutu achimsukuma myawe gafula na katsukirirwe au achimtsuphira utu bila ya kumanya, ");
INSERT INTO dig_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","au bila kulola atsuphe dziwe rikampige mutu wanjina naye afwe, kpwa kukala ye achiyefwa kakarire na uadui na ye mtsuphi wa dziwe kakakusudiya kumlumiza, ");
INSERT INTO dig_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","phahi, mkpwutano ni uamule kahi ya ye achiyeolaga na ye mʼbari wa ye ariyeolagbwa alondaye kuriphiza chisasi kulengana na shariya hizi. ");
INSERT INTO dig_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Mkpwutano ni umuokole ye achiyeolaga na iye mʼbari wa ye ariyeolagbwa na kumuuyiza ko mudzi wa kuchimbirira ariokala akachimbirira. Ni aenderere kusagala kuko hadi mlavyadzi-sadaka mkpwulu wa wakati hinyo ariyemwagirwa mafuha afwe. ");
INSERT INTO dig_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Ela ye achiyeolaga wakati wowosi achituluka kondze ya nyo mudzi ariouchimbirira, ");
INSERT INTO dig_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","na ye alondaye kuriphiza chisasi amuone kondze ya nyo mudzi wa kuchimbirira na amuolage, iye kandakala na makosa ga kumuolaga. ");
INSERT INTO dig_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Mana ye achiyeolaga ni asale ndani ya mudzi wa kuchimbirira hadi mlavyadzi-sadaka mkpwulu afwe ndipho auye kpwao. ");
INSERT INTO dig_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","“Higa gandakala malagizo ga chishariya kpwenu na vivyazi vyenu vyosi kokosi mundikokala. ");
INSERT INTO dig_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","“Mutu yeyesi achiolaga mutu, ni aolagbwe kpwa ushaidi wa zaidi ya mutu mmwenga, ela takuna mutu yeyesi ndiyeolagbwa kpwa ushaidi wa mutu mmwenga. ");
INSERT INTO dig_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","“Msikubali kuhala kore kpwa kukombola roho ya achiyeolaga ariyehukumiwa kuolagbwa. Mutu hiye ni aolagbwe. ");
INSERT INTO dig_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","“Msikubali kuphokera kore kpwa ajili ya mutu achiyechimbirira mudzi wa kuchimbirira ili mumuruhusu auye kpwao kabila ya ye mlavyadzi-sadaka mkpwulu kufwa. ");
INSERT INTO dig_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","“Msiitiye najisi tsi msagalayo, mana ko kuolaga kunaihenda yo tsi ikale najisi na takuna sadaka yoyosi iwezayo kutakasa tsi isiphokala ya ye achiyeolaga. ");
INSERT INTO dig_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Msiitiye najisi tsi msagalayo na nisagalayo mimi, mana mimi Mwenyezi Mlungu nasagala kahi za Aiziraeli.” ");
INSERT INTO dig_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Vilongozi a atu a chivyazi cha Giliadi mwana wa Makiri, mwana wa Manase a chivyazi cha Yusufu, akpwendagomba na Musa na nyo vilongozi anjina a mbari za Iziraeli ");
INSERT INTO dig_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","achiamba, “Mwenyezi Mlungu wakulagiza uwe bwana wehu kukala uaganyire Aiziraeli tsi kpwa kuhumira njira ya kupiga kura. Piya wakulagiza ulavye mtalo wa mwenehu wehu Selofehadi kpwa anae achetu. ");
INSERT INTO dig_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Ela achilólwa ni Aiziraeli a mbari zanjina, seemu yao indauswa kahi ya urisi wa akare ehu na kutsanganywa na wa yo mbari ambayo andakala akalólwa. Kpwa hivyo seemu ya urisi wehu indahalwa. ");
INSERT INTO dig_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Mwaka wa kuikpwa huru Aiziraeli uchifika, urisi wao undaenjerezwa kpwenye urisi wa yo mbari ambayo andakala akalólwa, na indauswa kula kpwa urisi wa akare ehu.” ");
INSERT INTO dig_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Phahi Musa achialagiza Aiziraeli kulengana na neno ra Mwenyezi Mlungu achiamba, “Higo agombago atu a mbari ya Manase mwana wa Yusufu ni ga kpweli. ");
INSERT INTO dig_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Vivi ndivyo Mwenyezi Mlungu arivyolagiza kuhusu ana achetu a Selofehadi: Ana uhuru wa kulólwa ni mutu yeyesi alondaye, ela ni akale ni wa kula kahi ya adugu a mbari ya ise yao, ");
INSERT INTO dig_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","ili kusikale na urisi wowosi wa Aiziraeli ndiotsamizwa kula mbari mwenga hadi mbari yanjina, mana Aiziraeli osi andasala na urisi wa mbari za akare ao. ");
INSERT INTO dig_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Chila mwana mchetu ariye na urisi kahi za mbari yoyosi ya Iziraeli ni alólwe ni mdugu wa ise, ili Aiziraeli osi aphahe urisi wa ise zao. ");
INSERT INTO dig_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Taphana urisi ndiotsamizwa kula mbari mwenga hadi yanjina. Chila mbari ya Aiziraeli indasala na urisiwe.” ");
INSERT INTO dig_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Phahi ana achetu a Selofehadi ahenda dza Mwenyezi Mlungu arivyomlagiza Musa. ");
INSERT INTO dig_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Nao kala ni Mahala, Tirisa, Hogila, 