﻿USE sofia;
DROP TABLE IF EXISTS sofia.dif_vpl;
CREATE TABLE dif_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES dif_vpl WRITE;
INSERT INTO dif_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Pantjipantjini‐jaura Jesu Christungundru, Davidani ngatamuraia, Abrahamani ngatamuraia; ");
INSERT INTO dif_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahamali kantji patana wonti Isaak, Isaakali kantji patana wonti Jacob, Jakobali kantji patana wonti Juda ja neji ja ngatata nunkani; ");
INSERT INTO dif_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judali kantji patana wonii Phares ja Zara Thamarangundru, Pharesali kantji patana wonti Esrom, Esromali kantji patana wonti Aram; ");
INSERT INTO dif_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aramali kantji patana wonti Aminadab, Aminadabali kantji patana wonti Naasson, Naassonali kantji patana wonti Salmon; ");
INSERT INTO dif_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmonali kantji patana wonti Boas Rahabangundru, Boasali kantji patana wonti Obed Ruthangundru, Obedali kantji patana wonti Jessai; ");
INSERT INTO dif_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jessaili kantji patana wonti mitaia kapara David, David mitaia kaparali kantji patana wonti Salomo Uriani noandru; ");
INSERT INTO dif_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomojeli kantji patana wonti Rehabeam, Rehabeamali kantji patana wonti Abia, Abiali kantji patana wonti Asa; ");
INSERT INTO dif_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asali kantji patana wonti Josaphat, Josaphatali kantji patana wonti Joram, Joramali kantji patana wonti Usia; ");
INSERT INTO dif_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usiali kantji patana wonti Jotham, Jothamali kantji patana wonti Ahas, Ahasali kantji patana wonti Hiskias; ");
INSERT INTO dif_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hiskiasali kantji patana wonti Manasse, Manassili kantji patana wonti Amon, Amonali kantji patana wonti Josia; ");
INSERT INTO dif_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiali kantji patana wonti Jechonia ja ngatata nunkani, jendranguta tanali tanana wapalkana wonti Babylaia, ");
INSERT INTO dif_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ja tanali tanana Babylaia matja wapalkana, Jechoniali kantji patana wonti Salathiel, Salathieli kantji patana wonti Serubabel; ");
INSERT INTO dif_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabelali kantji patana wonti Abiud, Abiudali kantji patana wonti Eliakim, Eliakimali kantji patana wonti Azor; ");
INSERT INTO dif_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azorali kantji patana wonti Sadok, Sadokali kantji patana wonti Achim, Achimali kantji patana wonti Eliud; ");
INSERT INTO dif_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudali kantji patana wonti Eleasar, Eleasarali kantji patana wonti Matthan, Matthanali kantji patana wonti Jacob; ");
INSERT INTO dif_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacobali kantji patana wonti Joseph, Mariananka noa, nankangundru dankana wonti Jesus, tala nunkani Christus. ");
INSERT INTO dif_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kapara pratjana Abrahamangundru Davidanilu marapratjana ja mandrumandru nganai; Davidandru Babylaia wapalkanantulu kapara marapratjana ja mandrumandru nganai; Babylaia wapalkanandru Christungulu kapara marapratjana ja mandrumandru nganai. ");
INSERT INTO dif_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesus Christus dankana wonti jeruja: Maria, ngandri nunkani, matja talpadakaterina Josephangu, windrila pudla jela ngamala, nandru mankamankana wonti, nani mandrantju nganana wonti Jaolali kulikirieli. ");
INSERT INTO dif_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ngangau Joseph, noa nankani, talku nganana wonti, ja wata jertapaterina wonti nana nintali ngankala, nulu ngundrana wonti, nana kurukuru worarala. ");
INSERT INTO dif_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nulu jenia ngundranani, mai, Godaia angela kulno ngapitjani nunkangu wondraterina wonti ja jatana wonti: „Josephajai, Davidani ngatamurajai, wata japali nganau, Maria, noa jinkani patala; ngangau mina nandru patana warai, Jaola kulikirindru nganai. ");
INSERT INTO dif_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nandru kupa kanku kantji patala nganai; nina jundru JESUS dikala nganai; ngangau kana wolara nunkani Nulu kulkala nganai tanani madlentjandru.“ ");
INSERT INTO dif_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Jenia pratjana pantjina wonti, ngangau morlalu pantjinanto, mina Prophetali Kaparandru kaukaubana wonti, nau jatana wonti: ");
INSERT INTO dif_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","„Mai! ngameri kulno mandrantju nganala nganai, ja nandru kupa kanku kantji patala nganai, ja tanali tala nunkani dikala nganai «Emmanuel», jenia wondrai: Goda‐ngaianangunto.“ ");
INSERT INTO dif_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Joseph mukandru matja jiritjina, nulu jeruja ngankana wonti, worderu Kaparaia angelali nunkangu jirijiribana warai, ja nulu noa nunkani patana wonti. ");
INSERT INTO dif_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ja nulu wata nana ngujamana wonti, nandru kupa kanku dankanantulu, ja nulu tala nunkani dikana wonti: „JESUS“. ");
INSERT INTO dif_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesus matja kupa dankana warai Bethlehemingu, Judaia mitani, Herodini mitaia kaparaia ditjini; mai, jendranguta kana kiri wora tiriwandru Jerusalemingu wokarana wonti, ");
INSERT INTO dif_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ja jatana wonti: „Woderi nau, Juda‐kanaia‐kapara matja dankana? Ngangau ngaiani ditji waka nunkani najinala tiriwani, ja wokarana warai nunkangu pantjaterkana ngarila.“ ");
INSERT INTO dif_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Herodes, mitaia kaparali, jenia matja ngarana, nau japali ngaruparana wonti, ja nunkangu jela Jerusalemala warupoto. ");
INSERT INTO dif_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ja nulu kana wolaraia Priesta pirna ja jaura jinkinietja pratjana kampana wonti ja tanana jekijekibana wonti, woderi Christus dankananto. ");
INSERT INTO dif_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ja tana nunkangu jatana wonti: „Bethlehemingu Judaiani“; ngangau jeruja Prophetali dakana wonti: ");
INSERT INTO dif_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","„Ja jidni Bethlehemiai, Judaia mitani, jidni wata ngadanietja nganai Judaia kapara marapuni, a‐ai, ngangau jinkangundru kapara dunkala nganai, Nulu kana wolara ngakani, Israel, ngamalkala nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ngadani Herodili kana kiri worana kurukuru karkana wonti ja tanana jiglerali jekijekibana wonti, winta ditji waka wondraterinala. ");
INSERT INTO dif_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ja nulu tanana Bethlehemia jinpana wonti ja jatana wonti: „Palkanimai ja kupa parparali wontianau, ja jura nina matja mankamankana, ngakangu jaura tikalkanau, ngani bakana wokarananto nunkangu pantjaterkana ngarila.“ ");
INSERT INTO dif_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Tanali mitaia kapara matja ngarana, tana palkana wonti. Ja mai, ditji waka nina tanali tiriwa najinala, tanangu ngopera wapana wonti, nau wokaranantulu miri banbala, woderi kupa nganana wonti. ");
INSERT INTO dif_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Tanali nina ditji waka najina, tana murlali pirna mankina wonti; ");
INSERT INTO dif_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ja tana pungani matja wirina, tanali kupa waka najina wonti Mariangu, ngandrini nunkanani jela; ja tana pantjaterkana ngarina wonti nunkangu, ja tanali poto pirna piltana wonti, ja nunkangu poto jinkina wonti: Marda, maralje, kuli ngumu ja kaldri pilki. ");
INSERT INTO dif_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ja Godali tanana ngapitjani daudauana wonti, tana wata morla Herodingu tikananto. Ja palto worku tana nakaldra tikana wonti mitaia tananaia.");
INSERT INTO dif_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Tana matja puntina, mai, Kaparaia angela kulno Josephangu ngapitjani wondraterina wonti ja jatana wonti: „Jiritjiau ja kupa ja ngandri nunkani manina kurau ja kuri‐kariau Egypta mitaia, ja naka ngamamai, ngani jinkangu jatanantulu; ngangau Herodes jertapateriai kupa wontila ninapara nandrala.“ ");
INSERT INTO dif_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Nau jiritjina wonti ja kupa ja ngandri nunkani manina kurana wonti tinkani, ja kutingana wonti Egypta mitaia. ");
INSERT INTO dif_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ja nau naka ngamana wonti Herodes palinantulu, ngangau morlalu pantjinanto, mina Prophetali Kaparandru kaukaubana wonti, nau jatana wonti: „Egypta mitandru ngato Ngatamura ngakani karkana wonti.“ ");
INSERT INTO dif_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herodili matja najina, kana kiri worali nina jedibala wiri, nau pirna tiririna wonti, ja nulu jinpana wonti Bethlehemingu ja wondirani pratjanani nunkanani ja kupa kanku pratjana nandrana wonti, tana kilpawoldra mandru ja morla waka nganana wonti, tanangupini ditjini, tanana nulu kana kiri worangu jekibala wiri. ");
INSERT INTO dif_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Jendranguta morlalu pantjina wonti, mina Jeremiasili Prophetali kaukaubana wonti, nau jatana wonti: ");
INSERT INTO dif_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","„Ramangu tanali ngaiala ngarana wonti, miritja ja jildri ja juajuangana pirna; Rahel nankani kupandru jindrana wonti ja wata ngantjana wonti ngankalkananto, ngangau tana panila nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herodes matja nari, mai, Kaperaia angela kulno ngapitjani Josephangu wondraterina wonti Egypta mitani, ");
INSERT INTO dif_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ja jatana wonti: „Jiritjiau ja kupa ja ngandri nunkani manina kurau, ja tikau, Israel mitaia; ngangau tana matja nari, tanali kupaia tepi wontina wonti.“ ");
INSERT INTO dif_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Nau jiritjina wonti ja kupa ja ngandri nunkani manina kurana wonti ja Israel mitani wokarana wonti. ");
INSERT INTO dif_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Nulu matja ngarana, Archelaus Judaia mitaia kapara nganai Herodini ngaperaia nunkanaia pirini, nau japali pantjina wonti nakani palkala; ja nulu ngapitjali jirijiribani jaura manina wonti, ja nau palkana wonti Galilaia mitaia. ");
INSERT INTO dif_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ja nau wokarana wonti ja ngamana wonti ngura kulnuni, tala nunkani Nazareth; ngangau morlalu pantjinanto Prophetaia jaura: „Tanali nina Nazarethala dikala nganai.“");
INSERT INTO dif_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tanangupini ditjini Johannes multibanietja wokarana wonti ja Judaia pitarani jaura jinkina wonti, ");
INSERT INTO dif_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ja jatana wonti: „Madlentjandru karitjianau, ngangau pariwilpaia milila karakara nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Naupini nau nganai, nunkangundru Jesaiasali Prophetali kaukaubana wonti; „Karkanietjaia ngaiala pitarani parai: Kaparaia palto ngankinganimai, ja tidna‐palto nunkani talku ngankanimai.“ ");
INSERT INTO dif_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Johannili kati Kameel njurdu ja dala mantamanta kapani nunkanani ngamalkana wonti, ja buka nunkani palaparu ja pitjambu nganana wonti. ");
INSERT INTO dif_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jendranguta nunkangu dunkana wonti Jesusalemala ja Judaiala pratjaterina ja Jordanala pratjaterina. ");
INSERT INTO dif_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ja nulu tanana multibana wonti Jordan kaiarani, ja tanali madlentji tanani talku dikana wonti. ");
INSERT INTO dif_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nulu Pharisaiala ja Sadduzaiala marapu nunkani multibanilaia wokaranani najina, nau tanangu jatana wonti: „Wiparaia kuparu worajai! warlenulu jurangu wondrana warai japa mindrinanto tirini nunkanani, nau wokarala nganai?“ ");
INSERT INTO dif_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Madlentjandru karitjinaia tandra talku punkibanau! ");
INSERT INTO dif_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ja wata munta ngundraterianau: „Ngaiana Abraham ngaperi ngaianani ngamalkai“; ngangau ngani jurangu jatai: „Goda ngurunguru nganai, tanangupini mardandru kupa jiritjibala Abrahamangu.“ ");
INSERT INTO dif_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kalara matja pita kaparani parai; Pita pratjana, wata tandra ngumu punkibanani, wokaribala nganai ja turuni worala nganai. ");
INSERT INTO dif_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ngato jurana ngapali multibai madlentjandru karitjimalkala; ngakangu ngadani kulno wokarala nganai, Nau morla ngurunguru nganai ngakangu, nunkangu ngani wata talku nganai, tidnaputa nunkani padakijiribala, Nulu jurana multibala nganai Jaolali kulukirieli ja turujeli. ");
INSERT INTO dif_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Marani nunkanani pirra nunkani parai, ja Nulu jiraua nunkani darpala nganai, ja buka tandra nunkani kampani pungaia mapala nganai, ja ngurdi Nulu japila nganai turujeli, nau wata paliai. ");
INSERT INTO dif_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ngadani Jesus Galilaiandru Jordan kaiarani Johanningu wokarana wonti, nunkangundru multibanila manila. ");
INSERT INTO dif_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Johannili nina daudauana wonti ja jatana wonti: „Ngato jinkangundru multibanila maninanto, ja jidni ngakangu wokarai“? ");
INSERT INTO dif_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesujeli kalabana wonti ja nunkangu jatana wonti: „Karari jenia manuni kurau, ngangau jeruja talku nganai ngaldrangu, talkula pratjana morlalu kurala.“ Ngadani nulu nunkangu manuni kurana wonti. ");
INSERT INTO dif_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jesujeli matja multibanila manina, Nau nurujeli ngapandru dunkana tarana wonti; ja mai, pariwilpa piririna wonti, ja nulu najina wonti Godaia Jaola ngarinani mulapara jeribaka wokarala nunkangu. ");
INSERT INTO dif_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ja mai! Ngaiala pariwilpandru jatana wonti: „Naupini Ngatamura ngantjalu ngakani nganai, nunkangu ngani murlali nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Jendranguta Jaolali Jesus pitaraia taralkana wonti, kutjieli nina wontjananto. ");
INSERT INTO dif_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ja Nau pota mandrumandru marapratjana ditji, ja pota mandrumandru marapratjana tinka milja ngamana warai, Nau ngadani mauali nganana wonti. ");
INSERT INTO dif_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ja wontjanietja nunkangu wokarana wonti ja jatana wonti: „Jidni Godaia Ngatamura ngananani, jatamai, tanapini marda bukarinanto.“ ");
INSERT INTO dif_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Nulu kalabana wonti ja jatana wonti: „Dakanala parai: Kana wata windri bukandru tepiriai, a‐ai, jaura warupotundru, nauja Godaia manandru dunkai.“ ");
INSERT INTO dif_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ngadani kutjieli nina ngura kulikiria padakana wonti, ja nina Godaia punga wutjuni terkibana wonti, ");
INSERT INTO dif_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ja nunkangu jatana wonti: „Jidni Godaia Ngatamura ngananani, ngarinalu kulkungamai; ngangau dakanala parai: Nulu angelani nunkanani jirijiribala nganai jinkangundru, tanali jidna marali ngamalkala nganai, wata jidni tidna mardani dakaterinanto.“ ");
INSERT INTO dif_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesus nunkangu jatana wonti: „Nakaldra dakanala parai: Goda Kapara jinkani wata wontjamai“! ");
INSERT INTO dif_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Nakaldra kutjieli nina mardawonpa miri pirnaia taralkana wonti ja nunkangu wondrana wonti mitaia kaparaia warupotuja milila ja pirnala tanani, ");
INSERT INTO dif_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ja nunkangu jatana wonti: „Tananapini warupoto ngato jinkangu jinkila nganai, jidni ngakangu pantjaterkana ngarinani ngatjila.“ ");
INSERT INTO dif_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ngadani Jesus nunkangu jatana wonti: „Kutingau Satanajai! ngangau dakanala parai: Jidni Godani Kaparani jinkanani ngatjiamai ja windri nunkangu wodatarana ngamamai.“ ");
INSERT INTO dif_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ngadani kutjieli nina worarana wonti, ja mai, angela wora nunkangu wokarana wonti ja nunkangu mili nganana wonti.");
INSERT INTO dif_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jesujeli matja ngarana, tanali Johannes kanjangari pungani widmana warai, Nau puntina wonti Galilaiaia; ");
INSERT INTO dif_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ja Nulu Nazareth worarana wonti ja ngura manina wonti Kapernaum ngamala, nau panto dirkalani parai, Sebulon ja Naphthali wondirani; ");
INSERT INTO dif_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ngangau morlalu pantjinanto, mina Jesaiasali Prophetali kaukanbana wonti, nau jatana wonti: ");
INSERT INTO dif_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","„Sebulon mitali ja Naphthali mitali pantunkari, Jordan kaiarani jerankari, ja Galilaialali kojeli, ");
INSERT INTO dif_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Kana wolarali, tana ngalpurani ngamai, praitji pirna najina wonti, ja tanangu, tana naria pirini ja pungalani ngamai, tanangu praitji dunkana tarana wonti.“ ");
INSERT INTO dif_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jendranguta Jesujeli wonina wonti kaukaubala ja jatala: „Madlentjandru karitjianau, ngangau pariwilpaia milila karakara nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesus Galilaia pantuni dirkalani wirarina wonti, ja Nulu neji mara wulana najina wonti, Simon, nina talali dikai Petrus, ja Andreas ngatata nunkani; pudlali jama pantuni worana wonti, ngangau pudla paru maninietja nganana wonti. ");
INSERT INTO dif_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ja Nau pudlangu jatana wonti: „Ngakangu karipaterialumai; ngato judlana kana maninietja ngankala nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Pudlali nurujeli jama worarana wonti ja nunkangu karipaterina wonti. ");
INSERT INTO dif_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ja Nau nakandru morla wapana wonti, ja Nulu neji mara mandru morla najina wonti, Jakobus, Zebedäuni ngatamura, ja Johannes, ngatata nunkani; pudlali botani Zebedäus, pudlani ngaperani jela, jama karpana wonti. Ja Nulu pudlana karkana wonti. ");
INSERT INTO dif_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Pudlali nurujeli bota ja ngaperi pudlani worarana wonti ja nunkangu karipaterina wonti.");
INSERT INTO dif_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ja Jesus Galilaiani paruparu wirarina wonti ja jaura pungani tananani ngujangujara jinkina wonti, ja ngantjani jaura mililandru kaukaubana wonti, ja muntja ja waltowalto pratjana Nulu tepi ngankana wonti kana wolarani. ");
INSERT INTO dif_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ja pinti nunkangundru dunkana wonti Syria mitaia paruparu, ja tanali nunkangu muntja pratjana padakana wonti, tana muntja ja ketjaketjana pilki ja pilki nganana wonti, ja kana kutjinto ja pirala muntja ja tjunduru; ja Nulu tanana pratjana katitepi ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ja kana wolara marapu nunkangu karipaterina wonti Galilaiandru ja Dekapolis mitandru ja Jerusalemingundru ja Judaiandru ja Jordan kaiari jerankarindru. ");
INSERT INTO dif_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Matja Nulu kana wolara najina, Nau mardawonpaia tarana wonti; ja Nau matja ngamana ngarina, mili nunkani nunkangu wokarana wonti. ");
INSERT INTO dif_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ja Nau mana wilparina wonti, ja Nulu tanangu ngujangujara jinkina wonti ja jatana wonti: ");
INSERT INTO dif_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Murlali pirna, tana mungarali wangiwangi, ngangau pariwilpaia milila tanangu nganai. ");
INSERT INTO dif_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Murlali pirna, tana ngaurongauro, ngangau tanali ngankalkani manila nganai. ");
INSERT INTO dif_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Murlali pirna, tana malti nganai, ngangau tanali mita maru ngamalkala nganai. ");
INSERT INTO dif_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Murlali pirna, tana mauali ja tertieli nganai talkulaia, ngangau tana bulurila nganai. ");
INSERT INTO dif_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Murlali pirna, tana kalumiltjamiltjariai, ngangau tanangu kalumiltjamiltjarina nganala nganai. ");
INSERT INTO dif_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Murlali pirna, tana ngara kulikiri nganai, ngangau tanali Goda najila nganai. ");
INSERT INTO dif_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Murlali pirna tana wadlietja, ngangau tanana tanali Godaia kupa dikala nganai. ");
INSERT INTO dif_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Murlali pirna tana, tanangu kana talkulandru tirikaripateriai, ngangau tanangu pariwilpaia milila nganala nganai. ");
INSERT INTO dif_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Murlali pirna jura nganai, tanali jurana ngirkibanani ja tirikaripaterinani ja madlentji marapu jurangu jatanani jedinali ngakangundru. ");
INSERT INTO dif_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mankianimai ja murlali ngananau, ngangau kalala jurani pirna nganai pariwilpani; ngangau jeruja tana bakana Propheta worangu, jurangu ngopera ngananala, tirikaripaterina wonti. ");
INSERT INTO dif_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jura mitaia kaldri nganai. Kaldri dunkarinani, minali tanali kaldri ngankala nganai? Nau baku nganai, ja kanali nina teribala nganai ja tidnali nankanankala nganai. ");
INSERT INTO dif_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Jura mitaia praitji nganai. Ngura kulno, mardawanpani miri paranani, wata kurukuru nganai. ");
INSERT INTO dif_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Tanali wata praitji miribai ja kokuni ngarinalu widmai, a‐ai, praitjaia potuni, ja nau pratjanani mintjiai, tana pungani ngamanani. ");
INSERT INTO dif_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Jeruja praitji jurani mintjiatimai kanani, ngangau tanali ngankani ngumu jurani najinanto ja Ngapari jurani pariwilpani jurakokananto. ");
INSERT INTO dif_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Wata ngundranau, ngani wokarana warai jirijiribani‐jaura kara, Prophetaia jaura kara dukarala, a‐ai, ngani wata wokarana warai, ninaia dukarala, windri morlalu kurala. ");
INSERT INTO dif_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ngangau morlalu ngani jurangu jatai: „Pariwilpa ja mita maru mudanantulu, wata tiwi kulno kara, malka wakawaka kulno kara jirijiribani jaurandru mudala nganai, jenia pratjana morlalu pantjinantulu.“ ");
INSERT INTO dif_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Warlenulu nunkangupini jirijiribani jaurandru kulno wakawaka dukaranani ja jeruja kanani ngujangujara jinkinani, nau wakawaka nganala nganai pariwilpaia mililani; warlenulu tanana ngankanani ja ngujangujara jinkinani, nau pirna nganala nganai pariwilpaia mililani. ");
INSERT INTO dif_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ngangau ngani jurangu jatai: „Talkula jurani wata morla ngumu ngananani jaura jinkinietjaia ja Pharisaiaia, jura morlalu wata pariwilpaia mililani wirila nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jura matja ngarana, worderu Nauja pinaru worangu jatana wonti: „Wata narielu nandramai“! warlenulu narielu nandrai, nunkangu kalala parai. ");
INSERT INTO dif_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ja ngani jurangu jatai: „Worananau ngatatani nunkanani baku tiririnani, nunkangu kalala parai; ja worananau ngatatani nunkanani jatai: «Raka», nunkangu kalala parai kaparani; ja worananau nunkangu jatai: «Jidni jirijiri», nunkangu kalala parai turu ngurali.“ ");
INSERT INTO dif_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ngangau jundru poto jinkani Altaraia padakanani, ja naka mangatandra wilparinani, ngatata jinkani jinkangu kuteriai, ");
INSERT INTO dif_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Jeruja poto jinkani naka Altara bankini woraramai, ja ngopera wapau, ja ngatatani jinkanani kulnukulnuni ngankateriamai, ja ngadani wokarau ja poto jinkani jinkiamai. ");
INSERT INTO dif_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Nurujeli murlali nganamai talpalani jinkanani, Jeruntjaia ditji jidni nunkangunto paltuni nganai; talpalali jidna kalala kuranietjani jinkiati, ja kalala kuranietjali jidna jinkiati milini, ja jidna kanjangari pungani widmaiati. ");
INSERT INTO dif_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Morlalu ngani jinkangu jatai: „Jidni wata morla nakandru dunkala nganai, jundru ngopera mudani marda jinkinantulu.“");
INSERT INTO dif_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Jura matja ngarana, worderu Nauja pinaru worangu jatana wonti: „Wata pinta wokaribamai“! ");
INSERT INTO dif_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ja ngani jurangu jatai: „Warlenulu widla najinani, nankangu milkirina, nulu matja ngarali nankangunto pinta wokaribana warai.“ ");
INSERT INTO dif_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Milki ngunarali jidna karkarkanani, ninaia dukarau ja worau jinkangundru; ngangau jinkangu ngumu nganai jinkani palku buru kulno tintananto, Nulia palku buru pratjana turuni woraiati. ");
INSERT INTO dif_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ja mara ngunarali jidna karkarkanani, ninaia wokaribau, ja jinkangundru worau; ngangau jinkangu ngumu nganai, jinkani palku buru kulno tintananto, palku buru pratjana turuni wiriati. ");
INSERT INTO dif_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Nauja jatana wonti: „Warlenulu noa nunkani woraranani, nulu nankangu narrani dakani jaura jinkinanto.“ ");
INSERT INTO dif_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ja ngani jurangu jatai: „Warlenulu noa nunkani woraranani, nani wata kantji palakantji ngananani, nulu nana pinta wokaribanietja ngankai; ja warlenulu narrani widla patanani, nulu pinta wokaribai.“ ");
INSERT INTO dif_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Nakaldra jura matja ngarana, worderu Nauja pinaru worangu jatana wonti: „Wata jedinali jaura morlalu jatamai, ja Kaparani jaura morlalu jinkani kuramai.“ ");
INSERT INTO dif_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ja ngani jurangu jatai: „Wata jaura morlalu jatamai, wata pariwilpani kara, ngangau nauja Godaia ngamani piri nganai. ");
INSERT INTO dif_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Wata mitani kara, ngangau nauja nunkani tidnaia piri nganai, wata Jerusalemingu kara, ngangau nauja kapara pirnaia ngura nganai. ");
INSERT INTO dif_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Bakana wata jinkani mangatandrani jaura morlalu jatamai, ngangau jidni ngandandariai, para kulno maru kara, waru kara ngankala.“ ");
INSERT INTO dif_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Jaura jurani nganaiatimai: „Kau, kau; pani, pani;“ mina pudlangu pinpi tarai, jenia madlentjandru dunkai. ");
INSERT INTO dif_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Jura matja ngarana, worderu Nauja jatana wonti: „Milki milkini, manatandra manatandrani.“ ");
INSERT INTO dif_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ja ngani jurangu jatai: „Madlentjani wata ngandrawalkaterianau, a‐ai, warlenulu jidna ngadla ngunari nandrai, nunkangu bakana nguru jinkiteriau. ");
INSERT INTO dif_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ja warlenulu ngundrai jinkangu tjakakijiribamalila kati waka jinkani manila, nunkangu bakana kati pirna worarau. ");
INSERT INTO dif_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ja warlenulu jidna winpai nunkangu jela karakara wirarila, nunkangu jela worita wirariau. ");
INSERT INTO dif_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Worananau jinkangu ngatjiai, nunkangu jinkiau; ja warlenulu ngantjai jinkangundru woljaia manila, wata nunkangundru kulkateriau.“ ");
INSERT INTO dif_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Jura matja ngarana, worderu Nauja jatana wonti: „Kamaneli jinkani ngantjamai, ja talpalani jinkanani kalakalariamai.“ ");
INSERT INTO dif_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ja ngani jurangu jatai: „Talpala jurani ngantjanimai; tanali jurangu kalala madlentji kuranani, tanangu kalala ngumu kuranau; tana jurangu kalakalarinani, tanangu ngumu ngankanimai; tanali jurana ngirkibanani ja jurangu tirikaripaterinani, tanangundru ngatjianimai. ");
INSERT INTO dif_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ngangau jura kupa nganananto Ngaperaia juranaia, Nauja pariwilpani; Nulia ditji pirna nunkani dunkalkai kanani madlentjani ja kanani ngumuni, ja talara jinkiai kana talkuni ja tjikatjikani.“ ");
INSERT INTO dif_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ngangau jura tanana ngantjanani, tanali jurana ngantjai, mina kalala jura ngamalkai? Wata mardatandrakampanietja jenildramata? ");
INSERT INTO dif_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ja jura jaura murlali jinkinani windri ngatatani juranani, mina pilkildra jura ngankai? Wata mardatandrakampanietja jeruldramata? ");
INSERT INTO dif_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Talku ngananau worderu Ngaperi jurani pariwilpani talku nganai. ");
INSERT INTO dif_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ngamalkaterianau, talkula jurani wata kana mudlani ngankala, tanali jurana najinanto; jura kalala pani Ngaperani juranani pariwilpani ngamalkaiati. ");
INSERT INTO dif_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Jundru kalumiltjamiltjarinali jinkinani, wata wima‐kokujeli ngaiala ngankamai, kana jeljujeljujeli jeribaka, tanali jaura pungani ja paltuni jeruja ngankai, jendrania kanali tanana jurakokananto. Morlalu ngani jurangu jatai: „Tanali kalala tanani matja ngamalkai.“ ");
INSERT INTO dif_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Jundru kalumiltjamiltjarinali jinkinani, mara worangantju wata milkila nganananto, mina ngunarali ngankai. ");
INSERT INTO dif_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Kalumiltjamiltjarina jinkani kurukuru nganananto, ja Npaperali jinkanali kurukuruni najiai, ja Nulia jinkangu kalala jinkila nganai tinkari. ");
INSERT INTO dif_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ja jidni ngatjinani, wata kana jeljujelju jeribaka nganamai, ngangau tanali ngantjai jaura pungani ja palto buruni terkana ngatjila, jendrania kanali tanana najinanto. Morlalu ngani jurangu jatai: „Tanali kalala tanani matja ngamalkai.“ ");
INSERT INTO dif_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Jidni ngatjinani, punga wapuni wiriau, ja mana ngandrawalkateriau, ja ngatjiau Ngaperani jinkanani, Nauja kurukuruni nganai, ja Ngaperali jinkanali kurukuruni najiai, ja Nulia jinkangu kalala jinkila nganai tinkari. ");
INSERT INTO dif_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Jura ngatjinani, wata manabaka ngarranau kana ko jeribaka; ngangau tanali ngundrai, jaura marapundru Godali tanana ngarala nganai. ");
INSERT INTO dif_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Wata tanali jeribaka ngundranau; ngangau Ngaperi jurani milkila, mina jura ngamalkananto, windrila jura nunkangu ngatjinani. ");
INSERT INTO dif_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Jeruja ngatjianau: „Ngaperi ngaianini, jidni pariwilpani ngamala wapaia; Tala jinkani kulikiri pantjiatimai; ");
INSERT INTO dif_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Milila jinkani wokaraiatimai; Jertapaterina jinkani pantjiatimai, worderu pariwilpani jeruja bakana mitani; ");
INSERT INTO dif_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Buka ngaianini ngaianingu karari jinkiamai; ");
INSERT INTO dif_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Madlentji ngaianini woramai, worderu bakana ngaiani kana nguruja madlentji worala wapaia; ");
INSERT INTO dif_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ja wata ngaianina wontjanilani wirilkamai, a‐ai, ngaianina madlentjani kulkamai; Ngangau jinkangu milila nganai ja ngurula ja pirnala ngurali. Amen.“ ");
INSERT INTO dif_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ngangau jura kanaia madlentji woranani, Ngaperali juranali pariwilpani madlentji jurani bakana woranani. ");
INSERT INTO dif_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Jura kanaia madlentji wata woranani, Ngaperali juranali pariwilpani madlentji jurani bakana wata woranani. ");
INSERT INTO dif_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jura milja ngamanani, jura wata kana jeljujelju jeribaka mujarinanto; ngangau tana mudla marki ngankateriai kanani, tana miljangamanietja wondraterinanto. Morlalu ngani jurangu jatai: „Tanali kalala tanani matja ngamalkai.“ ");
INSERT INTO dif_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Jidni milja ngamanani, jidni mangatandra gildieli wiribateriau, ja jidni mudla ngapali kulirkateriau, ");
INSERT INTO dif_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ngangau jidni kanani wata miljangamanietja wondraterinanto, a‐ai, windri Ngaperani jinkanani, Nauja kurukuruni nganai; ja Ngaperali jinkanali kurukuruni najiai, ja Nulia jinkangu kalala jinkila nganai tinkari. ");
INSERT INTO dif_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Wata poto kampanimai mitani, tanana kakatjieli ja karumurujeli tidatida ngankai, ja kurikantjieli bakujai wontiterina, ja kurieli maniai. ");
INSERT INTO dif_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Poto kampanimai pariwilpani, tanana kakatjieli ja karumurujeli wata tidatida ngankai, ja kurikantjieli bulu bakujai ja wata kurieli maniai. ");
INSERT INTO dif_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ngangau woderi ngantjani poto jurani parai, naka bakana jura ngara nganai. ");
INSERT INTO dif_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Palkuja praitji milki nganai. Jidni milki manju ngananani, jidni palku buru pratjana praitji ngananani. ");
INSERT INTO dif_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Jidni milki madlentji ngananani, jidni palku buru pratjana ngalpuru ngananani. Praitji jinkangu ngalpuru ngananani, worderu pirna ngalpuru munta? ");
INSERT INTO dif_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Kana kulno ngandandariai kapara mandruni mili ngamala, nau kulnuni kalakalarila nganai, ja kulno nulu ngantjala nganai kara; kulnuni nau wodatarana ngamala nganai, ja kulnuni gilbarila nganai kara. Jura ngandandariai Godani ja Mammonani mili ngamala. ");
INSERT INTO dif_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ngangau ngani jurangu jatai: „Wata manujeli ngundranau tepini juranani, mina jura tajila ja tapala nganai; bakana wata palkuni juranani, mina jura widmaterila nganai. Wata tepi morla pirna nganai bukani ja palku katini?“ ");
INSERT INTO dif_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Paia najianau ngaranani, tanalia wata jaupai ja kampai ja wata mapai kampani pungani, ja Ngaperali juranali pariwilpani tanangu buka jinkiai. Wata jura morla pirna nganai tanangu? ");
INSERT INTO dif_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Worana jurangundru ngurunguru nganai, tepini nunkanani tintipidi kulno juri ngankala manujeli ngundraterinali? ");
INSERT INTO dif_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ja minandru jura manujeli ngundrai katini? Ngunandula najianau maruni, worderu tanaia punkai; tanalia wata ngankai ja wata turpai. ");
INSERT INTO dif_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ngani jurangu jatai: „Bakana Salomo pirnalani nunkanani pratjanani wata widmaterina wonti tanangundru kulnuni jeribaka.“ ");
INSERT INTO dif_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Godali kanta maruni jeruja widmanani, nauja karari nganai, ja tankubana tanali ninaia turupirini worai; Nulia jenia jurangu wata ngankananto, jura wuldrungundranietja worajai? ");
INSERT INTO dif_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ngangau wata manujeli ngundraterianau ja jatanau: „Mina ngaiani tajila nganai kara? Mina ngaiani tapala nganai kara? Mina ngaiani widmaterila nganai kara?“ ");
INSERT INTO dif_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Jenia pratjana kana kojeli wontiai; ngangau Ngaperali juranali pariwilpani ngujamai, jura jenia pratjana ngamalkananto. ");
INSERT INTO dif_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ngopera wontianau Godaia milila ja talkula nunkani, ja jenia pratjana Nulia jurangu ngokala nganai. ");
INSERT INTO dif_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ngangau wata manujeli ngundranau tankubanaia; ngangau tankubana ditji munta manujeli ngundraterila nganai. Matja nganai, ditji pilki nauja pilkildra nunkani manujeli ngundraterinanto.");
INSERT INTO dif_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","„Wata kalala kuranau, jeruja jura wata kalala manila nganai. ");
INSERT INTO dif_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ngangau mina kalala jura kurai, jenipara kalala jura manila nganai; ja mina kokujeli jura nguja jinkiai, jenia koko jura nakaldra manina tikala nganai. ");
INSERT INTO dif_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Minandru jundru pita tiwitiwi ngatatani jinkanani milkini najiai, ja pita wondra milkini jinkanani jundru wata ngujamai? ");
INSERT INTO dif_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Worderu jidni ngatatani jinkanani jatananto kara: «Dabiau, ngato pita tiwitiwi milkindru jinkanani giltarananto;» ja mai, pita wondra milkini jinkanani parai? ");
INSERT INTO dif_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Jidni kana jeljujelju, ngopera pita wondra jinkani milkindru giltaramai, ja ngadani jundru ngumu najinanto, pita tiwitiwi ngatatani jinkanani milkindru giltarala. ");
INSERT INTO dif_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Kulikiri wata kintalani jinkianau ja marda ngumu wata pikini worana pararanau, tanali tanana tidnali nankaiati ja jurana purana karitjiati. ");
INSERT INTO dif_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ngatjianimai, ja Nulia jurangu jinkila nganai; wontianimai, ja jura mankamankala nganai; nandranandranimai, ja mana jurangu wilpa pantjila nganai. ");
INSERT INTO dif_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ngangau worana ngatjiai, nulu manila nganai; ja warle wontiai, nulu mankamankala nganai; ja warle nandranandrai, nunkangu mana wilpa pantjila nganai. ");
INSERT INTO dif_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Worana kana jurangundru nganai, nunkangu ngatamura nunkani ngatjiai bukaia, nulu nunkangu marda jinkila nganai? ");
INSERT INTO dif_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ja nau nunkangu ngatjiai paruja, nulu nunkangu tjutju jinkila nganai? ");
INSERT INTO dif_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ja jura, madlentji ngananani, ngujamai kupani juranani poto ngumu jinkila; worderu morla Ngaperali juranali pariwilpani poto ngumu jinkila nganai tanangu, tana nunkangu ngatjinani? ");
INSERT INTO dif_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Pratjana, mina jura ngantjai, kanali jurangu ngankananto, jenia bakana tanangu ngankanau; naupini jirijiribani jaura ja Prophetaia nganai. ");
INSERT INTO dif_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Manani wuldruni wirianau; ngangau mana maru nganai ja palto maru, nauja turuja wapai, ja marapu nunkangupini palkai. ");
INSERT INTO dif_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ngangau mana wuldru nganai ja palto wuldru, nauja tepini wiriai, ja ngalje nganai, tanali ninapini mankamankai. ");
INSERT INTO dif_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Jedikantji Prophetandru ngamalkaterianau; tjipi katieli tana jurangu wokarai, ja mandrani tana pandipandi puranietja nganai. ");
INSERT INTO dif_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Tanani tandrani jura tanana ngujamananto. Kanali bakana waina tandra kampala nganai dilkandru ja manawara dieltjirundru? ");
INSERT INTO dif_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","A‐ai, pita nindri ngumu pratjanali tandra ngumu punkibai, ja pita nindri madlentjali tandra madlentji punkibai. ");
INSERT INTO dif_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Pita nindri ngumu ngandandariai tandra madlentji punkibala, ja pita nindri madlentji ngandandariai tandra ngumu punkibala. ");
INSERT INTO dif_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Pita nindri pratjanali wata tandra ngumu punkibanani, tanali wokaribala nganai ja turuni worala nganai. ");
INSERT INTO dif_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ngangau tanani tandrani jura tanana ngujamananto. ");
INSERT INTO dif_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Wata tana pratjana, tana ngakangu jatai: «Kaparajai! Kaparajai!» pariwilpaia mililani wirila nganai, a‐ai, windri naupini, nulu Ngaperaia ngakanaia pariwilpalaia jertapaterina ngankai. ");
INSERT INTO dif_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Marapu ngakangu jatala nganai nunkanguka ditjini: «Kaparajai! Kaparajai! wata ngaiani talani jinkanani talpadakana wonti? Wata ngaiani talani jinkanani kutji dunkalkana wonti? Wata ngaiani talani jinkanani pirnala marapu ngankana wonti?» ");
INSERT INTO dif_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Jendranguta ngato tanangu kalabala nganai: «Wata ngato jurana ngujamana wonti; ngakangundru wapanimai; jura tjikatjika ngankanietja.» ");
INSERT INTO dif_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Warle tananapini jaura ngakani ngarai ja ngankai, nina ngato kana kiri jeribaka kurala nganai, nulu punga nunkani marda tulurani wotinala. ");
INSERT INTO dif_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ja talara kunditji godana wonti, ja ngapa kumari wokarana wonti, ja watara ngakana wonti ja ninapini punga tertapana wonti, ja bulu tampuribana wonti; ngangau nina marda tulurana wotinala. ");
INSERT INTO dif_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ja warle tananapini jaura ngakani ngarai ja wata ngankai, nau kana patipati jeribaka nganai, nulu punga nunkani mita ngalarani wotinala; ");
INSERT INTO dif_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ja talara kunditji godana wonti, ja ngapa kumari wokarana wonti, ja watara ngakana wonti, ja ninapini punga tertapana wonti, ja nau tampurina wonti, ja tampurini nunkani pirna nganana wonti.“ ");
INSERT INTO dif_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jendranguta Jesujeli tananapini jaura matja mudana, kana wolara ngujangujarani nunkanani pirna ngaruparana wonti. ");
INSERT INTO dif_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ngangau Nulu ngurungurujeli ngujangujara jinkina wonti, ja wata jaura jinkinietjali jeribaka. ");
INSERT INTO dif_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Nau mardawonpandru ngarina tikanani, jendranguta kana wolara marapu nunkangu karipaterina wonti. ");
INSERT INTO dif_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ja mai, kana kulno gambanto wokarana wonti ja nunkangu pantjaterkana ngarina wonti ja jatana wonti: „Kaparajai, jidni jertapaterinani, jidni ngurunguru nganai ngana kulikiri ngankala.“ ");
INSERT INTO dif_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ja Jesus mara warpina wonti, ja Nulu nina karakarana wonti ja jatana wonti: „Ngani jertapateriai, kulikiri nganamai.“ Ja nurujeli nau kulikiri pantjina wonti nunkani gambandru. ");
INSERT INTO dif_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ja Jesus jatana wonti nunkangu: „Mai, wata jundru jenia kanani kaukaubamai, a‐ai, wapau, Priestani wondrateriamai, ja nina poto jinkiau, nina Mosili jirijiribana wonti, tanangu malka nganananto.“ ");
INSERT INTO dif_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ja Jesus Kapernaum ngurani matja wirina, juljaia kapara kulno nunkangu wokarana wonti ja nunkangu ngatjina wonti, ");
INSERT INTO dif_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ja jatana wonti: „Kaparajai, mili ngakani pungani parai tjunduru, ja pirna ketjaketjai.“ ");
INSERT INTO dif_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ja Jesus nunkangu jatana wonti: „Ngani wokarala nganai, nina tepi ngankala.“ ");
INSERT INTO dif_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ja juljaia kaparali kalabana wonti ja jatana wonti: „Kaparajai, ngani wata talku nganai, jidni punga ngalpani ngakanani wirinanto; windri jaura kulno jatamai, ja mili ngakani tepirila nganai. ");
INSERT INTO dif_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ngangau ngani kana nganai ja kaparani wodatarana ngamai; ja ngato mili wolara ngamalkai; ja ngani nunkangupini jatanani: «Jerra wapau!» ja nau wapai; ja kulnuni: «Kaparau!» ja nau wokarai; ja milini ngakanani: «Ninapini ngankau!» ja nulu jenia ngankai.“ ");
INSERT INTO dif_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesujeli jenia matja ngarana, Nau ngaruparana wonti ja jatana wonti tanangu nunkangu karipaterinani: „Morlalu ngani jurangu jatai: Jenipara morlalu ngundrana ngato Israelani wata mankamankana warai.“ ");
INSERT INTO dif_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ja ngani jurangu jatai: „Marapu wokarala nganai tiriwandru ja jendakarandru ja Abrahamangu ja Isaakangu ja Jakobangu jela pariwipaia mililani ngamala nganai. ");
INSERT INTO dif_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ja Nulu mililaia kupa teribala nganai ngalpuru pirnaia, naka tana pirna ngirikidala nganai ja mana katakatangala nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ja Jesus jatana wonti juljaia kaparani: „Tikamai; worderu jundru morlalu ngundrana warai, jeruja jinkangu nganaiatimai.“ Ja mili nunkani tepirina wonti nunkangupini ditjini. ");
INSERT INTO dif_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ja Jesus Petruni pungani wirina wonti, ja Nulu paiara nunkani najina wonti, nani paranani muntja turuturu. ");
INSERT INTO dif_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ja Nulu nana mara patana wonti, ja muntja turuturujeli nana worarana wonti; ja nani jiritjina wonti ja tanangu mili nganana wonti. ");
INSERT INTO dif_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Matja kalkaurarina, tanali nunkangu kana kutjinto marapu wokaralkana wonti, ja Nulu jaurali kutji worana dunkalkana wonti, ja Nulu muntja pratjana tepi ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ngangau morlalu pantjinanto, mina Jesaiasali Prophetali kaukaubana wonti, nau jatana wonti: „Muntali Nulu waltowalto ngaianani manina wonti, ja muntja ngaianani waltana wonti.“ ");
INSERT INTO dif_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ja Jesujeli matja najina, kana wolarali nina kapikapinani, Nulu jirijiribana wonti jerankaria pararala. ");
INSERT INTO dif_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ja jaura jinkinietja kulno nunkangu wokarana wonti ja jatana wonti: „Ngujangujara jinkinietjajai, ngani jinkangu karipaterila nganai, wodajeri jidni wapanani.“ ");
INSERT INTO dif_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ja Jesus nunkangu jatana wonti: „Kintala jampali minka ngamalkai, ja paiali ngaranani kunjila ngamalkai, ja Kanaia Ngatamurajeli piri pani ngamalkai, wodajeri kukadi terkala.“ ");
INSERT INTO dif_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nunkani milindru kulno nunkangu jatana wonti: „Kaparajai, ngakangu manuni kurau, ngani ngopera wapananto, ngaperi ngakani todila.“ ");
INSERT INTO dif_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesus nunkangu jatana wonti: „Ngakangu karipateriau, ja narieli muntali nari tanani todinanto.“ ");
INSERT INTO dif_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ja Nau botani wirina wonti, ja mili nunkani nunkangu karipaterina wonti. ");
INSERT INTO dif_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ja mai, watara pirna wilparina wonti pantuni, jeruja mandikilali bota walpana wonti; ja Nau mukaturarana wonti. ");
INSERT INTO dif_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ja mili nunkangu wokarana wonti, ja tanali nina jiritjibana wonti ja jatana wonti: „Kaparajai, ngaianina kul‐kau, ngaiani palipaliati!“ ");
INSERT INTO dif_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ja Nau tanangu jatana wonti: „Minandru jura japali nganai, juru wuldrungundranietja?“ Ngadani Nau terkakana wonti ja watarani ja pantuni dikidikibana wonti, ja dalpura pirna pantjina wonti. ");
INSERT INTO dif_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ja kana ngaruparana wonti ja jatana wonti: „Mina kana Nauja nganai; ngangau watara ja panto nunkangu pankiji?“ ");
INSERT INTO dif_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ja Nau jerankari matja pararana Gergesena mitani, nunkangu kana mandru kutjinto dankamalina wonti; pudla narikutundru matja dunkana, tiri pirna, jeruja kana ngandandarina wonti nunkangupini paltuni palkingala. ");
INSERT INTO dif_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ja mai, pudla maritjina wonti ja jatana wonti: „Mina ngaianingu ja jinkangu, Jesujai, Godaia Ngatamurajai? Jidni ninkida wokarana warai, ngaianingu jupala ditji talkuja woljaia?“ ");
INSERT INTO dif_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Tanangu worita piki ngami pirna marakana wonti. ");
INSERT INTO dif_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Kutji wora nunkangu ngatjina wonti ja jatana wonti: „Jundru ngaianina dunkalkanani, ngaianingu manuni kurau piki ngamini wirinanto.“ ");
INSERT INTO dif_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ja Nau tanangu jatana wonti: „Wapanau!“ tana matja dunkana, tana pikini wirina wonti; ja mai, piki ngami mardawonpa kalikalini kalikalibakana wonti pantuni, ja ngapani palipalina wonti. ");
INSERT INTO dif_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ja ngamalkanietja japa mindrina wonti ja wapana wonti nguraia, ja pratjana kaukaubana wonti, bakana jenia kutjilandru. ");
INSERT INTO dif_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ja mai, ngura warupotula dunkana wonti Jesungu mandurila; ja tanali nina matja najina, tana nunkangu ngatjina wonti, Nau tanani wondirandru puntinanto. ");
INSERT INTO dif_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ja Nau botani wirina wonti ja pararana wonti, ja ngurani nunkanani wokarana wonti. ");
INSERT INTO dif_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ja mai, tanali tjunduru kulno nunkangu wokaralkana wonti, nau turarani pirini paranani. Ja Jesujeli morlalu ngun‐drana tanani matja najina, Nulu tjundurani jatana wonti: „Murlali nganamai, ngatamurajai, madlentji jinkani matja worana warai!“ ");
INSERT INTO dif_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ja mai, jaura jinkinietja palpali warawarapana wonti: „Nulupini Goda ngirkibai.“ ");
INSERT INTO dif_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesujeli ngundrana tanani matja ngujamana, Nau jatana wonti: „Minandru jura jenia madlentji ngundrai ngarali juranali? ");
INSERT INTO dif_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Mina morla ngaua nganai jatala kara: «Madlentji jinkani matja worana;» jatala kara: «Terkakamai ja wirariau?» ");
INSERT INTO dif_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ja jura ngujamananto, Kanaia Ngatamurajeli ngurula ngamalkai, mitani madlentji worala,“ — Nau tjundurani jatana wonti: „Terkakamai, turarani piri jinkani patau, ja pungaia jinkanaia tikamai.“ ");
INSERT INTO dif_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ja nau terkakana wonti ja pungaia nunkanaia tikana wonti. ");
INSERT INTO dif_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kana wolarali jenia matja najina, tana ngaruparana wonti ja Goda jurakokana wonti, ngangau Nulia jenia ngurula kanani jinkina warai. ");
INSERT INTO dif_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ja Jesus nakandru wapana wonti, ja Nulu kana kulno najina wonti mardatandrakampanietjaia pungani ngamanani, tala nunkani Matthäus; ja Nau nunkangu jatana wonti: „Ngakangu karipateriau!“ Ja nau terkakana wonti ja nunkangu karipaterina wonti. ");
INSERT INTO dif_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ja jendranguta Nau pungani bukani ngamana wonti; ja mai, mardatandrakampanietja ja madlentji ngankanietja marapu wokarana wonti ja Jesungu ja milini nunkanani jela bukaia ngamana ngarina wonti. ");
INSERT INTO dif_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ja jenia Pharisaiali matja najina, tana milini nunkanani jatana wonti: „Minandru ngujangujara jinkinietjali juranali mardatandrakampanietjani ja madlentji ngankanietjani jelali tajiai?“ ");
INSERT INTO dif_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesujeli jenia matja ngarana, Nau tanangu jatana wonti: „Ngurungurujeli wata kunki ngundrai, a‐ai, windri muntjali. ");
INSERT INTO dif_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Wapanau ja kiririanau, mina jenia wondrai: «Ngato kalumiltjamiltjarina ngantjai ja wata poto ngumu;» ngangau ngani wata wokarana warai kana talku karkala, a‐ai, windri kana madlentji.“ ");
INSERT INTO dif_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Jendranguta Johannini mili nunkangu wokarana wonti ja jatana wonti: „Minandru ngaiani ja Pharisaia pota marapu milja ngamai, ja mili jinkani wata milja ngamai?“ ");
INSERT INTO dif_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ja Jesus tanangu jatana wonti: „Worderu noangantjanipirnaia kamaneli ngaurongauro ngamananto, noangantjanipirna tanangu jela ngananani? Ditji wokarala nganai, tanali noangantjanipirna tanangundru manila nganai; ngadani tanaia milja ngamala nganai. ");
INSERT INTO dif_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Wata kulnujeli katini womalani kati tjela ngumu karpai; ngangau kati tjela nakaldra katindru purateriai, ja wilpa morla pirna pantjiai. ");
INSERT INTO dif_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ja tanali wata waina marra jungani womalani kurarai; junga purateriati, ja waina ngakaiati, ja junga tintateriati; a‐ai, tanali waina marra junga marrani kurarai ja pudlana jelalu kulkai.“ ");
INSERT INTO dif_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Nulu jenia tanangu kaukaubanani, mai, kapara kulno wokarana wonti ja nunkangu pantjaterkana ngarina wonti ja jatana wonti: „Ngatamura mankara ngakani karari matja palina, kaparau, jidni mara nankangu kurateriamai, ja nani tepirila nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ja Jesus terkakana wonti ja nunkangu karipaterina wonti, ja mili nunkani bakana. ");
INSERT INTO dif_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ja mai, widla kulno, nani kilpawoldra marapratjana ja mandru kumaranto nganana wonti, nunkangu tokuni wokarana wonti ja kati jelpi nunkani karana wonti. ");
INSERT INTO dif_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ngangau nani jataterina wonti: „Ngato windri kati nunkani karanani, ngani tepirinani.“ ");
INSERT INTO dif_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesujeli najina karitjina wonti ja nana najina wonti ja jatana wonti: „Murlali nganamai, ngatamurajai! morlalu ngundranali jinkanali jidna tepi ngankana warai.“ Ja widla tepirina wonti nunkangupini ditjini. ");
INSERT INTO dif_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ja Jesus kaparaia pungani matja wokarana, Nulu wimakoko wilpinietja najina wonti, ja kanali miritja ngankanani, ja Nau tanangu jatana wonti: ");
INSERT INTO dif_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","„Piri pinianimai; ngangau mankara wata nari, a‐ai, windri mukaturarai.“ Ja tana kinkana wonti nunkangu. ");
INSERT INTO dif_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ja Nulu kana wolara matja narrana, Nau wirina wonti ja nana mankara mara patana wonti, ja mankara jiritjina wonti. ");
INSERT INTO dif_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ja naupini pinti marurina wonti nunkangupini mitani paruparu. ");
INSERT INTO dif_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ja Jesus nakandru morla palkana wonti, ja nunkangu butju mandru karipaterina wonti, pudla maritjina wonti, ja jatana wonti: „Davidani ngatamurajai, ngalingu kalumiltjamiltjariau!“ ");
INSERT INTO dif_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Nau pungani wirinani, butju wulu nunkangu wokarana wonti, ja Jesus pudlangu jatana wonti: „Judla morlalu ngundrai, ngani ngurunguru nganai, jenia ngankala“? Pudla nunkangu jatana wonti: „Kau, Kaparajai!“ ");
INSERT INTO dif_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ngadani Nulu pudlana milki karakarana wonti ja jatana wonti: „Worderu judla morlalu ngundrana warai, jeruja jud‐langu pantjiatimai.“ ");
INSERT INTO dif_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ja pudla milki piririna wonti. Ja Jesujeli pudlana daudauana wonti ja jatana wonti: „Ngamalkaterialumai, wata kanali jenia ngujamananto.“ ");
INSERT INTO dif_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pudla dunkana wonti ja nunkangundru kaukaubana wonti nunkangupini mitani paruparu. ");
INSERT INTO dif_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Pudla puntinani, mai, tanali nunkangu kana ngapu kutjinto wokaralkana wonti. ");
INSERT INTO dif_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ja Nulu kutji matja dunkalkana warai, kana ngapula jatana wonti. Ja kana wolara ngaruparana wonti ja jatana wonti: „Wata pota kulno jenia Israelani pantjinala.“ ");
INSERT INTO dif_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pharisaia jatana wonti: „Nulia kutji dunkalkai kutjia kaparali.“ ");
INSERT INTO dif_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ja Jesus wirarina wonti ngura pirnani ja wakani pratjanani, ja ngujangujara jinkina wonti jaura pungani tananani, ja ngantjani jaura mililandru kaukaubana wonti, ja tepi ngankana wonti muntja pratjana ja waltowalto pratjana kana wolarandru. ");
INSERT INTO dif_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nulu kana wolara najina, Nau tanangu kalumiltjamiltjarina wonti, ngangau tana wilpawilpa ja piltjaru nganana wonti, tjipi jeribaka, tana ngamalkanietja pani. ");
INSERT INTO dif_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Jendranguta Nau milini nunkanani jatana wonti: „Kampananto marapu parai, ja ngankanietja windri ngalje.“ ");
INSERT INTO dif_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Jendrania Kampania Kaparani ngatjianimai, Nulia ngankanietja jinpananto nunkani kampanaia. ");
INSERT INTO dif_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ja Nulu mili nunkani marapratjana ja mandru matja karkana, Nulu tanangu ngurula jinkina wonti kutji murumuruja, tanana dunkalkananto ja tepi ngankananto muntja pratjana ja waltowalto pratjana. ");
INSERT INTO dif_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Mili marapratjana ja mandruja tala tanapini nganai: „Ngopera Simon, nina tanali dikai «Petrus» ja Andreas, ngatata nunkani; Jakobus, Zebedäuni ngatamura, ja Johannes, ngatata nunkani; ");
INSERT INTO dif_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Philippus ja Bartholomäus; Thomas ja Matthäus mardatandrakampanietja; Jakobus Alphäuni ngatamura, ja Leppäus, nina tanali dikai «Thaddäus»; ");
INSERT INTO dif_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon, Kana ngurandru ja Judas Iskarioth, nulu nina wondawondana wonti.“ ");
INSERT INTO dif_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Tananapini marapratjana ja mandru Jesujeli jinpana wonti, ja Nulu tanangu jirijiribana wonti ja jatana wonti: „Kana koja paltuni jura wata wapananto, ja Samarita ngurani jura wata wirinanto; ");
INSERT INTO dif_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","A‐ai, windri tjipia wapanau, tana Israel pungandru tintaterinala. ");
INSERT INTO dif_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Wapanau ja kaukaubanimai, ja jatanimai: «Pariwilpaia milila karakara nganai.» ");
INSERT INTO dif_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Muntja tepi ngankanimai, kana gambanto kulikiri ngankanimai, kana nari jiritjibanimai, kutji dunkalkanimai; bakujeli jura matja manina, bakujeli jinkianimai. ");
INSERT INTO dif_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Jura wata mardatandra maralje, bakana wata mardatandra bulu, bakana wata mardatandra nguja pilki pailtjini juranani ngamalkananto; ");
INSERT INTO dif_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Wata billi paltuja, bakana wata kati mandru, bakana wata tidnaputa, bakana wata wonapita; ngangau ngankanietjani talku nganai buka nunkani. ");
INSERT INTO dif_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Mina ngura pirnani kara, ngura wakani kara jura matja wirina, wolja jakalkanau, worana nunkangu talku nganai; naka ngamanimai, jura puntilalu. ");
INSERT INTO dif_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Jura pungani wirinani, nunkangu jaura murlali jinkianimai. ");
INSERT INTO dif_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Punga kara talku ngananani, murla jurani nunkangupini wokarananto, nau wata talku kara ngananani, murla jurani jurangu karitjina tikananto. ");
INSERT INTO dif_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ja warle jurana wata patanani, bakana jaura jurani wata ngaranani, nunkangupini pungandru kara ngurandru kara puntianimai, ja puturu jurani tidnandru kantikantianimai. ");
INSERT INTO dif_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Morlalu ngani jurangu jatai: «Sodoma ja Gomorra mitalali kalala morla waka manila nganai kalala ditjini nunkangupini ngurani.» ");
INSERT INTO dif_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Mai, ngato jurana jinpai tjipi jeribaka pandipandi mandrani; kiri ngananau tjutju jeribaka ja jedini pani mulapara jeribaka. ");
INSERT INTO dif_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ngamalkaterianau kanandru; ngangau tanali jurana kapara worangu ngulkujeli jinkila nganai ja jaura pungani tananani jurana wiriele nandrala nganai. ");
INSERT INTO dif_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Bakana najinajibanietjani ja mitaia kaparani tanali jurana wapalkala nganai ngakangundru, tanangu ja kana koni malka morlalu nganananto. ");
INSERT INTO dif_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Tanali jurana ngulkujeli jinkinani, wata manujeli ngundranau, worderu kara, mina kara jura jatananto; ngangau Nulia jurangu nunkangupini ditjini jinkila nganai, mina jura jatananto. ");
INSERT INTO dif_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ngangau wata jura jatai, a‐ai, jurani Ngaperaia Jaola jatai jurangu. ");
INSERT INTO dif_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Nejieli ngatata nunkani naria ngulkujeli jinkila nganai, ja ngaperali kupa nunkani; ja kupa terkakala nganai ngaperani ja ngandrini ja pudlana naria jinkila nganai. ");
INSERT INTO dif_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ja kana warupoto jurangu kalakalarila nganai ngakani talandru. Worana wonki nganai ngadajelu, nulu tepi ngurali manila nganai. ");
INSERT INTO dif_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Tana jurangu tirikaripaterinani ngura kulnuni ngura nguruja mindrianau. Ngangau morlalu ngani jurangu jatai: «Jura Israelaia ngura pratjana wata mudala nganai Kanaia Ngatamura wokaranantulu.» ");
INSERT INTO dif_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Mili wata morla pirna nganai ngujangujara jinkinietjani, bakana ngankanietja wata morla pirna kaparani nunkanani. ");
INSERT INTO dif_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Milini matja nganai, nau ngujangujara jinkinietjani nunkanani jeribaka pantjinani, ja ngankanietjani kaparani nunkanani jeribaka. Tanali punga ngamalkanietja Beelsebub matja dikana, worderu morla pungaia ngurula nunkani? ");
INSERT INTO dif_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Wata tanangundru japali ngananau! Ngangau panila kurirpi nganai, nau wata tinkari pantjila nganai; ja panila kurukuru nganai, nina tanali wata ngujamala nganai. ");
INSERT INTO dif_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Mina ngani jurangu jatai ngalpurani, jenia kaukaubanimai praitjani; ja mina jura kurukuru ngarai talpali, jenia kaukaubanimai punga mangatandrani. ");
INSERT INTO dif_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Wata japali ngananau tanangundru, tanali palku nari ngankai, ja ngandandariai mungara nari ngankala; morla japali ngananau nunkangundru, Nauja ngurunguru nganai, palku ja mungara turuja teribala. ");
INSERT INTO dif_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Tanali wata tiwilitja mandru mardatandra wakawaka kulnundru jinkimaliai? Ja wata kulno tanangundru mitani purila nganai jurani Ngaperani panini. ");
INSERT INTO dif_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Bakana para pratjana jurani mangatandrani matja windamana. ");
INSERT INTO dif_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Wata japali ngananau; jura morla pirna nganai tiwilitja marapuni. ");
INSERT INTO dif_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Warle ngana dikala nganai kanani, nina bakana ngato dikala nganai Ngaperani ngakanani pariwilpani. ");
INSERT INTO dif_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Warle ngana kutikutibala nganai kanani, nina bakana ngato kutikutibala nganai Ngaperani ngakanani pariwilpani. ");
INSERT INTO dif_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Wata ngundranau, ngani wokarana warai, murla kurala mitani; a‐ai, ngani wata wokarana warai murla kurala, windri kalti tiri. ");
INSERT INTO dif_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ngangau ngani wokarana warai, puntibala materi ja ngaperi nunkani, mankara ja ngandri nankani, kalari ja paiara nankani; ");
INSERT INTO dif_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ja pungaia ngurala kanaia talpala nganala nganai. ");
INSERT INTO dif_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Warle ngaperi kara, ngandri kara morla ngantjai ngakangu, nau ngakangu wata talku nganai; ja warle kaku kara, mankara kara morla ngantjai ngakangu, nau ngakangu wata talku nganai. ");
INSERT INTO dif_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ja warle kunarku nunkani wata maniai ja ngakangu karipateriai, nau ngakangu wata talku nganai. ");
INSERT INTO dif_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Warle tepi nunkani mankamankana warai, nulu nina tintala nganai, ja warle tepi nunkani tintana warai ngakangundru, nulu nina mankamankala nganai. ");
INSERT INTO dif_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Warle jurana patai, nulu ngana patai; ja warle ngana patai, nulu ninaia patai, Nulia ngana jinpanala. ");
INSERT INTO dif_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Warle Propheta kulno patai Prophetaia talani, nulu Prophetaia kalala manila nganai; ja warle kana talku patai kana talkuja talani, nulu kana talkuja kalala manila nganai. ");
INSERT INTO dif_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ja warle kulnuni tanangupini wakawakandru koko kulno ngapa malti jinkila nganai milia talani, morlalu ngani jurangu jatai: «Nulu kalala nunkani wata tintala nganai.»“ ");
INSERT INTO dif_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ja Jesujeli jendranguta matja mudana, milini nunkanani ngujangujara jinkila, Nau nakandru puntina wonti, ngujangujara jinkila ja jaura kaukaubala ngurani tananani. ");
INSERT INTO dif_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Johannili kanjangari pungani Christuni ngankana matja ngarana, nulu mili mandru nunkani jinpana wonti, ");
INSERT INTO dif_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ja nunkangu jatana wonti: „Naumata jidni, Nau wokarananto kara, kulnuni ngaiani kalkananto kara?“ ");
INSERT INTO dif_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesujeli kalabana wonti ja jatana wonti pudlangu: „Tikalumai, ja Johanningu kaukaubalumai, mina judla najila wapaia ja ngarala wapaia: ");
INSERT INTO dif_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Butjulali najiai, ja tjundurula wapai; gambala kulikiri pantjiai, ja talpakurulali ngarai; narila tepi terkakai, ja wangiwangieli ngantjani jaura ngarai; ");
INSERT INTO dif_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ja murlali pirna naupini nganai, nau ngakangu wata buljubuljuriai.“ ");
INSERT INTO dif_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Pudla tikanani, Jesujeli wonina wonti kana wolarani jatala Johanningundru: „Mina najila jura pitaraia palkana paraia? Kalanka kulno, watarali wijawijabanani? ");
INSERT INTO dif_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Mina najila jura palkana paraia? Kana kulno kati tjankanto? Mai, mitaia kaparaia pungani tanali ngamalkai kati tjanka. ");
INSERT INTO dif_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Mina najila jura palkana paraia? Propheta kulno? Morlalu ngani jurangu jatai: Nau morla pirna nganai Prophetani. ");
INSERT INTO dif_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ngangau naupini nau nganai, nunkangundru dakanala parai: «Mai, ngato angela ngakani jinkangu mudlani ngopera jinpai, nulu palto jinkani jinkangu ngopera ngankingala nganai.» ");
INSERT INTO dif_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Morlalu ngani jurangu jatai: «Wata kulno tanangundru, widlandru dankanala, terkakana wonti morla pirna Johanningu multibanietjani. Worananau morla waka nganai pariwilpaia mililani, nau morla pirna nganai nunkangu.» ");
INSERT INTO dif_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Johannes multibanietjaia ditjindru kararielu pariwilpaia milila ngurulali wokarai, ja kana ngurungurujeli ninaia parumai. ");
INSERT INTO dif_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ngangau Propheta worali ja jirijiribani jaurali Johanningulu talpadakana wonti; ");
INSERT INTO dif_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ja jura ngantjanani jenia patala, naupini Elias nganai, nau wokarananto. ");
INSERT INTO dif_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Warle talpa ngamalkai ngarala, nulu ngaraiatimai! ");
INSERT INTO dif_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Worangu ngato ninapini nguja jeribaka kurananto? Tanaia kupa wakani jeribaka nganai, tana jinkimalini pirini ngamai ja kamaneli tanani karkai ");
INSERT INTO dif_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Ja jatai: «Ngaiani jurangu wilpina warai, ja jura wata kilina warai; ngaiani jindrana warai, ja jura wata ngaurongaurojeli nandraterina warai.» ");
INSERT INTO dif_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ngangau Johannes wokarana warai wata tajina ja wata tapana, ja tanaia jatai: «Nulu kutji ngamalkai;» ");
INSERT INTO dif_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ja Kanaia Ngatamura wokarana warai, Nulia tajiai ja tapai, ja tanaia jatai: «Najianau, Nauja kana mirantjatieli tajinietja ja tapanietja, mardatandrakampanietjaia ja madlentji ngankanietjaia kamaneli!» Ja Kirila kalala maniai nunkani kupandru.“ ");
INSERT INTO dif_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jendranguta Nulu wonina wonti, jaura kalkri jatala tanangupini ngurani, tanangu pirnala nunkani marapu pantjina wonti, ngangau tana wata madlentjandru karitjina wonti: ");
INSERT INTO dif_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","„Jakajai jinkangu Choraziniai! jakajai jinkangu Bethsaidajai! ngangau Tyrus ja Sidon ngurani jenia pirnala pantjinani, judlangu pantjinala, pudla nurujeli kati murumurunto ja turuputani madlentjandru karitjinanto. ");
INSERT INTO dif_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ja ngani judlangu jatai: «Tyrus ja Sidon ngurali kalala ditjini kalala morla waka manila nganai judlangu.» ");
INSERT INTO dif_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ja jidni Kapernaum, jidni miririna pariwilpaia, turujelu jidni ngarila nganai; ngangau Sodom ngurani jenia pirnala pantjinani, jinkangu pantjinala, naupini nunkangupini ditjini kararielu terkananto. ");
INSERT INTO dif_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ja ngani jurangu jatai: «Sodom mitalali kalala ditjini kalala morla waka manila nganai jinkangu.»“ ");
INSERT INTO dif_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Jendranguta Jesujeli kalabana wonti ja jatana wonti: „Ngato jidnana Ngaperiai, Kapara pariwilpaia ja mitaia, jurakokala wapaia; ngangau jundru jenia kana kirini ja ngujamanietjani kutibana warai ja kupani tinkari ngankana warai; ");
INSERT INTO dif_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Kau, Ngaperiai! jeruja jinkangu manju nganana wonti. ");
INSERT INTO dif_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ngaperali ngakanali ngakangu warupoto jinkina wonti; ja wata kulnujeli Ngatamura ngujamai, windri Ngapili; ja bakana wata kulnujeli Ngapina ngujamai, windri Ngatamurajeli ja nulu, nunkangu Ngatamurajeli ngantjai jenia tinkari ngankala. ");
INSERT INTO dif_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ngakangu kaparanau pratjana, jura wariwariai ja pariai, ngato jurana ngara waribala nganai. ");
INSERT INTO dif_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Pita wokara ngakani manianimai, ja ngakangundru kiririanau, ngangau ngani malti ja ngarali waka ngundrateriai, ja jura mankamankala nganai mungara ngara ngamala. ");
INSERT INTO dif_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ngangau pita wokara ngakani manju, ja juditji ngakani ngaua nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Jendranguta Jesus Sabbat ditjini buka maruni palkingana wonti, ja mili nunkani mauali nganana wonti ja wonina wonti, buka tandra wokaribala ja tajila. ");
INSERT INTO dif_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Pharisaiali jenia najina, tana nunkangu jatana wonti: „Mai, milieli jinkanali ngankai, jenia wata talku nganai Sabbat ditjini.“ ");
INSERT INTO dif_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Nau tanangu jatana wonti; „Jura wata warapanala, mina Davidali ngankana wonti jendranguta, nau mauali nganana wonti ja tana nunkangunto? ");
INSERT INTO dif_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Worderu nau Godaia pungani wirina wonti ja wondrani buka tajina wonti, tanana tajila nunkangu ja tanangu nunkangunto wata manuni kuranala, a‐ai, windri Priestani? ");
INSERT INTO dif_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Jura wata warapanala jirijiribani jaurani, worderu Sabbat ditjini Priestali Godaia pungani Sabbat wokaribai, ja madlentji pani nganai? ");
INSERT INTO dif_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ngani jurangu jatai: «Ninkida Kulno nganai, Nauja morla pirna nganai Godaia pungani.» ");
INSERT INTO dif_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Jura ngujamanani mina jenia wondrai: «Ngato ngantjai kalumiltjamiltjarina ja wata poto ngumu,» jura tanangu, madlentji panini, wata kalala dikanani. ");
INSERT INTO dif_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ngangau Kanaia Ngatamura bakana Sabbat ditjia Kapara nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ja Nau nakandru wapana wonti ja jaura pungani tananani wokarana wirina wonti. ");
INSERT INTO dif_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ja mai, naka kana kulno nganana wonti, nau mara muja nganana wonti. Ja tanali nina jakalkana wonti ja jatana wonti: „Jenia talku nganai, Sabbat ditjini tepi ngankala?“ Ngangau tana nunkangundru ngulkuterkananto. ");
INSERT INTO dif_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Nau tanangu jatana wonti: „Worana kana jurangundru nganai, nulia tjipi kulno ngamalkai, nau Sabbat ditjini kutuni purinani, nulia nina wata patala nganai ja dukarala nganai? ");
INSERT INTO dif_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Worderu morla pirna kana nganai tjipini? Jeruja bakana talku nganai Sabbat ditjini ngumu ngankala.“ ");
INSERT INTO dif_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ngadani Nau nunkangupini kanani jatana wonti: „Mara ngutateriau!“ ja nau ngutaterina wonti, ja mara tepi pantjina wonti nguruni jeribaka. ");
INSERT INTO dif_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Pharisaia dunkana wonti ja ngankamalina wonti, worderu nina nandrala. ");
INSERT INTO dif_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ja Jesujeli jenia matja ngujamana, Nau nakandru puntina wonti, ja kana wolara marapu nunkangu karipaterina wonti, ja Nulu tanana pratjana tepi ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ja Nulu tanana daudauana wonti, tanali nina wata tinkari ngankananto. ");
INSERT INTO dif_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ngangau morlalu pantjinanto, mina Jesaiasali Prophetali kaukaubana wonti, nau jatana wonti: ");
INSERT INTO dif_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","„Mai, Ngatamura ngakani, ninaia ngato kalkalkana wonti, ja Ngantjanipirna ngakani, worangu ngani mungara manju nganai; Ngato Jaola ngakani nunkangu kurala nganai, ja Nulia kana wolarani kalala kaukaubala nganai. ");
INSERT INTO dif_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nulia wata jatamalila nganai ja maritjila nganai, ja tanali ngaiala nunkani wata paltuni ngarala nganai. ");
INSERT INTO dif_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Wokarini kalanka Nulia wata kantji wokaribala nganai, ja praitji, ngampu palina, Nulia wata kantji palimala nganai, Nulia kalala jinkinantulu kalalu ngankanaia. ");
INSERT INTO dif_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ja kana wolarali talani nunkanani wolkareli kalkala nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Jendranguta tanali nunkangu kana kulno kutjinto wapalkana wonti, nau butju ja ngapu nganana wonti; ja Nulu nina tepi ngankana wonti, jeruja ngapula ja butjula jatana wonti ja najina wonti. ");
INSERT INTO dif_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ja kana wolara ngaruparana wonti ja jatana wonti: „Wata Naupini Davidani ngatamura nganai?“ ");
INSERT INTO dif_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pharisaiali jenia matja ngarana, tana jatana wonti: „Nulupini kutji windri Beelsebub, kutjia kaparali dunkalkai.“ ");
INSERT INTO dif_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesujeli ngundrana tanani matja ngujamana, Nau tanangu jatana wonti: „Milila pratjana, munta piltjaru ngankaterinani, pitaru jeribaka pantjila nganai, ja ngura ja punga pratjana, munta piltjaru ngankaterinani, wata terkala nganai. ");
INSERT INTO dif_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ja kutjieli kutji dunkalkanani, nau munta piltjaru ngankateriai; worderu milila nunkani terkananto? ");
INSERT INTO dif_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ja ngato Beelsebubieli kutji dunkalkanani, waninali ngatamurajeli juranali tanana dunkalkai? Jendrania tana kalala kuranietja jurani nganala nganai. ");
INSERT INTO dif_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ngato Godaia Jaolali kutji dunkalkanani, jeruja morlalu Godaia milila jurangu wokarana warai. ");
INSERT INTO dif_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Worderu kara kana kulno kana ngurunguruja pungani wirinanto poto nunkani watawatali manila, nulu wata ngopera kana ngurunguru dupudupu ngankanani? Ja ngadani nulu pungani pratjana watawatali manila nganai. ");
INSERT INTO dif_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Worana wata ngakangunto nganai, nau tula ngakani nganai; ja warle wata ngakangunto kampai, nulu piltjaru ngankai.“ ");
INSERT INTO dif_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Jendrania ngani jurangu jatai: „Madlentji ja ngirkibani jaura pratjana Godali kanani kalingala nganai; windri Jaola ngirkibana Nulia wata kalingala nganai. ");
INSERT INTO dif_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ja warle jaura madlentji jatanani Kanaia Ngatamurani, nunkangu Nulia kalingala nganai; warle jaura madlentji jatanani Jaola kulikirini, nunkangu Nulia wata kalingala nganai, wata nunkangupini mitani ja bakana wata ngadani. ");
INSERT INTO dif_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Pita nindri ngumu kuranau, ja tandra nunkani ngumu; pita nindri madlentji kuranau, ja tandra nunkani madlentji; ngangau tandrani jura pita nindri ngujamai. ");
INSERT INTO dif_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Wiparu kupa worajai! Worderu jura ngumu jatananto jura madlentji ngananani? Ngangau ngara manamirindru mana jatai. ");
INSERT INTO dif_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Kana ngumujeli ngara ngumundru ngumula dunkalkai; kana madlentjali ngara madlentjandru madlentji dunkalkai. ");
INSERT INTO dif_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ngani jurangu jatai: «Jaura baku pratjanandru, tanana kana jatala nganai, tanali kalabananto kalala ditjini. ");
INSERT INTO dif_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ngangau jinkani jaurandru Nulia jidna talku dikala nganai, ja jinkani jaurandru Nulia jinkangu kalala jinkila nganai.»“ ");
INSERT INTO dif_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Jendranguta jaura jinkinietja ja Pharisaia palpali nunkangu kalabana wonti ja jatana wonti: „Ngujangujara jinkinietjajai, ngaiani ngantjai malka jinkangundru najila.“ ");
INSERT INTO dif_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Nulu kalabana wonti ja tanangu jatana wonti: „Nguja madlentjali ja palakantjieli malka wontiai, ja tanali wata malka manila nganai, windri Prophetaia Jonani malka. ");
INSERT INTO dif_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ngangau worderu Jonas paru pirna mandrani ditji parkulu ja tinka parkulu nganana wonti, jeruja bakana Kanaia Ngatamura mita mandrani ditji parkulu ja tinka parkulu nganala nganai. ");
INSERT INTO dif_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ninive kana terkakala nganai kalala ditjini nunkangupini ngujani jela ja tanangu ngulkuterkala nganai, ngangau tana madlentjandru karitjina wonti Jonani ngujangujarandru; ja mai, ninkida morla pirna nganai Jonangu. ");
INSERT INTO dif_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Mitaia kapara widla kunankarindru terkakala nganai kalala ditjini nunkangupini ngujani jela ja tanangu ngulkuterkala nganai; ngangau nani mitaia wondirandru wokarana wonti, Salomoni kiri ngarala; ja mai, ninkida morla pirna nganai Salomongu. ");
INSERT INTO dif_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Kutji murumuru kanandru matja dunkana, nau pitarani palkingai, wontina ngara ngamala, ja wata mankamankai. ");
INSERT INTO dif_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ngadani nau jatai: «Ngani tikala nganai pungaia ngakanaia, woderindru ngani matja dunkana.» Ja nau wokarana, nulu nina mankamankai kala, ja matja darpana, ja tjirkatjirkana. ");
INSERT INTO dif_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ngadani nau palkai, ja nulu wapalkai kutji mara wora ja mandru, morla madlentji nunkangu, ja tana wiriai naka ngamala; ja ngadani naupini kana morla madlentji pantjila nganai ngoperalani. Jeruja bakana nunkangupini nguja madlentjani pantjila nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nulu kana wolarani kaukaubanani, mai, ngandri nunkani ja ngatata nunkani palarani terkana wonti ja jertapaterina wonti nunkangu ngankamalila. ");
INSERT INTO dif_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Kulno nunkangu jatana wonti: „Mai, ngandri jinkani ja ngatata jinkani palarani terkala wapaia ja jertapaterila wapaia jinkangu ngankamalila.“ ");
INSERT INTO dif_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Nulu kalabana wonti ja jatana wonti nunkangu, nau jenia jatanani: „Worana ngandri ngakani ja warletana ngatata ngakani?“ ");
INSERT INTO dif_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ja Nulu nguna warpina wonti milini nunkanani ja jatana wonti: „Najianau, ngandri ngakani ja ngatata ngakani!“ ");
INSERT INTO dif_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","„Ngangau warle Ngaperaia ngakanaia pariwilpalaia jertapaterina ngankai, naupini ngatata ngakani ja kaku ngakani ja ngandri ngakani nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nunkangupini ditjini Jesus pungandru dunkana wonti, ja Nau panto dirkalani ngamana ngarina wonti. ");
INSERT INTO dif_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ja kana wolara nunkangu jurborina wonti, ja Nau botani wirina wonti ja ngamana ngarina wonti, ja kana wolara dirkalani terkana wonti. ");
INSERT INTO dif_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ja Nulu tanangu jaura marapu kaukaubana wonti jeribaka jaurali ja jatana wonti: „Mai, jaupanietja wapana wonti jaupala. ");
INSERT INTO dif_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ja nulu jaupanani, palpa paltuni purina wonti, ja paia wokarana wonti ja nina tajina wonti. ");
INSERT INTO dif_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ja palpa marda paltirani purina wonti ja wata mita tjanka marapu ngamalkana wonti ja nurujeli punkana wonti, ngangau mita puta nganana wonti. ");
INSERT INTO dif_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ja ditji matja dunkana, nau winjarina wonti, ja ngangau kapara pani nganana wonti, nau mujarina wonti. ");
INSERT INTO dif_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ja palpa dilkani purina wonti, ja dilka punkana wonti, ja nina palimana wonti. ");
INSERT INTO dif_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ja palpa mita ngumuni purina wonti ja tandra punkibana wonti, kulnujeli tandra 100, kulnujeli tandra 60, kulnujeli tandra 30. ");
INSERT INTO dif_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Warle talpa ngamalkai ngarala, nulu ngaraiatimai!“ ");
INSERT INTO dif_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ja mili nunkani nunkangu wokarana wonti ja jatana wonti: „Minandru jidni tanangu jeribaka jaurali jatai?“ ");
INSERT INTO dif_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Nulu kalabana wonti ja jatana wonti tanangu: „Jurangu matja jinkina warai, jaura kurukuru Godaia mililandru ngujamananto, ja tanangu jenia wata jinkina warai. ");
INSERT INTO dif_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ngangau warle ngamalkai, nunkangu Nulia jinkila nganai, ja nulu morla marapu ngamalkala nganai; ja warle wata ngamalkai, nunkangundru Nulia bakana jenia manila nganai, mina nulu ngamalkai. ");
INSERT INTO dif_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Jendrangundruja ngani tanangu jeribaka jaurali jatai, ngangau tanali najina bulu najiai, ja ngarana bulu ngarai, ja wata ngujamai. ");
INSERT INTO dif_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ja tanangu morlalu pantjiai Jesaiasani talpadakani jaura, nau jatana wonti: «Talpali jura ngarala nganai ja bulu ngundrala nganai, ja milkieli jura najila nganai ja bulu najila nganai. ");
INSERT INTO dif_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ngangau tananipini kana wolaraia ngara pariai, ja tanaia talpa talpakuru, ja tanaia milki butju ngankateriai, ngangau tanalia milkieli bulu najinanto ja talpali bulu ngarananto ja ngarali bulu ngujamananto, ja wata madlentjandru karitjinanto, ngato tananaia tepi ngankananto.» ");
INSERT INTO dif_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Murlali pirna milki jurani nganai, ngangau tanalia najiai, ja talpa jurani, ngangau tanalia ngarai. ");
INSERT INTO dif_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ngangau morlalu ngani jurangu jatai: «Propheta ja kana talku marapu wolkareli nganana wonti najila, mina jura najila wapaia, ja tanali jenia wata najina wonti, ja ngarala, mina jura ngarala wapaia, ja tanali jenia wata ngarana wonti.»“ ");
INSERT INTO dif_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Jeribaka jaura jaupanietjandru ngaranau! ");
INSERT INTO dif_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","„Warle jaura mililandru ngarai ja wata ngujamai, nunkangu kutji wokarai, ja nulu jenia dukarai, mina ngarani matja jaupana; naupini nau nganai, nina paltuni jaupana warai. ");
INSERT INTO dif_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Nina marda paltirani jaupana warai, nau nganai, nulu jaura ngarai ja nurujeli murlali nina patai; ");
INSERT INTO dif_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Nau kapara pani nganai, a‐ai, nau maraltja nganai. Ketjaketjana ja tirikaripaterina wokaranani jaurandru, nau wolja kalakalarila nganai. ");
INSERT INTO dif_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Nina dilkani jaupana warai, nau nganai, nulu jaura ngarai, ja nunkanipini mitaia manujeli ngundranali ja poto pirnaia jedibanali jaura palimai, ja nulu tandra pani punkibai. ");
INSERT INTO dif_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Nina mita ngumuni jaupana warai, nau nganai, nulu jaura ngarai ja ngujamai; nulupini tandra punkibai, kulnujeli tandra 100, kulnujeli tandra 60, kulnujeli tandra 30.“ ");
INSERT INTO dif_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jeribaka jaura nguru Nulu tanangu kurana wonti ja jatana wonti: „Pariwilpaia milila kana kulno jeribaka nganai, nulu paua ngumu mitani nunkanani jaupana wonti. ");
INSERT INTO dif_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Matja kana muka turaranani, talpala nunkani wokarana wonti, ja nulu paua madlentji jaupana wonti ngumuni terti, ja kutingana wonti. ");
INSERT INTO dif_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ja nindri punkanani ja tandrarinani, bakana nindri madlentji kantjirina wonti. ");
INSERT INTO dif_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ja pungaia kaparaia mili wora wokarana wonti ja jatana wonti nunkangu: «Kaparajai! wata jundru paua ngumu mitani jinkanani jaupana paraia? Woderindru nindri madlentji?» ");
INSERT INTO dif_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Nau tanangu jatana wonti: «Talpalali jenia ngankana paraia.» Mili nunkangu jatana wonti: «Jundru ngantjai, ngaiani wapananto, nina mulkana dukarala?» ");
INSERT INTO dif_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nau jatana wonti: «Pani; buka kanta jura bakana dukaraiati, nindri madlentji dukarana. ");
INSERT INTO dif_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pudla wolja jela punkananto kampani ditjielu, ja kampani ditjini ngani kampanietjani jatala nganai: Ngopera nindri madlentji kampanau, ja kuma ngankanau, nina turujeli japila; ja buka tandra kampani pungani ngakanani mapani‐mai.»“ ");
INSERT INTO dif_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jeribaka jaura nguru Nulu tanangu kurana wonti ja jatana wonti: „Pariwilpaia milila tandra wakawaka jeribaka nganai, ninapini kana kulnujeli manina wonti ja mitani nunkanani jaupana wonti. ");
INSERT INTO dif_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Nau morla waka nganai tandra nguja marapuni; nau matja pirnarina, nau morla pirna nganai nindri nguja marapuni, ja pitariai, jeruja tjilpini nunkanani paia ngaranala wokarai, ja ngamai.“ ");
INSERT INTO dif_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jeribaka jaura nguru Nau tanangu jatana wonti: „Pariwilpaia milila pulkurutjeribani buka jeribaka nganai, nina widla kulnujeli manina wonti ja duldruwana wonti koko pirna parkulu buka turarani, nau pulkurutjeranantulu.“ ");
INSERT INTO dif_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Tananapini pratjana Jesus kana wolarani jeribaka jaurali jatana wonti, ja jeribaka jaura panini Nau wata tanangu jatana wonti. ");
INSERT INTO dif_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ngangau morlalu pantjinanto, mina Prophetali kaukaubana wonti, nau jatana wonti: „Ngani mana wilparila nganai jeribaka jaurali, ngato kaukaubala nganai, mina kurukuru nganana wonti mita pantjimanandru.“ ");
INSERT INTO dif_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ngadani Jesujeli kana wolara jinpana wonti ja pungani wokarana wonti. Ja mili nunkani nunkangu wokarana wonti ja jatana wonti: „Jeribaka jaura nindri madlentjandru mitani ngaianingu mildiri ngankamai.“ ");
INSERT INTO dif_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nulu tanangu kalabana wonti: „Nulu paua ngumu jaupai, Nau Kanaia Ngatamura nganai; ");
INSERT INTO dif_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Buka maru, mita maru nganai; paua ngumu mililaia kupa nganai; nindri madlentji madlentjaia kupa nganai; ");
INSERT INTO dif_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Talpalali, nulu jenia jaupana, nau kutji madlentji nganai; kampani ditji mita mudani nganai; kampanietja angela wora nganai. ");
INSERT INTO dif_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Worderu tanali nindri madlentji kampai ja turujeli japiai, jeruja bakana mita mudanani nganala nganai. ");
INSERT INTO dif_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Kanaia Ngatamurajeli angala worana nunkani jinpala nganai ja nunkani mililandru kampala nganai tjikatjika pratjana, ja tanana madlentji ngankanietja. ");
INSERT INTO dif_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ja tanali tanana turu pirini worala nganai; naka tana ngirikidala nganai ja mana katakatangala nganai. ");
INSERT INTO dif_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Jendranguta kana talku mintjila nganai ditji pirna jeribaka tanani Ngaperaia mililani.“ Warle talpa ngamalkai ngarala, nulu ngaraiatimai! ");
INSERT INTO dif_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Nakaldra pariwilpaia milila poto pirna jeribaka nganai, nau mitani kurukuru parai; nina kana kulnujeli mankamankana wonti ja kutibana wonti, ja nunkangundru pirna mankina nau wapana wonti, ja warupoto, mina nulu ngamalkana, jinkina wonti, ja ninapini mita burungankana wonti. ");
INSERT INTO dif_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Nakaldra pariwilpaia milila jinkimalinietja jeribaka nganai, nulu marda ngumu wontiai. ");
INSERT INTO dif_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ja nulu marda kulno ngumu pirna matja mankamankana, nau wapana wonti, ja warupoto, mina nulu ngamalkana, jinkina wonti, ja nina burungankana wonti. ");
INSERT INTO dif_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Nakaldra pariwilpaia milila jama pirna jeribaka nganai, nina kanali panto pirnani worai ja paru nguja marapu kampai. ");
INSERT INTO dif_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ja naupini matja manamiririna, tanali nina taralkana wonti dirkalaia, ja tana ngamana ngarina wonti, ja tanali tanana ngumu pirrani kurana wonti, ja tanana madlentji worana wonti. ");
INSERT INTO dif_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Jeruja mita mudanani nganala nganai; angala wora dunkala nganai, ja tanali puntipuntibala nganai kana madlentji kana talkundru, ");
INSERT INTO dif_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ja tanana turu pirini worala nganai; naka tana ngirikidala nganai ja mana katakatangala nganai. ");
INSERT INTO dif_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesus tanangu jatana wonti: „Jura tananapini pratjana ngundrana warai?“ Tana nunkangu jatana wonti: „Kau, Kaparajai!“ ");
INSERT INTO dif_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Nau tanangu jatana wonti: „Jendrania jaura jinkinietja pratjana, tana mili pantjinala pariwilpaia mililaia, punga ngamalkanietja jeribaka nganai, tanali tanani poto pirnandru marra ja womala dunkalkai.“ ");
INSERT INTO dif_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ja jendranguta Jesujeli tananapini jeribaka jaura mudana wonti, Nau nakandru puntina wonti. ");
INSERT INTO dif_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ja Nau ngura kamanelini wokarana wonti, ja Nulu tanangu ngujangujara jinkina wonti jaura pungani tananani, ja tana pirna ngaruparana wonti ja jatana wonti: „Wodajerindru Nulia ninapini kiri ja ngurula manina? ");
INSERT INTO dif_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Naupini wata pita ngankanietjaia ngatamura nganai? Ja ngandri nunkani Maria? Ja ngatata nunkani Jakobus ja Joses ja Simon ja Judas? ");
INSERT INTO dif_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ja wata kaku nunkani pratjana ngaianangu jela nganai? Wodajerindru Nulia jenia pratjana manina?“ ");
INSERT INTO dif_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ja tana nunkangu kuterina wonti. Ja Jesus tanangu jatana wonti: „Propheta wata waka nganai, windri ngura kamanelini ja pungani nunkanani.“ ");
INSERT INTO dif_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ja Nulu wata pirnala marapu naka ngankana wonti, ngangau tanali wata morlalu ngundrana wonti. ");
INSERT INTO dif_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tanangupini ditjini Herodes, mitaia kapakaparali, pinti Jesungundru ngarana wonti, ");
INSERT INTO dif_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ja nau milini nunkanani jatana wonti: „Naupini Johannes multibanietja nganai, Nau narindru jiritjina warai; ngangau Nulu jenia pirnala ngankai.“ ");
INSERT INTO dif_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ngangau Herodili Johannes patana wonti ja dupudupu ngankana wonti ja nina kanjangari pungani widmana wonti, Herodias Philippuni ngatataia nunkanaia noandru. ");
INSERT INTO dif_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ngangau Johannes nunkangu jatana wonti: „Jinkangu wata talku nganai nana ngamalkananto.“ ");
INSERT INTO dif_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Nulu ngantjana wonti, nina nari ngankala, windri nau japali nganana wonti kana wolarandru; ngangau tanali nina Propheta ngundrana wonti. ");
INSERT INTO dif_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Herodili dankani ditji nunkani ngamalkana, Herodiani ngatani tanangu terti kilina wonti, ja Herodes nankangu murlali nganana wonti. ");
INSERT INTO dif_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Jendrania nau nankangu jaura morlalu jatana wonti, nankangu jinkila, minani nani ngatjinani. ");
INSERT INTO dif_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ngandrieli nankanali nana matja kurukurubana, nani jatana wonti: „Jinkiau ngakangu ninkida pirrani Johannes multibanietja mangatandra.“ ");
INSERT INTO dif_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ja mitaia kapara burkali pantjina wonti; windri jaura morlalundru ja pungaia kamanelindru nulu jirijiribana wonti, nina nankangu jinkinanto. ");
INSERT INTO dif_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ja nulu jinpana wonti ja Johannes mangatandra wokaribana wonti kanjangari pungani. ");
INSERT INTO dif_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ja tanali mangatandra pirrani tikalkana wonti ja mankarani jinkina wonti, ja nandru nina ngandrini nankanani padakana wonti. ");
INSERT INTO dif_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ja mili nunkani wokarana wonti ja palku nunkani manina wonti ja nina todina wonti ja wapana wonti, Jesungu jenia kaukaubala. ");
INSERT INTO dif_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ja Jesujeli jenia matja ngarana, nau nakandru botali wapana wonti pitaraia pilki. Ja kana wolarali jenia matja ngarana, tana tidnali nunkangu karipaterina wonti ngura wolarandru. ");
INSERT INTO dif_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ja Jesus dunkana wonti, ja Nulu kana wolara pirna najina wonti; ja Nau tanangu kalumiltjamiltjarina wonti, ja Nulu muntja tanani tepi ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Matja kalkaurarina, mili nunkani nunkangu wokarana wonti ja jatana wonti: „Ninkida pitaru nganai ja ditji matja wirina; kana wolara jinpau, tanaia nguraia wapananto buka tanani burungankala.“ ");
INSERT INTO dif_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesus tanangu jatana wonti: „Tanaia wata wapananto; jura tanangu buka jinkianau.“ ");
INSERT INTO dif_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Tana nunkangu jatana wonti: „Ngaiani ninkida windri buka ngunku mara wora ja paru mandru ngamalkai.“ ");
INSERT INTO dif_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Nau jatana wonti: „Jura ngakangu tanana padakanimai.“ ");
INSERT INTO dif_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ja Nulu jirijiribana wonti, kana wolara kantani ngamana ngarinanto; ja Nulu buka mara wora ja paru mandru patana wonti, ja pariwilpani najina tarana wonti, ja tanana ngurungutana wonti; ja Nulu buka wokaribana wonti ja milini nunkanani jinkina wonti, ja milieli kana wolarani. ");
INSERT INTO dif_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ja pratjanali tajina wonti ja jerturina wonti, ja tanali buka worduwordu kampana wonti, billi marapratjana ja mandru manamiri. ");
INSERT INTO dif_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ja tana materi 5000 nganana wonti, matja tajina, kalitakali widlakupata. ");
INSERT INTO dif_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ja wolja Jesujeli mili nunkani jinpana tertana wonti, tana botani wirinanto ja nunkangu ngopera jerankaria pararananto, Nulu ngopera kana wolara jinpananto. ");
INSERT INTO dif_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ja Nulu kana wolara matja jinpana, Nau mardawonpaia tarana wonti ngatjila kulnulu. Ja matja kalkaurarina, Nau naka kulnulu nganana wonti. ");
INSERT INTO dif_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Bota matja panto mandrani ngananani, mandikilali nina jupana wonti; ngangau watara tanangu mudlani ngakana wonti. ");
INSERT INTO dif_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Nguramaranikuperi Jesus tanangu wokarana wonti ngapani wapana. ");
INSERT INTO dif_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ja milieli nina najina ngapani wapanani, tana japali pirna pantjina wonti jo jatana wonti: „Kutji Nauja nganai!“ ja tana japali maritjina wonti. ");
INSERT INTO dif_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Nurujeli Jesus tanangu jatana wonti: „Murlali ngananimai, ngani Nauja; wata japali ngananimai!“ ");
INSERT INTO dif_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petrujeli nunkangu kalabana wonti ja jatana wonii: „Kaparajai! Jidni ngananani, ngana karkamai, ngani jinkangu ngapani wokarananto.“ ");
INSERT INTO dif_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Nau jatana wonti: „Kaparau!“ Ja Petrus botandru ngarina wonti ja ngapani wapana wonti, Jesungu wokarala. ");
INSERT INTO dif_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Nulu watara pirna najina, nau japali pantjina wonti; ja nau nganana ngarina wonti kunakutila, nau maritjina wonti ja jatana wonti: „Kaparajai, ngana kulkamai!“ ");
INSERT INTO dif_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Nurujeli Jesujeli nguna warpina wonti ja nina patana wonti ja jatana wonti: „Wuldrungundranietjajai, minandru jidni mangangankai?“ ");
INSERT INTO dif_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ja pudla botani tarana, watara mudana wonti. ");
INSERT INTO dif_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tana kana botani wokarana wonti nunkangu pantjaterkana ngarila, ja jatana wonti: „Morlalu, Jidni Godaia Ngatamura nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ja tana matja pararana, tana Genezareth mitani wokarana wonti. ");
INSERT INTO dif_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ja kanali nunkangupini ngurani nina matja ngujamana, tanali mita marapuni karakara jinpana wonti, ja tanali muntja pratjana nunkangu wokaralkana wonti. ");
INSERT INTO dif_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ja tana nunkangu ngatjina wonti, tanali windri katijelbi nunkani karakarananto; ja worderuntjali karakarana wonti, tepi pantjina wonti. ");
INSERT INTO dif_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ngadani Pharisaia ja jaura jinkinietja Jerusalemingundru Jesungu wokarana wonti ja jatana wonti: ");
INSERT INTO dif_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","„Minandru milieli jinkanali pinaraia jirijiribani jaura dankarai? Ngangau tanali mara wata kulirkateriai buka tajila.“ ");
INSERT INTO dif_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Nulu kalabana wonti ja tanangu jatana wonti: „Minandru jura Godaia jirijiribani jaura dankarai jurani jirijiribani jaurandru?“ ");
INSERT INTO dif_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ngangau Godali jirijiribana wonti ja jatana wonti: „Ngaperi ja ngandri pirna ngundramai!“ ja: „Warle ngaperani ja ngandrini jaura madlentji jatai, nau naria palinanto.“ ");
INSERT INTO dif_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ja jura jatai: „Worana npaperani kara ngandrini kara jatai: Poto ngumu ngato jinkiai, mina jinkangu ngumu nganai, nina jundru ngakangundru maninanto; ja nulu ngaperi nunkani kara, ngandri nunkani kara, wata pirna ngundrananto.“ ");
INSERT INTO dif_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ja jura Godaia jirijiribani jaura worana warai jurani jirijiribani jaurandru. ");
INSERT INTO dif_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Jura kana jeljujelju, ngumu Jesaiasali jurangundru talpadakana wonti ja jatana wonti: ");
INSERT INTO dif_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","„Tanapini kana wolara manali ngakangu wokarai ja manamimieli ngana pirna ngundrai, ja tanani ngara ngakangu worita nganai. ");
INSERT INTO dif_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Bakujeli tanali ngana pirna ngundrai; ngangau tanali kanaia jirijiribani jaurandru ngujangujara jinkiai.“ ");
INSERT INTO dif_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ja Nulu kana wolara karkana wonti ja tanangu jatana wonti: „Ngaranimai, ja ngundranimai! ");
INSERT INTO dif_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Wata jendralipara, mina manani wiriai, kana murumaru ngankai; a‐ai, windri jendralipara, mina manandra dunkai, nulupini kana murumuru ngankai.“ ");
INSERT INTO dif_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Jendranguta mili nunkani wokarana wonti ja nunkangu jatana wonti: „Jidni milkila, Pharisaiali ninaia jaura matja ngarana, tana kalakalarina warai?“ ");
INSERT INTO dif_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Nulu kalabana wonti ja jatana wonti: „Nindri pratjana, tananapini Ngaperali ngakanali pariwilpani wata kuranala, tanana tanali dukarala nganai. ");
INSERT INTO dif_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Tana worani; ngangau tana butjuja palto wondranietja ja munta butju nganai; butjujeli butjuni palto wondranani, pudla kutuni purila nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petrujeli kalabana wonti ja nunkangu jatana wonti: „Ninapini jeribaka jaura ngaianingu mildiri ngankamai.“ ");
INSERT INTO dif_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesus jatana wonti: „Bakana jura patipati nganai? ");
INSERT INTO dif_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Jura wata ngujamai, jenipara pratjana, mina manani wiriai, mandrani ngariai, ja ngadani palkingai? ");
INSERT INTO dif_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Jenipara, mina manandru dunkai, ngarandru wokarai; ja jendralipara kana murumuru ngankai. ");
INSERT INTO dif_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ngangau ngarandru dunkai, ngundrana madlentji, naria nandrani, pinta wokaribana, palakantji, kurikantji, jedieli jaura morlalu kurani, ngirkibani. ");
INSERT INTO dif_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Tanalipini kana murumuru ngankai; mara murumurujeli tajina wata kana murumuru ngankai.“ ");
INSERT INTO dif_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ja Jesus nakandru wapana wonti ja kutingana wonti Tyrus ja Sidon mitaia. ");
INSERT INTO dif_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ja mai, Canaan widla kulno nunkangupini wondirandru dunkana wonti ja maritjina wonti ja nunkangu jatana wonti: „Kaparajai, Davidani ngatamurajai! ngakangu kalumiltjamiltjariau; ngatani ngakani kutjieli pirna jupai.“ ");
INSERT INTO dif_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ja Nulu wata jaura kulno kalabana wonti nankangu. Ja mili nunkani nunkangu wokarana wonti ja nunkangu ngatjina wonti ja jatana wonti: „Nanaia jinpamai: ngangau nania ngaianangu maritjina karipateriai.“ ");
INSERT INTO dif_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ja Nulu kalabana wonti ja jatana wonti: „Ngapili ngana jinpana wonti windri tanangupini tjipia, tana Israel pungandru tintaterinala.“ ");
INSERT INTO dif_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ja nani wokarana wonti ja nunkangu pantjaterkana ngarina wonti ja jatana wonti: „Kaparajai, ngakangu marangokau!“ ");
INSERT INTO dif_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ja Nulu kalabana wonti ja jatana wonti: „Wata jenia talku nganai, kupaia buka manina ja kintalani worana.“ ");
INSERT INTO dif_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Nani jatana wonti: „Kau, Kaparajai; ja bakana kintalali buka worduwordu tajiai, kapara worani kurlindru purinani.“ ");
INSERT INTO dif_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jendranguta Jesujeli kalabana wonti ja nankangu jatana wonti: „Widlajai, morlalu ngundrana jinkani pirna nganai; mina jidni jertapateriai, jenia jinkangu pantjiatimai.“ Ja ngatani nankani tepirina wonti nunkangupini ditjini. ");
INSERT INTO dif_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ja Jesus nakandru wapana wonti ja Galilaia pantuni wokarana wonti ja mardawonpani tarana wonti ja naka ngamana ngarina wonti. ");
INSERT INTO dif_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ja kana wolara pirna nunkangu wokarana wonti, tanali padakana wonti tjunduru, butju, ngapu, dupudupu ja nguja marapu; ja tanali tanana Jesungu tidnani worana ngarina wonti, ja Nulu tanana tepi ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Jeruja kana wolara pirna ngaruparana wonti, ngangau tanali najina wonti, ngapula jatanani, dupudupula tepi, tjundurula wapanani ja butjulali najinani; ja tanali Israelani Goda jurakokana wonti. ");
INSERT INTO dif_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesujeli mili nunkani karkana wonti ja jatana wonti: „Ngani kana wolarani kalumiltjamiltjariai, ngangau ditji parkulu tanaia ngakangunto ngamana warai, ja tanalia panila ngamalkai tajila; ja ngato wata ngantjai, tananaia maua jinpala, tanaia paltuni wariwariati.“ ");
INSERT INTO dif_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ja mili nunkani nunkangu jatana wonti: „Wodajerindru ngaiani pitarani jeruntja buka maninanto, tananapini kana wolara jerto ngankala?“ ");
INSERT INTO dif_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ja Jesus tanangu jatana wonti: „Worderuntja buka ngunku jura ngamalkai?“ Tana jatana wonti: „Mara wora ja mandrumata ja paru wakawaka ngalje.“ ");
INSERT INTO dif_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ja Nulu kana wolarani jirijiribana wonti, tana mitani ngamana ngarinanto. ");
INSERT INTO dif_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ja Nulu buka ngunku mara wora ja mandru ja paru patana wonti, ja Nulu tanana ngurungutana wonti ja wokaribana wonti ja milini nunkanani jinkina wonti, ja milieli kana wolarani. ");
INSERT INTO dif_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ja pratjanali tajina wonti ja jerturina wonti, ja tanali buku worduwordu kampana wonti billi mara wora ja mandru manamiri. ");
INSERT INTO dif_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ja tanali matja tajina materi 5000 nganana wonti kalitakali widlakupata. ");
INSERT INTO dif_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ja Nulu kana wolara matja jinpana, Nau botani wirina wonti, ja Magdalaia wondirani wokarana wonti. ");
INSERT INTO dif_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ja Pharisaia ja Sadducaia wokarana wonti nina wontjala, ja nunkangu ngatjina wonti, Nulu tanangu malka kulno pariwilpandru wondrananto. ");
INSERT INTO dif_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Nulu kalabana wonti ja tanangu jatana wonti: „Matja kalkaurarinani, jura jatai: Ditji ngumu nganala nganai ngangau pariwilpani kalkamaralje pirna nganai. ");
INSERT INTO dif_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ja tankubana palkara: Karari ditjini talara wokarala nganai, ngangau pariwilpani nguramaralje pirna nganai, ja ngalpuru pantjiai. Jura kana jeljujelju! Pariwilpaia mudla jura kiri nganai ngujangujamala, windri miljaraia malka jura wata ngujangujamai. ");
INSERT INTO dif_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Nguja madlentjali ja pinta wokaribanietjali ngantjai malka kulno; ja tanalia wata malka manila nganai, windri Prophetaia Jonani malka.“ Ja Nulu tanana worarana kurana wonti ja wapana wonti. ");
INSERT INTO dif_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ja mili nunkani jerankari wokarana wonti, ja tana kuritarana wonti buka padakala. ");
INSERT INTO dif_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesus tanangu jatana wonti: „Najianau ja ngamalkaterianau Pharisaiaia ja Sadducaiaia pulkurutjeribani bukandru.“ ");
INSERT INTO dif_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Tana ngankamalina wonti ja jatana wonti: „Jenia Nauja jatai, ngangau ngaiana wata buka padakana warai.“ ");
INSERT INTO dif_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesujeli jenia matja ngujamana, Nau tanangu jatana wonti: „Minandru jura ngankamaliai, jura wuldrungundranietja, ngangau jura wata buka padakana warai? ");
INSERT INTO dif_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Jura wata ngundrai ja wata mangatandra wilpariai buka ngunku mara wora materani 5000, ja worderuntja billi jura kampana paraia? ");
INSERT INTO dif_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ja bakana wata buka ngunku mara wora ja mandru materani 4000, ja worderuntja billi jura kampala wiri? ");
INSERT INTO dif_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Worderu jura bulu ngujamai, ngani wata bukandru jatana warai, jurangu jatana: Jura ngamalkaterinanto Pharisaiaia ja Sadducaiaia pulkurutjeribani bukandru?“ ");
INSERT INTO dif_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Jendranguta tanali ngujamana wonti, Nau wata jatana warai, tana ngamalkaterinanto bukaia pulkurutjeribani bukandru, a‐ai, Pharisaiaia ja Sadducaiaia ngujangujarandru. ");
INSERT INTO dif_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesus Cäsaraia Philippi mitani wokarana wonti, ja Nulu mili nunkani jekibana wonti ja jatana wonti: „Mina kana jatai, worana Kanaia Ngatamura nganai?“ ");
INSERT INTO dif_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Tana jatana wonti: „Palpa jatai: Jidni Johannes multibanietja, palpa Elias, palpa Jeremias kara Propheta kulno kara.“ ");
INSERT INTO dif_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Nau tanangu jatana wonti: „Mina jura jatai, worana ngani nganai?“ ");
INSERT INTO dif_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Petrujeli kalabana wonti ja jatana wonti: „Jidni Christus nganai, Godaia tepia Ngatamura,“ ");
INSERT INTO dif_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ja Jesujeli kalabana wonti ja nunkangu jatana wonti: „Murlali pirna jidni nganai, Simon, Jonani ngatamura; ngangau palkujeli ja kumarali jinkangu jenia wata tinkari ngankana warai, a‐ai, Ngaperali ngakanali pariwilpani. ");
INSERT INTO dif_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ja ngani bakana jinkangu jatai: Jidni Petrus nganai, ja nunkangupini marda tulurani ngato milila ngakani wotila nganai, ja turu manali nina wata kalalu ngankala nganai. ");
INSERT INTO dif_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ja ngato jinkangu pariwilpaia mililaia mana ngamalkijiribananto jinkila nganai; ja mina jundru mitani dupudupu ngankala nganai, jenia bakana pariwilpani dupudupu nganala nganai; ja mina jundru mitani dukarala nganai, jenia bakana pariwilpani walto nganala nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ngadani Nulu mili nunkani daudauana wonti, tanali jenia wata kulnuni kaukaubananto, Nau Jesus Christus nganai. ");
INSERT INTO dif_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Jendranguta Jesujeli wonina wonti, milini nunkanani wondraterila, Nau Jerusalemia wapananto ja pinaru woraugundru ja Priesta pirnandru ja jaura jinkinietjandru pirna ketjaketjananto, ja tanali nina nari ngankananto, ja Nau ditjini parkulani nakaldra jiritjinanto. ");
INSERT INTO dif_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ja Petrujeli nina tjirimalkana wonti, ja wonina wonti nina daudauala ja jatana wonti: „Ngamalkateriamai, Kaparajai, wata jenia jinkangu pantjinanto.“ ");
INSERT INTO dif_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nau karitjina wonti ja Petrungu jatana wonti: „Ngakangu ngadaia nganamai, Satanajai! jundru ngana ngandrawalkai; ngangau jundru wata ngundrai, mina Godaia nganai, a‐ai, windri mina kanaia.“ ");
INSERT INTO dif_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jesus milini nunkanani jatana wonti: „Warle ngantjai ngakangu karipaterila, nau munta panila ngundrateriatimai, ja nulu kunarku nunkani maniatimai ja ngakangu karipateriatimai. ");
INSERT INTO dif_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ngangau warle tepi nunkani ngantjai kulkala, nulu nina tintala nganai; ja warle tepi nunkani tintai ngakangundru, nulu nina mankamankala nganai. ");
INSERT INTO dif_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Jenia kanani ngumu nganai kara, nulu mita maru maninani, ja mungara tintaterinani? Mina kalala kanali jinkinanto kara mungarani nunkanani? ");
INSERT INTO dif_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ngangau wolja Kanaia Ngatamura Ngaperaia nunkanaia pirnalali wokarala nganai nunkani angela worangunto; ja ngadani Nulu warupotuni kalala jinkila nganai tanani ngankanandru. ");
INSERT INTO dif_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Morlalu ngani jurangu jatai: Tanangundru palpa ninkida terkala wapaia, tanalipini nari wata wontjala nganai, tanalia Kanaia Ngatamura mililani nunkanani wokaranani najinantulu.“ ");
INSERT INTO dif_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ditji mara wora ja kulnuni Jesujeli Petrus ja Jakobus ja Johannes ngatata nunkani patana wonti, ja tanana pilki taralkana wonti mardawonpa pirnaia miri. ");
INSERT INTO dif_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ja Nau tanangu njeranjerarina wonti, ja Nau mudla ditji jeri mintjina wonti, ja kati nunkani bulurina wonti praitji jeribaka. ");
INSERT INTO dif_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ja mai, Moses ja Elias tanangu wondraterina wonti, pudla ngankamalina wonti nunkangu. ");
INSERT INTO dif_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Petrujeli kalabana wonti ja Jesungu jatana wonti: „Kaparajai, ninkida ngaianangu ngumu nganai; Jundru jenia ngantjai, ngaiani punga parkulu ninkida wotila nganai, jinkani kulno, Mosini kulno ja Eliani kulno.“ ");
INSERT INTO dif_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nau jeruja jatana, mai, talarapalku kulikirieli tanana walpadakana wonti. Ja mai, ngaiala talarapalkundru jatana wonti: „Naupini Ngatamura ngantjalu ngakani nganai, nunkangu ngani murlali nganai; ninaia ngaranimai.“ ");
INSERT INTO dif_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Milieli jenia matja ngarana, tana mudlali purina wonti ja japali pirna nganana wonti. ");
INSERT INTO dif_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ja Jesus tanangu wokarana wonti ja tanana karakarana wonti ja jatana wonti: „Jiritjianau, ja wata japali ngananau!“ ");
INSERT INTO dif_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Matja tana milki tjenmana, tanali kana pani najina wonti, windri Jesus kulnulu. ");
INSERT INTO dif_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ja tana mardawanpandru ngarina tikana, Jesujeli tanana daudauana wonti ja jatana wonti: „Ninaia mudla wata kulnuni kaukaubanau, Kanaia Ngatamura narindru jiritjinantulu.“ ");
INSERT INTO dif_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ja milieli nunkanali nina jakalkana wonti ja jatana wonti: „Minandru jaura jinkinietja jatai, Elias ngopera wokarananto?“ ");
INSERT INTO dif_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesujeli kalabana wonti ja tanangu jatana wonti: „Elias morlalu wokarala nganai, ja nulu warupoto nakaldra talku kurala nganai. ");
INSERT INTO dif_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ja ngani jurangu jatai: Elias matja wokarana warai, ja tanali nina wata ngujamana warai, a‐ai, nunkangu ngankana warai, mina tana jertapaterina warai. Jeruja bakana Kanaia Ngatamura tanangundru ketjaketjala nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ngadani milieli nunkanali ngujamana wonti, Nau tanangu Johannes multibanietjandru jatana warai. ");
INSERT INTO dif_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ja tana kana wolarani wokarana, kana kulno nunkangu wokarana wonti ja nunkangu pantjaterkana ngarina wonti, ");
INSERT INTO dif_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ja jatana wonti: „Kaparajai, ngatamurani ngakanani kalumiltjamiltjariau; ngangau nauwa pirala muntja nganai ja pirna ketjaketjai, ja pota marapu nauwa turuni puriai ja pota marapu ngapani. ");
INSERT INTO dif_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ja ngato ninawa milini jinkanani wapalkana warai, ja tanaia ngandandarina warai, ninawa tepi ngankala.“ ");
INSERT INTO dif_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesujeli kalabana wonti ja jatana wonti: „Jura nguja gilbarinietja ja tjautjauetja! Wintaranaia ngani jurangu jela nganananto? Wintaranaia ngato jurana ngamalkananto? Ninawa ngakangu padakanau ninkida.“ ");
INSERT INTO dif_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ju Jesujeli nina dikidikibana wonti, ja kutji murumuru nunkangundru dunkana wonti, ja kanku nunkangupini ditjini tepirina wonti. ");
INSERT INTO dif_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Jendranguta mili Jesungu pilki wokarana wonti ja jatana wonti: „Minandru ngaiani ngandandarina warai, ninaia dunkalkala?“ ");
INSERT INTO dif_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesus tanangu jatana wonti: „Jurani gilbarinandru. Ngangau morlalu ngani jurangu jatai: Jura morlalu ngundranani tandra wakawaka jeribaka, jura nunkangupini mardawonpani jatala nganai: «Ninkidandru tiringau jelaniwa;» ja nauja jelaniwa tiringala nganai, ja watala jura ngandandarila nganai. ");
INSERT INTO dif_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Naupara nguja wata dunkai, windri ngatjinali ja milja ngamanali.“ ");
INSERT INTO dif_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Tana Galilaiani wirarina, Jesus tanangu jatana wonti: „Tanali Kanaia Ngatamura kana marani ngulkujeli jinkila nganai. ");
INSERT INTO dif_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ja tanali ninaia nandrala nganai, ja ditjini parkulani Nauja jiritjila nganai.“ Ja tana ngaurongauro pirna pantjina wonti. ");
INSERT INTO dif_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Tana Kapernaum ngurani wokarana, kalala kampanietja Petrungu wokarana wonti ja jatana wonti: „Jurani Ngujangujana jinkinietjali wata kalala jinkiai?“ ");
INSERT INTO dif_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Nau jatana wonti: „Kau.“ Ja nau pungani wirina Jesujeli nina ngaringana wonti ja jatana wonti: „Mina jundru ngundrai, Simoniai? Worangundru mitaia kaparali kalala pilki ja pilki maniai, tanani kupandru kara, tulandru kara?“ ");
INSERT INTO dif_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petrus nunkangu jatana wonti: „Tulandru.“ Jesus nunkangu jatana wonti: „Jeruja kupa baku nganai. ");
INSERT INTO dif_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ngangau ngaiana tanana wata ngirkibananto, pantuja wapau, ja manakira worau, ja paru ngoperala nau taranani, maniau; ja jundru mana matja pirakana, jundru Statera mardatandra mankamankala nganai: Nina maniau, ja tanangu jinkiau ngakangundru ja jinkangundru.“ ");
INSERT INTO dif_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nunkangupini ditjini mili Jesungu wokarana wonti ja jatana wonti: „Worana pariwilpaia mililani morla pirna nganai?“ ");
INSERT INTO dif_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ja Jesujeli kupa waka karkana wonti ja tanangu terti terkibana wonti, ");
INSERT INTO dif_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ja jatana wonti: „Morlalu ngani jurangu jatai: Jura wata karitjinani ja kupa wakawaka jeribaka pantjinani, jura morlalu wata pariwilpaia mililani wirila nganai. ");
INSERT INTO dif_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Worana waka ngankateriai nunkangupini kupani jeribaka, naupini pariwilpaia mililani morla pirna nganai; ");
INSERT INTO dif_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ja warle jenipara kupa waka kulno patai talani ngakanani, nulupini ngana patai. ");
INSERT INTO dif_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Warle tanangundru kulno wakawaka, ngakangu morlalu ngundranani, karkarkai, nunkangu ngumu nganai, marda wati jerkalani kurananto ja nina panto mandrani terti jikananto. ");
INSERT INTO dif_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Jakajai mitani karkarkanandru! Karkarkana kantji nganananto, ja jakajai nunkangupini kanani, nulu karkarkai. ");
INSERT INTO dif_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Marali kara, tidnali kara jidnana karkarkanani, ninaia wokaribamai jo jinkangundru woramai; Ngumu jinkangu nganai, tidna wordu kara, nguna wordu kara, tepini wirila; tanali jidna mara mandrunto kara, tidna mandrunto kara turu nguralia woraiati. ");
INSERT INTO dif_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ja milkieli jidnana karkarkanani, ninaia dukaramai, ja jinkangundru woramai; Ngumu jinkangu nganai, milki kulnunto tepini wirila; tanali jidna milki mandrunto turu pirnaia woraiati. ");
INSERT INTO dif_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ngamalkaterianau, jura kulno tanangundru wakawaka waka ngundraiati; ngangau ngani jurangu jatai: Tanani angelali pariwilpani milingera ngakani Ngaperi mudla pariwilpani najila wapaia. ");
INSERT INTO dif_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ngangau Kanaia Ngatamura wokarana warai kulkala, mina tintaterina warai. ");
INSERT INTO dif_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Mina jura ngundrai? Kana kulnujeli 100 tjipi ngamalkanani ja kulno tanangundru tintaterinani, nulu wata 99 mardawonpani worarala nganai ja wapala nganai, nina manila, nau tintaterina warai? ");
INSERT INTO dif_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ja jeruja ngananani, nulu nina mankamankana, morlalu ngani jurangu jatai: Nau nunkangu morla mankila nganai tanangu 99, tana wata tintaterina warai. ");
INSERT INTO dif_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Jeruja Ngaperi jurani pariwilpani wata jertapateriai, kulno tanangundru wakawaka tintaterinanto. ");
INSERT INTO dif_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ngatatajeli jinkanali jinkangu madlentji ngankanani, wapau, ja kurukurubamai nina kulnujeli. Nulu jidna ngaranani, jundru ngatata jinkani kulkana warai. ");
INSERT INTO dif_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Nulu jidna wata ngaranani, maningamai jinkangu kulno kara mandru kara, ngangau jaura pratjana morlalu kuranietja mana mandruni kara parkulani kara parananto. ");
INSERT INTO dif_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nulu tanana bulu ngaranani, mili wolarani kaukaubamai; nulu mili wolara bulu ngaranani, nau jinkangu kana ko ja mardatandra kampanietja jeribaka nganaiatimai. ");
INSERT INTO dif_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Morlalu ngani jurangu jatai: Mina jura mitani dupudupu ngankala nganai, jenia bakana pariwilpani dupudupu nganala nganai; ja mina jura mitani dukarala nganai, jenia bakana pariwilpani walto nganala nganai. ");
INSERT INTO dif_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Nakaldra ngani jurangu jatai: Mandru jurangundru kulnukulnuni ngananani poto kulnuni, ja nunkangundru ngatjinani, nina tanali manila nganai ngakani Ngaperandru pariwilpani. ");
INSERT INTO dif_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ngangau woderi mandru kara, parkulu kara, jela ngamai talani ngakanani, naka ngani tanangu terti nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ngadani Petrus nunkangu wokarana wonti ja jatana wonti: „Kaparajai, worderuntja pota ngatatajeli ngakanali ngakangu madlentji ngankala nganai; ja worderuntja pota ngato madlentji nunkani worananto? Pota mara wora ja mandrumata?“ ");
INSERT INTO dif_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesus nunkangu jatana wonti: „Ngani jinkangu jatai: Wata pota mara wora ja mandruta, a‐ai, 70 pota mara wora ja mandrumata. ");
INSERT INTO dif_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ngangau pariwilpaia milila mitaia kapara jeribaka nganai, nulu ngantjana wonti, milini nunkanani jelali windamala. ");
INSERT INTO dif_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ja nulu matja wonina windamala, tanali mili kulno nunkangu wapalkana wonti, nau nunkangu 10,000 mardatandra pirna wilpanto nganana wonti. ");
INSERT INTO dif_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ngangau nulu panila ngamalkana wonti jinkila, kaparali nunkanali jirijiribana wonti, nina ja noa nunkani ja ngatamura nunkani ja warupoto, mina nulu ngamalkana jinkinanto, kalala manila. ");
INSERT INTO dif_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Naupini mili nunkangu woraterina wonti ja ngatjina wonti nunkangu ja jatana wonti: «Kaparajai, manju nganamai ngakangu, ngato jinkangu warupoto jinkila nganai.» ");
INSERT INTO dif_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kaparali nunkangu milini kalumiltjamiltjarina wonti ja nina kurakana wonti, ja poto wilpa nulu worani patana wonti. ");
INSERT INTO dif_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ja naupini mili dunkana wonti, ja mili nguruni dankamalina wonti, nau nunkangu 100 mardatandra waka wilpanto nganana wonti, ja nulu nina patana wonti ja jupana wonti ja jatana wonti: «Jinkiamai, mina jidni ngakangu wilpanto nganai.» ");
INSERT INTO dif_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ja mili nguru nunkangu tidnani woraterina wonti ja nunkangu ngatjina wonti ja jatana wonti: «Manju nganamai ngakangu, ngato jinkangu warupoto jinkila nganai.» ");
INSERT INTO dif_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ja nulu wata ngantjana wonti, a‐ai, nau wapana wonti ja nina kanjangari pungani widmana wonti, nulu poto wilpa jinkinantulu. ");
INSERT INTO dif_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Mili ngurujeli jenia matja najina, mina pantjina warai, tana ngaurongauro pirna pantjina wonti ja wokarana wonti, ja tanali kaparani tananani pratjana kaukaubana wonti. ");
INSERT INTO dif_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ngadani kaparali nunkanali nina karkana wonti ja nunkangu jatana wonti: «Jidni mili madlentji; ninapini poto wilpa warupoto ngato jinkangu worani patana warai, ngangau jidni ngakangu ngatjina warai; ");
INSERT INTO dif_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Wata jidni bakana kalumiltjamiltjarinanto mili nguruni, worderu ngani jinkangu kalumiltjamiltjarina warai?» ");
INSERT INTO dif_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ja kapara nunkani tiririna wonti, ja nulu nina jupanietjani jinkina wonti, nulu nunkangu jinkinantulu, mina nau nunkangu poto wilpa nganana wonti. ");
INSERT INTO dif_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jeruja bakana Ngaperali ngakanali pariwilpani jurangu ngankala nganai, jura wata ngarali woranani ngatataja jaranaia madlentji.“ ");
INSERT INTO dif_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ja jendranguta Jesujeli tananapini jaura matja mudana, Nau Galilaiandru puntina wonti ju Judaia wondirani wokarana wonti Jordan kaiarani jerankari. ");
INSERT INTO dif_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ja nunkangu kana wolara pirna karipaterina wonti, ja Nulu tanana naka tepi ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ja Pharisaia nunkangu wokarana wonti nina wontjala, ja nunkangu jatana wonti: „Jenia talku nganai kana kulnuni, noa nunkani worarala ngankana pilki ja pilkindru?“ ");
INSERT INTO dif_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Nulu tanangu kalabana wonti ja jatana wonti: „Jura wata warapana warai, Pantjimanipirnali tanana ngopera materi ja widla pantjimana wonti, ");
INSERT INTO dif_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ja jatana wonti: Jendrania kana kulnujeli ngaperi ja ngandri worarala nganai ja noani nunkanani jela ngamala nganai, ja pudla palku kulno nganala nganai? ");
INSERT INTO dif_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Jeruja pudla wata morla palku mandru, a‐ai, windri palku kulno nganai. Mina Godali matja ngokana, kanali wata puntibananto.“ ");
INSERT INTO dif_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Tana nunkangu jatana wonti: „Minandru Mosili jirijiribana wonti, puntibani dakani jaura jinkila ja nana worarala?“ ");
INSERT INTO dif_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Nau tanangu jatana wonti: „Mosili jenia manuni kurana wonti jurani ngara ngurungurundru, noa jurani worananto; ngopera wata jeruja nganana wonti. ");
INSERT INTO dif_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ngani jurangu jatai: Warle noa nunkani woraranani, nani wata palakantji ngananani, ja noa nguru patanani, nulu pinta wokaribai; ja warle woraworarani widla patanani, nulu bakana pinta wokaribai.“ ");
INSERT INTO dif_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Mili nunkani nunkangu jatana wonti: „Materaia poto noani nunkanani jeruja pirna ngananani, wata ngumu nganai noa patala.“ ");
INSERT INTO dif_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Nau tanangu jatana wonti: „Wata pratjanali ninapini jaura patai, a‐ai, windri tanali, tanangu matja jinkina. ");
INSERT INTO dif_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ngangau palpa eunucha nganai, tana ngandrindru jeruja dankanala; ja palpa eunucha nganai, tanana kanali ngankana warai; ja palpa eunucha nganai, tana pariwilpaia mililandru eunucha ngankaterinala. Worana ngurunguru nganai jenia patala, nulia pataiatimai.“ ");
INSERT INTO dif_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ngadani tanali kupa waka nunkangu padakana wonti, Nau tanangu mara kuraterinanto ja ngatjinanto; ja milieli tanana daudauana wonti. ");
INSERT INTO dif_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jesus jatana wonti: „Kupa worani patanau, ja tananaia wata daudauanau ngakangu wokarananto, ngangau tanangu pariwilpaia milila nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ja Nau tanangu matja mara kuraterina, Nau nakandru wapana wonti. ");
INSERT INTO dif_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ja mai, kulno nunkangu wokarana wonti ja jatana wonti: „Ngujangujara jinkinietja ngumujai, mina ngumula ngato ngankananto, tepi ngurali ngamalkala?“ ");
INSERT INTO dif_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Nau nunkangu jatana wonti: „Minandru jundru ngana ngumu dikai? Wata kulno ngumu nganai, windri Goda kulnulu. Jundru ngantjanani tepini wirila, jirijiribani jaura ngamalkamai.“ ");
INSERT INTO dif_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Nau nunkangu jatana wonti: „Wodanina?“ Jesus jatana wonti: „Jenia: Wata narielu nandramai, wata pinta wokaribamai, wata kurieli maniamai, wata jedi jaura morlalu jatamai. ");
INSERT INTO dif_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ngaperi ja ngandri pirna ngundramai, ja ngurala jinkani ngantjamai jidni munta jeribaka.“ ");
INSERT INTO dif_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Teri nunkangu jatana wonti: „Jenia pratjana ngato ngamalkai kupandru; mina ngato morla ngankananto?“ ");
INSERT INTO dif_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesus nunkangu jatana wonti: „Jundru ngantjanani talku nganala, wapau ja poto jinkani jinkiamai kalalaia, ja wangiwangini bakujeli jinkiau; jeruja jundru pariwilpani poto pirna ngamalkala nganai; ja ngadani tikau ja ngakangu karipateriau.“ ");
INSERT INTO dif_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Terieli nina jaura matja ngarana, nau ngaurongauro tikana wonti, ngangau nau poto pirna nganana wonti. ");
INSERT INTO dif_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jesus milini nunkanani jatana wonti: „Morlalu ngani jurangu jatai: Jenia mati nganai, kana poto pirna pariwilpaia mililani wirinanto. ");
INSERT INTO dif_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nakaldra ngani jurangu jatai: Morla ngaua nganai, Camuli kulno kuri pikiri wilpani palkingananto kana poto pirnani, nau Godaia mililani wirinanto.“ ");
INSERT INTO dif_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Milieli nunkanali jenia matja ngarana, tana pirna ngaruparana wonti ja jatana wonti: „Warlengarla tepita manila nganai?“ ");
INSERT INTO dif_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesujeli tanana najina pararana wonti ja jatana wonti: „Kana ngandandariai ngarla Godata wata ngandandariai.“ ");
INSERT INTO dif_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ngadani Petrulu kalabana wonti ja nunkangu jatana wonti: „Mai, ngaiani pratjana woraranala ja jinkangu karipaterinala; mina kalala ngaiani manila nganai?“ ");
INSERT INTO dif_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesus tanangu jatana wonti: „Morlalu ngani jurangu jatai: Jura ngakangu karipaterina warai marra dankanani, Kanaia Ngatamura ngamanani pirnalaia pirini nunkanani, jura bakana pirnalaia pirini marapratjana ja mandruni ngamala nganai, Juda kanaia kapara marapratjana ja mandruni kalala kurala. ");
INSERT INTO dif_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ja warle worarana warai punga worana kara, nejingatata worana kara, kaku worana kara, ngaperi kara, ngandri kara, noa kara, kupa worana kara, mita worana kara ngakani talandru, nulu 100 potajeli jenia manila nganai ja tepi ngurali patala nganui. ");
INSERT INTO dif_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ja marapu ngoperala ngadaia nganala nganai, ja ngadala ngopera nganala nganai.“");
INSERT INTO dif_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Pariwilpaia milila kana kulno jeribaka nganai, nau pungaia kapara nganai; nau tankubana wapana wonti, ngankanietja karkala wain maruja nunkanaia. ");
INSERT INTO dif_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ja tana talpadakijiribamalina warai mardatandra kulnuja ditji kulnuni, nulu tanana jinpana wonti wain maruja nunkanaia. ");
INSERT INTO dif_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ja nau wapana wonti takubana ditji mirini, ja nulu najina wonti kana nguru baku terkanani jinkimalini pirini, ");
INSERT INTO dif_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ja nau tanangu jatana wonti: „Bakana jura wapanau wain maruja, ja mina talku nganai, ngato jurangu jinkila nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ja tana wapana wonti. Nakaldra nau wapana wonti toda ja ditji kunarkuni ja bakana jeruja ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ditji ngaltingaltini nau wapana wonti, ja kana nguru nulu mankamankana wonti baku terkanani, ja nau tanangu jatana wonti: „Minandru jura ninkida ditjiwirdi baku terkai?“ ");
INSERT INTO dif_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Tana nunkangu jatana wonti: „Wata kana kulnujeli ngaianina karkana warai.“ Nau tanangu jatana wonti: „Bakana jura wapanau wain maruja, ja mina talku nganala nganai, jura manila nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ja matja kalkauranina wain maruja kapara najinajibanietjani nunkanani jatana wonti: „Ngankanietja karkamai, ja tanangu kalala jinkiau, ja woniau ngadanietjandru ngoperaetjajelu.“ ");
INSERT INTO dif_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ja tana ditji ngaltingaltila wokarana wonti, ja tanali mardatandra kulno manina wonti. ");
INSERT INTO dif_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ja ngoperaetja matja wokarana, tanali ngundrana wonti morla manila, ja bakana tanali mardatandra kulno manina wonti. ");
INSERT INTO dif_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tanali nina manina, tana pungaia kaparani kalakalarina wonti, ");
INSERT INTO dif_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ja jatana wonti: „Tanalipini ngadaetjali windri ditji kulno ngankana warai, ja jundru tanana ngaianingu jeribaka ngankana warai, ngaiani ditjiwirdi pirna ngankana warai ja woldrali ketjaketjana warai.“ ");
INSERT INTO dif_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Nulu kalabana wonti ja tanangundru kulnuni jatana wonti: „Kamaneliai, ngato jinkangu wata tjikatjika ngankai; wata ngaldra talpadakijiribamalina warai mardatandra kulnuja? ");
INSERT INTO dif_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Patamai pilki jinkani ja wapamai! Ngani jertapateriai nunkangupini ngadanietjani kalala jinkila jinkangu jeribaka. ");
INSERT INTO dif_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Wata ngakangu talku nganai, potuni ngakanani ngankala worderu ngato ngantjai? Jidni milki madlentji, ngangau ngani ngumu nganai? ");
INSERT INTO dif_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jeruja ngadala ngopera ja ngoperali ngadaia nganala nganai; ngangau marapu matja karkana, ja windri ngalje kalkalkana.“");
INSERT INTO dif_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ja Jesus Jerusalemia tarana, Nulu mili marapratjana ja mandru tjirimalkana wonti ja paltuni tanangu jatana wonti: ");
INSERT INTO dif_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","„Mai, ngaiana Jerusalemia tarala wapaia, ja tanali Kanaia Ngatamura Priesta pirnani ja jaura jinkinietjani ngulkujeli jinkila nganai, ja tanali ninaia naria kurala nganai. ");
INSERT INTO dif_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ja tanali ninaia kana koni ngulkujeli jinkila nganai, ninaia ngirkibala ja nandrala ja kunarkuni katibala; ja ditjini parkulani Nauja nakaldra jiritjila nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ngadani Zebedäuni ngatamuraia ngandri ngatananto nunkangu wokarana wonti ja pantjaterkana ngarina wonti ja nunkangu ngatjina wonti minakulnuja. ");
INSERT INTO dif_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Nau nankangu jatana wonti: „Mina jundru ngantjai?“ Nani nunkangu jatana wonti: „Jatau, pudlapini ngatani ngakani kulno ngunarani ja kulno worangantjuni mililani jinkanani ngamananto.“ ");
INSERT INTO dif_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesujeli kalabana wonti ja jatana wonti: „Judla wata milkila, mina judla ngatjiai. Judla ngurunguru nganai, nunkangupini kokundru tapala, nunkangundru ngato tapananto; ja nina multibanila manila kara, nina multibanila ngato maninanto?“ Pudla nunkangu jatana wonti: „Kauna, ngali ngurunguru nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ja Nau pudlangu jatana wonti: „Koko ngakani judla morlalu tapala nganai, ja nina multibanila, nina ngato maninanto, judla manila nganai; ja ngamana ngunarani ngakanani ja worangantjuni ngakanani jinkila, wata poto ngakani nganai, a‐ai, windri tanangu, worangu Ngaperali ngakanali ngankingana wonti.“");
INSERT INTO dif_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ja mili marapratjanali jenia matja ngarana, tana junkarina wonti neji marani. ");
INSERT INTO dif_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jesujeli tanana karkana wonti ja jatana wonti: „Jura milkila, kana wolaraia kaparali tanangu jirijiribai, ja kana pirnali tanana jupai. ");
INSERT INTO dif_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Jeruja wata jurangu nganaiatimai, a‐ai, warle jurangundru ngantjai pirna pantjila, nau mili jurani nganaiatimai, ");
INSERT INTO dif_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ja warle jurangundru ngantjai ngoperala nganala, nau mili jurani nganaiatimai. ");
INSERT INTO dif_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Worderu Kanaia Ngatamura wata wokarana warai mili ngamalkala, a‐ai, mili nganala, ja tepi nunkani jinkiterila kalala marapuja.“ ");
INSERT INTO dif_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ja tana Jericho ngurandru puntina, nunkangu kana wolara pirna karipaterina wonti. ");
INSERT INTO dif_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ja mai, kana butju mandru paltuni ngamana wonti, pudlali matja ngarana, Jesus wiringanani, pudla maritjina wonti ja jatana wonti: „Kaparajai, Davidani ngatamurajai, ngalingu kalumiltjamiltjariamai!“ ");
INSERT INTO dif_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kana wolarali pudlana daudauana wonti, pudla ngapurinanto; ja pudla morla parparali maritjina wonti ja jatana wonti: „Kaparajai, Davidani ngatamurajai, ngalingu kalumiltjamiltjariamai!“ ");
INSERT INTO dif_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ja Jesus banbana wonti, ja Nulu pudlana karkana wonti ja jatana wonti: „Mina judla ngantjai, ngato judlangu ngankananto?“ ");
INSERT INTO dif_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Pudla nunkangu jatana wonti: „Kaparajai, ngali milki piririnanto.“ ");
INSERT INTO dif_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesus pudlangu kalumiltjamiltjarina wonti, ja Nulu pudlana milki karakarana wonti, ja nurujeli pudlali milkieli nakaldra najina wonti, ja pudla nunkangu karipaterina wonti. ");
INSERT INTO dif_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ja tana Jerusalemingu karakara nganana ja Bethphagingu mani nindri mardawanpani wokarana, jendranguta Jesujeli mili nunkani mandru jinpana wonti, ");
INSERT INTO dif_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ja pudlangu jatana wonti: „Wirialumai nunkangupini ngura wakani judlani mudlankari, ja nurujeli judla donki ngandri mankamankala nganai workamantraterinani kuparanto; nana dukaralumai, ja pudlana ngakangu tikalkalumai. ");
INSERT INTO dif_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ja kulnujeli judlana daudauanani, judla jatalumai: Kaparali pudlanaia karkai; ja nurujeli nulu pudlana jinpala nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Jenia pratjana kantjirina wonti, ngangau morlalu pantjinanto, mina Prophetali kaukaubana wonti, nau jatana wonti: ");
INSERT INTO dif_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","„Zionani ngatamurani kaukaubanimai: Mai, Kapara jinkani jinkangu wokarala wapaia malti, ja Nau dukateriai donkini ja kuparani potowaltanietjaia wolkani.“ ");
INSERT INTO dif_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Mili wulu wapana wonti ja ngankana wonti, worderu Jesujeli pudlangu jirijiribana wonti. ");
INSERT INTO dif_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ja pudlali donki ja kuparu tikalkana wonti, ja kati tanani tanali nunkangu kurana wonti ja nina kurana tarana wonti. ");
INSERT INTO dif_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Kana wolarali kati tanani paltuni jaupana wonti, ja kana ngurujeli ngunanguna wokaribana wonti pita nindrindru, ja tanana paltuni jaupana wonti. ");
INSERT INTO dif_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ja kana wolara, tana ngopera wapana wonti ja karipaterina wonti, maritjina wonti ja jatana wonti: „Hosianna Davidani ngatamurani, ngaiani jurakokai ninaia, Nauja wokarai Kaparaia talani! Hosianna mirini!“ ");
INSERT INTO dif_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ja Nau Jerusalemingu matja wirina, ngura warupotula patijiritjina wonti ja jatana wonti: „Worana Naupini nganai?“ ");
INSERT INTO dif_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Kana wolara jatana wonti: „Naupini Propheta Jesus nganai, Nazarethala, Galilaiandru.“ ");
INSERT INTO dif_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ja Jesus Godaia pungani wirina wonti, ja Nulu pratjana narrana wonti, tanali jinkimalina wonti ja burungankana wonti Godaia pungani, ja mardatandrakaritjimalkanietjaia kurli ja mulapara burungankanietjaia ngamani piri Nulu kokulterkibana wonti; ");
INSERT INTO dif_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ja Nau tanangu jatana wonti: „Dakanala parai: Punga ngakani tanali ngatjini punga dikananto; ja jura ninaia watawatali maninietjaia minka ngankala wapaia.“ ");
INSERT INTO dif_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ja kana butju ja tjunduru nunkangu Godaia pungani wokarana wonti, ja Nulu tanana tepi ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Priesta pirnali ja jaura jinkinietjali jenia pirnala, Nulu ngankanani najina wonti, ja bakana kupa worana Godaia pungani maritjinani ja jatanani: „Hosianna Davidani ngatamurani!“ tana kuterina wonti, ");
INSERT INTO dif_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ja nunkangu jatana wonti: „Jundru ngarai, mina tanapini jatai?“ Jesus tanangu jatana wonti: „Kau, jura wata warapanala: Kupa wakawaka ja ngamatapanietja manandru jundru jurakokananto ngankingana warai?“ ");
INSERT INTO dif_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ja Nulu tanana worarana wonti ja ngurandru wapana wonti Bathania nguraia ja naka tinkani turarana wonti. ");
INSERT INTO dif_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tankubana palkara, Nau nguraia tikana, Nau mauali nganana wonti. ");
INSERT INTO dif_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ja Nulu tandraia nindri kulno paltuni najina wonti ja nunkangu wokarana wonti, ja Nulu nunkangu panila mankamankana wonti, windri talpa; ja Nau nunkangu jatana wonti: „Ngurali wata morla jinkangu tandra punkaiatinimai.“ Ja nurujeli tandraia nindri mujarina wonti. ");
INSERT INTO dif_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ja milieli nunkanali jenia najina, tana ngaruparana wonti, ja jatana wonti: „Worderu nurujeli nauja tandraia nindri mujarina warai?“ ");
INSERT INTO dif_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesujeli kalabana wonti ja tanangu jatana wonti: „Morlalu ngani jurangu jatai: Jura morlalu ngundrana ngamalkanani ja wata mangangankanani, ngadani jura wata windri jenia tandraia nindrini ngankala nganai; bakana jura nunkangupini mardawonpani jatanani: «Dukarateriamai ja ngapa pirnani worateriamai», jenia morlalu pantjila nganai. ");
INSERT INTO dif_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ja pratjana, mina jura ngatjinani juranani ngatjiai ja morlalu ngundrai, jura jenia manila nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ja Nau Godaia pungani wokarana wonti ja ngujangujara jinkina wonti. Ja nunkangu Priesta pirna ja kana wolaraia pinaru wokarana wonti ja jatana wonti: „Mina ngurulali jundru jenia ngankai, ja warle jinkangu ninapini ngurula jihkina warai?“ ");
INSERT INTO dif_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesujeli kalabana wonti ja tanangu jatana wonti: „Bakana ngato jurana jaura kulno jakalkala nganai; jura ngakangu jenia jatanani, bakana ngani jurangu jatala nganai, mina ngurulali ngato jenia ngankai. ");
INSERT INTO dif_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Johannini multibanila, wodajerindru nau nganana wonti: Pariwilpandru kara kanandru kara?“ Tanali tjurujeli ngundrana wonti, ja jatana wonti: „Ngaiani jatanani, «pariwilpandru,» Nauja ngaianingu jatala nganai: Minandru jura nunkangu wata morlalu ngundrana wonti? ");
INSERT INTO dif_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ngaiani jatanani, «kanandru,» ngaiani kana wolarandru japali nganananto, ngangau tanali marapujeli Johannes Propheta patai.“ ");
INSERT INTO dif_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ja tanali Jesungu kalabana wonti ja jatana wonti: „Ngaiani ko.“ Nau bakana tanangu jatana wonti: „Bakana ngani jurangu wata jatai, mina ngurulali ngato jenia ngankai. ");
INSERT INTO dif_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Mina jura ngundrai? Kana kulnujeli ngatamura mandru ngamalkana wonti, ja nau ngoperalani wokarana wonti ja jatana wonti: «Ngatamurajai, wapau, ja karari ngankau ngakani wain maruni.» ");
INSERT INTO dif_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Nulu kalabana wonti ja jatana wonti: «Ngato wata ngantjai.» Ngadani nau burkaljerina wonti ja wapana wonti. ");
INSERT INTO dif_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nau ngadalani wokarana wonti ja nunkangu jeribaka jatana wonti. Nulu kalabana wonti ja jatana wonti: «Kau, kaparajai,» ja wata wapana wonti. ");
INSERT INTO dif_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Warle pudlangundru ngaperaia jertapaterina ngankana wonti?“ Tana jatana wonti: „Ngoperalali.“ Jesus tanangu jatana wonti: „Morlalu ngani jurangu jatai: Mardatandrakampanietja ja palakantji jurangu ngopera Godaia mililani wirila nganai. ");
INSERT INTO dif_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ngangau Johannes jurangu wokarana wonti talkulaia paltuni ja jura nunkangu wata morlalu ngundrana wonti; mardatandrakampanietjali ja palakantjieli nunkangu morlalu ngundrana wonti. Ja jura jenia najina, wata ngadani madlentjandru karitjina wonti, nunkangu morlalu ngundrala. ");
INSERT INTO dif_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jeribaka jaura kulno morla ngaranau: Kana kulno punga ngamalkanietja nganana wonti, nulu wain maru kurana wonti, ja pita terkibana karitjina wonti, ja wain nankani kutu mandrani bakuna wonti, ja punga wutju wotina wonti, ja nina marunajinajibanietja worangu worarana wonti, ja wapana wonti worita. ");
INSERT INTO dif_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Tandraia miljaru matja karakara nganana, nulu mili nunkani wain maru najinajibanietja worangu jinpana wonti, tanali tandra nunkani manijiribananto. ");
INSERT INTO dif_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ja wain maru najinajibanietjali mili nunkani patana wonti, ja kulno nandrana wonti, kulno nari ngankana wonti, kulno mardali dakana wonti. ");
INSERT INTO dif_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nakaldra nulu mili nguru jinpana wonti morla tanangu ngoperalani, ja tanali tanangu jeribaka ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ngadani nulu ngatamura kunakulno jinpana wonti ja jatana wonti: Tana ngakani ngatamurani warawararila nganai. ");
INSERT INTO dif_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Wain maru najinajibanietja worali ngatamura nunkani najina, tana ngankamalina wonti: Naupini maratunkaia; kaparanau, ninaia ngaiana naria nandrananto maratunka nunkani ngaianani nganananto. ");
INSERT INTO dif_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ja tanali nina patana wonti, ja nina wain marundru narrana wonti, ja naria nandrana wonti. ");
INSERT INTO dif_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Wain maruja kapara wokaranani, mina nulu tanangupara wain maru najinajibanietja worangu ngankala nganai?“ ");
INSERT INTO dif_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Tana nunkangu jatana wonti: „Nulu tanana madlentjietja madlentji taribala nganai, ja nulu wain maru wain maru najinajibanietja nguruni jinkila nganai, tanali nunkangu tandra jinkinanto miljaru tananani.“ ");
INSERT INTO dif_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesus tanangu jatana wonti: „Jura wata warapanala jaurani: Naupini marda, nina wotinietjali worana wonti, nau marda buru pantjina wonti. Kaparandru nau jenia pantjina wonti, ja ngaianangu milkini ngaruparana pirna nganai? ");
INSERT INTO dif_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Jendrania ngani jurangu jatai: Jurangundru Nulia Godaia milila manila nganai, ja kana wolara nguruni jinkila nganai, tanalipini tandra nunkani mandrai. ");
INSERT INTO dif_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ja worana nunkangupini mardani puriai, nina nulu nankanankala nganai; worangu nau marda purila nganai, ninapini nulu turara ngankala nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ja Priesta pirnali ja Pharisaiali jeribaka jaura nunkani matja ngarana, tanali ngujamana wonti, Nau tanangundru jatai. ");
INSERT INTO dif_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ja tanali wontjana wonti nina patala, windri tana japali nganana wonti kana wolarandru, ngangau tanali nina Propheta patana wonti. ");
INSERT INTO dif_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ja Jesujeli kalabana wonti ja nakaldra jeribaka jaurali tanangu kaukaubana wonti ja jatana wonti: ");
INSERT INTO dif_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","„Pariwilpaia milila mitaia kapara jeribaka nganai, nulu noapatamalini buka ngankingana wonti nunkani ngatamuraia. ");
INSERT INTO dif_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ja nulu mili worana nunkani jinpana wonti kamaneli karkala noapatamalini bukaia ja tana delkina wonti. ");
INSERT INTO dif_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Nakaldra nulu mili nguru jinpana wonti ja jatana wonti: «Kamanelini jatanimai: Mai, buka ngakani ngato matja ngankingana, nganti pirna ngakani ja nganti manipirna ngato nandrana ja pratjana ngankingana warai; kaparanau noapatamalini bukaia.» ");
INSERT INTO dif_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ja tanali bulu ngarana wonti ja wapana wonti, kulno mitaia nunkanaia, ja kulno ngankanaia nunkanaia; ");
INSERT INTO dif_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Palpali mili nunkani patana wonti ja tanana ngirkibana wonti ja naria nandrana wonti. ");
INSERT INTO dif_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Mitaia kaparali jenia ngarana, nau tiri pantjina wonti ja mili wolara nunkani jinpana wonti ja tanapini naria nandranietja nandrana wonti, ja ngura tanani nulu japina wonti. ");
INSERT INTO dif_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ngadani nau milini nunkanani jatana wonti: «Noapatamalini buka ngato matja ngankingana, windri kamaneli wora wata talku nganai nunkanaia.» ");
INSERT INTO dif_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ngangau palto kunarkuja wapanau, ja noapatamalini bukaia karkanimai pratjana, jura mankamankala nganai. ");
INSERT INTO dif_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ja tana mili wapana wonti paltuni, ja tanali pratjana kampana wonti, tanana matja mankamankana, madlentji ja ngumu. Ja noapatamalini punga manamiririna wonti kamanelieli. ");
INSERT INTO dif_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ja mitaia kapara wirina wonti kamaneli najinajibala, ja nulu naka najina wonti kana kulno noapatamalini kati pani. ");
INSERT INTO dif_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ja nau jatana wonti nunkangu: «Kamaneliai, worderu jidni ninkida wirina warai noapatamalini kati pani?» Ja nau ngapurina wonti. ");
INSERT INTO dif_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Mitaia kapara milini nunkanani jatana wonti: «Ninaia mara ja tidna dupudupu ngankanau, ja ninaia patanau, ja woranimai ngalpuru pirnaia; naka nauja pirna ngirikidala nganai ja mana katakatangala nganai.» ");
INSERT INTO dif_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ngangau marapu matja karkana ja windri ngalje kalkalkana.“ ");
INSERT INTO dif_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ngadani Pharisaia wapana wonti ja ngankamalina wonti, nina jaurali mintieli jeribaka patala. ");
INSERT INTO dif_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ja tanali tanani ja Herodini mili nunkangu jinpana wonti ja jatana wonti: „Ngujangujara jinkinietjajai, ngaiani milkila jidni morlalu nganai, ja Godaia paltundru jundru ngujangujara morlalu jinkiai, ja jidni manubaku nganai kanani, ngangau jundru wata kana mudla ngundrai. ");
INSERT INTO dif_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ngaianingu jatau: Mina jundru ngundrai, jenia talku nganai mitaia kaparani kalala jinkila kara, pani kara?“ ");
INSERT INTO dif_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesujeli madlentji tanani matja ngujamana, Nau jatana wonti: „Minandru jura ngana wontjai, jura kana jeljujelju? ");
INSERT INTO dif_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Kalalaia mardatandra ngakangu wondralkanau.“ Tanali nunkangu mardatandra kulno wondralkana wonti. ");
INSERT INTO dif_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ja Nau jatana wonti tanangu: „Waninunkani mudla naupini nganai, ja mina jaura dirkalani parai?“ ");
INSERT INTO dif_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Tana nunkangu jatana wonti: „Mitaia kaparaia.“ Nau tanangu jatana wonti: „Jinkianau kaparaia poto kaparani ja Godaia poto Godani!“ ");
INSERT INTO dif_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Tanali jenia matja ngarana, tana pirna ngaruparana wonti, ja nina worarana wonti ja wapana wonti. ");
INSERT INTO dif_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nunkangupini ditjini bakana Sadducaia wokarana wonti, tanaia jatai: „Narila wata morla jiritjila nganai;“ ja tanali nina jakalkana wonti, ");
INSERT INTO dif_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ja tana jatana wonti: „Ngujangujara jinkinietjajai, Moses jatana wonti: Kana kulno kupa pani palinani, ngatatajeli nunkanali noa nunkani patananto ja nejini nunkanani ngatamura jiritjibananto. ");
INSERT INTO dif_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ngaianingu neji mara wora ja mandru nganana wonti, ja ngoperalali noa patana wonti ja palina wonti; ja ngangau nulu ngatamura pani ngamalkana, nulu noa nunkani ngatatani nunkanani worarana wonti. ");
INSERT INTO dif_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nunkangu jeribaka bakana mandrulali ja parkulali mara wora ja mandrujelu. ");
INSERT INTO dif_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Pratjaterinani ngadani bakana widla palina wonti. ");
INSERT INTO dif_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Terkakani ditjini, waninunkani noa mara wora ja mandrundru nani nganala nganai, ngangau tanali marapujeli nana ngamalkana wonti?“ ");
INSERT INTO dif_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesujeli kalabana wonti ja tanangu jatana wonti: „Jura tjautjau ngundrai, ngangau jura jaura worana ja Godaia ngurula wata ngujamai. ");
INSERT INTO dif_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ngangau terkakani ditjini tanali wata noa patai ja wata noa pantjiai, a‐ai, tana Godaia angelani pariwilpani jeribaka nganala nganai. ");
INSERT INTO dif_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Nari jiritjinandru jura wata warapanala, mina Godali jurangu kaukaubana wonti, Nauja jatana wonti: ");
INSERT INTO dif_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","«Ngani nganai Abrahamani Goda ja Isaakani Goda ja Jakobani Goda?» Goda wata naria Goda nganai, a‐ai, tepia.“ ");
INSERT INTO dif_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ja kana wolarali jenia matja ngarana, tana nunkani ngujangujarandru pirna ngaruparana wonti. ");
INSERT INTO dif_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Pharisaiali matja ngarana, Nulu Sadducaia ngapu ngankana warai, tana jerra jurborina wonti. ");
INSERT INTO dif_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ja kulnujeli tanangundru, jirijiribani jaura jinkinietjali, nina jakalkana wonti ja wontjana wonti: ");
INSERT INTO dif_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","„Ngujangujara jinkinietjajai, wodanau jirijiribani jauraia kapara nganai jirijiribani jaurani?“ ");
INSERT INTO dif_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesus nunkangu jatana wonti: „Jundru Goda, Kapara jinkani, ngantjamai ngarali jinkanali mungarali jinkanali ja manujeli jinkanali. ");
INSERT INTO dif_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Naupini jirijiribani jauraia ngoperala ja kapara nganai; ");
INSERT INTO dif_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ja kulno nunkangu jeribaka nganai: Ngurala jinkani ngantjamai, jidna munta jeribaka. ");
INSERT INTO dif_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Pudlangupini jirijiribani jaurani jirijiribani jaura ja Prophetaia pratjana parai.“ ");
INSERT INTO dif_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Jendranguta Pharisaia mapaterina wonti, ja Jesujeli tanana jakalkana wonti, ");
INSERT INTO dif_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Ja jatana wonti: „Mina jura ngundrai Christungundru, wani Ngatamura Nauja?“ Tana jatana wonti nunkangu: „Davidani.“ ");
INSERT INTO dif_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Nau tanangu jatana wonti: „Worderu Davidali Jaolali nina Kapara dikai, nau jatana wonti: ");
INSERT INTO dif_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","«Kapara jatanala Kaparani ngakanani: Ngakangu ngunarani ngamana ngariau, ngato talpala jinkani jinkangu tidnani kuranantulu, tidnaparani piri jeribaka?» ");
INSERT INTO dif_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Davidali nina Kapara dikanani, worderu Nau nunkani ngatamura nganai?“ ");
INSERT INTO dif_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ja tana ngandandarina wonti nunkangu jaura kulno kalabala; ja wata kulnujeli morla wontjana wonti nina jakalkala nunkangupini ditjindru. ");
INSERT INTO dif_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ngadani Jesujeli kana wolarani ja milini nunkanani kaukaubana wonti, ");
INSERT INTO dif_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ja jatana wonti: „Mosini ngamani pirini jaura jinkinietja ja Pharisaia wora ngamai. ");
INSERT INTO dif_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Pratjana, mina tana jurangu jatai, jura ngamalkananto, jenia ngamalkanimai, ja ngankanimai; tanani ngankanani jeribaka wata ngankanimai, ngangau tana jatai, ja wata ngankai. ");
INSERT INTO dif_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Tanali bururu mati ja morla wondra workaworkamandrai ja kanani pilpirani kurai; windri tanali muntali wata ngantjai tanana mara ngalkieli patala. ");
INSERT INTO dif_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Tanani ngankana pratjana tanali ngankai, kanali tanana najinanto; tanali tjerapu maru ngankai ja katijelbi wirdi ngankai; ");
INSERT INTO dif_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Tanali ngantjai piri ngopera buka pirnani ja piri ngopera jaura pungani; ");
INSERT INTO dif_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ja jaura murlali jinkimalini pirini, ja kanali tanana «Rabbi» dikananto. ");
INSERT INTO dif_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Tanali jurana wata «Rabbi» dikananto, ngangau Kulno jurani ngujangujara jinkinietja nganai, ja jura pratjana ngatata mara nganai. ");
INSERT INTO dif_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ja wata kulno jurangundru ngaperi dikanimai mitani, ngangau Kulno Ngapari jurani nganai, Nauja pariwilpani. ");
INSERT INTO dif_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Tanali jurana wata ngujangujara jinkinietja dikananto, ngangau Kulno ngujangujara jinkinietja jurani nganai, Christus. ");
INSERT INTO dif_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Worana jurangundru morla pirna nganai, nauja jurani mili nganaiatimai. ");
INSERT INTO dif_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Warle pirna ngankateriai, nau waka pantjila nganai, ja warle waka ngankateriai, nau pirna pantjila nganai. ");
INSERT INTO dif_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Jakajai jurangu, jura jaura jinkinietja ja Pharisaia, jura kana jeljujelju! ngangau jura pariwilpaia milila ngandrawalkai kanani; ngangau jura munta wata wiriai, ja tana wirinani, jura ngandrawalkai wirinanto. ");
INSERT INTO dif_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Jakajai jurangu, jura jaura jinkinietja ja Pharisaia, jura kana jeljujelju! ngangau jura mangawaruja punga tajiai ja ngatjina wirdieli wondralkai; jendrangundruja jura kalala morla pirna manila nganai. ");
INSERT INTO dif_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Jakajai jurangu jura jaura jinkinietja ja Pharisaia, jura kana jeljujelju! jura panto pirnani ja mita mujani wirariai Juda kanaia kamaneli kulno ngankala, ja nau matja pantjina, jura nina turuja kupa ngankai pota mandru morla pirna jurangu. ");
INSERT INTO dif_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Jakajai jurangu, jura paltowondranietja butju! jura jatai: Warle Godaia pungani jaura morlalu kurai, jenia panila nganai; ja warle Godaia pungaia marda maraljani jaura morlalu kurai, nau bakuwilpa nganai. ");
INSERT INTO dif_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Jura kana patipati ja butju! mina morla pirna nganai, marda maralje kara, Godaia punga kara, nulu nina marda maralje kulikiri ngankai? ");
INSERT INTO dif_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ja: Warle jaura morlalu kurai Altarani, jenia panila nganai; warle jaura morlalu kurai potuni, nau nunkangu parai, nau bakuwilpa nganai. ");
INSERT INTO dif_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Jura kana patipati ja butju! mina morla pirna nganai, poto kara, Altara kara, nulu poto kulikiri ngankai? ");
INSERT INTO dif_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Warle Altarani jaura morlalu kurai, nulu jaura morlalu kurai nunkangu ja pratjana nunkangu paranani; ");
INSERT INTO dif_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ja warle jaura morlalu kurai Godaia pungani, nulu jaura morlalu kurai nunkangupini ja nunkangu, Nauja mandrani ngamai; ");
INSERT INTO dif_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ja warle jaura morlalu kurai pariwilpani, nulu jaura morlalu kurai Godaia ngamani pirini, ja nunkangu, Nauja nunkangu ngamai. ");
INSERT INTO dif_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Jakajai jurangu, jura jaura jinkinietja ja Pharisaia, jura kana jeljujelju! ngangau jura manjura ja kalumba ja paua puntibai ja buru kulno marapratjanandru Godani jinkiai, ja jirijiribani jaura mati: Kalala ja kalumiltjamiltjarina ja morlalu ngundrana jura worarai. Tananapini jura ngankananto ja jenia wata worarananto. ");
INSERT INTO dif_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Paltowondranietja butju! jura wajluru ngandrawalkai ja Camuli julkai. ");
INSERT INTO dif_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Jakajai jurangu, jura jaura jinkinietja ja Pharisaia, jura kana jeljujelju! jura koko ja pirra tokuni kulikiri ngankai, ja mandrani puturu ja ngurdi nganai. ");
INSERT INTO dif_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Pharisaia butjujai! ngopera koko ja pirra mandrani kulikiri ngankamai, jeruja bakana toku kulikiririnanto. ");
INSERT INTO dif_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Jakajai jurangu, jura jaura jinkinietja ja Pharisaia, jura kana jeljujelju! ngangau jura wiribani nariwonpa jeribaka nganai, tanana palarani ngumu najiai ja mandrani narimoku ja murumuru manamiri nganai. ");
INSERT INTO dif_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Jeruja bakana jura, palarani jura talku wondrateriai kanani, ja mandrani jura jeljujelju ja madlentji manamiri nganai. ");
INSERT INTO dif_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Jakajai jurangu, jura jaura jinkinietja ja Pharisaia, jura kana jeljujelju! ngangau jura Prophetaia nariwonpa ngankijiribai ja kana talkuja nariwonpa tjirkatjirkai, ");
INSERT INTO dif_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ja jura jatai: Matja ngaiana ngaperaia ngaiananaia ditjini ngamanani, ngaiana wata tanani kamaneli Prophetaia kumarani ngananani; ");
INSERT INTO dif_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Jeruja jura muntali morlalu kurai, jura Propheta nari nandranietjaia ngatamura nganai. ");
INSERT INTO dif_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ja jura ngaperaia juranaia koko manamiri ngankanau! ");
INSERT INTO dif_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Jura tjutju ja wiparaia kuparu worajai! worderu jura turuja kalalandru puntila nganai? ");
INSERT INTO dif_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Mai, jendrania ngato jurangu Propheta worana ja kana kiri ja jaura jinkinietja worana jinpai; tanangundru jura palpa naria nandrala nganai ja palpa kunarkuni katibala nganai, ja tanangundru palpa jura jaura pungani juranani nandrala nganai ja ngura kulnundru ngura kulnuja tanangu tirikaripaterila nganai. ");
INSERT INTO dif_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ngangau jurangu wokarananto kumari talku pratjana, jenia mitani nangana, Abel talkuja kumarandru Zachariani, Barachiani ngatamuraia kumaranilu, nina jura Godaia pungani ja Altarani terti naria nandrana wonti. ");
INSERT INTO dif_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Morlalu ngani jurangu jatai: Jenia pratjana nunkangupini ngujani wokarala nganai. ");
INSERT INTO dif_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jerusalemiai, Jerusalemiai, jundru Propheta worana nandrai ja mardali dakai tanana jinkangu jinpanala; worderuntja pota ngato kupa jinkani jertapaterina wonti mapala, worderu warugati ngandrieli nankani wolka nankani ngaruni mapai, ja jura wata ngantjana wonti. ");
INSERT INTO dif_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Mai, punga jurani ngurawalpa parala nganai. ");
INSERT INTO dif_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ngangau ngani jurangu jatai: Kararindru jura ngana wata morla najila nganai, jura jatanantulu: Ngaiani jurakokai ninaia, Nauja wokarai Kaparaia talani!“ ");
INSERT INTO dif_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ja Jesus dunkana wonti ja Godaia pungandru wapana wonti; ja mili nunkani nunkangu wokarana wonti, nunkangu Godaia punga wotini wondrala. ");
INSERT INTO dif_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesus tanangu jatana wonti: „Jura najiai jenia pratjana? Morlalu ngani jurangu jatai: Wata marda kulno marda kulnuni parala nganai ninaia tanali wata wokaribala nganai?“ ");
INSERT INTO dif_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Nau maninindri mardawonpani ngamana ngarina, mili nunkani nunkangu pilki wokarana wonti ja jatana wonti: „Ngaianingu jatau, winta jenia pantjila nganai? Ja mina jinkani tikani ja mita maruja mudani malka nganai?“ ");
INSERT INTO dif_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ja Jesujeli kalabana wonti ja tanangu jatana wonti: „Ngamalkaterianau, kulnujeli jurana karkarkaiati. ");
INSERT INTO dif_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ngangau marapu talani ngakanani wokarala nganai ja jatala nganai: «Ngani Christus nganai;» ja tanali marapu karkarkala nganai. ");
INSERT INTO dif_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Jura ngarala nganai tirimalina ja tirimalinani pinti; ngamalkaterianau ja wata japali pantjianau; ngangau jenia pratjana pantjinanto, ja mudani jendranguta wata kantji nganala wapaia. ");
INSERT INTO dif_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ngangau kana wolara tiriterkakala nganai kana wolarani ja mitaia kaparaia milila mitaia kaparaia mililani ja maua pirna ja muntja pilki ja pilki nganala nganai, ja mita wiltjiwiltjila nganai mankamanka. ");
INSERT INTO dif_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Jenia pratjana ketjaketjanaia wonini nganai. ");
INSERT INTO dif_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ngadani tanali jurana ngulkujeli jinkila nganai ketjaketjananto, ja jurana nari ngankala nganai, ja kana wolara pratjana jurangu kalakalarila nganai ngakani talandru. ");
INSERT INTO dif_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ja ngadani marapu kalakalarila nganai ja ngulkuterkalkijiribamalila nganai ja kalakalarilkijiribamalila nganai. ");
INSERT INTO dif_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ja Jedikantji‐Propheta marapu terkakala nganai, ja tanali marapu karkarkala nganai. ");
INSERT INTO dif_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ja ngangau delkina pirna pirnarila nganai, kana marapuja ngantjani maltirila nganai. ");
INSERT INTO dif_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Worana wonki ngamai ngadajelu, nulu tepi pirna manila nganai. ");
INSERT INTO dif_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ja tanali ninapini ngantjani jaura mililandru mita maruni kaukaubala nganai, kana warupotuni malka nganananto, ja ngadani mudani wokarala nganai. ");
INSERT INTO dif_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Jura «duljadulja‐tjautjau» najinani, nunkangundru Prophatali Danielali kaukaubana wonti, nau piri kulikirini terkai, — warle jenia warapai ngundraiatimai—. ");
INSERT INTO dif_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ngadani tana Judaia mitala mardawonpaia japa mindriatinimai! ");
INSERT INTO dif_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Worana punga mangatandrani nganai, wata ngarina tikaiatimai, nunkani pungandru minakulno manila, ");
INSERT INTO dif_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ja worana maruni nganai, wata karitjina tikaiatimai kati nunkani manila. ");
INSERT INTO dif_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Jakajai tanangu mandrantjani ja ngama jinkinietjani tanangupini ditjini! ");
INSERT INTO dif_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ngatjianimai jurani japa mindrini wata pantjinanto kilpani kara, Sabbat ditjini kara. ");
INSERT INTO dif_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ngangau ngadani ketjaketjana pirna nganala nganai, worderu mitaia woninandru wata nganana wonti kararielu ja bakana wata morla nganala nganai. ");
INSERT INTO dif_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ja tanapara ditji wata wordurinani, kana pani tepi pirna ngamanani; windri kanandru, tanana Nulia kalkalkana wonti, tanapara ditji wordurila nganai. ");
INSERT INTO dif_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Jendranguta kulno jurangu jatanani: Mai, ninkida Christus nganai kara, jerra Nauja, jenia wata morlalu ngundranimai. ");
INSERT INTO dif_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ngangau Jedikantji‐Christus wora ja Jedikantji‐Propheta wora terkakala nganai, ja tanali malka pirna ja pirnala jinkila nganai; ngangau tana ngurunguru ngananani, tanali bakana karkarkananto, tanana Nulia kalkalkanala. ");
INSERT INTO dif_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mai, ngani jurangu jenia ngopera jatana warai. ");
INSERT INTO dif_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Tana jurangu jatanani: Mai, pitarani nau, wata wapanau; mai, nau punga mandrani, wata morlalu ngundranau. ");
INSERT INTO dif_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ngangau worderu talara praitji dunkai tiriwandru ja mintjiai jendakarajelu, jeruja bakana Kanaia Ngatamuraia tikani nganala nganai. ");
INSERT INTO dif_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ngangau woderi pundupundu parai, jerra kukunka jurboriai. ");
INSERT INTO dif_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Tanangupini ketjaketjani ditjini ngadani nurujeli ditji pirna ngalpuru pantjila nganai, ja pirali praitji nunkani wata jinkila nganai, ja ditji waka wora pariwilpandru purila nganai, ja pariwilpaia ngurula wiltjiwiltjila nganai. ");
INSERT INTO dif_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ja ngadani Kanaia Ngatamuraia malka pariwilpani wondraterila nganai, ja ngadani kana wolara mitani juajuangala nganai, ja tanali Kanaia Ngatamura talara palkujeli pariwilpalali wokaranani najila nganai ngurunguru ja pirna. ");
INSERT INTO dif_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ja Nulia angela worana nunkani jinpala nganai wima kokujeli ngaiala pirnali, ja tanali mapala nganai, tanana Nulia kalkalkanala, watara mandru ja mandrundru pariwilpaia wondiri kulnundru wondiri kulnujelu. ");
INSERT INTO dif_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Tandra nindrindru jeribaka malka kiririanimai; ngunanguna nunkani matja kuljakuljarina ja talpa matja punkana, jura ngujamai woldrakanja karakara nganai. ");
INSERT INTO dif_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Jeruja bakana jura ngujamananto, jura jenia pratjana najinani, nau manani karakara nganai. ");
INSERT INTO dif_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Morlalu ngani jurangu jatai: Naupini nguja wata mudala nganai jenia pratjana pantjinantulu. ");
INSERT INTO dif_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Pariwilpa ja mita maru mudala nganai; jaura ngakani wata mudala nganai. ");
INSERT INTO dif_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ninapini miljaru ja ditji wata kulnujeli ngujamai, bakana wata angelali pariwilpani, a‐ai, windri Ngaperali ngakanali. ");
INSERT INTO dif_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Worderu Noani ditjini, jeruja bakana Kanaia Ngatamuraia tikani nganala nganai. ");
INSERT INTO dif_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ngangau worderu tana ngarimataia ditjia woljaia ngamana wonti; tanali tajina wonti ja tapana wonti, noa patana wonti ja noa pantjina wonti nunkangupini ditjielu, jendranguta Noa bota pirnani wirina wonti; ");
INSERT INTO dif_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ja tanali wata ngundrana wonti ngarimata wokaranantulu ja pratjana tundribanantulu; jeruja bakana Kanaia Ngatamuraia tikani nganala nganai. ");
INSERT INTO dif_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Jendranguta mandru maruni nganala nganai, kulno Nulia patala nganai, ja kulno Nulia worarala nganai; ");
INSERT INTO dif_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Widla mandrujeli turara ngankala nganai marda watieli, nana kulno Nulia patala nganai, ja nana kulno Nulia worarala nganai. ");
INSERT INTO dif_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Tepi ngamanau, ngangau jura wata milkila, mina ditjini Kapara jurani wokarala nganai. ");
INSERT INTO dif_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Jenia ngujamanau! Punga ngamalkanietja milkila ngananani mina ditji tinkani kurikantji wokarai, nau tepi ngamala nganai ja ngandrawalkala nganai, nau wata pungani nunkanani wirinanto. ");
INSERT INTO dif_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Jendrania bakana jura ngankingaterianau! Ngangau ditji kulnuni, nina jura wata ngundrai, Kanaia Ngatamura wokarala nganai. ");
INSERT INTO dif_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Worana mili talku ja kiri nganai, nina kaparali najinajibanietja milini nunkanani kuranala, nulu tanangu buka ditji talkuni jinkinanto? ");
INSERT INTO dif_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Murlali pirna jenipara mili, nina kaparali nunkanali, nau wokarana tikanani, jeruja ngankanani mankamankala nganai. ");
INSERT INTO dif_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Morlalu ngani jurangu jatai: Nulu nina kapara kurala nganai nunkani poto pratjanani. ");
INSERT INTO dif_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Naupara mili madlentji ngarali nunkanali jatanani: Kapara ngakani kalkai wokarala, ");
INSERT INTO dif_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ja nulu woninani kamaneli nunkani nandrala, ja muntali nau tajinani ja tapanani tapanietjali jela: ");
INSERT INTO dif_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Jenipara milia kapara wokarala nganai miljaru kulnuni, nina nulu wata ngundrai, ja ditji kulnuni, nina nulu wata ngujamai, ");
INSERT INTO dif_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ja nina terti tjelapalkala nganai, ja nunkangu kalala nunkani kana jeljujelju jeribaka kurala nganai; naka tana pirna ngirikidala nganai ja mana katakatangala nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ngadani pariwilpaia milila ngameri marapratjana jeri nganala nganai, tanali praitji tanani manina wonti ja wapana wonti noangantjanipirnani mandurila. ");
INSERT INTO dif_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ja mara wora tanangundru kiri nganana wonti ja mara wora patipati. ");
INSERT INTO dif_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Patipatieli praitji tanani manina wonti, ja tanali wata gildi padakana wonti. ");
INSERT INTO dif_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Kirieli gildi manina wonti kokujeli tananali praitjanto. ");
INSERT INTO dif_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ngangau noangantjanipirna ngujawakaterina wonti, tana pratjana jindina wonti ju mukaturarana wonti. ");
INSERT INTO dif_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tinka tertini miritja pirna nganana wonti: „Mai, noangantjanipirna wokarai, wapanau nunkangu mandurila!“ ");
INSERT INTO dif_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Jendranguta jenipara ngameri pratjana jiritjina wonti, ja praitji tanani tjirkatjirkana wonti. ");
INSERT INTO dif_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Tana patipati kirini jatana wonti: „Ngaianingu jinkianau jurani gildindru, ngangau praitji ngaianani palila wapaia.“ ");
INSERT INTO dif_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Kirieli kalabana wonti ja jatana wonti: „A‐ai, pani‐riati ngaianingu ja jurangu; wapanau jinkimalinietjani ja jurangu burungankanau.“ ");
INSERT INTO dif_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Tana matja wapana burungankala, noangantjanipirna wokarana wonti; ja tana matja ngankingaterina, nunkangunto noapatamalini bukaia wirina wonti, ja tanali mana nguru ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ngadani bakana ngameri nguru wokarana wonti ja jatana wonti: „Kaparajai, Kaparajai, ngaianingu wilpa ngankau!“ ");
INSERT INTO dif_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Nulu kalabana wonti ja jatana wonti: „Morlalu ngani jurangu jatai: Ngato jurana wata ngujamai.“ ");
INSERT INTO dif_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jendrania tepi ngamanau, ngangau jura miljaru ja ditji wata ngujamai, nunkangupini Kanaia Ngatamura wokarala nganai.");
INSERT INTO dif_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Worderu kana kulno, nau jertapaterina wonti mita tulaia palkala, mili nunkani karkana wonti, ja tanangu poto nunkani jinkina kurana wonti. ");
INSERT INTO dif_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ja kulnuni nulu mardatandra pirna mara wora, ja kulnuni mandru, ja kulnuni kulno jinkina wonti, tanani ngurula pilki ja pilkindru; ja nau nurujeli palkana wonti. ");
INSERT INTO dif_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Naupini, nulu mardatandra pirna mara wora matja manina, wapana wonti ja jinkimalina wonti, ja nulu mardatandra pirna mara wora morla patana wonti. ");
INSERT INTO dif_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nunkangu jeribaka bakana nulupini, nulu mandru matja manina, mandru morla patana wonti. ");
INSERT INTO dif_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Naupini, nulu kulno matja manina, wapana wonti, ja kutu bakuna wonti mitani, ja kaparaia nunkanaia mardatandra kurukurumalkana wonti. ");
INSERT INTO dif_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ditji marapuni ngadani tanapini milia kapara tikana wonti, ja tanangunto windamana wonti. ");
INSERT INTO dif_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ja naupini, nulu mardatandra pirna mara wora maninala, wokarana wonti ja mardatandra pirna mara wora morla padakana wonti, ja jatana wonti: „Kaparajai, mardatandra pirna mara wora jundru ngakangn jinkinala; najiau, mardatandra mara wora morla ngato tanangu ngokana warai.“ ");
INSERT INTO dif_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Kapara nunkani nunkangu jatana wonti: „Matja, jidni mili ngumu ja talku, jidni talku nganana warai ngaljengaljeni, ngato jidnana kapara kurala nganai marapuni: Wiriau Kaparaia jinkanaia mankinani.“ ");
INSERT INTO dif_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Bakana naupini, nulu mardatandra pirna mandru maninala, wokarana wonti ja jatana wonti: „Kaparajai, mardatandra pirna mandru jundru ngakangu jinkinala; najiau, mardatandra pirna mandru morla ngato pudlangu ngokana warai.“ ");
INSERT INTO dif_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Kapara nunkani nunkangu jatana wonti: „Matja, jidni mili ngumu ja talku, jidni talku nganana warai ngaljengaljeni, ngato jidnana kapara kurala nganai marapuni: Wiriau Kaparaia jinkanaia mankinani.“ ");
INSERT INTO dif_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Bakana naupini, nulu mardatandra kulno maninala, wokarana wonti ja jatana wonti: „Kaparajai, ngato jidna ngujamanala, jidni kana ngurunguru nganai, jundru naka kampai, woderi jundru wata jaupanala, ja mapai, woderi jundru wata tarauanala; ");
INSERT INTO dif_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ja ngangau ngani japali, ngani wapanala ja mardatandra pirna kulno jinkani mitani kurukurumalkanala: Najiau ninkida jinkani.“ ");
INSERT INTO dif_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Kaparali nunkanali kalabana wonti ja nunkangu jatana wonti: „Jidni mili madlentji ja nguja, jidni milkila ngananala, ngato naka kampai, woderi ngato wata jaupanala, ja mapai, woderi ngato wata tarauanala; ");
INSERT INTO dif_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Jundru mardatandra ngakani mardatandrakaritjimalkanietjani jinkinanto, ja ngani wokaranani, ngato mardatandra ngakani kalalanto maninanto. ");
INSERT INTO dif_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Jeruja mardatandra pirna nunkangundru manianau, ja nunkangupini jinkianau, nulia mardatandra pirna marapratjana ngamalkai. ");
INSERT INTO dif_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ngangau nunkangu, nulu ngamalkai, tanali jinkila nganai, ja nulu morla marapu ngamalkala nganai; nunkangundru, nulu wata ngamalkai, tanali bakana jenia manila nganai, mina nulu ngamalkai. ");
INSERT INTO dif_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ja nina mili nguja ngalpuru pirnaia woranau; naka tana pirna ngirikidala nganai ja mana katakatangala nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Kanaia Ngatamura wokaranani pirnalani nunkanani ja angela kulikiri pratjana nunkangunto, jendranguta Nauja ngamana ngarila nganai pirnalaia nunkanaia ngamani pirini, ");
INSERT INTO dif_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ja tanali kana wolara warupoto nunkangu mapala nganai. Ja Nulia tanana puntibala nganai, worderu tjipi ngamalkanietjali tjipi puntibai tjipi ngaperandru, ");
INSERT INTO dif_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ja tjipi Nulia ngunarani nunkanani terkibala nganai, ja tjipi ngaperi worangantjuni. ");
INSERT INTO dif_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ngadani Kapara jatala nganai tanangu ngunarani nunkanani: „Kaparanau, jurana Ngaperali ngakanali jurakokai, ja mililu maratunka manianau, nina Nulia jurangu ngankingana wonti mita pantjimanandru. ");
INSERT INTO dif_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ngani mauali nganana warai, jura ngana jerto ngankana warai; ngani tertieli nganana warai, jura ngana kaljura ngankana warai; ngani tula nganana warai, jura ngana patana warai; ");
INSERT INTO dif_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ngani balu nganana warai, jura ngakangu kati widmana warai; ngani muntja nganana warai, jura ngakangu wokarana warai; ngani kanjangari pungani ngamana warai, jura ngakangu wirina warai.“ ");
INSERT INTO dif_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ngadani kana talkujeli nunkangu kalabala nganai ja jatala nganai: „Kaparajai, winta ngaiani jidna maua najina warai, ja jidna jerto ngankana warai? terti kara, ja jidna kaljura ngankana warai? ");
INSERT INTO dif_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Winta ngaiani jidna tula najina warai ja jidna patana warai? balu kara, ja jinkangu kati widmana warai? ");
INSERT INTO dif_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Winta ngaiani jidna muntja kara, kanjangari pungani kara najina warai ja jinkangu wokarana warai?“ ");
INSERT INTO dif_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ja kaparali kalabala nganai ja jatala nganai tanangu: „Morlalu ngani jurangu jatai: Mina jura ngankana warai ngakani ngatata wakawaka kulnuni, jenia jura ngakangu ngankana warai.“ ");
INSERT INTO dif_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ngadani Nauja bakana jatala nganai tanangu worangantjuni: „Wapanau ngakangundru, jura madlentji ngankanietja, ngurali turuja, nina matja ngankingana kutjini ja angelani nunkanani. ");
INSERT INTO dif_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ngani mauali nganana warai, ja jura ngana wata jerto ngankana warai; ngani tertieli nganana warai, ja jura ngana wata kaljura ngankana warai; ");
INSERT INTO dif_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ngani tula nganana warai, ja jura ngana wata patana warai; ngani balu nganana warai, ja jura ngakangu wata kati widmana warai; ngani muntja ja kanjangari pungani nganana warai, ja jura ngakangu wata wokarana warai.“ ");
INSERT INTO dif_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ngadani bakana tanali nunkangu kalabala nganai ja jatala nganai: „Kaparajai, winta ngaiani jidna najina warai maua kara, terti kara, tula kara, balu kara, muntja kara, kanjangari pungani kara, ja wata mili jinkani nganana warai?“ ");
INSERT INTO dif_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ngadani Nulia tanangu kalabala nganai ja jatala nganai: „Morlalu ngani jurangu jatai: Mina jura wata ngankana warai tanangundru wakawaka kulnuni jura ngakangu bakana wata ngankana warai.“ ");
INSERT INTO dif_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ja tanapini wapala nganai ngurali kalalaia; ja kana talku ngurali tepia.");
INSERT INTO dif_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ja jendranguta Jesujeli jenia jaura pratjana matja mudana, Nau milini nunkanani jatana wonti: ");
INSERT INTO dif_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Jura milkila, ditji mandruni Passa wokarai, ja tanali Kanaia Ngatamura ngulkujeli jinkila nganai, nina kunarkuni katibananto. ");
INSERT INTO dif_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Jendranguta Priesta pirna ja jaura jinkinietja ja kana wolaraia pinaru jurborina wonti Priesta pirnaia pirini, tala nunkani Kaiphas. ");
INSERT INTO dif_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ja tanali kurukuru warawarapana wonti Jesus kirieli patala ja nari ngankala. ");
INSERT INTO dif_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Tana jatana wonti: „Wata ditji pirnani, ngangau kana wolara juajuangaiati.“ ");
INSERT INTO dif_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesus Bethania ngurani Simon kana gambalaia pungani matja wokarana, ");
INSERT INTO dif_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Widla kulno nunkangu wokarana wonti, nandru Alabaster koko gildi ngumu pirnanto ngamalkana wonti, ja nunkangu mangatandrani nangana wonti, Nau kurlini ngamanani. ");
INSERT INTO dif_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Milieli nunkanali jenia najina, tana junkarina wonti ja jatana wonti: „Minani jenia tintana? ");
INSERT INTO dif_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ngangau nandruja jenia gildi kalala marapuja jinkinanto, ja wangiwangini bakujeli jinkinanto.“ ");
INSERT INTO dif_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesujeli jenia ngujamana, Nau tanangu jatana wonti: „Minandru jura nanaia widla jupai? nandruja ngankana ngumu ngakangu ngankana warai. ");
INSERT INTO dif_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ngangau milingeru jura kana wangiwangi jurangunto ngamalkai, ngana jura wata milingeru ngamalkai. ");
INSERT INTO dif_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nandruja ninapini gildi ngakangu palkuni nangana, nandruja jenia ngankana warai ngana wiribala todinaia ngakanaia. ");
INSERT INTO dif_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Morlalu ngani jurangu jatai: Woderi tanali paruparu ninapini ngantjani jaura kaukaubala nganai mita maruni, naka tanali bakana jatala nganai, mina nandruja ngankana warai, nanaia ngundrananto.“ ");
INSERT INTO dif_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Jendranguta marapratjana ja mandrundru kulno, tala nunkani Judas Ischariot, Priesta pirnaia wapana wonti. ");
INSERT INTO dif_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ja jatana wonti: „Mina kalala jura jertapateriai ngakangu jinkila, ngato nina jurangu wontawontala nganai?“ Tanali nunkangu mardatandra 30 jinkina wonti, ");
INSERT INTO dif_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Nunkangundruka ditjindru nulu milingeru wontjana wonti nina wontawontala. ");
INSERT INTO dif_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pulkurutjeribanibuka pani ditji ngoperalani mili wora Jesungu wokarana wonti ja nunkangu jatana wonti: „Wodaninkinaia jidni jertapateriai, ngaiani Passa kuparu jinkani ngankingananto tajila?“ ");
INSERT INTO dif_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Nau jatana wonti: „Nguraia wapanau nunkanguka, ja nunkangu jatanau: Ngujangujara jinkinietja jatai: Ditji ngakani karakara nganai, pungani jinkanani ngato milintali Passa kuparu tajila nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ja milieli jeruja ngankana wonti worderu Jesujeli tanangu jirijiribana warai, ja Passa kuparu ngankingana wonti. ");
INSERT INTO dif_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ja matja kalkaurarina, Nau kurlini ngamana ngarina wonti mili marapratjana ja mandrunto. ");
INSERT INTO dif_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ja tanali tajina, Nau jatana wonti: „Morlalu ngani jurangu jatai: Jurangundru kulnujeli ngana wontawontala nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ja tana ngaurongauro pirna pantjina wonti, ja wonina wonti pilki ja pilki nunkangu jatala: „Ngani nauja nganai Kaparajai?“ ");
INSERT INTO dif_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Nulu kalabana wonti ja jatana wonti: „Ngalinulu mara kurai pirrani, nulu ngana wontawontala nganai. ");
INSERT INTO dif_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Kanaia Ngatamura wapai, worderu nunkangundru dakanala parai; jakajai nunkangupini kanani, nulia Kanaia Ngatamura wontawontala nganai. Nunkangupini kanani ngumu ngananala, nauja wata dankanala.“ ");
INSERT INTO dif_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judas, wontawontanietjali nunkanali kalabana wonti ja jatana wonti: „Ngani nauja nganai Rabbi?“ Nau nunkangu jatana wonti: „Jidni matja jatai.“ ");
INSERT INTO dif_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Tanali tajinani, Jesujeli buka patana wonti ja ngurungutana wonti ja ninapini wokaribana wonti ja milini nunkanani jinkina wonti ja jatana wonti: „Patanimai ja tajianimai; naupini ngani palku nganai!“ ");
INSERT INTO dif_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ja Nulu koko patana wonti ja jurakokana wonti ja tanangu jinkina wonti ja jatana wonti: „Warupotujeli nunkangundru tapanimai! ");
INSERT INTO dif_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ngangau naupina ngani kumari nganai Testamenta marraia, ninapini ngani marapuja nangateriai madlentji kalingala. ");
INSERT INTO dif_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ngani jurangu jatai: Kararindru ngato wata morla nunkangupini waina nindri tandrandru tapala nganai nunkangupini ditjielu, ngato nina marra jurangunto tapala nganai Ngaperaia ngakanaia mililani.“ ");
INSERT INTO dif_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ja tana jurakokani wima matja jatana, tana maninindri mardawonpaia wapana wonti. ");
INSERT INTO dif_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ngadani Jesus tanangu jatana wonti: „Jura pratjaterina nunkangupini tinkani ngakangu kintjakintjarila nganai, ngangau dakanala parai: Ngato ngamalkanietja nandrala nganai, ja tjipi ngami piltjaru nganala nganai. ");
INSERT INTO dif_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ngadani ngani matja jiritjina warai, ngani jurangu ngopera Galilaiaia wapala nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petrulu kalabana wonti ja nunkangu jatana wonti: „Pratjana jinkangu kintjakintjarinani, ngani wata pota kulno jinkangu kintjakintjarila nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesus nunkangu jatana wonti: „Morlalu ngani jinkangu jatai: Nunkangupini tinkani windrila paia ngaperi jatananto, jundru ngana pota parkulu jedieli worarala nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petrus nunkangu jatana wonti: „Ngani bakana jinkangunto palinanto, ngato jidnana wata jedieli worarala nganai.“ Jeruja bakana mili pratjana jatana wonti. ");
INSERT INTO dif_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ngadani Jesus tanangunto piri kulnuni wokarana wonti, tala nunkani Gethsemane, ja milini jatana wonti: „Ninkida ngamana ngarianau, wolja ngani wapanani jerra ngatjila.“ ");
INSERT INTO dif_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ja Nulu Petrus ja Zebedäuni ngatamura wulana patana wonti, ja wonina wonti ngaurongauro ja japali nganala. ");
INSERT INTO dif_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ngadani Nau tanangu jatana wonti: „Ngani mungara ngaurongauro pirna nganai narielu; ninkida ngamanimai ja ngakangunto tepi ngamanimai!“ ");
INSERT INTO dif_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ja Nau ngalje morla wapana wonti ja mudlali woraterina wonti ja ngatjina wonti ja jatana wonti: „Ngakani Ngaperiai; jenia kantji pantjinani, naupini koko ngakangu wiringananto, wata jeruja worderu ngani jertapateriai, a‐ai, worderu jundru.“ ");
INSERT INTO dif_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ja Nau mili worangu tikana wonti, ja tanana muka mankamankana wonti ja Petrungu jatana wonti: „Mina, jura ngandandariai ngalje ngakangunto tepi ngamala? ");
INSERT INTO dif_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Tepi ngamanau ja ngatjianau, jura wontjanilani wiriati; mungara manju nganai ja palku waltowalto.“ ");
INSERT INTO dif_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nakaldra pota mandrula Nau wapana wonti ja ngatjina wonti ja jatana wonti: „Ngakani Ngaperiai; naupini koko ngandandarinani ngakangu wiringala, ngato ninaia tapananto; jeruja jertapaterina jinkani pantjiatimai.“ ");
INSERT INTO dif_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ja Nau tikana, Nulu tanana nakaldra muka mankamankana wonti; ngangau tana milki parina wonti. ");
INSERT INTO dif_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ja Nulu tanana worarana wonti ja nakaldra wapana wonti ja pota parkulula ngatjina wonti nakaldra jenia jaura jatana. ");
INSERT INTO dif_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ngadani Nau milini nunkanani tikana wonti ja tanangu jatana wonti: „Mukaturaranau ja ngara ngamanau! Mai, naupini ditji karakara nganai, ja tanali Kanaia Ngatamura madlentji marani ngulkujeli jinkila nganai. ");
INSERT INTO dif_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Terkakanau ngaiana wapananto! mai, nauwa wokaraila, nuluwa ngana wontawontai.“ ");
INSERT INTO dif_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ja Nau jenia jatanani, mai, Judas, marapratjana ja mandrundru kulno, wokarana wonti, ja nunkangunto kana wolara pirna kalti tirieli ja pitali Priesta pirnandru ja kana wolaraia pinarandru. ");
INSERT INTO dif_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Wontawontanietjali nunkanali tanangu malka jinkina wonti ja jatana wonti: „Worananina ngato manatapala nganai, Nauja nganai; ninaia patanimai!“ ");
INSERT INTO dif_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ja nurujeli nau Jesungu wokarana wonti ja jatana wonti: „Murlali nganamai, Rabbi!“ ja nina manatapana wonti. ");
INSERT INTO dif_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesus nunkangu jatana wonti: „Kamaneliai, minani jidni wokarai?“ Ngadani tana karakararina wonti ja Jesungu mara kurana pararana wonti ja nina patana wonti. ");
INSERT INTO dif_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ja mai, kulno tanangundru Jesungu jela, nguna warpipana wonti, ja mardakirra nunkani dukarana wonti, ja Priesta pirnaia mili kulno nandrana wonti, ja nina talpa wokaribana wonti. ");
INSERT INTO dif_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesus nunkangu jatana wonti: „Mardakirra jinkani nakaldra nunkani pirini widmana tikau; ngangau warletanali mardakirra patai, mardakirrali palila nganai. ");
INSERT INTO dif_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Jundru ngundrai, ngani karari ngandandariai Ngaperani ngakanani ngatjila, ja Nulia ngakangu angela morla marapu jinpananto legiona marapratjana ja mandruni? ");
INSERT INTO dif_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Worderu jaura wora morlalu pantjinanto, jeruja jenia pantjinanto?“ ");
INSERT INTO dif_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Nunkangupini ditjini Jesus wolarani jatana wonti: „Jura ngakangu dunkana warai watawatali maninietjani jeribaka mardakirrali ja pitali ngana patala; ditji marapuni ngani jurangunto ngamana warai Godaia pungani ngujangujara jinkina, ja jura ngana wata patana warai. ");
INSERT INTO dif_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Jenia pratjana pantjiai, Prophetaia jaura morlalu pantjinanto.“ Ngadani mili pratjana nunkangundru puntina wonti ja japa mindrina wonti. ");
INSERT INTO dif_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ja tanali Jesus patana wonti ja nina Kaiphasangu Priesta pirnaia wapalkana wonti, wodajeri jaura jinkinietja ja pinaru wora jurborina wonti. ");
INSERT INTO dif_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petrus nunkangu woritandru karipaterina wonti Priesta pirnaia pungajelu; ja nau wirina wonti, ja milini jela ngamana ngarina wonti najila, mina pantjila nganai. ");
INSERT INTO dif_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Priesta pirnali ja pinaru worali ja kapara pratjanali jedi jaura wontina wonti Jesungu, nina nari ngankala. ");
INSERT INTO dif_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ja tanali panila mankamankana wonti. Ja jedikantji marapu wokarana wonti, ja tanali panila mankamankana wonti. Ngadani jedikantji mandru wokarana wonti, ");
INSERT INTO dif_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ja jatana wonti: „Naupini jatana warai: Ngani ngurunguru nganai, Godaia punga wokaribala ja ditjini parkulani nina nakaldra wotila.“ ");
INSERT INTO dif_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ja Priesta pirna terkakana wonti ja jatana wonti nunkangu: „Jundru panila kalabai mina pudlalia morlalu kurai jinkangu?“ ");
INSERT INTO dif_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesus ngapu nganana wonti. Ja Priesta pirnali kalabana wonti ja nunkangu jatana wonti: „Ngato jinkangu jaura morlalu jakalkai Goda tepini, jidni ngaianingu jatananto, jidni Christus Godaia Ngatamura nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesus nunkangu jatana wonti: „Jidni matja jatai. Morlalu ngani jurangu jatai: Kararindru jura najila nganai Kanaia Ngatamura ngurulaia ngunarani ngamanani, ja pariwilpalali talara palkujeli wokaranani.“ ");
INSERT INTO dif_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ngadani Priesta pirnali kati nunkani purana wonti ja jatana wonti: „Nulia Goda ngirkibana warai; minani ngaiani jaura morlalu morla ngamalkananto? Mai, karari jura ninaia Goda ngirkibanani ngarana warai. ");
INSERT INTO dif_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Mina jura ngundrai?“ Tanali kalabana wonti ja jatana wonti: „Nauja palinanto nari.“ ");
INSERT INTO dif_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ngadani tanali ngaltja nunkangu mudlani worana wonti, ja nina marali nandrana wonti; ja palpali nina mara mokujeli nandrana wonti, ");
INSERT INTO dif_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ja jatana wonti: „Ngaianingu morlalu jatamai Christujai, warlenulu jidna nandrana warai?“ ");
INSERT INTO dif_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Petrus palarani ngamana wonti piri tertini, ja nunkangu widla mili wokarana wonti ja jatana wonti: „Jidni bakana Jesungunto Galilaiala nganana warai!“ ");
INSERT INTO dif_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Nau jedina wonti pratjanani ja jatana wonti: „Ngani ko, mina jidni jatai.“ ");
INSERT INTO dif_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Nau dunkana manani, nina kulno ngurujeli najina wonti ja tanangu naka jatana wonti: „Bakana naupini Jesungu Nazaretalani jela nganana warai.“ ");
INSERT INTO dif_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ja nau nakaldra jedina wonti ja jaura morlalu jatana wonti: „Ngato nina kana wata ngujamai.“ ");
INSERT INTO dif_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ngalje ngadani tana naka terkana wokarana wonti ja Petrungu jatana wonti: „Morlalu, bakana jidni tanangundru kulno nganai, ngangau talieli jinkanali jidni wondrai.“ ");
INSERT INTO dif_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Jendranguta nulu wonina wonti madlentji jataterila, ja jaura morlalu jatana wonti: „Ngato ninapini kana wata ngujamai.“ Ja nurujeli paia ngaperi jatana wonti. ");
INSERT INTO dif_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ja Petrulu Jesuni jaura ngundrana wonti, nau nunkangu jatala wiri: „Windrila paia ngaperi jatananto, jundru ngana pota parkulu jedieli worarala nganai.“ Ja nau dunkana wonti ja burkali pirna jindrana wonti. ");
INSERT INTO dif_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ja matja nguramarana, Priesta pirnali ja kana wolaraia pinaru pratjanali ngankamalina wonti Jesungundru, nina nari ngakala. ");
INSERT INTO dif_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ja tanali nina dupudupu ngankana wonti ja nina wapalkana wonti ja nina Pontiungu Pilatungu mitaia kapakaparani jinkina wonti. ");
INSERT INTO dif_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ngadani Judasali wontawontanietjali nunkanali matja najina, tanali nunkangu kalala jinkila nganai, nulu burkali mardatandra 30 Priesta pirnani ja pinaru worangu jinkina tikana wonti, ");
INSERT INTO dif_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ja jatana wonti: „Ngato madlentji ngankana warai, ngangau ngato kumari kulikiri wontawontana warai.“ Tana jatana wonti: „Mina jenia ngaianingu? Muntali najiau!“ ");
INSERT INTO dif_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ja nulu tanana mardatandra Godaia pungani worana wonti ja wapana wonti ja waruwarukijiribaterina wonti. ");
INSERT INTO dif_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Priesta pirnali tanana mardatandra patana wonti ja jatana wonti: „Wata talku nganai, tananaia Godaia pungaia kokuni worala, ngangau jenia kumari mardatandra nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Tana matja ngankamalina, tanali tanangundru bulurukoko ngankanietjaia mita burungankana wonti tula todila. ");
INSERT INTO dif_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Jendrangundruja tanali nina mita „kumari‐mita“ dikai kararilu. ");
INSERT INTO dif_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Jendranguta morlalu pantjina wonti mina Prophetali Jeremiasali kaukaubana wonti nau jatana wonti: „Ja tanali mardatandra 30 manina wonti burungankani kalala nunkangu, worana tanali Juda kana ngatamurandru burungankanala, ");
INSERT INTO dif_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ja tanali tanana jinkina wonti bulurukoko ngankanietjaia mitani worderu Kaparali ngakangu jirijiribana wonti.“ ");
INSERT INTO dif_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesus kapakapara mudlani terkana wonti. Ja kapakaparali nina jakalkana wanti ja jatana wonti: „Jidni Juda kanaia Kapara nganai?“ Jesus nunkangu jatana wonti: „Jidni matja jatai.“ ");
INSERT INTO dif_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ja Priesta pirna ja pinaru wora nunkangu ngulkuterkanani, Nulu wata kalabana wonti. ");
INSERT INTO dif_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ngadani Pilatus nunkangu jatana wonti: „Jundru wata ngarai, worderuntja jaurali tana jinkangundru ngulkuterkai?“ ");
INSERT INTO dif_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ja Nulu nunkangu wata jaura kulno kalabana wonti, jeruja bakana kapakapara pirna ngaruparana wonti. ");
INSERT INTO dif_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ditji pirnani kapakaparali milingeru wolarani kanjangarila kulno kurakana wonti, worananina tanali ngantjana wonti. ");
INSERT INTO dif_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Tanali jendranguta madlentji ngankanietja pirna kanjangari pungani ngamalkana wonti, tala nunkani Barabbas. ");
INSERT INTO dif_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Tana matja jurborina, Pilatus tanangu jatana wonti: „Worana jura ngantjai, nina ngato jurangu kurakananto, Barabbas kara, Jesus kara, nina tanali dikai Christus?“ ");
INSERT INTO dif_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ngangau nau milkila nganana wonti, tanali nina kuterilkanandru ngulkuterkana warai. ");
INSERT INTO dif_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Nau kalala jinkini pirini matja ngamana ngarina, noajeli nunkanali nunkangu jinpana wonti ja jatana wonti: „Panila jundru nunkangupini kana talkuni ngankamai; ngangau ngato karari ngapitjali nunkangundru pirna ketjaketjana warai.“ ");
INSERT INTO dif_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Priesta pirnali ja pinaru wolarali kana wolara winpana wonti, tanali Barabbangundru ngatjinanto, ja Jesus nari ngankananto. ");
INSERT INTO dif_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kapakaparali kalabana wonti ja tanangu jatana wonti: „Worana pudlangundru jura ngantjai, wodanina ngato pudlangundru kurakananto?“ Tana jatana wonti: „Barabbas.“ ");
INSERT INTO dif_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatus tanangu jatana wonti: „Mina ngato Jesungu ngankananto, nina tanali dikai Christus?“ Pratjana nunkangu jatana wonti: „Ninaia kunarkuni katibamai!“ ");
INSERT INTO dif_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Kapakaparali jatana wonti: „Mina madlentji Nulia ngankana warai?“ Tana morla maritjina wonti ja jatana wonti: „Ninaia kunarkuni katibamai!“ ");
INSERT INTO dif_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilatulu najina, jenia baku nganai, tana windri morla juajuangana wonti, nulu ngapa manina wonti ja mara kulirkaterina wonti kana wolara mudlani ja jatana wonti: „Ngani madlentji pani nganai nunkangu kana talku kumarani; muntali najianau!“ ");
INSERT INTO dif_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ja kana wolarali kalabana wonti ja jatana wonti: „Kumari nunkani ngaianingu ja kupani ngaianinani wokaraiatimai!“ ");
INSERT INTO dif_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ngadani nulu tanangu Barabbas kurakana wonti. Ja nulu jirijiribana wonti Jesus nandrananto, ja nina jinkina wonti kunarkuni katibala. ");
INSERT INTO dif_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ngadani kapakaparaia mili wolarali Jesus kapakaparaia pungani wapalkana wonti, ja nunkangu mili pratjana jurborilkana wonti. ");
INSERT INTO dif_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ja tanali kati nunkani dukarana wonti, ja nunkangu kati maralje widmana wonti. ");
INSERT INTO dif_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ja tanali dilka pirapira dakana wonti, ja nunkangu mangatandrani kurana wonti, ja pita nunkangu mara ngunarani jinkina wonti, ja nunkangu pantjaterkana ngarina wonti ja nina ngirkibana wonti ja jatana wonti: „Murlali nganamai, Juda kanaia Kaparajai!“ ");
INSERT INTO dif_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ja tanali nunkangu ngaltja worana wonti, ja pita manina wonti, ja nina mangatandra nandrana wonti. ");
INSERT INTO dif_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ja tanali nina matja ngirkibana, tanali kati maralje nunkangundru dukarana wonti, ju kati pilki nunkani nunkangu widmana wonti, ja nina wapalkana wonti kunarkuni katibala. ");
INSERT INTO dif_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Tana dunkana, tanali kana kulno Kyrenala mankamankana wonti, tala nunkani Simon; nina tanali watawatali patana wonti nulu kunarku nunkani waltananto. ");
INSERT INTO dif_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ja tana wokarana wonti piri kulnuni, Golgatha tala nunkani, jenia wondrai: „Mangatandra piri.“ ");
INSERT INTO dif_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ja tanali nunkangu kaldri puratandrali ngokana jinkina wonti tapananto; ja Nulu jenia wontjana, Nulu wata ngantjana wonti tapala. ");
INSERT INTO dif_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Tanali nina matja kunarkuni katibana, tanali kati nunkani puntibana wonti wontjani malkali: Ngangau Prophetaia jaura morlalu pantjinanto: „Tanali kati ngakani puntibana wonti, ja ngakani kati pirnani tanali wontjani malka worana wonti.“ ");
INSERT INTO dif_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ja tana ngamana ngarina wonti ja nina najinajibana wonti. ");
INSERT INTO dif_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ja tanali nunkangu mangatandrani miri jaura kurana wonti, minandru Nau palinanto jeruja: „Naupini Jesus Juda kanaia Kapara nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ngadani tanali nunkangu jela watawatali maninietja mandru kunarkuni katibana wonti, kulno nunkangu ngunarani, ja kulno nunkangu worangantjuni. ");
INSERT INTO dif_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Wiringanietjali nina ngirkibana wonti ja mangatandra walkina wonti, ");
INSERT INTO dif_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ja jatana wonti: „Jundru Godaia punga tampuribanietja ja wotinietja ditjini parkulani, jidni munta kulkateriau! jidni Godaia Ngatamura ngananani, kunarkundru ngariamai!“ ");
INSERT INTO dif_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Tanali jeribaka nina bakana Priesta pirnali ja jaura jinkinietjali ja pinarali ngirkibana wonti ja jatana wonti: ");
INSERT INTO dif_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","„Kana nguru Nulia kulkana warai, ja muntali Nauja ngandandariai kulkaterila; Nauja Israelani Kapara ngananani, Nauja karari kunarkundru ngariatimai, ja ngaiana nunkangu morlalu ngundrala nganai. ");
INSERT INTO dif_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nulia Godani morlalu ngundrana warai; Nulia karari ninaia kurakaiatimai, Nulia ninaia ngantjanani; ngangau Nauja jatana warai: Ngani Godaia Ngatamura nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Tanangu jeribaka nina bakana watawatali maninietjali ngirkibana wonti, pudla nunkangu jela kunarkuni parana wonti. ");
INSERT INTO dif_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Todandru ngalpuru pirna pantjina wonti mita maruni ditji kunarkujelu. ");
INSERT INTO dif_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ditji kunarkuni Jesus ngaiala pirnali maritjina wonti ja jatana wonti: „Eli, Eli, lama sabachthani?“ jenia wondrai: „Godajai ngakani, Godajai ngakani; minandru jundru ngana worarana warai?“ ");
INSERT INTO dif_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Palpa tanangundru naka terkana, ja jenia ngarana, jatana wonti: „Nulupini Elias karkai.“ ");
INSERT INTO dif_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ja nurujeli tanangundru kulno mindrina wonti ja miritipa manina wonti, ja nina kaldrieli ngapatjanka ngankana wonti, ja nina pitani widmana wonti, ja nunkangu jinkina wonti tapananto. ");
INSERT INTO dif_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kana nguru jatana wonti: „Worani; ngaiana najinanto Elias kara wokarala nganai ninaia kulkala.“ ");
INSERT INTO dif_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesus nakaldra ngaiala pirnali maritjina wonti ja palina wonti. ");
INSERT INTO dif_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ja mai, kati pirna Godaia pungani puraterina wonti terti mirindru ngarinalujelu; ja mita wiltjiwiltjina wonti, ja marda taldra tjelapalkaterina wonti. ");
INSERT INTO dif_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ja nariwonpa wilparina wonti, ja kana kulikiria palku marapu, tana matja turarana, jiritjina wonti. ");
INSERT INTO dif_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ja nunkani tepi terkakani ngadani, tana narikutundru dunkana wonti, ja ngura kulikiria wapana wonti, ja kana marapuni wondraterina wonti. ");
INSERT INTO dif_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ja juljaiakapara, ja tana nunkangunto Jesus najinajibana, japali pirna pantjina wonti, tanali mita wiltjiwiltjinani najina wonti, ja jenia, mina pantjina warai, ja jatana wonti: „Morlalu Naupini Godaia Ngatamura nganana warai.“ ");
INSERT INTO dif_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Naka bakana widla marapu nganana wonti, tanali woritandru jenia najina wonti; tana Jesungu Galilaiandru karipaterina warai mili nunkani nganala. ");
INSERT INTO dif_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Tanangundru nganana wonti Maria Magdalala, ja Maria, Jakobuni ja Joseni ngandri, ja Zebedäuni ngatamuraia ngandri. ");
INSERT INTO dif_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Matja kalkaurarina, kana poto pirna Arimathiala, tala nunkani Joseph, wokarana wonti; nau bakana Jesuni mili nganana wonti. ");
INSERT INTO dif_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nau Pilatungu wapana wonti, ja Jesuni palkuni ngatjina wonti; ngadani Pilatus jirijiribana wonti nunkangu palku jinkinanto. ");
INSERT INTO dif_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ja Josephali palku manina wonti, ja nina kati kulikirieli karana wonti, ");
INSERT INTO dif_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ja nina narikutu marrani nunkanani kurana wonti, nina nulu marda taldrani bakuna wonti; ja nulu marda pirna narikutuja manani tirimalkana wonti ja wapana wonti. ");
INSERT INTO dif_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Naka Maria Magdalala nganana wonti, ja Maria kulno, pudla nariwonpankari ngamana wonti. ");
INSERT INTO dif_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ditjini kulnuni, ngankingani ditjini ngadani, Priesta pirna ja Pharisaia Pilatungu jurlborina wonti, ");
INSERT INTO dif_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ja jatana wonti: „Kaparajai, ngaiani mangatandra wilpariai, Naupini karkarkanietja nunkani tepia ditjini jatana paraia: Ditjini parkulani ngani jiritjila nganai. ");
INSERT INTO dif_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Jirijiribamai, tanali nariwonpa ditjini parkulanilu najinajibananto, mili nunkani wokaraiati ja nina kurieli maniati ja kana wolarani jataiati: Nauja narindru jiritjina warai; ja mudani jedibala morla tjautjau pantjiati ngoperalani.“ ");
INSERT INTO dif_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatus tanangu jatana wonti: „Ninkida jura najinajibanietja ngamalkai; wapanau, ja nina ngumu ngamalkanau, worderu jura ngujamai.“ ");
INSERT INTO dif_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Tana wapana wonti ja nariwonpa ngumu ngamalkana wonti, ja mardani kandrieli malka kurana wonti najinajibanietjali jelali. ");
INSERT INTO dif_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabbath ditji matja mudana, ja nguramarana Godaia ditjini, Maria Magdalala ja Maria nguru wokarana wonti nariwonpa najila. ");
INSERT INTO dif_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ja mai, mita pirna wiltjiwiltjina wonti; ngangau Kaparaia angela pariwilpandru ngarina wonti, ja marda manandru tirimalkana wonti, ja nunkangupini miri ngamana ngarina wonti. ");
INSERT INTO dif_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nau mudla talara praitji jeribaka nganana wonti, ja kati nunkani bulu, taleri jeribaka. ");
INSERT INTO dif_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Najinajibanietja nunkangundru japali ngarrana wonti, ja nari jeribaka nganana wonti. ");
INSERT INTO dif_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Angelali widlani kalabana wonti ja jatana wonti: „Wata japali nganalumai; ngangau ngani milkila, judla Jesus wontiai, Nau kunarkuni palina. ");
INSERT INTO dif_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nau wata ninkida nganai; ngangau Nau tepi terkakana warai, worderu Nau jatana paraia. Kaparalumai, ja najialumai piri, wodajeri Kapara parana warai, ");
INSERT INTO dif_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ja nurujeli wapalumai, ja milini nunkanani jatalumai: Nau narindru tepi terkakana warai; ja mai, Nau jurangu ngopera wapala nganai Galilaia mitaia, naka jura nina najila nganai. Mai, ngani jenia judlangu jatana warai.“ ");
INSERT INTO dif_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ja pudla nurujeli narikutundru wapana wonti japali pirna ja mankinali, ja mindrina wonti jenia milini nunkanani kaukaubala. ");
INSERT INTO dif_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Pudla wapanani jenia milini nunkanani kaukaubala, mai, Jesus pudlangu mandurina wonti ja jatana wonti: „Murlali nganalumai!“ ja pudla nunkangu wokarana wonti ja nina tidna patana wonti ju nunkangu pantjaterkana ngarina wonti. ");
INSERT INTO dif_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ngadani Jesus pudlangu jatana wonti: „Wata japali nganalumai; a‐ai, wapalumai ja jenia ngatatani ngakanani kaukaubalumai; ngangau tana Galilaiaia wapananto, ja naka tanali ngana najila nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Pudla matja wapana, mai, najinajibanietja palpa ngurani wokarana wonti ja Priesta pirnani kaukaubana wonti pratjana, mina pantjina warai. ");
INSERT INTO dif_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ja tana, ja pinaru wora matja mapaterina ja jaura ngankamalina, tanali najinajibanietjani mardatandra marapu jinkina wonti, ");
INSERT INTO dif_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ja jatana wonti: „Jatanau: Mili nunkani tinkani wokarana warai, ja nina kurieli manina warai, ngaiani turaranani. ");
INSERT INTO dif_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ja jenia kapakaparali ngaranani, ngaiani nina murlali daudauala nganai, ja jurana nunkangu murlali ngankala nganai.“ ");
INSERT INTO dif_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tanali mardatandra manina wonti, ja jeruja ngankana wonti, worderu tanali ngujangujara manina warai. Ja Juda kanali jenia kaukaubijiribamalina wonti kararielu. ");
INSERT INTO dif_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Tana mili marapratjana ja kulno Galilaiaia wapana wonti nunkangupini mardawonpaia, wodajeri Jesujeli tanangu jirijiribanala. ");
INSERT INTO dif_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Tanali nina najina, tana nunkangu pantjaterkana ngarina wonti; ja palpa mangangankana wonti. ");
INSERT INTO dif_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ja Jesus tanangu wokarana wonti ja kaukaubana wonti ja jatana wonti: „Nulia ngurula pratjana ngakangu jinkina wonti pariwilpani ja mitani. ");
INSERT INTO dif_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Jeruja wapanau, ja kana wolara warupoto mili ngankanau, ja tanana multibanau Ngaperaia ja Ngatamuraia ja Jaolaia kulikiria talani. ");
INSERT INTO dif_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ja tanangu ngujangujara jinkianau pratjana ngamalkala, mina ngato jurangu jirijiribanala. Ja mai, ngani jurangunto nganala nganai ditjini warupotuni mita mudanajelu.“ ");
INSERT INTO dif_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jesuni Christuni Godaia Ngatamuraia wonini ngantjani jaura. ");
INSERT INTO dif_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Worderu Jesaiasani Prophetaia dakanala parai: „Mai, ngato angela ngakani mudlani jinkanani ngopera jinpai, nulu palto jinkani jinkangu ngankijiribingala nganai. ");
INSERT INTO dif_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Karkanietjaia ngaiala pitarani parai: Kaparaia palto ngankinganimai, ja tidna palto nunkani talku ngankanimai!“ ");
INSERT INTO dif_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Johannes terkakana wonti ja multibanila jinkina wonti pitarani, ja madlentjandru karitjimalkani multibanila kaukaubana wonti madlentji kalingala. ");
INSERT INTO dif_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ja nunkangu dunkana wonti Judaiala pratjaterina ja Jerusalemala; ja nulu tanana multibana wonti Jordan kaiarani, ja tanali madlentji tanani talku dikana wonti. ");
INSERT INTO dif_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Johannili kati Camuli njurdu ja dala kapani nunkanani ngamalkana wonti, ja buka nunkani palaparu ja pitjambu nganana wonti. ");
INSERT INTO dif_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ja nulu ngujangujara jinkina wonti ja jatana wonti: „Ngakangu ngadani kulno wokarala nganai, Nau morla ngurunguru nganai ngakangu; nunkangu ngani wata talku nganai buruna ngarila nunkani jinka tidnaputandru dukarala. ");
INSERT INTO dif_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ngato jurana ngapali multibai, ja Nulu jurana Jaola kulikirieli multibala nganai.“ ");
INSERT INTO dif_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ja jendranguta Jesus Nazaretandru Galilaiani wokarana wonti, ja Johanningundru multibanila manina wonti Jordan kaiarani. ");
INSERT INTO dif_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ja nurujeli ngapandru dunkana tarana, nulu pariwilpa piririnani najina wonti, ja Jaola mulapara jeribaka nunkangu ngarinani. ");
INSERT INTO dif_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ja ngaiala pariwilpandru pantjina wonti: „Jidni Ngatamura ngantjalu ngakani nganai, jinkangu ngani murlah nganai.“ ");
INSERT INTO dif_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ja nurujeli Jaolali nina pitaraia tertubana wonti. ");
INSERT INTO dif_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ja Nau naka pitarani pira kulno ja ditji marapratjana nganana wonti, ja kutjieli nina wontjana wonti, ja Nau nganti jampali jela nganana wonti, ja angela wora mili nunkani nganana wonti. ");
INSERT INTO dif_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Tanali Johannes kanjangari pungani matja widmana, Jesus Galilaiani wokarana wonti ja ngantjani jaura Godaia mililandru kaukaubana wonti, ");
INSERT INTO dif_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ja jatana wonti: „Ditji matja wokarana warai, ja Godaia milila karakara nganai. Madlentjandru karitjianau, ja ngantjani jaura morlalu ngundranau!“ ");
INSERT INTO dif_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Nau Galilaia pantuni wirarina wonti, ja Nulu Simon ja Andreas ngatata nunkani najina wonti, pudlali jama pantuni worana wonti; ngangau pudla paru maninietja nganana wonti. ");
INSERT INTO dif_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ja Jesus pudlangu jatana wonti: „Kaparalumai, ja ngakangu karipaterialumai, ngato judlana kana maninietja ngankala nganai.“ ");
INSERT INTO dif_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ja nurujeli pudlali jama worarana wonti ja nunkangu karipaterina wonti. ");
INSERT INTO dif_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ja Nau nakandru morla wapana wonti, ja Nulu Jakobus Zebedäuni ngatamura, ja Johannes ngatata nunkani, botani jama karpanani najina wonti. ");
INSERT INTO dif_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ja nurujeli Nulu pudlana karkana wonti; ja pudlali Zebedäus ngaperi pudlani ja mili nunkani botani worarana wonti, ja pudla wapana wonti ja nunkangu karipaterina wonti. ");
INSERT INTO dif_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ja tana Kapernaum ngurani wirina wonti. Ja nurujeli Nau Sabbat ditjini jaura pungani wirina wonti ja ngujangujara jinkina wonti. ");
INSERT INTO dif_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ja tana ngujangujarani nunkanani pirna ngaruparana wonti; ngangau Nulu ngurungurujeli tanangu ngujangujara jinkina wonti, ja wata jaura jinkinietjali jeribaka. ");
INSERT INTO dif_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ja jaura pungani tananani kana kulno kutji murumurunto nganana wonti, ja nau maritjina wonti, ");
INSERT INTO dif_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Ja jatana wonti: „Burru, mina ngaianingu ja jinkangu, Jesujai Nazarenalajai, jidni wokarana warai ngianina teribala? Ngato jidna ngujamai, worana jidni nganai: Godaia kulikiri!“ ");
INSERT INTO dif_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesujeli nina daudauana wonti ja jatana wonti: „Ngapuriau, ja nunkangundru dunkau!“ ");
INSERT INTO dif_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ja kutji murumurujeli nina diadialkana wonti, ja nau ngaiala pirnali maritjina wonti ja nunkangundru dunkana wonti. ");
INSERT INTO dif_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ja pratjana pirna ngaruparana wonti, jeruja tana jakalkijiribamalina wonti ja jatana wonti: „Mina jenia nganai? Mina naupini ngujangujara marra nganai? Ngangau Nulu ngurungurujeli bakana kutji murumuruni jirijiribai, ja tana nunkangu pankiai.“ ");
INSERT INTO dif_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ja nurujeli pinti nunkangundru karitjina wonti wontikana wonti Galilaiani paruparu. ");
INSERT INTO dif_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ja nurujeli tana jaura pungandru dunkana wonti, ja Simon ja Andreani pungani wirina wonti, Jakobus ja Johannes jelalu. ");
INSERT INTO dif_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simonani paiara muntja turuturu parana wonti; ja nurujeli tanali nunkangu nankangundru kaukaubana wonti. ");
INSERT INTO dif_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ja Nau wokarana wonti, ja nana terkibana tarana wonti, ja nana mara patana wonti; ja nurujali muntja turuturujeli nana worarana wonti, ja nani tanangu mili nganana wonti. ");
INSERT INTO dif_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Matja kalkaurarina, ja ditji wirina, tanali nunkangu muntja pratjana ja kana kutjinto jurborilkana wonti. ");
INSERT INTO dif_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ja ngurala pratjana mapaterina wonti manani. ");
INSERT INTO dif_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ja Nulu marapu, tanali muntja pilki ja pilki ngamalkana wonti, tepi ngankana wonti; ja Nulu kutji madlentji marapu dunkalkana wonti, ja Nulu kutjini wata manuni kurana wonti jatananto, ngangau tanali nina ngujamana wonti. ");
INSERT INTO dif_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ja nguramarani kuperi Nau jiritjina wonti ja pitaraia wapana wonti, ja naka Nau ngatjina wonti. ");
INSERT INTO dif_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ja Simon, ja tana nunkangunto, nunkangu wapantina wonti. ");
INSERT INTO dif_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ja tanali nina matja mankamankana, tana nunkangu jatana wonti: „Marapujeli jidna wontiai.“ ");
INSERT INTO dif_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ja Nau tanangu jatana wonti: „Ngaiana bakana ngura nguraia wapananto, ngangau ngato bakana naka jaura kaukaubananto; ngangau jendrania ngani wokarana wonti.“ ");
INSERT INTO dif_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ja Nulu jaura pungani tananani ngujangujara jinkina wonti Galilaiani paruparu, ja Nulu kutji dunkalkana wonti. ");
INSERT INTO dif_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ja kana kulno gambanto nunkangu wokarana wonti, nau nunkangu ngatjina wonti ja nunkangu pantjerterkana ngarina wonti ja nunkangu jatana wonti: „Jidni jertapaterinani, jidni ngurunguru nganai ngana kulirkala.“ ");
INSERT INTO dif_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesus nunkangu kalumiltjamiltjarina wonti, ja Nau mara warpina wonti ja nina karakarana wonti ja nunkangu jatana wonti: „Ngani jertapateriai, kulikiri nganamai!“ ");
INSERT INTO dif_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ja Nau jeruja jatana, nurujeli gamba nunkangundru puntina wonti, ja nau kulikiri pantjina wonti. ");
INSERT INTO dif_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ja Nulu nina daudauana wonti, ja nina nurujeli narrana wonti, ");
INSERT INTO dif_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Ja nunkangu jatana wonti: „Mai, wata kanani jenia kaukaubau, a‐ai, wapau ja Priestani wondrateriau, ja jinkani kulikirindru nina poto jinkiau, mina Mosili jirijiribana wonti, tanangu malka nganananto.“ ");
INSERT INTO dif_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nau matja dunkana, nulu wonina wonti jenia pirna kaukaubala ja jaura maruribala; jeruja Nau ngandandarina wonti tinkari ngura kulnuni wirila, a‐ai, Nau windri palarani pitarani nganana wonti, ja tana nunkangu paruparundru wokarana wonti. ");
INSERT INTO dif_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ja nakaldra ditji palpani ngadani Nau Kapernaum ngurani wirina wonti; ja tanali ngarana wonti Nau pungani ngamai. ");
INSERT INTO dif_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ja nurujeli marapu jurborina wonti, jeruja bakana naupini piri manani karakara tanangu wuldru nganana wonti; ja Nulu tanangu jaura kaukaubana wonti. ");
INSERT INTO dif_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ja tana nunkangu wokarana wonti, ja nunkangu kana tjunduru wapalkana wonti, nina kana mandru ja mandrujeli padakana wonti. ");
INSERT INTO dif_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ja ngangau tana ngandandarina wonti nina nunkangu karakara wapalkana kana wolarandru, tanali punga mangatandra, woderi Nau nganana wonti, wilpa ngankana wonti. Ja tanali nina matja wilpa ngankana, tanali turarani piri, nunkangupini kana tjunduru paranani, ngarilkana wonti. ");
INSERT INTO dif_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesujeli tanani morlalu ngundrana najina, Nau kana tjundurani jatana wonti: „Ngatamurajai, madlentji jinkani matja worana warai!“ ");
INSERT INTO dif_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Naka jaura jinkinietja palpa ngamana wonti, tanali ngundrana wonti ngarali tananali: ");
INSERT INTO dif_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","„Minandru Nulupini jeruja Goda ngirkibai? Worana ngurunguru nganai madlentji kalingala, kalitakali Goda kulnulu?“ ");
INSERT INTO dif_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ja nurujeli Jesujeli Jaolali nunkanali ngujamana wonti, tanali jeruja ngundrai, Nau tanangu jatana wonti: „Minandru jura ngarali juranali jenia ngundrai? ");
INSERT INTO dif_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Mina morla ngaua nganai, kana tjundurani jatala kara: Madlentji jinkani matja worana, jatala kara: Terkakau, turarani piri jinkani maniau ja wapau? ");
INSERT INTO dif_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ngangau jura ngujamananto, Kanaia Ngatamurajeli ngurula ngamalkai mitani madlentji worala, Nau tjundurani jatana wonti. ");
INSERT INTO dif_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Ngani jinkangu jatai: Terkakamai, turarani piri jinkani maniau, ja jinkani pungaia wapau!“ ");
INSERT INTO dif_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ja nau nurujeli terkakana wonti, ja nulu turarani piri nunkani manina wonti, ja dunkana wonti pratjanani, jeruja pratjana pirna ngaruparana wonti ja Goda jurakokana wonti jeruja jatana: „Wata pota kulno ngaiani jenia najinala.“ ");
INSERT INTO dif_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ja Nau nakaldra panto dirkalaniwirdi wapana wonti, ja kana wolara nunkangu wokarana wonti, ja Nulu tanangu ngujangujara jinkina wonti. ");
INSERT INTO dif_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ja wiringana Nulu Levi Alphäuni ngatamura najingana wonti mardatandrakampanietjaia pungani ngamanani, ja Nau nunkangu jatana wonti: „Ngakangu karipateriau!“ Ja nau terkakana wonti ja nunkangu karipaterina wonti. ");
INSERT INTO dif_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ja jendranguta Nau pungani nunkani bukani ngamana wonti, ja mardatandrakampanietja ja kana madlentji marapu Jesungu ja milini nunkanani jela ngamana ngarina wonti bukaia; ngangau tana marapu nganana wonti, ja tana nunkangu karipaterina wonti. ");
INSERT INTO dif_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ja jaura jinkinietjali ja Pharisaiali nina najina madlentji ngankanietjanto ja mardatandrakampanietjanto tajinani, tana milini nunkanani jatana wonti: „Minandru Nulu madlentji ngankanietjani ja mardatandrakampanietjani jela tajiai ja tapai?“ ");
INSERT INTO dif_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ja Jesujeli jenia matja ngarana, Nau tanangu jatana wonti: „Ngurungurujeli wata kunki ngundrai, a‐ai, muntjali. Ngani wata wokaranala kana talku karkala, a‐ai, windri kana madlentji.“ ");
INSERT INTO dif_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ja Johannini mili ja Pharisaiani milja ngamana wonti; ja tana wokarana wonti ja nunkangu jatana wonti: „Minandru Johannini ja Pharisaiani mili milja ngamai, ja mili jinkani wata milja ngamai?“ ");
INSERT INTO dif_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ja Jesus tanangu jatana wonti: „Noangantjanipirnaia kamaneli ngandandariai milja ngamala noangantjanipirna tanangu jela ngananani? Jeruntjaia tanali noangantjanipirna ngamalkai, tana ngandandariai milja ngamala. ");
INSERT INTO dif_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ditji wokarala nganai, tanali noangantjanipirna tanangundru manila nganai, ngadani tanaia milja ngamala nganai. ");
INSERT INTO dif_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Wata kulnujeli katini womalani kati jela ngumu karpai; ngangau kati jela marra nakaldra kati womalandru purateriai, ja wilpa morla pirna pantjiai. ");
INSERT INTO dif_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ja bakana wata kulnujeli waina marra junga womalani kurarai, a‐ai, waina marrali junga wokaribaiati, ja waina ngakaiati, ja junga pakiati, a‐ai, tanali waina marra junga marrani kurarananto.“ ");
INSERT INTO dif_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ja jendranguta Nau Sabbat ditjini buka maruni palkingana wonti, ja milieli nunkanali wonina wonti palto ngankala buka mangatandra wokaribala. ");
INSERT INTO dif_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ja Pharisaia nunkangu jatana wonti: „Mai, Minandru tanalia Sabbat ditjini ngankai, mina wata talku nganai?“ ");
INSERT INTO dif_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ja Nau tanangu jatana wonti: „Jura wata warapanala, mina Davidali ngankana wonti, jendranguta nau buka pani nganana wonti, ja nau, ja tana nunkangunto, mauali nganana wonti? ");
INSERT INTO dif_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Worderu nau Godaia pungani wirina wonti Abjathar Priesta pirnaia ditjini, ja wondrani buka tajina wonti, tanana tajila wata kuluni manuni kuranala, a‐ai, windri Priestani, ja nulu bakana tanangu nunkangunto, jinkina wonti? ");
INSERT INTO dif_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ja Nau tanangu jatana wonti: Sabbat ditji kanandru pantjina wonti, ja wata kana Sabbat ditjindru. ");
INSERT INTO dif_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Jendrania Kanaia Ngatamura bakana Sabbat ditjia Kapara nganai.“ ");
INSERT INTO dif_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ja Nau nakaldra jaura pungani wokarana wirina wonti, ja naka kana kulno nganana wonti, nau mara kulno muja nganana wonti. ");
INSERT INTO dif_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ja tanali nina najinajibana wonti, Nulu nina Sabbat ditjini tepi ngankala nganai kara, ngangau tana nunkangundru ngulkuterkananto. ");
INSERT INTO dif_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ja Nau nunkangupini kanani, nau mara muja ngananani, jatana wonti: „Terti terkakamai!“ ");
INSERT INTO dif_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ja Nau tanangu jatana wonti: „Jenia talku nganai, Sabbat ditjini ngumu ngankala kara, madlentji ngankala kara, mungara kulkala kara, nari ngankala kara?“ Ja tana ngapu nganana wonti. ");
INSERT INTO dif_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ja Nulu tanana tirieli najina karitjina wonti, ja tanani ngara ngurungurundru ngaurongauro nganana wonti, ja nunkangu kanani jatana wonti: „Mara ngutateriau!“ Ja nau mara ngutaterina wonti, ja nau mara nakaldra tepi nganana wonti mara nguru jeribaka. ");
INSERT INTO dif_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ja Pharisaia matja dunkana, tana nurujeli Herodini milieli jakalkijiribamalina wonti nunkangundru, worderu nina nandrala. ");
INSERT INTO dif_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ja Jesus nunkani milinto pantuja kutingana wonti; ja kana wolara marapu nunkangu karipaterina wonti Galilaiandru, ja Judaiandru, ");
INSERT INTO dif_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ja Jerusalemindru, ja Idumaiandru, ja Jordan kaiari jerankarindru, bakana tana Tyrus ja Sidon mitandru wolara marapu nunkangu wokarana wonti; ngangau tanali ngarana wonti, worderu marapu Nulu ngankanani. ");
INSERT INTO dif_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ja Nau milini nunkanani jatana wonti, tanali nunkangu bota ngankijiribingananto kana wolarandru; ngangau tanali nina wata nankanankananto. ");
INSERT INTO dif_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ngangau Nulu marapu tepi ngankana wonti, jeruja tana muntja pratjana nunkangu jurboringana wonti nina karakarala. ");
INSERT INTO dif_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ja kutji murumuru wora, tanali nina najina, nunkangu woraterina wonti ja maritjina wonti ja jatana wonti: „Jidni Godaia Ngatamura nganai.“ ");
INSERT INTO dif_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ja Nulu tanana pirna daudauana wonti, tanali nina wata tinkari ngankananto. ");
INSERT INTO dif_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ja Nau mardawonpaia tarana wonti, ja Nulu karkana wonti tanana Nulu ngantjana wonti; ja tana nunkangu wokarana wonti. ");
INSERT INTO dif_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ja Nulu marapratjana ja mandru kalkalkana wonti, ngangau tana nunkangunto nganananto, ja Nulu tanana jinpananto jaura kaukaubala, ");
INSERT INTO dif_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ja pirnala ngamalkala kana muntja tepi ngankala, ja kutji worana dunkalkala. ");
INSERT INTO dif_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ja Nulu Simoningu tala Petrus ngokana wonti. ");
INSERT INTO dif_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ja Jakobus Zebedäuni ngatamura, ja Johannes Jakobuni ngatata; ja Nulu pudlangu tala ngokana wonti jenia: „Boanerges, jenia wondrai: Piltripiltria kupa.“ ");
INSERT INTO dif_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ja Andreas, ja Philippus, ja Bartholomäus, ja Matthäus, ja Thomas, ja Jakobus Alphäuni ngatamura, ja Thaddäus, ja Simon, Kana ngurandru, ");
INSERT INTO dif_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Ja Judas Ischariot, nulu nina bakana wontawontana wonti. ");
INSERT INTO dif_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ja tana pungani wirina wonti; ja nakaldra kana wolara jurborina wonti, jeruja tana ngandandarina wonti buka tajila. ");
INSERT INTO dif_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ja tanali, nunkangunto nganana, jenia ngarana warai, tana dunkana wonti nina patala; ngangau tana jatana wonti: „Nauja jirijiri.“ ");
INSERT INTO dif_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ja jaura jinkinietja, tana Jerusalemingundru matja ngarina, jatana wonti: „Nulu Beelsebub ngamalkai, ja kutjia kaparali Nulu kutji worana dunkalkai.“ ");
INSERT INTO dif_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ja Nulu tanana karkana wonti, ja tanangu jeribaka jaurali jatana wonti: „Worderu Satanali Satan dunkalkananto? ");
INSERT INTO dif_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ja milila kulno munta piltjaru ngankaterinani, jeruja naupini milila wata terkala nganai. ");
INSERT INTO dif_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ja punga kulno munta piltjaru ngankaterinani, jeruja naupini punga wata terkala nganai. ");
INSERT INTO dif_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ja Satan munta terkakirpaterinani ja piltjaru ngankaterinani, jeruja nau wata terkala nganai, a‐ai, nau mudala nganai. ");
INSERT INTO dif_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Kana kulno ngandandariai kana ngurunguruja pungani wirila poto nunkani watawatali manila, nulu wata ngopera kana ngurunguru dupudupu ngankanani; ja ngadani nulu pungani nunkanani pratjana watawatali manila nganai. ");
INSERT INTO dif_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Morlalu ngani jurangu jatai: Kanaia kupani Nulia madlentji pratjana kalingala nganai, ja ngirkibani jaura pratjana, tanali Goda ngirkibanani. ");
INSERT INTO dif_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Warle ngirkibani jaura jatai Jaola Kulikirini, nulu wata kalinganila manila nganai ngurali, a‐ai, nulu kalala madlentji ngurali manila nganai. ");
INSERT INTO dif_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ngangau tana jatana wonti: Nulu kutji murumuru ngamalkai.“ ");
INSERT INTO dif_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jendranguta ngandri nunkani ja ngatata nunkani wokarana wonti; ja tana palarani terkana wonti ja nunkangu jinpana wonti nina karkala. ");
INSERT INTO dif_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ja kana wolara nunkangu ngamana karitjina wonti. Ja tana nunkangu jatana wonti: „Mai, ngandrieli jinkanali ja ngatatajeli jinkanali ja kakujeli jinkanali palarani jidna wontiai.“ ");
INSERT INTO dif_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ja Nulu tanangu kalabana wonti ja jatana wonti: „Worana ngandri ngakani nganai ja ngatata ngakani?“ ");
INSERT INTO dif_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ja Nulu najina karitjina wonti tanangu, tana nunkangu ngamana karitjina wonti ja jatana wonti: „Najanau, ngandri ngakani ja ngatata ngakani! ");
INSERT INTO dif_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ngangau warle Godaia jertapaterina ngankai, naupini ngatata ngakani ja kaku ngakani ja ngandri ngakani nganai!“ ");
INSERT INTO dif_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ja nakaldra Nulu wonina wonti panto dirkalani ngujangujara jinkila. Ja kana wolara nunkangu jurborina wonti, ja Nau botani wirina wonti ja ngapani ngamana ngarina wonti, ja kana wolara panto dirkalani ngamana ngarina wonti mitani. ");
INSERT INTO dif_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ja Nulu tanangu jeribaka jaurali ngujangujara marapu jinkina wonti, ja Nau tanangu ngujangujarali nunkanali jatana wonti: ");
INSERT INTO dif_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","„Ngaranau! Mai, jaupanietja wapana wonti jaupala. ");
INSERT INTO dif_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ja jendranguta nulu jaupanani, palpa paltuni purina wonti; ja paia wokarana wonti ja nina tajina wonti. ");
INSERT INTO dif_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Palpa marda paltirani purina wonti, ja wata mita tjanka marapu ngamalkana wonti; ja nurujeli punkana wonti, ngangau mita puta nganana wonti. ");
INSERT INTO dif_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ja ditji matja dunkana, nau winjarina wonti; ja ngangau kapara pani nganana wonti, nau mujarina wonti. ");
INSERT INTO dif_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ja palpa dilkani purina wonti; ja dilka punkana wonti ja nina palimana wonti, ja wata tandra jinkina wonti. ");
INSERT INTO dif_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ja palpa mita ngumuni purina wonti, ja kuripunkana wonti ja punkana wonti ja tandra punkibana wonti ja mandrana wonti: Kulnujeli 30, kulnujeli 60, kulnujeli 100. ");
INSERT INTO dif_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ja Nau tanangu jatana wonti: Warle talpa ngamalkai ngarala, nulu ngaraiatimai!“ ");
INSERT INTO dif_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ja Nau kulnulu nganana, nina mili marapratjana ja mandrujeli, ja tanali nunkangunto, jakalkana wonti nunkangupini jeribaka jaurandru. ");
INSERT INTO dif_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ja Nau tanangu jatana wonti: „Jurangu matja jinkina warai, jaura kurukuru Godaia mililandru ngujamananto; tanangu, tana palarani nganai, pratjana jeribaka jaura nganai. ");
INSERT INTO dif_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ngangau tanali najinani najinanto ja bulu ngujamananto, ja ngaranani ngarananto ja bulu ngundrananto; ngangau tana wata madlentjandru karitjinanto, tanani madlentji kalingananto.“ ");
INSERT INTO dif_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ja Nau tanangu jatana wonti: „Ninapini jeribaka jaura jura wata ngujamanani, ja worderu jura jeribaka jaura pratjana ngujamala nganai? ");
INSERT INTO dif_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Iaupanietjali jaura jaupai. ");
INSERT INTO dif_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Tana paltuni tanapini nganai; woderi jaura matja jaupana, ja tanali nina ngarana, nurujeli kutji wokarai ja jaura maniai, nina ngarani tananani matja jaupana. ");
INSERT INTO dif_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Tanangu jeribaka tanapini nganai, tanana marda paltirani matja jaupana; tanali jaura ngarai ja nurujeli murlali nina patai; ");
INSERT INTO dif_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ja munta tana kapara pani nganai, a‐ai, tana maraltja nganai; ngadani ketjaketjana ja tirikaripaterina wokaranani jaurandru, tana wolja kalakalarila nganai. ");
INSERT INTO dif_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ja palpa, tanana dilkani matja jaupana, tanapini nganai, tanali jaura ngarai, ");
INSERT INTO dif_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ja nunkangupini mitani manujeli ngundrana, ja poto pirnaia jedibana, ja poto nguruja milkirina tanangu wiriai, ja jaura palimai, ja tandra pani punkibai. ");
INSERT INTO dif_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ja tanapini nganai, tanana mita ngumuni matja jaupana; tanali jaura ngarai ja patai ja tandra punkibai; kulnujeli 30, kulnujeli 60, ja kulnujeli 100.“ ");
INSERT INTO dif_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ja Nau tanangu jatana wonti: „Praitji wokarai, nina kokuni ngarinalu kara, turarani pirini ngarinalu kara kurala? Nau wata parai, nina praitjaia potuni kurala? ");
INSERT INTO dif_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ngangau panila kurirpi nganai, naupini wata tinkari pantjinanto; ja panila kurukuruni pantjina wonti, a‐ai, praitjani wokarananto. ");
INSERT INTO dif_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kulnujeli talpa ngamalkai ngarala, nulu ngaraiatimai!“ ");
INSERT INTO dif_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ja Nau tanangu jatana wonti: „Najianau, mina jura ngarai: Mina kokujeli jura jinkiai, jenia koko jura nakaldra manina tikala nganai; ja jura ngaranani, tanali jurangu morla jinkila nganai. ");
INSERT INTO dif_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ngangau warle ngamalkai, nunkangu Nulia jinkila nganai; ja warle wata ngamalkai, nunkangundru Nulia bakana jenia manila nganai, mina nulu ngamalkai.“ ");
INSERT INTO dif_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ja Nau jatana wonti: „Jeruja Godaia milila nganai, worderu kana kulnujeli paua mitani japai, ");
INSERT INTO dif_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ja nau mukaturarai, ja jiritjiai tinkani ja ditjini, ja paua punkai ja wirdiriai; ja nau ko worderu. ");
INSERT INTO dif_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ngangau mita muntali tandra punkibai, ngopera nindri, ngadani mangatandra, ngadani tandra kantji mangatandrani. ");
INSERT INTO dif_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ja tandra talku ngananani, nurujeli nulu kirra jinpai, ngangau kampani ditji wokarana warai.“ ");
INSERT INTO dif_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ja Nau jatana wonti: „Worangu jeribaka ngaiani Godaia milila kurananto? Mina jeribaka jaurali ngaiani nina jeribaka kurananto kara? ");
INSERT INTO dif_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Tandra wakawaka jeribaka, ninapini mitani matja jaupana, nau morla waka nganai tandra nguja marapuni mitani. ");
INSERT INTO dif_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ja nina matja jaupana, nau kuri punkai ja morla pirna pantjiai nindri marapuni, ja nguna pirna dunkalkai, jeruja pungalani nunkanani bakana paia ngaranala ngamai.“ ");
INSERT INTO dif_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ja jeribaka jaura marapujeli Nulu tanangu jaura kaukaubana wonti, worderu tana ngurunguru nganana wonti ngarala. ");
INSERT INTO dif_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ja jeribaka jaura panini Nulu tanangu panila kaukaubana wonti; windri pilki Nulu milini nunkanani pratjana mildiri ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ja Nau tanangu, nunkangupini ditjini matja kalkaurarina, jatana wonti: „Ngaiana jerankaria pararananto.“ ");
INSERT INTO dif_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ja tanali kana wolara worarana wonti ja nina patana wonti worderu Nau botani nganana wonti; ja bakana bota nguru nunkangunto nganana wonti. ");
INSERT INTO dif_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ja watara pirna wilparina wonti; ja mandikila botani pinpitarana wonti, jeruja nau ngampu ngapali manamiri nganana wonti. ");
INSERT INTO dif_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ja Nau botani ngadani kukati terkana mukaturarana wonti; ja tanali nina jiritjibana wonti ja nunkangu jatana wonti: „Ngujangujara jinkinietjajai, jenia jnkangu jeribaka nganai ngaiana palinani?“ ");
INSERT INTO dif_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ja Nau mukandru matja jiritjina, Nulu watara dikidikibana wonti ja ngapani jatana wonti: „Ngapuriau, dalpura nganau!“ Ja watara mudana wonti, ja dalpura pirna nganana wonti. ");
INSERT INTO dif_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ja Nau tanangu jatana wonti: „Minandru jura jeruja japali nganai? Minandru jura wata morlalu ngundrai?“ ");
INSERT INTO dif_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ja tana japali pirna pantjina wonti ja ngankamalina wonti: „Worana Naupini nganai, ngangau nunkangu watara ja ngapa pankiai?“ ");
INSERT INTO dif_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ja tana pantuni jerankari pararana wonti Gadarena mitani. ");
INSERT INTO dif_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ja Nau botandru matja dunkana, nunkangu nurujeli narikutundru kana kutji murumurunto dankamalina wonti, ");
INSERT INTO dif_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ja ngura nunkani narikutu nganana wonti. Ja kana ngandandarina wonti nina kanjangarieli workamandrala. ");
INSERT INTO dif_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ngangau pota marapu tanali nina tidna workamandrana wonti, ja nina kanjangarieli dupudupu ngankana wonti; ja nulu kanjangari worduwordu ngankana wonti, ja tidna kanjangari dingadingana wonti; ja wata kulno ngurunguru nganana wonti nina manjujeli ngankala. ");
INSERT INTO dif_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ja nau milingeru ditjiwirdi ja tinkawirdi narikutuni ja mardawonpani maritjina wonti, ja munta mardali damaterina wonti. ");
INSERT INTO dif_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nulu Jesus woritandru najina, nau mindrina wonti ja nunkangu pantjaterkana ngarina wonti, ");
INSERT INTO dif_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ja maritjina wonti ngaiala pirnali ja jatana wonti: „Mina ngakangu ja jinkangu Jesujai, Goda Kapara pirnaia Ngatamurajai? Ngani jinkangu Godani jaura morlalu jatai, wata ngana jupau!“ ");
INSERT INTO dif_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Nau nunkangu jatana wonti: „Dunkau, jidni kutji murumuru, nunkangupini kanandru!“ ");
INSERT INTO dif_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ja Nulu nina jakalkana wonti: „Mina tala jinkani nganai?“ Ja nulu kalabana wonti ja nunkangu jatana wonti: „Legion tala ngakani nganai, ngangau ngaiani marapu nganai.“ ");
INSERT INTO dif_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ja nau nunkangu pirna ngatjina wonti, Nulu tanana wata nunkangupini mitandru narrananto. ");
INSERT INTO dif_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Naka mardawanpa kalikalini piki ngami pirna marakana wonti. ");
INSERT INTO dif_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ja kutji wora nunkangu ngatjina wonti ja jatana wonti: „Ngaianina jinpau pikia, ngangau ngaiani tanangu wirinanto!“ ");
INSERT INTO dif_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ja Jesujeli nurujeli tanangu jenia manuni kurana wonti. Ja kutji murumuru matja dunkana, tana pikini wirina wonti, ja piki ngami mardawonpa kalikalini kalikalibakana wonti ngapani; ja tana 2000 nganana wonti; ja tana ngapani palipalina wonti. ");
INSERT INTO dif_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ja pikingamalkanietja wora japa mindrina wonti, ja ngura pirnani ja wakani jenia kaukaubana wonti, ja tana dunkana wonti najila, mina pantjina warai. ");
INSERT INTO dif_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ja tana Jesungu wokarana wonti, ja tanali nina kana kutjila najina wonti ngapu ngamanani, ja kati matja widmaterina, ja tjuru ngumu ngamalkanani, nulupini ngopera Legion ngamalkana warai; ja tana japali pantjina wonti. ");
INSERT INTO dif_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ja tanali jenia najina wonti tanangu kaukaubana wonti mina kana kutjintani pantjina warai, ja bakana jenia pikini. ");
INSERT INTO dif_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ja tanali wonina wonti nunkangu ngatjila, Nau tanani wondirandru puntinanto. ");
INSERT INTO dif_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ja Nau botani matja wirina, nunkangu kana kutjila ngatjina wonti nunkangu jela nganala. ");
INSERT INTO dif_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jesujeli nunkangu wata manuni kurana wonti, a‐ai, nunkangu jatana wonti: „Wapau pungaia jinkanaia ja nguralaia jinkanaia, ja tanangu kaukaubamai mina pirnala Kaparali jinkangu ngankana warai, ja worderu Nau jinkangu kalumiltjamiltjarina warai.“ ");
INSERT INTO dif_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ja nau puntina wonti ja wonina wonti Dekapolis mitani kaukaubala, mina Jesujeli nunkangu ngankana warai; ja pratjana ngaruparana wonti. ");
INSERT INTO dif_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ja Jesus nakaldra botali dirkalani jerankana matja pararana, nunkangu kana wolara jurborina wonti; ja Nau pantuni karakara nganana wonti. ");
INSERT INTO dif_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ja mai, jaura pungaia kapara kulno wokarari wonti, tala nunkani Jairus, ja nulu nina najina, nau nunkangu tidnani woraterina wonti. ");
INSERT INTO dif_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ja nau nunkangu pirna ngatjina wonti ja jatana wonti: „Ngatamura mankara ngakani ngara wordu: Kaparau ja nankangu mara kurateriau, ngangau nani tepirinanto; ja tepi ngamananto.“ ");
INSERT INTO dif_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ja Nau nunkangunto wapana wonti; ja nunkangu kana wolara karipaterina wonti, ja nina jennia wonti. ");
INSERT INTO dif_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ja widla kulno, nani kilpawoldra marapratjana ja mandru kumaranto nganana wonti. ");
INSERT INTO dif_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ja nani kunki marapundru pirna ketjaketjana wonti, ja poto nankani kalala jinkina wonti, ja nankangu wata marangokana wonti, a‐ai, nani windri morla madlentji pantjina wonti; ");
INSERT INTO dif_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nandru Jesungundru matja ngarana, nani kana wolarani wirina wonti ja tokunkari kati nunkani karakarana wonti. ");
INSERT INTO dif_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ngangau nani jatana wonti: „Ngato windri kati nunkani karakaranani, ngani tepirinani.“ ");
INSERT INTO dif_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ja nurujeli kumari tjiri mujarina wonti, ja nandru palku nankanina ngujamana wonti, nani muntjandru matja tepirina. ");
INSERT INTO dif_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ja nurujeli Jesujeli muntali ngujamana wonti, ngurula nunkangundru matja dunkana, Nulu kana wolorani najina karitjina wonti ja jatana wonti: „Warle kati ngakani karakarana warai?“ ");
INSERT INTO dif_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ja mili nunkani nunkangu jatana wonti: „Jundru najiai, kana wolarali jidna jeniai, ja jidni jatai: Warle ngana karakarana warai?“ ");
INSERT INTO dif_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ja Nulu najina karitjina wonti nana najila, warlenandru jenia ngankana warai. ");
INSERT INTO dif_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Widla japali ja ngarranali wokarana wonti, ngangau nandru ngujamana wonti, mina nankangu matja pantjina, ja woraterina wonti nunkangu, ja nunkangu jaura morlalu pratjana jatana wonti. ");
INSERT INTO dif_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Nau nankangu jatana wonti: „Ngatamurajai, morlalu ngundranali jinkanali jidna tepi ngankana warai; murlali wapau, ja tepi nganau jinkani muntjandru!“ ");
INSERT INTO dif_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Nau jenia jatanani, jaura pungaia kaparaia ngurala palpa wokarana wonti ja jatana wonti: „Ngatamura mankara jinkani matja nari; minandru jundru ngujangungara jinkinietja morla ngarapatipatibai?“ ");
INSERT INTO dif_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesujeli jenia kaukaubani jaura nurujeli ngarana wonti, ja jaura pungaia kaparani jatana wonti: „Wata japali nganau, windri morlalu ngundrau!“ ");
INSERT INTO dif_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ja Nulu wata kulnuni manuni kurana wonti nunkangu karipaterila, windri Petrungu ja Jakobungu ja Johanningu Jakobuni ngatata. ");
INSERT INTO dif_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ja tana jaura pungaia kaparaia pungani wokarana wonti, ja Nulu patijiritjinani najina wonti, ja tana pirna jindranani ja juajuanganani. ");
INSERT INTO dif_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ja Nau matja wokarana wirina, Nau tanangu jatana wonti: „Minandru jura juajuangai ja jindrai? Kupa wata nari, a‐ai, nania windri mukaturarai.“ ");
INSERT INTO dif_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ja tana nunkangu kinkana wonti. Ja Nulu pratjana narrana wonti, ja Nulu kupaia ngaperi ja ngandri, ja tana nunkangunto, patana wonti, ja wirina wonti woderi kupa parana wonti. ");
INSERT INTO dif_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ja Nulu mankara mara patana wonti ja nankangu jatana wonti: „Talitha kumi; jenia wondrai: Mankarajai, ngani jinkangu jatai: Jiritjiau!“ ");
INSERT INTO dif_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ja nurujeli mankara jiritjina wonti ja wirarina wonti; ngangau nani kilpawoldra marapratjana ja mandru nganana wonti. Ja tana pirna ngaruparana wonti. ");
INSERT INTO dif_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ja Nulu tanana pirna daudauana wonti, wata kulnujeli jenia ngujamananto; ja Nau jatana wonti, tanali nana buka jinkinanto. ");
INSERT INTO dif_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ja Nau nakandru puntina wonti ja ngura kamanelini nunkanani wokarana wonti; ja mili nunkani nunkangu karipaterina wonti. ");
INSERT INTO dif_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ja matja Sabbatarina, Nulu wonina wonti jaura pungani ngujangujara jinkila; marapujeli jenia ngarana, pirna ngaruparana wonti ja jatana wonti: „Wodajerindrn Nulu jenia ngamalkai? Ja mina kiri jenia nganai nunkangu matja jinkina, ja jenia ngurula pirna, Nulia marali ngankai? ");
INSERT INTO dif_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Naupini wata pita ngankanietja nganai, Mariani ngatani, ja Jakobuni ja Joseni ja Judani ja Simonani neji? Ja kaku nunkani wata ngaianangunto nganai?“ Ja tana nunkangu kalakalarina wonti. ");
INSERT INTO dif_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesus tanangu jatana wonti: „Propheta wata waka nganai, a‐ai, windri mita kamanelini nunkanani ja kamanelini nunkanani ja pungani nunkanani.“ ");
INSERT INTO dif_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ja Nau ngandandarina wonti naka pirnala ngankala, windri muntja ngaljeni Nau mara kuraterina wonti, ja tanana tepi ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ja Nau ngaruparana wonti, ngangau tana wata morlalu ngundrana wonti. Jo Nau ngura worani karitjinawontiwontikana wonti ngujangujara jinkila. ");
INSERT INTO dif_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ja Nulu marapratjana ja mandru karkana wonti, ja wonina wonti tanana mandrulu mandrulu jinpala, ja tanangu ngurula jinkina wonti kutji murumuruja. ");
INSERT INTO dif_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ja Nulu tanangu jirijiribana wonti, tanali panila paltuni padakananto, windri wonapita; wata billi, wata buka, wata mardatandra pailtjini. ");
INSERT INTO dif_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Windri tidnaputa workamantraterianau, ja wata kati mandru widmaterianau! ");
INSERT INTO dif_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ja Nau tanangu jatana wonti: „Woderi jura punga kulnuni matja wirina, naka ngamanimai jura puntilalu. ");
INSERT INTO dif_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ja warle ngurali jurana wata patanani, ja jurana wata ngaranani; nakandru puntianau ja puturu jurani tidnandru kantikantianau, tanangu malka nganananto. Morlalu ngani jurangu jatai: Sodom ja Gomorra mitalali kalala morla waka manila nganai kalala ditjini, nunkangupini ngurani.“ ");
INSERT INTO dif_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ja tana matja wapana kurana, tanali kaukaubana wonti, tana madlentjandru karitjinanto. ");
INSERT INTO dif_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ja tanali kutji marapu dunkalkana wonti, ja waltowalto marapu gildieli wiribana wonti, ja tanana tepi ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ja Herodes mitaia kaparali jenia ngarana wonti, ngangau tala nunkani paruparurina wonti, ja nau jatana wonti: „Johannes multibanietja narindru matja jiritjina, ja jendrangundruja Nulu jenia pirnala ngankai.“ ");
INSERT INTO dif_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Palpa jatana wonti: „Nauja Elias nganai;“ palpa jatana wonti: „Nauja Propheta kulno nganai, Propheta kulno jeribaka kara.“ ");
INSERT INTO dif_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herodili jenia ngarana, nau jatana wonti: „Naupini Johannes nganai, nina mangatandra ngato wokaribana paraia; nau narindru jiritjina warai.“ ");
INSERT INTO dif_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ngangau nulupini Herodili jinpana wonti ja Johannes patana wonti, ja nina kanjangari pungani dupudupu ngankana wonti Herodias Philippuni ngatataia nunkanaia noandru; ngangau nulu nana noa patana wonti. ");
INSERT INTO dif_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ngangau Johannes Herodingu jatana wonti: „jinkangu wata talku nganai, ngatataia jinkanaia noa ngamalkananto.“ ");
INSERT INTO dif_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodiasandru nina najinajibana wonti ja ngantjana wonti nina nari ngankala, ja nani ngandandarina wonti. ");
INSERT INTO dif_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ngangau Herodes Johanningundru japali nganana wonti, ngangau nau milkila nganana wonti, nau kana talku ja kulikiri, ja nulu nina ngamalkana wonti; ja nina matja ngarana, nulu marapu ngankana wonti, ja nina manjujeli ngarana wonti. ");
INSERT INTO dif_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ja ditji manju matja wokarana, Herodili dankani ditjini nunkanani buka pirna ngankingana wonti kana pirnani, ja kapara pirnani, ja Galilaialani ngoperaetjani nunkanani. ");
INSERT INTO dif_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ja Herodiasani ngatani wirina wonti, ja nani kilina wonti, ja Herodes ja kamaneli nunkani nankangu murlali pantjina wonti; ngadani mitaia kaparali mankarani jatana wonti: „Ngatjiau ngakangu, mina jundru ngatjiai, ja ngato jinkangu jinkila nganai.“ ");
INSERT INTO dif_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ja nau nankangu jaura morlalu jatana wonti: „Minakulno jidni ngakangu ngatjiai, jenia ngato jinkangu jinkila nganai milila ngakani juralu.“ ");
INSERT INTO dif_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nani dunkana wonti ja ngandrini nankanani jatana wonti: „Mina ngani ngatjinanto?“ Nani jatana wonti: „Johannes multibanietja mangatandra.“ ");
INSERT INTO dif_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ja nani nurujeli pirna mitaia kaparani wirina wonti ja ngatjina wonti ja jatana wonti: „Ngato ngantjai, jundru ngakangu nurujeli Johannes multibanietja mangatandra pirrani jinkinanto.“ ");
INSERT INTO dif_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ja mitaia kapara ngaurongauro pirna pantjina wonti, windri jaura morlalundru ja bukaia kamanelindru nau wata ngantjina wonti nana nintali ngankala. ");
INSERT INTO dif_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ja nurujeli mitaia kaparali mangatandra wokaribanietja kulno jinpana wonti, ja jirijiribana wonti mangatandra nunkani maninanto. ");
INSERT INTO dif_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Nau wapana wonti ja mangatandra nunkani kanja ngari pungani wokaribana wonti, ja mangatandra nunkani pirrani tikalkana wonti ja mankarani jinkina wonti, ja mankarali nina ngandrini nankanani jinkina wonti. ");
INSERT INTO dif_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ja milieli nunkanali jenia matja ngarana, tana wokarana wonti ja palku nunkani manina wonti ja nari kutuni kulnuni kurana wonti. ");
INSERT INTO dif_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ja Apostel wora Jesungu jurborina tikana wonti, ja tanali nunkangu pratjana kaukaubana wonti, mina tanali ngankana warai, ja mina ngujangujara tanali jinkina warai. ");
INSERT INTO dif_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ja Nau tanangu jatana wonti: „Kaparanau jura pilki pitaraia!“ Ngangau marapu nganana wonti, tana wokarana wonti ja wapana wonti, ja tana ngandandarina wonti buka tajila. ");
INSERT INTO dif_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ja tana wapana wonti botali pilki pitaraia. ");
INSERT INTO dif_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ja kana wolarali tanana wapanani najina wonti, ja marapujeli nina ngujamana wonti; ja tana tidnali ngura pratjanandru jerra mindrina wonti, ja tana tanangu ngopera nganingana wonti ja nunkangu mapaterina wonti. ");
INSERT INTO dif_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ja Nau matja dunkana, Jesujeli kana wolara pirna najina wonti, ja Nau tanangu kalumiltjamiltjarina wonti, ngangau tana tjipi jeribaka nganana wonti tana ngamalkanietja pani; ja Nulu wonina wonti tanangu ngujangujara marapu jinkila. ");
INSERT INTO dif_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ja ditji ngaltingaltini mili nunkani nunkangu wokarana wonti ja jatana wonti: „Ninkida pitaru nganai, ja ditji ngaltingaltiriai. ");
INSERT INTO dif_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Tanana jinpau, ngangau tana ngura pirnaia ja wakaia karakara wapananto, tanali buka tanani burungankala, ngangau tanali panila ngamalkai tajila.“ ");
INSERT INTO dif_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Nulu kalabana wonti ja tanangu jatana wonti: „Jura tanangu buka jinkianau!“ Ja tana nunkangu jatana wonti: „Ngaiani wapananto 200 mardatandrali buka burungankala tanangu jinkila tajinanto?“ ");
INSERT INTO dif_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nau tanangu jatana wonti: „Worderuntja buka ngunku jura ngamalkai? Wapanau ja najianau!“ Ja tanali matja ngujamana, tana jatana wonti: „Mara wora, ja paru mandru.“ ");
INSERT INTO dif_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ja Nulu tanangu jirijiribana wonti, tana pratjana ngamana ngarinanto witta kulno ja witta kulno kanta kuljakuljani. ");
INSERT INTO dif_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ja tana ngamana ngarina wonti witta pilkipilki, milingeru witta kulnuni 100 ja witta kulnuni 50. ");
INSERT INTO dif_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ja Nulu buka ngunku mara wora jo paru mandru patana wonti, ja Nulu pariwilpa najina tarana wonti ja tanana ngurungutana wonti; ja Nulu buka wokaribana wonti ja milini nunkanani jinkina wonti, ngangau tanali tanangu jinkinanto, bakana paru mandru Nulu pratjanani puntibana wonti. ");
INSERT INTO dif_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ja pratjanali tajina wonti ja jerturina wonti. ");
INSERT INTO dif_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ja tanali buka wordu wordu billi marapratjana ja mandru manamiri kampana wonti, ja bakana paru. ");
INSERT INTO dif_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ja tanali matja buka tajina, materi 5000 nganana wonti. ");
INSERT INTO dif_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ja nurujeli Nulu mili nunkani jinpana tertana wonti, tana botani wirinanto ja nunkangu ngopera jerankari Bethsaidaia pararananto, Nulu ngopera kana wolara jinpananto. ");
INSERT INTO dif_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ja Nau tanangundru matja puntina, Nau mordawonpaia tarana wonti ngatjila. ");
INSERT INTO dif_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ja matja tinkarina, bota panto mandrani nganana wonti, ja Nau mitani kulnulu. ");
INSERT INTO dif_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ja Nulu najina wonti, worderu tanali parparali ngankana bota tertubana wonti, ngangau watara tanangu mudlani ngakana wonti. Ja nguramarani kuperi Nau tanangu wokarana wonti ngapani wapana; ja Nulu ngantjana wonti tanangu wiringala. ");
INSERT INTO dif_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Tanali nina najina ngapani wapanani, tanali ngundrana wonti Nau kutji nganai, ja pirna maritjina wonti. ");
INSERT INTO dif_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ngangau pratjanali nina najina wonti ja ngarrana wonti. Ja Nulu nurujeli tanangu kaukaubana wonti ja jatana wonti: „Murlali ngananimai, ngani Nauja, wata japali ngananimai!“ ");
INSERT INTO dif_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ja Nau tanangu botaia tarana wonti, ja watara mudana wonti. Ja tana munta japali pirna pantjina wonti ja ngaruparana wonti. ");
INSERT INTO dif_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ngangau tana bukandru wata kiririna wonti, ngangau tana ngara ngurunguru nganana wonti. ");
INSERT INTO dif_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ja tana matja pararana, tana Genezareth mitani wokarana wonti, ja tanali bota dirkalaia parumana wonti. ");
INSERT INTO dif_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ja tana botandru matja dunkana, nurujeli tanali nina ngujamana wonti. ");
INSERT INTO dif_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ja tana nunkangupini mitani paruparu wirarina wonti, ja wonina wonti turarani pirini kana muntja wirilkala, woderi tanali ngarana wonti Nau ngananani. ");
INSERT INTO dif_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ja woderi Nau wirina wonti ngura wakaia kara pirnaia kara ngura morla wakaia kara, jerra tanali kana muntja jinkimalini pirini terkibana wonti ja nunkangu ngatjina wonti, tanali windri kati jelbi nunkani karakarananto; ja pratjana tanali nina karakarana wonti, tepi pantjina wonti. ");
INSERT INTO dif_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ja Pharisaia ja jaura jinkinietja palpa nunkangu jurborina wonti, tana Jerusalemingundru wokarana wonti. ");
INSERT INTO dif_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ja tanali najina wonti milieli nunkanali palpali mara murumurujeli, jenia wondrai, wata kulirkaterina, buka tajina wonti, tanali daudauana wonti. ");
INSERT INTO dif_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ngangau Pharisaiali ja Juda kanali pratjanali wata tajiai, tana wata ngopera mara parparali kulirkaterina warai, ngangau tanali pinaraia jirijiribani jaura patai. ");
INSERT INTO dif_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ja tanali jinkimalini pirindru tikanani, tanali wata tajiai, wata ngopera kulirkaterina warai; ja jenia marapu nganai, mina tanali ngankai, worderu koko ja buluru koko ja pirra ja kurli kulirkula. ");
INSERT INTO dif_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ngadani Pharisaiali ja jaura jinkinietjali nina jakalkana wonti: „Minandru mili jinkani wata pinaraia jirijiribani jaurani pankiai, ngangau tanali mara murumurujeli buka tajiai“? ");
INSERT INTO dif_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Nulu kalabana wonti ja tanangu jatana wonti: „Ngumu Jesaiasali jurangundru kana jeljujeljundru talpadakana wonti, worderu dakanala parai: Tanalipini kana wolarali ngana manamimieli pirna ngundrai, ja ngara tanani ngakangu worita nganai; ");
INSERT INTO dif_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Bakujeli tanalia ngana pirna ngundrai, ngangau tanalia kanaia jirijiribanandru ngujangujara jinkiai. ");
INSERT INTO dif_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Godaia jirijiribani jaura jura worarai, ja kanaia jirijiribani jaura jura patai; marda koko ja buluru koko kulirkala, ja jenia jeribaka jura morla ngankai. ");
INSERT INTO dif_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ja Nau tanangu jatana wonti: Ngumu jura Godaia jirijiribani jaura worarai jurani jirijiribani jaura kulkala.“ ");
INSERT INTO dif_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ngangau Moses jatana wonti: „Ngaperi ja ngandri pirna ngundramai; ja: Warle ngaperani ja ngandrini jaura madlentji jatai, nau naria palinanto.“ ");
INSERT INTO dif_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Jura jatai: Worana ngaperani kara ngandrini kara jatai: „Korban, jenia wondrai: Poto ngumu ngato jinkiai, mina jinkangu ngumu nganai, nina jundru ngakangundru maninanto; ");
INSERT INTO dif_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Jeruja jura nunkangu wata morla manuni kurai ngaperani kara ngandrini kara ngumu ngankala. ");
INSERT INTO dif_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Jeruja jura Godaia jaura jurani jirijiribani jaurandru worarai, nina jura matja manina; ja jenia jeribaka jura morla ngankai.“ ");
INSERT INTO dif_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ja Nulu kana wolara nunkangu karkana wonti ja tanangu jatana wonti: „Pratjanali ngana ngaranimai ja ngundranimai! ");
INSERT INTO dif_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Panila palarani parai, mina kanani wiriai, jenia nina murumuru ngankai, a‐ai, windri jenia, mina nunkangundru dunkai, jendralipara kana murumuru ngankai. ");
INSERT INTO dif_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Warle talpa ngamalkai ngarala, nulu ngaraiatimai!“ ");
INSERT INTO dif_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ja Nau punga kulnuni wirina wonti kana wolarandru, ja milieli nunkanali nina jakalkana wonti jeribaka jaurandru. ");
INSERT INTO dif_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ja Nau tanangu jatana wonti: „Jeruja bakana jura patipati nganai? Jura wata ngujamai, jenipara pratjana, mina palarandru kanani wiriai, ngandandariai nina murumuru ngankala? ");
INSERT INTO dif_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ngangau jenia wata nunkangu ngarani wiriai, a‐ai, windri mandrani, ja ngadani palkingai; ja jenia tajina pratjana kulirkai. ");
INSERT INTO dif_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Nau jatana wonti: Mina kanandru dunkai, jendralipara kana murumuru ngankai. ");
INSERT INTO dif_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ngangau kana ngarandru dunkai: Ngundrana madlentji, pinta wokaribani, palakantji, naria nandrani. ");
INSERT INTO dif_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Kurikantji, potuni milkirini, tjikatjika, jedibani, mirautjatieli tajini ja tapani, milki madlentji, ngirkibani, pirna ngundraterini, patipatirini. ");
INSERT INTO dif_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Jenia madlentji pratjana ngarandru dunkai, ja kana murumuru ngankai.“ ");
INSERT INTO dif_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ja Nau nakandru terkakana wonti ja Tyrus ja Sidon mitani wokarana wonti; ja Nau punga kulnuni wirina wonti ja ngantjana wonti jenia wata kulnujeli ngujamananto, windri Nau ngandandarina wonti kurukurumalkaterila. ");
INSERT INTO dif_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ngangau widla kulnujeli nunkangundru matja ngarana, ngatatajeli nankanali kutji murumuru ngamalkana wonti, ja nani wokarana wonti ja nunkangu tidnani woraterina wonti. ");
INSERT INTO dif_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Nani widla Griecha widla nganana wonti, Syro Phönizia mitani dankanala, ja nani nunkangu ngatjina wonti, Nulu kutji murumuru nankani ngatanandru dunkalkananto. ");
INSERT INTO dif_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesus nankangu jatana wonti: „Ngopera kupa jerturinanto; ngangau jenia wata talku nganai kupaia buka manila ja kintalani worala.“ ");
INSERT INTO dif_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nandru kalabana wonti ja nunkangu jatana wonti: „Kau Kaparajai; ja bakana kintala wakali kurlini ngarinalu kupa wakaia buka worduwordu tajiai.“ ");
INSERT INTO dif_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ja Nau nankangu jatana wonti: „Nunkangupini jaurandru wapau! kutji jinkani ngatanandru matja dunkana warai.“ ");
INSERT INTO dif_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ja nani pungani nankanani wokarala tikana wonti, ja kutji murumuru matja dunkanani mankamankana wonti, ja mankara turarani pirini paranani. ");
INSERT INTO dif_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ja Nau nakaldra dunkana wonti Tyrus ja Sidon wondirandru, ja Nau Galilaia pantuni wokarana wonti Dekapolis wondirani terti. ");
INSERT INTO dif_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ja tanali nunkangu wapalkana wonti kana talpakuru ja ngapu, ja tana nunkangu ngatjina wonti, Nau nunkangu mara kuraterinanto. ");
INSERT INTO dif_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ja Nulu nina kana wolarandru tjirimalkingana wonti, ja nunkangu talpani Nau mara wutju nunkani kuraterina wonti, ja Nulu ngaltja matja worana, Nulu nina tali karakarana wonti. ");
INSERT INTO dif_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ja Nulu pariwilpa najina tarana wonti ja ngatjina wonti ja jatani wonti nunkangu: „Ephata“, jenia wondrai: „Biririau!“ ");
INSERT INTO dif_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ja nurujeli nau talpa biririna wonti, ja nau tali walto pantjina wonti, ja nau talku jatana wonti. ");
INSERT INTO dif_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ja Nulu tanangu jirijiribana wonti, wata jenia kanani kaukaubala; ja worderu morla Nulu daudauana wonti, jeruja morla tanali jenia kaukaubana wonti. ");
INSERT INTO dif_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ja tana pirna ngaruparana wonti ja jatana wonti: „Warupoto Nulia ngumu ngankai; talpakuru Nulia ngankai ngarananto ja ngapu jatananto.“ ");
INSERT INTO dif_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tanangupini ditjini kana wolara pirna naka nganana wonti, ja ngangau tanali panila ngamalkana wonti tajila, Jesujeli mili nunkani karkana wonti ja tanangu jatana wonti: ");
INSERT INTO dif_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","„Ngani kana wolarani kalumiltjamiltjariai, ngangau ditji parkulu tanaia ngakangunto ngamana warai, ja tanali panila ngamalkai tajila; ");
INSERT INTO dif_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ja ngato tananaia ngakangundru maua jinpanani nguraia tananaia, tanaia paltuni wariwariati; ngangau palpa tanangundru woritandru wokarala wiri.“ ");
INSERT INTO dif_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ja milieli nunkanali kalabana wonti nunkangu: „Wodajerindru kulnujeli buka maninanto ninkida pitarani, tananaia jerto ngankala?“ ");
INSERT INTO dif_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ja Nulu tanana jakalkana wonti: „Worderuntja buka ngunku jura ngamalkai?“ Tana jatana wonti: „Mara wora ja mandrumata.“ ");
INSERT INTO dif_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ja Nulu kana wolarani jirijiribana wonti mitani ngamana ngarinanto. Ja Nulu buka ngunku mara wora ja mandru patana wonti, ja tanana ngurungutana wonti ja wokaribana wonti ja milini nunkanani jinkina wonti, tanali tanangu jinkinanto; ja tanali kana wolarani jinkina wonti. ");
INSERT INTO dif_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ja tanali bakana paru wakawaka ngalje ngamalkana wonti; ja Nulu tanana ngurungutana wonti ja jirijiribana wonti, tananapini bakana jinkinanto. ");
INSERT INTO dif_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ja tanali tajina wonti ja jerturina wonti; ja tanali buka worduwordu kampana wonti billi mara wora ja mandru. ");
INSERT INTO dif_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ja tanali matja tajina 4000 nganana wonti; ja Nulu tanana jinpana wonti. ");
INSERT INTO dif_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ja nurujeli Nau milini nunkanani jela botani wirina wonti, ja Dalmanutha mitani wokarana wonti. ");
INSERT INTO dif_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ja Pharisaia dunkana wonti ja wonina wonti nunkangu jela jakalkijiribamalila, ja ngantjana wonti nunkangundru malka kulno pariwilpandru najila, nina wontjala. ");
INSERT INTO dif_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ja Nau Jaolali nunkanali ngaurongauro plrna pantjina wonti ja jatana wonti: „Minandru nulupini ngujali malka kulno ngundrai? Morlalu ngani jurangu jatai: Nulupini ngujali wata malka kulno manila nganai.“ ");
INSERT INTO dif_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ja Nulu tanana worarana wonti, ja nakaldra botani wirina wonti, ja dirkalaia jerankaria pararana wonti. ");
INSERT INTO dif_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ja tana kuritarana wonti buka padakala, ja tanali botani windri buka ngunku kulno ngamalkana wonti. ");
INSERT INTO dif_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ja Nulu tanangu jirijiribana wonti ja jatana wonti: „Najianau ja ngamalkaterianau Pharisaiaia pulkurutjeribani bukandru, ja Herodini pulkurutjeribani bukandru.“ ");
INSERT INTO dif_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ja tana ngankamalina wonti ja jatana wonti: „Jenia Nauja jatai, ngangau ngaiana wata buka padakana warai.“ ");
INSERT INTO dif_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ja Jesujeli jenia ngujamana, Nau tanangu jatana wonti: „Minandru jura ngankamaliai ngangau jura buka pani ngamalkai? Jura wata ngundrai ja bakana wata ngujamai? Jura kararilu ngara ngurunguru nganai? ");
INSERT INTO dif_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Jura milki ngamalkai ja wata najiai? Jura talpa ngamalkai ja wata ngarai? Ja jura wata mangatandra wilpariai? ");
INSERT INTO dif_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ngato buka ngunku mara wora 5000 materani matja wokaribana, worderuntja billi buka worduwordujeli manamiri jura kampana paraia?“ Tana nunkangu jatana wonti: „Marapratjana ja mandrumata.“ ");
INSERT INTO dif_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ngato buka ngunku mara wora ja mandru 4000 materani matja wokaribana, worderuntja billi buka worduwordujeli manamiri jura kampala wiri? Ja tana jatana wonti: „Mara wora ja mandrumata.“ ");
INSERT INTO dif_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ja Nau tanangu jatana wonti: „Worderu jura wata ngujamai?“ ");
INSERT INTO dif_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ja Nau Bethsaida wokarana wonti; ja tanali nunkangu butju kulno wokaralkana wonti ja nunkangu ngatjina wonti, Nulu nina karakarananto. ");
INSERT INTO dif_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ja Nulu kana butju mara patana wonti, ja nina ngurandru tjirimalkingana wonti; ja Nulu nunkangu milkini ngaltja worana wonti, ja Nau nunkangu mara kuraterina wonti ja nina jakalkana wonti: „Jundru palpa najiai?“ ");
INSERT INTO dif_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ja Nulu najina tarana wonti ja jatana wonti: „Ngato kana worana najiai, ngangau pita jeribaka ngato tana najiai, tana wapanani.“ ");
INSERT INTO dif_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ngadani Nau nakaldra mara nunkangu milkini kuraterina wonti ja nunkangu jirijiribana wonti, nulu najina tarananto; ja nau nakaldra tepi pantjina wonti, ja worita pratjana talku najina wonti. ");
INSERT INTO dif_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ja Nulu nina pungaia nunkanaia jinpana wonti ja jatana wonti: „Wata ngurani wiriau, ja wata kulnuni jenia jatau ngurani.“ ");
INSERT INTO dif_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ja Jesus ja mili nunkani wapana wonti ngura wakaia Cäsarea Philippini karakara. Ja paltuni Nulu mili nunkani jakalkingana wonti ja tanangu jatana wonti: „Mina kana jatai, worana ngani nganai?“ ");
INSERT INTO dif_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Tanali kalabana wonti: „Johannes multibanietja; ja palpa: Elias; ja palpa: Propheta kulno.“ ");
INSERT INTO dif_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ja Nau tanangu jatana wonti: „Mina jura jatai, worana ngani nganai?“ Petrulu kalabana wonti ja nunkangu jatana wonti: „Jidni Christus nganai.“ ");
INSERT INTO dif_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ja Nulu tanana daudauana wonti, tanali wata nunkangundru kulnuni kaukaubananto. ");
INSERT INTO dif_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ja Nulu wonina wonti tanangu ngujangujara jinkila: „Kanaia Ngatamura pirna ketjaketjananto, ja pinaru worali, ja Priesta pirna worali, ja jaura jinkinietja worali nina worananto ja nari ngankananto, ja ditjini parkulani Nau tepi terkakananto.“ ");
INSERT INTO dif_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ja Nulu talku ninapini jaura tanangu kaukaubana wonti. Ja Petrulu nina tjirimalkana wonti ja wonina wonti nina daudauala. ");
INSERT INTO dif_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Nulu najina karitjina mili nunkani najina wonti, ja Nulu Petrus daudauana wonti ja jatana wonti: „Ngakangu ngadaia nganamai, Satanajai! Ngangau jundru wata ngundrai mina Godaia nganai, a‐ai, windri mina kanaia.“ ");
INSERT INTO dif_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ja Nulu kana wolara milini nunkanani jela matja karkana, Nau tanangu jatana wonti: „Warle ngantjai, ngakangu karipaterila, nau munta panila ngundrateriatimai, ja nulu kunarku nunkani maniatimai ja ngakangu karipateriatimai. ");
INSERT INTO dif_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ngangau warle tepi nunkani ngantjai kulkala, nulu nina tintala nganai; ja warle tepi nunkani tintai ngakangundru ja ngantjani jaurandru, nulu nina mankamankala nganai. ");
INSERT INTO dif_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Jenia kanani ngumu nganai kara, nulu mita maru maninani, ja mungara nunkani tintaterinani? ");
INSERT INTO dif_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Mina kalala kanali jinkinanto kara mungarani nunkanani? ");
INSERT INTO dif_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ngangau worana ngakangundru ja ngakani jaurandru nintali nganai tanangupini nguja palakantjini ja madlentjani, nunkangundru bakana Kanaia Ngatamura nintali nganala nganai, Nauja wokarala nganai Ngaperaia nunkanaia pirnalani angela kulikirinto.“ ");
INSERT INTO dif_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ja Nau tanangu jatana wonti: „Morlalu ngani jurangu jatai: Tanangundru palpa ninkida terkala wapaia, tanalipini nari wata wontjala nganai, tanali Godaia milila ngurulali wokaranani najinantulu.“ ");
INSERT INTO dif_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ja ditji mara wora ja kulnuni Jesujeli Petrus ja Jakobus ja Johannes patana wonti, ja tanana pilki mardawonpa pirnaia miri taralkana wonti, kulno worana. Ja Nau njeranjerarina wonti tanangu milkini. ");
INSERT INTO dif_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ja kati nunkani kintjalkururina wonti, bulu pirna taleri jeribaka; jeruja kulirkanietja mitani ngandandariai tanana jeruja bulu ngankala. ");
INSERT INTO dif_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ja tanangu Elias Mosingunto wondraterina wonti; ja pudla Jesungu jela ngankamalina wonti. ");
INSERT INTO dif_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ja Petrulu kalabana wonti ja Jesungu jatana wonti: „Rabbi! Ninkida ngaianangu ngumu nganai; ja ngaiani punga parkulu ngankananto, jinkani kulno, ja Mosini kulno, ja Eliani kulno.“ ");
INSERT INTO dif_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ngangau nau ko nganana wonti mina nau jatananto, ngangau tana japali pirna nganana wonti. ");
INSERT INTO dif_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ja talarapalku pantjina wonti ja tanana walpadakana wonti; ja ngaiala talara palkundru dunkana wonti ja jatana wonti: „Naupini Ngatamura ngantjalu ngakani nganai, ninaia ngaraiatinimai!“ ");
INSERT INTO dif_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ja tanali najina karitjina wonti, ja nurujeli tanali kana pani najina wonti, windri Jesus kulnulu tanangunto. ");
INSERT INTO dif_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ja tana mardawonpandru ngarina tikana, Nulu tanangu jirijiribana wonti, jenia wata kulnuni kaukaubananto, mina tanali matja najina, windri ngadani, Kanaia Ngatamura narindru jiritjina warai. ");
INSERT INTO dif_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ja jenia jaura tanali patana wonti, ja tana jakalkijiribamalina wonti: „Mina jenia wondrai: Narindru jiritjina?“ ");
INSERT INTO dif_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ja tanali nina jakalkana wonti ja jatana wonti: „Jaura jinkinietja jatai: Elias ngopera wokarananto.“ ");
INSERT INTO dif_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Nulu kalabana wonti ja tanangu jatana wonti: „Elias wokarai, ja nulu ngopera pratjana talku kurai; ja worderu dakanala parai Kanaia Ngatamurandru; Nauja pirna ketjaketjananto, ja tanali ninaia panila ngundrananto.“ ");
INSERT INTO dif_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ngani jurangu jatai: „Elias morlalu wokarana warai, ja tanali nunkangu ngankana warai, mina tanali jertapaterina warai, worderu nunkangundru dakanala parai.“ ");
INSERT INTO dif_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ja Nau milini nunkanani wokarana wonti, ja Nulu kana wolara tanangunto najina wonti, ja jaura jinkinietjali tanana jakajakalkana wonti. ");
INSERT INTO dif_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ja nurujeli, kana wolarali nina matja najina, tana pirna ngaruparana wonti, ja tana karakararina wonti ja nunkangu jaura murlali jinkina wonti. ");
INSERT INTO dif_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ja Nulu jaura jinkinietja jakalkana wonti: „Mina jura tanangu jela jakalkijiribamaliai?“ ");
INSERT INTO dif_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ja kana wolarandru nunkangu kulnujeli kalabana wonti: „Ngujangujara jinkinietjajai, ngato ngatamura ngakani jinkangu wapalkana warai, nulia kutji ngapu ngamalkai; ");
INSERT INTO dif_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ja woderi nulia ninaia patai, jerra nulia ninaia diadialkai; ja nulia ngaltja ngankai ja manatandra matateriai ja winjariai; ja ngani milini jinkanani jatana warai, tanalia ninaia dunkalkananto, ja tanaia ngandandarina warai.“ ");
INSERT INTO dif_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Nulu tanangu kalabana wonti ja jatana wonti: „Jura nguja gilbarinietja, wintaranaia ngani jurangu jela nganananto, wintaranaia ngato jurana ngamalkananto? Ninaia ngakangu padakanimai!“ ");
INSERT INTO dif_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ja tanali nina nunkangu wapalkana wonti; ja Nulu nina najina, nurujeli kutjieli nina matarla ngankana wonti, ja nau mitani purina wonti ja ngaltja witjiwitji walkina wonti. ");
INSERT INTO dif_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ja Nulu ngaperi nunkani jakalkana wonti: „Winta jenia nunkangu pantjinala?“ Nau jatana wonti: „Kupandru,“ ");
INSERT INTO dif_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ja nulu nina pota marapu bakana turuni ja ngapani worai, nina nari ngankala. Windri jidni ngurunguru ngananani, kalumiltjamiltjarina ngalina marangokau. ");
INSERT INTO dif_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesus nunkangu jatana wonti: „Jundru ngurunguru ngananani morlalu ngundrala; warle morlalu ngundrai nunkangu panila ngandandariai.“ ");
INSERT INTO dif_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ja nurujeli kankuja ngaperi maritjina wonti, ja milkigildieli jatana wonti: „Ngato morlalu ngundrai, Kaparajai, marangokau ngakangu wuldrungundranietjani.“ ");
INSERT INTO dif_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesujeli najina, kana wolara jurborinani, Nulu katji murumuru dikidikibana wonti ja nunkangu jatana wonti: „Jidni kutji tali pani ja ngapu, ngato jinkangu jirijiribai, nunkangundru dunkau, ja wata morla nunkangu wiriau!“ ");
INSERT INTO dif_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ja nau maritjina wonti, ja nulu nina pirna diadialkana wonti, ja nau dunkana wonti; ja nau nari jeribaka nganana wonti, jeruja marapu jatana wonti: „Nauja matja nari.“ ");
INSERT INTO dif_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jesujeli nina mara patana wonti, ja nina terkibana tarana wonti, ja nau jiritjina wonti. ");
INSERT INTO dif_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ja Nau pungani matja wirina, milieli nunkanali nina pilki jekibana wonti: „Miandru ngaiani ngandandarina warai ninaia dunkalkala?“ ");
INSERT INTO dif_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ja Nau tanangu jatana wonti: „Naupara nguja ngandandariai pilki dunkala, windri ngatjinali ja milja ngamanali.“ ");
INSERT INTO dif_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ja tana nakandru wapana wonti ja Galilaiani palkingana wonti; ja Nulu wata ngantjana wonti kulnujeli jenia ngujamananto. ");
INSERT INTO dif_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ngangau Nulu milini nunkanani ngujangujara jinkina wonti ja tanangu jatana wonti: „Tanali Kanaia Ngatamura kana marani ngulkujeli jinkila nganai, ja tanali ninaia nari ngankala nganai, ja matja nari, Nauja jiritjila nganai.“ ");
INSERT INTO dif_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Tanali jenia jaura wata ngujamana wonti ja japali nganana wonti nina jakalkala. ");
INSERT INTO dif_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ja Nau Kapernaum ngurani wokarana wonti. Ja Nau matja pungani, Nulu tanana jakalkana wonti: „Mina jura paltuni ngankamalina warai?“ ");
INSERT INTO dif_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Tana ngapu nganana wonti; ngangau tana paltuni ngankamalina warai, worana morla pirna nganai. ");
INSERT INTO dif_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ja Nau matja ngamana ngarina, Nulu tanana marapratjana ja mandru karkana wonti ja tanangu jatana wonti: „kulnujeli ngantjanani ngoperala nganala, nau pratjanani ngadaia nganala nganai, ja pratjanaia mili.“ ");
INSERT INTO dif_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ja Nulu kupa waka patana wonti ja tanangu terti terkibana wonti; ja Nulu nina matja munamana, Nau tanangu jatana wonti: ");
INSERT INTO dif_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","„Warle jenipara kupa waka kulno patai ngakani talani, nulu ngana patai; ja warle ngana patai, wata ngana patai, a‐ai, ninaia Nulia ngana jinpanala.“ ");
INSERT INTO dif_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Johannili nunkangu kalabana wonti ja jatana wonti: „Ngujangujara jinkinietjajai, ngaiani kulno najina paraia jinkani talani kutji dunkalkanani, nau ngaianingu wata karipateriai; ja ngaiani nina daudauana paraia, ngangau nau ngaianingu wata karipateriai.“ ");
INSERT INTO dif_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesus jatana wonti: „Wata nina daudauanimai, ngangau wata kulno nganai, nulu ngurula ngankala nganai ngakani talani, ja wolja ngakangu madlentji jatala nganai. ");
INSERT INTO dif_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ngangau worana wata tula ngaianani nganai, nau kamaneli ngaianani nganai. ");
INSERT INTO dif_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ngangau warle jurangu ngapa koko kulno jinkiai tapananto ngakani talani, ngangau jura Christuja mili nganai, morlalu ngani jurangu jatai: Nulu kalala nunkani wata tintala nganai. ");
INSERT INTO dif_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ja warle tanangundru kulno wakawaka, ngakangu morlalu ngundranani, karkarkai, nunkangu ngumu nganai, marda wati jerkalani nunkanani kurananto, ja nina panto mandrani worananto. ");
INSERT INTO dif_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ja marali jidnana karkarkanani, ninaia wokaribamai; jinkangu ngumu nganai nguna wordu tepini wirila, jidni mara mandrunto kara turuja wiriati, nauja ngurali jerkiai. ");
INSERT INTO dif_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Jerra tanani burka wata paliai ja turu wata mudai. ");
INSERT INTO dif_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ja tidnali jidnana karkarkanani, ninaia wokaribamai; jinkangu ngumu nganai, tidna wordu tepini wirila, jidni tidna mandrunto turuja wiriati, nauja ngurali jerkiai. ");
INSERT INTO dif_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Jerra burka tanani wata paliai ja turu wata mudai. ");
INSERT INTO dif_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ja milkieli jidnana karkarkanani, ninaia dukarau; ngumu jinkangu nganai milki kulnunto Godaia mililani wirila, jidni milki mandrunto turuja wiriati. ");
INSERT INTO dif_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Jerra burka tanani wata paliai ja turu wata mudai. ");
INSERT INTO dif_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Pratjana tanali turujeli wiribala nganai, ja poto ngumu pratjana tanali kaldrieli wiribala nganai. ");
INSERT INTO dif_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Kaldri ngumu nganai; kaldri wata morla kaldri ngananani, minali jura ninaia ngankingala nganai? Kaldri jurangunto ngamalkanimai, ja murlali ngamalkijiribamalianimai!“ ");
INSERT INTO dif_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ja Nau nakandru puntina wonti ja Judaia wondirani wokarana wonti, ja mitani Jordan kaiari jerankari palkingana wonti; ja nakaldra kana wolara nunkangu jurborina wonti, ja worderu Nulu milingeru ngankana wonti, Nulu nakaldra tanangu ngujangujara jinkina wonti. ");
INSERT INTO dif_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ja Pharisaia nunkangu wokarana wonti nina wontjala, ja tanali nina jakalkana wonti, jenia talku nganai kana kulnuni noa nunkani worarala. ");
INSERT INTO dif_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Nulu kalabana wonti ja tanangu jatana wonti: „Mina Mosili jurangu jirijiribana wonti?“ ");
INSERT INTO dif_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Tana jatana wonti: „Mosili manuni kurana wonti puntibani dakani jaura dakala ja nana worarala.“ ");
INSERT INTO dif_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ja Jesujeli kalabana wonti ja tanangu jatana wonti: „Jurani ngara ngurungurundru nulu jurangu ninapini jirijiribani jaura dakana wonti. ");
INSERT INTO dif_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ngopera pantjimanandru Godali tanana materi ja widla pantjimana wonti. ");
INSERT INTO dif_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Jendrania kana kulnujeli ngaperi nunkani ja ngandri nunkani worarala nganai, ja noani nunkanani jela ngamala nganai. ");
INSERT INTO dif_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ja pudla palku kulno nganala nganai. Jendrania pudla wata morla mandru, a‐ai, windri palku kulno nganai. ");
INSERT INTO dif_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Mina Godali matja ngokana, kanali wata puntibananto.“ ");
INSERT INTO dif_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ja pungani nina nakaldra milieli nunkanali jendrangundruja jakalkana wonti. ");
INSERT INTO dif_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ja Nau tanangu jatana wonti: „Warle noa nunkani woraranani ja noa nguru patanani, nulu nankangu pinta wokaribai; ");
INSERT INTO dif_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ja widlali noa nankani woraranani ja noa nguru patanani, nandru pinta wokaribai.“ ");
INSERT INTO dif_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ja tanali kupa waka nunkangu padakana wonti, Nulu tanana karakarananto; milieli tanana daudauana wonti, tanali tanana padakanani. ");
INSERT INTO dif_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesujeli jenia najina, Nau kaldririna wonti ja tauangu jatana wonti: „Kupa worani patanau, ja wata daudauanau tanana ngakangu wokarananto; ngangau tanangu Godaia milila nganai. ");
INSERT INTO dif_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Morlalu ngani jurangu jatai: Warle Godaia milila wata patai kupa wakali jeribaka, nau wata nunkangu wirila nganai.“ ");
INSERT INTO dif_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ja Nulu tanana matja munamana, Nau tanangu mara kuraterina wonti ja tanana ngurungutana wonti. ");
INSERT INTO dif_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ja Nau dunkana kurana wonti paltuja, kulno nunkangu mindrina wonti ja nunkangu pantjaterkana ngarina wonti ja nina jakalkana wonti: „Ngujangujara jinkinietja ngumujai, mina ngato ngankananto tepi ngurali manila?“ ");
INSERT INTO dif_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesus nunkangu jatana wonti: „Minandru jundru ngana ngumu dikai? Wata kulno ngumu nganai, windri Goda kulnulu. ");
INSERT INTO dif_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Jirijiribani jaura jidni milkila: Wata pinta wokaribamai; wata narielu nandramai; wata kurieli maniamai, wata jedi jaura morlalu jatamai; wata watawatali maniamai; ngaperi jinkani ja ngandri jinkani pirna ngundramai.“ ");
INSERT INTO dif_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nulu kalabana wonti ja nunkangu jatana wonti: „Ngujangujara jinkinietjajai, jenia pratjana ngato ngamalkai kupandru.“ ");
INSERT INTO dif_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesujeli nina najina, Nulu nina ngantjana wonti ja nunkangu jatana wonti: „Kulno jundru wata ngamalkai; wapau, pratjana mina jundru ngamalkai, jinkiau kalalaiai, ja wangiwangini bakujeli jinkiau, ja jundru poto pirna pariwilpani ngamalkala nganai; ja ninkidani tikau, ngakangu karipateriau, kunarku maniau.“ ");
INSERT INTO dif_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nau jenia jaurandru ngaurongauro pantjina wonti, ja ngaurongaurojeli wapana wonti; ngangau nau poto pirna nganana wonti. ");
INSERT INTO dif_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ja Jesujeli najina karitjina wonti ja milini nunkanani jatana wonti: „Jenia mati nganai, tana poto pirna Godaia mililani wirinanto.“ ");
INSERT INTO dif_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Mili nunkani jaurandru pirna ngaruparana wonti. Jesujeli nakaldra kalabana wonti ja tanangu jatana wonti: „Kupa worai, worderu mati jenia nganai tanangu, tana potuni manujeli ngundranani Godaia mililani wirila. ");
INSERT INTO dif_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Morla ngaua nganai, Camuli kulno kuri pikiri wilpani palkingananto kana poto pirnani, nau Godaia mililani wirinanto.“ ");
INSERT INTO dif_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Tana morla pirna ngaruparana wonti ja ngankamalina wonti: „Warlengarla tepita manila nganai?“ ");
INSERT INTO dif_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesujeli tanana najina wonti ja jatana wonti: „Kana ngandandariai, ngarla Godata wata ngandandariai; ngangau Godani pratjana wata ngandandariai.“ ");
INSERT INTO dif_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Petrulu wonina wonti nunkangu jatala: „Mai, ngaiani pratjana woraranala ja jinkangu karipaterinala!“ ");
INSERT INTO dif_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesujeli kalabana wonti ja jatana wonti, morlalu ngani jurangu jatai: „Wata kulno nganai nulu worarana warai punga kara, nejingatata worana kara, kaku worana kara, ngaperi kara, ngandri kara, noa kara, kupa worana kara, mita worana kara ngakangundru ja ngantjani jaurandru. ");
INSERT INTO dif_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Nulu wata maninani 100 potajeli karari nunkangupini mitani punga worana ja ngatata worana ja kaku worana ja ngandri worana ja kupa worana ja mita worana tirikaripaterinali jela, ja ngadani tepi ngurali. ");
INSERT INTO dif_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Marapu ngoperala ngadaia nganala nganai, ja ngadala ngopera nganala nganai.“ ");
INSERT INTO dif_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Tana paltuni nganana wonti Jerusalemia tarala; ja Jesus tanangu ngopera nganingana wonti, ja tana ngaruparana wonti, ja tana nunkangu karipaterina japali pantjina wonti. Ja nulu nakaldra mili marapratjana ja mandruni manduringana wonti ja wonina wonti tanangu jatala, worderu nunkangu ngadani pantjinanto: ");
INSERT INTO dif_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","„Mai, ngaiana Jerusalemia tarala wapaia, ja tanali Kanaia Ngatamura Priesta pirnani ja jaura jinkinietjani ngulkujeli jinkila nganai, ja tanali ninaia naria kurala nganai ja ninaia kana koni ngulkujeli jinkila nganai. ");
INSERT INTO dif_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ja tanali ninaia ngirkibala nganai ja nandrala nganai, ja nunkangu ngaltja worala nganai, ja ninaia nari ngankala nganai; ja ditjini parkulani Nauja jiritjila nganai.“ ");
INSERT INTO dif_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ja nunkangu Jakobus ja Johannes Zebedäuni ngatamura wokarana wonti ja nunkangu jatana wonti: „Ngujagujara jinkinietjajai, ngali ngantjai, jundru ngalina jinkinanto minakulno ngali jinkangu ngatjiai.“ ");
INSERT INTO dif_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Nau pudlangu jatana wonti: „Mina judla ngantjai, ngato judlangu ngankananto?“ ");
INSERT INTO dif_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Pudla nunkangu jatana wonti: „Ngalingu kurau, kulno jinkangu ngunarani ja kulno jinkangu worangantjuni pirnalani jinkanani ngamananto.“ ");
INSERT INTO dif_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesus pudlangu jatana wonti: „Judla ngurunguru nganai, nunkangupini kokundru topala nina ngato tapai; ja nina multibanila manila, nina multibanila ngato maninanto?“ ");
INSERT INTO dif_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Pudla nunkangu jatana wonti: „Kauna, ngali ngurunguru nganai.“ Jesus pudlangu jatana wonti: „Nina koko ninapini ngato tapai, judla tapala nganai; ja nina multibanila, nina ngato maninanto, judla manila nganai; ");
INSERT INTO dif_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Windri ngamana ngunarani ngakanani ja worangantjuni ngakanani jinkila, wata poto ngakani nganai, a‐ai, windri tanangu, worangu matja ngankingana.“ ");
INSERT INTO dif_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ja mili marapratjanali jenia ngarana, tana junkarina wonti Jakobungu ja Johanningu. ");
INSERT INTO dif_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesujeli tana karkana wonti ja tanangu jatana wonti: „Jura milkila, kana wolaraia kaparali tanangu jirijiribai, ja tanani kana pirnali tanana jupai. ");
INSERT INTO dif_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Jeruja wata jurangu nganaiatimai; a‐ai, warle jurangundru ngantjai pirna pantjila, nau mili jurani nganaiatimai. ");
INSERT INTO dif_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ja warle jurangundru ngantjai ngoperala nganala, nau pratjanaia mili nganaiatimai. ");
INSERT INTO dif_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ngangau bakana Kanaia Ngatamura wata wokarana warai mili ngamalkala, a‐ai, mili nganala, ja tepi nunkani jinkiterila kalala marapuja.“ ");
INSERT INTO dif_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ja tana Jericho ngurani wokarana wonti. Ja Nau, ja mili nunkani, ja kana wolara Jerichundru dunkana, Timäiuni ngatamura, Bartimäus, butju paltuni ngamana wonti potuni ngatjila. ");
INSERT INTO dif_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ja nulu matja ngarana, Jesus Nazarenala Nauja nganai, nulu wonina wonti maritjila ja jatala: „Jesujai, Davidani ngatamurajai, ngakangu kalumiltjamiltjariau!“ ");
INSERT INTO dif_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ja marapujeli nina daudauana wonti nau ngapurinanto; ja nau morla parparali maritjina wonti: „Davidani ngatamurajai, ngakangu kulumiltjamiltjariau!“ ");
INSERT INTO dif_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ja Jesus banbana wonti ja jatana wonti: „Ninaia karkanau!“ Ja tanali nina kana butju karkana wonti ja nunkangu jatana wonti: „Murlali nganamai, terkakamai, Nulia jidna karkai!“ ");
INSERT INTO dif_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Nulu kati nunkani worarana wonti ja terkakana wonti ja Jesungu wokarana wonti. ");
INSERT INTO dif_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ja Jesujeli kalabana wonti ja nunkangu jatana wonti: „Mina jundru ngantjai ngato jinkangu ngankananto?“ Kana butju nunkangu jatana wonti: „Rabbuniai, ngato nakaldra najinanto!“ ");
INSERT INTO dif_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesus nunkangu jatana wonti: „Wapau morlalu ngundranali jinkanali jidnana tepi ngankana warai.“ Ja nurujeli nulu nakaldra najina wonti, ja nau Jesungu paltuni karipaterina wonti. ");
INSERT INTO dif_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ja tana Jerusalemingu karakara wokaranani, Bethphagingu ja Bethaniangu mani nindri mardawonpani, Nulu mili nunkani mandru jinpana wonti. ");
INSERT INTO dif_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ja pudlangu jatana wonti: „Wapalumai nunkangupini ngura waka judlangunkari, ja nurujeli judla nunkangu wirinani, judla donki kuparu workamantraterinani mankamankala nganai, nunkangupini wata kana kulno dukaterina warai; nina dukaralumai, ja tikalkalumai!“ ");
INSERT INTO dif_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ja kulno judlangu jatanani: „Ninandru judla jenia ngankai?“ Judla jatalumai: „Kaparali ninaia karkai“; ja nurujeli nulu nina jinpala nganai. ");
INSERT INTO dif_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Pudla wapana wonti ja donki kuparu mankamankana wonti manani workamantraterinani, palarani woderi palto karitjiai; ja pudlali nina dukarana wonti. ");
INSERT INTO dif_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ja palpa tanangundru jerra terkana, pudlangu jatana wonti: „Mina judla ngankai, donki kuparu judla dukarai?“ ");
INSERT INTO dif_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Pudla tanangu jatana wonti worderu Jesujeli jirijiribana warai, ja tanali pudlangu manuni kurana wonti. ");
INSERT INTO dif_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ja pudlali donki kuparu Jesungu tikalkana wonti, ja tanali kati tanani nunkangu kurana wonti, ja nina kurana tarana wonti. ");
INSERT INTO dif_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Marapujeli kati tanani paltuni jaupana wonti, kana ngurujeli ngunanguna pitandru wokaribana wonti, ja tanana paltuni jaupana wonti. ");
INSERT INTO dif_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ja tana ngopera wapana wonti ja karipaterina wonti maritjina wonti ja jatani wonti: „Hosiana, ngaiani jurakokai ninaia, Nauja wokarai Kaparaia talani: ");
INSERT INTO dif_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ngaiani jurakokai Ngaperaia ngaiananaia Davidani milila nauja wokarai! Hosiana mirini!“ ");
INSERT INTO dif_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ja Jesus Jerusalemingu ja jaura pungani wirina wonti. Ja Nulu pratjana matja najinajibana, ja matja kalkaurarina, Nau Bethaniaia wapana wonti marapratjana ja mandrunto. ");
INSERT INTO dif_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ja tana tankubana Bethaniandru dunkana kurana, Nau mauali nganana wonti. ");
INSERT INTO dif_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ja Nulu woritandru tandraia nindri kulno talpanto najina wonti, ja Nau nunkangu wokarana wonti, Nulu palpa nunkangu mankamankananto; ja Nau nunkangu matja wokarana, Nulu panila mankamankana wonti windri talpa; ngangau jendranguta wata tandraia miljaru nganana wonti. ");
INSERT INTO dif_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ja Jesujeli kalabana wonti ja nunkangu jatana wonti: „Ngurali wata morla kulnujeli jinkangundru tandra tajinanto.“ Ja milieli jenia ngarana wonti. ");
INSERT INTO dif_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ja tana Jerusalemingu wokarana wonti. Ja Jesus Godaia pungani wirina wonti, ja Nulu wonina wonti tanana narrala, tanali Godaia pungani jinkimalina wonti ja burungankana wonti, ja Nulu mardatandrakaritjimalkanietjaia kurli ja mulapara burungankanietjaia ngamana piri kokulterkibana wonti. ");
INSERT INTO dif_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ja Nulu wata manuni kurana wonti kulnujeli koko Godaia pungani palkingalkananto. ");
INSERT INTO dif_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ja Nulu ngujangujara jinkina wonti ja tanangu jatana wonti: „Wata dakanala parai: Tanali punga ngakani ngatjini punga dikananto kanani warupotuni? Ja jura ninaia watawatali maninietjaia minka ngankala wapaia.“ ");
INSERT INTO dif_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ja jaura jinkinietjali ja Priesta pirnali jenia ngarana wonti, ja wontina wonti worderu tanali nina nari ngankananto; ngangau tana japali nganana wonti nunkangundru, ngangau kana wolara pirna ngaruparana wonti nunkani ngujangujarandru. ");
INSERT INTO dif_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ja matja kalkaurarina, tana ngurandru dunkana kurana wonti. ");
INSERT INTO dif_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ja tankubana palkara tana wiringana, tanali najingana wonti tandraia nindri mujarina warai kaparajelu. ");
INSERT INTO dif_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ja Petrulu jenia ngundrana nunkangu jatana wonti: „Rabbi, najiau! Naupini tandraia nindri, ninaia jundru dikidikibala wiri, mujarina warai.“ ");
INSERT INTO dif_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ja Jesujeli kalabana wonti ja tanangu jatana wonti: „Godani morlalu ngundranau! ");
INSERT INTO dif_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ngangau morlalu ngani jurangu jatai: Kulno nunkangupini mardawonpani jatanani: Dukarateriamai ja ngapa pirnani worateriamai, ja nau ngarani nunkanani wata mangangankanani, a‐ai, windri morlalu ngundranani, jenia pantjinani, mina nau jatai, nunkangu pantjila nganai, mina nau jatai. ");
INSERT INTO dif_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Jendrania ngani jurangu jatai: Pratjana mina jura ngatjinani juranani ngatjiai, morlalu ngundranau jura jenia maninanto, ja jura jenia manila nganai. ");
INSERT INTO dif_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ja jura terkanani ngatjila, worani patanau mina jura kulnuni ngamalkai; ngangau bakana Ngaperali juranali pariwilpani madlentji jurani worani patananto. ");
INSERT INTO dif_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Jura wata worani patanani, jeruja bakana Ngaperali juranali pariwilpani madlentji jurani wata worani patala nganai.“ ");
INSERT INTO dif_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ja tana nakaldra Jerusalemingu wokarana wonti. Ja Nau Godaia pungani wirarinani, Priesta pirna ja jaura jinkinietja ja pinaru nunkangu wokarana wonti, ");
INSERT INTO dif_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ja nunkangu jatana wonti: „Mina ngurulali jundru jenia ngankai, ja warle jinkangu ninapini ngurula jinkina warai jenia ngankananto?“ ");
INSERT INTO dif_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesujeli kalabana wonti ja tanangu jatana wonti: „Bakana ngato jurana jaura kulno jakalkala nganai, ja jura ngakangu kalabananto; ja ngani jurangu jatala nganai, mina ngurulali ngato jenia ngankai. ");
INSERT INTO dif_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Johanini multibanila pariwilpandru kara, kanandru kara nganana wonti? Ngakangu kalabanau!“ ");
INSERT INTO dif_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ja tana tjurujeli ngundrana wonti ja jatana wonti: Ngaiani jatanani, pariwilpandru, Nauja ngaianingu jatala nganai: Minandru jura nunkangu wata morlalu ngundrana wonti? ");
INSERT INTO dif_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ngaiani jatanani, kanandru, ngaiani kana wolarandru japali nganananto, ngangau tanali marapujeli Johannes Propheta patai. ");
INSERT INTO dif_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ja tanali Jesungu kalabana wonti ja jatana wonti: „Ngaiani ko.“ Ja Jesus tanangu kalabana wonti ja jatana wonti: „Jeruja bakana ngani jurangu wata jatai, mina ngurulali ngato jenia ngankai.“ ");
INSERT INTO dif_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ja Nulu wonina wonti tanangu jeribaka jaurali jatala: „Kana kulno wain maru kurana wonti, ja nulu pita terkibana karitjina wonti, ja wain nankani kutu bakuna wonti, ja punga wutju wotina wonti, ja nina marunajinajibanietja worangu worarana wonti, ja wapana wonti worita. ");
INSERT INTO dif_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ja nulu najinajibanietja worangu miljaru talkuni mili kulno jinpana wonti, nulu najinajibanietja worangundru maruja tandrandru manijiribananto. ");
INSERT INTO dif_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Tanali nina patana wonti ja nina nandrana wonti ja mara kala jinpana wonti. ");
INSERT INTO dif_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ja nakaldra nulu tanangu mili nguru jinpana wonti; ja nina mangatandra tanali mardali diana wonti, ja nina matja ngirkibana, jinpana wonti. ");
INSERT INTO dif_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ja nakaldra nulu kulno nguru jinpana wonti; ja nina tanali nari ngankana wonti, ja marapu morla, tanangundru tanali palpa nandrana wonti, palpa nari ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Nulu windri ngatamura kunakulno ngantjalu morla ngamalkana wonti, ju nulu nina ngadani tanangu jinpana wonti ja jatana wonti: «Tana ngakani ngatamurani warawararila nganai.» ");
INSERT INTO dif_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Tana maru najinajibanietja ngankamalina wonti: «Naupini maratunkaia; kaparanau, ninaia ngaiana nari nandrananto maratunka nunkani ngaianani nganananto.» ");
INSERT INTO dif_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ja tanali nina patana wonti ja nari ngankana wonti, ja nina wain marundru palarani worana wonti. ");
INSERT INTO dif_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Mina wain maruja kaparali ngankala nganai? Nau wokarala nganai, ja nulu maru najinajibanietja nari ngakala nganai ja wain maru nguruni jinkila nganai. ");
INSERT INTO dif_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Jura wata ninapini jaura warapanala: «Naupini marda, nina wotinietjali worana wonti, nau marda buru pantjina wonti; ");
INSERT INTO dif_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Kaparandru nau jenia pantjina wonti, ja ngaianangu milkini ngaruparana pirna nganai.»“ ");
INSERT INTO dif_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ja tanali wontina wonti nina patala, windri tana kana wolarandru japali nganana wonti, ngangau tanali ngujamana wonti, Nulu tanangundru ninapini jeribaka jaura jatana warai. Ja tanali nina worarana wonti ja wapana wonti. ");
INSERT INTO dif_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ja tanali nunkangu Pharisaia palpa ja Herodini mili palpa jinpana wonti, tanali nina patananto jaurani nunkanani. ");
INSERT INTO dif_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Tana wokarana wonti ja nunkangu jatana wonti: „Ngujangujara jinkinietjajai, ngaiani milkila, jidni morlalu nganai, ja jidni manubaku nganai kanani; ngangau jundru wata kana mudla ngundrai, a‐ai, jundru morlalu Godaia paltundru ngujangujara jinkiai; jenia talku nganai mitaia kaparani kalala jinkila kara, pani kara? Ngaiani jinkinanto kara, wata jinkinanto kara?“ ");
INSERT INTO dif_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nulu tanana jeljujelju matja ngujamana, Nau tanangu jatana wonti: „Minandru jura ngana wontjai? Padakanau ngakangu kalalaia mardatandra kulno, ngato nina najinanto!“ ");
INSERT INTO dif_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Tanali kulno jinkina wonti. Ja Nau tanangu jatana wonti: „Waninunkani mudla naupini nganai, ja mina jaura dirkalani parai?“ Tana nunkangu jatana wonti: „Mitaia kaparaia.“ ");
INSERT INTO dif_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ja Jesujeli kalabana wonti ja jatana wonti: „Jinkianau kaparaia poto kaparani ja Godaia poto Godani!“ Ja tana nunkangundru pirna ngaruparana wonti. ");
INSERT INTO dif_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ja Sadducaia nunkangu wokarana wonti, tanaia jatai: „Narila wata morla jiritjila nganai“, ja nina jakalkana wonti ja jatana wonti: ");
INSERT INTO dif_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","„Ngujangujara jinkinietjajai, Mosili ngaianingu dakana wonti: «Kana kulnuja neji palinani, ja noa nunkani woraranani, ja kupa pani woraranani, ngatatajeli nunkanali noa nunkani patananto ja nejini nunkanani ngatamura jiritjibananto.» ");
INSERT INTO dif_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Neji mara wora ja mandru nganana wonti. Ja ngoperalali noa patana wonti, ja nau matja palina, ngatamura pani worarana wonti; ");
INSERT INTO dif_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ja mandrulali nana noa patana wonti ja palina wonti; ja parkulali bakana jeruja; ");
INSERT INTO dif_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ja nana tanali mara wora ja mandrujeli noa patana wonti, ja ngatamura pani worarana wonti. Pratjaterinani ngadani bakana widla palina wonti. ");
INSERT INTO dif_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Terkakani ditjini, tana matja jiritjina, waninunkani noa tanangundru nani nganala nganai, ngangau mara wora ja mandrujeli nana ngamalkana wonti?“ ");
INSERT INTO dif_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ja Jesujeli kalabana wonti ja tanangu jatana wonti: „Wata jura jendrangundruja tjautjau ngundranau, ngangau jura jaura worana ja bakana Godaia ngurula wata ngujamai? ");
INSERT INTO dif_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ngangau tana narindru matja jiritjina, tanali wata morla noa patai ja noa pantjiai, a‐ai, tana angela jeribaka nganai, tana pariwilpani nganai. ");
INSERT INTO dif_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Narilandru, tana tepi terkalala nganai, jura wata Mosini dakani jaurani warapana warai, worderu dilka nindrini Godali nunkangu kaukaubana wonti ja jatana wonti: «Ngani Abrahamani Goda ja Isaakani Goda ja Jakobani Goda?» ");
INSERT INTO dif_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Goda wata naria Goda, a‐ai, tepia; jura tjautjau pirna ngundrai!“ ");
INSERT INTO dif_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ja jaura jinkinietja kulno nunkangu wokarana wonti, nulu ngarana warai, worderu tana ngankamalina warai, ja nulu ngujamana warai, Nulu tanangu ngumu kalabana warai, nulu nina jekibana wonti: „Mina jirijiribani jaura pratjanaia kapara nganai?“ ");
INSERT INTO dif_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesujeli nunkangu kalabana wonti: „jirijiribani jaura pratjanaia kapara naupini nganai: Ngaramai, Israelajai, Kapara Goda ngaianani Kapara kulno nganai; ");
INSERT INTO dif_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ja jundru Kapara Goda jinkani ngantjamai ngarali jinkanali, ja mungarali jinkanali, ja manujeli jinkanali, ja ngurungurulali jinkanali warupotujeli. Naupini jirijiribani jauraia ngoperala nganai. ");
INSERT INTO dif_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ja nguru nunkangu jeribaka nganai: Ngurala jinkani ngantjamai, jidna munta jeribaka. Morla pirna pudlangu wata jirijiribani jaura kulno parai.“ ");
INSERT INTO dif_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ja jaura jinkinietja nunkangu jatana wonti: „Ngumu, Ngujangujara jinkinietjajai, jidni morlalu jatana warai, ngangau Kulno nganai, ja wata kulno nguru nganai nunkangu. ");
INSERT INTO dif_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ja ninaia ngantjana ngarali ja manujeli ja mungarali ja ngurungurulali warupotujeli, ja ngurala ngantjana munta jeribaka, morla pirna nganai tarani poto ngumuni ja poto ngumu pratjanani.“ ");
INSERT INTO dif_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ja Jesujeli ngujamana wonti, nulu matja kiri kalabana, Nau nunkangu jatana wonti: „Jidni wata worita nganai Godaia mililani.“ Ja wata kulnujeli wontjana wonti nina morla jekibala. ");
INSERT INTO dif_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ja Jesujeli, Godaia pungani ngujangujara jinkinani, kalabana wonti ja jatana wonti: „Worderu jaura jinkinietja jatai, Christus Davidani ngatamura nganai? ");
INSERT INTO dif_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","David munta Jaola kulikirieli jatai: Kapara jatanala Kaparani ngakanani: Ngakangu ngunarani ngamana ngariau, ngato talpala jinkani jinkangu tidnani kuranantulu, tidnaparani piri jeribaka. ");
INSERT INTO dif_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Davidali muntali nina dikai, Kapara, ja wodajerindru Nau ngatamura nunkani nganai?“ Ja kana wolarali nina murlali ngarana wonti. ");
INSERT INTO dif_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ja ngujangujarani nunkanani Nau tanangu jatana wonti: „Jaura jinkinietjandru ngamalkaterianau, tanali ngantjai kati wirdieli wirarina ja jaura murlali jinkimalini pirini, ");
INSERT INTO dif_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ja ngamanai piri ngopera jaura pungani, ja ngamani piri ngopera buka pirnani. ");
INSERT INTO dif_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Tanali mangawaruja pungu tajiai, ja jendralia ngatjina wirdri wondralkai; tanali kalala morla pirna manila nganai.“ ");
INSERT INTO dif_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ja Jesus mardatandra kokunkari ngamana ngarina wonti, ja Nulu najinajibana wonti worderu kana wolarali mardatandra mordatandra kokuni kurana wonti; ja kana poto pirna marapujeli kurana wonti marapu. ");
INSERT INTO dif_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ja mangawaru kulno wangiwangi wokarana wonti ja mardatandra mandru wakawaka kurana wonti, jenia nganai mardatandra mara kulno. ");
INSERT INTO dif_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ja Nulu mili nunkani karkana wonti ja tanangu jatana wonti: „Morlalu ngani jurangu jatai: Nandrupini mangawaru wangiwangieli morla mardatandra kokuni kurana warai, tanangu pratjanani. ");
INSERT INTO dif_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ngangau tanalia pratjanali tanani poto manamirindru kurana warai; nandrupini nankani ngaljengaljendru pratjana, mina nandruja ngamalkana warai, nankani poto pratjana, kurana warai.“ ");
INSERT INTO dif_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ja Nau Godaia pungandru dunkana kurana, mili nunkani kulno nunkangu jatana wonti: „Ngujangujara jinkinietjajai, najiau mina marda ja mina wotini!“ ");
INSERT INTO dif_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ja Jesujeli kalabana wonti ja nunkangu jatana wonti: „Jundru jenia wotini pirna najiai? Wata marda kulno marda kulnuni parala nganai.“ ");
INSERT INTO dif_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ja Nau maninindri mardawonpani Godaia pungankari matja ngamana ngarina, nina Petrulu ja Jakobulu ja Johannili ja Andreasali pilki jakalkana wonti: ");
INSERT INTO dif_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","„Ngaianingu jatau, winta jenia pantjila nganai; ja mina malka jenia nganai, winta jenia pratjana mudala nganai?“ ");
INSERT INTO dif_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesujeli kalabana wonti ja wonina wonti jatala: „ngamalkaterianau kulnujeli jurana karkarkaiati. ");
INSERT INTO dif_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ngangau marapu wokarala nganai talani ngakanani, ja tana jatala nganai: Ngani Nauja nganai, ja tanali marapu karkarkala nganai. ");
INSERT INTO dif_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Jura tirimalinandru ja tirimalina pinti ngaranani, wata japali pantjianau; ngangau jenia pantjinanto, ja mudana wata kantji nganala wapaia. ");
INSERT INTO dif_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ngangau kana wolara tiriterkakala nganai kana wolarani, ja mitaia kaparaia milila mitaia kaparaia mililani; ja mita wiltjiwiltjila nganai mankamanka, ja maua pirna ja tjautjau pirna nganala nganai. ");
INSERT INTO dif_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ketjaketjanaia wonina jenia nganai. Jura munta ngamalkaterianau, ngangau tanali jurana kaparani ngulkujeli jinkila nganai, ja jaura pungani tanali jurana nandrala nganai; ja najinajibanietjani ja mitaia kaparani tanali jurana terkibala nganai ngakangundru, tanangu malka nganananto. ");
INSERT INTO dif_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ja tanali ngopera kanani warupotuni ngantjani jaura kaukaubala nganai. ");
INSERT INTO dif_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kanali jurana wapalkanani ja ngulkujeli jinkinani wata manujeli ngundranau mina jura jatananto, ja wata ngankingaterianimai, a‐ai, windri jenia, mina Nulia jurangu jinkila nganai nunkangupini ditjini, jatanimai; ngangau wata jura nganai, tana jatai, a‐ai, Jaola kulikirieli. ");
INSERT INTO dif_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nejieli ngatata nunkani naria ngulkujeli jinkila nganai, ja ngaperali kupa nunkani; ja kupa terkakala nganai ngaperani ja ngandrini ja pudlana naria jinkila nganai. ");
INSERT INTO dif_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ja kana warupoto jurangu kalakalarila nganai ngakani talandru. Worana wonki nganai ngadajelu, nulu tepi ngurali manila nganai. ");
INSERT INTO dif_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Jura «duljadulja‐tjautjau» najinani, nunkangundru Propheta Daniilali kaukaubana wonti, nau terkai woderi nau wata terkananto, — warle jenia warapai ngundraiatimai — ngadani tana Judaia mitala mardawonpaia japa mindriatinimai! ");
INSERT INTO dif_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Worana punga mangatandrani nganai, wata pungani ngariatimai, ja bakana wata wiriatimai minakulno pungandru manila. ");
INSERT INTO dif_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ja worana maruni nganai, wata karitjina tikaiatimai, kati nunkani manila. ");
INSERT INTO dif_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Jakajai tanangu mandrantjani ja ngama jinkinietjani tanangupini ditjini! ");
INSERT INTO dif_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ngatjianimai jurani japa mindrina wata kilpani pantjinanto. ");
INSERT INTO dif_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ngangau tanapini ditji ketjaketjana pirna nganala nganai, worderu jenia mitaia woninandru, ninapini Godali pantjimana wonti, kararilu wata nganana wonti ja wata nganala nganai. ");
INSERT INTO dif_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ja Kaparali tananapara ditji wata wordu ngankanani, kana pani tepi pirna ngamanani: windri kalkalkanandru, tanana Nulia kalkalkana wonti, Nulia jenia ditji wordu ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Jendranguta kulno jurangu jatanani: Mai, ninkida Christus nganai kara; mai, jerra Nauja, jenia wata morlalu ngundranimai. ");
INSERT INTO dif_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ngangau Jedikantji Christus wora ja Jedikantji Propheta wora terkakala nganai, ja tanali malka ja pirnala jinkila nganai; ngangau tana ngurunguru ngananani, tanali bakana karkarkananto, tanana Nulia kalkalkanala. ");
INSERT INTO dif_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Jura ngamalkaterianau! Mai, ngani jurangu jenia pratjana ngopera jatana warai. ");
INSERT INTO dif_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Tanangupini ditjini, ketjaketjana pirnani ngadani, ditji pirna ngalpuru pantjila nganai, ja pirali praitji nunkani wata jinkila nganai. ");
INSERT INTO dif_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ja ditji waka wora pariwilpandru purila nganai, ja pariwilpaia ngurula wiltjiwiltjila nganai. ");
INSERT INTO dif_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ja ngadani tanali Kanaia Ngatamura najila nganai talara palkujeli wokaranani ngurungurulali ja pirnali. ");
INSERT INTO dif_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ja ngadani Nulia angela worana nunkani jinpala nganai, ja Nulia mapala nganai nunkani kalkalkanala watara mandru ja mandrundru, mitaia wondirandru pariwilpaia wondirajelu. ");
INSERT INTO dif_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Tandra nindrindru jeribaka malka kiririanimai; ngunanguna nunkani matja kuljakuljarina ja talpa matja punkana, jura ngujamai, woldrakanja karakara nganai. ");
INSERT INTO dif_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Jeruja bakana jura ngujamananto, jura jenia najina pantjinani, nau manani karakara nganai. ");
INSERT INTO dif_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Morlalu ngani jurangu jatai: Naupini nguja wata mudala nganai jenia pratjana pantjinantulu. ");
INSERT INTO dif_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Pariwilpa ja mita maru mudala nganai; jaura ngakani wata mudala nganai. ");
INSERT INTO dif_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ninapini miljaru ja ditji wata kulnujeli ngujamai, bakana wata angelali pariwilpani, bakana wata Ngatamurajeli, a‐ai, windri Ngaperali. ");
INSERT INTO dif_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ngamalkaterianau, tepi ngamanau ja ngatjianau, ngangau jura wata milkila, winta naupini ditji nganai. ");
INSERT INTO dif_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Worderu kana kulno palkanani, nulu punga nunkani worarai, ja milini nunkanani ngurula jinkiai, ja tanangu pratjanani ngankana tanani kurai, bakana mana ngamalkanietjani jirijiribai nau tepi ngamananto. ");
INSERT INTO dif_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Jeruja tepi ngamanau, ngangau jura wata milkila, winta pungaia kapara wokarai, kalkaura kara, tinka terti kara, paia ngaperi jatanani kara, tankubana kara; ");
INSERT INTO dif_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ngangau nulu jurana, nau nurujeli wokaranani, muka mankamankaiati. ");
INSERT INTO dif_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Mina ngani jurangu jatai, jenia ngani pratjanani jatai: Tepi ngamanau!“ ");
INSERT INTO dif_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ja ditji mandruni Passa ja pulkurutjeribanibuka pani ditji nganana wonti; ja Priesta pirnali ja jaura jinkinietjali wontina wonti, worderu tanali nina kirieli patananto ja nari ngankananto. ");
INSERT INTO dif_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Tana jatana wonti: „Wata ditji pirnani, ngangau kana wolara juajuangaiati.“ ");
INSERT INTO dif_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ja Nau Bethania ngurani Simon kana gambalaia pungani nganana wonti, ja Nau kurlini ngamana ngarinani, widla kulno wokarana wonti, nandru Alabaster koko gildi ngumu pirnanto ngamalkana wonti, ja nandru nina koko wokaribana wonti, ja nina nunkangu mangatandrani nangana wonti. ");
INSERT INTO dif_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Palpa jerra nganana wonti tana junkarilkijiribamalina wonti ja jatana wonti: „Minani jenia gildi bakujeli tintana? ");
INSERT INTO dif_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ngangau nandruja ninaia gildi kalalaia jinkinanto morla 300 mardatandrani, ja wangiwangini bakujeli jinkinanto.“ Ja tana nankangu buljubuljurina wonti. ");
INSERT INTO dif_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesus jatana wonti: „Nanaia murlali worani patanimai. Minandru jura nanaia jupai? Nandruja ngankana ngumu ngakangu ngankana warai. ");
INSERT INTO dif_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ngangau milingeru jura kana wangiwangi jurangunto ngamalkai, ja jura jertapaterinani jura tanangu ngumu ngankananto; ngana jura wata milingeru ngamalkai. ");
INSERT INTO dif_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Mina nandruja ngankananto, nandruja ngankana warai; nandruja ngopera ngankana warai ngana palku wiribala todinaia. ");
INSERT INTO dif_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Morlalu ngani jurangu jatai: Woderi tanali paruparu ninapini ngantjiani jaura kaukaubala nganai mita maruni, naka tanali bakana jatala nganai, mina nandruja ngankana warai, nanaia ngundrananto.“ ");
INSERT INTO dif_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ja Judas Ischariot, marapratjana ja mandrundru kulno, Priesta pirnaia wapana wonti, nulu nina tanangu wontawontananto. ");
INSERT INTO dif_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ja tanali jenia ngarana, tana mankina wonti, ja nunkangu talpadakana wonti mardatandra jinkila; ja nulu wontina wonti worderu nulu nina ditjini talkuni wontawontananto. ");
INSERT INTO dif_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pulkurutjeribanibuka pani ditji ngoperalani, tana Passa kuparu nandrana, mili nunkani nunkangu jatana wonti: „Wodaninkinaia jidni tertapateriai ngaiani wapananto ja ngankingananto, jundru Passa kuparu tajinanto?“ ");
INSERT INTO dif_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ja Nulu mili nunkani mandru jinpana wonti ja pudlangu jatana wonti: „Wapalumai nguraia, ja kana kulno judlangu mandurila nganai, nulu ngapa koko mandrai; nunkangu karipaterialumai, ");
INSERT INTO dif_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ja woderi nau wirila nganai, jerra punga ngamalkanietjani jatalumai: Ngujangujara jinkinietja jatai: Woderi ngakani piri nganai, naka ngato Passa kuparu milintali tajinanto? ");
INSERT INTO dif_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ja nulu judlangu tajini piri pirna matja ngankingana, wondrala nganai, naka ngaianani nina ngankingalumai.“ ");
INSERT INTO dif_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ja mili nunkani dunkana kurana wonti, ja ngurani wokarana wonti, ja jeruja mankamankana wonti, worderu Nau pudlangu jatana warai; ja pudlali Passa kuparu ngankingana wonti. ");
INSERT INTO dif_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ja matja kalkaurarina, Nau marapratjana ja mandrunto wokarana wonti. ");
INSERT INTO dif_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ja tana kurlini ngamanani ja tajinani Jesus jatana wonti: „Morlalu ngani jurangu jatai, kulnujeli jurangundru, nulia ngakangunto tajila wapaia, ngana wontawontala nganai.“ ");
INSERT INTO dif_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Tanali wonina wonti ngaurongauro pantjila ja nunkangu jatala pilki ja pilki: „Ngani nauja nganai? Ja kulno: Ngani nauja nganai?“ ");
INSERT INTO dif_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Nulu kalabana wonti ja tanangu jatana wonti: „Kulno marapratjana ja mandrundru, ngalikulno mara kurai pirrani. ");
INSERT INTO dif_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Kanaia Ngatamura wapai, worderu nunkangundru dakanala parai; jakajai nunkangupini kanani, nulia Kanaia Ngatamura wontawontala nganai; nunkangupini kanani ngumu ngananala, nauja wata dankanala.“ ");
INSERT INTO dif_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Tanali tajinani, Jesujeli buka patana wonti ja ngurungutana wonti ja ninapini wokaribana wonti ja tanangu jinkina wonti ja jatana wonti: „Patanimai ja tajianimai; naupini ngani palku nganai!“ ");
INSERT INTO dif_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ja Nulu koko matja patana ja jurakokana, Nulu nina tanangu jinkina wonti, ja tanali pratjanali nunkangundru tapana wonti. ");
INSERT INTO dif_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ja Nau tanangu jatana wonti: „Naupini ngani kumari nganai, ninapini ngani marapuja nangateriai. ");
INSERT INTO dif_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Morlalu ngani jurangu jatai: «Kararindru ngato wata morla nunkangupini waina nindri tandrandu tapala nganai nunkangupini ditjielu, ngato nina marra tapala nganai Godaia mililani.»“ ");
INSERT INTO dif_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ja tana jurakokani wima matja jatana, tana maninindri mardawonpaia wapana wonti. ");
INSERT INTO dif_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ja Jesus tanangu jatana wonti: „Jura pratjaterina nunkangupini tinkani ngakangu kintjakintjarila nganai, ngangau dakanala parai: Ngato ngamalkanietja nandrala nganai, ja tjipi piltjaru nganala nganai. ");
INSERT INTO dif_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ngadani ngani matja jiritjina warai, ngani jurangu ngopera Galilaiaia wapala nganai.“ ");
INSERT INTO dif_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petrus nunkangu jatana wonti: „Bakana pratjana jinkangu kintjakintjarinani, ja wata ngani.“ ");
INSERT INTO dif_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ja Jesus nunkangu jatana wonti: „Morlalu ngani jinkangu jatai: Karari nunkangupini tinkani, windrila paia ngaperi pota mandru jatananto, jundru ngana pota parkulu jedieli worarala nganai.“ ");
INSERT INTO dif_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Nau morla parparali jatana wonti: „Ngani bakana jinkangunto palinanto, ngato jidnana wata jedieli worarala nganai.“ Jeruja bakana mili pratja jatana wonti. ");
INSERT INTO dif_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ja tana piri kulnuni wokarana wonti, tala nunkani Gethsemane; ja Nau milini nunkanani jatana wonti: „Ninkida ngamana ngarianau ngani ngatjinantulu.“ ");
INSERT INTO dif_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ja Nulu Petrus ja Jakobus ja Johannes patana wonti ja wonina wonti ngaruparala ja japali nganala. ");
INSERT INTO dif_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ja Nau tanangu jatana wonti: „Ngani mungara ngaurongauro pirna nganai narielu; ninkida ngamanimai ja tepi ngamanimai!“ ");
INSERT INTO dif_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ja Nau ngalje morla wapana wonti ja mitani woraterina wonti ja ngatjina wonti, ngangau naupini ditji nunkangu wiringananto. ");
INSERT INTO dif_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ja Nau jatana wonti: „Abba, Ngaperiai! Jidni ngurunguru nganai pratjana ngankala, ninapini koko ngakangundru maniau: wata jeruja, mina ngani jertapateriai, a‐ai, mina jidni.“ ");
INSERT INTO dif_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ja Nau tikana wonti, ja Nulu tanana mukaturaranani mankamankana wonti, ja Nau Petrungu jatana wonti: „Simoniai, jidni mukaturarai? Jidni ngandandariai ngalje ngakangunto tepi ngamala? ");
INSERT INTO dif_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Tepi ngamanau ja ngatjianau, jura wontjanilani wiriati; mungara manju nganai ja palku waltowalto.“ ");
INSERT INTO dif_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ja Nau nakaldra wapana wonti ja ngatjina wonti jenildramata jaura. ");
INSERT INTO dif_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ja Nau nakaldra tikana, Nulu tana muka mankamankana wonti; ngangau tana milki parina wonti, ja tana wata milkila nganana wonti, mina tanali nunkangu kalabananto. ");
INSERT INTO dif_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ja Nau pota parkulani tikana wonti ja tanangu jatana wonti: „Mukaturaranau ja ngara ngamanau! Matja mudai; ditji matja wokarana; mai, tanali Kanaia Ngatamura madlentjia marani ngulkujeli jinkila nganai; ");
INSERT INTO dif_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Terkakanau, ngaiana wapananto! mai, nauwa, nuluwa ngana wontawontai, wokaraila.“ ");
INSERT INTO dif_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ja nurujeli, Nau jenia jatanani, Judas, marapratjana ja mandrundru kulno, wokarana wonti, ja nunkangunto kana wolara pirna kalti tirieli ja pitali Priesta pirnandru ja jaura jinkinietjandru ja pinarandru. ");
INSERT INTO dif_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Wontawontanietjali nunkanali tanangu malka jinkina wonti ja jatana wonti: „Worananina ngato manatapala nganai, Nauja nganai, ninaia patanimai, ja ninaia morlalu wapalkanimai!“ ");
INSERT INTO dif_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ja nau wokarana, nau nurujeli nunkangu wapana wonti ja jatana wonti: „Rabbi, Rabbi!“ ja nina manatapana wonti. ");
INSERT INTO dif_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Tanali mara nunkangu kurana pararana wonti ja nina patana wonti. ");
INSERT INTO dif_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Kulno tanangundru jerra terkanani mardakirra dukarana wonti, ja Priesta pirnaia mili kulno nandrana wonti, ja nina talpa wokaribana wonti. ");
INSERT INTO dif_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ja Jesujeli kalabana wonti ja tanangu jatana wonti: „Jura ngankangu dunkana warai watawatali maninietjani jeribaka mardakirrali ja pitali, ngana patala. ");
INSERT INTO dif_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ditji marapu ngani jurangunto nganana warai Godaia pungani ngujangujara jinkina, ja jura ngana wata patana warai: windri jaura wora morlalu pantjinanto.“ ");
INSERT INTO dif_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ja tana pratjana nunkangundru puntina wonti ja japa mindrina wonti. ");
INSERT INTO dif_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ja teri kulno nunkangu karipaterina wonti, nulu windri kati kulno palku baluni ngamalkana wonti; ja teri worali nina patana wonti. ");
INSERT INTO dif_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ja nulu kati worarana wonti, ja balu japa mindrina wonti. ");
INSERT INTO dif_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ja tanali Jesus Priesta pirnaia wapalkana wonti; ja nunkangu jela Priesta pirna ja pinaru ja jaura jinkinietja pratjana jurborina wonti. ");
INSERT INTO dif_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ja Petrus nunkangu woritandru karipaterina wonti Priesta pirnaia piri mandrajelu; ja nau naka milini jela ngamana wonti, ja turuni ngarakalina wonti. ");
INSERT INTO dif_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Priesta pirnali ja kapara pratjanali jedi jaura wontina wonti Jesungu, nina nari ngankala; ja tanali panila mankamankana wonti. ");
INSERT INTO dif_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ngangau marapujeli jedi jaura morlalu kurana wonti nunkangu, ja tanani jaura morlalu wata kulnuni nganana wonti. ");
INSERT INTO dif_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ja palpa terkakana wonti ja jedi jaura morlalu kurana wonti, ja jatana wonti: ");
INSERT INTO dif_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","„Ngaiani ninaia jatanani ngarana paraia: Ngato ninapini Godaia punga, ninaia kanali marali matja wotina, wokaribala nganai, ja ditjini parkulani ngato kulno nguru wotila nganai, ninaia kanali marali wata wotina warai.“ ");
INSERT INTO dif_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ja bakana jeruja tanani jaura morlalu wata kulnurina wonti. ");
INSERT INTO dif_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ja Priesta pirna terkana tarana wonti ja tertia wapana wonti, ja nulu Jesus jakalkana wonti ja jatana wonti: „Jundru panila kalabai? Mina tanalipini jinkangu morlalu kurai?“ ");
INSERT INTO dif_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Nau ngapu nganana wonti ja panila kalabana wonti. Nakaldra Priesta pirnali nina jakalkana wonti ja nunkangu jatana wonti: „Jidni Christus nganai jurakokania Ngatamura?“ ");
INSERT INTO dif_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesus jatana wonti: „Ngani Nauja, ja jura najila nganai Kanaia Ngatamura pirnalaia ngunarani ngamanani, ja pariwilpalali talara palkujeli wokaranani.“ ");
INSERT INTO dif_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Priesta pirnali kati nunkani purana wonti ja jatana wonti: „Minani ngaiana jaura morlalu morla ngamalkananto? ");
INSERT INTO dif_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Jura Godani ngirkibanani ngarana warai: Mina jura ngundrai?“ Tanali pratjanali nunkangu ngulkuterkana wonti, Nauja nari palinanto. ");
INSERT INTO dif_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ja palpali wonina wonti nunkangu ngaltja worala, ja mudla nunkani walpadakala, ja nina maramokujeli nandrala, ja nunkangu jatala: „Morlalu jatau!“ Ja bakana milieli nina pitali nandrana wonti. ");
INSERT INTO dif_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ja Petrus pirini ngarinalu nganana, Priesta pirnaia widla mili kulno wokarana wonti. ");
INSERT INTO dif_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ja nandru Petrus najina, worderu nau ngarakalinani, nandru nina ngurutalpana wonti ja jatana wonti: „Bakana jidni Jesungu Nazaretalani jela nganana warai!“ ");
INSERT INTO dif_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Nau jedina wonti ja jatana wonti: „Ngani ko, ja bakana wata ngujamai mina jidni jatai.“ Ja nau piri palaraia dunkana kurana wonti. Ja paia ngaperi jatana wonti. ");
INSERT INTO dif_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ja widla milieli nina matja najina, nani tanangu, naka terkanani jatana wonti: „Naupini kulno tanangundru nganai.“ ");
INSERT INTO dif_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Nau nakaldra jedina wonti. Ja wolja ngadani tana jerra terkana nakaldra Petrungu jatana wonti: „Morlalu jidni kulno tanangundru nganai, ngangau jidni Galilaiala nganai, ja talieli jinkanali jenia wondrai.“ ");
INSERT INTO dif_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ja nulu wonina wonti madlentji jataterila, ja jaura morlalu jatana wonti: „Ngato ninapini kana wata ngujamai, nunkangundru jura jatai.“ ");
INSERT INTO dif_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ja nurujeli paia ngaperi pota mandrulani jatana wonti. Ja Petrulu jenia jaura ngundrana wonti worderu Jesus nunkangu jatala wiri: „Windrila paia ngaperi pota mandru jatananto, jundru ngana pota parkulu jedieli worarala nganai.“ Ja nulu jenia ngundrana, nau jindrana wonti. ");
INSERT INTO dif_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ja nurujeli, matja nguramarana, Priesta ja pinaru ja jaura jinkinietja ja kapara pratjana ngankamalina wonti; ja tanali Jesus dupudupu ngankana wonti, ja nina wapalkana wonti, ja nina Pilatungu jinkina wonti. ");
INSERT INTO dif_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatulu nina jakalkana wonti: „Jidni Juda kanaia Kapara nganai?“ Nulu kalabana wonti ja nunkangu jatana wonti: „Jidni matja jatai.“ ");
INSERT INTO dif_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ja Priesta pirnali nunkangu jaura marapujeli ngulkuterkana wonti. ");
INSERT INTO dif_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatulu nina nakaldra jakalkana wonti ja jatana wonti: „Jundru panila kalabai? Mai, worderu ngurungurujeli tanaia jinkangundru ngulkuterkai!“ ");
INSERT INTO dif_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jesujeli nunkangu wata morla kalabana wonti, jeruja Pilatus ngaruparana wonti. ");
INSERT INTO dif_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ditji pirnani nulu tanangu milingeru kanjangarila kurakana wonti, worananina tanali ngatjina wonti. ");
INSERT INTO dif_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Kulno nganana wonti, tala nunkani Barabbas, nina tanali tirijiritjibanietjani jela dupudupu ngankana warai, ngangau tanali tirijiritjibanani kana kulno narielu nandrana warai. ");
INSERT INTO dif_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ja kana wolara pirna maritjina wonti ja wonina wonti ngatjila, worderu nulu tanangu milingeru ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatulu tanangu kalabana wonti ja jatana wonti: „Jura jertapateriai, ngato jurangu Juda kanaia Kapara kurakananto?“ ");
INSERT INTO dif_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ngangau nulu ngujamana wonti, Priesta pirnali nina windri kuterilkanandru ngulkuterkana warai. ");
INSERT INTO dif_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Priesta pirnali kana wolara ngankana wonti, nulu tanangu Barabbas kurakananto. ");
INSERT INTO dif_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilatus nakaldra kalabana wonti ja tanangu jatana wonti: „Mina jura jertapateriai ngato nunkangu ngankananto, ninaia juru dikai Juda kanaia Kapara?“ ");
INSERT INTO dif_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Tana nakaldra maritjina wonti: „Ninaia kunarkuni katibamai!“ ");
INSERT INTO dif_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatus tanangu jatana wonti: „Mina madlentji Nulia ngankana warai?“ Tana morla maritjina wonti: „Ninaia kunarkuni katibamai!“ ");
INSERT INTO dif_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatulu ngundrana wonti kana wolaraia jertapaterina ngankala, ja tanangu Barabbas kurakana wonti, ja nulu Jesus jinkina wonti, nulu nina matja nandrana, tanali nina kunarkuni katibananto. ");
INSERT INTO dif_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Mitaia kaparaia milieli nina palaraia pirini wapalkana wonti, nauja kalala jinkini piri nganai, ja tanali mili pratjana karkana wonti. ");
INSERT INTO dif_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ja tanali nunkangu kati maralje widmana wonti, ja nunkangu dilka pirapira kurana wonti, nina tanali matja dakana. ");
INSERT INTO dif_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ja tanali wonina wonti nunkangu jaura murlali jinkila: „Murlali nganamai, jidni Juda kanaia Kapara!“ ");
INSERT INTO dif_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ja milingeru tanali nina mangatandra pitali nandrana wonti, ja nunkangu ngaltja worana wonti, ja nunkangu pantjaterkana ngarina wonti, ja nunkangu woraterina wonti. ");
INSERT INTO dif_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ja tanali nina matja ngirkibana, tanali nunkangundru kati maralje dukarana wonti; ja kati pilki nunkani nunkangu widmana wonti; ja tanali nina dunkalkana wonti, nina kunarkuni katibala. ");
INSERT INTO dif_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ja tanali kana kulno watawatali patana wonti, nau wiringanani, Simon Kyrenala, nau marundru wokarana wonti, Alexandrini ja Ruphuni ngaperi, nulu kunarku nunkani waltananto. ");
INSERT INTO dif_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ja tanali nina Golgatha pirini wapalkana wonti, jenia wondrai: „Mangatandra piri.“ ");
INSERT INTO dif_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ja tanali nunkangu waina jinkina wonti nina kaldrieli ngokana, tapananto; ja Nulu nina wata manina wonti. ");
INSERT INTO dif_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ja tanali nina kunarkuni matja katibana, tanali kati nunkani puntibana wonti wontjani malkali, warle palpa maninanto. ");
INSERT INTO dif_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Jendranguta tankubana ditji mirini nganana wonti, ja tanali nina kunarkuni katibana wonti. ");
INSERT INTO dif_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ja tanali miri jaura kurana wonti minandru Nau palinanto: „Juda kanaia Kapara.“ ");
INSERT INTO dif_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ja nunkangu jela tanali watawatali maninietja mandru kunarkuni katibana wonti, kulno nunkangu ngunarani ja kulno nunkangu worangantjuni. ");
INSERT INTO dif_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ja jaura morlalu pantjina wonti, nauja jatai: „Bakana madlentji ngankanietjani terti Nau parananto.“ ");
INSERT INTO dif_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Wiringanietjali nina ngirkibana wonti, ja tana mangatandra walkina wonti ja jatana wonti: „Haha, jundru Godaia punga tamburibanietja ja wotinietja ditjini parkulani. ");
INSERT INTO dif_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Jidni munta kulkateriau, ja kunarkundru ngariau!“ ");
INSERT INTO dif_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Tanali jeribaka nina Priesta pirnali ja jaura jinkinietja jelali ngirkibana wonti ja jatana wonti: „Kana nguru Nulia kulkana warai, ja muntali Nauja ngandandariai kulkaterila. ");
INSERT INTO dif_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Christus, Juda kanaia Kapara, karari kunarkundru ngariatimai, ngangau ngaiani najinanto ja morlalu ngundrananto.“ Bakana pudlali nunkangunto kunarkuni parana, nina ngirkibana wonti. ");
INSERT INTO dif_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ja matja todarina, ngalpuru pirna pantjina wonti ditji kunarkujelu. ");
INSERT INTO dif_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ja ditji kunarkuni Jesus ngaiala pirnali maritjina wonti ja jatana wonti: „Eloi, Eloi, lama sabachthani?“ Jenia wondrai: „Godajai ngakani, Godajai ngakani; minandru jundru ngana worarana warai?“ ");
INSERT INTO dif_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ja palpa tanangundru naka terkana, ja jenia ngarana, jatana wonti: „Mai, Nulupini Elias karkai.“ ");
INSERT INTO dif_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Kulno mindrina wonti ja miritipa kulno kaldrieli ngapatjanka ngankana wonti, ja nina pitani widmana wonti ja nunkangu jinkina wonti tapananto, ja jatana wonti: „Worani, ngaiana najinanto Elias kara wokarala nganai ninaia ngarilkala.“ ");
INSERT INTO dif_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ja Jesus ngaiala pirnali maritjina wonti ja palina wonti. ");
INSERT INTO dif_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ja kati pirna Godaia pungani puraterina wonti terti mirindru ngarinalujelu. ");
INSERT INTO dif_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Juljaia kaparali, nau nunkangunkari terkana, nulu najina, Nau ngaiala pirnali palinani jatana wonti: „Morlalu Naupini kana Godaia Ngatamura nganana warai.“ ");
INSERT INTO dif_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Jerra bakana widla nganana wonti, tanali woritandru najina wonti; tanagundru Maria Magdalala ja Maria, Jakobus wakani ja Joseni ngandri, ja Salome nganana wonti. ");
INSERT INTO dif_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nau Galilaiani nganana tana nunkangu karipaterina wonti ja mili nunkani nganana wonti; ja marapu morla, tana nunkangu jela Jerusalemia tarana wonti. ");
INSERT INTO dif_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ja matja kalkaurarina, ngangau ngankingani ditji nganana, jenia wondrai ditji kulno wiringani ditjini ngopera. ");
INSERT INTO dif_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Joseph Arimathiala, kapara pirna kulno, nulu bakana muntali Godaia mililani kalkana, wokarana wonti; ja nau japanguru Pilatungu wirina wonti ja Jesu palkuni ngatjina wonti. ");
INSERT INTO dif_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatus ngaruparana wonti, Nau matja nari; ja nulu juljaia kapara karkana wonti ja nina jakalkana wonti, nau matja nari? ");
INSERT INTO dif_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ja nulu jenia juljaia kaparandru matja ngujamana, nulu Josephangu nina palku jinkina wonti. ");
INSERT INTO dif_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ja nulu kati burungankana wonti, ja nina ngarilkana wonti, ja nina katieli karana wonti, ja nina narikutuni kurana wonti, nulu nina marda taldrani matja bakuna, ja nulu marda kulno narikutuja manani tirimalkana wonti. ");
INSERT INTO dif_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Magdalalali, ja Maria Joseni ngandrieli najina wonti, woderi nulu nina kurana wonti. ");
INSERT INTO dif_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ja Sabbat ditji matja mudana, Maria Magdalala ja Maria Jakobuni ja Salome kuli ngumu burungankana wonti wapala nina wiribala. ");
INSERT INTO dif_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ja tana tankutankubana wokarana wonti nari wonpani Godaia ditjini. ");
INSERT INTO dif_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ja tana ngankamalina wonti: „Warle ngaianangu marda nari kutuja manandru tirimalkala nganai?“ ");
INSERT INTO dif_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ja tanali najingana wonti ja najina wonti, marda matja tiringana, ngangau nau pirna nganana wonti. ");
INSERT INTO dif_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ja tana nari kutuni wirina wonti, ja tanali teri kulno ngunarani ngamanani najina wonti, nulu kati bulu ngamalkana wonti; ja tana japali pantjina wonti. ");
INSERT INTO dif_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nau tanangu jatana wonti: „Wata japali ngananau, jura Jesus Nazarenala wontiai, nina tanali kunarkuni katibala wiri; Nau tepi terkakana warai, Nau wata ninkida nganai; najianau piri, woderi tanali nina kurala wiri. ");
INSERT INTO dif_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Wapanimai ja milini nunkanani ja Petrungu jatanimai: Nau jurangu ngopera wapala nganai Galilaia mitaia, naka jura nina najila nganai, worderu Nau jurangu ngopera jatana paraia.“ ");
INSERT INTO dif_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ja tana nurujeli dunkana wonti ja nari kutundru japa mindrina wonti; ngangau tana ngarrana wonti ja ngaruparana wonti, ja tana wata kulnuni jenia jatana wonti, ngangau tana japali pirna nganana wonti.");
INSERT INTO dif_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Nau matja tepi terkakana Godaia ditjini, Nau ngopera Maria Magdalalani wondraterina wonti, nankangundru Nulu kutji mara wora ja mandru dunkalkana wonti. ");
INSERT INTO dif_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Nani wapana wonti ja tanangu jenia kaukaubana wonti, tana nunkangunto nganana warai, tana ngaurongauro pirna nganana ja jindrana. ");
INSERT INTO dif_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ja tanali ngarana Nau tepi, ja nandru nina najina warai, tanali wata morlalu ngundrana wonti. ");
INSERT INTO dif_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ngadani Nau tanangundru mandruni, pudla paltuni nganana, nguja pilkieli wondraterina wonti, pudla maruja wapanani. ");
INSERT INTO dif_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ja pudla wapana wonti ja palpani jenia kaukaubana wonti; bakana pudlangu tanali wata morlalu ngundrana wonti. ");
INSERT INTO dif_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tanali ngadani kurlini ngamanani, Nau marapratjana ja kulnuni wondraterina wonti, ja tanani gilbarinandru ja ngara ngurungurundru Nau tanangu kaldririna jatana wonti, ngangau tanali tanangu, tanali nina matja tepi najina, wata morlalu ngundrana wonti. ");
INSERT INTO dif_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ja Nau tanangu jatana wonti: „Palkanau mita maruja, ja ngantjani jaura kaukaubanimai kanani warupotuni! ");
INSERT INTO dif_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Warle morlalu ngundrai ja multibanila maniai tepi ngurali manila nganai; worana gilbariai, tintaterila nganai.“ ");
INSERT INTO dif_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Tanangu, tanali morlalu ngundrai, jenia malka karipaterila nganai: Talani ngakanani tanali kutji dunkalkala nganai; tali marrali tana jatala nganai. ");
INSERT INTO dif_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Tanali tjutju narrala nganai; ja tanali naria tapani tapanani, tana wata palinani; muntjani tana mara kuraterila nganai, ja tana tepirila nganai. ");
INSERT INTO dif_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ja Kapara tanangu matja jaura jatana warai, Nau pariwilpaia tarana wonti, ja ngamala wapaia Godani ngurani. ");
INSERT INTO dif_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ja tana palkana wonti, ja paruparu jaura jinkina wonti, ja Kaparali tanangunto ngankana wonti ja malka pirnali jaura ngurunguru nganana wonti.");
INSERT INTO dif_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ngangau marapujeli wontjana wonti kaukaubani jaura dakala nunkangundru, mina ngaianangu terti pantjina wonti, ja ngaiani morlalu milkila, ");
INSERT INTO dif_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Jeruja worderu tanali ngaianangu kaukaubana wonti, tana ngoperandru milkieli najina wonti ja jaura jinkinietja pantjina wonti. ");
INSERT INTO dif_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Jeruja bakana ngato ngundrana warai, ngato ngoperandru pratjana jiglerali matja jakalkana warai, jenia jinkangu talku dakala, Theophilai ngantjalu. ");
INSERT INTO dif_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ngangau jundru talku ngujamananto tananapini jaura, tanangu jundru ngujangujara matja manina. ");
INSERT INTO dif_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herodes Judaia mitaia kaparaia ditjini Priesta kulno nganana wonti, tala nunkani Zacharias, Abiaia mardundru, ja noa nunkani Aaroni ngatamura widlandru, tala nankani Elisabeth. ");
INSERT INTO dif_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Pudla talku nganana wonti Godani, ja Kaparaia jirijiribani jaura pratjanani ja talkulani ngumu wodatarana ngamana wonti. ");
INSERT INTO dif_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pudlali wata kupa ngamalkana wonti, ngangau Elisabeth ngameri nganana wonti, ja pudla kilpawoldra marapuni wiringana wonti. ");
INSERT INTO dif_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ja jendranguta nulu Priestaia mangini ngamalkana wonti marduwittani nunkanani Godani. ");
INSERT INTO dif_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ja Priestaia wondrani malkali nina patana wonti kuli ngumu tarala, nau Godaia Kaparaia pungani wirina wonti. ");
INSERT INTO dif_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ja kana wolara palarani terkana wonti ngatjila kuli ngumuja ditjini. ");
INSERT INTO dif_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ja Kaparaia angela kulno nunkangu wondraterina wonti, nau turutupu Altaraia ngunarani terkana wonti. ");
INSERT INTO dif_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ja Zachariali nina najina, nau ngarrana wonti ja japali pantjina wonti. ");
INSERT INTO dif_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Angela nunkangu jatana wonti: „Wata japali nganau Zachariajai, ngangau ngatjina jinkani ngarana warai, ja noajeli jinkanali jinkangu kanku dankala nganai, ja jundru tala nunkani dikala nganai: Johannes. ");
INSERT INTO dif_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ja jundru mankina ja murla ngamalkala nganai, ja marapu mankila nganai nunkani dankanandru, ");
INSERT INTO dif_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ngangau nau pirna nganala nganai Kaparani; ja waina ja tapana ngurunguru nulu wata tapala nganai, ja Jaolali kulikirieli nau manamiri pantjila nganai nunkani ngandri mandrandru. ");
INSERT INTO dif_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ja nulu Israelaia ngatamura marapu karitjimalkala nganai Kaparani Godani tananani. ");
INSERT INTO dif_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ja nau nunkangu ngopera wapala nganai Eliaia jaolali ja ngurungurulali, ngaperi woraia ngara kupa worani, ja delkinietja talkulaia kirilani karitjimalkala, Kaparani kana wolara talku ngankingala.“ ");
INSERT INTO dif_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ja Zacharias angelani jatana wonti: „Worderu ngato jenia ngujamananto? Ngangau ngani pinaru, ja noa ngakani nankani ditji marapuni wiringana warai.“ ");
INSERT INTO dif_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ja angelali kalabana wonti ja nunkangu jatana wonti: „Ngani Gabrieli nganai, nauja Godani terkai, ja Nulia ngana jinpana warai, jinkangu ngankamalinanto, ja ninapini ngantjani jaura jinkangu kaukaubananto. ");
INSERT INTO dif_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ja mai, jidni ngapurila nganai ja ngandandarila nganai jatala nunkangupini ditjielu, nunkangupini jenia morlalu pantjila nganai; ngangau jundru jaurani ngakanani wata morlalu ngundrana warai, tanaia morlalu pantjila nganai ditjini tananani.“ ");
INSERT INTO dif_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ja kana wolarali kalkana wonti Zachariangu, to tana ngaruparana wonti, ngangau nau juri ngamana wonti Godaia pungani. ");
INSERT INTO dif_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Nau matja dunkana kurana, nau ngandandarina wonti tanangu ngankamalila, ja tanali ngujamana wonti, nulu mudla Godaia pungani najina warai, ja nau tanangu marali wondraterina wonti ja ngapu nganana wonti. ");
INSERT INTO dif_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ja jendranguta ngankana ditji nunkani matja mudana, nau tikana wonti pungaia nunkanaia. ");
INSERT INTO dif_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Tanangupini ditjini ngadani, Elisabeth noa nunkani mandrantjurina wonti; ja nani kurukuru ngamalkaterina wonti pira mara wora, ja jatana wonti: ");
INSERT INTO dif_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","„Jeruja Kaparali tanangupini ditjini ngakangu ngankana paraia, tanangu Nulia ngana najina, ninta ngakani kanandru manila.“ ");
INSERT INTO dif_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Pirani mara wora ja kulnuni Godali angela Gabriel jinpana wonti ngura kulnuja Galilaiaia, tala nunkani Nazaret. ");
INSERT INTO dif_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Mankara kulnuni, nandru talpadakana wonti materi kulnuni, tala nunkani Joseph, Davidani pungandru; ja mankaraia tala Maria nganana wonti. ");
INSERT INTO dif_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ja angela nankangu wirina wonti ja jatana wonti: „Murlali nganamai murlamaninietjajai; Kapara jinkangunto, jidni murlali pirna nganai widlani!“ ");
INSERT INTO dif_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Nandru nina najina, nani ngaruparana wonti nunkani jaurandru, ja ngundraterina wonti, mina mandurini jaura jenia nganai. ");
INSERT INTO dif_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ja angela nankangu jatana wonti: „Wata japali nganau Mariajai; ngangau jundru manjula mankamankana warai Godani. ");
INSERT INTO dif_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ja mai, jidni mandrantjurila nganai, ja kanku kulno dankala nganai, ja tala nunkani dikala nganai: «JESUS.» ");
INSERT INTO dif_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Naupini pirna nganala nganai, ja tanali nina Kapara pirnaia Ngatamura dikala nganai, ja Goda Kaparali nunkangu jinkila nganai ngaperaia nunkanaia Davidani pirnalaia piri. ");
INSERT INTO dif_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ja Nau Kapara nganala nganai Jakobani pungani ngurali, ja milila nunkani wata mudala nganai.“ ");
INSERT INTO dif_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria angelani jatana wonti: „Worderu jenia nganala nganai, ngangau ngato noa wata ngujamai?“ ");
INSERT INTO dif_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ja angelali kalabana wonti ja jatana wonti: „Jaola kulikiri jinkangu ngarila nganai, ja Kapara pirnaia ngurulali jidna walpala nganai; ngangau bakana nina Kulikirila, nina jundru dankala nganai, tanali Godaia Ngatamura dikala nganai. ");
INSERT INTO dif_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ja mai, Elisabeth kamaneli jinkani bakana mandrantju nganai kankunto, ja naupini pira mara wora ja kulno nganai nankangu, nana tanali ngameri dikai. ");
INSERT INTO dif_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ngarla Godata wata ngandandarila nganai jaura pratjanani.“ ");
INSERT INTO dif_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maria jatana wonti: „Mai, ngani Kaparaia mili nganai, ngakangu pantjiatimai worderu jidni jatana warai!“ Ja angela nankangundru kutingana wonti. ");
INSERT INTO dif_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Maria terkakana wonti tanangupini ditjini, ja palkana wonti mardawonpaia ngura kulnuja Judaiaia. ");
INSERT INTO dif_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ja Zachariani pungani wirina wonti ja Elisabethangu mandurini jaura jinkina wonti. ");
INSERT INTO dif_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ja jendranguta Elisabethandru Mariani mandurini jaura ngarana wonti, kupa nankani mandrani kulkungana wonti; ja Elisabeth manamiri pantjina wonti Jaolali kulikirieli. ");
INSERT INTO dif_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ja nani ngaiala pirnali maritjina wonti ja jatana wonti: „Murlali pirna jidni nganai widlani, ja murlali pirna jinkani mandraia tandra nganai! ");
INSERT INTO dif_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ja wodajerindru jenia ngakangu, Kaparaia ngakanaia ngandri ngakangu wokarananto? ");
INSERT INTO dif_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ngangau mai, matja mandurini jaura jinkani ngakangu talpani wirina, kupa mandrani ngakanani mankina kulkungana warai. ");
INSERT INTO dif_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ja murlali pirna nandru morlalu ngundrana paraia, ngangau morlalu jenia pantjila nganai, mina nankangu Kapara jatana paraia.“ ");
INSERT INTO dif_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ja Maria jatana wonti: „Mungarali ngakanali Kapara jurakokala wapaia, ");
INSERT INTO dif_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ja jaolali ngakanali Goda Kulkanipirnandru ngakanani mankila wapaia, ");
INSERT INTO dif_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ngangau Nulia najina wonti nunkani mili waka. Ngangau mai, kararindru ngana jurakokala nganai kana nguja warupotujeli. ");
INSERT INTO dif_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ngangau ngakangu pirnala ngankana paraia Nauja ngurunguru, ja kulikiri tala nunkani nganai. ");
INSERT INTO dif_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ja kalumiltjamiltjarina nunkani ngujandru ngujani nganai tanangu, tana nunkangundru japali nganai. ");
INSERT INTO dif_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nulia ngurungurula ngankana wonti ngunarali nunkanali; Nulia piltjaru ngankana wonti tanana ngara ngundranani tananani pirna ngundrateriai; ");
INSERT INTO dif_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nulia kapara worana worarana wonti pirnalaia pirindru ja wakawaka miri ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Tana maua nganana, Nulia potujeli manamiri ngankana wonti; ja tana poto pirnanto Nulia kala jinpana wonti. ");
INSERT INTO dif_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Nulia Israeli milini nunkanani marangokana wonti kalumiltjamiltjarina nunkani ngundrala. ");
INSERT INTO dif_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Worderu Nauja jatana wonti ngaianani ngaperi worani, Abrahamangu ja ngatamurani nunkanani ngurali.“ ");
INSERT INTO dif_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria nankangu jela pira parkulu ngamana wonti, ja ngadani pungaia nankanaia tikana wonti. ");
INSERT INTO dif_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabethananka ditji matja wokarana, nandru dankananto, ja nandru kupa ngatani dankana wonti. ");
INSERT INTO dif_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ja jenimalinietjali ja kamanelieli nankanali ngarana wonti worderu Kapara kalumiltjamiltjarina nunkani nankangu pirna ngankala wiri; ja tana nankangunto mankina wonti. ");
INSERT INTO dif_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ja jendranguta ditji mara wora ja parkulani tana wokarana wonti nina kanku karuwali ngankala, ja tanali nina ngaperi nunkani jeri „Zacharias“ dikana wonti. ");
INSERT INTO dif_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ja ngandrieli nunkanali kalabana wonti ja jatana wonti: „A‐ai, Johannes tala nunkani nganala nganai.“ ");
INSERT INTO dif_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ja tana nankangu jatana wonti: „Wata kamaneli kulno jinkani nganai, nina tanali ninapini tala dikai.“ ");
INSERT INTO dif_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Tanali ngaperi nunkani marali jekibana wonti, worderu nulu ngantjai ninaia dikala. ");
INSERT INTO dif_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ja nau ngatjina wonti marda pirrapirrani ja dakana wonti ja jatana wonti: „Johannes tala nunkani nganai.“ Ja tana pratjana ngaruparana wonti. ");
INSERT INTO dif_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Nurujeli mana nunkani piririna wonti, ja tali nunkani walturina wonti, ja nau jatana wonti ja Goda jurakokana wonti. ");
INSERT INTO dif_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ja jenimalinietja pratjana japali pantjina wonti, ja Judaia mardawonpa worani tana ngankamalina wonti jenia jaura pratjanandru. ");
INSERT INTO dif_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ja pratjana, tanali jenia ngarana wonti, jenia ngarali patana wonti ja jatana wonti: „Mina naupini kupa pantjila nganai?“ Ngangau Kaparaia mara nunkangunto nganana wonti. ");
INSERT INTO dif_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ja Zacharias, ngaperi nunkani, Jaolali kulikirieli manamiri pantjina wonti, ja nulu talpadakana wonti ja jatana wonti: ");
INSERT INTO dif_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","„Jurakokana nganaiatimai Kaparani, Israelaia Godani, ngangau Nulia najina wonti ja kulkana ngankingana wonti kana wolarani nunkanani, ");
INSERT INTO dif_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ja Nulia murlaia jurietjali ngaianangu jiritjibana wonti Davidani milini nunkanani pungani, ");
INSERT INTO dif_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Worderu Nauja jatana wonti nunkani Prophetaia kulikiria manali, tana ngopera nganana wonti. ");
INSERT INTO dif_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Nulia ngaianana kulkananto ngaianani talpalandru, ja mara pratjanandru tana ngaianangu kalakalariai, ");
INSERT INTO dif_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Kalumiltjamiltjarina ngankala ngaianani ngaperi worani, ja ngundrala nunkani Testamenta kulikiri; ");
INSERT INTO dif_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Jaura morlalu, nina Nulia talpadakana wonti Abrahamangu ngaperi ngaiananani, ngaianangu jinkila. ");
INSERT INTO dif_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ngangau ngaiana japanguru, Nulia ngaiananana tulaia marani matja kulkana, mili nunkani nganananto. ");
INSERT INTO dif_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Kulikirilani ja talkulani nunkani mudlani ditjini warupotuni ngaiananani. ");
INSERT INTO dif_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ja bakana jidna, kupajai, tanali Kapara pirnaia Propheta dikala nganai, ngangau jidni ngopera wapala nganai Kaparaia mudlani, palto nunkani ngankingala. ");
INSERT INTO dif_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Murlaia ngujamani jinkila kana wolarani nunkanani, madlentji tanani kalingala. ");
INSERT INTO dif_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Godaia ngaiananaia ngarali kalumiltjamiltjarinandru, nunkangundru ngaianangu mirindru praitji dunkana warai, ");
INSERT INTO dif_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Tanangu mintjila, tana ngalpurani ja naria pungalani ngamanani, ngaianani tidna murlaia paltuni wirilkala.“ ");
INSERT INTO dif_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kupa pirnarina wonti ja ngurungururina wonti Jaolali; ja nau pitarani nganana wonti nunkangupini ditjielu, nau Juda kanani wondraterina wonti. ");
INSERT INTO dif_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Jendranguta tanangupini ditjini mitaia kaparali Augustulu jirijiribana wonti, mita warupoto windamala. ");
INSERT INTO dif_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Naupini windamani ngoperala nganana wonti, jendranguta Kyrenius kapakapara Syria mitani nganana wonti. ");
INSERT INTO dif_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ja kana pratjana wapana wonti tanali tanana windamananto, kana pilki ja pilki nguraia tananaia. ");
INSERT INTO dif_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Jendranguta bakana Joseph tarana wonti Galilaiandru Nazaret ngurandru Judaia mitaia Davidani nguraia, tala nunkani Bethlehem, ngangau nau Davidani pungandru ja mardundru nganana wonti. ");
INSERT INTO dif_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Tanali nina windamananto Mariangunto, talpadakani noanto nunkani, nani mandrantju nganana wonti. ");
INSERT INTO dif_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Jendranguta, pudla jerra matja ngamana, ditji nankani wokarana wonti, nandru dankananto. ");
INSERT INTO dif_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ja nandru kupa kanku panturu dankana wonti, ja nina katieli karana wonti ja nganti pirrani kurana wonti, ngangau pudlangu piri pani nganana wonti ngurani. ");
INSERT INTO dif_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ja ngamalkanietja nunkangupini mitani palarani nganana wonti, tanali tinkani ngami tanani ngamalkana wonti. ");
INSERT INTO dif_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ja mai, Kaparaia angela kulno tanangu wondraterina wonti, ja Kaparaia pirnala tanangu mintjina wonti, ja tana japali pirna ngamana wonti. ");
INSERT INTO dif_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ja angela tanangu jatana wonti: „Wata japali ngananau; mai, mankini pirna ngato jurangu kaukaubala wapaia, nauja kanani warupotuni nganala nganai. ");
INSERT INTO dif_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ngangau Kulkanipirna jurangu karari dankana warai, Naupini Christus Kapara nganai, Davidani ngurani. ");
INSERT INTO dif_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ja naupini jurangu malka nganananto, jura kupa karaterinani mankamankala nganai, ja nganti pirrani paranani.“ ");
INSERT INTO dif_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ja nurujeli angela kulnuni angela wolara wora pariwilpandru wokarana wonti, tanali Goda jurakokana wonti ja jatana wonti: ");
INSERT INTO dif_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","„Pirnala Godani miri, ja murla mitani, ja Godali kana ngantjai.“");
INSERT INTO dif_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Jendranguta angela wolara wora tanangundru matja pariwilpani tikana tarana, ngamalkanietja ngankamalina wonti: „Ngaiana Bethlehemia wapananto jenia jaurandru, tana Kaparali ngaianangu wondrana warai, najila, mina pantjina warai.“ ");
INSERT INTO dif_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ja nurujeli tana wapana wonti, ja Joseph ja Maria mankamankana wonti, ja bakana kupa nganti pirrani paranani. ");
INSERT INTO dif_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Tanali nina matja najina, tanali jenia jaura piltjaru ngankana wonti, tanangu matja kaukaubana nunkangupini kupandru. ");
INSERT INTO dif_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ja pratjanali, tanali jenia ngarana, ngaruparana wonti nunkangundru, mina ngamalkanietjali tanangu kaukaubana warai. ");
INSERT INTO dif_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ja Mariandru tananapini jaura pratjana ngamalkana wonti, ja ngarali nankanali ngundrana wonti. ");
INSERT INTO dif_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ja ngamalkanietja tikana wonti ja Goda pirna ngundrana wonti ja jurakokana wonti pratjanandru, mina tanali ngarana ja najina warai, worderu tanangu matja kaukaubana.");
INSERT INTO dif_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ja ditji mara wora ja mandru matja mudana, tanali nina kupa karuwali ngankana wonti; ja tanali nunkangu bakana tala jinkina wonti „JESUS,“ worderu angelali nina morla ngopera dikana wonti, Nau mandrani kantjirina warai.");
INSERT INTO dif_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ja kulirkani ditji nankani matja mudana Mosini jirijiribani jaurandru, pudlali nina Jerusalemia taralkana wonti, nina Kaparani wondralkala. ");
INSERT INTO dif_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Worderu Kaparaia jirijiribani jaurani parai: „Kanku pratjana ngandrindru ngopera dankana, Kaparani kulikiri nganala nganai.“ ");
INSERT INTO dif_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ja poto ngumu jinkila, worderu Kaparaia jirijiribani jaura jatai: „Mulapara mandru kara, waparu wolka mandru kara.“ ");
INSERT INTO dif_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ja mai, kana kulno Jerusalemani nganana wonti, tala nunkani Simeon, ja naupini kana talku ja Godandru japali nganana wonti ja Israelaia ngankalkanani wolkareli kalkana wonti; ja Jaola kulikiri nunkangunto nganana wonti. ");
INSERT INTO dif_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ja nunkangu tinkari nganana wonti Jaola kulikirindru, nulu nari wata najinanto, a‐ai, nulu ngopera Kaparaia Christus najinanto. ");
INSERT INTO dif_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ja nau Jaolali Godaia pungani wirina wonti. Ja pudlali Jesus kupa wirilkanani nunkangu ngankala, worderu tanali jirijiribani jaurandru milingeru ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Bakana nulu nina ngunali nunkanali munamana wonti ja Goda jurakokana wonti ja jatana wonti: ");
INSERT INTO dif_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","„Kaparajai, karari jundru milini jinkanani manuni kurala wapai wapananto, worderu jundru ngakangu talpadakanala. ");
INSERT INTO dif_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ngangau ngato milkieli Kulkanipirna jinkani najila wapaia. ");
INSERT INTO dif_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ninapini jundru ngankingana wonti kana mudla warupotuja. ");
INSERT INTO dif_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Praitji kulno kana koni mintjila, ja pirnala Israel kana wolarani jinkanani.“");
INSERT INTO dif_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ja ngaperi nunkani ja ngandri nunkani ngaruparana wonti jenia jaurandru, mina nau nunkangundru jatana warai. ");
INSERT INTO dif_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ja Simeonali tanana ngurungutana wonti, ja Mariangu ngandrini nunkanani jatana wonti: „Mai, Naupini parai marapu Israelani nunkangu purinanto ja jiritjinanto, ja malka nganala, nunkangu tanali tjakakala nganai. ");
INSERT INTO dif_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ja kalti tiri bakana jinkangu mungarani palkingala nganai, kana marapuja ngarali ngundrani wondraterinanto.“ ");
INSERT INTO dif_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ja Propheta widla Hanna naka nganana wonti, Phanuelani ngatamura, Asserani mardundru; nani ditji marapuni wiringana wonti, nani noanto kilpawoldra mara wora ja mandru matja tepi ngamana. ");
INSERT INTO dif_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ja nani mangawaru nganana wonti tidna ja mara pratjana ja kulno pota mandru ja mandru; nanipini milingeru Godaia pungani ngamana wonti ja milja ngamana wonti ja ngatjina wonti, ja ditjini ja tinkani mili ngamana wonti. ");
INSERT INTO dif_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nanipini bakana nunkangupini ditjini karakara wokarana wonti, ja nandru Goda jurakokana wonti ja pratjanani nunkangundru kaukaubana wonti, tanali Jerusalemani Kulkanipirnani kalkana wonti. ");
INSERT INTO dif_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ja pudlali pratjana Kaparaia jirijiribani jaurandru matja mudana, pudla tikana kurana wonti Galilaia mitaia Nazaret nguraia tananaia. ");
INSERT INTO dif_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ja kupa pirnarina wonti ja ngurungururina wonti ja manamiri nganana wonti milkilali, ja Godaia manjula nunkangunto nganana wonti.");
INSERT INTO dif_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ja ngaperi ja ngandri nunkani milingeru kilpawoldrani pota kulno Jerusalemia palkana wonti wiringani ditji pirnani. ");
INSERT INTO dif_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ja Nau matja kilpawoldra marapratjana ja mandru nganana, pudla tarana wonti Jerusalemia, worderu milingeru ditji pirnani. ");
INSERT INTO dif_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ja ditji pirna matja mudana, pudla tikana kurana wonti; ja Nau kanku Jesus Jerusalemini ngamantina wonti, ja Joseph ja ngandri nunkani ko nganana wonti. ");
INSERT INTO dif_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Pudlali ngundrana wonti, Nau kamanelini jela nganai, ja ditji kulno matja palkana, pudlali nina wontina wonti kamanelini ja nguralani. ");
INSERT INTO dif_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ja pudlali nina wata mankamankana, pudla nakaldra tikana wonti Jerusalemia nina wontila. ");
INSERT INTO dif_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ja jendranguta ditji parkulani pudlali nina mankamankana wonti Godaia pungani, worderu Nau jaura jinkinietjani terti ngamanani tanana ngarala ja jakalkala. ");
INSERT INTO dif_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ja pratjanali nina matja ngarana, pirna ngaruparana wonti nunkani tjuru ngumundru ja kalabanandru. ");
INSERT INTO dif_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ja pudlali nina matja najina, pudla pirna ngaruparana wonti, ja ngandri nunkani nunkangu jatana wonti: „Ngataniai, minandru jundru jenia ngankala wiri ngalingu? mai, ngaurongaurojeli ngaperali jinkanali ngali jidna wontina warai.“ ");
INSERT INTO dif_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ja Nau pudlangu jatana wonti: „Minandrn judla ngana wontina warai? Wata judla ngujamai, ngani nganananto ngakani Ngaperaia pungani?“ ");
INSERT INTO dif_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ja pudlali jaura nunkani bulu ngujamana wonti, tanana Nau pudlangu jatana wonti. ");
INSERT INTO dif_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ja Nau pudlangu jela tikana wonti Nazaret nguraia, ja pudlangu wodatarana ngamana wonti. Ja ngandrieli nunkanali tananapini jaura pratjana ngamalkana wonti ngarali nankanali. ");
INSERT INTO dif_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ja Jesus morla milkila pantjina wonti ja pirnarina wonti ja Godali ja kanali nina morla ngantjana wonti.");
INSERT INTO dif_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tiberius kilpawoldra marapratjana ja mara wora mitaia kapara matja ngamana, Pontius Pilatus najinajibanietja Judaiani, ja Herodes kapakapara Galilaiani, ja Philippus neji nunkani kapakapara Ituraiani ja Trachonitis mitani, ja Lysanias kapakapara Abyleneni, ");
INSERT INTO dif_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ja Hannas ja Kaiphas Priesta pirna nganana wonti. Jendranguta Johanningu Zachariani ngatamurani Godaia jaura pantjina wonti pitarani. ");
INSERT INTO dif_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ja nau mitani Jorda kaiarani karakara wokarana wonti ja madlentjandru karitjimalkani multibani jaura kaukaubana wonti madlentji kalingala. ");
INSERT INTO dif_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Worderu Jesaiani Prophetaia jaurani parai, jeruja jatanani: „Karkanietjaia ngaiala pitarani parai: Kaparaia palto ngankinganimai ja tidna palto nunkani talku ngankanimai. ");
INSERT INTO dif_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Wipawipa pratjana palparu pantjila nganai, ja mardawonpa ja dako pratjana waka pantjila nganai; ja kuntikunti talku, ja palto diladila palara pantjila nganai. ");
INSERT INTO dif_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ja kana warupotujeli Godaia Kulkanipirna najila nganai.“ ");
INSERT INTO dif_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nulu kana wolarani, tana nunkangu dunkana wonti nunkangundru multibanila manila, jatana wonti: „Wiparaia kuparu worajai! Warlenulu jurangu wondrana wonti japa mindrinanto tirini, nau wokarala nganai? ");
INSERT INTO dif_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Madlentjandru karitjinaia tandra talku punkibanau, ja wata wonianau jataterila: «Ngaiana Abraham ngaperi ngaianani ngamalkai;» ngangau ngani jurangu jatai, Goda ngurunguru nganai tanangupini mardandru kupa jiritjibala Abrahamangu. ");
INSERT INTO dif_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kalara matja pita kaparani parai; pita pratjana, wata tandra ngumu punkibanani wokaribala nganai ja turuni worala nganai.“ ");
INSERT INTO dif_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ja kana wolarali nina jekibana wonti ja jatana wonti: „Mina ngaiani ngankananto?“ ");
INSERT INTO dif_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Nulu kalabana wonti ja tanangu jatana wonti: „Warle kati mandru ngamalkai, nulia nunkangu jinkiatimai, nulia wata ngamalkai; ja warle buka ngamalkai, ngankaiatimai bakana jeruja.“ ");
INSERT INTO dif_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ja bakana mardatandrakampanietja wokarana wonti multibanila manila, ja nunkangu jatana wonti: „Ngujangujara jinkinietjajai, mina ngaiani ngankananto?“ ");
INSERT INTO dif_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Nau tanangu jatana wonti: „Kampanimai mina jurangu parai kampananto, wata morla!“ ");
INSERT INTO dif_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Bakana kalti ja kirraetjali nina jekibana wonti ja jatana wonti: „Ja ngaiani, mina ngaiani ngankananto?“ Ja nau tanangu jatana wonti: „Wata kulno jupanau, ja wata kaukau wapanau, ja murlali ngananau kalalani juranani!“ ");
INSERT INTO dif_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Kana wolara kalkaterina wonti, ja pratjana ngarali tananali ngundrana wonti Johanningundru, nauja munta Christus nganai kara. ");
INSERT INTO dif_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Johannili kalabana wonti ja jatana wonti pratjanani: „Ngato jurana ngapali multibai, ngakangu ngadani kulno wokarala nganai, Nau morla ngurunguru nganai ngakangu; nunkangu ngani wata talku nganai nunkani jinka tidnaputandru dukarala. Nulu jurana multibala nganai Jaolali kulikirieli ja turujeli. ");
INSERT INTO dif_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Marani nunkanani pirra nunkani parai, ja Nulu jiraua nunkani darpala nganai, ja buka tandra nunkani kampani pungaia mapala nganai, ja ngurdi Nulu japila nganai turujeli, nau wata paliai.“ ");
INSERT INTO dif_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ja morla marapu nulu kurukurubana wonti ja ngantjani jaura kana wolarani kaukaubana wonti. ");
INSERT INTO dif_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Herodili kapakaparali, ninapini nulu kurukurubana wonti Herodias nunkanaia nejia noandru, ja madlentji pratjanandru, mina Herodili ngankana wonti, ");
INSERT INTO dif_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Pratjanani bakana jenia ngokana wonti, ja Johannes kanjangari pungani widmana wonti. ");
INSERT INTO dif_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Jendranguta kana pratjanali multibanila manina wonti, ja bakana Jesujeli multibanila manina wonti, ja Nau ngatjinani pariwilpa piririna wonti. ");
INSERT INTO dif_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ja Jaolali kulikirieli nunkangu ngarina wonti kantji mulapara jeribaka, ja ngaiala kulno pariwilpandru pantjina wonti ja jatana wonti: „Jidni Ngatamura ngantjalu ngankani nganai, jinkangu ngani murlali nganai.“ ");
INSERT INTO dif_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ja Jesus matja kilpawoldra pota parkulu marapratjana nganana, Nulu woninani; ja Nau, worderu kanali ngundrana wonti, Ngatamura nganana wonti Josephani, nau Elini. ");
INSERT INTO dif_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Nau Matthatani, nau Levini, nau Melchini, nau Janani, nau Josephani. ");
INSERT INTO dif_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Nau Mattathiani, nau Amonani, nau Nahumani, nau Eslini, nau Naggaiani. ");
INSERT INTO dif_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nau Maathani, nau Mattathiani, nau Semeiani, nau Josephani, nau Judani. ");
INSERT INTO dif_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Nau Joananani, nau Rhesani, nau Zorababelani, nau Salathielani, nau Neriani. ");
INSERT INTO dif_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nau Melchiani, nau Addiani, nau Kosamani, nau Elmodamani, nau Erani. ");
INSERT INTO dif_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Nau Joseani, nau Elieserani, nau Jorimani, nau Matthatani, nau Levini, ");
INSERT INTO dif_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Nau Simeonani, nau Judani, nau Josephani, nau Jonasani, nau Eliakimani. ");
INSERT INTO dif_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Nau Meleani, nau Menani, nau Mattathani, nau Nathanani, nau Davidani. ");
INSERT INTO dif_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Nau Jesseni, nau Obedani, nau Boasani, nau Salmonani, nau Nahessonani. ");
INSERT INTO dif_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nau Aminadabani, nau Aramani, nau Esromani, nau Pharesani, nau Judani. ");
INSERT INTO dif_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Nau Jakobani, nau Isaakani, nau Abrahamani, nau Tharani, nau Nachorani. ");
INSERT INTO dif_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nau Sarungani, nau Raguani, nau Phalekani, nau Eberani, nau Salahani. ");
INSERT INTO dif_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Nau Kainani, nau Arphachsadani, nau Semini, nau Noahni, nau Lamechani. ");
INSERT INTO dif_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Nau Methusalahani, nau Enochani, nau Jaredani, nau Mahaleelani, nau Kainani. ");
INSERT INTO dif_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Nau Enosani, nau Sethani, nau Adamani, nau Godaia. ");
INSERT INTO dif_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesus Jaola kulikirieli manamiri Jordan kaiarandru tikana wonti; ja Jaolali nina pitarani wirilkana wonti, ");
INSERT INTO dif_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Kutjieli nina pira mara kulno ja ditji marapratjana wontjananto. Ja Nulu tanangupini ditjini panila tajina wonti; ja tana matja mudana, Nau mauali nganana wonti. ");
INSERT INTO dif_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ja kutji nunkangu jatana wonti: „Jidni Godaia Ngatamura ngananani, nunkangupini mardani jatamai, nau bukarinanto.“ ");
INSERT INTO dif_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesujeli kalabana wonti ja nunkangu jatana wonti: „Dakanala parai: Wata windri bukandru kana tepiriai, a‐ai, Godaia jaura pratjanandru.“ ");
INSERT INTO dif_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ja kutjieli nina mardawonpa miria taralkana wonti, ja nunkangu nurujeli mitaia kaparaia warupotuja milila wondrana wonti. ");
INSERT INTO dif_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ja kutji nunkangu jatana wonti: „Jinkangu ngato tananapini ngurula pratjana ja tanani pirnala jinkila nganai; ngangau ngakangu naupini matja jinkina, ja nunkangu ngani jertapateriai jinkila, ngato ninaia jinkila nganai. ");
INSERT INTO dif_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Jidni ngakangu pantjaterkana ngarinani, jenia pratjana jinkani nganala nganai.“ ");
INSERT INTO dif_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ja Jesujeli kalabana wonti ja nunkangu jatana wonti: „Ngakangu ngadaia nganamai, Satanajai! Ngangau dakanala parai: Jidni Godani Kaparani jinkanani ngatjiamai, ja windri nunkangu wodatarana jidni ngamamai.“ ");
INSERT INTO dif_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ja nulu nina Jerusalemia wapalkana wonti ja Godaia punga wutjuni terkibana wonti ja nunkangu jatana wonti: „Jidni Godaia Ngatamura ngananani, ninkidandru ngarinalu kulkungamai! ");
INSERT INTO dif_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ngangau dakanala parai: Nulu angelani nunkanani jinkangundru jirijiribala nganai jidnana ngumu ngamalkala; ");
INSERT INTO dif_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ja tanali jidna marali ngamalkala nganai, wata jidni tidna mardali dakaterinanto.“ ");
INSERT INTO dif_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ja Jesujeli kalabana wonti ja nunkangu jatana wonti: „Jaura jatai: Goda, Kapara jinkani wata wontjamai!“ ");
INSERT INTO dif_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ja kutjieli wontjana pratjana matja mudana, nau nunkangundru kutingana wonti miljaru pilkielu. ");
INSERT INTO dif_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ja Jesus Jaolali ngurungurujeli tikana wonti Galilaiaia, ja pinti nunkangundru karitjinawontiwontikana wonti mita marapuni karakara. ");
INSERT INTO dif_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ja Nulu ngujangujara jinkina wonti jaura pungani tananani, ja tanali pratjanali nina jurakokana wonti. ");
INSERT INTO dif_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ja Nau Nazaretani wokarana wonti, woderi Nau pirnarinala; ja Nau Godaia ditjini jaura pungani wirina wonti worderu milingeru, ja terkakana wonti warapala. ");
INSERT INTO dif_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ja tanali nunkangu Jesaiani jaura jinkina wonti, ja Nulu nina matja pirakana, Nulu mankamankana wonti nina piri, woderi dakanala paranani: ");
INSERT INTO dif_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","„Kaparaia Jaola ngakangu nganai, jendrania Nulia ngana wiribana wonti ngantjani jaura wangiwangini kaukaubala; ja Nulia ngana jinpana wonti ngara ngaurongauro murlali ngankala ja kanjangarini kurakana kaukaubala, ja butjuni nakaldra najina ngankala; ja tanana tapanto kurakana dadala, ");
INSERT INTO dif_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Kaparaia kilpawoldra murlali kaukaubala.“ ");
INSERT INTO dif_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ja Nulu jaura matja punmana, ja milini nakaldra jinkina, Nau ngamana ngarina wonti; ja pratjana, jaura pungani ngamana, nina ngurutalpana najina wonti. ");
INSERT INTO dif_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Nau wonina wonti tanangu jatala: „Karari jenia jaura jurangu talpani morlalu pantjina warai.“ ");
INSERT INTO dif_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ja tanali pratjanali nunkangundru tinkari ngankana wonti ja ngaruparana wonti murlaia jaurandru, jenia nunkani manandru dunkana wonti, ja jatana wonti: „Wata naupini Josephani ngatamura nganai?“ ");
INSERT INTO dif_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ja Nau tanangu jatana wonti: „Morlalu jura ngakangu jenia jeribaka jaura jatala nganai: «Kunkiai, munta tepi ngankateriau! Pirnala marapu ngaiani ngarana warai Kapernaum ngurani matja pantjina, ngankau jenia bakana ninkida jinkani ngaperaia ngurani!»“ ");
INSERT INTO dif_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Nau jatana wonti: „Morlalu ngani jurangu jatai: Wata Propheta kulno kamaneli nganai ngaperaia ngurani. ");
INSERT INTO dif_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Morlalu ngani jurangu jatai: Mangawaru marapu nganana wonti Eliani ditjini Israelani, jendranguta pariwilpa ngurunguru nganana wonti kilpawoldra parkulu ja pira mara wora ja kulno, ja mita marapuni maua pirna nganana wonti; ");
INSERT INTO dif_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ja wata tanangundru kulnuja Elias jinpanala, a‐ai, windri mangawaru kulnuja Sidon mitaia Sarepta nguraia. ");
INSERT INTO dif_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ja kana gambanto marapu Israelani nganana wonti Propheta Elisani ditjini, ja wata kulno tanangundru nulu kulirkana wonti, windri Naeman Syriala.“ ");
INSERT INTO dif_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ja jaura pungalali pratjanali jenia matja ngarana, tana tiri pirna pantjina wonti. ");
INSERT INTO dif_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ja tana terkakana wonti, ja nina ngurandru tertubana wonti, ja nina marda tuluraia taralkana wonti nunkangupini kalikalini tanani ngura matja wotina, nina tertubana ngarila. ");
INSERT INTO dif_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ja Nau tanangu terti palkingana wonti ja wapana wonti. ");
INSERT INTO dif_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ja Nau Kapernaum nguraia ngarina wonti Galilaia ngura kulnuni, ja Nulu tanangu ngujangujara jinkina wonti Sabbat ditjini. ");
INSERT INTO dif_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ja tana ngaruparana wonti nunkani ngujangujarandru, ngangau jaura nunkani ngurunguru nganana wonti. ");
INSERT INTO dif_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ja jaura pungani kana kulno nganana wonti, nulu kutji murumuru ngamalkana wonti, ja nau ngaiala pirnali maritjina wonti, ");
INSERT INTO dif_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Ja jatana wonti: „Burru! Mina ngaianingu ja jinkangu, Jesujai Nazarenalajai! jidni wokarana warai ngaianina teribala? Ngato jidna ngujamai worana jidni nganai, Godaia kulikiri.“ ");
INSERT INTO dif_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ja Jesujeli nina daudauana wonti ja jatana wonti: „Ngapuriau ja nunkangundru dunkau!“ Ja kutjieli nina terti worana wonti ja nunkangundru dunkana wonti, ja nina wata patibana wonti. ");
INSERT INTO dif_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ja pratjana japali ngaruparana wonti ja ngankamalina wonti ja jatana wonti: „Mina jaura naupini nganai? ngangau ngurungurujeli ja pirnalali Nulia kutjini murumuruni jirijiribai, ja tana dunkai.“ ");
INSERT INTO dif_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ja pinti nunkangundru karitjinawontiwontikana wonti ngura marapuni karakara. ");
INSERT INTO dif_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Nau jaura pungandru terkakana wonti ja Simonani pungani wirina wonti; ja Simoni paiara muntja turuturu pirna nganana wonti, ja tana nunkangu ngatjina wonti nankangundru. ");
INSERT INTO dif_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ja Nau nankangu buruna ngarina wonti, ja Nulu muntja turuturuni dikidikibana wonti, ja nau nankangundru puntina wonti; ja nurujeli nani jiritjina wonti ja tanangu mili nganana wonti. ");
INSERT INTO dif_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ja ditji wirinani, pratjana tanali kana muntja muntja nguja pilkipilki marapu ngananani, nunkangu wapalkana wonti. Ja Nau tanangu pratjanani mara kuraterina wonti ja tanana tepi ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ja bakana kutji wora marapundru dunkana wonti, tana maritjina wonti ja jatana wonti: „Jidni Christus, Godaia Ngatamura nganai!“ Ja Nulu tanana daudauana wonti ja tanangu wata manuni kurana wonti jatananto, ngangau tana milkila nganana wonti, Nauja Christus nganai. ");
INSERT INTO dif_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ja matja ditjirina, Nau puntina wonti ja palkana wonti pitaraia; ja kana wolarali nina wontina wonti ja nunkangu wokarana wonti, ja tanali ngantjana wonti nina patala, Nau tanangundru puntiati. ");
INSERT INTO dif_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Nau tanangu jatana wonti: „Bakana ngura nguruni ngato ngantjani jaura Godaia mililandru kaukaubananto; ngangau jendrania Nulia ngana jinpanala.“ ");
INSERT INTO dif_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ja Nulu ngujangujara jinkina wonti Galilaia jaura punga worani. ");
INSERT INTO dif_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Jendranguta kana wolarali nina jenijenina wonti Godaia jaura ngarala, ja Nau Genezaret pantuni terkana wonti. ");
INSERT INTO dif_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ja Nulu bota mandru panto dirkalani paranani najina wonti; ja parumaninietja dunkana kurana wonti jama kulirkala. ");
INSERT INTO dif_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Nau botani kulnuni wirina wonti, Simonanani nunkanani, ja nunkangu ngatjina wonti, nulu ninaia ngalje ngapani tirimalkana ngarinanto; ja Nau ngamana ngarina wonti ja kana wolarani ngujangujara jinkina wonti botandru. ");
INSERT INTO dif_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nulu matja mudana jaura jatana, Nau Simoningu jatana wonti: „Ngapa mandraia bota ngarilkamai, ja jama jurani woranau paru patala!“ ");
INSERT INTO dif_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ja Simonali kalabana wonti ja jatana wonti nunkangu: „Kaparajai, ngaiani tinkawirdi jiglerali ngankana warai ja panila patana warai; ja jinkani jaurani ngato jama worala nganai.“ ");
INSERT INTO dif_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ja tanali jenia ngankana, tanali paru marapu patana wonti, ja jama tanani puraterina wonti. ");
INSERT INTO dif_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ja tanali kamaneli tanani bota nguruni marali karkana wonti tana wokarananto marangokala; ja tana wokarana wonti ja bota wulana manamiri ngankana wonti ngampu kunakutinanto. ");
INSERT INTO dif_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simon Petrulu jenia najina, nau Jesungu pantjani woraterina wonti ja jatana wonti: „Kaparajai, ngakangundru dunkau, ngangau ngani kana madlentji nganai!“ ");
INSERT INTO dif_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ngangau nau japali ngaruparana wonti, ja pratjana nunkangunto, jenia paru marapundru, tanali jelali patana warai. ");
INSERT INTO dif_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Jeruja bakana Jakobus ja Johannes Zebedäuni ngatamura wulu Simonani kamaneli. Ja Jesus Simoningu jatana wonti: „Wata japali nganau; ngangau kararindru jidni kana maninietja nganala nganai!“ ");
INSERT INTO dif_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ja tanali bota wulana dirkalani tirimalkana wonti ja pratjana worarana wonti ja nunkangu karipaterina wonti.");
INSERT INTO dif_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ja jendranguta Nau ngura kulnuni nganana wonti, ja mai, kana kulno gambanto, nulu Jesus najina, nau mudlani woraterina wonti ja nunkangu ngatjina wonti ja jatana wonti: „Kaparajai, jidni jertapaterinani, jidni ngurunguru nganai ngana kulikiri ngankala.“ ");
INSERT INTO dif_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ja Nau mara warpina wonti ja nina karakarana wonti ja jatana wonti: „Ngani jertapateriai, kulikiri nganamai!“ ja nurujeli gamba nunkangundru kutingana wonti. ");
INSERT INTO dif_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ja Nulu nunkangu jirijiribana wonti wata kulnuni jenia kaukaubala, a‐ai, wapau, ja Priestani wondrateriau, ja jinkani kulirkanandru jenia poto jinkiau, worderu Mosili jirijiribana wonti, tanangu malka nganananto. ");
INSERT INTO dif_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ja jaura nunkangundru kanani marurina wonti, ja kana wolara nunkangu jurborina wonti nina ngarala, ja tanani muntjandru nunkangundru tepi manila. ");
INSERT INTO dif_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Nau kurukurumalkaterina wonti pitarani ja ngatjina wonti. ");
INSERT INTO dif_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ja jendranguta ditji kulnuni Nulu ngujangujara jinkina wonti; ja jerra Pharisaia ja jirijiribani jaura jinkinietja ngamana wonti, tana Galilaia ja Judaia ngura pratjanandru ja Jerusalemingundru wokarana wonti; ja Kaparaia ngurula nganana wonti tanana tepi ngankala. ");
INSERT INTO dif_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ja mai, materali kana kulno wokaralkana wonti turarani pirini paranani, nau tjunduru nganana wonti; ja tanali wontina wonti nina wirilkala ja nunkangu terkibala. ");
INSERT INTO dif_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ja tanali kana wolarandru wata mankamankana wonti, worderu tanali nina wirilkananto, tana punga mangatandrani tarana wonti, ja nina turarani pirieli punga mangatandrandru ngarilkana wonti, tanangu terti Jesungu. ");
INSERT INTO dif_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ja Nulu tanani morlalu ngundrana matja najina, Nau nunkangu jatana wonti: „Kanajai, madlentji jinkani matja worana warai!“ ");
INSERT INTO dif_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ja jaura jinkinietjali ja Pharisaiali wonina wonti ngundrala ja jatana wonti: „Worana Naupini nganai, Nulu ngirkibani jaura jatai Godani? Worana ngurunguru nganai madlentji kalingala, kalitakali Goda kulnulu?“ ");
INSERT INTO dif_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesulu tanani ngundrana matja talku ngujamana, Nulu kalabana wonti ja tanangu jatana wonti: „Mina jura ngarali juranali ngundrai? ");
INSERT INTO dif_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Mina morla ngaua nganai jatala kara: Madlentji jinkani matja worana, jatala kara: Terkakamai ja wirariau?“ ");
INSERT INTO dif_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ngangau jura ngujamananto Kanaia Ngatamurajeli ngurula ngamalkai mitani madlentji worala, Nau tjundurani jatana wonti: „Ngani jinkangu jatai: Terkakamai, turarani piri jinkani patau, ja pungaia jinkanaia tikau!“ ");
INSERT INTO dif_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ja nurujeli nau tanangu milkini terkakana wonti, ja nulu turarani piri, nunkangu nau parana, patana wonti, ja pungaia nunkanaia tikana wonti ja Goda jurakokana wonti. ");
INSERT INTO dif_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ja pratjana pirna ngaruparana wonti, ja tanali Goda jurakokana wonti ja japali pirna pantjina wonti ja jatana wonti: „Ngaiani nguja tula karari najina warai.“ ");
INSERT INTO dif_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ja ngadani Nau wapana wonti, ja Nulu mardatandrakampanietja najina wonti, tala nunkani Levi, kampani pungani ngamanani, ja Nau nunkangu jatana wonti: „Ngakangu karipateriau!“ ");
INSERT INTO dif_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ja nulu pratjana worarana wonti, ja nau terkakana wonti ja nunkangu karipaterina wonti. ");
INSERT INTO dif_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ja Levili nunkangu buka pirna ngankingana wonti pungani nunkanani, ja naka mardatandrakampanietja marapu ja kana nguru nganana wonti, tana tanangunto kurlini ngamana wonti. ");
INSERT INTO dif_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ja jaura jinkinietja ja Pharisaia milini nunkanani kuterina wonti ja jatana wonti: „Minandru jura mardatandrakampanietjani ja kana madlentjani jela tajiai ja tapai?“ ");
INSERT INTO dif_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ja Jesujeli kalabana wonti ja tanangu jatana wonti: „Tepieli wata kunki ngundrai, a‐ai, windri muntjali. ");
INSERT INTO dif_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ngani wata wokarana warai kana talku karkala, a‐ai, windri kana madlentji madlentjandru karitjinanto.“ ");
INSERT INTO dif_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Tana nunkangu jatana wonti: „Minandru Johannini milieli jiglerali milja ngamai ja ngatjiai, jeruja bakana Pharisaiani mili, ja milieli jinkanali tajiai ja tapai?“ ");
INSERT INTO dif_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Nau tanangu jatana wonti: „Jura ngandandariai noangantjanipirnaia kamaneli milja ngankala, noangantjanipirna tanangu jela ngananani? ");
INSERT INTO dif_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ditji wokarala nganai, tanali noangantjanipirna tanangundru manila nganai, ngadani tanaia milja ngamala nganai tanangupini ditjini.“ ");
INSERT INTO dif_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Nau tanangu bakana jeribaka jaura jatana wonti: „Wata kulnujeli kati buru tjela kati marrandru kati womalani karpai, a‐ai, jenia wata windri kati marra purateriai, nau kati tjela marra bakana kati womalani wata talku nganai. ");
INSERT INTO dif_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ja bakana wata kulnujeli waina marra junga womalani kurarai, a‐ai, waina marrali junga wakaribaiati, ja wata windri waina baku ngakala nganai, bakana junga tintaterila nganai; ");
INSERT INTO dif_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","A‐ai, tanali waina marra junga marrani kurarananto, ja pudlana jela kulkananto. ");
INSERT INTO dif_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ja wata kulnujeli, nulu waina warula matja tapana, marra ngantjai; ngangau nau jatai: Nauja warula morla ngumu nganai.“ ");
INSERT INTO dif_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Jendranguta Nau Sabbat ditji pirna mandrulani buka maruni palkingana wonti; ja milieli nunkanali bukatandra mangatandra wokaribana wonti, ja marali turbana tajina wonti. ");
INSERT INTO dif_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Pharisaia palpa jatana wonti tanangu: „Minandru jura jenia ngankai, mina wata talku nganai Sabbat ditjini?“ ");
INSERT INTO dif_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesujeli tanangu kalabana wonti ja jatana wonti: „Jura wata jenia warapanala mina Davidali ngankana wonti, jendranguta nau munta mauali nganana wonti ja tana nunkangunto? ");
INSERT INTO dif_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Worderu nau Godaia pungani wirina wonti ja wondrani buka manina wonti ja tajina wonti, ja bakana tanangu nunkangunto jinkina wonti? tanana tajila wata kulnuni manuni kuranala, a‐ai, windri Priestani.“ ");
INSERT INTO dif_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ja Nau tanangu jatana wonti: „Kanaia Ngatamura bakana Sabbat ditjia Kapara nganai.“ ");
INSERT INTO dif_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Jendranguta Sabbat ditji nguruni Nau jaura pungani wokarana wirina wonti ja ngujangujara jinkina wonti; ja naka kana kulno nganana wonti, nau mara ngunari muja nganana wonti. ");
INSERT INTO dif_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Jaura jinkinietjali ja Pharisaiali nina kurukuru najinajibana wonti, Nulu Sabbat ditjini tepi ngankala nganai kara; ngangau tanali mankamankananto nunkangundru ngulkuterkala. ");
INSERT INTO dif_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Nulu ngundrana tanani ngujamana wonti, ja nunkangu kanani nau mara muja ngananani jatana wonti: „Jiritjiau ja terti terkakamai!“ Nau jiritjina wonti ja terkana wonti. ");
INSERT INTO dif_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jesus tanangu jatana wonti: „Ngato jurana minakulno jakalkai: «Jenia talku nganai Sabbat ditjini, ngumu ngankala kara, madlentji ngankala kara? Mungara kulkala kara, nari ngankala kara?»“ ");
INSERT INTO dif_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ja Nulu tanana pratjana najina karitjina wonti ja nunkangu jatana wonti: „Mara ngutateriau!“ Nulu jeruja ngankana wonti, ja nau mara nakaldra tepi nganana wonti mara nguru jeribaka. ");
INSERT INTO dif_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Tana tiri pirna pantjina wonti ja ngankamalina wonti, mina tanali Jesungu ngankananto. ");
INSERT INTO dif_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Jendranguta tanangupini ditjini Nau mardawonpaia tarana wonti ngatjila; ja Nau tinkawirdi Godani ngatjina wonti. ");
INSERT INTO dif_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ja matja ditjirina, Nulu mili nunkani karkana wonti nunkangu. Ja Nulu tanangundru mili marapratjana ja mandru kalkalkana wonti, tanana Nulu bakana Apostel dikana wonti: ");
INSERT INTO dif_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon, nina Nulu bakana Petrus dikana wonti, ja Andreas ngatata nunkani, ja Jakobus, ja Johannes, ja Philippus, ja Bartholomäus, ");
INSERT INTO dif_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Ja Matthäus, ja Thomas, ja Jakobus Alphäuni ngatamura, ja Simon, nina tanali dikai Zelotes, ");
INSERT INTO dif_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Ja Judas Jokobuni ngatamura, ja Judas Ischariot, nau wontawontanietja pantjina wonti. ");
INSERT INTO dif_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ja Nau tanangunto ngarina wonti ja terkana wonti mita palarani, ja nunkani mili wolara, ja kana wolara Judaiandru, ja Jerusalemingundru, ja Tyrus ja Sidon pantudirkala ngurandru, tana wokarana wonti nina ngarala ja tepi manila tanani muntjandru. ");
INSERT INTO dif_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Bakana jenipara kana, tanana kutji murumurujeli jupana, tepi pantjina wonti. ");
INSERT INTO dif_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ja kana pratjanali wontina wonti nina karakarala, ngangau ngurula nunkangundru dunkana wonti ja pratjana tepi pantjina wonti. ");
INSERT INTO dif_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ja Nau milki tjenmana wonti milini nunkanani ja jatana wonti: „Murlali pirna jura wangiwangi, ngangau jurangu Godaia milila nganai. ");
INSERT INTO dif_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Murlali pirna jura karari mauali ngananani, ngangau jura jerto pantjila nganai; murlali pirna jura karari jindranani, ngangau jura kinkala nganai. ");
INSERT INTO dif_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Murlali pirna jura nganai, kana jurangu kalakalarinani, ja jurana pilki ngankanani, ja ngirkibanani, ja jurani tala madlentji jeribaka woranani Kanaia Ngatamurandru. ");
INSERT INTO dif_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Nunkangupini ditjini mankianimai ja kulkunganimai; ngangau mai, kalala jurani pirna nganai pariwilpani; ngangau jeruja ngaperali tananali Prophetani ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Jakajai jurangu poto pirnanto, ngangau jura ngankalkana jurani matja manina. ");
INSERT INTO dif_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Jakajai jurangu, jura jerto pirna ngananani, ngangau jura maua ngamala nganai; jakajai jurangu, jura karari kinkanani, ngangau jura ngaurongauro ngamala nganai ja jindrala nganai. ");
INSERT INTO dif_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Jakajai jurangu, kana pratjanali jurangundru ngumu jatanani, ngangau jeruja ngaperali tananali jedikantji Prophetani bakana ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ngani jurangu, tanalia ngaranani, jatai: Talpala jurani ngantjanimai; ngumu ngankanimai tanangu, tana jurangu kalakalarinani. ");
INSERT INTO dif_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Tanali jurangu kalala madlentji kuranani, tanangu kalala ngumu kuranau, ja ngatjianau tanangundru, tanali jurana ngirkibanani. ");
INSERT INTO dif_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Warlenulu jidnana ngadla kulno nandrai, nunkangu bakana ngadla kulno jinkiteriau; ja warlenulu jinkani kati pirna maniai, nunkangu bakana kati waka wata ngandrawalkau. ");
INSERT INTO dif_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Worananau jinkangu ngatjiai, nunkangu jinkiau; ja nunkangundru, nulu poto jinkani maniai, ninaia wata mamana tikau. ");
INSERT INTO dif_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ja worderu jura ngantjai kanali jurangu ngankananto, jeruja kakana jura tanangu ngankanimai! ");
INSERT INTO dif_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ja jura tanana ngantjanani, tanali jurana ngantjai, mina kalala jura ngamalkai? Ngangau bakana madlentjali tanani ngantjanipirna ngantjai. ");
INSERT INTO dif_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ja jura tanangu ngumu ngankanani, tanali jurangu ngumu ngankai, mina kalala jura ngamalkai? Ngangau bakana madlentjali jenildramata. ");
INSERT INTO dif_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ja jura tanangu woljaia jinkinani, tanangundru jura ngundrai nakaldra manila, mina kalala jura ngamalkai? Ngangau bakana madlentjali kana madlentjani woljaia jinkiai, nakaldra jenia jeribaka manila. ");
INSERT INTO dif_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Talpala jurani ngantjanimai, ja ngumu ngankanimai, ja woljaia jinkianimai, ja wata ngundranimai jenia matja tintana; ja kalala jurani pirna nganala nganai, ja jura Kapara pirnaia ngatamura nganala nganai; ngangau Nauja ngumu nganai tanangu jurakokani panini ja kana madlentjani. ");
INSERT INTO dif_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ngangau kalumiltjamiltjarianau, worderu bakana ngaperi jurani kalumiltjamiltjariai! ");
INSERT INTO dif_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Wata kalala kuranau, jeruja tanali jurangu wata kalala kurala nganai; wata dikidikibanau, jeruja tanali jurangu wata dikidikibala nganai; madlentji woranau, jeruja tanali jurani madlentji worarala nganai. ");
INSERT INTO dif_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Jinkianimai, jeruja jura manila nganai; koko ngumu, matja nankana ngarina, ja wijawijabana, ja manimiri nangaterinanilu tanali jurangu ngalpani jinkila nganai; ngangau mina kokujeli jura jinkiai, jenia jura nakaldra manina tikala nganai. ");
INSERT INTO dif_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ja Nau tanangu jeribaka jaura jatana wonti: Butju ngandandariai butjuni palto wondrala? Wata pudla jela kutuni purila nganai? ");
INSERT INTO dif_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mili wata kaparani nunkanani wiringai; nau matja kiririna, nau kaparani nunkanani jeribaka nganala nganai. ");
INSERT INTO dif_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ja minandru jundru tiwitiwi ngatatani jinkanani milkini najiai, ja pita wondra milkini jinkanani jundra wata najiai? ");
INSERT INTO dif_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Worderu jidni ngatatani jinkanani jatananto: ngatatajai, ngato pita tiwitiwi jinkani milkindru giltarananto, ja jundru muntali pita wondra milkini jinkanani wata najiai? Jidni kana jeljujelju, ngopera pita wondra jinkani milkindru giltaramai, ja ngadani jundru ngumu najinanto pita tiwitiwi ngatatani jinkanani milkindru giltarala. ");
INSERT INTO dif_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ngangau wata pita nindri ngumujeli tandra madlentji punkibai, ja wata pita nindri madlentjali tandra ngumu punkibai. ");
INSERT INTO dif_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ngangau tanali pita pratjana ngujamai tanani tandrandru; ngangau tanali dilkandru wata manawara kampai, ja dilka nindrindru wata waina tandra wokaribai. ");
INSERT INTO dif_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Kana ngumujeli nunkani ngara ngumundru ngumula dunkalkai, ja kana madlentjali nunkani ngara madlentjandru madlentji dunkalkai; ngangau ngara mananirindru nunkani mana jatai. ");
INSERT INTO dif_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Minandru jura ngana dikai: «Kaparajai, Kaparajai!» ja wata ngankai mina ngani jatai? ");
INSERT INTO dif_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Worana ngakangu wokarai, ja jaura ngakani ngarai, ja tanana ngankai; ngato jurangu wondrala nganai worangu jeribaka nauja nganai. ");
INSERT INTO dif_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nau kana kulnuni jeribaka, nulu punga wotinala, nulu mikari bakunala, ja nulu marda kapara marda tulurani kuranala. Ja ngapa kumari matja wokarana, kaiarali nunkangupini pungani tertabanala ja ngandandarinala nina tamburibala, ngangau marda tulurani matja wotinala. ");
INSERT INTO dif_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Warle matja ngarana, ja wata ngankana, nau kana kulnuni jeribaka nganai, nulu punga mita ngalarani wotinala marda kapara pani; ja kaiarali nina tertabana, ja nurujeli nau tamburinala, ja nunkanipini pungaia tamburini pirna ngananala.“ ");
INSERT INTO dif_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nulu jaura nunkani pratjana kana wolaraia talpani matja mudana, Nau Kapernaum ngurani wirina wonti. ");
INSERT INTO dif_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Juljaia kapara kulnuja mili, nina nulu ngantjana wonti, muntja nganana wonti nari kupiri. ");
INSERT INTO dif_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nulu Jesungundru ngarana wonti, ja nulu Judaia kapara nunkangu jinpana wonti, ja nunkangu ngatjina wonti, Nau wokarananto milini nunkanani marangokala. ");
INSERT INTO dif_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Tana Jesungu matja wokarana, tana nunkangu parparali ngatjina wonti ja jatana wonti: „Nau talku nganai, jundru nunkangu jenia ngankananto. ");
INSERT INTO dif_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ngangau nulu ngaianana kana wolara ngantjai, ja jaura punga ngaianani nulu wotinala.“ ");
INSERT INTO dif_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jesus tanangunto wapana wonti. Ja Nau wata morla worita pungandru nganana, juljaia kaparali kamaeli nunkangu jinpana wonti tana nunkangu jatananto: „Kaparajai, wata ngara patau, ngangau ngani wata talku nganai jidni ngakangu pungani wirinanto. ");
INSERT INTO dif_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Jendrania ngani munta waka ngundraterina warai jinkangu wokarala; windri jaura kulno jatamai, ja mili ngakani tepirila nganai. ");
INSERT INTO dif_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ngangau bakana ngani kana nganai ja kaparani wodatarana ngamai, ja ngato mili wolara ngamalkai; ngani nunkangupini jatanani: Wapau, ja nau wapai; ja kulnuni: Kaparau, ja nau wokarai; ja milini ngakanani: Jenia ngankau, ja nulu jenia ngankai.“ ");
INSERT INTO dif_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesujeli jenia ngarana, Nau nunkangundru pirna ngaruparana wonti; ja Nulu najina karitjina wonti kana wolarani, nunkangu karipaterinani, ja jatana wonti: „Ngani jurangu jatai: Wata Israelani ngato jenipara morlalu ngundrana mankamankanala.“ ");
INSERT INTO dif_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ja tanali, tanana nulu jinpana, terpina tikana wonti, ja mili muntja tepi mankamankana wonti. ");
INSERT INTO dif_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ja ditji kulnuni Nau ngura kulnuja palkana wonti, Nain tala nunkani; ja mili nunkani marapu, ja kana wolara nunkangunto wapana wonti. ");
INSERT INTO dif_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nau ngura manani karakara wokarana, mai, tanali nari kulno padakana tarana wonti, nunkani ngandria ngatani kunakulno, ja nani mangawaru nganana wonti; ja kana wolara ngurandru nankangunto nganana wonti. ");
INSERT INTO dif_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Kaparali nana najina, Nau nankangu kalumiltjamiltjarina wonti ja nankangu jatana wonti: „Wata jindrau!“ ");
INSERT INTO dif_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ja Nau karakararina wonti, ja naria pirra patana wonti; ja wilimanietja banbana wonti. Ja Nau jatana wonti: „Teriai, ngani jinkangu jatai, terkakamai!“ ");
INSERT INTO dif_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ja narila ngamana tarana wonti, ja wonina wonti jatala. Ja Nulu nina ngandrini nunkanani jinkina tikana wonti. ");
INSERT INTO dif_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ja tana pratjana japali pantjina wonti ja Goda jurakokana wonti ja jatana wonti: „Propheta pirna ngaianangu terti jiritjina warai, ja Goda nunkani kana wolarani wokarana warai.“ ");
INSERT INTO dif_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ja nunkani pintipinti karitjinawontiwontikana wonti Judaia mitani paruparu, ja mita pratjanani karakara.");
INSERT INTO dif_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ja Johanningu milieli nunkanali jenia pratjana kaukaubana wonti. ");
INSERT INTO dif_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ja Johannili mili nunkani mandru karkana wonti ja pudlana Jesungu jinpana wonti ja jatana wonti: „Naumata jidni, Nau wokarananto kara, kulnuni ngaiani kalkananto?“ ");
INSERT INTO dif_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Pudla materi nunkangu wokarana wonti ja jatana wonti: „Johannes multibanietjali ngalina jinkangu jinpana warai ja jatana warai: Naumata jidni, Nau wokarananto kara, kulnunni gaiani kalkananto?“ ");
INSERT INTO dif_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Nunkangupini ditjini Nulu marapu tepi ngankana wonti muntjandru ja jupanandru ja kutji murumurundru, ja butju marapuni Nulu jinkina wonti najinanto. ");
INSERT INTO dif_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ja Jesujeli kalabana wonti ja pudlangu jatana wonti: „Tikalumai ja Johanningu kaukaubalumai, mina judla najila wapaia ja ngarala wapaia: Butjulali najiai, tjundurula wapai, gambala kulikiri pantjiai, talpakurulali ngarai, narila tepi terkakai, wangiwangieli ngantjani jaura ngarai. ");
INSERT INTO dif_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ja murlali pirna naupini nganai, nau ngakangu wata buljubuljuriai.“ ");
INSERT INTO dif_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Johannini mili matja tikana, Nulu wonina wonti kana wolarani jatala Johanningundru: „Mina najila jura pitaraia palkana paraia? Kalanka kulno watarali wijawijabanani? ");
INSERT INTO dif_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Mina najila jura palkana paraia? Kana kulno kati tjankanto? Mai, tana kati tjankani ja pankipankinani, mitaia Kaparaia pungani ngamai. ");
INSERT INTO dif_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Mina najila jura palkana paraia? Propheta kulno? Morlalu ngani jurangu jatai: Nau morla pirna nganai Prophetani. ");
INSERT INTO dif_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Naupini nau nganai, nunkangundru dakanala parai: Mai, ngato angela ngakani jinkangu mudlani ngopera jinpai, nulu palto jinkani jinkangu ngopera ngankingala nganai. ");
INSERT INTO dif_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ngangau ngani jurangu jatai: Propheta morla pirna tanangundru, widlandru dankanala, Johanningu multibanietjani wata kulno nganai; worananau waka nganai Godaia mililani, nau morla pirna nganai nunkangu.“ ");
INSERT INTO dif_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ja kana wolarali, tanali matja ngarana, ja mardatandrakampanietjali Goda talku ngundrana wonti, ja multibanila manina wonti Johannini multibanilali. ");
INSERT INTO dif_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pharisaiali ja jirijiribani jaura ngujangujara jinkinietjali Godaia jertapaterina tanangundru worarana wonti; ngangau tanali wata multibanila manina wonti nunkangundru. ");
INSERT INTO dif_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Kapara jatana wonti: „Worangu ngato ninapini kana nguja jeribaka kurananto? Ja worangu tanaia jeribaka nganai? ");
INSERT INTO dif_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Tanaia kupa wakani jeribaka nganai, tana jinkimalini pirini ngamai ja karkamaliai ja jatai: Ngaiani jurangu wilpina warai, ja jura wata kilina warai; ngaiani jurangu juajuangana warai, ja jura wata jindrana warai. ");
INSERT INTO dif_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Johannes multibanietja wokarana warai, nulu wata buka tajina ja wata waina tapana, ja jura jatai: Nulu kutji ngamalkai. ");
INSERT INTO dif_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Kanaia Ngatamura wokarana warai, Nulia tajai ja tapai; ja jura jatai: Najiau! Nauja mirantjatieli tajinietja ja waina tapanietja, mardatandrakampanietjaia ja madlentji ngankanietjaia kamaneli!“ ");
INSERT INTO dif_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ja kirilali kalala maniai nunkani kupa pratjanandru. ");
INSERT INTO dif_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Pharisaia kulno nunkangu ngatjina wonti, Nulu nunkangunto tajinanto; ja Nau Pharisaia pungani matja wirina, Nau kurlini ngamana ngarina wonti. ");
INSERT INTO dif_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ja mai, widla kulno ngurani, nani madlentji ngankanietja nganana wonti, nandru morlalu ngujamana wonti, Nau Pharisaia pungani kurlini ngamanani, nandru Alabaster koko kulno gildinto padakana wonti. ");
INSERT INTO dif_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ja nani nunkangu tokuni terkana wonti ja jindranali wonina wonti milkigildieli nankanali tidna nunkani turibala, ja parali nankanali pudlana muja ngankala; ja nandru tidna nunkani manatapana wonti ja gildieli wiribana wonti. ");
INSERT INTO dif_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nulupini Pharisaiali, nulu nina matja karkana, jenia najina, nulu muntali ngundrana wonti ja jatana wonti: „Naupini Propheta ngananani, Nulia ngujamananto worana ja mina widla nania nganai, nandruja ninaia matja karakarana; ngangau nania madlentji ngankanietja nganai.“ ");
INSERT INTO dif_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ja Jesujeli nunkangu kalabana wonti ja jatana wonti: „Simoniai! Ngani jinkangu minakulno jatananto.“ Nau jatana wonti: „Ngujangujara jinkinietjajai, jatau!“ ");
INSERT INTO dif_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Mardatandra jinkinietja kulnuni kana mandru poto wilpanto nganana wonti. Kulno nunkangu 500 mardatandra waka wilpa nganana wonti, ja kulno 50. ");
INSERT INTO dif_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ngangau pndlali wata ngamalkana wonti woljaia jinkila, nulu jenia pudlangu bakujeli jinkina wonti. Jatau, warle pudlangundru nina morla ngantjala nganai? ");
INSERT INTO dif_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simonali kalabana wonti ja jatana wonti: „Ngato ngundrai nulu, nunkangupini nulu morla bakujeli jinkina warai.“ Nau nunkangu jatana wonti: „Jidni talku jatana warai.“ ");
INSERT INTO dif_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ja Nulu widla karitjina najina wonti ja Simoningu jatana wonti: „Jundru najiai nanapini widla? Ngani jinkangu pungani wirina warai; jundru ngakangu wata ngapa tidnaia jinkina warai; nandru milkigildieli nankanali tidna ngakani wiribana warai ja parali nankanali muja ngankana warai. ");
INSERT INTO dif_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Jundru ngana wata manatapana warai; nani matja wirina, jigleri nganana warai, tidna ngakani tapala. ");
INSERT INTO dif_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Gildieli jundru wata ngana mangatandra wiribana warai, nandruja gildieli tidna ngakani wiribana warai. ");
INSERT INTO dif_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Jendrangundruja ngani jinkangu jatai: Madlentji nankani marapu matja kalingana, ngangau nandruja pirna ngantjana warai; worangu ngalje matja kalingana, nulu ngalje ngantjai.“ ");
INSERT INTO dif_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nau nankangu jatana wonti: „Madlentji jinkani matja kalingana.“ ");
INSERT INTO dif_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ja bukaia kamanelieli wonina wonti ngankamalila: „Worana Naupini nganai, Nulia bakana madlentji kalingai?“ ");
INSERT INTO dif_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Nau widlani jatana wonti: „Morlalu ngundranali jinkanali jidnana kulkana warai; murlali wapamai!“");
INSERT INTO dif_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ja jendranguta ditji ngadani Nau wirarina wonti ngura pirnani ja wakani ngujangujara jinkila ja ngantjani jaura Godaia mililandru kaukaubala, ja nunkangunto marapratjana ja mandru. ");
INSERT INTO dif_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ja widla palpa tana tepi pantjinala kutji murumurundru ja muntjandru, Maria, nana tanali dikai Magdalena, nankangundru kutji mara wora ja mandru dunkanala. ");
INSERT INTO dif_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ja Johanna, Chuzani, Herodini kapakaparaia noa, ja Susanna, ja widla palpa morla, tana mili nunkani nganana wonti tanani potundru. ");
INSERT INTO dif_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kana wolara marapu nunkangu jurborinani ja ngura marapundru nunkangu wokaranani, Nau jeribaka jaurali jatana wonti: ");
INSERT INTO dif_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","„Jaupanietja wapana wonti paua nunkani jaupala; ja nulu jaupanani, palpa paltuni purina wonti, ja kanali nina nankanankana wonti, ja paiali ngaranalali nina tajina wonti. ");
INSERT INTO dif_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ja palpa marda paltirani purina wonti, ja matja kuririna, mujarina wonti; ngangau tjanka pani nganana wonti. ");
INSERT INTO dif_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ja palpa dilkani terti purina wonti, ja dilkali jela punkana wonti, ja nina ngandrawalkana wonti. ");
INSERT INTO dif_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ja palpa mita ngumuni purina wonti ja punkana wonti ja tandra punkibana wonti 100 potajeli. Nau jenia matja jatana, Nulu karkana wonti: Warle talpa ngamalkai ngarala, nulu ngaraiatimai!“ ");
INSERT INTO dif_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ja milieli nunkananli nina jakalkana wonti ja jatana wonti: „Mina jeribaka jaura naupini?“ ");
INSERT INTO dif_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Nau jatana wonti: „Jurangu matja jinkina warai, jaura kurukuru Godaia mililandru ngujamananto; ja kana nguruni jeribaka jaurali, tanali najinani wata najinanto, ja ngaranani wata ngarananto. ");
INSERT INTO dif_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Jenia jeribaka jaurali wondrai: Paua Godaia jaura nganai. ");
INSERT INTO dif_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Tana paltuni tanapini nganai, tanali ngarai; ngadani kutji wokarai, ja nulu jaura tanani ngarandru maniai, tanali morlalu ngundraiati ja tepi pantjiati. ");
INSERT INTO dif_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Tana paltirani tanapini nganai, tanali matja ngarana, jaura mankinali patai, ta tana kapara pani nganai; ditji palpa tanali morlalu ngundrai, ja wontjanilaia ditjini tana walturiai. ");
INSERT INTO dif_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ja tana dilkani matja purina tanapini nganai, tanali matja ngarana, ja mitaia manujeli ngundranali ja poto pirnali ja pankipankinali wirarina nina ngandrawalkai ja wata tandra punkibai. ");
INSERT INTO dif_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ja tana mita ngumuni tanapini nganai, tanali jaura ngarai ja ngamalkai ngara kulikirieli ja ngumujeli ja wonkieli; ja wonkieli tandra punkibai.");
INSERT INTO dif_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Wata kulnujeli, nulu praitji matja miribana, nina kokujeli walpadakai, turarani pirini ngarinalu kurai kara, a‐ai, nulu nina praitji potuni kurai, ngangau tanali wirinani praitji najinanto. ");
INSERT INTO dif_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ngangau panila kurukuru nganai, jenia wata tinkari pantjila nganai; bakana panila ngalpurani nganai, tanali jenia wata ngujamala nganai ja tinkari pantjila nganai. ");
INSERT INTO dif_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Najianau worderu jura ngarai, ngangau warle ngamalkai, nunkangu Nulia jinkila nganai; ja warle wata ngamalkai, bakana jenia, nulu ngundrai ngamalkala, Nulia nunkangundru manila nganai.“ ");
INSERT INTO dif_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ngandri nunkani ja ngatata nunkani nunkangu wokarana wonti, ja tana ngandandarina wonti nunkangu wokarala kana wolarani. ");
INSERT INTO dif_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ja tanali nunkangu kaukaubana wonti ja jatana wonti: „Ngandri jinkani ja ngatata jinkani palarani terkala wapaia ja jertapaterila wapaia jidna najila.“ ");
INSERT INTO dif_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Nulu kalabana wonti ja tanangu jatana wonti: „Ngandri ngakani ja ngatata ngakani tanapini nganai, tanali Godaia jaura ngarai ja ngankai.“ ");
INSERT INTO dif_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ja jendranguta ditji kulnuni Nau ja mili nunkani botani wirina wonti; ja Nau tanangu jatana wonti: „Ngaiana pantuni jerankari dirkalaia pararananto;“ ja tana dirkalandru wapana wonti. ");
INSERT INTO dif_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Tana botali matja wapana, Nau mukaturarana wonti. Ja watara wondru wokarana wonti, ja bota manamiririna wonti, ja tana japali pantjina wonti. ");
INSERT INTO dif_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Tana karakara wokarana wonti nina jiritjibala ja jatana wonti: „Kaparajai, Kaparajai, ngaiana tintateriati!“ Nau matja jiritjina, Nulu watara ja mandikila dikidikibana wonti, ja tana ngapurina wonti, ja dalpura pirna pantjina wonti. ");
INSERT INTO dif_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Nau tanangu jatana wonti: „Woderi jurani morlalu ngundrana nganai?“ Tana japali pirna ngaruparana wonti ja ngankamalina wonti: „Worana Naupini nganai, Nulu bakana watarani ja ngapani daudauai, ja tana nunkangu pankiai?“ ");
INSERT INTO dif_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ja tana Gadarena mitani pararana wonti Galilaiankari. ");
INSERT INTO dif_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Nau mitaia matja dunkana tarana, nunkangu kana kulno ngurandru mandurina wonti, nulu ditji marapu kutji murumuru ngamalkana wonti, ja nau wata kati widmaterina wonti ja wata pungani ngamana wonti, a‐ai, narikutuni. ");
INSERT INTO dif_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Nulu Jesus najina, Nau maritjina wonti ja nunkangu woraterina wonti ja ngaiala pirnali jatana wonti: „Mina ngakangu ja jinkangu, Jesu, Goda Kapara pirnaia Ngatamurajai? Ngani jinkangu ngatjiai, ngana wata jupau!“ ");
INSERT INTO dif_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ngangau Nulu kutji murumuruni jirijiribana wonti kanandru dunkananto; ngangau ditji marapu nulu nina nunkangunto wapalkana paraia, ja tanali nina kanjangarieli dupudupu ngankana paraia, ja bakana tanali nina workamantrana paraia; ja nulu jenia ngurula matja wokaribana, kutjieli nina pitaraia wirilkana wonti. ");
INSERT INTO dif_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesulu nina jakalkana wonti ja jatana wonti: „Mina tala jundru ngamalkai?“ Nau jatana wonti: „Legiona:“ ngangau kutji marapu nunkangu wirinala. ");
INSERT INTO dif_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ja nau nunkangu ngatjina wonti, Nulu tanangu wata jirijiribananto ngarinaluja ngarila. ");
INSERT INTO dif_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Naka piki ngami pirna nganana wonti, tana mardawonpa kalikalini marakana wonti. Ja tana nunkangu ngatjina wonti, Nulu tanangu manuni kurananto, tanangupini wirinanto. Ja Nulu tanangu jenia manuni kurana wonti. ");
INSERT INTO dif_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ja tana kutji murumuru kanandru matja dunkana, tana pikini wirina wonti; ja piki ngami mardawonpa kalikalini ngapani kalikalibakana wonti, ja ngapali palipalina wonti. ");
INSERT INTO dif_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Piki ngamalkanietjali jenia najina, mina pantjina warai, tana japa mindrina wonti ja ngura pirnani ja wakani jenia kaukaubana wonti. ");
INSERT INTO dif_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Tana dunkana wonti najila mina pantjina warai; ja tana Jesungu wokarana wonti, ja nina kana Jesuja tidnani ngamanani mankamankana wonti, nunkangundru kutji wora dunkana warai, nau kati matja widmaterina ja tjuru ngumu ngamalkana; ja tana japali pantjina wonti. ");
INSERT INTO dif_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Tanali jenia najina wonti tanangu kaukaubana wonti, worderu nau kutjila tepi pantjina warai. ");
INSERT INTO dif_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ja kana wolarali Gadarenaia wondirani nunkangu ngatjina wonti, Nau tanangundru puntinanto, ngangau tana japali pirna pantjina wonti; ja Nau botani wirina wonti ja nakaldra karitjina tikana wonti. ");
INSERT INTO dif_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Nulupini kanali, nunkangundru kutji wora dunkana warai, nunkangu ngatjina wonti, nunkangu jela ngamala. Ja Jesujeli nina jinpana wonti ja jatana wonti: ");
INSERT INTO dif_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","„Pungaia jinkanaia tikamai, ja kaukaubamai, mina pirnala Godali jinkangu ngankana warai.“ Ja nau wapana wonti ja ngurani paruparu parparali kaukaubana wonti, mina pirnala Jesujeli nunkangu ngankana warai. ");
INSERT INTO dif_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jendranguta Jesus tikana wonti, ja kana wolarali nina patana wonti, ngangau pratjanali nunkangu kalkana wonti. ");
INSERT INTO dif_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ja mai, kana kulno wokarana wonti, tala nunkani Jairus, nau jaura pungaia kapara nganana wonti, ja nau Jesungu tidnani woraterina wonti ja nunkangu ngatjina wonti, Nau nunkangu pungani wirinanto. ");
INSERT INTO dif_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ngangau nulu mankara ngatamura kulno ngamalkana wonti, nani kilpawoldra marapratjana ja mandru tepi, ja parana wonti ngara wordu. Nau wapanani kana wolarali nina jenina wonti. ");
INSERT INTO dif_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ja widla kulnujeli kumaranto kilpawoldra marapratjana ja mandru nganana wonti, ja nandru poto nankani pratjana kunkini kalala jinkina wonti, ja wata kulnujeli nana tepi ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nani nunkangu tokuni wokarana wonti, ja kati jelpi nunkani karakarana wonti; ta nurujeli kumari tjiri nankani mudana wonti. ");
INSERT INTO dif_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ja Jesus jatana wonti: „Warle ngana karakarana warai?“ Pratjana pani pataterinani, Petrus ja tana nunkangunto jatana wonti: „Kaparajai, kana wolarali jidna jeniai ja nankai, ja jidni jatai: Warle ngana karakarana warai?“ ");
INSERT INTO dif_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jesus jatana wanti: „Kulnujeli ngana karakarana warai, ngangau ngato ngujamai ngurula ngakangundru dunkana warai.“ ");
INSERT INTO dif_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Widlali matja najina, nani wata kurukuru nganai, nani ngarranali wokarana wonti ja woraterina wonti ja kana wolarani nunkangu kaukaubaterina wonti, minandru nandru nina karakarana warai, ja worderu nani nurujeli tepi pantjina warai. ");
INSERT INTO dif_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Nau nankangu jatana wonti: „Murlali nganamai ngatamurajai, morlalu ngundranali jinkanali jidna tepi ngankana warai, murlali wapau!“ ");
INSERT INTO dif_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Nau jenia jatana, jaura pungaia kapara mili kulno wokarana wonti ja nunkangu jatana wonti: „Ngatamura mankara jinkani matja nari, ngujangujara jinkinietja wata ngarapatipatibau!“ ");
INSERT INTO dif_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesujeli jenia ngarana, Nulu nunkangu kalabana wonti ja jatana wonti: „Wata japali nganau, windri morlalu ngundrau, ja nani tepirila nganai.“ ");
INSERT INTO dif_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Nau pungani wirina, Nulu wata kulnuni manuni kurana wonti wirinanto, windri Petrungu ja Johanningu ja Jakobungu ja kupaia ngaperani ja ngandrini. ");
INSERT INTO dif_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Pratjana jindrana wonti ja nankangundru ngaurongauro nganana wonti. Nau jatana wonti: „Wata jindranau! Nania wata nari, a‐ai, nania windri mukaturarai.“ ");
INSERT INTO dif_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ja tana nunkangu kinkana wonti, ngangau tana ngujamana wonti nani nari. ");
INSERT INTO dif_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Nulu tanana pratjana narrana wonti, ja Nulu nana mara patana wonti ja karkana wonti ja jatana wonti: „Kupajai, terkakamai!“ ");
INSERT INTO dif_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ja mungara nankani tikana wonti, ja nani nurujeli jiritjina wonti. Ja Nulu jirijiribana wonti nana buka jinkinanto. ");
INSERT INTO dif_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ja ngaperi ja ngandri nankani pirna ngaruparana wonti. Ja Nulu tanangu jirijiribana wonti wata kulkuni jenia kaukaubananto mina pantjina warai. ");
INSERT INTO dif_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Nulu mili marapratjana ja mandru nunkani karkana wonti, ja tanangu pirnala ja ngurula jinkina wonti kutji murumuru pratjanaia, ja muntjandru tepi ngankala. ");
INSERT INTO dif_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ja Nulu tanana jinpana wonti Godaia mililandru ngujangujara jinkila, ja kana muntja tepi ngankala. ");
INSERT INTO dif_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ja Nau tanangu jatana wonti: „Panila paltuni manianimai; wata wonapita, wata billi, wata buka, wata mardatandra; jura bakana wata kati mandru ngamalkananto. ");
INSERT INTO dif_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ja mina pungani jura matja wirina, naka ngamanimai, ja nakandru wirarianimai. ");
INSERT INTO dif_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ja worderuntjali jurana wata patala nganai, nunkangupini ngurandru dunkanimai, ja bakana puturu jurani tidnandru kantikantianimai malka nganala tanangu.“ ");
INSERT INTO dif_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Tana wapana kurana wonti, ja ngura kulno ja kulnuni palkingana wonti, paruparu ngantjani jaura kaukaubala ja tepi ngankala. ");
INSERT INTO dif_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herodili mitaia kapakaparali pratjana ngarana, mina nunkangundru pantjinani, nau japali nganana wonti, ngangau palpa jatana wonti: „Johannes narindru matja jiritjina.“ ");
INSERT INTO dif_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Palpa: „Elias wondraterina warai;“ palpa: „Propheta kulno warula narindru matja jiritjina.“ ");
INSERT INTO dif_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ja Herodes jatana wonti: „Nina Johannes mangatandra ngato wokaribana paraia: ja worana Naupini nganai, nunkangundru ngato jenia ngarai?“ Ja nulu ngantjana wonti nina najila. ");
INSERT INTO dif_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ja Apostela matja tikana, tanali nunkangu kaukaubana wonti, mina pirnala tanali ngankanala; ja Nulu tanana tjirimalkana wonti, ja ngura kulnuja, tala nunkani Bethsaida, kutingana wonti. ");
INSERT INTO dif_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Kana wolarali jenia ngujamana, tana nunkangu karipaterina wonti; ja Nulu tanana patana wonti, ja tanangu Godaia mililandru kaukaubana wonti, ja kana muntja Nulu tepi ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ditji kunarkuni mili marapratjana ja mandru nunkangu wokarana wonti ja jatana wonti: „Kana wolara jinpau, ngangau tanaia ngura pirnani ja wakani wirinanto bukaia; ngangau ngaiana ninkida pitarani nganai.“ ");
INSERT INTO dif_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Nau tanangu jatana wonti: „Jura tanangu jinkianau tajinanto!“ Tana jatana wonti: „Ngaiani ninkida windri buka ngunku mara wora ja paru mandru ngamalkai; ngaiani kara wapananto, ja tanangupini kana wolarani buka burungankananto?“ ");
INSERT INTO dif_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ngangau tana kana 5000 nganana wonti. Nau milini nunkanani jatana wonti: „Tanaia ngamana ngarinanto witta kulno ja kulno, milingeru marapratjana pota mara wora.“ ");
INSERT INTO dif_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ja tanali jeruja ngankana wonti, ja pratjana ngamana ngarina wonti. ");
INSERT INTO dif_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Nulu buka ngunku mara wora ja paru mandru patana wonti ja pariwilpani najina tarana wonti, ja tanana ngurungutana wonti, ja tanana wokaribana wonti, ja milini nunkanani jinkina wonti, tana kana wolarani jinkinanto. ");
INSERT INTO dif_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ja tanali tajina wonti ja jerturina wonti, ja tanali buka worduwordu kampana wonti billi marapratjana ja mandru manamiri. ");
INSERT INTO dif_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ja jendranguta Nau kulnulu ngatjinani, mili nunkangu jurborina wonti; ja Nulu tanana jekibana wonti ja jatana wonti: „Mina kana jatai, worana ngani?“ ");
INSERT INTO dif_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Tanali kalabana wonti ja jatana wonti: „Johannes multibanietja; palpa Elias; palpa jatai Propheta kulno warula matja jiritjina.“ ");
INSERT INTO dif_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Nau tanangu jatana wonti: „Mina jura jatai, worana ngani nganai?“ Petrulu kalabana wonti ja jatana wonti: „Godaia Christus.“ ");
INSERT INTO dif_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Nulu tanana daudauana wonti, ja tanangu jirijiribana wonti, wata kulnuni jenia kaukaubala. ");
INSERT INTO dif_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Nau jatana wonti: „Kanaia Ngatamura pirna ketjaketjananto, ja pinaru worali ja Priesta pirnali ja jaura jinkinietjali ninaia worala nganai ja nari ngankala nganai, ja ditjini parkulani Nau jiritjila nganai.“ ");
INSERT INTO dif_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Nau pratjanani jatana wonti: „Warle ngantjai ngakangu karipaterila, nau munta panila ngundrateriatimai, ja nulu kunarku nunkani ditji pratjanani maniatimai, ja ngakangu karipateriatimai. ");
INSERT INTO dif_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ngangau warle tepi nunkani ngantjai kulkala, nulu nina tintala nganai; ja warle tepi nunkani tinkai ngakangundru, nulu nina kulkala nganai. ");
INSERT INTO dif_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ngangau jenia kanani ngumu nganai kara, nulu mita maru maninani, ja munta tintaterinani kara, nandraterinani kara? ");
INSERT INTO dif_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ngangau worananau ngakangundru ja ngakani jaurandru nintali nganai, nunkangundru bakana Kanaia Ngatamura nintali nganala nganai, Nau nunkanani, ja ngaperaia, ja angela kulikiria pirnalani wokarala nganai. ");
INSERT INTO dif_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Morlalu ngani jurangu jatai: Tanangundru palpa, ninkida terkala wapaia, tanalipini nari wata wontjala nganai, tanali Godaia milila najinantulu.“ ");
INSERT INTO dif_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jendranguta Nulu tanapini jaura matja mudana, ditji mara wora ja parkulani, Nulu Petrus ja Johannes ja Jakobus patana wonti, ja mardawonpaia tarana wonti ngatjila. ");
INSERT INTO dif_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ja Nau ngatjinani, mudla nunkani njeranjerarina wonti, ja kati nunkani bulurina wonti ja kintjalkururina wonti. ");
INSERT INTO dif_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ja mai, kana mandru nunkangu ngankamalina wonti, pudla Moses ja Elias nganana wonti. ");
INSERT INTO dif_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Pudla pirnalali wondraterina wonti, ja mudana nunkani kaukaubana wonti, nina Nulu morlalu ngankananto Jerusalemini. ");
INSERT INTO dif_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petrus ja pudla nunkangunto jindina wonti; ngangau tanali matja tepi ngamana, tanali pirnala nunkani najina wonti, ja kana mandru nunkangunto terkanani. ");
INSERT INTO dif_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ja jendranguta pudla nunkangundru kutinganani, Petrus Jesungu jatana wonti: „Kaparajai, ninkida ngaianangu ngumu nganai; ngaiani punga parkulu wotila nganai, jinkani kulno, Mosini kulno, ja Eliani kulno;“ ja nau ko nganana wonti, mina nau jatai. ");
INSERT INTO dif_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nau jenia jatana, talara palku wokarana wonti ja tanana walpadakana wonti; ja tana japali pirna pantjina wonti, pudla talara palkuni wirinani. ");
INSERT INTO dif_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ja ngaiala kulno talara palkundru pantjina wonti ja jatana wonti: „Naupini Ngatamura ngantjalu ngakani nganai; ninaia ngaraiatinimai!“ ");
INSERT INTO dif_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ja nau ngaiala pantjinani, tanali Jesus kulnulu mankamankana wonti. Ja tana ngapu nganana wonti, ja wata kulnuni tanangupini ditjini kaukaubana wonti nunkangundru, mina tanali matja najina. ");
INSERT INTO dif_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Jendranguta ditji kulnuni, tana mardawonpandru matja ngarina, kana wolara nunkangu jurborina wonti. ");
INSERT INTO dif_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ja mai, kana kulno kana wolarandru maritjina wonti ja jatana wonti: „Ngujangujara jinkinietjajai, ngani jinkangu ngatjiai, ngatamura kunakulno ngakani najiau. ");
INSERT INTO dif_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ja mai, kutjieli nina patai, ja nurujeli nau maritjiai, ja nulu nina diadialkai, jeruja nau ngaltja wiltjiwiltjiriai, ja mankali nau nunkangundru kutingai ja nandrai. ");
INSERT INTO dif_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ja ngani milini jinkanani ngatjina warai, tanali nina dunkalkananto, ja tanaia ngandandarina warai.“ ");
INSERT INTO dif_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesujeli kalabana wonti ja jatana wonti: „Jidni nguja gilbarinietja ja tjautjau, wintaranaia ngani jurangu jela nganai? Wintaranaia ngato jurana ngamalkala nganai? Ngatamura jinkani ninkidani padakanimai!“ ");
INSERT INTO dif_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nau karakara wokaranani, kutjieli nina patana wonti, ja nina matala ngankana wonti; ja Jesujeli kutji murumuru dikidikibana wonti, ja nina kanku tepi ngankana wonti, ja nina ngaperani nunkanani nakaldra jinkina tikana wonti. ");
INSERT INTO dif_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Pratjana Godaia pirnalandru ngaruparana wonti. Tana pratjana ngaruparanani pratjanandru, mina Jesujeli matja ngankana, Nau milini nunkanani jatana wonti: ");
INSERT INTO dif_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","„Tananapini jaura talpali patanimai; ngangau tanali Kanaia Ngatamura kana marani ngulkujeli jinkila nganai.“ ");
INSERT INTO dif_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Tanali ninapini jaura wata ngujamana wonti, ja jenia tanangu kurukuru nganana wonti, tanali jenia wata patananto; ja tana japali nganana wonti, nina jenia jaurandru jakalkala. ");
INSERT INTO dif_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ja tanali ngundrana wonti, worana morla pirna nganai tanangundru. ");
INSERT INTO dif_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesujeli tanani ngarali ngundranani ngujamana, Nulu kupa waka kulno patana wonti, ja nina nunkangu karakara terkibana wonti. ");
INSERT INTO dif_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ja tanangu jatana wonti: „Warle ninapini kupa patai ngakani talandru, nulia ngana patai; ja warle ngana patai, nulia ninapini patai, Nulia ngana jinpanala. Ngangau worana jurangundru pratjanani waka nganai, nauja pirna nganala nganai.“ ");
INSERT INTO dif_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Johannili kalabana wonti ja jatana wonti: „Kaparajai, ngaiani kulno najina paraia, nulu talani jinkanani kutji dunkalkanani, ja ngaiani nina daudauana paraia, ngangau nau wata ngaianingunto wapai.“ ");
INSERT INTO dif_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ja Jesus nunkangu jatana wonti: „Wata daudauanau; ngangau worana wata tula ngaianani nganai, nau kamaneli ngaianani.“ ");
INSERT INTO dif_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jendranguta, ditji nunkani miririnani, nau puntina wonti, ja Nulu mudlamudla kurana wonti Jerusalemia palkala. ");
INSERT INTO dif_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ja Nulu mili jinpana wonti manununkaninkari, ja tana palkana wonti Samarita ngura wakaia, nunkani ngankingala. ");
INSERT INTO dif_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ja tanali nina wata patana wonti, ngangau Nulu mudlamudla kurana wonti Jerusalemia palkala. ");
INSERT INTO dif_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ja milieli nunkanali Jokabus ja Johannes jenia najina, pudla jatana wonti: „Kaparajai, jidni jertapaterinani, ngali jirijiribananto turu pariwilpandru godananto, tanana julkananto, worderu Eliali ngankana wonti?“ ");
INSERT INTO dif_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jesujeli najina karitjina wonti ja pudlana daudauana wonti ja jatana wonti: „Judla wata milkila, mina Jaolaia kupa judla nganai. ");
INSERT INTO dif_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ngangau Kanaia Ngatamura wata wokarana warai kanaia tepi teribala, a‐ai, kulkala.“ Ja tana ngura kulnuja palkana wonti. ");
INSERT INTO dif_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Jendranguta tana paltuni wapanani, kulno nunkangu jatana wonti: „Ngani jinkangu karipaterila nganai, woderi jidni paruparu wapanani, Kaparajai.“ ");
INSERT INTO dif_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ja Jesus nunkangu jatana wonti: „Kintala jampali minka ngamalkai, ja paiali ngaranani kunjila ngamalkai, ja Kanaia Ngatamurajeli piri pani ngamalkai, wodajeri kukadi terkala.“ ");
INSERT INTO dif_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nau kulnuni jatana wonti: „Ngakangu karipateriau!“ Nau jatana wonti: „Kaparajai, ngakangu manuni kurau, ngani ngopera wopananto ngaperi ngakani todila.“ ");
INSERT INTO dif_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesus nunkangu jatana wonti: „Narieli muntali nari tanani todinanto, jidni wapau, ja Godaia mililandru kaukaubau.“ ");
INSERT INTO dif_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Bakana kulno jatana wonti: „Ngani jinkangu karipaterila nganai, Kaparajai, ngopera ngakangu manuni kurau, ngani ngakani nguralandru daninanto, tana ngakani pungani ngamai.“ ");
INSERT INTO dif_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesus nunkangu jatana wonti: „Wata kulno, nulu mara nunkani mita bakuni potuni kurai, ja worakalina tikana najiai, talku nganai Godaia mililani.“ ");
INSERT INTO dif_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ngadani Kaparali mili marapratjana pota mara wora ja mandru kalkalkana wonti, ja tanana mandru ja mandru nunkangu ngopera jinpana wonti ngura pirnaia ja wakaia, woderi Nau jertapaterina wonti munta wokarala. ");
INSERT INTO dif_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Nau tanangu jatana wonti: „Kampananto marapu parai, ja ngankanietja windri ngalje; jendrania Kampani Kaparani ngatjianau, Nulia ngankanietja worana jinpananto nunkani kampanaia. ");
INSERT INTO dif_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Wapanau! mai, ngato jurana jinpai tjipi kuparu jeribaka pandipandi mandrani. ");
INSERT INTO dif_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Wata billi, wata pailtji, ja wata tidnaputa mandranau; ja bakana wata kulnuni mandurini jaura jinkianau. ");
INSERT INTO dif_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Mina pungani jura wirila nganai, ngopera jatanau: «Murla nunkangupini pungani nganaiatimai!» ");
INSERT INTO dif_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ja naka murlaia kupa ngananani, jurani mura nunkangu wokarala nganai; ja pani, nau jurangu tikala nganai. ");
INSERT INTO dif_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nunkangupini pungani ngamanimai; tajianimai ja tapanimai mina tanali ngamalkai; ngangau ngankanietjani talku nganai nunkani kalala; wata punga kulnundru punga nguruja wapanau. ");
INSERT INTO dif_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ja mina ngurani jura wirila nganai, ja tanali jurana patanani, naka tajianimai mina tanali jurangu kurai. ");
INSERT INTO dif_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ja nunkangupini ngurani kana muntja tepi ngankanau, ja tanangu jatanau: Godaia milila jurangu karakara wokarala wapaia. ");
INSERT INTO dif_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Mina ngurani jura wirila nganai, ja tanali jurana wata patanani, tanani paltuni dunkanimai ja jatanimai: ");
INSERT INTO dif_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Bakana nina puturu, nau jurani ngurandru ngaianangu tidnani parai, ngaiani jurangu kantikantiai; windri jenia ngujamanau, jurangu Godaia milila karakara wokarala wapaia. ");
INSERT INTO dif_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ngani jurangu jatai: Sodom mitalali kalala morla waka manila nganai kalala ditjini nunkangupini ngurani. ");
INSERT INTO dif_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Jakajai jinkangu Choraziniai! Jakajai jinkangu Bethsaidajai! Ngangau Tyrus ja Sidon ngurani jenia pirnala pantjinani, judlangu pantjinala, pudla nurujeli kati murumurunto ja turuputani madlentjandru karitjinanto. ");
INSERT INTO dif_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Tyrus ja Sidon mitalali kalala morla waka manila nganai kalala ditjini, judlangu. ");
INSERT INTO dif_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ja jidni Kapernaum, jidni miririna pariwilpaia, turujelu jidni ngarila nganai! ");
INSERT INTO dif_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Warle jurana ngarai, nulu ngana ngarai; ja warle jurana worarai, nulu ngana worarai; ja warle ngana worarai, nulu ninaia worarai, Nulia ngana jinpanala.“ ");
INSERT INTO dif_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tana marapratjana pota mara wora ja mandru mankinali tikana wonti ja jatana wonti: „Kaparajai, bakana kutji wora ngaianingu jinkani talani wodatarana ngamana warai.“ ");
INSERT INTO dif_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Nau tanangu jatana wonti: „Ngato Satan talara praitji jeribaka pariwilpandru ngarinani najina warai. ");
INSERT INTO dif_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mai, ngato jurangu ngurula jinkiai tjutjuni ja katninuntini nankana wirarinanto, ja talpalaia ngurulani pratjanani, ja tanali jurana wata jupala nganai. ");
INSERT INTO dif_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Wata jendrangundruja mankianimai, jurangu kutji wora wadatarana ngamai, a‐ai, jendrania mankianimai, ngangau tala jurani pariwilpani matja dakana parai.“ ");
INSERT INTO dif_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nunkangupini ditjini Jesus Jaolali mankina wonti ja jatana wonti: „Ngato Jidnana Ngaperiai, Kapara pariwilpaia ja mitaia, jurakokala wapaia; ngangau Jundru jenia kana kirini ja ngujamanietjani kutibana warai ja kupani tinkari ngankana warai; kau Ngaperiai, jeruja jinkangu manju nganana wonti. ");
INSERT INTO dif_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ngaperali ngakanali ngakangu warupoto jinkina wonti; ja wata kulnujeli ngujamai, worana Ngatamura nganai, windri Ngapili, ja worana Ngili nganai, windri Ngatamurajeli, ja worangu Ngatamurajeli ngantjai jenia tinkari ngankala.“ ");
INSERT INTO dif_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ja Nulu mili mudlakalkana wonti ja jatana wonti: „Murlali pirna tana milki, tanali najiai mina jura najiai! ");
INSERT INTO dif_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ngangau ngani jurangu jatai: Propheta ja mitaia kapara marapujeli wolkareli nganana wonti jenia najila mina jura najiai, ja wata najina wonti; ja jenia ngarala mina jura ngarai, ja wata ngarana wonti.“ ");
INSERT INTO dif_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ja mai, jirijiribani jauraia ngujangujara jinkinietja terkakana wonti ja jatana wonti: „Ngujangujara jinkinietjajai, mina ngato ngankananto tepi ngurali maratunka ngamalkala?“ ");
INSERT INTO dif_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Nau nunkangu jatana wonti: „Mina jirijiribani jaurani dakanala parai? Worderu jundru warapai?“ ");
INSERT INTO dif_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nulu kalabana wonti ja jatana wonti: „Jundru Goda Kapara jinkani ngantjamai ngarali jinkanali, mungarali jinkanali, ja manujeli jinkanali; ja ngurala jinkani jidna munta jeribaka.“ ");
INSERT INTO dif_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Nau nunkangu jatana wonti: „Jundru talku kalabana warai; jenia ngankau, ja jidni tepi ngamala nganai!“ ");
INSERT INTO dif_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nau jertapaterina wonti talku ngankaterila ja Jesungu jatana wonti: „Worana ngurala ngakani nganai?“ ");
INSERT INTO dif_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesujeli kalabana wonti ja jatana wonti: „Kana kulno Jerusalemingundru Jerichoja ngarina wonti, ja watawatali maninietjali kati nunkani dukarana wonti ja nina nandrana wonti ja kutingana wonti, ja nina ngampu nari worarana wonti. ");
INSERT INTO dif_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Priesta kulno nunkangupini paltuni manubaku ngarina wonti; ja nulu nina najina, nau wiringana wonti. ");
INSERT INTO dif_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Jeruja bakana Levita kulno nunkangupini pirini wokarana wonti, ja nina najina wonti ja wiringana wonti. ");
INSERT INTO dif_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ja Samarita kana palkana wonti ja nina dankana wonti, ja nulu nina najina, nau kalumiltjamiltjarina wonti. ");
INSERT INTO dif_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ja nau karakararina wonti, ja nulu nina tapa karana wonti, ja gildi ja waina nangana wonti; ja nulu nina ngantini nunkanani kurana tarana wonti ja wapalkana wonti nguraia, ja nina ngamalkana wonti. ");
INSERT INTO dif_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ja nguramaranani nulu mardatandra mandru dukarana wonti ja punga ngamalkanietjani jinkina kurana wonti ja jatana wonti: «Ninaia ngamalkau, ja jundru morla tintanani, ngato jinkila tikala nganai ngani tikana.» ");
INSERT INTO dif_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Mina jundru ngundrai, worana tanangu parkulani ngurala nganana wonti nunkangu, nau watawatali maninietjani matja purina?“ ");
INSERT INTO dif_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Nau jatana wonti: „Naupini kalumiltjamiltjarinala nunkangu.“ Ja Jesus nunkangu jatana wonti: „Wapau, ja nunkangupini jeribaka ngankamai!“ ");
INSERT INTO dif_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jendranguta tana palkana, Nau ngura kulnuni wokara wonti; ja widla kulnujeli, tala nankani Martha, nina pungani nankanani patana wonti. ");
INSERT INTO dif_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ja nandru kaku kulno ngamalkana wonti, tala nankani Maria, nani bakana ngamana ngarina wonti Jesungu tidnani jaura nunkani ngarila. ");
INSERT INTO dif_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marthandru jiglerali ngankana wonti nunkangu mili nganala. Nani wokarana wonti ja jatana wonti: „Kaparajai, jenia jinkangu baku nganai, kakujeli ngakanali ngana kulnulu worarai mili nganala? Jatamai nankangu, nandruja ngakangu marangokananto!“ ");
INSERT INTO dif_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jesujeli kalabana wonti ja jatana wonti: „Marthajai, Marthajai, jundru marapuni manujeli ngundrai ja ngankai. ");
INSERT INTO dif_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Kulno jundru ngamalkananto. Mariandru poto ngumu kalkalkana warai, jenia wata kulnujeli nankangundru manila nganai.“ ");
INSERT INTO dif_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ja jendranguta Nau piri kulnuni nganana wonti ja ngatjina wonti, ja Nau matja mudana, mili nunkani kulno nunkangu jatana wonti: „Kaparajai, ngaianina kiri ngankau ngatjinanto, worderu bakana Johannili mili nunkani kiri ngankanala.“ ");
INSERT INTO dif_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Nau tanangu jatana wonti: „Jura ngatjinani jeruja jatanimai: Ngaperi ngaianini jidni pariwilpani ngamala wapaia, tala jinkani kulikiri pantjiatimai, milila jinkani wokaraiatimai, jertapaterina jinkani pantjiatimai, worderu pariwilpani jeruja bakana mitani. ");
INSERT INTO dif_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Buka ngaianini ngaianingu karari jinkiamai. ");
INSERT INTO dif_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Madlentji ngaianini woramai, ngangau bakana ngaiani muntali nunkangu worai, nulu ngaianingu madlentji ngankanani, ja wata ngaianina wontjanilani wirilkamai, a‐ai, madlentjani ngaianina kulkamai.“ ");
INSERT INTO dif_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Nau tanangu jatana wonti: „Warle jurangundru kamaneli kulno ngamalkai, ja nunkangu tinka terti wapala nganai, ja nunkangu jatala nganai: Kamaneliai, buka ngunku parkulu ngakangn woljaia jinkiamai. ");
INSERT INTO dif_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ngangau kamaneli kulno ngakani paltundru ngakangu wirina warai, ja ngato panila ngamalkai nunkangu kurala.“ ");
INSERT INTO dif_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ja nulu mandrani nunkangu kalabanani ja jatanani: „Wata ngana jupau; mana matja nguru nganai, ja kupa ngakani ngakangunto turarani pirini turarai; ngani ngandandariai jiritjila ja jinkangu jinkila.“ ");
INSERT INTO dif_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ngani jurangu jatai: „Nau bakana wata jiritjinani ja nunkangu jinkinani, ngangau nau kamaneli nunkani nganai, nau nunkani kaukau wapanandru jiritjila nganai, ja nunkangu jinkila nganai worderuntjali nulu ngamalkananto.“ ");
INSERT INTO dif_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ja ngani jurangu jatai: „Ngatjianimai, ja Nulia jurangu jinkila nganai; wontianimai, ja jura mankamankala nganai; nandranandranimai, ja mana jurangu wilpa pantjila nganai. ");
INSERT INTO dif_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ngangau worana ngatjiai, nulu manila nganai; ja warle wontiai, nulu mankamankala nganai; ja warle nandranandrai, nunkangu mana wilpa pantjila nganai. ");
INSERT INTO dif_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Worangu ngaperani jurangundru ngatamura bukaia ngatjila nganai, nnlu nunkangu marda jinkila nganai kara? Bakana parundru kara, nulu nunkangu parundru tjutju jinkila nganai kara? ");
INSERT INTO dif_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Nau nunkangu kapini ngatjinani kara, nulu nunkangu katninunti jinkila nganai? ");
INSERT INTO dif_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Jura, madlentji ngananani, ngujamai, kupani juranani poto ngumu jinkila; worderu morla Ngaperali pariwilpani Jaola kulikiri jinkila nganai tanangu, tana nunkangu ngatjinani!“ ");
INSERT INTO dif_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ja Nulu kutji dunkalkana wonti, nau ngapu nganana wonti. Ja jendranguta kutji matja dunkana, nau ngapula jatana wonti, ja kana wolara ngaruparana wonti. ");
INSERT INTO dif_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Palpa tanangundru jatana wonti: „Beelsebub kutjia kaparali Nulia kutji worana dunkalkai.“ ");
INSERT INTO dif_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Palpali nina wontjana wonti ja malka kulno pariwilpandru nunkangu ngatjina wonti. ");
INSERT INTO dif_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ngangau Nulu tanani ngundrana matja ngujamana, Nau tanangu jatana wonti: „Milila pratjana, munta piltjaru ngankaterinani, pitaru jeribaka pantjila nganai, ja punga kulno punga kulnuni tamburiai. ");
INSERT INTO dif_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Satanas munta piltjaru ngankaterinani, worderu milila nunkani terkananto? Ngangau jura jatai: Beelsebubieli ngato kutji worana dunkalkai. ");
INSERT INTO dif_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ja ngato Beelsebubieli kutji dunkalkanani, waninali ngatamurajeli juranali tanana dunkalkai? Jendrania tana kalala kuranietja jurani nganala nganai. ");
INSERT INTO dif_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ngato Godaia mara wutjujeli kutji dunkalkanani, jeruja morlalu Godaia milila jurangu wokarana warai. ");
INSERT INTO dif_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Kana ngurujeli kaltieli punga nunkani kulkanani, poto nunkani murlali parala nganai. ");
INSERT INTO dif_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Kana morla nguru nunkangu wokaranani ja nina kalalu ngankanani, ngadani nulu tirimalini poto nunkani maniai, tanangu nulu manujeli ngundrai, ja poto nunkani nulu piltjaru ngankai. ");
INSERT INTO dif_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Worana wata ngakangunto nganai, nau tula ngakani nganai; ja warle wata ngakangunto kampai, nulu piltjaru ngankai. ");
INSERT INTO dif_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Kutji murumuru kanandru matja dunkana, nau pitarani palkingai, ngara ngamala wontina, ja nulu nina wata mankamankanani, nau jatai: Ngani tikala nganai pungaia ngakanaia, woderundru ngani matja dunkana. ");
INSERT INTO dif_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ja nau matja wokarana, nulu nina mankamankai matja darpana ja tjirkatjirkana. ");
INSERT INTO dif_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ngadani nau palkai, ja nulu wapalkai kutji mara wora ja mandru, morla madlentji nunkangu; ja tana wiriai naka ngamala; ja ngadani naupini kana morla madlentji pantjila nganai ngoperalani.“ ");
INSERT INTO dif_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jendranguta, Nulu jenia kaukaubanani, widla kulno kana wolarandru ngaiala pirnali nunkangu jatana wonti: „Murlali pirna naupini palku, nulu jidna mandranala, ja ngama jundru tapanala!“ ");
INSERT INTO dif_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Nau jatana wonti: „Kauna, ja morla murlali pirna tana nganai, tanali Godaia jaura ngarai ja ngumu ngamalkai.“ ");
INSERT INTO dif_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Kana wolara jenimalinani, Nulu wonina wonti jatala: „Naupini nguja madlentji nganai; malka tanalia wontiai, ja tanalia wata malka manila nganai windri Prophetaia Jonani malka. ");
INSERT INTO dif_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ngangau worderu Jonas Ninivilani malka nganana wonti, jeruja bakana Kanaia Ngatamura nunkangupini ngujani malka nganala nganai. ");
INSERT INTO dif_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Mitaia Kaparaia widla kunankarindru terkakala nganai kalala ditjini, nunkangupini nguja kanani jela, ja tanangu ngulkuterkala nganai, ngangau nani mitaia wondirandru wokarana wonti, Salomoni kiri ngarala; ja mai, ninkida morla pirna nganai Salomongu. ");
INSERT INTO dif_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ninive kana terkakala nganai kalala ditjini, nunkangupini ngujani jela, ja tanangu ngulkuterkala nganai, ngangau tana madlentjandru karitjina wonti Jonani ngujangujarandru; ja mai, ninkida morla pirna nganai Jonangu. ");
INSERT INTO dif_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Wata kulnujeli, nulu praitji miribai, nina kurukuruni kara, kokuni ngarinala kara widmai, a‐ai, praitji potuni, ngangau tana wirinani mintjina nunkani najinanto. ");
INSERT INTO dif_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Palkuja praitji milki nganai. Jidni milki manju ngananani, jidni palku buru pratjana praitji ngananani; jidni milki madlentji ngananani, jidni palku buru pratjana ngalpuru ngananani. ");
INSERT INTO dif_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ngamalkateriau, nau praitji jinkangu ngananani ngalpuru nganaiati. ");
INSERT INTO dif_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Jinkani palku pratjana praitji ngananani, ja wata buru kulno ngalpuru ngananani, nau paruparu praitji nganala nganai, jeruja, worderu praitjieli mintjinali nunkanali jinkangu mintjinani.“ ");
INSERT INTO dif_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nau jenia jatana, Pharisaia kulno nunkangu ngatjina wonti, Nulu nunkangunto tajinanto. Nau matja wirina, Nau kurluni ngamana ngarina wonti. ");
INSERT INTO dif_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Pharisaiali najina wonti ja ngaruparana wonti, ngangau Nau tajinani ngopera wata kulirkaterina wonti. ");
INSERT INTO dif_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kapara nunkangu jatana wonti: „Jura Pharisaiali koko ja piri tokuni kulikiri ngankai; jurani mandrani watawatali ja madlentji manamiri nganai. ");
INSERT INTO dif_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Jura kana patipati! Nulupini, Nulia toku pantjimana wonti, wata bakana mandra pantjimana wonti? ");
INSERT INTO dif_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mina mandrani nganai wangiwangini jinkiau; ja mai, pratjana jurangu kulikiri nganai. ");
INSERT INTO dif_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Jakajai jurangu, jura Pharisaia, ngangau jura manjura ja kalumba ja kanta pilki pratjana puntipai, ja buru kulno marapratjanandru Godani jinkiai, ja kalala ja Godaia ngantjana jura worarai; tananapini jura ngankananto, ja jenia wata worarananto. ");
INSERT INTO dif_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Jakajai jurangu, jura Pharisaia, ngangau jura ngantjai piri ngopera jaura pungani, ja mandurini jaura jinkimalini pirini. ");
INSERT INTO dif_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Jakajai jurangu, jura jaura jinkinietja ja Pharisaia, jura kana jeljujelju, ngangau jura nariwonpa warula jeri, ja kana tanangu miri wirariai ja jenia wata ngujamai.“ ");
INSERT INTO dif_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jirijiribani jauraia ngujangujara jinkinietja kulnujeli kalabana wonti ja nunkangu wonti: „Ngujangujara jinkinietjajai, jenia jaurali jundru bakana ngaianina ngirkibai.“ ");
INSERT INTO dif_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Nau jatana wonti: „Jakajai bakana jurangu, jura jirijiribani jauraia ngujangujara jinkinietja, ngangau jura kanani bururu mati pirna kurarai, ja muntali jura nina bururu wata mara ngalkieli patai. ");
INSERT INTO dif_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Jakajai jurangu, ngangau jura Prophetaia nariwonpa ngankijiribai, ja ngaperali juranali tanana nari ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Jeruja jura muntali morlalu kurai ngaperaia juranaia ngankanani; ngangau tanali tanana nari ngankana wonti, ja jura nariwonpa tananina ngankijiribai. ");
INSERT INTO dif_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Jendrania bakana Godaia kirila jatana wonti: «Ngato tanangu Apostel ja Propheta worana jinpala nganai, ja tanangundru palpa tanali nari ngankala nganai ja tanangu tirikaripaterila nganai.» ");
INSERT INTO dif_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ngangau tanalipini ngujali kalala maninanto Propheta pratjanaia kumarandru jenia nanganani mita pantjimanandru; ");
INSERT INTO dif_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abelani kumarandru Zachariani kumaranilu, nau palina wonti Tarani Altarani ja Godaia pungani terti. Kau, ngani jurangu jatai: Tanalipini ngujali kalala manila nganai jendrangundruja. ");
INSERT INTO dif_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Jakajai jurangu, jura jirijiribani jauraia ngujangujara jinkinietja, ngangau jura ngujamani mana ngamalkai; jura munta wata wiriai, ja tanana, tanali ngantjai wirila, jura ngandrawalkai.“ ");
INSERT INTO dif_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Nau tanangu jenia jatana, jaura jinkinietjali ja Pharisaiali wonina wonti nina jaura winpala, ja palpandru nina jakalkala, ");
INSERT INTO dif_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Tanali nina kurukuru najinajibana wonti ja wontina wonti nunkani manandru palpa patala, nunkangundru ngulkuterkananto. ");
INSERT INTO dif_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Jendranguta kana wolara mapaterina wonti 1000 marapu jelalu, jeruja tana tidnali dakamalina wonti. Ja Nulu wonina wonti milini nunkanani jatala: „Ngopera Pharisaiaia pulkurutjeribani bukandru ngamalkaterianau, jenipara jeljujelju. ");
INSERT INTO dif_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ngangau panila kuripi nganai, nau wata tinkari pantjila nganai; ja panila kurukuru nganai, nina tanali wata ngujamala nganai. ");
INSERT INTO dif_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Jendrania, mina jura ngalpurani jatana warai, jenia tanali praitjani ngarala nganai! ja mina jura talpani punga bitini kaukaubana warai, jenia tanali punga mangatandrani kaukaubala nganai. ");
INSERT INTO dif_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ngani jurangu, kamanelini ngakanani, jatai: Wata tanangundru japali ngananau, tanali palku nari ngankai, ja ngadani tana ngandandariai morla ngankala. ");
INSERT INTO dif_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ngato jurangu wondrala nganai, worangundru jura japali nganananto; nunkangundru japali ngananau, Nulia matja nari ngankana, bakana ngurula ngamalkai turuja teribala; kau, ngani jurangu jatai, nunkangundru japali ngananau. ");
INSERT INTO dif_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Tanali wata tiwilitja mara worali mardatandra waka mandrundru jinkimaliai? ja Goda wata kulno tanangundru kuritarana warai. ");
INSERT INTO dif_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Bakana para pratjana jurani mangatandrani matja windamana. Wata japali ngananau; ngangau jura morla pirna nganai tiwilitja marapuni. ");
INSERT INTO dif_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ngani jurangu jatai: Warle ngana dikala nganai kanani, nina bakana Kanaia Ngatamurajeli dikala nganai Godaia angelani. ");
INSERT INTO dif_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Warle ngana kutikutibala nganai kanani, nina ngato kutikutibala nganai Godaia angelani. ");
INSERT INTO dif_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ja warle jaura madlentji jatanani Kanaia Ngatamurani, nunkangu Nulia kalingala nganai; ja warle Jaola kulikiri ngirkibai, nunkangu Nulia wata kalingala nganai. ");
INSERT INTO dif_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Tanali jurana jaura pungani ja mitaia kaparani ja ngurulani wapalkanani, wata manujeli ngundranau worderu kara, mina kara jura kalabananto kara jatananto kara. ");
INSERT INTO dif_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ngangau Jaolali kulikirieli jurana nunkangupini ditjini kiri ngankala nganai, mina jura jatananto.“ ");
INSERT INTO dif_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Kana wolarandru kulno nunkangu jatana wonti: „Ngujangujara jinkinietjajai, nejini ugakanani jatamai, nulungali poto maratunka puntibananto.“ ");
INSERT INTO dif_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Nau nunkangu jatana wonti: „Kanajai, warlenulu ngana talku jatanietja kara, poto maratunka puntibijiribanietja jurangu kurana warai?“ ");
INSERT INTO dif_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nau tanangu jatana wonti: „Najinajibaterianau ja ngamalkaterianau poto manujeli ngundranadru; ngangau kana kulno wata tepiriai, nulu poto marapu ngamalkanani.“ ");
INSERT INTO dif_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Nulu tanangu jeribaka jaura kaukaubana wonti ja jatana wonti: „Kana poto pirnaia mitali marapu mandrana wonti. ");
INSERT INTO dif_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ja nulu muntali ngundrana wonti ja jatana wonti: «Mina ngato ngankala nganai, ngangau ngato wata piri ngamalkai, woderi ngato tandra ngakani kurananto?» ");
INSERT INTO dif_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ja Nau jatana wonti: Jenia ngato ngankala nganai; Ngato kampani punga ngakani wokaribala nganai ja morla pirna wotila nganai, ja jerra ngato pratjana kurala nganai, mina ngakangu matja punkana, ja poto ngakani. ");
INSERT INTO dif_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ja ngani mungarani ngakanani jatala nganai: «Mungarajai, jundru poto marapu ngamalkai kilpawoldra marapuja; ngara ngamamai, tajiau, tapau, tepiriau!» ");
INSERT INTO dif_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Goda nunkangu jatana wonti: «Jidni kana patipatiai! nunkangupini tinkani Nulia mungara jinkani karkala nganai; wanini jenia nganala nganai, mina jundru matja ngankingana?» ");
INSERT INTO dif_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jeruja nau nganai, nulu nunkangu muntali poto kampai, ja wata poto pirna nganai Godani.“ ");
INSERT INTO dif_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Nau milini nunkanani jatana wonti: „Jendrania ngani jurangu jatai: Wata manujeli ngundranau tepini juranani, mina jura tajila nganai, bakana wata palkuni juranani, mina jura widmaterila nganai. ");
INSERT INTO dif_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Tepi morla pirna nganai bukani, ja palku morla pirna katini. ");
INSERT INTO dif_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kawalka najianau; ngangau tanalia wata jaupai ja wata kampai, ja wata tajina pnnga ja kampani punga ngamalkai, ja Godali tananaia jerto ngankai; worderu morla pirna jura nganai paiani? ");
INSERT INTO dif_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Worana jurangundru ngurunguru nganai, tepini nunkanani tintipidi kulno juri ngankala manujeli ngundraterinali? ");
INSERT INTO dif_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Jura ngandandarinani wakawakani, minandru jura manujeli ngundrai pilkilani? ");
INSERT INTO dif_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ngunandula najianau, worderu tanaia punkai; tanalia wata ngankai ja wata turpai; ngani jurangu jatai: Bakana Salomo pirnalani nunkanani pratjanani wata widmaterina wonti tanangundru kulnuni jeribaka. ");
INSERT INTO dif_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Godali kanta jeruja widmanani, nauja karari maruni terkai, ja tankubana tanali ninaia turupirini worai; worderu morla jurangu, jura wuldrungundranietja worajai! ");
INSERT INTO dif_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Bakana jura wata manujeli ngundranau, mina jura tajila nganai kara, mina jura tapala nganai kara, ja wata milkirianau! ");
INSERT INTO dif_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Jenia pratjana mitaia kanali wontiai; Ngaperi jurani milkila, jura jenia pratjana ngamalkananto. ");
INSERT INTO dif_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Wontianau Godaia milila, ja jenia pratjana Nulia jurangu jinkila nganai. ");
INSERT INTO dif_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Wata japali ngangau, ngangau jidni ngami wakawaka; ngangau Ngaperi jurani jertapaterina wonti jurangu milila jinkila. ");
INSERT INTO dif_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Buru ngankanau mina jura ngamalkai, ja wangiwangini bakujeli jinkianau. Jurangu billi ngankanau, tana wata womala pantjiai; poto pariwilpani nau wata mudai, woderi kurikantji wata karakara wokarai, ja bakana wata kakatjieli tajiai. ");
INSERT INTO dif_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ngangau woderi ngantjani poto jurani parai, naka bakana jurani ngara nganai. ");
INSERT INTO dif_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Jura kapa ngampianau, ja praitji jurani mintjianau. ");
INSERT INTO dif_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Jenipara kanani jeribaka ngananau, tanali kaparani tananani kalkai, nunkangu nurujeli mana walto ngankala, nau noapatamalini ditjindru wokarala tikanani ja nandranandranani. ");
INSERT INTO dif_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Murlali pirna tanapara mili, tanana kaparali tananali, nau wokarana tikanani, tepi mankamankala nganai. Morlalu ngani jurangu jatai: «Nau ngampipaterila nganai, ja tanangu manuni kurala nganai kurlini ngamana ngarinanto, ja nau wapala nganai tanangu mili nganala.» ");
INSERT INTO dif_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ja nau tinka terti kara, nguramaranaia woljaia kara wokaranani, ja tanana jeruja mankamankanani: Murlali pirna tanapini mili! ");
INSERT INTO dif_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Jenia ngujamanau, punga ngamalkanietja milkila ngananani, mina ditji tinkani kurikantji wokarai, nau tepi ngamala nganai ja ngandrawalkala nganai, nau wata pungani nunkanani wirinanto. ");
INSERT INTO dif_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Bakana jura ngankingaterianau! ngangau ditji kulnuni, nina jura wata ngundrai, Kanaia Ngatamura wokarala nganai.“ ");
INSERT INTO dif_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petrus nunkangu jatana wonti: „Kaparajai, jidni ninapini jeribaka jaura ngaianingu jatai kara marapuni kara.“ ");
INSERT INTO dif_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Kapara jatana wonti: „Worana punga ngamalkanietja talku ja kiri nganai, nina kaparali najinajibanietja milini nunkanani kurala nganai, nulu tanangu buka ditji talkuni jinkinanto. ");
INSERT INTO dif_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Murlali pirna jenipara mili, nina kaparali nunkanali, nau wokarana tikanani, jeruja ngankanani mankamankala nganai. ");
INSERT INTO dif_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Morlalu ngani jurangu jatai: Nulu nina kapara kurala nganai nunkani poto pratjanani. ");
INSERT INTO dif_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Naupara mili ngarali nunkanali jatanani: Kapara ngakani kalkai wokarala, ja nau woninani mili materi ja mili widla nandrala, tajila ja tapala ja parawarala. ");
INSERT INTO dif_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Jenipara milia kapara wokarala nganai miljaru kulnuni, nina nulu wata ngundrai, ja ditji kulnuni, nina nulu wata ngujamai, ja nina terti tjelapalkala nganai, ja nunkangu kalala nunkani kana tjikatjikani jeribaka kurala nganai. ");
INSERT INTO dif_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Jenipara milieli, nulu kaparaia nunkanaia jertapaterina ngujamai, ja wata ngankingana warai, ja bakana jertapaterinani nunkanani wata pankina warai, nandrana marapu manila nganai. ");
INSERT INTO dif_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Warle nina wata ngujamana warai, ja jenia ngankana warai, minandru nulu nandrana maninanto, nulu nandrana ngalje manila nganai. Nunkangundru, nunkangu marapu matja jinkina, Nulia marapu wontila nganai; ja worangu Nulia marapu jinkina warai, morla marapu Nulia nunkangundru karkala nganai. ");
INSERT INTO dif_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ngani wokarana wonti turu mitani worala, ja ngato ngantjai, nau matja jerkinanto! ");
INSERT INTO dif_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Multibanila kulno ngato maninanto, ja worderu japali ngani nganai nau mudanantulu! ");
INSERT INTO dif_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Wata ngundranau, ngani wokarana warai murla jinkila mitani, a‐ai, windri puntibala. ");
INSERT INTO dif_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ngangau kararindru mara wora punga kulnuni puntibijiribamalila nganai; parkulu mandruni ja mandru parkulani. ");
INSERT INTO dif_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ngaperali puntibala nganai ngatamurani ja ngatamurajeli ngaperani; ngandrieli ngatani mankarani ja ngatani mankarali ngandrini; paiarali kalarani nankanani, ja kalarali paiarani nankanani.“ ");
INSERT INTO dif_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Nau bakana kana wolarani jatana wonti: „Jura talara palku kulno kalkaura jendakarani dunkanani najinani, jura nurujeli jatai: Kunditji wokarai, ja jeruja morlalu pantjiai. ");
INSERT INTO dif_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ja jura kunankari watara ngakanani najinani, jura jatai: «Woldra pirna pantjila nganai, ja jeruja morlalu pantjiai.» ");
INSERT INTO dif_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Jura kana jeljujelju! mitaia ja pariwilpaia mudla jura ngujamai wontjala; minandru jura ninapini miljaru wata wontjai? ");
INSERT INTO dif_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Minandru jura wata muntali tjurujeli ngundrai mina talku nganai? ");
INSERT INTO dif_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ngangau jidni talpalani jinkanani jelalu mitaia kaparani wapanani, paltuni jigleri ngankau nunkangu kulnukulnuni nganala; ngangau nulu jidnana kalala kuranietjani wapal‐kaiati, ja kalala kuranietjali jidnana milini jinkiati, ja milieli jidnana kanjangari pungani widmaiati. ");
INSERT INTO dif_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Morlalu ngani jinkangu jatai: «Jidni wata morla nakandru dunkala nganai, jundru ngopera mudani marda jinkinantulu.»“ ");
INSERT INTO dif_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Tanangupini ditjini palpa naka nganana wonti, tanali nunkangu Galilaialandru kaukaubana wonti, tanani kumari Pilatulu tanani poto ngumuni duldruwanala. ");
INSERT INTO dif_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ja Jesujeli kalabana wonti ja tanangu jatana wonti: „Jura ngundrai, tana Galilaiala morla madlentji ngananala Galilaiala worangu, ngangau tanali jenia ketjaketjanala?“ ");
INSERT INTO dif_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","A‐ai, ngani jurangu jatai: „Jura wata madlentjandru karitjinani, jura pratjana tanangu jeribaka palila nganai. ");
INSERT INTO dif_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Tana marapratjana ja mara wora ja parkulu kara, tanangupini Siloa punga wutju purina wonti, ja tanana nari ngankana wonti; jura ngundrai, tana morla madlentji nganana wonti kana pratjanani Jerusalem ngurani ngamanani? ");
INSERT INTO dif_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","A‐ai, ngani jurangu jatai; jura wata madlentjandru karitjinani, jura tanangu jeribaka palila nganai.“ ");
INSERT INTO dif_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Nau ninapini jeribaka jaura jatana wonti: „Kulnujeli tandraia nindri maruni nunkanani kurana wonti; ja nau wokarana wonti nunkangu tandra wontila ja panila mankamankana wonti. ");
INSERT INTO dif_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Nau maru ngamalkanietjani jatana wonti: «Mai, kilpawoldra parkulu ngani wokarai nunkangupini tandra nindrindru tandra wontila, ja panila mankamankai; ninaia wokaribamai, minandru nulia mita ngandrawalkai?» ");
INSERT INTO dif_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Nulu kalabana wonti ja nunkangu jatana wonti: «Kaparajai, nunkangupini kilpawoldrani ninaia worani patamai, ngato nunkangu bakuna karitjinantulu ja kudna kuranantulu. ");
INSERT INTO dif_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Nulia kara ngadani tandra punkibananto; pani kara, ngadani jundru ninaia wokaribananto.»“ ");
INSERT INTO dif_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ja Nulu jaura punga kulnuni Sabbat ditjini ngujangujara jinkina wonti. ");
INSERT INTO dif_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ja mai, widla kulno naka nganana wonti, nandru waltowaltuja kutji kilpawoldra marapratjana ja mara wora ja parkulu ngamalkana wonti, ja nani tjunduru nganana wonti ja ngandandarina wonti talku terkala. ");
INSERT INTO dif_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesujeli nana najina, Nulu nana karkana wonti ja nankangu jatana wonti: „Widlajai, dukarateriau jinkani waltowaltundru!“ ");
INSERT INTO dif_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ja Nulu nankangu mara kuraterina wonti, ja nurujeli nani talku terkana wonti ja Goda jurakokana wonti. ");
INSERT INTO dif_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Jaura pungaia kaparali junkarina wonti, ngangau Jesujeli Sabbat ditjini tepi ngankana warai, ja nulu kalabana wonti ja kana wolarani jatana wonti: „Ditji mara wora ja kulno nganai, tanangu jura ngankananto, tanangupini wokaranau Nulia jurana tepi ngankananto, ja wata Sabbat ditjini!“ ");
INSERT INTO dif_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Kaparali nunkangu kalabana wonti ja jatana wonti: „Jidni kana jeljujelju! wata jura pratjanali jurani nganti kara, donki kara, pirrandru dukarai, ja tanana wapalkai ngapaia, Sabbat ditjini? ");
INSERT INTO dif_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Nanipini bakana Abrahamani ngatamura, nana kutjieli kilpawoldra marapratjana ja mara wora ja parkulu matja dupudupu ngankana, ngato nana wata kurakananto nanapini dupudupundru Sabbat ditjini?“ ");
INSERT INTO dif_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ja Nau jenia jatanani, talpala nunkani pratjana nintali pantjina wonti; ja kana wolara mankina wonti pirnala pratjanandru, jenia nunkangundru pantjinala. ");
INSERT INTO dif_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Nau jatana wonti: „Worangu jeribaka Godaia milila nganai, ja worangu jeribaka ngato nina kurala nganai? ");
INSERT INTO dif_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nau paua wakawakani jeribaka nganai, ninapini kana kulnujeli manina wonti, ja maruni nunkanani jaupana wonti; ja nau punkana wonti, ja pita pirna pantjina wonti, ja paia ngaranani ngunani nunkanani kunjila wontina wonti.“ ");
INSERT INTO dif_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ja nakaldra Nau jatana wonti: „Worangu jeribaka ngato Godaia milila kurala nganai? ");
INSERT INTO dif_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nau pulkurutjeribani buka jeribaka nganai, nina widla kulnujeli manina wonti ja kurukurumalkana wonti koko pirna parkulu buka turarani, nau pulkurutjeranantulu.“ ");
INSERT INTO dif_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ja Nau ngura pirnani ja wakani palkingana wonti ngujangujara jinkila, ja Nau Jerusalemia palkana wonti. ");
INSERT INTO dif_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Kulno nunkangu jatana wonti: „Kaparajai! tana ngalje nganai kara, tanali tepi manila nganai?“ Nau tanangu jatana wonti: ");
INSERT INTO dif_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","„Jiglerali ngankanau mana wuldruni wirila; ngangau marapujeli, ngani jurangu jatai, wontiai wirila, ja ngandandarila nganai. ");
INSERT INTO dif_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Jendranguka ditjindru, punga ngamalkanietja matja terkakana ja mana matja nguru ngankana, jura wonila nganai palarani terkala ja mana nandranandrala ja jatala: «Kaparajai, Kaparajai, ngaianingu walto ngankamai!» ja Nulu kalabala nganai ja jatala nganai: Ngato jurana wata ngujamai wodajerindru jura nganai. ");
INSERT INTO dif_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ngadani jura wonila nganai jatala: «Ngaiani jinkangu milkini tajinala ja tapanala, ja paltuni ngaianinani jundru ngujangujara jinkinala.» ");
INSERT INTO dif_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ja Nau jatala nganai: Ngani jurangu jatai, ngato jurana wata ngujamai wodajerindru jura nganai; wapanau ngakangundru pratjana jura tjikatjika ngankanietja! ");
INSERT INTO dif_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Naka ngirikidana ja mana katakatangana nganala nganai, jura najinani Abraham ja Isaak ja Jakob ja Propheta pratjana Godaia mililani, ja jurana nunkangundru matja teribana. ");
INSERT INTO dif_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ja tana tiriwandru ja jendakarandru ja tidnankarandru ja kunankarindru wokarala nganai, ja Godaia mililaia kurlini ngamana ngarila nganai. ");
INSERT INTO dif_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ja mai, ngadalata nganai, tana ngopera nganala nganai, ja ngoperalata nganai, tana ngadaia nganala nganai.“ ");
INSERT INTO dif_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Nunkangupini ditjini Pharisaia palpa nunkangu wokarana wonti ja nunkangu jatana wonti: „Puntiau, ja ninkidandru palkau, ngangau Herodili jertapateriai jidna nari ngankala.“ ");
INSERT INTO dif_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ja Nau tanangu jatana wonti: „Wapanau ja nunkangupini kintala jampani jatanau: Mai, ngato kutji worana dunkalkai ja tepi ngankai karari ja dankubana, ja ditjini parkulani ngato mudala nganai. ");
INSERT INTO dif_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Jendrania ngani karari ja dankubana ja tankubana kulnuni palkananto; ngangau jenia wata pantjinanto, Propheta kulno wata Jerusalemingu palinanto. ");
INSERT INTO dif_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jerusalemiai, Jerusalemiai! jundru Propheta worana nandrai, ja mardali dakai, tanana jinkangu jinpanala; worderuntja pota ngato kupa jinkani jertapaterina wonti mapala, worderu warugati ngandrieli nankani wolka nankani ngaruni mapai, ja jura wata ngantjana wonti. ");
INSERT INTO dif_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Mai, punga jurani ngurawalpa parala nganai. Morlalu ngani jurangu jatai: Jura ngana wata morla najila nganai jura jatanantulu: Ngaiani jurakokai ninaia, Nauja wokarai Kaparaia talani!“ ");
INSERT INTO dif_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Jendranguta Nau Sabbat ditjini Pharisaia kaparaia pungaia wirina wonti buka tajila, ja tanali nina najinajibana wonti. ");
INSERT INTO dif_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ja mai, kana kulno nunkangu kantjini nganana wonti ngapali muntja. ");
INSERT INTO dif_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ja Jesujeli kalabana wonti ja jirijiribani jauraia nguja ngujara jinkinietjani ja Pharisaiani jatana wonti: „Jenia talku nganai, Sabbat ditjini tepi ngankala kara, pani kara?“ ");
INSERT INTO dif_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Tana ngapurina wonti. Ja Nulu nina patana wonti ja tepi ngankana wonti ja nina jinpana wonti. ");
INSERT INTO dif_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ja Nulu kalabana wonti ja tanangu jatana wonti: „Warle jurangundru, ngatamura nunkani kara nganti kara ngapa kutuni purinani, nulu nina wata nurujeli dukarala nganai Sabbat ditjini?“ ");
INSERT INTO dif_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ja tana ngandandarina wonti nina jendrangundruja kalabala. ");
INSERT INTO dif_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Nau jeribaka jaura jatana wonti kurlia kamanelini, ngangau Nulu najina wonti, worderu tanali piri ngopera kalkalkanani, ja tanangu jatana wonti: ");
INSERT INTO dif_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","„Kana kulnujeli jidna karkanani noa patamalini bukaia, wata piri ngoperani ngamana ngariau, nulu kara kulno morla pirna jinkangu karkana warai; ");
INSERT INTO dif_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ja nau wokaranani, nulu jidna ja nina matja karkana, nau jinkangu jatala nganai: Jerrariau; ja jidni wonila nganai mudani pirini ngamala. ");
INSERT INTO dif_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","A‐ai, kulnujeli jidna karkanani, wapau ja mudani pirini ngamana ngariau; ngangau nau wokaranani, nulu jidna matja karkana, nau jinkangu jatala nganai: Kamaneliai, jera tarau! ngadani jundru pirnala ngamalkala nganai tanangundru, tana jinkangu jela kurlini ngamai. ");
INSERT INTO dif_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ngangau warle pirna ngankateriai, nau waka pantjila nganai; ja warle waka ngankateriai, nau pirna pantjila nganai.“ ");
INSERT INTO dif_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Nau nunkangu, nulu nina matja karkana, jatana wonti: „Jundru manamuka kara, buka pirna kara ngankinganani, wata kana kamaneli jinkani karkau, bakana wata neji worana jinkani, bakana wata kamaneli jinkani, bakana wata jenimalinietjaia kana poto pirna; ngangau tanali jidnana nakaldra karkaiati ja jinkangu kalala pantjiati. ");
INSERT INTO dif_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","A‐ai, jundru buka pirna ngankinganani, jeruja karkau kana wangiwangi, dupudupu, tjunduru, butju. ");
INSERT INTO dif_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ja murlali pirna jidni nganala nganai, ngangau tanali wata ngamalkai jinkangu kalala jinkila; ngangau jundru kalala manila nganai kana talkuja jiritjini ditjini.“ ");
INSERT INTO dif_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Kurlaia kamaneli kulnujeli jenia ngaranani, nau nunkangu jatana wonti: „Murlali pirna, warlenulu buka tajila nganai Godaia mililani.“ ");
INSERT INTO dif_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nau nunkangu jatana wonti: „Kana kulnujeli buka pirna ngankingana wonti ja marapuni jatingana wonti. ");
INSERT INTO dif_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ja nulu mili nunkani jinpana wonti bukaia ditjini, tanangu matja karkana, jatala: «Kaparanau, ngangau pratjana matja ngankingana warai.» ");
INSERT INTO dif_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ja tanali pratjanali wonina wonti kulnukulnuni delkila. Ngoperala nunkangu jatana wonti: «Ngato mita kulno burungankana warai, ja ngani morlalu wapananto nina najinajibala; ngani jinkangu ngatjiai, manju jatamai ngakangundru.» ");
INSERT INTO dif_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ja kulno jatana wonti: «Ngato nganti marapratjana burungankana warai, ja ngani wapai tanana wontjala; ngani jinkangu ngatjiai, manju jatamai ngakangundru.» ");
INSERT INTO dif_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ja kulno jatana wonti: «Ngato noa patana warai, jendralia ngani ngandandariai wokarala.» ");
INSERT INTO dif_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ja mili tikana wonti ja jenia kaparani nunkanani kaukaubana wonti. Jendranguta pungaia kapara tiri pantjina wonti ja milini nunkanani jatana wonti: «Nurujeli wapamai nguraia palto pirnani ja wakani, ja wangiwangi, ja dupudupu, ja tjunduru, ja butju wirilkamai.» ");
INSERT INTO dif_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ja mili jatana wonti: «Kaparajai, jenia matja pantjina, worderu jundru jirijiribana warai, ja morla piri parai.» ");
INSERT INTO dif_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ja Kapara milini jatana wonti: «Wapamai paltuni ja wondirani, ja tanana mararibamai wirinanto; ngangau punga ngakani manamiri pantjinanto.» ");
INSERT INTO dif_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ngangau ngani jurangu jatai: Wata kana kulnujeli tanangundru, ngani matja jatingana, buka ngakani wontjala nganai.“ ");
INSERT INTO dif_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Kana wolara marapu nunkangunto wapana wonti; ja Nau karitjina wonti ja tanangu jatana wonti: ");
INSERT INTO dif_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","„Kulno ngakangu wokaranani ja wata kalakalarinani ngaperani nunkanani ja ngandrini ja noani ja kupani ja neji marani ja kakuni, ja bakana mungarani nunkanani; nau ngandandariai mili ngakani nganala. ");
INSERT INTO dif_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ja warlenulu wata kunarku nunkani mandrai ja ngakangu karipateriai, nau ngandandariai mili ngakani nganala. ");
INSERT INTO dif_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ngangau warlenulu jurangundru ngantjai pungu wutju wotila, nauja wata ngopera ngamana ngarinani wintamala, nulia pratjana ngamalkai nina mudala? ");
INSERT INTO dif_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ngangau, nulia marda kapara matja kurana kara, ja ngandandarinani nina mudala, pratjanali nina najinani, woniati ninaia ngirkibala, ");
INSERT INTO dif_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ja jatala: «Nulupini kanali wonina warai wotila, ja ngandandarina warai mudala.» ");
INSERT INTO dif_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Worana mitaia kapara nganai kara, nau palkanani mitaia kapara kulnuni tirimalila, nau wata ngopera ngamana ngarinani ja munta warawarabanani, nau ngurunguru nganai kara 10,000 kananto nunkangu mandurila, nau nunkangu manduriai 20,000 kananto? ");
INSERT INTO dif_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Pani kara, nulu mili nunkani jinpala nganai, nau worita ngananani, nunkangundru murla ngatjila. ");
INSERT INTO dif_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Jeruja bakana pratjana jurangundru, warlenulu wata pratjana, mina nulu ngamalkai, worarai, ngandandariai mili ngakani nganala. ");
INSERT INTO dif_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Kaldri ngumu nganai; kaldri dunkarinani, minali tanali kaldri ngankananto? ");
INSERT INTO dif_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Wata mitani kara wata tunkani kara nau ngumu nganai, a‐ai, tanali nina palarani worarai. Warle talpa ngamalkai ngarala, nulu ngaraiatimai!“ ");
INSERT INTO dif_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Mardatandra kampanietja ja kana madlentji marapu nunkangu karakarana wonti nina ngarala. ");
INSERT INTO dif_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ja Pharisaiali ja jaura jinkinietjali kuterilkana wonti ja jatana wonti: „Nulupini kana madlentji patai, ja tanali jelali tajiai.“ ");
INSERT INTO dif_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Nulu tanangu ninapini jeribaka jaura kaukaubana wonti ja jatana wonti: ");
INSERT INTO dif_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","„Warlenulu kanali jurangundru, nulu 100 tjipi ngamalkanani, ja kulno tanangundru tintanani, wata nulu 99 wolja woraranani pitarani ja wapantinani nunkangu, nau matja tintaterina, nulu nina mankamankalalu? ");
INSERT INTO dif_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ja nulu nina matja mankamankana, nulu mankina nina pilperani kurana tarai. ");
INSERT INTO dif_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ja nau pungani matja tikana, nulu kamaneli ja jenimalinietja karkai ja tanangu jatai: «Ngakangunto mankianimai, ngangu tintani tjipi ngakani ngato mankamankana warai.» ");
INSERT INTO dif_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ngani jurangu jatai: Jeruja bakana pariwilpani mankina nganala nganai kana madlentji kulnundru, nau madlentjandrn karitjinani, morla 99 talkuni, tana wata madlentjandru karitjinanto. ");
INSERT INTO dif_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Widla kulnujeli kara mardatandra marapratjana ngamalkanani, ja nandru mardatandra kulno tintanani, wata praitji miribai, ja punga darbai, ja jiglerali wontiai, nina mankamankalalu? ");
INSERT INTO dif_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ja nandru nina matja mankamankana, nandru kamaneli ja jenimalinietja karkai ja jatai: «Ngakangunto mankianimai, ngangau nina mardatandra ngato mankamankana warai, nina ngato tintana warai.» ");
INSERT INTO dif_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Jeruja bakana ngani jurangu jatai: Godaia angela mankila nganai kana madlentji kulnundru, nau madlentjandru karitjinani.“ ");
INSERT INTO dif_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Nau jatana wonti: „Kana kulnujeli ngatamura mandru ngamalkana wonti. ");
INSERT INTO dif_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ja wakaia kupali ngaperani jatana wonti: «Ngaperiai, jinkiau ngakangu jenia poto ngakani pilki nganai.» Ja nulu pudlangu poto puntibana wonti. ");
INSERT INTO dif_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ja ditji palpani ngadani wakaia kupali pratjana ngokana wonti ja mita woritaia palkana wonti; ja jelaua nulu poto nunkani tintana wonti tepi madlentjali. ");
INSERT INTO dif_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nulu pratjana matja tintana, nunkangupini mitani maua pirna pantjina wonti; ja nulu wonina wonti maua ngamala. ");
INSERT INTO dif_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ja nau wapana wonti ja nunkangupini mitani kana kulnuja mili pantjina wonti; ja nulu nina mitani nunkanani jinpana wonti nganti ngamalkananto. ");
INSERT INTO dif_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ja nau ngalkujeli nganana wonti mandra nunkani tandra talali jerturila, tanana ngantieli tajina wonti, ja wata kulnujeli nunkangu jinkina wonti. ");
INSERT INTO dif_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Nau burkali pantjina wonti ja jatana wonti: «Worderuntja mili ngaperali ngakanali ngamalkai, tanali buka marapu ngamalkai, ja ngani mauali paliai. ");
INSERT INTO dif_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ngani jiritjila nganai, ja ngapinangu tikala nganai, ja nunkangu jatala nganai: ‚Ngaperiai, ngato madlentji ngankanala pariwilpani ja jinkangu, ");
INSERT INTO dif_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ngani wata morla talku nganai jundru ngana ngatamura jinkani dikananto; ngana mili jinkani ngankamai.‘ » ");
INSERT INTO dif_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ja nau jiritjina wonti, ja ngaperani nunkanani wokarana wonti. Nau matja worita nganana, ngaperali nunkanali nina najina wonti, ja nau nunkangu kalumiltjamiltjarina wonti ja mindrina wonti, ja nina munkana wonti ja manatapana wonti. ");
INSERT INTO dif_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ngatamura nunkangu jatana wonti: «Ngaperiai, ngato madlentji ngankanala pariwilpani ja jinkangu; ngani wata morla talku nganai, jundru ngana ngatamura jinkani dikananto.» ");
INSERT INTO dif_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ngaperi milini nunkanani jatana wonti: «Nurujeli kati ngumu pirna dukaranau ja nunkangu widmanau, ja marani nunkanani marapirapira kuranau, ja tidnaputa tidnani nunkanani, ");
INSERT INTO dif_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ja nina nganti kuparu manipirna manianau ja nandranau; ja ngaiana tajinanto ja mankinanto; ");
INSERT INTO dif_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ngangau naupini ngatamura ngakani nari nganana warai, ja nakaldra tepirina warai, nau tintaterina warai, ja nina matja mankamankana.» Ja tanali wonina wonti mankila. ");
INSERT INTO dif_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Neji nunkani maruni nganana wonti: ja nau tikanani ja pungani matja karakara, nulu wima ja dultrinani ngarana wonti. ");
INSERT INTO dif_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ja nulu mili kulno karkana wonti, ja nina jakalkana wonti mina jenia wondrai. ");
INSERT INTO dif_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Nau nunkangu jatana wonti: «Ngatata jinkani matja tikana, ja ngaperali jinkanali nina nganti kuparu manipirna nandrana warai, ngangau nulu nina nakaldra tepi ngamalkai.» ");
INSERT INTO dif_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Nau tiri pantjina wonti, ja wata ngantjana wonti wirila. Ngaperi nunkani dunkana wonti, ja nina kurukurubana wonti. ");
INSERT INTO dif_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Nulu kalabana wonti ja ngaperani nunkanani jatana wonti: «Mai, jeruntjaia kilpawoldra ngani jinkangu pankiai, ja wata pota kulno ngato jirijiribani jaura jinkani dankarana warai; ja ngakangu jundru wata pota kulno kuparu waka jinkina warai, ngani ngakani kamanelinto mankinanto. ");
INSERT INTO dif_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Naupini ngatamura jinkani matja tikana warai, nulu poto nunkani pirangurujeli julkana warai, jundru nunkangu nina nganti kuparu manipirna nandrana warai.» ");
INSERT INTO dif_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Nau nunkangu jatana wonti: Kupajai, jidni milingeru ngakangu jela nganai, ja pratjana mina ngakani, jinkani nganai. ");
INSERT INTO dif_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Jidni murlali nganananto ja mankinanto, ngangau naupini ngatata jinkani nari nganana warai ja tepirina warai, ja nau tintaterina warai ja nina matja mankamankana.“ ");
INSERT INTO dif_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Nau bakana milini nunkanani jatana wonti: „Kana kulno poto pirna nganana wonti, nulu ngamalkiribanietja ngamalkana wonti; ja nina tanali nunkangu ngulkuterkana wonti, ngangau nulu poto nunkani duljaduljamanala.“ ");
INSERT INTO dif_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ja nulu nina karkana wonti ja nunkangu jatana wonti: „Mina ngato jinkangundru ngarai? Ngamalkijiribanandru windamau, ngangau jidni ngandandariai morla ngankijiribala.“ ");
INSERT INTO dif_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ngamalkiribanietja warawarapaterina wonti: „Mina ngato ngankananto? Ngangau kaparali ngakanali ngamalkijiribanila ngakangundru maniai. Ngani ngandandariai bakula, ja ngani nintali nganai tjambatjambala, ");
INSERT INTO dif_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ngani milkila, mina ngato ngankala nganai, nulu ngamalkijiribanila ngakangundru mamanani, tanali ngana patananto pungaia tananaia.“ ");
INSERT INTO dif_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ja nulu kaparaia nunkanaia kana poto wilpanto kulno ja kulno karkana wonti ja ngoperalani jatana wonti: „Worderuntja jundru kaparani ngakanani poto wilpanto nganai?“ ");
INSERT INTO dif_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nau jatana wonti: „100 koko gildi;“ ja nau nunkangu jatana wonti: „Talpadakani dakani jinkani patamai, ngamana ngariau, ja nurujeli dakamai 50.“ ");
INSERT INTO dif_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ngadani nau kulnuni jatana wonti: „Ja jundru, worderuntja jundru poto wilpanto nganai?“ Nau jatana wonti: „100 billi buka tandra.“ Ja nau nunkangu jatana wonti: „Talpadakani dakani jinkani patau, ja dakamai 80.“ ");
INSERT INTO dif_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ja kaparali ngamalkiribanietja tjikatjika jurakokana wonti, ngangau nulu kiri ngankana wonti; ngangau nunkanipini mitaia kupa morla kiri nganai praitjaia kupani ngujani tananani. ");
INSERT INTO dif_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ja ngani jurangu jatai: „Jura jurangu muntali kamaneli ngankanimai mamon wata talkuni; ngangau nau mudanani, tanali jurana patala nganai punga nguralia. ");
INSERT INTO dif_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Worana talku nganai wakawakani, nau bakana pirnani talku nganai; ja worana wata talku nganai wakawakani, nau bakana pirnani wata talku nganai. ");
INSERT INTO dif_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Jura mamon wata talkuni wata talkurinani, warle jurangu morlalulali jinkila nganai? ");
INSERT INTO dif_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ja jura tulani wata talkurinani, warle jurangu juranani jinkila nganai? ");
INSERT INTO dif_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Pungaia mili kulno ngandandariai kapara mandruni mili ngamala; nau kulnuni kalakalarila nganai, ja kulno nulu ngantjala nganai kara, kulnuni nau wodatarana ngamala nganai, ja kulnuni gilbarila nganai kara. Jura ngandandariai Godani ja Mamonani mili ngamala.“ ");
INSERT INTO dif_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Jenia pratjana Pharisaiali ngarana wonti, tanali mardatandra manujeli ngundrana wonti; ja tanali nina ngirkibana wonti. ");
INSERT INTO dif_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Nau tanangu jatana wonti: „Jura jenipara nganai, tana munta talku wondrateriai kanani, ja Godali ngara jurani ngujamai. Ngangau jenia, mina kanani pirna nganai, Godani tjikatjika nganai. ");
INSERT INTO dif_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Jirijiribani jaura ja Propheta Johaningulu; nunkangupini ditjindru tanali ngantjani jaura Godaia mililandru kaukaubai, ja kana pratjanali ngurujeli nunkangu jeniai. ");
INSERT INTO dif_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Morla ngaua nganai pariwilpa ja mita mudanani, tjilpi waka kulno jirijiribani jaurandru purinani. ");
INSERT INTO dif_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Warlenulu noa nunkani worarai, ja kulno nguru patai, nulu pinta wokaribai; ja warlenulu jenipara, materali matja worarana, patai, bakana pinta wokaribai. ");
INSERT INTO dif_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Kana kulno poto pirna nganana wonti, nau kati tjanka waru ja maralje widmaterina wonti, ja ditjini warupotuni tepi ngumu ngankaterina wonti, ja mankina wonti. ");
INSERT INTO dif_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ja kana wangiwangi nganana wonti, tala nunkani Lazarus, naupini punga manani nunkanani parana wonti gambanto. ");
INSERT INTO dif_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ja nau ngalkujeli nganana wonti buka murujeli jerturila, tana kana poto pirnaia kurlindru purinani; ja kintala wokarana wonti ja nina tapa talieli tapana wonti. ");
INSERT INTO dif_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Jendranguta kana wangiwangi palina wonti, ja angelali nina taralkana wonti Abrahamangu ngalpaia. Ja kana poto pirna bakana palina wonti, ja tanali nina todina wonti. ");
INSERT INTO dif_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ja turuni nau milki tjenmana tarana wonti, ngangau nau ketjaketjanani nganana wonti; ja nulu Abraham woritandra najina wonti, ja Lazarus nunkangu ngalpani. ");
INSERT INTO dif_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ja nau karkana wonti ja jatana wonti: «Ngaperiai Abraham, kalumiltjamiltjariau ngakangu, ja Lazarus jinpamai, nau maramoku ngapani multibaterinanto ngana tali malti ngankala; ngangau ngani pirna ketjaketjai nunkanguja turu jaolani.» ");
INSERT INTO dif_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abraham jatana wonti: «Ngundrau ngatamurajai, ngumula jinkani jundru manina wonti tepiwirdi, ja Lazarulu madlentji manina wonti; ja karari nulu ninkida ngankalkana maniai, ja jundru ketjaketjana. ");
INSERT INTO dif_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ja bakana dulkuru pirna parai ngaianingu ja jurangu terti, jeruja tana ninkidandru jertapaterinani jerra pararala, jenia ngandandariai, ja bakana tana ninkindrupara ngandandariai ngaianingu pararala.» ");
INSERT INTO dif_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Nau jatana wonti: «Ngani jinkangu ngatjiai, ngaperiai, jundru ninapara jinpananto ngakani ngaperaia pungaia. ");
INSERT INTO dif_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ngangau ngatata mara wora ngato ngamalkai: tanangu nulupara morlalu kurananto, tana nunkangupini ketjaketjani pirini wokaraiati.» ");
INSERT INTO dif_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham nunkangu jatana wonti: «Tanali Mose ja Propheta worana ngamalkai, tanali tananaka ngaraiatinimai.» ");
INSERT INTO dif_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Nau jatana wonti: «A‐ai, ngaperiai Abraham, narila kulno wokaranani, jeruja tana madlentjandru karitjila nganai.» ");
INSERT INTO dif_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Nau nunkangu jatana wonti: «Tanali Mose ja Propheta worana bulu ngaranani, tanali bakana wata morlalu ngundrala nganai narila terkakanani.»“ ");
INSERT INTO dif_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Nau milini nunkanani jatana wonti: „Jenia ngandandariai wata karkarkana wokarananto; jakajai nunkangu, nunkangundru jenia wokarai. ");
INSERT INTO dif_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Nunkangu morla ngumu nganai, marda wati nunkangu jerkalani kurananto, ja nina panto pirnani jikananto, nulu wata tanangupini wakawaka kulno karkarkananto. ");
INSERT INTO dif_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ngamalkaterianau! Ngatatajeli jinkanali jinkangu madlentji ngankanani, nina kurukurubau; ja nau burkali ngananani, madlentji nunkani worau. ");
INSERT INTO dif_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ja nulu ditji kulnuni pota mara wora ja mandru jinkangu madlentji ngankanani, ja ditji kulnuni pota mara wora ja mandru jinkangu karitjinani ja jatanani: «Ngani burkali nganai;» jundru madlentji nunkani worananto.“ ");
INSERT INTO dif_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ja Apostel wora Kaparani jatana wonti: „Ngaianingu morlalu ngundrana morla jinkiau!“ ");
INSERT INTO dif_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Kapara jatana wonti: „Jura morlalu ngundrana ngamalkanani paua wakani jeribaka, jura nunkangupini tandra pitani jatala nganai: Dukarateriau, ja panto pirnani terkibateriau, ja nauja jurangu pankila nganai. ");
INSERT INTO dif_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Warlenulu jurangundru mili kulno ngamalkanani, nulu mita bakunani kara nganti ngamalkanani kara, nau marundru tikana warai, nunkangu jatanani: Nurujeli wokarau ja kurlini ngamana ngariau? ");
INSERT INTO dif_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Nau wata nunkangu jatala nganai: Ngakangu buka ngankinganimai, ja ngampipateriau, ja mili ngakani ngamamai, ngato matja tajina warai ja tapana warai; ja ngadani bakana jundru tajinanto ja tapananto? ");
INSERT INTO dif_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Nulu nina mili jurakokala nganai, nau jirijiribani jaurani nunkanani pankina warai? A‐ai, ngato ngundrai. ");
INSERT INTO dif_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Jeruja bakana jura, jura pratjana ngankana warai, mina jurangu matja jirijiribana, jatanau: Ngaiani mili baku nganai, ngangau mina ngaiani wilpanto nganai ngankala, ngaiani ngankana warai.“ ");
INSERT INTO dif_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jendranguta Nau Jerusalemia palkana wonti ja Samaria ja Galilaia mitani palkingana wonti. ");
INSERT INTO dif_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ja Nau ngura kulnuni wirinani, nunkangu materi marapratjana gambanto mandurina wonti, tana worita terkana wonti. ");
INSERT INTO dif_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ja tana ngaiala pirnali karkana wonti: „Jesujai, Ngujangujara jinkinietjajai, ngaianingu kalumiltjamiltjariau!“ ");
INSERT INTO dif_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ja Nulu tanana najina, Nau tanangu jatana wonti: „Wapanimai, ja Priesta worangu wondraterianau!“ Ja jendranguta tana wapana, tana kulikiririgana wonti. ");
INSERT INTO dif_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kulno tanangundru najiterina, nau matja tepirina, nau tarpina tikana wonti, ja Goda ngaiala pirnali jurakokana wonti. ");
INSERT INTO dif_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ja nau mudlani woraterina wonti nunkangu tidnani, ja nina jurakokana wonti; ja nau Samaritala nganana wonti. ");
INSERT INTO dif_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ja Jesujeli kalabana wonti ja jatana wonti: „Wata marapratjana kulikiri pantjina warai? Woderi mara wora ja mandru mandru? ");
INSERT INTO dif_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Wata tanana mankamankana, tanana karitjina tikananto Goda jurakokala, windri nulupini kana tulali?“ ");
INSERT INTO dif_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ja Nau nunkangu jatana wonti: „Terkakamai ja wapau; morlalu ngundranali jinkanali jidna tepi ngankana warai.“ ");
INSERT INTO dif_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Pharisaiali nina jakalkana wonti: „Winta Godaia milila wokarai?“ Nulu tanangu kalabana wonti ja jatana wonti: „Godaia milila wata jeruja wokarai, tanali nina ngujamanani. ");
INSERT INTO dif_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Tana bakana wata jatala nganai: Najiau ninkida, najiau jerra; ngangau mai, Godaia milila jurangu terti nganai.“ ");
INSERT INTO dif_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Nau milini nunkanani jatana wonti: „Ditji wokarala nganai, tanangupini jura jertapaterila nganai Kanaia Ngatamuraia ditji kulno najila, ja jura nina wata najila nganai. ");
INSERT INTO dif_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ja tana jurangu jatala nganai: Najiau ninkida, najiau jerra; wata wapanau, bakana wata karipaterianau. ");
INSERT INTO dif_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ngangau worderu talara praitji, nau mintjiai pariwilpaia wondiri kulnundru pariwilpaia wondiri kulnujelu, jeruja bakana Kanaia Ngatamura nganala nganai ditjini nunkanani. ");
INSERT INTO dif_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ngopera Nau pirna ketjaketjananto, ja tanalipini kana ngujali nina worananto. ");
INSERT INTO dif_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ja worderu Noahni ditjini pantjina wonti, jeruja bakana Kanaia Ngatamuraia ditjini nganala nganai. ");
INSERT INTO dif_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Tanali tajina wonti, tapana wonti, noa patana wonti, noa pantjina wonti, jenia ditjielu, Noah bota pirnani wirina wonti; ja kunditji wokarana wonti, ja pratjana nandrana wonti. ");
INSERT INTO dif_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Bakana jeruja, worderu Lotani ditjini pantjina wonti: tanali tajina wonti, tapana wonti, burungankana wonti, jinkimalina wonti, kurana wonti, wotina wonti. ");
INSERT INTO dif_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Nunkangupini ditjini, Lot Sodom ngurandru dunkana kurana, turu ja turukandri pariwilpandru godana wonti, ja pratjana nandrana wonti. ");
INSERT INTO dif_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Jeruja nunkangupini ditjini nganala nganai, nunkangu Kanaia Ngatamura wondraterila nganai. ");
INSERT INTO dif_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Worana nunkangupini ditjini punga mangatandrani nganai, ja poto nunkani pungani parai, wata ngarina tikaiatimai tanana manila; ja worana maruni nganai, bakana wata karitjina tikaiatimai nunkangu, mina nunkangu ngadani nganai. ");
INSERT INTO dif_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ngundranimai Lothani noa! ");
INSERT INTO dif_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Warlenulu wontiai tepi nunkani kulkala, nulu nina tintala nganai; ja warlenulu nina tintai, nulu nina tepi ngamalkala nganai. ");
INSERT INTO dif_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ngani jurangu jatai: Nunkangupini tinkani mandru turarani piri kulnuni parala nganai; kulno Nulia patala nganai, ja kulno Nulia worarala nganai. ");
INSERT INTO dif_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Mandrujeli jelali turara ngankala nganai; nana kulno Nulia patala nganai, ja nana kulno Nulia worarala nganai. ");
INSERT INTO dif_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Mandru maruni nganala nganai; kulno Nulia patala nganai, ja kulno Nulia worarala nganai.“ ");
INSERT INTO dif_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ja tanali kalabana wonti ja nunkangu jatana wonti: „Woderi Kaparajai!“ Nau tanangu jatana wonti: „Woderi pundupundu nganai, naka kirki jurborila nganai.“ ");
INSERT INTO dif_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Nau bakana tanangu jeribaka jaura jatana wonti, jendrangundruja tana milingeru ngatjinanto ja wata walturinanto. ");
INSERT INTO dif_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ja jatana wonti: „Ngura kulnuni kalala kuranietja kulno nganana wonti, nau Godandru wata japala nganana wonti, ja kanandru wata manngarina wonti. ");
INSERT INTO dif_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Mangawaru kulno nunkangupini ngurani nganana wonti, ja nani nunkangu wokarana wonti ja jatana wonti: «Ngana kulkamai ngakani talpalandru.» ");
INSERT INTO dif_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ja nulu juri wata ngantjana wonti. Ngadani nau warawarapaterina wonti: «Ngani bakana Godandru wata japali ngananani, ja wata kana kulnundru manngarinani. ");
INSERT INTO dif_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ngangau nandrupini mangawarujeli ngana jupai, ngato nana kulkala nganai; ngangau nania ngadani wokaraiati ja ngana nandraiati.»“ ");
INSERT INTO dif_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Kapara jatana wonti: „Ngaranau, mina kalala kuranietja tjikatjika jatai! ");
INSERT INTO dif_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Godali kana kalkalkana nunkani wata kulkala nganai, tanali ditjini ja tinkani nunkangu karkai, ja tanangu manju kalumiltjamiltjarila nganai? ");
INSERT INTO dif_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ngani jurangu jatai: Nulu tana nurujeli kulkala nganai. Kanaia Ngatamura wokaranani, Nulu bakana morlalu ngundrana mankamankala nganai?“ ");
INSERT INTO dif_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Nau nina jeribaka jaura palpani jatana wonti, tana munta talku ngundraterina wonti ja kana nguruni gilbarina wonti: ");
INSERT INTO dif_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","„Kana mandru tarana wonti Godaia pungani ngatjila; kulno Pharisaia nganana wonti, ja kulno mardatandra kampanietja. ");
INSERT INTO dif_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Pharisaia terkana wonti ja ngatjina wonti jeruja: «Godajai, ngato jidna jurakokai, ngangau ngani wata kana pilki jeribaka, watawatali maninietja, kana tjikatjika, pinta wokaribanietja, ja bakana wata naupini mardatandra kampanietja jeribaka. ");
INSERT INTO dif_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Pota mandru ngani milja ngamai ditji mara wora ja mandruni, ja marapratjanandru ngato buru kulno jinkiai pratjanandru ngato ngamalkai.» ");
INSERT INTO dif_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ja mardatandra kampanietja worita terkana wonti, nau wata jertapaterina wonti milki tjenmala tarala pariwilpaia, a‐ai, nau munambiri nandraterina wonti ja jatana wonti: «Godajai, ngakangu kanani madlentjani kalumiltjamiltjariau!» ");
INSERT INTO dif_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ngani jurangu jatai: Naupini morla talku ngarina tikana wonti pungaia nunkanaia nunkangu. Ngangau warle pirna ngankateriai, nau waka pantjila nganai, ja warle waka ngankateriai, nau pirna pantjila nganai.“ ");
INSERT INTO dif_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tanali bakana kupa waka nunkangu wokaralkana wonti, nulu tanana karakarananto; ja milieli jenia najina, tanali tauaua daudauana wonti. ");
INSERT INTO dif_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jesujeli tanana karkana wonti ja jatana wonti: „Kupa waka worani patanau ngakangu wokarananto, ja tananaia wata daudauanau; ngangau tanangu Godaia milila nganai. ");
INSERT INTO dif_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Morlalu ngani jurangu jatai: Warle Godaia milila wata patai kupa wakali jeribaka, nau nunkangu wata wirila nganai.“ ");
INSERT INTO dif_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ja kana kaparali nina jakalkana wonti ja jatana wonti: „Ngujangujara jinkinietja ngumujai, mina ngato ngankananto tepi ngurali maratunka manila?“ ");
INSERT INTO dif_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesus nunkangu jatana wonti: „Minandru jundru ngana ngumu dikai? Wata kulno ngumu nganai, windri Goda kulnulu. ");
INSERT INTO dif_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Jirijiribani jaura jidni milkila: Wata pinta wokaribamai, wata narielu nandramai, wata kurieli maniamai, wata jedi jaura morlalu jatamai, ngaperi jinkani ja ngandri jinkani pirna ngundramai.“ ");
INSERT INTO dif_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nau jatana wonti: „Jenia pratjana ngato ngamalkai kupandru.“ ");
INSERT INTO dif_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jesujeli jenia ngarana, Nau nunkangu jatana wonti: „Windri kulno jundru wata ngamalkai: Pratjana mina jundru ngamalkai jinkau kalalaia, ja wangiwangini bakujeli jinkiau, ja jundru poto pirna pariwilpani ngamalkala nganai; ja tikau, ja ngakangu karipateriau!“ ");
INSERT INTO dif_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nulu jenia ngarana, nau ngaurongaurorina wonti, ngangau nau poto pirna nganana wonti. ");
INSERT INTO dif_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesujeli najina, nau ngaurongaurorinani, Nau jatana wonti: „Worderu mati tana kana poto pirna Godaia mililani wirila nganai! ");
INSERT INTO dif_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Morla ngaua nganai, Camuli kulno kuri pikiri wilpani palkingananto kana poto pirnani, nau Godaia mililani wirinanto.“ ");
INSERT INTO dif_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Tanali jenia ngarana jatana wonti: „Warlengarla tepita manila nganai?“ ");
INSERT INTO dif_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Nau jatana wonti: „Mina kanani ngandandariai, ngarla Godata wata ngandandariai.“ ");
INSERT INTO dif_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Petrus jatana wonti: „Mai, ngaiani pratjana woraranala ja jinkangu karipaterinala.“ ");
INSERT INTO dif_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Nau tanangu jatana wonti: „Morlalu ngani jurangu jatai: Wata kulno nganai, nulu matja worarana punga kara, ngaperi ja ngandri kara, neji ngatata kara, noa kara, kupa kara, Godaia mililandru, ");
INSERT INTO dif_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Nulu wata pota marapu morla manila nganai nunkangupini miljarani, ja miljarani nau wokarala nganai tepi ngurali.“ ");
INSERT INTO dif_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ja Nulu mili marapratjana patana wonti ja tanangu jatana wonti: „Mai, ngaiana Jerusalemia tarala nganai, ja jenia pratjana morlalu pantjila nganai, mina Propheta worali dakana wonti Kanaia Ngatamurandru. ");
INSERT INTO dif_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ngangau tanali nina kana koni ngulkujeli jinkila nganai, ja tanali nina ngirkibala nganai ja nunkangu madlentji jatala nganai ja ngaltja worala nganai, ");
INSERT INTO dif_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ja tanali nina wirieli nandrala nganai ja nari ngankala nganai; ja ditjini parkulani Nau jiritjila nganai.“ ");
INSERT INTO dif_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ja tanali jenia bulu ngujamana wonti, ja naupini jaura tanangu purru nganana wonti, ja tanali bulu patana wonti mina tanangu matja jatana. ");
INSERT INTO dif_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jendranguta Nau Jericho karakara wokarana wonti, ja kana butju paltuni ngamana wonti potuni ngatjila. ");
INSERT INTO dif_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nulu matja ngarana, kana wolara wiri nganani, nulu jakalkana wonti mina jenia nganai. ");
INSERT INTO dif_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Tanali nunkangu kaukaubana wonti: „Jesus Nazaretala wiringala wapaia.“ ");
INSERT INTO dif_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ja nau maritjina wonti ja jatana wonti: „Jesujai, Davidani ngatamurajai, ngakangu kalumiltjamiltjariau!“ ");
INSERT INTO dif_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Tana ngopera wiringana nina daudauana wonti nau ngapurinanto; ja nau morla parparali maritjina wonti: „Davidani ngatamurajai, ngakangu kalumiltjamiltjariau!“ ");
INSERT INTO dif_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ja Jesus banbana wonti ja jirijiribana wonti nina nunkangu padakananto. Nau nunkangu matja karakara, Nulu nina jakalkana wonti ");
INSERT INTO dif_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Ja jatana wonti: „Mina jidni ngantjai, ngato jinkangu ngankananto?“ Nau jatana wonti: „Kaparajai, ngato najinanto.“ ");
INSERT INTO dif_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ja Jesus nunkangu jatana wonti: „Najiamai! morlalu ngundranali jinkanali jidna kulkana warai.“ ");
INSERT INTO dif_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ja nurujeli nulu nakaldra najina wonti ja nunkangu karipaterina wonti ja Goda jurakokana wonti. Ja kana wolarali pratjanali jenia najina, Goda jurakokana wonti. ");
INSERT INTO dif_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ja Nau wirina wonti, ja Jericho ngurani palkingana wonti. ");
INSERT INTO dif_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ja mai, kana kulno tala nunkani Zachäus, nau mardatandra kampanietjaia kapara nganana wonti, ja kana poto pirna. ");
INSERT INTO dif_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ja nulu wontina wonti Jesus najila worana nau nganai, ja nau ngandandarina wonti kana wolarandru; ngangau nau kana wordu waka nganana wonti. ");
INSERT INTO dif_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ja nau ngopera mindrina wonti ja tandra pitani katina wonti nina najila; ngangau naka Nau palkingananto. ");
INSERT INTO dif_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ja Nau nunkangupini pirini wokarana, Jesujeli nina najina tarana wonti ja nunkangu jatana wonti: „Zachäusajai, nurujeli ngariau, ngangau ngani karari jinkani pungani ngamananto.“ ");
INSERT INTO dif_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ja nau nurujeli ngarina wonti, ja murlali pirna nina patana wonti. ");
INSERT INTO dif_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ja pratjanali tanali jenia najina, buljubuljurina wonti ja jatana wonti: „Nauja kana madlentji kulnuni wirina warai jerra ngamala.“ ");
INSERT INTO dif_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zachäus karakararina wonti ja Kaparani jatana wonti: „Mai, Kaparajai, poto jura ngakani ngato wangiwangini jinkiai; ja ngani kana kulnundru palpa ngukingukipaterina warai, ngato nunkangu pota mandru mandru morla jinkina tikai.“ ");
INSERT INTO dif_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesus nunkangu jatana wonti: „Karari nunkangupini pungani murla pantjina warai, ngangau nauja bakana Abrahamani ngatamura nganai. ");
INSERT INTO dif_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ngangau Kanaia Ngatamura wokarana wonti wontila ja kulkala, mina tintaterina warai.“ ");
INSERT INTO dif_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Tanali jenia ngarana, Nau jeribaka jaura kulno morla jatana wonti, ngangau Nau Jerusalemingu karakara nganana wonti, ja ngangau tanali ngundrana wonti Godaia milila nurujeli wondraterinanto. ");
INSERT INTO dif_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Nau jatana wonti: „Kana pirna mita woritaia palkana wonti nunkangu milila manila ja nakaldra tikala. ");
INSERT INTO dif_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Nulu mili nunkani marapratjana karkana wonti, ja nulu tanangu mardatandra pirna marapratjana jinkina wonti ja tanangu jatana wonti: «Jinkimalianimai ngani wokaranantulu.» ");
INSERT INTO dif_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Kana wolara nunkani nunkangu kalakalarina wonti, ja nunkangu ngadani mili palpa jinpana wonti ja jatana wonti: «Ngaiani wata ngantjai, naupini ngaianingu kapara nganananto.» ");
INSERT INTO dif_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ja jendranguta nau matja tikana ja milila matja manina, nulu jirijiribana wonti tananapini mili nunkangu karkala, tanangu nulu mardatandra matja jinkina; ngangau nulu ngujamananto warle palpa jinkimalinala. ");
INSERT INTO dif_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ngoperala terkana wonti ja jatana wonti: «Kaparajai, mardatandra pirnali jinkanali mardatandra pirna marapratjana morla ngokana warai.» ");
INSERT INTO dif_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ja nau nunkangu jatana wonti: «Matja, jidni mili ngumu, ngangau jidni talku nganana warai wakawakani, ngurula ngamalkau ngura marapratjanani.» ");
INSERT INTO dif_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Mili mandrula wokarana wonti ja jatana wonti: «Kaparajai, mardatandra pirnali jinkanali mardatandra pirna mara wora morla ngokana warai.» ");
INSERT INTO dif_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Nau bakana nunkangu jatana wonti: «Bakana jidni kapara nganananto ngura mara worani.» ");
INSERT INTO dif_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ja kulno morla wokarana wonti ja jatana wonti: «Kaparajai, najiau mardatandra pirna jinkani, ninapini ngato katieli karana ngamalkana warai; ");
INSERT INTO dif_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ngangau ngani jinkangundru japali nganana warai, ngangau jidni kana ngurunguru nganai; jundru maniai, mina jundru wata kuranala, ja kampai, mina jundru wata jaupanala.» ");
INSERT INTO dif_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Nau nunkangu jatana wonti: «Jinkani manandru ngani jinkangu kalala jatai, jidni mili madlentji! Jidni milkila nganana warai ngani kana ngurunguru nganai, ngato maniai, mina ngato wata kuranala, ja kampai, mina ngato wata jaupanala. ");
INSERT INTO dif_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ja minandru jundru mardatandra ngakani wata mardatandrajinkimalinietjani jinkina warai? Ngangau ngato wokaranani nina kalalanto maninanto.» ");
INSERT INTO dif_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ja tanangu naka terkanani Nau jatana wonti: «Nunkangundru ninaia mardatandra pirna manianau, ja ninaia nunkangu jinkianau, nulia mardatandra pirna marapratjana ngamalkai!» ");
INSERT INTO dif_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ja tana nunkangu jatana wonti: «Kaparajai, nulia mardatandra pirna marapratjana ngamalkai!» ");
INSERT INTO dif_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ngangau ngani jurangu jatai: «Nunkangu, nulu ngamalkai, tanali jinkila nganai; nunkangundru, nulu wata ngamalkai, tanali bakana jenia manila nganai, mina nulu ngamalkai. ");
INSERT INTO dif_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Tanapini talpala ngakani, tanali wata ngantjana warai, ngani tanangu kapara nganananto, ninkida wokaralkanimai, ja ngakangu milkini nandranimai!»“ ");
INSERT INTO dif_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ja Nau jenia matja jatana, Nau ngopera Jerusalemia taringana wonti. ");
INSERT INTO dif_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Jendranguta Nau Bethphage ja Bathania ngurani wokarana, nunkangu mardawonpani, nina tanali dikai maninindri mardawonpa, nulu mili mandru nunkani jinpana wonti, ");
INSERT INTO dif_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ja jatana wonti: „Wapalumai nunkangu ngura wakankari, ja judla jerra wirina, judla donki kuparu workamantraterinani mankamankala nganai, nunkangu wata kana kulno dukaterinala; nina dukaralumai ja tikalkalumai! ");
INSERT INTO dif_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ja kulnujeli judlana jakalkanani: «Minandru judla ninaia dukarai?» Jeruja judla nunkangu jatala nganai: «Kaparali ninaia ngamalkananto».“ ");
INSERT INTO dif_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Pudla mili wulu wapana wonti, ja jeruja mankamankana wonti, worderu Nau pudlangu jatana warai. ");
INSERT INTO dif_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Pudlali nina kuparu dukarana, kapara wora nunkani pudlangu jatana wonti: „Minandru judla ninaia kuparu dukarai?“ ");
INSERT INTO dif_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Pudla jatana wonti: „Kaparali ninaia ngamalkananto.“ ");
INSERT INTO dif_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ja pudlali nina Jesungu tikalkana wonti, ja tanali kati tanani nunkangu kuparani kurana wonti, ja Jesus nankangu kurana tarana wonti. ");
INSERT INTO dif_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Nau palkanani, tanali kati tanani paltuni jaupana wonti. ");
INSERT INTO dif_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nau maninindri mardawonpaia kalikalini karakara wokarana, mili wolarali wonina wonti mankina Goda ngaiala pirnali jurakokala pirnala pratjanandru, tanali matja najina. ");
INSERT INTO dif_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ja tana jatana wonti: „Ngaiani Kapara jurakokai, Nauja wokarai Kaparaia talani! Murla pariwilpani, ja pirnala mirini!“ ");
INSERT INTO dif_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ja Pharisaia palpa kana wolarandru nunkangu jatana wonti: „Ngujangujara jinkinietjajai; milini jinkanani daudauamai!“ ");
INSERT INTO dif_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ja Nulu kalabana wonti ja jatana wonti: „Ngani jurangu jatai: Tanapini ngapu ngananani, marda maritjila nganai.“ ");
INSERT INTO dif_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ja Nau matja karakara wokarana, Nulu ngura najina wonti ja jindrana wonti nunkangundru, ");
INSERT INTO dif_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ja jatana wonti: „Jundru jenia ngujamanani nunkangupini ditjini jinkanani, mina murlani jinkanani nganananto! Ja jenipara jinkangu milkini kurukuru nganala wapaia. ");
INSERT INTO dif_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ngangau ditji wokarala nganai jinkangu, ja talpalali jinkanali wondiri wotina karitjila nganai ja jidna kapikapila nganai, ja paruparu tanali jidna jupala nganai; ");
INSERT INTO dif_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ja tanali jidna ja kupa jinkani dakangandrala nganai, ja tanali wata marda kulno kulnuni parananto worarala nganai; ngangau jundru ngantjani ditji jinkani wata ngujamanala.“ ");
INSERT INTO dif_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ja Nau Godaia pungani wirina wonti, ja Nulu wonina wonti tanana narrala, tana nunkangu jinkimalina wonti ja tanali burungankana wonti, ");
INSERT INTO dif_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ja Nau tanangu jatana wonti: „Dakanala parai: Punga ngakani ngatjini punga nganai, ja jura ninaia watawatali maninietjaia minka ngankanala.“ ");
INSERT INTO dif_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ja Nulu ditji pratjanani ngujangujara jinkina wonti Godaia pungani. Ja Priesta pirnali ja jaura jinkinietjali ja pinarali wontina wonti nina nandrala, ");
INSERT INTO dif_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ja tanali wata mankamankana wonti mina tanali ngankananto; ngangau kana wolarali nina ngantjana wonti ja nina ngarana wonti. ");
INSERT INTO dif_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Jendranguta ditji kulnuni, Nulu kana wolarani Godaia pungani ngujangujara jinkinani ja ngantjani jaura kaukaubanani, Priesta pirna ja jaura jinkinietja pinarani jela terkakana wonti ja nunkangu jatana wonti: ");
INSERT INTO dif_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","„Ngaianingu jatamai, mina ngurulali jundru jenia ngankai, ja warle jinkangu ninapini ngurula jinkina warai?“ ");
INSERT INTO dif_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Nulu kalabana wonti ja tanangu jatana wonti: „Bakana ngato jurana jaura kulno jakalkala nganai, ja jura ngakangu jatananto: ");
INSERT INTO dif_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Johannini multibanila, pariwilpandru kara kanandru kara nganana wonti.“ ");
INSERT INTO dif_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Tana warawarabijiribamalina wonti ja jatana wonti: „Ngaiani jatanani: «Pariwilpandru,» Nauja jatala nganai: Minandru jura nunkangu wata morlalu ngundrana wonti? ");
INSERT INTO dif_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ngaiani jatanani: «Kanandru,» kana wolarali ngaianina mardali diaiati, ngangau tanalia morlalu ngundrai, Johannes Prophata nganana wonti. ");
INSERT INTO dif_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ja tanali kalabana wonti: Ngaiani ko wodajerindru.“ ");
INSERT INTO dif_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ja Jesus tanangu jatana wonti: „Bakana ngani jurangu wata jatai, mina ngurulali ngato jenia ngankai.“ ");
INSERT INTO dif_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Nulu wonina wonti kana wolarani ninapini jeribaka jaura jatala: „Kana kulnujeli wain maru kurana wonti ja nina marunajinajibanietja worangu worarana wonti ja palkana wonti ditji marapu. ");
INSERT INTO dif_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ditji talkuni nulu marunajinajibanietja worangu mili kulno jinpana wonti, tanali nunkangu wain maruja tandra jinkinanto; ja marunajinajibanietja worali nina nandrana wonti, ja nina kala jinpana wonti. ");
INSERT INTO dif_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ja nakaldra nulu mili kulno jinpana wonti; bakana ninapini tanali nandrana wonti, ja nina ngirkibana wonti, ja nina kala jinpana wonti. ");
INSERT INTO dif_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ja nulu mili kulno morla jinpana wonti; tanali bakana nunkangu tapa jinkina wonti, ja nina palarani worarana wonti. ");
INSERT INTO dif_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Wain maruja kapara jatana wonti: «Mina ngato ngankananto? Ngato ngatamura ngantjalu ngakani jinpala nganai; tanali nina najinani, tana nintali warawararila nganai kara.» ");
INSERT INTO dif_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Wain maru najinajibanietja worali nina najina wonti, tana ngankamalina wonti ja jatana wonti: «Naupini maratunkaia; ngaiani nina nari nandrananto maratunka ngaianani nganananto.» ");
INSERT INTO dif_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ja tanali nina wain marundru palarani worarana wonti, ja nina nari ngankana wonti. Mina wain maruja kaparali tanangu ngankala nganai? ");
INSERT INTO dif_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nau wokarala nganai, ja tananapini marunajinajibanietja worana nandrala nganai.“ Tanali jenia ngarana, tana tatakana wonti: „A‐ai.“ ");
INSERT INTO dif_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Nulu tanana nguru talpana najina wonti ja jatana wonti: „Mina jenia nganai, matja dakanala parai: Naupini marda, nina wotinietjali worana wonti, nau marda buru pantjina wonti? ");
INSERT INTO dif_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Worana nunkangupini mardani puriai, nina nulu nankanankala nganai; worangu nau marda purila nganai, ninapini nulu turara ngankala nganai.“ ");
INSERT INTO dif_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ja Priesta pirnali ja jaura jinkinietjali wontina wonti nunkangupini ditjini mara nunkangu kurala, windri tana kana wolarandru japali nganana wonti; ngangau tanali ngujamana wonti, Nau tanangu ninapini jeribaka jaura jatana warai. ");
INSERT INTO dif_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ja tanali nina matja najinajibana, tanali kurukuru najinajibanietja jinpana wonti, tanali jeljujeljujeli talku wondraterina wonti, tanali nina jaurali patananto, ja nina kana kaparani ja najinajibanietjaia ngurulani ngulkujeli jinkinanto. ");
INSERT INTO dif_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ja tanali nina jekibana wonti ja jatana wonti: „Ngujangujara jinkinietjajai, ngaiani milkila, jundru talku kaukaubai, ja ngujangujara jinkiai, ja manubaku nganai, ja morlalu Godaia paltundru ngujangujara jinkiai; ");
INSERT INTO dif_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ngaianingu talku nganai, ngaiani mitaia kaparani kalala jinkinani kara, pani kara?“ ");
INSERT INTO dif_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Nulu tanani jeljujelju ngujamana wonti, ja Nau tanangu jatana wonti: „Minandru jura ngana wontjai? ");
INSERT INTO dif_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Ngakangu kalalaia mardatandra kulno wondralkamai. Waninunkani mudla ja jaura dirkalani nulia ngamalkai?“ Tanali kalabana wonti ja jatana wonti: „Mitaia kaparaia.“ ");
INSERT INTO dif_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Nau tanangu jatana wonti: „Jinkianau kaparaia poto kaparani ja Godaia poto Godani!“ ");
INSERT INTO dif_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ja tanali ngandandarina wonti nina jaura kulnujeli patala kana wolarandru; ja nunkani kalabani jaurandru tana ngaruparana wonti ja ngapurina wonti. ");
INSERT INTO dif_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadducaia palpa nunkangu karakararina wonti, tana jatai: „Narila wata morla jiritjila nganai,“ ja nina jakalkana wonti ja jatana wonti: ");
INSERT INTO dif_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","„Ngujangujara jinkinietjajai, Mosili ngaianingu dakana wonti, kana kulnuja nejieli, nulu noa ngamalkana warai, kupa pani palinani, ngatatajeli nunkanali nana widla patananto ja nejini nunkanani ngatamura jiritjibananto. ");
INSERT INTO dif_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Neji mara mara wora ja mandru nganana wonti; ja ngoperalali noa patana wonti ja kupa pani palina wonti; ");
INSERT INTO dif_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ja mandrulali nana widla noa patana wonti, nau bakana kupa pani palina wonti. ");
INSERT INTO dif_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ja parkulali nana patana monti, nunkangu jeribaka bakana tanali mara wora ja mandrujeli, ja tanali wata kupa worarana wonti ja palina wonti. ");
INSERT INTO dif_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Pratjanani ngadani bakana widla palina wonti. ");
INSERT INTO dif_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Terkakani ditjini, waninunkani noa tanangundru nani nganala nganai? ngangau mara wora ja mandrujeli nana noa ngamalkana wonti.“ ");
INSERT INTO dif_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ja Jesujeli kalabana wonti ja tanangu jatana wonti: „Nunkanipini mitaia kupali noa patai ja noa pantjiai; ");
INSERT INTO dif_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Tana talku nganai jenipara milila ja narindru jiritjina manila, tanali wata noa patai ja noa pantjiai. ");
INSERT INTO dif_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Tana ngandandarila nganai palila, ngangau tana angelani jeribaka nganai ja Godaia kupa, ngangau tana narindru jiritjini kupa nganai. ");
INSERT INTO dif_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Narila jiritjila nganai, jenia bakana Mosili dilka nindrini wondrana wonti, worderu nulu Kaparani dikai: «Goda Abrahamani ja Goda Isaakani ja Goda Jakobani.» ");
INSERT INTO dif_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Goda wata naria Goda nganai, a‐ai, tepia; ngangau nunkangu tana pratjana tepi.“ ");
INSERT INTO dif_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Jaura jinkinietja palpali kalabana wonti ja jatana wonti: „Ngujangujara jinkinietjajai, jundru ngumu kaukaubana warai.“ ");
INSERT INTO dif_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Tanali wata morla wontjana wonti nina minakulno jakalkala. ");
INSERT INTO dif_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Nau tanangu jatana wonti: „Worderu tana jatai, Christus Davidani ngatamura nganai? ");
INSERT INTO dif_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ja David munta wina jaurani jatai: «Kapara jatanala Kaparani ngakanani: Ngakangu ngunarani ngamana ngariau, ");
INSERT INTO dif_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Ngato talpala jinkani jinkangu tidnani kuranantulu, tidnaparani piri jeribaka.» ");
INSERT INTO dif_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Davidali nina Kapara dikanani, worderu Nau ngatamura nunkani nganai?“ ");
INSERT INTO dif_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Kana wolarali jenia ngaranani, Nau milini nunkanani jatana wonti: ");
INSERT INTO dif_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","„Ngamalkaterianau jaura jinkinietjandru, tanali ngantjai kati wirdieli wirarila, ja jaura murlali jinkimalini pirini, ja ngamani piri ngopera jaura pungani, ja ngamani piri ngopera buka pirnani; ");
INSERT INTO dif_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Tanali mangawaruja punga tajiai ja ngatjina wirdieli wondralkateriai. Tanalipini kalala morla pirna manila nganai.“ ");
INSERT INTO dif_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Nulu najina tarana wonti, ja kana poto pirna najina wonti, worderu tanali poto tanani mardatandra kokuni kurana wonti. ");
INSERT INTO dif_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Nulu bakana mangawuru wangiwangi kulno najina wonti, nandru mardatandra wakawaka mandru kurana wonti ");
INSERT INTO dif_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ja jatana wonti: „Morlalu ngani jurangu jatai, nandruja mangawaru wangiwangieli morla kurana wonti pratjanani. ");
INSERT INTO dif_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ngangau tanalipini pratjanali tanani poto manamirindru Godaia potuni kurana warai; nandruja nankani ngaljengaljendru pratjana, mina nandruja ngamalkana warai, nankani poto pratjana, kurana warai.“ ");
INSERT INTO dif_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ja palpa Godaia pungandru jatanani, worderu nauja marda ngumujeli ja poto ngumujeli tjirkatjirkaraterina, Nau jatana wonti: ");
INSERT INTO dif_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","„Jenia mina jura najiai — ditji wokarala nganai, tanangupini wata marda kulno kulnuni parala nganai, ninaia tanali wata dukarala nganai.“ ");
INSERT INTO dif_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Tanali nina jakalkana wonti ja jatana wonti: „Ngujangujara jinkinietjajai, winta jenia pantjila nganai? Ja mina nauja malka nganai jenia pantjinanto?“ ");
INSERT INTO dif_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Nau jatana wonti: „Ngamalkaterianau, tanali jurana karkarkaiati; ngangau marapu talani ngakanani wokarala nganai ja jatala nganai: Ngani Naujamata; ja: Miljaru matja karakararina warai. Tanangu wata wapantianau! ");
INSERT INTO dif_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Jura tirimalinandru ja tiripatijiritjinandru ngaranani, wata japali ngananau, ngangau jenia ngopera pantjinanto; ju mudani wata nurujeli wokarai. ");
INSERT INTO dif_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ngadani Nau tanangu jatana wonti: Kana wolara tiriterkakala nganai kana wolarani, ja mitaia kaparaia milila mitaia kaparaia mililani, ");
INSERT INTO dif_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ja mita wiltjiwiltjina pirna nganala nganai mankamanka, ja maua pirna ja muntja pirna pilki ja pilki paruparu nganala nganai, ja japa pirna ja malka pirna pariwilpandru pantjila nganai. ");
INSERT INTO dif_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Tanangupini pratjanani ngopera tanali jurangu mara kurala nganai ja jurangu tirikaripaterila nganai; tanali jurana jaura pungani ja kanjangarini ngulkujeli jinkila nganai, ja mitaia kaparani ja najinajibanietjani wapalkala nganai ngakani talandru. ");
INSERT INTO dif_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Jenia tanali jurangu ngankala nganai malka nganananto. ");
INSERT INTO dif_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Jurani ngarali jenia patanau, jura wata manujeli ngundrananto mina jura kalabananto. ");
INSERT INTO dif_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ngangau ngato jurangu mana ja kirila jinkila nganai, nunkangu jurani talpalali pratjanali wata tjakakala nganai, ja wata ngandrawalkala nganai. ");
INSERT INTO dif_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Jurana ngaperali ja ngandrieli ja neji marali ja kana kamanelieli ja kamanelieli jurana ngulkujeli jinkila nganai, ja palpa jurangundru tanali nari ngankala nganai. ");
INSERT INTO dif_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ja pratjana jurana kalakalarila ngunai ngakani talandru. ");
INSERT INTO dif_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ja para kulno jurani mangatandrani jura wata tintala nganai. ");
INSERT INTO dif_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Jura ngurunguru ngananani, jura mungara jurani kulkala nganai. ");
INSERT INTO dif_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Jura najinani tirimalinaia kana wolarali Jerusalem matja kapikapina, ngadani ngujamanau, ngurawalpa nunkani wokarana warai. ");
INSERT INTO dif_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ngadani tana Judaia mitani ngananani mardawonpaia japa mindrinanto, ja tana ngura pirnani terti ngananani puntinanto, ja tana ngura wakani ngananani wata nunkangu wirinanto. ");
INSERT INTO dif_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ngangau kalala ditji tanapini nganai, pratjana morlalu pantjinanto mina dakanala parai. ");
INSERT INTO dif_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Jakajai tanangu mandrantjuni ja ngama jinkinietjani tanangupini ditjtni! ngangau ketjaketjana pirna mitani nganala nganai ja tiri tanangupini kana wolarani. ");
INSERT INTO dif_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ja tana kalti tirieli palila nganai, ja tanali tanana dupudupu kana wolara pratjanani wapalkala nganai; ja kana ko wolarali Jerusalem tidnali dakala nganai kana koja ditji mudanantulu. ");
INSERT INTO dif_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ja malka pantjila nganai ditji pirnani ja pirani ja ditji wakawakani; ja mitani kana japali nganala nganai ja tana japali ngarrala nganai panto pirna mandikila tutunganani; ");
INSERT INTO dif_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ja kana japandru waltowalto pirna pantjila nganai, ngangau tana japali kalkai mina wolja mita maruni wokarananto; ngangau bakana pariwilpaia ngurula wiltjiwiltjila nganai. ");
INSERT INTO dif_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ja ngadani tanali Kanaia Ngatamura najila nganai talara palkujeli wokaranani ngurunguru ja pirna. ");
INSERT INTO dif_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ja jenia woninani, terkakanau ja mangatandra miririanau, ngangau kulkani jurani karakara wokarai. ");
INSERT INTO dif_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ja Nau jeribaka jaura tanangu jatana wonti: Najianau tandra nindri ja nindri warupoto. ");
INSERT INTO dif_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Tana matja kuljakuljarina, jura najiai ja muntali ngujamai, woldrakanja karakara nganai. ");
INSERT INTO dif_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Jeruja bakana jura najinani jenia matja pantjina, ngujamanau: Godaia milila karakara nganai. ");
INSERT INTO dif_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Morlalu ngani jurangu jatai: Naupini nguja wata mudala nganai jenia pratjana pantjinantulu. ");
INSERT INTO dif_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Pariwilpa ja mita maru mudala nganai, ja jaura ngakani wata mudala nganai. ");
INSERT INTO dif_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ngamalkaterianau, jura wata ngara nankaterinanto mirantjatieli tajina ja parawarala tapana ja tepindru manujeli ngundraterina, ja naupini ditji jurangu nurujeli wokaraiati. ");
INSERT INTO dif_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ngangau minti jeribaka nau wokarala nganai kanani warupotuni, tana mita maruni ngamai. ");
INSERT INTO dif_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ngangau milingeru tepi ngamanau, ja ditjini pratjanani ngatjianimai, jura ngurunguru pantjinanto nunkangundru pratjanandru, mina pantjila nganai, japa mindrila, ja Kanaia Ngatamurani terkala.“");
INSERT INTO dif_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ditjini Nulu Godaia pungani ngujangujara jinkina wonti, jr tinkani Nau dunkana wonti mukaturarala nunkangu marda wonpani, nina tanali dikai maninindri mardawonpa. ");
INSERT INTO dif_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ja kana wolara dankudankubana nunkangu wokarana wonti Godaia pungani, nina ngarala. ");
INSERT INTO dif_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Pulkurutjeribani ditji pirna, nina tanali dikai Passa, karakararina wonti. ");
INSERT INTO dif_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Priesta pirnali ja jaura jinkinietjali wontina wonti, worderu tanali nina nari ngankananto, ngangau tana kana wolarandru japali nganana wonti. ");
INSERT INTO dif_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Satan wirina wonti Judangu, nau tala Ischariot, nau marapratjana ja mandrundru kulno nganana wonti. ");
INSERT INTO dif_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ja nau wapana wonti ja Priesta pirnani ja jirijiribanietjani ngankamalina wonti, worderu nulu nina tanangu wontawontananto. ");
INSERT INTO dif_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ja tana mankina wonti; ja tana kulnukulnuni nganana wonti nunkangu mardatandra jinkila. ");
INSERT INTO dif_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ja nulu jenia talpadakana wonti, ja ditji talku wontina wonti, nina tanangu kana wolara panini ngulkujeli jinkila. ");
INSERT INTO dif_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Pulkurutjeribani ditji pirna kantji wokarana wonti, nunkangupini tanali Passa kuparu nandrananto. ");
INSERT INTO dif_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ja Nulu Petrus ja Johannes jinpana wonti ja jatana wonti: „Wapalumai ja Passa kupara ngaianani ngankingalumai, ngaiana nina tajinanto.“ ");
INSERT INTO dif_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Pudla nunkangu jatana wonti: „Wodaninkinaia jidni jertapateriai ngali nina ngankingananto.“ ");
INSERT INTO dif_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Nau pudlangu jatana wonti: „Mai, judla ngurani wirinani, kana kulno judlangu mandurila nganai, nulu ngapakoko mandrai; nunkangu karipaterialumai pungaia, woderi nau wiriai, ");
INSERT INTO dif_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ja punga ngamalkanietjani jatalumai: Ngujangujara jinkinietja jinkangu jatai: Woderi tajini piri nganai, nunkangu ngato Passa kuparu ngakani milintali tajinanto? ");
INSERT INTO dif_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ja nulu judlangu tajini piri pirna, matja ngankingana, wondrala nganai, naka nina ngankingalumai.“ ");
INSERT INTO dif_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Pudla matja wapana, pudlali jeruja mankamankana wonti, worderu Nau pudlangu jatana warai: ja pudlali Passa kuparu ngankingana wonti. ");
INSERT INTO dif_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ja ditji matja wokarana, Nau ngamana ngarina wonti, ja Apostel marapratjana ja mandru nunkangunto. ");
INSERT INTO dif_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ja Nau tanangu jatana wonti: „Ngani wolkareli ja ngalkujeli nganana warai ninapini Passa kuparu jurangu jelali tajila ngakani ketjaketjanani ngopera. ");
INSERT INTO dif_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ngangau ngani jurangu jatai: Ngato ninaia wata morla tajila nganai, jenia Godaia mililani morlalu pantjinantulu.“ ");
INSERT INTO dif_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ja Nulu koko patana wonti ja jurakokana wonti ja Nau jatana wonti: „Ninapini patanau ja jura muntali puntibijiribamalianau. ");
INSERT INTO dif_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ngangau ngani jurangu jatai: Ngato wata morla waina nindri tandrandru tapala nganai Godaia milila wokaranantulu.“ ");
INSERT INTO dif_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ja Nulu buka patana wonti ja jurakokana wonti ja nina wokaribana wonti ja tanangu jinkina wonti ja jatana wonti: „Naupini ngani palku nganai, ninaia ngani jurangu jinkiteriai; jeruja ngankanimai ngakangu ngundrala!“ ");
INSERT INTO dif_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Jeruja bakana koko tajinani ngadani, ja jatana wonti: „Naupini koko Testamenta marra nganai ngakani kumarani, ninaia ngani jurangu nangateriai.“ ");
INSERT INTO dif_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ja mai, ngakani wontawontanietjaia mara ngakangunto kurlini nganai. ");
INSERT INTO dif_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ja Kanaia Ngatamura wapai worderu morlalu kurana wonti; ja jakajai nunkangupara kanani, nulia ninaia wontawontala nganai. ");
INSERT INTO dif_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ja tanali wonina wonti jakalkijiribamalila, warlenulu tanangundru nganai, nulia jenia ngankala nganai. ");
INSERT INTO dif_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Tana bakana jatamalina wonti jendrangundruja, worananau morla pirna nganai tanangundru. ");
INSERT INTO dif_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Nau tanangu jatana wonti: „Kana wolaraia kaparali tanangu jirijiribai, ja ngurula ngamalkanietja tanani tanali dikai: «kapara ngumu.» ");
INSERT INTO dif_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Jura wata jeruja, a‐ai, worananau morla pirna jurangundru nganai, wakani jeribaka pantjinanto; ja kapara milini jeribaka. ");
INSERT INTO dif_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ngangau worananau morla pirna nganai, nau kurlini ngamai kara, nau mili nganai kara? Wata jeruja nganai, nau kurlini ngamai? Ngani jurangu terti nganai mili jeribaka. ");
INSERT INTO dif_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Jura tanaia nganai, tanaia ngakangunto wonki nganana warai ngakani wontjanani; ");
INSERT INTO dif_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ja ngato jurangu milila jinkiai, worderu Ngaperali ngakanali matja jinkina; ngangau jura tajinanto ja tapananto ngakani kurlini mililani ngakanani. ");
INSERT INTO dif_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ja jura kaparaia pirini ngamala nganai Israelani kapara marapratjana ja mandruni kalala kurala.“ ");
INSERT INTO dif_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Kapara jatana wonti: „Simoniai, Simoniai, mai, Satanali wontjana warai jurana buka tandra jeribaka tarauala. ");
INSERT INTO dif_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ngani jinkangundru ngatjina warai, morlalu ngundrana jinkani wata mudananto; ja jidni ngadani matja madlentjandru karitjina, ngatata jinkani ngurunguru ngankau!“ ");
INSERT INTO dif_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Nau nunkangu jatana wonti: „Kaparajai, ngani matja ngankaterina, jinkangunto bakana kanjangaria ja naria wapala.“ ");
INSERT INTO dif_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Nau jatana wonti: „Ngani jinkangu jatai Petrujai: Karari paia ngaperi wata jatala nganai, windrila jundru ngana pota parkulu jedieli worarala nganai ngana ngujamala.“ ");
INSERT INTO dif_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ja Nau tanangu jatana wonti: „Ngato jurana marakala jinpanala, billi ja pailtji ja tidnaputa pani, jura palpa wata ngamalkanala?“ Tana jatana wonti: „Pani.“ ");
INSERT INTO dif_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Nau tanangu jatana wonti: „Karari, warle billi ngamalkai, ninaia maniatimai, jeruja bakana pailtji; ja warlenulu wata ngamalkai, kati nunkani kalalaia jinkiatimai ja mardakirra burungankaiatimai. ");
INSERT INTO dif_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ngangau ngani jurangu jatai: Bakana jenia, mina ngakagundru morla dakanala parai, morlalu pantjinanto; jenia: Tanali nina madlentji ngankanietjani terti kurana wonti; ngangau mina ngakangundru dakanala parai, matja mudana.“ ");
INSERT INTO dif_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Tana jatana wonti: „Kaparajai, najiau ninkida mardakirra mandru parai!“ Nau tanangu jatana wonti: „Matja.“ ");
INSERT INTO dif_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ja Nau dunkana wonti ja maninindri mardawonpaia wapana wonti, worderu Nulu milingeru ngankana wonti; ja nunkangu bakana mili nunkani karipaterina wonti. ");
INSERT INTO dif_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Nau pirini matja wokarana, Nau tanangu jatana wonti: „Ngatjianimai jura wontjanilani wiriati.“ ");
INSERT INTO dif_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ja Nau tanangundru kulnulu tjiringana wonti, diani marda worita jeribaka, ja pantjaterkana ngarina wonti ja ngatjina wonti ja jatana wonti: ");
INSERT INTO dif_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","„Ngaperiai, jidni jertapaterinani ninapini koko ngakangu wirilkingala; wata jertapaterina ngakani, a‐ai, jinkani pantjinanto.“ ");
INSERT INTO dif_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Angela kulno pariwilpandru nunkangu wondraterina wonti nina ngurunguru ngankala. ");
INSERT INTO dif_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ja Nau naritirimalini wirinani, Nau morla parparali ngatjina wonti; ja kangu nunkani kumari jeribaka ngakana wonti. ");
INSERT INTO dif_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ja Nau ngatjinandru matja terkana tarana, Nau milini nunkanani wokarana wonti, ja Nulu tanana ngaurongaurojeli mukaturaranani mankamankana wonti, ");
INSERT INTO dif_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ja tanangu jatana wonti: „Minandru jura mukaturarai? Terkakanau ja ngatjianau, jura wontjanilani wiriati.“ ");
INSERT INTO dif_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Nau jenia jatanani, mai, kana wolara, ja Judas marapratjana ja mandrundru kulno, tanangu ngopera wapana wonti, ja Jesungu karakararina wonti nina manatapala. ");
INSERT INTO dif_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesus nunkangu jatana wonti: „Judajai, manatapanali jundru Kanaia Ngatamura wontawontai?“ ");
INSERT INTO dif_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Tanali nunkangunto matja najina, mina pantjiati, tana nunkangu jatana wonti: „Kaparajai, ngaiani mardakirrali nandrananto?“ ");
INSERT INTO dif_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ja kulnujelit anangundru Priesta pirnaia mili nandrana wonti, ja nina talpa ngunari wokaribana wonti. ");
INSERT INTO dif_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesujeli kalabana wonti ja jatana wonti: „Karari mudau!“ Ja Nulu nina talpa karakarana wonti ja nina tepi ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jesus jatana wonti Priesta pirnani ja Godaia pungaia kaparani ja pinarani, tana nunkangu matja wokarana: „Watawatali maninietjani jeribaka jura dunkana warai mardakirrali ja pitali? ");
INSERT INTO dif_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ngani jurangunto Godaia pungani nganana warai, jura mara jurani wata ngakangu ngutana warai. Ja naupini jurani ditji nganai ja ngalpuruja ngurula.“ ");
INSERT INTO dif_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tanali nina patana wonti ja nina wapalkana wonti ja nina Priesta pirnaia pungani wirilkana wonti. Ja Petrus woritandru wapantina wonti. ");
INSERT INTO dif_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Tanali pirini terti matja turu miribana ja ngamana ngarina, bakana Petrus tanangu terti ngamana ngarina wonti. ");
INSERT INTO dif_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Widla milieli nina turuni ngamanani najina, ja nina ngurutalpana najina, nani jatana wonti: „Bakana naupini nunkangunto nganana warai!“ ");
INSERT INTO dif_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Nau jedina wonti ja jatana wonti: „Widlajai, ngato nina wata ngujamai.“ ");
INSERT INTO dif_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ja wolja nina kulnujeli najina wonti ja jatana wonti: „Bakana jidni tanangundru kulno nganai!“ Petrus jatana wonti: „Wata ngani.“ ");
INSERT INTO dif_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ja ditji kulno matja mudana, kulnujeli morlalu kurana wonti ja jatana wonti: „Morlalu, bakana naupara nunkangunto nganana warai, ngangau nauja Galilaiala nganai!“ ");
INSERT INTO dif_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Petrus jatana wonti: „Kanajai! Ngani ko mina jidni jatai.“ Ja nurujeli, nau jeruja jatanani, paia ngaperi jatana wonti. ");
INSERT INTO dif_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ja Kaparali najina karitjina wonti ja Petrus najina pararana wonti. Ja Petrulu Kaparaia jaura ngundrana wonti, worderu Nau nunkangu jatala wiri: „Morla ngopera, windrila paia ngaperi jatananto, jundru ngana pota parkulu jedieli worarala nganai.“ ");
INSERT INTO dif_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ja Petrus palaraia dunkana wonti ja burkali pirna jindrana wonti. ");
INSERT INTO dif_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ja kanali, tanali Jesus patana wonti, nina ngirkibana wonti ja nandrana wonti. ");
INSERT INTO dif_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ja tanali nina matja walpadakana, tanali nina mudla nandrana wonti ja nina jakalkana wonti ja jatana wonti: „Ngaianingu morlalu jatamai, warlenulu jidna nandrana warai?“ ");
INSERT INTO dif_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ja ngirkibani jaura marapu morla tana nunkangu jatana wonti. ");
INSERT INTO dif_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ja matja ditjirina, kana wolaraia pinaru pratjana ja Priesta pirna ja bakana jaura jinkinietja jurborina wonti, ja tanali nina kaparani tananani wapalkana wonti, ");
INSERT INTO dif_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ja jatana wonti: „Jidni Christus nganai? Ngaianingu jatau!“ Nau tanangu jatana wonti: „Ngani jurangu jatanani, jura wata morlalu ngundranani; ");
INSERT INTO dif_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ngato jurana jakalkanani, jura ngakangu wata kalabanani, ngana kurakanani kara. ");
INSERT INTO dif_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kararindru Kanaia Ngatamura Godaia ngurulaia ngunarani ngamala nganai.“ ");
INSERT INTO dif_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Tana pratjana jatana wonti: „Ngarla jidni Godaia Ngatamura?“ Nau tanangu jatana wonti: „Jura jenia jatai, ngangau ngani Nauja.“ ");
INSERT INTO dif_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Tana jatana wonti: „Mina jaura morlalu ngaiana morla ngamalkananto? Ngangau ngaiana muntali jenia nunkani manandru ngarana warai.“ ");
INSERT INTO dif_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ja kana wolara tanani terkakana wonti ja nina Pilatungu wapalkana wonti. ");
INSERT INTO dif_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Tanali wonina wonti nunkangu ngulkuterkala ja jatana wonti: „Ninapini ngaiani mankamankana warai, Nulia kana wolara ngaianini tjautjau ngankai ja daudauai mitaia kaparani kalala jinkila ja jatai, Nauja Christus Kapara nganai.“ ");
INSERT INTO dif_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilatulu nina jakalkana wonti ja jatana wonti: „Jidni Juda kanaia Kapara nganai?“ Nulu nunkangu kalabana wonti ja jatana wonti: „Jidni matja jatai.“ ");
INSERT INTO dif_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilatus Priesta pirnani ja kana wolarani jatana wonti: „Ngato madlentji pani nunkangupini kanani mankamankai.“ ");
INSERT INTO dif_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ja tana jadijadibana wonti ja jatana wonti: „Nulia kana wolara patijiritjibai ja Judaia mitani pratjanani ngujangujara jinkiai, ja Nulia Galilaiandru wonina wonti ninkidanilu.“ ");
INSERT INTO dif_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilatulu Galilaia ngarana, nulu jakalkana wonti: „Nauja kana Galilaiala?“ ");
INSERT INTO dif_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ja nulu matja ngujamana, Nau Herodini ngurulandru nganai, nulu nina Herodingu jinpana wonti, naupini nunkangupini ditjini bakana Jerusalemingu nganana wonti. ");
INSERT INTO dif_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodilu Jesus najina, nau pirna mankina wonti; ngangau nau ditji marapuni wolkareli nganana wonti nina najila, ngangau nulu marapu nunkangundru ngarana wonti, ja nau kalkaterina wonti malka kulno nunkangundru najila. ");
INSERT INTO dif_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nulu nina jaura marapujeli jakalkana wonti, ja Nulu nunkangu panila kalabana wonti. ");
INSERT INTO dif_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Priesta pirna ja jaura jinkinietja naka terkana wonti, tana nunkangu pirna ngulkuterkana wonti. ");
INSERT INTO dif_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodili ja milieli nunkanali nina tilpana wonti ja ngirkibana wonti, ja nulu nina kati waru widmana wonti, ja nina nakaldra Pilatungu jinpana tikana wonti. ");
INSERT INTO dif_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Pilatus ja Herodes nunkangupini ditjini kamaneli pantjina wonti; ngangau pudla ngopera kalakalarilkijiribamalina wonti. ");
INSERT INTO dif_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilatulu Priesta pirna ja kana kapara ja kana wolara matja mapana, nau tanangu jatana wonti: ");
INSERT INTO dif_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","„Jura ninapini kana ngakangu wapalkana warai kulnuni jeribaka, nulu kana wolara karkarkai; ja mai, ngato jurangu mudlani ninaia wontjana warai, ja ngato nunkangupini kanani madlentji pani mankamankana warai, pratjanani jura nunkangundru ngulkuterkai. ");
INSERT INTO dif_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Bakana Herodili pani; ngangau ngato jurana nunkangu jinpana warai, ja mai, wata madlentji Nulia ngankana warai, jendrali Nauja palinanto. ");
INSERT INTO dif_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ngato ninaia nandrala nganai ja kurakala nganai.“ ");
INSERT INTO dif_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ngangau nulu tanangu ditji pirnani kulno kurakananto. ");
INSERT INTO dif_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Tana pratjana maritjina wonti ja jatana wonti: „Ninapini worau, ja ngaianingu Barabbas kurakau!“ ");
INSERT INTO dif_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Naupini tiripatijiritjinandru ngurani matja pantjina, ja nari nandranandru kanjangarini ngamana wonti. ");
INSERT INTO dif_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Nakaldra Pilatulu tanangu jaura kaukaubana wonti, ngangau nau jertapaterina wonti Jesus kurakala. ");
INSERT INTO dif_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Tana maritjina wonti ja jatana wonti: „Kunarkuni katibamai, kunarkuni ninaia katibamai!“ ");
INSERT INTO dif_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Nau pota parkulula tanangu jatana wonti: „Mina madlentji Nulupini ngankanala? Ngato wata madlentji nunkangu mankamankana warai jendrali Nauja palinanto; ngato ninaia nandrala nganai ja kurakala nganai.“ ");
INSERT INTO dif_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Tanali nina ngaiala pirnali winpana wonti ja ngatjina wonti, Nauja kunarkuni parananto. Ja tanani ja Priesta pirnaia ngaialali kalalu ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilatulu morlalu kurana wonti tanani ngatjina pantjinanto. ");
INSERT INTO dif_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Nulu tanangu ninapini kurakana wonti, nau tiripatijiritjinandru ja nari ngankanandru kanjangarini ngamana wonti. Ja nulu Jesus tanani jertapaterinani jinkina wonti. ");
INSERT INTO dif_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ja tanali nina wapalkana, tanali Simon, Kyrenala kulno, watawatali patana wonti, nau marundru tikanani, ja nunkangu kunarku kurana wonti, nulu nina Jesungu ngadani waltananto. ");
INSERT INTO dif_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Bakana kana wolara ja widla marapu nunkangu karipaterina wonti, tana nunkangundru ngaurongauro nganana wonti ja jindrana wonti. ");
INSERT INTO dif_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesus tanangu jatana karitjina wonti: „Jura Jerusalemini ngatamura worai, wata ngakangundru jindranau, a‐ai, jurangundru munta ja jurani kupandru jindranau! ");
INSERT INTO dif_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ngangau mai, ditji wokarala nganai, tanangupini tana jatala nganai: Murlali pirna tana ngameri, ja tana palku wata kantjirina warai, ja tana ngama, tanali wata tapananto jinkina warai! ");
INSERT INTO dif_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ngadani tanali wonila nganai mardawonpani jatala: Ngaianingu woraterianau! ja wonpani: Ngaianina walpadakanau; ");
INSERT INTO dif_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ngangau tanali jenia pita tjankani ngankanani, mina mujani pantjinanto?“ ");
INSERT INTO dif_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Tanali bakana madlentji ngankanietja mandru morla wapalkana wonti, pudlana nunkangunto nari ngankala. ");
INSERT INTO dif_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ja tana nunkangupini pirini, tala nunkani „mangatandra piri“ matja wokarana, tanali nina naka kunarkuni katibana wonti, ja madlentji ngankanietja kulno ngunarani ja kulno worangantjuni. ");
INSERT INTO dif_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesus jatana wonti: „Ngaperiai, tanangu woramai, ngangau tanali mangapunkujeli jenia ngankai.“ Tanali kati nunkani puntibana wonti wontjani malkali. ");
INSERT INTO dif_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ja kana wolara terkana wonti najila. Tanangunto bakana kana kaparali ngirkibana wonti ja jatana wonti: „Nguru Nulia kulkanala; Nauja munta kulkateriatimai, Nauja Christus, Godaia kalkalkani ngananani!“ ");
INSERT INTO dif_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Nina bakana mitaia kaparaia milieli ngirkibana wonti, tana karakararina wonti ja nunkangu kaldri pilki jinkina wonti, ");
INSERT INTO dif_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ja jatana wonti: „Jidni Juda kanaia Kapara ngananani, munta kulkateriamai!“ ");
INSERT INTO dif_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Bakana nunkangu miri jaura dakani parana wonti Griekaia ja Romaia ja Juda kanaia jaurali: „NAUPINI JUDA KANAIA KAPARA NGANAI.“ ");
INSERT INTO dif_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Madlentji ngankanietja kulnujeli, kunarkuni warukana, nina ngirkibana wonti ja jatana wonti: „Jidni Christus ngananani, munta kulkateriamai ja ngalina.“ ");
INSERT INTO dif_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Nulu kulnujeli kalabana wonti ja nina daudauana wonti ja jatana wonti: „Jidni bakana wata Godandru japali nganai, ngangau jundru bakana ninapini kalala ngamalkai? ");
INSERT INTO dif_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ja talku ngaldrangu, ngangau ngaldra maniai, mina ngaldra ngankanala;“ nulupini wata madlentji ngankana warai. ");
INSERT INTO dif_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ja nau Jesungu jatana wonti: „Kaparajai, ngana ngundramai, jidni mililani jinkanani wokaranani!“ ");
INSERT INTO dif_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesus nunkangu jatana wonti: „Morlalu ngani jinkangu jatai: Karari jidni ngakangunto Paradiesini nganala nganai.“ ");
INSERT INTO dif_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ja toda ngalpuru pirna pantjina wonti mita maruni ditji kunarkujelu. ");
INSERT INTO dif_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ja ditji pirna ngalpuru pantjina wonti, ja Godaia pungaia kati pirna terti puraterina wonti. ");
INSERT INTO dif_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ja Jesus ngaiala pirnali karkana wonti ja jatana wonti: „Ngaperiai! marani jinkanani ngato Jaola ngakani kurai.“ Ja Nau jenia matja jatana, Nau palina wonti. ");
INSERT INTO dif_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Juljaia kaparali jenia najina, mina pantjina, nulu Goda jurakokana wonti ja jatana wonti: „Morlalu, Naupini kana talku nganana warai.“ ");
INSERT INTO dif_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ja kana wolara pratjanali tana wokarana warai najila, tanali matja najina mina pantjinani, tana munampiri nandraterina wonti ja tikana karitjina wonti. ");
INSERT INTO dif_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Worita terkana wonti kamaneli nunkani pratjana, ja tana widla nunkangu Galilaiandru karipaterina warai, ja tanali jenia najina wonti. ");
INSERT INTO dif_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ja mai, kana kulno tala nunkani Joseph, kana kapara, kana ngumu ja talku. ");
INSERT INTO dif_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Naupini ngankamalinani tananani ja ngankanani tananani manukulkaterina wonti — nau Arimathia Juda kana ngura kulnundru, nulu bakana Godaia mililani kalkana wonti. ");
INSERT INTO dif_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nau Pilatungu wapana wonti ja Jesu palkuni ngatjina wonti. ");
INSERT INTO dif_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ja nulu nina matja ngarilkana, nulu nina katieli karana wonti ja narikutuni, mardani matja bakuna, kurana wonti, nunkangu wata kulno parana wonti. ");
INSERT INTO dif_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ja ngankingani ditji nganana wonti, ja Sabbat ditjini kupiri nganana wonti. ");
INSERT INTO dif_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Bakana widla, nunkangu matja karipaterina, tana nunkangunto Galilaiandru wokarala wiri, nina narikutu najina wonti, worderu palku nunkani paranani. ");
INSERT INTO dif_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Tana matja tikana, tanali kuli ngumu ja gildi pilki ngankingana wonti; ja Sabbat ditjini tana ngapu nganana wonti jirijiribani jaurandru. ");
INSERT INTO dif_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Godaia ditji nguramaranani tana nariwonpani wokarana wonti, ja kuli ngumu, nina tanali matja ngankingana, padakana wonti, ja palpa tanangunto. ");
INSERT INTO dif_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Tanali marda nari kutundru matja tiringana mankamankana wonti. ");
INSERT INTO dif_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ja tana matja wirina, tanali Jesu Kaparaia palku wata mankamankana wonti. ");
INSERT INTO dif_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ja jendranguta tana jendrangundruja mangapunkujeli nganana wonti, ja mai, materi mandru tanangu wokarana wonti mintjini katieli. ");
INSERT INTO dif_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Tana japali pantjinani ja mudla tanani mitani buruna ngarinani, pudla tanangu jatana wonti: „Minandru jura Tepita narini wontiai? ");
INSERT INTO dif_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nau wata ninkida nganai, a‐ai, Nau jiritjina warai. Ngundranau worderu Nulu jurangu kaukaubana paraia, Nau Galilaiani matja nganana, ");
INSERT INTO dif_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ja jatana paraia: Tanali Kanaia Ngatamura kana madlentjia marani jinkinanto ja kunarkuni katibananto, ja ditjini parkulani Nau jiritjinanto.“ ");
INSERT INTO dif_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ja tanali jaura nunkani ngundrana wonti. ");
INSERT INTO dif_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ja tana narikutundru karitjina tikana wonti ja jenia pratjana marapratjana ja kulnuni ja tanangu pratjanani kaukaubana wonti. ");
INSERT INTO dif_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Maria Magdalala ja Johanna ja Maria Jokobuni, ja tana widla palpa, tanangunto nganana wonti, tana jenia Apostelani jatana wonti. ");
INSERT INTO dif_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ja tanani kaukaubani jaura tanangu jaura baku jeribaka nganana wonti, ja tanali tanangu wata morlalu ngundrana wonti. ");
INSERT INTO dif_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Petrus terkakana wonti ja nari kutuja mindrina wonti; ja nulu matja buruna ngulukana, nulu windri kati paranani najina wonti; ja nau pungani tikana wonti ja pirna ngaruparana wonti jendrangundruja, mina pantjina warai. ");
INSERT INTO dif_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ja mai, mandru tanangundru nunkangupini ditjini ngura kulno wakaia wapana wonti, tala nunkani Emaus, nau Jerusalemingundru 60 Statia worita nganana wonti. ");
INSERT INTO dif_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ja pudla ngankamalina wonti jenia pratjanandru, mina pantjina warai. ");
INSERT INTO dif_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ja jendranguta pudla ngankamalinani ja jakalkijiribamalinani, bakana Jesus munta karakara wokarana wonti, ja pudlangunto wapana wonti. ");
INSERT INTO dif_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pudlani milki njurlunjurlurina wonti nina wata ngujamala. ");
INSERT INTO dif_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Nau pudlangu jatana wonti: „Mina jaura judla ngankamaliai paltuni, ja minandru judla ngaurongauro nganai?“ ");
INSERT INTO dif_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Kulnujeli, tala nunkani Kleophas, kalabana wonti ja nunkangu jatana wonti: „Jidni kulnulu tidnapalara Jerusalemingu nganai, nulupini wata ngarana warai, mina naka tanangupini ditjini matja pantjina?“ ");
INSERT INTO dif_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ja Nau pudlangu jatana wonti: „Mina?“ Pudla nunkangu jatana wonti: „Jenia Jesus Nazarenalandru, Naupini Propheta talku nganana wonti, ngankanali ja jaurali ngurunguru Godani ja kana wolarani. ");
INSERT INTO dif_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ja worderu Priesta pirnali ja kana kaparali ngaianinali nina naria ngulkujeli jinkila wiri, ja nina kunarkuni katibala wiri. ");
INSERT INTO dif_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ngaiani kalkanala, Nulu Israel kulkananto. Ja karari ditji parkulu nganai, jenia pratjana pantjila wiri. ");
INSERT INTO dif_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ja bakana widla palpali ngaianingundru ngaianina ngaruparibana warai, tana nguramarani nariwonpani wokarana warai. ");
INSERT INTO dif_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ja tanali palku nunkani wata mankamankana warai ja tikana warai ja jatana warai, tanali angela mudla matja najina, tana jatai, Nau tepi nganai. ");
INSERT INTO dif_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ja palpa ngaianingundru narikutuni wokarana warai, ja jeruja mankamankana warai, worderu widla likaukaubana warai; windri nina tanali wata najina warai.“ ");
INSERT INTO dif_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ja Nau pudlangu jatana wonti: „Judla kana patipati ja ngara ngurunguru jenia pratjana morlalu ngundrala, mina Prophetali kaukaubana wonti. ");
INSERT INTO dif_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Wata jenia Christulu ketjaketjananto ja pirnalani nunkanani wirinanto?“ ");
INSERT INTO dif_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ja Nulu wonina wonti pudlangu Mosingundru ja Propheta pratjanandru jenia mildiri ngankala, mina tanali jaurani tananani pratjanani jatana wonti. ");
INSERT INTO dif_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ja tana nunkangupini nguraia karakara wokarana wonti wodajeri pudla wapananto; ja Nulu malka wondrana wonti, Nau wiringananto. ");
INSERT INTO dif_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ja pudlali nina parparali ngankana wonti ja jatana wonti: „Ngalingu ngamamai, ngangau matja kalkaurariai ja ditji panila.“ Ja Nau wirina wonti pudlangu jela ngamala. ");
INSERT INTO dif_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ja jendranguta Nau pudlangunto matja ngamana ngarina, Nulu buka patana wonti ja nina ngurungutana wonti ja wokaribana wonti ja pudlangu jinkina wonti. ");
INSERT INTO dif_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Pudla milki piririna wonti, ja pudlali nina ngujamana wonti; ja Nau pudlangundru kutingana wonti. ");
INSERT INTO dif_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ja pudla ngankamalina wonti: „Wata ngaldra ngara jerkina warai, worderu Nulu paltuni ngaldrangu kaukaubana warai, ja worderu Nulu ngaldrangu jaura worana mildiri ngankana warai?“ ");
INSERT INTO dif_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ja pudla nunkangupini ditjini jiritjina wonti ja Jerusalemia tikana karitjina wonti; ja pudlali marapratjana ja kulno ja tanana tanangunto matja jurborina, mankamankana wonti. ");
INSERT INTO dif_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ja tana jatana wonti: „Kapara morlalu jiritjina warai ja Simoningu wondraterina warai!“ ");
INSERT INTO dif_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ja pudlali kaukaubana wonti mina paltuni matja pantjina, ja worderu pudlali nina ngujamana warai buka wokaribanani. ");
INSERT INTO dif_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Tana jenia kaukaubijiribamalinani Jesus munta tanangu terti terkana wonti ja tanangu jatana wonti: „Murla jurangunto nganaiatimai!“ ");
INSERT INTO dif_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Tana ngarrana wonti ja japali pirna pantjina wonti, ja tanali ngundrana wonti, tanali jaola najiai. ");
INSERT INTO dif_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ja Nau tanangu jatana wonti: „Minandru jura japali pirna nganai; ja minandru ngarali juranali mangangankana jiritjiai? ");
INSERT INTO dif_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ngana mara ja ngana tidna najianau, ngani munta Nauja nganai; ngana karakaranau ja najianau, ngangau jaolali wata palku ja moku ngamalkai, worderu jura najiai ngato ngamalkanani.“ ");
INSERT INTO dif_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ja Nau jenia matja jatana, Nau mara ja tidna tanangu wondraterina wonti. ");
INSERT INTO dif_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ngangau tanali mankinandru wata morlalu ngundrana wonti ja ngaruparana wonti, Nau tanangu jatana wonti: „Jura ninkida palpa ngamalkai tajinanto?“ ");
INSERT INTO dif_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Tanali nunkangu paru buru kulno, matja wajina, ja pitjambu jinkina wonti. ");
INSERT INTO dif_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ja Nulu nina patana wonti ja tanangu milkini tajina wonti. ");
INSERT INTO dif_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nau tanangu jatana wonti: „Tanapini jaura ngakani nganai, tananaia ngato jurangu kaukaubanala ngani jurangunto nganana, ngangau pratjana morlalu pantjinanto mina Mosini jirijiribani jaurani ja Prophetani ja wima jaurani ngakangundru dakanala parai.“ ");
INSERT INTO dif_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ngadani Nulu tjuru tanani piri ngankana wonti jaura worana ngujamananto. ");
INSERT INTO dif_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ja Nau tanangu jatana wonti: „Jeruja dakanala parai, ja jeruja Christus ketjaketjananto, ja ditjini parkulani jiritjinanto. ");
INSERT INTO dif_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ngangau tanali talani nunkanani madlentjandru karitjina ja madlentji kalingana kanani warupotuni kaukaubananto ja Jerusalemingu woninanto. ");
INSERT INTO dif_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Jura jenia pratjanandru morlalu kuranietja nganai. ");
INSERT INTO dif_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ja mai, ngato jurangu Ngaperaia ngakanaia talpada‐kanila jinpala nganai; Jerusalem ngurani ngamanau, jura ngurula mirindru widmaterilalu.“ ");
INSERT INTO dif_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ngadani Nulu tanana Bethaniaia dunkalkana wonti, ja Nau mara ngutaterina wonti, ja Nulu tanana ngurungutana wonti. ");
INSERT INTO dif_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ja jendranguta Nulu tanana matja ngurungutana, Nau tanangundru danina wonti ja pariwilpaia tarana wonti. ");
INSERT INTO dif_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ja tanali nunkangu matja pantjaterkana ngatjina, tana Jerusalemia tikana kurana wonti mankinali. ");
INSERT INTO dif_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ja tana milingeru Godaia pungani ngamana wonti, ja Goda jurakokana wonti ja ngatjina wonti. ");
INSERT INTO dif_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ngopera jaura nganana wonti, ja jaura Godanto nganana wonti, ja jaura Goda nganana wonti. ");
INSERT INTO dif_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Naupini ngopera Godanto nganana wonti. ");
INSERT INTO dif_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Nunkangundru warupoto pantjina wonti, ja nunkangupini panini wata kulno pantjina wonti mina pantjina wonti. ");
INSERT INTO dif_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Nunkangu tepi nganana wonti, ja tepi kanaia praitji nganana wonti. ");
INSERT INTO dif_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ja praitji mintjiai ngalpurani, ja ngalpurali nina wata patana wonti. ");
INSERT INTO dif_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Kana kulno terkakana wonti, nina Godali jinpana wonti, tala nunkani Johannes. ");
INSERT INTO dif_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Naupini wokarana wonti tinkaraia, ngangau nulu praitjandru tinkari ngankananto, pratjana nunkangundru morlalu ngundrananto. ");
INSERT INTO dif_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Wata nau munta praitji nganana wonti, a‐ai, praitjandru nulu tinkari ngankananto. ");
INSERT INTO dif_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Naupini praitji morlalu, Naupini kanani warupotuni mintjiai, mitani wokarananto. ");
INSERT INTO dif_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Naupini mitani nganana wonti, ja mita maru nunkangundru pantjina wonti, ja mita marujeli nina wata ngujamana wonti. ");
INSERT INTO dif_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Nau wokarana wonti nunkanani, ja tanali nunkanali nina wata patana wonti. ");
INSERT INTO dif_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Worderuntjali nina patana wonti, tanangu Nulu ngurula jinkina wonti Godaia kupa pantjinanto, tanali talani nunkanani morlalu ngundranani. ");
INSERT INTO dif_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Tanapini wata kumarali, bakana wata palku jertapaterinali, bakana wata materi jertapaterinali, a‐ai, Godandru dankana wonti. ");
INSERT INTO dif_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ja jaura palku pantjina wonti, ja ngaianangunto ngamana wonti, ja ngaiana pirnala nunkani najina wonti, Ngaperi Kunakulnuja pirnalani jeribaka murlali ja morlalu manamiri. ");
INSERT INTO dif_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Johannili nunkangundru tinkari ngankana wonti, ja nau maritjina wonti ja jatana wonti: „Naupini Nau nganai, nunkangundru ngani jatana wonti: Nau ngakangu ngadani wokarala nganai ngakangu ngopera wapana wonti; ngangau Nau morla ngopera nganana wonti ngakangu.“ ");
INSERT INTO dif_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ja nunkani manamirindru ngaiana pratjanali manina wonti murla ja murla. ");
INSERT INTO dif_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ngangau jirijiribani jaura Nulia Mosili jinkina wonti; murla ja morlalu Jesu Christungundru pantjina wonti. ");
INSERT INTO dif_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Wata kulnujeli Goda najina wonti; Ngatamura Kunakulnujeli, Nauja Ngaperaia ngalpani ngamai, Nulia ngaianangu kaukaubana wonti. ");
INSERT INTO dif_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ja naupini Johannini tinkari ngankani nganai, matja Juda kanali Jerusalemingundru Priesta ja Levita jinpanala, tanali nina jakalkananto: „Worana jidni nganai?“ ");
INSERT INTO dif_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ja nulu morlalu kurana wonti ja wata jedina wonti; ja nulu morlalu kurana wonti: „Wata ngani Christus nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ja tanali nina jakalkana wonti: „Worana jidni? Jidni Elias nganai?“ Nau jatana wonti: „Wata ngani nau.“ Jidni Propheta nganai? Ja nulu kalabana wonti: „Pani.“ ");
INSERT INTO dif_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Tana nunkangu jatana wonti: „Ja worana jidni nganai, ngaiani kalabani jaura tikalkananto tanangu, tanali ngaianina jinpana warai; mina jidni jatai jinkangundru?“ ");
INSERT INTO dif_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Nau jatana wonti: „Ngani karkanietjaia ngaiala pitarani nganai, Kaparaia palto talku ngankinganimai, worderu Propheta Jesaias jatana wonti.“ ");
INSERT INTO dif_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ja tana jinpani Pharisaiandru nganana wonti. ");
INSERT INTO dif_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ja tanali nina jekibana wonti ja nunkangu jatana wonti: „Minandru jundru multibai wata Christus ngananani ja wata Elias ja wata Propheta?“ ");
INSERT INTO dif_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Johannili kalabana wonti ja tanangu jatana wonti: „Ngato ngapali multibai, ja Nau jurangu terti terkai, nina jura wata ngujamai. ");
INSERT INTO dif_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Naupini Nau nganai, Nau ngakangu ngadani wokarala nganai, Nau ngakangu ngopera nganana, nunkangu ngani wata talku nganai tidnaputa jinka nunkani dukarala.“ ");
INSERT INTO dif_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jenia Bethabarani pantjina wonti, Jordan kaiarani jerankari, woderi Johannili multibana wonti. ");
INSERT INTO dif_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ditjini kulnuni Johannili najina wonti Jesus nunkangu wokaranani, ja jatana wonti: „Najiau Godaia tjipi kuparu, Nuluwa kana warupotuja madlentji mandrala wapaia!“ ");
INSERT INTO dif_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Naupini nganai, nunkangundru ngani jatana wonti: „Ngakangu ngadani kana kulno wokarala nganai, Nau ngakangu ngopera wapana wonti; ngangau Nau morla ngopera nganana wonti ngakangu.“ ");
INSERT INTO dif_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ja ngato nina wata ngujamana wonti, a‐ai, windri ngangau Juda kanali nina ngujamananto, jendrania ngani wokarana wonti ngapali multibala. ");
INSERT INTO dif_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ja Johannili tinkari ngankana wonti ja jatana wonti: „Ngato najina wonti Jaola pariwilpandru ngarinani mulapara jeribaka, ja Nauja nunkangu ngamana ngarina wonti.“ ");
INSERT INTO dif_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ja ngato nina wata ngujamana wonti, a‐ai, windri Naupini, Nulia ngana jinpana wonti ngapali multibala, ngakangu jatana wonti: „Worangu jundru najila nganai Jaola ngarinani ja nunkangu ngamanani, Naupini nganai, Nau Jaolali kulikirieli multibai.“ ");
INSERT INTO dif_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ja ngato najina wonti ja tinkari ngankana wonti: Naupini Godaia Ngatamura nganai. ");
INSERT INTO dif_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Tankubana ditjini Johannes nakaldra terkana wonti ja nunkani mili mandru. ");
INSERT INTO dif_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ja nulu Jesu palkanani najina wonti ja jatana wonti: „Najiau Godaia Tjipi kuparu!“ ");
INSERT INTO dif_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ja mili mandrujeli nina matja ngarana jatanani, pudla Jesungu karipaterina wonti. ");
INSERT INTO dif_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesus worakalina karitjina wonti ja najina wonti pudlana nunkangu karipaterinani, Nau pudlangu jatana wonti: „Mina judla wontiai?“ Pudla nunkangu jatana wonti: „Rabbi — jenia wondrai ngujangujara jinkinietja — woderi jidni ngamai?“ ");
INSERT INTO dif_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Nau pudlangu jatana wonti: „Kaperalumai ja najialumai!“ Pudla wokarana wonti ja najina wonti, woderi Nau ngamanani; ja nunkangupini ditjini pudla nunkangunto ngamana wonti. Ja ditji kunarku nganana wonti. ");
INSERT INTO dif_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andreas, Simon Petruni ngatata, pudlangundru kulno nganana wonti, pudlali Johanningundru ngarana warai, ja nunkangu karipaterina warai. ");
INSERT INTO dif_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Nulupini ngopera Simon neji nunkani mankamankana wonti, ja nunkangu jatana wonti: „Ngali Messias mankamankana warai, jenia wondrai Christus.“ ");
INSERT INTO dif_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Nulu nina Jesungu wapalkana wonti. Jesujeli nina matja najina, jatana wonti: „Jidni Simon nganai, Jonani ngatamura; jundru Kephas tala ngamalkala nganai;“ jenia wondrai „Marda.“ ");
INSERT INTO dif_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Tankubana ditjini Jesujeli ngantjana wonti Galilaiaia palkala, ja Nulu Philippus mankamankana wonti ja nunkangu jatana wonti: „Ngakangu karipateriau!“ ");
INSERT INTO dif_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Philippus Bethsaidandru nganana wonti, Andreani ja Petruni ngurandru. ");
INSERT INTO dif_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Philippula Nathanaeli mankamankana wonti ja nunkangu jatana wonti: „Ninaia, nunkangundru Mosili jirijiribani jaurani ja Prophetali dakana wonti, ninapini ngaiani mankamankana warai, Jesu Josephani ngatamura Nazaretandru.“ ");
INSERT INTO dif_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ja Nathanael nunkangu jatana wonti: „Nazaretandru ngumula dunkananto?“ Philippus nunkangu jatana wonti: „Kaparau ja najiau!“ ");
INSERT INTO dif_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesujeli Nathanael nunkangu wokaranani najina wonti, ja nunkangundru jatana wonti: „Najianau Israel kana morlalu, nunkangu jedini pani nganai!“ ");
INSERT INTO dif_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nathanael nunkangu jatana wonti: „Woderindru jundru ngana ngujamai?“ Jesujeli nunkangu kalabana wonti ja jatana wonti: „Morla ngopera Philippulu jidna karkana warai, jidni tandra pitani ngananani, ngato jidna najina warai.“ ");
INSERT INTO dif_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nathanailali nunkangu kalabana wonti ja jatana wonti: „Rabbi, jidni Godaia Ngatamura nganai, jidni Israelani Kapara nganai!“ ");
INSERT INTO dif_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesujeli nunkangu kalabana wonti ja jatana wonti: „Ngangau ngani jinkangu jatana warai, ngato jidnana najina warai tandra pitani, jundru morlalu ngundrai? Jundru morla pirnala najila nganai nunkangupini. ");
INSERT INTO dif_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ja Nau nunkangu jatana wonti: Morlalu, morlalu, ngani jurangu jatai: Kararindrn jura najila nganai pariwilpa piririnani, ja Godaia angela worana taranani ja ngarinani Godaia Ngatamurani.“ ");
INSERT INTO dif_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ja ditji parkulani noapatamalini ditji nganana wonti Kana ngurani Galilaiani; ja Jesuni ngandri naka nganana wonti. ");
INSERT INTO dif_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ja tanali bakana Jesus ja mili nunkani noapatamalini ditjia karkana wonti. ");
INSERT INTO dif_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ja waina matja mudana, Jesuni ngandri nunkangu jatana wonti: „Waina pani morla tanalia ngamalkai.“ ");
INSERT INTO dif_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesus nankangu jatana wonti: „Mina ngakangu ja jinkangu Widlajai? Ditji ngakani wata wokarala wapaia.“ ");
INSERT INTO dif_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ngandri nunkani milini jatana wonti: „Mina Nauja jurangu jatai, jenia ngankanau!“ ");
INSERT INTO dif_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ja naka mardangapakoko pirna mara wora ja kulno terkana wonti, worderu Juda kanali milingeru ngamalkana wonti kulirkaterila, ja koko pirnali mandrani koko waka mandru kara, parkulu kara patana wonti. ");
INSERT INTO dif_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesus tanangu jatana wonti: „Ngapakoko manamiri ngankanau ngapali.“ Ja tanali manamiri ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ja Nau tanangu jatana wonti: „Kaluanau, ja bukanajinajibanietjani padakanau!“ Ja tanali padakana wonti. ");
INSERT INTO dif_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ja bukanajinajibanietja nina waina, nau ngopera ngapa nganana warai, wontjana wonti, ja nau ko nganana wonti woderindru nau, windri mili milkila nganana wonti, ngangau tanali ngapa manina, bukanajinajibanietjali noangantjanipirna karkana wonti, ");
INSERT INTO dif_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ja nunkangu jatana wonti: „Kana pratjanali waina ngumu ngopera jinkiai, ja tana matja kaljura nganana, ngadani madlentji; jundru waina ngumu kulkana warai kararielu.“ ");
INSERT INTO dif_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Naupini malka ngopera nganana wonti, nina Jesujeli ngankana wonti Kana ngurani Galilaiani pirnala nunkani wondrala; ja milieli nunkanali morlalu ngundrana wonti nunkangu.");
INSERT INTO dif_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ngadani Nau Kapernaum nguraia ngarina wonti, Nau ja ngandri nunkani ja ngatata nunkani ja mili nunkani; ja naka tanali windri ditji palpa ngamana wonti. ");
INSERT INTO dif_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ja Juda kanaia Passa karakara nganana wonti, ja Jesus tarana wonti Jerusalemia. ");
INSERT INTO dif_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ja Nulu Godaia pungaia mankamankana wonti tanana nganti pirna ja tjipi ja mulapara burungankanani ja mardatandrakaritjimalkanietja ngamanani. ");
INSERT INTO dif_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ja Nulu jinkandru nandrani jinka wirri ngankana wonti, ja pratjana Godaia pungandru narana wonti, tjipi ja bakana nganti pirna; ja mardatandrakaritjimalkanietjaia marda Nulu nangana wonti, ja karitjimalkani kurli tanani Nulu kokulterkibana wonti. ");
INSERT INTO dif_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ja Nau mulaparaburungankanietjani jatana wonti: „Padakanimai tananapara pratjana ninkidandru, ja wata ngakani Ngaperaia punga burungankani punga karitjimalkanau!“ ");
INSERT INTO dif_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Milieli nunkanali ngundrana wonti worderu dakanala parai: „Ngantjana pirnali jinkani pungandru ngana tajila nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Juda kanali kalabana wonti ja nunkangu jatana wonti: „Mina malka jundru ngaianingu wondrai, ngangau jundru ninapini ngankai?“ ");
INSERT INTO dif_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesujeli kalabana wonti ja jatana wonti tanangu: „Ninapini punga wokaribamai, ja ditjini parkulani ngato ninaia terkibana tarala nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Juda kana jatana wonti: „Ninapini punga tanali 46 kilpawoldrani wotina wonti, ja jundru ninaia ditjini parkulani terkibana tarala nganai?“ ");
INSERT INTO dif_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Nau jenia jatana wonti nunkani palku pungandru. ");
INSERT INTO dif_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Nau matja tepi terkakana warai narindru, milieli nunkanali ngundrana wonti, Nulu jenia tanangu jatana wonti; ja tanali jaurani morlalu ngundrana wonti, ja nunkangupini jaurani nina Jesus jatana wonti. ");
INSERT INTO dif_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Nau Jerusalemingu nganana Passa ditji pirnani, marapujeli talani nunkanani morlalu ngundrana wonti, ngangau tanali malka nunkani najina wonti, tanana Nulu ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Jesujeli tanangu wata morlalu ngundrana wonti, ngangau Nulu pratjana ngujamana wonti. ");
INSERT INTO dif_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ja nunkangu wata kulno jaura jinkinanto kanandru; ngangau Nulu muntali ngujamana wonti, mina kanani nganai. ");
INSERT INTO dif_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Kana kulno nganana wonti Pharisaiandru, tala nunkani Nikodemus, Juda kanaia kapara kulno. ");
INSERT INTO dif_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Naupini Jesungu wokarana wonti tinkani, ja nunkangu jatana wonti: „Kaparajai, ngaiani milkila, jidni ngujangujara jinkinietja nganai Godandru wokaranala; ngangau wata kulno ngurunguru nganai tananapini malka ngankala, tanana jundru ngankai, Goda wata nunkangunto ngananani.“ ");
INSERT INTO dif_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesujeli kalabana wonti ja nunkangu jatana wonti: „Morlalu, morlalu, ngani jinkangu jatai: Wata kana marra dankanani, nau ngandandariai Godaia milila najila.“ ");
INSERT INTO dif_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikododemus nunkangu jatana wonti: „Worderu kana marra dankala nganai nau pirna ngananani? Nau poto mandrula ngandri mandrani wirinanto marra dankala?“ ");
INSERT INTO dif_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesujeli kalabana wonti: „Morlalu, morlalu, ngani jinkangu jatai: Warle wata marra dankanani ngapali ja Jaolali, nau ngandandarila nganai Godaia mililani wirila. ");
INSERT INTO dif_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mina palkujeli dankai, palku nganai; ja mina Jaolali dankai, Jaola nganai. ");
INSERT INTO dif_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Wata ngaruparau, ngangau ngani jinkangu jatana warai: Jura marra dankananto. ");
INSERT INTO dif_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Watara ngakai woderi nau jertapateriai ja birungana nunkani jundru ngarai, windri jundru wata ngujamai, woderindru nauja wokarai ja woderi ngakai; jeruja pratjana, tana Jaolandru dankai.“ ");
INSERT INTO dif_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemulu kalabana wonti ja nunkangu jatana wonti: „Worderu jenia pantjiai?“ ");
INSERT INTO dif_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesujeli kalabana wonti ja nunkangu jatana wonti: „Jidni ngujangujara jinkinietja nganai Israelani, ja jenia jundru wata ngujamai? ");
INSERT INTO dif_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Morlalu, morlalu, ngani jinkangu jatai: Ngaiani jatai mina ngaiani ngujamai, ja kaukaubai mina ngaiani najinala, ja ngaianini tinkari ngankani jura wata patai. ");
INSERT INTO dif_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ngani mitaia potundru jurangu jatanani, jura wata morlalu ngundranani; worderu morla jura wata morlalu ngundrala nganai, ngani pariwilpaia potundru jurangu jatanani? ");
INSERT INTO dif_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ja wata kulno pariwilpaia tarala wapaia, windri Nauja pariwilpandru ngarinala, Kanaia Ngatamura, Nauja pariwilpani nganai. ");
INSERT INTO dif_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ja worderu Mosili pitarani tjutju miri ngankana wonti, jeruja tanali Kanaia Ngatamura miri ngankananto. ");
INSERT INTO dif_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ngangau pratjanali, nunkangu morlalu ngundranani, wata tintaterinanto, a‐ai, tepi ngurali ngamalkananto. ");
INSERT INTO dif_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ngangau jeruja Godali mitala ngantjana wonti, Nulia Ngatamura Kunakulno nunkani jinkina wonti, ngangau pratjanali tana nunkangu morlalu ngundranani, wata tintaterinanto, a‐ai, tepi ngurali ngamalkananto. ");
INSERT INTO dif_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ngangau Godali Ngatamura nunkani wata mitani jinpana wonti kalala kurala, a‐ai, Nulu mitala kulkananto. ");
INSERT INTO dif_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Warlenulu ninaia morlalu ngundranani wata kalala maninani; ja warlenulu wata morlalu ngundranani kalala matja manina, ngangau nulu Godaia Ngatamuraia Kunakulnuja talani wata morlalu ngundrai. ");
INSERT INTO dif_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Naupini kalala nganai: Praitji mitani wokarana wonti, ja kanali ngalpuru morla ngantjana wonti praitjani; ngangau ngankana tananani madlentji nganana wonti. ");
INSERT INTO dif_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ngangau warle madlentji ngankai, praitjani kalakalariai, ja wata praitjani wokarai, ngankana nunkani tinkari pantjiati. ");
INSERT INTO dif_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Warle morlalulali ngankanani, praitjani wokarala nganai, ngangau ngankana nunkani tinkari pantjinanto, ngangau tanali Godani ngankana warai.“ ");
INSERT INTO dif_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ngadani Jesus ja mili nunkani Judaia mitani wokarana wonti; ja naka Nau ngamana wonti tanangunto ja multibana wonti. ");
INSERT INTO dif_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ja bakana Johannili multibana wonti Ainoni, Salimingu karakara, ngangau ngapa marapu naka nganana wonti; ja tana wokarana wonti ja multibanila manina wonti. ");
INSERT INTO dif_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ngangau jendranguta Johannes wata kanjangarini ngamana wonti. ");
INSERT INTO dif_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Johannini milindru jatamalina pantjina wonti Juda kanani kulirkanandru. ");
INSERT INTO dif_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ja tana Johanningu wokarana wonti ja nunkangu jatana wonti: „Rabbi, Naupini jinkangu nganana paraia Jordan kaiarani jerankari, nunkangundru jundru tinkari ngankana paraia, mai, Nau multibai, ja pratjana nunkangu wokarai.“ ");
INSERT INTO dif_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Johannili kalabana wonti ja jatana wonti: „Kana kulnujeli ngandandariai palpa manila, nunkangu wata ngopera jinkinala pariwilpandru. ");
INSERT INTO dif_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Jura muntali ngakangu tinkari ngankai, ngani jatana paraia: Ngani wata Christus nganai, a‐ai, Nulu ngana jinpana wonti nunkangu ngopera. ");
INSERT INTO dif_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Warle talpadakani noa ngamalkai, nau noangantjanipirna nganai; ja noangantjanipirnaia kamaneli, nau terkai ja nina ngarai, pirna mankiai noangantjanipirnaia ngaialandru. Naupini mankina pirna ngakani karari manamiri nganai. ");
INSERT INTO dif_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Nau pirnarinanto, ngani wakarinanto. ");
INSERT INTO dif_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Naupini mirindru wokarai morla pirna nganai pratjanani. Worana mitandru nganai, nau mitandru nganai ja mitandru jatai; Nau pariwilpandru wokarai morla pirna nganai pratjanani. ");
INSERT INTO dif_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Mina Nulu najina wonti ja ngarana wonti jenia Nulu tinkari ngankai, ja tinkari ngankani nunkani wata kulnujeli patai. ");
INSERT INTO dif_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Warle tinkari ngankani nunkani patana warai, nulu jenia morlalu kurana warai Goda morlalu nganai. ");
INSERT INTO dif_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ngangau worana Godali jinpana wonti, Nulu Godaia jaura kaukaubai; ngangau Godali wata Jaola ngalje jinkiai nunkangu. ");
INSERT INTO dif_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ngaperali Ngatamura ngantjai, ja pratjana Nulia marani nunkanani jinkina wonti. ");
INSERT INTO dif_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Warlenulu Ngatamurani morlalu ngundrai, nulu tepi ngurali ngamalkai; worana Ngatamurani wata pankiai, nulu tepita wata najila nganai, a‐ai, Godaia tiri nunkangu milingeru parai.“ ");
INSERT INTO dif_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Kaparali matja ngujamana, Pharisaiali ngarana warai Jesujeli morla mili ngankanani ja multibanani Johanningu ");
INSERT INTO dif_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","— Jesujeli muntali wata multibana wonti, a‐ai, windri milieli nunkanali — ");
INSERT INTO dif_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Nau Judaiandru puntina wonti ja nakaldra Galilaiaia palkana wonti. ");
INSERT INTO dif_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Nau Samaria mitani palkingananto. ");
INSERT INTO dif_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Nau wokarana wonti Samaria ngura kulnuni, tala nunkani Sichar, nunkangupini mitani karakara, nina Jakobali ngatamurani nunkanani Josephangu jinkina wonti. ");
INSERT INTO dif_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Naka Jakobani ngapatjili nganana wonti. Ngangau Jesus palkanandru matja walturina, Nau ngamana ngarina wonti ngapatjilini; ja toda nganana wonti. ");
INSERT INTO dif_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Samaria widla kulno wokarana wonti ngapa kaluala. Jesus nankangu jatana wonti: „Ngakangu jinkiau tapananto?“ ");
INSERT INTO dif_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ngangau mili nunkani nguraia wapana wonti buka burungankala. ");
INSERT INTO dif_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Samarita widla nunkangu jatana wonti: „Worderu jenia, jidni Juda kana nganai ja ngatjiai ngakangundru tapala, ngani Samarita widla ngananani?“ Ngangau Juda kana wata manduriai Samaritalani. ");
INSERT INTO dif_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesujeli kalabana wonti ja jatana wonti nankangu: „Jundru Godaia poto ngujamanani ja worana Nauja nganai, Nauja jinkangu jatai: Jinkiau ngakangu tapananto, jidni nunkangu ngatjila nganai, ja Nulia jinkangu tepia ngapa jinkila nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Widla nunkangu jatana wonti: „Kaparajai, jundru wata ngapakoko ngamalkai ja ngapatjili mikari nganai; wodajerindru jundru tepia ngapa ngamalkai? ");
INSERT INTO dif_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Jidni morla pirna nganai ngaianini ngaperani Jakobangu, nulupini ngaianingu ninaia ngapatjili jinkina wonti, ja nulu muntali nunkangundru tapana wonti ja ngatamurajeli nunkanali ja ngantieli nunkanali?“ ");
INSERT INTO dif_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesujeli kalabana wonti ja nankangu jatana wonti: „Warlepratjana nunkangupini ngapandru tapanani nakaldra tertieli pantjila nganai. ");
INSERT INTO dif_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Warle nunkangupini ngapandru tapala nganai, nina ngato nunkangu jinkila nganai, nau ngurali wata tertieli pantjila nganai; a‐ai, naupini ngapa, nina ngato nunkangu jinkila nganai, nunkangu ngapa jukeri pantjila nganai, nau ngurali tepini ngakala nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Widla nunkangu jatana wonti: „Kaparajai, ninapini ngapa ngakangu jinkiau, ngani wata morla tertieli pantjinanto, ja wata morla ninkida wokarananto kaluala.“ ");
INSERT INTO dif_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesus nankangu jatana wonti: „Wapau, noa jinkani karkau, ja nakaldra ninkida tikau!“ ");
INSERT INTO dif_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Widlali kalabana wonti ja jatana wonti: „Ngani noa pani.“ Jesus nankangu jatana wonti: „Talku jidni jatana warai, ngani noa pani. ");
INSERT INTO dif_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ngangau jundru noa mara wora matja ngamalkana, ja nau, ninapini jundru karari ngamalkai, wata noa jinkani nganai; jenia jidni morlalu jatana warai.“ ");
INSERT INTO dif_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Widla nunkangu jatana wonti: „Kaparajai, ngato na jiai, jidni Propheta nganai. ");
INSERT INTO dif_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ngaianini ngaperi nunkangupini mardawonpani ngatjina wonti, ja jura jatai, Jerusalemingu nau piri nganai, woderi ngatjinanto.“ ");
INSERT INTO dif_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesus nankangu jatana wonti: „Widlajai, ngakangu morlalu ngundrau, ditji kulno wokarala nganai, jura wata morla nunkangupini mardawanpani ja wata morla Jerusalemingu Ngapinangu ngatjila nganai. ");
INSERT INTO dif_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Jura nunkangu ngatjiai, nina jura wata ngujamai; ngaiani nunkangupini ngatjiai, ninaia ngaiani ngujamai; ngangau Kulkanipirna Juda kanandru wokarai. ");
INSERT INTO dif_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ditji kulno wokarala nganai, ja matja karari nganai, nunkangu tana morlalu ngatjinietja Ngapinangu ngatjila nganai Jaolali ja morlalujeli; ngangau Ngaperali jenipara ngantjai, nunkangu jeruja ngatjinani. ");
INSERT INTO dif_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Goda Jaola nganai, ja tana nunkangu ngatjiai, Jaolali ja morlalujeli nunkangu ngatjinanto.“ ");
INSERT INTO dif_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Widla nunkangu jatana wonti: „Ngani milkila Messias wokarala nganai, nina tanali dikai Christus; Nau wokaranani, Nulu ngaianingu pratjana kaukaubala nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesus nankangu jatana wonti: „Ngani Naujata, Nauja jinkangu jela ngankamalila wapaia.“ ");
INSERT INTO dif_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ja jendranguta mili nunkani tikana wonti, ja tana ngaruparana wonti, ngangau Nau widlali ngankamaliai; ja wata kulno jatana wonti: „Mina jundru wontiai kara? Mina jidni nankangu jela ngankamaliai kara?“ ");
INSERT INTO dif_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Widlali ngapakoko nankani worarana wonti, ja nguraia tikana kurana wonti, ja kanani jatana wonti: ");
INSERT INTO dif_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","„Kaparanimai ja najianimai kana kulno, Nulupini ngakangu jatana warai pratjana, mina ngato ngankana warai; Naumata kara Christus?“ ");
INSERT INTO dif_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Tana ngurandru dunkana wonti ja nunkangu wokarana wonti. ");
INSERT INTO dif_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Jendranguta mili nunkani nunkangu ngatjina wonti ja jatana wonti: „Rabbi, tajiau!“ ");
INSERT INTO dif_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Nau tanangu jatana wonti: „Ngato buka ngamalkai tajila ninaia jura wata ngujamai.“ ");
INSERT INTO dif_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Mili wora jaura ngankamalina wonti: „Kulnujeli nunkangu buka jinkina warai kara?“ ");
INSERT INTO dif_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesus tanangu jatana wonti: „Buka ngakani nganai, ngato jertapaterina nunkani ngankananto, Nulia ngana jinpana wonti, ja ngankana nunkani mudananto. ");
INSERT INTO dif_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Wata jura jatai: Pira mandru ja mandruni kampani ditji wokarala nganai? Mai, ngani jurangu jatai, milki jurani miririanau ja maruni najianau, ngangau nau karari talku nganai kampananto. ");
INSERT INTO dif_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Kampanietjali kalala maniai ja tandra kampai ngurali tepia; ngangau jelali mankinanto jaupanietja ja kampanietja; ");
INSERT INTO dif_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ngangau ninkina jenia jaura morlalu nganai: Kulno pilki jaupanietja ja kulno pilki kampanietja. ");
INSERT INTO dif_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ngato jurana jinpana wonti kampananto, mina jura wata ngankana warai; kana ngurujeli ngankana wonti, ja jura ngankanani tananani wirina wonti.“ ");
INSERT INTO dif_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Nunkangupini ngurandru Samaritala marapujeli nunkangu morlalu ngundrana wonti widlaia jaurandru, nandru tinkari ngankana wonti: „Nau ngakangu jatana warai pratjana, mina ngato ngankana wonti.“ ");
INSERT INTO dif_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Samaritala nunkangu matja wokarana, tana nunkangu ngatjina wonti, Nau tanangunto ngamananto; ja Nau ditji mandru naka ngamana wonti. ");
INSERT INTO dif_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ja morla marapujeli nunkani jaurandru morlalu ngundrana wonti, ");
INSERT INTO dif_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ja widlani tana jatana wonti: „Wata morla jinkani jaurandru ngaiani morlalu ngundrai, a‐ai, muntali ngaiani ngarana warai ja ngujamai, Naupini morlalu Christus, kanaia Kulkanipirna nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ditji mandruni Nau nakandru puntina wonti ja Galilaiaia palkana wonti. ");
INSERT INTO dif_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ngangau Jesujeli muntali morlalu kurana wonti, Propheta ngaperalani mitani waka nganai. ");
INSERT INTO dif_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Nau Galilaiani matja wokarana, Galilaialali nina patana wonti, ngangau tanali pratjana najina paraia, mina Nulu Jerusalemingu ditji pirnani ngankana paraia; ngangau bakana tana ditji pirnani wokarana wonti. ");
INSERT INTO dif_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jesus nakaldra Kana ngurani Galilaiani wokarana wonti, woderi Nulu ngapandru waina ngankana paraia. ");
INSERT INTO dif_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ja kapakapara kulno nganana wonti, nunkani ngatamura muntja parana wonti Kapernaum ngurani. Nulu matja ngarana, Jesus Judaiandru Galilaiaia wokaranani, nau nunkangu wapana wonti ja ngatjina wonti, Nau ngarinanto ngatamura nunkani tepi ngankala; ngangau nau ngara wordu parana wonti. ");
INSERT INTO dif_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ja Jesus nunkangu jatana wonti: „Jura wata malka ja pirnala najinani, jura wata morlalu ngundranani.“ ");
INSERT INTO dif_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kapakapara nunkangu jatana wonti: „Kaparajai, ngariau, windrila kupa ngakani palinanto.“ ");
INSERT INTO dif_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesus nunkangu jatana wonti: „Tikamai, kupa jinkani matja tepi.“ Nulu nina jaura morlalu ngundrana wonti, nina Jesus nunkangu jatana wonti, ja tikana wonti. ");
INSERT INTO dif_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nau matja ngarina, mili nunkani nunkangu mandurina wonti, ja nunkangu kaukaubana wonti ja jatana wonti: „Kupa jinkani matja tepi.“ ");
INSERT INTO dif_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ja nulu tanangundru ditji jakalkana wonti nunkangu nau tepirila wiri; ja tana nunkangu jatana wonti: „Woldrawirdi toda muntjali nina worarala wiri.“ ");
INSERT INTO dif_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Jeruja ngaperali ngujamana wonti, jenia nunkangupini ditjini nganala wiri, nunkangu Jesus nunkangu jatala wiri: „Ngatamura jinkani matja tepi;“ ja nulu morlalu ngundrana wonti ja ngurala nunkani pratjana. ");
INSERT INTO dif_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Naupini malka mandrula nganai Jesujeli matja ngankana, matja Nau Judaiandru Galilaiani wokarana wonti. ");
INSERT INTO dif_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ngadani ditji pirna nganana wonti Juda kanani, ja Jesus tarana wonti Jerusalemia. ");
INSERT INTO dif_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalemingu tjipi manani panto kulno nganana wonti, nulu Juda kana talini Bethesda tala ngamalkana wonti, nunkangu punga mara wora nganana wonti. ");
INSERT INTO dif_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Tanangupini mandrani parana wonti muntja marapu, butju, tjunduru, jiranga, tanali kalkana wonti ngapa patijiritjinanto. ");
INSERT INTO dif_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ngangau angela kulno pota palpa pantuni ngarina wonti, ja nulu ngapa patijiritjibana wonti. Worana ngopera pantuni wirinani ngapa matja patijiritjinani, nau tepi pantjina wonti, mina muntja nulu ngamalkana wonti. ");
INSERT INTO dif_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Kana kulno naka nganana wonti, nau kilpawoldra 38 muntja parana wonti. ");
INSERT INTO dif_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ninapini Jesujeli paranani najina wonti, ja Nulu ngarana wonti, nau ditji marapu jeruja nganana, Nau nunkangu jatana wonti: „Jundru ngantjai tepi pantjila?“ ");
INSERT INTO dif_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Muntjali nunkangu kalabana wonti: „Kaparajai, ngato kana pani ngamalkai, nulu ngana pantuni worananto, ngapa matja patijiritjibana; ja ngani wokaranani kulno nguru ngakangu ngopera wiriai.“ ");
INSERT INTO dif_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesus nunkangu jatana wonti: „Jiritjiau, turarani piri jinkani maniau ja wirariau!“ ");
INSERT INTO dif_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ja nurujeli naupini kana tepirina wonti, ja nulu turarani piri nunkani manina wonti ja wirarina wonti. Ja naupini ditji Sabbat nganana wonti. ");
INSERT INTO dif_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Juda kana nunkangu muntjalani jatana wonti: „Karari Sabbat nganai; ja jenia jinkangu wata manuni kurala wapaia turarani piri jinkani waltananto.“ ");
INSERT INTO dif_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Nulu tanangu kalabana wonti: „Naupini, Nulu ngana tepi ngankana warai, ngakangu jatana warai: Turarani piri jinkani maniau ja wirariau!“ ");
INSERT INTO dif_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Tanali nina jakalkana wonti: „Worana Naupini kana, Nau jinkangu jatana warai: Turarani piri jinkani maniau ja wirariau!“ ");
INSERT INTO dif_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Naupini muntjala ko nganana wonti, worana Nau nganai, ngangau Jesus kutingana wonti, ngangau kana wolara nunkangupini pirini nganana wonti. ");
INSERT INTO dif_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ngadani Jesujeli nina Godaia pungani mankamankana wonti ja nunkangu jatana wonti: „Mai, jidni tepirina warai; wata morla madlentji ngankau, jinkangu morla madlentji wokaraiati.“ ");
INSERT INTO dif_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Naupini kana wapana wonti ja Juda kanani kaukaubana wonti: „Nau Jesus nganai, Nulu ngana tepi ngankana warai.“ ");
INSERT INTO dif_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ja Juda kana jendrangundruja Jesungu tirikaripaterina wonti ja wontjana wonti nina naria nandrala, ngangau Nulu jenia ngankana wonti Sabbatani. ");
INSERT INTO dif_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesujeli kalabana wonti ja tanangu jatana wonti: „Ngaperali ngakanali ngankai kararielu, ja ngato bakana ngankai.“ ");
INSERT INTO dif_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jendrangundruja Juda kanali morla wontjana wonti nina naria nandrala, ngangau Nulu wata windri Sabbat wokaribana wonti, a‐ai, Nulu bakana Goda Ngaperi nunkani dikana wonti, ja jeruja munta Goda jeribaka ngankaterina wonti. ");
INSERT INTO dif_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesujeli kalabana wonti ja tanangu jatana wonti: „Morlalu, morlalu, ngani jurangu jatai: Ngatamura munta ngandandariai ngankala, Nulu wata ngopera najinani Ngaperali ngankanani; ngangau mina Nulupini ngankai, jenia bakana Ngatamurajeli ngankai. ");
INSERT INTO dif_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ngangau Ngaperali Ngatamura ngantjai, ja Nulia pratjana nunkangu wondrai, mina Nulia muntali ngankai; ja ngankana morla pirna tanangu Nulia nunkangu wondrala nganai, jura ngaruparananto. ");
INSERT INTO dif_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ngangau worderu Ngaperali narila jiritjibai ja tepi ngankai; jeruja bakana Ngatamurajeli tepi ngankai tanangu Nauja jertapateriai. ");
INSERT INTO dif_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ngangau Ngaperali wata kulnuni kalala kurani, a‐ai, kalala kurani pratjana Nulia Ngatamurani jinkina wonti, ");
INSERT INTO dif_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ngangau pratjanali Ngatamura pirna ngundrananto, worderu tanali Ngaperi pirna ngundrai. Warlenulu Ngatamurani wata pirna ngundrai, nulu Npaperi wata pirna ngundrai, Nulia ninaia jinpanala. ");
INSERT INTO dif_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Morlalu, morlalu, ngani jurangu jatai: Warlenulu jaura ngakani ngarai, ja nunkangu morlalu ngundrai, Nulia ngana jinpanala, nulu tepi ngurali ngamalkai; ja kalalani nau wata wokarai, a‐ai, nau narindru tepia wiringana wonti. ");
INSERT INTO dif_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Morlalu, morlalu, ngani jurangu jatai: Ditji kulno wokarala nganai, ja matja karari nganai, narieli Godaia Ngatamuraia ngaiala ngarala nganai, ja tanali ngarai, tana tepirila nganai. ");
INSERT INTO dif_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ngangau worderu Ngaperali muntali nunkangu tepi ngamalkai, jeruja bakana Nulia Ngatamurani jinkina wonti, tepi muntali nunkangu ngamalkala. ");
INSERT INTO dif_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ja Nulia nunkangu ngurula jinkina wonti kalala kurananto; ngangau Nauja Kanaia Ngatamura nganai. ");
INSERT INTO dif_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Wata ngaruparanau nunkangupini; ngangau ditji kulno wokarai, nunkangupini pratjanali, tana nari kutuni parai ngaiala nunkani ngarala nganai, ");
INSERT INTO dif_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ja dunkala nganai, tanali ngumu ngankanala tepia terkakala nganai, ja tanali madlentji ngankanala terkakala nganai kalalaia. ");
INSERT INTO dif_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ngani ngandandariai muntali ngakangundru ngankala; a‐ai, worderu ngato ngarai, jeruka ngato kalala kurai; ja kalala kurani ngakani talku nganai, ngangau ngato wata ngakani jertapaterinali wontiai, a‐ai, windri nunkani jertapaterinali, Nulia ngana jinpanala. ");
INSERT INTO dif_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ngato ngakangundru muntali jaura ngamalkanani, jaura ngakani wata morlalu ngananani; ");
INSERT INTO dif_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Kulno nguru ngakangundru jaura jatai, ja ngani milkila, jaura nunkani morlalu nganai, ninaia Nulia ngakangundru jatai. ");
INSERT INTO dif_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Jura Johanningu jinpana paraia, ja nulu jaura jatana paraia morlaluja. ");
INSERT INTO dif_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ngato wata kanandru jaura morlalu maniai, a‐ai, jenia ngani jatai, jura kulkani ngamalkananto. ");
INSERT INTO dif_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Nau jerkini ja mintjini praitji nganana wonti; ja jura ngantjana paraia ditji ngalje murlali nganala praitjani nunkanani. ");
INSERT INTO dif_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ngato jaura morlalu morla pirna ngamalkai Johanningu; ngangau tananapini ngankana, tanana Ngaperali ngakangu jinkinala, ngato tanana mudananto, tananapini ngankana tanana ngato ngankai, ngakangundru morlalu jatai, Ngaperali ngana jinpanala. ");
INSERT INTO dif_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ja Ngaperali, Nulia ngana jinpanala, munta ngakangundru jaura morlalu jatana wonti. Jura wata ngaiala nunkani ngarana wonti, ja wata mudla nunkani najina wonti; ");
INSERT INTO dif_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ja jaura nunkani wata jurangu parala wapaia, ngangau ninaia, ninaia Nulia jinpanala, nunkangu jura wata morlalu ngundrai. ");
INSERT INTO dif_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Jura wontiai Godaia jaurani, ngangau jura ngundrai nunkangu tepi ngurali ngamalkala, ja tanapini nganai, tanana ngakangundru kaukaubai. ");
INSERT INTO dif_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ja jura wata ngantjai ngakangu wokarala tepi ngamalkala. ");
INSERT INTO dif_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Kanandru wata ngato pirnala maniai. ");
INSERT INTO dif_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ngato jurana ngujamai, jura wata Godaia ngantjana jurangu ngamalkai. ");
INSERT INTO dif_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ngani wokarana wonti Ngaperaia ngakanaia talani, ja jura ngana wata patai; kulno nguru wokaranani jurangu talani nunkanani, nina jura patala nganai. ");
INSERT INTO dif_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Worderu jura morlalu ngundrananto jura pirnala manijiribamaliai; ja kulnuja Godaia pirnala jura wata wontiai? ");
INSERT INTO dif_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Wata ngundranau ngani jurangundru ngulkuterkala nganai Ngaperani, a‐ai, Moses jurani ngulkuterkanietja nganai, nunkangu jura kalkani jurani kurana warai. ");
INSERT INTO dif_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ngangau jura Mosingu morlalu ngundranani, jura ngakangu morlalu ngundranani, ngangau nulu ngakangundru dakana wonti. ");
INSERT INTO dif_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Jura jaurani nunkanani wata morlalu ngundranani, worderu jura jaurani ngakanani morlalu ngundrananto?“ ");
INSERT INTO dif_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ngadani Jesus Galilaia ja Tiberias panto jerankaria pararana wonti. ");
INSERT INTO dif_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ja kana wolara nunkangu karipaterina wonti, ngangau tanali tanana malka najina wonti, tana Nulu muntjani ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ja Jesus mardawonpaia tarana wonti, ja naka Nau ngamana ngarina wonti nunkani milinto. ");
INSERT INTO dif_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ja Passa, Juda kanaia ditji pirna, karakara nganana wonti. ");
INSERT INTO dif_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesus milkieli pariparina wonti ja najina wonti kana wolara nunkangu jurborinani, Nau Philippungu jatana wonti: „Wodajerindru ngaiana buka burungankananto tanali tajinanto?“ ");
INSERT INTO dif_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jenia Nau jatana wonti nina wontjana; ngangau Nau munta milkila nganana wonti, mina Nau jertapaterina wonti ngankala. ");
INSERT INTO dif_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Philippulu nunkangu kalabana wonti: „200 mardatandrali buka tanangu wata matja nganai, pilkipilki kulnujeli tanangundru windri ngalje maniati.“ ");
INSERT INTO dif_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Mili kulno nunkani Andreas, Simon Petruni ngatata, nunkangu jatana wonti: ");
INSERT INTO dif_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","„Kanku kulno ninkida nganai, nulia buka ngunku mara wora ja paru mandru ngamalkai; ja mina jenia tanangu marapuni!“ ");
INSERT INTO dif_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesus jataua wonti: „Ngankanau kana wolara ngamana ngarinanto!“ Nunkangupini pirini kanta marapu nganana wonti. Ja kana 5000 ngamana ngarina wonti. ");
INSERT INTO dif_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesujeli buka patana wonti, ja Nulu jurakokana wonti, ja tanana milini jinkina wonti, ja milieli tanangu matja ngamana ngarina; jeruja bakana parundru, worderuntja tanali ngantjana wonti. ");
INSERT INTO dif_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Tana matja jerturina, Nau milini nunkanani jatana wonti: „Buka worduwordu kampanau, ngangau panila tintananto.“ ");
INSERT INTO dif_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Tanali kampana wonti, ja billi marapratjana ja mandru buka worduwordujeli manamiri ngankana wonti buka ngunku mara worandru, tanana, tanali matja tajina, pinpana wonti. ");
INSERT INTO dif_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Kana worali nina malka, Jesujeli ngankanani matja najina, tana jatana wonti: „Naupini morlalu Nauja Propheta nganni, Nauja mitani wokarananto!“ ");
INSERT INTO dif_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jesujeli matja ngujamana, tana jertapaterinani wokarala ja nina patala ja nina mitaia kapara ngankala, Nau nakaldra mardawonpaia kutingana wonti kulnulu. ");
INSERT INTO dif_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Matja kalkaurarina, mili nunkani pantuja ngarina wonti, ");
INSERT INTO dif_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ja tana botani wirina wonti ja ngapani Kapernaumia wapana wonti; ja matja ngalpuru ngananani, Jesus wata tanangu wokarana warai; ");
INSERT INTO dif_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ja panto patijiritjina wonti, ngangau watara pirna ngakana wonti. ");
INSERT INTO dif_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Tana Statia 25 kara, 30 kara worita wapana, tanali Jesus najina wonti ngapani wapanani ja botani karakara wokaranani; ja tana japali pantjina wonti. ");
INSERT INTO dif_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Nau tanangu jatana wonti: „Nganimata Nauja, wata japali ngananau.“ ");
INSERT INTO dif_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tana jertapaterina wonti nina botaia manila, ja nurujeli bota dirkalaia pararana wonti, wodajeri tana jertapaterinani pararala. ");
INSERT INTO dif_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ditji kulnuni, tanali kana wolarali panto dirkalani jerankari matja terkana, najina wonti, wata bota nguru naka nganala wiri, windri naupara kulnulu, ja Jesus wata milini nunkanani jela botani wirila wiri, a‐ai, windri mili nunkani pilki wapala wiri ");
INSERT INTO dif_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","— Bota nguru wokarana warai Tiberiandru nunkangupini pirini karakara, wodajeri tanali buka tajila wiri Kaparaia jurakokanandru—; ");
INSERT INTO dif_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Kana worali najina, Jesus wata ninkida ngananani, bakana wata mili nunkani, tana bakana bota worani wirina wonti, ja Kapernaum ngurani wokarana wonti Jesus wontila. ");
INSERT INTO dif_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ja tanali nina pantuni jerutajerra matja mankamankana tana nunkangu jatana wonti: „Rabbi, winta jidni ninkida wokarana warai?“ ");
INSERT INTO dif_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesujeli tanangu kalabana wonti ja jatana wonti: „Morlalu, morlalu, ngani jurangu jatai: Jura ngana wata wontiai, ngangau jura malka najila wiri, a‐ai, ngangau tanangupini bukandru jura tajila wiri ja jerturila wiri. ");
INSERT INTO dif_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Wata jenipara buka ngankanau jenia mudai, a‐ai, jenipara buka, jenia tepi nguralini parala nganai, ninapini Kanaia Ngatamurajeli jurangu jinkila nganai; ngangau Ninapini Goda Ngaperali morlalu kurana wonti.“ ");
INSERT INTO dif_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Tana nunkangu jatana wonti: „Mina ngaiani ngankananto Godaia ngankana ngankala?“ ");
INSERT INTO dif_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesujeli kalabana wonti ja tanangu jatana wonti: „Naupini Godaia ngankana nganai: Jura nunkangu morlalu ngundrananto, ninapini Nulia jinpanala.“ ");
INSERT INTO dif_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Tana nunkangu jatana wonti: „Mina malka jundru ngankai, ngaiani nina najinanto ja jinkangu morlalu ngundrananto? Mina jundru ngankai? ");
INSERT INTO dif_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ngaianini ngaperi worali pitarani Manna tajina wonti, worderu dakanala parai: Buka pariwilpandru Nulia tanangu tajinanto jinkina wonti.“ ");
INSERT INTO dif_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesus tanangu jatana wonti: „Morlalu, morlalu, ngani jurangu jatai: Wata Mosili jurangu buka pariwilpandru jinkina wonti, a‐ai, Ngaperali ngakanali jurangu buka morlalu pariwilpandru jinkiai. ");
INSERT INTO dif_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ngangau Godaia buka Nauja nganai, Naupini pariwilpandru ngariai, ja mitalani tepi jinkiai.“ ");
INSERT INTO dif_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tana nunkangu jatana wonti: „Kaparajai, milingeru ngaianingu ninapini buka jinkiau!“ ");
INSERT INTO dif_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesus tanangu jatana wonti: „Ngani tepia buka nganai; worana ngakangu wokarai nauja wata mauali pantjila nganai; ja warle ngakangu morlalu ngundrai, nauja wata morla tertieli pantjila nganai: ");
INSERT INTO dif_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ngani jurangu jatana warai: Jura ngana najina warai ja wata morlalu ngundrai. ");
INSERT INTO dif_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Pratjana mina Ngaperali ngakanali ngakangu jinkiai, ngakangu wokarala nganai, ja worana ngakangu wokarai, ninapini ngato wata narrala nganai. ");
INSERT INTO dif_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ngangau ngani pariwilpandru ngarina wonti wata ngakani jertapaterina ngankala, a‐ai, nunkani jertapaterina, Nulia ngana jinpanala. ");
INSERT INTO dif_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Jenia Ngaperaia jertapaterina nganai, Nulia ngana jinpanala: Ngato pratjanandru, mina Nulia ngakangu jinkinala, panila tintananto, a‐ai, ngato jenia ditjini ngadalani jiritjibananto. ");
INSERT INTO dif_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ngangau jenia Ngaperaia ngakanaia jertapaterina nganai: Warle Ngatamura najiai, ja nunkangu morlalu ngundrai, tepi ngurali ngamalkananto; ja ngato nina ditjini ngadalani jiritjibala nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Juda kana buljubuljurina wonti, ngangau Nau jatana warai: „Ngani jenipara buka nganai, Nau pariwilpandru matja ngarina.“ ");
INSERT INTO dif_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ja jatana wonti: „Naupini wata Jesus, Josephani ngatamura, nunkani ngaperi ja ngandri ngaiani ngujamai? Worderu Naupini jatai: Ngani pariwilpandru matja ngarina?“ ");
INSERT INTO dif_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesujeli kalabana wonti ja tanangu jatana wonti: „Wata buljubuljurilkijiribamalianau. ");
INSERT INTO dif_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Wata kulno ngurunguru nganai ngakangu wokarala, Ngaperali ngakanali, Nulia ngana matja jinpana, nina wata parumanani; ja ngato nina ditjini ngadalani jiritjibala nganai. ");
INSERT INTO dif_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Propheta worani dakanala parai: Ja tana pratjana jenipara nganala nganai, tanali Godandru ngujangujara matja manina; warletanali Ngaperandru matja ngarana ja kirina, ngakangu wokarai. ");
INSERT INTO dif_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Wata kulnujeli Ngapina najina warai, a‐ai, windri Nulia, Nauja Ngaperandru nganai, Nulia Ngapina matja najina. ");
INSERT INTO dif_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Morlalu, morlalu, ngani jurangu jatai: Warle ngakangu morlalu ngundrai, nulu tepi ngurali ngamalkai. ");
INSERT INTO dif_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ngani tepia buka nganai. ");
INSERT INTO dif_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ngaperi worali juranali pitarani Manna tajina wonti ja palina wonti. ");
INSERT INTO dif_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Naupini buka, pariwilpandru matja ngarina, jenipara nganai, tanali nunkangundru tajinanto ja wata palinanto. ");
INSERT INTO dif_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ngani tepia buka nganai, Naupini pariwilpandru matja ngarina; warle nunkangupini bukandru tajila nganai, nulu tepi ngamalkala nganai ngurali; Naupini buka, nina ngato jinkila nganai, ngani palku nganai, ninaia ngani jinkiterila nganai mitalaia tepini.“ ");
INSERT INTO dif_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Juda kana jatamalina wonti ja jatana wonti: „Worderu Nulupini ngaianingu palku nunkani jinkila nganai tajinanto?“ ");
INSERT INTO dif_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesus tanangu jatana wonti: „Morlalu, morlalu, ngani jurangu jatai: Jura wata Kanaia Ngatamuraia palku tajinani, ja kumari nunkani tapanani, jura wata tepi jurangu ngamalkanani. ");
INSERT INTO dif_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Warle ngana palku tajiai, ja ngana kumari tapai, nulu tepi ngurali ngamalkai, ja ngato nina ditjini ngadalani jiritjibala nganai. ");
INSERT INTO dif_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ngangau ngani palku buka morlalu nganai, ja ngani kumari tapani morlalu. ");
INSERT INTO dif_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Warle ngana palku tajiai, ja ngana kumari tapai, nau ngakangu ngamai ja ngani nunkangu. ");
INSERT INTO dif_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Worderu ngana Ngaperi tepieli jinpanala, ja ngani Ngaperandru tepi nganai; jeruja bakana warle ngana tajiai, nau ngakangundru tepi ngamala nganai. ");
INSERT INTO dif_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Naupini jenipara buka nganai, Nauja pariwilpandru matja ngarina; wata jeruja worderu ngaperi worali juranali Manna tajina wonti ja palina wonti; warle ninapini buka tajiai, nau ngurali tepi ngamala nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Tananapini Nau jatana wonti, Nulu Kapernaum jaura pungani ngujangujara jinkina. ");
INSERT INTO dif_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Mili nunkani marapujeli jenia matja ngarana, tana jatana wonti: „Naupini jaura ngurunguru nganai, worana ngurunguru nganai nina ngarala?“ ");
INSERT INTO dif_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesujeli muntali matja ngujamana, mili nunkani jendrangundruja buljubuljurinani, Nau tanangu jatana wonti: „Jendrangundruja jura kintjakintjariai? ");
INSERT INTO dif_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Jura najinani Kanaia Ngatamura taranani, wodajeri Nauja ngopera nganana wonti? ");
INSERT INTO dif_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Jaola nganai, Nulia tepi ngankai, palku baku nganai; Tananapini jaura, ngato jurangu kaukaubana warai; Jaola ja Tepi tanapini nganai. ");
INSERT INTO dif_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ja palpa jurangundru nganai, tanali wata morlalu ngundrai.“ Ngangau Jesus ngoperandru milkila nganana wonti, warletana nganai, tanali wata morlalu ngundrai, ja warle nina wontawontala nganai. ");
INSERT INTO dif_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ja Nau jatana wonti: „Jendrangundruja ngani jurangu jatana warai: Wata kulno ngurunguru nganai ngakangu wokarala, nunkangu ngopera wata jinkinala Ngaperandru.“ ");
INSERT INTO dif_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Jendrangundruja mili nunkani marapu tikana wonti, ja wata morla nunkangunto wirarina wonti. ");
INSERT INTO dif_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jesus marapratjana ja mandruni jatana wonti: „Jura bakana jertapateriai ngakangundru wapana kurala?“ ");
INSERT INTO dif_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Petrulu nunkangu kalabana wonti: „Kaparajai, worangula ngaiani wapananto? Jundru tepi nguralia jaura ngamalkai, ");
INSERT INTO dif_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ja ngaiani morlalu ngundrana warai ja ngujamana warai, jidni Christus Goda tepia Ngatamura nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesujeli tanangu kalabana wonti: „Wata ngato jurana marapratjana ja mandru ngakani kalkalkana wonti? Ja kulno jurangundru kutji nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Nulu Judas Ischariot Simoni ngatamura ngundrana wonti, ngangau nulupini nina wontawontananto, ja nau marapratjana ja mandrundru kulno nganana wonti. ");
INSERT INTO dif_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ja ngadani Jesus Galilaiani wirarina wonti; ngangau Nulu wata ngantjana wonti Judaiani wirarila, ngangau Juda kanali nina wontina wonti naria nandrala. ");
INSERT INTO dif_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Juda kanaia pungawalpaia ditji pirna karakara nganana wonti. ");
INSERT INTO dif_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Tana ngatata nunkani nunkangu jatana wonti: „Ninkidandru puntiau ja Judaiaia wapau, ngangau bakana milieli jinkanali ngankana jinkani najinanto, tananaia jundru ngankai. ");
INSERT INTO dif_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ngangau wata kulnujeli kurukuru ngankai, ja wontiteriai tinkari pantjinanto. Jundru jenia ngankanani mitalani wondrateriau.“ ");
INSERT INTO dif_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ngangau bakana ngatatajeli nunkanali nunkangu wata morlalu ngundrana wonti. ");
INSERT INTO dif_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesus tanangu jatana wonti: „Miljaru ngakani wata wokarana warai, ditji jurani milingeru nganai. ");
INSERT INTO dif_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Mitala ngandandariai jurangu kalakalarila; ngakangu tana kalakalariai, ngangau ngato tanangundru jaura morlalu kurai, ngankana tanani madlentji nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Jura nunkangupini ditji pirnaia taranau; ngani wata nunkangupini ditji pirnaia tarai, ngangau miljaru ngakani wata kantji wokarana warai. ");
INSERT INTO dif_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Nau tananapini tanangu matja jatana, Nau Galilaiani ngamantina wonti. ");
INSERT INTO dif_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ngatata nunkani matja tarana, ngadani Nau bakana ditji pirnaia tarana wonti, wata kantji, a‐ai, kurukuru jeri. ");
INSERT INTO dif_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Juda kanali nina wontina wonti ditji pirnani ja jatana wonti: „Wodajeri Nau?“ ");
INSERT INTO dif_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Kana wolara marapujeli nunkangundru buljubuljurilkijiribamalina wonti. Palpa jatana wonti: „Nau ngumu nganai;“ palpa jatana wonti: „Pani, Nulu kana wolara karkarkai.“ ");
INSERT INTO dif_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Wata kulno nunkangundru tinkari jatana wonti, ngangau tana Juda kanandru japali nganana wonti. ");
INSERT INTO dif_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ditji pirna worani terti Jesus Godaia pungani tarana wonti ja ngujangujara jinkina wonti. ");
INSERT INTO dif_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ja Juda kana ngaruparana wonti ja jatana wonti: „Worderu Nulupini jauraia kirila ngujamai, wata Nauja ninaia kirina warai?“ ");
INSERT INTO dif_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesujeli tanangu kalabana wonti ja jatana wonti: „Ngakani ngujangujara wata ngakani nganai, a‐ai, nunkani, Nulia ngana jinpanala. ");
INSERT INTO dif_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Kulnujeli ngantjanani nunkani jertapaterina ngankala, nulupini ngujamala nganai, naupini ngujangujara Godandru ngananani kara, ngato ngakangundru muntali kaukaubanani kara. ");
INSERT INTO dif_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Warle nunkangundru muntali kaukaubai, nulu pirnala nunkani wontiai; warle nunkanipini pirnala wontiai, Nulia ninaia jinpanala, Nauja morlalu nganai, ja madlentji wata nunkangu nganai. ");
INSERT INTO dif_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Wata Mosili jurangu jirijiribani jaura jinkina wonti? Ja wata kulnujeli jurangundru jirijiribani jaurani pankiai; Minandru jura wontiai ngana naria nandrala?“ ");
INSERT INTO dif_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Kana wolarali kalabana wonti ja jatana wonti: „Jundru kutji ngamalkai; warle wontiai, jidna naria nandrala?“ ");
INSERT INTO dif_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesujeli kalabana wonti ja tanangu jatana wonti: „Ngankana kulno ngato ngankana warai, ja jura pratjana ngaruparai. ");
INSERT INTO dif_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Jendrangundruja, ngangau Mosili jurangu kaluwali ngankani jinkina wonti, — nau wata Mosingundru, a‐ai, ngaperi worandru — jura bakana Sabbatani karuwali ngankai. ");
INSERT INTO dif_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kana kulnujeli karuwali ngankala Sabbatani maninani, ngangau Mosini jirijiribani jaura wata wokaribananto; ngakangu jura tiririai, ngangau ngato kana kulno tepi ngankana warai Sabbatani? ");
INSERT INTO dif_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Wata kalala kuranau milkieli najinandru, a‐ai, kalala talku kuranau?“ ");
INSERT INTO dif_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jerusalemala palpa jatana wonti: „Wata Naupini Nauja nganai, ninaia tanali wontiai naria nandrala? ");
INSERT INTO dif_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ja mai, Nulia tinkari kaukaubai, ja tana nunkangu panila jatai. Kana kaparali morlalu ngujamana warai, Naupini Christus nganai? ");
INSERT INTO dif_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ninapini ngaiani ngujamai wodajerindru Nauja nganai; Christus wokaranani, wata kulnujeli ngujamala nganai, wodajerindru Nau nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jendranguta Jesus Godaia pungani parparali maritjina wonti ja ngujangujara jinkina wonti ja jatana wonti: „Kau, jura ngana ngujamai, ja bakana milkila wodajerindru ngani nganai; ja ngani wata ngakangundru munta wokarana wonti, a‐ai, Naupini morlalu nganai, Nulia ngana jinpanala, ninapini jura wata ngujamai: ");
INSERT INTO dif_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ngato ninaia ngujamai; ngangau ngani nunkangundru nganai, ja Nulia ngana jinpanala.“ ");
INSERT INTO dif_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Tanali wontina wonti nina patala, ja wata kulnujeli mara nunkangu kurana wonti; ngangau ditji nunkani wata kantji wokarana warai. ");
INSERT INTO dif_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Marapujeli kana wolarandru nunkangu morlalu ngundrana wonti ja jatana wonti: „Christus wokaranani, Nulu morla malka ngankala nganai, Nulupini matja ngankana warai?“ ");
INSERT INTO dif_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Pharisaiali ngarana wonti kana wolarali jenia nunkangundru buljubuljurilkijiribamalinani. Ja Priesta pirnali ja Pharisaiali mili jinpana wonti nina patananto. ");
INSERT INTO dif_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesus tanangu jatana wonti: „Windri miljaru wordu morla ngani jurangunto nganai, ja ngani nunkangu wapala nganai, Nulia ngana jinpanala. ");
INSERT INTO dif_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Jura ngana wontila nganai ja wata mankamankala nganai; ja wodajeri ngani nganai, nakani jura ngandandariai wokarala.“ ");
INSERT INTO dif_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Juda kana ngankamalina wonti: „Wodajeri Nulupini ngantjai palkala, ngangau ngaiani ninaia wata mankamankananto? Nulia ngantjai Griekani wapala, tana tjautjau ngamai, Griekani ngujangujara jinkila? ");
INSERT INTO dif_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Mina nulupini jaurali wondrai, ninapini Nauja jatana warai: Jura ngana wontila nganai ja wata mankamankala nganai; ja: Wodajeri ngani nganai, nakani jura ngandandariai wokarala?“ ");
INSERT INTO dif_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ditji pirnaia mudani ditjini, nau morla pirna nganana wonti, Jesus terkana wonti ja maritjina wonti ja jatana wonti: „Worana tertieli nganai, nau ngakangu wokaraiatimai ja tapaiatimai! ");
INSERT INTO dif_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Warle ngakangu morlalu ngundrai, worderu jaura jatai: Nunkani palkundru tepia ngapa kaiari ngakala nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jenia Nau Jaolandru jatana wonti, nina tanali maninanto, tana nunkangu morlalu ngundrai; ngangau jendranguta Jaola kulikiri wata kantji wokarana wonti, ngangau Jesus wata pirnala nunkani manina wonti. ");
INSERT INTO dif_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Kana wolarandru marapu, tanali tananapini jaura matja ngarana, jatana wonti: „Naupini morlalu Naupara Propheta nganai!“ ");
INSERT INTO dif_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Palpa jatana wonti: „Naupini Christus nganai;“ palpa jatana wonti: „Wata Galilaiandru Christus wokarai? ");
INSERT INTO dif_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Wata Godaia jaura jatai: Davidani ngatamurandru, ja Bethlehem ngura wakandru, wodajeri David nganana wonti, Christus wokarala nganai?“ ");
INSERT INTO dif_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Jeruja kana wolara tidatida ngankijiribamalina wonti nunkangundru. ");
INSERT INTO dif_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Palpali tanangundru ngantjana wonti nina patala, ja wata kulnujeli mara nunkangu kurana wonti. ");
INSERT INTO dif_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Mili Priesta pirnani ja Pharisaiani wokarana wonti, ja tana tanangu jatana wonti: „Minandru jura nina wata padakana warai?“ ");
INSERT INTO dif_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Milieli kalabana wonti: „Wata pota kulno kana kulnujeli kaukaubana warai, Nulupini kanali jeribaka.“ ");
INSERT INTO dif_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Pharisaiali tanangu kalabana wonti: „Nulu jurana bakana karkarkana warai? ");
INSERT INTO dif_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Kapara kulnujeli kara Pharisaia kulnujeli kara nunkangu morlalu ngundrai? ");
INSERT INTO dif_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","A‐ai, windri tanapini kana wolara, tanali jirijiribani jaura wata ngujamai; jakajai tanangu.“ ");
INSERT INTO dif_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodemus tanangu jatana wonti, nau tinkani nunkangu wokarana paraia, ja kulno tanangundru nganana wonti: ");
INSERT INTO dif_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","„Ngaianani jirijiribani jaurali wata kana kulnuni kalala kurai, nina wata ngopera ngaranani ja ngujamanani mina nulu ngankai?“ ");
INSERT INTO dif_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Tanali kalabana wonti ja nunkangu jatana wonti: „Jidni bakana Galilaiala nganai? Wontjamai ja najiamai, Galilaiandru wata Propheta terkakala nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ja pratjana pungaia tananaia wapana wonti. ");
INSERT INTO dif_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesus maninindri mardawonpaia wapana wonti. ");
INSERT INTO dif_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Dankudankubana Nau nakaldra Godaia pungani wokarana wonti, ja kana wolara nunkangu wokarana wonti, ja Nau ngamana ngarina wonti ja tanangu ngujangujara jinkina wonti. ");
INSERT INTO dif_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Jaura jinkinietjali ja Pharisaiali widla kulno nunkangu wapalkana wonti, tanali nana pinta wokaribanani matja patana, ja nana terti terkibana wonti, ");
INSERT INTO dif_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ja nunkangu jatana wonti: „Ngujangujara jinkinietjajai, nanapini widla tanali patana warai morlalu pinta wokaribanani. ");
INSERT INTO dif_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mosili jirijiribani jaurani ngaianingu jirijiribana wonti, jenipara mardali dakananto, mina jidni jatai?“ ");
INSERT INTO dif_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Jenia tana nunkangu jatana wonti nina wontjala, ngangau tanali palpa ngamalkananto nunkangundru ngulkuterkala. Jesus buruna ngarina wonti ja marawutjujeli mitani dakana wonti. ");
INSERT INTO dif_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ngangau tana nina milingeru jakalkanani, Nau miririna tarana wonti ja tanangu jatana wonti: „Warle jurangundru madlentji pani ngani, nulia marda ngoperalali nanaia dakananto.“ ");
INSERT INTO dif_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ja nakaldra Nau buruna ngarina wonti ja mitani dakana wonti. ");
INSERT INTO dif_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Tanali jenia matja ngarana, burka tanangu ngulkuterkana wonti, ja tana dunkana wonti kulnulu kulnulu, pinarandru wonina nakajelu; ja Jesus kulnulu ngamana wonti, ja widla terti terkantinani. ");
INSERT INTO dif_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jesus miririna tarana wonti, ja ngangau Nulu wata kulno najina wonti windri nana widla, Nau nankangu jatana wonti: „Widlajai, woderi jinkani tana ngulkuterkanietja? Wata kulnujeli jinkangu kalala jinkina warai?“ ");
INSERT INTO dif_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Nani jatana wonti: „Wata kulnujeli Kaparajai!“ Jesus nankangu jatana wonti: „Jeruja bakana ngato jinkangu wata kalala kurala nganai; wapau, ja wata morla madlentji ngankau!“ ");
INSERT INTO dif_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Nakaldra Jesujeli tanangu kaukaubana wonti ja jatana wonti: „Ngani mitaia praitji nganai; worana ngakangu karipaterila nganai, nau wata ngalpurani wirarila nganai, a‐ai, nulu tepia praitji ngamalkala nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Pharisaia nunkangu jatana wonti: „Jidni jinkangundru munta tinkari ngankateriai; tinkari ngankani jinkani wata morlalu nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesujeli kalabana wonti ja tanangu jatana wonti: „Bakana ngato ngakangundru muntali tinkari ngankanani, tinkari ngankani ngakani morlalu nganai, ngangau ngani milkila wodajerindru ngani wokarana wonti ja wodajeri ngani wapala nganai; jura wata milkila wodajerindru ngani wokarai ja wodajeri ngani wapai. ");
INSERT INTO dif_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Jura palkundru kalala kurai: ngato wata kulnuni kalala kurai. ");
INSERT INTO dif_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ja ngato bakana kalala kuranani, kalala kurani ngakani morlalu ngangai; ngangau ngani wata kulnulu nganai, a‐ai, ngani ja Ngaperi Nulia ngana jinpanala. ");
INSERT INTO dif_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ja bakana jurani jirijiribani jaurani dakanala parai: Kana mandruja tinkari ngankani morlalu nganai. ");
INSERT INTO dif_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ngato ngakangundru muntali tinkari ngankai, ja Ngaperali, Nulia ngana jinpanala, ngakangundru tinkari ngankai.“ ");
INSERT INTO dif_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Tana nunkangu jatana wonti: „Woderi Ngaperi jinkani nganai?“ Jesujeli kalabana wonti: „Jura wata ngana ja wata Ngaperi ngakani ngujamai; jura ngana ngujamanani, jura bakana Ngaperi ngakani ngujamanani.“ ");
INSERT INTO dif_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Tananapini jaura Jesujeli mardatandra kokuni karakara jatana wonti, Nulu Godaia pungani ngujangujara jinkinani; ja wata kulnujeli nina patana wonti, ngangau ditji nunkani wata kantji wokarana warai. ");
INSERT INTO dif_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesus nakaldra tanangu jatana wonti: „Ngani wapai, ja jura ngana wontila nganai, ja madlentjani juranani jura palila nganai; wodajeri ngani wapai, naka jura ngandandariai wokarala.“ ");
INSERT INTO dif_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Juda kana jatana wonti: „Nulia ngantjai kara munta nari ngankaterila, ngangau Nau jatai: Wodajeri ngani wapai, naka jura ngandandariai wokarala?“ ");
INSERT INTO dif_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ja Nau tanangu jatana wonti: „Jura ngarinalundru nganai, ngani mirindru nganai; jura nunkangupini mitandru nganai, ngani wata nunkangupini mitandru nganai. ");
INSERT INTO dif_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ngani jurangu matja jatana warai, jura madlentjani juranani palila nganai; ngangau jura wata morlalu ngundranani ngani Nauja nganai, jura madlentjani juranani palila nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Tana nunkangu jatana wonti: „Worana jidni nganai?“ Ja Jesus tanangu jatana wonti: „Ngopera jenia, mina ngani jurangu jatai. ");
INSERT INTO dif_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Marapu ngato ngamalkai jurangundru jatala ja kalala kurala; ja Nauja, Nulia ngana jinpanala, morlalu nganai, ja mina ngato nunkangundru ngarana wonti, jena ngato mitalani kaukaubai.“ ");
INSERT INTO dif_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Tanali wata ngujamana wonti, Nau tanangu Ngaperandru jatanani. ");
INSERT INTO dif_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Jesus tanangu jatana wonti: „Jura Kanaia Ngatamura matja miri ngankana warai, ngadani jura ngujamala nganai ngani Nauja nganai, ja ngato muntali panila ngankai, a‐ai, worderu Ngaperali ngakangu ngujangujara jinkina wonti, jenia ngato kaukaubai. ");
INSERT INTO dif_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ja Nulia ngana jinpanala, Naupini ngakangunto nganai; ja Ngaperali ngana wata kulnulu worarai, ngangau ngato milingeru ngankai, mina Nulia ngantjai.“ ");
INSERT INTO dif_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Nulu jenia kaukaubanani, marapujeli nunkangu morlalu ngundrana wonti. ");
INSERT INTO dif_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jesus tanangu Juda kanani, tanali nunkangu morlalu ngundranani, jatana wonti: „Jura jaurani ngakanani wonki ngamanani, jura morlalu mili ngakani ngananani, ");
INSERT INTO dif_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ja jura morlaluta ngujamala nganai, ja morlalulali jurana kurakala nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Tanali nunkangu kalabana wonti: „Abrahamani ngatamura ngaiani nganai, ja wata pota kulno ngaiani kulnuja mili nganana wonti; worderu jidni jatai: «Jura kurakanila pantjinanto?»“ ");
INSERT INTO dif_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesujeli tanangu kalabana wonti: „Morlalu, morlalu, ngani jurangu jatai: Warle madlentji ngankai, nau madlentjaia mili nganai. ");
INSERT INTO dif_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mili wata ngurali pungani ngamai; Ngatamura ngurali ngamai. ");
INSERT INTO dif_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ngatamurajeli jurana kurakanani, jura kantji kurakanila nganala nganai. ");
INSERT INTO dif_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ngani milkila jura Abrahamani ngatamura nganai; ja jura wontiai ngana naria nandrala, ngangau jaura ngakani wata jurangu wiriai. ");
INSERT INTO dif_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ngato kaukaubai, mina ngato Ngaperani ngakanani najina wonti; ja jura ngankai, mina jura ngaperani juranani najina warai.“ ");
INSERT INTO dif_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Tanali nunkangu kalabana wonti ja jatana wonti: „Ngaperi ngaianini Abraham nganai.“ Jesus tanangu jatana wonti: „Jura Abrahamani kupa ngananani, jura bakana Abrahamani ngankana ngankananto. ");
INSERT INTO dif_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Karari jura ngana wontiai naria nandrala, jenipara kana Nulia jurangu morlalu kaukaubana warai, nina ngato Godandru ngarana wonti; jenia Abrahamali wata ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Jura ngaperaia juranaia ngankani ngankai.“ Tana nunkangu jatana wonti: „Ngaiani wata palakantjindru dankana wonti; Ngaperi kulno ngaiani ngamalkai, ninaia Goda.“ ");
INSERT INTO dif_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesus tanangu jatana wonti: „Goda Ngaperi jurani ngananani, jura ngana ngantjanani; ngangau ngani Godandru dunkana wonti ja wokarana wonti, ngangau bakana ngani wata munta wokarana wonti, a‐ai, Nulia ngana jinpanala. ");
INSERT INTO dif_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Minandru jura jaura ngakani wata ngujamai? Ngangau jura ngandandariai jaura ngakani ngarala. ");
INSERT INTO dif_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Jura ngaperi kutjindru nganai, ja ngaperaia juranaia jertapaterina jura jertapateriai ngankala. Naupini kananandranietja ngoperandru nganana wonti, ja morlalulani nau wata terkai, ngangau morlalula wata nunkangu nganai. Nau jedi jatanani, nulu nunkangundru munta jatai, ngangau nau jedikantji nganai ja nunkanipini ngaperi. ");
INSERT INTO dif_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ngangau ngani jurangu jatai, jura ngakangu wata morlalu ngundrai. ");
INSERT INTO dif_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Warle jurangundru ngakangu madlentji kulno wondrai? Ngani morlaluta jatanani, minandru jura ngakangu wata morlalu ngundrai? ");
INSERT INTO dif_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Worana Godandru nganai, nulu Godaia jaura ngarai; jendrangundruja jura wata ngarai, ngangau jura wata Godandru nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Juda kanali kalabana wonti ja nunkangu jatana wonti: „Ngaiani wata talku jatai, jidni Samarita kana nganai ja kutji ngamalkai?“ ");
INSERT INTO dif_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesujeli kalabana wonti: „Ngato wata kutji ngamalkai, a‐ai, ngato Ngaperi ngakani pirna ngundrai, ja jura ngana wata pirna ngundrai. ");
INSERT INTO dif_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ngato wata pirnala ngakani wontiai; Kulno nganai, Nulupini ninaia wontiai ja kalala kurai. ");
INSERT INTO dif_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Morlalu, morlalu, ngani jurangu jatai: Kulnujeli jaura ngakani ngamalkanani, nulu ngurali wata nari najila nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Juda kana nunkangu jatana wonti: „Karari ngaiani ngujamai, jundru kutji ngamalkai; Abraham ja Propheta palina wonti, ja jidni jatai: Kulnujeli jaura ngakani ngamalkanani, nulu ngurali wata nari najila nganai. ");
INSERT INTO dif_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Jidni morla pirna nganai ngaianini ngaperani Abrahamangu, nau palina wonti? Ja Propheta wora palina wonti; worana jidni munta ngankateriai?“ ");
INSERT INTO dif_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesujeli kalabana wonti: „Ngani munta pirna ngankaterinani pirnala ngakani pani nganai; Ngaperali ngakanali ngana pirna ngankai, nunkangundru jura jatai, Nauja Goda jurani nganai. ");
INSERT INTO dif_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ja jura ninaia wata ngujamana warai; ngato ninaia ngujamai; ja ngani jatanani, ngato ninaia wata ngujamai, ngani jedikantji nganala nganai jurangu jeribaka; ngato ninaia ngujamai, ja jaura nunkani ngato ngamalkai. ");
INSERT INTO dif_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abraham ngaperi jurani murlali pantjina wonti ditji ngakani najila; ja nulu nina najina wonti ja mankina wonti.“ ");
INSERT INTO dif_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Juda kana nunkangu jatana wonti: „Jidni wata kilpawoldra 50 nganai? Ja jundru Abraham najina wonti.“ ");
INSERT INTO dif_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesus tanangu jatana wonti: „Morlalu, morlalu, ngani jurangu jatai: Morla ngopera Abrahamangu ngani nganana wonti.“ ");
INSERT INTO dif_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tanali marda patana wonti nina dakananto. Jesus kurukurumalkaterina wonti ja Godaia pungandru dunkana wonti, tanangu terti palkingana tarana. ");
INSERT INTO dif_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ja Nau wiringanani, Nulu kana kulno najina wonti, nau butju nganana wonti kupandru. ");
INSERT INTO dif_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ja milieli nunkanali nina jakalkana wonti ja jatana wonti: „Rabbi, warle madlentji ngankana wonti, nulupini kara, ngaperali ja ngandrieli nunkanali kara, ngangau nauja butju dankana wonti.“ ");
INSERT INTO dif_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesujeli kalabana wonti: „Wata nulupini madlentji ngankana wonti, bakana wata ngaperali ja ngandrieli nunkanali, a‐ai, Godaia ngankana nunkangu wondraterinanto. ");
INSERT INTO dif_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ngato nunkanipini ngankani ngankananto, Nulia ngana jinpanala, jeruntja ditjiwirdi ngananani; tinka wokarala nganai, nunkangupini kana warupoto ngandandarila nganai ngankala. ");
INSERT INTO dif_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Wintaranaia ngani mitani nganai, ngani mitaia praitji nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Nau jenia matja jatana, Nulu mitani ngaltja worana wonti ja ngaltjandru buluru ngankingana wonti, ja nina buluru butjuni milkini kurana wonti, ");
INSERT INTO dif_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ja nunkangu jatana wonti: „Wapau, ja Siloa pantuni kulirkateriau!“ Jenia wondrai: „Matja jinpana.“ Nau wapana wonti ja kulirkaterina wonti ja najila tikana wonti. ");
INSERT INTO dif_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Jenimalinietja, ja tana nina ngopera najina wonti potuni ngatjinani, jatana wonti: „Wata naupini nauja nganai, nauja ngamana warai potuni ngatjila?“ ");
INSERT INTO dif_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Palpa jatana wonti: „Nauja naumata nganai;“ palpa: „Nauja nunkangu jeribaka;“ nau munta jatana wonti: „Ngani nauja nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Tana nunkangu jatana wonti: „Worderu milki jinkani piririna warai?“ ");
INSERT INTO dif_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Nulu kalabana wonti ja jatana wonti: „Kana kulnujeli, tala nunkani Jesus, buluru ngankingana warai ja nina ngakangu milkini kurana warai ja ngakangu jatana warai: Siloah pantuja wapau ja kulirkateriau. Ngani wapana warai ja kulirkaterina warai ja kantji najina warai.“ ");
INSERT INTO dif_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Tana nunkangu jatana wonti: „Woderi Naupara nganai?“ Nau jatana wonti: „Nganako.“ ");
INSERT INTO dif_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Tanali nina, nau ngopera butju nganana warai, Pharisaiaia wapalkana wonti. ");
INSERT INTO dif_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jendranguta Sabbat nganana wonti, Jesujeli nina buluru ngankinganani ja milki nunkani piri ngankanani. ");
INSERT INTO dif_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Nakaldra nina bakana Pharisaiali jakalkana wonti, worderu nulu nakaldra najina warai. Nau tanangu jatana wonti: „Buluru Nulu ngakangu milkini kurana warai, ja ngani kulirkaterina warai, ja ngato kantji najiai.“ ");
INSERT INTO dif_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Pharisaia palpa jatana wonti: „Naupini kana wata Godandru nganai, ngangau Nulu Sabbat wata kulikiri ngamalkai.“ Palpa jatana wonti: „Worderu kana madlentji ngurungunu nganai jenia malka ngankala?“ Ja tana tidatida ngankijiribamalina wonti. ");
INSERT INTO dif_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Nakaldra tana butjuni jatana wonti: „Mina jidni nunkangundru jatai, ngangau Nulu milki jinkani piri ngankana warai?“ Nau jatana wonti: „Nau Propheta nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Juda kanali nunkangu, nau butju nganana warai ja nakaldra najina warai, wata morlalu ngundrana wonti, tanali nunkanipini, nulu nakaldra najina warai, ngaperi ja ngandri karkanantulu. ");
INSERT INTO dif_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ja tanali pudlana jakalkana wonti ja jatana wonti: „Naupini judlani kupa nganai, nunkangundru judla jatai, nau butju dankanala? Worderu jenia pantjina warai, ngangau nulia karari najiai?“ ");
INSERT INTO dif_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ngaperali ja ngandrieli nunkanali tanangu kalabana wonti ja jatana wonti: „Ngali milkila, naupini ngalini kupa nganai, ja nauja butju dankanala; ");
INSERT INTO dif_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Worderu nulia karari kantji najiai ngali ko; warle milki nunkani piri ngankana warai, ngali ko; nauja munta pirna nganai, ninaia munta jakalkanau, nauja nunkangundru muntali kalabananto.“ ");
INSERT INTO dif_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Jenia ngaperi ja ngandri nunkani jatana wonti, ngangau pudla Juda kanandru japali nganana wonti; ngangau Juda kana kulnukulnuni nganana wonti, warle nina Christus dikanani, nina tanali Godaia milindru worala nganai. ");
INSERT INTO dif_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Jendrangundruja ngaperi ja ngandri nunkani jatana wonti: „Nauja munta pirna nganai, ninaia munta jakalkanau.“ ");
INSERT INTO dif_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Tanali nina kana, nau butju nganana warai, nakaldra pota mandrula karkana wonti ja nunkangu jatana wonti: „Godani pirna ngundrau!“ ngaiani milkila, Naupini kana madlentji nganai. ");
INSERT INTO dif_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nulu kalabana wonti ja jatana wonti: „Nau kana madlentji nganai kara, ngani ko; kulno ngato milkila, ngani butju nganana warai ja karari nakaldra najiai.“ ");
INSERT INTO dif_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Tana nakaldra nunkangu jatana wonti: „Mina Nulu jinkangu ngankana warai? Worderu Nulu milki jinkani piri ngankana warai?“ ");
INSERT INTO dif_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Nulu tanangu kalabana wonti: „Ngani jurangu matja jatana warai ja jura bulu ngarana warai. Minandru jura jenia nakaldra ngarananto? Jura bakana ngantjai mili nunkani pantjila?“ ");
INSERT INTO dif_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tana nunkangu kaldririna wonti ja jatana wonti: „Jidni mili nunkani nganai, ngaiani Mosini mili nganai. ");
INSERT INTO dif_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ngaiani milkila, Godali Mosingu kaukaubana wonti; nunkangundru ngaiani ko nganai, wodajerindru Nau nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Nulupini kanali tanangu kalabana wonti ja jatana wonti: „Jenia ngaruparana nganai, ngangau jura ko wodajerindru Nau nganai, ja Nulu milki ngakani piri ngankana warai. ");
INSERT INTO dif_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ngaiani milkila, Godali kana madlentji wata ngarai, a‐ai, kulno Godandru japali ngananani ja jertapaterina nunkani ngankanani, nina Nulia ngarai. ");
INSERT INTO dif_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nguralindru (tanali) wata ngarana wonti, kulnujeli kana butjuja milki, nau butju dankanala, piri ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Naupini wata Godandru ngananani, Nau ngandandarinani jenia ngankala.“ ");
INSERT INTO dif_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Tanali kalabana wonti ja nunkangu jatana wonti: „Madlentjani jidni dankanala, ja jundru ngaianingu ngujangujara jinkiai?“ Ja tanali nina tertubana wonti palaraia. ");
INSERT INTO dif_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesujeli matja ngarana, tanali nina narrana warai, ja Nulu nina matja mankamankana, Nau nunkangu jatana wonti: „Jundru Godaia Ngatamurani morlalu ngundrai?“ ");
INSERT INTO dif_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Nulu kalabana wonti ja jatana wonti: „Worana Nau nganai, Kaparajai, ngato nunkangu morlalu ngundrananto?“ ");
INSERT INTO dif_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesus nunkangu jatana wonti: „Jundru nina najina warai, ja Nulia jinkangu ngankamalila wapaia, Naumata Nauja nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Nau jatana wonti: „Kaparajai, ngato morlalu ngundrai;“ ja nau nunkangu pantjaterkana ngarina wonti. ");
INSERT INTO dif_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ja Jesus jatana wonti: „Ngani nunkangupini mitani wokaranala puntibala; ngangau tanali wata najiai najinanto, ja tanali najiai butjurinanto.“ ");
INSERT INTO dif_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ja jenia Pharisaia palpali, tana nunkangunto ngananani, ngarana wonti ja nunkangu jatana wonti: „Ngaiani bakana butju nganai kara?“ ");
INSERT INTO dif_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesus tanangu jatana wonti: „Jura butju ngananani, jura wata madlentji ngamalkanani; karari jura jatai: Ngaiani najiai; jeruja madlentji jurani parala nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Morlalu, morlalu, ngani jurangu jatai: „Warle wata manani wiriai tjipi jaruni, a‐ai, pilki dankaranani, nau kurikantji ja watawatali maninietja nganai. ");
INSERT INTO dif_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Warle manani wiriai, nau ngamalkanietja nganai tjipia. ");
INSERT INTO dif_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Nunkangupini mana ngamalkanietjali mana walto ngankai, ja tjipieli ngaiala nunkani ngarai, ja nulu tjipi nunkani tala karkai, ja tanana dunkalkai. ");
INSERT INTO dif_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ja nulu tjipi nunkani dunkalkanani, nau tanangu ngopera wapai, ja tjipi nunkangu karipateriai, ngangau tanali ngaiala nunkani ngujamai. ");
INSERT INTO dif_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Tulani tana wata karipaterila nganai, a‐ai, nunkangundru japa mindrila nganai; ngangau tulaia ngaiala tanali wata ngujamai.“ ");
INSERT INTO dif_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ninapini jeribaka jaura Jesus tanangu jatana wonti; ja tanali wata ngujamana wonti mina jenia wondrai, Nau tanangu matja jatana. ");
INSERT INTO dif_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jesus nakaldra tanangu jatana wonti: „Morlalu, morlalu, ngani jurangu jatai: Ngani mana nganai tjipia. ");
INSERT INTO dif_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Worderuntja pratjana ngakangu ngopera wokaranala kurikantji ja watawatali maninietja nganai; ja tjipieli tanana wata ngarai. ");
INSERT INTO dif_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ngani mana nganai: kulno ngakangu wirinani, nulu kulkani ngamalkala nganai, ja nau wirila nganai ja dunkala nganai ja kuljakulja mankamankala nganai. ");
INSERT INTO dif_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Kurikantji windri wokarai kurieli manila naria nandrala ja teribala. Ngani wokaranala, tanali tepi ja poto pirna ngamalkananto. ");
INSERT INTO dif_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ngani Ngamalkanietja ngumu nganai. Nauja Ngamalkanietja ngumu tepi nunkani jinkiteriai tjipini. ");
INSERT INTO dif_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Nau ngamalkanietja kalalaia, nau wata ngamalkanietja nganai, ja tjipi wata nunkani nganai, nulupini pandipandi wokaranani najinani, nulu tjipi worarai ja japa mindriai, ja pandipandieli tanana patai, ja tjipi piltjaru ngankai. ");
INSERT INTO dif_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ngamalkanietja kalalaia japa mindriai, ngangau nau ngamalkanietja kalalaia nganai, ja ngangau nulu tjipi wata ngundrai. ");
INSERT INTO dif_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ngani Nauja ngamalkanietja ngumu nganai, ja tanana ngakani ngato ngujamai, ja tanali ngakanali ngana ngujamai. ");
INSERT INTO dif_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Worderu Ngaperali ngana ngujamai, ja ngato Ngaperi ngujamai; ja ngani tepi ngani jinkiteriai tjipini. ");
INSERT INTO dif_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ja ngato tjipi pilki ngamalkai, tana wata nunkangupini jarundru nganai; bakana tanana ngato wokaralkananto, ja tanali ngaiala ngakani ngarala nganai, ja ngami kulno ja ngamalkanietja kulno pantjila nganai. ");
INSERT INTO dif_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Jendrangundruja Ngaperali ngakanali ngana ngantjai, ngangau ngani tepi ngakani jinkiteriai, ninaia nakaldra manila. ");
INSERT INTO dif_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Wata kulnujeli ninaia ngakangundru maniai, a‐ai, ngani munta ninaia jinkiteriai. Ngato ngurula ngamalkai ninaia jinkiterila, ja ngato ngurula ngamalkai ninaia nakaldra manila: Ninapini jirijiribani jaura ngato ngakani Ngaperandru maninala.“ ");
INSERT INTO dif_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Juda kana nakaldra tidatida ngankijiribamalina wonti nunkangupini jaurandru. ");
INSERT INTO dif_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Palpa tanangundru jatana wonti: „Nulia kutji ngamalkai, ja jirijiri nganai; minandru jura ninaia ngarai?“ ");
INSERT INTO dif_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Palpa jatana wonti: „Jenia wata kana kutjintaia jaura nganai; kutji ngurunguru nganai butjuja milki piri ngankala?“ ");
INSERT INTO dif_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Godaia pungaia kulikiri ngankani ditji Jerusalemingu nganana wonti; ja kilpani nganana wonti. ");
INSERT INTO dif_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ja Jesus Godaia pungani Salomonani pirini wirarina wonti. ");
INSERT INTO dif_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Juda kanali nina kapikapina wonti ja nunkangu jatana wonti: „Wintaranaia jundru ngaianina mungara ngandrawalkai? Jidni Christus ngananani ngaianingu talku jatamai!“ ");
INSERT INTO dif_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesujeli tanangu kalabana wonti: „Ngani jenia jurangu jatana warai, ja jura wata morlalu ngundrai; tananaia ngankana, tananaia ngato ngankai Ngaperaia ngakanaia talani, tanalia ngakangundru tinkari ngankai. ");
INSERT INTO dif_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Windri jura wata morlalu ngundrai, ngangau jura wata tjipi ngakani nganai, worderu ngani jurangu jatana warai. ");
INSERT INTO dif_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Tjipieli ngakanali ngaiala ngakani ngarai, ja ngato tanana ngujamai, ja tana ngakangu karipateriai, ");
INSERT INTO dif_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ja ngato tanangu tepi ngurali jinkiai, ja tana ngurali wata tintaterila nganai, ja wata kulnujeli tanana ngakani marandru manila nganai. ");
INSERT INTO dif_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ngakani Ngaperi, Nulia tanana ngakangu jinkinala, morla pirna nganai warupotuni; ja wata kulno ngurunguru nganai, tanana Ngaperaia ngakanaia marandru manila. ");
INSERT INTO dif_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ngani ja Ngaperi kulno nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Juda kanali nakaldra marda patana wonti nina dakala. ");
INSERT INTO dif_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesujeli tanangu kalabana wonti: „Ngankani ngumu marapu ngato jurangu ngakani Ngaperandru wondrana warai; wodatanangundru ngankanandru jura ngana mardali dakai?“ ");
INSERT INTO dif_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Juda kanali nunkangu kalabana wonti ja jatana wonti: „Ngankani ngumundru ngaiani jidna wata mardali dakai, a‐ai, Godaia ngirkibanandru, ja ngangau jidni, kana ngananani, munta Goda ngankatariai.“ ");
INSERT INTO dif_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesujeli tanangu kalabana wonti: „Wata jurani jirijiribani jaurani dakanala parai: Ngani jatana wonti, jura Goda wora nganai? ");
INSERT INTO dif_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nulia tanana «Goda worana» dikanani, ja dakanala ngandandariai wokaribala; ");
INSERT INTO dif_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Jura nunkangu, ninaia Ngaperali kulikiri ngankana wonti ja mitani jinpana wonti, jatanani: «Jundru Goda ngirkibai;» ngangau ngani jatana warai: Godaia Ngatamura ngani nganai? ");
INSERT INTO dif_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ngato Ngaperaia ngakanaia ngankani wata ngankanani, ngakangu wata morlalu ngundranau; ");
INSERT INTO dif_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ngato tananaia ngankanani, jeruja, jura bakana ngakangu wata morlalu ngundranani, tanangu ngankanani morlalu ngundranau! ngangau jura ngujamananto ja morlalu ngundrananto, Ngaperi ngakangu nganai ja ngani nunkangu.“ ");
INSERT INTO dif_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Tanali nakaldra wontina wonti nina patala, ja Nau tanani marandru kutingana wonti. ");
INSERT INTO dif_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ja Nau nakaldra Jordan kaiari jerankaria wapana wonti, nunkangupini piria, woderi Johannili ngopera multibana wonti; ja Nau naka ngamana wonti. ");
INSERT INTO dif_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ja marapu nunkangu wokarana wonti ja jatana wonti: „Johannili malka pani ngankana paraia; ja pratjana mina Johannes nunkangundru jatana paraia, morlalu nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ja marapujeli naka nunkangu morlalu ngundrana wonti. ");
INSERT INTO dif_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Kulno muntja nganana wonti, Lazarus Bethaniandru, Marianankani ja Marthanankani nankani kakuja ngurani. ");
INSERT INTO dif_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Nani Maria nganana wonti, nandru Kapara matja gildieli wiribana, ja tidna nunkani parali nankanali matja muja ngankana, nankani neji Lazarus muntja parana wonti. ");
INSERT INTO dif_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Kaku wulali nunkangu jinpana wonti ja jatana wonti: „Kaparajai, mai, nina jundru ngantjai, nau muntja parai.“ ");
INSERT INTO dif_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesujeli jenia matja ngarana, Nau jatana wonti: „Naupini muntja wata naria nganai, a‐ai, Godaia pirnalandru, ngangau Godaia Ngatamura pirna pantjinanto nunkangundru.“ ");
INSERT INTO dif_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesujeli Martha ja kaku nankani ja Lazarus ngantjana wonti. ");
INSERT INTO dif_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Nulu matja ngarana, nau muntja, Nau ditji mandru morla nunkangupini pirini, woderi Nau nganana, ngamana wonti. ");
INSERT INTO dif_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ngadani Nau milini nunkanani jatana wonti: „Ngaiana nakaldra Judaiaia palkananto!“ ");
INSERT INTO dif_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Mili nunkani nunkangu jatana wonti: „Rabbi, kalkani Juda kanali wontina paraia jidna mardali dakala, ja nakaldra jidni jerra palkai?“ ");
INSERT INTO dif_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesujeli kalabana wonti: „Wata ditjiwirdri ditji karitjiai pota marapratjana ja mandru? Worana ditjini wiriai nau wata dakateriai, ngangau nulu nunkanipini mitaia praitji najiai; ");
INSERT INTO dif_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Worana tinkani wirariai, nau dakateriai, ngangau praitji wata nunkangu nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jenia Nau jatana wonti, ja ngadani Nau tanangu jatana wonti: „Lazarus kamaneli ngaianani mukaturarala wapaia; ja ngani wapai, nina jiritjibala.“ ");
INSERT INTO dif_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Mili nunkani jatana wonti: „Kaparajai, nau mukaturaranani, nau tepi pantjinani.“ ");
INSERT INTO dif_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesus nunkani narindru jatana wonti: tanali ngundrana wonti, Nau jenia mukandru jatai. ");
INSERT INTO dif_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ngadani Jesus tanangu talku jatana wonti: „Lazarus palila wiri, ");
INSERT INTO dif_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ja ngani mankiai jurangundru, ngani wata naka nganala wiri, ngangau jura morlalu ngundrananto; ngaiana nunkangu palkananto.“ ");
INSERT INTO dif_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Thomas, nina tanali dikai Didymus, mili nguruni jatana wonti: „Ngaiana bakana palkananto nunkangu jela palila!“ ");
INSERT INTO dif_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jesus matja wokarana, Nulu nina mankamankana wonti, nau ditji mandru ja mandru narikutuni paranani. ");
INSERT INTO dif_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bethania Jerusalemingu karakara nganana wonti, Statia marapratjana ja mara wora worita. ");
INSERT INTO dif_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Juda kana marapu Marthangu ja Mariangu wokarana wonti pudlana nejini pudlanani ngankalkala. ");
INSERT INTO dif_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marthandru matja ngarana Jesus wokaranani, nani wapana wonti nunkangu mandurila; Maria pungani ngamantina wonti. ");
INSERT INTO dif_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marthani Jesungu jatana wonti: „Kaparajai, jidni ninkida ngananani, neji ngakani wata palinani. ");
INSERT INTO dif_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Bakana karari ngani milkila, minakulno jidni Godandru ngatjinani, jenia Godali jinkangu jinkila nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesus nankangu jatana wonti: „Neji jinkani jiritjila nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marthani nunkangu jatana wonti: „Ngani milkila, nau jiritjila nganai tepi terkakani, ditjini ngadalani.“ ");
INSERT INTO dif_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesus nankangu jatana wonti: „Ngani tepi terkakani ja tepi nganai. Warle ngakangu morlalu ngundrai, nau tepi ngamala nganai, bakana nau palinani. ");
INSERT INTO dif_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ja worana tepi ngamai ja ngakangu morlalu ngundrai, nau morlalu ngurali wata palila nganai. Jundru jenia morlalu ngundrai?“ ");
INSERT INTO dif_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Nani nunkangu jatana wonti: „Kau Kaparajai, ngato morlalu ngundrai jidni Christus nganai, Godaia Ngatamura, Nauja mitani wokarananto.“ ");
INSERT INTO dif_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ja nani jenia matja jatana, nani wapana wonti ja kaku nankani Mariana kurukuru karkana wonti ja jatana wonti: „Ngujangujara jinkinietja ninkida nganai ja jidna karkai.“ ");
INSERT INTO dif_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Nandru jenia matja ngarana, nani nurujeli jiritjina wonti ja nunkangu wokarana wonti. ");
INSERT INTO dif_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesus jendranguta wata ngurani wokarana wonti, a‐ai, Nau nunkangupini pirini nganana wonti, woderi Marthani nunkangu mandurina wonti. ");
INSERT INTO dif_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Juda kanali, tana nankangu jela pungani ngamana wonti ja nana ngankalkana wonti, najinani Maria nurujeli jiritjinani ja dunkanani, tana nankangu karipaterina wonti ja jatana wonti: „Nania narikutuja wapai naka jindrala.“ ");
INSERT INTO dif_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maria naka wokaranani woderi Jesus nganana wonti, nandru nina matja najina, nani nunkangu tidnani woraterina wonti ja nunkangu jatana wonti: „Kaparajai, jidni ninkida ngananani, neji ngakani wata palinani.“ ");
INSERT INTO dif_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesujeli nana jindranani najina, ja Juda kana, tana nankangunto matja wokarana, bakana jindranani, Nau Jaolali ngara jerkina wonti ja ngaratutututungana wonti. ");
INSERT INTO dif_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ja Nau jatana wonti: „Woderi jura nina kurala wiri?“ Tana nunkangu jatana wonti: „Kaparajai, kaparau ja najiau!“ ");
INSERT INTO dif_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ja Jesus wolkarina wonti. ");
INSERT INTO dif_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Juda kana jatana wonti: „Najianau worderu Nulia ninaia ngantjana paraia!“ ");
INSERT INTO dif_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Palpa tanangundru jatana wonti: „Naupara, Nulia butjuja milki piri ngankana paraia, ngandandarina paraia ngankala, bakana Naupini wata palinanto?“ ");
INSERT INTO dif_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesus nakaldra ngara jerkina wonti ja narikutuni wokarana wonti. Nau minka nganana wonti, ja marda nunkangu parana wonti. ");
INSERT INTO dif_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesus jatana wonti: „Nina marda tirimalkanau.“ Martha, naria kaku, nunkangu jatana wonti: „Kaparajai, nauja matja paniai, ngangau nauja ditji mandru ja mandru parai.“ ");
INSERT INTO dif_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesus nankangu jatana wonti: „Ngani jinkangu wata jatana warai, jundru morlalu ngundranani, jundru Godaia pirnala najila nganai?“ ");
INSERT INTO dif_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tanali nina marda tirimalkana wonti, woderi nau nari paranani. Ja Jesus milki tjenmana wonti ja jatana wonti: „Ngaperiai, ngato jidna jurakokala wapaia, ngangau jundru ngana ngarana warai. ");
INSERT INTO dif_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ngani milkila, jundru ngana milingeru ngarai: windri kana wolarandru, tanaia karakara terkai, ngani jenia jatana warai, ngangau tanalia morlalu ngundrananto, jundru ngana jinpanala.“ ");
INSERT INTO dif_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ja Nau jenia matja jatana, Nau ngaiala pirnali karkana wonti: „Lazarujai dunkau!“ ");
INSERT INTO dif_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ja nau narila dunkana wonti mara ja tidna nari katieli karaterini, ja nunkangu mudlani kangu kati paranani. Jesus tanangu jatana wonti: „Ninaia dukaranau ja worani patanau!“ ");
INSERT INTO dif_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Juda kana marapujeli tana Mariangu wokarana wonti ja najina wonti mina Jesujeli ngankana wonti, tana nunkangu morlalu ngundrana wonti. ");
INSERT INTO dif_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Palpa tanangundru Pharisaiaia wapana wonti ja tanangu kaukaubana wonti mina Jesujeli ngankana warai. ");
INSERT INTO dif_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Priesta pirnali ja Pharisaiali kana kapara jurborilkana wonti ja jatana wonti: „Mina ngaiana ngankananto? Nulupini kanali malka marapu ngankai. ");
INSERT INTO dif_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ngaiana nina jeruja worani patanani, tanali pratjanali nunkangu morlalu ngundrala nganai; ja Roma kana wokarala nganai ja ngaianani piri ja kana wolara manila nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Kulno tanangundru, Kaiphas, nau nunkangupini kilpawoldrani Priesta pirna nganana wonti, tanangu jatana wonti: „Jura panila ngujamai. ");
INSERT INTO dif_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Jura bakana wata ngundrai, ngaianangu morla ngumu nganai, kana kulno kana wolarani palinanto, ja wata kana wolara tintaterinanto.“ ");
INSERT INTO dif_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Jenia nau wata munta jatana wonti, a‐ai, ngangau nau nunkangupini kilpawoldrani Priesta pirna nganana wonti, nulu talpadakana wonti Jesus palinanto kana wolarani. ");
INSERT INTO dif_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ja wata windri kana wolarani, a‐ai, Nulu bakana Godaia kupa, tana piltjaru ngamanani, kulnukulnuni ngankananto. ");
INSERT INTO dif_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Nunkangupini ditjindru tana ngankamalina wonti nina naria nandrala. ");
INSERT INTO dif_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Jesus wata morla Juda kanani kantji wirarina wonti, a‐ai, Nau nakandruka puntina wonti mita pitaraia karakaraia, ngura kulnuja, tala nunkani Ephraim, ja Nau naka ngamana wonti nunkani milinto. ");
INSERT INTO dif_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Juda kanaia Passa karakara nganana wonti, ja marapu nunkangupini mitandru Jerusalemia tarana wonti Passani ngopera, kulirkaterila. ");
INSERT INTO dif_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Tanali Jesus wontina wonti, ja Godaia pungani ngankamalina wonti ja jatana wonti: „Mina jura ngundrai? Nau wata ditji pirnani wokarala nganai?“ ");
INSERT INTO dif_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Priesta pirnali ja bakana Pharisaiali jirijiribani jaura jinkina wonti, woranakulno milkila, woderi Nau nganai, nulu jenia wondrananto, ngangau tanali nina patananto. ");
INSERT INTO dif_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ditji mara wora ja kulnuni Passani ngopera Jesus Bethaniani wokarana wonti woderi Lazarus nganana wonti, nina Jesujeli narindru jiritjibana paraia. ");
INSERT INTO dif_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Tanali nunkangu naka buka pirna ngankingana wonti, ja Martha mili nganana wonti; Lazarus kulno tanangundru nganana wonti, tana nunkangunto kurlini ngamana wonti. ");
INSERT INTO dif_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Marthandru Narda gildi koko kulno ngumu pirnanto manina wonti ja Jesuni tidna wiribana wonti ja tidna nunkani parali nankanali muja ngankana wonti, ja punga manamiri pantjina wonti gildia kuli ngumujeli. ");
INSERT INTO dif_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Nunkani milindru kulno, Judas Simon Ischariot, nulu nina wontawontananto, jatana wonti: ");
INSERT INTO dif_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","„Minandru ninapini gildi wata 300 mardatandraia jinkina warai kalalaia, ja wangiwangini bakujeli jinkina warai?“ ");
INSERT INTO dif_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Jenia nau wata jatana wonti, ngangau nulu kana wangiwangi ngundrana wonti, a‐ai, ngangau nau kurikantji nganana wonti, ja billi ngamalkana wonti ja patana wonti, mina tanali kurarala. ");
INSERT INTO dif_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesus jatana wonti: „Nana worani patanau! ngakani todini ditjia nandruja jenia kulkana warai. ");
INSERT INTO dif_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ngangau kana wangiwangi jura milingeru ngamalkai, ngana jura wata milingeru ngamalkai.“ ");
INSERT INTO dif_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Juda kana wolarali ngarana wonti, Nau naka ngananani; ja tana wata windri Jesungundru wokarana wonti, a‐ai, tanali bakana Lazarus najinanto, nina Nulu narindru jiritjibana paranani. ");
INSERT INTO dif_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Priesta pirna wora manamandumandurina wonti bakana nina Lazarus naria nandrala. ");
INSERT INTO dif_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ngangau Juda kana marapu nunkangundru wapana wonti, ja Jesungu morlalu ngundrana wonti. ");
INSERT INTO dif_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ditji kulnuni kana marapujeli, tana ditji pirnani matja wokarana, ngarana wonti Jesus Jerusalemia wokaranani. ");
INSERT INTO dif_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Tanali palma pitandru ngunanguna manina wonti ja dunkana wonti nunkangu mandurila ja maritjina wonti: „Hosiana, jurakokani nganaiatimai nunkangu, Nauja wokarai Kaparaia talani Israelaia Kapara!“ ");
INSERT INTO dif_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesujeli donki matja manina, Nau nunkangu ngamana tarana wonti, worderu dakanala parai: ");
INSERT INTO dif_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","„Wata japali nganau Zionani ngatamurajai, mai, Kapara jinkani wokarala wapaia donki kuparani dukaterina!“ ");
INSERT INTO dif_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Jenia milieli nunkanali ngopera wata ngujamana wonti, a‐ai, jendranguta Jesujeli pirnala nunkani matja manina, ngadani tanali ngundrana wonti, tananapini nunkangundru dakana wonti, ja tanali nunkangu jenia ngankanala. ");
INSERT INTO dif_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Kana wolarali tana nunkangunto nganana, Nulu Lazarus narikutundru karkana paraia ja nina narindru jiritjibana paraia, jenia tinkari ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Jendrangundruja bakana kana wolara nunkangu mandurina wonti, ngangau tanali ngarana warai, Nulu ninapini malka ngankana paraia. ");
INSERT INTO dif_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Pharisaiali ngankamalina wonti: „Jura najiai, jenia jurangu baku nganai; mai, kana warupoto nunkangu wapantina warai.“ ");
INSERT INTO dif_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Naka Grieka kana palpa nganana wonti tanangundru, tana milingeru tarana wonti ditji pirnani ngatjila. ");
INSERT INTO dif_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Tanapini Philippungu wokarana wonti, nau Bethsaida Galilaiandru nganana wonti ja nunkangu ngatjina wonti ja jatana wonti: „Kaparajai, ngaiani ngantjai Jesus najila.“ ");
INSERT INTO dif_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Philippus wokarai ja Andreangu jenia jatai; ja Andreas ja Philippus jenia nakaldra Jesungu jatai. ");
INSERT INTO dif_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesujeli kalabana wonti ja tanangu jatana wonti: „Ditji matja wokarana warai, Kanaia Ngatamura pirna pantjinanto. ");
INSERT INTO dif_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Morlalu, morlalu, ngani jurangu jatai: Buka tandra matja mitani purina wata palinani, nau kulnulu parai; nau matja palinani, nulu tandra marapu punkibai. ");
INSERT INTO dif_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Warle tepi nunkani ngantjai, nulu nina tintala nganai; ja worana nunkani tepini kalakalariai nunkangupini mitani, nulu nina tepi nguralia ngamalkala nganai. ");
INSERT INTO dif_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Worana mili ngakani nganai, nau ngakangu karipateriatimai, ja woderi ngani nganai, jerra bakana mili ngakani nganala nganai; ja worana mili ngakani nganala nganai, nina Ngaperali ngakanali pirna ngundrala nganai. ");
INSERT INTO dif_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ngani mungara karari ngaratutututungai. Ja mina ngani jatananto? Ngaperiai, nunkangupini ditjindru ngana kulkamai! Windri jendrangundruja ngani nunkangupini ditjini wokarana warai. ");
INSERT INTO dif_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ngaperiai, tala jinkani pirna ngankamai!“ Ngaiala kulno pariwilpandru wokarana wonti: „Ngato ninaia pirna ngankana warai, ja ninaia nakaldra pirna ngankala nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Kana wolara tana jerra terkana ja ngarana, jatana wonti: „Talara piltripiltri nganana warai;“ palpa jatana wonti: „Angela kulno nunkangunto ngankamalina warai.“ ");
INSERT INTO dif_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesujeli kalabana wonti ja jatana wonti: „Naupini ngaiala wata ngakangundru, a‐ai, jurangundru pantjina warai. ");
INSERT INTO dif_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Karari nunkangupini mitani puntibani nganai; karari Nulia nunkanipini mitaia kapara narrala nganai. ");
INSERT INTO dif_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ja ngani mitandru matja miri ngananani, ngato warupotopratjana ngakangu parumala nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jenia Nau jatana wonti wondrala, mina nari Nau palinanto. ");
INSERT INTO dif_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Kana wolarali nunkangu kalabana wonti: „Ngaiani jirijiribani jaurandru ngarana warai, Christus ngurali ngamala nganai; ja worderu jidni jatai: Kanaia Ngatamura miri pantjinanto? Worana Naupini Kanaia Ngatamura nganai?“ ");
INSERT INTO dif_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesus tanangu jatana wonti: „Windri miljaru wordu morla praitji jurangunto nganai. Wirarianau jeruntjaia jura praitji ngamalkai, ngangau ngalpurali jurana pataiati. Ja worana ngalpurani wirariai, nau wata milkila wodajeri nau wapai. ");
INSERT INTO dif_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Jeruntjaia jura praitji ngamalkai, praitjani morlalu ngundranau, ngangau jura praitjaia kupa pantjinanto.“ Jenia Jesujeli kaukaubana wonti ja wapana wonti ja tanangundru kurukurumalkaterina wonti. ");
INSERT INTO dif_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Nulu jeruntja malka tanangu milkini ngankana wonti, ja tanali nunkangu wata morlalu ngundrana wonti, ");
INSERT INTO dif_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ngangau Jesaiani Prophetaia jaura morlalu pantjinanto, nina nau jatana wonti: „Kaparajai, warle ngaianinani ngujangujarani morlalu ngundrana warai? Ja worangu Kaparaia nguna tinkari pantjina warai?“ ");
INSERT INTO dif_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Jendrangundruja tana ngandandarina wonti morlalu ngundrala, ngangau Jesaias nakaldra jatai: ");
INSERT INTO dif_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","„Nulia tanani milki butju ngankana wonti ja tanani ngara ngurunguru ngankana wonti, ngangau tanali milkieli wata najinanto ja ngarali wata ngujamananto ja madlentjandru karitjinanto, ngato tanana tepi ngankananto.“ ");
INSERT INTO dif_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Jenia Jesaias jatana wonti, nulu pirnala nunkani matja najina ja nunkangundru kaukaubana wonti. ");
INSERT INTO dif_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Bakana kapara marapujeli nunkangu morlalu ngundrana wonti; windri Pharisaiandru tanali nina wata kantji dikana wonti, tanali tanana Godaia milindru narraiati. ");
INSERT INTO dif_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ngangau tanali kanaia pirnala morla ngantjana wonti Godaia pirnalani. ");
INSERT INTO dif_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesus parparali karkana wonti ja jatana wonti: „Warle ngakangu morlalu ngundrai, wata ngakangu morlalu ngundrai, a‐ai, windri nunkangu, Nulia ngana jinpanala. ");
INSERT INTO dif_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ja warle ngana najiai, nulu ninaia najiai, Nulia ngana jinpanala. ");
INSERT INTO dif_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ngani mitani wokaranala praitji nganala; ngangau warle ngakangu morlalu ngundrai wata morla ngalpurani nganananto. ");
INSERT INTO dif_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ja warle jaura ngakani bulu ngarai ja wata morlalu ngundrai, nunkangu wata ngato kalala kurai, ngangau ngato wata wokaranala mitalani kalala kurala, a‐ai, mitala kulkala. ");
INSERT INTO dif_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Warle ngana worarai, ja jaura ngakani wata patai, nulu nina ngamalkai, nulu nunkangu kalala kurai; nulupini jaurali, nina ngani jatana warai, nunkangu kalala kurala nganai ditjini ngadalani. ");
INSERT INTO dif_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ngangau ngato wata ngakangundru muntali kaukaubana warai, a‐ai, Ngaperali, Nulia ngana jinpanala, ngakangu jirijiribani jaura jinkinala; mina ngato kaukaubananto ja mina ngani jatananto. ");
INSERT INTO dif_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ja ngani milkila, nunkani jirijiribani jaura tepi ngurali nganai. Mina ngani jatala wapaia, jenia ngani jeruja jatai, worderu Ngaperali ngakangu jatanala.“ ");
INSERT INTO dif_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Passa ditji pirnani ngopera Jesus milkila nganana wonti ditji nunkani matja wokarana, Nau nunkangnpini mitandru Ngaperaia wapananto; worderu Nulu nunkanina mitani ngananani, ngantjana wonti, jeruja Nulu tanana narielu ngantjana wonti. ");
INSERT INTO dif_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ja buka matja mudanani, ja kutjieli Judas Ischariot Simonani ngatamurani ngarani matja jinkina, nulu nina wontawontananto, ");
INSERT INTO dif_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ja Jesus matja milkila ngananani, Ngaperali nunkangu pratjana marani jinkina warai, ja Nau Godandru dunkanala ja Godaia tikananto, ");
INSERT INTO dif_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Nau bukandru terkakana wonti, ja kati nunkani dukarana wonti ja wirpakati manina wonti ja ngampina wonti; ");
INSERT INTO dif_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ngadani Nulu ngapa ngapakokuni nangana wonti ja wonina wonti militidna kulirkala ja wirpakatieli, nina Nau matja ngampina warai, muja ngankala. ");
INSERT INTO dif_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Nau Simon Petrungu wokaranani, nau nunkangu jatana wonti: „Kaparajai, jundru ngana tidna kulirkai?“ ");
INSERT INTO dif_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesujeli kalabana wonti ja nunkangu jatana wonti: „Mina ngato ngankala wapaia jidni karari wata milkila, jundru jenia ngadani ngujamala nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petrus nunkangu jatana wonti: „Ngurali jundru wata ngana tidna kulirkananto!“ Jesujeli nunkangu kalabana wonti: „Ngato jidna wata kulirkanani, jundru ngakangunto wata poto ngamalkanani.“ ");
INSERT INTO dif_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Petrus nunkangu jatana wonti: „Kaparajai, wata windri ngana tidna, a‐ai, bakana mara ja mangatandra.“ ");
INSERT INTO dif_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesus nunkangu jatana wonti: „Worana matja ngaporna, nau wata morla kulirkaterinanto windri tidna kulnulu, ngangau nau pratjanani kulikiri nganai; ja jura kulikiri nganai, windri wata pratjana.“ ");
INSERT INTO dif_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ngangau Nulu wontawontanietja nunkani ngujamana wonti; jendrangundruja Nau jatana wonti: „Jura wata pratjana kulikiri nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Nulu tanana tidna matja kulirkana, ja Nau kati nunkani matja widmaterina ja ngamana ngarina, Nau tanangu jatana wonti: „Jura ngujamai mina ngato jurangu ngankana warai? ");
INSERT INTO dif_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Jura ngana Ngujangujara jinkinietja ja Kapara dikai; ja jura talku jatai, ngangau ngani Nauja nganai. ");
INSERT INTO dif_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ngato, Kaparali ja Ngujangujara jinkinietjali juranali jurana tidna kulirkana warai, jeruja bakana jura tidna kulirkijiribamalinanto. ");
INSERT INTO dif_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Wondrani malka ngato jurangu jinkina warai, ngangau worderu ngato jurangu ngankana warai, jeruja bakana jura ngankananto. ");
INSERT INTO dif_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Morlalu, morlalu, ngani jurangu jatai: Mili wata morla pirna nganai nunkani kaparani, ja Apostel wata morla pirna nganai nunkangu, nulu nina jinpanala. ");
INSERT INTO dif_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Jura jenia milkila ngananani, murlali pirna jura nganai, jura jenia ngankanani. ");
INSERT INTO dif_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Wata jurangu pratjanandru ngato kaukaubai, ngani milkila, worana ngato kalkalkanala; windri jaura morlalu pantjinanto: «Nulu ngakangunto buka tajila wapaia, nulu tidnawoda nunkani miri ngankana warai ngakangu.» ");
INSERT INTO dif_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Karari ngani jurangu jenia jatai, morla ngopera jenia pantjinani, ngangau jura, jenia pantjinani, morlalu ngundrananto, ngani Nauja nganai. ");
INSERT INTO dif_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Morlalu, morlalu, ngani jurangu jatai: Warle nina patai, worana ngato jinpai, nulu ngana patai; ja warle ngana patai, nulu ninaia patai, Nulia ngana jinpanala.“ ");
INSERT INTO dif_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Nau jenia matja jatana, Jesus Jaolali ngaratutututungana wonti, ja Nulu tinkari ngankana wonti ja jatana wonti: „Morlalu, morlalu, ngani jurangu jatai: Kulnujeli jurangundru ngana wontawontala nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Mili milkieli najimalina karitjina wonti, ja tana wurpuru nganana wonti, worangundru Nauja jenia jatai. ");
INSERT INTO dif_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Nunkani mili kulno, nau kurlini Jesuni munambirini ngamana wonti, nina Jesujeli ngantjana wonti; ");
INSERT INTO dif_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Nunkangupini Simon Petrulu malka jinkina wonti nulu jakalkananto, worana nauja nganai, nunkangundru Nauja jenia jatai. ");
INSERT INTO dif_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Nau Jesu munambirini buruna ngarina wonti ja nunkangu jatana wonti: „Kaparajai, worana nauja nganai?“ ");
INSERT INTO dif_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesujeli kalabana wonti: „Nauja nganai, nunkangu ngato buka waka multibala nganai ja jinkila nganai.“ Ja Nulu buka waka matja multibana, Nulu nina Judas Ischariot Simonani ngatamurani jinkina wonti. ");
INSERT INTO dif_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ja nulu buka waka matja manina, Satan nunkangu wirina wonti. Jesus nunkangu jatana wonti: „Mina jundru ngankai, jenia morla nurujeli ngankai.“ ");
INSERT INTO dif_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Jenia wata kulnujeli tanangundru, kurlini matja ngamana, ngujamana wonti, minani Nau jenia nunkangu jatana wonti. ");
INSERT INTO dif_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Palpali ngundrana wonti, ngangau Judali mardatandra billi ngamalkana wonti, Jesus nunkangu jatai: „Burungankau, mina ngaiani ditji pirnani ngamalkananto,“ nulu wangiwangini palpa jinkinanto kara. ");
INSERT INTO dif_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Nulupini buka waka matja manina, nau nurujeli dunkana wonti. Ja tinka nganana wonti. ");
INSERT INTO dif_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Nau matja dunkana, Jesus jatana wonti: „Karari Godaia Ngatamura pirna nganai, ja Goda nunkangu pirna nganai. ");
INSERT INTO dif_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Goda nunkangu pirna ngananani, jeruja bakana Godali ninaia munta pirna ngankala nganai nunkangu, ja nurujeli Nulia nina pirna ngankala nganai. ");
INSERT INTO dif_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Kupa worai! Windri wordu morla ngani jurangunto nganai. Jura ngana wontila nganai, ja worderu ngani Juda kanani jatana warai: Wodajeri ngani wapai, naka jura ngandandariai wokarala; jeruja ngani karari bakana jurangu jatai. ");
INSERT INTO dif_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Jirijiribani jaura marra ngato jurangu jinkiai: Jura ngantjamalinanto; worderu ngato jurana ngantjana warai, jeruja bakana jura ngantjamalinanto. ");
INSERT INTO dif_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nunkangundru pratjanali ngujamala nganai, jura mili ngakani nganai, jura ngantjamalinani.“ ");
INSERT INTO dif_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Petrus nunkangu jatana wonti: „Kaparajai, wodajeri jidni wapai?“ Jesujeli nunkangu kalabana wonti: „Wodajeri ngani wapai, jerra jidni karari ngandandariai ngakangu karipaterila; ngadani jidni ngakangu karipaterila nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petrus nunkangu jatana wonti: „Kaparajai, minandru ngani karari ngandandariai jinkangu karipaterila. Ngakani tepi ngani jinkangundru jinkiterila nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesujeli nunkangu kalabana wonti: „Jinkani tepi jundru ngakangundru ngantjai jinkila? Morlalu, morlalu, ngani jinkangu jatai: Windrila paia ngaperi jatananto, jundru ngana pota parkulu jedieli worarala nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jura ngara wata japali pantjianau! Godani morlalu ngundranau, ja bakana ngakangu morlalu ngundranau. ");
INSERT INTO dif_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ngaperaia ngakanaia pungani piri marapu nganai; wata kantji ngananani, ngani jurangu jenia jatanani. Ngani wapai jurani piri ngankijiribingala; ");
INSERT INTO dif_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ja ngani matja wapana warai, ja jurangu piri ngankijiribingana warai, ngadani ngani nakaldra tikala nganai ja jurana ngakangu manila nganai, ngangau woderi ngani nganai bakana jura nganananto. ");
INSERT INTO dif_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ja wodajeri ngani wapai jura milkila, ja palto jura bakana milkila. ");
INSERT INTO dif_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Thomas nunkangu jatana wonti: „Kaparajai, ngaiani ko wodajeri jidni wapai, ja worderu ngaiani palto ngujamananto?“ ");
INSERT INTO dif_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesus nunkangu jatana wonti: „Ngani palto ja morlaluta ja tepi nganai; wata kulno Ngaperani wokarai, a‐ai, windri ngakangundru. ");
INSERT INTO dif_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Jura ngana ngujamanani, jura bakana ngakani Ngaperi ngujamanani: ja kararindru jura ninaia ngujamai ja ninaia najina warai.“ ");
INSERT INTO dif_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Philippus nunkangu jatana wonti: „Ngaperi ngaianingu wondramai, ja ngaianingu matja.“ ");
INSERT INTO dif_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesus nunkangu jatana wonti: „Jeruntjaia ditji ngani jurangunto nganai, ja jundru ngana wata ngujamana warai, Philippujai? Warle ngana najina warai, nulu Ngaperi najina warai; worderu jidni jatai: Ngaianingu Ngaperi wondramai? ");
INSERT INTO dif_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Jundru wata morlalu ngundrai ngani Ngaperani ja Ngaperi ngakangu nganai? Tananapini jaura, tanana ngani jurangu jatai, ngani wata ngakangundru munta jatai; Ngaperali, Nauja ngakangu ngamai, Nulia muntali tanana ngankani ngankai. ");
INSERT INTO dif_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ngakangu morlalu ngundranau ngani Ngaperani ja Ngaperi ngakangu nganai; pani kara, ngakangu morlalu ngundranau ngankanandru! ");
INSERT INTO dif_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Morlalu, morlalu, ngani jurangu jatai: Warle ngakangu morlalu ngundrai, nulu tanana ngankani bakana ngankala nganai, tanana ngato ngankai, ja ngankani morla pirna nulu ngankala nganai tanangupini, ngangau ngani ngakani Ngaperani wapai. ");
INSERT INTO dif_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ja minakulno jura talani ngakanani ngatjinani, jenia ngato ngankala nganai, ngangau Ngaperi pirna pantjinanto Ngatamurani. ");
INSERT INTO dif_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Minakulno jura talani ngakanani ngatjinani, jenia ngato ngankala nganai.");
INSERT INTO dif_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Jura ngana ngantjanani, jirijiribani jaura ngakani ngamalkanau! ");
INSERT INTO dif_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ja ngani Ngaperani ngatjila nganai, ja Nulia jurangu Ngankalkanipirna nguru jinkila nganai, Nauja ngurali jura ngunto nganananto, ");
INSERT INTO dif_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ninaia Jaola morlaluta, ninaia mitala ngandandariai manila, ngangau tanali ninaia wata najiai ja ninaia wata ngujamai; jura ninaia ngujamai, ngangau Nauja jurangunto ngamai, ja jurangu Nauja nganai. ");
INSERT INTO dif_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ngato jurana wata ngamuru worarala nganai; ngani jurangu wokarai. ");
INSERT INTO dif_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Wordu morla, ja mitalali ngana wata morla najila nganai; jura ngana najiai, ngangau ngani tepi, ja jura bakana tepi nganala nganai. ");
INSERT INTO dif_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Nunkangupini ditjini jura ngujamala nganai, ngani Ngaperani ngakanani, ja jura ngakangu, ja ngani jurangu. ");
INSERT INTO dif_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Warle jirijiribani jaura ngakani ngamalkai, ja tanana ngumu ngamalkanani, nau naupini nganai, nulu ngana ngantjai; warle ngana ngantjai, nina Ngaperali ngakanali ngantjala nganai, ja ngato nina ngantjala nganai, ja munta nunkangu wondraterila nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Nunkangu Judas, wata Ischariot, jatana wonti: „Kaparajai, mina pantjina warai, ngangau jidni jertapateriai ngaianingu wondraterila, ja wata mitalani?“ ");
INSERT INTO dif_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesujeli kalabana wonti ja nunkangu jatana wonti: „Kulnujeli ngana ngantjanani, nulu jaura ngakani ngamalkala nganai; ja Ngaperali ngakanali nina ngantjala nganai, ja ngali nunkangu wokarala nganai ja nunkangu ngamala nganai. ");
INSERT INTO dif_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Warle ngana wata ngantjai, nulu jaura ngakani wata ngamalkai; ja naupini jaura, nina jura ngarala wapaia, wata ngakani nganai, a‐ai, Ngapinanka, Nulia ngana jinpanala. ");
INSERT INTO dif_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ninapini ngani jurangu jatala wapaia, ngangau ngani jurangunto ngamala wapaia. ");
INSERT INTO dif_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ngankalkanipirnali, Jaolali kulikirieli, ninaia Ngaperali ngakanali jinpala nganai talani ngakanani, Nulupini jurana pratjanani ngujangujara jinkila nganai, ja Nulia jurana mangatandra wilpa ngankala nganai pratjanani, mina ngani jurangu jatana warai. ");
INSERT INTO dif_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Murla ngato jurangu worarai, murla ngakani ngato jurangu jinkiai; wata jeruja worderu mitalali jinkiai. Jura ngara wata ngaruparanau ja wata japali pantjianau! ");
INSERT INTO dif_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Jura matja ngarana, ngani jurangu jatana warai: Ngani wapai ja jurangu tikai. Jura ngana ngantjanani, jura mankinani, ngani jatana warai: Ngaperani ngani tikai; ngangau Ngaperi morla pirna nganai ngakangu. ");
INSERT INTO dif_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ja karari ngani jenia jurangu jatana warai, morla ngopera jenia pantjinani, ngangau jenia pantjinani, jura morlalu ngundrananto. ");
INSERT INTO dif_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ngani wata morla jaura marapu jurangu jatala nganai; ngangau nunkanipini mitaia kapara wokarai, ja panila nulu ngakangu ngamalkai. ");
INSERT INTO dif_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ngangau mitalali ngujamananto, ngato Ngaperi ngantjai, ja jeruja ngankai worderu Ngaperali ngakangu jirijiribanala: Terkakanau ngaiana ninkidandru wapananto.“");
INSERT INTO dif_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ngani waina nindri morlalu nganai, ja Ngaperi ngakani waina maru najinajibanietja nganai. ");
INSERT INTO dif_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Waina ngunanguna pilki ja pilki, nulu wata tandra mandranani, nina Nulia dukarai; ja pilki ja pilki nulu tandra mandranani, nina Nulia kulirkai, nulu tandra morla mandrananto. ");
INSERT INTO dif_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Jura kulikiri nganai nunkanipini jaurandru, nina ngato jurangu kaukaubana warai. ");
INSERT INTO dif_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ngakangu ngamanau ja ngani jurangu! Worderu waina ngunanguna ngandandariai muntali tandra mandrala nau wata waina nindrini paranani, jeruja bakana jura, jura wata ngakangu ngamanani. ");
INSERT INTO dif_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ngani waina nindri nganai, jura ngunanguna. Worana ngakangu ngamai ja ngani nunkangu, nulupini tandra marapu mandrai; ngangau ngakangu panini jura ngandandariai ngankala. ");
INSERT INTO dif_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Kulno wata ngakangu ngamanani, nina Nulia palarani worala nganai ngunanguna jeribaka, ja nau mujarila nganai; ja tanali nina kampala nganai ja nina turuni worala nganai, ja nau jerkila nganai. ");
INSERT INTO dif_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Jura ngakangu ngamanani ja jaura ngakani jurangu ngamalkanani: Mina jura jertapateriai jura ngatjinanto, ja jenia jurangu pantjila nganai. ");
INSERT INTO dif_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Jeruja Ngaperi ngakani pirna nganai, jura tandra marapu mandranani, ja jura mili ngakani ngananani. ");
INSERT INTO dif_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Worderu Ngaperali ngana ngantjana wonti, jeruja ngato jurana ngantjana warai: ngantjanani ngakanani wonki ngamanau! ");
INSERT INTO dif_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Jura jirijiribani jaura ngakani ngamalkanani, jura ngantjanani ngakanani ngamanani; worderu ngato Ngaperaia ngakanaia jirijiribani jaura ngamalkana warai, ja ngantjanani nunkanani ngamai. ");
INSERT INTO dif_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Tananapini ngato jurangu kaukaubana warai, ngangau ngakani mankini jurangu nganananto, ja jurani mankini manamiri pantjinanto. ");
INSERT INTO dif_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Naupini jirijiribani jaura ngakani nganai: Jura ngantjamalinanto, worderu ngato jurana ngantjana warai. ");
INSERT INTO dif_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Wata kulnujeli ngantjani morla pirna ngamalkai nunkangu, nau tepi nunkani jinkiteriai kamanelini nunkanani. ");
INSERT INTO dif_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Jura kamaneli ngakani nganai, jura ngankanani mina ngato jurangu jirijiribai. ");
INSERT INTO dif_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ngato jurana wata morla mili dikai, ngangau mili wata milkila mina kapara nunkani ngankai; jurana ngato kamaneli dikana warai, ngangau pratjana, mina ngato ngakani Ngaperandru ngaranala, ngato jurangu tinkari ngankana warai. ");
INSERT INTO dif_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Wata jura ngana kalkalkana wonti, a‐ai, ngato jurana kalkalkana wonti ja jurana kurana wonti jura wapananto ja tandra mandrananto, ja jurani tandra parananto: Ngangau minakulno jura ngakani talani Ngaperani ngatjinani, Nulia jurangu jinkinani. ");
INSERT INTO dif_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ninapini ngato jurangu jirijiribai: Jura ngantjamalinanto. ");
INSERT INTO dif_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Mitala jurangu kalakalarinani, ngujamanau, tanali ngakangu kalakalarina warai jurangu ngopera. ");
INSERT INTO dif_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Jura mitandru ngananani, mitala nunkanina ngantjanani; ngangau jura wata mitandru nganai, a‐ai, ngato jurana mitandru kalkalkana wonti, jendrangundruja mitala jurangu kalakalariai. ");
INSERT INTO dif_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ninapini jaura ngundranau nina ngani jurangu jatana warai: Mili wata morla pirna nganai kaparani nunkanani. Tana ngakangu tirikaripaterina warai tana bakana jurangu tirikaripaterila nganai; tanali jaura ngakani ngamalkana warai, tanali bakana jurani ngamalkala nganai. ");
INSERT INTO dif_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Jenia pratjana tanali ngankala nganai ngakani talandru, ngangau tanali nina wata ngujamai, Nulia ngana jinpanala.");
INSERT INTO dif_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ngani wata wokaranani ja tanangu jaura kaukaubanani, tanali wata madlentji ngamalkanani, karari tanali wata morla jataterila ngamalkai tanani madlentjandru. ");
INSERT INTO dif_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Worana ngakangu kalakalariai, bakana ngakani Ngaperani kalakalariai. ");
INSERT INTO dif_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ngato wata tanana ngankani tanangu terti ngankanani, tanana wata kulno ngurujeli ngankana warai, tanana wata madlentji ngamalkanani; karari tanali najina warai ja bakana kalakalarina warai ngakangu ja ngakani Ngaperani. ");
INSERT INTO dif_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ngangau naupini jaura, tanani jirijiribani jaurani dakanala parai, morlalu pantjinanto: Tanali ngakangu baku kalakalarina warai. ");
INSERT INTO dif_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ja Ngankalkanipirna matja wokarana, ninapini ngato jurangu jinpala nganai Ngaperandru, Jaola morlaluta, Nauja Ngaperandru dunkai, Nulia ngakangundru tinkari ngankala nganai. ");
INSERT INTO dif_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ja jura bakana tinkari ngankai, ngangau jura ngoperandru ngakangunto ngamai. ");
INSERT INTO dif_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ninapini ngani jurangu jatana warai, jura wata kintjakintjarinanto. ");
INSERT INTO dif_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Tanali jurana Godaia milindru narrala nganai; ja ditji wokarala nganai, warlenulu jurana naria nandranani, ngundrala nganai, nulu Godani poto ngumu jinkinani. ");
INSERT INTO dif_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ja jenia tanali jurangu ngankala nganai, ngangau tanali Ngaperi ja ngana wata ngujamana warai. ");
INSERT INTO dif_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Jenia ngani jurangu jatana warai, ngangau ditji matja wokaranani, jura ngundrananto, ngani jenia jurangu matja jatana. Ninapini ngani ngoperandru wata jatana warai, ngangau ngani jurangunto ngamana warai.");
INSERT INTO dif_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Karari ngani tikai nunkangu, Nulia ngana jinpanala, ja wata kulnujeli jurangundru ngana jakalkai: Wodajeri jidni wapai? ");
INSERT INTO dif_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","A‐ai, ngangau ngani jenia jurangu jatana warai, ngaurongaurojeli jurani ngara manamiri ngankana warai. ");
INSERT INTO dif_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ngani jurangu jaura morlalu jatai: Jenia jurangu ngumu nganai ngani tikanani; ngangau ngani wata tikanani, Ngankalkanipirna wata jurangu wokaranani; ja ngani matja tikana, ngato ninaia jurangu jinpala nganai. ");
INSERT INTO dif_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ja Nauja matja wokaranani, Nulia mitala kalalu ngankala nganai madlentjandru ja talkalandru ja kalalandru. ");
INSERT INTO dif_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Madlentjandru, ngangau tanali wata morlalu ngundrai ngakangu; ");
INSERT INTO dif_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Talkulandru, ngangau ngani Ngaperani tikai, ja jura ngana wata morla najila nganai; ");
INSERT INTO dif_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Kalalandru, ngangau nunkanipini mitaia kaparali kalala matja manina. ");
INSERT INTO dif_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Marapu morla ngato ngamalkai jurangu jatala, ja karari jura ngandandariai jenia pratjana waltala. ");
INSERT INTO dif_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ja Nauja matja wokaranani, Jaola morlaluta, Nulupini jurana morlaluta warupotuni wirilkala nganai; ngangau Nauja wata nunkangundru munta jatala nganai, a‐ai, mina Nulia matja ngarana, jenia Nauja jatala nganai, ja nau wokarani Nulia jurangu kaukaubala nganai. ");
INSERT INTO dif_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Nulupini ngana pirna ngankala nganai, ngangau ngakanandru Nulia manila nganai ja jurangu kaukaubala nganai. ");
INSERT INTO dif_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Warupoto, mina Ngaperali ngamalkai, ngakani nganai; jendrangundruja ngani jatana warai: Ngakanandru Nulia jenia manila nganai, ja jurangu kaukaubala nganai.");
INSERT INTO dif_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Miljaru wordu, ja jura ngana wata najila nganai, ja nakaldra miljaru wordu, ja jura ngana najila nganai, ngangau ngani Ngaperani wapai. ");
INSERT INTO dif_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Mili palpa nunkani ngankamalina wonti: „Mina jenia nganai, mina Nauja jatai ngaianangu: Miljaru wordu, ja jura ngana wata najila nganai, ja nakaldra miljaru wordu, ja jura ngana najila nganai, ja ngani Ngaperani wapai?“ ");
INSERT INTO dif_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Tana jatana wonti: „Mina jenia nganai, Nauja jatai: Miljaru wordu? Ko ngaiani nganai, mina Nauja jatai.“ ");
INSERT INTO dif_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesujeli ngujamana wonti tana jertapaterina nina jakalkala, ja Nau tanangu jatana wonti: „Jendrangundruja jura jakalkijiribamaliai, ngangau ngani jatana warai: Miljaru wordu, ja jura ngana wata najila nganai, ja nakaldra miljaru wordu, ja jura ngana najila nganai?“ ");
INSERT INTO dif_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Morlalu, morlalu, ngani jurangu jatai: „Jura jindrala nganai ja juajuangala nganai, ja mitala mankila nganai; ja jura ngaurongauro ngamala nganai, ja ngaurongaurola jurani mankilala karitjila nganai. ");
INSERT INTO dif_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Widlali kupa dankanani, nandru ngaurongaurola ngamalkai, ngangau ditji nankani matja wokarana; ja nandra kupa matja dankana, nandru wata morla japa ngundrai mankinandru, ngangau kana kulno mitani matja dankana. ");
INSERT INTO dif_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ja jura karari ngaurongaurola ngamalkai; ja ngato jurana nakaldra najila nganai ja jurani ngara mankila nganai, ja mankini jurani wata kulnujeli jurangundru manila nganai. ");
INSERT INTO dif_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ja nunkangupini ditjini jura ngana wata jakalkala nganai. (Ngantjani‐jaura Rogate ditjini.) Morlalu, morlalu, ngani jurangu jatai: Minakulno jura Ngaperandru ngatjinani talani ngakanani, Nulia jurangu jinkinani. ");
INSERT INTO dif_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Jura kararielu wata ngatjina warai talani ngakanani. Ngatjianimai ja jura manila nganai; jurani mankini manamiri pantjinanto.“ ");
INSERT INTO dif_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Jenia pratjana ngani jeribaka jaurali jurangu jatana warai; ja ditji wokarala nganai, nunkangu ngani wata morla jeribaka jaurali jurangu jatala nganai, a‐ai, ngato talku jurangu kaukaubala nganai ngakani Ngaperandru. ");
INSERT INTO dif_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nunkangupini diljini jura ngatjila nganai talani ngakanani. Ja ngani wata jurangu jatai, ngani Ngaperani ngatjila nganai jurangundru, ");
INSERT INTO dif_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ngangau Nulia Ngaperali muntali jurana ngantjai, ngangau jura ngana ngantjai ja morlalu ngundrai: Ngani Godandru dunkanala. ");
INSERT INTO dif_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ngani Ngaperandru dunkanala ja mitani wokaranala; nakaldra ngani mitandru puntila nganai ja Ngaperaia tikala nganai. ");
INSERT INTO dif_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Mili nunkangu jatana wonti: „Mai, karari jidni talku jatai ja wata jeribaka jaura jatai, ");
INSERT INTO dif_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Karari ngaiani ngujamai, warupotuni jidni milkila, ja wata kulnujeli jidna jakalkananto. Jendrangundruja ngaiani morlalu ngundrai: Jidni Godandru dunkanala.“");
INSERT INTO dif_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesujeli tanangu kalabana wonti: „Karari jura morlalu ngundrai?“ ");
INSERT INTO dif_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Mai, ditji wokarai ja karari matja wokarana, jura piltjaru pantjila nganai pilki ja pilki nunkanani, ja ngana kulnulu worani patala nganai, ja ngani wata kulnulu nganai, a‐ai, Ngaperi ngakangunto nganai. ");
INSERT INTO dif_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Tananapini ngato jurangu kaukaubana warai, ngangau jura ngakangu murla ngamalkananto. Mitani jura japa ngamalkai; murlali ngananau, ngato mita kalalu ngankana warai. ");
INSERT INTO dif_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ninapini Jesujeli kaukaubana wonti ja milkieli nunkanali pariwilpani najina tarana wonti ja jatana wonti: „Ngaperiai, ditji matja wokarana warai; Ngatamura jinkani pirna ngankamai, ngangau Ngatamurajeli jidna pirna ngankananto. ");
INSERT INTO dif_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Worderu jundru nunkangu ngurula jinkina wonti palku warupotuja, ngangau pratjana, mina jundru nunkangu jinkina wonti, Nulia tanangu jinkinanto, tepi ngurali. ");
INSERT INTO dif_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Naupini tepi ngurali nganai: Tannalia jidnana, kulnolu Goda morlalu, ja ninaia jundru jinpanala, Jesus Christus, ngujamananto. ");
INSERT INTO dif_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ngato jidnana mitani pirna ngankana warai, ja ninaia ngankani mudana warai, ninaia jundru ngakangu jinkina wonti ngato ninaia ngankananto. ");
INSERT INTO dif_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ja Ngaperiai! jundru karari ngana jinkangu pirna ngankamai nulupini pirnalali, ninaia ngato ngamalkana wonti jinkangu, windrila mita nganana wonti. ");
INSERT INTO dif_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ngato jinkani tala tinkari ngankana warai tanangupini kanani, tananaia jundru ngakangu jinkina warai mitandru. Jinkani tanaia nganana wonti, ja ngakangu jundru tananaia jinkina warai, ja jaura jinkani tanalia ngamalkana warai. ");
INSERT INTO dif_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Karari tanalia ngujamana warai, jenia pratjana, mina jundru ngakangu jinkina warai, jinkangundru nganai. ");
INSERT INTO dif_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ngangau tananaia jaura, tananaia jundru ngakangu jinkina wonti, ngato tanangu jinkina warai; ja tanalia tananaia patana warai ja morlalu ngundrana warai, ngani jinkangundru dunkanala, ja morlalu ngundrana warai, jundru ngana jinpanala. ");
INSERT INTO dif_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ngato tanangundru ngatjiai; wata mitandru ngani ngatjiai, a‐ai, windri tanangundru, tananaia jundru ngakangu jinkina warai, ngangau tanaia jinkani nganai. ");
INSERT INTO dif_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ja ngakani pratjana jinkani nganai, ja jinkani ngakani nganai, ja ngani tanangu pirna nganai. ");
INSERT INTO dif_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ja ngani wata morla mitani nganai, ja tanapini mitani nganai, ja ngani jinkangu wokarai. Ngaperi kulikiriai! Jinkani talani tananaia ngamalkamai, tananaia jundru ngakangu jinkina warai; ngangau tanaia kulnukulnuni nganananto ngaldrangu jeribaka. ");
INSERT INTO dif_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ngani tanangunto mitani nganana warai, ngato tananaia jinkani talani ngamalkana warai; tananaia, jundru ngakangu matja jinkina, ngato kulkana warai, ja wata kulno tanangundru tintaterina warai, windri tintaterini kupa kulnulu, ngangau jaura morlala pantjinanto. ");
INSERT INTO dif_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Karari ngani jinkangu wokarai, ja tananapini ngato mitani kaukaubai, ngangau tanalia ngakani mankini tanangu muntali manamiri ngamalkananto. ");
INSERT INTO dif_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ngato tanangu jaura jinkani jinkina warai, ja mitalali tanangu kalakalarina warai, ngangau tanaia wata mitandru nganai, worderu bakana ngani wata mitandru nganai. ");
INSERT INTO dif_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ngani wata ngatjiai, jundru tananaia mitandru maninanto, a‐ai, jundru tananaia kulkananto Madlentjani. ");
INSERT INTO dif_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Tanaia wata mitandru nganai, worderu ngani wata mitandru nganai. ");
INSERT INTO dif_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Morlalulali jinkanali tananaia kulikiri ngankamai; jaura jinkani morlalu nganai. ");
INSERT INTO dif_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Worderu jundru ngana mitaia jinpanala, jeruja bakana ngato tananaia mitani jinpana warai. ");
INSERT INTO dif_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ja ngani munta kulikiri ngankateriai tanangu, ngangau bakana tanaia kulikiri nganananto morlalulani. ");
INSERT INTO dif_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Wata windri tanangupini ngani ngatjiai, a‐ai, bakana tanangu, tanali jaurali tananali morlalu ngundrai ngakangu. ");
INSERT INTO dif_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ngangau pratjana kulnukulnuni nganananto, worderu jidni, Ngaperiai, ngakangu, ja ngani jinkangu, ngangau tana ngaldrangu kulnukulnuni nganananto; ngangau mitalali morlalu ngundrananto jundru ngana jinpanala. ");
INSERT INTO dif_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ja ngato ninapini pirnala, ninaia jundru ngakangu jinkinala, tanangu jinkina warai, ngangau tana kulnukulnuni nganananto, worderu ngaldra kulnukulnuni nganai. ");
INSERT INTO dif_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ngani tanangu ja jidni ngakangu, ngangau tana morlalu nganananto kulnukulnuni, ja ngangau mitalali ngujamananto jundru ngana jinpanala, ja jundru tanana ngantjanala, worderu jundru ngana ngantjanala. ");
INSERT INTO dif_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ngaperiai! Ngato ngantjai, woderi ngani nganai, naka bakana tana nganananto ngakangunto, tanana jundru ngakangu jinkina warai; ngangau tanali pirnala ngakani, ninapini jundru ngakangu jinkinala, najinanto, ngangau jundru ngana ngantjana wonti morla ngopera windrila mita pantjimala. ");
INSERT INTO dif_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ngaperi talkujai! Mitalali jidna wata ngujamana warai; ngato jidnana ngujamana warai, ja tanalipini ngujamana warai, jundru ngana jinpanala. ");
INSERT INTO dif_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ja ngato tanangu tala jinkani tinkari ngankana warai ja tinkari ngankala nganai, ngangau ngantjani, nulupini jundru ngana ngantjanala, tanangu nganananto, ja ngani tanangu.“ ");
INSERT INTO dif_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesus jenia matja jatana, Nau milinto dunkana wonti ja Kidron kaiarani pararana wonti; naka garden nganana wonti, nunkangu Nau ja mili nunkani wirina wonti. ");
INSERT INTO dif_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Bakana Judas, nulu nina wontawontana wonti, nina piri ngujamana wonti, ngangau Jesus nunkani milinto naka pota marapu jurborina wonti. ");
INSERT INTO dif_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Judasali kana wolara ja Priesta pirnaia ja Pharisaia mili matja patana, ja naka wokarana wonti turumanjali praitjali ja tirimalina potujeli. ");
INSERT INTO dif_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ngangau Jesus pratjana matja ngujamana, mina nunkangu wokarananto, Nau dunkana wonti ja tanangu jatana wonti: „Worana jura wontiai?“ ");
INSERT INTO dif_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Tanali nunkangu kalabana wonti: „Jesus Nazarenala.“ Jesus tanangu jatana wonti: „Ngani Nauja nganai.“ Ja bakana Judas, nulu nina wontawontana wonti, tanangunto terkana wonti. ");
INSERT INTO dif_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Worderu Jesus tanangu jatanani: „Ngani Nauja nganai,“ tana ngadatikana wonti ja mitani purina wonti. ");
INSERT INTO dif_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Nakaldra Nulu tanana jakalkana wonti: „Worana jura wontiai?“ Tana jatana wonti: „Jesus Nazarenala.“ ");
INSERT INTO dif_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesujeli kalabana wonti: „Ngani jurangu jatana warai, ngani Nauja nganai; jura ngana wontinani, tananaia worani patanau!“ ");
INSERT INTO dif_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ngangau naupini jaura morlalu pantjinanto, mina Nau jatana wonti: „Tanangundru, tanana jundru ngakangu jinkinala, ngato wata kulno tintana warai.“ ");
INSERT INTO dif_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simon Petrulu mardakirra ngamalkana wonti, ja nulu nina dukarana wonti ja Priesta pirnaia mili nandrana wonti, ja nina talpa ngunari wokaribana wonti; nau mili tala Malchus nganana wonti. ");
INSERT INTO dif_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesus Petrungu jatana wonti: „Mardakirra jinkani talani widmana tikau. Naupini koko, nina ngakangu Ngapili jinkinala, nina ngato wata tapananto?“ ");
INSERT INTO dif_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Kana wolarali ja juljaia kaparali ja Juda kanaia milieli Jesu patana wonti ja nina dupudupu ngankana wonti, ");
INSERT INTO dif_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ja tanali nina ngopera Hannasangu wapalkana wonti: Nau Kaiphani taru nganana wonti, nau nunkangupini kilpawoldrani Priesta pirna nganana wonti. ");
INSERT INTO dif_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiphas nau nganana wonti, nulu Juda kana kurukurubala wiri, jenia morla ngumu nganai, kana kulno palinanto kana wolarani. ");
INSERT INTO dif_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Jesungu Simon Petrus ja mili kulno karipaterina wonti. Ninapini mili Priesta pirnali ngujamana wonti, ja nau Jesungunto wirina wonti Priesta pirnaia pirini. ");
INSERT INTO dif_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Petrus manani palarani terkana wonti. Mili kulno, nina Priesta pirnali ngujamana wonti, dunkana wonti ja mana ngamalkanietja widlali ngankamalina wonti, ja Petrus wirilkana wonti. ");
INSERT INTO dif_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mana ngamalkanietja widla Petrungu jatana wonti: „Jidni bakana nunkanipini kanaia mili kulno nganai kara?“ Nau jatana wonti: „Wata ngani.“ ");
INSERT INTO dif_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","(Juda kanaia) mili ja (kaparaia) mili naka terkana wonti, tanali turu billa turu miribana wonti ja talpina wonti, ngangau kilpa nganana wonti. Ja bakana Petrus tanangunto terkana wonti ja talpina wonti. ");
INSERT INTO dif_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Priesta pirnali Jesus nunkani milindru ja nunkani ngujangujarandru jakalkana wonti. ");
INSERT INTO dif_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesujeli nunkangu kalabana wonti: „Ngato tinkari ja talku mitani kaukaubana warai, ngato milingeru jaura pungani ja Godaia pungani ngujangujara jinkina warai woderi Juda kana pratjana jurboriai, ja kurukuru ngato panila kaukaubana warai. ");
INSERT INTO dif_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Minandru jundru ngana jakalkai? Tanana jakalkau, tanali ngarana warai, mina ngato tanangu kaukaubana warai; mai, tana milkila mina ngani jatana warai.“ ");
INSERT INTO dif_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Nau jenia jatana, mili kulno naka terkana, nau Jesus ngadla nandrana wonti ja jatana wonti: „Jeruja jundru Priesta pirnani kalabai?“ ");
INSERT INTO dif_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesujeli nunkangu kalabana wonti: „Ngato madlentji kaukaubanani, tinkari ngankamai, jenia madlentji nganai; ngato manjujeli kaukaubanani, minandru jundru ngana nandrai?“ ");
INSERT INTO dif_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Hannasali nina dupudupu Kaiphangu Priesta pirnaia jinpana wonti. ");
INSERT INTO dif_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simon Petrus naka terkana wonti ja talpina wonti. Tana nunkangu jatana wonti: „Jidni bakana nunkanipini mili kulno nganai kara?“ Nau jedina wonti ja jatana wonti: „Wata ngani.“ ");
INSERT INTO dif_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Priesta pirnaia mili kulno, nunkanipini kamaneli nina talpa Petrulu wokaribana wonti, jatana wonti: „Ngato jidnana wata gardenani nunkangunto najina warai?“ ");
INSERT INTO dif_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Nakaldra Petrus jedina wonti, ja nurujeli paia ngaperi jatana wonti. ");
INSERT INTO dif_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Tanali Jesus Kaiphasangundru ngankamalini pungaia wapalkana wonti; ja nguramarani kuperi nganana wonti. Ja tana munta wata ngankamalini pungani wirina wonti, ngangau tana murumuru pantjiati, a‐ai, tanali Passa tajinanto. ");
INSERT INTO dif_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pilatus tanangu dunkana wonti ja jatana wonti: „Mina ngulku jura ngamalkai nunkangupini kanani?“ ");
INSERT INTO dif_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Tanali kalabana wonti ja nunkangu jatana wonti: „Naupini wata madlentji ngankanietja ngananani, ngaiani ninaia jinkangu wata ngulkujeli jinkinani.“ ");
INSERT INTO dif_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilatus tanangu jatana wonti: „Jura ninaia patanau, ja jurani jirijiribani jaurali ninaia kalala jinkianau!“ Juda kana jatana wonti: „Ngaianingu wata manuni kurala wapaia kulno naria nandrala.“ ");
INSERT INTO dif_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ngangau Jesuja jaura morlalu pantjinanto, nina Nau jatana warai wondrala, mina nari Nau palinanto. ");
INSERT INTO dif_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilatus nakaldra ngankamalini pungani wirina wonti ja Jesus karkana wonti ja nunkangu jatana wonti: „Jidni Juda kanaia Kapara nganai?“ ");
INSERT INTO dif_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesujeli nunkangu kalabana wonti: „Jidni munta jenia jatai kara, kana ngurujeli jenia jinkangu ngakangundru kaukaubana warai kara?“ ");
INSERT INTO dif_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatulu kalabana wonti: „Ngani Juda kana nganai? Jinkani kana wolarali ja Priesta pirnali jidnana ngakangu ngulkujeli jinkina warai; mina jundru ngankana warai?“ ");
INSERT INTO dif_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesujeli kalabana wonti: „Milila ngakani wata nunkangupini mitandru nganai; milila ngakani nunkangupini mitandru ngananani, ngakani mili tirimalinani, tanali ngana wata Juda kanani ngulkujeli jinkinanto. Jeruja milila ngakani wata ninkidandru nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilatus nunkangu jatana wonti: „Jeruja jidni Kapara nganai?“ Jesujeli kalabana wonti: „Jidni jenia jatai, ngani Kapara nganai. Ngani jendrania dankana wonti ja mitani jendrania wokarana wonti morlalulandru tinkari ngankala; worana morlalundru nganai, nulu ngaiala ngakani ngarai.“ ");
INSERT INTO dif_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilatus nunkangu jatana wonti: „Mina morlalu nganai?“ Ja nau jenia matja jatana, nau nakaldra Juda kanaia dunkana wonti ja tanangu jatana wonti: „Ngato wata madlentji nunkangu mankamankai. ");
INSERT INTO dif_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ngato milingeru jurangu jeruja ngankana warai; ngato jurangu kulno kurakananto Passani: Jura ngantjai, ngato jurangu Juda kanaia Kapaia kurakananto?“ ");
INSERT INTO dif_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Nakaldra pratjana maritjina wonti ja jatana wonti: „Wata ninapini, a‐ai, nina Barabbas.“ Barabbas watawatali maninietja nganana wonti. ");
INSERT INTO dif_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ngadani Pilatus Jesus manina wonti ja nina nandrana wonti. ");
INSERT INTO dif_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Mitaia kaparaia mili pirapira dakana wonti dilkandru, ja nunkangu mangatandrani kurana wonti ja nunkangu kati maralje widmana wonti, ");
INSERT INTO dif_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ja jatana wonti: „Murlali nganamai Juda kanaia Kapara!“ Ja nina ngadla nandrana wonti. ");
INSERT INTO dif_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilatus nakaldra dunkana wonti ja tanangu jatana wonti: „Najianau, ngato ninaia jurangu dunkalkai, jura ngujamananto, ngato nunkangu wata madlentji mankamankai.“ ");
INSERT INTO dif_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jesus dunkana wonti ja dilka pirapira ja kati maralje ngamalkana wonti; ja nau tanangu jatana wonti: „Najianau ninaia kana!“ ");
INSERT INTO dif_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Priesta pirnali ja milieli nina najinani, tana maritjina wonti ja jatana wonti: „Kunarkuni katibamai, kunarkuni katibamai!“ Pilatus tanangu jatana wonti: „Patanau jura ninaia ja kunarkuni katibanau; ngangau ngato nunkangu wata madlentji mankamankai.“ ");
INSERT INTO dif_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Juda kanali nunkangu kalabana wonti: „Ngaiani jirijiribani jaura ngamalkai, ja ngaianini jirijiribani jaurandru Nauja palinanto, ngangau Nauja munta Godaia Ngatamura ngankaterina warai.“ ");
INSERT INTO dif_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilatulu ninapini jaura matja ngarana, nau morla japali pantjina wonti. ");
INSERT INTO dif_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ja nau nakaldra ngankamalini pungani wirina wonti ja Jesungu jatana wonti: „Wodajerindru jundru nganai?“ Jesujeli nunkangu wata kalabani jaura jinkina wonti. ");
INSERT INTO dif_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilatus nunkangu jatana wonti: „Wata ngakangu jundru kaukaubai? Jidni wata milkila, ngato ngurula ngamalkai jidnana kunarkuni katibala kara, ja ngurula ngamalkai jidnana kurakala?“ ");
INSERT INTO dif_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesujeli kalabana wonti: „Jundru wata ngurula ngamalkai ngakangu, jundru nina wata mirindru maninani; jendrangundruja nulupini, nulu ngana jinkangu ngulkujeli jinkina warai, morla madlentji ngamalkai.“ ");
INSERT INTO dif_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Jendrangundruja Pilatulu wontina wonti nina kurakala. Juda kana maritjina wonti ja jatana wonti: „Jundru ninapini kurakanani, jidni wata morla mitaia kaparaia kamaneli nganai; worana munta kapara ngankateriai, nau kaparaia tula nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilatulu ninapini jaura matja ngarana, nulu Jesus dunkalkana wonti ja kalala jinkini pirini ngamana ngarina wonti; ninapini tanali dikai: „Marda piri; Juda kana talini Gabbatha.“ ");
INSERT INTO dif_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Passa ngankingani ditji nganana wonti, ja ditji dunkani kuperi; ja nau Juda kanani jatana wonti: „Najianau jurani Kapara!“ ");
INSERT INTO dif_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Tana maritjina wonti: „Woramai, woramai, kunarkuni ninaia katibamai!“ Pilatus tanangu jatana wonti: „Jurani Kapara ngato kunarkuni katibananto?“ Priesta pirnali kalabana wonti: „Ngaiani wata kapara ngamalkai, windri nina kapara Cäsar!“ ");
INSERT INTO dif_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ngadani nulu nina tanangu jinkina wonti, tanali nina kunarkuni katibananto. Tanali Jesus manina wonti ja nina wapalkana wonti. ");
INSERT INTO dif_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ja Nulu kunarku nunkani wilimana wonti, ja Nau dunkana wonti nunkangupini piria, nina tanali dikai: „Mangatandra piri; ja Juda kana talini Golgatha.“ ");
INSERT INTO dif_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ja naka tanali nina kunarkuni katibana wonti, ja nunkangunto mandru morla, jerra pankini ja jera pankini, ja Jesus terti. ");
INSERT INTO dif_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatulu bakana dakani miri dakana wonti, ja nina kunarkuni miri katibana wonti, ja jenia dakani ngananala: „Jesus Nazarethandru Juda Kanaia Kapara.“ ");
INSERT INTO dif_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ninapini dakani miri Juda kana marapujeli warapana wonti, ngangau ngurani karakara naupini piri nganana wonti, woderi tanali Jesus kunarkuni katibana wonti, ja dakani parana wonti Juda kana, Grieka kana, ja Roma kana talini. ");
INSERT INTO dif_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Juda kanaia Priesta pirna Pilatungu jatana wonti: „Wata dakamai, Juda kanaia Kapara, a‐ai, windri Naupini jatana warai: Ngani Juda kanaia Kapara nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilatulu kalabana wonti: „Mina ngato dakana warai, jenia ngato dakana warai.“ ");
INSERT INTO dif_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Mitaia kaparaia milieli Jesus kunarkuni matja katibana, tanali kati nunkani manina wonti ja buru mandru ja mandru ngankana wonti, milieli pilki ja pilki wora kulno, ja bakana kati pirna; ja kati pirna wata karpani nganana wonti, a‐ai, mirindru ngarinalujelu ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Tana ngankamalina wonti: „Ninaia ngaiana wata wokaribananto, a‐ai, nunkangundru ngaiana wontjani malka worananto wani nauja nganananto;“ ngangau jaura morlalu pantjinanto nauja jatai: „Tanali kati ngakani tanali puntibana wonti, ja ngakani kati pirnandru tanali wontjani malka worana wonti.“ Tananapini mitaia kaparaia milieli ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jesuni kunarkuni ngandri nunkani ja nunkanaia ngandria kaku, Maria, Kleophani noa, ja Maria Magdalala terkana wonti. ");
INSERT INTO dif_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesujeli ngandri nunkani, ja nina mili, nina Nulu ngantjanala, naka terkanani najina wonti, Nau ngandrini nunkanani jatana wonti: „Widlajai, najiau jinkani ngatamura!“ ");
INSERT INTO dif_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ngadani Nau milini jatana wonti: „Najiau jinkani ngandri!“ Ja nunkangupini ditjindru milieli nana pungaia nunkanaia manina wonti. ");
INSERT INTO dif_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ngadani, ngangau Jesus milkila nganana wonti, pratjana matja mudana warai, ngangau jaura kantji morlalu pantjinanto, Nau jatana wonti: „Ngani tertieli nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Naka koko kulno kaldrinto manamiri terkana wonti; tanali miritipa kulno kaldrini multibana wonti, ja nina Ysopani kurana wonti, ja nina nunkangu manani kurana tarana wonti. ");
INSERT INTO dif_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesujeli kaldri matja manina, Nau jatana wonti: „Matja mudai!“ Ja Nau mangatandra buruna ngarina wonti ja palina wonti. ");
INSERT INTO dif_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ngangau ngankingani ditji nganana wonti, ja palku wora wata kunarkuni parananto Sabbat ditjini, ngangau naupini Sabbat ditji pirna nganana wonti, Juda kana Pilatungu ngatjina wonti, tanali tanangu moku wokaribananto ja tanana ngarilkananto. ");
INSERT INTO dif_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Mitaia kaparaia mili wokarana wonti, ja ngoperalaia moku wokaribana wonti, ja kulno nguruni, nau nunkangunto kunarkuni parana wonti. ");
INSERT INTO dif_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Tana Jesungu wokarana wonti ja najina wonti Nau matia palina warai, tanali nina moku wata wokaribana wonti, ");
INSERT INTO dif_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","A‐ai, kaparaia mili kulnujeli kaltieli nina pankitiri dakana wonti, ja nurujeli kumari ja ngapa dunkana wonti. ");
INSERT INTO dif_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ja nulia jenia najina wonti, nulia jenia tinkari ngankana wonti, ja tinkari ngankani nunkani morlalu nganai, ja nauja milkila nauja morlalu jatai, ngangau jura morlalu ngundrananto. ");
INSERT INTO dif_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Jenia pantjina wonti, ngangau jaura morlalu pantjinanto: „Wata moku kulno tanali nina wokaribananto.“ ");
INSERT INTO dif_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ja nakaldra jaura kulno jatai: „Tanali nina najila nganai, nina tanali dakana wonti.“ ");
INSERT INTO dif_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ngadani Joseph Arimathiandru, nau Jesuja mili nganana wonti windri kurukuru, ngangau nau Juda kanandru japali nganana wonti, Pilatungu ngatjina wonti, nulu nina manuni kurananto Jesuja palku ngarilkananto. Ja Pilatulu jenia manuni kurana wonti. Nau wokarana wonti ja Jesuja palku ngarilkana wonti. ");
INSERT INTO dif_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Bakana Nikodemus wokarana wonti, nau ngopera tinkani Jesungu wokarana paraia ja kaldri pilki ja Aloe marapu matja duldruwana, padakana wonti. ");
INSERT INTO dif_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Tanali Jesu palku manina wonti ja nina katieli karana wonti kaldri pilkinto, worderu Juda kanali milingeru todina wonti. ");
INSERT INTO dif_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Nunkangu pirini karakara, woderi tanali nina kunarkuni katibana wonti, garden nganana wonti, ja gardenani narikutu marra, nunkangu wata kulno todinala. ");
INSERT INTO dif_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Naka tanali Jesu kurana wonti Juda kanaia ngankingani ditjindru, ngangau narikutu karakara nganana wonti. ");
INSERT INTO dif_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Godaia ditjini Maria Magdalala nguramarani kuperi narikutuni wokarana wonti; ja nandru najina wonti marda narikutundru matja tiringana. ");
INSERT INTO dif_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Nani mindrina wonti ja Simon Petrungu, ja mili kulnuni, nina Jesujeli ngantjana wonti, wokarana wonti, ja pudlangu jatana wonti: „Tanali Kapara narikutundru manina warai, ja ngaiani ko, wodajeri tanali nina kurana warai.“ ");
INSERT INTO dif_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Petrus ja mili kulno dunkana wonti ja narikutuni wokarana wonti. ");
INSERT INTO dif_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Pudla jela mindrina wonti, ja mili kulno ngopera nganingana wonti Petrungu, ja nau ngopera narikutuni wokarana wonti. ");
INSERT INTO dif_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ja nulu buruna ngarina wonti, ja nulu kati paranani najina wonti, ja nau wata wirina wonti. ");
INSERT INTO dif_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simon Petrus, nau nunkangu karipaterina, wokarana wonti, ja nau narikutuni wirina wonti ja najina wonti kati paranani, ");
INSERT INTO dif_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ja kangukati, nina tanali nunkangu mangatandrani karala wiri, wata katini jela paranani, a‐ai, nina pilki karana wonti piri kulnuni. ");
INSERT INTO dif_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ngadani bakana mili kulno, nau ngopera narikutuni wokarana warai, wirina wonti, ja nulu najina wonti ja morlalu ngundrana wonti. ");
INSERT INTO dif_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ngangau tanali jaura wata milkila nganana wonti, Nau narindru tepi terkakananto. ");
INSERT INTO dif_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Pudla mili nakaldra tikana wonti pungaia. ");
INSERT INTO dif_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maria narikutuni pankini palarani terkana wonti ja jindrana wonti. Nani jindranali narikutuni buruna ngarina wonti, ");
INSERT INTO dif_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ja nandru angela mandru kati bulujeli ngamanani najina wonti, kulno mangatandrani ja kulno tidnani, woderi Jesu palku parana wonti. ");
INSERT INTO dif_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ja pudla nankangu jatana wonti: „Widlajai, minandru jidni jindrai?“ Nani pudlangu jatana wonti: „Ngangau tanali Kapara ngakani manina warai, ja ngani ko, wodajeri tanali nina kurana warai.“ ");
INSERT INTO dif_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nani jenia matja jatana, nandru najina karitjina wonti, ja Jesus terkanani najina wonti; ja nani ko nganana wonti Nau Jesus nganai. ");
INSERT INTO dif_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesus nankangu jatana wonti: „Widlajai, minandru jidni jindrai? Worana jundru wontiai?“ Nandru ngundrana wonti, Nau gardenngamalkanietja nganai, ja nunkangu jatana wonti: „Kaparajai, jundru nina padakana warai? Jatau ngakangu woderi jundru nina kurano warai, ja ngato nina manila nganai.“ ");
INSERT INTO dif_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesus nankangu jatana wonti: „Mariajai!“ Nani karitjina wonti ja nunkangu jatana wonti: „Rabbuni!“ jenia wondrai Ngujangujara jinkinietja. ");
INSERT INTO dif_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesus nankangu jatana wonti: „Ngana wata patau! ngangau ngani wata tarana warai ngakani Ngaperaia. Wapau ngatatani ngakanani ja tanangu jatau: Ngani tarai ngakani Ngaperani ja jurani Ngaperani, ja ngakani Godani ja jurani Godani.“ ");
INSERT INTO dif_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maria Magdalala wokarana wonti ja milini kaukaubana wonti nandru Kapara najina warai, ja Nau jenia nankangu jatana warai. ");
INSERT INTO dif_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Nunkangupini Godaia ditji kalkaurani mili pungani jela nganana wonti mana ngurunguruni, Juda kanandru japali; Jesus wokarana wonti ja tanangu terti terkana wonti, ja tanangu jatana wonti: „Murla jurangunto nganaiatimai!“ ");
INSERT INTO dif_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ja Nau jenia matja jatana, Nau tanangu mara panki wondraterina wonti. Ja mili mankina wonti, ngangau tanali nina najina wonti. ");
INSERT INTO dif_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jesus nakaldra tanangu jatana wonti: „Murla jurangunto nganaiatimai! Worderu Ngapili ngana jinpanala, jeruja ngato jurana jinpala wapaia.“ ");
INSERT INTO dif_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ja Nau jenia jatana, Nulu tanana pulkana wonti, ja tanangu jatana wonti: „Jaola kulikiri manianimai! ");
INSERT INTO dif_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Jura tanangu madlentji kalinganani, tanali tanangu kalingani nganananto; ja jura tanangu madlentji ngamalkanani, tanali tanangu ngamalkani nganananto.“");
INSERT INTO dif_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ja Thomas, marapratjana ja mandrundru kulno, nina tanali dikai Ditymus, wata tanangunto jela nganana wonti Jesus wokaranani. ");
INSERT INTO dif_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ja mili nguru nunkangu jatana wonti: „Ngaiani Kapara najina warai.“ Nau tanangu jatana wonti: „Wata ngato mardatjinpiri nunkani najinani ja nunkangu mardatjinpirani ngana mara wutju kuraterinani, wata ngato jenia morlalu ngundranani.“ ");
INSERT INTO dif_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ja ditji mara wora ja parkulani mili nunkani nakaldra jela nganana wonti, ja Thomas tanangunto. Jesus woka rana wonti mana ngurunguruni, ja tanangu terti terkana wonti ja jatana wonti: „Murla jurangunto nganaiatimai!“ ");
INSERT INTO dif_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ngadani Nau Thomasangu jatana wonti: „Mara wutju jinkani jera kurana pararamai, ja mara ngakani najiamai, ja mara jinkani jera kurana pararamai, ja nina pankitirini ngakanani kurateriamai, ja wata gilbariamai, a‐ai, morlalu ngundramai!“ ");
INSERT INTO dif_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Thomas kalabana wonti ja nunkangu jatana wonti: „Ngakani Kaparajai, ngakani Godajai!“ ");
INSERT INTO dif_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesus nunkangu jatana wonti: „Thomajai, jundru morlalu ngundrai; murlali pirna jenipara nganai, tana wata naji, nani ja morlalu ngundranani.“ ");
INSERT INTO dif_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Bakana malka morla marapu Jesujeli ngankana wonti milini, tanali tanana wata dakana warai nunkangupini jaurani. ");
INSERT INTO dif_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Tananapini matja dakana, jura morlalu ngundrananto, Jesus morlalu Christus nganai, Godaia Ngatamura; ja jura morlalu ngundrananto ja tepi ngamalkananto nunkani talani.");
INSERT INTO dif_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ngadani Jesus nakaldra milini wondraterina wonti Tiberias pantuni. Nau jeruja wondraterina wonti: ");
INSERT INTO dif_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Naka jelalu nganana wonti Simon Petrus ja Thomas, nina tanali dikai Ditymus, ja Nathanaeli Kanandru Galilaiani ja Zebedäuni ngatamura wulu, ja nunkani mili mandru morla. ");
INSERT INTO dif_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Petrus tanangu jatana wonti: „Ngani wapai paru manila.“ Tana nunkangu jatana wonti: „Bakana ngaiani jinkangu jela wapala nganai.“ Tana dunkana wonti ja nurujeli botani wirina wonti, ja nunkangupini tinkani tanali panila patana wonti. ");
INSERT INTO dif_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Matja tankubanarina, Jesus dirkalani terkana wonti; ja mili wata milkila nganana wonti Nau Jesus nganai. ");
INSERT INTO dif_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesus tanangu jatana wonti: „Kupa worajai, jura wata tajila ngamalkai?“ Tanali nunkangu kalabana wonti: „Pani.“ ");
INSERT INTO dif_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Nau tanangu jatana wonti: „Bota panki ngunarani jama woranau, ja jura mankamankala nganai!“ Tanali worana wonti, ja tana ngandandarina wonti nina parumala paru marapundru. ");
INSERT INTO dif_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Naupini mili, nina Jesujeli ngantjana wonti, Petrungu jatana wonti: „Nauja Kapara nganai!“ Simon Petrulu ngarana wonti Nau Kapara ngananani, nau katieli ngampina wonti, ngangau nau balu nganana wonti, ja ngapani kulkungana wonti. ");
INSERT INTO dif_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Mili nguru botali wokarana wonti, ngangau tana wata worita nganana wonti dirkalandru, a‐ai, windri tintipitiwidri 200, ja tanali jama parunto parumana wonti. ");
INSERT INTO dif_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Tana matja dirkalaia dunkana tarana, tanali najina wonti turubilla turu paranani, ja paru nunkangupini paranani, ja buka. ");
INSERT INTO dif_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesus tanangu jatana wonti: „Padakanau tanangupini parundru, tananaia jura karari patana warai!“ ");
INSERT INTO dif_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Petrus wapana wonti, ja jama dirkalaia parumana tarana wonti, paru pirna manamiri 153. Jeruntjajeli jama wata purana wonti. ");
INSERT INTO dif_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesus tanangu jatana wonti: „Kaparanau, manabuka tajanau.“ Wata mili kulno wontjana wonti nina jakalkala: „Worana jidni?“ Ngangau tana milkila nganana wonti, Nau Kapara nganana wonti. ");
INSERT INTO dif_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesus wokarana wonti, ja buka patana wonti, ja tanangu jinkina wonti, ja bakana parundru. ");
INSERT INTO dif_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Naupini pota parkulu nganai, Jesus milini wondraterina wonti, Nau narindru matja tepi terkakana warai. ");
INSERT INTO dif_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Tanali manabuka matja tajina, Jesus Simon Petrungu jatana wonti: „Simoniai, Jonani ngatamurajai! Jundru ngana morla ngantjai tanangupini?“ Nau nunkangu jatana wonti: „Kau Kaparajai, jidni milkila, ngato jidnana ngantjai.“ Nau nunkangu jatana wonti: „Ngakani tjipi kuparu ngamalkau!“ ");
INSERT INTO dif_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Nau nakaldra pota mandrula nunkangu jatana wonti: „Simon Jonaniai! Jundru ngana ngantjai?“ Nau nuukangu jatana wonti: „Kau Kaparajai, jidni milkila, ngato jidnana ngantjai.“ Nau nunkangu jatana wonti: „Ngakani tjipi ngamalkau!“ ");
INSERT INTO dif_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Nau pota parkulula nunkangu jatana wonti: „Simon Jonaniai! Jundru ngana ngantjai?“ Petrus ngaurongauro nganana wonti, ngangau Nau pota parkulu nunkangu jatana wonti: „Jundru ngana ngantjai?“ Ja nau nunkangu jatana wonti: „Kaparajai, warupoto jundru milkila, jundru ngujamai, ngato jidnana ngantjai.“ Jesus nunkangu jatana wonti: „Ngakani tjipi ngamalkau! ");
INSERT INTO dif_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Morlalu, morlalu, ngani jinkangu jatai: Jidni teri ngananala, jidni munta ngampinala, ja wirarinala woderi jundru ngantjanala; jidni matja pinaru pantjina, jidni mara jinkani ngutaterila nganai, ja kulno ngurujeli jidna ngampipala nganai, ja wapalkala nganai woderu jundru wata ngantjai.“ ");
INSERT INTO dif_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ninapini Nau jatana wonti wondrala, mina narieli nulu Goda pirna ngankananto. Ja Nau jenia matja jatana, Nau nunkangu jatana wonti: „Ngakangu karipateriau!“ ");
INSERT INTO dif_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petrus karitjinawontikana wonti, ja nulu nina mili karipaterinani najina wonti, nina Jesujeli ngantjana wonti, nau bakana bukani nunkangu munambirini jeniterina wonti ja jatana wonti: „Kaparajai, worananau nganai nulu jidna wondawondala nganai?“ ");
INSERT INTO dif_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Nina Petrulu najina, nau Jesungu jatana wonti: „Kaparajai, mina nunkangupini?“ ");
INSERT INTO dif_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesus nunkangu jatana wonti: „Ngato ngantjanani nauja ngamananto ngani wokaranantulu, mina jenia jinkangu? Jindi ngakangu karipateriau!“ ");
INSERT INTO dif_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Naupini jaura ngatatani karitjinawontiwontikana wonti: „Naupini mili wata paliai.“ Ja Jesus wata nunkangu jatana wonti: Nauja wata paliai, a‐ai, windri: Ngato ngantjanani nauja nganananto ngani wokaranantulu, mina jenia jinkangu? ");
INSERT INTO dif_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Naupini nau mili nganai, nulu tanangundru tinkari ngankai, ja tananapini dakana wonti; ja ngaiani milkila, nunkani tinkari ngankani morlalu nganai. ");
INSERT INTO dif_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Marapu morla nganai, mina Jesujeli ngankana wonti, tanali jenia pilki ja pilki dakanani, ngato ngundrai, mitali tanana jaura pratjana, matja dakanani, wata patala nganai.");
INSERT INTO dif_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Kaukaubani jaura ngopera ngato dakana warai, Theophilajai, pratjanandru mina Jesujeli wonina wonti ngankala ja ngujangujara jinkila, ");
INSERT INTO dif_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Nunkangupini ditjielu windrila Nauja tarala, Nulia Apostel worangu, tanana Nulia kalkalkanala, Jaolali kulikirieli jirijiribana wonti: ");
INSERT INTO dif_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Tanangupini Nauja bakana tepila wondraterina wonti nunkani ketjaketjanani ngadani malka marapujeli, ja Nauja tanangu pira kulno ja ditji marapratjana wondraterina wonti, ja tanangu Godaia mililandru kaukaubana wonti. ");
INSERT INTO dif_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ja Nauja tanangu jela matja jurborina, Nulia tanangu jirijiribana wonti, tana wata Jerusalemingundru puntinanto, a‐ai, tanali Ngaperaia talpadakani kalkananto, nina jura ngakangundru ngarala wiri. ");
INSERT INTO dif_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ngangau Johannili ngapali multibana wonti; jura Jaolali kulikirieli multibanila manila nganai, tanangupini ditjini ngadani wolja. ");
INSERT INTO dif_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Tana matja jurborina, tanali ninaia jakalkana wonti ja jatana wonti: „Kaparajai! Jundru nunkangupini miljarani milila nakaldra ngankijiribala nganai Israelaia?“ ");
INSERT INTO dif_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Nauja tanangu jatana wonti: „Wata juranguta jenia parai miljaru kara ditji kara ngujamala, a‐ai, nina Ngapili kurana wonti ngurulali nunkanali muntali; ");
INSERT INTO dif_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Jura ngurula manila nganai, jurangu Jaola kulikiri matja ngarina, ja jura tinkari ngankanietja ngakani nganala nganai Jerusalemingu ja bakana Judaiani paruparu ja Samariani ja mitaia wondirajelu.“ ");
INSERT INTO dif_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ja Nauja jenia matja jatana, tanali ninaia najina wonti taranani, ja talara palkujeli ninaia manina wonti tanangu milki kantjini. ");
INSERT INTO dif_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ja tanali ninaia ngurutalpana najina taranani pariwilpani, ja mai, materi mandru kati warujeli tanangunto terkana wonti, ");
INSERT INTO dif_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Pudla bakana jatana wonti: „Jura Galilaiala materi worajai! Minani jura terkai ja pariwilpani najiai? Naupini Jesus, Nauja jurangundru pariwilpani tarana warai, nakaldra jeruka jeri tikala nganai, worderu jura ninaia najina warai pariwilpani taranani.“ ");
INSERT INTO dif_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ngadani tana Jerusalemia tikana kurana wonti mar dawonpandru, tala nunkani maninindri mardawonpa, nau Jerusalemingu karakara parai, windri Sabbat palto kulnuni worita. ");
INSERT INTO dif_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ja tana matja wirina, tana punga piri miria tarana wonti, woderi tana ngamana wonti: Petrus ja Johannes ja Jakobus ja Andreas, Philippus ja Thomas, Bartholomäus ja Matthäus, Jakobus Alphäuni ngatamura ja Simon Zelotes ja Judas Jakobuni ngatamura. ");
INSERT INTO dif_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Tanapini pratjana wonki kulnukulnuni nganana wonti ngatjila, widlali jelalu, ja bakana Maria Jesuni ngandri, ja ngatata nunkani jela. ");
INSERT INTO dif_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ja tanangupini ditjini Petrus milini terti terkana tarana wonti ja jatana wonti — Naka kana wolara jela ngamana wonti 120 kara —: ");
INSERT INTO dif_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Jura materi ja ngatata worajai! Naupini jaura morlalu pantjinanto, nina ngopera Jaolali kulikirieli Davidani manali talpadakana wonti Judasangundru, nau palto wondranietja pantjina paraia tanangu, tanali Jesus patana paraia; ");
INSERT INTO dif_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ngangau nau ngaianangunto jelarina wonti, ja ngaianangunto ninapini Ngamalkijiribani manina wonti. ");
INSERT INTO dif_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Nulupini mita buru burungankana paraia tjikatjikala kalalali, ja nau purina ngarina paraia, ja terti wokarina paraia, ja kudna nunkani pratjana balapurina paraia. ");
INSERT INTO dif_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jenia tinkari pantjina paraia pratjanani, tana Jerusalem ngamanani, jeruja tanali nina mita buru tanani talani dikai: Akeldama, jenia wondrai: Kumari mita. ");
INSERT INTO dif_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","„Ngangau Psalma jaurani dakanala parai: «Nunkani punga ngurawalpa parananto, ja wata kulno nunkangu ngamananto,» ja: «Nunkani ngamalkijiribani kulno nguru maninanto.» ");
INSERT INTO dif_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Jeruja tanangu materandru kulno, tanaia ngaianangunto wirarinala nunkangupini miljaruwirdi, nunkangu Jesus ngaianangu dunkanala ja wirinala, ");
INSERT INTO dif_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Johannini multibanandru nunkanipini ditjielu, Nauja ngaianangundru tarala wiri, tinkari ngankanietja pantjinanto nunkani tepi terkakanaia.“ ");
INSERT INTO dif_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ja tanali mandru terkibana wonti, Joseph, nina tanali dikai Barsabas, ja bakana Justus tala ngokana, ja Matthias. ");
INSERT INTO dif_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ja tana ngatjina wonti ja jatana wonti: „Jidni Kaparajai, jidni pratjanaia ngaraia ngujamanietja, wondramai pudlangundru kulno, worana jundru kalkalkana warai, ");
INSERT INTO dif_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Nulia maninanto ngamalkijiribanietjaia ja Apostelaia piri, nunkangundru Judas puntina paraia nunkani piri pilkia wapala.“ ");
INSERT INTO dif_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ja tanali pudlangu wontjani malka jinkina wonti. Ja wontjani malkali Matthias patana wonti, ja tanali nina Apostel marapratjana ja kulnuni jelaribana wonti. ");
INSERT INTO dif_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ja Jaolaia ditji matja wokarana, tana pratjana jela kulnukulnuni nganana wonti piri kulnuni. ");
INSERT INTO dif_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ja nurujeli pariwilpandru kirara pantjina wonti watara pirna jeribaka nau birunganani, ja nulu punga manamiri ngankana wonti woderi tana ngamanani. ");
INSERT INTO dif_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ja Jaola tiwilka turu jeribaka tanangu wondraterina wonti, ja Nauja tanangu marapuni pilki ja pilki ngamana ngarina wonti. ");
INSERT INTO dif_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ja tana pratjana manamiri pantjina wonti Jaolali kulikirieli, ja wonina wonti jatala tali nguruni, worderu Jaolali tanangu jinkina wonti jatananto. ");
INSERT INTO dif_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Jendranguta Juda kana Jerusalemingu ngamingana wonti, tana kana ngumu ja Godandru japali nganana wonti, kana wolara pratjanandru, tana pariwilpa ngalpani ngamanani. ");
INSERT INTO dif_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Jenia ngaiala matja pantjinani, kana wolara jurborina wonti ja ngaruparana wonti, ngangau tanali pratjanali tanana tanani tali pilki ja pilkini jatanani ngarana wonti. ");
INSERT INTO dif_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Tana pratjana japali pirna pantjina wonti ja ngaruparana wonti ja ngankamalina wonti: „Wata tanapini pratjana, tana jatai, Galilaiala nganai? ");
INSERT INTO dif_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Worderu ngaiana tanana ngarai pilki ja pilki tanani talini nunkangu ngaiana dankana wonti? ");
INSERT INTO dif_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Parthala ja Medala ja Elamitala, ja Mesopotamiala, Judaiala ja Kappadociala, Pondusala ja Asiala, ");
INSERT INTO dif_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Phrygiala ja Pamphyliala, Aegyptala ja Libya mitala Kyrenani karakara ja tula Romala; Juda kana ja Juda kana kamaneli. ");
INSERT INTO dif_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Kretala ja Arabiala, ngaiana tananaia ngarai jatanani ngaiananani talini Godaia ngankana pirna.“ ");
INSERT INTO dif_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ja tana pratjana japali pirna ja tjautjau pantjina wonti ja ngankamalina wonti: „Mina naupini pantjila nganai?“ ");
INSERT INTO dif_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ngurujeli ngirkibana jatana wonti: „Tanaia manamiri nganai waina marrali.“ ");
INSERT INTO dif_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Petrus terkakana wonti marapratjana ja kulnunto, ja nulu ngaiala nunkani miri ngankana wonti ja tanangu jeruja jatana wonti: „Juda kana worajai, ja pratjana jura Jerusalemingu ngamai, jenia jurangu tinkari nganananto, ja jaura ngakani jurani talpani wirinanto! ");
INSERT INTO dif_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ngangau tanaia wata parawarai worderu jura ngundrai, ngangau karari tankubana ditji miri nganai. ");
INSERT INTO dif_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","A‐ai, naupini nganai mina Joel Propheta jatana wonti: ");
INSERT INTO dif_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","«Ja jenia pantjila nganai ditji worangu ngadalani, Goda jatai, ngato ngakani Jaolandru palku warupotuni nangala nganai; ja jurani ngatamurajeli ja jurani ngatamura mankarajeli talpadakala nganai, ja jurani terieli malka mudla najila nganai, ja jurani pinarali ngapitja patala nganai; ");
INSERT INTO dif_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ja bakana ngakani milini ja mili widlani ngato tanangupini ditjini ngakani Jaolandru nangala nganai, ja tanali talpadakala nganai. ");
INSERT INTO dif_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ja ngato pirnala ngankala nganai pariwilpani taranalu, ja malka mitani ngarinalu, kumari ja turu ja turutupu; ");
INSERT INTO dif_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ditji pirna ngalpurani karitjila nganai ja pira kumarani, windrila Kaparaia ditji pirna ja tinkari wokarala nganai. ");
INSERT INTO dif_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ja pantjila nganai, warle Kaparaia tala ngatjina karkala nganai, nina Nulia kulkala nganai.» ");
INSERT INTO dif_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Israel materi worajai, tanapini jaura ngaranimai: Jesus Nazarethala, kana kulno ninaia Godali jurangu morlalu kurana wonti ngurungurujeli ja pirnalali ja malkali, tanana Godali jurangu terti nunkangundru ngankana paraia, worderu jura munta milkila. ");
INSERT INTO dif_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ninapini jura patana paraia, worderu Godali ngopera kurana wonti ja najina wonti, ja kana madlentjia marali kunarkuni katibana paraia, ja nari ngankana paraia. ");
INSERT INTO dif_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ninapini Godali jiritjibana paraia, Nulia naria ketjaketjana matja dukarana warai, ngangau jenia ngandandarina paraia, nulu ninaia milingeru patananto. ");
INSERT INTO dif_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ngangau David nunkangundru jatai: «Ngato ngurutalpana najina warai ngakani Kaparani, ngangau Nauja ngakangu ngunarani nganai, ngani wata wijiawijiabaterinanto. ");
INSERT INTO dif_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Jendrangundruja ngani ngara mankina warai, ja ngato talieli jurakokana warai; ja bakana ngani palku ngara ngamala nganai wolkareli kalkaterinani. ");
INSERT INTO dif_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ngangau jundru wata ngana mungara mitani ngarinalu worarala nganai, bakana wata manuni kurala nganai jinkani Kulikirila puapuarinani najinanto. ");
INSERT INTO dif_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Jundru ngakangu tepia palto wondraterina warai; jundru ngana manamiri ngankala nganai mankinali jinkani mudlani.» ");
INSERT INTO dif_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Materi worajai, ngatata worajai! Ngato manubakujeli jurangu kaukaubananto kapara jankuja ngaperi Davidandru, nau palina wonti ja tanali nina todina wonti, ja nunkani nariwonpa ngaianangu parai nunkanipini ditjielu. ");
INSERT INTO dif_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ngangau nau Propheta nganana wonti ja milkila nganana wonti Godali nunkangu jaura morlalulali talpadakana wonti, nunkanaia kapaia tandra kulno nunkani pirnalaia pirini ngamananto; ");
INSERT INTO dif_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Jeruja nulu jenia ngopera najina wonti, ja Christuni tepi terkakanandru kaukaubana wonti, Nulia ninaia mungara wata mitani ngarinalu worarana wonti, bakana Nulia palku puapuarina wata najina wonti. ");
INSERT INTO dif_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ninapini Jesus Godali jiritjibana paraia, ja nunkangundru ngaiani pratjana tinkari ngankanietja nganai. ");
INSERT INTO dif_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Nauja Godaia ngunarali matja tarana, ja Jaolaia kulikiria talpadakani Ngaperandru matja manina, Nulia jenia nangana warai, mina jura karari najila wapaia ja ngarala wapaia. ");
INSERT INTO dif_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ngangau David wata pariwilpaia tarana wonti, a‐ai, nau munta jatai: «Kaparali ngakani Kaparani jatana wonti: Ngakangu ngunarani ngamana ngariau, ");
INSERT INTO dif_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Ngato talpala jinkani jinkangu tidnani tidnapiri jeribaka kuranantulu.» ");
INSERT INTO dif_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Israelaia pungalali morlalu ngujamau, Godali ninaia Kapara ja Christus ngankana paraia, ninapini Jesus, ninaia jura kunarkuni katibana paraia.“ ");
INSERT INTO dif_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Tanali jenipara matja ngarana, jenia tanangu ngarani palkingana wonti, ja tana Petrungu ja Apostel worangu jatana wonti: „Materi worajai, neji worajai! Mina ngaiani ngankananto?“ ");
INSERT INTO dif_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petrus tanangu jatana wonti: „Madlentjandru karitjianau, ja pratjanali jurangundru multibanila manianimai Jesu Christuja talani madlentji kalingala, ja jura Jaola kulikiria poto manila nganai. ");
INSERT INTO dif_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ngangau talpadakani parai jurangu ja jurani kupani, ja pratjanani tana worita, jeruntja Godali Kaparali ngaianinali karkala nganai.“ ");
INSERT INTO dif_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ja jaura marapujeli morla nulu morlalu kurana wonti, ja tanana kurukurubana wonti ja jatana wonti: „Kulkani manianimai nunkangupini nguja tjautjauni!“ ");
INSERT INTO dif_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Tanalipini nunkani jaura matja patana tanali multibanila manina wonti; ja tanali nunkangupini ditjini kana 3000 morla ngokana wonti. ");
INSERT INTO dif_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Tana wonki ngamana wonti Apostel woranani ngujangujarani ja ngamalkijiribamalinani ja buka wokaribanani ja ngatjinani. ");
INSERT INTO dif_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ja mungara pratjana japali pantjina wonti, ja pirnala ja malka marapu pantjina wonti Apostel worangundru. ");
INSERT INTO dif_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Tanali morlalu ngundranani jelalu ngamana wonti, ja poto pratjana kulnukulnuni ngamalkana wonti. ");
INSERT INTO dif_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ja tanani mita ja poto tanali kalalaia jinkina wonti, ja pratjanani piltjaru ngankana wonti, worderu kulnujeli jenia ngamalkananto. ");
INSERT INTO dif_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ja tana ditji pratjanani Godaia pungani kulnukulnuni ngamana wonti, ja pungani pilki ja pilki tanali buka wokaribana wonti, ja buka manina wonti ngara mankinali ja manjujeli. ");
INSERT INTO dif_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ja tanali Goda jurakokana wonti, ja kana wolara tanangu murlali ngamana wonti. Kaparali ditji pratjanani mili wolarani morla kurana wonti tana tepi pantjinanto. ");
INSERT INTO dif_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Petrus ja Johannes jelalu Godaia pungaia tarana wonti ngatjini ditjini kalkaura ditji kunarkuni. ");
INSERT INTO dif_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ja kana kulno nganana wonti, nau ngandri mandrandru tjunduru nganana wonti, nina tanali waltana wonti; ja tanali nina ditji pratjanani Godaia pungaia manani, nina tanali dikai „ngumu“, kurana wonti, nulu poto ngatjinanto tanangu, tana Godaia pungani wirinani. ");
INSERT INTO dif_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nulupini Petrus ja Johannes najina wonti Godaia pungani wirinani, ja nau ngatjina wonti potuni. ");
INSERT INTO dif_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Petrulu nina ngurutalpana najina wonti ja bakana Johannil, ja jatana wonti: „Ngalina najiau!“ ");
INSERT INTO dif_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Nulu pudlana wolkareli najina wonti ja kalkana wonti minakulno pudlangundru manila. ");
INSERT INTO dif_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Petrus jatana wonti: „Mardatandra bulu ja mardatandra maralje ngato wata ngamalkai; mina ngato ngamalkai, ninaia ngato jinkangu jinkiai: Jesuja Christuja Nazarethalani talani terkakamai ja wirariamai!“ ");
INSERT INTO dif_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ja nulu nina mara ngunarani patana wonti, ja nina terkibana tarana wonti; ja nurujeli nunkani tidna ja tidnamoku nguru pantjina wonti. ");
INSERT INTO dif_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ja nau terkakala tarana wonti, ja naka terkana wonti ja wirarina wonti, ja nau pudlangu jela Godaia pungani wirina wonti, ja nulu wirarina ja kulkungana Goda jurakokana wonti. ");
INSERT INTO dif_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ja kana wolarali nina najina wonti wirarinani ja Goda jurakokanani. ");
INSERT INTO dif_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ja tanali nina ngujamana wonti nau naumata nganai, nau potuja Godaia pungaia mana ngumuni ngamana warai; ja tana pirna ngaruparana wonti ja ngarrana wonti jendrangundruja, mina nunkangu pantjina warai, ");
INSERT INTO dif_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ngangau nau tjundurula Petrungu ja Johanningu jela wapana wonti, kana wolara tanangu jurborina wonti nunkangupini pirini, nina tanali dikai Salamoni piri, ja tana pirna ngaruparana wonti. ");
INSERT INTO dif_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Petrulu jenia najina, nulu kana wolarani kalabana wonti: „Israel materi worajai! Minandru jura nunkangundru ngaruparala wapaia, ja minandru jura ngalina ngurutalpana najila wapaia, ngalinali ngurungurujeli kara talkulali kara ngali ninapini wirarinanto ngankana warai? ");
INSERT INTO dif_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abrahamani ja Isaakani ja Jakobani Godali, ngaperaia ngaiananaia Goda, mili nunkani pirna ngankana paraia, ninaia jura ngulkujeli jinkina paraia, ja jedieli worarana paraia Pilatungu, nulu ngundrana paraia ninaia kurakala. ");
INSERT INTO dif_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jura ninaia Kulikirila ja Talkula jedieli worarana paraia, ja ngatjina paraia, nulu jurangu kana kulno nari nandranietja jinkinanto. ");
INSERT INTO dif_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Tepia Kapara jura nari ngankana paraia, nina Godali narindru jiritjibana paraia, nunkangundru ngaiani tinkari ngankai, ");
INSERT INTO dif_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ja morlalu ngundranali nunkani talani ninapini ninkida, ninaia jura najiai ja ngujamai, nunkani talani ninapini ninkida, ninaia jura najiai ja ngujamai, nunkani talali ngurunguru ngankana warai; ja morlalu ngundranali nunkangundru, nunkangu jinkina warai, jurangu milki kantjini. ");
INSERT INTO dif_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Mai, ngatata warai, ngani milkila, jura jenia mangapunkujeli ngankana paraia, worderu bakana kaparali juranali. ");
INSERT INTO dif_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Godali jurangu morlalu ngankana paraia, mina Nulia Propheta pratjanaia manali talpadakana wonti Christus ketjaketjananto. ");
INSERT INTO dif_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Madlentjandru karitjianau ja karitjimalkaterianau, ngangau Nulia madlentji jurani kalingananto. ");
INSERT INTO dif_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ngangan miljaru malti wokarananto Kaparaia mudlandru, ja Nulia jurangu Jesus Christus jinpananto, nunkangundru tanali jurangu ngopera kaukaubana wonti, ");
INSERT INTO dif_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ninaia pariwilpali patananto tanangupini miljarajelu, Nulia pratjana nakaldra ngankinganantulu, mina Godali kaukaubana wonti nunkanaia Prophetaia kulikiria manali nguralindru. ");
INSERT INTO dif_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moses ngaperi worangu jatana wonti: «Propheta kulno ngakangu jeribaka Kaparali Godali juranali jurani ngatamurandru jiritjibala nganai, ninaia jura maramanjujeli ngarananto pratjanani, mina jurangu kaukaubala nganai; ");
INSERT INTO dif_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ja jenia pantjila nganai: Mungara pratjana, tanali ninapini Propheta bulu ngarala nganai, Nulia kana wolarandru teribala nganai.» ");
INSERT INTO dif_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Bakana Propheta pratjanali Samuelingundru ja witta ngadalandru pilki ja pilki, jeruntjali kaukaubana wonti, tanali bakana tanangupini ditji talpadakana wonti. ");
INSERT INTO dif_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Jura Prophetaia ngatamura nganai ja bakana Testamentaia, ninaia Godali ngaperani ngaiananani ngankana wonti, Nauja Abrahamangu jatana wonti: «Ja jinkani ngatamurani mitaia kana wolara warupoto murlali pantjinanto.» ");
INSERT INTO dif_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Jurangu Godali ngopera nunkani kupa Jesus jiritjibana paraia, ja ninaia jurangu jinpana wonti jurana ngurungutala; ngangau jura karitjinanto pratjana pilki ja pilki nunkani madlentjandru.“ ");
INSERT INTO dif_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pudlali kana wolarani kaukaubanani, pudlangu Priesta ja Godaia pungaia kapara, ja Sadducaia wokarana wonti, ");
INSERT INTO dif_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Tana buljubuljurina wonti, ngangau pudlali kana wolarani ngujangujara jinkina wonti ja Jesungu narindru jiritjini kaukaubana wonti. ");
INSERT INTO dif_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ja tanali mara pudlangu kurana wonti, ja pudlana kanjangari pungani widmana wonti tankubanajelu, ngangau karari kalkaura nganana wonti. ");
INSERT INTO dif_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Marapujeli tanangundru, tanali jaura matja ngarana, morlalu ngundrana wonti. Ja tana kana 5000 nganana wonti. ");
INSERT INTO dif_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Jendranguta ditji kulnuni tankutankubana tanani kana kapara ja pinaru ja jaura jinkinietja jurborina wonti Jerusalemingu, ");
INSERT INTO dif_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Bakana Hannas Priesta pirna ja Kaiphas ja Johannes ja Alexander, ja jeruntja Priesta pirnaia ngujandru nganana wonti. ");
INSERT INTO dif_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ja tanali pudlana tanangu terti terkibana wonti ja pudlana jakalkana wonti: „Mina ngurulali kara wani talani kara judla jenia ngankala wiri?“ ");
INSERT INTO dif_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Petrus Jaolali kulikirieli manamiri, tanangu jatana wonti: „Kana wolaraia kapara worajai ja Israelaia pinaru worajai! ");
INSERT INTO dif_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ngali karari kalala maninani nunkangupini ngumulandru kana muntjani, nunkangundru nauja tepi pantjila wiri? ");
INSERT INTO dif_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Jeruja jura pratjana ja Israel kana wolara milkila nganananto Jesuni Christuni Nazarethalani talani, ninaia jura kunarkuni katibana paraia, ninaia Godali narindru jiritjibana paraia, nunkangu naupini ninkida jurangu tepi terkala wapaia. ");
INSERT INTO dif_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Naupini nauja marda nganai, ninaia jura punga wotinietjali woraranala, nauja marda kapara pantjinala. ");
INSERT INTO dif_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ja wata kulno nguruni tepi nganai, ja wata tala nguru pariwilpaia ngalpani kanani matja jinkina, nunkangundru tanali tepi maninanto.“ ");
INSERT INTO dif_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Tanali Petruni ja Johannini manubaku najina wonti, ja ngujamana wonti pudla kana ko ja kiri pani, tana ngaruparana wonti, ja pudlana ngujamana wonti, pudla Jesungu jela ngamana paraia. ");
INSERT INTO dif_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Tanali nina kana, nau tepi pantjila wiri, pudlangu jela terkanani najina wonti, tanali panila ngamalkana wonti tjakakala. ");
INSERT INTO dif_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Tanali jirijiribana wonti, pudla kana kaparandru dunkananto; ja tanali ngankamalina wonti ja jatana wonti: ");
INSERT INTO dif_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","„Mina ngaiana pudlangupini kanani ngankananto? Ngangau malka morlalu pudlangundru pantjila wiri, jenia Jerusalemalani pratjanani tinkari nganai, ja ngaiana ngandandariai ninaia kutibala. ");
INSERT INTO dif_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Windri jenia wata morla pintipintikaritjinanto kana wolarani, ngaiana pudlana parparali dikidikibananto, pudlali wata morla nunkangupini talandru kana kulnuni kaukaubananto.“ ");
INSERT INTO dif_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ja tanali pudlana karkana wonti, ja pudlangu jirijiribana wonti, pudla ngapu nganananto, ja wata morla ngujangujara jinkinanto Jesuni talani. ");
INSERT INTO dif_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Petrulu ja Johannili tanangu kalabana wonti ja jatana wonti: „Muntali ngundranau, jenia Godandru talku nganai kara, ngali jurangu morla pankinanto Godangu. ");
INSERT INTO dif_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ngangau ngali ngandandariai worani patala kaukaubala nunkangundru, mina ngali najina wonti ja ngarana wonti.“ ");
INSERT INTO dif_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Tanali pudlana nakaldra dikidikibana wonti ja pudlana jinpana wonti; ngangau tanali wata mankamankana wonti, worderu tanali pudlangu kalala jinkinanto kana wolarandru; ngangau pratjanali Goda jurakokana wonti nunkangundru, mina pantjila wiri. ");
INSERT INTO dif_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ngangau kilpawoldra pota mandrumandru marapratjanani naupini kana, nunkangu nauja tepia malka pantjila wiri, wiringana wonti. ");
INSERT INTO dif_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Tanali pudlana matja kurakana warai, pudla pudlani kamanelini wokarana wonti, ja pratjana kaukaubana wonti, mina Priesta pirna ja kapara pudlangu jatana warai. ");
INSERT INTO dif_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Tanali jenia ngarana, tanali ngaiala kulnukulnuni parparali Godani miri ngankana wonti ja jatana wonti: „Kaparajai, jidni Goda, jundru pantjimana wonti pariwilpa ja mita maru ja panto pirna ja pratjana mina tanangu mandrani nganai. ");
INSERT INTO dif_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Jundru Davidali jinkanali milieli manali jatana wonti: «Minani kana ko tiririai, ja kana wolarali ngundrai bakuni?» ");
INSERT INTO dif_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Mitaia kapara wora terkakai, ja kapakapara manduiriai Kaparani ja nunkani Christuni, ");
INSERT INTO dif_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ngangau morlalu tana mapaterina paraia nunkangupini ngurani, jinkani Kupa kulikirini Jesungu, ninaia jundru wiribana wonti, Herodes ja Pontius Pilatus, kana koni ja Israel kana wolarani jela, ");
INSERT INTO dif_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Jeruja ngankala, mina jundru marali ja jinkani jertapaterinali ngopera kurana wonti jenia pantjinanto. ");
INSERT INTO dif_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ja karari Kaparajai, najiau tanani dikidikibani, ja jinkiau jinkani milini, tana manubakujeli jaura jinkani kaukaubananto; ");
INSERT INTO dif_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ja mara jinkani ngutateriau tepi ngankala, ja malka ja pirnala pantjinanto jinkani mili kulikiria Jesuni talani.“ ");
INSERT INTO dif_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ja tana matja ngatjina, naupini piri, woderi tana mapaterinani, wiltjiwiltjina wonti, ja tana pratjana Jaolali kulikirieli manamiri pantjina wonti, ja Godaia jaura manubakujeli kaukaubana wonti. ");
INSERT INTO dif_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Kana wolara pratjanali matja morlalu ngundrana, ngara kulno ja mungara kulno nganana wonti, ja wata kulno tanangundru nunkani potundru jatana wonti nau potuja kupana nganai, a‐ai, pratjana tanangu kulnukulnuni nganana wonti. ");
INSERT INTO dif_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ja ngurula pirnali Apostel worali Jesuja Christuja tepi terkakani tinkari ngankana wonti, ja murla pirna tanangu pratjanani nganana wonti. ");
INSERT INTO dif_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ngangau bakana wata wangiwangi kulno tanangu nganana wonti, a‐ai, jeruntjali tanangundru mita kara punga kara ngamalkana wonti, tanali jenia kalalaia jinkina wonti, ja kalala padakana wonti, ");
INSERT INTO dif_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Ja nina Apostel tidnani kurana wonti; ja tanali kulnuni ja kulnuni piltjaru ngankana wonti, worderuntja nulu ngamalkananto. ");
INSERT INTO dif_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Joses, nina Apostel worali dikana wonti Barnabas, jenia wondrai: „Ngankalkani ngatamura“ Levita kana Cyperala dankanala, ");
INSERT INTO dif_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Nulu maru kulno ngamalkana wonti, ja nulu nina kalalaia jinkina wonti ja mardatandra padakana wonti, ja nina Apostel tidnani kurana wonti. ");
INSERT INTO dif_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Kana kulnujeli, tala nunkani Ananias, Sapphirani noani nunkanani jela, mitaia kupana kalalaia jinkina wonti, ");
INSERT INTO dif_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ja nulu kalalandru palpa tjirimalkana wonti, ja bakana noa nunkani milkila nganana wonti, ja nulu buru kulno padakana wonti, ja Apostel worangu tidnani kurana wonti. ");
INSERT INTO dif_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Petrus jatana wonti: „Ananiajai! Minandru Satanali jidna ngara manamiri ngankana warai Jaola kulikirini jedila, ja mitaia kalalandru palpa tjirimalkala? ");
INSERT INTO dif_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Jundru nina ngamalkanani, nau wata potuja kupana jinkani ngananani; jundru nina kalalaia matja jinkina, nau bakana jinkani ngurulani nganana warai? Minandru jundru jenia ngarali jinkanali ngundrana warai? Wata kanani, a‐ai, Godani jidni jedina warai.“ ");
INSERT INTO dif_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananiasali tananapini jaura ngarana, nau purina wonti ja palina wonti. Ja tanali pratjanali, jenia matja ngarana, tana japali pirna pantjina wonti. ");
INSERT INTO dif_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Teri terkakana wonti, ja nina karana wonti, ja nina dunkalkana wonti, ja nina todina wonti. ");
INSERT INTO dif_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Jendranguta ditji pota parkulu karitjinani, noa nunkani wirina wonti, ja nani mangapunkujeli nganana wonti mina pantjina warai. ");
INSERT INTO dif_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petrulu nankangu kalabana wonti: „Jatau ngakangu, judla jeruntjajeli nina mita kalalaia jinkina warai?“ Nani jatana wonti: „Kau, jeruntjajeli.“ ");
INSERT INTO dif_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Petrus nankangu jatana wonti: „Minandru judla kulnukulnuni pantjina warai Kaparaia Jaola wontjala? Mai, tanapini tidna, tanalia noa jinkani todina warai manani terkala wapaia, ja tanalia bakana jidna todila nganai.“ ");
INSERT INTO dif_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Nani nurujeli nunkangu tidnani purina wonti ja palina wonti. Teri matja wirina, tanali nana nari mankamankana wonti, ja nana dunkalkana wonti, ja nana noani nankanani karakara todina wonti. ");
INSERT INTO dif_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ja mili wolarani japa pirna wokarana wonti, ja pratjanani, tanali jenia ngarana wonti. ");
INSERT INTO dif_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Apostel marali malka ja pirnala marapu kana wolarani pantjina wonti; ja pratjana kulnukulnuni jela ngamana wonti Salomonani pirini. ");
INSERT INTO dif_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Tanangundru ngurujeli wata kulnujeli wontjana wonti tanangu ngokamalila, windri kana wolarali tanana pirna ngundrana wonti. ");
INSERT INTO dif_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Morla ja morla ngokana wonti, tana Kaparani morlalu ngundrana wonti, materi ja widla worali, ");
INSERT INTO dif_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Jeruja tanali muntja palaraia dunkalkana wonti, ja tanana paltuwirdi turarani pirini ja wilimani pitani kurana wonti; ngangau Petrus wokaranani, windri pungalali nunkanali tanangundru kulno walpadakananto. ");
INSERT INTO dif_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Bakana kana wolara ngura karakarandru Jerusalemia jurborina wonti, ja tanali kana muntja ja tanana kutji murumurujeli jupanani padakana wonti, ja tana pratjana tepi pantjina wonti. ");
INSERT INTO dif_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Priesta pirna terkakana wonti, ja pratjana tana nunkangunto nganana, tana Sadducaia nguja, ja tana ngara jerkina wonti, ");
INSERT INTO dif_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ja tana Apostel worangu mara kurana wonti, ja tanana kanjangari pungani widmana wonti. ");
INSERT INTO dif_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Kaparaia angela kulnujeli tinkani kanjangaria pungaia mana walto ngankana wonti, ja tanana dunkalkana wonti ja jatana wonti: ");
INSERT INTO dif_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","„Wapau, ja Godaia pungani terkakanau, ja kana wolarani kaukaubanau tananapini tepia jaura pratjana!“ ");
INSERT INTO dif_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Tanali jenia matja ngarana, tana nguramarani kupiri Godaia pungani wirina wonti, ja ngujangujara jinkina wonti. Priesta pirna, ja tana nunkangunto nganana, matja wokarana, tanali kana kapara ja Israel kanaia pinaru pratjana karkana wonti, ja tanali kanjangari pungaia jinpana wonti, tanana manina tikananto. ");
INSERT INTO dif_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Mili naka matja wokarana, tanali tanana wata kanjangari pungani mankamankana wonti; ja tanana tikana kurana wonti ja kaukaubana wonti ");
INSERT INTO dif_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Ja jatana wonti: „Kanjangari punga ngaiani ngurunguru pirna mankamankana warai, ja najinajibanietja manani palarani terkanani; ngaiani matja walto ngankana, ngaiani wata kulno mandrani mankamankana warai.“ ");
INSERT INTO dif_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Priestali ja Godaia pungaia kaparali ja Priesta pirna worali tananapini jaura matja ngarana, tana tanangu wurpuru nganana wonti, mina jenia pantjinanto. ");
INSERT INTO dif_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Kulno wokarana wonti, ja tanangu kaukaubana wonti ja jatana wonti: „Mai, tana materi wora, tanana jura kanjangari pungani widmala wiri, tana Godaia pungani terkala wapaia, ja kana wolarani ngujangujara jinkila wapaia.“ ");
INSERT INTO dif_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Jendranguta juljaia kapara milinto wapana wonti, ja tanana wokaralkana wonti, wata watawatali, a‐ai, ngangau tana kana wolarandru japali nganana wonti, tanali tanana mardali dakaiati. ");
INSERT INTO dif_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ja tanali tanana matja wokaralkana, tanali tanana kana kaparani terkibana wonti. Ja Priesta pirnali tanana jakalkana wonti ja jatana wonti: ");
INSERT INTO dif_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","„Ngaiani jurana wata parparali daudauala wiri, wata ngujangujara jinkinanto nunkangupini talani? Ja mai, jura Jerusalem manamiri ngankana warai jurani ngujangujarali, ja ngantjai nunkangupini Kanaia kumari ngaianingu wokaralkala.“ ");
INSERT INTO dif_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Petrulu jo Apostel worali kalabana wonti ja jatana wonti: „Ngaiani Godani morla pankinanto kanani. ");
INSERT INTO dif_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ngaperi ngaiananaia Godali Jesus jiritjibana paraia, ninaia jura nari ngankana paraia, ja pitani warukijiribana paraia. ");
INSERT INTO dif_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ninapini Godali Kapara ja Kulkanipirna ngunarali nunkanali miri ngankana paraia, Israel kanani madlentjandru karitjini ja madlentji kalingani jinkila. ");
INSERT INTO dif_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ja ngaiani tinkari ngankanietja nunkani nganai tanangupini jaurani; ja Jaola kulikiri, ninapini Godali tanangu jinkina paraia, tana nunkangu pankiai.“ ");
INSERT INTO dif_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Tanali jenia matja ngarana, jenia tanangu ngarani palkingana wonti, ja tana manungana wonti, tanana nari ngankala. ");
INSERT INTO dif_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Kana kulno kaparandru, Pharisaiala, tala nunkani Gamaliel, terkana tarana wonti, nau jirijiribani jauraia ngujangujara jinkinietja nganana wonti, nina kana wolarali pirna ngundrana wonti; nulu jirijiribana wonti Apostel worana dunkalkala, ");
INSERT INTO dif_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ja tanangu jatana wonti: „Israel materi worajai! Ngamalkaterianau tanangupini kanani, mina jura ngundrai ngankala. ");
INSERT INTO dif_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ngangau tananguka ditjini ngopera Theudas terkakana wonti ja jatana wonti, nau pirna nganai; nunkangu kana marapu 400 kara jurborina wonti, nina tanali nari ngankana wonti, ja pratjana, tana nunkangu pankina wonti, piltjaru pantjina wonti, ja panila pantjina wonti. ");
INSERT INTO dif_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Nunkangupini ngadani Judas Galilaiala terkakana wonti windamani ditjini, ja nulu kana marapu danidanibana wonti nunkangu karipaterinanto; bakana naupini tintaterina wonti, ja pratjana tana nunkangu pankina wonti, piltjaru pantjina wonti. ");
INSERT INTO dif_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ja karari ngani jurangu jatai: Tananapini kana wata morla jupanau, ja tanana worani patanau; ngangau naupini ngundrana kara ngankana kara kanandru ngananani, nauja mudala nganai, ");
INSERT INTO dif_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Naupini Godandru ngananani, jura ngandandariai ninaia ngandrawalkala; jura jenipara kana mankamankaiati, tanaia Godangu tirimaliai.“ ");
INSERT INTO dif_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Tana nunkangu pankina wonti; ja tanali Apostel worana karkana wonti, ja tanana jinka wirrieli nandrana wonti, ja tanangu jirijiribana wonti, wata morla Jesuja talani kaukaubananto, ja tanali tanana jinpana wonti. ");
INSERT INTO dif_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Tana mankinali kana kapara mudlandru wapana wonti, ngangau tana talku nganana warai, nunkani talandru ninta manila. ");
INSERT INTO dif_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ja tanali wata mudana wonti ditjini pratjanani Godaia pungani ja punga worangu ngujangujara jinkila, ja Jesuni Christuni ngantjani jaura kaukaubala. ");
INSERT INTO dif_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Tanangupini ditjini mili morla marapu pantjinani, Grieka kana buljubuljurina wonti Juda kanani, ngangau tanali tanani mangawaru kuritarana wonti ditji pratjanaia jinkini. ");
INSERT INTO dif_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Marapratjana ja mandrujeli mili wolara jela karkana wonti ja jatana wonti: „Jenia wata ngumu nganai, ngaiana Godaia jaura worani patanani ja kurlia mili ngamanani. ");
INSERT INTO dif_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ngatata worajai! Materi mara wora ja mandru jurangundru wontianau, tanangundru kana ngumu jatai, Jaolali kulikirieli ja kirieli manamiri, tanana ngaiana kurananto nunkangupini manginani. ");
INSERT INTO dif_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ngaiana milingeru ngatjinanto ja Godaia jauraia ngamalkijiribananto.“ ");
INSERT INTO dif_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ja mili wolarali ninapini jaura ngantjana wonti; ja tanali Stephanus, kana kulno morlalu ngundrani, ja Jaolali kulikirieli manamiri, kalkalkana wonti, ja Philippus ja Prochorus ja Nikanor ja Timon ja Parmenas, ja Juda kanaia kamaneli Nikolaus Antiochiala. ");
INSERT INTO dif_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Tananapini tanali Apostel worangu terkibana wonti, ja tanali matja ngatjina, tanali tanangu mara kuraterina wonti. ");
INSERT INTO dif_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ja Godaia jaura punkana wonti, ja mili pirna marapurina wonti Jerusalemani, ja bakana Priesta marapujeli morlalu ngundranani pankina wonti. ");
INSERT INTO dif_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stephanulu, morlalu ngundranali ja ngurulali manamiri, pirnala ja malka pirna kana wolarani ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Palpa terkakana wonti tanangundru, tana Libertinaia ja Kyrenaia ja Alexandrinaia jaura pungandru nganana wonti, ja tanangundru, tana Ciliciala ja Asiala nganana wonti, Stephanusungu tjurbuwijiribamalila. ");
INSERT INTO dif_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ja tana ngandandarina wonti tjakakala kirilani ja jaolani, waninali nulu kaukaubana wonti. ");
INSERT INTO dif_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ngadani tanali palpali manawalkurali jinkina wonti, tana jatananto: „Ngaiani ninaia ngarana warai ngirkibani jaura jatanani Mosingu ju Godangu.“ ");
INSERT INTO dif_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ja tanali kana wolara ja pinaru ja jaura jinkinietja patijiritjibana wonti, ja wokarana wonti, ja tanali nina diadialkana wonti, ja nina kana kaparani wapalkana wonti, ");
INSERT INTO dif_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ja tanali jedikantji tinkari ngankanietja terkibana wonti, tana jatana wonti: „Nulupini kanali wata mudai ngirkibani jaura jatala nunkangupini piri kulikirini ja jirijiribani jaurani. ");
INSERT INTO dif_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ngangau ngaiani ninaia ngarana warai jatanani: Nulupini Jesujeli Nazarethalali ninapini piri tampuribala nganai, ja tananapini mangani, tanana ngaianangu Mosili jinkina wonti, pilki kurala nganai.“ ");
INSERT INTO dif_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ja pratjana, tana kana kaparani ngamana wonti, nina ngurutalpana najina wonti, ja tanali mudla nunkani najina wonti angelaia mudla jeribaka. ");
INSERT INTO dif_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Priesta pirna jatana wonti: „Jeruja jenia nganai?“ ");
INSERT INTO dif_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Nau jatana wonti: „Ngatata ja ngaperi ngantjalu, ngaranimarau! Pirnalaia Goda ngaperi ngaiananani Abrahamangu wondraterina wonti, nau Mesopotamia mitani ngamanala, windrila nau Haranani ngamanala, ");
INSERT INTO dif_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ja nunkangu jatana wonti: «Jinkani mitandru ja jinkani nguralandru puntiamai, ja mitaia palkamai, ninapini ngato jinkangu wondrala nganai.» ");
INSERT INTO dif_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ja nau Chaldaia mitandru puntina wonti ja Haranani ngamana wonti. Ja ngaperi nunkani matja nari, Nulia nina nakandru nguramanilkana wonti nunkangupini mitaia, nunkangu jura karari ngamala wapaia. ");
INSERT INTO dif_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ja Nulia nunkangu naka wata maratunka jinkina wonti, wata jeruntjaia worderunu tidna, ja nunkangu talpadakana wonti, Nulia ninapini mita nunkangu potuja kupana jinkila nganai, ja ngatamurani nunkanani nunkangu ngadani, windri nau kupa pani nganana wonti. ");
INSERT INTO dif_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Goda jeruja jatana wonti: «Ngatamura jinkani ngandrana nganala nganai mita tulani, ja tanali nina mili ngankala nganai, ja nunkangu madlentji ngankala nganai kilpawoldra 400. ");
INSERT INTO dif_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ja tanangupini kana wolarani, nunkangu tana mili nganala nganai, ngato kalala jinkila nganai, Goda jatana wonti, ja ngadani tana dunkala nganai, ja mili ngakani nganala nganai nunkangupini pirini.» ");
INSERT INTO dif_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ja Nulia tanangu karuwali ngankani Testamenta jinkina wonti; ja nulu Isaak kantji patana wonti, ja ditji mara wora ja parkulani nulu nina karuwali ngankana wonti, ja Isaakali nina Jakob, ja Jakobali ngaperi worani janku marapratjana ja mandru. ");
INSERT INTO dif_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Ja ngaperi worani jankujeli Josephangu milkirina wonti, ja nina Egypta mitaia kalalaia jinkina wonti; ja Goda nunkangunto nganana wonti, ");
INSERT INTO dif_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Ja Nulia nina nunkani ketjaketjana pratjanandru dukarana wonti, ja nunkangu murla ja kirila jinkina wonti Pharaoni Egypta mitaia kaparani, ja nulu nina kapakapara kurana wonti Egypta mitani ja pungani nunkanani. ");
INSERT INTO dif_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ja maua pirna ja ketjaketjana pirna Egypta mitani ja Kanaan mitani wokarana wonti; ja ngaperali worali ngaiananali buka pani mankamankana wonti. ");
INSERT INTO dif_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Jakobali matja ngarana, Egypta mitani buka tandra parai, nulu ngaperi worana ngaianani pota ngoperala jinpana wonti. ");
INSERT INTO dif_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ja pota mandrulani Joseph nejini nunkanani wondraterina wonti, ja Pharao Josephani nguja milkila pantjina wonti. ");
INSERT INTO dif_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Josephali jinpana wonti ja ngaperi nunkani Jakob ja ngurala nunkani pratjana manina tikana wonti, mungara 75. ");
INSERT INTO dif_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jakob Egypta mitaia ngarina wonti ja palina wonti, nau ja ngaperi wora ngaianani; ");
INSERT INTO dif_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ja tanali tanana Sichemia padakana wonti, ja nunkangupini narikutuni todina wonti, nina Abrahamali mardatandrali burungankana wonti Hemorani ngatamurandru Sichemangu. ");
INSERT INTO dif_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Worderu talpadakani miljaru karakararina wonti, nina Godali Abrahamangu morlalu kurana wonti, jeruja bakana kana wolara punkana wonti, ja munamaririna wonti Egypta mitani, ");
INSERT INTO dif_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Nunkanipini ditjielu, mitaia kapara nguru terkakanantulu, nau Josephandru ko nganana wonti. ");
INSERT INTO dif_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Nulupini ngaianani kana wolara kirieli jedibana wonti, ja ngaperi ngaianani jupana wonti ja jirijiribana wonti, tanali kupa waka worarana tikananto, ngangau tana wata tepi ngamananto. ");
INSERT INTO dif_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Nunkanguka miljarani Moses dankana wonti, ja kupa ngumu nganana wonti Godani; nina tanali pira parkulu pirna ngankana wonti ngaperaia nunkanaia pungani. ");
INSERT INTO dif_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Tanali bakana nina matja worarana tikana, nina Pharaonali mankarali patana wonti, ja nandru nina pirna ngankana wonti nankanila ngatani. ");
INSERT INTO dif_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ja Mosili ngujangujara manina wonti Egyptalani kirila pratjanani; ja nau ngurunguru nganana wonti jaurali ja ngankanali. ");
INSERT INTO dif_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Nau kilpawoldra 40 matja nganana, nunkangu ngarani wokarana wonti, ngatata nunkani, Israel ngatamura najila. ");
INSERT INTO dif_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ja nulu najina wonti, kulno talkundru ketjaketjanani, ja nunkangu nulu marangokana wonti, ja nunkangu talku jinkina wonti, nina nulu ngampu kalalu ngankanani, ja nulu Egypta kana naria nandrana wonti. ");
INSERT INTO dif_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Nulu ngundrana wonti, ngatatajeli nunkanali jenia ngujamananto, Godali marali nunkanali tanangu kulkani jinkinanto; tanali jenia wata ngujamana wonti. ");
INSERT INTO dif_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ja ditji kulnuni nau tanangu wondraterina wonti, ja mandru dilpamalina wonti, ja nulu pudlana parparali ngankana wonti murlali pantjinanto, ja jatana wonti: «Materi wulujai! judla ngatata nganai, minandru judla tjikatjika ngankijiribamaliai?» ");
INSERT INTO dif_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Nulu kamaneli nunkani tjikatjika ngankana warai, nina tertubana wonti ja jatana wonti: «Warle jidna ngalingu kapara ja kalala kuranietja kurana warai? ");
INSERT INTO dif_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Jundru ngantjai bakana ngana nari ngankala, worderu jundru woldrawirdi nina Egypta kana nari ngankala wiri?» ");
INSERT INTO dif_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moses nunkangupini jaurandru japa mindrina wonti, ja Midian mitani ngandrani pantjina wonti, ja naka nulu ngatamura mandru kantji patana wonti. ");
INSERT INTO dif_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Ja kilpawoldra 40 matja mudana, Sinaia mordawonpaia pitarani Kaparaia angela kulno nunkangu wondraterina wonti turu jaolali dilka nindrini. ");
INSERT INTO dif_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mosili nina najinani, nau mudlandru ngaruparana wonti; ja nau karakara matja wokarana nina najila, Kaparaia ngaiala nunkangu pantjina wonti: ");
INSERT INTO dif_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","«Ngani jinkanaia ngaperi woraia Goda nganai, Abrahamani Goda ja Isaakani Goda ja Jakobani Goda.» Mosili ngarrana wonti ja wata wontjana wonti morla najila. ");
INSERT INTO dif_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Kapara nunkangu jatana wonti: «Tidnaputa jinkani tidnandru dukarau, ngangau naupini piri, woderi jidni terkala wapaia, mita kulikiri nganai. ");
INSERT INTO dif_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ngato kantji najina warai, worderu tanali kana wolara ngakani Egypta mitani jupai, ja tanani kidakidani ngato ngarana warai, ja ngani ngarina warai tanana kulkala; ja karari kaparau, ngato jidna Egypta mitaia jinpala nganai.» ");
INSERT INTO dif_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Ninapini Mose, nina tanali bulu ngujamana wonti ja jatana wonti: «Warle jidna Kapara ja kalala kuranietja kurana warai?» Nina Godali kapara ja kulkanipirna jinpana wonti angelaia marali, nau nunkangu wondraterina wonti dilka nindrini. ");
INSERT INTO dif_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Nulupini tanana dunkalkana wonti, ja nulu malka ja pirnala ngankana wonti Egypta mitani ja panto maraljani ja pitarani kilpawoldra 40. ");
INSERT INTO dif_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Naupini nau Mose nganai, nau Israel ngatamurani jatana wonti: «Propheta kulno Kaparali juranali Godali jurangu jiritjibala nganai jurani ngatamurandru, ngana jeribaka, ninapini ngaralanganajatinimai.» ");
INSERT INTO dif_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Naupini nau nganai, nau mili wolarani pitarani angelani jela nganana wonti, nulu nunkangu Sinai mardawonpani ja ngaperani ngaiananani kaukaubana wonti, nulu tepia jaura patana wonti ngaianangu jinkila. ");
INSERT INTO dif_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Nunkangu ngaperi ngaianani wata ngantjana wonti pankila, a‐ai, tanali nina tertubana wonti, ja tanali ngarali tananali Egypta mitaia tikana kurana wonti. ");
INSERT INTO dif_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ja tana Aaronangu jatana wonti: «Ngaianingu Goda worana ngankijiribau, tana ngaianingu ngopera wapananto; ngangau ngaiani ko nganai, mina nunkangupini Mosingu, nulu ngaianina Egypta mitandru dunkalkana paraia, pantjila wiri.» ");
INSERT INTO dif_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ja tanali nganti kuparu ngankana wonti tananguka ditjini, ja tanali mudlamalkani poto ngumu jinkina wonti, ja tanana maraia ngankanani mankina wonti. ");
INSERT INTO dif_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Goda karitjinawontikana wonti, ja tanana jinkina wonti pariwilpaia wolarani wodatarana ngamala, worderu Prophetaia jaurani dakanala parai: «Jura ngakangu poto ngumu ja nandrani poto ngumu jinkina wonti kilpawoldrawirdi 40 pitarani, jura Israel pungajai? ");
INSERT INTO dif_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Kau, jura Molochani punga ja jurani Godaia Remphan ditji waka patana wonti, tanana mudlamalka, tanana jura ngankana wonti, tanangu ngatjila; ja ngato jurana Babylon jerankari kurala nganai.» ");
INSERT INTO dif_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Ngaianani ngaperi worali tinkaraia punga pitarani ngamalkana wonti, worderu Nulia, Nauja Mosingu ngankamalina wonti, jirijiribana wonti, nulu nina ngankananto nunkangu mudlani jeribaka, nina nulu najina wonti. ");
INSERT INTO dif_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ninapini ngaperali ngaiananali bakana manina wonti, ja nina Josua jela nunkangupini mitani padakana wonti, nina kana kojeli ngamalkana wonti, tanana Godali ngaperaia ngaiananaia mudlandru dangana wonti Davidani ditjielu. ");
INSERT INTO dif_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Nulupini Godangu manjula mankamankana wonti ja ngatjina wonti, nulu punga mankamankananto Jakobani Godani. ");
INSERT INTO dif_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Salomolu nunkangu punga wotina wonti. ");
INSERT INTO dif_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Windri Kapara pirna wata Godaia pungani ngamai, tanana kanali marali wotina warai, worderu Propheta jatana wonti: ");
INSERT INTO dif_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","«Pariwilpa ngakani pirnalaia piri nganai, ja mita ngakanaia tidnaia tidna piri; mina punga‐jura ngakangu wotinanto Kapara jatai; mina ngakani ngara ngamani piri nganai kara? ");
INSERT INTO dif_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Wata ngakani marali jenia pratjana ngankana wonti?» ");
INSERT INTO dif_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Jura kana wokara ngurunguru ja karuwali pani ngarani ja talpani, jura milingeru Jaola kulikirini tiririai, worderu ngaperi jurani jeruja bakana jura. ");
INSERT INTO dif_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Worangununkangu Propheta jurani ngaperi wora wata tirikaripaterina wonti? Ja tanali tanana nari ngankana wonti, tanali kaukaubana wonti kana talkuja wokaranandru, nunkani wondawondanietja ja nari nandranietja jura karari pantjina paraia; ");
INSERT INTO dif_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Jura, jura jirijiribani jaura manina wonti angelaia mangieli, ja ninapini wata ngamalkana warai.“ ");
INSERT INTO dif_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Tanali jenia ngarana, jenia tanangu ngarani palkingana wonti, ja tana manatandra mataterina wonti nunkangu. ");
INSERT INTO dif_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ja nau Jaolali kulikirieli manamiri nganana wonti, ja nulu pariwilpaia ngurutalpana najina tarana wonti, ja nulu Godaia pirnala najina wonti, ja Jesus Godaia ngunarani terkanani. ");
INSERT INTO dif_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ja nau jatana wonti: „Mai, ngato najila wapaia pariwilpa piririnani, ja Kanaia Ngatamura Godaia ngunarani terkanani.“ ");
INSERT INTO dif_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Tana ngaiala pirnali maritjina wonti, ja tanani talpa ngandrawalkaterina wonti, ja tirieli nunkangu kulnukulnuni mindrina pararana wonti. ");
INSERT INTO dif_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ja tanali nina ngurandru tertubana wonti, ja nina mardali naria dakana wonti. Ja tinkarietjali kati tanani kurana wonti kulnuja tidnani, tala nunkani Saulus. ");
INSERT INTO dif_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ja tanali Stephanus mardali naria dakana wonti, nulu karkana wonti ja jatana wonti: „Kapara Jesujai, jaola ngakani patamai!“ ");
INSERT INTO dif_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Nau pantjaterkana ngarina wonti, ja ngaiala pirnali karkana wonti; „Kaparajai, tanangu ninapini madlentji wata ngamalkamai!“ Ja nau jenia matja jatana, nau ngarapalina wonti. ");
INSERT INTO dif_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saululu nari nunkani ngantjana wonti. Tanangupini ditjini tirikaripaterina pirna pantjina wonti Jerusalem mili wolarani, ja pratjana piltjaru wapana wonti Judaia ja Samariaia mitaia pilki ja pilki, kalitakali Apostel ngamanani. ");
INSERT INTO dif_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Tanali materali, tana Godandru japali, Stephanus todina wonti, ja tana pirna juajuangana wonti nunkangundru. ");
INSERT INTO dif_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saululu mili wolara tjautjau ngankana wonti, ja nau pungani paruparu wirina wonti, ja materi ja widla watawatali dunkalkana wonti, ja tanana kanjangari pungani ngulkujeli jinkina wonti. ");
INSERT INTO dif_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Tana jeruja piltjaru pantjina, morla worita wapana wonti, ja jaura kaukaubana wonti. ");
INSERT INTO dif_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Philippus Samaria mitaia ngura kulnuja ngarina wonti, ja tanangu Christungundru kaukaubana wonti. ");
INSERT INTO dif_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Kana wolarali kulnukulnuni talpakaldrujeli ngarana wonti nunkangu, mina Philippus jatana wonti, tanali ngaranani ja malka najinani, tanana nulu ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ngangau kana marapu kutji murumurunto naka nganana wonti, tanangundru tanana maritjina pirnali dunkana wonti, ja dupudupu ja tjunduru marapu tepi pantjina wonti. ");
INSERT INTO dif_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ja mankina pirna pantjina wonti nunkangupini ngurani. ");
INSERT INTO dif_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Materi kulno, tala nunkani Simon, ngopara ngurani ngamana wonti, nau kunki nganana wonti, ja Samaria kana wolara ngaruparibana wonti, ngangau nau jatana wonti: „Ngani pirna nganai.“ ");
INSERT INTO dif_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Nunkangu pratjanali, wakali ja pirnali, pirna ngundrana wonti ja jatana wonti: „Naupini Godaia pirnala nganai, nauja pirna nganai.“ ");
INSERT INTO dif_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Jendrangundruja tanali nina pirna ngundrana wonti, ngangau nulu tanana miljaru wirdi kunki maninali ngaruparibana wonti. ");
INSERT INTO dif_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Tanali Philippungu morlalu ngundranani, nulu Godaia mililandru ja Jesuni Christuni talandru kaukaubanani, tanali materali ja widlali multibanila manina wonti. ");
INSERT INTO dif_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Bakana Simon muntali morlalu ngundrana wonti, ja multibanila manina wonti, ja Philippungu jela ngamana wonti; ja nulu malka ja ngurula pirna pantjinani najina wonti, nau pirna ngaruparana wonti. ");
INSERT INTO dif_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Apostel worali Jerusalemani matja ngarana, Samarialali Godaia jaura patala wiri, tanali tanangu Petrus ja Johannes jinpana wonti. ");
INSERT INTO dif_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Pudla ngarina wonti, ja tanangundru ngatjina wonti, tanali Jaola kulikiri maninanto. ");
INSERT INTO dif_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ngangau Nauja wata kulnuni tanangundru matja ngarina, a‐ai, tanali windri Kaparaia Christuni tala multibanila manina wonti. ");
INSERT INTO dif_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Pudla tanangu mara kuraterina wonti, ja tanali Jaola kulikiri manina wonti.");
INSERT INTO dif_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simonali matja najina, Jaola kulikiri ngarina warai Apostelali mara kuranani, nulu pudlangu mardatandra padakana wonti ");
INSERT INTO dif_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Ja jatana wonti: „Bakana ngakangu ninapini ngurula jinkialumai, ngangau pratjanali, tanangu ngani mara kuraterinani, Jaola kulikiri maninanto.“ ");
INSERT INTO dif_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Petrus nunkangu jatana wonti: „Jidni ja jinkani mardatandra turuja wirinanto, ngangau jundru ngundrai Godaia poto mardatandrajeli manila. ");
INSERT INTO dif_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Jinkangu wata buru ja wata maratunka parai nunkangupini jaurani, ngangau jidni ngara wata talku nganai Godangu. ");
INSERT INTO dif_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Nunkangupara jinkani tjikatjikandru karitjiau, ja Godangu ngatjiau, Nulia kara jinkanaia ngaraia ngundrani kalingananto. ");
INSERT INTO dif_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ngangau ngato najiai, jidni puratandraia kaldrini ja tjikatjikaia dupudupuni wirina warai.“ ");
INSERT INTO dif_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simonali kalabana wonti ja jatana wonti: „Judla ngakangundru Kaparani ngatjialumai, ngangau panila nunkangundru ngakangu wokarananto, mina judla jatana warai.“ ");
INSERT INTO dif_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pudla Kaparaia jaura matja tinkari ngankana ja kaukaubana, pudla Jerusalemia tikana wonti, ja pudlali ngantjani jaura kaukaubana wonti Samaritala ngura marapuni. ");
INSERT INTO dif_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Kaparaia angelali Philippungu kaukaubana wonti ja jatana wonti: „Terkakamai, ja kunankaria wapau, nunkangupini paltuni, nau Jerusalemingundru Gazaia ngariai, nau wanka nganai,“ ");
INSERT INTO dif_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ja nau terkakana wonti ja wapana wonti. Ja mai, materi kulno Aethiopiandru, nau eunucha ja Kandace Aethiopia mitaia kaparaia widlaia kana pirna kulno nganana wonti, nina nandru nankani poto pungani kurana wonti, nau Jerusalemingu wokarana wonti ngatjila; ");
INSERT INTO dif_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ja nau tikana kurana wonti, ja wilparani nunkanani ngamana wonti, ja Propheta Jesaias warapana wonti. ");
INSERT INTO dif_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Jaola Philippungu jatana wonti: „Wapau, ja nunkangupini wilparani karakara mindrindiau.“ ");
INSERT INTO dif_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Philippus matja karakara mindrindina wonti, ja nina Prophata Jesaias warapanani ngarana wonti ja jatana wonti: „Jundru bakana ngujamai, mina jundru warapai?“ ");
INSERT INTO dif_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Nau jatana wonti: „Worderu ngato ngujamananto, wata kulnujeli ngakangu ngujangujara jinkinani?“ Ja nau Philippungu ngatjina wonti tarananto nunkangu jela ngamala. ");
INSERT INTO dif_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Jaura witta, nina nulu warapanani, naupini nganana wonti: „Tanali ninaia tjipi jeribaka nari nandrala wapalkana wonti; ja Nauja ngapu nganana wonti tjipi kuparu jeribaka nunkani njurdu wokaribanietjani, jeruja Nauja mana wata wilpariai. ");
INSERT INTO dif_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Nunkani wakawakalani kalala nunkani mudana wonti; warle nunkani mardu kaukaubananto? Ngangau nunkani tepi mitandru matja manina.“ ");
INSERT INTO dif_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Eunuchali Philippungu kalabana wonti ja jatana wonti: „Ngani jinkangu ngatjiai, worangundru Propheta jenia jatai? Nunkangundru munta kara, kana ngurundru kara?“ ");
INSERT INTO dif_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Philippus mana wilparina wonti, ja nunkangupini jaurandru wonina wonti, ja nunkangu ngantjani jaura Jesungundru kaukaubana wonti. ");
INSERT INTO dif_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Pudla paltuwirdi wapana, pudla ngapani wokarana wonti, ja eunucha jatana wonti: „Najiau, ninkida ngapa nganai! Minali ngandrawalkai, ngato multibanila maninanto?“ ");
INSERT INTO dif_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Philippus jatana wonti: „Jundru ngarali morlalu ngundranani, jenia pantjinanto.“ Nulu kalabana wonti ja jatana wonti: „Ngato morlalu ngundrai Jesus Christus Godaia Ngatamura nganai.“ ");
INSERT INTO dif_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ja nulu jirijiribana wonti wilpara banbananto, ja pudla ngapaia ngarina wonti, Philippus ja eunucha, ja nulu nina multibana wonti. ");
INSERT INTO dif_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Pudla ngapandru matja dunkana tarana, Kaparaia Jaolali Philippus tjirimalkana wonti; ja eunuchali nina wata morla najina wonti; ja nau mankinali nunkani paltuni palkana wonti. ");
INSERT INTO dif_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Tanali Philippus Asdod ngurani mankamankana wonti. Ja nau wirarina wonti, ja nulu ngantjani jaura kaukaubana wonti ngura pratjanani, nau Cäsarea wokaranantulu. ");
INSERT INTO dif_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saulus milingeru ngaratupunga nganana wonti mili dikidikibala ja nari ngankala, ja nau Priesta pirnani wapana wonti, ");
INSERT INTO dif_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Ja nunkangundru dakani jaura Damaskus nguraia jaura pungani ngatjina wonti, ngangau nulu palpa nunkangupini paltuni mankamankanani, materi ja widla, nulu tana dupudupu Jerusalemia wapalkananto. ");
INSERT INTO dif_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Nau palkanani, ja Damaskus ngurani karakara wokarana, jendranguta nunkangu nurujeli praitji pariwilpandru mintjina karitjina wonti, ");
INSERT INTO dif_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ja nau mitani purina wonti, ja ngaiala kulno ngarana wonti nunkangu jatanani: „Saulujai, Saulujai, minandru jidni ngakangu tirikaripateriai?“ ");
INSERT INTO dif_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Nau jatana wonti: „Worana jidni nganai, Kaparajai?“ Kapara jatana wonti: „Ngani Jesus nganai, nunkangu jundru tirikaripateriai; jinkangu ngurunguru pantjila nganai dilkani dakala.“ ");
INSERT INTO dif_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Nau ngarrana wonti ja pirna ngaruparana wonti ja jatana wonti: „Kaparajai, mina jidni jertapateriai ngato ngankananto?“ Ja Kapara nunkangu jatana wonti: „Terkala tarau, ja ngurani wiriau, ja tana jinkangu jatala nganai, mina jundru ngankananto.“ ");
INSERT INTO dif_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Materi wora, tana nunkangunto palkana wonti, ngapu terkana wonti japandru, ngangau tanali ngaiala ngarana warai, ja wata kulno najina warai. ");
INSERT INTO dif_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saulus mitandru terkana tarana wonti; ja nau milki piririna wonti, nulu panila najina wonti; ja tanali nina mara patana wonti, ja nina Damaskus nguraia wapalkana wonti. ");
INSERT INTO dif_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ja nau ditji parkulu butju nganana wonti; ja nulu wata tajina wonti ja wata tapana wonti. ");
INSERT INTO dif_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damaskus ngurani mili kulno nganana wonti, tala nunkani Ananias, nunkangu Kapara mudlamalkali jatana wonti: „Ananiajai!“ Nau jatana wonti: „Ninkida ngani nganai, Kaparajai.“ ");
INSERT INTO dif_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Kapara nunkangu jatana wonti: „Terkakau ja wapau paltuja, nina tanali dikai «talku», ja Judani pungani jakalkau kulnuni, tala nunkani Saulus Tarsusala; ngangau mai, nau ngatjila wapaia, ");
INSERT INTO dif_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ja nulu mudlamalkani kana kulno, tala nunkani Ananias, wirinani ja nunkangu mara kuraterinani najina warai, nulu nakaldra najinanto.“ ");
INSERT INTO dif_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananiali kalabana wonti: „Kaparajai, ngato marapundru nunkangupini materandru ngarana warai, worderuntja madlentji nulu jinkani kulikirini ngankana warai Jerusalemingu; ");
INSERT INTO dif_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ja ninkida nulu ngurula ngamalkai Priesta pirnandru, dupudupu ngankala, tanali jinkani tala karkanani.“ ");
INSERT INTO dif_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Kapara nunkangu jatana wonti: „Wapau, naupini ngakangu ngankani poto ngumu nganai, nina ngato kalkalkana warai, nulu tala ngakani waltananto kana koni, ja mitaia kaparani, ja Israel ngatamurani. ");
INSERT INTO dif_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ngangau ngato nunkangu wondrala nganai, worderuntja nau ketjaketjananto ngakani talandru.“ ");
INSERT INTO dif_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananias wapana wonti ja pungani wirina wonti; ja nau nunkangu matja mara kuraterina, nau jatana wonti: „Ngatata Saul, Kaparali ngana jinpana warai, Naupini Jesus, Nauja jinkangu paltuni, nunkangupini jidni wokarala wiri, wondraterila wiri, jundru nakaldra najinanto ja Jaola kulikirieli manamiri pantjinanto.“ ");
INSERT INTO dif_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ja nurujeli nunkangu milkindru kulara jeribaka purina wonti, ja nulu nakaldra najina wonti, ja nau jiritjina wonti ja multibanila manina wonti. ");
INSERT INTO dif_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ja nulu buka matja tajina, nau nakaldra ngurunguru pantjina wonti. Ja nau Damaskus milini jela ditji palpa ngamana wonti. ");
INSERT INTO dif_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ja nurujeli nulu jaura pungani Jesus kaukaubana wonti, Naupini Godaia Ngatamura nganai. ");
INSERT INTO dif_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Pratjana, tanali nina ngarana, pirna ngaruparana wonti ja jatana wonti: „Wata naupini nau nganai, nulia Jerusalemingu pratjana piltjaru ngankana warai, tanali nunkangupini talani karkanani, ja nauja jendralia ninkida wokarala wiri, nulia tanana dupudupu Priesta pirnaia wapalkananto?“ ");
INSERT INTO dif_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Saulus milingeru morla ngurungururina wonti, ja nulu Juda kana, tana Damaskus ngurani ngamana wonti, tjautjau ngankana wonti, ngangau nulu morlalu kurana wonti: Naupini Christus nganai. ");
INSERT INTO dif_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ditji marapu matja mudana, Juda kana ngankamalina wonti, nina nari ngankala; ");
INSERT INTO dif_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Saulus tanani ngundrana milkila pantjina wonti. Ja tanali ngura mana ditjiwirdi ja tinkawirdi najinajibana wonti, nina nari ngankala. ");
INSERT INTO dif_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Milieli nina tinkani patana wonti, ja nina ngura wondirani wirilkana wonti, ja nina billieli ngarilkana wonti. ");
INSERT INTO dif_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saulus Jerusalemingu matja wokarana, nulu wontjana wonti milini ngokaterila; ja tana pratjana nunkangundru japali nganana wonti, ngangau tana wata morlalu ngundrana wonti, nau mili nganai. ");
INSERT INTO dif_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Barnabasali nina patana wonti, ja nina Apostel worangu wapalkana wonti, ja tanangu kaukaubana wonti, worderu nulu paltuni Kapara najina paraia, ja Nulia nunkangu ngankamalina paraia, ja worderu nulu Damaskus ngurani manabakujeli Jesuja talani tinkari ngankana paraia. ");
INSERT INTO dif_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ja nau tanangu jela nganana wonti, ja Jerusalem ngurani wirina wonti ja dunkana wonti; ja nulu Kaparaia talani manabakujeli tinkari ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Nulu kaukaubana wonti, ja bakana tjakakijiribamalina wonti Grieka kanani; tanali nina najinajibana wonti, nina nari ngankala. ");
INSERT INTO dif_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ngatatajeli jenia matja ngujamana, tanali nina Casareaja ngarilkana wonti, ja nina Tarsusuja jinpana wonti. ");
INSERT INTO dif_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Jeruja mili wolarali murla ngamalkana wonti Judaiani ja Galilaiani ja Samariani, ja tana munamarurina wonti, ja Kaparaia japani wirarina wonti, ja Jaola kulikiria ngankalkanali manamiri pantjina wonti. ");
INSERT INTO dif_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Jendranguta Petrus pratjanani wiringanani, nau bakana kulikirilani Lydda ngurani ngamanani, ngarina wonti. ");
INSERT INTO dif_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Naka nulu kana kulno, tala nunkani Aeneas, mankamankana wonti, nau kilpawoldra mara wora ja parkulu turarani pirini paranani, nau dupudupu nganana wonti. ");
INSERT INTO dif_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ja Petrus nunkangu jatana wonti: „Aeneajai, Jesus Christujeli jidna tepi ngankai: Jiritjiau, ja muntali turarani piri ngankingamai!“ Ja nurujeli nau jiritjina wonti. ");
INSERT INTO dif_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ja nina pratjanali najina wonti, tana Lyddangu ja Sarongu ngamana; ja tana Kaparaia karitjina wonti. ");
INSERT INTO dif_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Joppe ngurani miliwidla nganana wonti, tala nankani Tabitha, jenia wondrai Dorkas, nandru ngankana ngumu marapu ngankana wonti, ja kalumiltjamiltjarinali manamiri nga nana wonti. ");
INSERT INTO dif_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Jendranguta tanangupini ditjini, nani muntjarina wonti ja palina wonti; tanali nana kulirkana wonti, ja nana piri mirini kurana wonti. ");
INSERT INTO dif_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ngangau Lydda Joppingu karakara nganai, ja ngangau milieli ngarana wonti, Petrus naka ngamala wapaia, tanali materi mandru nunkangu jinpana wonti, nulu wata ngujawakananto wokarala. ");
INSERT INTO dif_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Petrus jiritjina wonti, ja tanangunto wapana wonti; ja nau naka matja wokarana, tanali nina punga miria taralkana wonti; ja nunkangu mangawaru pratjana wokarana wonti, ja tana jindrana wonti, ja nunkangu kati pirna ja kati waka wondralkana wonti, tanana Dorkasali ngankana warai, nani tanangunto ngananala. ");
INSERT INTO dif_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petrulu pratjana narrana wonti, ja nau pantjaterkana ngarina wonti ja ngatjina wonti; ja nulu palkuja nari najina karitjina wonti ja jatana wonti: „Tabithajai, jiritjiau!“ Nani milki tjenmana wonti, ja nandru Petrus najina, nani ngamana tarana wonti. ");
INSERT INTO dif_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Nulu nankangu mara jinkina wonti, ja nana jiritjibana tarana wonti, ja nulu kulikirila ja mangawaru karkana wonti, ja nana tepi wondralkana wonti. ");
INSERT INTO dif_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Joppala wolara jenia milkila pantjina wonti, ja marapujeli morlalu ngundrana wonti Kaparani. ");
INSERT INTO dif_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Jendranguta nau ditji marapu Joppeni ngamana wonti Simon kulnuni, nau tala ngankinganietja nganana wonti. ");
INSERT INTO dif_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kana kulno Cäsareani nganana wonti, tala nunkani Kornelius, nau juljaia kapara nganana wonti, tanana tanali dikai Italia wolarani; ");
INSERT INTO dif_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Nau talku ja Godandru japali nganana wonti nunkani pungalanto, nulu kana wolarani kalumiltjamiltjarina marapu jinkina wonti, ja milingeru Godani ngatjina wonti. ");
INSERT INTO dif_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Nulu mudlamalkali talku najina wonti, ditji kunarkuni Godaia angela nunkangu wokaranani ja jatanani: „Korneliusujai!“ ");
INSERT INTO dif_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Nulu nina ngurutalpana najina wonti, ja japali pantjina wonti, ja jatana wonti: „Mina nganai, Kaparajai?“ Nau nunkangu jatana wonti: „Jinkani ngatjini ja jinkani kalumiltjamiltjarini Godaia ngundranani tarana warai. ");
INSERT INTO dif_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ja karari materi jinpau Joppia, tanali karkananto Simon, nina tanali dikai Petrus; ");
INSERT INTO dif_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Nau Simon tala ngankinganietjani tidnapalara ngamai, nulu punga panto pirna dirkalani ngamalkai; nau jinkangu jatala nganai, mina jundru ngankananto.“ ");
INSERT INTO dif_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Nau angela, Korneliungu matja jatana, kutingana warai, nulu karkana wonti nunkani pungaia mili mandru ja mardakirraetja kulno, nau Godandru japali, tanangundru, tana nunkangu wonki ngamana wonti; ");
INSERT INTO dif_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ja nulu tanangu pratjana matja kaukaubana, nulu tanana Joppia jinpana wonti. ");
INSERT INTO dif_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ditji kulnuni, tana paltuni ngananani ja ngurani karakara wokaranani, Petrus pungaia mangatandraia tarana wonti ngatjila todani. ");
INSERT INTO dif_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Nau mauali pantjina wonti, ja ngantjana wonti palpa tajila; tanali nunkangu palpa wajina, nau ngaramarlarina wonti. ");
INSERT INTO dif_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ja nulu pariwilpa piririnani najina wonti, ja nunkangu ngarinani koko kulno, kati pirna jeribaka buru mandrumandruni ngurunguru, nani mitani ngarilkanani. ");
INSERT INTO dif_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Nunkangupini parana wonti mitaia nganti pratjana tidna mandrumandrunto ja nganti jampa ja tjutju ja ngaranala paia. ");
INSERT INTO dif_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ja ngaiala kulno nunkangu pantjina wonti: „Petrujai, terkala tarau, nandrau ja tajiau!“ ");
INSERT INTO dif_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Petrus jatana wonti: „A‐ai, Kaparajai! ngangau ngato wata pota kulno jampa ja murumuru tajina warai.“ ");
INSERT INTO dif_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ja nakaldra ngaiala nunkangu pantjina wonti, pota mandrulani: „Mina Godali kulirkana warai, ninapara jundru wata murumuru patau!“ ");
INSERT INTO dif_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Jenia pota parkulu pantjina wonti; ja nakaldra naupini koko pariwilpani taralkana tikana wonti. ");
INSERT INTO dif_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Petrus munta ko nganana wonti, mina nulupini mudlamalkali, nulu matja najina, wondrai kara; mai, tana materi, Korneliusulu matja jinpana, ja Simonani punga matja jakalkingana, manani terkana wonti, ");
INSERT INTO dif_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Karkana wonti ja jakalkana wonti, Simon, nina tanali dikai Petrus, nunkangupini pungani tidnapalara ngamai kara. ");
INSERT INTO dif_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Petrulu nunkangupini mudlamalkandru ngundranani, Jaolo nunkangu jatana wonti: „Mai, materi parkululali jidna wontiai; ");
INSERT INTO dif_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Terkala tarau ja ngariau, ja tanangunto palkau, ja wata mangangankau, ngangau ngato tanana jinpana warai.“ ");
INSERT INTO dif_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Petrus materaia matja ngarina, tanana Korneliusulu nunkangu jinpala wiri, nau jatana wonti: „Mai, ngani nauja nganai, ninaia jura wontila wapaia; minandru jura ninkida wokarana warai?“ ");
INSERT INTO dif_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Tana jatana wonti: „Kornelius, juljaia kaparali, kana talku ja Godangundru japali, nina Juda kana wolarali pirna ngundrai, jirijiribani jaura angela kulikirindru manila wiri, jidna nunkani pungaia karkananto, jinkangundru jaura ngarala.“ ");
INSERT INTO dif_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Nulu tanana karkana wonti wirinanto, ja nulu tanana ngamalkana wonti. Ditji kulnuni Petrus jiritjina wonti, ja tanangu jela palkana wonti, ja ngatata palpa Joppendru nunkangu jela wapana wonti. ");
INSERT INTO dif_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ja ditji kulnuni tana Cäsareani wokarana wonti. Korneliusulu ja nunkani nguralali ja kamaneli ngura kulnulali, tanana nulu mapana wonti, tanangu kalkana wonti. ");
INSERT INTO dif_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Jendranguta Petrus wirinani, Kornelius nunkangu mandurina wonti, ja nunkangu tidnani woraterina wonti, ja ngatjina wonti. ");
INSERT INTO dif_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Petrulu nina terkibala tarana wonti ja jatana wonti: „Terkakala taramai, ngani bakana kana nganai.“ ");
INSERT INTO dif_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ja nulupudla manju ngankamalina, nau wirina wonti, ja marapu mankamankana wonti, tana matja jurborina. ");
INSERT INTO dif_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ja nau tanangu jatana wonti: „Jura milkila, worderu Juda kanani wata manuni kurala wapaia tulani ngankamalinanto kara, wirinanto kara; windri Godali ngakangu wondrala wiri, wata kana kulno wokawaka kara murumuru kara dikananto. ");
INSERT INTO dif_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Jendrangundruja ngani wata delkila wiri wokarala, ngana karkanani. Jeruja ngato jakalkai, minandru jura ngana karkala wiri.“ ");
INSERT INTO dif_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ja Kornelius jatana wonti: „Ditji mandrumandruni ngopera, nunkangupini ditjielu karari, ngani milja ngamana warai; ja ditji kunarkuni ngani ngatjila wiri pungani ngakanani. Ja mai, kana kulnujeli kati kintjalkurujeli ngakangu terkala wiri, ");
INSERT INTO dif_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ja nau jatala wiri: «Godali jinkani ngatjini ngarana warai, ja jinkani kalumiltjamiltjarinandru jinkini Nulia ngundrana warai. ");
INSERT INTO dif_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Joppia jinpau, ja karkau Simon, nina tanali dikai Petrus; nau Simon tala ngankinganietjaia pungani, panto pirna dirkalani, tidnapalara ngamai.» ");
INSERT INTO dif_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Nurujeli ngato jinkangu jinpala wiri, ja jundru ngumu ngankana warai, jidni wokarala. Karari ngaiani pratjana Godani ngamai, pratjana ngarala, mina Godali jinkangu jirijiribala wiri.“ ");
INSERT INTO dif_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Petrus mana wilparina wonti ja jatana wonti: „Ngato morlalu ngujamala wapaia, Godali wata kana mudla ngundrai, ");
INSERT INTO dif_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","A‐ai, warle kana wolara pratjanani nunkangundru japali nganai, ja talkula ngankai, nina Nulia patai. ");
INSERT INTO dif_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Jura ngujamai ninaia jaura, ninapini Nulia Israel ngatamurani jinpana wonti, worderu Nulia Jesungu Christungundru murla kaukaubana wonti; Naupini warupotuja Kapara nganai. ");
INSERT INTO dif_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ninapini jaura, nauja Judaiani paruparu pantjinala, ja Galilaiani woninala, nunkangupini multibanilani ngadani, nina Johannili kaukaubana wonti: ");
INSERT INTO dif_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Jesus Nazarethalandru, worderu Godali nina Jaolali kulikirieli ja ngurulali wiribana wonti, Nauja wirarina wonti ja ngumu ngankana wonti, ja pratjana tepi ngankana wonti, tanana kutjieli jupanani; ngangau Goda nunkangunto nganana wonti. ");
INSERT INTO dif_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ja ngaiani tinkari ngankanietja pratjanandru nganai, mina Nulia ngankanala Judaia mitani ja Jerusalemingu. Ninaia tanali nari ngankana wonti, ja pitani warukijiribana wonti. ");
INSERT INTO dif_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ninapini Godali ditji parkulani jiritjibana wonti, ja ninaia wondralkana wonti. ");
INSERT INTO dif_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Wata kana wolara pratjanani, a‐ai, windri ngaianingu tinkari ngankanietjani, ngaianina Godali kalkalkanala, ngaiani nunkangu jela tajina wonti ja tapana wonti, Nauja narindru matja jiritjina. ");
INSERT INTO dif_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ja Nulia ngaianingu jirijiribana wonti, kana wolarani kaukaubananto, ja tinkari ngankananto: Ninaia Godali ngankana wonti kalala kuranietja tepia ja naria. ");
INSERT INTO dif_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Nunkangundru Propheta pratjanali tinkari ngankai, nunkani talandru warupotujeli, tana nunkangu morlalu ngundrai, madlentjaia kalinganila manila nganai.“ ");
INSERT INTO dif_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Petrus tananapini jaura jatanani, Jaola kulikiri tanangu pratjanani ngarina wonti, tanali jaura ngaranani. ");
INSERT INTO dif_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ja karu walila, tana morlalu ngundrana wonti, tana Petrungunto wokarana warai, pirna ngaruparana wonti, ngangau bakana kana koni Jaola kulikiri nangana warai. ");
INSERT INTO dif_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ngangau tanali tanana tali ngurujeli kaukaubanani ja Goda jurakokanani ngarana wonti. Ja Petrulu kalabana wonti: ");
INSERT INTO dif_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","„Kulnujeli ngapa ngandrawalkala nganai, tananaia wata multibananto, ngangau tanali Jaola kulikiri manina warai ngaianingu jeribaka?“ ");
INSERT INTO dif_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ja nulu jirijiribana wonti tanana multibala Kaparaia talani. Tana nunkangu ngatjina wonti, nau ditji palpa naka ngamananto. ");
INSERT INTO dif_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Apostel worali ja ngatata mara worali, tana Judaiani ngamana, ngarana wonti, bakana kana kojeli Godaia jaura patana warai. ");
INSERT INTO dif_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ja Petrus Jerusalemia matja tarana, tana karuwalilali jatamalina wonti nunkangu. ");
INSERT INTO dif_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ja jatana wonti: „Jidni kanani wirina paraia, tana wata karuwalila nganai, ja tanangu jela tajina paraia.“ ");
INSERT INTO dif_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Petrulu wonina wonti, ja tanangu warupotuni warapaterina wonti ja jatana wonti: ");
INSERT INTO dif_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","„Ngani Joppe ngurani matja ngatjinani, ja ngani ngaramarlarina paraia, ja mudlamalka najina paraia: Koko kulno, kati pirna jeribaka, buru mandru ja mandruni pariwilpandru ngarinani, ja nau ngakangu wokarana paraia. ");
INSERT INTO dif_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ja ngato nina ngurutalpana najina paraia, ja ngujangujamana paraia, ja ngato najina paraia mitaia nganti tidna mandrumandrunto ja nganti jampa ja tjutju ja paia ngaranala. ");
INSERT INTO dif_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ja ngato ngaiala ngakangu jatanani ngarana paraia: «Petrujai, terkala tarau, nandrau ja tajiau!» ");
INSERT INTO dif_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ngani jatana paraia: A‐ai, Kaparajai, ngangau jampa kara murumuru kara, wata pota kulno ngakangu manani wirina warai. ");
INSERT INTO dif_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ngaialali pariwilpandru pota mandrula ngakangu kalabana paraia: «Mina Godali kulirkana warai, ninapara jundru wata murumuru patau!» ");
INSERT INTO dif_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Jenia pota parkulu pantjina paraia; ja nakaldra pratjana pariwilpani taralkana tikana paraia. ");
INSERT INTO dif_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ja mai, nurujeli materi parkulu pungani terkana wirinani, nunkangu ngani ngamanani, tanana Cäsareandru ngakangu matja jinpana. ");
INSERT INTO dif_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Jaola ngakangu jatana paraia, ngani tanangu jela wapananto, wata mangangankani. Ngakangu jela bakana tanapini ngatata mara wora ja kulno wapana paraia, ja ngaiani nunkangupini materaia pungani wokarana paraia. ");
INSERT INTO dif_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ja nulu ngaianingu kaukaubana paraia, worderu nulu najina warai pungani nunkanani angela terkanani ja nunkangu jatanani: «Materi Joppia jinpau ja Simon, nina tanali dikai Petrus, karkau. ");
INSERT INTO dif_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Nau jinkangu jaura jatala nganai, tanangundru jundru ja jinkani pungalali tepi ngurali manila nganai.» ");
INSERT INTO dif_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ngato wonina paraia kaukaubala, Jaola kulikiri tanangu pratjanani ngarina paraia, ngaianangu jeribaka ngopera. ");
INSERT INTO dif_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ngato Kaparala jaura ngundrana paraia, worderu Nauja jatana wonti: «Johannili ngapali multibana wonti, jura Jaolali kulikirieli multibanila manila nganai.» ");
INSERT INTO dif_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Godali tanangu poto jinkinani, worderu bakana ngaianangu, ngaiana Kapara Jesungu Christungu morlalu ngundrana wonti: Worana ngani nganana paraia? Ngani ngurunguru nganana paraia Godani daudauala?“ ");
INSERT INTO dif_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Tanali jenia ngarana, tana ngapurina wonti; ja tanali Goda jurakokana wonti ja jatana wonti: „Jeruja bakana kana koni Godali madlentjandru karitjini jinkina paraia tepia.“ ");
INSERT INTO dif_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Tana ketjaketjanandru, nau Stephanusungundru pantjina, piltjaru nganana wonti Phönicielu ja Cypernilu ja Antiochialu marurina wonti, ja wata kulnuni jaura kaukaubana wonti, a‐ai, windri Juda kanani. ");
INSERT INTO dif_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Palpa tanangundru Cypriala ja Kyrenala nganana wonti, tana Antiochiani matja wokarana, bakana Grieka kanani jatana wonti, ja ngantjani jaura Kapara Jesungundru kaukaubana wonti. ");
INSERT INTO dif_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ja Kaparaia mara tanangunto nganana wonti; ja kana marapu, tana morlalu ngundrana wonti, Kaparaia karitjina wonti. ");
INSERT INTO dif_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Naupini pinti Jerusalem mili wolarani talpani wokarana wonti, ja tanali Barnabas jinpana wonti, nau Antiochialu wapananto. ");
INSERT INTO dif_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Nau naka matja wokarana, ja Godaia murla najina, nau mankina wonti, ja nulu pratjana kurukurubana wonti, ngara wonkieli Kaparani wonki ngamala. ");
INSERT INTO dif_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ngangau nau kana ngumu nganana wonti, Jaola kulikirieli ja morlalu ngundranali manamiri. Ja kana wolara marapu Kaparani ngokana wonti. ");
INSERT INTO dif_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Barnabas Tarsuja palkana wonti Saulus wontila; ja nulu nina matja mankamankana, nulu nina Antiochiaia manina tikana wonti. ");
INSERT INTO dif_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Jendranguta pudla kilpawoldra kulno mili wolarani jela ngamana wonti, ja mili wolarani ngujangujara jinkina wonti, ja tanali ngopera Antiochiani mili „Christiala“ dikana wonti. ");
INSERT INTO dif_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Tanangupini ditjini Jerusalemingundru Propheta Antiochiaia ngarina wonti. ");
INSERT INTO dif_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Kulno tanangundru, tala nunkani Agabus, terkakana wonti, ja Jaolali wondrana wonti, maua pirna mita maruni wokarala nganai. Naupini bakana kantji wokarana wonti mitaia kapara Claudiungu. ");
INSERT INTO dif_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Milieli pratjanali, kulno ja kulnujeli, kurana wonti, nunkani potundru palpa kalumiltjamiltjarina jinpananto tanangu ngatatani, tana Judaiani ngamanani. ");
INSERT INTO dif_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Jenia tanali bakana ngankana wonti, ja jenia pinarani jinpana wonti Barnabas ja Saulus marali. ");
INSERT INTO dif_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Nunkangupini miljarani Herodilu mitaia Kaparali mili wolarandru palpani mara kurana wonti, tanana jupala. ");
INSERT INTO dif_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Nulu jirijiribana wonti, tanali Jakobus, Johannini neji, mardakirrali nari ngankananto. ");
INSERT INTO dif_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ja nulu najina, Juda kanali jenia ngantjanani, nulu morla ngankana wonti, ja bakana Petrus patana wonti. Jendranguta pulkurutjeribanibuka pani ditji nganana wonti. ");
INSERT INTO dif_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Nulu nina matja patana, nulu nina kanjangari pungani widmana wonti, ja nulu nina pota mandrumandru mitaia kaparaia mili mandrumandruni jinkina wenti, tanali nina najinajibananto, ngangau nulu ngundrana wonti nina Passani ngadani kana wolarani wondralkala. ");
INSERT INTO dif_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Tanali Petrus kanjangari pungani najinajibana wonti; ja mili wolarali milingeru wonki nunkangundru Godani ngatjina wonti. ");
INSERT INTO dif_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Herodieli jertapaterinani nina wondralkala, nunkangupini tinkani Petrus mukaturarana wonti mitaia kaparaia mili mandruni terti, kanjangari mandrujeli dupudupu, ja najinajibanietja manani palarani kanjangari punga ngamalkana wonti. ");
INSERT INTO dif_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ja mai, Kaparaia angela kulno karakararina wonti, ja praitji kanjangari pungani mintjina wonti: Nulu Petrungu pankitiri nandranandrana wonti, nina jiritjibana wonti ja jatana wonti: „Nurujeli jiritjiau!“ Ja kanjangari nunkani marandru purina wonti. ");
INSERT INTO dif_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ja angela nunkangu jatana wonti: „Ngampiau, ja tidnaputa jinkani widmateriau;“ ja nulu jeruja ngankana wonti. Ja nau nunkangu jatana wonti: „Kati pirna jinkani jurkamateriau, ja ngakangu karipateriau.“ ");
INSERT INTO dif_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ja nau dunkana wonti, ja nunkangu karipaterina wonti, ja ko nganana wonti, jenia kantji nganai, mina angelandru pantjiai, a‐ai, nulu ngundrana wonti, nulu mudlamalka najiai. ");
INSERT INTO dif_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Pudla najinajibanietja ngoperalani ja mandrunila matja wiringana, pudla marda manani wokarana wonti, nulu nguraia padakai, naupini munta pudlangu piririna wonti; ja pudla dunkana wonti ja paltuwirdi kulno wapana wonti, ja nurujeli angela nunkangundru danina wonti. ");
INSERT INTO dif_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ja Petrus matja tjuruwilparina, nau jatana wonti: „Karari ngani morlalu milkila, Kaparali angela nunkani jinpana warai, ja ngana kulkana warai Herodes marandru ja Juda kana wolaraia kalkaterina pratjanandru.“ ");
INSERT INTO dif_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Nulu jenia matja ngujamana, nau Marianankani, Johannini ngandria, nina tanali dikai Markus, pungani wokarana wonti, woderi marapu mapaterina wonti ngatjila. ");
INSERT INTO dif_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Petrulu manaia pirnani manani nandranandranani, mili widla, tala nankani Rhote, wokarana wonti ngarala. ");
INSERT INTO dif_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ja nandru Petruni ngaiala ngujamana, nandru mankinandru mana wata walto ngankana wonti, a‐ai, nani wirina mindrina wonti ja kaukaubana wonti, Petrus manani terkala wapaia. ");
INSERT INTO dif_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Tanali nankangu jatana wonti: „Jidni jirijiri nganai;“ Nandru morlalu kurana wonti, jenia jeruja nganai. Tana jatana wonti: „Jenia angela nunkani nganai.“ ");
INSERT INTO dif_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Petrulu milingeru nandranandrana wonti. Tanali matja walto ngankana, tanali nina najina wonti ja pirna ngaruparana wonti. ");
INSERT INTO dif_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Nulu tanana marali daudauana wonti tana ngapurinanto, ja tanangu kaukaubana wonti, worderu Kaparali nina kanjangari pungandru dunkalkana warai. Ja nau jatana wonti: „Jenia Jakobungu ja ngatata worangu kaukaubanimai.“ Ja nau dunkana wonti ja piri kulnuja wapana wonti. ");
INSERT INTO dif_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Matja ditjirinani, tana juljaia mili wata ngalje ngaratutututu ngana wonti, mina Petrungu pantjina warai. ");
INSERT INTO dif_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodili nina matja wontina ja wata mankamankana, nulu najinajibanietjani kalala kurana wonti, ja jirijiribana wonti tanana wapalkala naria. Ja nau Judaiandru Cäsareaja ngarina wonti, ja naka ngamana wonti. ");
INSERT INTO dif_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodes Tyrusalani ja Sydonalani tiririna wonti; tana kulnukulnuni mapaterina wonti nunkangu, ja tanali mitaia kaparaia poto ngamalkijiribanietja Blastus matja karkarkana, tana murla ngatjina wonti, ngangau tanani mitali nunkani buka mitaia kaparaia mitandru tajina wonti. ");
INSERT INTO dif_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ditji kulnuni, nina nulu matja kurana, Herodili mitaia kaparaia kati widmaterina wonti, ja nau jaura pirini ngamana ngarina wonti, ja nulu kana wolaraia mudlani jaura kaukaubana wonti tanangu. ");
INSERT INTO dif_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Kana wolarali nunkangu karkana wonti: „Naupini Godaia ngaiala nganai, ja wata kanaia!“ ");
INSERT INTO dif_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ja nurujeli nina Kaparaia angelali nandrana wonti, ngangau nulu wata Godani pirna ngundrana wonti; ja miriwirieli nina tajina wonti, ja nau palina wonti. ");
INSERT INTO dif_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Godaia jaura punkana wonti ja marurina wonti. ");
INSERT INTO dif_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabas ja Saulus Jerusalemingundru tikana wonti, pudlani ngankana matja mudana, ja pudlali bakana Johannes, nina tanali dikai Marcus, manina kurana wonti. ");
INSERT INTO dif_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antiochiani mili wolarani Propheta ja ngujangujara jinkinietja nganana wonti, Barnabas ja Simeon, nina tanali dikai Niger, ja Lucius Kyrenala, ja Manaen kapakaparaia Herodini kalu kulno, ja Saulus. ");
INSERT INTO dif_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Tana Kaparani mili ngamana ja milja ngamana, Jaola kulikiri jatana wonti: „Barnabas ja Saulus ngakangu tjirimalkanau nunkangupini ngankanani, nunkanaia ngato pudlana karkana warai.“ ");
INSERT INTO dif_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ngadani tana milja ngamana wonti ja ngatjina wonti, ja tanali pudlangu mara kuraterina wonti, ja pudlana jinpana wonti. ");
INSERT INTO dif_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ja Jaolali kulikirieli pudlana matja jinpana, pudla Seleuciaia ngarina wonti, ja nakandru Cypernia pararana wonti. ");
INSERT INTO dif_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ja pudla Salamingu matja wokarana, pudlana Godaia jaura Juda kanaia jaura pungani kaukaubana wonti; ja pudlali bakana mili Johannes ngamalkana wonti. ");
INSERT INTO dif_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Pudlali watiwati paruparu Paphojelu matja palkingana, pudlali kana kulno mankamankana wonti, nau kunki ja jedikantji propheta ja Juda kana nganana wonti, tala nunkani Barjesus. ");
INSERT INTO dif_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Nau Sergius Paulungu nganana wonti, nau mitaia kapakapara ja kana kiri nganana wonti. Nulupini Barnabas ja Saulus karkana wonti, ja ngantjana wonti Godaia jaura ngarala. ");
INSERT INTO dif_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Pudlangu tjakakana wonti kunki Elimas, — jeruja nunkani tala matja karitjimalkana — ja wontina wonti kapakapara morlalu ngundranandru karitjimalkala. ");
INSERT INTO dif_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Saululu, nina tanali dikai Paulus, Jaolali kulikiri manamirieli nina ngurutalpana najina wonti, ");
INSERT INTO dif_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Ja jatana wonti: „Jidni kutjia ngatamura madlentjaia kirieli ja jeljujeljujeli pratjanali manamiri, talkulaia pratjanaia tula, jundru wata mudala nganai Kaparaia palto talku karitjimalkala? ");
INSERT INTO dif_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ja mai, Kaparaia mara jinkangu wokarai, ja jidni butjurila nganai, ja ditji pirna wata najila nganai miljaru kulnuwirdi.“ Nurujeli nunkangu prantjalku ja ngalpurali walpana wonti, ja nau wirarina wonti ja kana wontina wonti, tanali nina marali wiralkananto. ");
INSERT INTO dif_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Kapakaparali jenia najina mina pantjina warai, nulu morlalu ngundrana wonti ja Kaparaia ngujangujarandru pirna ngaruparana wonti. ");
INSERT INTO dif_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paulus, ja tana nunkangunto, Paphongundru matja pararana, tana Pergingu Pamphyliani wokarana wonti; Johannes pudlangundru puntina wonti, ja Jerusalemia tikana wonti. ");
INSERT INTO dif_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Pudla Pergendru palkana wonti, ja Antiochiani Pisidiani wokarana wonti, ja pudla Sabbat ditjini jaura pungani wirina wonti, ja ngamana ngarina wonti. ");
INSERT INTO dif_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Tanali jirijiribani jaura ja Propheta matja warapana, jaura pungaia kaparali pudlangu jinpana wonti ja jatana wonti: „Ngatata ngantjalu, judla kurukurubani jaura kulno kana wolarani ngamalkanani, jatalumai!“ ");
INSERT INTO dif_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Paulus terkakala tarana wonti, ja marali malka jinkina wonti ja jatana wonti: „Jura Israel kana, ja jura Godangundru japali nganana, ngaranimai! ");
INSERT INTO dif_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Tananipini Israel kana wolaraia Godali ngaperi worana ngaianani kalkalkana wonti; ja Nulia kana wolara miri ngankana wonti, tana Egypta mitani tula ngananala, ja tanana nguna terkanali nakandru dunkalkana wonti. ");
INSERT INTO dif_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ja kildawoldra pota mandrumandru marapratjana Nulia tanana dantjudantjumalkana wonti ja ngamalkana wonti. ");
INSERT INTO dif_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ja Nulia Canaan mitani kana wolara mara wora ja mandru matja palipalimana, Nulia tanangu tanani mita wontjani malkali puntibijiribana wonti. ");
INSERT INTO dif_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ja kilpawoldrawirdi 450 ngadani, Nulia tanangu kalala kuranietja jinkina wonti Samuel Prophetangulu. ");
INSERT INTO dif_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ngadani tana mitaia kapara ngatjina wonti, ja Godali tanangu Saul jinkina wonti, Kisani ngatamura, kana kulno Benjamin wittandru kilpawoldrawirdi pota mandrumandru marapratjana. ");
INSERT INTO dif_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ja Nulia nina matja worana, Nulia tanangu David mitaia kapara jiritjibana wonti, nunkangundru Nulia tinkari ngankana wonti ja jatana wonti: «Ngato David Jessaini ngatamura mankamankana warai, kana kulno ngakangu ngarani, nulu ngakani jertapaterina pratjana ngankala nganai.» ");
INSERT INTO dif_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Nunkangupini ngatamurandru Godali Israel kanani Jesus Kulkanipirna jiritjibana wonti, worderu Nulia talpadakana wonti; ");
INSERT INTO dif_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Nunkangupini wokarani ngopera Johannes Israel kana wolarani madlentjandru karitjinaia multibanila kaukaubana wonti. ");
INSERT INTO dif_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Johannili ngankana nunkani matja mudana, nau jatana wonti: Worana jura ngana ngundrai, ngani Nau wata nganai, a‐ai, mai, Nau ngakangu ngadani wokarai, nunkangu ngani wata talku nganai tidnaputa nunkani tidnandru dukarala. ");
INSERT INTO dif_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Ngatata ngantjalu! Jura Abrahamani marduja ngatamura, ja tana jurangundru Godandru japali nganai, jurangu ninapini kulkani jaura matja jinpana. ");
INSERT INTO dif_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ngangau Jerusalemalali ja tanani kaparali, ngangau tanali ninaia wata ngujamana wonti, Prophetaia jaura, Sabbat ditji pratjanani warapanani, manamiri ngankana wonti, ngangau tanali nunkangu kalala kurana wonti. ");
INSERT INTO dif_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ja tanali wata naria madlentji nunkangu mankamankana wonti, a‐ai, windri tanali Pilatungu ngatjina wonti, ninaia nari ngankala. ");
INSERT INTO dif_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ja tanali pratjana, mina nunkangundru dakanala paranani, mudana wonti, tanali ninaia pitandru ngarilkana wonti, ja narikutuni kurana wonti; ");
INSERT INTO dif_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ja Godali ninaia narindru jiritjibana wonti. ");
INSERT INTO dif_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ja Nauja ditji marapu tanangu wondraterina wonti, tana nunkangu jela Galilaiandru Jerusalemia tarana wonti, ja tana karari nunkani tinkari ngankanietja nganai kana wolarani. ");
INSERT INTO dif_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ja ngaiani jurangu ninapini talpadakani jaura kaukaubai, tana ngaperi worangu matja pantjina, ninapini Godali ngaianangu, tanani ngatamurani, morlalu kurana wonti, ngangau Nulia Jesus jiritjibana wonti. ");
INSERT INTO dif_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Worderu bakana Psalma mandrulani dakanala parai: «Jidni ngakani Ngatamura nganai, karari ngato jidna kantji patana warai.» ");
INSERT INTO dif_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Nulia ninaia narindru jiritjibana wonti, Nauja wata morla puapuarinani karitjina tikananto, nunkangundru Nulia jeruja jatana wonti: «Ngato jurangu Davidani murla morlalu jinkila nganai.» ");
INSERT INTO dif_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Jendrangundruja Nauja bakana piri kulnuni jatai: «Jundru wata manuni kurala nganai, jinkani Kulikiri puapuarinani najinanto.» ");
INSERT INTO dif_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ngangau Davidali, nunkani miljarani Godaia jertapaterinani matja pankina, palina wonti, ja tanali nina nunkani ngaperi worangu kurana wonti, ja nulu puapuarinani najina wonti. ");
INSERT INTO dif_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Nulia, ninaia Godali jiritjibana wonti, wata puapuarinani najina wonti. ");
INSERT INTO dif_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Jeruja jura ngujamananto, ngatata ngantjalu, nunkangundru jurangu madlentji kalingani kaukaubala nganai. ");
INSERT INTO dif_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ja nunkangu pratjanandru, nunkangundru jura ngandandarina wonti Mosini jirijiribani jaurani talku pantjila, nunkangu talku pantjiai, warle nunkangu morlalu ngundrai. ");
INSERT INTO dif_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ngamalkaterianau, wata jenia jurangu wokarananto, mina Propheta jatana wonti: ");
INSERT INTO dif_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","«Najianau jura ngirkibanietja, ja ngaruparanau ja panila pantjiau; ngangau ngato ngankana kulno jurani ditjini ngankai; jura wata morlalu ngundrala nganai, kulnujeli jenia jurangu kaukaubanani.»“ ");
INSERT INTO dif_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pudla Juda kana jaura pungandru matja dunkana, kana kojeli pudlangu ngatjina wonti, pudlali Sabbat ditji kul nuni tananapini jaura tanangu kaukaubananto. ");
INSERT INTO dif_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Jaura punga matja mudana, Juda kana ja Juda kana kamaneli marapu Paulungu ja Barnabangu karipaterina wonti, ja pudlali tanangu kaukaubana wonti, ja tanana kurukurubana wonti, tana Godaia murlani wonki ngamananto. ");
INSERT INTO dif_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Sabbat ditji kulnuni ngampu nguraia kana pratjana mapaterina wonti Godaia jaura ngarala. ");
INSERT INTO dif_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Juda kanali kana marapu matja najina, tana milkirinali manamiri pantjina wonti, ja nunkangupini tjakakana wonti, mina Paulus jatana wonti, ja ngirkibana wonti. ");
INSERT INTO dif_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Paulus ja Barnabas manubaku terkana wonti ja jatana wonti: „Jurangu morlalu ngopera Godaia jaura jatananto; ngangau jura ninaia tertabai, ja jura munta wata talku ngundrateriai tepi nguralia, mai, ngali kana koni karitjila nganai. ");
INSERT INTO dif_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ngangau jeruja Kaparali ngaianingu jirijiribana wonti: «Ngato jidna kana koja praitji terkibana wonti, jidni Kulkanipirna nganananto mita wondirajelu.»“ ");
INSERT INTO dif_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Kana kojeli jenia matja ngarana, tana mankina wonti, ja Kaparaia jaura jurakokana wonti, ja morlalu ngundrana wonti jeruntjali tanangundru Nulia tepi nguralia kalkalkana wonti. ");
INSERT INTO dif_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Kaparaia jaura munamarurina wonti nunkangupini mitani paruparu. ");
INSERT INTO dif_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Juda kanali widla kana pirna, Godangundru japali, ja nguraia kapara tirijiritjibana wonti, ja Paulungu ja Barnabangu tirikaripaterina patijiritjibana wonti, ja pudlana tanani wondirandru narrana wonti. ");
INSERT INTO dif_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pudlali puturu pudlani tidnaputandru matja kantikantina, pudla Ikoniungu wokarana wonti. ");
INSERT INTO dif_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Mili mankinali ja Jaolali kulikirieli manamiri pantjina wonti. ");
INSERT INTO dif_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Jendranguta pudla jela Ikoniungu Juda kanaia jaura pungani wirina wonti, ja jeruja kaukaubana wonti, Juda kana ja Grieka kana wolarali morlalu ngundrana wonti. ");
INSERT INTO dif_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Tanali Juda kanali, tanali wata morlalu ngundrana wonti, kana koja mungara patijiritjibana wonti, ja kaldri ngankana wonti ngatatani. ");
INSERT INTO dif_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pudla naka ditji marapu ngamana wonti, ja pudla manubakujeli kaukaubana wonti Kaparani, Nulia murlaia jaurani tinkari ngankana wonti, ja malka ja pirnala pudlali marali ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Nguraia kana wolara palkaterina wonti, palpa Juda kanani jela ngundrana wonti, ja palpa Apostel wulangu. ");
INSERT INTO dif_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Kana ko ja Juda kana tanani kaparanto jurboringana wonti, pudlana jupala ja mardali dakala. ");
INSERT INTO dif_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Pudlali jenia matja ngujamana, pudla japa mindrina wonti Lykaoniaja ngura wuluja, Lystrangu ja Derbengu, ja mitani karakara. ");
INSERT INTO dif_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ja pudla naka ngamana wonti, ja ngantjani jaura kaukaubana wonti. ");
INSERT INTO dif_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ja Lystrangu kana kulno nganana wonti, nau ngamana wonti, ja ngandri mandrandru tjunduru nganana wonti, nau wata pota kulno wirarina wonti. ");
INSERT INTO dif_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Nulupini Paulus kaukaubanani ngarana wonti; nulu nina ngurutalpana najina wonti, ja nulu matja ngujamana, nulu morlalu ngundrai tepi pantjila, ");
INSERT INTO dif_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Nau ngaiala pirnali jatana wonti: „Talku terkakamai jinkani tidnali!“ Ja nau kulkungana tarana wonti ja wirarina wonti. ");
INSERT INTO dif_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Kana wolarali matja najina, mina Paululu ngankana warai, tana ngaiala pirnali Lykaonia talieli jatana wonti: „Goda wora kanani jeribaka pantjina warai, ja ngaianingu ngarina warai.“ ");
INSERT INTO dif_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ja tanali Barnabas Zeus dikana wonti, ja Paulus Hermes, ngangau nulu jauraia kapara nganana wonti. ");
INSERT INTO dif_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Zeusuni priestali, nau tanani nguraia tidnanta nganana wonti, nganti ja tiwipirapira manani padakana wonti, ja ngantjana wonti kana wolarani jela poto ngumu jinkila. ");
INSERT INTO dif_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Pudlali Apostel, Barnabas ja Paulus, jenia ngarana, pudlali pudlani kati purana wonti, ja kana wolaraia mindrina wonti, ja maritjina wonti ");
INSERT INTO dif_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Ja jatana wonti: „Kana worajai! Mina jura ninkida ngankai? Ngali bakana kana jurangu jeribaka, ja ngali jurangu ngantjani jaura kaukaubai, jura tanangupini bakundru tepia Godani karitjinanto, Nulia pariwilpa ja mita ja panto pirna ja pratjana mina mandrani pantjimana wonti. ");
INSERT INTO dif_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Nulupini miljaru waruni kana ko worani patana wonti, tana tanani palto muntani wirarinanto. ");
INSERT INTO dif_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ja Nulia muntali morlalu kurana wonti, ngangau Nulia jurangu ngumula marapu ngankana wonti, ja pariwilpandru talara ja tandraia ditji jinkina wonti, ja jurana ngara manamiri ngankana wonti bukali ja mankinali.“ ");
INSERT INTO dif_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Pudla jenia matja jatana, pudla ngampu ngandandarina wonti kana wolara daudauala, pudlangu poto ngumu jinkila. ");
INSERT INTO dif_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Antiochiandru ja Ikoniungundru Juda kana wokarana wonti, tanali kana wolara jadijadibana wonti, ja tanali Paulus mardali dakana wonti, ja nina ngura palaraia parumana wonti, ja ngundrana wonti, nau matja nari. ");
INSERT INTO dif_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Milieli nina matja kapikapina, nau terkala tarana wonti, ja nguraia wirina wonti; ja ditji kulnuni nau Barnabas jela nakandru Derbia palkana wonti. ");
INSERT INTO dif_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ja pudla nunkangupini ngurani ngantjani jaura matja kaukaubana, ja mili marapu matja ngankana, pudla tikana kurana wonti Lystraia ja Ikoniuja ja Antochiaia. ");
INSERT INTO dif_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ja mili mungara nguru ngankana wonti, ja tanana kurukurubana wonti morlalu ngundrani wonki ngamala, ja ngaiani ketjaketjana marapuni wiringananto Godaia mililaia. ");
INSERT INTO dif_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Pudla tanangu kana kapara matja kalkalkana mili wolarani pilki ja pilki, pudlali ngatjinali ja milja ngamanali tanana Kaparani kurana wonti, nunkangu tanali morlalu ngundrana wonti. ");
INSERT INTO dif_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ja pudla Pisidiani matja palkingana, pudla Pamphyliani wokarana wonti. ");
INSERT INTO dif_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ja pudlali Pergengu jaura matja kaukaubana, pudla Attaliaia ngarina wonti. ");
INSERT INTO dif_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ja nakandru pudla Antiochiaia pararana wonti, wodajerindru pudlali Godaia murla jinkina paraia nunkangupini ngankanani, nau matja mudanani. ");
INSERT INTO dif_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Pudla naka matja wokarana, ja mili matja karkana, pudlali kaukaubana wonti, worderuntja Godali pudlanguntali ngankana warai, ja worderu Nauja kana koni morlalu ngundranaia mana piri ngankana warai. ");
INSERT INTO dif_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Pudla wata miljaru wordu naka milini jela ngamana wonti. ");
INSERT INTO dif_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ja palpa Judaiandru ngarina wonti, ja ngatatani ngujangujara jinkina wonti: „Jura wata karuwalila pantjinani Mosini ngujani jeribaka, jura ngandandarinani tepi ngurali manila.“ ");
INSERT INTO dif_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ngangau jendranguta wata waka tjelapalkani ja tjakakijiribamalini tanangu pantjina wonti Paulungu ja Barnabangu, tanali kurana wonti, Paulus ja Barnabas ja palpali morla tanangundru, Apostel worangu ja pinaru worangu Jerusalemia tarananto nunkangupini tirijakalkijiribamalinandru. ");
INSERT INTO dif_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Mili wolarali pudlana matja ngankijiribingana, pudla Phöniciani ja Samariani palkingana wonti, ja kana koja karitjini kaukaubana wonti, ja ngatata pratjanani mankina pirna ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pudla Jerusalemingu matja wokarana, mili wolarali ja Apostel worali ja pinaru worali pudlana murlali patana wonti; ja pudlali kaukaubana wonti, mina pirnala Gadali pudlangunto ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Pharisaia ngujandru palpa, tana morlalu ngundrana wonti, terkakana wonti ja jatana wonti: „Tanana karuwalila pantjinanto, ja tanangu jirijiribananto, tanali Mosini jirijiribani jaura ngamalkananto.“ ");
INSERT INTO dif_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Apostel wora ja pinaru wora mapaterina wonti, tananapini jaura najinajibala. ");
INSERT INTO dif_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Tjakakijiribamalina marapu matja pantjina, Petrus terkakana wonti ja tanangu jatana wonti: „Ngatata ngantjalu! Jura milkila, ditji warundru Godali ngaianangundru kalkalkana wonti, ngakani manali kana kojeli ngantjani jaura ngarananto ja morlalu ngundrananto. ");
INSERT INTO dif_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ja Godali ngarangujamanietjali tanangu tinkari ngankana wonti, ngangau Nulia tanangu Jaola kulikiri jinkina wonti, ngaianangu jeribaka; ");
INSERT INTO dif_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ja wata pilkipilki ngankana wonti ngaianangu ja tanangu, ngangau Nulia morlalu ngundranali tanani ngara kulirkanala. ");
INSERT INTO dif_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Minandru jura karari Goda wontjai, ja milini wokarani pita wokara kurai, nina ngaianani ngaperi wora ja ngaiani ngandandarina warai wilimala? ");
INSERT INTO dif_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","A‐ai, ngaiani morlalu ngundrai Kaparaia Jesuja manjulandru tepi pantjila, tanangupini jeribaka.“ ");
INSERT INTO dif_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Kana wolara ngapurina wonti, ja tanali Barnabas ja Paulus kaukaubanani ngarana wonti, worderu malka pirna ja pirnala Godali kana koni pudlangundru ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Pudla matja ngapurina, Jakobulu kalabana wonti ja jatana wonti: „Jura materi ja ngatata worajai, ngana ngaranimai! ");
INSERT INTO dif_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simeonali kaukaubana warai, worderu ngopera Godali kana kondru kana wolara kalkalkana wonti nina patala nunkani talandru. ");
INSERT INTO dif_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ja nunkangu Prophetaia jaura kulnukulnuni nganai, worderu dakanala parai: ");
INSERT INTO dif_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","«Ngadani ngani nakaldra tikala nganai, ja Davidani punga, nau tampurina, nakaldra wotila nganai, ja nunkani tampurini ngato nakaldra wotila nganai, ja nina terkibana tarala nganai; ");
INSERT INTO dif_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Pinpani kanali Kapara wontinanto, ja kana wolara pratjanali, tanangupini tanali tala ngakani dikai, Kapara jatai, Nulia jenia ngankai.» ");
INSERT INTO dif_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Godali ngankana nunkani nguralindru ngujamai. ");
INSERT INTO dif_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Jendrangundruja ngato kurai, tanapini wata morla jupala, tanana kana kondru Godangu karitjiai. ");
INSERT INTO dif_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","A‐ai, tanangu jirijiribananto, tanana muramura murumurundru ja palakantjindru ja ngurlini ngantindru ja kumarandru ngamalkaterinanto. ");
INSERT INTO dif_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ngangau Mosili warulandru ngura pratjanani jenipara ngamalkai, tanali nina kaukaubai, wodajeri tanali nina jaura pungani Sabbat ditji pratjanani warapai.“ ");
INSERT INTO dif_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Jendranguta Apostel worali ja pinaru worali ja mili wolarali kurana wonti, tanangundru materi palpa kalkalkala ja Antiochiaia jinpala Paulungu ja Barnabangu jela: Judas, nina tanali dikai Barsabas, ja Silas, pudla kana kapara nganana wonti ngatatani. ");
INSERT INTO dif_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ja pudlali marali dakanala jinpana wonti jeruja: „Apostel worali ja pinaru worali ja ngatata worali ngatatani kana kondru Antiochiani ja Syriani ja Ciliciani mandurini jaura jinpai. ");
INSERT INTO dif_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ngangau ngaiani matja ngarana, palpa ngaianingundru dunkana paraia, ja jurana patijiritjibana paraia jaurali, ja jurana mungara tjautjau ngankana paraia, ngangau tana jatai, jura karuwalila pantjinanto ja jirijiribani jaura ngamalkananto, tanangupini ngaiani jenia wata jirijiribana paraia. ");
INSERT INTO dif_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Jeruja ngaiani kulnukulnuni kurana warai, materi kalkalkala ja jurangu jinpala, ngaianinani Barnabangu ja Paulungu ngantjalu jela. ");
INSERT INTO dif_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Kana wulana, pudlali pudlani mungara jinkiterinala ngaiananani Kaparaia Jesu Christuja talani. ");
INSERT INTO dif_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Jeruja ngaiani Judas ja Silas jinpana warai, pudlali muntali jenia manali jurangu kaukaubala nganai. ");
INSERT INTO dif_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Jaolali kulikirieli ja ngaiani ngundrana warai jenia ngumu, jurangu juditji wata morla kurala, windri tananapini poto morlalu: ");
INSERT INTO dif_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Jura ngamalkaterinanto muramura poto ngumundru ja kumarandru ja ngurlini ngantindru ja palakantjindru. Jura tanangundru ngamalkaterinani, jura tepi ngumu ngananani. Tepi ngamanau!“ ");
INSERT INTO dif_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Tanali tanana matja jinpana, tana Antiochiani wokarana wonti; ja tanali kana wolara mapana wonti, ja tanangu dakani jaura jinkina wonti. ");
INSERT INTO dif_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Tanali nina matja warapana, tana kurukurubanandru mankina wonti. ");
INSERT INTO dif_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas ja Silas bakana muntali kaukaubana wonti, ngangau pudla Propheta nganana wonti, ja pudlana ngatata wolara jaura marapujeli kurukurubana wonti, ja tanana ngurunguru ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Pudla miljaru kulno naka matja ngamana, ngatatajeli pudlana murlali Apostel worangu jinpana tikana wonti. ");
INSERT INTO dif_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Silajeli ngantjana wonti naka ngamala. ");
INSERT INTO dif_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paulus ja Barnabas Antiochiani ngamana wonti; pudlali ngujangujara jinkina wonti, ja Kaparaia jaura kaukaubana wonti marapuni jela. ");
INSERT INTO dif_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ditji palpani Pauluna Barabangu jatana wonti: „Ngaldra nakaldra karitjinanto, ja ngaldrani ngatata najinajibananto ngura pratjanani, tanangu ngaldra Kaparaia jaura kaukaubana wonti, worderu tana ngamai.“ ");
INSERT INTO dif_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabajeli jertapaterina wonti, bakana Johannes, nina tanali dikai Marcus, manina kurala. ");
INSERT INTO dif_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Paululu ngundrana wonti, jenia talku nganai, ninapini, nau pudlangundru Pamphiliandru puntina wonti, ja wata pudlangunto wapana wonti ngankanaia, wata manina kurananto. ");
INSERT INTO dif_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Jeruja jatamalina pantjina wonti, ja pudla puntina wonti, ja Barnabali Marcus manina kurana wonti ja Cyperaia pararana wonti. ");
INSERT INTO dif_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Paululu Silas kalkalkana wonti ja palkana wonti, milieli nina Kaparaia manjulani matja kurana. ");
INSERT INTO dif_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Nau Syriani ja Ciliciani palkingana wonti, ja mili wolara nguru ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Nau Derbangu ja Lystrangu wokarana wonti. Ja mai, mili kulno naka nganana wonti, tala nunkani Timotheus, Juda widlaia ngatani, nandru morlalu ngundrana wonti, ja ngaperi nunkani Griekala nganana wonti; ");
INSERT INTO dif_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ngatatajeli Lystrangu ja Ikoniungu ngumu tinkari ngankana wonti nunkangundru. ");
INSERT INTO dif_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulus jertapaterina wonti ninapini manina kurala nunkangunto; ja nulu nina patana wonti, ja nina karuwali ngankana wonti, tanangupini Juda kanandru, tana tanangupini ngurani ngamana wonti; ngangau tanali pratjanali nunkani ngaperandru milkila nganana wonti, nau Griekala nganana wonti. ");
INSERT INTO dif_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Tana ngura worana palkinganani, tanali tanangu jirijiribani jaura jinkina wonti ngamalkananto, tanana Apostel worali ja pinaru worali Jerusalemingu kurana paranani. ");
INSERT INTO dif_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Mili wolara morlalu ngundranali ngurunguru pantjina wonti, ja morla marapurina wonti ditji pratjanani. ");
INSERT INTO dif_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Tana Phrygiani ja Galitia mitani palkingana wonti, ja Jaola kulikirieli tanana daudauana wonti Asiani jaura kaukaubala. ");
INSERT INTO dif_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Tana Mysia wondirani matja wokaranani, tanali wontjana wonti Bithynianaia palkala; ja Jaolali tanangu wata manuni kurana wonti. ");
INSERT INTO dif_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Tana Mysiangu matja palkingana, tana Troasangu ngarina wonti. ");
INSERT INTO dif_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ja mudla kulno tinkani Paulungu wondraterina wonti; Macedonia kana kulno naka terkana wonti, ja nunkangu ngatjina wonti ja jatana wonti: „Jera pararau Macedoniaia ja ngaianingu marangokau!“ ");
INSERT INTO dif_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Nulu nina mudla matja najina, ngaiana jertapaterina wonti nurujeli Macedoniaia palkala, ngangau ngaiana morlalu ngujamana wonti, Kaparali ngaianana karkana wonti, tanangu ngantjani jaura kaukaubala. ");
INSERT INTO dif_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ngaiana Troasangundru pararana wonti ja palto talkuni Samothracengu wokarana wonti, ja ditji kulnuni Neapo lisingu; ");
INSERT INTO dif_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ja nakangundruka Philippingu, naupini nunkanipini Macedonia mitaia buruni ngura ngoperala nganai, ngura kapara. Ngaiana nunkangupini ngurani ditji palpa ngamana wonti. ");
INSERT INTO dif_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ja Sabbat ditjini ngaiana ngurandru palaraia dunkana wonti kaiari kulnuja dirkalani, woderi ngatjini piri nganana wonti, ja ngaiana ngamana ngarina wonti ja widlani kaukaubana wonti, tana naka mapaterinani. ");
INSERT INTO dif_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ja widla kulnujeli, tala nankani Lydia, nani kati maralje jinkinietja Thyatira ngurandru, nani Godandru japali nganana wonti, ngarana wonti; ja nana ngara Kaparali kalupakibana wonti jenia ngundrala, mina Paululu kaukaubana wonti. ");
INSERT INTO dif_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Nandru ja nankani pungalali matja multibanila manina, nana ngaianana kurukurubana wonti ja jatana wonti: „Jura ngundranani, ngato Kaparani morlalu ngundrai, ngakani pungani wirianau ja jerra ngamanau.“ Ja nandru ngaianana mararibana wonti. ");
INSERT INTO dif_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Jendranguta ngaiana ngatjila wapanani, widla mili ngaianangu mandurina wonti, nandru kutjia talpadakani jaola ngamalkana wonti, nandru nankani kaparani kalala marapu jinkina wonti talpadakandru. ");
INSERT INTO dif_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Nani Paulungu ja ngaianangu wapantina wonti ja maritjina wonti ja jatana wonti: „Tanapini kana Goda pirnaia mili nganai, tanali jurangu murlaia palto kaukaubai.“ ");
INSERT INTO dif_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Jenia nandru ditji marapuni ngankana wonti. Paulus kalapankarina wonti ja karitjinawontikana wonti ja jaolani jatana wonti: „Ngato jinkangu Jesuja Christuja talani jirijiribai, jidni nankangundru dunkananto!“ Ja nau dunkana wonti nunkangupini ditjini. ");
INSERT INTO dif_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Nankani kaparali matja najina, tanani manginia kalkanani matja dunkana, tanali Paulus ja Silas patana wonti, ja pudlana jurborini piria parumana wonti ngaraia kaparani, ");
INSERT INTO dif_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ja pudlana kapakaparani wapalkana wonti ja jatana wonti: „Pudlalipini kanali ngura ngaianani patijiritjibai, ja Juda kana nganai. ");
INSERT INTO dif_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ja pudlali jenia mangini kaukaubai, tanali ngaiani wata patananto ja wata ngankananto, ngangau ngaiani Romala nganai.“ ");
INSERT INTO dif_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ja kana wolaraia ngara pudlangu tutututungana wonti; ja kapakaparali jirijiribana wonti, pudlani kati puribala, ja pudlana nandrala. ");
INSERT INTO dif_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ja tanali pudlangu nandrani marapu matja jinkina, tanali pudlana kanjangari pungani widmana wonti, ja kanjangari pungaia najinajibanietjani jirijiribana wonti, pudlana jiglerali najinajibala. ");
INSERT INTO dif_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Nulu ninapini jirijiribani jaura matja manina, nulu pudlana kanjangari punga mandrani widmana wonti, ja pudlani tidna workamandrana wonti pitani ngurunguru. ");
INSERT INTO dif_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Tinka tertini karakara Paululu ja Silasili ngatjina wonti ja Goda jurakokana wonti; ja kanjangarilali pudlana ngarana wonti. ");
INSERT INTO dif_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Nurujeli mita wiltjiwiltjina pirna pantjina wonti, jeruja kanjangari pungaia wotini wijawijabaterina wonti, ja nurujeli kanjangari pungaia mana pratjana walturina wonti, ja pratjanaia kanjangari dukaraterina wonti. ");
INSERT INTO dif_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Kanjangari pungaia najinajibanietja mukandru matja jiritjina, ja kanjangari pungaia mana walto ngananani najina, nulu mardakirra dukarana wonti, ja jertapaterina wonti munta nari ngankaterila, ngangau nulu ngundrana wonti, kanjangarila kutingana warai. ");
INSERT INTO dif_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Paulus ngaiala pirnali karkana wonti ja jatana wonti: „Wata madlentji ngankateriau! ngangau ngaiani pratjana ninkida nganai.“ ");
INSERT INTO dif_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Nulu praitji karkana wonti, ja mindrina wirina wonti, ja ngarrana wonti, ja Paulungu ja Silangu tidnani woraterina wonti. ");
INSERT INTO dif_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ja nulu pudlana dunkalkana wonti ja jatana wonti: „Kapara wulujai, mina ngato ngankananto kulkani manila?“ ");
INSERT INTO dif_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Pudla jatana wonti: „Kaparani Jesungu Christungu morlalu ngundrau, jeruja jundru ja jinkani pungalali kulkani manila nganai.“ ");
INSERT INTO dif_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ja pudla Kaparaia jaura nunkangu, ja pratjanani, tana pungani nunkanani ngamanani, kaukaubana wonti. ");
INSERT INTO dif_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ja nulu pudlana nunkangupini tinkaia ditjini patana wonti, ja pudlani tapa kulirkana wonti, ja nurujeli nulu ja nunkani pungalali multibanila manina wonti. ");
INSERT INTO dif_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ja nulu pudlana nunkani pungaia taralkana wonti, ja pudlangu buka kurana wonti ja mankina wonti, ngangau nulu nunkani pungalantali Godani morlalu ngundrana pantjina warai. ");
INSERT INTO dif_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Matja ditjirina, kapakaparali nguraia mili jinpana wonti ja jatana wonti: „Pudlanapini kana jinpau!“ ");
INSERT INTO dif_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Kanjangari najinajibanietjali tananapini jaura Paulungu kaukaubana wonti: „Kapakaparali jinpana warai judlana kurakananto; karari wapalumai, ja murlanto palkalumai!“ ");
INSERT INTO dif_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Paulus tanangu jatana wonti: „Tanali ngalina tinkari ja kalala kurani jaura panini nandrala wiri, ngali Romala terkai, ja ngalina kanjangari pungani widmala wiri, ja karari tanali ngalina kurukuru wailpananto? Wata jeruja, a‐ai, tana munta wokarananto ja ngalina dunkalkananto.“ ");
INSERT INTO dif_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Nguraia milieli kapakaparani tananapini jaura padakana wonti; ja tana japali pantjina wonti, tanali ngaranani, pudla Romala nganai. ");
INSERT INTO dif_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ja tana wokarana wonti, ja pudlana kurukurubana wonti, ja pudlana dunkalkana wonti, ja pudlangu ngatjina wonti ngurandru puntinanto. ");
INSERT INTO dif_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pudla kanjangari pungandru matja dunkana, pudla Lydianangu wapana wonti; ja pudla ngatata wora matja najina ja ngankalkana, pudla wapana wonti. ");
INSERT INTO dif_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Tana Amphipolingu ja Apolloniangu matja palkingana, tana Thessalonichingu wokarana wonti, woderi Juda kanaia jaura punga nganana wonti. ");
INSERT INTO dif_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Worderu Paululu milingeru, jeruja nau bakana tanangu wirina wonti, ja tanangunto Sabbat ditji parkulani ngankamalina wonti. ");
INSERT INTO dif_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Jaurandru nulu tanangu mildiri ngankana wonti, ja kurana wonti, Christus ketjaketjananto ja narindru jiritjinanto, ja Naupini Christus Jesus nganai, ninaia ngato jurangu kaukaubai. ");
INSERT INTO dif_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ja palpali tanangundru morlalu ngundrana wonti, ja Paulungu ja Silangu ngokana wonti, ja Griekala Godandru japali marapu, ja kana widla pirna wata ngalje. ");
INSERT INTO dif_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Juda kana, tana wata morlalu ngundrana wonti, milkirina wonti, ja tana jurborini pirindru materi madlentji palpa patana wonti, ja mapaterina wonti, ja ngura patijiritjibana wonti; ja tana Jason pungani tidnantani terkakana wonti, ja wontjana wonti, tanana kana wolarani wapalkala. ");
INSERT INTO dif_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Tanali tanana wata mankamankanani, tanali Jason ja ngatata palpa nguraia kaparani parumana wonti ja maritjina wonti: „Tanapini, tanali mita maru patijiritjibana warai, bakana ninkida wokarana warai; ");
INSERT INTO dif_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Tananapini Jasonili ngamalkai, ja tanali pratjanali mitaia kaparaia jirijiribani jaurani delkiai, ngangau tanana kurai, Kulno nguru Kapara nganai, Jesus.“ ");
INSERT INTO dif_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Tanali kana wolara ja nguraia kapara, tanali jenia matja ngaranani, patijiritjibana wonti. ");
INSERT INTO dif_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ja tanali Jasoningundru ja ngurundru morlalula matja manina, tanali tanana worani patana wonti. ");
INSERT INTO dif_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ngatatajeli nurujeli tinkani Paulus ja Silas Beröangu jinpana wonti, ja pudla naka matja wokarana, pudla Juda kanaia jaura pungani wirina wonti. ");
INSERT INTO dif_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Tanalipini morla ngumu ngundrana wonti Thessalonichalani, ngangau tanali jaura manjujeli patana wonti, ja ditji pratjanani Godaia jaurani wontina wonti, tanapini jeruja nganai kara. ");
INSERT INTO dif_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Jeruja marapujeli tanangundru morlalu ngundrana wonti, ja bakana Griekala kana pirna widla ja materi wata ngaljejeli. ");
INSERT INTO dif_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Thessalonicha Juda kanali matja ngarana, bakana Beröani Paululu Godaia jaura kaukaubai, tana wokarana wonti, bakana naka kana wolara patijiritjibala. ");
INSERT INTO dif_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Nurujeli ngatatajeli Paulus jinpana wonti, nau panto pirnaia dirkalajelu palkananto; Silas ja Timotheus naka ngamantina wonti. ");
INSERT INTO dif_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Tana Paulungu jela wapana, tanali nina Athenilu wapalkana wonti, ja tanali jirijiribani jaura matja manina, Silas ja Timotheus nurujeli nunkangu wokarananto, tana tarpina tikana wonti. ");
INSERT INTO dif_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Paulus Atheningu kalkaterinani pudlangu, nau jaola jerkina wonti, ngangau nulu najina wonti, ngurani Goda mudlamalka marapu paranani. ");
INSERT INTO dif_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Nulu jaura pungani Juda kanani, ja tanangu Godandru japali, ngankamalina wonti, ja jurborini pirini ditji pratjanani tanangu, tana jerra wokarana wonti. ");
INSERT INTO dif_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Palpali epicuräa ja stoika kana kirieli nunkangunto jatamalina wonti; ja palpa jatana wonti: „Mina naupini jatajatanietja jertapateriai jatala?“ Palpa nguru: „Ngaiani ngundrai, nulia kaukaubanietja Goda pilkindru nganai;“ Ngangau nulu tanangu ngantjani jaura Jesungundru, ja tepi terkakanani, kaukaubana wonti. ");
INSERT INTO dif_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ja tanali nina patana wonti, ja nina Areopagani wapalkana wonti ja jatana wonti: „Ngaiani ngujamananto, mina ngujangujara naupini nganai, ninaia jundru kaukaubai? ");
INSERT INTO dif_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ngangau jundru ngaianingu talpani palpa tula wirilkai, ngaiani ngantjai milkila nganala, mina jenia nganai.“ ");
INSERT INTO dif_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Athenalali, ja tana tidnapalarali, naka ngamanani, wata pilki ngundrana wonti, a‐ai, windri milingeru palpa marra jatala ja ngarala. ");
INSERT INTO dif_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Paulus Areopagani terti terkana wonti ja jatana wonti: „Athenala worajai! Ngato najiai, jura pratjanani Goda worangundru japali nganai. ");
INSERT INTO dif_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ngangau ngani palkingana warai, ja jurani poto kulikiri najina warai, ja ngato Altara kulno mankamankana warai, nunkangu dakani parai: «Nunkangupini Godani, nunkangu ngaiani ko.» Ninapini, ninaia jura bulu ngujamanali wodatarana ngamai, ngato jurangu kaukaubai. ");
INSERT INTO dif_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Nulupini Godali, Nulia mita maru, ja pratjana mina nunkangu mandrani, pantjimana wonti, Naupini pariwilpaia ja mitaia Kapara nganai, wata pungani ngamai, tana marali wotinala; ");
INSERT INTO dif_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Kana marali ninaia bakana wata ngamalkai, Nulia minakulno morla ngamalkananto, a‐ai, Nulia muntali pratjanani tepi ja jaola ja warupoto jinkiai. ");
INSERT INTO dif_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ja Nulia ngankana wonti, kulnuja kumarandru kana wolara mita maruja mudlani ngamananto, ja Nulia miljaru talku ja wondiri ngopera kurana wonti, worderunutana ngamananto. ");
INSERT INTO dif_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ngangau tanali Kapara wontinanto, tanali nina karakarananto ja mankamankananto; ngangau Nauja kantji wata worita nganai ngaianangu pratjanani. ");
INSERT INTO dif_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ngangau nunkangupini ngaiana tepiriai ja wirariai ja kantji nganai; worderu bakana jurani kurakuranietja palpa jatanala: «Ngaiana nunkani nguja nganai.» ");
INSERT INTO dif_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ngangau ngaiana Godaia nguja nganai, ngaiana wata ngundrananto, Goda jeribaka nganai, marda maraljeni kara, marda buluni kara, mardani kara, mudlani kara, ninaia kana kirila ja mankani matja ngankana. ");
INSERT INTO dif_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Godali koja miljaru wata ngundrai, ja karari Nulia kana warupotuni paruparu jirijiribai madlentjandru karitjinanto; ");
INSERT INTO dif_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ngangau Nulia ditji kulno kurana wonti, nunkangupini Nulia mita maruni kalala jinkila nganai talkulali, kana kulnujeli, ninaia Nulia kurana wonti, ja pratjanani morlalu ngundrana kurai, Nulia ninaia narindru matja jiritjibana.“ ");
INSERT INTO dif_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Tanali narindru jiritjini matja ngarana, palpali ngirkibana wonti; palpa jatana wonti: „Ngaiani jidna jendrangundruja nakaldra morla ngarananto.“ ");
INSERT INTO dif_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Jeruja Paulus tanangu tertindru wapana wonti. ");
INSERT INTO dif_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Kana palpa nunkangu wokarana wonti, ja morlalu ngundrana wonti: Tanangundru Areopagitala Dionysius, ja widla kulno, tala nankani Damaris, ja palpa pudlangunto. ");
INSERT INTO dif_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ngadani Paulus Atheningundru danina wonti, ja Korinthungu wokarana wonti. ");
INSERT INTO dif_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ja nulu Juda kana kulno mankamankana wonti, tala nunkani Aquilas, Pontungu matja dankana, nau kalkani Italiandru wokarana paraia, nunkani noali Priscilla jela, ngangau Claudiusulu Juda kana pratjanani jirijiribana paraia Romangundru puntinanto; pudlangu nau wirina wonti. ");
INSERT INTO dif_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Ja ngangau nau nunkani mangini nganana wonti, nau pudlangunto ngamana wonti ja ngankana wonti, ngangau pudla katipunga ngankanietja nganana wonti. ");
INSERT INTO dif_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Sabbat ditji pratjanani nulu tanangu kaukaubana wonti, ja Juda kana ja Grieka kana karkarkana wonti. ");
INSERT INTO dif_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Silas ja Timotheus Macedoniandru matja ngarina, Jaolali Paulus patana wonti, Juda kanani jiglerali morlalu kurala, Jesus nganai Christus. ");
INSERT INTO dif_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Tana delkinani ja ngirkibanani, nulu kati nunkani kantikantina wonti ja tanangu jatana wonti: „Kumari jurani jurangu mangatandrani wokaraiatimai! matja kulirkana ngani kararindru kana koni wapai.“ ");
INSERT INTO dif_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ja nau nakandru wapana wonti, ja kana kulnuja pungani wirina wonti, tala nunkani Titus Justus, nau Godandru japali nganana wonti, ja nunkani punga jaura pungani karakara parana wonti. ");
INSERT INTO dif_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Jaura pungaia kaparali, Krispus, Kaparani morlalu ngundrana wonti, nunkani pungantali jela; ja Korinthala marapujeli nina matja ngarana, tana morlalu ngundrana wonti, ja multibanila manina wonti. ");
INSERT INTO dif_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Kapara tinkani Paulungu mudlamalkali jatana wonti: „Wata japali nganau, a‐ai, kaukaubau, ja wata ngapuriau! ");
INSERT INTO dif_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ngangau ngani jinkangunto nganai, ja wata kulnujeli jidna patananto, jinkangu madlentji ngankala; ngangau ngato kana wolara nunkangupini ngurani ngamalkai.“ ");
INSERT INTO dif_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Nau naka kilpawoldra kulno ja pira mara wora ja kulno ngamana wonti, ja nulu tanangu Godaia jaura ngujangujara jinkina wonti. ");
INSERT INTO dif_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Gallion Achajaia kapakapara ngananani, Juda kana kulnukulnuni Paulungu tiriterkakana wonti, ja nina kalala pirini wapalkana wonti, ");
INSERT INTO dif_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ja jatana wonti: „Nulupini kana worana karkarkai Godangu wodatarana ngamananto, mina jirijiribani jaurani delkiai.“ ");
INSERT INTO dif_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Paulus jertapaterinani mana wilparila, Gallion Juda kanani jatana wonti: „Jenia ngirkibani ngananani kara, kankuja ngankani madlentji jeri kara, Juda kana worajai! ngato jurana talku ngarananto. ");
INSERT INTO dif_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Jenia tirijakalkijiribamalini ngananani ngujangujarandru ja talandru ja jurani jirijiribani jaurandru, jura munta najinanto; ngato wata ngantjai jeniandru kalala jinkinietja nganala.“ ");
INSERT INTO dif_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ja nulu tanana kalala pirindru narrana wonti. ");
INSERT INTO dif_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Grieka kana pratjanali Sosthenes jaura pungaia kapara patana wonti, ja nina nandrana wonti kalala piria mudlani; ja Gallioningu jenia jeribaka nganana wonti. ");
INSERT INTO dif_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulus miljaru palpa morla naka matja ngamana, nau ngatatandru danina wonti, ja Syriaia pararana wonti, ja nunkangunto Priscilla ja Aquilas; ja nulu Kenchreangu para nunkani wokaribana wonti, ngangau nulu talpadakani ngamalkana wonti. ");
INSERT INTO dif_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Nau Ephesungu wokarana wonti, ja pudlana naka worarana wonti; nau munta jaura pungani wirina wonti, ja Juda kanani ngankamalina wonti. ");
INSERT INTO dif_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Tana nunkangu ngatjina wonti, nau tanangu morla ngamananto; ja nau wata jertapaterina wonti. ");
INSERT INTO dif_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","A‐ai, nau tanangundru danina wonti ja jatana wonti: „Ngani kantji nunkangupini ditji pirnani, nau karakara, Jerusalemingu ngamananto; nakaldra ngani jurangu tikala nganai, Goda jertapaterinani.“ Ja nau Ephesungundru puntina wonti. ");
INSERT INTO dif_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ja Cäsareangu wokarana wonti. Ja nau tarana wonti mili wolarani mandurini jaura jinkila, ja ngarina wonti Antiochiaia. ");
INSERT INTO dif_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ja nau naka miljaru palpa matja ngamana, nau wapana wonti, ja Galatia mitani ja Phrygiani palkingana wonti, ja mili pratjana ngurunguru ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Juda kana kulno, tala nunkani Apollo, Alexandrini matja dankana, Ephesingu wokarana wonti, nau kana tali tjanka ja Godaia jaurani ngurunguru nganana wonti. ");
INSERT INTO dif_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Nulupini Kaparaia paltuni ngujangujara manina wonti, ja nulu Jaolali manamirieli kaukaubana wonti, ja nulu jiglerali Jesungundru ngujangujara jinkina wonti, ja nulu windri Johannini multibanilandru ngujamana wonti. ");
INSERT INTO dif_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ja nulupini wonina wonti manubakujeli jaura pungani kaukaukala. Aquilasili ja Priscillali nina matja ngarana, pudlali nina patana wonti, ja Godaia palto nunkangu morla talku mildiri ngankijiribana wonti. ");
INSERT INTO dif_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Nulu ngundranani Achajaia palkala, ngatatajeli mili wolarani dakana wonti, ja tanana kurukurubana wonti, tanali nina patananto; ja nau matja wokarana, nulu tanangu, tanali morlalu ngundrana wonti, murlali pirna marangokana wonti; ");
INSERT INTO dif_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ngangau ngurungurujeli nulu Juda kanali kantji kalalu ngankana wonti, ja Godaia jaurali wondrana wonti, Jesus nganai Christus. ");
INSERT INTO dif_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Jendranguta, Apollo Korinthungu ngananani, Paulus mita morla miri parana matja palkingana, Ephesungu wokarana wonti. Ja nulu naka mili palpa mankamankana wonti. ");
INSERT INTO dif_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Ja nau tanangu jatana wonti: „Jura Jaola kulikiri jendranguta maninala, jura morlalu ngundranala?“ Tana nunkangu jatana wonti: „Ngaiani wata pota kulno ngarana, Jaola kulikiri nganai.“ ");
INSERT INTO dif_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ja nau tanangu jatana wonti: „Minani jura multibanila maninala?“ Tana nunkangu jatana wonti: „Johannini multibanilani.“ ");
INSERT INTO dif_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Paulus jatana wonti: „Johannili morlalu madlentjandru karitjinaia multibanilali multibana wonti, ja kana wolarani jatana wonti, tanali morlalu ngundrananto nunkangu, nau nunkangu ngadani wokarananto, jenia Jesus nganai, Nauja Christus.“ ");
INSERT INTO dif_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Tanali jenia matja ngarana, tanali multibanila manina wonti Kaparaia Jesuni talani. ");
INSERT INTO dif_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ja Paulus tanangu mara kuraterinani, Jaola kulikiri tanangu ngarina wonti, ja tanali talieli kaukaubana wonti, ja talpadakana wonti. ");
INSERT INTO dif_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ja tana pratjana materi marapratjana ja mandru kara nganana wonti. ");
INSERT INTO dif_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Nau jaura pungani wirinani, nulu manubakujeli pira parkuluwirdi kaukaubana wonti, ja tanangu Godaia mililandru ngankamalina wonti, ja ngujangujara jinkina wonti. ");
INSERT INTO dif_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ngangau palpa ngurunguru ngankaterina wonti, ja wata morlalu ngundrana wonti, a‐ai, kana wolaraia mudlani paltundru madlentji kaukaubana wonti, nau tanangundru puntina kurana wonti, ja nulu mili mulkana wonti, ja ditji pratjanani Tyrannoni jaura pungani ngankamalina wonti. ");
INSERT INTO dif_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Jenia pantjina wonti kilpawoldra mandruwirdi, jeruja pratjanali, tana Asiani ngamana wonti, Kaparaia Jesuni jaura ngarana wonti, Juda kanali ja Grieka kanali. ");
INSERT INTO dif_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ja Godali wata waka ngurula ngankana wonti Paululu marali. ");
INSERT INTO dif_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Jeruja tanali kana muntjani kangukati ja kapakati nunkani talandru kurana wonti, ja muntjali tanana worarana wonti, ja kutji madlentji wora tanangundru dunkana wonti. ");
INSERT INTO dif_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Palpa Juda kanali, tana kunki wirarina wonti, wontjana wonti, Kaparaia Jesuni tala kanani kutjintani karkala, tana jatana wonti: „Ngaiani jurana jirijiribai Jesungu, ninaia Paululu kaukaubai.“ ");
INSERT INTO dif_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Juda kana Priesta pirnaia Skevani ngatamura palpa nganana wonti, mara wora ja mandru, tanali jenia ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Kutji madlentjali kalabana wonti ja jatana wonti: „Ninaia Jesus ngato ngujamai, ja Paulus ngato milkila; mina kana jura nganai?“ ");
INSERT INTO dif_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ja nau kana, nunkangu kutji madlentji nganana wonti, tanangu kulkungana wonti, ja tanangundru mandru kalalu ngankana wonti, ja nankana wonti, jeruja pudla balu ja tapanto nunkangupini pungandru kutingana wonti. ");
INSERT INTO dif_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Jenia pratjanali ngujamana wonti, tana Ephesungu ngamana wonti, Juda kanali ja Grieka kanali; ja tanana pratjana japa walpadakana wonti, ja Kaparaia Jesuni tala pirna pantjina wonti. ");
INSERT INTO dif_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ja tanangundru marapu wokarana wonti, tanali morlalu ngundrana wonti, ja tinkari dikana wonti ja kaukaubana wonti, mina tanali ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ja marapujeli tanangundru, tanali kunkia ngankani ngankana wonti, dakani jaura pratjana mapana wonti, ja kana pratjanaia mudlani tanana tarana wonti; ja tanali kalala tanangundru wintamana wonti ja mankamankana wonti, tana kalala 50,000 mardatandra bulu nganana wonti. ");
INSERT INTO dif_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Jeruja Kaparaia jaura ngurungurujeli punkana wonti, ja ngurunguru pantjina wonti: ");
INSERT INTO dif_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Jenia matja mudana, Paululu jaolali ngundrana wonti Macedoniani ja Achajani palkingana Jerusalemia palkala, ja jatana wonti: „Ngani naka matja ngamana, ngato bakana Roma najinanto.“ ");
INSERT INTO dif_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Nulu Macedoniaia tanangundru mandru jinpana wonti, tana mili nunkani nganana wonti, Timotheus ja Erastus; nau munta miljaru palpa Asiani ngamantina wonti. ");
INSERT INTO dif_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Jendranguta patijiritjini wata waka pantjina wonti nunkanipini paltundru. ");
INSERT INTO dif_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ngangau kulnujeli, tala nunkani Demetrius, marda bulu ngankanietja kulno, nulu Artemisini punga marda bulundru ngankana wonti; nulu ngankanietja worangu wata kalala ngalje jinkina wonti. ");
INSERT INTO dif_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Tananapini nulu karkana mapana wonti, ja tanangu, nunkangupini manginani jela ngankana wonti, jatana wonti: „Materi worajai! Jura milkila, ngaiani nunkangupini manginandru ngumu tepiriai; ");
INSERT INTO dif_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ja jura najiai ja ngarai, wata windri Ephesungu, a‐ai, bakana Asia maruni nulupini Paululu kana marapu karkarkai, ja tanani tjuru karitjimalkai ja jatai: «Jenia wata Goda nganai, marali matja ngankana.» ");
INSERT INTO dif_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Tanali wata windri ninapini poto waka ngankaiati, a‐ai, tanali bakana Artemisini Goda pirnaia punga panila ngundraiati; bakana jenia wokaraiati, nankani pirnala mudaiati, nina Asia marujeli ja mita marujeli pirna ngundrai.“ ");
INSERT INTO dif_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Tanali jenia matja ngarana, tana tiri pirna pantjina wonti, ja maritjina wonti ja jatana wonti: „Ephesusala Artemis pirna nganai.“ ");
INSERT INTO dif_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ja ngura pratjana tjautjau manamiri pantjina wonti, ja tana pratjana wondrani pungaia mindrina wonti, ja Gajus ja Aristarchus Macedoniandru, pudla Paulungu jela wonta wapani, parumana mindrilkana wonti. ");
INSERT INTO dif_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paulus jertapaterinani kana wolarani wirila, milieli nina ngandrawalkana wonti. ");
INSERT INTO dif_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Bakana Asia kapara palpali, tana nunkani kamaneli nganana wonti, nunkangu jinpana wonti, ja nunkangu ngatjina wonti, nau wata wondrani pungani wapananto. ");
INSERT INTO dif_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Palpa jenia maritjina wonti, ja palpa jeruja; ngangau jurborinala tjautjau nganana wonti, ja marapu mangapunko nganana wonti, minani tana mapamalina warai. ");
INSERT INTO dif_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Kana wolarali Alexander tertabana wonti, ngangau Juda kanali nina tirimalkana wonti; Alexander marali malka jinkina wonti, ja jertapaterina wonti kana wolarani jaura jinkila. ");
INSERT INTO dif_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Tanali matja ngujamana, nau Juda kana nganai, tanangundru pratjanandru ngaiala kulno pantjina wonti, jeruja tana ditji karitjini pota mandruwirdi maritjina wonti: „Ephesala Artemis pirna nganai!“ ");
INSERT INTO dif_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Nguraia dakanietjali kana wolara daudauana wonti ja jatana wonti: „Jura materi Ephesulala worajai! Worana kana wata milkila, Ephesulala ngura Artemisini punga, ja mudla pariwilpandru matja purina, ngamalkanietja nganai? ");
INSERT INTO dif_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ngangau jenia tjakakani panini parai, jura ngapurinanto, ja panila ngundrana panini ngankananto. ");
INSERT INTO dif_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Jura pudlanapini materi ninkidani wapalkana warai, pudla wata Godaia pungaia watawatali maninietja nganai, ja wata jurani Goda ngirkibai. ");
INSERT INTO dif_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Demetriulu ja ngankanietjali nunkangunto kulnuni ngulku ngamalkanani, jeruja kalala ditji parai, ja najinajibanietja nganai, tana ngulkuterkijiribamalinanto. ");
INSERT INTO dif_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Jura ngantjai minakulnuni ngankamalila, jeruja jenia ngura kana wolara jurborini talkuni pantjinanto. ");
INSERT INTO dif_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ngangau tanali ngaianangu nunkangupini ditjindru ngulkuterkaiati patijiritjibanandru, ngangau wata poto parai, nunkangundru ngaiana talku ngankaterinanto, nunkangupini patijiritjinandru.“ ");
INSERT INTO dif_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ja nau jenia matja jatana, nulu kana wolara jinpana wonti. ");
INSERT INTO dif_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Naupini patijiritjini matja mudana, Paululu mili wolara karkana wonti, ja tanana ngurungutana wonti, ja dunkana wonti Macedoniaia palkala. ");
INSERT INTO dif_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Nau tananapini mita matja palkinganani, ja tanana jaura marapujeli matja kurukurubanani, nau Grieka mitani wokarana wonti. ");
INSERT INTO dif_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Nau naka pira parkulu matja ngamana, ja ngangau Juda kanali manungana wonti nunkangu, nau jertapaterinani Syriaia pararala, nau manu wokarina wonti Macedoniaia tikala. ");
INSERT INTO dif_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Nunkangu jela palkana wonti Asianilu Sopater Pyrrhusuni ngatamura Beröandru; Aristarchus ja Sekundus Thessalonichundru; ja Gajus Derbendru, ja Timotheus; Tychikus ja Trophimus Asiandru. ");
INSERT INTO dif_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Tanapini ngopera wapana wonti, ja ngalingu Troasangu kalkana wonti. ");
INSERT INTO dif_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ngali pulkurutjeribanibukapani ditjini ngadani Philippindru pararana wonti, ja tanangu Troasangu wokarana wonti ditji mara worani; naka ngaiani ditji mara wora ja mandru ngamana wonti. ");
INSERT INTO dif_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Godaia ditjini mili wolara matja jurborina buka wokaribala, Paululu tanangu kaubaubana wonti, ngangau nulu ngundrana wonti ditji kulnuni palkala, ja nulu tinka tertielu jaura jinkina wonti. ");
INSERT INTO dif_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Praitji marapu punga pirini miri nganana wonti, woderi tana jurborina wonti. ");
INSERT INTO dif_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Teri kulno, tala nunkani Eutichus, milkiwilpani ngamana wonti, ja nina muka pirnali patana wonti, ngangau Paulusulu wirdi jaura kaukaubana wonti, ja nau muka pirna jindina wonti, ja nau piri parkulu mirindru purina ngarina wonti, ja tanali nina nari patana wonti. ");
INSERT INTO dif_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Paulus ngarina wonti, ja nunkangu woraterina wonti, ja nina munamana wonti ja jatana wonti: „Wata maritjianau, ngangau nauja mungara nunkangu nganai.“ ");
INSERT INTO dif_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Nau tarana tikana wonti, ja buka wokaribana wonti ja tajina wonti, ja nulu tanangu marapu nguramarani kuparajelu kaukaubana wonti, ja jeruja nau palkana wonti. ");
INSERT INTO dif_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Tanali nina teri tepi wokaralkana wonti, ja ngalkalkani pirna manina wonti. ");
INSERT INTO dif_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Ngaiani ngopera botani wirina wonti, ja Assonia pararana wonti, woderi ngaiani jertapaterina wonti Paulus patala, ngangau nulu jeruja jirijiribana wonti, ngangau nulu ngantjana wonti tidnali wapala. ");
INSERT INTO dif_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Nau Assongu ngaianingu matja mandurina, ngaiani nina patana wonti ja Mitylenengu wokarana wonti. ");
INSERT INTO dif_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ngaiani nakandru matja pararana, ngaiani ditji kulnuni Chionkari wokarana wonti; ja ditji kulnuni ngaiani Samoni wokarana wonti, ja ngaiani Trogylliongu palpa matja ngamana, ngaiani ditji kulnuni Miletingu wokarana wonti. ");
INSERT INTO dif_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paululu ngundrana wonti Ephesungu palkingana, ngangau nulu wata ditji tintananto Asiani, a‐ai, nau nururina wonti, jenia nunkangu pantjinanto, Jaolaia ditji pirnani Jerusalemingu ngamala. ");
INSERT INTO dif_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Miletungundru nulu Ephesungu jinpana wonti, ja mili wolaraia kapara karkana wonti. ");
INSERT INTO dif_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Tana nunkangu matja wokarana, nau tanangu jatana wonti: „Jura milkila, ditji ngoperandru, ngani Asiani matja wokarana, worderu ngani jurangu milingeru nganana wonti; ");
INSERT INTO dif_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ja Kaparaia mili nganana wonti wakawaka ngundraterinali ja milkigildi marapujeli, jenia ngakangu pantjina wonti Juda kanandru, tana ngakangu tirikaripaterina wonti; ");
INSERT INTO dif_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Worderu ngani panila kurukurumalkana wonti nunkangundru, mina ngumu nganai, jenia jurangu wata kaukaubananto, ja jurangu ngujangujara jinkinanto tinkari ja punga pilki ja pilkini; ");
INSERT INTO dif_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ja tinkari ngankana wonti Juda kanani ja Grieka kanani madlentjandru karitjila Godani, ja morlalu ngundrala Kaparani ngaiananani Jesungu Christungu. ");
INSERT INTO dif_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Ja mai! Ngani Jaolali dupudupu Jerusalemia palkaila, mangapunkujeli mina ngakangu naka mandurila nganai; ");
INSERT INTO dif_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Windri Jaola kulikirieli ngura pratjanani ngakangu morlalu tinkari ngankai ja jatai: Dupudupu ja ketjaketjana ngakangu naka kalkateriai. ");
INSERT INTO dif_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Jenia pratjana ngato panila ngundrai, ja bakana ngani mungara ngani wata pirna ngundrateriai; ngangau ngato mindrini ngakani mankinali mudananto, ja ngamalkijiribani, ninaia ngato Kapara Jesundru maninala, ngantjani jaura Godaia manjulandru morlalu tinkari ngankala. ");
INSERT INTO dif_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Ja mai, karari ngani milkila, ngana mudla jura wata morla najila nganai, jura pratjanali tanangu ngani wirarinani Godaia mililandru kaukaubana. ");
INSERT INTO dif_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Jendrangundruja ngato jurangu karari ditjini tinkari ngankai, ngani kulikiri nganai pratjanaia kumarandru. ");
INSERT INTO dif_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Ngangau ngato jurangu panila kurukurumalkana warai, ngato jurangu Godaia jertapaterina pratjana wata kaukaubananto. ");
INSERT INTO dif_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Munta ngamalkaterianau, ja ngami pratjana ngamalkanau, tanangupini Jaola kulikirieli jurana kurana warai najinajibanietja kapara nganala Godaia mili wolara ngamalkala, tanana Nulia mamana wonti kumarali nunkanali. ");
INSERT INTO dif_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ngangau ngani milkila, ngakani wapanani ngadani pandipandi tiri jurangu wirila nganai, tanali ngamini wata manju nganala nganai. ");
INSERT INTO dif_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Bakana jurangundru terti materi terkakala nganai, tanali tjautjau jatala nganai, ja mili tanangu ngadani karkarkala nganai. ");
INSERT INTO dif_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Jendrangundruja tepi ngamanau, ja ngundranau ngato kilpawoldra parkuluwirdi tinkani ja ditjini wata mudana warai, jurana pratjana milkigildieli kurukurubala. ");
INSERT INTO dif_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Ja karari, ngatata ngantjalu, ngato jurana Godangu ja nunkanaia murlaia jaurani kurala wapaia, Nauja ngurunguru nganai jurana wotila, ja jurangu maratunka jinkila nganai kulikirini pratjanani jela. ");
INSERT INTO dif_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Marda bulu, marda maralje, kati kara, ngato wata kulnundru ngatjina warai. ");
INSERT INTO dif_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Jura muntali ngujamai, ngakanaia ja ngakanaia wonta ngamalkijiribanandru pudlali marali mili nganana warai. ");
INSERT INTO dif_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Pratjanani ngato jurangu wondrana warai, kanali jeruka ngankananto, ja wangiwangini marangokananto, ja Kaparaia Jesuni jaura ngundrananto, ngangau Nauja munta jatana wonti: Jinkina morla murlali pirna nganai maninani.“ ");
INSERT INTO dif_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Ja nau jenia matja jatana, nau pantjaterkana ngarina wonti, ja tanangu pratjanani jela ngatjina wonti. ");
INSERT INTO dif_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Jindrini marapu tanangunto pratjanani nganana wonti; ja tana Paulungu munkamalina wonti, ja nina manatapana wonti. ");
INSERT INTO dif_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Morla ngaurongauro tana pantjina wonti nunkangupini jaurandru, nina nau jatana wonti, tanali nina mudla wata morla najinanto. Ja tana nunkangu jela botaia wapana wonti. ");
INSERT INTO dif_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Jendranguta ngaiana pararanani, ja ngaiana tanangundru matja delkiterina, ngaiana nururingana Kosuni wokarana wonti, ja ditji kulnuni Rhoduni, ja nakandru Patarani. ");
INSERT INTO dif_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ja ngaiana bota kulno matja mankamankana, nau Phönicieni pararanani, ngaiana nunkangu wirina wonti ja tirimalkana wonti. ");
INSERT INTO dif_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Ngaiana Cypern matja najina, ngaiana nina worangantjujeli worarana wonti ja Syriankaria pararana wonti ja Tyrungu banbana wonti; ngangau naka botali poto nunkani worajiribananto. ");
INSERT INTO dif_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ja ngaiana mili matja mankamankana, ngaiana ditji mara wora ja mandru naka ngamana wonti; ja tanalipini Paulungu Jaolali kulikirieli jatana wonti, nau wata Jerusalemia tarananto. ");
INSERT INTO dif_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ngaiana tananapini ditji naka matja ngamana, ngaiana dunkana wonti ja palkana wonti, ja tana pratjana widlani ja kupani jela ngaianangunto ngura tidnantaia wapana wonti, ja ngaiana dirkalani pantjaterkana ngarina wonti ja ngatjina wonti. ");
INSERT INTO dif_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Ja ngaiana matja danidanilkijiribamalina, ngaiana botani wirina wonti, ja tana pungaia tikana kurana wonti. ");
INSERT INTO dif_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Ngaiana palkana matja mudana, ngaiana Tyrundru Ptolomaiungu wokarana wonti, ja ngatatani mandurini jaura jinkina wonti, ja ditji kulno tanangu jela ngamana wonti. ");
INSERT INTO dif_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ditji kulnuni ngaiana dunkana kurana wonti, ja Casareangu wokarana wonti; ja ngaiana Philippuni ngantjani jaura kaukaubanietjaia pungani wokarana wonti, nau mara wora ja mandrundru kulno nganana wonti, ja nunkangunto ngamana wonti. ");
INSERT INTO dif_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Nulupini ngatamura mankara mandru ja mandru ngamalkana wonti, tana mankara mantaka nganana wonti, tana talpadakana wonti. ");
INSERT INTO dif_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Ngaiana ditji palpa naka matja ngamana, Propheta kulno Judaiandru ngarina wonti, tala nunkani Agabus. ");
INSERT INTO dif_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Nau ngaianangu wokarana wonti, ja Pauluni dala mantamanta patana wonti, ja munta mara ja tidna workamantraterina wonti, ja jatana wonti: „Jeruja Jaola kulikiri jatai: Ninaia materi, nunkangu naupini dala mantamanta nganai, ninaia Juda kana jeruja workamandrala nganai Jerusalemingu, ja ninaia kana koja marani ngulkujeli jinkila nganai.“ ");
INSERT INTO dif_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Ngaiana jenia matja ngarana, ngaiani ja bakana tanapini ngurala nunkangu ngatjina wonti, nau wata Jerusalemia tarananto. ");
INSERT INTO dif_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Paululu kalabana wonti: „Mina jura ngankai, ngangau jura jindrai ja ngana ngara wokaribai? Ngani matja ngankingaterina jinkiterila, wata windri workamantranani, a‐ai, bakana palinani Jerusalemingu Kaparaia Jesuni talandru.“ ");
INSERT INTO dif_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Ngangau nau milingeru tintjaterinani, ngaiani ngapurina wonti ja jatana wonti: „Kaparaia jertapaterina pantjiatimai!“ ");
INSERT INTO dif_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Tanangupini ditjini ngadani ngaiana judujudu pratjana ngankingana wonti ja Jerusalemia tarana wonti. ");
INSERT INTO dif_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Ngaianangu jela bakana mili palpa Cäsareandru wapana wonti, ja tanali ngaianana materi kulnuni, tala nunkani Mnason Cyperndru, wapalkana wonti, nau mili pinaru nganana wonti, nunkangu ngaiana tidnapalara ngamananto. ");
INSERT INTO dif_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Ngaiana Jerusalemingu matja wokarana, ngatatajeli ngaianana mankinali patana wonti. ");
INSERT INTO dif_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ditji kulnuni Paulus ngaianangu jela Jakobungu wirina wonti, ja pinaru wora nakanika mapaterina wonti. ");
INSERT INTO dif_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Ja nulu tanangu mandurini jaura matja jinkina, nau tidna warapaterina wonti mina Godali kana koni ngankana warai nunkani ngamalkijiribanilali. ");
INSERT INTO dif_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Tanali jenia matja ngarana, tanali Kapara jurakokana wonti, ja tanali nunkangu jatana wonti: „Jundru najiai, ngatatajai! worderuntja 1000 Juda kanali morlalu ngundrala wapaia; ja tana pratjana manabakapirna nganai jirijiribani jauraia. ");
INSERT INTO dif_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Tanali kaukaubani jaura jinkangundru ngarana warai, jundru Juda kana pratjanani, tana kana koni terti ngamai, ngujangujara jinkiai, tanali Mose worarananto, ja jatai: Tanali tanani kupa wata karuwali ngankananto, bakana wata mangini warula jeribaka wirarinanto. ");
INSERT INTO dif_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Mina karari? Kana wolara kantji jurborinanto, ngangau tanali ngarala nganai jidni matja wokarana. ");
INSERT INTO dif_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Jenia ngankamai, mina ngaiani jinkangu jatai. Ngaianingu terti materi mandru ja mandru nganai, tanali talpadakani tanangu ngamalkai; ");
INSERT INTO dif_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Tananapini jinkangu maniau, jinkangu jela kulirkananto, ja kalala tanangundru jinkiau, tanali para wokaribananto; ja pratjanali najila nganai, jenia baku nganai, mina tanali jinkangundru kaukaubana warai, a‐ai, jidni bakana jirijiribani jauraia ngamalkijiribanietja ngamai. ");
INSERT INTO dif_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Tana kana koni morlalu ngundrala wapaia, ngaiani jirijiribani jaura jinpana wonti, ja morlalu kurana wonti, tana ngamalkaterinanto muramura poto ngumu jinkinandru ja kumarandru ja ngurlini ngantindru ja palakantjindru.“ ");
INSERT INTO dif_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ngadani Paululu tanana materi nunkangu manina wonti, ja ditji kulnuni tanali nina tanangu jela matja kulirkana, nau Godaia pungani wirina wonti ja wondrana wonti, tanali kulikiri ngankani ditji morlalu ngamalkana warai, tanali tanangu pratjanandru poto ngumu jinkinantulu. ");
INSERT INTO dif_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Tanali ditji mara wora ja mandru ngampu mudanani, Juda kanali Asiandru nina Godaia pungani najinani, tanali kana wolara patijiritjibana wonti, ja nunkangu mara kurana wonti, ");
INSERT INTO dif_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Ja maritjina wonti: „Jura Israel materi worajai, marangokanau! Naupini nau kana nganai, nulia kana wolarani ja jirijiribani jaurani ja nunkangupini pirini paruparu pratjanani delkini ngujangujara jinkiai; ja nulia bakana Grieka kana Godaia pungani wirilkana warai, ja ninapini piri kulikiri murumuru ngankana warai.“ ");
INSERT INTO dif_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ngangau tanali ngopera Trophimus Ephesala nunkangu jela ngurani najila wiri ja ngundrala wiri, Paululu nina Godaia pungani wirilkana warai. ");
INSERT INTO dif_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ja ngurala warupoto patijiritjina wonti, ja kana wolara jurborina wonti; ja tanali Paulus patana wonti, ja nina Godaia pungandru parumana tarana wonti, ja nurujeli tanali mana nguru ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Tanali wontina wonti nina nari ngankala; naupini kaukaubani jaura juljaia kaparani tarana wonti, Jerusalemala warupoto patijiritjina warai. ");
INSERT INTO dif_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Nulu nurujeli julja worana ja kapakapara manina wonti, ja tanangu mindrina ngarina wonti. Tanali julja kapara ja julja wolara matja najina, tanali mudana wonti Paulus nandrala. ");
INSERT INTO dif_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ngadani juljaia kapara karakararina wonti ja jirijiribana wonti nina patananto, ja jirijiribana wonti nina kanjangari mandrujeli workamandrala; ja nulu jakalkana wonti worana nauja nganai, ja mina nulia ngankana warai. ");
INSERT INTO dif_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Kana wolarandru palpa jeruja maritjina wonti ja palpa jeruja. Ngangau nau ngandandarina wonti jaura morlalu ngujamala maritjinandru, nulu jirijiribana wonti, nina julja wolaraia pirini taralkala. ");
INSERT INTO dif_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Nau tidnaia katinani matja wokarana, juljali nina mandrananto kana wolaraia ngurulandru. ");
INSERT INTO dif_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ngangau kana wolara karipaterina wonti ja maritjina wonti: „Ninaia teribau!“ ");
INSERT INTO dif_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Ja tanali Paulus juljaia pirini wirilkanani, nau juljaia kaparani jatana wonti: „Jundru ngakangu manuni kurai jinkangu palpa jatala?“ Nau jatana wonti: „Jundru Grieka jaura ngujamai? ");
INSERT INTO dif_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Jidni wata naupini Egyptala ngani, nulu kalkani patijiritjibani ngankana paraia, ja tanana kana 4000 nari nandranietja pitarani dunkalkana paraia?“ ");
INSERT INTO dif_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paulus jatana wonti: „Ngani Juda kana nganai, Tarsusala, Ciliciani ngura wata wakawakaia kana, ngato jinkangu ngatjiai, ngakangu manuni kurau kana wolarani kaukaubala.“ ");
INSERT INTO dif_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Nulu nunkangu matja manuni kurana warai, Paulus tidnaia katinani terkakana wonti, ja kana wolarani malka jinkina wonti; ja matja dalpura pantjinani, nulu tanangu Juda kana talini kaukaubana wonti ja jatana wonti: ");
INSERT INTO dif_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","„Ngatata ja ngaperi worajai, ngakani kaukaubaterini jaura jurangu karari ngaranimarau!“ ");
INSERT INTO dif_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Tanali ngaranani, nulu tanangu Juda kana talini kaukaubanani, tana morla dalpura nganana wonti. Ja nau jatana wonti: ");
INSERT INTO dif_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","„Ngani Juda kana nganai, Tarsungu Cilicieni matja dankana, ja tanali ngakangu nunkangupini ngurani Gamalieli tidnani pirna ngankana wonti, ja ngurungurulali ngato ngaperaia jirijiribani jaurani ngujangujara maninala, ja ngani Godangu manabakapirna nganana wonti jurangu pratjanani karari jeribaka; ");
INSERT INTO dif_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ja ngani ninapini palto tirikaripaterina wonti narielu, ja ngato materi ja widla dupudupu ngankana wonti, ja tanana kanjangari pungani ngulkujeli jinkina wonti, ");
INSERT INTO dif_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Worderu ngakangu bakana Priesta pirnali ja pinaru worali pratjanali tinkari ngankai, tanangundru ngato bakana dakani jaura manina wonti ngatataia, ja Damaskuja palkana wonti, bakana tanana, naka ngamanani, dupudupu Jerusalemia wapalkala kalalaia. ");
INSERT INTO dif_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Jendranguta ngani palkanani, ja Damaskungu karakara wokaranani, todani nurujeli ngakangu pariwilpandru praitji mintjina karitjina wonti. ");
INSERT INTO dif_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ja ngani mitani purina ngarina wonti, ja ngaiala kulno ngakangu jatanani ngarana wonti: «Saulujai, Saulujai, minandru jidni ngakangu tirikaripaterila wapaia?» ");
INSERT INTO dif_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ngato kalabana wonti: Worana jidni nganai Kaparajai? Ja Nauja ngakangu jatana wonti: Ngani Jesus Nazaretala nganai, nunkangu jidni tirikaripaterila wapaia. ");
INSERT INTO dif_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Tana ngakangunto nganana, praitji najina wonti, ja japali pirna pantjina wonti; ja nunkani ngaiala, nulungali ngankamalinani, tanali wata ngarana wonti. ");
INSERT INTO dif_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ngani jatana wonti: Mina ngato ngankananto Kaparajai? Kapara ngakangu jatana wonti: Terkala taramai, ja Damaskuja wapau, naka tanali jinkangu pratjana kaukaubala nganai, mina jinkangu kurana parana ngankananto. ");
INSERT INTO dif_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ngangau ngani ngandandarinani najila nunkanaia praitjaia mintjinandru, kamanelieli ngakanali ngana marali wapalkana wonti, ja jeruja ngani Damaskungu wokarana wonti. ");
INSERT INTO dif_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Ananias kulno, nau Godaia jirijiribani jaurandru japali, nunkangu Juda kana pratjanali naka ngamanali pirna ngundrana wonti, ");
INSERT INTO dif_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Nau ngakangu wokarana wonti, ja ngakangu karakararina wonti ja jatana wonti: Ngatata Saulujai, najina tarau! ja nunkangupini ditjini ngato nunkangu najina tarana wonti. ");
INSERT INTO dif_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Nau jatana wonti: Ngaiananaia ngaperaia Godali jidna ngopera kurana wonti, jidni jertapaterini nunkani ngujamananto, ja ninaia Talkupirna najinanto, ja ngaiala nunkani nunkani manandru ngarananto. ");
INSERT INTO dif_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ngangau jidni tinkari ngankanietja nganala nganai nunkangu, kanani warupotuni, nunkangundru, mina jundru najina warai ja ngarana warai. ");
INSERT INTO dif_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ja karari, minandru jundru ngujawakai? Terkala tarau, ja multibanila madlentjandru kulirkala maniau, ja Kaparaia tala karkau! ");
INSERT INTO dif_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Jendranguta ngani Jerusalemia matja tikana, ja ngani Godaia pungani ngatjinani, ngani ngaramarlarina wonti. ");
INSERT INTO dif_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Ja ngato ninaia najina wonti, Nauja ngakangu jatanani: Mindriau, ja nurujeli Jerusalemingundru puntiau, ngangau tanali jinkani tinkari ngankani ngakangundru wata patala nganai. ");
INSERT INTO dif_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ja ngani jatana wonti: Kaparajai, tana munta milkila, ngato tanana, jinkangu morlalu ngundrana, jaura pungani wirrieli mandrana wonti, ja kanjangari pungani widmana wonti. ");
INSERT INTO dif_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ja jendranguta Stephanani jinkanaia tinkari ngankanietjaia kumari matja ngakana, bakana ngani munta naka terkana wonti, ja nunkani nari ngantjana wonti, ja tanani kati ngamalkiribamalina wonti, tanali nina nari ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Ja Nauja jatana wonti ngakangu: «Wapau, ngangau ngato jidna kana koni jinpala nganai.»“ ");
INSERT INTO dif_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Tanali nina ngarana wonti nunkangupini jauranilu, ja tana ngaiala tanani miririna wonti ja jatana wonti: „Ninapini mitandru teribanau, ngangau jenia wata talku nganai, nauja tepi ngamananto!“ ");
INSERT INTO dif_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Tana maritjinani, ja tanani kati woraranani, ja puturu miri teribanani, ");
INSERT INTO dif_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Jendranguta juljaia kaparali jirijiribana wonti, tanali nina juljaia pirini wapalkananto, ja jatana wonti, tanali nina wirrieli nandranali jakalkananto, ngangau nulu ngujamananto, minandru tana nunkangundru jenia miritja ngankai. ");
INSERT INTO dif_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Tanali nina ngutana ngurakatibinani wirria, Paulus nunkangu juljaia kapakaparani, nau karakara terkanani jatana wonti: „Jenia jurangu manuni kurala wapaia, kana kulno, nau Romala nganai, kalala kurani panini nandrala?“ ");
INSERT INTO dif_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Juljaia kapakaparali jenia matja ngarana, nau juljaia kaparani wapana wonti ja nunkangu kaukaubana wonti ja jatana wonti: „Mina jundru ngundrai ngankala? Naupini kana Romala nganai.“ ");
INSERT INTO dif_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Juljaia kapara karakararina wonti ja nunkangu jatana wonti: „Jatau ngakangu, jidni Romala?“ Nau jatana wonti: „Kau.“ ");
INSERT INTO dif_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Juljaia kaparali kalabana wonti: „Ngato kalala pirnali ninata ngurala burungankanala“. Paulus jatana wonti: „Ngani bakana Romala dankana wonti.“ ");
INSERT INTO dif_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Nurujeli tanali nina worarana wonti, tanali nina jakalkananto; ja juljaia kapara japali pantjina wonti, nulu matja ngarana, nau Romala nganai, ja ngangau nulu nina dupupu ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ditji kulnuni nulu ngantjana wonti morlalu ngujamala, minandru Juda kanali nunkangu ngulkuterkala wiri, ja nulu nina dukarana wonti ja jirijiribana wonti, Priesta pirna ja kapara pratjana jurborinanto; ja nulu Paulus ngarilkana wonti, ja nina tanangu terkibana wonti. ");
INSERT INTO dif_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paululu kapara pratjana ngurutalpana najina wonti ja jatana wonti: „Jura materi ja ngatata worajai, ngani ngara ngaiala ngumujeli Godani wirarina wonti nunkangupini ditjielu.“ ");
INSERT INTO dif_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ananias Priesta pirnali tanangu, tana nunkangu karakara terkanani, jirijiribana wonti, nina mana nandrala. ");
INSERT INTO dif_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Paulus nunkangu jatana wonti: „Godali jidna nandrala nganai, jidna wiribani wontini! Jidni ngamai ngakangu jirijiribani jaurali kalala jinkila, ja jirijiribani jaura panini jundru jirijiribai ngana nandrananto?“ ");
INSERT INTO dif_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Tana naka terkana jatana wonti: „Godaia Priesta pirnani jidni madlentji jatai?“ ");
INSERT INTO dif_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Ja Paulus jatana wonti: „Ngatata worajai! Ngani ko nganana warai, naupini Priesta pirna nganai, ngangau dakanala parai: Jidni jinkani kana wolaraia kaparani wata madlentji jatananto.“ ");
INSERT INTO dif_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Paululu ngujamana wonti, palpa tanangundru Pharisaiala ngananani, ja palpa Sadducaiala, nau kana kapara pratjanani terti maritjina wonti: „Materi ja ngatata worajai! Ngani Pharisaiala nganai, Pharisaialaia ngatamura; kalkanandru ja nari jiritjinandru ngani kalalaia terkai.“ ");
INSERT INTO dif_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Nau jenia matja jatana, Pharisaiala ja Sadducaiala jatamalina wonti, ja kana wolara tjelapalkaterina wonti. ");
INSERT INTO dif_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Ngangau Sadducaiala jatai: Nari jiritjini ja angela ja jaola pani nganai; Pharisaialali jenia mandru kaukaubai. ");
INSERT INTO dif_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ja miritja pirna pantjina wonti, ja Pharisaiala jaura jinkinietja palpa terkana tarana wonti ja tjakakijiribamalina wonti ja jatana wonti: „Ngaiani wata madlentji nunkangupini kanani mankamankai; jaola kara angela kara nunkangu ngankamalina warai, ngaiani ngandandariai Godani tirimalila.“ ");
INSERT INTO dif_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Patijiritjini morla pirna pantjinani, juljaia kapara japali pantjina wonti, tanali Paulus diadialkaiati, ja nulu jirijiribana wonti, julja wolara ngarinanto, nina tanangundru terti patananto, ja nina juljaia piria tikalkananto. ");
INSERT INTO dif_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ja tinkani Kapara nunkangu wokarana wonti ja jatana wonti: „Murlali nganau Paulujai, ngangau worderu jundru ngakangundru Jerusalemingu tinkari ngankala wiri, jeruja jundru bakana Romangu tinkari ngankananto.“ ");
INSERT INTO dif_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Matja ditjirina, Juda kana palpa mapaterina wonti, ja morlalu kurakijiribamalina wonti, wata tajila ja wata tapala, tanali Paulus nari nandralalu. ");
INSERT INTO dif_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Tana morla nganana wonti marapratjana pota mandru ja mandruni, tanali jenia morlalu kurakijiribamalini ngankana wonti. ");
INSERT INTO dif_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Tanapini Priesta pirnani ja pinarani wokarana wonti, ja jatana wonti: „Ngaiani kantji morlalu kurakijiribamalina warai panila wontjala, ngaiani Paulus nari nandralalu. ");
INSERT INTO dif_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Jura karari juljaia kaparani ja kapara worangu kaukaubanau, nulu nina tankubana jurangu ngarilkananto, jeruja jeribaka, jura poto nunkani morla talku jertapateriai najinajibala; ngaiani ngankingaterina warai nina nari ngankala, morla ngopera nau jurangu karakararinani.“ ");
INSERT INTO dif_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Pauluni kakuja ngatatajeli tanani ngundrani ngaranani, nau wokarana wonti, ja julja wolaraia pirini wirina wonti, ja jenia Paulungu kaukaubana wonti. ");
INSERT INTO dif_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Paululu juljaia kapakapara kulno karkana wonti ja jatana wonti: „Ninapini teri juljaia kaparani wapalkau, ngangau nulia minakulno ngamalkai nunkangu jatala.“ ");
INSERT INTO dif_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Nulu nina patana wonti, ja juljaia kaparani wapalkana wonti ja jatana wonti: „Paululu kanjangarilali ngana karkana warai, ja ngakangu ngatjina warai, ninapini teri jinkangu wapalkananto, ngangau nulia minakulno ngamalkai jinkangu kaukaubala.“ ");
INSERT INTO dif_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Juljaia kaparali nina mara patana wonti, ja nina tjirimalkana wonti, ja nina jakalkana wonti: „Mina jundru ngamalkai ngakangu kaukaubala?“ ");
INSERT INTO dif_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Nau jatana wonti: „Juda kana ngankamalina warai jinkangu ngatjina, jundru tankubana Paulus kapara worangu ngarilkananto, jeruja jeribaka, tanali nunkani poto morla talku najinajibananto. ");
INSERT INTO dif_vpl VALUES ("