﻿USE sofia;
DROP TABLE IF EXISTS sofia.did_vpl;
CREATE TABLE did_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES did_vpl WRITE;
INSERT INTO did_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Na kani so-idi to ogkama-anan to mgo ngadan to ka-aw-apu-an no piglikatan ni Jesu-Kristu no sugpù ni David no sugpù gayod ni Abraham. ");
INSERT INTO did_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Na si Abraham, amoy ni Isaac. Na gayod si Isaac, amoy ni Jacob. Aw si Jacob, amoy ni Huda aw mgo kasu-unan din. ");
INSERT INTO did_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Na si Huda, amoy ni Paris aw ni Sara. Si Tamar to inoy dan. Na si Paris, amoy ni Isrum. Na si Isrum, amoy ni Aram. ");
INSERT INTO did_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Na si Aram, amoy ni Aminadab. Na si Aminadab, amoy ni Nason. Aw si Nason, amoy ni Salmun. ");
INSERT INTO did_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Na si Salmun, amoy ni Bus, si Rahab to inoy din. Na si Bus, amoy ni Ubid, si Rut to inoy din. Na si Ubid, amoy ni Jesse. ");
INSERT INTO did_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Na si Jesse, amoy to harì no si David. Na si David, amoy ni Solomon. Na to inoy din, asawa tugdow ni Urias. ");
INSERT INTO did_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Na si Solomon, amoy ni Rubuwam. Na si Rubuwam, amoy ni Abias. Na si Abias, amoy ni Asa. ");
INSERT INTO did_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Na si Asa, amoy ni Husapat. Na si Husapat, amoy ni Huram. Na si Huram, amoy ni Usias. ");
INSERT INTO did_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Na si Usias, amoy ni Hutam. Na si Hutam, amoy ni Akas. Na si Akas, amoy ni Isikiyas. ");
INSERT INTO did_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Na si Isikiyas, amoy ni Manasis. Na si Manasis, amoy ni Amun. Na si Amun, amoy ni Josias. ");
INSERT INTO did_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Na si Josias, amoy ni Hikuniyas aw amoy dà to mgo su-un din todu-on no timpu pad to pagpagawang to mgo Isrili no mgo otow to kandan banwa aw kadaa on kandan katibò diyà to Babiluniya no madiyù on no banwa. ");
INSERT INTO did_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Na pagkadaa to mgo Isrili diyà to Babiluniya, si Hikuniyas nakapanganak ki Salatiyil. Na si Salatiyil, amoy ni Surubabil. ");
INSERT INTO did_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Na si Surubabil, amoy ni Abiyud. Na si Abiyud, amoy ni Iliyakim. Na si Iliyakim, amoy ni Asur. ");
INSERT INTO did_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Na si Asur, amoy ni Saduk. Na si Saduk, amoy ni Akim. Na si Akim, amoy ni Iliyud. ");
INSERT INTO did_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Na si Iliyud, amoy ni Eleasar. Na si Eleasar, amoy ni Matan. Na si Matan, amoy ni Jacob. ");
INSERT INTO did_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Na si Jacob, amoy ni Jose no bana ni Maria no inoy ni Jesu-Kristu no nahingadanan to Imananan to Ka-otawan. ");
INSERT INTO did_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Na-aboy on nasinumpow to kasinugpu-an ni Abraham hantod to sampuù tag upat no ka-sumpow to pigbukladan no pagka-otow ni David. Na-aboy on mandà nasinumpow to kasinugpu-an ni David hantod to sampuù tag upat no ka-sumpow to pigbukladan no pagkadaa to mgo Isrili diyà to Babiluniya aw kalobon. Likat mandà to pagkadaa to mgo Isrili diyà to Babiluniya, na-aboy on nasinumpow to kasinugpu-an dan mandà to sampuù tag upat no ka-sumpow to pigbukladan no pagka-otow ni Jesus no pighingadanan to Kristu su kandin to ogkahimu no Imananan to Ka-otawan. ");
INSERT INTO did_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Na diyà ta pad mandà to tutuwanon to pagka-otow on ni Jesus. Si Maria no inoy ni Jesus no asawahon ni Jose, wadà pad katu-un to bana din no si Jose, dì tahan on natagahan to si Maria, nigkabodos on to pigpamulingan no likat to Ispiritu Santu. ");
INSERT INTO did_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","No pagkama-an ni Jose to kabodos on kandin, konad kandin podon ogpadayong to pagtu-un to asawahon din su ma-unug-unugon kandin no otow to kasugu-an likat ki Moises bahin to pag-a-asawa. Pigdomdom ni Jose to og-oyow on podon kandin kan no pangasawahanan din ki Maria. Dì si Jose, konà no ogkaliyag to mahan-ing no otow to ogpakadinog to ogkasukunan su dagow si Maria, mapasikawan to kahan-ingan. ");
INSERT INTO did_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","No pagkatibuus on to domdom din to og-oyow on iyan podon kandin to pangasawahanan din ki Maria, nalipodong kandin. Paglipodong din moydu-on diwata no impakita kandin to Diyus pinabayà to taga-inop din aw pagbaawi kandin no nig-iling to “Jose no sugpù ni David, konà nu ogduwa-duwahon to ginhawa nu bahin to pagponga nu to pangasawahanan nu su sikan no buyag, wadà aang-aang nakaluming pad, su sikan ingkabodos din, impamuling sikan no niglikat to Ispiritu Santu. ");
INSERT INTO did_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Iyan ig-anak din to lukos, aw ikow no amoy-amoy, oghingadanan nu kandin ki Jesus su ogkatùtu-u to kalitukan to ngadan din to iyu no inikagihan no ogpakalipwas kandin to mgo saà to sakup din.” ");
INSERT INTO did_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Na sikan tibò nadoog-doogan ni Jose aw ni Maria no awos matuman to intag-an natodu-on to maglilikwaday to Diyus no lagsoban. ");
INSERT INTO did_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Na so-idi to intag-an no pig-iling to “Indanan now su og-anak to songo daga no wadà pad kalumingi aw ig-anak din to lukos no oghingadanan ki Imanuel” (no iyan kalitukan to “Nakasood ita to Diyus”). ");
INSERT INTO did_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Dayun nakagimata si Jose aw tumana din to kagi to diwata. Na nigpadayong kandin to pagpudut to asawahon din ");
INSERT INTO did_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","dì monang nighidani kandan no ing-anak pad to batà no pigpamulingan no panganoy ni Maria no pighingadanan ni Jose ki Jesus. ");
INSERT INTO did_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Na diyà i-anak si Jesus to lunsud to Bitlihim no prubinsiya to Hudiya todu-on timpu to pagharì ni Hirudis. Pagka-anak ki Jesus nigsilat to bayà no bitu-on diyà dapit to silatan. Na moydu-on mgo otow no manilatan no nangkama-an to kadodoog to mgo bitu-on no nig-indan to pagsilat kan bayà no bitu-on. Pagkakita dan, nighipanow on kandan no ogtu-ud diyà to nalongodan to pigbandogan kan no bitu-on su pigma-an kandan to Diyus to sikan no bandog to innangon kandan dow ando-i ig-anak to harì to mgo Hudiyu no mgo otow. Na nigdatong kandan diyà to Hirusalim no lunsud no pig-ugpa-an ni Harì Hirudis no madani dà to oot to Bitlihim no lunsud. Pagdatong dan, namangusip-usip kandan to mgo ka-otawan to ");
INSERT INTO did_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Dow ando-i buwa to batà no bayà na-otow no ogkahimu no harì to mgo ka-Hudiyuhan. To ing-andini noy su ogpanutuwon noy todu-on no batà su diyà noy ka-unug to pigsilatan to bitu-on no iyan nakahindù kanami diyà to pig-anakan kandin aw ogtahud koy podon todu-on no batà no ogkahimu no harì to mgo ka-Hudiyuhan.” ");
INSERT INTO did_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Na nigtangkap to nawnangonon bahin to tu-ud dan. No pagkadinog ni Harì Hirudis to moydu-on kun duma no ogkahimu no harì du-on kan no banwa, konad no pagkapook-pook din aw tibò no taga-lunsud diyà to Hirusalim su nahadok kandan ko og-abut to samuk. ");
INSERT INTO did_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Dayun impatawag to harì to mgo punu-an to tinu-uhan to mgo Hudiyu aw kan nangkama-an to mgo kasulatan dan su awos pangintagahan din podon dow ando-i to ig-anak si Kristu no Imananan to Ka-otawan no intag-an to mgo lagsoban. Pagkatibò dan nig-usip to harì to “Dow ando-i buwa to ig-anak si Kristu no iyan Imananan to Ka-otawan no ogsakup itanow agad-agad to kasulatan.” ");
INSERT INTO did_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Nig-ikagi kandan to “Bitlihim no lunsud to og-anakan, kani dà so-idi prubinsiya to Hudiya su impatag-an man no impasulat to Diyus to lagsoban din no pig-iling to ");
INSERT INTO did_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ikow no Bitlihim no lunsud, to mgo punu-an to mgo Hudiyu, nahimu ka dan no kamatu-udan no lunsud diyà to prubinsiya to Hudiya su agad malig-ot ka dà, dì ikow on to oglikatan to magsasakup to pigsakupan ku no mgo ka-Isrilihan.’” ");
INSERT INTO did_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Na pagkama-an ni Harì Hirudis dow ando-i to oglikatan to Imananan to Ka-otawan, pigpatawagan din todu-on nangkama-an no mgo otow no mgo manilatan su ogtongopan din og-usipon kandan dow kagan-u dan lagboy kakita-i to pagsilat kan no bitu-on. ");
INSERT INTO did_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Pagkama-an lagboy to harì, pigpa-andiyà din kandan to Bitlihim aw ikagihi din to “Ogpanganapon now todu-on no batà. Ko makita-àn now on, tagahon a now su og-ahà a su ogtahudan ku podon gayod kandin.” ");
INSERT INTO did_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Pagkadinog dan to kagi to harì, nighipanow on kan mgo manilatan aw tinakin nigsilat mandà kan bitu-on no angod dà ton paglikat dan. Pagkakita dan to bitu-on, konad no pagtukhow dan, aw nig-isog-isog kan bitu-on no nigpadoog diyà to kaylu dan aw iyan unug-unuga dan to pigbandogan to bitu-on hantod to nigdatong diyà to topad to pig-ugpa-an to batà aw sigkon to pagka-isog-isog. ");
INSERT INTO did_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Pagdatong dan, namanponhik kandan aw kakita dan to batà aw si Maria no inoy din. Namanluhud kandan aw tahud-tahuda dan to batà. Dayun pig-ukbahan dan gayod to kinaban-kaban aw butbuta to bobogoy dan to batà no buwawan aw palina no mahal aw mgo pahomut. ");
INSERT INTO did_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Na pagkalipodong kan nangkama-an no mgo manilatan no mgo otow, pigpataga-inop kandan to Diyus to konà ogpa-uli-on diyà to harì. Kaling man nighipanow on kandan no nig-ulì dì wadad sudsud to imbayà dan no tahan. ");
INSERT INTO did_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Na si Jose no nali-usan to mgo manilatan, moydu-on diwata no impakita mandà kandin to Diyus no pinabayà to taga-inop. Nig-ikagi to diwata to “Bangun kad aw hipanow kow on si Maria aw batà din diyà to Ihiptu no banwa aw pakamonang kow du-on hantod to ogkatugutan ku iyu to og-ulì dini su ogpanganapon kow ni Hirudis su awos mahimatayan din podon kan batà!” ");
INSERT INTO did_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","15","Na nakabangun si Jose to madukilom pad aw makahipanow kandan si Maria aw batà din diyà to Ihiptu aw du-on ugpà kandan kotob to pagkamatoy ni Harì Hirudis. To inlaguy dan du-on su awos matuman to impanangon to Diyus to lagsoban din no maglilikwaday no pig-iling to “Pigpatawagan kud on to Anak ku no pigpapa-ulì ku su pigpahipanow kud on diyà to Ihiptu.” ");
INSERT INTO did_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Pagkama-an ni Hirudis to pig-iyan-iyanan kandin to mgo manilatan no mgo otow, konad no pagkalangot din. Dayun pigsugù din to mgo sundau din to ogpahimatayan to tibò no mgo batà no lukos diyà to Bitlihim aw mgo kalongodan kotob kan og-idad on to daduwa no tu-ig aw sikan agad konà pad og-abut to daduwa no tu-ig agad-agad to tugdow no pagsilat kan bayà no bitu-on no innangon kandin kan mgo manilatan no mgo otow. ");
INSERT INTO did_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Sikan to ingkatuman to intag-an ni Jeremias no lagsoban to Diyus no maglilikwaday no pig-iling din to ");
INSERT INTO did_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ogkadinog diyà to Rama to pagsisinogow aw daugmatoy su pigsinogawan ni Raquel to mgo batà din. Konà kandin ogkasapadan su tibò to batà din, nangkamatoy.” ");
INSERT INTO did_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Na pagkaugoy-lugoy namatoy on si Harì Hirudis. Pagkamatoy to harì, si Jose, impakita kandin mandà to diwata no likat to Diyus no pinabayà to taga-inop din no kandan, diyà pad to Ihiptu. ");
INSERT INTO did_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Nig-ikagi to diwata to “Bangun kad on aw ulì kow on si Maria aw batà din diyà to ka-Isrilihan su namatoy on ton oghimatoy podon sikan no batà.” ");
INSERT INTO did_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kandan si Jose, namanbangun aw ulì diyà to ka-Isrilihan. ");
INSERT INTO did_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Na pagkamatoy ni Harì Hirudis, si Arkilaw no anak din nakasukoli mandà to pagharì diyà to Hudiya no banwa. Pagkama-an ni Jose to naharì on to anak ni Hirudis diyà to Hudiya, nahadok mandà kandin to ogpakamonang du-on. Na inabut mandà kandin to tugun no pinabayà to taga-inop din to ogpapadayongon kandin diyà to Galiliya no banwa. ");
INSERT INTO did_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Du-on pakamonang kandan diyà to Nasarit no lunsud. Iyan inhalin dan diyà to Nasarit su awos matumanan si Jesus to na-ikagi to lagsoban to Diyus no maglilikwaday no pig-iling to “Oghingadanan kandin to taga-Nasarit puli.” Na kandan si Jose, naman-ugpà diyà to Nasarit aw du-on tulin si Jesus. ");
INSERT INTO did_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Na diyà ta pad to bugti no tutuwanon. Pagkabayà to pila on no tu-ig, si Juan no Magbobonyagay, niglogwà diyà to kahanongan no banwa aw du-on ugpà kandin no nasakup to prubinsiya to Hudiya. Na nigpangudlin kandin to mgo ka-otawan to ");
INSERT INTO did_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Og-oyowan now on to katahani now no bugtì su konà no maugoy ogkatuman to pagsakup ita to Diyus!” ");
INSERT INTO did_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Na si Isaias no lagsoban to Diyus natodu-on, intag-an din tahan bahin to ki Juan no kabahinan su nig-iling kandin to “Diyà to kahanongan no banwa moydu-on nigpangudlin to ma-agbot lagboy no nig-iling to ‘Oghina-atan now to daan to Magbobo-ot ta. Ogtul-idon now to igbayà din!’” ");
INSERT INTO did_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Na to kabotang ni Juan diyà to kahanongan, tongop dà iyan puli su iyan dà pinangabò din ubag to hinaboan no bubuu to buhì no pighingadanan to kamilyu aw pigpamagkos din to kubaa puli ubag aw iyan dà pagko-on din to tangas aw dogà. ");
INSERT INTO did_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Dì nadudugukan si Juan to ka-otawan no nigmutmut to Hirusalim aw duma pad no kalunsudan diyà to pigsilugan to Hurdan no wohig no ogpaminog to pagpangudlin din. ");
INSERT INTO did_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Pagdinog to ka-otawan to pagpangudlin ni Juan, namantuman kandan aw naman-abin kandan to saà dan aw pamabonyag gayod kandan du-on. ");
INSERT INTO did_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Mahan-ing gayod no mgo punu-an to tinu-uhan to mgo Hudiyu no nakalikat to panon to Parisiyu aw panon to Sadusiyu no puli kandan namanpabonyag ki Juan. Dì nig-ikagi si Juan to “Iyu tibò no mgo otow, iyan na-angodan now to uwod su puli kow malaguy-laguyon to kahadokanan. Nokoy man no puli kow ogpapatiwoy to kaboù to Diyus to mahudi no adow dì wadà kow sosoo to katahani now no bugtì aw oyowi. ");
INSERT INTO did_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Na ko lagboy tùtu-u to pagpasakup now to impang-anad ku bahin to pagsosoo now to paghimu now no bugtì, igpatu-u now no igpabayà to pag-oyow now aw oghimuhon now gayod to madoyow awos igkapatu-u lagboy to pagpasakup now aw katotopong to hinang now aw pagpasakup now. Konà kow ogpadinog to balibad to pagpatu-u now to pagpasakup now. ");
INSERT INTO did_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Konà kow gayod oglangub og-ikagi to ‘Agad on man, konà koy ogpakapatu-u to kanami pagpasakup su konà kinow man ogkabou-an to Diyus su itanow tibò, sugpù kinow dà man tibò ni Abraham no mgo Hudiyu no mgo otow aw impanahad iyan to Diyus diyà ki Abraham to ogpanalanginan din to kasinugpu-an tibò ni Abraham.’ Dì,” kagi ni Juan, “ognangonan ku iyu to si Abraham, konà ogkapook to kasinugpu-an no ogpanalanginan to Diyus su to Diyus, ogpakabauy kandin so-idi no mgo kabatuhan no ogkahimu no kasinugpu-an ni Abraham no ogka-uyunan to Diyus agad Hudiyu aw bugtì no banwa no piglikatan dan. ");
INSERT INTO did_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Na tibò no kayu no konà ogbogas to madoyow, ogpoodon aw dap-uga aw padokoti to kayu, aw kunto-on imomo-ot on podon to ogpupukon iyan du-on to punu-an. ");
INSERT INTO did_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Na kanak, ogmatu-udon kud to pagpasakup now to kanak impang-anad bahin to pag-oyow now to katahani now no bugtì no igpabayà to pagbonyag kud iyu to wohig. Dì moydu-on otow no ogpakasukoli pad hognà kanak no oglabow pad lagboy kandin dini kanak to kabogbogan. Kanak, igatang podon ogpabatà-batà a kandin. Dì konà a su oglabow pad lagboy kandin dini kanak to kabogbogan. Kandin gayod, ogmatu-udon din to pagpasakup now to kandin igpang-anad no igpabayà to ogbonyagan kow to Ispiritu Santu no iyan ogsoodan kow din lagboy. Aw kalisodan gayod no iyan ogka-angodan to logdog no og-abut iyu to igmatu-ud su sikan to ig-anti dow tùtu-u to pagpasakup now kandin. ");
INSERT INTO did_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Na to ogpakasukoli kanak, imomo-ot din oglinisan to gi-okanan su oghimunon din to tipaoy aw ibotang diyà to botanganan. Dì to uhut, ogsangabon to kayu no wadà kaposokanan.” ");
INSERT INTO did_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Na ki Jesus on mandà no tutuwanon to og-uli-on tad. Kandin no wadà pad sood to katondanan din, niglikat on to Galiliya aw diyà to Hurdan no wohig to ogpadoog su awos ogpabonyag kandin ki Juan. ");
INSERT INTO did_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Dì nigbalibad podon si Juan aw maka-ikagi to “Nokoy man no ogpabonyag ka man kanak. Ikow podon nasì to ogbonyag kanak!” ");
INSERT INTO did_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Dì nigtabak si Jesus to “Ikow to ogpabonyagon ku nasì kanak su sikan to ogkatuman ta no igpahimu ita to Diyus.” Dayun nig-uyun si Juan aw bonyagi din. ");
INSERT INTO did_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Pagkatapusi ni Jesus to bonyag, niggamat kandin to pangpang aw tinakin nakadongan to natau-angan to langit aw kakita-i to nigbunsud to Ispiritu Santu no iyan na-angodan to salapati aw du-on taphun ki Jesus. ");
INSERT INTO did_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Nadinog to kagi likat to langit no na-iling to “Sikan to Anak ku no nalogonan ku lagboy no naliyagan kud lagboy.” ");
INSERT INTO did_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Pagbunsud to Ispiritu Santu, nig-allad kandin ki Jesus diyà to kahanongan no banwa awos mapanogkadan kandin ni Satanas to pa-antihan dow makaboos si Jesus to kabogbogan no likat to Ispiritu Santu dow puli iyan lawa din dà to ogbuligan din. ");
INSERT INTO did_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","No nakap-atan no adow si Jesus diyà to kahanongan no banwa no wadà ko-on-ko-on, niglotoy kandin lagboy. ");
INSERT INTO did_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ton du-on pad si Jesus no niglotoy kandin, pigduguk kandin ni Satanas aw iling to “Na, ko ikow iyan to Anak to Diyus, ogbauyon nu so-idi no mgo batu no ogkako-on no paan.” ");
INSERT INTO did_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Nakatabak si Jesus to “Nasulat on no pig-iling to ‘Konà no ogkako-on dà to igkabuhì to otow. Dì igkabuhì gayod to tibò no kagi to Diyus.’” ");
INSERT INTO did_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Na pigdaa si Jesus ni Satanas diyà to Hirusalim no pigdangonan to labow no simbahan aw papukhuya kandin diyà to kinatunguyan to simbahan. ");
INSERT INTO did_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Na nig-ikagi si Satanas to “Ko ikow man iyan to Anak to Diyus, na patayab ka kun diyà to pasak dow wadà man oghalinan nu su nasulat man diyà to mgo kasulatan no pig-iling to ‘Ogsugu-on to Diyus to mgo diwata din to ogpabantayon din ikow. Ogpa-apnayon ikow to mgo diwata din ko makalapdos ka to batu, no ikow, konà ka ogka-amonu.’” ");
INSERT INTO did_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Nakatabak si Jesus to “Nasulat on gayod to ‘Konà nu ogpanogkadan to Diyus no Magbobo-ot nu to pa-antihan.’” ");
INSERT INTO did_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Na pigdaa mandà si Jesus ni Satanas diyà to puputukan to untud. To songo pagpilok dà impakita kandin ni Satanas to tibò no banwa no pig-ugpa-an to mgo pigsakupan tibò dini to babow to kalibutan aw sikan kandan ogkapanggadan aw gayod sikan kandan mgo kaboonganan. ");
INSERT INTO did_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Kagi ni Satanas to “Ahà ka suyà mgo pigsakupan dini to babow. Tibò on ikow dì puli ka luhud dini kanak aw ampù ka kanak su ogbogayan ku gayod ikow sikan.” ");
INSERT INTO did_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Nakatabak si Jesus to “Gawang kad on Satanas, su nasulat on no pig-iling to ‘Iyan dà ogka-ampu-an nu to Diyus no Magbobo-ot nu aw kandin dà to ogkatuman nu.’” ");
INSERT INTO did_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Na kandin, pig-oyowan ni Satanas aw tinakin nakasukoli to mgo diwata likat to Diyus aw alaga-i dan si Jesus. ");
INSERT INTO did_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Na si Juan no Magbobonyagay, napirisu kandin. Pagkama-an ni Jesus to napirisu si Juan, nighipanow on kandin padoog diyà to prubinsiya to Galiliya ");
INSERT INTO did_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","dì wadà paugoy du-on to Nasarit no lunsud din. Nigpadayong nasì kandin diyà to Kapirna-um no lunsud no madani to dagat to Galiliya aw du-on kandin pakamonang kan pag-ootan to Sabulun aw Niptali no diyà dihipag to Hurdan no wohig. ");
INSERT INTO did_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Iyan inhalin ni Jesus du-on su awos matuman on to tag-an ni Isaias no lagsoban to Diyus no pig-iling to ");
INSERT INTO did_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Mgo taga-Sabulun aw mgo taga-Niptali diyà to Galiliya no banwa to mgo natabagan no mgo otow no diyà dihipag to Hurdan no madani to dagat no ma-aslag pad, ");
INSERT INTO did_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","sikan no mgo otow, namaka-ugpà dà diyà to kadigloman su wadà nama-anan dan. Dì kandan, ogkakita-an dan to lanyag no ogpandalipaak. Sikan nadigloman to pagka-ugpà dan no ogpakamatayon, ogkatang-awan dà nasì!” ");
INSERT INTO did_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Na kan no pagdatong ni Jesus diyà to Kapirna-um, pigpunu-an din to pagpangudlin to ka-otawan no nig-iling to “Sosoo kow to katahani now aw oyowi su madaas on to pagsakup to Diyus ita!” ");
INSERT INTO did_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Na nigladgad on si Jesus diyà to boyboy to dagat to Galiliya aw kakita-i din to daduwa no ka-otow no nigpatahadi no iyan ngadan to kakoy si Simon no pighingadanan gayod ki Pedro. Iyan ngadan to hadi si Andres. Namantuntun kandan to pukut su sikan to nama-anan dan no kandan pagpanapì. ");
INSERT INTO did_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Nig-ikagi si Jesus to “Lagi, ko pumasakup kow kanak, ogkasakup ku gayod iyu aw ogpakahimun kow to mgo otow awos masakup ku gayod kandan. Konad on no isdà to ogsakupon now, dì mgo otow to ogpapasakupon now dini kanak.” ");
INSERT INTO did_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Dayun pig-oyowan dan to pukut aw duma kandan ki Jesus. ");
INSERT INTO did_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Na pag-u-ugsud ni Jesus nakita-an din mandà to songo nigpatahadi gayod aw du-on gayod to amoy dan. Iyan ngadan to kakoy si Santiago. Iyan ngadan to hadi si Juan. Iyan ngadan to amoy dan si Sibidiyu. Namandowdoyow kandan to pukut du-on to bautu. Na pigtawag ni Jesus kan nigpatahadi awos pumasakup du-on kandin. ");
INSERT INTO did_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Dayun pig-oyowan dan to amoy dan diyà to bautu aw duma kandan ki Jesus. ");
INSERT INTO did_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Dayun namanlibod kandan si Jesus to mgo simbahan du-on to prubinsiya to Galiliya aw ipang-anad din to Madoyow no Tutuwanon to pagsakup to Diyus, aw kangkadoyow ni Jesus to mgo nangkasakit tibò. ");
INSERT INTO did_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Tibò pigtangkapan to kabantug din diyà to Siriya no banwa. Kaling man pigpandaa dan diyà ki Jesus to mgo nangkasakit no pig-abuy aw kan ogbatì to ogkawaas to lawa aw kan mgo otow no pigpansoodan to busow. Tibò din nangka-uli-an. ");
INSERT INTO did_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kaling man mahan-ing to ka-otawan no nigdumduma kandin likat to Galiliya, Dikapulis, Hirusalim, Hudiya, aw diyà pad dihipag to Hurdan no wohig. ");
INSERT INTO did_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","To mgo ka-otawan no nangkahimun diyà to patag no namantagad ki Jesus, nakita-an din kandan no namanduguk du-on kandin. Dayun niggomow-gomow si Jesus to untud dì madani dà aw namanlibong to mgo pangabaga din. ");
INSERT INTO did_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Nig-ingkud si Jesus no ogpang-anad su tahan din ko ogpang-anad. Ogkadinogan dà gayod to kagi din to mgo ka-otawan no nangkahimun. No nigpang-anad si Jesus nig-iling kandin to: ");
INSERT INTO did_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“To otow no og-abin to kandin, makasasaà, ogkaliyag su ogpakasood kandin to pigsakupan to Diyus. ");
INSERT INTO did_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","To otow no naduyong-ot kunto-on su kandin, makasasaà, ogkaliyag gayod su ogkapadaoyag dà to Diyus. ");
INSERT INTO did_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","To otow no danu-an, ogkaliyag gayod su ogpakatu-un kandin so-idi kalibutan to mahudi no adow. ");
INSERT INTO did_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ogkaliyag gayod tootow no ogpa-aag-aagon din to pagbo-ot to Diyus no ogpakatuwadong to ginhawa su ogkatuwadong man iyan. ");
INSERT INTO did_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","To otow no makawka-aton to kasing-otow din, ogkaliyag gayod su ogka-atan man kandin to Diyus. ");
INSERT INTO did_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","To otow no natibuus to ginhawa din du-on to Diyus, ogkaliyag kandin su ogpakakita kandin to Diyus to mahudi no adow. ");
INSERT INTO did_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","To otow no matihusoy to mgo samuk, ogkaliyag gayod su kandin, ogkahingadanan to sugpù to Diyus. ");
INSERT INTO did_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","To otow no ogkapahadatan to duma su kandin, nigtuman to pagbo-ot kandin to Diyus, ogkaliyag kandin su ogpakatu-un to pigsakupan to Diyus to mahudi no adow. ");
INSERT INTO did_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ogkaliyag kow gayod ko panamas-tamasan kow aw ka-uwang-uwangi kow aw ogbotang-botangan kow su iyu, sakup ku man tibò. ");
INSERT INTO did_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ogkaliyag kow aw tukhow kow su dakoo to igbaos iyu no panalangin no namakabotang on diyà to langit. Sikan pag-uwang-uwang iyu, angod dà to pag-uwang-uwang to mgo otow diyà to mgo maglilikwaday to Diyus natodu-on aw madoyow to igbaos kandan to Diyus.” ");
INSERT INTO did_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Na dini to babow to kalibutan, iyu no mgo sakup ku, iyan ogka-angodan now to asin su ogkahimu no ogpakadoyow kow to agad intawa no ogkapaghiba-otan now. Dì ko ogkagawang to katam-isan to asin, amonuhon ta man to pagpapa-ulì to katam-isan. Sikan konad on ogkapuusan, iyan on ogkahimuhan ta to igkatimbag diyà to labas awos gi-ok-gi-okan to mgo otow.” ");
INSERT INTO did_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Na pigsugpatan ni Jesus to pag-ikagi din no nig-iling to “Iyu, iyan ogka-angodan now to ogpakatang-ow to mgo otow dini to kalibutan su ogbogoy kow to ka-awangan. Iyan ogka-angodan now gayod to lunsud no du-on makabotang to puputukan to untud no konà ogkasalibonan su sunudonon kow man to ka-otawan. ");
INSERT INTO did_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Na ko ogpadokotan ta to ilawan, konà ta ogsangkuban to lata ko konà no diyà ta to igbotang to so-og awos kotob to nasood du-on, tibò ogkatang-awan. ");
INSERT INTO did_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Na iyan ogka-angodan ta to ilawan ko oghimuhon ta to madoyow. Konà ta ighobong to igtang-ow ta no iyan madoyow no hinang ta. Dì ogpapayagon ta su awos ogkakita-an ki to ka-otawan to madoyow no paghimu ta aw makasayà kandan to Diyus no Amoy diyà to langit. ");
INSERT INTO did_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Na konà now ogdomdomon to tu-ud ku to oggawangon to kasugu-an ni Moises aw duma no maglilikwaday to Diyus natodu-on, su tu-ud ku to ogpongahon ku kan katawilan to kasulatan dan. ");
INSERT INTO did_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ogkanangon ku iyu bahin to kasulatan dan, monang mawadà to agad songo kudlis dà dow so puntu dà ko matuman on tibò, agad ogboongon dà to langit aw kalibutan. ");
INSERT INTO did_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","To otow no konà ogtuman to songo sugù dà to Diyus, agad ma-intok dà, aw makapa-unug kandin to duma no otow to kandin batasan, ogpakasagkop dà kandin diyà to pigsakupan to Diyus to mahudi no adow. Dì to otow no ogtuman to sugù to Diyus aw makapa-unug kandin to ka-otawan, sikan to ogpakalabow diyà to pigsakupan to Diyus. ");
INSERT INTO did_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ogkanangon ku iyu, ko konà no labow pad to katuwadongan now du-on to katuwadongan to mgo Parisiyu aw kan mgo mag-a-anad to tinu-uhan, konà kow ogpakasood to pigsakupan to Diyus.” ");
INSERT INTO did_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Na nigsugpat si Jesus to pagpangudlin din no nig-iling kandin to “Na, nadinog now on to sugù no nadawat on to mgo minuna ta no pig-iling to ‘Konà kow oghimatoy to otow su ko oghimatoy kow, ogkapa-atubang kow aw kahimu kow no himatayanan.’ ");
INSERT INTO did_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Dì so-idi to kagi ku iyu gayod, ko puli now mabou-an to kasing-otow now, kastiguhonon kow gayod. Ko puli kow ma-ina-inahon no otow, ogkapa-atubang kow diyà to matikang pad. Dì to otow no og-ikagi diyà to kasing-otow din to ‘Langog ka!’ sangabonon iyan kandin. ");
INSERT INTO did_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ko pananglitan, moydu-on ogdaahon now no bobogoy now to Diyus no igtahud now aw datong kow on du-on kotob dà to solib to simbahan no botanganan to bobogoy now aw makadomdom kow to moydu-on otow no nasawà du-on iyu. ");
INSERT INTO did_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Ibilin now na-ay to bobogoy now to Diyus diyà to labas aw pati-ulì kow aw hinusayay kow pad na-ay, kayan pana igbogoy now to bobogoy to Diyus. ");
INSERT INTO did_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ko pananglitan, moydu-on ogdiklamu iyu diyà to ogdaa to bala-od. Ko konà kow din pad madawat, tu-uni now na-ay to paghusoy. Su ko konà mahusoy, bali no huwis on to ogsangko-an aw ogsugu-on din on to pulis din aw ogpirisuhon kow on. ");
INSERT INTO did_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Konà kow pad ogpakalabas ko konà now pad mabayadan tibò to ogpabayadan iyu. ");
INSERT INTO did_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“In-anad iyu mandà to likat to minuna ta no pig-iling to ‘Konà kow oghilabot to duma.’ ");
INSERT INTO did_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Dì so-idi to kagi ku iyu. To otow no agad puli dà og-otob-otob kandin du-on to buyag, nakasaà on kandin su du-on to sood to ginhawahan din angay on to nakada-og-da-og kandin. ");
INSERT INTO did_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ko makasaà ka to mata no dibauy, lugita aw itimbag. Ayaw kid maka-andiyà to kastiguhanan to saà, agad mamatahan kid. Manginun pad ogpasakup ki to sinakupan to Diyus, agad dibauy nandà to mata. ");
INSERT INTO did_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ko makasaà ka to boad, tampoda aw itimbag. Ayaw kid ikasugba diyà to logdog no kastiguhanan to saà, agad wadà kakipangan ta no otow. Manginun pad ogpasakup ki to sinakupan to Diyus, agad nakipangan ki no otow. ");
INSERT INTO did_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Na in-anad on gayod iyu tibò bahin to nigtugut to kasugu-an ni Moises bahin to pagbolag to asawa no pig-iling to ‘Ko ogbolag to otow to asawa din, ogkabogayan din to asawa din to sulat no kalig-onan din awos ogkahimù dà ogka-asawa to duma.’ ");
INSERT INTO did_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Dì so-idi to kagi ku iyu. To otow, ko og-oyowan din to kandin asawa no una agad wadà saà gawas ko ogpalibug to duma, ogkahimu din to asawa din no sala-an su to asawa din, ogkalap-angan din to kandan pag-a-asawa ko ma-asawa on mandà kandin to duma. Asta pad to otow no og-asawa kan buyag no na-oyowan on, ogkahimu on gayod kandin no sala-an su ogpakalap-ang kandin to pag-a-asawa kan daduwa no wadà kalabotan din.” ");
INSERT INTO did_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Na nig-aboy si Jesus to pagpang-anad din no nig-ikagi kandin to “Na in-anad on iyu to likat to minuna ta no pig-iling to ‘Ko panahad kow aw og-amaa kow to tu-un now no lawa diyà to Diyus, konà now no ogkabalibad.’ ");
INSERT INTO did_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","35","Dì so-idi to kagi ku iyu. No igmatu-ud to igsahad now, wadà ogka-amaan now, agad intaa. Konà kow ogpadaan-daan to ogbalibad to insahad now. Ko ogsahad kow to duma, konà kow ogdamoy to langit aw pasak su konà no iyu no tu-un sikan su ingkudanan to Diyus to langit aw gi-okanan din to pasak. Konà now gayod ogdamayon to lunsud to Hirusalim, su sikan to sakupanan to Diyus no labow no Harì. ");
INSERT INTO did_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Agad kinabuhì now, konà kow ogdamoy to pag-amaa su konà kow ogpakabo-ot sikan su agad songo soag dà to bubuu now, konà kow ogpakapaputì dow ogpakapa-itom su Diyus dà to ogka-amu. ");
INSERT INTO did_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Iyan dà ogka-ikagi now to ‘Ho-o’ dow ‘Konà,’ su ko madugangan now pad sikan, oglikat on diyà ki Satanas. ");
INSERT INTO did_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Na, nadinog now gayod to sugù no ingkabogoy no pig-iling to ‘Ko malugit to ikow no mata to duma, ogkalugit nu iyan gayod to kandin mata. Ko malagpu-an ka to ngipon to duma nu no otow, ogkalagpu-an nu iyan gayod to kandin ngipon.’ ");
INSERT INTO did_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Dì so-idi to kagi ku iyu. Konà now ogbaosan ko moydu-on oghimu to mado-ot du-on iyu. Ko ogdagpangon kow to dibauy, ipalibang now mandà to dibauy. ");
INSERT INTO did_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","To otow no ogpa-atubang iyu aw ogpabayadon kow hantod to agad ilisan now no kabò, ogtugutan now gayod to ogpudut agad iyanon no kabò. ");
INSERT INTO did_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ko ogpakalogahon ka to sundau kotob to songo kilumitru, dugangi now nasì daahi to songo kilumitru pad. ");
INSERT INTO did_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ko moydu-on ogpangamuyù iyu, ogbogayan now. Ko moydu-on ogboos diyà iyu, paboosa now, aya kow balibad. ");
INSERT INTO did_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“In-anad on iyu no pig-iling to ‘Ogka-atan now to kadumahan now dì ogkablangon now to kablang now.’ ");
INSERT INTO did_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Dì so-idi to kagi ku iyu. Ogka-atan now gayod to mgo kablang now. I-ampù now nasì kandan to Diyus agad napahadatan kow dan ");
INSERT INTO did_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","awos maka-angod kow to Amoy now diyà to langit, su ogpatang-awan tibò kinow to Diyus to soga agad madoyow aw mado-ot. Ogpa-inudanan gayod to Diyus to tanom now, agad matinumanon kow to kasugu-an din dow konà. ");
INSERT INTO did_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ko iyan dà ogka-atan now to ogka-at iyu, amonuhon to pagka-uyun iyu to Diyus, su agad mgo wadà tu-u to katahanan ta, ogtumanon dan dà kan, agad mgo magsusukut to buhis. ");
INSERT INTO did_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ko iyan dà og-abayon now ogdinuguk-digukon to nahinanaaman now tahan, wadà kalabow to paghimu now du-on to paghimu to mgo otow no wadà tu-u to Diyus. ");
INSERT INTO did_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Pakatuwadong kow no angod to katuwadong to iyu no Amoy diyà to langit.” ");
INSERT INTO did_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Na nig-aboy si Jesus to pagpangudlin din no nig-ikagi kandin to “Dowdoyow kow ko puli kow ogpa-ahà-ahà to pagtuman now to tumanonon to tinu-uhan now awos ogkasayà-sayà kow to otow. Matuu konà kow ogkabaosan to madoyow to Diyus no Amoy now diyà to langit to mahudi no adow. ");
INSERT INTO did_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Kaling man ko bumulig kow to nawada-an no otow, konà now oglisagan to kadumahan now to gimbaa awos mangkahimun aw mamakakita pad to paghimu now aw kasayà kow dan su sikan to oghimuhon to otow no mapakunon-kunonon diyà to kahimunanan aw diyà to mgo hibaakan to daan awos ogkasayà kandan. Dì so-idi to kagi ku iyu. Iyan dà ogkadawat dan to pagsayà to otow. ");
INSERT INTO did_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Dì iyu, ko bumulig kow to duma, konà now ogka-iman to og-indanan kow agad ma-intok. ");
INSERT INTO did_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Agad mahobong to pagbulig now, dì ogkakita-an dà to Diyus aw ogbaosan din to mahudi no adow. ");
INSERT INTO did_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“To mgo mapakunon-kunonon no otow, ogkaliyag to ogpanawag-tawag to Diyus diyà to kahimunanan aw diyà to mgo hibaakan to daan su awos ogkakita-an kandan to mgo otow. Konà now ogsunudon kandan. Iyan dà ogkadawat dan to pag-indan to otow. ");
INSERT INTO did_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Dì iyu, agad sobu-ukon now dì ogpaka-ampù kow su ogkakita-an kow to Diyus aw ogkabaosan kow. ");
INSERT INTO did_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ko og-ampù ki to Diyus, konà ta puli og-abayon ogsinudsudon to paglituk angod to mgo otow no bugtì to tinu-uhan su intobo-ot dan dow ogkadinog kandan to Diyus ko oghaba-on dan to pagpanawag-tawag. ");
INSERT INTO did_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Konà now ogsunudon kandan su nama-anan tahan to Diyus no Amoy ta dow nokoy to kapookanan ta to konà ki pad ogpangamuyù diyà kandin. ");
INSERT INTO did_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Iyu no mgo sakup ku, ko og-ampù kow to Diyus, og-angodon now so-idi no paglituk no, ‘Amoy noy no diyà to langit, matahudan podon to ngadan nu. ");
INSERT INTO did_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Umabut podon to pagsakup nu dini to kalibutan. Matuman podon to pagbo-ot nu dini to kalibutan no angod dà kunto-on no natuman on diyà to langit. ");
INSERT INTO did_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Bogayi koy nu podon kunto-on no adow to kapookanan noy no ogkako-on noy. ");
INSERT INTO did_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ogpasayluhon koy nu to saà noy ikow su pigpasaylu noy on to nakasaà dini kanami. ");
INSERT INTO did_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Og-aha-on koy nu dow wadà buwa dini kanami no igkahimu ni Satanas no pa-antihan. Dì pagawangon nu nasì si Satanas dini kanami.’ “Na og-angodon now sikan no pag-ampù. ");
INSERT INTO did_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ko pasayluhon now to duma to saà dan diyà iyu, Diyus gayod no Amoy ta diyà to langit, ogpasayluhon din man gayod to saà now diyà kandin. ");
INSERT INTO did_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Dì ko konà now ogpasayluhon to saà dan diyà iyu, konà gayod ogpasayluhon to Diyus to iyu no saà diyà kandin. ");
INSERT INTO did_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ko ogpu-asa kow, konà kow puli ogpa-ahà-ahà to ka-otawan su to mgo otow no mangkapakunon-kunonon, puli dan ogtagonan to ig-okod awos ogkakita-an kandan to ka-otawan. Dì iyan dà ogkadawat dan to pag-indan to mgo otow. Dì konà man ogka-indanan to Diyus. ");
INSERT INTO did_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Iyu, ko ogtagonan now on to pu-asa, ogpadigus kow aw panapid-tapid to bubuu agad-agad to ingkatahan now ");
INSERT INTO did_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","awos konà ma-indanan to pagtagon now to iyu ing-okod. Dì to Diyus, agad mahobong, ogka-indanan din aw ogkabaosan kow din to mahudi no adow. ");
INSERT INTO did_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Konà now oghimunon to kadatù now aw ibotang dini to kalibutan su ogkakotkot to uwod-uwod aw kalingi. Kawatan gayod, ogpanggapi-on to mgo takop to baoy aw ogkapudut to kadatù now. ");
INSERT INTO did_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Dì diyà now to ibotang to kadatù now to langit su konà ogkasoodan to kawatan. Konà gayod ogkotkoton to uwod-uwod aw konà ogkalingan. ");
INSERT INTO did_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Agad ando-i ta ibotang to linogonan ta, du-on dà gayod to domdom ta. Kaling man ogpakabotang ki to linogonan to diyà to langit. ");
INSERT INTO did_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Na, to mata ta, iyan na-angodan to ilawan to lawa ta. Ko wadà ogpakasalibon, ogkatang-awan man to lawa ta tibò. ");
INSERT INTO did_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Dì ko moydu-on ogpakasalibon no mado-ot no domdom now, ogkadigloman gayod to lawa now tibò. Ko wadà makada-og to ilawan now to kadigloman, wadad ogka-angodan to kadiglom su angay pisok kow on. ");
INSERT INTO did_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Na to otow, konà no ogkahimu no daduwa to pigtagonan din su kan sobu-uk, ogkablangon din aw kan sobu-uk, iyan on ogpa-aag-aagon din. Matinumanon gayod kandin diyà to sobu-uk, matuu kan sobu-uk, og-oyowan su nigsabaag on to pagdomdom. Konà ta ogpagtokapon to pagtagon ta, Diyus aw kadatù. ");
INSERT INTO did_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Kaling man konà now ogkapook-pookan to kabotang now dow nokoy to ogkako-on now aw ogka-inom, aw ogkapangabò now su to kinabuhì ta, labow pad du-on to ogkako-on ta. Aw lawa ta gayod, labow pad du-on to ogkapangabò ta. Mano pigbogayan ki to Diyus to kinabuhì ta aw lawa ta gayod, angod dà ogbogayan ki din gayod to kapookanan ta tibò. ");
INSERT INTO did_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ko pananglitan, to mgo manuk-manuk, konà og-odok aw konà gayod og-ani. Konà gayod oghimunon to tipaoy aw ibotang diyà to kubkub. Dì ogbogayan dà gayod to Diyus no Amoy ta diyà to langit to ogkako-on dan. Dì labow kow pad iyan du-on kandan no manuk-manuk. ");
INSERT INTO did_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Agad kanunoy now mapook-pookan bahin to igkabuhì now, dì konà no sikan to ogpakapagsugpat to kinabuhì now agad songo lumpù dà. ");
INSERT INTO did_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Nokoy man no ogkapook-pook kow to ogkapangabò now. Ogdomdoman now to pagtulin to mgo bulak-bulak no puli oggitì. Ogkabuhì man kandan. Konà podon ogka-amu kandan to ogtalabahu, agad pad pagtingkaa. ");
INSERT INTO did_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ogkanangon ku iyu to agad si Harì Solomon no dadatu-on, dì wadà kabò din no ogpaka-angod sikan mgo bulak-bulak bahin to kinalabawan no og-aha-on. ");
INSERT INTO did_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Diyus to nigdaa to puli ogpanggitì no mgo bulak-bulak no ogtuga dì to sunù no adow sangabonon on. Woynu pad ogdaahon kow din aw bogayi kow din to ogkapangabò now. Tùtu-u to ma-intok iyan to pagtu-u now to Diyus! ");
INSERT INTO did_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Mano pigbantayan to Diyus to manuk-manuk aw mgo kabagnotan, konà now ogkapook-pookan to iyu no kabotang su ogbantayan kow din gayod. Konà kow gayod ogkasukun no og-iling to ‘Amonu kid on to ogkako-on ta aw ogka-inom ta,’ aw ‘Amonu kid on to ogkapangabò ta!’ ");
INSERT INTO did_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Su angod sikan to pagkangkapook-pook to mgo otow no bugtì to pigsaligan dan no konà no Diyus. Dì Diyus no Amoy ta diyà to langit, ogkakita-an din tibò dow nokoy to iyu no nawadà. ");
INSERT INTO did_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Dì ko ogpa-aag-aagon now nasì to pagsakup to Diyus iyu aw to igpatuman din, ogkabogayan kow gayod to Diyus to iyu no ogkapookan. ");
INSERT INTO did_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kaling man konà kow ogminapook-pook to og-abut iyu to kasoom su to kunto-on no adow hustu dà man to ita no ogka-atubangan.” ");
INSERT INTO did_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Na sinugpatan ni Jesus to impang-anad aw panoysoy kandin bahin to pagbino-otay to otow to saà. Nig-iling kandin to “Konà now ogbino-ot-bo-otan to saà to duma now awos konà kow ogkabo-otan to Diyus to saà now, ");
INSERT INTO did_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","su ogkabo-otan kow din agad-agad to pagbo-ot now to duma. Ogpagsokodon din to mgo igkangkabo-ot su sikan kotob to igkabogoy now, sikan dà to ogka-ontopan to ogkadawat now gayod. ");
INSERT INTO did_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Nokoy man no og-aha-on now to puling to mata to duma now dì wadà now on nasì bati-a to batang du-on to iyu no mata. ");
INSERT INTO did_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nokoy man no og-iling kow to ‘Su-un, ogkuhiton ku to puling nu.’ Matuu to iyu no mata moydu-on man batang gayod. ");
INSERT INTO did_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Iyu no mapakunon-kunonon no mgo otwo, tugdow oggawangan now to batang diyà to iyu no mata. Kayan ogpakakita kow to pagkuhit to puling diyà to mata to duma now. ");
INSERT INTO did_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Konà kow og-anti ogtubung to idù no langog su puli man ogbaliskadon to tutubung aw iyu on nasì to ogpanginmumungutan ogkagaton. Konà kow gayod og-anti ogtubung to kadlaganon su dagow madagilasan dà puli to tutubung aw iyu nasì to og-dugma-on aw sigboa. ");
INSERT INTO did_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“To ogpangamuyu-on now diyà to Diyus, igbogoy man iuy. To ogpanganapon now, ogkakita-an now man. To ogsabi diyà to Diyus no awos makaponhik, ogkapasood iyan kandin to pigsakupan to Diyus ");
INSERT INTO did_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","su to ogpangamuyù, ogpakadawat man. To ogpanganap, ogpakakita man. To ogsabi no awos makaponhik, ogkapasood man. ");
INSERT INTO did_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Wadà buwa iyu ko ogpangamuyu-an to batà din to ko-onon dì iyan on igbogoy to batu. ");
INSERT INTO did_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Wadà gayod ogbogoy to uwod diyà to batà din no isdà to pigpangamuyù din. ");
INSERT INTO did_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Iyu, agad wadà pad ka-usab to ginhawahan now, dì ka-amu kow on ogbogoy to kadoyawan diyà to mgo batà now. Labi pad man to Diyus no Amoy diyà to langit, igbogoy din iyu to panalangin ko ogpangamuyù kow kandin. ");
INSERT INTO did_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Na ogpagpadihuhon now to pagbulig now diyà to duma aw sikan pagbulig no ogpangamuyu-on now su sikan to mgo kalitukan to impang-anad ni Moises aw duma no mgo maglilikwaday to Diyus natodu-on. ");
INSERT INTO did_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","“Ogpakali-ot kow to malig-ot no paslangan no soodanan to daan no igkatutuu diyà to Diyus agad malisod su ogkabogayan kow din man to kinabuhì no konad ogkawadà, dì konà iyan no mahan-ing to ogpakatutuu. Dì lagboy iyan to kahan-ing no ogpakatutuu to maow-ag no daan no igkatutuu diyà to kado-otan. ");
INSERT INTO did_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Dowdoyow kow kan mgo ogpang-anad to konà no tùtu-u no ogpakunon-kunon to kandan, angod to buhì no ma-aam dì matuu mamang man iyan kandan. Puli ogbalatakon to pagtu-u now. ");
INSERT INTO did_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Dì to hininang kan no otow to igkakilaa ta kandan dow madoyow dow mado-ot su bagnot dà puli, konà ogbogas to ogkako-on. Bayabas aw mangga, konà oglikat to kadudugihan. ");
INSERT INTO did_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ko matabà to tanom ta, ogbogas to madoyow. Dì ko magasà, konà ogbogas to madoyow. ");
INSERT INTO did_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","To matabà no tanom, konà ogbogas to mado-ot. To magasà, konà gayod ogbogas to madoyow. ");
INSERT INTO did_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","To tanom no ogbogas to mado-ot, oggawangon ta aw sangaba ta su to nigpasakup to konà no tùtu-u, mado-ot to ogkadoogan. ");
INSERT INTO did_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ogkakilaa ta to mgo tanom ko du-on to bogas dan to og-aha-an. To mgo gau-on no ogpang-anad, madaas dow maugoy mado-ot to ogpakalikat du-on kandan. Kaling man ogkakilahan kandan no mado-ot no ogpang-anad.” ");
INSERT INTO did_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Na nig-aboy si Jesus to pagpang-anad din no nig-iling to “Moydu-on mgo otow no ogtawag kanak no og-iling to ‘Magbobo-ot ku, Magbobo-ot ku.’ Di konà no tibò no og-ikagi sikan to ogpakasood to pigsakupan to Diyus diyà to langit. Iyan dà ogpakasood to otow no ogtuman to pagbo-ot to Diyus no Amoy ku diyà to langit. ");
INSERT INTO did_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","To mahudi no adow no paggawang to mapakunon-kunonon no otow, mahan-ing no og-iling to ‘Dì Magbobo-ot, nigpangudlin koy iyan no niggamit koy to ikow no ngadan. Agad mgo busow, nagawang noy no niggamit koy to ikow no ngadan. Iyan pighimu noy mandà no kaboonganan likat to kabogbogan nu no pigdaa noy su piggamit noy to ikow ngadan.’ ");
INSERT INTO did_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Dì ogtabakon ku iyu to ‘Wadà kalabotan ku iyu no dakoo to saà. Gawang kow on!’ ");
INSERT INTO did_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“To otow no ogpaminog to kagi ku aw tumana din, iyan ogka-angodan din to mapandoy no maghihimu to baoy. Ogdaomon din to pagkali kotob no iyan ogkapanggadan to batu su du-on din on ogpa-ukdangon to baoy. ");
INSERT INTO did_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Na nig-udan to mabogbog aw sigoy to wohig no malakas aw masaplangan to baoy to sigoy aw kasabod to kamag no mabogbog, dì wadà kapood su batu man to pina-ukdangan to baoy. ");
INSERT INTO did_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Dì nokoy to ogkadoogan to otow no ogpaminog to kagi ku dì konà ogtumanon. Iyan ogka-angodan din to buguk no otow no paok puli to pigpa-ukdangan din to kandin baoy. ");
INSERT INTO did_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Pag-udan to mabogbog aw kan baoy, ogsabodon to kamag aw kasaplangi to sigoy aw ogkapood, wadà ogka-angodan to pagkawagkas to baoy!” ");
INSERT INTO did_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Pagpang-anad ni Jesus du-on nangkaboong-boong to ka-otawan to kandin pagpabayà to pagpang-anad din ");
INSERT INTO did_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","su konà ogpaka-angod to pagpabayà to pagpang-anad to mgo mag-a-anad to tinu-uhan, su si Jesus, moydu-on kabogbogan no intapik du-on kan kandin no pagpang-anad. ");
INSERT INTO did_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Na nigpatugpù kandan si Jesus likat du-on to untud no pigpang-anadan din no naluyudan dà kandin kanunoy to kahan-ingan no ka-otawan. ");
INSERT INTO did_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Na moydu-on otow no pig-ibung, no pagkita din ki Jesus, nigduguk kandin aw luhud aw ikagi to “Sir, ko pagbo-ot nu to ogka-uli-an a nu, ogka-uli-an a dà man aw kalinisi a.” ");
INSERT INTO did_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Dayun pigdampon ni Jesus to otow no pig-ibung aw tinakin ikagi kandin to “Ogbo-otan ku man. Na, ka-uli-i kad on aw kalinisi kad on.” Na-uli-an on dayun to sakit to otow no ibung aw kalinisi on to lawa din. ");
INSERT INTO did_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Na pigbahog lagboy ni Jesus to “Lagi, konà nu na-ay igpannawnangonon to kanak to naka-ulì to ikow no sakit. Dì nasì patidow ka diyà ton ogtubus ikow diyà to atubangan to Diyus aw ipakita kandin to sakit nu no na-uli-an on. Bogoy ka kandin agad-agad to insugù ni Moises no buhì no pagmatu-ud to pagka-uli-i nu kan sakit nu awos matu-uhan to ka-otawan.” ");
INSERT INTO did_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Dayun nigpadayong kandan si Jesus diyà to Kapirna-um no lunsud. Pagdatong dan du-on pigsungun kandan to kapitan to sundau no taga-Ruma. Nigduguk kandin ki Jesus ");
INSERT INTO did_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","aw ikagi to “Sir, moydu-on sugu-onon ku no mamonang on puli diyà to hibatanan din no konà ogpakahisù aw kanunoy on nalisodan.” ");
INSERT INTO did_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Nig-ikagi si Jesus to “Ogduma a ikow aw makadoyow a kandin.” ");
INSERT INTO did_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Nig-iling kan sundau to “Sir, ogpasandog a ikow dì konà a ogpakapa-andiyà ikow to kanak baoy su konà a no litos no og-abutan nu su labow ka pad kanak. Dì igatang moydu-on malituk nu no kagi no ogpaka-ulì to sakit to sugu-onon ku. ");
INSERT INTO did_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ogkilahon ku no ikow no otow no magbobo-ot. Kanak gayod nasakup ad to mata-as ku aw mata-as ku, imbotang a din no kapitan to mgo sundau. Ko ogsugu-on ku to sobu-uk no sundau ku to ogpa-andiya-on, ogpakatuman dà man. Ko ogsugu-on ku to ogpa-andinihon, ogpakatuman gayod. Ko osugu-on ku to batà-batà ku, ogpakatuman man tibò.” ");
INSERT INTO did_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Pagkadinog ni Jesus to pig-ikagi to kapitan to mgo sundau no taga-Ruma, naboong-boong kandin. Naka-ikagi kandin diyà to mgo duma din to “Agad ando-i dini to ka-Isrilihan wadà a aligbat makakita to pagtagon no angod to pagtagon sikan no otow no konà man podon no Isrili kandin. ");
INSERT INTO did_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Konà now ogkalingawan to kagi ku diyà iyu su to mahudi no adow iyan ogmutmutan to kahan-ingan no nakalogob to binogdokan to langit no ogpagsau to pagko-on ni Abraham aw ni Isaac aw ni Jacob no minuna ta diyà to pigsakupan to Diyus. ");
INSERT INTO did_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Dì mahan-ing podon no kasinugpu-an dan no ogkalabot dà to pigsakupan to Diyus dì ogpagawangon dà nasì diyà to labas no diyà to kadigloman kandan aw oog to pagka-aang-aangi dan aw pangagot to bag-ang to pagkangkasakiti dan.” ");
INSERT INTO did_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Dayun niglingì si Jesus diyà kan sundau aw ikagi, “Na, ulì kad on su natuman on to pigpangamuyù nu su nigtu-u ka man kanak.” Kandà no uras na-uli-an to sugu-onon to sundau. ");
INSERT INTO did_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Na nigponhik kandan si Jesus diyà to baoy ni Pedro. Pagkasapat dan nakita-an dan to ugangan ni Pedro no buyag no nakahibat-hibat no nasakit no mapasù to lawa. ");
INSERT INTO did_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Dayun pigduguk ni Jesus to buyag aw dawata to boad din. Du-on na-uli-an dayun to buyag. Nigbangun kandin aw pang-alagà to mgo bisita. ");
INSERT INTO did_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Pagkahapun, pigpandaa to mgo otow no nangkasakit diyà ki Jesus aw mgo otow no pigpansoodan to busow. Nangkagawang din to busow no malituk din to kagi aw kangka-uli-i din tibò. ");
INSERT INTO did_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Napugut on sikan tibò su awos matuman to intag-an ni Isaias no maglilikwaday to Diyus no lagsoban natodu-on no pig-iling to “Itanow, pigpanggawangan din to mgo sakit aw mgo kagobloy to lawa su nigtubus man kandin ita.” ");
INSERT INTO did_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Na songo kahapunan nakakita si Jesus to ka-otawan no nangkahimun diyà to boyboy to dagat. Nigpadapit kandin to bautu no talipagay diyà dihipag to dagat. ");
INSERT INTO did_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Monang nakatalipag si Jesus no pigduguk pad kandin to songo mag-a-anad to tinu-uhan to mgo Hudiyu aw ikagi kandin to “Sir, agad ando-i ka dumoog, ogsigi a ogduma ikow.” ");
INSERT INTO did_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Nig-ikagi si Jesus to “Agad mgo katuyù, dì moydu-on dà bullug dan ugpa-anan no ogkalukuhan aw mgo manuk-manuk, moydu-on dà gayod bullug dan ugpa-anan no ogkahapunan. Dì kanak no Tumutubus to Ka-otawan, agad ando-i a to makasigkon.” ");
INSERT INTO did_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Na to duma no sakup ni Jesus nig-iling to “Sir, oglobong koy pad na-ay to amoy noy. Kayan pana ogduma ad ikow.” ");
INSERT INTO did_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Dì nig-iling si Jesus to “To mgo duma nu no wadà tu-u no puli on bunwanon, oghimuhon nu nasì kandan no bunwanon nu to patoy now. Dì ikow, duma kad kanak.” ");
INSERT INTO did_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Dayun namanluwan kandan aw si Jesus to bautu no tatalipagay to dagat. Pagluwan dan dayun niglikat on kandan aw pamanlayag to dagat. ");
INSERT INTO did_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","No pagpanongà-tongà dan on to dagat tinakin nigsabod to kamag no mabogbog no nigkumus du-on to sakayan. Magabubungan gayod to baod to dagat no ogkalukut-lukut aw katinagu-i pad to sakayan to wohig. Dì nalimogtokan si Jesus no nalipodong. ");
INSERT INTO did_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Dayun pig-andu-onan dan si Jesus aw pukawa to mgo pangabaga din aw mamaka-ikagi to “Sir, gimata kad aw bulig kad! Kamuwahanan tad on buwa so-idi no nig-abut!” ");
INSERT INTO did_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Nakatabak si Jesus to “Nokoy man no ogkangkahadok kow. Ma-intok pad to pagsalig now kanak.” Du-on nigbangun si Jesus aw sapadi din to kamag aw baod no nigpamawbakuud no ogkalukut-lukut. Dayun nighagtong to kamag aw ampan pad pangidù-kidù to dagat. ");
INSERT INTO did_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Naboong-boong lagboy to mgo pangabaga ni Jesus. Nigka-inusipay kandan to “Intawa nò buwa so-idi no otow su ogpakatuman dà to kamag aw baod to dagat ko ogsugu-an din.” ");
INSERT INTO did_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Na nigdatong mandà kandan si Jesus diyà to dihipag to dagat no banwa no pighingadanan to Gadada. Paghaw-as dan pigsungun kandan to daduwa no ka-otow no pigsoodan to busow no naugoy on to pagka-ugpà dan diyà to lobonganan. Wadà ogpakadani sikan no mgo otow su lagboy to kabuut sikan no mgo langog. ");
INSERT INTO did_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Pagkakita to mgo langog ki Jesus, namakapanguy-lahuy to “Ikow no Anak to Diyus, wadà kalabotan nu kanami. Nokoy to ogtu-udon nu! Dow ogpahadatan koy nu buwa to konà pad no ogkagotò to adow?” ");
INSERT INTO did_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Na moydu-on panon to babuy no namandungaa diyà to augan no madani dà. ");
INSERT INTO did_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nangamuyù lagboy sikan mgo busow diyà ki Jesus no nig-iling to “Ko gawangon koy nu, igatang tuguti koy podon to ogpasoodon koy nu du-on sikan mgo babuy.” ");
INSERT INTO did_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Nig-ikagi si Jesus to “Na, ogkahimù man.” Dayun namakagawang to mgo busow du-on sikan pigsoodan dan no mgo otow aw pamatisood kandan diyà to ginhawahan to mgo babuy aw tinakin pamanlaguy tibò to tipanonan du-on to augan aw pamampatidaplus tibò diyà to dagat aw kangkaonod. ");
INSERT INTO did_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Dayun namanlaguy to mgo otow no nigbantoy to mgo babuy aw pamang-ulì diyà to kandan lunsud aw namannawnangonon kandan to nadoogan kan daduwa no ka-otow no pigpansoodan to busow. ");
INSERT INTO did_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Pagkadinog to mgo taga-lunsud, namang-andiyà kandan ki Jesus no diyà to kahilitan no banwa. Pagkakita dan aw pagkataga dan on to nadoogan, nangamuyù kandan diyà ki Jesus to kaliyag to ogpagawangon on kandin du-on to kandan no banwa. ");
INSERT INTO did_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Kaling man nigluwan kandan si Jesus to sakayan aw talipag to dagat no nig-ulì diyà to kandan no lunsud no Kapirna-um. ");
INSERT INTO did_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Pagdatong dan, dinaa diyà ki Jesus to pulid no otow no piglahung. Pagsabut ni Jesus to insalig dan lagboy du-on kandin to ogkadoyow din to pulid no otow, nig-ikagi kandin to “Lagi, padaoyagad to ginhawa nu su pigpasaylu kud on to mgo saà nu.” ");
INSERT INTO did_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Dì moydu-on mgo mag-a-anad to tinu-uhan to mgo Hudiyu no nakadinog to kagi ni Jesus. Pig-iling dan diyà to domdom dan to “Nokoy man no otawa sikan su niglangub nig-ikagi to angod sikan. Napa-inahan din on to Diyus to na-ikagi din su nigpagsokod kandin podon to Diyus su kunon kun kandin to ogpakapasaylu to saà to otow. Dì matuu Diyus dà man iyan tahan to nataga to ogpakapasaylu to saà to otow.” ");
INSERT INTO did_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Dì tahan dà nama-anan ni Jesus to mgo domdom dan. Nig-ikagi kandin to “Nokoy man no iniling now to domdom now. ");
INSERT INTO did_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Mahawoy dà to pagpasaylu to saà to pulid no otow. Dì malisod to pagtambaa to pulid no otow aw malisod gayod to ogpahipanawon. ");
INSERT INTO did_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Mangkuwan ig-ikagi ku diyà to pulid awos mataga kow to kanak no Tumutubus to Ka-otawan, nabogayan a to kabogbogan to ogpakapasaylu a to tibò to saà to mgo otow dini to babow to kalibutan.” Nigsunglà kandin du-on to pulid aw ikagihi to “Lagi, bangun kad aw sakindog kad on aw lukuta to hikam nu aw ulì kad.” ");
INSERT INTO did_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Dayun nigbangun aw ulì diyà kandin. ");
INSERT INTO did_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nangkaboong-boong kan mgo ka-otawan aw sayà-saya-a dan to Diyus su nigbogoy kandin diyà to otow to kabogbogan to ogpakadoyow to sakit aw ogpakapasaylu kandin to saà. ");
INSERT INTO did_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Na nighipanow on si Jesus. Pagkabayà din to sukutanan to buhis, nakita-an din to otow no nig-ingkud no pighingadanan ki Mateo. Pig-ikagihan ni Jesus to “Lagi, kunto-on duma kad on kanak.” Dayun nigsakindog kandin aw duma ki Jesus. ");
INSERT INTO did_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Na pigbana-an ni Mateo kandan si Jesus diyà to baoy din. Nakaba-ot to mahan-ing no magsusukut to buhis no duma ni Mateo aw duma gayod no mgo otow no wadà tu-u to mgo katahanan to mgo Hudiyu. ");
INSERT INTO did_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Dì to mgo Parisiyu no nigtagon lagboy to kandan katahanan, nakita-an dan to nigpagdongan si Jesus to pagko-on kan mgo otow no wadà tu-u to kandan katahanan. Namang-usip kandan diyà to mgo pangabaga ni Jesus to “Nokoy man no ogpagdongan to mag-a-anad now to pagko-on to mgo magsusukut to buhis aw duma pad no wadà tu-u to katahanan ta.” ");
INSERT INTO did_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Dì nakadinog dà si Jesus to usip dan aw ipananglitan din no pig-iling to “To otow no konà og-abin to kandin sakit, konà ogpagawang to ogtambaa. Dì to otow no og-abin to nasakit kandin, kandin iyan to ogpagawang to ogtambaa to sakit din. ");
INSERT INTO did_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Na iyu no puli matagon-tagonon no otow to katahanan, ogpangindaagan now to kalitukan so-idi no kagi to Diyus no pig-iling to ‘Ogpa-aag-aagon ku pad to pagka-at now to kasing-otow now du-on to pagsundù now nasì dini kanak to buhì.’ Angod dà sikan to ingka-andini ku to babow to kalibutan su ogbulig a to mgo otow no ogkaliyag ogpagawang to saà dan. Dì konà no iyan tu-ud ku to ogbulig kan mgo otow no puli matagon-tagonon to katahanan dì konà ogpagawang to saà.” ");
INSERT INTO did_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Na dayun nigdatong du-on to mgo sakup ni Juan no Magbobonyagay. Nig-ikagi kandan du-on ki Jesus to “Na kanami aw sikan mgo sakup to mgo Parisiyu, ogtagonan noy to katahanan ta no pu-asa. Nokoy man no konà nu ogpatagonan sikan to ikow no mgo sakup.” ");
INSERT INTO did_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Impananglitan ni Jesus no nig-iling to “Ogpako-onon pad to mgo bumaba-ot to pagsauhan ko du-on pad to bana no bayà hitu-un! Dì ko mali-us on, konad ogko-on aw ooga dan su nali-us on. Moydu-on kagoto-an no adow no pagpahipanow to bana no bayà hitu-un. Kayan ogpamampu-asa to mgo bumaba-ot.” ");
INSERT INTO did_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Na impananglitan mandà ni Jesus bahin to bayà no impang-anad din aw kan tahan no pagpang-anad to mgo Parisiyu no wadà hidaag no pig-iling din to “Konà ta ogtapakan to tahan no kabò no nahigbit to tatapakay no wadà pad kadakdaki su ko tapakan ta aw dakdaki on, ogkokos to bayà no intapak. Pagkokos, oglisig on lagboy to nahigbitan to pigtapakan no tahan.” ");
INSERT INTO did_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nig-ikagi mandà si Jesus to “Konà ta ogpagsambuon to bayà no inomon aw tahan no inomon no pingaa. Dì ko ogpagsambuon ta to bayà aw kan tahan, mado-ot to ogkabauyan. Ogka-uwakan tibò, sikan bayà no inomon aw sikan tahan no inomon. Ogbugti-on ta to pagtagù awos wadà ogka-uwakan.” ");
INSERT INTO did_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Na diyà ta pad mandà to bugtì no tutuwanon. No nang-anad pad si Jesus to ka-otawan, naka-andu-on on to songo otow no punu-an to tinu-uhan no nigdaa to kahimunan to simbahan. Nigduguk kandin ki Jesus aw luhud. Nig-ikagi kandin to “To batà ku no dawdaga on, namatoy on kunto-on pad no adow. Dì agad namatoy on kandin, dì ogpadumahon ku dà ikow aw igpadampon ku awos buhayon nu kandin.” ");
INSERT INTO did_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Na kandan aw si Jesus, pigdumahan dan to otow no namatayan to batà. ");
INSERT INTO did_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","22","No diyà pad to pangindanan kandan, iyan nigsunduu kandin to buyag no moydu-on sakit no kanunoy piglabasan to langosa to sood on to sampuù tag duwa no tu-ig to pagkadawdaa din. Pigtuman din to pigginhawa din no pig-iling to “Domdom ku ko puli a makatudì to sagyad to kabò din ogka-uli-an ad on.” No pagkatudì din to sagyad to kabò ni Jesus, na-uli-an on kandin aw tigpok dayun to paglabas to langosa. Nakalingì si Jesus aw kakita-i din kan no buyag aw ikagi to “Konà ka ogkapook-pook Laginà, su na-uli-an kad on su nigsalig ka kanak to ogpakadoyow a ikow.” ");
INSERT INTO did_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Na og-uli-on tad mandà to tutuwanon to nigdaa to kahimunan to tinu-uhan. No pagdatong ni Jesus diyà to baoy no namatayan, lagboy to kaguub to patanugonon aw kuus pad to mgo ka-otawan aw otow pad no nigsasabog-sabog. ");
INSERT INTO did_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Nig-ikagi si Jesus to “Logwa-i now kani. Wadà kamatoy so-idi batà. Puli niglipodong.” Dì pigngingisihan si Jesus to mgo ka-otawan. ");
INSERT INTO did_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Dì paglogwà to ka-otawan, nigsood si Jesus to sinabong no pigkotangan to patoy aw duguka din aw dawata din to boad to batà. Dayun to nakabangun to batà. ");
INSERT INTO did_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Na sikan no nawnangonon, nigtangkap diyà to kalongodan to Kapirna-um no lunsud. ");
INSERT INTO did_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Dayun nighipanow on kandan si Jesus no pigsunduwan to daduwa no ka-otow no aag pisok. Nigtinawag kandan no nig-iling to “Ikow no sugpù ni Harì David, ka-ati koy nu ubag podon.” ");
INSERT INTO did_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Dì wadà paminog si Jesus. Pagponhik ni Jesus to baoy no pigtu-ud din, nakasunù dà kan daduwa no ka-otow no mgo pisok. Inusip ni Jesus kandan to “Dow nigtu-u kow to ogpakadoyow a to iyu no sakit?” Nakatabak kan mgopisok to “Ho-o iyan Sir, ogtu-u koy lagboy!” ");
INSERT INTO did_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Dayun pigtudì din to mgo mata dan aw ikagihi to “Magawangan kow to sakit now agad-agad to pagtu-u now.” ");
INSERT INTO did_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Dayun na-uli-an on to mata dan aw ogkita on. Pigbahog lagboy ni Jesus kandan to konà ogpatangkapon to napugut-pugutan. Kagi din to “Wadà otow no ogkanangonan now.” ");
INSERT INTO did_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Dì bali man no pigpatangkap dan to nawnangonon to napugut-pugutan hantod to nigtangkap to tibò nasakup du-on to Kapirna-um no lunsud. ");
INSERT INTO did_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","No ililikaton on podon kandan, pigsakpan kandan to otow no pigdaa du-on ki Jesus no pigsoodan to busow no makapopohà. ");
INSERT INTO did_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Dayun piggawangan ni Jesus aw maka-ikagi kan otow. Nangkaboong-boong to mgo ka-otawan aw ikagi to “Dini to ka-Isrilihan wadà aligbat kakita-i no angod so-idi.” ");
INSERT INTO did_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Dì naka-ikagi to mgo Parisiyu to “Ogpakagawang kandin to busow su nabogayan kandin to kabogbogan likat ki Satanas no punu-an to mgo busow.” ");
INSERT INTO did_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Na niglibod-libod kandan si Jesus to mgo lunsud aw sityu to pagpang-anad to ka-otawan diyà to mgo simbahan no nanoysoy kandin to Madoyow no Tutuwanon bahin to pagsakup to Diyus. Nangka-uli-an din kan mgo otow no moy nigsingkabugtì no mgo sakit aw mgo kagoblayon dan. ");
INSERT INTO did_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Pagkakita din to mgo ka-otawan, nigka-at kandin kandan su pig-abloy kandan aw nangkagobloy no iyan na-angodan dan to buhì no wadà nigbantoy. ");
INSERT INTO did_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Nig-ikagi kandin diyà to mgo pangabaga din to “Mahan-ing podon to ogpasakup to Diyus aw iyan ogka-angodan dan to humayan no maow-ag no madakoo podon to nig-abut no anihonon. Dì ma-intok dà to ogpaka-ani. ");
INSERT INTO did_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kaling man ogpangamuyù kow to Diyus no Amoy no tagtu-un to humayan to ogpadugangan pad to mgo mag-a-ani no ogpatabangon iyu diyà to anihonon.” ");
INSERT INTO did_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Na to mgo pangabaga ni Jesus no sampuù tag duwa, pigpaduguk din kandan aw himuha din kandan no tumutubus diyà to mgo Isrili. Pigbogayan din kandan to kabogbogan to ogpakagawang to mgo busow no nakasood to mgo otow aw ogpakagawang gayod kandan to mgo sakit no nigsingkabugtì. ");
INSERT INTO did_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Tugdow si Simon no pighingadanan gayod ki Pedro. To mgo ngadan to duma no tumutubus ni Jesus, si Andres no hadi ni Pedro, aw si Santiago no nigpatahadi aw si Juan no iyan amoy dan si Sibidiyu. ");
INSERT INTO did_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Nakasunù si Felipe, si Bartolome, si Tomas, si Mateo no magsusukut to buhis natodu-on, aw si Santiago no anak ni Alpiyu, si Tadeo gayod, ");
INSERT INTO did_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","si Simon no sakup natodu-on to panon to mapatubuk-tubukon to bandila, aw si Judas Iskariyuti no nigbaligyà ki Jesus diyà to kablang din. ");
INSERT INTO did_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Na dayun pigpapangudlin ni Jesus kan sampuù tag duwa no tumutubus din diyà to ka-Isrilihan no banwa. Pig-udlinan din tibò to “Kunto-on wadà pad labot now to ka-Samariyahan aw duma no mgo otow no nigsingkabugtì ");
INSERT INTO did_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","su iyan pad nasì ogpama-andiya-an ku iyu to kadumahan ta no kasinugpu-an ni Israel, su iyan na-angodan dan to buhì no nawagà-wagà. ");
INSERT INTO did_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ogpahipanawon ku iyu no ogpapasabuton ku to ka-otawan no og-ilingon now to ‘Inabutan kid on to pagsakup to Diyus.’ ");
INSERT INTO did_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ogkangkadoyow now gayod to mgo pigpang-ibung no otow aw duma pad no nangkasakit aw ogbuhayon now to nangkamatoy, aw ogpakagawang kow to mgo busow no nansood to otow. Dì konà now ogkapabayadan so-idi no kabogbogan no impamalogob ku imbogoy iyu. Konà now ogpabayadan gayod to pagbulig now to otow no igpabayà so-idi no kabogbogan. ");
INSERT INTO did_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Konà kow ogpanghimun to tingub no ogdaahon now to paghipanow now no angod to mgo buwawan aw sapì, agad songo dakò. ");
INSERT INTO did_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Konà kow gayod ogdaa to ogpakabogat iyu no balutan, ilisan, aw sapatus. Agad agos, konà, su tùtu-u to ikagihonon no pig-iling to ‘To mgo ogtalabahu, bayadanan kandan,’ su to ogtalabahu to Diyus, bogayanan gayod to mgo kapookanan dan. ");
INSERT INTO did_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ko dumatong kow diyà to songo lunsud dow sityu, aha-a now dow intawa to ogpagduma iyu aw sikan impang-anad now gayod. Du-on kow agpot. Konà kow on oghinalin to agpotan now. Bullug sobu-uk dà no baoy to ugpa-i now ko diyà kow on to songo banwa hantod to matapus now on. ");
INSERT INTO did_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ko ogponhik kow to songo baoy, ogbogayan now to katahudan aw iling kow to ‘Mapanalanginan to Diyus so-idi no baoy.’ ");
INSERT INTO did_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ko ogpagduma kandan iyu aw sikan impang-anad now, ogpapanalanginan now kandan to Diyus. Dì ko konà ogpagduma kandan iyu aw gayod sikan impang-anad now, agad on su ogpapa-uli-on now dà to panalangin. ");
INSERT INTO did_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ko konà kow dawaton diyà to songo lunsud dow songo baoy, labayi now du-on kandan. Ko lumikat kow, padpada to abug to kobong now no pagpakilaa now to wadà labot now du-on kandan. ");
INSERT INTO did_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Dì to adow to pagbo-ot to Diyus, aboy malisod pad to ogkadoogan to mgo otow no og-oyow iyu aw sikan iyu no impang-anad. Kakampà dà to nadoogan to mgo taga-Suduma aw mgo taga-Gumuda no na-ubus to logdog no likat to langit. ");
INSERT INTO did_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ogpatubuson ku iyu kunto-on to pagpangudlin to mgo otow no bugtì to mgo ginhawa su iyan ogka-angodan now to buhì no nalibongan on to mamang. Na kaling man, bahin to mado-ot, ogdowdoyow kow no ogpa-angod kow to kadlaganon to ka-idla, dì ogpa-angod kow gayod to limukon to ka-ungangon.” ");
INSERT INTO did_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Na nig-ikagi mandà si Jesus to “Dowdoyow kow su ogdakopon kow aw botang-botangi kow puli aw pa-atubanga kow diyà to punu-an aw ogbunaan kow gayod diyà to simbahan. ");
INSERT INTO did_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ogpa-atubangon kow diyà to ukum aw mgo harì bahin kanak. Dì bahin to pagtu-u now kanak, sikan to paghutoy now to ognangon kow to Madoyow no Tutuwanon diyà to ukum aw harì aw gayod duma pad no nigsingkabugtì no mgo otow no wadà pad tu-u. ");
INSERT INTO did_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ko pa-atubangon kow on aw pang-usip-usipa kow, konà kow ogkapook-pook dow nokoy to igkatabak now su to litos no igkatabak now no mgo kagi, igbogoy iyu to Ispiritu Santu no niglikat to Amoy now no tigka-un puli now ogkalituk no litos no igkatabak. ");
INSERT INTO did_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Konà no iyu to ogkalikatan kan no kagi no igkatabak ko konà no Ispiritu Santu to ogpalituk iyu to kagi. ");
INSERT INTO did_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“To mahudi no adow, agad su-un din dà dì igkabusuu igkahatod diyà to ukum aw pahimatayi. Agad amoy din dà dì igkabusuu igkahatod din gayod to batà din. To mgo batà, og-atu to amoy aw inoy aw pahimatayi. ");
INSERT INTO did_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","To ka-otawan, ogkablangon kow dan ugpat to kanak ngadan. Dì to oghogot to pagtu-u din kanak hantod to wadà katapusan, ogkalipwasan dà. ");
INSERT INTO did_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ko pahadatan kow diyà to songo lunsud, pamanlaguy kow on to bugtì no lunsud, aw konà now pad ogkalogob to kalunsudan tibò to mgo ka-Isrilihan ko ogdatong a dini no Tumutubus to Ka-otawan.” ");
INSERT INTO did_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Na nigsugpat si Jesus to pag-udlin din no pig-iling din to “Na to mgo ogpa-anad, konà ogpakapalabow-labow to nig-anad kandan. Sikan mgo sugu-onon mandà, konà ogpakapalabow du-on to amu dan. ");
INSERT INTO did_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Iyu no mgo sakup ku, konà now ogka-iman to igkatahud kow to ka-otawan su wadà a ikatahud. No pighingadanan a ki Bilsibul no tagtu-un to busow, lagboy on to pag-ina-ina to mgo sakup ku. ");
INSERT INTO did_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Dì konà kow ogminapook-pook su to nakahobong to mata ta kunto-on, ogkapayagan dà to mahudi no adow. Ko moydu-on ingkahobong, ogka-ukasan dà tibò. ");
INSERT INTO did_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","To innangon kud iyu kunto-on no itanow dà, sikan iyan to igkanangon now gayod diyà to ka-otawan. To impannangon ku iyu dini to pagtongopan, sikan on to igkanangon now diyà to kahan-ingan. ");
INSERT INTO did_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Konà kow ogminahadok to ogpakawadà to lawa ta. Dì iyan dà lagboy nasì kahadokanan ta tibò to Diyus su ko mabitas ki din, ogkawadà din iyan to lawa ta aw umagad ta gayod no wadà pagpatunga su kandin dà to ogka-amu to ogpakawadà to lawa ta aw umagad ta gayod su ogpa-andiya-on kow din to kastiguhanan to saà no impiyirnu. ");
INSERT INTO did_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Na ko pananglitan to daduwa ubag no manuk-manuk, agad konà ta podon ogkahimu no igkasodà to songo pagko-on ubag, dì wadà pinanà aw ka-uug no konà no na-indanan dà to Diyus aw kabo-oti din. ");
INSERT INTO did_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Dì iyu, nalogob to pag-indan to Diyus to kada songo soag to bubuu now ");
INSERT INTO did_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","aw iyu, pighimu to Diyus no labow kow pad diyà to manuk-manuk. Kaling man konà kow ogminapook-pook. ");
INSERT INTO did_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“To otow no ogmatu-ud diyà to atubangan to ka-otawan to kanak to tagsakup kandin, kandin, og-abinon ku gayod diyà to atubangan to Diyus no Amoy ta diyà to langit. ");
INSERT INTO did_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Dì to otow no ogtuy-ow kanak, kandin gayod, konà ku og-abinon diyà to atubangan to Diyus no Amoy ta diyà to langit. ");
INSERT INTO did_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Na-intobo-ot now buwa dow nig-andini a to pasak no puli a ogpanhusoy to ka-otawan aw panmatu-uda ku to kandan dà no katahanan. Dì konà su kanak to ogkahimu no oglikatan nasì to igkasamuk to katahanan su kanak to igkasusuwoy to mgo otow su katahanan to mgo otow, konà no sikan to piglikatan to kalinaw. ");
INSERT INTO did_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Agad pata-ugangan aw pata-anak, dì kanak to ogkahimu no ogkapakunan to igkasusuwoy dan. ");
INSERT INTO did_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","To mgo nasood to baoy, ogkakinablangay. ");
INSERT INTO did_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Na to otow no iyan ogpa-aag-aagon din to ginikanan din dì matuu dini kanak konà, kandin konà ku no sakuponon. To otow no ogpa-aag-aagon din to mgo batà din dini kanak, kandin gayod konà ku no sakuponon. ");
INSERT INTO did_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Kinurus now, no kalitukan to pagtuwa-ay now to kalisodan, ko umoyow kow tumi-ang sikan no kinurus now, konà ku iyu no sakuponon. ");
INSERT INTO did_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","To otow no og-adlis to kamatayon aw oglidung to pagtu-u din kanak awos madilinan to kamatayon, mayubì nasì to kamatayon to mahudi no adow. Dì to otow no ogkamatoy su pigtuman din to sugù ku, to mahudi no adow ogbuhayon aw tuusa. ");
INSERT INTO did_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“To otow no ogdawat iyu su sakup ku iyu, iyan ogka-angodan to pagdawat din kanak. Ko ogdawat kandin kanak, iyan ogka-angodan to pagdawat din gayod to nigpa-andini kanak. ");
INSERT INTO did_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","To otow no ogdawat to impang-anad to otow su kandin maglilikwaday to Diyus, ogkalabot man kandin gayod to madoyow no pagbaos du-on to maglilikwaday to Diyus to mahudi no adow. To otow no ogdawat to duma su matuwadong kan duma, ogkalabot gayod kan no otow to madoyow no baos to mahudi no adow. ");
INSERT INTO did_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","To otow no ogpa-inom dà ubag to duma su kandin, sakup ku, agad ma-intok, dì konad iyan ogkawada-an to baos no padatongon pad likat to Diyus.” ");
INSERT INTO did_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Pagkatapus ni Jesus to pangudlin to mgo pangabaga din no sampuù tag duwa, namanlibod-libod on mandà kandan si Jesus to mgo kalunsudan to mgo ka-Isrilihan to pagpang-anad dan aw pangudlin. ");
INSERT INTO did_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Na ton diyà pad si Juan no Magbobonyagay to pirisuhan, pig-abutan kandin to nawnangonon bahin to mgo hininang ni Jesu-Kristu no Imananan to Ka-otawan. Pigpa-andiyà ni Juan to mgo sakup din su igpa-usip din kandan ki Jesus ");
INSERT INTO did_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","no igpa-iling to “Dow ikow iyan to Imananan to Ka-otawan? Dow moydu-on duma no ogka-iman pad to ka-otawan no oglogwà.” ");
INSERT INTO did_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Pigtabak ni Jesus to inusip dan bahin kandin no iniling to “Na, pa-ulì kow diyà ki Juan aw tutuwani now kandin to nadinog now aw nakita-an now ");
INSERT INTO did_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","no nangka-uli-an kud on to mgo pig-ibung aw mgo pungkù, mgo bongoo, pisok, aw pigpambuhoy ku to nangkamatoy, aw to mgo mangkasagkop no kabotang, napasabut on to Madoyow no Tutuwanon. ");
INSERT INTO did_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","To otow no wadà ablayanan din to pagtu-u din dini kanak, ogkaliyag dà su kanunoy din ogtagadan to insahad to Diyus.” ");
INSERT INTO did_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Dayun naman-ulì on to mgo sakup ni Juan no namakagomò on to tugun ni Jesus. Pagkali-us dan nighutoy si Jesus to pagpanoysoy to ka-otawan bahin to katondanan ni Juan. Nig-iling kandin to “Nokoy to naduguk now natodu-on ton pag-andiyà now to banwa no kahanongan. Nokoy to pig-ahà now du-on. Dow kandà mgo kugun no ogkabaguyun no ogsabodon to kamag? Dì konà. ");
INSERT INTO did_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nokoy to pig-andu-onan now aw aha-a, dow otow no nangabò to mahal? Dì konà su to otow no nangabò to mahal aw wadà ogboongon, og-ugpà man diyà to ugpa-anan to datù. Konà og-ugpà diyà to kahanongan no banwa. ");
INSERT INTO did_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nokoy to pigduguk now du-on. Aw nokoy to napugut-pugutan du-on to kahanongan no banwa no naliyagan now no nasoodan now. Dow maglilikwaday to Diyus to pig-ahà now bali? Maglilikwaday man iyan no niglabow pad tibò, ");
INSERT INTO did_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","su kandin to napa-atubangan to intag-an to maglilikwaday no lagsoban to Diyus natodu-on su nighina-at kandin to igbayà to Imananan to Ka-otawan. Nasulat to maglilikwaday to kagi to Diyus no pig-iling to ‘Ahà ka su ogpa-unahan ku ikow to kanak maglilikwaday awos din mahina-at to igbayà nu.’ ");
INSERT INTO did_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Na ogdomdoman now on to kagi ku. Dini to babow to kalibutan wadà otow no oglabow pad ki Juan no Magbobonyagay no maglilikwaday gayod to Diyus no wadà pad abut to bayà no pagsakup to Diyus. Mangkuwan, to mahudi no adow, to kinasagkopan diyà to pigsakupan to Diyus, ogkalabawan pad man si Juan su ogka-usab to pigsakupan. ");
INSERT INTO did_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Likat to pagpangudlin ni Juan no Magbobonyagay hantod kunto-on, moydu-on nigpakalayas nigpakadangon podon to pagsakup to Diyus dini to babow to pasak agad-agad to kandan dà no napikiyan ");
INSERT INTO did_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","su nama-anan dan to ogkatuman to mahudi no adow to pagsakup to Diyus no natitibo-an to pagtag-an ni Moises aw duma pad no maglilikwaday no lagsoban to Diyus hantod to paglogwà ni Juan no Magbobonyagay. ");
INSERT INTO did_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Impanag-an to mgo maglilikwaday to ogpa-ulì iyan si Elias dini no ogpa-unahon to Imananan to Ka-otawan awos humina-at to igbayà din. Ko matu-uhan now, si Juan sikan iyan si Elias no pig-imanan ta to og-andini. ");
INSERT INTO did_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Na paminogan now lagboy iyan to pig-ikagi ku. ");
INSERT INTO did_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Dow nokoy buwa to igpananglitan ku to pagpasabut iyu to katahani so-idi mgo otow no mgo kadongan ku. Iyan ogka-angodan dan to mgo batà no nangkahimun diyà to dadaga-anan no ogpamansunud-sunud to pagsauhan kun no ogpamanghuhulindog kandan no og-iling to ");
INSERT INTO did_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nokoy man no wadà kow sayow su piglisagan noy man iyu.’ Iyan ogka-angodan dan gayod to mgo batà no ogpamansunud-sunud to ogpaman-oog to namatoy no og-iling to ‘Nokoy man no wadà kow sunud to pagdaugmatoy noy su pigdaugmatayan noy man iyu, dì wadà kow baos. Wadà iyan ingkangkaliyag now!’ Na iyu, iyan ogka-angodan now kan mgo batà to iyu no pagdawat aw pagsabut to pagpang-anad iyu, ");
INSERT INTO did_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","su si Juan no Magbobonyagay no niglogwà no nigpangudlin, dì wadà man ba-ot si Juan to pagko-onan aw inoman, aw puli now botang-botangi to kandin, pigsoodan to busow. ");
INSERT INTO did_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Dì kanak no Tumutubus to Ka-otawan, ogpagba-ot a man dì pighimu a now no ma-omot to ogko-on aw ogminahingow aw matiduguk diyà to mgo magsusukut to buhis aw duma pad no mgo wadà tu-u to katahanan now. Wadà iyan ingkangkaliyag now. Dì ogkakilaa ta iyan to ka-ugsoban to Diyus su pigpakatuman din to pagbo-ot din agad nigsingkabugtì no mgo otow, agad mapawpa-awayon iyan to og-ugpà aw matiduguk gayod no otow.” ");
INSERT INTO did_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Na nigpunù si Jesus to pagpambahog to ka-otawan diyà to kalunsudan no pigpanlibod-libodan din to pagpangudlin su wadà dan man sosoi aw oyowi to kandan katahanan no bugtì. ");
INSERT INTO did_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Nigbahog kandin to taga-Bitsayda aw taga-Kurasin no pig-iling to “Aboy iyu su mabogbog to kaboonganan no pighimu ku diyà iyu dì wadà kow tu-u aw wadà kow sosoo to pighimu now no mado-ot aw wadà now oyowi to katahanan now no bugtì. Dì to taga-Tiru aw to taga-Sidun nasì no mangkadakoo to saà natodu-on ogpakasosoo podon kandan to pighimu dan no mado-ot aw ka-oyowi dan podon to katahanan dan ko nakita-an dan podon to kaboonganan angod so-idi pighimu ku kani iyu kunto-on aw ogpangabò kandan podon to hanuut no ta-indanan to pagkasosoo dan to saà aw ka-oyowi aw budbudi dan gayod to abu to uu dan. ");
INSERT INTO did_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Kaling man to mahudi no adow no pagbo-ot to Diyus, malisod kow pad lagboy iyan kani. Kakampà dà nasì to nadoogan dan. ");
INSERT INTO did_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Aw iyu no mgo taga-Kapirna-um, nakalabow kow on diyà to langit, dì ogpaka-andiyà kow nasì to hinibatan to pasak. Sikan mgo taga-Suduma gayod, ko nakita-an dan pa podon no angod so-idi no kinita now on no kaboonganan, ogka-oyowan dan podon to katahanan dan aw sosoo aw wadà podon kagawang to kandan no lunsud dì tigbat pad podon kunto-on. ");
INSERT INTO did_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Kakampà dà to kandan nadoogan. Malisod-lisod pad to pagbo-ot iyu to Diyus to mahudi no adow.” ");
INSERT INTO did_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Na du-on kan no uras nig-ampù si Jesus to Diyus no nig-iling kandin to “Amoy no Magbobo-ot to langit aw pasak, ogpasalamat a ikow su pig-ukasan nud on to nama-anan nu to mangka-intok no otow. Dì pighobongan nud on to mgo mangka-aslag no mgo otow bahin to Madoyow no Tutuwanon bahin to pagsakup to Diyus. ");
INSERT INTO did_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Dì to mangka-intok no mgo otow, pigtaga nud iyan nasì bahin to pagsakup nu su sikan man to pagbo-ot nu.” ");
INSERT INTO did_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Pagkatapus ni Jesus to nig-ampù to Diyus, nigpanoysoy mandà kandin to kahan-ingan bahin to pigsakupan to Diyus. Kagi din, “To Amoy ku, imbogoy din kanak to tibò no katùtu-uhanan. Wadà duma no nigkilaa lagboy to Anak, ko konà no Amoy dà, aw wadà duma no nigkilaa to Amoy ko konà no Anak dà gayod aw tibò to pigpilì din no ogpakilahon din to Diyus. ");
INSERT INTO did_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Iyu no nangkapagud to pagpa-omot to pagdaa to mabogat no tulumanon no wadad on man kapongahanan, pasakup kow on kanak su awos mapahungow ku iyu to kalisodan aw ka-agkapi kow to kabogatan no pigtagudaa now. ");
INSERT INTO did_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ogsab-ung kow to kanak yugu no litukan to ogpasakup kow to kanak impang-anad aw ogpa-anad kow kanak su danu-an a aw ma-ungangon a no otow. Ogpahungawon ku to iyu no ginhawa no nigdodo-ot. ");
INSERT INTO did_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","To insugù ku iyu, konà no mabogat dì mahawoy dà iyan.” ");
INSERT INTO did_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Pagkaugoy-lugoy nighipanow on kandan si Jesus no nigtaà to humayan to adow no konà no tigtatalabahu. To mgo pangabaga din, kanunoy nalisig kandan no nighipanow namangkinotu-kotu to bogas to humoy aw kotip-kotipa dan su kandan, namanlotoy. ");
INSERT INTO did_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Dì nakita-an kandan to mgo Parisiyu no namantagon lagboy to kandan no katahanan. Namaka-ikagi kandan to “Naboong-boong koy su to mgo pangabaga nu, pighimu dan to konà podon ogtugutan to tinu-uhan ta to adow no konà no tigtatalabahu. Nokoy man buwa no namanhimu kandan to angod sikan.” ");
INSERT INTO did_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Nigtabak si Jesus to “Wadà kow buwa makabasa to pagbo-ot ni David no namakalaguy kandan no nahadok to mgo kablang dan. Wadà ko-on-ko-on dan. ");
INSERT INTO did_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Na du-on namanlotoy kandan si David. Wadà now buwa kadomdomi to nakasood kandan to simbahan aw pamango-on puli to ko-onon no in-idang diyà to atubangan to Diyus. Iyan dà ogpakako-on podon sikan no ko-onon kan mgo punu-an to tinu-uhan no pigpatubus to ka-otawan diyà to atubangan to Diyus su sikan dà to pigtugutan to tinu-uhan ta. Dì wadà mamakadilin namakako-on on tibò gayod kandan si David su namanlotoy man lagboy. ");
INSERT INTO did_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Dow wadà kow buwa makabasa to kasulatan ni Moises bahin to mgo hinang-hinang to punu-an to labow no simbahan natodu-on. Agad adow on no konà no tigtatalabahu, dì kanunoy ogpakatuman on to ogkangkahinang-hinang dan. Dì wadà dà man kabotangi kandan to saà. ");
INSERT INTO did_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Dì kunto-on moydu-on on iyan nakalogwà no labow pad to katahanan ta bahin to tulumanon to simbahan su ogpunu-an kud to bayà no tulumanon. ");
INSERT INTO did_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Wadà now podon kabotang-botangi to saà to mangkatuwadong no otow ko madaagan now pa podon to litukan so-idi no ikagihonon no likat to kasulatan no pig-iling to ‘Ogpa-aag-aagon ku pad to pagka-at now to kasing-otow now du-on to pagsundù now nasì kanak to buhì,’ ");
INSERT INTO did_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","su kanak no Tumutubus to Ka-otawan, tagtu-un a man gayod to adow no konà no tigtatalabahu.” ");
INSERT INTO did_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Dayun nighipanow kandan si Jesus aw padayong diyà to simbahan to mgo Parisiyu. ");
INSERT INTO did_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Nakaba-ot gayod to songo otow no pawing no nignohut to boad. To mgo Parisiyu no namantagon lagboy to kandan tinu-uhan, nigpangusip-usip kandan su awos moydu-on mapatikinan dan podon no igkadiklamu dan kandin diyà to mata-as to tinu-uhan. Kagi dan to “Dow ogtugutan ki buwa to tinu-uhan ta to pagdoyow to masakiton to adow no konà no tigtatalabahu?” ");
INSERT INTO did_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Na impananglitan ni Jesus to pagtabak din no pig-iling din to “Iyu, ko pananglitan moydu-on sobu-uk no buhì dì ma-uugan kow to iyu no buhì diyà to lugì, lagboy konà now puli ogkapabay-anan. Dì ogpangahà kow to pagpadoog no ogkapudut awos konà mamuwa to buhì agad makata-un to adow no konà no tigtatalabahu. ");
INSERT INTO did_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Dì labow-labow pad to kasing-otow ta du-on to buhì ta puli. Kaling man ogkatugutan ki to tinu-uhan ta to ogpabuligan ita to kasing-otow ta, agad adow on no konà no tigtatalabahu.” ");
INSERT INTO did_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Kagi ni Jesus diyà to otow no pawing no nig-iling to “Kotongad on to boad nu!” Dayun kinotong to napawing to boad aw ka-uli-id on dayun. ");
INSERT INTO did_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Na to mgo Parisiyu, namanlabas aw kasusukun-sukun kandan dow og-amonuhon dan to pagpadoog to paghimatoy podon ki Jesus. ");
INSERT INTO did_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Dì nama-anan dà ni Jesus to napikiyan dan. Kaling man nighipanow on kandan si Jesus. Dì namanduma dà to kahan-ingan aw pamasandog to mgo masakiton diyà kandin. Tibò din nangka-uli-an to nangkasakit. ");
INSERT INTO did_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Dì pigbahog ni Jesus kandan to konà ogpatangkapon to bantug din ");
INSERT INTO did_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","su awos matuman to intag-an ni Isaias no maglilikwaday to Diyus no lagsoban. ");
INSERT INTO did_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","So-idi to impasulat ki Isaias to Diyus no pig-iling to. “So-idi to timbang ku no pigpilì no nalogonan ku no naliyagan ku lagboy no ogpatumanon ku to pagbo-ot ku su ogbogayan ku kandin to Ispiritu Santu, aw kandin gayod ogpabobo-oton ku to nigsingkabugtì no mgo otow. ");
INSERT INTO did_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Konà ogpangsamuk kandin aw ogbansagon ko igkikita diyà to hibaakan to daan. ");
INSERT INTO did_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Konà din gayod ogdut-unan kan otow no nalisodan aw konà din ogdut-unan to buu no nabutuk to kamag. Konà din gayod ogposokan to nighaong-haong on no ilawan. Dì bali on man ogkapasigkon din to samuk-samuk tibò to katapusanan din no pagda-og, ");
INSERT INTO did_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","aw ngadan din to ogka-imanan to nigsingkabugtì no mgo otow.” ");
INSERT INTO did_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Na pagkaugoy-lugoy nigdatong on mandà to otow no nasoodan to busow no pigdaa to mgo kadumahan din. Pisok aw pohà pad kandin no otow. Piggawang ni Jesus to busow du-on kan no otow hantod to ogpaka-ikagi on aw makakita. ");
INSERT INTO did_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Naboong-boong to mgo ka-otawan du-on aw ka-inusipay kandan to “Sugpù ni David buwa so-idi no otow no og-imanon ta no bumubulig ita.” ");
INSERT INTO did_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pagkadinog to mgo Parisiyu to napugut-pugutan, namaka-i-ikagi kandan to “To igkagawang ni Jesus to mgo busow su nabogayan man kandin to kabogbogan to tagtu-un to mgo busow no si Bilsibul.” ");
INSERT INTO did_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Dì tahan dà nama-anan ni Jesus dow nokoy to nadomdoman dan. Kagi din to “To sinakupan, ko ogkinablangay, madaas dà to katapusan. To songo banwa gayod dow lunsud, ko ogkinablangay, ogkalompag dà man iyan. ");
INSERT INTO did_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ko oggawang si Satanas to mgo kasakupan din, ogkagawang dà to sinakupan din tibò. ");
INSERT INTO did_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Na ko nadomdoman now to ogpakagawang a to mgo busow no likat to kabogbogan to tagtu-un kandan no si Bilsibul, ando-i buwa to piglikatan to kabogbogan to mgo sakup now no ogpakagawang to mgo busow. Sikan mgo sakup now to igkapatu-u to nakasaà kow to pagdomdom now su intobo-ot now dow to kanak kabogbogan, likat diyà ki Satanas no pighingadanan gayod ki Bilsibul. ");
INSERT INTO did_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Dì ko Ispiritu Santu to piglikatan to kanak kabogbogan to ogpakagawang to mgo busow, sikan to igkapatu-u iyu to na-abutan kow on to pagsakup to Diyus. ");
INSERT INTO did_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Na to kawatan, konà ogpakasood to baoy to otow ko mabuut to tagbaoy aw makapudut to katinguban din ko konà pad mada-og to tagbaoy. Dì ko mada-og to tagbaoy, kayan pana ogkapudutan kandin to katinguban din. ");
INSERT INTO did_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“To otow no konà ogduma kanak, iyan nasì ogkablang kanak. To otow no konà ogbulig kanak no ogpanghimun to nig-abut, iyan nasì ogpangkanat to nahimun on no nig-abut. ");
INSERT INTO did_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kaling man ognangonan ku iyu to ogkapasaylu dà to agad nokoy no saà to otow, agad og-ina-inahon din on to Diyus no Amoy aw Anak. Dì ko og-ina-inahon din on to Ispiritu Santu, konad on ogkapasaylu. ");
INSERT INTO did_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Agad ina-inahon a no Tumutubus to Ka-otawan, dì ogkapasaylu ku dà. Dì to otow no oglangub og-ina-ina to Ispiritu Santu, konad on iyan ogkapasaylu. Kanunoy on ogdokot du-on kandin to saà, kunto-on aw agad kaugayan. ");
INSERT INTO did_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Oghimuhon ta no songobu-ukon to kayu aw bogas din, agad madoyow dow mado-ot. To bogas, du-on ta to ogkakilahan dow nokoy kayuha to nalikatan din. Ko mado-ot no kayu, og-agad dà to mado-ot dà gayod to mgo bogas. ");
INSERT INTO did_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Iyu, iyan ogka-angodan now to uwod no ogpakamuwa. Konà kow ogpakalituk to madoyow su mado-ot to sood to ginhawahan now. Su agad nokoy no imbotang now du-on to ginhawahan now, og-agad gayod to pag-ikagi now. ");
INSERT INTO did_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Madoyow no otow, ogpaka-ikagi to madoyow su madoyow man to imbotang din du-on to ginhawahan din. Dì mado-ot no otow, ogpaka-ikagi to mado-ot su mado-ot man to imbotang din du-on to ginhawahan din. ");
INSERT INTO did_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Ognangonan ku iyu, to mahudi no adow, to mgo otow tibò no ogpang-ikagi to wadà puus, ogbo-otan to Diyus ");
INSERT INTO did_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","su to ogbo-otan kow to Diyus to mahudi no adow agad-agad to nalituk now no kagi agad madoyow no ogpakalipwas iyu dow mado-ot no ogpakapabalitù dà iyu.” ");
INSERT INTO did_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Na moydu-on mgo mag-a-anad to tinu-uhan to mgo Hudiyu aw mgo Parisiyu no namang-ikagi diyà ki Jesus to “Sir, ogpa-aha-on koy nu podon to kaboonganan no mabogbog pad no igpahimu noy ikow no igkamatu-ud to na-uyunan ka to Diyus.” ");
INSERT INTO did_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Dì nakatabak si Jesus to “Lagboy to kado-ot to mgo kadongan ku no kanunoy ogpanlingì-lingì to duma no ogpadugang pad podon to kaboonganan no ogkakita-an dan podon su litos on man podon to kaboonganan no nahimu kud on no nakamatu-ud iyu to na-uyunan a to Diyus. Wadà kaboonganan no igdugang ku gawas to kaboonganan no ogpaka-angod to kaboonganan natodu-on no ingkalibwas ni Jonas no maglilikwaday to Diyus no agad nalam-od on to isdà no ma-aslag, dì nakalibwas dà kandin. ");
INSERT INTO did_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Si Jonas, naka-ugpà on du-on to sood to gotok to isdà to tatou no adow. Dì kanak no Tumutubus to Ka-otawan, ogpaka-ugpà a gayod to lobong to tatou no adow. ");
INSERT INTO did_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ton mgo taga-Niniba no namantuman to udlin ni Jonas aw sosoo aw oyowi dan to kandan katahani no bugtì, to mahudi no adow no pagbo-ot on to Diyus to ka-otawan, ogkabotangan kow dan nasì to saà no iyu no tipahudi no kadongan ku su wadà now angodi to pighimu dan. Dì nakalogwà on dini to maglilikwaday to Diyus no labow pad ki Jonas. Dì iyu kunto-on, wadà now on oyowi to katahani now. ");
INSERT INTO did_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Natodu-on gayod buyag no nigsakup to Siba no banwa diyà to babagan, ogkabotangan kow din to saà no tipahudi no kadongan ku to mahudi no adow no pagbo-ot on to Diyus to mgo ka-otawan su kandin, nig-andiyà on ki Harì Solomon, agad madiyù no banwa to piglikatan din, su ogpaminog podon kandin to nama-anan ni Solomon no imbogoy to Diyus. Dì kunto-on nakalogwà on to labow pad ki Solomon dì wadà now angodi to pighimu din.” ");
INSERT INTO did_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Nig-aboy si Jesus nigpang-anad to ka-otawan no nig-iling to “Na ko pananglitan, ko magawang to busow du-on to pigsoodan din, ogpakalahok on puli to busow du-on to katahayan no banwa su ogpanganap to ogka-ugpa-an din, dì wadà ogka-abutan din. ");
INSERT INTO did_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","To tu-un din no domdom og-ilingon din to ‘Ah, ogpati-ulì a dà diyà to tahan ku no ugpa-anan no nali-usan kud on.’ Pagdatong din wadà nasakpan din du-on. Dì napunasan on aw katapid on. ");
INSERT INTO did_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Dayun nigbaligà to pitu pad no mgo busow no mado-ot pad du-on kandin. Namansood kandan du-on ton otow no piggawangan on. Na to ka-ugpà kan otow, malisod pad nasì du-on to tugdow no kabotang din. Angod dà to ogkadoogan so-idi no mgo otow no kadongan ku no mangkado-ot.” ");
INSERT INTO did_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Na naka-abut on to inoy ni Jesus aw mgo hadi din ta-un to nig-ikagi pad si Jesus. No diyà dà kandan to labas, puli dan impasabi si Jesus su mahan-ing no nadasok. ");
INSERT INTO did_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Dayun moydu-on nignangon ki Jesus to “Kanid on to inoy nu aw mgo hadi nu. Ogpagbaaw podon ikow kandan.” ");
INSERT INTO did_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Nig-ikagi si Jesus to “Intawa lagboy to inoy ku aw mgo su-un ku.” ");
INSERT INTO did_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Intudlì ni Jesus kan mgo sakup din no natalidong aw ikagi to “Iyu on to angay inoy ku aw mgo su-un ku. ");
INSERT INTO did_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","To ogtuman to pagbo-ot to Amoy ku diyà to langit, sikan on to angay inoy ku aw mgo su-un ku.” Angod sikan to impang-anad ni Jesus to mgo ka-otawan. ");
INSERT INTO did_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Kandà no adow nighipanow on kandan si Jesus padoog diyà to boyboy to dagat. Pagdatong dan aw ni Jesus diyà to boyboy nig-ingkud kandan ");
INSERT INTO did_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","su awos ogpang-anad on to ka-otawan no nahimun aw nadasok lagboy. Kaling man nigluwan si Jesus to sakayan no bautu. Nig-ingkud on kandin no nig-atubang kandin to kahan-ingan no du-on to boyboy to dagat. ");
INSERT INTO did_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Na nigpang-anad si Jesus to ka-otawan no impabayà to mahan-ing no pananglitan. Nig-iling kandin to “Na, ogtutuwanan kow to mag-o-odok to humoy. No makalangkob to sangab pigsawodan on to mag-o-odok to binhì. ");
INSERT INTO did_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Pagsawod din moydu-on binhì no nigdo-og diyà to daan. Dayun nigpatipadpad to manuk-manuk aw pantubug-tubuga to binhì. ");
INSERT INTO did_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Moydu-on binhì no nigdo-og diyà to pasak no batuhon. Nigtulin dà kan niggitì du-on to batuhon. ");
INSERT INTO did_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Dì pag-ugtu to soga, oglanos aw kamatoy su wadà man ogkaduhugan to dalid. ");
INSERT INTO did_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Moydu-on gayod binhì no nigdo-og diyà to pasak no dalidon no kan dalid no paggitì, dugihon on. Nigkadodongan to pagtulin no hantod to piglinop aw nohut aw lahag su nasakbut man. ");
INSERT INTO did_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Moydu-on gayod binhì no nigdo-og diyà to madoyow no pasak aw sikan to nigbogas to madoyow aw abut to dakoo. Moydu-on niggatus, aw moydu-on nigkan-oman, aw moydu-on nigkatlu-an to nig-abut. ");
INSERT INTO did_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Na, agad intawa no nakadinog, pangindaagan to kalitukan to pananglitan ku.” ");
INSERT INTO did_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Na pagkali-us to ka-otawan pig-usip si Jesus to mgo sakup din to “Nokoy man no impananglitan nu pad man to pagpang-anad nu to ka-otawan.” ");
INSERT INTO did_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Nigtabak si Jesus to “Mahobong todu-on no kalitukan aw sikan kadaoman, dì iyu, ogkama-anan now dà no bahin to pagsakup to Diyus. Su kunto-on ogbadbadan kow on to Diyus. Dì igpananglitan ku pad to mgo ka-otawan su pighobongan nasì kandan to Diyus to mgo kalitukan. ");
INSERT INTO did_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","To otow no nigtu-u, ogkadugangan ku pad iyan to nama-anan din, dì to wadà paminog, agad ma-intok dà to nama-anan din dì ogkapudutan pad nasì. ");
INSERT INTO did_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kaling man to ka-otawan no wadà kalabotan to sinakupan to Diyus no nabigtoan on, impananglitan ku su agad mang-ahà-ahà kandan, dì wadà ogkakita-an dan. Agad duminog, dì konà ogpakadaag. ");
INSERT INTO did_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Natuman dan to tahan impanag-an ni Isaias no maglilikwaday no lagsoban to Diyus no pig-iling to ‘Nabigtoan kandan su agad mang-ahà-ahà kandan, dì wadà ogkakita-an dan. Agad makadinog kandan, dì ampan ogkadaagan dan. ");
INSERT INTO did_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Su iyu no mgo otow, to ginhawahan now, masupak-supakon. To talinga now, ogpabongoo-bongoon now puli. To mata now, pigpiyong now, su puli ogtawtaga-odan to pag-ahà now. Dì to domdom now, wadà du-on. Ko wadà kow podon angod sikan, ogpasakup kow podon kanak, aw ogkabuligan ku podon iyu.’ ");
INSERT INTO did_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Dì iyu no sakup ku, ogkaliyag kow su ogpakakita kow man aw makadinog. ");
INSERT INTO did_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Iyu, nakita-an now on to pigpakagutgut podon no ogkakita-an to mgo maglilikwaday no lagsoban to Diyus natodu-on aw duma gayod no mgo otow no matuwadong. Nadinogan now on gayod to piggutgut dan podon no ogdinogon. ");
INSERT INTO did_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Na, ogpangintaga kow to mgo kalitukan to pananglitan ku. Na bahin to mag-o-odok to humoy, ");
INSERT INTO did_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","sikan mgo otow no ogdinog to impang-anad ku bahin to pagsakup to Diyus aw konà ogpakadaag, iyan ogka-angodan dan to binhì no nigdo-og diyà to daan. Ko duminog kandan to kagi to Diyus, oglogwà on si Satanas aw sakmita din to ing-odok du-on kandan. ");
INSERT INTO did_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Sikan binhì no nigdo-og diyà to batuhon no pasak, iyan ogka-angodan to mgo otow no ogkaliyag to ogpaminog to kagi to Diyus aw dawata. ");
INSERT INTO did_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Dì wadà lagboy makaduhug to dalid su wadà dan man lagboy pasooda du-on to ginhawahan dan to kagi to Diyus. Ko umabut to kalisod aw mgo pagpahadat to kadumahan dan ugpat to kagi to Diyus, ogka-oyowan dan to pagtu-u dan dayun dini kanak. ");
INSERT INTO did_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Moydu-on gayod binhì no nigdo-og diyà to pasak no dalidon no sikan, dugihon, sikan iyan na-angodan to mgo otow no nigdawat to kagi to Diyus no wadà abuti to bogas su piglinop on kandan to nakasakbut to kagi to Diyus du-on to ginhawahan dan su nigminapook-pook kandan to igkabuhì dan aw pa-aag-aagon dan nasì to kadatù. Kaling piglinop to kagi to Diyus aw wadà nig-abut no bogas. ");
INSERT INTO did_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","To ing-odok no nigdo-og diyà to madoyow no pasak, iyan na-angodan to mgo otow no nigpaminog to kagi to Diyus aw pigpasood diyà to ginhawahan dan aw baya-a to Diyus kandan aw moydu-on bogas no nig-abut no niggatus. Moydu-on tag kan-oman. Moydu-on gayod tag katlu-an to nig-abut.” Sikan to kalitukan to pananglitan ni Jesus. ");
INSERT INTO did_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Na impananglitan mandà ni Jesus to ka-otawan bahin to otow no nig-odok to dawa. Kagi ni Jesus to “To pagsakup to Diyus, iyan ogka-angodan to otow no nig-odok to dawa. Nigsawod kandin to madoyow no binhì diyà to uma din no maow-ag. ");
INSERT INTO did_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","No pagkatapus to pagsawod aw kadukilom on aw nangkalipodong on to mgo sakup din, pig-andu-onan to kablang din aw imba-ot to bagnot to pagtanom du-on to pig-odokan din to dawa. Dayun namanlunus aw hipanow on kandan no wadà nama-an. ");
INSERT INTO did_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Wadà kaugoy niggitì on aw namanpamagtin to in-odok dì naba-otan on to bagnot. ");
INSERT INTO did_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Dayun pig-andu-onan sikan tagtu-un to dawahan to mgo sakup din aw usipa dan to ‘Dow konà buwa no pinpin no dawa no binhì todu-on impa-odok nu, Sir? Nokoy man buwa to ingkapabayà to naba-otan on man to bagnot su kunto-on bali nakilahan su namagtin on to dawa.’ ");
INSERT INTO did_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Nakatabak to tagtu-un to dawahan to ‘Imba-ot iyan to kablang ta.’ Nig-ikagi to mgo sakup din to ‘Dow igpapispis nu dà buwa kanami to bagnot su imba-ot dan man iyan to pagtanom ta.’ ");
INSERT INTO did_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nakatabak to tagtu-un to dawahan to ‘Konà now on ogpispison to bagnot kunto-on su ogka-aput to dawa. ");
INSERT INTO did_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ogpabay-anan now on nasì hantod to tig-ani on. Kayan ogsugù a to mgo uma-ani to, Ogtugdawon now to pagpispis to bagnot aw ogpambogkoton awos mahakut aw masangab. Dì sikan bogas to dawa, pagka-ani, oghakuton aw ibotang diyà to kubkub.’” ");
INSERT INTO did_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Na impananglitan din mandà bahin to pagdakoo to sinakupan to Diyus no innangon din bahin to intanom no binhì no longa no magabudbud dà no pig-iling din to “To pagdakoo to sinakupan to Diyus, ");
INSERT INTO did_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","iyan na-angodan to binhì no longa, to tugdow, magabudbud dà ubag. Dì ko oggitì on, ma-aslag on kan lawa aw ogkahimu no ogkahapunan to mgo manuk-manuk to mgo sanga. ");
INSERT INTO did_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","“Na to pagdakoo to sinakupan to Diyus, iyan na-angodan to ogpatulin to buyag to malagkit. Agad ma-intok dà to imba-ot din no igpatulin, dì ogkaponù on to pigbotangan din.” ");
INSERT INTO did_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","To pagpang-anad ni Jesus to ka-otawan, kanunoy din igpabayà to pananglitan. Wadà ing-anad ni Jesus to mgo ka-otawan ko konà din no igpabayà to pananglitan tibò. ");
INSERT INTO did_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Iyan impananglitan ni Jesus to pagpang-anad su awos matuman to tahan intag-an to maglilikwaday no lagsoban to Diyus bahin ki Jesus no pig-iling to. “Igpananglitan ku to ing-anad ku. Ogtagahon ku kunto-on to mahobong likat to paggihit to Diyus so-idi kalibutan hantod kunto-on.” ");
INSERT INTO did_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Na nigpagsuwoy kandan si Jesus to mgo ka-otawan aw ulì diyà to baoy. Pagdatong dan on kagi to mgo pangabaga din to “Panaysayi koy kun Sir to pananglitan nu bahin to bagnot diyà to dawahan.” ");
INSERT INTO did_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Kagi ni Jesus to “Kanak no Tumutubus to Ka-otawan, og-odok a to binhì no madoyow. ");
INSERT INTO did_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","To pasak, iyan ogka-angodan so-idi kalibutan. To binhì no madoyow, iyan ogka-angodan to mgo otow no ogpamasakup kanak. To bagnot, iyan ogka-angodan kan konà ogpamasakup kanak su ki Satanas kasakupan. ");
INSERT INTO did_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","To nigba-ot to bagnot, iyan ogka-angodan din to kablang ta no si Satanas. To pagka-ani, iyan ogka-angodan to katapusanan so-idi kalibutan. To uma-ani, mgo diwata likat to Diyus. ");
INSERT INTO did_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Na to pagdap-ug dan to bagnot aw sangaba, iyan ogka-angodan to katapusan so-idi kalibutan ");
INSERT INTO did_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","su kanak no Tumutubus to Ka-otawan, igpagawang ku to mgo diwata kan mgo otow no mangkado-ot to hinang aw agad nokoy no igkasaà to mgo otow du-on to pigsàkupan ku. ");
INSERT INTO did_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Pagkahimun igsugba diyà to logdog. Du-on ogpakasinogow kandan to pagkasosoo dan aw pangagotkot to bag-ang ugpat to pagkasakiti dan. ");
INSERT INTO did_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Pagkagawang tibò to mangkado-ot no hinang, sikan mgo sakup to Diyus no madoyow to hinang, ogbandog no ogpaka-angod to soga su ogtumanon on to pagsakup to Diyus ta no Amoy. Agad intawa no nakadinog to impang-anad ku, ogtumanon.” ");
INSERT INTO did_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Nig-ikagi mandà si Jesus no pig-iling to “To pagsakup to Diyus, iyan gayod ogka-angodan to ayama-an no inhobong diyà to kapognotan. Dì nakita-an to songo otow aw tukhow kandin. Dayun inlobong aw libuni din aw ulì diyà to baoy su igpamaligyà din to katu-unan tibò su ogbolihon din podon kan no pasak no nabotangan to ayama-an no nakita-an din.” ");
INSERT INTO did_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Na impananglitan ni Jesus mandà bahin to mamaligya-ay to mutyà no mahal. Kagi din to “To pagsakup to Diyus, iyan ogka-angodan to mutyà no mahal no pigpanganap to mamaligya-ay. ");
INSERT INTO did_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Pagkakita din on to mutyà no mahal, imbaligyà to katu-unan din tibò aw iyan boliha din. ");
INSERT INTO did_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“To pagsakup to Diyus, iyan gayod ogka-angodan to ma-aslag no pukut no intuntun diyà to dagat aw makapudut to isdà no nigsingkabugtì. ");
INSERT INTO did_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ko mahan-ing to nakasood, ogguyudon on to mang-isda-ay diyà to boyboy. To mangkadoyow, igtagù to bangkow, dì to mangkado-ot, igtimbag. ");
INSERT INTO did_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","To mahudi no adow to katapusanan to kalibutan, sikan mgo diwata to Diyus, ogpaka-angod kan, su ogpagbugti-on dan kan mgo mangkadoyow no mgo otow aw kan mangkado-ot. ");
INSERT INTO did_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","To mangkado-ot, igsugba diyà to logdog, aw du-on pakasinogow to pagkasosoo dan aw pangagotkot to bag-ang ugpat to pagkasakiti dan.” ");
INSERT INTO did_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Na nig-usip si Jesus to mgo pangabaga din no sampuù tag duwa to “Dow nadaagan now to tibò no innangon ku iyu?” Namantabak kandan to “Ho-o.” ");
INSERT INTO did_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Nig-ikagi mandà si Jesus to “Iyu no pig-anad to impang-anad ku bahin to pagsakup to Diyus, iyan ogka-angodan now to tagbaoy no dakoo to katinguban no nigsingkabugtì no mgo tahan aw mgo bayà, su ogpakapang-anad kow to ka-otawan to tahan no impang-anad ita aw bayà no impang-anad ku iyu gayod.” ");
INSERT INTO did_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Pagkatapus ni Jesus to mgo pananglitan din no impang-anad din, namanhipanow on tibò kandan ");
INSERT INTO did_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","padoog diyà to kandin banwa. Pagdatong dan nang-anad mandà si Jesus diyà to tu-un dan no simbahan. Nangkaboong-boongan to mgo kadumahan din du-on sikan no lunsud to kandin impang-anad. Nigka-inusipay kandan to “Ando-i buwa makalikat to kandin nama-anan aw kan mgo kaboonganan. ");
INSERT INTO did_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Dow konà buwa no so-idi to anak ton maghihimu to baoy? Dow konà buwa gayod no anak ni Maria? Dow mgo su-un din buwa, kandan si Santiago, si Jose, si Simon, aw si Judas? ");
INSERT INTO did_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Sikan mgo atoboy din, dow konà ta buwa no duma kani so-idi no lunsud? Ando-i buwa makalikat to nama-anan din su tahan ta dà man nama-anan to piglikatan din.” ");
INSERT INTO did_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Kaling man nasawa-an dan kandin su intobo-ot dan dow niglangub puli kandin nigpalabow-labow. Dì nig-ikagi si Jesus to “Tahan to otow su agad ando-i dumoog to maglilikwaday to Diyus, igkatahud kandin tibò gawas ko diyà to kandin banwa aw diyà to mgo kasu-unan din.” ");
INSERT INTO did_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kaling man ma-intok dà to kaboonganan no pighimu din du-on su wadà tu-uhi kandin no Imananan to Ka-otawan. ");
INSERT INTO did_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Dì to bantug to kaboonganan no pighimu ni Jesus, nigtangkap diyà to duma no banwa. Aw si Hirudis gayod no mata-as to Galiliya, inabut to nawnangonon aw kapook-pooki din su na-intobo-ot din dow si Juan on no Magbobonyagay to nighimu sikan no nanangon no mgo kaboonganan. ");
INSERT INTO did_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Na-iling din to “Domdom ku dow si Juan on no Magbobonyagay to nighimu sikan no mgo kaboonganan. Inabut buwa kandin to kabogbogan no iyan piglikatan to pagbuhaya din.” ");
INSERT INTO did_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Na og-uli-on tad to tutuwanon no napa-atubangan to kagi ni Hirudis no sikan, nalipasan tad. Si Hirudis iyan to nigpadakop aw nigpahimatoy ki Juan natodu-on. Impadakop din si Juan su impanagda si Hirudis ni Juan su si Felipe no hadi ni Hirudis, inagawan din to asawa no si Hirudiyas. ");
INSERT INTO did_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Kagi ni Juan no nanagda ki Hirudis to “Nakasaà ka su inasawa nu to asawa on to hadi nu. Ing-okod to tinu-uhan ta.” ");
INSERT INTO did_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ogpatampodan din podon si Juan to li-og dì nahadok si Hirudis ko mamang-atu to ka-otawan su si Juan, pighinang dan no tùtu-u no maglilikwaday to Diyus. ");
INSERT INTO did_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Na nighinang si Hirudis to impasalamat din to pagka-otow din. Pinasayow din to daga no anak to ipag din no inasawa din dà. Pagsayow din du-on to kahimunan, naliyag si Hirudis. ");
INSERT INTO did_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Nakasahad kandin no pigbogat din to kagi to ogbogoy kandin diyà sikan no daga to agad nokoy no ogpangamuyu-on din. ");
INSERT INTO did_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Na to inoy to daga, impa-ikagi din to anak din diyà ki Hirudis no impa-iling din to “Bogayi a nu kunto-on to uu ni Juan no Magbobonyagay no igluwan to bandihadu.” ");
INSERT INTO did_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Na nakasosoo dà podon si Hirudis to ingkasahad din no kagi. Dì konà din on ogkabalibad to na-ikagi din diyà to daga su nakasahad man kandin no pigbogat din to kagi du-on to atubangan to mgo namba-ot no nangkahimun du-on to hinang din. ");
INSERT INTO did_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","No bali wadà din on kasalipoguti, na-igoy din on to ogpatampodan din si Juan to li-og diyà to pirisuhan. ");
INSERT INTO did_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Na du-on natuman on to pigpangamuyù aw kadaa to uu ni Juan no inluwan diyà to bandihadu aw ibogoy diyà to daga. Na dayun pigdaa gayod to daga diyà to inoy din. ");
INSERT INTO did_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Dayun natugutan to mgo sakup ni Juan to kandan to oglobong to patoy no lawa ni Juan. Pagkatapus dan to niglobong, naman-andiyà kandan ki Jesus aw nangoni dan to napugut-pugutan bahin ki Juan. ");
INSERT INTO did_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Pagkadinog ni Jesus to nadoogan ni Juan, piggawangan din sikan no banwa. Namanluwan kandan aw si Jesus to sakayan no bautu aw talipag to dagat. Pagdatong dan diyà dihipag nigdu-ung kandan diyà to kahanongan no banwa. Dì pagkama-an to mgo ka-otawan to ogtalipag on kandan si Jesus, namanladgad no ogtokap kandan to boyboy to dagat su ogpamang-andiyà gayod kandan sikan no banwa no kahanongan. Naka-una dà nigdatong to kahan-ingan no ka-otawan aw katibò kangkahimun diyà to ogtagadan dan ki Jesus. ");
INSERT INTO did_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Bali no nigdatong kandan si Jesus. Paghaw-as dan, lagboy to kahan-ing to otow no nangkahimun. Pagkakita ni Jesus, pigka-atan din aw kangkadoyow din tibò to mgo masakiton. ");
INSERT INTO did_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Na pagkahapun namanduguk to mgo pangabaga diyà ki Jesus aw pamang-ikagi to “Sir, kahanongan on man no banwa so-idi aw sakot mahapun on. Sugu-ad so-idi mgo ka-otawan aw pama-andiya-a kandan to mgo kalunsudan awos ogboli to kandan ogkako-on.” ");
INSERT INTO did_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Dì nig-ikagi si Jesus to “Agad on. Konà ogpaka-and iyà kandan su iyu on to ogbogoy to ogkako-on dan.” ");
INSERT INTO did_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Namaka-ikagi to mgo pangabaga din to “Iyan dà ba-aw ta tibò to lima no bu-uk no paan aw daduwa gayod no bu-uk to isdà.” ");
INSERT INTO did_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Nig-ikagi si Jesus, “Na, daaha now dini kanak.” ");
INSERT INTO did_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Na pigpama-ingkud din tibò to kahan-ingan diyà to kasagkopan no bagnot. Pigdawat ni Jesus kan lima no bu-uk no paan aw daduwa no bu-uk no isdà aw langhag kandin diyà to langit no ogpasalamat to Diyus. Pigpamikas-pikas din kan paan aw ipamaduhuu din to mgo pangabaga din diyà to mgo ka-otawan. ");
INSERT INTO did_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Dayun namango-on to tibò no nangkahimun no puli dan binungku-an to pagko-on. Pagkatapus to pagko-on pigpanghimun dan to nasamà aw itagù dan diyà to bangkow aw sampuù tag duwa pad no ka-bangkow to naponù to nasamà. ");
INSERT INTO did_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Lima no maan to kalukosan no namango-on du-on. Wadad bilanga to kabuyagan aw kabata-an. ");
INSERT INTO did_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Na pigpa-una ni Jesus to mgo pangabaga din no pigpatalipag to dagat. Pigpamaluwan din to sakayan to mgo pangabaga din tibò, dì kandin to nabitas aw kandin to nigba-id aw pamahipanawa din to mgo ka-otawan no nangkahimun. ");
INSERT INTO did_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Pagpahipanow din to ka-otawan niggomow si Jesus to untud no awos og-ampù kandin to Diyus. Nadukiloman kandin du-on kan no untud no sobu-ukon din. ");
INSERT INTO did_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Dì to mgo pangabaga din no namansakoy to sakayan, nadaa on diyà to tongà-tongà to dagat su sinabod to kamag no mabogbog no nakabalatak kandan aw ogpakatinunga-tunga to sakayan to baod no magabubungan. ");
INSERT INTO did_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","To kabukas-bukas to adow, nigduguk si Jesus kandan no nighipanow diyà to babow to dagat. ");
INSERT INTO did_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Pagkakita to mgo pangabaga ni Jesus to nighipanow kandin du-on to babow to dagat, namakasa-og kandan to “Busow on buwa suyà!” su konad no pagkahadok dan su na-intobo-ot dan man dow busow on iyan no nigpa-atow no ogduguk du-on kandan. ");
INSERT INTO did_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Dì nig-ikagi kandin to “Si Jesus a. Konà kow ogkahadok.” ");
INSERT INTO did_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Si Pedro, naka-ikagi to “Sir, ko ikow iyan si Jesus, paduguka a diyà ikow no ogpakahipanow a du-on to babow to dagat.” ");
INSERT INTO did_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Nig-ikagi si Jesus, “Na, andini ka.” Dayun nighaw-as si Pedro aw makahipanow du-on to babow to dagat no nigpadoog diyà ki Jesus. ");
INSERT INTO did_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Dì pagbatì din to kamag aw kakita-i din to baod no magabubungan no ogkakinugpahay, konad no pagkahadok din aw hantod to nahibuu-hibuu on kandin podon. Nakapanawag kandin to “Sir, bumulig kad su ogkaonod ad.” ");
INSERT INTO did_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Nadawat ni Jesus aw ikagihi to “Nokoy man no wadà ka salig kanak no nigsugù ikow to ogpakahipanow ka du-on to babow to dagat. Ma-intok dà to pagtu-u nu. Nokoy man no nigduwa-duwa ka.” ");
INSERT INTO did_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Pagkaluwan dan to sakayan, nigsigkon to kamag. ");
INSERT INTO did_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Du-on namakaluhud kandan aw ampù kandan ki Jesus aw naman-ikagi to “Tùtu-u ka iyan no Anak to Diyus!” ");
INSERT INTO did_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Dayun nigdatong on kandan diyà to dihipag to dagat. Pagdatong dan nigdu-ung diyà to Ginisarit no banwa. ");
INSERT INTO did_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Paghaw-as dan aw ni Jesus, nakilahan dà kandan to mgo taga-Ginisarit. Dayun pigpamatawagan dan to mgo nangkasakit diyà to kalongodan aw pandaaha dan du-on ki Jesus. ");
INSERT INTO did_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Pigpangamuyu-an dan si Jesus to igatang ogpatudi-on to mgo nangkasakit to sagyad to kabò din. To otow no nigtudì to sagyad to kabò ni Jesus, na-uli-an to sakit din. ");
INSERT INTO did_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","No diyà pad si Jesus to Ginisarit, namang-andu-on to mgo punu-an to tinu-uhan no mgo Parisiyu aw mgo mag-a-anad to kasugu-an no likat to Hirusalim no lunsud. Pig-usip dan si Jesus no namang-iling to ");
INSERT INTO did_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Nokoy man no wadà tagon to mgo pangabaga nu to tulumanon ta no niglikat to ka-aw-apu-an ta su konà ogpanghugas kandan to boad ko ogko-on. Nakasaà kandan to pagko-on dan.” ");
INSERT INTO did_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Nakatabak si Jesus to “Og-usipon ku iyu to nokoy man no ogpa-aag-aagon now to iyu no tulumanon dì konà now ogpa-aag-aagon to kasugu-an to Diyus. ");
INSERT INTO did_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Insugù iyu to Diyus no pig-iling to ‘Igtahud now to amoy aw inoy no igpabayà to pag-alagà.’ Pig-iling gayod to ‘To og-ina-ina to amoy aw inoy, ogkahimu now no himatayanan.’ ");
INSERT INTO did_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Dì iyu, ogpang-anad kow nasì to litos dà ko moydu-on igkabulig to otow to ginikanan din, dì og-iling nasì kandin to ‘To bulig ku podon iyu no mgo ginikanan ku, diyà kud nasì igkabogoy to Diyus ta.’ Kaling man konà now igpatahud to otow to kandin amoy aw inoy no igpabayà to pag-alagà. ");
INSERT INTO did_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Sikan to nakapabayà kow to puli ogkapabay-anan to kasugu-an to Diyus aw katuman to iyu dà no impang-anad. ");
INSERT INTO did_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mapakunon-kunonon kow no mgo otow! Tùtu-u to tahan natag-an ni Isaias no maglilikwaday no lagsoban to Diyus bahin iyu no pig-iling to ");
INSERT INTO did_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Nigpakunon-kunon nigtahud kanak sikan no mgo otow to pag-ikagi dan, dì bàbà dan dà puli su bugtì to ginhawahan dan. ");
INSERT INTO did_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nigpakunon-kunon nig-ampù dini kanak, dì to kasugu-an ku, pig-ilisan dan to impang-anad no likat puli to domdom to otow.’” ");
INSERT INTO did_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Na pigpamaduguk mandà ni Jesus to ka-otawan aw ikagi to “Paminog kow tibò aw konà now ogkalingawan to mgo kagi ku. ");
INSERT INTO did_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Wadà ko-onon no ogpakasood to bàbà to otow no igkasaà din du-on to Diyus. Dì to oglogwà du-on to bàbà to otow, sikan nasì to igkasaà din du-on to Diyus.” ");
INSERT INTO did_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Dayun nigduguk ki Jesus to mgo pangabaga din aw pamang-ikagi, “Dow nama-anan nu buwa to nasawa-an ka to mgo Parisiyu ton na-ikagi nu?” ");
INSERT INTO did_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Impananglitan ni Jesus to pagtabak din no nig-iling to “Agad nokoy no tanom no wadà itanom to Diyus no Amoy ku diyà to langit, ogkabagnus. ");
INSERT INTO did_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Dì pabay-ani now on kandan no mgo Parisiyu su napisok man kandan no oghindù podon kandan to duma no pisok. Ko pisok to oghindù to pisok, tibò on ogpamakatuklabù to lugì.” ");
INSERT INTO did_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Nig-ikagi si Pedro, “Hubadi koy to mgo kalitukan to pananglitan nu.” ");
INSERT INTO did_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Nig-iling si Jesus to “Dow wadà kow pad makadaag to impang-anad ku? ");
INSERT INTO did_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Wadà now buwa kama-ani to konà ogpakasood dini to ginhawahan ta to kino-on ta? Dini to gotok ta to ogpakasood aw logwà diyà to labas to lawa ta. ");
INSERT INTO did_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","To oglikat to sood to ginhawahan to otow no kagi, sikan to igkasaà din ");
INSERT INTO did_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","su ginhawahan to otow to piglikatan to mado-ot no nigsingkabugtì no angod to mado-ot no pikii, pamunù, panghilabot to duma, pangawat, pagbotang-botang aw pag-ina-ina. ");
INSERT INTO did_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Sikan no oglikat to sood to ginhawahan to otow no mado-ot, sikan iyan to igkasaà din. Ko konà kow ogpakapanghugas to boad to konà pad ogko-on angod to insugù dan iyu agad man, su konà no sikan to igkasaà ta to kasugu-an to Diyus.” ");
INSERT INTO did_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Na namanhipanow on kandan si Jesus padoog diyà to banwa no nasakup to Tiru aw Sidun. ");
INSERT INTO did_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Pagdatong dan pigduguk kandin to buyag no sugpù to mgo taga-Kanan no tugdow no mgo uminugpà du-on kan no banwa no wadà pad kasoodi to mgo Isrili. Pigtinawag to buyag to “Magbobo-ot no anak ni Harì David, ka-ati a su pigsoodan to batà ku to busow.” ");
INSERT INTO did_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Dì wadà ikagi si Jesus. Pigduguk kandin to mgo sakup din aw pangamuyù kandan diyà ki Jesus to “Patumani nu ubag to pigpangamuyù sikan no buyag aw pahipanawad on kandin su pig-inulit-ulit din on to pagtawag ita.” ");
INSERT INTO did_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Nakatabak si Jesus, “Iyan dà pigpabantayan kanak to Diyus to mgo kasinugpu-an ni Israel su iyan ogka-angodan dan to mgo buhì no nangkawagà-wagà no wadà nigbantoy!” ");
INSERT INTO did_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Dì nigduguk nasì to buyag aw luhud, aw ikagi kandin to “Magbobo-ot, buligi a nud on ubag.” ");
INSERT INTO did_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Na impananglitan ni Jesus to pag-ikagi din no pig-iling din to “Konà no hustu ko ogtugdawan ta ogtubungan to mgo kadung ko wadà pad makako-on to mgo batà. Dì iyan ogpa-unahon ta to batà ogpako-onon.” ");
INSERT INTO did_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Nigtabak to buyag, “Ho-o iyan, Sir. Dì igatang iyan ogkako-on to mgo kadung to samà-samà no nangkapadpad diyà to saad to ko-onanan to tagbuhì.” ");
INSERT INTO did_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Naka-ikagi si Jesus to “Nigtu-u ka na-an Laginà. Matuman on to pigpangamuyù nu.” Na-uli-an on dayun to batà. ");
INSERT INTO did_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Na dayun nighipanow on kandan si Jesus no namanladgad to boyboy to dagat to Galiliya aw padayong kandan diyà to mgo ka-untudan. Pagdatong dan naman-ingkud kandan ");
INSERT INTO did_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","aw kahimuni kandan to kahan-ingan no ka-otawan no namanlupug aw nigdaa kandan to pungkù, podpod, pisok, pohà, aw duma pad no mgo mangkasakiton aw ipambotang dan du-on to atubangan ni Jesus. Nangka-uli-an din tibò. ");
INSERT INTO did_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","To tawoy, nangkaboong-boong on kan kahan-ingan su nakita-an dan to ogpaka-ikagi to pohà, aw kangka-ulì to podpod, aw makahipanow to pungkù aw ogpakakita to pisok aw kasayà-sayà dan to Diyus no ampu-onon to mgo Isrili. ");
INSERT INTO did_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Na pigpansabi ni Jesus to mgo pangabaga din aw ikagihi din to “Pigka-atan kud so-idi mgo ka-otawan su natatouhan on kandan dini ita no pigkabusan on to ba-aw dan. Konà ku puli kunto-on kandan ogpa-uli-on su ko pa-uli-on kud puli to wadà nangkako-on dan, dagow ogpamanlotoy kandan diyà to pangindanan.” ");
INSERT INTO did_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nakatabak kandan to “Ando-i ki to ogpudut to igpako-on ta kandan su kahanongan no banwa kani.” ");
INSERT INTO did_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Nig-usip si Jesus, “Dow pila no bu-uk to paan.” Namantabak to pangabaga din, “Pitu dà no bu-uk to paan aw moydu-on ubag isdà dì ma-intok dà.” ");
INSERT INTO did_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Dayun pigpama-ingkud din to kahan-ingan diyà to pasak ");
INSERT INTO did_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","aw dawata din kan pitu no bu-uk no paan aw isdà aw pasalamat kandin to Diyus. Pigpamikas-pikas din aw iduhuu din diyà to mgo pangabaga din. Na impamaduhuu din mandà diyà to mgo kahan-ingan. ");
INSERT INTO did_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Namango-on kandan no puli dan binungku-an to pagko-on. Pagkatapus to pagko-on dan, pighimun dan to mgo samà aw itagù dan diyà to bangkow aw pitu no ka-bangkow to naponù. ");
INSERT INTO did_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Upat no maan to lukos no namango-on du-on. Dì wadad bilanga to kabuyagan aw kabata-an no namango-on du-on gayod. ");
INSERT INTO did_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Na du-on pigpama-ulì din to mgo ka-otawan dì kandan si Jesus, namanluwan to sakayan aw talipag on kandan no ogpadoog on diyà to Magadan no banwa. ");
INSERT INTO did_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","No du-on pad kandan to Magadan no banwa, piglambag kandan to punu-an to tinu-uhan no mgo Parisiyu aw mgo Sadusiyu su awos ogpangintu-u dow si Jesus lagboy Imananan to Ka-otawan. Igpahimu dan podon ki Jesus to kaboonganan no oglikat diyà to langit no igkamatu-ud to na-uyunan iyan kandin to Diyus. ");
INSERT INTO did_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Dì pagpangamuyù dan iyan dà intabak ni Jesus to impananglitan no nig-iling to “Ko oglinahag to langit to mahapun, ogpaka-atom-atom kow to ‘Ogsoga to banwa.’ ");
INSERT INTO did_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ko oglinahag to langit aw makiboo to masoom, ogpaka-atom-atom kow no og-iling kow to ‘Ogdodo-ot gagaya.’ Ogka-amu kow dà ogtahom to timpu to banwa. Dì to timpu on to paglogwà to Imananan to Ka-otawan, konà kow on ogkilaa. ");
INSERT INTO did_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","To kadakoo to kado-ot to mgo kadongan ku no kanunoy ogliningì-lingì to duma no ogpadugang pad podon to kaboonganan no ogkakita-an dan no igkamatu-ud to na-uyunan a to Diyus. Iyan dà igpakita kandan to ta-indanan no igkapatu-u to ogpambuhayon to nangkamatoy no ogpaka-angod to nadoogan ni Jonas no maglilikwaday to Diyus natodu-on no nakalibwas dà kandin to kamatayon su agad pagkapuguti din to tatou no adow to pagka-ugpà din du-on to sood to gotok to ma-aslag no isdà dì nakalibwas dà kandin.” ");
INSERT INTO did_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Dayun du-on namanhipanow on kandan si Jesus aw talipag on to dagat. Dì nalingawan dan to pagdugang to ba-aw dan no paan. ");
INSERT INTO did_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Pagdatong dan diyà dihipag to dagat impananglitan ni Jesus no nig-iling to “Bantoy kow to igpatulin to paan likat to mgo Parisiyu aw mgo Sadusiyu.” ");
INSERT INTO did_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Nigka-inusipay kandan dow nokoy to kalitukan to pananglitan ni Jesus no nig-iling kandan to “Nokoy buwa to kalitukan to pananglitan din su wadà ki man makadaa to paan.” ");
INSERT INTO did_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Dì tahan dà nama-anan ni Jesus to intobo-ot dan dow to pig-ikagi din no ba-aw dan to napa-atubangan. Nig-usip kandin, “Nokoy man no nigka-inusipay kow to wadà paan ta. Manawà dà to pagtu-u now. ");
INSERT INTO did_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Wadà kow pad buwa makadaag to konà kow podon ogkapook-pook to ogkako-on? Dow nalingawan now buwa to pila no ka-bangkow pad to natagu-an now to nasamà pagpamaduhuu ku to lima dà no bu-uk no paan diyà to lima no maan no ka-otow ");
INSERT INTO did_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","aw pagpamaduhuu ku to pitu no paan diyà to upat no maan no otow. ");
INSERT INTO did_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nokoy man no wadà kow pad man makadaag to konà no paan to napa-atubangan ku to pagsoysoy ku to pananglitan ku. Bantayi now nasì to kandan no igpatulin to paan no mgo Parisiyu aw kan mgo Sadusiyu.” ");
INSERT INTO did_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Na bali no nadaagan dan to konà na-an no paan to napa-atubangan ni Jesus to kagi din. Dì pigpabantayan din nasì kandan to impang-anad to mgo Parisiyu aw Sadusiyu. ");
INSERT INTO did_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Na nigpadayong kandan si Jesus diyà to mgo lunsud no nasakup on to Sisariya Pilipu. No diyà pad kandan sikan no banwa, nig-usip si Jesus to mgo pangabaga din no iniling to “Kanak no Tumutubus to Ka-otawan, dow intawa a buwa agad-agad to mgo atoman to mgo ka-otawan.” ");
INSERT INTO did_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Namantabak kandan to “Moydu-on naka-ikagi to si Juan ka no Magbobonyagay no pigbuhoy. Moydu-on naka-ikagi to si Elias ka. Moydu-on gayod naka-ikagi to si Jeremias ka dow duma no maglilikwaday no lagsoban to Diyus natodu-on.” ");
INSERT INTO did_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Kagi din to “Dì iyu, intawa a agad-agad to atoman now.” ");
INSERT INTO did_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Naka-ikagi si Simon Pedro to “Ikow, Kristu ka no Imananan to Ka-otawan no Anak to Diyus no kan Diyus piglikatan to kinabuhì no konad ogkawadà.” ");
INSERT INTO did_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Nig-ikagi si Jesus to “Adu-a man ikow, Simon no anak ni Juan to kagi nu su sikan pagkakilaa nu kanak, wadà likat to puli no otow no mamatayon dà. Nakatag-an ka su Diyus no Amoy ku diyà to langit, kandin to piglikatan to na-ikagi nu. ");
INSERT INTO did_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Na ikow Simon, oghingadanan ku ikow kunto-on ki Pedro no iyan kalitukan to batu. Dì kanak no katondanan no Imananan to Ka-otawan no Anak to Diyus no impatag-an ikow to Diyus, ogpaka-angod to buhì no batu. Sikan no katondanan ku no angod to buhì no batu to pa-ukdanganan no ogkadangonan ku to kanak kasinakupan. Konà ogkagobà agad makugpahan to kasinakupan ni Satanas tibò no oglikat diyà to sood to pasak. ");
INSERT INTO did_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Oghimuhon ku ikow no ogbantoy to li-otanan to pigsakupan ku diyà to langit. To ogbogkoton nu dini to pasak, ogkabogkot dà gayod diyà to langit. To ogbadbadan nu dini to pasak, ogkabadbadan dà gayod diyà to langit.” ");
INSERT INTO did_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Dì pigpambahog lagboy ni Jesus to mgo pangabaga din tibò to wadà otow no ognangonan dan to kandin iyan to Imananan to Ka-otawan. ");
INSERT INTO did_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Na likat kandà no adow pigpunu-an ni Jesus to pagpasabut to mgo pangabaga din dow nokoy to igkapatuwa-ay kandin diyà to Hirusalim no ogpahadatan kandin to mgo punu-an to tinu-uhan hantod to oghimatayan kandin. Dì pagkatatouhi no adow, ogbuhayon dà. ");
INSERT INTO did_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Dì wadà kaliyagi ni Pedro aw paduguka din si Jesus aw sapadi din podon no nig-iling to “Sir, mababagan podon to Diyus to pig-ikagi nu. Konà podon ogkahimù to ogkatuman to pig-ikagi nu!” ");
INSERT INTO did_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Naka-ahà si Jesus aw maka-ikagi diyà ki Pedro, “Gawang kad kani, Satanas! Wadà nu uyuni to niglikat to Diyus. Dì otow dà puli to piglikatan to og-uyunan nu. Oghikogon a nu podon aw balataka a nu podon no ogtuman a man iyan to pagbo-ot to Diyus!” ");
INSERT INTO did_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Na innangon ni Jesus to mgo pangabaga din no pig-iling to “Na to ogpasakup kanak, ogka-oyowan din to kandin katahani tibò aw ogpaka-angod kanak no ogti-ang to kinurus din no iyan kalitukan to iglingow din to kandin no natagon no maogon lagboy. ");
INSERT INTO did_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Agad intawa no ogkawada-an to kandin kinabuhì ugpat kanak, ogkamoydu-onan to mahudi no adow. Dì agad intawa, ko ogpakatagonan din to kinabuhì din dini to kalibutan, ogkawada-an dà kandin to mahudi no adow. ");
INSERT INTO did_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","To otow no agad kunto-on ogpakatu-un so-idi kalibutan tibò dì to mahudi no adow konà ogbuhayon, dow nokoy to puus to natu-un din to mahudi no adow. Wadà dini to babow to kalibutan no igkatobus to otow awos mahawì din to kandin kinabuhì. ");
INSERT INTO did_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Moydu-on adow no ig-andini ku no Tumutubus to Ka-otawan no ogdumahan to mgo diwata aw katuusan to Diyus no Amoy ku. Kayan pana ogbaosan ku to mgo otow agad-agad to nangkahimu dan. ");
INSERT INTO did_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Moydu-on mgo otow kani no monang ogkamatoy ko ogkasakpanan pad to pagdatong to pagsakup ku no Tumutubus to Ka-otawan.” ");
INSERT INTO did_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Na pag-abuti to onom no adow niggomow si Jesus to untud no matikang. Pigputlung din pigpaduma si Pedro aw sikan nigpatahadi no si Santiago aw si Juan. ");
INSERT INTO did_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Pagkaluwan dan on du-on to puputukan to untud, nahalin on si Jesus. Na-usab to lawlanguhan din no ogpaka-angod on to bandog to soga to kasilow aw lagboy putì to kabò din aw pigsilow to mgo sakup din to nig-ahà. ");
INSERT INTO did_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Na nakalogwà du-on kandan to daduwa no katuusan on no maglilikwaday to Diyus natodu-on no si Elias aw si Moises. Nigpagbaaw kandan du-on ki Jesus. ");
INSERT INTO did_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Na du-on naka-iling si Pedro to “Sir, madoyow su kani koy man. Dow pahimuhon koy nu to tatou no pinayag awos oglogoban kow aw si Moises aw si Elias aw ikow.” ");
INSERT INTO did_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","No malituk ni Pedro tinakin to nasaungan kandan to gabun no ogsilawon kandan to pag-ahà. Na du-on nadinog dan to kagi no niglikat to gabun no na-iling to “So-idi to nalogonan ku lagboy no Anak ku no naliyagan ku lagboy. Kandin to ogpaminogan now.” ");
INSERT INTO did_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Pagkadinog dan to kagi no niglikat to gabun, namakalangkob kandan su nangkahadok man kandan. ");
INSERT INTO did_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Pigduguk ni Jesus sikan namakalangkob aw tudi-a aw ikagihi to “Sakindog kow. Konà kow ogkahadok.” ");
INSERT INTO did_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Paglingì dan pigboong dan on kan daduwa no ka-otow no mgo lagsoban to Diyus. Iyan nandà nabitas no nakita-an dan si Jesus. Na dayun nighipanow on kandan aw si Jesus no namanpatugpù to untud. ");
INSERT INTO did_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","No diyà pad kandan to pangindanan nigbahog si Jesus no nig-iling to “Monang now itutuwanon to nakita-an now ko mamatoy ad aw buhayon ad gayod no Tumutubus to Ka-otawan.” ");
INSERT INTO did_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Na namang-ikagi to mgo pangabaga din to “Dì to mgo mag-a-anad to tinu-uhan no nangkama-an to kasulatan no tahan, og-iling kandan to ‘Monang ogpakalogwà to Imananan to Ka-otawan ko dumatong pad si Elias.’ Ma-amonu man buwa no pig-iling dan to angod sikan.” ");
INSERT INTO did_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Nigtabak si Jesus to “Ogdatong pad iyan si Elias no og-uliman tibò awos mahina-at to daan no igbayà to Imananan to Ka-otawan. ");
INSERT INTO did_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nigdatong on iyan si Elias, dì wadà man kakilaa kandin, dì natumanan dà nasì kandin to pagbo-ot to otow. Ogbo-otan a dan gayod no Tumutubus to Ka-otawan to angod dà kan nadoogan ni Elias.” ");
INSERT INTO did_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Bali dan kadaagi to si Juan na-an no Magbobonyagay to napa-atubangan ni Jesus to pag-ikagi din. ");
INSERT INTO did_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Na pagdatong dan diyà to kahan-ingan to ka-otawan no nigtagad kandan, nigduguk to songo otow aw luhud diyà kandin aw ikagi to ");
INSERT INTO did_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Sir, ka-ati a nu dà ubag su kan batà ku, nasakit to abuy no nalagbayan on kandin to pagkalisodi. Ogpakasinugba to logdog aw ogpaka-inusbug gayod diyà to wohig. ");
INSERT INTO did_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Pigdaa kud on diyà to mgo sakup nu su awos ogpagawangan kud podon kandan dì konà dan ogka-amuhan.” ");
INSERT INTO did_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Nig-ikagi si Jesus to “Iyu no kadongan ku no bugtì to ginhawahan, naugoy on to pagpang-anad ku iyu dì wadà kow pad tu-u lagboy Amonuhon ku buwa. Daaha dini kanak to batà nu.” ");
INSERT INTO did_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Dayun pigsugù ni Jesus kan busow to ogpagawangon. Na nakagawang aw ka-uli-i to batà. ");
INSERT INTO did_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Na nigduguk to mgo pangabaga din diyà ki Jesus no pigpa-awayan dan pig-usip diyà kandin no namang-iling to “Nokoy man buwa no wadà koy man makagawang to busow.” ");
INSERT INTO did_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Nigtabak kandin, “Wadà kow makagawang su manawà man to pagtu-u now to Diyus. Ko ogtu-u kow, agad magabudbud dà to pagtu-u now, dì ko ogsugù kow so-idi untud to ‘Mahalin ka diyà to kadiyu-an,’ ogkatuman man dayun. Ogkahimu dà to agad nokoy no kaboonganan, ko tumu-u kow lagboy su ko tumu-u kow wadà konà now ogkahimu. ");
INSERT INTO did_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Dì so-idi no busow to konà ogkagawang ko konà kow ogpangamuyù lagboy to Diyus aw pu-asa kow su sikan dà to ogpaka-ulì kan no sakit din no ingkabogoy kan no busow.” ");
INSERT INTO did_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Na nighihimun mandà to mgo pangabaga ni Jesus diyà to Galiliya awos matitibò kandan to paghipanow. Nig-ikagi si Jesus to “Kanak no Tumutubus to Ka-otawan, imomo-ot ad on ogdaahon diyà to oghimatoy kanak. ");
INSERT INTO did_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Dì pagkatatouhi no adow, ogbuhayon a dà.” Nangkapook-pook to mgo pangabaga din to pig-ikagi ni Jesus. Na namanghipanow on kandan padoog diyà to Kapirna-um no lunsud. ");
INSERT INTO did_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","No pagkadatong dan du-on to Kapirna-um, pigduguk si Pedro to otow no ogsukut to igpa-amut to simbahan. Kagi din “To mata-as now, dow konà buwa og-amut to simbahan?” ");
INSERT INTO did_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Nakatabak si Pedro, “Og-amut dà man.” Pagdatong dan diyà to baoy, inusip ni Jesus si Pedro to “Nokoy to domdom nu bahin to pagsukut to buhis to nigsingkabugtì no mgo sinakupan dini to babow to kalibutan. Ko pananglitan intawa lagboy to ogkasukutan to mgo ma-aslag no mgo otow, dow kandan no mgo batà dow diyà kan mgo dampà dan pad.” ");
INSERT INTO did_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","“Kan mgo dampà dan pad iyan,” to intabak ni Pedro. “Tùtu-u iyan,” to kagi ni Jesus. “Mano iyan ogpakabayad to mgo dampà dan pad, na og-agad dà iyan no ogkalipwasan to mgo batà to pagbayad. ");
INSERT INTO did_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Agad ita no batà to Diyus, ogpakabayad ki dà to igpabayad ita to otow no nigsakup ko masawa-an ki to mgo otow no wadà labot to pagsakup to Diyus. Kaling man ogpakapudut ki to igkabogoy ta to simbahan. Na Pedro, ogpangawad ka diyà to dagat. To tugdow no ogtubug, bugkuta. Ko lingaton nu to kawad, ogkakita-an nu to songo sapì du-on to bàbà. Puduta aw ibayad sikan to bogayanan ta to simbahan su litos on man sikan no igbayad ta tibò.” ");
INSERT INTO did_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Na pagkaugoy-lugoy nighihimun to mgo pangabaga ni Jesus aw masig-usip kandan ki Jesus to “Intawa dapit to labow tibò kanami diyà to sinakupan to Diyus.” ");
INSERT INTO did_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Dayun pigpaduguk ni Jesus to batà aw patonga-a din du-on kandan ");
INSERT INTO did_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","aw ikagi kandin to “Monang kow ogpakasood to pigsakupan to Diyus ko ma-usab pad to ginhawahan now aw ogpaka-angod kow to batà no hanuut. ");
INSERT INTO did_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","To lagboy dakoo to pigsakupan to Diyus diyà to langit, sikan, ogpakobos kandin aw ogpaka-angod so-i batà. ");
INSERT INTO did_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ko ogdawaton now to otow su sakup ku, agad masagkop kandin no angod so-idi no batà, iyan ogka-angodan now to ogdawat kanak. ");
INSERT INTO did_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Dì to ogpasuwoy to ma-intok no otow no nigtu-u kanak, mahawoy dà ko pa-usbugon kandin diyà to bulibuwan to dagat no oglawigan to batu to li-og. Dì malisod lagboy ko kastiguhon kandin to Diyus to mahudi no adow. ");
INSERT INTO did_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Tahan to otow dini to babow to kalibutan no ogbogayan to pa-antihan dow ogpakasaà dì aboy to otow ko ogpasaa-on din to duma.” ");
INSERT INTO did_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Na impananglitan mandà ni Jesus no nig-iling to “Ko makasaà ka to boad, madoyow pad nasì ko tampodon nu to boad aw itimbag. Manginun pad ogpakasood ki to sinakupan to Diyus agad nakipangan ki dow pungkù ki, ayaw ki ikasugba diyà to logdog no wadà kaposokanan, agad kokobongan ki aw boboadan ki. ");
INSERT INTO did_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ko makasaà ka to mata, madoyow pad ko lugiton aw itimbag. Madoyow pad ko ogsood to sinakupan to Diyus agad dibauy dà to mata. Ayaw ki ikasugba diyà to kastiguhanan to saà no impirnu, agad mamatahan kid. ");
INSERT INTO did_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Doydoyow kow sikan mgo batà. Konà now ogpasagkopon so-idi mangka-intok no mgo otow su to diwata no pigpabantoy kandan to Diyus, kanunoy ogpaka-inandiyà to atubangan to Diyus no Amoy ku diyà to langit, ");
INSERT INTO did_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","su kanak no Tumutubus to Ka-otawan, iyan ing-andini ku to kalibutan su ogpanganapon ku to natanak no mgo otow no sakup ku podon. ");
INSERT INTO did_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ko pananglitan to tagbuhì, moydu-on songo gatus no mgo buhì din no karniru. Nigpamàpà kandan, dì nakasuwoy to songo bu-uk. Nokoy to oghimuhon to tagbuhì. Ogkapabay-anan din dà to kasi-aman aw si-am diyà to pigpamàpa-an aw iyan kapa-aag din kapanganap kan sobu-uk no nakasuwoy. ");
INSERT INTO did_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ko makita-an din on wadà ogpakasokod to pagtukhow din agad pigtukhawan din gayod kan kasi-aman aw si-am no wadà makasuwoy. ");
INSERT INTO did_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Kaling man konà no pagbo-ot to Diyus no Amoy ku diyà to langit to ogkagawang to mangka-intok no otow, agad songo bu-uk. ");
INSERT INTO did_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ko moydu-on kasing-tumutu-u nu no moydu-on saà diyà ikow, ogtongopan nu pad na-ay to pagnangon nu kandin to saà din diyà ikow. Ko pumaminog man kandin, ogpa-uli-on nu dà to kasing-tumutu-u nu. ");
INSERT INTO did_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ko konà ogpaminog, ogpaduma ka to sobu-uk no kasing-tumutu-u nu dow daduwa su awos ogkamatu-ud to tibò to pagbaaw-baaw agad-agad to kasulatan ta. ");
INSERT INTO did_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ko konà pad ogdawat kandin to kandan paghusoy, diyà now inangon to kahimunan to tinu-uhan. Ko konà pad mandà ogdawat kandin to kandan pagbo-ot, konà now ogpapanginlaboton kandin to iyu no sinakupan dì oghinangon now nasì no otow no wadà labot to Diyus aw nigpagkablang iyu. ");
INSERT INTO did_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Iyu no sinakupan ku, to pagbo-ot now no nasusukun-sukunan now no nangkahimun, agad otow kow dà dì ogkamatu-ud to Diyus no Amoy diyà to langit, su to ogbogkoton now dini to pasak, ogkabogkot dà gayod diyà to langit, aw to ogbadbadan now dini to pasak, ogkabadbadan dà gayod diyà to langit. ");
INSERT INTO did_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Dini to pasak, iyu no sakup ku, agad daduwa kow dà dì ko ogka-uyun kow no iyan ogkasusukunan now to pagpangamuyù to Diyus no Amoy diyà to langit, ogkatuman dà. ");
INSERT INTO did_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Agad daduwa kow dà dow tatou, dì ko ogtatagbu kow awos og-ampù kanak, ogpagtibò a man iyu.” ");
INSERT INTO did_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Na nigduguk si Pedro aw usip to “Sir, ko moydu-on saà to kasing-tumutu-u ku dini kanak, ando-i buwa to ogkapanggadan to pagpasaylu ku kandin, kotob buwa to kapitu?” ");
INSERT INTO did_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Nakatabak si Jesus to “Hantod to kapitu-an no kapitu to pagpinasaylu nu su labow pad to kadodoog to pigsakupan to Diyus. ");
INSERT INTO did_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Na to pagsakup to Diyus, iyan na-angodan to songo harì no nigbalansi to mgo utang to mgo sakup din. ");
INSERT INTO did_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","To tugdow no pigtawagan din, pagbalansi din moydu-on utang din no pila no maan. ");
INSERT INTO did_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Dì wadà din kabayadi. Impabaligyà din podon sikan no songo minyò no udipon din tibò aw katu-unan dan tibò awos mabayadan to tibò utang din. ");
INSERT INTO did_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Dì nakaluhud kan no sakup din aw makapangamuyù to ‘Sir, palugwayi a nu pad na-ay su ogpanganap a pad to igkabayad ku ikow su ogbayadan ku tibò sikan.’ ");
INSERT INTO did_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Na pigpasaylu din tibò su pigka-atan din man. ");
INSERT INTO did_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Dì sikan dà no sakup, niglangub nigpatiduguk iyan to kandin kasing-sakup no moy utang diyà kandin no songo gatus dà aw tongà aw alikmata din dagwata kandin aw pinggoa din aw ikagi to ‘Ikow, bayadi a nud to utang nu!’ ");
INSERT INTO did_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nakaluhud to kasing-sakup din aw makapangamuyù kandin to ‘Palugwayi a nu pad ubag na-ay su ogbayadan ku tibò iyan ikow sikan!’ ");
INSERT INTO did_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Dì wadà din palugwayi. Impapirisu din nasì hantod to makabayad tibò. ");
INSERT INTO did_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Pagkama-an to mgo kasing-sakup din to napugut-pugutan, napook-pook kandan aw maka-andiyà kandan to mata-as dan no harì aw nangon kandan tibò to nadoogan to duma dan. ");
INSERT INTO did_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Dayun pigpatawagan din kan sakup din aw ikagihi to ‘Bugtì ka na-an no sakup ku. Pigpasaylu ku ikow to utang nu tibò su nigpangamuyù ka kanak. ");
INSERT INTO did_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nokoy man no wadà nu pasayluha to kasing-sakup nu. Pigpasaylu nu podon angod to pagpasaylu ku ikow.’ ");
INSERT INTO did_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Konad no langot din diyà kan sakup din aw ipapirisu aw ipapanakit-sakit hantod mabayadan to utang din tibò. ");
INSERT INTO did_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Na ogkapatumanan kow tibò gayod angod kan to Amoy ku diyà to langit ko konà now ogpasayluhon diyà to ginhawahan now to kasing-otow now.” ");
INSERT INTO did_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Na pagkatapus ni Jesus to pagpang-anad diyà to Galiliya no banwa, nighipanow on mandà no ogtu-ud diyà to Hudiya no nigpanlawang-lawang to mgo kadihipagan to Hurdan no wohig ");
INSERT INTO did_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","aw kanunoy nadumahan to kahan-ingan aw tibò din kangka-uli-i to mgo nangkasakit. ");
INSERT INTO did_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Na nigduguk to mgo Parisiyu su ogpangindakop kandan podon to kagi-kagi ni Jesus no ogpakasuwoy. Pig-usip dan, “To kasugu-an ni Moises, dow ogkatugutan to mag-asawa to ogkabinolagay to agad ma-intok dà to mahipugti-an?” ");
INSERT INTO did_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Intabak ni Jesus to “Dow wadà kow makabasa du-on to kasulatan to Diyus to kapinunu-an pigbotad to Diyus to otow, lukos aw buyag no ogkasobu-uk ");
INSERT INTO did_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","aw kagi to Diyus to mano pigbotad din to lukos aw buyag no ogkasobu-uk, to otow no og-asawa, ogpagluwatan din to amoy din aw inoy aw pagtibò to asawa din aw ogkasobu-uk kandan. ");
INSERT INTO did_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kaling man konad on no daduwa kandan. Na-angay on kandan no sobu-ukon. Kaling man to pigpagtibò to Diyus, konà ogkapagbolag puli to otow.” ");
INSERT INTO did_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Pig-usip to Parisiyu to “Nokoy man no pigtugutan ni Moises to otow to ogpagbolag kandin to asawa din ko mabogayan din to sulat no kalig-onan to wadà pig-abin to pag-a-asawa dan.” ");
INSERT INTO did_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Nakatabak si Jesus to “Imbogoy puli iyu ni Moises sikan no ka-at su tahan din natagahan to ma-oyow-oyowon kow no otow to sugù to Diyus. Dì konà no sikan to napikiyan tahan to Diyus. ");
INSERT INTO did_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","To otow, ko og-oyowan din to asawa din no una to agad wadà saà, gawas ko ogpalibug to asawa, aw asawa to bugtì, ogkalap-angan din to pag-a-asawa dan.” ");
INSERT INTO did_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Na nig-usip to mgo pangabaga ni Jesus to “Ko sikan to kadodoog to igkabinolagay to mag-asawa, madoyow pad buwa ko konà ki og-asawa.” ");
INSERT INTO did_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Nakatabak si Jesus to “Moydu-on otow no pigbo-otan to Diyus no konà kandin og-asawa. Madoyow man sikan gayod. Dì duma no mgo otow, konà no litos, ko konà mabo-otan kandan to Diyus. ");
INSERT INTO did_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Moydu-on otow no nadonganan to pagka-otow din no moydu-on piglikatan to konà ogpaka-asawa. Moydu-on gayod pigbo-otan to duma no kandin, konà ogpaka-asawa. Moydu-on gayod nigbo-ot to kandin, ogpahimu no konà ogpaka-asawa su nigpasalig to ogpinuna-us to mgo kahinang-hinang to pigsakupan to Diyus. To otow no ogpakapasalig to kandin, konà og-asawa, ogtugutan man kandin.” ");
INSERT INTO did_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Na moydu-on mgo otow no namandaa to mgo batà diyà ki Jesus su igpadampon dan aw pa-ampu-i ki Jesus to Diyus kandan. Dì to mgo pangabaga din, pigsasapadan dan podon sikan namandaa to batà. ");
INSERT INTO did_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Dì nig-iling si Jesus to “Ayaw now balataka to mgo batà. Paduguka now nasì dini kanak. To sinakupan to Diyus, iyan ogka-angodan sikan mgo batà no mgo hanuut.” ");
INSERT INTO did_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Dayun pigpandampon din to mgo batà. Pagkatapus to nandampon, namanhipanow on kandan si Jesus. ");
INSERT INTO did_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Na moydu-on otow no batà-batà pad no naliyag to impang-anad ni Jesus. Nigduguk kandin aw iling to “Sir, nangoni a dow nokoy to matuwadong no ogkahimu ku awos mabogayan a to kinabuhì no konad ogkawadà.” ");
INSERT INTO did_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Nakatabak si Jesus to “Nokoy man no nig-usip ka kanak bahin to matuwadong su Diyus dà man to matuwadong lagboy tibò. Ko maliyag ka to ogbogayan ka to kinabuhì no konad ogkawadà, ogtuman ka to kasugu-an ni Moises du-on to kasulatan to Diyus.” ");
INSERT INTO did_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Nig-usip kandin to “Nokoy sugu-a to igpatuman nu kanak.” Nigtabak si Jesus to “Ogtumanon nu so-idi no pig-iling to ‘Konà ka ogpanghimatoy aw konà ka ogpanlibug. Konà ka ogpangawat aw konà ka ogbotang-botan g. ");
INSERT INTO did_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Igtahud nu to amoy nu aw inoy nu. Oglogonan nu to kapadihu nu angod dà to paglogon to lawa nu.’ Na sikan to ogkangkatagonan.” ");
INSERT INTO did_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nakatabak kandin, “Sikan no kasugu-an to Diyus, sikan on iyan to tahan kanak nagimatahan aw natagonan kud iyan lagboy sikan. Dow moydu-on pad ogboongon ku?” ");
INSERT INTO did_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Nigtabak si Jesus to “Ko matibò nud matuman, ipambaligyà nud to tibò no mgo katu-unan nu aw ipambogoy to sapì diyà to mgo nawada-an aw oghina-atan ka to Diyus to ayama-an nu diyà to langit. Ko makatuman ka sikan tibò, kayan ulì ka dini aw pasakup kad bali kanak.” ");
INSERT INTO did_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pagkadinog kan otow to ing-udlin ni Jesus, naduyong-ot kandin aw hipanow on puli su datù man kandin. ");
INSERT INTO did_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Na nig-ikagi si Jesus diyà to mgo pangabaga din, “Malisod iyan to mgo datù no konad podon ogpasakup to Diyus! ");
INSERT INTO did_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Konà now ogkalingawan to malisod iyan to datù no otow no ogpasakup podon diyà to Diyus. Mahawoy dà nasì ko ogpalusuton to kamilyu no kina-aslagan no buhì du-on to lugì to dagom!” ");
INSERT INTO did_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Du-on nangkaboong-boong to mgo sakup ni Jesus to pig-ikagi din aw mamaka-ikagi kandan to “Agaw man malisod lagboy to ogpasakup to mgo otow to Diyus su wadà buwa ogbay-awon no otow to mahudi no adow!” ");
INSERT INTO did_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Nig-ahà si Jesus diyà kandan aw ikagi to “Ko otow dà puli, konà ogka-amu, dì to Diyus, wadà malisod, agad nokoy, ogka-amuhan din.” ");
INSERT INTO did_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Na tahan moydu-on ig-usip podon ni Pedro. Pagkadinog din to pig-ikagi ni Jesus, pighutoy din to pag-usip ki Jesus no nig-iling to “Na Sir, kanami kunto-on, pig-oyowan noy on to katu-unan noy tibò aw duma koy on ikow. Nokoy on buwa to ogka-iman noy no igbaos nu kanami.” ");
INSERT INTO did_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Nakatabak si Jesus, “To mahudi no adow to sinakupan to Diyus, kanak no Tumutubus to Ka-otawan, igbotang a to Diyus no ogsakup to kalibutan no bayà pad ogka-uliman to banwa. Iyu gayod no mgo pangabaga ku, igpambotang kow gayod no ogsakup to kasinugpu-an ni Israel no sampuù tag duwa no panon. ");
INSERT INTO did_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Agad intawa, ko oyowan din to amoy, inoy, mgo su-un, mgo batà, baoy aw pasak ugpat kanak ngadan, ogkadawat din to kinabuhì no konad ogkawadà. Aw to ogkadawat din no igbaos, ginatus-gatus. ");
INSERT INTO did_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Kunto-on mahan-ing to ogkaliyag ogpalabow, dì to mahudi no adow ogpakapasagkop nasì kandan. Mahan-ing gayod to masagkop kunto-on, dì to mahudi no adow, ogpakalabow kandan.” ");
INSERT INTO did_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Na impananglitan ni Jesus to angod to nigtanom to paras no tanom no bawbagon no ogbogas to ogkako-on. Kagi din to “To pagsakup to Diyus, iyan ogka-angodan to tagtu-un to kaparasan no pagkahinug to bogas, nigsoom-soom kandin nighipanow no nigpanganap to ogpamakotuhon din to paras. ");
INSERT INTO did_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Pagkakita din nigsusukun kandan aw ka-uyuni to tag songo sapì to igbayad kandan to adow dan su tahan dan man du-on sikan no banwa. Paghi-uyun dan, pigpatalabahu din kandan no mabukas. ");
INSERT INTO did_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Na nig-andiyà to tagtu-un to kaparasan to palingki to matikang to soga. Nakita-an din du-on to mgo otow no wadà mgo talabahu. ");
INSERT INTO did_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Pig-ikagihan din to ‘Ogpatalabahuhon ku iyu diyà to kanak kaparasan. Ogbayadan ku iyu agad-agad to katahanan ta.’ Dayun namantalabahu kandan diyà to kaparasan. ");
INSERT INTO did_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Pinasudsud din to pagpatalabahu to mgo otow no wadà talabahu to ma-ugtu to soga aw gayod mgo alas tris. ");
INSERT INTO did_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Na pag-andiyà din mandà to palingki to mahapun, moydu-on pad mgo otow du-on no wadà mgo talabahu. Kagi din to ‘Nokoy man no puli kow man namansakindog no ogka-uwakan on man to adow.’ ");
INSERT INTO did_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Namantabak kandan, ‘Wadà man otow no nigpatalabahu kanami.’ Kagi to tagtu-un to kaparasan, ‘Na, ogpatalabahuhon ku gayod iyu.’ ");
INSERT INTO did_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Pagkahapun on lagboy pigsugù kan tagtu-un to kaparasan to sakup din no sinaligan din no nig-iling to ‘Ogpanghimunon nu to mgo nigpangotu to paras aw pambayadi aw ogpapunu-on nu kan mahudi aw pa-abaya kotob diyà kan una no pigpamatalabahu ku.’ ");
INSERT INTO did_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Dayun pigpamahimun dan kan mahudi. Pigpambayadan kandan to tag songo sapì agad monang nakapunù kandan no mahapun on. ");
INSERT INTO did_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Pagkahimun to una no nigtalabahu, intobo-ot dan dow labow-labow pad to ogkadawat dan du-on to pig-uyunan dan. Dì wadà man su pagbayad kandan, iyan dà pig-ontopan to na-uyunan dan no tag songo sapì. ");
INSERT INTO did_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pagkadawat dan to bayad kandan, namankiyaw-kiyaw kandan diyà to magbobo-ot to kaparasan to wadà dugangi to na-uyunan dan tahan no bayad kandan. ");
INSERT INTO did_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Kagi dan, ‘Songo uras dà man to pagtalabahu to mangkahudi. Dì pigpag-unawa nu dà to pagbayad kanami tibò agad kanami no naka-una aw kaboad koy pad lagboy to soga aw puguti koy to adow to pagkagukù to pagpangotu to paras.’ ");
INSERT INTO did_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Pagkadinog to tagtu-un to kaparasan to namankiyaw-kiyaw kandan, nig-ikagi kandin to ‘Wadà ku pakabusi iyu, Lagi. Dow wadà now buwa ka-uyuni to igkabayad no tag songo sapì dà man to songo adow. ");
INSERT INTO did_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Na ogdawaton now to iyu no bayad aw ulì kow on. ");
INSERT INTO did_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Kanak to ogbobo-ot to paggastu to kanak sapì. Dow namahayan a now buwa su kanak, pigka-atan kud kandan.’ ");
INSERT INTO did_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Na to ogpaka-una on kunto-on, ogkamahudi on nasì to mahudi no adow. To mahudi on kunto-on, ogpaka-una kandin to mahudi no adow.” ");
INSERT INTO did_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Na namanhipanow on kandan si Jesus aw kaluyudi to kahan-ingan padoog diyà to Hirusalim. No diyà pad to pangindanan, pigtumaag ni Jesus to mgo pangabaga din no sampuù tag duwa su awos makapagtongop makapagbaaw diyà kandan. Pigtongopan din to pag-ikagi to mgo pangabaga din no nig-iling to ");
INSERT INTO did_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Moydu-on ignangon ku iyu. Ogpaka-andiyà kid on to Hirusalim. Kanak no Tumutubus to Ka-otawan, igkabaligyà a to sakup ku dà diyà to mgo punu-an to tinu-uhan aw puli a oghimuhon no himatayanan. ");
INSERT INTO did_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Sikan mgo punu-an gayod, ogdaahon a dan diyà to ukum no taga-Ruma no nakasakup ita. Sikan mgo taga-Ruma, ogpamandugadi kanak aw ogbunaa kanak, aw himatayi a su igtutuk a diyà to kinurus. Dì pagkatatouhi no adow, kanak, ogbuhayon a dà man.” ");
INSERT INTO did_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","No wadà pad datong diyà to Hirusalim, dinuguk si Jesus to asawa ni Sibidiyu no pigdumahan to anak din no si Santiago aw si Juan. Nigluhud kandin diyà to atubangan ni Jesus su moydu-on ogpangamuyu-on din. ");
INSERT INTO did_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Kagi ni Jesus to “Nokoy to ogpangamuyu-on nu kanak. Ikagiha man dow nokoy.” Nigtabak kandin to “Sir, ko mahimù, igbotang nu so-idi mgo anak ku no daduwa no pangabaga nu no ogpakasunù ikow to timpu to pagkaharì nu.” ");
INSERT INTO did_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Nig-ikagi si Jesus to “Wadà ka kataga dow nokoy to ogdatongan sikan ko ibogoy ku iyu to katondanan no ogkahimu now no ogpakasunù kanak. Moydu-on og-abut kanak no kalisodan. Madaas ad oghimatayan. Dow ogpakatuwa-ay kow ko maka-abut iyu to kalisodan no ogpaka-angod to kanak kalisodan?” Nakatabak kan daduwa to “Ogpakatuwa-ay koy man.” ");
INSERT INTO did_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Kagi ni Jesus to “Ogkalisodan kow iyan no ogpaka-angod to kanak pagkalisodi. Dì konà no kanak to ogbobo-ot to kabahinan to mgo otow ko magotò to pagkaharì ku su tahan on pigbo-otan to Diyus no Amoy ku.” ");
INSERT INTO did_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Pagkadinog kan sampuù no pangabaga din to nigpalabow-labow on podon kan daduwa nigpatahadi, naboù kandan. ");
INSERT INTO did_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Dayun pigpaduguk ni Jesus kan sampuù tag duwa aw iling to “Nama-anan now man to mgo mangka-aslag no mgo otow dini to babow to kalibutan, ogpanda-og-da-og to mgo ka-otawan aw to nangatondanan gayod, tibò dan dampà to sakup dan. ");
INSERT INTO did_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Dì ita, konà no sikan to kadodoog ta su itanow, ko ogkaliyag ki ogpatikang to sinakupan to Diyus, ogpasagkop ki na-ay angod to sugu-onon no dini ki pad to babow to kalibutan. ");
INSERT INTO did_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Itanow no ogkaliyag oglabow, igpabayà ta pad to ogpasagkop angod to allang. ");
INSERT INTO did_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Og-unugon now to kanak batasan no Tumutubus to Ka-otawan. To ing-andini ku to kalibutan su ogbulig a to mgo ka-otawan. Konà a ogpabulig to mgo ka-otawan. Ogbuligan ku to mgo otow no igpabayà to pagpakimatoy ku kandan awos malipwasan to saà.” ");
INSERT INTO did_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Na nigpadayong kandan si Jesus. No pagkalaboy dan on to Hidiku no lunsud namakaluyud mandà to kahan-ingan. ");
INSERT INTO did_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Nabaya-an dan to daduwa no pisok no naman-i-ingkuday diyà to bagibitan to daan. Pagkasabut dan to si Jesus on to ogbayà du-on, nigsingka-ikagi to ma-agbot to “Ka-ati koy nu ubag no sugpù todu-on harì no si David!” ");
INSERT INTO did_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Dì pigsasapadan kandan podon to ka-otawan dì wadà kasapadi. Dì pigpadugang dan nasì to pagsabi su awos ogdinogon ni Jesus no nig-iling to “Sir, sugpù ni David, ka-ati koy nu ubag iyan!” ");
INSERT INTO did_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","No pagkadinog ni Jesus, nakasigkon kandin aw maka-ikagi to “Nokoy to ogpamuyu-on now kanak.” ");
INSERT INTO did_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Nigsingka-ikagi kan mgo pisok to “Sir, ma-uli-an nu podon to mata noy!” ");
INSERT INTO did_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Na du-on kina-atan ni Jesus aw tudi-a to mata dan. Dayun du-on to na-uli-an kandan. Pagka-uli-i kan mgo pisok, namanduma on kandan ki Jesus. ");
INSERT INTO did_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Na namanpadayong kandan si Jesus aw gayod to mgo kahan-ingan padoog diyà to Hirusalim. No nakalongod on kandan diyà to Bitpagi no lunsud no diyà to augan to Ulibu-an no untud, sinugù ni Jesus to daduwa no pangabaga din no nig-iling to ");
INSERT INTO did_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Andiyà kow to lunsud no diyà to kaylu ta pad. Ko makasood kow on to lunsud, ogkakita-an now on to kabayù aw nati din. Hubada now to hikot aw daaha now dini kanak. ");
INSERT INTO did_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Dì ko moydu-on ogsagman iyu, iling kow to ‘Moydu-on ogkadomdoman to Magbobo-ot ta sikan.’ Ogkatugutan kow man dayun.” ");
INSERT INTO did_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Napugut on sikan su awos ogkatuman to pig-ikagi to maglilikwaday no lagsoban to Diyus natodu-on no pig-iling to ");
INSERT INTO did_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Nangoni to mgo taga-Siyun to ‘Ahà kow, ogdatong to Harì now dì danu-an kandin su nati dà to kabayù to ogsakoy-sakayan din. Konà gayod no mada-og-da-ogon to kandin pagsakup.’” ");
INSERT INTO did_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Na natuman to mgo pangabaga ni Jesus to insugù din. ");
INSERT INTO did_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Pigdaa dan to kabayù diyà ki Jesus. Pigsablayan dan to kabayù to kabò dan su awos mahanigan to bagakwang. Tinakin to nigsakoy si Jesus. ");
INSERT INTO did_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","To mgo ka-otawan, pigladladan dan to mgo kabò dan diyà to igbayà din su pagtahud dan sikan. Moydu-on gayod nigpudut to mgo lumboy aw pambotangi du-on to igbayà ni Jesus su awos igpatugu dan. ");
INSERT INTO did_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Moydu-on mgo otow no naman-una kandin. Moydu-on gayod diyà to hudihan din. Tibò kandan namanlangkoà no namang-iling to “Mabuhì, mapanalanginan to sugpù ni Harì David. Labow ka no pigpatubus kanami to Magbobo-ot dini to kalibutan. Masayà ka gayod diyà to langit.” ");
INSERT INTO did_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Na pagkasood ni Jesus to Hirusalim naboong-boong to mgo taga-lunsud aw ka-inusipay to “Intawa buwa lagboy sikan no otawa.” ");
INSERT INTO did_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Namaka-ikagi to kahan-ingan no namakaduma ki Jesus to “Kandin si Jesus no maglilikwaday no lagsoban to Diyus no taga-Nasarit no nasakup to Galiliya.” ");
INSERT INTO did_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Na nig-andiyà si Jesus to labow no simbahan to Diyus. Pagsood din nakita-an din to mgo otow no mamolihay aw mamaligya-ay aw magkakambiyu to sapì. Pigpambohus din kandan aw baliskada din to lamisa to mgo magkakambiyu aw ingkudanan to mamaligya-ay to salapati ");
INSERT INTO did_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","no naka-iling kandin to “So-idi to nasulat diyà to kasulatan no na-ikagi to Diyus no pig-iling to ‘So-idi abutanan ku, oghingadanan to mgo otow to ampu-anan to Diyus.’ Dì iyu, pighimu now nasì no hobonganan to mgo tulisan.” ");
INSERT INTO did_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Na to mgo pisok aw mgo pungkù, nig-andu-on kandan ki Jesus no diyà pad to labow no simbahan aw pasandog kandan. Dayun nangkadoyow kandan. ");
INSERT INTO did_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Agad mgo batà, impababow dan si Jesus no namaka-ikagi to “Mabuhì, sugpù ni Harì David.” Na to mgo punu-an to tinu-uhan, pagkadinog dan to langkoà aw kakita-i dan to kaboonganan no pighimu ni Jesus, konad no mgo langot dan. ");
INSERT INTO did_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Namaka-ikagi kandan diyà ki Jesus to “Dow wadà ka makadinog to impababow ka man to mgo batà?” “Nadinog ku iyan,” to tabak din. “Dow wadà kow buwa makabasa to kasulatan no pig-iling to ‘Ikow Diyus, pig-anad nu to mgo batà aw mgo kabaya-i pad ing-anak no pighimu nud on no ogka-amu lagboy to pagsayà ikow.’” ");
INSERT INTO did_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Na dayun nighipanow on si Jesus no ogpadoog diyà to Bitaniya no lunsud su du-on on to oghibat. ");
INSERT INTO did_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Dì pagkabukas namangpa-ulì kandan si Jesus diyà to Hirusalim. Dì no diyà pad kandan to pangindanan, si Jesus, niglotoy. ");
INSERT INTO did_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Diyà to tibi to kalasada, nakita-an din to igira no kayu no nigdamoo on to dohun. Pig-iman on podon ni Jesus to moydu-on bogas su sikan no kayu, ogdodongan to pagdohuni aw pagkahinug to bogas. Dì pag-ahà din lagboy, wadà man bogas. Dohun dà tumaag to nakita-an din. Kagi ni Jesus, “Konà ka ogbogas kunto-on hantod to wadà katapusan.” No malituk to kagi ni Jesus, niglanos to igira no kayu dayun. ");
INSERT INTO did_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Pig-indanan to mgo pangabaga din aw kaboong-boongi dan. Pig-usip dan si Jesus to “Na-amonu man no tigbayà on man kadaas to inlanos sikan no kayu.” ");
INSERT INTO did_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Nakatabak kandin to “Konà now ogkalingawan to ko tumu-u kow aw wadà pag-ablaya, ogpakahimu kow to ogka-angod to nadoogan kan kayu. Aw hognà pad gayod ko og-iling kow diyà suyà no untud to ‘Magawang ka aw kahalin ka diyà to dagat,’ ogkatuman dà man ko tumu-u kow. ");
INSERT INTO did_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Agad nokoy no ogpangamuyu-on now to Diyus, ogkadawat now iyan ko ogsalig kow no ogbogoy to Diyus.” ");
INSERT INTO did_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Na pagdatong ni Jesus aw mgo pangabaga din diyà to Hirusalim, diyà pa-abut kandan to labow no simbahan. Pagsood dan to simbahan nigpang-anad kandin to mgo ka-otawan. Na to mgo punu-an to tinu-uhan, namanduguk ki Jesus aw iling to “Intawa to nigpahimu ikow to hininang nu. Ando-i makalikat to kabogbogan nu.” ");
INSERT INTO did_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Nakatabak si Jesus to “Moydu-on pad ig-usip ku iyu. Ko makatag-an kow, kayan ignangon ku iyu dow ando-i makalikat to kabogbogan ku no ingkahimu ku to hininang ku. ");
INSERT INTO did_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Na intawa to nigsugù ki Juan to ogpamabonyag to mgo ka-otawan. Diyus dow otow.” Dì kandan, nigka-inusipay no nigtinongopay dow nokoy to igtabak dan ki Jesus. Kagi to sobu-uk, “Ko itabak ta to ‘Diyus to nigsugù ki Juan,’ ig-ikagi din man to ‘Nokoy man no wadà now dawata to ing-anad din.’ ");
INSERT INTO did_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Dì ko itabak ta to ‘Otow dà to nigsugù kandin,’ ogkahadok ki to ka-otawan su pighinang dan si Juan no tùtu-u no maglilikwaday no lagsoban to Diyus.” ");
INSERT INTO did_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kaling man to intabak to mgo punu-an to tinu-uhan to “Indoy ta iyan dow ando-i makalikat to kabogbogan ni Juan no Magbobonyagay.” Nig-ikagi si Jesus to “Su pig-angod now man sikan, na agad man. Konà a gayod ognangon iyu dow intawa to nigpahimu kanak to hininang ku.” ");
INSERT INTO did_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Na impananglitan ni Jesus diyà to kahan-ingan to ka-otawan no nig-iling to “Na ko pananglitan moydu-on tagtu-un to kaparasan no moy daduwa no batà. Pigduguk din to batà din no kakoy aw ikagihi to ‘Ogpatalabahuhon ku ikow to paras kunto-on no adow.’ ");
INSERT INTO did_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Nakatabak to batà no kakoy ‘Konà a Amoy.’ Dì pagkaugoy-lugoy nakasosoo dà aw bali on makatalabahu to paras. ");
INSERT INTO did_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Dayun nig-andiyà to tagtu-un to kaparasan to batà din no hadi aw patalabahuha gayod. Naka-ikagi to hadi to ‘Ho-o Amoy, ogtalabahu a dà iyan to paras.’ Dì to batà no hadi, ampan paningoo-tingoo. ");
INSERT INTO did_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Na,” kagi ni Jesus, “intawa buwa dapit to nigtuman kandan to pagbo-ot to amoy dan.” Namakatabak kan mgo punu-an to tinu-uhan, “Kan kakoy to nigtuman.” Kagi ni Jesus to “Sikan mgo wadà tu-u to ita no katahanan no angod to magsusukut to buhis aw to mgo buyag no iyan dà igkakita dan to sapì to ogpalibug, ogka-unahan kow dan pad to ogpasakup to Diyus ");
INSERT INTO did_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","su pig-oyowan dan to kandan katahani no bugtì. Dì iyu, wadà. Si Juan no Magbobonyagay iyan nig-andini aw pangudlin to ogpa-oyowan iyu to mgo katahanan now no bugtì awos ma-usab to ginhawahan now. Agad makita-an now on sikan mgo wadà tu-u to katahanan ta no bali nangka-usab on to kandan katahani no bugtì, dì wadà now tumana to ing-udlin ni Juan aw wadà kow tu-u.” ");
INSERT INTO did_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Na nig-aboy si Jesus to pagpang-anad no nig-iling to “Na igpananglitan ku mandà iyu to tagtu-un to kaparasan. Pagtanom din inaad din aw dangoni to ligisan to bogas to paras. Pighimuhan din gayod to pinayag no bantayanan. Pigpanghina-at din tibò aw pigpa-uyamu din to kaparasan to mgo otow no puli huwag-on to pag-ugpà. Dayun nighipanow kandin diyà to songo banwa. ");
INSERT INTO did_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Pagbogas on to kaparasan pigpa-andu-on to tagtu-un to mgo sugu-onon din awos pasukuton din podon to kandin bahin. ");
INSERT INTO did_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Dì wadà dan bogayi. Pigdakop dan nasì to songo bu-uk aw bunayi. Pighimatayan to songo bu-uk aw dogpaka to batu to songo bu-uk. ");
INSERT INTO did_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Pigpa-andu-on mandà to tagtu-un to kaparasan to mahan-ing pad no sugu-onon din. Dì angod dà to hininang dan du-on kandan. ");
INSERT INTO did_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Na bali no pigpa-andu-on din to anak din su piggiginhawa din to ‘Ogtahomon ku to igtahud dan to anak ku.’ ");
INSERT INTO did_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Dì pag-abut to anak din no sinugù to ogpasukuton to bahin din podon, namaka-ikagi kandan to ‘So-idid on iyan to anak to mata-as ta. Iyan on ogkahimu no tagtu-un to kaparasan ko mamatoy on to amoy din. Nokoy pad to ogtagadan ta. Kuwà kid on. Oghimatayan tad awos ita on nasì to ogpakatu-un to kaparasan.’ ");
INSERT INTO did_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Dayun pigdadawat dan kandin aw daaha diyà to labas to kaparasan aw himatayi dan. ");
INSERT INTO did_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Na pagdatong kan tagtu-un to kaparasan, og-amonuhon din buwa kan mgo otow no nigbantoy kan paras din.” ");
INSERT INTO did_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Namakatabak kandan to “To mgo otow no dakoo to saà, pigponas din aw ipa-uyamu din on to duma no mgo otow no matuwadong no ogbogoy to bahin diyà to tagtu-un ko og-abut to paras.” ");
INSERT INTO did_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Na pig-usip ni Jesus kan mgo punu-an to tinu-uhan to “Dow wadà kow buwa makabasa to pananglitan to Diyus no nasulat on no pig-iling to ‘To batu no pa-ukdangan podon to baoy, agad intimbag to maghihimu to baoy, dì iyan on pighimu nasì to Diyus no sinaligan no pa-ukdangan. Sikan to nahimu to Magbobo-ot ta aw na-uyunan noy.’ ");
INSERT INTO did_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Na,” kagi ni Jesus, “iyu no mgo Hudiyu, og-agawan kow to sinakupan to Diyus aw ibogoy diyà to mgo otow no pighimu to Diyus no bogayanan su kandan, ogpamantuman to kasugu-an din. ");
INSERT INTO did_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Aw to otow no ogdo-og du-on kan no batu, ogpanlagsik. Ko ogdo-ogan kandin kan no batu, ogkadupuk-dupuk.” ");
INSERT INTO did_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Na sikan mgo punu-an to tinu-uhan no pagkadinog dan to mgo pananglitan ni Jesus, nasabutan dan to kandan to napa-atubangan to kagi din. ");
INSERT INTO did_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Nakadomdom on kandan to ogdakopon dan podon si Jesus. Dì wadà dan kato-odi to pagdakop su ogkahadok to mgo punu-an du-on to mgo ka-otawan su pighimu to ka-otawan si Jesus no maglilikwaday no lagsoban to Diyus. ");
INSERT INTO did_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Na impananglitan mandà ni Jesus to ka-otawan bahin to pagsauhan to harì. ");
INSERT INTO did_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Kagi din, “To pagsakup to Diyus, iyan ogka-angodan to pagsauhan no pighimu to harì no taglukos. ");
INSERT INTO did_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","To mgo sakup din no diyà to songo lunsud, pigpamatawagan din awos makaba-ot to pagsauhan no pighimu to harì. No magotò on to adow no pagsauhan, impamahimun din to sugu-onon din to mgo pigpamatawagan din podon. Dì kandan, naman-oyow. ");
INSERT INTO did_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Pigpaduguk din mandà to sugu-onon din aw ikagihi din to ‘Nangoni todu-on mgo nangkatawagan kud on to, Pumadagas on su nangkahina-at on tibò. Nahimatayan on to baka aw nati no matabà. Nangkahina-at on tibò. Pamadagas kow on diyà to pagsauhan.’ ");
INSERT INTO did_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Dì wadà dan paminoga to impamatawag to mata-as dan aw iyan nasì tumana dan to tu-un dan no kadomdomanan aw asigsusuwoy-suwoy on kandan puli. Moydu-on nig-andiyà to pasak din. Moydu-on nigbantoy to tindahan din. ");
INSERT INTO did_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Sikan namanpakamonang, iyan napikiyan dan to ogdakopon dan to mgo sugu-onon to harì aw bunayi aw himatayi. ");
INSERT INTO did_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Na to imbaos to harì, impaponas din to sundau to tibò no mgo taga-lunsud no namanbunù to mgo sugu-onon din aw ipamasangab to lunsud dan. ");
INSERT INTO did_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Nig-ikagi to harì diyà to sugu-onon din to ‘Nahina-at on to pagsauhan dì sikan mgo otow no pigpamatawagan kud, konad on man no litos no ogkatawag pad su nahimun kud tahan podon dì naman-oyow man. ");
INSERT INTO did_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Andiyà kow nasì to mgo hibaakan to daan aw ko moydu-on ogkakita-an now, pama-andiniha now to pagsauhan ku.’ ");
INSERT INTO did_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Dayun namanghipanow to mgo sugu-onon to harì no niglogob-logob to pag-unug to kalasada aw pamadumaha dan tibò kotob to nakita-an dan agad madoyow aw mado-ot, awos maponù to pa-abutanan to harì to mgo otow to pagsauhan no pighimu din. ");
INSERT INTO did_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Dayun nigsood to harì awos og-aha-on din dow tùtu-u iyan to namanda-on-da-on on to kabò no impapangabò din to pagsauhan to anak din. Dì nakita-an din to songo otow no wadà pad makapanda-on-da-on. ");
INSERT INTO did_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Dayun pig-usip to harì to ‘Lagi, nokoy man to inglangub nu insood to pagsauhan ku no wadà ka man makapanda-on-da-on to kabò no impapangabò ku podon.’ Wadad nahimu no kagi din. ");
INSERT INTO did_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Dayun du-on nig-ikagi to harì diyà to mgo sugu-onon din to ‘Babakusa now kandin to boad aw kobong aw palabasa now kandin dini to sood to baoy aw itimbag now kandin diyà to kadigloman. Diyà ogpakasinogow to mgo otow aw pangagotkot to bag-ang ugpat to pagkasakiti dan.’” ");
INSERT INTO did_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Inhubad ni Jesus to kalitukan to pananglitan din no nig-iling to “Mahan-ing to ogkangkatawagan to Diyus dì ma-intok dà to ogkapilì.” ");
INSERT INTO did_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Na nighipanow on sikan mgo Parisiyu aw susukun-sukun dow amonuhon to pagpangindakop dan to mgo kagi-kagi ni Jesus. ");
INSERT INTO did_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Pigpa-andiya-an dan si Jesus to mgo sakup dan aw mgo sakup ni Hirudis aw ipa-ikagi to “Sir, pigkilaa noy to matuwadong ka no otow aw matul-id to pagpang-anad nu bahin to kasugu-an to Diyus. To pagpang-anad nu, wadà ogpili-on nu no otow agad ma-aslag dow ma-intok. ");
INSERT INTO did_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kaling moydu-on ig-usip noy ikow. Nokoy to domdom nu bahin to pagpabayad ita to mgo buhis diyà ki Harì Cesar no mata-as to mgo taga-Ruma no nakasakup ita. Dow ogkatugutan ki dow konà to kasugu-an dini ita to ogpakabayad ki.” ");
INSERT INTO did_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Dì tahan dà nama-anan ni Jesus to napikiyan dan on to mado-ot su pigsombang dan podon kandin. Kaling man no pig-usip dan si Jesus, intabak din to “Iyu no mangkapakuno n-kunonon no mgo otow, nokoy man no pigbogayan a now to pa-antihan. ");
INSERT INTO did_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ipa-ahà kanak to songo sapì no igpabayad ita to tag songo bu-uk to buhis.” Dayun intagwoy diyà kandin to songo sapì. ");
INSERT INTO did_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Nig-iling si Jesus to “Intawa so-idi inotow-otawa. Intawa tagngadan so-i.” ");
INSERT INTO did_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Namakatabak kandan to “Si Harì Cesar no mata-as to taga-Ruma no nigsakup ita.” Nig-ikagi si Jesus, “Na i-untuu now diyà ki Harì Cesar no taga-Ruma to kandin bahin. Dì i-untuu now gayod diyà to Diyus ta to kandin bahin.” ");
INSERT INTO did_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","No pagkadinog dan to intabak ni Jesus, na-ompongan to mgo Parisiyu aw puli on namanghipanow kandan. ");
INSERT INTO did_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Na pagkaugoy-lugoy nigdatong on to mgo Sadusiyu no wadà tu-u to ogpambuhayon dà to mgo nangkamatoy to mahudi no adow aw tuusa. Pig-usip dan si Jesus no nig-iling to ");
INSERT INTO did_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Sir, agad-agad to kasulatan no kasugu-an ni Moises, ko mamatoy to otow dì wadà pad makapanganak kandan, iyan ogpakapangimau to hadi din. Ko ogpanganak kandan, sikan mgo batà, angay dà sugpù to kakoy din. ");
INSERT INTO did_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Na ko pananglitan, moydu-on pitu no nigsusu-un. Nig-asawa to kakoy. No pagkaugoy to kandan no pag-a-asawa, namatoy kan kakoy dì wadà pad kandan makapanganak. Dayun pigpangimau to nigsunù to kakoy kan buyag. ");
INSERT INTO did_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","No pagkaugoy on mandà namatoy on kan hadi no nangimau, dì wadà pad gayod kandan makapanganak. Sikan mgo hadi no namakasunù, namakapangimau kandan tibò to buyag. Dì angod dà tibò to nadoogan dan no pitu no namansusu-un no tibò dà nangkamatoy, dì wadà kandan tibò makapanganak. ");
INSERT INTO did_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Na kayan pana namatoy to buyag. ");
INSERT INTO did_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Na agad-agad to ikow no impang-anad, ko buhayon on to mgo otow no nangkamatoy to mahudi no adow, intawa dapit to ogpakatu-un to buyag su to pitu no nigsusu-un, kandà man to na-asawa dan.” ");
INSERT INTO did_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Na nigtabak si Jesus to “Nakasaà kow to pigtu-uhan now aw wadà kow makadaag to kasulatan to Diyus aw kabogbogan din. ");
INSERT INTO did_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Wadad otow no og-asawa pad aw igpa-asawa pad to mahudi no adow su iyan on ogka-angodan dan to mgo diwata diyà to langit. ");
INSERT INTO did_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Na bahin to ogbuhayon to Diyus to mgo nangkamatoy aw tuusa, dow wadà kow buwa makabasa to kasulatan no pig-ikagi man to Diyus iyu no pig-iling to konà kandin no ampu-onon to nangkamatoy dì ampu-onon kandin to mgo otow no buhì. ");
INSERT INTO did_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Su nig-ikagi to Diyus no pig-iling to ‘Kanak no Diyus, ampu-onon a ni Abraham aw ampu-onon ni Isaac aw ampu-onon ni Jacob.’ Konad on ogpaka-ampù to Diyus kan mgo otow no nataunan on to pagkamatoy. To ogbuhayon dà, kandan to ogpaka-ampù to Diyus. Diyus, ampu-onon to mgo otow no ogbuhayon dà.” Pagkadinog to mgo Sadusiyu, na-ompongan kandan no mgo Sadusiyu. ");
INSERT INTO did_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Aw to mgo ka-otawan no nakadinog, nangkaboong-boongan dan to kandin impang-anad. ");
INSERT INTO did_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Pagkadinog to mgo Parisiyu to nakada-og si Jesus to mgo Sadusiyu no nangka-ompongan kandan dì nangkahimun on mandà su kandan, og-antihan dan podon ogpangindakopan to kagi-kagi din. ");
INSERT INTO did_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Na to songo Parisiyu no mag-a-anad to tinu-uhan to mgo Hudiyu, nigbogoy kandin ki Jesus to pa-antihan aw ikagi to ");
INSERT INTO did_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Sir, nokoy sugu-a to kamatu-udan lagboy to kasulatan ta no imbogoy ni Moises.” ");
INSERT INTO did_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Nigtabak si Jesus to “To tugdow, pig-iling to ‘Oglogonan now to Diyus no Magbobo-ot now to tibò no tu-un now no domdom aw tibò no pikii now, ginhawa now, aw mgo doson now. Igtibò now diyà kandin.’ ");
INSERT INTO did_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Sikan tugdow no sugù to Diyus iyan kamatu-udan tibò no wadà ogpakasokod. ");
INSERT INTO did_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ikaduwa angod sikan. ‘Oglogonan now to kapadihu now angod dà to paglogon to lawa now.’ ");
INSERT INTO did_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tibò to kasugu-an ni Moises aw duma no maglilikwaday to Diyus, pigtibo-an on no daduwa nandà no kasugu-an angod to logon.” ");
INSERT INTO did_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","No mahimun on to mgo Parisiyu, moydu-on ing-usip ni Jesus kandan. ");
INSERT INTO did_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Kagi din, “Nokoy to domdom now bahin to Kristu no Imananan to Ka-otawan. Intawa to tagsugpù kandin.” Nakatabak kandan to “Si David to tagsugpù kandin.” ");
INSERT INTO did_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Kagi ni Jesus, “Nokoy man buwa no iyan impahingadan ki David to Ispiritu Santu to Magbobo-ot kan no Imananan. Pighingadanan din on to Magbobo-ot su insulat din no pig-iling to ");
INSERT INTO did_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Diyus no Magbobo-ot ku, pig-ikagihan din kan otow no Magbobo-ot ku gayod no na-iling to, Ogpaso-ingon ku ikow kani to kalintu-u ku hantod to ogpababawon ku ikow du-on to mgo kablang nu, aw igpada-og ku ikow tibò kandan.’ ");
INSERT INTO did_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","To otow no Imananan to Ka-otawan, pigkilaa ni David no iyan Magbobo-ot din, dì amonuhon man su sugpù dà man gayod kandin ni David.” ");
INSERT INTO did_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Na to mgo Parisiyu, nangka-ompongan kandan. Likat kandà no uras, wadà nakalangub to pagpang-usip-usip ki Jesus no awos ogpangindakop podon to kagi-kagi din. ");
INSERT INTO did_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","No nang-anad si Jesus to mgo pangabaga din aw sikan kahan-ingan, nig-ikagi kandin to ");
INSERT INTO did_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“To mgo Parisiyu aw mgo mag-a-anad to tinu-uhan no kasugu-an ni Moises, imbotang kandan no magsasaysayay to kasugu-an din. ");
INSERT INTO did_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kaling man ogkatuman now sikan likat ki Moises. Dì konà now og-unug-unugon to mgo katahani dan su wadà dan tumana to kandan impang-anad. ");
INSERT INTO did_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Pagpatuman dan to tulumanon no likat dà to domdom to otow, iyan ogka-angodan to ogkabogatan ki to tagudaa no insangon dan dini ita. Matuu kandan, konà ogpaningoo-tingoo to pagbulig awos ma-agkap podon. ");
INSERT INTO did_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Mangka-unug-unugon kandan to tulumanon awos ogkakita-an kandan to otow no ogsigi kandan ogtuman dì matuu, to domdom dan konà no du-on. Ko ogsimba, ogpamanda-on-da-on kandan su ogpa-ahà-ahà awos konà ogkalingawan to nigsimba kandan aw kahimu kandan no matuwadong. ");
INSERT INTO did_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ogkaliyag kandan gayod to ingkudanan to talahudon diyà to pagko-onan aw simbahan. ");
INSERT INTO did_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ogkaliyag gayod kandan ko mabogayan kandan to tahud diyà to lunsud aw papahingadan to mag-a-anad. ");
INSERT INTO did_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Dì iyu, konà kow ogpahingadan to mag-a-anad aw konà kow ogpalabow-labow su sobu-uk dà to mag-a-anad now tibò. Iyu, u-unawa kow to katikang su nigsusu-un-su-un kow man to pagtu-u. ");
INSERT INTO did_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Wadà otow dini to babow to kalibutan no ogkahingadanan now to amoy ku no pinakadiyus, su sobu-uk dà man to Amoy now diyà to langit. ");
INSERT INTO did_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Konà kow gayod ogpahingadan to gumuguuy su sobu-uk dà man to gumuguuy now no Imananan to Ka-otawan. ");
INSERT INTO did_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Dini itanow, to labow tibò, ogpasugù-sugù tibò. ");
INSERT INTO did_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","To otow no ogpalabow, ogsagkop man nasì. Dì to ogpasagkop, ogpakalabow nasì.” ");
INSERT INTO did_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Pagkatapus ni Jesus to pagpang-anad to ka-otawan, pigpa-atubangan din to kagi din to mgo Parisiyu aw mgo mag-a-anad no nangkama-an to tinu-uhan to mgo Hudiyu. Kagi din, “Iyu no mgo punu-an to tinu-uhan, aboy kow su mapakunon-kunonon kow puli to pagpang-anad to kalitukan no tùtu-u to kasugu-an to Diyus, di ogpambalatak kow nasì to duma no mgo otow no ogsood podon to sinakupan to Diyus. Matuu iyu, konà kow ogsood aw konà now ogpasoodon to duma no ogkaliyag podon ogsood. ");
INSERT INTO did_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Aboy kow no mgo Parisiyu aw mag-a-anad to tinu-uhan no mapakunon-kunonon kow su ogpanlukuhon now to mgo bau no buyag su ogpang-agawan now to baoy dan. Dì puli now on oghaba-on to pag-ampù now to Diyus. Kaling man ogkadugang-dungangan to igbaos iyu. ");
INSERT INTO did_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Nigpa-omot kow dì aboy kow su ogkalinakdoy now to ka-untudan aw ogkatinalipag now to kadagatan awos makasakup kow agad songo bu-uk dà podon kan iyu no tinu-uhan. Dì ko matuman, sakup on iyan lagboy kandin ni Satanas no ogkahinang on no kastiguhonon to saà. ");
INSERT INTO did_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Aboy kow su pisok kow no ogpanghindù kow pad podon to mgo otow no pisok on tahan. Konà kow og-anad to otow to ogpadaan-daan to ogpabalibadon now kandin to insahad din on su nasì kow on nig-anad no nig-iling kow to ‘Ko katinguban no buwawan to simbahan to Diyus to madamoy to otow no igmatu-ud din to pagsahad din no igpabayà to ogpakatumanon din iyan lagboy to insahad din.’ Og-anad kow gayod no nig-iling to ‘Ko simbahan dà to Diyus to madamoy to otow to igmatu-ud din to insahad no igpabayà to mabogat no kagi, konà din ogkatuman to insahad din.’ Dì iyu, puli now on nasì ogpapabay-anan kandin aw papalingawi kandin su intobo-ot now buwa dow kamatu-udan pad nasì to katinguban no buwawan diyà to simbahan to Diyus no abutanan din. ");
INSERT INTO did_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Dì konà man su ognangonan ku iyu no mgo pisok aw konà no matul-id to domdom now, to iyan dà ogpakamatu-ud to simbahan to Diyus to buwawan no nakabotang on du-on tahan. ");
INSERT INTO did_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ko buhì no igsundù now diyà to Diyus to igmatu-ud to otow to pagsahad din no igpabayà to mabogat no kagi din, ogkatuman din iyan to insahad din. Dì ko sangabanan to igsundù du-on to Diyus to madamoy to otow no igmatu-ud din to insahad din no igpabayà to mabogat no pag-ikagi, ogpadaan-daanan now kandin nasì to igbalibad din to insahad din. ");
INSERT INTO did_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Iyu no pisok, dow nokoy to kamatu-udan pad, sikan igbogoy now diyà to Diyus dow sikan sangabanan to Diyus no ogbotangan to igbogoy now diyà kandin. ");
INSERT INTO did_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","To otow no ogdamoy to sangabanan no igmatu-ud din to pagsahad din no igpabayà to mabogat no pag-ikagi, ogtibo-on du-on to imbotang no igmatu-ud din tibò. ");
INSERT INTO did_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","To otow no ogdamoy to simbahan to Diyus to pagmatu-ud to pagsahad din no igpabayà to mabogat no kagi, Diyus gayod no og-abut du-on, kandin iyan to igkapabayà to pagkamatu-ud din. ");
INSERT INTO did_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","To otow no ogdamoy to langit to pagmatu-ud pagsahad din no igpabayà to mabogat no pag-ikagi, ogkadamoy dà gayod to sakupanan to Diyus aw ogkadamoy dà gayod sikan nigsakup no Diyus. Agad nokoy no igkasahad now, ogtumanon now tibò. ");
INSERT INTO did_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Aboy kow no punu-an to tinu-uhan no mangkapakunon-kunonon su matuman-tumanon kow to iyu no tulumanon su ogbinogoy kow to Diyus to sinampuù to agad nokoy no og-abut agad kama-intokanan ubag no angod to a-anag. Dì to kamatu-udan to tinu-uhan ta, pigpabay-anan now puli no angod to pagtahud aw pagka-at aw pagkatibuus to ginhawa diyà to Diyus. Madoyow podon ko matuman now tibò. ");
INSERT INTO did_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Iyu no pisok no oghindù kow pad to mgo otow no pisok on tahan, ogpakahigiton now ubag to kosu du-on to inomon now dì ogpakalam-od kow nasì to kamilyu no buhì no kina-aslagan su kanunoy ogtumanon now to iyu dà no tulumanon, dì to insugù to Diyus, ogpalabayon now on nasì. ");
INSERT INTO did_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Aboy kow no mag-a-anad to tinu-uhan aw mgo Parisiyu no mangkapakunon-kunonon su nakasaà kow to tinu-uhan now su puli now oghugasan to babow to bukug aw palatu. Dì to sood, wadà now hugasi. Dì nakasood iyu to kalogod aw pagpanda-og-da-og. ");
INSERT INTO did_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Iyu no mgo Parisiyu, monang now oghugasan to babow to bukug ko oghugasan pad to sood tugdow. Ko ogkahugasan now on to sood, kayan oghugasan now to babow. ");
INSERT INTO did_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Iyu no mgo Parisiyu aw mag-a-anad to tinu-uhan, aboy kow su mangkapakunon-kunonon kow no mgo otow su iyan ogka-angodan now to lobong no ogpaputi-on to babow awos madoyow to og-aha-on. Matuu du-on to sood, wadà duma ko konà no mgo bokog dà tibò aw maligsom. ");
INSERT INTO did_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ko og-aha-on noy iyu, ogka-intobo-ot noy dow matuwadong kow lagboy. Dì matuu dakoo to saà now aw mangkapakunon-kunonon kow no mgo otow. ");
INSERT INTO did_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Iyu no mgo Parisiyu aw mgo mag-a-anad to tinu-uhan, aboy kow su ogdangonon now to lobong no ogpadayan-dayanan now no ogkadomdoman to maglilikwaday to Diyus natodu-on aw duma no matuwadong no mgo otow natodu-on. ");
INSERT INTO did_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Og-ikagi kow to ‘Ko podon nasakpanan ta to mgo ka-aw-apu-an ta, konà ta man podon og-uyunan to paghimatoy dan to mgo maglilikwaday no lagsoban to Diyus.’ ");
INSERT INTO did_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Dì ton kagi now, nakapabalitù dà iyu su mapakunon-kunonon kow no mgo otow aw sugpù kow todu-on nighimatoy to mgo maglilikwaday to Diyus aw uyuni now todu-on pighimu to mgo ka-aw-apu-an now. ");
INSERT INTO did_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Aboy kow su nig-unug kow to kandan katahani. ");
INSERT INTO did_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Iyu iyan ogka-angodan now to uwod no makamuwa, amonuhon now man to pagdilin to kastiguhanan to saà. ");
INSERT INTO did_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kaling man ogpa-andinihan ku iyu to tùtu-u no mag-a-anad aw mgo nangkama-an no mgo otow to kagi to Diyus, aw mgo maglilikwaday no lagsoban din lagboy. Dì moydu-on oghimatayan now aw itutuk now diyà to kinurus no ogpadodopahon. Moydu-on ogbunaan now diyà to kahimunanan. Ogpang-andiyà kow to kalunsudan awos mapahadatan now to ogpa-andiya-on ku iyu ");
INSERT INTO did_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","no awos kow ogkabaosan to paghimatoy now to mangkatuwadong no mgo otow likat to paghimatoy ki Abil hantod to paghimatoy ki Zacarias no anak ni Barakiyas no pighimatayan diyà to pag-ootan to abutanan to Diyus aw sangabanan to buhì no igsundù to Diyus diyà to solib to labow no simbahan. ");
INSERT INTO did_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","So-idi no kadongan ku, ogkastiguhon kandan to mgo saà dan aw sikan mgo saà gayod to ka-aw-apu-an dan. ");
INSERT INTO did_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Na iyu no taga-Hirusalim, agad himatayan now to mgo maglilikwaday no lagsoban to Diyus aw agad dogpakon now to mgo otow no pigtubuy no pigpa-andini iyu to Diyus, dì ogsakupon ku podon iyu. Su kapila on to paghinimun-himun kud podon iyu aw pasaunga kow angod to manuk no mangunsuy no oglangkob to unsuy din no ogpasaungon din to kamuwahanan. Dì nigsupak kow. ");
INSERT INTO did_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kaling man naboboas-boasan now to banwa now su pig-oyowan kow to Diyus no nigbantoy iyu. ");
INSERT INTO did_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Monang a now pad mandà ogkakita-an ko igkalangkoà now no ogpaka-iling kow to ‘Mabuhì to pigpatubus to Diyus no pigpa-andini din ita.’” ");
INSERT INTO did_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Na niglogwà si Jesus to labow no simbahan aw no imomo-ot on kandin oglikat, dinuguk to mgo sakup din aw pantudli-i to mgo baoy no nalabot to labow no simbahan du-on. ");
INSERT INTO did_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Nig-ikagi si Jesus to “Nokoy man no og-abayon now oghiling-hilingon so-idi mgo baoy no simbahan aw kaboong-boongi now su ogkangkalompag dà man tibò to mahudi no adow. Agad batu no pigpapagdokot-dokot, dì wadà ogkasamà.” ");
INSERT INTO did_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Na nig-andiyà kandan si Jesus to Ulibu-an no untud. No pagtidow dan nig-ingkud si Jesus no sobu-ukon aw namanduguk to mgo pangabaga din no awos tongopan dan to pag-ikagi. Namang-iling kandan diyà ki Jesus to “Dow kagan-u ogkagotò to pagkalompag to labow no simbahan. Nokoy to indananan noy to pag-ulì nu dini aw katapusanan to kalibutan.” ");
INSERT INTO did_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Nakatabak si Jesus to “Bantoy kow. Aw konà kow ogpasuwoy ");
INSERT INTO did_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","su mahan-ing to oglogwà no ogpa-angod-angod puli kanak aw og-ikagi to ‘Kanak to Imananan to Ka-otawan dini to babow to kalibutan,’ aw mahan-ing no mgo otow no ogkangkasakup dan. Ogpamakasuwoy to mgo ka-otawan. ");
INSERT INTO did_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ogkadinog now to panganod-kanod to gubut no madani. Aw ogkadinog now to nawnangonon to nagira on diyà to kadiyu-an. Dì konà kow ogkahadok su maogot man iyan ogkatuman dì konà-konà pad no sikan to kagoto-an to kaliswahanan ");
INSERT INTO did_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","su ogkasamuk-samuk pad to mgo kanasudan aw ogkagubut pad to mgo kalunsudan. Ogtiyogon gayod to nigsingkabugtì no banwa. Ogkogsa-an to bontas to mgo ka-otawan. ");
INSERT INTO did_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Dì tugdow pad sikan to kalisodan to mgo otow dini to babow to kalibutan. ");
INSERT INTO did_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ogdakopon kow aw og-uwang-uwangan kow aw oghimatayan kow. Oghimuhon kow no kablang to tibò to mgo ka-otawan su nigpasakup kow kanak. ");
INSERT INTO did_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Mahan-ing to og-oyow to pagtu-u dan kanak. Mahan-ing to ogkabinaligya-ay diyà to kablang dan aw ogkinablangay. ");
INSERT INTO did_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Oglogwà to mahan-ing no lagsoban no konà no tùtu-u no ogpa-ikagihon to konà no Ispiritu Santu. Mahan-ing to ogpamasuwayon dan. ");
INSERT INTO did_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Su ogdugangan to kado-otan dini to babow aw mahan-ing to ogtawad to logon dan dini kanak. ");
INSERT INTO did_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Dì to oghogot to pagtu-u din hantod to katapusanan, ogpakalangit. ");
INSERT INTO did_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Dì monang og-abutan to katapusanan ko ogkapanaysayan pad to tibò to mgo timamanwa dini to babow to kalibutan to Madoyow no Tutuwanon bahin to pagsakup to Diyus.” ");
INSERT INTO did_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Kaling man, iyu no ogbasa so-idi no diblu, indani now to kalitukan to pig-ikagi ni Jesus bahin ton otow no kablang to Diyus su puli din on ogsoodan to abutanan to Diyus no podon konà din no litos no soodanan no tinag-an ni Daniel no lagsoban to Diyus natodu-on. Nig-iling mandà si Jesus to “Ko kita-on now to puli din on ogsoodan diyà to abutanan podon to Diyus no konà din podon ogkasoodan, ");
INSERT INTO did_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","sikan to ta-indanan now no taga-Hudiya no ogpamakalaguy kow on diyà to ka-untudan. ");
INSERT INTO did_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ko diyà kow to labas to baoy, konà now on ogka-ulì pad to katinguban now. Pamakalaguy kow on puli. ");
INSERT INTO did_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ko ogtalabahu kow diyà to uma, konà now on ogka-ulì pad to ilisan now diyà to baoy. ");
INSERT INTO did_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Aboy to mgo magkabodos aw mgo manggi-anak to ogkalisodan. ");
INSERT INTO did_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ogpangamuyù kow to Diyus to konà podon ogkatuman sikan no kalisodan to timpu amihan dow adow no konà no tigtatalabahu. ");
INSERT INTO did_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Likat to paggihit to Diyus so-idi kalibutan hantod kunto-on aw hantod to wadà katapusan, wadà ogpakasokod to kalisodan to mahudi no adow no ingkanangon kud iyu iyan. ");
INSERT INTO did_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ko wadà pa podon bo-oti tahan to Diyus to ogyopoton din dà sikan no kalisodan, wadad on podon ogkasamà no mgo otow to mahudi no adow. Dì pigbo-otan dà nasì to ogyopoton dà no kalisodan su ogka-atan din to mgo sakup din no pig-abin din tahan.” ");
INSERT INTO did_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Na nig-aboy si Jesus nanoysoy no nig-iling to “Ko moydu-on otow no og-ikagi du-on iyu to ‘Dutun on iyan to Imananan to Ka-otawan,’ konà kow ogtu-u. Ko moydu-on og-ikagi to ‘Kanid on to Imananan to Ka-otawan,’ konà kow ogtu-u, ");
INSERT INTO did_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","su mahan-ing to ogpamanlogwà no ogpamakunon-kunon to kandan, Imananan to Ka-otawan. Mahan-ing gayod to ogpamanlogwà no konà no tùtu-u no maglilikwaday to Diyus. Oghinangon dan to kaboonganan aw mgo ta-indanan to moydu-on kandan kabogbogan, aw mahan-ing to ogpamasuwayon dan agad podon to mgo sakup to Diyus no pig-abin din on tahan. ");
INSERT INTO did_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Dì bantoy kow su nama-anan now on dow nokoy to ogkadoogan sikan odomà su pignangonan kud on man iyu tahan. ");
INSERT INTO did_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Ko og-ikagi kandan to ‘Diyad on to kahanongan no banwa kan Imananan to Ka-otawan,’ konà kow og-andiyà. Ko og-ikagi gayod to ‘Du-on on to baoy no nakasood on dì nighobong,’ konà kow ogtu-u. ");
INSERT INTO did_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Su konà now man oglamanon ko lumogwà ad no Tumutubus to Ka-otawan su mapayag dà, su pag-andini ku iyan ogka-angodan to kiblat to kilat no oglikat to silatan aw oglanyagan hantod to saopan su ogkakita-an to tibò. ");
INSERT INTO did_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Og-indanan now to kagi ku iyu bahin to kagau-an no pagpang-anad su agad ando-i to nahaù, og-agad dà to ogdugukon to uwak, su agad ando-i to otow no mado-ot to ginhawahan, og-agad dà ogpakadawat to impang-anad no kagau-an. ");
INSERT INTO did_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ko matapus kan no mgo kalisodan to mgo otow dini to babow to kalibutan, ogkawadà to bandog to soga aw buwan. To mgo bitu-on diyà to langit, ogkangka-uug. To tibò to mgo ogpansilat diyà to langit, ogpamakasuwoy to tahan dan no baya-anan. ");
INSERT INTO did_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kayan ogkangkakita-an diyà to langit to ta-indanan to pagpa-ulì on to Tumutubus to Ka-otawan. To mgo kasinakupan tibò dini to babow, ogkangkahadok aw kakita-i dan to Tumutubus to Ka-otawan no oglugsad dini to kalibutan no ogliwaw-ang to gabun no ogdumahan to kabogbogan ku aw katuusan ku. ");
INSERT INTO did_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","To mgo sakup ku tibò no pig-abin kud on tahan, igpahimun ku to mgo diwata likat to Diyus to pagpatanug to budyung. Ogmutmutan to mgo sakup ku to binogdokan to langit. ");
INSERT INTO did_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Na ko pananglitan, dini kunto-on to babow to kalibutan moydu-on ta-indanan ta to tinu-ig. Ko ogbogas on to mgo kayu, ogka-indanan tad to tigaas on iyan. ");
INSERT INTO did_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","To mahudi no adow moydu-on gayod ta-indanan now ko madaas on to pagkagotò to pag-ulì ku dini. Pagkagotò to kalisodan to ka-otawan no innangon ku iyu, ogka-indanan now to madaas on to pagpa-ulì ku agad imomo-ot ad oglugsad. ");
INSERT INTO did_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","To mgo sakup ku no ogsakpan to kalinikatan sikan no kalisodan dini to kalibutan no innangon kud iyu aw kakilahi dan kan no ta-indanan, monang iyan ogkamatoy ko matuman on tibò. ");
INSERT INTO did_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Moydu-on dà katapusan to langit aw kalibutan. Dì to kagi ku, wadà katapusan. ");
INSERT INTO did_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Dì sikan no tu-iga aw sikan no adawa no igkagotò, wadà nataga, agad kanak no Anak aw mgo diwata likat to Diyus, su iyan dà nataga to Diyus no Amoy. ");
INSERT INTO did_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","To umulì a no Tumutubus to Ka-otawan, to kadodoog to mgo otow iyan ogka-angodan to timpu to pag-ugub to dagat to kalibutan natodu-on, su kandan dà aw si Noe to nigtu-u to ogkatuman to pag-ugub to dagat su agad innangon on ni Noe tahan to ka-otawan dì wadà dan tu-uhi. ");
INSERT INTO did_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Natodu-on no wadà pad ugubi to dagat to kalibutan, sikan mgo otow dini to babow, ogsigihon dan to kandan no kadodoog no ogko-on to hustu aw inom aw inasawahay agad hantod to nigsood on kandan aw si Noe to arka din. ");
INSERT INTO did_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Dì to mgo otow, monang on namakadaag kandan to nagotò on to adow no nalinop on su wadà dan man tu-uhi aw kaponas tibò su puli natokawan. Kanak no Tumutubus to Ka-otawan, ogpaka-angod a dà su to umulì a dini to kalibutan, konà a ogka-iman to mgo otow. ");
INSERT INTO did_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kandà no uras ogtalabahu to daduwa no ka-otow diyà to uma. Songo bu-uk, ogkabayow. Songo bu-uk, ogkabitas, su konà ku no sakup. ");
INSERT INTO did_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ogbayu to daduwa no ka-buyag no og-a-asod. Songo bu-uk, ogkabayow, dì songo bu-uk, ogkabitas. ");
INSERT INTO did_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Kaling man ogbantoy kow su wadà kow kataga to adow no igkagotò to pag-ulì ku no Magbobo-ot now. ");
INSERT INTO did_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ko pananglitan tagbaoy, ko mama-anan din podon dow nokoy to uras to ogdatong to kawatan, ogpakabantoy kandin podon su gimata pad man kandin aw du-on konà man ogpakasood to baoy din to kawatan. ");
INSERT INTO did_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kaling man hina-at kow su ogkatokawan kow to pag-ulì ku no Tumutubus to Ka-otawan. ");
INSERT INTO did_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Na intawa man to sakup no ogka-amu no ogkasaligan aw matuman-tumanon. Sikan sakup no iyan oghinangon to tagsakup no magbobo-ot to mgo sood din aw pamahanduga to kapookanan diyà to duma no kasakupan din. ");
INSERT INTO did_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ogkaliyag lagboy kan no sakup su to impahinang kandin to mata-as din, to pag-ulì din, natuman din on tahan. ");
INSERT INTO did_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Maogot ogkahimu kandin no magbobo-ot to tibò no pigsakupan din. ");
INSERT INTO did_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Dì aboy sikan sakup no mado-ot no og-iling to domdom din to ‘Maugoy pad buwa to mata-as og-ulì,’ ");
INSERT INTO did_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","aw binunaan din puli to kasing-sakup din aw puli nigpagtibò to mgo hingow diyà to pagko-onan aw pag-inoman. ");
INSERT INTO did_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ogkatokawan puli sikan no sakan no sakup to pag-ulì to mata-as din su wadà din man katagahi dow kagan-u og-ulì to mata-as. ");
INSERT INTO did_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Oggawangon din iyan kan no sakup aw kastiguha din aw ogpa-agpoton din kandin to ogdoogan to mgo mangkapakunon-kunonon no mgo otow. Ogpamakasinogow aw pangagotkot to bag-ang ugpat to pagkasakiti dan kanunoy.” ");
INSERT INTO did_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Na impananglitan mandà ni Jesus to mgo sakup din bahin to pagsakup to Diyus to katapusanan to mahudi no adow no nig-iling to “To pagsakup to Diyus, iyan ogka-angodan to kadodoog to pagpudut to asawahon diyà to songo manwa. Na to pagpudut to otow to asawahon din, moydu-on sampuù no mgo buyag no kadumahan to mangasawa no daga pad no pigtagadan dan to pag-ulì to duma dan no ogpudut to asawahon din. Dì naugoy man kandan naka-ulì no mangasawa. ");
INSERT INTO did_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Sikan mgo daga, piglogoban kandan to ilawan. Lima no ka-daga, mangkapikii su pigdakoo dan tahan to gaas dan. Dì kan lima no mgo duma dan no mgo daga, mgo dagbow to pikii su wadà dan hina-ati dakoa to gaas dan. ");
INSERT INTO did_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","No pagkaugoy to pag-abut to bayà pad no nighitu-un, nangkalipodong sikan sampuù no niglanyag pad to ilawan no nigtagad kandan. ");
INSERT INTO did_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Dì no kabakna-an on to kadukiloman bali on tinawag kandan to ‘Bangun kow on. Kanid on to bayà hitu-un. Ogsalubung kid.’ ");
INSERT INTO did_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Namakabangun kan sampuù no ka-daga aw tatampodi dan to mitsa. ");
INSERT INTO did_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Namaka-i-ikagi kan mgo daga no dagbow to pikii, ‘Dugangi koy ubag to gaas su oghaong-haong on so-idi kanami ilawan.’ ");
INSERT INTO did_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Namakatabak kan mgo daga no mangkapikii, ‘Konà ogkahimù su litos noy dà puli. Boli kow on nasì diyà to tindahan.’ ");
INSERT INTO did_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Dayun namanhipanow on kandan su awos ogpamanboli to gaas. Dì pagkali-us dan nig-ulì on to bayà hitu-un. Dayun namansood kandan tibò to baoy aw kan lima no ka-daga no mangkapikii. Dayun pigtakopan aw himuha to pagsauhan. ");
INSERT INTO did_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Na pagkaugoy-lugoy naman-ulì on kan lima no ka-daga no namanboli pad to gaas. Namantawag kandan to ‘Sir, paponhika koy.’ ");
INSERT INTO did_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Dì natabak din to ‘Wadà labot ku iyu no mgo otow.’ ” ");
INSERT INTO did_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Na diyà pa-atubangi ni Jesus to mgo sakup din to pag-ikagi din no konà ogpa-ablayon kandan no nig-iling to “Na angod dà ogbantoy kow su wadà kow kataga dow kagan-u ogkagotò no tu-iga aw adawa to pag-ulì ku dini to kalibutan.” ");
INSERT INTO did_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Na impananglitan mandà ni Jesus bahin to igbaos din to mgo sakup din ko umulì kandin dini to kalibutan. Kagi din, “To igbaos ku iyu, iyan ogka-angodan to igbaos to songo tagsakup diyà to mgo sakup din pag-ulì din to panow din. Na ogtutuwanan kow pad to paghipanow din. No ililikaton kandin, pigtawagan din pad to tatou no sakup din aw isalig din kandan to tibò to kadatù din no wau no ka-bahin su igpaboli din aw ipabaligyà su awos ogdugang to sapì din. ");
INSERT INTO did_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Sobu-uk, pigbogayan din to lima no ka-bahin. Sobu-uk gayod, pigbogayan din to daduwa no ka-bahin. Songo bu-uk gayod, pigbogayan din to songo bahin dà. Pigpamogayan to mata-as to tag songo bu-uk aw og-ontopan agad-agad to kandan ka-omot to pagboli aw pagbaligyà dan. ");
INSERT INTO did_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Pagkatapus din to pagpamogoy, nighipanow on kandin. Sikan pigbogayan to lima, nigpa-omot dayun aw boli aw baligyà aw nadugangan to lima. ");
INSERT INTO did_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Sikan gayod pigbogayan to daduwa, nadugangan to daduwa. ");
INSERT INTO did_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Dì sikan gayod pigbogayan to songo bu-uk dà, bullug sobu-uk dà su puli din man inlobong to sapì to mata-as. ");
INSERT INTO did_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Pagkaugoy nig-ulì on to mata-as dan aw balansiha din to sapì no impambilin din. ");
INSERT INTO did_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Sikan nabogayan din to lima no ka-bahin, pigpaduguk aw ipadaa gayod to nakadugang no lima. Kagi din, ‘Sir, pigbogayan a nu to lima no ka-bahin. Nadugangan to lima.’ ");
INSERT INTO did_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Naka-ikagi to mata-as din to ‘Naka-unug ka iyan to pagtuman nu. Ogkasaligan ka no sakup ku aw madoyow to nahimu nu. Natuman nu iyan lagboy to insangon ku ikow no katondanan. Ogdugangan ku to ikow no bahin no igkaboli aw ikabaligyà. Na ogpakalabot ka to kanak pagtukhow no magbobo-ot nu.’ ");
INSERT INTO did_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Na pigpaduguk mandà kan nabogayan to daduwa no ka-bahin. Kagi din, ‘Sir, pigbogayan a nu to daduwa no ka-bahin. Nadugangan on gayod to daduwa.’ ");
INSERT INTO did_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Naka-ikagi to mata-as din to ‘Naka-unug ka iyan to pagtuman nu. Ogkasaligan ka no sakup aw madoyow ka. Natuman nu iyan lagboy to insangon ku ikow. Ogdugangan ku to ikow no bahin no igkaboli aw ikabaligyà. Na ogpakalabot ka to kanak pagtukhow no magbobo-ot nu.’ ");
INSERT INTO did_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","25","“Bali no pigpaduguk din gayod to pigbogayan to songo bu-uk dà no bahin. Kagi din, ‘Sir, puli ku inlobong kan imbogoy nu kanak su nakadok a ko matampodan to kadatù nu su lagboy nu man igpa-ung to sugù nu su agad wadà nu i-odok, dì moydu-on dà ogka-ani nu. Agad wadà nu kapasidi, dì moydu-on dà igkabotang nu no bogas.’ ");
INSERT INTO did_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Naka-ikagi to mata-as din to ‘Ikow no bugtì no sakup ku aw mahukow ka su mana-anan nu man to moydu-on dà man ogka-ani ku agad wadà ku itanom aw moydu-on igkabotang ku no bogas agad wadà ku kapasidi. ");
INSERT INTO did_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Nokoy man no wadà nu ibotang to sapì ku diyà to bangku awos podon ogtulin aw moydu-on igkabogoy nu kanak pagdatong ku aw kadugangi pad podon. ");
INSERT INTO did_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Agad songo bu-uk dà to bahin din, dì ogpudutan pad nasì aw ibogoy diyà nasì kan moydu-on tahan sampuù on to bahin. ");
INSERT INTO did_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","To moydu-on bahin, ogkadugangan, awos ogdakoo pad. Dì to poguwon, agad ma-intok to kandin bahin, dì ogkapudutan pad nasì. ");
INSERT INTO did_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Na to sakup ku no poguwon palabasa diyà to kadigloman. Diyà ogpakasinogow aw pangagotkot to mgo bag-ang ugpat to pagkasakiti din lagboy.’” ");
INSERT INTO did_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Na nig-aboy si Jesus to pagpang-anad din bahin to mahudi no adow no nig-iling kandin to “Kanak no Tumutubus to Ka-otawan, ko umulì a dini to kalibutan, oghinangon ad no harì no ogdumahan to mgo diwata likat to Diyus aw mgo kaboonganan to Diyus. Dayun ogbotangan ad to katondanan no kinalabawan su ogkahimu a no harì. ");
INSERT INTO did_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Igpahimun ku to kasinakupan dini to kalibutan aw pa-atubanga su ogbugti-on ku to madoyow aw mado-ot angod to tagbuhì to pagbutì din to kabuhi-an din no nigsingkabugtì, agad karniru aw kambing. ");
INSERT INTO did_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ogpadapiton ku to karniru dini to kalintu-u ku su na-uyunan ku. Dì to kambing, ogpadapiton ku dini to kawaa ku. ");
INSERT INTO did_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Dayun og-ikagi a no harì du-on sikan dini to kalintu-u ku to ‘Na iyu no napanalanginan to Diyus no Amoy ku, kunto-on ogtu-unon now to ugpa-anan diyà to pigsakupan din su pighina-atan kow ontahan to Diyus likat to paggihit din to kalibutan ");
INSERT INTO did_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","su pagbontasa ku, iyu to nigpako-on kanak. No piglanggahan ad, iyu to nigpa-inom kanak. Kanak, otow a no wadà now kakilahi, dì iyu to nigdawat kanak to madoyow. ");
INSERT INTO did_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Wadà kabò ku, dì iyu to nigbogoy kanak to ogkapangabò ku. Nasakit a dì iyu to niglo-uy kanak aw bulig. Pigpirisu a dì iyu to niglo-uy kanak aw alagà.’ ");
INSERT INTO did_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ogpaka-usip kan matuwadong aw matino-od no mgo otow to ‘Dow kagan-u buwa Sir to pagpako-on noy ikow su binontas ka, aw pagpa-inom noy su piglanggahan ka. ");
INSERT INTO did_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Dow kagan-u buwa to pagdawat noy ikow to madoyow agad wadà noy kakilahi. Dow kagan-u buwa to pagbogoy noy ikow to ogkapangabò nu su nawada-an ka. ");
INSERT INTO did_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Dow kagan-u buwa Sir to paglo-uy noy ikow no nasakit aw pigpirisu ka.’ ");
INSERT INTO did_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ogpakatabak a no harì to ‘Ko ogbuligan now to sakup ku no angod to su-un ku, agad kinasagkopan, iyan on ogka-angodan to pagbulig now kanak.’ ");
INSERT INTO did_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Dayun ognangonan ku no harì kan mgo otow du-on to kawaa ku, ‘Gawang kow du-on. Pakapadoog kow on diyà to banwa no kastiguhanan to saà no moy logdog no wadad kaposokanan, agad pighina-atan dà si Satanas aw mgo sakup din agad busow aw diwata din dì sikan gayod to ogkadoogan now. ");
INSERT INTO did_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Su no pigbontas ad, wadà a now pako-ona. No piglanggahan ad dì wadà a now pa-inoma. ");
INSERT INTO did_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Wadà a now dawata su wadà a now kilaha. Wadà kabò ku dì wadà a now bogayi to ogkapangabò ku. Nasakit a aw napirisu, dì wadà a now lo-uya aw alaga-i.’ ");
INSERT INTO did_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Og-iling kandan, ‘Dow kangan-u buwa Sir to wadà koy maka-alagà aw bontasa ka aw paglanggahi nu aw pagkawada-i nu to kabò aw pagkasakit aw pagkapirisu nu no wadà koy bulig ikow.’ ");
INSERT INTO did_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ogpakatabak a no harì, ‘Na to kinasagkopan no sakup ku no angod to su-un ku no wadà now buligi, iyan on ogka-angodan to kanak to wadà now buligi.’ ");
INSERT INTO did_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","To mgo mangkado-ot, ogpamagawangon aw papadooga to banwa no kastiguhanan to saà no wadà katapusanan. Dì to mgo mangkatuwadong, ogpamakalangit.” ");
INSERT INTO did_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Na pagkatapus ni Jesus to impang-anad din bahin to mahudi no adow, pignangonan din to mgo pangabaga din bahin to kandin ogmuwahon. ");
INSERT INTO did_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Kagi din, “Nama-anan now to madaduwa pad no adow kayan ogkagotò to hihinangay to Hinang to Pagpalipas to Kado-otan. Kayan kanak no Tumutubus to Ka-otawan, ogdaahon ad diyà to ukum aw himatayi a no igtutuk no ogpadodopahon diyà to kinurus.” ");
INSERT INTO did_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Na to mgo punu-an to tinu-uhan to mgo Hudiyu, nighihimun tibò diyà to baoy to mata-as dan no si Kaipas ");
INSERT INTO did_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","aw iyan susukuni dan to og-amonuhon dan to pagkumit no ogkadakop dan si Jesus aw kahimatayi. ");
INSERT INTO did_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Na-uyunan dan to ogliwason dan pad to Hinang to Pagpalipas to Kado-otan. Kayan pana ogpadayongon dan to paghimatoy ki Jesus. Kagi dan, “Ogliwason ta pad to Hinang to Pagpalipas to Kado-otan su dagow masamuk to mgo ka-otawan no ogkangkahimun.” ");
INSERT INTO did_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Na og-uli-on tad mandà to tutuwanon ki Jesus no diyà pad to Bitaniya no lunsud no nig-agpot kandin diyà to baoy ni Simon no na-uli-an on to ibung. ");
INSERT INTO did_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Pigduguk si Jesus to buyag no nigdaa to lamita no limut no pighimu likat to batu no madoyow no pighingadanan to alabastru no moydu-on intagù no mahal no hihinaki no mahomut. No nig-ingkud pad si Jesus no nig-atubang to pagko-onan, binus-ugan to buyag to uu din to hihinaki. ");
INSERT INTO did_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","No pagkakita to mgo sakup din to pighimu to buyag du-on ki Jesus, nado-otan kandan aw ka-inusipay to “Nokoy man buwa no puli din on pig-uwakan to hihinaki. ");
INSERT INTO did_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Su sikan no hihinaki, ko napabayluhan pa podon to sapì, konà dà buwa no pila no gatus aw moydu-on pad podon igkabogoy diyà to mgo publi.” ");
INSERT INTO did_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Dì nama-anan dà ni Jesus to ingka-inusipay dan aw iling kandin to “Konà now igpanagda kandin su madoyow man to pighinang din kanak. ");
INSERT INTO did_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Dì to mgo publi, agad nokoy no adow igkabulig now su natuonan kow dan man kanunoy. Dì kanak, madaas ad on oghipanow. ");
INSERT INTO did_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Sikan to pagtahud din kanak su nasabutan din to madaas ad on ogkamatoy. Pighina-atan a din on no iglobong no pinabayà to paghinaki to mahal no hihinaki. ");
INSERT INTO did_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Agad ando-i no banwa no ogpanoysoy to Madoyow no Tutuwanon, ogkanangon to pighinang kanak todu-on no buyag. Kaling man kanunoy ogkadomdoman to mgo otow to pighinang todu-on no buyag no sikan to pagtahud din kanak.” ");
INSERT INTO did_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Na songo pangabaga dà gayod ni Jesus no iyan ngadan si Judas Iskariyuti, nakadomdom to og-andiyà to mgo punu-an to tinu-uhan to mgo Hudiyu su igbaligyà din si Jesus diyà kandan ");
INSERT INTO did_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","aw iling kandin diyà to mgo punu-an to “Pila buwa to igbayad now kanak ko daahon ku si Jesus dini iyu.” Na-uyunan to mgo punu-an to katlu-an no bu-uk to sapì aw bogayi dan dayuni si Judas. ");
INSERT INTO did_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Likat du-on kan no uras, si Judas, kanunoy on nakadomdom kandin dow og-amonuhon din to pagkumit no ogkadaa din si Jesus diyà to mgo kablang din. ");
INSERT INTO did_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Na nagotò to hihinangay to Hinang to Paan no Wadà Igpatulin no ogpakadaa gayod to Hinang to Pagpalipas to Kado-otan no iyan ogpakapunù. Na namanduguk diyà ki Jesus to mgo pangabaga din aw asig-usip kandan to “Dow ando-i koy nu buwa Sir to ogpahina-aton to paniyapun ta no Hinang to Pagpalipas to Kado-otan.” ");
INSERT INTO did_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Nigtabak si Jesus to “Andiyà kow to songo otow diyà to lunsud aw ikagihi kandin to ‘Si Sir, nig-ikagi no nig-iling to, Nagotò on to adow ku to pagmuwaha ku. Ogtuman koy to tulumanon no Hinang to Pagpalipas to Kado-otan, dini noy to ogpa-abuton to ikow no baoy.’” ");
INSERT INTO did_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Na to mgo pangabaga ni Jesus no sampuù tag duwa, natuman dan to impansugù ni Jesus kandan aw nangkahina-at dan tibò to pagko-onan to igdodomdomay dan to Pagpalipas to Kado-otan. ");
INSERT INTO did_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","No masaklop on no nangkahimun on tibò, namang-ingkud kandan si Jesus no ogpamandungà to pagko-onan. ");
INSERT INTO did_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","No ta-un to nigko-on kandan intag-an ni Jesus no nig-iling to “Ogdaahon ad to songo pangabaga ku dà diyà to kablang ku.” ");
INSERT INTO did_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Na nangkapook-pook kandan aw ka-inusipay to “Intawa on man buwa dapit Sir kanami. Konà buwa no kanak.” ");
INSERT INTO did_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Nig-ikagi si Jesus, “Sikan nigpagsau kanak, sikan iyan to ogdaa kanak diyà to mgo kablang ku. ");
INSERT INTO did_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Agad kanak to Tumutubus to Ka-otawan, dì tahan on nasulat bahin to kanak pagkamatoy aw natuman on. Dì aboy to otow no niglangub nigbaligyà kanak. Kanugun on kandin to mahudi no adow. To otow no nigbaligyà kanak no Tumutubus to Ka-otawan, madoyow pad nasì ko wadà podon ka-otow kandin.” ");
INSERT INTO did_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Si Judas no nigbaligyà ki Jesus, nig-usip kandin, “Sir, dow intawa buwa. Dow kanak buwa?” Nigtabak si Jesus, “Ho-o, sikan iyan.” ");
INSERT INTO did_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Na to wadà pad makatapus to pagko-onan, pigdawat ni Jesus to paan aw pasalamati din to Diyus. Dayun pigpamikas-pikas din aw pamalogobi din tibò to mgo pangabaga din no pigdonganan din to kagi no nig-iling to “Dawata now so-idi no paan aw ko-ona now su so-idi no paan, lawa ku.” ");
INSERT INTO did_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Pig-usab din mandà pigdawat to kabù aw pasalamati din aw ipamalogob din aw dongani din gayod to kagi no nig-iling to “Inoma now tibò ");
INSERT INTO did_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","su kanak to ogpakatubus no ogpakamatoy to saà to mgo otow dini to kalibutan awos ogkapasaylu dà to saà. So-idi no inomon, langosa ku no ogpataugon ku no igpa-inom ku iyu tibò su ogpakimatoy a iyu awos mapasaylu dà to saà now. So-idi to ta-indanan to bayà no insahad no pighimu iyu to Diyus. Na so-idi to panugun-tugun ku iyu. ");
INSERT INTO did_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Konà ki pad ogka-u-usab ogka-i-inom. Dì ogka-u-usab kinow dà ogka-i-inom to mahudi on no adow no umabut on to pagkaharì to Diyus dini to kalibutan.” ");
INSERT INTO did_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Dayun namanganta kandan to insayà-sayà dan to Diyus. Pagkatapus to pagkanta, namanghipanow kandan padoog diyà to Ulibu-an no untud. ");
INSERT INTO did_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","No pagdatong dan nig-ikagi on si Jesus to “Gagaya ogkatawadan a now tibò su ogdadakopon ad su nasulat on man bahin iyu no impananglitan to Diyus no pig-iling to ‘Ogpahimatayan ku to nigbantoy to mgo buhì aw puli on ogkawagà-wagà to mgo buhì.’ ");
INSERT INTO did_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Dì agad mamatoy a, dì ogbuhayon a dà. Pagbuhaya ku, og-una a iyu diyà to Galiliya no banwa no ogtatagbuhan ta.” ");
INSERT INTO did_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Naka-ikagi si Pedro to “Agad kandan tibò mamang-oyow ikow, dì kanak, konà a og-oyow ikow.” ");
INSERT INTO did_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Dì kagi ni Jesus to “So-idi iyan Lagi, kunto-on no kadukiloman no konà pad no kabukas-bukas no tataga-ukay to manuk, katatou nu to ilidung to nakilahan a nu.” ");
INSERT INTO did_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Dì pig-inulit no kagi ni Pedro no pig-iling to “Konà ku man ikow og-oyowan. Kamatayon nu, kamatayon ku dà gayod. Konà ku iglidung ikow.” Namansunud to duma no mgo pangabaga din to kandan no pag-ikagi. ");
INSERT INTO did_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Na nighipanow on kandan si Jesus padoog diyà to Gitsimani no tinanoman to kayu. No pagdatong dan nig-ikagi si Jesus to “Pakamonang kow kani dì kanak, og-u-ugsud a pad su og-ampù a to Diyus.” ");
INSERT INTO did_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Iyan dà pigpaduma din si Pedro aw kan daduwa no anak ni Sibidiyu. Na si Jesus, napook-pook lagboy aw naduyong-ot to ginhawa din. ");
INSERT INTO did_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nig-ikagi kandin to “Naduyong-ot lagboy to ginhawa ku hantod to igkamatoy kud podon so-idi. Kamonang kow kani aw bantoy kow.” ");
INSERT INTO did_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Dayun nig-u-ugsud kandin aw tinakin patilangkob kandin. Nigpangamuyù kandin to Diyus no nig-iling to “Ko mahimù Amoy, oglipwasan a nu so-idi no kalisodan. Dì mangkuwan konà no kanak to ogpakabo-ot to kanak ogkadoogan. Dì ikow dà man to ogpakabo-ot.” ");
INSERT INTO did_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Na nigpati-ulì si Jesus du-on kan tatou no pangabaga din no pinabantoy din. Dì nangkalipodong tibò kandan. Naka-ikagi si Jesus diyà ki Pedro to “Dow konà kow buwa ogpakatuwa-ay to ogbantoy agad songo uras dà? ");
INSERT INTO did_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Agdam kow aw ampù kow to Diyus no awos konà kow ogkatokawan to kalisodan no og-anti to pagtu-u now. Ogkaliyag to otow du-on to ginhawahan din to oghogoton podon to pagtu-u din, dì ko ogdo-ogan on kandin to kalisodan, ko kandin dà, konà ogka-amu to pagtuman on to paghogot.” ");
INSERT INTO did_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Na nigpa-ulì mandà si Jesus du-on to pig-ampu-an din aw ampù mandà kandin to Diyus no nig-iling to “Amoy ku, ko pagbo-ot nud on to ogkatuman on to ogmuwahon ad, na matuman on man su ikow dà to ogpakabo-ot to kanak ogkadoogan bahin to kalipwasanan to mgo ka-otawan.” ");
INSERT INTO did_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nigpati-ulì mandà kandin diyà to mgo pangabaga din. Nangkalipodong dà mandà kandan su lagboy nangkapuwow. ");
INSERT INTO did_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","To ikatou no pagsuwoy ni Jesus no kandin dà no og-ampù, pigsudsud din dà to pagpangamuyù din to Diyus. ");
INSERT INTO did_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","46","Pagpati-ulì din mandà diyà to mgo pangabaga din nig-iling kandin to “Nokoy man no nangkalipodong kow pad man aw hibat kow. Agad on. Na kuwà kinow on. Nagotò on bali to kanak adow to ogkadaa a no Tumutubus to Ka-otawan diyà to otow no dakoo to saà. Nig-abut on to ogdaa kanak. Pamanbangun kow on su ogkuwà kinow on.” ");
INSERT INTO did_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","No ta-un to nig-ikagi si Jesus, pigduguk ni Judas no sood dà gayod to sampuù tag duwa no pangabaga ni Jesus no nadumahan on to kahan-ingan likat to mgo punu-an to tinu-uhan. Namandaa kandan to otak aw popokpokay. ");
INSERT INTO did_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","To otow no nigbaligyà kandin, nigtudlì to kahan-ingan no pinabayà to hadok no tahan dan nasabutan dow ando-i si Jesus su na-iling din tahan to “Na to oghadokan ku, sikan si Jesus. Dayuna now dakopa.” ");
INSERT INTO did_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Na pag-abut din du-on nigduguk si Judas diyà ki Jesus aw ikagi to “Kamusta Sir,” aw hadoki din gayod. ");
INSERT INTO did_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Naka-ikagi si Jesus to “Tumanad man Lagi to napikiyan nu. Nokoy pad man to ogtagadan nu.” Dayun to pigdakop dan si Jesus. ");
INSERT INTO did_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Dì nakalapnut to sobu-uk no pangabaga ni Jesus to otak aw itigbas to sugu-onon to mata-as to mgo punu-an to tinu-uhan. Dì iyan dà na-igù to dibauy no talinga din aw kasangguwi. ");
INSERT INTO did_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Naka-ikagi si Jesus to “Isug-ub to otak nu Lagi, su to otow no oglangub ogtigbas to kasing-otow din, kandin gayod ogkamatoy dà to tigbas. ");
INSERT INTO did_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Dow wadà nu buwa kama-ani to ogkabuligan a podon su ogkapa-andini to Diyus no Amoy ku to diwata din no minaan ko puli ku dà ogpangamuyu-on. ");
INSERT INTO did_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Dì konà a ogpabulig kunto-on su ogkatuman man to pig-ikagi to Diyus no nasulat on su tahan natag-an man to pagmuwaha ku.” ");
INSERT INTO did_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Na nig-ikagi si Jesus to kahan-ingan no ka-otawan to “Dow oghimuhon a now no tulisan no ogdakopon now? Nokoy man to impandaa now to otak aw popokpokay. Adow-adow pigpang-anad ku iyu diyà to simbahan dì wadà a now dakopa. ");
INSERT INTO did_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Dì ogdangat so-idi dini kanak awos matuman to impasulat to Diyus to mgo maglilikwaday din no lagsoban din natodu-on bahin to pagmuwa kanak.” Na du-on na-oyowan kandin bali to mgo sakup din aw pamanlaguy kandan. ");
INSERT INTO did_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Na, pigdaa si Jesus kan nigdakop kandin diyà to kahimunan to mgo punu-an to tinu-uhan no mata-as dan no si Kaipas. ");
INSERT INTO did_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Na si Pedro, nigpawpatilupug dà kotob diyà to solib to baoy to mata-as to mgo punu-an. Dayun nigli-ot si Pedro aw sood to li-otanan du-on to mgo solib aw ingkud kandin no nigpaglamutoy to mgo guwardya awos matagahan din dow nokoy to ogkadoogan ni Jesus. ");
INSERT INTO did_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Na kandan si Kaipas, pigpanganap dan to otow no ogpabotang-botangon dan ki Jesus to litos on podon no igkahimatoy dan. ");
INSERT INTO did_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Dì wadà man nakita-an dan no litos no igkahimatoy dan. Agad mahan-ing to mgo otow no nigbotang-botang, dì tibò konà no tùtu-u. Bali no moydu-on nigsakindog no daduwa ");
INSERT INTO did_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","no nig-ikagi to “So-idi no otow, nig-ikagi to oglompagon din kun so-idi no abutanan to Diyus. Dì sood kun to tatou no adow ogka-uliman din dà kun.” ");
INSERT INTO did_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Dayun nigsakindog to mata-as to mgo punu-an aw usipa din si Jesus to “Dow wadà igkatabak nu todu-on no indiklamu dan ikow?” ");
INSERT INTO did_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Dì si Jesus, puli nigpapahonok. Dayun pig-ikagihan si Jesus to mata-as to “Na ogpatabakon ku ikow to ig-usip ku ikow no igpabayà to panumpà nu diyà to atubangan to Diyus dow Kristu ka iyan no otow no Imananan to Ka-otawan no Anak to Diyus.” ");
INSERT INTO did_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Nigtabak bali si Jesus to “Ho-o, tùtu-u iyan kan pig-ikagi nu. Madaas on iyan ogkama-anan now to pagbo-ot ku iyu su ogpagso-ing a to Diyus no Amoy no nigbogoy kanak to kabogbogan. Aw kanak no Tumutubus to Ka-otawan, og-ulì a dà dini no ogpakaliwaw-ang a to gabun.” ");
INSERT INTO did_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","No malituk to kagi ni Jesus, pigpongkas to mata-as to punu-an to kabò din no ta-indanan to paglangoti din aw maka-ikagi to ma-agbot to “Napa-inahan din to Diyus kan no pig-ikagi din. Litos on to ingkadiklamu su nadinogan now on to kagi din no mado-ot. Nokoy man no ogtagad ki pad to duma no dugang no igkadiklamu. ");
INSERT INTO did_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nokoy to iyu no ogkaliyagan.” Namaka-ikagi kandan to “Himatayanan on iyan kandin.” ");
INSERT INTO did_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Na, pig-iloban dan to uu ni Jesus. Pigsumbag dan aw sampaluha dan no naman-ikagi kandan to ");
INSERT INTO did_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Tag-ana kun dow intawa ton nigsumbag ikow ko tùtu-u ka iyan no lagsoban no pinilì on to Diyus no hinimu din no Imananan to Ka-otawan.” ");
INSERT INTO did_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Na og-uli-on tad mandà to tutuwanon ki Pedro no diyà to solib no nig-ingkud. Dinuguk kandin to daga no sugu-onon aw ikagihi to “Ikow, duma ka gayod ni Jesus no taga-Galiliya.” ");
INSERT INTO did_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Di niglidung si Pedro aw maka-ikagi to “Wadà nasabutan ku no litukan ton pig-ikagi nu kanak.” ");
INSERT INTO did_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pagli-ot ni Pedro diyà to balkun nakita-an kandin mandà to duma no daga no sugu-onon. Nig-iling kandin diyà to mgo maglalaboy to “Sikan no otow, duma ni Jesus no taga-Nasarit.” ");
INSERT INTO did_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Dì niglidung mandà si Pedro. Pig-ikagi din to pigbogat aw ilinga din to “Wadà ku kakilahi sikan no otow.” ");
INSERT INTO did_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Pagkaugoy-lugoy pigduguk si Pedro to maglalaboy aw iling to “Agaw to inikagihan nu inikagihan man to mgo taga-Galiliya su ikow, duma ka din gayod.” ");
INSERT INTO did_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Na pigpakabogat ni Pedro to kagi din aw ilinga din to “Wadà ku kakilahi sikan no otow.” Aw du-on nigtaga-uk dayun to manuk. ");
INSERT INTO did_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Dayun nadomdoman ni Pedro to intag-an tahan ni Jesus no nig-iling to “To konà pad no kabukas-bukas no tataga-ukay to manuk, katatou nud to ilidung to nakilahan a nud.” Na nakapono-ug si Pedro aw makasinogow ugpat to pagkasosoo din. ");
INSERT INTO did_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Na pagkabukas namanhihimun mandà tibò to punu-an to tinu-uhan aw pamansusukun-sukun to pagpahimatoy dan ki Jesus su ogmatu-udon dan to pigbo-otan dan to madukilom pad no paghinang dan ki Jesus no himatayanan. ");
INSERT INTO did_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Pagkasusukun dan, impabakus dan to boad din aw daaha dan diyà ki Pilato no gubirnadur no imbotang du-on to taga-Ruma no nakasakup to mgo ka-Hudiyuhan. ");
INSERT INTO did_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Na si Judas no nigbaligyà ki Jesus, pagkama-an din to puli nahinang si Jesus no himatayanan, nakasosoo dà kandin aw kadomdom to ig-ulì din podon to sapì diyà to mgo punu-an to tinu-uhan ");
INSERT INTO did_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","aw maka-ikagi kandin to “Nakasaà a man diyà to atubangan to Diyus su nakabaligyà ad on to otow no wadà saà. Hawi-a now dà to sapì now.” Dì wadà dan on hawi-a aw pamang-ikagi nasì kandan to “Ikow on to ogbobo-ot su wadad kalabotan noy to kanami.” ");
INSERT INTO did_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ingkadogpak ni Judas to sapì du-on to sood to simbahan aw makahipanow aw ogot no nigbibitoy to tu-un din no lawa. ");
INSERT INTO did_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Dì to mgo punu-an, pigpanghimun dan to sapì aw mamaka-ikagi to “Konà ta igkabotang so-idi diyà to botanganan to sapì to simbahan su so-idi no sapì to nakapood to otow.” ");
INSERT INTO did_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Namansusukun-sukun kandan dow amonuhon dan to sapì. Iyan na-uyunan dan to igboli to pasak no oglobongan to otow no bugtì to piglikatan aw ko du-on mata-unan to kamatayon to pagkadiyù dan to kandan banwa, du-on to iglobong. Pasak to maghuhungun to kudon to pigboli dan. ");
INSERT INTO did_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Hantod kunto-on nahingadanan sikan no pasak to Pasak no Langosahon, su to sapì no imbayad sikan no pasak, nakapood to otow. ");
INSERT INTO did_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Na natuman on to natag-an ni Jeremias no maglilikwaday no lagsoban to Diyus no pig-iling to “Pigpanghimun dan to sapì no katlu-an no bu-uk no ingkabayad to na-uyunan to kasinugpu-an ni Israel no imbogoy diyà to nigbaligyà to otow, ");
INSERT INTO did_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","aw sikan no sapì iyan naboli to pasak to maghuhungun to kudon su pagbo-ot man to Magbobo-ot dini kanak.” Sikan to pig-ikagi ni Jeremias no lagsoban natodu-on. ");
INSERT INTO did_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Na pigpa-atubang si Jesus diyà ki Pilato. Pigpangusip-usip din no nig-iling to “Ikow, dow harì ka to mgo Hudiyu?” Nakatabak si Jesus to “Ho-o, sikan ing-usip nu, sikan iyan.” ");
INSERT INTO did_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Dì pagdiklamu to mgo punu-an to tinu-uhan, puli nigpapahonok si Jesus. ");
INSERT INTO did_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Nig-ikagi si Pilato to “Dow wadà nu kadinogi to indiklamu dan no nigsingkabugtì?” ");
INSERT INTO did_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Dì wadà usab ikagi si Jesus. Dì puli nigpapahonok kandin hantod to naboong-boong si Pilato no gubirnadur. ");
INSERT INTO did_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Na to tighihinang to Hinang to Pagpalipas to Kado-otan, kadoog ogsabuk si Pilato to sobu-uk no pirisu su tahan din. Dì to pirisu, igpapilì din pad to mgo ka-otawan. ");
INSERT INTO did_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Na si Barabas no bantugan no maghihimatoy, napirisu tahan. ");
INSERT INTO did_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Na pagkahimun to ka-otawan, pig-usip ni Pilato to “Intawa to ogpili-on now no ogpasabukan now kanak, si Barabas dow si Jesus no pighingadanan to Imananan to Ka-otawan.” ");
INSERT INTO did_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Nama-anan din to pigdaa dan diyà kandin su ogsombangon dan man si Jesus. ");
INSERT INTO did_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","No niggumotong pad si Pilato to kahimunan, nakadatong on to otow no niglikwad to tugun likat to asawa din no na-iling to “Konà ka ogpadamoy to kamatayon sikan no otow su wadà saà din no ogkahibatan din, su napook-pookan ku lagboy to taga-inop ku ganina bahin kandin.” ");
INSERT INTO did_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Dì sikan mgo punu-an to tinu-uhan, nadaa dan dà tibò to kahan-ingan su impapangamuyù dan to iyan ogpasabukan si Barabas. Dì si Jesus to ogpahimatayan dan. ");
INSERT INTO did_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Inusab mandà inusip ni Pilato to ka-otawan, “Intawa dapit lagboy to ogpasabukan now kanak.” Namakatabak to ka-otawan to “Si Barabas dà iyan bullug.” ");
INSERT INTO did_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Naka-ikagi si Pilato to “Nokoy to igpabobo-ot now kanak so-idi no otow no si Jesus no pighingadanan man podon to Imananan to Ka-otawan.” Namantabak kandan to “Himatayi, tutuki diyà to kinurus.” ");
INSERT INTO did_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Naka-ikagi si Pilato to “Nokoy man. Nokoy to saà din.” Dì namakasa-og mandà to mgo ka-otawan to “Himatayi, tutuki.” ");
INSERT INTO did_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pagabut ni Pilato to konà kandin ogpakada-og ogpakapaduma to mgo ka-otawan to kandin pagbo-ot, dì nasì on ogkasamuk to kahan-ingan, puli on nigpabu-ud kandin aw hugasi to boad din diyà to atubangan to ka-otawan no pagpasabut din to wadà kalabotan din to kamatayon ni Jesus no nig-iling to “Wadà labot ku to kamatayon so-idi no otow. Iyu on to ogbobo-ot.” ");
INSERT INTO did_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Namaka-ikagi to kahan-ingan to “Na kanami on to ogbobo-ot to saà noy asta pad man to mgo kasinugpu-an noy.” ");
INSERT INTO did_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Dayun pigpasabukan din diyà to kahan-ingan si Barabas. Dì si Jesus, impabu-ud din on pigpabunaan aw ipadaa diyà to mgo sundau no awos itutuk diyà to kinurus. ");
INSERT INTO did_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Na pigdaa si Jesus to mgo sundau diyà to kahimunanan to gubirnadur. Pigpahimun dan to songo panon no sundau no tibò no ginatus to kahan-ing aw pa-atubanga dan si Jesus. ");
INSERT INTO did_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Piggawang dan to kabò din aw kabo-i to kabò no maogdog no angod-angod to kabò to harì, ");
INSERT INTO did_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","aw sapidi dan to bawbagon no dugihon no impa-angod-angod dan to sinuwang-suwang to harì aw su-uwi dan to uu din. Pigpatagon dan si Jesus to buu to kalintu-u din no boad no igpatubus dan to bastun to harì aw namanpakunon-kunon kandan namanluhud diyà to atubangan din. Namandugadi kandan aw pakunon-kunon kandan pagkamusta ki Jesus no ogpaman-ikagi kandan to “Kamusta. Mabuhì, harì to mgo ka-Hudiyuhan.” ");
INSERT INTO did_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Pig-iloban dan si Jesus. Pigdawat dan du-on ki Jesus kan buu no impatagon dan aw ibalitu dà ibunaa to uu din. ");
INSERT INTO did_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pigdugadi dan si Jesus aw lobasi dan to maogdog no kabò aw ilisi dan to tahan din no kabò. Dayun pigdaa dan kandin diyà to labas su ogtututukon dan to paghimatoy ki Jesus diyà to kinurus. ");
INSERT INTO did_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Pagkalibwas dan to li-otanan to in-aad to lunsud, ingkikita dan si Simon no taga-Sirini. Pigpogos dan pigpati-ang kandin to kinurus no ogpadodopahan dan ki Jesus. ");
INSERT INTO did_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Pagdatong dan diyà to untud no pighingadanan to Gulguta no iyan kalitukan to bobo-ungon to otow, ");
INSERT INTO did_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","pigtadwayan dan kandin to inomon no pigba-otan to mapo-it no tambaa no makalilingow. Dì pagka-anti din wadà din abaya inoma. ");
INSERT INTO did_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","No intututuk dan si Jesus du-on to kinurus, pighahandug to mgo sundau to kabò din, dì impabayà dan to tinag-anay dow intawa dapit kandan to makatu-un. ");
INSERT INTO did_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pigbantayan si Jesus to mgo sundau ko moydu-on humilabot kandin. ");
INSERT INTO did_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Insulat dan to indiklamu dan ki Jesus aw ibotang diyà to babow to uu din. So-idi to nasulat no indiklamu no pig-iling to “So-idi si Jesus no Harì to mgo ka-Hudiyuhan.” ");
INSERT INTO did_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Intutuk to sundau gayod to daduwa no ka-tulisan no pinagdibauy kandan. ");
INSERT INTO did_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Na to mgo maglalaboy, naman-ina-ina ki Jesus aw namanyowyow gayod du-on kandin. ");
INSERT INTO did_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Namang-iling to “Ikow no kunon kun oglompag to labow no simbahan to Diyus, aw og-ulimanon nu dà kun sood to tatou no adow, na anti ka kun kunto-on bulig to ikow no lawa. Ko tùtu-u ka man iyan no Anak to Diyus, kawas kad kun du-on to kinurus.” ");
INSERT INTO did_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","To mgo punu-an to tinu-uhan, naman-ina-ina gayod ki Jesus no nig-iling to ");
INSERT INTO did_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Pigbuligan din to nigsingkabugtì no otow dì konad on man kandin ogka-amu ogbulig to kandin tu-un no lawa. Ikow, ko harì ka to mgo ka-Isrilihan, na anti ka kun kawas kunto-on awos ogtu-u koy bali to harì ka iyan no pig-iman noy. ");
INSERT INTO did_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ko nigsalig ka to Diyus, mabuligan ka kunto-on ko na-uyunan man to Diyus su konon kun Anak ka to Diyus.” ");
INSERT INTO did_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Sikan mgo tulisan no intututuk gayod du-on to kinurus no nakadidibauy du-on ki Jesus, naman-ina-ina dà gayod kandan ki Jesus no pig-angod dà sikan. ");
INSERT INTO did_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Na pag-ugtu to soga nigdiglom to banwa hantod to mgo alas tris on to uras. ");
INSERT INTO did_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kayan naka-ikagi si Jesus to ma-agbot to kandin tu-un no kagi no pig-iling to “Eli, Eli, lama sabaktani,” no iyan kalitukan to “Diyus ku, Diyus ku, na-amonu ka man no pig-oyowan a nu.” ");
INSERT INTO did_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","To mgo maglalaboy, na-intobo-ot dan dow pigsabi din si Elias no maglilikwaday to Diyus natodu-on aw iling kandan to “Eè, sinabi din si Elias.” ");
INSERT INTO did_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nigpanlaguy to sobu-uk aw pudut to papasopsopay aw pasopsopa din to sukà no inomon. Insaligpit din to papasopsopay du-on to tawoy to katinoptopan aw itukoy dino awos makasupsup si Jesus. ");
INSERT INTO did_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Dì moydu-on duma no naka-ikagi to “Aya kad na-ay su dagow umandini si Elias no ogbulig kandin.” ");
INSERT INTO did_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Dayun nigsa-og mandà si Jesus aw tu-uni din ligtasi to ginhawa din. ");
INSERT INTO did_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Na to pagkamatoy ni Jesus, nakadongan to napongkas to ingkayad no insalibon to habangan to sinabong no abutanan to Diyus diyà sood to labow no simbahan du-on to Hirusalim no lunsud. Diyà kapunù to babow hantod to sagyad. Pigtiyog to banwa aw nambotu to mgo kabatuhan ");
INSERT INTO did_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","aw kangka-ukasi to mgo pigpanlobongan no nangkalimut aw mahan-ing to tumutu-u to Diyus no pigpambuhoy. ");
INSERT INTO did_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Pagbuhaya gayod ni Jesus, namanlogwà on kandan to linobongan aw sood to Hirusalim aw mahan-ing to nakakita kandan. ");
INSERT INTO did_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Na og-uli-on tad kandà no timpu no pagkabigtawid ni Jesus. To kapitan aw mgo sundau no nigbantoy kandin, nabatì dan kan no tiyog. Pagkakita dan to tibò no napugut, nangkaboong-boong lagboy aw mamaka-ikagi to “Anak na-an iyan to Diyus todu-on no otow.” ");
INSERT INTO did_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Moydu-on gayod mgo buyag no namanbantow puli to pag-ahà. Sikan mgo buyag no taga-Galiliya iyan namandumduma kandan ki Jesus no nig-alagà to mgo panow din likat to Galiliya. ");
INSERT INTO did_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Iyan ngadan dan si Maria no taga-Magdala, aw si Maria no inoy ni Santiago aw ni Jose, aw asawa ni Sibidiyu. ");
INSERT INTO did_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Pagkahapun on, nigdatong si Jose no taga-Arimatiya no dadatu-on no sakup ni Jesus. ");
INSERT INTO did_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nigba-id kandin ki Pilato to kandin to oglobong ki Jesus aw pigtugutan. ");
INSERT INTO did_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Piglingat din to patoy no lawa aw lukuti din to bayà no hinaboan no linu no maputì. ");
INSERT INTO did_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Diyà din ilobong to pigbangbangan no batu no pighina-atan on tahan to kandin ogkalobongan. No pagkalobong on, pigligadan din to batu no malidok aw isomban. No masombanan din on, nighipanow on kandin. ");
INSERT INTO did_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Si Maria aw si Maria no taga-Magdala, namang-ingkud no nigbantoy diyà topad to atubangan to linobongan. ");
INSERT INTO did_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Na to sunù no adow no konà no tigtatalabahu sikan mgo punu-an to tinu-uhan tibò, namang-andiyà kandan ki Gubirnadur Pilato. ");
INSERT INTO did_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Naman-ikagi kandan to “Sir, wadà noy kalingawi sikan mapakunon-kunonon no otow no buhì pad kandin, nig-ikagi to ogbuhayon dà kun to pagkatatouhi no adow. ");
INSERT INTO did_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kaling man madoyow ko ogpabantayan nu to sundau to linobongan kandin kotob to tatou no adow su dagow ko puduton to mgo sakup din aw inangon dan to ka-otawan to pigbuhoy on si Jesus, su ogkadugangan on man to kagau-an bahin kandin to Imananan to Ka-otawan su malisod to patu-uhon to mgo ka-otawan to ogpambuhayon to mgo nangkamatoy on.” ");
INSERT INTO did_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Naka-ikagi si Pilato to “Na igbotang now to sundau aw digona now agad-agad to nama-anan now no pagdigon.” ");
INSERT INTO did_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Dayun pigpakadigon dan aw pigpapagdokot lagboy to insomban no batu aw du-on dan botangi to mgo sundau. ");
INSERT INTO did_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Na og-uli-on tad mandà to tutuwanon bahin to mgo buyag no namakabantow to pag-ahà to paglobong ki Jesus no kandan si Maria aw si Maria no taga-Magdala no wadà pad makaponga kandan to paghimu to igpahomut to patoy su ta-un on man to adow no konà no tigtatalabahu. To kabukas-bukas on to sunù no adow, naman-andiyà kandan su oglo-uy kandan to lobong, ");
INSERT INTO did_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","aw tinakin pigtiyog to banwa to mabogbog su nigpatipadpad to diwata likat to Diyus diyà to langit. Pigligad din kan malidok no batu no insomban to lingangahan to piglobongan no imbangbang to batu. Dayun nigpati-ingkud on kandin du-on to batu. ");
INSERT INTO did_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","To pagkagoya-goya din, ogpaka-angod to kilat aw kabò din, ogpaka-angod-angod to panganud to kaputì. ");
INSERT INTO did_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Pigpidpid to mgo sundau to pagkahadok aw nangkapood no angod to nangkamatoy. ");
INSERT INTO did_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Na nig-ikagi sikan diwata diyà to mgo buyag to “Konà kow ogkahadok. Nama-anan ku no iyan ogpanganapon now si Jesus no intututuk diyà to kinurus. ");
INSERT INTO did_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Wadad on du-on. Pigbuhoy on no natuman on ton innangon din iyu natodu-on. Andini kow aw aha-a now to pigbotangan kandin. ");
INSERT INTO did_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ko makita-an now on, andiya-i now on to mgo pangabaga aw nangoni now to pigbuhoy on aw og-una on kandin diyà to Galiliya no ogtagbuhan din iyu. Na sikan dà to kagi ku iyu.” ");
INSERT INTO did_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Dayun namanhipanow kan daduwa no ka-buyag no nangkaboong-boong dì namantukhow on. Namang-ulì on no inlinaguy dan to nawnangonon diyà to mgo pangabaga ni Jesus su awos mataga kandan to napugutan. ");
INSERT INTO did_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Dì no diyà pad to pangindanan ingkikita dan on si Jesus. Nig-ikagi si Jesus to “Kamusta iyu no daduwa.” Namakaluhud kandan aw asigkatagon to kobong ni Jesus aw mamaka-ampù. ");
INSERT INTO did_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Nig-ikagi si Jesus, “Konà kow ogkahadok. Nangoni now nasì to mgo pangabaga ku to og-una ad on kandan diyà to Galiliya no diyà koy on to ogkikita.” ");
INSERT INTO did_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Na og-uli-on tad on to tutuwanon bahin to mgo sundau no pigpabantoy to piglobongan ki Jesus. Pagbuhaya dà ni Jesus, naman-ulì kan mgo sundau diyà to lunsud aw nawnangonon kandan diyà to mgo mata-as to punu-an to tinu-uhan to napugut-pugutan. ");
INSERT INTO did_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Dayun nighihimun to duma no punu-an aw mamakasusukun-sukun. Pigbayadan dan to mgo sundau to dakoo su ogpaginau-on to pagnangon dan to ka-otawan. ");
INSERT INTO did_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Angod so-idi to in-anad dan no igpa-iling dan kandan, “To mgo sakup ni Jesus, nigpata-un nig-andu-on to piglobongan ki Jesus to madukilom no uras to nalipodong koy. Wadà noy kakita-i aw puduta dan to patoy no lawa ni Jesus.” ");
INSERT INTO did_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","“Na,” kagi mandà to mgo punu-an to tinu-uhan, “ko madinog sikan to gubirnadur, kanami on to ogbobo-ot. Ogkadaa noy dà kandin. Konà kow ogminapook-pook.” ");
INSERT INTO did_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Dayun nadawat to mgo sundau to sapì aw katuman dan to insugù kandan. Nigtangkap sikan no nawnangonon to ka-Hudiyuhan aw katu-uhi hantod kunto-on. ");
INSERT INTO did_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Na sikan mgo pangabaga ni Jesus no sampuù tag isa, namanhipanow on padoog diyà to untud to Galiliya no pigpatagbuhan kandan ni Jesus. ");
INSERT INTO did_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","No ipaghitagbu dan si Jesus namakaluhud kandan aw maka-ampù dì naba-otan dà gayod du-on to wadà tu-u to si Jesus iyan sikan no pigbuhoy on. ");
INSERT INTO did_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Pigduguk kandan ni Jesus aw ikagihi to “Pigbogayan ad to Diyus to kabogbogan tibò to ogpasakupon so-idi kalibutan aw kalangitan. ");
INSERT INTO did_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kaling man pamanghipanow kow diyà to tibò no timamanwa no oglogob kow to binogdokan to langit aw himuha now kandan no mgo sakup ku aw pambonyagi now to ka-otawan no igmatu-ud to pagpasakup dan to ngadan to Diyus no Amoy aw Diyus no Anak aw Diyus no Inspiritu Santu, su iyu on iyan to ogtubus kanami si Amoy. ");
INSERT INTO did_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Oglapuwaason now to pagpang-anad kandan aw ogpatumanon to mgo impansugù ku iyu. Na konà now ogkalingawan to agad ando-i kow makadoog, kanunoy ku iyu ogdumahan hantod to katapusan to banwa.”");
INSERT INTO did_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","So-i no tutuwanon, iyan pigupunu-an to pagkatuman to kagi to Diyus du-on to Anak din no impananglitan. ");
INSERT INTO did_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Sikan no pananglitan to Diyus, impasulat din natodu-on to maglilikwaday din no lagsoban. Iyan ngadan din si Isaias. Sikan pananglitan to Diyus pig-iling to, “Na, kunto-on pigpa-andiyà ku to sugu-onon ku to kahanongan no banwa. Oghina-aton din to daan nu no igbayà nu. ");
INSERT INTO did_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Diyà to kahanongan no banwa moydu-on nigpangudlin to ma-agbot lagboy no nig-iling to ‘Oghina-aton now to daan to Magbobo-ot ta. Ogtul-idon now to igbayà din.’” ");
INSERT INTO did_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Na natuman sikan no kagi to Diyus to pinalogwà si Juan no pighingadanan to Magbobonyagay diyà to kahanongan no banwa. Sikan no banwa, madani to wohig no pighingadanan to Hurdan. Nigpangudlin si Juan to mgo ka-otawan no nahimun diyà to kahanongan no banwa no nig-iling to “Pakasosoo kow to saà now aw oyowi su agun pasayluhon dà to Diyus to saà now, aw pabonyag kow to wohig no igmatu-ud to pagpasakup now to kanak impang-anad.” ");
INSERT INTO did_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Na tibò to mgo ka-otawan, namanmutmut to prubinsiya to Hudiya aw lunsud to Hirusalim no namanduguk ki Juan no diyà to Hurdan no wohig, aw pamabonyag kandan no naman-abin gayod kandan to saà dan. ");
INSERT INTO did_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","No pag-ugpà ni Juan diyà to kahanongan no banwa iyan pigpangabò din to pighaboan no bubuu to buhì no pighingadanan to kamilyu. Nigpamagkos si Juan to kubaa. Tangas dà aw dogà to pagko-on ni Juan. ");
INSERT INTO did_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Nig-iling si Juan to “Moydu-on otow no ogpakasukoli pad hognà kanak no oglabow pad lagboy kandin dini kanak to kabogbogan. Kanak, igatang podon ogpabatà-batà a du-on kandin. Dì konà a su kandin, labow pad lagboy dini kanak. ");
INSERT INTO did_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Kanak, pigmatu-ud ku to pagpasakup now to kanak impang-anad no impabayà to ogbonyagan ku iyu to wohig. Dì kandin, ogmatu-udon din to pagpasakup now to kandin igpang-anad no igpabayà to ogbonyagan kow din to Ispiritu Santu no iyan ogsoodan kow din lagboy.” ");
INSERT INTO did_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Na no pagbonyag pad ni Juan to mgo ka-otawan, naka-abut on gayod si Jesus no niglikat to kandin lunsud no pighingadanan to Nasarit no nasakup to prubinsiya to Galiliya. Pag-abut ni Jesus du-on to Hurdan no wohig nigpabonyag kandin gayod ki Juan. ");
INSERT INTO did_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Paggamat ni Jesus du-on to pangpang, tinakin nakita-an din to langit no natau-angan. Dayun nigbunsud du-on ki Jesus to Ispiritu Santu no iyan na-angodan to salapati. ");
INSERT INTO did_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Nadinogan to mgo otow du-on to kagi no niglikat to langit no pig-iling to “Ikow to nalogonan ku lagboy no Anak.” ");
INSERT INTO did_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Na pigpa-andiyà si Jesus to Ispiritu Santu to banwa no lagboy kahanongan. Iyan dà nig-ugpà du-on to mgo uwod-uwod. ");
INSERT INTO did_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Pigpangap-atanan no adow si Jesus du-on kan no banwa. Nigsood gayod si Satanas du-on aw pigpanogkadan din si Jesus to pa-antihan dow makaboos kandin to kabogbogan no niglikat to Ispiritu Santu. Dì wadà makasaà si Jesus aw nada-og din si Satanas aw du-on alaga-i kandin to mgo diwata likat to Diyus. ");
INSERT INTO did_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Na impapirisu ni Harì Hirudis si Juan no Magbobonyagay. Pagkama-an ni Jesus to napirisu si Juan, nighipanow on kandin padoog diyà to Galiliya no banwa no nig-aboy nigpang-anad to Madoyow no Tutuwanon to Diyus ");
INSERT INTO did_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","no nig-iling to “Madaas on ogkagotò to pagsakup to Diyus. Ogsosoo kow aw oyowi now to katahanan now aw tu-u kow gayod to Madoyow no Tutuwanon to Diyus.” ");
INSERT INTO did_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Na nigladgad on si Jesus diyà to boyboy to dagat to Galiliya aw kakita-i din to daduwa no ka-otow no nigpatahadi. Iyan ngadan to kakoy si Simon. Iyan ngadan to hadi si Andres. Namantuntun kandan to pukut du-on to dagat su sikan to nama-anan dan no panapì. ");
INSERT INTO did_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Nig-iling si Jesus to “Lagi, pumasakup kow kanak, ogkasakup ku gayod iyu aw ogkahimun now to mgo otow awos masakup ku gayod kandan. Konad on no isdà to ogsakupon, dì mgo otow to ogpapasakupon now dini kanak.” ");
INSERT INTO did_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Dayun pig-oyowan dan to pukut aw duma kandan ki Jesus. ");
INSERT INTO did_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Pag-u-ugsud ni Jesus nakita-an din to songo bugtì no nigpatahadi. Iyan ngadan to kakoy si Santiago. Iyan ngadan to hadi si Juan. Iyan amoy dan si Sibidiyu. Namandowdoyow kandan to pukut du-on to bautu. ");
INSERT INTO did_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Dayun pigtawag ni Jesus kan nigpatahadi awos pumasakup du-on kandin. Pig-oyowan dan to amoy dan aw mgo inadow dan diyà to bautu aw duma kandan ki Jesus. ");
INSERT INTO did_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Na nig-andiyà si Jesus to Kapirna-um no lunsud no pigdumahan to mgo sakup din. Sabadu no adow to konà dan igtalabahu no mgo Hudiyu no mgo otow. Nigsood si Jesus aw mgo sakup din diyà to simbahan to Sabadu aw nigpang-anad kandin to mgo ka-otawan du-on. ");
INSERT INTO did_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Dì naboong-boong sikan mgo ka-otawan to impang-anad din su sikan bayà no ing-anad ni Jesus, paka-angod dà to impang-anad to otow no moydu-on kabogbogan. Bugtì du-on to impang-anad to mgo mag-a-anad to kasugu-an to tinu-uhan to mgo Hudiyu. Puli dan pig-unug sikan pigtagonan dan no tinu-uhan. ");
INSERT INTO did_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Na nigsood gayod to simbahan to otow no pigsoodan to busow. ");
INSERT INTO did_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Nigsa-og kandin to “Jesus no taga-Nasarit, wadà labot nu kanami. Nokoy to tu-ud nu. Dow og-ubuson koy nu? Kinilaa ku ikow no matuwadong no likat to Diyus no Imananan to Ka-otawan.” ");
INSERT INTO did_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Dì pigsapadan ni Jesus aw ikagihi to “Pahonok kad. Gawang kad du-on kan otow.” ");
INSERT INTO did_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Dayun du-on nigpalukub to busow aw makapanagoa kan otow aw tinakin makagawang kan busow. ");
INSERT INTO did_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Dayun naboong-boong sikan mgo otow du-on to simbahan aw ka-inusipay kandan to “Ma-amonu man buwa so-idi bayà no impang-anad ni Jesus. Ko ogsugù kandin, angod dà man to sugù to otow no moydu-on kabogbogan. Agad busow, ko ogsugu-on din, ogpakatuman iyan.” ");
INSERT INTO did_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nigtangkap to bantug ni Jesus diyà to prubinsiya to Galiliya. ");
INSERT INTO did_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Na niglogwà si Jesus to simbahan no pigdumahan ni Santiago aw ni Juan. Nigponhik on kandan diyà to baoy ni Simon aw ni Andres. ");
INSERT INTO did_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Na to ugangan ni Simon no buyag, nakahibat-hibat su mapasù to lawa aw nangoni dan si Jesus. ");
INSERT INTO did_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Nigduguk si Jesus diyà to buyag no nasakit aw dawata din to boad din aw pabanguna din. Na-uli-an dayun to ugangan ni Simon aw bulig on kandin alagà to mgo bisita. ");
INSERT INTO did_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Na pagkahapun, pigdaa to mgo otow no nangkasakit diyà ki Jesus aw to mgo otow gayod no pigpansoodan to busow. ");
INSERT INTO did_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nangkahimun du-on to atubangan to baoy to tibò no taga-Kapirna-um. ");
INSERT INTO did_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Agad nokoy no sakit to mgo otow, pigpandoyow tibò ni Jesus. Nangkagawang din gayod to busow. Dì konà din ogpa-ikagihon kan mgo busow su nakilahan dan si Jesus no Anak to Diyus. ");
INSERT INTO did_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Na to kabukas-bukas nigbangun si Jesus aw andiyà kandin to hilit aw ampù gayod kandin to Diyus. ");
INSERT INTO did_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Dì piglupug ni Simon aw mgo duma din. ");
INSERT INTO did_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Pagkita dan ki Jesus nig-iling kandan to “Ogpanganap ikow Sir, to tibò no ka-otawan.” ");
INSERT INTO did_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Dì nig-ikagi si Jesus to “Oglibod-libod kid on nasì to kalunsudan su ogpangudlin ki du-on tibò. Sikan to ing-andini ku to kalibutan.” ");
INSERT INTO did_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Dayun namanghipanow kandan aw libod diyà to ka-Galiliyahan no banwa. Nigpangudlin kandan diyà to kahimunanan no simbahan to mgo taga-Galiliya. Piggawangan gayod ni Jesus to mgo otow no pigsoodan to busow. ");
INSERT INTO did_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Na du-on kan no banwa no Galiliya moydu-on otow no pig-ibung. Nigduguk diyà ki Jesus aw luhud aw iling to “Ko bumo-ot ka Sir to ogka-uli-an ad on, ogka-uli-an a dà man aw kalinisi a.” ");
INSERT INTO did_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Na pigka-atan ni Jesus aw dampona din aw ikagihi to “Ogbo-otan ku man. Na, ka-uli-i kad on aw kalinisi kad on.” ");
INSERT INTO did_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Na-uli-an on dayun to sakit kan otow no ibung aw kalinisi to lawa din. ");
INSERT INTO did_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Pigbahog lagboy ni Jesus to “Lagi, konà nu na-ay igpannawnangonon to nadoyow ku kan sakit nu. Dì padohus ka nasì diyà to ogtubus ikow diyà to atubangan to Diyus aw pa-ahà ka kandin. Bogayi kan ogtubus ikow to insugù ita ni Moises no buhì no pagmatu-ud to pagka-uli-i nu kan ikow sakit awos matu-uhan to ka-otawan.” Pagkatapus to pagbahog ni Jesus kan otow, pigpahipanow din on. ");
INSERT INTO did_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nakahipanow on sikan pig-ibung no otow no na-uli-an on man. Dì innawnangonon on man nasì. Kaling man nigtangkap du-on no banwa to nawnangonon to pagka-uli-i din to ibung hantod to konad on oghipanow si Jesus diyà to lunsud su ogdilin kandin to mgo ka-otawan ko makita-an kandin. Dì agad diyà si Jesus to kahilitan, dì agad ando-i no banwa, pigmutmutan to mgo otow no naman-andu-on. ");
INSERT INTO did_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Pagkaugoy-lugoy nig-ulì on si Jesus diyà to Kapirna-um no lunsud. Pagkama-an to mgo ka-otawan to du-on on si Jesus to pig-ugpa-an din, naman-andu-on kandan. ");
INSERT INTO did_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Mahan-ing lagboy to nangkahimun du-on to atubangan to baoy. Ampan ogkali-otan to uu to otow no nahimun. Dayun nigpanoysoy si Jesus to kagi to Diyus. ");
INSERT INTO did_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ta-un pagpanoysoy ni Jesus, nigdatong to napulid no otow no piglahung to upat no ka-otow. ");
INSERT INTO did_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Wadà makali-ot sikan upat no ka-otow padoog diyà ki Jesus su mahan-ing no mgo otow no nahimun du-on no baoy. Dayun nigpikii kandan to ogpotos kandan diyà to babow to atop. Piggakasan dan to atop to litos-litos dà sikan hibatanan to pulid no otow. Pigtuntun dan du-on topad ni Jesus to otow no pulid su insalig dan ki Jesus to ogka-uli-an din to pulid. ");
INSERT INTO did_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Pagsabut ni Jesus to insalig dan lagboy du-on kandin to ogkadoyow din to pulid, nig-iling kandin diyà to pulid no otow to “Lagi, pigpasaylu kud on to mgo saà nu.” ");
INSERT INTO did_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Na, moydu-on namang-ingkud du-on no mgo mag-a-anad to tinu-uhan to mgo Hudiyu. Pig-iling dan du-on to domdom dan to ");
INSERT INTO did_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Intawa man otawa sikan no niglangub nig-ikagi to angod kan. Napa-inahan din to Diyus su nigpagsokod kandin podon to Diyus su kunon kun kandin to ogpakapasaylu to saà to otow. Intawa man to ogpakapasaylu to saà to otow ko konà no Diyus dà.” ");
INSERT INTO did_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Dì tahan dà nama-anan ni Jesus to nadomdoman to mag-a-anad no mgo otow. Nig-ikagi si Jesus, “Nokoy man no iniling now to domdom now ");
INSERT INTO did_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","su mahawoy dà to pagpasaylu to saà to napulid no otow. Dì malisod ko tambaan ta to pulid no otow. Malisod gayod to igpalukut ta to pulid no otow to hikam din aw pahipanawa kandin. ");
INSERT INTO did_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Moydu-on ig-ikagi ku diyà kan pulid no otow su awos mataga kow tibò to kanak no Tumutubus to Ka-otawan, nabogayan a to kabogbogan to pagpasaylu to saà to otow dini to babow to kalibutan.” Nig-iling gayod si Jesus diyà to pulid no otow to ");
INSERT INTO did_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Lagi, so-i to kagi ku ikow. Bangun kad on. Lukuta to hikam nu aw ulì kad on.” ");
INSERT INTO did_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Dayun nigbangun to pulid no otow aw lukuta to hikam din aw labas du-on to baoy no na-uli-an on to sakit din no nakita-an iyan to mgo ka-otawan. Naboong-boong to mgo ka-otawan aw sayà-sayà kandan to Diyus no nig-iling to “Aligbat kid og-ugpà bali ki pad kita to kaboonganan no angod sikan.” ");
INSERT INTO did_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Na nig-ulì on si Jesus diyà to boyboy to dagat. Moydu-on kahan-ingan no mgo otow no nigduguk du-on kandin. Pigpang-anad ni Jesus kan mgo ka-otawan no nahimun du-on to boyboy. ");
INSERT INTO did_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Pagkatapus din to pagpang-anad to mgo ka-otawan, nig-u-ugsud pad si Jesus du-on to boyboy. Nakabayà kandin to sukutanan to buhis. Pagkabayà din du-on, nakita-an din si Lebi no anak ni Alpiyu no nig-ingkud. Dayun pig-ikagihan ni Jesus si Lebi to “Lagi, kunto-on duma kad on kanak.” Dayun to nigsakindog kandin aw patiduma ki Jesus. ");
INSERT INTO did_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","16","Na nigponhik si Jesus aw mgo sakup din diyà to baoy ni Lebi su pigbana-an kandan du-on. Niglambag puli to mgo punu-an to tinu-uhan to mgo Hudiyu no kandan, mgo mag-a-anad aw mgo Parisiyu no lagboy mangkatinumanon to kandan katahanan. Paglambag kan mgo punu-an nakita-an dan si Jesus aw mgo sakup din no namango-on. Nigpagdongan si Jesus to pagko-on to mgo magsusukut to buhis aw duma pad no wadà tu-u to katahanan dan. Mahan-ing sikan no mgo otow no namanpasakup ki Jesus. Pagkita to mgo Parisiyu to nigpagdongan si Jesus to pagko-on kan no mgo otow, moydu-on ing-usip dan kan mgo sakup ni Jesus no nig-iling to “Nokoy man no nigpagdongan si Jesus to pagko-on sikan mgo magsusukut to buhis aw duma pad no wadà tu-u to katahanan ta.” ");
INSERT INTO did_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Pagkadinog ni Jesus to usip to mgo Parisiyu, impananglitan din no nig-iling to “To otow no og-abin to kandin sakit, ogpagawang kandin to ogtambaa to kandin sakit. Dì ko konà din og-abinon, amonuhon man to pagkagawang to sakit din. To ing-andini ku to kalibutan su ogtabang to mgo otow no ogpagawang kanak to saà dan. Konà no tu-ud ku to ogtabang to mgo otow no konà ogpagawang kanak to saà dan.” ");
INSERT INTO did_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Na to mgo sakup ni Juan no Magbobonyagay aw mgo sakup to Parisiyu, pigtagonan dan to katahanan dan no pu-asa. Dì to mgo sakup ni Jesus, wadà dan tagoni. Moydu-on mgo otow no namang-usip ki Jesus no nig-iling to “Nokoy man no wadà tagoni to mgo sakup nu to pu-asa. Dì to sakup ni Juan aw mgo sakup to Parisiyu, pigtagonan dan man.” ");
INSERT INTO did_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Puli impananglitan ni Jesus no nig-iling to “Ogpako-onon pad to mgo bumaba-ot to pagsauhan ko du-on pad to bana no bayà hitu-un. Dì ko mali-us on, ogpalaboy to pagko-on. ");
INSERT INTO did_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Moydu-on kagoto-an no adow to pagpahipanow to bana no bayà hitu-un. Kayan ogpamampu-asa to mgo bumaba-ot.” ");
INSERT INTO did_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Impananglitan mandà ni Jesus bahin to bayà no impang-anad din aw sikan tahan no impang-anad to mgo Parisiyu no wadà hidaag. Kagi din to “Konà ta ogtapakan to tahan no kabò no nahigbit to tatapakay no wadà pad kadakdaki. Ko ogtapakan ta, ogkokos to bayà no intapak. Pagkokos, oglisig to pagkahigbit kan pigtapakan.” ");
INSERT INTO did_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Impananglitan mandà ni Jesus bahin to bayà no impang-anad din no nig-iling to “Konà ta ogpagsambuon to bayà no inomon aw tahan no inomon no pingaa. Ko ogpagsambuon ta, mado-ot to ogkabauyan. Ogka-uwakan tibò, ton bayà no inomon aw tahan no inomon. Ogbugti-on ta to pagtagù awos wadà ogka-uwakan.” ");
INSERT INTO did_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Na to songo adow no konà no tigtatalabahu nighipanow si Jesus no pigdumahan to mgo sakup din no nigtaà kandan diyà to humayan aw mgo sakup din, kanunoy nalisig namangkotu to bogas to humoy. ");
INSERT INTO did_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nakita-an to mgo Parisiyu to namangkotu to mgo sakup ni Jesus. Wadà katu-udi to mgo Parisiyu su namantagon lagboy kandan to tinu-uhan dan. Nig-iling kandan to “Nokoy man no pighimu dan to konà podon ogtugutan to tinu-uhan ta to adow konà no tigtatalabahu.” ");
INSERT INTO did_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Nig-ikagi si Jesus to “Natodu-on no timpu ni Abiyatar no tumutubus to mgo ka-aw-apu-an ta diyà to atubangan to Diyus, niglisod si David no minuna ta to pagko-on din. Dow wadà kow buwa makabasa to nahimu ni David aw mgo sakup din to paglotoy dan no pagkalaguy dan no nahadok to kablang dan? ");
INSERT INTO did_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Namakasood kandan si David aw mgo sakup din du-on to simbahan to Diyus. Moydu-on paan no inhonat diyà to atubangan to Diyus. Sikan mgo tumutubus diyà to atubangan to Diyus du-on to simbahan, kandan dà podon to ogpakako-on sikan no paan. Dì puli on pigko-on ni David sikan no paan aw pigpamogayan din gayod to mgo sakup din. Sikan punu-an, wadà din patu-una to nakasaà si David su namanlotoy kandan.” ");
INSERT INTO did_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Kagi ni Jesus, “Pigbahin to Diyus to adow no konà no tigtatalabahu su awos matabangan ki, konà podon mabalatak. ");
INSERT INTO did_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kaling man kanak no Tumutubus to Ka-otawan, tagtu-un a gayod to adow no konà no tigtatalabahu.” ");
INSERT INTO did_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Na nigsood mandà si Jesus to simbahan. Moydu-on otow no pawing no nignohut to boad no nigsood gayod du-on to simbahan. Du-on gayod to mgo Parisiyu no namantagon lagboy to kandan tinu-uhan. ");
INSERT INTO did_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Sikan mgo Parisiyu, pigbantayan dan lagboy si Jesus dow ma-uli-an din kan pawing no otow to adow no konà no tigtatalabahu to mgo Hudiyu. Ko ma-uli-an iyan ni Jesus kan pawing, igdiklamu dan podon si Jesus no mgo Parisiyu diyà to mata-as dan. ");
INSERT INTO did_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Si Jesus, nig-ikagi diyà to pawing, “Duguk ka.” ");
INSERT INTO did_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Dì nig-usip si Jesus sikan mgo Parisiyu to “Dow nokoy to hustu to oghimuhon ta to adow no konà no tigtatalabahu. Dow madoyow ko og-uli-an ta to padihu ta no nasakit, dow sugayon ta nasì. Dow madoyow ko ogtabangan ta to nasakit dow himatayan ta nasì. Dow nokoy to insugù ita bahin to adow no konà no tigtatalabahu.” Nangka-ompongan to mgo Parisiyu no namantagon to kandan tinu-uhan. ");
INSERT INTO did_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Impasosollong ni Jesus to pagpangahà-ahà din kan mgo otow no nahimun. Wadà katu-udi kandin to bo-ot kan mgo Parisiyu. Si Jesus, nig-ikagi diyà to pawing, “Kotongad to boad nu.” Dayun pigkotong to napawing to boad din aw dayun ka-uli-id on. ");
INSERT INTO did_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Dayun namanlabas to mgo Parisiyu du-on to simbahan. Pagkalabas dan nigpagsukun kandan to mgo sakup ni Harì Hirudis dow amonuhon to pagpadoog to paghimatoy dan podon ki Jesus. ");
INSERT INTO did_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Na nighipanow on si Jesus aw mgo sakup din padoog diyà to dagat. Namanduma to kahan-ingan no taga-Galiliya. Moydu-on pad mgo otow no nakadinog to moydu-on pighinang ni Jesus no kaboonganan. Pagkadinog dan to tibò to pighinang ni Jesus, pig-andiya-an kandin to kahan-ingan no otow likat to nigsingkabugtì no banwa no Hudiya, Hirusalim, Idumiya, Tiru, Sidun, aw diyà to dihipag to Hurdan no wohig. ");
INSERT INTO did_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Pagdatong to kahan-ingan no ka-otawan diyà to dagat, pigsugù ni Jesus to mgo sakup din to ogpapudut kandin to bautu. Nigpapudut kandin su awos ko mahimun to ka-otawan, konà madasok kandin ");
INSERT INTO did_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","su bantugan si Jesus su nangka-uli-an din man to kahan-ingan no masakiton. Kaling man nadasokan kandin to mgo nangkasakit su awos makadawat kandan ki Jesus. Nama-anan to nangkasakit ko makadawat kandan ki Jesus, ogka-uli-an on. ");
INSERT INTO did_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","To mgo busow, ko kumita on ki Jesus, ogpakaluhud to otow no pigsoodan dan aw maka-iling to “Ikow, Anak ka to Diyus.” ");
INSERT INTO did_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Dì pigbahog lagboy ni Jesus kan mgo busow no nig-iling to “Ayaw kow ogpakilaa to kanak no Anak to Diyus.” ");
INSERT INTO did_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Na pigpamilì ni Jesus to mgo sakup din aw padumaha din kandan diyà to untud. Pagdatong dan du-on to untud, ");
INSERT INTO did_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","pighinang din no pangabaga kan sampuù tag duwa no ka-otow no duma din no ogpatubuson din. Singaman to ogpagduma kan pangabaga ki Jesus. Singaman to ogpamanbugtì kandan oghipanow aw panoysoy to Madoyow no Tutuwanon. ");
INSERT INTO did_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Pigbogayan ni Jesus kan mgo pangabaga din to kabogbogan to oggawang to mgo busow no nigsood to mgo otow. ");
INSERT INTO did_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Na so-idi to mgo pangabaga ni Jesus: si Simon no pighingadanan gayod ki Pedro, ");
INSERT INTO did_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","aw mgo anak ni Sibidiyu no si Santiago aw si Juan. Si Jesus, niggoa ki Santiago aw ki Juan ki Buwanirgis no litukan to madaas ogkaboù. ");
INSERT INTO did_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","So-idi gayod to pangabaga ni Jesus: si Andres, Felipe, Bartolome, Mateo, Tomas, si Santiago no anak ni Alpiyu, si Tadeo, aw si Simon no sakup to punduk to mgo otow no mapatubuk-tubukon to bandila. ");
INSERT INTO did_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Si Judas Iskariyuti, pangabaga dà gayod ni Jesus no kandin to nigbaligyà ki Jesus diyà to kablang din. Pagkatapus ni Jesus to pagpanghinang to pangabaga din, namang-ulì on kandan. ");
INSERT INTO did_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Pagdatong dan, mahan-ing lagboy to ka-otawan no nangkahimun du-on aw mgo mag-a-anad gayod to tinu-uhan no taga-Hirusalim. Kaling man konad ogpakako-on si Jesus aw mgo sakup din su mahan-ing to mgo otow du-on. ");
INSERT INTO did_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","22","Naman-iling to ka-otawan to “Langog buwa so-idi no otow.” Naman-iling to mgo mag-a-anad to “Sikan no otow, pigsoodan buwa ni Bilsibul no iyan si Satanas. Nabogayan kandin to kabogbogan to tagtu-un to mgo busow to ogpakagawang to mgo busow ko ogsood to mgo otow.” Na to mgo kadumahan ni Jesus, pagkadinog dan to nawnangonon to mgo otow bahin kandin, naman-andu-on kandan ki Jesus su ogdokaton dan kandin. ");
INSERT INTO did_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Dì pigpaduguk ni Jesus to mgo ka-otawan aw mgo taga-Hirusalim no mag-a-anad aw ipananglitan din no nig-iling to “Dow ma-amonu to paggawang ni Satanas to kandin tu-un no mgo sakup. ");
INSERT INTO did_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Madaas dà to katapusan to sinakupan ko gawangon to panguu kan mgo sakup din. ");
INSERT INTO did_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Madaas dà to katapusan to songo manwa ko ogkinablangay kandan. ");
INSERT INTO did_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ko gawangon ni Satanas to mgo sakup din, madaas gayod to katapusan to sinakupan din.” ");
INSERT INTO did_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Na impananglitan mandà ni Jesus no nig-iling to “Na to tagbaoy, ko mabuut, konà ogkapudutan to tingub din. Dì ko mada-og to tagbaoy, kayan pana ogkapudutan on kandin to tingub din.” Sikan to impananglitan ni Jesus. ");
INSERT INTO did_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Nig-iling si Jesus to “Na to pagpasaylu to saà, ognangonan ku iyu to ogkapasaylu dà to Diyus to agad nokoy no saà. Agad ma-ina-ina to Diyus, dì ogkapasaylu dà. ");
INSERT INTO did_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Dì to otow no oglangub og-ina-ina to Ispiritu Santu, konad on iyan ogkapasaylu kandin hantod to wadà katapusan.” ");
INSERT INTO did_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Sikan to na-ikagi ni Jesus su nig-iling to mgo mag-a-anad to “Pigsoodan si Jesus to busow.” ");
INSERT INTO did_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","32","No nalibongan pad si Jesus to mgo ka-otawan no pig-anad din, nigdatong to inoy din du-on aw su-un din. No diyà pad to solib impatawag dan puli si Jesus. Namang-ikagi to mgo ka-otawan to “Nigdatong on to inoy nu aw su-un nu no du-on pad to solib. Ogpa-andiya-on ka podon.” ");
INSERT INTO did_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Nig-ikagi si Jesus to “Intawa lagboy to inoy ku aw mgo su-un ku.” ");
INSERT INTO did_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Nigpanlingì-lingì aw nigpangahà-ahà si Jesus du-on kan mgo otow no namang-ingkud. Nig-iling kandin diyà kan namanlibong no mgo otow, “Iyu on iyan angay to inoy ku aw mgo su-un ku. ");
INSERT INTO did_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","To otow no ogtuman to pagbo-ot to Diyus, sikan on to angay hadi ku aw atoboy ku aw inoy ku.” ");
INSERT INTO did_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Na nigpang-anad mandà si Jesus diyà to boyboy to dagat. Mahan-ing to mgo otow no nahimun du-on ki Jesus aw nadasok. Kaling man nigluwan si Jesus diyà to bautu no nigpaotow-lotow du-on to babow to dagat aw ingkud kandin. Dì sikan mgo ka-otawan, du-on to boyboy to dagat. ");
INSERT INTO did_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Na nigpang-anad si Jesus to mgo ka-otawan no impabayà to mahan-ing no pananglitan. Nig-iling kandin to ");
INSERT INTO did_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Na ogtutuwanan kow to otow no nig-odok to humoy. No makalangkob to sangab, pigsawodan din to binhì. ");
INSERT INTO did_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Pagsawod din, moydu-on binhì no nigdo-og diyà to daan. Nigpatipadpad to manuk-manuk aw pantubug-tubuga. ");
INSERT INTO did_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Moydu-on gayod binhì no ngdo-og diyà to pasak no batuhon. Nigtulin da kan niggitì diyà to batuhon. ");
INSERT INTO did_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Dì pag-ugtu to soga, niglanos su wadà ogkaduhugan to dalid. ");
INSERT INTO did_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Moydu-on gayod binhì no nigdo-og diyà to pasak no dalidon, no kan dalid, dugihon. Pagkaugoy nigtulin to dugi, aw kan mgo tanom, piglinop aw kasakbut, Kaling man wadà bogas. ");
INSERT INTO did_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Dì moydu-on gayod binhì no nigdo-og diyà to madoyow no pasak aw sikan to nig-abut. Nigtulin to madoyow aw abut to dakoo, hantod to moydu-on nig-abut no madakoo. Moydu-on niggatus aw moydu-on nigkan-oman aw moydu-on nigkatlu-an to nig-abut. ");
INSERT INTO did_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Na, agad intawa no nakadinog, pangindaagan to kalitukan to pananglitan ku.” ");
INSERT INTO did_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Na nighipanow on sikan mgo ka-otawan. Pagkali-us to mgo ka-otawan, pig-usip si Jesus kan sampuù tag duwa no pangabaga din aw duma no sakup din dow nokoy to kalitukan to pananglitan din. ");
INSERT INTO did_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Nig-ikagi si Jesus to “Tudo-on mahobong to kalitukan aw kadaoman pad, imbogoy dà iyu to ogkama-anan now ko bahin to sinakupan to Diyus. Kunto-on pigbadbadan kow on to Diyus. Dì igpananglitan ku dà diyà to mgo ka-otawan no wadà labot to pagsakup to Diyus no nabigtoan on ");
INSERT INTO did_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","su tùtu-u to kagi to Diyus bahin to mgo ka-otawan no pig-iling to ‘Agad mangahà-ahà kandan, dì wadà ogkakita-an dan. Agad duminog kandan, dì konà ogpakadaag, su ko wadà podon angod sikan, dagow og-oyowan dan to katahani dan no bugtì aw kapasaylu dà.’” ");
INSERT INTO did_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Nig-iling si Jesus to “Dow wadà kow makasabut sikan no pananglitan ku? Amonu kow man ogpakasabut to duma no pananglitan ku su wadà kow man makadaag sikan no pananglitan.” ");
INSERT INTO did_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Na nigpanoysoy si Jesus to kalitukan to pananglitan din. Kagi din to “Tugdow, sikan mgo binhì no ing-odok, iyan na-angodan to kagi to Diyus aw mgo otow no nigdawat kan kagi. ");
INSERT INTO did_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Sikan binhì no nigdo-og diyà to daan, iyan on na-angodan to mgo otow no ogdinog to kagi to Diyus. Sikan no mgo otow, ko ogdinog kandan to kagi to Diyus, og-abut du-on kandan si Satanas. Ogsakmiton dà ni Satanas to kagi to Diyus no pigdinog dan. ");
INSERT INTO did_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Sikan binhì no nigdo-og diyà to batuhon, iyan na-angodan to mgo otow no ogkaliyag to ogpaminog to kagi to Diyus aw dawata. ");
INSERT INTO did_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Dì ogka-abutan to kalisod aw pahadati to kadumahan dan ugpat to kagi to Diyus. Pag-abuti to kalisod, nig-oyow dayun kandan to pagtu-u dan. ");
INSERT INTO did_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Na moydu-on duma no mgo otow no iyan na-anogdan to binhì no nigdo-og diyà to pasak no dalidon no paggitì dugihon. ");
INSERT INTO did_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Sikan kagi to Diyus diyà to domdom dan, piglinop on su nakasakbut to ogkapookan dan dini to babow to kalibutan aw mgo pagkaliyag dan to kadatù aw duma pad no kadomdomanan dan. Kaling man wadà nig-abut no bogas. ");
INSERT INTO did_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Dì sikan binhì no nigdo-og diyà to madoyow no pasak, iyan na-angodan to mgo otow no ogpaminog to kagi to Diyus aw tuman. Pig-usab to Diyus to ginhawahan dan aw moydu-on tagkatlu-an no nig-abut. Moydu-on gayod kan-oman. Moydu-on gayod nig-abut no ginatus to pagdoyow.” Sikan to pagsoysoy ni Jesus to pananglitan din. ");
INSERT INTO did_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Impananglitan mandà ni Jesus no pig-iling to “Ko ogpadokotan ta to ilawan, dow ogsangkuban ta to lata? Dow igbotang ta to ilawan du-on to saom to ingkudanan? Igbotang ta du-on to so-og su awos matang-awan tibò du-on to baoy. ");
INSERT INTO did_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Tibò kan mahobong kunto-on, ogka-ukasan to mahudi no adow. ");
INSERT INTO did_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ogpaminog kow lagboy to kagi ku.” ");
INSERT INTO did_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","25","Nig-iling si Jesus to “Konà now ogkalingawan so-idi no kagi ku. Ko puma-awos kow to pagsabut to igpang-anad ku, ogkadugangan gayod to nama-anan now, su sikan kotob to igkabogoy now, sikan dà to ogka-ontopan to ogkadawat now gayod. Dì ko konà kow puma-awos agad ma-intok to nama-anan now, dì ogkapudutan kow pad nasì to nama-anan now.” ");
INSERT INTO did_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Nig-ikagi mandà si Jesus to “To pagdakoo to sinakupan to Diyus, iyan on na-angodan to pagdakoo to tanom ta. Ko ti-o-odok on, puli kid og-odok. ");
INSERT INTO did_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","To madukilom oghibat ki. To adow ogbangun ki, dì wadà ki kataga dow og-amonu to paggitì to binhì du-on to pasak. ");
INSERT INTO did_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Puli on oglogwà to dohun. Pagsunù nigpamagting on. Pag-usab nigbogas on. ");
INSERT INTO did_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ko mahinug on to bogas, puli kid on og-ani. Wadà ta katagahi to paghan-ing to tanom ta.” Sikan to pananglitan ni Jesus bahin to pagdakoo to sinakupan to Diyus. ");
INSERT INTO did_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Na pigsugpatan ni Jesus to pagpang-anad no nig-iling to “Na nokoy buwa to madoyow no pananglitan no ogka-angodan to pagdakoo to sinakupan to Diyus. ");
INSERT INTO did_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","To pagdakoo to sinakupan to Diyus, iyan no-angodan to pagtanom to binhì to longa no magabudbud dà. Agad kina-intokan no binhì to pagtanom ");
INSERT INTO did_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","dì ogdakoo man. Paggiti, ma-aslag lagboy no tanom. Ogpananga-sanga aw kahapuni to manuk-manuk du-on to sanga no lambungan agad likat to binhì no magabudbud dà.” Sikan to pananglitan ni Jesus bahin to pagdakoo to sinakupan to Diyus. ");
INSERT INTO did_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Mahan-ing kan no mgo pananglitan no impanoysoy ni Jesus to kagi to Diyus. Nigpanoysoy kandin hantod to ogkasabutan to mgo ka-otawan. ");
INSERT INTO did_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Wadà panoysoy si Jesus to mgo ka-otawan ko konà din igpananglitan. Sikan dà kandin mgo sakup to ogbadbadan din to pananglitan ko mali-usan to mgo ka-otawan. ");
INSERT INTO did_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Na pagkahapun on, nig-ikagi si Jesus diyà to mgo sakup din, “Ogtalipag kid diyà dihipag.” ");
INSERT INTO did_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Dayun nigpasuwoy kandan to mgo ka-otawan diyà to boyboy to dagat. Pagsuwoy dan, nigsakoy si Jesus aw mgo sakup din to bautu no pgi-ingkudan ni Jesus pagpang-anad din. Moydu-on duma no bautu no nigsunduu to pigsakayan ni Jesus. ");
INSERT INTO did_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Pagkaugoy-lugoy nig-abut to kamag no nigkumus to sakayan. Magabubungan to baod to dagat no ogkalukut-lukut aw katagu-i to wohig du-on to sakayan. ");
INSERT INTO did_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Dì si Jesus du-on dà to uling to bautu no nalimogtokan to paglipodong no nig-u-uu-an. Dayun pigpukow si Jesus to mgo sakup din aw namaka-ikagi to “Sir, dow wadà ka-at nu? Kamuwa kid buwa.” ");
INSERT INTO did_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Nakagimata si Jesus aw sapadi to kamag. Nig-iling kandin diyà to dagat, “Sigkon kad.” Nighagtong dayun to kamag. Ampan pad ogpangidù-kidù to dagat. ");
INSERT INTO did_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nig-ikagi si Jesus to “Nokoy man no ogkahadok kow. Nokoy man no wadà kow salig to Diyus no nigbantoy iyu.” ");
INSERT INTO did_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Naboong-boong lagboy sikan mgo sakup ni Jesus aw ka-inusipay to “Intawa nò buwa so-idi no otow su to kamag aw dagat, ogpakatuman dà ko ogsugu-an din.” ");
INSERT INTO did_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Na nigdatong si Jesus aw mgo sakup din diyà to banwa no diyà dihipag to dagat no pighingadanan to Gidasa. ");
INSERT INTO did_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Paghaw-as ni Jesus, pigsungun kandin to otow no niglikat to lobonganan no kandin, pigsoodan to busow. ");
INSERT INTO did_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Nig-ugpà puli kandin diyà to lobonganan Konà ogkabakus to sangkalì ");
INSERT INTO did_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","su agad pigbakus to boad din to sangkalì dì nabigtow din dà to sangkalì. Pigbinakus gayod to kobong to sangkalì dì nabigtow din dà gayod to sangkalì. Konà ogkatogon su madoson kagboy kandin. ");
INSERT INTO did_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Adow aw madukilom, kadoog ognginangang kandin aw pambukbuka to lawa din to batu. Ogkadinogan to pinangiyakon to langog diyà to lobonganan aw du-on to ka-untudan. ");
INSERT INTO did_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Na og-uli-on tad to tutuwanon ki Jesus. Agad diyà pad to madiyù, dì nakita-an si Jesus to otow no pigsoodan to busow. Dayun niglaguy no nigsungun ki Jesus. Nigluhud dayun kan otow du-on to atubangan ni Jesus. ");
INSERT INTO did_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Kagi ni Jesus, “Ikow no busow, gawang kad du-on kandin.” Nigpangiyak kandin aw sa-og to “Wadà labot nu kanami Jesus, su Anak ka to Kinalabawan no Katuusan. Ogpamatu-udon ku to Diyus aw nangoni ku ikow to konà a nu na-ay ogpahadatan.” ");
INSERT INTO did_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Nig-usip si Jesus to “Intawa to ngadan nu.” Nigtabak kandin to “To ngadan ku si Minaan su mahan-ing koy.” ");
INSERT INTO did_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nigpangnmuyù lagboy kandan ki Jesus to konà ogpagawangon kandan no mgo busow du-on to kandan banwa. ");
INSERT INTO did_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Na du-on moydu-on mahan-ing no mgo babuy no namandungaa diyà to augan. ");
INSERT INTO did_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Sikan mgo busow, nangamuyù ki Jesus no nig-iling to “Pasooda koy podon du-on suyà mgo babuy.” ");
INSERT INTO did_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Na pigtugutan ni Jesus aw gawang to mgo busow du-on kan pigsoodan dan aw sood kandan diyà to mgo babuy no mgo daduwa no mann. Namanlaguy tibò to mgo babuy diyà to augan aw pamanpatidaplus diyà to dagat aw kangkaonod tibò. ");
INSERT INTO did_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Na to mgo otow no nigbantoy to mgo babuy, namanlaguy on aw nawnangonon kandan diyà to lunsud aw diyà to kahilitan to nadoogan kan otow. Dayun nbamang-andu-on to ka-otawan awos pumaangintaga to napugutan. ");
INSERT INTO did_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pagduguk dan ki Jesus, nakita-an dan ton otow no pigsoodan to busow no nabatuk on to domdom din. Nangabò on kandin aw puli ingkud du-on. Nangkaboong-boong to mgo ka-otawan du-on ");
INSERT INTO did_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","su nanangonan kandan to napugutan to babuy aw otow no pigsoodan to mgo busow su sikan nignangon kandan, nakakita lagboy to napugutan. ");
INSERT INTO did_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nangamuyù on sikan mgo otow ki Jesus to ogpagawangon on kandin du-on to kandan no banwa. ");
INSERT INTO did_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Na nighipanow on si Jesus. Pagkaluwan ni Jesus to bautu, pigduguk kandin to otow no nagawangan on to busow. Nigpangamuyù kandin ki Jesus to ogpadumahon podon kandin. ");
INSERT INTO did_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Dì wadà tuguti ni Jesus. Nig-ikagi si Jesus to “Aya kad on, Lagi, Dì ulì kad on nasì diyà to ikow no banwa aw tutuwani to mgo kadumahan nu no pigka-atan kad on aw tabangi ka to Magbobo-ot to Kalibutan.” ");
INSERT INTO did_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Dayun nighipanow on sikan otow aw pannangoni din to mgo taga-Dikapulis to lagboy kandin pigtabangan ni Jesus. Lagboy naboong-boong tibò to mgo otow no taga-Dikapulis. ");
INSERT INTO did_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Na nigpa-ulì on si Jesus diyà dihipag to dagat. Pagdu-ung dan diyà to boyboy nahimunan mandà kandin to mgo ka-otawan. ");
INSERT INTO did_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Moydu-on nigduguk du-on-ki Jesus no otow no punu-an to simbahan. Iyan ngadan din si Hairu. Pagkakita din ki Jesus nigluhud kandin diyà to atubangan din. ");
INSERT INTO did_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Nigpangamuyù kandin ki Jesus to ogpatambaan din to batà din no nasakit no nig-iling to “Sir, pakamatayon on to batà ku no dawdaga. Igpadampon ku ikow podon awos ma-uli-an.” ");
INSERT INTO did_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Dayun nigduma si Jesus sikan otow no punu-mbahan. Paghipanow dan pigdumahan si Jesus to kahan-ingan no mgo otow aw kadasok kandin. ");
INSERT INTO did_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nasunduwan kandin to byag no moydu-on sakit no kanunoy piglabasan to langosa to sood on to sampuù tag duwa no tu-ig pagkadawdaa din. ");
INSERT INTO did_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nakatuway-ay puli kandin to intambaa to mahan-ing no mgo magtatambaay. Piggastu din to tibò no sapì din aw tingub to pagpamakut din no nigpa-aput. Dì nasì on ogdo-oo to sakit no pagtambaa to magtatambaay. ");
INSERT INTO did_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Dì nakadinog sikan buyag to nawnangonon bahin to piganambaan ni Jesus. Kaling man nigsunduu kandin ki Jesus aw tumana din to ginhawa din no pig-iling to “Domdom ku ko puli a makatudì to kabò din, ogka-uli-an a.” ");
INSERT INTO did_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","No makatudì kandin to kabò ni Jesus, dayun nigtigpok on to paglangosa aw binatì on to buyag to na-uli-an on kandin. ");
INSERT INTO did_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nigbati si Jesus to piglogwa-an kandin to kabogbogan. Nakalingì kandin du-on to kabakna-an to kahan-ingan aw maka-ikagi to “Eh, intawa to nigtudì to kabò ku.” ");
INSERT INTO did_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Naman-iling to mgo sakup din to “Mano nigkita ka man to kahan-ingan no otow no iyan nakadasok ikow, nokoy man no og-usip ka pad dow intawa to nigtudì ikow.” ");
INSERT INTO did_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Nigpanlingì-lingì si Jesus dow intawa to nigtudì kandin. ");
INSERT INTO did_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nama-anan kan buyag to na-uli-an on kandin aw duguk on nasì dupon ki Jesus aw pidpida aw makaluhud du-on ki Jesus aw abina to kandin iyan to nigtudì to kabò aw ka-uli-i kandin dayun. ");
INSERT INTO did_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Kagi ni Jesus, “Laginà, na-uli-an kad on su nigsalig kad to ogpaka-uli a ikow. Ma-uli-an kad on to sakit nu. Konà ka ogkapook-pook. Ulì kad on to ikow.” ");
INSERT INTO did_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Na og-uli-on tad to tutuwanon to otow no nigdaa to kahimunan to simbahan no si Hairu. No ta-un pad nig-i-ikagi si Jesus, nigdatong to otow likat to baoy ni Hairu no nignangon kandin to “Nabigtawan on ton batà nu. Nokoy man no ogpadumahon ta pad si Sir.” ");
INSERT INTO did_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Dì nakadinog dà si Jesus to nawnangonon aw ikagi diyà ki Hairu to “Konà ka ogkapook-pook to batà nu. Salig ka dà to ogkatabangan ku ikow.” ");
INSERT INTO did_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Na nigto-od kandan dì iyan dà pigpaduma ni Jesus si Pedro, si Santiago, aw si Juan no hadi ni Santiago. ");
INSERT INTO did_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Na nigdatong kandan diyà to baoy to nigdaa to kahimunan to simbahan. Pagdatong dan, iyan on nakita-an ni Jesus to mgo ka-otawan no nigsasabog-sabog no nigkukuus aw sinogow aw daugmatoy. ");
INSERT INTO did_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Pagkasapat ni Jesus, nig-ikagi kandin to “Nokoy man to pigkukuusan now aw pamansinogow kow. Wadà man kamatoy to batà, Nalipodong puli.” ");
INSERT INTO did_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Dì puli pigngisihan si Jesus to mgo ka-otawan. Dì pigpalabas kandan ni Jesus du-on to baoy. Dayun nigsood si Jesus to sinabong no pigkotangan to batà. Iyan dà pigpasood din gayod ton tatou no pangabaga din aw amoy aw inoy. ");
INSERT INTO did_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Dayun pigdawat ni Jesus to boad to batà aw ikagi si Jesus to kandin inikagihan no pig-iling to “Talita kumi,” no litukan to “Igi, bangun ka.” ");
INSERT INTO did_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Dayun no malituk to kagi ni Jesus, nakabangun to batà aw makahihipanow su konà no ma-intok pad lagboy no batà su sampuù on tag duwa to panu-igon din. Naboong-boong to mgo ka-otawan. ");
INSERT INTO did_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Pigbahog lagboy ni Jesus to konan ogpatangkapon to nawnangonon bahin sikan kaboonganan. Dayun pigsugù ni Jesus to ogpako-onon kan batà no pigbuhoy din. ");
INSERT INTO did_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Na niglikat on si Jesus du-on sikan no banwa no og-ulì diyà to kandin banwa no pigdumahan to mgo pangabaga din. ");
INSERT INTO did_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","To tigsisimbahay nigpang-anad si Jesus diyà to simbahan. Naboong-boong to mgo otow no nigpaminog to impang-anad din. Nigka-inusipay kandan to “Dow ando-i buwa makalikat to impang-anad so-idi no otow. Dow ando-i likat to nama-anan din. Nokoy sikan no kaboonganan no nadinogan ta no pighimu ni Jesus. ");
INSERT INTO did_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kandin no maghihimu to baoy, anak iyan ni Maria. Kakoy iyan ni Santiago kandin. Si Jose aw si Judas aw si Simon, hadi din. Mgo atoboy din, dini pad ugpà to ita no banwa.” Kaling man nasawa-an dan kandin su intobo-ot dan dow puli niglangub kandin nigpalabow-labow. ");
INSERT INTO did_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Kagi ni Jesus, “Tahan to otow, su agad ando-i no banwa, igkatahud to mgo otow to maglilikwaday to Diyus. Dì diyà to kandin banwa, konà igtahud. Konà gayod igtahud to maglilikwaday to mgo kasu-unan din aw mgo sood diyà to kandin baoy.” ");
INSERT INTO did_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kaling man wadà lagboy palabasa ni Jesus to kaboonganan diyà to kandin banwa. Iyan dà pighimu din to pigdampon to pilahon dà no masakiton aw ka-uli-i din. ");
INSERT INTO did_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Naboong-boong si Jesus su wadà tu-uhi kandin no Imananan to Ka-otawan. Dayun nighipanow on si Jesus aw panlibod-libod to mgo kalunsudan to pagpang-anad din. ");
INSERT INTO did_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Na pigpaduguk ni Jesus kan sampuù tag duwa no pangabaga din aw himuha din kandan no tumutubus din diyà to mgo ka-Isrilihan. Pigbogayan din to igpahimu din kandan. Pigpahipanow din to tag daduwa aw bogayi din to kabogbogan to ogpakagawang to mgo busow du-on to pigpansoodan. ");
INSERT INTO did_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Wadà tuguti ni Jesus to pagdaa to ba-aw, balutan, ilisan, aw sapì. Dì pigsugù din to mgo pangabaga din to ogpanapatus aw agos dà to igpadaa din. ");
INSERT INTO did_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kagi ni Jesus, “Ko moydu-on ogpagduma iyu, sikan dà no baoy to og-agpotan now, konà kow on oghinalin to agpotan now. Ugpà kow to sobu-uk dà no baoy diyà to songo banwa. ");
INSERT INTO did_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ko konà kow dawaton diyà to songo banwa, labayi now du-on. Ko konà ogpaminog to mgo otow to pangudlin now, labayi now du-on to kandan banwa. Ko lumikat kow, padpada to abug to kobong now su awos ogkakilaa dan to wadà labot now kandan.” Sikan to sugù ni Jesus diyà to mgo pangabaga din. ");
INSERT INTO did_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Dayun nighipanow on to mgo pangabaga ni Jesus aw pangudlin to mgo otow to ogsosoo aw oyowi to katahanan dan no mado-ot. ");
INSERT INTO did_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Namakagawang to mgo pangabaga to mahan-ing no busow no nigsood to mgo otow. Namaka-ulì kandan gayod to mgo masakiton no impabayà to pighidhidan dan to lana. ");
INSERT INTO did_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Na nakadinog si Harì Hirudis to nawnangonon bahin ki Jesus su bantugan on si Jesus. Moydu-on mgo otow no nig-iling to “Si Juan no Magbobonyagay buwa sikan no otow no pigbuhoy on. Kaling man moydu-on kabogbogan din no katuusan.” ");
INSERT INTO did_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Moydu-on mgo otow no nig-iling gayod to “Ton maglilikwaday buwa no si Elias sikan no otow.” Moydu-on gayod mgo otow no nig-iling to “Maglilikwaday buwa si Jesus angod to tùtu-u no maglilikwaday to Diyus natodu-on.” ");
INSERT INTO did_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Dì si Harì Hirudis, pagkadinog din to nawnangonon, naka-ikagi kandin to “Aboy ko pigbuhoy dà si Juan no pigpatampodan ku to li-og natodu-on.” ");
INSERT INTO did_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Na, og-uli-on tad to tutuwanon no napa-atubangan to kagi ni Hirudis no sikan, nalipasan tad. Natodu-on no wadà pad kamatoy si Juan, si Harì Hirudis, pig-agow din to buyag no pighingadanan ki Hirudiyas. Sikan no buyag, asawa to hadi ni Harì Hirudis no iyan ngadan si Felipe. ");
INSERT INTO did_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Pag-agow ni Harì Hirudis sikan no buyag, impanagda kandin ni Juan no nig-iling to “Ing-okod to tinu-uhan to pag-agow to asawa to hadi nu dà.” ");
INSERT INTO did_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Sikan buyag no si Hirudiyas, nasokò. Impadakop din si Juan to bana din no harì. Pigpahimatayan din podon si Juan su ogbaosan din podon. Dì wadà tuguti ni Harì Hirudis ");
INSERT INTO did_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","su intahud din si Juan. Nama-anan din no matuwadong no otow si Juan. Kaling man puli din impapirisu si Juan. Naliyag si Harì Hirudis to ogpaminog to pangudlin ni Juan dì nalibug-libug to domdom din. ");
INSERT INTO did_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Na sikan buyag no si Hirudiyas, moydu-on adow din no imbaos din ki Juan. Si Harì Hirudis, nighimu to hinang no pasalamat to pagka-otow din. Pigpatawagan din to mgo otow no moydu-on katondanan aw mgo mangkata-as to mgo sundau, aw mangka-aslag no mgo otow no taga-Galiliya. ");
INSERT INTO did_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Impatawag din gayod to daga no anak ni Hirudiyas no asawa din. Pigpasayow din to daga. Naliyag si Harì Hirudis aw sikan mgo otow no nahimun to pagsayow to daga. Naka-iling si Harì Hirudis diyà to daga to “Igì, agad nokoy no ogpangamuyu-on nu kanak, igbogoy ku dà ikow.” ");
INSERT INTO did_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Pigbogat din to pag-ikagi din no insahad to ogbogayan to daga to agad nokoy to ogpangamuyu-on din, agad katongà to kadatù din. ");
INSERT INTO did_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Na niglogwà kan daga aw andiyà to inoy din. Nig-usip kandin, “Inoy, dow nokoy to igpapangamuyù nu kanak.” Nigtabak to inoy to “Iyan pangamuyu-a to uu ni Juan no Magbobonyagay.” ");
INSERT INTO did_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nigpati-ulì dayun to daga diyà ki Harì Hirudis aw i-ikagi din to “Patampodi to li-og ni Juan no Magbobonyagay. Ibotang to uu ni Juan diyà to bandihadu aw ibogoy kanak.” ");
INSERT INTO did_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nakasosoo dà podon to harì dì konà din on iyan ogkabalibad to na-ikagi din diyà to daga su pigbogat din lagboy to kagi to pagsahad din diyà to atubangan to mgo otow no nahimun du-on to hinang din. ");
INSERT INTO did_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","No bali wadà din on kasalipoguti, na-igoy ni Harì Hirudis to sundau to ogpa-andiya-on to pirisuhan aw patampodi din si Juan to li-og awos ipadaa to uu diyà to daga. Dayun niglogwà to sundau aw tampodi si Juan diyà to pirisuhan. ");
INSERT INTO did_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Pigdaa din to uu ni Juan diyà to daga. Pigdaa gayod to daga diyà to inoy din. ");
INSERT INTO did_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Dayun nakadinog to mgo sakup ni Juan to namatoy on kandin. Pagkadinog dan, nig-andu-on aw ilobong dan si Juan. ");
INSERT INTO did_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Na og-uli-on tad to nawnangonon to mgo pangabaga ni Jesus. Pagkatapus to panow dan, nig-ulì kandan. Pignangonan dan si Jesus to pigpanghinang dan aw impangudlin dan to paghipanow dan. ");
INSERT INTO did_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kagi ni Jesus, “Ogpagsuwoy ki to mgo ka-otawan su awos makasigkon ki pad,” su mahan-ing to namang-ulì, mahan-ing gayod to ogpamang-abut hantod to konad ogpango-on-ko-on si Jesus aw mgo sakup din. Kaling nig-ikagi si Jesus to og-andiyà kandan to kahanongan no banwa su ogpamansigkon pad kandan. ");
INSERT INTO did_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Dayun namansakoy kandan no si Jesus aw mgo pangabaga din du-on to bautu. Niglayag kandan padoog diyà to kahanongan no banwa no diyà dihipag to dagat. ");
INSERT INTO did_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Paglayag ni Jesus aw mgo pangabaga din, nakita-an dà kandan to mgo ka-otawan no taga-lunsud. Namanladgad no ogtokap kandan to boyboy to dagat padoog gayod diyà to kahanongan no banwa. Naka-una kandan ki Jesus aw kahimun diyà to kahanongan no banwa no du-on sikan pigtagadan dan ki Jesus. Dayun nig-abut si Jesus aw mgo pangabaga din gayod. ");
INSERT INTO did_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Paghaw-as ni Jesus, iyan nakita-an din to mgo ka-otawan no nahimun on tahan. Nigka-at si Jesus to mgo ka-otawan su iyan on na-angodan dan to mgo buhì no wadà nigbantoy. Mahan-ing to impang-anad ni Jesus to mgo ka-otawan du-on to kahanongan no banwa. ");
INSERT INTO did_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Na, pagkahapun nigduguk to pangabaga diyà ki Jesus aw pamang-ikagi to “Sir, kahanongan on no banwa so-idi aw sakot mahapun on. ");
INSERT INTO did_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Pahipanawad so-idi mgo otow diyà to kalunsudan aw kasityuhan awos ogboli to ogkako-on dan.” ");
INSERT INTO did_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Dì nig-ikagi si Jesus to “Iyu on to ogbogoy to ogkako-on dan.” Naka-ikagi to pangabaga ni Jesus to “Atuu, nokoy to igkabayad ta. Pila no maan no ka-otow dini. Konà buwa ogkahantoy kandan.” ");
INSERT INTO did_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nig-ikagi si Jesus, “Dow pila no bu-uk to paan tanow. Aha-a now.” Pag-ahà dan, pignangonan dan si Jesus to “Moydu-on lima no bu-uk no paan aw daduwa gayod no bu-uk ubag to isdà.” ");
INSERT INTO did_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Na pigsugù ni Jesus to mgo ka-otawan to tibò ogpa-ingkudon diyà to masagkop no kabagnotan dì ogpabahin-bahinon. ");
INSERT INTO did_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Dayun namang-ingkud nigbahin-bahin kada songo bahin no moydu-on ginatus, moydu-on tagkalim-an. ");
INSERT INTO did_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Dayun pigdawat ni Jesus to lima no bu-uk no paan aw daduwa no isdà. Niglanghag kandin diyà to langit aw pasalamat to Diyus. Pigpikas-pikas din kan paan aw ipamaduhuu to pangabaga din diyà to mgo ka-otawan. Insunù to pagpahandug to daduwa no isdà. ");
INSERT INTO did_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Dayun namango-on to tibò no ka-otawan no puli dan binungku-an to pagko-on. ");
INSERT INTO did_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Pagkatapus to pagko-on, intagù dan diyà to sampuù tag duwa no ka-bangkow to nasamà no paan aw isdà. ");
INSERT INTO did_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Lima no maan to kalukosan no namango-on du-on to paan. Wadad bilanga to kabuyagan aw kabata-an. ");
INSERT INTO did_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Na pigpa-una ni Jesus to mgo pangabaga din no pigpatalipag to dagat. Sikan ogdoogan dan no lunsud no pighingadanan to Bitsayda. Pigpamaluwan din to sakayan to mgo pangabaga din. Dì kandin to nabitas su nigba-id to mgo ka-otawan. ");
INSERT INTO did_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Pagkatapus din to pagba-id, niggomow si Jesus to untud su og-ampù kandin to Diyus. ");
INSERT INTO did_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nadukiloman on si Jesus no sobu-ukon din du-on to untud. Na og-uli-on tad to nawnangonon to mgo pangabaga ni Jesus no namanlayag du-on to dagat. ");
INSERT INTO did_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Pigsabod to kamag no mabogbog on no nakabalatak kandan. Nakita-an ni Jesus to mgo pangabaga din no niglisod to pagbobsay. No kabukas-bukas, pigduguk ni Jesus kandan no nighipanow du-on to babow to dagat. Angod to piglaboy-labayan ni Jesus kandan ");
INSERT INTO did_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","dì nakita-an kandin to mgo pangabaga din. Namakasa-og kandan su nangkahadok lagboy. Intobo-ot dan dow busow si Jesus no nigpa-atow no nighipanow du-on to babow to dagat. Pagsa-og to pangabaga, nigsigkon si Jesus aw iling to “Daoyag kow su si Jesus a. Konà kow ogkahadok.” ");
INSERT INTO did_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Dayun nigpagtibò si Jesus diyà to mgo pangabaga din du-on to bautu. Tinakin to nigsigkon on to kamag. Naboong-boong lagboy to pangabaga ni Jesus ");
INSERT INTO did_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","su wadà lagboy makasabut kandan to kabogbogan din su tigbayà nakapadakoo to paan. Wadà dan pad kilaha dow si Jesus, Anak to Diyus. ");
INSERT INTO did_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Na nigdatong kandan diyà to dihipag to dagat. Pagdatong dan nigdu-ung diyà to Ginisarit no banwa. ");
INSERT INTO did_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Paghaw-as dan, nakilahan dà si Jesus to mgo otow no taga-Ginisarit. ");
INSERT INTO did_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Dayun nigpanlaguy kandan diyà to kahilitan su awos madokat dan to mgo masakiton. Piglahung dan diyà ki Jesus. Ko madinogan to mgo otow dow ando-i si Jesus, ogkahimunan dan aw to mgo masakiton, ogdaahon dan. ");
INSERT INTO did_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ko umabut si Jesus diyà to kalunsudan, kasityuhan, dow kahilitan, igkabotang kan mgo masakiton diyà to kahimunanan aw pangamuyù to ogpaka-atan no igatang makatudì kandan to sagyad to kabò ni Jesus. To ogtudì to sagyad to kabò ni Jesus, ogka-uli-an to sakit din. ");
INSERT INTO did_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","4","Na to mgo Hudiyu, moydu-on kandan udyu-on no kanunoy dan og-unug-unugon no niglikat to ka-aw-apu-an dan. Moydu-on ighugas dan to boad ko ogpaka-ulì on kandan no ogpamoli. Ko konà pad ogkahugasan to boad dan, konà ogko-on to mgo Hudiyu. Moydu-on gayod kandan ighugas to mgo tingub dan no mgo kabù, kondì, aw mgo kandidu no bulunsi. Sikan mgo Parisiyu aw mgo mag-a-anad, matuman-tumanon to kandan tinu-uhan no niglikat to ka-aw-apu-an dan. Sikan no mgo Hudiyu, likat to Hirusalim no lunsud. Nahimunan dan si Jesus. Pagpaningugtu to mgo pangabaga ni Jesus, wadà hugasi to boad dan. Pig-indanan to mgo Hudiyu no kan pangabaga, wadà panghugas kandan. ");
INSERT INTO did_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Na pig-usip si Jesus to mgo punu-an to tinu-uhan to “Nokoy man no wadà tagon to pangabaga nu to tulumanon likat to ka-aw-apu-an ta su konà ogpanghugas kandan to boad ko ogko-on. Nakasaà kandan to pagko-on dan.” ");
INSERT INTO did_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Nigtabak si Jesus to “Tùtu-u to tahan natag-an ni Isaias no maglilikwaday no lagsoban to Diyus natodu-on bahin iyu no mapakunon-kunonon no mgo otow no pig-iling to ‘Nigpakunon-kunon nigtahud kanak kan no mgo otow to pag-ikagi dan dì bàbà dan dà puli su bugtì to kandan ginhawahan. ");
INSERT INTO did_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Nigpakunon-kunon kandan nig-ampù kanak. Dì to kasugu-an to Diyus, pig-ilisan dan to impang-anad no likat puli to domdom to otow.’ Sikan to nasulat ni Isaias. ");
INSERT INTO did_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Pig-oyowan now to kasugu-an to Diyus dì iyan pigtagonan now nasì lagboy to kasugu-an likat to otow.” Sikan to kagi ni Jesus du-on to mgo Hudiyu no namantagon lagboy to kandan tinu-uhan. ");
INSERT INTO did_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Na nig-iling sì Jesus to “Mapandoy kow to ogpadaan-daan to ogbalibad to kasugu-an to Diyus. Agaw pig-ilisan now to kasugu-an to Diyus su pig-oyowan now on to kasugu-an to Diyus su awos ma-unug-unug now to iyu no katahanan likat to ka-aw-apu-an now. ");
INSERT INTO did_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","So-idi nasì to kasugu-an to Diyus no linikwad ni Moises no pig-iling to ‘Tahuda to amoy aw inoy nu no igpabayà to pag-alagà.’ Pig-iling gayod to ‘To og-ina-ina to amoy din aw inoy din, ogkahimu now no himatayanan.’ ");
INSERT INTO did_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Dì,” kagi ni Jesus, “so-idi to igpang-anad now. Ko moydu-on ogpangamuyu-on iyu to amoy now aw inoy now, og-iling kow to ‘Sikan no pigpangamuyù nu, pig-abin ku dà no bobogoy ku to Diyus.’ ");
INSERT INTO did_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Kaling man iyu no punu-an, konà now on ogpatabangon kandan to amoy dan aw inoy. ");
INSERT INTO did_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Dì ogpa-ilison now to mgo ka-otawan to kasugu-an to Diyus. Igpatuman now nasì to kasugu-an likat to otow dà puli. Mahan-ing no talabahu now no angod kan.” ");
INSERT INTO did_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Na pigpamaduguk mandà ni Jesus to mgo ka-otawan. Nig-ikagi kandin to “Paminog kow tibò aw konà now oglingawan to kagi ku. ");
INSERT INTO did_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Wadà ko-onon no igkasaà to otow. Dì to oglikat to sood to ginhawahan din, sikan nasì to igkasaà din. ");
INSERT INTO did_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","17","Og-indanan now to pig-ikagi ku.” Dayun nig-ulì on si Jesus aw mgo pangabaga din diyà to pigpagsuwayan dan ton mgo ka-otawan. Pagdatong ni Jesus aw mgo pangabaga din diyà to baoy, pig-usip dan si Jesus dow nokoy to litukan to pananglitan din. ");
INSERT INTO did_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Nig-iling si Jesus to “Dow wadà kow pad gayod makadaag? Dow wadà kow buwa kama-an to konà ogpakasood diyà to ginhawahan ta to kino-on ta? Dì dìyà dà to gotok ta to ogpakasood aw logwà diyà to labas. Kaling man konà no kino-on ta to igkasaà ta.” No sikan no kagi ni Jesus, pighinang din no wadà ko-onon no ing-okod ita. ");
INSERT INTO did_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kagi ni Jesus, “To oglikat to sood to ginhawahan to otow, sikan to igkasaà din ");
INSERT INTO did_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","su to ginhawahan to otow to piglikatan to mado-ot no nigsingkabugtì no angod to mado-ot no pikii, pangawat, pamunù, panghilabot to duma, pag-akom, kado-otan, pag-iyan-iyan, maw-oy, pagsombang, pag-ina-ina, masagsagà aw tingpongog. ");
INSERT INTO did_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Sikan, likat tibò to sood to ginhawahan to otow aw sikan to igkasaà din.” ");
INSERT INTO did_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Na nighipanow on si Jesus padoog diyà to banwa to Tiru. Nigponhik kandin diyà to songo baoy. Konà ogkaliyag si Jesus ko madinog to mgo ka-otawan dow ando-i kandin to ogpaka-ugpà. Dì konà ogpakahobong si Jesus su bantugan man kandin. ");
INSERT INTO did_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Diyà sikan no banwa, moydu-on buyag no nig-ugpà no taga-Sirupinisiya no konà no sakup to Hudiyu no mgo otow. Moydu-on batà din no buyag no pigsoodan to busow. Nakadinog to inoy to du-on on si Jesus kan no banwa. Dayun pig-andu-onan din si Jesus aw patilangkob du-on to atubangan din. Pigpangamuyù to buyag to igpagawang podon ki Jesus to busow no nigsood diyà to batà din. ");
INSERT INTO did_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Pagdinog ni Jesus to pangamuyù to buyag, nig-iling kandin to “Mado-ot ko ogtugdawan ta ogtubungan to mgo kadung ko wadà pad makako-on to mgo batà. Iyan ogpa-unahon ta to mgo batà ogpako-onon.” ");
INSERT INTO did_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nigtabak to buyag, “Ho-o iyan Sir. Dì pagkatapus to pagko-onan to mgo batà, igatang iyan ogkako-on to mgo kadung to samà-samà no nangkapadpad du-on to saad to ko-onanan to tagbuhì.” ");
INSERT INTO did_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Nig-iling si Jesus to “Su na-ikagi nu to angod sikan, oggawang on kan busow no nigsood du-on to batà nu. Na, ulì kad diyà to baoy nu Laginà.” ");
INSERT INTO did_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Dayun nighipanow on to buyag. Pagdatong din diyà to baoy, nakita-an din on to batà din diyà to hibatanan no na-uli-an on kandin. ");
INSERT INTO did_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Na niglikat on si Jesus du-on to Tiru no banwa. Nakabayà kandin to Sidun no banwa aw Dikapulis no banwa. Nigto-od kandin padoog diyà to dagat to Galiliya. ");
INSERT INTO did_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Pagdatong din diyà to dagat pig-andu-onan kandin to otow no bongoo aw pohà. Pigdaa kandin to mgo kadumahan din. Pigpangamuyù dan ki Jesus to igpadampon dan kan masakiton. ");
INSERT INTO did_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Pigpaduma ni Jesus to bongoo diyà to kaylu to mgo otow no nahimun. Dayun inluglug ni Jesus to tudlù din du-on to talinga to bongoo. Nig-ilob si Jesus diyà to kandin tudlù aw tudi-a to dilà kan pohà no otow. ");
INSERT INTO did_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Niglanghag si Jesus diyà to langit aw ginhawa to mahabà. Nig-ikagi si Jesus to kandin inikagihan, “Ipata,” no iyan kalitukan to “Ka-uli-i ka.” ");
INSERT INTO did_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Na-uli-an on dayun to otow. Ogpakadinog on aw maka-ikagi to matuwadong. ");
INSERT INTO did_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Na pigbahog ni Jesus kan mgo ka-otawan to konà igpapanutuwanon to napugutan. Dì nasì on man impanutuwanon to mgo ka-otawan. ");
INSERT INTO did_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Naboong-boong lagboy to mgo ka-otawan. Namaka-iling kandan to “Mabogbog si Jesus iyan. Agad bongoo aw pohà, dì ogkatambalan din.” ");
INSERT INTO did_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Na nahimunan mandà si Jesus to kahan-ingan no mgo otow. Natatouhan to mgo ka-otawan du-on. Nangka-ubusan kandan to ba-aw dan. Dayun pigpaduguk ni Jesus to mgo pangabaga din. ");
INSERT INTO did_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Kagi din, “Pigka-atan ku so-idi mgo ka-otawan su natatouhan on dini ita no pigpangkabusan on to ba-aw dan. ");
INSERT INTO did_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ko pa-uli-on kud puli podon kandan to wadà nangkako-on, dagow ogpamanlotoy kandan diyà to pangindanan su moydu-on man kan mgo otow no madiyù to banwa to piglikatan.” ");
INSERT INTO did_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Nig-iling to mgo pangabaga ni Jesus to “Og-amonu ki man ogpako-on so-idi mgo otow su dini ki man to kahanongan.” ");
INSERT INTO did_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Nig-usip si Jesus to “Dow pila no bu-uk to paan now.” Namantabak to mgo pangabaga din to “Pitu dà no bu-uk to paan.” ");
INSERT INTO did_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Na pigpama-ingkud ni Jesus to ka-otawan du-on to pasak. Pigdawat din kan pitu no bu-uk no paan aw pasalamat kandin to Diyus. Pigpamikas-pikas din to paan aw iduhuu diyà to mgo pangabaga din aw ipamaduhuu din mandà diyà to mgo ka-otawan. ");
INSERT INTO did_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Moydu-on gayod pilahon dà ubag no mangkanawà no isdà. Pig-usab din pigdawat to isdà aw pasalamat kandin. Impamaduhuu din gayod to mgo pangabaga to isdà diyà to mgo ka-otawan. ");
INSERT INTO did_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Namango-on to mgo upat no maan no ka-otow no puli dan binungku-an to pagko-on. Pagkatapus to pagko-on, intagù dan to nasamà diyà to pitu no ka-bangkow. ");
INSERT INTO did_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Dayun pina-ulì ni Jesus to mgo ka-otawan. Pagpapa-ulì din to mgo ka-otawan, nigluwan on si Jesus aw mgo pangabaga din diyà to bautu no ogpadoog diyà to banwa no pighingadanan to Dalmanuta. ");
INSERT INTO did_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ton diyà pad si Jesus to Dalmanuta no banwa, pigduguk kandin to mgo Parisiyu. Nigpag-asuy podon kandan ki Jesus, su og-ahà kandan podon to kaboonganan likat to Diyus no igkamatu-ud to na-uyunan kandin to Diyus. ");
INSERT INTO did_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nigginhawa si Jesus to mahabà aw iling kandin to “Iyu no kadongan ku, nokoy man no ogpa-ahà kow pad podon to kaboonganan. Konà ku iyan igpa-ahà iyu to duma pad no kaboonganan.” ");
INSERT INTO did_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Nighipanow on kandin. Nigpa-ulì kandin diyà to bautu. Dayun nigsakoy si Jesus aw mgo pangabaga din padoog diyà to dihipag to dagat. ");
INSERT INTO did_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Paglikat dan nalingawan to pangabaga ni Jesus to pagdugang to ba-aw. Sobu-uk nandà to nasamà no paan. ");
INSERT INTO did_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Impananglitan ni Jesus no pig-iling to “Bantoy kow to igpatulin to paan likat to mgo Parisiyu aw likat ki Harì Hirudis.” ");
INSERT INTO did_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Nigka-inusipay to mgo pangabaga din to “Nokoy buwa to kalitukan to pananglitan din, su wadà ki man makadaa to paan.” ");
INSERT INTO did_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Tahan dà nama-anan ni Jesus to iyan nadomdoman dan bahin to ba-aw dan aw nig-iling kandin to “Nokoy man no nigka-inusipay kow to wadà ba-aw ta. Nokoy man no wadà kow man makadaag. Dow wadà kow pad buwa makasabut to kalitukan to igpatulin to paan? Nokoy to nakapalinggut to uu now. ");
INSERT INTO did_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Moydu-on mata now. Nokoy man no wadà kow makakita. Moydu-on talinga now. Nokoy man no wadà kow makadinog. Nokoy man no nalingow kow. ");
INSERT INTO did_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Paghandug ku to lima no paan diyà to lima no maan no mgo otow, dow pila no ka-bangkow to natagu-an now to nasamà.” Nigtabak kandan to “Sampuù tag duwa no bangkow.” ");
INSERT INTO did_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Nig-iling si Jesus to “Paghandug ku to pitu no bu-uk no paan diyà to upat no maan no mgo otow, dow pila no bangkow to natagu-an now to nasamà.” Nigtabak kandan, “Pitu no ka-bangkow.” ");
INSERT INTO did_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Nig-usip si Jesus, “Dow wadà kow pad makasabut?” ");
INSERT INTO did_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Na nigdatong si Jesus aw mgo pangabaga din diyà to Bitsayda no lunsud. Moydu-on mgo otow no nigdaa to pisok diyà ki Jesus. Pigpangamuyù dan ki Jesus to ogpatambaan to pisok. ");
INSERT INTO did_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Pigdaa ni Jesus to pisok diyà to madiyù-diyù. Pig-iloban din to mata to pisok aw dampona din. Nig-usip si Jesus to “Dow moydu-on nakita-an nu?” ");
INSERT INTO did_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nakalanghag to pisok aw maka-ikagi to “Moydu-on on nakita-an ku no mgo otow no nigpadiboy. Dì konà pad no mapayag to pag-ahà ku su angod pad to tu-od to pag-ahà ku.” ");
INSERT INTO did_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Dayun pigsampong ni Jesus to mata to pisok. Nig-ahà to pisok aw ka-uli-i. Mapayag on to og-ahà. ");
INSERT INTO did_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Pagkatapus, pina-ulì ni Jesus to pisok diyà to banwa din. Pigsugù din to “Ko umulì kad to banwa nu, lipas ka to lunsud.” ");
INSERT INTO did_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Na nigpadayong si Jesus aw mgo pangabaga din padoog diyà to mgo kalunsudan to prubinsiya no Sisariya Pilipu. No diyà pad to pangindanan kandan, nig-usip si Jesus to mgo pangabaga din no pig-iling to “Dow intawa a buwa, agad-agad to atoman to mgo ka-otawan.” ");
INSERT INTO did_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Namantabak kandan to “Moydu-on naka-ikagi to si Juan ka no Magbobonyagay. Moydu-on naka-ikagi to si Elias ka no maglilikwaday. Moydu-on naka-ikagi to maglilikwaday ka angod to tùtu-u no maglilikwaday to Diyus natodu-on.” ");
INSERT INTO did_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Nig-iling si Jesus to “Dì agad-agad to iyu no atoman gayod, dow intawa a.” Nakatabak si Pedro, “Ikow, Kristu ka no Imananan to mgo Ka-otawan.” ");
INSERT INTO did_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Pigbahog ni Jesus to mgo pangabaga din to wadà otow no ognangonan dan dow intawa lagboy iyan kandin. ");
INSERT INTO did_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Na pigpunu-an ni Jesus to pagnangon to mgo pangabaga din to kandin igkapatuwa-ay. Ogsupakon kandin to mgo punu-an to tinu-uhan to mgo Hudiyu. Oghimatayan kandin, dì pagkatatouhi no adow ogbuhayon dà. ");
INSERT INTO did_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Pigpapayag din on bali to pagnangon diyà to mgo pangabaga din to igpatuwa-ay kandin. Pigpaduguk ni Pedro si Jesus aw sapadi din podon. ");
INSERT INTO did_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Niglingì si Jesus aw ahà diyà to mgo pangabaga din aw impanagda din nasì si Pedro no nig-iling to “Gawang kad kani Satanas. Wadà nu uyuni to niglikat to Diyus. Dì otow dà puli to piglikatan to og-uyunan nu.” ");
INSERT INTO did_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Na pigpaduguk ni Jesus to mgo ka-otawan aw mgo pangabaga din. Piglapuwaas din no pag-ikagi kandan no nig-iling to “To ogpasakup kanak, ogka-oyowan din to kandin katahani tibò aw ogpaka-angod kanak no ogti-ang to kinurus din no iyan kalitukan to iglingow din to natagon din no maogon lagboy. ");
INSERT INTO did_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Agad intawa no ogkawada-an to kinabuhì din ugpat kanak aw ogbulig kanak to pagpang-anad to Madoyow no Tutuwanon, ogkamoydu-onan dà nasì kandin to mahudi no adow. Dì agad intawa, ko ogpakatagonan din to kinabuhì din dini to kalibutan, ogkawada-an dà kandin to mahudi no adow. ");
INSERT INTO did_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Agad kunto-on madatù ki tibò dini to kalibutan, dì wadà puus ta ko konà ki ogbuhayon to mahudi no adow aw tuusa. ");
INSERT INTO did_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Dini to babow to kalibutan wadà agad nokoy no igkabogoy no igkatobus to otow awos mahawì din dà to kandin kinabuhì.” ");
INSERT INTO did_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Na nig-iling si Jesus to “To mgo otow no kadongan ku dini to babow to pasak, mado-ot to kandan hinang aw oglingì-lingì kandan to bugtì no ampu-onon. Ko konà kow ogmatu-ud to pagpasakup now aw ko konà kow ogtuman to kagi ku, konà a gayod ogmatu-ud iyu no sakup ku to mahudi no adow to pagsakup to Diyus no Amoy ku no og-ulì ad dini so-idi kalibutan no kanak to Tumutubus to Ka-otawan. Ogdumahan ad to katuusan to Diyus no Amoy aw mgo diwata din.” ");
INSERT INTO did_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Nig-iling si Jesus to “Moydu-on mgo otow no nahimun kani no monang ogkamatoy ko ogsakpanan pad to pagdatong to pagsakup to Diyus no ogdumahan to katuusan din.” ");
INSERT INTO did_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Na pag-abuti to onom no adow, niggomow si Jesus to untud no matikang. Si Pedro, si Santiago, aw si Juan to pigputlung din pigpaduma. Pagdatong dan diyà to puputukan nahalin on si Jesus no na-usab to lawlanguhan din ");
INSERT INTO did_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","aw putì lagboy to kabò din no wadà naka-angod to kaputi-an dini to babow to kalibutan no pigsilow kandan to pag-ahà dan. ");
INSERT INTO did_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Na nakalogwà du-on kandan to daduwa no katuusan on no maglilikwaday to Diyus natodu-on no si Elias aw si Moises no nigpagbaaw du-on ki Jesus. ");
INSERT INTO did_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Na naka-iling si Pedro diyà ki Jesus to “Sir, madoyow su kani koy man. Dow pahimuhon koy nu to tatou no pinayag awos oglogoban kow aw si Moises aw si Elias aw ikow.” ");
INSERT INTO did_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Sikan to na-ikagi ni Pedro su nahadok kandin. Kaling man naka-iling kandin to konà no matuwadong no litukan. Kandan tibò, nangkahadok iyan. ");
INSERT INTO did_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Na nasaungan kandan to gabun. Nakadinog kandan to kagi no du-on makapu-un to gabun no na-iling to “So-idi to nalogonan ku lagboy no Anak. Ogpaminogan now kandin.” ");
INSERT INTO did_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Paglingì to mgo pangabaga ni Jesus, pigboong dan on kan daduwa no ka-otow. Iyan nandà nakita-an dan si Jesus. Na dayun nighipanow on kandan aw si Jesus. ");
INSERT INTO did_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","No pagpatugpù ni Jesus aw mgo pangabaga din, pigbahog ni Jesus to “Monang now igtutuwanon to nakita-an now ko mamatoy ad aw buhayon ad gayod no Tumutubus to Ka-otawan.” ");
INSERT INTO did_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Kaling man pig-indanan dan to pig-ikagi ni Jesus dì wadà dan itutuwanon. Dì nigsusukun kandan dow nokoy to kalitukan to pagbuhoy to mgo namatoy. ");
INSERT INTO did_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Na nig-iling to mgo pangabaga ni Jesus, “Dì to mgo mag-a-anad to tinu-uhan no nangkama-an to kasulatan no tahan no og-iling kandan to ‘Monang ogpakalogwà to Imananan to Ka-otawan ko dumatong pad si Elias.’ Ma-amonu man buwa no pig-iling dan to angod sikan.” ");
INSERT INTO did_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Nigtabak si Jesus to “Ogdatong on iyan si Elias no og-uliman tibò awos oghina-at to igbayà to Imananan to Ka-otawan. Ma-amonu no nasulat pad bahin to kanak kalisod aw pagka-uwang-uwangi ku aw pagkasawoy ku agad kanak to Tumutubus to Ka-otawan. ");
INSERT INTO did_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Iyan on ognangonan ku iyu to nigdatong on iyan si Elias. Dì natuman on to kasulatan bahin to nadoogan ni Elias no pigbo-otan to bugtì no mgo otow.” Sikan no pananglitan ni Jesus, napa-atubangan din si Juan no Magbobonyagay. ");
INSERT INTO did_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Na pagdatong dan diyà to duma no mgo pangabaga ni Jesus, nakita-an dan to mahan-ing no mgo otow no namanlibong du-on to mgo sakup din. Nigpag-asuy kan mgo mag-a-anad to tinu-uhan du-on to mgo pangabaga ni Jesus. ");
INSERT INTO did_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nakita-an si Jesus to mgo ka-otawan. Pagkita dan, naboong-boong kandan. Nigpanlaguy kandan no nigsungun diyà ki Jesus. Pigbogayan dan to katahudan. ");
INSERT INTO did_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Na nig-usip si Jesus, “Nokoy to pig-asuy-asuyan now.” ");
INSERT INTO did_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Moydu-on otow no nig-ikagi to “Sir, pigdaa ku to anak ku no lukos dini ikow. Pigsoodan kandin to busow. Kaling man napohà kandin su pigsoodan to busow no makapopohà. ");
INSERT INTO did_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ko og-abuton to batà to busow, ogkapood kandin diyà to pasak. Oglawayon aw kagot to ngipon aw liskog to lawa. Pigpangamuyù ku to mgo sakup nu to ogpagawangan ku podon to batà ku to busow. Dì konà dan ogka-amuhan.” ");
INSERT INTO did_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Nig-ikagi si Jesus to “Iyu no kadongan ku, naugoy on to pagpang-anad ku iyu, dì wadà kow tu-u kanak. Amonuhon ku buwa. Daaha dini kanak to batà nu.” ");
INSERT INTO did_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Dayun pigdaa to batà diyà ki Jesus. Pigkita si Jesus to busow no makapopohà. Pagkita din ki Jesus, pigpalukuban to batà. Napood to batà diyà to pasak. Pagkapood din, nakapaligid-ligid aw bubukà to bàbà. ");
INSERT INTO did_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Pig-usip ni Jesus to amoy to “Pila on no tu-ig to pagbatì to batà nu so-idi no sakit.” Nakatabak to amoy to “Likat on to pagkabatà din iyan. ");
INSERT INTO did_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kanunoy ogpakasinugba kandin diyà to logdog. Ko og-abuton ogpaka-inusbug gayod diyà to wohig awos din podon ogkamatoy to batà. Ko mahimù Sir, buligi a podon. Ka-ati a podon.” ");
INSERT INTO did_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Nigtabak si Jesus, “Nokoy man no nig-iling ka to ‘Ko mahimù,’ su ogkahimù man iyan. To otow no ogtu-u to Diyus, ogkatabangan man agad nokoy to kalisod din.” ");
INSERT INTO did_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Naka-ikagi to amoy to batà to “Nigtu-u a ikow. Dì dugangi to pagtu-u ku Sir, su ma-intok pad.” ");
INSERT INTO did_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Na nakita-an ni Jesus to ogpamanduguk to kahan-ingan no otow du-on kandin. Pagkita din to mgo otow no ogduguk, pigsapadan din to busow. Kagi din, “Ikow no busow no makabobongoo, makapopohà, oggawangon ku ikow. Ayaw kad ogsood og-usab du-on to batà.” ");
INSERT INTO did_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nakapanagoa kandin. Pigpalukuban to busow to batà aw tinakin makagawang kandin. Pagkagawang to busow kan batà, nakotang. Kaling man namaka-iling to kahan-ingan to “Namatoy on to batà.” Dì puli nakotang kandin, mangkuwan buhì dà. ");
INSERT INTO did_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Dayun pigdawat ni Jesus to boad to batà aw pabanguna. Dayun nakasakindog to batà. ");
INSERT INTO did_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Na nigpa-ulì on si Jesus aw mgo pangabaga din diyà to baoy. Pagdatong dan, pigpa-awayan dan pig-usip si Jesus no namang-iling to “Nokoy man buwa no wadà koy man makapagawang kanami to busow.” ");
INSERT INTO did_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Nigtabak si Jesus, “Konà ogkagawang to busow ko konà kow ogpangamuyù to Diyus to iyan oggawang.” ");
INSERT INTO did_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Na nighipanow on kandan si Jesus. Nakabayà kandan to prubinsiya to Galiliya. Konad ogkaliyag si Jesus to ogkama-anan pad to mgo otow to pagbayà dan to Galiliya ");
INSERT INTO did_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","su ognangonan din on to mgo pangabaga din dow nokoy to og-abut du-on kandin. Kagi din, “Kanak no Tumutubus to Ka-otawan, ogdaahon a diyà to oghimatoy kanak. Dì pagkatatouhi no adow ogbuhayon a dà.” ");
INSERT INTO did_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Dì wadà makadaag to mgo pangabaga ni Jesus to kalitukan to pig-ikagi din. Nahadok kandan to og-usip dow nokoy to kalitukan to kagi din. ");
INSERT INTO did_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Na nigdatong kandan si Jesus diyà to Kapirna-um no lunsud. Nigpama-ulì on kandan diyà to pig-ugpa-an dan. Pagdatong dan pig-usip ni Jesus to mgo pangabaga din to “Nokoy to na-asuyan now ton diyà ki pad to pangindanan.” ");
INSERT INTO did_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Wadà mamakatabak to mgo pangabaga ni Jesus su nig-a-asuy-asuy man kandan dow intawa to labow kandan. ");
INSERT INTO did_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Nig-ingkud si Jesus aw paduguka to mgo pangabaga din no sampuù tag duwa. Nig-iling si Jesus to “To sakup ku no ogpalabow podon, iyan igkapabayà nasì to ogpasagkop pad kandin. Ogpa-angod podon kandin to sugu-onon.” ");
INSERT INTO did_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Dayun pigdawat ni Jesus to batà no wadà pad lagboy bo-ot aw ibotang din du-on to kabakna-an to mgo pangabaga din aw padaniha din to batà aw pananglitani din no nig-iling to ");
INSERT INTO did_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ko ogdawaton now to sakup ku no angod so-idi no batà, agad masagkop kandin, iyan ogka-angodan now to ogdawat kanak. Ko ogdawaton a now, iyan ogka-angodan now to ogdawat to nigpa-andini kanak.” ");
INSERT INTO did_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Dì naka-ikagi si Juan no songo pangabaga din gayod to “Ho-o Sir, dì moydu-on nakita-an noy no otow no niggawang to busow no nigsood diyà to otow dì iyan piggamit din to ikow no ngadan. Dì pigsapadan noy su wadà man makalabot to ita no sinakupan.” ");
INSERT INTO did_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Nig-iling si Jesus to “Konà now ogsapadan kandin. Ko oghinang to otow to kaboonganan no oggamiton din to kanak ngadan, konà no pag-ina-ina kanak to tawoy sikan. ");
INSERT INTO did_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Su to otow no konà ogbalatak ita, ogduma sikan ita. ");
INSERT INTO did_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ko oglanggahan kow aw moydu-on otow no ogpa-inom iyu to wohig su sakup ku iyu, moydu-on iyan ogkapudut din nasì.” ");
INSERT INTO did_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Nig-iling si Jesus to “To ogpasuwoy to ma-intok no otow no nigtu-u kanak, mahawoy dà ko pa-usbugon kandin diyà tò dagat no oglawigan to batu to li-og din. Dì malisod lagboy ko kastiguhon kandin to Diyus to mahudi no adow.” ");
INSERT INTO did_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Na impananglitan ni Jesus no nig-iling to “Ko makasaà ka to boad, manginun pad nasì ko tampodon nu. Agad boboadan ka, dì ogka-uwakan ka dà tibò ko mamatoy ka aw pa-andiya-a ka to banwa no kastiguhanan to saà to mahudi no adow. Manginun pad nasì ko sobu-uk dà to boad nu dì ko mahudi no adow buhayon ka. Diyà to kastiguhanan to saà moydu-on logdog no wadà kaposokanan.” ");
INSERT INTO did_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Nig-iling si Jesus to “Ko makasaà ka to kobong, madoyow ko tampodon. Agad kokobongan ka, dì ogka-uwakan ka tibò ko mamatoy ka aw pa-andiya-a ka to kastiguhanan to saà to mahudi no adow. Manginun pad nasì agad ko sobu-uk dà to kobong nu dì ko mahudi no adow, buhayon ka.” ");
INSERT INTO did_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Nig-iling si Jesus to “Ko makasaà ka to mata, madoyow pad ko lugiton nu. Madoyow pad ko ogpasakup ka nasì to sinakupan to Diyus su ogbuhayon ka dà man to mahudi no adow agad sobu-uk dà to mata. Agad mamatahan ka, dì ogka-uwakan ka tibò ko maka-andiyà ka to kastiguhanan to saà. ");
INSERT INTO did_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Kan no banwa, wadà kaposokanan to logdog aw wadà pagkagawang to iyas.” ");
INSERT INTO did_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Na impananglitan mandà ni Jesus no nig-iling to “Maogot ogkabaya-an to kalisod to tibò no mgo ka-otawan dini to babow to kalibutan. Sikan no kalisod to igkadowdoyow ta to ita no ginhawahan su angod to asin no ogpakadoyow to sodà ta. ");
INSERT INTO did_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Na to asin, ogtabang ita. Dì ko ogkawadà to katam-isan to asin, amonuhon ta to pagpa-ulì to nanam to asin. Konà kow ogpakawadà to katam-isan to iyu no ginhawahan. Pakatuwadong kow nasì. Konà kow ogbubuwow-buwow bahin to ka-ugpà now dini to babow to kalibutan.” ");
INSERT INTO did_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Na niggawang si Jesus du-on to prubinsiya to Galiliya. Nighipanow on kandin padoog diyà to Hudiya no banwa aw diyà dihipag to Hurdan no wohig. Nahimunan na-usaban si Jesus to mgo ka-otawan su tahan din man pigpang-anad. ");
INSERT INTO did_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Na pigduguk si Jesus to mgo Parisiyu no mangkatagon-tagonon to kandan tinu-uhan. Moydu-on ing-usip dan su ogpagiti-an dan podon to igkadiklamu dan ki Jesus. Nig-iling kandan to “To tinu-uhan ta, dow ogkatugutan to mag-asawa to ogbinolagay?” ");
INSERT INTO did_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Nigtabak si Jesus, “Dow nokoy to kasugu-an ton maglilikwaday no si Moises bahin to pagbinolagay to mag-asawa.” ");
INSERT INTO did_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Nigtabak to mgo Parisiyu, “Pigtugutan ni Moises to otow to ogpabolag kandin to asawa din ko mabogayan din to sulat no kalig-onan to wadà pig-abin din to pag-a-asawa dan.” ");
INSERT INTO did_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Nig-iling si Jesus to “Imbogoy puli iyu ni Moises sikan no sugù su bugtì to bo-ot now. ");
INSERT INTO did_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Dì to kapinunu-an, piggihit to Diyus to songo minyò no sobu-uk to lukos aw sobu-uk to buyag. ");
INSERT INTO did_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Kaling man ko ogkaminyò on to otow, ogpagluwatan din to amoy aw inoy aw pagtibò kandin to asawa din. ");
INSERT INTO did_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Konad on no daduwa no ka-otow kandan dì nasobu-uk on kandan. ");
INSERT INTO did_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kaling man to pigpagtibò to Diyus, konà ogkapagbolag puli to otow.” ");
INSERT INTO did_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Pagdatong ni Jesus aw mgo sakup din diyà to baoy, nig-usip kandan bahin to pagbinolagay to mag-asawa. ");
INSERT INTO did_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Nig-iling si Jesus to “To otow, ko og-oyowan din to kandin asawa no una aw pangasawa to bugtì, ogkalap-angan din to una no asawa din. ");
INSERT INTO did_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","To buyag, ko og-oyowan din to bana din aw babana to bugtì no lukos, ogkalap-angan din to una din no bana.” ");
INSERT INTO did_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Na moydu-on mgo otow no namandaa to mgo batà diyà ki Jesus su igpadampon dan kandin. Dì to mgo pangabaga ni Jesus, pigsasapadan dan podon sikan namandaa to batà. ");
INSERT INTO did_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Pagkataga ni Jesus to pigsasapadan dan podon, naboù kandin aw iling kandin diyà to mgo sakup din to “Ayaw now balataka to mgo batà. Paduguka now dini kanak su to sinakupan to Diyus, iyan ogka-angodan sikan mgo batà no mgo hanuut. ");
INSERT INTO did_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ognangonan ku iyu, ko konà kow ogpaka-angod to batà no hanuut, konà kow ogpakasood to pigsakupan to Diyus.” ");
INSERT INTO did_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Dayun pigpanggakod ni Jesus to mgo batà aw pandampona. Pigpangamuyù din to Diyus no Amoy to ogpapanalanginan to mgo batà. ");
INSERT INTO did_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Na nighipanow on si Jesus. Dì paglikat din, moydu-on otow no niglaguy padoog du-on kandin aw luhud diyà to atubangan din. Nig-iling kandin to “Sir, su matuwadong ka no otow, nangoni a dow nokoy to matuwadong no ogkahimu ku su awos mabogayan a to kinabuhì no konad ogkawadà.” ");
INSERT INTO did_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Nakatabak si Jesus to “Nokoy man no pighingadanan a nu to matuwadong, su Diyus dà man to matuwadong lagboy tibò. ");
INSERT INTO did_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nama-anan nud man to kasugu-an to Diyus no pig-iling to ‘Konà ka ogpanghimatoy, aw konà ka oghilabot to duma. Konà ka ogpangawat aw konà ka ogbotang-botang. Konà ka ogpanluku. Igtahud nu to amoy aw inoy nu.’” ");
INSERT INTO did_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nig-ikagi kan otow to “Sir, sikan no kasugu-an to Diyus, sikan on iyan to tahan kanak nagimatahan. Likat to pagkabatà ku, natagonan kud iyan lagboy sikan.” ");
INSERT INTO did_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Naliyag no ginhawa ni Jesus diyà kan no otow. Nig-ahà si Jesus kan otow aw iling to “Moydu-on sobu-uk no sugù no igpatuman pad ikow. Ipambaylu nud to sapì to tibò no mgo katu-unan nu aw ipamogoy diyà to mgo publi su awos ka mahina-atan to Diyus to ayama-an nu diyà to langit. Pagkapamogoy nud, ulì kad dini aw pasakup kad bali kanak.” ");
INSERT INTO did_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Niggobloy on to ginhawa to otow kan pagkalituk to kagi ni Jesus. Naduyong-ot kandin aw hipanow on puli su datù man kandin. ");
INSERT INTO did_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Na niglingì aw ikagi si Jesus diyà to mgo sakup din to “Kalisod to datù no konad podon ogpasakup to Diyus.” ");
INSERT INTO did_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Naboong-boong to mgo sakup ni Jesus to pig-ikagi din. Nig-iling si Jesus to “Mgo sakup ku, malisod iyan to otow no ogpasakup to Diyus ko ogsalig to kadatù din. ");
INSERT INTO did_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","To kamilyu no kina-aslagan no buhì, mahawoy dà nasì ko ogpalusuton du-on to lugì to dagom. Dì malisod ko ogpasakup podon to otow no datù diyà to Diyus.” ");
INSERT INTO did_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Naboong-boong to mgo sakup ni Jesus aw pamang-ikagi to “Mano malisod lagboy ko ogpasakup to otow to Diyus, wadà buwa ogbay-awon no otow to mahudi no adow.” ");
INSERT INTO did_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Na nig-ahà si Jesus diyà to mgo sakup din aw ikagi to “Moydu-on dà ogbay-awon. Wadà ogka-amu no otow to ogbay-ow to otow. Dì ogka-amuhan to Diyus to ogbay-ow to mgo otow su agad nokoy, ogka-amuhan to Diyus.” ");
INSERT INTO did_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Na si Pedro, nig-ikagi to “Pig-oyowan noy on tibò to katu-unan noy aw duma koy on ikow.” ");
INSERT INTO did_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Nig-iling si Jesus to “To otow no agad nokoy no og-oyowan din moydu-on ogkadawat din agad pila no bu-uk. Ko og-oyowan din to mgo su-un din, inoy, amoy, mgo batà din aw pasak din ugpat kanak aw ugpat gayod to Madoyow no Tutuwanon, moydu-on ogkadawat din agad pila no ka-baoy, su-un, inoy, mgo batà, aw pasak. Dì kunto-on og-uwang-uwangan to mgo sakup ku to kadumahan dan dì ogbuhayon dà iyan to mahudi no adow aw tuusa. ");
INSERT INTO did_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kunto-on, mahan-ing no og-una no mgo otow dì ogkamahudi iyan nasì to mahudi no adow. Mahan-ing gayod kunto-on to mahudi no mgo otow, dì ogpaka-una nasì to mahudi no adow.” ");
INSERT INTO did_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Na namanhipanow kandan si Jesus padoog diyà to Hirusalim no lunsud. Moydu-on gayod mahan-ing no ka-otawan no namanluyud-luyud. Nig-una si Jesus. Nigsunù to mgo pangabaga din. Mahudi to mgo ka-otawan. Naboong-boong to mgo pangabaga din su ogpakapatidawan ni Jesus to lunsud no moydu-on mgo kablang din. Sikan mgo ka-otawan, nahadok lagboy dow nokoy to og-abutan dan diyà to Hirusalim. Si Jesus, pigpaduguk din mandà kan sampuù tag duwa no pangabaga din aw nangoni din dow nokoy to ogpaka-abut du-on kandin no kado-otan diyà to Hirusalim. ");
INSERT INTO did_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Pigtongopan din to pag-ikagi to mgo pangabaga din no nig-iling to “Moydu-on ignangon ku iyu. Ogpaka-andiyà kid on to Hirusalim. Kanak no Tumutubus to Ka-otawan, igbaligyà a to sakup ku dà diyà to mgo otow no oghimatoy kanak. To mgo punu-an to tinu-uhan to mgo Hudiyu, kandan to ogpahimatoy kanak. Oghinangon a dan no himatayanan aw daaha a dan diyà to ukum no taga-Ruma. ");
INSERT INTO did_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Sikan mgo taga-Ruma, ogdugadi kanak aw og-iloban a, bunai a, aw himatayi a. Dì pagkatatouhi no adow, kanak, ogbuhayon a dà man.” ");
INSERT INTO did_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Na no diyad on kandan to tongà-tongà to pangindanan, pigduguk si Jesus to mgo anak ni Sibidiyu no si Santiago aw si Juan. Nig-iling kandan to “Sir, moydu-on ogpangamuyu-on noy ikow ko mahimù.” ");
INSERT INTO did_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Kagi ni Jesus, “Kahimù man. Nokoy to ogpangamuyu-on now kanak. Antiha now man ikagiha dow nokoy.” ");
INSERT INTO did_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Nig-ikagi to nigsusu-un to “Ko mahimù podon Sir, oghinangon koy nu no pangabaga nu no ogpakasunù ikow to timpu to pagkaharì nu.” ");
INSERT INTO did_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Nakatabak si Jesus to “Wadà kow kataga to ogdatongan sikan ko mabogayan kow to katondanan no ogkahimu kow no ogpakasunù kanak. Og-abut to kanak no kalisodan. Dow ogpakatuwa-ay kow ko maka-abut iyu to kalisodan no ogpaka-angod to kanak kalisodan? Madaas ad oghimatayan. Dow ogpakatuwa-ay kow ko mabaya-an now no ogpaka-angod to kanak ogkabaya-an?” ");
INSERT INTO did_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“Ho-o iyan,” kagi to daduwa no ka-otow. Nig-ikagi si Jesus to “Iyan on og-abut iyu to kalisodan to mahudi no adow aw ogkabaya-an now angod to kanak ogkabaya-an. ");
INSERT INTO did_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Dì konà no kanak to ogbobo-ot to kabahinan to mgo otow ko timpu on to pagkaharì ku su tahan on pigbo-otan to Diyus no Amoy ku.” ");
INSERT INTO did_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Na pagkadinog kan sampuù no pangabaga din to nigpalabow-labow podon kan daduwa no nigpatahadi, naboù kandan. ");
INSERT INTO did_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Dayun pigpaduguk ni Jesus to tibò no pangabaga din. Nig-iling kandin to “Nama-anan now man to mgo mangka-aslag no mgo otow dini to babow to kalibutan, ogpanda-og-da-og to mgo ka-otawan. To mgo nangatondanan gayod, tibò dan dampà to sakup dan.” ");
INSERT INTO did_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nig-iling si Jesus to “Dì ita, konà no sikan to kadodoog ta. Itanow no ogkaliyag ogpatikang to sinakupan to Diyus, iyan igpabayà ta pad to ogpasagkop ki na-ay angod to sugu-onon no dini ki pad to babow to kalibutan. ");
INSERT INTO did_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Itanow no ogkaliyag to oglabow, igpabayà ta pad to ogpasagkop ki angod to allang. ");
INSERT INTO did_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Og-unugon now to kanak batasan no Tumutubus to Ka-otawan. To ing-andini ku to kalibutan su ogbulig a to mgo ka-otawan. Konà a ogpabulig to mgo ka-otawan. Ogbuligan ku to mgo ka-otawan no igpabayà to pagpakimatoy ku kandan awos malipwasan to saà.” ");
INSERT INTO did_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Na nigbayà kandan si Jesus to Hidiku no lunsud. Pigdumdumahan pad kandin to mgo sakup din aw sikan kahan-ingan no mgo otow no nigluyud kandan. Paglikat dan diyà to tawoy to lunsud, moydu-on pisok no otow no nigpalimus no nig-i-ingkud diyà to kilid to daan no igbayà ni Jesus. Iyan ngadan din si Bartimeo, no kalitukan to anak ni Timeo. ");
INSERT INTO did_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nakadinog kandin to si Jesus no taga-Nasarit to ogbayà on du-on. Pagkadinog din to si Jesus on iyan, nig-ikagi kandin to ma-agbot to “Jesus, no sugpù todu-on harì no si David, ka-ati a nu podon.” ");
INSERT INTO did_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Dì pigsapadan kandin podon to ka-otawan dì wadà paminog to pisok. Pigpadugangan din nasì to pagsabi su awos ogpakadinog lagboy si Jesus. Nig-iling kandin mandà to “Sugpù ni David, ka-ati a nu podon.” ");
INSERT INTO did_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Pagkadinog ni Jesus, nigsigkon. Kagi din, “Pa-andiniha now todu-on no otow.” Pig-ikagihan kan pisok to ka-otawan to “Daoyag ka. Sakindog ka su ogpa-andiya-on kad ni Sir.” Dayun nakasakindog to pisok ");
INSERT INTO did_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","aw kahiyab din to lu-ubon din no nigduguk diyà ki Jesus. ");
INSERT INTO did_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Nig-iling si Jesus to “Nokoy ngadana to ogpabuligan nu kanak.” Nigtabak to pisok to “Sir, ma-uli-an a nu podon to mata ku.” ");
INSERT INTO did_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Nig-iling si Jesus to “Ogpakahipanow kad on kunto-on su na-uli-an on to mata nu su nigtu-u ka kanak.” Pagkalituk to kagi ni Jesus, na-uli-an on kandin. Pagka-uli-i to pisok, nigdumduma on ki Jesus. ");
INSERT INTO did_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Na, namanpadayong kandan si Jesus aw mgo ka-otawan gayod padoog diyà to Hirusalim aw nakalongod no mgo lunsud diyà to augan to Ulibu-an no untud. Sikan mgo lunsud, pighingadanan to Bitpagi aw Bitaniya. Pagkatopad ni Jesus diyà to lunsud, sinugù din to daduwa no pangabaga ");
INSERT INTO did_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","no nig-iling to “Andiyà kow to lunsud. Ko makasood kow on to lunsud, ogkakita-an now on to kabayù no nati. Dì nahikotan tahan. Wadà pad kasakayi aligbat to nati. Hubada now to hikot aw daaha now to nati dini kanak. ");
INSERT INTO did_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Dì ko moydu-on ogsagman iyu, iling kow to ‘Moydu-on ogkadomdoman to Magbobo-ot ta to kabayù aw igpa-ulì din dà dayun to nati gagaya ko matapus to kandin no ogkadomdoman bahin to nati.’” ");
INSERT INTO did_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Na nighipanow kan daduwa no sakup ni Jesus padoog diyà to lunsud. Pagdatong dan diyà to lunsud, nakita-an dan to nati diyà to tibi to kalasada. Nahikotan to pisì to nati diyà to atubangan to baoy. Pighubad kan daduwa no sakup ni Jesus to hikot to nati. ");
INSERT INTO did_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Moydu-on taga-lunsud no nakasagman aw iling to “Og-amonuhon now sikan nati.” ");
INSERT INTO did_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Tinabak dan diyà to taga-lunsud to “Impapudut ni Sir.” Dì wadà sapadi usab to taga-lunsud kan daduwa no ka-otow no pigsugù ni Jesus. ");
INSERT INTO did_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Na pigdaa dan to nati. Pigsablayan dan to nati to kabò su inhanig to bagakwang to nati. Tinakin to nigsakoy si Jesus. ");
INSERT INTO did_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Pigladladan to mgo ka-otawan to kabò dan diyà to igbayà din. Pinambotangan gayod to lumboy no impatugu to igbayà ni Jesus. ");
INSERT INTO did_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Moydu-on mgo otow no naman-una ki Jesus. Moydu-on gayod mgo mahudi. Tibò kandan, namanlangkoà to ma-agbot no nig-iling to “Mabuhì, mapanalanginan sikan pigpatubus ita to Magbobo-ot dini to kalibutan aw langit. ");
INSERT INTO did_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Mabuhì to pagkaharì din no ogpaka-angod to pagkaharì ton apù ta no si Harì David. Kamusta to uminugpà to langit.” ");
INSERT INTO did_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Pagkahapun on, nigdatong si Jesus diyà to Hirusalim. Pagdatong dan nigsood dayun kandin diyà to labow no simbahan no abutanan to Diyus, aw pangahà-ahà kandin tibò du-on to sood to simbahan. Dayun niglogwà kandin aw kan sampuù tag duwa no pangabaga din su mahapun on man. Paglogwà dan to simbahan nighipanow kandan padoog diyà to Bitaniya no lunsud. ");
INSERT INTO did_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Na to sunù no adow niglikat kandan to Bitaniya su ogpa-ulì diyà to Hirusalim. No diyà pad kandan to pangindanan, si Jesus, niglotoy. ");
INSERT INTO did_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Pag-ahà din diyà to madiyù, iyan nakita-an din to igira no kayu no nigdamoo on. Pig-iman on podon ni Jesus to moydu-on bogas, su sikan no kayu, ogdodongan to pagdohuni aw pagkahinug to bogas. Kaling man pig-andu-onan din dow moydu-on bogas. Dì paghiling-hiling din, wadà bogas. Dohun dà tumaag to nakita-an din su konad man no tigbobogas to igira no kayu agad nigdamoo on to dohun. ");
INSERT INTO did_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Nig-iling si Jesus to “Konà ka ogbogas kunto-on hantod to wadà katapusan.” Pig-indanan dayun to mgo pangabaga din kan in-ikagi din bahin sikan igira no kayu no konad kun ogbogas. ");
INSERT INTO did_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Pagka-ulì ni Jesus aw mgo pangabaga din diyà to Hirusalim, nigsood mandà si Jesus to labow no simbahan. Pagsood ni Jesus, nakita-an din to mgo otow no mamolihay aw magkakambiyu to sapì aw mamaligya-ay to salapati. Pagkita ni Jesus kandan, pigbaliskad din to ingkudanan kan mamaligya-ay to salapati. Pigbaliskad gayod to lamisa to magkakambiyu to sapì. Pigpambohus din to mamaligya-ay to buhì. ");
INSERT INTO did_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Wadà ogtugutan ni Jesus to pagdaa to mgo katinguban diyà to sood to simbahan. ");
INSERT INTO did_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Na pigpang-anad ni Jesus to mgo ka-otawan no nig-iling to “So-idi to nasulat diyà to kasulatan to Diyus no pig-iling to ‘So-idi abutanan ku, oghingadanan to ampu-anan to Diyus to nigsingkabugtì no mgo otow dini to babow to kalibutan.’ Dì iyu, pighimu now nasì no hobonganan to mgo tulisan.” ");
INSERT INTO did_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Na to mgo punu-an to tinu-uhan to mgo Hudiyu, nakadinog kandan to nawnangonon bahin to impang-anad ni Jesus. Pagkadinog dan, nigdomdom kandan dow amonuhon dan to pagkumit no ogkahimatayan si Jesus su pigsombang dan si Jesus su naliyagan to mgo ka-otawan to bayà no impang-anad ni Jesus no natapikan to mgo kaboonganan. ");
INSERT INTO did_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Na pagkahapun, niggawang si Jesus to lunsud to Hirusalim. ");
INSERT INTO did_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Pagkabukas, nighipanow si Jesus aw mgo sakup din no nigbatuk to imbayà dan no nig-ulì mandà kandan diyà to Hirusalim. Nakabayà kandan to kayu no pig-awa-an ni Jesus to konà ogbogas hantod to wadà katapusan. ");
INSERT INTO did_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Wadà kalingawi ni Pedro ton pig-ikagi ni Jesus bahin to igira no kayu. Kagi din to “Sir, aha-a nu suyà kayu no pig-awa-an nu. Kunto-on no adow, namatoy on.” ");
INSERT INTO did_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Nig-ikagi si Jesus, “Tu-u kow to Diyus. ");
INSERT INTO did_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ognangonan ku iyu, ko og-iling kow diyà suyà untud to ‘Magawang ka aw kahalin diyà to dagat,’ ogkahimù dà man ko tumu-u kow lagboy to ogbogayan kow to Diyus to pigpangamuyù now kandin. ");
INSERT INTO did_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kaling man so-idi to kagi ku iyu, ko moydu-on ogpangamuyu-on now to Diyus, tu-u kow to ogkadawat now gayod. Ko tumu-u kow, ogpakadawat kow to agad nokoy. ");
INSERT INTO did_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ko moydu-on otow no moydu-on saà diyà ikow, pasayluha to wadà ka pad ampù to Diyus awos ogkapasaylu to saà nu diyà to Diyus no Amoy diyà to langit. ");
INSERT INTO did_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ko konà nu pasayluhon to saà diyà ikow, konà gayod ogkapasaylu to saà nu diyà to Diyus no Amoy diyà to langit.” ");
INSERT INTO did_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Na nigdatong mandà kandan diyà to Hirusalim no lunsud. Nigpawpadiboy si Jesus diyà to solib to labow no simbahan. Pagpadiboy din du-on, pigduguk kandin to mgo punu-an to tinu-uhan to mgo Hudiyu. ");
INSERT INTO did_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Nig-iling kandan diyà ki Jesus to “Dow ando-i makalikat to ikow kabogbogan. Intawa to nigpahimu ikow to hinang nu.” ");
INSERT INTO did_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","30","Nakatabak si Jesus to “Moydu-on pad ig-usip ku iyu. Dow ando-i makalikat to kabogbogan ni Juan no Magbobonyagay. Dow likat to Diyus no Amoy dow ando-i. Ko makatag-an kow to tùtu-u, kayan ignangon ku iyu dow intawa to nigpahimu kanak to hininang ku. Na, nokoy to pagtag-an now.” ");
INSERT INTO did_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Dayun nigkasusukun sikan mgo Hudiyu dow nokoy to igtabak dan ki Jesus. Kagi dan, “Ko itabak ta to ‘Likat to Diyus no kabogbogan ni Juan no Magbobonyagay,’ ig-ikagi din man to ‘Nokoy man no wadà kow tu-u ki Juan.’ ");
INSERT INTO did_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Dì konà ta igtabak to ‘Puli likat to otow to kabogbogan ni Juan no Magbobonyagay,’ su ogkahadok ki to mgo ka-otawan. Su nigtu-u kandan to si Juan, lagboy tùtu-u no maglilikwaday to Diyus.” ");
INSERT INTO did_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kaling man to intabak to mgo punu-an to Hudiyu to “Indoy ta iyan dow ando-i makalikat to kabogbogan ni Juan.” Nig-ikagi si Jesus to “Su pig-angod now sikan, agad man. Oyow a gayod ognangon iyu dow intawa to nigpahimu kanak to hininang ku.” ");
INSERT INTO did_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Na impananglitan mandà ni Jesus to mgo ka-otawan no nig-iling to “Moydu-on otow no nigtanom to paras. Pig-aad din to paras. Pighimu din gayod du-on to ligisan to bogas to paras. Pighimu din gayod du-on to pinayag to otow no ogbantoy to paras din. Pigpa-uyamu din to paras to mgo otow no puli huwag-on to pag-ugpà. Dayun nighipanow kandin diyà to songo banwa. ");
INSERT INTO did_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Pag-abut to paras, pigpa-andu-on to tagtu-un to sugu-onon din awos podon pasukuton to kandin bahin. ");
INSERT INTO did_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Dì wadà bogayi kandin to mgo otow no pigpa-uyamu to paras. Pigbubunaan dan nasì aw pa-uli-a dan diyà to mata-as din no tagtu-un to paras. ");
INSERT INTO did_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Dayun pigpa-andiyà mandà to tagtu-un to songo sugu-onon din gayod. Pigpasukut din podon gayod to kandin bahin. Dì nasì on pigbunaan kandin to uu aw pa-inahi pad gayod to mgo otow no nig-uyamu to paras. ");
INSERT INTO did_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Moydu-on mandà ikatou no pigpa-andiyà din dì bali man no pighimatayan on nasì kandin to otow no nig-uyamu to paras. Mahan-ing pad to pigpama-andiyà din no sugu-onon. Dì moydu-on nasì pigbunaan aw moydu-on pighimatayan. ");
INSERT INTO did_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Sobu-uk pad no wadà pa-andu-ona to tagtu-un to kaparasan. Na bali pigpa-andu-on din to lagboy din nalogonan no anak. Nig-iling kandin to ‘Ogtahomon ku to anak ku no lukos to iyan ogtahudon to nig-uyamu to paras.’ ");
INSERT INTO did_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Na nigdatong to anak din diyà to pigtanoman to paras. Pag-abut din, naman-iling kan mgo otow no nig-uyamu to paras to ‘So-idid to anak to mata-as ta. Ogkahimu kandin no tagtu-un. Nokoy pad to ogtagadan ta. Oghimatayan tad. Kahimu kid no tagtu-un.’ ");
INSERT INTO did_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Dayun pigdakop dan to anak to tagtu-un aw hihimatayi dan. Intimbag dan kan patoy no otow diyà to labas to pigtanoman to paras. ");
INSERT INTO did_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Na, amonuhon buwa kan tagtu-un. Pig-andiya-an din to pigtanoman din to paras aw panghimatayi din tibò kan mgo otow no pigpa-uyamu din to paras aw ipa-uyamu din to duma no mgo otow.” ");
INSERT INTO did_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","Nig-iling si Jesus to “Dow wadà kow buwa makabasa to pananglitan to Diyus no nasulat no pig-iling to ‘To batu no pa-ukdangan podon to baoy, agad intimbag on puli to maghihimu to baoy, dì iyan on pighimu nasì to Diyus no sinaligan no pa-ukdangan. Sikan to nahimu to Magbobo-ot ta aw na-uyunan noy.’” ");
INSERT INTO did_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Pigdakop podon si Jesus to mgo punu-an to tinu-uhan su nasabutan dan to kandan to napa-atubangan to impananglitan ni Jesus. Dì puli dan pig-oyowan si Jesus aw pamanhipanow on su nahadok kandan to mgo ka-otawan. ");
INSERT INTO did_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Na pigpa-andu-onan si Jesus to mgo sakup to Parisiyu aw mgo sakup ni Harì Hirudis. Ogpangindakopan dan podon dow nokoy to kagi-kagi ni Jesus. ");
INSERT INTO did_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Nig-ikagi kandan to “Sir, pigkilaa noy to matuwadong ka no otow aw matul-id to pagpang-anad nu bahin to kasugu-an to Diyus. To pagpang-anad nu, wadà ogpili-on nu no otow agad ma-aslag dow ma-intok. Kaling, moydu-on ig-usip noy ikow. Nokoy to domdom nu bahin to pagpabayad ita to mgo buhis diyà ki Harì Cesar no mata-as to taga-Ruma no nakasakup ita. ");
INSERT INTO did_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Dow tugutan ki to kasugu-an dini ita to ogpakabayad ki dow konà.” Nama-anan ni Jesus to mangkapakunon-kunonon kandan no mgo otow. Nig-ikagi kandin to “Nokoy man no pigbogayan a now to pa-antihan. Daaha now dini kanak to songo sapì aw ipa-ahà kanak.” ");
INSERT INTO did_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Dayun pigbogayan dan. Kagi ni Jesus, “Intawa so-idi inotow-otawa. Intawa to tagngadan so-idi.” Nigtabak kandan, “Ki Harì Cesar.” ");
INSERT INTO did_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Nig-ikagi si Jesus to “I-untuu now diyà ki Harì Cesar to kandin bahin. Dì i-untuu now gayod diyà to Diyus to kandin bahin.” Na-ompongan kandan du-on. ");
INSERT INTO did_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Na moydu-on songo panon to Hudiyu no pighingadanan to Sadusiyu. Wadà tu-u kandan to ogbuhayon dà to mgo otow to mahudi no adow aw tuusa. Pigduguk si Jesus to mgo sakup to Sadusiyu. ");
INSERT INTO did_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Nig-ikagi kandan to “Sir, sikan kasulatan no kasugu-an ni Moises, pig-iling to ‘To mag-asawa, ko wadà pad makapanganak kandan dì ogkamatoy to bana, iyan ogpakapangimau to hadi din. Ko ogpanganak kandan, sikan mgo batà, angay dà to sugpù to kakoy din agad namatoy kandin.’ ");
INSERT INTO did_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Na ko pananglitan, moydu-on pitu no nigsusu-un. Nig-asawa to kakoy. No pagkaugoy to kandan pag-a-asawa, namatoy kan kakoy dì wadà pad makapanganak kandan. ");
INSERT INTO did_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Dayun pigpangimau to hadi no nigsunù. Dì pagkaugoy mandà, namatoy gayod kan hadi aw wadà pad gayod kandan makapanganak. Na to ikatou no su-un, nigpangimau mandà kandin to buyag. ");
INSERT INTO did_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Dì kandà to nadoogan to pitu no nigsusu-un. Tibò namatoy dì wadà kandan tibò makapanganak. Na kayan pana namatoy to buyag. ");
INSERT INTO did_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Na, agad-agad to ikow no impang-anad, ko buhayon to nangkamatoy to mahudi no adow, intawa dapit buwa to ogpakatu-un to buyag su to pitu no nigsusu-un, kandà man no na-asawa dan.” ");
INSERT INTO did_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Na nigtabak si Jesus to “Nakasuwoy kow to pagsabut now to tinu-uhan ta aw wadà kow makasabut to kasulatan to Diyus. Wadà kow gayod makasabut to kabogbogan to Diyus. ");
INSERT INTO did_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Wadà otow no og-asawa pad aw igpa-asawa pad to mahudi no adow su iyan on ogka-angodan to diwata to Diyus. ");
INSERT INTO did_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Na bahin to pagbuhoy to nangkamatoy aw tuusa, dow wadà kow buwa makabasa to kasulatan ton maglilikwaday to Diyus no si Moises? Pigsulatan din bahin to pagliyab-liyab to bawbagon no dugihon dì wadà pighalinan to bawbagon. Pagliyab-liyab to bawbagon no dugihon no wadà pighalinan, pig-ikagihan to Diyus si Moises to ‘Kanak no Diyus to ampu-onon ni Abraham, aw ampu-onon ni Isaac, aw ampu-onon ni Jacob.’” ");
INSERT INTO did_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Nig-iling si Jesus to “To mgo otow no ogkamatoy, konad on ogpaka-ampù to Diyus. Nakasuwoy kow to pagsabut now to tinu-uhan ta su wadà kow tu-u to buhayon dà to namatoy no mgo otow.” ");
INSERT INTO did_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Na pigduguk si Jesus to otow no mag-a-anad to tinu-uhan to Hudiyu. Nakadinog kandin ton pag-a-asuy aw indani to hustu to intabak ni Jesus. Nig-usip kandin ki Jesus to “Nokoy sugu-a to kamatu-udan lagboy.” ");
INSERT INTO did_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Nigtabak si Jesus to “So-idi to kamatu-udan no sugù no imbogoy itanow. To tugdow, pig-iling to ‘Paminog kow no mgo kasinugpu-an ni Israel. Sobu-uk dà to tùtu-u no ampu-onon now. Sikan tùtu-u no ampu-onon now, Diyus dà man. ");
INSERT INTO did_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Oglogonan now to Diyus no Magbobo-ot now, agad domdom now, pikii now, ginhawa now, aw mgo doson.’ ");
INSERT INTO did_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","To ikaduwa, angod sikan no pig-iling to ‘Oglogonan now to kapadihu now angod to paglogon to lawa now.’ Wadà nakasokod sikan no mgo sugù.” ");
INSERT INTO did_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Na nig-ikagi kan mag-a-anad to “Hustu Sir. Tùtu-u iyan to pig-ikagi nu. Sobu-uk dà to tùtu-u no ampu-onon. Wadà duma no tùtu-u no ampu-onon. ");
INSERT INTO did_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ogsundu-an to Diyus to buhì ta aw bogayi to pasalamat. Dì madoyow pad ko logonan ta to Diyus to domdom ta, mgo doson ta aw ginhawa ta, aw gayod oglogonan ta to kapadihu ta no angod dà to paglogon ta to ita lawa.” ");
INSERT INTO did_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nama-anan ni Jesus to tùtu-u to intabak kan otow aw kagi din to “Madaas-daas kad podon ogkasakup to Diyus.” Na likat sikan, wadà otow no oglangub ogpangindakop to kagi-kagi ni Jesus. ");
INSERT INTO did_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Na nigpang-anad mandà si Jesus to mgo ka-otawan diyà to labow no simbahan. Kagi din to “Amonuhon buwa no nig-iling to mgo mag-a-anad to ‘Sugpù ni David to otow no Imananan to Ka-otawan.’ ");
INSERT INTO did_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Natodu-on impatag-an ki Harì David to Ispiritu Santu bahin to otow no Imananan to Ka-otawan no pig-iling to ‘Diyus no Magbobo-ot ku, pig-ikagihan din kan Magbobo-ot ku gayod no na-iling to, Ogpaso-ingon ku ikow kani to kalintu-u ku hantod to ogpababawon ku ikow du-on to mgo kablang nu aw igpada-og ku ikow tibò kandan.’ ");
INSERT INTO did_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Sikan otow no Imananan to Ka-otawan, mano pighingadanan ni Harì David to Magbobo-ot din, amonuhon man no sugpù gayod kandin ni David.” To impang-anad ni Jesus, ogkaliyag to mgo ka-otawan to ogpaminog. ");
INSERT INTO did_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Na nig-iling si Jesus to “Bantoy kow, konà kow ogsunud to mgo mag-a-anad to tinu-uhan. Ogkaliyag kandan to ogkakita kandan no ogpangabò to mahal aw patahud-tahud diyà to kahimunanan ");
INSERT INTO did_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","aw diyà to simbahan aw diyà to pagko-onan. ");
INSERT INTO did_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Sikan mgo mag-a-anad, ogpambugow to mgo bau no buyag du-on to baoy dan. Dì puli mahabà to ogpanawag-tawag to Diyus. Dakoo to kastigu kandan.” ");
INSERT INTO did_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Na nig-ingkud si Jesus diyà topad to botanganan to sapì to simbahan. Nigbantoy kandin to mgo otow no nigbogoy to sapì. Mahan-ing to mgo datù no nigbogoy to dakoo no sapì. ");
INSERT INTO did_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Dì moydu-on bau no buyag no nigbogoy to daduwa dà ubag no ka-dakò. ");
INSERT INTO did_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Na pigpaduguk ni Jesus to mgo pangabaga din aw iling to “Agad pad pagtibo-on to sapì no imbogoy kan mgo otow, dì konà ogpakasokod to imbogoy kan no bau ");
INSERT INTO did_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","su kandan, nigbogoy to samà. Dì sikan bau no buyag, agad ma-intok to sapì din dì imbogoy din intibò, agad pangabuhì din.” ");
INSERT INTO did_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Na niglogwà si Jesus aw mgo pangabaga din du-on to labow no simbahan. Naka-ikagi to songo pangabaga din to “Sir, ahà ka so-idi labow no simbahan. Lagboy madoyow no batu.” ");
INSERT INTO did_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Nig-ikagi si Jesus to “So-idi no pighiling-hiling now no mgo mangka-aslag no baoy no simbahan, ogkangkalompag dà tibò to mahudi no adow. Wadà ogkasamà no batu no pigpapagdokot-dokot.” ");
INSERT INTO did_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Na nighipanow si Jesus aw mgo pangabaga din padoog diyà to untud no pighingadanan to Ulibu-an. Pag-abut dan du-on, nig-ingkud kandan diyà topad to labow no simbahan diyà to Hirusalim. Pigduguk kandin ni Pedro aw ni Santiagol ni Juan aw ni Andres aw tongopi dan usipa to ");
INSERT INTO did_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Dow kagan-u ogkagotò to paglompag to labow no simbahan. Nokoy to indananan noy to imomo-ot on to ogkagotò.” ");
INSERT INTO did_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Nigtabak si Jesus to “Bantoy kow, su dagow moydu-on ogpasuwoy iyu ");
INSERT INTO did_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","su mahan-ing to oglogwà no ogpa-angod-angod kanak no og-ikagi to ‘Kanak to Imananan to Ka-otawan.’ Mahan-ing no mgo otow no ogkangkasakup dan. Ogpamakasuwoy to mgo ka-otawan.” ");
INSERT INTO did_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nig-iling si Jesus to “Ko madinog now to gira diyà to kadiyu-an dow agad madani dà, kona kow ogkahadok. Maogot ogkasamuk to kalibutan dì konà pad no sikan to kagoto-an to kaliswahanan ");
INSERT INTO did_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","su ogkasamuk-samuk pad to mgo kanasudan aw ogkagubut pad to mgo kalunsudan. Ogtiyogon to nigsingkabugtì no banwa. Ogkogsa-an to bontas to mgo ka-otawan. Sikan kapinunu-an pad kan no kalisodan to mgo otow dini to babow to kalibutan.” ");
INSERT INTO did_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Nig-iling si Jesus to “Dumowdoyow kow, su ogdakopon kow aw daaha kow diyà to nigdaa to bala-od aw ogbunaan kow pad diyà to simbahan. Ogpa-atubangon kow to ukum aw hari bahin kanak. Bahin to pagtu-u now, sikan to paghutoy now to ignangon now to ukum. ");
INSERT INTO did_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Dì to wadà pad katapusan, ogpasabuton pad to tibo no timamanwa to Madoyow no Tutuwanon to Diyus. ");
INSERT INTO did_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ko pa-atubangon kow on aw pang-usip-usipa kòw, konà kow ogkapook-pook dow nokoy to igkatabak now, su tigka-un puli now ogkalituk to igbogoy iyu to Ispiritu Santu no litos no igkatabak now.” ");
INSERT INTO did_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nig-iling si Jesus to “Moydu-on adow no su-un din da, igkahatod din diyà to ukum aw pahimatayi din su nigtu-u kanak. To amoy gayod, ogpahimatayan din to batà din. To mgo anak, og-atu to amoy aw inoy aw pahimatayi. ");
INSERT INTO did_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Iyu, ogkablangon kow to tibò no mgo otow ugpat kanak ngadan. Di to oghogot to pagtu-u din kanak hantod to wada katapusan, ogkalipwasan dà.” ");
INSERT INTO did_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Iyu no ogbasa so-idi no diblu, indani now to kalitukan to pig-ikagi ni Jesus bahin kan kablang to Diyus. So-idi to kagi ni Jesus, “Ko makita-an now to ogsoodan to kablang to Diyus diyà to konà podon ogkasoodan no simbahan no abutanan podon to Diyus dà, ogpanlaguy to mgo taga-Hudiya diyà to ka-untudan. ");
INSERT INTO did_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ko diyà kow to labas to baoy, konà now on ogka-ulì pad to katinguban. Pakalaguy kow on puli. ");
INSERT INTO did_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ko ogtalabahu kòw diyà to uma, konà now on ogka-ulì pad to ilisan now diyà to baoy. ");
INSERT INTO did_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Aboy to magkabodos aw mgo manggi-anak to ogkalisodan. ");
INSERT INTO did_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Pangamuyù kow to Diyus to konà podon ogkatuman sikan no kalisodan to tig-amihan. ");
INSERT INTO did_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Likat to paggihit to Diyus so-idi kalibutan hantod kunto-on aw hantod to wadà katapusan, wadà ogpakasokod to kalisodan to mahudi no adow no ingkanangon kud iyu iyan. ");
INSERT INTO did_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ko wadà pa podon bo-oti tahan to Diyus to ogyopoton din dà to kalisodan, wadad on podon ogkasamà no mgo otow to mahudi no adow. Dì pigbo-otan nasì to Diyus to ogyopoton din dà to kalisodan su ogka-atan din to mgo sakup din no pig-abin din tahan.” ");
INSERT INTO did_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Nig-iling si Jesus to “Ko moydu-on otow no og-ikagi du-on iyu to ‘Dutun on iyan to Imananan to Ka-otawan,’ konà kow ogtu-u. Ko moydu-on otow no og-ikagi to ‘Kanid on to Imananan to Ka-otawan,’ konà kow ogtu-u. ");
INSERT INTO did_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Oglogwà to kunon kun Imananan to Ka-otawan dì matuu, konà man no tùtu-u. Oglogwà gayod to mgo namanpatutuus no gau-on. Oghimuhon dan to kaboonganan aw ta-indanan to kabogbogan no ogpakasuwoy kandan podon agad kan mgo sakup to Diyus no pig-abin din tahan. ");
INSERT INTO did_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Di bantoy kow su nama-anan now on dow nokoy to ogkadoogan sikan odomà, su pigma-an kud on iyu tahan.” ");
INSERT INTO did_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Na nig-iling si Jesus to “Pagkatapus to kalisodan to mgo otow dini to babow to kalibutan, ogkawada to bandog to soga aw buwan. ");
INSERT INTO did_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","To mgo bitu-on diyà to langit, ogka-uug aw mamakasuwoy to tahan dan no baya-anan. ");
INSERT INTO did_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Dayun ogkakita-an a no Tumutubus to Ka-otawan no oglugsad dini to kalibutan no ogliwaw-ang to gabun no ogdumahan to kabogbogan ku aw katuusan ku. ");
INSERT INTO did_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","To mgo diwata likat to Diyus, ogpahimunon ku to mgo sakup ku no pig-abin kud on tahan no ogmutmutan dan to binogdokan to langit.” ");
INSERT INTO did_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Nig-iling si Jesus to “Ko pananglitan, dini to babow to kalibutan kunto-on, moydu-on indananan ta to tinu-ig. Ko ogbogas on to mgo kayu, ogka-indanan tad to tiggaas on iyan. ");
INSERT INTO did_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","To mahudi no adow, ko dumatong on sikan no kalisodan dini to kalibutan, indananan now gayod to madaas on to pag-uli ku no Tumutubus to Ka-otawan. ");
INSERT INTO did_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Monang ogkamatoy to mgo otow no ogkita to pagpunù sikan ko matuman to tibò no pig-ikagi ku iyo. ");
INSERT INTO did_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Moydu-on dà katapusan to lingit aw kalibutan, dì to kagi ku, wadà katapusan.” ");
INSERT INTO did_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Na nig-iling si Jesus to “To adow no igkagotò to katapusan aw pag-ulì ku dini so-idi kalibutan, Diyus dà no Amoy ku to nataga. Agad kanak no Anak din aw mgo diwata likat to Diyus, wadà koy kangkataga su Amoy ku dà to nataga iyan. ");
INSERT INTO did_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Doydoyow kow. Bantoy kow su wadà kow gayod kataga to ogkagotò no adow. ");
INSERT INTO did_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Sikan kagoto-an to pag-ulì ku, angod to pag-ulì to tagbaoy no nighipanow diyà to songo banwa. Paglikat din, imbotang to sugu-onon din no kapatas. Pigbogayan din kada sugu-onon to kabagi-an no talabahu. Pigsugù din to magbabantayay to li-otan to ‘Bantayi.’ ");
INSERT INTO did_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Kaling man, bantoy kow su wadà kow kataga dow ogpakatokow to pag-abut to tagbaoy dow masaklop, kabakna-an to kadukiloman, kabukas-bukas, dow kabukas. ");
INSERT INTO did_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Bantayi now su dagow matokawan kow to pag-ulì to tagbaoy aw kakita-i kow to nalipodong kow. ");
INSERT INTO did_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","So-idi to kagi ku iyu aw kagi ku to tibò no mgo otow, Ogbantoy kow.” ");
INSERT INTO did_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Na to madaduwa pad no adow kayan ogkagotò to hihinangay to Hinang to Paan no Wadà Igpatulin no iyan nakadaa gayod to Hinang to Pagpalipas to Kado-otan no iyan ogpakapunù. Na pagkahimun to mgo punu-an to tinu-uhan to mgo Hudiyu, nigsusukun kandan dow og-amonuhon dan to pagkumit to ogkadakop dan si Jesus aw kahimatayi. ");
INSERT INTO did_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Dì na-uyunan dan to ogliwason dan pad to Hinang to Pagpalipas to Kado-otan su nig-iling kandan to “Ogliwason ta pad to hinang su dagow ogkasamuk to mgo ka-otawan no ogkangkahimun.” ");
INSERT INTO did_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Na og-uli-on tad to tutuwanon ki Jesus. Nigpa-ulì on kandin diyà to Bitaniya no lunsud. Nig-agpot kandin diyà to baoy ni Simon no na-uli-an on to ibung. No nig-ingkud pad si Jesus no nig-atubang to pagko-onan, nig-abut to buyag no nigdaa to lamita no limut no moydu-on intagù no mahal no hihinaki no mahomut no iyan ngadan to nardu. Wadà imba-ot kan no hihinaki. Pigbugwakan to buyag to lamita aw ibus-ug din du-on to uu ni Jesus. ");
INSERT INTO did_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Dì moydu-on otow du-on no nado-otan to pag-ahà aw ka-inusipay kandan no nig-iling to “Nokoy man no puli pig-uwakan sikan hihinaki. ");
INSERT INTO did_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ko imbaylu pa podon sikan to sapì, agad pila no gatus buwa to kantidad. Madoyow pad podon ko igbogoy diyà to mgo publi.” Impapanagda to mgo ka-otawan kan buyag. ");
INSERT INTO did_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Dì kagi ni Jesus to “Konà now igpanagda kandin. Madoyow to pighinang din kanak. ");
INSERT INTO did_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Agad nokoy no adow igkabulig now to mgo publi su kanunoy man natuonan kow dan dini. Dì kanak, konà no maugoy to paghituon ta. ");
INSERT INTO did_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Sikan to pagtahud din kanak su madaas ad ogkamatoy. Pighimu din to na-amuhan din. Pighina-atan a din on su iglobong a no pinabayà to paghinaki kanak to mahal no hihinaki.” ");
INSERT INTO did_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nig-iling si Jesus to “Agad ando-i no banwa no ogpanoysoy to Madoyow no Tutuwanon, ogkanangon to pighinang kanak todu-on no buyag. Kaling man kanunoy ogkadomdoman to mgo otow pighinang todu-on no buyag no sikan to pagtahud din kanak.” ");
INSERT INTO did_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Na si Judas lskariyuti no pangabaga dà gayod ni Jesus, nig-andiyà kandin to mgo punu-an to tinu-uhan to mgo Hudiyu, su igbaligyà din si Jesus diyà kandan. ");
INSERT INTO did_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Pagkataga to punu-an, nigtukhow kandan. Dayun insahad dan diyà ki Judas to ogbogayan dan to sapì. Kaling man kanunoy nakadomdom si Judas dow og-amonuhon din to pagkumit to ogkadaa din si Jesus diyà to mgo kablang din. ");
INSERT INTO did_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Na nig-abut to una-una no adow to Hinang to Paan no Wadà Igpatulin no iyan nakadaa gayod to Hinang to Pagpalipas to Kado-otan no iyan ogpakapunù. Na pig-usip si Jesus to mgo pangabaga din to “Ando-i koy nu no baoy to ogpahina-aton to paniyapun to Hinang to Pagpalipas to Kado-otan.” ");
INSERT INTO did_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Nig-ikagi si Jesus diyà to daduwa no pangabaga din to “Sood kow diyà to lunsud to Hirusalim. Pagkasood now, ogsungunon kow to otow no ogdawdaa to bobotangan no pigtagu-an to wohig. Pagkita now kandin, duma kow kandin. ");
INSERT INTO did_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","To baoy no ogsoodan sikan no otow, sikan to ogko-onan ta. Ilinga now diyà to tagbaoy to ‘Igpa-usip ka kanami ni Sir dow ando-i to pa-abutanan nu no og-iyapunan noy to Hinang to Pagpalipas to Kado-otan.’ ");
INSERT INTO did_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ko ma-usip now on to tagbaoy, ogtudli-an kow on to pa-abutanan diyà di-atas no natingub on tahan tibò. Diyà now hina-ata to paniyapun ta.” ");
INSERT INTO did_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Dayun nighipanow to pangabaga ni Jesus padoog diyà to lunsud to Hirusalim. Pag-abut dan diyà to lunsud, natuman on to pig-ikagi ni Jesus tibò aw pighina-at dan tibò to pagko-onan no indodomdomay dan to Pagpalipas to Kado-otan. ");
INSERT INTO did_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Pagkasaklop, nig-abut on si Jesus aw duma no pangabaga din. Namantatagbu si Jesus aw ton sampuù tag duwa no ka-otow diyà to baoy no pa-abutanan. ");
INSERT INTO did_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ton diyà pad kandan no namandungà pad to pagko-onan nigtag-an si Jesus no nig-iling diyà to mgo pangabaga din to “Ogdaahon ad to pangabaga ku dà diyà to kablang ku. Agad nigpagsau kanak kunto-on, dì ogdaahon a din diyà to kablang ku.” ");
INSERT INTO did_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Nangkapook-pook to mgo pangabaga din no duma. Nigka-inusipay kandan to “Intawa man buwa dapit Sir kanami. Konà buwa no kanak.” ");
INSERT INTO did_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Nig-ikagi si Jesus to “Songo otow no pangabaga ku dà, ogdaahon a din diyà to mgo kablang ku. To nigpagsau kanak, sikan iyan to ogdaa kanak diyà to mgo kablang ku. ");
INSERT INTO did_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Agad kanak to Tumutubus to Ka-otawan, dì tahan on nasulat bahin to kanak kamatayon. Dì aboy sikan no otow, kanugun on to mahudi no adow. Sikan otow no nigbaligyà kanak no Tumutubus to Ka-otawan, madoyow pad nasì ko wadad podon ka-otow kandin.” ");
INSERT INTO did_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Na to wadà pad katapus to pagko-on, pigdawat ni Jesus to paan aw pasalamati din. Dayun pigpikas-pikas din aw pamalogobi din kotob to pangabaga din no pigdonganan din to kagi no nig-iling to “Dawata now so-idi paan no igpamogoy ku iyu su lawa ku so-idi.” ");
INSERT INTO did_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Pig-usab din pigdawat to kabù aw pasalamati din to Diyus aw ipamalogob din. Pigpamogayan din to mgo pangabaga din aw dawat kandan aw inom tibò. ");
INSERT INTO did_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nig-iling si Jesus to “Kanak on to ogpakimatoy to saà to mgo otow dini to kalibutan. So-idi inomon, langosa ku dà no ogpataugon ku su ogpakimatoy a iyu. ");
INSERT INTO did_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","So-i iyan to panugun-tugun ku iyu. Monang kid ogka-i-inom mandà ko mahudi on no adow ko umabut on to pagharì to Diyus dini to kalibutan.” ");
INSERT INTO did_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Na namanganta kandan to insayà-sayà dan to Diyus no Amoy. Pagkatapus to kanta, namanghipanow kandan padoog diyà to Ulibu-an no untud. ");
INSERT INTO did_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Nig-iling si Jesus to “Gagaya ogtawadan a now tibò su ogdakopon ad su nasulat on bahin iyu no impananglitan to Diyus natodu-on no pig-iling to ‘Ogpahimatayan ku to nigbantoy to mgo buhì aw puli on ogkawagà-wagà to mgo buhì.’ ");
INSERT INTO did_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Dì agad mamatoy a, dì ogbuhayon a dà. Pagbuhaya ku, og-una a iyu diyà to Galiliya no banwa no ogtatagbuhan tanow.” ");
INSERT INTO did_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Naka-iling si Pedro to “Agad kandan tibò mamang-oyow ikow, dì konà a og-oyow ikow.” ");
INSERT INTO did_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Nig-ikagi si Jesus to “So-idi no kadukiloman no konà pad no ikaduwa no pagtaga-uk to manuk, katatou a nu to ilidung to nakilahan a nu.” ");
INSERT INTO did_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pigbogat ni Pedro lagboy to pag-ikagi no nig-iling to “Ando-i ku man ikow oyowi. Kamatayon nu, kamatayon ku dà gayod. Konà ku iglidung ikow.” Namansunud gayod to duma no pangabaga to kandan no pag-ikagi. ");
INSERT INTO did_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Na nig-abut on si Jesus aw mgo pangabaga din diyà to Gitsimani no tinanoman to kayu. Nig-ikagi si Jesus diyà to mgo pangabaga din to “Kamonang kow kani. Dì kanak, ogpadiyù-diyù a su og-ampù a to Diyus.” ");
INSERT INTO did_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Iyan dà pigpaduma din si Pedro, si Santiago aw si Juan. Napook-pòok lagboy si Jesus aw kaduyong-ot. ");
INSERT INTO did_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nig-ikagi kandin to “Naduyong-ot lagboy to ginhawa ku hantod to igkamatoy kud podon so-idi. Kamonang kow kani aw bantoy kow.” ");
INSERT INTO did_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nig-u-ugsud si Jesus aw tinakin patilangkob kandin. Nigpangamuyù kandin to Diyus no ko mahimù to ogpalipwasan kandin sikan og-abut kandin. ");
INSERT INTO did_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Nig-iling si Jesus to “Amoy, ikow dà to ogka-amu to pagbulig agad nokoy no kalisod. Buligi a nu kunto-on Amoy, lipwasi a nu so-idi. Dì konà no kanak to ogpakabo-ot. Dì ikow dà to ogpakabo-ot to kanak ogkadoogan.” ");
INSERT INTO did_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Na nig-ulì si Jesus du-on kan tatou no pangabaga din. Dì nangkalipodong tibò kandan. Nig-iling kandin diyà ki Pedro to “Simon, dow nalipodong kad? Dow konà ka ogpakatuwa-ay to ogbantoy agad songo uras dà? ");
INSERT INTO did_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Og-agdam kow aw ampù kow to Diyus awos konà kow ogkatokawan to kalisodan no og-anti to pagtu-u now. Du-on to ginhawahan to otow ogkaliyag kandin to oghogoton podon to pagtu-u din. Dì ko ogdo-ogan on kandin to kalisodan, ko kandin dà, konà ogka-amu to pagtuman on to paghogot.” ");
INSERT INTO did_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Na nigpa-ulì mandà kandin to pig-ampu-an din aw ampù mandà kandin no pigsudsud din dà to pagpangamuyù din. ");
INSERT INTO did_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Dayun nigpa-ulì kandin du-on to mgo pangabaga din. Dì nangkalipodong dà na-usab kandan su lagboy nangkapuwow. Wadad igka-ikagi dan. ");
INSERT INTO did_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","To ikatou no pagpa-ulì ni Jesus, nig-ikagi kandin to “Nokoy man no nangkalipodong kow pad man aw hibat kow. Agad on, su nagotò on to adow ku kunto-on no ogdaahon a diyà to mgo otow no dakoo to saà no kanak no Tumutubus to Ka-otawan. ");
INSERT INTO did_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Na, bangun kow su ogkuwà kinow on. Nig-abut on to otow no ogdaa kanak diyà to kablang ku.” ");
INSERT INTO did_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Na ta-un to pag-ikagi ni Jesus, nigduguk si Judas no sood dà gayod to sampuù tag duwa no pangabaga ni Jesus no nadumahan to kahan-ingan likat to mgo punu-an to tinu-uhan to Hudiyu. Namandaa kandan to otak aw popokpokay. ");
INSERT INTO did_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Na sikan otow no nigbaligyà ki Jesus, ogtudli-an din kan mgo ka-otawan to ta-indanan no tahan dan nasabutan dow ando-i si Jesus. Kagi kan nigbaligyà no nig-iling to “To oghadokan ku, kandin si Jesus. Dayuna now dakopa aw padumaha now dì kanunoy now bantayan.” ");
INSERT INTO did_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Nigduguk kandin ki Jesus aw ikagi to “Sir,” aw hadoki din si Jesus. ");
INSERT INTO did_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Dayun to pigdakop dan si Jesus. ");
INSERT INTO did_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Moydu-on duma ni Jesus no nakalapnut to otak din aw itigbas to sugu-onon to mata-as to mgo punu-an to tinu-uhan. Dì iyan dà na-igù to dibauy no talinga din aw kasangguwi. ");
INSERT INTO did_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Na nig-iling si Jesus diyà to mgo ka-otawan to “Dow oghimuhon a now no tulisan no ogdakopon now? Nokoy man to impandaa now to otak aw popokpokay. ");
INSERT INTO did_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Adow-adow pigpang-anad ku iyu diyà to simbahan dì wadà a now dakopa. Dì ogdangat so-idi awos matuman to impasulat to Diyus natodu-on bahin to kanak kamatayon.” ");
INSERT INTO did_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Na du-on naluwatan bali si Jesus to mgo sakup din aw pamanlaguy kandan. ");
INSERT INTO did_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Nadumdumahan si Jesus to songo bawbatà no nangabò dà to hinaboan no maputì. Pigdawat gayod kandin to mgo ka-otawan. ");
INSERT INTO did_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Dì nigpanlaguy sikan bawbatà to tinakin naobasan. Nabilin ton hinaboan du-on to boad to otow no nigpandawat kandin. ");
INSERT INTO did_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Dayun pigdaa si Jesus to mgo ka-otawan diyà to mata-as to mgo punu-an to tinu-uhan to mgo Hudiyu. Nahimun tibò to mgo punu-an. ");
INSERT INTO did_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Na si Pedro, nigpawpatilupug dà kotob diyà to solib to baoy to mata-as to mgo punu-an. Nig-ingkud kandin du-on no nigpaglamutoy to mgo guwardya no namanghinadang du-on to kayu. ");
INSERT INTO did_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Tibò no mgo punu-an aw mata-as dan, nigpanganap to mgo otow no moydu-on igkadiklamu no tùtu-u bahin ki Jesus. Ogpakahimatayan dan on podon si Jesus. Dì wadà man ingkadiklamu no tùtu-u. ");
INSERT INTO did_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Mahan-ing to mgo gau-on no mgo otow no nigbotang-botang, dì konà no oghiduma to litukan to innangon dan tibò. ");
INSERT INTO did_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Moydu-on gau-on no mgo otow no nig-iling to ");
INSERT INTO did_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nakadinog koy to pig-ikagi din no pig-iling to ‘Oglompagon ku so-idi no abutanan to Diyus no pighimu to otow. Dì sood to tatou no adow ogdangonon ku dà to duma no abutanan to Diyus no konà oghimuhon to otow.’” ");
INSERT INTO did_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Dì to mgo nangon dan, wadà gayod hiduma to kalitukan. ");
INSERT INTO did_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Na nigsakindog to mata-as to mgo punu-an to tinu-uhan aw usipa din si Jesus to “To indiklamu ikow ton mgo otow, dow wadà igkatabak nu?” ");
INSERT INTO did_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Dì puli on nigpapahonok si Jesus. Pig-usip mandà si Jesus to “Dow ikow, Kristu ka iyan no tùtu-u no Imananan to Ka-otawan no Anak to Kinalabawan no Ampu-onon diyà to langit?” ");
INSERT INTO did_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Nigtabak si Jesus to “Ho-o iyan. Ogkakita-an a now no Tumutubus to Ka-otawan no ogso-ing diyà to kalintu-u to Diyus aw og-ulì dini so-idi kalibutan no ogpakaliwaw-ang a to gabun.” ");
INSERT INTO did_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","No malituk sikan, dayun pigpongkas to mata-as no otow to kabò din. Naka-ikagi kandin to “Nokoy man no ogtagadan ta pad to mgo diklamu. ");
INSERT INTO did_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nadinog now on to mado-ot no na-ikagi din no ingkapa-ina din to Diyus. Nokoy to iyu no ogkaliyagan.” Tibò kandan, na-uyun to si Jesus, himatayanan. ");
INSERT INTO did_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Moydu-on nig-ilob diyà to goya ni Jesus. Pigsalibonan dan to mata ni Jesus aw sumbaga dan aw ikagihi to “Tag-ana nu kun dow intawa ton nigsumbag ikow.” Pigsampalu gayod kandin to mgo sundau. ");
INSERT INTO did_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Na og-uli-on tad to tutuwanon ki Pedro no diyà to solib no nig-ingkud no nigpanghinadang to kayu. Pigduguk kandin to buyag no sugu-onon to punu-an to tinu-uhan. ");
INSERT INTO did_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Nakita-an din si Pedro no nigpanghinadang diyà to kayu. Nig-ahà kandin diyà ki Pedro aw ikagi to “Ikow gayod, duma ka ton taga-Nasarit no si Jesus.” ");
INSERT INTO did_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Dì naka-ikagi si Pedro aw iling to “Wadà ku kakilahi kandin. Wadà nasabutan ku no kalitukan to kagi nu.” Nigpagsuwoy si Pedro aw li-ot kandin diyà to li-otanan. Tinakin nigtaga-uk to manuk. ");
INSERT INTO did_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Na nakita-an mandà si Pedro ton sugu-onon du-on to li-otanan. Nig-ikagi to sugu-onon diyà to mgo otow no maglalaboy to “Sikan no otow, duma ni Jesus.” ");
INSERT INTO did_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Dì niglidung mandà si Pedro. Dayun nig-ikagi to mgo otow no maglalaboy to “Sakup ka ni Jesus iyan, su taga-Galiliya ka man.” ");
INSERT INTO did_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pigpakabogat mandà ni Pedro to pag-ikagi no nig-iling to “Wadà ku kakilahi sikan no otow no ing-ikagi now kanak.” ");
INSERT INTO did_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","No malituk din to kagi, nakadinog kandin to ikaduwa on no taga-uk to manuk. Tinakin nadomdoman ni Pedro to na-ikagi ni Jesus tahan no pig-iling to “To ikaduwa no pagtaga-uk to manuk, katatou nud to ilidung to nakilahan a nu.” Dayun nakasinogow si Pedro ugpat to pagkasosoo din. ");
INSERT INTO did_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Na pagkabukas namanhihimun mandà tibò to punu-an to tinu-uhan aw pamansusukun-sukun to paghimatoy dan ki Jesus. Dayun impabakus dan si Jesus aw daaha dan diyà ki Pilato no gubirnadur no imbotang du-on to taga-Ruma no nakasakup to mgo ka-Hudiyuhan. ");
INSERT INTO did_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pig-usip mandà ni Pilato to “Ikow, dow harì ka to mgo Hudiyu?” Nakatabak si Jesus to “Kan ing-usip nu, tùtu-u iyan.” ");
INSERT INTO did_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Mahan-ing to indiklamu ki Jesus to mgo punu-an to tinu-uhan. ");
INSERT INTO did_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pig-usip mandà ni Pilato to “Nadinog nud to mahan-ing to indiklamu ikow, dow wadà igtabak nu?” ");
INSERT INTO did_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Dì wadad usab ikagi si Jesus. Puli nigpapahonok kandin hantod to naboong-boong si Pilato. ");
INSERT INTO did_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Na to tighihinang to Hinang to Pagpalipas to Kado-otan, kadoog ogsabuk si Pilato no gubirnadur to sobu-uk no pirisu, su tahan din. Dì igpapilì din pad to mgo ka-otawan. ");
INSERT INTO did_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Kan no timpu, mahan-ing no mgo otow no napirisu no nighimatoy to otow to pag-atu dan to gubirnu. Moydu-on gayod otow diyà to pirisuhan no nig-atu no pighingadanan ki Barabas. ");
INSERT INTO did_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Na nig-abut to mgo kahan-ingan aw pangamuyù ki Pilato to ogpapili-on kandan to pirisu no ogpasabukan su tahan ni Pilato. ");
INSERT INTO did_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Nig-usip si Pilato to mgo otow to “Dow ogpasabukan now kanak to Harì to mgo ka-Hudiyuhan?” ");
INSERT INTO did_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Sikan to pig-ikagi ni Pilato su domdom din to pigdaa si Jesus to mgo punu-an su ogsombangon dan kandin. ");
INSERT INTO did_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Dì pigpilì to mgo punu-an to kandan ogpasabukan si Barabas, aw pigpamab-otan dan gayod to mgo ka-otawan no si Barabas dà to igkapapilì dan. ");
INSERT INTO did_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Na nig-iling mandà si Pilato to “Nokoy man to igpagbo-ot now kanak so-idi no otow no pighingadanan now man to Harì to mgo ka-Hudiyuhan.” ");
INSERT INTO did_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Namansa-og kandan to “Himatayi. Tutuki diyà to kinurus.” ");
INSERT INTO did_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Naka-ikagi si Pilato, “Nokoy man. Nokoy to saà din.” Dì pigpadugang dan nasì to sa-og no mgo kahan-ingan no “Himatayi. Tutuki.” ");
INSERT INTO did_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Bali impabu-ud puli ni Pilato to ka-otawan aw pigsabukan din si Barabas su igpatukhow din to mgo ka-otawan. Dì si Jesus, pigpabunaan din aw tinakin ibogoy din kandin diyà to mgo sundau aw pahimatayi din on nasì. ");
INSERT INTO did_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Na pigdaa to mgo sundau si Jesus diyà to sood to baoy no kahimunanan to gubirnadur. Pigpatawagan dan to tibò no panon to kasundauhan no ginatus to kahan-ing. ");
INSERT INTO did_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Pigkabo-an si Jesus to mgo sundau to kabò no maogdog no ogpaka-angod-angod to kabò to harì. Pigsapid dan to bawbagon no dugihon no impa-angod-angod dan to sinuwang-suwang to harì aw su-uwi dan to uu ni Jesus. ");
INSERT INTO did_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Nigpakunon-kunon to mgo sundau nigpagkamusta ki Jesus no naman-ikagi kandan to “Mabuhì to Harì to mgo ka-Hudiyuhan.” ");
INSERT INTO did_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Pigbunaan dan gayod to buu to uu ni Jesus aw ilobi gayod. Nigpakunon-kunon nigluhud sikan mgo sundau diyà to atubangan ni Jesus. Nigpakunon-kunon gayod nigtahud kandan ki Jesus aw dugadiha dan. ");
INSERT INTO did_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pagdugadi dan ki Jesus, piglobasan dan kandin to kabò no maogdog aw ilisi dan to tahan din kabò. Pigdaa dan si Jesus diyà to labas su ogtututukon dan on diyà to kinurus. ");
INSERT INTO did_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Na puli nakalaboy to otow no si Simon no taga-Sirini no amoy ni Rufo aw ni Alejandro no niglikat to hilit. Pigpogos pigpati-ang si Simon to mgo sundau to kinurus no ogpadodopahan ki Jesus. ");
INSERT INTO did_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Na pigdaa si Jesus to mgo sundau diyà to banwa no pighingadanan to Gulguta no kalitukan to bobo-ungon to otow. ");
INSERT INTO did_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Na pigtadwayan dan si Jesus to inomon no pigba-otan to tambaa no makalilingow. Dì wadà abaya inoma ni Jesus. ");
INSERT INTO did_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Na intututuk si Jesus to mgo sundau du-on to kinurus aw lindoga dan. Dayun pighahandug to mgo sundau to mgo kabò ni Jesus no impabayà to tinag-anay dow intawa dapit kandan to makatu-un. ");
INSERT INTO did_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mgo alas nuwibi to kasooman to paglagkot dan ki Jesus. ");
INSERT INTO did_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","So-idi to nasulat no indiklamu dan ki Jesus no pig-iling to “Harì to mgo Ka-Hudiyuhan.” ");
INSERT INTO did_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Na intutuk dan si Jesus aw daduwa no ka-tulisan no pinagdibauy kandan. ");
INSERT INTO did_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Natuman bali to kasulatan no kalitukan to “Pighinang dan kandin no kasala-anan.” ");
INSERT INTO did_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Moydu-on maglalaboy no nigkita ki Jesus aw ina-inaha dan aw pamanpanaklà aw iling to “Hoy, maglolompag kun to labow no simbahan aw ikow kun to og-uliman gayod to sood to tatou no adow, ");
INSERT INTO did_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","na, tabang ka kun iyan kunto-on to ikow lawa. Anti kad kun kawas du-on to kinurus.” ");
INSERT INTO did_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Naman-ina-ina gayod to mgo punu-an no nigka-inikagihay to “Pigbuligan din to nigsingkabugtì no otow dì konà man na-an ogka-amu ogbulig to kandin lawa. ");
INSERT INTO did_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Lamanon ko tùtu-u no kandin to Imananan to Ka-otawan su ogkawas on kunto-on kandin, kayan to ogtu-u kinow to kandin iyan na-an to harì no og-imanon ta.” Sikan mgo tulisan no intututuk gayod du-on to kinurus no pinagdibauy du-on ki Jesus, naman-ina-ina dà gayod kandin. ");
INSERT INTO did_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Na pag-ugtu to soga nigdiglom to banwa hantod to mgo alas tris on to uras. ");
INSERT INTO did_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Kayan naka-ikagi si Jesus to ma-agbot to kandin tu-un no kagi no pig-iling to “Eluwi, Eluwi, lama sabaktani,” no iyan kalitukan to “Diyus ku, Diyus ku, na-amonu ka man no pig-oyowan a nu.” ");
INSERT INTO did_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Moydu-on mgo maglalaboy no intobo-ot dan dow pigsabi din si Elias aw mamaka-iling kandan to “Ahà ka, pigtawag din si Elias.” ");
INSERT INTO did_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nigpanlaguy to sobu-uk aw pudut to papasopsopay aw pasopsopa din to sukà no inomon. Insaligpit din to papasopsopay du-on to tawoy to katinoptopan aw itukhoy din awos makasupsup si Jesus. Naka-ikagi to otow no maglalaboy to “Aya kad na-ay su dagow umandini si Elias no oglingat kandin du-on to kinurus.” ");
INSERT INTO did_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Na nigsa-og si Jesus no nigtu-un nigligtas to ginhawa. ");
INSERT INTO did_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Na to pagkamatoy ni Jesus, nakadongan to napongkas to ingkayad no insalibon to habangan to abutanan to Diyus no sinabong diyà sood to labow no simbahan diyà to Hirusalim. Pagkapongkas to ingkayad no magapaad to kadamoo, diyà kapunù to babow hantod to sagyad. ");
INSERT INTO did_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Na to kapitan to mgo sundau, pagkakita din to na-iling to pagkaligtasi ni Jesus, naka-ikagi to “Anak na-an iyan to Diyus sikan no otow.” ");
INSERT INTO did_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Na moydu-on gayod mgo buyag no namanbantow puli to pag-ahà. Sikan mgo buyag, mgo sakup gayod ni Jesus. Namanduma kandan ki Jesus diyà to Hirusalim. Ton diyà pad si Jesus to Galiliya, kandan to nig-alagà kandin. Iyan ngadan dan si Maria no taga-Magdala, si Salumi, si Maria no inoy ni Jose aw ni Santiago no piggoan ki Batà. Moydu-on pad duma no mgo buyag no namanduma ki Jesus diyà to Hirusalim. ");
INSERT INTO did_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Na moydu-on otow no nigbo-ot to kandin to oglobong ki Jesus. Iyan ngadan din si Jose no taga-Arimatiya. Talahudon no otow kandin no songo nigdaa gayod to mgo Hudiyu. Pig-iman din gayod to pagsakup to Diyus. Nigpanginpabubuut si Jose to nig-andiyà ki Pilato aw ba-id to kandin to oglobong ki Jesus. ");
INSERT INTO did_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Naboong-boong si Pilato pagdinog din to namatoy on si Jesus. Pigtawag din to sundau din aw usipa dow namatoy on si Jesus. ");
INSERT INTO did_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pagkama-an ni Pilato to namatoy on si Jesus, pigtugutan din si Jose to oglobong. ");
INSERT INTO did_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Na nigboli si Jose to hinaboan no linu. Piglingat din to patoy aw lukuti to hinaboan no linu. Dayun inlobong din diyà to pigbangbangan no batu. Pagkatapus dan to niglobong, pigligadan dan to malidok no batu aw isomban. ");
INSERT INTO did_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Si Maria no taga-Magdala aw si Maria no inoy ni Jose, pig-indanan dan to piglobongan ki Jesus. ");
INSERT INTO did_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Na to katapusan to adow no konà no tigtatalabahu, namoli kan mgo buyag to pahomut. Ogpahomutan to patoy kan mgo buyag no si Maria no taga-Magdala, si Salumi, aw si Maria no inoy ni Santiago. ");
INSERT INTO did_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Pagkabukas nig-andiyà kandan to piglobongan. ");
INSERT INTO did_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","No diyà pad kandan to pangindanan, nigkasusukun to “Aboy gagaya to ogligad to batu no insomban to lobong.” ");
INSERT INTO did_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Kan no pag-abut dan, pag-ahà dan, naligad on to batu. ");
INSERT INTO did_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Na nigsood kandan to pigbangbangan no batu. Pagsood dan nakita-an dan to otow no batan-on pad diyà to kalintu-u no nig-i-ingkud. Nangabò kandin to hinaboan no maputì. Naboong-boong sikan mgo buyag. ");
INSERT INTO did_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Pig-ikagihan din kandan to “Konà kow ogkahadok. Dow iyan ogpanganapon now si Jesus no taga-Nasarit no intutuk diyà to kinurus? Wadad dini. Pigbuhoy on. Aha-a now to pigbotangan kandin. ");
INSERT INTO did_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ulì kow on aw nangoni now si Pedro aw duma pad no pangabaga din to og-una on kandin iyu diyà to Galiliya no banwa. Maogot no diyà to igpagkita now si Jesus su sikan to tugun din iyu.” ");
INSERT INTO did_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nigpatilogwà sikan mgo buyag aw pamanlaguy. Naboong-boong to domdom dan aw pampidpida kandan to pagkahadok. Wadad mamaka-ikagi kandan su konad no pagkahadok dan. ");
INSERT INTO did_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","To kabukas-bukas to masoom to Dumingu no adow pigbuhoy si Jesus. Pagbuhoy kandin iyan una-una piglogwà din si Maria no taga-Magdala no piggawangan din natodu-on to pitu no busow no nigsood kandin. ");
INSERT INTO did_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Dayun nig-andiyà si Maria to mgo sakup ni Jesus no namansinogow pad kandan to pag-oog dan kandin. Dì pignangonan ni Maria to “Pigbuhoy on si Jesus su nakita-an kud.” Dì wadà tu-u sikan mgo sakup ni Jesus. ");
INSERT INTO did_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ikaduwa no piglogwà ni Jesus to daduwa no sakup din no nighipanow kandan diyà to kahilitan. Paglogwà ni Jesus kandan, na-usab on to lawlanguhan din. ");
INSERT INTO did_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nig-ulì kan daduwa no ka-otow aw nangoni dan to duma no mgo sakup ni Jesus to “Nigbabaaw koy.” Dì wadà tu-u gayod kandan. ");
INSERT INTO did_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ikatou no piglogwà ni Jesus ton mgo pangabaga din no sampuù tag isa no ta-un to namango-on kandan. Impanagda din su bugtì on to ginhawa dan. Wadà tu-u kandan kan mgo otow no nakakita ki Jesus to pigbuhoy on. ");
INSERT INTO did_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Pigsugù ni Jesus to mgo pangabaga din to “Ogpalapuwaasan ku iyu to mgo otow hantod to binogdokan to langit aw ipapasabut ku iyu to Madoyow no Tutuwanon to Diyus. ");
INSERT INTO did_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","To otow no ogtu-u aw pabonyag, ogkalipwasan kandin to saà. Dì to otow no konà ogtu-u, ogkadokotan to saà hantod to wadà katapusan. ");
INSERT INTO did_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","To mgo otow no ogtu-u, ogkahimu dan to agad nokoy no kaboonganan. Ogkagawang dan to mgo busow no igpabayà to kanak ngadan no oggamiton dan aw tigka-un ogpamang-ikagi kandan to inikagihan no wadà dan aligbat ka-anadi. ");
INSERT INTO did_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Agad makadawat kandan to uwod dì konà ogkamuwa kandan. Agad maka-inom kandan to makahilu dì wadà oghalinan. Ko damponon dan to masakiton, ogka-uli-an to sakit.” ");
INSERT INTO did_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Pagkatapus to pag-ikagi ni Jesus no Magbobo-ot, nabayow kandin diyà to langit. Nig-ingkud kandin no nigso-ing diyà to kalintu-u to Diyus. ");
INSERT INTO did_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Pagkali-us ni Jesus, nighipanow on to mgo sakup din. Niglogob-logob kandan to timamanwa aw pasabut to Madoyow no Tutuwanon no pigtabangan kandan to Magbobo-ot ta aw matu-uda to pagpang-anad dan su pigpadumahan din to kaboonganan.");
INSERT INTO did_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Kamusta ka man Sir Teofilo: To mgo otow no tahan nigdumduma ki Jesu-Kristu, namannangon kanami to napugut no nakita-an dan ton natuonan din pad kandan su to hinang dan to ogpang-anad to kagi din. Mahan-ing no otow to namanpa-awos to ogpansulat bahin sikan napugut likat to kapinunu-an. ");
INSERT INTO did_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Na nadomdom kud to madoyow ko igpansulat ku gayod ikow Sir Teofilo, su sikan mgo nawnangonon likat to kapinunu-an, naugoy on man to pag-anad kud gayod. ");
INSERT INTO did_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Igpadaa kud ikow to sulat awos mamatu-ud ku to lagboy katùtu-uhanan bahin ton nadinog nud on awos mama-anan nu lagboy to katùtu-uhanan. ");
INSERT INTO did_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Dì tugdow iyan igkatutuwanon ta pad bahin ki Juan no Magbobonyagay. Na to timpu to pagka-otow din, si Hirudis to nigharì diyà to prubinsiya to Hudiya, aw moydu-on songo punu-an to tinu-uhan to mgo Hudiyu no nigtubus to ka-otawan diyà to atubangan to Diyus to pag-ampù. Iyan ngadan din si Zacarias no nasakup to panon ni Abias no sugpù ni Arun no tugdow no imbotang no pigpatubus to ka-otawan diyà to atubangan to Diyus natodu-on. Iyan asawa din si Elisabet no sugpù dà gayod ni Arun. ");
INSERT INTO did_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Matuwadong no namang-ugpà kandan no mag-asawa diyà to atubangan to Diyus aw matinumanon kandan to kasugu-an to Diyus no Magbobo-ot, aw to mgo tulumanon, pigpantuman dan lagboy tibò. ");
INSERT INTO did_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Dì puli on nangkabuyag kandan. Ampan makakita to anak su bukak si Elisabet no buyag aw kandan tibò, puli on nangkabuyag. ");
INSERT INTO did_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Na to mgo panon to punu-an to tinu-uhan no ogtubus to ka-otawan to pag-ampù diyà to atubangan to Diyus, ogsusukoli. Na Abias on no panon to ogpaka-ampù to Diyus. Si Zacarias to nakalabas to tinag-anay no ogsangab to palina no ig-ampù to Diyus ko ogduguk kandan diyà to atubangan to Diyus. Sikan man to ingkatahan dan. No pagkatuman to tigsasangab to palina nigsood on si Zacarias to simbahan to Diyus. ");
INSERT INTO did_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Dì to kahan-ingan no ka-otawan, nigtagad-tagad puli diyà to labas no namang-ampù kandan gayod to Diyus. ");
INSERT INTO did_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Tinakin nakalogwà du-on ki Zacarias to diwata likat to Diyus aw dani no nigsakindog diyà dapit to kalintu-u to botanganan no sangabanan to palina. ");
INSERT INTO did_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Pagkasunglà ni Zacarias to diwata, pig-abut kandin to kahadok aw koba. ");
INSERT INTO did_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Dì nig-ikagi to diwata to “Konà ka ogkahadok Zacarias, su dininog on to Diyus to pigpangamuyù nu kandin su iyu no mag-asawa kunto-on, ogkakita now on to anak now no lukos aw hingadani now ki Juan. ");
INSERT INTO did_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Wadad ogbayan to ginhawa now to pagkaliyag. Aw to mgo hamilidan, ogkaliyag gayod ko ma-otow to batà now ");
INSERT INTO did_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","su oghimuhon kandin to Diyus no tahudonon to mgo otow. Kandin, konà oghilabot to ogpakahingow. Ko ma-otow kandin, tahan on nasoodan to Ispiritu Santu. ");
INSERT INTO did_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","To mgo kasinugpu-an ni Israel no namanlingow on to pag-ampù to Diyus no Magbobo-ot dan, mahan-ing to ogpapa-uli-on din. ");
INSERT INTO did_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Kandin, ogpaka-una to Magbobo-ot awos mahina-at din to pagdatong to Magbobo-ot su ogpamasabuton din to ka-otawan angod dà ki Elias no mabogbog no maglilikwaday to Diyus natodu-on su ogkasoodan gayod kandin to Ispiritu Santu. Ogpagdaagon din to mgo amoy aw mgo batà. Mgo otow gayod, agad pig-oyowan dan to pagdomdom to Diyus, dì ogpapa-uli-on din kandan to pagdomdom diyà to Diyus su awos mahina-at to kasinakupan no ogkaliyagan to Magbobo-ot ta.” ");
INSERT INTO did_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Naka-ikagi si Zacarias to “Og-amonuhon ku man buwa to pagpadoog to paghimu ku sikan su kanami, tibò koy on man nangkabuyag.” ");
INSERT INTO did_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Nig-ikagi to diwata to “Kanak no si Gabriel no diwata no maglilikwaday to Diyus, kadoog a ogtagad-tagad du-on to atubangan din. Pigpa-andini ad su ogpalikwadon a din ikow ton ingkanangon kud on ikow ganina. ");
INSERT INTO did_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Dì ikow, wadà nu man tu-uhi to ingkanangon ku no sikan ogkatùtu-u man iyan lagboy to timpu on to kagoto-an. Na, likat on iyan kunto-on, ikow, ogkawada-an kad to kagi hantod to ogkatuman ton ingkanangon ku ikow.” ");
INSERT INTO did_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Na sikan ka-otawan no namantagad-tagad diyà to labas, nangkaboong-boong kandan to nokoy to ingkaugoy ni Zacarias to nakalogwà du-on to sood to simbahan. ");
INSERT INTO did_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Na pagkalogwà din, konad ogpaka-ikagi. Na to kadumahan din, nasabutan dan to moydu-on impakita kandin to Diyus. Mangginonà nandà ogsinyas kandin diyà to kadumahan din aw hantod to natuyunan on napohà si Zacarias. ");
INSERT INTO did_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Na pagkatapus to kandin no pag-ampù to Diyus, nasukolihan on kandan to songo panon gayod aw ulì si Zacarias diyà to kandin banwa. ");
INSERT INTO did_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Na si Elisabet, pagpangidam din, nigpakamonang kandin diyà to baoy to sood to lima no buwan su kandin, nangidam aw maka-ikagi kandin to ");
INSERT INTO did_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Pigbuligan ad to Diyus no Magbobo-ot kunto-on, aw pigka-atan a din aw nagawangan a din on to igkasawoy kanak to ka-otawan su kanak, bukak a man no otow.” ");
INSERT INTO did_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Na, pagka-abut to onom no buwan to pagkabodos ni Elisabet, pigpalugsad to Diyus to diwata din no si Gabriel diyà to Nasarit no lunsud no nasakup to Galiliya no prubinsiya. ");
INSERT INTO did_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Impa-abut to Diyus kan diwata du-on ki Maria no daga no asawahon on ni Jose no sugpù ni David no harì natodu-on. ");
INSERT INTO did_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","No pagdatong on to diwata, nig-ikagi kandin to “Kamu sta man, naliyagan ka to Magbobo-ot no og-aha-on ka din kanunoy.” ");
INSERT INTO did_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Si Maria, dakoo no napook-pook dow nokoy to tawoy sikan no pagkamusta kandin to diwata. ");
INSERT INTO did_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Nig-ikagi to diwata to “Konà ka ogkahadok Maria, su na-uyunan kad on to Diyus su ikow, ");
INSERT INTO did_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ogkakita nud to anak no lukos. Oghingadanan nu kandin ki Jesus. ");
INSERT INTO did_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ogkabantug kandin aw kahingadani to Anak to Kinalabawan no Katuusan Tibò, aw Diyus no Magbobo-ot, ogbogayan din kandin to pigsakupan ni David no minuna din, ");
INSERT INTO did_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","aw ogsakupon din to kasinugpu-an ni Jacob to wadà katapusan.” ");
INSERT INTO did_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Naka-ikagi si Maria to “Dow amonuhon buwa to pagtuman sikan no kanak, wadà man bana ku podon.” ");
INSERT INTO did_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Nigtabak to diwata to “Ogkonsadan ka to Ispiritu Santu aw ogsoodan ka to katuusan to Diyus no Kinalabawan. Kaling man to igkabodos nu, ogkahingadanan to mgo otow to matuwadong no Anak to Diyus. ");
INSERT INTO did_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Na to su-un nu no si Elisabet no nabuyag on man podon kandin no sikan iyan piggoan to mgo otow to bukak no buyag, nigkabodos on man kandin. Onom din on no buwan to pagkabodos. ");
INSERT INTO did_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Bahin to Diyus, wadà konà din ogka-amuhan aw wadà gayod hinang no konà din ogkatagahan.” ");
INSERT INTO did_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Nig-ikagi si Maria to “Kanak, sugu-onon a to Magbobo-ot ku. Podon dini kanak matuman to ikow no kagi bahin kanak.” Dayun niggawang on to diwata du-on kandin. ");
INSERT INTO did_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Na si Maria, nig-agpas kandin aw panlotà-lotà to mgo ka-untudan padoog diyà to songo lunsud du-on to prubinsiya to Hudiya. ");
INSERT INTO did_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Baoy ni Zacarias to pigdatongan din aw iyan soodi din aw dayun kamustaha din si Elisabet. ");
INSERT INTO did_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Du-on binatì ni Elisabet to nigpanghisù-hisù to gotok din no madinog din to malituk ni Maria to pagkamusta din aw kasoodi si Elisabet to Ispiritu Santu ");
INSERT INTO did_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","aw maka-ikagi to mabogbog no na-iling to “To kabuyagan tibò, ikow dà to pigpanalanginan lagboy to Diyus aw sikan batà gayod no ingkabodos nu. ");
INSERT INTO did_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nokoy man buwa no kanak to pigpatahudan to Diyus no nig-agpot man dini kanak to inoy to Magbobo-ot ku. ");
INSERT INTO did_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Su iyan inghisù to gotok ku su nigtukhow man to batà ku no madinog kud to malituk nu to pagkamusta nu. ");
INSERT INTO did_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Lagboy iyan to pagtukhow nu su nigtu-u ka man to ogkatuman to impanahad to Magbobo-ot.” ");
INSERT INTO did_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Na si Maria, naka-ikagi to, “Bahin to kanak ginhawa tibò, ogpalabawon kud on to Magbobo-ot ku ");
INSERT INTO did_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","aw tukhow ad lagboy no nadomdoman a man to Diyus no Maglilipwasay ku ");
INSERT INTO did_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","su likat kunto-on to mgo tipahudi, oghimuhon a dan no ogpa-aag-aagon a to Diyus agad kinasagkopan a, ");
INSERT INTO did_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","su to Diyus, labow to kabogbogan din, aw to ngadan din, wadà saà, aw pigbuligan a to kabogbogan din. ");
INSERT INTO did_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ogka-atan din to mgo ka-otawan no ogtahud kandin agad natodu-on aw kunto-on aw kaugayan. ");
INSERT INTO did_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Impakita din to kabogbogan din su to mgo otow no nigpalabow to kandan domdom diyà to Diyus, ogpamasuwayon din. ");
INSERT INTO did_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","To mgo kinalabawan no ogsakup dini to babow to pasak, ogkahimu din nasì kandan no ogpakapasagkop, dì to mgo masagkop, ogpalabawon din nasì. ");
INSERT INTO did_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","To mgo binontas, ogpako-onon din nasì to madoyow. Dì to mgo datù, ogpagawangon din nasì no wadà igbogoy. ");
INSERT INTO did_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","To mgo Isrili no mgo otow no sinakupan to Diyus, pigbuligan din su wadà din kalingawi to pagka-at din kandan ");
INSERT INTO did_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","su pigsahadan din to ka-aw-apu-an ta no si Abraham aw mgo kasinugpu-an din tibò.” Sikan to ingkasayà ni Maria to Diyus. ");
INSERT INTO did_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Sood to tatou no buwan to pag-agpot ni Maria du-on ki Elisabet, kayan nig-ulì on kandin diyà to banwa din. ");
INSERT INTO did_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Na si Elisabet, nagotò on to adow no a-anakay din on aw to ingka-anak din, lukos. ");
INSERT INTO did_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","To mgo kadumahan din, pagkadinog dan, namantukhow kandan lagboy su natu-un ni Elisabet to ka-at likat to Magbobo-ot dan. ");
INSERT INTO did_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Na pagkawauhi no adow, to kadumahan ni Zacarias no aag Isrili, naman-andu-on kandan to baoy din awos mata-indananan to batà no sakup to Diyus aw to paghingadan gayod. Insangay dan podon kandin to ngadan to amoy din no si Zacarias. ");
INSERT INTO did_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Dì naka-ikagi to inoy din to “Konà man ogkahimù no igkasangay to paghingadan. Dì nasì kandin, iyan igkahingadan si Juan.” ");
INSERT INTO did_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Dì namaka-ikagi kandan to “Dì wadà kadumahan now no nahingadanan to angod sikan no ngadan agad-agad to ita no na-anadan.” ");
INSERT INTO did_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Na nigsinyas kandan du-on to amoy to batà no pohà dow intaa to kandin ighingadan. ");
INSERT INTO did_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Na nigpabogoy si Zacarias to ogkasulatan to ngadan. Dayun insulat din du-on to “Ogkahingadanan tad kandin ki Juan.” Du-on naboong-boong kan kadumahan dan su wadà kadumahan dan no ogkasangayan to angod sikan no ngadan. ");
INSERT INTO did_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Na sukuu mahingadanan to batà du-on dayun na-uli-an si Zacarias to pagkapohà din aw ogpakalituk on to og-ikagi aw makasayà-sayà on kandin to Diyus. ");
INSERT INTO did_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Sikan kadumahan dan, pig-abut to kaboong-boong aw natangkapan to nawnangonon to banwa dan no ka-untudan to prubinsiya to Hudiya. ");
INSERT INTO did_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Na to tibò to mgo ka-otawan no namakadinog, nigsin-indan sikan nawnangonon aw nigdomdom dow nokoy to ogkatuman aw ka-inusipay kandan to “Nokoy on buwa to ogkadoogan sikan no batà. Agaw moydu-on kabogbogan to Diyus no nakadongan to pagka-otow din su pigbogayan kandin to katondanan no ogkatuman to mahudi no adow.” Kandin, nadumahan iyan to pagbulig to Diyus. ");
INSERT INTO did_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Na si Zacarias no amoy to batà, nasoodan to Ispiritu Santu aw ogpalikwadon kandin to so-idi no kagi no pig-iling to, ");
INSERT INTO did_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Masayà-sayà on to Diyus no ampu-onon to mgo Isrili su moydu-on pigpa-andini din no sinakupan din aw kabuligi ki din aw bogayi kid din to ogpakatubus no ogpakamatoy to saà ta, ");
INSERT INTO did_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","su pigbogayan kid to Diyus to mabogbog no Maglilipwasay no sugpù ni David no sugu-onon din. ");
INSERT INTO did_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Su to mgo lagsoban to Diyus no maglilikwaday din, natag-an dan ");
INSERT INTO did_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","to ogpabuligan ki din ko mapahadatan ki to mgo kablang ta aw ko ogkablangon ki to agad intawa no otow. ");
INSERT INTO did_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Impatag-an gayod to Diyus diyà to ka-aw-apu-an ta to ita, ogka-atan ki iyan no kasinugpu-an dan su konà din man ogkalingawan to impanahad din diyà kandan. ");
INSERT INTO did_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Angod dà man to impanahad din ki Abraham no minuna ta ");
INSERT INTO did_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","to ogbuligan ki din ko mapahadatan ki to mgo kablang ta aw ogpa-ampu-on ki din no wadad ogkasukoniban ta no saà ta. Kanunoy ki ogpakatuwadong diyà to atubangan to Diyus hantod to mamatoy kid. ");
INSERT INTO did_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Aw ikow no batà ku, ogkahingadanan ka to maglilikwaday ka to Kinalabawan no Diyus, su ogpa-unahan ikow to Magbobo-ot awos mahina-at nu to igbayà din ");
INSERT INTO did_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","su ogtagahon nu to kasinakupan to Diyus to ogbuligan din kandan su ogpasayluhon din to saà dan. ");
INSERT INTO did_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Su ogka-atan kid lagboy to Diyus su ko magotò to adow aw ogsilat on no ogpandalipaak, ogtang-awan kid on, ");
INSERT INTO did_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","su dini ki pad man to kadigloman su nasalibonan ki pad man kunto-on du-on kan tumatang-away to Diyus su mamatayon ki pad man, dì ogka-alladan kid to daan no malinawon.” Sikan to impalikwad to Diyus ki Zacarias no amoy ni Juan. ");
INSERT INTO did_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Na si Juan, nigtulin on no ma-ugsob aw naponù to pikii gayod. Dì mamonang dà kandin diyà to kahilitan hantod to nagotò on to adow no iglogwà din to ka-otawan no mgo Isrili. ");
INSERT INTO did_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Na og-uli-on tad to tutuwanon ki Jesu-Kristu. To timpu to pagka-otow din, si Harì Agusto, nigsugù to ogpamalistahon to mgo sakup tibò du-on to pigsakupan din. ");
INSERT INTO did_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Na si Kirinyu to gubirnadur to prubinsiya to Siriya ton tugdow no pagpamalista. ");
INSERT INTO did_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","To mgo ka-otawan, nigsingka-andiyà to kandan tahan no lunsud no piglikatan to ka-aw-apu-an dan aw pamalista kandan. ");
INSERT INTO did_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Na si Jose no taga-Nasarit no nasakup to Galiliya no sugpù ni David, nighipanow no nig-andiyà to Bitlihim no nasakup to Hudiya su sikan to lunsud ni David. ");
INSERT INTO did_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Nigpaduma kandin ki Maria no bayà din katu-un no nigkabodos on dì matuu daga pad kandin. Nigduduma su ogpamalista kandan. ");
INSERT INTO did_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","No diyà pad kandan to Bitlihim, nagotò on to adow no a-anakay ni Maria ");
INSERT INTO did_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","aw lukos to anak din no panganoy din. Pigkomo-an din aw pahibata diyà to ko-onanan to baka su wadad ogka-oogan dan diyà to pa-abutanan no baoy. ");
INSERT INTO did_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Na diyà ta pad to bugtì no tutuwanon du-on kan no banwa. Moydu-on magbabantayay to karniru diyà to pamàpa-anan kandà no kadukiloman, ");
INSERT INTO did_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","aw tinakin piglogwà kandan to diwata likat to Diyus no Magbobo-ot aw katang-awi kandan to bandog to Diyus. Pig-abut kandan to kahadok. ");
INSERT INTO did_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Nig-ikagi to diwata to “Konà kow ogkahadok su moydu-on ogkanangon ku iyu no madoyow no nawnangonon no ogtukhawan to mgo otow dini to kalibutan no nigsingkabugtì to piglikatan dan ");
INSERT INTO did_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","su to iyu no Maglilipwasay no Magbobo-ot no Imananan to Ka-otawan, ing-anak on kunto-on no adow diyà to lunsud ni David. ");
INSERT INTO did_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Na so-idi to ta-indanan no igkapatu-u iyu to ingkanangon ku iyu. Ogkakita-an now to batà no pigkomo-an no pinahibat diyà to ko-onanan to baka.” ");
INSERT INTO did_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Na tinakin to namantampu on to duma no mgo diwata no niglikat to langit no namansayà-sayà to Diyus. Namanlangkoà kandan no nig-iling to, ");
INSERT INTO did_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Masayà to Diyus no diyà to kinatikangan to langit, aw to kapasakan, wadà podon samuk-samuk to mgo otow no na-uyunan to Diyus, madumahan kandan to kalinaw.” ");
INSERT INTO did_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Na pigboong dan on to diwata aw ulì diyà to langit. To mgo magbabantayay to karniru, nigka-inikagihay to “Kuwà kinow on, og-andiyà kid on to Bitlihim awos ogkakita-an ta to nahimu no innangon ita to Magbobo-ot.” ");
INSERT INTO did_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Dayun namanpadagas kandan aw kakita-i dan si Maria aw si Jose aw sikan batà no pinahibat du-on to ko-onanan to baka. ");
INSERT INTO did_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Pagkakita dan ki Maria aw ki Jose aw sikan batà, namannawnangonon kandan to innangon kandan to diwata bahin sikan no batà. ");
INSERT INTO did_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","To mgo otow no nakadinog to innangon to mgo magbabantayay to karniru, nangkaboong-boong kandan. ");
INSERT INTO did_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Dì si Maria, puli din pig-indanan aw kanunoy din domdoma. ");
INSERT INTO did_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Na to mgo magbabantayay to karniru, namang-ulì on no namansayà-sayà to Diyus aw tahud-tahuda dan kanunoy to Diyus bahin to nakita-an dan aw nadinog dan su natuman tibò no iyan na-agadan to innangon kandan to diwata. ");
INSERT INTO did_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Na pagkawauhi no adow, pigtuman to ginikanan to tulumanon bahin to paghingadan to batà aw pag-indan su sikan to na-anadan to mgo sakup to Diyus natodu-on. Pighingadanan dan kandin ki Jesus agad-agad to innangon to diwata to wadà pad ikabodos kandin. ");
INSERT INTO did_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Na natuman on to adow to pagtuman to tulumanon bahin to pagpanganak to inoy no iyan na-agadan to kasugu-an ni Moises, su nasulat on diyà to Kasulatan to Diyus no pig-iling to “Ogtaphagan now to Diyus to daduwa no bu-uk no salapati dow daduwa no ugà to baud.” Sikan no tulumanon, pighingadanan to Paglinis to Pag-anak. Na kandan si Jose, naman-andiyà to labow no simbahan diyà to Hirusalim awos ipa-ahà kan batà to Diyus no ta-indanan to og-uyun to ginikanan to igkabogoy kan no batà diyà to Diyus no ogdaa kandin to pag-ampù to Diyus ko tumulin to batà su nasulat on gayod ni Moises natodu-on diyà to Kasulatan to Diyus no pig-iling to “To batà no lukos no panganoy, ogka-abin to Diyus to oghimuhon no ogdaa to pag-ampù to Diyus.” ");
INSERT INTO did_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Na sikan no timpu moydu-on otow diyà to Hirusalim no iyan ngadan din si Simeon. Matuwadong kandin aw matinumanon to kasugu-an to Diyus aw kanunoy ogtagad-tagad kandin ko ogbuligan to Diyus to mgo Isrili. Nasoodan kandin to Ispiritu Santu. ");
INSERT INTO did_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Tahan on pigmatu-udan kandin to Ispiritu Santu to monang kandin ogkamatoy ko makita-an din pad to otow no oghimuhon to Diyus no Imananan to Ka-otawan. ");
INSERT INTO did_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Na pig-alladan si Simeon to Ispiritu Santu diyà to simbahan no labow awos du-on din tagadan kandan si Jose su ogtumanon dan kan no tulumanon bahin to mgo batà no iyan ogka-agadan to kasugu-an ni Moises. Na pagdatong dan on, ");
INSERT INTO did_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","pigdawat ni Simeon to batà aw sawsagopuha din aw sayà-saya-a din to Diyus no nig-iling to, ");
INSERT INTO did_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Na, Magbobo-ot ku, kanak no sugu-onon nu, kunto-on ogkahimù to ogtugutan a nud to ogkamatoy su bali ad nalitosan ");
INSERT INTO did_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","su nakita-an kud on iyan lagboy to pagbulig nu kanami agad-agad to innangon on kanak, ");
INSERT INTO did_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","no nahina-at nud on no ogkakita-an to ka-otawan no nigsingkabugtì to oglikatan. ");
INSERT INTO did_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Sikan mgo otow no wadà pad makakita ikow, ogkakita-an dan no andidiyow no ogpandalipaak, su ogtang-awan din to daan no igkatutuu dan diyà ikow, aw kandin to ogkahimu no igkabantug to sinakupan nu no mgo Isrili.” ");
INSERT INTO did_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Na du-on naboong-boongan to amoy aw inoy to na-ikagi bahin to kabahinan to batà. ");
INSERT INTO did_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Na si Simeon, pigpapanalanginan din to Diyus kandan no tatou. Dì nig-ikagi kandin diyà ki Maria no inoy to batà no pig-iling to “To ikow no ginhawahan, oglasadon to kaduyong-ot no angod to ma-utong no otak su mahan-ing no Isrili no kadumahan to batà, og-oyow kandin. Dì iyan ogkahimu no ogpakabalitu kandan. Dì moydu-on duma gayod, ogkahimu kandin no tukhawanan dan. Aw kandin to ogpaka-ukas to nakasood to ginhawahan to mahan-ing no mgo otow.” Sikan to intag-an ni Simeon to kabahinan ni Jesus. ");
INSERT INTO did_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Na moydu-on gayod maglilikwaday to Diyus no buyag diyà to Hirusalim no iyan ngadan din si Ana no anak ni Panuwil no sakup to Asir no panon su kasugpu-an kandin ni Asir. Si Ana, nabuyag on lagboy su kawau-an on aw upat no tu-ig to idad din. Pitu dà no tu-ig to pagkaminyò din, nabau on kandin. Puli on nigpakamonang kandin diyà to simbahan no labow, adow aw madukilom nigsimba aw nig-ampù to Diyus aw pu-asa. ");
INSERT INTO did_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Kandà no timpu no du-on pad kandan si Jose to simbahan, nigdatong si Ana du-on aw bogoy to pasalamat din diyà to Diyus aw pagbaaw-baaw kandin bahin kan no batà diyà to mgo ka-otawan no naman-iman to ogpakatubuk to Hirusalim to pagsakup aw paglipwas to saà to mahudi no adow. ");
INSERT INTO did_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Na kandan si Jose, pagkatuman on to tibò to tulumanon no insugù to Diyus no Magbobo-ot bahin to bayà pad pag-anak, namang-ulì on kandan diyà to banwa dan no Nasarit no nasakup to Galiliya. ");
INSERT INTO did_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Aw to batà, nigtulin on no madoson. Natogob on to ka-ugsob aw nadumahan kandin to ka-at to Diyus. ");
INSERT INTO did_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Na kandan si Jose, kada tu-ig naka-inandiyà to Hirusalim to tighinang no pighingadanan to Hinang to Pagpalipas to Kado-otan. ");
INSERT INTO did_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Na pagkasampuu-i tag duwa no tu-ig to idad ni Jesus, kandan si Jose aw duma no taga-Nasarit, namanba-ot kandan to hinang diyà to Hirusalim su sikan man to natahanan dan. ");
INSERT INTO did_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Na pagkatapus to hinang, namantitibò on naman-ulì to kahan-ingan diyà to kandan lunsud. Dì to ginikanan ni Jesus, wadà dan katagahi to nabitas dan dà to Hirusalim. ");
INSERT INTO did_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Dì intobo-ot dan dow nakaba-ot dà kandin to kahan-ingan no pag-ulì to pagkatapus to paghinangan. Pinuna-us dan to adow to paghipanow. Bali dan naboong-boongan su wadà dan pad kakita-i si Jesus to songo adow. Dayun pigpanganap dan to batà diyà to kadumahan dan no namakaduma. ");
INSERT INTO did_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Dì wadà dan kakita-i. Dayun pig-ulì si Jesus to ginikanan diyà to Hirusalim aw diyà dan panganapa. ");
INSERT INTO did_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Pagkatatouhi no adow, bali dan on natutuwan si Jesus no diyad on to simbahan no labow no nigpaglatok-latok to mangka-aslag no mgo otow no mag-a-anad to tinu-uhan. Nigpaminog kandin aw pangusip-usip gayod kandin. ");
INSERT INTO did_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Tibò no nakadinog ki Jesus, naboong-boongan dan to kandin pagsabut aw pagtabak gayod. ");
INSERT INTO did_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Na to ginikanan ni Jesus, pagkakita dan to nakaba-ot kandin to nangkama-an to tinu-uhan, naboong-boongan dan kandin aw ipanagda to inoy no nig-iling to “Utù, nokoy man no nigpakalimu-ut ka kanami, su agad ando-i napanganap noy ikow.” ");
INSERT INTO did_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nigtabak si Jesus to “Nokoy man to igpanganap now kanak. Dow wadà kow kataga to kanak, ogpakamonang ad dini to simbahan to Amoy ku?” ");
INSERT INTO did_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Dì wadà dan kadaagi to inikagi ni Jesus. ");
INSERT INTO did_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Na nigduma si Jesus to ginikanan din diyà to Nasarit aw pasakup kandin. Dì to inoy din, pig-indanan din puli sikan no napugutan. ");
INSERT INTO did_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Na to pagtulin-tulin ni Jesus aw dugang-dugang to domdom din, na-uyunan kandin to Diyus aw mgo otow gayod. ");
INSERT INTO did_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Na og-uli-on tad si Juan no anak ni Zacarias no diyà ugpà to kahanongan no banwa. Na to ikasampuù tag lima no tu-ig to pagharì ni Tibiriyu, pigtidow si Juan to kagi no likat to Diyus no kandin, diyà to kahanongan. Na si Poncio Pilato, gubirnadur to Hudiya, si Hirudis, gubirnadur to Galiliya, aw su-un din no si Felipe, gubirnadur to Ituriya aw Trakuniti. Si Lisanias, gubirnadur to Abilina. Si Anas aw si Kaipas to kinatikangan to punu-an to tinu-uhan to mgo Hudiyu. ");
INSERT INTO did_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Si Juan, piglogob din to mgo banwa diyà to pigsilugan to Hurdan no wohig aw pangudlin to ka-otawan to kandan, ogpakasosoo to paghimu dan no mado-ot aw oyowi, aw bonyagi din diyà to wohig awos mapasaylu to Diyus to saà dan. ");
INSERT INTO did_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Na du-on natuman on to nasulat ni Isaias no lagsoban no maglilikwaday to Diyus natodu-on no pig-iling to, “Diyà to kahanongan no banwa, moydu-on nigpangudlin to ma-agbot lagboy no nig-iling to ‘Oghina-aton now to daan to Magbobo-ot ta. Ogtul-idon now to igbayà din. ");
INSERT INTO did_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ogkapatag to mgo ka-untudan, aw ogka-untud to mgo kapatagan, aw ogkasosokod on tibò. Ogpotoson to maliwog aw to nambu-u-bu-u, ogpamatagon to Diyus. ");
INSERT INTO did_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Tibò to mgo otow, ogpakakita to pagbulig to Diyus.’ ” Sikan to nasulat ni Isaias babin to katondanan ni Juan no Magbobonyagay. ");
INSERT INTO did_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Na to pagpangudlin ni Juan to ka-otawan, namutmutan dan kandin su ogpamabonyag kandan. Dì moydu-on gayod mgo namanpakunon-kunon no mgo otow to ogpasakup kandan to impang-anad ni Juan su puli podon kandan ogpabonyag. Dì nig-ikagi si Juan to “Iyu tibò no mgo otow, iyan ogka-angodan now to uwod su puli kow malaguy-laguyon to kahadokanan. Nokoy man no puli kow ogpapatiwoy to kaboù to Diyus to mahudi no adow dì wadà kow makasosoo to katahani now no bugtì aw oyowi. ");
INSERT INTO did_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Na ko lagboy tùtu-u to pagpasakup now to impang-anad ku bahin to pagkasosoo now to paghimu now no bugtì, igpatu-u now no igpabayà now to pag-oyow now aw oghimuhon now gayod to madoyow awos igkapatu-u lagboy to pagpasakup now aw katotopong to hinang now aw pagpasakup now. Konà kow gayod oglangub og-ikagi to ‘Agad on man, konà koy ogpakapatu-u to kanami pagpasakup su konà kinow man ogkabou-an to Diyus su itanow tibò, sugpù kinow dà ni Abraham tibò no mgo Hudiyu no mgo otow aw impanahad iyan to Diyus diyà ki Abraham to ogpanalanginan din to kasinugpu-an tibò ni Abraham.’ Dì,” kagi ni Juan, “ognangonan ku iyu to si Abraham, konà ogkapook to kasinugpu-an no ogpanalanginan to Diyus su to Diyus, ogpakabauy kandin so-idi no mgo kabatuhan no ogkahimu no kasinugpu-an ni Abraham no ogka-uyunan to Diyus agad Hudiyu aw bugtì no banwa no piglikatan dan. ");
INSERT INTO did_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Na tibò no mgo kayu no konà ogbogas to madoyow, ogpoodon aw dap-uga aw padokoti to kayu, aw kunto-on imomo-ot on podon to ogpupukon iyan du-on to punu-an.” ");
INSERT INTO did_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Na to ka-otawan, naman-usip to “Og-amonuhon noy man to paghimu awos ogtotopong to hinang noy aw pagpasakup noy.” ");
INSERT INTO did_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Natabak ni Juan to “Na to daduwa no kabò, igbogoy to sobu-uk diyà to nawada-an. To moydu-on ogkako-on, ogbogayan gayod to nawada-an.” ");
INSERT INTO did_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Na to mgo magsusukut to buhis no namanpabonyag on, naman-usip to “Nokoy to igpahimu nu kanami no awos matotopong to hinang noy aw to pagpasakup noy.” ");
INSERT INTO did_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Natabak ni Juan to “Konà now ogpasublahan to igpasukut iyu to mata-as.” ");
INSERT INTO did_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Na to mgo sundau, naman-usip gayod to “Nokoy to igpahimu nu kanami.” Na-ikagi din to “Iyu no mgo sundau, wadà ogtulisan now, konà kow ogpanda-og-da-og aw pandiklamu to konà no tùtu-u aw ogkalitosan kow to igbayad iyu.” ");
INSERT INTO did_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Na to ka-otawan no namamaminog to kagi ni Juan, kanunoy naman-iman to og-abuton kandan to pagbulig to Diyus aw domdoma dan dow si Juan on iyan buwa to Imananan to Ka-otawan no tahan on impanahad to Diyus. To mgo ka-otawan, nigsingka-usip to tu-un dan no domdom dow intawa lagboy si Juan. ");
INSERT INTO did_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Kaling man nig-iling si Juan to “Kanak, ogmatu-udon kud on to pagpasakup now to kanak impang-anad no igpabayà to ogbonyagan kud iyu to wohig. Dì moydu-on otow no ogpakasukoli pad hognà kanak no oglabow pad lagboy kandin dini kanak to kabogbogan. Kanak, igatang podon ogpabatà-batà a kandin. Dì konà a, su oglabow pad lagboy kandin dini kanak to kabogbogan. Kandin gayod, ogmatu-udon din to pagpasakup now to kandin impang-anad no igpabayà to ogbonyagan kow to Ispiritu Santu no iyan ogsoodan kow din lagboy. Aw kalisodan gayod no iyan ogka-angodan to logdog no og-abut iyu to igmatu-ud su sikan to ig-anti dow tùtu-u to pagpasakup now kandin. ");
INSERT INTO did_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Na to ogpakasukoli kanak, imomo-ot din on oglinisan to gi-okanan su oghimunon din to bogas aw ibotang diyà to botanganan. Dì to uhut, ogsangabon to kayu no wadà kaposokanan.” ");
INSERT INTO did_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Na si Juan, mahan-ing pad to duma no mgo pangudlin din no pagpasabut din to ka-otawan to Madoyow no Tutuwanon. ");
INSERT INTO did_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","Dì si Hirudis no gubirnadur, mahan-ing no hininang din no bugtì no napanagdahan ni Juan. Pinasubla din on su impapirisu si Juan su si Juan, nakapanagda ki Hirudis natodu-on su si Hirudis, nig-agow ki Hirudiyas no asawa dà to su-un din. ");
INSERT INTO did_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Na og-uli-on tad si Jesus no nigtulin on kandin. No pigpambonyagan pad ni Juan to kahan-ingan no kandin wadà pad kapirisu, si Jesus gayod, pigbonyagan din. Si Jesus, no pag-ampù din to Diyus, natau-angan to langit ");
INSERT INTO did_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","aw nigbunsud du-on kandin to Ispiritu Santu no iyan na-angodan to salapati no ta-un nadinog dan to kagi likat to langit no na-iling to “Ikow to nalogonan ku lagboy no Anak aw kaliyagi kud lagboy ikow.” ");
INSERT INTO did_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Na si Jesus, mgo katlu-an on no tu-ig to idad din to pagsood din to katondanan. Domdom to ka-otawan to iyan amoy din si Jose no anak ni Hili, ");
INSERT INTO did_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","no anak ni Matat, no anak ni Lebi, no anak ni Milki, no anak ni Hana, no anak ni Jose, ");
INSERT INTO did_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","no anak ni Matatias, no anak ni Amos, no anak ni Nahum, no anak ni Isli, no anak ni Nagai, ");
INSERT INTO did_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","no anak ni Maat, no anak ni Matatias, no anak ni Simin, no anak ni Jose, no anak ni Huda, ");
INSERT INTO did_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","no anak ni Huwanan, no anak ni Risa, no anak ni Surubabil, no anak ni Salatiyil, no anak ni Neri, ");
INSERT INTO did_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","no anak ni Milki, no anak ni Adi, no anak ni Kusam, no anak ni Ilmudam, no anak ni Ir, ");
INSERT INTO did_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","no anak ni Josue, no anak ni Eliezer, no anak ni Hurim, no anak ni Matat, no anak ni Lebi, ");
INSERT INTO did_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","no anak ni Simeon, no anak ni Huda, no anak ni Jose, no anak ni Hunan, no anak ni Iliyakim, ");
INSERT INTO did_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","no anak ni Miliya, no anak ni Maynan, no anak ni Matata, no anak ni Natan, no anak ni David, ");
INSERT INTO did_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","no anak ni Jesse, no anak ni Ubid, no anak ni Bus, no anak ni Salmun, no anak ni Nasun, ");
INSERT INTO did_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","no anak ni Aminadab, no anak ni Aram, no anak ni Arni, no anak ni Isrum, no anak ni Paris, no anak ni Huda, ");
INSERT INTO did_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","no anak ni Jacob, no anak ni Isaac, no anak ni Abraham, no anak ni Tara, no anak ni Nakur, ");
INSERT INTO did_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","no anak ni Sirug, no anak ni Ragaw, no anak ni Pilig, no anak ni Ibir, no anak ni Sala, ");
INSERT INTO did_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","no anak ni Kainan, no anak ni Arpahad, no anak ni Sim, no anak ni Noe, no anak ni Lamik, ");
INSERT INTO did_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","no anak ni Matusalin, no anak ni Enoc, no anak ni Harid, no anak ni Mahaliyil, no anak ni Kainan, ");
INSERT INTO did_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","no anak ni Inus, no anak ni Sit, no anak ni Adan, no anak to Diyus. ");
INSERT INTO did_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Na si Jesus no natogob to Ispiritu Santu likat to pagpabonyag din no nakasood to katondanan din, nighipanow on kandin likat to Hurdan no wohig no pigbonyagan kandin. Pig-alladan kandin to Ispiritu Santu ");
INSERT INTO did_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","diyà to kahanongan no banwa. Du-on dà kandin pigpakamonang sood to kap-atan no adow awos panogkadan ni Satanas si Jesus to pa-antihan dow makaboos si Jesus to kabogbogan no likat to Ispiritu Santu. No du-on pad kandin, wadà ko-on kandin to sood to kap-atan no adow aw du-on niglotoy si Jesus. ");
INSERT INTO did_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Na si Satanas no magbabalatak, nig-iling kandin diyà ki Jesus to “Na, ko ikow iyan to Anak to Diyus, ogbauyon nu so-idi mgo batu no ogkako-on no paan.” ");
INSERT INTO did_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Naka-ikagi si Jesus to “Nasulat on no pig-iling to ‘Konà no ko-onon dà to igkabuhì to otow.’” ");
INSERT INTO did_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Na pigdaa kandin ni Satanas diyà to untud. Pigpadomoo din si Jesus to mgo banwa dini to babow to kalibutan no pig-ugpa-an to tibò no mgo pigsakupan. To songo pagpilok dà, nakita-an din on tibò. ");
INSERT INTO did_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Nig-ikagi mandà si Satanas to “Aha-a nu suyà mgo banwa tibò. Nabogayan ad man to kabogbogan to pagsakup suyà tibò. Dì ogbogayan ku ikow gayod tibò aw to mgo kaboonganan no igkatapik aw kabogbogan to pagsakup suyà. ");
INSERT INTO did_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Dì iyan dà ogkahimu nu to og-ampù ka puli dini kanak, su kanak dà to ogpakabobo-ot to pagbogoy sikan no mgo kasinakupan.” ");
INSERT INTO did_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Naka-ikagi si Jesus to “Nasulat on no pig-iling to ‘Iyan dà ogka-ampu-an nu to Diyus no Magbobo-ot nu, aw kandin dà to ogkatuman nu.’” ");
INSERT INTO did_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Na piglangguy din si Jesus diyà to Hirusalim no pigtukudan to labow no simbahan, aw diyà din papukhuya kandin diyà to kinatunguyan to simbahan. Na nig-ikagi si Satanas to “Ko ikow man iyan to Anak to Diyus, na, patayab ka kun diyà to pasak dow wadà man halinan nu ");
INSERT INTO did_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","su nasulat man diyà to mgo kasulatan no pig-iling to ‘Ogsugu-on to Diyus to mgo diwata din to ogpabantayon din ikow.’ ");
INSERT INTO did_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Nasulat on gayod to ‘Mgo diwata to Diyus to ogpa-apnayon din ikow ko makalapdos ka to batu no ikow, konà ka ogka-amonu.’” ");
INSERT INTO did_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Naka-ikagi si Jesus to “Nasulat on gayod diyà to kasulatan no pig-iling to ‘Konà nu ogpanogkadan to Diyus no Magbobo-ot nu to pa-antihan.’” ");
INSERT INTO did_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Na bali no nigbungkù si Satanas to pagpanogkad din to pa-antihan diyà ki Jesus aw nigpagsuwoy to magbabalatak hantod to moydu-on pad paghutoy din mandà. ");
INSERT INTO did_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Na si Jesus, nig-ulì on kandin diyà to Galiliya no banwa no natogob to kabogbogan to Ispiritu Santu. Na nigtangkap to nawnangonon bahin ki Jesus diyà to mgo banwa no namakalongod to Galiliya. ");
INSERT INTO did_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nang-anad kandin diyà to mgo simbahan to ka-Galiliyahan no nigsayà-sayà kandan tibò ki Jesus. ");
INSERT INTO did_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Na bali on no nigdatong si Jesus diyà to Nasarit no lunsud no tinulinan din on aw andiyà gayod to simbahan du-on to adow no tigsisimbahay su tahan din man sikan. Na nigpangukdayogan si Jesus du-on to atubangan to kahimunan su ogbasa kandin to kasulatan. ");
INSERT INTO did_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Pigbogayan kandin to sinulat ni Isaias no lagsoban to Diyus no maglilikwaday aw buklada din aw batuka din no pig-iling to, ");
INSERT INTO did_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Impa-abut ad to Ispiritu Santu to Magbobo-ot su pigmatu-ud ad no pigpilì din to ogpasabut to Madoyow no Tutuwanon to mgo kasagkopan no mgo otow. Pigpa-andini a din su ogpasabukan din kanak to mgo otow no nangkapirisu, aw to mgo pisok, ogpang-ulimanon ku. Mgo nangkada-og-da-og, ogpambuligan. ");
INSERT INTO did_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ogpasabut a to kunto-on to timpu to pagbulig on to Magbobo-ot to mgo ka-otawan.” ");
INSERT INTO did_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Pagkatapus ni Jesus to pagbasa, piglukut din to nasulatan aw i-ulì diyà to tagumotong to kahimunan, aw ingkud awos ogpang-anad on su tahan man kandan ko ogpang-anad. Na to mgo otow no nangkahimun du-on to simbahan, namannongnong kandan tibò no ampan gogonokan no namantagad ko umikagi si Jesus. ");
INSERT INTO did_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","So-idi iyan to kagi ni Jesus, “Na kunto-on no adow, natuman on sikan no nasulat on no pigbasa kud iyu.” ");
INSERT INTO did_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Namakasayà-sayà tibò aw kaboong-boongi dan to kandin no paglituk to kagi no matam-is. Dì nigka-inusipay kandan to “Dow konà buwa no so-idi to anak ni Jose?” ");
INSERT INTO did_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Du-on naka-ikagi si Jesus to “Ogsudsudon now dà buwa to ita no ikagihonon no pig-iling to ‘Ikow no magtatambaa, unayà dà tambai to ikow tu-un no lawa, su to nadinogan noy no nahimu nu diyà to Kapirna-um no lunsud, oghimuhon nu gayod dini to ita no lunsud.’ ");
INSERT INTO did_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Dì konà a ogpakahimu dini su ma-intok to pagtu-u dini su tùtu-u man gayod to duma no ikagihonon ta no pig-iling to ‘To mgo lagsoban to Diyus no maglilikwaday, konà ogka-uyunan kandan to mgo kadumahan dan diyà to kandan tahan no banwa.’ ");
INSERT INTO did_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Tùtu-u iyan su ko pananglitan si Elias no maglilikwaday to Diyus natodu-on, dini to ka-Isrilihan no nigguwabung on to tatou no tu-ig aw tongà, pigkogsa-an to bontas to mgo otow. Mahan-ing no bau no buyag no mgo Isrili no nalisodan lagboy. ");
INSERT INTO did_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Dì sobu-uk dà no buyag no bau to pigpa-andiya-an ki Elias to Diyus no ogpabuligan, su nigtu-u kandin to Diyus. Dì sikan no buyag, konà no Hudiyu dì taga-Saripta dà nasì aw nasakup to Sidun no banwa. ");
INSERT INTO did_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ton katu-igan gayod ni Eliseo no maglilikwaday to Diyus, mahan-ing gayod no mgo Isrili no mgo otow no pig-ibung. Dì iyan dà na-uli-an si Naman no taga-Siriya. Konà no Hudiyu kandin dì nigtu-u man kandin to Diyus.” ");
INSERT INTO did_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Pagkadinog to ka-otawan, konad no pagkangkalangot dan su wadà kaliyagi to pig-ikagi ni Jesus no kasing-lunsud dan dà. ");
INSERT INTO did_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Dayun pigpagawang dan si Jesus du-on to kandan pig-ugpà-an no lunsud aw diyà daaha kandin to kapipilangan no untud no pigdangonan to lunsud su du-on dan to ogpa-osmadon podon si Jesus diyà to pasak. ");
INSERT INTO did_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Dì nasì on nanli-ot-li-ot kandin to kahan-ingan no ka-otawan no niglunus aw hipanow on ");
INSERT INTO did_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","padoog diyà to Kapirna-um no lunsud no nasakup gayod to Galiliya. Na to adow to tigsisimbahay, nig-andiyà si Jesus to simbahan aw pang-anad to ka-otawan. ");
INSERT INTO did_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Na du-on naboong-boongan dan kan impang-anad din su natapikan to kabogbogan to Diyus. ");
INSERT INTO did_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Na moydu-on otow du-on no pigsoodan to busow aw sa-og kandin to ");
INSERT INTO did_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ikow, Jesus no taga-Nasarit, wadà labot nu kanami. Dow iyan ing-andini nu su awos koy nu og-ubuson? Kinilaa ku ikow to matuwadong ka no otow no niglikat to Diyus.” ");
INSERT INTO did_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Na pigsapadan ni Jesus to “Pahonok kad on aw gawang kad on du-on.” Busow to nakapahibat kan otow du-on to atubangan to ka-otawan aw tinakin nagawangan kandin no wadà ka-amonu. ");
INSERT INTO did_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","To ka-otawan, pig-abut on to kaboong-boong aw ka-inusipay kandan to “Nokoy kan no impang-anad, su mabogbog su agad puli dà ogsugu-on din to busow, dì ogpakagawang on.” ");
INSERT INTO did_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Dayun du-on nigtangkap to nawnangonon bahin ki Jesus to tibò no nakalongod to Kapirna-um no lunsud. ");
INSERT INTO did_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Na kandan si Jesus, namanlabas du-on to simbahan aw iyan tu-uda dan to baoy ni Simon. Na du-on to ugangan ni Simon no buyag no nasakit no mapasù lagboy to lawa aw patambaa kandan ki Jesus. ");
INSERT INTO did_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Na du-on pigdomoan ni Jesus aw sugu-a kan sakit to ogpakagawang. Dayun na-uli-an kandin. Na nakabangun dayun to buyag aw maka-alagà on kandin to mgo bisita. ");
INSERT INTO did_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Na no mahapun on lagboy, to mgo nangkasakit no nigsingkabugtì, tibò pigdaa to kadumahan dan diyà ki Jesus aw pandampona din kandan tibò aw dayun nangka-uli-an kandan tibò. ");
INSERT INTO did_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","To busow no nigsood to mgo otow, nangkagawang aw makasa-og to “Ikow, Anak iyan to Diyus.” Dì pigsapadan ni Jesus aw wadà din tuguti kandan to og-ikagi su kinilaa dan to kandin to Imananan to Ka-otawan. ");
INSERT INTO did_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Na to kabukas-bukas on, nighipanow on si Jesus padoog diyà to kahanongan no banwa. Dì nalupug dà to kahan-ingan no otow aw pawpanganapa dan su ogpapa-uli-on dan podon si Jesus su diyà ogpa-ugpa-on dan podon kandin to banwa dan. ");
INSERT INTO did_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Dì naka-ikagi si Jesus to “Ogpakapasabut a pad to Madoyow no Tutuwanon bahin to pagsakup to Diyus diyà to duma no mgo kalunsudan su sikan to impa-andini kanak to Diyus,” ");
INSERT INTO did_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","aw katuman din to pagpasabut diyà to mgo simbahan to mgo ka-Hudiyuhan. ");
INSERT INTO did_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Na si Jesus no diyà kandin to boyboy to dagat to Ginisarit, napuunan kandin to ka-otawan. Nigpasabut kandin to kagi to Diyus no nigsakindog kandin. Dì kandin, nadasokan to ka-otawan no ogpaminog to kagi to Diyus du-on to boyboy to dagat. ");
INSERT INTO did_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Diyà din kakita-i to daduwa no bautu aw pighaw-asan to tagtu-un to bautu su nighugas to mgo pukut dan. ");
INSERT INTO did_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Na nigluwan si Jesus du-on to bautu no iyan tagtu-un si Simon aw padiyù-diyù kandin to mayopot. Dayun nig-ingkud kandin du-on no nigpang-anad to ka-otawan no kan kahan-ingan du-on dà to boyboy to dagat no ogpamaminog. ");
INSERT INTO did_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Na pagkatapus din to pagpang-anad, nig-ikagi si Jesus du-on ki Simon to “Dutun kinow on to kadaoman aw tuntuna to pukut awos makapudut kad to isdà.” ");
INSERT INTO did_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Naka-ikagi si Simon to “Nabukasan koy on, Sir. Puli koy on lagboy napagud no matuu wadà man napudut noy no isdà. Dì ikow, su insugù nud on Sir, kanak, ogtumanon kud.” ");
INSERT INTO did_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Na pagtuntun dan to pukut, mahan-ing on iyan no isdà to nasakup dan no naponù on hantod to ogkahigbit on podon to pukut to kahan-ing to isdà. ");
INSERT INTO did_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Dayun pigkamoy dan to duma dan no diyà to songo bautu awos ogpabuligon dan. Dayun pigbubuligan dan to pagbagtun likat to kadaoman aw iluwan dan du-on to bautu takas-takas to naponù on to daduwa no ka-bautu to isdà aw hantod to ogkangkaonod on podon tibò kandan. ");
INSERT INTO did_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Pagkita ni Simon Pedro to nasakup on to mahan-ing no isdà, nakaluhud kandin diyà to atubangan ni Jesus aw maka-ikagi to “Magbobo-ot, wadà labot ku ikow su kanak, makasasaà a no otow,” ");
INSERT INTO did_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","10","su to mahan-ing no isdà no nasakup, naboong-boong kandan aw si Simon, aw si Santiago aw si Juan no mgo anak ni Sibidiyu no duma ni Simon. Nig-ikagi si Jesus du-on ki Simon to “Konà ka ogkahadok. Likat kunto-on, otow to ogsakupon now, konà no isdà dà.” ");
INSERT INTO did_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Pigpadu-ung dan to bautu diyà to boyboy to dagat aw pigpang-oyowan dan tibò to mgo luwan du-on to bautu aw pamatiduma on kandan ki Jesus. ");
INSERT INTO did_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Na diyà pad kandan si Jesus to songo lunsud, sinakpan kandin to otow no pig-ibung. No pagkakita din ki Jesus, nigluhud aw pangamuyù ki Jesus no nig-iling to “Magbobo-ot, ko pagbo-ot nu to ogka-uli-an a nu, ogka-uli-an a dà man aw kalinisi a.” ");
INSERT INTO did_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Na du-on pigdampon din aw ikagi to “Ogbo-otan ku man. Na, ka-uli-i kad on aw kalinisi kad on.” Du-on na-uli-an on dayun kan otow to sakit din aw kalinisi on to lawa din. ");
INSERT INTO did_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Na pigbahog lagboy ni Jesus to wadà ogpanangonan din to na-uli-an din on kandin to sakit. Dì kagi din to “Patidow ka diyà to ogtubus ikow diyà to atubangan to Diyus aw ipa-ahà kan sakit nu no na-uli-an on. Agad-agad to insugù ni Moises, bogoy ka kandin to buhì no pagmatu-ud to pagka-uli-i nu kan ikow sakit awos matu-uhan to ka-otawan.” ");
INSERT INTO did_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Dì pinatangkap din on nasì to nawnangonon diyà to kadiyu-an bahin ki Jesus aw du-on dayun nangkahimun to kahan-ingan no otow awos ogpamaminog to impang-anad din aw ogpamatambaa kandan to mgo sakit dan. ");
INSERT INTO did_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Dì si Jesus, nighipanow on aw sood to kahanongan no banwa su diyà to og-ampù kandin to Diyus. ");
INSERT INTO did_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Na, songo adow nigpang-anad si Jesus to ka-otawan. Namakaba-ot gayod du-on to mgo mag-a-anad to tinu-uhan aw mgo Parisiyu no mangkatagon-tagonon to kandan katahanan. Agad ando-i nandà no banwa to pigmutmutan to ka-otawan no namanlikat diyà to Hirusalim aw mgo kalunsudan to prubinsiya to Galiliya aw Hudiya no namang-andu-on ki Jesus. Kandan tibò, naman-ingkud no natalibonok du-on ki Jesus. Nadugangan on si Jesus to kabogbogan to Magbobo-ot to pagpandoyow din to sakit. ");
INSERT INTO did_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Na tinakin nigdatong on mandà to pulid no otow no piglahung. Ogsood podon to namanlahung to pulid no otow su diyà dan podon to igbotang to atubangan ni Jesus. ");
INSERT INTO did_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Dì wadà nali-otan dan diyà ki Jesus su wadà pigsìsi-an to kahan-ingan no ka-otawan no nadasok no naminog ki Jesus. Dì iyan nadomdoman dan to ogpotos kandan diyà to babow to atop aw gakasi dan to atop to litos-litos ogka-oog to hibatanan to pulid no otow aw tuntuna dan to otow du-on topad ni Jesus no nalibunukan to ka-otawan. ");
INSERT INTO did_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Pagsabut ni Jesus to insalig dan du-on kandin to ogkadoyow din to pulid, nig-ikagi kandin du-on to pulid no otow to “Lagi, napasaylu on to mgo saà nu.” ");
INSERT INTO did_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","To mgo mag-a-anad to tinu-uhan aw mgo Parisiyu, nigka-inusipay kandan to “Nokoy man no kandin niglangub to ogpa-inahan din podon to Diyus, su sikan no otow nigpagsokod podon kandin to Diyus su kunon kun kandin to ogpakapasaylu to saà to mgo otow. Dì sobu-uk dà to ogpakapasaylu to saà no kandin, Diyus dà man.” ");
INSERT INTO did_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Dì tahan on nama-anan ni Jesus to nadomdoman dan aw du-on in-ikagi din to “Nokoy man no pig-iling now to domdom now. ");
INSERT INTO did_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nokoy to mahawoy to og-ikagihon diyà to napulid no otow, to ‘Napasaylu to saà nu,’ dow ‘Bangun kad on aw hipanow kad on.’ ");
INSERT INTO did_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Moydu-on ig-ikagi ku to pulid awos kow mataga tibò to bahin to mgo saà to otow, kanak no Tumutubus to Ka-otawan, nabogayan a to kabogbogan to ogpakapasaylu a to saà dini to babow to kalibutan.” Na pig-ikagihan ni Jesus to pulid no otow to “Na ikow no pulid, bangun kad on aw lukuta to hikam nu aw ulì kad on.” ");
INSERT INTO did_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Dayun nigbangun aw lukuta din to hikam din aw ulì diyà to kandin no nigsayà-sayà to Diyus. ");
INSERT INTO did_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Du-on pig-abut tibò to kaboong-boong aw sayà-saya-a dan to Diyus no naman-iling to “Nakita-an tad on bali to kaboonganan kunto-on no adow.” ");
INSERT INTO did_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Na namanlabas kandan si Jesus to baoy aw laboy. Nakabayà si Jesus to sukutanan to buhis. Nakita-an din to songo magsusukut to buhis no nig-ingkud du-on no pighingadanan ki Lebi. Pig-ikagihan ni Jesus to “Lagi, duma kad on kanak.” ");
INSERT INTO did_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Dayun pigpang-oyowan din to pig-atubang din tibò aw patiduma kandin ki Jesus. ");
INSERT INTO did_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Na si Lebi, binana-an din kandan si Jesus diyà to baoy din. Iyan mgo dongan gayod du-on kan no pagko-onan to mahan-ing no ka-otawan. Mahan-ing gayod du-on no mgo duma ni Lebi no magsusukut to buhis no wadà ka-uyuni to mgo otow no nigdaa to tinu-uhan to mgo Hudiyu. Mahan-ing gayod to duma du-on no wadà tu-u to kandan katahanan. ");
INSERT INTO did_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Dì to mgo mag-a-anad to tinu-uhan to mgo Hudiyu aw mgo Parisiyu no matagon-tagonon gayod to kandan katahanan, pigpandiyampà dan to mgo pangabaga ni Jesus. Naman-ikagi kandan to “Nokoy man no kanunoy kow ogpagdongan to pagko-on aw pag-inom kow to mgo magsusukut to buhis aw duma pad no mgo otow no wadà tu-u to katahanan ta no wadà ka-uyuni to mgo punu-an ta.” ");
INSERT INTO did_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Na impananglitan ni Jesus no pig-iling to “Na to otow no konà og-abin to sakit din, konà ogpagawang to ogtambaa to sakit din. Dì to otow no og-abinon din to sakit din, ogpagawang to ogtambaa to sakit din. ");
INSERT INTO did_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","To ing-andini ku su ogbulig a to otow no ogpagawang to saà. Dì to otow no konà ogpagawang to saà, konà ku ogbuligan.” ");
INSERT INTO did_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Na to sunù no indiyampà dan, bahin to tig-ampù aw katahanan dan no pu-asa. Namang-ikagi kandan to “Mgo sakup ni Juan no Magbobonyagay aw mgo Parisiyu, ogtagonan dan to katahanan ta bahin to tig-ampù aw tigpu-asa. Dì ikow no mgo sakup, konà man su agad nokoy no adawa, ogko-on aw inom.” ");
INSERT INTO did_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Impananglitan ni Jesus no nig-iling to “Na to mgo bumaba-ot to pagsauhan, ogpako-onon pad ko du-on pad to baoy to bana no bayà hitu-un. Dì ko mali-usan on kandan, wadad ogpakako-on su naponga on man to pagsauhan dan. ");
INSERT INTO did_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Moydu-on adow no ogkagotò to paghipanow to bana no bayà pad hitu-un, kayan ogpamampu-asa to mgo bumaba-ot.” ");
INSERT INTO did_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Na impananglitan mandà ni Jesus bahin to bayà no impang-anad din aw to tahan no impang-anad to mgo Parisiyu no wadà hiduma. Kagi din to “Konà ta oghigbiton to bayà no kabò awos puduton to tatapakay aw tapaki ta to tahan no kabò su to bayà no kabò, ogkado-ot, aw hognà pad konà oghidaag kan igtapak aw kan ogtapakan.” ");
INSERT INTO did_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Na impananglitan mandà ni Jesus bahin to bayà no impang-anad din. Kagi din to “Konà ta ogpagsambuon to bayà no inomon du-on to tahan no inomon no pingaa, su ko ogpagsambuon ta to bayà du-on to tahan, iyan ogkabauyan to mado-ot. Ogka-uwakan puli tibò, kan bayà no inomon aw sikan tahan no inomon. ");
INSERT INTO did_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Konà ogpagsambuon to bayà aw tahan no inomon su pagbauy, kan tibò mado-ot aw puli man ogka-uwakan to bayà no ingkasambuu. ");
INSERT INTO did_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Wadà otow no og-anti pad to bayà no inomon ko moydu-on pad pingaa no inomon su og-ikagi man to ‘Oyow kid to bayà su madoyow pad to tahan su napingaa on man.’” Sikan to impananglitan ni Jesus bahin to mgo impang-anad no tahan aw bayà no konà oghidaag. ");
INSERT INTO did_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Na songo adow no konà no tigtatalabahu, kandan si Jesus namanhipanow no nigtaà to humayan aw to mgo sakup din, kanunoy nalisig namangkotu to bogas to humoy aw kulipisa dan aw kotip-kotipa dan. ");
INSERT INTO did_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Dì moydu-on mgo Parisiyu no namakakita kandan aw maka-ikagi to “Nokoy man no pighimu now sikan no konà kow man podon ogtugutan to tinu-uhan ta bahin to adow no konà no tigtatalabahu.” ");
INSERT INTO did_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Nakatabak si Jesus to “Wadà now buwa kabasahi bahin to nahimu ni David no paglotoy dan no namakalaguy kandan no nahadok to mgo kablang dan. ");
INSERT INTO did_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Puli on namakasood kandan diyà to abutanan to Diyus no konà dan podon no soodanan aw puli dan on kangkako-on kan ko-onon no inghonat diyà to atubangan to Diyus no ing-okod podon kandan su iyan dà ogpakako-on to mgo punu-an to tinu-uhan no imbotang to Diyus no ogtubus to ka-otawan diyà to atubangan din. ");
INSERT INTO did_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Na kanak no Tumutubus to Ka-otawan, ogpakabo-ot a dà to adow gayod no konà no tigtatalabahu.” ");
INSERT INTO did_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Na to duma on no adow no konà no tigtatalabahu, nigsood si Jesus to simbahan aw pang-anad to ka-otawan. Nakaba-ot gayod to otow no pawing no nignohut to kalintu-u no boad din. ");
INSERT INTO did_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Na to mgo mag-a-anad aw mgo Parisiyu no namantagon lagboy to kandan katahanan, pigpakabantayan dan si Jesus ko manambaa to adow no konà no tigtatalabahu su awos moydu-on mapatikinan dan no igkadiklamu dan ki Jesus diyà to mgo mangkata-as dan. ");
INSERT INTO did_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Dì nama-anan dà ni Jesus dow nokoy to domdom dan. Na nig-ikagi si Jesus diyà to pawing to “Duguk ka. Sakindog ka kani.” Dayun pigtuman din to insugù kandin ni Jesus. ");
INSERT INTO did_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Na nig-ikagi si Jesus diyà to mgo Parisiyu to “Moydu-on ig-usip ku iyu. Nokoy to hustu no oghinangon ta to adow no konà no tigtatalabahu. Ando-i dapit to madoyow, ko ogtambaan ta to padihu ta no nasakit, dow sugayon ta nasì. Ando-i gayod to madoyow, ko ogbuligan ta to nasakit dow himatayan ta nasì. Nokoy to kasugu-an dini ita bahin to adow no konà no tigtatalabahu.” ");
INSERT INTO did_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Nigpang-ahà-ahà si Jesus to mgo otow no nahimun du-on aw ikagi diyà to pawing to “Kotongad to boad nu.” Na-uli-an dayun to boad din no kotongon din on. ");
INSERT INTO did_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Dì du-on konad no pagkangkalangoti nasì to mgo Parisiyu aw kasusukun kandan dow og-amonuhon dan si Jesus. ");
INSERT INTO did_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Na, nighipanow on si Jesus aw gomow to untud no awos og-ampù kandin to Diyus. Pinuna-us din to songo kadukiloman to pag-ampù to Diyus. ");
INSERT INTO did_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Na pagkabukasi on, pighimun ni Jesus tibò to mgo sakup din aw pili-a din to sampuù tag duwa aw himuha din kandan no tumutubus din diyà to ka-otawan. ");
INSERT INTO did_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Na sikan mgo tumutubus din, si Simon no pighingadanan din gayod ki Pedro, aw si Andres no su-un din, aw si Santiago aw si Juan aw si Felipe aw si Bartolome ");
INSERT INTO did_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","aw si Mateo aw si Tomas aw si Santiago no anak ni Alpiyu, aw si Simon no piggoan dan ki Silutis no iyan nalitukan to mapatubuk-tubukon to bandila, ");
INSERT INTO did_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","aw si Judas no anak ni Santiago, aw si Judas Iskariyuti no ogbaligyà ki Jesus diyà to mgo kablang din. ");
INSERT INTO did_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Na nigpamatugpù on kandan si Jesus aw pagtampu kandan to kahan-ingan du-on to patag no duma no mgo sakup din aw duma pad gayod no mgo otow no nigtagad-tagad kandan ki Jesus no kandan, namanlikat to Hudiya aw Hirusalim aw kabaybayan to Tiru aw Sidun no ogpaminog kandin aw ogpamatambaa to sakit dan. ");
INSERT INTO did_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Nangka-uli-an din gayod kan mgo pigpansoodan to busow. ");
INSERT INTO did_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kan kahan-ingan, puli on namantudì kandin su ko matudì dan si Jesus, oglogwa-an kandin to kabogbogan no ogpakadoyow kandan to sakit dan tibò. ");
INSERT INTO did_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Na nigpang-anad si Jesus to mgo sakup din no ogkadinog dà gayod to kahan-ingan. Nig-ikagi kandin to, “Iyu no nawada-an to mgo kapookanan, ogkaliyag kow nasì su ogpakasood kow to pigsakupan to Diyus.” ");
INSERT INTO did_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Iyu no nanlotoy kunto-on, ogkaliyag kow su oghantayon kow to mahudi no adow. “Iyu no nigsinogow kunto-on, ogkaliyag kow su ogtukhow kow to mahudi no adow. ");
INSERT INTO did_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Iyu no ogkablangon kunto-on to mgo otow aw pagawangon kow aw ina-inaha to ngadan now su nigpasakup kow man kanak no Tumutubus to Ka-otawan, kaliyagi now nasì. ");
INSERT INTO did_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Kandà no timpu, ogtukhow kow aw og-inugsayow to pagkaliyag su dakoo to igbaos iyu diyà to langit agad ma-uwang-uwangan kow on kunto-on, su angod dà man to pighimu to ka-aw-apu-an dan diyà to mgo maglilikwaday to Diyus natodu-on aw madoyow to igbaos kandan to Diyus. ");
INSERT INTO did_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Iyu no mgo datù, aboy kow su wadà og-abut iyu to mahudi no adow su natuman on to iyu no napilì no tukhawanan dini to babow to pasak. ");
INSERT INTO did_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Iyu no nahantoy on kunto-on, aboy kow su ogkabatì now to lotoy to mahudi no adow. Iyu no ogngingisi kunto-on dini to babow to pasak, aboy kow su ogpamakasinogow kow aw og-oog kow to mahudi no adow. ");
INSERT INTO did_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Aboy kow on ko puli kow dà masayà to mgo ka-otawan, su to ka-aw-apu-an now, puli dà man namansayà-sayà gayod kandan to mgo lagsoban no konà no tùtu-u natodu-on. ");
INSERT INTO did_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Dì iyu no ogpamaminog kanak, ognangonan ku iyu no oglogonan now nasì to mgo kablang now. Ko ogkablangon kow to mgo otow, ogpapanalanginan now nasì kandan no ogkablang iyu. ");
INSERT INTO did_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","To otow no ogtungayow iyu, konà now ogbaosan. Dì ogpapanalanginan now nasì kandan to Diyus. Ampu-i now nasì diyà to Diyus to otow no og-uwang-uwang iyu. ");
INSERT INTO did_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ko ogdagpangon kow to dibauy, ipalibang now mandà to dibauy. To ogpudut to iyu no agad ilisan now no kabò, ogtugutan now gayod to ogpudut agad iyanon now no kabò. ");
INSERT INTO did_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Agad intaa no ogpangamuyù iyu, bogayi now. To ogpudut puli to iyu no katinguban, agad man konà now on mahawì. ");
INSERT INTO did_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ko moydu-on igpatuman to duma du-on iyu, sikan, ogkatuman now gayod diyà kandin. ");
INSERT INTO did_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Na to mgo kablang now, ogka-atan now dà gayod su ko iyan dà ogkalogonan now kan oglogon iyu, wadà man igka-uyun iyu to Diyus. Mgo otow dini to babow to kalibutan, agad kan wadà tahud diyà to Diyus, oglogon kandan to kapadihu dan no otow no oglogon gayod kandan. ");
INSERT INTO did_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ko iyan dà ogdowdoyawan now to ogbaos iyu, wadà man igka-uyun to Diyus su agad mgo otow no wadà tahud to Diyus, ogdowdoyawan dan dà gayod to kapadihu dan no kan ogbaos kandan. ");
INSERT INTO did_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ko iyan dà ogpabooson now to otow no ogka-imanan now to ogpakabaos iyu, wadà igka-uyun to Diyus. Agad otow no wadà tahud diyà to Diyus, kandin ogpaboos ko ika-ulì dà ikatibò. ");
INSERT INTO did_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Iyu, ogkalogonan now to mgo kablang now. Ogdowdoyawan now aw paboos no agad konad ogpaka-untuu su dakoo to igkabaos iyu aw ogkatu-uhan to iyu to anak to Diyus no Kinalabawan su makawka-aton kandin diyà to mgo otow, agad logodon aw konà no mapinasalamaton. ");
INSERT INTO did_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Makawka-aton kow su makawka-aton gayod to Amoy now. ");
INSERT INTO did_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Konà kow ogpambo-ot-bo-ot to duma su awos konà kow mabo-otan to Diyus. Konà now oghimuhan to saà to duma now awos konà kow gayod mahimuhan to Diyus to saà. Dì ogpasayluhon now nasì to duma now awos mapasaylu kow to Diyus. ");
INSERT INTO did_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ogbogoy kow to duma aw ogpakadawat kow to wadà ogka-oogan tibò agad dasokon pad aw isangkaa, dì og-awas dà. Su sikan kotob to igkabogoy now, sikan dà to ogka-ontopan to ogkadawat now gayod.” ");
INSERT INTO did_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Na nig-aboy si Jesus to pagpang-anad din bahin to paghimu to saà to duma no impananglitan din. Kagi din to “Dow ogpakahindù to pisok to aag pisok? Madaduwa on kandan no aag pisok, tibò on ogpamakatuklabù diyà to lugì. ");
INSERT INTO did_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Na to sakup gayod, konà kandin ogpakapalabow to nigsakup kandin. Dì ko ma-anad on lagboy to sakup, iyan on ogka-angodan din to nig-anad kandin. ");
INSERT INTO did_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Nokoy man no og-aha-on now to puling to duma now no wadà now nasì bati-a to batang du-on to iyu no mata. ");
INSERT INTO did_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Iyu no mangkapakunon-kunonon no mgo otow, nokoy man no nig-iling kow to ‘Su-un, ipakuhit nu kanak to puling nu.’ Matuu kan iyu no mata, moydu-on man batang gayod. Tugdow oggawangon now pad to batang diyà to iyu no mata, kayan ogpakakita kow to pagkuhit to puling to mata to duma now. ");
INSERT INTO did_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Na, wadà kayu no madoyow no ogbogas to mado-ot. Wadà gayod kayu no mado-ot no ogbogas to madoyow. ");
INSERT INTO did_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Agad nokoy no kayu, sikan bogas din to ogkakilahan ta dow nokoy kayuha, agad madoyow dow mado-ot. Tungow-tungow no bogas, wadà likat to kadudugihan. Bugkà gayod, wadà likat to sagoy. ");
INSERT INTO did_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","To otow no madoyow to ginhawahan, og-agad man to madoyow gayod to ogka-ikagi din. To otow no mado-ot to ginhawahan, og-agad man to mado-ot gayod to ogka-ikagi din su agad nokoy no ogpakasood to ginhawahan din, og-agad to sikan iyan to oglabas no kagi no ogkalituk din. ");
INSERT INTO did_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Nokoy man no pighingadanan a now to ‘Magbobo-ot, Magbobo-ot,’ dì konà now man ogtumanon to igsugù ku iyu. ");
INSERT INTO did_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","To otow no ogduguk kanak aw paminogi to kagi ku aw tumana din, ");
INSERT INTO did_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","iyan ogka-angodan din to ogtugdok to baoy. Ogdaomon din to kali kotob no iyan ogkapanggadan to batu su du-on din on ogpa-ukdangan to baoy. Ko ogsigoy to wohig to mabogbog aw kasaplangi to baoy, konà ogkapood to baoy su pigdigon man to nigtugdok. ");
INSERT INTO did_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Dì to nakadinog to kanak kagi dì wadà din tumana, iyan ogka-angodan din to otow no ogtugdok to baoy no konà no madigon to napa-ukdangan din su ko masaplangan to sigoy, ogkapood dayun aw wadà ogka-angod-angodan to pagkawagkas.” ");
INSERT INTO did_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Na pagkatapus ni Jesus to pagpang-anad to ka-otawan, nig-andiyà kandin to Kapirna-um no lunsud. ");
INSERT INTO did_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Moydu-on kapitan to sundau no taga-Ruma no imbotang du-on kan no lun-sud. Moydu-on sugu-onon din no pigtagaman din on lagboy no nasakit no matigdà. ");
INSERT INTO did_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Pagkadinog din to nawnangonon bahin ki Jesus, igpadokat din podon si Jesus to punu-an to tinu-uhan to mgo Hudiyu no gustu din podon to pigbatì to sugu-onon din, ma-uli-an. ");
INSERT INTO did_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Na pagdatong to mgo punu-an diyà ki Jesus, pig-pangamuyu-an dan lagboy si Jesus. Nig-ikagi kandan to “Sikan kapitan to sundau no taga-Ruma no imbotang dini, ogpa-andiya-on ka din podon su sugu-onon din no natagaman din lagboy, nasakit no matigdà. Igpadokat ka din su awos ma-uli-an kan sugu-onon din to sakit. Madoyow iyan podon ko ogbuligan nu kandin ");
INSERT INTO did_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","su sikan no kapitan, matinabangon ita no mgo Hudiyu su pigbogayan koy din to simbahan kani to kanami no lunsud.” ");
INSERT INTO did_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Dayun nigduma si Jesus kandan. No madani on kandan, pinasungun to kapitan to mgo kadumahan din no awos igpasuhung din si Jesus no igpa-iling to “Magbobo-ot, agad on. Aya kad ogpa-abut su konà a no litos no og-abutan nu. ");
INSERT INTO did_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Kaling man konà a oglangub to ogsungun ikow. Agad on. Konà kad on ogpatidow dini kanak dì igatang puli nud on oglitukon to kagi nu aw ogpaka-ulì to sugu-onon ku. ");
INSERT INTO did_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nama-anan ku dà to ogkahimu nu sikan su angod kanak no nasakup ad to mata-as ku, aw mata-as ku, imbotang a din no kapitan to mgo sundau. Ko ogsugu-on kud to songo sundau ku to ‘Andiyà kad on,’ ogkatuman din man. Ko igsugù kud to duma no sundau to ‘Andini kad on,’ ogkatuman din man gayod. Ko ogsugu-on kud to sugu-onon ku to ‘Hinanga so-i,’ ogkatuman din man gayod.” ");
INSERT INTO did_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Pagkadinog ni Jesus to kagi no igpanangon to kapitan to mgo sundau no taga-Ruma, naboong-boong kandin. Na to mgo ka-otawan du-on, pig-ikagihan ni Jesus to “Ognangonan ku iyu to dini to ka-Isrilihan, wadà a aligbat makakita to pagtagon no angod to pagtagon sikan no otow no konà man podon no Isrili kandin.” ");
INSERT INTO did_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Na pag-ulì to mgo duma to kapitan to sundau, na-uli-an on to sugu-onon din. ");
INSERT INTO did_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Na nig-andiyà kandan si Jesus diyà to lunsud no pighingadanan to Nain no nadumahan kanunoy to kahan-ingan. ");
INSERT INTO did_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","No madani on to li-otan to lunsud, impaghisungun dan to kahan-ingan no lumolobong to batà no lukos no anak to bau no buyag no sobu-ukon. ");
INSERT INTO did_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Pagkakita ni Jesus to buyag no bau, pigka-atan din aw ikagihi din to “Pahagtong kad to ogsinogow.” ");
INSERT INTO did_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Du-on pigdampà dayun ni Jesus to lungun aw pamansigkon kan mgo lumolobong. Kagi ni Jesus to “Utù, bumangun kad on.” ");
INSERT INTO did_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Na dayun nakabangun to patoy aw makapagbaaw-baaw on. Na pigpa-ulì ni Jesus to batà diyà to inoy din su pigbuhoy on man. ");
INSERT INTO did_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Dayun nangkaboong-boong kandan lagboy aw mamakasayà-sayà kandan to Diyus no namaka-iling to “Bali on niglogwà dini ita to maglilikwaday to Diyus no mabogbog,” aw maka-ikagi gayod to “Nakita-an tad on to hinimu to Diyus ta kunto-on no adow.” ");
INSERT INTO did_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Tinangkapan to nawnangonon bahin to nahimu ni Jesus diyà to prubinsiya to Hudiya aw banwa no namakadani du-on. ");
INSERT INTO did_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Na og-uli-on tad to tutuwanon bahin ki Juan no Magbobonyagay no diyà pad to pirisuhan. Pignangonan si Juan to mgo sakup din bahin to nangkahimu ni Jesus no mabogbog. ");
INSERT INTO did_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Pigtawag ni Juan to daduwa no sakup din aw pa-andiya-a din kandan diyà ki Jesus no Magbobo-ot su impa-usip ni Juan kandan ki Jesus no impa-iling to “Dow ikow iyan no Imananan to Ka-otawan dow moydu-on pad duma no ogka-iman pad to ka-otawan no oglogwà.” ");
INSERT INTO did_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Pagdatong dan nig-ikagi dayun kandan to “Pigpa-andini koy ni Juan no Magbobonyagay su igpa-usip ka din kanami dow ikow iyan to Imananan to Ka-otawan dow moydu-on pad duma no ogka-iman to ka-otawan no oglogwà.” ");
INSERT INTO did_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Na kandà no timpu mahan-ing du-on no moydu-on mgo sakit aw mgo pigpansoodan to busow. Dì nangkagawangan tibò ni Jesus, aw mgo pisok, tibò nangka-uli-an din. ");
INSERT INTO did_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kaling tinabak ni Jesus no nig-iling to “Na, pa-ulì kow on diyà ki Juan aw nangoni now kandin to nadinog now aw kinita now. Nangka-uli-an on to mgo pisok. Aw mgo pungkù, ogpamakahipanow on, aw mgo pigpan-ibung, nangkadoyow on, mgo bongoo, ogpakadinog on. Mgo nangkamatoy, pigpambuhoy on. To mgo mangkasagkop to pagkabotang, natutuwan on to Madoyow no Tutuwanon. ");
INSERT INTO did_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Na to otow no wadà ablayanan to pagtu-u din dini kanak, ogkaliyag kandin su kanunoy din ogtagadan to insahad to Diyus.” ");
INSERT INTO did_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Na pagkali-us on to sinugù ni Juan, nighutoy si Jesus to pagpanoysoy to ka-otawan bahin to katondanan ni Juan. Nig-ikagi kandin to “Nokoy to naduguk now diyà to kahanongan no banwa natodu-on. Nokoy to pig-ahà now du-on, dow kandà puli mgo kugun no ogkabaguyun no ogsabodon to kamag? Dì konà man. ");
INSERT INTO did_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Dow pig-ahà now to otow no nangabò to mahal? Dì konà man, su to otow no ogpangabò to mahal aw wadà ogboongon dan, og-ugpà diyà to ugpa-anan to datù, konà og-ugpà diyà to kahanongan. ");
INSERT INTO did_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Nokoy to pigduguk now du-on. Nokoy to napugut-pugutan no naliyagan now no nasoodan now. Dow nig-ahà kow bali to maglilikwaday to Diyus? Maglilikwaday man iyan, dì konà no maglilikwaday dà puli, ");
INSERT INTO did_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","su so-idi to nasulat on bahin ki Juan no pig-iling to ‘Na ahà kad on, su ogpa-unahan ku ikow to kanak maglilikwaday su ogpahina-aton kud on kandin to igbayà nu.’ ");
INSERT INTO did_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Na ognangonan ku iyu to dini to babow to pasak, wadà otow no oglabow pad ki Juan to katondanan. Mangkuwan to mahudi no adow, to kinasagkopan diyà to pigsakupan to Diyus, ogkalabawan pad man si Juan su ogka-usab to pigsakupan.” ");
INSERT INTO did_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Na to mgo ka-otawan puli aw mgo magsusukut to buhis no pigpambonyagan ni Juan, no pagkadinog dan to ingka-ikagi ni Jesus bahin to katondanan ni Juan, nangkaliyag su namakamatu-ud on kandan to katuwadongan to Diyus su pigtuman dan to pagbo-ot din no pagpabonyag dan on ki Juan. ");
INSERT INTO did_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Dì to mgo mag-a-anad to tinu-uhan aw mgo Parisiyu no matagon-tagonon gayod to kandan katahanan, wadà kandan kaliyag su puli dan on piglingawan to pagbo-ot to Diyus bahin kandan su wadà pabonyag kandan ki Juan. ");
INSERT INTO did_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Na og-uli-on tad to pagpanoysoy ni Jesus bahin ki Juan aw mgo otow no pigpangudlinan din. Nig-ikagi kandin to “Nokoy to ogka-angodan to mgo otow kunto-on no kadongan ta. ");
INSERT INTO did_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Iyan ogka-angodan dan to mgo batà no nangkahimun diyà to dadaga-anan no ogpamansunud-sunud to pagsauhan no oghinulindogay to ‘Nokoy man no wadà kow sayow no kanami, niglisag koy man iyu.’ Mgo kadongan ta gayod, iyan ogka-angodan dan to mgo batà no ogpamansunud-sunud to ogpaman-oog to namatoy no og-iling to ‘Nokoy man no wadà kow baos to pagdaugmatoy noy su kanami, pigdaugmatayan noy on man iyu.’ Kan mgo batà, wadà ingkangkaliyag dan. Na iyu gayod, iyan ogka-angodan now kan mgo batà to iyu no pagdawat aw pagsabut now to pagpang-anad iyu. ");
INSERT INTO did_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Si Juan no Magbobonyagay, wadà pagba-ot kandin to mgo pagko-onan aw mgo pag-inoman, aw puli now on botang-botangi kandin no pigsoodan kun to busow. ");
INSERT INTO did_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Dì kanak no Tumutubus to Ka-otawan, ogpagba-ot a, dì pighimu a now nasì no ma-omot no ogko-on aw minahingow, aw ogdinuguk-duguk a to mgo magsusukut to buhis aw duma no wadà tu-u to katahanan ta. Wadà iyan ingkangkaliyag now. ");
INSERT INTO did_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Dì to ka-ugsoban to Diyus, ogkakilaa ta su pigpatuman din dà to pagbo-ot din to nigsingkabugtì no mgo otow, agad mapawpa-awayon ubag to og-ugpà aw matiduguk gayod no otow.” ");
INSERT INTO did_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Na si Simon no songo Parisiyu no matagon-tagonon to kandan katahanan, pigbana-an din kandan si Jesus. ");
INSERT INTO did_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Na du-on sikan no lunsud moydu-on buyag no mado-ot. No pagkadinog din to du-on si Jesus kan no baoy, niglambag on kandin no nigdaa to lamita no nahimu no likat to batu no maputì no natagu-an to hihinaki no ighidhid no pahomut. ");
INSERT INTO did_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","No pagdatong din, nakita-an din kandan no namanluhud no namango-on su tahan dan. Kandin, nigduguk aw luhud diyà dapit to talikudan ni Jesus aw nig-sinogow kandin aw dukduki din to kobong ni Jesus no awos tagdu-an to luhà. Pinahidan to bubuu din to kobong ni Jesus aw puuga to pahomut to kobong ni Jesus aw hadoki din to kobong. ");
INSERT INTO did_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Na pagkakita to Parisiyu no otow no nigbanà ki Jesus, iniling din to sood to ginhawa din to “Ko lagsoban kandin iyan to Diyus, nama-anan din on podon dow nokoy sikan no buyaga no nigtudì kandin su sikan, mado-ot man no buyag.” ");
INSERT INTO did_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Dì nama-anan dà ni Jesus dow nokoy to domdom ni Simon aw ikagihi din to “Simon, moydu-on ig-ikagi ku ikow.” Nakatabak si Simon to “Na, nokoy Sir.” ");
INSERT INTO did_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Kagi ni Jesus to “Na moydu-on otow no nigpaboos to sapì din diyà to daduwa no ka-otow. To sobu-uk, nigboos to lima no gatus, to sobu-uk, kalim-an dà. ");
INSERT INTO did_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Dì wadà dan bayadi. Dì napasaylu dà man. Na, ando-i dapit to dakoo to pagkalogon diyà to otow no nigpaboos kandan to sapì, sikan ma-aslag dow kan ma-intok.” ");
INSERT INTO did_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Nakatabak si Simon to “Sikan sobu-uk buwa no dakoo to napudut dì napasaylu din dà.” Kagi ni Jesus to “Hustu to tabak nu.” ");
INSERT INTO did_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Dayun niglingì si Jesus sikan buyag diyà to talikudan din no tinakin pig-ikagihan din si Simon to “Lagi, ahà kad man so-idi buyag no nigluhud dini to talikudan ku. Ikow, pigpaponhik a nu to baoy nu dì wadà a nu hugasi to kobong ku agad-agad to katahanan ta ko moydu-on pigpaponhik ta no bisita, oghugasan to kobong. Dì kandin, pighugasan a din to luhà din aw pahidi din dà to bubuu to kobong ku no pigpatagdu-an to luhà. ");
INSERT INTO did_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ikow, wadà a nu pangamustaha to hadok. Dì kandin, likat on to pagdatong ku, pighinadokan din to kobong ku. ");
INSERT INTO did_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ikow, wadà nu hinakihi to uu ku. Dì kandin, pigpuug din to kobong ku to pahomut. ");
INSERT INTO did_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kaling man, ognangonan ku ikow to agaw dakoo to paglogon din kanak su napasaylu dà to saà din, agad mahan-ing. Dì to otow no ma-intok dà to napasaylu, ma-intok dà gayod to paglogon din kanak.” ");
INSERT INTO did_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Na pig-ikagihan ni Jesus to buyag to “Na, napongahan on to pagpasaylu to saà nu.” ");
INSERT INTO did_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Na to mgo dongan din no nigko-on, namaka-inusipay to “Intawa man buwa so-idi no otow no oglangub man ogpasaylu to saà to otow.” ");
INSERT INTO did_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Dì pig-ikagihan ni Jesus to buyag to “Nalipwasan kad on to saà nu su nigtu-u ka man lagboy kanak. Na, madumahan kad to kalinaw no og-ulì diyà ikow.” ");
INSERT INTO did_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Pagkaugoy-lugoy, si Jesus aw sikan sampuù tag duwa no pangabaga din, namanlibod-libod kandan to kalunsudan to Galiliya aw mgo kasityuhan no namanoysoy kandan to ka-otawan to Madoyow no Tutuwanon bahin to pagsakup to Diyus. ");
INSERT INTO did_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Nadumahan kandin to mgo buyag no pigpanggawangan din to busow aw sakit. Kandan si Maria no taga-Magdala no pigpanggawangan din on to pitu no busow, ");
INSERT INTO did_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","aw si Juana no asawa ni Kusa no pighimu ni Harì Hirudis no magbobo-ot to mgo sood to baoy din, aw si Susana, aw mahan-ing pad no duma no mgo buyag no nig-alagà ki Jesus aw mgo pangabaga din to tu-un dan no sapì. ");
INSERT INTO did_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Na nahimunan kandin to mgo otow no namanlikat to mgo kalunsudan. Pagkahimun dan, nigpang-anad si Jesus no impabayà to pananglitan. ");
INSERT INTO did_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Nig-iling kandin to “Na, ogtutuwanan kow to otow no nig-odok to humoy. Pagsawod din, moydu-on binhì no nigdo-og diyà to daan no nagi-okan to mgo otow. Nigpatipadpad to manuk-manuk aw pantubug-tubuga. ");
INSERT INTO did_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Moydu-on binhì gayod no nigdo-og diyà to pasak no batuhon. Nigtulin dà kan niggitì diyà to batuhon dì oglanos dà man su wadà ogkaduhugan to dalid. ");
INSERT INTO did_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Moydu-on binhi no nigdo-og diyà to pasak no dalidon no kan dalid, dugihon. Nigkadodongan kan dugi aw kan tanom no hantod to piglinop on to tanom aw lahag su nasakbut man. ");
INSERT INTO did_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Moydu-on binhi no nigdo-og diyà to madoyow no pasak aw sikan no binhì, nig-abut to madoyow no niggatus.” No nigpang-anad si Jesus nig-iling to “Na, agad intawa no nakadinog, pangindaagan to kalitukan to mgo pananglitan ku.” ");
INSERT INTO did_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Na to mgo sakup ni Jesus, nig-usip kandan dow nokoy to kalitukan to pig-ikagi din no pananglitan. ");
INSERT INTO did_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Nig-ikagi kandin to “Ogpapanaysayan kow to Diyus kanak bahin to pagsakup din. Dì duma no mgo otow no wadà labot to pagsakup to Diyus no nabigtoan on, igpananglitan ku awos kandan, agad mang-ahà-ahà, dì wadà ogkakita-an dan. Agad duminog kandan, dì konà ogpakadaag. ");
INSERT INTO did_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Na so-idi to kalitukan to pananglitan ku. Tugdow, to binhì no in-odok, iyan ogka-angodan to kagi to Diyus. ");
INSERT INTO did_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","To daan no nado-ogan to binhì, iyan ogka-angodan to mgo otow no ogdinog to kagi to Diyus. Dì ogdatong si Satanas aw sakmita din dà to kagi to Diyus du-on to ginhawahan dan awos konà ogpakatu-u aw konà ogkalipwasan kandan. ");
INSERT INTO did_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","To batuhon no pasak no nado-ogan to binhì, iyan ogka-angodan to otow no ogkaliyag to ogpaminog to kagi to Diyus aw dawata. Dì wadà lagboy makaduhug to dalid su wadà man lagboy pasooda to ginhawahan dan to kagi to Diyus. Ko og-abut on to kalisod, og-oyowan dan on to pagtu-u. ");
INSERT INTO did_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Na to pasak no moy mgo dalid no dugihon no nado-ogan to binhì, iyan na-angodan to otow no ogpaminog to kagi to Diyus. Dì no og-ugpà kandan no oglinopon to kalisod aw pagkaliyag to kadatù aw ogminaliyag puli, konà ogkaduyhat to bogas. ");
INSERT INTO did_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Dì to pasak no madoyow no nado-ogan to binhì, iyan na-angodan to mgo otow no ogpaminog to kagi to Diyus aw tagoni lagboy no matino-od kandan no wadà ogkasukinoban dan no saà no konà dan ogbungku-an to pagtu-u di og-abut nasì to dakoo no bogas.” ");
INSERT INTO did_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Na impananglitan mandà ni Jesus no nig-iling to “Ko ogpadokotan ta to ilawan, dow ogsangkuban ta to lata, dow konà. Dow igbotang ta du-on to saom to ingkudanan, dow konà. Diyà ta iyan igbotang to kabakna-an su awos matang-awan to nasood du-on. ");
INSERT INTO did_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Tibò to mahobong kunto-on, ogka-ukasan to mahudi no adow, aw to innangon to pagtongopan, ogkatagahan, su ogkapayagan dà su tibò man, ogkatang-awan. ");
INSERT INTO did_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Na ogpaminog kow lagboy su to otow no moydu-on pagtu-u, ogdugangan nasì to nama-anan din. Dì to otow no wadà pagtu-u dì nigsa-om to pig-moydu-on din on, ogpudutan pad nasì kandin.” ");
INSERT INTO did_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Na ta-un nigpang-anad si Jesus to ka-otawan, nigdatong to inoy din aw mgo su-un din. Dì wadà dan katutuwi si Jesus su mahan-ing no mgo otow no nadasok. ");
INSERT INTO did_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Moydu-on nignangon ki Jesus no nig-iling to “Inoy nu aw su-un nu, namandatong dì diyà pad kandan to labas. Ogpagkita kandan podon ikow.” ");
INSERT INTO did_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Dì naka-ikagi si Jesus to “To otow no ogpaminog to kagi to Diyus aw tumana din, sikan on to angay inoy ku aw su-un ku.” ");
INSERT INTO did_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Na songo adow mandà namanluwan kandan si Jesus to bautu aw ikagi kandin to “Ogtalipag kid to dagat.” Dayun namanlikat kandan. ");
INSERT INTO did_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","No paglayag dan, nalipodong si Jesus. Na pig-abut to sakayan to kamag no mabogbog no nigkumus du-on to sakayan. Magabubungan to baod no ogkalukut-lukut aw katinagu-i to sakayan no kandan, kamuwahanan dan on podon sikan. ");
INSERT INTO did_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Pigpukow si Jesus to mgo sakup din aw ikagihi to “Sir, kamuwahanan tad on so-idi no nig-abut ita.” Du-on nakagimata si Jesus aw sapadi din to kamag aw baod no ogkalukut-lukut no magabubungan. Dayun nighagtong to kamag aw ampan pad pangidù-kidù to dagat. ");
INSERT INTO did_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Na du-on naka-ikagi si Jesus to “Wadà kow na-an salig to Diyus no nigbantoy iyu.” Naboong-boong kandan aw kahadok aw ka-inusipay kandan to “Intawa buwa so-idi no otow su ko ogsugu-an din to kamag aw dagat, ogpakatuman dà.” ");
INSERT INTO did_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Na dayun nigdatong kandan si Jesus diyà dihipag to dagat no banwa no pighingadanan to Gidasa no diyà longod to Galiliya. ");
INSERT INTO did_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Kandan si Jesus no paghaw-as dan to pigsakayan dan no bautu, pigsungun kandan to songo taga-lunsud dà no pigsoodan to mahan-ing no mgo busow. No naugoy on to pagwawadà to kabò aw wadà baoy no pigtingonan din to pag-ugpà. Dì diyà dà kanunoy og-ugpà to lobonganan. ");
INSERT INTO did_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Pagkita din ki Jesus, nigpangiyak aw tinakin to nakaluhud diyà to atubangan ni Jesus aw sa-og to “Wadà labot nu kanak, Jesus no Anak to Diyus no Kinalabawan no Katuusan. Ogpangamuyù a ikow to konà a nu ogpahadatan.” ");
INSERT INTO did_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Su pigsugù on ni Jesus to busow to ogpagawangon du-on sikan otow. Na ko ogsoodan kandin to busow, kanunoy ogbantayan kandin to duma aw hikoti kandin to sangkalì aw bakusa. Dì kanunoy dà ogkangkabingà to sangkalì aw papa-andiya-a kandin to busow to kahanongan no banwa. ");
INSERT INTO did_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Na nig-usip si Jesus to “Intawa to ngadan nu.” Nigtabak kandin to “Si Minaan to kanak ngadan,” su mahan-ing no busow no nigsood sikan no otow. ");
INSERT INTO did_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nigpangamuyù kan mgo busow to konà ogpagawangon kandan du-on to kandan banwa aw konà ogpa-andiya-on ni Jesus to banwa no kastiguhanan to saà no kadaoman no wadà kinotoban. ");
INSERT INTO did_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Na moydu-on panon to babuy no namandungaa diyà to augan aw pangamuyù to mgo busow to ogpasoodon podon kandan nasì du-on to ginhawahan to mgo babuy. Dayun pigtugutan ni Jesus. ");
INSERT INTO did_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Dayun nakagawang to mgo busow aw pamansood diyà to ginhawahan to babuy. Namanlaguy tibò to mgo babuy diyà to augan aw pamanpatidaplus diyà to dagat aw kangkaonod tibò to mgo babuy. ");
INSERT INTO did_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Pagkita to nigbantoy to babuy to nadoogan kan otow, namanlaguy kandan gayod aw inawnangonon dan diyà to lunsud dan aw mgo kahilitan. ");
INSERT INTO did_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Dayun naman-andu-on to mgo ka-otawan no awos ogpangintaga dow nokoy lagboy iyan to napugutan du-on. Pagdatong dan du-on ki Jesus, nakita-an dan kan otow no pigpanggawangan ni Jesus to busow no puli on nig-ingkud du-on to longod to kobong ni Jesus aw nangabò on kandin aw nabatuk on to domdom din. Nangkaboong-boong kandan tibò. ");
INSERT INTO did_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","To mgo otow no namakakita to napugutan, impannawnangonon dan to ka-otawan bahin kan otow no pigpansoodan to busow dì pigpanggawangan on aw ka-uli-i. ");
INSERT INTO did_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Dì to mgo taga-Gidasa, nangamuyù kandan diyà ki Jesus to ogpagawangon kandin du-on to banwa dan su inabut on tibò kandan to mgo hadok. Kaling man kandan si Jesus, namanluwan diyà to bautu awos og-ulì diyà to kandan no banwa. ");
INSERT INTO did_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Na to otow no nagawangan to busow, nigduma podon ki Jesus, dì wadà katuguti ni Jesus. Pig-ikagihan kandin ni Jesus to ");
INSERT INTO did_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ulì kad nasì diyà to banwa nu aw tutuwani to mgo kadumahan nu to pigbuligan kad on to Diyus.” Na nighipanow on sikan otow aw pannangoni din to mgo otow no taga-lunsud to pigbuligan kandin ni Jesus. ");
INSERT INTO did_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Na nig-ulì on kandan si Jesus no nigtalipag to dagat. Pagdatong dan, madoyow to pagdawat mandà kandan to ka-otawan su pigtagadan dan kandan. ");
INSERT INTO did_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Na nigduguk to otow no punu-an to simbahan no iyan ngadan din si Hairu. Nigluhud kandin diyà to atubangan ni Jesus aw pangamuyu-a din to ogpadumahon din ");
INSERT INTO did_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","su ogpatambaan din to batà din no buyag no songobu-ukon no mgo sampuù pad tag duwa to idad su ogpakamatayon on kandin. Na nigduma si Jesus no pigdumahan gayod to kahan-ingan no nadasok si Jesus. ");
INSERT INTO did_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nasunduwan kandin to buyag no moydu-on sakit no kanunoy piglabasan to langosa to sampuù on tag duwa no tu-ig to pagkadawdaa din. Agad piggastu din on to mgo igkabuhì din to pagpa-aput to magtatambaay, dì konà ogka-uli-an. ");
INSERT INTO did_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nigtudì kandin to sagyad to kabò ni Jesus. No makatudì kandin to kabò ni Jesus, dayun nigtigpok on to paglangosa. ");
INSERT INTO did_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Naka-ikagi si Jesus to “Eè, intawa to nigtudì to kabò ku.” Dì wadà naka-abin. Naka-ikagi si Pedro to “Sir, mano natalibongbongan ka man to kahan-ingan aw hidasok-dasok kid, nokoy man no og-usip ka pad to intawa to nigtudì ikow.” ");
INSERT INTO did_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Dì nakatabak si Jesus to “Konà, dì moydu-on nigtudì iyan su nigbatì a to piglogwa-an a to kabogbogan.” ");
INSERT INTO did_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Pagsabut to buyag to konà kandin ogpakalidung, nigduguk no pinidpid aw makaluhud diyà to atubangan ni Jesus aw maka-abin diyà to atubangan to kahan-ingan dow nokoy to ingkatudì din ki Jesus aw pagka-uli-i din. ");
INSERT INTO did_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Nig-ikagi si Jesus to “Laginà, na-uli-an kad on su nigsalig ka man kanak. Konà ka ogkapook-pook. Ulì kad diyà to ikow no madumahan ka to ka-at no og-ulì.” ");
INSERT INTO did_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Na og-uli-on tad to tutuwanon to otow no nigdaa to kahimunan to simbahan no si Hairu. No ta-un pad nig-i-ikagi si Jesus diyà kan no buyag no na-uli-an on, nigdatong to otow no niglikat to baoy ni Hairu no nignangon to “Nabigtawan on to batà. Nokoy man no ogpadumahon pad si Sir.” ");
INSERT INTO did_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Dì nakadinog dà si Jesus to nawnangonon aw ikagi to “Konà ka ogkapook-pook. Dì isalig nasì to ogkabuligan ka, su ogka-uli-an dà man kandin.” ");
INSERT INTO did_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Pagkasood dan on to baoy ni Hairu, iyan dà pigtugutan ni Jesus to ogpasoodon diyà to sinabong no pigkotangan to batà si Pedro aw si Juan aw si Santiago aw sikan ginikanan to batà. ");
INSERT INTO did_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Namansinogow tibò to kahan-ingan su nig-oog man. Dì nig-ikagi si Jesus to “Konà kow ogsinogow su wadà man kamatoy. Puli nalipodong.” ");
INSERT INTO did_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Dì pigngisihan kandin to kahan-ingan su nama-anan dan man no kan batà, tùtu-u on iyan no namatoy. ");
INSERT INTO did_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Dayun pigdawat ni Jesus to boad to batà aw ikagi to “Igì, bangun kad.” ");
INSERT INTO did_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nakapa-ulì dà to umagad din aw makabangun dayun. Pigpabogayan ni Jesus to batà to ko-onon. ");
INSERT INTO did_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nangkaboong-boong on to amoy aw inoy to batà. Dì binahog din to konà igpanawnangonon to napugut-pugutan. ");
INSERT INTO did_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Na pigpaduguk ni Jesus to mgo pangabaga din no sampuù tag duwa aw himuha din kandan no tumutubus din aw pamalogobi din to pagbogoy to kabogbogan to ogpakagawang to mgo sakit aw busow. ");
INSERT INTO did_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Pigpamalibod-libod din kandan to mgo kalunsudan no awos ogpamakapasabut to ka-otawan bahin to pagsakup to Diyus aw ogpamaka-ulì kandan to nangkasakit. ");
INSERT INTO did_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nig-ikagi si Jesus to “Ko oghipanow kow on, wadà ogdaahon now agad agos, dow balutan, ko-onon, sapì aw ilisan now. ");
INSERT INTO did_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Agad ando-i no baoy no og-agpotan now, pakamonang kow dà du-on hantod to oghipanow kow du-on kan no lunsud. Konà kow oghinalin to agpotan now. ");
INSERT INTO did_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ko konà ogdawat iyu, labayi now on sikan no lunsud aw padpada now to abug no ogdokot to kobong now no pagpakilaa now to kandan, wadà labot now.” ");
INSERT INTO did_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Na namanlikat on to mgo pangabaga ni Jesus aw pamanlibod-libod to kalunsudan, aw agad ando-i nigpasabut to ka-otawan to Madoyow no Tutuwanon aw mamakadoyow kandan to mgo nangkasakit. ");
INSERT INTO did_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Na si Harì Hirudis, no pagkadinog din to nawnangonon bahin to napugut-pugutan, napook-pook to kandin domdom aw kobaha su moydu-on mgo otow no nakanangon to si Juan no Magbobonyagay no pigpahimatayan din natodu-on, pigbuhoy on. ");
INSERT INTO did_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Moydu-on gayod nakanangon to si Elias no maglilikwaday natodu-on to Diyus, pigbuhoy on aw logwà on. Moydu-on gayod nakanangon no kandin to duma no maglilikwaday to Diyus natodu-on no pigbuhoy on. ");
INSERT INTO did_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Dì si Harì Hirudis, naka-ikagi to “Si Juan, pigpatampodan kud on to li-og natodu-on. Dì intawa buwa sikan no nadinogan ku no otow no nigpanghimu to mgo kaboonganan.” Ogpagkita-an din podon si Jesus. ");
INSERT INTO did_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Na og-uli-on tad to tutuwanon bahin to mgo tumutubus ni Jesus. Namang-ulì on kandan aw ipanutuwanon dan diyà ki Jesus tibò to pigpanghimu dan. Dayun nigpaduma si Jesus to mgo pangabaga din aw pagsuwoy on kandan to ka-otawan aw diyad on padoog to Bitsayda. ");
INSERT INTO did_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pagkama-an to ka-otawan to si Jesus, diyad on to kahanongan no banwa, piglupug dan dà. Pag-abut dan, pigdawat ni Jesus kandan to madoyow aw usaba din pang-anada kandan bahin to pagsakup to Diyus aw kangkadoyow to tibò no nangkasakit. ");
INSERT INTO did_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Na pagkahapun, namanduguk kan sampuù tag duwa no pangabaga din aw ikagi to “Sir, su kahanongan man kani no banwa, pahipanawad so-idi mgo otow diyà to kalunsudan aw diyà to kasityuhan awos ogpudut to ogkako-on dan aw awos makapanganap to ogkangkahibatan dan.” ");
INSERT INTO did_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Dì nig-ikagi si Jesus to “Iyu on to ogbogoy to ogkako-on dan.” Naka-ikagi kandan to “Ko konà koy nu ogpabolihon to igkalitos no igkapako-on so-idi no ka-otawan tibò, konà noy no ogkapako-on kandan, su lima dà no bu-uk to paan aw daduwa dà no bu-uk to isdà to moydu-on. Dì konà no litos to igkapako-on so-idi no kahan-ingan.” ");
INSERT INTO did_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Su to pagbilang to lukos, moydu-on mgo lima no maan no wadà bilanga to kabuyagan aw kabata-an. Dì du-on naka-ikagi si Jesus diyà to mgo pangabaga din to “Ogpama-ingkudon ta to ka-otawan no ogpabahin-bahinon to tagkalim-an kada songo bahin.” ");
INSERT INTO did_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Dayun namang-ingkud tibò. ");
INSERT INTO did_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Pigdawat ni Jesus to lima no bu-uk no paan aw daduwa no bu-uk no isdà aw tinakin langhag diyà to langit aw pasalamat kandin. Pigpikas-pikas din aw ipamaduhuu din to mgo pangabaga diyà to ka-otawan. ");
INSERT INTO did_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Namango-on tibò kandan aw kangkahantoy aw puli dan binungku-an to pagko-on. Na to nangkasamà, intagù dan diyà to sampuù tag duwa no ka-bangkow. ");
INSERT INTO did_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Na kandan aw si Jesus, nigpawpa-awoy no kandin, nig-ampù to Diyus. Dayun nig-usip si Jesus to mgo pangabaga din to “Agad-agad to atoman to mgo ka-otawan, intawa a.” ");
INSERT INTO did_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nakatabak kandan to “Moydu-on naka-ikagi to si Juan ka no Magbobonyagay. Moydu-on gayod naka-ikagi to si Elias ka. Moydu-on naka-ikagi to ikow, lagsoban ka to Diyus natodu-on no pigbuhoy on.” ");
INSERT INTO did_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Kagi ni Jesus to “Na iyu gayod, agad-agad to atoman now, intawa a man.” Nakatabak si Pedro to “Ikow, Kristu ka no imbotang ka to Diyus no Imananan to Ka-otawan.” ");
INSERT INTO did_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Dì pigbahog ni Jesus to wadà ognangonan to kandin iyan to Imananan to Ka-otawan, ");
INSERT INTO did_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","su kagi din to “Kanak no Tumutubus to Ka-otawan, monang ad ogkamatu-ud no Imananan to Ka-otawan ko mahan-ing pad no kalisodan no ogkabaya-an ku aw supaka a to mgo punu-an tibò to tinu-uhan ta aw makabayà a to kamatayon aw ogbuhayon a dà to tatou no adow.” ");
INSERT INTO did_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Na piglapuwaas ni Jesus no pag-ikagi kandan no nig-iling to “Na to agad intawa no ogpasakup dini kanak, ogka-oyowan din to kandin katahani aw adow-adow ogti-ang to kinurus din no litukan to iglingow din to kandin no natagon no maogon lagboy. ");
INSERT INTO did_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Agad intawa no ogkawada-an to kandin kinabuhì dini to babow ugpat kanak, ogkamoydu-onan dà nasì kandin to mahudi no adow. Dì agad intawa, ko ogpakatagonan din to kinabuhì din dini to kalibutan, ogkawada-an dà nasì kandin to mahudi no adow. ");
INSERT INTO did_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Agad kunto-on madatù ki tibò dini to kalibutan, dì wadà puus ta ko ita, konà ogbuhayon to mahudi no adow aw tuusa. ");
INSERT INTO did_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","To otow no konà ogmatu-ud to pagpasakup din dini kanak aw uyuni to kagi ku, kandin, konà ku ogkamatu-ud gayod no sakup ku ko dumatong a no Tumutubus to Ka-otawan no ogkadumahan to mgo katuusan noy aw Amoy ku aw mgo diwata din. ");
INSERT INTO did_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Dì ognangonan ku iyu to kunto-on moydu-on mgo otow kani no monang on ogkamatoy ko ogkasakpanan pad to pagsakup to Diyus.” ");
INSERT INTO did_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Na pagka-abuti to wau no adow, niggomow si Jesus to untud su og-ampù to Diyus aw putlunga din padumaha kandan si Pedro aw si Juan aw si Santiago. ");
INSERT INTO did_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","No pag-ampù ni Jesus, na-usab on to lawlanguhan din aw putì lagboy to kabò din aw silawa to mgo pangabaga din to pag-ahà dan. ");
INSERT INTO did_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Aw nakalogwà du-on kandan to daduwa no katuusan on no maglilikwaday to Diyus natodu-on no si Moises aw si Elias aw pagbaaw kandan du-on ki Jesus ");
INSERT INTO did_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","bahin to pagkali-us din dini to pasak no pagkamatoy din no igpatuman to Diyus kandin diyà to Hirusalim. ");
INSERT INTO did_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Agad lagboy kandan si Pedro ogkalipodong podon, dì wadà dan tuguti to paglipodong aw iyan on nakita-an dan to kaboonganan ni Jesus aw sikan daduwa no ka-otow no nigsakindog du-on to dani din. ");
INSERT INTO did_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","No imomo-ot oghipanow kan daduwa no katuusan, naka-iling si Pedro diyà ki Jesus to “Sir, madoyow su kani koy man. Dow pahimuhon koy nu to tatou no pinayag no oglogoban kow aw si Moises aw si Elias aw ikow.” Sikan, puli na-ikagi ni Pedro su kinoba man kandin aw konà no matuwadong to nalitukan. ");
INSERT INTO did_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","No malituk to kagi din, nasaungan kandan tibò to gabun. Nangkahadok kandan no tatou no pagkalatok dan to gabun. ");
INSERT INTO did_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Nakadinog kandan to kagi no nakapu-un du-on to gabun no na-iling to “So-idi to Anak ku no pigpilì kud no ogpatumanon ku to pagbo-ot ku. Ogpaminogan now kandin.” ");
INSERT INTO did_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Pagkatapus to pag-ikagi to Diyus, pigboong dan kan daduwa no ka-otow no katuusan. Iyan nandà nabitas no nakita-an dan si Jesus. Kan tatou no pangabaga din, namanpahonok kandan kandà no timpu su wadà otow no pignangonan dan to nakita-an dan du-on. ");
INSERT INTO did_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Na to sunù no adow nigpamatugpù on kandan aw si Jesus aw kasungun kandan to kahan-ingan to mgo otow. ");
INSERT INTO did_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Moydu-on songo otow no nasakitan to batà din, aw tinawag din si Jesus to ma-agbot no pagtawag. Nig-ikagi kandin to “Sir, ogpangamuyù a ikow no awos nu og-aha-on to batà ku no sobu-ukon ubag ");
INSERT INTO did_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","su lagboy pigsoodan kandin to busow aw tinakin ogpakangangang aw ogpakapangagkag aw ogbubukà to bàbà. Pigpasakitan kandin to busow aw malisod no og-alison. ");
INSERT INTO did_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Na pigpangamuyu-an ku to mgo pangabaga nu ganina to ogpagawangan ku podon, dì konà dan ogka-amuhan.” ");
INSERT INTO did_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Nig-ikagi si Jesus to “Iyu no kadongan ku no bugtì to ginhawahan, naugoy on to pagpang-anad ku iyu dì wadà kow tu-u lagboy. Amonuhon ku buwa iyu no wadà tu-u. Daaha dini kanak to batà nu.” ");
INSERT INTO did_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","No pagdaa to batà diyà ki Jesus, pigsigi inlinapdos to busow no ogpakapangagkag. Dì pigsapadan dayun ni Jesus to busow aw makagawang du-on to busow aw ka-uli-id to batà. In-ulì ni Jesus to batà diyà to amoy din no na-uli-an on to sakit no abuy. ");
INSERT INTO did_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","To kahan-ingan, nangkaboong-boongan dan tibò to kabogbogan to Diyus. Dì no naboong-boongan pad to ka-otawan to nahimu ni Jesus, nig-ikagi kandin diyà to mgo pangabaga din to ");
INSERT INTO did_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Iyu, konà now oglingawan to nanangon kud on iyu. Kanak no Tumutubus to Ka-otawan, ogdaahon a pad diyà to mgo otow no mgo bugtì.” ");
INSERT INTO did_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Dì wadà man makasabut kandan to innangon ni Jesus su mahobong man to kalitukan no awos konà dan masabutan. Wadà gayod langub to mgo pangabaga to og-usip ki Jesus bahin to kalitukan to innangon din kandan no wadà dan kasabuti. ");
INSERT INTO did_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Na to mgo pangabaga ni Jesus, nig-a-asuy-asuy kandan dow intawa dapit to oglabow kandan. ");
INSERT INTO did_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Dì pagkama-an ni Jesus dow nokoy to pigdomdom dan, pigdawat din to batà no ogpagoadan din kandan aw padaniha din kan batà. ");
INSERT INTO did_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Nig-ikagi kandin to “Na ko ogdawaton now so-idi no batà su nasakup kud, iyan ogka-angodan to ogdawat kanak. To ogdawat kanak, angod dà ogkadawat now gayod to nigpa-andini kanak. To kinasagkopan dini iyu, sikan iyan nasì to oglabow.” ");
INSERT INTO did_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Dì naka-ikagi si Juan to “Ho-o Sir, dì moydu-on nakita-an noy no otow no niggawang to busow diyà to otow no iyan piggamit din to ikow no ngadan. Dì pigsapadan noy su wadà man makalabot to ita no sinakupan.” ");
INSERT INTO did_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Nig-iling si Jesus to “Konà now ogsapadan kandin, su ko konà ogbalatak kandin ita, ogduma sikan ita.” ");
INSERT INTO did_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Na no madaas on to adow no pagbayow to Diyus ki Jesus diyà to langit, pigpa-awosan din no ogka-andiya-an din pad to Hirusalim no ogkamuwahan din on no banwa. ");
INSERT INTO did_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","To domdom din, oghapitan din pad podon diyà to lunsud no nasakup to Samariya. Kaling man pigpa-una din to pigpalikwad din awos ogpahina-aton kandan. ");
INSERT INTO did_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Dì wadà dan kaliyagi no mgo taga-Samariya to ogkahapitan pad kandan ni Jesus su diyà man to Hirusalim to ogtu-udan dan no kamatu-udan no lunsud to mgo Hudiyu. Aw to mgo Hudiyu no mgo otow, pigsawoy dan to mgo taga-Samariya. Kaling man nigbaos kandan to konà ogpahapiton kandan aw si Jesus du-on. ");
INSERT INTO did_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Dì pagkama-an ni Santiago aw ni Juan to konà ogpahapiton kandan to mgo taga-Samariya, namaka-ikagi on to “Sir, dow ogsugu-on koy nu to ogka-ubus kandan to logdog no oglikat to langit?” ");
INSERT INTO did_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Dì nalingì ni Jesus aw sapadi din kandan. ");
INSERT INTO did_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kaling man namakalaboy kandan aw si Jesus aw andiyà to bùgtì no lunsud. ");
INSERT INTO did_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Na no diyà pad kandan to pangindanan tigpoak moydu-on naka-ikagi no puli kandin nakaduma sikan no paghipanow ni Jesus no nig-iling to “Agad ando-i ka dumoog, ogsigi ad ogduma ikow.” ");
INSERT INTO did_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Naka-iling si Jesus to “Agad manuk-manuk, moydu-on dà bullug dan ugpa-anan no ogkahapunan aw to katuyù, moydu-on dà bullug dan ugpa-anan no ogkalukuhan. Dì kanak no Tumutubus to Ka-otawan, agad ando-i a to makasigkon.” ");
INSERT INTO did_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Na pig-ikagihan ni Jesus diyà to sobu-uk to “Duma kad kanak.” Dì nigtabak kandin to “Sir, tuguti a nu na-ay to monang ad ogduma ikow ko mamatoy on to amoy ku. Ko mamatoy on to amoy ku, kayan pana ogduma ad ikow.” ");
INSERT INTO did_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Dì nig-iling si Jesus to “To mgo duma nu no wadà tu-u no puli on bunwanon, oghimuhon nu nasi kandan no bunwanon nu to patoy now. Dì ikow, libod-libod ka to kalunsudan aw pasabuta to ka-otawan bahin to pagsakup to Diyus.” ");
INSERT INTO did_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Na kagi to duma to “Ogduma a ikow Sir. Dì monang ad oglikat ko ogba-id a pad to kadumahan ku.” ");
INSERT INTO did_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Naka-ikagi si Jesus to “To otow no ogdadadu dì oglingì-lingì on, konad no sakuponon to Diyus.” ");
INSERT INTO did_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Na pigpilì ni Jesus to duma no mgo otow no kapitu-an aw tinagdaduwaha to pigpinpin su ogpa-unahon din su igpahina-at din kandan to mgo lunsud aw mgo banwa no imomo-ot din ogdatongan. ");
INSERT INTO did_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Na impananglitan din kandan no nig-iling to “Dakoo on to anihonon no nig-abut, dì to mgo otow no ogpaka-ani, ma-intok dà. Ogpangamuyù kow to tagtu-un to humayan to ogpadugangan pad to mag-a-ani no ogpatabangon iyu diyà to anihonon. ");
INSERT INTO did_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ogpatubuson ku iyu to mgo otow no bugtì to mgo ginhawa su iyan ogka-angodan now to buhì no nalibongan to mamang. ");
INSERT INTO did_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Wadà ogdaahon now no kamuyut aw balutan aw sapatus. Konà kow ogsigkon to ogpagbaaw to agad intawa diyà to pangindanan su magagà to himuhonon now. ");
INSERT INTO did_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Agad ando-i no baoy no og-agpotan now, og-ikagihan now pad to tagbaoy to ‘Mapanalanginan so-idi no baoy.’ ");
INSERT INTO did_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ko pagduma iyu to tagbaoy, ogdugangan now to panalangin diyà kandin. Dì ko konà kandin, ogpapa-uli-on now to panalangin now. ");
INSERT INTO did_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Konà kow oghinalin, bullug sobu-ukon dà to og-agpotan now. Ogko-onon now aw inoma to agad nokoy no ighonat su to mgo ogtalabahu, bayadanan kandan. ");
INSERT INTO did_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Agad ando-i to og-abutan now no banwa, ogko-onon now to igkahonat iyu aw inoma now su iyu, ogbogayan kow man podon to igkabuhì now. ");
INSERT INTO did_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ogkangkadoyow now to nangkasakit du-on aw nangoni now kandan to ‘Madani on kani iyu to pagsakup to Diyus.’ ");
INSERT INTO did_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Dì ko umabut kow on to lunsud no konà kow dawaton, diyà kow to hibaakan aw ipasabut to ka-otawan no og-ilingon now to ");
INSERT INTO did_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Agad abug no nigdokot to kobong noy, ogpadpadon noy on no pagpakilaa to wadà koy now dawata aw to kanami no impang-anad. Dì ogtagahon noy iyu to madani on podon kani iyu to pagsakup to Diyus.’ ");
INSERT INTO did_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Na ognangonan ku iyu to sikan nadoogan to Suduma no lunsud natodu-on no na-ubus to logdog, kakampà dà. Dì to ogkadoogan to tibò no taga-lunsud no og-oyow iyu, malisod pad kandan iyan to mahudi on no adow. ");
INSERT INTO did_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Na iyu no taga-Kurasin, aboy kow. Aw iyu gayod no taga-Bitsayda, aboy kow, su mabogbog to kaboonganan no pighimu ku diyà iyu dì wadà now tu-uhi aw wadà now oyowi to paghimu now no mado-ot aw sosoo. Dì to mgo taga-Tiru aw mgo taga-Sidun natodu-on no dakoo to saà, nasosoan dan podon aw oyowi dan podon ko nakita-an dan podon to kaboonganan angod to nakita-an now kunto-on aw ogpangabò dà kandan podon to hanuut no ta-indanan to pagkasosoo dan to saà aw budbudi dan to abu to uu dan. ");
INSERT INTO did_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kaling man to mahudi no adow no pagbo-ot on to Diyus to mgo otow, malisod kow pad iyan aw konà now iyan ogkatuwa-ay to igbaos iyu to saà now su dakoo to impatu-u no nakita-an now, dì matuu wadà kow sosoo. ");
INSERT INTO did_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Iyu gayod no taga-Kapirna-um, agad nakalabow kow diyà to langit, dì ogpaka-andiyà kow to hinibatan to pasak.” ");
INSERT INTO did_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Na natapusan ni Jesus to pagtugun din diyà kan kapitu-an no ogpalibod-libodon no nig-ikagi kandin to “Na, to ogpaminog iyu, sikan angay ogpaminog kanak, aw to og-oyow iyu, og-oyow kanak aw og-oyow gayod to nigpa-andini kanak.” ");
INSERT INTO did_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Na kan kapitu-an, pagkatuman dan to insugù ni Jesus no pigpalibod-libod to mgo banwa, namang-ulì on kandan diyà ki Jesus aw nignawnangonon kandan no namantutukhaway aw ikagi to “Sir, agad mgo busow, ogpakatuman man ko ogsugu-on noy ko oggamiton noy to ngadan nu, su kanami, nahinang koy nu man no tumutubus diyà to ka-otawan.” ");
INSERT INTO did_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Dì naka-ikagi si Jesus to “Ho-o iyan, aw nakita-an kud on si Satanas no tagbayà ingkadogpak on no naka-angod to kilat no nigkiblat aw kagawang on kandin diyà to langit. ");
INSERT INTO did_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Na og-indanan now so-idi no kagi ku iyu. Pigbogayan ku iyu to kabogbogan to agad magi-okan now to ogpakalogot dì konà kow oglogoton, aw ogpakababow kow to kablang now, dì wadà oghalinan now. ");
INSERT INTO did_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Mangkuwan konà podon no sikan on to igkaliyag now su ogpakada-og kow to mgo busow. So-idi dà to angayan no tukhawanan now su nasulat on to ngadan now diyà to listahanan diyà to langit.” ");
INSERT INTO did_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Na kandà no timpu si Jesus, pigpadaoyag kandin to Ispiritu Santu aw iling kandin to “Amoy no Magbobo-ot to langit aw pasak, ogpasalamat a ikow su pighobongan nu to otow no madoyow to uu aw to nangkama-an no otow to impasabut nu bahin to pagsakup nu. Dì pigpakita nu nasì to mgo otow dà puli no wadà makatunga to ka-awangan su sikan to ikow pagbo-ot, Amoy. ");
INSERT INTO did_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","23","“Kanak, timbang a to Amoy ku, aw imbogoy din on kanak tibò. Wadà duma no nigkilaa to Anak lagboy ko konà no Amoy dà. Wadà duma no nigkilaa to Amoy lagboy ko konà no Anak dà gayod aw to pigpilì din no ogpakilahon din to Diyus no Amoy.” ");
INSERT INTO did_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Na nig-atubang si Jesus diyà kan mgo pangabaga din aw pantongopi to kagi no pig-iling to “Ogkaliyag kow su iyu, nakita-an now on to wadà kakita-i to mgo lagsoban to Diyus aw mgo harì agad pigpakagutgut dan podon no awos og-aha-on dì wadà dan sakpana. Nakadinog kow on gayod to dinogonon no wadà dan kadinog, agad pigpakagutgut dan podon no awos ogdinogon dì wadà dan gayod sakpana.” ");
INSERT INTO did_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Na moydu-on songo mag-a-anad to tinu-uhan to mgo Hudiyu no nigpangukdayogan su og-antihan din podon si Jesus. Nig-usip kandin to “Sir, amonu a buwa awos madawat kud to kinabuhì no konad ogkawadà.” ");
INSERT INTO did_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Nakatabak si Jesus to “Nokoy to pagpanginsabut nu to kasulatan bahin sikan no impangusip nu.” ");
INSERT INTO did_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nigtabak to mag-a-anad to kasugu-an to “Ogkalogonan now to Diyus no Magbobo-ot now to tibò no tu-un now no domdom aw tibò no pikii now, ginhawa now, aw mgo doson now tibò, aw oglogonan now to kapadihu now angod to paglogon to lawa now.” ");
INSERT INTO did_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Nig-iling si Jesus to “Hustu iyan to pig-ikagi nu, ogtumanon nu sikan no na-ikagi nu awos ogkabogayan ka to kinabuhì no konad ogkawadà.” ");
INSERT INTO did_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Dì sikan mag-a-anad, wadà kaliyag ko mahimu to ka-otawan to ing-usip din no wadà maka-igù. Kaling man naka-ikagi kandin to “Tùtu-u to pig-ikagi nu, dì intawa buwa lagboy to kapadihu ku.” ");
INSERT INTO did_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Na impananglitan ni Jesus to intabak din no iniling din to “Songo otow no Hudiyu, niglikat to Hirusalim su oghipanow diyà to Hidiku no lunsud. No diyà pad to tongà-tongà to pangindanan, pigtulis kandin. Piglobasan kandin to tulisan aw bunai. Dayun pig-oyowan kandin no pakamatayon on podon. ");
INSERT INTO did_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Wadà dà kaugoy to pagkali-us to mgo tulisan, nakabayà on to punu-an to tinu-uhan to mgo Hudiyu. Dì pagkita din, nigpatitalipag to daan aw labayi din nasì kan otow no nakahibat. ");
INSERT INTO did_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Pagkaugoy-lugoy nakasudsud mandà to nabaya-an to songo pangabaga to mgo punu-an to tinu-uhan. No padatong din diyà topad kan otow, nigpatitalipag kandin aw labayi din mandà puli. ");
INSERT INTO did_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pagkaugoy-lugoy nakasunù mandà nakabayà to songo otow no nigsakoy to kabayù no taga-Samariya no puli ogsawayon to mgo Hudiyu. Dì kandin, pagkita din du-on to otow no Hudiyu no nakahibat du-on to daan, pigka-atan din ");
INSERT INTO did_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","aw andu-oni din. Pigtambaan din no piglamas to mapodos du-on to mgo palì din aw pigpatagdu-an din to lana aw bodboda din Davun pigpaluwan to taga-Samariya kan otow no Hudiyu diyà to kabayù din aw daaha din diyà to songo pa-abutanan aw alaga-i. ");
INSERT INTO did_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","“Na to sunù no adow imbogoy din to sampuù tag lima no sapì diyà kan tagtu-un to pa-abutanan aw ikagihi to ‘Ogpabantayan ku ikow to otow no napali-an. Ko sumubla to ogkagastu din, ogbayadan ku dà ikow ko umulì a dini.’ ");
INSERT INTO did_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Na sikan tatou no ka-otow no nakabayà du-on kan nalisodan no otow no napali-an, intawa lagboy to tùtu-u no kapadihu din.” ");
INSERT INTO did_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Nakatabak to mag-a-anad to “Sikan nigka-at kandin to tùtu-u no kapadihu din.” Naka-ikagi si Jesus to “Na, sunuda nu kandin.” ");
INSERT INTO did_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Na nigto-od si Jesus to panow din aw mgo sakup din padoog diyà to Hirusalim. Dì nighapit pad kandin diyà to Bitaniya no lunsud aw to nigpaponhik kandin to baoy, si Marta. ");
INSERT INTO did_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Moydu-on hadi din no iyan ngadan si Maria aw iyan dà talabahu din to ogpaminog to impang-anad ni Jesus. ");
INSERT INTO did_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Dì si Marta, nigsabaag pagpaminog din su mahan-ing to dawatonon din. Naduguk din si Jesus aw ka-ikagihi to “Wadà a nu buwa Sir ka-aha-i to sobu-ukon a no og-alagà to bisita no puli a pigpabay-anan to hadi ku to kanak dawatonon dini to baoy. Igaya kun kandin dini awos matabangan a.” ");
INSERT INTO did_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Dì nigtabak si Jesus to “Marta, Marta, nokoy man no napook-pook ka to mahan-ing to dawatonon nu aw kasabaagan to pagpandagimon aw pagpang-alagà to mgo bisita. ");
INSERT INTO did_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Dì sikan labow pad tibò, napilì on ni Maria no sikan, ogpaminog kandin lagboy to impang-anad ku aw konà ku ogsapadan kandin.” ");
INSERT INTO did_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Na songo adow nig-ampù si Jesus to Diyus. Pagkatapus din pag-ampù, nig-ikagi to sobu-uk no sakup din to “Sir, anada koy to pag-ampù to Diyus awos ma-amu koy, su si Juan, pigpang-anad din man to kandin mgo sakup to pag-ampù to Diyus.” ");
INSERT INTO did_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Nig-ikagi si Jesus to “Ko og-ampù kow, og-angodon now so-idi no paglituk no, “Amoy, matahudan podon to ngadan nu su matuwadong ka. Kunto-on umabut podon to pagsakup nu dini to kalibutan. ");
INSERT INTO did_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","“‘Bogayi koy nu podon kunto-on no adow to kapookanan noy no ogkako-on noy. ");
INSERT INTO did_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","“‘Ogpasayluhon koy nu to mgo saà noy su pigpasaylu noy on to nakasaà dini kanami. Og-aha-on koy nu dow wadà buwa dini kanami no igkahimu ni Satanas no pa-antihan.’” ");
INSERT INTO did_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Pagkatapus ni Jesus to pag-anad to mgo pangabaga din to pag-ampù to Diyus, impananglitan din no pag-aboy din to pagpang-anad. Kagi din to “Na ko pananglitan, oglatun kid diyà to songo baoy ta to madaom on no kadukiloman su moydu-on bisita ta no nakadatong no nighapit ita no madiyù to pighipanawan din, aw wadà igkahonat ta kandin. Ko umabut ki du-on ");
INSERT INTO did_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","og-ikagi kid to ‘Lagi, bayà datong to bisita noy no nighapit diyà kanami no madiyù to pighipanawan din no nasaklopan on kandin. Wadà Lagì igkahonat ku kandin. Ogpangamuyù a dini ikow to igkahonat ku podon ko mahimù.’ ");
INSERT INTO did_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Sikan tagbaoy no diyà dà to sood to baoy din, ogtabak to ‘Aya kad ogsamuk kanak su natakopan on Lagi. Pigpamalipodong kud on to mgo batà ku. Konà a ogpakabangun aw ogpakabogoy kunto-on no mataod on no kadukiloman.’ ");
INSERT INTO did_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Na ognangonan ku iyu, agad konà ogbangun podon aw bogayi ki din su sumbaoy ki din man, ogpakabangun dà aw makabogoy ita to pigpangamuyù ta ko konà ta ogbungku-an to ogbuyù. ");
INSERT INTO did_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ognangonan ku iyu to ko ogpangamuyù kow on to Diyus, ogbogayan kow man. Ko pumanganap kow, ogpakita-on kow man. Ko ogsabi kow, ogpaponhikon kow. ");
INSERT INTO did_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Su to tibò ogpangamuyù, ogpakadawat. To ogpanganap, ogpakakita. To ogsabi, ogkapaponhik. ");
INSERT INTO did_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Wadà amoy ko ogpangamuyu-an to isdà no iyan on igbogoy to uwod diyà to batà din. ");
INSERT INTO did_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ko ogpangamuyù to otoug, konà no iyan on igbogoy to salipit-sipit. ");
INSERT INTO did_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Iyu, agad wadà pad ka-usab to ginhawa dì ogka-amu kow on to pagbogoy to kadoyawan diyà to mgo batà now, woynu pad man to Diyus no Amoy diyà to langit igbogoy din iyu to Ispiritu Santu ko ogpangamuyù kow diyà kandin.” ");
INSERT INTO did_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Na songo adow niggawang si Jesus to busow no makapapohà diyà to songo otow. Paggawang to busow, ogpaka-ikagi on to matuwadong. Na nangkaboong-boong to ka-otawan. ");
INSERT INTO did_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Dì moydu-on naka-ikagi to “Si Satanas no pighingadanan gayod ki Bilsibul no tagtu-un to mgo busow, nabogayan din sikan no otow to kabogbogan to ogpakagawang to busow ko ogsood to otow.” ");
INSERT INTO did_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Na moydu-on gayod nigbogoy ki Jesus to pa-antihan su ogpahimuhon podon kandin to kaboonganan no likat to kabogbogan to Diyus no ogkita-on dan podon diyà to langit. ");
INSERT INTO did_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Dì tahan dà nama-anan ni Jesus to mgo domdom dan aw ikagi kandin to “Na to sinakupan, ko ogkinablangay, madaas dà to katapusan. To songo manwa, ko ogkinablangay, madaas dà to katapusan. ");
INSERT INTO did_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Kandan aw si Satanas, ko ogkinablangay, madaas to katapusan to kandin sinakupan. Na sikan pagpandomdom now, konà no hustu su nig-ikagi kow to oggawang a to busow likat to kabogbogan ni Satanas no pighingadanan gayod ki Bilsibul. ");
INSERT INTO did_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Na, ko nadomdoman now to oggawang a to busow no impabayà to kabogbogan no imbogoy to tagtu-un kandan no si Bilsibul, intawa buwa to nigbogoy to kabogbogan to iyu no mgo sakup no ogpakagawang to busow. Usipa now kandan su mgo sakup now no ogpakagawang to busow, kandan to igmatu-ud to nakasaà kow su pighimu a now no nigdawat to kabogbogan likat ki Satanas no pighingadanan gayod ki Bilsibul. ");
INSERT INTO did_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Dì ko Diyus to piglikatan to kanak kabogbogan to ogpakagawang to mgo busow, sikan to igkapatu-u iyu to na-abutan kow on to pagsakup din. ");
INSERT INTO did_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Na ko pananglitan, mabuut to tagbaoy no natinguban to panganiban aw bantayi to kandin ugpa-anan, wadà ogkasalin no katinguban din. ");
INSERT INTO did_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Dì ko moydu-on duma no mabobogbog pad du-on kan tagbaoy no ogpagbuwow aw kada-og kan tagbaoy, ogkapudutan dà iyan kandin to katinguban din no pigsaligan din aw hinanduga to otow no nakapudut du-on kandin. ");
INSERT INTO did_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Na to konà ogduma kanak, iyan ogkablang kanak nasì. To otow no konà ogbulig kanak no ogpanghimun to nig-abut, iyan nasì ogpangkanat to nahimun on no nig-abut.” ");
INSERT INTO did_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Na nig-aboy pad si Jesus to pagpasabut no nig-iling to “Na ko pananglitan, ko ogpakagawang on to busow diyà to pigsoodan din no otow, ogpakalahok on puli to busow diyà to katahayan no banwa su ogpanganap to ogka-ugpa-an din dì wadà ogka-abutan din. To tu-un din no domdom, og-ilingon din to ‘Ah, ogpati-ulì a dà diyà to tahan ku no ugpa-anan.’ ");
INSERT INTO did_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Dì pagdatong din, napunasan on aw katapid on. ");
INSERT INTO did_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Na du-on ogbaligà kandin to pitu pad no busow no mado-ot pad du-on kandin. Namansood kandan du-on ton otow no piggawangan on aw pakamonang kandan du-on pamang-ugpà. Na to katapusan kan no otow, malisod pad nasì du-on to tugdow no kabotang din.” ");
INSERT INTO did_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Na no pagpasabut ni Jesus to ka-otawan, moydu-on songo buyag no naka-ikagi to ma-agbot to “Ogkaliyag to buyag no nig-anak ikow aw padudù kandin ikow.” ");
INSERT INTO did_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Naka-ikagi si Jesus to “Ogkaliyag nasì to ogpaminog to kagi to Diyus aw tumana.” ");
INSERT INTO did_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Na no pagdugang-dugang to ka-otawan no ogpaminog ki Jesus, impasabut din no pig-iling to “Mado-ot to mgo otow no ogkaliyag puli og-ahà to kaboonganan no ta-indanan to pagmatu-ud to na-uyunan a to Diyus. Iyan dà igkabogoy diyà sikan ka-otawan no kaboonganan to angod to ingmatu-ud to pagka-uyuni ni Jonas no maglilikwaday to Diyus natodu-on no nakalibwas dà kandin to kamatayon su agad pigpugutan on to tatou no adow to pagka-ugpà din diyà to sood to gotok to ma-aslag no isdà, dì nakalibwas dà kandin. ");
INSERT INTO did_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Sikan no nadoogan ni Jonas, ta-indanan to pagmatu-ud to na-uyunan kandin to Diyus diyà to taga-Niniba natodu-on. Kanak gayod no Tumutubus to Ka-otawan, to ogkadoogan ku, ta-indanan gayod diyà to kadongan-dongan ku to pagmatu-ud to Diyus to kanak, na-uyunan to Diyus no ogpakalibwas a dà gayod to kamatayon. ");
INSERT INTO did_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ko magotò to adow to pagbo-ot to Diyus to mgo otow, ogpangukdayogan to buyag no nigsakup to Siba no banwa natodu-on aw kabogayi din to saà to kadumahan ta kunto-on no ogkahibatan dan su madoyow to pighimu din, su agad madiyù no banwa to piglikatan din, dì nighipanow on kandin diyà to pigsakupan ni Solomon awos ogpaminog podon to nama-anan ni Solomon no imbogoy to Diyus. Di og-indanan now to kunto-on nig-andini on no labow pad ki Solomon. Dì kandan, wadà dan i-angod. ");
INSERT INTO did_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ko ogbo-ot to Diyus to mahudi no adow, ogka-usip kow to saà now to mgo taga-Niniba no ognangon to pigpang-oyowan dan nasì to kandan katahani no pag-udlin ni Jonas kandan natodu-on. Dì iyu, wadà now oyowi to katahani now no pag-udlin ku iyu dì nig-andini on to labow pad ki Jonas dì wadà now i-angod.” ");
INSERT INTO did_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Na impananglitan ni Jesus no nig-iling to “Ko ogpadokotan ta to ilawan, konà ta ogsangkuban to lata dow igbotang ta dà du-on to saad to baoy. Igbotang ta nasì diyà to kabakna-an awos matang-awan to nasood du-on. ");
INSERT INTO did_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Na to mata ta, iyan na-angodan to ilawan to lawa ta. Ko wadà ogpakasalibon to mata, ogkatang-awan tibò to lawa ta. Dì ko moydu-on ogpakasalibon no mado-ot to domdom now, ogkadigloman man gayod to lawa now tibò. ");
INSERT INTO did_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kaling man ogdowdoyawon now to ginhawa now su to ka-awangan now, iyan ogkabauyan to kadigloman. ");
INSERT INTO did_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ko matang-awan tibò to lawa now, moydu-on on igtang-ow now iyan aw angod to natang-awan kow to ilawan.” ");
INSERT INTO did_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Na pagkatapus to pag-ikagi ni Jesus, pigpaponhik kandin to songo Parisiyu diyà to baoy din aw du-on kandin pako-ona. Pagkasood dan, nig-ingkud si Jesus ");
INSERT INTO did_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","no wadà panghugas to boad din agad-agad to tulumanon dan no mgo Hudiyu. Naboong-boong to Parisiyu su wadà tumana ni Jesus to kandan tulumanon. ");
INSERT INTO did_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Dì impananglitan ni Jesus no nig-iling to “Iyu no mgo Parisiyu, angod kow dà to otow no oghugas to mgo bukug dì iyan dà oghugasan dan to babow. Matuu to sood to bukug aw platu, konà dan oghugasan. To nakasood iyu to pagpanda-og-da-og aw kado-otan, wadà now hugasi to sood now. ");
INSERT INTO did_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Wadà nama-anan now. Su sobu-ukon dà to niggihit to sood aw babow to lawa ta no otow. Ogkalinisan now dà gayod tibò to mgo domdom now. ");
INSERT INTO did_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","To pigsakupan now no kadatù, ko ogbogayan now to nawada-an to kapookanan dan, kayan sikan diyà to sood now, ogkadoyow gayod. ");
INSERT INTO did_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Iyu no mgo Parisiyu no punu-an to tinu-uhan, aboy kow su lagboy kow no matagon-tagonon to tulumanon now, su agad kama-intokanan ubag no angod to a-anag dì ogbinogoy kow to Diyus to sinampuù. Dì to kamatu-udan no angod to pagtahud aw paglogon now to Diyus, pigpabay-anan now dà. Ogtumanon now podon sikan nasì tibò. ");
INSERT INTO did_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Aboy iyu no Parisiyu, su iyan dà oghimuhon now to ogpatahud-tahud diyà to simbahan aw diyà to mgo kahimunanan. ");
INSERT INTO did_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Aboy iyu no mgo Parisiyu aw mgo mag-a-anad to tinu-uhan, humina-at kow no iyan ogka-angodan now to lobong no wadà indan aw kagi-ok-gi-okid puli to ka-otawan, su iyu to piglikatan to kado-otan to ka-otawan dì wadà dan kama-ani.” ");
INSERT INTO did_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Na, songo mag-a-anad to tinu-uhan, nig-ikagi to “Sir, ton na-ikagi nu diyà to mgo Parisiyu, kanami gayod to napa-atubangan nu aw kasikawi koy.” ");
INSERT INTO did_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Naka-ikagi si Jesus to “Aboy gayod iyu no mag-a-anad to tinu-uhan. Humina-at kow no ogpabogatan now on to ka-otawan to tagudaa dan aw iyu, konà now ogbuligan kandan agad ma-intok. ");
INSERT INTO did_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Aboy iyu su puli now on pigpadayan-dayanan to piglobongan no indananan ta to mgo maglilikwaday to Diyus aw sikan mgo tumutubus din no pigpanghimatayan natodu-on to ka-aw-apu-an now. ");
INSERT INTO did_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kaling man iyu no mag-a-anad, nakamatu-ud kow to pig-uyunan now to pighimu to mgo ka-aw-apu-an now no paghimatoy dan kan mgo maglilikwaday to Diyus natodu-on su kandan to nanghimatoy to mgo maglilikwaday, aw iyu no mag-a-anad to nigdayan-dayan to mgo lobong dan su nigka-u-uyun kow man to domdom. ");
INSERT INTO did_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kaling to Diyus no dakoo to nama-anan, nig-ikagi kandin to ‘ogpa-andiya-on ku to maglilikwaday ku aw mgo tumutubus ku, dì kandan, moydu-on ogka-uwang-uwangan aw moydu-on ogkahimatayan gayod.’ ");
INSERT INTO did_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kaling man mgo otow kunto-on, ogkastiguhon to Diyus su ogkahimu kandan no nigpanghimatoy to tibò no mgo maglilikwaday din likat to paggihit so-idi kalibutan ");
INSERT INTO did_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","aw likat to paghimatoy ki Abil hantod to paghimatoy ki Zacarias diyà to pag-ootan to sangabanan to buhì no igsundù diyà to Diyus aw abutanan din diyà to solib to labow no simbahan. Ogkastiguhon kow tibò. ");
INSERT INTO did_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Aboy humina-at kow no mag-a-anad to tinu-uhan, no wadà now ibogoy to susi no igka-abli to nabotangan to nama-anan no lagboy katùtu-uhanan. Aw iyu, wadà kow sood kan nabotangan aw hognà pad konà now ogtugutan kan ogkaliyag ogsood podon du-on.” ");
INSERT INTO did_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Na nighipanow kandan si Jesus, dì agad ando-i dumoog kandan, sikan mgo mag-a-anad to tinu-uhan aw mgo Parisiyu, kanunoy dan pigpangusip-usip si Jesus to agad nokoy no ig-usip dan ");
INSERT INTO did_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","su awos makadakop podon kandan to kagi-kagi din no ogkapatikinan no igkadiklamu dan kandin. ");
INSERT INTO did_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Na pagkahimun to ka-otawan no minaan, nadasok-dasok on lagboy hantod to nigkagini-okay on kandan. Tugdow nigpagbaaw si Jesus to mgo pangabaga din. Nig-ikagi kandin to “Dowdoyow kow to pagpatulin to paan to mgo Parisiyu no iyan kalitukan sikan to pagpakunon-kunon dan. ");
INSERT INTO did_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Wadà nakahobong no konà ogkapayagan dà su wadà inghobong no konà ogkatagahan. ");
INSERT INTO did_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Agad nokoy no og-ikagihon now no wadà nataga, ko kaugayan, ogkama-anan dà. To ighagas now puli diyà to iyu no baoy, ogkatagahan dà to ka-otawan.” ");
INSERT INTO did_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Na nig-aboy si Jesus nigpangudlin no pag-ikagi din to “Ogkanangon ku iyu no mgo kasu-unan ku, konà kow ogminahadok to otow su iyan dà ogkahimatayan din to lawa ta aw tinakin wadà duma no kado-otan ta no likat kandin. ");
INSERT INTO did_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Dì ogbahogon ku iyu to iyan lagboy kahadokanan now to Diyus. Ogkahadokan now kandin su ko Diyus to oghimatoy to otow, ogpakapadoog kan otow diyà to banwa no kastiguhanan to saà. Kandin iyan to lagboy kahadokanan now. ");
INSERT INTO did_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Na agad lima no bu-uk no manuk-manuk, konà ta oghinangon no igkasodà ta to so pagko-on dà. Dì konà ogkalingawan to Diyus. Agad sobu-uk dà no manuk-manuk, ogkama-anan to Diyus to ogkadoogan din. Woynu pad man to otow. ");
INSERT INTO did_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Agad bubuu ta, na-indanan to Diyus. Kaling man konà kow ogminapook-pook su iyu, pighimu to Diyus no oglabow kow pad diyà to mgo manuk-manuk tibò. ");
INSERT INTO did_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Na, ognangonan ku iyu to sikan otow no ogmatu-ud diyà to atubangan to ka-otawan to kanak to tagsakup kandin, kanak gayod no tumutubus to Ka-otawan, og-abinon ku iyan kandin diyà to atubangan to Diyus aw mgo diwata din. ");
INSERT INTO did_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Dì ko ogtuy-awon a din, konà ku gayod og-abinon kandin diyà to atubangan to mgo diwata to Diyus. ");
INSERT INTO did_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“To otow no og-ina-ina kanak no Tumutubus to Ka-otawan, ogkapasaylu dà. Dì to otow no oglangub og-ina-ina to Ispiritu Santu, konad on iyan ogkapasaylu kandin to saà. ");
INSERT INTO did_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ko ogpa-atubangon kow aw pangusip-usipa kow to agad intawa no moydu-on kabogbogan, konà kow ogkapook-pook to igkatabak now aw iyu no ogka-ikagi, ");
INSERT INTO did_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","su sikan no timpu, ogbogayan kow to kagi no tigka-un puli now ogkalituk to igpa-ikagi iyu to Ispiritu Santu no litos no igkatabak now.” ");
INSERT INTO did_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Na, moydu-on otow no nakaba-ot diyà to kahan-ingan no naka-ikagi to “Sir, og-ikagihan nu to su-un ku to oghandugan a din dà to mgo kabilin to ma-as noy.” ");
INSERT INTO did_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Dì naka-ikagi si Jesus to “Konà a, su wadà a ikabotang no maghuhusoy.” ");
INSERT INTO did_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Pig-ikagihan ni Jesus to ka-otawan to “Ogdilinan now ko iyu, ma-inga-on. To kamatu-udan to pag-ugpà ta, konà no katu-unan ta sikan.” ");
INSERT INTO did_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Na, impananglitan ni Jesus to impang-anad din no nig-ikagi kandin to “Songo datù no otow, dakoo on to nig-abut to tanom din. ");
INSERT INTO did_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nadomdoman din to kandin tu-un no domdom to ‘Amonuhon ku buwa so-idi, su wadà ogkabotangan ku to nig-abut su madakoo on man lagboy. ");
INSERT INTO did_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Na,’ kagi din, ‘ogwagkason ku dà aw basbasa ton tahan no kubkub ku su og-ilisan ku to bayà aw ma-a-aslag pad no ogkalitos to nig-abut kanak, aw tibò no tingub ku, igkabotang ku du-on. ");
INSERT INTO did_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Og-iling kanak to domdom ku to, Pigkulisan a su madoyow to nig-abut su igkabotang kud on to litos-litos no igkabuhì ku to kahaba-an ku no og-ugpà. Konà a ogpakatalabahu kunto-on to mabogat. Ogko-on a aw og-inom a aw liliyag a.’ ");
INSERT INTO did_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Dì Diyus, og-ikagi kandin to ‘Oy, ampan napikiyan nu no madoyow. Na, ogkanangon ku ikow to kunto-on no kadukiloman katapusan nud on, aw sikan nadap-ug nud no intagama nu to kaugayan nu, intawa on man to ogpakatu-un sikan.’ ");
INSERT INTO did_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Na, tahan iyan to otow no angod kan no puli dà na-aun to kadatù dini to babow to pasak dì ko diyad kandin to atubangan to Diyus, puli on ogkomoo-komoo, wadad ogkadawat din.” ");
INSERT INTO did_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Na nig-iling si Jesus diyà to mgo pangabaga din to “Kaling man konà now ogkapook-pookan to kabotang now dow nokoy to ogkako-on now aw ogkapangabò now, ");
INSERT INTO did_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","su to kinabuhì ta, labow pad du-on to ogkako-on ta. Aw lawa ta gayod, labow pad du-on to ogkapangabò ta. Mano pigbogayan ki to Diyus to kinabuhì ta aw lawa ta gayod, angod dà ogbogayan kid gayod to kapookanan ta tibò. ");
INSERT INTO did_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ko pananglitan to mgo manuk-manuk, konà og-odok aw konà gayod og-ani. Wadà oghimuhon dan no kubkub no ogbotangan dan to tipaoy. Diyus dà man to ogpako-on kandan. Dì labow kow pad lagboy du-on to manuk-manuk. ");
INSERT INTO did_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Agad kanunoy now mapook-pookan, dì konà no sikan to ogpakapagsugpat to kinabuhì now, agad songo lumpù dà. ");
INSERT INTO did_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ko konà kow ogpakatuman to mgo kama-intokanan, amonuhon now to pagtuman to kina-aslagan. ");
INSERT INTO did_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ogdomdoman now to pagtulin to mgo bulak-bulak no puli oggitì. Ogkabuhì dà man kandan. Konà kandan ogka-amu to ogtalabahu agad ogtingkaa. Dì ogkanangon ku iyu to agad si Harì Solomon no dadatu-on, dì wadà kabò din no ogpaka-angod kan bulak-bulak bahin to kinalabawan no og-aha-on. ");
INSERT INTO did_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Diyus to nigdaa to puli ogpanggitì no mgo bulak-bulak no ogtuga dì to sunù no adow, sangabonon on. Woynu pad ogdaahon kow din aw kabogayi kow din to ogkapangabò now. Tùtu-u to ma-intok to pagtu-u now to Diyus. ");
INSERT INTO did_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Konà now ogkapook-pookan to pagpanganap to ogkako-on now aw sikan ogka-inom now, ");
INSERT INTO did_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","su angod sikan to pagkangkapook-pook to mgo otow no bugtì to pigsaligan no konà no Diyus. Dì Diyus no Amoy ta, nama-anan din dow nokoy to iyu no nawadà. ");
INSERT INTO did_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ko ogpa-aag-aagon now nasì to kandin no pagsakup, ogbogayan kow din gayod to mgo kapookanan now. ");
INSERT INTO did_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Na, iyu no sinakupan ku kunto-on, agad ma-intok kow dà, dì wadà ogkapook-pookan now su ogkaliyag to Diyus no Amoy ta to ogbogayan kow to katondanan to pigsakupan din. ");
INSERT INTO did_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ogpabayluhan now on to katu-unan now to sapì aw igpambogoy now diyà to nawada-an su sikan iyan to igkapudut now botanganan diyà to langit no konà ogkadunut aw itagù now no konà ogkilos. Konà gayod ogkapudut. Konà ogkakotkot to kaling no ogpakado-ot. ");
INSERT INTO did_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Agad ando-i ta ibotang to linogonan ta, du-on dà gayod to domdom ta. ");
INSERT INTO did_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Na, oghina-atan now on to pagdatong to tagsakup iyu no og-ulì no nigba-ot to pagsauhan. Agad mataod to kadukiloman, oghina-at kow no ogpanda-on-da-on aw padokot kow to ilawan now angod to sugu-onon no nigtagad to pag-ulì to tagsakup kandin, awos kow madaas ogpakasalubung ko ogsabi kandin. ");
INSERT INTO did_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Na dayun ogkaliyag kow no mgo sakup ko konà pad ogkalipodong dì ogtagad kow pad ko umabut to tagsakup iyu. Ognangonan ku iyu to kandin no tagsakup, ogsukoli dà to katondanan to sakup din dà, su ogpangabò ubag kandin nasì to hanuut no kabò to sakup aw pa-ingkuda din to sakup aw diyaga gayod kandin. ");
INSERT INTO did_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Agad masaklop on dow kabakna-an to kadukiloman to pagdatong din, ogkaliyag to mgo sakup ko ogpamanggimata pad. ");
INSERT INTO did_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ko pananglitan, tagbaoy, ko mama-anan din lagboy dow nokoy to uras to ig-abut to kawatan, ogpakabantoy man kandin su gimata pad man kandin aw konà ogpakasood to baoy din to kawatan. ");
INSERT INTO did_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kaling iyu, oghina-at kow gayod su awos konà kow ogkatokawan to pagdatong ku dini no Tumutubus to Ka-otawan.” ");
INSERT INTO did_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Na, nig-usip si Pedro to “Sir, dow kanami dà iyan dow tibò to napa-atubangan nud to impananglitan nu.” ");
INSERT INTO did_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Naka-iling si Jesus to “Nig-ikagi a diyà to sakup no matinumanon aw ka-amu no ogkasaligan to tagsakup kandin no oghandug to kapookanan diyà to duma no kasakupan din. ");
INSERT INTO did_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ogkaliyag lagboy to sakup ko dumatong to tagsakup kandin no ogpangintaga dow natuman on to mgo sugù din. ");
INSERT INTO did_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Tùtu-u to ogbaosan din no igbotang din on kan no sakup din no magbobo-ot to katu-unan din tibò. ");
INSERT INTO did_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Dì to tu-un din no domdom, ko og-iling pa to ‘Ogkaugoy buwa to pag-ulì to mata-as ta,’ aw sikan no sakup, nigpambunaa nasì kandin to pigpabantayan podon kandin, agad lukos aw buyag, aw pinuna-us din to pagko-on aw pag-inom aw minahingow, ");
INSERT INTO did_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","dì tinakin ogkatokawan kadin su ogpakatokow ogpakalogwà to mata-as din diyà to wadà din imani to ogkalogwa-an. Oggawangan on kandin to insalig kandin no imbotang diyà kandin aw kastiguha kandin aw hinangad no konad no tumutu-u kandin. ");
INSERT INTO did_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“To sakup no nama-an to igpahimu to tagsakup kandin dì wadà hina-ata aw wadà tumana to igpahimu to tagsakup aw wadà agdam to a-abutay to tagsakup, ogkabunaan lagboy. ");
INSERT INTO did_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Dì to sakup no wadà din katagahi to insugù to tagsakup kandin, dì nahimu din no igkahimu kandin no ogkabunaan, mahinoy dà to pagkastigu kandin. To otow no ogbogayan to dakoo, dakoo gayod to ogkasukut du-on kandin. To otow no ogbogayan to dakoo pad, dakoo pad gayod to ogkasukut du-on kandin. ");
INSERT INTO did_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Na, iyan ingka-andini ku to pasak su so-idi pasak, ogpadokotan ku to kayu. Ogpadokotan on podon kunto-on, dì konà-konà pad. ");
INSERT INTO did_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ogkalisodan a dì ogkatuwa-ay ku dà. Ogkapookan ku hantod to matuman on. ");
INSERT INTO did_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Dow intobo-ot now dow so-idi pag-andini ku to kalibutan no puli a nigpahagtong to mgo samuk to ka-otawan aw pamatibo-a ku kandan agad wadà ka-usab kandan to ginhawahan dan? Konà, su iyan ingka-andini ku su ogpagsuwoy-suwayon kud nasì tibò. ");
INSERT INTO did_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ko pananglìtan, likat kunto-on to songo minyò no lima kandan, ogkasusuwoy dà to daduwa aw kabugtì to tatou aw ogkakablang kandan. ");
INSERT INTO did_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ogkinalituhay ogkakablang to amoy aw anak, anak aw inoy. Pata-ugang, ogkakablang, gayod.” ");
INSERT INTO did_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Na, nig-aboy si Jesus nigsoysoy to kahan-ingan. Kagi din to “Ko ogpakakita kow to makiboo diyà to saopan, ogpaka-iling kow to ‘Dagow dow tumo-od umudan gagaya,’ aw du-on ogkatùtu-u man. ");
INSERT INTO did_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ko ogkamag on no oglikat to habagatan, ogpaka-ikagi kow to ‘Habagat on no timpu kunto-on,’ aw ogkatùtu-u man gayod. ");
INSERT INTO did_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Iyu no mapakunon-kunonon no mgo otow, ogka-amu kow dà ogtahom to timpu to banwa. Dì to timpu on to paglogwà to Imananan to Ka-otawan, konà now on ogkakilahan. ");
INSERT INTO did_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Nokoy man no konà kow ogpikii to matuwadong. ");
INSERT INTO did_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Na ko pananglitan, moydu-on ogdiklamu iyu diyà to ogdaa to bala-od. Ko konà kow din pad madawat, tu-uni now na-ay to paghusoy, su ko konà, bali no huwis on to ogsangko-an aw ogsugu-on din to pulis din aw ipapirisu kow din. ");
INSERT INTO did_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Konà kow pad ogpakalabas ko konà now pad mabayadan tibò to ogpabayadan iyu.” ");
INSERT INTO did_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Na du-on to mgo otow no nignawnangonon ki Jesus bahin to pagpahimatoy ni Gubirnadur Pilato to mgo taga-Galiliya no namanghinang kandan diyà to simbahan no labow. ");
INSERT INTO did_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Kagi ni Jesus to “Dow intobo-ot now buwa dow saà sikan mgo taga-Galiliya no pigpanghimatayan, madakoo pad diyà to kadumahan dan su pigpahimatayan man kandan? ");
INSERT INTO did_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Dì konà man. Aw ognangonan ku iyu, ko konà kow makasosoo aw oyowi now to paghimu now no mado-ot, padihu dà iyan to ogkadoogan now. ");
INSERT INTO did_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Sikan gayod sampuù tag wau no nangkamatoy no pigdo-ogan to pinatudoy no batu no matikang no bantayanan no napood diyà to longod to Siluwi no linow, dow intobo-ot now buwa dow madakoo pad to saà dan diyà to duma no taga-Hirusalim? ");
INSERT INTO did_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Dì konà. Aw ognangonan ku iyu to ko konà now on ma-oyowan to paghimu now no mado-ot, ogka-ubus kow man no ogpaka-angod kow kandan.” ");
INSERT INTO did_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Na, impananglitan ni Jesus to pagpang-anad din no pig-iling din to “Songo otow, nigtanom to kayu no ogbogas to ogkako-on no oghingadanan to igira. Pagkaugoy nig-ahà kandin to bogas, dì wadà nakita-an din. ");
INSERT INTO did_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Kagi din diyà to otow no pigpabantoy din to tanomanan din to ‘Lagi, natatou no tu-ig to sigi a og-inahà dow moydu-on on bogas sikan no kayu, dì wadà man nakita-an ku. Ogpoodon nud on su ogpakaguk-aa on puli to pasak.’ ");
INSERT INTO did_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Kagi to otow no pigpabantoy to tanomanan to ‘Konà Sir. Ogpabay-anan ta dà sood to songo tu-ig pad su ogsubungon ku pad aw ogpandansuhan ku. ");
INSERT INTO did_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ko bumogas to sunù no tu-ig, ogtukhow ki. Dì ko matag on konad abutan to tu-ig mandà, kayan poodon on.’” ");
INSERT INTO did_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Na, nigpang-anad si Jesus diyà to songo simbahan to adow no konà no tigtatalabahu. ");
INSERT INTO did_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Nakaba-ot to buyag no nasakit su nakapagugukù to bagakwang su konà din man ogkatul-id lagboy. Pigpanampuu-an on tag wau no tu-ig to pagdawdaa to sakit din. Busow to piglikatan to sakit din. ");
INSERT INTO did_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Pagkakita ni Jesus kandin, pigtawag din aw ikagi to “Laginà, ka-uli-i kad on to sakit nu.” ");
INSERT INTO did_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Dayun pigdampon din aw ka-uli-i aw katul-id on to bagakwang din aw sayà-sayà kandin to Diyus. ");
INSERT INTO did_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Dì to otow no nigdaa to simbahan, konad no langot su nakatambaa si Jesus to adow no konà no tigtatalabahu. To gumuguuy to kahimunan, naka-ikagi diyà to ka-otawan to “Natahinan to onom no adow kada simana no tigtatalabahu. Sikan to a-andinihay now no adow ko maliyag kow no ogka-uli-an. Konà kow ogpaka-andini to adow no konà no tigtatalabahu no awos ogpatambaa.” ");
INSERT INTO did_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Dì naka-ikagi si Jesus to “Iyu no mapakunon-kunonon no mgo otow, agad adow on no konà no tigtatalabahu, ogpambadbadan now dà to mgo buhì now awos maka-andiyà to wohig aw maka-inom. ");
INSERT INTO did_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Sikan no buyag no sugpù gayod to apù ta no si Abraham, ogkabuligan podon to kandin no kalisodan likat ki Satanas no sampuù on tag wau no tu-ig, agad adow on no konà no tigtatalabahu.” ");
INSERT INTO did_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Nahogna-an din nasikawan to mgo punu-an no kablang din to ingka-ikagi din. Dì sikan ka-otawan no puli dà no otow, namantukhow on to tibò no kaboonganan no pigpanghimu din. ");
INSERT INTO did_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Na, impananglitan ni Jesus to pagpang-anad din no nig-iling to “Nokoy to madoyow no pananglitan no ogka-angodan to pagdakoo to sinakupan to Diyus. ");
INSERT INTO did_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Sikan pagdakoo to sinakupan to Diyus, iyan na-angodan to pagtanom ta to binhì no longa no agad magabudbud dà ubag, dì paggitì, ogkahimu on no kayu aw ogkangkahapunan to manuk-manuk to sanga agad niglikat to binhì no magabudbud dà ubag.” ");
INSERT INTO did_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Kagi ni Jesus to “Nokoy pad no pananglitan no ogka-angodan to pagdakoo to sinakupan to Diyus. ");
INSERT INTO did_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Iyan na-angodan to ogpatulin to buyag to malagkit. Agad ma-intok dà to igpatulin no imba-ot din, dì ogkaponù to pigbotangan din.” ");
INSERT INTO did_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Na, nighipanow on kandan si Jesus padoog diyà to Hirusalim aw panghapit-hapit pad to kalulunsudan aw mgo kasityuhan no ogpang-anad. ");
INSERT INTO did_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Na moydu-on nig-usip ki Jesus to “Sir, dow ma-intok dà buwa to ogkabuligan to Diyus no ogpadilinon to banwa no kastiguhanan to makasasaà?” Nakatabak si Jesus to ");
INSERT INTO did_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Pamakut kow to ogsood to habangan no malig-ot, aw ognangonan ku iyu to kahan-ingi to ogkaliyag to ogsood podon, dì konà man ogpakasood. ");
INSERT INTO did_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","“Na, ko pananglitan og-andiyà kow to songo baoy dì ogtakopan on. To diyà kow pad to labas, ogtawag kow to tagbaoy to ‘Sir, ogpaponhikon koy nu,’ dì ogpaka-ikagi kandin to ‘Wadà ku katagahi dow ando-i to piglikatan now.’ ");
INSERT INTO did_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ogpaka-iling kow to ‘Natodu-on nigpagsau koy ikow aw pag-inom. Nigpang-anad ka gayod to kahimunan diyà kanami no lunsud natodu-on.’ ");
INSERT INTO did_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Dì ogtabakon din to ‘Ognangonan ku iyu to wadà ku katagahi dow ando-i to piglikatan now. Gawang kow on no mado-ot to iyu no hinang.’ ");
INSERT INTO did_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ko matuman kan no timpu, lagboy no ogpamakasinogow kow aw pagpangagot to bag-ang su ogpakasosoo kow ko makita-an now si Abraham aw si Isaac aw si Jacob aw mgo maglilikwaday to Diyus no nalabot tibò to sinakupan to Diyus. Dì iyu, ogkabugow kow pad du-on. ");
INSERT INTO did_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Dì to duma no mgo otow, ogmutmutan dan to binogdokan to langit aw ogba-ot aw tatagbuhi dan to pagko-onan to sinakupan to Diyus. ");
INSERT INTO did_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Moydu-on nakasagkop bahin to tinu-uhan kunto-on dì to mahudi no adow, ogpakababow on diyà to pigsakupan to Diyus. Moydu-on gayod nakababow kunto-on bahin to tinu-uhan, dì to mahudi no adow ogsagkop on diyà to pigsakupan to Diyus.” ");
INSERT INTO did_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Na, moydu-on mgo Parisiyu no nigdatong aw nangoni si Jesus to “Hipanow kad on su ogpahimatayan kad podon ni Harì Hirudis.” ");
INSERT INTO did_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Naka-ikagi si Jesus to “Andiya-i now kan nigpa-angod-angod to katuyù no matigpos dì matuu ogkahadok dà man. Nangoni kandin to monang ad ogkamatoy ko maponga on to igpahimu kanak. Ogpanggawang a pad to busow aw pandoyow to nangkasakit to sood pad to daduwa no adow likat kunto-on. Dì tatou kunto-on no adow, og-abut to kabahinan ku ko umabut a diyà to Hirusalim. ");
INSERT INTO did_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Kunto-on pad iyan to ogpuguton aw kun-isa to pag-abut to kanak pabilu, su tahan to maglilikwaday to Diyus, wadà kamuwahanan ko konà diyà to Hirusalim to og-abut. ");
INSERT INTO did_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Dì iyu no taga-Hirusalim, nokoy man no nigpanghimatoy kow to mgo lagsoban to Diyus aw pandogpaka now to batu to mgo maglilikwaday to Diyus. Dì ogsakupon ku podon iyu su kapila on to paghinimun-himun ku podon iyu aw pasaunga kow no iyan ogka-angodan to mangunsuy no manuk no oglangkob to unsuy din no ogpasaungon din to kamuwahanan dì nigsupak kow. ");
INSERT INTO did_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kaling man pig-oyowan kow to Diyus no nigbantoy iyu. Ognangonan ku iyu to monang a now pad mandà oggoyahon ko igkalangkoà now no ogpaka-iling kow to ‘Mabuhì to pigpatubus to Diyus no pigpa-andini din ita.’” ");
INSERT INTO did_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Na, songo adow no konà no tigtatalabahu, diyà papaningugtuha si Jesus to baoy to songo punu-an to Parisiyu no songo panon to tinu-uhan. Pigbantayan kandin lagboy to ka-otawan. ");
INSERT INTO did_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nakaba-ot du-on gayod to nasakit no otow no nigpanggub-ak to lawa din. ");
INSERT INTO did_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Nig-usip si Jesus to mgo Parisiyu aw duma no mgo mag-a-anad to tinu-uhan to “Dow tugutan kid to kasugu-an to tinu-uhan ta to pagdoyow to nasakit to adow no timpu no wadà talabahu?” ");
INSERT INTO did_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Dì wadà nakatabak. Dayun pigdawat ni Jesus kan otow no nanggub-ak to lawa. Dayun na-uli-an aw pigpapa-ulì ni Jesus. ");
INSERT INTO did_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Na nig-ikagi si Jesus diyà to ka-otawan no nangkahimun du-on to “Ko ma-uugan kow to buhì now diyà to linow, ogkabutwà now dà dayun, agad adow on no konà no tigtatalabahu.” ");
INSERT INTO did_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Wadà ingkatabak dan. ");
INSERT INTO did_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Na, na-indanan ni Jesus to pigpilì dà to mgo bisita to ogpa-ingkudan to talahudon. Dayun impananglitan din kandan no nig-iling to ");
INSERT INTO did_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ko ogpaba-oton ka to pagsauhan, konà nu ogtuwanon to ogpa-ingkudan to talahudon, su dagow makaba-ot to labow pad ikow ");
INSERT INTO did_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","aw sikan nigpa-andu-on iyu, ogdugukon ka aw ikagihi ka din to ‘Halin ka kani su moydu-on pad labow no ogpa-ingkudon ku kani,’ aw du-on ogkapa-inahan ka aw maka-ingkud diyà to masagkop. ");
INSERT INTO did_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ko ogpaba-oton kad on to pagsauhan, iyan ingkudi nu to masagkop no ingkudanan awos ko dumuguk to mgo tag-anak, og-ikagi diyà ikow to ‘Lagi, halin ka kani aw du-on ka to ingkudanan to mata-as.’ Kayan ogtahudon ka diyà to atubangan to kahan-ingan no diyà to pagsauhan. ");
INSERT INTO did_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","To otow no ogpalabow, ogsagkop nasì aw to ogpasagkop, ogpakalabow nasì.” ");
INSERT INTO did_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Na, nig-ikagi gayod si Jesus diyà to nigpaba-ot kandin to pagko-onan to “Ko oghimuhon now to pagko-onan dow pagbana-an, konà now ogpaba-oton to kadumahan now aw kasu-unan aw songo baoy now no datù su ko angod sikan, kandan, ogbaos iyu su ogkabayadan kow dan man. ");
INSERT INTO did_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Dì ko oghimuhon now to pagko-onan, ogpaba-oton now nasì to nangkawada-an to kandan kapookanan, aw mgo pawing, aw mgo pungkù aw mgo podpod aw mgo pisok ");
INSERT INTO did_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","aw kadoyawi kow to Diyus, su kandan, konà ogpakabaos. Dì ogkabaosan kow iyan ko ogpambuhayon to madoyow no mgo otow no nangkamatoy to mahudi no adow.” ");
INSERT INTO did_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Na songo otow no nakaba-ot kan no pagko-onan, nadinog din to inikagi ni Jesus aw ikagihi din to “Ah, ogkaliyag koy podon ko ogpakaba-ot koy to pagko-onan diyà to pigsakupan to Diyus.” ");
INSERT INTO did_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Dì impananglitan ni Jesus no pig-iling to “Moydu-on songo otow no nighimu to pagko-onan no dakoo aw mahan-ing to pigpamatawagan din podon. ");
INSERT INTO did_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","No pagkagotò to adow to pagko-onan, impamadokat din podon to sugu-onon din kan pigpamatawagan aw iyan impa-iling din diyà kandan to ‘Na, impadokat kow din kanak. Magagà kinow on su natibò on nahonat.’ ");
INSERT INTO did_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Dì namanbalibad tibò. To tugdow, nig-iling to ‘Pigboli kud to pasak, konà a ogpaka-andiyà. Og-aha-on ku pad to pasak. Puli on udasi to nigpatawag.’ ");
INSERT INTO did_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Nig-ikagi to duma to ‘Pigboli kud to sampuù no baka aw ka-antihi ku dà sikan. Puli on udasi to nigpatawag.’ ");
INSERT INTO did_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Nig-iling to duma pad to ‘Bayà koy pad hitu-un. Kaling man konà a ogpakatuman to ogba-ot.’ ");
INSERT INTO did_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Dayun nigpa-ulì to sugu-onon aw inangon din to mata-as din. Konad no langot to tagtu-un to pagko-onan. Pigsugù din mandà to sugu-onon din to ‘Madaas ka dà aw pangandiya-i nu to agad ando-i no pighisubaa-subaan to kalasada to lunsud aw mgo daan aw pandokata to nangkawada-an to kandan kapookanan, aw mgo pawing no otow, aw mgo pungkù, aw mgo pisok.’ ");
INSERT INTO did_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Natabak to sugu-onon din to ‘Natuman on Sir to insugù nu. Dì maluyow pad agad mahan-ing pad.’ ");
INSERT INTO did_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Nig-ikagi to tagtu-un to pagko-onan to ‘Na andiya-i pad mandà to kahilit-hilitan agad diyà to daan dow kalasada ko moy igpagkita nu, hinggata to ka-otawan awos maponù to baoy ku aw paba-ota to pagko-onan ku ");
INSERT INTO did_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","su sikan mgo otow no pigpatawagan kud ikow, wadà ogpaka-anti to pagko-onan ku.’” ");
INSERT INTO did_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Na no nang-anad si Jesus, nadumdumahan kandin to kahan-ingan. No nang-anad kandin, nig-iling kandin to ");
INSERT INTO did_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ko ogpasakup kow kanak dì konà a now ogpa-aagon diyà to amoy now aw inoy now aw asawa now aw batà now aw mgo kasu-unan now, agad iyu no kinabuhì, konà ku gayod ogkasakup iyu. ");
INSERT INTO did_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","To otow no ogpasakup kanak, ogpakasunud ogpakati-ang to kandin kinurus no litukan to iglingow to kandin dà no natagonan no maogon su nasakup ku man kandin. Ko konà kow makasunud, konà ku iyu ogkasakup. ");
INSERT INTO did_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ko pananglitan, otow no oghimu to baoy, ogtugdow ogbilang pad to gastuhonon din ");
INSERT INTO did_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","su dagow iyan dà mapongahan to pa-ukdangan, ogkasikawan kandin su puli on nakapahimu to baoy to wadà din ka-atom-atom to gastuhonon din no igù no igkaponga to baoy, aw ogkasawoy kandin to ka-otawan no ogpakakita aw kadugadi. ");
INSERT INTO did_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ogpamang-iling kandan to ‘Pigpunu-an kan no otow to paghimu to baoy din, dì wadà kandin makaponga su buguk kandin to oghimu to baoy.’ ");
INSERT INTO did_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Na, ko pananglitan mandà moydu-on songo harì no ogpikii to pagpanuyù to duma no harì. Dì ogtugdow pad ogpagsukun to katu-unan din aw iling to ‘Dow makada-og ki buwa kandan no moy kawa-an no maan no sundau, matuu ita, sampuù ki dà no maan tibò.’ ");
INSERT INTO did_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ko domdom din no konà kandin ogpakada-og, ko madiyù pad to kablang dan, ogpa-andiya-on to harì to pigpatubus din aw pahusaya no awos malinawon. ");
INSERT INTO did_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Kaling man ko ogpasakup kow kanak, ogka-oyowan now tibò to katu-unan. Ko konà, konà ku iyu ogkasakup.” ");
INSERT INTO did_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Na, impananglitan mandà ni Jesus no nig-iling kandin to “Na to asin, ogpakadoyow to sodà. Dì ko ogkawadà to katam-isan to asin, amonuhon tad to pagpapa-ulì to katam-isan to asin. ");
INSERT INTO did_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Wadad puus, agad abunu to pasak. Wadà ogpakasokod to asin ko iyan ogkawadà to nanam to asin. Ogka-oyowan tad puli. Na, indanan now to kalitukan to pig-ikagi ku.” ");
INSERT INTO did_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Na to magsusukut to buhis aw duma pad no mgo wadà tu-u to katahanan to mgo Hudiyu, ogpamanduguk du-on ki Jesus su awos ogpaminog to impang-anad din. ");
INSERT INTO did_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Dì to mgo Parisiyu aw duma no mag-a-anad to tinu-uhan to mgo Hudiyu, naman-ina-ina no namang-iling to “Sikan no otow, ogdawaton din to agad mgo otow no wadà tu-u to katahanan ta aw ogpagsau kandan gayod.” ");
INSERT INTO did_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Dì nama-anan ni Jesus to pig-ina-ina dan aw ikagi kandin to ");
INSERT INTO did_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Na, ko pananglitan iyu, moydu-on songo gatus no buhì no namamàpà. Pagpamàpà dan, natanak to sobu-uk aw oyowi now dà kan kasi-aman aw si-am diyà to pamàpa-anan aw panganapa to sobu-uk no natanak hantod to nakita-an now. ");
INSERT INTO did_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Pagkakita now, pigbakus now aw babaha no nigtukhow kow lagboy su nakita-an dà man. ");
INSERT INTO did_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Pag-ulì now, pigpanghimun now to kadumahan now aw iling kow to ‘Ogtukhow kinow dà su nakita-an ku dà to buhì ku no natanak.’ ");
INSERT INTO did_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Na ko otow no agad wadà din tu-u to katahanan now dì to paghimu din no mado-ot, ko ogkasosoan din aw oyowi, ogsubla on to pagtukhow to mgo uminugpà diyà to langit. Dì wadà ogtukhow diyà bahin to otow no konà ogpagawang to saà din. ");
INSERT INTO did_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Na, ko pananglitan gayod no moydu-on songo buyag no sampuù to sapì no buwawan. Dì natanakan to songo bu-uk. Agad madukilom on, ogpadokotan to ilawan din aw sin-igi to saad to baoy aw panganapa din lagboy hantod to ogkita-on din. ");
INSERT INTO did_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Pagkakita din, ogtawagon to kadumahan din aw ikagi to ‘Ogtukhow kinow dà su nakita-an ku dà to sapì ku no buwawan no natanak.’ ");
INSERT INTO did_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Angod dà man to innangon ku iyu to ogpamantukhow to Diyus aw mgo diwata din, agad sobu-uk no makasasaà, ko makasosoo kandin to pighimu din no mado-ot aw oyowi. ");
INSERT INTO did_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","“Na, ko pananglitan mandà to otow no moydu-on daduwa no batà no lukos. ");
INSERT INTO did_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nig-iling to hadi diyà to amoy din, ‘Amoy, to kanak handug no igkapangumbilin nu kanak, bogayi a nud nasì kunto-on.’ Dayun pigpanghandug to amoy to kadatù din. ");
INSERT INTO did_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Na, pagkapilahi no adow sikan nadawat to hadi, pigpabayluhan din on to sapì aw hipanow on kandin padoog diyà to banwa no madiyù aw du-on din tanama gastuha to sapì din no puli inminaliyag din. ");
INSERT INTO did_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Pagka-ubus to sapi din du-on sikan no banwa, pigkogsa-an to bontas aw kandin, niglotoy. ");
INSERT INTO did_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nakapikii on kandin to ogsood to talabahu no magtutubung to babuy. ");
INSERT INTO did_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Tantu no paglotoy din, ogko-on podon kandin to mgo ukap no tutubungay to babuy. Dì wadà nigka-at kandin su wadà nigbogoy diyà kandin. ");
INSERT INTO did_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Dì pagdoyow to domdom din, na-iling to pikii din to ‘To mgo inadlaw ni Amoy, ko ogpamango-on, dakoo pad to ogkasubla agad mahan-ing kandan. Dì aboy kanak no nakadayò no ogkamatoy-matoy ad to bontas. ");
INSERT INTO did_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Og-anti ad ogpa-ulì ki Amoy aw og-ikagi a diyà kandin to, Amoy, nakasaà ad ikow aw diyà to atubangan to Diyus. ");
INSERT INTO did_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Konà a nud oghimuhon no anak a nu. Puli a nud himuha no inadlaw nu.’ ");
INSERT INTO did_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Na nig-ulì kandin diyà to amoy din. “Dì no madiyù pad, nakita-an on kandin to amoy din aw ka-ati dà ubag kandin. Nakadagap to amoy to batà aw gogoa aw kapanghadoki din. ");
INSERT INTO did_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Naka-ikagi kan anak to ‘Amoy, nakasaà a ikow aw diyà to atubangan to Diyus. Konà a nud oghimuhon no anak nu.’ ");
INSERT INTO did_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Dì nigsugù to amoy to sugu-onon din to ‘Madaas ka dà aw daaha to kabò no kinalabawan no igpapangabò ku to batà ku aw isu-uu to singsing aw ogsapatusan ku. ");
INSERT INTO did_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Iyan puduton nu kan nati to baka no matabà aw himatayi nu su oghimuhon ta no pasalamat aw ogliliyag kinow tibò. ");
INSERT INTO did_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","So-idi batà ku, iyan on na-angodan to namatoy on, dì pigbuhoy dà. Iyan napadihuhan gayod to natanak, dì nakita-an dà.’ Na du-on namanliliyag kandan tibò. ");
INSERT INTO did_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Dì to kakoy no nali-us on pag-ulì to hadi din, nig-ulì on no diyà pu-un to uma. No pagkadani din to baoy, iyan on nadinog din to mgo patanugonon aw katad-katad to sayow. ");
INSERT INTO did_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Dayun pigtawag din to songo sugu-onon aw usipa dow nokoy to napugutan dan. ");
INSERT INTO did_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Na-iling to ‘Nig-ulì on to hadi nu. Nighimatoy to amoy nu to nati to baka no matabà su impagala su nigpasalamat su naka-ulì dà to batà din no ampan pad halinan.’ ");
INSERT INTO did_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Dì nasawà to kakoy hantod to konà ogsood kandin to baoy. Impadokat podon to amoy din aw pangamuyù to ogpaba-oton to pagliliyag dan. ");
INSERT INTO did_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Dì naka-ikagi to kakoy to ‘Amoy, napugutan on iyan to mahan-ing no tu-ig to pagbulig ku ikow aw tumana to sugù nu tibò. Dì ampan a nu bogayi to buhì, agad ma-intok no igkaliyag ku to mgo kapadihu ku. ");
INSERT INTO did_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Dì sikan pinadaoyag nu no batà no nig-uwak puli to ingkabuhì nu aw nigpanghilabot to buyag no mado-ot, no pag-ulì din, pigpagalahan nu nasì aw pahimatayi nu pad to buhì nu no matabà.’ ");
INSERT INTO did_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Dì naka-ikagi to amoy to ‘Dì Utù, ikow, timbang ku man no nigdumduma ka kanak aw kalabot kad to tibò no katu-unan ku. ");
INSERT INTO did_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Dì hustu dà man to ogliliyag kinow on aw pamantukhow su hadi nu, iyan on na-angodan to namatoy no tagbayà pigbuhoy dà. Iyan na-angodan din gayod to natanak dì nakita-an dà.’” ");
INSERT INTO did_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Na impananglitan ni Jesus to mgo sakup din no nig-iling to “Songo datù, moydu-on pigpabantoy to sapì din. Dì moydu-on nignangon to datù to pigsalinan to sapì to otow no pinabantoy din. ");
INSERT INTO did_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Pigpaduguk kandin to datù aw ikagihi to ‘Dow tùtu-u to nadinog ku bahin to pagpansalin nu? Ahà ki to mgo listahan to pagbayad aw kan ogkadawat su oggawangan ku ikow to katondanan no pinabantoy to sapì ku.’ ");
INSERT INTO did_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Dì to nigbantoy to sapì, na-iling du-on to ginhawa din to ‘Amonu a buwa so-idi su oggawangan ad to datù to katondanan ku. Maotoy to lawa ku. Konà a gayod ogpakatalabahu to mabogat aw ogkasikow ad to ogpalimus. ");
INSERT INTO did_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Na moydu-on nadomdom ku no ogkahimu ku awos ad madawat diyà to duma no mgo baoy ko magawangan ad to katondanan ku.’ ");
INSERT INTO did_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Dayun pigpantawag din to moydu-on mgo utang diyà to mata-as din. Nig-iling kandin diyà kan tugdow to ‘Man-u buwa to utang nu diyà to datù.’ ");
INSERT INTO did_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nigtabak kandin to ‘Daduwa no gatus no ka-lata to lana.’ Nig-iling to nigbantoy to sapì to ‘So-idid to kamatu-udan to pagsasabut. Na, madaas nud ilisi to kamatu-udan aw isulat nu du-on to songo gatus dà to utang nu.’ ");
INSERT INTO did_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Na pig-usip mandà to duma to ‘Man-u buwa to utang nu diyà to datù.’ Nigtabak kandin to ‘Lima no gatus no ka-saku to bogas.’ Nig-iling mandà to nigbantoy to sapì to ‘So-idid to kamatu-udan to pagsasabut. Ilisi nud to kamatu-udan aw isulat du-on to upat dà no gatus no saku to utang nu.’ ");
INSERT INTO did_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Na to datù, nakasayà dà to pinabantoy din to sapì agad maluku-lukuhon dì mapandoy dà to ogpadaan-daan to kandin kadoyawan su iyan tùtu-u to kunto-on no timpu, to mgo otow dini to babow no wadà tahud to Diyus, mapandoy pad kandan diyà to mgo mangkatahud-tahudon no otow diyà to Diyus to ogpadaan-daan to kandan kadoyawan. ");
INSERT INTO did_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Kaling man indanan now to pig-ikagi ku iyu, to kadatù now no kalibutanon, oggastu kow no igbulig now to kasing-otow now su ogka-uyunan kow to Diyus ko maka-atan now kandan aw ogkadawat kow din diyà to langit to mahudi no adow ko wadà ogkaboli to sapì. ");
INSERT INTO did_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Na to otow no ogkasaligan to ma-intok, ogkasaligan gayod to ma-aslag. Dì to otow nò konà ogkasaligan to agad ma-intok, wadà igkasalig ta no ma-aslag. ");
INSERT INTO did_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ko wadà kow kasaligi to kadatù dini to babow, konà kow gayod ogkasaligan to kadatù no tùtu-u diyà to langit. ");
INSERT INTO did_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ko konà kow ogkasaligan to ogbantoy to kadatù to duma dini to babow, amonuhon man to pagkasalig to Diyus ìyu to iyu no kadatù diyà to langit. ");
INSERT INTO did_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“To otow, konà ogkahimu no daduwa to pigtagonan din su ogkablangon din iyan to sobu-uk aw sobu-uk, ogpa-aag-aagon din on. Matinumanon gayod diyà to sobu-uk, matuu kan sobu-uk, og-oyowan din on. Konà ta ogpagtokapon to pagtagon ta, Diyus aw kadatù.” ");
INSERT INTO did_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Na to mgo Parisiyu no ogkaliyag to kadatù, nigpaminog to intutuu ni Jesus, tibò namandugadi kandin. ");
INSERT INTO did_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Dì nig-ikagi si Jesus diyà kandan to “Iyu no mapakunon-kunonon no mgo otow, ogpatahud kow dà podon to ka-otawan. Dì diyà to atubangan to Diyus, konà kow ogka-uyunan su nama-anan din man dow nokoy diyà to sood to ginhawahan now su to ogpa-aag-aagon to otow, ogsawayon iyan to Diyus. ");
INSERT INTO did_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Na impatuman to Diyus to ka-otawan to kasugu-an ni Moises aw kasulatan to duma no mgo maglilikwaday to Diyus hantod to si Juan on to pigpalikwad. Likat to paglikwad ni Juan no Magbobonyagay sikan Madoyow no Tutuwanon bahin to madaas og-abut to pagsakup to Diyus, mgo otow nigpogos podon to ogdangon to pagsakup to Diyus agad-agad to kandan dà no napikiyan. ");
INSERT INTO did_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Dì bahin to ogkawadà to kasugu-an ni Moises aw duma no kasulatan, konà ogkahimù to ogkawadà ko konà pad matuman tibò. Kalangitan aw kapasakan, ogkangkawadà. Dì kasulatan to Diyus, agad songo kudlis dà, konà ogkawadà ko konà pad ma-una matuman. ");
INSERT INTO did_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Na, to otow ko og-oyowan din to kandin asawa no una aw pangasawa to bugtì, ogpakasaà su ogkalap-angan din to pag-a-asawa dan. To og-asawa gayod to buyag no na-oyowan to una no bana din, ogpakasaà gayod su ogkalap-angan din gayod to kandan pag-a-asawa no wadà kalabotan din.” ");
INSERT INTO did_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Na, impananglitan ni Jesus to impang-anad din no pig-iling to “Na moydu-on datù no ogpangabò to mahal aw kanunoy dakoo to pagko-on du-on to baoy din. ");
INSERT INTO did_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Moydu-on gayod otow no nawada-an to kapookanan din. Iyan ngadan din si Lazaro. Nakahibat-hibat diyà to li-otanan to ugpa-anan to datù. Pig-ugudan ");
INSERT INTO did_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","aw dila-i to mgo idù to mgo laù din. Ogko-on podon si Lazaro to puyapud no nangka-uug diyà to ko-onanan to datù. ");
INSERT INTO did_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Na pagkaugoy-lugoy namatoy on si Lazaro aw kadaa to umagad din to mgo diwata to Diyus diyà ki Abraham no apù ta lagboy no diyà to botanganan to mangkadoyow no mgo otow. Na namatoy on gayod to datù aw ilobong. ");
INSERT INTO did_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Dì umagad din, imbotang diyà to kastiguhanan to saà. No kanunoy no ogkasakitan kandin, niglanghag diyà to langit aw kakita-i si Abraham diyà to madiyù aw si Lazaro no nigsoso-ing. ");
INSERT INTO did_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Tinawag to datù to ‘Apù Abraham, ogka-atan a nu. Ogpa-andinihan a nu ki Lazaro. Igatang ogpabìbi-an nu kandin to kanak dilà no pigtahayan on su lagboy on to paglanggahi ku su nadangka a so-idi logdog.’ ");
INSERT INTO did_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Dì nigtabak si Abraham to ‘Wadà nu buwa kalingawi ton buhì ka pad Apù no madoyow man to kabotang nu. Dì si Lazaro, nalisodan. Dì madoyow on to kabotang din kunto-on. Dì ikow, napasu-an kad on to logdog to kayu kunto-on. ");
INSERT INTO did_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Hognà pad moydu-on dama diyà to pag-ootan ta no konà ta ogkalawangan su sikan on to igkahibugtì ta.’ ");
INSERT INTO did_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Naka-ikagi to datù to ‘Igatang ogpangamuyù a ikow Apù to ogpa-andiya-on nu si Lazaro diyà kandan aw ki Amoy. ");
INSERT INTO did_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Moydu-on lima no su-un ku no igpabahog kud ko maka-andini kandan so-idi ogpanakitan to kayu no logdog.’ ");
INSERT INTO did_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Dì nakatabak si Abraham to ‘Ogpaka-anad kandan to kasulatan ni Moises aw duma no maglilikwaday.’ ");
INSERT INTO did_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Naka-ikagi to datù to ‘Konà man Apù Abraham. Dì ko ma-andiya-an kandan podon to otow no pigbuhoy on, ogpakapaminog aw oyowi to kandan paghimu no mado-ot.’ ");
INSERT INTO did_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Nakatabak si Abraham to ‘No wadà dan paminog to kasulatan ni Moises aw duma no maglilikwaday to Diyus, konà dà gayod ogpaminog agad moydu-on oglogwà no pigbuhoy on.’” ");
INSERT INTO did_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Na impang-anad mandà ni Jesus to mgo sakup din no pig-iling din to “Tahan to otow no ogbogayan to pa-antihan dow ogpakasaà. Dì aboy to otow ko ogpasaa-on din to duma. ");
INSERT INTO did_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","To ogpasuwoy to agad ma-intok no otow, mahawoy dà ko pa-usbugon kandin diyà to dagat no oglawigan to batu to li-og. Dì malisod lagboy ko kastiguhon kandin to Diyus to mahudi no adow. ");
INSERT INTO did_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Na, doydoyow kow. Ko ogpakasaà to su-un now, udlinan now. Ko makasosoo kandin to paghimu din no mado-ot aw oyowi, ogpasayluhon now dà. ");
INSERT INTO did_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Agad makasaà diyà iyu to kapitu to songo adow, dì pasayluhon now dà ko og-inandu-on iyu aw pangamuyù kandin no nig-iling to ‘Nakasosoo a, pasayluhon a nu dà iyan,’ na iyu, pasayluha now dà man gayod.” ");
INSERT INTO did_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Na to mgo pangabaga ni Jesus no tumutubus din, namang-ikagi diyà kandin to “Ogdugangan nu to pagtu-u noy.” ");
INSERT INTO did_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Naka-ikagi si Jesus to “Ko moydu-on pagtu-u now no agad magabudbud dà, ogkasugù now so-idi madigon no sikumuru no kayu to ‘Mabukad kad aw kahalin kad diyà to dagat aw diyà ka katanom,’ aw ko og-aha-on ta, ogkatuman iyan. ");
INSERT INTO did_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Na ko pananglitan, moydu-on sugu-onon now no pigpagaas now dow pigpabantoy now to mgo buhì now. Ko mahapun on, og-ulì diyà to baoy. Ko dumatong on to sugu-onon now, dow konà kow buwa og-iling to ‘Na Sir, ingkud ka su oghonatan ku ikow.’ ");
INSERT INTO did_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Konà man buwa, su og-iling kow on buwa nasì to ‘Na, lutu-i a nu aw honati a. Ko makatapus ad to pagko-on aw pag-inom, ikow on ogpakasukoli kad ogpakako-on aw maka-inom.’ ");
INSERT INTO did_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Dow wadad buwa pasalamat kandin to sugu-onon din su natuman din to insugù din. ");
INSERT INTO did_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Iyu, angod dà iyan su ko matuman now on to insugù ku iyu, ogka-iling now to ‘Konà koy no saya-onon su natongop dà to natuman noy no insugù nu kanami.’” ");
INSERT INTO did_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Na no nigpadayong kandan si Jesus padoog diyà to Hirusalim no lunsud, nakadatong kandan diyà to pag-ootan to Galiliya aw Samariya. ");
INSERT INTO did_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","No pagkasood dan to songo lunsud, pigsungun kandan to sampuù no ka-otow no pigpan-ibung dì nigpamatiwoy kandan ki Jesus ");
INSERT INTO did_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","aw puli tawag kandan to ma-agbot to “Jesus, Magbobo-ot, ogka-atan koy nu.” ");
INSERT INTO did_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Pagkasunglà din, nig-ikagi kandin to “Andiya-i now to punu-an to tinu-uhan no nigtubus iyu diyà to atubangan to Diyus awos ma-ahà to sakit now dow magawang.” No paghipanow dan on, nangka-uli-an on man tibò kandan. ");
INSERT INTO did_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Na pagkita to sobu-uk to na-uli-an on kandin, nigpatipa-ulì kandin diyà ki Jesus aw sayà-sayà to Diyus to ma-agbot. ");
INSERT INTO did_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Nakaluhud kandin diyà to atubangan ni Jesus no nigpasalamat. Songobu-ukon dà kandin no nig-ulì aw pasalamat aw kandin iyan to taga-Samariya. ");
INSERT INTO did_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Naka-iling si Jesus to “Dow konà buwa no sampuù kow no na-uli-an? Ando-id pamandoog ton si-am no ka-otow. ");
INSERT INTO did_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Dì so-idi, taga-Samariya man, aw kandin dà to nigpa-ulì aw saya-sayà to Diyus.” ");
INSERT INTO did_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Pig-ikagihan ni Jesus kan taga-Samariya no na-uli-an on to “Na, sakindog kad on aw ulì kad on su na-uli-an kad man su nigtu-u ka man kanak.” ");
INSERT INTO did_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Na kandan no mgo Parisiyu, naman-usip kandan ki Jesus dow kagan-u to og-abut to pagsakup to Diyus. Nigtabak si Jesus to “To ogpunu-an to pagsakup to Diyus, konà ogkakita-an to mata to gi-otawan puli. ");
INSERT INTO did_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Konà ogka-iling to ‘Ahà ka su so-idid.’ Konà gayod ogka-iling to ‘Ahà ka, suyad on,’ su pagpunù to pagsakup to Diyus, nig-abut on dini iyu su diyad on to sood to otow agad wadà now kama-ani lagboy to nakasood on.” ");
INSERT INTO did_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Na pagkaugoy-lugoy nigpanoysoy mandà si Jesus to mgo sinakupan din bahin to pag-abut to pagsakup to Diyus to ogkamotow-motawan on lagboy ogkakita-an. Kagi din to “To mahudi no adow, ogkaliyagan now on podon to ogpunù on to pagsakup to Tumutubus to Ka-otawan dì konà now pad ogkakita-an dì ogkatagadan now dà kanunoy. ");
INSERT INTO did_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Moydu-on og-iling iyu to ‘Ahà ka, suyad on to pigsakupan to Diyus.’ Dì konà kow ogtuman og-andiyà aw konà kow ogpasakup ");
INSERT INTO did_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","su ko kanak on to umulì, konà now oglamanon su mapayag dà su angod to ogkiblat no kilat no ogpakatang-ow to binogdokan tibò to langit. Angod dà man to adow to pag-ulì ku no Tumutubus to Ka-otawan. ");
INSERT INTO did_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Dì ogkalisodan a pad aw oyowi a to mgo kadongan ku. ");
INSERT INTO did_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ton kadodoog to ka-otawan natodu-on no timpu pad ni Noe no mangudlinay to Diyus, ogka-angod dà man to kadodoog to ka-otawan to umulì a dini no Tumutubus to Ka-otawan ");
INSERT INTO did_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","su to ka-otawan natodu-on no wadà pad ugubi to kalibutan, iyan dà pighimu dan to kandan natungahan no ogko-on aw og-inom aw inasawahay agad hantod to namansood on kandan aw si Noe diyà to arka din. Pag-ugub to dagat, nangkaponas tibò to ka-otawan ton wadà mamakasood to arka. ");
INSERT INTO did_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","To mahudi no adow no ogsakup to Tumutubus to Ka-otawan, angod dà gayod to mgo timpu no katu-igan ni Lut su mgo ka-otawan, tinuman dan to katahanan to otow no pagko-on, pag-inom, pagboli, pagbaligyà, pagtanom, aw paghimu to baoy. ");
INSERT INTO did_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Dì adow to pagkali-us ni Lut to lunsud to Suduma, pig-abutan sikan no lunsud to logdog aw maliyab-liyab no asupri no niglikat to langit aw kangka-ubus to tibò no otow du-on. ");
INSERT INTO did_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Angod dà to adow to Tumutubus to Ka-otawan to lumogwà no ogpakatokow puli no ogpakado-ot to mgo otow no mangkado-ot. ");
INSERT INTO did_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Na kandà no timpu to otow no diyà to labas to baoy, konà din on ogka-ulì to katinguban din dì puli on ogpakalaguy kandin. Ko diyà kow to uma, konà kow on gayod ogpakapa-ulì diyà to baoy. Dì puli kow on ogpakalaguy nasì. ");
INSERT INTO did_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Konà now ogkalingawan to nadoog-doogan to asawa ni Lut no pagkalingì din to nali-usan din, dayun nigbauy kandin no tibu-uk no asin. ");
INSERT INTO did_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","To otow no ogpa-aagon din to kandin kinabuhì, ogkawada-an man nasì. Dì to otow no konà din ogpa-aagon to kinabuhì din, wadà ka-usabanan to mahudi no adow. ");
INSERT INTO did_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ognangonan ku iyu to matuman kan no kadukiloman no pag-abut to Tumutubus to Ka-otawan, ogkahuhulid pad to daduwa no ka-otow. Dì puli on ogboongon to sobu-uk no ogbayawon ku aw kabitas kan sobu-uk. ");
INSERT INTO did_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","To ogbayu no og-a-asod, ogboongon to sobu-uk no ogbayawon ku aw kabitas kan sobu-uk. ");
INSERT INTO did_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","To daduwa diyà to uma, ogboongon to sobu-uk no ogbayawon ku aw kabitas kan sobu-uk.” ");
INSERT INTO did_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Na to mgo pangabaga ni Jesus, namaka-ikagi kandan to “Ando-i Sir dapit to ogdo-og no banwa to innangon nu.” Impananglitan ni Jesus to intabak din no pig-iling to “Agad ando-i to nahaù, og-agad dà ogdagsà to kuligi su agad ando-i no otow no mado-ot to ginhawahan, og-agad dà ogpakadawat to impang-anad no kagau-an.” ");
INSERT INTO did_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Na, impananglitan mandà ni Jesus to impang-anad din to mgo sakup din bahin to og-ampù kandan aw wadà pagbungkù. ");
INSERT INTO did_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Kagi din to “Moydu-on punu-an to lunsud no wadà tahud to Diyus aw otow. ");
INSERT INTO did_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Moydu-on bau no buyag diyà kan no lunsud no nig-inandiyà kan punu-an aw pinangamuyù no nig-iling to ‘Igpakastigu ku ikow to kablang ku.’ ");
INSERT INTO did_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Nig-oyow to punu-an to pagbulig. Dì to kaugayan na-iling to tu-un din no domdom to ‘Agad wadà pagtahud ku to Diyus aw diyà to otow, ");
INSERT INTO did_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","dì ogpatumanan ku nasì to pigpangamuyù din bahin to kablang din su nabuung ad to pagpangamuyù din.’ ");
INSERT INTO did_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Na, ko bumulig dà kan punu-an, agad wadà pagtahud din on to Diyus aw otow, ");
INSERT INTO did_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","woynu pad to kasakupan to Diyus, ogbuligan dà man su pigpilì din on aw ogpangamuyu-an dan adow aw madukilom to pagpakastigu. ");
INSERT INTO did_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Madaas din iyan ogkastiguhon. Dì ogpaka-usip a iyu to man-u pad buwa to mgo otow dini to babow to kalibutan no ogtu-u pad dini kanak aw ampù to Diyus to umulì ad no Tumutubus to Ka-otawan to mahudi no adow.” ");
INSERT INTO did_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Na, impananglitan mandà ni Jesus bahin to mgo otow no nigsalig dà to kandan tu-un no pighimu no madoyow, dì to duma no otow, pigsawoy dan. ");
INSERT INTO did_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Kagi din to “Moydu-on daduwa no ka-otow no nig-andiyà to simbahan su og-ampù to Diyus. Sobu-uk, Parisiyu no matagon-tagonon to kandan katahanan agad kama-intokanan. Kan sobu-uk, magsusukut to buhis no wadà tu-u to katahanan dan. ");
INSERT INTO did_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","To Parisiyu no nigpasowsobu-uk, nigsakindog aw langhag no nigpanawag-tawag to Diyus aw langub kandin iling to ‘Diyus ku, nigpasalamat a ikow su kanak, wadà a maka-angod kandan no duma no angod to mgo otow no logodon, aw mgo magluluku, aw ogpanghilabot to duma, agad suyà gayod no magsusukut to buhis, wadà a makapadihu to kandin igbayà. ");
INSERT INTO did_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Pigtagonan ku gayod to pu-asa to kadaduwa kada simana aw bogoy a diyà to Diyus to ogsinampuu-an ku to tibò to ogkadawat ku.’ ");
INSERT INTO did_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Dì to magsusukut to buhis no agad wadà tu-u to katahanan, dì nigpadiyù-diyù diyà to mgo magsisimbahay aw wadà langhag diyà to langit aw iyan dà nahimu din to nakadadabu to kandin dagaha to pagkapook-pook din to kandin saà aw maka-iling to ‘Diyus ku, ka-ati a nu dà podon su makasasaà a man tahan.’ ");
INSERT INTO did_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Na, ognangonan ku iyu to tawoy kan magsusukut to buhis no wadà tu-u to katahanan, na-uyunan nasì to Diyus. Dì to Parisiyu, wadà man ka-uyuni kandin. To otow no ogpalabow, ogsagkop nasì. Dì to ogpasagkop, ogpakalabow nasì.” ");
INSERT INTO did_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Na, moydu-on namandaa diyà ki Jesus to mgo batà dan no awos igpadampon dan ki Jesus. Dì pagkakita to mgo pangabaga din, pigsasapadan dan podon. ");
INSERT INTO did_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Dì pighimun ni Jesus to mgo pangabaga din aw ikagi to “Ogpadugukon kud to mgo batà. Konà now ogbalatakon kandan su to sinakupan to Diyus iyan ogka-angodan sikan mgo batà no mgo hanuut. ");
INSERT INTO did_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ognangonan ku iyu gayod ko konà kow ogpa-angod to batà no hanuut, konà kow ogpakasood to pigsakupan to Diyus.” ");
INSERT INTO did_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Na, moydu-on punu-an to tinu-uhan to mgo Hudiyu no nig-iling diyà ki Jesus to “Sir, su matuwadong ka, moydu-on ig-usip ku ikow. Nokoy to matuwadong no ogkahimu ku awos mabogayan a to kinabuhì no konad ogkawadà.” ");
INSERT INTO did_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Nakatabak si Jesus to “Nokoy man no pighingadanan a nu to matuwadong, su Diyus dà man to matuwadong lagboy tibò. Wadà duma. ");
INSERT INTO did_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nama-anan nu to kasugu-an to Diyus no pig-iling to ‘Konà ka ogpanghilabot to duma, konà ka ogpanghimatoy, konà ka ogpangawat, konà ka ogbotang-botang. Igtahud nu to amoy aw inoy nu.’” ");
INSERT INTO did_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Naka-ikagi to punu-an to tinu-uhan to “Sir, sikan no kasugu-an to Diyus, sikan on iyan to tahan kanak nagimatahan. Likat to pagkabatà ku, natagonan kud iyan lagboy sikan.” ");
INSERT INTO did_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nig-iling si Jesus to “Moydu-on pad sobu-uk no wadà nu pad katuman. Ipambaylu nud to sapì to tibò to mgo katu-unan nu no tingub aw ipamogoy diyà to mgo nangkawada-an su agun mahina-atan ka to Diyus to ayama-an nu diyà to langit. Pagkapamogoy nu ulì kad dini aw pasakup kad bali kanak.” ");
INSERT INTO did_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Pagkadinog to punu-an to pig-ikagi ni Jesus, naduyong-ot on to ginhawa din su datù man kandin. ");
INSERT INTO did_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Na no pag-ahà ni Jesus diyà to punu-an, nig-ikagi kandin to “Kalisod iyan to mgo datù no konad podon ogpasakup to Diyus. ");
INSERT INTO did_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Malisod iyan to otow no ogpasakup to Diyus ko ogsalig to kadatù din. Dì to kamilyu no kina-aslagan no buhì, mahawoy dà nasì ko ogpalusuton du-on to lugì to dagom. Dì to ma-aslag no otow no datù, malisod ko ogpasakup podon diyà to Diyus.” ");
INSERT INTO did_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Namaka-iling kan nakadinog kandin to “Ko tùtu-u sikan, intawa man dapit to ogbay-awon to Diyus.” ");
INSERT INTO did_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Nakatabak si Jesus to “Ko otow dà, konà ogka-amu, dì to Diyus, ogka-amuhan din tibò, agad ma-aslag no datù dì ogkabay-ow dà gayod.” ");
INSERT INTO did_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Naka-ikagi si Pedro to “Sir, pig-oyowan noy on man to katu-unan noy tibò aw duma koy on ikow.” ");
INSERT INTO did_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Si Jesus, nig-ikagi to “Ko ma-oyowan now on to baoy dow asawa dow kasu-unan dow ginikanan dow mgo batà ugpat kanak aw ugpat gayod to pigsakupan to Diyus, ");
INSERT INTO did_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ogkadawat now agad man-u kunto-on aw to mahudi no adow, ogkadawat now to kinabuhì now no konad ogkawadà.” ");
INSERT INTO did_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Na, no namanghipanow kandan si Jesus padoog diyà to Hirusalim, pigpaduguk din to mgo pangabaga din no sampuù tag duwa aw tongopi din to pag-ikagi no nig-iling to “Moydu-on ignangon ku iyu tibò. Ogpaka-andiyà kid mandà to Hirusalim aw tibò to nasulat to mgo maglilikwaday to Diyus natodu-on bahin to Tumutubus to Ka-otawan, ogkatuman on, ");
INSERT INTO did_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","aw ogdaahon kandin diyà to taga-Ruma no nakasakup ita. Og-ina-inahon aw pasikawi aw ilobi. ");
INSERT INTO did_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ogbunaan aw himatayi. Dì pagkatatouhi no adow, ogbuhayon dà kandin.” ");
INSERT INTO did_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Dì wadà nadaagan dan no pig-ikagi ni Jesus. Nadaoman kandan to litukan aw wadà dan kadaagi. ");
INSERT INTO did_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Na, no madani on kandan si Jesus to Hidiku no lunsud, moydu-on pisok no otow no puli nig-i-ingkuday diyà to tibi to daan no baya-anan ni Jesus. Nigpalimus kandin to sapì. ");
INSERT INTO did_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","No pagkadinog to pisok to namanbayà to kahan-ingan, naka-iling kandin to “Dow nokoy buwa so-i.” ");
INSERT INTO did_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Pignanangonan dan kandin to “Si Jesus no taga-Nasarit to ogbayà kani.” ");
INSERT INTO did_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Pagkasabut to pisok to si Jesus on iyan to ogbayà, nig-ikagi kandin to ma-agbot to “Jesus no sugpù todu-on harì no si David, ka-ati a nu podon.” ");
INSERT INTO did_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Moydu-on mgo otow no diyà to unahan ni Jesus no namansapad podon to pisok no ogpapahonokon dan podon. Dì wadà paminog kandin. Nasì on ogpadugangon din to pagtawag su awos madinog ni Jesus aw inulit-ulita din to “Sugpù ni David, ka-ati a nu podon.” ");
INSERT INTO did_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Pagkadinog ni Jesus, nigsigkon kandin aw paduguka din to pisok. No pagkaduguk din, inusip ni Jesus to ");
INSERT INTO did_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Nokoy ngadana to ogpabuligan nu kanak.” Nigtabak to pisok to “Sir, ma-uli-an a nu podon to mata ku.” ");
INSERT INTO did_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Nig-ikagi si Jesus to “Ogka-uli-an kad on su nigtu-u ka kanak.” ");
INSERT INTO did_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Na na-uli-an on dayun to pisok aw dumduma on kandin no nigsayà-sayà kanunoy kandin to Diyus aw mgo ka-otawan no namakakita, namansayà-sayà gayod to Diyus. ");
INSERT INTO did_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Na, namansood kandan si Jesus to Hidiku no lunsud. No namanbayà kandan du-on, ");
INSERT INTO did_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","moydu-on punu-an to magsusukut to buhis no datù no otow no iyan ngadan din si Sakiyu. ");
INSERT INTO did_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ogkaliyag kandin podon to igatang ogkita kandin to tùtu-u no goya ni Jesus dow ma-amonu. Dì ogpag-ali kandin awos ogkita ki Jesus su kandin, masagkop man aw gayod mahan-ing no otow no nahimun. ");
INSERT INTO did_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Kaling man pig-oyowan ni Sakiyu to kahan-ingan aw laguy diyà to unahan. Namonhik to kayu no matikang no pighingadanan to sikumuru no ogtagadan din su awos ogdomoan din si Jesus no oglaboy du-on. ");
INSERT INTO did_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","No diyad on saom si Jesus to kayu no pigpamonhikan ni Sakiyu no ogtagadan din, niglanghag si Jesus aw ikagi to “Sakiyu, madaas ka ludus su ogpaka-agpot a diyà ikow kunto-on no adow.” ");
INSERT INTO did_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nakapatiludus dayun si Sakiyu aw dawata si Jesus no lagboy on pagtukhow din. ");
INSERT INTO did_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Dì pagkakita to kahan-ingan, nabaaw-baawan dan si Jesus aw ikagi to “Nokoy man buwa no nigduguk si Jesus to otow no wadà tu-u to katahanan ta.” ");
INSERT INTO did_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Na nigduguk si Sakiyu aw ikagi kandin diyà ki Jesus to “Sir, igbogoy kud on to tongà to katu-unan ku diyà to nawada-an. Ko moydu-on pigluku ku, ig-ulì ku to ka-upat.” ");
INSERT INTO did_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Nig-iling si Jesus to “Kunto-on no adow ogkalipwasan on tibò to mgo sood so-idi baoy nu su iyu gayod to kasinugpu-an ni Abraham, agad nahimu no wadà tu-u to katahanan, ");
INSERT INTO did_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","su kanak no Tumutubus to Ka-otawan, iyan ing-andini ku su ogpanganap a to natanak-tanak aw lipwasi ku.” ");
INSERT INTO did_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Na no pagpaminog to kahan-ingan, impananglitan ni Jesus bahin to pagpapunù to pagsakup to Diyus dini to kalibutan to mahudi no adow su madani on kandan to Hirusalim, su intobo-ot to ka-otawan dow imomo-ot on to ogpunu-an. ");
INSERT INTO did_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Nig-iling si Jesus to “Na, moydu-on otow no ma-aslag no nig-andiyà to mata-as-ta-as pad diyà to madiyù no banwa su awos makadawat to katondanan din no ogkahimu kandin no magbobo-ot ko maka-ulì du-on to kandin tahan no banwa. ");
INSERT INTO did_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","To wadà pad kandin hipanow, pigpamatawagan din pad to sampuù no sugu-onon din. Impamogoy din to kada sobu-uk tag songo maan aw sugu-a din to ‘Na, impama-utang now so-idi tibò to duma now no mgo sakup dini agun tumulin hantod to pag-uli ku.’ ");
INSERT INTO did_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Dayun nighipanow on kandin no ma-aslag no otow padoog diyà to mata-as-ta-as pad. Dì to duma din no mgo sakup diyà to nali-usan din, pigkablang dan aw oyow kandin no iyan ogkahimu no magbobo-ot diyà kandan. Kaling man nigpilì kandan to mgo otow no ogpatubuson dan aw sugu-a dan diyà to hangadonon dan pad. Sikan impadaa dan no kagi kan pinatubus dan to ‘Oyow koy ko iyan ogpakasakup kanami sikan no otow.’ ");
INSERT INTO did_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Dì wadà tu-u kan mata-as, nasì din on pigbogayan to katondanan aw du-on din ibotang kan no banwa. “Na, pagdatong din, pigpamatawagan din kan sampuù no pigpamogayan din to sapì agun din matagahan dow nigtulin on likat to pagpa-utang dan. ");
INSERT INTO did_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Na, nigdatong to tutugdawon no pigbogayan aw nangon to ‘Sir, sikan sobu-uk no imbogoy nu kanak, nadugangan. To kasampuù tulin.’ ");
INSERT INTO did_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Na-ikagi to magbobo-ot din to ‘Ah, madoyow su matinumanon ka no sakup. Su matinumanon ka to ma-intok, ogpasakupon ku ikow to ma-aslag no sampuù no ka-lunsud.’ ");
INSERT INTO did_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Nignangon to ikaduwa. ‘Sir, sikan sobu-uk no imbogoy nu kanak, kalima tulin.’ ");
INSERT INTO did_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Naka-ikagi to magbobo-ot to ‘Ogpasakupon ku mandà ikow to lima no kalunsud.’ ");
INSERT INTO did_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Dayun nigdatong mandà to ikatou aw nangon to ‘Sir, igka-ulì ku dà ikow so-idi no ingkabogoy nu kanak su likat to pagkali-us nu puli ku imbotang no natongos ");
INSERT INTO did_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","su ogkahadok a ikow no ma-unug-unugon ka lagboy no otowsu ogpuduton nu dà kan konà no ikow aw aniha nu dà to wadà nu kapagudi to pag-odok.’ ");
INSERT INTO did_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Naka-ikagi to magbobo-ot to ‘Sikan no na-ikagi nu, igkabalitu ikow. Nama-anan nu man to ma-unug-unugon a no otow. Ogpuduton ku kan konà no kanak aw aniha to wadà ku kapagudi to pag-odok. ");
INSERT INTO did_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Nokoy man no wadà nu ipa-utang to sapì ku awos ogtulin aw ogkasukut ku to pag-ulì ku.’ ");
INSERT INTO did_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Na nig-iling to magbobo-ot to duma no sakup din to ‘Puduta kan sobu-uk no imbogoy ku kandin aw ibogoy diyà kan moydu-on kasampuù tulin.’ ");
INSERT INTO did_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Dì nakatabak kandin to ‘Sir, kandin, moydu-on on sampuù no nigsubla on.’ ");
INSERT INTO did_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Dì na-ikagi to magbobo-ot to ‘Ognangonan ku to kan dakoo on, ogkadugangan pad. Dì to ma-intok dà, ogkapudutan pad nasì. ");
INSERT INTO did_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Dì sikan kablang ku no wadà pasakup kanak, daaha aw himatayi dini to atubangan ku.’” ");
INSERT INTO did_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Na pagkatapus to pagpananglitan ni Jesus, nigpadayong on kandan padoog diyà to Hirusalim. ");
INSERT INTO did_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","No madani on kandan diyà to mgo lunsud to Bitpagi aw Bitaniya no diyà to augan to untud no pighingadanan to Ulibu-an, nigsugù kandin to daduwa no pangabaga din no nig-iling to ");
INSERT INTO did_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Andiya-i now to kaylu now pad no lunsud. Ko dumatong kow on, ogkakita-an now to nati to kabayù no nahikotan on tahan no wadà pad kasakayi aw hubada now to hikot aw daaha now dini kanak. ");
INSERT INTO did_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ko moydu-on ogsagman iyu, iling kow to ‘Moydu-on ogkadomdoman to Magbobo-ot ta to kabayù.’” ");
INSERT INTO did_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Dayun nighipanow on kan daduwa aw katuman dan to innangon kandan ni Jesus. ");
INSERT INTO did_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Pag-abut dan, pighubadan dan on dayun kan inhikot to nati, aw to tagtu-un, nakasagman aw maka-usip to “Nokoy man no pighubadan now sikan nati.” ");
INSERT INTO did_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nigtabak kandan no daduwa to “Moydu-on ogkadomdoman to Magbobo-ot ta sikan.” ");
INSERT INTO did_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Dayun pigdaa dan diyà ki Jesus. Pigsablayan dan to bagakwang to nati to kabò dan su awos ihanig aw pasakayi dan ki Jesus. ");
INSERT INTO did_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","To mgo ka-otawan, pigladladan dan to kabò dan diyà to igbayà din no nigsakoy to kabayù aw kan ogkagi-okan no katawilan to pagtahud-tahud dan to harì. ");
INSERT INTO did_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Na no pagkabaak dan tibò to daan no igkapatugpù on to Ulibu-an no untud, sikan kahan-ingan no kasakupan ni Jesus, namanpunù kandan to pagtukhow aw sayà-sayà to Diyus to ma-agbot su mabogbog no kaboonganan no pigpanghimu ni Jesus no nakita-an dan. ");
INSERT INTO did_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Inlangkoà dan no nig-iling to “Mabuhì, mapanalanginan to Harì no pigpatubus to Diyus no Magbobo-ot dini to ka-otawan. Malinawon diyà to langit aw matahudan to Diyus no kinatikangan.” ");
INSERT INTO did_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Dì moydu-on Parisiyu no nakaba-ot gayod du-on to kahan-ingan no nig-ikagi diyà ki Jesus to “Sir, sapadi nu to mgo sakup nu no naman-iling to angod kan.” ");
INSERT INTO did_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Nig-ikagi si Jesus to “Ognangonan ku iyu ko mapahonok ku sikan, agad mgo batu, ogpakalangkoà no igmatu-ud to pagkaharì to Magbobo-ot.” ");
INSERT INTO did_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Na no madani on kandan to Hirusalim, pigsinogawan ni Jesus kan no lunsud ");
INSERT INTO did_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","aw ikagi to “Ko mama-anan now on podon kunto-on no mgo taga-Hirusalim dow amonuhon now to pagpadoog now awos malinawon kow. Dì konà now pad ogkakita-an. ");
INSERT INTO did_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Moydu-on adow no konà kow on ogpakalot-ang to lunsud su ogkalipusan kow on to mgo kablang now. Ogkalilibong-libongan kow on iyan. Agad ando-i nandà to ogmutmutan dan no ogdodoo iyu takas ko mahimun kow. ");
INSERT INTO did_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Iyu no taga-Hirusalim, aw mgo agpot now to lunsud, ogkatimodmod dà. Ogkalompag dà tibò. Wadà batu no pigpagdokot-dokot no ogkabilin su wadà now man kilaha to adow to pag-abut iyu to Diyus no bumubulig podon iyu.” ");
INSERT INTO did_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Na, nigsood si Jesus to labow no simbahan aw pambohusa din tibò kan pigsakpan din du-on to sood no mamaligya-ay. ");
INSERT INTO did_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Nig-iling si Jesus to “Nasulat on diyà to kasulatan to Diyus no pig-iling to ‘Abutanan ku, oghingadanan to ampu-anan to Diyus.’ Dì pighimu now on nasì no hobonganan to mgo tulisan.” ");
INSERT INTO did_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Na, adow-adow nigpang-anad si Jesus diyà kan no simbahan no labow. Dì to mgo punu-an to tinu-uhan aw mgo duma no mangka-aslag no mgo Hudiyu, nigdomdom kandan dow amonuhon dan to pagpadoog to paghimatoy ki Jesus. ");
INSERT INTO did_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Dì wadà dan pad man katuman su to ka-otawan, namanpaminog man lagboy to kagi-kagi din. ");
INSERT INTO did_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Na, songo adow nigpang-anad si Jesus to kahan-ingan diyà to labow no simbahan aw ipasabut to Madoyow no Tutuwanon. Tinakin pigduguk kandin to mgo punu-an to tinu-uhan to mgo Hudiyu. ");
INSERT INTO did_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Nig-iling kandan diyà ki Jesus to “Nangoni koy dow ando-i makalikat to kabogbogan nu. Intawa to nigpahimu ikow to hininang nu.” ");
INSERT INTO did_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Nig-iling si Jesus to “Moydu-on pad ig-usip ku iyu. ");
INSERT INTO did_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Nokoy to domdom now bahin to kabogbogan ni Juan no Magbobonyagay, dow ando-i makalikat, Diyus dow otow to nalikatan.” ");
INSERT INTO did_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Nigkasusukun-sukun kandan dow nokoy to igtabak dan ki Jesus. Kandan naman-iling to “Ko iyan itabak ta to ‘Likat to Diyus kan no kabogbogan,’ og-ikagihon din to ‘Nokoy man no konà kow ogtu-u.’ ");
INSERT INTO did_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Dì ko iyan itabak ta to ‘Likat dà puli to otow,’ ogdodogpakon ki man to ka-otawan to batu su namantu-u man kandan to si Juan, tùtu-u no maglilikwaday to Diyus.” ");
INSERT INTO did_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Kaling man to intabak dan to wadà dan kama-ani dow ando-i makalikat to kabogbogan ni Juan. ");
INSERT INTO did_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","“Na,” kagi ni Jesus, “konà ku gayod iyu ognangonan dow ando-i makalikat to kanak kabogbogan to hininang ku.” ");
INSERT INTO did_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Na, impananglitan ni Jesus to pagpang-anad din to ka-otawan no nig-iling to “Moydu-on otow no nigtanom to paras. To pigpa-uyamu din to tanom to mgo otow no puli huwag-on to pag-ugpà. Dayun nighipanow on kandin diyà to songo banwa no og-ugpa-an din to maugoy. ");
INSERT INTO did_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Pag-abut on to tanom din no kaparasan, sinugu-an din to sobu-uk no sugu-onon din diyà kan pigpa-uyamu no mgo otow su pigpasukut din podon to kandin bahin. Dì pigbunaan nasì kan sugu-onon aw papa-uli-a kandin diyà to mata-as no wadà napudut. ");
INSERT INTO did_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Pigsugu-an mandà to tagtu-un to kaparasan to duma no sugu-onon. Pagdatong din, pigbunaan dan gayod aw pa-inahi dan pad aw papa-uli-a no ampan pad gayod napudut. ");
INSERT INTO did_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Wadà inonoka to tagtu-un to kaparasan aw pigpa-usaban din to ikatou no sugu-onon din dì nigsubla on nasì su pigpampalì-pali-an dan on aw tinakin papa-uli-a dan mandà. ");
INSERT INTO did_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Na to tagtu-un to kaparasan, sobu-uk pad no ogkapa-andu-on din no iyan anak din no lagboy din nalogonan. Bali man pigpa-andu-on din kandin no nig-iling kandin to ‘Ogtahomon ku to ogtahudon dan iyan to anak ku.’ ");
INSERT INTO did_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Dì pag-abut din to namang-uyamu no mgo otow, naman-ikagi to ‘Na, so-idid on iyan to anak to mata-as ta no ogkahimu no tagtu-un to kaparasan ko mahudi no adow. Nokoy pad to ogtagadan ta. Oghimatayan tad awos ita on to tagtu-un to kaparasan.’ ");
INSERT INTO did_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Dayun pigdaa dan kandin diyà to labas aw himatayi. “Na to tagtu-un to kaparasan, amonuhon din buwa kandan no iyan man pigpa-uyamu din. ");
INSERT INTO did_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ogpati-ulì dà kandin aw andiya-i aw ponasa din himatayi kan no pigpa-uyamu din aw ipa-uyamu din on to duma no mgo otow to tanom din.” Pagkadinog to ka-otawan, namaka-ikagi to “Mababagan podon to Diyus bahin to pig-ikagi nu,” su nama-anan dan to kandan to napa-atubangan to impananglitan ni Jesus. ");
INSERT INTO did_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Dì nig-ahà si Jesus to ka-otawan aw iling to “Ko konà pa no tùtu-u to pig-ikagi ku, nokoy to litukan to nasulat on no pig-iling to, “‘To batu no pa-ukdangan podon to baoy, agad intimbag on puli to maghihimu to baoy, dì iyan on pighimu nasì to Diyus no sinaligan no pa-ukdangan.’ ");
INSERT INTO did_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","To otow no ogdo-og du-on kan no batu, ogpanlagsik. Ko ogdo-ogan kandin kan no batu, ogkadupuk-dupuk.” ");
INSERT INTO did_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Na kandà no timpu, pigpangindakopan podon si Jesus to mgo punu-an to tinu-uhan to mgo Hudiyu, su nasabutan dan to kandan to napa-atubangan to impananglitan ni Jesus. Dì nahadokan dan dà to mgo ka-otawan. ");
INSERT INTO did_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kaling man, pigpakabantayan dan lagboy aw kapangindakopi dan podon to kagi-kagi din aw pa-andu-oni dan to mgo otow no mapakunon-kunonon awos moydu-on igkanangon dan diyà to gubirnu to taga-Ruma no nakasakup kandan. ");
INSERT INTO did_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Pig-usip-usip dan si Jesus no nig-iling to “Sir, pigkilaa noy to matuwadong to impang-anad nu aw kagi-kagi nu. Matul-id to pagpang-anad nu bahin to kasugu-an to Diyus. To pagpang-anad nu, wadà ogpili-on nu no otow agad ma-aslag dow ma-intok. ");
INSERT INTO did_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Na, moydu-on ig-usip noy ikow. Nokoy to domdom nu bahin to pagpabayad ita to mgo buhis diyà ki Harì Cesar no mata-as to taga-Ruma no nakasakup ita. Dow tugutan ki to kasugu-an dini ita dow wadà to ogpakabayad ki.” ");
INSERT INTO did_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Dì nama-anan ni Jesus to mangkapakunon-kunonon kandan no mgo otow aw ikagi kandin to ");
INSERT INTO did_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ipa-ahà kanak to songo sapì.” Nigpudut kandan aw ipa-ahà dan kandin. Nig-iling si Jesus to “Intawa inotow-otawa kani so-idi. Intawa tagngadan so-idi.” Nakatabak kandan to “Ki Harì Cesar.” ");
INSERT INTO did_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Nig-ikagi si Jesus to “Na, i-untuu now diyà ki Harì Cesar to kandin bahin. Dì i-untuu now gayod diyà to Diyus to kandin bahin.” ");
INSERT INTO did_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Wadà dan kadakopi kandin to kagi-kagi din diyà to atubangan to ka-otawan. Na-ompongan du-on kandan. ");
INSERT INTO did_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Na pigduguk si Jesus to mgo Sadusiyu no wadà tu-u to ogbuhayon to nangkamatoy to mahudi no adow aw tuusa. ");
INSERT INTO did_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Naman-usip kandan to “Sir, nasulatan kinow ni Moises to ko mamatoy to su-un ta no lukos no wadà pad makapanganak, iyan ogpakapangimau ki aw ko ogpanganak ki, ogkahimu dà no sugpù din, kan su-un ta no namatoy on. ");
INSERT INTO did_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Na ko pananglitan, moydu-on pitu no nigsusu-un. Nig-asawa to kakoy. No pagkaugoy to kandan no pag-a-asawa, namatoy on kandin dì wadà pad makapanganak kandan. ");
INSERT INTO did_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Dayun pigpangimau kan buyag to hadi no nigsunù kandin. Dì pagkaugoy mandà, namatoy gayod kan hadi no wadà pad makapanganak kandan gayod. ");
INSERT INTO did_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","To su-un din no ikatou, nigpangimau mandà kan no buyag. Dì kandà to nadoogan to pitu no nigsusu-un. Tibò nangkamatoy, dì wadà kandan tibò makapanganak. ");
INSERT INTO did_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Na kayan pana namatoy to buyag. ");
INSERT INTO did_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Na agad-agad to ikow no impang-anad, to mahudi no adow no pagbuhoy to otow no nangkamatoy, intawa buwa dapit to ogpakatu-un kan no buyag su sikan pitu no nigsusu-un, kandà man no asawa dan.” ");
INSERT INTO did_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Nigtabak si Jesus to “Mgo otow kunto-on, og-asawa pad aw igpa-asawa pad. ");
INSERT INTO did_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Dì to tuusonon to mahudi no adow no ogka-uliman tibò, wadad og-asawa pad aw igpa-asawa pad ");
INSERT INTO did_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","su wadad kamatayon to otow, iyan on ogka-angodan dan to mgo diwata no konà ogpanganak su anak man gayod to Diyus, su ogpambuhayon dà man to Diyus to mgo otow aw tuusa. ");
INSERT INTO did_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“Nokoy man no wadà kow tu-u to ogbuhayon dà to nangkamatoy, su agad si Moises no lagsoban to Diyus no maglilikwaday din, pigmatu-ud din gayod to ogpambuhayon dà to nangkamatoy aw tuusa, su ogkabasa ta kan nasulat din bahin to pagliyab-liyab to bawbagon no dugihon dì wadà pighalinan to bawbagon, aw du-on pighingadanan ni Moises to Magbobo-ot ta to Ampu-onon ni Abraham aw Ampu-onon ni Isaac aw Ampu-onon ni Jacob, agad nangkamatoy on kandan. ");
INSERT INTO did_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Su pighimu kandan to Diyus angay buhì dà su ogbuhayon din kandan to mahudi no adow.” ");
INSERT INTO did_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Naka-ikagi to songo mag-a-anad to tinu-uhan to “Tùtu-u iyan Sir to pig-ikagi nu.” ");
INSERT INTO did_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Katapusan, wadad ingka-usip dan su wadà oglangub to pag-usip kandin bahin to impang-anad din. ");
INSERT INTO did_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Na, nig-ikagi si Jesus to “To otow no ogkahimu no Imananan to Ka-otawan, sugpù kun ni David, dì ogka-amonu man buwa ");
INSERT INTO did_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","su si David, nasulat din diyà to diblu no pighingadanan to Mgo Salmu no pig-iling to, “‘Diyus no Magbobo-ot ku, pig-ikagihan din kan otow no Magbobo-ot ku gayod no na-iling to, Ogpaso-ingon ku ikow kani to kalintu-u ku ");
INSERT INTO did_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","hantod to ogpababawon ku ikow du-on to mgo kablang nu aw igpada-og ku ikow tibò kandan.’ ");
INSERT INTO did_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Mano pighingadanan ni David kandin to Magbobo-ot din, dì og-amonuhon man su sugpù dà man gayod kandin ni David.” ");
INSERT INTO did_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Na no nadinogan to ka-otawan, nig-ikagi si Jesus diyà to mgo pangabaga din to ");
INSERT INTO did_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Bantoy kow, konà kow ogsunud to mgo mag-a-anad to mgo tinu-uhan su ogpangabò to mahal aw patahud-tahud diyà to kahimunanan aw simbahan aw pagko-onan. ");
INSERT INTO did_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Dì sikan to ogpambugow to baoy to bau no buyag dì puli mahabà to ogpanawag-tawag to Diyus. Dakoo to kastigu kandan.” ");
INSERT INTO did_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Na nakalinggokà si Jesus aw kakita-i to mgo datù no mgo otow no naman-uug to sapì diyà to botanganan to sapì to simbahan. ");
INSERT INTO did_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Nakita-an din gayod to bau no buyag no nig-uug to daduwa dà no ka-dakò ubag. ");
INSERT INTO did_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Kagi ni Jesus to “Ognangonan ku iyu to tùtu-u iyan to agad pad pagtibo-on to sapì no imbogoy kan mgo datù, dì ogsubla on to kandin imbogoy ");
INSERT INTO did_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","su kandan, namambogoy to samà, dì sikan no buyag, intibò din imbogoy agad pangabuhì din.” ");
INSERT INTO did_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Na to mgo sakup ni Jesus, nigkababaaw kandan bahin to labow no simbahan aw to madoyow no mgo batu no ingkahimu kan, aw sikan mgo impandayan-dayan no impang-amut to mgo ka-otawan. ");
INSERT INTO did_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Nig-ikagi si Jesus to “To nakita-an now no mangka-aslag no mgo baoy no simbahan, to mahudi no adow, ogkangkalompag dà tibò. Wadà ogkasamà no batu no pigpagdokot-dokot.” ");
INSERT INTO did_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Namang-ikagi kandan to “Sir, dow kagan-u ogkagotò to pagkalompag to labow no simbahan. Nokoy to indananan noy to imomo-ot on ogkagotò.” ");
INSERT INTO did_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Nig-iling si Jesus to “Bantoy kow su dagow matanak-tanak kow su mahan-ing to oglogwà no ogpa-angod-angod puli kanak no og-ikagi to ‘Kanak to Imananan to Ka-otawan dini to babow to kalibutan. Nagotò on to adow.’ Dì konà kow ogpasakup. ");
INSERT INTO did_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ko madinog now to moydu-on gira aw samuk-samuk, konà kow ogkahadok su maogot ogkatuman pad sikan to konà pad no kaliswahanan.” ");
INSERT INTO did_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Na nig-iling si Jesus diyà kandan to “Ogkasamuk-samuk pad to mgo kanasudan aw ogkagubut pad to mgo kalunsudan. ");
INSERT INTO did_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ogtiyogon no mabogbog to nigsingkabugtì no banwa aw ogkogsa-an to bontas aw oglogpadan to mgo sakit. To mahudi no adow no ogakita-an to kaboonganan diyà to langit no kahadokanan no ta-indanan to kaliswahanan on to kalibutan. ");
INSERT INTO did_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Dì ogkadakop kow pad aw ka-uwang-uwangi aw pa-atubanga kow diyà to ogdaa to tinu-uhan aw kapirisu kow aw pa-atubanga kow pad diyà to mgo ukum aw harì ugpat kanak. ");
INSERT INTO did_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Kayan pana ogmatu-udon now to pagpasakup now kanak. ");
INSERT INTO did_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","To konà kow pad ogpa-atubangon aw pang-usip-usipa kow, konà kow ogpanghina-at to igkatabak now ");
INSERT INTO did_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","su kanak, ogbogayan ku iyu to ka-ugsoban aw mgo kagi no litos no igkatabak now no konà kow no ogkakambawan to kagi to kablang now aw konà ogka-asuy to kagi now. ");
INSERT INTO did_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Agad ginikanan now, ighatod kow dan diyà to ukum. Agad kasu-unan now aw kadumahan now, ighatod kow dan gayod. Moydu-on iyu gayod ogkahimatayan. ");
INSERT INTO did_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ogkablangon kow to tibò ugpat to kanak ngadan. ");
INSERT INTO did_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Dì wadà agad so soag to bubuu now no ogkawadà. ");
INSERT INTO did_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Oghogoton now to pagtu-u now su awos mabogayan kow to kinabuhì no konad ogkawadà. ");
INSERT INTO did_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Dì ko makita-an now to piglibong-libongan on to Hirusalim to kasundauhan, ogka-indanan now to madaas on to kado-otanan kan no lunsud. ");
INSERT INTO did_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","To mgo taga-Hudiya, ogpamakalaguy diyà to mgo ka-untudan. To taga-lunsud, ogpamakalabas. Dì to otow no diyà to kahilitan, konad ogpakasood to lunsud, ");
INSERT INTO did_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","su adow on to pagkastigu su ogkatuman on to kasulatan. ");
INSERT INTO did_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Aboy to mgo magkabodos aw mgo manggi-anak to ogkalisodan. Og-abut to kaboù to Diyus du-on to mgo ka-otawan ");
INSERT INTO did_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","no ogpanghimatayan to palì to otak dow ogkadakop no oghimuhon no bihag diyà to nigsingkabugtì no banwa. Hirusalim no lunsud, ogkagi-okan to bugtì no mgo otow hantod to matumanan on to adow no ogkapanggadan no ogtugutan to Diyus. ");
INSERT INTO did_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Na to mahudi no adow, ogkangkakita-an to kaboonganan diyà to soga aw buwan aw mgo bitu-on no ta-indanan to katapusan on sikan. Ogpangkobahon to mgo kasinakupan likat to pagkangkaboong-boong dan to mgo dadagu-uk to dagat aw pamawbakuud no baod. ");
INSERT INTO did_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ogpanggobloy to mgo otow likat to hadok dan dà puli no ogtagad to ogkatuman dini to babow to kalibutan, su to mgo ogpansilat diyà to langit, ogpamakasuwoy to tahan dan no baya-anan. ");
INSERT INTO did_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kayan pana ogkakita-an to Tumutubus to Ka-otawan no ogliwaw-ang to gabun no oglugsad dini to kalibutan no ogdumahan to kabogbogan ku aw katuusan ku. ");
INSERT INTO did_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Na ko ogpunu-an on to pagtuman sikan, ogpakasakindog kow aw langhag diyà to langit su madani-dani on to pagbay-ow iyu.” ");
INSERT INTO did_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","30","Na, impananglitan ni Jesus no nig-iling kandin to “Ko pananglitan, dini to babow to kalibutan kunto-on, moydu-on indananan ta to tinu-ig. Ko ogbogas to mgo kayu, ogka-indanan tad to tigaas on iyan. ");
INSERT INTO did_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","To mahudi no adow, moydu-on gayod indananan now su ko ogkakita-an now on to natuman on kan no kalisodan no innangon ku iyu, katagahanan now man gayod to madaas on to ogsakupan to Diyus dini to pasak. ");
INSERT INTO did_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Dì nangonan ku iyan iyu to ko ogpunu-an sikan monang ogkangkamatoy to sinakupan ku ko masakpanan pad to pig-ikagi ku iyu. ");
INSERT INTO did_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Moydu-on dà katapusan to langit aw kalibutan, dì to kagi ku, wadà katapusan. ");
INSERT INTO did_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Na, dowdoyow kow ko mangkatiko-on kow on aw mangkati-inom aw makabogat iyu no igkapook-pook now bahin to kadodoog now dini to babow to kalibutan, su ogkatokawan kow dà to pag-abut kan no adow no angod to batik no ogkabokas, ");
INSERT INTO did_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","su lagboy iyan og-abut ogkatokawan to tibò no nig-ugpà no mgo otow dini to babow to pasak. ");
INSERT INTO did_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kadoog kow ogbantoy. Ogpangamuyù kow to Diyus to kabogbogan ko mahimù to ogpakalawang kow kan no mgo kalisodan no imomo-ot on ogkatuman aw makatutuu kow kanak no Tumutubus to Ka-otawan no wadà halinan.” ");
INSERT INTO did_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Adow-adow nigpang-anad si Jesus diyà to labow no simbahan diyà to Hirusalim. Dì diyà to og-ugpà to Ulibu-an no untud to madukilom. ");
INSERT INTO did_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","To mgo ka-otawan, no masoom-soom pad, kanunoy ogkangkahimun du-on to simbahan no ogpamaminog to impang-anad ni Jesus. ");
INSERT INTO did_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Na, madaas on ogkagotò to hihinangay to Hinang to Paan no Wadà Igpatulin no ogpakadaa gayod to Hinang to Pagpalipas to Kado-otan no iyan ogpakapunù. ");
INSERT INTO did_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Na pagkahimun on to mgo punu-an to tinu-uhan to mgo Hudiyu, nigsusukun-sukun kandan dow og-amonuhon dan to pagkumit no ogkahimatayan si Jesus su ogkahadok kandan ko ogkasamuk to ka-otawan no ogkangkahimun. ");
INSERT INTO did_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Na, nakasood si Satanas diyà ki Judas Iskariyuti no sakup dà gayod kan sampuù tag duwa no pangabaga ni Jesus. ");
INSERT INTO did_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Dayun nakahipanow on si Judas no ogpadoog diyà to mgo punu-an to tinu-uhan no awos ogpagsukun to pagkumit din to ogkadaa din si Jesus diyà to mgo kablang din. ");
INSERT INTO did_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nangkaliyag kandan no mgo punu-an aw dayun bogayi dan to sapi si Judas. ");
INSERT INTO did_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Nig-uyun si Judas aw kanunoy nakadomdom kandin dow og-amonuhon din to pagkumit to ogkadaa din si Jesus du-on to mgo kablang din ko mali-usan to ka-otawan. ");
INSERT INTO did_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Na, nig-abut on to adow to Hinang to Paan no Wadà Igpatulin aw sikan no adow igsundù dan gayod to buhì no igdodomdomay dan to Pagpalipas to Kado-otan. ");
INSERT INTO did_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Kaling man pigsugù ni Jesus si Pedro aw si Juan to “Na oghina-aton now on to pagko-onan ta no igdodomdomay ta to Pagpalipas to Kado-otan.” ");
INSERT INTO did_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nig-usip kandan to “Ando-i koy nu to ogpahina-aton.” ");
INSERT INTO did_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Nigtabak si Jesus to “Na ko dumatong kow on to lunsud ogsungunon kow to otow no ogdaa to bobotangan no pigtagu-an to wohig, patiduma kow kandin hantod diyà to ogsoodan din no baoy. ");
INSERT INTO did_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ikagihi now to tagbaoy to ‘Igpa-usip ka kanami ni Sir dow ando-i koy nu to ogpa-abuton no ogko-on koy to igdodomdomay noy to Pagpalipas to Kado-otan.’ ");
INSERT INTO did_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Na oghindu-an kow diyà di-atas no maow-ag no tahan on natingub. Du-on on tibò to ogkahina-at to pagko-onan ta.” ");
INSERT INTO did_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Dayun namang-andiyà on kandan aw kita-a dan agad-agad to innangon kandan ni Jesus aw pighina-at dan tibò to pagko-onan no igdodomdomay dan to Pagpalipas to Kado-otan. ");
INSERT INTO did_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Na no pagkahina-at on, namang-ingkud kandan si Jesus no namango-on. ");
INSERT INTO did_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Nig-ikagi si Jesus diyà to mgo pangabaga din to “Madaas-daas on to pagmuwa kanak. Kaling man ogkaliyagan ku podon to ogpamango-on kinow so-idi katapusanan no igdodomdomay ta to Pagpalipas to Kado-otan ");
INSERT INTO did_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","su monang kid ogkakoko-on mandà ko matuman on to litukan so-idi pagko-onan to mahudi no adow to pigsakupan to Diyus dini to babow to kalibutan.” ");
INSERT INTO did_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Na pigdawat din on to kabù aw pasalamati din to Diyus. Nig-ikagi kandin to “Dawat kow on aw pamang-inom kow ");
INSERT INTO did_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","su ognangonan ku iyu to likat kunto-on monang ad ogpag-inom iyu to inomon mandà ko matuman on to pagsakup to Diyus dini to babow to kalibutan.” ");
INSERT INTO did_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Du-on dinawat din to paan aw pasalamati din to Diyus. Pigpamikas-pikas din aw ipamogoy no pigdonganan din to kagi no pig-iling to “So-idi no paan, lawa ku no ogpakatubus iyu no ogpakamatoy. Ogko-onon now so-idi no igdodomdomay now kanak.” ");
INSERT INTO did_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Pagkatapus to pagko-on, pigdawat din to duma no kabù aw pama-inoma din no pigdonganan to kagi no pig-iling to “So-idi inomon, langosa ku no ogpataugon ku no ogmatu-ud to bayà no insahad to Diyus iyu su ogpakimatoy a iyu. ");
INSERT INTO did_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Dì to nigpagsau dini kanak kunto-on, sikan iyan to ogbaligyà kanak. ");
INSERT INTO did_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ogmuwahon a no Tumutubus to Ka-otawan agad-agad to pigbo-otan to Diyus, dì aboy kan otow no ogbaligyà kanak.” ");
INSERT INTO did_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Dayun nigka-inusipay kandan dow intawa dapit kandan to oghimu kan pig-ikagi ni Jesus no ogbaligyà kandin, dì wadà dan katagahi. ");
INSERT INTO did_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Na, sikan mgo pangabaga ni Jesus no du-on to katapusanan dan no pagko-onan, nighi-asuy-asuy kandan dow intawa dapit to ogkahimu no labow-labow kandan. ");
INSERT INTO did_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Dì naka-ikagi si Jesus to “To mgo harì dini to babow to kalibutan, ogpanda-og-da-og to sinakupan dan, dì mangkuwan mgo sumasakup, ogpahingadan podon to Bumubulig to Ka-otawan. ");
INSERT INTO did_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Dì konà no sikan to kadodoog ta su to labow ita, ogpabatà-batà nasì aw mangkanigo-on, ogpahimu no batà. ");
INSERT INTO did_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Intawa dapit to labow, sikan ogpa-ingkudon no ogpakako-on, dow sikan maghohonat. Agad-agad to kadodoog to mgo otow dini to babow to pasak, sikan ogpa-ingkudon to labow. Dì to itanow, kanak no tagsakup iyu iyan ogka-angodan ku to batà-batà. ");
INSERT INTO did_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Na, iyu, namakadumduma kow kanak to pagkalisodi ku. ");
INSERT INTO did_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Moydu-on ogpasakupan kanak to Amoy ku. Iyu gayod, moydu-on ogpasakupan ku iyu ");
INSERT INTO did_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","awos ogpamango-on kinow aw pamang-inom diyà to ogsakupan ku, aw iyu, ogpasakupan ku iyu to sampuù tag duwa no mgo panon to mgo Isrili.” ");
INSERT INTO did_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Na, nig-ikagi si Jesus diyà ki Pedro to “Simon, Simon, pigtugutan si Satanas to og-anti iyu dow tùtu-u to pagtu-u now. ");
INSERT INTO did_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Dì nigpangamuyù ad on to Diyus to konà ogpatugutan to paglingow nu to pagtu-u. Agad dow makasuwoy ka dà, dì ogpakapa-ulì ka dà gayod. Ko maka-ulì kad on, ogkabuligan nu gayod to kasing-sakup nu.” ");
INSERT INTO did_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Naka-ikagi si Simon to “Sir, ko mapirisu ka, ogpapirisu a gayod. Kamatayon nu, kamatayon ku da gayod.” ");
INSERT INTO did_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Nig-ikagi si Jesus to “So-idi iyan Lagi, no konà pad no kabukas-bukas no tataga-ukay to manuk, katatou nu ilidung to nakilahan a nu.” ");
INSERT INTO did_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Na, pig-usip ni Jesus to mgo pangabaga din to “Todu-on pagpalibod-libod ku iyu to pagpasabut no wadà ku iyu pamadaaha to balutan aw sapì aw sapatus, dow wadà buwa pigboong now?” Namakatabak kandan to “Wadà dà man pigboong noy usab.” ");
INSERT INTO did_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Nig-ikagi si Jesus to “Dì kunto-on, bugtì to ginhawa to ka-otawan dini ita. Kaling man ko moydu-on sapì, ogdawdaa kow dà. Ko moydu-on balutan, daaha. Ko wadà otak now, igbaligyà to ilisan now aw iboli to otak ");
INSERT INTO did_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","su ogkatuman dà to kasulatan bahin kanak no pig-iling to ‘Nahimu kandin no makasasaà,’ su sikan nasulat on bahin kanak, ogkatuman on.” ");
INSERT INTO did_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Namaka-ikagi kandan to “Ahà ka Sir, so-idid to daduwa no otak.” Nig-ikagi si Jesus to “Hustu dà kan.” ");
INSERT INTO did_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Na, namanpono-ug kandan si Jesus aw pamang-andiyà to Ulibu-an no untud su tahan man kandan, og-inandiyà. ");
INSERT INTO did_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Pagdatong dan, nig-ikagi si Jesus to “Ogpangamuyù kow to Diyus to konà kow din matugutan to ogkabogayan kow to pa-antihan.” ");
INSERT INTO did_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nigpagsuwoy si Jesus kandan aw u-ugsud aw tinakin patilangkob kandin aw ampù to Diyus. Nig-iling kandin to ");
INSERT INTO did_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Amoy, ko pagbo-ot nu, oglipwasan a nu padon so-idi no mgo kalisodan. Mangkuwan konà no kanak to ogpakabo-ot. Dì ikow dà to ogpakabo-ot to kanak ogkadoogan.” ");
INSERT INTO did_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Dayun piglogwà kandin to diwata likat to Diyus aw kadugangi to doson din. ");
INSERT INTO did_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Na naduyong-ot to ginhawa din. Lagboy to pag-ampù din hantod to pig-uwasan kandin no iyan on ogka-angodan to langosa no nigpanagdù du-on to pasak. ");
INSERT INTO did_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Na pagkatapus din to pag-ampù, du-on nigsakindog kandin aw andiya-i din to mgo pangabaga din. Dì nangkalipodong on kandan tibò to pagkangkagobloy dan. ");
INSERT INTO did_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Pig-ikagihan ni Jesus to “Nokoy man to ingkangkalipodong now on puli. Bangun kow aw ampù kow to Diyus su dagow mabogayan kow to pa-antihan.” ");
INSERT INTO did_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Na to ta-un to pag-ikagi ni Jesus, namandatong on to kahan-ingan no pig-alladan ni Judas no sood dà gayod kan sampuù tag duwa no pangabaga ni Jesus. Pigduguk ni Judas su oghadokan din si Jesus. ");
INSERT INTO did_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Dì na-ikagi ni Jesus to “Dow igbaligyà a nu buwa no Tumutubus to Ka-otawan so-i no paghadok nu kanak?” ");
INSERT INTO did_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Pagsabut to duma no mgo pangabaga ni Jesus to ogkadoogan, namaka-usip kandan to “Na Sir, dow igpamatigbas nud kanami kandan?” ");
INSERT INTO did_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Aw to songo sakup din nakalapnut on aw itigbas din to sugu-onon to mata-as to mgo punu-an to tinu-uhan. Dì iyan dà na-igù to kalintu-u no talinga din aw kasangguwi. ");
INSERT INTO did_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Dì naka-ikagi si Jesus to “Aya kad.” Dayun pigtudì ni Jesus to talinga no nasangguu aw ka-ulì dà. ");
INSERT INTO did_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Na nig-ikagi si Jesus diyà to mgo punu-an to tinu-uhan aw mgo guwardya to simbahan no labow no ogdakop kandin to “Dow oghimuhon a now no tulisan, su nigdaa kow to otak aw popokpokay. ");
INSERT INTO did_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","No pagkadani-dani ku iyu adow-adow diyà to labow no simbahan, wadà a now dakopa. Dì kunto-on, adow now on aw ni Satanas gayod no tagtu-un to kadigloman aw gayod kunto-on, ogkabo-otan a now on.” ");
INSERT INTO did_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Na, pigdakop dan si Jesus aw daaha diyà to ugpa-anan to mata-as to mgo punu-an to tinu-uhan. Nigpawpatilupug dà si Pedro. ");
INSERT INTO did_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Na nigtomog kandan to kayu diyà to solib no piglibong to aad. Namang-ingkud tibò kandan aw duguk si Pedro aw ingkud gayod kandin du-on no nigpalamutoy to mgo guwardya no namanghinadang du-on to kayu. ");
INSERT INTO did_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","No pagbandogi ni Pedro to kayu, nakita-an kandin to songo sugu-onon no daga aw maka-ikagi kandin to “Kandin, duma gayod sikan no otow.” ");
INSERT INTO did_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Dì niglidung si Pedro aw iling to “Igi, wadà ku kakilahi sikan no otow.” ");
INSERT INTO did_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Wadà dà kaugoy moydu-on songo otow no nakakita kandin aw iling to “Duma ka din iyan gayod.” Dì naka-ikagi si Pedro to “Konà Lagi.” ");
INSERT INTO did_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Puli dà na so lingonngon mandà songo bugtì no otow to naka-ikagi lagboy to “Agaw man taga-Galiliya sikan no otow su duma din.” ");
INSERT INTO did_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Naka-ikagi si Pedro to “Lagi, wadà a makadaag to litukan to kagi nu.” No malituk to kagi ni Pedro, nigtaga-uk wo manuk. ");
INSERT INTO did_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Na nakalingì si Jesus aw makasunglà diyà ki Pedro aw kadomdomi din to innangon kandin to Magbobo-ot din no pig-iling to “Monang ogtaga-uk to manuk to kabukas-bukas ko katatow nu ilidung to nakilahan a nu.” ");
INSERT INTO did_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Dayun nakalogwà si Pedro aw makasinogow ugpat to pagkasosoo din. ");
INSERT INTO did_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Na to mgo guwardya no nigbantoy ki Jesus, nigdugadi aw bunai gayod kandin. ");
INSERT INTO did_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Pigsalibonan dan gayod to mata din aw ikagihi to “Ko lagsoban ka to Diyus, tag-anan nu kun dow intawa ton nigsumbag ikow.” ");
INSERT INTO did_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Mahan-ing pad to mgo ing-ina-ina da ki Jesus. ");
INSERT INTO did_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Na pagkabukas, nahimun on tibò to mgo punu-an to tinu-uhan to mgo Hudiyu aw pa-atubanga si Jesus. Nig-ikagi kandan diyà ki Jesus to ");
INSERT INTO did_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Ko Kristu ka no otow no Imananan to Ka-otawan, tug-ani koy.” Nakatabak si Jesus to “Ko tumug-an a, konà kow man ogtu-u. ");
INSERT INTO did_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ko moydu-on ig-usip ku iyu, konà kow man gayod ogtabak kanak. ");
INSERT INTO did_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Mano oghimatayan a now on, likat kunto-on, kanak no Tumutubus to Ka-otawan, igkabotang a diyà a kalintu-u to Diyus no Kinabogbogan.” ");
INSERT INTO did_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Naka-usip kandan to “Dow to nalitukan buwa to na-ikagi nu to ikow, Anak ka iyan to Diyus?” Nakatabak si Jesus to “Sikan ing-usip now bahin kanak, tùt-u iyan.” ");
INSERT INTO did_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Nigka-inusipay tibò kandan to “Nokoy pad man to ogkatagadan ta no duma no igdiklamu kandin. Itanow, namakadinog kinow on man tibò to gaù din no ingkapa-ina din to Diyus.” ");
INSERT INTO did_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Na to tibò no mgo punu-an to tinu-uhan, pigdaa dan si Jesus diyà ki Pilato no gubirnadur no imbotang du-on to taga-Ruma no nakasakup to mgo ka-Hudiyuhan. ");
INSERT INTO did_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Indiklamu dan si Jesus diyà ki Pilato. Nig-ikagi kandan to “Nasakpanan noy pad so-idi no otow no nigpasuwoy kanami no mgo Hudiyu to bala-od to gubirnu now no konà now ogka-uyunan podon no taga-Ruma su ogbalatakon koy on podon to pagbayad to buhis diyà to gubirnu now no taga-Ruma su kandin kun songo harì no Imananan noy kun no mgo Hudiyu.” ");
INSERT INTO did_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Dayun pig-usip kandin ni Pilato to “Ikow, dow harì ka to mgo Hudiyu?” Natabak ni Jesus to “Sikan ing-usip nu, tùtu-u iyan.” ");
INSERT INTO did_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Nig-ikagi si Pilato diyà to mgo punu-an to tinu-uhan aw sikan kahan-ingan to “Wadà saà sikan no otow no nakita-an ku no igù ogkahibatan din.” ");
INSERT INTO did_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Dì to lagboy indiklamu dan no iyan on na-ikagi dan to “Puli din dà pigsinamuk to ka-otawan no paglibod-libod to ka-Hudiyuhan aw ka-Galiliyahan to pagpangudlin din agad hantod on kani to Hirusalim.” ");
INSERT INTO did_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Na pagkadinog ni Pilato kan mgo indiklamu dan, ing-usip din dow kandin, taga-Galiliya. ");
INSERT INTO did_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pagkama-an ni Pilato to si Jesus, taga-Galiliya iyan no pigsakupan ni Harì Hirudis, pigpa-andiya-an din si Hirudis su kandà no timpu, du-on dà gayod si Hirudis kan no lunsud no Hirusalim. ");
INSERT INTO did_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Na pagkakita kandin ni Hirudis, naliyag kandin lagboy su naugoy on to ogkaliyag ogpagkita podon kandin ki Jesus su nakadinog on tahan si Hirudis to mgo kaboonganan no pigpanghimu ni Jesus. Ogkaliyagan din podon to ogkita. ");
INSERT INTO did_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Kaling man nigpang-usip-usip ki Jesus kandin dì puli nigpapahonok si Jesus. ");
INSERT INTO did_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Na nigsakindog to mgo punu-an to tinu-uhan aw i-aboy dan ipandiklamu si Jesus. ");
INSERT INTO did_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Si Hirudis aw mgo sundau din, pigpa-inahan dan si Jesus aw dudugadiha dan pad. Dayun pigpapangabò dan si Jesus to kabò to harì aw pigpapa-ulì kandin diyà ki Pilato. ");
INSERT INTO did_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kandà no timpu nigkalalagi si Hirudis aw si Pilato no tahan kandan, nigkakablang no wadà pad pa-atubanga si Jesus. ");
INSERT INTO did_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Na pigpatawagan ni Pilato to mgo punu-an to tinu-uhan aw mgo kahan-ingan no mgo Hudiyu. ");
INSERT INTO did_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Pagkahimun dan tibò, nig-ikagi si Pilato to “Indiklamu now on sikan no otow dini kanak to nigpasuwoy kun to ka-otawan no konà ogka-uyunan podon to gubirnu. Dì dini to atubangan now pagpangumo-id ku to mgo indiklamu now kandin, wadà man saà din no litos ogkahibatan din no lagboy no indiklamu now. ");
INSERT INTO did_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Wadà saà din no litos gayod no nakita-an ni Harì Hirudis su agaw man ing-ulì din dà dini kanami. Wadà pighimu din no litos to igkamatoy on to kandin tu-un no lawa. ");
INSERT INTO did_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Kaling man, ogpabunaan ku dà puli aw pasabuki.” ");
INSERT INTO did_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Na kanunoy to tighihinang to Hinang to Pagpalipas to Kado-otan ogsabuk si Pilato to songo bu-uk no tahan napirisu aw pikii-pikiya din to si Jesus to ogpasabukan din podon. ");
INSERT INTO did_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Dì namakasa-og to kahan-ingan to “Himatayi. Pasabuki si Barabas.” ");
INSERT INTO did_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Na si Barabas, pigpirisu kandin su nigsamuk to ka-otawan no pigpa-atu din to gubirnu diyà to Hirusalim aw nighimatoy kandin gayod to otow. ");
INSERT INTO did_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Nig-ikagi mandà podon si Pilato diyà to kahan-ingan su ogpakasabukan din podon si Jesus. ");
INSERT INTO did_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Dì namansa-og mandà to kahan-ingan to “Himatayi. Tutuki diyà to kinurus.” ");
INSERT INTO did_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ikatou no pag-ikagi ni Pilato to “Nokoy man. Nokoy to saà din. Wadà nakita-an ku no saà din no litos igkamatoy din. Kaling man puli ku ogpabunaan aw pasabuki ku dà.” ");
INSERT INTO did_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Dì lagboy on liyag to ogpahimatayan dan aw pamansa-og kandan aw makada-og to pagbo-ot dan aw mgo punu-an dan. ");
INSERT INTO did_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Na pigbo-otan ni Pilato to ogkatugutan to pigpangamuyù to kahan-ingan. ");
INSERT INTO did_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pigsabukan din nasì kan napirisu on no nigsamuk to ka-otawan aw nigpanghimatoy to otow. Dì si Jesus, impabu-ud din to kahan-ingan no ogpabo-otan. ");
INSERT INTO did_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Na no pigdaa si Jesus to mgo sundau, impagkita dan to songo otow no si Simon no taga-Sirini no niglikat to hilit aw pigpogos dan pigpati-ang to kinurus aw palupug-lupuga dan ki Jesus. ");
INSERT INTO did_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Na piglupug gayod to kahan-ingan no otow aw mgo buyag no namansinogow aw pamandaugmatoy kandan no buyag. ");
INSERT INTO did_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Dì niglingì si Jesus aw ikagi to “Iyu no mgo buyag no taga-Hirusalim, konà a now ogsinogawan. Iyan ogsinogawan now nasì to iyu no kabotang aw mgo kabata-an now. ");
INSERT INTO did_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Su to mahudi no adow, oghimuhon no ogkaliyag kan konà ogpamanganak aw kan konà ogkadudu-an, su tibò ogkalisodan lagboy. ");
INSERT INTO did_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Kayan pana du-on ogpamaka-iling to ka-otawan to ‘Iyu no mgo ka-untudan, kangkatunai koy on sanga. Aw iyu gayod no mgo kabundu-an, ogpamakalibun kow podon kanami su manginun pad ogkamuwa koy to angod kan, ayaw sikan no ogkatuman dà to mahudi no adow.’ ");
INSERT INTO did_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ko konà mapalipasan to kado-otan to otow, agad wadà saà, woynu pad man to otow no dakoo to saà no konà man ogkapalipasan, su angod kanak nowadà saà, ogpaka-angod a dà to kayu no lindog pad. Dì ogmuwahon a dà gayod. Dì woynu pad to pagka-ubus to mgo otow no dakoo to saà su ogpaka-angod dà man kandan to nagangu no kayu no madaas ogdokotan.” ");
INSERT INTO did_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Na, pigdaa to sundau to daduwa pad no ka-otow dì dakoo on to saà dan aw nahimu on gayod no himatayanan on. Ogpanghimatayan to sundau kan tatou no igpantutuk diyà to kinurus. ");
INSERT INTO did_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Pagdatong dan diyà to untud no pighingadanan to Bobo-ungon to Otow, impantutuk kan tatou no otow no pinagdibauy ki Jesus kan daduwa no ka-otow no dakoo to mgo saà. ");
INSERT INTO did_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Na, nig-iling si Jesus diyà to Diyus to “Amoy, pasayluhon nu to kablang ku su wadà dan kama-ani to litukan to nahimu dan dini kanak.” Dayun pighahandug to mgo sundau to kabò ni Jesus no impabayà dan to tinag-anay dow intawa dapit kandan to makatu-un. ");
INSERT INTO did_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Natalidokan to kahan-ingan no nig-ahà kandin. Dì to mgo punu-an, naman-ina-ina ki Jesus no namang-iling to “Nigbulig kandin to duma. Kokoy man no konà din ogkabuligan to tu-un din no lawa ko tùt-u man no pigpilì on kandin to Diyus aw nahimu no Imananan to Ka-otawan.” ");
INSERT INTO did_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","To mgo sundau, namandugadi gayod no nigtadwoy to sukà no igpa-inom dan ki Jesus. ");
INSERT INTO did_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Nig-ikagi kandan to “Ko tùtu-u ka no harì to mgo ka-Hudiyuhan, anti ka kun bulig to ikow lawa.” ");
INSERT INTO did_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Insulat dan diyà to babow to uu ni Jesus no pig-iling to “Harì to mgo ka-Hudiyuhan.” ");
INSERT INTO did_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Songo dakoo to saà no intutuk no induug diyà to takidingan ni Jesus, nig-ina-ina dà gayod no nig-iling to “Na, ko tùt-u ka no Imananan to Ka-otawan, buligi kinow kun tibò.” ");
INSERT INTO did_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Dì kan sobu-uk, nigsapad no nig-ikagi to “Wadà pagkahadok nu to Diyus? Su mano nigtotopong dà to pagbo-ot ita to ukum. ");
INSERT INTO did_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Dì ita, kastiguhonon kid to saà. Dì sikan no otow, wadà saà din.” ");
INSERT INTO did_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Pig-ikagihan din nasì si Jesus to “Jesus, ogdomdomon a nu to umulì ka no mahimu kad on no harì no mabogbog.” ");
INSERT INTO did_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Nigtabak si Jesus to “Kunto-on no adow iyan og-agpot ka kanak diyà to botanganan to mangkadoyow no nangkamatoy on.” ");
INSERT INTO did_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Na pag-ugtu to soga, nigdiglom on to banwa hantod to mgo alas tris on to uras. ");
INSERT INTO did_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","No mawadà to bandog to soga, napongkas kan ingkayad no natongà du-on to habangan to abutanan to Diyus no sinabong diyà sood to labow no simbahan. ");
INSERT INTO did_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Dayun nig-ikagi si Jesus to ma-agbot to “Amoy, ogpa-andiya-on ku ikow to umagad ku,” aw tu-una din ligtasa to ginhawa din. ");
INSERT INTO did_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Pagkakita to kapitan to sundau to kaboonganan no intapik to pagkamatoy ni Jesus, nakasayà kandin to Diyus no pinakalabow din aw maka-ikagi to “Agaw man iyan kaboonganan no intapik to pagkamatoy sikan no otow su wadà iyan saà din. Dì nahimatayan man nasì.” ");
INSERT INTO did_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","To kapungan no nahimun no puli nig-ahà to pagkamatoy ni Jesus, namanboas-boas on kandan no nigsingkadabu to dagaha to pagsingkapook-pook dan. ");
INSERT INTO did_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","To mgo pigpantagaman ni Jesus aw mgo kabuyagan no taga-Galiliya no kanunoy namandumduma kandin, namanbantow puli to pag-ahà dow nokoy to nadoogan ni Jesus. ");
INSERT INTO did_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Na, moydu-on nigdaa to mgo Hudiyu no to ngadan si Jose no taga-Arimatiya. Matuwadong kandin aw bo-otan. ");
INSERT INTO did_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Wadà kandin uyun to paghimatoy ki Jesus aw kandin, nig-iman to pagsakup to Diyus. ");
INSERT INTO did_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Pig-andiya-an din si Pilato aw ba-id to kandin to oglobong ki Jesus. ");
INSERT INTO did_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Na, pigtugutan ni Pilato. Dayun piglingat ni Jose to patoy du-on to kinurus aw lukuti din to hinaboan no linu aw ibotang din to patoy no lawa ni Jesus diyà to oglobongan no pigbangbangan no batu no wadà pad kabotangi aligbat. ");
INSERT INTO did_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Na, imomo-ot on og-abut to tigsisigkonay agad-agad to kasugu-an to tinu-uhan to mgo Hudiyu. ");
INSERT INTO did_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Si Maria no taga-Magdala aw si Juana aw si Maria no inoy ni Santiago aw duma pad no mgo buyag no taga-Galiliya no namanduma ki Jesus, nigduma kandan ki Jose diyà to lobong aw namang-ahà to piglobongan aw kan pagbotang to patoy. ");
INSERT INTO did_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","No mahapun on, naman-ulì on kandan si Maria diyà to lunsud aw hina-ata dan to pahomut aw mgo hihinaki. Pagkahina-at dan on, tigsisigkonay on to mgo Hudiyu no mgo otow. Kaling man namansigkon kandan tibò su sikan man to katahanan no kasugu-an to mgo tinu-uhan dan. ");
INSERT INTO did_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Dì to pagkasunù no adow no kabukas-bukas pad lagboy, naman-andiyà kandan si Maria su oglo-uy to lobong ni Jesus no namandawdaa on to pahomut no nahina-at dan on. ");
INSERT INTO did_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","No pagdatong dan, naligad on tahan to batu no insomban to lingangahan to piglobongan. ");
INSERT INTO did_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Pagkasood dan, wadà dan on kakita-i to patoy. ");
INSERT INTO did_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Du-on naboong-boong on kandan aw tinakin moydu-on niglogwà kandan no daduwa no ka-otow no ogkasilawan ko aha-on to mgo kabò dan. ");
INSERT INTO did_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Nangkahadok kandan aw namakadudumuk kan mgo buyag to pag-ahà dan. Nig-ikagi on kan daduwa no ka-otow to “Nokoy man to igpanganap now pad todu-on no pigbuhoy on man dini to botanganan to patoy to nangkamatoy. ");
INSERT INTO did_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Domdoma now on man puli to innangon din iyu no ton diyà pad kandin to Galiliya ");
INSERT INTO did_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","no Tumutubus to Ka-otawan, ogdaahon diyà to mgo otow no dakoo to saà aw itutuk aw buhaya dà sood to tatou on no adow.” ");
INSERT INTO did_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Na du-on nadomdoman dan to pig-ikagi din. ");
INSERT INTO did_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","10","Na namang-ulì on kandan si Maria aw nangoni dan kan sampuù tag isa no tumutubus ni Jesus aw duma no mgo kasakupan din. ");
INSERT INTO did_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Dì wadà dan tu-uhi su iyan na-angodan to sugilon puli no konà no tùt-u. ");
INSERT INTO did_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Dì si Pedro, pagkadinog din, wadà inonoka no nig-andiyà to piglobongan dow tùtu-u iyan to nanangon bahin ki Jesus no impanlaguy din. Pag-abut din nigpagugukù-gukù no nigpang-ahà-ahà. No iyan dà nakita-an din to nabilin no impambodbod to patoy no nagawang on. Dayun kandin nigpati-ulì no nigdodomdom to napugut. ");
INSERT INTO did_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Na, sikan dà no adow, nighipanow on to daduwa no mgo tumutu-u ki Jesus padoog diyà to Imaus no lunsud no mgo sampuù tag duwa no ka-kilumitru no ingkahipanow dan likat diyà to Hirusalim. ");
INSERT INTO did_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","No namangindaan kandan kadoog namanbaaw-baaw kandan to bayà no napugut-pugutan. ");
INSERT INTO did_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","No namanbaaw-baaw kandan bahin ki Jesus, nigduguk kandin aw pagba-ot kandin du-on kandan. ");
INSERT INTO did_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Dì wadà din pakilaha kandan. ");
INSERT INTO did_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Kagi din to “Nokoy to nabaaw-baawan now no paghipanow now.” Nakasigkon kandan no nangkapanodò. ");
INSERT INTO did_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Kagi to sobu-uk no si Cleopas to “Dow naka-agpot ka dà buwa diyà to Hirusalim dì wadà ka kataga dow nokoy to bayà no napugut?” ");
INSERT INTO did_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Kagi ni Jesus to “Nokoy to napugut buwa.” Namakatabak kandan to “Dow wadà nu kadìnogi dow ma-amonu si Jesus no taga-Nasarit no maglilikwaday to Diyus no mabogbog aw pigpanghimu din no mabogbog aw mgo pangudlin din diyà to atubangan to Diyus aw ka-otawan. ");
INSERT INTO did_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Dì ton ita no mgo punu-an pigdaa dan diyà to gubirnu to taga-Ruma aw puli dan pighimu si Jesus no himatayanan aw padodopaha dan diyà to kinurus. ");
INSERT INTO did_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Na-iman noy dà podon to kandin to ogpatubuk ita to bandila no mgo Isrili. Asta pad natatouhan on no adow. ");
INSERT INTO did_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Hognà pad no moydu-on igkadugang awos matùtu-u sikan no nawnangonon no naboong-boongan noy su moydu-on mgo kabuyagan no kasing-tumutu-u noy no namanlo-uy to piglobongan ki Jesus ganina no kabukas-bukas pad ");
INSERT INTO did_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","aw wadà dan on kun kakita-i to patoy no lawa ni Jesus. Nigpati-ulì dayun kandan aw nawnangonon on kanami to moydu-on kun kinita dan no mgo diwata no nignangon kandan to si Jesus, pigbuhoy on kun. ");
INSERT INTO did_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Moydu-on niglikat du-on kanami no nig-andiyà aw kita-a to natuman dà kun iyan to ingkanangon kandan. Aw to patoy kun, wadà dan on gayod kita-a.” ");
INSERT INTO did_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Na nig-ikagi si Jesus to “Maotoy dà to pagpangindaag now to nasulat on to mgo maglilikwaday to Diyus ");
INSERT INTO did_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","no konà ogkahimù to Imananan to Ka-otawan no konà tugdow ogkalisodan aw kayan pana igkatinahud aw makasood to ogkadoogan no kinabuhì no wadà kinotoban.” ");
INSERT INTO did_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Dayun pigpambadbadan din to mgo kalitukan to tibò no kasulatan bahin to kandin lawa, likat to nasulat on ni Moises aw pagpambatuk-batuk to mgo nasulat to mgo maglilikwaday to Diyus bahin to kandin lawa. ");
INSERT INTO did_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Na no madani-dani on kandan to lunsud no ogdoogan dan, kunon kun oglaboy on podon ogpadayong si Jesus no konad oghapit. ");
INSERT INTO did_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Dì pighnggat dan to ogpahapiton diyà kandan aw ikagihi dan to “Mahapun on man. Ogpahapiton noy pad ikow dini kanami.” Dayun nigpagduma si Jesus kandan. ");
INSERT INTO did_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","To pagpamango-on to iyapun, pigdawat ni Jesus to paan aw pasalamati din du-on aw pamikas-pikasa din aw ipamogoy din. ");
INSERT INTO did_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Bali din on impakilaa kandan aw tinakin pigboong dan. ");
INSERT INTO did_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Na nigka-inikagihay kandan to “Nigdoyow iyan to ginhawa ta no nigbaaw-baaw kinow no ton diyà ki pad to pangindanan no pigbadbadan kinow din to kasulatan.” ");
INSERT INTO did_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Na kandan, namampa-ulì diyà to Hirusalim. Pagdatong dan on, tahan nahimun kan sampuù tag isa no pangabaga ni Jesus aw mgo duma dan ");
INSERT INTO did_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","aw sikan, nignangon kandan to “Pigbuhoy on iyan to Magbobo-ot aw logwa-a gayod si Pedro.” ");
INSERT INTO did_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Dayun pignangonan dan to napugut-pugutan diyà ton pagpangindanan dan aw bali ipakilaa kandan no ta-un diyà to pagko-onan dan. ");
INSERT INTO did_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","No ta-un to pagnangon dan, niglogwà si Jesus. ");
INSERT INTO did_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Dì natokawan aw kangkahadok su na-intobo-ot dan dow kandin, busow. ");
INSERT INTO did_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Nig-ikagi si Jesus to “Madumahan kow to kalinaw. Nokoy man no ogkapook-pook kow on aw kaduwa-duwa to ginhawa now. ");
INSERT INTO did_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Iyan aha-on now to kobong ku aw boad ku. Kanak si Jesus. Antiha a now dà dawata dow kanak iyan. To busow, wadà man mgo unud aw bokog, dì kanak, moydu-on man.” ");
INSERT INTO did_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Na impakita din kandan to boad din aw kobong din no nigbutiyow. ");
INSERT INTO did_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Konad no pagpamantukhow dan aw gayod pagkaboong-boong dan. Dì wadà-wadà pad kandan lagboy makatu-u. Nig-ikagi si Jesus to “Moydu-on dà buwa ogkako-on ku?” ");
INSERT INTO did_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Dayun pigbogayan dan kandin to isdà no nahaub on tahan. ");
INSERT INTO did_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Dinawat din aw ko-ona din diyà to atubangan to mgo pangabaga tibò. ");
INSERT INTO did_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Na nig-ikagi si Jesus diyà kan mgo pangabaga din to “Pignangonan ku iyu ton wadà a pad kamatoy to ogkatuman dà bahin kanak no nasulat on ni Moises aw duma no mgo maglilikwaday to Diyus aw sikan nasulat on ni David diyà to mgo Salmu.” ");
INSERT INTO did_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Du-on pigbuligan din aw ukasi din to pagpadaag to mgo ginhawa to pagsabut to mgo kasulatan. ");
INSERT INTO did_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Nig-ikagi kandin to “Nasulat on bahin to Imananan to Ka-otawan to ogkalisodan pad kandin aw pagkatatouhi no adow ogbuhayon ");
INSERT INTO did_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","aw mgo tumutubus din, ogpalapuwaason to pagpangudlin to ka-otwan no nigsingkabugtì dini to babow to kalibutan to ogsosoo kandan to paghimu dan no mado-ot aw oyowi aw du-on kandan ogpasayluhon to saà dan ko pumasakup to ngadan to nahimu no Imananan to Ka-otawan. Kani now to ogpalikatanan to pagpangudlin now to Hirusalim. ");
INSERT INTO did_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Og-apidan now tibò sikan su nakita now on su natuman on. ");
INSERT INTO did_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Sikan insahad iyu to Diyus no Amoy, ogpa-abuton ku dini iyu. Dì monang kow ogpakalogwà kani no lunsud no Hirusalim ko ogkangkatogob kow pad tibò to kabogbogan no oglikat diyà to langit.” ");
INSERT INTO did_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Na pinaduma ni Jesus tibò kandan hantod to Bitaniya no lunsud. Pinantodungan din to boad din aw papanalangini din kandan to Diyus. ");
INSERT INTO did_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","No ta-un pagpapalangin din, nabayow kandin diyà to langit. ");
INSERT INTO did_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Na nig-ampù kandan ki Jesus aw pamang-ulì kandan tibò diyà to Hirusalim no konad no pagpamantukhow dan. ");
INSERT INTO did_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Kanunoy dan pigsinayà-sayà to Diyus diyà to labow no simbahan.");
INSERT INTO did_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","2","Na, to kalinikatan no wadà pad kabotad so-idi kalibutan, naka-ugpà on tahan diyà to langit to otow no nahingadanan to Kagi to Diyus. Kandin, Diyus dà man gayod aw timbang dà kandin to Diyus no na-uyunan. No pagkatimbang din to Diyus, likat to kapinunu-an no na-uyunan kandin, ");
INSERT INTO did_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","nigpagtibò kandin to Diyus to pagpangbotad tibò. Wadà nabotad ko konà no kandin to pinabaya-an no nahingadanan to Kagi to Diyus. ");
INSERT INTO did_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Na sikan nahingadanan to Kagi to Diyus, umu-ukas to kandan no pagkadiyus su kandan no katahani. Kandin iyan to piglikatan to kinabuhì ta no konad ogkawadà no natibo-an to kandin kinabuhì. Na sikan kinabuhì din, tumatang-away to mgo otow su igka-ukas to domdom dan ");
INSERT INTO did_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","aw sikan no tumatang-away, oglanyag dini to kadigloman, aw sikan gayod no kadigloman to domdom to otow, konà ogpakada-og sikan no lanyag. ");
INSERT INTO did_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Na, to wadà pad ipakilaa si Jesu-Kristu no tumatang-away to mgo otow, moydu-on pigpa-una kandin to Diyus su awos kandin to ogtaga to mgo otow awos ogkapatu-u to tibò to mgo otow du-on kan tumatang-away. Iyan ngadan din si Juan. ");
INSERT INTO did_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Konà no kandin to tumatang-away to mgo otow. Dì si Juan to pigpa-andini to Diyus su pigbogayan kandin to katondanan to pagmatu-ud dow intawa iyan lagboy to tumatang-away aw patu-uhon din to ka-otawan diyà ki Jesus. ");
INSERT INTO did_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","No madaas on to pagkaponga ni Juan to kandin katondanan, imomo-ot on oglogwà kan tùtu-u no tumatang-away to tibò to mgo otow dini to babow to kalibutan. ");
INSERT INTO did_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Na kunto-on si Jesus, nakalogwà on iyan dini to babow agad kandin dà to niggihit so-idi no kapasakan. Dì to mgo otow, wadà dan kandin tahoma to iyan niggihit. ");
INSERT INTO did_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Kandin, nakasood on iyan to kandin banwa, dì wadad on uyuni kandin to kadumahan din no kahan-ingan. ");
INSERT INTO did_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Dì moydu-on dà namantu-u aw pasakup du-on kandin, aw kandan no namantu-u, pigpamogayan din to kabogbogan no ogkahimu kandan no mgo anak to Diyus no agad intawa no ogtu-u to kandin ngadan su ogkalabot dà man kandan gayod ogkadawat to kandin katu-unan tibò. ");
INSERT INTO did_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Aw to kinabuhì ta no konad ogkawadà, wadà makalikat to langosa to otow dow ibog to otow aw to pagbo-ot to otow. Dì sikan konad ogkawadà no kinabuhì ta, Diyus iyan to nalikatan. ");
INSERT INTO did_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Na sikan nahingadanan to Kagi to Diyus, nigpaka-otow on kandin aw agpot dini ita no mgo otow no natogob kandin to katuwadongan aw katùtu-uhanan. Inukasan din on dini kanami to kaboonganan din no kandin dà iyan to moydu-on angod sikan no kaboonganan no kandin dà gayod to sobu-ukon no Anak to Diyus. ");
INSERT INTO did_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Kandin no si Jesus, pigmatu-ud ni Juan to kandin iyan to tùtu-u no Imananan to Ka-otawan, aw ipamasabut din kandan no nig-iling to “Sikan no otow to innangon ku iyu no moydu-on ogpakasukoli pad hognà kanak no oglabow pad lagboy dini kanak to kabogbogan, su to wadà a pad ka-otow, naka-ugpà on kandin tahan.” ");
INSERT INTO did_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Aw pigpamogayan kinow din to panalangin no niglikat to kandin pagkadakoo. ");
INSERT INTO did_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Su agad si Moises to pinabaya-an to pagbogoy ita to kasugu-an to Diyus no impatuman ita, dì si Jesu-Kristu no Imananan to Ka-otawan to pinabaya-an to pagbogoy ita to panalangin aw katùtu-uhanan tibò. ");
INSERT INTO did_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Wadà otow no nakakita to Diyus. Dì Anak to Diyus no timbang din, kandin to nig-ukas dini ita awos makita-an to Amoy. ");
INSERT INTO did_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Na, to mgo punu-an to tinu-uhan to mgo Hudiyu no taga-Parisiyu gayod no matagon-tagonon lagboy to kandan katahanan, pigpapangintaga dan to mgo pangabaga dan aw duma no mgo kasakupan dan no sugpù gayod ni Lebi dow intawa kun lagboy si Juan no namonyag aw ando-i kun makalikat to kabogbogan din. ");
INSERT INTO did_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Dì pagtabak ni Juan sikan nigpang-usip-usip bahin to katondanan din, nignangon kandin to tùtu-u no nig-iling to “Konà no kanak to Imananan to Ka-otawan.” Wadà kandin ginaù bahin to katondanan din. ");
INSERT INTO did_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Pig-usip kan mgo sakup to punu-an to “Nokoy man no namonyag ka to mgo ka-otawan. Intawa ka buwa lagboy, dow si Elias ka?” Nakatabak si Juan to “Konà.” Inusip dan mandà to “Dow lagsoban ka to Diyus no sikan no maglilikwaday din no og-imanon noy to oglogwà to kinahudihan?” Nakatabak si Juan to “Konà.” ");
INSERT INTO did_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Pig-usab dan pig-usip to “Intawa ka man iyan lagboy. Nangoni koy su awos moydu-on igkanangon noy to nigsugù kanami. Nokoy no iyan lagboy to ikow katondanan.” ");
INSERT INTO did_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Nakatabak si Juan to “Puli a napa-atubangan to kagi no na-iling to ‘Diyà to kahanongan no banwa moydu-on nigpangudlin to ma-agbot lagboy no nig-iling to, Oghina-aton now to daan to Magbobo-ot ta. Ogtul-idon now to igbayà din,’ su sikan to intag-an natodu-on ni Isaias no maglilikwaday no lagsoban to Diyus.” ");
INSERT INTO did_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Na sikan mgo otow no pigpa-andiyà to mgo Parisiyu no pigpapangusip-usip dan ki Juan, ");
INSERT INTO did_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","naman-iling kandan to “Ko konà ka no Imananan to Ka-otawan aw ko konà ka no si Elias aw ko konà ka gayod no maglilikwaday no og-imanon noy to oglogwà to kinahudihan, nokoy man no pigpambonyagan nu kan no mgo ka-otawan.” ");
INSERT INTO did_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Nakatabak si Juan to “Ogmatu-udon ku to pagpasakup dan to impang-anad ku to pagbonyag ku kandan to wohig. Dì moydu-on on dini iyu no otow no wadà now kilaha. ");
INSERT INTO did_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Kandin to ogsukoli kanak. Kanak igatang podon ogpabatà-batà a du-on kandin. Dì konà a su labow pad man lagboy kandin dini kanak to kabogbogan.” ");
INSERT INTO did_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","29","Na to sunù no adow no diyà pad si Juan to pigbonyagan din no Bitaniya no diyà dihipag to Hurdan no wohig, nakita-an din si Jesus no ogduguk kandin. Nig-ikagi si Juan diyà to ka-otawan to “Na, og-indanan now, suyad on iyan to angod to buhì no igsundù to Diyus no ogpakagawang to saà ta no mgo otow tibò su ogpakimatoy ita. ");
INSERT INTO did_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Sikan on iyan to innangon ku iyu no na-ikagi ku to ‘Imomo-ot on oglogwà to otow no ogpakasukoli kanak dì oglabow pad man lagboy dini kanak to kabogbogan su to wadà a pad ka-otow, naka-ugpà on kandin tahan.’ ");
INSERT INTO did_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Kanak natodu-on, wadà ku pad kama-ani dow intawa to ogkahimu no Imananan to Ka-otawan. Dì iyan inlogwà ku dini su ogpanma-an a to mgo Isrili dow intawa to Imananan ko lumogwà. Pigmatu-ud ku to pagpasakup to mgo ka-otawan to kanak impang-anad to pagsosoo to katahani dan no bugtì aw oyowi no impabayà to pigbonyagan ku kandan awos makahina-at kandan ko lumogwà kan Imananan to Ka-otawan.” ");
INSERT INTO did_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Na, innangon gayod ni Juan no nig-iling to “Nakita-an ku to pigbunsudan si Jesus to Ispiritu Santu no iyan na-angodan to salapati aw pakamonang du-on kandin. ");
INSERT INTO did_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Kanak, wadà ku kilaha to Imananan natodu-on dì sikan nigpa-andini kanak to pagbonyag to wohig, nig-iling dini kanak to ‘To otow no ogbunsudan to Ispiritu Santu aw pakamonang du-on, kandin to ogmatu-ud to pagpasakup to mgo ka-otawan to kandin impang-anad no igpabayà to ogbonyagan kow to Ispiritu Santu no iyan ogsoodan kow din lagboy.’ ");
INSERT INTO did_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Na nakita-an kud on to na-ikagi kanak no pigbunsudan kandin, aw ogmatu-udon kud kunto-on to kandin, Anak to Diyus iyan.” ");
INSERT INTO did_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Na, to sunù no adow no nigtagad kandan si Juan aw si Andres aw duma no sakup din, nabaya-an kandan ni Jesus. ");
INSERT INTO did_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Pig-ahà kandin ni Juan aw ikagi to “Og-indanan now su suyad on iyan to otow no angod to buhì no igsundù to Diyus no ogpakatubus to saà to mgo otow.” ");
INSERT INTO did_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Kandan si Andres aw duma din, namakadinog to napa-atubangan to pig-ikagi ni Juan aw dayun kandan namanlupug tibò ki Jesus. ");
INSERT INTO did_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Nakalingì si Jesus aw kita-a din to daduwa no ka-otow no niglupug kandin aw maka-iling to “Nokoy to tu-ud now.” Nakatabak kandan to “Sir, ando-i to ikow no ugpa-anan.” ");
INSERT INTO did_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","40","Nigtabak si Jesus to “Duma kow kanak awos makakita kow to ugpa-anan ku.” Dayun namanduma aw makakita to kandin pig-ugpa-an aw du-on pakamonang su mahapun on. ");
INSERT INTO did_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Na no pagkama-an ni Andres to pigtudli-an ni Juan to Imananan to Ka-otawan no si Jesus, pigpangahà din to kakoy din no si Simon Pedro awos mataga kandin gayod. No mabaya-an din on, naka-ikagi to “Nakita-an noy to Misiyas,” no iyan nalitukan to Imananan to Ka-otawan. ");
INSERT INTO did_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Dayun pig-alladan din si Pedro diyà ki Jesus. Na nig-ahà si Jesus diyà ki Pedro aw ikagi to “Aw ikow man na-an si Simon no anak ni Juan. Na, oghingadanan ku ikow ki Sipas,” (ko ita pa, si Pedro, no iyan nalitukan to batu). ");
INSERT INTO did_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Na, to sunù no adow mandà nakapikii si Jesus to og-andiyà to Galiliya. Du-on impagkita din si Felipe. Pagkakita din, pig-ikagihan ni Jesus to “Pasakup ka kanak Lagi, aw duma ka kanak.” ");
INSERT INTO did_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Na si Felipe, taga-Bitsayda no kasing-taga-lunsud dà ni Andres aw ni Pedro. ");
INSERT INTO did_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Dayun pigpangahà ni Felipe si Natanael. Pagkabayà din, pig-ikagihan to “Nakita-an noy on to otow no pighimu no Imananan to Ka-otawan no nasulatan ni Moises natodu-on aw duma pad no lagsoban to Diyus du-on to mgo kasulatan. Kandin, si Jesus no taga-Nasarit no anak ni Jose.” ");
INSERT INTO did_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Naka-ikagi si Natanael to “Na-amonu man buwa, su wadà kun madoyow no otow no taga-Nasarit.” Nakatabak si Felipe to “Duma ka awos makakita ka.” Dayun namang-andiyà. ");
INSERT INTO did_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Na, pagkita ni Jesus ki Natanael no ogduguk, nig-ikagi kandin to “Indanan now so-idi sugpù ni Israel no tùtu-u no matino-od.” ");
INSERT INTO did_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","No madinog ni Natanael, naka-ikagi to “Na-amonu man no pigkilaa a nu man.” Nigtabak kandin to “To wadà ka pad tawaga ni Felipe no diyà ka pad to saom to igira no kayu, nakita-an kud tahan ikow.” ");
INSERT INTO did_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Naka-ikagi kandin to “Sir, nama-anan kud on to Anak ka na-an to Diyus no Harì to ka-Isrilihan su nakilaa a nud on.” ");
INSERT INTO did_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Nig-ikagi si Jesus to “Nakatu-u ka buwa su pignangonan ku ikow to nakita-an ku ikow diyà to saom to igira no kayu? Oglabow pad to ogkakita-an nu to mahudi no adow. ");
INSERT INTO did_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","So-idi iyan, ogkakita-an nu to langit no ogkatau-angan aw logwà to mgo diwata no likat to Diyus. Ogpamanbunsud kandan du-on to Tumutubus to Ka-otawan aw pamakawoy dà kandan.” ");
INSERT INTO did_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Na kandan si Jesus no pagkatatouhi no adow no pagpaman-ulì dan on diyà to Galiliya no prubinsiya, nakata-un kandan to moydu-on pagsauhan diyà to lunsud to Kana, aw paba-ota kandan tibò aw inoy ni Jesus. ");
INSERT INTO did_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Pagkaugoy-lugoy du-on pigkabusan kandan to inomon no tagtu-un to pagsauhan. Dayun pignangonan si Jesus to inoy din to “Utù, amonuhon on buwa kandan to ogka-inom dan su pigkabusan on kandan.” ");
INSERT INTO did_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Nakatabak si Jesus to “Konà-konà pad Inoy no ogkagotò to kanak adow no Imananan to Ka-otawan.” ");
INSERT INTO did_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Dì to inoy din, pignangonan din to mgo sugu-onon to tagtu-un to pagsauhan to “Ogkatuman now dà to agad nokoy no igsugù din.” ");
INSERT INTO did_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Na moydu-on onom no bobotangan du-on kan no baoy no hinimu no likat to batu no katinguban to tulumanon to mgo Hudiyu no pighingadanan to paglinis. Kada bobotangan, ogkatagu-an to mgo onom dow upat no lata. ");
INSERT INTO did_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Na, insugù ni Jesus to “Na, ponu-a now tibò to bobotangan to wohig.” Dayun pinamonù dan lagboy tibò. ");
INSERT INTO did_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","“Na,” kagi ni Jesus, “sauk kow aw daaha now diyà to nigdaa to pagsauhan.” Pigdaa dan aw pa-antihi. ");
INSERT INTO did_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","No pagka-anti din, iyan on nabauyan kan wohig to inomon. Dì wadà din katagahi dow nokoy to piglikatan to inomon, dì natagahan kan mgo sugu-onon no namansauk to wohig to piglikatan. Dayun pig-andu-onan din to tagtu-un to pagsauhan ");
INSERT INTO did_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","aw ikagihi din to “Nokoy man no monang nu pigpantada-an to napingaa on no inomon no nangkahingow on tibò to bumaba-ot aw kayan nu ogpantada-an to wadà pad lagboy kapingaa su konà dan ogkatagahan dow madoyow dow mado-ot. To mgo tagtu-un to pagsauhan, kadoog ogtugdawon ogtada-on to napingaa. Dì ikow, bali ka kunto-on ogtadà to napingaa on lagboy.” ");
INSERT INTO did_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Na sikan no kaboonganan ni Jesus to tugdow din pighimu diyà to Kana, Galiliya, aw bali din ipakita to kabogbogan din. Kaling man nadugangan to pagtu-u to mgo sakup din du-on kandin. ");
INSERT INTO did_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Na dayun naman-andiyà kandan si Jesus to Kapirna-um no lunsud no iyan nadumahan to inoy din, mgo su-un din, aw duma pad no mgo sakup din aw pamang-ugpà kandan du-on to wadà dà pilahi no adow. ");
INSERT INTO did_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Na namanpadayong kandan si Jesus diyà to Hirusalim no lunsud su madaas on to adow to hinang to mgo Hudiyu no pighingadanan to Hinang to Pagpalipas to Kado-otan. ");
INSERT INTO did_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Pagdatong dan aw ni Jesus aw mgo sakup din, namansood diyà to labow no simbahan to Diyus. Nakita-an ni Jesus to mgo mamaligya-ay to baka, karniru, aw salapati aw sikan mgo magkakambiyu to sapì no naman-ingkud no nighangad diyà to lamisa dan su sikan to kandan no pagpanapì. ");
INSERT INTO did_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Na, niglubid si Jesus to iglatus aw pigpambohus kandan tibò aw mgo buhì diyà to simbahan. Pigkanat din to sapì aw pambaliskada din to lamisa. ");
INSERT INTO did_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Pig-ikagihan din to mamaligya-ay to salapati to “Panggawanga now sikan kani. Konà now oghimuhon no bolihanan so-idi abutanan to Amoy ku.” ");
INSERT INTO did_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Pagkadinog to mgo sakup din no namanduma, nadomdoman dan to nasulat on bahin to Imananan to Ka-otawan du-on to kasulatan to Diyus no pig-iling to “Pagkatibuus kud to pagbantoy kud to ikow abutanan, igkado-ot ku dà man.” ");
INSERT INTO did_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Dì to mgo punu-an to tinu-uhan to Hudiyu, namaka-usip to “Nokoy to kaboonganan no ogkahimu nu no igkamatu-ud nu to Diyus to piglikatan to ikow kabogbogan to pagbo-ot bahin to simbahan ta.” ");
INSERT INTO did_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Nakatabak si Jesus to “Ko ogdodo-oton now so-idi abutanan to Diyus, ogka-uliman ku dà to sood to tatou no adow.” ");
INSERT INTO did_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Namaka-ikagi to mgo Hudiyu, “Konà nu buwa ogkatuman sikan pig-ikagi nu su so-idi no simbahan no labow no abutanan to Diyus, pigpangkap-atanan no tu-ig aw onom to paghimu so-i. Dì ikow, niglangub ka to nig-ikagi to ogka-uliman nu dà to sood to tatou no adow.” ");
INSERT INTO did_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Dì si Jesus, wadà din kapa-atubangi to kagi to simbahan to Diyus. Iyan nasì napa-atubangan din to tu-un din no lawa no abutanan to Diyus. ");
INSERT INTO did_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Aw to timpu to pagbuhoy ki Jesus, nadomdoman to mgo sakup din to na-ikagi din du-on aw namantu-u lagboy kandan to kasulatan to Diyus aw sikan kalitukan to na-ikagi ni Jesus. ");
INSERT INTO did_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Na no pagba-ot ni Jesus to Hinang no pighingadanan to Pagpalipas to Kado-otan diyà to Hirusalim, mahan-ing to nigtu-u su nakita-an dan to kaboonganan no pighimu din. ");
INSERT INTO did_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Dì si Jesus, wadà nasaligan din su du-on dan podon ogpadangonon to pagkaharì ni Jesus agad dow konà pad magotò. ");
INSERT INTO did_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Dì nama-anan din iyan dow nokoy diyà to sood to ginhawahan to mgo otow tibò su kandin, konà ogkanangonan. ");
INSERT INTO did_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Na moydu-on punu-an to tinu-uhan to mgo Hudiyu no nasakup to panon no pighingadanan to Parisiyu. Iyan ngadan din si Nikudimu. ");
INSERT INTO did_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","To madukilom nig-andiyà kandin ki Jesus su awos pumangindaag kandin to impang-anad ni Jesus. Pagdatong din nig-ikagi kandin du-on ki Jesus to “Sir, nama-anan noy to ikow, pigpa-andini ka to Diyus awos ka makapang-anad kanami su wadà otow no ogka-amu oghimu to kaboonganan no angod to nahimu nu ko konà no Diyus to nigbulig sikan.” ");
INSERT INTO did_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Nig-ikagi si Jesus to “So-idi iyan, monang ogkalabot to otow to pagsakup to Diyus ko ogka-usab pad ogka-otow no kayan kandin ogkasakup to Diyus.” ");
INSERT INTO did_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Naka-ikagi si Nikudimu to “Aw na-an. Og-amonuhon man to pagka-otow mandà ko manigo-on on. Dow ogpakasood ki pad buwa mandà to gotok to inoy ta aw ig-usab ki dà ig-anak?” ");
INSERT INTO did_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Nakatabak si Jesus to “So-idi iyan, monang ogkalabot to otow to pagsakup to Diyus ko wohig to igmatu-ud din to pagpasakup din aw ogka-usab pad ogka-otow likat to Ispiritu Santu. ");
INSERT INTO did_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","To oglikat to otow, bullug man otow dà iyan. To oglikat to Ispiritu Santu no iyan Diyus no Katuusan, bullug man katuusan iyan. ");
INSERT INTO did_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Konà nu ogkaboong-boongan to inikagi ku ikow no ogka-usab kow pad ogka-otow. ");
INSERT INTO did_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Na ko ogsabod to kamag, agad ando-i to ogkabutuk, ogkadinog ta to kagaskas, dì wadà ta katagahi dow ando-i makalikat aw ando-i to ogkabutuk Angod dà man ko ma-usab kow ma-otow to kabogbogan to Ispiritu Santu, ogkatuman dì wadà now katagahi dow ma-amonu.” ");
INSERT INTO did_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Naka-ikagi si Nikudimu to “Ogka-amonu buwa to pagkatuman to pig-ikagi nu.” ");
INSERT INTO did_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Nigtabak si Jesus to “No mag-a-anad ka man no nadinog-dinog on dini to ka-Isrilihan, nokoy man no wadà nu pad kadaagi to pig-ikagi ku ikow. ");
INSERT INTO did_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Na kanami, ogkanangon noy iyu no namantagon lagboy to tinu-uhan to mgo Hudiyu to nama-anan noy aw nakita-an noy. Dì iyu, wadà now tu-uhi to innangon noy. ");
INSERT INTO did_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nignangon a iyu bahin to kadodoog to kalibutan, dì wadà kow makadaag. Woynu pad buwa ko kadodoog on to langit to inangon kud iyu, konà now on ogkadaagan. ");
INSERT INTO did_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Wadà nigkawoy diyà to langit ko konà no nigbunsud likat to langit no Tumutubus to Ka-otawan. ");
INSERT INTO did_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Na ko pananglitan, to inuwod-uwod no pigpahungunan ki Moises to Diyus no bulunsi diyà to kahanongan no banwa, intukoy din du-on to kayu awos makita-an to mgo otow no nangkakagat to mgo uwod aw ogkangkagawangan dà kandan to laas su nigtu-u kandan to impa-ikagi ki Moises to Diyus. Na kanak no Tumutubus to Ka-otawan, ogpaka-angod a dà su igkatutuk a diyà to kinurus aw lindoga ");
INSERT INTO did_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","su awos to ogtu-u kanak, ogkabogayan to kinabuhì no konad ogkawadà. ");
INSERT INTO did_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Nalogonan to Diyus to mgo otow dini to babow to kalibutan hantod to Anak din no sobu-ukon, pigpatubus din no iyan ogpakimatayan din to mgo saà dan. Agad intawa no ogsalig kandin, konad ogkagawang kandin to atubangan to Diyus, dì ogkabogayan nasì to kinabuhì no konad ogkawadà. ");
INSERT INTO did_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Pagpa-andini to Diyus to Anak din dini to kalibutan, konà no iyan tu-ud din to ogkastiguhon to mgo otow to saà dan dì oglipwasan din kandan to saà dan. ");
INSERT INTO did_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","To nigsalig kandin, konà din on ogkahibatan to saà din, dì to wadà salig, ogkahibatan din dà to saà din su wadà salig kandin to ngadan to sobu-ukon no Anak to Diyus. ");
INSERT INTO did_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","“So-idi iyan to saà no ogkahibatan to mgo otow su niglogwà on to Tumatang-away aw pandalipaak dini to kalibutan, dì to mgo otow, pigpa-aag-aag dan nasì to kadigloman. Wadà dan nasì pa-aag-aaga to ka-awangan su ogkahadok ko ma-ukasan to kandan hininang no mado-ot. ");
INSERT INTO did_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Tibò no mado-ot to hininang, ogkablangon dan to lanyag aw konà ogduguk su dagow matagahan to hininang dan no mado-ot. ");
INSERT INTO did_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Dì to madoyow to hininang, ogduguk to lanyag awos igkapapayag to kandan hininang no madoyow, ogka-uyunan to Diyus.” ");
INSERT INTO did_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Na pagkatapus to Hinang to Pagpalipas to Kado-otan, namanggawang on kandan si Jesus to Hirusalim aw pamang-andiyà to kahilitan to prubinsiya to Hudiya aw pambonyagi dan to mgo ka-otawan no nigpamanpasakup to impang-anad din. ");
INSERT INTO did_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Angod dà gayod diyà to Inun Salim su si Juan, pigpambonyagan din gayod to mgo ka-otawan no nigpasakup to impang-anad din su moydu-on man wohig du-on no litos to ogkabonyagan. ");
INSERT INTO did_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Sikan no pagpamonyag ni Juan ton wadà pad kandin kapirisu. ");
INSERT INTO did_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Na moydu-on songo otow no nigtagon to tinu-uhan to mgo Hudiyu no nigpag-asuy to mgo sakup ni Juan bahin to pagbonyag ni Jesus aw pagbonyag ni Juan gayod. ");
INSERT INTO did_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Dayun pig-andiya-an si Juan to mgo sakup din aw ikagihi kandin to “Sir, si Jesus no pigmatu-ud nu natodu-on to kandin katondanan diyà dihipag to Hurdan, nigpambonyag on kandin to mgo otow no namanpasaup kandin aw tibò namanduguk diyà kandin.” ");
INSERT INTO did_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Naka-ikagi si Juan to “Wadà kabogbogan no ogka-abin to otow, agad intawa, ko konà no Diyus diyà to langit to ogbogoy. ");
INSERT INTO did_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Dì iyu, ogmatu-udon now to kanak, na-ikagi kud on iyu to konà a no Imananan to Ka-otawan. Dì napa-una a kandin awos mahina-at ku to pagdatong din. ");
INSERT INTO did_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Na ko pananglitan to ogpakatu-un to asawahon din, kandin to tumatawas. Dì to mgo kadumahan to tumatawas, ogkangkaliyag gayod su ogkangkalabot to pagtukhow to tumatawas. Kaling man nigtukhow a lagboy su kanak, na-angodan ku to duma to tumatawas. ");
INSERT INTO did_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Kunto-on kandin, ogpakalabow, dì kanak, ogpasagkop a.” ");
INSERT INTO did_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Na to niglikat diyà to langit, ogpalabawon kandin tibò. Dì to niglikat puli dini to babow to pasak, iyan dà nama-anan din to kadodoog to pasak aw kandin igpang-anad bahin to kadodoog to pasak. Dì to niglikat diyà to langit, kinalabawan kandin. ");
INSERT INTO did_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Kandin, ognangon to nakita-an din aw kadinog din ton diyà pad kandin to langit. Dì wadà nigtu-u. ");
INSERT INTO did_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Dì moydu-on dà nigtu-u to kagi din aw matu-uda dan to ogtumanon to Diyus to na-ikagi din ");
INSERT INTO did_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","su kandin no pina-andini to Diyus, iyan oglituk to kagi to Diyus no pinabayà to kabogbogan to Ispiritu Santu no imbogoy kandin no wadà kapanggadanan. ");
INSERT INTO did_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","To Diyus, nalogonan din to Anak aw patubusa din aw iyan papanguuha to kandin pigsakupan tibò. ");
INSERT INTO did_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","To nigtu-u to Anak to Diyus, moydu-on on kinabuhì din no konad ogkawadà aw kandin, ogtuuson on. Dì to konà ogtuman to Anak to Diyus, konà man ogtuuson dì nataunan on kandin nasì to kaboù to Diyus. ");
INSERT INTO did_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Na og-uli-on tad to tutuwanon ki Juan aw ki Jesus no nigsimbonyag to mgo ka-otawan no namanpasakup to kandan mgo impang-anad. Dì si Jesus, konà no kandin to nambonyag. Dì sikan mgo pangabaga din dà to namanbonyag. Na to mgo Parisiyu no matagon-tagonon to kandan katahanan, nadinogan dan to “Nakada-og si Jesus to pagpansakup to mgo ka-otawan.” No pagkama-an ni Jesus to nadinogan to mgo Parisiyu kandin, insigkon din to pambonyag aw hipanow on kandin likat to Hudiya aw pa-ulì diyà to Galiliya. ");
INSERT INTO did_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Dì nakabayà kandan si Jesus to Samariya no prubinsiya. ");
INSERT INTO did_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Na, no ma-ugtu to soga nakadatong kandan diyà to tawoy to Sikar no songo lunsud du-on to Samariya no madani-dani dà to pasak no imbogoy ni Jacob diyà to anak din no si Jose. ");
INSERT INTO did_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","8","Na sikan no pasak, du-on dà makabotang no saukanan no pighingadanan to Balu ni Jacob. Na si Jesus, kan no pagtidow dan du-on sikan no saukan, puli on naka-ingkud kandin du-on to dani lagboy to balun su napagud man to paghipanow. Dì to mgo pangabaga din, namanpadayong diyà to lunsud su ogboli to ogkako-on dan. Dì si Jesus, nigtagad du-on to saukan. Puli dà nali-us to mgo pangabaga din, naka-abut to buyag no taga-Samariya no ogsauk. Dì sikan no uras konà podon no litos no sasaukay su ma-ugtu man. Na si Jesus, nig-ikagi to “Og-inom a to wohig.” ");
INSERT INTO did_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nig-ikagi to buyag to “Nokoy man. Naboong-boongan ku ikow su ikow, Hudiyu ka man no otow, dì ogpamuyù ka to wohig kanak, no kanak, taga-Samariya a man.” Na to mgo Hudiyu aw mgo taga-Samariya, konà tahan ogkasosood. ");
INSERT INTO did_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Kagi ni Jesus to “Agad nabuyù kud on to wohig no ogkaliyagan ku no og-inomon, dì ko nama-anan nud on pa podon dow nokoy to igkabogoy to Diyus aw dow intawa a no nigpagbaaw ikow, ogpabogoy ka podon nasì kanak to ogtubud no wohig no makagbuhoy no igka-usab to ginhawa nu aw igtuusa nud to mahudi no adow.” ");
INSERT INTO did_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Naka-ikagi to buyag to “Dì wadà igsauk nu Sir, aw madaom. Ando-i nu sauka no wohig no ogtubud no makagbuhoy. ");
INSERT INTO did_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Konà ka buwa no labow pad to apù ta no si Jacob no nigbogoy kanami so-idi no saukan no litos kandan aw apù ta no si Jacob natodu-on aw mgo kabuhi-an din.” ");
INSERT INTO did_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Nakatabak si Jesus to “To otow no og-inom so-idi no wohig, oglanggahan nasì. ");
INSERT INTO did_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Dì to og-inom to wohig no igbogoy ku no makagbuhoy, konad oglanggahan. To wohig no igbogoy ku, ogkahimu no tubud no og-ugwak no iyan ogkapanggadan to banwa no wadà kamatayon.” ");
INSERT INTO did_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Naka-ikagi to buyag to “Sir, bogayi a nu sikan no wohig awos konà ad oglanggahan aw konà ad maka-aboy makasauk kani.” ");
INSERT INTO did_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Na nig-iling si Jesus to “Na, pa-andiniha to bana nu.” ");
INSERT INTO did_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Naka-ikagi to buyag to “Wadà bana ku.” Nig-ikagi si Jesus to “Tùtu-u iyan no wadà bana nu. ");
INSERT INTO did_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Dì ikow, na-inagpotan kad on to lima no lukos. To nig-agpot gayod ikow kunto-on, puli nu dà binana-bana sikan. Tùtu-u iyan to na-ikagi nu.” ");
INSERT INTO did_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Naka-ikagi to buyag to “Aw, lagsoban ka na-an Sir. ");
INSERT INTO did_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Na, to kanami ka-aw-apu-an, kani so-idi untud ampu-anan dan, dì iyu no Hudiyu, ogmatu-udon now to Hirusalim podon to ampu-anan to mgo otow.” ");
INSERT INTO did_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Naka-ikagi si Jesus to “Ognangonan ku ikow to moydu-on adow no ogkagotò to konà ogka-ampu-an to Diyus diyà to Hirusalim aw so-idi no untud gayod. ");
INSERT INTO did_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Na to pag-ampù now to Diyus likat pad to ka-aw-apu-an now, konà no litos, su wadà dan tibo-i uyuni to kasulatan to Diyus. Dì to pag-ampù noy no mgo Hudiyu, litos su tibò on na-uyunan noy aw kanami no Hudiyu to piglikatan to Imananan to Ka-otawan. ");
INSERT INTO did_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Dì imomo-ot on ampu-anan to Diyus no Amoy to ginhawahan to mgo sakup din su ko umampù kandan, to kagi dan ogkadumahan to ginhawa dan su sikan iyan to tùtu-u no pag-ampù. Ogpanganap to Diyus to otow no angod kan no pag-ampù kandin. ");
INSERT INTO did_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Diyus, katuusan man kandin. Kaling man og-ampù ki to Diyus no ogkadumahan pad to ginhawa no wadà paghisabaag su sikan to tùtu-u no pag-ampù to Diyus.” ");
INSERT INTO did_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Naka-ikagi to buyag to “Nama-anan ku to og-andini to Imananan to Ka-otawan no pighingadanan gayod to Kristu. Pagdatong din, ogpasabuton kinow din tibò.” ");
INSERT INTO did_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Nig-ikagi si Jesus to “Kanak no nigpagbaaw ikow, Imananan a to Ka-otawan.” ");
INSERT INTO did_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Na namang-ulì on to mgo sakup ni Jesus no nata-unan to pagbabaaw dan pad aw kaboong-boong kandan su nigpagbaaw si Jesus to buyag. Dì wadà naka-usip to buyag to “Dow nokoy to tu-ud nu.” Wadà gayod naka-usip ki Jesus to “Nokoy man no nigpa gbaaw ka to buyag dà.” ");
INSERT INTO did_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Dayun na-oyowan to buyag to pigsung-oy din no wohig aw makapa-ulì diyà to lunsud. Pignangonan din to mgo taga-lunsud to ");
INSERT INTO did_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Duma kow kanak. Og-alladan ku iyu diyà to otow no nignangon kanak to nahimu ku tibò. Dow konà buwa no Imananan to Ka-otawan sikan?” ");
INSERT INTO did_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Dayun namanlikat on kandan aw padoog diyà ki Jesus. ");
INSERT INTO did_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Na og-uli-on tad to tutuwanon kandan aw ki Jesus. Pighinggat podon si Jesus to mgo sakup din to ogko-on su nakaboli on kandan to ogkako-on diyà to lunsud. Kagi dan to “Ogko-on kid Sir.” ");
INSERT INTO did_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Dì naka-iling si Jesus to “Moydu-on ingkabuhì ku no wadà now kama-ani.” ");
INSERT INTO did_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Nigka-inusipay to mgo sakup to “Ando-i buwa makako-on kandin.” ");
INSERT INTO did_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Nig-ikagi si Jesus to “Ogpa-aag-aagon ku to pagtuman to pagbo-ot to Diyus. Konà ku ogpa-aag-aagon to igkabuhì to lawa ku puli. To pagtuman ku to pagbo-ot to Diyus, aw kaponga to igpahinang din kanak, sikan to angay sodà ku no tùtu-u no igkabuhì ku su sikan to ingka-andini ku to pasak. ");
INSERT INTO did_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Na, ko og-usipon ku iyu to ‘Pila pad no buwan to pag-abut to tanom kani,’ iyan igtabak now to ‘Upat pad buwa no buwan kayan og-abut to tanom.’ Dì iyan ogkanangon ku iyu to nig-abut on iyan su nangkatonggò on, anihonon on man. Ahà kow dà. ");
INSERT INTO did_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","To mgo og-ani, moydu-on ogkadawat dan no bayad no konà ogkawadà aw to mahudi no adow, ogkalabot kandan to nig-odok aw ogpamantukhow tibò kandan, sikan og-odok aw sikan og-ani ");
INSERT INTO did_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","awos matuman to ikagihonon no pig-iling to ‘Moydu-on og-odok, moydu-on gayod og-ani.’ ");
INSERT INTO did_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Igpa-ani ku iyu sikan wadà now ka-uyamu. Bugtì to nig-uyamu. Ogkalabot kow to nig-odok su mahan-ing natodu-on to nigpang-anad to kagi to Diyus no intag-an no natuman on kunto-on no tig-a-anihay on.” ");
INSERT INTO did_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Na, og-uli-on tad to mgo taga-Samariya no namang-andiyà ki Jesus. Mahan-ing kandan no namantu-u ki Jesus su ingkanangon kandan to buyag no natag-anan ni Jesus to tibò no nabayà-baya-an to buyag, su na-ikagi to buyag to “Natag-anan din to nahimu ku tibò no mado-ot natodu-on.” ");
INSERT INTO did_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Na pagdatong kan mgo taga-Samariya diyà ki Jesus pigpangamuyù dan to ogpa-agpoton dan si Jesus du-on to kandan no banwa. Nig-uyun on si Jesus aw agpot du-on to daduwa dà no adow. ");
INSERT INTO did_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Na pagdinog to taga-lunsud to innangon ni Jesus, nigdugang pad to kahan-ing to nigtu-u aw pasakup. ");
INSERT INTO did_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Pignangonan dan kan buyag no nig-allad kandan diyà ki Jesus to “Nigtu-u koy su pignangonan koy nu. Dì nighognà koy pad nigtu-u su kanami, nakadinog koy kandin to atubang. Nama-anan noy on no maogot to Maglilipwasay iyan kandin to tibò no mgo otow dini to kalibutan.” ");
INSERT INTO did_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Na pagkadaduwahi no adow, nighipanow on kandan si Jesus padoog diyà to Galiliya no kandin banwa ");
INSERT INTO did_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","agad kandin, pigmatu-ud din on to lagsoban to Diyus no maglilikwaday, wadà itahud du-on to kandin banwa. ");
INSERT INTO did_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Dì sikan no paglo-uy din du-on to Galiliya, madoyow to pagdawat kandin to pagdatong din su bantugan on man aw nakita-an dan gayod to kaboonganan no nahimu din diyà to Hirusalim no pagpamanba-ot dan to Hinang to Pagpalipas to Kado-otan. ");
INSERT INTO did_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Na nigpadayong kandan si Jesus diyà to Kana no lunsud no pigbisitahan din ton pigbauyan din to inomon no wohig. Na diyà to Kapirna-um no lunsud no moydu-on nigdaa to bala-od du-on no batà din, nasakit. ");
INSERT INTO did_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Pagdinog din to nigdatong on si Jesus du-on to Kana, Galiliya, no pu-un diyà to Hudiya, nig-andiyà kandin to Kana no ogdokat podon ki Jesus awos din ipagawang to sakit su matigdà on to batà din no lukos. ");
INSERT INTO did_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Pagpangamuyù din, iyan in-ikagi ni Jesus to “Konà ka buwa ogtu-u kanak ko konà ka ogpakakita to kaboonganan aw mabogbog no ta-indanan no igkatu-u nu to kanak katondanan.” ");
INSERT INTO did_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Naka-ikagi to nigdaa to bala-od to “Sir, madaas ki dà su pakamatayon on to batà ku.” ");
INSERT INTO did_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Kagi ni Jesus, “Ulì kad puli su ogkabuhì dà man to batà nu.” Nakatu-u kan otow to innangon ni Jesus aw hipanow on no nig-ulì. ");
INSERT INTO did_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","No diyà pad to pangindanan, namansungun to mgo sugu-onon din aw nangoni kandin to “Na-uli-an on to batà nu.” ");
INSERT INTO did_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Dayun ing-usip din to “Dow nokoy urasa to pagka-uli-i din.” “Gabi-i pad,” kagi dan, “no bawbangkolid to soga nabahaw on to lawa din.” ");
INSERT INTO did_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Na-indanan to amoy to sukuu ma-ikagi ni Jesus to “Ogkabuhì dà to batà nu,” dayun na-uli-an iyan. Nadugangan to pagtu-u din aw mgo sood to baoy din. ");
INSERT INTO did_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","No paglikat ni Jesus to Hudiya aw datong diyà to Galiliya, pagka-ulì din sikan batà, ikaduwa on no kaboonganan no nahimu din. ");
INSERT INTO did_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Na, naman-andiyà kandan si Jesus to Hirusalim su ogpamanba-ot to hinang to mgo Hudiyu. ");
INSERT INTO did_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Na du-on to dani to li-otanan to mgo buhì no karniru, makabotang to padigusanan no pighingadanan to Bitsata to Hinibriyu pa no inikagihan. Moydu-on lima no baoy no saunganan no namakalibong du-on to padigusanan. ");
INSERT INTO did_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ogkahibat-hibatan to kahan-ingan no nangkasakit no mgo pisok, mgo pungkù, aw mgo pawing aw mgo pulid, su ogpamantagad-tagad kandan ");
INSERT INTO did_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","to diwata to Diyus no ogbunsud aw pa-alimbuwaanga din to wohig. Ko og-alimbuwaang on to wohig, to otow no ogpaka-una ogtogkad du-on kan no wohig, sikan to ogka-uli-an to sakit no agad nokoy. ");
INSERT INTO did_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Na du-on moydu-on kanunoy on nakahibat-hibat no nasakit to sood to katlu-an on aw wau no tu-ig. ");
INSERT INTO did_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Na si Jesus, nakita-an din sikan otow aw kama-ani din to naugoy on to pagkasakit din. Nig-ikagi si Jesus to “Dow ogkaliyag ka ko ma-uli-an ka?” ");
INSERT INTO did_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Nigtabak kandin to “Ho-o podon Sir. Dì wadà otow no ogpakagaboy kanak awos a makatogkad du-on to wohig. Ko ogduguk a podon du-on to wohig ogka-unahan ad to duma aw katogkad on.” ");
INSERT INTO did_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Kagi ni Jesus to “Agad on man, dì bangun kad on aw daaha to hikam nu aw hipanow kad on.” ");
INSERT INTO did_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Na na-uli-an on kandin aw hipanow on no pigdaa din to hikam din. Dì sikan no pagka-uli-i din, adow man no konà no tigtatalabahu, ");
INSERT INTO did_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","aw to punu-an to Hudiyu no matagon-tagonon to kandan katahanan, namakakita kandan to pigdaa din on to hikam din. Naka-usip kandan to “Nokoy man to indaa nu to hikam nu to adow no konà no tigtatalabahu, su ing-okod ita to tinu-uhan ta.” ");
INSERT INTO did_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Dì to otow no na-uli-an on to sakit, naka-iling kandin to “Sikan otow no nakadoyow kanak, iyan ing-ikagi din puli kanak to ‘Daaha to hikam nu aw hipanow kad on.’” ");
INSERT INTO did_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Naka-ikagi kandan to “Intawa buwa sikan no otawa no niglangub nigsugù ikow to igpadaa to hikam nu aw sugu-a ka to hipanow kad on.” ");
INSERT INTO did_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Sikan otow no na-uli-an on, wadà din kama-ani dow intawa to ngadan to nakadoyow kandin su wadad maka-usip kandin su mahan-ing no otow no nadasok aw puli on pigboong si Jesus du-on to kahan-ingan. ");
INSERT INTO did_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Na pigpanganap ni Jesus to otow no piggawangan din to sakit aw diyà din on kakita-i to simbahan. Pagkakita din, nig-ikagi kandin to “Na kunto-on no na-uli-an kad on, konà nud og-uli-on to mado-ot su dagow ko sumubla pad to kalisodan nu.” ");
INSERT INTO did_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Dayun nighipanow on to otow no pigtambaan ni Jesus aw nangoni din to punu-an to tinu-uhan to mgo Hudiyu to si Jesus to nakadoyow kandin. ");
INSERT INTO did_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Iyan impahadat dan ki Jesus su nakalapas kandin to kandan dà no tinu-uhan su nakadoyow kandin to masakiton to adow no konà no tigtatalabahu. ");
INSERT INTO did_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pig-usip dan si Jesus dow nokoy to inlangub din to pagpanambaa to adow no konà no tigtatalabahu, aw makatabak kandin to “Na to Diyus no Amoy ku, ogtuman kanunoy to kandin ogbo-otan no agad nokoy no adow. Ogpakasunud a dà kandin su ogpakatuman a gayod to pagbo-ot din to agad nokoy no adow.” ");
INSERT INTO did_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Na pigpakapa-omotan to mgo punu-an to mgo Hudiyu to pagpanganap to igkagawang dan kandin su wadà kandin makaduma to kandan tinu-uhan bahin to adow no konà no tigtatalabahu. Intobo-ot dan on dow napa-inahan din to Diyus no Amoy su nigpagsokod kandin to Diyus su pighimu ni Jesus to Diyus no Amoy din dì wadà dan sikan tu-uhi. ");
INSERT INTO did_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Kaling man nig-ikagi si Jesus diyà kandan to “So-idi iyan, to Anak, wadà ogkahinang din ko ogtubuk-tubuk kandin. Agad nokoy to ogkakita-an to Anak no pighimu to Amoy diyà to langit, iyan gayod ogkahimu to Anak dini to pasak, ");
INSERT INTO did_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","su tukhawanan to Diyus to Anak din aw igpa-ahà din to Anak to pighimu din tibò. Na mabogbog pad to igpakita din kandin no igpahimu din su awos maboong-boongan now. ");
INSERT INTO did_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ogbuhayon to Diyus no Amoy to nangkamatoy aw bayawa aw pa-ugpa-a din kandan diyà to banwa no wadà kamatayon. Angod dà gayod to oghimuhon to Anak, su ogpa-ugpa-on din to ogpili-on din diyà to banwa no wadà kamatayon. ");
INSERT INTO did_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Diyus no Amoy, wadà ogbo-otan din to mahudi on no adow ko konà no Anak din to ogpabaya-an din. Iyan ogpabo-oton din to Anak din ");
INSERT INTO did_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","su awos masosokod to pagtahud to mgo otow to Diyus no Amoy aw Diyus gayod no Anak. To otow no konà ogtahud to Anak to Diyus, konà dan gayod ogkatahudan to Amoy no nigpa-andini to Anak din. ");
INSERT INTO did_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“So-idi iyan, to otow no ogpaminog to kagi ku aw tu-u to Diyus no nigpa-andini kanak, moydu-on on kinabuhì din no konad ogkawadà. Konà ogpagawangon kandin du-on to atubangan to Diyus su nakalibwas on to pagsakup to kamatayon, dì ogpaka-ugpà nasì kanunoy diyà to atubangan to Diyus su nabogayan on to kinabuhì no konad ogkawadà, su agad kandin natodu-on angod to namatoy dì pigbuhoy on man kandin. ");
INSERT INTO did_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“So-idi iyan gayod, iyu no angod to mgo otow no nangkamatoy, ogkagotò to adow no ogpakadinog to igsugù to Anak to Diyus. To ogpaminog to sugù din, ogbuhayon aw moydu-on kinabuhì no konad ogkawadà. ");
INSERT INTO did_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Diyus to piglikatan to kinabuhì no konad ogkawadà. Pighimu gayod to Diyus to Anak din no oglikatan to kinabuhì to mgo otow no konad ogkawadà. ");
INSERT INTO did_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Pigbogayan to Diyus gayod kan Anak din to kabogbogan to ogpakabo-ot to mgo otow su nahimu man gayod no Tumutubus to Ka-otawan. ");
INSERT INTO did_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Konà kow ogkaboong-boong to ignangon ku iyu su moydu-on adow no ogkagotò no ogkadinog to sugù ku no ogmadmadon ku diyà to mgo nangkamatoy no otow aw ogpakalogwà kandan du-on to pigpanlobongan. ");
INSERT INTO did_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","To madoyow to hinang, ogpambuhayon aw pantuusa aw ogpaka-ugpà diyà to atubangan to Diyus. Dì to mado-ot to hinang, ogpambuhayon dà gayod dì konà ogtuuson, dì ogpakagawang dà diyà to atubangan to Diyus, aw kanunoy dan ogkahibatan to saà dan. ");
INSERT INTO did_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Na kanak, konà a oglangub ogtuman to pagbo-ot to Diyus no ogtubukan ku to kanak dà no kabogbogan. Ogpagdumahan ku dà to pagbo-ot din no Amoy ku aw to impadinog din kanak. Madoyow to pagbo-ot ku su konà a puli no ogpalabow-labow, su tu-ud ku to ogtumanon ku to pagbo-ot to Diyus no Amoy ku no nigpa-andini kanak. ");
INSERT INTO did_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Na ko kanak to ogmatu-ud to pigpa-andini a to Diyus, konà no ogkatu-uhan to Diyus to iyan nigpa-andini kanak. ");
INSERT INTO did_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Dì moydu-on ogmatu-ud, aw nama-anan ku dà man iyan to lagboy tùtu-u to ingkanangon din su Diyus man kandin. ");
INSERT INTO did_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Moydu-on gayod pigpapangintaga now diyà ki Juan bahin kanak aw kamatu-ud din mandà to tùtu-u iyan no pigpa-andini a to Diyus. ");
INSERT INTO did_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Konà ku dà ogkasaligan to pagmatu-ud to otow. Dì mano otow to ogsaligan now to pagmatu-ud, igpadomdom ku iyu to ingkanangon ni Juan awos ogkatu-uhan now aw katabangi kow to Diyus aw konà kow ogpagawangon du-on to atubangan din. ");
INSERT INTO did_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Si Juan, iyan ogka-angodan din to ilawan no og-andidiyow su pigpapayagan kow din to pagsabut din bahin to impang-anad din. To so lingonngon naliyagan now aw tukhawi to kandin pagbandog. ");
INSERT INTO did_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Dì kanak, mabogbog pad to pagmatu-ud ku diyà sikan pagmatu-ud ni Juan bahin to kanak katondanan su sikan impahinang to Diyus kanak, iyan man nahimu kud on. To nahimu kud on, naka-apid gayod to nigpa-andini kanak no Diyus no Amoy. ");
INSERT INTO did_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Diyus no Amoy no nigpa-andini kanak, iyan nigmatu-ud lagboy to kanak katondanan. Konà now ogkadinog ko og-ikagi kandin. Konà now gayod ogkakita-an to lawa din. ");
INSERT INTO did_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Na agaw man wadà kow tu-u kanak no otow no pina-andini to Diyus su wadà now pasooda lagboy to kagi din diyà to ginhawahan now. ");
INSERT INTO did_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","40","“Intobo-ot now dow moydu-on on kinabuhì now no konad ogkawadà su puli now ogpa-omotan to pag-anad to kasulatan to Diyus. Dì iyu, wadà kow makadawat su wadà kow pasakup kanak no ogpakabogoy to kinabuhì no konad ogkawadà. To kasulatan no ogpaka-abayon now og-anadan, sikan gayod to songo nakamatu-ud to kanak katondanan. ");
INSERT INTO did_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Kanak, konà a dà ogpakapa-uyun to otow. ");
INSERT INTO did_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Dì iyu, ogpakapa-uyun kow nasì to otow su wadà kow ka-uyuni to Diyus su wadà now kalogoni kandin su nama-anan ku dà dow nokoy to nakasood to ginhawahan now. ");
INSERT INTO did_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Iyan ing-andini ku su ogtubus a to Amoy ku su pigbogayan a to kabogbogan din. Dì wadà kow pasakup kanak. Dì ko ogpaka-andini to duma no ogdangon to kandin dà no ogsakupan, ogpasakup kow dà kandin nasì. ");
INSERT INTO did_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Amonuhon man to pagpasakup now to Diyus su ogpa-u-uyunay kow dà man no tumaag otow. Dì matuu konà kow on ogmina-uyun to Diyus. ");
INSERT INTO did_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Konà now ogkadomdoman to kanak to ogdikalamu iyu diyà to atubangan to Diyus no Amoy ku to mahudi no adow, su ki Moises dà no kasugu-an no kunon kun pigpakasaligan now, dì sikan on nasì to ogpakabogoy iyu to saà diyà to atubangan to Diyus. ");
INSERT INTO did_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ko tumu-u kow to ki Moises no kasulatan, ogtu-u kow podon gayod kanak su kandin man to nigsulat bahin kanak. ");
INSERT INTO did_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Dì mano wadà now tu-uhi to kasulatan ni Moises, og-amonuhon now man gayod to pagtu-u now to kagi ku iyu.” ");
INSERT INTO did_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Na kandan si Jesus, namantalipag to Galiliya no dagat no pighingadanan gayod to Tibiriyas no dagat. ");
INSERT INTO did_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","4","No madaas on to tighihinang to Hinang to Pagpalipas to Kado-otan, mahan-ing no ka-otawan to ogpamanhipanow no ogpadoog diyà to Hirusalim su ogpamanba-ot to hinang. Dì mahan-ing no otow no namansuuk no namanlupug ki Jesus diyà dihipag su nakita-an dan natodu-on to kaboonganan no nahimu din no angod to pagkangkadoyow to nangkasakit. Na kandan si Jesus, no pagdu-ung dan to boyboy, namanggomow kandan to untud. Pagkaluwan dan to untud, namang-ingkud du-on. ");
INSERT INTO did_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Puli dà nahinhinà nakita-an ni Jesus kan kahan-ingan no otow no nakadatong gayod du-on su namanlupug kandan. Pagkita ni Jesus, nig-ikagi kandin diyà ki Felipe to “Ando-i kid buwa to ogboli to igpako-on ta kandan.” ");
INSERT INTO did_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Na iyan ing-usip din ki Felipe sikan su awos mabogayan din to pa-antihan dow masaligan kandin ni Felipe to pag-aun agad si Jesus, tahan din on nama-anan dow nokoy to oghimuhon din. ");
INSERT INTO did_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Nakatabak si Felipe to “Konà buwa no litos to agad songo maan ko igboli ta to agad pannawà-nawa-on to paghandug.” ");
INSERT INTO did_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Na si Andres no su-un ni Simon Pedro no sakup gayod ni Jesus, naka-ikagi to ");
INSERT INTO did_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Moydu-on batà no moy lima no bu-uk no paan no sibada to pighimuhan aw daduwa no bu-uk no isdà no pigdaa din no ba-aw. Dì konà no litos su lagboy on to kahan-ing to otow.” ");
INSERT INTO did_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Dì nig-ikagi si Jesus, “Na, pama-ingkuda now on kan mgo otow.” Dayun namang-ingkud kandan du-on su litos no ogka-ingkudan su masagkop no bagnot du-on. To kalukosan, mgo lima no maan. Wadad bilanga to kabuyagan aw kabata-an. ");
INSERT INTO did_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Na pigdawat ni Jesus to paan aw pasalamat kandin. Pigpamaduhuu din kan mgo sakup din diyà to kahan-ingan no namang-ingkud. Insunù din to pagpahandug to isdà. Dayun namango-on to ka-otawan no puli dan binungku-an to pagko-on. ");
INSERT INTO did_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","No nangkahantoy on kandan, nig-ikagi si Jesus to “Na, oghimunon now to nasamà awos wadà ogka-uwakan.” ");
INSERT INTO did_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Dayun pighimun dan to nasamà aw sampuù tag duwa no ka-bangkow to natagu-an pad to paan no sibada. ");
INSERT INTO did_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Na pagkita to mgo otow sikan no kaboonganan no pighimu ni Jesus, nigka-inikagihay to “Maglilikwaday na-an kandin to Diyus no og-imanon na to og-andini ita no Imananan to Ka-otawan.” ");
INSERT INTO did_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Dì si Jesus, nama-anan din dà to imomo-ot dan on ogpakalayason ogpakahimuhon podon kandin no harì dan du-on. Dì puli on niglunus kandin du-on to nahimun no mgo otow aw hipanow no oggomow to untud. ");
INSERT INTO did_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Na pagkahapun no nali-usan ni Jesus to mgo pangabaga din, diyà padoog kandan to boyboy to dagat ");
INSERT INTO did_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","aw pamanluwan kandan to sakayan aw ituud dan to sakayan su ogtalipag kandan to dagat su diyà podon to Kapirna-um no lunsud to ogdoogan dan. Pigsakap kandan to kasaklopan no pagsakoy dan aw wadà dan pad katuuy si Jesus su wadà pad si Jesus makapagtagbu kandan. ");
INSERT INTO did_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Na du-on nigpamawbakuud to dagat su nigsabod to kamag no mabogbog. ");
INSERT INTO did_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","No onom on dow lima no kilumitru to nabogsayan dan, tinakin nakita-an dan du-on si Jesus no nighipanow du-on du-on to babow to dagat no ogduguk du-on to sakayan dan. Lagboy nangkahadok kandan, ");
INSERT INTO did_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","dì nig-ikagi kandin to “Si Jesus a. Konà kow ogkahadok.” ");
INSERT INTO did_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Du-on nangkaliyag kandan aw paluwana dan si Jesus. Pagkaluwan ni Jesus puli on nahigpat kandan to nigdatong diyà to ogdoogan dan. ");
INSERT INTO did_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","24","Na og-uli-on tad to kahan-ingan no nabitas diyà to dihipag no nali-usan ni Jesus. No diyà pad kandan to pigko-onan dan tibò to paan no pigpasalamatan ni Jesus, nakita-an dan to mgo sakup ni Jesus no nigsakoy padoog diyà dihipag to dagat aw katagahi dan gayod to si Jesus, wadà makaduma kandan. Dì matuu sikan dà man no sakayan to niglikat no niglayag kan no kahapunan. Kaling man intobo-ot dan dow mamonang pad si Jesus du-on to pasak. Dì pagkabukas, wadà dan on kakita-i si Jesus. Kaling man to pagdomdom dan to si Jesus, diyad on to dihipag to dagat. Na, moydu-on duma pad no mgo sakayan no nigdu-ung on du-on no niglikat to Tibiriyas. To kahan-ingan no mgo otow no wadà dan kakita-i si Jesus, dayun namanluwan kandan du-on kan no mgo sakayan no nigdu-ung aw layag kandan padoog diyà to Kapirna-um no lunsud awos diyà dan panganapa si Jesus. ");
INSERT INTO did_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Na pagdatong to kahan-ingan no otow diyà dihipag, nakita-an dan si Jesus du-on. Pig-usip dan si Jesus to “Sir, na-amonu man to pagka-andini nu.” ");
INSERT INTO did_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Nakatabak si Jesus to “So-idi iyan, nama-anan kud tahan dow nokoy to pagpanganap now kanak. Iyan impanganap now kanak su nakakita kow to ogka-amu a to ogpako-on iyu aw kangkaliyag kow to kaboonganan bahin to pagpako-on kud iyu su puli now man pigbungku-an to pagko-on. Dì wadà a now panganapa no awos iyan madaagan now to kalitukan to kaboonganan no pighimu ku. ");
INSERT INTO did_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Dì konà kow lagboy ogpa-awos to pagpangahà to igkabuhì now dini to babow su ogkadunut dà. Dì ogpa-aag-aagon now podon nasì to igkabuhì to kinabuhì now no konad ogkawadà, no igbogoy ku no Tumutubus to Ka-otawan, su pigmatu-ud to Diyus no Amoy to kanak katondanan no ogpakabogoy sikan.” ");
INSERT INTO did_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Namaka-usip kandan to “Nokoy to oghimuhon noy no awos ogka-uyunan koy to Diyus.” ");
INSERT INTO did_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Nig-ikagi si Jesus to “So-idi to ogkahimu now no ogka-uyunan to Diyus ko ogtu-u kow kanak no pigpa-andini din. Sikan to lagboy ogka-uyunan din.” ");
INSERT INTO did_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Nigsingka-ikagi kandan to “Ko ikow tùtu-u ka no Imananan to Ka-otawan, nokoy to kaboonganan no oghimuhon nu pad no igpakita nu to ka-otawan awos matu-uhan noy to kagi nu. ");
INSERT INTO did_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Na si Moises, wadà makapadakoo to ogkako-on diyà to kahanongan no banwa, dì pigpako-on din diyà to ka-aw-apu-an ta to mana no maga-agloy dà to kanawà no niglikat diyà to langit, su nasulat on no pig-iling to ‘Kandin, impako-on din to mgo otow to ko-onon no likat diyà to langit.’” ");
INSERT INTO did_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Nig-iling si Jesus to “Dì so-idi iyan. Konà no si Moises to nigbogoy to ingkabuhì diyà to ka-aw-apu-an ta natodu-on su Diyus man iyan. Aw Diyus dà to ogbogoy iyu to tùtu-u no igkabuhì no niglikat diyà to langit. ");
INSERT INTO did_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Su igkabuhì no niglikat diyà to Diyus, diyà to langit to ogpu-un aw sikan to igkabuhì to mgo otow dini to babow to pasak aw to tawoy sikan, kinabuhì no konad ogkawadà.” ");
INSERT INTO did_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Nigsingka-ikagi kandan to “Sir, bogayi koy nu podon sikan kanunoy.” ");
INSERT INTO did_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Naka-ikagi si Jesus to “Kanak to igkabuhì to mgo otow no konad ogkawadà. To ogpasakup kanak, konà ogbontason. To ogsalig kanak, konà oglanggahan. ");
INSERT INTO did_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Dì iyu, angod dà to pignangonan ku iyu, su nakita-an now on to ingkamatu-ud to kanak katondanan, dì wadà now tu-uhi. ");
INSERT INTO did_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tibò no otow no imbogoy kanak to Diyus, ogpakapa-agad ogpakapasakup kanak. To ogpasakup kanak, konà ku oggawangon to atubangan ku ");
INSERT INTO did_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","su iyan ing-andini ku su ogtumanon ku to pagbo-ot to Diyus no nigpa-andini kanak no niglikat diyà to langit. Konà a puli ogtubuk-tubuk ogtuman to kanak dà no pagbo-ot. ");
INSERT INTO did_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Pigbo-otan kan nigpa-andini kanak to wadà ogboongon ku no sakup no ingkabogoy din on kanak. Dì ogpambuhayon ku dà kandan nasì to mahudi no adow aw tuusa. ");
INSERT INTO did_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Sikan to pagbo-ot to Amoy ku. To ogkilaa to Anak to Diyus aw pasakup kandin, ogkabogayan to kinabuhì no konad ogkawadà aw ogbuhayon ku dà to lawa din to mahudi no adow aw tuusa.” ");
INSERT INTO did_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Na sikan mgo Hudiyu no mangkatagon-tagonon to kandan katahanan, nigka-inusipay kandan bahin ki Jesus no nigminus su nig-ikagi kandin to “Kanak no niglikat to langit to igkabuhì to mgo otow dini.” ");
INSERT INTO did_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Nigka-inusipay kandan no nigminus to “Dow konà buwa no anak ni Jose sikan no otow? Ah, nama-anan ta dà man iyan dow ando-i makalikat to kandin ginikanan. Nokoy man buwa no pig-ikagi din to ‘Langit to piglikatan ku.’” ");
INSERT INTO did_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Na nig-ikagi si Jesus to “Nokoy man no nig-inusipay kow angod sikan no pagminus now. ");
INSERT INTO did_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Agad intawa no otow, monang ogpaka-andini kanak aw pasakup kanak ko ogpa-andinihon kandin to Amoy ku no nigpa-andini kanak, aw kan no otow, ogbuhayon ku to mahudi no adow. ");
INSERT INTO did_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Na, nasulat on du-on to kasulatan to mgo lagsoban to Diyus no maglilikwaday din natodu-on no pig-iling to ‘Tibò to ogpasakup to Diyus, og-anadon din.’ Na to otow no nakadinog to kagi to Diyus aw anada to Amoy ku, ogpakapa-agad no ogpakapasakup kanak. ");
INSERT INTO did_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Konà no kalitukan to kagi ku to moydu-on nakakita to Diyus, su iyan dà nakakita to Diyus no otow to niglikat kandin. ");
INSERT INTO did_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“So-idi iyan, to otow no nigtu-u kanak aw pasakup, nadawat din on to kinabuhì no konad ogkawadà. ");
INSERT INTO did_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Kanak to igkabuhì to kinabuhì to otow no konad ogkawadà. ");
INSERT INTO did_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mgo ka-aw-apu-an ta, agad nakako-on on kan maga-agloy dà no mana no niglikat diyà to langit natodu-on, dì kandan, wadà pantuusa. Dì nasì on nangkamatoy kandan tibò. ");
INSERT INTO did_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Dì ingkanangon kud on iyu bahin to tùtu-u no igkabuhì no niglikat diyà to langit. Ko ko-onon now sikan, konà ogkawadà to tùtu-u no kinabuhì now ");
INSERT INTO did_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","su kanak man sikan igkabuhì no niglikat diyà to langit. Ko ogpasoodon to otow sikan no igkabuhì, konad ogkawadà to kinabuhì din. Sikan gayod igkabuhì no igbogoy ku diyà to mgo otow dini to kalibutan, kanak lawa awos ogkabuhì dà kandan.” ");
INSERT INTO did_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Na to tawoy on kan no pig-ikagi ni Jesus to mabogbog no pag-a-asuy-asuy to mgo Hudiyu aw nigka-inusipay kandan to “Amonuhon man to pagpako-on ita sikan otow to lawa din dà man buwa.” ");
INSERT INTO did_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Pig-ikagi ni Jesus to “Indanan now lagboy so-idi. Konà kow ogkabogayan to kinabuhi no konad ogkawadà ko konà kow pad makako-on to lawa ku aw maka-inom kow to langosa ku no Tumutubus to Ka-otawan.” ");
INSERT INTO did_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Napa-atubangan ni Jesus to pagpakimatoy din ita no nig-iling kandin to “Na to otow no ogko-on to lawa ku aw inom to langosa ku no iyan nalitukan to og-uyun to kanak to ogpakatubus no ogpakamatoy to kandin mgo saà, ogka-otow on kandin ogka-usab no konad ogkawadà aw to mahudi no adow ogbuhayon ku to lawa din ");
INSERT INTO did_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","su lawa ku, tùtu-u no igkabuhì to otow, aw langosa ku, tùtu-u no inomon. ");
INSERT INTO did_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Aw to otow no ogko-on to lawa ku aw inom to langosa ku, ogkahimu no ogkasobu-uk koy dà. Kandà no kinabuhì noy. ");
INSERT INTO did_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Amoy ku no nigpa-andini kanak to piglikatan to kinabuhì ku no konad ogkawadà. Aw to ogko-on to lawa ku, angod dà su ogbuhayon ku su natitibò koy on man. ");
INSERT INTO did_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Sikan no lawa ku to tùtu-u no ko-onon no niglikat diyà to langit. Dì konà no angod to nako-on to ka-aw-apu-an ta natodu-on su nangkamatoy dà man kandan tibò. Dì to ogko-on sikan no ko-onon no ingkanangon ku iyu, ogbuhayon kandin aw tuusa to konad ogkawadà.” ");
INSERT INTO did_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Sikan to impang-anad ni Jesus diyà to simbahan no diyà to Kapirna-um no lunsud. ");
INSERT INTO did_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Dì mahan-ing no sakup din no namakadinog sikan no impang-anad din diyà to simbahan bahin to tùtu-u no igkabuhì to otow, naboong-boongan dan aw nigsingka-ikagi to “Malisod iyan sikan no impang-anad. Konà ki ogpaminog sikan.” ");
INSERT INTO did_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Dì si Jesus, nama-anan din on to pagminus dan aw ikagi kandin to “Nokoy man no naboong-boongan now kan no impang-anad ku aw igkabungkù now on buwa sikan to pagtu-u now. ");
INSERT INTO did_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Nokoy buwa to ogka-ikagi now ko makita-an now on to Tumutubus to Ka-otawan no ogkabayow diyà to langit no piglikatan din. ");
INSERT INTO did_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ispiritu Santu dà to piglikatan to kinabuhì no konad ogkawadà. Dì no na-otow ki, ko lawa ta dà puli podon to nahimu, wadà puus su kaung dà puli to lawa. To kagi ku iyu, sikan to oglikatan to kinabuhì now no konad ogkawadà no igkabogoy to Ispiritu Santu. ");
INSERT INTO did_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Dì moydu-on kani iyu no konà no tùtu-u to pagpasakup dan kanak.” Iyan ingka-ikagi ni Jesus sikan su nama-anan din tahan dow intawa to wadà tu-u no otow diyà kandin aw intawa to ogbaligyà no otow kandin, ");
INSERT INTO did_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","aw ikagi kandin to “Kaling man nignangon a iyu to wadà otow no ogpakapasakup dini kanak ko konà no Diyus no Amoy to og-allad kandin dini kanak.” ");
INSERT INTO did_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Na kandà no adow no ingkaboong-boong on to mgo ka-otawan sikan no impang-anad ni Jesus, mahan-ing to nakabungkù to pagtu-u dan aw oyow kandan to ogpagduma kandin. ");
INSERT INTO did_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Kaling pig-usip ni Jesus tibò kan sampuù tag duwa no pangabaga din to “Na iyu, dow lumuwat kow gayod kanak?” ");
INSERT INTO did_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Nakatabak si Simon Pedro to “Ando-i koy man to ogdoog Sir, su ikow dà man to piglikatan to kagi no ogpakabogoy to kinabuhì no konad ogkawadà. ");
INSERT INTO did_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nigtu-u koy ikow aw kama-ani noy to ikow to otow no wadà saà no pighimu to Diyus no Imananan to Ka-otawan.” ");
INSERT INTO did_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Nig-ikagi si Jesus to “Pinilì kud on iyu tibò, dì sobu-uk iyu no nasakup ni Satanas.” ");
INSERT INTO did_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Si Judas iyan no anak ni Simon Iskariyuti to napa-atubangan ni Jesus to kagi din, su si Judas to ogbaligyà kandin. ");
INSERT INTO did_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Na, no naboong-boongan to mgo Hudiyu to kalitukan to mgo impang-anad ni Jesus, niggawang du-on si Jesus aw mgo sakup din aw pamanlibod-libod kandan diyà to Galiliya no prubinsiya su kaliyag kandin to ogdilinan to oglibod-libod diyà to Hudiya su pigmunu-munuhan to mgo punu-an to mgo Hudiyu to oghimatayan dan podon kandin. ");
INSERT INTO did_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Na madaas on to adow no tighihinang to mgo Hudiyu no pighingadanan to Hinang to Dinudungdung su sikan to igdodomdomay dan to pagbulig to mgo ka-aw-apu-an dan natodu-on no timpu pad no pagkalibod-libod dan to katahayan no banwa. ");
INSERT INTO did_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Kaling kan mgo su-un ni Jesus, pig-ikagihan dan kandin to “Nokoy man no wadà ka andiyà to Hudiya no prubinsiya awos buma-ot to hinang diyà to Hirusalim su awos makita-an to mgo hininang nu to mgo kasakupan nu diyà. ");
INSERT INTO did_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ko ogpabantug ka, konà nu ighobong to mgo oghinangon nu. Ko tùtu-u to oghimuhon nu to kaboonganan, igpa-ahà nu to ka-otawan.” ");
INSERT INTO did_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Su agad kan mgo su-un din, wadà makatu-u to kandin iyan to Imananan to Ka-otawan. ");
INSERT INTO did_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Nig-ikagi si Jesus to “Wadà pad kagoto-i to adow to kanak kabahinan. Dì iyu no puli no otow, agad nokoy no adow, tibò now timpu. ");
INSERT INTO did_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Iyu, konà kow ogkablangon to mgo otow dini to babow to kalibutan. Dì kanak, pigkablang a dan su to mado-ot no hinang dan, og-ukasan ku man. ");
INSERT INTO did_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Na, andiyà kow on to Hinang, dì kanak, konà a ogpakaduma iyu su wadà-wadà pad kagoto-i to adow ku.” ");
INSERT INTO did_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Na nigpakamonang kandin diyà to Galiliya. ");
INSERT INTO did_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Dì no pagkali-us to mgo su-un din, nighipanow on si Jesus padoog mandà diyà to Hirusalim dì wadà pagba-ot to kahan-ingan no otow no ogtu-ud diyà to Hirusalim. Dì nigpa-awoy kandin no nighipanow. ");
INSERT INTO did_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Na bahin to Hinang diyà to Hirusalim, to mgo punu-an to tinu-uhan to mgo Hudiyu, namanganap kandan ki Jesus aw ka-inusipay to “Dow ando-i buwa si Jesus.” ");
INSERT INTO did_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","To mgo ka-otawan, puli on kandan nighi-asuy-asuy bahin ki Jesus no moydu-on nig-iling to “Madoyow kan no otow.” Moydu-on gayod nig-iling to “Konà no madoyow no otow su iyan nigpasuwoy to ka-otawan to tinu-uhan.” ");
INSERT INTO did_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Dì wadà dan lagboy kapalabas to pagdomdom dan bahin ki Jesus su ogkahadok kandan ko mapagawang kandan to kahimunan to tinu-uhan. ");
INSERT INTO did_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Dì to pagpanongà-tongà to hinang, bali niglogwà si Jesus diyà to simbahan no labow aw pang-anad kandin to ka-otawan. ");
INSERT INTO did_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Na naboong-boongan to mgo punu-an to tinu-uhan to mgo Hudiyu to impang-anad din aw ka-inusipay to “Nokoy sikan no impang-anad aw ando-i ka-anadi din sikan su wadà gradu kan no otow.” ");
INSERT INTO did_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Nig-ikagi si Jesus to “Konà no kanak to piglikatan to impang-anad ku. Dì sikan nigpa-andini kanak, kandin to piglikatan. ");
INSERT INTO did_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","To otow no ogbo-ot to ogtuman to pagbo-ot to Diyus, du-on din on to ogkatagahan dow ando-i makalikat to impang-anad ku, dow Diyus dow makatubuk ad puli to pagpang-anad. ");
INSERT INTO did_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","To ogtubuk-tubuk dà to kandin pagpang-anad, puli ogpalabow-labow kandin. Dì to otow no ogpalabawon din to nigsugù kandin, matuwadong kandin aw wadà kagau-an. ");
INSERT INTO did_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moydu-on kasugu-an to Diyus no imbogoy iyu ni Moises. Dì agad sobu-uk iyu, wadà nakatuman sikan no kasugu-an. Nokoy man no ogpakahimatayan a now podon.” ");
INSERT INTO did_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Nigsingka-ikagi to ka-otawan to “Langog ka su pigsoodan ka to busow su wadà oglangub oghimatoy ikow.” ");
INSERT INTO did_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Naka-iling si Jesus to “Sobu-uk nandà to pighimu ku no wadà now uyuni su pighimu a now no nakalapas to ig-okod bahin to adow no konà no tigtatalabahu su nakadoyow a to masakiton. ");
INSERT INTO did_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Na si Moises, nigbogoy to kasugu-an bahin to pag-indan to batà, agad konà lagboy no si Moises to nalikatan sikan dì ka-aw-apu-an din pad to lagboy piglikatan, aw ogkatuman now kan agad adow on no konà no tigtatalabahu. Dì si Moises, nigbogoy gayod to kasugu-an bahin to pagpasigkon to adow no konà no tigtatalabahu. ");
INSERT INTO did_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ko og-indanan now to batà agad adow on no konà no tigtatalabahu awos matuman to kasugu-an ni Moises, nokoy man no nabou-an a now man su nakadoyow a to otow no masakiton agad adow on no konà no tigtatalabahu. ");
INSERT INTO did_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ogpakabo-ot kow podon gayod agad-agad to katùtu-uhanan aw konà no agad-agad to ogkadagbow ta puli.” ");
INSERT INTO did_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Na moydu-on mgo taga-lunsud no taga-Hirusalim no nigka-inusipay to “Dow konà buwa no sikan ton otow no ogpakahimatayan podon to punu-an ta? ");
INSERT INTO did_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Dì kandin, nakasood on nasì to labow no simbahan no nigpang-anad dì wadà sapadi to mgo punu-an. Dow ogkahimù buwa to nama-anan dan to sikan no otow, Imananan na-an to Ka-otawan? ");
INSERT INTO did_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Dì konad buwa ogkahimù su nama-anan ta to piglikatan sikan no otow no ginikanan aw banwa gayod. Dì tigka-un puli ogpakalogwà to Imananan ta, su wadà ogkama-an dow ando-i makalikat.” ");
INSERT INTO did_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Na, no nama-anan dà ni Jesus to napakunan to pag-a-asuy dan, pigpabogbogan din to pagpang-anad to ka-otawan du-on to simbahan no nig-iling kandin to “Tùtu-u iyan to pigkilaa a now aw nama-anan now iyan to nalikatan ku no ginikanan aw banwa ku. Dì wadà now kama-ani to lagboy ku piglikatan. Wadà a puli tubuk-tubuk to pag-andini ku to kalibutan. Sikan nigpa-andini kanak, tùtu-u, dì wadà now lagboy kama-ani. ");
INSERT INTO did_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Dì pigtagaman kud man su kandin to piglikatan ku aw kandin nigpa-andini kanak.” ");
INSERT INTO did_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Na sikan nangkama-an no mgo otow to tinu-uhan, wadà dan kaliyagi to na-ikagi ni Jesus. Kaling man pigpakadakop dan podon si Jesus, dì wadà nakatudì su wadà pad kagotò to adow din. ");
INSERT INTO did_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Agad ogpakadakopon podon to mgo punu-an to tinu-uhan, sikan puli no mgo ka-otawan, namantu-u on kandan ki Jesus aw ikagi kandan to “Ko lumogwà to Imananan to Ka-otawan, wadad buwa kaboonganan no oghimuhon din pad no ogpakalabow pad to pighimu sikan no otow no igkamatu-ud to pagbotang kandin.” ");
INSERT INTO did_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Na to mgo Parisiyu no mangkatagon-tagonon to kandan katahanan, namakadinog kandan to pag-a-asuy-asuy to mgo ka-otawan bahin ki Jesus. Kaling man kandan aw mgo punu-an to tinu-uhan, pigpa-andiya-an dan si Jesus to mgo guwardya to simbahan su igpadakop dan kandin podon. ");
INSERT INTO did_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Pagdatong to mgo guwardya, nigpang-anad si Jesus to ka-otawan no nangkahimun. Nig-ikagi kandin to “Ogpaugoy-lugoy a pad dini iyu, dì madaas ad oghipanow su og-ulì ad diyà to nigpa-andini kanak. ");
INSERT INTO did_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ogpanganapon a now, dì konà a now ogkakita-an su to og-ugpa-an ku, konà kow ogpakatutuu.” ");
INSERT INTO did_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Dì to mgo Hudiyu, nigka-inusipay to “Dow ando-i buwa to ogdoogan din no banwa no konà ta ogkapanganap. Dow ogpagtibò kandin buwa to kadumahan ta no nangkaba-otan to mgo Giriyigu awos mangka-anad din to mgo Giriyigu? ");
INSERT INTO did_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Nokoy buwa to kalitukan to pig-ikagi din no ‘Ogpanganapon a now, dì konà a now ogkakita-an su to og-ugpa-an ku, konà kow ogpakatutuu.’” ");
INSERT INTO did_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Na to katapusan no adow aw kamatu-udan no adow to hinang to mgo Hudiyu no igdodomdomay dan to pagbulig to Diyus to ka-aw-apu-an dan to paglibod-libod dan diyà to katahayan no banwa natodu-on, nigsakindog si Jesus aw ikagi to ma-agbot to “Ko moydu-on piglanggahan, umandini kanak aw inom. ");
INSERT INTO did_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","To ogtu-u kanak, ogkatuman to kasulatan no pig-iling to ‘To otow no og-inom, bahin to ginhawahan din, iyan ogka-angodan to tubud no og-ugwak aw pandahugi to kawohigan no makagbuhoy.’” ");
INSERT INTO did_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Na, to pag-ikagi ni Jesus iyan napa-atubangan to Ispiritu Santu no igbogoy diyà to mgo tumutu-u kandin, su kan no timpu wadà pad abut to Ispiritu Santu su wadà pad kabayow si Jesus diyà to langit no ogsood to kandin katondanan du-on. ");
INSERT INTO did_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Na pagkadinog to ka-otawan to impang-anad ni Jesus, moydu-on naka-ikagi to “Lagsoban na-an sikan to Diyus no sikan dà na-an iyan og-imanon ta no oglogwà to kinahudihan.” ");
INSERT INTO did_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Moydu-on gayod naka-iling to “Imananan man iyan kandin to Ka-otawan.” Dì moydu-on gayod naka-iling to “Konà no diyà to Galiliya to oglikatan to Imananan to Ka-otawan ");
INSERT INTO did_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","su agad-agad to kasulatan, sugpù ni David to Imananan aw Bitlihim to oglikatan din.” ");
INSERT INTO did_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Kaling man wadà hidaag to pagdomdom dan bahin ki Jesus. ");
INSERT INTO did_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Moydu-on ogdomdom to ogdakop podon kandin dì wadà pad niglangub to nigdakop kandin. ");
INSERT INTO did_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Na to mgo guwardya no pigpadakop podon ki Jesus to mgo punu-an, puli namakapa-ulì diyà to nigsugù kandan no mgo punu-an to tinu-uhan aw mgo Parisiyu no wadà makadaa ki Jesus. Na pig-usip dan to mgo guwardya to “Nokoy man no wadà now kadaa si Jesus.” ");
INSERT INTO did_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Namakatabak to mgo guwardya to “Wadà man aligbat nadinog noy no kagi no angod sikan to nalitukan to kagi din.” ");
INSERT INTO did_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Naka-ikagi to Parisiyu to “Dow napasuwoy kow din buwa gayod? ");
INSERT INTO did_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Wadà ogka-indanan ta no Parisiyu aw punu-an to tinu-uhan no nigtu-u kandin. ");
INSERT INTO did_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Dì sikan dà no mgo ka-otawan no wadà kataga lagboy to kasugu-an ni Moises, do-otonon kandan to Diyus.” ");
INSERT INTO did_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Dì si Nikudimu no songo punu-an gayod to tinu-uhan no nig-andiyà ki Jesus natodu-on no madukilom no ogpangintaga to impang-anad din, nigbulig podon kandin ki Jesus. Nig-ikagi kandin diyà to duma no punu-an to ");
INSERT INTO did_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Konà ki ogkatugutan to kasugu-an ta no nasulat on no ogpakabo-ot ki to otow to konà ta pad ogkadinogan to ignangon din aw wadà ta pad kapangintagahi to hinang din.” ");
INSERT INTO did_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Namaka-iling kandan to “Ikow Nikudimu, taga-Galiliya ka gayod buwa. Panganapa nu du-on to kasulatan aw pangintagahi to wadà otow no lagsoban to Diyus no maglilikwaday din no ogpakalikat du-on to Galiliya, agad sobu-uk.” ");
INSERT INTO did_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Na du-on namakasusuwoy-suwoy to mgo punu-an no nangkahimun aw masigka-ulì kandan su wadà hi-uyun-uyun kandan. ");
INSERT INTO did_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Na og-uli-on tad to tutuwanon ki Jesus. Nig-andiyà kandin to untud no pighingadanan to Ulibu-an no ogpakadukilom kandin du-on. ");
INSERT INTO did_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Na pagkabukas nig-ulì si Jesus diyà to simbahan no labow. Nahimunan kandin to ka-otawan no ogpama-anad kandin. Kaling nig-ingkud si Jesus no ogpang-anad su tahan to mgo Hudiyu no mgo otow, ko ogpang-anad, og-ingkud. ");
INSERT INTO did_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","No nang-anad si Jesus nigdatong to mgo punu-an to tinu-uhan no Parisiyu aw mag-a-anad no nigdaa to buyag no nasakpanan dan no nigpalibug kandin. Pigpapatongà dan to buyag ");
INSERT INTO did_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","aw ikagi kandan diyà ki Jesus to “Na Sir, so-idi no buyag, nasakpanan noy to nigpalibug kandin. ");
INSERT INTO did_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Na si Moises, insugù din du-on to kasulatan to igpamadogpak to batu to ogpakasaà no angod sikan. Dì ikow, nokoy to pagdomdom nu.” ");
INSERT INTO did_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Iyan ing-iling dan sikan su ogpangindakopan dan podon si Jesus to kagi-kagi din su pigpanganap dan to ogkapatikinan to igkadiklamu dan kandin. Dayun nig-ingkud si Jesus no nigpagutung-gutung aw isulat to tudlù din diyà to paok. ");
INSERT INTO did_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Na ing-aboy dan ing-usip-usip su ogpalabason dan podon to pagdomdom ni Jesus. Dì nigsakindog si Jesus aw ikagi to “Ko moydu-on iyu no wadà saà agad sobu-uk, ogkahimu kandin no tugdow no ogdogpak to batu.” ");
INSERT INTO did_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Nig-usab nig-ingkud aw isulat to tudlù din mandà diyà to paok. ");
INSERT INTO did_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Pagkadinog dan to kandà to na-ikagi ni Jesus, puli on namanlunus kandan no nigdiklamu likat to mangkanigo-on aw hantod to batà su nangkasikow. Si Jesus nandà to nabilin aw to buyag no nigsakindog diyà to atubangan din. ");
INSERT INTO did_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Na niglinggokà si Jesus aw ikagi to “Na ando-id kandan no namandiklamu ikow. Dow wadad agad so otow no oghimu pad ikow no himatayanan?” ");
INSERT INTO did_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Nakatabak to buyag to “Wadad on Sir.” Nig-iling si Jesus to “Konà ku gayod ikow ogbotangan to saà. Ogpakahipanow kad on dì konà nu og-uli-on oghinangon to mado-ot.” ");
INSERT INTO did_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Na nigpangudlin mandà si Jesus to mgo nigdaa to tinu-uhan to mgo Hudiyu no diyà to Botanganan to Sapì to simbahan. Nig-iling kandin to “Kanak, tumatang-away a to otow no dini to kalibutan. To ogduma kanak, konà ogpakadoom dì ogkatang-awan to igbayà din padoog diyà to banwa no wadà kamatayon.” ");
INSERT INTO did_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Dì nig-iling to mgo Parisiyu to “Konà ogkatu-uhan to innangon nu su puli nu ogtubuk-tubukan to pagmatu-ud nu to ikow no katondanan.” ");
INSERT INTO did_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Nig-ikagi si Jesus to “Agad tu-unan ku to ogmatu-ud to kanak katondanan, dì tùtu-u iyan su kanak, nama-anan ku to piglikatan ku aw kama-ani ku gayod to ogdoogan ku. Dì iyu, wadà now kama-ani to piglikatan ku aw to ogdoogan ku ");
INSERT INTO did_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","su ogbobo-ot kow agad-agad to ogkadomdoman to otow puli. Dì kanak, konà no tu-ud ku to ogpambobo-ot a to mgo otow no madoyow aw mado-ot. ");
INSERT INTO did_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Dì ko ogbobo-otan kud to mgo otow, tùtu-u to kanak no pagbo-ot su wadà a puli tubuk-tubuk to pagpambo-ot su nigka-u-uyun koy si Amoy no nigpa-andini kanak. ");
INSERT INTO did_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Dì konà dà no kanak to ogmatu-ud to kanak katondanan, su nasulat on to kasugu-an ta no pig-iling to ‘Ogkasaligan now to agad nokoy, ko ogkamatu-ud to daduwa no ka-otow no oghiduma dà lagboy to pagnangon dan.’ ");
INSERT INTO did_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Na kanak, ogmatu-udon ku to kanak katondanan. Dì Amoy ku no nigpa-andini kanak, kandin gayod to ogpakamatu-ud to kanak katondanan.” ");
INSERT INTO did_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Naman-usip kandan to “Ando-i to Amoy nu.” Nakatabak kandin to “Wadà kow makakilaa kanak aw Amoy ku. Ko makilaa a now, ogpakakilaa kow gayod to Amoy ku.” ");
INSERT INTO did_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Kanunoy nigpapayag si Jesus to pagpang-anad aw kandà no adow du-on to Botanganan to Sapì to simbahan no labow pang-anad. Dì wadà nakalangub to pagdakop kandin su wadà pad kagotò to adow din. ");
INSERT INTO did_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Na nigpang-anad mandà si Jesus to mgo Hudiyu, aw iling kandin to “Madaas ad oghipanow aw ogpanganapon a now dì konà kow ogpakakita kanak su ogkamatoy kow on puli no konà pad ogkapasaylu to saà now. Konà kow ogpakatutuu diyà to ogdoogan ku.” ");
INSERT INTO did_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Nigka-inusipay to mgo Hudiyu to “Dow og-ogot buwa kandin, su na-ikagi din to ‘Konà kow ogpakatutuu diyà to ogdoogan ku.’” ");
INSERT INTO did_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Nig-ikagi si Jesus to “Pasak dà to nalikatan now. Dì kanak, langit to nalikatan ku. ");
INSERT INTO did_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Pig-ikagihan kud on iyu to ogkamatoy kow no konà pad ogkapasaylu to saà now ko konà kow ogtu-u to kanak to og-imanon to mgo otow.” ");
INSERT INTO did_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Namaka-ikagi to mgo Hudiyu, “Intawa ka man lagboy no otawa no ikow, ogpalabow-labow on.” Nakatabak si Jesus to “Pig-ikagihan kud on iyu tahan likat to kapinunu-an to impang-anad ku iyu bahin to kanak no katondanan. ");
INSERT INTO did_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Bahin iyu, mahan-ing podon to ignangon ku aw mahan-ing podon to igkabo-ot ku iyu. Dì iyan dà iglikwad ku to nadinog kud on likat diyà kandin no nigpa-andini kanak no kandin, katùtu-uhi iyan.” ");
INSERT INTO did_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Dì sikan mgo Hudiyu, wadà dan tu-uhi to Diyus no Amoy to piglikatan ni Jesus. ");
INSERT INTO did_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Nig-iling si Jesus to “Sikan Tumutubus to Ka-otawan no pig-iman now no insahad iyu to Diyus, ogpadodopahon now nasì du-on to kinurus. Kayan pana ogkama-anan now to kanak iyan sikan Tumutubus to Ka-otawan aw wadà a tubuk-tubuk to pagpanghinang likat to kanak dà tu-un no kabogbogan dì iyan dà pig-ikagi ku to impang-anad kanak to Amoy ku. ");
INSERT INTO did_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","To nigpa-andini kanak, konà a din og-oyowan su kanunoy a din nasì ogdumdumahan su kanunoy ku man ogpanghimuhon to ogkaliyagan din.” ");
INSERT INTO did_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","No pagpang-anad ni Jesus angod kan, mahan-ing to namakatu-u kandin. ");
INSERT INTO did_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Na nig-ikagi si Jesus diyà to sikan namakatu-u on kandin no Hudiyu gayod to “Iyu, ko oghogoton now to pagtagon to kanak kagi, sakup ku iyu iyan lagboy, ");
INSERT INTO did_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","aw ogkama-anan now to katùtu-uhanan no tinu-uhan likat to Diyus aw ogpakaluwas iyu sikan no katùtu-uhanan.” ");
INSERT INTO did_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Na to mgo ka-otawan, namaka-ikagi to “Kasinugpu-an koy ni Abraham. Wadà pad aligbat nakasakup kanami. Nokoy man no nig-ikagi ka to ‘Moydu-on ogpakaluwas iyu.’” ");
INSERT INTO did_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Nigtabak si Jesus to “So-idi iyan, to otow no mado-ot to hinang, sakup ni Satanas no piglikatan to mado-ot no mgo hinang tibò aw kahimu din kandin no udipon. ");
INSERT INTO did_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Na ko pananglitan, to mgo udipon, agad intawa to tag-udipon, wadà ogtingonan su ogkagawang kandan su kadoog ogkabinabakliday. Dì to anak to tag-inugpà, kandin to moydu-on ogtingonan su nigpata-anak man kandan. ");
INSERT INTO did_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ko sikan anak to tag-inugpà to ogtobus iyu no udipon aw maluwasan kow to pagka-udipon now, ogkahimu kow on no konà puli no baklidonon. ");
INSERT INTO did_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nama-anan ku man to mgo sugpù kow tibò ni Abraham dì nokoy man no oghimatayan a now man podon nasì. Iyan igkahimatoy now podon kanak su konà now ogpasoodon lagboy to kagi ku du-on to ginhawahan now. ");
INSERT INTO did_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Impannangon ku iyu to tibò to nakita-an ku diyà to atubangan to Diyus no Amoy ku. Dì iyu, iyan ogtumanon now to insugù ni Satanas no amoy now su pigtu-uhan now.” ");
INSERT INTO did_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Namaka-iling kandan to “Si Abraham to kanami amoy.” Dì nig-ikagi si Jesus to “Ko tùtu-u kow no sugpù ni Abraham, ogtumanon now on to igpahinang din podon. ");
INSERT INTO did_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Na kanak, inlikwad ku iyu to katùtu-uhanan no likat to Diyus. Dì iyu, oghimatayan a now on podon nasì. To pighinang ni Abraham, konà no angod kan. ");
INSERT INTO did_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Iyu, iyan nasì oghinangon now to angod to hinang to iyu no amoy no si Satanas no pigtu-uhan now.” Namaka-iling kandan to “Kanami iyan konà no piglikatan noy to paglingì-lingì to duma. Diyus dà man no sobu-ukon no Amoy to piglikatan noy.” ");
INSERT INTO did_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Nig-ikagi kandin to “Ko tùtu-u, Diyus to piglikatan now podon no Amoy, igtahud a now podon su Diyus man to piglikatan ku. Wadà a puli tubuk-tubuk to pag-andini su Diyus man to nigbo-ot kanak no pigpa-andini a. ");
INSERT INTO did_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nokoy man no wadà now kadaagi to na-ikagi ku. Konà kow ogpakadaag su konà kow ogpaminog. ");
INSERT INTO did_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Si Santanas to piglikatan now no amoy now. Ogpakatumanon now to naliyagan din. Likat to kapinunu-an kandin to piglikatan to kamatayon to mgo otow aw kandin, wadà kalabot to katùtu-uhanan su otow no lagboy gau-on iyan sikan. Ko ogginaù kandin, kandin katahani to pigsaligan din su gau-on no otow kandin aw piglikatan gayod kandin to gaù, agad intawa no ogpakalituk aw tu-uhi now sikan. ");
INSERT INTO did_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Dì kanak, nignangon a iyu to katùtu-uhanan. Dì wadà a now tù-uhi su naliyag kow to ogtu-u to gaù. ");
INSERT INTO did_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Wadà iyu tibò no ogpakamatu-ud to moy saà ku. Su tùtu-u man to innangon ku iyu, nokoy man no wadà now katu-uhi. ");
INSERT INTO did_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","To otow no oglikat to Diyus, iyan ogpakapaminog to kagi to Diyus. Konà kow ogpakapaminog to kagi to Diyus su wadà kow man makalikat kandin.” ");
INSERT INTO did_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Namaka-iling kan mgo Hudiyu no mgo otow to “Bahin to na-ikagi nud on to angod kan kunto-on, sikan to igkaptu-u ton na-ikagi noy natodu-on no pig-iling noy to ‘Ikow, taga-Samariya ka no pigsoodan ka to busow.’” ");
INSERT INTO did_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Naka-ikagi si Jesus to “Wadà likat to busow to pag-ikagi ku. Dì pagtahud ku nasì to Diyus no Amoy ku to piglikatan to pag-ikagi ku. Dì wadà now matu-uda to kagi ku su wadà a now tahuda. ");
INSERT INTO did_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Dì wadà a patahud-tahud to duma. Dì soobù to Amoy ku no Diyus to nig-ikagi diyà to mgo otow to igpatahud-tahud a din. Dì ogpakabo-ot gayod to Diyus to otow no wadà tahud kanak. ");
INSERT INTO did_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","So-idi iyan, to otow no ogtuman to kanak kagi, konà ogkagawang kandin diyà to atubangan to Diyus su konà ogkamatoy kandin.” ");
INSERT INTO did_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Namaka-iling sikan mgo Hudiyu to “Nama-anan noy on iyan to pigsoodan ka to busow su iniling nu to ‘To otow no ogtuman to kagi ku, konà ogkamatoy,’ dì si Abraham aw mgo lagsoban to Diyus natodu-on, nangkamatoy on tibò. ");
INSERT INTO did_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Dow konà ka no labow pad ki Abraham aw mgo lagsoban to Diyus no puli on kandan nangkamatoy tibò? Nokoy to paghingadan nu to katondanan nu.” ");
INSERT INTO did_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Nakatabak si Jesus to “Ko puli a nigpatahud-tahud podon to kanak lawa, wadà puus. Dì to Amoy ku no Diyus no kunon kun pigpilì now on tahan no ampu-onon now, pigtahudan a din iyan. ");
INSERT INTO did_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Dì iyu, wadà now kandin katagahi. Dì kanak, natagahan ku. Ko ilidung ku podon kandin no mangkuwan natagahan ku, ogpaka-angod ad iyu no mgo gau-on. Dì matuu ogtumanon ku to kagi din su tahan ku natagahan. ");
INSERT INTO did_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Si Abraham no apù now, pigpangumanoy din ko lumogwà a. Aw kunto-on, nama-anan din on to natuman on to pig-imanan din bahin kanak aw tukhow kandin.” ");
INSERT INTO did_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Namaka-iling sikan mgo Hudiyu to “Wadà ka makakita ki Abraham no minuna ta su wadà ka pad abut to kalim-an no tu-ig.” ");
INSERT INTO did_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Nig-ikagi si Jesus to “Ogkamatu-ud ku to wadà pad ka-otow si Abraham, kanak, tahan on iyan naka-ugpà.” ");
INSERT INTO did_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","No lagboy on to piglangotan to mgo Hudiyu to nadinogan dan, nigsingkadawat kandan to batu su ogdogpakon dan podon si Jesus. Dì kandin, nakahobong dà aw logwà du-on to simbahan no labow. ");
INSERT INTO did_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Na kandan si Jesus, no namanlikat kandan du-on to simbahan no labow du-on kan no lunsud no Hirusalim, nigpadayong on kandan aw nakita-an dan to otow no pisok likat to pagka-otow din. ");
INSERT INTO did_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","To mgo sakup ni Jesus, namaka-usip kandin to “Sir, nokoy to piglikatan to pagkapisok no ingkadongan to pagka-otow din. Intawa dapit to nakasaà, kandin dow ginikanan din.” ");
INSERT INTO did_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Nakatabak si Jesus to “Konà man no saà din aw konà gayod to saà to ginikanan to nalikatan to pagkapisok din. Dì iyan ingkapisok din su awos du-on to makita-an to mgo otow to kabogbogan to Diyus no ogpakadoyow to pisok. ");
INSERT INTO did_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ogtuman ki to igpahinang ita to Diyus no nigpa-andini kanak su oghutoy ki pad su ma-awang pad. Dì madaas kid ogkasaklopan no wadad ogpakatalabahu. ");
INSERT INTO did_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","No dini a pad to kalibutan, kanak to ilawan.” ");
INSERT INTO did_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","No ta-un to pag-ikagi ni Jesus, pig-iloban din to pasak aw gawgawa din hantod to nigsapuut to pasak. Dayun to intaplak din du-on to mata to pisok ");
INSERT INTO did_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","aw ikagihi din to “Diyà kad on aw pamuwam-us ka to tubudan no padigusanan no pighingadanan to Siluwi.” Ko ita pa kalitukan sikan no ngadan to Impadaa. Na dayun nigtuman kandin to insugù ni Jesus aw pamuwam-us. To pagpati-ulì din, ogpakakita on. ");
INSERT INTO did_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Na to sumbaoy din aw duma no nama-an kandin no nigpalimus to sapì, namaka-ikagi to “Dow sikan iyan buwa to kanunoy nig-ingkud natodu-on no nigpalimus to sapì.” ");
INSERT INTO did_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Moydu-on naka-iling to “Kandin iyan buwa.” Moydu-on gayod naka-iling to “Konà, dì to pag-ahà ta, ogpaka-angod-angod puli iyan.” Dì to pisok no na-uli-an on naka-iling to “Kanak iyan to pisok natodu-on.” ");
INSERT INTO did_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","To mgo otow, naman-ikagi diyà to pisok to “Na-amonu no iyan to pagkapabayà to pagka-uli-i nu to pagkapisok nu.” ");
INSERT INTO did_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Nakatabak kandin to “Ton otow no pighingadanan ki Jesus, nig-ilob du-on to pasak aw gawgawa din hantod to nigsapuut aw itaplak to mata ku aw sugu-a a din no nig-iling to ‘Diyà kad on to Siluwi no tubud aw pamuwam-us ka.’ Dayun nigtuman a to sugù aw du-on dayun a na-uli-an.” ");
INSERT INTO did_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Namaka-usip to mgo otow to “Ando-id kunto-on ton no otow.” Nakatabak to otow no na-uli-an to pagkapisok din to “Indoy dow ando-id buwa.” ");
INSERT INTO did_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Dì kan otow no bayà pad natambaan ni Jesus to mata, pigdaa to mgo ka-otawan diyà to mgo Parisiyu no mangkatagon-tagonon to kandan katahanan ");
INSERT INTO did_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","su natambaan man to mata din to adow to tigsisigkonay no pinabayà to intaplak ni Jesus to masapuut no pasak du-on to mata to otow no pisok. ");
INSERT INTO did_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","To mgo Parisiyu, pig-usab dan pig-usip to otow dow na-amonu to kandin pagka-uli-i. Sinudsud din to pag-ikagi to “Puli din man intaplak to masapuut no pasak kani to mata ku aw papamuwam-usa a aw dayun to na-uli-an a.” ");
INSERT INTO did_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Moydu-on Parisiyu no naka-iling to “Sikan no otow, wadà likat to Diyus su wadà din tagoni to ig-okod ta bahin to adow no tigsisigkonay.” Dì moydu-on gayod nig-ikagi to “Dì ko sala-an sikan no otow, og-amonuhon man oghinang sikan no kaboonganan.” Kaling man to pagdomdom dan bahin ki Jesus, wadà katibuus. ");
INSERT INTO did_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Dì to mgo Parisiyu, inusip mandà sikan otow no natambaan to “Na, no kandin to nakadoyow ikow, nokoy to pagdomdom nu bahin to kandin katondanan.” Nakatabak kandin to “Kandin, maglilikwaday to Diyus no lagsoban.” ");
INSERT INTO did_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Dì sikan mgo Parisiyu, monang namantu-u to tùtu-u napisok iyan sikan no otow aw na-uli-an on no pigtawag dan pad to ginikanan din. Kayan pana kandan nigtu-u. ");
INSERT INTO did_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Pagkatawag to mgo Parisiyu to ginikanan din nig-ikagi kandan to “Dow anak now so-i? Dow ogkamatu-ud now to napisok kandin likat to pagka-otow din? Na-amonu man to pagkadoyow to mata din.” ");
INSERT INTO did_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Namakatabak to ginikanan to “Ogkamatu-ud noy to anak noy sikan no otow aw to pagkapisok din, likat pad to pagka-otow din. ");
INSERT INTO did_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Dì bahin to pagka-uli-i din, wadà koy kataga sikan. To nakadoyow to mata din, wadà koy gayod tibò kataga. Usipa now kandin kunto-on aw du-on kow on pudut to katagahanan now su kandin, moydu-on on pikii.” ");
INSERT INTO did_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Na-iling to ginikanan to pagtabak su nahadok man ko magawang kandan to mgo Hudiyu to kahimunan to tinu-uhan dan su to mgo punu-an dan, nasusukunan dan on tahan to oggawangon dan to agad intawa no otow no ogmatu-ud to si Jesus, Imananan to Ka-otawan. ");
INSERT INTO did_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Kaling man na-iling to ginikanan to “Usipa now kandin aw du-on kow on pudut to katagahanan now su kandin, moydu-on on pikii.” ");
INSERT INTO did_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Na to ikaduwa no pagpang-usip to mgo Parisiyu kan otow no pisok, namang-iling kandan to “Nangon ka to atubangan to Diyus dow na-amonu to pagka-uli-i nu. Dì nama-anan noy to sala-an sikan no otow.” ");
INSERT INTO did_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Natabak to otow to “Ko sala-an pa dow konà, wadà ku man kama-ani. Dì moydu-on sobu-uk no kanak nama-anan su agad pisok a dì kunto-on no na-uli-an ad, ogpakakita ad man.” ");
INSERT INTO did_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Nigsingka-ikagi kandan to “Pig-amonu to pagtambaa din to ingka-uli-i nu.” ");
INSERT INTO did_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Nakatabak to pisok, “Pignangonan kud on iyu, dì wadà kow tu-u. Nokoy man no og-usip kow pad mandà. Dow ogpasakup kow buwa gayod ki Jesus?” ");
INSERT INTO did_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Dì pig-ina-ina dan kandin aw ikagi gayod to “Na ikow to sakup din. Dì kanami, sakup koy ni Moises ");
INSERT INTO did_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","su nama-anan noy lagboy to Diyus, nigpag-atubang ki Moises to pag-ikagi. Dì sikan no otow, wadà noy kama-ani dow ando-i to piglikatan din.” ");
INSERT INTO did_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","To otow no na-uli-an on to pagkapisok din, naka-ikagi kandin to “Naboong-boongan kud iyu su wadà now kandin kama-ani dow ando-i to piglikatan din dì matuu nama-anan now to kandin to nakadoyow to mata ku. ");
INSERT INTO did_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nama-anan ta man iyan tibò to konà ogpaminogon to Diyus to igpanawag-tawag to otow no sala-an. Dì to ogtahud to Diyus aw ogtuman to pagbo-ot din, ogpaminogon din to ogpamuyu-on dan. ");
INSERT INTO did_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Likat to pagbotad so-idi kalibutan ko moydu-on nakadoyow to mata to pisok likat to pagka-otow din, wadà ta aligbat kadinog. ");
INSERT INTO did_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ko wadà makalikat to Diyus sikan no otow, wadà kaboonganan no ogkahimu din podon.” ");
INSERT INTO did_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Namaka-ikagi to mgo Parisiyu to “Saà to otow to piglikatan to pagkapisok nu no ingkadongan nu. Na nokoy to iglangub nu to og-anad kanami.” Dayun du-on pigpagawang kan pisok no na-uli-an on du-on to kahimunanan to tinu-uhan. ");
INSERT INTO did_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Na pagkadinog ni Jesus to nagawang to kahimunanan to pisok no na-uli-an din, pigpanganap din aw pagkita din pig-usip din to “Ikow, ogpasakup ka to Tumutubus to Ka-otawan?” ");
INSERT INTO did_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Naka-ikagi kandin to “Nangoni a Sir dow intawa otawa sikan pig-ikagi nu su awos ogpakapasakup a kandin.” ");
INSERT INTO did_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Kagi ni Jesus to “Nakita-an nud on man kandin su to nigpagbaaw ikow kunto-on, sikan iyan.” ");
INSERT INTO did_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Kagi to otow no na-uli-an on to pagkapisok to “Sir, nigtu-u a aw ogpasakup a ikow.” Dayun nig-ampù kandin ki Jesus. ");
INSERT INTO did_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Nig-ikagi si Jesus to “Iyan ing-andini ku to kalibutan su awos mahimu a no oglikatan to paghibugtì to mgo otow, awos sikan nahimu no konà ogpakakita, ogkahimu dà no ogpakakita, aw sikan no intobo-ot dan dow ogpakakita on kandan, ogkahimu no ogkapisok.” ");
INSERT INTO did_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Moydu-on Parisiyu no namakadani ki Jesus, namakadinog to pig-ikagi din aw du-on namaka-ikagi kandan, “Dow pighinang koy nu gayod no pisok?” ");
INSERT INTO did_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Natabak ni Jesus, “Ko nasì tahan kow podon pisok, wadà podon saà now. Dì mano pig-ikagi now to ‘Ogpakakita koy dà,’ pigdokotan kow nasì to saà.” ");
INSERT INTO did_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Na impananglitan ni Jesus to mgo Hudiyu bahin to sinakupan din no iyan ogka-angodan to pigpang-aad no mgo buhì no karniru. Kagi din to “So-idi iyan. To ogsood to aad to mgo buhì no oglipas to li-otanan aw puli ponhik aw patilopow to in-aad, kandin ogpaka-angod to kawatan aw tulisan. ");
INSERT INTO did_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Dì to otow no ogbayà to li-otanan to in-aad, kandin to tagbuhì, ");
INSERT INTO did_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","aw kandin to ogpasoodon to ogbantoy to li-otanan. Kan mgo buhì, ogkilahon dan to kagi to tagbuhì. Ogtawagon din to kada ngadan dan aw pamalogwa-a no oghindu-an din kandan to ogkapamàpa-an dan. ");
INSERT INTO did_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ko oglogwà on tibò to mgo buhì, og-unahan din aw pamasunduwa din su ogpakakilaa kandan to kagi to tagbuhì. ");
INSERT INTO did_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","To otow no wadà dan kilaha to iyan tagbuhì, ogmina-idlahan dan nasì su wadà dan man kakilahi to kagi.” ");
INSERT INTO did_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Sikan no impananglitan ni Jesus, wadà kadaagi to kalitukan kan mgo Hudiyu no mgo otow. ");
INSERT INTO did_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Na kaling man pigpanaysayan ni Jesus to impananglitan din su wadà dan kadaagi. Nig-ikagi kandin to “Tùtu-u to kanak, iyan ogka-angodan ku to li-otanan to in-aad to mgo buhì no karniru. ");
INSERT INTO did_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Likat natodu-on hantod kunto-on tibò no namanlogwà no namanpakunon-kunon to kandan, Imananan to Ka-otawan, dì kandan, kawatan nasì aw ogpantulis to mgo buhi-onon ku. Dì to mgo buhì no sinakupan ku, konà dan ogpaminogan to konà no tùtu-u. ");
INSERT INTO did_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Kanak, iyan ogka-angodan ku gayod to li-otanan to in-aad to kabuhi-an. To ogsood sikan no li-otanan, konà ogka-amonu. Ogpamakalinogwà kandan aw ogpamakasinood aw ogpamakatutuu kandan diyà to kabagnotan no maunhow no igkabuhì dan. ");
INSERT INTO did_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Dì to kawatan, iyan igsood din su ogpudut aw ogpanghimatoy aw ogpandodo-ot kandin puli. Dì kanak, iyan ing-andini ku su ogbuhì a to mgo buhì ku no karniru no wadà ogboongon dan. ");
INSERT INTO did_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Na kanak no tagbuhì, madoyow to pagdaa to buhì no sakup ku su ogpakimatoy a to sakup ku su awos mangkabuhì kandan. ");
INSERT INTO did_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Dì to nigbantoy dà puli to buhì no konà no tagtu-un no puli nigpabayad dì matuu konà ogkasaligan tibò to pagdaa, no ko moydu-on ogduguk no mamang du-on to buhì, puli din on ogka-oyowan to pigbantayan din aw laguy su ogsagà man kandin su konà man no tagtu-un kandin. Na du-on oghutayon to ogpamu-od on to mgo buhì aw to tipanonan to buhì puli on ogkawagà-wagà kan nandà nadoogan. ");
INSERT INTO did_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Nigsagà man kandin su kan no pagbantoy din puli man nigkalun to bayad aw wadà logon din to panon to buhì. ");
INSERT INTO did_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Dì kanak iyan to tagbuhì aw kanak aw binuhi-an ku, nighitatagam koy man ");
INSERT INTO did_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","angod to paghitagam noy aw ni Amoy no Diyus su ogpakimatoy a to sinakupan ku no iyan ogka-angodan dan to mgo buhì ku no karniru. ");
INSERT INTO did_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Moydu-on sakuponon ku pad no wadà pad kalabot so-idi no panon. Dì kandan, ogkasakup ku dà gayod. Ogpaminog kandan gayod to kagi ku hantod to ogkasobu-uk dà to panon aw songo bu-uk dà to tagbuhì. ");
INSERT INTO did_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Kaling man nalogonan a to Amoy ku su ogpakatubus a ogpakimatoy to mgo sakup ku awos ogpaka-agad no ogpakabuhoy a dà to kanak tu-un no lawa. ");
INSERT INTO did_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Wadà otow no ogpakapagawang to kinabuhì ku, su kanak to ogpakabo-ot to ogpakamatoy. Ogpakabuhoy a dà gayod su pigbo-otan a to Amoy ku.” ");
INSERT INTO did_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Na to tawoy sikan no na-ikagi ni Jesus to nighibugtì kandan no mgo Hudiyu aw nigka-a-asuy-asuy kandan. ");
INSERT INTO did_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Mahan-ing to naka-iling to “Langog iyan kandin su pigsoodan buwa to busow. Nokoy man to igkapaminog ta kandin.” ");
INSERT INTO did_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Moydu-on gayod nig-iling to “Sikan, wadà makalikat to busow to na-ikagi din. Ko busow pa, konà man ogpakadoyow kandin to mata to pisok.” ");
INSERT INTO did_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","23","Na, ton diyà pad si Jesus to Hirusalim no timpu to amihan, nigba-ot kandin to hinang diyà to labow no simbahan no pighingadanan to Hinang to Paglimpas to Simbahan to Diyus, su sikan to pagpadomdom to ka-otawan to paglimpas to minuna dan natodu-on to simbahan no labow. Na nigpawpadiboy si Jesus diyà to himunanan no pighingadanan to balkun ni Solomon no nasakup gayod kan simbahan. Pagpawpadiboy din du-on, ");
INSERT INTO did_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","madag-an to nahimun du-on kandin no mgo Hudiyu su ogpamang-usip-usip kandan ki Jesus. Nig-usip kandan to “Nokoy no kanunoy koy nu ogpatagadon no awos ogkataga koy lagboy to ikow no katondanan dow Imananan ka to Ka-otawan dow konà. Nangoni koy nud on. Ogpapayagan koy nu tibò to pagnangon.” ");
INSERT INTO did_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Nakatabak si Jesus to “Pignangonan kud on iyu, dì wadà now tu-uhi. To impahimu kanak no nigtubus a to ngadan to Amoy ku, sikan to igkamatu-ud to kanak katondanan, ");
INSERT INTO did_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","dì wadà now tu-uhi su wadà kow man makalabot to kanak sinakupan no angod to mgo buhì ku. ");
INSERT INTO did_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Dì to kanak no mgo karniru, ogpamakadinog kandan to kagi ku, aw nighitagam koy on, aw duma kanak, ");
INSERT INTO did_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","aw ogbogayan ku kandan to kinabuhì no konad ogkawadà. Wadà ogpaka-agow kandan dini to boad ku. ");
INSERT INTO did_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Kinalabawan no katuusan no Amoy ku no nigbogoy kanak to mgo sakup ku aw wadà ogpaka-agow kandan du-on to kandin boad. ");
INSERT INTO did_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nasobu-uk koy si Amoy no Diyus.” ");
INSERT INTO did_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Dì kandan no mgo Hudiyu, namaka-usab nigsingkadawat to batu su ogdogpakon dan podon si Jesus. ");
INSERT INTO did_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Dì nig-ikagi si Jesus to “Impakita ku iyu to mahan-ing no madoyow no hininang no likat to Diyus no Amoy. Ando-i dapit no pighimu ku no igkadogpak now kanak.” ");
INSERT INTO did_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Namakatabak to mgo Hudiyu to “Hinang nu no madoyow, konà no sikan to igkadogpak noy ikow. Dì iyan igkadogpak noy ikow su to Diyus, napa-inahan nu su ikow, otow ka dà man puli, dì nigpapagsokod kad podon to Diyus.” ");
INSERT INTO did_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Naka-ikagi si Jesus to “Nasulat on du-on to kasulatan ta no pig-iling to ‘Na-ikagi to Diyus to iyu no imbotang ku no ogpakabobo-ot to ka-otawan, oghingadanan ku iyu to pinakadiyus kow to mgo ka-otawan, su ogpatubuson ku iyu to ogpakabobo-ot kow kandan.’ ");
INSERT INTO did_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","No nasulat on to angod kan aw konà ogkawadà to kasulatan to Diyus no pighimu din no pinakadiyus to otow no pigpa-abutan to tugun din, ");
INSERT INTO did_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","nokoy man no pighimu a now no nakapa-ina a to Diyus su na-ikagi ku to Anak a to Diyus, su Diyus no Amoy ku, imbotang a din to katondanan ku dini so-idi kalibutan. ");
INSERT INTO did_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ko wadà ku podon tumana to impahimu kanak to Amoy ku, konà kow ogtu-u to na-ikagi ku. ");
INSERT INTO did_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Dì ko matuman ku, agad wadà kow tu-u to na-ikagi ku, ogpakatu-u kow to Diyus to nigpahimu kanak to nangkahimu kud on su awos makasabut kow on to nigka-u-uyun koy si Amoy no Diyus.” ");
INSERT INTO did_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Dayun pigdakop dan podon mandà si Jesus, dì nakalikoy dà kandin. ");
INSERT INTO did_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Na nigtalipag mandà kandan si Jesus to Hurdan no wohig no pigpambonyagan ni Juan no Magbobonyagay to kapinunu-an to kandin katondanan. Nigpakamonang kandan si Jesus du-on ");
INSERT INTO did_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","aw kahimuni kandin to mahan-ing no ka-otawan no tahan on nakadinog natodu-on to impang-anad ni Juan. Nigka-inusipay kandan to “Si Juan no Magbobonyagay, wadà kaboonganan no pighimu din no igkamatu-ud to kandin katondanan. Dì tibò to intag-an din bahin ki Jesus, natumanan on iyan.” ");
INSERT INTO did_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Kaling man mahan-ing to nakatu-u du-on to si Jesus, Imananan to Ka-otawan. ");
INSERT INTO did_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Na moydu-on nasakit no impaghitagam ni Jesus no si Lazaro to ngadan. Si Maria aw si Marta to mgo atoboy din. Taga-Bitaniya kandan tibò. ");
INSERT INTO did_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Si Maria to nadinog ta no nigpatagdù to kobong ni Jesus natodu-on to pahomut aw pahidi din dà to bubuu din. ");
INSERT INTO did_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ton pagkasakit ni Lazaro, to mgo atoboy din, moydu-on pinalikwad dan diyà ki Jesus no impa-iling to “Sir, to pigtagaman nu no lagi nu, nasakit.” ");
INSERT INTO did_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Dì no pagkadinog din to nasakit to lagi din, wadà paningoo-tingoo kandin su nasì on pig-ikagi din kandan to “Konà no igkamatoy din sikan dì to tawoy sikan no pagkasakit din, ogkasayà to Diyus to mgo ka-otawan aw ogkasayà gayod to Anak to Diyus.” ");
INSERT INTO did_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Na si Jesus, agad pigtagaman din lagboy kan tatou no nigsusu-un no si Lazaro, si Maria, aw si Marta, ");
INSERT INTO did_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","dì pagkadinog din to nasakit si Lazaro, nigpakamonang nasì kandin to sood to daduwa no adow. ");
INSERT INTO did_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","No pagkadaduwahid no adow nig-iling si Jesus diyà to mgo sakup din to “Kuwà kinow on. Ulì kinow on diyà to Hudiya.” ");
INSERT INTO did_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Namaka-ikagi to mgo sakup din to “Sir, bayà-bayà ka pad pigdodogpak to batu podon to mgo Hudiyu diyà. Konà kid ogpa-ulì diyà.” ");
INSERT INTO did_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Na impananglitan ni Jesus to pag-ikagi din no pig-iling to “Ogpakahipanow kid likat to pagkabukas kotob to ogkahapun to adow, su ogkatang-awan to soga so-idi kalibutan aw konà ki man ogpakadinugsù. ");
INSERT INTO did_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Dì ko oghipanow ki to madiglom, ogpakadinugsù ki su wadà man ogpakatang-ow ita.” ");
INSERT INTO did_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Na pag-ikagi ni Jesus sikan no pananglitan din, nig-ikagi kandin diyà to mgo sakup din to “Nalipodong on to lagi ta no si Lazaro. Dì og-andiya-an ku su awos mapukow ku.” ");
INSERT INTO did_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Namaka-ikagi kandan to “Sir, ko puli nalipodong si Lazaro, madoyow no ta-indanan su ogpakagimata dà.” ");
INSERT INTO did_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Na-iling to bo-ot to mgo sakup din dow to kalitukan to pananglitan din to puli iyan nalipodong si Lazaro. Dì to kalitukan to pig-ikagi ni Jesus to si Lazaro, tùtu-u on iyan no namatoy. ");
INSERT INTO did_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Dayun pigpapayagan din to kalitukan aw kagi din no pig-iling to “Si Lazaro, namatoy on. ");
INSERT INTO did_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Dì madoyow su wadà a du-on su dagow mababagan ku podon ko du-on a. Dì kunto-on madoyow, su ogkadugangan nasì to pagtu-u now to ogkadoogan din. Na, og-andiyan-an tad on kunto-on si Lazaro.” ");
INSERT INTO did_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Na si Tomas no piggoan ki Iping, naka-ikagi to “Na kuwà kinow on, ogduma kid ki Jesus su kamatayon din, kamatayon tanow gayod.” ");
INSERT INTO did_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","18","Na, namanghipanow on kandan si Jesus padoog diyà to Hudiya no prubinsiya. Kan no pagdatong dan diyà to lunsud to Bitaniya no namatayan ni Lazaro no mgo upat dow tatou no kilumitru to pag-ootan diyà to Hirusalim, pignangonan kandan to na-upatan on si Lazaro diyà to lobong. ");
INSERT INTO did_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Mahan-ing to taga-Hirusalim no nig-andu-on no awos ogpadaoyagon kandan no namatayan no si Marta aw si Maria no atoboy ni Lazaro. ");
INSERT INTO did_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","No pagkadinog dan to madani on si Jesus du-on to Bitaniya si Marta, pigsungun-sungun din kandin. Dì si Maria, nigpakamonang dà diyà to baoy. ");
INSERT INTO did_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Na si Marta, pagkakita din ki Jesus, naka-ikagi kandin to “Sir, ko kani ka pa podon, konà podon ogkamatoy to ma-ama ku. ");
INSERT INTO did_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Agad kunto-on no namatoy on dì nama-anan ku dà to agad nokoy no ogpangamuyu-on nu to Diyus, igbogoy din diyà ikow.” ");
INSERT INTO did_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Nig-ikagi si Jesus to “Moydu-on dà ogbuhoy to ma-ama nu.” ");
INSERT INTO did_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Si Marta nakatabak to “Ho-o man iyan su to mahudi no adow no igpambuhoy to mgo otow, nama-anan ku to moydu-on dà ogbuhoy kandin.” ");
INSERT INTO did_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Nig-ikagi si Jesus to “Kanak to ogpambuhoy to mgo otow no nangkamatoy aw piglikatan a to kinabuhì no konad ogkawadà. To ogtu-u kanak, agad mamatoy dì ogbuhayon ku dà. ");
INSERT INTO did_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","To otow no moydu-on tùtu-u no kinabuhì aw salig kanak, agad mamatoy to lawa din dì kandin, konà ogkawadà. Dow ogtu-u ka Marta sikan?” ");
INSERT INTO did_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Nakatabak si Marta to “Ho-o Sir, nigtu-u a to ikow to Anak to Diyus aw Imananan ka to Ka-otawan no og-imanon noy to og-andini to kalibutan.” ");
INSERT INTO did_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Dayun nig-ulì on si Marta diyà to baoy din aw hagasi din puli to hadi din no si Maria to pagnangon to “Nakadatong on si Sir no dutun on to tawoy kunto-on. Ogpa-andiya-on ka din.” ");
INSERT INTO did_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","30","Dayun nigsakindog si Maria aw andiyà to tawoy to lunsud no pigsungunan ni Marta ki Jesus su du-on pad kandin. ");
INSERT INTO did_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Na to mgo Hudiyu no nigpadaoyag to namatayan, namanlupug ki Maria su nakita-an dan to pagkalogwà din aw intobo-ot dan dow nig-andiyà si Maria to linobongan su og-oog kandin. ");
INSERT INTO did_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Na pagkakita ni Maria ki Jesus, nigluhud kandin diyà to atubangan din aw maka-ikagi to “Sir, ko kani ka pa podon, konà podon ogkamatoy to ma-ama ku.” ");
INSERT INTO did_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Pagkakita ni Jesus to naman-oog kandan si Maria, naduyong-ot to ginhawa din aw pig-abut on kandin to ka-at. ");
INSERT INTO did_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Nig-usip si Jesus to “Ando-i now ilobong.” Nigtabak kandan to “Kuwà kid Sir, su oghindu-an ka to piglobongan ki Lazaro.” ");
INSERT INTO did_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Na du-on nigluhà si Jesus. ");
INSERT INTO did_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Namaka-i-ikagi kandan to “Eh-ay, lagboy din iyan inghitagam.” ");
INSERT INTO did_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Dì moydu-on gayod naka-ikagi to “To mgo pisok no otow, nakadoyow man kandin. Nokoy man buwa no wadà din ka-uli-i si Lazaro no podon naka-ulì man kandin to otow no pisok.” ");
INSERT INTO did_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Na tantu to pagkaduyong-ot ni Jesus, nig-andiyà kandin to linobongan ki Lazaro no imbangbang no pigsombanan to batu to lingangahan. ");
INSERT INTO did_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Nig-ikagi si Jesus to “Ligada to batu.” Dì si Marta no atoboy kan namatoy, naka-iling to “Nahaù on Sir, su na-upatan on man to pagkamatoy din.” ");
INSERT INTO did_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Dì nig-ikagi si Jesus to “Dow konà no na-ikagi kud on man to ko tumu-u ka kanak ogkakita-an nu to kaboonganan to Diyus?” ");
INSERT INTO did_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Na du-on piggawang dan to batu. Pagkagawang on, niglanghag si Jesus diyà to langit aw ikagi to “Amoy, salamat su naminog ka kanak. ");
INSERT INTO did_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nama-anan ku to kanunoy a nu ogpaminogan dì nakalituk a sikan su awos mama-anan to tibò to ka-otawan no nangkahimun kani to ikow to nigpa-andini kanak.” ");
INSERT INTO did_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","No pagkalituk sikan, pig-ikagihan din to ma-agbot to “Lazaro, logwà kad on.” ");
INSERT INTO did_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Na du-on dayun nakalogwà kan pigbuhoy on no patoy no nabodbodan dà to lawa aw kapukut to kobong aw boad su sikan to batasan dan ko oglobong kandan to patoy. Nabodbodan dà gayod to uu to panyù. Insugù ni Jesus to “Hubadi aw pa-uli-a now kandin.” ");
INSERT INTO did_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Na du-on bali namantu-u to mahan-ing no mgo Hudiyu to si Jesus iyan to tùtu-u Imananan to Ka-otawan su namanduma kandan to mgo atoboy ni Lazaro diyà to linobongan aw kakita-i dan to pagbuhoy ni Jesus ki Lazaro. ");
INSERT INTO did_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Dì moydu-on mgo otow gayod nignangon to mgo kablang ni Jesus no mgo Parisiyu to nahimu ni Jesus sikan no kaboonganan. ");
INSERT INTO did_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Kaling kan mgo Parisiyu aw mgo mata-as to tinu-uhan to mgo Hudiyu, pigpahimun dan to tibò to mgo punu-an to tinu-uhan aw susukun-sukun kandan no nig-iling to “Amonuhon ta man bahin to kandin impang-anad su mahan-ing to kaboonganan no nahimu din ");
INSERT INTO did_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","aw ogpamanpasakup to kahan-ingan. Ko konà ta mababagan kandin dagow puli makastigu kandan si Jesus to gubirnu to taga-Ruma aw ogkangkadamoy kid ko dodo-oton dan to simbahan ta aw banwa ta.” ");
INSERT INTO did_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Dì si Kaipas no mata-as lagboy to mgo punu-an to tinu-uhan kandà no tu-ig, naka-ikagi to “Wadà gindawanan now so-idi. ");
INSERT INTO did_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ita no mgo Hudiyu, dow wadà now kadaagi to tapat on nasì ayaw ogkahimatayan kid to songobu-uk no ogpatubuson ta no ogpakimatoy to ka-otawan. Ayaw kid tibò ogka-ubus.” ");
INSERT INTO did_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Na to mata-as lagboy to mgo punu-an to tinu-uhan, nakatag-an puli kandin sikan no na-ikagi din su wadà man likat to kandin tu-un puli no domdom. Dì puli impalituk kandin to Ispiritu Santu kan no kagi no napa-atubangan to si Jesus, ogpakimatoy to ka-otawan su si Kaipas to mata-as to mgo punu-an to tinu-uhan to mgo Hudiyu kan no tu-ig. ");
INSERT INTO did_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Dì konà no mgo Hudiyu dà to ogkatubusan su tibò to mgo ka-otawan no nahilatag-latag dini to babow to kalibutan no ogpasakup to Diyus no agad otow no konà no Hudiyu no wadà makalabot kandan to Diyus natodu-on, dì ogkahimun aw ogkasobu-uk dà kandan. Sikan to napa-atubangan to ingkapalituk ki Kaipas no kagi. ");
INSERT INTO did_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Na likat kandà no adow, nigkamumunu-munu kandan dow amonuhon to pagpadoog to paghimatoy dan ki Jesus. ");
INSERT INTO did_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kaling man likat kandà no timpu, wadà ba-ot si Jesus to kahan-ingan no Hudiyu dì nig-andiyà kandin to lunsud no Ipraim no nakabotang diyà to pag-ootan to katahayan no banwa no kahanongan. Namanpakamonang kandan si Jesus du-on aw mgo sakup din. ");
INSERT INTO did_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Na madaas on to tighihinang to Hinang to Pagpalipas to Kado-otan. Mahan-ing to ka-otawan no naman-andiyà to Hirusalim no niglikat to kahilitan no banwa. Dì og-anti kandan to ogpadatong diyà to Hirusalim to konà pad ogkagotò to adow to hinang su moydu-on pad tulumanon no ogkatuman dan no pighingadanan to paglinis. ");
INSERT INTO did_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Na to mgo namba-ot, namanpanganap kandan ki Jesus diyà to simbahan aw ka-inusipay kandan to “Nokoy to domdom now bahin ki Jesus. Dow konà buwa ogba-ot kandin to hinang?” ");
INSERT INTO did_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","To mgo punu-an to tinu-uhan aw mgo Parisiyu, insugù dan on tahan ko moydu-on mataga dow ando-id maka-ugpà sikan no otow no si Jesus, ignangon dan to mgo punu-an su awos madakop. ");
INSERT INTO did_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Na no ogka-onoman pad to adow to tighihinang to Pagpalipas to Kado-otan, nigdatong kandan si Jesus diyà to Bitaniya no lunsud ni Lazaro no pigbuhayan din. ");
INSERT INTO did_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Na, du-on pigbana-an si Jesus. No pighonatan kandan si Jesus aw si Lazaro to ko-ononon du-on to ko-onanan, si Marta no atoboy din to nanghonat. ");
INSERT INTO did_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Si Maria no atoboy din gayod no nadinog tad on tahan to hinimu din, kandà no uras pigpudut din to songo lamita no tumaag nardu no mahal no pahomut aw patagdu-i din to kobong ni Jesus aw pahidi to kandin dà bubuu, no nangho-ot-ho-ot to ngadog du-on to baoy. ");
INSERT INTO did_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Dì si Judas Iskariyuti, no songo sakup ni Jesus no tibò kandan sampuù tag duwa, no kandin iyan to ogbaligyà ki Jesus, naka-ikagi kandin to ");
INSERT INTO did_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Nokoy man no wadà nu pabayluhi to sapì sikan no pahomut su pila buwa pad no gatus to kantidad ko sapì sikan podon. Madoyow pad podon ko diyà nu to mgo publi ibogoy.” ");
INSERT INTO did_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Iyan ing-iling din sikan su wadà ka-at nasì ni Judas to mgo publi dì kawatan no otow si Judas. Nahimu on si Judas no ogtagon to sapì dan tibò, dì ogpinudut-pudutan din dà. ");
INSERT INTO did_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Dì naka-ikagi si Jesus to “Pabay-ani now on si Maria su in-indan din on sikan no pahomut no igtagama din kanak ko adow on to paglobong kanak. ");
INSERT INTO did_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Agad nokoy no adow igkabulig now to mgo publi su kanunoy dà man natuonan kow dan dini to babow to pasak. Dì konà no maugoy to pagka-ugpà ku dini iyu.” ");
INSERT INTO did_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Na pagkama-an to kahan-ingan to ka-otawan no mgo Hudiyu to si Jesus, nakadatong on du-on to baoy ni Lazaro, naman-andu-on kandan. Konà no puli oglambag ki Jesus dì ogkaliyag kandan gayod to ogkita ki Lazaro no binuhoy on ni Jesus. ");
INSERT INTO did_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Kaling man to mgo mata-as to mgo punu-an to tinu-uhan, namangpikii kandan gayod to oghimatoy ki Lazaro ");
INSERT INTO did_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","su kandin iyan to ingkapatu-u on to kahan-ingan to si Jesus, tùtu-u no Imananan to Ka-otawan su pigbuhoy din si Lazaro aw to tawoy, mahan-ing to nig-oyow on to pagpasakup dan to impang-anad to mgo punu-an to tinu-uhan aw kabayà dan on to kandan pagpasakup, su namantu-u kandan ki Jesus. ");
INSERT INTO did_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Na to sunù no adow, sikan mgo ka-otawan no nangkahimun diyà to Hirusalim no namanba-ot to hinang, namakadinog to madani on si Jesus diyà to lunsud. ");
INSERT INTO did_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Dayun namanpudut kandan to lumboy aw pamansungun diyà kandin. Ma-agbot to paglangkoà dan no nig-iling to “Mabuhì. Mapanalanginan kandin no pinatubus ita to Diyus no Magbobo-ot no Harì to mgo ka-Isrilihan.” ");
INSERT INTO did_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Na, impapudut ni Jesus to nati to kabayù aw sakayi din. Napugut on sikan awos matuman to nasulat on diyà to kasulatan no pig-iling to ");
INSERT INTO did_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Mgo taga-Siyun, konà kow ogkatahà to ogsungun to harì now su agaw man ogdatong on iyu no nati dà to kabayù to ogsakoy-sakayan din su konà no mada-og-da-ogon to kandin pagsakup.” ");
INSERT INTO did_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Kandà no timpu, wadà makadaag to mgo sakup ni Jesus to kalitukan kan no kasulatan no natuman on. Dì pagbuhoy ki Jesus aw bayawa diyà to langit, nadomdoman dan kan no kasulatan no intag-an natodu-on bahin ki Jesus aw natuman on. ");
INSERT INTO did_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Na to mgo kahan-ingan no namakakita to timpu to pagbuhoy ki Lazaro no nakalogwà to linobongan kandin, nigpatangkap kandan to nawnangonon bahin to nakita-an dan. ");
INSERT INTO did_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","To mgo kahan-ingan gayod no puli nangkanangonan, iyan ingkasungun dan ki Jesus su nadinogan dan sikan no kaboonganan no hinimu ni Jesus. ");
INSERT INTO did_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Dì to mgo Parisiyu, nigka-inikagihay to “Ahà kow, konad on ogkababagan sikan su tibò to mgo otow dini to babow to kalibutan, namanpasakup on du-on kandin.” ");
INSERT INTO did_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Na to mgo ka-otawan no namanba-ot to hinang diyà to Hirusalim, moydu-on gayod mgo Giriyigu no mgo otow no namanba-ot du-on. ");
INSERT INTO did_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ogkaliyag gayod podon kandan to ogpagbaaw ki Jesus no ogpag-atubang. Namanduguk kandan ki Felipe no taga-Bitsayda no songo lunsud no nasakup to Galiliya no prubinsiya. Nigsingka-ikagi kandan diyà ki Felipe to “Sir, ogkaliyag koy podon ogpagbaaw ki Jesus no ogpag-atubang.” ");
INSERT INTO did_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pignangonan ni Felipe si Andres aw dayun andiya-i dan si Jesus aw nangoni dan kandin to mgo Giriyigu no mgo otow, ogpagbaaw podon kandin no ogpag-atubang. ");
INSERT INTO did_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","No pagkadinog ni Jesus sikan no nawnangonon nig-iling kandin to “Na, nagotò on to adow ku to igkapapayag kud on diyà to tibò to mgo otow to katondanan ku no Tumutubus to Ka-otawan su ogpalabawon ad. ");
INSERT INTO did_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","So-idi iyan. To binhì, monang ogpamogas aw bullug dà gayod iyan sobu-ukon ko igtanom pad diyà to pasak aw kawadà to kandin tahan no lawa aw bugtì on to ogkabauyan. Dì ko ogkawadà on to kandin tahan no lawa aw iyan ogkabauyan to bugtì, ogpamogas on to dakoo. ");
INSERT INTO did_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","To otow no iyan ogpa-aag-aagon to kandin kinabuhì, ogkawada-an dà nasì kandin to kinabuhì din. Dì to otow no oglingawan din nasì to kandin kinabuhì dini to babow to pasak, ogkamoydu-onan kandin to mahudi no adow aw konà ogkawada-an. ");
INSERT INTO did_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","To otow no ogpasakup kanak, ogpakaduma kanak aw agad ando-i a makadoog oghiduma koy dà kadoog aw to otow no og-ampù kanak, igkatahud kandin to Amoy ku.” ");
INSERT INTO did_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Na nig-aboy si Jesus nig-ikagi bahin to ogkadoogan din. Kagi din to “Na, nigwagwaag on to ginhawahan ku. Og-amonuhon kud buwa. Na Diyus no Amoy ku, dow ogpalipwasan ku ikow to kanak kamuwahanan, dow konà. Eh konà, su iyan ing-andini ku su ogtumanon ku to kanak katondanan. ");
INSERT INTO did_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Amoy, matahud to ikow no ngadan.” Dayun nadinog to kagi no ma-agbot likat diyà to langit no na-iling to “Impatahud kud on dì igpa-usab ku dà igpatahud.” ");
INSERT INTO did_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","To mgo ka-otawan no namakatuon no namakadinog, na-intobo-ot dan dow lugung to pagdinog dan. Dì moydu-on gayod naka-ikagi to “Iyan nig-ikagi buwa to diwata.” ");
INSERT INTO did_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Naka-iling si Jesus to “Todu-on no kagi no nadinog now to igkatu-u now to kanak katondanan awos mataga kow, konà no kanak to pigpatu-u todu-on no kagi su iyu to ogpatu-uhon. ");
INSERT INTO did_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Kunto-on nagotò to adow to mgo otow dini to babow to pasak su ogkabo-otan kandan tibò aw si Satanas no nakasakup to mgo otow dini to babow to kalibutan, ogkagawang kandin. ");
INSERT INTO did_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Aw kanak, ko lindogon a no diyà to kinurus no ogtutukon aw pagbuhoy kanak aw tuusa, ogpamadugukon ku to tibò no mgo otow.” ");
INSERT INTO did_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Nig-ikagi si Jesus sikan awos matagahan dow nokoy to igkahimatoy kandin no ogtutukon diyà to kinurus. ");
INSERT INTO did_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Namaka-ikagi to ka-otawan to “Og-amonu man to paghimatoy to Tumutubus to Ka-otawan su agad-agad to kasulatan ta, konà man ogkamatoy kandin su Imananan to Ka-otawan. Intawa man sikan no Tumutubus to Ka-otawan.” ");
INSERT INTO did_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Na impananglitan ni Jesus to pagtabak din no nig-iling to “Kanak no tumatang-away no dini a pad iyu, moydu-on ilawan now, dì konad no maugoy su madaas ad oghipanow su madani on ogkagotò to adow ku. No tantu moy pad ilawan now, ogpakahipanow kow pad dini su dagow masakpanan kow to kasaklopan, su ko oghipanow kow to madiglom, ogpakasuwoy kow. ");
INSERT INTO did_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ko moydu-on iyan ilawan now, ogpakasalig kow on to intang-ow din awos ogkalabot kow to ka-awangan.” Na pag-ikagi ni Jesus sikan, nighipanow on kandin no puli on niglunus. ");
INSERT INTO did_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Agad mahan-ing to kaboonganan no impakita ni Jesus to ka-otawan, dì wadà kadaa kandan to pagtu-u to kandin, Imananan to Ka-otawan ");
INSERT INTO did_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","awos matuman to intag-an ni Isaias natodu-on no lagsoban to Diyus no maglilikwaday no pig-iling to “Diyus no Magbobo-ot noy, ma-intok dà to nigtu-u to impanangon nu kanami agad nakita-an noy on to ingkamatu-ud no kaboonganan no impahimu nu, dì ma-intok dà to nigtu-u.” ");
INSERT INTO did_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Kaling man bullug dà konà ogkabuligan to Diyus kandan su konà ogpakatu-u kandan su intag-an mandà ni Isaias no pig-iling to ");
INSERT INTO did_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Pigpisok to Diyus kandan aw bigtoi. Su ko wadà podon angod sikan, ogpasakup kandan podon kanak aw ogkabuligan podon kandan.” ");
INSERT INTO did_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Iyan ingkatag-an sikan ni Isaias no lagsoban to Diyus su nakita-an din natodu-on to kaboonganan to pagkadiyus ni Jesus to wadà pad goman to pagka-otow din. ");
INSERT INTO did_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Dì moydu-on gayod nigtu-u, su agad mgo punu-an to tinu-uhan to mgo Hudiyu, puli naogos nadaa to si Jesus to Imananan to Ka-otawan. Dì wadà angkon su ogkahadok ko magawang kandan to mgo Parisiyu to kahimunan to tinu-uhan dan ");
INSERT INTO did_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","su sikan mgo punu-an, pigpa-aag-aag dan to pagtahud to otow du-on to pag-uyun to Diyus. ");
INSERT INTO did_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Na, si Jesus nig-ikagi to ma-agbot to “To ogtu-u kanak, konà no kanak dà to ogtu-uhan din, su ogtu-uhan din gayod to nigpa-andini kanak. ");
INSERT INTO did_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","To ogpakakita kanak, ogpakakita gayod to nigpa-andini kanak. ");
INSERT INTO did_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Kanak, nig-andini no awos mahimu a no igkatang-ow to kalibutan. Agad intawa no ogtu-u kanak, konà kandin ogpaka-ugpà du-on to kadigloman. ");
INSERT INTO did_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","To ogpakadinog to kagi ku dì puli din ogpaliwlingawan, konà no kanak to ogbo-ot kandin su iyan ing-andini ku to kalibutan su ogtabangan ku to mgo otow. Konà a ogbo-ot kandan. ");
INSERT INTO did_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","To og-oyow kanak aw og-oyow to kagi ku, to kandin pag-oyow to kagi ku, sikan to igkabo-ot kandin to mahudi no adow. ");
INSERT INTO did_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Wadà ku itubuk i-ikagi su Amoy ku no nigpa-andini kanak, insugù din inhognà kanak to iyan igpalituk din aw ipa-ikagi. ");
INSERT INTO did_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nama-anan ku to tawoy to pagsugù din to kinabuhì no konad ogkawadà. Na agad nokoy no og-ikagihon ku, Amoy ku dà iyan to oglikatan.” ");
INSERT INTO did_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Na madaas on og-abut to tighininang no pighingadanan to Hinang to Pagpalipas to Kado-otan aw kama-ani ni Jesus to ogkagotò on to adow din no ighipanow din kani so-idi no kalibutan aw ulì diyà to Amoy din. Nalogonan din kanunoy to tu-un din no mgo sakup dini to kalibutan, dì du-on igpakita din to ka-aslagan to paglogon din kandan. ");
INSERT INTO did_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Na, namango-on kandan si Jesus to kandan katapusan no pagko-on. No pigpamab-otan on ni Satanas si Judas no anak ni Simon Iskariyuti to igbaligyà din si Jesus, ");
INSERT INTO did_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","4","na si Jesus no ta-un to pagpamango-on dan, pigsakindogan din to ko-onanan su ogpasagkop kandin no oghugasan din to kobong to mgo sakup din no ta-indanan to nasobu-uk on kandan. Nama-anan ni Jesus to tahan on nabogayan kandin to Diyus to kabogbogan no wadà ogboongon. Nama-anan din gayod to Diyus to piglikatan din aw ogdoogan din gayod. Na, piglobas din to nakababow no kabò din aw pamagkosa din to tuwayla du-on to hawak. ");
INSERT INTO did_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Imbus-ug din to wohig du-on to palanggana aw panghugasi din to kobong to mgo sakup din. Dayun pigpahidan din to tuwayla no imbagkos din to hawak. ");
INSERT INTO did_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Na nigduguk si Jesus ki Simon Pedro su oghugasan din to kobong din. Dì naka-ikagi si Pedro to “Nokoy man Sir to ighugas nu to kobong ku.” ");
INSERT INTO did_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Naka-ikagi si Jesus to “Kunto-on wadà ka makadaag to ogkalitukan to oghimuhon ku. Dì to mahudi no adow, kayan nu ogkadaagan.” ");
INSERT INTO did_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Naka-ikagi si Pedro to “Ikow, ayaw nud oghugasi to kobong ku.” Nig-ikagi si Jesus, “Ko konà a pumasagkop aw ko konà a humugas to kobong nu, wadà labot nu kanak.” ");
INSERT INTO did_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Naka-ikagi si Simon Pedro to “Konà no kobong ku dà, dì tibò ogkahugasan nu to boad ku aw uu ku.” ");
INSERT INTO did_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Kagi ni Jesus to “To sakup ku no nakapadigus on, iyan dà kanunoy ku ogkahugasan to kobong su tibò, tahan on malinis gawas to kobong. Iyu, malinis kow on, dì konà no tibò kow.” ");
INSERT INTO did_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Tahan on nama-anan ni Jesus dow intawa to ogbaligyà kandin. Kaling man na-ikagi din to “Konà no tibò kow no nalinisan.” ");
INSERT INTO did_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Na si Jesus, no pagkatapus to pagpanghugas din to kobong dan aw pangabò, nigpati-ulì kandin diyà to ko-onanan aw ingkud. Dayun nigpanugun-tugun kandin to mgo sakup din no nig-iling to “Konà kow buwa ogpakadaag to nalitukan to hinimu ku? ");
INSERT INTO did_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Pighingadanan a now to Mag-a-anad aw Magbobo-ot now aw tùtu-u iyan su sikan to katondanan ku. ");
INSERT INTO did_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Mano Magbobo-ot a now aw Mag-a-anad, dì nigpasagkop a no pigpanghugasan ku iyu to kobong now, ogpagoadon ku iyu aw ogpasagkop kow aw pahuhugasay kow to kobong now. ");
INSERT INTO did_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Oggoadon now to insanglitanan ku iyu no pagpanghugas ku to kobong now. ");
INSERT INTO did_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","So-idi iyan, to sugu-onon, konà ogpakalabow du-on to amu din. Na to otow no pigpa-andu-on to songo banwa to mata-as din no pigpatubus din, konà kandin ogpakalabow du-on to nigsugù kandin. ");
INSERT INTO did_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ko madaagan now sikan no impang-anad ku, ogkaliyag kow ko matuman now. ");
INSERT INTO did_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Konà no tibò iyu to napa-atubangan to inikagi ku. Natagahan kud dow nokoy to namakasood to otow tibò, agad sikan mgo pigpilì kud on no pangabaga. Dì moydu-on nasulat on diyà to kasulatan no ogkatuman on no pig-iling to ‘To su-un ku no nigpagsau kanak, nahimu no kablang ku nasì.’ ");
INSERT INTO did_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ignangon kud on iyu kunto-on awos to matuman on, ogkatu-uhan now to kanak, Imananan to Ka-otawan. ");
INSERT INTO did_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","So-idi iyan, to otow no ogdawat to madoyow to pigpa-andini ku dini iyu, iyan ogka-angodan to pagdawat din kanak. To otow no ogdawat kanak to madoyow, kandin ogdawat gayod to nigpa-andini kanak.” ");
INSERT INTO did_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Na pagka-ikagi ni Jesus sikan, nigwagwaag to sood to ginhawahan din aw inangon din to ogkadoogan din. Nig-iling kandin to “So-idi iyan, moydu-on kani iyu songo pangabaga ku dà no oglangub ogbaligyà kanak diyà to kablang ku.” ");
INSERT INTO did_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Na to mgo sakup din, nigkasinungla-ay kandan dow intawa dapit kandan to napa-atubangan to pig-ikagi ni Jesus. ");
INSERT INTO did_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Na kanak no nigsulat so-idi no sulat no lagboy tinagaman ni Jesus, nigsoso-ing koy on. ");
INSERT INTO did_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Kaling man pigpayango-an a ni Pedro aw ikagihi a to “Ipanangon dow intawa.” ");
INSERT INTO did_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Dayun piglingì ku aw usipa ku to mahinoy dà to “Dow intawa dapit kanami Sir.” ");
INSERT INTO did_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Tinabak ni Jesus to “To ogbogayan ku so-idi no paan no pigbasà kud to sabow, sikan iyan.” No tapus no pagbasà, iyan pigbogayan din si Judas no anak ni Simon Iskariyuti. ");
INSERT INTO did_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Pagdawat ni Judas to paan, pigsoodan kandin ni Satanas. Pig-ikagihan kandin ni Jesus to mahinoy to “Ton ogkaliyagan nu no oghimuhon, madaas nu oghimuhon.” ");
INSERT INTO did_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Dì to duma no namango-on du-on, wadà nama-an dow nokoy to napa-atubangan ni Jesus to pig-ikagi din. ");
INSERT INTO did_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Moydu-on nakadomdom dow pigsugù ni Jesus to ogpabolihon to kapookanan to hinang dow pabogayan din to publi to sapì su si Judas to nigtagon to sapì noy tibò. ");
INSERT INTO did_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Dì si Judas, no pagdawat din to paan, nighipanow on kandin no awos ogtuman to kandin nadomdoman no madukilom on. ");
INSERT INTO did_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Na pagkali-us ni Judas, pig-aboy ni Jesus to pagpanugun-tugun no nig-iling to “Kunto-on, to Tumutubus to Ka-otawan no pighingadanan to Anak to Otow, bali on ogkatagahan to kandin, nighi-uyun lagboy to Diyus. Aw Diyus gayod, ogkasayà kandin no ogpabaya-on to ogkadoogan to Tumutubus to Ka-otawan. ");
INSERT INTO did_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ko ogkasayà to Diyus, ogpatahudan din gayod to Tumutubus to Ka-otawan aw madaas on ogkatuman. ");
INSERT INTO did_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Na, mgo sakup ku no pigpang-anad ku angod to mgo batà ku, konà no maugoy to pagka-ugpà ku iyu. Ogpangaha-on a now dì igkanangon ku iyu angod to ingkanangon kud on tahan to mgo punu-an to Hudiyu no ‘To ogdoogan ku, wadà ogpakatutuu iyu.’ ");
INSERT INTO did_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Na moydu-on bayà no sugù ku iyu no oglinogonay kow angod to paglogon ku iyu. ");
INSERT INTO did_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ko oglinogonay kow, ogkatagahan to iyu, sakup ku iyu lagboy su oglinogonay kow man.” ");
INSERT INTO did_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Na si Simon Pedro nig-iling to “Pignangonan koy nu to ikow, oghipanow kad on. Ando-i Sir to ogdoogan nu.” Nakatabak si Jesus to “Konà kow ogpakaduma kanak kunto-on diyà to ogdoogan ku. Dì to mahudi no adow, ogpakalupug kow dà kanak.” ");
INSERT INTO did_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Naka-ikagi si Pedro to “Nokoy man Sir no konà a ogpakaduma ikow kunto-on, su kamatayon nu, kamatayon ku dà gayod.” ");
INSERT INTO did_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Nakatabak si Jesus to “Dow tùtu-u sikan no pig-ikagi nu? Dì so-idi iyan, to konà pad no kabukas-bukas no igtaga-uk to manuk, katatou nud on to ilidung to nakilahan a nu.” ");
INSERT INTO did_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Na pigdugangan ni Jesus to pagpanugun-tugun du-on to mgo pangabaga din no nig-iling to “Konà kow ogkapook-pook du-on to ginhawahan now. Iyu, salig kow nasì kanami si Amoy no Diyus. Su kanami no daduwa, nigka-u-uyun koy man. ");
INSERT INTO did_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Na to Amoy ku, mahan-ing to ogka-ugpa-an diyà kandin. Ko konà pa podon no tùtu-u, tahan kud podon pignangonan iyu. Og-andiyà a su oghina-atan ku iyu to ogka-ugpa-an now. ");
INSERT INTO did_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ko umandiyà a aw hina-ata to ogkangka-ugpa-an now, og-ulì a dini su ogdokat a iyu awos ogkatitibò kid on to pag-ugpà. ");
INSERT INTO did_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nama-anan now on man to daan no igkabayà now padoog diyà to ogdoogan ku.” ");
INSERT INTO did_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Na si Tomas naka-ikagi to “Amonu koy man to paglupug ikow su to ogbaya-an nu, wadà noy man kama-ani to ogdoogan nu.” ");
INSERT INTO did_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Nakatabak si Jesus to “Kanak dà to igkabayà now diyà to Diyus no Amoy su kanak to ogtubus iyu diyà to atubangan din. Su kanak to piglikatan to katùtu-uhanan aw kinabuhì now no konad ogkawadà. ");
INSERT INTO did_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ko natagahan a now pa podon lagboy, natagahan now gayod podon to Amoy ku, su nigka-u-uyun koy man. Likat kunto-on ogkatagahan now on to Diyus su nakita-an now on man kandin su nigka-u-uyun koy dà man.” ");
INSERT INTO did_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Na si Felipe nig-iling to “Sir, pakita-a koy on to Diyus no Amoy awos podon malitosan koy on.” ");
INSERT INTO did_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Nig-ikagi si Jesus to “Nokoy man Lagi no wadà a now kama-ani dow intawa a lagboy su nakita-an a now on man, aw angay nakita-an now on gayod to Diyus no Amoy. Nokoy man no naka-iling ka pad to ‘Pakita-a koy to Diyus no Amoy.’ ");
INSERT INTO did_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Dow wadà now buwa tu-uhi to nasobu-uk koy si Amoy? Konà no kanak dà to nalikatan to kagi no impalituk kanak. Wadà ku tubuki to pag-ikagi su Amoy ku to nigbogoy to kabogbogan su nasobu-uk koy dà man to ginhawa, aw kandin to nigpahimu kanak to agad nokoy. ");
INSERT INTO did_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","To kanak no pig-ikagi no nighiduma koy si Amoy, ko konà now tu-uhan sikan, ogtu-uhan now podon nasì su namatu-ud on to kagi to mgo kaboonganan no nangkahimu kud. ");
INSERT INTO did_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Na so-idi iyan, to otow no ogtu-u kanak, ogpakahimu kandin to angod dà to pigpanghimu ku. Agad oglabow pad no hinang, ogkahimu din gayod su og-andiya-an ku to Amoy ku. ");
INSERT INTO did_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ko ogpangamuyu-on now to agad nokoy su nakatagon kow on to ngadan ku, ogkatuman ku su ogsaya-on to Diyus no Amoy to oghimuhon to Anak din su nasobu-uk koy dà man. ");
INSERT INTO did_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Agad nokoy no ogpangamuyu-on now su iyu, nigtagon kow on to ngadan ku, ogkatuman ku man.” ");
INSERT INTO did_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Na nig-aboy si Jesus to pagpanugun-tugun no nig-iling to “Ko tùtu-u man no kanak, oglogonon a now, ogtuman kow to kanak sugù. Ko ogtumanon now to kanak sugù, ");
INSERT INTO did_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ogpangamuyu-an ku to Diyus no Amoy to ogpabogayan kow to duma no Bumubulig no ig-ilis kanak aw tubus kanak dini iyu aw kanunoy kow ogdumahan su sikan to Katuusan no og-anad iyu to katùtu-uhanan su kandin ");
INSERT INTO did_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","pighingadanan to Katuusan no Piglikatan to Katùtu-uhanan. Kandin, konà ogkàdawat to mgo otow no wadà makatu-u kanak su kandin, konà dan ogkakita-an aw konà ogkatagahan gayod. Dì iyu, ogtandu-an kow din aw ogsood to ginhawahan now. ");
INSERT INTO did_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Na, konà ku iyu og-oyowan puli no wadà ogpakatandù iyu agad umandiyà ad to Amoy ku. Og-andinihan ku dà iyu gayod su nasobu-uk koy dà man no Ispiritu Santu no ogsukoli kanak. ");
INSERT INTO did_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ko maugoy-lugoy pad, konà ad ogkakita-an to mgo otow no wadà tu-u kanak. Dì iyu, ogkakita-an a now dà. Mano ogkabuhì a dà, iyu, ogkabuhì kow dà gayod. ");
INSERT INTO did_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ko umabut to Ispiritu Santu, ogkama-anan now lagboy to nasobu-uk koy dà lagboy si Amoy aw kasobu-uk kinow dà gayod. ");
INSERT INTO did_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","To nataga to kanak kasugu-an aw tumana din, kandin to niglogon kanak. To oglogon kanak, kandin to ogkalogonan to Amoy ku. Ogkalogonan ku gayod kandin aw ogpakita-on ku kandin kanak.” ");
INSERT INTO did_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Na si Judas no sangay ni Judas Iskariyuti, naka-iling kandin to “Sir, dow ogka-amonu no kanami dà to ogpakita-on nu to ikow tu-un no lawa. Dì konà nu nasì ogpakita-on to mgo otow no wadà tu-u ikow.” ");
INSERT INTO did_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Nigtabak si Jesus to “Ko oglogon kanak to otow, ogtumanon din to kanak kasugu-an aw kalogoni kandin to Amoy ku aw andu-oni noy kandin aw ugpà koy du-on kandin. ");
INSERT INTO did_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","To konà oglogon kanak, kandin iyan to konà ogtuman to kasugu-an ku su sikan no kasugu-an no impadinog ku iyu, konà no kanak pigtubukan no kasugu-an, dì kasugu-an to Amoy ku no nigpa-andini kanak. ");
INSERT INTO did_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Na no nig-ugpà a kani iyu, innangon kud iyu to mgo impang-anad ku. ");
INSERT INTO did_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Dì to Bumubulig no Ispiritu Santu no ogtubus kanak, ogpa-andinihon to Diyus no Amoy awos tagahon kow din bahin to katu-unan ku tibò. Dumatong kandin og-anad iyu to bayà no igpang-anad aw ipabatuk-batuk din iyu to tibò no tahan ku no impang-anad on iyu. ");
INSERT INTO did_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Na kunto-on igbogoy ku iyu to mahoung no ginhawahan su sikan to igbilin ku iyu tibò. Sikan mahoung no ginhawahan no igbogoy ku iyu, wadà likat so-idi no kalibutan. To ginhawahan now, konà kow ogkapook-pook aw kahadok. ");
INSERT INTO did_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Na-ikagihan kud on iyu to ‘Oghipanow ad, dì og-ulì a dà dini.’ Ko ogpa-aag-aagon now podon to kanak ogkadomdoman, ogtukhawan now nasì podon su ogpagtagbu ad to Amoy ku no labow pad dini kanak. ");
INSERT INTO did_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ingkanangon kud on man iyu to ogkatuman awos matu-uhan a now lagboy ko matuman. ");
INSERT INTO did_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Konà kud on oghaba-on to ogpagbaaw iyu su to ogpakasakup on so-idi kalibutan, og-andinid on. Konà a din ogkada-og. ");
INSERT INTO did_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Dì kunto-on ogtumanon ku pad to insugù kanak to Diyus no Amoy awos mataga to mgo otow to nalogonan ku lagboy to Amoy ku. Na, kuwà kinow on tibò.” ");
INSERT INTO did_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Na no paghina-at dan to oghipanow, nig-aboy pad si Jesus to pagpanugun-tugun din no nig-iling to “Na, kanak iyan ogka-angodan ku to tùtu-u no lawa to tanom aw iyu to mgo sanga. Diyus no Amoy ku to tagtu-un to tanomanan no ogkaliyag to ogpadugangan din pad to bogas. ");
INSERT INTO did_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kaling man, oggawangon to ugbusan to sanga to tanom no awos sumalingsing aw bogas mandà. Agad ando-i no sanga ku no konà ogbogas, oggawangon. Dì to sanga no ogbogas, oggawangan ku to mado-ot awos sumalingsing aw dugang pad to pagbogas. ");
INSERT INTO did_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Iyu, malinis kow on su to kagi ku iyu sikan to ingkalinis now. ");
INSERT INTO did_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Kanunoy kinow ogkaduduma su iyu no sanga, ko ogpagpigtas kow puli, konà kow ogbogas. ");
INSERT INTO did_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Dì ko moydu-on lawa, ogbogas su oghi-uyun man. “Iyu no sanga, ko ogpagduma kow kanak no lawa aw pag-uyun kow, ogbogas kow lagboy su ko pumapigtas kow, wadà ogkahimu now. ");
INSERT INTO did_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Iyu no mgo sanga, ko konà kow ogpag-uyun kanak, oggawangon kow no ogkagangu aw ogpandap-ugon aw ipanimbag diyà to oglogdog no kayu aw ogkasangab. ");
INSERT INTO did_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ko kanunoy kow ogpag-uyun kanak aw ogtagonan now lagboy to kagi ku, to agad nokoy no ogkaliyagan now, agad puli now dà ogpangamuyu-on dini kanak, ogkadawat now. ");
INSERT INTO did_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","“Na-so-idi iyan, to ogkasayà diyà to Diyus no Amoy ku ko bogasan now lagboy to madoyow du-on to ginhawahan now aw sikan to igpatu-u to iyu, sakup ku. ");
INSERT INTO did_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nalogonan a to Diyus no Amoy. Angod dà kanak gayod, nalogonan ku iyu. Kanunoy kow ogpa-uyun kanak. ");
INSERT INTO did_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Na ko ogtumanon now to insugù ku iyu, ogpakaduma kow to naliyagan ku, su ogtumanon ku to insugù kanak to Amoy aw ogpakaduma a to kandin naliyagan. ");
INSERT INTO did_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Na sikan to impanugun-tugun ku iyu su awos ogpatukhawon ku lagboy iyu no wadà ogboongon. ");
INSERT INTO did_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Dì so-idi to igsugù ku iyu no kamatu-udan no oglinogonay kow no angod dà to paglogon ku iyu. ");
INSERT INTO did_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Na to otow, wadà ogpakalabow pad no paglogon du-on to paglogon to otow no ogpakatubus ogpakimatoy to kapadihu din. ");
INSERT INTO did_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ko ogtumanon now to kasugu-an ku, ogkalinogonay kinow. ");
INSERT INTO did_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Konà kud iyu og-usaban oghingadanan to sugu-onon ku pad, dì oghingadanan kud iyu to nigkatinagamay kid su to sugu-onon, konà man ogkataga to domdom to amu din. Dì oghingadanan kud on iyu to nigkatinagamay kid su pigpantaga kud on iyu tibò to nadinog kud on no innangon kanak to Amoy ku. ");
INSERT INTO did_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","“Dì iyu, wadà a now na-an pili-a no amu now, dì kanak, pinilì kud on iyu nasì no sakup ku aw ibotang ku iyu no ogbogas to madakoo no konà ogkagawang, awos agad nokoy no ogpangamuyu-on now to Amoy ku, su sakup ku iyu, ogkabogayan kow din. ");
INSERT INTO did_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Kaling man so-idi to sugù ku iyu no iyu, oglinogonay kow tibò. ");
INSERT INTO did_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Dì to mgo otow dini to babow to kalibutan, pigkablang kow dan, dì konà now ogkalingawan to monang kow pigkablang no pigtugdow a pad pigkablang dan. ");
INSERT INTO did_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ko nakalabot kow podon kandan no wadà tu-u kanak dini to babow to kalibutan, oglogonan kow dan podon nasì su nasobu-uk kow podon tibò no otow. Dì wadà kow man makalabot to mgo otow no konà no sakup ku. Kaling man ogkablangon kow dan su sakup ku iyu no pinilì kud on no ogpasuwayon ku iyu to mgo otow no konà ku no sakup, su konà kow oghidaag. ");
INSERT INTO did_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Kadomdomi now to pig-ikagi kud iyu no pig-iling to ‘To sugu-onon, konà ogpakapalabow du-on to amu din.’ No napahadatan ad to mgo otow, ogkapahadatan kow gayod su mgo sakup ku man iyu. Ko tumanon dan to kanak kagi, ogkatuman dan gayod to iyu no kagi. ");
INSERT INTO did_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Dì ogtumanan kow man to tibò sikan ingka-ikagi kud iyu su sakup kud iyu aw wadà dan gayod katagahi to nigpa-andini kanak. ");
INSERT INTO did_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Ko wadà a podon maka-andini aw wadà ku podon ikapang-anad kandan, konà dà podon lagboy ogdokotan kandan to saà. Dì kunto-on no ingkapang-anad kud on kandan, aw puli dan paliwlingawi, wadà man igkabalibad dan to pagkakastigu kandan to saà. ");
INSERT INTO did_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","No nasobu-uk koy dà si Amoy, ko ogkablangon a to mgo otow, ogpaka-agad gayod no ogkablangon dan to Diyus no Amoy ku. ");
INSERT INTO did_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","To mgo otow dini to babow to kalibutan, dakoo on to saà su puli dan man pigpaliwlingawan to nakita-an dan no nahimu kud on no wadà pad aligbat nakakita no mgo otow. Ko wadà dan podon kakita-i sikan, ma-intok dà podon to saà dan. Dì kunto-on no bali dan nakita-an aw paliwlingawi, kanunoy on kandan pigdokotan to saà no dakoo su kanami si Amoy, lagboy dan ogkablangon. ");
INSERT INTO did_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Dì ogkatuman on man sikan su awos matuman on to nasulat du-on to kasulatan ta no pig-iling to ‘Na pigkablang a dan agad wadà igkakablang dan dini kanak.’ ");
INSERT INTO did_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Dì ko dumatong to Bumubulig no Katuusan no oglikat to Amoy ku no ogpatubuson ku dini iyu, no pighingadanan to Piglikatan to Katùtu-uhanan, ogmatu-udon din gayod to katùtu-uhanan bahin kanak. ");
INSERT INTO did_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Iyu gayod, ogpakamatu-ud kow to katùtu-uhanan su namakaduma kow man kanak likat to kapinunu-an to pagpang-anad ku.” ");
INSERT INTO did_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Na nig-aboy si Jesus to pagpanugun-tugun no nig-iling to “Innangon kud iyu sikan tibò awos konà now matawadan to pagsalig now dini kanak ko abuton kow to kalisodan to mahudi no adow. ");
INSERT INTO did_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ogpanggawangon kow on to kahimunan to tinu-uhan. To oghimatoy iyu to mahudi on no adow, ogka-intobo-ot din dow natuman on to pagbo-ot on kandin to Diyus. Dì konà pad su puli kandin ogtu-u to sikan to pagbo-ot on to Diyus. ");
INSERT INTO did_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ogtumanon dan sikan diyà iyu su sakup noy on man iyu, aw kanami si Amoy no tagsakup iyu, wadà dan kakilani. ");
INSERT INTO did_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Dì nanangon kud on iyu sikan to wadà pad katuman su awos ko magotò on to adow, konà kow ogkaboong-boong. Dì ogkadomdoman now to na-ikagi kud on iyu tahan aw kahogot nasì to pagtu-u now. “Wadà ku ikanangon iyu sikan natodu-on likat to kapinunu-an su nigkaduduma kinow pad. ");
INSERT INTO did_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Dì kunto-on, no og-andiya-an ku to nigpa-andini kanak, wadad naka-usip kanak to ‘Ando-i to dooganan nu.’ ");
INSERT INTO did_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Dì naduyong-ot kow on su ingkanangon kud on iyu to ogkatuman. ");
INSERT INTO did_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Dì tùtu-u to ingkanangon ku iyu no igkadoyow now dà ko makahipanow ad on su ko konà a pa podon oghipanow, to Bumubulig no ogtubus kanak, konà man ogpaka-andini kandin. Dì ko makahipanow ad on, ogpasubaon kud kandin. ");
INSERT INTO did_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","11","Ko dumatong on to Bumubulig no Ispiritu Santu, ogpasabuton din to mgo otow dini to kalibutan to mado-ot to paglapas to kasugu-an to Diyus su ingkasugù din to mgo otow to ogpatu-uhon din kandan du-on to tùtu-u no Anak. Dì kandan, wadà man tu-u. To Bumubulig, ogpasabuton din gayod to mgo otow to ogkabogayan kandan to katuwadongan su ogmatu-udon din to naluwasan kandan to saà su ogmatu-udon to na-uyunan to Diyus to kanak katondanan su ogtuuson a diyà to atubangan to Diyus agad boongon a now. Dì ogtubus a iyu diyà to atubangan din. Ogpasabuton to Bumubulig to mgo otow to maogot ogbobo-otan to Diyus to mgo otow su si Satanas no nakasakup to mgo otow dini so-idi kalibutan, pigbo-otan on to Diyus aw bullug on iyan ogkabo-otan to mgo kasakupan din tibò.” ");
INSERT INTO did_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Na nig-ikagi mandà si Jesus to “Na, moydu-on pad igkanangon ku iyu podon dì konà kow pad ogpakatuwa-ay kunto-on. ");
INSERT INTO did_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ko umandini to Ispiritu Santu no piglikatan to katùtu-uhanan tibò, kandin to ogpang-anad iyu to katùtu-uhanan su konà man ogtubuk-tubuk ogpang-anad su to nadinog din, sikan dà to igkanangon din iyu aw tagaha kow din to ogkatuman to mahudi no adow. ");
INSERT INTO did_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Igtahud a to Ispiritu Santu du-on iyu su ogpanoysoy iyu to impang-anad bahin kanak su ogtubus kanak. ");
INSERT INTO did_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","To katu-unan to Diyus no Amoy, katu-unan ku dà gayod sikan. Kaling man ingka-ikagi ku iyu to Ispiritu Santu, ogtagahon kow din bahin kanak tibò. ");
INSERT INTO did_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Na ko maugoy-lugoy on, konà a now on ogkakita-an. Dì madaas a now dà ogkakita-an mandà.” ");
INSERT INTO did_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","To mgo sakup din, nigka-inusipay to “Nokoy buwa to kalitukan to pig-ikagi din no ‘Ko maugoy-lugoy on’ kun, ‘konà a now on ogkakita-an. Dì madaas a now dà ogkakita-an mandà.’ Nokoy buwa to kalitukan to pig-ikagi din no ‘Og-andiyà ad to Amoy ku.’ ");
INSERT INTO did_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Nokoy buwa to kalitukan to pig-ikagi din no ‘Ko maugoy-lugoy.’ Indoy ta man dow nokoy to kalitukan to pig-ikagi din.” ");
INSERT INTO did_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Dì si Jesus, natagahan din to og-usipan dan podon dow nokoy to kalitukan to pig-ikagi din. Kaling man nig-ikagi kandin to “Dow og-usipon now podon buwa dow nokoy to kalitukan to pig-ikagi ku no ‘Ko maugoy-lugoy on konà a now on ogkakita-an. Dì madaas a now dà ogkakita-an mandà.’ ");
INSERT INTO did_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Na so-idi iyan, ogpamakadaugmatoy kow aw mamakasinogow kow su konà a now on ogkakita-an. Dì to mgo otow no konà ku no sakup dini to kalibutan, ogpamantukhow nasì. Iyu, ogkaduyong-ot kow, dì sikan pagkaduyong-ot now, iyan ogkabauyan to ogtukhow kow. ");
INSERT INTO did_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Na ko pananglitan, buyag no mgo magkabodos, ogkapook-pook ko magotò to adow no a-anakay dan. Dì pagka-anak on, ogkalingawan dan on to kalisodan dan su ogtukhow on nasì su ogkita on to batà. ");
INSERT INTO did_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Na iyu, nangkaduyong-ot kow on kunto-on, dì ogpagtagbu kow on kanak to mahudi no adow aw ogtukhow kow, aw konà kow ogkawada-an to pagtukhow now. ");
INSERT INTO did_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Du-on dà no timpu, wadà ogkapangamuyù now kanak su so-idi iyan, to agad nokoy no ogpangamuyu-on now diyà to Amoy ku, ogkabogayan kow din su sakup ku iyu. ");
INSERT INTO did_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Na iyu no sakup ku, hantod kunto-on wadà pigpangamuyù now diyà to Amoy ku. Dì kunto-on, ogpangamuyù kow aw ogpakadawat kow su sakup ku iyu aw ogtukhow kow lagboy.” ");
INSERT INTO did_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Na nig-aboy si Jesus to pagpanugun-tugun no nig-iling to “Ingkapananglitan ku to impang-anad ku iyu hantod kunto-on. Dì to mahudi no adow, konà kud on igpananglitan. Dì to kalitukan to igpang-anad ku iyu bahin to Amoy ku no Diyus, ogpotosan kud on iyu. ");
INSERT INTO did_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Agad kunto-on, kanak to ogtubus iyu ko moydu-on ogpangamuyu-on now diyà to Diyus no Amoy, dì to mahudi no adow ogpakapangamuyù kow on no ogpakapag-atubang to Diyus su nakasood kow to ngadan ku, ");
INSERT INTO did_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","su kandin no Amoy ku, nalogonan kow din, su nalogonan a now man aw tu-uhi now to Diyus no Amoy to nalikatan ku. ");
INSERT INTO did_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Pag-andini ku to kalibutan, Diyus no Amoy to nalikatan ku. Dì ogkali-usan kud on gayod so-idi kalibutan su ogpati-ulì a diyà to Amoy ku.” ");
INSERT INTO did_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Namaka-i-ikagi to mgo sakup din to “Bali on iyan no pigpotosan koy nud to kalitukan to pig-ikagi nu. Wadà nud ipananglitan kunto-on to mahobong no kalitukan bahin to Diyus no Amoy. ");
INSERT INTO did_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Bali noy on nadaagan to nama-anan nud on to katùtu-uhanan tibò agad pad mahobong. Ogtagahon koy nu to domdom noy agad pad wadà ig-usip noy ikow. Sikan to ingkatu-u noy to Diyus to nalikatan nu.” ");
INSERT INTO did_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Nig-ikagi si Jesus to “Dow bali kow on iyan nakatu-u? ");
INSERT INTO did_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ogkagotò on iyan to adow no igsingkapa-ulì now diyà to iyu no banwa. Agad kunto-on nagotò on iyan. Og-oyowan a now tibò, dì konà iyan no sobu-ukon ku dà su kanunoy a man pigtandu-an to Diyus no Amoy. ");
INSERT INTO did_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Iyan impanugun-tugun ku sikan tibò su awos mahoung to iyu no ginhawahan. No dini kow pad to kalibutan, ogkalisodan kow on dì agad nokoy no og-abut iyu no samuk-samuk, ogliliyag kow nasì su nakada-og ad man to nakasakup so-idi no kalibutan no si Satanas.” ");
INSERT INTO did_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Na pagkatapus ni Jesus to pagpanugun-tugun to mgo sakup din, niglanghag diyà to langit aw ampù to Diyus no nig-iling kandin to “Na Amoy, nagotò on to igmatu-ud nu to kanak katondanan no ogpalabawon a nu. Aw kanak no Anak nu, ogpatahudan ku gayod ikow no ogpalabawon ku ikow gayod. ");
INSERT INTO did_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Su pigpasakup a nu to tibò no ka-otawan dini to kalibutan awos mabogayan kandan no sakup to imbogoy nu dini kanak no kinabuhì no konad ogkawadà. ");
INSERT INTO did_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ogkabogayan to mgo otow to kinabuhì no konad ogkawadà ko ogkatagahan ki dan no ikow no Diyus no sobu-uk dà no tùtu-u no ampu-onon aw kanak no si Jesus no Imananan to Ka-otawan no pigpa-andini nu. ");
INSERT INTO did_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Dini to kalibutan pigpalabow ku ikow Amoy su natuman kud on to impahimu nu tibò kanak. ");
INSERT INTO did_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Na kunto-on Amoy, ogpalabawon a nu diyà to ikow atubangan no angod dà natodu-on no wadà pad kabotad so-idi kalibutan no nigsoso-ing ki no nakalabot a to panalangin nu. ");
INSERT INTO did_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Na pig-ukasan kud to ikòw no ngadan Amoy, du-on to mgo otow no imbogoy nu kanak no wadad kalabotan dan dini to babow to kalibutan. Ikow on no sakup kandan, aw ibogoy nu dà dini kanak. Natuman dan on to ikow no kagi. ");
INSERT INTO did_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nama-anan dan on to kanak katu-unan to tibò no impamogoy nu kanak su diyà makalikat ikow. ");
INSERT INTO did_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Impang-anad kud on kandan to kagi nu no imbogoy nu dini kanak. Pigtagonan dan iyan aw kama-ani dan lagboy to ikow to nalikatan ku aw kama-ani dan to pigpa-andini a nu to kalibutan. ");
INSERT INTO did_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Na kandan no sakup to og-ampu-an ku kunto-on diyà ikow. Konà no mgo otow no konà ku no sakup to og-ampu-an ku. Dì kandan no imbogoy nu kanak, ogtubusan ku ogpangamuyu-an, su sakup nud on gayod kandan. ");
INSERT INTO did_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Su katu-unan ku tibò no mgo sakup, katu-unan nu gayod, aw natahud a su nalabot kud on kandan. ");
INSERT INTO did_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Na, madaas kud on ogkali-usan so-idi kalibutan su oghipanow ad su og-andiya-an ku ikow Amoy. Dì kandan no sakup ku, ogkabitas dà. Amoy no matuwadong, ogpatandu-an ku ikow to mgo sakup ku no imbogoy nud on no igpatagon kandan to pagtu-u to ikow ngadan awos wadà ogboongon ku no sakup aw makatibò kandan angod to pagkatibò ta. ");
INSERT INTO did_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Pagka-ugpà ku dini kandan, pigbantayan kud kandan no impatagon kud to pagtu-u dan to ikow ngadan no imbogoy nu kanak awos wadà ogkado-ot kandan. Pigbantayan ku man aw wadà pigboong ku gawas kan no nahimu to Diyus no do-otonon tahan awos ogkatuman to kasulatan bahin kandin. ");
INSERT INTO did_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Dì kunto-on og-andiya-an kud on ikow Amoy. No dini a pad to kalibutan, nalituk kud sikan no pigpangamuyù ku ikow awos kandan, mamakadinog aw kanunoy mamakatukhow. ");
INSERT INTO did_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","“Impang-anad kud on kandan no sakup ku to tibò to kagi nu. Dì kandan no nasakup ku, ogkablangon to mgo otow no konà no sakup ku su kandan, naka-angod on man kanak su wadà kalabotan dan to mgo otow dini to babow to kalibutan. ");
INSERT INTO did_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Konà ku ogpangamuyu-on diyà ikow to igpabayow ku ikow kandan dini so-idi kalibutan kunto-on, dì igatang ogpangamuyu-on ku to ogpabantayan ku ikow kandan awos konà ubuson ni Satanas no kinado-otan. ");
INSERT INTO did_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Kandan, angod dà kanak su wadà labot dan to mgo otow no konà no sakup ku dini to babow to kalibutan. ");
INSERT INTO did_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ikow no Amoy ku, ogpakatuwadongon nu to mgo sakup ku to ikow no katùtu-uhanan. To kagi nu, sikan iyan to katùtu-uhanan. ");
INSERT INTO did_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","“Na, pigpa-andini a nu to kalibutan awos matumanan to pagbo-ot nu. Ogka-angod dà man su ogpasinghipanawon ku gayod kandan no sakup ku awos matuman to ikow pagbo-ot dini to babow to kalibutan. ");
INSERT INTO did_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Na, oghina-at a pad awos mabuligan ku kandan aw pakatuwadongon kandan to katùtu-uhanan no ingkalikwad kud. ");
INSERT INTO did_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Na Diyus no Amoy ku, konà no kandan dà to og-ampu-an ku diyà ikow. Dì to ogtu-u pad gayod dini kanak no ogkanangonan kandan to mgo sakup ku no tahan on nigtu-u, og-ampu-an ku gayod diyà ikow kandan tibò. ");
INSERT INTO did_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ogpapanalanginan ku pad tibò su awos mahimu no sobu-uk dà tibò, ogka-angod dà ita no nigka-u-uyun aw ogkahimu kinow on no sobu-uk dà tibò. Kaling man ogtu-u to mgo otow dini to kalibutan to ikow Amoy to nigpa-andini kanak su nigka-u-uyun kinow man tibò. ");
INSERT INTO did_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nalabotan kud to ikow pagkatahud su na-uyunan a nu. To mgo sakup ku gayod, ogkalabotan to pagkatahud ku su na-uyunan ku kandan awos ogkasobu-uk kandan tibò Amoy, angod dà to pagkasobu-uk ta. ");
INSERT INTO did_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Kanak aw mgo sakup ku, sobu-uk dà. Ita gayod Amoy, sobu-uk dà aw tawoy sobu-uk dà kandan no mgo sakup ku. Kaling man ogkama-anan to mgo otow dini to babow to kalibutan to ikow to nakapa-andini kanak aw sosokod dà to paglogon nu kanak aw paglogon nu gayod kandan no mgo sakup ku. ");
INSERT INTO did_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Na Amoy, ogkaliyagan ku to ogpakatampu kandan kanak no imbogoy nu kanak awos makita-an dan to kanak no kaboonganan to pagkadiyus ku no imbogoy nu kanak su kanunoy a nu nalogonan likat to wadà pad kabotad to kalibutan. ");
INSERT INTO did_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Amoy no matuwadong, wadà ka katagahi to mgo otow dini to kalibutan. Dì kanak, natagahan ku ikow no Diyus aw katagahi to mgo sakup ku to ikow to nigpa-andini kanak. ");
INSERT INTO did_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Impang-anad ku to mgo sakup ku bahin ikow aw kalitukan to ngadan nu aw ipang-anad ku pad awos ogka-u-uyun koy aw oglinogonay kandan angod dà to paglogon nu gayod kanak.” ");
INSERT INTO did_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Na, pagkatapus ni Jesus to pagpanugun-tugun to mgo pangabaga din, namanghipanow on kandan. Namanlapas kandan to sapà no pighingadanan to Kidrun aw pamansodlop kandan diyà to tanomanan to kayu no sigkonanan no piglibong to aad no batu. ");
INSERT INTO did_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Na si Judas no sakup din dà podon no nigbaligyà kandin, nama-anan din gayod dow ando-i to ogtatagbuhan dan su tahan si Jesus ogpinagtagbu to mgo sakup din du-on. ");
INSERT INTO did_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Si Judas, pigpaduma din to mgo sundau aw mgo guwardya to simbahan no pigpatubus to mgo Parisiyu aw duma no mgo punu-an to tinu-uhan. Nigdaa kandan to ilawan no nighibubugtì aw mgo panganiban. ");
INSERT INTO did_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Agad nama-anan ni Jesus dow nokoy to maduwayan din sikan no timpu dì nigpakaduguk kandin diyà to kahan-ingan aw ki Judas no nakaba-ot du-on. Nig-usip nasì si Jesus du-on kandan to “Intawa to ogpanganapon now.” ");
INSERT INTO did_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Nigsingka-ikagi kandan to “Si Jesus no taga-Nasarit to ogpanganapon noy.” Na-ikagi ni Jesus to “So-i a man.” Si Judas no nigbaligyà ki Jesus iyan nakatuon du-on kandan. ");
INSERT INTO did_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","No malituk ni Jesus sikan, namaka-us-us kandan tibò aw kangkapood kandan su nangkatokawan. ");
INSERT INTO did_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Na nig-usip mandà si Jesus to “Intawa lagboy to ogpanganapon now.” Namaka-ikagi mandà to “Si Jesus man no taga-Nasarit.” ");
INSERT INTO did_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Nig-iling si Jesus to “Pig-ikagihan kud on iyu to so-i a man iyan. Su kanak to ogpanganapon now, konà kow ogpandamoy to kanak mgo sakup.” ");
INSERT INTO did_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Iyan ingka-ikagi din sikan su awos ogkatuman to ingka-ikagi din on diyà to Diyus no “Wadà ogboongon kandan no imbogoy nu kanak.” ");
INSERT INTO did_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Na si Simon Pedro no moydu-on pigdaa no otak, nakalapnut kandin aw itigbas din to sugu-onon to mata-as to mgo punu-an to tinu-uhan. Dì iyan dà na-igù to kalintu-u no talinga din aw kasangguwi. Si Malku to ngadan. ");
INSERT INTO did_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Nig-iling si Jesus diyà ki Pedro to “Isug-ub to otak nu Lagi, su ogtumanon ku nasì to pagbo-ot to Amoy ku no ogkalisodan a kunto-on.” ");
INSERT INTO did_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Na dayun pigdakop si Jesus aw bakusa to mgo sundau aw mata-as dan aw guwardya to simbahan. ");
INSERT INTO did_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Tugdow pigdaa dan si Jesus diyà ki Anas no ugangan ni Kaipas no mata-as to mgo punu-an to tinu-uhan kan no tu-ig, dì to tu-ud kan daduwa no mata-as, na-u-uyun. ");
INSERT INTO did_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Si Kaipas iyan to nangudlin to mgo Hudiyu to madoyow ko songo otow to ogpatubuson to kamatayon to ka-otawan tibò no mgo Hudiyu. ");
INSERT INTO did_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Na kanami no daduwa, si Simon Pedro aw kanak no si Juan, nig-aw-agad koy. Kanak no tahan iyan kinilaa to mata-as, madaas a nakasood to pig-aad no solib din no nakatapik a ki Jesus. ");
INSERT INTO did_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Dì si Pedro, nabilin ku diyà to labas no madani dà to li-otanan. Dayun pigtugutan a to igpadokat si Pedro su kinilaa a man tahan to mata-as. To daga no nigbantoy to li-otanan, bina-id ku aw daaha ku si Pedro du-on to sood to solib no piglibong to aad. ");
INSERT INTO did_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Dì inusip to daga si Pedro to “Ikow, dow konà ka gayod no sakup buwa todu-on no otow?” Nakatabak si Pedro aw lidung to “Konà.” ");
INSERT INTO did_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Na nigpagba-ot si Pedro to mgo sugu-onon aw guwardya to pagpanhinadang du-on to kayu no pigtomog dan su pigpanghagsii kandan su nangkabukas-bukasan kandan du-on to solib. ");
INSERT INTO did_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Na, si Jesus no diyad on to sood to baoy ni Anas no mata-as gayod to tinu-uhan, pig-usip-usip ni Anas bahin to sinakupan din aw to impang-anad din. ");
INSERT INTO did_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Dì nig-ikagi si Jesus to “Wadà inhobong ku no impang-anad ku to ka-otawan. Kanunoy a nigpang-anad du-on to labow no simbahan aw diyà to duma no simbahan aw agad ando-i no ogpagtagbu to mgo Hudiyu diyà a gayod pang-anad. Wadà impang-anad ku no mahobong. ");
INSERT INTO did_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Nokoy man no kanak to og-usipon now dow nokoy to impang-anad ku. Iyan og-usipon now podon nasì to nakadinog on to impang-anad ku su nama-anan dan on dow nokoy to na-ikagi ku.” ");
INSERT INTO did_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","No malituk ni Jesus sikan, pigsampalu to guwardya aw iling to “Nokoy man no pig-iling nu to pagtabak nu to mata-as.” ");
INSERT INTO did_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Nigtabak si Jesus to “Ko konà no tùtu-u to ingkatabak ku, igkadiklamu a now agad-agad to kasulatan ta. Dì ko tùtu-u to ingkatabak ku, nokoy man no pigsampalu a nu.” ");
INSERT INTO did_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Dayun du-on impabakus ni Anas si Jesus aw ipadaa kandin mandà diyà ki Kaipas no mata-as lagboy kan no tu-ig. ");
INSERT INTO did_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Na, og-uli-on tad to tutuwanon ki Pedro to kandin no nadoog-doogan. No pagpanghinadang din pad, pig-usip kandin to mgo naba-otan din to “Ikow iyan buwa sakup ka gayod ton otow?” Dì niglidung si Pedro no nig-iling to “Konà.” ");
INSERT INTO did_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Na to songo sugu-onon to mata-as no su-un ni Malku no sugu-onon no nasangguwan ni Pedro to talinga, nig-usip kandin gayod to “Dow konà no nakita-an ku man ikow diyà ganina to sigkonanan no nigduma ka man kandin?” ");
INSERT INTO did_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Lagboy niglidung mandà si Pedro aw sakadyap nakadongan to taga-uk to manuk. ");
INSERT INTO did_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Na og-uli-on tad to tutuwanon ki Jesus. Pagkabukas no pagkatapus dan to pagpang-usip-usip kandin, niglogwà on si Jesus to baoy ni Kaipas no kahimunanan to mgo punu-an to tinu-uhan to mgo Hudiyu, su ighalin dan si Jesus diyà to kahimunanan to gubirnadur no taga-Ruma. Dì kandan no mgo punu-an to mgo Hudiyu, wadà dan kasoodi to kahimunanan to taga-Ruma su ig-okod man to tinu-uhan dan. Nigpakamonang dà kandan diyà to solib su awos ogpakaba-ot podon kandan to hinang no pighingadanan to Hinang to Pagpalipas to Kado-otan. ");
INSERT INTO did_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Kaling man nakalogwà si Gubirnadur Pilato diyà to balkun to kahimunanan no nigpag-atubang kandan aw iling kandin to “Na, ikagiha now kun dow nokoy to igkadiklamu now so-idi no otow.” ");
INSERT INTO did_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Namang-ikagi kandan to “Ko wadà podon saà so-idi no otow, wadà noy man podon daaha dini ikow.” ");
INSERT INTO did_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Naka-ikagi si Pilato to “Iyu on to ogbobo-ot kandin agad-agad to iyu no kasugu-an no kasulatan.” Namaka-iling kandan to “Kanami no Hudiyu, konà koy ogkatugutan to bala-od now no taga-Ruma to paghimatoy to otow no ogpadodopahon du-on to kinur us.” ");
INSERT INTO did_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Nabuyù dan sikan no igkamatoy ni Jesus su tahan din on natag-an sikan bahin to kamatayon din. ");
INSERT INTO did_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Na nigsood mandà si Pilato to baoy aw sabiha din si Jesus aw usipa din to “Dow tùtu-u no Harì ka to mgo ka-Hudiyuhan?” ");
INSERT INTO did_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Nig-ikagi si Jesus to “Dow harì agad-agad to ikow no pagsabut, dow harì agad-agad to pagsabut noy no mgo Hudiyu.” ");
INSERT INTO did_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Naka-ikagi si Pilato, “Tabaka a nu agad-agad to kanak pagsabut to kagi no harì su kanak, konà a man no Hudiyu. Dì to tu-un nu no mgo otow no mgo Hudiyu aw mgo punu-an to iyu no tinu-uhan, nigdaa ikow dini kanak. Nokoy man to lagboy pighimu nu.” ");
INSERT INTO did_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Nakatabak si Jesus to “To pagkaharì ku, wadà labot so-idi kalibutan. Ko nakalikat podon to kalibutan, og-atuhan kow podon to mgo sakup ku no wadà a podon daaha dini to punu-an to tinu-uhan to mgo Hudiyu. Dì kanak pagkaharì, wadà labot so-idi kalibutan.” ");
INSERT INTO did_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Na-ikagi ni Pilato to “Dì naka-angkon kad on man buwa to harì ka iyan.” Nigtabak si Jesus to “Ko oghingadanan a nu man to harì, na, sigi. Iyan ing-andini ku to kalibutan su ogpang-anad a to katùtu-uhanan su sikan gayod to impaka-otow ku dini to kalibutan. To mgo otow no ogpa-aag-aagon dan to katùtu-uhanan, ogpakapaminog kandan to impang-anad ku aw tuman.” ");
INSERT INTO did_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Si Pilato, naka-iling to “Ah, nokoy lagboy to katùtu-uhanan. Konà ta buwa no puli ogka-otawan no ogkadatongan to katùtu-uhanan.” Na pagkatapus to pagpang-usip-usip ni Pilato niglogwà mandà no nigpag-atubang to kahan-ingan no mgo Hudiyu no nangkahimun du-on to solib aw inikagi din to “Wadà saà din no nakita-an ku. ");
INSERT INTO did_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Dì moydu-on songo kadodoog now no ogpasabukan now kanak to songo pinirisu no ogpili-on now to tighihinang to Hinang to Pagpalipas to Kado-otan. Nokoy to igpabo-ot now kanak kunto-on, ogpasabukan now buwa to Harì to mgo ka-Hudiyuhan?” ");
INSERT INTO did_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Dì namansa-og nasì kandan to ma-agbot to “Konà no sikan no otow, dì si Barabas nasì to ogpasabukan noy.” Dì si Barabas, tulisan iyan kandin no otow. ");
INSERT INTO did_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Na dayun impabu-ud ni Gubirnadur Pilato to pagbo-ot to mgo Hudiyu aw patisood mandà kandin to baoy. Pigpabunaan din si Jesus ");
INSERT INTO did_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","aw to mgo sundau, pigdugadi dan kandin aw piglubid dan to bawbagon no dugihon no impa-angod-angod dan to sinuwang-suwang to harì aw su-uwi dan to uu ni Jesus. Pigkabo-an dan gayod kandin to maogdog no kabò no ogpaka-angod-angod to kabò to harì. ");
INSERT INTO did_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Kunon kun sikan mgo sundau nigkamusta ki Jesus no namang-ikagi to “Mabuhì, Harì to mgo ka-Hudiyuhan,” aw sasampaluha dan pad kandin. ");
INSERT INTO did_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Na si Pilato, niglogwà mandà to balkun aw ikagihi din to kahan-ingan to “No ogpag-atubangon ku kandin iyu, indananan now to kandin, wadà saà din no nakita-an ku.” ");
INSERT INTO did_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Dayun niglogwà mandà si Jesus no nangabò on to maogdog no kabò aw kasu-uwi to sinuwang-suwang no dugihon to uu din. Nig-iling mandà si Pilato diyà to mgo kahan-ingan to “Na, so-idid iyan to otow ubag no nig-atu kun to gubirnu.” ");
INSERT INTO did_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Pagkakita to mgo punu-an to tinu-uhan aw mgo sugu-onon dan no guwardya, namansa-og to “Himatayi. Tutuki.” Naka-iling si Pilato to “Na, iyu on puli to oghimatoy kandin su kanak, wadà man saà din no nakita-an ku agad-agad to bala-od noy no taga-Ruma.” ");
INSERT INTO did_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Namaka-iling to mgo Hudiyu to “Agad-agad to kanami kasugu-an, himatayanan iyan kandin su nigpakunon-kunon to kandin, Anak kun to Diyus.” ");
INSERT INTO did_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Na pagkadinog ni Pilato kan no diklamu ki Jesus, lagboy nigwagwaag to ginhawa din. ");
INSERT INTO did_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Nakapati-ulì mandà kandin to kahimunanan aw ka-usip din mandà si Jesus to “Intawa lagboy to piglikatan nu.” Dì du-on nigpapahonok puli si Jesus. ");
INSERT INTO did_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Naka-iling si Pilato to “Nokoy man no konà a nu ogtabakon. Dow wadà nu buwa kama-ani to kanak to ogpakabobo-ot dow nokoy to ogkadoogan nu, kamatayon dow konà.” ");
INSERT INTO did_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Bali naka-ikagi si Jesus to “Iyan dà igkahimatoy nu kanak ko mabogayan ka to Diyus to kabogbogan. Kaling man dakoo pad to saà to otow no nigdaa kanak dini ikow, su pigdamoy dan gayod to gubirnu.” ");
INSERT INTO did_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Na pagkalituk ni Jesus sikan, pig-antihan pad podon ni Pilato pigsabukan kandin. Dì no pagkadinog to kahan-ingan no mgo Hudiyu to ogpasabukan din podon kandin, pigdugangan dan to pagsa-og no pig-iling to “Ko masabukan nu kandin, konà ka no sakup ni Harì Cesar no mata-as nu pad, su agad intawa no ogpaharì-harì, ogkahimu pad kandin no og-atu pad kandin ki Harì Cesar.” ");
INSERT INTO did_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pagkadinog ni Pilato sikan, pigpalogwà din mandà si Jesus diyà to atubangan to mgo kahan-ingan. Na si Pilato, nig-ingkud du-on to ingkudanan to mata-as du-on to kahimunanan no pighingadanan to Palatapurma no Batu no ko Hinibriyu pa no inikagihan to Gabata. ");
INSERT INTO did_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Na, to adow no tighihina-at to tighihinang to Pagpalipas to Kado-otan no ma-ugtu on to soga, nig-ikagi si Pilato diyà to kahan-ingan to “Iyu no mgo Hudiyu, no agad-agad to nama-anan now, so-idid on to harì now buwa ubag.” ");
INSERT INTO did_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Dì namansa-og kandan to “Gawanga, gawanga, himatayi, tutuki.” Dì naka-iling si Pilato to “Dow ogpahimatayan now buwa kanak to iyu no harì?” Naka-iling to mata-as to mgo punu-an to tinu-uhan to “Wadà harì noy ko konà no harì now no si Cesar.” ");
INSERT INTO did_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Na ingkapabu-ud on ni Pilato aw katugutid on to pagbo-ot to mgo Hudiyu no oghimatayan si Jesus aw to pagpatutuk du-on to kinurus. ");
INSERT INTO did_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Na dayun pigdaa si Jesus to sundau diyà to labas to lunsud. Pigpati-ang-ti-ang dan si Jesus to kinurus no ogtututukan kandin. Namanghipanow on kandan padoog diyà to banwa no pighingadanan to Gulguta no ko Hinibriyu pa no inikagihan, no kalitukan to bobo-ungon to otow. ");
INSERT INTO did_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Du-on itututuk si Jesus aw daduwa pad no ka-otow no kandan, tulisan no pinagdibauy du-on ki Jesus. ");
INSERT INTO did_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Moydu-on insulat ni Pilato no intutuk din gayod du-on to kinurus no ogkabasa no pig-iling to “Si Jesus no taga-Nasarit no Harì to mgo Ka-Hudiyuhan.” ");
INSERT INTO did_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Mahan-ing to mgo Hudiyu no nigbasa kan no nasulat su to banwa no pighimatayan, mandani dà man to Hirusalim no lunsud. Tatou no ka-inikagihan to nasulat to ingkadiklamu kandin, no Hinibriyu, Linatin, aw Giniriyigu. ");
INSERT INTO did_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Dì to mgo punu-an to mgo Hudiyu, namaka-ikagi kandan diyà ki Pilato to “Madoyow podon ko wadà nu isulat podon to ‘Harì to mgo Ka-Hudiyuhan,’ dì iyan insulat nu podon nasì to ‘Kandin, nig-ikagi to Kanak to Harì to mgo Ka-Hudiyuhan.’” ");
INSERT INTO did_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Dì naka-ikagi si Pilato to “Konad on ogka-usab to nasulat kud on.” ");
INSERT INTO did_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Na pagkatapus to pagtutuk to mgo sundau ki Jesus aw kalindog dan to kinurus no natutukan kandin, pigbahin-bahin dan to kabò din no upat no ka-bahin aw kada songo sundau, songo bahin. Dì wadà labot to tahan din no kabò no wadà hinugma-an no tumaag hinaboo. ");
INSERT INTO did_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Kaling nigka-inikagihay to mgo sundau to “Konà ta ogpambahin-bahinon sikan no kabò no tumaag hinaboo. Dì igpabayà ta to tinag-anay nasì dow intawa dapit itanow to makatu-un kan kabò no tumaag hinaboo.” Iyan ingkapugut sikan su awos ogkatuman to nasulat diyà to kasulatan no na-iling to “Pigbahin-bahin dan to kabò ku no impabayà to tinag-anay.” ");
INSERT INTO did_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Kaling man natuman on to mgo sundau. Na to inoy ni Jesus aw laginà din no si Maria no su-un to inoy din no asawa ni Cleopas, aw si Maria no taga-Magdala, nahimunan dan kandin. ");
INSERT INTO did_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Na kanak no si Juan no sakup no nalogonan ni Jesus no tinagaman din lagboy, du-on a man gayod. Pagkakita ni Jesus to inoy din aw kanak, intugun din to inoy din to “Inoy, so-idid on to anak nu no si Juan.” ");
INSERT INTO did_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Intugun din gayod kanak to “Lagi, so-idid on to inoy nu.” Likat du-on kan no uras, pigpa-ugpà kud to inoy ni Jesus du-on to kanak no baoy. ");
INSERT INTO did_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Na, su nama-anan ni Jesus to napongahan on tibò to kabahinan din no awos matuman to kasulatan, na-iling din to “Piglanggahan ad.” ");
INSERT INTO did_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Na moydu-on tagu-anan no moy sukà no inomon. Dayun pig-ood dan to papasopsopay awos pasopsopon to sukà. Insaligpit dan to papasopsopay du-on to tawoy to katinoptopan aw itukoy dan diyà kandin awos makasupsup kandin. ");
INSERT INTO did_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Pag-anti ni Jesus, naka-iling to “Na, naponga on bali tibò,” aw dumuk kandin aw tu-una din ligtasa to ginhawa din. ");
INSERT INTO did_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Na sikan no adow no paghimatoy ki Jesus, adow on no tahan pighingadanan to adow to tighihina-at to tigsisigkonay aw to sunù no adow, tigsisigkonay on no kamatu-udan lagboy. Wadà tuguti to kasugu-an to mgo Hudiyu to ogkabilinan to patoy du-on to kinurus sikan no adawa. To mgo punu-an to tinu-uhan to mgo Hudiyu, nangkapook-pook ko mabilinan dà to patoy sikan no adow. Kaling nangamuyù kandan du-on ki Gubirnadur Pilato to ogpapantigan to kobong to mgo pirisu awos madaas ogkamatoy su awos malingat aw ikalobong. ");
INSERT INTO did_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Dayun pigtugutan ni Pilato aw to mgo sundau, pigpamantigan dan to kobong to daduwa no tulisan no pigtutuk no pinagdibauy ki Jesus. ");
INSERT INTO did_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pigpantigan dan podon gayod to kobong ni Jesus, dì namatoy on man tahan. Kaling wadà dan on pantigi. ");
INSERT INTO did_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Dì piglugsak to sundau to kilid ni Jesus to palidok. Dayun nakalogwà to langosa aw wohig du-on to kilid ni Jesus. ");
INSERT INTO did_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Na kanak no si Juan no nigsulat so-idi, ogkamatu-ud kud sikan no tùtu-u iyan lagboy su nakita-an kud on man, su nakapag-atubang a man kandin. Tùtu-u aw ogkasaligan. ");
INSERT INTO did_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Iyan napugut sikan su awos ogkatuman to nasulat on tahan no pig-iling to “Wadad ogpantigan no bokog din.” ");
INSERT INTO did_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Natuman gayod to duma no nasulat on tahan no pig-iling to “Oglanghagon dan kan otow no piglugsak dan on.” ");
INSERT INTO did_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Na si Jose no taga-Arimatiya, tahan nigpasakup ki Jesus, dì wadà padinog to mgo otow to kandin, sakup ni Jesus su nahadok ko magawang kandin du-on to kahimunan to tinu-uhan to mgo Hudiyu. Dì nigpanginbubuut nasì kandin aw ba-id du-on ki Pilato aw pigtugutan kandin to iyan ogdaa to patoy no lawa ni Jesus. Dayun pig-andu-onan ni Jose aw daaha. ");
INSERT INTO did_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Na si Nikudimu no niglo-uy natodu-on ki Jesus no masaklop no ogpangintaga to impang-anad ni Jesus, nig-andu-on gayod kandin to pigbotangan ki Jesus no nigdawdaa to pahomut no pighingadanan to mira aw aluwi no subla to katlu-an no kilu to kabogatan. ");
INSERT INTO did_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Kandan no daduwa, piglingat dan to patoy no lawa ni Jesus aw lukuti dan to hinaboan no linu no inlukip to pahomut su sikan to kandan no batasan no mgo Hudiyu no mgo otow ko moydu-on iglobong no patoy. ");
INSERT INTO did_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Na moydu-on tinanoman to kayu no madani du-on to pighimatayan ki Jesus aw moydu-on bayà no oglobongan no wadà pad kabotangi aligbat du-on. ");
INSERT INTO did_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Mano madani dà, inlobong dan du-on si Jesus su mahapun on aw madaas on ogkapunu-an to tigsisigkonay to talabahu agad-agad to tinu-uhan to mgo Hudiyu. ");
INSERT INTO did_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Na pagkatatouhid no adow no iyan kapinunu-an no adow to simana, to kabukas-bukas pad, nig-andiyà si Maria no taga-Magdala to lobong ni Jesus. Nakita-an din to naligad on tahan to batu no insomban to lingangahan to piglobongan ki Jesus. ");
INSERT INTO did_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Dì si Pedro aw kanak no si Juan no natagaman ni Jesus, mamonang koy dà du-on to baoy. Dì si Maria, pagkita din to naligad on to batu, nigpa-ulì no nanlaguy dini kanami aw nangoni koy din no nig-iling to “Nadaa on to Magbobo-ot ta. Wadà noy kama-ani dow ando-i kadaa kandin.” ");
INSERT INTO did_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Na si Pedro no wadà inonoka, nigpono-ug aw hipanow padoog diyà to lobong ni Jesus. ");
INSERT INTO did_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Namanlaguy koy dì nakayluhan kud on si Pedro. Nakatugdow a nakadatong. ");
INSERT INTO did_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Nigpa-o-op-op a du-on aw linghaga ku du-on to lingangahan to piglobongan. Iyan nandà nakita-an ku du-on to linu no impukut to lawa ni Jesus no nabilin, dì wadà a pad sood. ");
INSERT INTO did_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Na nakadatong mandà si Simon Pedro aw patisood kandin dayun du-on to piglobongan. Nakita-an din gayod to linu no impukut no nabilin ");
INSERT INTO did_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","aw to panyù no imbodbod to uu, nabugtì on to nabotangan no nalupì dà. ");
INSERT INTO did_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Agad kanak to naka-una to pag-abut diyà to lobong, dì si Pedro to naka-una to pagsood, dì nigsood ad gayod mandà. Nakita-an kud on gayod to imbodbod to patoy no nabilin aw du-on makatu-u a to tùtu-u on iyan no pigbuhoy si Jesus, ");
INSERT INTO did_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","dì wadà noy pad kadagi to kasulatan no intag-an bahin to ogbuhayon kandin. ");
INSERT INTO did_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Na kanami no pangabaga ni Jesus, nigsing-ulì koy on. ");
INSERT INTO did_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Dì si Maria no wadà inonoka, nig-usab mandà kandin nigpa-ulì diyà to lobong. No diyad on kandin to labas to piglobongan no nigsinogow no niglinghag no nakapa-op-op du-on to lingangahan to piglobongan, ");
INSERT INTO did_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","iyan nakita-an din to diwata no daduwa likat to Diyus no namangabò to maputì no kabò no nig-ingkud du-on to piglobongan ki Jesus, to sobu-uk diyà to uu-an topad aw sobu-uk diyà topad to sikadan. ");
INSERT INTO did_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Pig-usip dan si Maria to “Nokoy man no nigsinogow ka.” Nakatabak kandin, “Su pigdadaa dan on man to Magbobo-ot ku. Wadà ku kama-ani dow ando-i makadoog.” ");
INSERT INTO did_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Na no malituk sikan, nakalingì si Maria aw si Jesus to nakita-an din dì wadà din kilaha. ");
INSERT INTO did_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Kagi ni Jesus to “Nokoy to ingkasinogow nu. Intawa to pigpanganap nu.” Nakatabak si Maria to “Sir, ko pigdaa nud on, nangoni a nu dow ando-i nu daaha su ogpuduton kud on podon.” Naka-iling si Maria sikan su na-intobo-ot din si Jesus, dow maglilinis puli to tinanoman. ");
INSERT INTO did_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Nig-ikagi si Jesus to “Maria.” Nakalinggokà si Maria aw maka-ikagi to Hinibriyu no inikagihan to “Rabuni.” Ko ita pa, no kalitukan to “Mag-a-anad.” ");
INSERT INTO did_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Naka-iling si Jesus to “Ayaw a nu ogdawata su wadà a pad kawoy diyà to langit no pig-ugpa-an to Amoy ku no Diyus. Dì ikow kunto-on, pang-andiya-i nud nasì to mgo pangabaga ku no su-un ku aw inangon to ogkawoy ad aw andiyà ad to Amoy ku aw Amoy now gayod. Kandin to Diyus ku aw Diyus now gayod.” ");
INSERT INTO did_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Dayun pigpang-andiya-an ni Maria to mgo pangabaga ni Jesus aw nangoni din to “Nakita-an kud on to Magbobo-ot tanow tibò.” Inlikwad din to impanangon ni Jesus. ");
INSERT INTO did_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Na no masaklop on kan no Dumingu, nangkahimun to mgo pangabaga ni Jesus no pigtakopan to nahimunan dan no baoy su nahadok kandan to mgo punu-an to mgo Hudiyu, ko puli makabotang-botang du-on to gubirnu bahin to nadoogan to pagkamatoy ni Jesus. Na sikan no timpu no ta-un to nighihimun to mgo pangabaga din, tinakin to niglogwà si Jesus du-on to mgo pangabaga din aw pagba-ot kandin du-on kandan. Nig-ikagi kandin to “Madumahan kow to kalinaw kanunoy.” ");
INSERT INTO did_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Na impakita din kandan to butiyow to boad din aw kilid to lawa no nigbutiyow. Dayun namantukhow kandan su du-on dan on bali kama-ani to kandin, Magbobo-ot iyan. ");
INSERT INTO did_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Nig-iling mandà si Jesus to “Madumahan kow to kalinaw kanunoy. To Amoy ku, pigpa-andini a din to kalibutan no pigpatubus a din aw iyu, ogpalapuwaasan ku iyu to mgo otow kotob to binogdokan to langit no ogpatubuson ku iyu.” ");
INSERT INTO did_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","No malituk sikan, pigginhawahan ni Jesus to mgo sakup din aw iling to “Na ogdawaton now on to Ispiritu Santu. ");
INSERT INTO did_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","To otow no moydu-on saà dì ogkabo-otan now dà to ogpasayluhon, ogkapasaylu dà iyan. Dì ko ogkabo-otan now on to ogpadokotan to saà din, ogkadokotan on iyan kanunoy.” ");
INSERT INTO did_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Na si Tomas no piggoan ki Iping no songo pangabaga ni Jesus no sakup kan sampuù tag duwa, wadà du-on to tugdow no paglogwà ni Jesus. ");
INSERT INTO did_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Dì pignangonan on kandin to mgo duma din to “Nakita-an noy on to Magbobo-ot tanow.” Dì naka-iling si Tomas to “Konà a og-inonoka ko konà ku makita-an to butiyow no nalagbasan to tutuk to paad din aw butiyow gayod to kilid to lawa din, aw kadamdami ku tibò.” ");
INSERT INTO did_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Na pagkawauhi no adow, nangkahimun mandà to mgo pangabaga ni Jesus du-on to baoy aw bali makaba-ot si Tomas. Natakopan to baoy dì nakalogwà on si Jesus no nigpagba-ot du-on kandan. Nig-iling kandin to “Madumahan kow to kalinaw kanunoy.” ");
INSERT INTO did_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Nig-iling si Jesus diyà ki Tomas to “Lagi, dini ka aw damdama nu to butiyow ku dini to kilid to lawa ku. Aha-a to paad ku no nigbutiyow on to nabaya-an to tutuk. Konà ka ogkaduwa-duwa dì nasì tibuuson to domdom nu aw tu-u ka to pigbuhoy ad on.” ");
INSERT INTO did_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Naka-ikagi si Tomas to “Nigtu-u ad on ikow no Magbobo-ot ku aw Diyus ku.” ");
INSERT INTO did_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Naka-iling si Jesus to “Dow nakatu-u kad on buwa su nakita-an a nud on no pigbuhoy on? Dì to otow no ogtu-u kanak agad wadà a din pad kakita-i, ogkaliyag kandin.” ");
INSERT INTO did_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Na, mahan-ing pad to kaboonganan no nahimu ni Jesus diyà to atubangan to mgo sakup din no wadà ikasulat kani to diblu. ");
INSERT INTO did_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Dì iyan ingkasulat so-idi su awos makatu-u kow to si Jesus to Imananan to Ka-otawan no Anak to Diyus, aw kabogayi kow to kinabuhì now no konad ogkawadà su ogpakatu-u kow to ngadan din no kalitukan to kandin katahani tibò. ");
INSERT INTO did_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Na piglogwà mandà ni Jesus to mgo sakup din diyà to boyboy to dagat no pighingadanan to Tibiriyas aw pighingadanan gayod to dagat to Galiliya. Na so-idi to impabayà to paglogwà din. ");
INSERT INTO did_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Du-on to boyboy nangkahimun koy on, si Pedro aw si Tomas no piggoan ki Iping, aw si Natanael no taga-Kana no nasakup to Galiliya, aw kanami no daduwa no anak ni Sibidiyu, aw daduwa pad no sakup din. ");
INSERT INTO did_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Na tigpoak naka-iling si Simon Pedro to “Na kanak, ogpangisdà a.” Naka-iling koy tibò to “Na, su agun ogduma koy ikow.” Dayun namanhipanow koy on aw pamanluwan koy to bautu. Dì puli koy on nabukasan, wadà napudut noy no isdà. ");
INSERT INTO did_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Na pagkabukas, nakita-an noy to otow no nigsakindog du-on to boyboy dì wadà noy kilaha kandin. Dì si Jesus man na-an. ");
INSERT INTO did_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Dayun to nigtawag kandin to “Lagi, dow moydu-on napudut now on no isdà?” Namakatabak koy to “Ampan.” ");
INSERT INTO did_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Kagi ni Jesus, “Itaktak now on diyà dapit to kalintu-u to bautu to pukut now su moydu-on on bali ogkapudut now.” Dayun intaktak noy. Na, konad podon ogkabatun to kabogat su mahan-ing on to isdà bali no nakasood. ");
INSERT INTO did_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Na kanak no si Juan no nigsulat so-idi no sulat, no sakup a gayod no tinagaman lagboy ni Jesus, naka-iling a gayod to “Magbobo-ot tanow iyan sikan.” No malituk ku sikan, si Pedro, nigpangabò su niglobas man tahan su nangisdà man. Na dayun nigkawas kandin du-on to dagat aw languy padoog diyà ki Jesus. ");
INSERT INTO did_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Dì kanami no duma no sakup din, namanakoy koy dà padoog diyà to bagibitan no puli nigguyud koy on to pukut no naponù on to isdà, su madani on to bagibitan no mgo kalim-an dà no dopa to kadiyu-an. ");
INSERT INTO did_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Na pagkadapat noy on, nakita-an noy to moydu-on on nahaub no isdà tahan du-on to pigbuhì no buling. Natingub gayod to paan. ");
INSERT INTO did_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Nig-ikagi si Jesus to “To sodà du-on, salin kow aw daaha now dini.” ");
INSERT INTO did_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Dayun nigluwan si Pedro to bautu aw dawata din to pukut aw guyuda din diyà to bagibitan no sikan pukut, naponù on to isdà no songo gatus aw kalim-an aw tatou no bu-uk. Agad mahan-ing no mangka-aslag no isdà, dì wadà kahigbit to pukut. ");
INSERT INTO did_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Nig-ikagi si Jesus to “Na, ogko-on kid.” Wadà sakup din no nakalangub to pag-usip dow intawa kandin su nama-anan noy to Magbobo-ot noy kandin iyan. ");
INSERT INTO did_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Na pigtadwayan koy din to paan aw isdà. ");
INSERT INTO did_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Sikan to ikatou no paglogwà ni Jesus du-on to mgo sakup din no pigbuhoy on kandin. ");
INSERT INTO did_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Na pagkatapus noy to pagko-on, nig-ikagi si Jesus diyà ki Simon Pedro, “Simon no anak ni Juan, to logon nu dini kanak, dow labow pad diyà to kandan no paglogon?” Nakatabak si Pedro to “Ho-o Sir, nama-anan nu man to niglogon a ikow.” Nig-iling si Jesus, “Na, ogtubungan nu to ugà to buhì ku no karniru.” ");
INSERT INTO did_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Nig-usip mandà si Jesus to “Simon no anak ni Juan, dow oglogonan a nu?” Nakatabak mandà si Pedro to “Ho-o iyan. Nama-anan nu to niglogon a ikow.” Nig-ikagi si Jesus to “Na, og-alaga-an nu to buhì ku no karniru.” ");
INSERT INTO did_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Na, nig-iling mandà si Jesus to “Simon no anak ni Juan, dow oglogonan a nu iyan?” Iyan ingkasawà ni Pedro su nig-usip si Jesus kandin to katatou dow oglogonan din kandin aw maka-ikagi kandin to “Sir, nama-anan nud tibò. Nama-anan nu to niglogon a ikow lagboy.” Nig-ikagi si Jesus to “Ogtubungan nu to mgo buhì ku no karniru. ");
INSERT INTO did_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Na so-idi iyan, ton batà ka pad, iyan oghinangon nu to ogpanghimos ka aw agad ando-i ka to makadoog. Dì ko mabuyag kad on, oghonat ka puli to boad aw ogkabo-an ka to duma aw bagkosi ka to duma no konà nu no duma aw kadaa ka diyà to konà nu podon ogkaliyagan no banwa.” ");
INSERT INTO did_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","To pag-ikagi ni Jesus sikan, napa-atubangan din to ogkabaya-an to igkamatoy ni Pedro no igpa-ahà to pagpasakup din to pagbo-ot to Diyus su ogpadodopahon gayod kandin du-on to kinurus. Na nig-ikagi mandà si Jesus to “Na Lagi, ogdumahan a nu diyà to kanak no ogdoogan.” Dayun nighipanow koy on. ");
INSERT INTO did_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Na, nakalingì si Pedro aw makakita kanak no niglupug ki Jesus no kanak iyan natagaman ni Jesus no nigpagso-ing kandin todu-on pagpanugun-tugun din kanami du-on kan no pagko-on noy aw usipa ku to “Dow intawa Sir toogbaligyà ikow.” ");
INSERT INTO did_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Na pagkakita ni Pedro kanak, naka-usip kandin ki Jesus to “Sir, nokoy to ogkadoogan so-i no otow,” su to kagi ni Pedro, kanak to napa-atubangan. ");
INSERT INTO did_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Nakatabak si Jesus to “Wadà labot nu sikan. Kanak dà to ogbobo-ot to ogkadoogan din. Agad pahaba-on ku to umuu din dow konà kotob to pag-ulì kud dini, dì wadà labot nu sikan. Dì to ikow, to oghimuhon nu, ogdumahan a nu.” ");
INSERT INTO did_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Dayun natangkapan to nawnangonon to kanak, konà a ogkamatoy. Dì wadà din inangon to kanak no si Juan, konà a ogkamatoy. Dì puli din nasì innangon no nig-iling to “Agad pahaba-on ku to umuu din dow konà kotob to pag-ulì ku dini, dì wadà labot nu sikan.” ");
INSERT INTO did_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Na kanak no si Juan to nabawbaawan dan bahin to ogkadoogan ku, aw kanak to nignangon aw nigsulat sikan no napugut. Nama-anan ku to tùtu-u to ingkanangon ku tibò no nasulat on kani. ");
INSERT INTO did_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Mahan-ing pad man to nahimu ni Jesus no wadà ku kasulat. Ko isulat ku pa tibò, domdom ku to so-idi kalibutan konà no ogka-oog to ogkabotangan to mgo diblu su mahan-ing pad iyan to susulatay podon.");
INSERT INTO did_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Kamusta ka Sir Teofilo: Sikan tugdow ku no sulat ikow natodu-on, impannangon ku ikow tibò bahin to pighimu ni Jesus aw sikan tibò no impang-anad din likat to kapinunu-an ");
INSERT INTO did_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","hantod to nabayow kandin diyà to langit. Dì monang pigbayow kandin no nanugun-tugun pad no pinabayà to kabogbogan to Ispiritu Santu diyà to mgo pigpilì din no oghimuhon din no tumutubus din diyà to mgo ka-otawan. ");
INSERT INTO did_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Mahan-ing to inmatu-ud din to pigbuhoy dà kandin iyan no namatoy su niglinogwà dà kandin du-on to sood to kap-atan no adow su nang-anad kandin kandan to pagsakup to Diyus. ");
INSERT INTO did_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","No du-on pad si Jesus to mgo tumutubus din, insugù din kandan no nig-iling to “Pakamonang kow kani so-idi no lunsud to Hirusalim aw tagad kow to insahad iyu to Diyus no Amoy no innangon kud on iyu natodu-on, ");
INSERT INTO did_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","su si Juan, pigmatu-ud din natodu-on to pagpasakup now to kandin impang-anad no impabayà to pigbonyagan kow din to wohig. Dì kanak, madaas on to ogmatu-udon kud to pagpasakup now to kanak impang-anad no ogbonyagan ku iyu to Ispiritu Santu no iyan ogsoodan kow din lagboy.” ");
INSERT INTO did_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Na no pagkahimun dan aw ni Jesus diyà to untud no pighingadanan to Ulibu-an, naman-usip to mgo tumutubus din to “Magbobo-ot, kunto-on dow ogpatubukon nu buwa to bandila ta no mgo Hudiyu no ita, nasakup kid on man to mgo taga-Ruma, aw pa-untuwa nu dà buwa ita to pagsakup to ita no banwa?” ");
INSERT INTO did_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Nakatabak si Jesus to “Diyus dà to ogpakagotò to adow aw ogpakabobo-ot to kabotang ta to pagka-untuu dini ita to pagsakup, dì konà kow ogkataga su tibò, kandin dà to ogpakabobo-ot. Wadà labot now sikan. ");
INSERT INTO did_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Dì kunto-on, bugtì to katondanan now su ko mamatu-ud on to Ispiritu Santu to nasoodan kow din on lagboy, iyan on ogkadawat now to kabogbogan aw agad ando-i ogkamatu-ud now to kanak, pigbuhoy ad on, aw iyu no ogmatu-ud, ogpalapuwaason ku iyu tibò no oglikat kow diyà to Hirusalim aw kotob to mgo timamanwa tibò no nasakup to mgo prubinsiya no Hudiya aw Samariya aw hantod to binogdokan to langit.” ");
INSERT INTO did_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Pagkatapus ni Jesus to pag-ikagi sikan, pigbayow on kandin diyà to langit no puli namakalanghag to mgo tumutubus din tibò. Pag-aboy dan paglanghag, pigboong dan on si Jesus su nakakaylu on man to gabun. ");
INSERT INTO did_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","To namanlanghag pad kandan, tinakin nig-abut du-on kandan to daduwa no ka-otow no mangkaputì to kabò aw sakindog du-on kandan. ");
INSERT INTO did_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Nig-ikagi kan daduwa no ka-otow diyà kan mgo tumutubus ni Jesus no pig-iling to “Iyu no taga-Galiliya, nokoy man no namansakindog kow kani aw aboy kow langhag diyà to langit. Si Jesus no pigbuhoy on aw tuusa, to mahudi no adow oglugsad dà dini to babow to pasak no angod dà to pagkabayow din su ogkakita-an dà kandin to mgo otow.” ");
INSERT INTO did_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Na nigsudsud to mgo tumutubus ni Jesus to imbayà no songo kilumitru dà to kadiyu-an likat to Ulibu-an no untud hantod to Hirusalim. ");
INSERT INTO did_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Pagdatong dan diyà to Hirusalim, namanponhik diyà to di-atas no ikaduwa no konhà no pig-ugpa-an dan. Na sikan tibò nangkahimun du-on no mgo tumutubus ni Jesus, si Pedro, si Juan, si Santiago, si Andres, si Felipe, si Tomas, si Bartolome, si Mateo, si Santiago no anak ni Alpiyu, si Judas no anak ni Santiago, aw si Simon no iyan goa din si Silutis no kalitukan to mapatubuk-tubukon no otow to bandila. ");
INSERT INTO did_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Nakatampu gayod to inoy ni Jesus aw mgo kasu-unan din, aw duma pad no mgo buyag. Masabid to paghihimun-himun dan aw ogpamangpuna-us kandan to og-ampù to Diyus no pigsobu-uk to ginhawa dan. ");
INSERT INTO did_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Na no nangkahimun to mgo sakup ni Jesus no songo gatus aw kawa-an tibò kandan, nangukdayogan si Pedro su igpapilì din to otow no ogkabogayan to katondanan ni Judas. ");
INSERT INTO did_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Nig-ikagi si Pedro to “Mgo kasu-unan ku, natuman on to nasulat no impatag-an ki David to Ispiritu Santu bahin to ogkadoogan ni Judas Iskariyuti no nig-allad to mgo otow no ogdakop ki Jesus. ");
INSERT INTO did_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Aag gayod si Judas nakaba-ot to ita no sinakupan natodu-on. Si Judas, nakaduma gayod kanami no pangabaga ni Jesus su pighimu koy tibò ni Jesus no sampuù tag duwa no tumutubus din diyà to ka-otawan. ");
INSERT INTO did_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","“Dì imbaylu ni Judas si Jesus to sapì, dì ing-ulì din dà podon. Dayun nig-ogot kandin no nigbibitoy to tu-un din no lawa aw makadusmuu kandin diyà to pasak aw botu to gotok aw kangkabutbut to tino-i. To sapì no imbayad diyà kandin to hinang din no mado-ot, iyan nadoogan to ingkabayad gayod to pasak no namatayan din. ");
INSERT INTO did_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Niglogob to nawnangonon to mgo taga-Hirusalim bahin ki Judas aw hingadani dan sikan no pasak to Akildama no kalitukan to Pasak no Langosahon, su to sapì no imbayad sikan no pasak, nakapood man to otow. ");
INSERT INTO did_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Natuman on to nasulat diyà to kasulatan no pighingadanan to Mgo Salmu no pig-iling to ‘Maboboas-boasan podon to pig-ugpa-an din.’ Natuman on gayod to nasulat no pig-iling no ‘Masukolihan podon kandin to katondanan.’” ");
INSERT INTO did_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Na nig-aboy si Pedro nig-ikagi no nig-iling to “Na, ogpili-on tad to otow aw patampuha tad su ogpasabut kid to mgo ka-otawan to pigbuhoy on si Jesus. Iyan ogpili-on ta to otow no nakadumduma on kanami aw ki Jesus likat to pagpangudlin ni Juan no Magbobonyagay aw hantod to pagbuhoy on ki Jesus aw kabayow diyà to langit. Kandin iyan to ogpili-on ta no ogpaka-ilis ki Judas.” ");
INSERT INTO did_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Na pigtubuy dan to daduwa no ka-otow. To mgo ngadan dan si Matias aw si Jose no pighingadanan gayod ki Barsabas dì pig-apiliduhan, ki Justo. ");
INSERT INTO did_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Dayun naman-ampù kandan to Diyus no iniling dan to “Diyus no Magbobo-ot, tahan nu man nama-anan dow nokoy to nakasood to ginhawahan to otow. Og-aha-on nu dow intawa dapit so-idi daduwa no ka-otow to pigpilì nu ");
INSERT INTO did_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","no tumutubus ni Jesus no ogpakasukoli to katondanan ni Judas, su nig-oyow on man kandin aw nig-andiyad on to kandin no ogdoogan.” ");
INSERT INTO did_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Pagkatapus dan to pag-ampù to Diyus, pighimu dan no tinag-anay dow ando-i dapit kan daduwa no ka-otow to napilì to Diyus no ogkahimu no tumutubus ni Jesus. Iyan nakalabas si Matias. Dayun pighimu dan si Matias no ikasampuù tag duwa no tumutubus ni Jesus. ");
INSERT INTO did_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Na pag-abut to pitu no simana likat to pagkamatoy ni Jesus, adow on mandà to tighihinang no pighingadanan to Pintikustis. Namanhihimun on diyà to songo baoy to sinakupan ni Jesus no mgo tumaag Hudiyu kandan dì tibò taga-Galiliya. ");
INSERT INTO did_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tagbayà nadinog dan to angod to kamag no nangambohong likat diyà to langit no nanikung-sikung du-on to sood to baoy. ");
INSERT INTO did_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Dayun nakita-an dan to angod to logdog no ogpaka-imo-ot to dilà no ogdilam, aw dayun nighan-ing to logdog hantod to piglogoban to tagsobu-uk kandan tibò no nahimun. Dayun namanpabunsud kan angod to dilà no logdog du-on to uu to tagsobu-uk no otow. ");
INSERT INTO did_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Tinakin nasoodan kandan to Ispiritu Santu aw tigka-un naman-ikagi kandan to impalituk kandan no likat to Ispiritu Santu no mgo inikagihan no nigsingkabugtì no wadà dan aligbat anadi. ");
INSERT INTO did_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Na no sikan pagkasoodi dan to Ispiritu Santu, moydu-on gayod namang-agpot du-on to Hirusalim no mgo otow no nigsingkabugtì to banwa no pigmutmutan dan dini to babow to kalibutan. Dì namantagon to tinu-uhan to mgo Hudiyu dì nigsingkabugtì to inikagihan dan. Namantampu kandan du-on to Hirusalim awos makaba-ot kandan to hinang. ");
INSERT INTO did_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Natokawan kandan no namanmutmut aw kahihimun kandan su nakadinog kandan to pangambohong to kamag aw makasindinog kandan to kandin tu-un no inikagihan no nigsingkabugtì no iyan tigka-un nangkalituk to mgo sinakupan ni Jesus. ");
INSERT INTO did_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","8","Lagboy naboong-boong kandan aw maka-ikagi to “Og-amonuhon dan man buwa to paglituk to nigsingkabugtì no inikagihan tanow no namanmutmut to kadiyu-an no mangkuwan podon kandan taga-Galiliya man. ");
INSERT INTO did_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Na, so-idi kinow on no taga-Partiya, taga-Midiya, taga-Ilam, taga-Misuputamiya, taga-Hudiya, taga-Kapadusiya, taga-Puntu, taga-Asiya, ");
INSERT INTO did_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","11","taga-Pirigiya, taga-Pampiliya, taga-Ihiptu, taga-Krita, taga-Arabiya, aw taga-Libya no nasakup to Sirini, aw taga-Ruma, agad Hudiyu aw duma no mgo otow no nigpasakup to ita no tinu-uhan, itanow tibò, nangkadinog tad bahin to mabogbog no kaboonganan to Diyus to pagpannangon dan no mgo sakup ni Jesus to itanow no inikagihan no nigsingkabugtì.” ");
INSERT INTO did_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Lagboy naboong-boongan dan to tigka-un no angod sikan aw ka-inusipay kandan to “Nokoy on man buwa to ogkadoogan sikan.” ");
INSERT INTO did_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Dì moydu-on duma no nigdugadi no nig-iling to “Namangminahingow buwa puli sikan no mgo otow.” ");
INSERT INTO did_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Dì si Pedro aw duma pad no tumutubus ni Jesus no iyan sampuù tag isa, namansakindog du-on. Si Pedro to nangudlin to kahan-ingan to ma-agbot no nig-iling to “Na mgo kasing-Hudiyu ku, aw duma no namang-agpot dini to Hirusalim, og-indanan now to ig-udlin ku iyu. ");
INSERT INTO did_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Intobo-ot now buwa to namangminahingow koy. Dì wadà koy man su masoom pad aw konà pad no litos no igkaminahingow to otow. ");
INSERT INTO did_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Natuman on iyan to impatag-an ki Joel no maglilikwaday gayod to Diyus natodu-on no lagsoban no pig-iling to, ");
INSERT INTO did_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“‘To mahudi no adow, kagi to Diyus, igpamogoy ku to Ispiritu Santu diyà to ka-otawan tibò no nigsingkabugtì to banwa. To mgo kasinugpu-an now, agad lukos aw buyag, ogpakalikwad kandan to kanak kagi no igpalituk ku kandan. To mgo lukos no batan-on pad, moydu-on igpakita ku kandan aw to mgo manigo-on, moydu-on igpataga-inop ku kandan. ");
INSERT INTO did_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ogpasoodan ku gayod to Ispiritu Santu to mgo sugu-onon ku, agad lukos aw buyag. Igpalikwad kud kandan to kagi ku. ");
INSERT INTO did_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Oghinang a to kaboonganan diyà to langit. Oghinang a to ta-indanan dini to kalibutan no ogkakita-an to langosa aw logdog aw oboo, ");
INSERT INTO did_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","aw ogkawadà to bandog to soga. Ko aha-on now to buwan, maogdog no iyan ogka-angodan to langosa. Ko ogkakita-an now on sikan no mgo kaboonganan, na ogkatuman on iyan to tùtu-u no adow to pagkastigu to Diyus no konà ogkalingawan. ");
INSERT INTO did_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Dì agad intawa no otow no og-ampù to ngadan to Diyus no Magbobo-ot, ogkaluwasan dà.’ Sikan to impatag-an ki Joel to Diyus.” ");
INSERT INTO did_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Na nig-aboy si Pedro to pag-udlin no nig-iling to “Na mgo kasu-unan ku no kasinugpu-an ni Israel, paminog kow to ignangon ku iyu. Sikan no otow no si Jesus no taga-Nasarit, pigmatu-ud to Diyus to kandin iyan to Imananan to Ka-otawan no pinabayà to kaboonganan no pighimu din kani to ita no banwa aw kama-ani now on gayod. ");
INSERT INTO did_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Tahan pigbo-otan to Diyus no Amoy to igkahatod now si Jesus diyà to mgo otow no wadà tahud to kasugu-an to Diyus aw pahimatayi now pad du-on to kinurus. ");
INSERT INTO did_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Dì wadà tuguti to Diyus to ogkatuyunan si Jesus no namatoy su pigbuhoy dà si Jesus to Diyus su katahani ni Jesus konà no ogkatuyunan to kamatayon. ");
INSERT INTO did_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Nasulat on ni David natodu-on no wadà pad goman to ogka-otow si Jesus bahin to og-ikagihon ni Jesus no pig-iling to, “‘Nama-anan ku to kanunoy a ogtandu-an to Magbobo-ot ku. Nigso-ing dini dapit to kalintu-u ku awos konà a ogkapook-pook. ");
INSERT INTO did_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Kaling man ogtukhow a nasì aw makasayà a ikow. Agad mamatoy ad, dì og-imanon ku to ogbuhayon a dà man. ");
INSERT INTO did_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Nama-anan ku to konà nu og-oyowan to umagad ku diyà to ugpa-anan to nangkamatoy. Konà nu gayod ogtugutan to ogkadunut to lawa ku no sugu-onon nu no matinumanon, su ogbuhayon a nu dà man. ");
INSERT INTO did_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Pighindu-an a nu to babayà no igkatutuu to banwa no wadà kamatayon. Ogpatukhow ka kanak nasì su konà kid man oghibugtì.’ Sikan to impa-ikagi ki David to Ispiritu Santu natodu-on bahin to Imananan to Ka-otawan.” ");
INSERT INTO did_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Na nig-aboy si Pedro to pagpangudlin no nig-iling to “Na mgo kasu-unan ku, ogpanoysoy a iyu bahin ton kagi ku iyu bahin ki David no puna ta. Kandin, nasulat din bahin to kamatayon aw pagbuhaya ni Jesus. Wadà nasulat din bahin to kandin tu-un no kamatayon aw pagbuhaya din. Namatoy on si David dì wadà pad buhaya. Hantod kunto-on ogkakita-an ta pad to piglobongan kandin no natakopan pad. ");
INSERT INTO did_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Si David no lagsoban to Diyus no maglilikwaday no buhì pad dini to pasak, nadaagan din to insahad kandin to Diyus no pinabayà to madigon no kagi no innangon din no ogpasakupan to Diyus to sugpù ni David to kandin pigsakupan. ");
INSERT INTO did_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Pig-iman ni David to ogkatuman to kagi to Diyus no impatag-an din bahin to ogbuhayon to Imananan to Ka-otawan su intag-an ni David to ‘Wadà oyowi to Diyus to Imananan du-on to ugpa-anan to nangkamatoy. Wadà tuguti to Diyus to ogkadunut to lawa to Imananan.’ ");
INSERT INTO did_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","33","“Na, todu-on no otow no si Jesus no pigbuhoy on to Diyus no Amoy aw tuusa aw kandin no nigdumduma kandin, ogpakamatu-ud sikan. Pigbayow on si Jesus diyà to langit aw pa-ingkuda kandin diyà dapit to kalintu-u to Diyus. Dinawat ni Jesus to Ispiritu Santu no imbogoy to Diyus no Amoy no natuman to impanahad din natodu-on. Na si Jesus, pigpama-abutan din to Ispiritu Santu diyà to sinakupan din no nasakpanan ta pad lagboy ganina. ");
INSERT INTO did_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Si David, wadà nasulat din bahin to kandin pagkabayow diyà to langit dì bahin nasì to duma. Nasulat din no pig-iling to ‘Diyus no Magbobo-ot ku, pig-ikagihan din kan otow no Magbobo-ot ku gayod no pig-iling to, Ogpaso-ingon ku ikow kani to kalintu-u ku ");
INSERT INTO did_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","hantod to ogpakababawon ku ikow du-on to mgo kablang nu aw igpada-og ku ikow tibò kandan.’” ");
INSERT INTO did_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Na nig-aboy si Pedro nig-ikagi to “Na mgo kasu-unan ku no kasinugpu-an ni Israel, ogtagahon ku iyu to pighinang na-an si Jesus to Diyus no Magbobo-ot aw Imananan to Ka-otawan. Dì iyu, pigpadodopa now on nasì kandin diyà to kinurus.” ");
INSERT INTO did_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Na pagkadinog dan to pig-ikagi ni Pedro, lagboy on to pagkapook-pook dan. Namaka-ikagi to kahan-ingan diyà ki Pedro to “Amonu koy on man buwa su-un kunto-on.” ");
INSERT INTO did_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Nig-ikagi si Pedro, “Na, to madoyow no oghimuhon now to ogsosoo kow tibò to hinang now no mado-ot aw oyowi now aw pabonyag kow on to wohig no igmatu-ud now to pagpasakup now to ngadan ni Jesus no Imananan to Ka-otawan awos mapasaylu dà to saà now aw soodi kow pad to Ispiritu Santu. ");
INSERT INTO did_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Iyu man to pigsahadan to Diyus to ogsoodan kow to Ispiritu Santu aw mgo kasinugpu-an now no mgo tipahudi, aw mgo otow diyà to kadiyu-an asta kan tibò no ogpatu-uhon to Diyus no Magbobo-ot ta.” ");
INSERT INTO did_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Na nig-aboy si Pedro to pagpangudlin din aw iling kandin to “Na mgo kasu-unan ku, ogdilinan now to kastigu no og-abut du-on to mgo kadongan ta no mado-ot to hinang.” ");
INSERT INTO did_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Na sikan mgo otow no nigtu-u to udlin ni Pedro, nigpabonyag to wohig. To nigtampu to sinakupan ni Jesus kandà no adow, mgo tatou no maan no ka-otow. ");
INSERT INTO did_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Kanunoy kandan ogtatampu aw pama-anad kandan to mgo tumutubus ni Jesus, aw ampù kandan to Diyus, aw ogsasau-sau kandan no indodomdomay dan to pagpakimatoy ni Jesus kandan. ");
INSERT INTO did_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Na pigpang-abut to ka-otawan to mgo kaboong-boong aw mahan-ing no kaboonganan to impahimu to mgo tumutubus ni Jesus. ");
INSERT INTO did_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Sikan mgo sakup ni Jesus, kanunoy nig-a-agpot aw kandà gayod no tingub dan. ");
INSERT INTO did_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ko moydu-on ogkangkawada-an to kapookanan, igpamabaligyà dan to pasak aw tingub dan aw ipamogoy diyà to kadumahan dan no nawada-an. ");
INSERT INTO did_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Kada adow oghihimun kandan diyà to simbahan no labow aw sasau-sau kandan diyà to mgo kabaoy-baayan. Namantukhow aw pasalamat kandan. ");
INSERT INTO did_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Pigsayà-sayà dan kanunoy to Diyus aw kangkatahud to mgo ka-otawan diyà kandan no mgo kasakupan ni Jesus aw adow-adow pigdugangan to Diyus to sinakupan din to mgo otow no nigtu-u aw ogpadilinan din to kado-otan no kastiguhanan to otow no makasasaà. ");
INSERT INTO did_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Na songo adow namang-andiyà si Pedro aw si Juan to simbahan no labow to mgo alas tris no a-ampu-ay to Diyus. ");
INSERT INTO did_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Pagdatong dan diyà to soodanan no pighingadanan to Dayan-dayan no Soodanan, iyan nakita-an dan to otow no pungkù no likat to pagkabatà din. Adow-adow, oglinahungon kan pungkù aw ibotang du-on to dani to soodanan awos ogtagad to mgo magsisimbahay aw palimus du-on. ");
INSERT INTO did_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","To pagkakita din ki Pedro aw ki Juan no ogsood on, pig-ikagihan din kandan no ogpalimus. ");
INSERT INTO did_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Nignongnong kandan aw ikagi si Pedro to “Lagi, ahà ka dini kanami.” ");
INSERT INTO did_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Dayun nig-ahà kan pungkù no nig-iman to ogbogayan kandin to limus. ");
INSERT INTO did_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Dì nig-ikagi si Pedro to “Wadà sapì ku. Dì moydu-on igbogoy ku ikow no subla pad. Ogsugu-an ku ikow to kabogbogan to ngadan ni Jesu-Kristu no taga-Nasarit to hipanow kad on.” ");
INSERT INTO did_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pigtagon ni Pedro to boad to pungkù aw tanaya din awos makasakindog to pungkù. Dayun na-uli-an to pungkù aw makasakindog kandin no madoson on to kobong aw makahihipanow. ");
INSERT INTO did_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Niglangkotow kandin no ogpakasakindog dà aw makahipanow aw pagluyud on kandin kandan aw ki Pedro no namansood to simbahan no nakahipanow on to pungkù no niglinangkotow on no nigsayà-sayà to Diyus ");
INSERT INTO did_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","no to ka-otawan, nakakita on kandin no nighihipanow no nigsayà-sayà to Diyus. ");
INSERT INTO did_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Pagkakilaa to ka-otawan to sikan na-an to nigpalimus no og-iningkud diyà to Dayan-dayan no Soodanan to labow no simbahan, naboong-boong lagboy kandan sikan tigka-un napugut. ");
INSERT INTO did_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Na no nanggawid kandin ki Pedro aw ki Juan, namakadagap on to kahan-ingan diyà to Kahimunanan ni Solomon. ");
INSERT INTO did_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pagkita ni Pedro to kahan-ingan no lagboy on to pagkaboong-boong, nig-ikagi kandin to “Na mgo kasu-unan ku no kasinugpu-an ni Israel, nokoy man to ingkaboong-boong now aw nongnongi koy now. Dow pagdomdom now buwa dow kanami no kabogbogan aw katuwadongan to naka-ulì to pagkapungkù din? ");
INSERT INTO did_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Dì to nakadoyow, kabogbogan to ngadan ni Jesus su insalig noy man kandin no Anak to Diyus ta no ampu-onon gayod to ka-aw-apu-an ta no si Abraham, aw si Isaac, aw si Jacob. Kandin no si Jesus, pigpakalabow to Diyus. Dì iyu, inhatod now diyà to taga-Ruma natodu-on. Wadà now uyuni kandin. Agad ogsabukan on podon ni Pilato, ");
INSERT INTO did_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","dì wadà now uyuni kandin no matuwadong no otow no ampan saà. Pigsupak now kandin aw pasabuki now nasì ki Pilato kan maghihimatoy no otow. ");
INSERT INTO did_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Si Jesus man to piglikatan to kinabuhì. Dì pighimatayan now on man nasì. Dì pigbuhoy dà kandin to Diyus no kanami, ogpakamatu-ud koy iyan. ");
INSERT INTO did_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Aw to kabogbogan to ngadan ni Jesus no pigsaligan noy, sikan iyan to nakadoyow so-idi no otow no nakita-an now aw kilaha now. To pagsalig to kandin ngadan, sikan to naka-ulì to pungkù agad-agad to nakita-an now.” ");
INSERT INTO did_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Na nig-ikagi mandà si Pedro to “Na mgo kasu-unan ku, nama-anan ku to iyu aw mgo punu-an now, pigpahimatayan now si Jesus su wadà now kama-ani dow intawa lagboy kandin. ");
INSERT INTO did_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Dì natuman on iyan to impatag-an to Diyus to mgo lagsoban din no maglilikwaday natodu-on no ogmuwahon dà to otow no pighimu din no Imananan to Ka-otawan. ");
INSERT INTO did_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Na mgo kasu-unan ku, ogsosoo kow on to hinang now no mado-ot aw oyowi aw pasakup kow to Diyus awos pasayluhon to saà now aw abuton kow to adow no igtukhow no likat to Diyus. ");
INSERT INTO did_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ogpa-andinihon din gayod to Imananan to Ka-otawan no si Jesus no tahan din on pigbo-otan no iyan no innangon on iyu natodu-on. ");
INSERT INTO did_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ogpaka-ugpà pad kandin diyà to langit hantod to og-uliman to Diyus to pasak no impannangon to mgo maglilikwaday to Diyus natodu-on. ");
INSERT INTO did_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Nig-ikagi si Moises no maglilikwaday no pig-iling to ‘To mahudi no adow, Diyus no Magbobo-ot, ogpalogwa-on din dini iyu to otow no maglilikwaday gayod to kagi din no angod dà kanak no su-un now no sugpù gayod ni Israel. Agad nokoy no ignangon din iyu, paminogi now. ");
INSERT INTO did_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Agad intawa no konà ogpaminog, oggawangon du-on to mgo sinakupan to Diyus.’ ");
INSERT INTO did_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Sikan paglogwà on kunto-on to Imananan to Ka-otawan, iyan impatag-an natodu-on to tibò no mgo lagsoban no maglilikwaday, likat ki Samuel aw duma no maglilikwaday no nigsunù kandin. ");
INSERT INTO did_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","“Na itanow, kasinugpu-an kinow man tibò sikan mgo maglilikwaday aw ogkadawat tanow to kabilin no imbogoy to Diyus no mgo ingkasahad din diyà to ka-aw-apu-an ta. Nig-ikagi to Diyus diyà ki Abraham to ‘Oghinangon ku no mgo sugpù nu no oglikatan to panalangin diyà to mgo timamanwa tibò dini to babow to kalibutan.’ ");
INSERT INTO did_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Natuman on man su pigbuhoy on to Diyus to Anak din. Tugdow pigpa-andinihan kid awos makadawat ki to panalangin su pigpa-oyowan on ita to mangkado-ot no hinang.” ");
INSERT INTO did_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Na, ta-un to nigpag-atubang pad kandan aw si Pedro to ka-otawan, pigduguk kandan to mata-as to guwardya to simbahan no labow aw mgo punu-an to tinu-uhan aw mgo Sadusiyu no konà ogtu-u to ogbuhayon to Diyus to mgo nangkamatoy. ");
INSERT INTO did_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Wadà dan kaliyagi to si Pedro aw si Juan ogpang-anad to ka-otawan to si Jesus, pigbuhoy on to Diyus. ");
INSERT INTO did_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Dayun impadakop dan kan daduwa no tumutubus ni Jesus aw ipapirisu dan to wadà pad ka-usip-usip su mahapun on. Kaling man pigbuguk dan du-on to pirisuhan hantod to sunù no adow. ");
INSERT INTO did_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Mangkuwan mahan-ing to nigtu-u no pagkadinog dan to impang-anad ni Pedro aw ni Juan aw pasakup kandan ki Jesus. Aw to kahan-ing to mgo sakup ni Jesus, nigsapat to mgo lima no maan no lukos puli, aw moy pad wadà ka-aput kabilang. ");
INSERT INTO did_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Na to sunù no adow nighihimun diyà to Hirusalim kan punu-an to tinu-uhan to mgo Hudiyu aw mgo mangkanigo-on aw mgo mag-a-anad to tinu-uhan. ");
INSERT INTO did_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Nighihimun gayod si Anas no mata-as to punu-an to tinu-uhan aw si Kaipas, si Juan, aw si Alejandro aw mgo su-un to mata-as. ");
INSERT INTO did_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pagkahimun dan, pigpa-atubang dan si Pedro aw si Juan. Nigsigi nig-usip to punu-an to “Intawa lagboy no ngadan to piggamit now to pagka-uli-i to pungkù. Ando-i makalikat to kabogbogan now.” ");
INSERT INTO did_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Du-on kan no uras, natogob si Pedro to Ispiritu Santu no pagtabak din. To kagi-kagi din na-alladan to Ispiritu Santu. Kagi ni Pedro to “Na talahudon no mgo punu-an aw mgo manigo-on, ");
INSERT INTO did_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ko ogpangintagahan now lagboy bahin to pagka-uli-i to pungkù aw bahin to pagka-amonu to ingka-uli-i din, ");
INSERT INTO did_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ogkamatu-ud ku diyà iyu aw duma no kasinugpu-an ni Israel dow ando-i to piglikatan sikan no kabogbogan. To naka-ulì kandin, kabogbogan to ngadan ni Jesu-Kristu no taga-Nasarit no otow todu-on pigpadodopa now diyà to kinurus dì pigbuhoy dà to Diyus. ");
INSERT INTO did_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Na kandin to napa-atubangan to kagi no nasulat no pig-iling to ‘To batu no pa-ukdangan podon to baoy, agad intimbag on to maghihimu to baoy, dì iyan on pighimu nasì to Diyus no sinaligan no pa-ukdangan.’ ");
INSERT INTO did_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Si Jesus dà to ogpakalipwas ita to kastigu to saà su wadà duma no ngadan no na-uyunan to Diyus dini to babow to kalibutan no ogpa-ampu-an tibò itanow to Diyus awos kinow malipwasan.” ");
INSERT INTO did_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Na, pig-indanan to mgo punu-an to wadà kahadok si Pedro aw si Juan to pagtabak dan agad ampan gradu aw puli iyan otow kandan. Naboong-boong to mgo punu-an aw kakilahi dan to diyà ki Jesus maka-anad kan daduwa su nakadumduma man kandan. ");
INSERT INTO did_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Na-ompongan to mgo punu-an su kapayagid on sikan no kaboonganan su sikan pungku, na-uli-an on no nigsakindog on du-on kandan. ");
INSERT INTO did_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Pigpalabas dan kan tatou no ka-otow awos sumusukun kandan dow amonuhon dan to pagpadoog to napikiyan dan. Pagkalabas dan, ");
INSERT INTO did_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","nigka-inusipay to mgo punu-an to “Amonuhon ta man buwa so-idi su natagahan dà man to mgo taga-lunsud kani to Hirusalim to impahinang kandan to Diyus sikan no kaboonganan no mabogbog aw konà ta gayod igkalidung. ");
INSERT INTO did_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Oghinadokon tad nasì kandan to kona no ogpakatangkapon dan sikan no tinu-uhan ki Jesus.” ");
INSERT INTO did_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Dayun pigpapa-ulì to mgo tumutubus ni Jesus aw sagwaa awos mahadok to ogpang-anad to tinu-uhan bahin to ngadan ni Jesus. ");
INSERT INTO did_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Dì iyan dà pig-ikagi kan daduwa to “Nokoy to iyu no domdom. Dow igpatuman kanami to Diyus to kasugu-an din dow kasugu-an now no otow puli. ");
INSERT INTO did_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Konà noy ogkatigkoan to og-ikagi to nakita-an noy on aw nadinogan noy.” ");
INSERT INTO did_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Lagboy pigpakasapadan dan to mgo punu-an aw kayan sabuki kandan su wadà man saà no ogkahibatan dan su ogkahadok to punu-an ko masamuk to kahan-ingan su pigsayà-sayà dan to Diyus no nakadoyow to pungkù. ");
INSERT INTO did_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","To dugang no nakabantug lagboy sikan no kaboonganan su likat to pagkabatà din no subla on to kap-atan no tu-ig to pagkapungkù din. ");
INSERT INTO did_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Na no masabukan on kandan aw si Pedro aw si Juan, namang-ulì kandan diyà to duma dan aw nangoni dan to tibò no ing-ikagi to mgo punu-an to tahan dan no tinu-uhan. ");
INSERT INTO did_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Pagkadinog dan to insapad lagboy to mgo punu-an, nig-u-uyun kandan to pag-ampù to Diyus no nig-iling kandan to “Magbobo-ot noy no Tagginihit to pasak, to langit, aw to dagat, aw agad nokoy pad no naluwan du-on, ");
INSERT INTO did_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","impabayà to Ispiritu Santu, tahan impa-ikagi nu ki David no sugu-onon nu no puna noy bahin ki Jesus no Imananan to Ka-otawan no pig-iling to ‘Nokoy man no ingkalangoti to mgo otow dini to babow to kalibutan no wadà tahud to Diyus. Nokoy man no pigpakapikiyan gayod to mgo Isrili no wadà puus ");
INSERT INTO did_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","aw nokoy man no nakapandigon-digon podon to mgo harì aw mgo panguu dini to babow to kalibutan aw pag-atu diyà to Diyus no Magbo-ot aw otow no pighimu din no Imananan to Ka-otawan.’ ");
INSERT INTO did_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Dì natuman on iyan kunto-on kani to Hirusalim su si Jesus no Anak nu no pighimu nu no Imananan to Ka-otawan, napikiyan dan on to mado-ot aw nahihimun-himunan on su si Harì Hirudis aw kandan si Gubirnadur Poncio Pilato asta pad mgo punu-an noy no mgo Hudiyu, nahihimunan on no ogkablangon dan ");
INSERT INTO did_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","awos matuman dan dà to ikow no pagbo-ot no impatag-an nu natodu-on. ");
INSERT INTO did_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Na Magbobo-ot, indani nu man kunto-on to paghinadok dan kanami. Bogayi koy nu no sakup nu to kabogbogan su awos konà koy mahadok to ogpanlituk-lituk to ikow no kagi. ");
INSERT INTO did_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Pangbuungi nu to mgo mangkasakiton aw pahinanga koy to kaboonganan no iyan oggamiton noy to ngadan ni Jesus no Anak nu no matuwadong.” ");
INSERT INTO did_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Pagkatapus to pag-ampù dan to Diyus, nigday-og to bao y. Natogob lagboy kandan to kabogbogan to Ispiritu Santu aw ampan gayod mgo hadok to paglikwad to kagi to Diyus. ");
INSERT INTO did_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Na, sobu-ukon dà to pikii to sinakupan ni Jesus aw to ginhawa dan. Wadà agad sobu-uk kandan no ogpaka-abin no ogpaka-iling to “Kanak so-idi.” Dì kandà no tingub dan tibò. ");
INSERT INTO did_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","To mgo tumutubus ni Jesus, kanunoy dan impasabut bahin to pagbuhoy to Magbobo-ot dan no si Jesus su pigbogayan kandan to kabogbogan no likat to Ispiritu Santu. Pigpanalanginan kandan tibò to Diyus. ");
INSERT INTO did_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Wadà mgo sakup ni Jesus no nawada-an to kapookanan su to moydu-on pasak aw baoy, igpambaligyà aw ihatod to sapì ");
INSERT INTO did_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","diyà to tumutubus ni Jesus, aw bogayi dan to nangkawada-an to kapookanan agad-agad to man-u to nawadà du-on kandan. ");
INSERT INTO did_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ko pananglitan, moydu-on sakup ni Jesus no taga-Sipri no sugpù ni Lebi no iyan ngadan din si Jose. Pighingadanan gayod kandin to mgo tumutubus ki Bernabe no iyan nalitukan to Magpapadaoyag. ");
INSERT INTO did_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Nigbaligyà si Bernabe to pasak din aw kan sapì, ihatod din diyà to mgo tumutubus ni Jesus. ");
INSERT INTO did_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Na si Ananias, nakaba-ot to mgo sinakupan ni Jesus no to asawa din, si Sapira. Moydu-on pasak din no imbaligyà din gayod. ");
INSERT INTO did_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Inghatod din gayod to sapì diyà to tumutubus ni Jesus dì monang inghatod no pigsalinan dan pad agad-agad to na-uyunan dan no mag-asawa. ");
INSERT INTO did_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Dì pig-ikagihan ni Pedro to “Nokoy man no nigpasakup ka ki Satanas awos ka makaginaù diyà to Ispiritu Santu. Su pigsalinan nu dà man to sapì. ");
INSERT INTO did_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ikow man no pasak. Ikow man kan no sapì. Wadà nigpogos ikow to ogpahatodon ka to sapì. Ikow man to nigbobo-ot. Dì kunon kun man imbogoy nu kanami intibò to sapì no nadawat nud. Nokoy man no pig-angod nu man sikan no mado-ot man sikan. Kanami dà podon to pigginau-an nu. Dì labow pad nakaginaù kad diyà to atubangan to Diyus.” ");
INSERT INTO did_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","No malituk on to pig-ikagi ni Pedro aw kadinog on ni Ananias, dayun napood kandin aw kamatoy. Tibò no nakadinog, pig-abut to kahadok. ");
INSERT INTO did_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Dayun pig-andu-onan to mgo batan-on pad aw tapida aw lukuti dan to hikam aw dadaaha dan awos ikalobong. ");
INSERT INTO did_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Na wadà dà kaugoy nigdatong si Sapira no asawa din. Dì wadà pad kataga dow nokoy to nadoogan to bana din. ");
INSERT INTO did_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pig-ikagihan ni Pedro to “Sapira, moydu-on ig-usip ku ikow. Ton no sapì now tibò no boli to pasak now, dow imbogoy now intibò dini kanami?” Nigtabak si Sapira to “Ho-o, intibò noy man.” ");
INSERT INTO did_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Nig-ikagi si Pedro to “Nokoy man no nigsasabut kow to ogpanogkadan now to Ispiritu Santu. Todu-on mgo otow no ogpamanponhik kunto-on no nadinog nu, naman-ulì on dini no likat on no niglobong to bana nu, aw ikow on mandà to igsunù dan igkalobong mandà.” ");
INSERT INTO did_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Dayun napood si Sapira du-on to atubangan ni Pedro aw kamatoy. Dayun namansood kan mgo batan-on pad no namanlobong to bana din aw kita-a dan to namatoy on si Sapira gayod. Pigdaa dan pig-usab awos ikalobong no indani dan dà du-on to piglobongan to bana din. ");
INSERT INTO did_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Lagboy to pagkangkahadok to mgo sinakupan ni Jesus aw duma no mgo otow no kan nakadinog to nadoog-doogan kan no mag-asawa. ");
INSERT INTO did_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Na pighimu to mgo tumutubus ni Jesus no kaboonganan lagboy. Tahan dan no mgo sinakupan ni Jesus oghihimun diyà to Kahimunanan ni Solomon no nasakup gayod to simbahan no labow. ");
INSERT INTO did_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Dì duma no mgo otow no konà no sakup ni Jesus, wadà oglangub to puli ogpagtampu, agad tibò dan igtahud to mgo sakup ni Jesus. ");
INSERT INTO did_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Kanunoy moydu-on nigpasakup to Diyus no lukos aw buyag hantod to nighan-ing to mgo sinakupan ni Jesus. ");
INSERT INTO did_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Mabantug to nangkahinang to mgo tumutubus ni Jesus. Kaling pigpandaa to mgo masakiton du-on aw pamahibata kandan du-on to kilid to igbayà ni Pedro su awos ubag malambungan kandan ni Pedro ko bumayà. ");
INSERT INTO did_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Pagka-agpot to mgo tumutubus diyà to Hirusalim, agad ando-i nandà no pigmutmutan no mgo kalunsudan to mgo otow no namansindaa to mgo nangkasakit aw to pigpansoodan to busow. Tibò to nangkadaa, nangka-uli-an. ");
INSERT INTO did_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Dì kandan si Anas no mata-as lagboy to mgo punu-an to tinu-uhan aw duma no sakup to panon to Sadusiyu, pigsombang dan kan mgo tumutubus ni Jesus ");
INSERT INTO did_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","aw impadakop dan kandan aw pirisuha. ");
INSERT INTO did_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Dì pagkasaklop, piglogwà kan tumutubus ni Jesus to diwata likat to Diyus aw ablihi din to takop to pirisuhan aw palabasa din kandan aw ikagihi din to ");
INSERT INTO did_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Andiyà kow on to labow no simbahan aw ilikwad now to ka-otawan to tibò to bayà no tinu-uhan bahin to pagpambuhoy to nangkamatoy.” ");
INSERT INTO did_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Pagkabukas, nigtuman on kandan aw andiya-i to labow no simbahan aw pang-anad to ka-otawan. Na kandan aw si Anas no mata-as to mgo punu-an to tinu-uhan to mgo Hudiyu, nighihimun aw patawagi to duma no mgo punu-an tibò aw kahimun kandan. Pagkahimun dan on tibò, impapudut dan podon kan mgo tumutubus ni Jesus to mgo guwardya dan awos pa-atubangon dan on podon kandan. ");
INSERT INTO did_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Dì pagdatong to mgo guwardya diyà to pirisuhan, wadad on to mgo tumutubus ni Jesus. Dayun nigpa-ulì to mgo guwardya aw nangoni dan to mgo punu-an to ");
INSERT INTO did_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Pag-abut noy Sir diyà to pirisuhan, wadad on man. Matuu natakopan dà man aw madigon. Pigbantayan dà man to guwardya gayod. Dì to pag-abli noy, wadad on man kan no mgo otow.” ");
INSERT INTO did_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Pagkadinog dan to nawnangonon to guwardya, napook-pook lagboy to mgo punu-an to tinu-uhan aw kan mata-as to guwardya to simbahan no labow su naboong-boongan dan aw kahadoki dow nokoy to ogkadoogan buwa sikan bayà no tinu-uhan. ");
INSERT INTO did_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Na songo otow nigsood no nignawnangonon to “Sir, ahà kow, sikan mgo otow no impapirisu now, du-on on kunto-on nigpang-anad on kandan to mgo ka-otawan du-on to simbahan.” ");
INSERT INTO did_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Dayun pigpudut to mgo guwardya dì wadà bidla-a kandan su makadilin to guwardya ko dogpakon kandan to batu to mgo ka-otawan. ");
INSERT INTO did_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Pagpudut to mgo guwardya to mgo tumutubus ni Jesus, pigpa-atubang dan diyà to mgo punu-an to tinu-uhan. Dayun pigpangusip-usip kandan to mata-as ");
INSERT INTO did_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","no nig-iling to “Pigsapadan noy man iyu to konà kow on ogpang-anad no iyu ogtubusan now to ngadan kan no otow. Dì wadà kow man kasapadi su kanunoy now on igpang-anad diyà to tibò no taga-Hirusalim. Igpa-abin now podon nasì kanami to kanami to nalikatan to pagkamatoy sikan no otow.” ");
INSERT INTO did_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Dì si Pedro aw duma no tumutubus, namakatabak to “Ogtumanon noy to sugù to Diyus, konà no otow. ");
INSERT INTO did_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Diyus no ampu-onon to ka-aw-apu-an ta, pigbuhoy din dà si Jesus no pighimatayan now aw pigpadodopa now diyà to kinurus. Pigbuhoy si Jesus to Diyus ");
INSERT INTO did_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","aw pakalabawa din aw paso-inga din diyà dapit to kalintu-u din no diyad on to langit. Pighimu din si Jesus no Magbobo-ot aw Maglilipwasay su agun ogpa-oyowan din ita no kasinugpu-an ni Israel to hinang no mangkado-ot aw kapasaylu ki din dà to saà ta. ");
INSERT INTO did_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Sikan tibò bahin to katondanan ni Jesus, pigmatu-ud noy tibò aw Ispiritu Santu no imbogoy to Diyus diyà to mgo otow tibò no ogtuman to sugù din.” ");
INSERT INTO did_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Pagkadinog to mgo punu-an sikan panabakan ni Pedro, lagboy on to pagkalangot dan podon. Kaliyagan dan on podon to oghimatayan dan kandan. ");
INSERT INTO did_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Dì nigsakindog to songo dumala no mag-a-anad to tinu-uhan dan no sakup to Parisiyu no panon. Iyan ngadan din si Gamaliel no tinahud to tibò to mgo ka-otawan. Pigpamalabas din kandan aw si Pedro. ");
INSERT INTO did_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Pagkalabas dan, nig-ikagi si Gamaliel to “Mgo kasing-Isrili ku, moydu-on ig-udlin ku iyu. Ogkadowdoyow tato pikii ta to paghimatoy bahin sikan daduwa no ka-otow. ");
INSERT INTO did_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ko pananglitan ogdomdomon ta to nadoogan ni Tiyudas no bayà-bayà pad nigpalabow-labow on to kandin kabogbogan. Nakasakup on kandin to pag-atom-atom ku to upat no gatus no ka-otow. Dì mangkuwan namuwa dà man kandin aw puli on mamakasusuwoy-suwoy to kandin sakup. Wadad nadoogan to sinakupan din. ");
INSERT INTO did_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Pagsunù si Judas no taga-Galiliya, natodu-on no pagpunù to pagsakup to taga-Ruma no impanlista to mgo ka-otawan, nig-atu kandin aw makasakup to mahan-ing. Dì namuwa dà gayod si Judas aw mamakasusuwoy-suwoy dà gayod to sinakupan din. ");
INSERT INTO did_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Bali no niglogwà on si Jesus no mahan-ing to kandin sakup. Namuwa dà gayod si Jesus. Na mgo kasing-dumala ku, konà ki oghilabot to kandan hinang-hinang aw kandan ogkadomdoman. Ko wadà likat to Diyus to kandan pikii aw sikan mgo hinang dan, wadà man ogkadoogan dan aw ogpamakasusuwoy-suwoy dà man kandan. ");
INSERT INTO did_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Dì ko likat to Diyus, konà man ogkada-og. Kaling man konà ki oghilabot su dagow ogpakabalatak ki puli to pagbo-ot to Diyus.” ");
INSERT INTO did_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Pagdinog dan to kagi ni Gamaliel, pig-uyunan dan. Pina-ulì dan kan daduwa no ka-otow aw bunai dan. Dayun pigbahog dan to “Konà kow on og-usab ogpang-anad no tumutubus to ngadan ni Jesus.” Na niglogwà on kandan. ");
INSERT INTO did_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Nigtukhow on kandan su napilì kandan to Diyus no nalisodan kandan su nigtubus man kandan ki Jesus. ");
INSERT INTO did_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Adow-adow diyà kandan to simbahan aw mgo kabaoy-baayan no ogpang-anad aw pasabut to si Jesus to Imananan to Ka-otawan. ");
INSERT INTO did_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Na nighan-ing on to mgo sinakupan ni Jesus no natibò no kandà no tinu-uhan dì nigsingkabugtì to kandan inikagihan aw kandan mgo katahanan. Sikan mgo sakup no Giniriyigu to inikagihan, ogdiyampa-on dan kan mgo sakup no Hinibriyu to inikagihan su ogbugti-on dan kun to kandan mgo bau aw ko oghandug to kapookanan, og-ipihan dan kun to kandan mgo bau to pagbogoy. ");
INSERT INTO did_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Dayun sikan sampuù tag duwa no tumutubus ni Jesus, tibò dan pigpatawagan to sinakupan no tibu-uk agun ikanangon dan to mgo ogkapikiyan dan. Pagkahimun dan, nig-ikagi to mgo tumutubus to “Konà koy no litos ogpakadaa to pagpanghandug to kapookanan. Dì iyan litos noy nasì to ogpanoysoy koy to kagi to Diyus. ");
INSERT INTO did_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Kaling man ogpilì kow to pitu no ka-otow no litos to ogkatahud on to ka-otawan aw dakoo on to nama-anan dan aw gayod nasoodan on to Ispiritu Santu aw kandan on to ogpadaahon now to paghandug to mgo kapookanan. ");
INSERT INTO did_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Dì kanami no sampuù tag duwa, ogpuna-us koy to ogpanoysoy to kagi to Diyus aw pag-ampù.” ");
INSERT INTO did_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Naliyagan lagboy to tibò no nahimun to kalitukan to pig-ikagi to mgo tumutubus ni Jesus. Na pigpilì dan to pitu no ka-otow no si Esteban no nigtu-u lagboy ki Jesus aw kasoodi lagboy to Ispiritu Santu, aw si Felipe, si Prukuru, si Nicanor, si Timun, si Parminas aw si Nikulas no taga-Antiyukiya no kandin dà iyan to konà no Hudiyu dì nigpasakup on tahan kandin to tinu-uhan to mgo Hudiyu. ");
INSERT INTO did_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Pagkapilì dan on, sikan mgo tumutubus pigpangamuyù dan to Diyus to ogpabogayan to panalangin. Pigpandampon dan kan pitu no ka-otow no pigbogayan to kabogbogan to igkatuman to kandan no katondanan. ");
INSERT INTO did_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Na to kagi to Diyus, nigtangkap hantod to nighan-ing on gayod to sinakupan ni Jesus diyà to Hirusalim. Agad mgo mangka-aslag no mgo punu-an to tinu-uhan to mgo Hudiyu, mahan-ing gayod to nigpasakup ki Jesus. ");
INSERT INTO did_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Na si Esteban no natogob gayod to kabogbogan aw panalangin to Diyus, oghinang to kaboonganan no mabogbog diyà to atubangan to ka-otawan. ");
INSERT INTO did_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Na moydu-on panon no pighingadanan to Sinabukan no Udipon no nigsingkabugtì to piglikatan dan no taga-Sirini aw taga-Alejandria aw taga-Silisiya aw taga-Asiya. Pagkadinog dan to nigpangudlin si Esteban, namanpag-asuy kandan ki Esteban. ");
INSERT INTO did_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Dì konà ogkakambawan si Esteban su pigbogayan to Ispiritu Santu to ka-ugsoban aw bogayi to kagi-kagi no igkatabak ni Esteban. ");
INSERT INTO did_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Kaling man nigkumit kandan nigpudut to otow no gau-on no ogpadiklamuhon dan to nadinogan dan to pigpa-inahan ni Esteban. Impa-iling dan to “Nadinog noy to pigpa-inahan ni Esteban to Diyus aw si Moises.” ");
INSERT INTO did_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Na pigsinamuk dan to mgo ka-otawan aw mgo punu-an tibò to tinu-uhan. Pagkadinog to mgo punu-an aw mgo ka-otawan to nig-ina-ina kun si Esteban, pigdasdasan dan aw dakopa aw papa-atubanga kandin to mgo punu-an to tinu-uhan. ");
INSERT INTO did_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Namanpaduma gayod to mgo otow no gau-on no ogpamatu-udon dan bahin to innangon ni Esteban. Nig-iling to gau-on no otow to “Kanunoy ogpa-inahan ni Esteban so-idi simbahan ta no labow aw kasugu-an gayod no likat ki Moises. ");
INSERT INTO did_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nadinog noy gayod to pig-ikagi ni Esteban to oglompagon kun ni Jesus so-idi no simbahan aw ogpang-ilisan kan mgo tinu-uhan no imbogoy ni Moises.” ");
INSERT INTO did_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Pagkatapus to pagnangon to gau-on no otow, nignongnong to mgo punu-an ki Esteban su na-usab to lawlanguhan din no angod to katuusan on. ");
INSERT INTO did_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Na nig-usip ki Esteban kan mata-as to punu-an to tinu-uhan to “Dow og-angkonan nu sikan no indiklamu ikow?” ");
INSERT INTO did_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Nigtabak si Esteban no inho-un din to lawa din no nig-iling to “Na mgo talahudon no punu-an aw mgo kasu-unan ku, paminog kow to kagi ku. Ton apù ta no si Abraham, nig-ugpà diyà to Misuputamiya natodu-on. To wadà pad halin kandin diyà to Haran no banwa, piglogwà kandin to Diyus no Labow no Katuusan. ");
INSERT INTO did_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Pig-ikagihan kandin to Diyus no nig-iling to ‘Ogpatubukon ku ikow to pag-ugpà. Ogpa-oyowan ku ikow to Kaldiya no banwa nu aw mgo kadumahan nu. Ogpahalinon ka diyà to banwa no ighindù ku ikow.’ ");
INSERT INTO did_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Na nighipanow on kandan si Abraham no pigdumahan to amoy din, aw halin diyà to Haran no banwa no pig-ugpa-an din hantod to du-on on kamatoy to amoy din. No pagkamatoy on to amoy din, pigpagawang kandin to Diyus du-on sikan no banwa aw pahalina dini so-idi no banwa no pig-ugpa-an tad on kunto-on. ");
INSERT INTO did_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Dì wadà imbogoy to Diyus no pasak no ogka-abin ni Abraham agad magapaad dà ubag no igkabilin din diyà to mgo kasinugpu-an din. Dì pigsahadan dà to Diyus to ogbogayan iyan to kasinugpu-an din to mahudi no adow. Dì pagsahad to Diyus ki Abraham, wadà pad batà dan hantod to nabuyag on kandin. ");
INSERT INTO did_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Dì maogot ogkatuman to kagi to Diyus su pignangonan din si Abraham no pig-iling to ‘To kasinugpu-an nu, diyà to madiyù no banwa ogkahuwag-onan to pag-ugpà dan. Ko umugpà du-on ogkahimu kandan no udipon aw pang-uwang-uwangi to upat no gatus no tu-ig. ");
INSERT INTO did_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Dì kanak no Diyus to ogkastigu kan mgo og-udipon. Ko matapus on to pagkastigu ku kandan, ogpaman-ulì on to kasinugpu-an nu aw mangkamonang on no pag-ugpà aw og-ampù on kanak.’ ");
INSERT INTO did_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“Na pigbogayan gayod si Abraham to Diyus to tulumanon no pag-indan to lawa no pagpakilaa to sakup din kandan. Kaling man pagpanganak ni Abraham ki Isaac, pigtuman ni Abraham kan no tulumanon no sikan pag-indan to lawa to pag-abut to wau no adow likat to pagka-otow. Nanganak si Isaac ki Jacob, angod dà to pigtuman din no tulumanon no sikan pag-indan to lawa. Nanganak gayod si Jacob, pigtumanan din kan no tulumanon to sampuù tag duwa no batà din no kandan on to piglikatan to sampuù tag duwa no mgo panon ta no mgo Isrili. ");
INSERT INTO did_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Mahan-ing iyan to mgo batà ni Jacob, dì iyan lagboy maogon din si Jose. Dì to mgo kakoy din, pigsombang dan si Jose. Imbaligyà dan si Jose aw kahinang no udipon diyà to banwa to Ihiptu. Dì kanunoy pigtandu-an si Jose to Diyus. ");
INSERT INTO did_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Agad nokoy to kalisod ni Jose, ogbuligan kandin to Diyus. Pagka-atubang din to harì to Ihiptu no si Paraun, pigbogayan si Jose to Diyus to ka-ugsoban aw buligi pad kandin. Kaling pighimu si Jose to harì no nigsunù kandin no panguu to pigsakupan din aw panguu gayod to mgo sood din to baoy. ");
INSERT INTO did_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Na pagkaugoy pigkogsa-an to bontas to Ihiptu no banwa aw so-idi no banwa ta no pighingadanan to Kanan natodu-on. Ampan ogkakita-an no ogkako-on to ka-aw-apu-an ta. ");
INSERT INTO did_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Dì si Jacob no apù ta, nakadinog to moydu-on dà ogkako-on ubag diyà to Ihiptu. Pigpapana-ulì din to anak din no sikan, mgo kakoy ni Jose no ka-aw-apu-an ta aw sikan to tugdow dan no pig-andiya-an no Ihiptu no banwa. ");
INSERT INTO did_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Kayan nigpakilaa si Jose diyà to mgo kakoy din no ikaduwa on no pagpana-ulì dan. Sikan no uras on to pagkama-an ni Harì Paraun dow intawa to piglikatan ni Jose no ginikanan. ");
INSERT INTO did_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Dayun impadokat ni Jose kandan si Jacob no amoy din. Kapitu-an aw lima no ka-otow no nighalin diyà to Ihiptu. ");
INSERT INTO did_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Nig-ugpà kandan si Jacob du-on to Ihiptu hantod to du-on on tibò kangkamatoy. ");
INSERT INTO did_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Dì imbatuk dan dà to paglobong diyà to kandan banwa no pasak no pigboli ni Abraham no apù ta diyà to mgo anak ni Hamur no taga-Sikim. ");
INSERT INTO did_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Dì no madaas on ogkagotò to pagtuman to Diyus to insahad din ki Abraham no ogpapa-uli-on to mgo kasinugpu-an din dini to kandan no banwa, kanunoy nighan-ing lagboy kandan no kasinugpu-an ni Jacob ");
INSERT INTO did_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","aw bugtì on to nigharì no wadà din katagami si Jose. ");
INSERT INTO did_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Nigpanluku kandin to mgo ka-aw-apu-an ta aw panda-og-da-og to ka-aw-apu-an ta su pigpogos din to pagpalabas to baoy to mgo apù ta to batà dan aw palungata aw itimbag diyà to wohig su awos ogkamatoy aw konà oghan-ing to ka-aw-apu-an ta. ");
INSERT INTO did_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Na ton harì pad sikan no otow, na-otow on si Moises no ogka-ayamà nu to kadoyow. Pigtamongan lagboy kandin to inoy din aw ihobong du-on to sood to baoy to sood to tatou no buwan. ");
INSERT INTO did_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Kayan pinalabas din si Moises dì inhobong din dà si Moises diyà to wohig. Dì nakita-an dà si Moises to buyag no anak to harì. Dì pigka-atan nasì to buyag aw angaya din no anak-anak si Moises. Anak to harì to nigbuhì on ki Moises. ");
INSERT INTO did_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Kaling dì pig-anad si Moises to mgo taga-Ihiptu to kandan nama-anan su na-apù on si Moises to harì. Labow man to mgo hinang ni Moises aw ko ogpang-i-ikagi. ");
INSERT INTO did_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Na pag-abut to kap-atan no tu-ig to idad ni Moises, nadomdoman din on to oglo-uy bali to kadumahan din no kasinugpu-an ni Israel awos makabulig kandin diyà kandan. ");
INSERT INTO did_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Na nakita-an din to songo duma din no pig-uwang-uwangan to taga-Ihiptu aw pigbuligan din no pinabayà to paghimatoy din to taga-Ihiptu. ");
INSERT INTO did_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Intobo-ot ni Moises dow dawaton dà kandin to kadumahan din no mgo Isrili aw pasakup su ogpabuligan kandan to Diyus. Dì wadad on man dawata. ");
INSERT INTO did_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Pagkasunù no adow nakita-an ni Moises to daduwa no ka-otow no kadumahan din dà no nigbubuwow. Pighusoy din podon no nig-iling kandin to ‘Mgo su-un ku, paminog kow. Konà kow man ogkinalituhay su nigsusu-un kow dà man aw ando-i kow man to ogsindoog.’ ");
INSERT INTO did_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Dì sikan mado-ot to paghimu du-on to su-un din, intuud din on nasì si Moises aw ikagi to ‘Intawa to nigsugù ikow to kanami, oghusayon koy nu aw ikow to ogbo-ot. ");
INSERT INTO did_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Nama-anan kud on to ikow to nighimatoy ton taga-Ihiptu gabi-i. Og-angodon a nu buwa gayod.’ ");
INSERT INTO did_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Pagkadinog ni Moises to nama-anan dà to kandin to nighimatoy to taga-Ihiptu, niglaguy aw hobong diyà to Midiyan no huwag-on din puli to pag-ugpà din du-on. Du-on on kandin maka-asawa aw makapanganak to daduwa no tumaag lukos. ");
INSERT INTO did_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Na diyà to Midiyan no banwa no kahanongan no katahayan, nigbantoy si Moises to buhì to ugangan din. Pag-abuti to kap-atan on no tu-ig no kandin nigbantoy no madani to Sinai no untud, piglogwà kandin to diwata to Diyus. Nakita-an din to logdog no nigliyab-liyab no nigkupkup du-on to bawbagon no dugihon dì wadà pighalinan. ");
INSERT INTO did_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Naboong-boongan din su wadà man pighalinan to bawbagon. Dayun pigduguk ni Moises su ogpangilahan din dow nokoy sikan. Pagduguk din nadinog din to kagi to Diyus no Magbobo-ot no pig-iling to ");
INSERT INTO did_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Kanak no Diyus to ampu-onon ni Abraham aw ampu-onon ni Isaac aw ampu-onon ni Jacob.’ Pigpidpid si Moises aw kahadok aw wadà maka-ahà kandin. ");
INSERT INTO did_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Pig-ikagihan kandin to Diyus to ‘Gawanga to sapatus nu no intahud nu kanak su talahudan no pasak so-idi su piglogwa-an ikow to Diyus. ");
INSERT INTO did_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Pig-indanan kud on to pagkangkasinogow to mgo sinakupan ku no pigpahadatan diyà to Ihiptu. Nig-andini a su ogbuligan ku. Na ikow Moises, ogpa-andiya-on ku ikow to Ihiptu su ogtubus ka kanak diyà.’ ");
INSERT INTO did_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Natodu-on to mgo kadumahan ni Moises, nigsupak kandan kandin su intobo-ot dan dow nigpalabow-labow si Moises. Namang-ikagi kandan to ‘Intawa to nigsugù ikow to kanami, ogsakupon koy nu aw ikow to ogbo-ot.’ Dì no pagkaugoy, kandà no otow no si Moises, pigpatubus kandin to Diyus diyà to mgo Isrili diyà to Ihiptu no pig-udiponan dan su pighimu to Diyus si Moises no ogsakup to mgo Isrili. Pigpabuligan din gayod ki Moises kandan no impabayà to diwata to Diyus no niglogwà ki Moises diyà ton bawbagon no dugihon. ");
INSERT INTO did_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Bali man pighinang ni Moises to kaboonganan no nig-allad kandin to mgo kasinugpu-an ni Israel likat to Ihiptu aw pagtalipag dan to Dagat no Maogdog aw pagkaligot-ligot dan diyà to kahanongan no banwa no katahayan to sood to kap-atan no tu-ig. ");
INSERT INTO did_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Si Moises iyan to nig-ikagi no pig-iling to ‘To mahudi no adow, Diyus, ogpalogwa-on din dini iyu to otow no maglilikwaday gayod to kagi din no angod dà kanak no su-un now no sugpù gayod ni Israel.’ ");
INSERT INTO did_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Natùtu-u on iyan, su si Moises on to nakalikwad to kagi to diwata diyà to sinakupan to Diyus no mgo kasinugpu-an ni Israel no diyà pad kandan natodu-on to kahanongan no banwa no katahayan. Pigdaa to diwata to kasugu-an to Diyus diyà ki Moises no diyà to Sinai no untud. Si Moises, pigdaa din hognà kan kagi to Diyus diyà to ka-aw-apu-an ta no ogpakadoyow to ka-ugpà ta. ");
INSERT INTO did_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Dì namansupak kandan ki Moises aw pangumanoy kandan nasì to ogpakabatuk dà podon to pag-ugpà dan diyà to Ihiptu no banwa no piggawangan kandan ni Moises no diyad on kandin kalaud diyà to untud no pigdawat din to kasugu-an to Diyus. ");
INSERT INTO did_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Nig-ikagi kandan diyà ki Arun no hadi ni Moises no pagkali-us din on no nig-iling to ‘Indoy ta dow nokoy on buwa to nadoogan ni Moises no nigpagawang ita diyà to Ihiptu no banwa aw ibu-us ki dini to kahanongan no banwa aw katahayan. Na, oghimuhan koy nu to ampu-onon no og-allad ita.’ ");
INSERT INTO did_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Dayun nighungun kandan to kandan ampu-onon no ogpaka-imo-ot to nati to baka. Pighinangan dan kan angod to nati aw hinanga no kalipay no katahudan dan to ampu-onon no pighungunan dan no ing-ilis dan to ampu-onon dan natodu-on. ");
INSERT INTO did_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Dayun pigtalikudan on kandan to Diyus aw wadà babagi kandan to Diyus to pag-ampù to bugtì no ampu-onon no mgo ogpamansilat diyà to langit. Natuman on to nasulat diyà to kasulatan to mgo maglilikwaday to Diyus no pig-iling to, “‘Iyu no kasinugpu-an ni Israel, konà no kanak to pig-ampu-an now sood to kap-atan no tu-ig diyà to katahayan no banwa no pagkalibod-libod now. ");
INSERT INTO did_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Pigdadaa now dà gayod to abutanan to bugtì no ampu-onon now no si Muluk. Pigdadaa now dà gayod to ogpaka-imo-ot to duma no ampu-onon now no si Ripan no puli pighungunan to otow no tagtu-un kun to bitu-on. Pighungunan now puli to iyu no ampu-onon. Kaling oggawangon ku iyu du-on to iyu no banwa aw pahalina kow diyà to kaylu pad to Babiluniya.’ Sikan to impabahog to Diyus to maglilikwaday din. ");
INSERT INTO did_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Na to ka-aw-apu-an tanow, no namakalibod-libod diyà to kahanongan no katahayan no banwa, namandawdaa kandan to abutanan to Diyus no igkamatu-ud dan to Diyus, nigduma-duma sanglitanan to Diyus no pigpa-aha-an din. ");
INSERT INTO did_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Kandan si Jusue no tipahudi on no pagpanutuu dan to banwa dan, nigdawdaa gayod kandan to abutanan to Diyus no kabilin to ka-aw-apu-an dan du-on kandan. Inogà on kandan to pag-ugsud-ugsud kandan pag-ugpà no inabut dan on to banwa no insahad to Diyus to ogpa-ugpa-an kandan aw inut-inuta gayod to impapigis to Diyus kan tahan naka-ugpà du-on kan no pasak no insahad to Diyus tahan to igbogoy du-on to kandan ka-aw-apu-an. Indangon du-on to abutanan to Diyus. Mamonang on du-on hantod to pagkaharì ni David. ");
INSERT INTO did_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","“Na nalogonan si David to Diyus, aw si David, pigba-id din dow matugutan kandin to ogpadangonon to Diyus to abutanan din no simbahan no labow su ampu-onon man to kasinugpu-an ni Jacob no pighingadanan gayod ki Israel. ");
INSERT INTO did_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Dì wadà tuguti to Diyus dì si Solomon no anak ni David to pigtugutan to ogpadangonon to abutanan to Diyus no labow no simbahan. ");
INSERT INTO did_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Dì to oghimuhon puli to otow, konà ogkalitos to Diyus no Labow no Katuusan. Tùtu-u to impa-ikagi to maglilikwaday to Diyus no pig-iling to ");
INSERT INTO did_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Langit to ingkudanan ku aw pasak to gi-okanan ku. Nig-ikagi gayod to Magbobo-ot no pig-iling to, Amonuhon now buwa to paghimu to baoy no ogkalitos a ");
INSERT INTO did_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","su kanak man to nighimu to langit aw pasak tibò.’ Sikan to pig-ikagi to Diyus no inhognà din pad impa-ikagi to maglilikwaday din no lagsoban natodu-on. ");
INSERT INTO did_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Na iyu no mgo otow, tu-un now iyan kan no domdom aw ginhawa no wadà ogka-usaban. Nigsupu kow man to ka-aw-apu-an ta su kanunoy kow nigsupak to Ispiritu Santu. ");
INSERT INTO did_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Tibò to maglilikwaday to Diyus, pigpalisodan to ka-aw-apu-an ta. Pigpanghimatayan dan to mgo maglilikwaday no nigtag-an to oglogwà to matuwadong no otow no Imananan to Ka-otawan. Dì imbaligyà now kan no otow no si Jesus aw pahimatayi, ");
INSERT INTO did_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","agad iyu to nigdawat to kasugu-an to Diyus no pigdaa to diwata din dì wadà now tumana.” ");
INSERT INTO did_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Na pagdinog to mgo punu-an to kagi ni Esteban, konad no langot dan aw puli nangagotkot to mgo bag-ang no ta-indanan to langot dan ki Esteban. ");
INSERT INTO did_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Dì songo nasoodan lagboy si Esteban to Ispiritu Santu aw langhag diyà to langit. Paglanghag ni Esteban diyà to langit, nignongnong kandin to bandog to Diyus no nig-andidiyow aw kakita-i din si Jesus no nig-ilug diyà dapit to kalintu-u to Diyus. ");
INSERT INTO did_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Kagi ni Esteban, “Ahà kow on man. Natau-angan on to langit. Suyà dà si Jesus no Imananan to Ka-otawan no nig-ilug diyà dapit to kalintu-u to Diyus no Amoy.” ");
INSERT INTO did_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Dayun to nigsingka-iyak kan mgo punu-an aw asigkasampong to talinga. Pigbokasan dan si Esteban ");
INSERT INTO did_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","aw guyuda dan kandin diyà to labas to lunsud dan aw dodogpaka dan to batu. Sikan mgo namandogpak, imbilin dan to kabò dan diyà ki Saulo no batan-on pad no duma dan. ");
INSERT INTO did_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Dì no pigdogpak dan si Esteban to batu, nig-ampù nasì kandin no nig-iling to “Jesus no Magbobo-ot, dawata nu to umagad ku.” ");
INSERT INTO did_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Dayun nakaluhud kandin aw maka-ikagi to ma-agbot, “Magbobo-ot, konà nu oghimuhon no saà dan no ogkahibatan dan.” Dayun namatoy on si Esteban. Na si Saulo, naka-uyun dà to kamatayon ni Esteban no nigbantoy su pigkablang din to bayà no tinu-uhan bahin ki Jesus. ");
INSERT INTO did_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Dì inlobong si Esteban to mgo otow no matino-od. Pig-oog dan lagboy si Esteban. Sikan no adow to piglikatan to pagkangkalisodi to mgo sakup ni Jesus su lagboy on pigpahadatan kandan to mgo kablang dan. To mgo tumutubus ni Jesus, namanpakamonang dà diyà to Hirusalim. Dì to duma no mgo sinakupan, nahilatagplatag diyà to prubinsiya to Hudiya aw prubinsiya to Samariya. ");
INSERT INTO did_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Na si Saulo, ogdodo-oton din podon to sinakupan ni Jesus aw pang-andiya-i din to kabaoy-baayan aw pangguyuda to mgo sinakupan ni Jesus, lukos dow buyag. Dayun impantagù to pirisuhan. ");
INSERT INTO did_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Na to mgo sinakupan ni Jesus no pagkahilatag-latag dan, namanlogob-logob kandan to nigsingkabugtì no banwa no nigpang-anad to kagi to Diyus. ");
INSERT INTO did_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Si Felipe no sakup ni Jesus, nig-andiyà to kamatu-udan no lunsud diyà to prubinsiya to Samariya aw panoysoy to si Jesus to Imananan to Ka-otawan. ");
INSERT INTO did_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","To mgo taga-Samariya, nigtibò kandan to pagpaminog to impang-anad ni Felipe su nakita-an dan to kaboonganan no pighimu din. ");
INSERT INTO did_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Mahan-ing to pigsoodan to busow no nagawangan ni Felipe aw makapanagoa. Mgo pungkù, mgo pawing, mgo pulid, tibò din na-uli-an to sakit du-on to mgo otow no taga-Samariya. ");
INSERT INTO did_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Nigtukhow tibò kandan. ");
INSERT INTO did_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Dì moydu-on otow no nig-ugpà du-on to Samariya no kunon kun nigpatutuus. Iyan ngadan din si Simon. Naugoy on to pagkaboong-boong to mgo taga-Samariya to kabogbogan din. Nigpalabow kandin aw kunon kun Diyus to piglikatan to kabogbogan din. ");
INSERT INTO did_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","11","Nigpaminog kan mgo taga-Samariya agad mangkabaklà aw mangka-intok su naboong-boongan dan man. Kaling man pighingadanan dan kandin to Kinabogbogan no likat to Diyus, su intobo-ot dan on dow likat to Diyus to kabogbogan ni Simon. ");
INSERT INTO did_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Dì pagkadinog dan to ki Felipe no pagpasabut bahin to pagsakup to Diyus aw ogkahimu ogkasakup ki to Diyus no Amoy ko pumasakup ki to Anak din no si Jesu-Kristu, nigtu-u kandan no lukos aw buyag aw tuman aw pabonyag to wohig no igmatu-ud to pagpasakup dan to ngadan ni Jesus. ");
INSERT INTO did_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Agad si Simon, nigtu-u man aw pabonyag kandin gayod su nigdumduma kandin ki Felipe aw maka-ahà to kaboonganan no pighimu ni Felipe, aw kaboong-boong. ");
INSERT INTO did_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Na, diyà ta pad to bugtì no tutuwanon no diyà to Hirusalim. Nakadinog to mgo tumutubus ni Jesus to sikan mgo taga-Samariya, nigpasakup on kandan to kagi to Diyus. Pagkadinog dan, pigpatubus dan pigpa-andiyà si Pedro aw si Juan ");
INSERT INTO did_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","awos ogpangamuyu-an kandan diyà to Diyus awos soodan kandan no mgo taga-Samariya to Ispiritu Santu ");
INSERT INTO did_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","su wadà pad lagboy kasoodi kandan. Puli pad namanpabonyag to wohig no inmatu-ud to pagpasakup dan to ngadan ni Jesus. ");
INSERT INTO did_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Pagdatong ni Pedro aw ni Juan, pigpandampon dan kandan no mgo taga-Samariya aw pangamuyu-i dan kandan to Diyus to ogpasoodan lagboy kandan to Ispiritu Santu. Dayun pigmatu-udan on to nasoodan kandan lagboy to Ispiritu Santu. ");
INSERT INTO did_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Na si Simon no nigpatutuus, pagkakita din to kandan, nasoodan to Ispiritu Santu no pagdampon to tumutubus ni Jesus, naliyagan din podon. Naka-ikagi kandin to “Nawà dow ogpabayluhan now kanak to sapì ");
INSERT INTO did_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","to kabogbogan now su awos ogkangkasoodan to mgo otow to Ispiritu Santu ko madampon ku.” ");
INSERT INTO did_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Nakatabak si Pedro, “Dowdo-otan ka kay na-an aw sikan ubag sapì nu ko konà nu og-oyowan kan mado-ot no domdom nu su intobo-ot nu dow ogkaboli nu puli to sapì kan igbogoy likat to Diyus. ");
INSERT INTO did_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Konà ka ogpakapanginlabot to igbogoy to Ispiritu Santu to pagdampon. Mado-ot to ikow nadomdoman diyà to atubangan to Diyus. ");
INSERT INTO did_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Na, ogsosoo ka pad na-ay aw oyowid to mado-ot no napikiyan nu aw pangamuyù ka to Diyus ko dagow pasayluhon ka dà to napikiyan nu no mado-ot. ");
INSERT INTO did_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Agaw man ogbayluhon nud podon to sapì to kabogbogan to Ispiritu Santu su mado-ot on to ginhawa nu diyà to Diyus. Nakasood ikow, kado-otan su nig-ingà ka man.” ");
INSERT INTO did_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Si Simon no nigpatutuus, naka-ikagi to “Pangamuyu-i a nu podon diyà to Diyus to konà ogkatuman to pig-ikagi nu bahin kanak.” ");
INSERT INTO did_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Na pagkatapus to pagpang-anad dan du-on aw paglikwad to kagi to Diyus no Magbobo-ot, namanpa-ulì on kandan no si Pedro aw si Juan diyà to Hirusalim. Dì pigpanghapit-hapitan dan pad to mgo kalunsudan to Samariya su igpasabut dan man to Madoyow no Tutuwanon bahin ki Jesus. ");
INSERT INTO did_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Na, og-uli-on ta pad si Felipe no tutugdawon no nangudlin to mgo taga-Samariya. Pig-ikagihan kandin to diwata likat to Diyus to “Na, kuwà kad on diyà to kalasada no ogpadoog diyà to babagan. Sikan no kalasada, likat diyà to Hirusalim no oglohus diyà to Gasa gayod no lunsud.” Naugoy on no kalasada sikan, dì maakwat on to ogbayà du-on su wadad lagboy uminugpà. ");
INSERT INTO did_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Dayun nighipanow on si Felipe padoog diyà to kalasada. Na, diyà ta pad mandà to bugtì no tutuwanon. Moydu-on otow no madiyù to piglikatan din no banwa no taga-Itiyupya. Sikan no otow, trisuriru ni Kandasi no buyag no nigsakup du-on to Itiyupya no banwa. Nig-andiyà to trisuriru to Hirusalim su og-ampù du-on. ");
INSERT INTO did_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Pagkatapus to nig-ampù, nig-ulì on kandin diyà to piglikatan din no nigsakoy to sakayan din. No pag-ingkud din du-on to sakayan, nigbasa-basa kandin to nasulat ni Isaias no maglilikwaday to Diyus no lagsoban natodu-on. ");
INSERT INTO did_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Na, og-uli-on tad mandà si Felipe no naka-abut on diyà to kalasada no igbayà to trisuriru. Du-on impaghibakos din to trisuriru. Dayun pigsugù Felipe to Ispiritu Santu no pig-iling to “Na, duguk ka kan no sakayan.” ");
INSERT INTO did_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Dayun nigduguk kandin to sakayan. Nadinog din to pigbasa to trisuriru to nasulat ni Isaias no maglilikwaday to Diyus. In-usip ni Felipe no nig-iling to “Kan no pigbasa nu, dow nasabutan nu?” ");
INSERT INTO did_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Nakatabak to trisuriru to “Amonuhon man to pagkasabut ku su wadà man ogpanoysoy kanak.” Dayun pigpaluwan din si Felipe to sakayan din. ");
INSERT INTO did_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","So-idi to nadinog ni Felipe no pigbasa to trisuriru no wadà din kasabuti no pig-iling to “Sikan otow, konà og-atu su kandin iyan ogka-angodan din to buhì no igsundù aw konà ogkahimu-himu to ginhawa to og-atu. Iyan ogka-angodan din gayod to nati to karniru ko oggupitan to bubuu no ogpatuyun kandin. ");
INSERT INTO did_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ko oglisod kandin, wadad ogpiyansa kandin. Amonuhon tad buwa to pagnangon to tùtu-u no kadakoan to saà to kadongan din su pigpakapusan dan man to kinabuhì din dini to babow to kalibutan.” ");
INSERT INTO did_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","“Na,” pig-usip to trisuriru, “to napa-atubangan to kagi ton lagsoban to Diyus, kandin tu-un no lawa dow duma.” ");
INSERT INTO did_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Dayun nigpasabut si Felipe to Madoyow no Tutuwanon bahin ki Jesus likat to sikan dà no nasulat ni Isaias. ");
INSERT INTO did_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Na nakabayà kandan to wohig. Kagi to trisuriru to “Ahà ka suyà wohig. Nokoy pad man to ogtagadan ta to pagpabonyag ku ikow.” ");
INSERT INTO did_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Nigtabak si Felipe to “Ogkahimù man ko tibuuson nu to ikow ginhawa.” Nakatabak to trisuriru to “Nokoy pad man su nigtu-u ad lagboy to si Jesus, Anak to Diyus.” ");
INSERT INTO did_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Dayun pigpasigkon din to sakayan aw haw-as kandan no ogduguk du-on to wohig aw apot kandan no daduwa aw bonyagi kandin ni Felipe. ");
INSERT INTO did_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Paggamat dan, pigsakgow si Felipe to Ispiritu Santu. Pigboong on kandin to trisuriru. Kandà to pagkikita dan. Dayun nigpadayong to trisuriru to panawan din no nigtutukhaway. ");
INSERT INTO did_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Dì si Felipe, monang on nataga no diyad on kandin to Asutu no banwa. Dayun niglogob-logob kandin mandà to mgo banwa to pagpasabut to Madoyow no Tutuwanon. Bali no nigdatong si Felipe diyà to Sisariya no lunsud. ");
INSERT INTO did_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Na og-uli-on tad si Saulo no kanunoy niglina-um to pagpanghimatoy to mgo sakup ni Jesus. Nig-andiyà si Saulo to mata-as to mgo punu-an to tinu-uhan. ");
INSERT INTO did_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Pagdatong din nigpangamuyù kandin to kalig-onan no ogpilimahan to mata-as su awos makilahan si Saulo to mgo otow no ogdaa to mgo simbahan to Hudiyu diyà to Damasku no lunsud. Ko panganapon din to mgo otow du-on no sakup ni Jesus, lukos dow buyag, igpadakop aw ogdaahon din diyà to Hirusalim. Dayun imbogoy to mata-as to kalig-onan no napilimahan din on. Pagkadawat ni Saulo, nighipanow on kandin padoog diyà to Damasku. ");
INSERT INTO did_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Na no madani on to ogdoogan din, tinakin pigbandogan lagboy si Saulo to bandog likat to langit. ");
INSERT INTO did_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Napood dayun si Saulo aw makadinog to kagi no iyan nalitukan to “Saulo. Saulo. Nokoy man to impahadat nu kanak.” ");
INSERT INTO did_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Nakatabak si Saulo to “Intawa ka Sir.” Nadinog ni Saulo to kagi no intabak no na-iling to “Kanak si Jesus no pigpahadatan nu. ");
INSERT INTO did_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Na, kuwà kad on aw padayong kad diyà to lunsud aw tagadi nu to sugù ku no ogkatuman nu.” ");
INSERT INTO did_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Sikan mgo duma ni Saulo, namakasigkon no wadà mamaka-ikagi. Namakadinog to kagi likat diyà to langit, dì wadà nakita-an dan. ");
INSERT INTO did_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Dayun nigbangun si Saulo aw gimata dì konad man ogpakakita. Kaling man pigtuyuk kandin to mgo duma din padoog diyà to lunsud ");
INSERT INTO did_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","aw napisok si Saulo to sood to tatou no adow aw wadà makako-on aw maka-inom. ");
INSERT INTO did_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Na diyà ta pad to bugtì no tutuwanon. Moydu-on songo sakup ni Jesus du-on to Damasku no iyan ngadan si Ananias. Pigpakita kandin to Diyus to ogkatuman. Kagi to Diyus no Magbobo-ot to “Ananias.” Naka-ikagi si Ananias to “So-idi ad Magbobo-ot ku.” ");
INSERT INTO did_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Kagi to Magbobo-ot, “Bangun kad aw andiyà kad on to bàya-anan no pighingadanan to Katul-idan no Baya-anan. Panganapa si Saulo no taga-Tarsu su mamonang dà kandin diyà to baoy ni Judas su nig-ampù kanak kunto-on. ");
INSERT INTO did_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Natagahan gayod ni Saulo to ogkatuman gagaya su pigpakita kud on man kandin. Nataga kandin gayod to ogdatong ka du-on to pig-ugpa-an din. Nama-anan din man to ngadan nu Ananias, aw ogdamponon nu kandin awos ma-uli-an to mata din.” ");
INSERT INTO did_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Dì naka-ikagi si Ananias to “Diyus kù, mahan-ing to nignangon kanak bahin sikan no otow su nigpang-uwang-uwang kun kandin to mgo sakup nu diyà to Hirusalim. ");
INSERT INTO did_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Su tu-ud din kun to ogdakop kanami no sakup nu su nig-andini to Damasku su nigsalig kun kandin to kalig-onan no pigpilimahan to mata-as to mgo punu-an to tinu-uhan.” ");
INSERT INTO did_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Kagi to Magbobo-ot, “Agad on man. Andiya-id, su pigpilì kud on si Saulo to ogpanoysoy bahin to kanak ngadan diyà to mgo harì aw mgo ka-Isrilihan aw duma no mgo ka-otawan no nigsingkabugtì no banwa dan. ");
INSERT INTO did_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Dì kanak no si Jesus, ogma-anon ku kandin dow nokoy to ogtuwa-ayon din su kandin ogtubus to kanak ngadan.” ");
INSERT INTO did_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Na nig-andiyà si Ananias to baoy ni Judas. Pagdatong din, pigdampon din si Saulo aw ikagi to “Saulo, su-un ku, kanak, pigpa-andini a ni Jesus no nakita-an nu diyà to pangindanan. Ogpadamponon a ikow awos ka ma-uli-an aw kasoodi ka to Ispiritu Santu.” ");
INSERT INTO did_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Tinakin moydu-on nangkapadpad likat du-on to mata din no angod to papalison aw dayun nakagimata aw makakita kandin. Dayun nakasakindog si Saulo aw pabonyag to wohig. ");
INSERT INTO did_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Pagbonyag kandin, nakako-on on. Pagkatapus to pagko-on, nigdoson on kandin. Na pag-agpot ni Saulo to pila no adow du-on to mgo sakup ni Jesus no taga-Damasku, ");
INSERT INTO did_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","pigpunu-an din to pagpinang-andiyà to mgo simbahan aw pasabut to si Jesus iyan Anak to Diyus. ");
INSERT INTO did_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Naboong-boong tibò to nahimun no ka-otawan. Nigka-inusipay kandan to “Sikan buwa to otow no nighimatoy to mgo sakup no nig-ampù to ngadan ni Jesus diyà to Hirusalim aw andini mandà kandin su awos dakopon mandà to nasamà aw daaha diyà to punu-an to tinu-uhan diyà to Hirusalim.” ");
INSERT INTO did_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Dì nigdugang to kabogbogan ni Saulo to pagpang-anad. Nakambawan ni Saulo to mgo Hudiyu no taga-Damasku aw kangkadaa din to si Jesus to Imananan to Ka-otawan. ");
INSERT INTO did_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Dì pagkaugoy nighihimun to mgo Hudiyu su ogsusukunan dan dow og-amonuhon to pagpadoog to paghimatoy dan podon ki Saulo. ");
INSERT INTO did_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Dì moydu-on nigtaga ki Saulo to pikii dan to ogpakahimatayan dan podon kandin. Adow aw madukilom pigbantayan dan to lili-ot to matikang no aad no batu no inlibong to lunsud. ");
INSERT INTO did_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Dì songo kadukiloman nigtagù si Saulo to bangkow aw patuntun to mgo sakup din diyà dibauy to in-aad aw makalikoy on kandin aw hipanow on kandin padoog diyà to Hirusalim. ");
INSERT INTO did_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Na pagdatong ni Saulo to Hirusalim, ogpagba-ot podon kandin to duma no mgo sakup ni Jesus. Dì wadà tu-u kandan to si Saulo, sakup iyan ni Jesus. Nahadokan dan tibò su intobo-ot dan dow nigpakunon-kunon si Saulo to sakup kandin ni Jesus. ");
INSERT INTO did_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Dì si Bernabe no sakup ni Jesus, pigbuligan din si Saulo. Pigdaa din diyà to mgo tumutubus ni Jesus. Pignangonan din kan mgo tumutubus to “Piglogwà si Saulo ni Jesus diyà to pangindanan padoog diyà to Damasku aw sugu-ad kandin ni Jesus. Diyà to simbahan to taga-Damasku, wadà hadok-hadok ni Saulo to ogpanoysoy bahin to ngadan ni Jesus.” ");
INSERT INTO did_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Kaling man nigpag-agpot si Saulo du-on to sinakupan ni Jesus aw libod-libod to mgo simbahan diyà to Hirusalim ");
INSERT INTO did_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","no ampan kahadok no nigpang-anad kandin no nigtubus to ngadan ni Jesus no Magbobo-ot. Nigpanoysoy si Saulo aw pag-asuy kandin to sinakupan to Giniriyigu no inikagihan no oghimatoy podon kandin. ");
INSERT INTO did_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Pagkama-an to dumà no sakup ni Jesus to ogmuwahon podon si Saulo, pigdaa dan diyà to Sisariya no lunsud aw pa-uli-a diyà to kandin banwa no Tarsu no lunsud. ");
INSERT INTO did_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Bali man nigsigkon to pag-uwang-uwang to sinakupan ni Jesus diyà to Hudiya aw Galiliya aw Samariya no likat pad to paghimatoy ki Esteban. Nighan-ing on kandan aw pigtahud dan to Diyus aw pinatibuus tibò kandan to Ispiritu Santu to ginhawa dan. ");
INSERT INTO did_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Na, og-uli-on tad to tutuwanon bahin ki Pedro. Niglogob-logob kandin to kalunsudan no nangudlin no bali nakatutuu to mgo sakup ni Jesus diyà to lunsud no Lida. ");
INSERT INTO did_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Nabaya-an din to otow no napulid no iyan ngadan si Iniyas. Wau on no tu-ig to pagkapulid din no konad on ogpakabangun. ");
INSERT INTO did_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Dì si Pedro, nig-ikagi kandin to “Iniyas, bangun kad on a