﻿USE sofia;
DROP TABLE IF EXISTS sofia.dhn_vpl;
CREATE TABLE dhn_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES dhn_vpl WRITE;
INSERT INTO dhn_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","शुरु मा परमेश्वर सोरग आरु धरती क बनायो। ");
INSERT INTO dhn_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","धरती क बनावट नी हुती आरु सुनली पड़तली हुती, आरु उन्डा जळ क उपोर आंधारो हुतो; एने परमेश्वर क आत्मा जळ क उपोर मण्डरायतो हुतो। ");
INSERT INTO dhn_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","ती परमेश्वर न कयो, “विजाळो होय,” ती विजाळो होय गोयो। ");
INSERT INTO dhn_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","आरु परमेश्वर न विजाळा क देख्‍यो कि वारु छे; आरु परमेश्वर न विजाळा क आंधारा सी ओलोग कोर्‌यो। ");
INSERT INTO dhn_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","आरु परमेश्वर न विजाळा क दाहड़ो आरु आंधारा क रात कोयो। एने सांतो हुयो आरु ओळतेन सोंदारो हुयो। ओस कोरीन पेहलो दाहड़ो होय गोयो। ");
INSERT INTO dhn_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","ओळतेन परमेश्वर कयो, पानीन वीच एक ओसो गाळो होय कि जळ दुय वाटाम होय जाय। ");
INSERT INTO dhn_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","ती परमेश्वर न एक गाळो कोरीन ओका नेचा क जळ आरु ओका उपोर क ओलोग कोर्‌यो; आरु ओसोत होय गोयो। आरु परमेश्वर न इना गाळा क वादळो कयो। एने सान्तो हुयो ओळतेन सोंदारो हुयो। ओस कोरिन दुसरु दाहड़ु होय गोयु। ");
INSERT INTO dhn_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","आरु परमेश्वर न हेका आकाश कोयो। एने सांतो हुयो ओळतेन भोर हुयो। एने रीते दुसरु दाहड़ु होयु। ");
INSERT INTO dhn_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","ओळतेन परमेश्वर न कयो, “वादळा क नेचो जळ एक जागा मा एकठो होय जाय आरु सुकली जागा देखा पोड़े,” आरु ओसोत होय गोयो ( 2 पत 3:5) ");
INSERT INTO dhn_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","आरु परमेश्वर न सुकला जागाक कोळी कोयो, एने जो जळ एकठो हुयो ओको हुयो दोरिया कोयो; आरु परमेश्वर न देख्यो कि वारु छे। ");
INSERT INTO dhn_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","ओळतेन परमेश्वर न कयो, “धोरती सि निळ्ळो खोड़ो, एने बिजावाळा नानला झाड़ आरु फोव आपन्या झाड़ वी जेनदरा बिजा हेना मा एक एक जाती क ओनसारे रोहे कोळी पोर उगे,” आरु होसोत हुय गोयो। (1 कुरि 15:38) ");
INSERT INTO dhn_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","ओस कोरीन कोळी सि निळ्ळो खोड़ो, आरु नानला झाड़े जिनाम आपसी जाति क ओनसारे बिज रोहे, आरु फोव आपन्या झाड़ जेन्दरा बिजा एक एक क जाति क ओनसारे हेरेमा छे उगे; आरु परमेश्वर न देख्यो कि वारु छे। ");
INSERT INTO dhn_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","एने सांतो हुयो ओळतेन सोंदारो हुयो। ओस कोरिन तिसरो दाहड़ो होय गोयो। ");
INSERT INTO dhn_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","ओळतेन परमेश्वर न कयो, “दाहड़ा क रात सी अलोग करने क लिय वादळा क गाळा मा विजाळो होय; आरु ये सोहलानी, आरु खोरी टेम, आरु दाहड़ा, आरु साल क कारण होय; ");
INSERT INTO dhn_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","आरु यो विजाळ्ळो वादळा क गाळा मा कोळी पोर विजाळो आपन्यो वी कोवाये,” आरु ओसोत हुय गोयो। ");
INSERT INTO dhn_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","ती परमेश्वर न दुय मोटला विजाळा बोनायो; हेनामा सी मोटलो विजाळो क दिसु पोर राज कोरने क लिय, आरु नानला विजाळा क रात पोर राज कोरने क लिय बोनायो; आरु तारामन्डळीक बी बोनायो। ");
INSERT INTO dhn_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","परमेश्वर न ओको वादळा क गाळा मा ओतरान कोरिन मेक्यो की हुये कोळी पोर विजाळो आपे, ");
INSERT INTO dhn_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","एने दिस आरु रात पोर राज कोरे आरु विजाळा क आंधारा सि ओलोग कोरे; आरु परमेश्वर न देख्यो कि वारु छे। ");
INSERT INTO dhn_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","एने सांतो हुयो ओळतेन सोंदारो हुयो। ओस कोरीन चोथो दाहड़ो हुय गोयो। ");
INSERT INTO dhn_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","ओळतेन परमेश्वर न कयो, “जळ जिवतला जिवो सी बेसको भोराय जाय, आरु चिल्‌ला कोळी क उपोर वादळा क गाळा मा उड़े।” ");
INSERT INTO dhn_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","ओतरान कोरिन परमेश्वर न जाति क मोटा जळ जिवो क आरु हेनु सब जिवतला जिवो क वी बोनायो जे चालता फिरता छे जेनासी जळ बेसका भोराय गोया आरु एक एक जाति क उड़नेवाळा चिल्‌ला क वी बोनायो; आरु परमेश्वर न देख्यो कि वारु छे। ");
INSERT INTO dhn_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","परमेश्वर न यो कोहीन ओको बोरकोत आप्यो, “फुलो फलो, आरु दरिया क जळ मा भोयार जावु, आरु चिल्‌ला कोळी पोर बेसका होय जाय।” ");
INSERT INTO dhn_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","एने सांतो हुयो ओळतेन सोंदारो हुयो। ओस कोरीन पाचवो दाहड़ु हुय गोयो। ");
INSERT INTO dhn_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","ओळतेन परमेश्वर न कयो, “कोळी सी एक एक जाति क जिवतला जिवे, यानी घोरुन ढुरे, आरु रेंगनेवाळा जिवे, आरु कोळी क जोंगली ढुरे, जाति जातिन क ओनसारे पोयदा होये,” आरु ओसोत होय गोयो। ");
INSERT INTO dhn_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","ओस कोरीन परमेश्वर न कोळी क जाती जाति क जोंगली ढुरो क आरु जाति जातिन क घोर पावन्या ढुरो क, आरु जाति जातिन क कोळी पोर सब रेंगनेवाळा जिवो क बोनायो; आरु परमेश्वर न देख्यो कि वारु छे। ");
INSERT INTO dhn_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","ओळतेन परमेश्वर न कयो “हामु मानुस क आपसा रुपो क ओनसारे आपने जोसा बोनावजे; आरु हुये दोरिया क माछा, आरु वादळा क चिल्‌ला आरु घोरपावन्या ढुरो, आरु आखी कोळी पोर, आरु सब रेंगनेवाळा जिवो पोर जो कोळी पोर रेंगे छे, हुकुम राखे।” ");
INSERT INTO dhn_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","ती परमेश्वर न मानुसक आपसा रुपो क ओनसारे बोनायो, आपसात रुपो क ओनसारे परमेश्वर न ओको पोरदा कोर्‌यो; नर आरु नारी कोरीन हुयो मानुस क बोनायो। (मत्ती 19:4, मर 10:6) ");
INSERT INTO dhn_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","आरु परमेश्वर न हेनुक बोरकोत आप्यो; आरु हेनुक कोयो, “फुलो फलो, आरु कोळी मा भोराय जावु, आरु ओको आपसा होको मा कोर लेवु; आरु दोरीया क माछा, एने वादळा क चिल्‌ला, आरु कोळी पोर रेंगनेवाळा सब जिव पोर होक राखे।” ");
INSERT INTO dhn_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","ओळतेन परमेश्वर न हेनु सी कोयो, “सोमळु, जोतरा बीजवाळा फोव रोहे, चे सब हांव तुमुक आपलु छे; हुये तुमरा खाने क लिय छे (14 : 2) ");
INSERT INTO dhn_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","आरु जोतरा कोळी क ढुरे, आरु वादळा क चिल्‌ला, आरु कोळी पोर रेंगनेवाळा जिवे छे, जिनामा जिवन क जिव छे, हेनु सब क खाने क लिय हांव सब निळ्ळा निव्ळा नानला झाड़ आपलो छे,” आरु ओसोत होय गोयो। ");
INSERT INTO dhn_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","ती परमेश्वर न जो काई बोनायो हुतो, सब क देख्यो, ती काय देख्यो, कि हुयो बेसको वारु छे। एने सांतो हुयो ओळतेन सोंदारो हुयो। ओस कोरीन छटवो दाहड़ो होय गोयो। (1 तीमु 4:4) ");
INSERT INTO dhn_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","इनी रीतिये सोरोग आरु धरती आर जो काय ओका मा छे उनी आखी चीज बनी। ");
INSERT INTO dhn_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","आरु परमेश्वर न आपसो काम जो हुयो कोरतो हुतो सातवे दाहड़े सार देदु, आरु हुये आपसा कोरला काम सी सातवे दाहड़े आराम कोर्यु। ");
INSERT INTO dhn_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","आरु परमेश्वर न सातवा दाहड़ा क बोरकोत आप्यो आरु चुखलो कोयो; काहकी हेनामा हुयो कोळी क घोड़ीन आपसो आखो कामो सी आराम कोर्यु। ");
INSERT INTO dhn_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","वादळा आरु कोळी क उबेजनो क वाराम यो छे की जोत्यार हुये पयदा होया यानी जेने दाहड़े योहोवा परमेश्वर न कोळी आरु वादळा क बोनाय: ");
INSERT INTO dhn_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ती खोयड़ा क काई पोवधो कोळी पोर नी हुतो, आरु नी खोयड़ा क काई नानो झाड़ उगलो हुतो, काहकी योहोवा परमेश्वर न कोळी पोर जळ नी पाड़्यु होतु, आरु कोळी पोर खेती करने क लिय मानुस वी नी हुतो; ");
INSERT INTO dhn_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","ते वी धुरो कोळी सी उठतो होतो तेरे सी कोळी पोर पानी देदला जोसो होय जातलो। ");
INSERT INTO dhn_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","ती योहोवा परमेश्वर न आदम क कोळी क धुळा सी बोनायो, आरु ओका नाको मा जिवन क सास फुक देदो; आरु आदम जिवतो जीव बोन गोयो। ");
INSERT INTO dhn_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","आरु योहोवा परमेश्वर न उगेवनो अदन मा एक वाड़ी लागाड़्यो, आरु होंया आदम क जेनाक हुयो बोनायो होतो, मेक देदो। ");
INSERT INTO dhn_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","आरु योहोवा परमेश्वरन कोळी सी सब भाती क झाड़, जे देखने मा घोन वारु जेनाक खाने मा वारु छे, उगाड़्यो, आरु वाड़ी क वीच मा जिवन क झाड़ क आरु वारु एने भुण्डा क गियान क झाड़ क वी लागाड़्यो। (प्रकाशितवाक्य 2:7, 22:2,14) ");
INSERT INTO dhn_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","हेनी वाड़ी क पानी देने क लिय एक मोटली नोदी अदन सी निकोळी आरु होंया सी ओगी उहवीन चार भागो मा वाटाय गोय। ");
INSERT INTO dhn_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","पेहली धारा क नाव पीशोन छे; यी ची छे जी हवीला नाव क आखो देश क जाँ सोनो छे, च्यारो मेर घेर रय। ");
INSERT INTO dhn_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","हेना देश क सोनो चुखो छे; होंया मोती आरु सुलेमानी दोगड़ा वी जोड़तला छे। ");
INSERT INTO dhn_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","दुसरी नदी क नाव गीहोन छे; यी ची छे जी कुश क आखा देश क घेरवायली छे। ");
INSERT INTO dhn_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","आरु तीसरी नोदीन नाव हिद्देकेल छे; यी ची छे जी अश्‍शुर क उगेवनो भिनी उहवे। आरु चोथी नोदीन नाव फरात छे। ");
INSERT INTO dhn_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","ती योहोवा परमेश्वर न आदम क लीन अदन क वाड़ी मा मेक देदो, कि हुयो हेरेम काम कोरे आरु वाड़ी क गुवाळी करे। ");
INSERT INTO dhn_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","आरु योहोवा परमेश्वर न आदम क यो हुकुम आप्यो, तु वाड़ी क आखा झाड़ क फोव विगुर निसंदेह खाय सोकतलु छे; ");
INSERT INTO dhn_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","बाखुन वारु भुण्डान क गियान क जो झाड़ छे, ओको फोव ती कोदी झुनी खाय: काहकी जेने दाहड़े तु हेना फोव क खाईस तेने दाहड़े छाचीन मोर जाईस ( रोमियो 6:23) ");
INSERT INTO dhn_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","ओळी योहोवा परमेश्वर न कयो, “मानुसक एखलो रयनो वारु नी हयस; हांव एरे जुगु एक ओसो सहायक बोनावीस जो एरे सी मेळ खाय।” ");
INSERT INTO dhn_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","आरु योहोवा परमेश्वर कोळी मा सी सब जाती क बनेला ढुरे, आरु वादळा क सब भाती क चिल्‌ला क बोनावीन आदम क पास ली आयो कि देख्यो कि हुयो हेन्दरो नाव काय काय पाड़े; आरु जिना जिनान जिवतला जिव क जो जो नाव आदम न पाड़्यो चोत ओको नाव होय गोयो। ");
INSERT INTO dhn_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","अत: आदम न सब जाति क घोरोन ढुरो, आरु वादळ क चिल्‌ला, आरु सब जाती क बनेले ढुरो क नाव पाड़्यो; बाखुन आदम क लिय कोय ओको सहायक नी जोड़्यो जो हेरे सी मेळ खाय सोके। ");
INSERT INTO dhn_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","ति योहोवा परमेश्वर न आदम क भारी नींदो मा सुवाड़ देदो, आरु जोत्यार हुयो सुय गोयो ती हुयो ओकी एक पासळी निकाळीन हेरे जागे मास भोर देदो। ");
INSERT INTO dhn_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","आरु योहोवा परमेश्वर न ओकी पासळी क जो हुयो आदम मासी निकाळ्यो हुतो, बायर बोनाय देदो; आरु आदम क पास ली आयो। ");
INSERT INTO dhn_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","ती आदम न कयो, हिमी यी मारु हाड़की मा की हाड़की आरु मारा मास मा क मास छे; ओतरान कोरिन एरो नाव नारी होयसे, काहकी यी नर मासी निकवली गोयली छे। (उत्पत्ति 29:14, 2 शामुएल 5:1, 1 कुरिन्थियो 11:8, 1 तिमु, 2:13) ");
INSERT INTO dhn_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","इने रिते मानुस आसी बासाक छुड़ीन आपसी घोरवाळी सी मिलीन रोहसे, आरु हुये एकुत डील बोनला रोहसे। (मत्ती 19:5, 1 कुरि. 6:16, इफि. 5:31) ");
INSERT INTO dhn_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","आदम आरु ओकी घोरवाळी दुयु नांगा होता, बाखुन लाजवायता नी होता। ");
INSERT INTO dhn_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","योहोवा भगवान जतरा जंगली जोनवारीयान क बोनायो हुतो, हेनु सब मा घोड़सो धुर्त हुतो; हुयो बाई सी कयो, काय छाचीन छे कि परमेश्वर न कयो, तुमु इनी वाड़ी क काहना झाड़ोन फोव नी खानो ( रोम 12:9, योएल 8:44, प्रका. 20:2) ");
INSERT INTO dhn_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","बाई न घोड़सा सी कोहि, इनी वाड़ी क झाड़ क फोव हामु खाय सोकजे; ");
INSERT INTO dhn_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","बाकु जो झाड़ वाड़ी क वीच मा छे, तेना फोव क वारा मा परमेश्वर कोवले छे कि नी ते तुमु ओको खाजे आरु नी ओको छिमजो नी ते तुमु मोर जासु ");
INSERT INTO dhn_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","ती घोड़सो न बायोर सी कयो, तुमु छाचीन नी मोरसु ");
INSERT INTO dhn_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","बाखुन परमेश्वर जाने की जेने दाहड़े तुमु हेरो फोव खासु तेने दाहड़े तुमरा डुळा उगड़ी जासे, आरु तुमु वारु भुण्डा क गियान जोड़से ती परमेश्वर जोसा होय जासु (यहेज. 28:2) ");
INSERT INTO dhn_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","एने: जोत्यार बायर न देखी की हेना झाड़ क फोव खाने मा वारु, आरु देखने मा मनभाऊ, आरु ओकोल आपने क लिय ओसो वी छे, ती होयी हेनाम सी तुड़ीन खादी; आरु आपसा घोरवाळा क वी आपी, जु हेरे सात मा हुतो; आरु हुयो वी खादो। ");
INSERT INTO dhn_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","ती हेनु दुयो क डुळा उगड़ी गोया, आरु ओको मालुम होयो कि हुये नांगा छे; ओतरान कोरिन हुये अंजीर क पान्टा जुड़ जुड़ीन छिन्दरा बोनाय लेदा। ");
INSERT INTO dhn_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","योहोवा परमेश्वर, जु दाहड़ा क सेळ्ळे टेमे वाड़ी मा फिरतो हुतो, ओको बुल सोमळाय देदो। ती आदम आरु ओकी घोरवाळी वाड़ी क झाड़ क वीच योहोवा परमेश्वर सी डुकाय गोया। ");
INSERT INTO dhn_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","ती योहोवा परमेश्वर न आयड़ीन आदम सी पुछ्यो, “तु काँ छे?” ");
INSERT INTO dhn_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","हुयो कयो, “हांव तारा बुले वाड़ी मा सोमळीन बिह गोयु, काहकी हांव नांगु होतु; एकालिय डुकाय गोयु।” ");
INSERT INTO dhn_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","योहोवा परमेश्वर न कयो, “कुन तुसे बताड्यो की तु नांगु छे? जेना झाड़ क फोव खाने क हांव तुसे मोना कोर्यु होतु, काय तु हेरो फोव खादलु छे?” ");
INSERT INTO dhn_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","आदम न कयो, “जेनी बायर क तु मारे पुठी रोहने क आपलो छे होयी हेना झाड़ क फोव मेसे आपी, आरु हांव खादु।” ");
INSERT INTO dhn_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","ती योहोवा परमेश्वर न बायर सी कयो, “तु यो कोरली छे?” बायर न कोहि, घोड़सो न मेसे बोहकाड़ देदो, ती हांव खादी (रोम 7:11, 2 कुरि 11:3, 1 तीमु 2:14) ");
INSERT INTO dhn_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","ति योहोवा परमेश्वर न घोड़सा सी कयो, “तु जो यो काम कोरलु छे ओतरान कोरिन तु आखा घरोन ढुरोक, आरु आखा जोंगली ढुरो सी जादा‍ शापित छे; तु पेटोल भुरसे जालीस, आरु जीवन भोरीन धुळु चाटतु रोहीस; ");
INSERT INTO dhn_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","आरु हांव तारे आरु एनी बायोर क वीच मा, आरु तारा ओवलियाद आरु ओकी ओवलियाद क विच मा घाड़ाय पोयदा कोरीस, हुयो तारो मुनका क कुचनी नाखसे, आरु तु एरी पाय पाटली क चावीस।” ");
INSERT INTO dhn_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","ओळतेन बायोर सी हुयो कयो, हांव तारी पीड़ा आरु तारा भारपाये होयने क दुख क बेस वोदाड़ीस; तु मान्दी होईन पुर्याक पोयदा कोरीस; आरु तारी लालोस तारा घोरवाळा क भीनी रोहसे, आरु हुयो तोर पोर पोरबुता कोरसे (1 कुरि 11:3, इफि 5:22, कुलु 3:18) ");
INSERT INTO dhn_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","आरु आदम सी हेनासी कयो, “तु जो आपसी घोरवाळी क वात सोमळ्यु, आरु जेना झाड़ क फोव क वारा हांव तुसे हुकुम आपलु होतु की तु हेनाक नी खानो, ओको तु खादलो‌‌ छे, ओतरान कोरिन कोळ तार कारण शापित छे। तु ओको उपज जिवन भोर दुख क सात खाया कोरीस (इब्रा 6:8) ");
INSERT INTO dhn_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","आरु हुयो तारे लिय काटा आरु ऊँटकटारे उगाड़से, आरु खेत क उपज खाईस; ");
INSERT INTO dhn_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","आरु आपसा माथा क पेसोव क रुटा खाया कोरीस, आरु आखरी मा धुळा मा मेळ जाईस; काहकी तु एना मासी निकावला गोयला छे, तु धुळु ते छे आरु धुऴा मा ओळी मीळ जाईस।” ");
INSERT INTO dhn_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","आदम न आपसी घोरवाळी क नाव हेवा पाड़्यो; काहकी जोतरा मानसे जीवतला छे हेनु सब क मुलमाता हुयी होयी। ");
INSERT INTO dhn_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","आरु योहोवा परमेश्वर न आदम आरु ओकी लाड़ी क लिय चामड़ा क छिन्दरा बोनाविन ओको पेहराय देदो। ");
INSERT INTO dhn_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","ओळी योहोवा परमेश्वर न कयो, “मानुस वारु भुण्डा क गियान पावीन हामु मा सी एक क जोसा होय गोया छे: ओतरान कोरिन हिमी ओसो नी होय, कि हुयो हात बोड़ावीन जिवन क झाड़ क फोव वी तुड़ीन खाय ले आरु होमीसा जिवतो रोहे।” ");
INSERT INTO dhn_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","ओतरान कोरिन योहोवा परमेश्वर न ओको अदन क वाड़ी मासी निकाळ देदो कि हियो हेना जागा पोर किरसानी कोरे जेनामा सी त्यो बोनावलो गोयो हुतो। ");
INSERT INTO dhn_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","ओतरान कोरिन आदम क हुयो निकाळ देदो आरु जिवन क झाड़ क वाट क पेहरो देने क लिय अदन क वाड़ी क उगेवनो भिनी करुबो क, आरु च्यारु मेर फिरनेवाऴा आगठा जोसो तलवार क वी नेवाड़ कोर देदो। ");
INSERT INTO dhn_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","जब आदम आपसी घोरवाळी हेवा क पास गोयो ती होयी भारेपाये होईन केन क जन्म आपी आरु कोयु, “हांवने योहोवा क सहायता सी एक पुर्य क जनम देदो छे।” ");
INSERT INTO dhn_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","ओळतेन हुयी ओका भाई हाबील क वी जन्म देदी, हाबिल ते गाडरा बुकड़ा क गुळाळ्या बोन गोया, बाखुन केन भुमी क खेती कोरनेवाळो किरसान बोन्यो। ");
INSERT INTO dhn_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","थुड़ाक दाहड़ा क वाद केन योहोवा क पास कोळी क उपज मा सी काहीन भेंट ली आयु (यहु 1:11) ");
INSERT INTO dhn_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","आरु हाबील वी आपसा गाडरा बुकड़ा क काई एक पेहली पयदावारीन पीलान क भेंट चोढ़ावने ली आयो आरु ओकी चोरबी भेंट चोड़ाया; ती योहोवा न हाबिल आरु ओकी भेंट क ते ग्रहण कोर्‌यो, (इब्रा 11:4) ");
INSERT INTO dhn_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","बाखुन केन आरु ओकी भेंट क हुयो कबुल नी कोर्‌यो। ति केन बेस रिसवाय गोयु, आरु ओका मुयो पोर उदासी छाय गोय। ");
INSERT INTO dhn_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","ती योहोवा न केन सी कयो, “तु काहा रिसवाय रोयु? आरु तारा मुयो पोर उदासी काहा छाय गोयली छे? ");
INSERT INTO dhn_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","काहमाईन तु भोलो कोरे, ती काय तारी भेंट ग्रहण न कोरी जासे? आरु काहमाईन तु भोलो नी कोरे, ते पाप झोपला पर छापायलो रोहे, आरु ओकी लालसा तारे भिनी रोहसे, आरु तुखे हेर पोर राज कोरनो छे।” ");
INSERT INTO dhn_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","ती केन न आपसा भाईस हाबील सी काहीन कोयो; आरु जब हुये खोयड़ा मा हुता, ती केन न आपसा भाईस पोर होमलु कोरीन मार देदो। ");
INSERT INTO dhn_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","ति योहोवा न केन सी पुछ्यो, “तारु भाई हाबील काँ छे?” हुयो कोयो, “मालुम नी; काय हांव आपसा भाई क राखवायु छे?” ");
INSERT INTO dhn_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","हुयो कयो, तु काय कोरलु छे? तारा भाई क लुहुय कोळी मा सि मेसे आयड़ीन मार सी विनता कोरने बाज रोयो (इब्रा 12:24) ");
INSERT INTO dhn_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","ओतरान कोरिन हिमी कोळी जी तारा भाई क लुहुय तारा हात सी पिने क लिय आपसो मुय उगाड़लो छे, ओकी भीनी सी तु शापित छे। ");
INSERT INTO dhn_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","चाहे तु कोळी पोर खेती कोरे, ते वी ओकी उपज ओळी तुसे नी जोड़से, आरु तु कोळी पोर भटकने वाळा आरु भगोड़ा होयसे। ");
INSERT INTO dhn_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","ती केन न योहोवा सी कयो, “मारो डोन नी वेठाये ओसो छे। ");
INSERT INTO dhn_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","देख, तु आज क दाहड़े मेसे कोळी पोर सी निकाळो छे आरु हांव तारी निगाह क आड़ मा रोहीस आरु कोळी पोर भोटकने वाळु आरु भगोड़ा रोहीस; आरु जो काई मेसे मिळसे, मेसे मार देसे।” ");
INSERT INTO dhn_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","ओसो कोरिन योहोवा न ओका सी कयो, “जो काई केन क मारसे हेनासी सात गुणा बोदलु लियु जासे।” आरु योहोवा न केन क लिय एक सोहलानी राख्यु ओसो नी होय की काई हेनाक मिळसे ने मार देये। ");
INSERT INTO dhn_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","ति केन योहोवा क ओगोळ सी निकोळी गोयु आरु नोद नावोन देश मा, जे अदन क उगेवनो भिनी छे, रोहने लाग्यु। ");
INSERT INTO dhn_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","जब केन आपसी घोरवाळी क पास गोयो ती हुयी भारेपाये होयी आरु हनोक क जन्म देदी; ओळतेन केन न एक नोगोर बोसाड़्यो आरु हेना नगर क नाव आपसा पुर्या क नाव पोर हनोक पाड़्यो। ");
INSERT INTO dhn_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","हनोक सी ईराद पोयदा हुयो, आरु ईराद महुयाएल पोयदा हुयो आरु महुयाएल सि मतुशाएल, आरु मतुशाएल सी लेमेक पोयदा हुयो। ");
INSERT INTO dhn_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","लेमेक न दुय बायोर ईयाव कोर्यु: जिनामा सी एक क नाव आदा आरु दुसरा क सिल्‌ला छे। ");
INSERT INTO dhn_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","आदा न याबाल क जन्म देदो। हुयो हेनु मानशो क बाबो हुतो जो तंबु मा रोहता हुता आरु ढुरो क पाळन कोरने जिवन जिवता हुता। ");
INSERT INTO dhn_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","ओका भाई क नाव युबाल हुतो: हुयो हेनु मानशो क बाबो हुतो जी वीणा आरु पाळवी वाजाड़ता हुता। ");
INSERT INTO dhn_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","आरु सिल्‌ला न वि तुबल केन नामक एक पुर्या क जन्म देदो: हुयी पितळ आरु लुहड़ा क आखा धारवाळा होतीयार क गुपायनेवाळा हुता। आरु तुबल केन क बोहनीस नामाह होती। ");
INSERT INTO dhn_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","लेमेक न आपसी लाड़ी सी कयो, हे आदा आरु हे सिल्‌ला मारी सोमळु; हे लेमेक क घोरवाळी, मारु वात पोर कानटा लागाड़ु: हांव एक मानुसक जे मेसे चुट लागाड़तो हुतो, अर्थात एक जुवान क जो काई मेसे घायोल कोरता हुता, घात कोरलो छे। ");
INSERT INTO dhn_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","जब केन क बोदलु सातगुणा लियो जासे। ती लेमेक क सतहत्तर गुणा लेयो जासे (मत्ती 18:24) ");
INSERT INTO dhn_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","आरु आदम आपसी घोरवाळी क पास ओळी गोयो; आरु ओको एक पुर्या क जन्म देदो आरु ओको नाव यो कोहीन शेत पाड़्यो कि परमेश्वर न मारे लिय हाबील क बोदले, जेनाक केन मार्‌यो हुतो, एक आरु ओवलियाद आप्यो (उत्प 5:3-4) ");
INSERT INTO dhn_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","आरु शेत क वी एक पुर्य पोयदा हुयो आरु ओको नाव एनोश पाड़्यो। तेने टेमे सी मानशे योहोवा सी विनता कोरने लाग्या। ");
INSERT INTO dhn_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","आदम क ओवलियाद यी छे। जोतयार परमेश्वर न मानुसक बोनायो ती आपसात रुपो मा ओको बोनायो (उत्पत्ती 1:27) ");
INSERT INTO dhn_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","हुयो नर आरु नारी कोरीन मानशो क बोनायो की आरु हेनुक बोरकोत आपे, आरु हेनुक बोनावने क दीन ओको नाव आदम पाड्यो। (उत्पत्ती 1:27-28) ");
INSERT INTO dhn_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","जोतयार आदम एक सोव तिस साल क हुयो, ती ओका द्वारा ओकोत जोसा मात हेना सी हेरेजोसो एक पुर्य पोयदा हुयो। ओको नाव शेत पाड़्यो। ");
INSERT INTO dhn_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","आरु शेत क पोयदा होयने क वाद आदम आठ सोव साल जिवतलो रोयो, आरु ओका आरु वी पुर्या पुरायटा पोयदा होया। ");
INSERT INTO dhn_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","ओस कोरीन आदम क आखा मेविन नोव सोव साल क हुयो, तेवाद हुयो मोर गोयो। ");
INSERT INTO dhn_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","जब शेत एक सोव पाच साल क हुयो, हेनासी एनोश हुयो। ");
INSERT INTO dhn_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","एनोश क पोयदा होयने क वाद शेत आठ सोव साल जिवतलो रोयो, आरु ओका आरु वी पुर्या पुरायटा पोयदा होया। ");
INSERT INTO dhn_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","ओस कोरीन शेत क पुरी उमोर नोव सोव बारे साल क हुयो; ओळतेन मोर गोयु। ");
INSERT INTO dhn_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","जोतयार एनोश नब्बे साल क हुयो, ती हुयो केनान क जन्म देदो। ");
INSERT INTO dhn_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","केनान क जन्म क वाद एनोश आठ सोव पोन्द्रे साल जिवतलो रोयो, आरु ओका आरु वी पुर्या पुरायटा पोयदा होया। ");
INSERT INTO dhn_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","ओस कोरीन एनोश क पुरी उमोर नोव सोव पाच साल हुयो; ती हुयो मोर गोयो। ");
INSERT INTO dhn_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","जब केनान सत्तर साल क हुयो, ती हुयो महललेल जन्म देदो। ");
INSERT INTO dhn_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","महललेल क जन्म क वाद केनान आठ सोव चाळीस साल जिवतलो रोयो, आरु ओका आरु वी पुर्या पुरायटा पोयदा हुया। ");
INSERT INTO dhn_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","ओस कोरीन केनान क पुरी उमोर नोव सोव दस साल क हुयो; ति हुयो मोर गोयो। ");
INSERT INTO dhn_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","जब महललेल पेसठ साल क हुयो, ती हुयो येरेद क जन्म देदो। ");
INSERT INTO dhn_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","येरेद क जन्म क वाद महललेल आठ सोव तीस साल जिवतलो रोयो, आरु ओका आरु वी पुर्या पुरायटा पोयदा हुया। ");
INSERT INTO dhn_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","ओस कोरीन महललेल क आखी उमोर आठ सोव साल पंचानवे साल क हुयो; ती ओळतेन हुयो मोर गोयो। ");
INSERT INTO dhn_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","जोतयार येरेद एक सोव बासठ साल क हुयो, जब हेनोक क जन्म देदो। ");
INSERT INTO dhn_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","हनोक क जन्म क वाद येरेद आठ सोव साल जिवतलो रोयो, आरु ओका आरु वी पुर्या पुरायटा होया। ");
INSERT INTO dhn_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","ओस कोरीन येरेद क पुरि उमोर नोव सोव बासठ साल क हुयो; तेरे वाद हुयो मोर गोयो। ");
INSERT INTO dhn_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","जब हनोक पेसठ साल क हुयो, ती हुयो मतुशेलह क जन्म देदो। ");
INSERT INTO dhn_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","मतुशेलह क जन्म क वाद हनोक तीन सोव साल लोगुन परमेश्वर क सात साते चालतो रोयो, आरु ओका आरु वी पुर्या पुरायटा पोयदा होया। ");
INSERT INTO dhn_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","ओस कोरीन हनोक क पुरी उमोर तीन सोव पेसठ साल क हुयो। ");
INSERT INTO dhn_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","हनोक परमेश्वर क सात साते चालतो हुतो; ओळतेन हुयो लोप हुय गोयो काहकी परमेश्वर न ओको उठाय लेदो (इब्रानियो 11:5, प्रकशित 4:10, 2 राजा 2:11, युहन्ना 14) ");
INSERT INTO dhn_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","जब मतुशेलह एक सोव सत्तासी साल क हुयो, ती हुयो लेमेक क जन्म देदो। ");
INSERT INTO dhn_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","लेमेक क जन्म क वाद मतुशेलह सात सोव बयासी साल जिवतलो रोयो, आरु ओका आरु वी पुर्या पुरायटा पोयदा हुया। ");
INSERT INTO dhn_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","ओस कोरिन मतुशेलह क पुरि उमोर नोव सोव उनसोतोर क हुयो; तेर वाद मोर गोयो। ");
INSERT INTO dhn_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","जब लेमेक एक सोव बयासी साल क हुयो, ती हुयो एक पुर्या क जन्म देदो। ");
INSERT INTO dhn_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","हुयो यो कोहीन ओको नाव नुह पाड़्यो, कि “योहोवा न कोळी क शाप आपलो छे, ओका वारामा यो पुर्य आमरे काम मा, आरु ओको कोठिन मेहनोत मा जो हामु कोरजे, आमुक शांति आपसे।” ");
INSERT INTO dhn_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","नुह क जन्म क वाद लेमेक पाच सोव पंचानवे साल जिवतलो रोयो, आरु ओका आरु वी पुर्या पुरायटा पोयदा होया। ");
INSERT INTO dhn_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","ओस कोरीन लेमेक क पुरी उमोर सात सोव सतहतर साल क हुयो; तेरे वाद हुयो मोर गोयो। ");
INSERT INTO dhn_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","आरु नुह पाच सोव साल क हुयो; आरु नुह न शेम, आरु हाम आरु येपेत क जन्म देदो। ");
INSERT INTO dhn_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","ओळतेन जोत्यार मानसे कोळी क उपोर घोना बोढ़ने लाग्या, आरु ओका पुरायटा पोयदा होय, ");
INSERT INTO dhn_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","ती परमेश्वर क पुर्या न मानसो क पुरायटा क देख्या, कि हुये घाटावा‌ छे, आरु हुये जेनु जेनुक चाहया तेरेसी ईयाव कोर लेदा। ");
INSERT INTO dhn_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","ति योहोवा न कयो, “मारो जीव मानुस सी होमीसा विवाद नी कोरसे, काहकी मानुस वी डीलुत छे; ओकी उमोर एक सोव साल होयसे।” ");
INSERT INTO dhn_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","तेनु दाहड़ा मा कोळी पोर दानव रोहता हुता; आरु ओका वाद जोत्यार परमेश्वर क पुर्या मानुसक पुरायटा क पास गोया ती ओका लारे जे पुर्या पोयदा हुया चे शुरवीर होता, जेन्दरी वात पेहले घोनी चालतली। (गिनती 13:33) ");
INSERT INTO dhn_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","योहोवा न देख्यो कि मानुसक बुराय कोळी पोर बोढ़ गयली छे, आरु ओका मन क विचार मा जो काइ पोयदा होये चो घोनोस भुण्डो होये छे। (मत्ती 24:37, लुका 17:26, 1 पतरस 3:20) ");
INSERT INTO dhn_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","आरु योहोवा कोळी पोर मानुसक बोनावने सी पोछतायो, आरु हुयो मोनो मा घोनो दुखी हुयो। ");
INSERT INTO dhn_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","ती योहोवा न कयो, “हांव मानुसक जेनुक हांव बोनवलु छे कोळी पोर सी मिटाड़ दिस; काय मानुस, काय ढुरे, काय रेंगनेवाळा जिवे, काय वादळा क चिल्‌ला, सब काई मिटाय दिस, काहकी हांव हेनुक बोनावने सी पोछतायो।” ");
INSERT INTO dhn_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","बाखुन योहोवा क गिन क निगाह नुह पोर बोनी रोही। ");
INSERT INTO dhn_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","नुह नु ओवलियाद यी छे। नुह धोरमी मानुस आरु आपसे टेमे क मानषो मा खोरु होतु ;आरु नुह परमेश्वर पुठी चालतु रोयु। ");
INSERT INTO dhn_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","आरु नुह सी शेम, आरु हाम, आरु येपेत नावोन तीन पुर्या पोयदा हुया। ");
INSERT INTO dhn_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","तेने टेमे कोळी परमेश्वर क निगाह मा बिगड़ गोय होती, आरु झगड़ो करावनो सी भोराय गोय होती। ");
INSERT INTO dhn_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","आरु परमेश्वर न कोळी पोर जी निगाह कोर्‌यो ती काय देख्‍यो कि हुयी बिगड़ी होयली छे; काहकी आखा जिवे न कोळी पोर आपसो चाल चलन बिगाड़ लेदा हुता। ");
INSERT INTO dhn_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","ती परमेश्वर न नुह सी कयो, “सब जिवो क खोतोम कोरने क सोवाल मारे ओगोव आय गोयलो छे काहकी हेन्दरे कारण कोळी झगड़ो करावनो सी भोराय गोयली छे, ओतरान कोरिन हांव हेनुक कोळी भेळ नाश कोर दीस। ");
INSERT INTO dhn_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","ओतरान कोरिन तु गोपोर झाड़ क लाकड़ा क एक ढोन्डयो बोनाव, तेरेमा खुल्या बनावजी, आरु माहाय खोयड़े हेना पोर राल लागाड़जी। ");
INSERT INTO dhn_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","इने रीते तु बोनावजी: ढोन्डया क नाम्बाय तीन सोव हात, चोवड़ो पोचास हात, आरु उचो तिस हातोन रोहे। ");
INSERT INTO dhn_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","ढोन्डया मा एक खिड़की बोनावजी, आरु एक हात उपोर सी ओकी छोत बोनावजी, आरु ढोन्ड्या क एकुत झोपलु राखजी; आरु ढोनड्या मा पेहलु, दुसरु, तिसरु खोण्डे बोनावजी। ");
INSERT INTO dhn_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","आरु सोमोळ, हांव आपसुत कोळी पोर मोटलु पानी पाड़िस आखा जीवोक, जिनामा जिवोन जीवे, वादळान नेड़ा सी नास कोरने मा छे; आरु आखा जो कोळी पोर गोथा मोर जासे। ");
INSERT INTO dhn_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","बाखुन तारे साते हांव वायदु बान्दो; ओतरान कोरिने हुयु आपसा पुर्या, लाड़ी, आरु उहड़सीया भेळ ढोनड्या मा भोराय जाजी। ");
INSERT INTO dhn_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","आरु सब जीवतला जिवो मा सी तु एक एक जाती क दुयदुय, यानी एक नर आरु एक मादा ढोनड्या मा ली जाईन, आपसे साते जिवतला राखजी। ");
INSERT INTO dhn_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","एक एक जाती क चिल्‌ला, आरु एक एक जाती क ढुरे, आरु एक एक जाति क कोळी पोर रेंगनेवाळा, सब मासी दुय तारे जुळ आवसे, कि तु हेनुक जिवतला राखे। ");
INSERT INTO dhn_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","आरु भाती भातीन क खानो चिज जे खातला छे, ओको तु लिन तारे जुळ एकठो कोरीन राखजी; जो तारे आरु ओका खाने क लिय होयसे।” ");
INSERT INTO dhn_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","परमेश्वर क इनी हुकुम क ओनसारे नुह न कोर्‌यो। (इब्रानियो 11:7) ");
INSERT INTO dhn_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","तोत्यार योहोवा भगवान नुह सी कयो, “तु आपसा आखा घोरल्याक लीन ढोन्ड्या मा जा; काहकी हांव इनु टेम क मानसो मा सी तुखेत मारी निंगा मा धोरमी जोड़लु छे। ");
INSERT INTO dhn_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","आखी जाती क चुखला ढुरो मा सी तु सात साते जुड़ो अर्थात् नर आरु मादा लावजी; बाखुन जे चुखला नी होय, तेनु मासी दुयदुयलावजी, अर्थात् नर आरु मादा (लेव्यव्यवस्ता 11) ");
INSERT INTO dhn_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","आरु आकाश क चिल्‌ला मा सी वी सात साते जुड़ो, अर्थात् नर आरु मादा लेजी, की हेन्दरो ओवलियाद वाचीन आखी कोळी क उपोर बोनलो रोहे। ");
INSERT INTO dhn_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","काहकी हीमी सात दाहड़ा वितने पोर हांव कोळी पोर चावीस दाहड़ा आरु चावीस रात लोगुन पानी पाड़तु रोहीस; आरु जोतरा जिवे मा बोनावलु छे हेनु सब क धोरती पोर सी मिटाय दिद।” ");
INSERT INTO dhn_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","योहोवा क इनी हुकुम क ओनसारे नुह न कोर्‌यो। ");
INSERT INTO dhn_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","नुह क ओमोर छ: सोव साल की हुती, जोत्यार जल प्रलय कोळी पोर आयो। ");
INSERT INTO dhn_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","नुह आपसा पुर्या, लाड़ी, आरु उहड़सीया भेळ जल–प्रलय सी वाचने क लिय ढोन्ड्या मा गोया। (मत्ती 24:38-49, लुका 17:27) ");
INSERT INTO dhn_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","चुखला आरु विटोळ, दुयु भातीन क ढुरो मा सी, चिल्‌ला, ");
INSERT INTO dhn_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","आरु कोळी पोर रेंगनेवाळा जिवो मा सी वी, दुयदुय, अर्थात् नर आरु मादा, ढोन्ड्या मा नुह क पास गोया, जोसु परमेश्वर नुह क हुकुम आप्यो हुतो। ");
INSERT INTO dhn_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","सार दाहड़ा क वाद प्रलय क जळ कोळी पोर आवने लाग्यो। ");
INSERT INTO dhn_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","जोत्यार नुह क ओमोर क छ: सोव साल क दुसरा मोहना क सत्रवो दाहड़ो आयो; तेनेत दाहड़े मोटला उंडा दरीया क आखा सोत फुट निकोळ्या आरु आकाश क झरोखा उगड़ी गोया ( 2 पतरस 3:6) ");
INSERT INTO dhn_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","आरु पानी चावीस दाहड़ा आरु चावीस रात एकसारकु कोळी पोर पोड़तु रोयु। ");
INSERT INTO dhn_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","ठीस तेनेर दाहड़े नुह आपसा पुर्या शेम, हाम, आरु येपेत, आरु आपसी लाड़ी, आरु तीनु उहड़ीसा भेळ, ");
INSERT INTO dhn_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","आरु ओका सात एक एक जाति क आखा बनेले ढुरे, आरु एक एक जाति क आखा घोरोन ढुरे, आरु एक एक जाति क सब उड़नेवाळा चिल्‌ला ढोन्ड्या मा गोया। ");
INSERT INTO dhn_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","जोतरा जीवो मा जिवन क जिव हुतो आखी जाति मा सी दुयदुय नुह क पास ढोन्ड्या म गोया। ");
INSERT INTO dhn_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","आरु जर गोया चे परमेश्वर क हुकुम क ओनसारे आखी जाति क जिवो मासी नर आरु मादा गोया। ती योहोवा न ढोन्ड्या क झपलो बोन्द कोर दिदो। ");
INSERT INTO dhn_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","कोळी पोर चावीस दाहड़ा लोगुन जल–प्रलय होयतो रोयो; आरु पानी बेसको बोड़तो गयो, जिनासी ढोन्ड्यो उपोर क उठने लाग्यो; आरु हुयो धोरती पोर सी उचो उठ गयो। ");
INSERT INTO dhn_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","जळ जाद् जादा धोरती पोर बेसको बोड़ गोयो, आरु ढोन्ड्यो पानी क उपोर झेपतो रोयो। ");
INSERT INTO dhn_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","पानी कोळी पोर बेसकोत बोड़ गोयो, यां लोगुन कि आखी धोरती पोर जोतरा मोट्टा मोटा बोयड़ा हुता, आखा डूब गोया। ");
INSERT INTO dhn_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","पानी पोन्द्रे हात आरु उपोर बोड़ गोयो, आरु बोयड़ा वी डूब गोया। ");
INSERT INTO dhn_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","आरु काय चिल्‌ला, काय घोरोन ढुरे, काय बनेले ढुरे, आरु कोळी पोर सब चालनेवाळा जिवे, आरु जोतरा जिवे कोळी मा घोन जोबोर सी भोराय गोया हुता, चे आखा आरु आखा मानुस मोर गोया। ");
INSERT INTO dhn_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","जे जागा पोर हुता, हेनुसी जोतरा वी नाको मा जोवोन दोम लेता हुता, आखा मोर मिट्या। ");
INSERT INTO dhn_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","आरु काय मानसे, काय ढुरे, काय रेंगनेवाळा जिवे, काय आकाश क चिल्‌ला, जे धोरती पोर हुता आखा कोळी पोर सी मोर मिट गोया; केवल नुह, आरु जोतरा ओका सात ढोन्ड्या मा हुता, चेत वाच गोया। ");
INSERT INTO dhn_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","आरु पानी कोळी पोर एक सोव पोचास दाहड़ा लोगुन रोयो। ");
INSERT INTO dhn_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","बाखुन परमेश्वर नुह आरु जोतरा बनेले ढुरे आरु पावन्या ढुरे ओका सात मा ढोन्ड्या म हुता, तेनु आखाक फोम राख्यु:आरु परमेश्वर कोळी पोर वाहवो उहवाड्यो, आरु जळ कोम होयने लाग्यो; ");
INSERT INTO dhn_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","आरु ऊण्डा दरीया क सोता आरु आकाश क झरोखा बंद हुय गोया; आरु जिना सी पानी पोड़तो हुतो चो वी रुक गयो; ");
INSERT INTO dhn_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","आरु डेड़ सोव दाहड़ा क वाद मा जळ धरती पोर गुथो घोटने लागयो। ");
INSERT INTO dhn_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","सातवा महीना क सत्रवे दाहड़े, ढोन्ड्यो अरारात नावन बयड़ा पोर टेक गियो। ");
INSERT INTO dhn_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","आरु पानी दसवे मोहने लोगुन घोटतो रोयो, आरु दसवे मोहने क पेहले दाहड़े क बयड़ान चोट्या देखा पोड़ी। ");
INSERT INTO dhn_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","ओळतेन ओसो हुयो कि चाळीस दाहड़ा क वाद मा नुह आपसा बोनावला ढोन्यान खिड़की उगाड़ीन, ");
INSERT INTO dhn_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","एक हाड़गावाक उड़ाय दिदो: जोत्यार लोगुन पानी धोरती पोर गोथो सुख्यो नी, तालोक लोगुन हाड़गावो ओथोन ओथो फिरतो रोयो। ");
INSERT INTO dhn_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","ओळतेन हेर जुळ एक पेरवी काजे वी उड़ाय देदो ने देख्यो कि जळ धोरती पोर सी घोट्यो की नी। ");
INSERT INTO dhn_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","तेनी पेरवी काजे आपसा पाय टेकवने वाटे काय साहरो नी जोड्यो, ती ची पोछी तेरेनचा ढोन्ड्या पोर आतरोय : काहकी आखी धोरती पोर पानी त् होतो। तोत्यार हात ओगु कोरीन आपसान चा ढोन्ड्या मा ली लेदो। ");
INSERT INTO dhn_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","तोत्यार ओवी सात दाहड़ा वीत गोया ने, हुयो तेनीत पेरवी काजे ढोन्ड्या मा सी ओळी उड़ाय देदो: ");
INSERT INTO dhn_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","आरु पेरवी सान्ती क टेम ओका पास मा आय लागी, ती काय देख्यो की ओकी चोंच मा जैतुन क एक पान्टो छ: एना सी नुह जान लेदो की जळ धोरती पोर गोथो घोट गोयो। ");
INSERT INTO dhn_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","ओळतेन नुह सात दाहड़ा आरु वाट जुवीन तेनीत पेरवी क उड़ाय दिदो: आरु ओळतेन ची पेरवी तेरेनचा पोछी फीरीन नी आवी। ");
INSERT INTO dhn_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","नुह की उमोर छोव सोव एक साल क पेहले मोहिने क पेहले दाहड़े जळ धोरती पोर गोथो सुक गोयो। तव ");
INSERT INTO dhn_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","तोत्यार दुसरे मोहने क सत्ताईसवे दाहड़े क धोरती पोर सी आखे रीते सुक गोय। ");
INSERT INTO dhn_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","तोत्यार परमेश्वर नुह क कयो, ");
INSERT INTO dhn_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","तु तारा पुर्या, घोरवाळी आरु उहुड़सीया आखाक लिन ढोन्ड्याम मा सी बाहर नीकोळी जा। ");
INSERT INTO dhn_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","काय चिल्‌ला, काय ढुरे, काय आखी भातीन क रेंगनेवाळा जिवे जे कोळी पोर रोवे–जोतरा डीलोवाळा जीवजन्तु तारे पुठी छे, तेनु आखाक तारे साते निकाय ले की कोळी पोर तेन्दरा घोना पुर्या होये आरु चे फुले फलें, आरु कोळी पोर खोव्‌वाय जाए। ");
INSERT INTO dhn_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","तोत्यार नुह आरु ओका पुर्या आरु घोरवाळी आरु उहुड़सीया निकोळी गोया: ");
INSERT INTO dhn_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","आरु आखा चारपाया, रेंगनेवाळा जीवे, आरु चिल्‌ला, आरु जोतरा जिवजोन्तु कोळी पोर चालता फिरता छे, आखी जाती जातीन कोरिन ढोन्ड्या मा सी नीकोळी आया। ");
INSERT INTO dhn_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","तोत्यार नुह योहोवा क लिय एक वेदी बनायो; आरु आखा चुखला ढुरो आरु आखा चूखला चिल्‌ला मा सी थुड़ा थुड़ाक लीन वेदी पोर होमबली चढ़ायो। ");
INSERT INTO dhn_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","इना पोर योहोवा सुखदायक गंदायन्य लीन विचार कोर्यु, “मानुसक कारण हांव ओळी कोदी कोळी क शाप नी आपो, बाखुन मानुसक मन मा बचपन सी जो काय पोयदा हुये चोत भुण्डोत रोवे; तेवी जोसु मे आखा जिवोक हिमी मारलु छे, तोसु तेनुक ओळतेन कोदी नी मारो। ");
INSERT INTO dhn_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","हिमी सी जोत्यार लोगुन कोळ बोनली रोहसे, तोत्यार लोगुन वेरने आरु काटने क टेम, सेळा आरु तोपोन, धूपकाल आरु शीतकाल, दाहड़ा आरु रात लोगातार होयतो रोहसे।” ");
INSERT INTO dhn_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","ओळतेन परमेश्वर नुह आरु ओका पुर्या क बोरकोत आप्यो आरु उना सी कयो फुलो–फलो, आरु वोदु, आरु कोळी मा भोराय जावु। ");
INSERT INTO dhn_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","तुमरी बीक आरु भय कोळी क आखो ढुरो, आरु आकाश क सब चिल्‌ला, आरु कोळी पोर क सब रेंगनेवाळा जीवो, आरु दरीया क सब माछा पोर बोनलो रोहसे: ये आखा तुमरा होको मा कोर दिदो जातो छे। ");
INSERT INTO dhn_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","आखा चालनेवाळा जिवे तुमरो खानो बोनसे; जोसो तुमुक निळ्वा निव्वा नानला झाड़ आपला हुता, तोसोत हिमी वी आखो आपो। ");
INSERT INTO dhn_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","बाखुन मांस क जिवो साते अर्थात् लुहुय भेव तमु झुणी खाता। (लेव्यव्यवस्ता 19:26, 15:23, व्यव्थाविवरण 12:16,23, उत्पत्ती 17:10-1) ");
INSERT INTO dhn_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","आरु खोरीत हांव तुमरे लुहुय अर्थात जीवोन बोदलु लीस: आखा ढुरे आरु मानसो, दुयो सी हांव हुयो लिस; मानसोन जीवो क बदलो एक एक क भाई बोन्या सी लीस। ");
INSERT INTO dhn_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","जो कुदु मानषोन लुहुय उहवाड़से तेरो लुहुय मानषोन से उहावाड़ीयो जासे, काहकी परमेश्वर मानुसकाजे आपसा रुपोन ओनसारे बनावलो छे। (उत्पत्ती 1:26, निर्गमन 20:13) ");
INSERT INTO dhn_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","आरु तुमु फुलो–फलो, आरु वोदु, आरु कोळी पोर घोनसोटा ओवलियाद पोयदा कोरिन एरेम भोरय जावु (उत्पत्ती 1:28) ");
INSERT INTO dhn_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","ओळतेन परमेश्वर नुह आरु ओका पुर्या से कयो, ");
INSERT INTO dhn_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“सोमळु, हांव तुमरे साते आरु तुमरे वाद मा जी तुमरी ओवलियाद होयसे, ओका सात मा वी वायदु बाधो; ");
INSERT INTO dhn_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","आरु आखा जीवतला जीवो सी वी जे तुमरे साते छे काय चिल्‌ला काय पावन्या ढुरे काय कोळी क सब बनेले ढुरे, कोळी क जोतरा जिवजोनतु ढोन्ड्या सी निकोवला छे। ");
INSERT INTO dhn_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","आरु हांव तुमरे साते आपसु यु वायदु बांधो कि आखा जिव ओळतेन जळ–प्रलय सी नष्ट नी होयसे: आरु कोळी क नाश कोरने क लिय ओळी जळ–प्रलय नी होयसे।” ");
INSERT INTO dhn_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","ओळतेन परमेश्वर कयो, “जु वायदु हांव तुमरे साते, आरु जोतरा जिवतला जिवे तुमरे साते छे तेनु सब क साथ वी जोलोम जोलोम् क पीढ़ी क लिय बांधो, ओकी यी सोहलानी छे: ");
INSERT INTO dhn_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","हांव वादळा मा आपनु बाम मेकलु छे, चो मारे आरु कोळी क विच मा वाचा क सोहलानी रोहसे। ");
INSERT INTO dhn_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","आरु जोत्यार हांव कोळी पोर वादळो फेलावीस ती वादळा मा बाम देखा पोड़से। ");
INSERT INTO dhn_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ती मारी जी वाचा तुमरे आरु सब जिवतला डीलवाळा जीवो क सात बन्धी छे; उको हांव फोम राखीस, ती ओसो जळ–प्रलय ओळी नी होयसे जिनासी सब जिवो क विनाश होय। ");
INSERT INTO dhn_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","वादवा मा जो धनुष होयसे हांव तेनाक देखीन यो हमीशा फोम राखीस, जो परमेश्वर क आरु कोळी पोर सब जीवतला डीलोवाळा जिवे क विच वायदु छे।” ");
INSERT INTO dhn_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","ओळतेन परमेश्वर नुह सी कुयो, “जी वाचा हांव कोळी भोर क सब जिवो क सात मा बांदली छे, ओकी सोहलानी यी छे।” ");
INSERT INTO dhn_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","नुह क पुर्य जो ढोन्ड्या मा सी निकोळया चे, शेम, हाम आरु येपेत हुता; आरु हामु कनान का बाबो हुतो। ");
INSERT INTO dhn_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","नुह क तीन पुर्या येत छे, आरु ओकी ओवलियाद आखी कोळी पोर जात रोया। ");
INSERT INTO dhn_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","नुह जो एक किरसान हुतो, दाखन वाड़ी लगाड़ने वाळो पेहलो मानुस हुयो। ");
INSERT INTO dhn_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","आरु हुयो दाखमधु पीन छाक गुयो; आरु आपसा घोर धोड़्ये नांगरु हुय गोयु। ");
INSERT INTO dhn_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","ती कनान क बाबो हाम आपसा क नांगो देख्यो, आरु खोयड़े आवीन आपसा दुयो भाई क कय दिदो (लेव्यव्यवस्ता 20:13) ");
INSERT INTO dhn_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","ती शेम आरु येपेत दुयु छिंदरो लिन आपसा खांदा पोर मेल्या आरु पोछोळ फिरिन ओन्दा चलिन आपसा बास क नांगा क डील क ढाक दिदा, आरु चे आपसो मुख पोछोल कोरला हुता एकालीय हिये आपसा बाबा क नांगो नी देख्या। ");
INSERT INTO dhn_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","जोत्यार नुह क नशो उतरीयो गियो। ती हियो जान लियो कि ओको नानलो पुर्‌यो ओका सात मा काय कोरलो छे। ");
INSERT INTO dhn_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","एकालीय हियो कयो, “कनान शापित होये हियो आपसा भाय बोन्यान क दासो क दास होये।” ");
INSERT INTO dhn_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","ओळी हीयो कयो, “शेम का परमेश्वर योहोवा सोयाव्वु छे, आरु कनान शेम का दास होये। ");
INSERT INTO dhn_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","परमेश्वर येपेत क ओवलियाद क फेलावे; आरु हुयो शेम क तम्बुओं मा वोसे, आरु कनान ओको दास हुये।” ");
INSERT INTO dhn_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","जळ–प्रलय क वाद मा नुह तीन सोव पचास साल जीवतलो रयो। ");
INSERT INTO dhn_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","ओस कोरिन नुह क उमोर साढ़े नोव सोव साल हुयो; तेर वाद मा मोर गयो। ");
INSERT INTO dhn_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","नुह क पुर्या शेम, हाम, आरु येपेत हुता; हेरा पुर्या जळ–प्रलय क वाद मा पोयदा होयली; हेन्दरी ओवलियाद छे। ");
INSERT INTO dhn_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","येपेत क पुर्य : गोमेर, मागोग, मादे, यावान, तुबल, मेशेक, आरु तिरास हुए। ");
INSERT INTO dhn_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","गोमेर क पुर्य: अशकनज, रीपत, आरु तोगर्मा हुए। ");
INSERT INTO dhn_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","आरु यावान क ओवलियाद मा एलिशा, आरु तर्शीश, आरु कित्ति, आरु दोदानी लोग हुए। ");
INSERT INTO dhn_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","इनरी ओवलियाद अन्यजातियान क द्वीपों क देशोम मा ओसा वाटाय गोया की दिसरी त् बुली, कुलें आरु जाति क अनसारे आंगे आंगेय् होय गोया। ");
INSERT INTO dhn_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","हाम क पुर्या: कुश, मिसर, फुत आरु कनान हुया ");
INSERT INTO dhn_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","आरु कुश क पुर्या सबा, हवीला, सबता, रामा, आरु सबुतका हुया। आरु रामा क पुर्या शबा, आरु ददान हुया। ");
INSERT INTO dhn_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","कुश क ओवलियाद मा निम्रोद वी हुयो; कोळी पोर पेहलु ताकोतवाळु जीकन्यु हुयु। ");
INSERT INTO dhn_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","हीयु योहोवा की निंगा मा ताकोतवाळु शिकार खेलनेवाळु रोयु, इना सी यी कहावत चाल्ली छे; “निम्रोद क जोसो योहोवा की निमगा मा ताकोतवाळु शिकार खेलनेवाळो।” ");
INSERT INTO dhn_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","हेरा राज्य क शुरु शिनार देश मा बेबीलोन, एरेख, अक्कद आरु कलने से हुयो। ");
INSERT INTO dhn_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","हेना देश सी हुयो निकोळीन अश्शुर क गयो, आरु नीनवे, रहोबोतिर आरु कालह क, ");
INSERT INTO dhn_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","आरु नीनवे आरु कालह क वीच जो रेसेन छे, तेनाक वी वसाड़ीयो; मोटलो नोगोर योत छे। ");
INSERT INTO dhn_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","मिसर क ओवलियाद मा लुदी, अनामी, लहाबी, नप्तुही, ");
INSERT INTO dhn_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","आरु पत्रुसी, कसलुहि आरु कप्तोरी मानुस हुया, कसलुहीयो मा सी ते पलिश्ती मानुस निकोळ्या। ");
INSERT INTO dhn_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","कनान क ओवलियाद मा ओको मोटलो पुर्य सीदोन, तब हित्त, ");
INSERT INTO dhn_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","यबुसी, एमोरी, गिर्गाशी, ");
INSERT INTO dhn_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","हिव्वी, अर्की, सीनी, ");
INSERT INTO dhn_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","अर्वदी, समारी, आरु हमाती मानुस वी हुया; ओळतेन कनानी क कुल वी फेल गया; ");
INSERT INTO dhn_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","आरु कनानियो क सिंयो सीदोन सी लीन गरार क वाट क होईन अज्जा लोगुन आरु ओळतेन सदोम आरु अमोरा, गमोरा, आरु अदमा आरु सबोयीम क वाट सी होईन लाशा लोगुन होयी। ");
INSERT INTO dhn_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","हाम क ओवलियाद मा येत हुया, आरु ये भाति भातीन कुले, बुली, देशों आरु जाती क अनसारे आंगे आंगेय् हुय गोया। ");
INSERT INTO dhn_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","शेम, चू आखी एबेर ओवलियाद क खास मानुस होयु, आरु जु येपेत क मोटलो भाईष् हुतो, ओको बी पुर्‌यो हुयो। ");
INSERT INTO dhn_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","शेम क पुर्य: एलाम, अश्शुर, अर्पक्षद, लुद सीरिया आरु अराम हुया। ");
INSERT INTO dhn_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","अराम क पुर्य: ऊस हुल, गेतेर आरु मश हुया। ");
INSERT INTO dhn_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","आरु अर्पक्षद न शेलह क, आरु शेलह न एबेर क जोन्मो दिदा। ");
INSERT INTO dhn_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","आरु एबेर क दुय पुर्य पोयदा हुया, एक क नाव पेलेग ओतरान कोरता राख्या की तीनु दाहड़ा मा कोळी वाटाय गोयली, आरु ओका भाईष् क नाव योक्तान हुतो। ");
INSERT INTO dhn_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","आरु योक्तान न अल्मोदाद, शेलेप, हसर्मावेत, येरह, ");
INSERT INTO dhn_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","यदोरवाम, ऊजाल, दिक्ला, ");
INSERT INTO dhn_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ओबाल, अबीमाएल, शबा, ");
INSERT INTO dhn_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ओपीर, हवीला आरु योबाब क जोन्मो दिदा: येत आखो योक्तान क पुर्य हुया। ");
INSERT INTO dhn_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","इनदरो रोयने क जागो मेशा सी लागाड़ीन सपारा, जो उगेवनो मे एक बोयड़ो छे, तेने वाट्ये लोगुन हुयो। ");
INSERT INTO dhn_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","शेम क पुर्य येत हुया: आरु ये भाति भातीन कुले, बुली, देशों आरु जातीयां क अनसारे आंगे आंगेय् होय गुया। ");
INSERT INTO dhn_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","नुह क पोर्या क घोराने योत छे: आरु ओकी जाति क ओनसारे ओकी ओवलियाद यित छे; आरु जळ–प्रलय क वाद कोळी भोरीन जाती एनु मा होईन वाटाय गोय। ");
INSERT INTO dhn_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","आखी कोळी पोर एकुत भाषा आरु एकुत बुली होती। ");
INSERT INTO dhn_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","तेन टेम मानुस उगेवना भिनी जाता हुता शिनार देश मा एक खोयड़ु जोड़्यु चां वोस गोया। ");
INSERT INTO dhn_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","तोत्यार चे हियेत कोहने लग्या, “चालु, आपनु ईटड़ा बोना बोनईन वारु पाकाड़ता।” आरु चे दोगड़ान जागे ईटड़ा सी आरु चूना क जागा पोर धूळा क गारो सी काम लिदा। ");
INSERT INTO dhn_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","ओळतेन हिये कोया, “चालु, आपनु एक नगर आरु एक गुम्मट बोनावता, तेरी चोटी आकाश सी वात कोरे, ओसा कोरीन आपनु म्हारो नाळ कोरजे। ओसो नी होये की आपनु क आखी कोळी मा वेरवायनो पोड़ जाय।” ");
INSERT INTO dhn_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","जोत्यार मानुस नगर आरु गुम्मट बोनावने लग्या, ती हीनुक देखने योहोवा उतरीन आयु। ");
INSERT INTO dhn_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","आरु योहोवा कयो, “हांव काय देखो की आखा एकुत दल मा छे। आरु बुली वी इनु आखान एकुत छे, आरु हियो ओसो काम शुरु कर दिदा; आरु हिमी जो काय कोरनेन क यत्न कोरसे, एरेमा काय वी इनदरे वाटू वातड़ो नी होयसे। ");
INSERT INTO dhn_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","ओतरान कोरिन आवु, आपनु उतरीन इन्दरी बुली मा गोड़बोड़ी कोरता, तेरे सी एक दिसरा क बुली क पोल्ले नी पोड़ सोके।” ");
INSERT INTO dhn_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","ओस कोरिन योहोवा ओकी होंया सी आखी कोळी उपोर फैला दिदो: आरु हिये उना नोगोर क बनावनो छुड़ दिदा। ");
INSERT INTO dhn_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","ओस कोरीन हिना नोगोर क नाव बेबीलोन पोड़्यो; काहकी आखी कोळीक बुली मा जी गोड़बोड़ी छे, ची योहोवा हीयांत नाखलु छव, आरु हियांत सी योहोवा मानुसक आखी कोळी क उपोर फैलाय दीदो। ");
INSERT INTO dhn_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","शेम कि ओवलियाद छे। जळ–प्रलय क दुय साल क वाद जोत्यार शेम एक सोव साल क हुयो, ती हिना सी अर्पक्षद क जोन्मो हुयो; ");
INSERT INTO dhn_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","आरु अर्पक्षद क जोन्म क वाद मा शेम पांच सोव साल जिवत्लु रोयु; आरु ओकी आरु वी पुर्या पुरायटा पोयदा हुया। ");
INSERT INTO dhn_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","जोत्यार अर्पक्षद पोयतीस साल क हुयो, ती हिना सी शेलह क जोन्मो हुयो; ");
INSERT INTO dhn_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","आरु शेलह क जोन्म क कवाद मा अर्पक्षद चार सोव तीन साल आरु जीवत्लो रोयो, आरु ओकी आरु वी पुर्या पुरायटा पोयदा हुया। ");
INSERT INTO dhn_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","जोत्यार शेलह तीस साल क होयो, ती ओको द्वारा एबेर क जोन्मो होयो; ");
INSERT INTO dhn_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","आरु एबेर क जोन्म क वाद मा शेलह चार सोव तीन साल आरु जीवत्लो रोयो, आरु ओकी आरु वी पुर्या पुरायटा पोयदा हुया। ");
INSERT INTO dhn_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","जोत्यार एबेर चोवतीस साल क हुयो, ती ओको द्वारा पेलेग क जोन्म हुयो; ");
INSERT INTO dhn_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","आरु पेलेग क जोन्म क वाद मा एबेर चार सोव तीस साल आरु जीवत्लो रोयो, आरु ओकी आरु वी पुर्या पुरायटा पोयदा हुया। ");
INSERT INTO dhn_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","जोत्यार पेलेग तीस साल क हुयो, ती ओको द्वारा रु क जोन्मो हुयो; ");
INSERT INTO dhn_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","आरु रु क जोन्म क वाद मा पेलेग दो सोव नोव साल आरु जीवत्लो रोयो, आरु ओकी आरु वी पुर्या पुरायटा पोयदा हुया। ");
INSERT INTO dhn_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","जोत्यार रु बोत्तीस साल क हुयो, ती ओको द्‍वारा सरुग क जोन्मो हुयो; ");
INSERT INTO dhn_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","आरु सरुग क जोन्म क वाद मा रु दो सोव सात साल आरु जीवत्लो रोयो, आरु ओकी आरु वी पुर्या पुरायटा पोयदा हुया। ");
INSERT INTO dhn_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","जोत्यार सरुग तीस साल क हुयो, ती ओको द्वारा नाहोर क जोन्मो हुयो; ");
INSERT INTO dhn_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","आरु नाहोर क जोन्मो क वाद मा सरुग दो सोव साल आरु जीवत्लो रोयो, आरु ओकी आरु वी पुर्या पुरायटा पोयदा हुया। ");
INSERT INTO dhn_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","जोत्यार नाहोर उनतीस साल क हुयो ती ओको द्वारा तेरह क जोन्मो हुयो; ");
INSERT INTO dhn_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","आरु तेरह क जोन्म क वाद मा नाहोर एक सोव उन्नीस साल आरु जीवत्लो रोयो, आरु ओकी आरु वी पुर्या पुरायटा पोयदा हुया। ");
INSERT INTO dhn_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","जोत्यार लोगुन तेरह सोत्तोर साल क हुयो, ती लोगुन ओको द्वारा अब्राम आरु नाहोर आरु हारान पोयदा हुया। ");
INSERT INTO dhn_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","तेरह क ओवलियाद यी छे। तेरह अब्राम, नाहोर आरु हारान क जोन्मो हुयो; आरु हारान सी लुत क जोन्मो हुयो। ");
INSERT INTO dhn_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","हारान आपसा बाबा तेरह क सामनेत कसदियो क ऊर नावोन नोगोर मा, जो ओकी पोयदा होयनेन जागु होतु, मोर गोयु। ");
INSERT INTO dhn_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","अब्राम आरु नाहोर दुयु ईयाव कोर्या। अब्राम क लाड़ी क नाव सारै आरु नाहोर क लाड़ी क नाव मिल्का हुतो। यी हारान क बेटी होतली, जी मिल्का आरु यिस्का दुयो क बाबो हुतो। ");
INSERT INTO dhn_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","सारै ते वान्टी होती; ओकी ओवलियाद नी होयी। ");
INSERT INTO dhn_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","तेरह आपसा पुर्य अब्राम, आरु आपसा पोता लुत, जौ हारानक पुर्य हुतो, आरु आपसी उहड़ीस सारै, जौ ओकी अब्राम क लाड़ी हुती, इनु आखा क लीन कसदियोम क ऊर नोगोर सी नीकोळीन कनान देश जाने कोरिन गोयु; बाखुन हारान नावोन देश मा पुगीन हीयांत रोहने लाग्यु। ");
INSERT INTO dhn_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","जोत्यार तेरह दो सोव पांच साल क हुयो; ती हुयो हारान देश मा मोर गोयो। ");
INSERT INTO dhn_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","योहोवा अब्राम सी कयो, आपना देश, आरु तारा घोरल्याक, आरु तारा बाबा क घोर छुड़ीन उना देश मा चाल जो हांव तुखे देखाड़ीस। (प्रेरित 7:2-3, इब्रानियो 11:8) ");
INSERT INTO dhn_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","आरु हांव तार सी एक मोटली जाति बोनावीस, आरु तुखे बोरकोत आपीस, आरु तारो नाव मोटो कोरीस, आरु तु बोरकोत क मुल रोहीस। ");
INSERT INTO dhn_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","जो तुखे बोरकोत आपे, तेनाक मे बोरकोत आपीस, आरु जु कुदु वेला पाड़से, तेनाक हांव शाप आपीस; आरु कोळी क आखा कुल तारे लारे बोरकोत पावसे (गलातियो 3:8) ");
INSERT INTO dhn_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","योहोवा क इना बुलो क अनसारे अब्राम चाल्यो, आरु लुत वी ओका सात मा‍ चाल्यो; आरु जोत्यार अब्राम हारान देश सी निकोळ्यो तेन टेमे हुयो पचहत्तर साल क हुतो। ");
INSERT INTO dhn_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","ओस कोरीन अब्राम हेरी लाड़ी सारै, आरु हेरा भोतेरज्यास लुत क, आरु जो धोन हुयो एकठो कोर्‌यो हुतो, आरु ढुरे हुयो हारान मा जोड़्ला हुता, आखाक लीन कनान देश मा जाने क निकोळी गयो; आरु हुये कनान देश मा आय गुया। ");
INSERT INTO dhn_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","तेना देश क विचो सी जाता होता अब्राम शकेम मा, चां मोरे क बांज झाड़ छे, पुग्या। तेन टेमे हिना देश मा कनानी मानुस रोहता हुता। ");
INSERT INTO dhn_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","ओळतेन योहोवा अब्राम क दर्शन आपिन कयो, “यो देश मे तारा ओवलियाद क आपीस।” आरु हुयो चां योहोवा क लिय, जो हेनाक दर्शन आप्यो हुतो, एक वेदी बनायो। (गलातियो 3:16, प्रेरित 7:5) ");
INSERT INTO dhn_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","ओळतेन होयां सी ओगा बोड़ीन होया तेना बोयड़ा पोर आया, जु बेतेल क उगेवनो भीनी छे, आरु हिन्दरो तंबु हेना जागा मा उबो किया जिना बुडेवनो भिनी बेतेल आरु उगेवनो भीनी ऐ छे। चां वी हुयो योहोवा क लिय एक वेदी बनायो आरु योहोवा सी विनता करीयो। ");
INSERT INTO dhn_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","आरु अब्राम ओगु जाईन कनान दोखेवरे देश भीनी जात रोयो। ");
INSERT INTO dhn_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","तेना देश मा काळ पोड़्यु: ओतरान कोरिन अब्राम मिसर देश मा जात रोयु की चां जाईन पोरदेशी बोनीन रोहे काहकी देश मा घोन जोबोर काळ पोड़लो हुतो। ");
INSERT INTO dhn_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","ओळतेन ओसो हुयो की मिसर क धोड़े पुगीन, हुयो हेरी लाड़ी सारै सी कयो, सोमोळ, मेखे मालुम‍ छे की तु घोन घाटावी बयोर छे; ");
INSERT INTO dhn_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","आरु जोत्यार मिसरी लोगहन तुखे देखसे ती कोवसे, यी हेरी लाड़ी छे, ओतरान कोरिने हीये मेखे मार नाखसे, बाखुन तार पोर जीती राख लेसे। ");
INSERT INTO dhn_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","ती: यो कोहजी, मे एरी बोहनीस छे, जिना सी तारे लारे मारो वी भलो होये, आरु मारु जीव तारे लारे वाचसे (उत्पत्ती 20:2, 26:7) ");
INSERT INTO dhn_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","ओळतेन ओसो हुयो की जोत्यार अब्राम मिसर मा आयो, ती मिसरी मानुस हेरी लाड़ीक देख्या की हीयी घोन घाटावी छे। ");
INSERT INTO dhn_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","आरु फिरोन क मुखी ओको देखीन फिरोन क सामने ओकी तारीफ कोर्या; ओतरान कोरिन हुयी बायर फिरोन क घोर मा पुगाड़ दिदा। ");
INSERT INTO dhn_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","आरु फिरोन हेरेन कोरीन अब्राम क भोलो हुयो; आरु ओको गाडरा बुकड़ा, गाय बुईल, दास दासीया, गदड़ा गोदड़ीया, आरु उटड़ा वी जोड़या। ");
INSERT INTO dhn_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","बाखुन योहोवा फिरोन आरु ओका घोराना पोर, अब्राम क लाड़ी सारै क कारण मोटी मोटी पिड़ा नाख्यु। ");
INSERT INTO dhn_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","ती फिरोन अब्राम क बुलावीन कयो, “तु मार साते काय कोर्यु? तु मेसे काहा नी कोयु की यी मारी लाड़ी छे? ");
INSERT INTO dhn_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","तु काहा कोयु की यी मारी बोहनीस छे? हांव हेनी काजे मारी लाड़ी बोनावने क लिय लेदु; बाखुन हीमी तारी लाड़ीक लीन यां गोथू जात रोव।” ");
INSERT INTO dhn_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","आरु फिरोन न आपसा मानषो क ओका वारा मा हुकुम आप्यु आरु हुये ओको आरु ओकी लाड़ी क, आखी धोनो भेव जी हेरी होती, मुकली देदा। ");
INSERT INTO dhn_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","तोत्यार अब्राम हेरी लाड़ी आरु आपसी आखी जायदाद लीन, लुत काजे वी पुठी लीन, मिसर काजे छुड़ीन कनान क दोखेवरे देश मा आया। ");
INSERT INTO dhn_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","अब्राम गाडरा बुकड़ा, गाय बुईल, आरु सोना रिपिया क मोटो धनी हुतो। ");
INSERT INTO dhn_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","ओळतेन हेना दोखेवरे देश गोथा बेतेल क पास तेनात जागा मा पुग्या, जां पेहले हुयो हेरु तंबु उबो करीयो हुतो, जो बेतेल आरु ऐ क वीच मा छे। ");
INSERT INTO dhn_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","यु जागु तेनी वेदी क छे, जु हीयु पेहले बनायो हुतो; आरु होयां अब्राम ओळी योहोवा सी विनता कोर्‌यो। ");
INSERT INTO dhn_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","लुत क पास वी, जु अब्राम क सात मा चालतो हुतो, गाडरा बुकड़ा, गाय बुईल, आरु तंबु हुतो। ");
INSERT INTO dhn_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","ओतरान कोरिन हीना देश मा हीनु दुय क लिय पुरतु जागु नी होतु क हुये एकठा रोय सोके; काहकी हीन्दरे जुळ घोन सोंटो धोन हुतो ओतरान कोरिन हीये एकठा नी रोय सोकतला। ");
INSERT INTO dhn_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","अब्राम आरु लुत क गाडरा बुकड़ा आरु गाय बुईल क गुवाळ्या मा झगड़ो हुयो। तेन टेमे कनानी आरु परिज्जी मानुस उना देश मा रोहता हुता। ");
INSERT INTO dhn_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","अब्राम लुत सी कोहने लाग्यो, मारा आरु तारा वीच, आरु मारा आरु तारे गुवाळ्या क वीच मा झगड़ो नी होयनो जुवे; काहकी आपनु भाई बन्धु छे। ");
INSERT INTO dhn_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","काय आखो देश तारे सामने नी? ओतरान कोरिन मार सी ओलोग हुय जा; बाखुन तु डाख्र्यु जाउ ती मे जेवड़ु जाईस; आरु तु जेवड़ु जाय ती मे डाख्र्यु जाइस ");
INSERT INTO dhn_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","ती लुत डुळा उचाकोरीन, यरदन नदी क पास वाली आखी तराई क देख्यो कि हियी आखी सिंचली छे। जोत्यार लोगुन योहोवा न सदोम आरु गमोरा क नष्ट नि करीयो हुतो, तित्यार लोगुन सोअर क वाट तक हियी तराई योहोवा की वाटिक, आरु मिसर देश क जोसो उपजाऊ हुती। (उत्प. 20:10) ");
INSERT INTO dhn_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","ओतरान कोरिन लुत हेरे लिय यरदन क आखी तराई क नेवाड़ीन उगेवनो भीनी चाल्यो, आरु हुये एक दिसरा सी ओलोग हुय गोया। ");
INSERT INTO dhn_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","अब्राम कनान देश मा रोयो, लुत तेनी तराई क नोगोर मा रोहने लाग्यो; आरु आपसो तंबु सदोम क धोड़े उबो कोर्‌यो। ");
INSERT INTO dhn_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","सदोम क मानुस योहोवा क लेखा मा मोटा दुष्ट आरु पापी हुता। ");
INSERT INTO dhn_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","जोत्यार लुत अब्राम सी ओलोग हुय गोयो तेरे वाद मा योहोवा अब्राम सी कयो, “डुळा उचा कोरीन जेना जागा पोर तु छे चां सी दोखेवरे बोखेवरो, उगेवनो बुडेवनो, च्यारु मेर निगा कोर। ");
INSERT INTO dhn_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","काहकी जोतरु जागु तुसे देखा पोड़े हेना सब क मे तुसे आरु तारा ओवलियाद क जोलोम् जोलोम क लिय आपीस। (प्रेरित 7:5) ");
INSERT INTO dhn_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","आरु हांव तारा ओवलियाद क कोळी क धूवा क किनका क समान घोना कोरीस, या तोक की जौ कुदु कोळी क धुवु क किनका क गिन सोके तोसो तारा ओवलियाद वी गिन सोकसे। ");
INSERT INTO dhn_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","उठ, एना देश क नाम्बाय आरु चोड़ाई मा चाल फिर, काहकी हांव तेनाक तुसे आपीस।” ");
INSERT INTO dhn_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","एरे वाद अब्राम आपस तंबु उखावीन, मम्रे क वांजिया झाड़ क वीच जी हेब्रोन मा हुता, जाईन रोहने लाग्या; आरु होया वी योहोवा क एक वेदी बनायो। ");
INSERT INTO dhn_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","शिनार ज राजा अम्रापेल, आरु एल्‌लासार क राजा अर्‌योक, आरु एलाम क राजा कदोर्लाओमेर, आरु गोयीम क राजा तिदाल क दाहड़ा मा ओसो हुयो, ");
INSERT INTO dhn_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","कि हुये सदोम क राजा बेरा, आरु गमोरा क राजा बिर्शा, आरु अदमा क राजा शिनाब, आरु सबोयीम क राजा शमेबेर, आरु बेला जो सोअर वी कोवाये। ");
INSERT INTO dhn_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","ये पांचू सिद्दीम नावोन तराई मा, जो खारा ताल क धोड़े छे, एका कोर्‌यो। ");
INSERT INTO dhn_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","बारे साल लोगुन ते ये कदोर्लाओमेर क हको तळे रोया; बाखुन तेरे साल मा ओका खिलाफ विद्रोहन काम कोर्‌यो। ");
INSERT INTO dhn_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","चोदवां साल मा कदोर्लाओमेर आरु ओका साती राजा आए, आरु अशतरोत्कनम मा रपाय क, आरु हाम मा जुजियो क, आरु शाबे किरयातेम मा एमियो क, ");
INSERT INTO dhn_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","आरु सेईर नावोन क बोयड़ा पोर होरीयो क कुटता कुटतात् तेना एल्पारान लोगुन जो जोंगोल क धड़े छे, पुग गया। ");
INSERT INTO dhn_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","होंया गोथा पोछा आवीन एन्मिशपात क आया, जो कादेश वी कोवाये, आरु अमालेकियो क आखा देश क आरु तेना एमोरिया क वी जीत लियो, जो हससोन्तामार मा रोहता हुता। ");
INSERT INTO dhn_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","ती सदोम, गमोरा, अदमा, सबोयीम, आरु बेला, जो सोअर वी कवाये, इन्दरु राजा निकले आरु सिद्दीम नावोन तराई मा उना सात लोड़ाय क लिय पाति बान्दया: ");
INSERT INTO dhn_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","अर्थात एलाम क राजा कदोर्लाओमेर, गोयीम क राजा तिदाल, शिनार क राजा अम्रापेल, आरु एल्‌लासार क राजा अर्‌योक, इनु च्यारु क विरुद चे पांचू मेवीन पाति बान्दया। ");
INSERT INTO dhn_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","सिद्दिम नावोन तराई मा जा लसार धुळा क खाड़ात खाड़ा हुता; सदोम आरु गमोरा क राजा ढास ढासता तेनुमा हीट पोड़्या, आरु जे वाच्या चे बोयड़ा पोर ढास गया। ");
INSERT INTO dhn_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","ती चे सदोम आरु गमोरा क आखो धोन आरु खानेन सोमान क लुट लुटीन जात रोया। ");
INSERT INTO dhn_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","आरु अब्राम क भतीजो लुत, जो सदोम मा रोहतो हुतो, तेरो वी धोन लिन जात रोया। ");
INSERT INTO dhn_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","ती एक जोनु जु ढासीन वाच नीकोळ्यो हुतो हुयो जाईन इब्री अब्राम क खोबोर आप्यो; अब्राम ते एमोरी मम्रे, जो एश्कोल आरु आनेर क भाईष् हुतो, ओका बांज झाड़ क वीच मा रोहतो हुतो; आरु ये मानुस अब्राम क सात मा वायदु बांधला हुता। ");
INSERT INTO dhn_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","यो सोमळीन कि ओको भतीजो धोराय गयो, अब्राम हेरा तीन सोव ओठारे भोनला, वार लोड़ायने मा पाका दासो क लीन जो ओको कुटुम्ब मा पोयदा हुया होता, होतीयार लीन दान लोगुन हिन्दरे पोछोळ पोड़्या; ");
INSERT INTO dhn_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","आरु रात क आपसा दास क आंगे आंगेय् दल बांधीन उन पोर होमलु कोरीन तेनुक मार लेदा आरु होबा लोगुन, जो दमिश्क क उत्तर की भेनी छे, तिन्दरे पोछोळ पोड़्या। ");
INSERT INTO dhn_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","आरु हुये आखो धन क, आरु आपसा भोतीजे लुत आरु ओको धोन क, आरु बायराक, आरु सब धोरायला क पोछा ली आया। ");
INSERT INTO dhn_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","जोत्यार हुये कदोर्लाओमेर आरु ओका साती राजा क जितीन पोछा आवता हुता ती सदोम क राजा शावे नावोन तराई मा, जु राजा क तराई वी कोवायतली, तेनासी मेवने कोरिन आयो। ");
INSERT INTO dhn_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","ती शालेम क राजा मलिकिसिदक, जु ईश्वर क मोटलो याजक हुतो, रुटू आरु दाखमधु ली आयो। (इब्रा. 7:1-10, भजन 110:4) ");
INSERT INTO dhn_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","आरु हुयो अब्राम क यो बोरकोत आप्यो, “मोटला भोगवान भिनी गोथो, जु आकाश आरु कोळ क आधिकारी छे, तु सोयाव्वु होये। ");
INSERT INTO dhn_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","आरु सोयाव्वु छे मोटलु भोगवान, जिनासी तारा वेरी क तारा वश मा कोर देदो।” ती अब्राम ओको आखा सामानोन दशमांश आप्यो। ");
INSERT INTO dhn_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","ति सदोम क राजा अब्राम सी कयो, “जीवे क तो मेखे आप, आरु धोन क आपसे पास राख।” ");
INSERT INTO dhn_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","अब्राम सदोम क राजा सी कयो, “मोटलु भोगवान योहोवा, आकाश आरु कोळी क आधिकारी छे, ");
INSERT INTO dhn_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ओकी मे शपथ खाम, कि जो काय तारो छे तेना सी नी ते हांव ककय वी, आरु नी खासड़ा क बोन्दे, नी काय आरु चीज नीकावो की तु ओसु नी कोहने बाजजाय की अब्राम मारेत लारे लोगपोती होयलु छे। ");
INSERT INTO dhn_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","बाखुन जो काय ईनु जुवान्या खाय लेदला छे, आरु इना वाटा, जे मारे साते गोयला छे अर्थात् आनेर, एश्कोल, आरु मम्रे, हांव नी पोछु आवो, चे ते आपसु त् वाटू राख लेये तोसे।” ");
INSERT INTO dhn_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","इनी वातो क वाद मा योहोवा क यो बुल दोर्शोन मा अब्राम क पास मा पुग्यो : “हे अब्राम, मा बिहये; तारी ढाल आरु तारो घोनो मोटो फोव मे छे।” ");
INSERT INTO dhn_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","अब्राम कयो, “हे भोगवान योहोवा, हांव ते निर्ओ ओवलियाद छे, आरु मारा घर क वारिस ये दमिश्कवासी एलीएजेर रोहसे, अत: तु मेसे काय आपीस?” ");
INSERT INTO dhn_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","आरु अब्राम न कयो, “मक क तु ओवलियाद नी दियो, आरु काय देखो की मारे घोर मा पोयदा होयलो एक जन मारो वारीस रोहसे।” ");
INSERT INTO dhn_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","ति योहोवा क यो बुल ओका पास मा पुग्यो, “यो तारो वारिस नो रोहसे, तारो जो निज पुर्यु रोहसे, वही तारो वारीस रोहसे।” ");
INSERT INTO dhn_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","आरु हुयो ओको खोयड़े लिजाईन कयो, “वादळा भीनी नीगाह नाखीन तारागण क गिन, काय तु ईनुक गिन सोके काय?” ओळतेन हुयो हेनाक कयो, तारा ओवलियाद वी ओसा रोहसे (रोम. 4:18, इब्रा. 11:12) ");
INSERT INTO dhn_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","हुयो योहोवा पोर विश्वास करीयो; आरु योहोवा न इनी वार क ओका लेखा मा धर्म गिन्यो (रोम. 4:3, गला. 3:6, याकुब 2:23) ");
INSERT INTO dhn_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","ती हुयो हिनासी कयो, “हांव वही योहोवा छे जु तुखे कसदियो क ऊर नोगोर सी खोयड़े ली आवलु, की तुसे एना देश क होक आपो।” ");
INSERT INTO dhn_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","चो कयो, “हे भोगवान योहोवा, हांव कोसु जानो कि हांव एरु होकदार्यु होईस?” ");
INSERT INTO dhn_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","योहोवा अब्राम सी कयो, “मारे जुगु तीन साल क एक कलोर, आरु तीन साल एक बुकड़ो, आरु तीन साल क एक गाडरा, आरु एक पिण्डुक आरु एक पेरवा क पिलो लीले।” ");
INSERT INTO dhn_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","ईनु आखा क लीन हुयो तिन्दरो वीच मा दी दुय टुकड़ा कोर दिदो, आरु टुकड़ा क आम्बा–साम्बा मेक दिदो; बाखुन चिल्‌ला क हुयो टुकड़ा नी करीयो। ");
INSERT INTO dhn_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","जोत्यार मासवाळा चिल्‌ला लोथो पोर आय लाग्या, ती अब्राम न ओको उड़ाय दिदो। ");
INSERT INTO dhn_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","जोत्यार दाहड़ु डूबने लाग्यु, ती अब्राम क बेसकी नींद आवी; आरु देखु, बेसकी बीक आरु घोने जोबोर आतंक होय गोयो (अय्युब 4:13-14) ");
INSERT INTO dhn_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","बती योहोवा न अब्राम सी कयो, “यो खोरी जान की तारा ओवलियाद पारका देश मा वी हुलक्र्या बोनीन रोहसे, आरु तेना देश क मानुषो क दास हुय जासे; आरु हुये चे ओको चार सोव साल लोगुन वेला पाड़से ( निर्ग. 1:1-14, प्रेरि. 7:6) ");
INSERT INTO dhn_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","ओळतेन जिना देस क हुये दास होयसे तेनाक मे डोन आपीस आरु ओका वाद मा मोटो धोन चा गोथू लिन निकोळी जाइस (निर्ग. 12: 40-41, प्रेरि. 7:7) ");
INSERT INTO dhn_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","तु ते आपसा पितरों मा कुशल क सात वारु मिळ जाईस; तुखे आखा डाहवारा मा धुळु आपसे। ");
INSERT INTO dhn_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","बाखुन हुये चोथी पीढ़ी मा यां ओळी आवसे: काहकी हिमी लोगुन एमोरिया क ओधोरोम पुरो नी होयलो छे।” ");
INSERT INTO dhn_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","आरु ओसो होयो कि जोत्यार दाहड़ु बुड गोयु आरु घोनो आंधारो होय गोयो, ती एक अंगीठी जीना सी धूवाडू निकवतलु आरु एक धोपोतली मशाल देखा पोड़ी जी तेना भुकरा क वीच मा होईन निकोळी गोय। ");
INSERT INTO dhn_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","इने दाहड़े योहोवा न अब्राम क सात मा वायदु बांध्यु, “मिसर क महनद से लीन परात नावोन मोटली नद लोगुन जोतरा देश‍ छे (प्रेरि. 7:5) ");
INSERT INTO dhn_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","अर्थात केनियो, कनिज्जियो, कदमोनियो, ");
INSERT INTO dhn_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","हित्तीयो, परिज्जियो, रपायो, ");
INSERT INTO dhn_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","एमोरियो, कनानियो, गिर्गाशियो आरु यबुसियो क देश हांव तारा ओवलियाद क आपलो छे।” ");
INSERT INTO dhn_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","अब्राम क लाड़ी सारै क कोय ओवलियाद नी होती। ओकी हाजिरा नाव क एक मिसरी दासी होती। ");
INSERT INTO dhn_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","सारै ने अब्राम सी कोहि, “देख, योहोवा न तो मारी कुख बोन्द राखली छे, ओतरान कोरिन हांव तार सी विनत कोरो कि मारी दासी क पास जा; सम्भव छे की मारो घोर ओके द्वारा बोस जाय।” सारै क यी वात अब्राम न मान लिदो। ");
INSERT INTO dhn_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","ओतरान कोरिन जोत्यार अब्राम क कनान देश मा रोहता दोस साल वित गोया ती ओकी लाड़ी सारै न आपसी मिसरी दासी हाजिरा क लीन आपसा घोरवाळा अब्राम क आपी, की हुयी हेरी लाड़ी होये। ");
INSERT INTO dhn_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","हुयो हाजिरा क पास मा गयो, आरु हुयी भारेपाये हुयी, ती हुयी जानी कि हांव भारपाये छे, ती हुयी आपसी स्वामिनी काजे तुच्छ निगाह से देखने बाज गोय। ");
INSERT INTO dhn_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","ती सारै न अब्राम सी कोहि, “जो मार पोर झगड़ो करावनो होयो चो तारात मुनका पोर होये। मे ते आपसी दासी क तारी लाड़ी कोर देदी; बाखुन हुयी जानी कि हांव भारपाये छे, ती मेखे वीटोळ जानने लाग गोय; ओतरान कोरिन योहोवा मारे आरु तारे वीच मा नियाव कोरे।” ");
INSERT INTO dhn_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","अब्राम न सारै सी कयो, “देख, तारी दासी तारा होको मा छे; जोसो तुखे वारु लागे तोसोत हेरे पुठी कोर।” ती सारै हेनीक वेला आपने वाज गोय, आरु हुयो हेरे सामने सी ढास गोय। ");
INSERT INTO dhn_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","ती योहोवा क दुत न ओको जोंगोल मा शुर क वाट्ये पोर पानीन झोरोन चा देखिन कोयो, ");
INSERT INTO dhn_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","हे सारै क दासी हाजिरा, तु कां गोथी आवी आरु कां जाय रोय; हुयी कोहि, “हांव मारी स्वामिनी सारै क सामने सी ढासीन आय रोय।” ");
INSERT INTO dhn_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","योहोवा क दुत न हेनी सी कयो, “आपसी स्वामिनी क पास म पोछी जा आरु ओका होको मा रोव।” ");
INSERT INTO dhn_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","आरु योहोवा क दुत ओको यो वी कयो, “मे तारी ओवलियाद क ओळी वोदाड़ीस, या तोक की घोनसोटा की गिनाये नि सोके।” ");
INSERT INTO dhn_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","आरु योहोवा क दुत हेनी सी कयो, देख, तु भारपाये छे, आरु पुर्य होयसे; तु ओको नाव इश्माएल राखजी, काहकी योहोवा न तारा दुख क हाल सोमळी लेदलो छे। ");
INSERT INTO dhn_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","आरु हुयो मानुस बनेले गदड़ा क जोसो होयसे, ओको हात सब क विरुद्ध उठसे आरु सब क हात ओका विरुद्ध मा उठसे; आरु हुयो आपसा सब भाई–बोन्या क वीच मा रोहसे। ");
INSERT INTO dhn_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","ती हुयो परमेश्वरन नाव जो हेना सी वात कोर्‌यो हुतो अत्ताएलरोई राखी कयो, “काय मे या वी ओको जातला देखिस आरु देखने क वाद मा जिवतली रोहिस?” ");
INSERT INTO dhn_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","ओस कोरिन तेना कुवा क नाव लहेरोई कुवो पोड़्यो; होयो ते कादेश आरु बेरेद क विच मा छे ");
INSERT INTO dhn_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","हाजिरा क अब्राम क द्वारा एक पुर्य होयो; आरु अब्राम न आपसा पुर्या क नाव, जो हाजिरा पोयदा कोरी, इश्माएल पाड़्यु। (गला. 4:22) ");
INSERT INTO dhn_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","जोत्यार हाजिरा न अब्राम क द्वारा इश्माएल क जोन्म देदी तेन टेमे अब्राम छियासी साल क थो। ");
INSERT INTO dhn_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","जोत्यार अब्राम एक कोम सोव सालोन होय गयो, ति योहोवा न ओको दर्शन दिन कयो, हांव सर्वशक्तिमान ईश्वर छे; मारी हाजरी मा चाल आरु खोरु होयतु जा। ");
INSERT INTO dhn_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","हांव तारे साते वायदु बान्दीस, आरु तारा ओवलियाद क बेस वोदाड़ीस। ");
INSERT INTO dhn_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","ती अब्राम मुयोन भुरसे हिट पोड़्यु: आरु परमेश्वर हेना सी होसुत वात कोतु रोयु, ");
INSERT INTO dhn_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","देख, मारु वायदु तारा सात मा बान्दायलु रोहसे, ओतरान कोरिन तु जाति क टुळा क मुलपिता होय जाईस। ");
INSERT INTO dhn_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","ओतरान कोरिन हीमी गोथो तारो नाव अब्राम नी रोहसे, बाखुन तारो नाव अब्राहम होयसे; काहकी मे तुखे जातियो क टुळा क मुलपिता बोनाय देदलु छे। (रोम. 4:17) ");
INSERT INTO dhn_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","हांव तुखे घोनु फलवन्त कोरिस, आरु तुसेक जाति जातिन मुल बनाय दिस, आरु तारा ओवलियाद म राजा पोयदा होयसे। ");
INSERT INTO dhn_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","आरु हांव तारे पुठी, आरु तारा वाद की पीढ़ी पीढ़ी लोगुन तारा ओवलियाद क सात वी इने आशय क जोलोम जोलोमन वायदु बान्धो, की मे तारे आरु वाद क तारा ओवलियाद क वी परमेश्वर रोहिस। (लुका 1:55) ");
INSERT INTO dhn_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","आरु हांव तुखे, आरु तारा वाद तारा ओवलियाद क वी, यो आखो कनान देश जेनामा तु हुलक्र्यु होईन रोहतलु, इने रिते आपीस कि चो होमीशा–होमीशा ओकी घोरुन जागु रोहसे, आरु हांव हेन्दरु परमेश्वर रोहिस (प्रेरि. 7:5) ");
INSERT INTO dhn_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","ओळतेन परमेश्वर न अब्राहम सी कयो, “तु वी मारा सात बान्दली वाचा क पाळ्या कोरजी। ");
INSERT INTO dhn_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","मारे साते बान्दली वाचा, तेरो पाळन तुसे आरु तारा वाद क तारा ओवलियाद क कोरनो पोड़से, ची यी छे : तुमरे मा सी एक एक मानुसक खतनो होये (रोम. 4:11, प्रेरि. 7:8) ");
INSERT INTO dhn_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","तुमु आपनी आपनी खालड़ी क खतनो कोराय लेजु : जु वाचा मारे आरु तुमरे विच मा छे, तेरो यो सोहलानी होयसे। ");
INSERT INTO dhn_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","पीढ़ी पीढ़ी मा केवल तारा ओवलियाद काज मानुस नी बाखुन जु तारे घोर पोयदा होयला छे, अथवा परदेशियो सी पोयस्‌या आपीन मुले लि लेजु। ");
INSERT INTO dhn_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","जु तारा घोर मा पोयदा होये, अथवा तारा पोयस्‌या सी मुले लेदलो रोहे, ओको खतनो वी कोरनो; ओस कोरिन मारा वायदान सोहलानी तुमरा डीलो मा रोहसे हुयो जोलोम जोलोम् रोहसे। ");
INSERT INTO dhn_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","जु मानुस विगुर फातोरकाती रोहसे, अर्थात जेरी खालड़ी क खतनो नो होये, चो जीव आपना मानषो मा सी नोष्ट कोर्‌यो जासे, काहकी हुयो मारे पुठी वायदु बान्दला काजे तुड़ देदो।” ");
INSERT INTO dhn_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","ओळी परमेश्वर न अब्राहम सी कयो, “तारी जी लाड़ी सारै छे, ओको तु हिमी सारै झुण कोहे, ओको नाव सारा होयसे। ");
INSERT INTO dhn_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","हांव हेनीक बोरकोत आपीस, आरु तुखे ओका द्वारा एक पुर्य आपीस, आरु हांव ओको ओसो बोरकोत आपीस की हुयी जाति जातिन मुलमाता होय जासे; आरु ओका ओवलियाद मा राज्य–राज्य क राजा पोयदा होयसे।” ");
INSERT INTO dhn_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","ती अब्राहम मुयोन भुरसे हुट पोड़यु आरु हासने, आरु मोनोत मोनोम कोहने लाग्यु, “काय सोव साल क मानुसक वी ओवलियाद होयसे आरु काय सारा जी नोब्बे साल कि छे पुर्य जोनसे?” ");
INSERT INTO dhn_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","आरु अब्राहम न परमेश्वर सी कयो, “इश्माएल तारी निगाह मा बोनलु रोहे! योत बेस छे।” ");
INSERT INTO dhn_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","ती परमेश्वर न कयो, “खोरी तारी लाड़ी सारा क तार सी एक पुर्य पोयदा होयसे; आरु तु ओको नाव इसहाक राखजी; आरु हांव ओका सात मा ओसी वाचा बान्धीस जी ओका वाद मा ओकी ओवलियाद क लिय जोलोम जोलोम् कि वाचा रोहसे। ");
INSERT INTO dhn_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","इश्माएल क वारा मा वी हांव तारी सोमवलु छे; मे ओको वी बोरकोत आपीस, आरु ओको फलवन्त कोरिस आरु घोनु वोदाड़ीस; हेना सी बारे डाहला पोयदा होयसे, आरु हांव हेना सी एक मोटली जाति बोनाविस। ");
INSERT INTO dhn_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","बाखुन हांव आपसी वाचा इसहाक पुठीत बान्दीस जु सारा सी अगले साल इने टेमे पोयदा होयसे।” ");
INSERT INTO dhn_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","ती परमेश्वर न अब्राहम सी वात कोरनो बोन्द करीयो आरु ओका चा रोईन उपोर जात रोयो। ");
INSERT INTO dhn_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","ती अब्राहम न आपसा पुरया इश्माएल क लिदो; आरु ओका घोर मा जोत्रा वी पोयदा होयला हुता, आरु जोतरा हेरा पोयस्‌या मुले लेदला हुता, अर्थात् ओका घोर मा जोत्रा मानुस हुता तेनु आखाक लीन तेने दाहड़े परमेश्वर क बुलोन ओनसारे हेन्दरी खालड़ी क खतनो करीयो। ");
INSERT INTO dhn_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","जोत्यार अब्राहम क खालड़ी क खतनो हुयो ती अब्राहम एक कोम सोव सालोन होतु। ");
INSERT INTO dhn_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","आरु जोत्यार हेरा पुर्या इश्माएल क खालड़ी क खतनो हुयो ती हुयो तेरे सालोन हुतो। ");
INSERT INTO dhn_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","अब्राहम आरु ओको पुर्य इश्माएल दुयो क खतनो एकज दाहड़े हुयो; ");
INSERT INTO dhn_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","आरु ओका घोर मा जोत्रा मानुस हुता, जे घोर मा पोयदा होयला ओळी जो पोरदेशी क हातो सी पोयस्‌यान मुले लेदला हुता, सब क खतनो ओकाज सात मा हुयो। ");
INSERT INTO dhn_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","अब्राहम मम्रे क बांज झाड़ क वीच बेस तोपो क टेमे तंबु क झोपला पोर बोठ रोयु होतु, ती योहोवा न ओको दर्शन दिदो: ");
INSERT INTO dhn_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","हुयो डुळा उचाकोरीन निगाह कोर्‌यो ति काय देख्यो कि तिन मानुस ओका सामने उब रोया। (इब्रा. 13:2) ");
INSERT INTO dhn_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","“हे पोरबु, काहमाईन मार पोर तारी गिनोन निगाह होय ती हांव विनता कोरो कि आपसा दासोन चा गोथू झुणी जाय। ");
INSERT INTO dhn_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","हांव थुड़ोस जळ लियावो, आरु आप आपसा पाय धुविन इना झाड़ क नेचो आराम कोरो। ");
INSERT INTO dhn_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","ओळी हांव एक भुकरु रुटान ली आवो, आरु तिनासी आप आपसा जीव क तृप्‍त कोरजे, ती ओका वाद मा ओगा बोड़जे; काहकी आप आपसा दास क पास ओतरान कोरिन आवलु छे।” हुयो कयो, “जोसो तु कोयो तोसोत कोर।” ");
INSERT INTO dhn_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","ती अब्राहम तोत्यारुत तंबु मा सारा क पास गयो आरु कयो, “छाटीत दोस किलु मोयदु लिन कुसोन आरु तेरा रुटा बोनाय ले।” ");
INSERT INTO dhn_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","ती अब्राहम गाय बुईल क टुळा मा दौवड़्यु आरु एक बेस वारु आरु वारु बछड़ो लिन आपसा दास क आप्यो, आरु तेनाक छाटू रान्दाड़्यु ");
INSERT INTO dhn_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","ती हुयो दुध आरु दही आरु बछड़ा क मांस, जो हुयु रान्दाड़लु हुतु, लीन हेरे ओगोळ वाट देदु; आरु आप झाड़ क नेड़ो पोलान चा उबो रोह, आरु हुये खाने लाग्या। ");
INSERT INTO dhn_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","हुये हेना सी पुछ्या, “तारी लाड़ी सारा कां छे?” हुयो कयो, “ची तंबु मा छे।” ");
INSERT INTO dhn_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","हुयो कयो, “हांव वसन्त ऋतु मे छाचीन तारेन्चा आवीस, आरु तारी लाड़ी सारा क एक पुर्य पोयदा होयसे।” सारा तंबु क झपला पोर जु अब्राहम क पोछो हुतो, सोमळती होती। (रोम. 9:9) ");
INSERT INTO dhn_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","अब्राहम आरु सारा दुयु बेसका डाळा होता; आरु सारा क मासिक धर्म बोन्द हुय गोया हुता। ");
INSERT INTO dhn_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","ओतरान कोरिन सारा मोनो मा हासीन कोहने लागी, हांव ते डावी छे, आरु मारु घोरवावु वी ते डावु छे, ती काय यो सुख होयसे (1 पत. 3:6) ");
INSERT INTO dhn_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","ती योहोवा न अब्राहम सी कयो, “सारा यो कोवीन काहा हासे कि काय मारे, जो ओतरी डावी होय गोय, छाचीन होयसे?” ");
INSERT INTO dhn_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","काय योहोवा क लिय काय काम वातड़ो छे? सोय टेमो मा, अर्थात वसन्त ऋतु मा, हांव तारे पास ओळी आवीस, आरु सारा क पुर्य पोयदा होयसे (लुका 1:37) ");
INSERT INTO dhn_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","ती सारा बिहिन कोहने बाज गोय “मे नी हासी।” हुयो कयो, “नी; तु ते हासली हुती।” ");
INSERT INTO dhn_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","ओळतेन चे मानुस चां गोथा सी चाल्या आरु सदोम भीनी निगाह कोर्या की; आरु अब्राहम तेनुक विदा कोरने क लिय ओका सात मा चाल्यो। ");
INSERT INTO dhn_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","ती योहोवा न कयो, “यो जो हांव कोरो, चो काय अब्राहम सी डुकाड़ी राखो? ");
INSERT INTO dhn_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","अब्राहम सी ते छाचीन एक मोटी आरु सामर्थी जाति उबेजसे, आरु कोळी का आखी जाती ओका लारे बोरकोत पावसे। ");
INSERT INTO dhn_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","काहकी हांव जानो कि हुयो पासा पुर्या आरु घोरल्या क, जे ओका पोछोळ रोय जासे, हुकुम आपसे कि चे योहोवा क वाटो मा अटल बोनला रोहु, आरु धर्म आरु नियाव कोरता रोहु; काहकी जो काय योहोवा न अब्राहम क वारा मा कोहलो छे ओको पुरो कोरे।” ");
INSERT INTO dhn_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","ओळी योहोवा न कयो, “सदोम आरु गमोरा कक आयड़नो वोद गोयो, आरु ओलो पाप बेस भारी होय गोयलो छे; ");
INSERT INTO dhn_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","ओतरान कोरिन हांव उतरीन देखिस कि हेरे जोसो आयड़नो मारा कान्टा लोगुन पुगलो छे, हुये ठीक तोसोत काम कोर्या कि नी; आरु नी कोर्या होय ति हांव हेना पारखी लीस।” ");
INSERT INTO dhn_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","ती चे मानुस होया सी मुड़ीन सदोम भिनी जाने लाग्या; बाखुन अब्राहम योहोवा क ओगोळ उबो रोय गोयो। ");
INSERT INTO dhn_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","ती अब्राहम हेरे धोड़े जाईन कोहने लाग्यु, “काय तु छाचीन भुण्डला पुठी वारलान वी नाश कोरीस? ");
INSERT INTO dhn_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","काहमाईन हेना नोगोर मा पोचास धोरमी होसे; ती काय तु छाचीन हेना जागा क नष्ट कोरिस आरु हेनु पोचास धोरमी क लिय जो हेरेम छे, नी छुड़ीस? ");
INSERT INTO dhn_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","ओसलो काम कोरने तार सी नाम्बे रोहे कि भुण्डा क सात धोरमी क वी मार नाखीस, आरु धोरमी आरु भुण्डा दुयो क एकुज रोहसे। यो तार सी नाम्बे रोहे। काय आखी कोळी क नियाव कोरन्यु नियाव नि लोरे?” ");
INSERT INTO dhn_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","योहोवा न कयो, “काहमाईन मेसे सदोम मा पोचास धोरमी जोड़े। ती तिन्दरै जुगु तेना आखा जागा क छुड़दीस।” ");
INSERT INTO dhn_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","ओळतेन अब्राहम न कयो, “हे पोरबु, सोमोळ, हांव ते धुळा आरु रुखड़ु छे, तेवी हांव ओतरी हिमोत नी कि तारसी वात कोरो। ");
INSERT INTO dhn_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","काहमाईन हेनु पोचास धोरमी मा पांच घोट जाय; ती काय तु पांचूत क घोटने क कारण तेनु आखा नोगोर काजे नाश कोरिस?” हुयो कोयो, “काहमाईन मेसे हेनुमासी चावीस ने पाच वी जोड़े, तीवी ओको नाश नी कोरो।” ");
INSERT INTO dhn_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","ओळी हुयो हेनासी यो वी कयो, “काहमाईन होयां चावीस जोड़े।” हुयो कयो, “ते हांव चावीस क कारण वी ओसो नी कोरीस।” ");
INSERT INTO dhn_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","ओळी हुयो कयो, “हे पोरबु, रीस झुण कोरे ती हांव काय ओळी कोहो। काहमाईन होया तीस जोड़े।” हुयो कयो, “काहमाईन मेसे होया तीस वी जोड़े, तेवी ओसो नी कोरीस।” ");
INSERT INTO dhn_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","ओळी हुयो कयो, “हे पोरबु सोमोळ, हांव ओतरी ढिठाई ते कोरलु छे की तार सी वात कोरो: काहमाईन हेरेमा वीस जोड़े।” हुयो कयो, “हांव विस क लिये वी ओको नाश नी कोरो।” ");
INSERT INTO dhn_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","ओळी हुयो कयो, “हे पोरबु, रीस झुन कोरे, मे एक कावार आरु कोहिस; काहमाईन हेरेमा दोस जोड़े।” हुयो कयो, “ति हांव दोस क लिय वी ओको नाश नी कोरिस।” ");
INSERT INTO dhn_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","जोत्यार योहोवा अब्राहम सी वात कोर लिदो, ती जात रोयु; आरु अब्राहम आपसे घोर क जात रोयु। ");
INSERT INTO dhn_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","वेळा क चे दुय दुत सदोम क पास आया; आरु लुत सदोम क झोपला क पास बोठलो हुतो। तेनुक देखीन हुयो तेनुक मेळने कोरीन उठ्यो, आरु मुय क भुरसे झुकीन वांदतु जाईन कोयु, ");
INSERT INTO dhn_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","“हे मारा भोगवाने, आपस दास क घोर मा आवु, आरु रात भोरीन आराम कोरु, आरु आपसा पाय धुवु, ओळतेन कुकड़ुवासे उठीन आपने वाट्ये जात रोहजु।” हुये कोया, “नी, हामु, चोकड़ी पोर रात रोय लेसु।” ");
INSERT INTO dhn_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","बाखुन हुयो हेन्दरे सी बेस विनता कोरिन मोनयु; ओतरान कोरिन चे ओका सात जाईन हेरा घोर मा आया; आरु हुयो हिन्दरे लिय खनो तियार कोर्‌यो, आरु विगुर खोमीर करुटा बोनावीन खावाड़ीयो। ");
INSERT INTO dhn_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","हेनुक सुवने से पेहले, सदोम नोगोर क मानुस न, जुवान्या सी लागाड़ीन डाहला लोगुन, बाखुन च्यारु मेरोन आखा मानुस आवीन हेना घोन क घेरवी लेदा; ");
INSERT INTO dhn_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","आरु लुत क आयड़ीन कोहने लाग्या, जे मानुस आज रात क तारेनचा आवला छे चे कां छे? हेनुक आमरेनचा खोयड़े ली आव कि हामु हिन्दरे सी संभोग कोरजे (न्यायीयो 19:22-24) ");
INSERT INTO dhn_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","ती लुत हिन्दरे धड़े झपला क खोयड़े गयो, आरु किवाड़ क आपसे पोछोळ बोन्द कोरीन कोयो, ");
INSERT INTO dhn_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","“हे मारा भाष्यो, हांव तुमरे सी विनता कोरो, ओसी बुराई मा कोरु। ");
INSERT INTO dhn_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","सोमळु, मारी दुय पुराय छे चे हांजु लोगुन मानषोन मुय नी देख्या; मोरजी होय ति हांव तेनुक तुमरेन्चा खोयड़े लि आवो, आरु तुमुक जोसो वारु लागे तोसो वेहवार हिन्दरे सी कोरु; बाखुन ईनु मानषो सी काय नी कोरु; काहकी ये मारी छोतो तोळे आवला छे।” ");
INSERT INTO dhn_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","हुये कोया, “छेटु जा!” ओळी कोहने लाग्या, तु ते हुलक्र्यु होईन यां रोहने क लिय आयो, बाखुन हीमी नियायी वी बोन बोठ्यु; ओतरान कोरिन हीमी हामु हेन्दरे वी वोदु तार पुठी बुराय कोरसु। आरु चे तेना मानुस लुत क घोना डाबने लाग्या, आरु किवाड़ तुड़ने क लिय धोड़े आया। ");
INSERT INTO dhn_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","ती चे पाहन्तरीया हात ओगु कोरीन लुत क आपसे चां घोर मा हापकी लेदा, आरु किवाड़ क बोन्द कोर दिदा। ");
INSERT INTO dhn_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","आरु हुये काय नाना, काय मोटा, आखा मानुस क जो घोर क झपला पोर होता, आंधवा कोर दिदा, अत: चे झोपला क टाटवी टाटवीन थाक गोया ( 2 राजा 6:18) ");
INSERT INTO dhn_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","ओळतेन हुये पाहन्तरिया न लुत सी पुछ्या, “यां तारो आरु कुन कुन छे? जोवाय, पुर्या, पुरायटा, आरु नोगोर मा तारो जो कुदु होय, तेनुक आखाक लिन इना जागा सी नीकोळी जा। ");
INSERT INTO dhn_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","काहकी हामु इना जागा क खोतोम कोरने पोर छे, ओतरान कोरिन कि इन्दरी ओवाज योहोवान क सामने बोढ़ गोयली छे; आरु योहोवा न आमुक ओको सत्यनाश करने क लिय मोकेल्लो छे।” ");
INSERT INTO dhn_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","ती लुत न नीकोळीन आपसा जोवाय क, जिन्दरे साते हेरा पुरायटान सोगाय होयली होती, सोनझाड़ीन कया, उठू, इना जागा सी निकोळीन जावु; काहकी योहोवा इना नोगोर क नोष्ट कोरने पोर‌ छे। बाखुन हुयु आपा जोवायन निगाहा मा ठट्ठा कोरनेवाळु जान पोड़्यु। ");
INSERT INTO dhn_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","जोत्यार पौ फाटने लागी, ती दुते न लुत सी छाटा कोरने कोरीन कयो आरु कोया, “उठ, आपसी लाड़ी आरु दुयु पुरायटाक जे या छे ली जा, नी ते तु वी इना नोगोर क ओधोरोम मा रुखड़ु होय जाइस।” ");
INSERT INTO dhn_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","बाखुन हुयु वार लागाड़तु रोयु; ओस कोरीन चे मानुस हेरो आरु हेरी लाड़ीन, आरु दुयु पुरायटान हात धोर्या, काहकी योहोवा की गीन हेर पोर होती; आरु हेनुक नीकाळीन नोगोर सी बाहर कोर देदा (2 पत. 2:17) ");
INSERT INTO dhn_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","आरु ओसो हुयो कि जोत्यार हुये हेनुकक खोयड़े निकाळया। ती कोया, “आपसी जीव लिन ढास जा; पोछू फिरीन झुणी भावे, आरु तराई भोर मा झुनी रुकाये; तेना बोयड़ा पोर ढास जाजु नी ते तु वी रुखड़ु होय जाइस।” ");
INSERT INTO dhn_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","लुत न तेनु सी कयो, “हे पोरबु, ओसो मा कोरे! ");
INSERT INTO dhn_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","देख, तारो दास पोर तारी गिन क निगाह होयली छे, आरु तु न इनी मा मोटी गीन देखाड़्यु कि मारो जुव क बाचाड़लो छे; बाखुन हांव बोयड़ा पोर नी ढास सोकतलु, काहमाईन ओसो नी की काहीन पिड़ा मार पोर आय पोड़े, आरु हांव पोर जाम। ");
INSERT INTO dhn_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","देख, हुयो नोगोर ओसो धोड़्ये छे कि हांव होया ढास सोकीस, आरु हुयो नानो वी छे। मेसे होयांत ढास जाने दे, काय हुयो नोगोर नानो नी होय? आरु मारो जीव वाच जासे।” ");
INSERT INTO dhn_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","हुये हेना सि कया, “देख, मे ते इना वाराम तारी विनता मानलु छे, कि जिना नोगोर क वात तु कोरलु छे, ओको मे नोष्ट नी कोरीस। ");
INSERT INTO dhn_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","तावनी सी होयां ढास जा; काहकी जोत्यार तु होयां नी पुगे, ती लोगुन हांव काय नी कोर सोकीस।” ओतरान कोरीन हेना नोगोर क नव सोअर पोड़्यो। ");
INSERT INTO dhn_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","लुत क सोअर क धोड़े पुगीन दाहड़ु कोळी पोर उगज्यु। ");
INSERT INTO dhn_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","ती योहोवा न अपसे भीनी सी सदोम आरु गमोरा पोर आकाश सी गन्धक आरु आगठो पाड़्यो (मत्ती 10:15, लुका 10:12, 2 पर. 2:6) ");
INSERT INTO dhn_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","आरु हेना नोगोर क आरु हेनी आखी तराई क, आरु नोगोर क सब मानषो क, धोरती क आखी उपज भेळ नष्ट कोर देदो। ");
INSERT INTO dhn_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","लुत क लाड़ी न जो ओका पोछोळ होती पोछी फीरीन निगाह नाखी, आरु हुयी नोनोन खाम्बु बोन गोय। ");
INSERT INTO dhn_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","सोन्दारे क अब्राहम उठीन तेना जागा क गयो, जां हुयो योहोवा क सामने उबो हुतो; ");
INSERT INTO dhn_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","आरु सदोम आरु गमोरा, आरु हेनी तराई क आखा देश क भीनी डुळा उचाकोरीन काय देख्यो कि हेना देश मा सी धोधेकतली भाटी क सो धुवाड़ो उठ रयो छे। ");
INSERT INTO dhn_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","आरु ओसो हुयो कि जोत्यार परमेश्वर न हेनी तराई क नोगोर क, जिनामा लुत रहतो हुतो, उलट–पुलट कोरीन नष्ट करीयो, ती हुयो अब्राहम क फोम कोर्‌यो लुत क हेनी गोरा सी वाचाड़ लेदो ");
INSERT INTO dhn_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","ओळतेन लुत न सोअर क छुड़ देदो, आरु बोयड़ा पोर आपसी दुय पुराय पुठी रोहने लाग्यो; काहकी हुयो सोअर मा रोहने सी बिहतो हुतो; ओतरान कोरिन हुयो आरु ओकी दुय पुराय चां एक गुफा मा रोहने लाग्या। ");
INSERT INTO dhn_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","ती मोटली पुराय न नानली सी कोहि, “आपनु बाबु डावु छे, आरु कोळी भर मा कोय ओसो मानुस नी होय जु संसार क रीति क ओनसारे आपने चां आवे। ");
INSERT INTO dhn_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","ओतरान कोरिन आव, आपनु आपना बाबा क दाखमधु पाविन हेरे पुठी सुवता, जैरे सी कि आपनी बाबा क ओवलियाद वाचली रोहे।” ");
INSERT INTO dhn_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","अत: हिये तेनेत दाहड़े रात क टेमे बाबा क दाखमधु पाया, ती मोटली पुराय जाईन आपसा बास क पास लुट गोय; बाखुन हुयो नी जान्यो कि हुयी कोत्यार लुटी ने कोत्यार उठ गोय। ");
INSERT INTO dhn_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","आरु ओसो हुयो कि दिसरे दाहड़े मोटली नानली सी कोहि, “देख, काल राती हांव आपसा बाबा क सात सुवी; ओतरान कोरिन आज वी रात क आपनु ओको दाखमधु पावसु; ती तु जाईन ओका सात मा सुवजी की आपनु आपना बाबा क लारे ओवलियाद पोयदा कोरजे।” ");
INSERT INTO dhn_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","अत: हुये तेनेत दाहड़े राती क टेमे आपसा बाबा क दाखमधु पाया; आरु नानली पुराय जाईन ओका पास लुट गोय, बाखुन ओको हेरो वि सुवने आरु उठने क टेम क गियान नि हुतो। ");
INSERT INTO dhn_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","ओसकोरिन सि लुत क दुयु पुराय आपसा बाबा सी भारेपाये होयी। ");
INSERT INTO dhn_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","मोटली एक पुर्य जोन्म देदी, आरु ओको नाव मोआब पाड़्या; हुयो मोआब नावोन जाती क जो आज लोगुन छे मुलपिता हुयो। ");
INSERT INTO dhn_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","आरु नानली वी एक पुर्य जोन्म देदी, आरु ओको नाव बेनम्मी पाड़्या; हुयो अम्मोन ओवलियादियो क जो आज लोगुन छे मुलपिता हुयो। ");
INSERT INTO dhn_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","ओळतेन अब्राहम चा सी निकोळीन दोखेवरे देश मा अवीन कादेश आरु शुर क विच मा रुकायो, आरु गरार मा रोहने लाग्यो। ");
INSERT INTO dhn_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","आरु अब्राहम न आपसी लाड़ी साराक वारा मा कयो, “हुयी मारी बोहनीस छे,” ओतरान कोरिने गरार क राजा अबीमेलेक न दुत मोकलीन सारा क बुलाय लिदो। ");
INSERT INTO dhn_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","रात क परमेश्वर न सोपना मा अबीमेलेक क पास आवीन कयो, सोमोळ। जेनी बायोर क तु राख लेदलु छे ओको कारण तु मोर जाईस काहकी हुयी सुहागिन छे। ");
INSERT INTO dhn_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","बाखुन अबीमेलेक हेरेन्चा नी गयो हुतो; ओतरान कोरिने हुयो कयो, “हे पोरबु, काय तु विनगुणाकी जाति क वी मार दीस? ");
INSERT INTO dhn_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","काय होयोत खुद मारे सी नी कोयो, ‘यि मारी बोहनीस छे?’ आरु हुयी बायर वी खुद कोहि, ‘यु मारु भाईश छे’ हांव ते मारा मोनोन सुदो आरु मारा व्यवहारोन क छाचो यो काम करीयो।” ");
INSERT INTO dhn_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","परमेश्वर न हेनासी सोपना मा कयो, हाव्, हांव वी जानो की आपना मोनो क खोराई सी तु यो काम कोरलु छे, आरु हांव ते तुखे रुकिन राख रोयु कि तु मारे विरुद्ध पाप नी कोरे; ओतरान कोरिन मे तुसेक हेनीक छिमने नी देतु। ");
INSERT INTO dhn_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","ओतरान कोरिन हीमी हेना मानुसक लाड़ी क हेना पोछू आप दे; काहकी हुयु कागळीयो छे, आरु तारे लिय विनता कोरसे, आरु तु जिवत्लु रोहिस; बाखुन तु हेनाक नि पोछू आपे ति फोम राखजी की तु आरु जोत्रा मानुस छे, आखा छाचीन मोर जासे। ");
INSERT INTO dhn_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","सबेरे अबीमेलेक न तड़के उठीन आपसा कामकोरन्याक बुलावीन यो आखाक वात सोमवाळ्यु; आरु चे मानुस बेस बिही गोया। ");
INSERT INTO dhn_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","ती अबीमेलेक न अब्राहम क बुलावीन कयो, “तु न मारा सार यो काय करीयो? हांव तरो काय बिगाड़ु कि तु मारा आरु मारा राजो क उपर ओसो मोटो पाप नाख देदो छे? तु मारा सात चो काम करीयो जो वारु नी हुतो।” ");
INSERT INTO dhn_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","ओळी अबीमेलेक न अब्राहम सी पुछ्यो, “तु काय सोमझीन ओसो काम सोयो?” ");
INSERT INTO dhn_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","अब्राहम न कयो, “हांव यो सोच्यो हुतो को इना जागा मा परमेश्वर क काय वी बीक नि रोहसे; ओतरान कोरिन ये मानुस मारी लाड़ी क कारण मेखे मार देसे। ");
INSERT INTO dhn_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","एर सिवाय छाचीन यी मारी बोहनीस छे; हुयी मारा बाबान पुराय ते छे, बाखुन मारी आयान पुराय नी; ते वी हुयी मारी लाड़ी होय गोय। ");
INSERT INTO dhn_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","आरु ओसो हुयो कि जोत्यार परमेश्वर न मको आपस बाबा क घोर छुड़ीन निकोळने क हुकुम आप्यो, ती हांव ते ओको कयो, ओतरी गीन तारी मार पोर कोरनो पोड़से कि हामु जां–जां जाजे चां–चां तु मारा वाराम मा कहनो कि यो मारो भाईष् छे।” ");
INSERT INTO dhn_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","ती अबीमेलेक न गाडरा–बुकड़ा, गाय–बुईल, आरु दास–दासीया लीन अब्राहम क आप्यो, आरु ओकी लाड़ी सारा क वी हुयो पोछो आड़ दिदो। ");
INSERT INTO dhn_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","आरु अबीमेलेक न कयो, “देख, मारो देश तारे सामने छे, जां तुसे पोटे चां रोव।” ");
INSERT INTO dhn_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","सारा सी हुयो कयो, “देख, हांव ते तारा भाष्यो क रिपियान एक होजार भुकरा आपलो छे। देख, तारा आखा संगियो क सामने हुयोत तारो डुला क पोरदो बोनसे, आरु सभो क ओगोळ त वारु होईस।” ");
INSERT INTO dhn_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","ती अब्राहम न योहोवा सी विनता करीयो की, आरु परमेश्वर अबीमेलेक, आरु ओकी लाड़ी आरु दासीया क आरगा कोर्‌यो आरु चे आरगा होय गोया। ");
INSERT INTO dhn_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","काहकी योहोवा न अब्राहम क लाड़ी साराक कारण अबीमेलेक क घोर क आखा बायरा क कुखों क पुरे रिते सी बोन्द कोर दियो हुतो। ");
INSERT INTO dhn_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","योहोवा जसो कयो तसोत सारा क फोम राख्यो की ओका सात आपनो बुल क ओनसारे करीयो। ");
INSERT INTO dhn_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","सारा अब्राहम सी भारेपाय होयी; आरु हेरा डाहवारा मा ओको नावाड़ले टेम पोर जु परमेश्वर तेनाक टाकलो हुतो, एक पुर्य होयो। ");
INSERT INTO dhn_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","अब्राहम न हेरा पुर्या क नाव जो सारा सी पोयदा होयो थो इसहाक पाड़्यो। ");
INSERT INTO dhn_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","आरु जोत्यार ओका पुर्य इसहाक आठ दिन क होयो, ती हुयो परमेश्वर क हुकुम क ओनसारे अब्राहम हेको खतनो करीयो। ");
INSERT INTO dhn_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","जोत्यार अब्राहम क पुर्य इसहाक पोयदा हुयो ती अब्राहम एक सोव साल क थो। ");
INSERT INTO dhn_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","आरु सारा न कयी, “परमेश्वर न मक घोनो खुश कोरलो छे; ओतरान कोरिन आखा सोमळनेवाळा वी मार सात मा खुश होवसे।” ");
INSERT INTO dhn_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","ओळी हुयी यो वी कोहि, “काय कुदु कदी अब्राहम सी कय सोकतो हुतो की सारा पुर्या क दुद पावसे? बाखुन देखु, मारसी ओका डाहवारा मा एक पुर्य पोयदा हुय गोयो।” ");
INSERT INTO dhn_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","चो पुर्य मोटो हुयो आरु ओको दुद छुड़ाय देदा; आरु इसहाक क दुध छुड़ावने क दाहड़े अब्राहम न मोटो भोज कोर्‌यो। ");
INSERT INTO dhn_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","ती सारा क मिसरी हाजिरा क पुर्य, जो अब्राहम सी पोयदा हुयो थो, हासतलो देखा पोड़्यो। ");
INSERT INTO dhn_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","ओस कोरीन हुयी अब्राहम सी कयो, “इनी दासी क पुर्या भेळ नीकाय दे; काहकी इनी दासी क पुर्य मारा पुर्या इसहाक क सात नी भेसकायसे।” ");
INSERT INTO dhn_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","यी वात अब्राहम क आपसा पुर्या क कारण बेस भुण्डी लागी। ");
INSERT INTO dhn_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","बाखुन परमेश्वर अब्राहम सी कयो, “हेना पुर्या आरु आपसी दासी क कारण भुण्डो नी लागे; जी वात सारा तुसे कोहि, तेनीक मान, काहकी जी तारी ओवलियाद कोवायसे ची इसहाक सीत चालसे। ");
INSERT INTO dhn_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","दासी क पुर्या सी वी मे एक जाति उबजाड़ीस, ओतरान कोरिन कि हुयो तारो ओवलियाद छे।” ");
INSERT INTO dhn_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","ओतरान कोरिन अब्राहम न वेगोत उठिन रुटा आरु पानी सी भरलो चामड़ा क थयलो वी हाजिरा क आप्यो, आरु ओका कान्धा पोर मेल्यो, आरु ओका पुर्या क वी हेनीक आपिन ओको मोकोळी देदो। हुयी जात रोय, आरु बेरसेबा क जोन्गोल मा वाहरायने लागी। ");
INSERT INTO dhn_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","जोत्यार थोयली मा वाळो पानी सोर गोयो, ती हुयी पुर्याक एक झाड़ो तोळे छेड़ देदी। ");
INSERT INTO dhn_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","आरु हुयी हेना सी थुड़ी नाम्बे जाईन ओका वाराम यो वीचारीन बोठ गोय, “मेसे पुर्यान मोत देखनो नी पोड़े।” ती हुयी ओका सामने बोठीन आयड़ी आयड़ीन रोड़ने वाज गोय। ");
INSERT INTO dhn_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","परमेश्वर न हेना पुर्या क सोमळ्यो, आरु ओका दुत न सोरोग सी हाजिरा क आयड़ीन कया, “हे हाजिरा, तारे काय होय गोयो? मा बिहये; काहकी जा तारु पुर्यु छे चां सी ओकी ओवाज परमेश्वर क सोमवली छे। ");
INSERT INTO dhn_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","उठ, आपसा पुर्या क चूट आरु आपसा हात सी सोमाळ; काहकी हांव ओका द्वारा एक मोटी जाति बोनावीस।” ");
INSERT INTO dhn_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","ती परमेश्वर न ओका डुळा उगाड़ दिदो, आरु ओको एक कुवो देखा पोड़्यो; ती हुयी जाईन थोयली क पानी भोरीन पुर्या क पावी। ");
INSERT INTO dhn_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","आरु परमेश्वर हेना पुर्या क सार रोयो; आरु जव हुयो मोटो होयो, ती उजाड़ बयड़ा मा रयीन रोहीन धनुर्धारी बोन गोयो। ");
INSERT INTO dhn_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","हुयो पारान नावोन जोन्गोल मा रोहतो हुतो; आरु ओको आईश् न ओक लिय मिसर देश सी एक बायोर मांगाड़ी। ");
INSERT INTO dhn_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","तेनु दाहड़ा मा ओसो हुयो कि अबीमेलेक आपसा सिपायड़ा पीकोलक सात लीन अब्राहम सी कोहने लाग्यो, “जो तु काय कोरे ओका मा परमेश्वर तारे साते रोवे; ");
INSERT INTO dhn_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","ओतरान कोरिन हीमी मेसे यां इना वारामां परमेश्वर क शपथ खाय कि तु नी ते मार पुठी धुकु कोरीस आरु नि ते कोदी मेरा होको सी कोरीस, बाखुन जोसी गीन हांव तार पोर कोरलु तोसुत तु मार पोर आरु एना देश पोर वी, जिनामा तु रोहे, कोरजी।” ");
INSERT INTO dhn_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","अब्राहम न कयो, “हांव शपथ खाईस।” ");
INSERT INTO dhn_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","ती अब्राहम न अबीमेलेक क एक कुवा क वारा मा जो अबीमेलेक क दासो न ताकोतसी ली लेदा होता, उलाहना आप्यो। ");
INSERT INTO dhn_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","ती अबीमेलेक न कयो, “हांव नि जानो कि कुन यो काम कोर्‌यो; आरु तु वी मेसे नि कोयु, आरु नी हांव आज सी पेहेल इना वाराम काय सोमळ्यु।” ");
INSERT INTO dhn_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","ती अब्राहम न गाडरा बुकड़ा आरु गाय–बुईल अबीमेलेक क आप्यो; आरु हिये दुयु आम्बा साम्बा वायदु कोर्या। ");
INSERT INTO dhn_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","अब्राहम न गाडरा क सात पुर्या ओलोग मेल्यो। ");
INSERT INTO dhn_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","ती अबीमेलेक न अब्राहम सी पुछ्यो, “ईनु सात पिला क, जो तु नेवाड़ रोयु, काय कोरीस?” ");
INSERT INTO dhn_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","हुयो कयो, “तु इनु सात गिदल्या क इने वाते गोवा जानीन मारा हातो सि ली के हांव यु कुवु खुंदलु छे।” ");
INSERT INTO dhn_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","हुये दुयु जे हेना जागा मा आपसा शपथ खादला, ओतरान कोरीन हेना जागान नाव बेरसेबा पोड़यो। ");
INSERT INTO dhn_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","जोत्यार बेरसेबा मा जोत्यार वाचा बान्धे, ती अबीमेलेक आरु ओको सिपायड़ो पीकोल उठीन पलिश्तियो क देश मा पोछा गोया। ");
INSERT INTO dhn_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","ओळतेन अब्राहम न बेरसेबा मा झाऊ क एक झाड़ लागाड़्या आरु होया योहोवा सी जो जलमको परमेश्वर छे विनता करियो। ");
INSERT INTO dhn_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","अब्राहम पलिश्तियान क देश मा घना दाहड़ा लोगुन हुलक्र्यु रोयु। ");
INSERT INTO dhn_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","इनी वातो क वाद मा ओसो हुयो कि परमेश्वर न अब्राहम सी यो कोवीन ओको पारखोन लेदु, “हे अब्राहम!” अब्राहम कयो, “ए पोरबु देख, हांव यां छे, काय हुकुम छे।” ");
INSERT INTO dhn_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","हुयो कयो, “आपसा पुर्या क अर्थात् आपसा एकखुयव्या पुर्या इसहाक क, जिना सी तु मोंग राखे, पुठी लीन मोरिय्याह देश मा जात रोह; आरु होयां ओको एक बोयड़ा क उपोर जो हांव तुसे कोहीस होमबली कोरीन चोड़ावजी।” ");
INSERT INTO dhn_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","ती: अब्राहम वेगोत उठीन आरु आपसा गोदड़ा पोर लाकड़ा चीरिन आपसा दुय चाखर्या, आरु आपसा पोर्या इसहाक को पुठी ली गयो, आरु होमबली वाटे लाकड़ा चीर लिदो; ती नीकोळीन उना जागा भेणी चाल दिदा, जेका वारा मा परमेश्वर न हेकेक कयलो हुतो। ");
INSERT INTO dhn_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","तीसरे दाहड़े अब्राहम न डुळा उचाकोरीन हेना जागा क नांबे सी देख्यो; ");
INSERT INTO dhn_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","तव अब्राहम हेका चाकरीयान सी कयो, “गदड़ा क पास मा उबा रोहजु; यो पुर्य आरु हांव होयां लोगुन जाजे, आरु वान्दीन, ओळतेन तुमरेन्चा आत रोहसु।” ");
INSERT INTO dhn_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","ती अब्राहम न होमबली क लाकड़ा लेदो आपसा पुर्या इसहाक पोर मेल्यो, आरु आगठो आरु छोक्कु आपसा हातो मा लेदो; आरु हुये दुयु एकठा चाल पोड़्या। ");
INSERT INTO dhn_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","इसहाक हेका बाप अब्राहम सी कयो, “ए म्हारा बाप,” त्यो कयो, काय वात छे? इसहाक कयो, “देख, आगठो आरु लाकड़ा ते छे; पुन होमबली वाटे गाडरो कांह छे?” ");
INSERT INTO dhn_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","अब्राहम न कयो, हे मार पुर्या, परमेश्वर होमबली क गाडरो क उपाय हुयोत कोरसे आरु हुये दुयु सातसाती ओगा चालता रोया। ");
INSERT INTO dhn_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","जोत्यार हुये हेना जागा क जु परमेश्वर न ओको बताड़ीयो हुतो पुग्या; ती अब्राहम न होयां वेदी बोनावीन लाकड़ा क नेवाड़ी नेवाड़ीन मेक्या, आरु आपसा पुर्या इसहाक बान्दीन वेदी पोर क लाकड़ा क उपोर मेल दिदो। ");
INSERT INTO dhn_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","ओळतेन अब्राहम न हात बोड़ावीन चोक्कु क ली लेदो कि आपसा पुर्या क बलि कोरे। ");
INSERT INTO dhn_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","ती योहोवा क दुत न सोरोग सी ओको आयड़ीन कयो, “हे अब्राहम!” हुयो कयो, “देख, हांव यां छे।” ");
INSERT INTO dhn_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","त्यो कोयो, “हेना पुर्या पोर हात झुनी बोड़ावे, आरु नी हेका पोर हात मा बोड़ावे; काहकि तु जो मारे सी आपसा पोर्याक, आपसा एकखुळ्या पोर्याक वी नी छुड़्यो; हेमी हांव जान लेदु कि तु परमेश्वरन बीक मानसे।” ");
INSERT INTO dhn_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","ती अब्राहम न डुळा क उठयो, आरु काय देख्यो कि ओका पोछोळ एक गाडरा आपसा सिंगड़ा सी एक झाड़का मा गुजवायलो छे; अत: अब्राहम न जाईन तिन गाडरा क लि लिदो, आरु आपसा पुर्या क जागा पोर तिनाक होमबली चढ़ायो। ");
INSERT INTO dhn_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","अब्राहम न हेना जागा क नाव योहोवा यिरे पाड़्यो। हेरेन जोसो आज लोगुन वी कोहे को योहोवा क बयड़ा पोर उपाय कोर्‌यो जासे। ");
INSERT INTO dhn_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","ओळतेन योहोवा क दुत न दुसरी वार सोरोग सी अब्राहम आयड़ीन कयो, ");
INSERT INTO dhn_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“योहोवा क यो बुल छे, की हांव आपसीत यी शपथ खाम की तु यो काम कोरलु छे कि आपसा पुर्या, बाखुन आपसा एकखुयव्या पुर्या क वी नि मकेक्यो; ");
INSERT INTO dhn_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ओसकोरीन हांव छाची तुसे बोरकोत आपीस; आरु छाची तार ओवलियाद क आकाश क तारागण, आरु दोरिया क तीर बालु क किनका क जोसो निगिनाये कोरीस, आरु तारा ओवलियाद आपसा जोमो क नोगोर क डाहला रोहसे; ");
INSERT INTO dhn_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","आरु कोळी क आखी जाति आपसा क तारा ओवलियाद क कारण सोयाव्वु मानसे: काहकी तु मारी वात मानलो छे।” ");
INSERT INTO dhn_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","ती अब्राहम आपसा चाखर्या क चां पोछा आया, आरु हुये आखा बेरसेबा क सात–सात गोया; आरु अब्राहम बेरसेबा मा रोवने लाग्यु। ");
INSERT INTO dhn_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","इनी वात क वाद मा ओसो हुयो कि अब्राहम क खोबोर जोड़ी, “मिल्‍का क तारा भाईष् नाहोर सी ओवलियाद होयली छे।” ");
INSERT INTO dhn_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","मिल्‍का क पुर्य ते ये हुया, अर्थात् हेरु जेठा ऊस, आरु ऊस क भाई बुज, आरु कमुएल, जु अराम क बाबो हुयो, ");
INSERT INTO dhn_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","ओळतेन केसेद, हजो, पिल्दाश, यिद्लाप, आरु बतुएल। ");
INSERT INTO dhn_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","ईनु आठो क मिल्का न अब्राहम क भाई नाहोर क द्वारा जोन्म दिदो। आरु बतुएल सी रिबका पोयदा होयी। ");
INSERT INTO dhn_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","ओळतेन, नाहोर क रुमा नावोन एक रखेल वी होती; जेरे सी तेबह, गहम, तहश, आरु माका पोदा हुया। ");
INSERT INTO dhn_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","सारा एक सोव सत्ताईस साल क होय गोय; आरु जोत्यार सारा क ओतरी ओमोर होयी, ");
INSERT INTO dhn_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","ती हुयी किरयतरबा मा मोर गोय। यो कनान देश मा छे, आरु हेब्रोन वी कोवाये। ओतरान कोरिन अब्राहम सारा क लिय रोड़ने हुयां गोयु। ");
INSERT INTO dhn_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","ती अब्राहम धोड़ोन क पास सी उठिन हित्तियो सी कोहने लाग्यु, ");
INSERT INTO dhn_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","हांव तुमरा वीच मा पाहन्त्रयु आरु पारका छे; मेसे तुमरे विच मा बिड़ा क लिय ओसु जागु आप जु मारुत हय जाय, की हांव मारा मोरला क गाड़ीन मारा डुळा क ओट कोरो। ");
INSERT INTO dhn_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","हित्तियो न अब्राहम सी कयो, ");
INSERT INTO dhn_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“हे आमरा परमेश्वर, आमरी सोमोळ; तु ते आमरा वीच मा मोटू डाहलु छे। आमरा बिड़ा मासी जो तुसे पोटे तेनामा तारा मोरला क गाड़; आमरे मा सी कोय तुसे आमरा बिड़ा लेने सी नी रुकसे, की तु तारा मोरला क हेनामा गाड़ नी पाय।” ");
INSERT INTO dhn_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","ती अब्राहम उठीन उबु होयु, आरु हित्तियो क सामने, जो हेना देश क मानुस हुता, वान्दीन कोहने लाग्यु, ");
INSERT INTO dhn_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","काहमाईन तुमरी यी मोरजी होय कि हांव मारा मोरला क गाड़ीज आपसा डुळा क ओट कोरो, ति मारी विनता छे कि सोहर क पुर्य एप्रोन सी मार लिय विनता कोरु, ");
INSERT INTO dhn_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","कि हुयो आपनी मकपेला वाळी गुफा, जो ओकी जागा क धोड़े छे, हेरु पुरु रिपियान दाम लीन मेसे आप देये, की हुयो तुमरे वीच बीड़ा क लिय मारु जागु होय जाय। ");
INSERT INTO dhn_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","एप्रोन त हित्तियो क विच होयां बोठलो हुतो, ओतरान कोरिन जोतरा हित्ति ओका नोगोर क झोपला सी होईन जाता हुता, तेनु आखा क ओगोळ हुयो अब्राहम क जोपाप आप्यो, ");
INSERT INTO dhn_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“हे मारा मालिक, ओसो नी, मारी सोमोळ; हुयु जागु हांव तुसे आप दोम, आरु ओका जो गुफा छे, हुयी वी हांव तुसे आपो दोम; आपना जाति भाईष् क ओगोळ हांव हेनाक तुखे आप दोम; अत: आपसा मोरला क बीड़ा मा मेक।” ");
INSERT INTO dhn_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","ती अब्राहम न हेना देश क मानषो क ओगोळ वान्द्यु। ");
INSERT INTO dhn_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","आरु हेरी सोमोळतात एप्रोन सी कयो, “काहमाइन तु ओसो चाहे, ती मारी सोमोळ: हेना जागाक जो दाम छे, चो मे तुसे आपने हिन्डो हुयो मार जुळ मुले ली ले, ती हांव मारा मोरला क होयां गाड़दीस।” ");
INSERT INTO dhn_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","एप्रोन न अब्राहम क यो जोपाप आप्यो, ");
INSERT INTO dhn_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“हे मारा पोरबु, मारी वात सोमोळ; हेनी जागा क दाम ते चार सोव शेकेल रिपिया छे; बाखुन मारा आरु तारा वीच मा यो काय छे? आपसा मोरला क बीड़ा मा मेक।” ");
INSERT INTO dhn_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","अब्राहम न एप्रोन क मानीन ओको होतरा रुप्या तुल दिदो, जोतरा हुयो हित्तियो क सोमवतला कोयो हुतो, अर्थात् चार सोव ओसा शेकेल जे व्यापारी मा चालता हुता। ");
INSERT INTO dhn_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","ओस कोरीन एप्रोन क जागो, जो मम्रे क सामने मकपेला मा हुती, हुयो गुफा भेळ आरु हेनु आखा झाड़ो भेळ जो ओका मा आरु ओका च्यारु मेर पावी पोर हुता, ");
INSERT INTO dhn_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","जोतरा हित्ति ओका नोगोर क झोपला सी लागाड़ीन माहाय जाता होता, हेनु आखा क ओगोळ अब्राहम क हुकुम पाक्के रिते आय गोय। ");
INSERT INTO dhn_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","एर वाद अब्राहम न आपसी लाड़ी सारा क हेन मकपेला वाळी जागा क गुफा मा, जो मम्रे क अर्थात हेब्रोन क ओगोळ कनान देश मा छे, धुळु आप्या। ");
INSERT INTO dhn_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","ओस कोरीन हुयु जागु गुफा भेळ जु हेरेमा होतो, हित्तियो क भीनी सी बीड़ा क लिय अब्राहमन हुकुम मा पाक्के रीते सी आय गोय। ");
INSERT INTO dhn_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","अब्राहम हीमी डावो हुय गयो होतो आरु ओकी ओमोर घोनी होती आरु योहोवा न आखी वातो मा ओको बोरकोत आपलो हुतो। ");
INSERT INTO dhn_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","अब्राहम न आपसा हेना दास सी, जो ओका घोर मा पुरनिया आरु ओकी आखी जायदाद पोर होक होतो, कयो, “आपसु हात मारा जांघ क निचो मेल; ");
INSERT INTO dhn_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","आरु मार सी आकाश आरु कोळी क परमेश्वर योहोवा क इना वारा मा शपथ खा की तु मारा पुर्या क लिय कनानियो क पुरायटा मा सी, जिन्दरे विच मा रोवे, कुदाक नी लावसे। ");
INSERT INTO dhn_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","बाखुन तु मारा देश मा मारात कुटुम्ब क पास जाईन माता पुर्या इसहाक क लिय एक लाड़ी ली आवीस।” ");
INSERT INTO dhn_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","दास न हेनासी कयो, “काहमाईन हुयी बाई इना देश मा मारा सात नि आवने हिण्डे; ती काय मेसे तारा पुर्य क हेना देश मा जां सी तु आयो छे ली जानो पोड़से?” ");
INSERT INTO dhn_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","अब्राहम न हेना सी कयो, “चोकचोयु रोह, मारा पुर्या क होयां कदी नी ली जाजी। ");
INSERT INTO dhn_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","सोरोग क परमेश्वर योहोवा, जु मेसे मारा बाबा क घोर सी आरु मारु जोन्मोन–जागु गोथू ली आवीन मार सी शपथ खादो आरु कयो कि हांव एना देश तारा ओवलियाद क आपीस, हुयोत आपसा दुत तारे ओगोळ मुकेलसे कि तु मारा पुर्या क लिय जां सी एक बायोर ली आवे। ");
INSERT INTO dhn_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","बाखुन काहमाईन हुयी बायर तारे साते आवने नी चाहे तित्यार तु इनी शपथ सी छूट जाईस; बाखुन मारा पुर्या क होयां झुनी लिजाय।” ");
INSERT INTO dhn_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","ती हेरो दास न आपना स्वामी अब्राहम क जांघ क नेचो आपसो हात मेलीन हेनासी इन वाराम शपथ खादो। ");
INSERT INTO dhn_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","ती हुयो दास स्वामी क उटड़ा मा सी दस उटड़ा नेवाड़ीन, ओका सब वारु–वारु पदार्थ मा सी काहाई काहाईन लिन चाल्यु आरु मेसोपोटामिया देश मा नाहो क नाहोर क पास पुग्यो। ");
INSERT INTO dhn_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","हुयो उटड़ा क नगर सी खोयड़े एक कुवा क पास बठाड़ीयो। हुयो सान्तोन टेम हुतो, जेने टेमे बायरा पानी भोरने क लिय नीकोळे। ");
INSERT INTO dhn_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","हुयो कोहने लाग्यु, “हे मारा स्वामी अब्राहम क परमेश्वर योहोवा, आज मारा काम क वारु कोर, आरु मारा स्वामी अब्राहम पोर गीन कोर। ");
INSERT INTO dhn_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","देख, हांव जळ क इना कुवा क पास उबो छे; आरु गाववाळा क पुरायटा पानी भोरने क लिय नीकोळीन आय रोया: ");
INSERT INTO dhn_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","ओतरान कोरिन ओसो होयने दे कि जेनि पुराय सी हांव कोहो, ‘तारु वोटळु मारे भिनी नेड़ो कोर कि हांव पानी पियो,’ आरु हुयी कोहे, ‘ले, पी ले, पोछोळ हांव तारा उटड़ा क वी पावीस,’ : यो तोसोत होये जो तु आपसा दास इसहाक लिय राखलो होय; इन रीते हांव जान लिस कि रु मारा स्वामी पोर गीन कोरलु छे।” ");
INSERT INTO dhn_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","आरु ओसो होयो कि जोत्यार हुयो विनता करतोत् हुतो कि रिबका, जी अब्राहम क भाई नाहोर क पोयदा होयली मिल्का क पुर्य बतुएल क पुराय होती, हुयी खांदा पोर वोटवो लीन आवी। ");
INSERT INTO dhn_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","रीबिका घण घाटळी आरु छल्लि हुती, आरु कुदा मानुसक मुय नी देखी हुती। हुयी कुवा मा झोर क पास उतोर गोय, आरु आपसो वोटवो भोरीन ओळी उपोर आवी। ");
INSERT INTO dhn_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","ती होयो दास हिनी से मिळने कोरीन दोवड़्यो, आरु कयो, “आपसा वोटळा मासी थुड़ोक पानी मेसे पाय दे।” ");
INSERT INTO dhn_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","हुयी कोहि, “हे मारा पोरबु, पी ले,” आरु हुयी तावनी सी वोटवो उतारीन हात हाते ओको पाय देदी। ");
INSERT INTO dhn_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","जोत्यार हुयी ओको पाय देदी, ती कयी, “हांव मारा उटड़ा क लिय वी ती लोगुन पानी भोर भोरीन लियावीस, जोत्यार लोगुन चे पानी नी पिदा।” ");
INSERT INTO dhn_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","ती हुयी तोत्यारुत आपसा वोटळाम क पानी होदा मा उथलावीन ओळी कुवा पोर भोरने क दौवड़ीन गोय, आरु ओका सब उटड़ा क लिय पानी भोर देदी। ");
INSERT INTO dhn_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","हुयु मानुस हेरे भीनी हुग हुगु घबरायने क सात ताकतो रोईन विचार कोरतो हुतो कि योहोवा मारी यात्रा सफल कोर्‌यो की नी। ");
INSERT INTO dhn_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","जोत्यार उटड़ा पी लेदा, ती हुयु मानुसन आदला तुलान सोना क एक नोथ निकाळीन ओको आप्यो, आरु दस तुला क काळ्या हातो मा पेराय देदो; ");
INSERT INTO dhn_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","आरु पुछ्यो, “तु कुनीन पुराय छे, यो मेसेक कोव। काय तारा बाबान घोर मा आमरे रोहने क लिय जागु छे?” ");
INSERT INTO dhn_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","जोपाप आपी, “हांव ते नाहोर क जन्माए मिल्का क पुर्य बतुएल क पुराय छे।” ");
INSERT INTO dhn_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","आरु हुयी हेनासी कोहि, “आमरे यां पुआल आरु चारो बेस छे, आरु रोहने क लिय जागो वी छे।” ");
INSERT INTO dhn_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","ती हुयु मानुसन मुनको झुकावीन योहोवा क वांदीन कयो, ");
INSERT INTO dhn_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“सोयाव्वु छे मारु स्वामी अब्राहम क परमेश्वर योहोवा, जु आपसी गीन आरु छाचाय क मारा स्वामी पोर सी छेटो नी कोर्‌यो; योहोवा न मेसे वारु वाट पोर चालाड़ीन मारा स्वामी क भाई बोन्या क घोर पोर पुगाड़ देदलु छे।” ");
INSERT INTO dhn_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","ती होयी पुराय दौवड़ीन आपसी आईश् क घोर मा यी आखी कोवीन सोमवाड़ी। ");
INSERT INTO dhn_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","ती लाबान जो रिबका क भाई हुतो, खोयड़े कुवा क पास हेना मानुसक पास दोड़ीन गयो। ");
INSERT INTO dhn_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","आरु ओसो हुयो कि जोत्यार हुयो ओका नथ आरु आपसी बहनीश् रिबका क हात मा हुये कंगन वी देख्यो, आरु ओकी यी वात वी सोमयो कि हुयो मानुस मार सी ओसी वात कोर्‌यो; ती हुयो हेना मानुसक पास गयो; आरु काय देख्यो की हुयो कुवा क धोड़े उटड़ा क पास उबो छे। ");
INSERT INTO dhn_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","हुयो कयो, “हे योहोवान चां सी सोयाव्वु मानुष, धोड़्ये आव। तु काहा खोयड़े उबु छे? हांव घोर काजे, आरु उटड़ा क लिय वी जागो तियार कोरलो छे।” ");
INSERT INTO dhn_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","इना पोर हुयो मानुस घोरमा गोयो; आरु लाबान न उटड़ा क काठीया उगाड़िन हेनुक पुआल आरु चारो आप्यो, आरु ओकोक आरु ओका साती क पाय धुवने क पानी आप्यो। ");
INSERT INTO dhn_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","ती अब्राहम क दास क ओगोळ जलपान क लिय काहीन मेल देदा; बाखुन हुयो कयो, “हांव जोत्यार लोगुन आपसो प्रयोजन नि कोय दोम, ती लोगुन काय नी खाईस्।” लाबान न कयो, “कय दे।” ");
INSERT INTO dhn_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","ती हुयो कोयो, “हांव ते अब्राहम क दास छे। ");
INSERT INTO dhn_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","योहोवा न मारा स्वामी क मोटी बोरकोत आपलो छे, ओतरान कोरिन हुयो मोटो मानुस होय गोयो छे; आरु हुयो ओका गाडरा–बुकड़ा, गाय बुईल, सोनो रिपिया, दास दासीया, उटड़ा आरु गोदड़ा छे। ");
INSERT INTO dhn_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","आरु मारा स्वामी क लाड़ी सारा क डाहवारा मा हिनासी एक पुर्य पोयदा होयलो छे; आरु हेना पोर्या क अब्राहम न आपसो आखा काहिय आप देदलो छे। ");
INSERT INTO dhn_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","मारा स्वामी न मेसे यी शपथ खावाड़लो छे, ‘हांव ओका पुर्या क लिय कनानियो क पुरयटा मा सी, जिना देश हुयु रोहे, कुय पुराय नी लावीस। ");
INSERT INTO dhn_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","हांव ओका बाबा क घोर आरु कुल क मानषो क पास जाईन ओका पुर्या क लिय एक बायर ली आवीस।’ ");
INSERT INTO dhn_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","ती हांव आपसा स्वामी सी कयो, ‘काहमाईन हुयी बायर मारे पोछोळ नी आवे।’ ");
INSERT INTO dhn_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","ती हुयो मारी सी कयो, ‘योहोवा, जिना ओगोळ हांव चालतु आय रोयु, हुयो तारे पुठी आपसा दुत क मोकोळीन तारी यात्रा क सोफोल कोरसे; आरु तु मारा कुल, आरु मारा बाबा क घोराना मासी पुर्या क लिय एक बायर लाय सोकीस। ");
INSERT INTO dhn_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","तु तीत मारी शपथ सी छुटीस, जोत्यार तु मारा कुल क मानषो क पास पुगीस; आरु काहमाईन हुये तुखे पुराय नी आपे, ती तु मारी शपथ सी छूटीस।’ ");
INSERT INTO dhn_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","ओतरान कोरिन हांव आज हेना कुवा क धोड़े आवीन कोहने लाग्यु, ‘हे मारा स्वामी अब्राहम क परमेश्वर योहोवा, काहमाईन तु मारी इनी यात्रा क सोफोल कोरतु होय; ");
INSERT INTO dhn_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","ती देख, हांव पानी क इना कुवा क धोड़े उबो छे; आरु ओसो होये कि जो कुमारी पानी भोरने क लिय आवे, आरु हांव तेनी सी कोवो, “आपसा वोटळा मासी मेसे थुड़ो पानी पाव,” ");
INSERT INTO dhn_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","आरु हुयी मार सी कोहे, “पी ले, आरु हांव तारा उटड़ा क पिने क लिय वी पानी भोर दीस,” हुयी चीत बायर रोहे जेनीक योहोवा मारा स्वामी क पुर्या क लिय राखलो छे।’ ");
INSERT INTO dhn_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","मे ते मोनोत मोनोम यो कोवतु होतु कि देख्यु रिबका खांदा पोर वोटलो लीन निकोळीन आवी; ओळतेन हुयी झोरो क पास उतरीन भोरने लागी। हांव हेनीसी कयो, ‘मेसे पाय दे।’ ");
INSERT INTO dhn_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","आरु हुयी छाटीत सी आपसा वोटळा क खांदा पोर सी उतारीन कोयी, ‘ले, पी ले, पोछोळ हांव तारा उटड़ा क वी पायदीस,’ ओसकोरीन हांव पी लेदु, आरु हुयी उटड़ा क वी पाय देदी। ");
INSERT INTO dhn_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","ती हांव हेनीक पुछ्यु, ‘तु कुनीन पुराय छे?’ हुयी कोहि ‘ मे ते नाहोर क जन्माए मिल्का क पुर्य बतुएल क पुराय छे,’ ती हांव हेनीक नाक मा हुयो नथ आरु ओका हातोम हुये कंगन पेराय देदु। ");
INSERT INTO dhn_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","ओळतेन हांव मुनको नेड़ो कोरिन योहोवा क वान्द्यो, आरु आपसा स्वामी अब्राहम क परमेश्वर योहोवा क सोयाव्वु कयो, काहकी हुयो मेसे वारु वाट्ये पुगाड़लु कि हांव आपसा स्वामी क पुर्या क लिय ओकाज कुटुम्ब क पुराय क लीन जाम। ");
INSERT INTO dhn_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","ओतरान कोरिन हीमी, काहमाईन तुमु मारा स्वामी क सात गीन आरु छाचाय क वेहवार कोरनो चाहे, ती मेसेक कोहु; आरु काहमाईन नी चाहता होय, तेवी मेसेक कोय देवु; तोसु हांव जेवड़्या भीनी एने डाख्र्या भिनी ओळी जाम।” ");
INSERT INTO dhn_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","ती लाबान आरु बतुएल न जोपाप आप्या, “यी वात योहोवा भिनी गोथी होयली छे; ओतरान कोरिन हामु मानुस तार सी नी तो भलो कय सकता छे नी भुण्डो। ");
INSERT INTO dhn_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","देख, रिबका तारे ओगोळ छे, हेनीक ली जा, आरु हुयो योहोवा क बुलो क ओनसारे तारा स्वामी क पुर्या क लाड़ी होय जाय।” ");
INSERT INTO dhn_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","हेन्दरी यी वात सोमळीन, अब्राहम क दास न भिमा पोड़ीन योहोवा क वान्द्यो। ");
INSERT INTO dhn_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","ओळतेन हुयो दास न सोना आरु या रिपिया गोहनो, आरु छींदरा निकाळीन रिबका क आप्यो; आरु ओका भाई आरु आईस क वी हुयो अनमोल सोमान आप्यो। ");
INSERT INTO dhn_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","ती हुये आपसा संगी जोना भेळ खादा, आरु रात हुयांत रोया। हुये वेगात उठिन कोया, “मेसेक मारा स्वामी क पास जाने क लिय विदा कोरु।” ");
INSERT INTO dhn_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","रिबका क भाई आरु आया न कया, “पुराय क आमरे पास थुड़ाक दाहड़ा, अर्थात कोम सी कोम दोस दाहड़ा आरु रोहने दे; ओळतेन हेरे वाद यी जात रोहसे।” ");
INSERT INTO dhn_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","हुयो हेनुक कयो, “योहोवा न जु मारी यात्रा क सफल कोरलो छे, ओतरान कोरिन तुमु मेसे मा रुकु, हीमी मेसे जाने देवु कि मे आपसा स्वामी क पास जाम।” ");
INSERT INTO dhn_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","हुये कोया, “हामु पुराय क बुलावीन पुछ लेजे, आरु देखसु कि होयी काय कोवे।” ");
INSERT INTO dhn_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","आरु हुये रिबका क बुलाविन हेनीसी पुछ्या, “काय तु इना मानषो क सात जाईस?” हुयी कोहि, “हाव्, हांव जाईस।” ");
INSERT INTO dhn_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","ती हुये आपसी बोहनीस रिबका, आरु ओकी धाय, आरु अब्राहम क दास आरु ओका साती, सबो क विदा कोर्या। ");
INSERT INTO dhn_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","आरु हुये रिबका क बोरकोत आपीन कोया, “हे आमरी बोहनीस, तु हजारु लाखो क आदिमाता होये, आरु तारा ओवलियाद आपसा जोमो क नोगोर क आदिकारी होये।” ");
INSERT INTO dhn_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","ती रिबका आपसी सहेलिया भेळ गोय, आरु उटड़ा पोर चोढ़ीन हेना मानुसक पोछोळ जात रोय। ओस कोरीन हुयो दास रिबका क सात लीन चाल दिदो। ");
INSERT INTO dhn_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","इसहाक जु दोखेवरे देश मा रोहतु होतु, लहेरोई नावोन कुवा सी होईन आवतु होतु। ");
INSERT INTO dhn_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","सांतोन टेम इसहाक खोयड़ा मा धीयान कोरीन निकोळ्या हुता; आरु हुयो डुळा उचाकोरीन काय देख्यो कि उटड़ा आवने बाज रोया। ");
INSERT INTO dhn_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","रिबका वी डुळा उचाकोरीन इसहाक क देखी, आरु देखीजुन उटड़ा पोर सी उतरी पोड़ी। ");
INSERT INTO dhn_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ती हुयो दास सी पुछ्यो, “जे मानुस खोयड़ा पोर आपनुक मेळने क आवे, ती कुन छे?” दास न कयो, “हुयो ते मारो स्वामी छे।” ती रिबका न घुमतो लीन आपसा मुय क ढां लेदी। ");
INSERT INTO dhn_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","दास न इसहाक हेरो आखी वात सोमवाड़्यो। ");
INSERT INTO dhn_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","ती इसहाक रिबका क आपसी आया सारा क तंबु मा ली आयो, आरु ओको इहयाव कोरीन हेनीसी मोंग कोर्‌यो। ओस कोरिन इसहाक क आया क मौत क वाद मा शान्ति जोड़ी। ");
INSERT INTO dhn_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","ती अब्राहम न एक आरु लाड़ी बनायो जेरो नाव कतुरा हुतो। ");
INSERT INTO dhn_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","हेरेसी जिम्रान, योक्षान, मदान, मिद्यान, यिशबाक, आरु शुह पोयदा हुया। ");
INSERT INTO dhn_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","योक्षान सी शबा आरु ददान पोयदा हुया; आरु ददान क ओवलियाद मा अश्शुरी, लतुशी, आरु लुम्मी लुग हुया। ");
INSERT INTO dhn_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","मिद्यान क पुर्या एपा, एपेर, हनोक, अबीदा, आरु एल्दा हुया, ये सब कतुरा की ओवलियाद हुया। ");
INSERT INTO dhn_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","इसहाक क ते अब्राहम न आपसो आखो काय आप्यो। ");
INSERT INTO dhn_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","बाखुन अब्राहम आपसी रखेलियो क पुर्या क काहीन आपीन आपसा जिवतात आपसा पुर्या इसहाक क पास सी उगेवनो देश मा मोकली देदो। ");
INSERT INTO dhn_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","अब्राहम क पुरी ओमोर एक सोव पचहत्तर साल क हुयो। ");
INSERT INTO dhn_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","अब्राहम क डोबोल ओमोर होयने क कारण अर्थात् आखा डाहवारा क टेमे जीव छूट गयो, आरु हुयो आपसा मानषो मा जाय भेटायु। ");
INSERT INTO dhn_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","हेरा पुर्या इसहाक आरु इश्माएल न, हित्ती सोहर क पुर्या एप्रोन क मम्रे क ओगोळवाळी जागा मा, जी मकपेला क गुफा हुती, ओको गाड़्या; ");
INSERT INTO dhn_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","अर्थात् जु जागु अब्राहम न हित्तियो सी मुले लेदो हुतो; ओकाज मा अब्राहम आरु ओकी लाड़ी सारा दुयो क गाड़ दिदा। (उत्पत्ती 23:16) ");
INSERT INTO dhn_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","अब्राहम क मोरने क वाद मा परमेश्वर न ओका पुर्या इसहाक क जु लहेरोई नावोन कुवा क पास रोहतो हुतो, बोरकोत आप्यो। ");
INSERT INTO dhn_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","अब्राहम क पुर्य इश्माएल जु सारा क मिसरी दासी हाजिरा सी पोयदा हुयो होतो, ओकी यि ओवलियाद छे। ");
INSERT INTO dhn_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","इश्माएल क पुर्या क नाव आरु ओवलियाद यि छे: अर्थात् इश्माएल क मोटलो पुर्य नबायोत, ओळी केदार, अद्बेल, मिबसाम, ");
INSERT INTO dhn_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","मिश्मा, दुमा, मस्सा, ");
INSERT INTO dhn_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","हदद, तेमा, यतुर, नापीश, आरु केदमा। ");
INSERT INTO dhn_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","इश्माएल क पुर्या ये ओतरात हुया, आरु ईनु क नावो क ओनसारे इन्दरो गाँव, आरु छावनियो क नाव वी पोड़्यो; आरु येत बारे आप आपसा कुक का डाहला हुया। ");
INSERT INTO dhn_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","इश्माएल क पुरी ओमोर एक सोव तीन कोम चावीस साल क हुयो; ती ओका जीव छूट गयो, आरु हुयो आपसा मानषो मा भेसकाय गोयो। ");
INSERT INTO dhn_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","ओका ओवलियाद हवीला सी शुर लोगुन, जे मिसर क ओगोळ अश्शुर क वाटो मा छे, बोस गोया; आरु हेन्दरु वाटू ओका भाई बोन्या क ओगोळ पोड़्यो। ");
INSERT INTO dhn_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","अब्राहम क पुर्या इसहाक क ओवलियाद यी छे : अब्राहम सी इसहाक पुयदा हुयो; ");
INSERT INTO dhn_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","आरु इसहाक न चावीस साल क होईन रिबका सी, जी पद्दनराम क वासी, अरामी बतुएल क पुराय आरु अरामी लाबान क बहनीष हुती; इयाव कोर लेदु। ");
INSERT INTO dhn_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","इसहाक क लाड़ी वान्टी होती, ओतरान कोरिन हुयो हेरा योहोवा सी विनता कोर्‌यो; आरु योहोवा न ओकी विनता सोमळीयो, ओसकोरीन ओकी लाड़ी रिबका भारपाये होयी ");
INSERT INTO dhn_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","पुर्या ओका पेटो मा आम्बासाम्बा थाबाईन एक दीसरा क कुटने लाग्या। ति हुयी कोहि, “मारी जी ओसी वेला रोहसे ती हांव कोसी जोवत्ली रोहिस?” आरु हुयी योहोवा क मोरजी पुछने क गोय। ");
INSERT INTO dhn_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","ती योहोवा न हेनी सीइ कयो, “तारा पेटो मा दुय जाति छे, आरु तारा कुखो सी जोसा निकोळसे दुय राज्य क मानुस आंग्ये होयसे, आरु एक राज्य क मानुस दुसरा सी वोदु ताकोतवाळा रोहसे, आरु मोटलो पुर्यु नानला क होको मा रोहसे।” ");
INSERT INTO dhn_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","जोत्यार हेरो पोखड़ायने क टेम आयो, ती काय देखा पोड़्यो की ओका कुखो मा जोवळीया पुर्या छे। ");
INSERT INTO dhn_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","पेहलु जु पोयदा होयु चू रातलु निकोळ्यु, आरु ओको आखो डील काम्बवा क जोसो रोममय हुतो; ओतरान कोरिन ओको नाव एसाव पाड़्या। ");
INSERT INTO dhn_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","पोछोळ ओको भाई आपसा हातो सी एसाव क पायोनपाटली क धोरीन पोयदा हुयो; आरु ओको नाव याकुब पाड़्या। जोत्यार रिबका न हेनुक जोन्म देदी ती इसहाक साठ साल क हुतो। ");
INSERT INTO dhn_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","ओळतेन हुये पुर्या मोटा होयने लाग्या, आरु एसाव ते जोन्गोलो मा रोहीन चतुर शिकार खेलनेवाळो हुय गोयो, बाखुन याकुब सुदो मानुस हुतो आरु तोम्बुत मा रोया कोरतु होतु। ");
INSERT INTO dhn_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","इसहाक एसाव क अहेर क मांस खाया कोरतो हुतो, ओतरान कोरिन हुयो हेनासी मोंग रोखतो हुतो; बाखुन रिबका याकुब सी मोंग राखती हुती। ");
INSERT INTO dhn_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","एक दाहड़ो याकुब खाने क लिय काहीन दाळ चुड़ेवतु होतु; आरु एसाव जोन्गोल सी घाबरायीन आयु। ");
INSERT INTO dhn_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","ती एसाव न याकुब सी कयो, “हुयी जी रातली चीज छे, हेनी रातली चीजों मासी मेसे काहीन खावाड़, काहकी हांव घाबराय रोयु।” ओस कोरिन हेरो नाव एदोम वी पोड़्यो। ");
INSERT INTO dhn_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","याकुब न कयो, “आपसा पहिलौठेक होक आज मारे हातोम वेच दे।” ");
INSERT INTO dhn_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","एसाव न कयो, “देख, हांव ते हीमी मोरने पोर छे : ओतरान कोरिन पहिलौठे क होक सी मारो काय फायदु होयसे?” ");
INSERT INTO dhn_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","याकुब न कयो, “मार सी हीमी शपथ खा,” अत: हुयो हेना सी शपथ खादो, आरु आपसा पहिलौठा क होक याकुब क हात वेच देदो। ");
INSERT INTO dhn_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","इना पोर याकुब न एसाव क रुटा आरु चुड़वली मसुर कि दाळ आप्यो; आरु हुयो वी खादा पीदा, आरु उठीन जात रोयो। यो एसाव न आपसो पहलौठे क होको क भुण्डोत जान्यो। ");
INSERT INTO dhn_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","उका देश मा काळ पोड़्यो, यो उना पेहला काळो सी ओलोग हुतो जो अब्राहम क दाहड़ा मा पोड़लो हुतो। ओतरान कोरिन इसहाक गरार क पलिश्तिया क राजा अबीमेलेक क पास गुयो। ");
INSERT INTO dhn_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","हुयां योहोवा न ओको दोर्शन आपीन कयो, “मिसर मा मां जाय; जो देश हांव तुखे देखाड़ो तेना मा रोव। ");
INSERT INTO dhn_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","तु एना देश मा रोवे, आरु हांव तारे साते रोहीस, आरु तुखे बोरकोत आपीस; आरु यो आखो देश हांव तुसेक आरु तारी ओवलियाद क आपीस; आरु जु वायदु मे तारा बाबा अब्राहम सी खादु होतु, चो हांव पुरो कोरीस। ");
INSERT INTO dhn_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","हांव तारे ओवलियाद क वादळा क तारागण क जोसा कोरीस; आरु हांव तारा ओवलियाद क यो आखो देश आपीस, आरु कोळी क आखी जातीक तारा ओवलियाद क लारे सोयाव्वु मानायसे। ");
INSERT INTO dhn_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","काहकी अब्राहम मारी वात मान्यु, आरु जो हांव हेनाक आप्यु होतु हेनाक आरु मारी हुकुम, कायदा आरु व्यवस्था क पाळन कोर्‌यो।” ");
INSERT INTO dhn_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","ओतरान कोरिन इसहाक गरार मा रोय गोयु। ");
INSERT INTO dhn_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","जोत्यार हेना जागा क मानुस हेरी घोरवाळी क वारा मा पुछ्या, तोत्यार हुयु यो बिहिन विचारीन कि काहमाईन हांव इनुक मारी घोरवाळी कोहीस ती यां वाळा मानुस रिबका क लीय यी घोन घाटावी छे मेसेक मार देसे, जोपाप आप्यु, यी ते मारी बोहनीस छे (उत्प 12:12,13. 20:2) ");
INSERT INTO dhn_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","जोत्यार इसहाक क होंया रोहता बेस दाहड़ा वित गोया, ती एक दाहड़ु पलिश्तिन राजा अबीमेलेक खिड़की मा सी छापिन काय देख्यु की इसाहक आपसी घोरवाळी रिबका क सात मोंग कोरने बाज रोयु। ");
INSERT INTO dhn_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","ती अबीमेलेक इसहाक क बुलावीन कोयु, होयी ते खोरी तारी घोरवाळी छे; ते वी तु काहा आपसी बोहनीस कोयु? इसहाक जोपाप आप्यु, “हांव यो विचारलु कि ओसो नी होवे की एरे जुगु मारी मोत होये।” ");
INSERT INTO dhn_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","अबीमेलेक कोयु, “तु आमरे सी यो काय कोर्यु? ओसो ते पोंचू मासी कोय तारी घोरवाळी क पुठी सहज सी कुकर्म कोर सोकतो, आरु तु आमुक पापो मा फोसाड़तु।” ");
INSERT INTO dhn_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","ओतरान कोरिन अबीमेलेक न आपसी आखी पोंचू क हुकुम आप्यो, “जु कोय एना मानुस निते एरी घोरवाळी क छीमसे, चो खोरी माराय जासे।” ");
INSERT INTO dhn_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","ओळतेन इसहाक न तेना देश मा जुप्यु वेर्यु, आरु तेनात साल मा सोव गुणा फोव कोमायु; आरु योहोवा न ओको बोरकोत आप्यु, ");
INSERT INTO dhn_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","आरु हुयो बोढ़्यो आरु ओकी उन्नती होयति रोही, यां लोगुन कि हुयो बेस मोटु मानुस होय गोयु। ");
INSERT INTO dhn_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","जोत्यार हेरा गाडरा बुकड़ा, गाय बुईल, आरु बेसका चाखर्रीया होया, ती पलिश्ति हेनासी घाड़ाय कोरने लाग्या। ");
INSERT INTO dhn_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","ओतरान कोरिन जोतरा कुवा क हेरा बाबा अब्राहम क दास न अब्राहम जोवतलो हुतो ती खुंदला, तेनुक पलिश्तिन मानुस धुळा सी भोर देदा। ");
INSERT INTO dhn_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","ती अबीमेलेक न इसहाक सी कयो, “आमरेन चा रोहीन जात रोव; काहकी तु आमरे सी बेस मोटू होय गोयलु छे।” ");
INSERT INTO dhn_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","ती इसहाक होयां सी जात रोयु, आरु गरार क घाटी मा आपसु तंबु उबु कोरीन रोहने लाग्यु। ");
INSERT INTO dhn_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","ती जे कुवा ओको बाबो अब्राहम क दाहड़ा मा खुंदला होता, आरु अब्राहम क मोरने क वाद पलिश्तिन मानुस भोर देला, तेनुक इसहाक पोछू खुंदाड़्यु; आरु हेन्दरा चेत नाव राख्यु, जो हेरु बाबु पाड़लु। ");
INSERT INTO dhn_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","ओळतेन इसहाक क दासो क घाटी मा खुंद खुंदता उहवता जळ क एक झोर जोड़्यो। ");
INSERT INTO dhn_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","ती गरार क गुळाव्या न इसाहक क गुळाव्या सी लोड़ाय पाड़ला आरु कोया, “यो जळ आमरो छे।” ओतरान कोरिने हेना कुवा क नाव एसेक पाड़्या; काहकी हुये हेन्दरे सी लोड़ाया हुता। ");
INSERT INTO dhn_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","ओळतेन हुये दुसरु कुवु खुन्दया, आरु हेये हेना क लिय वी लोड़ाय कोर्या; ओतरान कोरिन हेये ओको नाव सित्ना पाड्या। ");
INSERT INTO dhn_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","ती हुये होयां गोथा निकोळीन एक आरु कुवु खुंदाड़्यु; आरु हेना वाटु हेये नी लोड़ाया; ओतरान कोरिन हुये ओको नाव यो कोवीन रहोबोत पाड्या, “हिमी ते योहोवा न आमरे लिय बेस जागु आपलु छे, आरु आमु एना देश मा फुले फलेंगे।” ");
INSERT INTO dhn_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","होयां सी हुये बेरसेबा जात रोया। ");
INSERT INTO dhn_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","आरु तेने दाहड़ योहोवा राती ओको दर्शन आपीन कोयो, “हांव तारा बाबा अब्राहम क परमेश्वर छे; मा बिहये, काहकी हांव तारे साते छे, आरु मारा दास अब्राहम क लिय तुसे बोरकोत आपीस, आरु तारा ओवलियाद वोदाड़ीस।” ");
INSERT INTO dhn_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","ती हुयो होयां एक वेदी बोनायो, आरु योहोवा सी विनता कोर्‌यो, आरु आपसु तंबु होयांत उबो कोर्‌यो; आरु होयां इसाहक क दासो न एक कुवो खुंदो। ");
INSERT INTO dhn_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","ती अबीमेलेक आपसा मुखी अहुज्जत आरु आपसा सेनापती पीकोल क सात लीन गरार सी ओका पास मा गयो। ");
INSERT INTO dhn_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","इसाहक न हेना सी कयो, “तु मार सी घाड़ाय कोर्‌यो तुमरे विच मा सी निकाय देदलु, हिमी मारेनचां काहा आय रोयु?” ");
INSERT INTO dhn_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","हुयो कयो, “हामु ते प्रत्यक्ष देखला छे कि योहोवा तारे साते रवे छे; ओतरान कोरिन आमु विचार्या कि तु ते योहोवा भीनी से सोयाव्वु छे, एने आमरे विच मा वायदु खादा, आरु हामु तार सी इना वाराम वायदु बान्दे, ");
INSERT INTO dhn_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","की जसा हामु तुको नी छिम्या, पुन थारे साथ मा वारलोत् करला छे, आरु तुको शान्ति सी मोकलीया, हेकात् अनसारे तुको बी योहोवा सी बरकत जड़से करे।” ");
INSERT INTO dhn_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","ती हुयो हेनुक खाने आप्यु आरु हेये खादा पिदा। ");
INSERT INTO dhn_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","सोन्दारे हुये आखा वेगाद उठिन आम्बा साम्बा वायदु खादा; ती इसहाक न हेनुक विदा कोर्‌यो, आरु हुये वारु खुशी सी ओका चां सी जोत रोया। ");
INSERT INTO dhn_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","तेने दाहड़े इसहाक क दासे आवीन आपसा खुंदला कुवा क वाराम कोया, “आमुक जळ क एक सोतो जोड़लो छे।” ");
INSERT INTO dhn_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","ती हुये ओको नाव शिबा पाड़्यो; एने कारण इना नगर क नाव आज लगुन बेरसेबा छे। ");
INSERT INTO dhn_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","जव एसाव चावीस साल क हुयो, ती त्यो ओकी हित्ती बेरी न बेटी यहुदीत, आरु हित्ती एलोन की बेटी बाशमत सी इयाव कोर लेदी; ");
INSERT INTO dhn_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","आरु इनु बाय क कारण इसहाक आरु रिबका क मन को बुरो लाग्यो। ");
INSERT INTO dhn_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","जोत्यार इसहाक डावु होय गोयु, आरु ओका डुळा ओसा धुंधला पोड गोया कि ओको देखायतो नी होतो, ती हुयो आपसा मोटला पुर्या एसाव क बुलाविन कयो, “हे मारा बेटा,” हुयो कयो, “काय हुकुम।” ");
INSERT INTO dhn_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","हुयो कयो, “सोमोळ, मे ते डावु होय गोयलु छे, आरु नु जानो कि मारी मोतोन दाहड़ु कोत्यार होयसे: ");
INSERT INTO dhn_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","ओतरान कोरिन हिमी तु आपसा तेकश आरु धनुष आदि होतियार लीन खोयड़ा मा जा, आरु मारे जुगु अहेर कोरीन ली आव। ");
INSERT INTO dhn_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","तोत्यार मारे गोंहवतो खानो बोनावीन मारेनचा ली आवजी, की मे तेनाक खाईन मोरने सी पेहेल तुसे जी भोरीन बोरकोत आपो।” ");
INSERT INTO dhn_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","तोत्यार एसाव अहेर करने क खोयड़ा मा गोयु। जोत्यार इसहाक एसाव सी यी वात कोवतु होतु, ती रिबका सोमळती होती। ");
INSERT INTO dhn_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","ओतरान कोरिन रिबका आपसा पुर्या याकुब सी कोहि, “सोमोळ, हांव तारा बाबा क तारा भाईष एसाव सी यो कोहतला सोमळी छे, ");
INSERT INTO dhn_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘तु मारे जुगु अहेर कोरीन ओको सोवादो खानो बोनावे, की हांव तेनाक खाईन तुसे योहोवा क ओगोळ मोरने सी पेहेल बोरकोत आपो।’ ");
INSERT INTO dhn_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","ओतरान कोरिन हिमी, हे मारा पुर्या, मारी सोमोळ, आरु यी हुकुम मान, ");
INSERT INTO dhn_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","कि बुकड़ान चा जाईन बुकड़ा क दुय वार वारु गिदल्या ली आव; आरु हांव तारा बाबा क लिय ओको गोंहवे ओसो हेन्दरो मास क सोवाद खानो बोनावीस। ");
INSERT INTO dhn_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","ती तु तेनाक तारा बाबान्‍चा जाजी, की हुयो तेनाक मोरने सी पेहेल तुसेक बोरकोत आपे।” ");
INSERT INTO dhn_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","याकुब न आपसी आया रिबका सी कयो, “सोमोळ, मारु भाईष एसाव ते रोंआर मानुस छे, आरु हांव रोमहीन मानुस छे। ");
INSERT INTO dhn_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","काहमाईन मारु बाबु मेसे पुपावने लाग्यु, ती हांव हेरी निगाह मा ठोगारु रोहीस; आरु बोरकोतोन बोदले शाप कोमाईस।” ");
INSERT INTO dhn_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","हेरी आया हेना सी कोहि, “हे मारा बेटा, शाप तारे पोर नी मारे पोर पोड़े, तु मारी सोमोळ, आरु जाईन चे गिदल्या लिन मारेन्चा आव।” ");
INSERT INTO dhn_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","तोत्यार याकुब जाईन हेरी आयान चा ली आयु, आरु आया हेरा बाबा क गोंहवे ओसो सोवादो खानो बोनाय देदी। ");
INSERT INTO dhn_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","ती रिबका आपसा मोटला पुर्यान एसाव न घाटावा छिंदरा, जे हेरे जुळ घरमा हुता, लीन आपसा नानला पोर्या याकुब क पेराय देदी; ");
INSERT INTO dhn_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","आरु गिदल्यान खालड़ा क हेरा हातो मा आरु ओका चुपड़ा गोळा मा वेटाय देदी; ");
INSERT INTO dhn_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","आरु हुयी सोवादो खानो आरु आपसा बोनावला रुटा वी आपसा पुर्या याकुब क हातो मा आप देदी। ");
INSERT INTO dhn_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","ती हुयो आपसा बाबा क पास मा गयो आरु कयो आरु कयो, “हे मारा बाबा,” हुयो कयो, “काय वात छे? हे मारा पुर्या, तु कुन छे?” ");
INSERT INTO dhn_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","याकुब न आपसा बाबा सी कयो, “हांव तारु मोटलु पुर्यु एसाव छे। हांव तारा हुकुम क ओसो कोरलो छे; ओतरान कोरिन उठ आरु बोठीन मारो शिकार क मांस मा सी खा, की तु मेसे बोरकोत आपे।” ");
INSERT INTO dhn_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","इसहाक न आपसा पुर्या सी कयो, “हे मारा पुर्या, काय कारण छे की हुये तुसे ओतरो छाटो जोड़ गोयो?” हुयु जोपाप आप्यु, “तारु परमेश्वर योहोवा न ओको मारे ओगोळ कोर देदो।” ");
INSERT INTO dhn_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","ओळतेन इसहाक न याकुब सी कयो, “हे मारा पुर्या, धोड़े आव, हांव तुसे पुपावीन जानो कि तु छाचीन मारु पुर्यु एसाव छे की नी।” ");
INSERT INTO dhn_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","ती याकुब आपसा बाबा इसहाक क धड़ गयो, आरु हुयो ओको पुपावीन कयो, “कोळ ते याकुब क सो छे, बाखी हात एसाव क सो मालुम पोड़े।” ");
INSERT INTO dhn_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","आरु हुयो ओको नी उळख्यो नी, काहकी ओका हात हेरा भाईष एसाव सारको बुराळो नी हुतो; एने हुये ओको बोरकोत आप्यो। ");
INSERT INTO dhn_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","आरु हुयो पुछ्यो, “काय तु छाचीन मारु पुर्यु एसाव छे?” हुयो कयो, “हाव, हांव छे।” ");
INSERT INTO dhn_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","तोत्यार हुयो कयो, “खानाक मारे धड़ ली आव, कि हांव आपसा पुर्या क अहेर क मांस मासी खाईन, तुसे बोरकोत आपो।” ती हुयो ओको हेरा धड़ मा आयो, आरु हुयो खादो; आरु हुयो ओको पास मा दाखमधु वी लायो, आरु हुयो पिदो। ");
INSERT INTO dhn_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","ती हेरो बाबा इसहाक न हेना सी कयो, “हे मारा पुर्या, धड़े आवीन मेसे गुवु दे।” ");
INSERT INTO dhn_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","ओका धड़ जाईन ओको गुवु देदो; आरु हुयो ओका छिन्दरा क गोन्दीन ओको यो बोरकोत आप्यो, देख, मारा पुर्या क गन्ध जो ओसा खेत क स छे जिना पोर योहोवा न बोरकोत आपली होय; ");
INSERT INTO dhn_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","परमेश्वर तुसे वादळा सी धुरा, आरु कोळी क वारु सी वारी फोव, आरु घोनो सोटो अनाज आरु नवली दाखमधु आपे। ");
INSERT INTO dhn_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","राज राजोन मानुस तारा होको मा रोहे, आरु देश देशन मानुस तुसे वान्दे। तु आपसा भाष्यो क डाहलो होये, आरु तारी आया क पुर्या तुसे वान्‍दे जु तुसे शाप आपे चु श्रापित होये, आरु जु तुसे बोरकोत आपे तेनुक वी बोरकोत जोड़े। ");
INSERT INTO dhn_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","जोसोत यो बोरकोत इसहाक याकुब क आप्योत की, आरु याकुब आपसा बाबा इसहाक क ओगोळ सी निकोळी ही हुतो, की एसाव अहेर लीन आय पुग्यो। ");
INSERT INTO dhn_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","ती हुयो वी सोवादो खानो बोनावीन आपसा बाबा क पास ली आयो, आरु हेना सी कयो, “हे मारा बाबा, उठिन आपसा पुर्या क अहेर का मांस खा, ओळतेन मेसे बोरकोत आपे।” ");
INSERT INTO dhn_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","हेरा बाबा इसहाक पुछ्यो, “तु कुन छे?” हुयो कयो, “हांव तारु मोटलु पुर्यु एसाव छे।” ");
INSERT INTO dhn_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","ती इसाहक ति थोर थोर् कापतु जाईन कयो, “ओळतेन हुयो कुन होतो जु अहेर कोरिन मारेन्चा ली आवलो हुतो, आरु हांव तारे आवने सि पेहेल आखा मासी काहांय काहांय खादु आरु ओको बोरकोत आप देदु? हिमी हेनाक बोरकोत लागली वी रोहसे।” ");
INSERT INTO dhn_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","आपसा बाबान यी वात सोमळीन एसाव घोने जुरे आरु दुख सी भोरायला बुलो सि आयड़ीन आपसा बाबा सी कयो, “हे मारा बाबा, मेसे वी बोरकोत आप!” ");
INSERT INTO dhn_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","हुयो कयो, “तारो भाईष चालाकी सी आवलो, आरु तारो बोरकोत क लिन जात रोयो।” ");
INSERT INTO dhn_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","हुयो कयो, “काय हेरो नाव याकुब याने नी पाड़्या? हुयु मेसे दुय कावा रुक देदु। मारो मोटलो होक हुयुत ली ले लेदु; आरु हिमि देख, हुयु मारो बोरकोत वी ली लेदु।” ओळतेन हुयु कोयु, “काय तु मार जुगु काई वी बोरकोत नी विचारलु छे काय?” ");
INSERT INTO dhn_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","इसहाक एसाव क जोपाप अपीन कोयु, “सोमोळ, मे ते हेनाक तारो स्वामी बोनायु, आरु हेरा आखा भाईष क ओका होको मा कोर देदु, आरु अनाज आरु दाखमधु आपीन ओको पुष्ट कोरलु छे। ओतरान कोरिन हिमी, हे मारा बेटा, हांव तारे जुगु काय कोरो?” ");
INSERT INTO dhn_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","एसाव न आपसा बाबा सी कयो, “हे मारा बाबा, काय तारा मन मा एकुत बोरकोत छे? हे मारा बाबा, मेसे वी बोरकोत आप दे।” ओसो कोवीन एसाव बेस रोड़्यु। ");
INSERT INTO dhn_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","हेरु बाबु इसहाक हेना सी कयो, सोमोळ, तारो रोहनो पीयोत जागा सी छेटु होये, आरु उपोर सी वादळा क धुरो तेना पोर नी पोड़े। ");
INSERT INTO dhn_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","तु आपसी तलवार क भुरसे जोवतलो रोहीस, आरु आपसा भाईष क होको मा ते छे; बाखुन तु स्वाधीन होय जाईस, ती हेरा जुड़ा क आपसा खांदा पोर सी तुड़ नाखीस। ");
INSERT INTO dhn_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","एसाव ते याकुब सी आपसा बाबा क आपला बोरकोत क लिए घाड़ाय राख्यु; आरु हुयु विचार कोर्यु, “मारा बाबान आखरी दाहड़ा धोड़े छे, ओवळतेन हांव आपसा भाईष क मार दीस।” ");
INSERT INTO dhn_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","जोत्यार रिबका क हेरो मोटलो पुर्यु एसाव नी यी वाते देखाड़ी गोयी, ती हुयी आपसा नानला पुर्या याकुब क बुलावीन कोहि, “सोमोळ, तारो भाईष एसाव तुसे मारने कोरीन आपसा मन मा गोम राखलु छे। ");
INSERT INTO dhn_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","ओतरान कोरिन हिमी, हे मारा बेटा, मारी सोमोळ, आरु हारान क मारा भाईष लाबान क पास ढास जा; ");
INSERT INTO dhn_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","आरु थुड़ा दाहड़ा लोगुन, यानी जोत्यार लोगुन तारा भाईष क रीष नी उतरे ति लोगुन हेरेन चा रोहजी। ");
INSERT INTO dhn_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","ओळतेन जोत्यार तारा भाईष क रीश तार पोर सी उतरे, आरु जो काम तु हेर सी कोरलु छे चो हुयु विसरी जाय; ती हांव तुसे होंया बुलावने मुकलिस। ओसो काहा होये की एकुत दाहड़े मा मेसे तुमु दुयो सी रहित होयनो पोड़े?” ");
INSERT INTO dhn_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","ओळतेन रिबका न इसहाक सी कोहि, “हित्ती पुरायटा क कारण हांव आपसा जिव सी घिन कोरो; ओतरान कोरिन काहमाईन ओसो हित्ती पुरायटा मा सी, जोसो एना देश क पुरायटा छे, याकुब वी एक सी कोहे की इयाव कोर ले, ती मारा जीवोन मा काय फायदु होयसे?” ");
INSERT INTO dhn_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","ती इसहाक न याकुब क बुलावीन बोरकोत आप्यो, आरु हुकुम आप्यो, “तु कुदी कनानी पुराय सी ईयाव झुणी कोरे। ");
INSERT INTO dhn_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","पद्दनराम मा तारा मामान बाबा बतुएल क घर जाईन, होंया तारा लाबान की एक पुराय सी ईयाव कोर लेजी। ");
INSERT INTO dhn_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","जुरभोर्यु भोगवान तुसे बोरकोत आपे, आरु फलवन्त कोरिन बोढावे, आरु तु राज राज क मण्डळी क डाहलो होये। ");
INSERT INTO dhn_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","हुयो तुसे आरु तारी ओवलियाद क वी अब्राहम जोसी बोरकोत आपे, कि तु यो देश पोरदेशी होईन रोहे, आरु जिना परमेश्वर न अब्राहम क आपलो हुतो, ओको होक होय जाय।” ");
INSERT INTO dhn_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","आरु इसहाक याकुब क विदा कोर्‌यो, आरु पद्दनराम क अरामी बतुएल क पुर्य लाबान क पास जा, जो याकुब आरु एसाव कि आईश् रिबका क भाईष हुतो। ");
INSERT INTO dhn_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","जोत्यार इसहाक न याकुब क बोरकोत आपीन पद्दनराम मुकली देदो, कि हुयो होंया सी लाड़ी लावे, आरु ओको बोरकोत आपने क टेमे यो हुकुम आप्यो, “तु कुदी कनानी पुराय सी ईयाव झुणी कोरे,” ");
INSERT INTO dhn_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","आरु याकुब आसी बासान नु मानीन पद्दनराम क चाल देदु। ");
INSERT INTO dhn_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","ती एसाव यो आखो देखीन आरु यो वी विचार कोर्यु की कनानी पुरायटा मारा बाबा क इसहाक क वारु नी लागे, ");
INSERT INTO dhn_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","अब्राहम क पुर्य इश्माएल क पास गोयु, आरु इश्माएल की पुराय महलत क, जी नबायोत क बोहनीस हुती, ईयाव कोरीन घोरवाळी मा मेळवी लेदी। ");
INSERT INTO dhn_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","याकुब बेरसेबा सी निकोळीन हारान भीनी चाल्यु। ");
INSERT INTO dhn_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","आरु हुयु काहना जागाम मा पुगीन रात होयात रोहने क विचार कोर्यु, काहकी दाहड़ु बुड गोयु होतु; एकालीय हुयो हेना जागा क दोगड़ा मासी एक दगड़ा क आपसो ताकीयो बोनावीन मेल्यो, आरु हेनात जागाम सुय गोयु। ");
INSERT INTO dhn_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","ती सोपना मा काय देख्यो, की एक नीसुन कोळी पोर उबी छे, आरु हेरो मुनको सोरोग तोक पुगलो छे; आरु परमेश्वर क दुत हेरे पोर सी चोहड़े उतरे। ");
INSERT INTO dhn_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","आरु योहोवा हेरे पोर उबु होईन कोहे, “हांव योहोवा, तारा डाहला बाबा अब्राहम क परमेश्वर, आरु इसहाक क वी परमेश्वर छे; जेनी जागा पोर तु लुट रोयु, होयी हांव तुसेक आरु तारी ओवलियाद क आपीस। ");
INSERT INTO dhn_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","आरु तारो ओवलियाद कोळी क धुळा क किनका क जोसा बेस होयसे, आरु बुडेवना, उगेवना, दोखेवरे, बोखेवरो, च्यारु मेर फैल जासे: आरु तारा आरु तारा ओवलियाद क लारे कोळी क आखा कुल बोरकोत वाळा होयसे। ");
INSERT INTO dhn_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","आरु सोमोळ, हांव तारे साते रोहीस, आरु जां कावी तु जाय चां तारी गुवावी कोरीस, आरु तुसे एना देश मा पोछू ली आवीस।” ");
INSERT INTO dhn_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","ती याकुब जाग उठ्यु, आरु कोहने लाग्यु, “छाचीन एना जागा मा योहोवा छे; आरु हांव इनी वात क नी जानतु होतु।” ");
INSERT INTO dhn_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","आरु बिहतु जाईन हुयु कोयु, “यु जागु काय बिहाड़े छे! यो ते परमेश्वर क भवन क छुड़ीन आरु काय नी होय सोके; बाकी यो सोरोग क झोपलो त होसे।” ");
INSERT INTO dhn_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","कुकड़ु वासरेक याकुब उठ्यु, आरु आपसा गादि क दगड़ु लीन हेरु खाम्बु उबु कोर्यु, आरु ओका मुन्डा पोर तेल नाख देदु। ");
INSERT INTO dhn_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","हेना जागान क नाव बेतेल पाड्यु; बाखीन हेना नगर क नाव पेहेल लुज होतो। ");
INSERT INTO dhn_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","ती याकुब न यी मानता मान्यु, “काहमाईन परमेश्वर मारे साते रोहीन इनी यात्रा मा मारी गुवाळी कोरे, आरु मेसे खाने क लिय रुटा, आरु पेहरने क लिय छिंदरा आपे, ");
INSERT INTO dhn_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","आरु हांव आपसा बाबा क घोर वारु पोछु आवो; ती ती योहोवा मारु परमेश्वर कोवायसे। ");
INSERT INTO dhn_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","आरु यु दोगड़ु, जिनाक हांव उबु कोरलु छे, परमेश्वर क भवन कोहायसे: आरु जो काय तु मेसे आपसे हेरेमासी दशमांश हांव छाचीन तुसेक आप्या कोरीस।” ");
INSERT INTO dhn_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","ओवळतेन याकुब न आपसी वाट लेदु, आरु पुर्बियो क देश मा आयु। ");
INSERT INTO dhn_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","हुयो निगाह कोरिन काय देख्यो की खोयड़ा मा एक कुवु छे, आरु ओका पास मा गाडरा बुकड़ा क तिन टुवा बोठला छे; काहकी जो दगड़ो हेना कुवा क मुयो पोर धरा रोहतलो हुतो, जिनामा सी टुवा क जळ पाया कोरता हुता, हुयो भारो होतो। ");
INSERT INTO dhn_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","आरु जोत्यार आखा टुवु होंया एकठो होय जाय ती गुवाया हेना दगड़ा क कुवा क मुयो पोर गोबड़ावीन गाडरा बुकड़ा क पानी पावे, आरु ओळतेन दगड़ा क कुवा क मुयो पोर जोसा क तोसो मेल देता हुता। ");
INSERT INTO dhn_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","अत: याकुब न गुवाळ्या सी पुछ्यो, हे मारा भाष्यो, तुमु कां वाळा छे? हुये कोया, “आमु हारान वाळा छे।” ");
INSERT INTO dhn_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","ती हुये हेना सी पुछ्या, “काय तु नाहोर क पोते लाबान क उवखे?” हुये कोया, “हाव, हामु हेनाक जानजे।” ");
INSERT INTO dhn_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","ओळतेन हुयो हेनुक पुछ्यो, “काय हुयु वारलु छे?” हुये कोया, “हाव, आरगु छे आरु होयी देख, हेरु पुराय राहेल गाडरा बुकड़ा क लिय आवने बाज रोय।” ");
INSERT INTO dhn_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","हुये कोया, “देखु, हांजु ते दाहड़ु घोनु छे, ढुरोन एकठा होयनेन टेम नी; ओतरान कोरिन गाडरा बुकड़ा क पानी पावीन ओळी लीजाईन च्यारु।” ");
INSERT INTO dhn_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","हुये कोया, “हामु हिमी ओसा नी कोर सोकतला; जोत्यार आखा टुवा भेळा होये ती दगड़ा क कुवा क मुय पोर सी ढुव्वी देतला छे, आरु ती हामु गाडरा बुकड़ा क पानी पावतला छे।” ");
INSERT INTO dhn_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","हेन्दरी यी वात होयती होती कि राहेल, जी ढुरे चारती होती, आपसा बाबा क गाडरा बुकड़ा क लिन आय लागी। ");
INSERT INTO dhn_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","याकुब न आपसा मामा लाबान की पुराय राहेल क, आरु ओका गाडरा बुकड़ा क देख्यो ती धोड़े जाईन कुवा क मुयो पोर सी दगड़ा क ढुवयो आरु आपसा मामा लाबान क गाडरा बुकड़ा क पानी पायो। ");
INSERT INTO dhn_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","ती याकुब न राहेल क गुवु देदो, आरु घोने जुर्ये रोड्यु। ");
INSERT INTO dhn_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","आरु राहेल याकुब न राहेल क कोय देदु, की हांव तारु फुफेरु भाईष छे, यानी रिबका क पुर्यु छे। ती होयी दोवड़ीन आपसा बाबा सी कोय देदी। ");
INSERT INTO dhn_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","आपसा भान्जुस याकुब क खोबोर जोड़तात लाबान हेनाक मेळने कोरीन दोवड़ीन आयु, आरु गळे लागाड़ीन गुवा देदु, ओळतेन आपसे घोर ली आयु। याकुब न लाबान क आपसी आखी वात सोमवाड़्यु। ");
INSERT INTO dhn_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","ती लाबान न याकुब सी कयो, “तु ते छाचीन मारी हाड़की आरु मांस छे।” आरु याकुब एक मोहनो भोरीन हेरे साते रोयु। ");
INSERT INTO dhn_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","ती लाबान न याकुब सी कयो, “कुटुम्ब होयने क कारन तुसे ओसीत चाखरी कोरावनो मारे जुगु वारु नी होय; ओतरान कोरिन कोह हांव तुसे तारी चाखरीन बोदले काय आपो?” ");
INSERT INTO dhn_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","लाबान न दुय पुराय होती, जेनु मासी मोटली लिआ: आरु नानली राहेल होती। ");
INSERT INTO dhn_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","लिआ: क ते धुन्धला डुळा होता, बाखुन राहेल रुपवती आरु घाटावी होती। ");
INSERT INTO dhn_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","ओतरान कोरिन याकुब न, जी राहेल सी मोंग राखतु होतु, कयो, “हांव तारी नानली पुराय राहेल क लिय सात साल तारी चाखरी कोरीस।” ");
INSERT INTO dhn_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","लाबान न कयो, “एनीक पारका मानसोनचा आपने सी तुसे आपनो वारु होयसे; ओतरान कोरिन मारेंचा रोव।” ");
INSERT INTO dhn_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","अत: याकुब न राहेल क लिय सात साल चाखरी कोर्यु; आरु हुये राहेल क मोंगो क लारे थुड़ाक दाहड़ा क बराबर जान पोड़्या। ");
INSERT INTO dhn_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","ती याकुब न लाबान सी कोयो, “मारी घोरवाळी मेसे आप दे, आरु हांव हेरेन्चा जाईस, काहकी मारो टेम पुरो होय गोयलो छे।” ");
INSERT INTO dhn_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","अत: लाबान न हेना जागा क आखा मानषो क बुलावीन एकठो कोर्‌यो, आरु एक खावटी आप्यु। ");
INSERT INTO dhn_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","सान्तो क टेमे हुयु आपसी पुराय लिआ: क याकुब क पास ली गयो, आरु हुयो हेरे पास गयो। ");
INSERT INTO dhn_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","लाबान न आपसी पुराय लिआ: क ओकी दासी होयने क लिय आपसी दासी जिल्पाक आप्यो। ");
INSERT INTO dhn_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","सोन्दारे मालुम होयो की यी ते लिआ: छे, ओतरान कोरिन हुयो लाबान सी कयो, “यो तु मारे साते काय कोर्यु? हांव तारे पुठी रोहीन जी चाखरी कोर्यु, ती काय राहेल क लिय नी काय? ओळतेन तु मारे सी ओसो छल कोरलु छे?” ");
INSERT INTO dhn_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","लाबान न कयो, “आमरे यां ओसी रीती नी की मोटली पुराय सी पेहेल दीसरीन ईयहाव कोर देये। ");
INSERT INTO dhn_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","एरु साप्तु ते पुरु कोर; ओळतेन दीसरी वी तुसे हेरी‍‍ चाखरी क लिय जोड़से जो तु मारे साते रोहीन आरु सात साल लोगुन कोरजी।” ");
INSERT INTO dhn_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","याकुब न ओसोत कोर्‌यो, आरु लिआ: क सापतु क पुरु कोर्यु; ती लाबान न आपसी बेटी राहेल क वी आप्यो कि हेरी घोरवाळी होये। ");
INSERT INTO dhn_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","लाबान न आपसी बेटी राहेल क दासी होयने क लिय आपसी दासी बिल्हा क आप देदो। ");
INSERT INTO dhn_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","ती याकुब राहेल क पास वी गयो, आरु ओको मोंग लिआ: से जादा हेरे पोर होयो; आरु हुयो लाबान क सात रोहीन सात साल आरु ओकी चाखरी कोर्‌यो। ");
INSERT INTO dhn_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","जोत्यार योहोवा न देख्यो, की लिआ: नी गोंहती होयी, ती हेरी कुख खुल्यु, बाखुन राहेल वान्टी रोही। ");
INSERT INTO dhn_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","अत: लिआ: भारेपाये होये आरु ओको एक पुर्य पोयदा होयो, आरु हेरो यो कोवीन हेरो नाव रुबेन पाड़्यो, “योहोवा न मारा दुख पोर निगांह कोरलु छे, हिमी मारु घोरवावु मार सी मोंग राखसे।” ");
INSERT INTO dhn_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","ओळतेन हुयी भारेपाये होयी आरु ओको एक पुर्य पोयदा होयो; ती हुयी यो कोहि, “यो सोमळीन कि मे मोंगाव्वी नी होय, योहोवा न मेसे यो वी पुर्य आपलो छे।” एकालिय हियी एरो नाव शिमोन पाड़ी। ");
INSERT INTO dhn_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","ओळतेन हुयी भारेपाये होयी आरु ओको एक पुर्य पोयदा होयो; आरु हुयी कोहि, “एने वार ते मारु घोरवावु मेसे जोड़ जासे, काहकी हेनासी मारा तीन पुर्या पोयदा होयला छे।” ओतरान कोरिने एरो नाव लेवी पोड़्यो। ");
INSERT INTO dhn_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","आरु ओळतेन हुयी भारपाये होयी आरु ओको एक आरु पुर्य पोयदा होयो; आरु हुयी कोहि, “एने कावा ते हांव योहोवा क धन्यवाद कोरीस।” एकालीय हुयी हेरो नाव यहुदा पाड़्यु ती हेरी कुख बोन्द होय गोय। ");
INSERT INTO dhn_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","जोत्यार राहेल न देखी की याकुब क लिय मारी सी कुई ओवलियाद नी होयती, ती हुयी आपसी बोहनीस सी घाड़ाय कोरने लागगोय आरु याकुब सी कोहि, “मेसे वी ओवलियाद आप, नी ते मे मोर जाईस।” ");
INSERT INTO dhn_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","ती याकुब राहेल सी रीसवाईन कोयु, “काय मे परमेश्वर छे? तारो कुख ते होयु बोन्द कोरलु छे।” ");
INSERT INTO dhn_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","राहेल कोहि, “वारलो, मारी दासी बिल्हा हाजिर छे; ओका पास मा जा, होयी मारा माण्डा पोर पोयदा कोरसे, आरु ओका लारे मारो वी घोर बोससे।” ");
INSERT INTO dhn_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","ती होयु हेरी आपसी दासी बिल्हा क आपी की होयी हेरी घोरवाळी होये; आरु याकुब हेरेन्चा गोयु। ");
INSERT INTO dhn_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","आरु बिल्हा भारेपाये होयी आरु याकुब सी हेरो एक पुर्य होयो। ");
INSERT INTO dhn_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","ती राहेल कोहि, “परमेश्वर न मारो नियाव चुकाड़्यु आरु मारी सोमळीन मेसे एक पुर्य आप्यु।” ओतरान कोरिन होयी हेरो नाव दान पाड़ी। ");
INSERT INTO dhn_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","राहेल न दासी बिल्हा ओळी भारेपाये होयी आरु याकुब सी एक पुर्य आरु पोयदा होयो। ");
INSERT INTO dhn_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","तव राहेल कयी, “हांव म्हार बोयणी क सात मोटी लड़ाय करली छे।” एने हांव जीत गयी हतरान करीन हेका पोर्यान नाव नप्ताली पाड़ी। ");
INSERT INTO dhn_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","जोत्यार लिआ: न देखी की हांव पोयदा कोरी नी सोको, ती होयी आपसी दासी जिल्पा क लिन याकुब क लाड़ी होयने कोरीन आप देदी। ");
INSERT INTO dhn_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","आरु लिआ: सी दासी जिल्पा क वी याकुब सी एक पुर्य पोयदा होयो। ");
INSERT INTO dhn_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","ती लिआ: न कोहि, “अहो भाग!” ओतरान कोरिन होयी हेरो नाव गाद पाड़ी। ");
INSERT INTO dhn_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","ओळी लिआ: की दासी जिल्पा क याकुब सी एक आरु पुर्य पोयदा होयो। ");
INSERT INTO dhn_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","ती लिआ: न कोहि, “हांव सोयाळी छे; खोरी बायरा मेसे सोयाली कोहसे।” ओतरान कोरिन होयी हेरो नाव आशेर पाड़ी। ");
INSERT INTO dhn_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","गोंहोव काटने क दाहड़ा मा रुबेन क खोयड़ा मा दुदाफळ जोड़्या, आरु होयु तेनाक आपसी आईस लिआ: क पास ली गोयु। ती राहेल न लिआ: सी कोहि, “आपसा पुर्या क दुदाफळ मासी काहीन मेसे आप।” ");
INSERT INTO dhn_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","होयी हेनीक कोहि, तु जी मारा घोरवाळा क ली लेदली छे काय यी नानी वात छे? हिमी काय तु मारा पुर्या क दुदाफळ वी मांगने होय रोय? राहेल कोहि, “वारु, तारा पुर्या क दुदाफळ क बोदले होयु आज रात क तारा साते सुवसे।” ");
INSERT INTO dhn_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","सान्तो जोत्यार याकुब खोयड़ा सी आवतु होतु, ती लिआ: हेनाक मेळने गोय, आरु कोहि, “तुसे मारेन्चात आवनो पोड़से, काहकी हांव मारा पुर्या क दुदाफळ आपीन तुसे छाचीन मुले ली लेदी।” ती होयु तेने रात क ओकाज सात मा सुयो। ");
INSERT INTO dhn_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","ती परमेश्वर न लिआ: क सोमळ्यो, आरु होयी भारेपाये होई आरु याकुब सी हेरो पान्चवो पुर्‌यो हुयो। ");
INSERT INTO dhn_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","ती लिआ: न कोहि, “हांव जी मारा घोरवाळा क मारी दासीक आपी, ओतरान कोरिन परमेश्वर न मेसे मारी दाहड़की आपलो छे।” ओतरान कोरिन होयि हेरो नाव इस्साकार पाड़ी। ");
INSERT INTO dhn_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","लिआ: ओळी भारेपाये होयी आरु याकुब सी ओको छठवो पुर्य पोयदा होयो। ");
INSERT INTO dhn_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","ती लिआ: न कोहि, “परमेश्वर न मेसे वारु दान आपलु छे; एने कावा मारा घोरवावु मारे साते बोनलु रोहसे, काहकी मारा छव पुर्या होय गोयला छे।” ओतरान कोरिन होयी हेरो नाव जबुलुन पाड़ी। ");
INSERT INTO dhn_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","तेरे वाद मा हेरी एक पुराय वी होयी, आरु ओको नाव दीना पाड़ी। ");
INSERT INTO dhn_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","परमेश्वर न राहेल क वी सुधी लेदो, आरु ओकी वी कुख उगाड़ीयो। ");
INSERT INTO dhn_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","ओतरान कोरिन होयी भारेपाये होयी आरु होयी एक पुर्या क जन्म देदी, ती होयी कोहि, “परमेश्वर न मारी नावधोराई क छेटो कोर्यु।” ");
INSERT INTO dhn_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","ओतरान कोरिन होयी यो कोहीन हेरो नाव युसुफ पाड़ी, “परमेश्वर मेसे एक पुर्य आरु आपसे।” ");
INSERT INTO dhn_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","जोत्यार राहेल सी युसुफ पोयदा होयु, ती याकुब न लाबान सी कयो, “मेसे विदा कोर की हांव मारा देश आरु जागा क जाम। ");
INSERT INTO dhn_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","मारी घोरवाळी आरु मारा पुर्या, जिन्दरे वाटू हांव तारु चाखरी कोरलु छे, हेनुक मेसे आप दे कि जार रोहो; तु ते जाने की हांव तारी चाखरी कोरलु छे।” ");
INSERT INTO dhn_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","लाबान न हेना सी कयो, “काहमाईन तारी निगाह मा हांव गीन जोड़लो छे, ती तु यांत रोय जा; काहकी हांव पारख सी जान लेदो की योहोवा न तारे लारे मेसे वि बोरकोत आपलो छे।” ");
INSERT INTO dhn_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","ओळी हुयो कयो, “तु ठिक कोह कि हांव तुसे काय आपो, आरु हांव चो आपीस।” ");
INSERT INTO dhn_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","हुयो हेनासी कयो, “तु जाने कि हांव तारी कोसी चाखरी कोर्यु, आरु तारा ढुरे मारेन्चा कोसा रोया। ");
INSERT INTO dhn_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","मारे आवने सी पेहेल हुये कोतरा होता, आरु हीमी कोतरा होय गोया; आरु योहोवा न मारे आवने सी तुसे बोरकोत आपलु छे। बाखुन हांव मारे घोर क काम कोत्यार कोरीस?” ");
INSERT INTO dhn_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","हुयो औळी कयो, “हांव तुसे काय आपो?” याकुब कयो, “तु मेसे काय मा आपे; काहमाईन तु मारे जुगु एक काम कोरे, ती हांव ओळी तारा गाडरा बुकड़ा क चारीस, आरु हेन्दरी गुवाळी कोरिस। ");
INSERT INTO dhn_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","हांव आज तारा आखा गाडरा बुकड़ा क विन रोहीन निकविस, आरु जर गाडरा ने बुकड़ा चित्तीवाली आरु चितकबरी होय, आरु जे गाडरा काळा होय, आरु जे बुकड़ा चित्तीवाली आरु चितकबरी होय, तेनुक हांव ओलोग राखीस; आरु मारी दाहड़की मा वी ठहरसे। ");
INSERT INTO dhn_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","आरु जोत्यार ओगोळ क मारी दाहड़की क चर्चा तारे ओगोळ चाले, ती धर्म क योत गोवा होरसे; अर्थात बुकड़ा मासी जी काई चित्तीवाली आरु चितकबरी होय, आरु गाडरा मासी जी काई काळी नी होय, काहमाईन मारेन्चा निकोळे ती चुरीन कोवायसे।” ");
INSERT INTO dhn_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","ती लाबान न कयो, “तारे कोहने क ओनसार होये।” ");
INSERT INTO dhn_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","अत: हुयो तेने दाहड़े आखा धारीवाळा आरु चिरकाब्रया बुकड़ा, आरु सब चित्तीवाऴा आरु चितकाब्रया बुकड़ा क, अर्थात जिनामा काहिय उजलापन हुतो, ओको आरु सब काळा गाडरा क वी ओलोग कोरीन आपसा पुर्या क हात मा आप दिदो; ");
INSERT INTO dhn_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","आरु हुयो आपसा आरु याकुब क वीच मा तीन दिन क वाट क जागा कोहायसे; आरु याकुब लाबान क गाडरा बुकड़ा क चारने लाग्यो। ");
INSERT INTO dhn_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","ती याकुब न चिनार, आरु बादाम, आरु अर्मोन झाड़ क निळा निळा झाड़ोक लीन, हेन्दरा छोलटा काई काई छुलीन, तेनुक धारीदार बोनाय देदो, ओसी की हेनुक लाकड़ीयाण क धोळो देखायने लागे। ");
INSERT INTO dhn_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","ती छुल्‌ला लाकड़्या क गाडरा बुकड़ा क ओगोळ हेनुक पानी पिने क नाळी मा (नांद मां) उबो कोर्‌यो; आरु जोत्यार हुये पानी पिने क लिय आवे ती गाभीन होय गोय। ");
INSERT INTO dhn_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","लाकड़िया क ओगोळ गाभीन होईन, गाडरा बुकड़ा धारीवाळा, चित्तीवाळा आरु चितकबरा गिदल्या जोन्या। ");
INSERT INTO dhn_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","ती याकुब न गाडरा क पिला क ओलोग ओलोग कोर्‌यो, आरु लाबान क गाडरा बुकड़ा क मुय क चित्तीवाळा, आरु सब काळा पिला क ओलोग कोर देदो; आरु आपसा टुवा क हेन्दरे सी ओलोग राख्यो, आरु लाबान क गाडरा बुकड़ा सी मीळने नी देदो। ");
INSERT INTO dhn_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","आरु जोत्यार ताकोत वाळा गाडरा बुकड़ा गाभोन होयती होता, तोत्यार याकुब तेनु लाकड़ीया क भारा म हेन्दरे ओगोळ मेक देता हुता; जिनासी तेनु लाकड़िया क देखीन गाभोन होय जाय। ");
INSERT INTO dhn_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","बाखुन नी ताकोत वाळा गाडरा बुकड़ा गाभोन होयता हुता, ती हुये हेन्दरे ओगोळ नि राखतु होतु। इनासी कोमजुर कोमजुर्या लाबान की रोही, आरु ताकोतवाळा ताकोतवाळा याकुब क होय गोया। ");
INSERT INTO dhn_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","ओस कोरीन हुयो मानुस बेस धनावान हपोय गोयु, आरु ओका घोना सोटा गाडरा बुकड़ा, आरु दासीया आरु दासे, आरु उटड़ा आरु गोदड़ा होय गोया। ");
INSERT INTO dhn_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","ओळी लाबान क पुर्या कि यी वाते याकुब क सोमळने मा आवी, “याकुब न आपना बाबा क आखो काहिय हापकी लेदलो छे, आरु आपनु बाबा क धोन क लिय ओकी यी ठाट बाट छे।” ");
INSERT INTO dhn_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","आरु याकुब न लाबान क मुय पोर निगाह कोर्या आरु ताड़ देदा कि हुये ओका जोसा पेहले क जोसा नि छे। ");
INSERT INTO dhn_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","ति योहोवा न याकुब सी कयो, आपसा बाबा क देश आरु तारी पोयदावारीन जागा क जात तोह, आरु हांव तारे साते रोहीस। ");
INSERT INTO dhn_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","ती याकुब राहेल आरु लिआ: क खोयड़ा मा आपसा गाडरा बुकड़ा क धोड़े बुलाविन कयो, ");
INSERT INTO dhn_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","“तुमरा बाबान मुयो सी मेसे ओसो लागे की हुयो मेसे पेहले जोसो हिमी नी देखायतो; बाखुन मारा बाबान परमेश्वर मारे साते छे। ");
INSERT INTO dhn_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","तुमु वी जानु की हांव तुमरा बाबान चाखरी जिव लागाड़ीन कोरलु छे। ");
INSERT INTO dhn_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","ओळी वी तुमरु बाबु मारे सी छल कोरीन मारी दाहड़की क दस वार बोदली देदो; बाखुन परमेश्वर न ओको मारे नुकसान नी कोरने देदो। ");
INSERT INTO dhn_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","जोत्यार हुयो ओसो कोयो, ‘चित्तीवाळा पिला तारी दाहड़की कोहायसे,’ ती आखा गाडरा बुकड़ा‍ चित्तीवाळात होयने लाग्या; आरु जोत्यार होयु कोयु, ‘धारी वाळा पिला तारी दाहड़की कोहायसे’ ति आखा गाडरा बुकड़ धारीवाळा होयने लाग्या। ");
INSERT INTO dhn_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","ओस कोरीन परमेश्वर न तुमरा बाबा क ढुरोक लीन मेसे आपलु छे। ");
INSERT INTO dhn_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","गाडरा बुकड़ा क गाभीन होयने क टेम हांव सोपना मा काय देख्यु कि जे बुकड़ा पोर चोढ़ने बाज रोया, चै धारीवाळा, चित्तीवाळा, आरु घब्बेवाळा छे। ");
INSERT INTO dhn_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","ती परमेश्वर क दुत न सोपना मा मेसे कोयो की, ‘हे याकुब,’ हांव कोयु, काय हुकुम, ");
INSERT INTO dhn_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","हुयो कयो, डुळा उचाकोरीन हेनु आखा बुकड़ा क जे बुकड़ा पोर चोढ़ाई कोर रोया देख, की हुये धारीवाळा, चित्तीवाळा, आरु धब्बावाळा छे; काहकी जे काई लाबान तार सी कोरे, चो हांव देखलु छे। ");
INSERT INTO dhn_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","हांव तेना बेतेल क परमेश्वर छे, जां तु न एक खाम्बा पोर तेल नाख देदलु, आरु मारी मानता मानलु होतु। होमि चाल, एना देश सी निकोळीन आपसी पोयदावारीन जागा क जा।” ");
INSERT INTO dhn_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","ती राहेल आरु लिआ: न हेनासी कोया, “काय आमरु बाबा क घोर मा हिमी वि आमरो काई हिस्सो आरु ओवलियाद वाचलो छे? ");
INSERT INTO dhn_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","काय हामु ओकी निगाह मा पारका नी रोहजे? देख, हुयो ते आमुक ते वेच देदो, आरु आमरु पोयस्या खाय गोयलु छे। ");
INSERT INTO dhn_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","ओतरान कोरिन परमेश्वर न आमरा बाबा क जोत्रा धोन ले लेदलौ छे, हुयो आमरो आरु आमरा पुर्या क छे; हिमी जो काहिय परमेश्वर न तुसेक कवलो छे, चोत कोर।” ");
INSERT INTO dhn_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","ती याकुब न आपसा पुर्या आरु बायरा क उटड़ा पोर चोढ़ायु; ");
INSERT INTO dhn_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","आरु जोतरा ढुरे क हुयो पद्दनराम मा एकठा कोर्‌यो मातभोर होय गयो हुतो, सब क कनान मा आपसा बाबा इसहाक क पास जाने क विचाय सी, साते ली गयो। ");
INSERT INTO dhn_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","लाबान आपसा गाडरा क रुई कतरने क लिय जार रोयो हुतो, आरु राहेल आपसा बाबा क घोरुनदेवता क चुरीन ली गोय। ");
INSERT INTO dhn_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","अत: याकुब लाबान अरामी क पास सी मोनेन जात रोयु, ओको न बताड़ियो कि हांव ढासीन जात रोहीस। ");
INSERT INTO dhn_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","हुयो आपसो आखो काहिई लीन ढास्यु, आरु महानदी क पार उतरीन आपसो मुय गिलाद क बोयड़ा देश भिनी कोर्यु। ");
INSERT INTO dhn_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","तीसरे दाहड़े लाबान क पोतु चाल्यो कि याकुब ढास गोयो। ");
INSERT INTO dhn_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","ओतरान कोरिन हुयो आपसा भाईस क पुठी लिन ओको सात दाहड़ा लोगुन पोछोळ पोड़्यो, आरु गिलाद क बोयड़ा देश मा ओको जाईन धोर्‌यो। ");
INSERT INTO dhn_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","बाखुन परमेश्वर न रात क सोपना मा अरामी लाबान क पास आविन कयो, “चोकचोयु रोव, तु याकुब सी नी ते वारु भुण्डो नी कोहजी।” ");
INSERT INTO dhn_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","आरु लाबान याकुब क पास पुग गोयो। याकुब आपसा तंबु गिलाद नावोन बोयड़ा देश मा उबो कोर्यु होतु; आरु लाबान न वी आपसा भाई क सात आपसा तंबु ओकी बोयड़ा देश मा उबा कोर्या। ");
INSERT INTO dhn_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","ति लाबान याकुब सी कोवने लाग्यो, “तु यो काय कोर्यु कि मारे पास सी मोनेन आत रोयु, आरु मारा पुरायटा क ओसो ली आयो, मानो तोलवार सी बोन्दी बोनाय गोयली होय? ");
INSERT INTO dhn_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","तु काहा मोनेन ढास आयु, आरु मार सी विगुर काई कोहे मारे पास सी मोनेन चाली आयु; नी ते हांव तुसे खुशी क सात टुमेकड़ी (तबली) आरु झुमकु वाजाड़तु, आरु गीते गावता जाईन मुकोलता? ");
INSERT INTO dhn_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","तु ते मेसे मारा पुर्या पुरायटा क गुवु लोगुन नी देदु? तु ते गाण्डाय कोरलु छे। ");
INSERT INTO dhn_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","तुमु मानषो क नुकसान कोरने क शक्ति मारे हातो मा ते छे; बाखुन तुमरु बाबु परमेश्वर न मारे सी वितली रात मा कोयु, ‘चोकचोयु रोव, याकुब सी नी ते वारु कोहजी आरु नी भुण्डो।’ ");
INSERT INTO dhn_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","वारु, हिमी तु आपसा बाबा क घोर क मोटा इच्छा होईन आत रोयु ति आत रोयु, बाखुन मारा देवताक तु काहा चूर लायु?” ");
INSERT INTO dhn_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","याकुब न लाबान क जोपाप आप्यो, “हांव यो विचारीन बिहि गोयलु की काहमाईन तु तारा पुरायटा क मारे सी हापकी नी लेय। ");
INSERT INTO dhn_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","जेरे कुदा जुळ तु मारा देवता जोड़से, जो जिवतलो नी वाचसे। मारे जुळ तारो जो काई निकोळे, चो तु भाई बोन्या क ओगोळ उवखीन ली ले।” काहकी याकुब जनतो नी हुतो कि राहेल घोरुन देवता क चूरीन लावली छे। ");
INSERT INTO dhn_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","यो सोमळीन लाबान, याकुब आरु लिआ: आरु दुयो दासीयो क तंबु मा गयो; आरु काई नी जोड़्यो। ती लिआ: क तंबु मासी निकोळीन राहेल क तंबु मा गोयो। ");
INSERT INTO dhn_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","राहेल ते घोरुन देवता क उटड़ा क काठी मा मेलीन तेनु पोर बोस रोहली। लाबान न ओका आखा तंबु क चावयो ते वी जोड़्यो। ");
INSERT INTO dhn_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","राहेल आपसा बाबा सि कोहि, “हे मारा पोरबु; इना सी खुश नी होय की हांव तारे ओगोळ नि उठी; काहकी हांव मासिक धोरोम सी छे।” अत: तेनाक हेरने सी वी घोरुन देवता नी जोड़या। ");
INSERT INTO dhn_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","ती याकुब रिसवाईन लाबान सी लोड़ायने लाग्यु, आरु कोयु, “मारु काय गुनु छे? हांव काय पाप कोर्यु की तु ओतरु रिसवाइन मार पोछोळ पोड़शयु? ");
INSERT INTO dhn_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","तु जे मारो आखो सोमान चावविन देख्यु, ती तुसेक आपसा घोरोन आखो सोमान मासी काहीन जोड़्यो काय? काई जोड़्यो होय ती ओको याँ आपसा आरु मारा भाईश क ओगोळ मेक दे, आरु चे आपनु दुयो क वीच नियाव कोरे। ");
INSERT INTO dhn_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","एनु वीस साल लोगुन हांव तारेन्चा रोयु; एनामा नी ते तारा गाडरा बुकड़ा क कुख पोड़्यो, आरु न तारा मेढ़ो क मास हांव कोदी नी खादु। ");
INSERT INTO dhn_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","जेनुक बनेले जिवो न फाड़ नाख्यो ओको हांव तारे पास न लावतो होतो, ओकी नुकसानी हांव ही उठावतलु; चाहे दाहड़ा क चुरी जाय चाहे ती राती क, तु मारे सी माँग लेतलु। ");
INSERT INTO dhn_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","मारी ते यी दशा होती कि दिसु क ते तोप आरु राती क सेळो मेसे खाय गयो; आरु निंद मारा डुळ सी ढाक जाती होती। ");
INSERT INTO dhn_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","वीस साल लोगुण हांव तारे घोर मा रोयु; चोवदे साल ते हांव तारी दुय पुराय जुगु; आरु छव साल तारा गाडरा बुकड़ा क चाखरी कोर्यु; आरु तु ते मारी दाहड़की क दोस वार टाय देये। ");
INSERT INTO dhn_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","मारा बाबा क परमेश्वर, अर्थात अब्राहम क परमेश्वर, जेरे बीक इसहाक वी माने, काहमाईन मारे भीनी नी होयतु ती छाचीन तु हिमी मेसे छुछे हात जाने देतु। मारो दुख आरु मारो हातो क मेहनोत क देखीन परमेश्वर न विति रात क तुसे लोड़्यो।” ");
INSERT INTO dhn_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","लाबान न याकुब सी कयो, “यी पुराय ते मारीत छे, आरु ये पुर्या वी मारात छे, आरु ये गाडरा बुकड़ा वी मारात छे, आरु जो काई तुसे देखा पोड़े चो आखो मारोत छे। बाखुन हिमि मारी इनु बेटी, आरु ओकी ओवलियाद सी काय कोर सोको? ");
INSERT INTO dhn_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","हिमि आव, हांव आरु तु दुयु आपसा वायदु कोरजे, आरु हुये मारे आरु तारे वीच मा वायदु कोहायसे।” ");
INSERT INTO dhn_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","ती याकुब न एक दोगड़ो लिन ओको एक खांम्बो उबो कोर्‌यो। ");
INSERT INTO dhn_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","ती याकुब न आपसा भाई बोन्या सी कोयो, “दोगड़ा एकठा कोरु,” यो सोमळीन हुये दोगड़ा एकठा कोरिन एक ढ़ीग लागाड़या, आरु तेनात ढीगो क पास बोसीन खादा। ");
INSERT INTO dhn_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","तेना ढिगोनक नाव लाबान न ते जैगर सहदुथा, बाखुन याकुब न गिलियाद पाड़्यो। ");
INSERT INTO dhn_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","लाबान न कयो, “यो ढीग आज सी मारे आरु तारे वीच गोवा रोहसे,” ओस कोरीन ओको नाव गिलियाद पोड़्यो, ");
INSERT INTO dhn_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","आरु मिजपा वी; काहकी हुयो कयो, “जोत्यार हामु एक दिसरा सी नाम्बे रोहसु ती योहोवा मारी आरु तारी गुळाळी कोरे। ");
INSERT INTO dhn_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","काहिमाईन तु मारा पुरायटा क दुख आपे, निते ओको सिवाय आरु बाई सी इयाव कोरे, ती आमरे हाते कुदु मानुस नी रोहसे; बाखुन देख, मारे तारे वीच मा परमेश्वर गोवा रोहसे।” ");
INSERT INTO dhn_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","ओळी लाबान न याकुब सी कयो, “एना ढीग क देख आरु एना खाम्बा क वि देख, जिनाक हांव आपसे आरु तारे वीच मा उबो कोरलु छे। ");
INSERT INTO dhn_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","यो ढीग आरु यो खाम्बो दुयु एनी वातोन गोवा रोवे कि नुकसान कोरने क विचार सी नी ते हांव एना ढीग क पोल धोड़े तारे पास जाईस, नी ते तु एन ढीग आरु एना खाम्बा क पार कोरीन मारेन्चा आवीस। ");
INSERT INTO dhn_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","अब्राहम आरु नाहोर आरु हेन्दरो बाबा; तिनो क जो परमेश्वर छे, हुयोत आपनु दुयो क वीच नियाव कोरे।” ती याकुब न ओकी आन खादु जेरो बिक हेको बाबो इसहाक मानतो हुतो; ");
INSERT INTO dhn_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","आरु याकुब न हेना बोयड़ा पोर मेलबलि चोढ़ायु, आरु आपसा भाई बोन्या क खाने जुगु बुलायो; ती हुयो खाईन बोयड़ा पोर रात रोया। ");
INSERT INTO dhn_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","वेगोत लाबान उठ्यो, आरु आपसा बेटा बेटी क गुवा दीन आरु बोरकोत आपीन चाल पोड़यु, आरु आपसा जागा पोर आत रोयु। ");
INSERT INTO dhn_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","याकुब न वी आपसी वाट लेदो आरु परमेश्वर क दुत ओको आय मिळ्या। ");
INSERT INTO dhn_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","हेनुक देखतात याकुब कोयो, “यो परमेश्वर क टुळु छे।” ओतरान कोरिन हुयो हेना जागा क नाव महनेम पाड़्यु। ");
INSERT INTO dhn_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","ती याकुब न सेईर देश मा, अर्थात एदोम देश मा, आपसा भाईस एसाव क पास आपसा ओगोळ खोब्र्या मुकोळी देदु, ");
INSERT INTO dhn_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","आरु हुयो हेनुक यो हुकुम आप्यु, “मारा पोरबु एसाव सि यो कोहजु: तारु दास याकुब तुसेक ओसु कोहे के हांव लाबान क याँ सी पारकु होईन हिमि लोगुन रोयु; ");
INSERT INTO dhn_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","आरु मार जुळ गाय बुईल, गोदड़ा, गाडरा बुकड़ा, आरु दास दासीया छे: आरु हांव आपसा पोरबु क पास ओतरान कोरिन खोबोर मुकली रोयु कि तारी निगाह मार पोर रोहे।” ");
INSERT INTO dhn_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","चे दुत याकुब क पास पोछा आवीन कोहने लाग्या, “हामु तारा भाई एसाव क पास गोया होता, आरु हुयो वी तुसेक मिळने कोरीन चार सोव मानुस लिन आवने बाज रोयो।” ");
INSERT INTO dhn_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","ती याकुब बेस बिही गोयु आरु पीड़ा मा पोड़्यु; आरु यो विचारिन आपसा साती क, आरु गाडरा बुकड़ाक, गाय बुईल, आरु उटड़ा क वी ओलोग ओलोग दुय टुळु कोर लेदु, ");
INSERT INTO dhn_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","कि एसाव आवीन पेहला टुळा क मारे ती दीसरु टुळु वाचीन ढास जाईस। ");
INSERT INTO dhn_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","ओळी याकुब न कयो, “हे योहोवा, हे मारा डाहला बाबा अब्राहम क परमेश्वर, हे मारा बाबान इसहाक क परमेश्वर, तु ते मारी सी कोयु होतु कि आपसा देश आपसा पोयदावारीन जागाम जा, आरु हांव तारी भोलो कोरीस: ");
INSERT INTO dhn_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","तु ते जो जो काम आपसी दया आरु छाचाय सी आपसा दास क सात कोरलु छे, की हांव जो आपसी लाकड़ीत लीन एनी योरदोन नोदी क पार उतरी आया, आरु हिमी दुय टुऴा होय गोयाला छे; तारा ओसा ओसा काम मासी हांव एक क वी योग्य ते नी होय। ");
INSERT INTO dhn_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","मारी विनता सोमळीन मेसे मारा भाईस एसाव क हात सी वाचाड़: हांव ते हेना सी बिहयो, काहिय ओसो नि होये कि हुयो आवीन मेसे आरु आया भेळ पुर्या क वी मार देये। ");
INSERT INTO dhn_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","तु ते कोहलु की हांव छाचीन तारो भोलो कोरीस, आरु तारी ओवलियाद क दोरीया क बालु क किनका क जोसो बेसको कोरिस, जे घोनासोटा कि मारे सी नी गिनाये सोके।” ");
INSERT INTO dhn_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","हुयो तेने दाहड़े होयात रात रोयो; आरु जो काई ओका पास होतो ओका मा सी भाईष एसाव क भेंट क लिय नेवाड़ निकाळ्यो; ");
INSERT INTO dhn_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","अर्थात दुय सोव बुकड़ा, आरु वीस बुकड़ा, आरु दुय सोव गाडरा, आरु वीस गाडरा, ");
INSERT INTO dhn_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","आरु पिला भेळ दुत आपने वाळी उटड़ीयाँ, आरु चावीस गाय, आरु दोस बुईल आरु वीस गोदड़ा आरु ओका दोस पिला। ");
INSERT INTO dhn_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","इनुक हुयो टुवान टुवा कोरीन, आपसा दासो क सोपीन हुयो कयो, “मारे ओगोळ होयु; आरु टुळा क वीच वीच मा गाळु राखु।” ");
INSERT INTO dhn_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","ओळतेन हुयो ओगला टुळा क गुळाव्या क हुकुम आप्यो, “जोत्यार मारु भाईष एसाव तुसे मेळे, आरु पुछे, ‘तु कुनीन दास छे, आरु काँ सी आवे, आरु ये तारे ओगोळ ओगोळ छे, ये कुनीन छे?’ ");
INSERT INTO dhn_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","ती कोहजी, यो तारा दास याकुब क छे। हे मारा पोरबु एसाव, यो भेंट क लिय तारे पास मुकेल्लु छे, आरु हुयो आपसो वी आमरे पोछोळ पोछोळ आवे बाज रोयु।” ");
INSERT INTO dhn_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","आरु हुयो दिसरा आरु राखवाळया क वी, बाखुन तेनु आखा क जे टुवा क पोछोळ पोछोळ हुतो ओसोत हुकुम आप्यो के जोत्यार एसाव तुमुक मिळे ती ओसा कोहजु। ");
INSERT INTO dhn_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","आरु कोहजु, “तरो दास याकुब आमरे पोछोळ पोछोळ आवने बाज रोयु।” काहकी हुयो यो विचार्‌यो की भेंट जि मारे ओगोळ ओगोळ जाय, ओका लारे हांव हेरो रीस कोम कोरो ती ओको दर्शन कोरीस; होय सोके हुयो मार सी वारु नी होय। ");
INSERT INTO dhn_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","ओतरान कोरिन हुयो भेंट याकुब सी पेहेल पार उतरी गोया, आरु हुयो आपसुत् राती छावनी मा रोयो। ");
INSERT INTO dhn_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","तेने राती हुयो उठ्यो आरु आपसी दुयु घोरवाळी, आरु दुयु दासी आरु ग्यारे पुर्या क पुठी लीन घाट सी यब्बोक नोदी क पार उतरी गोयो। ");
INSERT INTO dhn_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","हुयो हेनुक नोदी क पार उतार देदो, बाखुन आपसो आखो काई पार उतार देदो। ");
INSERT INTO dhn_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","आरु याकुब आपसो एखलो रोय गोयो; तु कोय मानुस आवीन पौ फाटने लोगुन हेनासी मल्लयुद्ध कोरतु रोयु। ");
INSERT INTO dhn_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","जोत्यार हुयो देख्यो दी हांव याकुब पोर वातड़ु नि होय, तु होयु हेरी सारवा क नस क छीम्यु; आरु याकुब क सातवा क नस मल्लयुद्ध कोरतात चोढ़ गोय। ");
INSERT INTO dhn_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","ती होयु कोयु, “मेसे जाने दे, काहकी सोन्दारो होयने वाळो छे,” याकुब कोयु, “जोत्यार लोगुन तु मेसे बोरकोत नी आपे, तु लोगुन हांव तुसे नी जाने दोम।” ");
INSERT INTO dhn_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","आरु हुयो याकुब सी हेरो नाव पुछ्यो, “तारो नाव काय छे?” हुयो कयो, “याकुब।” ");
INSERT INTO dhn_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","हुयो कयो, तारो नाव हिमी याकुब नी, बाखुन, इसराएल होयसे, काहकी तु परमेश्वर सी आरु मानषो सी वी लोड़ाय कोरने मा जितलु छे (उत्पत्ति 35:10) ");
INSERT INTO dhn_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","याकुब न कयो, “हांव विनता कोरो, मेसे आपसो नाव देखाड़।” हुयो कयो, “तु मारो नाव काहा पुछे?” ती हुयो हेनाक हुयोत बोरकोत आप्यो। ");
INSERT INTO dhn_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","ती याकुब न यो कोवीन हेना जागा क नाव पनीएल पाड़्यो; “परमेश्वर क आंम्बा साम्बा देखने सी वी जिवतलु रोय गोयु।” ");
INSERT INTO dhn_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","पनीएल क पास चालता चालता दाहड़ु उग गोयु, आरु हुयो सातवा सी भागड़ु होय गोयु। ");
INSERT INTO dhn_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","इसराएली जे ढुरो क सातवा क जुड़ोवाळा जंघानस क आजुन दाहड़े लोगुन नी खाता, ओतरान कोरिन योत कि हेयो याकुब क सातवा क जुड़ मा जंघानस क छिम्यो। ");
INSERT INTO dhn_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","याकुब न डुळा उचा कोरीन देख्यो कि एसाव चार सोव मानषो पुठी लीन आवे। ती हुयो पुर्या क ओलोग ओलोग वाटिन लिआ: आरु राहेल आरु दुयु दासी क आप देदो। ");
INSERT INTO dhn_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","आरु हुयो आखान ओगोळ पुर्या भेळ दासीयो क, ओका पोछोळ पुर्या भेळ लिआ: क आरु आखा क पोछोळ राहेल आरु युसुफ क मेल्यो, ");
INSERT INTO dhn_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","आरु आपसु हेनु आखा क ओगोळ गोयु आरु सातु वार भिमा पोड़ीन वान्द्यु, आरु आपसा भाईष क पास पुग्यो। ");
INSERT INTO dhn_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","ती एसाव हेनाक मेळने कोरीन दोवड़्यो, आरु ओको हृदय सी लागाड़ीन, गोळा सी थाबाईन गुवा देदो; ओळी हुये दुयु रोड़ने लाग्या। ");
INSERT INTO dhn_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","ती हुयो डुळा उचाकोरीन बायरा आरु पुर्या क देख्यो, आरु पुछ्‌यो, “ये जे तारे साते छे ये कुन छे?” हुयो कोयो, “ये दास क पुर्या छे, जे परमेश्वर न गिन कोरीन आपलो छे।” ");
INSERT INTO dhn_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","ति पुर्या भेळ दासीयो न धड़ आवीन वान्द्यो; ");
INSERT INTO dhn_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","ओळी पुर्या भेळ लिआ: धोड़े आवी आरु हुये वी वान्द्या; आखरी मा युसुफ आरु राहेल वी धोड़े आवीन वान्द्या। ");
INSERT INTO dhn_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","ती हुयो पुछ्यो, “तारु यु मोटलु टुळु मेसे जोड़्यु, काय वात छे?” हुयो कयो, “यि की मारा पोरबुन गिन मार पोर होयी।” ");
INSERT INTO dhn_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","एसाव न कयो, “हे मारा भाईष, मारे जुळ ते बेस छे; जो काई तारो छे चोत तारो रोहे।” ");
INSERT INTO dhn_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","याकुब न कयो, “नि नि, काहमाईन तारी गिन मार होय, ती मारी भेंट ली ले; काहकी मे ते तुसे मेळीन, जोसो परमेश्वर सी मेळ लेदु, आरु तु मार सी वारु होय गोयु। ");
INSERT INTO dhn_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","ओतरान कोरिन यी भेंट जी तुसेक मुकेल्ली छे, ली ले; काहकी परमेश्वर न मार पोर गिन कोरलु छे, आरु मारे जुळ बेस छे।” जोत्यार होयो हेनासी बेसकु विनता कोर्यु, ती हुयो भेट क ली लेदो। ");
INSERT INTO dhn_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","ओळतेन एसाव न कयो, “आव, हिमी ओगा चालता; आरु हांव तारे ओगोळ चालीस।” ");
INSERT INTO dhn_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","याकुब न कयो, “हे मारा पोरबु, तु जाने की मारे साते पुर्या, आरु दुध आपन्या गाडरा बुकड़ा आरु गाय छे; एने ओसो ढुरे एक दाहड़ु वी वोदु पिसला होय जाय, ती आखा की आखा मोर जासे। ");
INSERT INTO dhn_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","ओतरान कोरिन मारो पोरबु आपसा दास क ओगोळ चाल, आरु हांव इनु ढुरो क चाल क ओनसारे जे मारे ओगोळ छे, आरु पिल क चाल क ओनसारे धीरा धीरा चालीन सेईर मा आपसा पोरबु क पास पुग जाईस।” ");
INSERT INTO dhn_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","एसाव कोयो, “तु आपसा साती मासी हांव कुदा एक तारे साते मेल जाम।” हुयो कयो, ओसो काहा? ओतरोत बेस की मारु पोरबु क गीन की निगाह मार पोर बोनली रोहे।\" ");
INSERT INTO dhn_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","ती एसाव न तेने दाहड़े सेईर जाने क आपसी वाट लेदो। ");
INSERT INTO dhn_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","बाखुन याकुब होंसा सी निकोळीन कर सुक्कोत क गोयो, आरु होंया आपसे जुगु एक घोर, आरु ढुरो क लिय खोपड़ो बोनायो। ओतरान कोरिन हेना जागा क नाव सुक्कोत पोड़्यो। ");
INSERT INTO dhn_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","याकुब जो पद्दनराम सी आयो हुतो, हुयो कनान देश क शकेम नगर क पास आरगु पुगीन नगर क ओगोळ डेरु उबु कोर्यु। ");
INSERT INTO dhn_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","आरु कोळी क जिना खोण्डो पोर हुओ आपसी तंबु उबु कोर्यु, ओको हुयो शकेम क बाबा हमोर क पुर्या क हात सी एक सोव कसीतों मा मुले लेदु। ");
INSERT INTO dhn_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","होंया हुयो एक वेदी बोनवीन ओको नाव एल एलोहे इस्राएल पाड़्यु। ");
INSERT INTO dhn_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","एक दाहड़ु लिआ:न पुराय दीना, जी याकुब सी पोयदा होयी होती, तेना देश क पुरायटा सी मेळने कोरीन निकोळी। ");
INSERT INTO dhn_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","ती हेना देश क डाहलो हिव्वी हमोर क पुर्य शकेम न ओको देख्यो, आरु ओको ली जाईन ओका सात कुकर्म कोरीन भ्रष्ट कोर नाख्यु। ");
INSERT INTO dhn_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","ती ओको मन याकुब क बेटी दीना सी लाग गोयो, आरु हुयो हेनी पुराय सी मोंगोन वार कोर्यु, आरु हेरे सी मोंग कोरने लाग्यु। ");
INSERT INTO dhn_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","अत: शकेम न आपसा बाबा हमोर सी कयो, “मेसे इनी पुराय क मारु घोरवाळी होयने क लिय आपड़ दे।” ");
INSERT INTO dhn_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","आरु याकुब न सोमळ्यो कि शकेम न मारी पुराय दीना क विटळी देदु; बाखुन हेरा पुर्या तेने टेमे ढुरो क सात खोयड़ा मा हुता, ओतरान कोरिन हुयो हेनुक आवता लोगुन हुगु रोयु। ");
INSERT INTO dhn_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","ती‍ शकेम क बाबो हमोर निकोळीन याकुब सी वात कोरने क लिय ओका पास आयो। ");
INSERT INTO dhn_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","याकुब क पुर्या यो सोमळीन खोयड़ा सी बेस उदास आरु रिसवाईन आया; काहकी शकेम न याकुब क पुराय क सात कुकर्म कोरीन इस्राएल क घोराना सी विनोकल्या क जोसो काम कोर्‌यो हुतो, जो कोरनो वारु नी होतो। ");
INSERT INTO dhn_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","हमोर न हेनु आखासी कयो, “मारु पुर्यु शकेम क मोन तुमरी पुराय पोर बेस लागलो छे, ओतरान कोरिन हेनीक एरी घोरवाळी होयने कोरीन आप देवु। ");
INSERT INTO dhn_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","आरु आमरे साते इयाव कोरु; तुमरा पुरायटा क आमुक आप्या कोरु, आरु आमरा पुरायटा तुमु लि जाया कोरु। ");
INSERT INTO dhn_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","आमरे पुठी बोसला रोहु; आरु यो देश तुमरे ओगोळ पोड़लो छे, इना मा रोहीन लेन देन कोरु, आरु इनी जागा क आपसे वाटू ली लेवु।” ");
INSERT INTO dhn_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","शकेम न वी दीना क बाबा आरु भाष्यो सी कयो, काहमाईन मार पोर तुमु मानषो क गीनोन निगाह होय, ती जो काई मार सी कोहु, चो हांव आपीस। ");
INSERT INTO dhn_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","तुमु मार सी कोतरो वी दाम आरु बोदलु काहा नी मांगु, ते वी हांव तुमरे कोहे ओनसारे आपीस; बाखुन हेनी पुराय क घोरवाळी होयने कोरीन मेसे आपु। ");
INSERT INTO dhn_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","ती यो विचारु कि शकेम न आमरी बोहनीस दीना क विटळो छे, याकुब क पुर्या न शकेम आरु ओका बाबा हमोर क छल क सात यो जोपाप आप्या, ");
INSERT INTO dhn_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","“हामु ओसो काम नी कोर सोकतला कि कुदु खतनाविगुर मानुसक आमरी बोहनीस आपजे, काहकी इनासी आमरी नावबोद्दी होयसे। ");
INSERT INTO dhn_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","इनी वात पोर ते हामु तुमरी पुराय मान लेसु क आमरे जोसा तुमरे सि होर एक मानुसक खोतनो कोर्‌यो जाए। ");
INSERT INTO dhn_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","ती हामु आमरी पुराय तुमरे सी इयाव कोरसु, आरु तुमरा पुरायटा सी इयाव, आरु तुमरे पुठी बोस्या वी कोरसु, आरु हामु दुयो एकुत टुळान क मानुस होय जासु। ");
INSERT INTO dhn_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","बाखुन काहमाइन आमरी वात नी माने आपसो खोतनो नी कोरावी, ती हामु आमरी पुराय क लिन याम सि जात रोहसु।” ");
INSERT INTO dhn_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","हेन्दरी इनी वात पोर हमोर आरु ओको पुर्य शकेम खुश होया। ");
INSERT INTO dhn_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","आरु हुये जुवान्या जे याकुब क पुराय क बेस चाहता हुता, इना काम क कोरने मा हुये तवार नी कोर्या। हुये आपसा बाबा क आखा घोराना मा बेस प्रतिष्‍ठित हुता। ");
INSERT INTO dhn_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","ओतरान कोरिन हमोर आरु ओका पुर्य शकेम आपसा नगर क झोपला क धोड़े जाईन नगरवाळा क यो सोमझाड़ने लाग्यो, ");
INSERT INTO dhn_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“चे मानुस आपने साते मिळीन रोहने चाहता छे, अत: हुये इना देश मा रोहीन लेनदेन कोरने देवु: देखु, यो देश हेन्दरे जुगु बेस‌ छे; ओळी हामु मानुस हेन्दरा पुरायटा सी इयाव लेजे, आरु आपना पुरायटा क हेनुक आप देजे। ");
INSERT INTO dhn_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","चे मानुस केवल इनी वात पोर आपने सारे रोहसे आरु एकुत समुदाय क मानुस होयने क खुस छे की ओका जोसा आपना आखा मानषो क खोतनो कोर्‌यो जाय। ");
INSERT INTO dhn_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","काय हेन्दरा गाडरा बुकड़ा, आरु गाय बुईल बाखुन हेन्दरो आखा ढुरे आरु धोन जायदाद आपनी नी होय जासे? ओतरोत कि हामु मानुस हेन्दी वात मान ले, ती हुये आमरे साते रोहसे।” ");
INSERT INTO dhn_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","ओतरान कोरिन जोतरा हेना नगर क झोपला सी निकोळता हुता, हेनी आखा न हमोर क आरु ओका पुर्य शकेम क वात माने; आरु होर एक मानुस खोतनो कोरावे, जोतरा हेना नगर क झोपला सी निकोळता हुता। ");
INSERT INTO dhn_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","तीसरे दाहड़े, जोतयार हुये मानुस मान्दा पोड़ गोया, ती ओसो होयो कि शिमोन आरु लेवी नावोन याकुब क दुय पुर्या न, जे दीनान क भाई हुता, आपसी आपसी तोलवार लीन नगर मा विगुर बिहये भोराईन आखा मानषो क मार देदा। ");
INSERT INTO dhn_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","हमोर आरु ओका पुर्या शकेम क हुये तलवार सी मार देदा, आरु दीना क शकेम क घर सी निकाळ ली गया। ");
INSERT INTO dhn_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","याकुब क पुर्या क मारने पोर वी नगर क ओतरान कोरिन लुट लेदा की हेना मा हेन्दरी बोहनीस विटळी गोय होती। ");
INSERT INTO dhn_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","हुये गाडरा बुकड़ा, आरु गाय बुईल, आरु गोदड़ा, आरु नगर आरु खोयड़ा मा जोतरो धोन हुतो लिजात रोया। ");
INSERT INTO dhn_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","हेनु आखाक, आरु हेन्दरा बाळ पुर्या, आरु बायरा क वी ली गोया, बाखुन घोर घोर मा जो काई हुतो चो वी लुट लेदा। ");
INSERT INTO dhn_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","ती याकुब न शमोन आरु लेवी सी कयो, “तुमु जो एना देश क मानषो कनानियो आरु परिज्जियो क मन मा मारे जुगु घाड़ाय पोयदा कोर्या, इना सी तुमु मेसे पिड़ा मा नाख देदला‌ छे, काहकी मारे साते ते थुड़ा मानुस छे; ओतरान कोरिन हिमि हुये एकठा होईन मार पोर चोहड़से, आरु मेसे मार देसे, ती हांव आपसा घोराना भेळ खोतोम हय जाईस।” ");
INSERT INTO dhn_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","हुये कोया, “काय हुयी आमरी बोहनीस क सारे वेश्या क जोसा व्यवहार कोरे?” ");
INSERT INTO dhn_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","ती परमेश्वर न याकुब सी कयो, “या सी निकोळीन बेतेल क जा, आरु होयात रोव; आरु हुँया परमेश्वर क लिय वेदी बोनाव, जु तुखे दर्शन आप्यो, जोत्यार तु आपसा भाईस एसाव क बिक सी ढासतो हुयो।” ");
INSERT INTO dhn_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","ती याकुब न आपसा घोराना सी, आरु हुये बी जे हेरे पुठी हुता, कोया, “तुमरे विच मा जु पारकु देवता छे, हेना निकाल नाखु; आरु आपसा-आपसा क चुखा कोरु, आरु आपसा छिंदरा बोदली लेवु; ");
INSERT INTO dhn_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","आरु आवु, आपनु याँ सी निकोळीन बेतेल क जाजे; होंया हांव परमेश्वर क लिय एक वेदी बोनाविस, जु वेला क दाहड़ा मा मारी सोमवलु, आरु जेने वाट्ये सि हांव चालतु होतु, तेरेमा मारे साते रोयु।” ");
INSERT INTO dhn_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","ओतरान कोरिन जोतरा पारका देवता हेंदरे जुळ होता; आरु कुण्डल हेन्दरा कान्टा मा होता, हेनु सब क हुये याकुब क आप्या; आरु हुयो हेनु तेरो बांज झाड़ क नेचो, जो शेकेम क पास मा छे, गाड़ देदा। ");
INSERT INTO dhn_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","ती हुये कुच कोर्या; आरु हेन्दरे‍ च्यारु मेर क नगर मा रोहन्या क मन मा परमेश्वर क भीनी दी ओसो बिक सोमाय गोयो, कि हुये याकुब क पुर्या क पोछोळ नी पोड़्या। ");
INSERT INTO dhn_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","याकुब हेनु आखा भेळ, जो हेरे पुठी हुता, कनान देश क लुज नगर क आया। चो नगर बेतेल वी कोवाये। ");
INSERT INTO dhn_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","होंया हुयो एक वेदी बोनायो, आरु हेना जागा क नाव एल बेतेल पाड़्यो; काहकी जोत्यार हुयो आपसा भाईस क बिक सी ढास जातलु ती परमेश्वर हेर पोर प्रगट होयलु। ");
INSERT INTO dhn_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","आरु रिबका क दुध पाळनेवाळी दाई दबोरा मोर गोय, आरु बेतेल क बांज झाड़ क नेचो हेनीक गाड़ देदा, आरु हेना बांज झाड़ क नाव अल्लोनबक्कुत पाड़्या। ");
INSERT INTO dhn_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","ओळतेन याकुब क पद्दनराम सी आवने क वाद परमेश्वर न दुसरी वार ओको दर्शन आपीन बोरकोत आप्यो। ");
INSERT INTO dhn_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","आरु परमेश्वर न हेनासी कोयो, हिमी लोगुन ते तेरो नाव याकुब रोहलो छे; बाखुन ओगो क तेरो नाव याकुब नी रोहसे, तु इस्राएल कोवाईस। ओस कोरीन हुयो हेरो नाव इस्राएल पाड़्या। ");
INSERT INTO dhn_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","ओळतेन परमेश्वर न हेना सी कोयो, “हांव सर्वशक्तिमान परमेश्वर छे। तु फुले फले आरु वोदे; आरु तार सी एक जाति बाखुन जातिन एक माण्डळी वी पोयदा होयसे, आरु तारी ओवलियाद मा राजा पोयदा होयसे। ");
INSERT INTO dhn_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","आरु जु देश हांव अब्राहम आरु इसाहक क आपलो छे, चो देश तुसेक आपो, आरु तारे पोछोल तारी ओवलियाद क वी आपीस।” ");
INSERT INTO dhn_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","ती परमेश्वर हेना जागा मा, जा हुयो याकुब सी वात कोर्‌यो, ओका पास सी उपोर चोढ़ गोयो। ");
INSERT INTO dhn_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","आरु जेना जागा मा परमेश्वर न याकुब सी वात कोर्‌यो, चाँ याकुब न दोगड़ा क एक खाम्बो उबो कोर्‌यो, आरु हेर पोर अर्घ तेल नाख देदो। ");
INSERT INTO dhn_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","जाँ परमेश्वर न याकुब सी वात कोर्‌यो, हेना जागा क नाव हुयो बेतेल पाड़्यो। ");
INSERT INTO dhn_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","ओळतेन हुये बेतेल दी कुच कोर्या; आरु एप्रात थुड़ेत नांबे रोय गोया हुता कि राहेल क पुर्य क जनने क घोनी पीड़ा लागी। ");
INSERT INTO dhn_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","जोत्यार हेनीक मोटी मोटी पीड़ा होयतली ती दाई न हेरेसी कोहि, “मा बिहये; हेमी वी तारु पुर्युत होयसे।” ");
INSERT INTO dhn_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","ती ओसो होयो कि हुयी मोर गोय, आरु जिव निकोळता निकोळतात् हुये हेना पुर्या क नाव बेनोनी पाड़्या; बाखुन हेरा बाबा न हेरे नाव बिन्यामीन पाड्या। ");
INSERT INTO dhn_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","यो राहेल मोर गोय, आरु एप्रात, यानी बैतलहम क वाट मा, ओको गाड़ देदा। ");
INSERT INTO dhn_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","आरु याकुब न ओको कबर पोर एक खाम्बो उबो कोर्‌यो: राहेल क बिड़ा क हुयो खाम्बो आज लोगुन बोनलो छे। ");
INSERT INTO dhn_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","ओळतेन इस्राएल न कुच कोर्‌यो, आरु एदेर नावोन गुम्मट क ओगा बोड़ीन आपसो तंबु उबो कोर्‌यो। ");
INSERT INTO dhn_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","जोत्यार इस्राएल हेना देश मा वोसलु होतु, ती एक दाहड़े ओसो हुयो की रुबेन न जाईन आपसा बाबा की रखेल बिल्हा क सात कुकर्म कोर्‌यो; आरु यी वात इस्राएल क मालुम होय गोय। याकुब क बारे पुर्या होया। ");
INSERT INTO dhn_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","हेनामासी लिआ क पुर्या ये हुता; यानी याकुब क जेठा, रुबेन, ओळतेन शिमोन, लेवी, यहुदा, इस्साकार, आरु जबुलुन। ");
INSERT INTO dhn_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","आरु राहेल क पुर्या ये हुता; यानि युसुफ, आरु बिन्यामीन। ");
INSERT INTO dhn_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","आरु राहेल क दासी बिल्हा क पुर्या ये हुता; यानी दान, आरु नप्ताली। ");
INSERT INTO dhn_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","आरु लिआ क दासी जिल्पा क पुर्या ये हुता; यानी गाद, आरु आशेर। याकुब क येत पुर्या होया, जे हेनासी पद्दनराम मा पोयदा होया। ");
INSERT INTO dhn_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","आरु याकुब मम्रे मा, जे किरयतरबा, यानी हेब्रोन छे, जाँ अब्राहम आरु इसहाक पारकु होईन रोहलु होतु, आपसा बाबा क पास आयो। (इब्रा 11:9) ");
INSERT INTO dhn_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","इसहाक क उमोर एक सोव चार विस क होय गोयो। ");
INSERT INTO dhn_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","आरु इसहाक क जिव छुट गोयो, आरु हुयो मोर गोयो, आरु हुयो डावो आरु पुरी उमोर क होईन आपसा मानसो मा जाय मेळ्यु; आरु ओका पुर्या एसाव आरु याकुब न ओको धुळु आप्या। ");
INSERT INTO dhn_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","एसाव जु एदोम वी कोवाये ओकी यि ओवलियाद छे। ");
INSERT INTO dhn_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","एसाव न ते कनानी पुराय सी इयाव कोर्यु; यानी हित्ती एलोन क पुराय आदा क, आरु ओहोलीबामा क जी अना की पुराय, आरु हिव्वी सिबोन क नातिन होती। ");
INSERT INTO dhn_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ओळतेन हुयो इश्माएल क पुराय बाशमत क वी, जी नबायोत क बोहनीस हुती, इयाव कोर्‌यो। ");
INSERT INTO dhn_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","आदा न ते एसाव क द्‍वारा एलीपज क, आरु बासमत न रुएल क जोन्म देदी। ");
INSERT INTO dhn_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","आरु ओहोलीबामा न युश, आरु यालाम, आरु कोरह क पयदा कोर्‌यो, एसाव क येत पुर्या कनान देश मा पोयदा होयला। ");
INSERT INTO dhn_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","एसाव आपसी घोरवाळी, आरु पुर्या पुरायटा, आरु घर क आखा जीवो, आरु आपसा गाडरा बुकड़ा, आरु गाय बुईल आदि आखा ढुरो, निदान आपसी आखी जायदाद क, जे हेना कनान देश मा एकठो कोरला हुता, लीन आपसा भाई याकुब क पास सी दिसरा देश क चाली गोयो। ");
INSERT INTO dhn_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","काहकी हेन्दरी जायदाद ओतरी होय गोयली, कि हुये एकठा नी रोय सोक्या; आरु ढुरो क घोना सोटा होयने क कारण हेना देश मा, जाँ हुये पारका होईन रोहता हुता, हुये सोमाय नी सोक्या। ");
INSERT INTO dhn_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","एसाव जु एदोम वी कोवाये, सेईर नावोन बोयड़ा देश मा रोहने लाग्या। ");
INSERT INTO dhn_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","सेईर नावोन बोयड़ा देश मा रोहनेवाळा एदोमियो क मुल मानुस एसाव क ओवलियाद यी छे ");
INSERT INTO dhn_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","एसाव क पुर्या क नाव ये छे; यानी एसाव क घोरवाळी आदा क पुर्य एलीपज, आरु हेरीत एसाव क घोरवाळी बासमत क पुर्य रुएल। ");
INSERT INTO dhn_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","आरु एलीपज क ये पुर्य हुया; यानी तेमान, ओमार, सपो, गाताम, आरु कनज। ");
INSERT INTO dhn_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","एसाव क पुर्य एलीपज क तिम्ना एक रखेल होती, जिनासी एलीपज क द्वारा अमालेक क जन्म देदी; एसाव क घोरवाळी आदा क ओवलियाद मा येत हुया। ");
INSERT INTO dhn_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","रुएल क ये पुर्या हुया; यानी नहत, जेरह, शम्मा, आरु मिज्जा एसाव क घोरवाळी बासमत क ओवलियाद मा येत छे। ");
INSERT INTO dhn_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","ओहोलीबामा जी एसाव क घोरवाळी, आरु सिबोन क नातिन आरु अना क पुराय हुती, ओका ये पुर्या हुया: यानी हुयो एसाव क द्वारा युश यालाम आरु कोरह क जन्म देदी। ");
INSERT INTO dhn_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","एसाव ओवलियाद क अधिपति ये हुया: यानी एसाव क मोटलो एलीपज क ओवलियाद मा सी ते तेमान अधिपती, ओमार अधिपति, सपो अधिपति, कनज अधिपति, ");
INSERT INTO dhn_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","कोरह अधिपति, गाताम अधिपति, अमालेक अधिपति एलीपज ओवलियाद मा सी एदोम देश मा येत अधिपति हुया: आरु येत आदा क ओवलियाद मा हुया। ");
INSERT INTO dhn_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","एसाव क पुर्य रुएल क ओवलियाद मा येत हुया; यानी नहत अधिपति, जेरह अधिपति, शम्मा अधिपति, मिज्जा अधिपति रुएल ओवलियाद मा सी, एदोम देश मा येत अधिपति होया; आरु येत एसाव क घोरवाळी बासमत क ओवलियाद मा होया। ");
INSERT INTO dhn_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","एसाव क घोरवाळी ओहोलीबामा क ओवलियाद मा येत हुया; यानी युश अधिपति, यालाम अधिपति, कोरह अधिपति, अना क पुराय ओहोलीबामा जी एसाव क घोरवाळी हुती ओकी ओवलियाद मा येत हुया। ");
INSERT INTO dhn_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","एसाव जु एदोम वी कोहाये, ओका ओवलियाद येत छे, आरु हेन्दरा अधिपति वी येत हुया। ");
INSERT INTO dhn_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","सेईर ज होरी नावोन जाती क हुतो, ओको यो पुर्य हेना देश मा पेहले सी रोहता हुता; यानी लोतान, शोबाल, सिबोन, अना, ");
INSERT INTO dhn_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","दीशोन, एसेर, आरु दीशान: एदोम देश मा सेईर क येत होरी जातीवाळा अधिपति हुया। ");
INSERT INTO dhn_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","लोतानन पुर्यो, होरी आरु हेमाम होया; आरु लोतानोन बोहनीस तिम्ना होती। ");
INSERT INTO dhn_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","शोबाल क ये पुर्या हुया: यानी आल्वा, मानहत, एबाल, शपो, आरु ओनाम। ");
INSERT INTO dhn_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","आरु सीदोन क ये पुया हुया: अय्या, आरु अना; ये चेत अना छे जेको जोंगोल मा आपसा बाबा सिबोन क गदड़ा क चारता चारता तातला पानी क झोरना मा मेवलो। ");
INSERT INTO dhn_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","आरु अना क दीशोन नावोन पुर्या हुया, आरु हेना अना क ओहोलीबामा नावोन पुराय होयी। ");
INSERT INTO dhn_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","दीशोन क ये पुर्या हुया: हेमदान, एशबान, यित्रान, आरु करान। ");
INSERT INTO dhn_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","एसेर क ये पुर्या हुया: बिल्हान, जावान, आरु अकान। ");
INSERT INTO dhn_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","दीशान क ये पुर्या हुया: ऊस, आरु अरान। ");
INSERT INTO dhn_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","होरीयो क अधिपति, ये हुया: लोतान अधिपति, शोबाल अधिपति, सिबोन अधिपति, अना अधिपति, ");
INSERT INTO dhn_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","दीशोन अधिपति, एसेर अधिपति, दीशान अधिपति, सेईर देश मा होरी जातिवाळा येत अधिपति हुया। ");
INSERT INTO dhn_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","ओळतेन जोत्यार इसराएली पोर कोय राजा न राजा न कोर्या हुता, ती वी एदोम क देश मा ये राजा हुया ");
INSERT INTO dhn_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","बोर क पुर्या बेला न एदोम मा राज कोर्या, आरु ओकी देश क नाव दिन्हाबा छे। ");
INSERT INTO dhn_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","बेला क मोरने पोर, बोसरानिवासी जेरह क पुर्या योबाब ओका जागा पोर राजा हुयो। ");
INSERT INTO dhn_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","योबाब क मोरने पोर, तेमानिया क देश क रोहन्या हुशाम हेना जागा पोर राजा होयु। ");
INSERT INTO dhn_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","ओळतेन हुशाम क मोरने पोर, बदद क पुर्या हदद हेना जागा पोर राजा हुया यो चोत छे जेना मिद्यानियो क मोआब क देश मा मार लेदो, आरु ओकी राजधानी क नाव अबीत छे। ");
INSERT INTO dhn_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","हदद क मोरने पोर, मस्रेकावासी सम्ला हेना जागा पोर राजा हुयु। ");
INSERT INTO dhn_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","ओळतेन सम्ला क मोरने पोर, शाऊल जु महानद क तटवाळा रहोबोत नगर क हुतो, हेना जागा पोर राजा हुयो। ");
INSERT INTO dhn_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","शाऊल क मोरने पोर, अकबोर क पुर्य बाल्हानान हेना जाग पोर राजा हुयु। ");
INSERT INTO dhn_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","अकबोर क पुर्य बाल्हानान क मोरने पोर, हदर हेना जागा पोर राजा हुयु आरु हेनी राजधानी क नाव पाऊ छे; आरु ओकी घोरवाळी क नाव महेतबेल छे, जु मेजाहाब क नातीन आरु मत्रेद क पुराय हुती। ");
INSERT INTO dhn_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","ओळतेन एसाव ओवलियाद क अधिपतियो क कुलों, आरु जागा क ओनसारे ओको नाव यो छे तिम्ना अधिपति, अल्वा अधिपति, यतेत अधिपति, ");
INSERT INTO dhn_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ओहोलीबामा अधिपति, एला अधिपति, पीनोन अधिपति, ");
INSERT INTO dhn_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","कनज अधिपति, तेमान अधिपति, मिबसार अधिपति, ");
INSERT INTO dhn_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","मग्दीएल अधिपति, ईराम अधिपति एदोम ओवलियादियो न जु देश आपसु कोर लेदु होतु, ओको निवास जाग मा हेन्दरा येत अधिपति हुया; आरु एदोमी जाती क डाहलु मानुस एसाव छे। ");
INSERT INTO dhn_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","याकुब ते कनान देश मा रयतो हतो, जां सारीक ओको बाप बाहर देश वाळो बनीन रवतो हतो। ");
INSERT INTO dhn_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","आरु याकुब न ओवलियादन पुरावु यो छे: युसुफ सोतरा सालन होईन ओका भाई न साथ मा गाडरा बोकरा चरावतो हुतो आरु त्यो पोर्‌यो ओका बाप न पेयली लाड़ी बिल्हा, आरु जिल्पान पोर्यान क साथ मा रयतो हुतो; आरु हेनकी बुराईन वाराम मा ओका बाप क खबर पुगाड़्या कोरतो हुतो। ");
INSERT INTO dhn_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","आरु इस्राएल हेका सारा पोर्या सी जादा युसुफ सी जादा मोंग राखतो हुतो, काहकी त्यो ओका डाहवारान पोर्‌यो हुतो आरु याकुब ओका वाट्ये भाती भातीन रंग वाळा चोगला बनवायो। ");
INSERT INTO dhn_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","पुन युसुफन दिसरा भाई देख्या कि हामरो बाप हामु आखा सी जादा मोंग हेका सी राखे, तव त्या लोगहन हेका सी घाड़ाय कोरने लाग्या आरु ओका साथ मा वारु वात नी कोरता हुता। ");
INSERT INTO dhn_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","युसुफ एक सपनो देख्यो आरु त्यो सपनो ओका भाई लोगहन क देखाड़्यो तव त्या युसुफ सी आरु वी जादा घाड़ाय कोरने लाग्या। ");
INSERT INTO dhn_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","युसुफ उन लोगहन सी कयो, “जो सपनो हांव देख्यो, ओको समळु ");
INSERT INTO dhn_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","हामु लोगहन खेत मा पुळा बाँधता हुता आरु काय देखो कि म्हारो बांधलो पुळो उबो हुय गयो; तव तुमरा पुळा म्हारा पुळाक च्यारो मेर सी घेर लेदा आरु ओको झुकीन वांद्या।” ");
INSERT INTO dhn_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","तव ओका भाई युसुफ सी कोया काय तु छाचली हामरे पोर राज कोरीस? एने काय छाचली तु हामरे पोर होक कोरीस? अतरा करीन त्या लोगहन युसुफ सपना आरु ओका वातन कारण सी ओकासी आरु वी जादा घाड़ाय कोरने लाग्या। ");
INSERT INTO dhn_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","ओळतेन एक दाहड़ु आरु एक सपनो देख्यो, आरु ओका भाई लोगहन क वी यो सपनो देखाड़्यो, “समळु, हांव एक आरु सपनो देखलो छे, कि दाहड़ु आरु चांद आरु ग्यारे तारा मखे वांद्र्या।” ");
INSERT INTO dhn_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","एना सपनान वारामा युसुफ ओका बाप आरु भाई लोगहन क सामने पुरावो देखाड़्यो: तव हेको बाप युसुफ क लड़्यो आरु कयो यो कसो सपनो छे ज तु देख्यो? काय छाची हांव आरु थारी माय आरु थारा भाई सब जाईन थारे अगळ धरती पोर पड़ीन वांदसु? ");
INSERT INTO dhn_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","हेका भाई ते हेका सी रीस आरु घाड़ाय कोरता हुता पुन हेको बाप हेका कयला बुलोक फोम राख्यो। ");
INSERT INTO dhn_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","आरु हेका भाई लोगहन हेनका बापन गाडरा बकड़ा चरावने करीन शेकेम गया। ");
INSERT INTO dhn_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","तव याकुब युसुफ सी कयो, “थारा भाई लोगहन ते शेकेम मा गाडरा बकड़ा चरावता हसे, अतरान करीन हांव तुख हेनके पास मुकलो।” त्यो हेका सी कयो, “जसो थारो हुकुम हांव हजुर छे।” ");
INSERT INTO dhn_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","युसुफ याकुब सी कयो जा, तारा भास्योन आरु गाडरा बुकड़ान हाल देखिन आव कि चे वारु ते छे कि, ओळी मार जुळ खबर लीन आवजी। अतरान करीन त्यो हेको हेब्रोनोन झुळा मा मुकली देदो, आरु त्यो शेकेम मा आयो। ");
INSERT INTO dhn_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","आरु एक जनो हेको खयड़ा मा अथोन आथो भटकतला देखीन हेका सी पुछ्यो तु काय हेरे? ");
INSERT INTO dhn_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","त्यो कयो, “हांव ते म्हार भाई लोगहन क हेरी रयो गीन करीन मख देखाड़ कि त्या गाडरा बकड़ान क कां चार रोया?” ");
INSERT INTO dhn_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","त्यो मानुस हेका सी कयो, “त्या लोगहन ते यां सी जात रोया; आरु हांव हेनको यो कहवतला समळ्यो, की आवु, हामु दोतान भेनी जाजे अतरान करीन युसुफ हेका भाईन लोगहन क पास जाने लाग्यो आरु हेनको दोतान मा हेर लेदो।” ");
INSERT INTO dhn_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","आरु त्या लोगहन जसा हेकेक नांबे रीन आवतला देख्या, ती हेका साते आवने सी पेहलेज हेको मारनेन विचार बोनाया। ");
INSERT INTO dhn_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","आरु त्या एक दिसरा सी कयने लाग्या, “देखु, त्यो सपनो देखनेवाळो आवने मंडरीयो। ");
INSERT INTO dhn_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","ती आवु, हामु हेको धुकु कोरिन काहला खाढा मा नाख देजे, आरु यो कय देसु, कि काहलो जंगली जोनवार आयो हेको खाय गयो। ओळतेन हामु देखसु की हेका सपनान फोव काय हयसे।” ");
INSERT INTO dhn_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","यो समळीन रुबेन हेको उन लोगहन क हाथ सी वाचाड़ने करीन मन राखीन कयो, हामु हेको जीव सी ते नी मारता। ");
INSERT INTO dhn_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","ओळतेन रुबेन उन लोगहन सी कयो, “लुहुय मा उहवाड़ु, हेको जंगलन एना खाढा मा नाख देजे आरु हेका पोर हाथ मा उठावु।” त्यो हेको हेनका हाथ सी वाचाड़ीन हेका बाप क पास पछ पुगाड़ने हिनतो हुतो। ");
INSERT INTO dhn_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","अतरान करीन असो हुयो कि जव युसुफ हेका भाई लोगहन क पास पुग्यो तव त्या लोगहन हेका रंगबिरंगा चोगला तेनाक त्यो पेहरलो हुतो निकाळ लेदा। ");
INSERT INTO dhn_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","आरु युसुफ क हाकोळीन खाढा मा नाख देदा त्यो खाडो ते सुकलो हुतो आरु उना मा कायबी पानी नी हुतो। ");
INSERT INTO dhn_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","तव त्या लोगहन रोटो खाने करीन बठ गया आरु नजर उँची करीन यो देख्या की इश्माएलियान एक टुळु उटड़ा पोर वारु गंधायन्यो चीज बलसान, आरु गन्धरस सी भरायला, गिलाद सी मिसर भेनी जाने लाग रया हुता। ");
INSERT INTO dhn_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","तव यहुदा न हेका भाई लोगहन सी कयो, “हेका भाई क मारने करीन आरु हेको लुहुय साताड़ने सी काय फायदु हवसे? ");
INSERT INTO dhn_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","आवु, हामु हेको इश्माएलियान हाथोम वेच देजे, आरु हेका हाथ उना पोर नी हाकलिया, काहकी त्या हामरा भाई आरु हामरीज हाड़की आरु माँस छे।” आरु हेका भाई लोगहन न हेकी वात मान लेदा। ");
INSERT INTO dhn_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","तव मिद्यानी वेपारी ओथा सी होईन ओका पास पुग्या। युसुफ क भाई लोगहन न हेको उना खाड़ा मा सी हापकीन निकाळ्या, आरु इश्माएलियान क हाथ चाँदी क वीस टुकड़ा मा वेच देदा; आरु त्या युसुफ क मिसर मा ली गुया। ");
INSERT INTO dhn_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","रुबेन न खाढा पोर लौटीन काय देख्या कि युसुफ खाढा मा नी छे; अतरान करीन त्यो हेका पुतल्या फाड़्यो, ");
INSERT INTO dhn_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","आरु हेका भाई क पास लौटीन कहने लाग्यो, “पुर्‌यो ते नी होय; हेमी हांव कांखेर जाम?” ");
INSERT INTO dhn_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","तव त्या युसुफ क अंगरखो लेदा, आरु एक बुकड़ा क मारीन हेको लुहुय डुबाड़ देदा। ");
INSERT INTO dhn_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","आरु त्या उना रंग बिरंगा अंगरका क हेका बास क पास मुकलीन यो खबर आप्या; “यो हामुक मिळ्यो, देखिन उळखी ले की यो तारा पुर्या क अंगरखो छे कि नी।” ");
INSERT INTO dhn_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","त्यो हेको उळखी लेदो, आरु, “हाव यो म्हाराज पुर्या क अंगरखो छे; काहनलो दुष्ट ढुर न ओको खाय लेदो छे: नि:सन्देह युसुफ फाड़ नाख्यो छे।” ");
INSERT INTO dhn_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","तव याकुब न हेका पुतल्या फाड़्यो आरु कमर मा गंटो वेटायो, आरु आपसा पुर्या क लिय घना दाहड़ा लगुन विलाप करतो रयो। ");
INSERT INTO dhn_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","आरु हेका आखा पुर्या पुरायटा न ओको शान्ति आपनेन कोशिश कर्या; पुन हेको शान्ति नी मीळी; आरु त्यो योज कयतो रयो, “हांवज विलाप करतो जाईन हेका पुर्या क पास अधोलोक मा उतरी जाईस।” इने रीते ओको बास ओका लिय रड़तोज रयो। ");
INSERT INTO dhn_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","एना वीच मिद्यानियो न युसुफ क मिसर मा ली जाईन पोतीपर नावोन फिरोन क एक हाकिम आरु अंगरक्षको क डाहला, क हाथ वेच नाख्यो। ");
INSERT INTO dhn_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","हेनुत दाहड़ा मा ओसो हुयो की यहुदा आपसा भाई क पास सी जात रोयो, आरु हीरा नावोन एक अदुल्‌लामवासी मानुसक पास डेरो कोर्‌यो। ");
INSERT INTO dhn_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","चाँ यहुदा न शुआ नावोन एक कनानी मानुसक पुराय क देख्यो; आरु ओको इयाव कोरीन ओका पास गोयो। ");
INSERT INTO dhn_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","हुयी भारपाये हुयी, आरु ओको एक पुर्य होयो; आरु यहुदा न ओको नाव एर पाड़्यो। ");
INSERT INTO dhn_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","आरु हुयी ओळी भारपाये हुयी, आरु ओको एक पुर्य आरु होयो; आरु ओको नाव ओनान पाड़ देदा। ");
INSERT INTO dhn_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","ओळतेन हेरो एक पुर्य आरु होयो, आरु ओको नाव शेल पाड़ देदा; आरु जेने टेमे एरो जन्म हुयो हेने टेमे यहुदा कजीब मा रोहता हुता। ");
INSERT INTO dhn_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","आरु यहुदा न तामार नावोन एक बायोर सी आपसा मोटला एर क इयाव कोर देदो। ");
INSERT INTO dhn_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","बाखुन यहुदा क हुयो मोटलो एर योहोवा क लेखा मा दुष्ट हुतो, ओतरान कोरिन योहोवा न ओको मार देदो। ");
INSERT INTO dhn_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","ती यहुदा न ओनान सी कयो, “आपसी भोजाय क पास जा, आरु ओका सात देवर क काम पुरो कोरीन आपसा भाई क लिय ओवलियाद पोयदा कोर।” ");
INSERT INTO dhn_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","ओनान ते जानतो हुयो की ओवलियाद मारी कोहायसे; ओतरान कोरिन ओसो हुयो कि जोत्यार हुयो आपसी भोजाय क पास गोयो, ती हुयो नेड़ु वीर्य पाड़ीन नाश कोर्यु, जिनासी ओसो नी होये की ओको भाई क नाव सी ओवलियाद चाले। ");
INSERT INTO dhn_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","यो काम ज हुयो कोर्‌यो हेनासी योहोवा खुश नु होयु आरु हुयो हेनाक वी मार देदो। ");
INSERT INTO dhn_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","ती यहुदा न इनी बिक सी क काई ओसो नी होये की आपसा भाई क जोसो शेला वी मोरे, आपसी उहड़ीस तामार सी कयो, जोत्यार लोगुन मारु पुर्यु शेला सयाना नी होय जाय ती लोगुन आपसा बाबा क घोर मा रोडायलीत बोस रोह। ओतरान कोरिन तामार आपसा बाबा क घोर मा रोहने लागी। ");
INSERT INTO dhn_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","घोनी टेम क वितने पोर यहुदा क घोरवाळी जी शुआ क पुराय होती, ची मोर गोय; ओळतेन यहुदा शोक क दाहड़ा वितने पोर आपसा जुड़ीदार हीरा अदुल्‌लामवासी भेळ आपसा गाडरा बुकडा क रुई कातरनेवाळा क पास तिम्नाह क गोया। ");
INSERT INTO dhn_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","आरु तामार क यो खोबोर जोड़ी, “तारो सेसरो आपसा गाडरा बुकड़ा क रुई कातरावने क लिय तिम्नाह क जाने वाज रोयु।” ");
INSERT INTO dhn_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","ती हुयी यो विचारीन कि शेला सयाना ते होय गोयु बाखुन हांव हेरी घोरवाळी नी होय पाय; आपसा विधवापन क पेहरोट उतारी आरु घुमतु पाँगरीन आपसा क ढाक लेदी, आरु एनेम नगर क झोपला क पास, ज तिम्नाह क वाटे मा छे, जाय बोसी। ");
INSERT INTO dhn_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","जोत्यार यहुदा न ओको देख्यो, हुयो हेनीक वेश्या सोमझ्यो; काहकी हुयी आपसो मुय ढाकली होती। ");
INSERT INTO dhn_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","हुयो वाटी सी हेरे भिनी फिर्यु, आरु हेनीक कोहने लाग्यु, मेसेक तारेन्चा आवने दे (काहकी ओको यो मालुम नी हुतो कि हुयी ओकी उहड़ीस छे।) आरु हुयी कोहने लागी, “काहमाइन हांव तुसेक मारे याँ आवने दीस, ती तु मेसे काय आपीस?” ");
INSERT INTO dhn_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","हुयो कोयो, “हांव मारा बुकड़ा मा सी बुकड़ान एक गिदल्यो तारेन्चा मुकली दीस।” ती हुयी कोहि, “भलो हुयो मुकलने लोगु काय तु आमरे पास काहीन रेहन मेक जाईस?” ");
INSERT INTO dhn_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","हुयो पुछ्यो, “हांव तारे पास काय रेहन मेक जाम?” हुयी कोहि, “आपसी मुहर, आरु बाजुबंद, आरु आपसा हातोन लाकुड़।” ती हुयो हेनीक होयि चिजे आप देदु, आरु ओका पास गोयो, आरु हुयी भारपाये होयी। ");
INSERT INTO dhn_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","ती हुयी उठिन जात रोय, आरु आपसो घुमतो उतारीन आपसो विधवापन क पेहरोट ओळी पेहेर लेदी। ");
INSERT INTO dhn_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","ती यहुदा न बुकड़ान गिदल्यो आपसा जुड़ीदार हेना अदुल्‌लामवासी क हात सी मुकली देदो की हुयी रेहन राखली चिजो हेनी बायोर क हात सि छुड़ाय ली आवे; बाखुन हुयी बायोर हेनाक नी मीळी। ");
INSERT INTO dhn_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","ती हुयो चाँ वाळा मानशो सी पुछ्यो, “ची देवदासी जी एनेम मा वाटी क एक धोड़े बोसी होती, काँ छे?” हुये कोया, “याँ ते कुसु देवदासी नी होती।” ");
INSERT INTO dhn_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","ओतरान कोरिन हुयो यहुदा क पोछो आवीन कोयो, “मेसे ची नी मीळी; आरु हेना जागा क मानसे कोया ‘ याँ ते कोय देवदासी नी होती।’” ");
INSERT INTO dhn_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","ती यहुदा न कोयो, “वारु, हुयो बन्धक हेरेनचा रोहने दे, नी ते आपनु मानसे तुच्छ गिनाय जासु; देख, मेते बुकड़ा क यो गिदल्यो मुकली देदो हुतो, बाखुन हुयी तुसे नी जोड़ी।” ");
INSERT INTO dhn_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","घोनाघोना तीन मोहना क वाद यहुदा क यो खोबोर जोड़ी, “तारी उहड़ीस तामार न छिनावो कोरली छे; बाखुन हुयी व्यभिचार सी भारपाये वी होय गोयली छे।” ती यहुदा न कोयो, “ओको खोयड़े ली आवु की हेनीक धोपाड़ देजे।” ");
INSERT INTO dhn_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","जोत्यार हेनीद खोयड़े निकाळता होता, ती होयी, आपसा सेसराक पास यो कोय मुकली, “जेना मानसो क ये चिजे छे, हेना सी हांव भारपाये छे,” ओळी हुयी यो वी कोवाड़ी, “उवोख ते खोरु की यी मुहर, आरु बाजुबंद, आरु लाकड़ी कुनीन छे।” ");
INSERT INTO dhn_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","यहुदा न हेनुक उळखीन कोयु, “हुयी ते मारसी कम गुनावी छे; काहकी हांव हेरे मारा पुर्या शेला सी इयाव नी कोर्यु।” आरु हुयो हेरेसी ओळी कोदी प्रसंग नी कोर्यु। ");
INSERT INTO dhn_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","जब हेरो फोवरि होयने क टेम आवी, ती यो जान पोड़्यो की हेरा पेटो मा जोवया पुर्या छे। ");
INSERT INTO dhn_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","आरु जब हुयी फोवरी होयने लाती ती एक पुर्या क हात खोयड़े आयो, आरु दाई न रातला सुत लीन हेरा हातो मा यो कोवती जाईन बाँद देदी, “पेहेल यु पोयदा होयु।” ");
INSERT INTO dhn_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","जब हुयी हात सेमटी लेदी, ती हेरु भाईस पोरदा होय गोयु, ती होयी दाई न कोहि, “तु काहा बरबस निकोळी आवलु छे?” एका लिय ओको नाव पेरेस राख देदा। ");
INSERT INTO dhn_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","पोछोळ ओको भाई जेरा हात मा रातलो सुत बान्दलो हुतो पोयदा हुयो, आरु ओको नाव जेरह राख देदा। ");
INSERT INTO dhn_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","जब युसुफ काजे मिसर मा पुग गोयु, ती पोतीपर नावोन एक मिसरी न, जुळ फिरोन क हाकिम, आरु अंगरक्षक क डाहलु होतु, ओको इश्माएलियो क हात सी जु हेना होया ली गोयु होतु, मुले लेदु। ");
INSERT INTO dhn_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","युसुफ आपसा मिसरी स्वामी क घर मा रोहतु होतु, आरु योहोवा ओका संग होतु; ओतरान कोरिन हुयु भागोवाळु मानुस होय गोयु। (प्रेरि 7:9) ");
INSERT INTO dhn_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","आरु युसुफ क स्वामी न देख्यो, की योहोवा हेनका पुठी रोहे, आरु जो काम हुयो कोरे ओको योहोवा ओका हात सी सफल कोर देये। (प्रेरि 7:9) ");
INSERT INTO dhn_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","ती हेरा फोकटन दया क निगाह युसुफ पोर होयी, आरु हुयो हेनाक ओकी सेवा चाखरी कोरने क लिय नेवाड़ कोर लेदो; ओळी हुयो हेनाक आपसा घोर क आधिकारी बोनावीन आपसो आखो काई ओका हात मा सोप देदु। ");
INSERT INTO dhn_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","जब सी हुयो हेनाक आपसा घोर क आरु हेरु आखी जायदाद क होकदार बोनायु, ती योहोवा युसुफ क कारण हेना मिसरी क घर पोर बोरकोत आपने लाग्यु; आरु काई घर मा, काय खोयड़ा मा, ओको जो काई हुतो, सब पोर योहोवा क बोरकोत होयने लागी। ");
INSERT INTO dhn_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","ओतरान कोरिन हुयो आपसा सब काई युसुफ क हात मा याँ तक छुड़ देदु की आपसा खाने क रुटा क छुड़िन, हुयो हेरी जायदाद क हान काई नि जानतो हुतो। युसुफ घाटावु आरु रुपवान होतु। ");
INSERT INTO dhn_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","एनी बातो क वाद ओसो हुयो, की हेरा स्वामी क घोरवाळी न युसुफ क भीनी डुळा लागाड़ी आरु कोहि, “मारे साते सुळ।” ");
INSERT INTO dhn_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","बाखुन हुयो नि कोहतु जाईन आपसा स्वामी क घोरवाळी सी कोयु, “सोमोळ, जो काई इना घोर मा छे मारा हातो मा छे; हुयो मारु स्वामी काई नी जाने, आरु हुयो आपसो आखो काई मेसे मार हातो मा सोप देदलु छे। ");
INSERT INTO dhn_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","एना घोर मा मार सी मोटो कुदु नी; आरु हुयो तुसे छुड़िन, जि हेरी घोरवाळी छे; मारसी काई नी मेक छुड़्यु; ओतरान कोरिन भोलो, हांव ओसी मोटी दुष्टता कोरीन परमेश्वर क गुनावु काहा बोनो?” ");
INSERT INTO dhn_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","आरु ओसो हुयो की हुयी दाहड़ीन युसुफ सी वात कोरती रोही, बाखुन हुयो हेरी नी मान्यु कि हेरे पास लुटे ने हेरे पुठी सुवतु रोहे। ");
INSERT INTO dhn_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","एक दाहड़ु काय होयो कि युसुफ आपस काम काज करने क लिय घोर मा गोयो, आरु घोर क चाखर्या मासी कोय वी घोर मा नी होतो। ");
INSERT INTO dhn_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","ति हुयी बायोर न ओका छिन्दरा धोरीन कोहि, “मारे साते सुव,” बाखुन हुयु आपसा छिन्दरा हेरा हात मा नाखिन ढास गोयु, आरु खोयड़े निकोळी गोयु। ");
INSERT INTO dhn_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","यो देखीन कि होयी आपसा छिन्दरा मारा हातो मा रोहन्दीन ढास गोयु, ");
INSERT INTO dhn_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","होयी बायोर न आपसा घोर क चाखर्या क बुलावीन कोहि, “देखु, हुयो एक इब्री मानुसक आपनो तिरस्कार करने क लिय मारे पास ली आवलो छे। हुयो ते मारे साते सुवने क मोतलोब सी मारे पास माहाय आवलो हुयो आरु हांव जुरे आयड़ी देदी। ");
INSERT INTO dhn_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","आरु मारी मोटेत आयड़ी सोमळीन हुयो आपसा लुगड़ा मारे याँ नाखीन ढास गोयो, आरु खोयड़े निकोळी गोयो।” ");
INSERT INTO dhn_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","आरु हुयो ओका लुगड़ा ओका स्वामी क घोर आवने लोग आपसे जुळ मेक रोय। ");
INSERT INTO dhn_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","ती हुयो हेनासी ओसी वात कोरी कि, “हुयो इब्री दास जेनाक तु आपने पास ली आवलु छे, हुयो मेसे हासी करने क लिय मारे पास आयो हुतो; ");
INSERT INTO dhn_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","आरु जब हांव घोन जुरे आयड़ि देदी, तु हुयो हेरा लुगड़ा मारे याँ नाखिन खोयड़े ढास गोयो।” ");
INSERT INTO dhn_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","आपसी घोर वाळी क यी बात सोमळीन क तारो दास मार सी ओसो ओसो काम कोर्‌यो, युसुफ क स्वामी क कोप भोड़क्यो। ");
INSERT INTO dhn_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","आरु युसुफ क स्वामी न ओको धोरीन जेलखाना मा, जाँ राजा क केदड़ा बोन्द होता, बोन्द कोराय देदु; एने हुयो हेना जेलखाना मा रोयो। ");
INSERT INTO dhn_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","बाखुन योहोवा युसुफ क पुठ पुठी रोयो, आरु ओका पोर गीन कोर्यु, आरु जेलखाना क दरोगा मुखी क गिन क निगाह हेना पोर पोड़ली होती। ");
INSERT INTO dhn_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","ओतरान कोरिन जेलखाना क दरोगा मुखी न हेनु सब बान्दायला क, जे जेलखाना मा होता, युसुफ क हात मा सोप देदो; आरु जो जो काम हुये कोरता होता, चो हेरात हुकुम सी होयतो होतो। ");
INSERT INTO dhn_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","युसुफ क होको मा जो काई होतो हेनामा सी जेलखाना क दरोगा मुखी क काई वी चिज देखनो नी पोड़तो होतो; काहकी योहोवा युसुफ क सात होतो; आरु जो काई हुयो कोरतो हुतो, योहोवा ओको ओकामा सफलता आपतो हुतो। ");
INSERT INTO dhn_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","एनी वातो क वाद ओसो हुयो, कि मिसर क राजा क पिलानेहारे आरु खावड़ावनीया पिवड़ावनीया आपसा स्वामी क विरुद्ध गुनु कोर्या। ");
INSERT INTO dhn_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","ती फिरोन न आपसा हेनु दुयो हाकिमो, यानी पिलानेहारो क डाहला, आरु पकानेहारो क डाहला पोर रिसवाईन ");
INSERT INTO dhn_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","हेनुक बुजाड़िनम, अंगरक्षक क डाहला क घोर क हेना जेलखाना मा, जा युसुफ बोंद होतु, नाखाड़ देदु। ");
INSERT INTO dhn_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","ती अंगरक्षक क डाहला न ओको युसुफ क हातो मा सोवंप्यो, आरु हुयो हेन्दरु सेवा चाखरी कोरने लाग्यु; एने हुये थुड़ा दाहड़ा लोगुन जेलखाना मा रोया। ");
INSERT INTO dhn_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","मिसर क राजा क पिलानेहारा आरु पकानेहारा, जे जेलखाना मा बंद हुता, हेनु दुयु न एकुत रातो मा, आपसा-आपसा होनहार क ओनसारे, सोपना देख्या। ");
INSERT INTO dhn_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","सोन्दारे जब युसुफ हेन्दरे पास माहाय गोयु, ती हेन्दरे पोर निगाह कोर्यु, ती काय देख्यु, की हुये घाबरायला छे। ");
INSERT INTO dhn_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","ओतरान कोरिन हुये फिरोन क हेनु हाकिमो सी, जो ओका सात हेन्दरो स्वामी क घोर क जेलखाना मा होता, पुछ्‍या, “आज तुमरो मुय काहा उतरी रोयो?” ");
INSERT INTO dhn_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","हुये हेनुक कोया, “हामु दुयु सोपनो देखला छे, आरु हेन्दरो फळक बताड़नेवाळो कोय नी होय।” युसुफ न हेनुसी कोयो, “सोपना क फोव कोहनो परमेश्वर क काम नी छे? मेसे आपनो आपनो सोपनो देखाड़ु।” ");
INSERT INTO dhn_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","ति पिलानेहारे क डाहलो हेरो सोपनो युसुफ क यो देखाड़ने लाग्यो: हांव सोपना मा देख्यु, कि मारे ओगोळ एक अंगुर न मुरे छे; ");
INSERT INTO dhn_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","आरु हेनी दाखलता मा तीन डाळ्या छे; आरु हेरेमासी ओसा मुरे लागला छे, आरु चे फुली आरु हेरा गुमछा मा अंगुर लागीन पाक गोयो। ");
INSERT INTO dhn_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","आरु फिरोन क कटोरो मारा हात मा हुतो; आरु हांव हेना दाख क लीन फिरोन क कटोरा मा निफयु आरु कटोरा क फिरोन क हात मा आप्यु। ");
INSERT INTO dhn_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","युसुफ न हेनासी कोयो, “एरो फोव यो छे: तीन डाळन मतलब छे ");
INSERT INTO dhn_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","ओतरान कोरिन हिमि तीन दाहड़ा क माहाय फिरोन तारो मुनको उँचो कोरसे, आरु ओळी सी तारा पद पोर तुसे नेवाड़से, आरु तु पेहले क जोसु फिरोन क पिलानेहारा होईन ओको कटोरो ओका हात मा ओळी आप्या कोरीस। ");
INSERT INTO dhn_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","एने: जब तारो भोलो होय जाय ती मेसे फोम कोरजी, आरु मार पोर गीन कोरिन फिरोन सी मारी वात चालाड़जी, आरु इना घोर सी मेसे छुड़ाय देजी। ");
INSERT INTO dhn_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","काहकी छाचिन इब्रानी क देश सी मेसे चुराविन लावला छे, आरु याँ वी हांव ओसो काई ओसो काम नी कोर्यु, जेरे जुगु मे इना जेलखाना मा रोहनो जुवे।” ");
INSERT INTO dhn_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","यो देखिन कि हेन्दरा सोपना क फोव वारु निकोळ्यो, पकानेहारे क डाहलो न युसुफ सी कोयो “हांव वी सोपनो देखलो छे, चो यो छे: हांव देख्यु की मारा मुनका पर धोवळ्या रुटा क तीन टोगारा छे ");
INSERT INTO dhn_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","आरु ऊपोर क टोगारा मा फिरोन क लिय सब भातीन क चुड़लो चिजे छे; आरु चिल्‌ला मारा मुनका पोर क टोगारा मा सी तेनु चिज क खाय रोया।” ");
INSERT INTO dhn_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","युसुफ न कयो, “एरो फोव यो छे: तीन टोगारा क मतलव तीन दाहड़ा छे। ");
INSERT INTO dhn_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","हीमी सी तिन दाहड़ा क माहाय फिरोन तारा मुनको काटाड़ीन तुसे एक झाड़ पोर टांगाड़ देसे, आरु चिल्‌ला तारो मांस क नुची नुचीन खासे।” ");
INSERT INTO dhn_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","आरु तिसरे दाहड़े फिरोन क जन्मदिन हुतो, हुयो आपसा आखा कामकोर्न्या क भोज आप्यो, आरु हेरेमा सी पिलानेहारो क डाहलो, आरु पकानेहारो क डाहलो सुयो क जेलखाना सी निकायमांग्यो। ");
INSERT INTO dhn_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","पिलानेहारो क डाहलो क ते पिलानेहारे क जागा पोर ओळी सी नेवाड़ लेदो, आरु हुयो फिरोन क हात मा कटोरो आपने लाग्यो। ");
INSERT INTO dhn_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","बाखुन पकानेहारे क डाहला क हुयो टांगाड़ देदो, जोसो कि युसुफ न हेरा सोपना क फोव हेनाक कोवलो हुतो। ");
INSERT INTO dhn_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","ते वी पिलानेहारो क डाहलो न युसुफ क फोम नि राख्यो: बाखुन हेनाक वीसरी गोयो। ");
INSERT INTO dhn_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","पुरा दुय साल क वितने पोर फिरोन न यो सोपनो देख्यो की हुयो नील नदी क कातरे उबो छे। ");
INSERT INTO dhn_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","आरु तेनी नदी मा सी सात घाटावी आरु माती माती गाय निकोळीन नंदिन दंगवु चोरने लागी। ");
INSERT INTO dhn_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","आरु, काय देख्यु कि हेन्दरे पोछोळ आरु सात गाय, जे नानी कुरुप आरु कोमजुर छे, नदी दी निकोळी; आरु दुसरी गायो क धोड़े नदी क तट पोर जाईन उबी होय। ");
INSERT INTO dhn_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","ती ये नानी आरु कोमजुर गाये हेनु सात घाटावी आरु माती माती गाय क खाई गोय। ती फिरोन जाग उठ्यु। ");
INSERT INTO dhn_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","आरु हुयो ओळी सुय गोयो आरु दुसरो सोपनो देख्यो कि एक पुवा मा सी सात मोटी आरु वार वारु उम्बीया निकोळी। ");
INSERT INTO dhn_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","आरु, काय देख्यो कि हेन्दरे पोछोळ सात उमबिया पातळी आरु उगनले धड़ेन वावही सी चिमायली निकळी। ");
INSERT INTO dhn_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","आरु इनु पातळी उम्बीया क गिळ लेदी। ती फिरोन जाग्यु, आरु हेनाक मालुम होयो कि यो सोपनोत हुतो। ");
INSERT INTO dhn_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","भोर क फिरोन क मन‍ व्याकुल हुयो; आरु हुयो मिसर क सब ज्योतिषियो, आरु पंडितो क बुलावने मुकल्यु; आरु हुये मारा सोपना क देखाड़े; बाखुन हेन्दरे मा सी कोय नी हेरो फोव फिरोन क नी देखाड़ सोक्या। ");
INSERT INTO dhn_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","ती पिलानेहारो क डाहलो फिरोन सी कोय पोड़्यु, “मारु गुनु आज मेसे फोम आवि: ");
INSERT INTO dhn_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","जोत्यार फिरोन आपसा दास सी रिसवायलु होतु, आरु मेसे आरु पकानहारे क डाहला क केद कोराळीन अंगरक्षको क डाहला क घोर क जेलखाना मा नाख देदु होतु; ");
INSERT INTO dhn_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","ती हामु दुयु ने एकुत सोपनो रात मा, आपना आपसा होनहार क ओनसारे देखला; ");
INSERT INTO dhn_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","आरु चाँ आमरे साते एक इब्री जुवान होतु, जु अंगरक्षक क डाहला क दास हुतो; एने: आमु हेना देखाड़ला, आरु हुयो आमरा सोपना क फोव आमरी सी कोयो, आमरे मा सी एक एक क सोपना क फोव हुयो देखाड़ देदलो। ");
INSERT INTO dhn_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","आरु जोस जोसो फोव हुयो आमरे सी कोहलो हुतो, तोसोत होयलो वी, यानी मेसेक ते मारु जागु जोड़ गोयु, बाखुन हुयो फांसी पोर टांग देदा।” ");
INSERT INTO dhn_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","ती फिरोन न युसुफ क बुलावने मुकल्यु। आरु हेनाक तावनी पाड़िन जेलखाना सी निकाळ लाया, आरु झोटा विचरिन, आरु छिन्दरा बोदलीन फिरोन क ओगोळ आयो। ");
INSERT INTO dhn_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","फिरोन न युसुफ सी कोयो, “हांव एक सोपनो देखलु छे, आरु हेरे फोव क देखाड़नेवाळो कोय वि नी; आरु हांव तार वाराम सोमवलु छे, कि तु सोपनो सोमवतात हेरो फोव देखाड़ सोके।” ");
INSERT INTO dhn_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","युसुफ न फिरोन सि कोयो “हांव ते काई नी जानो: परमेश्वरुत फिरोन वाटू वारलो बुल आपसे।” ");
INSERT INTO dhn_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","ओळी फिरोन युसुफ सी कोहने लाग्यु, “हांव मारा सोपना मा देख्यु, कि नील नदी क किनारे पोर उबलु छे। ");
INSERT INTO dhn_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ओळी, काय देख्यु, कि नदी मा सी सात माती आरु घाटावी घाटावी गाय निकोळीन दंगवु क खोड़ो चोरने लाग गोय। ");
INSERT INTO dhn_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","ओळी, काय देख्यु, कि हेन्दरे पोछोळ सार आरु गाय निकोळी, जी पातळी, आरु बेस कुरुप, आरु दुर्बल छे: हांवते आखा मिसर देश मा ओसी कुडोल गाये कोदी नी देख्यु। ");
INSERT INTO dhn_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","इनु कोमजुर आरु डगरी गायोन हेनु पेहली सातो माती माती गाय क खाई गय। ");
INSERT INTO dhn_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","आरु जब हुये हेनुक खाई गोय ती यो मालुम नी हुयतो थो कि हुये ओको खाई गयली छे, काहकी चे पेहेल क जोसी क जोसी कुडोल रोही। ती हांव जाग उठ्यु। ");
INSERT INTO dhn_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","ओळी हांव दिसरो सोपनो देख्यु, कि एकुत पुवा मा सात वार वारु आरु दाना सी भोरायली उम्बीया निकोळी। ");
INSERT INTO dhn_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","ओळी काय देख्यु, कि पोछोळ आरु सात उम्बीया छूछी छूछी आरु पातळी आरु पुरवाई सि मुरझायली निकोळी। ");
INSERT INTO dhn_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","आरु इनी पातळी उम्बीया न हेनु सात वार वारु उम्बीया क गिळ गोय। यी हांव नजर बांदा काजे बताड़ीयो, बाखुन यो सोमाझाड़ने वाळो कोय नी मिळ्यो।” ");
INSERT INTO dhn_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","ती युसुफ न फिरोन सी कयो, फिरोन क सोपनो एकुत छे, परमेश्वर जो जाम कोरने चाहे, तेनाक हुयो फिरोन पोर प्रकट कोरलो छे। ");
INSERT INTO dhn_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","चे सात वार वारु गाय सात साल छे; आरु चे सात वार वारु उम्बिया वी सार साल छे; सोपनो एकुत छे। ");
INSERT INTO dhn_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","ओळी हेन्दरे पोछोळ जे कोमजुर आरु डगरी गाये निकोळी, आरु जे सात छूछी आरु पुरवाई सी मुरझायली होयली उम्बीया निकोळी, चे अकाल क सात साल होयसे। ");
INSERT INTO dhn_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","यी चीत् वात् छे जी हांव फिरोन काजे कोय देदु, की परमेश्वर जो काम कोरने चाहाय, चो हुयो फिरोन काजे देखाड़लो छे। ");
INSERT INTO dhn_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","सोमोळ, आखा मिसर देश मा सात साल ते घोनो सोटो ओनाज फोळसे। ");
INSERT INTO dhn_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","एरे वाद सात साल काव क आवसे, आरु आखा मिसर देश मा मानसे इनी आखी कोमाई क विसरी जासे; आरु काव सी देश क नाश होयसे। ");
INSERT INTO dhn_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","आरु सुकाव (बहुतायत क कोमाई) देश मा ओळी फोम नी रोहसे काहकी काव घोने जोबोर होयसे। ");
INSERT INTO dhn_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","आरु फिरोन न जो यो सोपनो दुय वार देखलो छे एरो दाखलो योत छे कि योत छे कि यो वात परमेश्वर क भीनी सी नेवाड़ होय चुकलो छे, आरु परमेश्वर एनाक घोनो छाटोत पुरो कोरसे। ");
INSERT INTO dhn_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","ओतरान कोरिन हिमि फिरोन कुदाक समझदार आरु ओकोल वाळा मानुसक हेर कोरीन तेनाक मिसर देश पोर प्रधानमंत्री बोनावसे। ");
INSERT INTO dhn_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","फिरोन यो करे कि देश पोर होक क नेवाड़ कोरे, आरु जब लोगुन सुकाल क सात साल रोहे तोत्यार लोगुन हुयो मिसर देश क कोमाई क पांचवु वाटू लिया कोरे। ");
INSERT INTO dhn_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","आरु चे एनु वारला सालो मा सब भाती क खाने क चिज एकठो कोरे, आरु नगर नगर मा भण्डार घर भोजन क लिय, फिरोन क होकोम कोरीन ओकी गुळावी कोरे। ");
INSERT INTO dhn_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","आरु हुयो खानेन चिज काव क हेनु सात साल क लिय, जे मिसर देश मा आवसे, देश क भोजन क निमित्त राख राखे, जिनासी देश हेना काव सी सत्यानाश नी हो जाय। ");
INSERT INTO dhn_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","यी वात फिरोन आरु ओका आखा कामकोरनया क वारु लागी। ");
INSERT INTO dhn_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","ओतरान कोरिन फिरोन न आपस कामकोरन्या सी कोयो, “काय आमुक ओसो मानुष, जोसो यु छे, जेरेमा परमेश्वर क आत्मा रोहे छे, मिळ सोक छे?” ");
INSERT INTO dhn_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","ओळी फिरोन न युसुफ सी कोयो, परमेश्वर नजो तुसे ओतरो गियान आपलो छे, कि तार जोसो कुदु समझदार आरु ओकोलवाळु नी; ");
INSERT INTO dhn_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","ओतरान कोरीन तु मारा घोर क होकदार होयसे, आरु तारा हुकुम क ओनसारे मारी आखी प्रजा चालसे, केवल राजगाद्दी क वारामा हांव तार सी मोटू कोवाईस (प्ररि 7:10) ");
INSERT INTO dhn_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","ओळी फिरोन न युसुफ सी कोयो, “सोमोळ, हांव तुसेक मिसर क आखा देश क उपोर होक आपो।” ");
INSERT INTO dhn_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","ती फिरोन न आपसु हात सी मुँदी निकाळीन युसुफ क हात म पेराय देदु; आरु ओको घोना वारु मलमल क छिन्दरा पेराय देदा, आरु हेरा गोळा मा सोना क माला पेराय देदा; ");
INSERT INTO dhn_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","आरु ओको आपसा दिसरा रथ पोर चोढाया; आरु मानसे हेरे ओगोळ ओगोळ यो पोरचार कोरता चाल्या, कि मान्डा टेकविन वान्दु आरु हुयो इनाक मिसर देश क पोर प्रधानमंत्री बोनायो। ");
INSERT INTO dhn_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","ओळी फिरोन न युसुफ सी कोयो, “फिरोन ते मे छे, आरु आखा मिसर देश मा कोय वी तारा हुकुम क विगुर हात पाय नी हालवे।” ");
INSERT INTO dhn_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","फिरोन न युसुफ क नाव सापनत पानेह पाड़्यु। आरु ओन नगर क याजक पोतीपेरा क पुराय आसनत सी ओकी इयाव कोराय देदो। आरु युसुफ आखा मिसर देश क मा दौर कोरने लाग्यु। ");
INSERT INTO dhn_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","जब युसुफ मिसर क राजा फिरोन क ओगोळ उबो हुयो, ती हुयो तिस साल क हुतो। हुयो फिरोन क ओगोळ सी निकोळीन आखा मिसर देश मा दौरु कोरनर लाग्यु। ");
INSERT INTO dhn_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","सुकाल क सातु साल मा धोरती बेसकी धान पाकाड़ती रोही। ");
INSERT INTO dhn_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","आरु युसुफ हेनु सात साल मा आखी भातीन क खानेन चीजे, जे मिसर देश मा होयती होती, एकठो कोरीन नगर क च्यारु मेर क खेतो क भोजन चीजो क हुयो हेना नगर मा एकठो कोरतो गोयो। ");
INSERT INTO dhn_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","ओस कोरीन युसुफ न धान क दरीया क रेत क जोसो घोनो सोटो सा टोका टोका गिनीन मेक लेदु, याँ लोगुन कि हुयो हेन्दरो गिननो छुड़ देदो; काहकी हुये निगिनाये ओसा होय गोयो। ");
INSERT INTO dhn_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","काव क पेहला साल क आवने सी पेहेल युसुफ क दुय पुर्या, ओन क याजक पोतीपेरा क पुराय आसनत सी जन्म्या। ");
INSERT INTO dhn_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","“आरु युसुफ न आपसा मोटला क नाव मनश्शे पाड़्यु, कि परमेश्वर न मार सी मारो आखो घोरानो विसराड़ देदलु छे।” ");
INSERT INTO dhn_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","दिसरा क नाव हुयो यो कोविन एपरेम पाड़्यु, कि मेसे दुख वेठने क देश मा परमेश्वर न फलवन्त कोरलु छे। ");
INSERT INTO dhn_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","आरु मिसर देश क सुकाल क सात साल सोर गोया। ");
INSERT INTO dhn_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","आरु युसुफ क कोहने क ओनसारे सात साल क लिय काव सुरु होय गोयु। आखा देशो मा काव पोड़ने लाग्यु; बाखुन आखा मिसर देश मा धान होतो। (प्रेरि 7:11) ");
INSERT INTO dhn_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","जब मिसर क आखा देश भुके मोरने लाग्या; ती मानसे फिरोन सी आयड़ी आयड़ीन रुटा माँगने लाग्या; आरु हुये आखा मिसरी सी कोया कोरतलु, युसुफ क पास जावु; आरु जो काई हुयो तुमरे सी कोहे, चोत कोरु (प्रेरि 7:11) ");
INSERT INTO dhn_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","ओतरान कोरिन जब काव आखी कोळी पोर होय गोय, आरु मिसर देश मा काव क बेस जोबोर रुप होय गोयो; ती युसुफ सब भण्डारन घर क उगाड़ीन मिसरी लोगहन क ओन वोचने लाग्यु। ");
INSERT INTO dhn_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","ओतरान कोरिन आखी कोळी क मानसे मिसर मा ओन मुले लेने क लिय युसुफ क पास आवने लाग्या, काहकी आखी कोळी पोर बेस जोबोर काव होतु। ");
INSERT INTO dhn_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","जब याकुब न सोमळ्यो कि मिसर मा ओन छे, ती हुयो आपसा पुर्या सी कयो, “तुमु एक दिसरान मुय काय देख रोया।” ");
INSERT INTO dhn_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","ओळी हुयो कोयो, हांव सोमवलु छे की मिसर मा ओन छे; ओतरान कोरिन तुमु होंया जाईन आपने जुगु ओन मुले लि आवु, जेरेसे आपनु नी मोरजे, बाखुन जुवतला रोहजे (प्रेरि 7:12) ");
INSERT INTO dhn_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","एने: युसुफ क दस भाई ओन मुले लेने क लिय मिसर क गोया। ");
INSERT INTO dhn_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","बाखुन युसुफ क भाई बिन्यामीन क याकुब न यो विचारीन भाष्‍यो क भेळ नी मुकल्यो कि काहमाईन ओसो नि होये कि हेर पोर काहिन वेला आय पोड़े। ");
INSERT INTO dhn_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","ओस कोरीन जे मानशे ओन मुले लिन आया ओका सात इस्राएल क पुर्या वी आया; काहकी कनान देश मा वी भारी काव होतु (प्रेरि 7:11) ");
INSERT INTO dhn_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","युसुफ ते मिसर देश क आधिकारी होतु, आरु हेना देश क सब मानशो क हात हुयोत ओन वेचतो हुतो; ओतरान कोरिन जब युसुफ क भाई आया ती भिमा मुयोन भुरसे पोड़िन ओको वांद्या। ");
INSERT INTO dhn_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","हेनुक देखिन युसुफ न उळखी ते लेदु, बाखुन हेन्दरे ओगोळ भुळु बोनीन वातड़ु होईन हेनुक पुछ्यु, “तुमु का सी आय रोया?” हुये कोया, “हामु ते कनान देश सी ओन मुले लेने क लिय आवला छे।” ");
INSERT INTO dhn_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","युसुफ न आपसा भाई क उळखी लेदु, बाखुन हुये हेनाक नी उळख्या। ");
INSERT INTO dhn_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","ती युसुफ आपसा हेनु सोपना क फोम कोरिन जे हुये हेर वाराम देखला होता, हेनुक कोहने लाग्यु, “तुमु जासुस छे; एना देश न वेला क देखने क लिय आय रोया।” ");
INSERT INTO dhn_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","हुये हेनाक कोया, “नि, नि, हे पोरबु, तारा दास खानेन चीजे मुले लेने क लिय आय रोया। ");
INSERT INTO dhn_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","आमु आखा एकुत बाबान पुर्या छे, हामु सुदा मानशे छे, तारा दास जासुस नी होय।” ");
INSERT INTO dhn_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","हुयु हेनुक कोयु, “नी, तुमु एना देश क वेला देखनेत क आवला छे।” ");
INSERT INTO dhn_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","हुये कोया, “हामु तारा दास बारे भाईश छे, आरु कनान देशवासी एकुत मानुसक पुर्य छे, आरु नानलो एने टेमे आमरा बाबा क पास छे, आरु एक नी रोयु।” ");
INSERT INTO dhn_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","ती युसुफ न हेनु सी कोयु हांव ते तुमरे सी कोय देदु, कि जासुस करनिया छे; ");
INSERT INTO dhn_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","इने रिते तुमु पारखाय जासु, फिरोन क जिवन क शपथ, जोत्यार लोगुन तुमरु नानलु भाईस याँ नी आवे ती लोगुन तुमु याँ सी जाय नि सोकु। ");
INSERT INTO dhn_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","ओतरान कोरिन आपसा मा सी एक क मुकली देवी कि चू तुमरा भाईस क लि आवे, आरु तुमु मानशो बान्दायन रोहसु; ओस कोरीन तुमरी वात पारखाय जासे कि तुमु छाचा छे की नी। कदाम तुमु खोरा नी निकोळ्या ती ते फिरोनन जीवण शपथ तुमु छाचीन जासुस कोवायसु। ");
INSERT INTO dhn_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","ती हुयु हेनुक तिन दाहड़ा लोगुन जेलखाना मा बुज रोयु। ");
INSERT INTO dhn_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","तिसरे दाहड़े युसुफ न हेन्दरे सी कोयु, “एक काम कोरु ती जीवतला रोहसु; काहकी हांव परमेश्वर क बिक मानो; ");
INSERT INTO dhn_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","काहमाईन तुमु सुदा मानसे होय, ति तुमु आखा भाष्यो मा सी एक जन एना जेलखाना मा बादायलु रोहे; आरु तुमु आपसा घोरवाळा क भुक मिटावने क लिय ओन ली जावु। ");
INSERT INTO dhn_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","आरु आपसा नानला भाई क मारे पास ली आवु; ओस कोरिन तुमरी वात खोरली कोहायसे, आरु तुमु मारे नी जासु।” ति हुये तोसोत कोर्या। ");
INSERT INTO dhn_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","हेये हुयेत आपसा-आपसा कोया, “बेफीकुर आपना भाई क वारा मा गुनु छे, काहकी जोत्यार हुयु आपने सी गिड़गिड़ावीन विनती कोर्यु, ती वी आपनु यो देखीन, की हेरो जीवोन कोसो पिड़ा मा पोड़लो होसे, हेरी नी सोमळ्या; ओस कोरीन हामु वी हिमी इनी वेला मा पोड़ला छे।” ");
INSERT INTO dhn_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","रुबेन न हेरेसी कोयो, “काय हांव तुमरे सी नी कोयु होतु कि पुर्या क गुनावा मा बोनु? बाखुन तुमु नी सोमळ्या। देखु, हिमी तेरा लुहुय क बोदलु भुकती रोया।” ");
INSERT INTO dhn_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","युसुफ काजे आरु हेरी वात जी एक दुय बुलीन लारे होयती होती; इनासी हेनुक मालुलम नी हुयो कि हुयो हेन्दरी बुली सोमजे। ");
INSERT INTO dhn_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","ती हुयो हेनका धड़ सी छेटो होईन रड़ने लाग्यो; हेनका पास पोछु आवीन आरु हेन्दरे सि वात कोरीन हेन्दरे मा सी शिमोन क नेवाड़ीन आरु ओको ओगोळ बोन्दी बोनाय लेदु। ");
INSERT INTO dhn_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","ती युसुफ न हुकुम आप्यो, की हेन्दरा थोयला ओनो सी भोर देवु आरु एक एक जन क थोयला मा ओका रिपिया वि मेक देवु, ओळी हेन्दरे वाट्ये क लिय खानेन चीज आपु। एने: हेन्दरे पुठी ओसोत कोर्या। ");
INSERT INTO dhn_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","ती हुये आपसा ओनन थोयला आपसा गोदड़ा पोर मेलीन होंया सी चाल देदा। ");
INSERT INTO dhn_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","सराय मा जब एक न आपसा गोदड़ा क च्यारु आपने क लिय थोयलो उगाड़ियो, ती ओको रिपिया थोयला क मुयो पोर मेकलो हुतो देखा पोड़्यो। ");
INSERT INTO dhn_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","ती हुयो आपसा भाष्यो सी कोयो, “मारा रिपिया ते पोछा आप देदलो छे, देखु, हुयो मारा थोयला मा छे,” ती हेन्दरा जिवो मा जिव नी रोयु, आरु हुये एक दिसरा क आरु बिक सी ताकने लाग्या, आरु कोया, “परमेश्वर न यो आमरे सी काय कोरलु छे?” ");
INSERT INTO dhn_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","ती हुये कनान देश मा आपसा बाबा याकुब क पास आया, आरु आपसी आखी वात क ओस कोरीन कोया: ");
INSERT INTO dhn_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“जो मानुस हेना देश क स्वामी छे, हुयो आमुक घोनो वातड़ो क सात वात कोर्‌यो, आरु आमुक देश क भेदिया कोयो। ");
INSERT INTO dhn_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","ती हामु हेरेसी कोया, ‘हामु सुदा मानशे छे, भेदिया नी। ");
INSERT INTO dhn_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","हामु बारे भाईष एकुत बाबान पुर्या छे, एक ते जातु रोयु, बाखुन नानलु एने टेमे कनान देश मा आमरा बाबा क पास छे।’ ");
INSERT INTO dhn_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","ती होयु मानुसन, जो हेना देश क स्वामी छे, आमुक कोयु, एनासी मालुम होय जाय की तुमु सुदा मानसे होय; तुमु आपसा मा सी एक क मारे पास छुड़िन आपसा घोरवाळा क भुख मिटावने क लिय थुड़ोक ली जावु, ");
INSERT INTO dhn_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","आरु आपसा नानला भाई क मारे पास ली आवु। ती मेसे विश्वास होय जाय कि तुमु भेदिया नी, सुदा मानशे छे। ओळी हांव तुमरा भाईष क तुमुक आप दीस, आरु तुमु एना देश मा लेनो देनो कोर सोकसु।” ");
INSERT INTO dhn_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","यो कोहीन हुये आपसा-आपसा थोयला सी ओन निकाळने लाग्या, ती, काय देख्या, की एक एक जन क रिपिया क थोयली ओकाज थोयला मा मेकली छे। ती रुप्या क थोयलिया क देखीन हुये आरु हेन्दरो बाबा बेस बिह गोयु। ");
INSERT INTO dhn_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","ती हेन्दरो बाबो याकुब न हेनु सि कोयो, “मेसेक तुमु विगुर ओवलियाद नु कोर देदा, देखु, युसुफ नी रोयु, आरु शिमोन वी नी आयु, आरु हिमी तुमु बिन्यामीन क वी ली जाने हिय रोया। यी आखी पीड़ा मारे उपोर आय पोड़ली छे।” ");
INSERT INTO dhn_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","रुबेन आपसा बाबा सी कोयु, “काहमाईन हांव हेनाक तारे पास नी लावो, ती मारा दुयु पुर्या क मार देजी; तु ओको मारा हातो मा सोप दे, हांव हेनाक तारेन्चा ओळी पुगाड़ दिस।” ");
INSERT INTO dhn_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","हुयो कोयो, “मारु पुर्यु तुमरे पुठी नी जासे; काहकी हेरु भाईस मोर गोयलु छे, आरु हुयो एखलो हिमी रोय गोयलो छे: ओतरान कोरिन जेने वाट्ये सी तुमु जासु, हेरेमा काहमाईन हेरे पोर काई वि पीड़ा आवे, ती तुमरे कारण हांव इना डाहवारा क टेमे मा शोक क सात अधोलोक मा उतरी जाईस।” ");
INSERT INTO dhn_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","देश मा काव आरु वी बेस जोबोर होयतो गोयो। ");
INSERT INTO dhn_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","जव त्यो ओन जो हुये मिसर सी लि आया होता, सोर गोयो तो हेन्दरो बाबु न हेनुक कोयो, “ओळी जाईन आपने लिय थुड़ोक सो खानेन चीज मुले ली आवु।” ");
INSERT INTO dhn_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","ती यहुदा न हेनुसी कोयु, “हेयो मानुसन आमुक चेतावनी आपिन कोहलो, ‘काहमाईन तुमरो भाई तुमरे साते नी आवे, ती तुमु मारे ओगोळ नी आय पावसु।’ ");
INSERT INTO dhn_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","ओतरान कोरिन काहमाईन तु आमरा भाई क आमरे साते नी मुकले, ति ते हामु जाईन तारे जुगु खानेनचीज मुले ली आवसु; ");
INSERT INTO dhn_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","बाखुन काहमाईन तु हेनाक नी मुकले, ती आमु नी जाजे, काहकी हेना मानुसन आमरे सी कोयो, काहमाईन तुमरो भाईश तुमरे साते नी होय, ती तुमु मारे ओगोळ नी आय पावसु।” ");
INSERT INTO dhn_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","ती इस्राएल न कोयो, “तुमु हेना मानुसक यो कोया की आमरु एक आरु भाईष छे, काहा मारेसी भुण्डो बर्ताव कोर्यु?” ");
INSERT INTO dhn_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","हुयो कोयो, “जब हुयो मानुसन आमरी आरु आमरे कुटुम्बयो क स्थिति क वारा मा इने रिते पुछ्यो, ‘काय तुमरु बाबु हिमी लोगुन जिवतलु छे? काई तुमरु काई आरु भाईष वी छे?’ ती हामु इनु सोवालो क ओनसारे हुयो वर्णन कोर्यु; ओळी हामु काय जानता हुता कि हुयो कोहसे, आपसा भाई क याँ ली आवु।” ");
INSERT INTO dhn_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","ओळी यहुदा न आपसा बाबा इस्राएल सी कोयो, “हेन पुर्या क मारे पुठी मुकली देवु, की हामु जात रोहजे; एनासी हामु, आरु तु, आरु आमरा बाळ बोच्‌चा मोर नी पावसे, बाखुन जुवतला रोहसे। ");
INSERT INTO dhn_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","हांव हेरु जामनी होयो; मारात हातो सि तु पोछू लावजी। काहमाईन हांव ओको तारे पास पुगाड़ीन ओगोळ नि उबो कोर दोम, ती ते हांव होमीसा क लिय गुनावु कोवाईस। ");
INSERT INTO dhn_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","यदि हामु मानषो क वार नी कोरतु, ति हान्जु लोगुन दुय कावार पौछा आत रोहता।” ");
INSERT INTO dhn_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","ती हेन्दरु बाबु इस्राएल न हेनुक कोयु, “काहमाईन छाचीन ओसीत वात छे, ती यो कोरु; इना देश क वार वारु चीजो मासी काई काई आपना थोयला मा हेना मानुसक लिय भेंट ली जावु: जोसो थुड़ो सो डीग, आरु थुड़ो सो मधु, आरु काई गोंदायन्यो तेल, आरु गन्धरस, पिस्ते, आरु बादाम। ");
INSERT INTO dhn_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","ओळी आपना आपना सात दुना रिपिया ली जावु; आरु जे रुप्या तुमरा थोयला क मुयावा पोर मेकलो पोछो आप देदलो हुतो, तेनाक वी लेता जावु; काहमाईन यो विसरीन सी होयो होय। ");
INSERT INTO dhn_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","आपसा भाई क वी पुठी लीन हेना मानुसक पास ओळी जावु, ");
INSERT INTO dhn_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","आरु जुरभोर्यु परमेश्वर हेना मानुसक तुमरे पोर गिन कोरसे, जेरेसे कि हुयो तुमरा दिसरा भाई क आरु बिन्यामीन क वी आवने देय: आरु काहमाईन हांव वीगुर ओवलियाद न होयो ती हयने देवु।” ");
INSERT INTO dhn_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","ती हेना मानषो न होयी भेंट, आरु दुय गुना रिपिया, आरु बिन्यामीन क वी पुठी लिज्या, आरु चाल देदा आरु मिसर मा पुगीन युसुफ क ओगोळ उबा होया। ");
INSERT INTO dhn_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","हेन्दरे पुठी बिन्यामीन क देखीन युसुफ न आपसा घोर क आधिकारी सी कोयु, “हेनु मानषो क घोर मा पुगाड़ देवु, आरु पशु मारिन खानेन तियारी कोरु; काहकी हुये मानसे सिरान मारे साते खासे।” ");
INSERT INTO dhn_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","ती हुये आधिकारी मानुस युसुफ क कोहनेन ओनसारे हेनु मानषो क युसुफ क घोर मा लि गोया। ");
INSERT INTO dhn_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","जोत्यार हुये युसुफ क घोर मा पुगाड़ देदा ती हुये आपसात बिहता जाईन कोहने लाग्या, “जो रिपिया पेहली वार आपना थोयला मा पोछा आप देदला होता, हेरे जुगु आपनुक माहाय बुलावलो छे; जेरेसे कि हुयो मानुस आपने पोर टुट पोड़े, आरु हेरे होको मा कोरीन आपसा दास बोनावे, आरु आपना गोदड़ा क वी हापकी लेय।” ");
INSERT INTO dhn_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","ती हुये युसुफ घोर क आधिकारी क धोड़े जाईन घर क झपला पोर ओसा कोहने लाग्या, ");
INSERT INTO dhn_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","हे आमरा पोरबु, जोत्यार हामु पेहली कावा ओन मुले लेने आया हुता, ");
INSERT INTO dhn_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","ती हामु घर जानेन टेमे सराय मा पुगीन आमरा थोयला उगाड़्या, ती काय देख्या, की एक एक जन क पुरो पुरो रिपिया ओका थोयला क मुयावा पोर मेकला छे; एकालिय हामु ओको आपसा सात ओळी लिन आवला छे। ");
INSERT INTO dhn_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","आरु दिसरा पोस्या वी खानेन चीज मुले लेने क लिय लावला छे; हामु नी जानजे क आमरा पोस्या थोयला मा कुन मेक देदो हुतो। ");
INSERT INTO dhn_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","हुयो कोयो, “तुमरो वारलो होय, मा बिहयु: तुमरु परमेश्वर, जुळ तुमरु पिता क वी परमेश्वर छे, हुयोत तुमुक तुमरा थोयला मा धोन आप्यो होसे, तुमरा रुप्‌या ते मेसेक मिळी गोया हुता।” ओळी त्यो शिमोन क निकाळीन हेनका पुटी कोर देदो ");
INSERT INTO dhn_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","ती हेना जन न हेनु मानषो क युसुफ क घोर मा लि जाईन पानी आप्यु, ती हुये आपसा पायो क धुया; ओळी हुये हेन्दरा गोदड़ा च्यारु आप्यो। ");
INSERT INTO dhn_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","ती यो सोमळीन, की आज आमुक यात खानो छे, हुये युसुफ क आवने क टेमे लोगुन, यानी सिरान लोगुन, हेरे भेंट क एकठो तीयार कोरीन मेक्या। ");
INSERT INTO dhn_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","जोत्यार युसुफ घोर आयो ती तेनी भेंट क, जो हेन्दरा हातो मा होतो, ओका ओगोळ घोर मा ली गोया, आरु नेड़ा पोड़िन हेनाक वांदया। ");
INSERT INTO dhn_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","हुयो हेनुक हालचाल पुछ्यो आरु कोयो, काय तुमरु डुकरु बाबु, जेरी तुमु वात कोरला, वारलु छे की? काय होयु हांजु लोगुन जिवतलु छे? ");
INSERT INTO dhn_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","हुये कोया, “हाव तारु दास आमरु बाबु वारलु‌ छे आरु हिमि लोगुन जिवतलु छे।” ती हुये मुनको झुकाड़ीन ओळी वांद्या। ");
INSERT INTO dhn_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","ती हुयो डुळा उचाकोरीन आरु आपसा सोगा भाईष बिन्यामीन क देखीन पुछ्यो, “काय तुमरु यु नानलु भाईश, जेरी वात तुमु मार सी कोर्या हुता, यु छे?” ओळी हुयो कोयो, “हे मारा पुर्या, परमेश्वर तारे पोर गिन कोरे।” ");
INSERT INTO dhn_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","ती आपसा भाईष क मोंगो सी मोन भोर आवने क कारण आरु यो विचारीन कि हांव काँ जाईन रोड़ो, युसुफ तोत्यारुत आपसा कोपरा मा गोयु, आरु चाँ रोड़ पोड़्यु। ");
INSERT INTO dhn_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","ओळी आपसो मुय धुवीन निकोळी आरु, आरु आपसा क हुगु कोरीन कोयु, खानो निकावु। ");
INSERT INTO dhn_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","ती हुयो हेरे वाटू ओहोग, आरु भाष्यो वाटू वी ओलोग, आरु जे मिसरी हेरे साते खाता होता, हेन्दरे वाटू वी ओलोग, खानो निकाया; ओतरान कोरिन कि मिसरी इब्री क पुठी खानो नी खाय सोकतला, बाखुन मिसरी ओसो कोरनो घाड़ाय सोमझता हुता। ");
INSERT INTO dhn_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","ती युसुफ क भाई ओका ओगोळ, मोटा मोटा पेहेल, आरु नाना नाना पोछोल, आपसा-आपसा अवस्था क ओनसारे, वारी सी बोसाड़्या; यो देखीन हुये विस्मित होईन एक दिसरा भिनी भावने लाग्या। ");
INSERT INTO dhn_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","ती युसुफ आपसे ओगोळ सी खानेन चीजे चुटी चुटीन हेन्दरे पास ली मुकलने लाग्यु, आरु बिन्यामीन क आपसा भाष्यो सी पाँचगुना खानेनचीजे मिळी। आरु हुये ओका पुठी मन गोंहतो खादा पिदा। ");
INSERT INTO dhn_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","ती हुयो आपसा घोर क आधिकारी क हुकुम आप्यो की, “एनु मानषो क थोयला मा जोतरो खानेन चीजे सोमाये तोतरो भोर देवु, आरु एक एक जन रिपिया क ओका थोयला क मुयावा पोर मेल देवु। ");
INSERT INTO dhn_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","आरु मारो चाँदी क कोटोरो नानास थोयला क मुयावा पोर ओका ओन क रुप्या क सात मेक देवु।” युसुफ क इनी हुकुम क ओनसारे हुये कोर्या। ");
INSERT INTO dhn_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","सोंदारे वेगात होयतात हुये मानुस आपसा गोदड़ा भेळ चाल देदा। ");
INSERT INTO dhn_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","हुये नगर सी निकोळ्यात हुया, आरु नाम्बे वीनी गोया होता कि युसुफ न आपसा घोर क आधिकारी सी कोयु हेनु मानषो क पोछोळ पोड, आरु हेनुक हेरीन कोह कि, तुमु वारला क बोदला मा बुराय काहा कोर्या? काहा तुमु म्हारा स्वामी क वाटको चुर लेदा? ");
INSERT INTO dhn_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","काय यी ची चीजे नी जेरेमा मारु स्वामी पितलु‌ छे, आरु जिना हुयो सातायली वातोक कोरे? तुमु यो जु कोरला छे ते वारु नी कोर्या। ");
INSERT INTO dhn_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","ती हुयो हेनुक जाईन धोर्‌यो, आरु ओसीत वात हेन्दरे कोयु। ");
INSERT INTO dhn_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","हुये हेनासी कोया “हे मारा पोरबु, तु ओसी वात काहा कोवे छे? हामु वायदु कोरजे कि ओसो काम हामु नी कोरते। ");
INSERT INTO dhn_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","देख जे रुप्या आमरा थोयला क मुयावा पोर निकोळ्या हुता, जब आमु ओको कनान देश सी ली आवीन तुसे पोछो आप देदा, ती वारु, तारा स्वामी क घोर मा सी हामु काई चाँदी ने सोनो क चीजे कोसा चुराय सोकतला छे? ");
INSERT INTO dhn_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","तारा दास मा सी जेरे कुदा क पास हुयो निकोळे,‍ चो मार नाख्यो जाय, आरु हामु वी आपसा हेना स्वामीन दास होय जासु।” ");
INSERT INTO dhn_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","घोरोन होकदारीयो कोयो, “तुमरोत कोहनो खोरो, जेरे जुळ हुयो वाटको निकोळे चो मारो दास होयसे; आरु तुमु मानुस विनगुनाळा कोहायसु।” ");
INSERT INTO dhn_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","एर पोर हुये तावनी सी आपसा-आपसा थोयला उतारीन भीमा मेलीन थोयला उगाड़ने लाग्या। ");
INSERT INTO dhn_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","ती हुये हेरने लाग्या, आरु मोटला क थोयला सी लीन नानला क थोयला लोगुन हेर कोर्या: आरु कटोरा बिन्यामीन क थोयला मा मिळ्यो। ");
INSERT INTO dhn_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","ती हुये दुख मा आपसा-आपसा छिन्दरा फाड़्या आरु आपसा आपस गोदड़ा पोर मेलीन नगर क जात रोया। ");
INSERT INTO dhn_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","जोत्यार यहुदा आरु ओका भाई युसुफ क घर पुग्या, आरु युसुफ होयाँत हुयो, ती हुये हेरे ओगोळ भुमी पोर पोड़्या। ");
INSERT INTO dhn_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","युसुफ न हेनुसी कोयो, “तुमु मानसे न कोसो काम कोरला छे? काय तुमु नी जानता हुता की मार सी मानुस सातायली वातक जान सोकतलो?” ");
INSERT INTO dhn_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","यहुदा न कोयो, “आमु मानषो आपसा स्वामी सी काय कोहे? हामु काय कोहीन आपसा क निर्दोषी कोहो? परमेश्वर न तारा दास क ओधोरोम क धोरीन लेदला छे। हामु, आरु जेरे पास कटोरो निकोळ्यो हुयो वी, आमु आखा की आखा आमरा स्वामीन दासुत छे।” ");
INSERT INTO dhn_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","हुयो कयो, “ओसो कोरनो मारसे नांबे रोहे, जेरे मानुसक पास कटोरो निकोळ्लो छे, चोत मारो दास होयसे; आरु तुमु मानुस आपसा बाबा क पास वारु रिते जात रोहु।” ");
INSERT INTO dhn_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","ती यहुदा ओका पास जाईन कोहने लाग्यो, “हे मारा पोरबु, तारा दास को आपसा पोरबु सी कोहने को हुकुम होय, आरु तारी रिस तारा दास पोर नी भोड़के; काहकी तु ते फिरोन के जोसो छे। ");
INSERT INTO dhn_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","मारा पोरबु न आपसा दासो सी पुछ्‌यो हुयो, ‘काय तुमरु बाबु ने दिसरा भाईश छे?’ ");
INSERT INTO dhn_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","आरु हामु आपसा पोरबु सी कोया, ‘हाव, आमरु ढुकरु बाबु छे, आरु ओका डाहवारा क एक नानो सोव पुर्‌यो वी छे, वाखुन ओको भाई मोर गोयलो छे, ओतरान कोरिन हुयो हेमी आपसी आईस क एखलोत रोय गोयो, आरु ओको बाबो ओको मोंग राखतो छे।’ ");
INSERT INTO dhn_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","ती तु आपसा दासो सी कयो हुतो, ‘ओको मार पास ली आवु, जेरेसे हांव ओको देखो।’ ");
INSERT INTO dhn_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","ति हामु आपसा पोरबु सि कोया हुता, ‘हुयो पुर्‌यो आपसा बाबा क नी छुड़ सोकतो; नी ते हेरो बाबो मोर जासे।’ ");
INSERT INTO dhn_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","आरु तु आपसा दास सी कोयो, ‘काहमाईन तुमरु नानलु भाइस तुमरे पुठी नी आवे, ती तुमु मारे ओगोळ ओळी नी आय पावसु।’ ");
INSERT INTO dhn_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","ओतरान कोरिन जब हामु आमरा बाबा तारा दास क पास गोया, ती हामु हेरेसी आपसा पोरबु कि वाते कोया। ");
INSERT INTO dhn_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","ती आमरु बाबु न कोयु, ‘ओळी जाईन आपने जुगु थुड़ो सो खानेन चिज मुले ली आवु।’ ");
INSERT INTO dhn_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","हामु कोया, ‘हामु नु जाय सोकतला, हाव, काहमाईन आमरु नानलु भाईस आमरे पुठी रोहे, ती हामु जासु; काहली काहमाईन आमरु नानलु भाईस आमरे पुठी नी रोहे, ती हामु हेना मानुसक ओगोळ नी जाय पावसु।’ ");
INSERT INTO dhn_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","ती तारा दास मारा बाबा न हामु सी कोयो, ‘तुम ते जानु होय की राहेल सि दुय पुर्या पोयदा हुया। ");
INSERT INTO dhn_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","आरु हेना सी एक ते मेसेक छुड़ित गोयो, आरु हांव छाचिन कोर लेदु, की हुयो फाड़ देदु गोयु होसे; आरु ती सी हांव हेरो मुय नी देख पायु। ");
INSERT INTO dhn_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","एने: काहमाईन तुमु ओको वी मारा डुळा क आड़ मा ली जावु, आरु काई वेला एर पोर पोड़े, ती तुमरे कारण हांव एना डाहवारा क टेमे मा शोक क सात अधोलोक मा उतरी जाईस।’ ");
INSERT INTO dhn_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","ओतरान कोरिन जब हांव आपसा बाबा तारा दास क पास पुगजे, आरु यो पुर्‌यो पुठी नी रोहे, ती, ओको जीव जो एरे पोर ओटेलो रोहे छे, ");
INSERT INTO dhn_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","ओस कोरीन, यो देखीन की पुर्‌यो नी छे, हुयो तोत्यारुत मोर जासे। ती तारा दास क कारण तारा दास आमरो बाबो, जो डाहवारा क टेमे मा छे, शोक क सात अधोलोक मा उतरी जासे। ");
INSERT INTO dhn_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","ओळी तारो दास आपसा बाबा क याँ यो कोहीन एना पुर्या क जामनी हुयो छे, ‘काहमाईन हांव एना तारा पास नी पुगाड़ दोम, ती ते हांव होमीसा क लिय तारु गुनावु कोवाईस।’ ");
INSERT INTO dhn_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","एकालिय हिमी तारा दास एना पुर्या क बोदले आपसा पोरबु क दास होईन रोहने क हुकुम पावे, आरु एना पुर्या आपसा भाईस क पुठी जाने दे। ");
INSERT INTO dhn_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","काहकी पुर्या क विगुर पुठी रोहे हांव कोसु आपसा बाबा क पास जाय सोकीस; ओसो नी होये की मारा बाबा पोर जुळ दुख पोड़से चो मेसे देखने पोड़े।” ");
INSERT INTO dhn_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","ती युसुफ हेनु सब क ओगोळ, जे हेरे आड़े धोड़े उबला होता, आपसा क आरु रुक नी सोक्यो; आरु आयड़ीन कोयो, “मारा आड़े धोड़े सी सब मानषो क खोयड़े कोर देवु।” भाष्यो क ओगोळ आपसा क प्रगट कोरने क टेमे युसुफ क सात आरु कोय नी रोयो। ");
INSERT INTO dhn_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","ती हुयो जुरेत रोड़ने लाग्यो; आरु मिसरि मानुस सोमळ्या, आरु फिरोन क घोर क मानषो क वी एरी खोबोर मिळी। ");
INSERT INTO dhn_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","ती युसुफ आपसा भाष्यो सी कोहने लाग्यु, “हांव युसुफ छे, काय मारु बाबु हाँजु लोग जिवतलु छे?” एरो जोपाप हेरा भाई नी आप सोक्या; काहकी हुये घाबराय गुया होता। ");
INSERT INTO dhn_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","ओळी युसुफ न आपसा भाष्यो सी कोयो, “मारे धोड़े आवु।” यो सोमळीन हुये धोड़े गोया। ओळी हुये कोया, “हांव तुमरु भाईस युसुफ छे, जेनाक तुमु मिसर आवनेवाळा वेपारीन हात वेच देदाला। (प्रेरि. 7:9) ");
INSERT INTO dhn_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","हिमी तुमु मानुस मा पोछतायु, आरु तुमु जो मेसे याँ वेच देदा, एरेसे उदास मा होयु; काहकी परमेश्वर न तुमरा जीवोक वाचाड़ने क लिय मेसे तुमरे ओगोळ मुकोल देदलो छे (प्रेरि. 7:15) ");
INSERT INTO dhn_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","काहकी हिमी दुय साल सी एना देश मा काव छे; आरु हिमी पाच साल आरु ओसोत होयसे कि हेरेमा नी ते होळ चालसे आरु नी धान काटयसे। (प्रेरि. 7:15) ");
INSERT INTO dhn_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","ओतरान कोरिन परमेश्वर न मेसे तुमसे ओगोळ एकाजलिय मुकेलो की तुमु कोळी पोर जिवतला रोहु, आरु तुमरा जिवो क वाचड़ने सी तुमरो ओवलियाद वोदे। ");
INSERT INTO dhn_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","इने रिते हिमी मेसेक याँ सारतीक मुकलन्या तुमु नी, परमेश्वर कोहायसे; आरु हुयोत मेसे फिरोन क बाबा सारको, आरु आखा मिसर देश क पोरबु बोनाय देदलु छे। ");
INSERT INTO dhn_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","एने: तावनी सी मारा बाबा क पास जाईन कोहु, तारु पुर्यु युसुफ ओस कोरीन कोहे छे, के परमेश्वर न मेसे आखा मिसर क स्वामी बोनायो छे; ओतरान कोरिन तु मारा पास विगु वार लागाड़्ये चाली आव। (प्रेरि. 7:14) ");
INSERT INTO dhn_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","आरु तारा निवास गोशेन देश मा होयसे, आरु तु, पुर्या, पोता, गाडरा बुकड़ा, गाय बुईल, आरु आपसो आखो काई भेळ मेसे धोड़े रोहसे। ");
INSERT INTO dhn_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","आरु काव क जे पाच साल आरु होयसे, हेरेमा हांव होयाँत पालन पोषण कोरीस; ओसो नी हय की तु, आरु तारो घोराना, वरन् जोतरा तारा छे, चे भुकला मोरे (प्रेरि. 7:14) ");
INSERT INTO dhn_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","आरु तुमु आपसा डुळा सी देख रोया, आरु मारा भाईष बिन्यामीन वी आपसा डुऴा सी देखतो छे की जो आमरे सी वात कर रोया छे चो युसुफ छे। ");
INSERT INTO dhn_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","तुमु मारा सब ठाट बाट, को मिसर मा छे आरु जो काई तुमु न देख्यो छे, हेनु सब क मारा बाबा सी वात कोरजु; आरु तुरन्त मारा बाबाक याँ लीन आवु।” ");
INSERT INTO dhn_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","आरु हुयो आपसा भाई बिन्यामीन क गोळे सी लिपटाईन रोड़्यु; आरु बिन्यामीन वी ओको गळे सि लिपटाईन रोड़्यु। ");
INSERT INTO dhn_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","हुयो आपसा सब भाई क चुमीन रोड्यु आरु एरे वाद ओका भाई हेरेसी वात कोरने लागे। ");
INSERT INTO dhn_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","एनी वात क खोबोर क युसुफ क भाई आवला छे, फिरोन क भवन लोगुन पुग गोय, आरु एरेसे फिरोन हेरा कामकोरन्या घोना खुश होय गया (प्रेरि. 7:13) ");
INSERT INTO dhn_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","ओतरान कोरिन फिरोन न युसुफ सि कोयो, “आपसा भाष्यो सी कोह की एक काम कोरु; आपसा ढुरो क लादीन कनान देश मा जात रोहु। ");
INSERT INTO dhn_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","आरु आपसा बाबा आरु आपसा-आपसा घोर क मानशो क लिन मारे पास आवु; आरु मिसर देश मा जो काई वारु सी वारु छे चो मे तुमुक आपीस, आरु तुमरा देश क वारु सी वारी खानो खाने क मिळ्से। (प्रेरि. 7:14) ");
INSERT INTO dhn_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","आरु तुसे हुकुम मिळी चे, तुमु एक काम कोरु कि मिसर देश सी आपसा बाळ बोच्‌चा आरु बायरा क लिय गाड़ीया ली जावु, आरु आपसा बाबा क ली आवु। (प्रेरि 7:14) ");
INSERT INTO dhn_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","आरु आपसो सोमान क फिकुन झुण कोरता; काहकी आखा मिसर देश मा जो काई वारु सि वारु छे चो तुमरो छे” ");
INSERT INTO dhn_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","इस्राएल क पुर्या न ओसोत कोर्या; आरु युसुफ न फिरोन क हुकुम क ओनसारे हेनुक गाड़ीया आप देदु, आरु वाट्ये क लिय खानेन चिजे वी आप्यु। ");
INSERT INTO dhn_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","हेरेमा सी एक एक जोना क ते हुयो एक एक जुड़ी छिन्दरा वी आप्यो; आरु बिन्यामीन क तीन सोव चाँदीन सिक्का आरु पाच जुड़ी छिन्दरा आप्यो। ");
INSERT INTO dhn_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","आपसा बाबा क पास हुयो जु ली मुकेल्लो चो यो छे, यानी मिसर क वारु चीजे सि भोरीन दोस गोदड़ा, आरु ओन आरु रुटा आरु हेरे बाबा क वाट्ये क लिय खानेन चीजे सी भोरीन दोस गोदडी। ");
INSERT INTO dhn_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","ती हुये आपसा भाष्यो क मुकल्यो, आरु हुये चाल देदा; आरु हुये हेनाक कोया, “वाट्ये काँखेर झुणी लोड़ायता।” ");
INSERT INTO dhn_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","मिसर सी चालिन हुये कनान देश मा आपसा बाबा याकुब क पास पुग्या। ");
INSERT INTO dhn_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","आरु हेरेसे यी आखी वात कोर्या, “युसुफ हाँजु लोगुन जिवतलु छे, आरु आखा मिसर देश पोर राज हुयोत कोरे छे।” बाखुन हुयो हेन्दरे पोर विश्वास नी कोर्‌यो, आरु हुयो सन्न रोय गुयो। ");
INSERT INTO dhn_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","ती हुयो आपसा बाबा याकुब सी युसुफ क आखी वाते, जी हुयो हेनाक कोहने कोहलु, कोय देद; जब हुयो हेनी गाड़ीया क देख्यो, जो युसुफ न हेनाक ली आवने क लिय मुकेललो होती, ती ओका मनक शांती मिळी। ");
INSERT INTO dhn_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","आरु इस्राएल न कोयो “बस, मारु पुर्यु युसुफ हिमी वी जिवतलु छे; हांव मारे मोरने सी पेहेल जाईन हेनाक देख लिस।” ");
INSERT INTO dhn_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","ती इस्राएल आपसो आखो काई लीन बेरसेबा क गोयो, आरु होंया आपसा बाबा इसहाक क परमेश्वर क बलिदान चोड़ायो। ");
INSERT INTO dhn_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","ती परमेश्वर न इस्राएल दी रात क दर्शन मा कोयो, “हे याकुब हे याकुब।” हुयो कोयो, “काय हुकुम।” ");
INSERT INTO dhn_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","हुयो कोयो, “हांव परमेश्वर तारा बाबा क परमेश्वर छे, तु मिसर मा जाने सी मा बिहये; काहकी हांव तार सी होंयाँ एक मोटी जाति बोनावीस। ");
INSERT INTO dhn_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","हांव तारे पुठी पुठी मिसर क चालता छे; आरु हांव तुसे होंयाँ सी ओळी ली आवीस; आरु युसुफ आपसा हातो सी तारा डुळा क बोन्द कोरसे।” ");
INSERT INTO dhn_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","ती याकुब बेरसेबा सि चाल्यो; आरु इस्राएल क पुर्या आपसा बाबा याकुब, आरु आपसा बाळ बोच्‌चा, आरु बायरा क हेनु गाड़ीया पर, जे फिरोन न हेन्दरे जुगु ली मुकोल लो हुतो, चोड़ावीन चाल देदा। ");
INSERT INTO dhn_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","याकुब आपसा गाडरा बुकड़ा, गाय बुईल, आरु कनान देश मा आपस एकठो कोरला आखा धन क लिन मिसर मा आया। ");
INSERT INTO dhn_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","आरु याकुब आपसा बेटा बेटिया, आरु पोता पोती, यानी आपसी ओवलियाद भोरीन आपसे पुठी मिसर मा लि आयो। ");
INSERT INTO dhn_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","याकुब क सात मा जे इसराएली, यानी हेरा पुर्या, पोता, आदि मिसर मा आया, हेन्दरा नाव ये छे याकुब क मोटलो रुबेन हुतो। ");
INSERT INTO dhn_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","आरु रुबेन क पुर्य हनोक, पल्लु, हेस्रोन, आरु कर्म्मी हुता। ");
INSERT INTO dhn_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","शिमोन क पुर्या, यमुएल, यामीन, ओहद, याकीन, सोहर, आरु एक कनानी बायोर सी जोनम्यो शाऊल वी हुतो। ");
INSERT INTO dhn_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","लेवी क पुर्या गेर्शोन, कहात, आरु मरारी हुता। ");
INSERT INTO dhn_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","यहुदा क एर, ओनान, शेला, पेरेस, आरु जेरह नावोन पुर्यु होयु होतु; बाखुन एर आरु ओनान कनान देश मा मोर गोया हुता; आरु पेरेस क पुर्य, हेस्रोन आरु हामुल हुता। ");
INSERT INTO dhn_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","इस्साकार क पुर्या, तोला, पुव्वा, योब, आरु शिम्रोन हुता। ");
INSERT INTO dhn_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","जबुलुन क पुर्या, सेरेद, एलोन, आरु यहलेल हुता। ");
INSERT INTO dhn_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","लिआ क पुर्या जे याकुब सी पद्दनराम मा पोयदा होया हुता, ओका पुर्या पोता येत होता, आरु एरे सी सोटा ओको ओकाज सात एक बेटी दीना क वी जन्म दिदो, याँ लोगुन ते याकुब क आखा ओवलियाद डेड़ वीस ने तीन मानसे हुया। ");
INSERT INTO dhn_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","ओळी गाद क पुर्या, सपोन, हाग्गी, शुनी, एसबोन, एरी, अरोदी, आरु अरेली हुता। ");
INSERT INTO dhn_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","आशेर क पुर्या, यिम्ना, यिश्वा, यिश्वी, आरु बरिआ हुता, आरु ओकी बहीन सेरह हुती; आरु बरिआ क पुर्या, हेबेर आरु मल्कीएल हुतो। ");
INSERT INTO dhn_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","जिल्पा, जेनिक लाबान न आपसी पुराय लिआ क आप्यो हुतो, ओका पुर्या पारी आदी येत हुता; आरु ओका द्वारा याकुब क सुव्वे जिवे पोयदा हुया। ");
INSERT INTO dhn_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","ओळी याकुब क घोरवाळी राहेल क पुर्य युसुफ आरु बिन्यामीन हुया। ");
INSERT INTO dhn_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","आरु मिसर देश मा ओन क याजक पोतीपेरा क पुराय आसनत सी युसुफ क ये पुर्या पोयदा हुया, याणी मनश्शे आरु एपरेम। ");
INSERT INTO dhn_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","बिन्यामीन क पुर्या, बेला, बेकेर, अश्बेल, गेरा, नामान, एही, रोश, मुप्पीम, हुप्पीम, आरु अर्द हुता। ");
INSERT INTO dhn_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","राहेल क पुर्या जे याकुब सी पोयदा हुया ओका येत पुर्या हुया; ओका सब पुर्या पारी चोवदे जिवे हुया। ");
INSERT INTO dhn_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","ओळी दान क पुर्य हुशीम हुतो। ");
INSERT INTO dhn_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","नप्ताली क पुर्याम यहसेल, गुनी, सेसेर, आरु शिल्लेम हुता। ");
INSERT INTO dhn_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","बिल्हा, जेनाकक लाबान न आपसी पुराय राहेल क आप्यो हुतो, ओका पुर्या पारी येत हुता; ओका द्वारा याकुब क ओवलियाद मा सात जिवे हुया। ");
INSERT INTO dhn_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","याकुब क निज ओवलियाद क जे जिवे मिसर आ आया, चे ओका उहड़ीसा क छुड़ीन सब मेळीन छियासठ जिवे हुया। ");
INSERT INTO dhn_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","आरु युसुफ क पुर्या, जे मिसर मा हेरेसे पोयदा हुया, चे दुय जोना हुता; ओस कोरीन याकुब क घोराना क जे मानुस मिसर मा आया हुता चे आखा मिळीन सत्तर हुया। ");
INSERT INTO dhn_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","ओळी हुयो यहुदा क आपसे ओगोळ युसुफ क पास मुकली देदो कि हुयो ओको गोशेन क वाट देखाड़्या; आरु गोशेन देश मा आयो। ");
INSERT INTO dhn_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","ती युसुफ आपसी घुड़ागाड़ी जुपाड़ीन आपसा बाबा इस्राएल सि मीळने कोरिन गोशेन देश क गोयो, आरु हेरेसे मिळने कोरीन हेरे गोळे सी लिपटाय गोया, आरु काईन वार लोगुन ओका गोळा सी लिपटाईन रोड़ता रोया। ");
INSERT INTO dhn_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","ती इस्राएल न युसुफ सी कोयो, “हांव हिमी मोरने सी वी खुश छे, काहकी तुसे जिवतलु देख्यु आरु तारो मुय देख लेदु।” ");
INSERT INTO dhn_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","ती युसुफ न आपसा भाई सी आरु आपसा बाबा क घोराना सी कोयो, “मे जाईन फिरोन क यो खोबोर आपीस, ‘मारा भाईस आरु मारा बाबा क आखो घोराना क मानषे, जे कनान देश मा रोहता हुता, चे मारे पास आय गोयला छे; ");
INSERT INTO dhn_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","आरु हुये मानुस गुवाळ्या छे, काहकी हुये ढुरोक पाळता आवला छे; ओतरान कोरिन हुये आपसा गाडरा बुकड़ा, गाय बुईल, आरु जो काई ओको छे, आखो ली आवला छे।’ ");
INSERT INTO dhn_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","जब फिरोन तुमुक बुलावीन पुछे, ‘तुमरो उद्यम काय छे?’ ");
INSERT INTO dhn_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ती यो कोहजु, ‘तारा दास लड़कपन सी लीन आज लोगुन ढुरो क पाळता आया छे, बाखुन आमरा डाहडा वी ओसात कोरता हुता।’ इनासी तुमु गोशेन देश मा रोहने पावसु; काहकी सब गुवाळ्या सी मिसरि मानुस घाड़ाय कोरतला छे।” ");
INSERT INTO dhn_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","ती युसुफ न फिरोन क पास जाईन यो खोबोर आप्या, “मारु बाबु आरु मारा भाईष, आरु ओका गाडरा बुकड़ा, गाय बुईल आरु जो काई ओकोज छे, आखो कनान देश सी आय गोयला छे; आरु हेमी ते चे गोशेन देश मा छे।” ");
INSERT INTO dhn_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","ओळी हुये आपसा भाई मा सी पाच जोन लिन फिरोन क ओगोळ उबो कोर देदा। ");
INSERT INTO dhn_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","फिरोन न ओका भाइश सी पुछ्यो, “तुमरो उद्यम काय छे?” हुये फिरोन सी कोया, “तारा दास गुवाळ्या छे, आरु आमरा डाहडा वी ओसात रोया।” ");
INSERT INTO dhn_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","ओळी हुये फिरोन सि कोयो, “आमु इना देश मा पारका जोसा रोहने क लिय आवला छे; काहकी कनान देश मा भारी काव छे कोरीन तारा दास क गाडरा बुकड़ा क लिय च्यारु नी रोयो; ओतरान कोरिन आपसा दास क गोशेन देश मा रोहने क हुकुम आप्यो।” ");
INSERT INTO dhn_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","ति फिरोन न युसुफ सि कोयो, “तारा बाबा आरु तारा भाईश तारा पास आय गोयला छे, ");
INSERT INTO dhn_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","आरु मिसर देश तारे ओगोळ पोड़लो छे; एना देश क जो आखा रोईन वारु भाग होय, हेरेमा आपसा बाबा आरु भाइश्यो क वोसाड़ दे; यानी चे गोशेन देश मात रोहे; आरु काहमाईन तु जानतु होय, की हेरेमा सी मेहनोती मानुस छे, ती हुये मारा ढुरो क मुखी बोनाय दे।” ");
INSERT INTO dhn_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","ती युसुफ न आपसा बाबा याकुब क ली आवीन फिरोन क ओगोळ उबो कोर्‌यो; आरु याकुब न फिरोन क बोरकोत आप्या। ");
INSERT INTO dhn_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","ती फिरोन न याकुब सी पुछ्यो, “तारी उमोर कोतरा दाहड़ान होयली छे?” ");
INSERT INTO dhn_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","याकुब न फिरोन सी कोयो, “हांव ते एक सोव तीस साल पारका होईन आपसो जीवन विताड़ चुकलो छे; मारा जीवन क दाहड़ा थुड़ा आरु दुख सी भोरायला वी होयला हुता, आरु मारा डाहडा पारका होईन जोतरा दाहड़ा लोगुन जिवतला रोया तोतर दाहड़ा क म्हारा हिमि नी होयो।” ");
INSERT INTO dhn_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","आरु याकुब फिरोन क बोरकोत आपीन ओका ओगोळ सी जात रोयो। ");
INSERT INTO dhn_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","ती युसुफ न आपसा बाबा आरु भाश्यो क बसाड़ देदो, आरु फिरोन क हुकुम क ओनसारे मिसर देश क वारु सी वारु वाटा मा, यानी रामसेस नावोन प्रदेश मा, जागु आपीन ओको सोप देदा। ");
INSERT INTO dhn_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","आरु युसुफ आपसा बाबा क, आरु आपसा भाष्यो क आरु बाबा क आखा घोराना क, एक एक क बाळ पुर्या क गिनती क ओनसारे, ओन आपीन ओको पाळन पोषण कोरने लाग्या। ");
INSERT INTO dhn_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","हेना आखा देश मा खाने क काई नी रोहो; काहकी काव घोने जोबोर हुतो, आरु काव क कारन मिसर आरु कनान दुयु देश नाश होय गोया। ");
INSERT INTO dhn_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","आरु जोत्रा रुप्या मिसर आरु कनान देश मा हुतो, सब क युसुफ न हेना ओन क बोदले, जो हेरा निवासी मुले लेता हुता एकठा कोरीन फिरोन क घोर मा पुगाड़ देदा। ");
INSERT INTO dhn_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","जब मिसर आरु कनान देश क रिपिया सोर गोया, ती सब मिसरी युसुफ क पास आव आवीन कोहने लाग्या, “आमुक खानेन चीजे आपे, काय हामु रुप्या क नी रोहने सी तारे रोहते होय मोर जाजे?” ");
INSERT INTO dhn_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","युसुफ न कोयो, “काहमाईन रिपिया न होय ते आपना ढुरोक आप दे, आरु हांव ओका बोदले तुमुक खाने क आपीस।” ");
INSERT INTO dhn_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","ती हुये आपसा ढुरे युसुफ क पास लि आया; आरु युसुफ ओका घुल्‌ला, गाडरा बुकड़ा, गाउ बुईल आरु गोदड़ा क बोदले खाने क आपने लाग्यो: हेना साल मा हुये सब जाती क ढुरो क बोदले खाने आपीन ओको पाळोन पोषन कोरता रोया। ");
INSERT INTO dhn_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","हुये साल ते यो काट देदा; ती ओगले साल मा हुये ओका पास आवीन कोया, “हामु आपसा पोरबु सी यो वात साताड़ नी राख्से के आमरा रिपिया सोर गोया छे, आरु आमरे सब भातीन क ढुरे आमरा पोरबु क ओगोळ आमरा डील आरु जागु‌ छुड़ीन आरु काय नी रोयो। ");
INSERT INTO dhn_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","हामु तारे देखतेत काहा मोरे, आरु आमरी जागा काहा उजाड़ जाजे? आमुक आरु आमरी जागा क खानेन चीजे क बोदले मुले लेजे, कि हामु आपस जागा भेळ फिरोन क दास होय आरु आमुक बिज आपे, कि हामु मोरजे नी, बाखुन जिवतला रोया, आरु जागु नी उजड़े।” ");
INSERT INTO dhn_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","ती युसुफ न मिसर क आखी जागा क फिरोन क लिय मुले लेदा; काहकी हेना घोना काव क पोड़ने सि मिसरीक आपनो आपनो खेत वोचनो पोड़्यो। ओस कोरीन आखी जागा फिरोन क होय गोय। ");
INSERT INTO dhn_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","आरु एक धोड़े सी लीन दिसरे धोड़े लोगुन आखा मिसर देश मा जे मानसे रोहता हुता, ओका हुये नगर मा लावीन बोस गोया। ");
INSERT INTO dhn_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","बाखुन याजक क जागा ते हुये मुले नी लेदो; काहकी याजक क लिय फिरोन क भीनी सी नित्य खानो क बंदोबस्त हुतो, आरु नित्य जो खानो फिरोन हेनुक आपता हुता हुये चेत खाता हुता; ओस कोरीन हेनुक आपसु जागु वेचनो नी पोड़्यो। ");
INSERT INTO dhn_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","ती युसुफ न प्रजा क मानषो सी कोयो, “सोमवु, मे आज क दाहड़े तुमुक आरु तुमरी जागा क वी फिरोन क लिय मुले लेदलो छे; देखु, तुमरे जुगु याँ बिज छे, इनाक धोरती मा वेरु। ");
INSERT INTO dhn_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","आरु जो काई उगे पांचवो वाटो फिरोन क आपनो, बाकी चार अंश तुमरा रोहसे कि तुमु हेनाक आपना खेतो मा वेरे, आरु आप आपसा बाळ पुर्या आरु घोर क दिसरा मानसे खाया कोरे।” ");
INSERT INTO dhn_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","हुये कोया, “तु आमुक वाचाड़लु छे; आमरा पोरबु क गीन क निगाह आमरे पोर बोनली रोहे, आरु हामु फिरोन क दास होईन रोहसे।” ");
INSERT INTO dhn_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","ओस कोरीन युसुफ न मिसर क जागा क वारा मा ओसो कायदो कोहायसे, जो आज क दाहड़े लोगुन चाली आयो छे कि पंचमांश फिरोन क मिळ्या कोरे; केवल याजकोत क जागा फिरोन क नी होये। ");
INSERT INTO dhn_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","इसराएली मिसर क गोशेन प्रदेश मा रोहने लाग्या; आरु होंया क जागा क जागाम हेरे होको मा हुतो, आरु फुले फले, आरु घोना वोदे। ");
INSERT INTO dhn_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","मिसर देश मा याकुब सतरह साल जुवतलो रोयो ओस कोरीन याकुब क आखी उमोर एक सोव पाच कोम पोचा साल क हुया। ");
INSERT INTO dhn_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","जब इस्राएल क मोरने क दाहड़ा आय गोया, ती हुये आपसा पुर्या युसुफ क बुलावीन कोयो, “काहमाईन तारो गीन मार पोर होय, ते आपसो हात मारी जाँघ क तळे मेकीन वायदु खा, की तु मारे साते गिन आरु छाचाय क यो काम कोरसे, कि मेसे मिसर मा धुळु नी आपीस। ");
INSERT INTO dhn_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","जब हांव आपसा बाप दादा क पुठी सुय जाईस, ती तु मेसे मिसर से उठाविन जाईन तेना बिड़ा मा मेकीस।” ती युसुफ न कोयो, “हांव तारा बुलो के ओनसारे कोरीस।” ");
INSERT INTO dhn_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","ओळी हुयो कोयो, “मार सी वायदु खा।” एने: हुये हेनासी वायदु खादो, ती इस्राएल न खाटला क मुन्डास्या भिनी मुनको नेचो कोरीन विनता कोर्‌यो। (इब्रा 11:21) ");
INSERT INTO dhn_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","एनी वात क वाद कुदु युसुफ सी कोयो, “सोमोळ, तारु बाबु मान्दलु छे।” ती हुयो मनश्शे आरु एपरेम नावोन आपसा दुयु पुर्या क पुठी लिन ओका पास चाल्या। ");
INSERT INTO dhn_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","कुदु याकुब क कोय देदो, “तारु पुर्यु युसुफ तारे पास आवने बाज रोयु,” ती याकुब आपसा क सोमाळीन खाटला पोर बोर गोयु। ");
INSERT INTO dhn_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","आरु याकुब न युसुफ सी कोयो, “जुरभोर्यु परमेश्वर न कनान देश क लुज नगर क पास मेसे दर्शन आपीन बोरकोत आप्यो, ");
INSERT INTO dhn_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","आरु कोयो, ‘सोमोळ, हांव तुसे फलवन्त कोरीन वोदाड़ीस, आरु तुसे राज राजन मण्डळी क मुल बोनावीस, आरु तारा ओवलियाद क यो देश आपीस, जेनासी की हुयो होमीसा लोगुन ओका वावड़्या जागु बोनलु रोहे।’ ");
INSERT INTO dhn_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","आरु हिमी तारा पुर्या, जे मिसर मा मारे आवने सी पेहेल पोयला छे, चे मारात कोहायसे; यानी जेने रीते सी रुबेन आरु शिमोन मारा छे, हेने रीते एपरेम आरु मनश्‍शे वी मारा कोहायसे। ");
INSERT INTO dhn_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","आरु ओका वाद तारी जी ओवलियाद होये, चे तारात कोहायसे; बाखुन वाटान टेमे हुये आपसा भाष्यो त क ओवलियाद मा गिन्या जासे। ");
INSERT INTO dhn_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","जोत्यार हांव पद्दान सि आवता हुता, ती एप्रात पुगने सी थुड़ेत नांबे पेहेल राहेल कनान देश मा, वाट्ये मा, मारे ओगोळ मोर गोय; आरु हांव हेनीक होयाँत, यानी एप्रात ज बैतलहम वी कोहाये छे, ओकाज वाट मा धुळु आप्यु।” ");
INSERT INTO dhn_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","ती इस्राएल क युसुफ क पुर्या देखा पोड़्या, आरु हुये पुछने लाग्यो, “यो कुण छे?” ");
INSERT INTO dhn_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","युसुफ न आपसा बाबा सी कोयो, “ये मारा पुर्या छे, जे परमेश्वर न मेसे याँ आपलो छे।” हुयो कोयो, “हेनुक मारे पास ली आवु की हांव हेनुक बोरकोत आपो।” ");
INSERT INTO dhn_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","इस्राएल क डुळ डाहवारा क कारन धुन्दला होय गोया हुता, याँ लोगुन की हेनाक कोम सुझतो हुतो। ती युसुफ हेनुक हेरे पास ली गोयु; आरु हुयो हेनुक गुळा दिन गोळे लागाड़ लेदु। ");
INSERT INTO dhn_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","ती इस्राएल न युसुफ सी कोयो, “मारो विचार नी होतो, कि हांव तारो मुख ओळी देखने पावीस: बाखुन देख, परमेश्वर न मेसे तारा ओवलियाद वी देखाड़्यो छे।” ");
INSERT INTO dhn_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","ती युसुफ न हेनाक आपसा मान्डा क विच से छेटा कोरीन आरु धोरती भैनी नेड़ु भावीन वान्द्यु। ");
INSERT INTO dhn_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","ती युसुफ न हेनुक दुयोक लिन, यानी एपरेम क आपसा जेवड़्या हात सी, कि हुयो इस्राएल क डाख्र्या हात पोड़े, आरु मनश्शे क आपसो डाख्र्‌यो हात सी, कि इस्राएल क जेवड़्यो हात पोड़े, हेनुक ओका पास ली गोयो। ");
INSERT INTO dhn_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","ती इस्राएल न आपसो जेवड़्यो हात ओगु कोरीन एपरेम क मुनका पोर जु नानलु होतु, आरु आपसु डाख्र्यु हात ओगु कोरिन मनश्शे क मुनका पोर नेक देदु; हुयो ते जान बुजीन ओसो कोर्‌यो; नी ते मोटलो पुर्‌यो मनश्शे त हुतो। ");
INSERT INTO dhn_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","ओळी हुयो युसुफ क बोरकोत आपिन कोयो, परमेश्वर जेरे ओगोळ मारा डाहडा अब्राहम आरु इसहाक चालता हुता चोत परमेश्वर मारी पोयदा वारी सी लिन आज क दाहड़े तक मारु गुवाळ्यु बोनलु छे (इब्रा. 11:21) ");
INSERT INTO dhn_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","आरु हुये दुत मेसे आखी बुराय सी छुड़ावता आवला छे; हुये इनु पुर्या क बोरकोत आपे; आरु ये मारा आरु मारा डाहडा अब्राहम आरु इसहाक क कोहायसे; आरु कोळी मा वारु रिते वोदे (इब्रा. 11:21) ");
INSERT INTO dhn_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","जोत्यार युसुफ न देख्यो कि मारा बाबा न आपसो जेवड़्यो हात एपरेम क मुनका पोर छे, ती यी वात ओको भुण्डी लागी; ओतरान कोरिन हुयो आपसा बाबा क हात एनी मोनसा सी धोर लेदो, कि एपरेम क मुनका पोर सी चुटीन मनश्शे क मुनका पर मेल दे। ");
INSERT INTO dhn_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","आरु युसुफ न आपसा बाबा सी कोयो, “हे बाबा, ओसो नी; काहकी मोटलो यो छे; आपसु जेवड़्यु हात एरा मुनका पोर मेल।” ");
INSERT INTO dhn_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","हेरु बाबु कोयु, “नी, सोमोळ, हे मारा बेटा, हांव इनी वात क वारु रीते जानो बाखुन एनासी वी मानषो क एक मन्डळी पोयदा होयसे, आरु यो वी मोटो होय जासे, ते वी एरो नानलो भाई एरेसे जादा मोटो होय जासे, आरु ओका ओवलियाद सी बेस सी जातिया निकोळसे।” ");
INSERT INTO dhn_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","ओळी हुयो हेने दाहड़े यो काहिन ओको बोरकोत आप्यो, “इसराएली मानसे तारो नाव लीन ओसो बोरकोत आप्या कोरसे ‘ परमेश्वर तुसे एपरेम आरु मनश्शे क जोसो बोनाय देये’” आरु हुयो मनश्शे सी पेहेल एपरेम क नाव लेदो। ");
INSERT INTO dhn_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","ती इस्राएल न युसुफ सी कोयो, देख, हांव ते मोरने पोर छे बाखुन परमेश्वर तुमु मानसो क पुठी रोहसे, आरु तुमुक तुमरा डाहडा क देश मा ओळी पुगाड़ देसे। ");
INSERT INTO dhn_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","आरु हांव तुसेक भाष्यो सी मोटु जागा क एक वाटू आपो, हेनाक मे एमोरियो क हात सि आपसी तलवार आरु धनुष क भुरसे लि लेदलो छे (युह 4:5) ");
INSERT INTO dhn_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","ओळी याकुब न आपसा पुर्या क यो कोहीन बुलायो, एकठा होय जावु, हांव तुमुक देखाड़ीस, की‍ चेहला दाहड़ा मा तुमरे पोर काय काय वितसे। ");
INSERT INTO dhn_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","हे याकुब क पुर्या, एकठा होईन सोमळु, आपसा बाबा इस्राएल भिनी कान्टा लागाड़ु। ");
INSERT INTO dhn_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","हे रुबेन, तु मारु मोटलु पुर्यु, मारी ताकोत, आरु मारा मानुस होयनेन पेहलु फळ‌ छे; प्रतिष्ठा क वारु वाटू, आरु ताकोत क वी वारु वाटू तु त छे। ");
INSERT INTO dhn_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","तु जळ क जोसो उकोळनेवाळु छे, ओतरान कोरिन दिसरा सी वारु नी कोहायसे; काहकी तु आपसा बाबा क खाटला पोर चोढ़्यु, ती तु ओको विटोळ कोर्यु; हुयो मारा आथरन्या पोर चोढ गोयु। ");
INSERT INTO dhn_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","शिमोन आरु लेवी ते भाईभाईस छे, हेन्दरी तोलवार झगड़ो करावनो क होतीयार छे। ");
INSERT INTO dhn_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","हे मारा जीव, हेन्दरा मर्म मा नी पोड़, हे मारी महिमा, हेन्दरी सभा मा झुणी मिळे; काहकी हुये रीस सी मानषो क मार देदा, आरु आपसीत मोरजी पोर चालीन बयलीयो क लेंगड़ा बोनायो। ");
INSERT INTO dhn_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","धिक्कार हेन्दरा रीस क, जो प्रचण्ड हुतो; आरु हेन्दरो रोष क, जो निर्दय हुतो; हांव हेनद्रा याकुब मा आंगेआंगे आरु इस्राएल मा तितर बितर कोर दिस। ");
INSERT INTO dhn_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","हे यहुदा, तारा भाई तारो धन्यवाद कोरीस, तारा हात तारा शत्रु क गोळा पर पोड़से; तारा बाबा क पुर्य तुसे वान्दसे। ");
INSERT INTO dhn_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","यहुदा नाहोर क पुर्य छे। हे मारा पुर्य, तु अहेर कोरीन गुफा मा गोयो छे हुयो नाहार एने नाहरनी क जोसो दोबीन बोस गोय; ओळी कुन हेनुक छेड़से। (प्रका 5:5) ");
INSERT INTO dhn_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","जोत्यार लोगुन शीलो नी आवे ती लोगुन नी ते यहुदा सी राजडोन छुटसे, नी हेरो ओवलियाद सी व्यवस्‍था आपनेवाळु आंगे होयसे; आरु राज राजन मानुस हेरा होक क होय जासे। (युह. 11:52) ");
INSERT INTO dhn_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","हुये आपसा जुवान्या गोदड़ा क दाखलता मा, आरु आपसा गोदडी क पिला क वारु जाती क दाखलता मा बान्धया कोरसे (प्रका 7:14, प्रका 22:14) हुये आपसा छिन्दरा दाखमधु मा, आरु आपसी पेहरोट दाखो क रस मा धोयो छे। ");
INSERT INTO dhn_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","ओका डुळा अंगुरन रस जसी चमकीला आरु ओका दात दुध जसा धळा होयसे ");
INSERT INTO dhn_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","जबुलुन दरिया धोड़े पोर रोया कोरसे, आरु ढोन्या क लिय बंदरगाह क काम कोरसे, आरु ओको परलो वाटू सीदोन क धोड़े पुगसे ");
INSERT INTO dhn_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","इस्‍साकार एक मोटो आरु बलवन्त गोदड़ो छे, जे ढुरो क वाड़ा क वीच मा लुटलो रोहे छे। ");
INSERT INTO dhn_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","हुयो एक आरामोनजागु देखिन, कि वारु छे, आरु एक देश, क मनोहर छे, आपसा खादा क बोझ चुटने क लिय झुकायो, आरु बेगारी मा दास क सो काम कोरने लाग्यो। ");
INSERT INTO dhn_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","दान इस्राएल क एक गोत्र होईन आपसी जाती भाई क नीयाव कोरसे। ");
INSERT INTO dhn_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","दान वाट मा क एक घोड़सो, आरु वाट्ये मा क एक नाग होयसे, जु घुल्‌ला क नळी क डोसतो छे, जेनासीइ ओको सोवर पोछोळ हिट पोड़े छे। ");
INSERT INTO dhn_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","हे योहोवा, हांव तारी सी छुटकारो पावने क वाट जुवो। ");
INSERT INTO dhn_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","गाद पोर एक दल चोढ़ाई ते कोरसे; बाखुन हुये हेना दल क पोछोला वाटा पोर आक्रमण करसे। ");
INSERT INTO dhn_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","आशेर सी ज आन पोयदा हुयसे चो वारु हुयसे, आरु हुयो राजा क योग्य सोवादो खानो आप्या कोरसे। ");
INSERT INTO dhn_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","नप्ताली एक छुटली होयनी छे; हुयो घाटावी वात कोहे छे। ");
INSERT INTO dhn_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","युसुफ बलवन्त लता क एक डाळ छे, हुयो सोता क पास लागली होयी फलवन्त लता क एक डाळ छे; ओकी डाळ्या भितड़ा पोर सी चोड़ीन खोव्‌वाय जाय छे। ");
INSERT INTO dhn_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","धनुर्धारि न ओको खेदित कोर्या, आरु हेरे पोर तीर देये, आरु ओका पोछोळ पोड़े छे। ");
INSERT INTO dhn_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","बाखुन हेरो धोन्दली दृढ़ रयो, आरु ओका बाहा आरु हात याकुब क हेरो जुरभोर्या परमेश्वर क हातो क द्वारा छाटा हुया, जेरे पास सी हुये गुवाळ्या आवसे, जे इस्राएल क चाफर्या वी कोहायसे। ");
INSERT INTO dhn_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","यो तारा बाबा क हेना परमेश्वर क काम छे, जुळ तारी मोदोत कोरसे, हेना जुरभोर्या क जो तुसे उपोर सी वादळा मा क बोरकोत, आरु नेचा सी उन्डा जळ मा क बोरकोत, आरु स्तनो, आरु कुख क बोरकोत आपसे। ");
INSERT INTO dhn_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","तारा बाबा क बोरकोत मारा पितरों क बोरकोत सी सोटो वोद गोयो छे आरु सनातन बोयड़ा क मनचाही चीजो क जोसो बोनलो रोहसे चे युसुफ क मुनका पोर, जो आपसा भाई सी ओलोग कोर्‌यो गोयो हुतो, हेरात मुनका क मुकुट पोर फुले फळसे। ");
INSERT INTO dhn_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","बिन्यामीन फाड़नेवाळु लेंडियो छे, सोंदारे ते हुयो अहेर मारसे, आरु सान्तु क लुटलो वाट लेसे। ");
INSERT INTO dhn_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","इस्राएल क बारा गोत्र येत छे आरु ओका बाबा न जेना जेनाक बुल सी बोरकोत आप देदु, चे येत छे; एक एक क हेरा बोरकोत क ओनसारे हुयो बोरकोत आप्यो। ");
INSERT INTO dhn_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","ती हुयो यो कोहीन हेनुक हुकुम आप्यो, हांव मारा मानषो क पुठी मिळने पोर‌ छे: ओतरान कोरिन मेसे हित्ती एप्रोन क जागावाळी गुफा मा मारा डाहडा क पुठी धुळु आपजु, (प्रेरि 7:16) ");
INSERT INTO dhn_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","यानी हेना गुफा मा जो कनान देश मा मम्रेक ओगोळ वाळी मकपेला क जागा मा छे; हेना जागा क अब्राहम न हित्ती एप्रोन क हात सी ओतरान कोरिन मुले लेदो हुतो, कि हुयो बिड़ा क लिय ओको वावड़्यो जागो होय। ");
INSERT INTO dhn_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","“होंया अब्राहम आरु ओकी घोरवाळी सारा क धुळु आपलो हुतो; आरु हुयो इसहाक आरु ओकी घोरवाळी रिबका क वी धुळु आपला; आरु हुयो हांव लिआ क वी धुळु आपलु। ");
INSERT INTO dhn_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","हुयु जागु आरु हेरेम क गुफा हित्ती क हात सी मुले लेदला।” ");
INSERT INTO dhn_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","याकुब जब आपसा पुर्याक यो हुकुम आप्यो हुतो, ती आपस पाय खाटला पोर सेमटीन जीव छुड़्यु, आरु आपसा मानसो मा जाय मिळ्यु। (प्रेरि. 7:15) ");
INSERT INTO dhn_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","तोत्यार युसुफ आपसा बाबा क मुयो पोर पोड़ीन रोड़्यु आरु ओको गुळा देदु। ");
INSERT INTO dhn_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","आरु युसुफ न हेनु वैद्यो क, जे हेरा चाखर्या हुता, हुकुम आप्यो की हेर बाबा क धड़ मा आनतर तेल भोर; दीयात वैद्यो न इस्राएल क धड़ मा गोंदायन्यो तेल भोर दियात। ");
INSERT INTO dhn_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","आरु ओका चाळीस दाहड़ा पुरा हुया, काहकी जेरा धड़ मा गोंदायन्यो तेल भोर देये, ओको ओतरात दाहड़ा पुरा लागतला छे; आरु मिसरी मानुस ओका लिय सत्तर दाहड़ा लोगुन कलपिया कोरता रोया। ");
INSERT INTO dhn_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","जब ओका कलेपणेन क दाहड़ा वित गोया, ती युसुफ फिरोनन क घोराना क मनुष सी कोहने लाग्या, “काहमाईन तुमरा गिन क निगाह मार पोर होय ती मारी यी खबर फिरोन क सोमवाड़ु, ");
INSERT INTO dhn_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","मारु बाबु न यो कोहीन, ‘देख हाऊ मोरने मा छे,’ मेसे यु वायदु खावाड़्यु, ‘जो बिड़ो हांव आपसा जुगु कनान देश मा खुँदाड़लु छे हेना मा तु मेसे धुळु आपजी।’ ओतरान कोरिन हिमि मेसे होंयाँ जाईन मारा बाबा क धुळु आपनेन हुकुम आप, तेर वाद मा पोछू आत रोहीस।” ");
INSERT INTO dhn_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","ती फिरोन न कोयो, “जाईन आपसा बाबा क खादला वायदा क ओनसारे ओको धुळु आप।” ");
INSERT INTO dhn_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","ओतरान कोरिन युसुफ आपसा बाबा क धुळु आपने क लिय चाल्यो, आरु फिरोन क आखा कामकोरन्या, यानी हेरा घोर क पुरनिया, आरु मिसर देश क आखा पुनिया ओका पुठी चाल्या। ");
INSERT INTO dhn_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","आरु युसुफ क गर क आखा मानषे, आरु ओका भाई, आरु ओका बाबा क घोर क आखा मानुस वी पुठी गोया; बाखुन हुये आपस बाळ बोच्‌चा, आरु गाडरा बुकड़ा, आरु गाय बुईल क गोशेन देश मा छुड़ीन गोया। ");
INSERT INTO dhn_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","आरु ओका पुठी घुड़ागाड़ी आरु सोवार गोया, ओस कोरीन भीड़ घोने जोबोर होय गोय। ");
INSERT INTO dhn_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","जोत्यार हुये आताद क खलिहान लोगुन, जे यरदन नदी क पार छे, पुग्या, ती होया घोने जोबोर विलाप कोर्या, आरु युसुफ न आपसा बाबा क लिय सात दाहड़ा क विलाप कोरायो। ");
INSERT INTO dhn_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","आताद क खलिहान मा क विलाप क देखिन हेना देश क मानुस कनानी न कोया, “यो ते मिसरी क काई घोनो विलाप होसे।” कोरीन हेना जागा क नाव अबिलमिसरेम पोड़्यो, आरु हुयो यरदन क पार छे। ");
INSERT INTO dhn_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","इस्राएल क पुर्या न ठिक चोत काम कोर्या जोसो हुयो हेनुक हुकुम आप्यो हुतो: ");
INSERT INTO dhn_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","यानी हुये ओको कनान देश मा ली जाईन मकपेला क हेनी जागावाळी गुफा मा, जि मम्रे क ओगोळ छे, धुळु आप्या; जेनाक अब्राहम न हित्ती एप्रोन क हात सी ओतरान कोरिन मुले लेदा हुता, की हुये बिड़ा क लिय हेन्दरी वावड़्यु जागु होय। ");
INSERT INTO dhn_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","आपसा बाबा क धुळु आपीन युसुफ आपसा भाष्यो आरु हेनु आखा भेळ, जु हेरा बाबा क धुळु आपने क लिय ओका पुठी गोया हुता, मिसर पोछा आया। ");
INSERT INTO dhn_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","जब युसुफ क भाईष्यो न देख्या कि आमरु बाबु ते मोर गोयलु छे, ती कोहने लाग्या, “कदाचित् युसुफ हिमी आमरे पोछोळ पोड़े, आरु जोतरी कुहराय हेर सी आपनु कोरला हुता आखा क बोदलो आपने सी लेये।” ");
INSERT INTO dhn_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","ओतरान कोरिन हुये युसुफ क पास यो कोय मुकल्या, “तारा बाबा न मोरने सी पेहेल आमुक यो हुकुम आप्यो हुतो, ");
INSERT INTO dhn_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","तुमु मानुस युसुफ सु ओस कोरीन कोहजु, की हामु विनता कोरजे, की तु आपसा भाष्यो क गुना आरु पाप क माफ कोर; हामु तार सी कुहराय कोर्या हुता, बाखुन हिमी आपसा बाबा क परमेश्वर क दासो क गुना माफ कोर” हेन्दरी यी वात सोमळीन युसुफ रोड़ पोड़्यु। ");
INSERT INTO dhn_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","आरु ओका भाई आपसात वी ओका ओगोळ नेड़ा पोड़्या, आरु कोया, देख, हामु तारा दास छे। ");
INSERT INTO dhn_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","युसुफ न हेनुक कोयु, “मा बिहयु, काय हांव परमेश्वर क जागा पोर छे? ");
INSERT INTO dhn_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","बाखुन तुमु मानुस मारे जुगु कुहराय क विचार कोरला हुता; बाखुन परमेश्वर न हेनी वात मा भोलान विचार कोर्‌यो, जेरेसी हुयो ओसो कोरे, जोसे आज क दाहड़े प्रगट‌ छे, की बेस का मानुस क जिव नी वाचलो छे। ");
INSERT INTO dhn_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","ओतरान कोरिन हिमी मा बिहयु: हांव तुमरु आरु तुमरा बाळ बोच्‌चा क पाळन पुषोन कोरतु रोहीस।” ओस कोरीन हेनुक सोमझाड़िन हेमोत आप्यु। ");
INSERT INTO dhn_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","युसुफ आपसा बाबा क घराना भेळ मिसर मा रोहतु रोयु, आरु युसुफ एक सोव दस साल जिवतलु रोयु। ");
INSERT INTO dhn_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","आरु युसुफ एपरेम क परपोता लोगुन क देखने पायो आरु मनश्शे क पोता, जो माकीर क पुर्य हुतो, चे पोयदा हुया आरु युसुफ न हेनुक खुळाम लेदु। ");
INSERT INTO dhn_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","युसुफ न आपसा भाष्यो सी कोयु, हांव ते मोरने पोर छे; बाखुन परमेश्वर छाचीन तुमुक फोम राखसे, आरु तुमुक इन देश सी निकाळीन हेना देश मा पुगाड़ देसे, जेनाक आपने क हुयो अब्राहम, इसहाक, आरु याकुब सी वायदु खादलु होतु (इब्रा 11:22) ");
INSERT INTO dhn_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","ओळी युसुफ न इसराएलीयो सी कोयो कि परमेश्वर छाचीन तुमुक फोम राखसे, हेनुक इना वाराम क वायदु खावाड़्यु, हामु तारा हाड़का क याँ सी हेना देश मा ली जासु (इब्रानियो 11:22) ");
INSERT INTO dhn_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","ओस कोरिन युसुफ एक सोव दस साल क होईन मोर गोयो; आरु ओका धड़ मा गोंदायन्यो तेल भोर देदा, आरु हुयो धड़ मिसर मा एक सन्दुक मा मेल देदा।");
INSERT INTO dhn_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","याकुब न पोर्या क नाव, जो आपसा- आपसा घराना को लीन याकुब क साथ मा मिसर देश मा आया, चे या छे; ");
INSERT INTO dhn_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","रुबेन, शिमोन, लेवी, यहुदा, ");
INSERT INTO dhn_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","इस्साकार, जबुलुन, बिन्यामीन, ");
INSERT INTO dhn_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","दान, नप्ताली, गाद, आरु आशेर। ");
INSERT INTO dhn_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","आरु युसुफ ते मिसर मा पेहलुत आय गयलो हुतो। याकुब क आपसी ओवलियाद मा सी पयदा हुयला त्या आखा मेळीन सत्तर लोगहन हुता। ");
INSERT INTO dhn_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","युसुफ आरु सब उना भाईस, आरु उनी पीढ़ीन सब लोगहन मर गया। ");
INSERT INTO dhn_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","पुन इसराएल नी ओवलियाद जादा पयदा हुयने लाग गय; आरु त्या घण जबर ताकत वाळा बनता गया; आरु अतरा जादा वद गिया कि सारो मिसर देश उन लोगहन सी भराय गियो। ");
INSERT INTO dhn_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","मिसर देश मा एक नवलो राजा राज गाद्दी पर बठ्यो जो युसुफ को नी जानतो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","आरु त्यो आपसा लोगहन सी कयो, “देखो, इसराएली लोगहन हामरे सी गिनती आरु ताकत मा घण जबर वद गयला छे। ");
INSERT INTO dhn_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","अतरान करीन आवो, हामु त्या लोगहन क साथ मा ओकल सी व्यहवार करजे, असो नी त्या कि कदाम त्या घण जबर वद जाय, आरु लड़ाय करनेन दाहड़ा आय पड़े, ती त्या हामरा वैरी सी मेळ करीन हामरे साते लड़ाय करे आरु इना मिसर देश सी निकळ जाय।” ");
INSERT INTO dhn_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","अतरान करीन मिसर देश वाळा उन लोगहन क लिये रिकामा काम करने वाळा नेवाड़ीया कि त्या इस्राएल क लोगहन पर मुखी भार न्हाकी-न्हाखीन दु:ख दिया करे; तव त्या फिरोन क लिये पितोम आरु रामसेस नावन नगर मा भण्डारन घर वाळा नगर बनाया। ");
INSERT INTO dhn_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","पुन जसा-जसा त्या लोगहन दु:ख देता गया तसा-तसा इसराएली लोगहन वद्ता गिया; अतरान करीन इसराएली सी मिसर देश वाळा घण जबर बीह गिया आरु घुस्‍सो कनरनो लागी गयला हुता। ");
INSERT INTO dhn_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","ती आरु मिसरी लोगहन इसराएली लोगहन सी वातड़ी चाकरी कराया; ");
INSERT INTO dhn_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","आरु उन लोगहन के जीवन गारा, ईटड़ा आरु भाँती- भाँतीन काम न वातड़ी चाकरी करावीन जिवनो काठो कोर देदा; जिना बी काम त्या उन लोगहन सी चाकरी करावता हुता उना मा वातड़ो व्यवहार करता हुता। ");
INSERT INTO dhn_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","शिप्रा आरु पुआ नावन दुय इबरी सुवारनी को मिसर देशन राजा हुकुम दिदो, ");
INSERT INTO dhn_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“जव तुमु इबरी बाय जात को पोखड़ाये तव धीयान से देखजु कदाम पोर्‌यो हय, ती उको मार देजु; आरु कदाम पोराय हय ती जीवती रहवने देजु।” ");
INSERT INTO dhn_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","पुन ची सुवारनी योहोवा भगवान न बीक मानती हुती, अतरान करीन मिसर देशन राजान हुकुम नी मानिया आरु पोर्यान क जीवतला छुड़ देती हुती। ");
INSERT INTO dhn_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","तव मिसर देशन राजा उन सुवारनीया क बुलावीन पुछियो, “तुमु पोर्यान क जीवतला छुड़ देय, ती असा काह करो?” ");
INSERT INTO dhn_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","सुवारनीया फिरोन राजा को जवाब देदी, “इबरी जातीन बायरा मिसरी बायरान सारका नी हय; चे असा उतवाळीया छे कि सुवारनी न जाने सी पेहलुत उको पोर्‌यो पयदा हुय जाय।” ");
INSERT INTO dhn_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","अतरान करीन योहोवा भगवान उन सुवारनी क साथ मा भलो करीयो; आरु त्या लोगहन वदीन घण ताकत वाळा हुय गया। ");
INSERT INTO dhn_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","अतरान करीन कि सुवारनीया योहोवा भगवानन बीक मानती हुती आरु योहोवा भगवान हेनको घर बसायो। ");
INSERT INTO dhn_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","तव फिरोन आपसी सारी परजान लोगहन को हुकुम दिदो, “इबरी जातीन जतरा पोर्या पयदा हुयला छे उन सब को तुमु नील नदी मा न्हाक देजो, आरु सब पोराईयो को जीवता छुड़ देजो।” ");
INSERT INTO dhn_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","लेवी क घरानान एक मनुस एक लेवी जाती न बायर सी वीयाव कर लिदो। ");
INSERT INTO dhn_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","ची बायर भार पाये हय आरु उको एक पोर्‌यो पयदा हुयो; आरु यो देखीन कि त्यो बाळो घाटाळो छे, उना उनासी बाळा क तीन महीना तक सातीन राखी। ");
INSERT INTO dhn_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","जव ची बायर उको जादा समय तक सातीन नी राख सकी तव उका लियन टुकरान बनावली एक खिल्‌ली लेदी आरु उनी पर चिकनु धुळु आरु राल लगाड़ीन, उना मा बाळा को मेळीन नील नदीन काठा पर काहळान वीच मा छुड़ी आवी। ");
INSERT INTO dhn_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","उना बाळान बयनी दुर उबी रहवी यो देखने कि ओको काय हाल हुयसे। ");
INSERT INTO dhn_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","तव फिरोन राजान पोराय ऊंगळने करीन नदी न काटा पर आवी; ओकी पावराय बी काठा पर फिरती हुती; तव ची काहळान वीच मा खिल्‌ली को देखीन आपसी पावराय को उको ली आवने करीन लेने मोकली। ");
INSERT INTO dhn_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","तव फिरोन राजान पोराय उनी खिल्‌ली काजे उगाड़ीन देखी कि उका मा रोड़तलो एक बाळो छे; तव उको उना बाळा पर दया आवी आरु ची कयने लागी, “यो ते इबरी जाती बाळो हसे।” ");
INSERT INTO dhn_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","तव बाळान बयनी फिरोन राजा नी पोरय सी कयने लागी, “काय हांव जाईन इबरी बायर माईन काहली एक बाय को तारे पास बुलाय लावो जो तारे लिये बाळा को दुध पिवाड़िया करे?” ");
INSERT INTO dhn_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","फिरोन न पोराय कहवी, “जा।” तव ची पोराय जाईन बाळान माय को बुलाय लावी। ");
INSERT INTO dhn_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","फिरोन राजा न पोराय उना सी कयी, “तु इना बाळा को ली जाईन म्हारे लिये दुध पाया कर, आरु हांव तुको दाहड़की देय दिस।” तव ची बायर बाळा को ली जाईन दुध पावने लागी। ");
INSERT INTO dhn_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","जव बाळो थुड़क मोटो हुयो तव ची उना बाळा को फिरोन न पोराय क पास मा ली गय, आरु त्यो उको पोर्‌यो बनियो; आरु ची यो कयीन उको नाव मुसा राखी, “कि हांव उको पानी मा सी निकावली हुती।” ");
INSERT INTO dhn_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","जव मुसा जुवान हुयो, आरु उना दाहड़ा मा बाहर आपसा भाईबनिया क पास जाईन उन लोगहन क दु:खो क देखने लागीयो; तव त्यो देखियो कि कोय मिसरी मनुस ओको एक इबरी को सात लड़ाईन उको दी रयो। ");
INSERT INTO dhn_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","जव मुसो अथोन-अथो देखियो कि कोय नी हय, तव उना मिसरी मनुस को मुसो मारीन बालु रेतळा मा सात दीदो। ");
INSERT INTO dhn_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","ओळते दिसरे दाहड़े बाहर जाईन देखियो कि दुय इबरी मनुस आपसुत लड़ाय कर रीया; ती मुसो गुनाका मनुस को कयो, तु तारा भाई क काय लेने दी रयो? ");
INSERT INTO dhn_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","त्यो मनुस कयो, “कुन तुको हामरे पर हक राखनीयो मुखी आरु नियाव करने वाळो बनायो? जिने रीतिये तु मिसरी मनुस को मार न्हाकीयो तिनिये रीतिये तु मेखे बी मारने हुय रीयो?” तव मुसा यो सोचीन बिह गयो कि छाची यी वात उजन्ती हुय गय। ");
INSERT INTO dhn_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","जव फिरोन इनी वात को समळीयो तव मुसा को मार न्हाखने योजना बनायो। पुन मुसा फिरोन क सामने सी ढास गियो, आरु मिद्यान देश मा जाईन रोहने लाग्यो; आरु त्यो वाँ सारी एक कुँवान पास मा जाईन बठ गियो। ");
INSERT INTO dhn_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","मिद्यान न पुजारान सात पोराय्यो हुती; आरु ची वाँ आवीन पानी भरने लागी कि कठड़ा मा पानी भरीन आपसा बाप न गाडरा-बुकड़ा को पानी पिलावे। ");
INSERT INTO dhn_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","तव गुवाळीया आवीन हेनको छेटा करने लागीया; अतरा पर मुसा उबो हईन उनी पोराईयोन मद्त करीयो, आरु गाडरा–बुकड़ान को पानी पिवाड़ियो। ");
INSERT INTO dhn_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","जव ची पोराईयो आपसा बाप रुएल क पास आर आवी, तव त्यो पोराइयो सी पुछियो, “काय कारण छे कि आज तुमु अतरा छाटा आत रीया?” ");
INSERT INTO dhn_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","चे कया, एक मिसरी मनुस हामुक गुवाळीया सी छुड़ायो, आरु हामरे लिये घण सवटो पानी भरीन गाडरा–बुकड़ान को पिवाड़ियो। ");
INSERT INTO dhn_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","तव रुएल आपसी पोराईयो सी पुछियो, “त्यो काँ छे? तुमु उको काय लेने छुड़ी आया? उको बुलाय लावो कि त्यो खानो खाय।” ");
INSERT INTO dhn_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","आरु मुसा उना मनुस क सात मा रयने खुश हुयो; त्यो मुसा सी आपसी पोराय सिप्पोरा सी वियाव कर दीदो। ");
INSERT INTO dhn_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","आरु उको एक पोर्‌यो पयदा हुयो, तव मुसा यो कयीन कि, हांव बाहर देश मा परदेशी छे, करीन उको नाव गेर्शोम राखियो। ");
INSERT INTO dhn_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","घण दाहड़ा क बाद मिसर क राजा मर गियो। आरु इसराएली वातड़ी सेवान कारण ओकी–ओकी दम लेने लागीया, आरु आयड़ता हुता, आरु उन लोगहन की वातड़ी सेवा क कारण हेनको आयेड़नो योहोवा भगवान तक पुग गियो। ");
INSERT INTO dhn_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","आरु योहोवा भगवान उन लोगहन क आयेड़नो समळीन ओकी वाचा को, जो योहोवा भगवान अबराहम, आरु इसहाक, आरु याकुब क साथ मा बाँधली हुती फोम करीयो। ");
INSERT INTO dhn_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","आरु योहोवा भगवान इसराएली लोगहन पर नजर लगाड़ीन मन लगाड़ीयो। ");
INSERT INTO dhn_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","मुसा आपसा सेसरा यित्रो नावन मिद्यान क पुजारान गाडरा–बुकड़ान क चारावतो हुतो; आरु‍ त्यो गाडरा–बुकड़ान को जंगलो मा पश्चिम तरफ होरेब नावन योहोवा देव बयड़ान पास मा ली गियो। ");
INSERT INTO dhn_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","आरु योहोवा देवोन दुत एक काटा वाळी झाड़ोन वीच मा आग्ठान लपट मा मुसा को दर्शन दीदो; आरु त्यो नजर नाखीन देखियो कि झाड़को धप रीयो, पुन खतम नी हुयती। ");
INSERT INTO dhn_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","तव मुसा आपसा मोनोम विचारीयो, हांव हतो जाईन इना विछेळीया काम को देखीस कि त्यो झाड़को काह नी धपतो। ");
INSERT INTO dhn_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","जव योहोवा देव यो देख्‌यो कि मुसा देखने करीन आय रीयो, तव योहोवा देव झाड़ीन वीच मा सी मुसा को आयड़ी कयो, “ए मुसा, ए मुसा” मुसा कयो काय, काय हुकुम। ");
INSERT INTO dhn_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","योहोवा देव कयो, उरो मा आवे, आरु तारा पाय मा सी खासड़ा निकाळ दे, काहकी जिना जागा पर तु उबो हुय रीयो त्यो चुखलो छे। ");
INSERT INTO dhn_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","अतळते त्यो कयो, हांव तारा बाप को परमेश्वर, आरु अबराहम को परमेश्वर, इसहाक क परमश्वेर, आरु याकुब को परमेश्वर छे। तव मुसा जो योहोवा देव न तरफ भावनेन बिह गोयी, एकालिय उको मुय ढाक लीदो। ");
INSERT INTO dhn_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","अळते योहोवा देव कयो, “हांव म्हारी जातीन क लोगहन जो मिसर मा छे हेनका दु:ख को छाचो देखलो छे, आरु वातड़ी मेहनत करावने सी हेन्को आयेड़ेन ओवाज उको हांव बी समळलो छे, आरु हेन्दरी पीड़ा पर हांव मन लगाड़ीयो। ");
INSERT INTO dhn_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","अतरान करीन अब हांव नेचो उतरी आवलो छे कि उन लोगहन को मिसरीयान हाथ मा सी छुड़ावो, आरु उना देश सी निकाळीन एक वारला आरु मोटा देश मा जिना मा दुध आरु माहळन धार उहवे, मतलब कि कनानी, हित्ती, एमोरी, परिज्जी, हिव्वी, आरु यबुसी लोगहन क जागा मा पुगाड़ीस। ");
INSERT INTO dhn_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","अतरान करीन अब समळ, इसराएलीयान आयेड़नो मखे समळाय पड़ियो, आरु मिसरीयान उन लोगहन वेला पाड़नो बी मखे देखाय पड़लो छे, ");
INSERT INTO dhn_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","अतरान करीन आव, हांव तुको फिरोन क पास मुकलो कि तु इसराएल जातीन लोगहन को मिसर देश सी निकाळ ली आवे।” ");
INSERT INTO dhn_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","तव मुसा योहोवा सी कयो, “हांव कुन छे, जो फिरोन क पास मा जामो, आरु इसराएलीयो को मिसर देश सी निकाळ लावो?” ");
INSERT INTO dhn_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","योहोवा देव कयो, पाको हांव तारे साते रहीस; आरु इनी वात को कि तुखे मोकलने वाळो हांव छे, तारे लिये यी सोहलानी रहवसे; कि जव तुउन लोगहन को मिसर देश सी निकाळ लीस तव तुमु इनात् बयड़ा पर म्हारी सेवा भक्ती करसु। ");
INSERT INTO dhn_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","मुसा योहोवा देव सी कयो, जव हांव इसराएलियो क पास मा जाईन हेनको यो कयो, कि तुमरा डाहडान देव मखे तुमरे पास मोकलीयो, तव कदाम त्या म्हार सी पुछे, उको नाव काय छे? तव हांव उन लोगहन को काय देखाड़ीस? ");
INSERT INTO dhn_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","योहोवा देव मुसा सी कयो, “हांव जु छे चु छे।” ओळते त्यो मुसा सी कयो, तु इसराएलियो सी कयजी जेरो नाव हांव छे चो छे त्यो मखे तुमरे याँह मोकलीयो। ");
INSERT INTO dhn_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","ओळते योहोवा देव मुसा सी यो बी कयो, तु इसराएलियो सी यो कयजी, तुमरा डाहडान योहोवा देव, मतलब अबराहम को परमेश्वर, इसहाक को परमेश्वर, आरु याकुब को परमेश्वर, त्योत् मखे तुमरे पास मोकलीयो। देख सदा तक म्हारो नाव योत् रयसे, आरु पीढ़ी–पीढ़ी मा म्हारी फोम इना सी हुया करसे। ");
INSERT INTO dhn_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","अतरान करीन अब जाईन इसराएली डाहडान को एखटा कर, आरु उन लोगहन सी कय तुमरा डाहडा अबराहम, इसहाक, आरु याकुबन परमेश्वर, योहोवा मखे दर्शन दीन कयलो छे कि हांव तुमरे पर आरु तुमरे साते जो गलत व्यवहार मिसर हुयतलो उना पर मन लगाड़लो छे; ");
INSERT INTO dhn_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","आरु हांव ठान लियो कि तुमुक मिसर देशन दु:ख मा सी निकाळीन कनानी, हित्ती, एमोरी, परिज्जी, हिव्वी, आरु यबुसी लोगहन क देश मा ली जाईस, जो असो देश छे कि जिनाम मा दुध आरु माहळनी धार उहळे। ");
INSERT INTO dhn_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","तब त्या मान लेसे; आरु तु इसराएली डाहडान को सात मा ली जाईन मिसर देशन राजा को यो कयजी, इबरीयान परमेश्वर, योहोवा भगवान सी हामरी भेटावनी हुयली छे; अतरान करीन अब हामुक तीन दाहड़ान वाटिये जंगल मा जानी दे कि हामरा परमेश्वर योहोवा क बलिदान चढ़ावजे। ");
INSERT INTO dhn_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","हांव यो जानो कि मिसर देशन राजा तुमुक जाने नी देय पुन एक मोटी ताकतुत तुमु लोगहन क जाने क लिय ओको वेला पाड़से। ");
INSERT INTO dhn_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","अतरान करीन हांव हाथ बढ़ावीन उन सब पर विनछेळीया काम मिसरन वीच मा करीस उना देश को मारीस; आरु उना बाद त्यो तुमुक जाने देसे। ");
INSERT INTO dhn_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","तव हांव मिसरी जाती सी म्हारी इनी जाती पर दया करावीस; आरु जव तुमु निकेळसु तव ठारला हाथ सी नी निकळु। ");
INSERT INTO dhn_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","पुन तुमरी एक–एक बायर आपसी–आपसी पड़ोस वाळी, आरु आपसा–आपसा घर मा रहवने वाळी सी सोना चाँदीन गयनो, आरु छिंदरा मांग लेसे, आरु तुमु ओको तुमरा पोर्या आरु पोराईयोन को पेहरावजो; इनिये रीतिये तुमु मिसरी लोगहन को लुट लेसो। ");
INSERT INTO dhn_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","तव मुसा जवाब दीदो, त्या तार पर विश्वास नी करे आरु नी म्हारी समळे, पुन कयसे, योहोवा तुखे दर्शन नी दीदो। ");
INSERT INTO dhn_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","योहोवा देव मुसा सी कयो, “तारा हाथ मा त्यो काय छे?” मुसा बोलियो “लाकड़ी।” ");
INSERT INTO dhn_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","योहोवा देव कयो, ओको धरती पर न्हाख दे। जव मुसा उको धरती पर न्हाक दीदो तव‍ त्यो घोड़सो बन गयो, आरु मुसा उना सामने सी ढास गीयो। ");
INSERT INTO dhn_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","तव योहोवा मुसा सी कयो, हाथ बढ़ावीन ओकी छेमटी धर ले, काहकी त्या लोगहन विश्वास करे कि तुमरा आड़ाबुड़ा क परमेश्वर मतलब अबराहम क परमेश्वर, इसहाक क परमेश्वर, याकुब क परमेश्वर, योहोवा तुखे दर्शन आपलो छे। ");
INSERT INTO dhn_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","ओस कोरीन चे भुरसु कोरसे जव हाथ बढ़ावीन उको धर लीदो तव त्यो उना हाथ मा पछी लाकड़ी बन गय। अबराहमन परमेश्वर इसहाकोन परमेश्वर आरु याकुबोन परमेश्वर मेसे दोरसोन आप्यु ");
INSERT INTO dhn_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","ओळी योहोवा मुसा सी यो बी कयो, तारो हाथ छाती पर मेलीन ढाक ले। तसोत् मुसा उना हाथ छाती पर मेलीन ढाक लीयो; ओळते जव उको निकाळीयो तव यो देख्‌यो कि उको हाथ कुढ़न कारण बोरोफ क सारको धवळीयो हुय गयो। ");
INSERT INTO dhn_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","तव योहोवा मुसा सी कयो, “तार हाथ छाती पर मेलीन ढाकले।” आरु मुसा ओको हाथ छाती पर मेलीन ढाक लीदो; आरु जव मुसा ओको हाथ छाती पर सी निकाळीयो ती यो देख्‌यो कि‍ त्यो ओळी आखा डीलोन तसो हुय गीयो। ");
INSERT INTO dhn_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","तव योहोवा कयो, “कदाम त्या तारी वात पर विश्वास नी करे, आरु पेहली सोहलानी को नी माने, ती दिसरी सोहलानी पर विश्वास करसे। ");
INSERT INTO dhn_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","आरु कदाम त्या इनु दुयु सोहलानी पर विश्वास नी करे आरु तारी वात को नी माने, तव तु नील नदी मा सी थुड़क पानी लीन सुखली धरती पर न्हाकजी; आरु जो पानी तु नदी सी निकाळीस त्यो सुकली धरती पर लुहुय बन जासे।” ");
INSERT INTO dhn_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","मुसा योहोवा सी कयो, “ए म्हारा पोरबु। हांव बुलने मा पाको नी हय, नी ते पेहले हुतो, आरु नी जव सी तु तारा दास सी वात करने लागीयो; हांव ते मुयन बुबड़ो आरु जीभ को गुंगड़ो छे।” ");
INSERT INTO dhn_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","योहोवा मुसा सी कयो, मानुस को मुय कुन बनायो? आरु मनुस को गुँगड़ो, या बेहरो, या देखने वाळो, या आंधवो, मखे छुड़ीन कुन बनावे? ");
INSERT INTO dhn_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","अब जा, हांव तारा मुय सी जो काय तुखे कयनो छे त्यो तुखे सिखाड़तो जाईस। ");
INSERT INTO dhn_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","त्यो कयो, “ए म्हारा पोरबु, थार सी विनती छे कि तु कुदा दिसरा मनुस को मोकली दे।” ");
INSERT INTO dhn_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","तव पोरबुन रीस मुसा पोर भड़की। पोरबु कयो, काय लेवी ओवलियादन हारुन तारो भाईन नी होय? हांव जानो कि त्यो वारलो बुलसे देख, त्यो तार सी मिळने आय रोयो। जव त्यो तुसे देखसे तव आपसा काळजजा मा खुश होयजी। ");
INSERT INTO dhn_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","तु उनासी वार कोरजी। आरु ओको बताड़जी की काय कोरनो छे, हांव तुको आरु उको बुलने मा मदत कोरीस। आरु तुमुक काय कोरनो छे, यो सिकाड़ीस। ");
INSERT INTO dhn_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","हारुन तारे भेनि सी म्हार लोगहन सी वात कोरसे, त्यो तारो बुलन्यो हुयसे, आरु तु हेका लिय परमेश्वर सारको कोवायसे। ");
INSERT INTO dhn_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","तु आपसा पुठी लाकुड़ ली जाजी, तु हेरे लारे मोटा काम कोरनेन सोहलानी देखाड़ीस। ");
INSERT INTO dhn_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","मुसा वां सी चाली गुयो। त्यो आपसा सेसरा यितरो क पास गुयो। हेको कयो, मेसे जाने देवु हांव आपसा भाय बोन्या क पास, जे मिसर देश मा छे पोछा ली आवो। हांव जाईन देखीस की काय त्या हेमी जिवतला छे, यित्रो न मुसा सी कयो, “वारु शांती सी जा।” ");
INSERT INTO dhn_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","पोरबु न मिद्यान देश मा मुसा सी कयो, मिसर देश क लौटी जा; काहकी जे लोगहन तारा जीव लेनो चाहता हुता, त्या आखा मोर गोयला छे। ");
INSERT INTO dhn_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","मुसा न आपसी लाड़ी आरु पुर्या क गोदड़ा पोर बोसाड़्यो आरु मिसर देश भेनी निकळ्यो, आरु मुसा न परमेश्वर न उना लाकुड़ को लेदो। ");
INSERT INTO dhn_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","तव योहोवा न मुसा सी कयो, जव तु मिसर देश मा पुगे तव धियान रोहे कि जे मोटला काम हांव तारा होक मा कोरल छे उना आखा क फिरोन क देखाड़जी; पुन हांव हेनको मोन वातड़ो कोरीस, आरु त्या म्हार लोगन क जाने नी देये। ");
INSERT INTO dhn_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","आरु तु फिरोन सी कोहजो, योहोवा असो कोहे छे, कि इस्राएल म्हार पुरीया पुन मारो पेहलो पुर्‌यो छे, ");
INSERT INTO dhn_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","आरु हांव ज तुसे कोहलो छे कि म्हार पुर्या क जाने दे की त्या म्हार वायदान चाखरी कोरे; आरु तु न हेमि लगुन हेको जाने नी देदो, एना कारण हांव हेमी तारा मोटला पुर्या को मारीस। ");
INSERT INTO dhn_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","तव असो हुयो कि वाट मा धोरोमसाहवा मा योहोवा न मुसा को मार नाखनो चाहाया। ");
INSERT INTO dhn_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","तव सिप्पोरा न एक धारवाळो दगड़ो लीन आपसा पुर्यान खाल क काट नाखी, आरु मुसा क पायोम यो कोहीन नाख देदा, छाचिन तु म्हार लिय लुहुय उहवाड़ने वाळो म्हारो धेनी छे। ");
INSERT INTO dhn_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","तव योहोवा न हेको छुड़ देदो, उना टेमे खतना क कारण त्या बुली, “तु लुहुय उहवाड़ने वाळो धेनी छे।” ");
INSERT INTO dhn_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","तव योहोवा न हारुन सी कयो, “मुसा सी मिळने कोरीन जंगल मा जा।” त्यो गुयो आरु परमेश्वर क बोयड़ा पोर उनासी मिळ्यो आरु मुसा को गुळु देदो। ");
INSERT INTO dhn_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","तव मुसा न हारुन को यो बतलायो कि योहोवा न काय काय वात कोविन हेको मुकल्यो छे, आरु काहनली काहनली सोहलानी देखाड़नेन हुकुम हेको आपलो छे। ");
INSERT INTO dhn_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","तव मुसा आरु हारुन ज जाईन इसराएलीयो क आखा डाहडा क एकठा कोर्या। ");
INSERT INTO dhn_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","आरु जोतरी आखी वात योहोवा न मुसा सी कोयो हुतो ची आखी वात हारुन न हेको समवाड़्यो, आरु लोगहन क डुळा अगळ त्या सोहलानी वी देखाड़्या। ");
INSERT INTO dhn_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","आरु लोगहन न हेनको विश्वास कोर्या; आरु यो समळीन कि योहोवा न इसराएलीयोन फोम करीयो आरु हेनका दुख पोर निंगा कोरलो छे, त्या मुनका नेचा करीण वांद्या। ");
INSERT INTO dhn_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","तव मुसा आरु हारुन जाईन फिरोन सी कया, “इसराएल को योहोवा भगवान यो कहे: म्हारी परजान लोगहन को जाने दे कि त्या जंगल मा म्हारे लिए एक तिहवार मनावे।” ");
INSERT INTO dhn_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","फिरोन कयो, “योहोवा कुन छे कि हांव ओको वचन मानीन इसराएली लोगहन को जाने द्योव? हांव योहोवा को नी जानो, आरु हांव इसराएलीयान को नी जाने द्योव।” ");
INSERT INTO dhn_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","त्या कय इबरीयान योहोवा भगवान हामरे सी मेवायलो छे; अतरान करीन हामुक जंगल मा तीन दाहड़ान वाटिये जाने दे, कि हामरा योहोवा भगवान को बलीदान करजे, असो नी हये कि त्यो हामरे मा मरी फैलावे या तोलवार चलाड़े। ");
INSERT INTO dhn_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","मिसरन राजा उन लोगहन सी कयो, ए मुसा, ए हारुन, तुमु काहा लोगहन को काम छुड़ावने हय रीया? तुमु जाईन तुमरो-तुमरो काम करो। ");
INSERT INTO dhn_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","आरु फिरोन कयो, सुनो, इना देश मा त्या लोगहन घणा हुय गयला छे, हिमी तुमु उन लोगहन को काम सी आराम आपाड़ने हिय रिया! ");
INSERT INTO dhn_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","फिरोन उना दाहड़े तिनु काठी मेहनत कराने वाळान को जो उन लोगहन पर हुता, आरु उन लोगहन क मेटड़ा लोगहन को यो हुकुम दिदो, ");
INSERT INTO dhn_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“तुमु जो अब तक इटड़ा बनावने करीन लोगहन को चारान ढिग दिया करतो हुतो अब ओगळ कथो झुण आपे; त्या आपसुत् जाईन च्यारु एखटा करसे। ");
INSERT INTO dhn_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","तव बी जतरा ईटड़ा उन लोगहन को बनावनो पड़तलो ततरात् ओगो बनाय मांगजी, इटड़ान गिनती थुड़ीक बी झुण घटाड़े; काहकी त्या उजग्या छे, इना कारण यो कहीन आयड़े, हामु जाईन हामरा योहोवा भगवान को बलीदान करजे। ");
INSERT INTO dhn_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","उन मनुसो सी आरु जादा वातड़ो काम करावजी कि त्या उना मा वातड़ो काम करता रहवे आरु झुटी वातो पर मन नी लगाड़े।” ");
INSERT INTO dhn_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","तव लोगहन को काम करवाने वाळा आरु मेटड़ा बाहर जाईन उन लोगहन सी कया, फिरोन असो कहे, कि हांव तुमुक च्यारु नी आपो। ");
INSERT INTO dhn_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","तुमुत् जाईन जाँ काहा बी च्यारु जड़े वाँ सी उको एखटो करीन ली आवु; पुण तुमरो काम थुड़ोक बी नी घटाड़ो। ");
INSERT INTO dhn_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","अतरान करीन त्या लोगहन सारा मिसर देश मा तितर-बितर हुय गिया कि चारान बदले खुट्या एखटा करे। ");
INSERT INTO dhn_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","काम करावने वाळा यो कहीन उन लोगहन को उतवाळी करावता रिया, कि जिनिये रीतिये तुमु धुळु मांगीन काम करता रया तसात् तुमरो दाहड़ीन काम हेमी बी पुरो करो। ");
INSERT INTO dhn_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","आरु इसराएलीयो मा सी जिनु सरदारीयान को फिरोन न काम करनीया उन लोगहन क आदिकारीया बनावला हुता त्या घण मार खादा आरु उन लोगहन सी सरदारीया पुछिया कि काय ओसो छे कि तुमु तुमरी आपली गिनतीन अनसारे पेहलेन तसा काल आरु आज पुरी नी कराया? ");
INSERT INTO dhn_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","तब इसराएलियान सरदारीया जाईन फिरोन सी यो कहीन रावनिया करीया, “तु तारा दासो सी असो व्यवहार काह कर रीयो? ");
INSERT INTO dhn_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","तारा दासोन को च्यारु ते आपता नी आरु त्या हामरे सी कयता रहे, कि ईटड़ा बनावो, आरु तारा नेवाड़ला दास लोगहन बी मार खादा; पुण गुनु तारात् लोगहन को छे।” ");
INSERT INTO dhn_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","फिरोन कयो, तुमु उजग्या छे, उजग्या; अतरान करीन तुमु यो कहवो की हामुक योहोवा भगवान क लिये बलिदान चढ़ावने जाने दे। ");
INSERT INTO dhn_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","अब जाईन तुमरो काम करो; आरु च्यारु तुमुक नी आपजे। पुण इटड़ान गिनती पुरी करनो पड़से। ");
INSERT INTO dhn_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","जव इसराएलीयान सरदारीया यी वात समळीया तिन्दरा ईटड़ान गिनती नी घटे, आरु दाहड़ीन ततरोत् काम करनो पड़से, तव त्या जान गया कि उन लोगहन पर काठला दाहड़ा आय गिया। ");
INSERT INTO dhn_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","जव त्या फिरोनन सामने सी बाहर निकळी आया तव मुसा आरु हारुन, जो तिन्दरे सी मेळ भेट करने करीन उबा हुय रीया हुता, उन लोगहन को भेटीया; ");
INSERT INTO dhn_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","आरु त्या लोगहन मुसा आरु हारुन सी कया, योहोवा भगवान तुमरे पर नजर करीन नियाव करे, काहकी तुमुत् हामुक फिरोन आरु उना आदिकारीयान नजर मा खुटा बनावीन हामुक मारवने करीन उन लोगहन क हाथ मा तोलवार आप देदला छे। ");
INSERT INTO dhn_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","तव मुसा योहोवा भगवान क पास पछो जाईन कयो, “ए पोरबु, तु इनी जाती काजे काहा तोकलीप आप रोयु? आरु तु मखे याँ सारी काहा मोकलीयो? ");
INSERT INTO dhn_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","जव सी हांव तारा नाव सी फिरोन क पास वात करने करीन गियो तव सी त्यो इनी जातीन साथ खुटो व्यवहार करियो, आरु तु तारी जातीन लोगहन को काय बी छुटकारो करियो।” ");
INSERT INTO dhn_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","तव योहोवा भगवान मुसा सी कयो, “जो वेवहार हांव फिरोन क पुठी कोरीस, हेमी तु ओको देखीस। त्यो म्हार मोटी ताकोक क कारन आपसा देश सी ओको मुकलसे। विनभुरसे म्हार मोटी ताकोत क कारण त्यो ओको निकाळ देसे।” ");
INSERT INTO dhn_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","योहोवा भगवान मुसा सी कयो, हांव योहोवा भगवान छे। ");
INSERT INTO dhn_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","हांव आखा सी मोटो ताकोत वाळो भगवान क नाव सी अबराहम, इसहाक, आरु याकुब को दर्शन देतो हुतो, पुण योहोवा भगवान क नाम सी तिन्दरे पर उजेन्तो नी हुयो। ");
INSERT INTO dhn_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","आरु हांव उन लोगहन क साथ मा म्हारी वाचा वातड़ी करलो छे, मतलब कनान देश जिना मा त्या बाहर देश वाळा बनीन हयता हुता, त्यो हेन्को आपदेयो। ");
INSERT INTO dhn_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","इसराएली जिनुक मिसरी लोगहन आपसा हको तळे राखे, तिन्दरो आयेड़नो बी समळीन हांव म्हारी वाचाक फोम करलो छे। ");
INSERT INTO dhn_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","अतरान करीन तु इसराएलीया सी कय, हांव योहोवा भगवान छे, आरु तुमुक मिसरीयान भारो तळे रईन निकाळीस, आरु तिन्दरा गुलामी सी तुमुक छुड़ावीस, आरु म्हारो हाथ बढ़ावीन आरु वातड़ो दण्ड आपीन तुमुक छुड़ाय लीस, ");
INSERT INTO dhn_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","आरु हांव तुमुक म्हारा लोग बनावने करीन मान लीस, आरु हांव तुमरो योहोवा भगवान ठेहरीस; आरु तुमु जान जासु कि हांव तुमको मिसरियान भारो तळे रईन निकाळ लायो। ");
INSERT INTO dhn_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","आरु जिना देश को आपनेन हांव अबराहम, इसहाक, आरु याकुब सी हात उचो कोरीन वायदो करलो हुतो उनात् मा हांव तुमको पुगाड़ीन उको तुमरो होक बनाय दिस। हांव तो योहोवा छे। ");
INSERT INTO dhn_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","यी सारी वात मुसा इसराएलीया लोगहन को समळाय दिदो; पुण हेनको मन दु:खी हुयने सी आरु गुलामीन वेलान कारण सी मुसान नी समळीया। ");
INSERT INTO dhn_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","तव योहोवा मुसा सी कयो, ");
INSERT INTO dhn_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","\"तु जाईन मिसरन राजा फिरोन सी कय कि इसराएली लोगहन थार देश मा सी निकळी जाने दे। ");
INSERT INTO dhn_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","आरु मुसा योहोवा सी कयो, \"देख, इसराएली लोगहन म्हारी नी समळीया; ओळी फिरोन म्हार गुंगड़ान वात काहा समळसे?\" ");
INSERT INTO dhn_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","तव योहोवा मुसा आरु हारुन को इसराएली आरु मिसरन राजा फिरोन क लिये इनीये रीतिये हुकुम दीदो कि त्या इसराएली लोगहन को मिसर देश सी निकाळी ली जाय। ");
INSERT INTO dhn_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","हेनका डाहडान क घरानान खास ओदमी या छे: इसराएलन पेहला खुळान रुबेन क पोर्‌यो हनोक, पल्लु, हेसरोन आरु कर्मी हुता; इनु सी रुबेनन खानदानी निकळी। ");
INSERT INTO dhn_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","आरु शिमोन को पोर्‌यो: यमुएल, यामीन, ओहद, याकीन, आरु सोहर हुता, आरु एक कनानी बायोरन पोर्‌यो शाऊल बी हुतो; इनु सी शिमोन नी खानदनी निकळी। ");
INSERT INTO dhn_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","लेवीन पोर्या जीनु सी ओवलियाद चाली, उन लोगहन क नाव यो छे: गेर्शोन, कहात आरु मरारी, आरु लेवीन पुरी उमोर एक सोव सयतीस साली हय। ");
INSERT INTO dhn_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","गेर्शोन न पोर्‌यो जिनु सी हेनकी खानदानी चाली: लिबनी आरु शिमी हुता। ये आपसी जातीन डाहला हुता। ");
INSERT INTO dhn_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","कहातन पोर्या: अम्राम, यिसहार, हेब्रोन, आरु उज्जीएल हुता, आरु कहात न पुरी उमोर एक सोव सेंतीस सालोन हय। ");
INSERT INTO dhn_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","मरारी न पोर्या: महली आरु मुशी हुता। लेवियान जाती जिनु सी हेनकी ओवलियाद चाली यात् छे। ");
INSERT INTO dhn_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","अम्राम आपसी फुय योकेबेद सी वियाव कर लिदो आरु उना सी मुसा हारुन पयदा हुया, आरु अम्रामन पुरी उमोर एक सोव सेमतीस सालन हय। ");
INSERT INTO dhn_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","यिसहारन पोर्या: कोरह, नेपेग आरु जिक्री हुता। ");
INSERT INTO dhn_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","उज्जीएल न पोर्या: मीशाएल, एलसाफान आरु सित्री हुता। ");
INSERT INTO dhn_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","हारुन अम्मीनादाब न बेटी, आरु नहशोन नी बयणी एलीशीबा सी वियाव कर लीदो; आरु उना सी नादाब, अबीहु, एलीयाजर आरु ईतामार पयदा हुया। ");
INSERT INTO dhn_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","कोरहन पोर्या: अस्सीर, एल्काना आरु अबीआसाप हुता; आरु इनु सी कोरहियान जाती निकळी। ");
INSERT INTO dhn_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","हारुन न पोर्या एलीयाजर पुतीएल न पोराई सी वियाव कर लीदो; आरु उका सी पीनहास पयदा हुयो। जिना सी हेनकी जाती चाली। लेवियान डाहडान घरानान यात् ओदमी छे। ");
INSERT INTO dhn_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","हारुन आरु मुसा त्यात् छे जिनुक योहोवा भगवान हुकुम आपलो \"इसराएली लोगहन को टुळुन टुळु करीन हेनका जत्थान अनसारे मिसर निकाळ ली आवो।\" ");
INSERT INTO dhn_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","या त्यात् मुसा आरु हारुन छे जे मिसर देश न राजा फिरोन सी कया कि हामु इसराएली लोगहन को मिसर सी निकाळ ली जासु। ");
INSERT INTO dhn_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","जव योहोवा मिसर देश मा मुसा सी यी वात करीयो, ");
INSERT INTO dhn_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","त्यो मुसा सी कयो, \"हांव ते योहोवा छे; अतरान करीन जो काय हांव तुमुक कयीस त्यो सब मिसर देशन राजा फिरोन सी कयजो। ");
INSERT INTO dhn_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","पुण मुसा योहोवा को जवाब दीदो, हांव ते बुलने मा गुंगड़ो छे; आरु फिरोन म्हारी वात कसो समळसे?\" ");
INSERT INTO dhn_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","तव योहोवा भगवान मुसा सी कयो, \"समळ, हांव तुको फिरोन क लिये परमेश्वर सारको बनावो; आरु थारो भाय हारुन थारो कागळीयो कोवायसे। ");
INSERT INTO dhn_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","जो–जो हुकुम हांव तुको आपीस त्योत् कयजी, आरु हारुन उना हुकुम को फिरोन सी कयसे जिना सी त्यो इसराएली लोगहन को आपसा देश सी निकळ जाने देय। ");
INSERT INTO dhn_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","पुण हांव फिरोन क मन को वातड़ो कर दीस, आरु म्हारी सोहलाणी आरु चमत्कार मिसर देश मा जबर देखाड़ीस। ");
INSERT INTO dhn_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","ते बी फिरोन तुमरी नी समळे; आरु हांव मिसर देश पर म्हारो हाथ अगो कोरीन मिसरी लोगहन को बेसको दण्ड आपीन म्हारी इसराएली जाती को मिसर देश सी निकाळ लीस। ");
INSERT INTO dhn_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","आरु जव हांव मिसर पर हाथ अगो कोरिन इसराएली लोगहन को हेनको वीच मा रईन निकाळीस तव मिसरी लोगहन जान जासे, कि हांव योहोवा छे।\" ");
INSERT INTO dhn_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","तव मुसा आरु हारुन योहोवान हुकुम क अनसारेत करीया। ");
INSERT INTO dhn_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","जब त्या फिरोन सी वात करने लागिया तव मुसा ते अस्सी सालन हुतो, आरु हारुन तिरासी सालन हुतो। ");
INSERT INTO dhn_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","योहोवा मुसा आरु हारुन सी इने रीतिये सी कयो, ");
INSERT INTO dhn_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","\"जव फिरोन तुमरे सी कये, कि तुमरी सोहलानीन काहय वीनछेळीयो काम देखाड़ो,' त तु हारुन सी कयजी, थार लाकड़ी लीन फिरोन क सामने न्हाक दे, कि घड़सु बन जाय।\" ");
INSERT INTO dhn_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","तव मुसा आरु हारुन फिरोन क पास मा जाईन योहोवान हुकुमन अनसारे करीया; आरु फिरोनन अधिकारियान सामने न्हाक दीदा, तव लाकड़ी घड़सु बन गय। ");
INSERT INTO dhn_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","तव फिरोन झाड़ु झोपाय करने वाळान क बुलायो; आरु मिसर नजरबान्दा आपसा तंत्र मंत्र सी तसात् करीया। ");
INSERT INTO dhn_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","त्या लोगहन बी आपसी–आपसी लाकड़ी को न्हाक दीदा, आरु चे बी घड़सु बन गय। पुण हारुनन लाकड़ी हेनकी लाकड़ी को गीळ गय। ");
INSERT INTO dhn_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","पुण फिरोनन मन अळी वातड़ो हुय गयो, आरु योहोवान वचन कि अनसारे त्यो मुसा आरु हारुनन वातो को नी मानीयो। ");
INSERT INTO dhn_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","तव योहोवा मुसा सी कयो, \"फिरोन को मन वातड़ो हुय गयलो छे आरु त्यो इनी जाती को जाने नी देसे। ");
INSERT INTO dhn_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","जव फिरोन संदारे नदी भेनी आवसे तव तु हेका पास जाजी, तु नील नोदी क धड़े हेकी वाट जुवजी, जी लाकुड़ घोड़सु बोन गोयली हुती ओको आपसा हात मा धर लेजी। ");
INSERT INTO dhn_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","आरु तु उना सी ईनिये रीतिये सी कयजी, 'इबरीयान योहोवा भगवान मेखे यो कयने करीन थारे पास मोकलीयो कि म्हारी जातीन लोगहन को जाने दे जिना सी कि त्या जंगल मा जाईन म्हारी विनता करे; आरु हाय तक तु म्हारो कयनो नी मानीयो। ");
INSERT INTO dhn_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","योहोवा यो कये, कि इना सी तु जान लीस कि हांव योहोवा भगवान छे; देक, हांव म्हार लाकड़ी को नील नदी न पानी पर दीस, आरु पानी लुहुय सारको बन जायसे, ");
INSERT INTO dhn_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","आरु जो माछली नोंदी मा छे त्या मर जासे, आरु नील नदी गंधायने लाग जासे, आरु मिसरीयान जीव नदीन पानी पीने नी करसे।\" ");
INSERT INTO dhn_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","ओळते योहोवा मुसा सी कयो, \"हारुन सी कय कि थार लाकड़ी लीन मिसर देश मा जतरो पानी छे, मतलब ओकी नोंदी, नहरम, झील, आरु पानीन कुण्डिया, सबन पर थार हाथ बढ़ाव कि ओको पानी लुहुय बन जाय; आरु सारा मिसर देश मा लाकड़ान आरु दगड़ान दुय भाँतीन ठिकरा मा लुहुयत् लुहुय हुय जासे।\" ");
INSERT INTO dhn_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","तव मुसा आरु हारुन योहोवान हुकुम क अनसारे करीया, मतलब त्या लाकड़ी को हाकलीन फिरोन आरु उना आदिकारीया न देखान्तो नील नदीन पानी पर देदो, आरु नदीन सारो पानी लुहुय बन गयो। ");
INSERT INTO dhn_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","आरु नील नदी मा माछली हुती त्या सब मर गय; आरु नदी सी गंध आवने लाग गय, आरु मिसरी लोगहन नदीन पानी नी पी सकीया; आरु सारा मिसर देश मा लुहुय लुहुय हुय गयो। ");
INSERT INTO dhn_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","तव मिसर नजरबान्दा आपसा तंत्र मंत्र सी वसात् करीया; तव फिरोनन मन वातड़ो हुय गयो, आरु योहोवान कयनेन अनसारे त्यो मुसा आरु हारुनन नी मानीयो। ");
INSERT INTO dhn_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","फिरोन इना पर धियान नी दीदो, आरु मुय फिरवीन आपसा घर मा जाती रीयो। ");
INSERT INTO dhn_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","आरु सब मिसरी लोगहन पीनेन पानी क लियेन नील नदी धड़े–धड़े खुँदने लाग गीया, काहकी त्या नदीन पानी नी सकता हुता। ");
INSERT INTO dhn_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","जव सी योहोवा नील नदी को देदो तव सी लगाड़ीन सात दाहड़ा हुय गयला हुता। ");
INSERT INTO dhn_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","तव योहोवा ओळी मुसा सी कयो, \"फिरोनक पास जाईन कय, 'योहोवा तुखे इनीये रीतिये कय रीयो, म्हारी परजान लोगहन को जाने दे जिना सी कि त्या म्हारी विनता करे। ");
INSERT INTO dhn_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","पुण कदाम तु हेनको जाने नी देय ती समळ, हांव डेटकान को मोकलीन थारा सारा देश मा नुक्सान करने वाळो छे। ");
INSERT INTO dhn_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","आरु नील नदी डेटका सी भराय जासे, आरु त्या थारा भवन मा, आरु थारा आथरुन पर, आरु आदिकारीयान घरो मा, आरु थारी परजा पर, थारा चुला आरु पीठु कुसननेन परात मा बी चढ़ जासे। ");
INSERT INTO dhn_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","आरु थार पर, आरु थारी परजा, आरु करमचारिया, पर आखा डेटका चढ़ जासे।\" ");
INSERT INTO dhn_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","ओळते योहोवा मुसा को हुकुम दीदो, \"हारुन सी कय दे, कि नोंदीया, नहरोम, आरु झीलोन ऊपर लाकड़ी क साथ मा हाथ अगो कोरीन डेटकान को मिसर देश पोर चढ़ाय ली आवे।\" ");
INSERT INTO dhn_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","एकालिय हारुन मिसरन पानीन जागा पर आपसा हाथ को बढ़ायो; आरु डेटका मिसर देश पर चढ़ीन उका पर वेरवाय गया। ");
INSERT INTO dhn_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","आरु नजरबान्दा बी आपसा तंत्र मंत्र सी तिने रीतिये मिसर देश पर डेटका चढ़ाय ली आया। ");
INSERT INTO dhn_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","तव फिरोन मुसा आरु हारुन को बुलावीन कयो, \"योहोवा सी विनता करो कि त्यो इनु डेटकान को म्हार सी आरु म्हार परजा सी दुर कर देय; आरु म्हार इसराएली लोगहन क जाने दीस। जेरेसी त्या योहोवा क लिय बलिदान चोड़ावसु। ");
INSERT INTO dhn_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","तब मुसा न फिरोन सी कयो, ओतरी वात क लिय मेसे हुकुम आप दे कि हेमी तारे आरु तारा कामकोरन्या, आरु मानसो क निमित्त कोत्यार विनता कोरो, की योहोवा तारे पास सी आरु तारा घरो मा सी डेडरा क छेटा कोर, आरु त्या केवल नील नदी मा ओतरेत रोवे। ");
INSERT INTO dhn_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","हुयो कयो, “वाहने।” हुयो कयो, “तारा बुलोन क ओनसारे होयसे, जेरेसी तुख यो जानाय जाय की आमरो परमेश्वर योहोवा क जसो कोय दिसरो नी होय। ");
INSERT INTO dhn_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","आरु डेडरा तारे पास सी आरु तारा घरो म सी तारा कामकोरन्या आरु मानसे क पास सी छेटो होईन केवल नदी मा रोहसे।” ");
INSERT INTO dhn_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","तोत्यार मुसा आरु हारुन फिरोन क पास सी निकळ गोया; आरु मुसा न हेनु डेडरा क वाराम, योहोवा क विनता आप्या ज त्या फिरोन पोर मुकल्या हुता। ");
INSERT INTO dhn_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","आरु योहोवा न मुसा क कोहने क ओनसारे कोर्‌यो; आरु डेडरा घोरोम, आँगना, गाँव आरु खेतोम मा मोर गोया। ");
INSERT INTO dhn_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","आरु मिसर देशन लोगहन एकठा करीन ओको ढेर लागाड़ देदा, आरु आखा देश भुंडात गोंद सी भोराय गोयो। ");
INSERT INTO dhn_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","बाखुन जब फिरोन न देख्यो की हेमी आराम जोड़्यो छे ती योहोवा क कोहने क ओनसारे हुयो ओळी आपना मोनोक वातड़ो कोर्‌यो, आरु हेनकी नी सोमळ्यो। ");
INSERT INTO dhn_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","ओळी योहोवा न मुसा सी कोयो, “हारुन क हुकुम आप, तु आपनी लाकड़ी ओगु कोरुन धोरती क धुळा पोर दे, जेरेसी हुयो मिसर देश भरीन मा पिसाळा बोन जाय।” ");
INSERT INTO dhn_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","आरु हुये होसात कोर्या जसो; यानी हारुन न लाठी क लिन हात ओगु कोरिन धोरती क धुळा पोर देदो, ती मानसो आरु ढुरे दुयो पोर पिसाळा होय गोय, बाखुन आखा मिसर देश मा धोरती क धुळु पिसाळा बोन गोय। ");
INSERT INTO dhn_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","तोत्यार जादुगरो न चाहाय्या की आपना तंत्र-मंत्र क ताकोत सी हामु वी पिसाळा लि आवजे, बाखुन यो हेनुसी नि होय सोक्यो। ओस करीन मानसो एने डुरो दुयो पोर पिसाळा बोनी रोही, आरु होर जागे पीसाळात हुता। ");
INSERT INTO dhn_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","तोत्यार नजर बांदा फिरोन सी कोया, “यो ते परमेश्वर क हातन काम छे।” तेवी योहोवा क कहने क ओनसारे फिरोन क मोन वातड़ो होयतो गोयो, आरु हुयो मुसा आरु हारुन क वात नी मान्यो, जसो योहोवा कयो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","ओळतेन योहोवा न मुसा सी कयो, “सोंदारे उठिन फिरोन क ओगळ उबो होयनो, हुयो ते जळ क भैनी आवसे, आरु हेरेसी कोहजी, योहोवा तारेसी यो कोहे छे: मारु प्रजा क मानसो क जाने दे की हुये मारु विनता करे। ");
INSERT INTO dhn_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","काहमाइन तु मारु प्रजा क नी जाने देसे ती सोमोळ, हांव तार पोर आरु तारा कामकोरन्या आरु तारा मानसो पोर, आरु तारा घरो मा टुळुन टुळुन डांसीया मुकलीस; आरु मिसर लोगहन क घर आरु ओक रोहने क धरती वी डांसीया सी भोराय जासे। ");
INSERT INTO dhn_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","तेने दाहड़े हांव गोशेन देश क जेरेम मारी प्रजा रोहे छे ओलोग कोरिस, आरु हेरेम माखान क टुळा होयसे; जेरेसी तु जान लेय की कळीन विच मा हांवज् योहोवा छे। ");
INSERT INTO dhn_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","आरु हांव म्हार लोगहन आरु तार लोगहन मा फोरोक राकीस। यी सोहलानी चमत्कार वाहने होयसे।” ");
INSERT INTO dhn_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","आरु योहोवा न तसोत कोर्‌यो, आरु फिरोन क भवन आरु उना कामकोरन्या क घरोम मा, आरु आखा मिसर देश मा माखान टुळान टुळा भोराय गोया, आरु माखान क मारे हुयो देश नाश हुय गुयो। ");
INSERT INTO dhn_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","तोत्यार फिरोन न मुसा आरु हारुन क बुलावीन कोयो, “तुमु जाईन आपना परमेश्वर क लिय एना देश मा बलिदान चड़ावु।” ");
INSERT INTO dhn_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","मुसा न कोयो, “ओसो कोरनो वारु नी; काहकी हामु आपना परमेश्वर योहोवा क लिय मिसरियो क घाड़ायन सोमान बलिदान कोरसु; आरु काहमाइन हामु मिसरियो क देखता उना घाड़ायन सोमान बलिदान कोरजे ती काय हुये आमरे पोर दोगाड़ाटसे नी? ");
INSERT INTO dhn_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","हामु सुनला जंगल मा तिन दाहड़ा क चालो पोर जाईन आपना परमेश्वर योहोवा क लिय जसो हुयो हामरे सी कोहसे तसाज् बलिदान चड़ावसु।” ");
INSERT INTO dhn_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","फिरोन न कयो, “हांव तुमक जंगल मा जाने दिस की तुमु आपना परमेश्वर योहोवा क लिय सुनला जंगल मा बलिदान चड़ावु; पुन जादा म्हाय घुन जाता, आरु म्हार लिय विनता कोरु।” ");
INSERT INTO dhn_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","तोत्यार मुसा न कोयो, “सोमळ, हांव तारे यां सी खोयड़े जाईन योहोवा सी विनता कोरीस की माखान क टुळो तारे, आरु तारा कामकोरन्या, आरु हेका लोगहन क पास सी वाहनेत छेटो होये; बाखुन फिरोन ओगो कोरीन हामु योहोवा क लिय बलिदान करने क जाने देने क लिय मोना झुणी कोरे।” ");
INSERT INTO dhn_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","मुसा न फिरोन क पास सी खोयड़े जाईन योहोवा सी विनता कोर्‌यो। ");
INSERT INTO dhn_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","आरु योहोवा न मुसा क कोहनेन ओनसारे माखान टुळा क फिरोन, आरु उना कामकोरन्या, आरु ओकी प्रजा सी छेटो कोर्‌यो; याँ लोगुन की एक वी डांसीयो नी रोयो। ");
INSERT INTO dhn_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","तोत्यार फिरोन न एन वार वी आपसा काळ्जाक वातड़ो कोर लेदो, आरु इसरायली लोगहन क जाने नी दिदो। ");
INSERT INTO dhn_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","ओळी योहोवा मुसा को कयो, \"फिरोन क पास जाईन कय, इबरीया को योहोवा भगवान तुको इनिये रीतिये कय रीयो, कि म्हारी परजान लोगहन को जाने दे, कि म्हारी विनता करे। ");
INSERT INTO dhn_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","कदाम तु उन लोगहन को जाने नी देय आरु हेमी वी रुक रोव, ");
INSERT INTO dhn_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ती समळ, थारा जो घुल्‌ला, गोदड़ो, उटड़ा, गाय-बयल्या, गाडरा, बोकड़ा आरु घण सवटा ढुरे जो मयदान छे, उनान पर योहोवा भगवान क हाथ असो पड़से कि घण जोबोर महामारी हुयसे। ");
INSERT INTO dhn_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","ओळी योहोवा इसराएलीयान क ढुरो माईन आरु मिसरीयान ढुरोम असो फोरक पाड़ देसे कि जो इसराएलीयान छे, उनाम सी कुय बी नी मरे।\" ");
INSERT INTO dhn_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","ओळते योहोवा यो कयीन टेम टाक दीदो, \"हांव यो काम मिसर देश मा वाहनाम करीस।\" ");
INSERT INTO dhn_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","दिसरे दाहड़े योहोवा असोत् करीयो; आरु मिसरन ते आखा ढुरे मर गिया, पुन इसराएलीयान एक बी ढुर नी मरीया। ");
INSERT INTO dhn_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","आरु फिरोन लोगहन को मोकली दीदो, कि एक वी ढुर मोरलो होय की नी, पुण इसराएलीयान क ढुरो माईन एक बी नी मरलो हुतो। ते बी फिरोनन मन वातड़ो हुय गियो, आरु त्यो उन लोगहन को जाने नी दीदो। ");
INSERT INTO dhn_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","ओळी योहोवा मुसा आरु हारुन सी कयो, \"समळो दुयु भाटी माईन एक–एक मुठ रुखड़ो ली लेयो, आरु मुसा उको फिरोन क अगळ वादळा भेनी उड़ाय देय। ");
INSERT INTO dhn_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","तव त्यो रुखड़ो झीनलो धुळो बनीन आखा मिसर देश मा मानसो आरु ढुरो दुयो पर फुफला आरु फुड़ा बन निकळसे।\" ");
INSERT INTO dhn_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","अतरान करीन त्या भाटीन मुठ भरीन रुखड़ो लीन फिरोन क सामने उबा हुया, आरु मुसा उना रुखड़ा को वाहळा मा वादळा भेनी उड़ाय दीदो, आरु त्यो मानसो आरु ढुरो दुयो पर फुफला आरु फुड़ा बन गिया ");
INSERT INTO dhn_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","एकालिय उना फुड़ा न कारण नजर बांदा मुसा अगळ उबा नी रय सकीया, काहकी त्या फुड़ान सारका आखा मिसरीया पर निकळीया तसात् उन नजर बांदा पर बी फुड़ा निकळी गीया हुता। ");
INSERT INTO dhn_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","तव योहोवा फिरोनन काळ्जाक वातड़ो कर दीदो, आरु जसो योहोवा मुसा सी कलो हुतो, त्यो ओकी नी समळीयो। ");
INSERT INTO dhn_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","ओळी योहोवा मुसा सी कयो, \"सदारे उठीन फिरोन क अगळ उबो हुय जा, आरु उका सी कय इबरीयान परमेश्वर योहोवा इनीये रीते कयरियो, म्हारी पोरजान लोगहन को जाने दे, कि त्या म्हारी विनता करे ");
INSERT INTO dhn_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","अब कि बार हाव तारे पर, आरु थारा कर्मचारीया आरु तारा लोगहन आखी भातीन पीड़ा नाख दीस, जिनासी तु जानलीस कि आखी कवजुगमा मारेन तोसो कुदु नि होय। ");
INSERT INTO dhn_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","हांव ते हेमी आपसो हाथ अगो कोरीन तुको आरु तारी पोरजान लोगहन को बिमारी मरी सी मार दीतो, आरु तु धरती पर सी नाश हुय जातो; ");
INSERT INTO dhn_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","पुण छाची हांव तुको ओका लिय सी तुको जिवतलो राख रीयो कि तुको हांव म्हारी शक्ति देखाड़ो आरु म्हारो नाव नावसादियो करो। ");
INSERT INTO dhn_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","ती वी तु हेमी वी घाड़सीयो छे आरु म्हार लोगहन को जाने नी देतो। ");
INSERT INTO dhn_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","समळ हांव वाहने इनी टेम पर असा मोटा–मोटा गारा पाड़ीस, जसो मिसर देश बोनलो उना दाहड़ा सी हेमी लगुन नी हुयो। ");
INSERT INTO dhn_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","“एकालिय हेमी आपसा मानसो को मोकलीन तारा ढुरोक आरु खोयड़ान जागा उघाड़ला मा छे, उको वारला जागाम पुगाड़ दे; आरु जे लोगहन आरु ढुरे खोयड़े रोय गोयला छे, उना पोर मोटला गारा पोड़से आरु त्या मोर जासे।” ");
INSERT INTO dhn_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","अतरान करीन फिरोनन थुड़ाक चाकरीया मा जे योहोवान वचनन बीक मानता हुता, आरु त्या आपसा दास आरु ढुरोक आसरु आपने कोरीन घर मा ली आया। ");
INSERT INTO dhn_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","पुन जतरा योहोवा भगवानन वचन पर धियान नी लगाड़ीया आरु आपसा काळजा मा जागो नी आप्या, त्या आपसा चाकरीयान को आरु पशु को खयड़ा मा रयने दीदा। ");
INSERT INTO dhn_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","तव योहोवा भगवान मुसा सी कयो, \"थारो हाथ वादळा भेनी ओगो कोर कि आखा मिसर देश न मानसो, आरु ढुरे, आरु खेतोन आखी फसल आरु जोतरो निळो हुतो आखा पोर गारा पड़े।\" ");
INSERT INTO dhn_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","तव मुसा आपसी लाकड़ीक वादळा भेनी उचो कोरियो; आरु योहोवान ताकत सी वादळो गाजने लागियो आरु गारा पड़ने लाग गीया, आरु आगठो धरती पर लगुन आवतो रयो, इनीये रीतिये योहोवा मिसर देश पर गारा पाड़ीयो। ");
INSERT INTO dhn_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","जो गारा पड़ता हुता उना साथ मा विजळी बी भेसकायली हुती, आरु त्या अतरा भारी हुता कि जव सी मिसर देस बसलो हुतो तव सी आखा मिसर देश मा असा गारा नी पड़ला हुता। ");
INSERT INTO dhn_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","अतरान करीन मिसर देशन खेतो मा काय मानसे, काय ढुर, जतरा बी हुता त्या सब गारा हेनका ऊपर गारा पड़ने सी मर गिया, आरु गारा पड़ने सी खेतोन आखी फसल नाश हुय गय, आरु खोयड़ान आखा झाड़े बी टुट गीया। ");
INSERT INTO dhn_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","गोशेन परदेश मा अतरा गारा नी पड़ीया जां इसराएली लोगहन रयता हुता। ");
INSERT INTO dhn_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","तव फिरोन मुसा आरु हारुन क बुलावने मोकलीयो आरु उन लोगहन सी कयो, \"इनी वार हांव पाप करलो छे; योहोवा धरमी छे, आरु हांव आरु म्हारी पोरजा धरमी नी होय। ");
INSERT INTO dhn_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","वादळान गाजनो आरु गारा बेसका पड़ लेदा; अब योहोवा सी विनता करो; तव हांव तुमु सबन को जाने दीस, आरु नी रुको।\" ");
INSERT INTO dhn_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","मुसा फिरोन सी कयो, \"जसोज हांव नगर सी खयड़े जाईस, योहोवा भेनी आपसो हातोक उचा कोरीस, तव वादळान गाजनो बोंद होय जासे, आरु गारा नी पड़े, इना सी तु जान लीस कि यो कोळजुग योहोवा भगवानन जुन छे। ");
INSERT INTO dhn_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","ते बी हांव यो जानो, कि नी ते तु आरु नी थारा चाकरिया योहोवा भगवानन बीक माने। ");
INSERT INTO dhn_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","सन आरु जोव गँहव ते गारा पड़ने सी मर गिया, काहकी जोव गँहवन कनुस निकळी गयला हुता आरु सोन मा फुले आय गयला हुता। ");
INSERT INTO dhn_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","पुन काहनो वी गहोव नाश नी हुयो, काहकी त्या वाद मा पाके। ");
INSERT INTO dhn_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","जव मुसा फिरोन क पास सी नगरन बाहर निकळीन योहोवा भगवान भेणी आपसा हातोक ऊचो करीयो ने विनता करीयो, तव वादळान गाजनो आरु गारान पड़नो बन्द हुय गियो, आरु ओळते जादा पानी धरती पर नी पड़ीयो। ");
INSERT INTO dhn_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","पुन जव फिरोन देख्यो की गारा पोड़नो आरु वादळो गाजनो बन्द हुय गुयो, तव त्यो पोछो पाप करीयो आरु त्यो आरु हेका चाकरीया आपसा काळ्जा क वातड़ो कोर लेदा ");
INSERT INTO dhn_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","इनिये रीतिये फिरोनन मन वातड़ो हुय गयो, आरु त्यो इसराएली लोगहन को जाने नी दीदो; जसो कि योहोवा भगवान मुसान लारे कवाड़लो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","ओळी योहोवा भगवान मुसा सी कयो, \"फिरोन क पास जा; काहकी हांवत् छे जो उको आरु उना करमचारियान मन क अतरान करीन वातड़ो करीयो म्हार मोटा चमत्कारन काम उन लोगहन के वीच मा देखाड़ो ");
INSERT INTO dhn_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","आरु तुम लोगहन तुमरा पोर्या पारीन लारे एको पुरावो करो कि योहोवा भगवान मिसरीयान को कसो हासी उड़ायो आरु काय–काय चमत्कार सोहलानी उन लोगहन को वीच मा उजेन्तो करीयो; जिना सी तुमु यो जान जासु कि हांवत् योहवा छे।\" ");
INSERT INTO dhn_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","तव मुसा आरु हारुन फिरोन क पास मा जाईन कया, इबरीयान योहोवा भगवान थार सी इनीये रीतिये कय रीयो, कि तु कब तक म्हारे सामने निचळो हुयने मा संका करतो रहीस? म्हारी परजान लोगहन को जाने दे कि त्या म्हारी विनता करे। ");
INSERT INTO dhn_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","कदाम तु म्हारी परजान लोगहन को जाने नी देय तो सुन, वाहने हांव थारा देश मा टिडिया ली आवीस। ");
INSERT INTO dhn_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","आरु त्या धरती पर असा छावाय जासे कि धरती देखाय नी पड़े; आरु तुमरो जो काय बी गारा सी वाचलो छे उको त्या खाय जासे, आरु तुमरा जतरा बी झाड़े खयड़ा मा लागला छे उको बी खाय जासे, ");
INSERT INTO dhn_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","आरु त्‍या थारा आरु थारा सारा करमचारियान को, याँ तक कि आखा मिसरीयान को घरो मा भराय जासे; अतरा टिड्डिया थारा बाप-दादा बी नी देखिया हसे।\" आरु त्या मुय मुयड़ीन फिरोन क पास सी बाहर जात रीया। ");
INSERT INTO dhn_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","तव फिरोनन करमचारिया उका सी कयने लागीया, त्यो मनुस काँ लुगन हामरे लिए फंदो बनलो रयसे? उन मनुस न को जाने दे कि त्या हेनका योहोवा भगवान नी विनता करे; काय तु हाय बी नी जाने कि सारो मिसर देश नाश हुय गयलो छे? ");
INSERT INTO dhn_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","ओतरान कोरीन मुसा आरु हारुन को फिरोन क पास बुलाया, आरु त्यो मुसा आरु हारुन सी कयो, \"जावो जात रयो, तुमरा योहोवा भगवान नी विनता करो; पुन जो जाने वाळा मानसे त्या कुन–कुन छे?\" ");
INSERT INTO dhn_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","मुसा कयो, हामु ते पोर्या-पारी, गाडरा-बोकड़ा, गाय-बयल्यान क साते याँ तक कि नानला पोर्यान सी लगाड़ीन डाहला डोकरान तक आखा की आखा जासु, काहकी हामुक योहोवा भगवान क लिये तिहवार वावनो छे।\" ");
INSERT INTO dhn_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","त्यो इनीये रीतियेबुन लोगहन सी कयो, योहोवा भगवान तुमरे साथमा जव हांव तुमुक नानला पोर्यान क साथमा जाने देयो; देखो तुमरा मन मा बुराई छे। ");
INSERT INTO dhn_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","नी असो नी होये; तुमु ओदेमड़ात् जाईन योहोवा भगवान नी विनता करो, तुमको योत् जुवतो हुतो।\" आरु मुसा आरु फिरोन क अगळ सी निकाळ दिदा। ");
INSERT INTO dhn_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","तव योहोवा भगवान मुसा सी कयो, \"मिसर देश भेनी थारो हात ओगो कर कि टिडिया मिसर देश पर चहड़े आरु देशन होरीक धरतीन जतरो बी ओन छे जो गारा सी वाचला छे उको सब खाय जाय।\" ");
INSERT INTO dhn_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","एकालिय मुसा ओकी लाकुड़ को मिसर देश भेनी फिरीन हात उचो करीन अगो करीयो, तव योहोवा भगवान दाहड़ु भरीन आरु रात भरीन मिसर देश पर उगेनली वाहळी चलाड़ीयो; आरु जव भोळभाको हुयो तव उनी वाहळी मा टिडिया आया। ");
INSERT INTO dhn_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","आरु टिडियान टुळो आवीन मिसर देशन सारी जागा पर बठ गीया, हेनको टुळो घण सवटो हुतो, नी ते उना सी पेहले असा टिडिया आवला हुता, आरु नी ते हेनको बाद मा ओळी असा आवसे। ");
INSERT INTO dhn_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","त्या ते सारी धरती पर छावाय गय, याँ तक कि आखा मिसर देश मा आंधारो हुय गीयो, आरु ओको सारो ओन आरु झाड़न सब फोव, आरु जो काय गारा पड़ीन खतम हुयने सी वाचलो हुतो, त्यो सब टिडिया खाय गीया; याँ तक कि मिसर देश मा नी ते कायला झाड़ पर नीळ्ळा पोत्ता कायबी नी रीया आरु नी खयड़ा मा वाळा झाड़े आरु पवधा वाचीया। ");
INSERT INTO dhn_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","तव फिरोन उतवाळीयो मुसा आरु हारुन को बुलावीन कयो, \"हांव ते तुमरा योहोवा भगवानन सी पाप करलो छे। ");
INSERT INTO dhn_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","अतरान करीन मारो हिमलो पाप माफ करो, आरु तुमरा योहोवा भगवान सी विनता करो कि त्यो अतरोत करे कि म्हारे उपर सी इनी मोत को दुर कर देय।\" ");
INSERT INTO dhn_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","तव मुसा फिरोन क पास सी निकळीन योहोवा भगवान सी विनता करियो। ");
INSERT INTO dhn_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","तव योहोवा भगवान घण भारी वाहळी चालाड़ीन टिडियान को उड़ावीन रातला दरिया मा न्हाक दीदो, आरु मिसर देशन काहला बी जागा पर एक बी टिडियो नी रयो। ");
INSERT INTO dhn_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","तव बी योहोवा भगवान फिरोनन मन काजे वातड़ो कर दीदो, जिना सी त्यो इसराएलीयान को जाने नी दीदो। ");
INSERT INTO dhn_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","ओळी योहोवा भगवान मुसा सी कयो, थारो हात सोरगन भेणी बढ़ाव कि मिसर देश पर आंधारो हुय जाय, असो आंधारो कि हात सी टुटळाये।\" ");
INSERT INTO dhn_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","तव मुसा आपसो हात सोरग भेणी बढ़ायो, आरु सारा मिसर देश मा तीन दाहड़ा तक बेसको आंधारो हुयलो रयो। ");
INSERT INTO dhn_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","मसर देशन मानसे तीन दाहड़ा तक नी ते कोय कुदान को देखियो, आरु नी कोय आपसा जागा सी उठीयो; पुण सारा इसराएलीयान घरो मा विजाळो रीयो। ");
INSERT INTO dhn_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","तव फिरोन मुसा क पास बुलावीन कयो, \"तुम लोगहन जावो, योहोवा नी विनता करो; तुमरा पोर्या-पारीन को बी सात मा ली जावो; तुमरा गाडरा-बोकड़ान को अतरा यात रयने देयो।\" ");
INSERT INTO dhn_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","मुसा फिरोन सी कयो, \"तुको हामरे हात मा मेलबलि आरु होमबली बी आपनो पड़से, जिनको हामु हामरा योहोवा भगवान क लिए बलिदान चढ़ावासु। ");
INSERT INTO dhn_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","अतरान करीन हामरा ढुरे बी हामरे साते जासे, हेनको एक खुर बी याँह नी रये, काहकी उना मा सी हामुक हामरा योहोवा भगवान क लिए आराधना करनेन सामान लेनो छे। आरु हामु जव तक वाँ सारी नी पुग जाजे तव तक हामुक नी मालोम हय कि काय–काय लीन योहोवा भगवान नी विनता करनो पड़से।\" ");
INSERT INTO dhn_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","पुण योहोवा भगवान फिरोनन मोन को वातड़ो कर दीदो, जिना सी त्यो उन लोगहन को जाने नी दीदो।\" ");
INSERT INTO dhn_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","तव फिरोन मुसा सी कयो “म्हार सामने सी जात रय; आरु चोकचोळीयो रयजी; मखे थारो मुय पछो झुण देखड़े; काहकी जिने दाहड़े तु मखे मुय देखाड़ीस उनी दाहड़े तको मार न्हाखसु।” ");
INSERT INTO dhn_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","मुसा कयो, तु वारुत् कयो; हांव थारा मुय को कदी पछो नी देखो।\" ");
INSERT INTO dhn_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","ओळी योहोवा भगवान मुसा सी कयो, एक आरु पीड़ा हांव फिरोन आरु मिसर देश पर न्हाको, तव‍‍ त्यो तुम लोगहन को वाँ सी जाने देसे, आरु जव त्यो तुम लोगहन को जाने देय तव तुमु सबन को पाक्‌कोत् निकाळ देसे। ");
INSERT INTO dhn_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","म्हारी परजान लोगहन को म्हारो यो हुकुम समळाड़ कि एक–एक ओदमी आरु एक–एक बाय लोग आपसी साते वाळा सी सोना–चाँदीन गयनो मांग लेय।\" ");
INSERT INTO dhn_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","तव योहोवा भगवान मिसरियान को आपसी परजान क लोगहन पर दया वाळा बनायो। आरु इना सी त्यो मनुस मुसा मिसर देश मा फिरोनन करमचारिया आरु पंचु लोगहन क नजर सामने घणो मोटो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","ओळते मुसा न फिरोन सी कयो, योहोवा भगवान इनीये रीतिये कय रीयो, कि आदीक रातन टेमे हांव मिसर देशन वीच मा सी चालीस। ");
INSERT INTO dhn_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","तव मिसर देश मा राजगाद्दी पर बठने वाळा फिरोन सी लगाड़ीन चक्की दोळने वाळी पावेरनीन तक पेहल खुळीया याँ तक कि पशुन बी पेहलो पयदा मर जासे ");
INSERT INTO dhn_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","आरु सारा मिसर देश मा घणो मोटो विखो पड़जासे, या तक कि ओको सारको नी ते कदी हुयो आरु नी हुये। ");
INSERT INTO dhn_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","पुन इसराएलीयान विरुध्द मा, काय मनुस, काय पशु, कुदा पर बी कुदु कुतरो बी नी भोकसे; जिना सी तुम लोगहन जान जासु कि मिसरिया आरु इसराएलीया मा हांव योहोवा नेवाड़ो पाड़ो। ");
INSERT INTO dhn_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","तव थारा ये सब करमचारिया म्हारे पास आवीन मखे वान्दीन यो कयसे, थारा आखा लोगहन क साथ मा निकळी जा।' तव हांव निकळी जाईस यो कहीन मुसा फिरोन क पास सी घणो किचवाईन निकळी गीयो। ");
INSERT INTO dhn_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","योहोवा मुसा सी कय दीयो हुतो, \"फिरोन तुमरी वात नी समळे; काहकी म्हारी यी मरजी छे कि मिसर देश मा घण सवटी सोहलानी देखाड़ो।\" ");
INSERT INTO dhn_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","मुसा आरु हारुन फिरोनन सामने यी घण सवटी विनछेळाय सोहलानी देखाड़ीया; पुन योहोवा भगवान फिरोन क मन को आरु वातड़ो कर दीदो, अतरान करीन त्यो इसराएलीयान को उना देश को छुड़ी जाने नी दीदो। ");
INSERT INTO dhn_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","ओळी मिसर देश मा योहोवा भगवान मुसा आरु हारुन सी कयो, ");
INSERT INTO dhn_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","यो मयनो तुम लोगहन क लिये पेहलो टाकायसे; मतलब यो कि सालोन पेहलो मयनो यो टाकायलो रयनो जुवे। ");
INSERT INTO dhn_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","इसराएलन सारी मण्डळी सी इनीये रीतिये कयो, कि इना मयनान दसवा दाहड़ाक तुम लोगहन तुमरो डाहडान घरानान अनसारे, घरो पछोळ एक–एक गाडरो लीन राखो। ");
INSERT INTO dhn_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","आरु कदाम काहला घरो मा एक गाडराक खानेन करीन मनुस कम हय, ती त्यो आपसे साते रयने वाळा फळेन लोगहन क सात मा जीवोन गिनतीन अनसारे एक गाडरो लीन राखे; आरु तुमु आखा क लियेन खानेन अनारे गाडरान हिसाब करजो। ");
INSERT INTO dhn_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","तुमरो गाडरो विनगुनाको नी आरु पेहले सालोन नर हुयनो जुवे, आरु उको चाहे गाडरा माईन लेजो चाहे ती बुकड़ा माईन। ");
INSERT INTO dhn_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","आरु इना मयनान चोवदे दाहड़ा तक उको मेल राखजो, आरु उना दाहड़े शांतन टेम पर इसराएलन सारी मण्डळीन लोगहन उको बली कर। ");
INSERT INTO dhn_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","तव उना लुहुय माईन थुड़क लीन जिना घर मा गाडरान को खास हेनका झपला दुय धड़े चोखट पर लगाड़जो। ");
INSERT INTO dhn_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","आरु त्या ओको मास को उनी रात आगठा मा चुयनीन पान्यान रोटान क सात मा आरु कड़वा भाजी क सात मा खानो। ");
INSERT INTO dhn_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","उको मुनका, पाय आरु आतड़ियान क सात मा आगठाम चुयनीन खाजो काचलो या पानी मा थुड़क पकाड़ीन नी खानो। ");
INSERT INTO dhn_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","आरु उना माईन थुड़क बी संदारे तक नी रयने देजो, आरु कदाम संदारे तक रय बी जाय, ती उको आगठाम धपाड़ देजो। ");
INSERT INTO dhn_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","आरु उको खानेन रीति यी छे: कि कड़ीयाम बांध लेय, पाय मा खासड़ा पेहर लेय आरु हात मा लाकड़ी लीन उको उतावाळीया खाजो; त्यो ते योहोवा भगवानन तिहवार हुयसे। ");
INSERT INTO dhn_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","काहकी उनी रात मा हांव मिसर देशन वीच मा रईन जाईस, आरु मिसर देशन काय मानसे, काय ढुर, सबन पेहला खुळीयान को मारीस; आरु मिसर देशन सारा देवतान को बी हांव डन आपीस;हांव ते योहोवा छे। ");
INSERT INTO dhn_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","आरु जिना घरो मा तुमु रयसु उना घर पर‍ त्यो लुहुय तुमरे लिये सोहलानी बनसे; मतलब हांव उना लुहुय को देखीन तुमको छुड़ीन जात रईस, आरु जव हांव मिसर देशन लोगहन को मारी, तव त्यो पीड़ा तुमरे उपर नी पड़े आरु तुमु नाश नी हुयो। ");
INSERT INTO dhn_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","आरु त्यो दागड़ो तुमुक फोम देवाड़ने वाळो रयसे, आरु तुमु उको योहोवा भगवान क लिये तिहवार करीन मनावजो;‍ त्यो तुमरी पीड़ी क लियन जलोमकी रीति जानीन तिहवार को मनावजो। ");
INSERT INTO dhn_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","परमेश्वर कयो, \"सात दाहड़ा तक अखमीरी रोटो खाया करजो, उनाम सी पेहलेत दाहड़े तुमरा घरो मा सी खमीर चुट लेजो, याँ तक कि जो पेहले दाहड़े सी लगाड़ीन सातवे दाहड़े तक कोय खमीरी चीज को खाजे, उना जीवड़ो इसराएल मा सी नाश होय जासे। ");
INSERT INTO dhn_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","पेहले दाहड़े एक चुखली मीटिंग, आरु सातवे दाहड़े बी एक चुखली मीटिंग करजो; तनी दुयु दाहड़ा मा कोय बी काम को नी करनो हय; पुण अतरोत कि जिना जीवड़ा को जो खानो छे ओको चो ओतरोत तुमु रांद सोकतला। ");
INSERT INTO dhn_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","अतरान करीन तुमु बीना खमीरन रोटान तिहवार मनावजो, काहकी उना दाहड़े यो मानो कि हांव तुमुक टुळुन टुळु करीन मिसर देश मा सी निकाळ्ळो छे; इना कारण सी त्यो दाहड़ो तुमरी पीड़ी मा जलोमकी रीति जानीन मनावजो। ");
INSERT INTO dhn_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","पेहला मयनान चोवदे दाहड़ान सान्तो सी लगाड़ीन इक्कीस दाहड़ान सान्तो तक तुमु अखमीरी रोटो खाया करजो। ");
INSERT INTO dhn_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","सात दाहड़ा तक तुमरा घरो मा काय बी खमीर नी वाचणो जुवे, पुण जो काय काहली खमीरी चीज को खाय, चाहे त्यो देशी हय चाहे पारको, त्यो आखा मानसे इसराएली लोगहन मा रईन नाश हुय जासे। ");
INSERT INTO dhn_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","कोय खमीरी चीज को नी खानो, तुमरा घरो मा विगुर खमीरन रोटो खाया करजो।\" ");
INSERT INTO dhn_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","तव मुसा इसराएलीन सब डाहडान को बुलावीन कयो, \"तुमु तुमरा आपसा कुलन अनसारे एक–एक गाडरो अलग करीन राखो, आरु फसहन गाडरो बलिदान करजो। ");
INSERT INTO dhn_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","आरु उको लुहुय जो वाटका मा हुयसे उना मा एक गछळो डुबाड़ीन उना तसला माईन लुहुय को झपलान चुखट कुना आरु दुयु धड़ मा थुड़ोक लगाड़जो; आरु भोळ भाका तक तुमरे माईन कोय घर सी बाहर झुण निकळता। ");
INSERT INTO dhn_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","काहकी योहोवा भगवान मिसर देशन वीच मा रईन मिसरीयान को मारतो जासे; अतरान करीन जाँ सारीक त्यो चुखोटन कुना, आरु दुयु धड पर उना लुहुय को देखसे, वाँ सारीक त्यो झपला को छुड़ीन जात रयसे, आरु नाश करने वाळा को तुमरा घरो मा मारने करीन जाने नी देय। ");
INSERT INTO dhn_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","ओळते तुमु इनी रीति को तुमरे आरु तुमरी ओवलियाद क लिये जोलमकात रिति जानीन मानीया करो। ");
INSERT INTO dhn_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","जव तुमु उना देशम मा जिनाक योहोवा कि कयनेन अनसारै तुमुक आपसे भरायजो, तव ज्यी रितीन पाळनी पाळजो। ");
INSERT INTO dhn_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","आरु जव तुमरा पोर्या वाळा तुमरे सी पुछे, कि इनी रिती सी तुमरा काय मतलब छे?' ");
INSERT INTO dhn_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","तव तुमु हेनको यो जवाब देजो, योहोवा जो मिसरीयान को मारनेन टेमे मिसर मा रयने वाळा हामु इसराएलीयान घरोक वाचाड़ीयो इना कारण सी उका लिये फसहन यो बलिदान करजो।\" तव लोगहन मुनका झुकाड़ीन आराधना कोरीया। ");
INSERT INTO dhn_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","तव त्या इसराएलीया लोगहन जाईन, जो हुकुम योहोवा मुसा आरु हारुन को आपलो, उनात् अनसारे करीया। ");
INSERT INTO dhn_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","असो हुयो कि आदी राती योहोवा मिसर देश मा राजगाद्दी पर बसीन राज करने वाळा फिरोन सी लगाड़ीन जेलोम मा पड़ला केदड़ा लगुन सबन पेहल खुळीया को, याँ तक कि पशुन पेहल खुळीयान को बी मार न्हाकीयो। ");
INSERT INTO dhn_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","आरु फिरोन रातो मा उठीन बठो हुयो, आरु सब करमचारिया, याँ तक कि सारा मिसर वाळा उठ गीया; आरु मिसर वाळा आखान या मोटो विखो हुयो, काहकी एक बी घर असो नी हुतो जिनाम मोत नी हय। ");
INSERT INTO dhn_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","तव फिरोन रातो मा मुसा आरु हारुन को बुलाईन कयो, तुमु इसराएलीयान को लीन म्हारी परजान वीच मा रईन निकळीन जात रय; आरु थारे कयुनेन अनसारे जाईन योहोवा भगवानन विनता कर। ");
INSERT INTO dhn_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","थारे कयने अनसारे थारा गाडरा–बोकड़ान आरु गाय–बयलीयान को सात मा ली जावो आरु मखे सोयबरकत कय जावो।\" ");
INSERT INTO dhn_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","आरु मिसरी जो कयता हुता, हामु ते सब मरीन खतम हुय गीया; त्या इसराएली लोगहन पर दबाव बनावीन कया, \"इना देश सी उतवाळीयात् निकळीन जात रयो।\" ");
INSERT INTO dhn_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","तव त्या हेनको परातियान मा कुसनला पीठा को बीना खमीर को टाहरा क सात मा छिंदरा मा बाँधीन आपसा–आपसा खांदा पर न्हाक लीदा। ");
INSERT INTO dhn_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","इसराएलीया मुसान कयनेन अनसारे मिसरीया सी सोना–चाँदीन गयनो आरु छिंदरा मांग लीदा। ");
INSERT INTO dhn_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","आरु योहोवा भगवान मिसरीयान को ओकी परजान लोगहन पर दयाळा बना दीदो कि त्या जो–जो मांगीया त्यो सब हेनको आप दीदा। इनीये रीतिये इसराएलीया मिसरीयान को लुट लीदा। ");
INSERT INTO dhn_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","तव इसराएली लोगहन रामसेस सी थुड़ाक अगा जाईन सुक्कोत मा जात रीया, आरु नानला पोर्यान आरु बायरा को छुड़ीन छव लाख पाये चालीन जानेवाळा ओदेमड़ा हुता। ");
INSERT INTO dhn_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","हेनका सात मा दिसरा जे इसरायली नु हुता। भेसकायलु टुळु गयु, आरु गाडरा–बोकड़ा, गाय–बयलीया, घण सवटा जीव जनवारीया बी गिया। ");
INSERT INTO dhn_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","आरु जो कुसनलो पीठो हुतो उको त्या मिसर सी सात मा ली गीया कि ओकी त्या वीन खमीरन रोटा बनाया; काहकी त्या मिसर सी असा उतवाळीया निकळी गीया, कि हेनको टेम बी नी जड़ीयो कि वाट्‌ये खाने करीन थुड़ोक खानो बनायलेय, इना कारण सी त्या विगुर खमीरन कुसनलो पीठो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","मिसर मा रयने वाळा इसराएलीयान को चार सोव तीस साल वीत गयला हुता। ");
INSERT INTO dhn_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","आरु उना चार सोव तीस सालोन वीतने पर, ठीक उना दाहड़े, योहोवा भगवानन सारी सेना मिसर देश सी निकळी गय। ");
INSERT INTO dhn_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","योहोवा इसराएलीयान को मिसर देश सी निकाळ लायो, इना कारण त्यी रात उको फोम करने लीयन छे यी योहोवान त्यो रात छे जिनाक पीढ़ी–पीढ़ी मा माननो इसराएलीयान क लिये पाकी छे। ");
INSERT INTO dhn_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","ओळते योहोवा मुसा हारुन सी कयो, \"तिहवार न रीति यी छे; कि कोय पारका देशन उना माईन नी खानो; ");
INSERT INTO dhn_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","पुण जो कुय मुले लीदलो पावर हय, आरु तुम लोगहन उको चामड़ो काटीन नक करला हय ती त्यो खाय सकतलो। ");
INSERT INTO dhn_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","पारका देश वाळो आरु दाहड़कीयो उना माईन नी खानो। ");
INSERT INTO dhn_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","उको खानो एकुज घर मा हुयनो जुवे; मतलब तुमु उना मास माईन थुड़ोक बी घर सी खयड़े नी ली जानो; आरु बली करला गाडरान हाड़की झुण तोड़ता। ");
INSERT INTO dhn_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","तिहवार को माननो इसराएलन सारी मण्डळीन काम छे। ");
INSERT INTO dhn_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","आरु कदाम कोय पारका देशम वाळो तुमरे सात मा रयीन योहोवा क लिये तिहवार मनावने करे, ती त्यो उना याँ रयने वाळा सब ओदमीन को फातोरकाती करावे, तव त्यो साते आवीन उको माने; आरु त्यो पारका देश वाळा मनुस को सारको हुयसे। पुण कुय वीना नक करलो ओदमी उना माईन नी खानो जुवे। ");
INSERT INTO dhn_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","ओको रीति देशी आरु तुमरे वीच मा रयने वाळा पारका देश वाळानज दुयोन एक हुयनो जुवे।\" ");
INSERT INTO dhn_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","यो हुकुम जो योहोवा मुसा आरु हारुन को आपलो उको अनसारे सारा इसराएलीया करीया। ");
INSERT INTO dhn_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","आरु ठीक उना दाहड़े योहोवा इसराएलीयान को मिसर देश सी टुळुन–टुळु करीन निकाळ ली गयो। ");
INSERT INTO dhn_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","ओळते योहोवा मुसा सी कयो, ");
INSERT INTO dhn_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","\"काय मनुसन, काय ढुरन, इसराएलीया मा जतरा बी आपसी–आपसी माय को पेहल खुळीयो हय, उको म्हारे लिये चुखलो मानुस, त्यो ते म्हारोत् छे।\" ");
INSERT INTO dhn_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","ओळते मुसा लोगहन सी कयो, \"इना दाहड़ा को फोम राखो, जिना मा तुम लोगहन बांधायला हुता, मतलब मिसर सी निकळीन आवला छे; योहोवा ते तुमुक वाँ सी उका हातन ताकत सी निकाळ लावु; इना मा खमीरोन रुटा नी खानो। ");
INSERT INTO dhn_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","अबीब न मोहना मा आजुन दाहड़े तुमु निकळ्ळा छे। ");
INSERT INTO dhn_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","अतरान करीनज जव योहोवा तुमुक कनानी, हित्ती, एमोरी, हिव्वी, आरु यबुसी लोगहन क देश मा पुगाड़से, जिनाक आपने त्यो तुमरा वेगला डाहडा सी वायदो कोरलो हुतो, आरु जिनाम दुधन आरु माहवन धार उहवे, तव तुमु इने मयने विनता न तिहवार मनावजो। ");
INSERT INTO dhn_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","सात दाहड़ा तक अखमीरी रोटो खाया करजो, आरु सातवे दाहड़े योहोवा भगवान क लिये तिहवार मनावजो। ");
INSERT INTO dhn_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","इनु सात दाहड़ा मा अखमीरी रोटो खाजो, आरु तुमरा आखा देशम नी खमीर वाळा रुटा, नी खमीर तुमरे जुळ देखायनो जुवे। ");
INSERT INTO dhn_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","आरु उना दाहड़े तुमु तुमरा पोर्यान को यो कयीन समझाड़ देजो, कि यो ते हामु उना काम क कारण करजे, जो योहोवा हामरे मिसर देश सी निकळनेन टेमे हामरे लिये करलो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","ओळते यो तुमरे लिये तुमरा हातो मा एक सोहलानी हुयसे, आरु तुमरा दुळान सामने फोम करावने वाळी चीज हयसे; जिना सी योहोवान नियम तुमरा मुय पर रये काहकी योहोवा भगवान तुमुक उना ताकत वाळा हातो सी मिसर देश सी निकाळ्ळो छे। ");
INSERT INTO dhn_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","अतराज कोरीन तुमु इना नियम को सालो डीट टेमे-टेमे मानीया करजो। ");
INSERT INTO dhn_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","\"ओळी जव योहोवा भगवान उनी कसम क अनसारे, जो त्यो तुमरा वेगला डाहडा सी आरु तुमरे सी बी खादलो छे, तुमुक कनानीयान देश मा पुगाड़ीन उको तुमुक आप देसे, ");
INSERT INTO dhn_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","तव तुमरे माईन जतरा आपसी–आपसी मायन मोटलो पोर्‌यो छे, आरु तुमरा पशु माईन जो असा हय उको बि योहोवा भगवान क लिये अर्पण करजो; सब नर बच्चे हय तो योहोवान छे। ");
INSERT INTO dhn_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","आरु गोदड़ीन हर एक पेहल खुळीयान बदले गाडरो आपीन उको छुड़ाय लेजो, आरु कदाम तुमुक उको नी छुड़ाव हय ती उको गळो तुड़ देजो। पुन मानसोन सब पेहल खुळीया पोर्यान क बदलो दीन छुड़ाय लेजो। ");
INSERT INTO dhn_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","आरु आवने वाळा दाहड़ा मा जव तुमरा पोर्या तुमरे सी पुछे, 'यो काय छे?' ती उन सी कयजो, योहोवा हामुक आखा लोगहन को बन्दीन घर सी मतलब मिसर देश सी उका हातोन ताकत सी निकाळ लावलो छे। ");
INSERT INTO dhn_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","उना टेमे मा जव फिरोन वातड़ो हईन हामुक जाने नी देतो हुतो, तव योहोवा न मिसर देश मा मानसो सी लीन ढुरन लगुन आखान पेहला खुळ्याक मार नाख्यो। एकालिय ढुरो मा सी जोतरा आपसी माय क पेहला खुळ्या नर छे, हेको हामु योहोवा क लिय बलिदान कोरे; पु आपसा आखा पेहला खुळ्या पुर्या क हामरे बोदले आपीन छुड़ाय लेये। ");
INSERT INTO dhn_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","यो तुमरे हातो पर एक सोहलानी आरु पापनीया वीच मा टीका सारको बनसे; काहकी योहोवा हामुक मिसर देश सी उना हातोन ताकत सी लावलो छे।\" ");
INSERT INTO dhn_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","जव फिरोन लोगहन को जानेन हुकुम दियो, तव कदाम पलिश्तियान देश मा हईन जो रस्तो जाय त्यो नानलो हुतो; ते बी योहोवा भगवान यो सोचीन उनी वाट सी नी ली गयो कि असो नी हुय जाय कि जव या लोगहन लड़ाई देखे ती कदाम मिसर मा पछा जात रये। ");
INSERT INTO dhn_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","अतरान करीन परमेश्वर उन लोगहन को भंगलाड़ीन रातला दरियान जंगलो माईन ली गयो। आरु इसराएली टुळुन टुळु मिसर सी निकळी गीया। ");
INSERT INTO dhn_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","आरु मुसा युसुफन हाड़कान को सात मा लेतो गीयो; काहकी युसुफ इसराएलीया सी यो कयीन कि योहोवा भगवान छाची तुमुख फोम करसे,' उन लोगहन इनी वातोन वाराम कसम खावड़लो हुतो कि उना हाड़कान को हेनका सात मा लेता जाय। ");
INSERT INTO dhn_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","ओळते त्या सुक्कोत सी थुड़ाक अगा जाईन जंगलोन छेळ पर एताम मा रुकीया। ");
INSERT INTO dhn_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","आरु योहोवा हेनको दिसु वाट देखाड़ने करीन वादळान खाम्बा मा, आरु राती विजाळो आपने करीन आगठान खाम्बा मा हयीन हेनका ओगळ–ओगळ चालतो जातो हुतो, जिना सी त्या राती आरु दाहड़ाम दुय मा चाल सके। ");
INSERT INTO dhn_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","त्यो नी ते वादळान खाम्बाक दिसु आरु नी ते आगठान खाम्बाक रात मा लोगहन क ओगळ सी छेटो करीयो। ");
INSERT INTO dhn_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","योहोवा मुसा सी कयो, ");
INSERT INTO dhn_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","\"इसराएलीयान को हुकुम दे, कि त्या पछा आवीन मिग्दोल आरु दरियान वीच मा पीहहीरोतन साने बालसपोन न सामने आपसो तम्बु कोरे, ओकोत् ओगळ दरियान धड़े तम्बु करे। ");
INSERT INTO dhn_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","तव फिरोन इसराएलीयान वाराम विचार करसे, त्या ओनजान देश मा भंगलायीन घबराय गयला छे, सुनसान पोरदेश मा हेनको बन्दि बोनाय लेदला छे। ");
INSERT INTO dhn_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","तव हांव फिरोन क मन को वातड़ो कर दीस, आरु हेनको पछोळ पड़से, तव फिरोन आरु ओकी सारी सेनान लारे म्हारी मोहिमा हुयसे; आरु मिसरी जान जासे कि हांव योहोवा छे।\" आरु त्या वसात् करिया। ");
INSERT INTO dhn_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","जव मिसरन राजा को यो खबर मिळी कि त्या लोगहन ढास गीया, तव फिरोन आरु उका करमचारियान मन हेनका विरोध मा उल्टो हुय गीयो, आरु त्या कयने लाग गीया, \"हामु यो काय करीया, कि इसराएलीयान को ओकी सेवा चाकरी सी छुटकारो आपीन जाने दीदो। ");
INSERT INTO dhn_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","तव त्यो उको रथ तियार करायो आरु आपसी सेना को पुठी ली गीयो। ");
INSERT INTO dhn_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","त्यो छव सोव वारु सी वारु घुड़सवारी मिसर न आखी घुड़सवारी लीन आरु हेनु आखा पर सरदार बठाड़ीयो। ");
INSERT INTO dhn_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","आरु योहोवा भगवान मिसरन राजा फिरोनन मन को वातड़ो कर दीदो। अतरान करीन त्यो इसराएली लोगहन पछोळ पड़ीयो; पुण इसराएली ती नीचळात् निकळीन जाता हुता। ");
INSERT INTO dhn_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","पुण फिरोनन सब घुल्‌ला, आरु घुड़सवारो क पुठी मिसरी सेना हेनको पछोळ पड़ीन हेनका पास, जो पीहहीरोत क पास, बालसपोन क सामने, दरियान धड़े तम्बु डालीन पड़ला हुता, वाँ सी जाय पुगीया। ");
INSERT INTO dhn_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","जव फिरोन साते आयो, तव इसराएलीयान ढुळा उगाड़ीन देखीया, कि मिसरी हामरे पछोळ पड़ीन आय रीया; आरु इसराएली घण बिह गीया, आरु आयड़ीन योहोवा भगवानन विनता करीया। ");
INSERT INTO dhn_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","आरु त्या मुसा सी कयने लाग गीया, \"काय मिसर मा बीड़ा नी हुता जो तु हामुक वाँ रईन मरने करीन जंगलो मा ली आयो? तु हामरे साते यो काय करीयो कि हामुक मिसर देश सी निकाळ लायो? ");
INSERT INTO dhn_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","काय हामु थार सी मिसर देश मा रईन यी वात नी कया कि हामुक रयने दे कि हामु मिसरीयान सेवा चाकरी करजे? हामरे लिये ते मरने सी मिसरीयान सेवा करनो वारलो हुतो।\" ");
INSERT INTO dhn_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","मुसा लोगहन सी कयो, बिहयो मा, उबा रईन त्या छुटकारान काम देखो, जो योहोवा भगवान आज तुमरे लिये करसे; काहकी जिनु मिसरीयान को आज तुमु देख रीया, हेनको ओळी पोछा कदी नी देखु। ");
INSERT INTO dhn_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","योहोवा भगवान आपसुत् तुमरे लिये लड़से, अतरान करीन तुमु हुगा रयो।\" ");
INSERT INTO dhn_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","तव योहोवा भगवान मुसा सी कयो, \"तु काय लेने मखे आयड़ी रीयो? इसराएलीयान को हुकुम दे कि याँ सी थुड़ोक काहय करे। ");
INSERT INTO dhn_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","आरु तु थारी लाकड़ी थारो हात दरियान उपर अगो बढ़ाव, आरु‍ त्यो दुय वाटा हुय जासे; तव इसराएली दरियान वीच मा रईन सुकली धरती परुत् चालीन जात रयसे। ");
INSERT INTO dhn_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","आरु समळ, हांव मिसरीयान मन को वातड़ो करो, आरु त्या हेनका पछोळ पड़ीसे। तव फिरोन आरु हेका मानसे दरिया मा भराय जासे, तव फिरोन आरु ओकी सेना, आरु घुड़सवारीन लारे म्हारी मोहिमा हुयसे। ");
INSERT INTO dhn_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","आरु जव फिरोन, आरु उका घुल्‌ला गाड़ी, आरु सवारोन लारे म्हारी मोहिमा हुयसे, तव मिसरी जान लेसे कि हांव योहोवा भगवान छे।\" ");
INSERT INTO dhn_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","तव योहोवा भगवान को दुत जो इसराएली सेना क अगोळ–अगोळ चालतो जातो हतो हेनको पछोळ हुय गीयो; आरु वादळान खाम्बो हेनको अगोळ सी हेनको पछोळ जाय पुगीयो। ");
INSERT INTO dhn_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","इने रीतिये त्यो मिसरी सेना आरु इसराएली सेनान वीच मा आय गीयो; आरु वादळो आरु आंधारो ते हुयो, ते बी आगठान खाम्बा सी हेनको विजाळो जड़तो रीयो; आरु त्या रात भरीन एक दीसरान क पास म नी आया। ");
INSERT INTO dhn_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","तव मुसा उको हात दरियान उपर अगो करीयो; आरु योहोवा भगवान रात भरीन घण भारी हवा चालाड़ीयो, आरु दरिया को पानी दुय वाटा मा वाटाय गुयो पोरबु दरिया सुकलो जागो बोनाय देदो। ");
INSERT INTO dhn_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","तव इसरायली दरियान वीच मा धरती पर चालीन जात रीया, आरु पानी हेनके जेवड़े आरु डाखरीये दुयु तरफ भीतन तसो हुय गीयो आरु भीतन काम करतो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","तव मिसरी लोगहन, मतलब कि फिरोनन सब घुल्‌ला, घुड़सवारी, आरु सवार हेनको पछोळ पड़ीन दरियान वीच मा जात रीया। ");
INSERT INTO dhn_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","आरु रातन छेहला पेहराम योहोवा भगवान वादळान आरु आगठान खाम्बा मा रईन मिसरीया पर नजर न्हाखीन हेनको घबराय दीदो। ");
INSERT INTO dhn_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","आरु त्यो हेनकी घुड़सवारीन चाकटाक निकाळ दीदो, जिना सी हेनको चालनो काठो हुय गीयो; तव मिसरी एक दीसरा सी कयने लाग गीया; आवो हामु इसराएलीयान क अगळ सी ढास जाजे; काहकी योहोवा भगवान हेनका भेनी रईन मिसरीयान विरुद मा लड़ाय कर रीयो।\" ");
INSERT INTO dhn_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","ओळते योहोवा भगवान मुसा सी कयो,\" थारो हात दरियान उपर बढ़ाब, कि पानी मिसरीया, आरु हेनकी घुड़सवारी, आरु सवार पर ओळी पछो उहवे तसे। ");
INSERT INTO dhn_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","तव मुसा उको हात दरियान उपर करीयो आरु भळभाको हयता–हुयता काय हुयो कि दरियो ओळी जसो हुतो तसो हुय गीयो आरु आपसा जागा पर आय गीयो; आरु मिसरी उलटा ढ़ासने लाग गीया, पुण योहोवा भगवान हेनको दरियान वीच मात् उहवाड़ दीदो। ");
INSERT INTO dhn_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","आरु पानीन पछो पलटने सी, जतरी घुड़सवारी आरु सवार इसराएलीयान पछोळ आवला हुता, त्या सब आरु फिरोनन सारी सेना उका मा डूब गुया, आरु उका माईन एक बी नी वाचीयो। ");
INSERT INTO dhn_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","पुण इसराएली दरियान वीच मा धरती पोर चालीन जात रीया, आरु पानी हेनके जेवड़े आरु डाखरीये दुयु धड़े भीतन बनीन उबो रयो। ");
INSERT INTO dhn_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","इनीये रीतिये योहोवा भगवान उना दाहड़े इसराएलीयान को मिसरीयान क हकोम रईन छुड़ायो; आरु इसराएलीया मिसरीयान को दरियान धड़े काठा पर मरला पड़ रयला देखीया। ");
INSERT INTO dhn_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","जव इसरालियो न मिसर क रोहने वाला पोर योहोवा न आपसी ताकोत देखाड़ीयो, तव त्या बिहने लाग्या ती हेका सेवक मुसा पोर विश्वास कोरीया। ");
INSERT INTO dhn_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","तव मुसा आरु इसराएलीया योहोवा भगवान क लिये यो गीत गाया। त्या कया, \"हांव योहोवान गीत गावीस, काहकी त्यो आखा सी मोटो छे; त्यो घुल्‌लान क सात मा घुल्‌ला सवार को त्यो दरिया मा उहवाड़ दीदो। ");
INSERT INTO dhn_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","योहोवा परमेश्वर म्हारी ताकत आरु भजनन दाखुलु छे, आरु‍ त्योत् म्हारो छुड़ावने वाळो बी बनीयो; म्हारो योहोवा भगवान त्योत् छे, हांव उकोत् गीत गावीन भक्ती करीस, हांव योहोवा भगवान क लिये रयनेन जागो बनावी, म्हारा वेगला डाहडान योहोवा भगवान त्योत् छे, हांव उकोत् भाळतो रयीस। ");
INSERT INTO dhn_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","योहोवा लड़ाय मा जीतनियो छे; उको नाव योहोवा छे। ");
INSERT INTO dhn_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","त्यो फिरोनन घुड़सवार आरु सेना को दरिया मा न्हाक दीदो; आरु उका वारु सी वारली घुड़सवारी आरु आधिकारी रातला दरिया मा डूब गीया। ");
INSERT INTO dhn_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","उण्डो पानी हेनको ढाक लीदो; त्या दगड़ा सारका उण्डला जागाम डूब गीया। ");
INSERT INTO dhn_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","ए योहोवा, थारो जेवड़ीयो हात ताकोत मा मोटो हुयो ए योहोवा, थारो जेवड़ीयो हात जोम वेरी को झीनो कर देय। ");
INSERT INTO dhn_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","तु थारा विरुधियान को थारी मोटी ताकत सी पाड़ देय; तु थारी रीस को भड़कावे, आरु त्या झीनला झीकटन सारका भसम हुय जाय। ");
INSERT INTO dhn_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","थारा नाकन दोम सी पानी एखटो हुय गीयो, पानीन धार ठेळान तसी एक जागे उबी हुय गय; दरियान वीच मा उण्डो पानी जम गीयो। ");
INSERT INTO dhn_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","वेरी जोम कयो, हांव जाईन धरीस, हांव लुटलो माल को वाट लीस, उका सी म्हारो जीव भराय जासे। हांव म्हारी तरवार हापकीन म्हार हात सी हेनको नाश कर दीस। ");
INSERT INTO dhn_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","तु थारी दोमोन वाहळ्ळी चलाड़ीयो, तव दरियो न हेनको ढाक लिदो; त्या दरिया मा लुहड़ान तसा डूब गीया। ");
INSERT INTO dhn_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","“ए यहोवा, देवता मा थारे सारको कुन छे? तुते चुखापन मा मोटो छे, आरु थारी बढ़ाय करने वाळान मन मा बीक राखने जुगु छे, आरु विनछेळ्यो काम मोटो काम करे। ");
INSERT INTO dhn_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","तु थारो डाखरीयो हात बढायो, आरु धरती उको गीळ गय। ");
INSERT INTO dhn_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","थारी दया सी तु थारी छुड़ावली परजान अगवाय करीयो, थारी ताकत सी उको थारा चुखला जागा मा लीन गयो। ");
INSERT INTO dhn_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","देम–देशन लोगहन यो समळीन काप उठसे; पिलिश्तियान मा रोहने वाळान पोखड़ायनेन पीड़ा सारकी पीड़ा होयसे। ");
INSERT INTO dhn_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","एदोमन डाहडा घबराय जासे; मोआबन ताकत वाळा कापने लाग जासे; सब कनान मा रयने वाळान मन निचळो हुय जासे। ");
INSERT INTO dhn_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","उन लोगहन मा बीक आरु घबरायनो समाय जासे; थारा खुळान ताकत सी त्या दगड़ान तसा विन मुया हुय जासे, जव तक ए योहोवा, थारी परजान लोगहन जिनुक तु मोल लेदलो छे पार नी छेक जाय। ");
INSERT INTO dhn_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","तु उन लोगहन को पुगाड़ीन थार आपसा हकन वाटा पर बठाड़ीस, यो‍ त्योत् जागो छे, ए योहोवा जिनाक तु थारा रयनेन जागा जुगु बनायो, आरु त्योत् चुखलो जागो छे जिनाक, ए पोरबु, तु आपसुत् उबो करलो छे। ");
INSERT INTO dhn_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","योहोवा जलोमको राज करतो रयसे।” ");
INSERT INTO dhn_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","यो गीत गावनेन कारण यो छे, कि फिरोनन घुड़सवारी आरु सवारन सात मा दरियान वीच मा जात रीया, आरु योहोवा हेनको उपर दरियान पानी पछो ली आयो; पुण इसराएली दरियान वीच मा धरतीन जागा परुत् चालीन छेक गीया। ");
INSERT INTO dhn_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","तव हारुनन बयनी मरियममन नावन कागळीयो हात मा ढुलगो लीदो; आरु सब बायरा ढपली लीन नाचता जाईन उका पछोळ चाल पड़ीया। ");
INSERT INTO dhn_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","आरु मरियम हेनको सात मा यो गीत गावता गीया कि; योहोवान गीत गावो, काहकी त्यो मोटो ताकत वाळो बनीयो; घुल्‌लान को सात मा त्यो सवार करने वाळान को दरिया मा न्हाक दीदो। ");
INSERT INTO dhn_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","तव मुसा इसराएलीयान को रातला दरिया सी अगो लीन गयो, आरु त्या शुर नावन जंगलो मा आया; आरु जंगल मा जाता जाईन तीन दाहड़ा लगुन पानीन झर नी जड़ीयो। ");
INSERT INTO dhn_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","ओळते मारा नावन एक जागा पर पुगीया, वाँ वाळो पानी कड़वो हुतो, आरु त्या उको पी नी सकीया; इना कारण सी उना जागान नावन मारा पड़ गीयो। ");
INSERT INTO dhn_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","तव त्या यो कयीन मुसान विरुद मा कुड़कुड़ायने लागीया, “हामु काय पीजे?” ");
INSERT INTO dhn_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","तव मुसा योहोवा सी विनता करीयो, आरु योहोवा भगवान उको एक झाड़ देखाड़ीयो, जिना सी जव उको पानी न्हाकीयो, तव त्यो पानी गुळो हुय गीयो। वाँत् योहोवा हेनका लिये एक नियम बनायो, आरु वाँत् त्यो यो कयीन हेनकी पारख करीयो, ");
INSERT INTO dhn_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","“कदाम तु थारा योहोवा भगवानन वचन तन मन सी समळे, आरु जो ओकी नजर मा वारु छे त्योत् करे, आरु ओको हुकुम पर कानटा लगाड़े आरु उना सब नियम को माने, ती जतरी बिमारी हांव मिसरीया पर मकलीयो, उका माईन एक बी थारे पर नी मकलो; काहकी हांव तुमरो आरगाय आपने वाळो योहोवा छे।” ");
INSERT INTO dhn_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","तव त्या एलीम मा आया, जाँ सारी पानीन बारे झोरे आरु तीन कोम आठ वीस खजुरन झाड़ हुता; आरु वाँ त्या पानीन पास मा तम्बु करीया। ");
INSERT INTO dhn_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","ओळते एलीम सी थुड़ाक अगा जाईन इसराएलीयान सारी मण्डळी, मिसर देश सी निकळीन ओळते दिसरे मयनान पंदरवे दाहड़ाम, सीन नावन जंगलो मा, जो एलीमन आरु सीनाय बयड़ान वीच मा छे, वाँ पुग गीया। ");
INSERT INTO dhn_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","जंगलो मा इसराएलीयान सारी मण्डळी मुसा आरु हारुनन विरुद मा कुड़कुड़ायने लाग गीया। ");
INSERT INTO dhn_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","आरु इसराएली हेनका सी कयने लागीया, “जव हामु मिसर देश मा मासन ढेचका क पास मा बठीन मन मा आवे तसो खाता हुता, तव कदाम हामु योहोवा भगवानन हात सी मरी बी जाता ती वारु त्योत् हुतो; पुण तुमु हामुक इना जंगलो मा अतरान करीन निकाळ लाया कि इना आखा लोगहन को भुकला म्हार न्हाके।” ");
INSERT INTO dhn_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","तव योहोवा भगवान मुसा सी कयो, “देखो हांव तुम लोगहन क लिये सरग माईन खानेन चीजन को पाड़ीस; आरु याँ लोगहन दाहड़ीन बाहर जाईन खानो एख्टो करसे, इना सी हांव हेनकी पारख करीस, कि त्या म्हारा कायदा पर चाले कि नी चाले। ");
INSERT INTO dhn_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","आरु असो हुयसे कि छटवे दाहड़े त्या खानो आरु गाहड़ा सी वदीन हुयसे, अतरान करीन जो काय त्या उना दाहड़े एखटा करसे उको तीयार करीन राखे।” ");
INSERT INTO dhn_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","तव मुसा आरु हारुन सारा इसराएलीया सी कय दीदा, “शांता तुमु जान जासो कि जि तुम लोगहन को मिसर देश मा सी निकाळ लायो, त्यो योहोवा छे। ");
INSERT INTO dhn_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","आरु भोळभाकाम तुमुक योहोवा भगवानन विजाळो देखाय पड़से, काहकी तुमु जो योहोवा पर कुड़कुड़ाये उका सी त्यो समळे। आरु हामु काय छे। कि तुमु हामरे पर कुड़कुड़ाये?” ");
INSERT INTO dhn_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","जव मुसा कयो, यो तव हुयसे जव योहोवा भगवान शांतो तुम लोगहन को खाने करीन मास आरु भोळभाकाम रोटो मन पड़े तसो आपसे, काहकी तुमु जो उका पर कुड़कुड़ाये उका सी त्यो समळे। आरु हामु काय छे? तुमरो कुड़कुड़ायनो हामरे पर नी पुण योहोवा भगवान पर हुये। ");
INSERT INTO dhn_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","ओळते मुसा हारुन सी कयो, “इसराएलीयान सारी मण्डळीक हुकुम दीदो, कि योहोवान सामने पुण उका साते आवे, काहकी त्यो हेनको कुड़कुड़ायनो समळ्ळो छे।” ");
INSERT INTO dhn_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","आरु असो हुयो कि जव हारुन इसराएलीयान सारी मण्डळी सी असीत् वात करतो हुतो, कि त्या जंगल भेणी नजर न्हाखीन देखीया, आरु हेनको योहोवान विजाळो वादळा मा देखाय पड़ीयो। ");
INSERT INTO dhn_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","तव योहोवा मुसा सी कयो, ");
INSERT INTO dhn_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","इसराएलीयान कुड़कुड़ायनो हांव समळ्ळो छे; उना लोगहन सी कय दे, कि दुय दाहड़ा दाहड़ु डूबनेन टेमे सी तुमु मास खासु आरु भोळभाकाम तुमरो रोटा सी पेट भरायसे; आरु तुमु यो जान लेसो कि हांव तुमरो योहोवा भगवान छे। ");
INSERT INTO dhn_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","तव असो हुयो कि शांता बटेरे आवीन आखी छावनी पर बठ गय; आरु भोळभाकाम छावनीन चारो मेर धुवरो पड़ीयो। ");
INSERT INTO dhn_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","आरु जव धुवरो सुख गयो ती काय देखीया, कि जंगलन मा धरती पर नाना–नाना छलटा पाळान धड़े कचरान तसा पड़ रीया। ");
INSERT INTO dhn_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","जव इसराएली देख्या, त्या एक दिसरा सी कयने लाग गीया यो ते मन्ना छे। जो नी जानता हुता कि यो काय चीज छे, तव मुसा हेनको कोयो, जो चीज योहोवा खाने करीन तुमुक आपे। ");
INSERT INTO dhn_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","जो हुकुम योहोवा भगवान आपीयो त्यो यो छे, कि तुमु उका माईन तुमरे लिये खानेन कामको हय त्यो एख्टो करजो, मतलब तुमरा प्राणीन गिनतीन अनसारे, हर एक मनुसन पछोळ एक–एक ओमेर एखटा करजो; जिनान टेरा जतरा हय त्यो हेनको लिये एखटा करे। ");
INSERT INTO dhn_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","आरु इसराएलीया वसात् करीया; आरु कोय जादा आरु कोय थुड़क एखटा करीया। ");
INSERT INTO dhn_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","जव त्या हेनको ओमेर सी मापीया, तव जिना पास जादा हुता उको पास ओळते जादा नी रीयो, आरु जिना पास थुड़ोक हुतो उको कोय कमी नी हय; काहकी एक–एक मनुस हेनको खाने जुगु एखटा कर लीदाला हुता। ");
INSERT INTO dhn_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","ओळते आरु मुसा कयो, कोय इना माईन थुड़ोक बी सोंदारे तक झुण रयने दीता। ");
INSERT INTO dhn_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","ती बी त्या मुसान वात नी मानीया; अतरान करीन जव कोय मनुस उका माईन सोंदारे तक मेल राखीया हुता, ती उका मा कीड़ा पड़ गीया आरु त्यो गंदायने लाग गीयो; तव मुसा उन लोगहन पर किचवायने लागीयो। ");
INSERT INTO dhn_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","त्या भोळभाका मा हेनका लिये खाने करीन एखटा कर लेता हुता, आरु दाहड़ान को घणो तपतो हुतो, तव त्यो पिघळी जातलो। ");
INSERT INTO dhn_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","ओळते हसो हुयो कि छटवे दाहड़े एक दाहड़ा मा डबल, मतलब कि एक मनुसन पछोळ दुय-दुय ओमेर एखटा कर लेदा, आरु मण्डळीन सब वेगला डाहला आवीन मुसा को देखाड़ दीदा। ");
INSERT INTO dhn_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","त्यो उन लोगहन सी कयो, यो ते चीत वात हुयी जो योहोवा भगवान नी कयो, मतलब योहोवा क लिये चुखलो आराम हुयसे; अतरान करीन तुमुक जो तंदुर मा पकाड़नो हय उको पकाड़ो, आरु जिनाक बाफनो छे त्यो वाफजो, आरु उका माईन जतरा पीला हय हेनको सोंदारे तक राखजो। ");
INSERT INTO dhn_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","जव त्या इना काम को मुसान इना हुकुमन अनसारे सोंदारे तक मेल राखीया, तव त्यो नी ते गोंदायो, आरु नी उका मा किड़ा पड़ीया। ");
INSERT INTO dhn_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","तव मुसा कयो, \"आज उकोत् खावो, काहकी आज योहोवान आराम को दाहड़ो छे; अतरान करीन आज तुमुक खयड़ा मा नी जड़े। ");
INSERT INTO dhn_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","छव दाहड़ा ते तुमु उको एखटा करसो; पुण सातवे दाहड़ो ते आरामन दाहड़ो छे, उका मा त्यो नी जड़े।\" ");
INSERT INTO dhn_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","ते बी लोगहन माईन कोय–कोय सातवे दाहड़े बी एखटा करने करीन बाहर गीया, पुण हेनको काय बी नी जड़ीयो। ");
INSERT INTO dhn_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","तव योहोवा मुसा सी कयो, तुम लोगहन म्हारा हुकुम आरु कायदा को कोत्यार लोगुन नी पाळन कोरसु? ");
INSERT INTO dhn_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","देखु, योहोवा जो तुमुक आरामन दाहड़ो आपलो छे, इना कारण सी त्यो छटवे दाहड़ेत् दुय दाहड़ान खानो तुमुक आप देय; अतरान करीन तुमु तुमरा–तुमरा जागा पर बठ रयजो, सातवे दाहड़े कोय बी तुमरा जागा सी खोयड़े झुण जाता। ");
INSERT INTO dhn_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","एकालिय इसरायली लोगहन सातवे दाहड़े आराम करीया। ");
INSERT INTO dhn_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","इसराएलन घरानो उनी चीज को नाव मन्ना राखीया; आरु त्यो जुवार न धवळीया बिजा सारको धवळीयो हुतो, आरु उको सवाद माहळन बनला पुळा जसो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","ओळते ओळी मुसा कयो, योहोवा जो हुकुम आपीयो त्यो यो छे, कि इना माईन ओमेर भरीन “मन्ना” तुमरी पीड़ी क लिये मेल राखो, जिना सी त्या जाने कि योहोवा हामुक मिसर देश मा सी निकाळीन जंगल मा कसो रोटा खावाड़तो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","तव मुसा हारुन सी कयो, एक वोटवो लीन उका मा ओमरे भर “मन्ना” लीन उको योहोवा क ओगळ मेल दे, कि त्यो तुमरी पीड़ी क लिये मेकलो रये। ");
INSERT INTO dhn_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","योहोवा मुसा आरु हारुन क हुकुम आपलो हुतो, ओकोत् अनसारे हारुन उको गवाह न सन्दुकन ओगळ मेल दीदो, कि त्यो वाँत् रये। ");
INSERT INTO dhn_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","इसराएली जव तक उना देश मा नी पुग गुया, तव तक चालीस साल लगुन इसराएली लोगहन “मन्ना” खाता रीया; त्या जव तक कनान देशन काकड़ पर नी पुगीया तव तक “मन्ना” खाता रीया। ");
INSERT INTO dhn_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","एक ओमरे ते एपा न दसवो भाग छे। ");
INSERT INTO dhn_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","ओळी इसराएलीयान आखी मण्डळी सीन नावन जंगल मा सी निकळीन जाने लागी, आरु योहोवान हुकुम अनसारे थुड़ाक अगा जाईन रपीदीम जागाम मा हेनका डेरा उबा करीया; आरु वाँ त्या लोगहन को पीनेन पानी नी जड़ीयो। ");
INSERT INTO dhn_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","एकालिय हुये मुसा वाद विवाद कोरीन कोहने लाग्या, “आमुक पीने क पानी आप।” मुसा न हेनुसी कोयो, “तुमु मार सी काहा वाद-विवाद करु? आरु योहोवा क पारोख काहा कोरु?” ");
INSERT INTO dhn_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","पुन उना लोगहन को पीस लागी, ती हुये यो कोहीन मुसा पोर बुड़बुड़ायने लाग्या, “तु हामरा बाळ-बोच्‌चा आरु ढुरो भेळ तिसला मारने क लिय मिसर सी काहा ली आयो?” ");
INSERT INTO dhn_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","ती मुसा न योहोवा सी विनता कोर्‌यो, आरु कोयो, एनु मानसो साते हांव काय कोरो? ये आखा मेसे दोगड़ाटने क तियार छे। ");
INSERT INTO dhn_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","योहोवा न मुसा सी कोयो, “इसराएलन डावा होयला मानसो मा सी थुड़ाक क आपसे पुठी ली गोयो; आरु जेनी लाकुड़ सी तु न नील नोदी पोर देदलो हुतो, ओको आपसा हात मा लीन मानसो क ओगोळ चाल। ");
INSERT INTO dhn_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","देख, हांव तारे ओगोळ चालीन होरेब बोयड़ा क एक चाफुर पोर उबु रोहीस; आरु ओको तु हेनी लाकुड़ को चाफुर पोर देजी, ती हेरेम सी पानी निकळसे, जेरेसी ये मानसे पीये।” ति मुसा न इस्राएल क डाहला मानसोन डुळा देखता होसोत कोरीयो। ");
INSERT INTO dhn_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","आरु मुसा न हेना जागा क नाव मस्सा आरु मरीबा पाड़्यो, काहकी इसराएलीयान न होया वाद-विवाद कोरला हुता, आरु योहोवा क पारोख यो कोहीन कोर्या की, “काय योहोवा आमरे विच छे की नी?” ");
INSERT INTO dhn_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","ऐरे वाद अमालेकी जाति आविन रपीदीम मा इसराएलीयो सी लोड़ायने लाग्या। ");
INSERT INTO dhn_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","ती मुसा न योहोसु सी कोयो, “आपने जुगु काई मानसो क नेवाड़ ले, आरु वाहने खोयड़े जाईन अमालेकीयो सी लोड़ाये; आरु हांव काल परमेश्वर क म्हार लाकुड़ हात मा लीन बोयड़ा क चोटी पोर जाईन उबु रोहीस।” ");
INSERT INTO dhn_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","जसो की मुसान हुकुमन ओनसारे योहोसु अमालेकियो सी लोड़ायने लाग्यो, आरु मुसा हारुन आरु हुर बोयड़ा पोर चोहोड़ गुया। ");
INSERT INTO dhn_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","जोत्यार लगुन मुसा आपसा हात उचा कोर रोहतो हुतो ति लोगुन इस्राएल जीतता हुता; बाखुन जोत्यार जोत्यार हुयो नेचो कोरे ती ती अमालेक जीतता हुता। ");
INSERT INTO dhn_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","पुन जव मुसान हात घबराय गुया, तव हारुन आरु हुर न एक दगड़ो नेचो मेक देदो। आरु मुसा उना पोर बोठ गुयो, आरु हारुन आरु हुर एक एक वाहळा मा हेनका हातोक समाळ रोया; एक जेवड़े भेनी आरु एक डाखरे भेनी उका हात दाहड़ु डुबने लगुन उचा कोरला रोया। ");
INSERT INTO dhn_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","आरु योहोसु न आपसा लोगहन क साथ अमालेकियो क तलवार क ताकोत सी हाराय दिदो। ");
INSERT INTO dhn_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","तव योहोवा न मुसा सी कयो, यी वात किपात मा फोम राखे क लिय लिख ले आरु योहोसु क समवाड़ दे, कि हांव वादवा क नेचो सी अमालेकी जाती क फोम राखनेन सोहलानी आखो बुरवी दीस। ");
INSERT INTO dhn_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","ती मुसा न एक वेदी बोनावीन ओको नाव “योहोवा निस्सी” राख्यो; ");
INSERT INTO dhn_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","आरु त्यो कोयो, योहोवा क झंडो धोर रोव, योहोवा अमालेकियो सी पीढ़ी सी पीढ़ी लोगुन पोरबु क लिय हामरो लोड़ाय होयतो रोहसे। ");
INSERT INTO dhn_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","जब मुसा क सेसरा मिद्यान क याजक यित्रो न यो सुन्यो की परमेश्वर न मुसा आरु आपसा मानसो इस्राएल क लिय काय काय कोर्‌यो, यो की काहने रीते सी योहोवा इसराएलीयो क मिसर सी निकाळ ली आयो, ");
INSERT INTO dhn_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","ती मुसा क ससुर यित्रो मुसा क लाड़ी सिप्पोरा क, जी पेहेल मायके मुकली देदो हुता, ");
INSERT INTO dhn_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","आरु उना पुर्या क वी लीन आयो; एनुमा सी एक क नाव मुसा न यो कोहीन गेर्शोम पाड़्यो हुतो: “हांव दिसरा देश मा पारकु छे।” ");
INSERT INTO dhn_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","आरु दुसरा क नाव हुयो यो कोहीन एलीएजेर राख्यो: “मारा बाबा परमेश्वर न मारो सहायक होईन मेसे फिरोन नु तलवार सि वाचाड़्यो।” ");
INSERT INTO dhn_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","मुसा की लाड़ी आरु पुर्याक, उना सेसरो यित्रो पुठी लीन मुसा क पास सुनला जोंगल क उना जागा मा ली आयो, जाँ परमेश्वर क बोयड़ान पास ओको डेरो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","आरु आवीन हुयो मुसा क पास यो कोय मुकल्यो, “हांव मुसा तारु सेसरुस यित्रो छे, आरु दुयु पुर्या भेळ तारी लाड़ी क तारे पास ली आय रोयु।” ");
INSERT INTO dhn_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","ओतरान कोरता मुसा आपसा सेसरा सी मिळने क लिय निकळ्यो, आरु ओको वान्दीन गुळु देदो; आरु हुये आपसा वारु हावभाव पुछता जाईन डेरा पोर आय गोया। ");
INSERT INTO dhn_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","होंया मुसान आपसा सेसरा सी उना आखा कामोन वाराम बताड़ीयो। योहोवा न इसराएलीयो क जुगु फिरोन आरु मिसरियो सी काय-काय कोर्‌यो, आरु इसरालियो न वाट मा काय-काय वेला कोर्‌यो, ओळी योहोवा हेनुक कोसो-कोसो छुड़ावतो आयो। ");
INSERT INTO dhn_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","जव यित्रो न उना आखा भलाई क कारण जो योहोवा न इसरालियो क साथ कोरीयो हुतो, कि हेनको मिसर क होक सी छुड़ावलो हुतो, खुश होयीन कयो, ");
INSERT INTO dhn_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","यित्रो न कयो, “सोयाव्वु छे योहोवा, जु तुमु क फिरोन आरु मिसरियो क होकोम सी छुड़ायु, जुळ तुमु मानसो क मिसरीयान हातोम सी छुड़ायु छे। ");
INSERT INTO dhn_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","हिमी हांव ते जान लेदु की योहोवा आखा देवता सी मोटू छे; बाखुन हेका वाराम वी जिनासी इसरालियो क पुठी घाड़ायीन वेवहार कोरला हुता।” ");
INSERT INTO dhn_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","ती मुसा क सेसरो यित्रो न परमेश्वर क लिय होमबली आरु मेलबलि चोढ़ायो, आरु हारुन इसराएलियान आखा डाहडा पुजारा भेळ मुसा क सेसरा यित्रो क पुठी परमेश्वर क ओगोळ भोजन कोरने आया। ");
INSERT INTO dhn_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","दिसरे दाहड़े मुसा मानसो क नियाव कोरने क बोठ्यो, आरु वेगोत सी सांतो लोगुन मानसे मुसा क आड़ेधोड़े उबा रोया। ");
INSERT INTO dhn_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","जव मुसान सेसरो न हेनको लोगहन क नियाय कोरता देख्यो तव उनासी पुछ्यो लोगहन क लिय तु यो काय कोर रयो? काय कारण छे कि तु एखलो बठ रयो, आरु लोगहन संदोरे सी शांतो लोगुन तार आड़े धोड़े उबा रोहे? ");
INSERT INTO dhn_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","मुसा न आपसा सेसरा सी कयो, “एको कारण यो छे कि लोगहन म्हार पास परमेश्वर सी नियाव सिखने क लिय आवे। ");
INSERT INTO dhn_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","जोत्यार जोत्यार हेनको काहीन लोड़ाय होये छे ती ती हुये मारा पास आवे छे, आरु हांव हेनका वीच नियाव कोरो, आरु परमेश्वरन कायदा आरु व्यवस्था हेनको सोमजाड़ो।” ");
INSERT INTO dhn_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","मुसा क सेसरो न मुसा सी कोयो, “जो काम तु कोरे छे, त्यो वारु नी। ");
INSERT INTO dhn_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","एना सी तु काय, बाखुन तु आरु तारा लोगहन वी तारे पुठी छे छाचिन खाबराय जासे, काहकी यो काम तारे जुगु बेस काठो छे; तु इनाक एखलो नी कोर सोके। ");
INSERT INTO dhn_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","हिमी तु म्हार ओवाज समळ ले, हांव तुसेक सोला आपो, आरु परमेश्वर तारे पुठी रोहे! तु इनु लोगहन क लिय परमेश्वरन ओगोळ जाया कोर, आरु हेनकी तोकलीप को परमेश्वर क पास पुगाड़ दीया कोर। ");
INSERT INTO dhn_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","तु हेनको परमेश्वर क कायदा आरु नियम सिकाड़जो आरु जो इनको कोरनो छे आरु काहने वाटे पोर चालनो छे बताड़ देजो। ");
INSERT INTO dhn_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","पुन तु आखा इसरारली पाका मानसोक निवाड़ लेजो परमेश्वर क बीक मानतो होय आरु खोरो, गुनाको, नियाव मा फायदा सी छेटो रोहने वाळाक नेवाड़ लेजो। आरु ओसा लोगहन को हजार-हजार, सोव-सोव, पचास-पचास, आरु दस-दस लोगहन क टुळा पोर निवाय न होकदारीया निवाड़ कोर देजो। ");
INSERT INTO dhn_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","आरु हुये आखा टेम पोर इनु मानसो क नियाव कोरसे; आरु मोटा मोटा झोगड़ा क ते तारे पास ली आया कोरे, आरु नाना झोगड़ा क नियाव आपसा ज कोरीय कोरसे; ती तारो भार होळको होयसे, काहकी इना भार क हुये वी तारे पुठी हुचले। ");
INSERT INTO dhn_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","कदाम तु यो उपाय कोरे, आरु परमेश्वर तुसेक ओसो हुकुम आपे देये, तव तु एक जागे रोहायसे, आरु ये आखा मानसे आपना जागाम वारु रीते पुगसे।” ");
INSERT INTO dhn_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","आपसा सेसरा की यी सोलाक मानीन मुसा न हेना आखा बुलोन ओनसारे करीयो। ");
INSERT INTO dhn_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","मुसा आखा इसराएल लोगहन मा गोथा गुणी लोगहन क नेवाड़ीन हेनको हजार-हजार, सोव-सोव, पचास-पचास, दस-दस लोगहन पोर डाहला बोनायो। ");
INSERT INTO dhn_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","आरु त्या आखा लोगहन न नियाव कोरने लाग्या; जो झोगड़ो वातड़ो होयतो होय तेनाक मुसा क पास ली आवता हुता, आरु आखा नानला मुकद्दमा क नियाव हुये आपसा कोर्या कोरतला हुता। ");
INSERT INTO dhn_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","ती मुसा न आपसा सेसरा क वोवाव दिदो, आरु हुये आपसा देशम चाली गुयो। ");
INSERT INTO dhn_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","एकालिय इसरालियो क मिसर देश सी निकोवला जेने दाहड़े सी तीन मोहना वित गुया, उना दाहड़े त्या सीनाय जंगल मा आया। ");
INSERT INTO dhn_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","आरु जव हुये रपीदीम सी उतवाळ्या कोरीन सीनाय जंगल मा आया, ती हुये जंगल मा डेरो उबा कोरीया; आरु त्या बोयड़ान ओगोळ इसराएली लोगहन न डेरो नाख्या। ");
INSERT INTO dhn_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","आरु मुसा बोयड़ा पोर परमेश्वर क पास चहोड़ गोया, आरु योहोवा न बोयड़ा पोर सी हेनको आयड़ीन कोयो, याकुब क घोराना सी ओसो कोह, आरु इसरालियोन क मारो यो बुल सोमळाव: ");
INSERT INTO dhn_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","तुमु देखला छे की हांव ने मिसरया पुठी सी काय-काय करीयो; तुमुक मानो घुवड़ चिल्‌ला क पाखड़ा पोर बसाड़ीन आपसा धोड़े ली आवलो। ");
INSERT INTO dhn_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","एकालिय हिमी कदाम तुमु खोरी मारी मानसु, आरु म्हार वायदान पाळन कोरसु, ती आखा मानसो मा सी तुमुत मारा खास धोन कोहायसु; आखी कळी ते मारीत छे ");
INSERT INTO dhn_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","आरु तुमु मारी नजर मा याजको क मुलुक आरु चुखलो मुलुक कोवायसे। जी वाते तुमुक इसराएलीयो सी कोहनो छे ची यी छे। ");
INSERT INTO dhn_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","ती मुसा न आवीन मानसो क डाहला पुजारा लोगहन को बुलायो, आरु यी आखी वात, जेनको कोहनेन हुकुम योहोवा न उको आपलो हुतो, हेनको सोमजाय देदो। ");
INSERT INTO dhn_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","आरु आखा मानसे मीळीन जपाप आप्या, “जो काय योहोवा न कोहलो चो आखा हामु कोरसु।” लोगहन यी वात मुसा न योहोवा क सोमवाड़्यो। ");
INSERT INTO dhn_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","ती योहोवा न मुसा सी कोयो, “सोमोळ, हांव काळ्ळा वादळान आंधारा मा रोहिन तार पास आवो, एकालिय की जव हांव तार सी वात कोरो तव त्या सोमळे, आरु होमीसा तार पोर विश्वास कोरे।” आरु मुसा न योहोवा सी लोगहन वातोन वाराम कोयो। ");
INSERT INTO dhn_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","तव योहोवा न मुसा सी कोय, लोगहन पास जा आरु हेनको आज आरु वाहने चुखा कोर, आरु त्या आपसा लुगड़ा धुय लेये, ");
INSERT INTO dhn_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","आरु त्या तीसरे दाहड़े लोगुन तीयार होय जाय; काहकी तीसरे दाहड़े योहोवा आखा लोगहन क डुळान देखतात सीनाय बोयड़ा पोर उतोर आवीस। ");
INSERT INTO dhn_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","आरु तु लोगहन क लिय च्यारु धोड़े वाड़ बाँदजी, आरु उनासी कोहजो: तुमु चोकचोया रोहु की बोयड़ा पोर नी चोहड़ो आरु उना वाड़ काजे छिमता झुणी आरु जो कुय बोयड़ा को छिमसे त्यो छाचो मार न्याखो जासे। ");
INSERT INTO dhn_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","ओको कोय हात सी नी छिमे; जु छीमसे उका पोर दोगड़ाटसे, एने उको तीर से मार देसे; चाहाय ढुर होय चाहे मानुस, चो जिवतलो नी वाचे। जव गाडरान सिंगड़ान नरसिंगा वाळा बुल घनी वार लगुन सोमळाय देये, ती मानसे बोयड़ा पोर चोहड़से। ");
INSERT INTO dhn_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","तव मुसा न बोयड़ा पोर सी उतरीन लोगहन पास आवीन हेनको चुखो कोरायो; आरु त्या आपसा लुगड़ा धुय लेदा। ");
INSERT INTO dhn_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","आरु त्यो लोगहन सी कयो, “तीसरे दाहड़े लोगुन तीयार होय जावु; आपसी लाड़ी क पास नी जानो।” ");
INSERT INTO dhn_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","जव तीसरो दाहड़ो आयो तव संदारे वादळो गाजने लाग्यो आरु विजळी चोमकने लागी, आरु बोयड़ा पोर काळ्ळो वादळो छाय गोयो, ओळी नरसिंगान मोटो भारी बुल समळायो, आरु छावनी मा जोतरा लोगहन हुता आखा लोगहन कापने लाग्या। ");
INSERT INTO dhn_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","ती मुसा लोगहन क परमेश्वर सी मीळने करीन छावनी सी निकाळ ली गोया; आरु त्या बोयड़ान नेड़ा उबा हुया। ");
INSERT INTO dhn_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","आरु योहोवा त्यो आगठा मा रोहीन सीनाय बोयड़ा पोर उतरियो हतो, एना कारण आखा बोयड़ा धुवाड़ा सी भोराय गोयो; आरु ओको धुवो भट्टा सारको हुय गोयो, आरु आखा बोयड़ा काप रोया होता। ");
INSERT INTO dhn_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","ओळी जव नरसिंगा को बुल बोढ़तो आरु बेसको जादा होयतो गोयो, तव मुसा कोयो, आरु परमेश्वर बुल सोमळाड़ीन ओको जोपाप आप्यो। ");
INSERT INTO dhn_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","आरु योहोवा सीनाय बोयड़ान चोटी पोर सी नेचो उतरीयो; आरु मुसा को बोयड़ा चोटी पोर बुलायो, आरु मुसा उपोर चोहड़ गोयो। ");
INSERT INTO dhn_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","तव योहोवा न मुसा सी कोयो, “नेचो उतरीन लोगहन क चेतावनी आप, काय असो नी होये कि त्या यी वाड़ी तुड़ीन योहोवा क पास देखने लिय भराय जाय, आरु उनाम सी बेसका नाश होय जाय। ");
INSERT INTO dhn_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","आरु पुजारा जे योहोवा क धोड़े आया कोरे, त्या वी आपसाक चुखा कोरे, काय ओसो नी होय की योहोवा हेनको डोन आपे।” ");
INSERT INTO dhn_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","मुसा न योहोवा सी कोयो, “त्या लोगहन सीनाय बोयड़ा पोर नी चोढ़ सोके; तु ते आपसो हामुक यो कोहीन चोकचोया कोरीयो कि बोयड़ान च्यारु मेर वाड़ बाँधीन ओको चुखो राखु।” ");
INSERT INTO dhn_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","योहोवा न उनासी कोयो, “उतर ते जा, आरु हारुन भेळ तु ऊपर आव; बाखुन पुजारा आरु दीसरा लोगहन योहोवा क पास वाड़ तुड़ीन नी‍ चोहोड़ आवे, असो नी होये की होये की त्यो हेनको डोन आपे।” ");
INSERT INTO dhn_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","यी वाते मुसा न लोगहन क पास उतरीन हेनको सोमवाड़्यो। ");
INSERT INTO dhn_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","तव परमेश्वर न ये आखो बुल कोयो: ");
INSERT INTO dhn_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“हांव तारु परमेश्वर योहोवा छे, जो तुसे गुलामीन घोर यानी मिसर देश सी निकाळीन लावलु छे। ");
INSERT INTO dhn_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“तु मेसे छुड़ीन दिसरा क परमेश्वर कोरिन झुणी मानजी। ");
INSERT INTO dhn_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“तु आपसा लिय काय मुर्ती खुँदिन झुणी बोनवे, नी कुदान जनारक मुर्ति आरु चीज बोनावजी, जो वादळा मा, एने कळी पोर, एने कळीन नेचो जळ मां छे। ");
INSERT INTO dhn_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","तु ओसो वान्दे झुणी, आरु नी हेनको विनता कोरजी; काहकी हांव तारु परमेश्वर योहोवा जळन राखने वाळु परमेश्वर छे, आरु जुळ मार सी घाड़ाय कोरे, हेका पुर्या, पोता, आरु परपोतो क वी डाहडानक वी डोन आप्या कोरो, ");
INSERT INTO dhn_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","आरु जो म्हार सी मोंग राखे आरु मारा हुकुम क माने, हेनु हजारु पीढ़ीया पोर गीन कोरिया कोरो। ");
INSERT INTO dhn_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“तु आपसा परमेश्वर क नाव उदुड़ नी लेनो; काहकी जो योहोवा क नाव उदुड़ लेये चो ओको वीन गुनाकु नी कोहायसे। ");
INSERT INTO dhn_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“तु आरामोन दाहड़ा क चुखो मानने क लिय फोम राखजी। ");
INSERT INTO dhn_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","छोळ दाहड़ा लोगुन तु काम कोरीया कोर आपसो काम-काज कोर; ");
INSERT INTO dhn_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","बाखुन सातवो दाहड़ो तारा परमेश्वर योहोवा क लिय आरामोन दाहड़ो छे। हेरेमा नी ते तु कोहने वि रीते क काम-काज कोरजी, आरु नी तारा पुर्या, नी तारी पुराय, नी तारा दास, नी तारी दासी, नी तारा ढुरे, नी काई पारकाओ जो तारा झोपला क धोड़े होय। ");
INSERT INTO dhn_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","काहकी छोव दाहड़ा मा योहोवा न वादळा, आरु कळी, आरु दोरया, आरु जो काई हेरेम छे, आखो बोनायो, आरु सातवे दाहड़े आराम कोर्‌यो; ओस कोरीन योहोवा न आरामोन दाहड़ा क बोरकोत आप्यो आरु ओको चुखलो कोयो। ");
INSERT INTO dhn_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“तु आपसा बाबा आरु आपसी आयान आदर कोरजी, जेरेसी जे देश तारा परमेश्वर योहोवा तुखेक आपे छे हेरेम तु घोना दाहड़ा लौगुन रोय सोके। ");
INSERT INTO dhn_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“तु खुन झुणी कोरे। ");
INSERT INTO dhn_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“तु व्यभिचार झुणी कोरे। ");
INSERT INTO dhn_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“तु चूरी झुणी कोरे। ");
INSERT INTO dhn_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“तु कुदान विरुद्ध झुटु गोवा नी देजी। ");
INSERT INTO dhn_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“तु कुदान घोर क लालच झुणी कोरजी; नीते कुदान बायोर क लालच कोरजु, आरु नी कुदा क दास-दासी एने बुईल-गोदड़ा क, नी कुदा क काई चिजो क लालच कोरजु।” ");
INSERT INTO dhn_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","आखा मानसे वादळो गाजनो आरु विजवी आरु नरसिंगा क बुल सोमळीन, आरु धुवाड़ा क उठतो हुवे बोयड़ा क देखता रोया, आरु देख क, कापता जाईन छेटा उबा होय गोया; ");
INSERT INTO dhn_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","आरु हुये मुसा सी कोहने लाग्या, “तुत आमरे सी वात कोर, ती ते हामु सोमळी सोकसु; बाखुन परमेश्वर आमरे सी वात नी कोरे, ओसो नी होय की हामु मोर जाजे।” ");
INSERT INTO dhn_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","मुसा न मानसो सी कोयो, “मा बीहयु; काहकी परमेश्वर इकालिय आयो छे की तुमरी पारोख कोरे, आरु ओको बीक तुमरा मोन मा बोनलो रोहे की तुमु पाप नी कोरु।” ");
INSERT INTO dhn_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","आरु त्या लोगहन छेटा उबा रोया पुन मुसा उना घोना आंधारा धोड़े गुयो जां परमेश्वर हुतो। ");
INSERT INTO dhn_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","तव योहोवा न मुसा सी कोयो, तु इसराएलियो को म्हार ये बुले सोमवाड़: तुमु लोगहन आपसा देख्या की हांव तुमरे पुठी वादळा सी वात कोरलो छे। ");
INSERT INTO dhn_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","म्हार विगुर आराधना क देवता जुगु आपसा लिय सोना चाँदीन भगवान झुणी बोनावता। ");
INSERT INTO dhn_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","मारे जुगु धुळान क एक वेदी बोनावीन, आरु आपसा गाडरा-बुकड़ा आरु गाय-बुल्यो क होमबली आरु मेलबलि क हेर पोर चोढ़ावजु; होर जागाम जाँ हांव आपसा नाव क फोम कोरावो चाँ चाँ हांव आवीन तुमुक बोरकोत आपीस। ");
INSERT INTO dhn_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","आरु कदाम तुमु मारे लिय दोगड़ा क वेदी बोनावु, ती तराशे हुया दोगड़ा सी नी बोनावजु; काहकी जाँ तुमु न हेर पोर आपसो होतीयार लागाड़े चाँ तुमु हेनाक विटवी देसु। ");
INSERT INTO dhn_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","आरु मारी वेदी पोर पान्छ्या सी कोदी नी चोड़नो, काहिय ओसो नि होय कि तारो डिल हेर पोर नांगो देखा पोड़े। ");
INSERT INTO dhn_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","ओळी जे कायदा तुखे हेनको समझावनो छे त्या ये छे: ");
INSERT INTO dhn_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","जोत्यार तुमु काय इबरी दास मुले लेये, तव त्यो छोव साल लोगुन चाखरी कोरतो रोहे, आरु सातवा साल स्वतन्त्र विगुर दाम आपे जात रोहे। ");
INSERT INTO dhn_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","कदाम हुये छोल्लो आयो होय, ती छोल्लो जात रोहे; आरु कदाम लाड़ी भेळ आयो होय, ती उना साथ ओकी लाड़ी वी जात रोहे। ");
INSERT INTO dhn_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","कदाम हेको मालीक न उको लाड़ी बोनाय देदो होय आरु उना उकासी पुर्या आरु पुरायटा पोयदा होया होय, ति ओकी लाड़ी आरु बाळक हेरा मालीक क त रोहे, आरु हुयो एखलो जात रोहे। ");
INSERT INTO dhn_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","बाखुन कदाम हुयो दास हिमोत कोरीन कोहे, हांव आपसा मालिक, आरु आपसी लाड़ी, आरु पुर्या सी मोंग राखो; एकालिय हा स्वतन्त्र होईन नी जाईस; ");
INSERT INTO dhn_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","ती हेको मालिक उको योहोवा भगवान क पास मा ली जाय; ओळते उको भितड़ान छिवनियान धड़ मा ली जायीन उका कान्टा मा सुजेन सी वीन्द देय; तव त्यो जलोमको ओकी चाखरी करतो रये। ");
INSERT INTO dhn_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","कदाम कोय आपसी पोराय को दासी हुयने करीन वेच देय, तो त्यी दासी सारकी खोयड़े नी जाय। ");
INSERT INTO dhn_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","कदाम त्यो आपसा मालीक क आपसा लिय मुले लेदलो होय, आरु उको मालिक उको आपसी लाड़ी बनावे, आरु ओळते उका सी त्यो खुश नी हुये, ती त्यो उको उना दाम मा पछो छुड़वने देय; उको भुरसो तुड़नेन ओळते बाहर देश वाळान को वेचनेन उको हक नी रये। ");
INSERT INTO dhn_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","कदाम त्यो उका पोर्यान क सात मा वियाव बी कर दीदो हय, तो उका सी पोराईन सारको वेवहार करे। ");
INSERT INTO dhn_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","चाहे त्यो दिसरी लाड़ी कर लेय, तेबी, त्यो उनी पेहली लाड़ीन खानो, छिंदरा, सातसोंगत कम नी करनो जुळे। ");
INSERT INTO dhn_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","आरु कदाम त्यो इनी तीन वातो मा कमी करे ती, त्या बायोर उना मालिक को रुप्‌या आपे विगुर जात रये। ");
INSERT INTO dhn_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","जु कोय कुदा मनुस को असो देय की त्यो मर जाय, ती त्यो मारने वाळान सजा यी छे कि त्यो बी छाचो मार दियो जाय। ");
INSERT INTO dhn_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","कदाम त्यो ओको केड़ु हय नी बठलो हय, आरु योहोवा भगवानन मरजी सी त्यो उका हाथ मा पड़ गयो हय, ती असो मारने वाळान क लिए हांव एक जागो तियार कर राखीस जाँ सारी त्यो ढास जाय। ");
INSERT INTO dhn_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","पुण कदाम कोय रीस करीन कुदा सी लड़ाय करीन उको सी धुको करीन मार देय, ती उना मारने वाळा को मारने करीन म्हारी वेदी सी बी छेटा ली जाजु। ");
INSERT INTO dhn_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","जो कोय आपसा- माय या बाप को सात मा मार पीट करे ती त्यो छाचो मार दियो जाय। ");
INSERT INTO dhn_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","जो कोय कुदा मानुस क चुरावे, चाहे त्यो उको वेच देय, चाहे उको याँ जप जाय, ती उना चुरावने वाळान को छाचो मार न्हाखे। ");
INSERT INTO dhn_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","जो कोय आपसा बाप या माय को सराप देय, त्यो बी छाचो मार दियो जाय। ");
INSERT INTO dhn_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","कदाम मनुस लड़ायता हय, आरु एक दिसराक दगड़ा या धुमा दीन मांदो कर देय आरु त्यो खाटला मा पड़ जाय। ");
INSERT INTO dhn_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","ती जव त्यो उठीन लाकड़ीन टेका चालने फिरने लाग जाय, तव मारने वाळो गुणेगार नी रये: उनी टेम मा त्यो मार खाने वाळान पड़ रयनेन दाहड़ान नुक्शानी भर देय; आरु उको आरगो करने इलाज बी कराय देय। ");
INSERT INTO dhn_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","कदाम कोय आपस दास या दासी को सुटा देय आरु त्यो असो देय कि त्यो हेको देने सी मर जाय, तव उको छाचो डण्ड जड़नो जुळे। ");
INSERT INTO dhn_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","पुण कदाम त्यो दुयेक दाहड़ा जीवतलो रये, ती ओको मालिक को डण्ड नी देनो; काहकी त्यो दास उका रुप्‌या छे। ");
INSERT INTO dhn_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","कदाम कोय मानुस एकि दिसरा सी मार पीट करीन काहली भारपाये बायोर को चुट लगाड़े आरु उको चुट लगाड़ने सी उनी बायोर को कुख गिर जाय, पुण आरु काहय दिसरी नुक्शानी नी हुये, ती मारेने वाळा सी तरोत डण्ड लेनो जतरो उनी बायोर को धेणी पंचुन राजी सी देखाड़े। ");
INSERT INTO dhn_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","पुण कदाम उको दिसरी काहय नुक्शानी हुये, ती जीव को बदले जीवन, ");
INSERT INTO dhn_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","आरु डुळान बदले डुळु, आरु दाँतन बदले दाँत, आरु हातन बदले हात, आरु पायन बदले पाय, ");
INSERT INTO dhn_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","आरु आगठो चोसटाड़ने बदले आगठो चोसटाड़नो, आरु घावन बदले घाव, आरु मारन बदले मार हुयनो जुळे। ");
INSERT INTO dhn_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","जव कोय आपसा दास या दासीन डुळा पर असो देय कि ओको डुळो फुट जाय, ती त्यो उना डुळान बदले छुट आपीन जाने देय। ");
INSERT INTO dhn_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","आरु कदाम त्यो आपसा दास या दासी को देय आरु ओको दात तुड़ देय, ती त्यो उका दातन बदले उको छुट आपीन जाने देय। ");
INSERT INTO dhn_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","कदाम बयल्यो कोय बायोर एने ओदमी को असो सींगड़ो मारे कि त्यो मर जाय, ती उना बयलीयो छाचो दगड़ा दीन मार देनो, आरु ओको मास नी खानो; पुण बयल्यान मालिक गुनेगार नी बने। ");
INSERT INTO dhn_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","पुन कदाम उना बयलीयोन पेहले सु सींगड़ो देनेन टेळ होय, आरु उका मालिक को कय देने पर बाँधीन नी राखे, आरु कोय बायोर या ओदमी को मार देय, तव उना बयल्या को दगड़ावे, आरु उको मालिक को बी मोतन डण्ड आपीन मार देय। ");
INSERT INTO dhn_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","कदाम उका पर छुटनेन गुनु राखे, ती जीव छुड़वनेन जो दाम काय हेरेन करीन टाकलो, उको तरोत आपनो पड़से। ");
INSERT INTO dhn_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","चाहे बयल्यो कोय को पोर्यान को, चाहे पोराई को सिंगड़ो लागाड़े, तेबी उना नियम क अनसारे उका मालिक क सात वेवहार करे। ");
INSERT INTO dhn_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","कदाम बयलीयो कोय दास या दासी को सींगड़ो सी मारीयो हय, ती बयल्यान मालिक उना दास क मालिक को चाँदीन तीस सिक्के आप देय, आरु उना बयल्या पर दगड़ा देय। ");
INSERT INTO dhn_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","कदाम कोय मनुस खाडो खुंदीन या खुंदीन उको पछो नी बुरवे, आरु उना मा कोय को बयलीयो या ते गदड़ो पड़ जाय, ");
INSERT INTO dhn_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ती जिनान त्यो खाडो छे त्यो उनी नुक्शानी को भर देय; त्यो उना पशुन मालिक को ओको मुले आप देय, आरु त्यो ढुर खाढा वाळान रये। ");
INSERT INTO dhn_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","कदाम कोय को बयलीयो कोय दिसरान बयल्या को असो चुट लगाड़े कि त्यो मर जाय, ती त्या दुयु मनुस जीवतला बयल्या को वेचीन ओको रुप्‌या आपस मा वाट लेय; आरु मोरला बयल्या को बी तसात वाट लेय। ");
INSERT INTO dhn_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","कदाम यो उजन्तो कय कि उना बयलीयोन पेहले सी सींगड़ा मारनेन आदत पड़ली हुती, पुण उना बयल्यान मालिक ओको बाँधीन नी राखे, ती छाचो त्यो बयल्यान बदले बयल्यो आप देय, पुण मोरलो ढुर ओको रये। ");
INSERT INTO dhn_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","कदाम कोय मनुस बयलीयो, या गाडरा, या बकड़ा चुरी करीन उको मार न्हाखे या वेच देय, ती त्यो बयल्यान बदले पाच बयल्या, आरु गाडरान-बकड़ान बदले चार गाडरा-बकड़ा भर देय। ");
INSERT INTO dhn_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","कदाम चुर चुरी करतलो धराय जाय, आरु उना पर असी मार पड़े कि त्यो मर जाय, ती उका खुन को गुणो नी लागे; ");
INSERT INTO dhn_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","कदाम दाहड़ो उग जाय, तव चुर क मारने वाळा पोर गुनो लागे, पुन त्यो चुर नुकसान नी भोराये, ती त्यो चुर को वेच देय। ");
INSERT INTO dhn_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","कदाम चुरावलो बयलीयो या गदड़ो, या गाडरो, या बकड़ो उना जुळ जीवतलो जड़ जाय, त्यो उको दुय गुणा भर देय। ");
INSERT INTO dhn_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","कदाम कुय आपसो ढुर सी कुदाण खेतोम एने अंगुरोन वाड़ीम चोरे, आपसा ढुर क ओसो छुड़ देये कि त्यो पारका खेतोम चोर लेये ती त्यो आपसा खेतोन आरु आपसी अंगुरोन वाड़ीन वारु सी वारु मेर मा सी ओकी नुकसानी भोरे। ");
INSERT INTO dhn_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","कदाम कोय ओदमी आपसा खेत मा आगठो धपाड़े, आरु आगठो काटा मा लाग जाय आरु फुलोन ढिगोम या ओन या उबलो खेत धप जाय, ती त्यो आगठो लगाड़ियो हय त्यो नुक्शान हयो वतरो भर देय। ");
INSERT INTO dhn_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","कदाम कोय दिसरा न क पास मा सी रुप्‌या या सामान गिरीवी मेले, आरु त्यो उना घर चुरी हुय जाय, ती कदाम चुर धराय जाय ती उको दुय गुना भरनो पड़से। ");
INSERT INTO dhn_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","कदाम चोर नी धराये, ती घर को मालिक को योहोवा भगवान कि पास मा लावे कि मालुम हुय जाय की त्यो उना सोगाय साय वाळान धोन पोर हात लगाड़ीयो छे की नी। ");
INSERT INTO dhn_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","चाहे बयलीयो, चाहे गदड़ो, चाहे गाडरो या बकड़ो, चाहे छिंदरा, चाहे काहली बी भाँती खुवायली चीजोन वाराम गुनु काहनी लागड़लो हय, जिनाक दुय जना म्हारी म्हारी कयता हय, ती उना दुय जन को झोगड़ान क योहोवा भगवान को पास मा आवे; आरु जिनाक योहोवा भगवान गुनागार बनावे त्यो दिसरान दुय गुना भर देय। ");
INSERT INTO dhn_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","कदाम कोय दीसरान को गदड़ो या बयलीया या गाडरो- बकड़ो या काहलो बी ढुर को उका जुळ भाळने करीन मेले, आरु कुदान बी बिना देखे त्यो जनवार मर जाय, ता काहय चोट लाग जाय, या आहानाय ली जाय, ");
INSERT INTO dhn_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ती उन दुयन क वीच मा योहोवा भगवान न कसम देवाड़नो, कि हांव एकी सम्पती पर हाथ नी लगाड़ीयो; तव सम्पती को मालिक उनी वात को पाको माने आरु दिसरा को काहय बी भरने नी देनो जुळे। ");
INSERT INTO dhn_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","कदाम त्यो पाको उका हात सी चुरावलो हय, ती त्यो ओका मालिकन नुक्शानी को भर देय। ");
INSERT INTO dhn_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","आरु कदाम त्यो जोंगली जोवारीयो फाड़ दियो हय, ती त्यो फड़लात् जनवार को गोवान कोरता ली आवे, तव उना क बी नुक्सानी भरनो नी पड़े। ");
INSERT INTO dhn_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","ओळी कोय दिसरा सी पशु माँगीन ली आवे आरु उना मालिक क साथ मा नी रये ने आरु ओको चुट लाग जाय या मर जाय, ती त्यो पाको ओकी नुक्शानी भर देय। ");
INSERT INTO dhn_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","कदाम ओको मालिक साथ मात् रये, ती दिसरा को नुक्शानी नी भरनो पड़े; आरु कदाम त्यो भाड़ा पर लावलो हय ती ओकी नुक्शानी उना भाड़ा मा आय गय। ");
INSERT INTO dhn_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","कदाम कोय ओदमेड़ो काहली छोल्ली पोराय को, जिनीन वियाव न वात नी हयली हय, फुसलावीन उना साथ मा विनलागीयो काम करे, ती त्यो पाको ओको मोल आपीन उना सी वियाव कर लेय। ");
INSERT INTO dhn_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","पुन कदाम ओको बाप उनी पोराय को वियाव सी पुरो मना कर देय, ती गुनु करने वाळो पोरई को मोलन रीतिन अनसारे रुप्‌या तुल देय। ");
INSERT INTO dhn_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","तु जादु टोना करने वाळी बायर को जीवतली झुण रयने देय। ");
INSERT INTO dhn_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","जो कोय संवसार करतो होय, ती त्यो पाको मार दियो जाय। ");
INSERT INTO dhn_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","जो कोय योहोवा को छुड़ीन आरु कुदा दिसरा देवतान करीन बलि करे ओको सत्यनाश करीयो जाय। ");
INSERT INTO dhn_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","तुमु बाहर देश वाळान को झुण सतावता आरु उना पर घाड़साय झुण करता, काहकी मिसर देश तुमु बी बाहर देश वाळा हुता। ");
INSERT INTO dhn_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","काहली रोन्डायली बायोर एने विखा वाळा पोर्यान को दु:ख झुण देय। ");
INSERT INTO dhn_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","कदाम तुमु असलान को काहले बी रीतिये सी दु:ख देयो आरु त्या म्हार सी विनता करे, ती हांव छाचो हेनकी विनता समळीस; ");
INSERT INTO dhn_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","तव हांव रीसवाय जाईस, आरु हांव तुमुक तोलवार सी मारावीस, आरु तुमरी धेन्यारी रोन्डाय जासे आरु तुमरा पोर्या पारी विखा वाळा हुय जासे। ");
INSERT INTO dhn_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","कदाम तु म्हारी परजान लोगहन मा सी नेचळा को जो तारे जुळ रयतो हय आरु बियाजता रुप्‌या आपे ती उना सी नाव सोवकार सारका बियाज झुण लेतो। ");
INSERT INTO dhn_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","कदाम तु कदी थारा भाई बयणीयान छिंदरा खण्डीन राखी बी लेय, ती दाहड़ो डुबने सी पहले तक उको पछो आप देजी; ");
INSERT INTO dhn_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","काहकी त्यो ओको पाँगरुन छे, उना डीलन त्योत् एकुत छिंदरो रयसे; ओळते त्यो काय पाँगरीन सुवसे? आरु जव म्हार सी विनता करसे तव हांव हेनकी विनता समळी लीस, काहकी हांव दया वाळो छे। ");
INSERT INTO dhn_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","योहोवा भगवान को शाप झुण देय, आरु नी थारा लोगहन को डाहडान को सराप देय। ");
INSERT INTO dhn_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","आपसा खेतोन अनाज को आरु फवोन रस मा सी काहय मखे आपने करीन काहय बी वार झुण लगाड़े। आरु पोर्या माईन पयला खुळान बाळो मखे आपजी। ");
INSERT INTO dhn_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","तसोत् थारी गाय आरु गाडरो-बकड़ान पेहली पयदावारीन बी आपजी; सात दाहड़ा तक ते पीलो या नानलो बाळो आपसी माय को पास मा रये, आरु आठवे दाहड़े ओको मखे चड़ाय आप देजी। ");
INSERT INTO dhn_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","तुमु म्हार चुखला लोगहन बोनु; इना कारण सी जो ढुर खयड़ा मा फाड़ खादलो आरु मरलो जड़े उको मास झुण खाता, पुण उको कुतरान ओगळ न्हाक देजो। ");
INSERT INTO dhn_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","झुटी वात झुण फैलावे। अन्यायी गवा बनीन पापी मनुस को सात झुण देय। ");
INSERT INTO dhn_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","बुराय करने करीन गण सवटा पछल झुण जाय; आरु नी ते हेनका पछोळ फिरीन नियाव बिगाड़ने करीन गवाय देय; ");
INSERT INTO dhn_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","आरु गरीबन नियवा मा उना तरफ बी झुण हये। ");
INSERT INTO dhn_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","कदाम थारा वेरीन बयलीयो या गदड़ो खुवाय जाय आरु त्यो तुको भेटाये, ती उको उना पास मा छाचो पछो ली आवजी। ");
INSERT INTO dhn_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","जव उमा मनुस को गदड़ा क भार तळे दबायलो देखे, तव उना मनुस सी कुहराय क विसरीन उना गदड़ा को उठाड़नेम मदत कोर आरु गदड़ा को भार सी छुड़ाव। ");
INSERT INTO dhn_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","तारा लोगहन मा सी जो गरीब हय, उका पंचु मा उका नियाव को झुण बीगाड़े। ");
INSERT INTO dhn_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","झुटा नियाव सी दुर रयजी, आरु देरो गुणो नी हय आरु धरमी जन को कुड़ो हईन नुक्शान झुण करे, काहकी हांव दुष्ट को विन गुनाको नी बनावो, ");
INSERT INTO dhn_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","पयस्या झुण लेये काहकी पयस्या मनुस को छाचाय सी आंधवो कर देये आरु वीन गुनाकान नियाव को बिगाड़ देय। ");
INSERT INTO dhn_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","बाहर देश वाळा काजे दोमता झुण; तुमु ते बाहर देश वाळान मन को जानो, काहकी तुमु बी मिसर मा अनजानिया हुता। ");
INSERT INTO dhn_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","छव साल ते थारी जागा पर वेरजी आरु ओको ओनाज एख्टो करजी; ");
INSERT INTO dhn_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","पुण सातवा साल मा उको पड़वीति रयने देजी आरु तसोत् छुड़ देजी। ती तारा भाय बोन्या माईन गरीब लोगहन ओको खाय ओते, आरु जो काहिन उनासी वि वाचे त्यो जोंगली ढुरोक खानेम काम आवे। आपसी अंगुर आरु जैतुनन वाड़ी सी वी ओसाज कोरजु ");
INSERT INTO dhn_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","छव दाहड़ा तक थारो काम काज करजी, आरु सातवे दाहड़े आराम करजी काहकी थारा बयलीयो आरु गदड़ा आराम करे आरु थारी पावेरनीयान पोर्या आरु बाहर देश वाळा बी आपसा जीव को शेळो करे। ");
INSERT INTO dhn_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","जो काय हांव तुमरे सी कयो उना मा चोकचोळीया रयजु; आरु दिसरा देवतान नावन वात विचार मत करज, पुन त्या तुमरा मुय सी बी नी समळायनो चाहे। ");
INSERT INTO dhn_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","सालो डीट तीन वार म्हारे जुगे तीहवार वाळजु। ");
INSERT INTO dhn_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","अखमीरी रोटान तीहवार वाळजु; उनामा म्हारा हुकुमन अनसारे अबीब मोहना न टाकली टेम पर सात दाहड़ा तक अखमीरी रोटा खाया करजो, काहकी उना मोहना मा तुमु मिसर देश सी निकळीन आवला हुता। कुय वी मनुस म्हार दोरसोन क लिय ठाहरला हात झुन आवता। ");
INSERT INTO dhn_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","जव थारा वेरला खेतोन पेहली फसल उगीन तीयार हुय जाय, तव काटनीन तीहवार वाळजी। सालोन आखरी मा जव तु आरामन फोव भेळा करीन ढिक वाळलेय तव भेळा करनेन तीहवार वाळजी। ");
INSERT INTO dhn_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","सालो डीट तीनु वार थारा सब ओदेमड़ा योहोवा भगवान को अगळ होजुय हये। ");
INSERT INTO dhn_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","मारा चढ़ावला ढुरन लुहुय खमीरी रोटान साथ मा नी खानो, आरु नी म्हारा तीहवारन वारला चढ़ावा माईन काहय बी संदारे तक झुण रयने देता। ");
INSERT INTO dhn_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","थार खेतोन पेहली फसलन पेहलो वाटो योहोवा भगवान न भवन मा लावजी। गाडरा आरु बकड़ान पीला ओकी माय न दुत मा चुड़ेवता झुण। ");
INSERT INTO dhn_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“समळ, हांव एक दुत थारे ओगळ ओगळ मोकलो जो वाटिये थारी राखवाळी करसे, आरु जिना जागा को हांव तियार करलो छे उना मा तुक पुगाड़से। ");
INSERT INTO dhn_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","उना ओगळ जाळवायतो रयजी, आरु ओकी समळजी, ओको विरुद झुण करे, काहकी त्यो तुमरा पापोन को माफ नी करे; अतरान करीन कि उका मा म्हारो नाव रये। ");
INSERT INTO dhn_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","कदाम तु छाचो ओकी समळे आरु जो काय हांव कयो त्यो तु करे, ती हांव थारा वेरीन को वेरी आरु थारा दुश्मनोन दुश्मन बनीस। ");
INSERT INTO dhn_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","इनी रीति सी म्हारो दुत थारे ओगळ ओगळ चालीन तुको एमोरी, हित्ती, परिज्जी, कनानी, हिब्बी, आरु यबुसी लोगहन को या पुगाड़ीस, आरु हांव हेनको नाश करी दीस। ");
INSERT INTO dhn_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","हेनका देवता न को झुण वान्दे, आरु नी ते हेनकी भक्ति करे, आरु नी ते हेनका सारका काम करजी, पुण हेनी मुरतियान को आखो पुरो नाश कर देजी, आरु उन लोगहनन पुजान खंबा को टुकड़ा टुकड़ा कर देजो। ");
INSERT INTO dhn_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","तु थारा योहोवा भगवानन विनता करजी, तव त्यो थारा ओन जल पर सय बरकत आपसे, आरु थारे वीच मा रईन बिमारी पीड़ा दुर करसे। ");
INSERT INTO dhn_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","थारा देश मा नी ते कोय को पुरीयो खोखळाये आरु नी ते कोय वांजाय रयसे; आरु थारी उमर हांव पुरी करीस। ");
INSERT INTO dhn_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","जतरा लोगहन को वीच मा तु जाईस हेनो सबन मन मा हांव म्हारी बीक पेहल सी असो भर दीस कि हेनको घबराड़ दीस, आरु हांव तुको आखा वेरीन वासो देखाड़ीस। ");
INSERT INTO dhn_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","आरु हांव थार सी पेहल गेन्डरान मोखड़ा को मोकलीस जो हिब्बी, कनानी, आरु हित्ती लोगहन को थारे सामने सी ढसाड़ीन दुर कर देसे। ");
INSERT INTO dhn_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","हांव उन लोगहन को थार ओगळ सी एकात् साल मा नी निकाळो, असो नी हये कि देश उजड़ी जाय, आरु जंगली जोनवारीया वदीन तुको पीड़ा आपे। ");
INSERT INTO dhn_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","जव तारी गिनाय वोदीन देश को थारा हको मा नी कर लेय तव तक हांव हेनको थार ओगळ सी थोड़ा थोड़ा करीन निकाळतो रयीस। ");
INSERT INTO dhn_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","हांव रातला दरिया सी लगाड़ीन पलिश्तियान दरिया तक वाळा देश आरु जंगल सी लगाड़ीन फरात महानद तक क देश को थारा हको तळे कर दीस; हांव उना देशन रयनेवाळान को बी थारा हको तळे कर दीस, आरु हेनको आपने ओगळ रईन खरो निकाळ दीस। ");
INSERT INTO dhn_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","तु हेन लोगहन सी काय वात झुण वायदु कोरे आरु नी ते हेनका देवता सी। ");
INSERT INTO dhn_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","त्या थारा देश मा नी रयनो जुळे, असो नी हयनो जुळे कि त्या थार सी म्हार विरुद मा पाप करावे; काहकी कदाम तु हेनका देवतान विनता करीस, ती यो थार वाटे जाळ बन जासे।” ");
INSERT INTO dhn_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","ओळी मुसा सी कयो, तु, हारुन, नादाब, अबीहु, आरु इसराएलीयान सत्तर डाहडान को सात लावीन योहोवा भगवान क पास मा आवीन दुर सी आराधना कोरजी। ");
INSERT INTO dhn_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","आरु मुसा अतरोत योहोवा भगवान क पास मा आवजी; पुन त्या लोगहन पास मा नी आवनो, आरु दिसरा लोगहन उना सात मा ऊपर नी आवनो। ");
INSERT INTO dhn_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","तव मुसा लोगहन को पास मा जाईन योहोवा भगवान नी सब वात आरु सब नियम कायदा सुना दियो; तव सब लोगहन एकसारको रेंग निकाळीन बुलने लाग गीया। “जतरी वात योहोवा भगवान कयलो छे उनी सब वातोन को हामु मानसु।” ");
INSERT INTO dhn_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","तव मुसा योहोवा भगवानन सब वचन को लिख दीदो। आरु सोन्दारे उठीन बयड़ान नेचा एक बेदी आरु इसराएलन बारे गोत्रान ओनसारे खम्बा बनवाड़ीया। ");
INSERT INTO dhn_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","तव त्यो घण सवटा इसराएली जवानीया को मोकलीयो जे योहोवा क लिए होमबली आरु पशु को मेलबलि चढ़ावे। ");
INSERT INTO dhn_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","आरु मुसा आदो लुहुय लीन वाटका मा राखीयो, आरु आदो बेदी पर छिड़की दीदो। ");
INSERT INTO dhn_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","तव वाचान किपात को लीन लोगहन को भनीन सुनायो; उनी किताब को सुनीन त्या ळोगहन कया जो काय योहोवा भगवान कयलो छे उनी सब वात को हामु करसु, आरु ओको हुकुम मानसु। ");
INSERT INTO dhn_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","तव मुसा लुहुय को लीन लोगहन पर छिड़की दीदो, आरु उन लोगहन सी कयो, देखो, यो उनी वाचान लुहुय छे जिनीक योहोवा भगवान इनु सब वचन पर तुमरे साते बांधलो छे। ");
INSERT INTO dhn_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","तव मुसा, हारुन, नादाब, अबीहु आरु इसराएलीयान सत्तर डाहडा बयड़ा पर गीया, ");
INSERT INTO dhn_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","आरु इसराएलन योहोवा भगवान को दरशन करीया; आरु उना पायो तळे नीलमणीन सारको पाटलो हुतो, जो वादळा सारको जुगाळो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","आरु त्यो इसराएलीयान डाहडा पर हाथ नी बढ़ायो; तव त्या लोगहन योहोवा भगवानन दरशन करीया, आरु खादा पीदा। ");
INSERT INTO dhn_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","तव योहोवा भगवान मुसा सी कयो, बयड़ा पर म्हारे जुळ चढ़ीआव आरु वाँ सारी रय; आरु हांव तुको दगड़ान पट्टिया, आरु म्हारा लिखला नियम आरु हुकुम आपीस कि तु उन लोगहन को सिकाड़े। ");
INSERT INTO dhn_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","तव मुसा योहोसु नावन ओको मदतगार योहोवा भगवानन बयड़ा पर चढ़ी गीया। ");
INSERT INTO dhn_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","आरु डाहडा सी त्यो यो कय गयो, “इव तक हामु तुमरे जुळ पछा नी आवजे, तव तक तुमु यात् हामरी वाट जुळता रयजु; आरु समळो, हारुन आरु हुर तुमरे सात मा रयसे; ती कदाम कुदा मनुस को काहय नियाव करनो हय ती हेनको पास जाजो।” ");
INSERT INTO dhn_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","तव मुसा बयड़ा ऊपर चढ़ी गीयो, आरु वादळो बयड़ान को ढाक लीदो। ");
INSERT INTO dhn_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","तव योहोवान विजाळो सीनाय बयड़ा पर उतर आयो, आरु त्यो वादळो उना पर छव दाहड़ा तक छावयलोत् रीयो; आरु सातवे दाहड़े योहोवा भगवान मुसाक वादळान वीच मा रईन आयड़ीयो। ");
INSERT INTO dhn_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","आरु इसराएलीयान नजर मा योहोवा भगवानन विजाळो बयड़ान कातर पर घण जबर धोदेकतला आगठान सारको देखाय देतो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","तव मुसा वादळान वीच माईन भराईन बयड़ा पर चढ़ी गीयो। आरु त्यो बयड़ा ऊपर चालीस दाहड़ा आरु चालीस रात तक रीयो। ");
INSERT INTO dhn_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","योहोवा भगवान मुसा सी कयो, ");
INSERT INTO dhn_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","इसराएलीया सी यो असो कोय कि म्हारे जुगु भेट लावे; जतरा जन आपसी मरजी सी आपनो चाहे हेनु सब सी म्हारी भेंट लेजी। ");
INSERT INTO dhn_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","आरु जिना चीजोन भेट हेनका सी लेनो छे त्यो यो छे; सोनो, चाँदी, पीतल, ");
INSERT INTO dhn_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","आरु नीळ्ळा, जामनीया रंगोन आरु रातला रंगोन छिंदरा, सुवाळा‌ छिंदरा, आरु बकड़ान झोटा, ");
INSERT INTO dhn_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","रातला रंगो सी रंगायली गाडरीन खालड़ा, सुस नावोन मोटली माछीन खालड़ा, बाबळीयान लाकड़ा, ");
INSERT INTO dhn_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","विजाळा जुगु तेल, अभिषेक करने करी तेल आरु वारु सवादो गंधायने वाळा धूप जुगु गंधायनाय चीज, ");
INSERT INTO dhn_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","एपोद आरु राखवाळीन ढाळ क लिय छेल भातीया रंगोन घाटळा सुलेमानी दगड़ा, आरु लगाने क लिय मणि। ");
INSERT INTO dhn_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","आरु त्या म्हारे लिय एक चुखलो जागो बनावे, कि हांव हेनका वीच मा रया करो। ");
INSERT INTO dhn_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","जो काय हांव तुको देखाड़ो, मतलब रयनेन जागो आरु उना आखा सोमान सारको, उनात् अनसारे तुमु उको बनावाजो। ");
INSERT INTO dhn_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","बाबळीयान लाकड़ान एक घाटाळो सन्दुक बनावजो, ओकी नाम्बाय दुय हात ने आदो हात आरु चवड़ाय आरु ऊचाय डेढ़-डेढ़ हातन हुयनो जुळे। ");
INSERT INTO dhn_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","आरु उको चुखला सोना सी माहयतो आरु बाहर ढाळाड़जो, आरु सन्दुकन ऊपर चारो मेर सोनान वाड़ बनावजो। ");
INSERT INTO dhn_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","आरु सोनान चारो कड़ीया ढाळाड़ीन उना चारो पाया पर एक आरु दुय कड़ीया आरु दिसरे तरफ बी दुय कड़ीया लागाड़जो। ");
INSERT INTO dhn_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","ओळी बाबळ्यान लाकड़ान डान्डा बनवाड़जो, आरु हेनको बी सोना सी ढाळाड़जो। ");
INSERT INTO dhn_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","आरु डान्डान को सन्दुकन दुयो तरफन कड़ीया मा न्हाकजो जिना सी उना लारे सन्दुक को हाकले। ");
INSERT INTO dhn_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","त्या डान्डा सन्दुकन कड़ीया मा लागला रयनो जुवे; आरु उना सी अलग नी करनो हय। ");
INSERT INTO dhn_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","आरु जो गवायन पत्री हांव तुको आपीस उको उना पेटारा मा राखजी। ");
INSERT INTO dhn_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","ओळी चुखा सोनान एक पछतावान ढापनो बनाड़जी; ओकी नाम्बाय ढाय हात, आरु चवड़ाई डेढ़ हातन हयनो जुवे। ");
INSERT INTO dhn_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","आरु सोनो ढाळीन दुय पाखड़ावाळो जोनवार बनवाड़ीन पछतावान ढापनान दुयु छिवणिया पर लगवाड़जी। ");
INSERT INTO dhn_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","एक करुब ते एक छिवनीया पर आरु दिसरो करुब दिसरा छिवनीया पर लगवाड़जी; आरु करुबियान को आरु पछतावान ढाकना को उना टुकड़ा सी बनावीन उको दुयु छिवनीया पर लगवाड़जी। ");
INSERT INTO dhn_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","आरु उना करुबियान पाखड़ा ऊपर सी असा फैलायला बननो जुवे कि पछतावन ढाकना उना सी ढाकायललो रयनो जुवे, आरु हेनका मुय आम्बा साम्बा आरु पछतावान ढाकना तरफ रये। ");
INSERT INTO dhn_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","आरु पछतावान ढाकना को सन्दुकन ऊपर लगवाड़जी; आरु जो गवायन पत्री हांव तुको आपीस उको सन्दुकन माहय राखजी। ");
INSERT INTO dhn_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","आरु हांव उना ऊपर रयीन थार सी मेळीया करीस; आरु इसराएलीयान क लियन जतरो हुकुम हांव तुको आपीस, उनी आखी वातोन वाराम मा पछतावान ढाकनान ऊपर सी आरु उना करुबन वीच मा सी, जो गवायन पत्रीन सन्दुक पर हुयसे, थार सी वात करीया करीस। ");
INSERT INTO dhn_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","ओळी बाबळ्यान लाकड़ान एक मेज बनावजी; ओकी नाम्बाय दुय हात, आरु चवड़ाय एक हात, आरु ऊचाय डेढ़ हातन हुयनो जुळे। ");
INSERT INTO dhn_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","उको चुखला सोना सी ढाळाड़जी, आरु उना च्यारो मेर सोनान एक कुर बनवाड़जी। ");
INSERT INTO dhn_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","आरु उना च्यारो मेरन च्यार आंगळीन चवड़ी एक पट्टी बनवाड़जी, आरु इनी पटड़ीन च्यारो मेर सोनान एक कुर बनवाड़जी। ");
INSERT INTO dhn_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","आरु सोनान च्यार कड़ीया बनवाड़ीन मेजन च्यारो कुना मा लगवाड़जी जो उना च्यारो पायो मा हसे। ");
INSERT INTO dhn_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","त्या कोड़ा कुर क पास होये जेरेसी टेबल हुचलने क लिय डाण्डान वातड़ायीन काम देय। ");
INSERT INTO dhn_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","आरु डान्डान को बाबळीयान लाकड़ान बनावीन सोना सी ढाळाड़जी, आरु मेज हेनके लारे हाकलाय जाय। ");
INSERT INTO dhn_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","आरु ओकी परात आरु धूपदान, कुड़चिया आरु चाटलीया आरु रेड़ने करीन वाटका, सब चुखला सोना सी बनवाड़जी। ");
INSERT INTO dhn_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","आरु मेज पर म्हारे ओगळ भेटन रोटा छाचो मेलीया करजी। ");
INSERT INTO dhn_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","ओळते चुखला सोनान एक दिवो मेकनीयो खांबो बनवाड़जी। सोनो ढाळाड़ीन त्यो दीवल्यो, पाया आरु डान्डान को सात मा बनायो जाय; उको फुल सारको, गाठ आरु फुल, आरु सब एकुत् टुकड़ान बननो जुळे; ");
INSERT INTO dhn_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","आरु उका किनारा सी छव डाळीया निकळनो जुळे, तीन डाळीया ते दीवलीयान तरफ सी आरु तीन डाळीया ते दीवलीयान दिसरे तरफ सी निकवली हुयनो जुळे; ");
INSERT INTO dhn_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","एक-एक डाळी मा बोदामन फुलन सारका तीन-तीन पुष्पकोष, एक-एक गाठ, आरु एक-एक फुल हुयनो जुळे; दीवलीया सी निकळ्ली छवु डाळीयान सारकी बनली हुयनो जुळे आरु रक सारको रुप हुयनो जुळे। ");
INSERT INTO dhn_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","आरु दीवलियान डान्डा मा बादामन फुल कपो सारको च्यार पुष्पकोष आपसी-आपसी गाठ आरु फुलोन सात हयनो जुळे; ");
INSERT INTO dhn_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","आरु दीवलिया सी निकळ्ळी छव डाळीया माईन दुय-दुय डाळीयान नेचा एक-एक गाठ हयनो जुळे, त्या दीवलिया को सात एकत् टुकड़ा मा बनला हुयनो जुळे। ");
INSERT INTO dhn_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","हेनकी गाठ आरु डाळीया को सात एकत् टुकडाम हय, चुखला सोना को ढाळाड़ीन पुरो दीवलियो एकत् टुकड़ान बनवाड़जी। ");
INSERT INTO dhn_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","आरु सात दीवलिया बनवाड़जी; आरु दीवलिया धपाड़ीन जाय कि दिवटन सामने विजाळो हुये। ");
INSERT INTO dhn_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","आरु हेनका आगठो चुटनेन चिमटो आरु थाळी सब चुखला सोना हुयनो हुयनोप जुळे। ");
INSERT INTO dhn_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","त्यो सब इनु आखा सामान को भेळ चोतीस किला भरीन चुखला सोनान बननो जुळे। ");
INSERT INTO dhn_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","आरु चोकचोळीया रयीन इनी आखी चीजोन को उना नमुना सारको बनवाड़जी, जो तुको इना बयड़ा पर हांव देखाड़ियो। ");
INSERT INTO dhn_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","ओळी चुखलो जागा क लियन दस परदा बनवाड़जी; हेनको पातळी सुत वाळा आरु नीळ्ळा, रीन्गनिया आरु रातला रंगन छिंदरान होसे, आरु इना मा काहना वारला कारीगर सी करुबियान सात मा बनवाड़जी। ");
INSERT INTO dhn_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","एक-एक परदान नाम्बाय वीस ने आठ हात आरु चवड़ाय च्यार हातन हयनो जुळे; सब परदा एकत् मापन हुयनो जुळे। ");
INSERT INTO dhn_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","पाँचो परदा एक दिसरा सी जुड़ायला हुयनो जुळे; आरु ओळी जो पाँचो परदा रयसे त्या बी एक दिसरा सी जुड़ायला हुयनो जुळे। ");
INSERT INTO dhn_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","आरु जाँ सारी याँ परदा जुड़ायसे वाँ वाळा दुयु छोरो पर निळ्ळी- निळ्ळी फाँदी बनवाड़जी। ");
INSERT INTO dhn_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","दुयु छोरो मा पचास-पचास फाँदी असी लगवाड़जी कि त्या आमने-सामने हुयनो जुळे। ");
INSERT INTO dhn_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","आरु सोनान पचास हेकड़ा बनवाड़जी; आरु दुय परदान छल्‌लान को हेकड़ान लारे एक दिसरा सी असो जुड़वाड़जी कि निवास जागो मेळीन एकत् हुय जाय। ");
INSERT INTO dhn_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","ओळी निवासन ऊपर तम्बुन काम आपने क लियन बकड़ीन झटान गियारा परदा बनवाड़जी। ");
INSERT INTO dhn_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","एक-एक परदान नाम्बाय तीस हात आरु चवड़ाय च्यार हातन हुयनो जुळे; गियारा परदा एकत् मापन हुयनो जुळे। ");
INSERT INTO dhn_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","आरु पाच परदा अलग आरु छव परदा अलग जुड़वाड़जी, आरु छटवा परदा को तम्बुन सामने मुड़ी देजी। ");
INSERT INTO dhn_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","आरु तु पचास आकड़ा उना परदान छोर मा जो बाहर सी मेळाड़से आरु पचासुत् आकड़ा दीसरी तरफ मा जो बाहर सी मेळाड़से असो बनवाड़जी। ");
INSERT INTO dhn_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","आरु पीतळन पचास आकड़ान बनावजी, आरु हेकड़ा को परदा मा लगाड़ीन तम्बु को असो जुड़वाड़जी कि त्यो मेळीन एकत् हुय जाय। ");
INSERT INTO dhn_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","आरु तम्बुन परदा को टान्गायलो भाग, मतलब कि जो आदला पर रयसे, त्योत् निवास जागान पछली तरफ टान्गायलो रये। ");
INSERT INTO dhn_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","आरु तम्बुन परदन नाम्बाय माईन हात भर, उरो, आरु हात भर निवास को ढाकने क लियन हेनकी दुयु तरफ टान्गायलो रये। ");
INSERT INTO dhn_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","ओळते तम्बु वाटे रातला रंग सी रंगायली गाडरीन खालन एक पांगरुन आरु उना ऊपर सुइसोन खालोन बी एक पांगरुन बनवाड़जी। ");
INSERT INTO dhn_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","ओळते रोहनेन जागा को उबो करीन बाबळीयान लाकड़ान पाटिया बनवाड़जी। ");
INSERT INTO dhn_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","एक-एक पाटियान नाम्बाय दस हात आरु चवड़ाय डेढ़ हातन हुयनो जुळे। ");
INSERT INTO dhn_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","एक-एक पाटिया मा एक दिसरा सी जुड़ायली दुय-दुय खाचा हुयनो जुळे; निवासन सब पाटिया को इनीये रीतिये सी बनवाड़जी। ");
INSERT INTO dhn_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","आरु निवासन लियन जो पाटिया तु बनवाड़ीस उना मा सी वीस पाटिया ते दोखेवरे वाटे हयनो जुळे; ");
INSERT INTO dhn_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","आरु वीस पाटियान नेचो चाँदीन चालीस कुड़सीया बनवाड़जी, मतलब एक-एक पाटियान नेचो हेनका खाचान क लियन दुय-दुय कुड़सीया। ");
INSERT INTO dhn_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","आरु निवासन दिसरे तरफ, मतलब बोखेवरे वीस पाटिया बनवाड़जी। ");
INSERT INTO dhn_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","आरु हेनका लियन चाँदीन चाळीस कुड़ची बनवाड़जी, मतलब एक-एक पाटियान नेचा दुय-दुय कुड़ची हुयनो जुळे। ");
INSERT INTO dhn_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","आरु निवासन पछळ, मतलब बुडेवने भेनीन क लियन छव पाटिया बनवाड़जी। ");
INSERT INTO dhn_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","आरु पछला जागाम निवासन कुना क लियन दुय पाटिया बनवाड़जी; ");
INSERT INTO dhn_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","आरु या नेचा दुय-दुय भागन हुयनो जुळे आरु दुयु भागन ऊपरन मुनका तक एक-एक कड़ीया मेळाड़जी; दुयु पाटियान यो रुप हुयनो जुळे; या ते दुयु कुना क लियन हुयनो जुळे। ");
INSERT INTO dhn_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","आरु आठ पाटिया हय; आरु हेनकी चाँदीन सुळा कुड़चीहुयनो जुळे; मतलब एक-एक पाटियान नेचा दुय-दुय कुड़ची हुयनो जुळे ");
INSERT INTO dhn_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","ओळी बाबळीयान लाकड़ान डांडा बनवाड़जी, मतलब निवासन एक तरफ पाटिया क लियन पाच, ");
INSERT INTO dhn_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","आरु निवासन दिसरे तरफ पाच डांडा, आरु निवासन जो भाग दखेवरे भेनी पछळ्ळा भाग मा हुयसे, हेनका लियन पाच डांडा बनवाड़जी। ");
INSERT INTO dhn_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","वीचमावाळा डांडा जो पाटियान वीच मा हुयसे त्यो तम्बुन एक दिसरे छिवनीये तक पुगसे। ");
INSERT INTO dhn_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","ओळी पाटियान को सोना सी फाळाड़जी, आरु हेनका डांडा घरन काम देसे हेनको बी सोना सी ढाळाड़जी। ");
INSERT INTO dhn_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","आरु निवास क इनीये रीतिये उबो करजी जसो इना बयड़ा पर तुको हांव देखाड़ीयो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","ओळी नीळ्‍ळा, रींगनिया आरु रातला रंगन आरु वाटायली सुळावी सनीवाळा छिंदरान एक वीचमा वाळो परदो बनवाड़जी; त्यो विंदीन काम करीनिया करुबियान को सात मा बननो जुळे। ");
INSERT INTO dhn_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","आरु उको सोना सी ढाळायला बाबळीयान च्यार खाम्बा पर लटकाड़जी, ओकी हेकड़ीया सोनान हुयनो उळे, आरु या चाँदीन कुड़ची पर उबो रये। ");
INSERT INTO dhn_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","आरु वीचमा वाळा परदान हेकड़ीयान नेचो लटकाड़ीन, ओकी आड़ मा गोवान चिट्ठी सन्दुक माहयतो ली जाजी; अतरान करीन त्यो वीचमा वाळो परदो तुमरे लियन चुखला जागा को चुखामा चुखा जागा सी अलग रये। ");
INSERT INTO dhn_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","ओळी चुखाम चुखा जागा मा गोवान चिट्ठी सन्दुकन ऊपर पछतावान ढाकना को राखजी। ");
INSERT INTO dhn_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","आरु उना परदान बाहर निवासन दखेवरे भेनी मेज राखजी; आरु ओको बखेवरो भेनी मेजन सामने दीवलियान को राखजी। ");
INSERT INTO dhn_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","ओळते ओळी तम्बुन झोपलान लिये निळ्ळो, जामन्यो आरु रातला रंगन आरु सुतीन सुवाळा सनीवाळा छिंदरान उटनेन काम करलो एक परदो बनवाड़जी। ");
INSERT INTO dhn_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","एना पोरदा क टांगने क लिय बाबळ्यान लाकड़ान सोना सी घड़ायला पांच खांबा बोनावजु, हेनकी हेकड़िया सोनान होयनो जुवे आरु हेनका लिय पीतळन पांच कुड़चिया बोनावजो ");
INSERT INTO dhn_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","ओळी वेदी बाबळीयान लाकड़ान, पाच हात नांबी आरु पाच हात चवड़ी बनवाड़जी; वेदी चाय खुटाय होयनो जुळे, आरु हेकी उचाय तीन हातन होयनो जुळे। ");
INSERT INTO dhn_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","आरु उना च्यारो कुना पर च्यार सींग बनवाड़जी; त्यो उको सातमा एकुत् टुकड़ान हये, आरु उको पीतळ सी ढाळाड़जी। ");
INSERT INTO dhn_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","आरु ओको रुखड़ो चुटनेन ठिकरा, आरु पावड़िया, आरु वाटका, आरु दाताळ्यो पावड़ो, आरु सुपड़ीया बनवाड़जी; हेनको आखो सोमान पीतळन वनवाड़जी ");
INSERT INTO dhn_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","आरु उको पीतळन जाळीन एक झारु बनवाड़जी; आरु उको च्यारो छिवनीया मा पीतळन च्यार कड़ीया बनावड़जी। ");
INSERT INTO dhn_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","आरु उना झारा को वेदीन च्यारो मेर कंगनीन नेचो असो लगवाड़जी कि त्यो वेदी क उचान विच लोगुन पुगे। ");
INSERT INTO dhn_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","आरु वेदी लियन बाबळीयान लाकड़ान डांडा बनावजी; आरु उको पीतळ सी ढाळाड़जी। ");
INSERT INTO dhn_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","आरु डांडा कड़ा मा डालजे कि जव वेदी चुटे तव त्या हेनका भुरसे रोये। ");
INSERT INTO dhn_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","वेदीन तख्तो सी खोखली बनवाड़जी; जसो त्यो इना बयड़ा पर तुको देखाड़ीयो हुतो तसोज बनावजी। ");
INSERT INTO dhn_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","ओळी निवासन आंगना को बनावजी। उको दोखेवरे तरफ ते वाटयला सुवाळा छिंदरान सब परदा मेळावीन ओकी नाम्बाय सोव हातन हय; एक तरफ ते हतरोत् हयनो जुळे। ");
INSERT INTO dhn_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","आरु हेनका लिय वीस खाम्बा बनवाड़जी, आरु हेनको वाटे पीतळन वीस कुरचिया बनी, आरु खाम्बान छोल्‌ला आरु हेनकी पट्टी चाँदीन हय। ");
INSERT INTO dhn_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","आरु उना रीतिये आँगनान बखेवरे भेनी नाम्बाय बी सोव हात नाम्बो परदो हय, आरु हेनको वाटे बी वीस खाम्बा आरु हेनका वाटे बी पीतळन वीस खाचा हये; आरु उना खाम्बान छोल्‌ला आरु पट्टीया चाँदीन हुयनो जुळे। ");
INSERT INTO dhn_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","ओळी आँगनान चवड़ाय मा दखेवरे भेनी पचास हातन परदा हुयनो जुळे, आरु हेनका वाटे दस खाम्बा आरु खाचा बी दस हुयनो जुळे। ");
INSERT INTO dhn_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","एक तरफ बी आँगनान चवड़ाय पचास हातन हुयनो जुळे। ");
INSERT INTO dhn_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","आँगनान झोपलान एक तरफ पन्द्रह हातन परदा हुयनो जुळे, आरु हेनका वाटे बी तीन खाम्बा आरु तीन खाचा हुयनो जुळे। ");
INSERT INTO dhn_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","आँगनान झोपलान दिसरे तरफ पन्द्राह हातन परदा हुयनो जुळे, हेनका वाटे बी खाम्बा तीन आरु खाचा बी तीन हुयनो जुळे। ");
INSERT INTO dhn_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","आँगनान झोपला वाटे एक परदो बनवाड़जी, जो नीळ्ळा, जामनीया आरु रातला रंगन छिंदरा आरु वाटायला सुवाळा छिंदरान घाटाळो बनलो वीस हातन हुयनो जुळे, हेनको वाटे खाम्बा च्यार आरु खाचा बी च्यार हुयनो जुळे। ");
INSERT INTO dhn_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","आँगनान च्यारु मेर सब खाम्बा चाँदीन पट्टीया सी जुड़ायाला हुयनो जुळे, हेनकी छोल्‌ला च्यार चाँदीन आरु खाचा पीतळन हुयनो जुळे। ");
INSERT INTO dhn_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","आँगनान नाम्बाय सोव हातन, आरु ओकी चवड़ाय पचास हातन, आरु परदानन उचाय पचास हातन हुयनो जुळे, ओकी परदा सुवाळा छिंदरा बनली हुयनो जुळे, आरु खाम्बान खाचा पीतळन हुयनो जुळे। ");
INSERT INTO dhn_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","निवासन जागान भाती–भातीन ठाहरा आरु समान आरु उना सब खुँटा आरु आँगनान बी सब खुटा पीतळन हुयनो जुळे। ");
INSERT INTO dhn_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","ओळी तु इसराएलीयान को यो हुकुम आपजी, कि म्हारे पास दीवलीया वाटे कुटिन निकव्ळा जैतुन चुखलो तेल ली आवजी, जिना सी दीवलीया सलींग धपता रये। ");
INSERT INTO dhn_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","परमेश्वरन होजरी वाळा तम्बु मा, उना वीचमा वाळा परदा सी बाहर जो गवान चिट्ठी ओगळ हसे, हारुन आरु उना पोर्या दीवलीयान को सांतो सी लगाड़ीन सोन्दारे तक योहोवा भगवानन सामने सजाळीन मेले। यी रीति इसराएलीयान पीढ़ी वाटे जोलमकी बनली रयसे। ");
INSERT INTO dhn_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","ओळी तु इसराएलीयान मा सी थार भाई हारुन, आरु नादाब, अबीहु, एलीयाजर आरु ईतामार नावन उना पोर्यान को तारे पुठी ली आवजी कि त्या म्हारे लिये पुजारान को काम करे। ");
INSERT INTO dhn_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","आरु तु थारा भाई हारुन लिये वारु ठाट बाटन छिंदरा आरु सुबे असो चुखो छिंदरो बनावजी। ");
INSERT INTO dhn_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","आरु जतरा जनान जीव मा ओकल छे, जिनको हांवो ओकल आपने वाळी आत्मा सी भरलो छे, हेनको तु हारुनन छिंदरा बनावनेन हुकुम आप दे कि त्या म्हारेन करीन पुजारान को पवित्र काम करे। ");
INSERT INTO dhn_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","आरु जो छिंदरा हयेनको बनावनो छे त्या या छे, मतलब सीनाबन्द आरु एपोद, आरु चोगला, च्यार खानान मोटली शाल, खान्दानी पागड़ी, आरु कड़ीयान वातड़ो पट्टो; यात् चुखला छिंदरा थारा भाई हारुन आरु उना पोर्यान क लियन बनावजो कि त्या म्हारेन करीन पुजारान को काम करे। ");
INSERT INTO dhn_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","आरु त्या सोनान आरु नीळ्ळा आरु जामनीया आरु रातला रंगन आरु सुवाळा छिन्दरा ले। ");
INSERT INTO dhn_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","त्या एपोद को सोनान, आरु नीळ्‍ळा, जामनीया आरु रातला रंगन छिंदरान आरु छानला सुवाळा बुरान छिंदरा बनावे, जो कि वारु रीते विंदनीयान हातन काम हय। ");
INSERT INTO dhn_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","आरु त्यो इनीये रीतिये सी जुड़ाय जाय कि उका दुयु कांधान छिवनीया पछा भेसकायला रये। ");
INSERT INTO dhn_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","आरु एपोद पर गुतायलो पट्टो हसे ओकी बनावट उनात् अनसारे हय; आरु त्या दुयु विगुर जुड़न हय, आरु सोनान आरु नीळ्ळा, जामनीया आरु रातला रंग वाळा आरु छिनला सुवाळा छिंदरान हय। ");
INSERT INTO dhn_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","ओळी दुय सुलेमानी मनि लीन उना पर इसराएलीयान पोर्यान नाव खुंदवाड़जी। ");
INSERT INTO dhn_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","हेनका नाव मा सी ते छव ते एक मणि पर आरु वाचला छव नाव दिसरी मणि पर, इसराएलन पोर्यान पोयदावारीन अनसारे खुंदवाड़जी। ");
INSERT INTO dhn_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","मणि छाळवने वाळान कामन अनसारे जसा चापा कुरिन जाय, हसात उनी दुय मणिया पर इसराएलन पोर्यान नाव कुराया; आरु हेनको सोनान खाचा मा जुड़ाय देजी। ");
INSERT INTO dhn_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","आरु दुयु मणियान एपोदन कांधा पर लगवाड़जी, त्या इसराएलीयान को लोगात फोम देवाड़ने वाळी मणि बनसे; मतलब हारुन आरु हेनको नाव योहोवा भगवान ओगळ दुयु कांधा पर फोम करने करीन लगाडलो रये। ");
INSERT INTO dhn_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","ओळी सोनान खाचा बनवाड़जी; ");
INSERT INTO dhn_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","आरु दुयड़ा सारको गुथायला दुय शाकळ चुखला सोनान बनवाड़जी; आरु गुथायला शाकळन उना खाचा मा जुड़वाड़जी। ");
INSERT INTO dhn_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","ओळी नियावन छातीयो बांदनेन छिंदरो को बी विंदनेन काम आवने वाळो बनवाड़जी; एपोदन समान सोना, आरु नीळ्ळा, जामनीया आरु रातला रंगन आरु वाटायला सुवाळा छिंदरान उको बनवाड़जी। ");
INSERT INTO dhn_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","त्यो च्यार खुटीयो आरु दुय तरफीयो, आरु ओकी नाम्बाय आरु चवड़ाय एक-एक वेहतन। ");
INSERT INTO dhn_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","आरु उनामा खास दोगड़ान च्यार हालोर मणि जुड़जी। पेहली हालोर मा ते माणिक्य, पद्मराग आरु लालड़ी हय; ");
INSERT INTO dhn_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","दिसरी हालोर मा मरकत, नीलमणि आरु हीरा; ");
INSERT INTO dhn_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","तीसरी हालोर मा लशम, सुर्यकान्त आरु नीलम; ");
INSERT INTO dhn_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","आरु चवथी हालोर मा फीरोजा, सुलेमानी मणि आरु यशब हय; या सब खाचा मा जुड़ायनो जुळे। ");
INSERT INTO dhn_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","आरु इसराएलन पोर्यान जतरा नाव हतरी मणि हय, मतलब हेनका नावन गिनतीन अनसारे बारेह नाव खुंदे, बारेह जाती मा सी एक-एकन नाव एक-एक मणि पर असो खुंदाड़ जसो छापा खुंदे। ");
INSERT INTO dhn_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","ओळी राखवाळीन ढाळ छिंदरा पर दुयड़ा सारको गुथायला चुखला सोनान जंजीर लगवाड़जी; ");
INSERT INTO dhn_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","आरु राखवाळीन ढाळ छिंदरा मा सोनान दुय कड़िया लगवाड़जी आरु दुयु कड़िया को राखवाळीन ढाळ छिंदरा दुयो छिवनीया पर लगवाड़जी। ");
INSERT INTO dhn_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","आरु सोनान दुयो गुथायला जंजीरोक उना दुय कड़िया मा जो राखवाळीन ढाळ छिंदरान छिवनीया पर हुयसे उको लगवाड़जी। ");
INSERT INTO dhn_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","आरु गुथायला दुयो जंजीरोन दुयो रयला छिवनीया दुयो खाना मा जुड़ावाड़ीन एपोदन दुयो कांधान बाधायला पर उना सामने लगवाड़जी। ");
INSERT INTO dhn_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","ओली सोनान दुय आरु कड़िया बनावीन राखवाळीन ढाळ छिंदरान दुयो छिवनीया पर, ओकी उनी कुर पर जो एपोदन माहाय तरप लगाड़जी। ");
INSERT INTO dhn_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","ओळी हेनका विगुर सोनान दुय आरु कड़िया बनवाड़ीन एपोद क दुयो खांदा क बांदाय पोर, नेचो सी हेनका अगळ आरु हेनका जुड़ क पास एपोदन विंदला पोट्टा क उपोर लगवाड़जी। ");
INSERT INTO dhn_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","आरु राखवाळीन ढाळ आपसी कड़ीयान लारे एपोदन कड़िया मा नीळ्ळा बोंदो सी बांधजो, इनीये रीतिये त्यो एपोदन ढाळायला पट्टा पर बनली रये, आरु राखवाळीन ढाळ एपोद पर सी अलग नी हुयनो जुळे। ");
INSERT INTO dhn_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","आरु जव-जव हारुन चुखला जागा मा भराया करे, तव-तव‍ त्यो नियावन राखवाळीन ढाळ छिंदरा पर आपसा मनन ऊपर इसराएलीयान नावोक लगाड़लो रये, जिना सी योहोवा भगवानन सामने हेनको फोम जोलम रयसे। ");
INSERT INTO dhn_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","आरु तु नियावन राखवाळीन ढाळ छिंदरा मा ऊरीम आरु तुम्मीम को राखजी, आरु जव-जव हारु योहोवा भगवान सामने भराये, तव-तव त्या उना मनन ऊपर हय; इनीये रीतिये हारुन इसराएलीया क लियन योहोवा भगवानन आपसा मन पर योहोवा भगवानन अगळ एक सारको लागलो रये। ");
INSERT INTO dhn_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","ओळी एपोदन कुरता को पुरो नीळ्ळा रंगन बनावजी। ");
INSERT INTO dhn_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","ओकी बनावट असी हुयनो जुळे कि उना वीच मा विच मा छिवनीया न्हाकनेन डूचा हय, आरु उना डूचान च्यारो मेर कवच डूचान सारकी एक बुनली कोर हय कि त्यो नी फाटे। ");
INSERT INTO dhn_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","आरु उना नेचला घेरा मा‍ त्यारो मेर नीळ्ळ, जामनीया आरु रातला रंगन छिंदरान अनार बनवावड़जी आरु उना वीच-वीच च्यारो मेर सोनान घंटिया लगवाड़जी, ");
INSERT INTO dhn_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","मतलब एक सोनान घंटी आरु एक अनार, ओळी एक सोनान घंटी आरु एक अनार ईनीये रीतिये चोगलान नेचला घेरा मा च्यारो मेर असोत् हुये। ");
INSERT INTO dhn_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","आरु हारुन उना चोगलान सेवा चाकरी करनेन टेमे पहरीया करे, कि जव-जव त्यो चुखलो जागान माहय योहोवा भगवानन सामने जाय या बाहर निकळे, तव-तव ओकी ओवाज समळाय देय, नी ते त्यो मर जासे। ");
INSERT INTO dhn_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","ओळी चुखला सोनान एक पट्टी बनावजी, आरु जसो छापा मा हसोत् उना मा यो आकड़ा खुंदजी, मतलब योहोवा क लियन चुखलो होय। ");
INSERT INTO dhn_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","आरु उको नीळ्ळा बोंदो सी बांधजी; आरु त्यो पागड़ीन सामने वाळा भाग पर रये। ");
INSERT INTO dhn_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","आरु त्यो हारुनन मुनका पर रये, अतरान करीन कि इसराएली जो काय चुखो बनावे, मतलब जतरी चुखली चीज भेट चढावे उनी चुखली चीजोन को पाप हारुन हाकलतो रये। आरु हमीसा हेका माथा पोर रोहे, जिनासी योहोवा उनासी खुश रोहे। ");
INSERT INTO dhn_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","झोगला को सुवाळा छिंदरान च्यारा खाचान बनवाड़जी, आरु एक पागड़ी बी सुवाळा छिंदरान बनावड़जी, आरु हीर गुथलो एक कड़ीयान पट्टो बी बनवाड़जी। ");
INSERT INTO dhn_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","ओळते हारुनन पोर्यान करीन बी अंगरखा आरु कड़ीयान पट्टा आरु टुपिया बनवाड़जी; या छिंदरा बी ठाट बाटन आरु भाळे हसा बननो जुळे। ");
INSERT INTO dhn_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","थारा भाइस हारुन को आरु उना पोर्सयान को या सब छिंदरा पेहारवीन छिंदरा पहरावीन आरु तेल लगाड़ीन चड़ावनो आरु रीत भात करजी, आरु हेनको चुखा करजी कि त्या म्हारे लिये पुजारान काम। ");
INSERT INTO dhn_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","आरु हेनका लिये छिंदरान आदला चोड्डा बनावड़जी जिनु सी हेनको डील ढाकायलो रये; त्या कड़ीया मा सी जाँघ तकुन हुयनो जुळे; ");
INSERT INTO dhn_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","आरु जव-जव हारुन या उना पोर्या मिलापवाळा तम्बु मा भराया करे, या चुखला जागा मा सेवा चाकरी करनेन वेदी को पास मा जाय तव-तव त्या उना आदला चोड्डा को पेहरीन रये; असो नी हये कि त्या पापी बने आरु मर जाय। यो हारुन क लिये आरु उना बाद मा ओकी ओवलियाद क लिये बी जोलमन रीति बने। ");
INSERT INTO dhn_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","हेनको चुखा करने क ज काम तुखे हेनुक कोरनो छे की हुये मार लिय याजक क काम कोरे हुये ये छे: एक चुखला गिदल्यो आरु दुय चुखला गाडरा लेनो, ");
INSERT INTO dhn_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","आरु अखमीरी रुटा, आरु तेल सी चुपड़ायला हांवदान अखमीर वाळा पुरी, आरु तेल सी चुपेड़ली अखमीरी पपड़ियाँ वी लेनो। ये आखा गंहवन हांवदान बनवाड़जो। ");
INSERT INTO dhn_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","एनुक एक खिल्‌ला मा मेकिन हेनु खिल्‌ला क हेनु बछड़ा आरु हेनु दुयु गाडरा भेळ धोडे ली आवजो। ");
INSERT INTO dhn_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","ओळतेन हारुन आरु हेरा पुर्या क मिलापवाळा तम्बु क झोपला क धोड़ ली आविन पानी सी उँगवावजु। ");
INSERT INTO dhn_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","ती हेनु लुगड़ा क लीन हारुन क झोगलो आरु एपोद क कुरतो पेहरावजु, आरु एपोद आरु छातिये बांदनीयो, आरु एपोद क बनावलो पाटो वी बाधनु; ");
INSERT INTO dhn_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","आरु उना मुनका पोर पागड़ी मेलजी, आरु पागड़ी पर चुखला मुकुट क मेकजो। ");
INSERT INTO dhn_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","तव चुखला तेल लीन उका मुनका पर नांखीन उको अभिषेक कोरनो। ");
INSERT INTO dhn_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","ओळतेन हेरा पोर्यान को पास मा लावीन हेनको चोगला पेहरावजी, ");
INSERT INTO dhn_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","आरु उका मतलब की हारुन आरु उना पोर्यान को कड़ीया मा बाँधजी आरु हेनका मुनका पर टुपीया मेलजी; जिना सी पुजारान पद पर जलेमको हेनको हक रये। इनीये रीतिये सी हारु आरु उना पोर्यान को रीती करजो। ");
INSERT INTO dhn_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","तव बछड़ा को परमेश्वरन होजरी वाळा तम्बुन अगळ धोड़े ली आवजी। आरु हारुन आरु उना पोर्या बछड़ान मुनका पर आपसा-आपसाहात मेले, ");
INSERT INTO dhn_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","तव उना बछड़ा को योहोवा भगवानन सामने मिलापवाळा तम्बुन झपला पर बली करजी, ");
INSERT INTO dhn_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","आरु बछड़ान लुहुय मा सी थुड़क लीन आँगळीया सी वेदीन सींगड़ा पर लगाड़जी, आरु बाकी रयलो सब लुहुय को वेदीन पाया पर रेड़ देजी। ");
INSERT INTO dhn_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","आरु जिनी चर्बी सी आतड़ीया ढाकाय रये, आरु जी जाळ काळजान ऊपर रये, हेनकोप आरु दुयु गुरदा को हेनकी चर्बीन क सात मा लीन सबन को वेदी पर धपाड़जी। ");
INSERT INTO dhn_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","पुण बछड़ान मास को, आरु खाल, आरु गुबर, छावनी सी खयड़े आगठा मा धपाड़ देजी; काहकी यो पापबलि हुयसे। ");
INSERT INTO dhn_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","ओळते एक गाडरो लेजी, आरु हारुन आरु उना पोर्यान गाडरान मुनका पर आपसा-आपसा हात मेले, ");
INSERT INTO dhn_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","तव उना गाडरा को बलि करजी, आरु उना लुहुय लीन वेदी पर च्यारो मेर छिड़कजो। ");
INSERT INTO dhn_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","आरु उना गाडरा को टुकड़ा-टुकड़ा करीन काटजी, आरु ओकी आंतड़ा आरु पाय को धुवीन उका टुकड़ा आरु मुनका साथ मा मेलजो। ");
INSERT INTO dhn_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","उना पुरा गाडरा को वेदी पर धपाड़जी; त्यो ते योहोवा भगवान क लियन होमबली हुयसे; त्यो वारु गंदायन्यो वाळो आरु योहोवा भगवान क लियन हवन हुयसे। ");
INSERT INTO dhn_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","ओळी दिसरा गाडरा को लेजी; हारुन आरु उना मुनका पर आपसा- आपसा हात मेले, ");
INSERT INTO dhn_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","तव उना गाडरा को बलि करजी, आरु उना लुहुय मा सी थुड़क लीन हारुन आरु उना पोर्यान मुनका पर, आरु हेनका जेवड़ा हात आरु जेवड़ा पायन उमठा पर लगाड़जो, आरु लुहुय को वेदी पर च्यारो मेर छिड़कजो। ");
INSERT INTO dhn_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","ओली वेदी परुन लुहुयय को, आरु अभिषेकन तेल को, इनु दुय मा सी थुड़क-थुड़क लीन हारुन आरु उना छिंदरा पोर वी आरु पोर्या आरु हेनका छिंदरा पर बी छिड़की देजो; तव त्यो आप-सा छिन्दरान क सात मा चुखो हुय जासे। ");
INSERT INTO dhn_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","तव गाडरा को रीती वाळो जानीन उना मा सी चर्बी आरु जाडली छेमटी को, आरु जिनी चर्बी सी आतड़ीया ढाकाय रये उको, आरु काळजा पर वाळी जाळी को, आरु चर्बीन को सात मा दुयु गुरदा को, आरु जेवड़ीया कड़ीया को लेजो। ");
INSERT INTO dhn_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","आरु अखमीरी रोटान टुपलो जो योहोवा भगवानन अगोळ मेकली हसे उना मा बी एक रोटो आरु तेल सी सेकायला मेदान एक पुरी आरु एक पापड़ी लीन, ");
INSERT INTO dhn_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","इनु सबन को हारुन आरु उना पोर्यान को हात मा मेलीन उतारनेन भेट बनावीन योहोवा भगवान को ओगळ उतारनो जुळे। ");
INSERT INTO dhn_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","तव उनी आखी चीजन कोब हेनका हातो मा सी लीन होमबली न वेदी पर धपाड़ देजो, जिना सी त्यो योहोवा भगवान को सामने वारु गंदायन्यो वाळो बनसे; त्यो ते योहोवा भगवान क लियन हवन बनसे। ");
INSERT INTO dhn_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","ओळी हारुनन रीतीन जो गाडरो हुयसे ओकी छाती को लीन हालेवनेन भेट क लियन योहोवा भगवानन अगोळ हालेवजो; आरु त्यो तारो भाग बनसे। ");
INSERT INTO dhn_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","आरु हारुन आरु उना पोर्यान रीतीन जो गाडरो हुयसे, उना मा सी हालेवनेन भेटवाळी छाती जो हालेवने क लियन रये, आरु उठावनेन भेटवाळा कड़ीयो जो उठायो जाय इनु दुयन को चुखो बनसे। ");
INSERT INTO dhn_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","आरु ये जलोमन विधि आरु रीति पडर इसराएलीयान तरफ सी हारुन आरु उना पोर्यान भाग बने, काहकी यो उठावी जानेन भेट बनली छे; आरु यो इसराएलीन तरफ सी हेनको मेलबलिया मा सी योहोवा बगवान क लियन उठावी जानेन भेट हुयसे। ");
INSERT INTO dhn_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","हारुनन जो चुखलो बछिंदरो हसे‍ त्यो उना बाद मा उना पोर्या आरु पोर्यान पोर्या आरु घण झाजा को जड़तो रये, जिना सी हेनकोत् अभिषेक हेनको नियुक्त आरु रीती करीयो जाय। ");
INSERT INTO dhn_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","उना पोर्यान जो उना जागा पर जो पुजारो हुयसे, त्यो जव‍ चुखला जागा मका सेवा चाकरी करने करीन मिलापवाळा तम्बु मा पेहल आवे, तव उना छिंदरा को सात दाहड़ा तक पेहरला रये। ");
INSERT INTO dhn_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","ओळी पुजारान संस्कार को जो गाडरान हयसे उको लीन हेनको मास कोय चुखला जागा मा चुड़ावजो। ");
INSERT INTO dhn_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","तव हारुन उना पोर्यान को सात मा उना गाडरान मास आरु टुपला माईन रोटा, दुयन को मिलापवाळा तम्बुन झपला पर खाय। ");
INSERT INTO dhn_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","जिनी चीजन सी हेनको संस्कार आरु हेनको चुखो करने करीन पछतावो करे ती उको त्या खाय, पुण पारका जातन कोय बी नी खानो जुळे, काहकी त्या चुखला रयसे। ");
INSERT INTO dhn_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","कदाम संस्कार वाळा मास या रोटा मा सी थुड़क सन्दारे तक वाचाड़ रये, ती उना वाचला को नागठा मा धपाड़ देजो, त्यो खानो नी खाय; काहकी‍ त्यो चुखलो रयसे। ");
INSERT INTO dhn_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“हांव तुको जो-जो हुकुम आपलो छे, उना आखा हुकुमन अनसारे तु हारुन आरु उका पोर्यान सी करजी; आरु सात दाहड़ा तक हेनको संस्कार करतो रयजी, ");
INSERT INTO dhn_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","मतलब पापबलिन एक बछड़ो पछतावा क लियन दाहड़ीन चढ़ावजी। आरु वेदी को बी पछतावो करनेन टेम पर चुखो करजी, आरु उको चुखो करने करीन उको अभिषेक करजी। ");
INSERT INTO dhn_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","सा दाहड़ा तक वेदीन पछतावो करीन उको चुखो करजी आरु वेदी चुखामा चुखी बनसे; आरु जो काय उना सी छिमायसे त्यो बी चुखो हुय जासे। ");
INSERT INTO dhn_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“जो तुको वेदी पर दाहड़ीन चढावो चढ़ावनो रयसे त्यो यो छे; मतलब कि दाहड़ीन एक-एक सालन दुय गाडरान पीला। ");
INSERT INTO dhn_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","एक गाडरान पीलाक ते भोळभाकाम आरु दिसरा गाडरान पीलाक सान्ती टेम पर चढ़ावजी। ");
INSERT INTO dhn_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","आरु एक गाडरान पीलान को सात मा दुय लिटर तेल सी झारलो एक किलो मैदो आरु बलिन करता दुय किलो दाखमधु चढ़वनो। ");
INSERT INTO dhn_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","आरु दिसरा गाडरान पीला को सान्ते टेमे चढ़ावजी, आरु उना सात मा भोळभाकान रीतिन अनसारे अन्नबलि आरु अर्घ दुयु आपजो, जिना सी कि त्यो वारु गंदायन्या वाळो आरु योहोवा भगवान क लियन हवन ठहरे। ");
INSERT INTO dhn_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","तुमरी पीढ़ी सी पीढ़ी मा योहोवा भगवानन अगोळ मिलापवाळा तम्बुन झोपला पर लोगत असोत् होमबली हुया करे; यो त्यो जागो छे जिनाम तुम लोगहन सी अतरान करीन मेञळ भेट करतो रयीस कि तुमरे सी वात करीया करो। ");
INSERT INTO dhn_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","हांव इसराएलीयान सी वाँत् मेळ भेट करीया करीस, आरु त्यो तम्बु म्हारा सेक सी चुखलो हुय जासे। ");
INSERT INTO dhn_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","आरु हांव मिलापवाळा तम्बु आरु वेदी को चुखो करीया करीस, आरु हारुन आरु उना पोर्या को बी चुखो करीया करीस कि त्या म्हारे लिये पुजारान को काम करे। ");
INSERT INTO dhn_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","आरु हांव इसराएलीयान वीच मा रया करीस, आरु हेनको योहोवा भगवान बनीस। ");
INSERT INTO dhn_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","तव त्या लोगहन जान जासे कि हांव हेनको योहोवा भगवान छे, जो हेनको मिसर देश सी निकाळीन ली आयो, कि हांवत् हेनको योहोवा भगवान छे। ");
INSERT INTO dhn_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“ओळी धुप दपाड़ने वाटे बाबळीयान लाकड़ान वेदी बनावजी। ");
INSERT INTO dhn_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","ओकी नाम्बाय एक हातन आरु चवड़ाय एक हातन हुयनो जुळे, त्यो च्यार कुनीयो हुयनो जुळे, आरु ओकी उचाय दुय हातन हुयनो जुळे, आरु उना सींगड़ा उना टुकड़ा सी बनाया जासे। ");
INSERT INTO dhn_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","आरु वेदीन उपर वाळा पल्‌ला आरु च्यारो मेरन टेकान आरु सींगड़ाक चुखा सोना सी ढाळड़जी, आरु हेनको च्यारो मेर सोनान एक वाड़ बनावजी। ");
INSERT INTO dhn_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","आरु ओकी वाड़न नेचो उना आमने-सामनेन दुयो पल्‌लान पर दुय-दुय सोनान कड़ीया बनावीन हेनका दुयु तरफ लगाड़जी, त्या हेनको हाकलने वाटे डान्डान काम देसे। ");
INSERT INTO dhn_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","डाण्डान को बाबळीयान लाकड़ान बनावीन हेनको सोना सी ढाळजी। ");
INSERT INTO dhn_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","आरु तु उको उना परदान ओगळ राखजी जो गवान चिट्ठी सन्दुकन सामने छे, मतलब पछतावान ढाकनान ओगळ जो गवान चिट्ठी उपर छे, वांत् हांव थार सी मेळ भेट करीया करीस। ");
INSERT INTO dhn_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","आरु उनी वेदी पर हारुन वारु गंधायने वाळो धुप धपाड़ीया करे; दाहड़ीन सोन्दारे जव त्यो दीवा ओ ठीक करे तव त्यो धूप धपाड़े, ");
INSERT INTO dhn_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","आरु सांतेन टेमे जव हारुन दीवलीयान को धपाड़े तव धूप धपाड़्या करे, यो दुप योहोवान सामने तुमरी पीढ़ी पीढ़ी तक जोलम धपाड़ीया करे। ");
INSERT INTO dhn_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","उनी वेदी पर कोय दिसरी भाँतीन दुप नी धपड़नो, आरु नी उना पर होमबली आरु नी ते अन्नबलि चढ़ावजो; आरु नी ते उना पर अर्घ देजो। ");
INSERT INTO dhn_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","हारुन साल मा एक वार सींगड़ा पर पछतावो करे; आरु तुमरी पीढ़ी-पीढ़ी मा सालम एक वार पछतावन पापबलिन लुहुय सी इनीये रितिये पछतावो करता जाय; यो योहोवा वाटे चुखा मा चुखो छे।” ");
INSERT INTO dhn_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","तव योहोवा मुसा सी कयो, ");
INSERT INTO dhn_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“जव तु इसराएलीयान गिनती लेने लाग्या, तव गिननेन टेमे जिन्दरी गिनती हुय गई त्या आपसा-आपसा जीवोन वाटे योहोवा क छुटकारान करता, भगवान को किमत आपसु जिना सी तु हेनकी गिनती करतो रये उनी टेमे काहय पीड़ा हेनको उपर संकट नी आय पड़े। ");
INSERT INTO dhn_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","जतरा लोगहन गिनाय जाय त्या चुखला जागान शेकेलन अनसारे आदा‍ शेकेल आपे, यो शेकेल वीस गेरान हुये, योहोवान भेट आदो शेकेल हुयनो जुळे। ");
INSERT INTO dhn_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","विस साल क एने हेरेसी जादा वेवोसता क जोतरा गिनाय जाय हेरेम सी एक एक जोनु योहोवा क रुपीया आपे। ");
INSERT INTO dhn_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","जब तुमरा जीवो प्राण क पछतावो क निमित्त योहोवा क रुपीया चोड़ायो जाय, ती नी ते धोनवान मानसे शेकेल सी जादा आपे; आरु नी गोरिब मानसे हेरेम सी कोम आपे। ");
INSERT INTO dhn_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","आरु तु इसराएलीयो सी पछताव क रुप्‌या लिन मिलापवाळा तम्बु क काम मा लागाड़े; जेरेसी हुयो योहोवा क ओगळ इसराएलीयो क फोमकरनेन सोहलानीन कोहाये, आरु होका जीवो क पश्चाताप वी होये।” ");
INSERT INTO dhn_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","योहोवा न मुसा सी कयो, ");
INSERT INTO dhn_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","धुवने क लिय पितळ क एक मोटलो तपलो, आरु ओक जोड़लो वी पितळन बोनावजु। ओक मिलापवाळा तम्बु आरु वेदीन विच मा मेकिन ओक मा पानी भोर देनो; ");
INSERT INTO dhn_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","आरु हेरेम हारुन आरु उना पुर्या आपना आपना हात पाय धुया कोरे। ");
INSERT INTO dhn_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","जव जव हुये मिलापवाळा तम्बु मा भोराया कोरे ती ती हुये हात पाय सी धुवे, नी ती मोर जासे, आरु जब जब हुये वेदी क पास सेवा चाखरी कोरने, यानी योहोवा क लिय हवन धोपाड़ने क आवे ती ती हुये हात पाय धुवे, ओसो नी होय की उको मोर जाय। ");
INSERT INTO dhn_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","यो हारुन आरु ओसी पीढ़ी पीढ़ी क ओवलियाद क लिय होमीसा क विधी कोहाये। ");
INSERT INTO dhn_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","ओलतेन योहोवा न मुसा सि कोयो, ");
INSERT INTO dhn_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“तु वारु सी वारु गोंदायन्या मोसाला ले, यानी चुखलाजागा क शेकेल क ओनसारे पाच सोव शेकेल आपने आप निकाळ्यो हुयो गोंदायनीयो रस, आरु ओक आधो, यानी ढाई सोव शेकेल गोंदायन्यो मोसालाम वाळो झाड़ोन पुपड़ो, आरु ढाई सोव शेकेल गोंदायन्यो अगर मसालो, ");
INSERT INTO dhn_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","चुखला स्थानक तेलक अनसारे छोव किला तेजपान आरु चार लिटर जैतुनन तेल लेनु। ");
INSERT INTO dhn_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","हेनुसी आंगे कोरलो चुखलो तेल, यानी गन्दायनीयान रीती सी तियार कोर्‌यो हुयो गोंधायन्या तेल बोनावनो; यो अभिषेक क चुखो तेल कोहाये। ");
INSERT INTO dhn_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","आरु हेरेसी मिलापवाळा तम्बु क, आरु गोवान चिट्ठी सन्दुक क, ");
INSERT INTO dhn_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","आरु आखा सोमान भेळ टेबलन, आरु सोमान भेळ भीतन, आरु धुपवेदीन, ");
INSERT INTO dhn_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","आरु आखा सोमान भेळ होमबली, आरु पाया भेळ मोटला तोपलान को सजाय देजो, ");
INSERT INTO dhn_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","आरु ओक चुखो कोरनो, जेरेसी हुयो परम चुखलो कोहाये; आरु ज काय हेरेसी छिम्यो जासे त्यो चुखो होय जासे। ");
INSERT INTO dhn_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","ओळी हारुन क हेका पुया क सात अभिषेक कोरनो, आरु ओस कोरिन हेनुक मारे लिय याजक क काम करने क लिय चुखो कोरनो। ");
INSERT INTO dhn_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","आरु इसराएलीयो क मारी यी हुकुम सोमवाड़नो, यो तेल तुमरी पीढ़ी पीढ़ी मा मारे लिय चुखो कोरलो तेल होयसे। ");
INSERT INTO dhn_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","यो कुदा मानुस क डिल पोर नी नाख्यो जाय, आरु मिलावट मा ओक जसो आरु काई नी बोनजो; यो चुखलो छे, यो तुमरे लिय वी चुखलो होयसे। ");
INSERT INTO dhn_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","ज काई ओक जसो काई बोने, एने जो कुदु एरेम सी काई पारका कुलवाळा पोर लागाड़े, हुये आपना मानसो मा सी नाश होय जासे।” ");
INSERT INTO dhn_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","ओळी योहोवा न मुसा सी कोयो, “बुल, नखी आरु कुन्दरु, ये गोंदायन्या चिज चुखला लोबान भेळ ली लेजो, यी सब एक तोल क होय, ");
INSERT INTO dhn_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","आरु ओक धुप यानी नोन भेसकीन गंदायनेन रीतीन ओनसारे चुखो आरु चुखो गोंदायन्यो चिज बोनावनो। ");
INSERT INTO dhn_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","ओळी हेरेम सी काहिन दोविन झिनो कोर देजो, ती हेरेम सी काई मिलापवाळा तम्बु मा गोवापत्र क ओगळ, जा पोर हांव तारसी मिळ्या कोरीस, राखजी; हुयो तुमरे लिय परम चुखलो होयसे। ");
INSERT INTO dhn_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","ज धूप तु बोनाविस, मिळावट मा ओक जसो तुमु मानसे आपने लिय आरु काई नी बोनावनो; हुयो तुमरे ओगळ योहोवा क लिय चुखलो होयसे। ");
INSERT INTO dhn_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","ज काई सुंगने क लिय ओक जसो काई बोनावे हुयो आपना मानसो मा सी एक जन छे। ओका तरह नी हिवनो जासे।” ");
INSERT INTO dhn_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","ओळी योहोवा न मुसा सी कोयो, ");
INSERT INTO dhn_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“सोमोळ, हांव ऊरीन पुर्य बसलेलन, जो हुर क पोतो आरु यहुदान घोरानान छे, नाव लिन बुलावो। ");
INSERT INTO dhn_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","आरु हांव उना परमेश्वरन आत्मा सी ज ओकल, हुसीयार, गियान, आरु सब भातिन कामो क सोमोज आपनेवाळो आत्मा छे, पुरोनपुरो कोरो, ");
INSERT INTO dhn_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","जेरेसी हुयो कारीगरीन काम ओकोल सी निकाळीन सब भातिन बोनावोट मा, सोना, चाँदी, आरु पितळ मा, ");
INSERT INTO dhn_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","आरु लगाड़ने लिय मणि काटने मा, आरु लाकड़ा पोर नक्काशीन काम कोरे। ");
INSERT INTO dhn_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","आरु सोमोळ, हांव दानन गोत्रवाला अहीसामाकन पुर्य ओहोलीआबन उना पुठी कोर देये छे; बाखुन जोतरा ओकल मान छे हेनु सबन काळजा मा हांव ओकोल आपो छे, जेरेसी जोतरी चिजोन हुकुम हांव न तुखे आपलो छे हेनु सबोक हुये बोनावे; ");
INSERT INTO dhn_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","यानी मिलापवाळा तम्बु, आरु गोवान चिट्ठी सन्दुक आरु हेर पोरन पोशतावा वाळा ढकना आरु तम्बुन आखो सोमान, ");
INSERT INTO dhn_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","आरु सोमान भेळ टेबल, आरु आखा सोमान भेळ चुखला सोनान दिवो, आरु धूपवेदी, ");
INSERT INTO dhn_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","आरु आखा सोमान भेळ होमबली, आरु पाया भेळ मोटलो तोपलो, ");
INSERT INTO dhn_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","आरु विंदला छिंदरा, आरु हारुन याजकन याजकवाळा कामन चुखला छिंदरा, आरु उना पुर्यान छिंदरा, ");
INSERT INTO dhn_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","आरु ओलोग कोरलो तेल, आरु चुखला जागान लिय गोंदायन्यो धुप, एनु आखान त्या उना आखा हुकुमोन ओनसारे बोनाये जो हांव तुखे आपलो छे।” ");
INSERT INTO dhn_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","ओळतेन योहोवा मुसा सी कोयो, ");
INSERT INTO dhn_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“तु इसराएलीयो सी असो वी कोहजी, छाचिन तुमु मारा आरामोन दाहड़ाक माननो, काहकी तुमरी पीढ़ी पीढ़ी मा मारा आरु तुमु मानसोन विच यो एक सोहलानी कोहायसे छे, जेरेसी तुमु यी वात जान राखु की योहोवा हामरो चुखलो कोरने वाळो छे। ");
INSERT INTO dhn_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","ओस करीन तुमु आरामोन दाहड़ाक मानजु, काहकी हुयो तुमरे जुगु चुखलो कोहाये छे; जुळ हेको विटोळ कोरे त्यो छाचिन मार नाख्यो जाय: जुळ कुय तेने दाहड़े मा काई काम-काज कोरे हुयो जीव आपना मानसोन वीच सी निकाळे जाय। ");
INSERT INTO dhn_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","छोळ; दाहड़ा काम-काज कोरजो, बाखुन सातवे दाहड़े परम आरामोन दाहड़ो आरु योहोवा लिय चुखलो छे; एकालिय जुळ कुय काई आरामोन दाहड़े मा काई काम-काज कोरे हुयो छाचिन मार नाख्यो जाय। ");
INSERT INTO dhn_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","एकालिय इसराएली आरामोन दाहड़ाक मान्या कोरे, बाखुन पीढ़ी पीढ़ी मा हेको जोलेमका वायदान वाराम जानीन मान्या कोरे। ");
INSERT INTO dhn_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","हुयो मारे आरु इसराएलीयोन वीच जोलेमका एक सोहलानी रोहसे, काहकी छव दाहड़ा मा योहोवान वादळा आरु कळीक बोनायो, आरु सातवे दाहड़े आराम कोरीन आपसो जीव सेवो कोरीयो” ");
INSERT INTO dhn_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","जब परमेश्वर मुसा सी सीनाय बोयड़ा पोर ओसी वात कोरीयो, ती त्यो हेको आपसु आँगळी सी लिखायली गोवान आपनेवाळी दोगड़ान दुये ओख्ये पाटिया आपीयो। ");
INSERT INTO dhn_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","जब लोगहन न देख्या की मुसाक बोयड़ा सी उतरने मा वार होय रोहली छे, ती हुये हारुन पास एकठा होईन कोहने लाग्या, “हेमी आमरे जुगु देवता बोनाव, जो हामरे ओगळ ओगळ चाले; काहकी उना मनुस मुसाक जुळ हामुक मिसर देश सि निकाळ ली आयो छे, हामु नी जानजे कि काय हुयो?” ");
INSERT INTO dhn_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","हारुन न उना लोगहन सी कोयो, “तुमरा बायरा आरु पुरीया पारीन कानटा मा सोनान जे टुकरीया छे हेनुक निकाळु, आरु म्हार पास ली आवु।” ");
INSERT INTO dhn_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","ती सब लोगहन हेनका कानटा सी सोनान टुकरीयाक निकाळीन, आरु हारुन पास ली आया। ");
INSERT INTO dhn_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","हारुन न हेनका हात सी लिदो, आरु एक सांछा मा न्हाख्या, आरु एक बछड़ो क घोड़ीन बोनायो, तव लोगहन कोहने लाग्या, “हे इस्राएल, तारो परमेश्वर जुळ तुमुक मिसर देश सी छुड़ाय लायो छे, हुयो योत छे।” ");
INSERT INTO dhn_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","यो देखिन क हारुन न उना ओगळ एक वेदी बोनवाड़्यो; आरु यो पोरचार कोर्‌यो, “वाहने योहोवा क लिय पर्व होयसे।” ");
INSERT INTO dhn_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","आरु दिसरे दाहड़े लोगहन वेगात उठिन होमबली चोढ़ाया, आरु आगठान बलि ली आया; ओळतेन बोठीन खादा पिदा, आरु गोळोत काम कोरने लाग्या। ");
INSERT INTO dhn_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","तब योहोवा न मुसा सी कोयो, “नेड़ो उतर जा, काहकी तारा पोरजान लोगहन, जेनको तु मिसर देश सी निकाळ लायु छे, त्या बिगोड़ गोयला छे; ");
INSERT INTO dhn_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","आरु जेनी वाटो पोर चालनेन हुकुम हांव हेनको आपलो हुतो उतवाळीया छुड़िन त्या एक बछड़ो घोड़ीन बोनाय लेदा, ओळतेन हेको वांद्या कोर्या, आरु हेका लिय बलिदान वी चोढ़ाया, आरु ओसा कोया, हे इसराएलीयो, तुमरो परमेश्वर जो तुमुक मिसर देश सी छुड़ाय ली आयो त्यो योत छे।” ");
INSERT INTO dhn_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","ओळतेन योहोवा न मुसा सी कोयो, “हांव एनु लोगहन क देख्यो, आरु सोमळ्यो, त्या एक होटीया छे। ");
INSERT INTO dhn_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","हेमी मेसे मा रुके, म्हार रीस हेनका पोर भड़क रोय, जिनासी हांव हेनको नाश कोरो; पुन तारेसी एक मोटो मुलुक बोनावीस।” ");
INSERT INTO dhn_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","तब मुसा आपसा परमेश्वर योहोवा असो कोहीन रावन्या करने लाग्यो, “हे योहोवा, तारी रीस आपसा लोगहन पोर काहा भोड़के, जेनको तु मोटा सामर्थ्य आरु ताकोतवाळ हातोन लारे मिसर देश सी निकाळ लावलो छे? ");
INSERT INTO dhn_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","मिसरी मानसे असो नी कोहने जुवे, ‘त्या हेनका भुंडा विचार सी बोयड़ा मा दीन धोरति पोर सी बुरवनेन मोन सी निकाळ ली गुयो?’ तु आपसा भोड़ेकला रीस क हुगो कोर, आरु आपसा लोगहन को असो नुकसान कोरने सी बोदली जा। ");
INSERT INTO dhn_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","आपसा दास अब्राहम, इसहाक, आरु याकुब काजे फोम कोर जेनुसी तु आपसोत वायदो कोरीन कयो हुतो, हांव तुमरा ओवलियादक वादळान सारका बेसका कोरीस, आरु यो आखो देश जेरी हांव वात कोर्‌यो छे तुमरा ओवलियाद क आपीस कि हुये उना होकदारीया होमीसा बोनला रोहे।” ");
INSERT INTO dhn_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","तब योहोवा आपनी प्रजा क हानी करने सीज ओक कोयो हुतो त्यो मन फिरायो। ");
INSERT INTO dhn_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","तब मुसा पोछफिरिन गोवा क दुयो तख़्तियो क हात मा लिन बोयड़ा सी उतरी गोयो। हेनी तख़्तियो क एन एने पोले दुयो ओख्ये लिख्यो हुयो हुतो, ");
INSERT INTO dhn_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","आरु हुयो पाटिया परमेश्वरन बोनावली हयी हुती, आरु हेनु पोर ज खुँदिन लिख्यो हुयो हुतो हुयो परमेश्वर क लिख्यो हुयो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","जव योहोसु लोगहन को आयड़नेन सारका सोमवाय पोड़्या, तव त्यो मुसा सी कोयो, “छावनी सी लोड़ायनेन सारको बुल सोमवाये छे।” ");
INSERT INTO dhn_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","त्यो कोयो, “ओसो कयो जे बुल छे, नी ते जीतनेवाळा क छे, आरु नी हारनेवाळा क छे; मेसे ते गावने क बुल सोमवाये छे।” ");
INSERT INTO dhn_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","छावनी क धोड़े आवतात् मुसा क हुयो बछड़ो आरु नाचनो देखा पोड़्यो, ती मुसा क कोप भड़क उठ्‍यो, आरु हुयो तख़्तियो क आपना हात सी बोयड़ा क नेचो नाखीन तुड़ नाखयो। ");
INSERT INTO dhn_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","तब हुये ओक बोनावला होया बछड़ा क लिन आगठा मा धोपाड़ देदो। आरु पीसकर झीनो झीनो कोर नाख्यो, आरु जळ क उपोर नाख देदो, आरु इसराएलीयो क ओक पिवाड़ देदो। ");
INSERT INTO dhn_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","तोत्यार मुसा हारुन सी कोहने लाग्यो, “एनु मानसो न तारो सात काय कोर्या कि तु न ओक ओतरा मोटा पाप मा फोसाड़्यो?” ");
INSERT INTO dhn_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","हारुन न जोपाप आप्यो, “मारा पोरबु क रिसस न भोड़क; तु ते एनु मानसो क जाने छे की ये भुंडाय मा मोन लागाड़ला रोहे छे। ");
INSERT INTO dhn_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","आरु हुये मारसी कोय, आमरे जुगु देवता बोनाव ज आमरे ओगळ ओगळ चाले; काहकी हउये मानुस मुसा क, ज आमुक मिसर देश सी छुड़ाविन लायो छे, हामु नी जानता की काय होयो? ");
INSERT INTO dhn_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","तोत्यार हांव न हेरेसी कोयो, ‘जे जेरे पास सोनान क गोहना होय, हुये ओक निकाय लावे;’ आरु जब हुये मक हुये आप्या, हांवन ओक आगठा मा नाख देदो, तोत्यार यो बछड़ो निकऴ पोड़्यो।” ");
INSERT INTO dhn_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","मुसा देख्यो कि हारुन न हेनु मानसो क ओसो बोदनाम नी आवे असो कोर देदो हुतो कि हुये आपसा विरोधियो क विच मोजाक सारका होय गोया। ");
INSERT INTO dhn_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","ओक निरंकुश देखिन मुसा न छावनी क झोपला पोर उबो होईन कोयो, “ज काइ योहोवा क भिनी क छे हुयो मारे पास आवे;” तित्यार आखा लेवी उना पास एकठा होया। ");
INSERT INTO dhn_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","हुये हेरेसी कोय, “इस्राएल क परमेश्वर योहोवा यो कोहे छे कि आपना आपना सातळा पोर तलवार लोटकाड़िन तम्बु क एक झोपला सी दिसरे लोगुन फिरि फिरिन आपना आपना भास्यो, संगियो, आरु पड़ोसियो क मार देवु।” ");
INSERT INTO dhn_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","मुसा क एना बुल क ओनसारे लेवीयो न कोर्या; आरु हेने दाहड़े हजार क ओड़े धोड़े मानसे मोर गोया। ");
INSERT INTO dhn_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","ओळतेन मुसा न कोयो, “आज क दाहड़े योहोवा क लिय आपनो याजकपद क संस्कार कोरु, बाखुन आपना आपना पुर्या आरु भास्यो क वी विरुद्ध होईन ओसो कोरु जेरेसी हुयो आज तुम क बोरकोत आपे।” ");
INSERT INTO dhn_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","दिसरे दाहड़े मुसा न मानसो सि कोयो, “तुम न मोटो पाप कोर्या छे। हेमी हांव योहोवा क पास चोहोड़ जाइस; सम्भव छे की हांव तुमरा पाप क पछतावो कोर सोको।” ");
INSERT INTO dhn_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","तोत्यार मुसा योहोवा क पास जाईन कोहने लाग्यो, “हाय, हाय, हेनु मानसो न सोना क देवता बोनाविन मोटो त पाप कोर्या छे। ");
INSERT INTO dhn_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","ते वी हेमी तु ओक पाप सोमा कोर - नी ते आपनी लिखली होयी किपात मा सी नाव काट दे।” ");
INSERT INTO dhn_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","योहोवा न मुसा सी कोयो, “ज मारे विरुद्ध पाप कोर्‌यो छे ओक नाव हांव आपनी किपात मा सी काट दिस। ");
INSERT INTO dhn_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","हेमी तु जाईन हेनु मानसो क हेना जागा मा लि चाल जेरी वात हांवन तार सी कोर्‌यो हुतो; देख, मारो दुत तारे अगल अगळ चालसे। बाखुन जेने दाहड़े हांव मिवाई तेने दाहड़े ओक एना पाप क वी डोन आपीस।” ");
INSERT INTO dhn_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","एने: योहोवा न हेनु मानसो पोर पिड़ा नाख्यो, काहकी हारुन क बोनावला होया बछड़ा क हुयेत बोनाय माँगला हुता। ");
INSERT INTO dhn_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","ओळतेन योहोवा न मुसा सी कोयो, “तु हेनु मानसो क जेनुक मिसर देश सी छुड़ाय लायो छे पुठी लिन हेना देश क लिजा, जेरे वाराम हांवन अब्राहम, इसहाक, आरु याकुब सी शपथ खाईन कोयो हुतो कि हांव ओक तारी ओवलियाद क आपीस। ");
INSERT INTO dhn_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","आरु हांव तारे ओगळ ओगळ एक दुत क मुकलीस, आरु कनानी, एमोरी, हित्ती, परिज्जी, हिब्बी आरु यबुसी मानसो क उतवाळीयो निकाळ दिस। ");
INSERT INTO dhn_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","तुमु मानसे हेना देश क जाऊ जेरेम दुध आरु मधु क धारा उहवे छे; बाखुन तुमु एक होटीया छे, एर कोरीन हांव तुमरे विच मा होईन नी चालीस, असो नी होये की हांव वाट मा तुमरो नास कोर दोम।” ");
INSERT INTO dhn_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","यी बुरी खोबोर सोमळीन हुये मानसे दु;ख कोरने लाग्या; आरु काहिय आपने गहने पेहरला हुया नी रोहे। ");
INSERT INTO dhn_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","एकालिय योहोवा न मुसा सी कोय देदो हुतो, “इसराएलीयो क मारो यो बुल सोमळ्यो, तुमु मानसे ते होटीया होये; काहमाइन हांव पल भर क लिय तुमरे वीच होईन चालो, ती तुमरो नास कोर नाखीस। एकालिय हेमी आपना आपना गोहना आपना पिलो सी उतार देवु की हांव जानो की तुमरे पुठी काय कोरनो चाहजे।” ");
INSERT INTO dhn_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","एकालिय इसराएली होरेब सिने बोयड़ा सी लिन ओगोळ क आपना गोहना उतारला रोहे। ");
INSERT INTO dhn_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","मुसा तम्बु क छावनी सी खोयड़े बाकुन नांबे उबो कोराया कोरतो हुतो, आरु ओक मिलापवाळा तम्बु कोहतो हुतो। आरु ज काई योहोवा क हेरतो हुयो हेना मिलापवाळा तमबु क पास ज छावनी क पास क छावन ई क खोयड़े हुतो, निकळ जातो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","जब जब मुसा तम्बु क पास जातो, तब तब आखा मानसे उठिन आपना आपसो डेरा क झोपला पोर उबा होय जाता, आरु जब लोगुन मुसा हेना तम्बु मा भोराये नी कोरतो हुतो ती लोगुन हेरे भिनी देखतु रोहता होता। ");
INSERT INTO dhn_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","जब मुसा हेना तम्बु मा भोराये कोरतो हुतो, तब वादळा क खाम्बा उतरीन क तम्बु क झोपला पोर उबोरह जातो हुतो, आरु योहोवा मुसा सी वात कोरने लागतो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","आरु आखा मानसे जोत्यार वादळा क खाम्बा क तम्बु क झोपला देखता हुता, तोत्यार उठिन आपना आपना डेरा क झोपला पोर सी वाद्या कोरता हुता। ");
INSERT INTO dhn_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","आरु योहोवा मुसा सी ओस कोरिन आंबा-सांबा वार कोरता हुता, जोस कोरिन कोय आपना भास्यो सी वात कोरे। आरु मुसा ते छावनी मा पोछो आत रोहतलो, बाखुन योहोसु नावोन एक जुवान, ज नुन क पुर्य आरु मुसा क सेवक हुतो, हुये तम्बु मा सी नी निकळता हुता। ");
INSERT INTO dhn_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","मुसा न योहोवा सी कोयो, “सोमोळ तु मार सि कोयलो छे, ‘एनु मानसो क लि चाल;’ बाखुन यो नी देखाड़्यो की तु मारे पुठी कुनिक मुकलिस। तेवी तुन कोयो छे, ‘तारो नाव मारे चित्त मा बोसलो छे, आरु तारे पोर मारी गिन क निगाह छे।’ ");
INSERT INTO dhn_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","आरु हेमी काहमाइन मार पोर तारी गिनोन निगाह होय, ती मेसे आपसी गति सोमझाड़ दे, जेरेसी हांव तारो गियान पावो तोत्यर तारी गिन क निगाह मार पोर बोनली रोहे। ओळतेन यो वी धियान राखो की यी मनख्या तारी पोरजा छे।” ");
INSERT INTO dhn_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","योहोवा न कोयो, “हांव आप तारे पुठी चालीस आरु तुसे आराम आपीस।” ");
INSERT INTO dhn_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","हुयो हेरेसी कोयो, “काहमाइन तु आपसु नी चाले, ती हामु याँसी ओगा मा लि जाय। ");
INSERT INTO dhn_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","यो कोसो जाने पाये की तारे गिनोन क निगाह मार पोर आरु आपनी प्रजा पोर छे? काय एरेसी नी की तु आमरे पुठी पुठी चाले, जेरेसी हांव आरु तारु प्रजा क मानस ए कळ भोरिन क सब मानसो सी ओलग कोहायजे?” ");
INSERT INTO dhn_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","योहोवा न मुसा सी कोयो, “हांव यो काम वी, जेरे वाराम तु कोर्‌यो छे क, कोरिस; काहकी मारी गिन क निगाह तार पोर छे, आरु तारो नाव मारे मन मा बोसलो छे, हांव तुखे नाव सी जानतु छे।” ");
INSERT INTO dhn_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","मुसा न कोयो, मखे उका मोहिमा क तेज देखाड़ दे। ");
INSERT INTO dhn_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","हुयो कयो, “हांव तारे ओगळ होईन चालता होईन तुसे आपनी आखी भोलाई देखाड़िस, आरु तारे ओगळ योहोवा नाव क पोरचार कोरिस; आरु जेर पोर हांव गिन कोरनो चाहो हेर पोर गिन कोरिस, आरु जेर पोर दया कोरनो चाहो तेर पोर दया कोरिस।” ");
INSERT INTO dhn_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","ओळतेन हुयो कोयो, “तु मारा मुख क दोरसोन नी कोय सोके; काहकी मानुस मारा मुख क दोरसोन कोरन जिवतलो नी रोय सोके।” ");
INSERT INTO dhn_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","अळतेन योहोवा न कोयो, “सोमोळ, मारे पास एक जागो छे, याँ तु हेर पोर चट्टान पोर उबो होय; ");
INSERT INTO dhn_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","आरु जोत्यार लोगुन मारो सेक तारे ओगळ होईन चालतो रोहे, तोत्यार लगुन हांव तुसे चट्टान क दरार मा राखुस आरु जोत्यार लोगुन हांव तारे अगळ सि होईन नी निकळी जाम तोत्यार लोगुन आपना हातो सी तुसे ढाकिन रोहजी; ");
INSERT INTO dhn_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","ओळतेन हांव आपनो हात चुट लिस, तोत्यार तु मारा वासा क ते दोरसोन पाविस; बाखुन मारो मुख क दोरसोन नी मिळसे।” ");
INSERT INTO dhn_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","ओळतेन योहोवा न मुसा सि कोयो, “पेहली तख़्तियो क जसो दोगड़ा क दुयो ओख्यो पट्टिया घोड़ लेरे; तब ज बुल हेनु पेहली तख़्तियो पोर लिख्या हुतो, जेनुक तुन तुड़ नाख्यो, हुयेत बुल मा हेनु तख़्तियो पोर वी लेखिस। ");
INSERT INTO dhn_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","सोंदारे तियार रोहजी, आरु भोर क सीनाय बोयड़ा पोर चोहड़ीन ओकी चोटी पोर मारे ओगळ उबो होयजी। ");
INSERT INTO dhn_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","तारे पुठी काई नी चोहोड़ पावे, बाखुन बोयड़ा भोर पोर कोय मानुस काहिय देखाइ नी देये; आरु नी गाडरा-बुकड़ा आरु गाय-बुईल वी बोयड़ा क ओगळ चोरने पाये।” ");
INSERT INTO dhn_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","तोत्यार मुसा न पेहली तख़्तियो क जसो दुय आरु पट्टिया घोड़्‌या; आरु वेगोत क उठिन आपना हात मा दोगड़ा क हुये दुयो पट्टिया लिन योहोवा क हुकुम क ओनसारे सीनाय बोयड़ा पोर चोहोड़ गोया। ");
INSERT INTO dhn_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","तब योहोवा न वादळा मा उतरीन ओक पुठी उबो होईन योहोवा खुदक नाव क पोरचार कोर्‌यो। ");
INSERT INTO dhn_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","यहोवा ओक अगळ होईन यो पोरचार हुयो चाल्यो, “योहोवा, ईश्वर दयालु आरु गिनोन, रीस करने मा धीरजवन्त, आरु घण करुणामय आरु खोरो, ");
INSERT INTO dhn_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","हजारो पीढ़ीयो लोगुन लोगातार दया करनेवाळा, अधोरोम आरु गुणा आरु पाप सोमा करनेवाळा छे, बाखुन दोष क हुयो काहने भातिन गुनावा नी कोहायसे; हुयो पितरो क अधोरोम क डोन ओक पुर्या बाखुन पोता आरु परपोता क वी आपनेवाळा छे।” ");
INSERT INTO dhn_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","तोत्यार मुसा न तोत्यार कळ क भैनी झुकीन वांद्यो। ");
INSERT INTO dhn_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","आरु हुयो कोयो, “हे पोरबु, काहमाइन तारी गिन क निगाह मार पोर होय, ती पोरबु हामु मानसो क विच मा होईन चाले; ये मानसे एक होटीया ते छे, ते वी आमरा अधोरोम आरु पाप क सोमा कोर आरु आपना निज वाटो मानीन ग्रहण कोर।” ");
INSERT INTO dhn_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","हुयो कोयो, “सोमळ, हांव एक वाचा बाँदो छे। तारा आखा मानसो क अगळ मा ओसा मोटा काम करिस जोसो कळी पोर आरु आखी जाती मा कोदी नी होये; आरु हुये आखा मानसे जेरे विच तु रोहे छे योहोवा क काम क देखसे; काहकी ज हांव तुमु मानसो क लिय करने पोर छे हुयो भयंकर बीकन काम छे। ");
INSERT INTO dhn_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","ज हुकुम मे आज तुमुक आपो छे ओक तुमु मानसे मानजु। देखु, हांव तुमरे ओगळ सी एमोरी, कनानी, हित्ती, परिज्जी, हिब्बी, आरु यबुसी मानसो क निकळो छे। ");
INSERT INTO dhn_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","एकालिय चोकचोया रोहनो कि जेना देश मा तु जानेवाळो छे उना निवासियो सी वाचा नी बाँदनो; काहिय ओसो नि होये की हुयो तारे लिय फंदो कोहाये। ");
INSERT INTO dhn_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","एकालिय ओकी वेदीयो क पाड़ दे नो, ओक खांभा क तुड़ नाखजो, आरु ओकी अशेरा नावोन मुर्तियो क काट नाखजो; ");
INSERT INTO dhn_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","काहकी तुमुक काहनी दिसरा क ईश्वर कोरिन वादंने कोरने क हुकुकम नी, काहकी योहोवा जेरो नाव जलनशील छे, हुयो धोपाइन उठनेवाळो परमेश्वर छे, ");
INSERT INTO dhn_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","ओसो नी होये कि देशक निवासियो सी वायदु करे। ओसो नी होय कि जव वे आपना देवता क बुंडो काम करे आरु यो वेवविचार क व्यवहार कोरे, आपना देवता क बलि चढ़ावसे आरु कोई तुखे नेवतो करे तव तु ओकान बलीन मांस खासे। ");
INSERT INTO dhn_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","आरु तु ओकी पुराय क आपना पुर्या क लिय लावे, आरु ओकी पुराय ज आप आपना देवताओ क पोछोल होयने क वेवविचार कोरे छे, तारा पुर्य सि वी आपना देवताओं क पोछोळ होयने क वेवविचार कोरावे। ");
INSERT INTO dhn_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“तुमु देवताओ क मुर्तिया घोड़ीन झुणी बोनाय लेनो। ");
INSERT INTO dhn_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“अखमीरी रुटी क पर्व मानजु। हेरेम मारी हुकुम क ओनसारे आबीब मोहना क नियत टेमे पोर सात दाहड़ा लोगुन अखमीरी रुटा खाया कोरजु; काहकी तु मिसर सी आबीब मोहना मा निकळ आया। ");
INSERT INTO dhn_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","हर एक पहिलौठा मारो छे; आरु काय बछड़ो, काय मेम्ना, तारा ढुरो मा सी ज नर पहिलोठो होये हुयो सब मारोत छे। ");
INSERT INTO dhn_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","गदड़ा क पेहला खुळ्या क बोदले मेम्नो आपिन ओक छुड़ावजो, कदाम तु ओक छुड़ावने नी चाहे ती ओक गोळो तुड़ देजी। बाखुन आपना आखा पहिलोठो पुर्या क बदलो आपिन छुड़ावनो। मेसे काई ठाहरले हाते आपनो मुय नी देखाड़े। ");
INSERT INTO dhn_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“छव दाहड़ा ते काम कोरजु, बाखुन सातवे दाहड़े आराम कोरजु; बाखुन हळ जुपने आरु काटाई क टेमे वी आराम कोरजु। ");
INSERT INTO dhn_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","आरु तु सापता क पर्व मानजु ज पेहला लवे हुया गोहोव क पर्व कोहाये छे, आरु साल क आखरी मा एकठो क वी पर्व मानजु। ");
INSERT INTO dhn_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","साल मा तिन वार तारा आखा मानसे इस्राएल क परमेश्वर पोरबु योहोवा क आपनो मुख देखाड़े। ");
INSERT INTO dhn_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","काहकी हांव दिसरी जाति क तारे अगळ सी निकाळीन तारि सिमाओ क विदाड़िस; आरु जब तु आपना परमेश्वर योहोवा क आपनो मुख देखाड़ने क लिय साल मा तिन वार आया कोरे, ती काई तारी भुमी क लालच नी कोरसे। ");
INSERT INTO dhn_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“मारा बलिदान क लुहुय क खमीर भेळ नी चोड़ावनो, आरु नी फसह क पर्व क बलिदान मासी काइन सोंदारे लोगुन रोहने देजो। ");
INSERT INTO dhn_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","आपनी भुमी क पेहली उपज क पेहलो वाटो आपना परमेश्वर योहोवा क भवन मा ली आवनो। बुकड़ा क गिदल्या क ओकी आईस क दुध मा नी पाकाड़नो।” ");
INSERT INTO dhn_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","तोत्यार योहोवा न मुसा सी कोयो, यो बुल लिख लेये; काहकी एना बुलो क ओनसारे हांव न तारे आरु इस्राएल क पुठी वाचा बादलो छे। ");
INSERT INTO dhn_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","मुसा होया योहोवा क पुठी चालिस दाहड़ा आरु रात रोयो; आरु तोत्यार लोगुन नी ते हुयो रुटा खादा आरु नी पानी पिदो। आरु हुयो हेनु तख़्तियो पोर वाचा क बुल यानी दोस हुकुम लिख देदो। ");
INSERT INTO dhn_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","जोत्यार मुसा गोवा क दुयो पाटिया हातो मा लिय सीनाय बोयड़ा सी उतर रोयो हुतो तोत्यार योहोवा क सात वात कोरने क कारण उना चेहरा सी तेज निकळी रोय होती, बाखुन हुयो यो नी जानतो हुतो की ओक चेहरा तेज निकळ रोय छे। ");
INSERT INTO dhn_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","जब हारुन आरु सब इसराएलीयो न मुसा क देख्या की उना मुख सि किरण निकळ रोय छे, ती हुये ओक पास जाने सी बिह गोया। ");
INSERT INTO dhn_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","तोत्यार मुसा न ओक बुलायो; आरु हारुन मण्डळी क आखा डाहला भेळ उना पास आया, आरु मुसा हेनुसी वात कोरने लाग्या। ");
INSERT INTO dhn_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","ओक वाद आखी इसराएली पास आया, आरु जोतरा हुकुम योहोवा न सीनाय बोयड़ा पोर उना सात वात कोरने क टेम आप्यो हुतो, हुयो सब हुयो ओक बताड्यो। ");
INSERT INTO dhn_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","जोत्यार लोगुन मुसा हेनुसी वात नी कोर चुक्या तोत्यार लोगुन मुसा हेनुसी वात नी कोर चुक्यो तोत्यार लोगु आपसा मुख पोर फोटको पाँगरीन रोयो; ");
INSERT INTO dhn_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","बाखुन जोत्यार जोत्यार मुसा धोड़े योहोवा सी वात कोरने क ओक ओगळ जाय, तोत्यार तोत्यार हुयो हेनु पांगरुन क निकळते टेमे लोगुन उतारे हुये रोहतो हुतो; ओळतेन खोयड़े आविन ज ज हुकुम ओक मिळे हेनुक इसराएलीयो सी कोय देतो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","इसराएली मुसा क मुख देखतो हुतो की हेरेसी किरणे निकळे छे; आरु जोत्यार लोगुन हुयो योहोवा सी वात कोरने क धोड़े नी जाता तोत्यार लोगुन त्यो फोटको पाँगरीन रोहता हुतो। ");
INSERT INTO dhn_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","मुसा न इसराएल क आखा लोगहन क एकठा कोरीन उनासी कयो, “जेना काम को कोरनेन हुकुम योहोवा आपलो छे त्या ये छे। ");
INSERT INTO dhn_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","छव दाहड़ा ते काम कोरजो, पुन सातवो दाहड़ो तुमरे लिय आरु चुखलो आरु योहोवा क लिय खास आरामन दाहड़ो कोहायसे, उनामा जो काय काम कोरसे त्यो मार नाख्यो जासे; ");
INSERT INTO dhn_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","पुन आरामन दाहड़े तुमु आपसा घरोम चुलो भी मा धपाड़ता।” ");
INSERT INTO dhn_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","ओळते मुसा इसराएलीयान सारी मण्डळी सी कयो, “जिनी वातन हुकुम योहोवा भगवान आपलो छे‍ त्या यी छे। ");
INSERT INTO dhn_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","तुमरे जुळ रयीन योहोवा भगवान क लियन भेट लेय, मतलब जतरा बी आपसी राजी मरजी सी आपनो चाहे त्या योहोवा भगवानन भेट करीन यी चीज ली आवे; मतलब सोनो, रुप्‌या, पीतळ; ");
INSERT INTO dhn_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","नीळ्ळा, जामनीया रंगन आरु रातला रंगन छिंदरा, सुवाळा छिंदरा, बकड़ान झटा, ");
INSERT INTO dhn_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","रातला रंगो सी रंगायली गाडरान खालड़ा, आरु सुईसो नावोन मोटला माछान खालड़ा; बाबळीयान लाकड़ा, ");
INSERT INTO dhn_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","विजाळो आपने करीन तेल, पवित्र कोरलो तेल, आरु धूद देने करीन वारु गंधायने वाळी चीज, ");
INSERT INTO dhn_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ओळी एपोद आरु छाती पोर बांदनीया क लियन सुलेमानी मणिया आरु लगाड़नेन मणि। ");
INSERT INTO dhn_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“तुमरे मा सी जतरान जीवड़ा मा ओकलन विजाळो छे त्या सब आवीन जिनी-जिनी चीजन हुकुम योहोवा भगवान आपलो छे त्या सब बनावे। ");
INSERT INTO dhn_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","मतलब तम्बु, आरु वोरसादी को सात मा निवास, आरु ओकी हेकड़ा, चोखट, डांडा, खाम्बा, आरु कुड़ची; ");
INSERT INTO dhn_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","ओळी डांडान को सात मा सन्दुक, आरु पछतावान ढाकनो, आरु वीचवाळा परदा; ");
INSERT INTO dhn_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","डांडा आरु सब समान को सात टेबल, आरु भेटन रोटा; ");
INSERT INTO dhn_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","समान आरु दीवान क सात मा विजाळो आपने वाळा खुटो, आरु विजाळो आपने करीन तेल; ");
INSERT INTO dhn_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","डांडान क सात मा धूप देनेन वेदी, चुखलो तेल, वारु गंधायने वाळो धूप, आरु निवासन झोपलान परदो; ");
INSERT INTO dhn_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","पीतळन जाली, डांडा हसलोत् आरु आखो समान होमबली, पायान सात मा मोटलो तोपलो; ");
INSERT INTO dhn_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","खाम्बा आरु हेनकी कुड़चीन क सात मा आँगनान परदा, आरु झोपलान परदा; ");
INSERT INTO dhn_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","निवास आरु आँगनान दुयु खुटा, आरु दुयड़ा; ");
INSERT INTO dhn_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","चुखला जागा मा सेवा चाकरी करने करीन होभावळा छिंदरा, आरु पुजारान काम करने करीन हारुन पुजारान चुखला छिंदरा, आरु उना पोर्यान छिंदरा बी।” ");
INSERT INTO dhn_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","तव इसराएलीयान आखा लोगहन मुसान सामने सी जाती रया। ");
INSERT INTO dhn_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","आरु जतरा जनान जुर वदियो, आरु जतरा जनान मन मा असी मरजी पड़ी कि, त्या मिलापवाळा तम्बुन काम करने करीन आरु ओकी सारी सेवा चाकरी आरु चुखझला छिंदरा बनावने करीन योहोवा भगवानन भेट लावने लागिया। ");
INSERT INTO dhn_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","काय बायरा ने आरु काय ओदेमड़ा, जतरा जनान मन मा असी मरजी पड़ी कि त्या सब गळान हार, नाक मा पेहरने वाळा सोनान कुचा, मुंदिया आरु हसी घण सवटी चीज सोनान गयनो लावने लागीया, इनीये रीतिये जतरा मनुस योहोवा भगवान क लियने ओसनान भेट आपनेवाळा हुता त्या सब हेनको ली आया। ");
INSERT INTO dhn_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","आरु जिना-जिना ओदेमड़ान क पास नीळ्ळा, रींगनीया रंगन या रातला रंगन छिंदरा या सुवाळा छिंदरा, या बकड़ान झटा, या रातला रंग सी रंगायली गाडरीन खाल, या सुईसो नावन मोटला माछान खालड़ा हुता, त्या हेनको ली आया। ");
INSERT INTO dhn_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","ओळते जतरा चाँदी, या पीतळन भेट आपने वाळा हुता त्या योहोवा भगवान वाटे भेट ली आया; आरु जिना-जिनान पास मा सेवा चाकरीन काहला बी काम लियन बाबळीयान लाकड़ा हुता त्या उको ली आया। ");
INSERT INTO dhn_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","आरु जतरी बायरन जीवड़ा मा ओकलन आरु कला हती त्या आपसा हातो सी सुत बोनावीन नीळ्ळा, जामनीया रंगन आरु रातला रंगन, आरु सुवाळा सनीन कातेरला सुत को ली आवी। ");
INSERT INTO dhn_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","आरु जतरी बायरन मन मा असी ओकलन विजाळो हुतो त्या बकड़ान झटा बी घुथला। ");
INSERT INTO dhn_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","आरु मुखी लोगहन एपोद आरु छातीये बांदने लियन सुलेमानी मणि, आरु जड़नेन मणि, ");
INSERT INTO dhn_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","आरु विजाळो आपने आरु चुखो कोरलो तेल आरु धूपन वारु गंधायने वाळी चीज आरु तेल ली आया। ");
INSERT INTO dhn_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","जिनी-जिनी चीजन बनावने हुकुम योहोवा भगवान मुसान लारे आपलो हुतो, हेनका लियन जो काय जरुरी हुतो, उको त्या ओदेमड़ा आरु बायरा मेळीन ली आया, जतरा जना मन मा असी मरजी हयली हुती। इनीये रीतिये इसराएली योहोवा भगवान क लिये आपसी मरजी सी भेट ली आया। ");
INSERT INTO dhn_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","तव मुसा इसराएलिया सी कयो समळो, “योहोवा यहुदान घराना वाळा बसलेल को, जो ऊरीन पोर्‌यो आरु हुरन पोतो छे, नाव लीन बुलायो। ");
INSERT INTO dhn_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","आरु त्यो उको योहोवा भगवानन आत्मा सी असो भराय गीयो कि सब भातीन चीज बनावनेन असी ओकलो जड़ली छे, ");
INSERT INTO dhn_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","कि त्यो कारीगारी करने ओकल लगाड़ीन सोना, चाँदीन, आरु पीतळोन ठाहरा बोनावे, ");
INSERT INTO dhn_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","आरु लगाड़ने करीन मणि काटने मा आरु लाकड़ा पर चितरो बनावने मा, या तक की आखी भातीन निकाळी बनावने मा काम कोरे। ");
INSERT INTO dhn_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","ओळते योहोवा भगवान उना मन मा आरु दानन घराना वाळा अहीसामाकन पोर्या ओहोलीआबन मन मा सिकापन आपनेन ताकत आपीयो। ");
INSERT INTO dhn_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","इनु दुयन को मन को योहोवा भगवान ओसी बुध्दि क असी ओकल सी भरीयो, कि त्या आकने मा आरु ढाळने मा आरु नीळ्ळा आरु रातला रंगन छिंदरा, आरु सुवाळा छिंदरा काढ़ने आरु विन्दने मा, सब भातीन बनावने मा, आरु ओकल सी काम निकाळने मा सब भातीन काम करे। ");
INSERT INTO dhn_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“बसलेल आरु ओहोलीआब आरु सब ओकल वाळ जिनको योहोवा भगवान असी ओकल आरु सोमोज आपलो हय, कि त्या योहोवा भगवानन सारा हुकुम को लारे चुखला जागान सेवा चाकरी क लियन आखा भातीन काम करनो जाने, त्यो सब यो काम करे।” ");
INSERT INTO dhn_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","तव मुसा बसलेल आरु ओहोलीआब आरु सब ओकल वाळान को जिनको जीव मा योहोवा भगवान ओकलन विजाळो आपलो हुतो, मतलब जिना-जिनान पास मा आवीन काम करनेन जुर हुतो हेनु सबन को बुलायो। ");
INSERT INTO dhn_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","आरु इसराएली जो-जो भेट चुखला जागान सेवान काम आरु उको बनावने करीन लीयावला हुता, उको त्या मनुस मुसान हात सी ली लेदा। तव बी लोगहन भोळभाकाम उना पास भेट आपसी राजी मरजी सी लावता रीया। ");
INSERT INTO dhn_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","आरु जतरा ओकल वाळा चुखला जागान काम करता हुता त्या सब आपसा-आपसा काम छुड़ीन मुसान पास मा आया, ");
INSERT INTO dhn_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","आरु मुसा लागीया, “जिना काम को करनेन योहोवा भगवान हुकुम आपलो छे उना लिये जतरा जुळतो हुतो उना सी जादा त्या ली आया।” ");
INSERT INTO dhn_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","तव मुसा सारी तम्बु मा इना हुकुमन परचार करायो, “काय ओदेमड़ा, काय बायरा, कोय बी चुखला जागा लिये भेट नी लावनो।” इनीये रीति सी लोगहन आरु भेट लावने सी रुकाय गीया। ");
INSERT INTO dhn_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","काहकी सब काम क लियन जतरो सामान जुळतो हुतो हतरत् पुन उना सी जादा बनावने वाळान पास मा आय गयलो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","आरु काम करनेवाळा जतरा ओकल वाळा हुता त्या निवास लियन वाटायला सुवाळा छिंदरान, आरु निव्वा आरु रातला रोंगोन छिंदरान दोस पोरदा काजे गुथला कोरुब भेव बोनाया। ");
INSERT INTO dhn_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","एक-एक परदान नाम्बाय अठावीस हातन आरु चवड़ाई च्यार हातन हय; सब परदन एकुत् माप बनीयो। ");
INSERT INTO dhn_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","त्यो पाच परदा एक दिसरा सी जुड़ दीदो, आरु ओळी पाच परदा बि एक दिसरा सी जुड़ दीदा। ");
INSERT INTO dhn_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","आरु जा सारी या जुड़ायला परदा वा सारी दुय छिवनीया पर त्यो नीळ्ळा-नीळ्ळा फांदीया लाड़ीयो। ");
INSERT INTO dhn_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","आरु त्यो दुयो मेर मा पचास पचास फान्दा लगाड़ीया की त्या एक दिसरा अगळ हुता। ");
INSERT INTO dhn_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","आरु त्यो सोनान पचास आकड़ा बनायो, आरु हेनका लारे एक दिसरा सी जुड़ीयो कि निवास मेळीन एक हुय ईयो। ");
INSERT INTO dhn_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","ओळी निवासन उपरक तंबु पर ढ़ाकने क करता त्यो बकड़ान छटान गियारा परदा बनायो ");
INSERT INTO dhn_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","एक-एक परदान नाम्बाय तीस हातन आरु चवड़ाय च्यार हातन हुयी; आरु गियारा ");
INSERT INTO dhn_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","एनामा सी त्यो पाच पोरदा ओलोग आरु छव पोरदा ओलोग जुड़ दिदो। ");
INSERT INTO dhn_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","आरु जा सारी दुयु जुड़ाय गिया वा खुनान छिवनीया मा त्यो पचास पचास फान्दीया लगाड़ीयो। ");
INSERT INTO dhn_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","आरु त्यो तम्बु को जुड़ने करीन पीतळन पचास आकड़ा बी बनायो जिना सी त्यो एक हुय जाय। ");
INSERT INTO dhn_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","आरु त्यो तम्बु क लिये रातला रमग सी रंगायली गाडरान खालन एक पांगरुन आरु उना ऊपर लियन सीइसन खालन एक पांगरुन बी बनायो। ");
INSERT INTO dhn_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","ओळी त्यो निवास क लियन बाबळीयान लाकड़ान पाटिया को उब राखने करीन बनायो। ");
INSERT INTO dhn_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","एक-एक पाटियान नाम्बाय दस हात आरु चवड़ाय डेढ हातन हुयी। ");
INSERT INTO dhn_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","एक-एक पाटिया मा एक दिसरा सी जुड़ायली दुय-दुय चुले बनली, निवासन सब पाटियान को असोत् बनायो। ");
INSERT INTO dhn_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","त्यो रोहनेन जागा क लिय पाटियान को असोत् बनायो कि दोखेवरे तरफ वीस पाटिया लागीया। ");
INSERT INTO dhn_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","आरु इनु वीस पाटियान नेचा चाँदीन चाळीस कड़ची, मतलब एक-एक पाटियान नेचो दुय चुला क लियन दुय कड़ची बनायो। ");
INSERT INTO dhn_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","आरु निवासन दिसरे तरफ, मतलब उगेवनो तरप लगाड़ने करीन त्यो वीस पाटिया बनायो। ");
INSERT INTO dhn_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","आरु हेनको लिये बी त्यो चाँदी चाळीस कुड़ची, मतलब एक-एक पाटियान नेचो दुय-दुय कुड़ची बनायो। ");
INSERT INTO dhn_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","आरु निवासन पछली तरफ, मतलब जेवड़ीये तरफ क लियन त्यो छव पाटिया बनायो; ");
INSERT INTO dhn_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","आरु पछला भागन कुना क लियन त्यो दुय पाटिया बनायो। ");
INSERT INTO dhn_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","त्यो नेचो रईन दुय- दुय भागन बनायो, आरु दुयु भाग मा निवासन कुना क लियन त्यो दुय पाटिया बनायो। ");
INSERT INTO dhn_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","इना रीति सी आठ पाटिया हुया, आरु हेनकी चाँदीन सुवळा कुड़ची हुय; मतलब एक-एक पाटियान नेचो दुय-दुय कुड़ची हुयी। ");
INSERT INTO dhn_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","ओळी त्यो बाबळीयान लाकड़ान डांडा बनायो, मतलब निवासन एक धोड़ेन पाटिया लियन पाच डांडा, ");
INSERT INTO dhn_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","आरु निवासन दिसरी तरफन पाटियान; जुगु पाच डांडा, आरु निवासन जो कुनु जेवड़ीयो आरु जो पछळ जागाम हुतो उना लियन बी पाच डांडा बनायो। ");
INSERT INTO dhn_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","आरु त्यो वीच मा वाळा डांडान पाटियान वीच मा तम्बुन एक छिवणिया सी दिसरे छिवणिये तक पुगने करीन बनायो। ");
INSERT INTO dhn_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","आरु पाटियान को त्यो सोना सी घड़ीयो आरु डांडान घर मा काम आवने वाळा कड़ाक को सोनान बनायो, आरु डांडा को बी बनायो। ");
INSERT INTO dhn_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","ओळी त्यो नीळ्ळा, जामनीया आरु रातला रंगन छिदरान आरु सुवाळा सनीवाळा छिंदरान वीचमा वाळा परदा बनायो; त्यो विंदनेन काम करनीया करुबन चितरोन सात मा बनीयो। ");
INSERT INTO dhn_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","त्यो उना लियन बाबळीयान च्यार खाम्बा बनायो, आरु हेनको सोना सी ढाळीयो; हेनका माकड़ा वी सोनान बनी, आरु त्यो हेनका लियन चाँदीन च्यार कड़चीया ढाळीयो। ");
INSERT INTO dhn_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","त्यो तंबुन झोपला क लियन बी नीळ्ळा, जामनीया आरु रातला रंगन छिंदरान, आरु वाटायला सुवाळा छिंदरा विंदिन काम करलो परदो बनायो; ");
INSERT INTO dhn_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","आरु त्यो माकड़ा क सात मा उना पाच खाम्बा बी बनायो, आरु हेनका मुनका पर जुड़ने वाळी छड़ीयान को सोना सी ढाळीयो, आरु हेनकी पाच कुड़ची पीतळन बनायो। ");
INSERT INTO dhn_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","ओळतेन बसलेल ने बाबळीयान लाकड़ान पेटारो बनायो; ओकी नाम्बाय ढाय हात, चवड़ाय डेढ हात आरु ऊचाय डेढ़ हातन हुती। ");
INSERT INTO dhn_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","त्यो उको माहय बाहर चुखला सोना सी ढाळीयो; आरु उना च्यारो मेर सोनान वाड़ बनायो। ");
INSERT INTO dhn_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","आरु ओका च्यारो मेर पाया पर लगाड़ने करीन त्यो सोनान च्यार कड़ा ढाळीया, दुय कड़ा एक तरफ दुय कड़ा दिसरे तरफ लागीया। ");
INSERT INTO dhn_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","ओळते त्यो बाबळीयान डांडा बनाया, आरु सोना सी ढाळीयो। ");
INSERT INTO dhn_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","आरु हेनको सन्दुकन दुयु तरफन कड़ा मा लगाड़ीयो कि हेनका साहरे हाकलाय जाय। ");
INSERT INTO dhn_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","ओळी‍ त्यो चुखला सोनान पछतावा ढाकना को बनायो; ओकी नाम्बाय ढाय हात आरु चवड़ाय डेढ़ हातन हुती। ");
INSERT INTO dhn_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","आरु त्यो सोनान दुय करुब घड़ावीन पछतावान ढाकनान दुयु छिवनीया पर बनायो। ");
INSERT INTO dhn_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","एक करुब ते एक छिवनीया पर, आरु दिसरो करुब दिसरा छिवनीया पर बनीयो; हेनको त्यो पछतावान ढाकना कपो सात मा एकुत् टुकड़ान दुयु छिवनीया पर बनायो। ");
INSERT INTO dhn_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","आरु करुबोन पाखड़ा ऊपर सी खरवायला सारका बनीया, आरु उना पाखाड़ा सी पछतावान ढाकनो ढाकायलो बनीया, आरु हेनका मुय आम्बा-साम्बा आरु पछतावान ढाकनान तरफ करला बनीया। ");
INSERT INTO dhn_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","ओळी त्यो बाबळीयान लाकड़ान मेज को बनायो; ओकी नाम्बाय दुय हात, आरु चवड़ाय एक हातन आरु ऊचाय डेढ हातन हुती। ");
INSERT INTO dhn_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","आरु त्यो उको चुखा सोना सी ढाळीयो, आरु उना मा च्यारो मेर चुखला सोनान एक वाड़ बनायो। ");
INSERT INTO dhn_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","आरु त्यो उना लये च्यार आंगवी चवड़ी एक पटड़ी, आरु इनी पटड़ी लियन च्यारो मेर सोनान एक वाड़ बनायो। ");
INSERT INTO dhn_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","आरु त्यो मेज क लियन सोनान चार हेकड़ीया ढाळीन यना च्यारो कोना मा लगाड़ीयो जो उना पाया पर हुता। ");
INSERT INTO dhn_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","‍त्या कड़ा पटड़ीन पास मा हाकलनेन डांडान खाचान कामे आवने करीन बनायो। ");
INSERT INTO dhn_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","आरु त्यो मेज हाकलने करीन डांडान क बाबळ्यान लाकड़ान बनायो आरु सोना सी घड़ीयो। ");
INSERT INTO dhn_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","आरु‍ त्यो मेज परुन सामान मतलब परात, धूपदान, कटोरा, आरु रेड़नेन ठाहरा सब चुखला सोनान बनायो। ");
INSERT INTO dhn_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","ओळी चुखला सोनान ढाळाड़ीन पाया आरु डांडीन सात मा दीवलीया को बनाया; हेका फुलोन ढीग, गाँठड़ा, आरु फुल आखा एकोत् टुकड़ान बनीया। ");
INSERT INTO dhn_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","आरु दीवलीया सी निकळ्ळी छव डाळीया बनी; तीन डाळीया ते ओकी एक धोड़े सी आरु तीन डाळीया ओकी दिसरा धोड़े सी निकळ्ळी बनी। ");
INSERT INTO dhn_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","आरु एक-एक डाळी मा बादामन फुलो सारको तीन तीन फुलोन ढीग, एक-एक गाठड़ा, आरु एक-एक फुल बनीयो; दीवलीया सी निकळ्ळा उना छव डाळीयान योत् रुप हुयो। ");
INSERT INTO dhn_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","आरु दीवलीयान डांडा मा बादमन फुलन सारको आपसी-आपसी गाठ आरु फुलोन पीठी च्यार फुलोन ढीग बनीया। ");
INSERT INTO dhn_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","आरु दिवा सी निकळी छव डाळ मा सी दुय दुय डाळीयान क नेचो एक एक दिवा क पुठी एकुत् टुकड़ान बनी। ");
INSERT INTO dhn_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","गाठड़ा आरु डाळ्या आखा दिवा क पुठी एकुत् टुकड़ान बनीयो; आखा दिवा घोड़ला चुखला सोनान आरु एकुत् टुकड़ान बोनीयो। ");
INSERT INTO dhn_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","आरु त्यो दीवलीयान सातु दीवा, आरु चिमटो, आरु थाळी, चुखा सोनान बनाया। ");
INSERT INTO dhn_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","त्यो सारा सामान क सात मा दीवलीयान चवतीस किला एक आंदास भरीन चुखला सोनान बनायो। ");
INSERT INTO dhn_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","ओळी त्यो बाबळीयान लाकड़ान धूप वेदी बी बनायो; ओकी नाम्बाय आरु चवड़ाय एक एक हात हुती। आरु त्यो चार कुन्यो बनीयो, आरु ओकी उचाय हुय हातन आरु उका सिंगड़ा एकुत् टुकड़ान बोनला हुता। ");
INSERT INTO dhn_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","उपरवाळो पटियो, आरु च्यारो भेनीन कुना आरु सीगड़ान भेळ त्यो उनी वेदी को चुखा सोना सी ढाळीयो; आरु उका च्यारु मेर एक वाड़ बनायो, ");
INSERT INTO dhn_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","आरु उना बाड़न नेचा उना दुय पल्‌ला पर त्यो सोनान दुय कड़ा बनायो, जो ओको हाकलने को डांडान खाचान काम देय। ");
INSERT INTO dhn_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","आरु डांडान त्यो बाबळीयान लाकड़ान बनायो, आरु सोना सी ढाळीयो। ");
INSERT INTO dhn_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","आरु त्यो चुखो करलो तेल, आरु वारु गंधायने वाळो चीज धूप गंदायनेन रीतिन अनसारे बोनाया। ");
INSERT INTO dhn_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","ओळते त्यो बाबळीयान लाकड़ान होमबली करने करीन वेदी बी बनायो; ओकी नाम्बाय पाच हात आरु चवड़ाय पाच हातन हुती; इनीये रीतिये सी त्यो च्यार खुनाय बनी, आरु ऊचाय तीन हातन हुती। ");
INSERT INTO dhn_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","आरु त्यो उना च्यारो कुना पर उना च्यार सींगड़ा बनाया, आरु‍ त्या उना पुठी मा वीगुर जुड़न बनीया; आरु त्यो उको पीतळ सी ढाळाया। ");
INSERT INTO dhn_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","आरु त्यो वेदीम सारो समान, मतलब ओकी टाहरा, पावड़िया, कटवरा, चिमटा, आरु सुपड़ी को बनाया। ओको सारो सोमान त्यो पीतळन बनायो। ");
INSERT INTO dhn_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","आरु वेदीन लिये उना च्यारो मेरन झारा तळे त्यो पीतळन जाळीन एक झांझरी बनायो, त्यो नेचो रयीन वेदीन ऊचायन वीच तक पुगी। ");
INSERT INTO dhn_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","आरु त्यो पीतळन झांझरीन च्यारु कुना क लियन च्यार कड़ीया ढाळीया, जो डांडान खाचान काम देय। ");
INSERT INTO dhn_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","ओळतेन त्यो बाबळीयान लाकड़ान डांडा बनायो आरु पीतळ सी ढाळीयो। ");
INSERT INTO dhn_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","तव त्यो डांडान वेदीन तरफ कड़ीया मा वेदी को हाकलने करीन न्हाक दीदा। वेदीन धोड़े त्यो पाटिया सी पुल्ली बनायो। ");
INSERT INTO dhn_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","त्यो मोटलो तोपलो आरु उका पाया दुयु पीतळन बनायो, यो मिलापवाळा तम्बुन झोपला पर चाकरी करनेवाळी बायरान पीतळ सी आरसा बोनायो। ");
INSERT INTO dhn_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","ओळतेन आंगनो बनायो; आरु दोखेवरे क लियन आंगनान परदा वाटयली सुतोन सुळावा सनीन छिंदरा हुता, आरु आखो मिळीन सोव हात नांबा हुता; ");
INSERT INTO dhn_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","हेनको लिये वीस खम्बा, आरु ओकी पीतळन कुड़ची बनी; आरु खाम्बान हेकड़िया आरु जुड़ने वाळी लाकुड़ चाँदीन बनी। ");
INSERT INTO dhn_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","आरु दोकेवरे तरफ सी सोव हात नाम्बा परदा बनीया; आरु हेनका लियेन वीस खाम्बा, आरु हेनका पितळन विस कुड़चिया बोनी, आरु खाम्बो क हेकड़ीया आरु जुड़ने क लिय लाकड़िया चाँदीन बोनी। ");
INSERT INTO dhn_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","आरु बुडेनो क भिनी क लिय आखा पोरदा मेळीन पचार हातन हुता; उना क लिय दोस खाम्बा, आरु दोसुत हेन्दरी कुड़चिया होती, आरु खाम्बा क हेकड़ियाँ आरु जुड़ने क लाकड़िया चाँदी क हुती। ");
INSERT INTO dhn_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","आरु उगेवने भिनी वी होयी पोचास हात क हुता। ");
INSERT INTO dhn_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","आँगना क झोपला क एक धोड़े क लिय पोंद्रे हात क पोरदा बोन्या; आरु उना लिय तीन खाम्बा आरु तीन कुड़ची होती। ");
INSERT INTO dhn_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","आरु आँगना क झोपला क दिसरे ओख्ये वी तोसोन बोनलो हुतो; आरु आँगना क झोपला क आड़े आरु धोड़े पोंद्रे-पोंद्रे हात क पोर्दा बोनला होता; आरु उना लिय तीनुत तीन खाम्बा, आरु तीनुत तीन हेनकी कुड़चिया वी होती। ");
INSERT INTO dhn_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","आँगना क च्यारु ओखे आखा पोर्दा सुळावा वाटायला सनी क लुगड़ा क बोनलो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","आरु खाम्बा क कुड़चिया पितळ क, आरु हेकड़ीया आरु लाकड़िया चाँदिन बोनली, आरु उना मुनका चाँदी सी मढ़े गोया, आरु आँगना क आखा खाम्बा चाँदी क लाकड़िया सी जुड़ाय गोया हतो। ");
INSERT INTO dhn_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","आँगना क झोपला क पोर्दा पोर बेल बुटेन काम कोरलो हुतो, आरु हुयो निळ्ळा, जामनिया आरु रातला रोंगोन क छिंदरा क; आरु सुवाळा सनी क छिंदरान बोनलो हुतो; आरु ओकी नांबाय बिस हातन होती, आरु ओकी उचाई आँगना क कनात क चोड़ाई क सामान पाच हात क बोन्यो। ");
INSERT INTO dhn_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","आरु उना लिय चार खाम्बा, आरु खाम्बान चारुत कुड़चिया पितळ क बोनी, ओकी हेकड़ीया चाँदी क बोनी, आरु उना मुनका चाँदी सी घड़ीया, आरु उना लाकड़िया चाँदी क बोनी। ");
INSERT INTO dhn_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","आरु रोहने आरु आँगनान च्यारु ओखे आखा खुटा पितळन बोनलो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","गोवान चिट्ठी रोहनेन सोमान जो लेवियोन चाखरीन काम लिय बोनलो; आरु जेनकी गिनती हारुन याजक क पुर्या ईतामारन लारे मुसा क कोहने सी होयली होती, ओको पुरावो यो छे। ");
INSERT INTO dhn_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","जेनी-जेनी चिजो क बोनावने क हुकुम योहोवान मुसा आप्यो हुतो ओको यहुदान गोत्रवाळा बसलेल, ज हुरन पोतो आरु ऊरीन पोरीयो होतु, बोनाय देदो। ");
INSERT INTO dhn_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","आरु उना पुठी दान गोत्रवाळा, अहीसामाकन पुर्या, ओहोलीआब हुतो, जु नक्काशी कोरने आरु काढ़नेवाळा आरु निळ्ळा, बैंगनी, आरु रातला रोंगोन क आरु सुळावा सनीन छिंदरा मा कढ़ाई कोरनेवाळा हुसीयार कारीगर हुतो। ");
INSERT INTO dhn_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","चुखला जागान आखा काम मा जो भेटन सोनो लाग्यो चो चुखला जागा क शेकेलन हिसाब सी उनतीस किक्कार, आरु सात सोव तीस शेकेल हुतो। ");
INSERT INTO dhn_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","आरु मण्डळी क गिनयला मानसो क भेंट क चाँदी चुखला जागा क शेकेल क अनसारे सी लगभग तीन हजार पांच सोव बीस किला हता। ");
INSERT INTO dhn_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","जतरा विस साल क आरु हेरेसे जादा उमोर क गिनायला होता, चे छोव लाख तिन होजार साढ़े पाच सोव मानसे हुता, आरु एक-एक जन क भिनी सी चुखलाजागा क शेकेल क ओनसारे आदो शेकेल, ज एक बेका होये छे, मिड्ळ्यो। ");
INSERT INTO dhn_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","आरु हुयो सोव किक्कार चाँदी चुखला जागा आरु विचवाळा पोरदा दुयु क कुड़ची क ढाळने मा लाग गोय; सोव किक्कार सी सोव कुड़चिया बोनी, एक-एक कुड़ची एक किक्कार क बोनी। ");
INSERT INTO dhn_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","आरु सोतरे सोव पचहत्तर शेकेल जे वाच गोयो हेरेम खाम्बा क चोटियो मढ़ी गोय, आरु ओकी लाकड़िया वी बोनाय गोयी। ");
INSERT INTO dhn_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","आरु भेंट क पितळ सत्तर किक्कार आरु दुय होजार चार सोव शेकेल हुता; ");
INSERT INTO dhn_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","एरेसे मिलापवाऴा तम्बु क झोपला क कुड़चिया, आरु पितळन वेदी, पितळ क झंझरी, आरु वेदी क आखो सोमान; ");
INSERT INTO dhn_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","आरु आँगना क च्यारु ओखे क कुड़चिया, आरु उना झोपलान कुड़ची, आरु निवास, आरु आँगनान च्यारु मेर क खुटा वी बोनाया गोया। ");
INSERT INTO dhn_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","ओळते त्या नीळ्ळा, जामनीया आरु रातला रंगन ढळायला छिंदरा चुखला वेदी क चाकरी करनिया याजक क करता, हारुन क लियन बी चुखला छिंदरा बनावजो जिने रीतिये योहोवा भगवान मुसा को हुकुम आपलो। ");
INSERT INTO dhn_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","आरु‍ त्यो एपोदन सोना, आरु नीळ्ळा, जामनीया आरु रातला रंगन छिंदरान, आरु सुळ्ळा छिंदरा बनायो। ");
INSERT INTO dhn_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","आरु त्या सोना को कुटि-कुटीन उको पत्तर बनायो, ओळी पतरा को काट काटीन तार बोनाया आरु वारला हुसीयार कारीगर तार को नीळ्ळा, जामनीया आरु रातला रंगन छिंदरा मा, आरु सुळ्ळा छिंदरा मा विंदीन बोनावीन सी भेसकी दिदा। ");
INSERT INTO dhn_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","एपोदन जोड़ना को त्या उका कांधा पर बन्धन बनाया, त्यो आपसे दुयु मुनका जुड़ीया। ");
INSERT INTO dhn_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","आरु त्यो कसने क लियन जो ढाळायलो पट्टो उना बनाव, त्यो उका सात मा विन जुड़ को, आरु वसोत् बनावटन अनसारे, मतलब सोनान आरु नीळ्ळा, जामनीया आरु रातला रंगन छिंदरान सुळ्ळा सनन छिंदरा बनाव; जिने रीतिये सी योहोवा भगवान मुसा को हुकुम आपलो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","त्या सुलेमानी मणि काटीन उका मा इसराएलन बारे पोर्यान को नाव, जसो छापीयो, खुन्दाये तसोत् खुन्दे, आरु सोनान खाचा मा जुड़ दीदा। ");
INSERT INTO dhn_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","त्यो हेनको एपोदन कांधान बन्धन पर लगाड़ीया, जिना सी इसराएलीयान क फोम करने वाळा मणि बने; जिने रीतिये योहोवा भगवान मुसा को हुकुम आपलो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","त्यो राखवाळीन ढाळ एपोदन समान सोनान, आरु नीळ्ळा, जामनीया आरु रातला रंगन छिंदरान, आरु सुळवा छिंदरा मा घाटाळो काम करलो बनायो। ");
INSERT INTO dhn_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","राखवाळीन ढाळ ते चोकार बनीयो; आरु त्या हेनको दोहरा बनाया, आरु त्यो दुनवायीन एक वेहेत नाम्बो आरु एक वेहेत चवड़ा बनाव। ");
INSERT INTO dhn_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","आरु त्या उका मा च्यार हालोर मा मणि जुड़ीया। पेहली हालोर मा माणिक्य, पद्मराग, आरु लालड़ी लगाड़ीयो; ");
INSERT INTO dhn_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","आरु दिसरी हालोर मा मरकत, नीलमणि, आरु हीरा, ");
INSERT INTO dhn_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","आरु तीसरी हालोर मा लशम, सुर्यकान्त, आरु नीलम; ");
INSERT INTO dhn_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","आरु चवती हालोर मा फीरोजा, सुलेमानी मणि, आरु यशब लगाड़ीयो या सब अलग-अलग छातीन खाचा मा लगाड़ीयो। ");
INSERT INTO dhn_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","आरु या मणि इसराएलन पोर्यान नावन गिनतीन अनसारे बारे हुता; बारे गोत्र मा सी एक-एकन नाव जसो छापो खुन्दाये वसोत् खुन्दीयो। ");
INSERT INTO dhn_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","आरु त्या चुखला सोनान दुय खाचा आरु सोनान दुय हेकड़ीया बोनावीन दुय हेकड़ीयाक राखवाळीन ढाळ दुय छिवनिये लगाड़ीयो। ");
INSERT INTO dhn_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","ओळते ओळी त्या सोनान दुय काना, आरु सोनान दुय कड़ीया बनावीन दुयु कड़ीयान राखवाळीन ढाळ दुयु मुनका पर लगाड़ीयो; ");
INSERT INTO dhn_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","तव त्या सोनान दुय गुथायली जाळीयान को राखवाळीन ढाळ सिरा परदुयु हेकड़ीया मा लगाड़ीयो। ");
INSERT INTO dhn_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","आरु गुथायली दुयु जाळीया बाकी रयला दुयु छिवनीया को त्या दुयु वाचला छिवनियेन त्या दुयु खाचा मा लगाड़ीन एपोदन अगळ दुयु कांधान बोंदो पोर लगाड़ीयो। ");
INSERT INTO dhn_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","आरु त्या सोनान आरु दुय कड़ीया बनावीन राखवाळीन ढाळ दुय छिवनीया पर ओकी उना कोर पर, जो एपोदन माहलो जागाम मा हुती लगाड़ीया। ");
INSERT INTO dhn_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","आरु त्या सोनान दुय आरु कड़ीया बी बनावी एपोदन दुय कांधान बोंदो पर नेचा सी उना सामने आरु जुड़न धोड़े, एपोदन काढयला पट्टान ऊपर लगाड़ीया। ");
INSERT INTO dhn_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","तव त्या राखवाळीन ढाळ कोप ओकी कड़ीयान झोपला एपोदन काढायला पट्टान ऊपर रये, आरु राखवाळीन ढाळ एपोद सी अलग नी हुयने जुळे; जसो योहोवा भगवान मुसा को हुकुम आपलो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","ओळी एपोदन बागा पुरो नीळ्ळा रंगन बनाया। ");
INSERT INTO dhn_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","आरु ओकी बनवाट असी हय कि उना वीच मा डोगलान कोट्टान डुचान सारको एक डुचो बनीयो, आरु डुचान चयारो मेर एक कुर बनी, कि त्यो नी फाटे। ");
INSERT INTO dhn_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","आरु त्या उना नेचला घेरा मा नीळ्ळा, जामनीया आरु रातला रंगन छिंदरान अनार बनाया। ");
INSERT INTO dhn_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","आरु त्या चुखला सोनान घंटिया बी बनावीन बागान नेचला घेरान च्यारो मेर अनारन वीचो वीच मा लगाड़ीया; ");
INSERT INTO dhn_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","मतलब झोगलान नेचला घेरान च्यारो मेर एक सोनान घंटी, आरु एक अनार लगाड़ीया कि त्या उको पेहरीन सेवा चाकरी करे; जसो योहोवा भगवान मुसा को होयो हुकुम आपलो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","ओळते त्या हारुन आरु उना पोर्यान क लियन बनली सुवाळा छिंदरान चोगला, ");
INSERT INTO dhn_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","आरु सुवाळा छिंदरान पागड़ी, आरु सुवाळा छिंदरान घाटाळा टुपीया बनाया, आरु सुवाळा छिंदरान चोड्डा बनायो, ");
INSERT INTO dhn_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","आरु सुवाळा छिंदरान सनीन छिंदरान आरु नीळ्ळ, जामनिया आरु रातला रंगन ढाळ्ळीन काम कोरली पागड़ी; एनु आखान सारको योहोवा मुसा को हुकुम आपलो हुतो तसोत् बोनायो। ");
INSERT INTO dhn_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","ओळते‍ त्या चुखला मुकुटन पट्टी चुखला सोनान बनाया; आरु छापा मा वसात् उना मा आकड़ा गोंदाड़ीयो, कि योहोवा भगवान क लियन चुखलो। ");
INSERT INTO dhn_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","आरु त्या उना मा निळो दुयड़ो लगाया, जिना सी‍ त्यो उपोर पागड़ी पर रये, जीने रीतिये योहोवा भगवान मुसा को हुकुम आपलो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","इणीये बरीतिये सी मिलापवाळा तम्बुन निवास को सब का खतम हुयो, आरु जिनान-जिना कामन हुकुम योहोवा भगवान मुसा को आपलो हुतो, इसराएलीया लोगहन तोसात् करीया। ");
INSERT INTO dhn_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","तव त्या निवास को मुसा को मुसान पास मा ली आया, मतलब घुड़िया पाटिया बेड़ीया, खाम्बा, कुड़ची हसान हसा ओळी आखो सोमान भेळ तम्बु, ");
INSERT INTO dhn_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","आरु रातला रंगन रंगायली गाडरीन खालड़ीन पांगरुन, आरु सुईसो नावोन मोटला माछान खालड़ान पांगरुन, आरु वीच मा वाळो परदो; ");
INSERT INTO dhn_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","डांडान सात मा गोवान पत्रीन सन्दुक आरु पछतावान ढाकनो; ");
INSERT INTO dhn_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","सारा सामान को भेळ टेबल, आरु भेटन रोटा; ");
INSERT INTO dhn_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","सारा सामान को चुखला सोनान सात मा दीवलिया, आरु ओकी घाटाळो कोरनेन दीवु आरु विजाळो आपने करीन तेल; ");
INSERT INTO dhn_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","सोनान वेदी, आरु चुखो कोरलो तेल, आरु वारु गंदायने वाळो धूप, आरु तम्बुन झोपलान परदा; ");
INSERT INTO dhn_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","पीतळन झांझरी, डांडा आरु आखा सोमान को सात मा मोटलो तोपलो; ");
INSERT INTO dhn_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","खम्बा आरु कुरसियान को सात मा आंगनान, परदा आरु आंगनान झोपलान परदा, आरु दुयड़ा, आरु खुटा, आरु परमेश्वरन होजरी वाळा तम्बुन रोहनेन सेवान सारो समान; ");
INSERT INTO dhn_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","चुखला जागान सेवा चाकरी करने करीन घाटळा कोरला छिंदरा, आरु हारुन पुजारान चुखला छिंदरा, आरु उना पोर्यान छिंदरा जिनको पेहरीन हेनको पुजारान काम करनो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","मतलब जो-जो हुकुम योहोवा भगवान मुसा को आपलो हुतो हसन हस इसराएली लोगहन सब काम करीया। ");
INSERT INTO dhn_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","तव मुसा सारा कामन ओरावो लीन देख्‌यो कि त्या योहोवा भगवानन हुकुमन अनसारे आखो काय हुतो त्यो काम करीया। आरु योहोवा भगवान हेनको सोय बरकत आपीयो। ");
INSERT INTO dhn_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","ओळी योहोवा भगवान मुसा सी कयो, ");
INSERT INTO dhn_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“पेहले मयनेन पेहले दाहड़े तु परमेश्वरन होजरी वाळा तम्बुन को उबो करजी। ");
INSERT INTO dhn_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","आरु उना मा गोवान पत्रीन सन्दुक को मेकीन वीचमा परदान ओट मा कर देजी। ");
INSERT INTO dhn_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","आरु टेबल को माहय ली जाईन जो काहय उना पर सजावनो छे उको सजाय देजी; तव दिवा को धोड़े ली जायीन उना दीवलिया को दपाड़ देजी। ");
INSERT INTO dhn_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","आरु गोवान पत्रीन सन्दुकन अगळ सोनान वेदी को जो धुप क लियन छे उको राखजी, आरु निवास को झोपलान परदा को लगाड़ देजी। ");
INSERT INTO dhn_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","आरु परमेश्वरन होजरी वाळा तम्बुन को झोपलान सामने होमबली को राखजी। ");
INSERT INTO dhn_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","आरु परमेश्वरन होजरी वाळा तम्बुन आरु वेदीन वीच मा मोटला तोपला को राखीन उना मा पानी भरजी। ");
INSERT INTO dhn_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","आरु च्यारो तरफ आंगनान पोरदान वाड़ को उबो करजी, आरु उना आंगनान झोपला पर परदा लटकाड़ देजी। ");
INSERT INTO dhn_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“आरु चुखो कोरलो तेल लीन निवासन आरु जो काय उना मा रयसे, सबन को चुखो करजी, आरु आखा सामान को सात मा उको चुखो करजी; तव त्यो चुखलो हुयसे। ");
INSERT INTO dhn_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","सब सामान क सात मा होमबली को चुखो कोरिन ओको अर्पन करजी तव त्यो चुखामा चुखो हुयसे। ");
INSERT INTO dhn_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","पायान पुठी मोटलो तोपलो बी आपीन उको चुखो करजी।” ");
INSERT INTO dhn_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","तोत्यार हारुन आरु उना पोर्यान को मिलापवाळा तम्बुन झोपला पर ली जाईन पानी सी नहवाड़जी, ");
INSERT INTO dhn_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","आरु हारुन को चुखलो छिंदरो पेहरावजी, आरु उको होपीन उको चुखो करजी कि त्यो म्हारे लियन पुजारान को काम करे। ");
INSERT INTO dhn_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","आरु उका पोर्यान को ली जाईन चोगलो पेहरावजी, ");
INSERT INTO dhn_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","आरु जसो तु हेनका बास को अभिषेक करीसजी कि त्या म्हारे लियन पुजारान को काम करे; आरु हेनको अभिषेक हेनकी पीड़ी-पीड़ी क लियन हेनका जलोमको पुजारान जागो आरु सोहलाणी हुयसे। ");
INSERT INTO dhn_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","आरु मुसा जो-जो हुकुम योहोवा उको आपलो हुतो ओकोत् अनसारे करीयो। ");
INSERT INTO dhn_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","आरु दिसरे सालोन पेहले मयनान पेहला दाहड़ाम रोहनेन तम्बु को उबो करीयो। ");
INSERT INTO dhn_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","मुसा रोहनेन तम्बु को उबो करीयो आरु ओकी कुड़ची मेकिन उका पाटिया लगाड़ीन उनामा डांडा न्हाकीयो आरु उका खाम्बा उबो करीयो; ");
INSERT INTO dhn_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","आरु त्यो निवास को ऊपर तम्बु को फैलायो, आरु तम्बुन उपर त्यो पांगरुन को लगाड़ीयो; जिने रीतिये योहोवा मुसा को हुकुम आपलो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","आरु त्यो गोवान चिट्ठीन को लीन सन्दुक मा मेल दीदो, आरु सन्दुक मा डान्डान को लगाड़ीन उना उपर पछतावान ढाकना को मेल दीदो; ");
INSERT INTO dhn_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","आरु त्यो सन्दुक को निवास मा पुगाड़ीयो, आरु वीचवाळा परदा को लटकाड़ीन गोवा पत्रीन सन्दुक को ओको माहयतो करीयो; जिना रीतिये सी योहोवा मुसा को हुकुम आपलो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","आरु त्यो परमेश्वरन होजरी वाळा तम्बु मा निवासन उगेवनो आरु वीचमा वाळा परदा सी बाहर मेज को लगवाड़ीयो, ");
INSERT INTO dhn_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","आरु उना पर त्या योहोवा भगवान को सामने रोटा को सजावीन मेलीयो; जिने रीतिये योहोवा भगवान मुसा को हुकुम आपलो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","आरु त्यो मिलापवाळा तम्बु मा मेजन सामने निवासन दोखेवरे दीवलिया को मेलीयो, ");
INSERT INTO dhn_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","आरु त्यो दीवलियान को योहोवा भगवान को सामने धपाड़ दीदो; जिने रीतिये योहोवा भगवान मुसा को हुकुम आपलो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","आरु त्यो परमेश्वरन होजरी वाळा तम्बुन वीच मा वाळा परदान अगळ सोनान वेदी को मेलीयो। ");
INSERT INTO dhn_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","आरु त्यो उना पर वारु गंदायने वाळो धूप को धपाड़ीयो; जिने रीतिये योहोवा भगवान मुसा को हुकुम आपलो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","आरु त्यो निवासन झोपला पर परदान को लगाड़ीयो। ");
INSERT INTO dhn_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","आरु परमेश्वरन होजरी वाळा तम्बुन निवासन झोपला पर होमबली को मेलीन उना पर आगठान बलि आरु ओन बलि को चढायो; जिने रीतिये योहोवा भगवान मुसा को हुकुम आपलो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","आरु त्यो परमेश्वरन होजरी वाळा तम्बु आरु वेदीन वीच मा मोटला तोपला को मेलीन उना मा धुवने क लियन पानी न्हाकीयो, ");
INSERT INTO dhn_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","आरु मुसा आरु हारुन आरु हारुनन पोर्या उना मा आपसा-आपसा हाथ पाय धुया; ");
INSERT INTO dhn_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","आरु जव जव त्या मिलापवाळा तम्बु मा या वेदीन पास मा जाता हुता तव-तव त्या हाथ पाय को धुवतला; जिने रीतिये योहोवा भगवान मुसा को हुकुम आपलो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","आरु मुसा निवासन च्यारो मेर वेदीन ओड़े-धोड़े आंगनान पोरदा को उबो करायो, आरु आंगनान झोपलान परदा को लटकाड़ दीदो। इनीये रीतिये सी मुसा आखा कामक पुरो करीयो। ");
INSERT INTO dhn_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","तव वादळो मिलापवाळा तम्बु पर छावाय गियो, आरु योहोवा भगवानन विजाळो निवास जागा पर भराय गियो। ");
INSERT INTO dhn_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","आरु वादळो मिलाप वाळा तम्बु पर ठेहर गियो, आरु योहोवा भगवान को विजाळो निवास जागा पर भराय गियो, इनीये रीतिये मुसा उना मा नी भराय सकीयो। ");
INSERT INTO dhn_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","इसराएलीयान सारी यात्रा मा असोत् हुयतलो हुतो, कि जव-जव त्यो वादळो निवासन ऊपर सी जात रयतो हुतो तव-तव‍ त्यो अगा जाता रयतला। ");
INSERT INTO dhn_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","आरु कदाम त्यो वादळो नी उठतलो, ती जिने दाहड़े तक वादळो नी उठ जातलो उना दाहड़े तक अगा नी जाता हुतो। ");
INSERT INTO dhn_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","इसराएली लोगहन नी आखी यात्रा मा दिसु मा ते योहोवा भगवानन वादळा मा रोहतलो, आरु राती उना वादळा मा आगठो हेनको सब लोगहन को देखाय देतो हुतो।");
INSERT INTO dhn_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","योहोवा न मूसा क मिलाप वाळा तम्बू मा सी बुलावीन हेका सी कयो, ");
INSERT INTO dhn_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","इसराएलीयो सी कय कि कदाम तुमरे मा सी कोय मनुस यहोवा क लियन पशुन चढ़ावो चढ़ावे, ती पाळनिया पशु गाडरा- बुकड़ा माईन एक हुयनो जुवे। ");
INSERT INTO dhn_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","कदाम त्यो पाळनीया पशु मा सी होमबली करे, ती ओका मा काहय बी पाप नी हय उको मिलाप वाळा तम्बून झपला पर चढ़ावे कि योहोवा हेको मान लेय। ");
INSERT INTO dhn_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","त्यो आपसा हाथ को होमबलि क पशुन मूनका पर मेले, आरू त्यो हेका लियन पछतावो करने करीन मान लेसे। ");
INSERT INTO dhn_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","तव त्यो उना केवड़िया को योहोवा भगवान क सामने बलि करे; आरू हारून क पोर्या जो पुजारो छे त्या लुहूय को साते ली जाईन उनी वेदी न च्यारो मेर छिड़क देय जो मिलाप वाळा तम्बून झपला पर छे। ");
INSERT INTO dhn_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","ओळते त्यो खाल निकाळीन उना पशुन टुकड़ा-टुकड़ा करे; ");
INSERT INTO dhn_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","तव हारून पुजारान वेदी पर आग्ठी मेले, आरू आग्ठा पर लाकड़ा जावीन मेले; ");
INSERT INTO dhn_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","आरू हारून क पोर्या जो पुजारा छे त्या मूनका आरू चरबी क सात मा पशुन टुकड़ा क उनी लाकड़ी पर वेदीन आग्ठी पर हसे उको सजावीन मेले; ");
INSERT INTO dhn_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","आरू त्यो ओका आतड़ा आरू पाय को पानी सी धुवे। तव पुजारो सब को वेदी पर धपाड़ देय कि त्यो होमबलि योहोवा भगवान क लियन वारू गंधायने वाळो बलिदान बने। ");
INSERT INTO dhn_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","कदाम त्यो गाडरो या बुकड़ान होमबलि चढ़ावे, त्यो पूरो आरेगलो नर पशु हय उको चढ़ावे। ");
INSERT INTO dhn_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","आरू त्यो उको योहोवा न ओगळ वेदी पर उत्तर न तरफ बलि करे; आरू हारून क पोर्या जो पुजारा छे पशु क लुहूय को वेदीन चारो मेर छिड़की देय। ");
INSERT INTO dhn_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","आरू त्यो मूनका आरू चरबी क सात मा ओका टुकड़ा-टुकड़ा करे, आरू पुजारो ईनु आखान क उनी लाकड़ी पर सजावीन मेले जो वेदी रहवसे; ");
INSERT INTO dhn_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","त्यो ओका आतड़ा आरू पाय को पानी सी धुवे। आरू पुजारो वेदी पर धपाड़े कि‍ त्यो होमबलि हुय जाय आरू योहोवा भगवान जुगु गंधायने वाळो बलिदान बने। ");
INSERT INTO dhn_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“कदाम त्यो यहोवा क लियन चिल्लान होमबलि चढ़ावे, ती हुली नीते पेरवान क चढ़ावो चढ़ावे। ");
INSERT INTO dhn_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","पुजारो ओको वेदी क साते ली जाईन हेका गळा क मुयड़ीन मूनको धड़ सी अलग करे, आरू वेदी पर धपाड़े; आरू उका सारा लुहूय को उनी वेदी क धड़े पाड़ देय; ");
INSERT INTO dhn_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","आरू त्यो ओकी गळान थयली को पाखड़न क सात निकाळीन वेदी क पूरबन तरप रुखड़ो न्हाकनेन जागा पर न्हाक देय; ");
INSERT INTO dhn_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","आरू त्यो ओका पाखड़ान वीच मा सी फाड़ देय, पुन अलग-अलग नी करे। तव पुजारो उको वेदी पर उनी लाकड़ीन उपर मेलीन जो आग्ठा पर हसे उको धपाड़े कि‍ त्यो होमबलि आरू यहोवा क लियन गंधायने वाळो बलिदान बने। ");
INSERT INTO dhn_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“जव कोय यहोवान करता अन्नबलि क चढ़ावो चढ़ावने चाहे, त्या मैदा चढ़ावे; आरू हेका पर तेल न्‍हाखीन हेके उपर लोबान राखे ");
INSERT INTO dhn_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","आरू चा उकान हारून क पोर्‍या क जु याजक छे, लावे। आरू चा अनाज भेंटन तेल भेसकलो मैदा मा सी ओका गत आपनी भरीन निकाळे कि सब लोबान उकामा आय जाय; आरू याजक हेको फोम आपने वाळा भाग क करता वेदी पर धोपाड़्या कि या योहोवा क करता सुखदायक सुगन्धित भेंट हुयसे। ");
INSERT INTO dhn_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","आरू अनाज भेंट मा सी जो वाचला रवे चा हारून आरू उकान पोर्‍या क ठरसे; या योहोवा क भेंट मा सी घण चुखो वाटो छे। ");
INSERT INTO dhn_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“जव तु अन्नबलि न करता तन्दूर मा रांदलो चढ़ावु चढ़ाया, ते चा तेल सी झारली अखमीरी चांतीक होय। ");
INSERT INTO dhn_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","आरू कदाम तार चढ़ावु तवा पर रांदलो अन्नबलि होय, ते चो तेल करीन झारलो अखमीरी मयदान होसे; ");
INSERT INTO dhn_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","हेका टुकड़ा टुकड़ा करीन हेका पर तेल न्‍हाकजो, तव त्यो अनाज भेंट हुय जासे। ");
INSERT INTO dhn_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","आरू कदाम थारो चढ़ावो कढ़ाई मा तोवलो अनाज भेंट हय, ती त्यो मयदा सी तेल मा बनावनो जुळे। ");
INSERT INTO dhn_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","आरू जु अनाज भेंट ओका चीज मा सी काहनी होय उका योहोवा क सामने ली जानु; आरू जव चु याजक क जु लाया जासे, तव याजक उका वेदी क सामने ली जाय। ");
INSERT INTO dhn_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","आरू याजक अनाज भेंट मा रयी फोम करावने वाळो भाग निकाळीन वेदी पर धोपाड़े की त्यो योहोवान करता सुखदायक सुगन्धवाळो भेंट ठरसे; ");
INSERT INTO dhn_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","आरू अन्नबलि मा सी जो वाचलो रवे चो हारून आरू उकान पोर्‍यो न ठरसे; चो योहोवा क भेंट मा घण चुखु वाटु हुयसे। ");
INSERT INTO dhn_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“काहलो अनाज भेट जेको तुमु यहोवान करता चढ़ावु, खमीर भेस्किन झुण बनावता; तुमु कदी आग्ठान भेंट मा यहोवान करता, खमीर आरू माहळ झुण धोपाड़जु। ");
INSERT INTO dhn_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","तुमु हेको पेहली फसलन चढ़ावु करीन यहोवान करता चढ़ावा, पर चा सुखदायक सुगन्ध क करता वेदीन आग्ठी पर झुन चढ़ावु। ");
INSERT INTO dhn_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","पछा आपना सब अनाजन भेंट क नमकीन बनावनु; आरू आपना कुई अनाजन भेंट आपना परमेश्वरन साथ मा बाँधली वाचा क नोन सी रहित होयने नी देनु; आपना सब चढ़ावा साथे नोन भी चढ़ावनु। ");
INSERT INTO dhn_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“कदाम तु योहोवा क करता पेहली फसलन अनाजन भेट चढ़ावु, ते आपनी पेहली कमायन अनाजन करता आग्ठा मा भुंजली निळ्ळी-निळ्ळी उम्बीया , मतलब निळ्ळी-निळ्ळी उम्बीयाक मसळीन निकाळ लेनु, तव अनाज भेंट चढ़ावनु। ");
INSERT INTO dhn_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","आरू उका मा तेल नाखनु, आरू उकान उपर लोबान राखनु; तव चा अनाज भेंट हुय जासे। ");
INSERT INTO dhn_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","आरू याजक मसळीन निकावलो अन्ना क, आरू तेल क, आरू सब लोबान क फोम करवानेवाळो भाग करीन धोपाड़ दे; त्यो यहोवा क करता वेदी की आग ठरसे। ");
INSERT INTO dhn_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“कदाम उकान चढ़ावु मेलबलि क होय, आरू कदाम चा केवड़ी-बुयल मा सी काहना क चढ़ावे, चाहे चा पशु नर होय या मादा, ते जु पूरो आरगो हय हेकेक त्यो यहोवान अगोळ चढ़ावे। ");
INSERT INTO dhn_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","आरू चा आपसो हाथ आपसा चढ़ावान करता पशु न मुनका पर मेले आरू हेको मिलापवाळा तम्बून झपला पर बलि करे; आरू हारून क पोर्‍यो जो पुजारो छे त्यो हेको लुहूय क वेदीन च्यारू मेर छिड़के। ");
INSERT INTO dhn_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","आरू त्यो मेलमिलापन बलि मा रयीन यहोवान करता वेदी की आग्ठी मा चढ़ावे, मतलब जीनी चरबी सी आतड़ा ढाकयला रये, आरू जो झाळ हेना मा लेपटाय रये ची भी, ");
INSERT INTO dhn_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","आरू दुयु गुर्दा आरू हेके उपर वाळी चरबी जो कमर क जु रवती छे, आरू गुर्दान क सात मा काळजा न उपर झाळी, इनु सबन क त्यो अलग करे। ");
INSERT INTO dhn_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","तव हारून क पोर्यो हेनको वेदी पर होमबलि पर धोपाड़े, जो हेनू लाकड़ा पर हसे जो आग्ठान उपर छे कि यो यहोवान करता सुखदायक सुगन्धवाळा भेट रयसे। ");
INSERT INTO dhn_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“कदाम यहोवा न मेलमिलाप न बलिन करता हेको चढ़ावो पालतु पशु मा सी होय, ते चाहे त्यो नर हय या मादा, पर जो पूरा डिलोम आरगो हय हेको चढ़ावे। ");
INSERT INTO dhn_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","कदाम त्यो गाडरान पीलो चढ़ावतो हय, ती हेको यहोवान क सामने चढ़ावे, ");
INSERT INTO dhn_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","आरू चा आपनु चढ़ावान पशु न मुनका पर हाथ मेके आरू हेको मिलापवाळा तम्बू न अगोळ बलि करे; आरू हारून क पोर्यो हेको लुहूय वेदीन च्यारो तरफ छिड़के। ");
INSERT INTO dhn_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","तब मेलबलि मा सी चरबा क योहोवा क करता हवन करे, मतलब ओकान चरबी भरली मोटली सेमटी क चा रीढ़न जुळ सी अलग करे, आरू जेकी चरबी सी आतड़्या ढ़ाकला रये, आरू जी चरबो उना मा चिपकली रवती छे, ");
INSERT INTO dhn_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","आरू दुयु गुर्दा, आरू जो चरबो उकान उपर कमर क जु रवती छे, आरू गुर्दा समेत कावजा क उपरली झिल्ली, इना सभा क चा अलग करे। ");
INSERT INTO dhn_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","आरू याजक ओका वेदी पर धोपाड़े; या योहोवा क करता भेंट रूपी भोजन ठरसे। ");
INSERT INTO dhn_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“कदाम चा बुकड़ी चढ़ावे ती हेको योहोवा क सामने चढ़ाया। ");
INSERT INTO dhn_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","आरू चा आपना हाथ उकान मुनका पर मेके, आरू उकाह मिलापवाळा तम्बू क ओगव बलि करे; आरू हारून क पोर्‍या उकान लुहूय क वेदी क चार तरफ छिड़कु। ");
INSERT INTO dhn_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","तव चा उकामा सी आपनो चढ़ावो योहोवा क करता वेदी की आग पर चढ़ावे, मतलब जीन चरबी सी आतड़ा ढाकायला रये छे, आरू जो चरबी हेकाम चिपकली रये त्यो भी, ");
INSERT INTO dhn_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","आरू दुयु गुर्दा आरू जो चरबो उकान उपर कमर क जु रवती छे, आरू गुर्दा समेत काळजान क उपर वाळी जाळी, इनु सबन क त्यो अलग करे। ");
INSERT INTO dhn_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","आरू याजक ओका वेदी पर धोपाड़्या; यो हवन रूपी भोजन छे जो सुखदायक सुगन्ध क करता हतलो छे; काहकी सब चरबी यहोवान छे। ");
INSERT INTO dhn_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","यो तुमरी रयने जागा मा तुमरी पीढ़ी पीढ़ी क करता हमेशान विधि रयसे कि तुमु चरबी आरू लुहूय कदी नी खावु।” ");
INSERT INTO dhn_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","पछो यहोवा न मूसा सी कयो, ");
INSERT INTO dhn_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","इस्राएलिया सी यो कोय कि कदाम कोय मनुस उना कामो मा सी जीनाक यहोवा मना करलो छे, काहना काम क विसरीन करीन पापी होय जाए; ");
INSERT INTO dhn_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","आरू कदाम अभिषिक्त याजक ओसो पाप करे जेका सी प्रजा दोषी ठरसे, ते आपना पापन कारण चु एक पूरो आरेगलो बयल्यो योहोवा क पापबलि करीन चढ़ाया। ");
INSERT INTO dhn_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","त्यो उना बयल्यान क मिलापवाळा तम्बू न झोपला पर योहोवा क ओगव ली जाईन उकान मुनका पर हाथ मेके, आरू उका बयल्यान क योहोवा क सामने बलि करे। ");
INSERT INTO dhn_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","आ रू अभिषिक्त पुजारो बयलशयान क लुहूय मा सी काहय लीन मिलापवाळा तम्बू मा ली जाय; ");
INSERT INTO dhn_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","आरू पुजारो आपसी आंगळी लुहू मा डुबाड़ी-डुबाड़ीन आरू हेकामा सी काहय लीन चुखला जागान वीच माहयला परदान क ओगळ यहोवान सामने सात वार छिड़के। ");
INSERT INTO dhn_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","आरू पुजारो हेका लुहूय मा सी लीन वारू गंधायने वाळा धुपन वेदीन क सिंगड़ा पर जो मिलापवाळा तम्बू मा छे यहोवान क सामने लगाड़े; ओळी बयल्यान क सब लुहूय वेदीन क पाया पर जो मिलापवाळा तम्बून झपला पर छे रेड़ देय। ");
INSERT INTO dhn_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","पछु चु पापबलि क बयल्यान क सब चरबी हेका सी अलग करे, आरू जीनी चरबी सी आतड़ा ढाकायला रवता छे, आरू जोतरो चरबो उना मा चिपकली रवती छे, ");
INSERT INTO dhn_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","आरू दुयु गुर्दा आरू उना क उपर क चरबो जो कमर क जु रवती छे, आरू गुर्दा समेत कावजा ऊपर ली जाळी, इना सभा क अलग करे, ");
INSERT INTO dhn_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","जोसो मेलमिलापन बलिवाळा चढ़ावा क बयल्या सी अलग कर्‍या जाता छे, आरू याजक इनुक होमबलि कर्‍या वेदी पर धोपाड़ीयो। ");
INSERT INTO dhn_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","पुन उना केवड़ा क खाल, पाये, मुनको, आतड़ा, गुबर, ");
INSERT INTO dhn_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","आरू सब मांस, मतलब पूरो बयल्यो पड़ाव सी बाहरते चुखला जागा मा, जा रूखड़ो नाखे, ली जाईन लाकड़ा पर मेलीन आग्ठा सी धोपाड़़े; जा रूखड़ो न्‍हाखे तेखे व्हा धपाड़े। ");
INSERT INTO dhn_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“कदाम इस्राएल क सब मण्डली अज्ञानतान कारण पाप करे आरू ची वात मण्डली क डुवा सी धोपाय छे, आरू चा योहोवा क काहनी हुकुम क विरूध्द काहय करीन दोषी ठर्‍या छे; ");
INSERT INTO dhn_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","ते जव उकान करीन पाप प्रगट होय जाय तव मण्डली एक केवड़ा क पापबलि करीन चढ़ाया। चा उका मिलापवाळा तम्बू क ओगव ली जाय, ");
INSERT INTO dhn_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","आरू मण्डळीन डाहला लोगहन आपना आपना हाथ क योहोवा भगवान क ओगळ बयल्या क मुनका पर मेके, आरू चो बयल्या क योहोवा भगवान क सामने बलि कर्‍या जासे। ");
INSERT INTO dhn_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","तव अभिषिक्त याजक बयल्यान ज लुहूय मा सी मिलापवाळा तम्बू मा ली जासे; ");
INSERT INTO dhn_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","आरू याजक आपनी आंगुळ लुहूय मा डुबाड़ीन हेका वीचमाहयला परदा क ओगव सात वार योहोवा क सामने छिड़के। ");
INSERT INTO dhn_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","आरू हेका लुहूय मा सी वेदीन सिंगड़ा पर जो यहोवान ओगळ मिलापवाळा तम्बू मा छे लगाड़े; आरू वाचला सब लुहूय होमबलि न वेदी क पाया पर जो मिलापवाळा तम्बू क झोपला पर छे रेड़ देय। ");
INSERT INTO dhn_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","आरू त्यो बयल्यान सब चरबी निकाळीन वेदी पर धपाड़ देय। ");
INSERT INTO dhn_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","जसो पापबलिन बयल्या सी करला हुता तसोज हेका सी भी करे; इनीये रीतिये पुजारो इस्राएलियान पाप क ढाके, तव उनाक चो पाप माप करलु जासे। ");
INSERT INTO dhn_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","आरू चा बयल्यान क पड़ाव सी बाहरो ली जाईन इनिये रीतिये धपाड़े जसो पेहला बयल्यान क धोपाड़यो हतो; यी मण्डलीन करता पापबलि हुयसे। ");
INSERT INTO dhn_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“जव कुई मुखि मानुस पाप करीन आपना परमेश्वरन योहोवा क काहनी हुकुम क विरूध्द मा विसर भूले सी काहय करीन दोषी होय जासे, ");
INSERT INTO dhn_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","आरू उकान पाप उका पर प्रगट होय जासे, ते वा एक निर्दोष बुकड़ो बलिदान करने क करीन ली आया; ");
INSERT INTO dhn_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","आरू बुकड़ा क मुनका पर आपना हाथ धरे, आरू बुकड़ा क उका जागा पर बलि करे जा होमबलि योहोवा भगवान क ओगव बलि कर्‍या जाता छे; या पापबलि ठरसे। ");
INSERT INTO dhn_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","तव पुजारो आपनी आंगुव सी पापबलि क लुहूय मा सी काहय लीन होमबलि क वेदी क सिंगड़ा पर लागाड़े, आरू उकान लुहूय होमबलि क वेदी क पाय पर नाख दे। ");
INSERT INTO dhn_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","आरू चा उकान कुल चरबा क मेलबलि क समान वेदी पर धोपाड़े; आरू याजक उकान पाप क विषय मा पश्चाताप कर, तव चु माप कर्‍यु जासे। ");
INSERT INTO dhn_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“कदाम साधारण लोगहन मा सी कुई विनअकल सी पाप करे, हेनू काम क जिनू सी योहोवा भगवान मना कर्‍यु हेके करे ती त्यो दोषी हुयसे, ");
INSERT INTO dhn_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","ते चा उका पाप क कारण एक निर्दोष बुकड़ी बलिदान क करता ली आया; ");
INSERT INTO dhn_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","आरू चु आपना हाथ पापबलिपशु क मुनका पर मेके, आरू होमबलि क जागा पर पापबलिपशु क बलिदान करे। ");
INSERT INTO dhn_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","आरू याजक उकान लुहूय मा सी आपनी आंगुव सी काहय लीन होमबलि क वेदी क सींगड़ा पर लागाड़े, आरू उकान सब लुहूय क उका वेदी क पाय पर माख दे। ");
INSERT INTO dhn_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","आरू ची उकान सब चरबा क मेलमिलाप बलिपशुन चरबीन क सारको अलग करे, तव याजक ओका वेदी पर योहोवा क करता सुखदायक सुगन्ध क करता धोपाड़े; आरू ओका प्रकार याजक करता पश्चाताप करे, तव उका मापी जोड़से। ");
INSERT INTO dhn_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“कदाम चु पापबलि क करता एक गाडरीन पीलो ली आयो, ते चु पूरो आरेगलो मादा होय, ");
INSERT INTO dhn_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","आरू चु आपना हाथ पापबलि क मुनका पर मेके, आरू उकान पापबलि क करता चोज बलिदान करे जा होमबलिपशु बलि कर्‍या जाता छे। ");
INSERT INTO dhn_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","तव याजक आपनी आंगुळ सी पापबलिन लुहूय मा सी काहय लीन होमबलि क वेदी क पाय पर नाख दे। ");
INSERT INTO dhn_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","आरू त्यो हेकी सब चरबी क मेलबलिवाळा गाडरान पीलान चरबी समान अलग करे, आरू याजक उका वेदी पर योहोवा क हवन क ऊपर धोपाड़े; आरू ओका प्रकारन याजक उकान पाप क करता पश्चाताप करे, आरू तिनाक माप कर दे जासे। ");
INSERT INTO dhn_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“कदाम कोय गवा हुयीन सो पाप करे कि कसम खावड़ावीन पुछने पर भी कि काय तु यो समळ्यू नीते जाने, आरू ची वात उजेन्‍ती नी करे, ते ओका आपना गुणान भार झेलनो पड़से। ");
INSERT INTO dhn_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","कदाम कोय विटुळ चीज क भुल चुक सी हाथ लगाड़े, ते चाहे चु अशुद्ध बनैल पशु क, चाहे शुद्ध घर माहयला पशु क, चाहे अशुद्ध रेंगनेवाळा जीव-जन्तु न धड़ हय, ती त्यो विटुळ हुयीन गुणाको ठरसे। ");
INSERT INTO dhn_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","निते कदाम कुई मानुस काहनी अशुद्ध चीज क भुल चुक सी हाथ ले, चाहे चु अशुद्ध चीज काहनी भी प्रकार करे काह नी होय जेका सी मानसे अशुद्ध होय जाता छे, ते जव चु उका वात क जाव लेसे तव चु दोषी ठरसे। ");
INSERT INTO dhn_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","कदाम कुई बुरो या भलो करने क बिना सोचे समझे शपथ खादा, चाहे काहना प्रकारन वात बिना-विचारे शपथ खाईन कोया, ते ओसी वात मा चु दोषी उका टेमे ठरसे जव उका मालुम होय जासे। ");
INSERT INTO dhn_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","आरू जव त्यो इनी वातो मा सी काहनी भी वात मा गुणेगार हय, तव जेका विषय मा ओको पाप कर्‍या होय चु ओकाह मान ले, ");
INSERT INTO dhn_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","आरू चु योहोवा क सामने आपनो दोषबलि ली आया, मतलब उका पाप क कारण चा एक गाडरा या बुकड़ा पापबलि करने क करता ली आया; तव याजक उका पाप क विषय पश्चाताप करे। ");
INSERT INTO dhn_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“पुन कदाम उका गाडरा या बुकड़ी आपने क सामर्थ्य नी होय, ते आपना पाप क कारण दुय पण्डुक या कबूतरी क दुय पिल्ला दोषबलि चढ़ावनेन करता योहोवा क साथे ली आया, उनामा सी एक ते पापबलि क करता आरू दिसरा होमबलि क करता लावे। ");
INSERT INTO dhn_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","चा ओकान याजक क जु ली आया, आरू उकान मुनका गवा सी पिव्वी नाखे, पुन अलग नी करे, ");
INSERT INTO dhn_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","आरू चु पापबलिपशु क लुहूय मा सी वेदी क बाजु पर छिड़के, आरू जो लुहूय शेष रवे ची वेदी क पाय पर पाड्या जासे; चो पापबलि ठरसे। ");
INSERT INTO dhn_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","तव दिसरा चिल्ला क ची विधि क अनसारे होमबलि करे, आरू याजक ओकान पाप क पश्चाताप करे, आरू तव चा माप कर्‍या जासे। ");
INSERT INTO dhn_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“पुन कदाम चा दुय पण्डुक या कबूतरी क दुय पिल्ला भी नी आप सके, ते चो आपना पाप क कारण आपना चढ़ावु एपा क दसवु भाग मयदा पापबलि करीन ली आया; उका पर नी ते चा तेल नाख्या, आरू नी लोबान मेक्या, काहकी चो पापबलि होयसे। ");
INSERT INTO dhn_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","चु उकाह याजक क जु ली जावु, आरू याजक उकामा सी आपनी मुठ भरीन फोम आपावनेवाळा भाग जानीन वेदी पर योहोवा क हवनो क ऊपर धोपाड्या; चो पापबलि ठरसे। ");
INSERT INTO dhn_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","आरू इनी वात मा सी काहनी भी वात क विषय मा को कुई पाप करे, याजक ओकान पश्चाताप करे, आरू तव चु पाप माप कर्‍या जासे। आरू ओका पापबलि क शेष अन्नबलि क शेष क समान याजक क ठरसे।” ");
INSERT INTO dhn_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","पछा योहोवा मूसा सी कयो, ");
INSERT INTO dhn_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","कदाम कुई योहोवा क चुखी करली चीजन वारा मा गलती सी विश्वासघात करे आरू पापी ठरसे, ते चु योहोवा क जु एक निर्दोष गाडरा दोषबलि क क करता ली आया; ओकान किमत पवित्रस्थान क शेकेल क अनसारे ओतरा ज शेकेल चाँदीन होय जोतरो याजक ठरसे। ");
INSERT INTO dhn_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","आरू जेका चुखली चीज क विषय उको पाप कर्‍या होय, उकामा चु पाचवु भाग आरू बढ़ावीन याजक क आप; आरू याजक दोषबलि क गाडरो चढावीन उकान पाप क ढाँके, तब उकान पाप माप कर्‍या जासे। ");
INSERT INTO dhn_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“कदाम कुई ओसो पाप करे के उना कामो मा सी जेका योहोवा भगवान मना कर्‍यो छे काहना काम करे, ते चाहे चु हेको आपसा गुणान भार उठावनु पड़से। ");
INSERT INTO dhn_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","एरकरता चु एक निर्दोष गाडरा दोषबलि करीन याजक क जु ली आया, चा ओतरीज किमत क होय जोतरा याजक ठराया, आरू याजक उकान करता ओकान ओकी भूल क जा ओकाह अनजावना मा करी होई पश्चाताप करे, आरू चु माप कर्‍यु जासे। ");
INSERT INTO dhn_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","यी दोषबलि ठरसे; काहकी चु मानुस पाक्को योहोवा क सम्मुख दोषी ठरसे।” ");
INSERT INTO dhn_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","पछु योहोवा मूसा सी कयो, ");
INSERT INTO dhn_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“कदाम कोय यहोवा सी विश्वासघात करीन पापी ठरसे, जोसो कि धरोहर, या लेनदेन, या लूट क विषय मा आपना भाईस्यक साथे कपट करे, या ओका पर आंधारो करे, ");
INSERT INTO dhn_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","या पड़ रयली चीज जड़े ती हेका वारा मा झूठ बुले आरू झूठी कसम बी खाय; ओसी कुई भी वात काह नी होय जेको करीन मानुस पापी ठरतु छे, ");
INSERT INTO dhn_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","ते जव चु ओसो काम करीन दोषी होय जाय, तव जु भी चीज ओको लुट्यो, या आंधारो करीन, या धरोहर, या खुवायली चीज जो हेको जोड़ली हय ; ");
INSERT INTO dhn_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","चाहे काहनी भी चीज काह नी होय जेका विषय मा उको झूठी शपथ खादली होसे; ते ची उको सब वापस कर दे, आरू पाचवु भाग भी बढ़ावीन भर दे, जेके दाहड़े यो मालुम होसे कि चु दोषी छे उके दाहड़े चु उका चीज क ओका स्वामी क वापस कर दे। ");
INSERT INTO dhn_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","आरू चु योहोवा क सामने आपना दोषबलि भी ली आया, मतलब एक पूरो आरेगलो गाडरा दोषबलि क करता याजक क जु ली आया, चा ओतरी किमत होय जोतरो याजक ठरावसे। ");
INSERT INTO dhn_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","ओका प्रकार क याजक उकान करता योहोवा क सामने पश्चाताप करे, आरू जेका काम क करीन चु दोषी होय गया छे उकाह मापी जोड़से।” ");
INSERT INTO dhn_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","आरू यहोवा मूसा सी कयो, ");
INSERT INTO dhn_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“हारून आरू ओकान पोर्‍या क हुकुम आपीन यो कयो कि होमबलि क व्यवस्था यी छे: होमबलि भाट्टीन ऊपर रात भर भोर तक वेदी पर पवड़ा रवे, आरू वेदी क आगठो वेदी पर धोपती रवे। ");
INSERT INTO dhn_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","आरू याजक आपना सनी क छिंदरा आरू आपना डील पर आपनी झारली जाँघिया पेहरीन होमबलि क मेक, जी आग्ठा सी भस्म करने सी वेदी पर रय जाय, ओका उठावीन वेदीन धड़े मेक दे। ");
INSERT INTO dhn_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","तव चु आपना छिंदरा उतारीन दिसरा छिंदरा पेहरीन रूखड़ा क पड़ाव सी बाहरते काहना शुद्ध स्थान पर ली जाय। ");
INSERT INTO dhn_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","वेदी पर आगठो धोपतो रवे, आरू कभी उलवायने नी जुवे; आरू याजक हर एक दाहड़े पहाटे उका पर लाकड़ा धोपाड़ीन होमबलि क टुकड़ा क ओकान ऊपर सजाड़ीन धर दे, आरू ओकान ऊपर मेलबलिया क चरबा क धोपाड्या करे। ");
INSERT INTO dhn_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","वेदी पर आगठो लगातार धोपतो रवे; चो कभी बुझायनो नी जुवे। ");
INSERT INTO dhn_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“अन्नबलि क व्यवस्था इना गत छे: हारून क पोर्‍यो ओकाह वेदी क सामने योहोवा क सामने ली आया। ");
INSERT INTO dhn_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","आरू चु अन्नबलि क तेल भेस्कायलो मयदा मा सी मुठ भरीन आरू उका परलो सब लोबान उठावीन अन्नबलि क यादन ओका भाग क योहोवा क सामने सुखदायक सुगन्ध क करता वेदी पर धोपाड़े। ");
INSERT INTO dhn_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","आरू ओका मा सी जो शेष रय जाय ओका हारून आरू ओकान पोर्‍या खाय; चु बिना खमीर चुखलीजागा मा खाया जासे, मतलब चा मिलापवाळा तम्बू क आंगना मा उका खाये। ");
INSERT INTO dhn_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","चो खमीर क साथे रांदनो नी; काहकी हाव आपना हव्य मा सी उकाह ओकान निज भाग होयने क करता हेका देदा छे; एरकरता जोसो पापबलि आरू दोषबलि घण चुखो छे, तोसोज चो भी छे। ");
INSERT INTO dhn_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","हारून क वंश क सब मानुस उका मा सी खाय सकता छे, तुमरी पीढ़ी मा योहोवा भगवान क हवन मा सी यो उकान भाग हमेशा बवनो रवसे; जु कुई उना हवनो क हाथ लागाड़े चु चुखलु ठरसे।” ");
INSERT INTO dhn_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","पछु योहोवा मूसा सी कयो, ");
INSERT INTO dhn_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“जेके दाहड़े हारून क अभिषेक होसे उके दाहड़े चु आपना पोर्‍या क साथे योहोवा क यो चढ़ावु चढ़ायु; मतलब एपा क दसवु भाग मयदो नित्य अन्नबलि मा चढ़ाया, उका मा सी आर्धे पहाटे आरू आर्धे सांतेन टेमे चढ़ाया। ");
INSERT INTO dhn_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","चो तवा पर तेल क साथे रांदलो जासे; जव चो तेल सी तरी होय जाय तव उका ली आवनो, ओका अन्नबलि न चुल्लो टुकड़ो योहोवा भगवान क सुखदायक सुगन्ध करता चढ़ावनो। ");
INSERT INTO dhn_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","हारून क पोर्‍या मा सी जु भी उका याजक पद पर अभिषिक्त होसे, वी विधि हमेशा क करता छे। कि योहोवा क सामने चो सब‍ चढ़ावो धोपाड्यो जासे। ");
INSERT INTO dhn_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","याजक क सब अन्नबलि भी सब धोपाड्या जासे; चो कभी नी खातो जासे।” ");
INSERT INTO dhn_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","आरू योहोवा भगवान मूसा सी कयो, ");
INSERT INTO dhn_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“हारून आरू उकान पोर्‍या सी यो कयो कि पापबलि की नियम यो छे: जेका जागा मा होमबलिपशु क बलि कर्‍या जाता छे उका मा पापबलिपशु भी योहोवा भगवान क सामने बलि कर्‍या जासे; चु परमपवित्र छे।” ");
INSERT INTO dhn_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","जु याजक पापबलि चढ़ावु चु ओका खाये; चु पवित्रस्थान मा, मतलब मिलापवाळा तम्बू क आंगना मा काया जासे। ");
INSERT INTO dhn_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","जो काहय उकान मांस सी हाथ लागाड़े जासे, चु पवित्र ठरसे; आरू कदाम उकान लुहूय क छिटळा एकदा छिंदरा पर पड़ जाय, ते उकाह काहना चुखला जागा मा धुव देदु। ");
INSERT INTO dhn_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","आरू त्यो धुळान ठिकरा मा त्यो पाकाळलो गयो तुड़ दि जासे; कदाम चु पितवन पात्रा मा उबाळ्यो गयो छे, ते चो उजाळीन, आरू पाणी सी धुव देल्लो जासे। ");
INSERT INTO dhn_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","याजक मा सी सब मानसे उकाह खाय सकता छे; चु परमपवित्र चीज छे। ");
INSERT INTO dhn_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","पुन जेका पापबलिपशु क लुहूय मा सी काहय भी लुहूय मिलपवाळा तम्बू क माहयता चुखलो जागा मा पश्चाताप करने क पुगाड्या जासे, उकान मांस कभी नी खाय जासे; चो आग्ठा मा धोपाड़ दे जासे। ");
INSERT INTO dhn_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","यी दोष-बलिन व्यवस्था छे: ची घण चुखो छे। ");
INSERT INTO dhn_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","जिना जागा मा आग्ठा क बलि क पशु क वध करता छे, हेका स्थान मा दोष-बलि लीन पशु क वध कर्‍यो जासे, आरू उकान लुहूय वेदीक चार तरफ छिड़की जासे। ");
INSERT INTO dhn_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","उकान माइन सब चरबी क चढ़ावे: हेका चरबो भारी चरबी वाळी सेमटी, आतड्याक ढ़ाकने वाळो चरबो बी, ");
INSERT INTO dhn_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","दुयु गुर्दा आरू चो चरबो जो उकान ऊपर आरू कमर क जु रवती छे, आरू गुर्दा क साथ मा काळजान ऊपरली जाळी इनु सब कहो अलग करे । ");
INSERT INTO dhn_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","पुजारो हेको वेदी पर धोपाड़े। चु पोरबु क आग्ठा मा अर्पित गुणानन-बलि छे। ");
INSERT INTO dhn_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","याजक मायीन सब मानुस ओकामा सी खाय सके; चा काहना चुखलास्थान मा खाया जासे; काहकी चु घण चुखो छे। ");
INSERT INTO dhn_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","जोसो पापबलि छे तोसोज दोषबलि भी छे, हेनु दुयन एकुज व्यवस्था छे; जो पुजारा हेनु बलिक चढ़ावीन पाप ढाकीन करे त्यात् हेनु चीजक लेये। ");
INSERT INTO dhn_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","आरू जु याजक काहना क करता होमबलि क चढ़ावे उनी होमबलि पशुन खाल क त्यो पुजारो ली लेय। ");
INSERT INTO dhn_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","आरू भट्टी मा, या कढ़ाया मा, या तवा पर चुढ़लो सब अन्नबलि उनात् याजकन हुयसे जो हेको चड़ावे। ");
INSERT INTO dhn_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","आरू सब अन्नबलि, जो चाहे तेल करीन झारलो चाहे सुकलो हय, चा हारून क सब पोर्‍यान क एक समान जोड्या। ");
INSERT INTO dhn_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“मेलबलि क, जेका कुई योहोवा क करता चढ़ावे व्यवस्था यी छे: ");
INSERT INTO dhn_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","कदाम चा उका धन्यवाद क करता चढ़ाया, ते धन्यवादबलि क साथे तेल करीन चुड़ली अखमीरी पुड़ी, आरू तेल सी चुपड़ली अखमीरी रोटा, आरू तेल करीन चुड़ला मयदान क पुड़ी तेल सी भेसकला चढ़ावे। ");
INSERT INTO dhn_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","आरू चो आपनो धन्यवादवाळा मेलबलि क साथ खमीरी रोटा भी चढ़ाया। ");
INSERT INTO dhn_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","आरू ओसो एक एक चढ़ावा मा सी चा एक एक रोटो योहोवा क भेंट करीन चढ़ाया; चा मेलमिलापबलि न लुहूय क छिड़कनेवाळा पुजारान हुयसे। ");
INSERT INTO dhn_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","आरू उका धन्यवादवाळा मेलबलि क मांस बलिदान चढ़ावने क दाहड़े खादा जासे; उकामा सी काहय भी भोर तक शेष नी रया जासे। ");
INSERT INTO dhn_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","पुन कदाम बलिदान क चढ़ावो मन्नत क के स्वेच्छा क होय, ते उका बलिदन क जेके दाहड़े चो चढ़ाया जासे उके दाहड़े चो खादा जासे, आरू उका मा सी जा शेष रय जासे चो दीसरे दाहड़े भी खादा जासे। ");
INSERT INTO dhn_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","पुन जु काहय बलिदान क मांस मा सी तीसरे दाहड़े तक रय जासे तेनाक आग्ठा मा धोपाड़े जासे। ");
INSERT INTO dhn_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","आरू उकान मेलबलि क मांस मा सी कदाम काहय भी तीसरे दाहड़े खादा जासे, ते चा ग्रहण नी कर्‍या जासे, आरू नी उकान हित मा गिनियो जासे; चो घाड़्च्या काम समझा जासे, आरू जु कुई उकामा सी खादा ओधोरोम उका क मुनका पर पड़से। ");
INSERT INTO dhn_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“ओळतेन जो मांस काहना अशुद्ध चीज हाथ लागाड़े जासे चो नी खाया जासे। ओळतेन मेलबलि क मांस जोतरा शुद्ध होय चाज खाए, ");
INSERT INTO dhn_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","पुन जु अशुद्ध होईन योहोवा क मेलबलि क मांस मा सी काहय खाए चा आपना लोगहन मा सी नाश कर्‍या जासे। ");
INSERT INTO dhn_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","आरू कदाम कुई अशुद्ध चीज क हाथ लागाड़ीन योहोवा क मेलबलिपशु क मांस मा सी खाए, चा भी आपना लोगहन मा सी नाश कर्‍या जासे, चाहे चु मानुस क कुई अशुद्ध चीज या अशुद्ध पशु या कुई भी अशुद्ध आरू घाड़्च्या चीज होसे।” ");
INSERT INTO dhn_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","ओळतेन योहोवा मूसा सी कयो, ");
INSERT INTO dhn_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“इस्राएलिया सी इनीये रीतिये कय: तुमु लोगहन नी ते बुयल क काहय चरबो खानो आरू नी गाडरा निते बुकड़ी क। ");
INSERT INTO dhn_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","आरू जु पशु खुद मर जाए, आरू जु दीसरा पशु सी फाड़े जासे, ओकान चरबो दीसरा काम मा लेनो, पुन उका काहना प्रकारण सी खानो नी। ");
INSERT INTO dhn_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","जु कुई ओसो पशु क चरबो खासे जेरामा सी लोगहन काहय योहोवा क करता बलिदान करीन चढ़ाया करता छे, चो खानेवाळो आपना लोगहन मा सी नाश कर्‍या जासे। ");
INSERT INTO dhn_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","आरू तुमु आपना घर मा काहना भाँतिन क लुहूय, चाहे चिल्ला क चाहे पशु क होय, नी खानो। ");
INSERT INTO dhn_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","हर एक प्राणी जौ काहनी भाँतिन लुहूय खासे चो आपना लोगहन मा सी नाश कर्‍या जासे।” ");
INSERT INTO dhn_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","ओळतेन योहोवा मूसा सी कयो, ");
INSERT INTO dhn_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“इस्राएलिया सी ओका प्रकार कयो: जो योहोवा क करता मेलबलि चढ़ाया ची उको मेलबलि मा सी योहोवा क जु भेंट ली आया; ");
INSERT INTO dhn_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","चा आपनाज हाथ सी योहोवा क हव्य क, मतलब छाती समेत चरबो क ली आया कि छाती हालावने क भेंट करीन योहोवा क सामने हालाया जासे। ");
INSERT INTO dhn_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","आरू याजक चरबा क ते वेदी पर धोपाड़्या, पुन छाती हारून आरू ओकान पोर्‍या क होसे। ");
INSERT INTO dhn_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","आरू तुमु आपना मेलबलि मा सी डाखर्‍यु जाँग क भी उठावने क भेंट करीन याजक क आपनु; ");
INSERT INTO dhn_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","हारून क पोर्‍या मा सी जो मेलबलि क लुहूय आरू चरबा क चढ़ाया डाखर्‍यु जाँग उका क भाग होसे। ");
INSERT INTO dhn_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","काहकी इस्राएलिया क मेलमिलापबलि मा सी हालावने क भेंट क छाती आरू उठावने क भेंट क जाँग क लीन हाव ते याजक हारून आरू उकान पोर्‍योक आप्या छे कि यो हमेशा इस्राएलिया क तरफ सी उनाक हक बवनो रया। ");
INSERT INTO dhn_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","“जिन दाहड़े हारून आरू ओकान पोर्‍याक योहोवा क समीप याजक पद क करता लाया जासे ओकी दाहड़े योहोवा क बलिदान मा सी उनाक यी अभिषिक्त भाग ठराया गोया; ");
INSERT INTO dhn_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","मतलब जिन दाहड़े योहोवा उनाक अभिषेक कर्‍या उके दाहड़े ओका हुकुम देदो कि उनाक इस्राएलिया क तरफ सी या भाग नित्य जोड़े कर्‍या; उनाक पीढ़ी पीढ़ी क करता उनाक यो हक जड़ीयो गोया।” ");
INSERT INTO dhn_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","होमबलि, अन्नबलि, पापबलि, दोषबलि, याजक क संस्कार बलि, आरू मेलबलि क व्यवस्था यी छे; ");
INSERT INTO dhn_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","जव योहोवा सीनाय बोयड़ा क उजाड़ी जागा मा मूसा क हुकुम देदा कि इस्राएली मार करता काय काय चढ़ावो चढ़ायो, तव ओको उनाक यी व्यवस्था देदी हती। ");
INSERT INTO dhn_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","ओळतेन योहोवा मूसा सी कयो ");
INSERT INTO dhn_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“तू हारून आरू ओकान पोर्‍या क छिंदरा, आरू अभिषेक क तेल, आरू पापबलि क केवड़ा, आरू दुयु गाडरा, आरू अखमीरी रूटो क टुकरा क ");
INSERT INTO dhn_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","मिलापवाळा तम्बू क झोपला पर ली आया, आरू चान सब मण्डली क इकठा कर।” ");
INSERT INTO dhn_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","योहोवा क ओका हुकुम क अनसारे मूसा कर्‍या मण्डली मिलापवाळा तम्बू क झोपला पर इकठा होया। ");
INSERT INTO dhn_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","तव मूसु मण्डली सी कोया, “जो काम करनेक हुकुम योहोवा आप ददो छे चो यो छे।” ");
INSERT INTO dhn_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","ओळतेन मूसा हारून आरू हेका पोर्यान क साते ली जाईन पानी सी उंगवाळ्यो। ");
INSERT INTO dhn_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","तव ओको उनाक चौगला पेहरायो, आरू पट्टो लेपट्यो आरू धंगड़ो पांगरायो, आरू एपोद लागाड़ीन एपोद क काढ़ा होया पट्टा सी याजकन छिंदरा क बाँधीन कस देदा। ");
INSERT INTO dhn_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","आरू उका सिनाबंद लागाड़ीन सिनाबंद मा ऊरीम आरू तुम्मीम मेक देदा। ");
INSERT INTO dhn_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","तव ओको ओकान मुनका पर पागड़ी बाँधीन पागड़ी क सामने सोनान पट्टी क, मतलब पवित्र मुकुट क लागाड्या, जेका प्रकार योहोवा मूसा क हुकुम देदी हती। ");
INSERT INTO dhn_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","तव मूसु अभिषेक क तेल लीन निवास आरू जो काहय ओकामा हतो उना सब क भी अभिषेक करीन हेका चुखलो कर्‍या। ");
INSERT INTO dhn_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","आरू उका तेल मा सी काहय उनी वेदी पर सात वार छिड़कीयो, आरू आखा समान क साथ वेदी क आरू हेका ठिकरा चुखो करियो। ");
INSERT INTO dhn_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","आरू ओको अभिषेक क तेल मा सी काहय हारूनन मुनका पर न्हाखिन ओकान अभिषेक करीन ओकाह चुखलो कर्‍या। ");
INSERT INTO dhn_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","ओळतेन मूसु हारून पोर्‍याक सामने ली आवीन, अंगरखा पेरावीन, कड़ीयाम पट्टो बाँधिन ओकान मुनका पर टुपी मेक देदा, जेका प्रकार योहोवा मूसा क हुकुम देदी हती। ");
INSERT INTO dhn_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","तव त्यो पापबलिन केवड़ा क सामने ली गोया; आरू हारून आरू ओकान पोर्‍यो आपना आपना हाथ पापबलि क केवड़ा क मुनका पर मेक्या। ");
INSERT INTO dhn_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","तव चा बलि कर्‍या गोया, आरू मूसु लुहूय लीन आंगवी करीन वेदीक च्यारू सिंगळा पर लागाड़ीन चुखलो कर्‍यो, आरू लुहूय वेदी क पाय पर उंडेल देदो, आरू ओकान करता पश्चाताप करीन ओकाह चुखलो कर्‍या। ");
INSERT INTO dhn_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","आरू मूसा आतड़ा परली सब चरबी, आरू काळजा परली चरबी, आरू चरबीन क सात मा दुयु गुर्दान क लीन वेदी पर धपाड़ियो। ");
INSERT INTO dhn_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","पुन केवड़ा मा सी जो काहय वाच गयो हेको, गुबरन सात हेकी खाल आरू मांस क ओको पड़ाव सी बाहरते आग्ठा मा धोपाड़ दिदो, जेका तरह योहोवा मूसा क हुकुम देदो हतो। ");
INSERT INTO dhn_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","ओळतेन चा होमबलि क गाडरा क सामने ली गोया, आरू हारून आरू ओकान पोर्‍यो आपना आपना हाथ गाडरा क मुनका पर मेक्या। ");
INSERT INTO dhn_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","तव चा बलि कर्‍या गोया, आरू मूसु ओकान लुहूय वेदी पर चार तरफ छिड़क्या। ");
INSERT INTO dhn_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","तव गाडरा क टुकड़ा टुकड़ा कर्‍या गोयो, आरू मूसा मुनको आरू चरबीन क सात टुकड़ा क धोपाड़ दिदो। ");
INSERT INTO dhn_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","तव आतड्या आरू पाय पाणी करीन धुव्या गोया, आरू मूसु पुरा गाडराक वेदी पर धोपाड्या, आरू चा सुखदायक सुगन्ध आपने क करता होमबलि आरू योहोवा क करता बलिदान होय गोया, जेका तरह योहोवा मूसा क हुकुम देदो हतो। ");
INSERT INTO dhn_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","ओळतेन चा दीसरा गाडरा क जो अभिषकन भेंट क गाडरो हुतो सामने ली गयो, आरू हारून आरू हेका पोर्या आपसा-आपसा हाथ गाडरा क मुनका पर मेक्यो। ");
INSERT INTO dhn_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","तव चो बलि कर्‍यो गोया आरू मूसु ओकान लुहूय मा सी काहय लीन हारून डाखरे कान क मुनका पर आरू ओकान डाखरे हाथ आरू डाखरे पाय क ऊमठा पर लागाड्या। ");
INSERT INTO dhn_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","आरू चु हारून क पोर्‍याक सामने ली गोयो, आरू लुहूय मा सी काहय एक एक डाखर्‍या कान क मुनका पर आरू डाखर्‍या हाथ आरू डाखर्‍या पाय क ऊमठा पर लागाड्या; आरू मूसु लुहूय क वेदी पर चार तरफ छिड़क्या। ");
INSERT INTO dhn_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","आरू ओको चरबो, आरू चरबीदार शेमटी, आरू आतड्या परली सब चरबो, आरू कावजा परली झिल्ली समेत दुयु गुर्दा, आरू डाखर्‍या जाँग, या सब लीन अलग मेके; ");
INSERT INTO dhn_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","आरू अखमीरी रूटा क टुकरो जो योहोवा क ओगव मेकला हता ओकाम माहयलो एक रूटो, आरू तेल करीन झारलो मयदा क एक पुरी, आरू एक रूटो लीन चरबो आरू डाखर्‍या जाँग पर मेक देदा; ");
INSERT INTO dhn_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","आरू या सब चीज हारून आरू ओकान पोर्‍या क हाथ पर धर देदी गई, आरू हिलान क भेट क करता योहोवा क ओगव हालाया गोया। ");
INSERT INTO dhn_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","तव मूसा हेकेक हेनका हाथ पर सी मा लीन हेका वेदी पर होमबलि क ऊपर धोपाड्या, यो सुखदायक सुगन्द आरू यहोवान क लियन आग्ठान भेट हुती। ");
INSERT INTO dhn_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","तव मूसु छाती क लीन हिलाने क भेट क करता योहोवा क ओगव हालव्या; आरू संस्कार क गाडरा मा सी मूसा क भाग यो होयो जोसो योहोवा मूसा क हुकुम देदी हती। ");
INSERT INTO dhn_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","तव मूसु अभिषेक क तेल आरू वेदी पर लुहूय, दुयु मा सी काहय लीन हारून आरू ओकान छिंदरा पर, आरू ओकान पोर्‍याक आरू उनाक छिंदरा पर भी छिड़क्या; आरू ओकान छिंदरा समेत हारून क भी चुखलो कर्‍या। ");
INSERT INTO dhn_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","तव मुसू हारून आरू ओकान पोर्‍या सी कयो, “मांस क मिलापवाळा तम्बू क झोपला पर रांदु, आरू उका रूटा कजो संस्कार क टुकरा मा छे चो खाऊ, जोसो हाव हुकुम देदी छे कि हारून आरू ओकान पोर्‍यो ओकाह खाएँ। ");
INSERT INTO dhn_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","आरू मांस आरू रूटा मा सी जो शेष रय जाए ओका मा धोपाड़ देनु। ");
INSERT INTO dhn_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","जव तक तुमरा संस्कार क दाहड़ा पुरो नी होय तव तक, मतलब सात दाहड़े तक मिलापवाळा तम्बू क झोपला क बाहरते जानु, काहकी वा सात दाहड़े तक तुमरो संस्कार करतो रवसे। ");
INSERT INTO dhn_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","जेका प्रकार आज कर्‍या गोया छे तोसाज करने क हुकुम योहोवा देदो छे, जेका सी तुमरो पाप ढाकाय जासे। ");
INSERT INTO dhn_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","एरकरता तुमु मिलापवाळा तम्बू क झोपला पर सात दाहड़े तक ठहरे रयनु, आरू योहोवा क हुकुम क मामनु, ताकि तुमु मर नी जावु; काहकी ओसोज हुकुम मखे आपी गई छे।” ");
INSERT INTO dhn_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","तव योहोवा क इनाक सब हुकुम क अनसारे जो ओको मूसा क द्वारा देदी हती, हारून आरू ओकान पोर्‍यो कर्‍यो। ");
INSERT INTO dhn_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","आठवे दाहड़े मूसु हारून आरू ओकान पोर्‍या क आरू इस्राएली पुरानिया क बुलावीन हारून सी कयो, ");
INSERT INTO dhn_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","“पापबलि क करता एक निर्दोष गाडरा लीन योहोवा क सामने भेट चढ़ा। ");
INSERT INTO dhn_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","आरू इस्राएली सी यो कोय, तुमु पापबलि क करता एक बुकड़ो, आरू होमबलि क करता एक केवड़ो आरू एक गाडरा क बच्चो लेवु, जो एक सालन होय आरू निर्दोष होसे, ");
INSERT INTO dhn_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","आरू मेलबलि क करता योहोवा क सामने चढ़ावने क करता एक बुयल आरू एक गाडरो, आरू तेल करीन झारलो होयो मयदा क एक अनाज भेंट भी ली लेवु; काहकी आज योहोवा तुमु क दर्शन देसे।” ");
INSERT INTO dhn_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","आरू जेका जेका चीज क हुकुम मूसु देदु उना सब क चा मिलापवाळा तम्बू क ओगव ली आया; आरू सब मण्डली सामने जाईन योहोवा क सामने उबा होया। ");
INSERT INTO dhn_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","तव मूसु कयो, “यो काम छे जेका करने क करता योहोवा हुकुम देदो छे कि तुमु उकाह करू; आरू योहोवान महिमा तुमु क दुखाई पड़से।” ");
INSERT INTO dhn_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","तव मूसु हारून सी कयो, “योहोवा क हुकुम क अनसारे वेदी क सामने जाईन आपना पापबलि आरू होमबलि क चढ़ावीन आपना आरू सब जनता क करता पश्चाताप कर; आरू जनता क चढ़ावा क भी चढ़ावीन उनाक करता पश्चाताप कर।” ");
INSERT INTO dhn_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","एरकरता हारून वेदीक सामने जाईन आपना पापबलि क केवड़ा क बलिदान कर्‍या। ");
INSERT INTO dhn_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","आरू हारून क पोर्‍यो लुहूय क ओकान जु ली गोया, तव ओको आपनी आंगवी क लुहूय मा डुबाड़ीन वेदी क सिंगड़ा पर लुहूय क लागाड्या,अ आरू शेष लुहूय क वेदी क पाय पर उंडेल देदा; ");
INSERT INTO dhn_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","आरू पापबलि माहयली चरबो आरू गुर्दो आरू कावजा परली झिल्ली क ओकान वेदी पर धोपाड्या, जोसो योहोवा मूसा क हुकुम देदी हती। ");
INSERT INTO dhn_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","आरू मांस आरू खाल क ओकान पड़ाव सी बाहरते आग्ठा मा धोपाड्या। ");
INSERT INTO dhn_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","तव होमबलिपशु क बलिदान कर्‍या; आरू हारून क पोर्‍या क लुहूय क ओकान हाथ मा आप्या, आरू ओको उकाह वेदी पर चार तरफ छिड़की देदा। ");
INSERT INTO dhn_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","तव हेका होमबलिपशु क टुकड़ा टुकड़ा करीन मुनका सहित ओकान हाथ मा आप देदा आरू ओकान उनाक वेदी पर धोपाड़ देदा। ");
INSERT INTO dhn_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","आरू ओकान आतड़िया आरू पायोक धुवीन वेदी पर होमबलि क ऊपर धोपाड्या। ");
INSERT INTO dhn_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","तव ओका लोगहन क चढ़ावा क ओगव लीन आरू ओका पापबलि क बुकड़ा क जा उनाक करता हता लीन ओकान बलिदान कर्‍या, आरू पेहेल समान उकाह भी पापबलि करीन चढ़ाया। ");
INSERT INTO dhn_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","आरू ओको होमबलि क भी सामने ली जाईन विधि क अनसारे चढ़ाया। ");
INSERT INTO dhn_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","आरू अन्नबलि क भी सामने ली जाईन ओकामा सी मुठ भरीन वेदी पर धोपाड्या, यो भोर क होमबलि क बिना चढ़ायो गोयो। ");
INSERT INTO dhn_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","बयल्यो आरू गाडरा, मतलब जु मेलबलिपशु, जनता क करता हता चा भी बलि कर्‍या गोया; आरू हारूनक पोर्‍यो लुहूय क ओकान हाथ मा आप देदा, आरू उको उकाह वेदी पर चार तरफ छिड़की देदो; ");
INSERT INTO dhn_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","आरू हेका बुयल क चरबा क, आरू गाडरा मा सी चरबीदार सेमटी क, आरू जेका चरबा सी आतड़िया ढाकली रवती छे ओकान, आरू गुर्दो समेत कावजा परली झिल्ली क भी ओकान हाथ मा आप्या; ");
INSERT INTO dhn_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","आरू हेका चरबा क छाती पर मेक्या; आरू ओको चो चरबो पर धोपाड्या, ");
INSERT INTO dhn_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","पुन छाति आरू डाखर्‍यो जाँघ क हारून मूसा क हुकुम क अनसारे हिलाने क भेट क करता योहोवा क सामने हिलाया। ");
INSERT INTO dhn_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","तव हारून क लोगहन क तरफ हाथ बढ़ावीन हेका सय बरकत देदा; आरू पापबलि, होमबलि, आरू मेलबलि क चढ़ावीन चो नेड़ो उतरी आयो। ");
INSERT INTO dhn_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","तव मूसु आरू हारून मिलापवाळा तम्बू मा गोया, आरू निकाळीन लोगहन क सय बरकत देदा; तव योहोवा न महिमा सब जनता क दिखाय देदो। ");
INSERT INTO dhn_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","आरू योहोवा क सामने सी आगठो निकळे आरू चरबा समेत होमबलि क वेदी पर भस्म कर देदा; ओका देखिन जनता जय जयकार क नारा लागाड्या आरू आपना आपना मुहय क बुरसे पड़ीन दण्डवत् प्रणाम कर्‍या। ");
INSERT INTO dhn_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","तव नादाब आरू अबीहु नावन हारून क दुय पोर्‍या आपना आपना धूपदान लिदा, आरू उनामा आगठो भर्‍या, आरू हेका मा धूप न्हाखिन हेको ऊपर वाळी आग्ठी यहोवाक अर्पित करीया जेको हुकुम यहोवा आप लोन हुतो। ");
INSERT INTO dhn_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","तव योहोवा क सामने आगठो निकळे आरू उना दुयोक भस्म कर देदो, आरू चा योहोवा क सामने मर गोया। ");
INSERT INTO dhn_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","तव मूसु हारून सी कयो, “यी वात छे जेका योहोवा कयो हतो कि जो मार सामने आवे, नक्‍की छे कि चो मखे चुखलो जाने, आरू सब लोगहन क सामने म्हारी महिमा करे।” आरू हारून चुप रयो। ");
INSERT INTO dhn_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","तव मूसा हारूनन काका उज्जीएल न पोर्या, मीशाएल आरू एलसाफान क बुलायो। त्यो हेनको कयो, साते आवो, आरू तुमरा भतेरजास क चुखला जागान सामने सी हाकलीन पड़ावन बाहर ली जावो। ");
INSERT INTO dhn_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","मूसा क उकाह हुकुम क अनसारे चा नाट जाईन उनाक चौगलान सात मा हाकलीन पड़ावन बाहर ली गिया। ");
INSERT INTO dhn_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","तव मूसु हारून सी आरू ओकान पोर्‍या एलीआजार आरू ईतामार सी कयो, “तुमु लोगहन आपना मुनका झोठा मा वेरू, आरू मा आपना छिंदरा क फाडु, ओसो नी होय कि तुमु भी मर जावु, आरू इस्राएल क कुल घराना क लोगहन जा तुमरे भाईबन्धु छे योहोवान क लागाड़ली आग्ठी सी मर गिया हेनू पर विखाम रड़े। ");
INSERT INTO dhn_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","आरू तुमु लोगहन मिलापवाळा तम्बू क झोपला क बाहरते नी जानु, ओसो नी होय कि तुमु मर जावु; काहकी योहोवा ख अभिषेक क तेल तुमु पर लागाड्या छे।” मूसा क ओका वचन क अनसारे हेका कर्‍या। ");
INSERT INTO dhn_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","ओळतेन योहोवा हारून सी कयो, ");
INSERT INTO dhn_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“जव जव तू या तारा पोर्या मिलापवाळा तम्बू मा आया तव तव तुमरे मा रयीन कोय बी मोंद आरू नी काहला भातिन क शराब, के ओसो नी होय कि तुमु मर जावु; तुमरी पीढ़ी मा यी विधि चालती रये, ");
INSERT INTO dhn_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","जेका सी तुमु चुखला आरू विटुळ मा, आरू वारला आरू भुंडला न पारक कर सके, ");
INSERT INTO dhn_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","आरू इस्राएलिया क उना सब विधिया क सिखाड़ सके जेका योहोवा मूसा क द्वारा उनाक देखाड़लो छे” ");
INSERT INTO dhn_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","ओळतेन मूसु हारून सी आरू ओकान वाचला दुयु पोर्‍या ईतामार आरू एलीआजार सी भी कयो, “योहोवा क हव्य मा सी जो अन्नबलि वाचला छे उका लीन वेदी क जु बिना खमीर खाऊ, काहकी चो घण चुखी छे; ");
INSERT INTO dhn_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","आरू तुमु उका काहना पवित्रजागा मा खाऊ, चा योहोवा क हव्य मा सी तारो आरू तारा पोर्‍या क हक छे; काहकी हाव ओसोज हुकुम जोडी छे। ");
INSERT INTO dhn_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","पुन हिलाई ओसली भेट क छाती आरू उठावळी ओसी भेट क जाँघ क तुमु लोगहन, मतलब तू आरू तारा पोर्‍या-पोराय क सब काहनी शुद्ध जागा मा खाऊल काहकी चा इस्राएलिया क मेलबलि मा सी तुखे आरू तारा बच्चा क हक ठराव देदी गई छे। ");
INSERT INTO dhn_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","चरबा क हव्या समेत जी उठाई ओसी जाँग आरू हिलाई होई छाती योहोवा क सामने हिलाने क करता आव्या करसे, या भाग योहोवा क हुकुम क अनसारे हमेशा विधि क व्यवस्था सी तार जु बच्चा क करता छे।” ");
INSERT INTO dhn_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","ओळतेन मूसु पापबलि क बुकड़ा क खोजबीन कर्‍या, ते काय जोड्यो कि चो धोपाड्यो गोयो छे। एरकरता एलीआजार आरू ईतामार जु हारून क पोर्‍यो वाचला हता उना सी चा रीस मा आवीन कयने लाग्या, ");
INSERT INTO dhn_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","पापबलि जो घण चुखी छे आरू जेका योहोवा तुमुक एरकरता देदा छे कि तुमु मण्डली क ओधोरोम क भार आपसु उठावीन उनाक करता योहोवा क सामने पश्चाताप करे, तुमु ओकान मांस चुखलोजागा मा काह नी खादो? ");
INSERT INTO dhn_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","देखु, ओकान लुहूय चुखलोजागा क माहयता ते लाव्या नी गोया, पाक्को यो वारलो हुयतो कि तुमु मारा हुकुम क अनसारे ओकान मांस क चुखलाजागा मा खादा।? ");
INSERT INTO dhn_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","ओका जवाब हारून मूसा क ओका प्रकार देख्या, देख, आजुज हेका आपना पापबलि आरू होमबलि क योहोवा क सामने चढ़ाया; ओळतेन मखे पर ओसो गोरा आय पड़यो छे! एरकरता कदाम हाव आज पापबलि क मांस खाता ते काय ती वात योहोवा क सामने वारलो रवतो? ");
INSERT INTO dhn_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","जव मूसु यो सोमव्यु तव उका संतुष्ट होयु। ");
INSERT INTO dhn_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","ओळतेन योहोवा मूसु आरू हारून सी कयो, ");
INSERT INTO dhn_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","इस्राएली लोगहन सी कोय: जोतरा पशु धरती पर छे उना सभा मा सी तुमु इना जीवधारिया क मांस खाय सकता छे। ");
INSERT INTO dhn_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","पशु मा सी जोतरा चिरायला या फाटला खुर्‍या क होतला छे आरू पागुर करता छे, हेका खाय सकता छे। ");
INSERT INTO dhn_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","पुन पागुर करनेवाळा या फाटला खुर्‍यावाळा मा सी इना पशु क नी खानु, मतलब ऊटळो, जो पागुर ते करता छे पुन चिरायला खुर्‍या क नी हता, एरकरता चा तुमरे करता अशुद्ध ठरता छे। ");
INSERT INTO dhn_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","आरू मुरचीतो, जो वेगलतो ते रये पुन चिरायला खुर्‍या क नी हता, चो भी तुमरे करता विटळ छे। ");
INSERT INTO dhn_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","आरू खरहा, जु पागुर ते करता छे पुन चिरायला खुर्‍या क मी हता, एरकरता चु भी तुमरे करता विटळ छे। ");
INSERT INTO dhn_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","आरू सुवर्‍यो, जो चिरायलो मतलब फाटलो खुर्‍या क रवतो ते छे पुन पागुर नी करता, एरकरता चो तुमरे करता विटळ छे। ");
INSERT INTO dhn_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","इना मांस मा सी काहय नी खानु, आरू इनाक लोथ क हाथ भी नीलागाड़नु; यो ते तुमरे करता अशुद्ध छे ");
INSERT INTO dhn_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","ओळतेन जोतरा जलजन्तु छे उनामा सी तुमु ओका खाय सकता छे, मतलब दरिया या नदिया क जलजन्तु मा सी जोतरा क फाकळा आरू खिलपड़ा रये हेको खाय सकता छे। ");
INSERT INTO dhn_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","आरू पानी मा चरने वाला प्राणी मा सी जोतरा जीवधारि बिना फाखड़ा आरू खिलपड़ान क दरिया या नदी मा रयता छे चा सब तुमरे करता घाड़्च्या छे। ");
INSERT INTO dhn_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","त्यो तुमरे करता भुण्डलो रयसे; तुमु हेका मांस मा सी काहय बी नी खानो, आरू उना धड़ क विटुळ जानजो। ");
INSERT INTO dhn_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","जल मा जेका काहना जन्तु क फाखड़ा आरू चोंयेटे नी होता चा तुमरे करता अशुद्ध छे। ");
INSERT INTO dhn_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“ओळतेन चिल्ला मा सी इनाक अशुद्ध जाननु, या अशुद्ध होयनेन कारण खाए नी खाएँ, मतलब घुवड, हवाटीयो, वागळो, ");
INSERT INTO dhn_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","गुवड़ो, आरू भाँति-भाँति क हेवाटिया, ");
INSERT INTO dhn_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","आरू भाँति-भाँति क सब हाड़गाळा, ");
INSERT INTO dhn_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","घुबड़ीया, शुतुर्मुग, पानकुकड़ी, आरू भाँति भाँतिन शिकरे, ");
INSERT INTO dhn_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","साहळी, कागनघारो, भचकीड़ियो, ");
INSERT INTO dhn_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","बगलियो, पानकुकड़ी, घुवड़, ");
INSERT INTO dhn_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","सारस, भाँति-भाँतिन क भोगल्या, टिटवड़ी आरू वागळा। ");
INSERT INTO dhn_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“जोतरा फाखड़ावाळा कीड़ा चार पायन भुरसा पर चालता छे चा सब तुमरे करता अशुद्ध छे। ");
INSERT INTO dhn_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","पुन रेंगनेवाळा आरू फाखड़ा वाळा जा चार पायन भुरसा पर चाले, जेका धरती पर कूदने फाँदने क पांय रवता छे उनाक ते खाय सकता छे, ");
INSERT INTO dhn_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","चा या छे, मतलब भाँति भाँतिन टिड्या, भाँति भाँतिन माकनीया भाँति भाँतिन सांडीया, आरू भाँति भाँतिन टिड्या। ");
INSERT INTO dhn_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","पुन आरू सब रंगनेवाळा फाखळावाळा कीड़ा जा चार पायवाळा रवता छे चा तुमरे करता अशुद्ध छे। ");
INSERT INTO dhn_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“इनाक कारण तुमु अशुद्ध ठरसे; जेका काहना सी इनाक लोथ क हाथ लागाड़े चो सांते तक अशुद्ध ठरसे। ");
INSERT INTO dhn_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","आरू जु कुई इनाक लोथ माहयन काहय भी हाकलिया चो आपना छिंदरा धुवे आरू सांते तक अशुद्ध रवे। ");
INSERT INTO dhn_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","ओळतेन जोतरा पशु चिरायला खुर्‍या क रवता छे पुन नी ते पुरा फाटला खुर्‍या आरू नी पागुर करनेवाळा छे चा तुमरे करता अशुद्ध छे; जु कुई हेका हाथ लागाड़े चा अशुद्ध ठरसे। ");
INSERT INTO dhn_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","आरू चार पाय पर चालनेवाळा मा सी जोतरा पंजा पर चालने वाळा छे चा तुमरे करता अशुद्ध छे; जा कुई उनाक लोथ हाथ लागाड़े सांते तक अशुद्ध रया। ");
INSERT INTO dhn_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","आरू जु कुई उनाक लोथ हाकलिया चा आपना छिंदरा धुव्या आरू सांते तक अशुद्ध रया; काहकी चा तुमरे करता अशुद्ध छे। ");
INSERT INTO dhn_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“जु धरती पर रेंगता छे उनामा सी या रंगनेवाळा तुमरे करता अशुद्ध छे, मतलब अनीर, उंदरो, आरू भाँति-भाँतिन क गुरफड़ो, ");
INSERT INTO dhn_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","आरू मांदेवड़ियो, मगर, गिरवाळी, चांदनगुटीयो, आरू सेवड़ियान। ");
INSERT INTO dhn_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","सब रेंगनेवाळा मा सी याज तुमरे करता अशुद्ध छे; जा कुई इनाक लोथ क हाथ लागाड़े चा सांते तक अशुद्ध रवे। ");
INSERT INTO dhn_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","आरू इना मा सी काहना लोथ जा काहना चीज पर पड़ जाए ते चो भी अशुद्ध ठरसे, चाहे चो काठ क कुई पात्र होसे, चाहे छिंदरा, चाहे खाल, चाहे काहनो काम क कोसो भी पात्र आदि काह नी होय; तेनाल जल मा न्हाखे जासे, आरू सांते तक अशुद्ध रवे, तव शुद्ध समझे जासे। ");
INSERT INTO dhn_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","आरू कदाम धुवा क कुई पात्र होसे जेकामा इना जन्तु मा सी कुई पड़े, ते उका पात्रा मा जो काहय होसे चो अशुद्ध ठरसे, आरू पात्रा क तुमु तुड़ न्हाखजु। ");
INSERT INTO dhn_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","ओकामा जो खाने क योग्य खानो होये, जेकामा पाणी क छिमिया होय चा सब अशुद्ध ठरसे; ओळतेन कदाम ओसो पात्रा मा पानी क करता काहय होय ते चो भी अशुद्ध ठरसे। ");
INSERT INTO dhn_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","आरू कदाम इनाक लोथ मा काहय तंदुर या चूल्हा पर पड़े ते चा भी अशुद्ध ठरसे, आरू तुड़ न्हाखजे; काहकी चो अशुद्ध होय जासे, चो तुमरे करता भी अशुद्ध ठरसे। ");
INSERT INTO dhn_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","पुन सोता या तवाव जेकामा पाणी एकठो होये चो ते शुद्ध रवे; पुन जो कुई इनाक लोथ क हाथ लागाड़े ते चो अशुद्ध ठरसे। ");
INSERT INTO dhn_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","आरू कदाम इनाक लोथ मा काहय काहना प्रकार क बीज पर जा वेरने क करता से पड़ला, ते चा बीज शुद्ध रवे; ");
INSERT INTO dhn_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","पुन कदाम बीज पर पाणी न्हाखला होसे आरू पछव लोथ माहयलो काहय उका पर पड़ जाए, त ");
INSERT INTO dhn_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","ते जु कुई उनाक लोथ क हाथ लागाड़े ते चो सांते तक अशुद्ध रवे। ");
INSERT INTO dhn_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","आरू ओकान लोथ मा सी जु कुई काहय खाए चु आपना छिंदरा धुवे आरू सांते तक अशुद्ध रवे; आरू जु कुई ओकान लोथ उठावे तेनाक भी आपना छिंदरा धुवे आरू सांते तक अशुद्ध रवे। ");
INSERT INTO dhn_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“सब प्रकार क धरती पर रेंगनेवाळा जन्तु घिनौना छे; चा खादो नी जासे। ");
INSERT INTO dhn_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","धरती पर सब रेंगनेवाळा मा सी जोतरा पेट या चार पाय पर चालता छे, या जास्ती पायवाळा रवता छे, हेका तुमु नी खानु; काहकी चा घिनौना छे। ");
INSERT INTO dhn_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","तुमु काहना प्रकार क रेंगनेवाळा जन्तु क द्वारा आपने आपसु क घिनौनो काम नी करनु; आरू नी ओकान द्वारा क अशुद्ध करीन विटुळ ठरनु। ");
INSERT INTO dhn_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","काहकी हाव तुमरू परमेश्वर योहोवा छेव; ओका कारण आपनु क शुद्ध करीन चुखला बवना रवु, काहकी हाव चुखलु छे। एरकरता तुमु काहना प्रकार क रेंगनेवाळा जन्तु क द्वारा जा धरती पर चालता छे आपने आपसु क अशुद्ध नी करनु। ");
INSERT INTO dhn_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","काहकी हाव चु योहोवा छेव जु तुमुक मिस्र देश सी एरकरता निकाळीन ली आयु छे, कि तुमरू परमेश्वर कहवायो; एरकरता तुमु चुखा बनु, काहकी हाव चुखो छे।” ");
INSERT INTO dhn_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","पशु, क चिल्ला, आरू सब जलचर प्राणी, आरू धरती पर सब रेंगनेवाळा प्राणी क बारा मा यी व्यवस्था छे, ");
INSERT INTO dhn_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","के शुद्ध अशुद्ध आरू भक्ष्य आरू अभक्ष्य जीवधारिया मा भेद कर्‍या जासे। ");
INSERT INTO dhn_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","पछु योहोवा भगवान मूसा सी कयो, ");
INSERT INTO dhn_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“इस्राएलिया सी कोया: जी बायर पेट सी होईन पोर्‍याक जन्म देती छे ते ची सात दाहड़े तक अशुद्ध रवसे; जोसो ची ऋतुमती होईन अशुद्ध रया करती। ");
INSERT INTO dhn_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","आरू आठवे दाहड़े पोर्‍या क चामड़ी काटी चुखो करे। ");
INSERT INTO dhn_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","पछी ची बायर आपना शुद्ध करनेवाळा रूधिर मा तैतीस दाहड़ा रवे; आरू जव तक उकाह शुद्ध होयनेन दाहड़ा पुरा नी होय तव तक ची नीते काहनी चुखली चीजक हाथ लागाड़े, आरू नी चुखली जागा मा जाया करे। ");
INSERT INTO dhn_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","आरू कदाम हेकी पोराय पयदा होई, ते उकाह ऋतुमती क सी अशुद्ध चोवदे दाहड़ान लागी; आरू पछा छियासठ दाहड़ा तक आपना शुद्ध करनेवाळा रूधिर मा रया। ");
INSERT INTO dhn_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“जव हेकी शुद्ध होय जानेन दाहड़ा पूरा होय, तव चाहे हेकी पोर्‍यो होय या पोराय, चो होमबलि करता एक साल क गाडरा क बच्चो, आरू पापबलि क करता कबूतरी क एक पिल्लो, या पण्डुकी मिलापवाळा तम्बू क झोपला पर याजक क जु लाया। ");
INSERT INTO dhn_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","तव याजक उकाह योहोवा क सामने भेंट चढ़ावीन उकान करता पश्चाताप करे; आरू चा आपना रूधिर क वहयनेन अशुद्धता सी छुड़ीन शुद्ध ठरसे। जीन बायरन पोर्‍यो या पोराय पयदा होय उकान करता यी व्यवस्था छे। ");
INSERT INTO dhn_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","आरू कदाम उकान जु गाडरो या बुकड़ी आपनेन पुंजी नी होय, ते आप पण्डुकी या कबूतरी क दुय पिल्ला, एक ते होमबलि आरू दिसरा पापबलि क करता आप; आरू याजक उकान करता पश्चाताप करे, तव ची शुद्ध ठरसे।” ");
INSERT INTO dhn_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","ओळतेन योहोवा मूसु आरू हारून सी कोया, ");
INSERT INTO dhn_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“जव काहना मानुस क डिल क चामड़ा मा सूजलो या फुलो या दाग होसे, आरू ओका हारूनसी ओका चामड़ा मा कोढ़ क जु या ओकान पोर्‍यो जो याजक छे उना मा सी काहना क जु ली जाएँ। ");
INSERT INTO dhn_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","जव याजक उकान चामड़ा क दाग क देख्या, आरू कदाम उका व्‍याधि क जागे रयने आरू कुड़ सी घण जादा देख पड़े, ती त्यो जान जाय कि कुढ़न टेम छे आरू पुजारो हेको देखीन विटुळ बना। ");
INSERT INTO dhn_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","पुन कदाम चो दाग उकान चामड़ा मा उजव्यो ते होसे, पुन चामड़ा सी उंडो नी देख पड़े, आरू नी चा वाळा रोवड़ा विजावो होय गोया छे, ते याजक ओकाम सात दाहड़े तक बन्द कर देदा; ");
INSERT INTO dhn_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","आरू सातवे दाहड़े याजक ओकाह देख्या, आरू कदाम ची दाग जोसी तोसी बोवनी रवे आरू ओकान चामड़ा मा नी पसरी छे, ते याजक ओकाह आरू भी सात दाहड़े तक बन्द कर देदा; ");
INSERT INTO dhn_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","आरू सातवे दाहड़े याजक ओकाह ओळतेन देख्या, आरू कदाम देख पड़े कि दाग क चमक कम छे आरू दाग क चामड़ा पर पसरी नी होसे, ते याजक ओकाह शुद्ध ठरावे; काहकी ओकाह ते चामड़ा मा पापड़ी छे; आरू चा आपना छिंदरा धुवीन शुद्ध होय जाए। ");
INSERT INTO dhn_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","पुन कदाम याजक क उका जाँचन बाद जेकामा चो शुद्ध ठरायो होयो हतो, ची फुलो उकान चामड़ा पर बैस पसरी गोया, ते पछा चा याजक क देखाड़े जासे; ");
INSERT INTO dhn_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","आरू कदाम याजक क देख पड़े कि पापड़ी चामड़ा मा पसरी गई छे, ते चा ओकान अशुद्ध ठराया; काहकी चो कुढुज छे। ");
INSERT INTO dhn_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“कदाम कोढ़ क सी दाग काहनु मानुस क होसे, ते चो याजक क जु पुगाड्या जासे; ");
INSERT INTO dhn_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","आरू याजक ओका देख्यु, आरू कदाम ची सूजन ओकान चामड़ा मा उजवी होसे, आरू ओकान कारण रोवड़ा भी विजावो होय गोयो होसे, आरू उका सूजन मा बिना चामड़ा क मांस होसे, ");
INSERT INTO dhn_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","ते याजक जाने कि ओकाह चामड़ा मा जुन्लो कोढ़ छे, एरकरता चो ओकाह अशुद्ध ठराया; आरू बन्द नी राख्या, काहकी चो अशुद्ध छे। ");
INSERT INTO dhn_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","आरू कदाम कोढ़ काहना क चामड़ा सी फूटीन या तक पसरी जाएँ, कि जा का याजक देख्या रोगी क मुनका सी पाय तवे तक कोढ़ नी सब चामड़ो पुरो कर लेदा होसे, ");
INSERT INTO dhn_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","ते याजक ध्यान सी देखे, आरू कदाम कोढ़ ओका सब डिलक क पर पसरी गयो होसे, ते यो ओका मानसक शुद्ध ठराया; आरू ओकान डिल जो बिलकुल विजावो होय गोयो छे चा शुद्ध ठहरे छे। ");
INSERT INTO dhn_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","पुन जव ओकामा चामड़ाम मांस देख पड़े, तव चो अशुद्ध ठरसे। ");
INSERT INTO dhn_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","आरू याजक चामड़ा मांस क देखिन ओकाह अशुद्ध ठरे; काहकी तोसो चामड़ा मांस अशुद्ध रवतो छे; चो कोढ़ छे। ");
INSERT INTO dhn_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","पुन कदाम चो चामड़ो मांस ओळता विजावो होय जासे, ते चु मानुस याजक क जु जाए, ");
INSERT INTO dhn_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","आरू याजक ओकाह देखे, आरू कदाम चो दाग ओळता विजावो होय गोयो छे, ते याजक रोगी क शुद्ध जाने; चो शुद्ध छे। ");
INSERT INTO dhn_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“ओळतेन कदाम काहना चामड़ा मा फुड़ा होईन वारला होय गोया छे, ");
INSERT INTO dhn_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","आरू फुड़ा क जागा मा विजावा सी सूजलो या लाली करता विजावो दाग होसे, ते चो याजक क देखाड़े जासे; ");
INSERT INTO dhn_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","आरू याजक ओका सुजला क देखे, आरू चा चामड़ा सी उंडो देखाय पड़े, आरू ओकान रोड़े भी विजावा हो गोया छे, ते याजक यो जानीन उका मानसक अशुद्ध ठराया; काहकी चो कोढ़ क दाग छे फुड़ा मा सी फुटिन निकळी छे। ");
INSERT INTO dhn_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","पुन कदाम याजक देखे कि उकामा विजावा रोया नी छे, आरू चो चामड़ा सी उंडो नी, आरू ओकान चमक कम होई छे, ते याजक उका मानसक सात दाहड़े तक बनन्द कर राखे; ");
INSERT INTO dhn_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","आरू कदाम त्यो दाग उके टेमे तक चमड़ा मा सचमुच पसरी जाए, ते याजक उका मानस क अशुद्ध ठरसे; काहकी त्यो कोढ़ क दाग छे। ");
INSERT INTO dhn_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","पुन कदाम त्या दाग नी पसरे आपना जागा पर बोवना रया, ते त्या फुड़ाक दाग छे; याजक उका मानस क शुद्ध ठरसे। ");
INSERT INTO dhn_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“ओळता कदाम काहना क चामड़ा मा धोपड़ेन घाव होसे, आरू उका धोपला घाव मा चामड़ा बिना दाग लाली करता होया विजावो या विजावोज होय जाए, ");
INSERT INTO dhn_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","ते याजक ओकाह देखे, आरू कदाम उका दाग मा रोया विजवा होय गोया होसे आरू त्यो चामड़ा सी जादी देखाय पड़े, ते चा कोढ़ छे; जो उकाह धोपला दाग मा सी फूट निकळ्या छे; याजक उका मानस क अशुद्ध ठराया; काहकी ओका मा कोढ़ क व्‍याधि छे। ");
INSERT INTO dhn_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","पुन कदाम याजक देखे कि दाग मा विजावा दाग रोया नी आरू नी त्या चामड़ा सी काहय उंडा छे, आरू उकान चमक मक होई छे, ते त्यो ओकाह सात दाहड़े तक बन्द कर राखे, ");
INSERT INTO dhn_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","आरू सातवे दाहड़े याजक क ओको देख्या, आरू कदाम चो चामड़ा मा पसरी गई होसे, ते चो उका मानस क अशुद्ध ठराया; काहकी ओकाह कोढ़ क दाग छे। ");
INSERT INTO dhn_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","पुन कदाम चा दाग चामड़ा मा नी पसर्‍या आरू आपना जागा परूज जा का ताह बवनो होसे, आरू ओकान चमक कम होई होसे, ते चो धोपाय जाने क कारण सूजलो छे, याजक उका मानस क शुद्ध ठराया; काहकी चो दाग धोपने क कारण सी छे। ");
INSERT INTO dhn_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“ओळतेन कदाम काहना मानुस या बायर क मुनका पर, या मानस क दाढ़ी मा दाग होसे, ");
INSERT INTO dhn_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","ते याजक दाग क देख्या, आरू कदाम चप चामड़ा सी उंडो देखाय पड़े, आरू उकामा भूरला-भूरला पातवा झोठा होसे, ते याजक उका मानस क अशुद्ध ठराया; चो दाग सी खवड़ु, मतलब मुनका या दाढ़ी क कोढ़ छे। ");
INSERT INTO dhn_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","आरू कदाम याजक सी होयतो व्‍याधि क देखे कि चो चामड़ा सी उंडो नी छे आरू उकामा काळ्ळा-काळ्ळा झोठा नी छे, ते चा सेंहुआ बेमार्‍या क सात दाहड़े तक बन्द कर राख्या, ");
INSERT INTO dhn_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","आरू सातवे दाहड़े याजक दाग क देख, तव कदाम चा सेंहुआ पसर्‍यो नी होसे, आरू उकामा भूरला-भूरला झोठा नी होसे, आरू सेंहुआ चामड़ा सी उंडो नी देख पड़े, ");
INSERT INTO dhn_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","ते यो मानुस मूँड़ाय ते जासे; पुन जा सेंहुआ होसे चा नी मूँड़ाय ते जासे; आरू याजक उका सेंहुआवाळा क आरू भी सात दाहड़े तक बन्द करे; ");
INSERT INTO dhn_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","आरू सातवे दाहड़े याजक सेंहुआ क देखे, आरू कदाम चा सेंहुआ चामड़ा मा पसर्‍यु नी होसे आरू चामड़ा सी उंडा नी देखाय पड़े, ते याजक उका मानस क शुद्ध ठराया; आरू चा आपना छिंदरा धुवीन शुद्ध ठरसे। ");
INSERT INTO dhn_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","पुन कदाम ओकान शुद्ध ठरने क पश्चाताप सेंहुआ चामड़ा मा काहय भी पसरे, ");
INSERT INTO dhn_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","ते याजक ओका देखे, आरू कदाम चा‍मड़ा मा पसर्‍यो होसे, ते याजक भूरला झोठा नी हेरे; काहकी चो मानुस अशुद्ध छे। ");
INSERT INTO dhn_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","पुन कदाम ओकान नजर मा चा सेंहुआ जोसाज तोसो बवनो होसे, आरू ओकामा काळ्ळा झोठा जमला होसे, ते चा जाने कि सेंहुआ वारला होय गोया छे, आरू चो मानुस शुद्ध छे; याजक उकाह शुद्ध ठरजे। ");
INSERT INTO dhn_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“औळतेन कदाम काहना मानस क या बायर क चामड़ा मा उजला दाग होसे, ");
INSERT INTO dhn_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","ते याजक देखे, आरू कदाम ओकान चामड़ा मा चा दाग कम उजला होसे, ते चा जाने क ओकान चामड़ा मा निकळली दाद छे; चो मानुस शुद्ध ठरजे। ");
INSERT INTO dhn_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“ओळतेन जेका मुनका क झोठा झड़ गोया छे, ते जाननु कि चो ते टकलो ते छे पुन शुद्ध छे। ");
INSERT INTO dhn_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","आरू जेका मुनका क ओगला झोठा झड़ गोया छे, ते चो निंडावा क चन्दुला ते छे पुन शुद्ध छे। ");
INSERT INTO dhn_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","पुन कदाम चन्दुला मुनका पर या चन्दुला निंडावा पर लाली लीन उजली दाग होसे, ते जाननु कि चा उकान चन्दुला मुनका या चन्दुला निंडावा पर निकळयो होयो कोढ़ छे। ");
INSERT INTO dhn_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","एरकरता याजक ओका देख्या, आरू कदाम दाग क सूजन ओकान टकलो मुनको या निंडावा पर ओसी लाली करता उजली होसे जोसो चामड़ा क कोढ़ मा हतला छे, ");
INSERT INTO dhn_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ते चु मानुस कढ़ावाळो छे आरू अशुद्ध छे; आरू याजक ओकान नक्की अशुद्ध ठराया; काहकी ची दाग ओकान मुनका पर छे। ");
INSERT INTO dhn_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“जेका मा ची दाग होसे उका कोढ़ा क छिंदरा फाटला आरू मुनका क झोठा सुटला रया, आरू चा आपना ऊपरवाळा उठ क ढापीन अशुद्ध, अशुद्ध आयड्या करे। ");
INSERT INTO dhn_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","जोतरा दाहड़ा तक चा दाग ओका मा रया ओतरा दाहड़ा तक चा अशुद्ध ठरला रया; एरकरता चु एकलु रया करे, ओकान निवास स्थान क छावनी क बाहरता छे। ");
INSERT INTO dhn_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“ओळतेन जेका छिंदरा मा कोढ़ क दाग होसे, चाहे चा छिंदरा रूई क होसे चाहे झारली क, ");
INSERT INTO dhn_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ची दाग चाहे उका झारली या ऊनन छिंदरा क सिवलो मा हय चाहे गुथलो हय, या त्यो दाग चामड़ा मा या चामड़ा क बोवनी काहनी चीज मा हय, ");
INSERT INTO dhn_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","कदाम त्यो दाग काहला छिंदराम चाहे सिवला मा चाहे गुथला मा, या चामड़ा मा या चामड़ान काहली चीज मा निव्ळो हय या लाल सी हय, ती जानजी कि त्यो दाग छे आरू त्यो पुजारान जक देखाड़े। ");
INSERT INTO dhn_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","आरू याजक क देख, आरू दागवाळी चीज क सात दाहड़ान करता बन्द करे; ");
INSERT INTO dhn_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","आरू सातवे दाहड़े चु उका दाग क देखे, आरू कदाम चा छिंदरा क चाहे ताने मा चाहे बाने मा, या चामड़ा मा या चामड़ा क बवनी काहनी चीज मा पसरी गई होसे, ते जाननु कि दाग क गलति कोढ़ छे, एरकरता ची चीज, चाहे काहनी काम मा काह नी आवती होसे, तेभी अशुद्ध ठरसे। ");
INSERT INTO dhn_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","चु उका छिंदरा क ताने या बाने मा ची दाग होसे, चाहे चा ऊनन क होसे चाहे सनी क, या चामड़ा क होसे; उकाह धोपाड़ दे, ची दाग गळनियो कुढ़न छे; हेनी चीज क आग्ठा मा धोपाड़ देनो जुळे। ");
INSERT INTO dhn_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“कदाम याजक देखे कि त्यो दाग उना छिंदरान कुना मा या वीच मा, या चामड़ान क उनी चीज मा नी पसरी, ");
INSERT INTO dhn_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","ते जेका चीज मा दाग होसे ओकान धोने क आदेश आप, तव उका आरू भी सात दाहड़े बन्द कर राखे; ");
INSERT INTO dhn_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","आरू उकाह धोने क बाद याजक ओकाह देखे, आरू कदाम दाग क नी ते रंग बदल्यो होसे, आरू नी दाग पसरी होसे, ते जाननु कि चो अशुद्ध छे; उकाह आग्ठा मा धोपाळनु, काहकी चाहे चा दाग माहयता चाहे ऊपरली होसे तेभी ची खाने वाळी दाग छे। ");
INSERT INTO dhn_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","पुन कदाम याजक देखे कि ओकाह धोने क बाद दाग क चमक कम होय जासे, ते चा उकाह छिंदरा क चाहे ताने चाहे बाने मा सी, या चामड़ा मा सी फाड़ीन निकळे; ");
INSERT INTO dhn_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","आरू कदाम ची दाग तव भी उका छिंदरा क ताने या बाने मा, या चामड़ा क उका चीज मा देखाय पड़े, ते जाननु कि ची फुटीन निकळी दाग छे; आरू जेका मा ची दाग होसे ओका आग्ठा मा धोपाड़नु। ");
INSERT INTO dhn_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","कदाम हेका छिंदरा या चामड़ान काहय बी चीज हय जेको छुवने सी दाग जात रये, ती त्यो दिसरी वार धुळायीन चुको हये।” ");
INSERT INTO dhn_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","ऊनन या सुवाळा छिंदरान कुना मा या काहा बी या चामड़ान काहली बी चीज मा जो कुढ़न दाग हय हेको चुखो करनेन योत् नियम छे। ");
INSERT INTO dhn_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","ओळतेन योहोवा मूसा सी कयो, ");
INSERT INTO dhn_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","कोढ़ क चुखो करनेन नियम यो छे। त्यो पुजारान याँ जाय; ");
INSERT INTO dhn_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","आरू पुजारो छावनी क बाहरते जासे, आरू याजक उका कोढ़ क देखे, आरू कदाम उका कोढ़ क दाग वारली होई होसे, ");
INSERT INTO dhn_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","ते याजक आदेश देदो कि शुद्ध ठरावनेवाळा क करता दुय शुद्ध आरू जीवता चिल्ला, देवदारू क लाकड़ी, आरू लाल रंग क छिंदरा आरू जूफा या सब क करता जासे; ");
INSERT INTO dhn_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","आरू याजक आदेश आप कि एक चिल्ला वोहयता पाणी क ऊपर धुवा क ठिकरा मा बलि कर्‍या जासे। ");
INSERT INTO dhn_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","तव चो जीवतो चिल्ला क देवदारू क लाकड़ो आरू रंग क छिंदरा आरू जूफान इना सब क लीन एक संग उका चिल्ला क लुहूय मा जो वोहयतो पाणी क ऊपर बलि करे; ");
INSERT INTO dhn_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","आरू कोढ़ सी शुद्ध ठरावनेवाळा पर सात वार छिड़कीन ओकाह शुद्ध ठराया, तव उका जीवता चिल्ला क मैदान मा छुड़ दे। ");
INSERT INTO dhn_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","आरू शुद्ध ठरावनेवाळा आपना छिंदरा क धुवे, आरू सब झोठा काडाळीन पाणी सी उंगव्या उंगळी लेय, तव चा शुद्ध ठरसे; आरू ओकान बाद चा पड़ावा मा आवनु जुवे, पुन सात दाहड़े तक आपना डेरा सी बाहरते रया। ");
INSERT INTO dhn_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","आरू सातवे दाहड़े त्यो मुनको, दाढ़ी आरू काखेन सब झोठा बुड़ाय देय, आरू सब अंग काडाड्या, आरू आपना छिंदरा क धुव्या, आरू पाणी सी उंगवी करे, तव चा शुद्ध ठरसे। ");
INSERT INTO dhn_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","आठवें दाहड़े त्या दुय निर्दोष गाडरा क बच्चें, आरू अन्नबलिन करता तेल करीन झारलो एपा पाँच किलो मैदा, आरू आधा लिटर तेल लावे। ");
INSERT INTO dhn_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","आरू शुद्ध ठरावनेवाळा याजक इना चीज क समेत उका शुद्ध होयनेवाळा मानस क योहोवा क सामने मिलापवाळा तम्बू क झोपला पर उबा करे। ");
INSERT INTO dhn_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","तव याजक एक गाडरा क बच्चा लीन दोषबलि क करता उका आरू लोज भर तेल क सामने लाया, आरू इना दुयु क हालावने क भेंट क करता योहोवा क सामने हालाया; ");
INSERT INTO dhn_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","आरू चा उका गाडरा क बच्चा क उका जागा मा जा चा पापबलि आरू होमबलि पशु क बलिदान कर्‍या करसु, मतलब चुकलास्थान मा बलिदान करे; काहकी जोसा पापबलि याजक क निज भाग होसे जोसाज दोषबलि भी उका जियोन भाग ठरसे; चो परमपवित्र छे। ");
INSERT INTO dhn_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","तव याजक दोषबलि क लुहूय मा सी काहय लीन शुद्ध ठरावनेवाळा क डाखर्‍या कान क मुनका पर, आरू ओकान डाखर्‍या हाथ आरू डाखर्‍या पाय क आंगठा पर लाया। ");
INSERT INTO dhn_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","तव याजक उका लोज भर तेल मा सी कहाय आपना जेवड़ा हाथ क थोवती पर न्हाखे, ");
INSERT INTO dhn_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","आरू याजक आपना डाखर्‍या हाथ क आंगवी क आपनी जेवड़ी थोवती परली तेल मा डुबाड़ीन उका तेल मा सी काहय आपनी आंगवी करीन योहोवा क सामने सात वार छिड़के। ");
INSERT INTO dhn_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","आरू जो तेल उकान थोवती पर रय जासे याजक ओकामा सी काहय शुद्ध होयनेवाळा क डाखर्‍या कान क मुनका पर आरू ओकान डाखर्‍या हाथ आरू डाखर्‍या पाय क आंगठा पर दोषबलि लीन लुहूय क ऊपर लागाड्या; ");
INSERT INTO dhn_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","आरू जो तेल याजक क थोवती पर रय जाए ओकान चो शुद्ध होयनेवाळा क मुनका न्हाख दे। आरू याजक ओकान करता योहोवा क सामने पश्चाताप करे। ");
INSERT INTO dhn_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","याजक पापबलि क भी चढ़ावीन करता जा आपनी अशुद्धता सी शुद्ध होयनेवाळा पशु क बलिदान करीन: ");
INSERT INTO dhn_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","अन्नबलि समेत वेदी पर चढ़ाया: आरू याजक ओकान करता पश्चाताप करे, आरू चा शुद्ध ठरसे। ");
INSERT INTO dhn_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","पुन कदाम चो दारिद्र होसे आरू ओतरो लावने क करता ओका जु पूंजी नी होसे, ते चा आपना पश्चाताप करावने क करता, हालावने क करता गाडरा क बच्च दोषबलि क करता, आरू तेल सी झारला एपा क एक किलो मैदा अन्नबलि करीन, आरू 300 ग्राम तेल लावे; ");
INSERT INTO dhn_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","आरू दुय हुली, या पेरवान दुय पीला लावे, जा चा लाय सक्या; आरू इनामा सी एक ते पापबलि क करता आरू दीसरा होमबलि क करता होसे। ");
INSERT INTO dhn_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","आरू आठवे दाहड़े चा इना सभां क आपना शुद्ध ठरावने क करता मिलापवळा तम्बू क झोपला पर योहोवा क सामने, याजक क जु ली आया; ");
INSERT INTO dhn_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","तव याजक उका लोज भर तेल आरू दोषबलि गाडरा क बच्चा क लीन हालावने क भेंट क करता योहोवा क सामने हालाया। ");
INSERT INTO dhn_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","ओळता दोषबलि क गाडरा क बच्चा क बलिदान कर्‍या जासे; आरू याजक ओकान लुहूय मा सी काहय लीन शुद्ध ठरावनेवाळा क डाखर्‍या कान क मुनका पर, आरू ओकान डाखर्‍या हाथ आरू डाखर्‍या पाय क आंगठा पर लागाड्या। ");
INSERT INTO dhn_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","ओळता याजक उका तेल मा सी काहय आपना जेवड़ा हाथ क थोवती पर न्हाखिन, ");
INSERT INTO dhn_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","आपना डाखर्‍या हाथ क आंगवी सी आपनी जेवड़ी थोवती पर तेल मा सी काहय योहोवा क सामने सात वार छिड़के; ");
INSERT INTO dhn_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","ओळता याजक आपनी थोवती पर तेल मा सी काहय शुद्ध ठरावनेवाळा क डाखर्‍या कान क मुनका पर, आरू ओकान डाखर्‍या हाथ आरू पाय क आंगठा पर, दोषबलि क लुहूय क जागा पर लागाड्या; ");
INSERT INTO dhn_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","आरू जो तेल याजक क थोवती पर रय जाए उका चा शुद्ध ठरावनेवाळा क करता योहोवा क सामने पश्चाताप करने क उकान मुनका पर न्हाख दे। ");
INSERT INTO dhn_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","तव चा पंडुक या बच्चा मा सी जो चु लाय सक्या होसे एक क चढ़ाया, ");
INSERT INTO dhn_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","जो चिल्लोन कत्यो लाय सके, उनामा सी एक क पापबलिन करता आरू अन्नबलि समेत दीसरा क होमबलिन करता चढ़ाया; ओका रीति सी याजक शुद्ध ठरावनेवाळा क करता योहोवा क सामने पश्चाताप करे। ");
INSERT INTO dhn_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","जेका कोढ़ क व्‍याधि होई होसे, आरू ओकान ओतरी पूंजी नी होसे कि चा शुद्ध ठरावनेवाळा क करता योहोवा क सामने पश्चाताप करने क ओकान मुनका पर न्हाख दे। ");
INSERT INTO dhn_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","ओळता योहोवा मूसु आरू हारून सी कयो, ");
INSERT INTO dhn_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“जव तुमु लोगहन कनान देश मा पुगु, जेका हाव तुमरी निज धरती होयने क करता तुमुक आपता छे, उका टेमे कदाम हाव कोढ़ क दाग तुमरा हक क काहना घर मा देखाडो, ");
INSERT INTO dhn_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ते जेका चो घर होसे चा आवीन याजक क कोय दे कि मखे ओसो देखाड़ पड़ता छे कि घर मा मानु काहनो दाग छे। ");
INSERT INTO dhn_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","तव याजक आदेश देदो कि उका घर मा दाग देखने क करता म्हार जाने क पेहेल उका खाली करो, के ओसो नी होय कि जो काहय घर मा होसे चो सब अशुद्ध ठरसे; आरू पछव याजक घर देखने क करता माहयता जाए। ");
INSERT INTO dhn_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","तव चो उकाह दाग क देखे; आरू कदाम ची दाग घर क भितड़ा पर निळ्ळा-निळ्ळा या लाल लाल मानु कुरलो ओसो लकीरे क रूप मा होसे, आरू या लकीरे भितड़ा मा उंडी देखाय पड़ती होसे, ");
INSERT INTO dhn_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","ते याजक घर सी बाहरते झोपला पर जाईन घर क सात दाहड़े तक बन्द कर राखे। ");
INSERT INTO dhn_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","आरू सातवे दाहड़े याजक देखे; आरू कदाम चो दाग घर क भितड़ा पर पसरी गई होसे, ");
INSERT INTO dhn_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","आरू चा घर सी बाहरते काहना अशुद्ध स्थान मा न्हाख दे; ");
INSERT INTO dhn_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","आरू चा घर क माहयता चार तरफ खुरचवाए, आरू ची खुरचन क धुवा नगर सी बाहरते काहना स्थान मा न्हाखे जासे; ");
INSERT INTO dhn_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","आरू उना दगड़ा क जागा मा आरू दीसरा दगड़ा लीन लगाड़े आरू त्या ताजा गारा लीन घरन जुड़ाई करे। ");
INSERT INTO dhn_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“कदाम दगड़ा क निकाळने आरू घर क खुरचने आरू गारा जुड़ाई आरू लिपायन बाद चा दाग ओळता घर मा फुट निकळे, ");
INSERT INTO dhn_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","ते याजक आवीन देख; आरू कदाम ची दाग घर मा पसरी गई होसे, ते चा जान लेवु कि घर मा गलति कोढ़ छे; चो अशुद्ध छे। ");
INSERT INTO dhn_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","आरू चा सब गारे समेत दगड़ा, लाकड़ा आरू घर क खोंदाड़ीन पड़ दे; आरू उना सब चीज क उठावीन नगर सी बाहरते काहना अशुद्ध जागा पर न्हखड़ दे। ");
INSERT INTO dhn_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","आरू जव तक चो घर बन्द रये आरू कदाम कुई उका मा जाए ते चे सांतो तक रये; ");
INSERT INTO dhn_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","आरू जो कुई उका घर मा सुवे चो आपना छिंदरा क धुवे; आरू जु कुई उका घर मा खानो खादा चु भी आपना छिंदरा धवे। ");
INSERT INTO dhn_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“पुन कदाम पुजारो आवीन देखे कि जव सी घर लेसला गोया छे तव सी उकामा दाग नी पसरे छे, ते यो जानीन कि ची दाग सेठी होय गोय छे, घर क शुद्ध ठराया। ");
INSERT INTO dhn_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","आरू उका घर क चुखलो करने क करता दुय चिल्ला, देवदारू क लाकड़ी, लाल रंग क छिंदरा आरू जूफा लाया, ");
INSERT INTO dhn_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","आरू एक चिल्लो वोहयतो वोहयता पाणीन ऊपर धुळान ठिकरा मा बलिदान करे, ");
INSERT INTO dhn_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","तव चो देवदारू क लाकड़ी, लाल रंग क छिंदरा आरू जूफा आरू जीवता चिल्ला इना सभा क लीन बलिदान करला चिल्ला क लुहूय मा आरू उहवता पाणी मा बुड़ाळ देदा, आरू उका घर पर सात वार छिड़क्या। ");
INSERT INTO dhn_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","ओका प्रकार चा चिल्लो लुहूय, आरू वोहयतो पाणी, आरू जीवता चिल्ला, आरू देवदारू क लाकड़ी, आरू जूफा आरू लाल रंग क छिंदरा क झोपला क घर क चुखलो करे; ");
INSERT INTO dhn_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","तव चा जीवता चिल्ला क नगर सी बाहरता मैदान मा छुड़ देदा; ओका रीति सी चो घर क करता पश्चाताप करे, तव चो शुद्ध ठरसे।” ");
INSERT INTO dhn_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","सब भाँति क कोढ़ क दाग, आरू सेंहुए, ");
INSERT INTO dhn_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","आरू छिंदरा, आरू घर क कोढ़ ");
INSERT INTO dhn_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","आरू सूजलो, आरू खुलसा, आरू दाग क विषय मा, ");
INSERT INTO dhn_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","शुद्ध आरू अशुद्ध ठरने क शिक्षा आपनेक व्यवस्था यी छे। सब प्रकार क कोढ़ क नियम यी छे। ");
INSERT INTO dhn_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","ओळतेन योहोवा मूसु आरू हारून सी कोयु, ");
INSERT INTO dhn_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“इस्राएलिया सी कयु कि जेका जेका ओदमीन सफेद पानी जातो होसे, ते चो प्रमेह कारण अशुद्ध ठरसे। ");
INSERT INTO dhn_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","चो चाहे वोहयतो रये, चाहे वोहयनु बन्द भी होसे, तेभी उकान अशुद्धता बनी रवसे। ");
INSERT INTO dhn_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","जेकान प्रमेह होसे चो जेका जेका खाटला पर लुटे चु अशुद्ध ठरसे, आरू जेका जेका चीज पर चु बठे भीत्यो अशुद्ध ठरसे। ");
INSERT INTO dhn_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","आरू जु कुई हेका खाटला क हाथ लागाड़े त्यो आपसा छिंदरा धुवीन पाणी सी उंगव्या करे, आरू सांतो तक विटळ रये। ");
INSERT INTO dhn_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","आरू जेको प्रमेह होय आरू चा जीन चीज पर बठला छे, उका पर जा कुई बठला चा आपना छिंदरा क धुवीन पाणी सी उंगव्या करे, आरू सांजु तक अशुद्ध ठरला रये। ");
INSERT INTO dhn_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","आरू जेकान प्रमेह होय उका सी जु कुई हाथ लागाड़े जासे चा आपना छिंदरा क धुवीन पाणी सी उंगव्या करे आरू सांतो लग विटळ रये। ");
INSERT INTO dhn_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","आरू जेका प्रमेह होय कदाम चा काहना शुद्ध छिंदरा क धुवीन पाणी सी उंगव्या करे, आरू सांतो तक विटळ रये। ");
INSERT INTO dhn_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","आरू जेका न प्रमेह होय ची सवारी क जेका चीज पर बोठ्या चो विटळ ठरे। ");
INSERT INTO dhn_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","आरू जु कुई काहनी चीज क जो उकान नेड़ा रया होसे हाथ लागाड़े, चो सांते तक अशुद्ध रये; आरू जो कुई ओसी काहनी चीज क उठावे चु आपना छिंदरा क धुवीन पाणी सी उंगव्या करे, आरू सांतो लग विटळ रये। ");
INSERT INTO dhn_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","आरू जेका क प्रमेह होय चु जा काहना क बिना धुवीन हाथ लागाड़े चु आपना छिंदरा क धुवीन पाणी सी उंगव्या करे, आरू सांतो लग विटळ रये। ");
INSERT INTO dhn_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","आरू जेका क प्रमेह होय चो धुवान जेका काहना पात्रा क हाथ लागाड़े तेनाक तुड़ न्हाख्या जासे, आरू काठ क सब प्रकार क पात्रा पाणी सी धुव्या जासे। ");
INSERT INTO dhn_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“ओळता जेका क प्रमेह होय तेनाक जव आपना रोग सी आरगाय होय जाय, तव सी शुद्ध ठरने क सात दाहड़ा गिन लेवु, आरू उनाक वीतने पर आपना छिंदरा क धुवीन वोहयता पाणी सी उंगव्या करे; तव चो शुद्ध ठरसे। ");
INSERT INTO dhn_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","आरू आठवे दाहड़े ची दुय हुली या पेरवान दुय पीला लीन मिलापवाळा तम्बू क झोपला पर योहोवा क सामने जाईन हेका पुजारा क आपे। ");
INSERT INTO dhn_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","तव याजक उना मा सी एक क पापबलि, आरू दीसरा क होमबलि क करता भेंट चढ़ाया; आरू याजक उकान करता उकान प्रमेह क कारण योहोवा क सामने पश्चाताप करे। ");
INSERT INTO dhn_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“ओळता कदाम काहना मानस क वीर्य स्खलित होय जासे, ते चा आपना सब शरीर क पाणी सी धुवे, आरू सांतो लग विटळ रये। ");
INSERT INTO dhn_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","आरू जेका काहना छिंदरा या चामड़ा पर चा वीर्य पड़े तेनाक पाणी सी धुव्या जासे, आरू सांजु तक विटळ रये। ");
INSERT INTO dhn_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","जव कुई मानुस बायर सी सहवास करे, ते चा दुयु पाणी सी उंगव्या करे, आरू सांतो लग विटळ रये। ");
INSERT INTO dhn_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“ओळता जव कुई बायर‌ मासिकधरम रये, ते चो सात दाहड़े तक अशुद्ध ठरलो रये, आरू जु कुई ओका हाथ लागाड़े त्यो सांतो तक विटळ रये। ");
INSERT INTO dhn_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","आरू जव तक चो अशुद्ध रये तव तक जेका जेका चीज पर चा लुटे, आरू जेका जेका चीज पर बोठे चा सब विटळ ठरसे। ");
INSERT INTO dhn_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","आरू जु कुई ओकान खाटला क हाथ लागाड़े चु आपना छिंदरा धुवीन पाणी सी उंगव्या करे, आरू सांतो तक विटळ रये। ");
INSERT INTO dhn_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","आरू जु कुई काहनी चीज क हाथ लागाड़े जेका पर ची बोठी होसे चा आपना छिंदरा धुवीन पाणी सी उंगव्या करे, आरू सांतो तक विटळ रये। ");
INSERT INTO dhn_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","आरू कदाम खाटलो या दीसरो काहना चीज पर जेका पर ची बोठी होसे हाथ लागाड़नेन टेमे ओकान रुधिर लागाड़ होसे, ते सुनेहरो सांतो तक विटळ रये। ");
INSERT INTO dhn_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","आरू कदाम कुई मानुस उका सी प्रसंग करे, आरू ओकान रुधिर ओकाह लाग जाए, ते चु मानुस सात दाहडे तक अशुद्ध रये, आरू जेका जेका खाटला पर चु लुट्यु चा सब विटळ ठरसे। ");
INSERT INTO dhn_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“ओळता कदाम काहनी बायरक आपना नावनीन टेम सी जादा दाहड़ा तक लुहूय वोहयतो रवे, या उका नेमला टेम सी जास्ती टेमे तक मासिकधर्म रवे, ते जव तक चो ओसी दशा मा रवे तव तक चो विटळ रये। ");
INSERT INTO dhn_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","उकान मासिक धर्म रवनेक सब दाहड़ा मा जेका जेका खाटला पर चो लुटे चा सब उकान मासिक धर्मान खाटलान समान ठरसे; आरू जेकी चीज पर चा बोठे चा भी उकान मासिक धर्म रयनेक दाहड़ान सारकी विटळ रये। ");
INSERT INTO dhn_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","आरू जु कुई उना चीजक हाथ लागाड़े चो विटळ ठरसे, एरकरता चो आपना छिंदरा क धुवीन पानी सी उंगव्या करे, आरू सांतो तक विटळ रवे। ");
INSERT INTO dhn_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","पुन जव ची बायर आपना मासिक धर्म सी चुखी हुय जासे, तव सी चा सात दाहड़ा गिन ले, आरू उना दाहड़ाक जाने पर ची चुखी हुसे। ");
INSERT INTO dhn_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","पछा आठवे दाहड़े चा दुय पंडुक या कबुतरा क दुय पीला लिन मिलापवाळा तम्बू क झोपला पर पुजारा जुळ जाय। ");
INSERT INTO dhn_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","तव याजक एक क पापबलि आरू दिसरान होमबलिक करता चढ़ाया; आरू याजक करता मासिक धर्मान विटळ हुयनेन कारण यहोवान सामने पछतावु करे। ");
INSERT INTO dhn_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“ओका गत तुमु इस्राएलियाक उनाक विटळ हुयने सी अलग मेक्या करे, का ओसो नी होए कि चा योहोवाक निवास क जा उकान वीचमा छे अशुद्ध करीन आपनी विटुळ हुयनेन कारण मर जाय।” ");
INSERT INTO dhn_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","जेकान प्रमेह होय आरू जा मानसे वीर्य स्खलित होयने सी विटळ रये; ");
INSERT INTO dhn_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","आरू जी बायर मासिक धर्म सी हय; आरू काय मानसे काय बायर अशुद्ध बायर सी प्रसंग सी करे, इना सभा क करता यी नियम छे। ");
INSERT INTO dhn_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","जव हारून न दुय पोर्‍या योहोवान सामने जाईन मर गीया, हेको बाद यहोवा मूसा सी वातु कर्यो; ");
INSERT INTO dhn_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","आरू यहोवा मूसा सी कयो, थारा भाईस हारून सी कय कि पेटारा न ऊपर पश्चातापवाळा ढाकनान अगोळ, वीचमाहायला परदान माहायता, चुखला जागा मा हर टेमे नी प्रवेश करे, नी ते मर जासे; काहकी हाव पश्चातापवाळा ढाकनेक ऊपर बादल मा दिखाई देसे। ");
INSERT INTO dhn_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","जव हारून चुखलास्थान मा प्रवेश करे तव ओका रीति सी प्रवेश करे, मतलब पापबलिन करता एक केवड़ाक आरू होमबलिन करता एक गाडराक लीन आया। ");
INSERT INTO dhn_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","ची सनीन छिंदराक चुखलो चोगला, आरू आपना डील परला छिंदरान चड्डी पेहरीन, आरू सनन छिंदराक कटिबन्द, आरू सनीक छिंदरान पागड़ी भी पाणी सी ऊंगव्या करीन हेका पेहरे। ");
INSERT INTO dhn_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","पछा चा इस्राएलियान मण्डलिन जु सी पापबलिन करता दुय बुकड़ा आरू होमबलिन करता एक गाडरो लेदा। ");
INSERT INTO dhn_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","तोत्यार हारून आपसा पापोन बादा चोड़ावसे एने आपसा ओळी आपसा घोराना जुगू पोसतावू कोरसे। ");
INSERT INTO dhn_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","ओळतेन हारून दुय बुकड़ा लीन भोगवानो ओगोव मिलापवावा तम्बू पोर उबू कोरसे। ");
INSERT INTO dhn_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","हारून एनू दुयु बुकड़ा जुगु चि़ट्ठी नाखसे। एक योहोवा भोगवान जुगु दिसरी ओजाजेल देवो जुगु। ");
INSERT INTO dhn_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","आरू जिना बुकड़ पोर योहोवा भोगवानोन चिट्ठी निकळे तिनाक हारून पापोन बादा जुगु चोड़ावसे। ");
INSERT INTO dhn_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","पुन जिना बुकड़ा पोर ओजाजेलो जुगु चिट्ठी निकळे चो योहोवा भोगवानो ओगोळ जिवत्लो उबो कोरसे की तेरे पोर पोसतावू कोरे आरू तिनाक उजाड़ी मुलुक मा ओजाजेलोन जा मुकली देय तोसे। ");
INSERT INTO dhn_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","हारून तिना पापोन बादान गाडरा काजे जो हेरेत् जुगु होयसे चो धोड़े ली आवे , आरू तिनाक बादा चोड़ावीन आपसा आरू आपसा घोराना जुगु पोसतावू कोरे तोसे। ");
INSERT INTO dhn_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","आरू जो बेदी योहोवा भोगवानो ओगोव छे तेर पोरून धोपत्ला कुयला सी भोरला धुपोन टाहरा काजे लीन, आरू आपसा दुयु मुठो मा कुटला गोंदायन्या धुपो सी भोरीन, इचमा वावा पोरदा धोड़े ली आवीन ");
INSERT INTO dhn_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","तीना धुप काजे योहोवा भोगवानो ओगोव आगठा मा मेकजी, जेरेसी धुपोन धुवाडू गोवान चिट्ठी पोर पोसतावान ढाकना उपोर छावाय जाय, नी ते हुयो मोर जासे; ");
INSERT INTO dhn_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","तोत्यार हुयो गाडरान लुहुय मा गोथो इतरोक लुहुय लीन उगेनलेछ्ये पोसतावान ढाकनान उपोर आपसी आंगवी सी छाट देसे, आरू ओली तेना लुहुय मा गोथो इतरोक आपसी आंगवी सी तेना ढाकना ओगोव वी सात कावा छाट देजी। ");
INSERT INTO dhn_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","ओळी हारून मानसोन कोरता पापोन बादान बुकड़ाक चोड़ावसे चो हेरा लुहयोन इचमा वावा पोरदान धोड़े ली आवे, आरू जिने रिते बुकड़ान लुहयो पुठी कोर्यू तोसुत् कोरसे, तिना लुहयोक गिनोन पाटड़ी उपोर एने हेरे ओगोव छाट देसे। ");
INSERT INTO dhn_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","आरू हुयो इसराएलीन भाति भातिन विटोळ, आरू गुना, आरू हेंदरा आखा पापोन कोरता चुखला जागा जुगु पोसतावू कोरसे; आरू मिलापवावा तम्बू जो हेरे भेव हेनाक भाति भातिन विटोवोन इचमा रोवे हेरे जुगू वी हुयो तोसोत् कोरे। ");
INSERT INTO dhn_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","जोत्यार हारून पोसतावा जुगु चुखला जागाम भोरायसे आरू जोत्यार लोगुन हुयू आपसा, आपसा घोरल्या एने आखा इसराएली मानसे जुगु पोसतावू कोरीन खोयड़े नी निकवे, ती लोगुन मिलाप वावा तम्बू मा कुदु वी मानुस उबु नी रोवे। ");
INSERT INTO dhn_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","हुयु भोगवानो ओगोव वावी वेदीन चा खोयड़े आवसे आरू हेरे जुगु पोसतावू कोरसे। हुयु गाडरा एने बुकड़ान थुड़ोक लुहुय लीन वेदीन च्यारू मेर सिंगड़ा पोर लुहयोक लागाड़से। ");
INSERT INTO dhn_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","आरू उना लुहुय मा सी आंगळीये करीन सात वार लुहुय छाटसे। ओस कोरीन हुयु इसराएली मानसोन विटोळ गोथु वारु एने चुखा झोन कोरसे। ");
INSERT INTO dhn_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","जोत्यार हुयो चुखलाजागान आरू मिलापवावा तम्बू आरू बेदी जुगु पछतावो कर लेये, ती जिवतला बुकड़ाक ओगा ली आवजु; ");
INSERT INTO dhn_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","हुयो आपसु दुयु हात जिवतेला बुकड़ान मुनका पोर मेसे, आरू इसरारली सोमाजोन आखा भुण्डला काम, आरू आखा पापन क मान लेये। हुयो हेनुक बुकड़ान बुनका पोर नाख देसे, आरू तिना मानसोन हाते कोरीन, जु इना काम जुगु नेवाड़लु होयसे, बुकड़ाक उजाड़ी जागा मुकली छुड़ देसे। ");
INSERT INTO dhn_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","बुकड़ु हेन्दरा आखा भुन्डला कामोक आपसे उपोर हुचलिन सुनसान जागा मा ली जासे। चो मानुस बुकड़ाक उजाड़ी मुलुकोम छुड़ देसे। ");
INSERT INTO dhn_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","तोत्यार हारून मिलापवावा तम्बू मा आवसे। हुयो तेनु आखा सुतिन छिन्दराक निकावीन चां मेक एसे जे हुयो चुखला जागाम भोरायते टेमे पेहलु होतु। ");
INSERT INTO dhn_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","हुयो चुखला जागाम पानीम उंगेवसे आरू आपसा छिन्दरा पेहरीन खोयड़े आवसे। तोत्यार हुयो आपसे एने मानसोन आगठान बादा चोड़ावसे आरू आपसे एने मानसो जुगु पोच्छाताप कोरसे। ");
INSERT INTO dhn_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","हुयो पापोन बादान वावा ढुरोन चोरबी बेदी पोर धोपाड़से। ");
INSERT INTO dhn_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","ओजाजेलोन चा बुकड़ाक ली जानेवावु मानुस आपसा छिन्दरा छुवसे आरू पानीम उंगेवसे। ओळतेनुत् चु पोड़ाव मा माहाय भोराय सोकसे। ");
INSERT INTO dhn_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","पाप बादान वाछड़ो एने पाप बादान बुकड़ो, जेरो लुहुय पोच्छाताप जुगु चुखला जागाम लावला होता, पोड़ावोन खोयड़े ली आवसे आरू चा हेन्दरा खालड़ा, मास आरू गुबोर आगठाम धोपाड़ देसे। ");
INSERT INTO dhn_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","हेनुक धोपाड़नेवावु ओदमी आपसा छिन्दरा धुवसे आरू पानीम उंगेवसे। ओळतेनुत चु पोड़ाव मा भोराय सोकसे। ");
INSERT INTO dhn_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","तुमु मानसो जुगु यी जोलोमोन रिती होयसे कि सातवे मोहनेन दोसवे दाहड़े तुमु आपसा-आपसा जिव काजे उपास राखिन दुख देजु, तेने दाहड़े कुदु वी मानुस चाहाय चु यांत् वावु होय तेने तुमरे विच मा रोवने वावु होय, काम नी कोरनो जुवे; ");
INSERT INTO dhn_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","काहकि इने दाहड़े तुमरे जुगु, तुमुक चुखा कोरने कोरिन पोसतावु कोर्यु जासे। तुमु योहोवा ओगोव आपसा आखा पापो सी चुखा होय जासु। ");
INSERT INTO dhn_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","यो तुमरे जुगु बेसकु आरामोन दाहड़ु छे। तुमु आपसा काजे उपासोन लारे दु:ख देजो। यी जलोमन रिति छे। ");
INSERT INTO dhn_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","आरू जु पुजारू, आपसा बासोन जागा पोर पुजारान जागा जुगु अभिषेक आरू चुखो कोरनेन रिति कोरे, चु पुजारू पोसतावु कोर्या कोरे, एने चु चुखला सुतीन छिन्दरा पेहरिया कोरोसे। ");
INSERT INTO dhn_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","होयु बेसका चुखला जागा, मिलापवावा तम्बू आरू बेदी जुगु पोसतावु कोरसे। हुयो पुजारा एने आखा मोन्डळीन मानसो जुगु वी पछतावो करे। ");
INSERT INTO dhn_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","यी तुमरे जोलोम जुगु रिति छे कि इसराएली मानसे आखा पापोन कोरता हेन्दरे जुगु सालोम एक वार पोसतावु कोरे। जोसु योहोवा मुसाक हुकुम आपलु होतु, हारून वी तोसुत कोर्यु। ");
INSERT INTO dhn_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","पछु योहोवा भगवान मूसा सी कयो, ");
INSERT INTO dhn_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“हारून पोर्‍या सी आरू सब इस्राएलिया सी कयो कि योहोवा भगवान यी हुकुम आपली छे: ");
INSERT INTO dhn_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","इस्राएलिया क घराना मा सी कुई मानुस होय जु बुयल या गाडरा क बच्चा, या बुकड़ी क, चाहे छावनी मा चाहे छावनी सी बाहरते घात करीन ");
INSERT INTO dhn_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","मिलापवाळा तम्बू क झोपला पर, योहोवा भगवान क रयनेन सामने योहोवा क चढ़ावनेन बाहना सी नी ली जाय, ते उका मानसक लुहूय वयावने क दोष लागसे; आरू चु मानुस जु लुहूय वयावने वाळा ठरसे, चा आपना लोगहन क वीच मा सी खतम कर्‍यो जाय। ");
INSERT INTO dhn_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","इनी विधि न यो कारण छे कि इस्राएली आपसो बलिदान जिनाख त्यो खुल्ला मैदान मा वध करता छे, चा हेका मिलापवाळा तम्बू क झोपला पर याजक क जु, योहोवाक करता ली जाईन उकान करता मेलबलि करीन बलिदान कर्‍या करे; ");
INSERT INTO dhn_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","आरू याजक लुहूय क मिलापवाळा तम्बू क झोपला पर योहोवा क वेदी क ऊपर छिड़क्या, आरू चरबा क उकान सुखदायक सुगन्ध क करता धोपाड्या। ");
INSERT INTO dhn_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","चा जा बुकड़ा पुजणीयो हुयी बी व्यभिचार करे, त्यो आपना बलिपशु क ओकान करता बलिदान नी करे। तुमरी पीढ़ीया क करता यो हमेशा क विधि होसे। ");
INSERT INTO dhn_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“तु उकाह कयो कि इस्राएल क घराना क लोगहन मा सी या उनाक वीच रयनेवाळा परदेशिया मा सी कुई मानुस काह नी होय जा होमबलि या मेलबलि चढ़ाया, ");
INSERT INTO dhn_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","आरू उकाह मिलापवाळा तम्बू क झोपला पर योहोवा क करता चढ़ावने नी लावे; चु मानुस आपना लोगहन मा सी खतम कर्‍या जासे। ");
INSERT INTO dhn_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“पछा इस्राएल क घराना क लोगहन मा सी या उनाक वीच रयनेवाळा परदेशिया मा सी कुई मानुस काह नी होय जो काहना प्रकार लुहूय खाय, हाव उकान लुहूय खानेवाळा क विरूध होईन उकाह उकान लोगहन क वीच मा सी खतम कर न्हाखिस। ");
INSERT INTO dhn_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","काहकी शरिर क जीव लुहूय मा रवतु छे; आरू उकान हाव तुमु लोगहन क वेदी पर चढ़ावने करता आपला छे कि तुमरा जीवन करता लुहूय करता पश्चाताप कर्‍यो जासे; काहकी जीव क करता लुहूय सी पश्चाताप हुये। ");
INSERT INTO dhn_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","ओका कारण हाव इस्राएलिया सी कयता छे कि तुमु मा सी कुई जीव लुहूय नी खाय, आरू जु परदेशी तुमरे वीच मा रवता छे चु भी लुहूय कभी नी खाय। ");
INSERT INTO dhn_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“इस्राएलिया मा सी या उकान वीच रयनेवाळा परदेशिया मा सी कुई मानुस काह नी होय जु अहेर करिन खाने क योग्य पशु या चिल्ला क धर्‍या; चा ओकान लुहूय क न्हाखिन धुवा सी ढाक देदा। ");
INSERT INTO dhn_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","काहकी शरिर क जीव जु छे चु उकान लुहूज छे जो उकान जीव क साथे एक छे; ओका करता हाव इस्राएलिया सी कयता छे कि काहना प्रकारन क जनावर क लुहूय क तुमु नी खानु, काहकी सब जनावर क जीव उकान लुहूय छे; जु कुई ओकान खासे चु खतम कर्‍या जासे। ");
INSERT INTO dhn_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","आरू चाहे चु देशी होय या परदेशी होय, जु कुई काहना लोथ या फाड़ला पशु का मांस खाय चा आपना छिंदरा क धुवीन पाणी सी उंगवीन करे, आरू सांजु तक अशुद्ध रवे; तव चो शुद्ध होसे। ");
INSERT INTO dhn_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","कदाम चु उका नी धुवे आरू नी उंगव्या करे, ते उकाह आपना ओधोरोम क भार खुद उठावनो पड़से।” ");
INSERT INTO dhn_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","पछु योहोवा मूसा सी कयो, ");
INSERT INTO dhn_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","इस्त्राएलिया सी कयो कि हाव तुमरू परमेश्वर योहोवा छेव। ");
INSERT INTO dhn_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","तुमु मिस्र देशन कामन अनसारे, जेकामा तुमु रयता हता, नी करनु; आरू कनान देशम कामक अनसारे भी, जा हाव तुमुक लीन जाव, नी करनु; आरू नी ते हेनू देशन नियम पर चालनो। ");
INSERT INTO dhn_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","माराज नियमक मानजो, आरू म्हारीज विधिक मानता उना पर चालनु। हाव तुमरू परमेश्वर योहोवा छेव। ");
INSERT INTO dhn_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","एरकरता तुमु मार नियम आरू मारी विधिक उनाक हमेशा माननु; जु मानुस उनाक माने चु उकान कारन जीवतु रवसे। हाव योहोवा छेव। ");
INSERT INTO dhn_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","तुमु मा सी कुई आपनी काहनी नाट वाळी परिवार वाळीक डिल उघाड़नेक उकान जु नी जाए। हाव योहोवा छेव। ");
INSERT INTO dhn_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","आपसी आईस न डिल, जो तुमरा बास न डिल छे, नी उघाड़नु; ची ते तुमरी आया छे, एरकरता तुमु उकान डिल नी उघाड़नु। ");
INSERT INTO dhn_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","आपनी दिसरी आयान भी डिल नी उघाड़नु; चो ते तुमरा बासनुज ते छे। ");
INSERT INTO dhn_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","आपनी बोहनी चाहे एकुज आयान रवे कि दिसरी आयान होसे, चाहे ची घरमा पयदा होई होसे चाहे बाहरते, उकिन डिल नी उघाड़नु। ");
INSERT INTO dhn_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","आपसा पोर्यान पोराय पुतनी या नातनीन भी डिल नी उघाड़नु, उकिन डिल ते मानु तुमरो छे। ");
INSERT INTO dhn_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","तुमरी सौतेली बोहनी जी तुमरा बास सी पयदा हुई, ची तुमरी बोहनी छे, ओका कारन उकान डिल नी उघाड़नु। ");
INSERT INTO dhn_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","आपनी फुईन डिल नी उघाड़नु; ची ते तुमरा बासन नाट बयणी छे। ");
INSERT INTO dhn_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","आपनी मावसीन डिल नी उघाड़नु; काहकी ची तुमरी आयान कुटुंबन नाट वाळी छे। ");
INSERT INTO dhn_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","आपना काकान डिल उगाड़नु, मतलब उकान बायरक साते नी जानु; ची ते ओकान काकी छे। ");
INSERT INTO dhn_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","आपनी वोवड़िस डिल नी उगाड़नु; ची ते तुमरा पोर्‍याक लाड़ी छे, ओका कारण तुमू ओकान डिल नी उगाड़नु। ");
INSERT INTO dhn_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","आपनी भाभीन डिल नी उगाड़नु; चो ते तुमरा भाईसक डिल छे। ");
INSERT INTO dhn_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","एकदी बायर आरू हेकी पोरायक डिल नी उगाड़नु, आरू हेकी पुतनीक या हेकी नातनीक आपनी बायर समजीन हेकी डिल नी उगाड़नु, ची ते नाट कुटुम्ब वाळी छे; ओसो करनु महापाप छे। ");
INSERT INTO dhn_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","आरू आपनी बायरक भोहनीक आपनी बायर समजीन हेकी बोयंडळ नी बनावनु काहकी पेहली जीविता रयता रयता हेकी डिल भी उगाड़े। ");
INSERT INTO dhn_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","पछु जव तक एकदी बायर आपना ऋतुन कारन अशुद्ध रया तव तक ओकान जु ओकान डिल उगाड़ने क नी जानु। ");
INSERT INTO dhn_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","पछा आपना भाईबन्धुक बायर सी कुकर्म करीन अशुद्ध नी होय जानु। ");
INSERT INTO dhn_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","आपना सन्तान मा सी काहनाक मोलेकक करता होम करीन नी चढ़ावनु, आरू नी आपना परमेश्वरक नावक विटुळ ठरावनु; हाव योहोवा छेव। ");
INSERT INTO dhn_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","स्त्रीगमनक रीति सी पुरूषगमन नी करनु; चो ते घिनौनो काम छे। ");
INSERT INTO dhn_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","एकदि जातिन पशुक साथे पशुगमन करीन अशुद्ध नी होय जानु, आरू नी एकदि बायर पशुक सामने एरकरता उभी होए के उकान साथे कुकर्म करे; यी ते उलटी वात छे। ");
INSERT INTO dhn_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","ओसलो-ओसलो कुई भी काम करीन अशुद्ध नी होय जानु, काहकी जिन जातियाक हाव तुमरे ओगव सी जाने पर छेव चा ओसा ओसा काम करीन अशुद्ध होय गयो छे; ");
INSERT INTO dhn_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","आरू उकान देश भी अशुद्ध होय गयो छे, ओका कारन हाव उका पर उकान अधर्मक दण्ड आपतु छेव, आरू चा देश आपना निवासियाक उगल देतु छे। ");
INSERT INTO dhn_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","ओका कारण तुमु लोगहन मारी विधिया आरू नियमोक निरन्तर माननु, आरू चाहे देशी तुमरे वीचमा रयनेवाळा परदेशी होसे, तुमु मा सी एकदि भी ओसो घिनौनो काम नी करे; ");
INSERT INTO dhn_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","काहकी ओसो सब विनलागीया काम क उना देशन मानसे ज जो तुमरे सी पेहले रयता हुता, ओका सी चो देश विटळ हुय होय गयलो छे। ");
INSERT INTO dhn_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","हिमी ओसो नी होए कि जोसी रीति सी जी जाति तुमू सी पेहेल उका देश मा रयती हती ओकाह उकान उगल देदा, ओकी रीति जव तुमु ओकान अशुद्ध करू, ते चो तुमुक भी उगल देसे। ");
INSERT INTO dhn_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","जु कोय असो विनलाजीयो काम करे असला सब लोगहन आपसा मा सी नष्ट कर्‍या जासे। ");
INSERT INTO dhn_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","यो आदेश जो हाव तुमरे माननेक देदी छे उकाह तुमु माननु, आरू जो घिनौनी रीति तुमु सी पेहेल प्रचलित छे उनामा सी काहना पर नी चालनु, आरू नी उनाक कारन अशुद्ध होय जानु। हाव तुमरू परमेश्वर योहोवा भगवान छेव। ");
INSERT INTO dhn_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","पछु योहोवा भगवान मूसा सी कयो, ");
INSERT INTO dhn_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","इस्राएलियाक सब मण्डली सी कईन तुमु चुखला बोवना रयु; काहकी हाव तुमरो परमेश्वर योहोवा पवित्र छेव। ");
INSERT INTO dhn_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","तुमु आपनी आपनी आयाक आरू आपना आपना बासक भीख माननु, आरू मारा आरामक दाहड़ाक माननु; हाव तुमरू परमेश्वर योहोवा छेव। ");
INSERT INTO dhn_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","तुमु मुर्तिक तरफ नी फिरनु, आरू देवतान फुटा न्हाखिन नी बनाव लेनु; हाव तुमरू परमेश्वर योहोवा छे। ");
INSERT INTO dhn_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","जव तुमु योहोवाक करता मेलबलि करू, तव ओसो बलिदान करनु जेका सी तुमु सी खुश होय जाऊ। ");
INSERT INTO dhn_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","उकान मांस बलिदानक दाहड़े आरू दिसरे दाहड़े खाए जासे, पुन तीसरे दाहड़े तक जा रय जाए चा आग्ठा मा धोपाड़ देय जासे। ");
INSERT INTO dhn_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","कदाम उकामा सी काहय भी तीसरे दाहड़े खाए जासे, ते यो घाड़्च्या ठरसे, आरू ग्रहण नी कर्‍या जासे, ");
INSERT INTO dhn_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","आरू उकान खानेवाळा योहोवाक पवित्र चीजक विटुळ ठरावता छे, एरकरता उकान आपना अधर्मक भार खुद उठावनु पड़से; आरू चो प्राणी आपना लोगहन मा सी नष्ट करे जासे। ");
INSERT INTO dhn_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","पछा तुमु आपना देश क खेत काटो तव आपना खेतक कुपरे तक पुरो नी कादनु, आरू काटला खेतक पड़ली ओसला झोठाक नी नेवाड़नु। ");
INSERT INTO dhn_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","आरू आपनी दाखक वाड़ीक दाना दानान तुड़ लेनु, आरू आपनी दाखक वाड़ीक झोड़ला अंगुरक नी चुटनु; हेका दाहड़े आरू परदेशी लोगहन क करता छुड़ देनु; हाव तुमरू परमेश्वर योहोवा छेव। ");
INSERT INTO dhn_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","तुमु चुरी नी करनु, आरू एक दिसरा सी नी ते कपट करनु, आरू नी झुठ बुलनु। ");
INSERT INTO dhn_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","तुमु मारा नावक झुठी शपथ खाईन आपना परमेश्वरक नाव विटुळ नी करनो; हाव योहोवा छेव। ");
INSERT INTO dhn_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","एक दिसरा पर आन्धारो नी करनु, आरू नी एक दिसराक लुट लेनु। मजदुरन मजदुरी तार जु आखी रात सोंदारे तक नी रय सके। ");
INSERT INTO dhn_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","बोयराक शाप नी देनु, आरू आंधवाक ओगव ठुकर राखनु; आरू आपना परमेशवरक भीख माननु; हाव योहोवा छेव। ");
INSERT INTO dhn_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","न्याय मा कुटिलता नी करनु; आरू नी ते कंगालक पक्ष करनु आरू नी मोटला मानसक मुहय देखनु विचार करनु; एक दिसराक न्याय धर्म सी करनु। ");
INSERT INTO dhn_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","लुतरा बनीन आपना लोगहन मा नी फिर्‍या करनु, आरू एक दिसराक लुहुय वोहयनेन युक्ति नी बांधनु; हाव योहोवा भगवान छेव। ");
INSERT INTO dhn_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","आपना मन मा एक दिसराक प्रति खत नी मेकनु; आपने नाट घर वाळाक नक्कि डाडनु, नी ते उकान पापक भार तुखेक उठावनु पड़से। ");
INSERT INTO dhn_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","बदलो नी लेनु, आरू नी आपसा लोगहन सी खत राखनु, पुन एक दिसरा सी आपने समान मोंग राखनु; हाव योहोवा भगवान छेव। ");
INSERT INTO dhn_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","तुमु म्हारा नियम जलोमका मान। आपजो तमरा पाळनिया जनवार क दिसरी जातिन जनवार सी प्रजनन झुन करने देनु; आपना खेत मा दुय प्रकारक बीजा एकठा नी वेरनु; आरू झारीन आरू ऊनान मिलावट सी बोवना होया छिंदरा नी पेहरनु। ");
INSERT INTO dhn_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“पछी एकदी बायर दासी होसे, आरू उकान इहाव एकदा मानसक सी होई होसे, पुन चो नीते दाम सी आरू नी सेंतमेंत स्वाधीन करी गई होसे; उकासी कदाम कुई कुकर्म करे, ते उना दुय दाहड़ाक दण्ड ते जोड़े, पुन उका बायरक स्वाधीन नी होयनेक कारण चा दुयु मार नी न्हाखे जासे। ");
INSERT INTO dhn_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","पुन चो मानुस मिलापवाळा तम्बूक झोपला पर योहोवाक जु एक गाडरो दोषबलिक कारण ली आया। ");
INSERT INTO dhn_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","आरू याजक ओकान कर्‍या होया पापन कारण दोषबलिक गाडराक द्वारा ओकान करता योहोवाक सामने पश्चाताप करे; तव ओकान कर्‍या होया पापक माप कर्‍या जासे। ");
INSERT INTO dhn_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“पछा जव तुमु कनान देश मा पुगीन काहना प्रकारक फोव झाड़को लागाडु, ते ओकान फोव तुमरे करता मानु खतनारहित ठरला रवे; एरकरता उनामा सी काहय नी खादा जासे। ");
INSERT INTO dhn_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","आरू चौथा साल मा ओकान सब फोव योहोवाक स्तुति करनेक करता पवित्र ठरसे। ");
INSERT INTO dhn_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","तव पाचवा साल मा तुमु ओकान फोव खानु, एरकरता के उकासी तुमुक बैस फोव जोड्या; हाव तुमरा परमेश्वर योहोवा छेव। ");
INSERT INTO dhn_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“तुमु लुहुय लागाड़लो ओसलो मांस नी खानु। आरू नी जादु टोनु करनु, आरू नी शुभ या अशुभ मुहूर्तोक माननु। ");
INSERT INTO dhn_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","आपना मानुका मा घेरा मेकिन नी काडनु, आरू नी आपना गालक झोठाक काडनु। ");
INSERT INTO dhn_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","मरला धोड़न कारण आपना डिलक बिलकुल नी चीरनु, आरू नी उकमा छाप लागाड़नु; हाव योहोवा छेव। ");
INSERT INTO dhn_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“आपनी पोरायक वेश्या बनावीन विटुळ नी करनु, ओसो नी होय कि देश वेश्यागमनक कारण महापाप सी भर जासे। ");
INSERT INTO dhn_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","मारा आरामक दाहड़ाक मान्या करनु, आरू मारा पवित्रस्थानक डर हमेशा माननु; हाव योहोवा छेव। ");
INSERT INTO dhn_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“ओझाओं आरू भुतड़ा साधनेवाळाक तरफ नी फिरनु, आरू ओसोज खोज करीन उनाक अशुद्ध नी होय जानु; हाव तुमरू परमेश्वर योहोवा छेव। ");
INSERT INTO dhn_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“डाहला लोगहन क सामने उभरय जानु, आरू डाहयलाक आदरमान करनु, आरू परमेश्वरक डर हमेशा माननु; हाव योहोवा छेव। ");
INSERT INTO dhn_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“कदाम एकदु परदेशी तुमरा देश मा तुमरे साथे रये, ते ओकाह दु:ख नी देनु। ");
INSERT INTO dhn_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","जा परदेशी तुमरे साथे रये चा तुमरे करता आपना देशन समान रवसे, आरू ओकासी आपने समान मोंग राखता; काहकी तुमु भी मिस्र देश मा परदेशी हता; हाव तुमरू परमेश्वर योहोवा छेव। ");
INSERT INTO dhn_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“तुमु न्याय मा, आरू परिणाम मा, आरू तौल मा, आरू नाप मा कुटिलता नी करनु। ");
INSERT INTO dhn_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","सच्ची ताकड़ी, धर्मक बटखरे, सच्चु एपा, आरू धर्माक हीन तुमरे जु रये; हाव तुमरू चु परमेश्वर योहोवा छेव जो तुमुक मिस्र देश सी निकाळ ली आया। ");
INSERT INTO dhn_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","एरकरता तुमु मारी सब विधिया आरू सब नियमक मानता जाईन हमेशा पालन करू; हाव योहोवा छेव।” ");
INSERT INTO dhn_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","पछु योहोवा मूसा सी कयो, ");
INSERT INTO dhn_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","इस्राएलिया सी कया कि इस्राएलियाक विच मा रयनेवाळा परदेशिया मा सी, एकदो काह नी होसे जी आपनी एकदी सन्तान मोलेक बलिदान करे, चो नक्कि माराय जासे; आरू जनता उका पर पथराव करे। ");
INSERT INTO dhn_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","हाव भी उका मानसक विरूद्ध होईन ओकाक उका लोगहन मा सी ओका कारण खतम करसु कि ओको आपनी सन्तान मोलेकक आपीन मार पवित्रस्थानक अशुद्ध कर्‍या, आरू मार पवित्र नावक विटुळ ठरायो। ");
INSERT INTO dhn_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","आरू कदाम एकदो आपनी सन्तान मोलेक बलिदान करे, आरू जनता ओकान विषय मा आनाकानी करे आरू ओकाह मार नी न्हाख्ये, ");
INSERT INTO dhn_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","तव ते हाव खुद ओका मानसक आरू ओकान घरानाक विरूद्ध होईन ओकान आरू जोतरा ओकान पछव होईन मोलेक साथ व्यभिचार करे उना सभाक भी उनाक लोगहनक वीच मा सी खतम करसु। ");
INSERT INTO dhn_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","पछा जु प्राणी ओझाओ या भूतसाधनेवाळाक तरफ फिरीन, आरू उनाक पछव होईन व्यभिचारी बन्या, ते हाव प्राणीक विरूद्ध होईन ओकाक ओकान लोगहनक विच मा सी खतम कर दिस। ");
INSERT INTO dhn_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","एरकरता तुमु आपने आपसु पवित्र करू; आरू पवित्र बवना रयु; काहकी हाव तुमरू परमेश्वर योहोवा छे। ");
INSERT INTO dhn_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","आरू तुमु मार विधियाक मानजु, आरू ओकान पालन भी करनु; काहकी हाव तुमरो पवित्र करनेवाळो योहोवा छे। ");
INSERT INTO dhn_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","एकदो काह नी होसे जु आपना बासक या आयाक शाप आपे तिनाक नक्कि मार न्हाखे जासे; ओको आपना बासक या आयाक शाप देदा छे, ओका कारण ओकान खून ओका मुनका पर पड़से। ");
INSERT INTO dhn_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","पछा कदाम एकदो पराई बायरक साथे व्यभिचार करे, ते जोतरी एकदी दिसरी बायरक साथे व्यभिचार करे होसे ते चो व्यभिवारी आरू ची व्यभिचारणी दुयु नक्कि मार न्हाखे जासे। ");
INSERT INTO dhn_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","कदाम एकदो आपनी सौतली आईस पुठी सुवे, चो आपना बासक डिल उघाड़नेवाळो ठरसे; एरकरता चा दुयु नक्कि मार न्हाखे जासे, ओकान लूहुय हेका मुनका पर पड़से। ");
INSERT INTO dhn_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","कदाम एकदो आपनी पतोहूक साथे सुवे, ते चा दुयु नक्कि मार न्हाखे जासे; काहकी चा उलटो काम करनेवाळा ठरसे, आरू ओकान लूहुय हेका मुनका पर पड़से। ");
INSERT INTO dhn_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","कदाम एकदो जेकी रीति बायर सी उनी रीति मानुस सी प्रसंग करे, ते चा दुयु घिनौनो काम करनेवाळा हुयसे; ओका कारण चा नक्कि मार न्हाखे जासे, ओकान लूहुय हेका मुनका पर पड़से। ");
INSERT INTO dhn_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","कदाम एकदो आपनी लाड़ीक आरू आपनी सासुक दुयुक राखे, ते यो महापाप छे; एरकरता चो मानुस आरू ची बायर तीनुन तीनुक आग्ठा मा धोपाड़े जासे, जेकी तुमरे वीचमा महापाप नी होसे। ");
INSERT INTO dhn_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","पछा कदाम एकदो मानुस पशुगामी होसे, ते मानुस आरू पशु दुयु नक्कि मार न्हाखे जासे। ");
INSERT INTO dhn_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","कदाम एकदी बायर पशुक जु जाईन ओकान संग कुकर्म करे, ते तू ओकी बायर आरू पशु दुयोक घात करनु; चा नक्कि मार न्हाखे, ओकान लूहुय हेका मुनका पर पड़से। ");
INSERT INTO dhn_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","कदाम एकदो आपनी सौतली बोहनीसक, चाहे ओकान सगी बोहनी होसे चाहे सौतली, ओकीम बिना छिंदराक डिल देखे, ते यो निन्दित वात छे, चा दुयु आपना जातीन भाईसक डुवान सामने खतम करे जासे; काहकी जु आपनी बोहनीस डिल उघाड़नेवाळा ठरसे ओकाह आपना अधर्मन भार खुद उठावनु पड़से। ");
INSERT INTO dhn_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","पछा कदाम एकदो मानुस काहना ऋतुमती बायरक संग सुवीन ओकान तन उघाड़े, ते चो मानुस ओकान रूधिरक सोतेक उघाड़नेवाळा ठरसे, आरू ची बायर रूधिरक सोतेक उघाड़नेवाळा ठरसे; ओका कारण चा दुयु आपना लोगहनक वीच मा सी खतम कर्‍या जासे। ");
INSERT INTO dhn_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","आपनी जीजी या फुईक डिल नी उघाड़नु, काहकी जु ओका उघाड़े चु आपने साथे कुटुम्बिनीक नगो करता छे; एरकरता उना दुयुक आपना अधर्मन भार उठावनु पड़से। ");
INSERT INTO dhn_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","कदाम एकदो आपनी काकीन साथे सुवे, ते चो आपना काकान डिल उघाड़नेवाळो ठरसे; एरकरता चा दुयु आपना पापक भार क उठावीन निर्वश मर जासे। ");
INSERT INTO dhn_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","कदाम एकदो आपनी वोवड़ीस या भयाहू क आपनी लाड़ी बनावे, ते ओका घिनौनो काम जाननु; आरू आपना भाईसक डिल उघाड़नेवाळा ठरसे, ओका करण चा दुयु निर्वश रवसे। ");
INSERT INTO dhn_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","तुमु मारी सब विधिया आरू मारा सब नियमोक समझक साथे माननु; जेका सी यो नी होसे कि जेका देश मा हाव तुमुक लीन जाय रयु छे चु तुमुक उगल देसे। ");
INSERT INTO dhn_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","आरू जेकी जातीन लोगहनक हाव तुमरे ओगव सी निकाळता छे उकान रीति रस्म पर नी चालनु; काहकी उना लोगहन नी जो यो सब कुकर्म करे छे ओका कारण मखे उना सी घृणा होय गई छे। ");
INSERT INTO dhn_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","पुन हाव तुमु लोगहन सी कयतु छे कि तुमु ते ओकान धरतीन आधिकारी होसे, आरू हाव ओका देश क जेका मा दूध आरू मोवन धारा वोहयता छे तुमरा हक मा कर दिस; हाव तुमरो परमेश्वर योहोवा छे जु तुमुक दिसरा देशक लोगहन सी अलग कर्‍यो छे। ");
INSERT INTO dhn_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","ओका कारण तुमु शुद्ध आरू अशुद्ध पशु मा, आरू शुद्ध आरू अशुद्ध चिल्ला मा भेद करनु; आरू एकदो पशु या चिल्लो या काहनो प्रकारन धरती पर रेंगनेवाळा जीवजन्तु काह नी होसे, जेका हाव तुमरे करता अशुद्ध ठरावीन वर्जित कर्‍या छे, ओका सी आपने आप क अशुद्ध नी करनु। ");
INSERT INTO dhn_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","तुमु मार करता पवित्र बवना रयु; काहकी हाव योहोवा खुद पवित्र छे, आरू हाव तुमु क आरू देशक लोगहन सी एरकरता अलग कर्‍या छे कि तुमु निरन्तर माराज बवना रवु। ");
INSERT INTO dhn_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","कदाम एकदो मानुस या बायर ओझाई अथवा भूतज साधना करे, ते चो नक्कि मार न्हाखे जासे; ओसा पर पथराव कर्‍या जासे, ओकान लूहुय हेकाक मुनका पर पड़से। ");
INSERT INTO dhn_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","पछु योहोवा मूसा सी कयो, “हारूनक पोर्‍यो जु याजक छे ओका सी कया कि तुमरे लोगहन मा सी कोय भी मरे, ते ओकान कारण तुमु मा सी कुई आपसाक अशुद्ध नी करे; ");
INSERT INTO dhn_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","आपने निकट कुटुम्बिया, मतलब आपनी आया, या बासक, या पोर्‍या, या पोराय, या भाईसक करता, ");
INSERT INTO dhn_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","या आपनी कुवारी बोहनीस जेका हियाव नी होयो छे, जेका निकटन सम्बन्ध छे; उनाक करता चो आपनाक अशुद्ध कर सकता छे। ");
INSERT INTO dhn_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","पुन याजक होयने नाता चो आपना लोगहन मा प्रधान छे, एरकरता चो आपनुक ओसो अशुद्ध नी करे कि विटुळ होय जाए। ");
INSERT INTO dhn_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","चा नी ते आपना मुनकान झोठा काढ़ाया, आरू नी आपना गालक झोठाक काढ़ाया, आरू नी आपना शरीर चीरे। ");
INSERT INTO dhn_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","चा आपना परमेश्वरन करता पवित्र बवना रवु, आरू आपना परमेश्वरक नाव विटुळ नी करे; काहकी चा योहोवाक हव्य क जो ओकान परमेश्वरन खानो छे, चढ़ावो करता छे; कारण चा पवित्र बवना रवे। ");
INSERT INTO dhn_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","चा वेश्या या भ्रष्टा सी हियाव नी करे, आरू नी त्यागी होई सी हियाव करे; काहकी याजक आपना परमेश्वरन करता पवित्र होयता छे। ");
INSERT INTO dhn_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","एरकरता तु याजक पवित्र जाननु, काहकी चो तुमरा परमेश्वरम खानो चढ़ायो करता छे; एरकरता चो तारी नजर मा पवित्र ठरे; काहकी हाव योहोवा, जो तुमुक पवित्र करता छे, पवित्र छे। ");
INSERT INTO dhn_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","आरू कदाम याजकन पोराय वेश्या बनावीन आपने आपसुक विटुळ करे, ते चो आपना बासक विटुळ ठरावती छे; ची आग्ठा मा धोपाड्यो जासे। ");
INSERT INTO dhn_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“जु आपना भाईसक मा महायाजक होसे जेका मुनका पर अभिषेक तेल न्हाख्या गया होसे, आरू जेका पवित्र छिंदराक पेहरनेन करता संस्कार होयो होसे चो आपना मुनकाक झोठा वेरायने नी देनु, आरू नी आपना छिंदरा फाड़े; ");
INSERT INTO dhn_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","आरू नी चो काहना लोथ क जु जाए, आरू नी आपना बास या आयाक कारण आपनुक अशुद्ध करे; ");
INSERT INTO dhn_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","आरू चो पवित्रस्थानक पवित्रस्थान सी बाहरता भी नी निकळे, आरू नी आपना परमेश्वरक पवित्रस्थानक विटुळ ठरायो; काहकी चो आपना परमेश्वरक अभिषेक तेलरूपी मुकुट धारण कर्‍या होया छे; हाव योहोवा छे। ");
INSERT INTO dhn_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","आरू ची कुवारी बायर सी हियाव करे। ");
INSERT INTO dhn_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","जी विधवा, या त्यागी होई, या भ्रष्ट, या वेश्या होसे, ओसी काहना सी ची हियाव नी करे, चा आपनाज लोगहन वीच माहयला काहनी कुवारी पोराय सी हियाव करे। ");
INSERT INTO dhn_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","आरू ची आपनी संतानक आपना लोगहन मा विटुळ नी करे; काहकी हाव ओकान पवित्र करनेवाळा योहोवा छे।” ");
INSERT INTO dhn_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","पछु योहोवा मूसा सी कयो, ");
INSERT INTO dhn_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“हारून सी कय कि तार साथे वंश पीढ़ी पीढ़ी मा जेका काहनाक कुई भी दोष होसे चो आपना परमेश्वरम खानो चढ़ावनेक करता सामने नी आया। ");
INSERT INTO dhn_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","एकदो काह नी होसे जेका मा दोष होसे वो सामने नी आया, चाहे चो आंधवो होसे, चाहे लेंगड़ा, चाहे नकटपटा होसे, चाहे ओकान काहय सवटो अंग होसे, ");
INSERT INTO dhn_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","या ओकान पाय, या हाथ टूटे होसे, ");
INSERT INTO dhn_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","या चो कुबड़ा, या बौना होसे, या ओकान डुवा मा दोष होसे, या उका मानसक चाई या खुजली होसे, या ओकान आंडा पिचका होसे; ");
INSERT INTO dhn_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","हारून याजकन वंश मा सी जेका काहना मा एकदो भी दोष होसे चो योहोवाक हव्य चढ़ावने करता सामने नी आया; चो जो दोषयुक्त छे कभी भी आपना परमेश्वरन खानो चढ़ावनेक करता सामने नी आया। ");
INSERT INTO dhn_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","चो आपना परमेश्वरन पवित्र आरू घण चुखो दुयु प्रकारन भोजनक खाये, ");
INSERT INTO dhn_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","पुन ओकान दोषन कारण चो नी ते वीचमाहयला पड़दान माहयता आया आरू नी वेदीक सामने, जेका सी ओसा नी होसे कि चो मारो पवित्रस्थानक विटुळ करे; काहकी हाव ओकान पवित्र करनेवाळा योहोवा छे।” ");
INSERT INTO dhn_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","एरकरता मूसु हारून आरू ओकान पोर्‍याक तथा सब इस्राएलियाक या वातु कय सुनाई। ");
INSERT INTO dhn_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","पछु योहोवा मूसा सी कया, ");
INSERT INTO dhn_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","हारून आरू ओकान पोर्‍या सी कया कि इस्राएलियाक पवित्रन होई चीज सी जेका चो मार करता पवित्र करता छे अलग रया, आरू मारा पवित्र नावन विटुळ नी करे; हाव योहोवा छे। ");
INSERT INTO dhn_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","आरू उना सी कय कि तुमरी पीढ़ी पीढ़ी मा तुमरे सब वंश मा सी जो कुई आपनी अशुद्धता कि दशा मा उना पवित्र होई चीजक जु जाए, जेका इस्राएली योहोवाक पवित्र करता छे, चो प्राणी मार सामने सी नाश कर्‍या जासे; हाव योहोवा छे। ");
INSERT INTO dhn_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","हारूनक वंश मा सी कुई काह नी होसे जो कोढ़ी होसे, या ओकान सफेदपाणी होसे, चो मानुस जव तक शुद्ध नी होसे जाए तव तक पवित्र होई चीज मा सी काहय नी खाए। जो लोथक कारण अशुद्ध होसे, या जेका वीर्य स्खलित होयो होसे, ओसो मानुसक जो कुई हाथ लागाड़े, ");
INSERT INTO dhn_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","आरू जो कुई काहनी ओसो रेंगनेहारे जन्तुक हाथ लागाड़े जेका सी लोगहन अशुद्ध होय सकता छे, या काहना ओसा मनुस क हाथ लागाड़े जेका मा काहना प्रकारन अशुद्धता होसे जो ओकाह भी लाग सकती छे ");
INSERT INTO dhn_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","ते चो प्राणी जो इनामा सी काहनाक हाथ लागाड़े सांजु तक अशुद्ध ठरल रवे, आरू जव तक जल सी स्नान नी करले तव तक पवित्र चीज मा सी काहय नी खाए। ");
INSERT INTO dhn_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","तव दाहड़ो बुडनेक होयने पर चो शुद्ध ठरसे; आरू तव चो पवित्र चीज मा सी खाय सक छे, काहकी ओकान खानो चो छे। ");
INSERT INTO dhn_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","जो जनावर आपने आपसु सी मरलो होसे या हिंसक पशु सी फावड़ो गयो होसे उका खाईन चो आपने आपसुक अशुद्ध नी करे; हाव योहोवा छे। ");
INSERT INTO dhn_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","एरकरता याजक लोगहन म्हारा आपला नियमनमन पालन करे, ओसो नी होय कि चा उनाक विटुळ करीन पापन भार उठायो, आरू ओका कारण मर भी जाए; हाव ओकान पवित्र करनेवाळु योहोवा छे। ");
INSERT INTO dhn_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“पराया कुलक जन काहना पवित्र चीजक नी खानु जुवे, चाहे चु याजक क पाहनत्रो होसे या मजदुर होसे, तौभी चा कुई पवित्र चीज नी खाए। ");
INSERT INTO dhn_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","कदाम याजक काहना प्राणी ओकामा सी खाय सकता छे; आरू जु याजकक घर मा पयदा होये होसे चा भी ओकान खाना मा सी खाए। ");
INSERT INTO dhn_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","कदाम याजकक पोराय पराया कुलक काहना मानसो सी हियाव वाळी होसे, ते ची भेंटक होई पवित्र चीज मा सी नी खाए। ");
INSERT INTO dhn_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","कदाम याजकक पोराय विधवा या त्यागी होई होसे, आरू ओकान सन्तान नी होसे, आरू ची आपनी बाल्यावस्थाक रीतीक अनसारे आपना बासक घर मा रयती होसे, ते ची आपना बासन खाना मा सी खाए; पुन पराया कुलक एकदो ओकामा सी नी खाय नी सके। ");
INSERT INTO dhn_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","आरू कदाम एकदो मानुस काहना पवित्र चीज मा सी कहाय विसरीन काय जासे, ते चो ओकान पाचवो भाग बढ़ावीन उका याजक क भर दे। ");
INSERT INTO dhn_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","चा इस्राएलियाक पवित्र करली होई चीजक, जेका चा योहोवाक करता चढ़ाया, विटुळ नी करे। ");
INSERT INTO dhn_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","चा ओका आपनी पवित्र चीज मा सी खावाढ़ीन ओका सी अपराधक दोष नी उठाड्या; हाव ओकान पवित्र करनेवाळु योहोवा छे।” ");
INSERT INTO dhn_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","पछु योहोवा मूसा सी कयो, ");
INSERT INTO dhn_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“हारून आरू ओकान पोर्‍या सी आरू इस्राएलिया सी समझाळीन कया कि इस्राएलक घराना या इस्राएल मा रयनेवाळा परदशिया मा सी एकदो काह नी होए जु मन्नत या स्वेच्छाबलि करनेक करता योहोवाक कुई होमबलि चढ़ाया, ");
INSERT INTO dhn_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","ते आपना निमित्त ग्रहणयोग्य ठरनेक करता बुयल या गाडरा या बुकड़ा मा सी निर्दोष नर चढ़ायो जासे। ");
INSERT INTO dhn_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","जेका मा कुई भी दोष होय हेको नी चढ़ावनो; काहकी त्यो तुमरे जुगू मानने सारको नी रयसे। ");
INSERT INTO dhn_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","आरू जु कुई बुयल या गाडरा-बुकड़ा मा सी स्वेच्छाबलिन करता योहोवाक मेलबलि चढ़ाया, ते ग्रहण होयनेन करता पाको छे कि चो निर्दोष होय, ओकामा कुई भी दोष नी होय। ");
INSERT INTO dhn_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","जु आंधवो या डिलन टुटलो या लुल्लो होसे, अथवा ओकमा रसौली या खवड़ा या खुजली होसे, ओसाक योहोवाक करता नी चढ़ावनु, ओकाक वेदी पर योहोवान करता हव्य नी चढ़ावनु। ");
INSERT INTO dhn_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","जेका काहनो बुयल या गाडराक कुई डिल जास्ती या कम मोटलो होसे ओकाह स्वेच्छाबलिन करता चढ़ाव सकता छे, पुन मन्नत पूरी करनेन करता चो ग्रहण नी होयसे। ");
INSERT INTO dhn_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","जेका आंडा दाबायला या कुचनाया या टूटला या काटला गया होसे ओका योहोवाक करता नी चढ़ावनु, आरू आपना देश मा भी ओसो काम नी करनु। ");
INSERT INTO dhn_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","इकामा सी काहनाक तुमु आपनो परमेश्वरन खानो जानीन एकदा परदेशी सी लीन नी चढ़ावु; काहकी ओकामा ओकान दोष छे, ओकामा दोष छे, एरकरता चो तुमरे निमित्त ग्रहण नी होसे।” ");
INSERT INTO dhn_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","पछु योहोवा मूसा सी कयो, ");
INSERT INTO dhn_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“जव केवढ़ाक या गाडराक या बुकड़ान बच्चा सी पयदा होय, ते चो सात दाहड़े तक आपनी आयाक साथे रये; पछा आठवे दाहड़े सी ओगव चो योहोवाक हव्यन करता ग्रहणयोग्य ठरसे। ");
INSERT INTO dhn_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","चाहे केवढ़ी, चाहे गाडरा या बुकड़ा होये, ओकाक आरू बच्चाक एकुज दाहड़ा मा बलि नी करनु। ");
INSERT INTO dhn_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","आरू जव तुमु योहोवान करता धन्यवादन मेलबलि चढ़ावु, ते उनी रीति सी करनु जेका सी चो ग्रहणयोग्य ठरसे। ");
INSERT INTO dhn_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","चा ओके दाहड़े खाये जासे, ओकामा सी काहय भी सोंदारे तक रयनु नी जुवे; हाव योहोवा छे। ");
INSERT INTO dhn_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“एरकरता तुमु मारी हुकुमोन माननु आरू ओकान पालन करनु; हाव योहोवा छे। ");
INSERT INTO dhn_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","आरू मारा पवित्र नाव विटुळ नी ठरनु, काहकी हाव इस्राएलियाक वीच मा पाको पवित्र माने जासे; काहकी हाव तुमरो पवित्र करनेवाळु योहोवा छे, ");
INSERT INTO dhn_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","जा तुमुक मिस्र देश सी निकाळ लाया, जेका सी तुमरो परमेश्वर बवनु रवे; हाव योहोवा छे।” ");
INSERT INTO dhn_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","पछा यहोवु मूसा सी कयो, ");
INSERT INTO dhn_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“इस्राएलिया सी कया कि योहोवान तिवार जेकान तुमुक पवित्र सभा एकठी करनेक करता नेमला टेमो पर प्रचार करनु पड़से, मारा या तिवार या छे। ");
INSERT INTO dhn_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","छव: दाहड़ा काम-काज कर्‍या जासे, पुन सातवे दाहड़े परमआरामम तरफ पवित्र सभान दाहड़ु छे; ओकामा काहना प्रकारन काम-काज नी कर्‍या जासे; चा तुमरा सब घर मा योहोवाक आरामन दाहड़ा ठरसे। ");
INSERT INTO dhn_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“पछा योहोवान तिवार जेकामा सी एकेकान ठराया होए टेमो मा तुमुक पवित्र टुळु करनेन करता प्रचार करनो पड़से चा या छे। ");
INSERT INTO dhn_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","पेहले महिनान चौदवे दाहड़े शान्‍तीन टेमे योहोवान फसह होया करे। ");
INSERT INTO dhn_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","आरू उके महिनान पंद्रावे दाहड़े योहोवान करता अखमीरी रोटान तिवार होया करे; ओकामा तुमु सात दाहड़े तक अखमीरी रोटा खाया करनु। ");
INSERT INTO dhn_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","ओकामा पेहलो दाहड़ो तुमरी पवित्र सभा होसे; आरू उके दाहड़े मेहनतन कुई काम नी करनु। ");
INSERT INTO dhn_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","पुन सातु दाहड़े तुमु योहोवान हव्य चढ़ाया करनु; आरू सातवे दाहड़े पवित्र सभा होसे; उके दाहड़े मेहनतन कुई काम नी करनु।” ");
INSERT INTO dhn_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","पछा योहोवा मूसा सी कयो, ");
INSERT INTO dhn_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“इस्राएलिया सी कया कि जव तुमु उका देश मा प्रवेश करहत जेका योहोवा तुमुक आपतु छे आरू ओकामा खेत काटु, तव आपना आपना पाकला खेतन पेहली कमाईन पूला याजकन जु ली आया करनु; ");
INSERT INTO dhn_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","आरू चु उका पूलाक योहोवान सामने हालाड्या, कि चो तुमरे निमित्त ग्रहण कर्‍या जासे; चो उका आरामन दाहड़े दिसरे दाहड़े हालाड्या। ");
INSERT INTO dhn_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","आरू जेके दाहड़े तुमु पूला हालाड़े उके दाहड़े एक सालन निर्दोष गाडरान बच्चा योहोवान करता होमबलि चढ़ाना। ");
INSERT INTO dhn_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","आरू ओकान साथेन अन्नबलि एपान दुय दसवो अंश तेल सी झारीन मैदान होसे, चो सुखदायक सुगन्धान करता योहोवान हव्य होसे; आरू ओकान साथेन दूय लीटर भरीन पीने वाळो दाखरस चढ़ावाए । ");
INSERT INTO dhn_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","आरू जव तक तुमु ओका चढ़ावाक आपना परमेश्वरक जु नी ली जावु, उके दाहड़े तक नोवला खेत मा सी नी ते रोटो खानु आरू नी भूजलो अन आरू नी हरी बाले; यी तुमरी पीढ़ी पीढ़ी मा तुमरा सब घराना मा हमेशान विधि ठरसे। ");
INSERT INTO dhn_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“पछा उका आरामन दाहड़ान दिसरे दाहड़ा सी, मतलब जेके दाहड़े तुमु हिलाड्या जानेवाळी भेंटन पूलेक लावसु, उका दाहड़ा सी पूरा सात आरामन दाहड़े गिन लेनु; ");
INSERT INTO dhn_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","सातवा आरामन दाहड़ान दिसरे दाहड़े तक पचास दाहड़ा गिन्नु, आरू पचावे दाहड़े योहोवान करता नोवला अन्नबलि चढ़ावनु। ");
INSERT INTO dhn_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","तुमु आपना घरो मा सी एपा क दुय दसवु अंश मैदान दुय रोटा हालावनेक भेंटन करता ली आवनु; चा खमीरन साथे रांदायनु जुवे, आरू योहोवान करता पेहली कमाय ठरसे। ");
INSERT INTO dhn_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","आरू उका रोटान संग एक एक सालन सात निर्दोष गाडरान बच्चा, आरू एक बछड़ो, आरू मेंढा चढ़ावनु; चा आपना आपना साथे वाळा अन्नबलि आरू अर्घ समेत योहोवान करता होमबलिन समान चढ़ावनु जासे, मतलब चा योहोवान करता सुखदायक सुगन्ध आपनेवाळा हव्य ठरसे। ");
INSERT INTO dhn_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","पछा पापबलिन करता एक बुकड़ो, आरू मेलबलिन करता एक एक सालन दुय गाडरान बच्चा चढ़ावनु। ");
INSERT INTO dhn_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","तव याजक उकाह पेहली कमाईन रोटा समेत योहोवान सामने हालावनेक भेंटन करता हालाड्या, आरू इना रोटान संग चा दुय गाडराक बच्चा भी हालाड्या जासे; चा योहोवान करता पवित्र, आरू याजकन भाग ठरसे। ");
INSERT INTO dhn_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","आरू तुमु उके दाहड़े यो प्रचार करनु कि आज हामरी एक पवित्र सभा होसे; आरू मेहनतन कुई काम नी करनु; यो तुमरा सब घराना मा तुमरी पीढ़ी पीढ़ी मा हमेशान विधि ठरसे। ");
INSERT INTO dhn_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“जव तुमु आपना देश मा खेत काटु, तव आपना खेत न कानोक पुरी रीती सी नी काटनु, आरू खेत मा पड़ला होया झोठाक नी एकठा करनु; उका दीनहीन आरू परदेशीन करता छुड़ देनु; हाव तुमरो परमेश्वर योहोवा छे।” ");
INSERT INTO dhn_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","भोगवान मुसा काजे कोयु, ");
INSERT INTO dhn_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","तु इसरायली काजे यो कोव: सातवे मोहनान पेहले दाहड़े बेस चुखलु दाहड़ु वावजु। एनाक फोम कोरावने जुगु मोटला फेपारीया वाजाड़जु, आरू एक चुखली मिटिंग एकठी होयनो जुवे। ");
INSERT INTO dhn_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","तुमु काहने वी भातीन मेहनोतोन काम झुन कोरता। तुमु योहोवा जुगु आगठान बादा चोड़ावजु। ");
INSERT INTO dhn_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","पोरबु मुसा काजे कोयु, ");
INSERT INTO dhn_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","इना सातवा मोहनान दोसवे दाहड़े पोसतावान दाहड़ु छे। हुयो तुमरे जुगु चुखला तिहवारोन टेम होयसे। तेने दाहड़े तुमु आपसाक उपास राखिन दुख आपजु आरू पोरबुक आगठान बादा चोड़ावजु। ");
INSERT INTO dhn_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","तुमु इने दाहड़े काहने वी भातिन काम झुनी कोरता; काहकि यु योहोवा परमेश्वर ओगोव तुमरा पोसतावु कोरने जुगु पोसतावान दाहड़ु छे। ");
INSERT INTO dhn_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","जु मानुस इना दाहड़े आपसाक उपार राखिन दुख नी देय, चु आपसा मानसो मा नास कोर देयो जासे। ");
INSERT INTO dhn_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","जे मानुस इने दाहड़े काहने वी भातिन काम कोरसे, तेना मानुस काजे हांव मानसोन इचमा गोथु मिटाय नाखीस। ");
INSERT INTO dhn_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","तुमु काहने वी भातिन कामु झुनी कोरता। यी तुमरा आखा रोवनेन जागा मा पीढ़ी गोथा पीढ़ी लोगुन जोलोम नेम कोवायसे। ");
INSERT INTO dhn_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","चु दाहड़ु तुमरे जुगु बेस चुखलु दाहड़ु होयसे। तेने दाहड़े तुमु आपसाक उपार राखिन दुख देजु। तुमु तेने मोहनेन नोवनवे दाहड़े सान्ता गोथा दिसरे दाहड़ेन सान्तु लोगुन आरामोन दाहड़ु मानता रोवजु। ");
INSERT INTO dhn_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","योहोवा मुसा काजे कोयु, ");
INSERT INTO dhn_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","तु इसराएली मानसो काजे कोव: इना मोहनान पोन्दरोवे दाहड़े गोथा सात दाहड़ा लोगुन पोरबु जुगु झोपाट्यान तिहवार वावजु। ");
INSERT INTO dhn_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","पेहले दाहड़े चुखली मिटिंग रोवे। उना दाहड़े तुमु काहने वी भातिन मेहनोतोन काम झुन कोरता। ");
INSERT INTO dhn_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","तुमु सात दाहड़ा लोगुन पोरबु काजे आगठान बादा चोड़ावजु। आठवे दाहड़े चुखली मिटिंग राखजु, आरू पोरबु काजे आगठान बादा चोड़ावजु। यी खास मिटिंग छे। एने तेने दाहड़े तुमु काहने वी भातिन काठलो काम झुन कोरता। ");
INSERT INTO dhn_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","यो पोरबुन टाकलु तिहवार छे, जेरेम चुखली मिटिंग राखनेन खोबोर कोरजु। यु तिहवार पोरबु काजे आगठा मा बादा चोड़ावने, आगठान बादा, ओनोन बादा, ढुरोन बादा आरू पेय बादा हेरा टाकला दाहड़ा पोर चोड़ावने जुगु छे। ");
INSERT INTO dhn_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","यो आखा गोथो जादा योहोवान आरामोन दाहड़ा काजे मानु, आरू आखी भेट, मानता आरू मोरजी से चोड़ावली बादाक छुड़ीन दिसरो छे, जो तुमु पोरबु काजे चोड़ाया कोरजु। ");
INSERT INTO dhn_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","सातवे मोहनेन पोन्दरोवे दाहड़े, जोत्यार तुमु खेतोन मेर एकठी कोरसु तोत्यार पोरबु जुगु सात दाहड़ा लोगुन तिहवार वावजु। पेहले दाहड़े बेसकु चुखलु दाहड़ु होयसे; आठवु दाहड़ु वी बेस चुखलु दाहड़ु होयसे। ");
INSERT INTO dhn_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","पेहले दाहड़े तुमु वारू सी वारू झाड़ोन फोव, खजूरन झाड़ोन डाळ्या, पान्टा वावा झाड़ोन डाळ्या आरू खुदरा मायीन दोंळान डाळ्या लिन आपना पोरबु परमेश्वर ओगोव सात दाहड़ा लोगु खुस रोवजु। ");
INSERT INTO dhn_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","तुमु विरसि सात दाहड़ा लोगुन पोरबु जुगु तेनी जातरान तिहवार वावजु। यी तुमरी पीढ़ी गोथी पीढ़ी लोगुन जोलोम रिती कोवाये। तुमु तिहवार काजे सातवे मोहने वावजु। ");
INSERT INTO dhn_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","तुमु सात दाहड़ा लोगुन छोपाट्या मा रोवजु, एसराएलोन आखा गांवल्या झोपाट्या मा रोवजु, ");
INSERT INTO dhn_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","जेरेसी तुमरी पीढ़ी-पीढ़ी काजे फोम रोवे कि जोत्यार हांव इसराएली मानसो काजे मिसर मुलुक गोथु खोयड़े निकावळु तोत्यार हेनुक झोपट्या मा आसरू आपलु। हांव तुमरू परमेश्वर योहोवा छे। ओस कोरीन मुसा इसराएली मानसो काजे पोरबुन टाकला तिहवार देखाड़्यु। ");
INSERT INTO dhn_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","आरू मुसा इसराएली मानसो काजे यहोवा भोगवानोन तिहवारोन टेम कोवीन सोमवाड़्यु ");
INSERT INTO dhn_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","ओळी योहोवा मूसा सी कोयू, ");
INSERT INTO dhn_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","इसराएली मानसो काजे यो हुकुम आप कि मारेन्चा विजावो कोरने कोरीन कुट सी निकोवलो जेतुन झाड़कान वारलो तेल लीन आवजू कि दिव एक पोट्यू धोपतू रोवे। ");
INSERT INTO dhn_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","हारून तिनाक, मिलाप वावा तम्बू मा, पोरदान खोयड़े सान्तु गोथु सोन्दारे लोगुन पोरबु ओगोच एक सारकु सोजावीन राखसे। यी तुमरी पीढ़ी जुगु जोलोम रिती कोवाये। ");
INSERT INTO dhn_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","हुयो चुखला सोनान भीतड़ा पोर योहोवा ओगोव दिवु एक पोट्यु सोजावीन राखसे। ");
INSERT INTO dhn_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“तुमु मेदा काजे कुसनीन तेरा बारे रूटा बोनावजु। एक एक रूटु दुय किलान बोननो जुवे। ");
INSERT INTO dhn_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","तुमु रूटाक दुय चोव मा योहोवा ओगोव चुखला सोनाना पाटला पोर मेकजु। एक चोव मा छोव रूटा मेकजु। ");
INSERT INTO dhn_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","तुमु आखी चोव मा चुखलो लोबान पुठी मेकजु जेरेसी चे रूटा भेळ फोम देवाड़े वावी चिज बोनिन योहोवा काजे आगठा मा चोहोड़ जाय तोसे। ");
INSERT INTO dhn_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","हारून आखा आरामोन दाहड़े इसराएली मानसो ओगे गोथु वायदान रुपोमा योहोवा ओगोव एक सारका नोवला रूटा चोवेन चोव मेक्या कोरसे। ");
INSERT INTO dhn_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","ये रूटा हारून आरू हेरा पुर्यान होयसे। चे तिनुक चुखला जागाम खासे; काहकि योहोवा काजे आगठा मा चोड़ावली बादा मा गोथो यो हेन्दरू बेस चुखलु वाटु छे। इना पोर हेन्दरो होक छे।” ");
INSERT INTO dhn_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","एक वार काहनी इसराएली बायरोन पुर्यु तेरू बास मिसर देस मा रोवने वावु होतु, इसराएली मानसोन इचमा गोयु। चा पोड़ाव मा चु होतु एने एक इसराएली मानसे आपसात् लोड़ायने लाग्या। ");
INSERT INTO dhn_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","इसराएली बायरोन पुर्यु योहोवा भोगवानोव नावोक भुन्डा बुले कोयु आरू वायकेड़ा उड़ायु। मानसे तिनाक मुसान चा लाया। तेरी आयस्युन नाव सलोमित होतो, जे दान घोरानान दिबरीन पुराय होती। ");
INSERT INTO dhn_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","चे मानसे इसराएली बायोरोन पुर्याक तेने टेमे लोगुन कुंडवाड़ाम राख्या जोत्यार लोगुन योहोवा भोगवानोन बुल तिनाक वारू रीते पोतु नी होय जाय। ");
INSERT INTO dhn_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","योहोवा मुसा काजे कोयु, ");
INSERT INTO dhn_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","तुमु मनख्या तेना वायकेड़ा उड़ावने वावान पोड़ाव मा गोथा खोयड़े लीयावु; आरू जोतरा मानसे वायकेड़ा उड़ातेला सोमया होय चे आखा आपना आपना हात हेरा मुनका पोर मेकु, तोत्यार आखा मोन्डळीन मानसे तिनाक दोगड़ाटने लाग्या। ");
INSERT INTO dhn_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","तु इसराएली मानसो काजे यो वी कोवजी: जु मानुस आपसा भोगवान काजे भुन्डा बुल बुलसे, चु आपसा पापोन भार आपसुत छेलसे। ");
INSERT INTO dhn_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","भोगवानोन नावोन वायकेड़ा उड़ावसे तिनाक मोतोन डोन जोड़से। आखा मोन्डळीन मानसे तिनाक दोगड़ाटसे। जोत्यार कुदु मानुस चु गांवल्यु होत तेने पारकु होय, योहोवा भोगवानोन वायकेड़ा उड़ावसे तिनाक मोतोन डोन जोड़से। ");
INSERT INTO dhn_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","जु मानुस कुदा मानसोक मार देये तिनाक मोतोन डोन जोड़से। ");
INSERT INTO dhn_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","ढुरोक मारने वावु मानुस तेरी नुकसानी आपसु झेलसे तेना ढुरोन बोदलाम ढुर आपे। ");
INSERT INTO dhn_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","कोदाम कुदु मानुस आपसा काहना गांवल्या भास्योन एने बोहोनस्यान चोट लागाड़े ती हेरे पुठी वी तोसोत् होयसे; ");
INSERT INTO dhn_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","चोटोन बोदलाम चोट, डुवान बोदलाम डुवु, दातोन बोदलाम दात। जोसु चु दिसरा मनुसन नुकसानी कोरे, तोसोत् तेरे पुठी होयसे। ");
INSERT INTO dhn_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","ढुरोक मारने वावा मनुसन नुकसानी चु झेलसे; पुन मानसोक मारने वावा मानसोक मोतोन डोन जोड़से। ");
INSERT INTO dhn_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","पारका एने गांवल्या मानसो जुगु एकुत नियोवोन कायदु होयसे; काहकि हांव योहोवा, तुमु भोगवान छे। ");
INSERT INTO dhn_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","मुसा इसराएली मानसो काजे यी वात कोयु। चे भोगवानोन वायकेड़ा उड़ान्याक खोयड़े ली गोया। चां चे तिनाक दोगड़ाटीन मार नाख्या। ओस कोरीन जोसु योहोवा भोगवान मुसा काजे हुकुम आपलु होतु तोसात् इसराएली कोर्या। ");
INSERT INTO dhn_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","योहोवा भोगवान मुसा काजे सिनाय बोयड़ा पोर कोयु, ");
INSERT INTO dhn_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","तु इसराएली मानसो काजे कोवजी; तु तेनु काजे ओसु कोवजी: जोत्यार तुमु तेना मुलुक मा जासु जो हांव तुमुक आप रोयु, तोत्यार तेना मुलुकोन जागु वी योहोवा भोगवान जुगु आराम कोरसे। ");
INSERT INTO dhn_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","तुमु छव साल तक तुमरो खेत वेरीया करजो, आरू छवु साल आपसी आपसी खेतीन वाड़ी न छाटी छाटीन खेतन फसल एखटी करीया करजो। ");
INSERT INTO dhn_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","पुन सातवा सालोम खेतीक वी बेसको आराम जोड़से: योहोवा भोगवानोन आरामोन साल। तुमु तेने साल नी ते आपसा खेतेम वेरू आरू नी आपसा ओंगुरोन वाड़ी मा काटनो कोरजु। ");
INSERT INTO dhn_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","जो काहिन तुमरा काटला खेतोन आपसुत् उगे तिनाक झुन काटता, आरू नी चुटला ओंगुरोन वेलाम गोथा तुड़जु; काहकि इना जागा जुगु बेसकु आरामोन साल होयसे। ");
INSERT INTO dhn_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","पुन खेती आपना आरामोन सालो मा तुमरी, तुमरा चाखरीया, दाहाड़क्या आरू तुमरा विच मा रोहवने वावा पारका मानसो जुगु खानो जोड़्या कोरसे। ");
INSERT INTO dhn_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","आरू तुमरा मुलकोन जतरा बी जनवार हय हेनको वाटे खाणो बी धरतीन आखी मेर मा रयीन रोयसे। ");
INSERT INTO dhn_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","तुमु सात आरामोन साल मोतलोब सात गुना सात वोरीस गिनजु, सात आरामोन सालोन यो टेम चावीस ने नोव सालोन रोवसे। ");
INSERT INTO dhn_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","तोत्यार तुमु सातवा मोहनान दोसवे दाहड़े आखा जागा पोर मटलाबुलन भिरा फुकजु। पोसतावान दाहड़े तुमत आपसा मुलुकोन आखा जागा पोर मोटला फेपारीया फुकजु। ");
INSERT INTO dhn_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","आरू तुमु पोचास साल काजे चुखलु मानजु, आरू मुलुकोन आखा रोवन्या काजे छुटकारान पोरचार कोरजु, यो जुबली वाळो साल कोवायसे। इने साल आखा मानसे आपसा बासोन धोन पोछा हात कोरसे। आखा मानसे आपसा घोरलीयान जा पोछा जात रोवसे। ");
INSERT INTO dhn_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","तुमरे जुगु पोचासवु साल जुबली वावु साल होयसे। तुमु तेन साल बेरता झनी, आरू जो काहीन आपसुत उगसे, तिनाक झुन कटता, आरू जे ओंगुर नी चुटाया तेनु ओंगुरोन वेलाक झुन तुड़ता; ");
INSERT INTO dhn_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","काहाकि चु जुबली वावु साल होयसे। चु तुमरे जुगु चुखलु साल कोवायसे। जो खेतोम उगसे, तुमु चोत् खाजु। ");
INSERT INTO dhn_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","इना जुबली वावा साल मा आखा मानसे आपसा बासोन धोन काजे पोछा हात कोरसे। ");
INSERT INTO dhn_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","कोदाम तुमु आपना काहना मुलकोन भाइस क काहिन वेचसु एने तेरा हातोम रोइन काहिन लेसु, ती एक दिसरा पोर आंधारो झुन कोरता। ");
INSERT INTO dhn_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","पेहेला जुबली वावा सालोन ओवतेन जोतरा साल वीते तेर ओनसारे गिनिन तुमु आपसा मुलुक वावा भास्यो एने बोहोनस्या जुळ मुले लेजु; मेरोन वाचाला सालोन गिनतीन ओनसारे चे तुमुक वेचसे। ");
INSERT INTO dhn_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","कोदाम जादा साल वाचे, ती तुमु भाव बोड़ावजु; पुन कोदाम कोम साल वाचला होय, ती भाव कोम कोरजु; काहाकि जो हुये वेचे, चो मेरोन गिनतिन ओनसारे वेचे। ");
INSERT INTO dhn_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","तुमु एक दिसरा पोर कुहराय झुन कोरता पुन आपसा भोगवानोन बिक मानजु; काहकि हांव तुमरू योहोवा भोगवान छे। ");
INSERT INTO dhn_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","तुमु मारी रिती काजे मानजु, आरू मारा नेम कायदा पोर सोमजी जानीन चालजु; काहकि ओसो कोरने सी तुमु तिना मुलुक मा विगुर बिहये वोसला रोवसु। ");
INSERT INTO dhn_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","धोरती तुमुक मेर पाकाड़ीन आपसे, आरू तुमु पेट भोरीन खाया कोरसु, आरू तिना मुलुक मा बेफिकरिया वोस रोवसु। ");
INSERT INTO dhn_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","आरू कोदाम तुमु कोवु कि सातवा सालोम हामु काय खासु, नी ते हामु वेरजे नी आपना खेतोन मेर काजे एकठी कोरसु? ");
INSERT INTO dhn_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","ती जान लेवु की हांव तुमुक छोटवा सालोम ओसी बोरकोत आपीस, कि धोरतीन मेर तीन वोरीस लोगुन काम आवसे। ");
INSERT INTO dhn_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","तुमु आठवा सालोन मेर जोत्यार लोगुन नी पाके ती लोगुन तुमु जुनली मेरोम गोथा खाता रोवसु। ");
INSERT INTO dhn_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","जागा काजे जोलोम जुगु नी वेचाये, काहकि जागा मारी छे; आरू हेरेम तुमु पारका आरू बाहारला कोवायसु। ");
INSERT INTO dhn_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","बाखुन तुमु आपसा वाटान आखा मुलुकोन जागाक छुड़वने देजु। ");
INSERT INTO dhn_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","कोदाम तुमरू कुदु भाय बोन्यु गोरब्यु होयीन आपसी जागामा गोथु थुड़ोक वेच देये, ती तेरा घोराना मा गोथु जो आखा गोथो धोड़े होय चु आवीन आपसा भायबोन्यान वेचलु वाटु छुड़वी लेय। ");
INSERT INTO dhn_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","कोदाम कुदु मानुसो जुगु कुदु छुड़ावनेवावो नी होय, आरू तेर जु ओतरो धोन होय कि आपसुत् आपसा वाटाक छुड़वी ली सोके, ");
INSERT INTO dhn_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","ती चु एइना सालोन ओनसारे गिन लेय, जिने साल होयु तिनाक वेचलु, तेर हिसाबे तिनाक दाम आपसे। तोत्यार तेरो धोन पोछो तेरोत् होय जासे। ");
INSERT INTO dhn_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","कोदाम तेरे जुव आपसो वाटु पोछु छुड़ेवने जुगु धोन नी होय, ती जागु लेनेवावान हातोम जुबली वावे साल लोगुन रोवसे। जुबली वावा साल मा जागु आपसुत् छुट जासे आरू वेचने वावान पोछु होकम होय जासे। ");
INSERT INTO dhn_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","ओळी कोदाम कुदु मानुस मोटला भितड़ा वावा सोहरोम रोवने जुगु घोर वेचे, ती चु वेचनेन ओळतेन साल भोर मा तिनाक छुड़वी कोरे, कोवे ती आखु साल भोरीन तिना मानुस काजे छुड़ोवनेन होक रोवसे। ");
INSERT INTO dhn_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","पुन कोदाम साल भोरीन नी छुटे, ती चो घोर जो मोटला भितड़ा वावा सोहरोम छे मुले लेने जुगु बोनलो रोवे, आरू पीढ़ी-पीढ़ी लोगुन तेरात् ओवलियाद जुगु बोनलो रोवे, आरू जुबली वावा सालोम वी नी छुटे। ");
INSERT INTO dhn_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","पुन विगुर मोटला भितड़ा वावा गांवोम वावा घोर ते देसोन खेतो जोसा गिनाये; जिन्दरो छुड़ेवनो वी होय सोके, आरू चे जुबली वावा साल मा छुट जासे। ");
INSERT INTO dhn_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","ओळी वी लेवी मानसोन आपसा वाटान सोहरोन जे घोरे छे तेनुक लेवी मानसो जोत्यार मोरजी पोड़े तोत्यार छुड़वी लेय। ");
INSERT INTO dhn_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","आरू कोदाम लेवी मानुस आपसु वाटु नी छुड़वे, ती चो वेचलो घोर जे हेरा वाटान सोहोरोम जुबली वावा सालोम छुट जाय; काहकि इसरारली मानसोन इचमा लेवी मानसोन वाटु हेन्दरा सोहरोम चे घोरूत् छे। ");
INSERT INTO dhn_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","पुन तिन्दरा गावोन च्यारू मेर ढुरोक चारनेन जागु नी वेचाये; काहकि चु जोलोम जुगु तेन्दरु वाटु कोवाये। ");
INSERT INTO dhn_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","कोदाम तारू भाय बोन्यु गोरीब होय जाय, आरू तेरे पोर तुसेक गीन आवे ओसो होय, ती तु तिनाक सोमावजी; चु पारका एने वाट चाला जोसु रोवे। ");
INSERT INTO dhn_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","तेरे जुळ इयाज एने वोदु पोस्या झुन लेये; भोगवानोन बिक मानजी; जेरेसी तारू भाय बोन्यु तारे पुठी जिवतु रोय सोके। ");
INSERT INTO dhn_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","तिनाक इयाजता रूप्या झुन आपे, आरू नी काय खानेन सोमान नोफु कोमायने कोरीन आपे। ");
INSERT INTO dhn_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","हांव तुमरू योहोवा भोगवान छे; हांव तुमुक कोनान मुलुक आपने जुगु आरू तुमरू भोगवान रोवीस ओस कोरीन तुमुक मिसर मुलुक गोथु निकाव लावलु छे। ");
INSERT INTO dhn_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","कोदाम तारू भायबोन्यु तारे ओगोव गोरब्यु होयीन आपसा काजे तारा हातोम वेच देय, ती तेरेसी पावोर जोसु काम झुन कोरावतु। ");
INSERT INTO dhn_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","चु तार पुठी दाहड़क्यु एने वाट चालु जोसु रोवे, आरू जुबली वावा साल लोगुन पुठी रोवी चाखरी कोरतु रोवे; ");
INSERT INTO dhn_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","तोत्यार चु बाळ-बच्चा भेळ तारेनचा गोथु जात रोवे, आरू आपसा घोरल्या मा आरू आपसा बासोन वाटा मा पोछु जात रोवे। ");
INSERT INTO dhn_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","काहकि चे मारा पावरीया छे, जेनुक हांव मिसर मुलुक गोथु निकाय लावलु छे; एरकरीन चे दासन रीतीये नी वेचनो। ");
INSERT INTO dhn_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","तेर पोर ओनाड़ु बोनीन होक झुन कोरतु; आपसा भोगवानोन बिक मानतु रोवजी। ");
INSERT INTO dhn_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","तारा जे पावोर-पावेरनिया होय चे तुमरा च्यारू मेरोन जातिम गोथा रोवे, आरू पावरीया आरू पावेरनिया तेनुम गोथा मुले लेजु। ");
INSERT INTO dhn_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","जे वाट चाला तुमरे इचमा पारका बोनीन रोवसे, तेनुम गोथा आरू तेन्दरा घोरानाम गोथा वी जे तुमरे आड़े धोड़े होय, आरू तुमरा मुलुक मा पोयदा होया होय, तेनुम गोथा पावोर आरू पावेरनिया मुले लेजु; आरू चे तुमरोत् धोन कोवायसे। ");
INSERT INTO dhn_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","तुमु आपसा पुर्याक वी जे तुमरे ओळतेन होयसे तिन्दरा हकोम कोर सोकु, आरू त्या हेनको वाटो कहवायसे; हेनुम गोथा तुमु जलोम आपसे जुगु पावोर लिया कोरजु, पुन तुमरा भायबोन्या जे इसराएली होय हेनु पोर तुमरो होक ओनाड़ा बनीन झुन कोरता। ");
INSERT INTO dhn_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","कोदाम तुमरे पुठी रोवने वावु पारकु एने वाट चाला मा मातभोर होय जाय, आरू तेरे ओगोव तारू भाइस गोरीब होयीन आपसा काजे तारे ओगोव पारकु एने वाट चसलु एने आपसी ओवलियाद काजे वेज देय, ");
INSERT INTO dhn_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","ती तेरे वेचायनेन ओळतेन चु ओळी पोछु छुट सोके; तेरा भास्यो मा गोथु कुदु वी छुड़वी सोके, ");
INSERT INTO dhn_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","तेरू काकु, कुदु भाईस, आरू तेरा घोराना मा कुदु वी जु तेरे साते वावु छे छुड़वी सोके; निन्ते कोदाम चु मातभोर होय जाय, ती आपसाक वी छुड़वी सोके। ");
INSERT INTO dhn_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","चु आपसाक मुले लेनेवावा पुठी आपसा वेचायनेन साल गोथु जुबली वावा साल लोगुन हिसाब कोरे, आरू तेरा वेचायनेन किमोत जोतरा सालोन गिनतीन ओनसारे होय, मोतलोब जु दाम दाहाड़क्यान दाहड़ान जोसु रोवसे। ");
INSERT INTO dhn_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","कोदाम जुबली वावु साल आवने घोना साल रोवे, ती जोतरा रूप्यान चु वेचायलु होतु, तेरेम गोथु चु आपसाक छुड़ोवनेन दाम तोतरा सालोन ओनसारे आप देय। ");
INSERT INTO dhn_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","कोदाम जुबली वावु साल आवने थुड़ाक साल रोया होय, ते वी आपसा मालीक पुठी हिसाब कोरीन आपसा छुड़ावने दाम तोतरात् सालोन ओनसारे आप देय। ");
INSERT INTO dhn_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","चु आपसा मालीक पुठी तेना दाहाड़क्या जोसु रोवे जोसु वोरीसदाय दाहाड़की नोक्खी कोरली होय; आरू तेरू मालीक तेरे पोर तार ओगोव वातड़ु बोनीन होक नी कोरनो जुवे। ");
INSERT INTO dhn_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","आरू कोदाम चु इनु रिती सी नी छुटे, ती चु जुबली वावा सालोम आपसा बाळ-बच्चा भेळ छुट जाय। ");
INSERT INTO dhn_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","काहकि इसराएली मारात् चाखरीया छे; चे मिसर मुलुक गोथा मारात् निकावला चाखरीया छे; हांव तुमरू योहोवा भोगवान छे। ");
INSERT INTO dhn_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","तुमु आपसा जुगु मुरती झुन बोनावता, आरू नी काहनी खुन्दली मुरती आरू खाम्बा काजे उबु कोरू, आरू नी आपसा मुलुकोम वांदने कोरीन दोगड़ाक घोड़ीन उबु कोरू; काहकि हांव तुमरू योहोवा भोगवान छे। ");
INSERT INTO dhn_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","तुमु मारा आरामोन दाहड़ान पाळनी पावजु आरू मारा चुखला जागान बीक राखजु; हांव योहोवा भोगवान छे। ");
INSERT INTO dhn_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","कोदाम तुमु मारा कायदा पोर चालु आरू मारा हुकुम काजे मानीन तेनुन पाळनी पाळजु, ");
INSERT INTO dhn_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","ती हांव तुमरे जुगु टेम टेम पानी पाड़ीस, आरू धोरती आपसी मेर उगाड़से, आरू खोयड़ान झाड़का पोर आपसो आपसो फोव फोळसे; ");
INSERT INTO dhn_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","यां लोगुन कि तुमु ओंगुर तुड़नेन टेमे दावनी कोरता रोवसु, आरू वेरनीन टेम पोर वी पेट भोरीन खाया कोरसु, आरू तुमुक गोंहोवता रूटा खाया कोरसु, आरू आपसा मुलुकोम बेफिकरीया रोया कोरसु। ");
INSERT INTO dhn_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","आरू हांव तुमरा मुलुकोम सुक शान्ति आपीस, आरू तुमु सुवसू आरू तुमुक बिहाड़नेवावो नी रोवे; आरू हांव तुमरा देसोम जोंगली जोनवारे जे मानसोन नुकासानी कोरे तेनुक रोवने नी देयो, आरू काहनो वी मुलकेम वावा तुमरे भुने तोलवार नी चालाड़े। ");
INSERT INTO dhn_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","आरू तुमु आपसा वेरी काजे कुटिन ढासाड़ देसु, आरू चे तुमरी तोलवार सी हिट पोड़से। ");
INSERT INTO dhn_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","तुमरेम पाच मानसे सोव जोनाक आरू सोव मानसे होजार जोनाक नी बोदे; आरू तुमरा वेरी तुमरे ओगोव हिट पोड़से; ");
INSERT INTO dhn_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","आरू हांव तुमरे भेनी गिनोन निंगा राखीस आरू तुमुक बोरकोत आपीस आरू गिनाये नी ओसा होय जासु, आरू तुमरे पुठी मारू वायदु पुरू कोरीस। ");
INSERT INTO dhn_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","आरू तुमु मेकला जुनला ओनो काजे खाया कोरसु, आरू नोवलो ओन रोवसे ते वी जुनलो ओन खासु। ");
INSERT INTO dhn_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","हांव तुमरे विच मा रोया कोरीस, आरू मारो जीव तुमरे सी घाड़ाय नी कोरे। ");
INSERT INTO dhn_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","आरू हांव तुमरे विच मा चाल्या फिर्या कोरीस, आरू तुमरू भोगवान रोवीस, आरू तुमु मारा मानसे बोना रोवसु। ");
INSERT INTO dhn_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","हांव योहोवा, तुमरू परमेश्वर छे। हांव तुमुक मिसर मुलकोम गोथु निकाय लावलु कि तुमु मिसर वावान पावरीया बोनला नी रोवु; आरू हांव तुमरा जुड़ाक तुड़ नाख्यु, ततरू तुमु सुदु उबु कोरीन चालाड़्यु। ");
INSERT INTO dhn_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","कोदाम तुमु मारी नी सोमवु, आरू एनू आखा हुकुम काजे नी मानसु, ");
INSERT INTO dhn_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","आरू मारा कायदा काजे उदुड़ जानसु, आरू तुमरो जीव मारा नियाव सी घाड़ाय कोरू, आरू तुमु मारा आखा हुकुमोन पाळोन नी कोरसु, पुन मारा वायदाक तुड़सु, ");
INSERT INTO dhn_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","ती हांव तुमरे सी ओसु कोरीस; मोतलोब हांव तुमरे सी डोगाय जाईस, आरू टीवीन बिमारी आरू सेरी सी मांदु पाड़ीस, आरू जेरेसी तुमरा डुळा धुंदवाय जासे, आरू तुमरे मोन धोनो घाबराय जासे। आरू तुमरा बिज बिगड़ी जासे, काहकि तुमरा वेरी तुमरी मेर खाय जासे; ");
INSERT INTO dhn_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","हांव तुमरे भेनी गोथु आड़ु भाय लिस, जेरेसी तुमु आपसा वेरी ओगोव हार जासु। जिनुसी तुमु घाड़ाय कोरे, चेत् तुमरे पोर होक कोरसे। तुमरे पोछोळ कुदु नी पोड़े, तीवी तुमु ढासता रोवसु। ");
INSERT INTO dhn_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","आरू कोदाम तुमु इनी वातोन ओळतेन वी मारी नी सोमवु, ती हांव तुमरा पापोन कोरता तुमुक सातगुना वेला आपीस, ");
INSERT INTO dhn_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","आरू हांव तुमरा ताकोतोन घाड़ाय काजे तुड़ दीस, आरू तुमरे जुगु वादवा काजे लुहड़ा जोसु वातड़ु, आरू धोरती काजे पीतवो जोसु बोनाय दीस की पानी नी पोड़से। ");
INSERT INTO dhn_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","तो्यार धोरती पोर तुमरी आखी मेहनोत वायबार होय जासे; काहकि धोरतीन मेर नी उगे आरू खोयड़ान झाड़े फोव नी फोवे। ");
INSERT INTO dhn_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","कोदाम तुमु मारे विरूद् चालतात् रोवसु, आरू मारो कोवनो नी मानु, ती हांव तुमरा पापोन ओनसारे तुमरे पोर आरू सातगुना वेला आपीस। ");
INSERT INTO dhn_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","आरू हांव तुमरे विच जोंगली जोनवारे मुकलीस, जे तुमरा पुर्याक तुमरेनचा गोथा चुटलीन जात रोवसे, आरू तुमरा घोरून ढुरोक फाड़ खासे, आरू तुमरी गिनती कोम होय जासे, , जेरेसी तुमरी सोयड़ोक सुनी पोड़ जासे। ");
INSERT INTO dhn_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","\"ओळी कोदाम तुमु एनू वातो पोर वी मारी आपली गरा सी नी सुदरू, आरू मारे विरुद् चालतात् रोवसू, ");
INSERT INTO dhn_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","ती हांव वी तुमरे विरुदच चालीस, आरू तुमरा पापोन कोरता हांव आपसुत् तुमुक सातगुना दीस। ");
INSERT INTO dhn_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","हांव तुमरे पोर वेरीन होमलु कोरावीस, जु वायदु तुड़नेन पुरून पुरू बोदलु लेसे; आरू जो्त्यार तुमु आपसा सोहरोम एकठा होयसु ती हांव तुमुरे पोर काळ मुकलीस आरू तुमु वेरीन हातोम धोराय जासु। ");
INSERT INTO dhn_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","जोत्यार हांव तुमरे जुगु खानेन ओन तुमरे जुळ गोथु छेटु कोर दीस, तोत्यार दोस बायरा एकुत तोवा पोर रूटा बोनावसे, आरू चे तुमुक रूटा तुली तुलीन आपसे, आरू तुमु रूटा खासु ती वी नी आफरू। ");
INSERT INTO dhn_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","ओळी कोदाम तुमु एनी वातोन ओळतेन वी मारी नी सोमवु, आरू मारे विरुद् चालता रोवसु, ");
INSERT INTO dhn_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","ती हांव मारो नियाव तुमरे विरुद् चालीस, आरू तुमरा पापोन कोरता तुमुक सातगुना लोगुन वेला ओवी जादा आपीस। ");
INSERT INTO dhn_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","आरू तुमुक आपसा पुर्या आरू पुरायटान मास खानो पोड़से। ");
INSERT INTO dhn_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","आरू हांव तुमरा डाहडान पुजा कोरनेन उचला जागाक उदार दीस, आरू तुमरी धुपोन वेदी काजे नास कोर दिस। तुमरा देवता काजे उदेरला मुरतिया पोर तुमरा धोड़ नाखीस। आरू मारू जीव तुमरे सी सीगी कोरसे। ");
INSERT INTO dhn_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","आरू हांव तुमरा सोहरोक उजाड़ दिस, आरू तुमरा चुखला जागाक उजाड़ दिस, आरू तुमरा सुकोन गोंदायन्या काजे नी सुंगो। ");
INSERT INTO dhn_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","आरू हांव तुमरा मुलुक काजे सुनलो कोर दिस, आरू तुमरा वेरी जे जां रोवे चे इनी वातोन कोरता ओका बोकी होय जासे। ");
INSERT INTO dhn_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","आरू हांव तुमुक बेसका मुलकोम रिवन्या तिवन्या कोरीस, आरू तुमरे विरूद् आपसुत् तोलवार काजे निकाव लीस। तुमरो मुलुक सुनलो होय जासे। तुमरो सोहोर उजाड़ होय जासे। ");
INSERT INTO dhn_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","जोत्यार लोगुन तुमु आपसा वेरीन मुलकोम रोवसु आरू तुमरी जागा सुनली पोड़ रोवसे, तोत्यार लोगुन धोरती आरामोन सालोन खुसी सी पाळनी पाळसे। धोरती आराम कोरसे आरू आरामोन सालोन खुसी सी पाळनी कोरसे। ");
INSERT INTO dhn_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","जोतरा दाहडा हुयो सुनलो पोड़ रोवसे तोतरा दाहड़ा तिनाक आराम रोवसे, मोतलोब जो आराम तुमरे होंया रोवते तुमरा आरामोन टेम मा नी जोड़्यो होसे चो तव जोड़से। ");
INSERT INTO dhn_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","आरू तुमरे मा गोथो जे वाचला रोवसे आरू आपसा वेरी मुलकोम होसे तिन्दरा मोनोम बिक बोसाड़ दीस; आरू चे पान्टा खोकेड़से ती वी ढास जासे, आरू चे ओसा ढाससे जोसा तोलवार सी वाचने ढासे, आरू कुदु पोछोव नी पोड़े ती वी चे झोटवायता ने पोड़ता जासे। ");
INSERT INTO dhn_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","जोत्यार कुदु पोछोव नी आवे ती वी ओसा जासे जोसा तोलवारोन बीके एक दिसरान आफठायीन पोड़ जासे, आरू तुमरेम आपसा वेरी ओगोव उबरोवने हेमो नी रोवसे। ");
INSERT INTO dhn_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","तोत्यार तुमु मुलको मा पुगीन नास होय जासु, आरू तुमरा वेरीन जागा तुमुक खाय जासे। (तोत्यार तुमु मुलको मा पुगीन मोर जासु, तुमरा वेरीन जागा मा गाड़ाय जासु) ");
INSERT INTO dhn_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","आरू तुमरेम गोथा वाचला रोवसे चे आपसा वेरीन मुलकोम आपसा गुनान कोरता गोळ जासे; आरू आपसा डाहडान गुनान कामोन कोरता वी चे तिन्दरेन्द तोसा गोळ जासे। ");
INSERT INTO dhn_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","पुन कोदाम चे आपसा आरू आपसा बासोन गुनाक मान लेय, मोतलोब जे मारे साते धुकु कोरीन आरू मारा कोयान नी चाल्या। ");
INSERT INTO dhn_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","ओतरान कोरता हांव हेन्दरे विरुद् चाल्यु, आरू हेनुक वेरीन मुलकोम ली आवलु, कोदाम चे आपसा वातड़ा जीयोक निचवो कोरसे, आपसा गुनान डोन काजे मान लेसे। ");
INSERT INTO dhn_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","ती हांव याकुब, इसहाक आरू ओबराहाम पुठी वायदु बांदलु चु फोम कोरीस, हांव तुमरा जागा काजे फोम कोरीस। ");
INSERT INTO dhn_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","पुन चो देस हेन्दरे गोथो पेहेल सुनलो होयीन पोड़लो रोवसे, आरू हेन्दरे विगुर रोवीन वी आपसा आरामोन टेम काजे मानतो रोवे; आरू चे मानसे आपसा गुनान डोन काजे मानसे, ओतरान कोरता कि हुये मारा हुकुम काजे नी मान्या, आरू हेन्दरा जीयो काजे मारा नेम सी घाड़ाय होती। ");
INSERT INTO dhn_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","ओतरा पोर वी जोत्यार चे आपसा वेरीन मुलकोम होसे तोत्यार हांव तेनुक ओस कोरीन नी छुड़ो, आरू नी हेनुसी ओसु सिगी कोरो कि हेन्दरो नास कोर नाखो आरू आपसा वायदा काजे तुड़ दोम जो हांव हेनुसी वायदु कोरलु होतु; काहकि हांव हेन्दरू योहोवा भोगवान छे; ");
INSERT INTO dhn_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","पुन हांव हेन्दरी भोलाय जुगु हेन्दरा बासो सी बान्दला वायदा काजे फोम कोरीस; जेनुक हांव आड़जात्यान डुळा ओगोव मिसर मुलकोम गोथु निकावीन लायु कि हांव हेन्दरु भोगवान कोवायो; हांव योहोवा भोगवान छे। ");
INSERT INTO dhn_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","जे-जे नेम कायदा आरू नेम आरू हुकुम योहोवा भोगवान आपसे वोगे गोथु इसराएली मानसो जुगु सिनाय बोयड़ा पोर मुसान लारे कोयु चे येत् छे। ");
INSERT INTO dhn_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","योहोवा भोगवान मुसा काजे कोयु, ");
INSERT INTO dhn_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“ इसराएली मानसो काजे ओसु कोवजी कि जोत्यार खास मानता माने, ती मानता कोरला जीव तारे कोवनेन ओनसारे योहोवा भोगवानोन होयसे; ");
INSERT INTO dhn_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","एरकरीन कोदाम चु वीस सालोन नीते हेरेसी जादा आरू तीन वीस साल गोथु कोम उमोरोन ओदमी होय, ती तेरे जुगु चुखला जागान चांदीन सिक्कान ओनसारे पोचास सिक्का कोवाये। ");
INSERT INTO dhn_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","कोदाम ची बायोर होय, ती तीस चांदीन सिक्का रोवसे। ");
INSERT INTO dhn_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","ओळी कोदाम तेरी उमोर पाच साल नीते तेरेसी जादा आरू वीस साल गोथा कोमोन होय, ती पुर्या जुगु वीस सिक्का, आरू पुराय जुगु दोस सिक्का। ");
INSERT INTO dhn_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","कोदाम तेन्दरी उमोर एक मोहनान नीते तेरेसी जादा आरू पाच साल गोथी कोम होय , ती पुर्या जुगु पाच सिक्का आरू पुर्या जुगु तीन सिक्का कोवाये। ");
INSERT INTO dhn_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","ओळी कोदाम तेरी उमोर तीन वीस साल होय नीते तेरेसी जादा होय, चु ओदमी होय ती तेर जुगु पोन्दरे सिक्का, आरू बायोर जुगु दोस सिक्का कोवाये। ");
INSERT INTO dhn_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","पुन कोदाम कुदु ओतरू गोरीन होय कि पुजारान आकलो दाम आपी नी सोके, ती तिनाक पुजारा ओगोव उबु कोरजु, आरू पुजारू तेर जुगु टोका आकसे, मोतलोब जोतरी मानता कोरनेवा सी होय सोके, पुजारू तेरेत हिसावे मेकसे। ");
INSERT INTO dhn_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“ओळतेन जेनु ढुरोम गोथा योहोवा भोगवान काजे चोड़ावु, कोदाम ओसी काहनी मानता होय, ती जु ढुर कुदु योहोवा भोगवाग काजे आपे चो चुखलो कोवायसे। ");
INSERT INTO dhn_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","मानता चोड़ावने वावु काहने वी भातीन नी बोदले, नी ते चु बुरान बोदले वारू, आरू नी वारलान बोदलाम भुन्डो आपे; आरू कोदाम चु तेना ढुरोन बोदलाम दिसरो ढुर आपे, ती चो आरू हेरू बोदलु दुयु चुखला कोवायसे। ");
INSERT INTO dhn_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","कोदाम चो ढुर विटोळ होय, जिनाक योहोवा भोगवान काजे चोड़ावा मा नी चोड़ाया होय, ती मानता राकने वावु मानुस ओसु ढुर पुजारा ओगोव उबराखसे। ");
INSERT INTO dhn_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","पुजारू ढुरोक पारेखसे की चो वारू होय की नी। जोसो पुजारा काजे पारोखने मा मालुम पोड़े , तोसोत् मानसे। ");
INSERT INTO dhn_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","पुन कोदाम मानता राखने वावु तिनाक काहने रिते छुड़ावने हिन्डे, ती जु दाम पुजारू कोवसे तेरेम पाचवु वाटु आरू जुड़ीन आपसे। ");
INSERT INTO dhn_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“ओळी कोदाम कुदु मानुस आपसा घोरो जुगु मानता मानतु होय कि हेरो घोर मारा पोरबु जुगु चुखो रोवे, ती पुजारू तेरा वाराम विचारीन कि वारू छे की भुन्डो छे; आरू जोतरो पुजारू कोवे तेर हिसाबे दाम होतरोत रोवसे। ");
INSERT INTO dhn_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","आरू कोदाम घोरोक चुखो कोरावने वावु तिनाक छुड़ेवने हिन्डे, ती जोतरा रूप्या पुजारू तेरो दाम कोयु होय तेरेम रोईन पाचवु वाटु आरू बोड़ावीन आपे, ती चो घोर तेरोत रोवसे। ");
INSERT INTO dhn_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“कोदाम कुदु मानुस आदसी जागान वाटु योहोवा भोगवान जुगु चुखी कोरावने चाहाय, ती हेरो दाम ऐर ओनसारे होयसे कि तिना खेतोम कोतरो बिज पोड़से; जोतरा जागामा कांगनी भोरीन जोव गोंहोव पोड़े तोतरा जुन दाम पोचास चांदीन सिक्का कोवायसे। ");
INSERT INTO dhn_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","कोदाम चु जुबली वावा सालोम चुखो कोरावे, ती तेरो दाम तार कोवले होयनो जुवे। ");
INSERT INTO dhn_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","पुन कोदाम चु जुबली वावा सालोन ओळतेन आपसा खेतोन मानता मानसे, ती जोतरा साल आवने वावा जुबली वावा साल वाच रोवसे, तेर हिसाबे पुजारू खेतोन हिसाब लागाड़से, आरू तुमरे हिसाबो मा सी कोम होये। ");
INSERT INTO dhn_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","आरू कोदाम खेतोन चुखो कोरावने वावु तिनाक छुड़वी लेनो चाहाय, ती जो दाम पुजारू कोवलु तेरेम गोथो पाचवु वाटु आरू वोदाड़ीन आपसे, ती खेत तेरोत रोवसे। ");
INSERT INTO dhn_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","पुन कोदाम चु खेत काजे छुड़ेवने नी चाहाय, कोदाम चु आपसा खेतोक दिसरा मानसोक वेच देसे ती पोछो छुड़ाय नी सोके। ");
INSERT INTO dhn_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","पुन जोत्यार चु खेत जुबली वावा सालोम छुटे, तोत्यार पुरी रिती सी चोड़ावला खेतो जोसो योहोवा भोगवान जुगु चुखलो कोवाये, चु पुजारान आपसु जागु होय जासे। ");
INSERT INTO dhn_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","ओली कोदाम कुदु आपसो मुले लेदला खेत, जु आपसु वाटान खेतोन नी रोवे, योहोवा जुगु चुखलो कोवायसे। ");
INSERT INTO dhn_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","ती पुजारू जुबली वावा साल लोगुन हिसाव कोरीन तिना मानुस जुगु जोतरो कोवे तोतरोत् चु योहोवा जुगु चुखो जानीन तेनेत् दाहड़े आप देय। ");
INSERT INTO dhn_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","जुबली वावा साल मा चु खेती तेरेत् होकोम जेरेसी चु मुले लेदु होय ओळी आय जाय, जेरू खास वाटु छे तेरूत् पोछु होय जाय। ");
INSERT INTO dhn_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","आखो हिसाब चुखला जागान तुलो मा होयसे। चांदीन एक सिक्कु बारे गोरामोन होयसे। ");
INSERT INTO dhn_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“पुन पावन्या ढुरोन पेहलो वाछड़ो, जो पेहलो होयने कोरता योहोवा भोगवानोन कोवाये, तिनाक कुदु मानता नी मानसे; चाहय चो वाछड़ो होय, चाहाय गाडरो बुकड़ीन गिदल्यो, चो योहोवा भोगवानोन छे। ");
INSERT INTO dhn_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","बाखुन कोदाम चो विटोळ ढुरोन होय, ती तिनाक चुखो कोवाड़नेवावु तिनाक पुजारान कोवला दामोन ओनसारे तेरु पाचवु वाटु आरू वोदाड़ीन छुड़ाय सोके; आरू कोदाम चु नी छुड़ावे, ती पुजारान कोवला दामोन ओनसारे वेचाय जाय। ");
INSERT INTO dhn_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“बाखुन आपसी आखी चिजोम गोथो थुड़ोक कुदु योहोवा भोगवान जुगु चोड़ाया कोरे, चाहाय मानुस होय चाहाय ढुर, चाहाय आपसा वाटान खेत होय, ओसी काहनी चोड़ावली चिज नी वेचाये आरू नी छुड़वे; जो काहिन चोड़ावलो छे चो योहोवा जुगु बेसको चुखलो कोवाये। ");
INSERT INTO dhn_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","मनुस मा गोथो जो काहिन मोतोन डोन जुगु चोड़ावलो होय छुड़वी नी सोके; पाको चो मार नाख्यो जाय। ");
INSERT INTO dhn_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“ ओळी खेतीन मेरोन दोसवु वाटु, चाहाय चु खेतीन बिज होय चाहाय झाड़ोन फोव, चो योहोवा भोगवानोन छे; चो योहोवा जुगु चुखलो कोवाये। ");
INSERT INTO dhn_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","कोदाम कुदु आपसा दोसवा वाटाम गोथु काहिन छुड़ेवने चाहाय, ती पाचवु वाटु वोदाड़ीन तिनाक छुड़ावे। ");
INSERT INTO dhn_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","आरू गाय-बुईल, आरू गाडरा-बुकड़ा, जे-जे ढुरे गिनने जुगु लाकुड़ोन नेचा सी निकवी जाने वावा छे तेरो दोसवु वाटु, दोस दोस पोछोव एक एक ढुर योहोवा जुगु चुखलो कोवाये। ");
INSERT INTO dhn_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","कुदु वारू भुन्डान पारोख नी कोरे, आरू नी तेर बोदलाम; आरू कोदाम कुदु तेर बोदले वी लेये, ती चो आरू तेरे बोदले वावो दुयु चुखला कोवाये; आरू चो कोदी नी छुड़ावसे।” ");
INSERT INTO dhn_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","जो हुकुम योहोवा भोगवान इसराएली मानसो जुगु सिनाय बोयड़ा पोर मुसा काजे आपलु होतु चे येत् छे।");
INSERT INTO dhn_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","योहोवा परमेश्वर क दास मुसान मरनेन बाद मा भगवान मुसान चाकरिया योहोसु सी कयो जो नुन क पोर्‌यो हुतो, ");
INSERT INTO dhn_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","“म्हार चाकरीयो मुसा मर गयो; एरकरता हांय तु उठ, कनाठ्यु बांध, आरु ओका सब प्रजा समेत यरदन क पार होईन उका देशम जा जेका हाव उनाक मतलब इसराएली लोगहन क आपो। ");
INSERT INTO dhn_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","उका वचन क सारको जो हाव मुसा क सी कयो, मतलब जेका जेका जागा पर तुमु पाये धरसे चा सब हाव तुमुक सब सोप देदु छे। ");
INSERT INTO dhn_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","जंगल आरु उना लबानोन सी लगाड़ीन मोटली नदी फरात तक, आरु हित्ती जातीन लोगहन क देश सी लगाड़ीन मटला दर्या तक, सारो देश तुमरो हुय जासे। ");
INSERT INTO dhn_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","तारा जीवन भर कुई तार सामने उबा नी रय सकजे; जोसु हाव मुसा जु रयु तोसु तार जु भी रईस; आरु नी ते हाव तुखे धोकु दीस, आरु नी तुखे सुड़ो। ");
INSERT INTO dhn_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","एरकरता हिमत बाँधीन वातड़ो हुय जा; काहकी जेका देश क आपने न शपथ हाव इना लोगहन क हाहला सी खाई हती उकान हक तु हेनको करीस। ");
INSERT INTO dhn_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","ओतरो होय कि तु हियाव बाँधीन आरु मजबुत वातड़ो होईन जी नियममार दास मुसु तुखे आप देदु छे उना सब क अनसारे करने मा चोक्सी करनु; आरु उका सी नी ते डाखरे वोगे फिरनु आरु नी जेवड़े, तव जा जा तु जासे चा तारो काम सफल होयसे। ");
INSERT INTO dhn_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","नियम क यी किपात तार चित्त सी कभी नी उतरसे, ओका मा दाहड़ुन रात ध्यान दी रवजी, एरकरता कि जो काहय उका मा लिखलो छे उका अनसारे करने क तु चोक्सी करे; काहकी ओसोज करने सी तारा सब काम सफल होयसे, आरु तु प्रभावशाली होयसे। ");
INSERT INTO dhn_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","काय हाव तुखे आदेश नी देदु? हिमत बाँधीन वातड़ो हुय जा; बीह मा, आरु थार मन कोमजुर नी होयनो जुवे; काहकी जा जा तु जासे चा चा तार योहोवा परमेश्वर तार साथे रवसे।” ");
INSERT INTO dhn_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","तव योहोसु ने इसराएली लोगहन क सरदार क यो हुकुम दिदो, ");
INSERT INTO dhn_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","“छावनी मा उरा परा जाईन प्रजा क लोगहन क यो आदेश आप, कि आपने आपने क करता खानो तयार कर राखु; काहकी तीन दाहड़ान माहयता तुमुक ओका यरदन पार उतरीन उका देश क आपना हक मा लेने करिन जानु छे जेका तुमरु योहोवा परमेश्वर तुमरा हक मा आपने वाळो छे।” ");
INSERT INTO dhn_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","आर योहोसु रुबेनिया, गादिया, आरु मनश्शे क आदा ओवलियाद क लोगहन सी कयो, ");
INSERT INTO dhn_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","“जी वात भगवानन दास मुसु तुमुक कयो हतो कि तुमरु परमेश्वर योहोवा भगवान तुमुक आराम आपतु छे, आरु यी देश तुमुक आपसे, उकान फोम करु। ");
INSERT INTO dhn_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","तुमरा बायरा, बाल-बोच्‌चा, आरु पशु ते ओका देश मा रया जो मुसु तुमुक यरदन क ओका पार देदा, पुन तुमु जा शुरवीर होय पाँति बाँधीन आपना भाइस्यो क ओगव ओगव पार उतर चालु, आरु उकान मदत करु; ");
INSERT INTO dhn_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","आरु जब योहोवा भगवान उका ओसो आराम आपसे जोसो चो तुमुक आप्यो छे, आरु चा भी तुमरु परमेश्वर योहोवा भगवान क आपला ओसो देश क आधिकारी होय जासे; तव तुमु आपना आधिकारी क देश मा, जा योहोवा क दास मुसु यरदन क इन पार दाहड़ु बुडनेन तरफ तुमुक आपलो छे, पछा फिरीन ओको हक हुयसे।” ");
INSERT INTO dhn_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","तव योहोसु क जवाब दिदो, “जो काहय तु आमुक करने क हुकुम दिदयो त्यो आमु करसु, आरु जा का तु आमुक मुकलसे चा आमु जासु। ");
INSERT INTO dhn_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","जोसा कि आमु सब वात मा मुसाक मानता हता तोसाज तारी भी वात मानसु; ओतरो होय कि योहोवा परमेश्वर जोसो मुसा क साथे रवतु हतु तोसु तार साथे भी रवे। ");
INSERT INTO dhn_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","कुई काह नी होय जु तार विरुद बलवा करे, आरु जोतरी हुकुम तु आप उकाह हुकुम क नी माने, ते उकाह मारीन नाख देदा जासे। पुन तु मजबुत वातड़ो आरु हिमत बाँधीन रय।” ");
INSERT INTO dhn_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","तव नुन क पोर्‌यो योहोसु दुय भेदिया क शित्तीम सी धोपाईन मोकली देदु, आरु उकाह कयो, “जाईन उका देश आरु योरीहो क देख।” तात्काल चा चाल देदा, आरु राहाब नावन काहनी वेश्या क घर मा जाईन सुय गयो। ");
INSERT INTO dhn_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","तव कोय योरीहोन राजा सी कयो, “आज रात मा कोय इसराएली हामरा देश न पुरावो लेने या आया छे।” ");
INSERT INTO dhn_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","तव योरीहोन राजु राहाब क ज यो कयीन मोकल्यो, “जो ओदेमड़ा तार या आवला छे हेनको बाहरते ली आव; काहकी चा सब देश क भेद लेने क आया छे।” ");
INSERT INTO dhn_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","4","ची बायर दुयु माहनक धोपाड़ मेकली; आरु ओसो कयो, “मार जु बैस मानसे आया ते हता, पुन हाव नी जानती कि चा कावाळा हता; ");
INSERT INTO dhn_vpl VALUES ("JS2_5","007_2_5","JOS","2","5","5","आरु जब आंधारो हयो, आरु सहरन फाटक बंध होयने लाग्यो, तव चा निकळी गया; मखे मालुम नी कि चा का गया; तुमु आंदाज करिन हेनको पछव जावु ते हेनको जाईन धरसे।” ");
INSERT INTO dhn_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","ओको उकान घरन छत पर चढ़ीन सनन लाकड़ाक नेड़ी हेनको डुकाड़ दिदी जो हेका घर पर सजाड़ीन मेक देदली हती। ");
INSERT INTO dhn_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","चा मानसे ते यरदन क रस्ता वोगे उकाक हेरने मा घाट तक जात रया; आरु जा उकाह हेरनेवाळा सोहोरन झोपला सी निकळ्या त्यो फाटक बंध हुय गया। ");
INSERT INTO dhn_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","या लुटनु नी जुवला हता कि ची बायर घर पर उकान जु जाईन ");
INSERT INTO dhn_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","आरु उना लोगहन सी कयणे लागी, “मखे ते पाक्‌को जान पड़े कि योहोवा भगवान तुमु लोगहन क यो देश आपलु छे, आरु तुमरु डर आमु लोगहन क मन मा समायलु छे, आरु ओका देश मा सब रयने वाळा तुमरे कारण हरबळाय गया छे। ");
INSERT INTO dhn_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","काहकी हामु सोमवला छे कि योहोवा भगवान तुमरे मिसर सी निकळने टेमे तुमरे सामने लाल दरिया क पाणी सुकाळ देदु। आरु तुमु सीहोन आरु ओग नावन यरदन पार रयने वाळा एमोरिया क दुयु राजान सत्यनाश कर नाख्या छे। ");
INSERT INTO dhn_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","आरु यो सोमवताज आमरो मन पोगवी गयो, आरु तुमरे कारण काहना क घणा घबराय गिया; काहकी तुमरु परमेश्वर योहोवा भगवान ऊपर वादवा क आरु नेड़ली धरतीन परमेश्वर छे। ");
INSERT INTO dhn_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","हिमी हाव जो तुमरे पर दया कर्‍यु छे, एरकरता म्हार सी भगवानन कसम खावो कि तुमु भी म्हार बासन क घरन आखा पर दया करसु, आरु ओका खोरलो सोहलानी मखे आप, ");
INSERT INTO dhn_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","कि तुमु मार आय-बास, भाईसक आरु बोहनीस क, आरु जो काहय उकान छे उना सभा क भी जीवतो मेक रयु, आरु आमु सब क प्राण मरने सी वाचाड़सु।” ");
INSERT INTO dhn_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","तव उना लोगहन कयो, “कदाम तु आमरी यी वात काहना पर प्रगट नी करे, ते तुमरा जीवन क बदले आमरु जीव जासे; आरु जव भगवान आमुक यो देश आपसे, तव हामु तार साथे दया आरु छाचाय सी बर्ताव करसु।” ");
INSERT INTO dhn_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","तव राहाब जेका घर सोहोरन भितड़ा धड़े बवनो हतो, आरु ची चाज रवती हती, उको उकाह खिड़की सी नाड़ा क भुरसे उतारीन नगरन बाहरते कर देदी। ");
INSERT INTO dhn_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","आरु उको उकाह कयो, “बोयड़ा पर जात रयु, ओसो नी होए के तुमुक हेरने वाळा तुमुक देखे; एरकरता जव तव तुमुक हेरने वाळा वापस नी आए तव तक, मतलब तीन दाहड़ा चा धोपाय रवजु, उकान बाद आपनु रस्तु लेजु।” ");
INSERT INTO dhn_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","17","हेको त्या कयो, जी कसम तु हामुक खवाड़ली छे हेका वारामा ते हामु विन गुणाका रयसु। ");
INSERT INTO dhn_vpl VALUES ("JS2_18","007_2_18","JOS","2","18","18","सोमव, जव हामु इना देश मा पछा आवसु, तव जीन खिड़की सी तु आमुक उतारियो छे उकामा लाल रंग क हुतन दुवड़ी बांध देनु; आरु आपना आया-बास, भाईस्योक, नीते आपनी बासक सब घराना क इना घर मा आपने जु एकठा करिन मेकनु। ");
INSERT INTO dhn_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","तव कुई तार घरन झोपलान बाहरते निकाळ्या, उकान लुहुयोक दोष उकान मुनका पर पड़ जाय, आरु आमु निर्दोष ठरसे: पुन कदाम तार साथे घरमा रयता रयता एकदा पर एकदान हाथ पड़े, ते उकान खुनन दोष आमरे मुनका पर पड़से। ");
INSERT INTO dhn_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","तु हामरी यी वात कोय को कय दिस, ते जी कसम तु आमुक खवाड़ली छे हेका सी हामु विन गुणाका रयसु ");
INSERT INTO dhn_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","उको कयो, “तुमरा वचन क अनसारे होय।” तव हेको उकाह वाट लागाड़ देदो, आरु चा जात रया; आरु हेको लाल रंग क दुवड़ी क खिड़की मा बांध देदा। ");
INSERT INTO dhn_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","चा जाईन बोयड़ा पर पुग्या, आरु चा हेरने वाळान क पछा आवने तक, मतलब तीन दाहड़े तक रया; आरु हेरने वाळा उकाह सब रस्ता मा देखता रया आरु का नी देख्या। ");
INSERT INTO dhn_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","तव त्या दुयु ओदेमड़ा बोयड़ा सी उतर्‌या, आरु पार जाईन नुन क पोर्‌यो योहोसु क जु पुगीन जो काहय उना पर वीती हती उकान वाराम कया। ");
INSERT INTO dhn_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","आरु चा योहोसु सी कया, “हमखास योहोवा भगवान वा सब देश आमरा हाथ मा कर देदु छे; पछु ओका सिवाय उकान सब रयने वाळा आमरे कारन हरबड़ाय गया छे।” ");
INSERT INTO dhn_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","योहोसु सोंदारे उठ्यु आरु सब इसराएली लोगहन क साथ मा लीन शित्तीम सी चालीन यरदन नदीन धड़े आया; आरु चा पार उतरने सी पेहल चाज टिक गया। ");
INSERT INTO dhn_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","आरु तीन दाहड़ा क बाद अगळवानीया छावनीक वीच मा जाईन ");
INSERT INTO dhn_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","प्रजा क लोगहन क या आदेश देदु, “जव तुमु क आपनु योहोवा परमेश्वरन वाचान सन्दुक आरु हेको हाकलीन लेवीया याजक भी देख पड़े, तव आपना जागा सी चालता चालता उकान पछव पछव चाल्या, ");
INSERT INTO dhn_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","पुन उकान आरु तुमरे वीच मा दुय हजार हाथन लगभग जागु रयु; तुमु सन्दुक नाट नी जानु। काहकी तुमु देख सकु कि काहनी वाट सी तुमुक चालनु छे, काहकी हिमी तक तुमु ओका वाट पर होईन नी चाल्या।” ");
INSERT INTO dhn_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","पछु योहोसु प्रजाक लोगहन सी कयो, “तुमु आपने आप क पवित्र कर्‌या; काहकी कालेन दाहड़े योहोवा भगवान तुमरे वीच मा विछेळीयो काम करसे।” ");
INSERT INTO dhn_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","तव योहोसु पुजारान सी कयो, “वाचा क सन्दुक उठावीन इसराएली लोगहन क ओगळ ओगळ चालु।” तव त्या वाचान सन्दुक हाकलीन लोगहन क ओगव ओगव चालीया। ");
INSERT INTO dhn_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","तव भगवान योहोसु सी कयो, आजुन दाहड़े रईन हाव इसराएलीया क सामने तारी बढ़ाई करने सुरवात करीस, जेका सी त्या जान लेय कि जोसो हाव मुसा क साथे रयतु हतु तोसोज हाव तार सात मा भी रइस। ");
INSERT INTO dhn_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","आरु तु वाचान सन्दुक क हाकलने वाळा पुजारान क यो हुकुम दे, “जव तुमु यरदन क पानीन धोड़े पुग्या, तव यरदन मा उबा रयना।” ");
INSERT INTO dhn_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","तव योहोसु इसराएलीया सी कयो, “साथे आवीन आपना योहोवा परमेश्वर क वचन सोमळो।” ");
INSERT INTO dhn_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","10","आरु योहोसु कयने लाग्यु, “ओका सी तुमु जान लेसे कि जीवता परमेश्वर तुमरे माहय मा छे, आरु चा तुमरे सामने सी नि:सन्देह कनानियो, हित्तियो, हिब्बीया, परिज्जियो, गिर्गाशियो, एमोरियो, आरु यबुसियो क उकान देश मा सी निकाळ देसे। ");
INSERT INTO dhn_vpl VALUES ("JS3_11","007_3_11","JOS","3","11","11","सोमवु, पृथ्वी भरीन पोरबु क वाचा क सन्दुक तुमरे ओगव ओगव यरदन मा जाने पर छे। ");
INSERT INTO dhn_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","एरकरता हिमी इसराएलीया क गोत्रो मा सी बाहरते मानसे निवाळ लेवु, चा एक गोत्रो मा सी एक मानुस होय। ");
INSERT INTO dhn_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","आरु जीन टेमे धरती भरीन पोरबु योहोवा क वाचा उठावने वाळा याजक क पाय यरदन क पाणी मा पड़से, उका टेमे यरदन क ऊपर सी वहयतो पाणी उभरय जासे, आरु ढेर होईन उबो रयसे।” ");
INSERT INTO dhn_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","14","एरकरता जब प्रजा क लोगहन आपना पड़ाव सी यरदन पार जाने क चाल पड़्या, आरु याजक वाचा क सन्दुक उठावतु प्रजान ओगव ओगव चाले, ");
INSERT INTO dhn_vpl VALUES ("JS3_15","007_3_15","JOS","3","15","15","आरु सन्दुक उठावने वाळा यरदन पर पुग्या, आरु सन्दुक क उठावने वाळा याजक क पाये यरदन तीर क पाणी मा डुब गया (यरदन क पानीन ते कटनी क टेमे सब दाहड़ा आपना किनारा पर वयतो रयतो छे), ");
INSERT INTO dhn_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","वईन आवतो हतो चा बैस दुर, मतलब आदाम नगर क नाट जो सारतान सोहोर क नाट छे उबो रईन एक ढेर होय गयो, आरु भिताड़ा पर सा उबो रयो, आरु जो पाणी अराबा क दरियो जो खारो दरियो भी कयाड़तो छे, उकान तरफ वयतो जातो हतो, चो पुरी रीति सी सुख गयो; आरु प्रजा क लोगहन योरीहो क सामने पार उतर गया। ");
INSERT INTO dhn_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","आरु याजक योहोवा भगवान क वाचा सन्दुक धरीन यरदन क एकदम वीच मा पुगीन स्थल पर स्थिर उबा रया, आरु सब इसराएलीया चालीन स्थल पार उतरता रया, आखरी मा उका सब जाति क लोग यरदन पार होय गया। ");
INSERT INTO dhn_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","जव उका सब जाति क लोगहन यरदन क पार उतर गया, तव योहोवा भगवान योहोसु सी कयो, ");
INSERT INTO dhn_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","“प्रजा मा सी बारा मानसे, मतलब गोत्र पछव एक एक मानस क निवाळीन यी हुकुम देदी, ");
INSERT INTO dhn_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","तुमु यरदन क वीच मा, जा याजक ने पये धर्‍या हता चा रईन बारा दगड़ा उठावीन आपने साथे पार ली चालु, आरु जा आज रात पड़ाव हसे चा उकाह मेक देनु।” ");
INSERT INTO dhn_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","तव योहोसु उना बारा मानस क, जिनाक चु इसराएलीया क हर एक गोत्र मा सी छाटीन उभु कर मेक्यु हतु, ");
INSERT INTO dhn_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","योहोसु बुलावीन कयो, “तुमु आपना परमेश्वर योहोवा भगवान क सन्दुक क ओगव यरदन नदी क वीच मा जाईन इसराएलीया क गोत्रो क गिनती क अनसारे एक एक दगड़ु उठावीन आपना-आपना खांदा पर मेक्या, ");
INSERT INTO dhn_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","जेका सी यो तुमु लोगहन वीच मा सोहलानी ठरसे, आरु ओगव जव तुमरा पोर्‍या यह पुच्या, ‘ओका दगड़ान काय मतलब छे?’ ");
INSERT INTO dhn_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","तव तुमु उनाक यो जवाब दे, कि यरदन नदी पाणी योहोवा भगवान वाचा क सन्दुक क सामने सी दुय भाग होय गया हता; काहकी जव यरदन नदी पार आय रयु हतु, तव यरदन नदी क पाणी दुय भाग होय गयो। अत: चा दगड़ा इसराएलीया कक हमेशा क करता फोम करावने वाळा रवसे।” ");
INSERT INTO dhn_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","योहोसु क ओका हुकुम क अनसारे इसराएलीया कर्‌या, जोसो योहोवा भगवान योहोसु सी कयो हतो तोसोज हेका इसराएली गोत्रो क गिनती क अनसारे बारा दगड़ा यरदन नदी क वीच मा सी उठाव लेदा; आरु उनाक आपने साथे ली जाईन पड़ावा मा मेख देदा। ");
INSERT INTO dhn_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","आरु यरदन नदी क वीचमा, जा याजक वाचा क सन्दुक क उठावीन आपना पाये धर्‍यो हतो योहोसु ने बारा दगड़ा उबा कराया; चा आज तक चाज देख्या गया छे। ");
INSERT INTO dhn_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","आरु याजक सन्दुक उठावीन उके टेमे तक यरदन नदी क वीच मा उबा रया जव तक चा सब वात पुरी नी होई, मुसाक योहोवा भगवान योहोसु क लोगहन सी कयने क हुकुम दी हती। तव सब लोगहन फुर्ती सी पार उतरी गया; ");
INSERT INTO dhn_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","आरु जव सब लोगहन पार उतर गया, तव सब लोगहन याजक आरु योहोवा क सन्दुक भी उनाक देखता पार हया गया। ");
INSERT INTO dhn_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","आरु रुबेनी, गादि, आरु मनश्शे क आदा गोत्रा क लोगहन मुसा क कयने लाग्या कि अनसारे इसराएली लोगहन क ओगव कतार सी यरदन नदी पार हुय गया; ");
INSERT INTO dhn_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","मतलब कुई चालीस हजार मानुसे युद्ध क हथियार बांधीन संग्राम करने क करता योहोवा क सामने पार उतरीन योरीहो क जु अराबा मा पुग्या। ");
INSERT INTO dhn_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","उके दाहड़े योहोवा भगवान सब इसराएलीया क सामने योहोसु क महिमा बढ़ाई; आरु जोसो चा मुसा क डर मानता हता तोसाज योहोसु क भी बीक उकान जीवन भर मानता रया। ");
INSERT INTO dhn_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","तव योहोवा योहोसु सी कया, ");
INSERT INTO dhn_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","“वाचा क सन्दुक उठावने वाळा याजक क हुकुम आपे कि यरदन नदी मा सी निकळी आये।” ");
INSERT INTO dhn_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","ते योहोसु याजक क हुकुम देदी, “यरदन नदी मा सी निकळी आयो।” ");
INSERT INTO dhn_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","आरु जा योहोवा क वाचा क सन्दुक उठावने वाळा याजक यरदन नदी क वीच मा सी निकळी आया, आरु उनाक पाये स्थल पर पड़े, त्या ही यरदन नदी क पाणी आपना जागा पर आया, आरु पेहल समान किनारान क ऊपर पछो वहने लाग्यो। ");
INSERT INTO dhn_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","पेहले महिने क दसवे दाहड़े क प्रजा क लोगहन यरदन नदी मा सी निकळीन योरीहो क पेहली सिमा पर गिलगाल मा आपना डेरु नाख्या। ");
INSERT INTO dhn_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","आरु जा बारा दगड़ा यरदन नदी मा सी निकाळ्या गया हता, उनाक योहोसु नी गिलगाल मा उबा कर्‌या। ");
INSERT INTO dhn_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","तव चु इसराएलीया सी कयो, “ओगव जव तुमरा झोठा-बोच्‌चा आपना आपना बास क यो पुछ्या, ‘ओका दगड़ा क काय मतलब छे?’ ");
INSERT INTO dhn_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","तव तुमु यो कईन उनाक कया, ‘इसराएली यरदन नदी क पार स्थल ही चाली आया हता।’ ");
INSERT INTO dhn_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","काहकी जोसो तुमरु परमेश्वर योहोवा नी लाल दरिया क आमरे पार होय जाने तक आमरे सामने सी हटावीन सुखला मेक्या हता; तोसोत् होयो योरदोन काजे वी पानी तुमरे पार होय जाने लोगुन तुमरे ओगोव गोथो छेटो होयीन सुकाड़ राख्यु; ");
INSERT INTO dhn_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","एरकरता कि धरती क सब देशो क लोगहन जान लेवु कि योहोवा परमेश्वर क हाथ बलवन्त‌ छे; आरु तुमु हमेशा आपना योहोवा भगवान क बीक मानता रयु।” ");
INSERT INTO dhn_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","जव यरदन क पश्चिम क तरफ रतने वाळा एमोरिया क सब राजा, आरु दरिया साथे रयनर वाळा कनानिया क सब राजा यो सोमव्या, कि योहोवा भगवान इसराएलीया क पार होयने तक उकान सामने सी यरदन नदीन पाणी हटाकर सुखलो राखलो‌ छे, तव इसराएलीया क डरन कारण मन हरबड़ाय गयो, आरु उना क जीव मा जीव नी रयु। ");
INSERT INTO dhn_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","उना टेमे योहोवा भगवान योहोसु सी कयो, “चकमक सी छुरिया बनावीन दिसरी वार इसराएलीया क खतना कराव दे।” ");
INSERT INTO dhn_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","तव योहोसु चकमक क छुरिया बनावीन खलड़िया नावन टीले पर इसराएलीया क खतना कराया। ");
INSERT INTO dhn_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","4","आरु योहोसु जो खतना करायु, ओका कारण यो छे, कि जोतरा युद्ध क योग्य मानसे मिसर सी निकळ्या हता चा सब मिसर सी निकळने पर जंगल क रस्ता पर मर गया हता। ");
INSERT INTO dhn_vpl VALUES ("JS5_5","007_5_5","JOS","5","5","5","जा मानसे मिसर सी निकळया हता उना सब क खतना होय गया हता, पुन जोतरा उनाक मिसर सी निकळ ने पर जंगकन मार्ग मा पयदा हुया उना मा सी कुनीन नी खतना होयो हतो। ");
INSERT INTO dhn_vpl VALUES ("JS5_6","007_5_6","JOS","5","6","6","काहकी इसराएलीया ते चालीस साल तक जंगल मा फिरता रया, जव तक उकान सब जाति क लोगहन, मतलब जोतरा युद्ध क योग्य लोगहन मिसर सी निकळ्या चा खतम नी होय गया, काहकी हेको योहोवा भगवान नी मानी हती; एरकरता योहोवा भगवान शपथ खाईन उनाक कयो हतो, आरु उकामा दुध आरु माखान धार वयती छे, चो देश हाव तुमुक नी देखाड़ने। ");
INSERT INTO dhn_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","ते उना लोगहन क पोर्‌यो जेका योहोवा भगवान उकाम जागा पर पयदा कर्‌या हता, उकान खतना योहोसु सी कराया, काहकी रस्ता मा उकान फातोरकाती नी होयने क कारण चा खतनारहित हता। ");
INSERT INTO dhn_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","आरु जव उका सब जाति क लोगहन क खतना होय गयो, तव चा आरगाय होय जाने तक आपना आपना जागा पर छावनी मा रया। ");
INSERT INTO dhn_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","तव योहोवा भगवान योहोसु सी कयो, “तुमरी नामधराई जी मिसरिया मा होई छे उका हाव आज सेठु कर्‍यु छे।” एर कारण उका जागा क नाव आजुन दाहड़े तक गिलगाल पड़्या छे। ");
INSERT INTO dhn_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","एरकरता इसराएलीया गिलगाल मा डेरा नाखला रवे, आरु हेको योरीहोन मैदान मा मयनान चोवदवे दाहड़े सांतेन टेमे फसहन तिवार वाळीया। ");
INSERT INTO dhn_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","आरु तिवार क दिसरे दाहड़े चा उका देश क कमाय मा सी अखमीरी रोटो आरु उके दाहड़े सी भुंजला दाना भी खाने लाग्या। ");
INSERT INTO dhn_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","आरु जेका दाहड़े चा उका देश क कमाय मा सी खाने लाग्या, उना दाहड़े सबेरे क मन्ना बंद होय गया; आरु इसराएलीया क ओगव पछा कभी नी जोड्यो, पुन उके साल हेकोने कनान देशन कमाय मा सी खादा। ");
INSERT INTO dhn_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","जव योहोसु योरीहो क जु हतो तव उको आपना डुवा उठाव्या, आरु काय देख्या, कि हाथ मा नंगी तलवार लीन एक मानुस सामने उभु छे; आरु योहोसु उकान जु जाईन पुछा, “काय तु आमरे तरफ सी छे, या आमरा बैरिया तरफ का?” ");
INSERT INTO dhn_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","तव उकाह उत्तर देदु, हांव कुदा वोवकु नी होय। हांव पोरबुन सेनान मुखी छे आरु हेमी यां आवलु छे। योहोसु तोत्यारुत् नेचु पोड़ीन हेनाक वांद्‌यु आरु हेरेसी पुछ्यु, “मालीन, मेस पावोर जुगु तारो काय हुकुम छे?” ");
INSERT INTO dhn_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","योहोवा क सेनिक क प्रधान योहोसु सी कयो, “आपना खासड़ा पायम सी उतार नाख, काहकी जीन जागा पर तु उबा छे चा चुखली छे।” तव योहोसु तोसुज कर्‌या। ");
INSERT INTO dhn_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","योरीहो क सब फाटक इसराएलीया क डरन कारण लगातार बंद रया; आरु कुई बाहर माहयता आवने जानेन मालुम नी हतो। ");
INSERT INTO dhn_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","पछा योहोवा भगवान योहोसु सी कयो, “सोमव, हाव योरीहो क उकान राजु आरु शुरवीर समेत तार ओवलियाद मा कर देतु छेव। ");
INSERT INTO dhn_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","एरकरता तुमु मा जोतरा योद्धा छे गाव क गेर लेदा, आरु उका गाव क चार तरफ एक वार फिरीन आया। आरु छव: दाहड़ा तक ओसोज कर्‌या करु। ");
INSERT INTO dhn_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","आरु सात याजक सन्दुक क ओगव ओगव गाडराक सिंगड़ा साथे सात नरसिंगे लीन चाल्या; पछा सातवे दाहड़े तुमु गाव क चार तरफ सात वार फिरजु, आरु याजक भी नरसिंगा फुकता चाल्या। ");
INSERT INTO dhn_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","आरु जव गाडरा क सिंगड़ा पर नरसिंगे देर तक फुकता रया, तव सब लोगहन नरसिंगे क शब्द सोमवताज मोटला ओवाज सी जयजयकार करे; तव नगर क सोहोरन भीतड़ो नेव सी पड़ जासे, आरु सब लोगहन आपना आपना सामने चढ़ जाए।” ");
INSERT INTO dhn_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","एरकरता नुन क पोर्‌यो योहोसु याजक क बुलावीन कयो, “वाचा क सन्दुक क उठाव ले, आरु सात याजक योहोवा भगवान क सन्दुक ओगव ओगव गाडरा क सिंगड़ा क सात नरसिंगे करता चाल्या।” ");
INSERT INTO dhn_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","नगर आरु हथियारबन्द मानसे योहोवा भगवान क सन्दुक ओगव ओगव चाल्या। ");
INSERT INTO dhn_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","आरु जव योहोसु यी वात लोगहन सी कय गयु, ते चा सात याजक जा योहोवा भगवान क सामने सात नरसिंगे लीन हता नरसिंगे फुकता चाल्या, आरु योहोवा क वाचा क सन्दुक उनाक पछव पछव चाल्या। ");
INSERT INTO dhn_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","आरु हथियारबन्द मानुस नरसिंगे फुकनेवाळा याजक लीन ओगव ओगव चाल्या, आरु पछव वाळा सन्दुक क पछव पछव चाल्या, आरु याजक नरसिंगे फुकता चाल्या। ");
INSERT INTO dhn_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","आरु योहोसु लोगहन क हुकुम देदु, “जव तक हाव तुमुक जयजयकार करने क हुकुम नी देव, तव तक जयजयकार नी करो, आरु नी तुमरा कुई शब्द सोमवने मा आया, नी कुई वात तुमरा मुहय मा निकळनो नी जुवे; हुकुम जोड़ताज जयजयकार करनो।” ");
INSERT INTO dhn_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","उको योहोवा भगवान क सन्दुक क एक वार गाव क चार तरफ फिराया; तव चा छावनी मा आया, आरु रात चा काड़्या। ");
INSERT INTO dhn_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","योहोसु सोंदारे उठ्यु, आरु याजक योहोवा क सन्दुक उठाव लेदो। ");
INSERT INTO dhn_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","आरु उना सात याजक गाडरा क सिंगड़ा क सात नरसिंगे लीन आरु योहोवा क सन्दुक क ओगव ओगव फुकता चाल देदा; आरु उनाक ओगव हथियारबन्द मानुस चाल्यु, आरु पछल वाळा योहोवा न सन्दुक क पछव पछव चाल्या, आरु याजक नरसिंगे फुकता चाल देदा। ");
INSERT INTO dhn_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","एरगत चा दिसरे दाहड़े भी एक बार गाव क चार तरफ फिरीन पड़ाव पर पछा वापस आया। आरु ओका प्रकार हेको छव: दाहड़े तक कर्‌या। ");
INSERT INTO dhn_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","पछा सातवे दाहड़े चा कुकड़ा वासने न टेमे उठीन तीनीन रीति सी गाव क चार तरफ सात बार फिरीन आया; सिर्फ तीनीज दाहड़े चा सात बार फिर्‍या। ");
INSERT INTO dhn_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","तव सातवी बार जव याजक नरसिंगे फुकता हता, तव योहोसु लोगहन सी कयो, “जयजयकार करो; काहकी योहोवा यो गाव तुमुक आप देदु छे। ");
INSERT INTO dhn_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","आरु गाव आरु जा काहय उकामा छे योहोवा क करता अर्पण करली चीज ठरसे; सिर्फ राहाब वेश्या आरु जोतरा ओकान घर मा छे चा जीवता छुड़ देदा जासे, काहकी चु आमरी मोकल्‌ला दुत क धोपाड़ लेदा हता। ");
INSERT INTO dhn_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","आरु तुमु अर्पण करली चीज सी सावधानी सी आपनो पाप क अलग राखु, ओसो नी होय कि अर्पण करली चीज ठहरावीन बाद मा उकाक अर्पण करली चीज मा सी काहय ली लेवु, आरु ओका प्रकार इसराएलि पड़ाव क नाश करिन उका कष्ट मा नाख दे। ");
INSERT INTO dhn_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","सब चाँदी, सोना, आरु जो पात्र पीतवन आरु लोखंडान छे, चा योहोवा क करता चुखला छे, आरु उका क समान मा मेकनु छे।” ");
INSERT INTO dhn_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","तव लोगहन ने जयजयकार कर्‌या, आरु याजक नरसिंगे फुकता रयु। आरु जव लोगहन ने नरसिंगे क शब्द सोमव्या ते पछा मोटा ओवाज सी हेको जयजयकार कर्‌या, तव सोहोरपनाह नींव सी पड़ गया, आरु लोगहन आपने आपने सामने सी उका गाव मा चढ़ गया, आरु गाव क ली लेदु। ");
INSERT INTO dhn_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","आरु काय मानुस, बायर काय, काय जवान, काय जुवान, काय डाहला, वरन् बयलीय, गाडरा-बुकड़ा, गोदड़ा, आरु जोतरा गाव मा हता, उना सभा क हेको अर्पण करली चीज जानीन तलवार सी मार नाख्या। ");
INSERT INTO dhn_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","तव योहोसु उना दुय मानसक सी जो उका देश क भेद लेने गया का, “आपनी शपथ क अनसारे उका वेश्या क घर मा जाईन उकाह आरु जो उकाह जु हेको भी निकाळ ली आरु।” ");
INSERT INTO dhn_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","तव चा दुयु जुवान भेदिए माहयता जाईन राहाब क, आरु उकान आय-बास, भाईसक, आरु सब क जो उकाह या रवता हता, वरन् उकाह सब कुटुंब वाळा क निकाळ लाया, आरु इसराएल क पड़ाव सी बाहरते बठाड़ देदा। ");
INSERT INTO dhn_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","तव हेका गाव क आरु जा काहय उकामा हता, सब क आगठो धोपाड़ीन फुक देदा; सिर्फ चाँदी, सोना, आरु जा पात्र पीतळ आरु लोखंड क हतो, उकाह हेका योहोवा भगवान क भवन क समान मा मेक देदा। ");
INSERT INTO dhn_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","आरु योहोसु राहाब वेश्या आरु उकान बास क घराना क, वरन् उकाह सब लोगहन क जीवता छुड़ देदा; आरु आज तक उकान पिढ़ी इसराएलीया क वीच मा रवता छे, काहकी जा दुत योहोसु योरीहो क भेद लेने क मुकल्या हता हेका उको धोपाड़ लेदा हता। ");
INSERT INTO dhn_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","पछा उका टेमे योहोसु इस्राइलीया क सामने शपथ मेकी, आरु कया, “जु मानुस उठीन ओका गाव योरीहो क पछा बनाया चा योहोवा क तरफ सी शापित होये। जव चा उकान नींव नाखसे तव उकान मोठलो पोर्‌यो मरसे, आरु जव चा उकान फाटक लागाड़से।” ");
INSERT INTO dhn_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","आरु योहोवा योहोसु क संग रया; आरु योहोसु क कीर्ति उका सब देश मा पसरी गई। ");
INSERT INTO dhn_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","पुन इसराएलीया नाश करनेन चीज न वाराम धुको कर्‌या; यहुदा गोत्र क आकान, जो जेरह ओवलियादी जब्दी क पुतन्यो आरु कर्म्मी क पोर्‌यो हता, उका ने अर्पण क चीज मा सी काहय ली लेदा; एका कारण योहोवा भगवान क रीश इसराएलीया पर भड़क उठ्या। ");
INSERT INTO dhn_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","2","योहोसु योरीहो सी ऐ नावन नगर क पास, जो बेतावेन सी लागलु बेतेल उगवनी वोगे छे, काहय मानसक यो कईन मोकल्या, “जाईन देश क बेद ले आरु।” आरु उना मानसक जाईन ऐ का भेद देदा। ");
INSERT INTO dhn_vpl VALUES ("JS7_3","007_7_3","JOS","7","3","3","आरु हेको योहोसु क साथे वापस फिरीन आवीन कया, “सब लोग चा नी जाय, कुई दुय तीन हजार मानसे जाईन ऐ गाव क जीत सकता छे; सब मानसक चा जानेन कष्ट मा आपु, काहकी चा मानसे थुड़ाज छे।” ");
INSERT INTO dhn_vpl VALUES ("JS7_4","007_7_4","JOS","7","4","4","एरकरता कुई तीन हजार मानसे चा गया; पुन ऐ गाव मा रयने वाळा क सामने सी डासीन आया, ");
INSERT INTO dhn_vpl VALUES ("JS7_5","007_7_5","JOS","7","5","5","तव ऐ गाव क रहने वाळा उनामा सी कुई छत्तीस मानसे मार नाख्या, आरु आपना फाटक सी शबीराम तक उनाक पछव करिन उतराई मा उनाक मारता गया। तव लोगहन क मन पिघवाळीन पाणी जोसो बन गयो। ");
INSERT INTO dhn_vpl VALUES ("JS7_6","007_7_6","JOS","7","6","6","तव योहोसु आपना छिंदरा फाड़े, आरु चा आरु इसराएली डाहला लोगहन योहोवा क सन्दुक क सामने मुहयन बुरसे पड़ीन धरती पर सांजु तक पवड़ा रवे; आरु हेको आपना आपना मुनका पर धुवु नाखी। ");
INSERT INTO dhn_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","7","आरु योहोसु कयु, “हाय, पोरबु योहोवा, तु आपनी ओका प्रजा क यरदन नदी पार काय ली आयु? काय आमुक एमोरिया क वश मा करिन नष्ट करने क करता ली आया छे? वारलो हतो कि आमु संतोष करिन यरदन नदी क तीन पार रय जाता! ");
INSERT INTO dhn_vpl VALUES ("JS7_8","007_7_8","JOS","7","8","8","हाय, पोरबु हाव काय कयो, जव इसराएलीया आपना दुश्मन क वाहँ दिखाड़े छे! ");
INSERT INTO dhn_vpl VALUES ("JS7_9","007_7_9","JOS","7","9","9","काहकी कनानी वरन् ओका देश क सब निवासी यो सोमवीन आमुक घेर लेसे, आरु आमरो नाव धरती पर सी मिटाळ नाखसे; पछु तु आपना मोटा नावन करता काय करसे?” ");
INSERT INTO dhn_vpl VALUES ("JS7_10","007_7_10","JOS","7","10","10","योहोवा योहोसु सी कया, उठ, उबो रय जा, तु काह ओका भाति मुयक बल धरती पर पड़े छे? ");
INSERT INTO dhn_vpl VALUES ("JS7_11","007_7_11","JOS","7","11","11","इसराएलीया पाप कर्‌या छे; आरु जी वाचा हाव उका सी आपने साथ बंधाई हती उकाह हेको तुड़ देदा छे; हेको अर्पण करी चीज मा सी ली लेदा, वरन् चुरी भी करी कि आरु छल करिन उकाह आपने समान मा मेक देदा छे। ");
INSERT INTO dhn_vpl VALUES ("JS7_12","007_7_12","JOS","7","12","12","ओका कारण इसराएलीया आपना दुश्मन क सामने उबा नी रय सकता; चा आपना दुश्मन क वाहँ देखाड़ता छे, एरकरता कि चा खुद अर्पण करी चीज बन गया छे। आरु कदाम तु आपने वीच मा सी अर्पण करी चीज क सत्यनाश नी कर नाखसे, ते हाव ओगव क तुमरे साथे नी रवो। ");
INSERT INTO dhn_vpl VALUES ("JS7_13","007_7_13","JOS","7","13","13","उठ, लोगहन क चुखलो कर, ओकाह कय, सोंदारे रक आपने आपसु क चुखलो कर मेक; काहकी इस्राएल क परमेश्वर योहोवा यो कयतो छे, “हे इस्राएल, तार वीच मा अर्पण करली चीज छे; एरकरता जव तक तु अर्पण करली चीज क आपने वीच मा सी सेठी मा करे तव तक तु आपना दुश्मन क सामने उभु नी रय सकतु।” ");
INSERT INTO dhn_vpl VALUES ("JS7_14","007_7_14","JOS","7","14","14","एरकरता सोंदारे क तु गोत्र गोत्र क अनसारे सामने उबा कर्‌या जासे; आरु जा गोत्र क योहोवा धरे चु एक एक कुल करिन नाट आवे; आरु जा कुल क योहोवा धरे चो घराना घराना करिन नाट आया; पछा जा घराना क योहोवा भगवान धरे चु एक एक मानुस करिन नाट आया। ");
INSERT INTO dhn_vpl VALUES ("JS7_15","007_7_15","JOS","7","15","15","तव जु मानुस अर्पण करी चीज मेकली सापड़ी जाय, चा आरु जो काहय उकान होय सब आग्ठा मेकीन धोपाड़ देदलो जाय; काहकी उको योहोवा क वाचा क तुवड़ो छे, आरु इस्राएल मा अनुचित काम कर्‌या छे। ");
INSERT INTO dhn_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","16","योहोसु सोंदारे उठीन इसराएलीया क गोत्र गोत्र करिन सामने ली गया, आरु यहुदा क गोत्र धोराय गयो; ");
INSERT INTO dhn_vpl VALUES ("JS7_17","007_7_17","JOS","7","17","17","तव उको यहुदा क परिवार क सामने कर्‌या, आरु जेरह ओवलियादिया क कुल धोराय गयो; जेरह ओवलियादिया क घराना क एक एक मानस क सामने लाया, आरु जब्दी धराय गयो; ");
INSERT INTO dhn_vpl VALUES ("JS7_18","007_7_18","JOS","7","18","18","तव उको उकाह घराना क एक एक मानस क सामने उबा कर्‌या, आरु यहुदा गोत्र क आकान, जु जेरह ओवलियादी जब्दी क नातन्यो आरु कर्म्मी क पोर्‍यु हतु, धराय गयो। ");
INSERT INTO dhn_vpl VALUES ("JS7_19","007_7_19","JOS","7","19","19","तव योहोसु आकान सी कयने लाग्यो, “हे मार पोर्‍या, इस्राएल क परमेश्वर योहोवान मोहिमा कर, आरु ओकान ओगव अंगीकार कर; आरु जो काहय तु करलु छे चो मखे कय दे, आरु मखे सी काहय मा धोपाड़े।” ");
INSERT INTO dhn_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","आकान योहोसु क उत्तर देदु, “सचमा हाव इस्राएल क परमेश्वर योहोवा क विरुध्द पाप कर्‍यु छे, आरु ओका प्रकार हाव कर्‍यु छे, ");
INSERT INTO dhn_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","21","कि जब मखे लुट मा शिनार देश क एक सुन्दर ओढ़ना, आरु दुय सोव शेकेल चाँदी, आरु पचास शेकेल हुनान एक इटळो देखाय पड़्यो, तव हाव ओकान लालच करिन हेको मेक देदा; चा मार पड़ावन माहयता धरती मा गावड़ा छे, आरु सब क नेड़ी चाँदी छे।” ");
INSERT INTO dhn_vpl VALUES ("JS7_22","007_7_22","JOS","7","22","22","तव योहोसु थुड़ाक लोगहन क मकल्यो, आरु त्या उना पड़ाव मा दौड़ी पड़्या; आरु काय देख्या कि चा चीजे उकान पड़ाव मा गावड़ा छे, आरु सब नेड़ी चाँदी छे। ");
INSERT INTO dhn_vpl VALUES ("JS7_23","007_7_23","JOS","7","23","23","उकाह हेका पड़ाव मा सी निकाळीन योहोसु आरु सब इसराएलीया क साथ लावीन योहोवा क सामने मेक देदा। ");
INSERT INTO dhn_vpl VALUES ("JS7_24","007_7_24","JOS","7","24","24","तव सब इसराएलीया समेत योहोसु जेरह ओवलियादी आकान क, आरु उका चाँदी आरु ओढ़ने आरु हुनान इटळो क, आरु ओकान पोर्‍या-पोराय क, आरु उकान बयलीय, गदड़ा आरु गाडरा-बुकड़ा क, आरु उकान पड़ाव क, मतलब जा काहय ओकान हतो उना सब क आकोर नावन तराई मा ली गया। ");
INSERT INTO dhn_vpl VALUES ("JS7_25","007_7_25","JOS","7","25","25","तव योहोसु ओकाह कयो, “तु आमुक काह कष्ट आप्यु छे? आजुन दाहड़े योहोवा भगवान तुखे कष्ट आपसे।” तव सब इसराएलीया उका पर पथराव कर्‌या; आरु उका आग्ठा मा नाखीन धोपाड़्या, आरु उकान उपर दगड़ा नाख देदा। ");
INSERT INTO dhn_vpl VALUES ("JS7_26","007_7_26","JOS","7","26","26","आरु हेको उकान उपर दगड़ा क ढिग लागाड़ देदा जो आज तक बवनो छे; तव योहोवा क भड़कलो रीस शांत होय गयो। ओका कारण उका जागा क नाव आज तव आकोर तराई पड़ गयो। ");
INSERT INTO dhn_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","1","तव योहोवा योहोसु सी कया, “मा बीहे, आरु तारो मन कच्चो नी होय; कमर बाँधीन सब योद्धाओंक साथे लेवु, आरु ऐ पर चढ़ाई कर; सोमव, हाव ने ऐ का राजु उकान प्रजा आरु उकान नगर आरु जमीन क साथ मा थारा हक मा कर दिलो छेतो। ");
INSERT INTO dhn_vpl VALUES ("JS8_2","007_8_2","JOS","8","2","2","आरु जोसो तु योरीहो आरु ओकान सी कर्‌या तोसोज ऐ आरु उकान राजाक साथे भी करनु; केवल तुमु पशु समेत ओकान लुट ते आपने करता ली सकजे; एरकरता ओका नगरक पछवली तरफ आपना पुरुष घात मा लागाड़ देसे।” ");
INSERT INTO dhn_vpl VALUES ("JS8_3","007_8_3","JOS","8","3","3","अत: योहोसु सब योद्धा समेत ऐ पर चढ़ाई करनेक तेयारी कर्‌या; आरु योहोसु तीस हजार मानसक जु शुरवीर हता रातीज आदेश आपीन मुकल्या। ");
INSERT INTO dhn_vpl VALUES ("JS8_4","007_8_4","JOS","8","4","4","आरु उनाक यी हुकुम आप्या, सोमवु, तुमु ओका नगरक पछवली तरफ घात लागाड़े बठला रयनु; नगर सी बैस सेठे नी जानु, आरु सब के सब तेयार रहना; ");
INSERT INTO dhn_vpl VALUES ("JS8_5","007_8_5","JOS","8","5","5","आरु हाव आपना साथी समेत ओका नगरन नाट जाईस। आरु जव चा पेहले समान आमरो सामनु करनेक निकळ्या, तव आमु ओका ओगव सी डाससु; ");
INSERT INTO dhn_vpl VALUES ("JS8_6","007_8_6","JOS","8","6","6","तव चा यो सोचीन, कि पेहले भाँतिन आमरे सामने सी डास जाता छे, आमरी पिछा करसे; ओका प्रकार आमु ओकान सामने सी डासीन हेका नगर सी छेठा निकाळ ली जासे; ");
INSERT INTO dhn_vpl VALUES ("JS8_7","007_8_7","JOS","8","7","7","तव तुमु आपसा डुकायने क जागा सी निकळजु आरु नगर पोर होक कोर लेजु, काहकी पोरबु परमेश्वर नगर क तुमरा होक मा कोर देसे। ");
INSERT INTO dhn_vpl VALUES ("JS8_8","007_8_8","JOS","8","8","8","जव तुमु नगर क आपसा होक मा कोर लेसु तव उनामा आगठो लागाड़ देजु। पोरबु क बुलन ओनसारे असाज कोरजु। देखु, तुमरे लिय योज मारो हुकुम छे। ");
INSERT INTO dhn_vpl VALUES ("JS8_9","007_8_9","JOS","8","9","9","योहोसु न हेनको मुकल देदो। त्य डुकायने का जागा पोर चाली गुया। त्या ऐ नगर क बुडेनले धड़े, ऐ नगर आरु बेतेल क वीच डुकायीन बोस गुया। योहोसु न आपसा सिपायड़ा क पुठी रात रोयो। ");
INSERT INTO dhn_vpl VALUES ("JS8_10","007_8_10","JOS","8","10","10","योहोसु संदारे बेगो उठ्यो। त्यो सिपायड़ा क एकठा कोर्‌यो, आरु इसराएली धोरमोन डाहडा भेळ सिपायड़ा क अगळ अगळ ऐ नगर क भेनी गुयो। ");
INSERT INTO dhn_vpl VALUES ("JS8_11","007_8_11","JOS","8","11","11","योहोसु क पुठी क आखा सिपायड़ा ओगा गुया। त्या नगर क अगळ ओका धड़े पुग्या। त्या ऐ नगर क उत्तर मा पड़ाव कोर्या। हेनका आरु ऐ नगर क वीच एक तंग घाटी हुती। ");
INSERT INTO dhn_vpl VALUES ("JS8_12","007_8_12","JOS","8","12","12","योहोसु न पांच हजार सिपायड़ा लिन आरु उना ऐ नगर क बुडेनले मा, ऐ नगर आरु बेतेल क वीच एक जागा पोर डुकायीन बोसाड़ देदो। ");
INSERT INTO dhn_vpl VALUES ("JS8_13","007_8_13","JOS","8","13","13","इसराएली सिपायड़ा क स्थिती यी हुतली, ऐ नगर क उत्तर मा अग्रगामी सिपायड़ान टुळो आरु नगर क बुडेनले मा चन्दावल सिपायड़ान टुळो पड़ाव कोर्‌यो। योहोसु न घाटी मा रात रोयो। ");
INSERT INTO dhn_vpl VALUES ("JS8_14","007_8_14","JOS","8","14","14","जव ऐ नगर क राजा न योहोसु क सिपायड़ा क देख्यो, तव त्यो विगुर वार कोरे; त्यो आरु हेनका लोगहन नगर क आखा सिपायड़ा इसराएलीयो सी लोड़ाय करने क लिय यर्दन नदी क घाटी क भेनी गुया। त्या उना अराबा जागा पोर गुया जाँ त्या पेहले लोड़ाय कोर्या हुता। राजा नी जानतो हुतो कि नगर क पछळ भेनी सी उना पोर डुकायीन होमलो कोरसे। ");
INSERT INTO dhn_vpl VALUES ("JS8_15","007_8_15","JOS","8","15","15","योहोसु आरु इसराएल पुठी क सिपायड़ा न हारनेन बहानो कोर्या, आरु त्या उजाड़ी पोरदेश क वाट क भेनी ढासने लाग्य। ");
INSERT INTO dhn_vpl VALUES ("JS8_16","007_8_16","JOS","8","16","16","ऐ नगर क आखा लोगहन हेनका पछळ गुया। त्या योहोसु क पछळ करता नगर सी घोना छेटा निकळ गुया। ");
INSERT INTO dhn_vpl VALUES ("JS8_17","007_8_17","JOS","8","17","17","ऐ नगर आरु बेतेल नगर मा एक वी मानुस नी रोयो जो इसराएलीयो क पछळ करने नी गुयो होय। आखा मानसे नगर क उघाड़लो नाखीन इसराएलीयो क पछळ करने चाली गुया। ");
INSERT INTO dhn_vpl VALUES ("JS8_18","007_8_18","JOS","8","18","18","पोरबु न योहोसु सी कयो, आपसा हाथ क भाला सी ऐ नगर भेनी सोहली कोर; काहकी हांव नगर क तारा होक मा कोर देदो। योहोसु न आपसा हाथ क भाला सी ऐ नगर भेनी होत ओगो कोर्‌यो। ");
INSERT INTO dhn_vpl VALUES ("JS8_19","007_8_19","JOS","8","19","19","हेको हाथ उपोर कोर्‌यो, डुकायीन बोठला सिपायड़ा तावनी सी आपसा जागा सी उठ्या, आरु नगर भेनी दवड़ी पोड़्या। त्या नगर मा भराय गुया आरु हेको आपसा होक मा कोर लेदा त्या विगुर वार कोरे आगठो लागाड़ देदा। ");
INSERT INTO dhn_vpl VALUES ("JS8_20","007_8_20","JOS","8","20","20","जव ऐ नगर ज मानसे पोछा फिरीन देख्या कि ते काय देख्या की नगर क धुवाड़ो वादळा क भेनी उठ रोयो, आरु हेनको नी ते इंखेर ढासनेन ताकोत रोही, आरु नी ओथी, आरु जे मानसे जंगल भेनी ढासता हुता त्या फिरीन आपसाक मारनेवाळा पोर टुट पोड़्या। ");
INSERT INTO dhn_vpl VALUES ("JS8_21","007_8_21","JOS","8","21","21","जोत्यार योहोसु आरु आखा इसराएली न देख्या कि मारन्या नगर क ली लेदा, आरु हेको धुवाड़ो उठ रोयो छे, तव फिरिन ऐ नगर क मानसे मारने लाग्या। ");
INSERT INTO dhn_vpl VALUES ("JS8_22","007_8_22","JOS","8","22","22","आरु हेनका सामनो करने क दिसरा वी नगर सी निकळ आया, एकालिय त्या इसराएलीयो क वी मा पड़ गुया, काहिन इसराएली ते हेनका ओगळ आरु काहिन हेनका पछळ हुता; त्या हेनको यां लगुन मार्या कि उनमा सी नी ते कहिन वाचने आरु नी ढासाये। ");
INSERT INTO dhn_vpl VALUES ("JS8_23","007_8_23","JOS","8","23","23","आरु ऐ नगर क राजा क जिवतला धरीन योहोसु क पास ली आया। ");
INSERT INTO dhn_vpl VALUES ("JS8_24","007_8_24","JOS","8","24","24","जोत्यार इसराएली ऐ नगर क आखा रोहनेवाळा क खयड़ा मा, उना जंगल मा जां त्या पछळ कोर्या हुता घात करला आरु त्या आखाक तलवार सी मार्या गया यां लगुन कि हेनको आखरी हुय गुयो, तव आखा इसराएलीयो न ऐ क लोवटीन हेको वी तलवार सी मार्या। ");
INSERT INTO dhn_vpl VALUES ("JS8_25","007_8_25","JOS","8","25","25","आरु बायरा मानसे आखा मिळीन जे उना दाहड़े मार्या गुया त्या बारे हजार हुता, आरु ऐ नगर क आखा मानसे होतरात हुता। ");
INSERT INTO dhn_vpl VALUES ("JS8_26","007_8_26","JOS","8","26","26","काहकी जव लगुन योहोसु न ऐ नगर क आखा रहनेवाळा क नाश नी कोर नाख्यो ती लगुन त्यो आपसो हाथ जिनासी बर्छो बड़ायो हुतो, ओळी नी हापक्यो। ");
INSERT INTO dhn_vpl VALUES ("JS8_27","007_8_27","JOS","8","27","27","परमेश्वर क हुकुम क ओनसारे ज त्यो योहोसु क आप्यो हुतो इसराएलीयो न ढुरो नगर क लुट आपसो कोर लेदो। ");
INSERT INTO dhn_vpl VALUES ("JS8_28","007_8_28","JOS","8","28","28","तव योहोसु न ऐ नगर क धपाड़ देदो त्यो आज लगुन उजाड़ पोड़लो छे। ");
INSERT INTO dhn_vpl VALUES ("JS8_29","007_8_29","JOS","8","29","29","आरु ऐ नगर क राजा क त्यो शांतो लगुन झाड़ पोर टांग राख्यो आरु दाहड़ु डूबता डूबता योहोसु क हुकुम सी हेको धड़ झाड़ पोर सी उतारीन नगर क झपला क अगळ नाख देदा, आरु उना पोर दोगड़ा क मोटो ढीग लागाड़ देदा, ज आज लगुन बनलो छे। ");
INSERT INTO dhn_vpl VALUES ("JS8_30","007_8_30","JOS","8","30","30","तव योहोसु न इस्राएल क परमेश्वर योहोवा क लिय एबाल बोयड़ा पोर एक वेदी बनवाड़्यो, ");
INSERT INTO dhn_vpl VALUES ("JS8_31","007_8_31","JOS","8","31","31","जसो योहोवा क दास मुसा न इसराएलीयो क हुकुम आप्यो हुतो, आरु तसोज मुसान कायदान किपात मा लिखलो छे, त्यो समुचे दगड़ा क एक वेदी बनवाड़्यो जेना पोर ओवजार नी चालाड़्यो गुयो हुतो। आरु उना पोर त्या योहोवा क लिय होमबली चोड़ाया आरु मेलबलि कोर्या। ");
INSERT INTO dhn_vpl VALUES ("JS8_32","007_8_32","JOS","8","32","32","उना जागा पोर योहोसु न इसराएलीयो क अगळ उना दोगड़ा क उपोर मुसा क कायदा ज उनने लिख्यो हुतो, हेकी नकल कोराड़्यो। ");
INSERT INTO dhn_vpl VALUES ("JS8_33","007_8_33","JOS","8","33","33","आरु त्या, काय देशी काय पारका आखा इसराएली आपसा डाहला लोगहन, सरदारो, आरु नियाय कोरन्या भेळ योहोवा क वाचान सन्दुक चुटनेवाळा लेवीय याजकों क अगळ उना सन्दुक क एंखेर तेंखेर उबा हुया आदा लोगहन ते गिरिज्जीम बोयड़ा क, आदा एबाल बोयड़ा क अगळ उबा हुया तोसा कि योहोवा क दास मुसा न पेहलो हुकुम आप्यो हुतो कि इसराएली पोरजा क बोरकोत आप्यो जाय ");
INSERT INTO dhn_vpl VALUES ("JS8_34","007_8_34","JOS","8","34","34","हेका वाद त्यो बोरकोत आरु शाप नु कायदान आखा बुल, जसा जसा कायदान किपात मा लिखला छे तसाज तसाज भनी भनीन समवाड़ देदा। पारका लोगहन क अगळ वी भनीन नी समवाड़्या। ");
INSERT INTO dhn_vpl VALUES ("JS8_35","007_8_35","JOS","8","35","35","जोतरी वातोक मुसा न हुकुम आप्यो हुतो, उनामा सी काय ओसी वात नी रोय गोय जी योहोसु न इस्राएल क आखी सभा, आरु बायरा, आरु बाळ बोच्‌चा आरु हेनका पुठी रहनेवाळा क उचा बुल सी समवाड़ देदो ");
INSERT INTO dhn_vpl VALUES ("JS9_1","007_9_1","JOS","9","1","1","यो सोमवीन हित्ती, एमोरी, कनानी, परिज्जी, हिब्बी, आरु यबुसी, जोतरा राजा यरदनक ओका पार पहाड़ी देश मा आरु नेड़ला देश मा, आरु लबानोनक सामनेक महासागरक काठ पर रयता हता, ");
INSERT INTO dhn_vpl VALUES ("JS9_2","007_9_2","JOS","9","2","2","चा एक मन होईन योहोसु इसराएलीया सी लड़नेक एकठा होया। ");
INSERT INTO dhn_vpl VALUES ("JS9_3","007_9_3","JOS","9","3","3","जव गिबोनक निवासिया सोमव्या कि योहोसु योरीहो आरु ऐ सी काय काय कर्‌या छे, ");
INSERT INTO dhn_vpl VALUES ("JS9_4","007_9_4","JOS","9","4","4","तव हेका छल कर्‌या, आरु राजदुतक भेष बनावीन आपना गदड़ा पर पुराना बोरे, आरु पुराना फाटला आरु जोड़ लागला होया मदिराक कप्पा लादीन ");
INSERT INTO dhn_vpl VALUES ("JS9_5","007_9_5","JOS","9","5","5","आपना पायो मा जुन्ली पैबन्द लागाड़ला खासड़ा, आरु डिल पर जुन्ला छिंदरा पेहरी, आरु आपना खानान करता नबनुखी आरु फफुँदी लागाड़ला रुटो ली लेदा। ");
INSERT INTO dhn_vpl VALUES ("JS9_6","007_9_6","JOS","9","6","6","तव चा गिलगाल क छावनी होई योहोसुक जु जाईन ओकाह आरु इसराएली मानसक कयने लाग्या, आमु दिसरा देशम सी आया छे; एरकरता हिमी तुमु आमुसी वाचा बाँधु। ");
INSERT INTO dhn_vpl VALUES ("JS9_7","007_9_7","JOS","9","7","7","इसराएली मानसे उना हिब्बीया सी कया, काय जानु तुमु आमरा मध्य माज रयता होसे; पछा आमु तुमु सी वाचा कोसा बाँधजे? ");
INSERT INTO dhn_vpl VALUES ("JS9_8","007_9_8","JOS","9","8","8","हेका योहोसु ओकाह कयो, आमु तारा दास छे। तव योहोसु ओकाह कयो, तुमु कुन छे? आरु काह सी आया होसे? ");
INSERT INTO dhn_vpl VALUES ("JS9_9","007_9_9","JOS","9","9","9","हेका ओकाह कयो, तार दास बैस सेटला देश सी तारा परमेश्वरन योहोवाक नाव सोमवीन आया छे, काहकी आमु सब यो सोमव्या छे, मतलब ओकान कीर्ति आरु जो काहय ओको मिसर मा कर्‍यो, ");
INSERT INTO dhn_vpl VALUES ("JS9_10","007_9_10","JOS","9","10","10","आरु जो काहय ओको एमोरियान दुयु राजा कर्‌या जा यरदनक तीन पार रयता हता, मतलब हेश्बोनक राजु सीहोन सी, आरु बासानक राजु ओगळ सी जो अशतारोत मा हता। ");
INSERT INTO dhn_vpl VALUES ("JS9_11","007_9_11","JOS","9","11","11","एरकरता आमरे यान डाहला लोगहन आरु आमरा देशक सब निवासिया आमु सी कया, कि वाटक करता आपने जु भोजनक चीज लीन ओकाह मेळनेक जाऊ, आरु ओकाह कयनु, कि आमु तुमरा दास छे; एरकरता हिमी तुमु आमुसी वाचा बाँधु। ");
INSERT INTO dhn_vpl VALUES ("JS9_12","007_9_12","JOS","9","12","12","जिन दाहड़े हामु तुमरे जु चालने निकळे उके दाहड़े ते हामु आपने आपने घर सी रोटो तातलो आरु ताजी ली हती; पुन हिमी देखु, यो सुख गयो छे आरु इकामा बुर्थाय गईली छे। ");
INSERT INTO dhn_vpl VALUES ("JS9_13","007_9_13","JOS","9","13","13","पछा या जा मोंद हामु भर लेदा हता, तव ते नोवला हता, पुन देखु हिमी या लाम्बली जात्राक कारण जुन्ली होय गई छे। ");
INSERT INTO dhn_vpl VALUES ("JS9_14","007_9_14","JOS","9","14","14","तव उना लोगहन योहोवा सी नी पुछिया आरु उना माईन थुड़ंक खानो ली लीदा। ");
INSERT INTO dhn_vpl VALUES ("JS9_15","007_9_15","JOS","9","15","15","तव योहोसु उनाक मेळ करिन उनासी यी वाचा बाँधी कि तुमुक जीवता छुड़ु; आरु मण्डलीक प्रधाने उनाक शपथ खादी। ");
INSERT INTO dhn_vpl VALUES ("JS9_16","007_9_16","JOS","9","16","16","उनाक साथे वाचा बाँधनेक तीन दाहड़ाक बाद उनाक यो खबर मेळे, कि चा हामरे नाट रयनेवाळा लोगहन छे, आरु आमरेज वीच मा बोठला छे। ");
INSERT INTO dhn_vpl VALUES ("JS9_17","007_9_17","JOS","9","17","17","तव इसराएली कुच करिन तीसरे दाहड़े उनाक नगरक जिनान नाव गिबोन, कपीरा, बेरोत, आरु किर्यत्यारीम छे पुग गया, ");
INSERT INTO dhn_vpl VALUES ("JS9_18","007_9_18","JOS","9","18","18","आरु इसराएलीया उनाक नी देदा, काहकी मण्डलीक प्रधान उनाक साथे इस्राएलक परमेश्वर योहोवाक शपथ खादी हती। तव सब मण्डलीक लोगहन प्रधानक विरुद्ध कुड़कुड़ावने लाग्या। ");
INSERT INTO dhn_vpl VALUES ("JS9_19","007_9_19","JOS","9","19","19","तव सब प्रधान सब मण्डली सी कयो, आमु उनाक इस्राएलक परमेश्वर योहोवाक शपथ खादी छे, एरकरता हिमी उनाक हाथ नी लागाड़ सकता। ");
INSERT INTO dhn_vpl VALUES ("JS9_20","007_9_20","JOS","9","20","20","आमु उना सी यो करसु कि उका शपथक अनसारे आमु उनाक जीवता छुड़ देसु, नी ते आमरी खादली शपथक कारण आमु पर गुस्सु पड़से। ");
INSERT INTO dhn_vpl VALUES ("JS9_21","007_9_21","JOS","9","21","21","पछा प्राधाने उनाक कयो, चा जीवता छुड़े जाए। अत: प्रधानक ओका वचनक अनसारे चा सब मण्डलीक करता लकड़हारे आरु पाणी भरनेवाळा बनु। ");
INSERT INTO dhn_vpl VALUES ("JS9_22","007_9_22","JOS","9","22","22","पछु योहोसु उनाक बुलावीन कयो, तु ते हामरे वीच माज रयतु छे, पछु तु आमु सी यो कईन काह छल कर्‍यु छे, कि आमु तुमु सी बैस छेठा रयता छे? ");
INSERT INTO dhn_vpl VALUES ("JS9_23","007_9_23","JOS","9","23","23","एरकरता हिमी तुमु शापित होसे, आरु तुमु मा सी ओसा कुई नी रवसे जु दास, मतलब मारा परमेश्वरन भवनक करता लाकड़ा तुड़नेवाळो आरु भरनेवाळा नी होय। ");
INSERT INTO dhn_vpl VALUES ("JS9_24","007_9_24","JOS","9","24","24","हेका योहोसुक जवाब देदो, तार दासक यो नक्की कयो गयो हतो, कि तारा परमेश्वर योहोवा आपनो दास मुसाक आदेश देदी हती कि तुमुक चु सब देश आप देय, आरु ओकान सब निवासियाक तुमरे सामने सी सर्वनाश करे; एरकरता आमु लोगहनक तुमरे कारण सी आपना जियोन कोरता बीह गया। एरकरता आमु ओसो काम कर्‌या। ");
INSERT INTO dhn_vpl VALUES ("JS9_25","007_9_25","JOS","9","25","25","आरु हिमी हामु तारा वश मा छे, जोसो भुल चाल तुखे वारलो लागे आरु ठीक जान पड़े, तोसोज व्यवहार आमरे साथे कर। ");
INSERT INTO dhn_vpl VALUES ("JS9_26","007_9_26","JOS","9","26","26","तव ओको उनाक तोसोज कर्‌या, आरु हेका इसराएलीयाक हाथ सी ओसो बचाड्या, कि चा हेका घात करने नी जुवे। ");
INSERT INTO dhn_vpl VALUES ("JS9_27","007_9_27","JOS","9","27","27","पुन योहोसु उके दाहड़े ओकाह मण्डलीक करता, आरु योहोवा नेवाड़ ले उकामा ओकान वेदीक करता, लाकड़ा तुड़नारा आरु पानी भरनेवाळा नेवाड़ लेदा, जोसा आज तक छे। ");
INSERT INTO dhn_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","1","जव यरुशलेमन राजो अदोनीसेदेक सोमव्यु कि योहोसु ऐ कोक करता, आरु ओकान सत्यनाश कर न्हाख्या छे, आरु जोसो ओको योरीहो आरु ओकान राजा सी कर्‌या हता तोसाज ऐ आरु ओकान राजा सी भी कर्‌या छे, आरु यो भी सोमव्या कि गिबोनक निवासिया इसराएलीया सी मेल कर्‌या, आरु उनाक वीच मा रयने लाग्या छे, ");
INSERT INTO dhn_vpl VALUES ("JS10_2","007_10_2","JOS","10","2","2","तव चा बैस बीह गया, काहकी गिबोन मोटलो नगर वरन् राजनगरक तुल्य आरु ऐ सी मोटलो हतो, आरु ओकान सब निवासी शुरवीर हता। ");
INSERT INTO dhn_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","एरकरता यरुशलेमक राजा अदोनीसेदेक हेब्रोनक राजो होहामक, यर्मुतक राजो पिराम, लाकीशक राजो यापी, आरु एग्लोनक राजो दबीरक जु यो कोय मोकल्यो: ");
INSERT INTO dhn_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","“मार जु आवीन मारी मदत करु, आरु चालु आपु गिबोनक मारु; काहकी ओको योहोसु आरु इसराएलीया सी मेल मिलाप कर लेदा छे।” ");
INSERT INTO dhn_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","एरकरता यरुशलेम, हेब्रोन, यर्मुत, लाकीश, आरु एग्लोनक पाँचो एमोरी राजा आपनी आपनी सब सेना एकठी करिन चढ़ाई कर देदा, आरु गिबोनक सामने डेरु न्हाखिन उका सी युद्ध कर पड्या। ");
INSERT INTO dhn_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","तव गिबोनक रयनेवाळा गिलगालक छावनी मा योहोसुक जु यो कोय मुकल्यो, “आपना दासक तरफ सी तु आपनो हाथ नी हटावनु; जल्दी आमरे जु आवीन आमुक वाचाड़ ले, आरु आमरी मदत कर; काहकी बोयड़ा पर रयनेवाळा एमोरियाक सब राजा आमरे विरोध एकठा होया छे।” ");
INSERT INTO dhn_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","तव योहोसु सब योद्धा आरु सब शुरवीरक साथे लीन गिलगाल सी चाल पड्या ");
INSERT INTO dhn_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","आरु योहोवा योहोसु सी कयो, “उका सी मा बीहये, काहकी हाव उनाक तार हाथ मा कर देदा छे; उनामा सी एक मानुस भी तार सामने टिक नी सके।” ");
INSERT INTO dhn_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","तव योहोसु रातोरात गिलगाल सी जाईन एकाएक उना पर टूट पड्यो। ");
INSERT INTO dhn_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","तव योहोवा ओसो कर्‌या कि चा इसराएलीया सी घाबराय गया, आरु इसराएलीया गिबोनक जु उनाक मोटलो संहार कर्‌या, आरु बेथोरोनक चढ़ाव पर उनाक पछव करिन अजेका आरु मक्केदा तक उकाह देतो देतो गयो। ");
INSERT INTO dhn_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","पछा जव चा इसराएलीयाक सामने सी डासीन बेथोरोन की उतराई पर आयो, तव अजेका पुगता तक योहोवा आकाश सी मोटला मोटला दगड़ा करिन उनाक देदा, आरु चो मर गयो; जा ओलो सी मर गया उनाक गिनती इसराएलीयाक तलवार सी मरला होया सी जास्ती हती। ");
INSERT INTO dhn_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","उके टेमे, मतलब जीन दाहड़े योहोवा भगवान एमोरियाक इसराएलीयाक वश मा कर देदा, उके दाहड़े योहोसु योहोवा सी इसराएलीयाक देखता ओका प्रकार कया, “हे सुर्य, तु गिबोन पर, आरु हे चाँदबाबा, तु अय्यालोनक तराईन ऊपर उबो रयो।” ");
INSERT INTO dhn_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","आरु सुर्य उके टेमे तक रुकायलो रयो, आरु चाँद भी उके टेमे तक उबो रयो, जव तक उका जातिक लोगहन आपना दुश्मन सी बदलु नी लेदा। काय यी वात याशार नावन किताब मा नी लिखला छे कि सुर्य आकाशमण्डल क वीचमा उबो रयो, आरु लगभग चार पहर तक नी डूबलो? ");
INSERT INTO dhn_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","नी ते ओकान पेहेल एकदु ओसलु दाहाडु आरु नी उकान बाद, जेका मा योहोवा काहना मानसन सोमवलो छे; काहकी योहोवा ते इस्राएलक तरफ सी लड़तो हतो। ");
INSERT INTO dhn_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","तव योहोसु सब इसराएलीया समेत गिलगालक छावनीमा वापस गयो। ");
INSERT INTO dhn_vpl VALUES ("JS10_16","007_10_16","JOS","10","16","16","चा पाच राजा डासीन मक्केदाक साथे वाळा गुफामा धोपाया। ");
INSERT INTO dhn_vpl VALUES ("JS10_17","007_10_17","JOS","10","17","17","तव योहोसुक यो खबर जोड्यो, “पाचु राजा मक्केदाक साथे वाळा गुफामा धोपायला जोड्या छे।” ");
INSERT INTO dhn_vpl VALUES ("JS10_18","007_10_18","JOS","10","18","18","योहोसु कयो, “गुफाक मुहय पर मोटला मोटला दगड़ा डुव्वीन उकान देखभाव क करता मानसक उकाम जु बठाड़ देवु; ");
INSERT INTO dhn_vpl VALUES ("JS10_19","007_10_19","JOS","10","19","19","पुन तुमु मा उबा रयु, आपना दुश्मनक पछव पड़ीन उनामा सी जा जा पिछड़ी गया छे उनाक मार न्हाखु, एका आपना आपना नगर मा आवनेन टेमे मा आपु; काहकी तुमरु परमेश्वर योहोवा उनाक तुमरा हाथ मा कर देदा छे।” ");
INSERT INTO dhn_vpl VALUES ("JS10_20","007_10_20","JOS","10","20","20","जव योहोसु आरु इसराएली उकान संहार करिन हेका खतम कर देदा, आरु उनामा सी जा वाच गया चा आपना आपना गढ़वाळा नगर मा बोराय गया, ");
INSERT INTO dhn_vpl VALUES ("JS10_21","007_10_21","JOS","10","21","21","तव सब लोगहनक मक्केदाक छावनीक योहोसुक जु वारु आरगाय सी वापस आया; आरु इसराएलीयाक विरुद्ध कुई जीभ तक नी हालाड्या। ");
INSERT INTO dhn_vpl VALUES ("JS10_22","007_10_22","JOS","10","22","22","तव योहोसु आदेश देदु, “गुफान मुहय उगाड़ीन उना पाचो राजाक मार निकाड़ लावु।” ");
INSERT INTO dhn_vpl VALUES ("JS10_23","007_10_23","JOS","10","23","23","हेका ओसाज कर्‌या, आरु यरुशलेम, हेब्रोन, यर्मुत, लाकीश, आरु एग्लोनक उना पाचु राजाक गुफा मा सी ओका जु निकाड़ आया। ");
INSERT INTO dhn_vpl VALUES ("JS10_24","007_10_24","JOS","10","24","24","जव चा उना राजाक योहोसु इस्राएलक सब मानसक बुलावीन आपने साथे चालने वाळा योद्धाक प्रधान सी कया, “साथे आवीन आपना आपना पाये इना राजान भुचारा पर मेकु।” आरु हेका नाट जाईन आपना आपना पायक उनाक भुचारा पर मेक्या। ");
INSERT INTO dhn_vpl VALUES ("JS10_25","007_10_25","JOS","10","25","25","तव योहोसु उनाक कयो, “बीहयु मा, आरु नी तुमरो मन कच्चो होए; हियाव बाँधीन पक्को होय; काहकी योहोवा तुमरा सब दुश्मन सी जिना सी तुमु लड़नेवाळा होसे ओसाज करसे।” ");
INSERT INTO dhn_vpl VALUES ("JS10_26","007_10_26","JOS","10","26","26","ओका बाद योहोसु उनाक म्हार न्हाखाड्यो, आरु पाच झाड़का पर लटकाड़ देदा। आरु चा साँजु तक उनाक झाड़का पर लटकाड़ रया। ");
INSERT INTO dhn_vpl VALUES ("JS10_27","007_10_27","JOS","10","27","27","दाहड़ु बुड़ता बुड़ता योहोसु सी आदेश लीन लोगहन नी हेका उना झाड़का पर सी उतारीन उका गुफा मा जा चा धोपाय गया हता न्हाख देदा, आरु उका गुफान मुहय पर मोटला मोटला दगड़ा मेक देदा, चा आज तक चा मेकला छे। ");
INSERT INTO dhn_vpl VALUES ("JS10_28","007_10_28","JOS","10","28","28","उके दाहड़े योहोसु मक्केदाक ली लेदो, आरु ओकाह तलवार करिन म्हार देदो, आरु राजान सत्यनाश कर्‍यो; आरु जोतरा प्राणी ओकामा हता उना सभा मा सी काहनाक नी जीवता नी छुड्यो; आरु जोसो ओको योरीहोक राजान साथे कर्‌या हता तोसोज मक्केदाक राजा सी भी कर्‌या। ");
INSERT INTO dhn_vpl VALUES ("JS10_29","007_10_29","JOS","10","29","29","तव योहोसु सब इसराएलीया समेत मक्केदा सी चालीन लिब्नाक गया, आरु लिब्ना सी लड़ायो; ");
INSERT INTO dhn_vpl VALUES ("JS10_30","007_10_30","JOS","10","30","30","आरु योहोवा उकाह भी राजा समेत इसराएलीया क हाथ मा कर देदा; आरु योहोसु उकाह आरु उकामा क सब जनावर क तलवार सी म्हार्‍या; आरु ओकामा सी काहना भी जीवता नी छुड्या; आरु ओकान राजा सी तोसोज कर्‍यो जोसो ओको योरीहो क राजाक साथे कर्‌या हता। ");
INSERT INTO dhn_vpl VALUES ("JS10_31","007_10_31","JOS","10","31","31","पछु योहोसु सब इसराएलीया समेत लिब्ना सी चालीन लाकीशक गयो, आरु ओकान विरुद्ध छावनी न्हाखिन लड्या; ");
INSERT INTO dhn_vpl VALUES ("JS10_32","007_10_32","JOS","10","32","32","आरु योहोवा लाकीशक इस्राएलक हाथ मा कर देदा, आरु दिसरे दाहड़े ओको उकाह जीक लेदा; आरु जोसो ओको लिब्नाक सब जनावरक तलवार सी म्हार्‍या हता तोसाज ओको लाकीश सी भी कर्‌या। ");
INSERT INTO dhn_vpl VALUES ("JS10_33","007_10_33","JOS","10","33","33","तव गेजेरक राजा होराम लाकीशक मदत करिन चढ़ आया; आरु योहोसु प्रजा समेत ओकाह भी ओसा मारा क ओकान करता काहनाक नी छुड्या। ");
INSERT INTO dhn_vpl VALUES ("JS10_34","007_10_34","JOS","10","34","34","पछा योहोसु सब इसराएलीया समेत लाकीश सी चालीन एग्लोनक गया; आरु ओकान विरुद्ध छावनी न्हाखिन युद्ध करने लाग्या; ");
INSERT INTO dhn_vpl VALUES ("JS10_35","007_10_35","JOS","10","35","35","आरु उके दाहड़े हेका उकाह ली लेदा, आरु ओकाह तलवार सी म्हार्‍या; आरु उके दाहड़े जोसो उकाह लाकीशक सब जनवारीयान क सत्यनाश कर न्हाख्या हता तोसोज उका एग्लोन सी भी कर्‌या। ");
INSERT INTO dhn_vpl VALUES ("JS10_36","007_10_36","JOS","10","36","36","पछा योहोसु सब इसराएलीया समेत एग्लोन सी चालीन हेब्रोनक गयो, आरु उका सी लड़ने लाग्या; ");
INSERT INTO dhn_vpl VALUES ("JS10_37","007_10_37","JOS","10","37","37","आरु हेका उका ली लेदा, आरु ओकाह आरु ओका राजो आरु सब गावक आरु उनामा सब जनावर तोलवार सी म्हार्‍या; जोसो योहोसु एग्लोन सी कर्‌या हता तोसोज हेब्रोन मा भी काहनाक जीवता नी छुड्या; उको ओकाह आरु उकामा सब जीव जनवार क सत्यनाश कर न्हाख्या। ");
INSERT INTO dhn_vpl VALUES ("JS10_38","007_10_38","JOS","10","38","38","तव योहोसु सब इसराएलीया समेत फिरीन दबीरक गया, आरु उकाह लड़ने लाग्या; ");
INSERT INTO dhn_vpl VALUES ("JS10_39","007_10_39","JOS","10","39","39","आरु राजा समेत उका आरु सब गावक ली लेदा; आरु हेका उनाक तलवार सी घात कर्‌या, आरु जोतरा जनावर उनामा हता सबन सत्यनाश कर न्हाख्या; काहना क जीवता नी छुड्या, जोसु योहोसु हेब्रोन आरु लिब्ना आरु ओकान राजा सी कर्‌या हता तोसोज ओका दबीर आरु ओकाह राजा सी भी कर्‌या। ");
INSERT INTO dhn_vpl VALUES ("JS10_40","007_10_40","JOS","10","40","40","ओका प्रकार योहोसु उका सब देशक, मतलब पहाड़ी देश, दोखेवरे देश, नेड़ला देश, आरु ढालु देशक, उनाक सब राजा समेत म्हार्‍या; आरु इस्राएलक परमेश्वर योहोवाक हुकुमोक अनसारे एकाह भी जीवता नी छुड्या, वरन् जोतरा जनावर हता सभाक सत्यनाश कर न्हाख्या। ");
INSERT INTO dhn_vpl VALUES ("JS10_41","007_10_41","JOS","10","41","41","आरु योहोसु कादेशबर्ने सी ली ले अज्जा तक, आरु गिबोन तक सब गोशेन देशक लोगहनक म्हार्‍यो। ");
INSERT INTO dhn_vpl VALUES ("JS10_42","007_10_42","JOS","10","42","42","इना सब राजाक उनाक देशो समेत योहोसु एकुज टेमे मा ली लेदा, काहकी इस्राएलक परमेश्वर योहोवा इसराएलीयाक तरफ सी लड़ता हता। ");
INSERT INTO dhn_vpl VALUES ("JS10_43","007_10_43","JOS","10","43","43","तव योहोसु सब इसराएलीया समेत गिलगालक छावनी मा वापस आयो। ");
INSERT INTO dhn_vpl VALUES ("JS11_1","007_11_1","JOS","11","1","1","यो सोमवीन हासोरक राजा याबीन मादोनक राजा योबाब, आरु शिम्रोन आरु अक्षाप राजाक, ");
INSERT INTO dhn_vpl VALUES ("JS11_2","007_11_2","JOS","11","2","2","आरु जा जा राजा उत्तरक तरफ पहाड़ी देश मा. तरफ किन्नेरेत दोखेवरे अराबा मा, आरु नेड़ला देश मा, आरु पश्चिमक तरफ दोर क देश मा रयता हता, उनाक, ");
INSERT INTO dhn_vpl VALUES ("JS11_3","007_11_3","JOS","11","3","3","आरु पुरब पश्चिम दोनो तरफन रयनेवाळा कनानियो, आरु एमोरियो, हित्तियो, परिज्जियो, आरु पहाड़ी यबुसियो, आरु मिस्पा देश मा हेर्मोन बोयड़ाक नेड़ा रयनेवाळा हिब्बीया क कय मुकल्यो। ");
INSERT INTO dhn_vpl VALUES ("JS11_4","007_11_4","JOS","11","4","4","आरु चा आपनी आपनी सेना समेत, जा दरियाक धोड़ेन बालु क किनकाक समान बैस हती, भेवाईन निकळ आया, आरु उनाक साथ घण सवटा घुल्‌ला आरु घुड़ सवारी भी हुती। ");
INSERT INTO dhn_vpl VALUES ("JS11_5","007_11_5","JOS","11","5","5","तव चा सब राजा सम्मति करिन एकठा होया, आरु इसराएलीया सी लड़नेक मेरोम नावन तालक जु आवीन एक संग छावनी न्हाखि। ");
INSERT INTO dhn_vpl VALUES ("JS11_6","007_11_6","JOS","11","6","6","तव योहोवा योहोसु सी कयो, उना सी मा बीहयु, काहकी काल इके टेमे उना सभाक इसराएलीया क वश मा करिन माराव न्हाखाड़ दिस; तव तु उनाक घुल्‌लान क माणडान माईन नस कटाड़जी, आरु हेनका घुड़सवारीयान क खतम कर देजी। ");
INSERT INTO dhn_vpl VALUES ("JS11_7","007_11_7","JOS","11","7","7","आरु योहोसु सब योद्धा समेत मेरोम नावन तालक जु अचानक पुगीन उना पर टूट पड्या। ");
INSERT INTO dhn_vpl VALUES ("JS11_8","007_11_8","JOS","11","8","8","आरु योहोवा उनाक इसराएलीया क हाथ मा कर देदा, एरकरता हेकाक हेका मार लेदा, आरु मोटला नगर मा सीदोन आरु मिसर पोतमैम तक, आरु पुर्वक तरफ मिस्पेक मैदान तक उनाक पछव कर्‌या; आरु ओकाक मार्‍या, आरु उनामा सी काहना क जीवता नी छुड़नु। ");
INSERT INTO dhn_vpl VALUES ("JS11_9","007_11_9","JOS","11","9","9","तव योहोसु योहोवा क आदेश क अनसारे उना सी कर्‌या. मतलब उनाक गुल्‌लाक घुटनाक नस कटाड़ीया, आरु उनाक रथ आग्ठा मा धोपाड़ीन भस्म कर देदा। ");
INSERT INTO dhn_vpl VALUES ("JS11_10","007_11_10","JOS","11","10","10","उके टेमे योहोसु फिरीन हासोर क जा पेहेल उना सब राज्य मा मुखी हता ली लेदा, आरु उकान राजाक तलवार सी म्हार न्हाख्या। ");
INSERT INTO dhn_vpl VALUES ("JS11_11","007_11_11","JOS","11","11","11","आरु जोतरा जनावरे ओकामा हता उन सभाक हेका तलवार सी मारीन सत्यनाश कर्‌या; आरु हासोर काजे योहुसु जनावर नी ओगव लागाड़ीन फुँकवा देदा। ");
INSERT INTO dhn_vpl VALUES ("JS11_12","007_11_12","JOS","11","12","12","आरु उना सब नगरक उनाक सब राजा समेत योहोसु नी ली लेदा, आरु योहोवाक दास मुसान हुकुमोक अनसारे उनाक तलवार सी घात करिन सत्यनाश कर्‌या। ");
INSERT INTO dhn_vpl VALUES ("JS11_13","007_11_13","JOS","11","13","13","पुन हासोरक छुड़ीन, जेको योहोसु आगठो लगाड़ीन धपाड़ दीदो, आरु इस्राएल कोय दिसरा नगर क जा टिला पर बनलो हुतो उको नी धोपाड्या। ");
INSERT INTO dhn_vpl VALUES ("JS11_14","007_11_14","JOS","11","14","14","आरु इना नगर क जीव जनवारीयान क इनाक सब लुटक इसराएलीया आपना कर देदा; पुन मानसक हेका तलवार सी मार न्हाख्या, या तक उनाक सत्यनाश कर न्हाख्या कि एक भी जनावरक जीवता नी छुड्या गया। ");
INSERT INTO dhn_vpl VALUES ("JS11_15","007_11_15","JOS","11","15","15","जो आदेश योहोवा आपना दास मुसाक आप देदी हती उकान अनसारे मुसु योहोवाक आदेश देदो हतो, आरु ठीक तोसाज योहोसु कर्‍यो भी; जो जो आदेश योहोवा मुसाक देदो हतो उनामा सी योहोसु कुई भी पुरी करे बिना नी छुड़ी। ");
INSERT INTO dhn_vpl VALUES ("JS11_16","007_11_16","JOS","11","16","16","तव योहोसु उका सब देशक, मतलब पहाड़ी देश, आरु सब दोखेवरे देश, आरु कुल गोशेन देश, आरु नेड़ला देश, अराबा, आरु इस्राएलक पहाड़ी देश, आरु उकान नेडलावाळा देशक, ");
INSERT INTO dhn_vpl VALUES ("JS11_17","007_11_17","JOS","11","17","17","हालाक नावन पहाड़ सी ले, जो सेईर क चढ़ाई पर छे, बालगाद तक, जा लबानोन मैदान मा हेर्मोन बोयड़ान नेड़ा छे, जोतरा देश छे उना सबक जीत लेदा आरु उना देशक सब राजाक धरीन मार न्हाख्या। ");
INSERT INTO dhn_vpl VALUES ("JS11_18","007_11_18","JOS","11","18","18","उना सब राजा सी युद्ध करता करता योहोसुक बैस दाहाड़ा लाग गया। ");
INSERT INTO dhn_vpl VALUES ("JS11_19","007_11_19","JOS","11","19","19","गिबोनक निवासी हिब्बीयाक छुड़ आरु एकदा नगर क लोगहन इसराएलीया सी मेलमिलाप नी कर्‌या; आरु सब नगरक हेका लड़ लड़ीन जीत लेदा। ");
INSERT INTO dhn_vpl VALUES ("JS11_20","007_11_20","JOS","11","20","20","काहकी योहोवाक जी मनसा हती, कि आपनी उको हुकुमोन अनसारे जी ओको मुसाक आपी हती उना पर काहय भी दया नी करे, वरन् सत्यनाश कर न्हाखे, ओका कारण ओको उनाक मन ओसा वातड़ो कर देदा, कि हेका इसराएलीयाक सामना करिन उनाक युद्ध कर्‌या। ");
INSERT INTO dhn_vpl VALUES ("JS11_21","007_11_21","JOS","11","21","21","उके टेमे योहोसु पहाड़ी देश मा आवीन हेब्रोन, दबीर, अनाब, वरन् यहुदा आरु इस्राएल दुयोक सब पहाड़ी देश मा रयनेवाळा अनाकिया क खतम कर्‌या; योहोसु नगर समेत उनाक सत्यनाश कर न्हाख्या। ");
INSERT INTO dhn_vpl VALUES ("JS11_22","007_11_22","JOS","11","22","22","इसराएलीया क देश मा कुई अनाकी नी रय गया; केवल अज्जा, गत, आरु अशदोद मा कुई कुई रय गया। ");
INSERT INTO dhn_vpl VALUES ("JS11_23","007_11_23","JOS","11","23","23","जोसो योहोवा मुसा सी कयो हतो, तोसोज योहोसु चा सब देश ली लेदा; आरु उका इस्राएलक गोत्रा आरु कुलोक अनसारे बाँट करिन हेका आप देदा। आरु देशक लड़ाई सी शान्ति जोड़ी। ");
INSERT INTO dhn_vpl VALUES ("JS12_1","007_12_1","JOS","12","1","1","यरदन पार सुर्यदयक तरफ, मतलब अर्नान घाटी सी लीन अर्नोन बोयड़ा तक देश, आरु सब पुर्वी अराबाक जीन राजाक इसराएलीया मारीन ओकान देशक आपना हक मा कर लेदा हता चा या छे: ");
INSERT INTO dhn_vpl VALUES ("JS12_2","007_12_2","JOS","12","2","2","एमोरियाक हेशबोनवासी राजा सीहोन, जा अर्नान घाटीक किनाराक अरोएर सी लीन, आरु उका घाटीक वीच माहयला नगरक छुड़ीन यब्बोक नदी तक, जा अम्मोनिया क सीमा छे, आदा गिलाद पर, ");
INSERT INTO dhn_vpl VALUES ("JS12_3","007_12_3","JOS","12","3","3","आरु किन्नेरेत नावन ताल सी लीन बेत्यशीमोत सी होईन अराबाक ताल तक; जो खारो ताल भी कयाड़तो छे, पुर्वक तरफ अराबा, आरु दक्षिणक तरफ पिसगाक ढलान क नेड़ला देश पर पोरबुता राखता हता। ");
INSERT INTO dhn_vpl VALUES ("JS12_4","007_12_4","JOS","12","4","4","पछा वाचला होया रपाया मा सी बासान क राजा ओगक देश हतो, जो अशतारोत आरु एद्रेई मा रया करता हता, ");
INSERT INTO dhn_vpl VALUES ("JS12_5","007_12_5","JOS","12","5","5","आरु हेर्मोन बोयड़ा, सलका, आरु गशुरिया, आरु माकियाक सीमा तक कुल बासान मा, आरु हेशबोनक राजा सीहोन क सीमा तक आदा गिलाद मा भी पोरबुता करता हता, ");
INSERT INTO dhn_vpl VALUES ("JS12_6","007_12_6","JOS","12","6","6","इसराएलीया आरु योहोवाक दास मुसा इनुक मार लेदु; आरु योहोवाक दास मुसा ओका देश रुबेनिया आरु गादिया आरु मनश्शे क आदा गोत्रा क लोगहन क आप देदा। ");
INSERT INTO dhn_vpl VALUES ("JS12_7","007_12_7","JOS","12","7","7","यरदन क पश्चिमक तरफ, लबानोन क मैदान मा बालगाद सी लीन सेईरक चढ़ाईन हालाक पहाड़ तक देशक जीन राजान योहोसु आरु इसराएलीया मारीन उनाक देश इसराएलीयाक गोत्रा आरु कुलोक अनसारे डासीन आप देदा हता चा या छे: ");
INSERT INTO dhn_vpl VALUES ("JS12_8","007_12_8","JOS","12","8","8","हित्ती, आरु एमोरी, आरु कनानी, आरु परिज्जी, आरु हिब्बी, आरु यबुसी, जा पहाड़ी देश मा, आरु नेड़ला देश मा, आरु अराबा मा, आरु ढालु देश मा, आरु जंगल मा, आरु दोखेवरे देश मा रयता हता। ");
INSERT INTO dhn_vpl VALUES ("JS12_9","007_12_9","JOS","12","9","9","एक, योरीहो क राजा; एक, बेतेल क जु ऐ क राजा; ");
INSERT INTO dhn_vpl VALUES ("JS12_10","007_12_10","JOS","12","10","10","एक, यरुशलेम क राजो; एक, हेब्रोन क राजा; ");
INSERT INTO dhn_vpl VALUES ("JS12_11","007_12_11","JOS","12","11","11","एक, यर्मुत क राजा; एक, लाकीश क राजा; ");
INSERT INTO dhn_vpl VALUES ("JS12_12","007_12_12","JOS","12","12","12","एक, एग्लोन क राजा; एक, गेजेर क राजा; ");
INSERT INTO dhn_vpl VALUES ("JS12_13","007_12_13","JOS","12","13","13","एक, दबीर क राजा; एक, गेदेर क राजा; ");
INSERT INTO dhn_vpl VALUES ("JS12_14","007_12_14","JOS","12","14","14","एक, होर्मा क राजा; एक, अराद क राजा; ");
INSERT INTO dhn_vpl VALUES ("JS12_15","007_12_15","JOS","12","15","15","एक, लिब्ना क राजा; एक अदुल्‌लाम क राजा; ");
INSERT INTO dhn_vpl VALUES ("JS12_16","007_12_16","JOS","12","16","16","एक, मक्केदा क राजा; एक, बेतेल क राजा; ");
INSERT INTO dhn_vpl VALUES ("JS12_17","007_12_17","JOS","12","17","17","एक, तप्पुह क राजा; एक, हेपेर क राजा; ");
INSERT INTO dhn_vpl VALUES ("JS12_18","007_12_18","JOS","12","18","18","एक, अपेक क राजा; एक, लश्शारोन क राजा; ");
INSERT INTO dhn_vpl VALUES ("JS12_19","007_12_19","JOS","12","19","19","एक, मादोन क राजा; एक, हासोर ज राजा; ");
INSERT INTO dhn_vpl VALUES ("JS12_20","007_12_20","JOS","12","20","20","एक, शिम्रोरोन क राजा; एक, अक्षाप क राजा; ");
INSERT INTO dhn_vpl VALUES ("JS12_21","007_12_21","JOS","12","21","21","एक, तानाक क राजा; एक, मगिद्दो क राजा; ");
INSERT INTO dhn_vpl VALUES ("JS12_22","007_12_22","JOS","12","22","22","एक, केदेश क राजा; एक, कार्मेल माहयन योकनाम क राजा; ");
INSERT INTO dhn_vpl VALUES ("JS12_23","007_12_23","JOS","12","23","23","एक, दोर नावन उँचला देश मा दोर क राजा; एक, गिलगाल मा क गोयीम क राजा; ");
INSERT INTO dhn_vpl VALUES ("JS12_24","007_12_24","JOS","12","24","24","आरु एक, तिर्सा क राजा छे; ओका प्रकार सब राजा इकतीस होया। ");
INSERT INTO dhn_vpl VALUES ("JS13_1","007_13_1","JOS","13","1","1","योहोसु डाहलो आरु बैस उमोर होय गयो हतो; आरु योहोवा ओकाह कयो, “तु डाहलो आरु बैस उमोर होय गयो छे, आरु बैस देश रय गया छे, जा इस्राएलक हक मा हिमी तक नी आया। ");
INSERT INTO dhn_vpl VALUES ("JS13_2","007_13_2","JOS","13","2","2","या देश रय गया छे, मतलब पोलिस्तीयाक सब प्रान्त, आरु सब गशुरी ");
INSERT INTO dhn_vpl VALUES ("JS13_3","007_13_3","JOS","13","3","3","(मिसरन ओगव शीहोर सी लीन उत्तरन तरफ एक्रोनक सीमा तक जु कनानीया क भाग गिवनु जातु छे; आरु पलिश्तियाक पाँचु सरदार, मतलब अज्जा, अशदोद, अशकलोन, गत, आरु एक्रोनक लोगहन), आरु दक्षिणक तरफ अव्वी भी, ");
INSERT INTO dhn_vpl VALUES ("JS13_4","007_13_4","JOS","13","4","4","पछा अपेक आरु एमोरियाक सीमा तक कनानियाक सब देश, आरु सीदोनियाक मारा नावन देश, ");
INSERT INTO dhn_vpl VALUES ("JS13_5","007_13_5","JOS","13","5","5","पछु गवालियाक देश, आरु सुर्‌योदयक तरफ हेर्मोन बोयड़ाक नेड़ला बालगाद सी लीन हमातक घाटी तक सब लबानोन, ");
INSERT INTO dhn_vpl VALUES ("JS13_6","007_13_6","JOS","13","6","6","पछा लबानोन सी लीन मिसर मिस्रपोतमैम तक सीदोनियाक पहाड़ी देशक निवासी। इनुक हाव इसराएलीयाक सामने सी निकाळ दिस; ओतरो होय के तु मारा हुकुमोक अनसारे चिट्ठी न्हाख न्हाखिन उनाक देश इस्राएलक वाट दे। ");
INSERT INTO dhn_vpl VALUES ("JS13_7","007_13_7","JOS","13","7","7","एरकरता तु हिमी ओका देशक नोव गोत्रा आरु मनश्शेन आदा गोत्राक उनाक भाग होयने करता वाट दे।” ");
INSERT INTO dhn_vpl VALUES ("JS13_8","007_13_8","JOS","13","8","8","रुबेनिया आरु गादियाक ते चो भाग जोड़ चुक्यो हतो, जेका मुसु हेका यरदनक पुर्व दिशान तरफ देदो हतो, काहकी योहोवाक दास मुसु यो हेकाक आप देदु हतु, काहकी योहोवाक दास मुसु यो हेनाक आप देदु हतु, ");
INSERT INTO dhn_vpl VALUES ("JS13_9","007_13_9","JOS","13","9","9","मतलब अर्नोन नावन घाटीन किनाराक अरोएर सी लीन, आरु उका घाटीन वीच माहयलो नगरक छुड़ीन दीबोन तक मेदबाक जु सब चोरस देश; ");
INSERT INTO dhn_vpl VALUES ("JS13_10","007_13_10","JOS","13","10","10","आरु अम्मोनियाक सीमा तक हेशबोन मा बोठनेवाळा एमोरियाक राजा सीहोनक सब नगर; ");
INSERT INTO dhn_vpl VALUES ("JS13_11","007_13_11","JOS","13","11","11","आरु गिलाद देश, आरु गशुरिया आरु माकियावासियान सीमा, आरु सब हेर्मोन बोयड़ा, आरु सलका तक सब बासान, ");
INSERT INTO dhn_vpl VALUES ("JS13_12","007_13_12","JOS","13","12","12","पछु आशतारोत आरु एद्रेई मा बोठनेवाळा ओका ओगव क सब राज्या जा रपाया मा सी एखला वाच गया हता; काहकी बासानक मुसु मारीन उनाक प्रजाक तीना देशम रईन निकाळ देदा हता। ");
INSERT INTO dhn_vpl VALUES ("JS13_13","007_13_13","JOS","13","13","13","पुन इसराएलीया गशुरिया आरु माकियाक उनाक देश सी नी निकाळ्या; एरकरता गशुरी आरु माकी इसराएलीयाक वीचमा आज तक रयता छे। ");
INSERT INTO dhn_vpl VALUES ("JS13_14","007_13_14","JOS","13","14","14","आरु लेवीन गोत्रियाक ओको कोय भाग नी देदा; काहकी इस्राएलक परमेश्वर योहोवाक वचनक अनसारे ओकाक हव्य उनाक करता डास निकळ्या छे। ");
INSERT INTO dhn_vpl VALUES ("JS13_15","007_13_15","JOS","13","15","15","मुसु रुबेनक गोत्राक उनाक कुलोक अनसारे आप्या, ");
INSERT INTO dhn_vpl VALUES ("JS13_16","007_13_16","JOS","13","16","16","मतलब अर्नोन नावन घाटीन धोड़े अरोएर सी लीन आरु ओकी घाटीक वीच माहयला नगरक छुड़ीन मेदबाक साथेवाळो सब चोरस देश; ");
INSERT INTO dhn_vpl VALUES ("JS13_17","007_13_17","JOS","13","17","17","पछु चोरस देश मा हेशबोन आरु ओकाक सब गाँव; पछा दीबोन, बामोतबाल, बेतबाल्मोन, ");
INSERT INTO dhn_vpl VALUES ("JS13_18","007_13_18","JOS","13","18","18","यहसा, कदेमोत, मेपात, ");
INSERT INTO dhn_vpl VALUES ("JS13_19","007_13_19","JOS","13","19","19","किरयातेम, सिबमा, आरु तराई मा पहाड़ पर बोठलो सेरेथश्सोहोर, ");
INSERT INTO dhn_vpl VALUES ("JS13_20","007_13_20","JOS","13","20","20","बेतपोर, पिसगाक ढलान आरु बेत्यशीमोत, ");
INSERT INTO dhn_vpl VALUES ("JS13_21","007_13_21","JOS","13","21","21","मतलब चोरस देश मा बोठला होया हेशबोन मा बोठनेवाळा एमोरियाक उका राजा सीहोनक राज्याक सब नगर जिनाक मुसु मार लेदु हतु। मुसु एवी, रेकेम, सुर, हुर, आरु रेबा नावन मिद्यानक प्रधानक भी मार न्हाख्या हता जो सीहोनक ठरायो होयो हाकिम आरु ओका देशक निवासी हता। ");
INSERT INTO dhn_vpl VALUES ("JS13_22","007_13_22","JOS","13","22","22","आरु इसराएलीया उनाक आरु मारे होयाक साथ बोरक पोर्‌यो ओगवायती वात कोवनेवाळा बिलामक भी तलवार सी मार न्हाख्या। ");
INSERT INTO dhn_vpl VALUES ("JS13_23","007_13_23","JOS","13","23","23","आरु रुबेनियाक सीमा यरदनक धोड़े उभी रयी। रुबेनियाक भाग उनाक कुलक अनसारे नगर आरु गावो समेत या रयी। ");
INSERT INTO dhn_vpl VALUES ("JS13_24","007_13_24","JOS","13","24","24","पछु मुसु गादक गोत्रियाक भी कुलक अनसारे उनाक भाग करिन वाट देदा। ");
INSERT INTO dhn_vpl VALUES ("JS13_25","007_13_25","JOS","13","25","25","तव यो ठर्‍यो, मतलब याजेर आदि गिलादक सब नगर, आरु रब्‍बाक सामनेन अरोएर तक अम्मोनियाक आदो देश, ");
INSERT INTO dhn_vpl VALUES ("JS13_26","007_13_26","JOS","13","26","26","आरु हेशबोन सी रामत मिस्पे आरु बोटोनीम तक, आरु महनेम सी दबीरक सीमा तक, ");
INSERT INTO dhn_vpl VALUES ("JS13_27","007_13_27","JOS","13","27","27","आरु तराई मा बेथारम, बेतनिम्रा, सुक्कोत, आरु सापोन, आरु हेशबोनक राजु सीहोनक राज्याक वाचला भाग, आरु किन्नेरेत नावन तालक सिरे तक, यरदनक पुर्वन तरफन चो देश जेरी सीमा यरदन छे। ");
INSERT INTO dhn_vpl VALUES ("JS13_28","007_13_28","JOS","13","28","28","गादियाक भाग उकान कुलक अनसारे नगर आरु गाव समेत या उबो रई। ");
INSERT INTO dhn_vpl VALUES ("JS13_29","007_13_29","JOS","13","29","29","पछु मुसु मनश्शेक आदा गोत्रियाक ओकान निज भाग करिन देदा; चो मनश्शेइयाक आदो गोत्राक निज ओकान कुलक अनसारे ठर्‍या। ");
INSERT INTO dhn_vpl VALUES ("JS13_30","007_13_30","JOS","13","30","30","हेनको जागान सेड़ो यो छे, मतलब महनेम सी लीन बासानक राजु ओगक राज्याक सब देश, आरु बासान मा बठली होई याईर क साठों बस्तिया, ");
INSERT INTO dhn_vpl VALUES ("JS13_31","007_13_31","JOS","13","31","31","आरु गिलादक आदो भाग, आरु अशतारोत, आरु एद्रेई, जो बासान मा ओगक राज्याक नगर हता, या मनश्शेक पोर्‌यो माकीरक ओवलियाद क, अनसारे ठहरे। ");
INSERT INTO dhn_vpl VALUES ("JS13_32","007_13_32","JOS","13","32","32","जा भाग मुसु मोआबक अराबामा योरीहोक जु यरदनक पेहल वाट देदा चा या छे। ");
INSERT INTO dhn_vpl VALUES ("JS13_33","007_13_33","JOS","13","33","33","पुन लेवीक गोत्राक मुसाक कुई भाग नी देदा; इस्राएलक परमेश्वर योहोवाज आपना वचनक अनसारे ओकान भाग ठरे। ");
INSERT INTO dhn_vpl VALUES ("JS14_1","007_14_1","JOS","14","1","1","जु जु भाग इसराएलीया कनान देश मा जोड्या, जिनाक एलीयाजर याजक, आरु नुनक पोर्‌यो योहोसु, आरु इसराएली गोत्राक डाहला घरानान मुखी मुखी मानसे उनाक देदा चा या छे। ");
INSERT INTO dhn_vpl VALUES ("JS14_2","007_14_2","JOS","14","2","2","जी हुकुम योहोवा मुसाक द्वारा साढ़े नोव गोत्राक करता आपी हती, ओकान अनसारे ओकान भाग चिट्ठी न्हाख न्हाखिन आप गयो। ");
INSERT INTO dhn_vpl VALUES ("JS14_3","007_14_3","JOS","14","3","3","मुसु ते अड़ीच गोत्रान भाग यरदन पार आप्या हता; पुन लेवियाक ओको उनाक वीचमा काहनो भाग नी आप्यो हतो। ");
INSERT INTO dhn_vpl VALUES ("JS14_4","007_14_4","JOS","14","4","4","युसुफक ओवलियाद क ते दुय गोत्रा होय गया हता, मतलब मनश्शे आरु एपरेम; आरु ओको देश मा लेवियाक थुड़ोक भाग नी आप्या, केवल रयनेवाळ नगर, आरु पशु आदि धन राखनेक चाराई ओकोक जोड़ी। ");
INSERT INTO dhn_vpl VALUES ("JS14_5","007_14_5","JOS","14","5","5","जी हुकुम योहोवा मुसाक आपी हती ओकान अनसारे इसराएलीया कर्‌या; आरु हेका देशक वाट लेदा। ");
INSERT INTO dhn_vpl VALUES ("JS14_6","007_14_6","JOS","14","6","6","तव यहुदी योहोसुक जु गिलगाल मा आया; आरु कनजी यपुन्नेक पोर्‌यो कनिज्‍जी कालेब ओकाह कयो, “तु जानतु होसे कि योहोवा कादेशबर्ने मा परमेश्वरक जन मुसा सी मार आरु तार बारामा काय कया हता। ");
INSERT INTO dhn_vpl VALUES ("JS14_7","007_14_7","JOS","14","7","7","जव योहोवाक दास मुसु मखे ओका देशक भेद लेनेक करता कादेशबर्ने सी मोकल्यो हतो तव हाव चालीस सालन हतो; आरु हाव सच्चा मन सी ओका जु खबर ली आयो। ");
INSERT INTO dhn_vpl VALUES ("JS14_8","007_14_8","JOS","14","8","8","आरु मार साथी जा मार साथे गया हता हेका ते प्रजाक लोगहन मन नाराज कर देदा, पुन हाव आपना परमेश्वरक पुरी रीति सी वात मानी। ");
INSERT INTO dhn_vpl VALUES ("JS14_9","007_14_9","JOS","14","9","9","तव उके दाहड़े मुसु शपथ खाईन मखे सी कयो, ‘तु ते पुरी रीति सी मार परमेश्वर योहोवान वातक अनुकरण कर्‌या छे, ओका कारण बिनदास जीन धरती पर तु आपना पाय धरीन आया छे चो हमेशान करता तारो आरु तार ओवलियादक भाग होसे।’ ");
INSERT INTO dhn_vpl VALUES ("JS14_10","007_14_10","JOS","14","10","10","आरु हिमी देख, जव योहोवा मुसा सी यो वचन कया हता तव सी पोयतालीस साल होय चुक्या छे, जिनामा इसराएली जंगल मा घूमता फिरता रया; ओकामा योहोवा आपने कयनेक अनसारे मखे जीविता राख्या छे; आरु हिमी पचास सालन छे। ");
INSERT INTO dhn_vpl VALUES ("JS14_11","007_14_11","JOS","14","11","11","जोतरी ताकद मुसाक मुकलनेन दाहड़े मखे मा हतो तोतरी ताकद हिमी तक मखे मा छे; युद्ध करने, या माहयता बाहरता आवने जानेक करता जोतरी ओके टेमे मखे मा ताकोत हती ओतरी हिमी भी मखे मा सामर्थ्य छे। ");
INSERT INTO dhn_vpl VALUES ("JS14_12","007_14_12","JOS","14","12","12","एरकरता हिमी ची पहाड़ी मखे आप दे जेरी चर्चा योहोवा भगवान उके दाहड़े करी हती; तु ते ओके दाहड़े सोमव्यु होसे कि ओकामा अनाक ओवलियाद रयता छे, आरु मोटला मोटला गढ़वाळा नगर भी छे, पुन काय जाने संभव छे कि योहोवा मार साथे रवे, आरु ओकान कयनेक अनसारे हाव हेका उनाक देश सी निकाळ दिस।” ");
INSERT INTO dhn_vpl VALUES ("JS14_13","007_14_13","JOS","14","13","13","तव योहोसु ओकाह बरकत देदा; आरु हेब्रोनक यपुन्नेक पोर्‍या कालेबक भाग कर देदा। ");
INSERT INTO dhn_vpl VALUES ("JS14_14","007_14_14","JOS","14","14","14","ओका कारण हेब्रोन कनजी यपुन्नेक पोर्‍या कालेबक भाग आज तक बवनो छे, काहकी चो इस्राएलक परमेश्वर योहोवाक पुरी रीति सी अनुगामी हता। ");
INSERT INTO dhn_vpl VALUES ("JS14_15","007_14_15","JOS","14","15","15","पेहले हेब्रोनक नाव किरयतरबा हतो; चो अर्बा अनाकियो मा सब सी मोटलो मानुस हतो। आरु उका देशक लड़ाई सी शान्ति जोड़ी। ");
INSERT INTO dhn_vpl VALUES ("JS15_1","007_15_1","JOS","15","1","1","यहुदियाक गोत्राक भाग उनाक कुलोक अनसारे चिट्ठी न्हाखने सी एदोमक सीमा तक, आरु दोखेवरे क तरफ सीनक जंगल तक जी दक्षिण सीमा पर उबो रई छे। ");
INSERT INTO dhn_vpl VALUES ("JS15_2","007_15_2","JOS","15","2","2","ओकान भागन दक्षिण सीमा खारला तालन ओका सिरेवाळा कोल सी सुरवात होई जी दोखेवरे तरफ वाढ़ती छे; ");
INSERT INTO dhn_vpl VALUES ("JS15_3","007_15_3","JOS","15","3","3","आरु ची अक्रब्बीम नावन चढ़ाईक दक्षिण तरफ सी निकळीन सीन तरफ होता कादेशबर्नेक दोखेवरे क तरफ चढ़ गई, पछा हेस्रोनक जु होसे अद्दारक चढ़ीन करका तरफ फिर गई, ");
INSERT INTO dhn_vpl VALUES ("JS15_4","007_15_4","JOS","15","4","4","चा रईन अम्मोन होता ची मिसरक नाला पर निकळी, आरु उका सीमान नास दरियो होयो। तुमरी दोखेवरे वाळी सीमा यी होसे। ");
INSERT INTO dhn_vpl VALUES ("JS15_5","007_15_5","JOS","15","5","5","पछी पुर्वी सीमा यरदनक मुहने तक खारा ताल ठरी, आरु उत्तर दिशाक सीमा यरदनज मुहानाक जु तालक कोल सी सुरवात करीन, ");
INSERT INTO dhn_vpl VALUES ("JS15_6","007_15_6","JOS","15","6","6","बेथोग्लाक चढ़ता चढ़ता बेतराबाक उत्तरक तरफ होईन रुबेनी बोहन नावन दगड़ा तक चढ़ गई; ");
INSERT INTO dhn_vpl VALUES ("JS15_7","007_15_7","JOS","15","7","7","आरु ची सीमा आकोर नावन तराई सी दबीरक तरफ चढ़ गई, आरु उत्तर होयता गिलगालक तरफ झुकली जी तराई दोखेवरे तरफली अदुम्मीमक चढ़ाईन सामने छे; चा सी चा एनशेमेश नावन सोता क जु पुगीन एनरोगेल पर निकळी; ");
INSERT INTO dhn_vpl VALUES ("JS15_8","007_15_8","JOS","15","8","8","पछी ची सीमा हिन्नोमक पोर्‍याक तराई सी होईन यबुस (जो यरुशलेम कयाळतो छे) क दोखेवरे क तरफ सी चढ़ता चढ़ता ओका बोयड़ाल सिगा पर पुगी, जी पश्चिमक तरफ हिन्नोमक तरफ सामने आरु रपायीन तराईक उत्तरवाळा सिरा पर छे; ");
INSERT INTO dhn_vpl VALUES ("JS15_9","007_15_9","JOS","15","9","9","पछी ची सीमा ओका बोयड़ाक सिगे रईन नेप्तोह नावन सोतेक जात रई, आरु एप्रोन बोयड़ाक नगर पर निकळी; पछा चा रईन बालाक (जो किर्यत्यारीम भी कहवाये छे) पुगी; ");
INSERT INTO dhn_vpl VALUES ("JS15_10","007_15_10","JOS","15","10","10","पछा चा बाला सी पश्चिमक तरफ फिरीन सेईर बोयड़ा तक पुगी आरु यारीम बोयड़ा (जो कसालोन भी कयाड़तो छे) ओकान उत्तरक तरफ सी होईन बेतशेमेशक उतरी गयी, आरु चा रईन तिम्ना पर निकळी; ");
INSERT INTO dhn_vpl VALUES ("JS15_11","007_15_11","JOS","15","11","11","चा रईन ची सीमा एक्रोनक उत्तर तरफ जु होयता होयता शिक्करोन गयी, आरु बाला बोयड़ा पर होईन यब्नेल पर निकळी; आरु ओकी सीमान आखरी दरियाक किनार जोड़ी। ");
INSERT INTO dhn_vpl VALUES ("JS15_12","007_15_12","JOS","15","12","12","आरु पश्चिमक सीमा महादरियाक किनार ठरी। यहुदियाक जु भाग उनाक कुलक अनसारे जोड़ी ओकान चार तरफन सीमा यी होई। ");
INSERT INTO dhn_vpl VALUES ("JS15_13","007_15_13","JOS","15","13","13","यपुन्नेक पोर्‌यो कालेबक योहोसु योहोवान हुकुमोन अनसारे यहुदियाक वीच माहयलो भाग आप्या, मतलब किरयतरबा जो हेब्रोन भी कयाड़तो छे (चो अर्बा अनाक बास हतु)। ");
INSERT INTO dhn_vpl VALUES ("JS15_14","007_15_14","JOS","15","14","14","आरु कालेब चा सी शेशै, अहीमन, आरु तल्मै नावन अनाक क तीनु पोर्‍याक निकाळ देदा। ");
INSERT INTO dhn_vpl VALUES ("JS15_15","007_15_15","JOS","15","15","15","पचा चा रईन दबीरक निवासिया पर चढ़ गया; पुर्वकाल मा ते दबीरक नाव किर्यत्सेपेर हतो। ");
INSERT INTO dhn_vpl VALUES ("JS15_16","007_15_16","JOS","15","16","16","आरु कालेब कयो, “जो किर्यत्सेपेरक मारीन लीले ओका सी हाव आपनी पोराय अकसाक इयाव कर दिस।” ");
INSERT INTO dhn_vpl VALUES ("JS15_17","007_15_17","JOS","15","17","17","तव कालेबक भाई कनजीक पोर्‌यो ओत्नीएल ओका सी ली लेदु; आरु ओको ओका सी आपनी पोराय अकसाक इयाव कर देदो। ");
INSERT INTO dhn_vpl VALUES ("JS15_18","007_15_18","JOS","15","18","18","जव ची ओका जु आवी, तव ओको उका बास सी थुड़ीक जमीन मागनेक उभार्‌यो, पछी ची आपना गदड़ा पर सी उतर पड़ी, आरु कालेब ओकाह पुछी, “तु काय चाहती छे?” ");
INSERT INTO dhn_vpl VALUES ("JS15_19","007_15_19","JOS","15","19","19","ची बुली, “मखे सय बरकत आप; तु मखे दोखेवरे देश मा काहय जमीन ते आपी छे, मखे पाणी क सोते भी आप।” तव ओको उपरला सोते, नेवड़ा सोते, दुयु ओका आप्यो। ");
INSERT INTO dhn_vpl VALUES ("JS15_20","007_15_20","JOS","15","20","20","यहुदियाक गोत्राक भाग ते उनाक कुलक अनसारे यो छे। ");
INSERT INTO dhn_vpl VALUES ("JS15_21","007_15_21","JOS","15","21","21","यहुदियाक गोत्राक किनारवाळा नगर दोखेवरे देश मा एदोमक सीमाक तरफ या छे, मतलब कबसेल, एदेर यागुर, ");
INSERT INTO dhn_vpl VALUES ("JS15_22","007_15_22","JOS","15","22","22","कीना, दीमोना, अदादा, ");
INSERT INTO dhn_vpl VALUES ("JS15_23","007_15_23","JOS","15","23","23","केदेश, हासोर, यित्नान, ");
INSERT INTO dhn_vpl VALUES ("JS15_24","007_15_24","JOS","15","24","24","जीप, तेलेम, बालोत, ");
INSERT INTO dhn_vpl VALUES ("JS15_25","007_15_25","JOS","15","25","25","हासोर्हदत्त, करिय्योथेस्रोन, (जो हासोर भी कयाड़तो छे), ");
INSERT INTO dhn_vpl VALUES ("JS15_26","007_15_26","JOS","15","26","26","आरु अमाम, शमा, मोलादा, ");
INSERT INTO dhn_vpl VALUES ("JS15_27","007_15_27","JOS","15","27","27","हसर्गद्दा, हेशमोन, बेत्पालेत, ");
INSERT INTO dhn_vpl VALUES ("JS15_28","007_15_28","JOS","15","28","28","हसर्शआल, बिज्योत्या, बेरसेबा ");
INSERT INTO dhn_vpl VALUES ("JS15_29","007_15_29","JOS","15","29","29","बाला, इय्यीम, एसेम, ");
INSERT INTO dhn_vpl VALUES ("JS15_30","007_15_30","JOS","15","30","30","एलतोलद, कसील, होर्मा, ");
INSERT INTO dhn_vpl VALUES ("JS15_31","007_15_31","JOS","15","31","31","सिकलग, मदमन्ना, सनसन्ना, ");
INSERT INTO dhn_vpl VALUES ("JS15_32","007_15_32","JOS","15","32","32","लबाओत, शिल्हीम, ऐन, आरु रिम्मोन; या सब नगर उन्तीस छे, आरु ओका गाव भी छे। ");
INSERT INTO dhn_vpl VALUES ("JS15_33","007_15_33","JOS","15","33","33","नेड़ला देश मा या छे: मतलब एशताओल, सोरा, अशना, ");
INSERT INTO dhn_vpl VALUES ("JS15_34","007_15_34","JOS","15","34","34","जानोह, एनगन्नीम, तप्पुह, एनाम, ");
INSERT INTO dhn_vpl VALUES ("JS15_35","007_15_35","JOS","15","35","35","यर्मुत, अदुल्‍लाम, सोको, अजेका, ");
INSERT INTO dhn_vpl VALUES ("JS15_36","007_15_36","JOS","15","36","36","शारैम, अदीतेम, गदेरा, आरु गदेरोतेम; या सब चोवदे नगर छे, आरु इनाक गाव मा भी छे। ");
INSERT INTO dhn_vpl VALUES ("JS15_37","007_15_37","JOS","15","37","37","पछा सनान, हदाशा, मिगदलगाद, ");
INSERT INTO dhn_vpl VALUES ("JS15_38","007_15_38","JOS","15","38","38","दिलान, मिस्पे, योक्‍तेल, ");
INSERT INTO dhn_vpl VALUES ("JS15_39","007_15_39","JOS","15","39","39","लाकीश, बोस्कत, एग्लोन, ");
INSERT INTO dhn_vpl VALUES ("JS15_40","007_15_40","JOS","15","40","40","कब्बोन, लहमास, कितलीश, ");
INSERT INTO dhn_vpl VALUES ("JS15_41","007_15_41","JOS","15","41","41","गदेरोत, बेतदागोन, नामा, आरु मक्केदा; या सोलह नगर छे, आरु इनाक गाव भी छे। ");
INSERT INTO dhn_vpl VALUES ("JS15_42","007_15_42","JOS","15","42","42","फिर लिब्ना, ऐतेर, आशान, ");
INSERT INTO dhn_vpl VALUES ("JS15_43","007_15_43","JOS","15","43","43","यिप्‍ताह, अशाना, नसीब, ");
INSERT INTO dhn_vpl VALUES ("JS15_44","007_15_44","JOS","15","44","44","कीला, अकजीब आरु मारेशा; या नोव नगर छे आरु इनाक गाव भी छे। ");
INSERT INTO dhn_vpl VALUES ("JS15_45","007_15_45","JOS","15","45","45","पछा नगर आरु गाव समेत एक्रोन, ");
INSERT INTO dhn_vpl VALUES ("JS15_46","007_15_46","JOS","15","46","46","आरु एक्रोन सी लीन दरिया तक, आपना आपना गाव समेत जोतरा नगर अशदोदक तरफ छे। ");
INSERT INTO dhn_vpl VALUES ("JS15_47","007_15_47","JOS","15","47","47","पछा आपना आपना नगर आरु गाव समेत अशदोदो, आरु अज्जा, वरन् मिसरक नदी तक आरु महादरियाक किनारा तक जोतरा नगर छे। ");
INSERT INTO dhn_vpl VALUES ("JS15_48","007_15_48","JOS","15","48","48","बोयड़ा वाळा देश मा या छे: मतलब शामीर, यत्तीर, सोको, ");
INSERT INTO dhn_vpl VALUES ("JS15_49","007_15_49","JOS","15","49","49","दन्ना, किर्यत्सन्ना (जो दबीर भी कहवाये छे), ");
INSERT INTO dhn_vpl VALUES ("JS15_50","007_15_50","JOS","15","50","50","अनाब, एशतमो, आनीम, ");
INSERT INTO dhn_vpl VALUES ("JS15_51","007_15_51","JOS","15","51","51","गोशेन, होलोन, आरु गीलो; या ग्यारा नगर छे। इनाक गाव भी छे। ");
INSERT INTO dhn_vpl VALUES ("JS15_52","007_15_52","JOS","15","52","52","पछा अराब, दुमा, एशान, ");
INSERT INTO dhn_vpl VALUES ("JS15_53","007_15_53","JOS","15","53","53","यानीम, बेत्तप्पुह, अपेका, ");
INSERT INTO dhn_vpl VALUES ("JS15_54","007_15_54","JOS","15","54","54","हुमता, किरयतरबा (जो हेब्रोन भी कहवाये छे, आरु सीओर); या नोव नगर छे, आरु इनाक गाव भी छे। ");
INSERT INTO dhn_vpl VALUES ("JS15_55","007_15_55","JOS","15","55","55","पछा माओन, कर्मेल, जीप, युता, ");
INSERT INTO dhn_vpl VALUES ("JS15_56","007_15_56","JOS","15","56","56","यिज्रेल, योकदाम, जानोह, ");
INSERT INTO dhn_vpl VALUES ("JS15_57","007_15_57","JOS","15","57","57","केन, गिबा, आरु तिम्ना; या दस नगर छे, आरु इनाक गाव वी छे। ");
INSERT INTO dhn_vpl VALUES ("JS15_58","007_15_58","JOS","15","58","58","पछो हलहुल, बेतसुर, गदोर, ");
INSERT INTO dhn_vpl VALUES ("JS15_59","007_15_59","JOS","15","59","59","मरात, बेतनोत, आरु एलतकोन; या छव: नगर छे, आरु इनाक गाव भी छे। ");
INSERT INTO dhn_vpl VALUES ("JS15_60","007_15_60","JOS","15","60","60","पछा किर्यतबाल (जो किर्यत्यारीम भी कहवाये छे), आरु रब्बा; या दुय नगर छे, आरु इनाक गाव भी छे ");
INSERT INTO dhn_vpl VALUES ("JS15_61","007_15_61","JOS","15","61","61","जंगल मा या नगर छे: मतलब बेतराबा, मिद्दीन, सकाका; ");
INSERT INTO dhn_vpl VALUES ("JS15_62","007_15_62","JOS","15","62","62","निबशान, लोनवाला नगर, आरु एनगदी, या छव: नगर छे, आरु इनाक गाव भी छे। ");
INSERT INTO dhn_vpl VALUES ("JS15_63","007_15_63","JOS","15","63","63","यरुश्लेमक निवासी यबुसियाक यहुदीन निकाळ सके; एरकरता आजुन दाहड़े तक यबुसी यहुदियाक संग यरुशलेम मा रयता छे। ");
INSERT INTO dhn_vpl VALUES ("JS16_1","007_16_1","JOS","16","1","1","पछा युसुफक सन्तानक भाग चिट्ठी न्हाखने सी ठरायो गयो, ओकान सीमा योरीहो क जु यरदन नदी सी, मतलब पुर्वक तरफ योरीहो क पाणी सी सुरुवात होईन ओका बोयड़ा परला देश सी होयता, जा जंगक मा छे, बेतेलक पुगी; ");
INSERT INTO dhn_vpl VALUES ("JS16_2","007_16_2","JOS","16","2","2","बेतेल सी चो लुज तक पुगी, आरु एरेकिया क सीमा सी होयता अतारोत पर जाय निकळी; ");
INSERT INTO dhn_vpl VALUES ("JS16_3","007_16_3","JOS","16","3","3","आरु पश्चिम क तरफ यपलेतियाक सीमा सी उतरीन पछा नेड़ली बेथोरोन क सीमा सी होईन गेजेरक पुगी, आरु दरिया पर निकळी। ");
INSERT INTO dhn_vpl VALUES ("JS16_4","007_16_4","JOS","16","4","4","तव मनश्शे आरु एपरेम नावन युसुफक दुयु पोर्‍याक भाग लेदा। ");
INSERT INTO dhn_vpl VALUES ("JS16_5","007_16_5","JOS","16","5","5","एपरेमियो क सीमा उनाक कुलक अनसारे यी ठरी; मतलब उनाक भाग क सीमा पुर्व सी सुरुवात होईन अत्रोतदार सी होयता होया ऊपरवाळा बेथोरोन तक पुगी; ");
INSERT INTO dhn_vpl VALUES ("JS16_6","007_16_6","JOS","16","6","6","आरु उत्तरी सीमा पश्चिमक तरफ मिकमतात सी सुरुवात होईन पुर्व क तरफ फिरीन तानतशीलक पुगी, आरु ओ हकान जु होयत यानोह तक पुगी; ");
INSERT INTO dhn_vpl VALUES ("JS16_7","007_16_7","JOS","16","7","7","पछा यानोह सी चो अतारोत आरु नारा क उतरीन हुई योरीहो क जु होईन यरदन पर निकळी। ");
INSERT INTO dhn_vpl VALUES ("JS16_8","007_16_8","JOS","16","8","8","पछी ची सीमा तप्पुह सी निकळीन, आरु पश्चिमक तरफ जाईन, काना क नाला तक होईन दरिया पर निकळी। एपरेमियोक गोत्राक भाग उनाक कुलक अनसारे यी ठरी। ");
INSERT INTO dhn_vpl VALUES ("JS16_9","007_16_9","JOS","16","9","9","आरु मनश्शेइयोक भागक वीचमा भी कोय एक नगर आपना आपना गाव समेत एपरेमियोक करता अलग कर्‌या गया। ");
INSERT INTO dhn_vpl VALUES ("JS16_10","007_16_10","JOS","16","10","10","पुन जु कनानी गेजेर मा रयता हुता उनाक एपरेमिया चा रईन नी निकाळ्या; एरकरता चा बेगारी मा दासक समान काम करता छे। ");
INSERT INTO dhn_vpl VALUES ("JS17_1","007_17_1","JOS","17","1","1","पछु युसुफक जेठे मनश्शेक गोत्रक भाग चिट्ठी न्हाखने सी यो ठरे। मनश्शेक जेठाक पोर्‌यो, गिलादक बास माकीर, योद्धा हतो ओका कारण ओकान ओवलियादक गिलाद आरु बासान जोड्यो। ");
INSERT INTO dhn_vpl VALUES ("JS17_2","007_17_2","JOS","17","2","2","एरकरता यो भाग दिसरा मनश्शेइयाक करता ओकान कुलक अनसारे ठर्‍यो, मतलब अबीएजेर, हेलेक, ओसरीयेल, शेकेम, हेपेर, आरु शमीदा; जु आपना आपना कुलक अनसारे युसुफक पोर्‌यो मनश्शेक ओवलियाद माहयला मानसे हता, उनाक अलग अलग ओवलियादक करता ठर्‍या। ");
INSERT INTO dhn_vpl VALUES ("JS17_3","007_17_3","JOS","17","3","3","पुन हेपेर जु गिलादक पोर्‌यो, माकीर क नातन्यो, आरु मनश्शेक नातु पंतु हतु, ओकान पोर्‌यो सलोफादक पोर्‌यो नी हता, पोरायुज होई; आरु ओकान नाव महला, नोआ, होग्ला, मिल्का, आरु तिर्सा छे। ");
INSERT INTO dhn_vpl VALUES ("JS17_4","007_17_4","JOS","17","4","4","तव चा एलीयाजर याजक, नुनक पोर्‍यु योहोसु, आरु प्रधानक जु जाईन कयने लागी, “योहोवा मुसाक हुकुम देदो, कि चु आमुक आमराक भाइसक वीच मा वाट दे।” ते योहोसु योहोवा क हुकुमोन अनसारे हेके उनाक चचाओक वीच मा वाटो जोड्यो। ");
INSERT INTO dhn_vpl VALUES ("JS17_5","007_17_5","JOS","17","5","5","तव मनश्शेक, यरदन पार गिलाद देश आरु बासानक छुड़, दस भाग जोड्या: ");
INSERT INTO dhn_vpl VALUES ("JS17_6","007_17_6","JOS","17","6","6","काहकी मनश्शेइयाक वीच मा मनश्शेई बायराक भी वाटु जोड्यो। आरु दिसरा मनश्शेईयाक गिलाद मा जोड़्‌या ");
INSERT INTO dhn_vpl VALUES ("JS17_7","007_17_7","JOS","17","7","7","मनश्शेक सीमा आशेर सी लीन मिकमतात तक पुगी, जो शकेमक सामने छे; पछु चु दक्षिणक तरफ जाईन एनतप्पुहक निवासिया तक पुग्या। ");
INSERT INTO dhn_vpl VALUES ("JS17_8","007_17_8","JOS","17","8","8","तप्पुह न जागा ते मनश्शेक जड्यो, पुन तप्पुह नगर ज्यो मनश्शे न सीमा पर रयता हुता चु एपरेमियान हुयो। ");
INSERT INTO dhn_vpl VALUES ("JS17_9","007_17_9","JOS","17","9","9","त्या वाळी सीमा कानाक नाले तक उतरीन ओकान दोखेवरे तरफ तक पुग गयी; यो नगर यद्यपि मनश्शेक नगरक वीच मा हतो तेभी एपरेमक ठरे; आरु मनश्शेक सीमा ओका नालाक उत्तरक तरफ सी जाईन दरिया पर निकळी; ");
INSERT INTO dhn_vpl VALUES ("JS17_10","007_17_10","JOS","17","10","10","दोखेवरे क तरफलो देश ते एपरेमक तरफ उत्तरक तरफक मनश्शेक जोड्यो, आरु ओकान सीमा दरियो ठर्‍यो; आरु चा उत्तरक तरफ आशेर सी आरु पुर्वक तरफ इस्साकार सी जाय भेवाया। ");
INSERT INTO dhn_vpl VALUES ("JS17_11","007_17_11","JOS","17","11","11","आरु मनश्शेक, इस्साकार आरु आशेर आपना आपना नगरक समेत बेतशान, यिबलाम, आरु आपना नगरो समेत दोरक निवासी, आरु आपना नगरक समेय तानाक निवासी, आरु आपना नगर समेत मगिद्दोक निवासी, या तीनु जा ऊचा जागा पर बठला जोडया। ");
INSERT INTO dhn_vpl VALUES ("JS17_12","007_17_12","JOS","17","12","12","पुन मनश्शे उना नगरक निवासियाक उनामा सी नी निकाळ सके; एरकरता चा कनानी उका देश मा बलपुर्वक बठला रया। ");
INSERT INTO dhn_vpl VALUES ("JS17_13","007_17_13","JOS","17","13","13","तेभी जव इसराएली सामर्थी होय गया, तव कनानिया सी बेगारी ते करने लाग्या, पुन उनाक पुरी रीति सी बाहरते निकाळ नी सक्या। ");
INSERT INTO dhn_vpl VALUES ("JS17_14","007_17_14","JOS","17","14","14","युसुफक सन्तान योहोसु सी कयने लागी, “आमु ते गिनती मा बैस छे, काहकी हिमी तक योहोवा आमुक बरकत आपतो आयो छे, पछु तु ते आमरा भागन करता चिट्ठी न्हाखिन काह एक अंश देदा छे?” ");
INSERT INTO dhn_vpl VALUES ("JS17_15","007_17_15","JOS","17","15","15","योहोसु उनाक कयो, “कदाम तुमु गिनती मा बैस होए, आरु एपरेमक बोयड़ा देश मा तुमरे करता नानो होय, जा परिज्जिया आरु रपायान देश जु जंगल छे ओकामा जाईन झाड़काक काट न्हाखु।” ");
INSERT INTO dhn_vpl VALUES ("JS17_16","007_17_16","JOS","17","16","16","युसुफक सन्तान कयो, “चा बोयड़ा वाळो देश आमरे करता नानो छे; आरु बेतशान आरु ओकान नगर मा रयनेवाळा, आरु यिज्रेलक तराई मा रयनेवाळा, जोतरा कनानी नेड़ला देश मा रयता छे, उना सभाक जु लोहान रथ छे।” ");
INSERT INTO dhn_vpl VALUES ("JS17_17","007_17_17","JOS","17","17","17","पछु योहोसु, काय एपरेम काय मनश्शेई, मतलब युसुफ क सब घराना सी कयो, “होव, तुमु लोगहन ते गिनती मा बैस होसे, आरु तुमरी ताकोत भी मोटली छे, एरकरता तुमुक केवल एकुज भाग नी जोड़से; ");
INSERT INTO dhn_vpl VALUES ("JS17_18","007_17_18","JOS","17","18","18","बोयाड़ा वाळो देश भी तुमरो होय जासे; काहकी चु जंगल ते छे, पुन ओकन झाड़का काट न्हाख्या, तव ओकान आस पासक देश भी तुमरो होय जासे; काहकी चाहे कनानी सामर्थी होसे, आरु उनाक जु लोहान रथ भी होसे, तेभी तुमु हेकाक चा रईन निकाळ सकजे।” ");
INSERT INTO dhn_vpl VALUES ("JS18_1","007_18_1","JOS","18","1","1","आरु इसराएलीयान सब मण्डळी शीलो मा इकठी हयीन चा मिलापवाळा तम्बु क उबो कर्या; काहकी देश हेनको हक मा हुय गयलो हुतो। ");
INSERT INTO dhn_vpl VALUES ("JS18_2","007_18_2","JOS","18","2","2","आरु इसराएलीया मा सी सात गोत्रान क लोगहन आपनो आपनो भाग नी जड़ीयो त्या असात रय गिया। ");
INSERT INTO dhn_vpl VALUES ("JS18_3","007_18_3","JOS","18","3","3","तव योहोसु इसराएलीया सी कयो, “जो देश तुमरा डाहलान परमेश्वर योहोवा तुमुक देदु छे, ओकाह आपना हक मा कर लेने मा तुमु कोतार तक डिला करता रवसे? ");
INSERT INTO dhn_vpl VALUES ("JS18_4","007_18_4","JOS","18","4","4","हिमी प्रति गोत्रा मा सी तीन मानसक ठराव लेवु, आरु हाव हेका एरकरता मुकलीस कि चा चालीन देश मा फिरे, आरु आपना आपना गोत्राक भाग प्रयोजनक अनसारे ओकान हाल लिख लिखीन मार जु वापस आया। ");
INSERT INTO dhn_vpl VALUES ("JS18_5","007_18_5","JOS","18","5","5","आरु चा देशक सात भाग लिखला, यहुदी ते दोखेवरेक तरफ आपना भाग मा, आरु युसुफक घरानान लोगहन जवाबक तरफ आपना भाग मा रया। ");
INSERT INTO dhn_vpl VALUES ("JS18_6","007_18_6","JOS","18","6","6","आरु तुमु देशन सात भाग लिखीन मार जु ली आवु; आरु हाव या तुमरे करता आपनो परमेश्वर योहोवाक सामने चिट्ठी न्हाखी। ");
INSERT INTO dhn_vpl VALUES ("JS18_7","007_18_7","JOS","18","7","7","आरु लेवियाक तुमरे वीचमा थुड़क भाग नी होसे, काहकी योहोवाक आपला याजकपद ओकान भाग छे; आरु गाद, रुबेन, आरु मनश्शेक आदा गोत्रान लोगहन यरदन पुर्वक तरफ योहोवान दास मुसाक आपलो आपनो आपनो भाग जोड़ चुक्यो छे।” ");
INSERT INTO dhn_vpl VALUES ("JS18_8","007_18_8","JOS","18","8","8","तव चा मानसे उठीन चाल देदा; आरु जो उका देशन हाल लिखने चाले हेका योहोसु यी हुकुम आपी, “जाईन देश मा घूमु फिरु, आरु ओकान हाल लिखीन मार जु वापस आवु; आरु हाव या शीलो मा योहोवाक सामने तुमरे करता चिट्ठी न्हाखिज।” ");
INSERT INTO dhn_vpl VALUES ("JS18_9","007_18_9","JOS","18","9","9","तव चा मानसे चाल देदा, आरु ओका देश मा फिरु, आरु ओका नगर क सात भाग करीन ओकान हाल किपात मा लिखिन शीलाक छावनी मा योहोसुक जु आया। ");
INSERT INTO dhn_vpl VALUES ("JS18_10","007_18_10","JOS","18","10","10","तव योहोसु शीलो मा योहोवाक सामने ओकान करता चिट्ठीया न्हाख्या; आरु चो योहोसु इसराएलीयाक ओकान भागक अनसारे देश वाट देदा। ");
INSERT INTO dhn_vpl VALUES ("JS18_11","007_18_11","JOS","18","11","11","बिन्यामीनियाक गोत्राक चिट्ठी ओकान कुलक अनसारे निकळी, आरु ओकान भाग यहुदिया आरु युसुफियाक वीच मा पड्यो। ");
INSERT INTO dhn_vpl VALUES ("JS18_12","007_18_12","JOS","18","12","12","आरु उकान उत्तरी सीमा यरदन सी सुरु होयती छे, आरु योरीहोक उत्तर तरफ पहाड़ी देश मा होईन बेतावेनक जंगल मा निकळी; ");
INSERT INTO dhn_vpl VALUES ("JS18_13","007_18_13","JOS","18","13","13","चा रईन चा लुजक पुग्या जा बेतेल भी कवाये, आरु लुजक दोखेवरे तरफ सी होयतो नेड़लो बेथोरोनक दक्षिण तरफ पहाड़क जु होय अत्रोतद्दारक उतर गई। ");
INSERT INTO dhn_vpl VALUES ("JS18_14","007_18_14","JOS","18","14","14","पछी पश्चिमी सीमा फिरीन बेथोरोनक सामने आरु उकान दोखेवरे तरफन पहाड़ी सी होयता किर्यतबाल नावन यहुदान एक नगरपर निकळी जा किर्यत्यारीम भी कहवाये छे; पश्चिम सीमा यी ठरी। ");
INSERT INTO dhn_vpl VALUES ("JS18_15","007_18_15","JOS","18","15","15","पछा दोखेवरे क तरफ सीमा पश्चिम सी सुरु होईन किर्यत्यारीमक सिरे सी निकळीन नेप्तोहक सोते पर पुगी; ");
INSERT INTO dhn_vpl VALUES ("JS18_16","007_18_16","JOS","18","16","16","आरु उका बोयड़ाक सिरे पर उतरी, जी हिन्नोमन पोर्‌योक तराईक सामने आरु रपाय नावन तराईन उत्तर तरफ छे; वा सी हिन्नोमन तराई मा, मतलब यबुसक दोखेवरे तरफ होईन एनरोगेलक उतरी; ");
INSERT INTO dhn_vpl VALUES ("JS18_17","007_18_17","JOS","18","17","17","चा रईन उत्तर तरफ फिरीन एनशेमेशक निकळीन ओका गलीलोतक तरफ गई, जु अदुम्मीमक चढ़ाईन सामने छे, पछु चा रईन यो रुबेनक पोर्‍याक बोहन दगड़ा तक उतर गई; ");
INSERT INTO dhn_vpl VALUES ("JS18_18","007_18_18","JOS","18","18","18","चा रईन चु उत्तरक तरफ जाईन अराबा सी होयता अराबाक उतरी; ");
INSERT INTO dhn_vpl VALUES ("JS18_19","007_18_19","JOS","18","19","19","चा रईन ची सीमा बेथोग्ला क उतर तरफ सी जाईन यरदन खारे तालल उत्तर तरफ कोल मा यरदनक मुहाने पर निकळी; दोखेवरे सीमा यी ठरी। ");
INSERT INTO dhn_vpl VALUES ("JS18_20","007_18_20","JOS","18","20","20","आरु पुर्वक तरफन सीमा यरदनक ठरी। बिन्यामीनियाक भाग, चार तरफन सीमा सहित, उकान कुलक अनसारे, यी ठरी। ");
INSERT INTO dhn_vpl VALUES ("JS18_21","007_18_21","JOS","18","21","21","बिन्यामीनियाक गोत्राक उकान कुलक अनसारे या नगर जोड्या, मतलब योरीहो, बेथोग्ला, एमेक्कसीस, ");
INSERT INTO dhn_vpl VALUES ("JS18_22","007_18_22","JOS","18","22","22","बेतराबा, समारैम, बेतेल, ");
INSERT INTO dhn_vpl VALUES ("JS18_23","007_18_23","JOS","18","23","23","अब्बीम, पारा, ओप्रा, ");
INSERT INTO dhn_vpl VALUES ("JS18_24","007_18_24","JOS","18","24","24","कपरम्मोनी, ओप्रनी आरु गेबा; या बारा नगर आरु इनाक गाव जोड्या। ");
INSERT INTO dhn_vpl VALUES ("JS18_25","007_18_25","JOS","18","25","25","फिर गिबोन, रामा, बेरोत, ");
INSERT INTO dhn_vpl VALUES ("JS18_26","007_18_26","JOS","18","26","26","मिस्पे, कपीरा, मोसा, ");
INSERT INTO dhn_vpl VALUES ("JS18_27","007_18_27","JOS","18","27","27","रेकेम, यिर्पेल, तरला, ");
INSERT INTO dhn_vpl VALUES ("JS18_28","007_18_28","JOS","18","28","28","सेला, एलेप, यबुस जो यरुशलेम भी कयाड़तो छे, गिबत आरु किर्यत; या चोवदे नगर आरु इनाक गाव हेका जोड़े। बिन्यामीनियाक भाग उनाक कुलक अनसारे यी ठरी। ");
INSERT INTO dhn_vpl VALUES ("JS19_1","007_19_1","JOS","19","1","1","दिसरी चिट्ठी शिमोनन नाव पर, मतलब शिमोनियाक कुलक अनसारे ओकान गोत्राक नाव पर निकळी; आरु ओकान भाग यहुदियाक भागन वीच मा ठरे ");
INSERT INTO dhn_vpl VALUES ("JS19_2","007_19_2","JOS","19","2","2","ओकान भाग मा या नगर छे, मतलब बेरसेबा, शेबा, मोलादा, ");
INSERT INTO dhn_vpl VALUES ("JS19_3","007_19_3","JOS","19","3","3","हसर्शआल, बाला, एसेम, ");
INSERT INTO dhn_vpl VALUES ("JS19_4","007_19_4","JOS","19","4","4","एलतोलद, बतुल होर्मा, ");
INSERT INTO dhn_vpl VALUES ("JS19_5","007_19_5","JOS","19","5","5","सिकलग, बेत्मर्काबोत, हसर्शुसा, ");
INSERT INTO dhn_vpl VALUES ("JS19_6","007_19_6","JOS","19","6","6","बेतलबाओत, आरु शारुहेन; या तेरा नगर आरु ओका गाव हेका जोड़े। ");
INSERT INTO dhn_vpl VALUES ("JS19_7","007_19_7","JOS","19","7","7","फिर ऐन, रिम्मोन, एतेर, आरु आशान, या चार नगर गाव समेत; ");
INSERT INTO dhn_vpl VALUES ("JS19_8","007_19_8","JOS","19","8","8","आरु बालत्बेर जु दक्खिन देशक रामा भी कयाड़तो छे, चा तक इना नगर चार तरफ सब गाव भी हेका जोड्या। शिमोनियाक गोत्राक भाग उनाक कुलक अनसारे यी ठरी। ");
INSERT INTO dhn_vpl VALUES ("JS19_9","007_19_9","JOS","19","9","9","शिमानियाक भाग ते यहुदियाक अंश मा सी आप्या गयो; काहकी यहुदियाक भाग ओकान करता बैस हतो, ओका शिमोनियाक भाग हेका भागक वीच मा ठर्‍यो। ");
INSERT INTO dhn_vpl VALUES ("JS19_10","007_19_10","JOS","19","10","10","तीसरी चिट्ठी जबुलुनियाक कुलक अनसारे ओकान नाव पर निकळी। आरु ओकान भागक सीमा सारीद तक पुगी; ");
INSERT INTO dhn_vpl VALUES ("JS19_11","007_19_11","JOS","19","11","11","आरु ओकान सीमा पश्चिम तरफ मरलाक चढ़ीन दब्बेशेतक पुगी, आरु योकनामक सामनेन नदी तक पुग गई; ");
INSERT INTO dhn_vpl VALUES ("JS19_12","007_19_12","JOS","19","12","12","पछा सारीद सी चा उगवनी वोगे तरफ फिरीन किसलोत्ताबोरक सीमा तक पुगी, आरु चा रईन जाता जाता दाबरत मा निकळी आरु यापीक तरफ जाय निकळी; ");
INSERT INTO dhn_vpl VALUES ("JS19_13","007_19_13","JOS","19","13","13","चा रईन चु उगवनी वोगेन तरफ ओगव जाईन गथेपेर आरु इत्कासीनक गई, आरु ओका रिम्मोन मा निकळी जो नेआ तक पसर्‍यो छे; ");
INSERT INTO dhn_vpl VALUES ("JS19_14","007_19_14","JOS","19","14","14","चा सी चु सीमा ओकान उत्तर तरफ सी फिरीन हन्नातोन पर पुगी; आरु यिप्तहेलक तराई मा जाय निकळी; ");
INSERT INTO dhn_vpl VALUES ("JS19_15","007_19_15","JOS","19","15","15","कत्तात, नहलाल, शिम्रोन, यिदला, आरु बैतलहम; या बारा नगर ओकान गाव समेत ओका भागक ठर्‍या। ");
INSERT INTO dhn_vpl VALUES ("JS19_16","007_19_16","JOS","19","16","16","जबुलुनियाक भाग ओकान कुलक अनसारे यो ठहरे; आरु ओकामा आपना आपना गाव समेत यो नगर छे। ");
INSERT INTO dhn_vpl VALUES ("JS19_17","007_19_17","JOS","19","17","17","चोथी चिट्ठी इस्साकारियोक कुलक अनसारे ओकान नाव पर निकळी। ");
INSERT INTO dhn_vpl VALUES ("JS19_18","007_19_18","JOS","19","18","18","आरु ओकान सीमा यिज्रेल, कसुल्‍लोत, शुनेम, ");
INSERT INTO dhn_vpl VALUES ("JS19_19","007_19_19","JOS","19","19","19","हपारेम, शीओन, अनाहरत, ");
INSERT INTO dhn_vpl VALUES ("JS19_20","007_19_20","JOS","19","20","20","रब्बीत, किश्योन, एबेस, ");
INSERT INTO dhn_vpl VALUES ("JS19_21","007_19_21","JOS","19","21","21","रेमत, एनगन्नीम, एनहद्दा, आरु बेत्पस्सेस तक पुगी। ");
INSERT INTO dhn_vpl VALUES ("JS19_22","007_19_22","JOS","19","22","22","पछु ची सीमा ताबोर, शहसुमा आरु बेतशेमेश तक पुगी, आरु ओकान सीमा यरदन नदी पर जाय निकळी; ओका प्रकारन ओकाह सोलह नहर आपना आपना गाव समेत जोड़ी। ");
INSERT INTO dhn_vpl VALUES ("JS19_23","007_19_23","JOS","19","23","23","कुलक अनसारे इस्साकारियाक गोत्राक भाग नगर आरु समेत यी ठरी। ");
INSERT INTO dhn_vpl VALUES ("JS19_24","007_19_24","JOS","19","24","24","पाचवी चिट्ठी आशेरियोक गोत्राक कुलक अनसारे ओकान नाव पर निकळी। ");
INSERT INTO dhn_vpl VALUES ("JS19_25","007_19_25","JOS","19","25","25","ओकान सीमा मा हेल्कात, हली, बेतेन, अक्षाप, ");
INSERT INTO dhn_vpl VALUES ("JS19_26","007_19_26","JOS","19","26","26","अलाम्मेल्‍लेक, अमाद, आरु मिशाल हता; आरु ची पश्चिम तरफ कार्मेल तक आरु शीहोर्लिब्नात तक पुगी; ");
INSERT INTO dhn_vpl VALUES ("JS19_27","007_19_27","JOS","19","27","27","पछी ची उगवनी वोगे तरफ फिरीन बेतदागोनक गई, आरु जबुलुनक भाग तक, आरु यिप्तहेलक तराई सी उत्तर तरफ होईन बेतेमेक आरु नीएल तक पुगी; आरु उत्तर तरफ जाईन काबुल पर निकळी, ");
INSERT INTO dhn_vpl VALUES ("JS19_28","007_19_28","JOS","19","28","28","आरु चु एब्रोन, रहोब, हम्मोन, आरु काना सी होईन मोटला सीदोनक पुगी; ");
INSERT INTO dhn_vpl VALUES ("JS19_29","007_19_29","JOS","19","29","29","चा रईन ची सीमा फिरीन रामा सी होयता सोर नावन गढ़वाळा नगरतक जात रई; पछी सीमा होसाक तरफ फिरीन आरु अकजीनक जु देश मा होईन दरिया पर निकळी, महलेब ");
INSERT INTO dhn_vpl VALUES ("JS19_30","007_19_30","JOS","19","30","30","उम्मा, अपेक, आरु रहोब भी ओकान भाग मा ठर्‍या; ओका प्रकार बाईस नगर आपना आपना गाव समेत ओकाह जोड्या। ");
INSERT INTO dhn_vpl VALUES ("JS19_31","007_19_31","JOS","19","31","31","कुलक अनसारे आशेरियाक गोत्राक भाग नगर आरु समेत यी ठर्‍यो। ");
INSERT INTO dhn_vpl VALUES ("JS19_32","007_19_32","JOS","19","32","32","छटवी चिट्ठी नप्तालियाक कुलक अनसारे ओकान नाव पर निकळी। ");
INSERT INTO dhn_vpl VALUES ("JS19_33","007_19_33","JOS","19","33","33","आरु ओकान सीमा हेलेप सी, आरु सानन्नीम वांज्यो झाड़का सी, अदामीनेकेब आरु यब्नेल सी होईन, आरु लक्कुम जाईन यरदन पर निकळी; ");
INSERT INTO dhn_vpl VALUES ("JS19_34","007_19_34","JOS","19","34","34","चा रईन ची सीमा पश्चिम तरफ फिरीन अजनोत्ताबोर गई, आरु चा सी हुक्कोक गई, आरु दोखेवरे, आरु जबुलुनक भाग तक, आरु पश्चिम तरफ आशेरन भाग तक, आरु उगवनी तरफ यहुदान भागन जुन यरदन नदी पर पुगी। ");
INSERT INTO dhn_vpl VALUES ("JS19_35","007_19_35","JOS","19","35","35","आरु ओकान गढ़वाळा नगर या छे, मतलब सिद्दीम, सेर, हम्मत, रक्‍कत, किन्नेरेत, ");
INSERT INTO dhn_vpl VALUES ("JS19_36","007_19_36","JOS","19","36","36","अदामा, रामा, हासोर, ");
INSERT INTO dhn_vpl VALUES ("JS19_37","007_19_37","JOS","19","37","37","केदेश, एद्रेई, एन्हासोर, ");
INSERT INTO dhn_vpl VALUES ("JS19_38","007_19_38","JOS","19","38","38","यिरोन, मिगदलेल, होरेम, बेतनात, आरु बेतशेमेश; या उन्नीस नगर गाव समेत ओकाह जोड्या। ");
INSERT INTO dhn_vpl VALUES ("JS19_39","007_19_39","JOS","19","39","39","कुलक अनसारे नप्तालियाक गोत्राक भाग नगर आरु ओकान गाव समेत यी ठरी। ");
INSERT INTO dhn_vpl VALUES ("JS19_40","007_19_40","JOS","19","40","40","सातवी चिट्ठी कुलक अनसारे दानियाक गोत्राक नाव पर निकळी। ");
INSERT INTO dhn_vpl VALUES ("JS19_41","007_19_41","JOS","19","41","41","आरु ओकान भागन सीमा मा सोरा, एशताओल, ईरशेमेश, ");
INSERT INTO dhn_vpl VALUES ("JS19_42","007_19_42","JOS","19","42","42","शालब्बीन, अय्यालोन, यितला, ");
INSERT INTO dhn_vpl VALUES ("JS19_43","007_19_43","JOS","19","43","43","एलोन, तिम्ना, एक्रोन, ");
INSERT INTO dhn_vpl VALUES ("JS19_44","007_19_44","JOS","19","44","44","एलतके, गिब्बतोन, बालात, ");
INSERT INTO dhn_vpl VALUES ("JS19_45","007_19_45","JOS","19","45","45","यहुदा, बनेबराक, गत्रिम्मोन, ");
INSERT INTO dhn_vpl VALUES ("JS19_46","007_19_46","JOS","19","46","46","मेयर्कोन, आरु रक्‍कोन ठहरे, आरु याफा क सामनेन सीमा उकान हती। ");
INSERT INTO dhn_vpl VALUES ("JS19_47","007_19_47","JOS","19","47","47","आरु दानियोक भाग ओका सी जास्ती होय गया, मतलब दानी लेशेम पर चढ़ीन ओका सी लढ़े, आरु उका लीन तलवार सी म्हार न्हाख्यो, आरु ओकाह आपनो हक मा करीन ओकामा बठ गया, आरु आपना महापुरुषक नाव पर लेशेमक नाव दान मेक्या। ");
INSERT INTO dhn_vpl VALUES ("JS19_48","007_19_48","JOS","19","48","48","कुलक अनसारे दानियोक गोत्राक भाग नगर आरु गाव समेत यी ठहरे। ");
INSERT INTO dhn_vpl VALUES ("JS19_49","007_19_49","JOS","19","49","49","जव देशन वाटनु सीमान अनसारे पुरो होय गयो, तव इसराएलीया नुनक पोर्‌यो योहोसुक भी आपना वीचमा एक भाग आप्यो। ");
INSERT INTO dhn_vpl VALUES ("JS19_50","007_19_50","JOS","19","50","50","योहोवान कयनर क अनसारे हेका ओकाक उकान मांगलोचो नगर आपला, यो एपरेमक पहाड़ी देश माहयलो तिम्नत्सेरह छे; आरु चो उका नगरक बठाड़ीन रयने लाग्यो। ");
INSERT INTO dhn_vpl VALUES ("JS19_51","007_19_51","JOS","19","51","51","जु जु भाग एलीयाजर याजक, आरु नुनक पोर्‌यो योहोसु, आरु इसराएलीयाक गोत्राक घरानान पुर्वजन मुखी मुखी मानसे शीलो मा, मिलापवाळा तम्बु क झोपला पर, योहोवाक सामने चिट्ठी न्हखिन वाट देदा चा याज छे। ओका प्रकार हेकान देश वाटनेन काम पुरो कर्‌या। ");
INSERT INTO dhn_vpl VALUES ("JS20_1","007_20_1","JOS","20","1","1","पछु योहोवा योहोसु सी कयो, ");
INSERT INTO dhn_vpl VALUES ("JS20_2","007_20_2","JOS","20","2","2","“इसराएलीया सी यो कयो, ‘हाव मुसाक द्वारा तुमु सी शरण नगरक जी चर्चान हती ओकान अनसारे ओकाह ठराव लेवु, ");
INSERT INTO dhn_vpl VALUES ("JS20_3","007_20_3","JOS","20","3","3","जेका सी कुई ओसोज बिना समझ जाने काहनाक म्हार न्हाख्या, चु ओकाम रईन काहना मा डास जासे; एरकरता चा शरण नगर खुनक पलटाव लेनेवाळा सी वाचने करता तुमरा चरणस्थान ठरसे। ");
INSERT INTO dhn_vpl VALUES ("JS20_4","007_20_4","JOS","20","4","4","चु उना नगर मा सी काहनु डास जासे, आरु उका नगरक फाटक मा सी उबा होईन ओकान डाहलाक आपनो मुकद्दमु कय सोमवाळे; आरु चा ओकाह आपना नगर मा आपने जु टिकाळ ले, आरु उकाह कुई स्थान आपे, जेकामा उनाक साथ रवे। ");
INSERT INTO dhn_vpl VALUES ("JS20_5","007_20_5","JOS","20","5","5","आरु कदाम खुनक पलटाव लेनेवळा ओकान पीछा करे, ते चा यो जानीन ओको आपना साथेवावा बिना जानेक, आरु पेहले ओका सी बैर मेकीन देदो, ओकाह खुनीक ओकान हाथ मा आप। ");
INSERT INTO dhn_vpl VALUES ("JS20_6","007_20_6","JOS","20","6","6","आरु जव तक ची मण्डलीक सामने न्यायक करता उबो नी होसे, आरु जव तक उना दाहड़ाक महानायक नी मर जासे, तव तक चो उके नगर मा रया; ओकान बाद चु खुनी आपना नगरक वापस आवीन जेका सी चो भाग आयो होसे आपना घर मा पछा रयने लाग्या।’” ");
INSERT INTO dhn_vpl VALUES ("JS20_7","007_20_7","JOS","20","7","7","अत: हेका नप्तालीन पहाड़ी देश मा गलीलक केदेश, आरु एपरेमन पहाड़ी देश मा शेकेमक, आरु यहुदाक पहाड़ी देश मा किरयतरबा, जो हेब्रोन भी कयाड़तो छे, आसरान पवित्र जागो बनीयो। ");
INSERT INTO dhn_vpl VALUES ("JS20_8","007_20_8","JOS","20","8","8","आरु योरीहोक जु यरदनन पुर्व तरफ हेका रुबेनक गोत्राक भाग मा बेसेरक, जंगल मा चोरस धरती पर बठला छे, आरु गादक गोत्राक भाग मा गिलाद रामोतन, आरु मनश्शेन गोत्राक भाग मा बासान गोलानक ठराया। ");
INSERT INTO dhn_vpl VALUES ("JS20_9","007_20_9","JOS","20","9","9","सब इसराएलीयान करता, आरु उकान वीचमा रयनेवाळा परदेशीयान करता भी, जो नगर इना मनसा सी ठराया गया कि जु कुई काहना प्राणी क विसराए म्हार न्हाखे चा ओका मा सी काहना मा डास जासे, आरु जव तक न्यायन करता मण्डलीन सामने उबा नी होसे, तव तक खुनक पलटाव लेनेवाळा ओका म्हार न्हाखनु नी जुवे, चा याज छे। ");
INSERT INTO dhn_vpl VALUES ("JS21_1","007_21_1","JOS","21","1","1","तव लेवियाक पुर्वजन घरानान मुखी मुखी मानसे एलीयाजर याजक, आरु नुनक पोर्‌यो योहोसु, आरु इसराएली गोत्राक पुर्वज घोरानान मुखी मुखी मानसक जु आवीन ");
INSERT INTO dhn_vpl VALUES ("JS21_2","007_21_2","JOS","21","2","2","कनान देशन शीलो नगर मा कयने लाग्या, “योहोवा मुसान द्वारा आमुक भठनेक करता नगर, आरु आमरा पशुन ओवलियादन करता हेका नगरन चराइया भी आपनेन हुकुम देदी हती।” ");
INSERT INTO dhn_vpl VALUES ("JS21_3","007_21_3","JOS","21","3","3","तव इसराएलीया योहोवाक कयनेक अनसारे आपना आपना भाग मा सी लेवियाक चाराय समेत या नगरे आप्यो। ");
INSERT INTO dhn_vpl VALUES ("JS21_4","007_21_4","JOS","21","4","4","तव कहातियाक कुलक नाव पर चिट्ठी निकळी। एरकरता लेविया मा सी हारुन याजकक ओवलियादक यहुदा, शिमोन, आरु बिन्यामीनक गोत्राक भाग मा सी तेरा नगर जोड्या। ");
INSERT INTO dhn_vpl VALUES ("JS21_5","007_21_5","JOS","21","5","5","बाकी कहातियाक एपरेमक गोत्राक कुल, आरु दानक गोत्रा मनश्शेक आदा गोत्राक भाग मा सी चिट्ठी न्हाख न्हखिन दस नगर आप्या गया। ");
INSERT INTO dhn_vpl VALUES ("JS21_6","007_21_6","JOS","21","6","6","पछा गेर्शोनियाक इस्साकारक गोत्रान कुल, आरु आशेर, आरु नप्तालीक गोत्राक जागा मा सी, आरु मनश्शेक ओका आदा गोत्राक भाग मा सी भी जो बासान मा हता चिट्ठी न्हाख न्हाखिन आप्या गया। ");
INSERT INTO dhn_vpl VALUES ("JS21_7","007_21_7","JOS","21","7","7","कुलक अनसारे मरारियाक रुबेन, गाद, आरु जबुलुनक गोत्राक भाग मा सी बारा नगर आप्या गया। ");
INSERT INTO dhn_vpl VALUES ("JS21_8","007_21_8","JOS","21","8","8","जी हुकुम योहोवा मुसान द्वारा आपी हती ओकान अनसारे इसराएलीया लेवियाक चाराई समेत या नगर चिट्ठी न्हाख न्हाखिन आप्या। ");
INSERT INTO dhn_vpl VALUES ("JS21_9","007_21_9","JOS","21","9","9","हेका यहुदियाक आरु शिमोनियाक गोत्रान भाग मा सी या नगर जेकान नाव लिखलो छे आपे; ");
INSERT INTO dhn_vpl VALUES ("JS21_10","007_21_10","JOS","21","10","10","या नगर लेवीया कहाती कुल मा सी हारुनक ओवलियादक करता हता; काहकी पेहली चिट्ठी हेकीक नाव पर निकळी हती। ");
INSERT INTO dhn_vpl VALUES ("JS21_11","007_21_11","JOS","21","11","11","मतलब हेका उनाक यहुदाक पहाड़ी देश मा चार तरफन चाराई समेत किरयतरबा नगर आप देदा, जा अनाकक बास अर्बाक नाव पर कहवाये आरु हेब्रोन भी कहवाये छे। ");
INSERT INTO dhn_vpl VALUES ("JS21_12","007_21_12","JOS","21","12","12","पुन उका नगरक खेत आरु ओकान गाव हेका यपुन्नेक कालेबक उकान खाजगी भुमी करीन आप देदा। ");
INSERT INTO dhn_vpl VALUES ("JS21_13","007_21_13","JOS","21","13","13","तव हेका हारुन याजकक ओवलियादक चाराई समेत खुनीक शरण नगर हेब्रोन, आरु आपनी आपनी चाराई समेत लिब्ना, ");
INSERT INTO dhn_vpl VALUES ("JS21_14","007_21_14","JOS","21","14","14","यत्तीर, एश्तमो, ");
INSERT INTO dhn_vpl VALUES ("JS21_15","007_21_15","JOS","21","15","15","होलोन, दबीर, ");
INSERT INTO dhn_vpl VALUES ("JS21_16","007_21_16","JOS","21","16","16","ऐन, युता आरु बेतशेमेश आपे; ओका प्रकार उना दुयु गोत्राक भाग मा सी नोव नगर आप्या गया। ");
INSERT INTO dhn_vpl VALUES ("JS21_17","007_21_17","JOS","21","17","17","आरु बिन्यामीनक गोत्राक भाग मा सी आपनी आपनी चाराई समेत या चार नगर आप्या गया, मतलब गिबोन, गेबा, ");
INSERT INTO dhn_vpl VALUES ("JS21_18","007_21_18","JOS","21","18","18","अनातोत आरु अल्मोन आरु च्‌यार नगर। ");
INSERT INTO dhn_vpl VALUES ("JS21_19","007_21_19","JOS","21","19","19","ओका प्रकार हारुन ओवलियादी याजकन तेरा नगर आरु उनाक चाराई जोड़ी। ");
INSERT INTO dhn_vpl VALUES ("JS21_20","007_21_20","JOS","21","20","20","पछा बाकी कहाती लेवियाक कुलक भागन नगर चिट्ठी न्हाख न्हाखिन एपरेमक गोत्राक भाग मा सी आप्या गया। ");
INSERT INTO dhn_vpl VALUES ("JS21_21","007_21_21","JOS","21","21","21","मतलब उनाक चाराई समेत एपरेमक पहाड़ी देश मा खुनीक शरण लेनेक शकेम नगर आप्या गया, पछा आपनी आपनी चाराई समेत गेजेर, ");
INSERT INTO dhn_vpl VALUES ("JS21_22","007_21_22","JOS","21","22","22","किबसेम, आरु बेथोरोन; या चार नगर आप्या गया। ");
INSERT INTO dhn_vpl VALUES ("JS21_23","007_21_23","JOS","21","23","23","आरु दानक गोत्राक भाग मा सी आपनी आपनी चाराई समेत, एलतके, गिब्बतोन, ");
INSERT INTO dhn_vpl VALUES ("JS21_24","007_21_24","JOS","21","24","24","अय्यालोन, आरु गत्रिम्मोन; या चार नगर आप्या गया। ");
INSERT INTO dhn_vpl VALUES ("JS21_25","007_21_25","JOS","21","25","25","आरु मनश्शेक आदा गोत्राक भाग मा सी आपनी आपनी चाराई समेत तानाक आरु गत्रिम्मोन; या दुय नगर आप्या गया। ");
INSERT INTO dhn_vpl VALUES ("JS21_26","007_21_26","JOS","21","26","26","ओका प्रकार बाकी कहातियाक कुलक सब नगर चाराई समेत दस ठर्‍या। ");
INSERT INTO dhn_vpl VALUES ("JS21_27","007_21_27","JOS","21","27","27","पछा लेवियाक कुलमान गेर्शोनियाक मनश्शेक आदा गोत्राक भाग मा सी आपनी आपनी चाराई समेत खुनीक शरण नगर बासानक गोलान आरु बेशतरा; या दुय नगर आप्या गया। ");
INSERT INTO dhn_vpl VALUES ("JS21_28","007_21_28","JOS","21","28","28","आरु इस्साकारन गोत्रान भाग मा सी आपनी आपनी चाराई समेत किश्योन, दाबरत, ");
INSERT INTO dhn_vpl VALUES ("JS21_29","007_21_29","JOS","21","29","29","यर्मुत, आरु एनगन्नीम; या चार नगर आप्या गया। ");
INSERT INTO dhn_vpl VALUES ("JS21_30","007_21_30","JOS","21","30","30","आरु आशेरक गोत्राक भाग मा सी आपनी आपनी चाराई समेत मिशाल, अब्दोन, ");
INSERT INTO dhn_vpl VALUES ("JS21_31","007_21_31","JOS","21","31","31","हेल्कात, आरु रहोब; या चार नगर आप्या गया। ");
INSERT INTO dhn_vpl VALUES ("JS21_32","007_21_32","JOS","21","32","32","आरु नप्तालीन गोत्राक भाग मा सी आपनी आपनी चाराई समेत खुनी क शरण नगर गलीलक केदेश, पछा हम्मोतदोर, आरु कर्तान; या तीन नगर आप्या गया। ");
INSERT INTO dhn_vpl VALUES ("JS21_33","007_21_33","JOS","21","33","33","गेर्शोनियाक कुलक अनसारे उकान सब नगर आपनी आपनी चाराई समेत तेरा ठरसे। ");
INSERT INTO dhn_vpl VALUES ("JS21_34","007_21_34","JOS","21","34","34","पछा बाकी लेविया, मतलब मरारियाक कुलक जबुलुनक गोत्राक भाग मा सी आपनी आपनी चाराई समेत योकनाम कर्ता, ");
INSERT INTO dhn_vpl VALUES ("JS21_35","007_21_35","JOS","21","35","35","दिम्नो, आरु नहलाल; या चार नगर आप्या गया। ");
INSERT INTO dhn_vpl VALUES ("JS21_36","007_21_36","JOS","21","36","36","आरु रुबेनक गोत्रान भाग मा सी आपनी आपनी चाराई समेत बेसेर, यहसा, ");
INSERT INTO dhn_vpl VALUES ("JS21_37","007_21_37","JOS","21","37","37","कदेमोत, आरु मेपात; या चार नगर आप्या गया। ");
INSERT INTO dhn_vpl VALUES ("JS21_38","007_21_38","JOS","21","38","38","आरु गादक गोत्राक भाग मा सी आपनी आपनी चाराई समेत खुनीक शरण नगर गिलाद मा रामोत, पछा महनेम, ");
INSERT INTO dhn_vpl VALUES ("JS21_39","007_21_39","JOS","21","39","39","हेशबोन, आरु याजेर, जु सब मेवीन चार नगर छे, आप्या गया। ");
INSERT INTO dhn_vpl VALUES ("JS21_40","007_21_40","JOS","21","40","40","लेवियाक बाकी कुलक मतलब मरारियाक कुल अनसारे उनाक सब नगर या ठर्‍या, ओका प्रकार उनाक बारा नगर चिट्ठी न्हाख न्हाखिन आप्या गया। ");
INSERT INTO dhn_vpl VALUES ("JS21_41","007_21_41","JOS","21","41","41","इसराएलियाक निज धरतीक वीचमा लेवियाक सब नगर आपनी आपनी चाराई समेत अड़तीस ठर्‍या। ");
INSERT INTO dhn_vpl VALUES ("JS21_42","007_21_42","JOS","21","42","42","या सब नगर आपना आपना चार तरफन चाराईक साथ ठरे; इना सब नगरक यी दशा हती। ");
INSERT INTO dhn_vpl VALUES ("JS21_43","007_21_43","JOS","21","43","43","ओका प्रकार योहोवा इसराएलियाक चा सब देश देदा, जेका ओको उनाक डाहला सी शपथ खाईन आपनेक कयो हतो; आरु चा ओकान हक होईन ओकामा बठ गया। ");
INSERT INTO dhn_vpl VALUES ("JS21_44","007_21_44","JOS","21","44","44","आरु योहोवा उनाक सब वातक अनसारे, जो ओकाह उनाक डाहला सी शपथ खाईन कयी हती, हेका चार तरफ सी आराम देदा; आरु उनाक दुश्मन मा सी कुई भी ओकान सामने टिक नी सक्या; योहोवा उना सभा क वश मा कर देदा। ");
INSERT INTO dhn_vpl VALUES ("JS21_45","007_21_45","JOS","21","45","45","जोतरा भलाईन वात योहोवा इसराएलक घराना सी कयी हुती उनामा सी कुई वात भी नी छूटी; सबन सब पुरी होई। ");
INSERT INTO dhn_vpl VALUES ("JS22_1","007_22_1","JOS","22","1","1","उके टेमे योहोसु रुबेनिया, गादिया, आरु मनश्शेक आदा गोत्रियाक बुलावीन कयो, ");
INSERT INTO dhn_vpl VALUES ("JS22_2","007_22_2","JOS","22","2","2","“जी जी हुकुम तुमु मानला छे, आरु जी जी हुकुम मुसा काजे योहोवा तुमुक आपली छे उना सभाक भी तुमु मानला छे; ");
INSERT INTO dhn_vpl VALUES ("JS22_3","007_22_3","JOS","22","3","3","तुमु आपना भाईसक ओतरा दाहड़ा मा आज क दाहड़े तक नी छुड़्या, पुन आपना परमेश्वर योहोवा क हुकुम तुमु चोकसी सी मानी छे। ");
INSERT INTO dhn_vpl VALUES ("JS22_4","007_22_4","JOS","22","4","4","आरु हिमी तुमरो परमेश्वर योहोवा तुमरा भाईसक आपना वचनक अनसारे आराम देदा छे; एरकरता हिमी तुमु वापस फिरीन आपना आपना डेराक, आरु आपनी निजी धरती मा, जेका योहोवाक दास मुसा यरदन पार तुमुक आप्या छे, जात रयु। ");
INSERT INTO dhn_vpl VALUES ("JS22_5","007_22_5","JOS","22","5","5","केवल ओका वात क पुरी चोकसी करनु कि जी जी हुकुम आरु व्यवस्था योहोवा क दास मुसु तुमुक आपी छे ओकाह मानीन आपना परमेश्वर योहोवा सी मोंग राखु, ओका सब मार्ग पर चालु, ओकान हुकुम मानु, उकान भक्ति मा लवलीन रयु, आरु आपना सब मन आरु सब प्राण सी ओकान सेवा करु।” ");
INSERT INTO dhn_vpl VALUES ("JS22_6","007_22_6","JOS","22","6","6","तव योहोसु हेका सय बरकत आपीन वाट लागाड्या आरु चा आपना आपना डेरा पर जात रया। ");
INSERT INTO dhn_vpl VALUES ("JS22_7","007_22_7","JOS","22","7","7","मनश्शे क आदा गोत्रियाक मुसु बासान मा भाग देदो हतो; पुन दिसरा आदा गोत्राक योहोसु ओका भाईसक वीच मा यरदनक पश्चिमक तरफ भाग देदा। ओकाह जव योहोसु सोयाव्वु कोविन वाट लागाड़्या कि आपना आपना डेरा मा जाऊ, ");
INSERT INTO dhn_vpl VALUES ("JS22_8","007_22_8","JOS","22","8","8","तव उनाक भी सय बरकत आपीन कया, “बैस सी पशु, आरु चाँदी, हुनो, पीतवन, लोखंडो, आरु बैस सी छिंदरा, आरु बैस धन-सम्पत्ति लीन आपना आपना पेरा पर जात रयु; आरु आपना दुश्मनक लुटक सम्पत्ति क आपना भाईसक साथे वाट लेजु।” ");
INSERT INTO dhn_vpl VALUES ("JS22_9","007_22_9","JOS","22","9","9","तव रुबेनी, गादि, आरु मनश्शे क आदा गोत्रि इसराएलीयाक जु सी, मतलब कनान देश क शीला नगर सी, आपनी गिलाद नावन निजी धरती मा, जी मुसान द्वारा आपी गई योहोवा क हुकुमोन अनसारे उकान निजी धरती होय गई हती, जानेन विचार सी वापस फिर गया। ");
INSERT INTO dhn_vpl VALUES ("JS22_10","007_22_10","JOS","22","10","10","जव रुबेनी, गादि, आरु मनश्शे क आदा गोत्रि यरदनक उका तराई मा पुग्या जा कनान देश मा छे, तव हेका चा देखने योग्य एक मोटली वेदी बनाई। ");
INSERT INTO dhn_vpl VALUES ("JS22_11","007_22_11","JOS","22","11","11","आरु ओका खबर इसराएलीयाक सोमवने मा आयो, कि रुबेनियो, गादियो, आरु मनश्शेक आदा गोत्रियोन कनान देशक सामने यरदनक तराई मा, मतलब ओकान उका पार जा इसराएलीयाक छे, एक वेदी बनाई छे। ");
INSERT INTO dhn_vpl VALUES ("JS22_12","007_22_12","JOS","22","12","12","जव इसराएलीया यो सोमव्या, तव इसराएलीयाक सब मण्डली ओका सी लड़नेक करता चढ़ाई करनेक करता शीलो मा एकठा होया। ");
INSERT INTO dhn_vpl VALUES ("JS22_13","007_22_13","JOS","22","13","13","तव इसराएलीया रुबेनियो, गोदिया, आरु मनश्शेक आदा गोत्रियाक जु गिलाद देश मा एलीयाजर याजकक पोर्‍यो पीनहासक, ");
INSERT INTO dhn_vpl VALUES ("JS22_14","007_22_14","JOS","22","14","14","आरु ओका साथे दस प्रधानोक, मतलब इस्राएलक एक एक गोत्रा मा सी पुर्वजक एक एक प्रधानक मोकल्या, आरु चा इस्राएलक हजारो मा आपना आपना पुर्वजक घरानाक मुखी मानुस हतो। ");
INSERT INTO dhn_vpl VALUES ("JS22_15","007_22_15","JOS","22","15","15","चा गिलाद देश मा रुबेनिया, गादिया, आरु मनश्शेक आदा गोत्रियाक जु जाईन कयने लाग्या, ");
INSERT INTO dhn_vpl VALUES ("JS22_16","007_22_16","JOS","22","16","16","“योहोवा क सब मण्डली यो कयती छे, ‘तुमु इस्राएलन परमेश्वर योहोवाक यो कोसो विश्वासघात कर्‌या; आज जो तुमु एक वेदी बनाव लेदा छे, ओका मा तुमु ओकान पछव चालनेक छुड़ीन ओकान विरुद आज बलवा कर्‌या छे? ");
INSERT INTO dhn_vpl VALUES ("JS22_17","007_22_17","JOS","22","17","17","सोमवु पोरक विषयक ओधोरोम आमरे करता जुरुक कम हतो, यद्यापि योहोवाक मण्डलीक भारी दण्ड जोड़े तेभी आजुन दाहड़े आमु ओका ओधोरोम सी चुखा नी होया; काय चो तुमरी नजर मा एक नानी वात छे ");
INSERT INTO dhn_vpl VALUES ("JS22_18","007_22_18","JOS","22","18","18","कि आज तुमु योहोवाक त्यागीन ओकान पछव चालमनु छुड़ देन्या छे? आज तुमु योहोवा सी पछा जाता होसे, आरु काल चा इस्राएलक सब मण्डली सी क्रोधित होसे। ");
INSERT INTO dhn_vpl VALUES ("JS22_19","007_22_19","JOS","22","19","19","पुण दाम तुमरो सतान जागो विटोळ हय ती पार आवीन भगवानन खास जागा मा जाँ सारी भगवान रये हामरे वीच मा तुमरो सतान जागो कर लेयो पुण हामरा योहोवा परमेश्वर वेदी क छुड़ीन कोय दिसरी वेदी बनावीन हेको विरुध्द मा झुन जाता आरु नी ते हामरे विरुद मा। ");
INSERT INTO dhn_vpl VALUES ("JS22_20","007_22_20","JOS","22","20","20","देखु, जव जेरह क पोर्‍यो आकान अर्पण करली चीजक विषय मा विश्वासघात कर्‌या, तव काय योहोवाक कोप इस्राएलक पुरी मण्डली पर नी भड़क्यो? आरु ओका मानुसक धर्मक प्राण डोन एखलाक ओकाक नी जोड्या।’” ");
INSERT INTO dhn_vpl VALUES ("JS22_21","007_22_21","JOS","22","21","21","तव रुबेनिया, गादियो, आरु मनश्शेक आदा गोत्रिया इस्राएलक हजारोक मुखी लोगहनक यो जवाब देदो, ");
INSERT INTO dhn_vpl VALUES ("JS22_22","007_22_22","JOS","22","22","22","“योहोवा परमेश्वर आखा सी जुर भरीयो ताकत वाळो छे, त्यो भगवानुत जाने, आरु इसराएली भी ओका जान लेसे कि कदाम योहोवा सी फिरके या ओकान विश्वासघात करीन आमु यो काम कर्‌या होसे, ते तु आज आमुक जीवतु नी छुड़े, ");
INSERT INTO dhn_vpl VALUES ("JS22_23","007_22_23","JOS","22","23","23","कदाम आज क दाहड़े आमु नी वेदीक एरकरता बनाया होसे कि योहोवाक पछव चालनु छुड़ देजे, या एरकरता कि ओका पर होमबली, अन्नबली, या मेलबलि चढ़ाया, ते योहोवा आप हेरो हिसाब लेसे; ");
INSERT INTO dhn_vpl VALUES ("JS22_24","007_22_24","JOS","22","24","24","पुन आमु ओका विचार आरु मनसा सी यो कर्‌या छे के भविष्य मा तुमरी सन्तान आमरी सन्तान सी यो नी कयने लागे, ‘तुमुक इस्राएलक परमेश्वर योहोवा सी काय काम? ");
INSERT INTO dhn_vpl VALUES ("JS22_25","007_22_25","JOS","22","25","25","काहकी, हे रुबेनियो, हे गादियो, योहोवा जो आमरे आरु तुमरे वीच मा यरदनक सीमा ठराय देदो छे, एरकरता योहोवा मा तुमरा एक भी भाग नी छे।’ ओसो कोईन तुमरी सन्तान आमरी सन्तान मा सी योहोवाक बीक छुड़ाय देसे। ");
INSERT INTO dhn_vpl VALUES ("JS22_26","007_22_26","JOS","22","26","26","एरकरता आमु कया, ‘आवु, आमु आपने करता एक वेदी बनाव लेवु, चा होमबली या मेलबलिन बादा न करता नी, ");
INSERT INTO dhn_vpl VALUES ("JS22_27","007_22_27","JOS","22","27","27","पुन एरकरता कि आमरा आरु तुमरा, आरु आमरा बाद आमरा आरु तुमरा ओवलियादक वीच मा साक्षीन काम आप; एरकरता कि आमु होमबली, मेलबलि, आरु बादा चढ़ावीन योहोवाक सामने ओकान उपासना करे; आरु भविष्य मा तुमरी सन्तान आमरी सी यो नी कयनु जुवे, कि योहोवा मा तुमरो कुई भाग नी।’ ");
INSERT INTO dhn_vpl VALUES ("JS22_28","007_22_28","JOS","22","28","28","एरकरता आमु कया, ‘जव चा लोगहन भविष्य मा आमु सी या आमरा ओवलियाद सी यो कयने लाग्या, तव आमु उना सी कयसु, कि योहोवाक वेदीक नमुना पर बवनी होई ओका वेदीक देखु, जेका आमरा डाहला होमबली या मेलबलिक बादा न करता नी बनाया; पुन एरकरता बनाया हता कि आमरे आरु तुमरे वीच मा साक्षीक काम आप।’ ");
INSERT INTO dhn_vpl VALUES ("JS22_29","007_22_29","JOS","22","29","29","यो आमु सी छेठा रया कि योहोवा सी फिरीन आज ओकान पछव चालनु छुड़ दे, आरु आपनु परमेश्वर योहोवाक ओका वेदीक छुड़ावीन जो ओकान निवासक सामने छे होमबली, आरु अन्नबलि, या मेलबलिन बादान करता दिसरी वेदी बनाया।” ");
INSERT INTO dhn_vpl VALUES ("JS22_30","007_22_30","JOS","22","30","30","रुबेनियो, गादियो, आरु मनश्शेक आदा गोत्रियाक इनी वातक सोमवीन पीनहास याजक आरु ओकान साथे मण्डलीक प्रधान, जो इस्राएलक हजारो मुखी मानसे हता, चा बैस खुश होया। ");
INSERT INTO dhn_vpl VALUES ("JS22_31","007_22_31","JOS","22","31","31","आरु एलीयाजर याजकक पोर्‍यो पीनहास रुबेनियो, गादियो, आरु मनश्शेइयो सी कया, “तुमु जो योहोवाक ओसो विश्वासघात नी कर्‌या, ओका सी आज आमु यो जान लेदा कि योहोवा आमरे वीच मा छे: तुमु लोगहन इसराएलीयाक योहोवाक हाथ सी वाचाड्या छे।” ");
INSERT INTO dhn_vpl VALUES ("JS22_32","007_22_32","JOS","22","32","32","तव एलीयाजर याजकक पोर्‍यो पीनहास प्रधान समेत रुबेनियो, आरु गादियोक, जु सी गिलाद होयता कनान देश मा इसराएलीयाक जु वापस गया: आरु यो वृतान्त उनाक कय सोमवाड्या। ");
INSERT INTO dhn_vpl VALUES ("JS22_33","007_22_33","JOS","22","33","33","तव इसराएली खुश होया: आरु परमेश्वरक सोयाव्वु कया, आरु रुबेनियो, आरु गादियो, सी लड़ने आरु उनाक रयनेक देश उजाड़नेक करता चढ़ाई करनेक चर्चा पछी नी करी। ");
INSERT INTO dhn_vpl VALUES ("JS22_34","007_22_34","JOS","22","34","34","आरु रुबेनियो, आरु गादियो, यो कोईन, “यी वेदी आमरे आरु उनाक वीचमा ओका वातक साक्षी ठरी छे, कि योहोवाज परमेश्वर छे;” ओकी वेदीक नाव एद मेक्या। ");
INSERT INTO dhn_vpl VALUES ("JS23_1","007_23_1","JOS","23","1","1","ओका बैस दाहड़ाक बाद, जव योहोवा इसराएलीयाक उनाक चार तरफ शत्रु सी आराम देदा, आरु योहोसु दाडला आरु बैस दाहलो होय गया, ");
INSERT INTO dhn_vpl VALUES ("JS23_2","007_23_2","JOS","23","2","2","तव योहोसु सब इसराएलीयाक, मतलब पुरानो मुखी मानुस, न्यायियो, आरु सरदारक बुलावीन कयने लाग्या, “हाव ते हिमी दाहला आरु बैस सालक होय गयु छे; ");
INSERT INTO dhn_vpl VALUES ("JS23_3","007_23_3","JOS","23","3","3","आरु तुमु नी देखता छे कि तुमरो परमेश्वर योहोवा तुमरे निमत्त इनी सब जातिया सी काय काय करला छे, काहकी जि तुमरी तरफ सी लड़तु आयु छे चु तुमरो परमेश्वर योहोवा छे। ");
INSERT INTO dhn_vpl VALUES ("JS23_4","007_23_4","JOS","23","4","4","देखु, हाव इनी वाचली जातियाक चिट्ठी न्हाख न्हाखिन तुमरा गोत्राज भाग कर देदा छे; आरु यरदन सी लीन दाहड़ु बुडने तरफ मोटलो दरिया तक रयनरवाळी उना सब जातियाक भी ओसोज देदा छे, जेकाक हाव काट न्हाख्या छे। ");
INSERT INTO dhn_vpl VALUES ("JS23_5","007_23_5","JOS","23","5","5","आरु तुमरो परमेश्वर योहोवा उनाक तुमरे सामने उनाक देश सी निकाळ देसे; आरु तुमु आपना परमेश्वर योहोवाक वचन क अनसारे उनाक देशक हक होय जासे। ");
INSERT INTO dhn_vpl VALUES ("JS23_6","007_23_6","JOS","23","6","6","एरकरता बैस हियाव बाँधिन, जो काहय मुसान व्यवस्थाक किपात मा लिखलो छे ओकाक पुरो करने मा चोकसी करनु, ओका सी नी ते जेवड़े वोगे फिरनु आरु नी डाखरे। ");
INSERT INTO dhn_vpl VALUES ("JS23_7","007_23_7","JOS","23","7","7","या जा जातिया तुमरे वीचमा रय गया छे इनाक वीच मा नी जानु, आरु नी ओका देवताक नावक चर्चा करनु, आरु नी ओकान शपथ खावळावनु, आरु नी ओकान विनता करनु, आरु नी ओकाक दण्डवत् करनु, ");
INSERT INTO dhn_vpl VALUES ("JS23_8","007_23_8","JOS","23","8","8","पुन जोसो आजुन दाहड़े तक आपना परमेश्वर योहोवाक भक्ति मा लवलीन रयता होसे, तोसाज रया करनु। ");
INSERT INTO dhn_vpl VALUES ("JS23_9","007_23_9","JOS","23","9","9","योहोवा तुमरे सामने सी मोटली मोटली आरु बलवन्त जातिया निकावळी छे; आरु तुमरे सामने आजुन दाहड़े तक कुई रुकाय नी सक्या। ");
INSERT INTO dhn_vpl VALUES ("JS23_10","007_23_10","JOS","23","10","10","तुमु मा सी एक मानसक हजार मानसक डासाड़से, काहकी तुमरो परमेश्वर योहोवा आपना वचनक अनसारे तुमरी तरफ सी लड़ता छे। ");
INSERT INTO dhn_vpl VALUES ("JS23_11","007_23_11","JOS","23","11","11","एरकरता आपना परमेश्वर योहोवा सी मोंग राखनेक पुरी चोकसी करनु। ");
INSERT INTO dhn_vpl VALUES ("JS23_12","007_23_12","JOS","23","12","12","काहकी कदाम तुमु काहनी रीति योहोवा सी फिरीन इनी जातियाक बाकी लोगहन सी मिवने लागे जो तुमरे वीच वाचला होया रयता छे, आरु इना सी हियाव करीन इनाक साथ समधियाना रिश्ता जुड़ो, ");
INSERT INTO dhn_vpl VALUES ("JS23_13","007_23_13","JOS","23","13","13","ते नक्की जान लेवु कि ओगव तुमरे परमेश्वर योहोवा इनी जातियाक तुमरे सामने सी नी निकाळसे; आरु या तुमरे करता पाणी आरु फंदा, आरु तुमरे पांजरोक करता कोड़े, आरु तुमरी डुवा मा काटा ठरसे, आरु नास मा तुमु इनी वारली धरती पर सी जो तुमरो परमेश्वर योहोवा तुमुक आपी छे खतम होय जासे। ");
INSERT INTO dhn_vpl VALUES ("JS23_14","007_23_14","JOS","23","14","14","“सोमवु, हाव ते हिमी संसारियाक गति पर जानेवाळो छे, आरु तुमु सब आपना आपना ह्रदय आरु मन मा जानता होसे, कि जोतरी भलाईक वात आमरा परमेश्वर योहोवा आमरे विषय मा कया उनामा सी एक भी बिना पुरी होया नी रयु; चा सबक सब तुमु घट गई छे, उनामा सी एक भी बिना पुरी होए नी रई। ");
INSERT INTO dhn_vpl VALUES ("JS23_15","007_23_15","JOS","23","15","15","ते जोसो तुमरो परमेश्वर योहोवाक कयली वात सब भलाईक वात तुमु पर घटी छे; तोसोज योहोवा विपत्तिक सब वात भी तुमु पर लागाड़से आरु तुमुक इकी वारली धरतीन उपर सी, जेका तुमरा परमेश्वर योहोवा तुमुक आप्या छे। खतम कर न्हाखसे। ");
INSERT INTO dhn_vpl VALUES ("JS23_16","007_23_16","JOS","23","16","16","जव तुमु उका वाचाक, जेका तुमरे परमेश्वर योहोवा तुमुक हुकुम आपीन आपने साथे बांधाया छे, तुड़नो करीन पराया देवताक विनता आरु उनाक दण्तत् करने लाग्या, तव योहोवाक कोप तुमु पर भड़केगा, आरु तुमु ओका वारला देश मा सी जेका ओका तुमुक आप्या छे पटकन खतम होय जासे।” ");
INSERT INTO dhn_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","पछा योहोसु इस्राएलक सब गोत्राक शकेम मा इकट्ठा कर्‌या, आरु इस्राएलक दाहला लोगहन आरु मुखी लोगहन, आरु न्यायियो, आरु सरदारक बुलवाया; आरु चा परमेश्वरन सामने हजर होया। ");
INSERT INTO dhn_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","तव योहोसु उना सब लोगहन सी कया, “इस्राएलक परमेश्वर योहोवा ओका प्रकार कयता छे, ‘प्राचीन काल मा अब्राहम आरु नाहोरक बास तेरह आदि, तुमरा पुरखा परात महानदक ओका पर रयता रयता दिसरा देवताक विनता करता हता। ");
INSERT INTO dhn_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","आरु हाव तुमरे खास अबराहम महानदक उका पार सी ली आवीन कनान देशक सब स्थान मा फिराया, आरु ओकान ओवलियाद बढ़ाया। आरु ओका इसहाको आप्या; ");
INSERT INTO dhn_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","पछा हाव इसहाको याकुब आरु एसावक आप्या। आरु एसावक हाव सेईर नावन पहाड़ी देश आप्या के चा ओकान हक होसे, पुन याकुब बेटो-नातन्यो समेत मिसरक गया। ");
INSERT INTO dhn_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","पछा हाव मुसा आरु हारुन मुकलीन उना सब कामोक द्वारा जो हाव मिसर मा कर्‌या, उका देशक मारा; आरु ओकान बाद तुमुक निकाळ लाया। ");
INSERT INTO dhn_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","6","आरु हाव तुमरे डाहलाक मिसर मा सी निकाळ लाया, आरु तुमु दरियाक पुग्या; आरु मिसरिया रथ आरु सवारोक साथे लीन लाल दरिया तक तुमरा पीछा कर्‌या। ");
INSERT INTO dhn_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","आरु जव तुमु योहोवाक दोहाई आपी तव ओकान तुमरे आरु मिसरियाक वीच मा अन्धियारा कर देदा, आरु उना पर दरियाक वयाडीन उनाक डुबाड़ देदा; आरु जो काहय हाव मिसर मा कर्‌या उका तुमु बैस लोगहन आपनी डुवा सी देख्या; पछा तुमु बैस दाहड़े जंगल मा रया। ");
INSERT INTO dhn_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","तव हाव तुमुक उना एमोरियाक देश मा ली आया, जो यरदन उका पार बठला हता; आरु चा तुमु सी लड़े, आरु हाव हेके तुमरे ओवलियाद मा कर देदा, आरु तुमु उनाक देशक आधिकारी होय गया, आरु हाव उनाक तुमु सामने सी सत्यानाश कर न्हाख्या। ");
INSERT INTO dhn_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","पछा मोआबक राजा सिप्पोरक पोर्‍याक बालाक उठावीन इस्राएल सी लड़ा; आरु तुमुक शाप देनेक करता बोर क पोर्‍या बिलामक बुलावने मुकल्यो, ");
INSERT INTO dhn_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","पुन हाव बिलामक नी सोमव्यु; चा तुमुक बरकत आपता गया; ओका प्रकार हाव तुमुक ओकान हाथ सी वाचाड्या। ");
INSERT INTO dhn_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","तव तुमु यरदन पार होईन योरीहोक जु आया, आरु जव योरीहोक मानुसे, आरु एमोरी, परिज्जी, कनानी, हित्ती, गिर्गाशी, हिब्बी, आरु यबुसी तुमु सी लड्या, तव हाव हेका तुमरा वश मा कर देदा। ");
INSERT INTO dhn_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","आरु हाव तुमरे ओगव गेंडरा क मुकल्या, आरु हेकान एमोरियान दुयु राजा तुमरे सामने सी डास्या; देखु, यी तुमरी तलवार या धोंदलीक काम नी होयो। ");
INSERT INTO dhn_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","पछा हाव तुमुक ओसा देश आप्या जेका हाव तुमु मेहनत नी कर्या हता, आरु ओसो नगर भी देदा छे जेका तुमु नी बठाड्या हता, आरु तुमु ओकामा बठला होसे; आरु जीन दाखरस आरु जैतुनन बगीचाक फोवक फोव तुमु खाता होसे हेका तुमु नी लागाड्या हता।’ ");
INSERT INTO dhn_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","“एरकरता हिमी योहोवा परमेश्वरन बीक मानीन ओकान सेवा छाचाय आरु सच्चाई सी करु; आरु जिन देवताक सेवा तुमरा पुरखा महानदक उका पार आरु मिसर मा करता हता, हेका छेठा करीन योहोवाक सेवा करु। ");
INSERT INTO dhn_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","आरु कदाम योहोवा परमेश्वरन सेवा करनु तुमुक बुरो लागे, ते आज नेवाळ लेवु कुनीन सेवा कर हत, चाहे उना देवताक जिनाक सेवा तुमरा पोरखा महानदक उका पार करता हता, आरु चाहे एमोरियाक देवतान सेवा करु जिनाक देश मा तुमु रयता होसे; पुन हाव ते आपना घराना समेत योहोवान सेवा नित करीस।” ");
INSERT INTO dhn_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","तब लोगहन जवाब देदा, “योहोवा परमेश्वर क त्यागीन दिसरा देवतान सेवा करनु आमु सी छेठा रयु; ");
INSERT INTO dhn_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","काहकी आमरु परमेश्वर योहोवा चा छे जु आमुक आरु आमरे पुरखाक दासत्वक घर, मतलब मिसर देश सी निकाळ ली आया, आरु आमरा देखता देखता मोटला मोटला विछेळीयो काम कर्‌या, आरु जेकि वाट पर आरु जोतरी जातियाक वीच मा सी आमु चालीन आवता हता ओका सी आमरी रक्षा; ");
INSERT INTO dhn_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","आरु आमरे सामने सी ओका देश मा रयनेवाळा एमोरी कदाम सब जातियाक निकाळ देदा छे; एरकरता आमु भी योहोवाक सेवा करसु, काहकी आमरो परमेश्वर चो छे।” ");
INSERT INTO dhn_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","योहोसु लोगहन सी कयो, “तुमु सी योहोवाक सेवा नी होय सकती; काहकी चो पवित्र परमेश्वर छे; चो जलन राखनेवाळो ईश्वर छे; चो तुमरो आपराध आरु पाप सोमा नी करसे। ");
INSERT INTO dhn_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","कदाम तुमु योहोवाक त्यागिन देवतान सेवा करने लागसे, ते यद्यपि चा तुमरो भलो करता आयो छे तेभी चा फिरीन तुमरो नुकसान करसे, आरु तुमरो नास भी कर न्हाखसे।” ");
INSERT INTO dhn_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","लोगहन योहोसु सी कया, “नी; आमु योहोवान सेवा करसु।” ");
INSERT INTO dhn_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","योहोसु लोगहन सी कयो, “तुमु आपसुज आपना साक्षी होयु कि तुमु योहोवान सेवा करनु नेवाळ लेदा छे।” हेका कया, “होव, आमु साक्षी छे।” ");
INSERT INTO dhn_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","योहोसु कयो, “आपने वीच मा सी पराया देवताक छेठा करीन आपना आपना मन इस्राएलक परमेश्वर योहोवाक तरफ लागाडु।” ");
INSERT INTO dhn_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","लोगहन योहोसु सी कया, “आमु ते आपना परमेश्वर योहोवाक सेवा करसु, आरु ओकान वात मानसु।” ");
INSERT INTO dhn_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","तव योहोसु उके दाहड़े उना लोगहन सी वाचा बांधाड्या, आरु शकेम मा ओकान करता विधि आरु नियम ठराया। ");
INSERT INTO dhn_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","यो सब वृतान्त योहोसु परमेश्वरक व्यवस्थाक किपात मा लिख देदा; आरु एक मोटलो दगडो नेवाळीन चा ओका बांज झाड़कान नेड़ो उबो कर्‍यो, जो योहोवान पवित्रस्थान मा हतो। ");
INSERT INTO dhn_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","तव योहोसु सब लोगहन सी कयो, “सोमवु, यो दगड़ु आमु लोगहनक साक्षी रवसु, काहकी जोतरा वचन योहोवा आमु सी कया छे हेका यो सोमव्यो छे; एरकरता यो तुमरा साक्षी रवसे, ओसो नी होए कि तुमु आपना परमेश्वर सी मुकर जावु।” ");
INSERT INTO dhn_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","तव योहोसु लोगहनक आपना आपना निज भाग पर जानेम करता वाग लागाड्या। ");
INSERT INTO dhn_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","इनी वातन बाद योहोवाक दास, नुनन पोर्‍यो योहोसु, एक सोव दस सालन होईन मर गयो। ");
INSERT INTO dhn_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","आरु ओकाह तिम्नत्सेरह मा, जु एपरेम क पहाड़ी देश मा गाश नावन पहाड़क उत्तर मा छे, उकान भाग मा धुवो आप गया। ");
INSERT INTO dhn_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","योहोसु क जीवन भर, आरु जा डाहला लोगहनक योहोसुक मरनेक बाद जीविता रया आरु जानता हता कि योहोवा इस्राएलक करता कोसा कोसा काम कर्‌या हता, ओकान भी जीवन इसराएली योहोवाक सेवा करता रया। ");
INSERT INTO dhn_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","पछु युसुफन हाड़का जेका इसराएली मिसर सी ली आया हता चा शकेमक धरतीक ओका भाग मा गाड़ी गई, जेका याकुब शकेमक बास हमोर पोर्‍या सी एक सोव चांदीक सिक्का मा मोल लेदा हता; एरकरता चु युसुफन सन्तानक निज भाग होय गयो। ");
INSERT INTO dhn_vpl VALUES ("JS24_33","007_24_33","JOS","24","33","33","हारुनक पोर्‍यो एलीयाजर भी मर गयो; आरु ओकान एपरेमक पहाड़ी देश मा ओका पहाड़ी पर धुवो आपी गई, जी ओकान पीनहासक नाव पर गिबत्पीनहास कयाड़ती छे आरु ओकाक आपी गई हती।");
INSERT INTO dhn_vpl VALUES ("ET1_1","018_1_1","EST","1","1","1","क्षयर्ष नावोन राजान दाहड़ा मा यी वाते हयी; यो त्यो क्षयर्ष छे, जो एक सोव वीस ने सात देशो पर, मोतलोब इथियोपिया गोथु हिन्दुसतान लोगुन राज करतो हुतो। ");
INSERT INTO dhn_vpl VALUES ("ET1_2","018_1_2","EST","1","2","2","राजा क्षयर्ष क राजोन राजधानी शुशन गढ़ हुतो, त्या राजगादी पोर बोठीन राज कोर रयो हुतो। ");
INSERT INTO dhn_vpl VALUES ("ET1_3","018_1_3","EST","1","3","3","होंया हुयो आपसा राज क तीसरा साल मा आपसा आखा मुखी आरु कामकरन्या क भोज आप्यो। फारस आरु मादै क सेनापति आरु प्रान्त-प्रान्त क प्रधान आरु हाकिम ओका अगळ आय गुया। ");
INSERT INTO dhn_vpl VALUES ("ET1_4","018_1_4","EST","1","4","4","भोज करवानेन तिहवार छोव महिना तक वाळीयो। आरु पाहंतीरियान को हेका राज वाड़ान धन आरु हेकी राज करनेन शान देखड़तो रियो। ");
INSERT INTO dhn_vpl VALUES ("ET1_5","018_1_5","EST","1","5","5","ओतरा दाहड़ा क वितने पोर राजा न काय नाना काय मोटा उना आखा क वी ज शुशन नावोन राजगढ़ मा एकठा हुया हुता, राजभवन क वारी मा आँगना मा सात दाहड़ा लगुन भोज आप्यो। ");
INSERT INTO dhn_vpl VALUES ("ET1_6","018_1_6","EST","1","6","6","होंया क परदा श्वेत आरु निळा सुत क हुता, आरु सन आरु जामन्या रोंगोन। बठनेन पाटला सी चाँदी क छल्‌ला मा, संगमरमर क बोनला फोरस्या पोर धरी हुयी हतली। ");
INSERT INTO dhn_vpl VALUES ("ET1_7","018_1_7","EST","1","7","7","उना भोज मा राजा क योग्य दाखमधु भाति-भातिन रीते क सोना क टाहरा मा डालीन राजा क उदारता सी घनात भेळ पावतला। ");
INSERT INTO dhn_vpl VALUES ("ET1_8","018_1_8","EST","1","8","8","पीनो ते कायदा ओनसारे हयतो हुतो, जोसो चाहे तोसो पाळतला हुता; काहकी राजा न ते आपसा भवन क आखा भण्डारियो क हुकुम आपता हुता, की ज पाहनतरीया जसा चाहे ओका भेळ तोसाज वेवहार कोरनो। ");
INSERT INTO dhn_vpl VALUES ("ET1_9","018_1_9","EST","1","9","9","रानी वशती न वी राजा क्षयर्ष क भवन मा बायरा क भोज आप्या। ");
INSERT INTO dhn_vpl VALUES ("ET1_10","018_1_10","EST","1","10","10","सातवे दाहड़े, जोत्यार राजा क मोन दाखमधु मा मगन हुतो, तोत्यार हुयो महुमान, बिजता, हर्बोन, बिगता, अबगता, जेतेर आरु कर्कस नावोन सातु गोतराड़ा क ज क्षयर्ष राजा क अगळ सेवा चाखरी कोर्या कोरता हुता, हुकुम, ");
INSERT INTO dhn_vpl VALUES ("ET1_11","018_1_11","EST","1","11","11","की रानी वशती क राजमुकुट धारण कोर्‌यो हुयो राजा क अगळ ली आवु; जेरेसी कि देश-देश क लोगहन आरु हाकिमो पोर ओकी घाटाळो प्रगट होय जाय; काहकी हुये देखने मा घाटाळो हुतो। ");
INSERT INTO dhn_vpl VALUES ("ET1_12","018_1_12","EST","1","12","12","खोजो क लारे राजा नी यी हुकुम मिळी रानी वशती न आवने सी मोना कोर्‌यो। एना पोर राजा मोटा रीसवाईन जळने लाग्यो। ");
INSERT INTO dhn_vpl VALUES ("ET1_13","018_1_13","EST","1","13","13","तोत्यार राजा न टेमे-टेमे क भेद जाननेवाळा पंडितो सी पुछ्यो (राजा ते नीति आरु नियाव क आखा गियानियो सी असोज कोरतो हुतो। ");
INSERT INTO dhn_vpl VALUES ("ET1_14","018_1_14","EST","1","14","14","ओका पास कर्शना, शेतार, अदमाता, तर्शीश, मेरेस, मर्सना, आरु ममुकान नावोन फारस, आरु मादै क सात प्रधान हुता, ज राजा क दर्शन कोरता आरु राज मा खास-खास पदो पोर नेवाड़ कोर्‌यो गया हुता।) ");
INSERT INTO dhn_vpl VALUES ("ET1_15","018_1_15","EST","1","15","15","राजा न पुछ्‌या, “रानी वशती न राजा क्षयर्ष नु हेर लारे आपाड़ला हुकुम क तुड़नो कोर्या, ती नीतिन ओनसारे ओका भेळ काय कोर्‌यो जाय?” ");
INSERT INTO dhn_vpl VALUES ("ET1_16","018_1_16","EST","1","16","16","तोत्यार ममुकान न राजा आरु हाकिमो नु हाजरी मा जपाप आप्यो, “रानी वशती न ज भुंडो काम कर्‌यो छे, हुयो नी केवल राजा सी बाखुन आखा हाकिमो सी आरु उना आखा देशों क लोगहन सी वी ज राजा क्षयर्ष क आखा प्रान्तो मा रोहे छे। ");
INSERT INTO dhn_vpl VALUES ("ET1_17","018_1_17","EST","1","17","17","काहकी रानी क एना काम नु चर्चा आखा बायरा मा होयसे आरु जोत्यार यो कोयो जासे, ‘राजा क्षयर्ष न रानी वशती क आपसे अगळ ली आवने नु हुकुम आप्यो पुन हुयी नी आवी,’ ती हुये वी आपसा-आपसा घोरवाळा क तुच्छ जानने लागसे। ");
INSERT INTO dhn_vpl VALUES ("ET1_18","018_1_18","EST","1","18","18","आजुन दाहड़े फारस आरु मादी हाकिमो नु बायरा जे रानी नु यी वात सोमळायो छे ती हुये वी राजा क आखा हाकिमो सी असोज कोहने लागसे; एने रीते घनात घाड़ाय आरु रीस पोयदा होयसे। ");
INSERT INTO dhn_vpl VALUES ("ET1_19","018_1_19","EST","1","19","19","कदाम राजा क स्वीकार होय, ती यो हुकुम निकाळे, आरु फारसियो आरु मादीयो क कानुन मा लिखी वी जाय, जेरेसी कदाम बोदल नी सके, की रानी वशती राजा क्षयर्ष क अगळ ओळी कोदी आवने नी पावे, आरु राजा पटरानी क पद कुदा दिसरा क आप देये तेरेसी वारु होय। ");
INSERT INTO dhn_vpl VALUES ("ET1_20","018_1_20","EST","1","20","20","अत: जोत्यार राजा नु यो हुकुम ओका आखा राज मा सोमळायो जासे, ती आखा बायरा, आपसा-आपसा घरवाळा क चाहे गरीब होय एने अमीर, आदरमान कोरती रोहसे।” ");
INSERT INTO dhn_vpl VALUES ("ET1_21","018_1_21","EST","1","21","21","यी वात राजा आरु हाकिमो क पसन्द आवी आरु राजा न ममुकान नु सम्मति मान लेदो आरु आपसा राज मा, ");
INSERT INTO dhn_vpl VALUES ("ET1_22","018_1_22","EST","1","22","22","अर्थात् होरीक राजोन क आकड़ा मा आरु होरीक जाति नु बुली मा चिट्ठियाँ मुकळ्या, की आखा मानसे आपसा-आपसा घर मा होक चालाड़े, आरु आपसी जाति नु बुली बुल्या कोरे। ");
INSERT INTO dhn_vpl VALUES ("ET2_1","018_2_1","EST","2","1","1","एनु वारो क वाद जोत्यार राजा क्षयर्ष क रीस सेवती हुय गय, ती हुयो रानी वशती कर्‌यो, आरु ज काम हुयो कर्‌यो हुतो, आरु ज ओका वाराम हुकुम निकळी हुती ओकी वी सुधी लेदो। ");
INSERT INTO dhn_vpl VALUES ("ET2_2","018_2_2","EST","2","2","2","ती राजा क सेवक ज ओका टहलुए हुता, कहने लाग्या, “राजा क लिय घाटाळी एने जुवान कुँवारी हेरी जाय। ");
INSERT INTO dhn_vpl VALUES ("ET2_3","018_2_3","EST","2","3","3","आरु राजा न आपसा राज क आखा प्रान्तो मा लोगहन क एकालिय नेवाड़ कोर्‌यो की हुये आखा घाटाळी जुवान कुँवारियो क शुशन गढ़ क रनवास मा एकठा कोरे आरु बायरा क प्रबन्धक हेगे क ज राजा क खोजी हुतो सोप देये; आरु चुखा कोरने योग्य चिजे ओको आप्यो जाय। ");
INSERT INTO dhn_vpl VALUES ("ET2_4","018_2_4","EST","2","4","4","तोत्यार उनामासी जी कुँवारी राजा नु निंगा मा वारु ठहरे, ची रानी वशती क जागा पोर पटरानी बोनायी जाय।” यी वात राजा क पसन्द आवी आरु हुयो असोज कर्‌यो। ");
INSERT INTO dhn_vpl VALUES ("ET2_5","018_2_5","EST","2","5","5","शुशन गढ़ मा मोर्दके नावोन एक यहुदी रहतो हुतो, ज कीश नावोन एक बिन्यामीनी क परपोतो, शिमी क पोतो, आरु याईर क पुर्य हुतो। ");
INSERT INTO dhn_vpl VALUES ("ET2_6","018_2_6","EST","2","6","6","हुयो उना बन्दियो क साथ यरुशलेम सी बंदुआई मा गुयो हुतो, जेनुक बेबीलोन क राजा नबुकदनेस्सर, यहुदा क राजा यकोन्याह क भेळ यरुश्लेम बन्दी बोनावीन ली गुयो हुतो। ");
INSERT INTO dhn_vpl VALUES ("ET2_7","018_2_7","EST","2","7","7","हुयो हदास्सा नावोन आपसी चचेरी बहनीस क, ज एस्तेर वी कोहायती हुती, पाळन-पुष्‌यो हुतो; काहकी ओका आसी-बासा कुय नी हुता, आरु हुयी पुराय घाटाळी आरु रुपवती हुती, आरु जोत्यार ओका आसी-बासा मोर गुया, तोत्यार मोर्दके न ओको आपसी पुराय कोरीन पाळ्यो। ");
INSERT INTO dhn_vpl VALUES ("ET2_8","018_2_8","EST","2","8","8","जोत्यार राजा नु हुकुम आरु कायदा सोमवाड़्या गया, आरु बेसका जुवान बायरा, शुशन गढ़ मा हेगे क हक मा एकठा कोर्या गुया, ती एस्तेर वी राजभवन मा बायरा क प्रबन्धक हेगे क होक मा सोपी गुय। ");
INSERT INTO dhn_vpl VALUES ("ET2_9","018_2_9","EST","2","9","9","हुयी पुराय ओकी निंगा मा वारु लागी; आरु हुयो उनासी खुश हुयो, ती हुयो विगुर वार कर्‌यो ओको राजभवन मा सी चुखो करनेन चिजे, आरु ओको भुजन, आरु ओका लिय नेवाड़ली सात सहेलिया वी आप्यो, आरु ओको आरु ओकी सहेलियो क रनवास मा आखासी वारु रहने क जागो आप्यो। ");
INSERT INTO dhn_vpl VALUES ("ET2_10","018_2_10","EST","2","10","10","एस्तेर न नी आपसी जाती बताड़ी हुती, नी आपसो कुल; काहकी मोर्दके न ओको हुकुम आप्यो हुतो नी ओको नी बताड़जो। ");
INSERT INTO dhn_vpl VALUES ("ET2_11","018_2_11","EST","2","11","11","मोर्दके ते दाहड़ीन रनवास क आँगना क अगळ टहलतो हुतो ताकी जाने की एस्तेर कोसी छे आरु ची काय वारली होयसे? ");
INSERT INTO dhn_vpl VALUES ("ET2_12","018_2_12","EST","2","12","12","जोत्यार एक-एक पुराय नु वारी आवी, की हुयो क्षयर्ष राजा क पास जाय, आरु यो उना टेमे हुयो जोत्यार ओका पुठी बायरा ठहराया हुया कायदा क ओनसारे बारे मोहना लगुन वेवहार कोर्‌यो गुयो हुतो; अर्थात् ओको चुखो करने क दाहड़े एने रीते सी वीत गुया, की छव मोहना गन्धरस क तेल लागाड़्यो जातो हुतो, आरु छव महना लगुन गोंदायन्यो तेल, आरु बायरा क चुखो कोरने क दिसरो सोमान लागाड़्यो जातो हुतो। ");
INSERT INTO dhn_vpl VALUES ("ET2_13","018_2_13","EST","2","13","13","एने रीते सी हुयी पुराय जोत्यार राजा क पास जाती हुती, ती ज काही हुयी चाहती की रनवास सी राजभवन मा ली जाय, हुयो ओको आप्यो जातो हुतो। ");
INSERT INTO dhn_vpl VALUES ("ET2_14","018_2_14","EST","2","14","14","सांतो क ते हुयी जाती हुती आरु संदारे क हुयी लौटीन रनवास क दिसरा घर मा जाईन रखेलो क प्रबन्धक राजा क खोजे शाशगज क होक मा होय जाती हुती, आरु राजा क पास अळी नी जाती हुती। आरु कदाम राजा उनासी खुश हुय जातो हुतो, ती हुयो नाव लीन बुलावी जाती हतली। ");
INSERT INTO dhn_vpl VALUES ("ET2_15","018_2_15","EST","2","15","15","जोत्यार मोर्दके क चाचो अबीहेल नु पुराय एस्तेर, जेको मोर्दके न बेटी मानीन राखलो हुतो, ओकी वारी आवी की राजा क पास जाय, ती ज काई बायरा क प्रबन्धक राजा क खोजी हेगे न ओका लिय ठहरायो हुतो, उनासी जादा हुयी आरु काय नी माँगी। जोतरा न एस्तेर क देख्या, हुये आखा उनासी प्रसन्न हुया। ");
INSERT INTO dhn_vpl VALUES ("ET2_16","018_2_16","EST","2","16","16","अत: एस्तेर राजभवन मा राजा क्षयर्ष क पास ओका राज क सातवा वरीस क तेबेत नावोन दसवा मोहना मा पुगाड़ी गुय। ");
INSERT INTO dhn_vpl VALUES ("ET2_17","018_2_17","EST","2","17","17","आरु राजा न एस्तेर क आरु आखा बायरा सी जादा मोंग कोर्‌यो, आरु दिसरा आखा कुँवारियो सी जादा ओको फोकटन दया आरु गीन नु निंगा उना पोर हय, अस करीन हयो ओका मुनका पोर राजमुकुट मेक्यो आरु ओको वशती क जागा पोर रानी बोनायो। ");
INSERT INTO dhn_vpl VALUES ("ET2_18","018_2_18","EST","2","18","18","तोत्यार राजा न आखा हाकिमो आरु कामकरन्या क एक मोटो भोज आप्यो, आरु हुयो एस्तेर क भोज कयो; आरु प्रान्तों मा छुट्टी आपाड़्यो, आरु आपसी उदारता क योग्य इनाम वी वाट्यो। ");
INSERT INTO dhn_vpl VALUES ("ET2_19","018_2_19","EST","2","19","19","जोत्यार छल्‌ला दिसरी वार एकठी कोरी गय, ती मोर्दके राजभवन क फाटक मा बठलो हुतो, ओका टेमे राजा मोर्दक क आपसी शासन क चाकरीमा हिमी तव करला हता। ");
INSERT INTO dhn_vpl VALUES ("ET2_20","018_2_20","EST","2","20","20","एस्तेर न आपसी जाती आरु कुल क पतो नी आपी हुती, काहकी मोर्दके न ओको असी हुकुम आप्यो हुतो की नी बताड़े; आरु एस्तेर मोर्दके नु वार असी मानती हती जसी की ओका याँ आपसा पाळन-पुषन क टेम मानती हती। ");
INSERT INTO dhn_vpl VALUES ("ET2_21","018_2_21","EST","2","21","21","तेनु दाहड़ा मा जोत्यार मोर्दके राजा क राजभवन क फाटक मा बठ्या कोरतो हुतो, ती राजा क खोजे ज द्वारपाल वी हुता, उनामासी बिगताना आरु तेरेश नावोन दुय जना न राजा क्षयर्ष सी नाराज होईन उनाक मारनेन विचार कोर्या। ");
INSERT INTO dhn_vpl VALUES ("ET2_22","018_2_22","EST","2","22","22","यी वात मोर्दके क मालुन हय, आरु हुयो एस्तेर रानी क यी बात बताड़्यो, आरु एस्तेर न मोर्दके क नाव लिन राजा क वात कय आपी। ");
INSERT INTO dhn_vpl VALUES ("ET2_23","018_2_23","EST","2","23","23","ती जाँच पड़ताल होयने पोर यी वात खोरी निकळी आरु हुयो दुयोक झाड़ पोर लटकाय गुया, आरु यी वात राजान अगळ इतिहास नु किपात मा लिख्यो गुयो। ");
INSERT INTO dhn_vpl VALUES ("ET3_1","018_3_1","EST","3","1","1","एनी वातो क वाद राजा क्षयर्ष न अगागी हम्मदाता क पुर्य हामान क उचो पद आप्यो, आरु ओको महत्व आपीन ओका लिय ओका साथी हाकिमो क सिंहासनो सी उँचा सिंहासन ठहरायो। ");
INSERT INTO dhn_vpl VALUES ("ET3_2","018_3_2","EST","3","2","2","राजा क आखा कामकरन्या ज राजभवन क फाटक मा रया कोरता हुता, हुये हामान क सामने झुकीन दण्डवत् कोर्या कोरता हुता काहकी राजा न ओका वाराम असो हुकुम आप्यो हुतो; पुन मोर्दके नी ती झुकतो हुतो आरु नी दण्डवत् कोरतो हुतो। ");
INSERT INTO dhn_vpl VALUES ("ET3_3","018_3_3","EST","3","3","3","तोत्यार राजा क कामकरन्या ज राजभवन क फाटक मा रोया कोरता हुता, हुये मोर्दके सी पुछ्या, “तु राजा क हुकुम क काहा नी मानतो छे?” ");
INSERT INTO dhn_vpl VALUES ("ET3_4","018_3_4","EST","3","4","4","जोत्यार हुये ओको दाहड़ीन असोज कोहता रोया, आरु हुयो ओकी एक नी मान्यो, ती हुये यो देखिन की मोरजी सी मोर्दके नु यी वात चालसे की नी, हामान क बताड़ देदा; हुयो ओको हुयो बताड़ देदो की हांव यहुदी छे। ");
INSERT INTO dhn_vpl VALUES ("ET3_5","018_3_5","EST","3","5","5","जोत्यार हामान न देख्यो, कि मोर्दके नी झुकतो, आरु नी मेखे दण्डवत् कोरतो छे, ती हामान घनो रिसवायो। ");
INSERT INTO dhn_vpl VALUES ("ET3_6","018_3_6","EST","3","6","6","हुयो केवल मोर्दके पोर हाथ उठावनो आपसी इजुत सी कोम जान्यो। काहकी हुयो हामान क यी वात बताड़ देदा हुता, कि मोर्दके काहनी जातीन छे, एकालिय हामान न क्षयर्ष क साम्राज्य मा रोहनेवाळा आखा यहुदियो क वी मोर्दके नु जाती जानीन, विनाश कोरनेन विचार निकाळ्यो। ");
INSERT INTO dhn_vpl VALUES ("ET3_7","018_3_7","EST","3","7","7","राजा क्षयर्ष क बारे वरीस क नीसान नावोन पेहले मोहने मा, हामान न अदार नावोन बारे मोहना लगुन क एक-एक दाहड़े आरु एक-एक मोहने क लिय “पुर” अर्थात् चिट्ठी आपसा सामने नाखाड़्यो। ");
INSERT INTO dhn_vpl VALUES ("ET3_8","018_3_8","EST","3","8","8","हामान न राजा क्षयर्ष सी कयो, “तारा राज क आखा प्रान्तों मा रहनेवाळा देश-देश क लोगहन क विच मा तितर-बितर आरु छिटकी हयी एक जाति छे, जेरा कायदा आरु आखा लोगहन क कायदा सी ओलोग छे; आरु हुये राजा क कायदा पोर नी चालता, एकालिय ओको रहने देनो राजान फायदु नी छे। ");
INSERT INTO dhn_vpl VALUES ("ET3_9","018_3_9","EST","3","9","9","कदाम राजा क स्वीकार हय ती ओको नष्ट कोरनेन हुकुम लिख्यो जाय, आरु हांव राजा क भण्डारियो क हाथ मा राजभण्डार मा पुगाड़ने क लिय, दस हजार किक्कार चाँदी आपीस।” ");
INSERT INTO dhn_vpl VALUES ("ET3_10","018_3_10","EST","3","10","10","तोत्यार राजा न आपसी मुँदी आपसा हातोम सी निकाळीन अगागी हम्मदाता क पुर्या हामान क, ज यहुदियो क वेरी हुतो आप देदो। ");
INSERT INTO dhn_vpl VALUES ("ET3_11","018_3_11","EST","3","11","11","आरु राजा न हामान सी कयो, “हुयो चाँदी तुख आप्यो गयो छे, आरु हुये लोगहन वी, ताकि तु उनासी जसो तारो जीव चाहे तोसोज वेवहार कोरे।” ");
INSERT INTO dhn_vpl VALUES ("ET3_12","018_3_12","EST","3","12","12","ओळी तेरेसी पेहेल मोहनान तेरहवे दाहड़े क राजा क लेखक बुलाया गुया, आरु हामान नु हुकुम क ओनसारे राजा क आखा अधिपतियो, आरु आखा प्रान्तों क प्रधानो, आरु देश-देश क लोगहन क हाकिमो क लिय चिट्ठियाँ, एक-एक प्रान्त क आकड़ा मा, आरु एक-एक देश क लोगहन नु बुली मा राजा क्षयर्ष क नाव सी लिख्यी गय; आरु उनामा राजा नु मुँदीन छापु लागाड़्यु गयु। ");
INSERT INTO dhn_vpl VALUES ("ET3_13","018_3_13","EST","3","13","13","राज्य क आखा प्रान्तो मा एना आशय नु चिट्ठियाँ होर डाकियो क लारे मुकली गुय की एकुज दाहड़ा मा, अर्थात् अदार नावोन बारे मोहनान तेरवे दाहड़े क, काय जुवान, काय डाहला, काय बायरा, काय पुर्या, आखा यहुदी घात आरु नाश कोर्या जाय; आरु ओका धन सम्पत्ति लुट लेदो जाय। ");
INSERT INTO dhn_vpl VALUES ("ET3_14","018_3_14","EST","3","14","14","एना हुकुम क लेख नु नकलें आखा प्रान्तों मा खुली हुय मुकली गय की आखा देश क लोगहन उना दाहड़े क लिय तियार होय जाय। ");
INSERT INTO dhn_vpl VALUES ("ET3_15","018_3_15","EST","3","15","15","यो हुकुम शुशन गढ़ मा आप्यी गुय, आरु डाकिया राजान हुकुम सी छाटात निकळी गुया। राजा आरु हामान ते दाखमधु पीने बस गुया; पुन शुशन नगर मा घाबरोन फैल गुय। ");
INSERT INTO dhn_vpl VALUES ("ET4_1","018_4_1","EST","4","1","1","जोत्यार मोर्दके न जान लेदो कि काय-काय कोर्‌यो गुयो छे ती मोर्दके छिन्दरा फाड़, गन्टो पेहरीन, रुखड़ु नाखिन, नगर क विच जाईन उँचा आरु दु:ख भर्या बुल सी आयड़ने लाग्यो; ");
INSERT INTO dhn_vpl VALUES ("ET4_2","018_4_2","EST","4","2","2","आरु हुयो राजभवन क फाटक क सामने पुग्यो, पुन गन्टो पेहरलोत राजभवन क फाटक क धड़े ते कुदाक जानेन हुकुम नी हुती। ");
INSERT INTO dhn_vpl VALUES ("ET4_3","018_4_3","EST","4","3","3","एक-एक प्रान्त मा, जाँ-जाँ राजा नु हुकुम आरु कायदा पुग्या, होंया-होंया यहुदी मोटा विलाप कोरने आरु उपवास कोरने आरु रोड़ने कुटने लाग्या; पुन घणा सा गन्टा पेहरीन आरु रुखड़ु नाखीन पोड़्या रोया। ");
INSERT INTO dhn_vpl VALUES ("ET4_4","018_4_4","EST","4","4","4","एस्तेर रानी नु सहेलियो आरु खोजो न जाईन ओको बताड़ देदा, ती रानी शोक सी भराय गय; आरु मोर्दके क पास छिन्दरा मुकलीन यो कोयमुकली की गन्टो उतारीन एको पेहेर ले, पुन हुयो ओको नी लेदो। ");
INSERT INTO dhn_vpl VALUES ("ET4_5","018_4_5","EST","4","5","5","तोत्यार एस्तेर न राजा खोजो मा सी हताक क जेनाक राजा न ओका पास रहने क ठहरायो हुतो, बुलावीन हुकुम आपी, की मोर्दके क पास जाईन मालुन कोर ले, की काय वात छे एरो काय कारण छे। ");
INSERT INTO dhn_vpl VALUES ("ET4_6","018_4_6","EST","4","6","6","तोत्यार हताक नगर क उना चोक मा, ज राजभवन क फाटक क अगळ हुतो, मोर्दके क पास निकळी गुयो। ");
INSERT INTO dhn_vpl VALUES ("ET4_7","018_4_7","EST","4","7","7","मोर्दके न ओको आखो काहीन बताड़ देदो की म्हारे उपोर काय-काय वितलो छे, आरु हामान न यहुदियो क नाश कोरने नु हुकुम जोड़ने क लिय राजभण्डार मा कोरता चाँदी भोर देने क बुल आपलो छे, यो वी वारु-वारु बताड़ देदो। ");
INSERT INTO dhn_vpl VALUES ("ET4_8","018_4_8","EST","4","8","8","ओळी यहुदियो क विनाश करने क ज हुकुम शुशन मा आपी गय हुती, ओकी एक नकल वी हुयो हताक क हाथ मा, एस्तेर क देखाड़ने क लिय, आरु हुयो आखो हाल बताड़ने, आरु यो हुकुम आपने क कयो, की धड़े राजा क पास जाईन आपसा लोगहन क लिय गिड़गिड़ावीन विनता कोरे। ");
INSERT INTO dhn_vpl VALUES ("ET4_9","018_4_9","EST","4","9","9","तोत्यार हताक न एस्तेर क पास जाईन मोर्दके नु वात कोय सोमवाड़्यो। ");
INSERT INTO dhn_vpl VALUES ("ET4_10","018_4_10","EST","4","10","10","तोत्यार एस्तेर न हताक क मोर्दके सी यो कोहने नु हुकुम आपी, ");
INSERT INTO dhn_vpl VALUES ("ET4_11","018_4_11","EST","4","11","11","“राजा क आखा कामकरन्या, पुन राजा न प्रान्तो क आखा लोगहन क वी मालुम छे, की काय मानुस काय बायरा, काय कुय नी होयम ज हुकुम विगुर पावे धड़े आँगना मा राजा क पास जासे ओको मार नाखनेन हुकुम छे; केवल जेरे भेनी राजा सोना क राजडोन बड़ावे चोंत वाचे छे। पुन हांव हेमी तीस दाहड़ा सी राजा क पास नी बुलावी गयी छे।” ");
INSERT INTO dhn_vpl VALUES ("ET4_12","018_4_12","EST","4","12","12","एस्तेर नु यी वाते मोर्दके क सोमळाय गय। ");
INSERT INTO dhn_vpl VALUES ("ET4_13","018_4_13","EST","4","13","13","तोत्यार मोर्दके न एस्तेर क पास यो कोय मुकल्यो, “तु मनम यो विचार नी कोर, की हांवज राजभवन मा रोहनेन कारण आरु आखा यहुदियो मा सी वाचली रोहीस। ");
INSERT INTO dhn_vpl VALUES ("ET4_14","018_4_14","EST","4","14","14","काहकी ज तु एने टेमे हुगी रोही, ती आरु कुय नी कुदाक उपाय सी यहुदियो क छुटकारो आरु छुटकारो होय जासे, पुन तु आपसा बास क घराना भेळ नाश होयसे। काय जाने तुख असोज काठा टेम क लिय राजपद मिळ गयो होय?” ");
INSERT INTO dhn_vpl VALUES ("ET4_15","018_4_15","EST","4","15","15","तोत्यार एस्तेर न मोर्दके क पास यो कय मुकली, ");
INSERT INTO dhn_vpl VALUES ("ET4_16","018_4_16","EST","4","16","16","“तु जाईन शुशन क आखा यहुदियो क एकठा कोर, आरु तुमु आखा मिळीन म्हारे निमित्त उपवास करु, तीन दाहड़ा-तीन नी ते काहीन खाजु, आरु नी काहिन पुजु। आरु हांव वी आपसी सहेलियो भेळ तेनेत रीते उपवास कोरीस। आरु असीज दशा मा हांव कायदा क विरुद्ध राजा क पास धड़े जाईस; आरु कदाम नाश होय गुय ती होय गय।” ");
INSERT INTO dhn_vpl VALUES ("ET4_17","018_4_17","EST","4","17","17","ती मोर्दके चाली गुलयो आरु एस्तेर क हुकुम नु ओनसारेज हुयो कर्‌यो। ");
INSERT INTO dhn_vpl VALUES ("ET5_1","018_5_1","EST","5","1","1","तीसरे दाहड़े एस्तेर आपसा राजकीय छिन्दरा पेहरीन राजभवन क धड़े आँगना मा जाईन, राजभवन क अगळ जाईन, राजभवन क अगळ उबी हुय गय। राजा ते राजभवन मा राजगाद्दी पोर भवन क झपलान सामने विराजमान हुतो; ");
INSERT INTO dhn_vpl VALUES ("ET5_2","018_5_2","EST","5","2","2","आरु जोत्यार राजा न एस्तेर रानी क आँगना मा उबी हयली देख्यो, तोत्यार उनासी प्रसन्न होईन सोना क राजडोन ज ओका हाथ मा हुतो ओका भेनी बडायो। ती एस्तेर न धड़े जाईन राजडोन क नोक छिमी। ");
INSERT INTO dhn_vpl VALUES ("ET5_3","018_5_3","EST","5","3","3","ती राजा न उनासी पुछ्यो, “हे एस्तेर रानी, तुख काय चाहजे? आरु तु काय माँगती छे? माँग आरु तुख आदो राज लगुन आप्यो जासे।” ");
INSERT INTO dhn_vpl VALUES ("ET5_4","018_5_4","EST","5","4","4","एस्तेर न कव्यी, “कदाम राजा क स्वीकार होय, ती आज हामान क भेळ लीन उको भोज मा आवे, ज हांव राजा क लिय तियार कोर्री छे।” ");
INSERT INTO dhn_vpl VALUES ("ET5_5","018_5_5","EST","5","5","5","तोत्यार राजा न हुकुम आप्यो, “हामान क छाटा ली आवु, कि एस्तेर क निमंत्रण ग्रहण कोर्‌यो जाय।” अत: राजा आरु हामान एस्तेर क तीयार कोरला भोज मा आवे। ");
INSERT INTO dhn_vpl VALUES ("ET5_6","018_5_6","EST","5","6","6","भोज क टेम जोत्यार दाखमधु पियो जातो हुतो, ती राजा न एस्तेर सी कयो, “तारो काय निवेदन छे? चो पुरो कोर्‌यो जासे। आरु तु काय माँगती छे? माँग, आरु आदो राज लगुन तुख आप्यो जासे।” (मर. 6:23) ");
INSERT INTO dhn_vpl VALUES ("ET5_7","018_5_7","EST","5","7","7","एस्तेर न जपाप आपी, “म्हारो निवेदन आरु जो हांव माँगती छे, ");
INSERT INTO dhn_vpl VALUES ("ET5_8","018_5_8","EST","5","8","8","कि कदाम राजा म्हारे पोर प्रसन्न छे आरु म्हारा निवेदन सोमळनो आरु जो मांग हांव माँगो चो आपनो राजा क स्वीकार होय, ती राजा आरु हामान कल उना भोज मा आवे जेनाक हांव ओका लिय कोरीस, आरु कल हांव राजा क एना बुल क ओनसारे कोरीस।” ");
INSERT INTO dhn_vpl VALUES ("ET5_9","018_5_9","EST","5","9","9","उना दाहड़े हामान खुश आरु मोन मा प्रसन्न होईन खोयड़े गुयो। पुन जोत्यार हुयो मोर्दके क राजभवन क फाटक मा देख्यो, की हुयो ओका सामने नी ते उबो हुयो, आरु नी भिहियु हुयो, ती हुयो मोर्दके क विरुद्ध रीस सी भोराय गुयो। ");
INSERT INTO dhn_vpl VALUES ("ET5_10","018_5_10","EST","5","10","10","ती वी हामान आपसा क रुकिन आपसे घर गुयो; आरु आपसा दुसतीदार आरु आपसी बायर जेरेश क बुलवाय मुकल्यो। ");
INSERT INTO dhn_vpl VALUES ("ET5_11","018_5_11","EST","5","11","11","तोत्यार हामान न, हुयो आपसा धन क ठाट बाट, आरु आपसा बाळ-बोच्‌चा क वोदती आरु राजा न ओको कसो-कसो वदाड़्यो, आरु आखा हाकिमो आरु आपसा आखा कामकरन्या सु उँचो पद आप्यो हुतो, एना आखा क वाराम बताड़्यो। ");
INSERT INTO dhn_vpl VALUES ("ET5_12","018_5_12","EST","5","12","12","हामान न यो वी कयो, “एस्तेर रानी न वी मेखे छुड़ आरु कुदाक क राजा क भेळ, आपसा कोरला हुया भोज मा आवने नी देदी; आरु कल क लिय वी राजा क भेळ हुयी मेखेक नेवतो आपली छे। ");
INSERT INTO dhn_vpl VALUES ("ET5_13","018_5_13","EST","5","13","13","ती वी जोत्यार-जोत्यार मेखे हुयी यहुदी मोर्दके राजभवन क फाटक मा बोठलो देखा पोड़ेओ छे, ती-ती यो आखो म्हारी निंगा मा असोज लागतो छे।” ");
INSERT INTO dhn_vpl VALUES ("ET5_14","018_5_14","EST","5","14","14","ओकी लाड़ी जेरेश आरु ओका आखा दुसतीदार न उनासी कोया, “पचास हाथ उचो फांसी क एक खम्भो बोनायो जाय, आरु सोंदारे क राजा सी कोहजो, की उना पोर मोर्दके लटकाड़ देदो जाय; तो राका लीन भेळ खुशी सी भोज मा जाजो।” एनी वात सी प्रसन्न होईन हामान न तसोज फांसी क एक खाम्बो बोनवाड़्यो। ");
INSERT INTO dhn_vpl VALUES ("ET6_1","018_6_1","EST","6","1","1","तेने राती राजा क नींद नी आवी, एकालिय ओका हुकुम सी इतिहास नु किपात लावी गय, आरु भनीन राजा क सोमवाड़्यो गयो। ");
INSERT INTO dhn_vpl VALUES ("ET6_2","018_6_2","EST","6","2","2","ओकामा यो लिखलो हुओ मिळ्यो, कि जोत्यार राजा क्षयर्ष क हाकिम क द्वारपाल वी हुतो, उनामा सी बिगताना आरु तेरेश नावोन दुय जना न उना पोर हाथ चालाड़नेन विचार कोर्या हुता उना मोर्दके न प्रगट कोर्लो हुतो। ");
INSERT INTO dhn_vpl VALUES ("ET6_3","018_6_3","EST","6","3","3","तोत्यार राजा न पुछ्यो, “एका बोदले मोर्दके नु काय प्रतिष्ठा आरु बड़ाई कर्‌यो गयो?” राजा क जे सेवक ओकी चाखरी कोर रोया हुता, हुये ओको जपाप आप्या, “ओका लिय काय वी नी कोर्‌यो गुयो।” ");
INSERT INTO dhn_vpl VALUES ("ET6_4","018_6_4","EST","6","4","4","राजा न पुछ्यो, “आँगना मा कुन छे?” तेने टेमे हामान राजा क भवन सी खोयड़े आँगना मा एना विचार सी आयो हुतो, की ज खाम्बो हुयो मोर्दके क लिय तियार कोरायो हुतो, उना पोर ओको लटकाय देनेन वात राजा सी कोरे। ");
INSERT INTO dhn_vpl VALUES ("ET6_5","018_6_5","EST","6","5","5","तोत्यार राजा क चाख्र्या न उनासी कोया, “आँगना मा ते हामान उबो छे।” राजा न कयो, “ओको धड़े बुलाय लावु।” ");
INSERT INTO dhn_vpl VALUES ("ET6_6","018_6_6","EST","6","6","6","जोत्यार हामान धड़े आयो, तोत्यार राजा न उनासी पुछ्यो, “जेना मानुस नु प्रतिष्ठा राजा कोरनो चाहतो हय ती ओका लिय काय कोरनो वारु होयसे?” हामान न यो सुचीन, की म्हारे सी जागा राजा कुदाक प्रतिष्ठा कोरनो चाहतो हसे? ");
INSERT INTO dhn_vpl VALUES ("ET6_7","018_6_7","EST","6","7","7","राजा क हामान जपाप आप्यो “जेना मानुस क प्रतिष्ठा राजा कोरनो चाहे, ");
INSERT INTO dhn_vpl VALUES ("ET6_8","018_6_8","EST","6","8","8","ओका लिय राजकीय पुतल्या लाया जाय, ज राजा पेहरतो छे, आरु एक घुल्लो वी, जेना पोर राजा सवार होयतो होय, आरु ओका मुनका पोर ज राजकीय मुकुट मेक्यो जातो छे हुयो वी लायो जाय। ");
INSERT INTO dhn_vpl VALUES ("ET6_9","018_6_9","EST","6","9","9","ओळी चो पुतल्या, आरु हुयो घुल्लो राजा क कुदा मोटा हाकिम क सोवंप्यो जाय, आरु जेरी प्रतिष्ठा राजा कोरनो चाहतो होय, ओको हुये पुतल्या पेहराया जाय, आरु उना घुल्‌ला पोर सवार कोरीन, नगर क चोक मा ओको फिरायो जाय; आरु ओका अगळ-अगळ यो पोरचार कोर्‌यो जाय, जेरी प्रतिष्ठा राजा कोरनो चाहतो छे, ओका साथ असोज कोर्‌यो जासे।” ");
INSERT INTO dhn_vpl VALUES ("ET6_10","018_6_10","EST","6","10","10","राजा न हामान सी कयो, “उतवाळ कोरीन आपसा कोहनेन ओनसारे तेनु पुतल्या आरु तेना घुल्‌ला क लि, उना यहुदी मोर्दके सी ज राजभवन क फाटक मा बोठ्‌या कोरतो छे, तसोज कोर। जसो तुन कयो छे उनामा काय वी कोमी होयनो नी जुवे।” ");
INSERT INTO dhn_vpl VALUES ("ET6_11","018_6_11","EST","6","11","11","तोत्यार हामान न उना पुतल्या, आरु घुल्‌ला क लिन, मोर्दके क पेहरायो, आरु उना घुल्‌ला पोर चड़ावीन, नगर क चोक मा एने रिते आयड़तो हुयो फिरयो, “जेरी प्रतिष्ठा राजा कोरनो चाहतो छे ओका साथ असोज कोर्‌यो जासे।” ");
INSERT INTO dhn_vpl VALUES ("ET6_12","018_6_12","EST","6","12","12","ती मोर्दके ते राजभवन क फाटक मा लौटी गुयो पुन हामान शोक कोरतो जाईन आरु मुनको ढाँकीन झट आपसे घर क गुयो। ");
INSERT INTO dhn_vpl VALUES ("ET6_13","018_6_13","EST","6","13","13","हामान न आपसी घरवाळी जेरेश आरु आपसा आखा दुसतीदार सी आखो काहीन ज उना पोर वित्यो हुतो कयो। ती ओका ओकोलवाळा दुसरतीदार आरु ओकी घरवाळी जेरेश न उनासी कव्या, “मोर्दके जेनाक तु नेचो देखाड़नो चाहतो छे, कदाम हुयो यहुदियो क ओवलियाद मा क छे, ती तु उना पोर जीत नी होयने पावसे उनासी पुरी रीती नेचो होय जाईस।” ");
INSERT INTO dhn_vpl VALUES ("ET6_14","018_6_14","EST","6","14","14","हुये उनासी वातेत कोरता हुता, की राजा क खोजे आवीन हामान क एस्तेर क कोरला भोज मा उतळाव सी बुलाय ली गुया। ");
INSERT INTO dhn_vpl VALUES ("ET7_1","018_7_1","EST","7","1","1","अत: राजा आरु हामान एस्तेर रानी नु भोज मा आय गुयो। ");
INSERT INTO dhn_vpl VALUES ("ET7_2","018_7_2","EST","7","2","2","आरु राजा न दिसरे दाहड़े दाखमधु पीता-पीता एस्तेर सी ओळी पुछ्यो, “हे एस्तेर रानी! तारो काय निवेदन छे? चो पुरयो कोर्‌यो जासे। आरु तु काय माँगती छे? माँग, आरु आदो राज लगुन तुख आप्यो जासे।” (मर. 6:23) ");
INSERT INTO dhn_vpl VALUES ("ET7_3","018_7_3","EST","7","3","3","एस्तेर रानी न जपाप आपी, “हे राजा! कदाम तु म्हारे पोर प्रसन्न छे, आरु राजा क यो स्वीकार होय, ती म्हारो निवेदन सी मेखे, आरु म्हारे माँगने सी म्हारा लोगहन क जीवोनदान मिळे। ");
INSERT INTO dhn_vpl VALUES ("ET7_4","018_7_4","EST","7","4","4","काहकी हांव आरु म्हारि जाति क लोगहन वेचाय गयला छे, आरु हामु आखा मार्या आरु नाश कर्या जानेवाळा छे। कदाम हामु केवल दास-दासी होय जाने क लिय वेचाय जाता, ती हांव हुगी रयती; चाहे तेनी दशा मा वी हुये विरोधी राजा नु हानि भर नी सकतो।” ");
INSERT INTO dhn_vpl VALUES ("ET7_5","018_7_5","EST","7","5","5","तोत्यार राजा क्षयर्ष न एस्तेर रानी सी पुछ्यो, “चो कुण छे? आरु काँ छे जेरी असो करनेन हिमोत कोरलो छे?” ");
INSERT INTO dhn_vpl VALUES ("ET7_6","018_7_6","EST","7","6","6","एस्तेर न जपाप आपी, “हुयो विरोधी आरु वेरु यो दुष्ट हामान छे।” तोत्यार हामान राजा-रानी क अगळ बिह गुयो। ");
INSERT INTO dhn_vpl VALUES ("ET7_7","018_7_7","EST","7","7","7","राजा रिस सी भोराय गुयो, दाखमधु पीने सी उठीन, राजभवन क वाड़ी मा निकळी गुयो; आरु हामान यो देखीन की राजा न म्हारी हानी ठान्यो हसे, एस्तेर रानी सी जीवोनदान माँगने क उबो हुयो। ");
INSERT INTO dhn_vpl VALUES ("ET7_8","018_7_8","EST","7","8","8","जोत्यार राजा राजभवन क वाड़ी सी दाखमधु पीने सी जागा मा लौटी आयो तोत्यार काय देख्यो, कि हामान उनी चोकी पोर जेरे पोर एस्तेर बठी छे झुक रयो छे; आरु राजा न कयो, “काय यो घरुज मा म्हारे सामनेज रानी सी बरबस करनो चाहतो छे?” राजा क मुख सी यो बुल निकळ्यो ही हुतो, की सेवको न हामान क मुय ढाँप देदा। ");
INSERT INTO dhn_vpl VALUES ("ET7_9","018_7_9","EST","7","9","9","तोत्यार राजा क सामने हजुर रहनेवाळा खोजो मा सी हर्बोना नावोन एक न राजा सी कयो, “हामान क याँ पचास हाथ उचो फाँसी क एक खाम्बो उबो छे, ज हुयो मोर्दके क लिय बनवाड़्यो छे, ज राजान हित नु वात कर्‌यो हुतो।” राजा न कयो, “ओको ओकाज पोर लटकाय देवु।” ");
INSERT INTO dhn_vpl VALUES ("ET7_10","018_7_10","EST","7","10","10","तोत्यार हामान ओकाज खाम्बा पोर ज हुयो मोर्दके क लिय तियार कोरायो हुतो, लटकाय देदो गुयो। एना पोर राजा नु रीस सेवाय गय। ");
INSERT INTO dhn_vpl VALUES ("ET8_1","018_8_1","EST","8","1","1","तेने दाहड़े राजा क्षयर्ष न यहुदियो क विरोधी हामान क घरबार एस्तेर रानी क आप देदो। मोर्दके राजा क सामने आयो, काहकी एस्तेर न राजा क बताड़ी हुती, कि ओकासी ओको काय नातो हुतो ");
INSERT INTO dhn_vpl VALUES ("ET8_2","018_8_2","EST","8","2","2","तोत्यार राजा न आपसी ची मुंदी ज हुयो हामान सी ली लेदो हुतो, निकाळीन, मोर्दके क आप देदो। एस्तेर न मोर्दके क हामान क घरबार पोर होकदार्‌यो नेवाड़ कोर देदो। ");
INSERT INTO dhn_vpl VALUES ("ET8_3","018_8_3","EST","8","3","3","ओळतेन एस्तेर दिसरी वार राजा सी कवी; आरु ओका पाय पोर पोड़, आसा उहाविड़न उनासी गिड़गिड़ावीन विनता कोर, की अगागी ओवलियाद क हामान नु बुराई आरु यहुदियो क हानि नु ओको विचार निष्फळ कोर्‌यो जाय। ");
INSERT INTO dhn_vpl VALUES ("ET8_4","018_8_4","EST","8","4","4","तोत्यार राजा न एस्तेर भेनी सोनान राजडोन बोड़ायो, तोत्यार एस्तेर उठीन राजान सामने उबी हय; आरु कोहने लागी। ");
INSERT INTO dhn_vpl VALUES ("ET8_5","018_8_5","EST","8","5","5","“कदाम राजा क स्वीकार होय आरु हुयो म्हारेसी प्रसन्न छे आरु यी वार ओको वारु जान पोड़े, आरु हांव वी ओको वारु लागती होय, ती ज चिट्ठियाँ हम्मदाता अगागी क पुर्य हामान न राजा क आखा प्रान्तो क यहुदियो क नाश करने नु विचार कोरीन लिखाड़्यो हुतो, ओको बदलने क लिय लिख्यो जाय। ");
INSERT INTO dhn_vpl VALUES ("ET8_6","018_8_6","EST","8","6","6","काहकी हांव आपसी जाति क लोगहन पोर पड़नेवाळी उनी पिड़ा क काहने रीते सी देख सकीस? आरु हांव आपसा भास्यो क विनाश क कोसी देख सोकीस?” ");
INSERT INTO dhn_vpl VALUES ("ET8_7","018_8_7","EST","8","7","7","तोत्यार राजा क्षयर्ष न एस्तेर रानी सी आरु मोर्दके यहुदी सी कयो, “हांव हामान क घरबार ते एस्तेर क आप चुक्यो छे, आरु हुयो फांसी क खाम्बा पोर लोटकाय देदो गुयो छे, एकालिय की हुयो यहुदियो पोर हाथ उठायो हुतो। ");
INSERT INTO dhn_vpl VALUES ("ET8_8","018_8_8","EST","8","8","8","अत: तुमु आपनी समझ क ओनसारे राजा क नाव सी यहुदियो क नाव पोर लिखु, आरु राजा नु मुंदी क छाप वी लागाड़ु; काहकी ज चिट्ठी राजा क नाव सी लिखी जाय, आरु ओका पोर ओकी मुंदीन छापो लागाड्यो जाय, ओको काय वी बदल नी सोकतो।” ");
INSERT INTO dhn_vpl VALUES ("ET8_9","018_8_9","EST","8","9","9","तेने टेमे मोतलोब सीवान नावोन तीसरा मोहना क तेवीसवे दाहड़े क राजा क लेखक बुलाया गुया आरु जिना-जिनाक वातोन हुकुम मोर्दके न ओको आप्यो हुतो, ओको यहुदियो आरु अधिपतियो आरु भारत देश सी लीन कुश लगुन, ज एक सोव सत्ताईस प्रान्त छे, उना आखा क अधिपतियो आरु हाकिमो क एक-एक प्रान्त क आकड़ा मा आरु एक-एक देश क लोगहन नु बुली मा, आरु यहुदियो क उना आकड़ा आरु बुली मा लिखी गय। ");
INSERT INTO dhn_vpl VALUES ("ET8_10","018_8_10","EST","8","10","10","मोर्दके न राजा क्षयर्ष क नाव सी चिट्ठियाँ लिखाड़ीन, आरु उना पोर राजान मुंदीन छापो लागाड़ीन, छाटा चालनेवळी सरकारी घुल्‌ला, चचर गोदड़ा आरु पोर सवार करने वाळा क हाथ मुकली देदो। ");
INSERT INTO dhn_vpl VALUES ("ET8_11","018_8_11","EST","8","11","11","इनु चिट्ठियो मा आखा नगरों क यहुदियो क राजा क भेनी सी हुकुम आप्यो गुयो, की हुये एकठा होये आरु आपसा-आपसा जीव वाचाड़ने क लिय तियार होईन, जेनी जाति एने प्रान्त क लोगहन अन्यान कोरीन ओको एने ओका बायरा आरु बाळ-बोच्‌चा क पीड़ा आपनो चाहे, ओको घात आरु नाश कोरे, आरु ओकी धन सम्पत्ति लुट लेये। ");
INSERT INTO dhn_vpl VALUES ("ET8_12","018_8_12","EST","8","12","12","आरु यो राजा क्षयर्ष क आखा प्रान्तों मा एकुज दाहड़े मा कोर्‌यो जाय, अर्थात् अदार नावोन बारवे मोहनेन तेरवे दाहड़े क। ");
INSERT INTO dhn_vpl VALUES ("ET8_13","018_8_13","EST","8","13","13","एना हुकुम क लेख नु नकलें, आखा प्रान्तो मा आखा देशों क लोगहन क पास उघाड़ली हयीन मुकल्या जासे; इनासी यहुदी उना दाहड़े आपसा वेरी सी पलटो लेने तियार रोहे। ");
INSERT INTO dhn_vpl VALUES ("ET8_14","018_8_14","EST","8","14","14","अत: हरकारे वेग चलनेवाळा सरकारी घुल्‌ला पोर सवार होईन, राजा नु हुकुम सी उतवाळ कोरीन तावनी चाली गुया, आरु यो हुकुम शुशन राजगढ़ मा आप्यो गयो हुतो। ");
INSERT INTO dhn_vpl VALUES ("ET8_15","018_8_15","EST","8","15","15","तोत्यार मोर्दके निळा आरु श्वेत रंगोन राजकीय पुतल्या पेहरलो आरु मुनका पोर सोनान मोटो मुकुट मुकलो हुतो आरु सुळावो सन आरु बैंगनी रंगोन बागो पेहरलो हुतो, राजा क अगळ सी निकळ्यो, आरु शुशन नगर क लोगहन खुशी नु मारे ललकार उठ्‌या। ");
INSERT INTO dhn_vpl VALUES ("ET8_16","018_8_16","EST","8","16","16","आरु यहुदियो क खुशी आरु हर्ष हुयो आरु ओकी मोटी प्रतिष्ठा हयी। ");
INSERT INTO dhn_vpl VALUES ("ET8_17","018_8_17","EST","8","17","17","आरु जेना-जेना राज, आरु यहुदयो क खुशी आरु हर्ष हुयो, आरु ओको भोज कोरीन उना दाहड़े क खुशी क दाहड़ो मान्या। आरु उना देश क लोगहन मा सी बेसका यहुदी बोन गुया, काहकी ओका मोन मा यहुदियो क बिक सोमाय गुयो हुतो। ");
INSERT INTO dhn_vpl VALUES ("ET9_1","018_9_1","EST","9","1","1","अदार नावोन बारवे मोहनेन तेरवे दाहड़े क, जेने दाहड़े राजा नु हुकुम आरु कायदो पुरो हयने क हुतो, आरु यहुदियो क वेरी उना पोर प्रबल होयनेन आशा राखता हुता, पुन एरा विपरीत यहुदी आपसा वेरी पोर प्रबल हुया; उना दाहड़े, ");
INSERT INTO dhn_vpl VALUES ("ET9_2","018_9_2","EST","9","2","2","यहुदी लोगहन राजा क्षयर्ष क आखा प्रान्तो मा आपसा-आपसा नगर मा एकठा हुया, की ज ओको हानि कोरने क यत्न कोरे, उना पोर हाथ चालाड़े। कुय ओको सामनो नी कोर सक्यो, काहकी ओको बिक देश-देश क आखा लोगहन क मन मा समाय गुयो हुतो। ");
INSERT INTO dhn_vpl VALUES ("ET9_3","018_9_3","EST","9","3","3","पुन प्रान्तो क आखा हाकिमो आरु अधिपतियो आरु मुखिया आरु राजा क कामकरन्या न यहुदियो नु सहायता कोर्या, काहकी ओका मोन मा मोर्दके क बिक समाय गुयो हुतो। ");
INSERT INTO dhn_vpl VALUES ("ET9_4","018_9_4","EST","9","4","4","मोर्दके ते राजा क याँ घनो प्रतिष्ठित हुतो, आरु ओकी किर्ति आखा प्रान्तो मा फेल गुय; पुन उना मानुस मोर्दके नु महिमा वदरी गुय। ");
INSERT INTO dhn_vpl VALUES ("ET9_5","018_9_5","EST","9","5","5","अत: यहुदियो न आपसा आखा वेरी क तलवार सी मारीन आरु घात कोरीन नाश कोर नाख्या, आरु आपसा वेरी सी आपनी मोरजी ओनसारे बर्ताव कोर्या। ");
INSERT INTO dhn_vpl VALUES ("ET9_6","018_9_6","EST","9","6","6","शुशन राजगढ़ मा यहुदियो न पाच सोव मानसो क घात कोरीन नाश कोर्या। ");
INSERT INTO dhn_vpl VALUES ("ET9_7","018_9_7","EST","9","7","7","हुये पर्शन्दाता, दल्पोन, अस्पाता, ");
INSERT INTO dhn_vpl VALUES ("ET9_8","018_9_8","EST","9","8","8","पोराता, अदल्या, अरीदाता, ");
INSERT INTO dhn_vpl VALUES ("ET9_9","018_9_9","EST","9","9","9","पर्मशता, अरीसे, अरीदे आरु वेजाता, ");
INSERT INTO dhn_vpl VALUES ("ET9_10","018_9_10","EST","9","10","10","अर्थात् हम्मदाता क पुर्य यहुदियो क वेरी हामान क दसु पुर्‌यो क वी घात कोर्या; पुन ओको धन क नी लुट्या। ");
INSERT INTO dhn_vpl VALUES ("ET9_11","018_9_11","EST","9","11","11","तेने दाहड़े शुशन राजगढ़ मा घात कोर्या हुया नु गिनती राजा क सोमवाड़्या गुया। ");
INSERT INTO dhn_vpl VALUES ("ET9_12","018_9_12","EST","9","12","12","तोत्यार राजा न एस्तेर रानी सी कयो, “यहुदियो न शुशन राजगढ़ज मा पाच सोव मानसो आरु हामान क दसु पुर्या क वी घात कोरीन नाश कोर्या छे; अळी राज क दिसरा प्रान्तो मा हुये नी जाने काय-काय कोर्या होसे! हेमी एरेसी जादा तारो निवेदन काय छे? हुयो वी पुरो कर्‌यो जासे। आरु तु काय माँगती छे? हुये वी तुसे आप्यो जासे।” ");
INSERT INTO dhn_vpl VALUES ("ET9_13","018_9_13","EST","9","13","13","एस्तेर न कयो, “कदाम राजा क स्वीकार होय ती शुशन क यहुदियो क आज क समान कल वी करने क हुकुम आप्यो जाय, आरु हामान क दसु पुर्या फांसी क खम्बो पोर लटकायो जाय।” ");
INSERT INTO dhn_vpl VALUES ("ET9_14","018_9_14","EST","9","14","14","राजा न कयो, “असो कर्‌यो जाय,” यो हुकुम शुशन मा आप्यो गुयो, आरु हामान क दसु पुर्या लटकाय गुया। ");
INSERT INTO dhn_vpl VALUES ("ET9_15","018_9_15","EST","9","15","15","शुशन क यहुदियो न अदार महीना क चोदवे दाहड़े क वी एकठा होईन शुशन मा तीन सोव मानसो क घात कोर्या, पुन धोन नी लुट्या। ");
INSERT INTO dhn_vpl VALUES ("ET9_16","018_9_16","EST","9","16","16","राज क दिसरा प्रान्तों क यहुदी एकठा होईन आपसा-आपसा जीव वाचाड़ने क लिय उबा हुया, आरु आपसा वेरी मा सी तीन वीस ने पोंद्रे हजार मानसो क घात कोरीन आपसा वेरी सी आराम जड़्यो; पुन धोन नी लुट्या। ");
INSERT INTO dhn_vpl VALUES ("ET9_17","018_9_17","EST","9","17","17","यो अदार मोहना क तेरवे दाहड़े क कोर्‌यो गुयो, आरु चोदवे दाहड़े क हुये आराम करीन भोज कर्या आरु खुशी क दाहड़ु ठहराया। ");
INSERT INTO dhn_vpl VALUES ("ET9_18","018_9_18","EST","9","18","18","पुन शुशन क यहुदी अदार मोहनान तेरवे दाहड़े क, आरु तेनेत मोहनेन चोदवे दाहड़े क एकठा हुया, आरु तेने मोहनेन पोंद्रवे दाहड़े क हुये आराम करीन भोज क आरु खुशी क दाहड़ो ठहराया। ");
INSERT INTO dhn_vpl VALUES ("ET9_19","018_9_19","EST","9","19","19","एने कारण देहाती यहुदी ज विगुर सोहोरपनाह नु नगर मा रोहता छे, हुये अदार मोहनान चोदवे दाहड़े क खुशी आरु भोज आरु खुशी आरु आपसा मा भोजन सोमान मुकळने क दाहड़ो नेवाड़ करीन माने छे। ");
INSERT INTO dhn_vpl VALUES ("ET9_20","018_9_20","EST","9","20","20","एनी वातो क वाराम लिखीन, मोर्दके न राजा क्षयर्ष क आखा प्रान्तो मा, काय धड़े काय छेटा रोहनेवाळा आखा यहुदियो क पास चिट्ठियाँ मुकल्या, ");
INSERT INTO dhn_vpl VALUES ("ET9_21","018_9_21","EST","9","21","21","आरु यो हुकुम आप्या, की अदार मोहनान चोदवे आरु तेनेत मोहनेन पोंद्रवे दाहड़े क होर वरीस मनायो जासे। ");
INSERT INTO dhn_vpl VALUES ("ET9_22","018_9_22","EST","9","22","22","जेरेम यहुदियो न आपसा वेरी सी आराम जड़्यो, आरु यो मोहनो जेरेम शोक खुशी आरु विलाप खुश मा बदली गयो; ओका जेवनार आरु खुशी आरु एक दिसरा क पास भोजन चिजे मुकळने आरु कंगालो क दान आपने क दाहड़े माने। ");
INSERT INTO dhn_vpl VALUES ("ET9_23","018_9_23","EST","9","23","23","अत: यहुदियो न जोसा सुरु कोर्या हुता, आरु जसो मोर्दके न उको लिख्यो, तसोज करने क पाको कोर लेदो। ");
INSERT INTO dhn_vpl VALUES ("ET9_24","018_9_24","EST","9","24","24","काहकी हम्मदाता अगागी क पुर्य हामान ज आखा यहुदियो क विरोधी हुतो, हुयो यहुदियो क नाश करनेन वीचार कोर्‌यो कि, आरु ओको मिटाय नाखने आरु नाश करने क लिय पुर अर्थात् चिट्ठी नाखाड़्यो हुतो। ");
INSERT INTO dhn_vpl VALUES ("ET9_25","018_9_25","EST","9","25","25","पुन जोत्यार राजा न यो जान लेदा, तोत्यार हुयो हुकुम आप्यो आरु चिट्ठि लिखवाड़्यो की ज दुष्ट विचार हामान न यहुदियो क विरुद्ध कोर्‌यो हुतो चो ओकाज मुनका पोर पलट आवे, तोत्यार हुयो आरु ओका पुर्या फांसी क खाम्बा पोर लटकाड़यो गुयो। ");
INSERT INTO dhn_vpl VALUES ("ET9_26","018_9_26","EST","9","26","26","एने कारण उना दाहड़ा क नाव पुन बुल सी पुरीम राख्यो गुयो। एनी चिट्ठी क आखी वातो क कारण, आरु ज काहि हुये एना वाराम देख्या आरु ज काहि उना पोर वितलो हुतो, ओका कारण वी ");
INSERT INTO dhn_vpl VALUES ("ET9_27","018_9_27","EST","9","27","27","यहुदियो न आपसा-आपसा लिय आरु आपसी ओवलियाद क लिय, आरु उना आखा क लिय वी ज उनामा मिळ गुया हुता यो पाक्‌को विचार कोर्या, की उना लेख क ओनसारे होर वरीस ओका टाकला टेम मा हुये ये दुय दाहड़ा माने। ");
INSERT INTO dhn_vpl VALUES ("ET9_28","018_9_28","EST","9","28","28","आरु पीढ़ी-पीढ़ी, कुल-कुल, प्रान्त-प्रान्त, नगर-नगर मा ये दाहड़ा फोम कोरे आरु मान्या जासे। आरु पुरीम नावोन दाहड़े यहुदियो मा कोदी नी मिटसे आरु ओको फोम ओका ओवलियाद सी जातो नी रोहसे। ");
INSERT INTO dhn_vpl VALUES ("ET9_29","018_9_29","EST","9","29","29","ओळी अबीहेल नु पुराय एस्तेर रानी, आरु मोर्दके यहुदी न, पुरीम क वाराम यी दुसरी चिट्ठी मोटा होक क भेळ लीख्या। ");
INSERT INTO dhn_vpl VALUES ("ET9_30","018_9_30","EST","9","30","30","एरी चिट्ठि मोर्दके न क्षयर्ष क राज क, एक सोव सत्ताईस प्रान्तों क आखा यहुदियो क पास शान्ति आपनेवाळी आरु वारु वातो क भेळ एना मोतलोब सी मुकल्यो, ");
INSERT INTO dhn_vpl VALUES ("ET9_31","018_9_31","EST","9","31","31","कि पुरीम क उना दाहड़े क खास टाकलो हुयो टेम मा मोर्दके यहुदी आरु एस्तेर रानी नु हुकुम नु ओनसारे, आरु ज यहुदियो न आपसा आरु आपसी ओवलियाद क लिय ठान लेदो हुतो, ओका ओनसारे वी उपवास आरु विलाप कोर्‌यो जाय। ");
INSERT INTO dhn_vpl VALUES ("ET9_32","018_9_32","EST","9","32","32","पुरीम क वाराम क यो कायदो एस्तेर नु हुकुम सी वी स्थिर कोर्‌यो गुयो, आरु ओकी वात किपात मा लिखी गुय। ");
INSERT INTO dhn_vpl VALUES ("ET10_1","018_10_1","EST","10","1","1","राजा क्षयर्ष न देश आरु दरिया क टापुओं पोर फाळु लागाड़्यो। ");
INSERT INTO dhn_vpl VALUES ("ET10_2","018_10_2","EST","10","2","2","ओका माहात्म्य आरु पराक्रम क कामो, आरु मोर्दके नु उना बड़ाई क पुरो ब्योरो, ज राजा न ओकी कोर्‌यो हुतो, काय हुयो मादे आरु फारस क राजाओं क इतिहास नी किपात मा नी लिखलो होय? ");
INSERT INTO dhn_vpl VALUES ("ET10_3","018_10_3","EST","10","3","3","निदान यहुदी मोर्दके, क्षयर्ष राजात क नेचो हुतो, आरु यहुदियो नी निंगा मा मोटो हुतो, आरु ओका आखा भाई ओकासी खुश हुता, काहकी हुयो आपसा लोगहन क भलाई नु हेर मा रोया कोरतो हुतो, आरु आपसा आखा लोगहन सी वार शान्ति क वाते कोरतो हुतो।");
INSERT INTO dhn_vpl VALUES ("EC1_1","022_1_1","ECC","1","1","1","यरुशलेमन राजा, दाऊद न पोर्या आरु सभोपदेशकन वचन। ");
INSERT INTO dhn_vpl VALUES ("EC1_2","022_1_2","ECC","1","2","2","सभोपदेश क यो वचन छे, वाय बार वाय बार, वाय बार वाय बार, आखो बी वायेन छे, ");
INSERT INTO dhn_vpl VALUES ("EC1_3","022_1_3","ECC","1","3","3","जो मेहनत मानुस इनी धरती पर करे, ओका सी हेको काय फायदु जड़े? ");
INSERT INTO dhn_vpl VALUES ("EC1_4","022_1_4","ECC","1","4","4","एक पीढ़ी जाय आरु दिसरी पीढ़ी आवे, पुन धरती जसी की तसीत जोलोम बनली रये ");
INSERT INTO dhn_vpl VALUES ("EC1_5","022_1_5","ECC","1","5","5","दाहड़ु उगे आरु डूबी वी जाय, आरु छाटलोत उना जागा पर जात रये जाँ सी त्यो उगे। ");
INSERT INTO dhn_vpl VALUES ("EC1_6","022_1_6","ECC","1","6","6","वाहळो ते दोखेवरे भेनी जाय, आरु बोखवरे भेणी फिरती जाय; आरु फिरे आरु चाले, आरु आपसा जागा पोर पछी आत रवे। ");
INSERT INTO dhn_vpl VALUES ("EC1_7","022_1_7","ECC","1","7","7","आखा नोंद्‌या एकुत् जागा भेणी ताव-ताव उह्‌या करे। त्या सब दरिया सी मिळ जाय आरु हेको भेणी पछी फिर जाय। ");
INSERT INTO dhn_vpl VALUES ("EC1_8","022_1_8","ECC","1","8","8","आखी वात हरबड़ावने वाळी छे, मानुस हेको पुरावो नी कर सके। देखीन भी डुळान हर नी भागे, आरु समळीन भी कान्टा नी भराये। ");
INSERT INTO dhn_vpl VALUES ("EC1_9","022_1_9","ECC","1","9","9","जो वात हय गयी त्या अळी पछी हुयसे। जो काय बनगियो त्योत् ओळी बनसे; आरु धरती पर काहय बी नवलो नी हय। ");
INSERT INTO dhn_vpl VALUES ("EC1_10","022_1_10","ECC","1","10","10","काय असी काहली वात छे, जेका वाराम लोगहन कय सके कि देख यी नवली छे? यी ते वेगला वाराम हामरे सी घण पेहले सी हुयती आय रयी। ");
INSERT INTO dhn_vpl VALUES ("EC1_11","022_1_11","ECC","1","11","11","वेगला वारान वात न काय फोम नी रयी, आरु हयने वाळी वातन क भी हेनको बाद मा आवने वाळान क फोम नी रये। ");
INSERT INTO dhn_vpl VALUES ("EC1_12","022_1_12","ECC","1","12","12","हांव उपदेशक यरुशलेम मा इसराएलन राजो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EC1_13","022_1_13","ECC","1","13","13","हाव म्हारो मन लगाड़ीयो कि जो काय धरती पर करीयो जाय, हेको पुरावो अकोल सी सोची समजीन मालोम करो; कि यो मोटा दु:खन काम छे जो परमेश्वर मानुसो वाटे टाकलो छे कि त्या हेका मा लागला रोवे तोसे। ");
INSERT INTO dhn_vpl VALUES ("EC1_14","022_1_14","ECC","1","14","14","हांव हेनु सब काम क देखीयो जो काय धरती पर हुये; देखु त्यो आखो वायबार छे आरु वाहळाक धरने तोसो छे। ");
INSERT INTO dhn_vpl VALUES ("EC1_15","022_1_15","ECC","1","15","15","जो आड़ो छे त्यो सुतरो नी हय सके, आरु जो नी होय त्यो गिनाये नी। ");
INSERT INTO dhn_vpl VALUES ("EC1_16","022_1_16","ECC","1","16","16","हांव मारा मोन मा कयो, देख, जतरा म्हार सी पेहले यरुशलेम मा हुता, हेनु आखा सी हांव घणी अकोल हात करलो छे; आरु मेखे घण जबर ओकोल आरु गियान जड़ गयलो छे। ");
INSERT INTO dhn_vpl VALUES ("EC1_17","022_1_17","ECC","1","17","17","आरु हांव म्हारो मन लगाड़ीयो कि अकोलन पुरावो लेयो आरु भंगलायली आरु विनअकलाय वात क बी जान लेयो। मेखे पतो लागीयो कि यो बी वाहळाक धरने तोसो छे। ");
INSERT INTO dhn_vpl VALUES ("EC1_18","022_1_18","ECC","1","18","18","काहकी जादा अकोलन सात मा जादा दु;ख हये, आरु जो आपसी अकोल वदाड़े त्यो आपसो दु:ख क बी वदाड़े। ");
INSERT INTO dhn_vpl VALUES ("EC2_1","022_2_1","ECC","2","1","1","हांव म्हारा मन सी कयो, “चाल, हांव तुको खुशीन लारे पारखीस की खुशी काय छे? पुन यो वी मालुम पोड़्‌यो की यो वी वायबार छे। ");
INSERT INTO dhn_vpl VALUES ("EC2_2","022_2_2","ECC","2","2","2","मेखे हासी खुशीन वाराम कयनो पड़ीयो, यो ते गांडवायनो छे,” आरु सुखन वाराम, “ हेका सी काय जड़से?” ");
INSERT INTO dhn_vpl VALUES ("EC2_3","022_2_3","ECC","2","3","3","हांव मन विचार करीयो कि काहली रीति सी म्हारी अकोल बनली रये आरु हांव म्हारा जीव क अंगुरन रस पीने सी कसो बदाड़ो आरु कसो विनअकल वात क कसो म्हार हक मा राखो, जव तक मालोम नी कर लेयो की त्यो वारलो काम काहलो छे जिनाक मानुस आपसा जीवन भर करतो रये। ");
INSERT INTO dhn_vpl VALUES ("EC2_4","022_2_4","ECC","2","4","4","हांव मोटो काम करीयो; हांव म्हारे वाटे घर बनवाड़ीयो आरु म्हारे वाटे दाखन वाड़ी लगवाड़ीयो। ");
INSERT INTO dhn_vpl VALUES ("EC2_5","022_2_5","ECC","2","5","5","म्हाव म्हारे वाटे अंगुरन वाड़ी लगाड़ लीदो, आरु हेनाम भांती भांतीन क फोव वाळा झाड़न वाड़ लगवाड़ीयो। ");
INSERT INTO dhn_vpl VALUES ("EC2_6","022_2_6","ECC","2","6","6","हांव म्हारे वाटे तळाव बनाय लिदो कि हेनु मा झाड़कान क पानी देया करे जिनुम झाड़का लगाड़ता हुता। ");
INSERT INTO dhn_vpl VALUES ("EC2_7","022_2_7","ECC","2","7","7","हांव पावर आरु पावेरनियान क मुले लीदो, आरु म्हारे घर मा पावरीया बी पयदा हुया; आरु जतरा म्हार सी पेहले यरुशलेम मा हुता हेनु सी घणा गाय ने बयलिया आरु गाडरा आरु बकड़ान क मालिक हुतो। ");
INSERT INTO dhn_vpl VALUES ("EC2_8","022_2_8","ECC","2","8","8","हांव राजाओ आरु परदेशोन सोनो, चाँदी आरु धन बी म्हारे पास एख्‌टो करीन राखलो हुतो। हांव म्हार वाटे गावने वाळा ओदमी आरु गावने वाळा बायरान क मुले लिदो, आरु घण सवटा ओदेमड़ान क जीव खुश करने करीन घणी सवटी रखेल बायजात बी हुती। ");
INSERT INTO dhn_vpl VALUES ("EC2_9","022_2_9","ECC","2","9","9","इनीये रीतिये सी म्हार सी पेहल वाळा सब यरुशलेम मा रयने वाळा सी जादा मोटा आरु धनी हुय गिया; तेबी म्हारी अकोल ठिकान पर रयी। ");
INSERT INTO dhn_vpl VALUES ("EC2_10","022_2_10","ECC","2","10","10","आरु जतरी चीजन क म्हारी देखनेन मरजी पड़ी, हांव हेको जीव भरीन देखीयो। हांव म्हारा मन क काहली बी भातीन सुख मारने सी नी रुकियो काहकी म्हार मन म्हारी आखी काठी मेहनत सी खुश हुयो; आरु म्हारी मेहनत सी मखे योत् वाटो जड़ियो। ");
INSERT INTO dhn_vpl VALUES ("EC2_11","022_2_11","ECC","2","11","11","तव हांव पछो ओळी म्हारा हातन सब काम क, आरु म्हारी सारी मेहनत क देखीयो, ती काय देखीयो कि आखो बी वायबार छे आरु वाहळाक धरनो जोसो छे, आरु इनी दुनिया मा काय बी फायदो नी हय। ");
INSERT INTO dhn_vpl VALUES ("EC2_12","022_2_12","ECC","2","12","12","ओळते हांव मन क फिरायो कि अकोल आरु गांडवाड़नाय आरु विनकलियान काम क देखो; काहकी जो मानुस राजा न पछोळ आवसे, त्यो काय करसे? अतरोत की जो हुयतो आय रियो। ");
INSERT INTO dhn_vpl VALUES ("EC2_13","022_2_13","ECC","2","13","13","हांव देखियो कि आंधारा सी मोटो विजाळो छे, वसोत् अकोल बी विनकलाय वात मोटी छे। ");
INSERT INTO dhn_vpl VALUES ("EC2_14","022_2_14","ECC","2","14","14","जो अकोल वाळो छे, हेका मुनका मा डूळा रये, पुन विनअकलिया आंधारा मा चाले; ते बी हांव जान लिदो कि दुयुन दोस्‌या एक सारकी हुये। ");
INSERT INTO dhn_vpl VALUES ("EC2_15","022_2_15","ECC","2","15","15","तव हांव मन मा कयो, जसी विनअकलियान हालत हुयसे, वसीत म्हारी बी हालत हुयसे; ते हांव काहा जादा अकोल वाळो हुयो? आरु हांव मन कयो, यो बी वायबार छे। ");
INSERT INTO dhn_vpl VALUES ("EC2_16","022_2_16","ECC","2","16","16","काहकी नी ते अकोल वाळान क आरु नी ते विनअकलियान फोम जलोमकी नी रये, पुन आवने वाळा दाहड़ाम विसराय जासे, अकोल वाळो कसो विनकलियान तसो मर जाय। ");
INSERT INTO dhn_vpl VALUES ("EC2_17","022_2_17","ECC","2","17","17","अतरान करीन हांव म्हार जीव पर किचवायो, काहकी जो काम धरती पर हुये, मेखे भुण्डलो मालोम पड़ियो; काहकी सब काय वायबर आरु वाहळाक धरनो छे। ");
INSERT INTO dhn_vpl VALUES ("EC2_18","022_2_18","ECC","2","18","18","हांव म्हारा आखा मेहनतन कामन फोव सी जिनाक हांव धरती पर करलो हुतो किचवायो, काहकी पाको छे कि हांव हेको फोव उना मानुसन वाटे छुड़ जाम जो म्हारेन ओळते आवसे। ");
INSERT INTO dhn_vpl VALUES ("EC2_19","022_2_19","ECC","2","19","19","यो कुन जाने कि त्यो मानुस अकोल वाळो हुयसे या विनकलियो? तेबी दाहड़ान नेचो जतरी मेहनत हांव करीयो, आरु हेको वाटे अकोल काम मा लायो की हेनु सबन त्यो आदिकारी हुयसे। यो बी वायबार। ");
INSERT INTO dhn_vpl VALUES ("EC2_20","022_2_20","ECC","2","20","20","तव हांव म्हार मन मा हेनी आखी मेहनतन वाराम जो हांव धरती पर करलो हुतो नराज हुयो। ");
INSERT INTO dhn_vpl VALUES ("EC2_21","022_2_21","ECC","2","21","21","काहकी असो मानुस बी छे, जिनान काम मेहनत आरु ओकल आरु गियान सी हुये आरु सफल बी हुये, ते बी हेको असा मानुस वाटे छुड़ीन जानो पड़ जाय, जिनाम काहय बी मेहनत नी करीयो हय। यो बी वायबार आरु घणोत् भुण्डो छे। ");
INSERT INTO dhn_vpl VALUES ("EC2_22","022_2_22","ECC","2","22","22","मानुस जो धरती पर मन लगाड़ी लगाड़ीन मेहनत करे उना सी हेको काय फायदो हुये। ");
INSERT INTO dhn_vpl VALUES ("EC2_23","022_2_23","ECC","2","23","23","हेका सब दाहड़ा ते दु:ख सी भरायला रये, आरु हेका काम कोमजुर मन सी हुये; राती बी हेको मन सुक नी हात करे, यो बी वायबार छे। ");
INSERT INTO dhn_vpl VALUES ("EC2_24","022_2_24","ECC","2","24","24","मानुसन करता खाने-पीने आरु मेहनत करता जाईन आपसा जीव क सुखी राखनो यो छुड़ीन काय बी वारु नी हय। हांव देखीयो कि यो बी परमेश्वरन भेणी रयीन जड़े। ");
INSERT INTO dhn_vpl VALUES ("EC2_25","022_2_25","ECC","2","25","25","काहकी हेरे विगुर कुन खाय पीन खुश रोय सोके। ");
INSERT INTO dhn_vpl VALUES ("EC2_26","022_2_26","ECC","2","26","26","जिना मानुस सी परमेश्वर खुश हुये त्यो हेनात् ककोल, गियान आरु सुक आपे। पुन पापी मानुस क त्यो दु:ख सी भरायल काम आपे त्यो हेको आपने करीन मेहनत करीन ढेर लगाड़े जो परमेश्वरन निगाम वारु हय। यो बी वायबार आरु वाहळान क धरनो छे। ");
INSERT INTO dhn_vpl VALUES ("EC3_1","022_3_1","ECC","3","1","1","हर एक वातन एक मुखो आरु हर काम क, जो सोरगन नेचो हुये, एक टेम छे। ");
INSERT INTO dhn_vpl VALUES ("EC3_2","022_3_2","ECC","3","2","2","पयदा हुयनेन टेम, वेरनेन टेम; आर वेरलान क उखाळनेन बी टेम छे; ");
INSERT INTO dhn_vpl VALUES ("EC3_3","022_3_3","ECC","3","3","3","मारनेन टेम, आरु आरगो करनेन बी टेम ढोळी देनेन टेम, आरु बनावनेन बी टेम छे; ");
INSERT INTO dhn_vpl VALUES ("EC3_4","022_3_4","ECC","3","4","4","रोड़नेन टेम, आरु हासनेन टेम, दु:ख करनेन टेम, आरु नाचनेन बी टेम छे; ");
INSERT INTO dhn_vpl VALUES ("EC3_5","022_3_5","ECC","3","5","5","दगड़ा न्हाकनेन टेम, आरु दगड़ान क एखटा करनेन बी टेम, गळे मिळनेन टेम, आरु गळे मिळने सी रुकायनेन बी टेम छे ");
INSERT INTO dhn_vpl VALUES ("EC3_6","022_3_6","ECC","3","6","6","हेरनेन टेम, आरु खुवनेन बी टेम, वाचाड़ीन मेलनेन टेम, आरु न्हाकनेन बी टाकलो टेम छे। ");
INSERT INTO dhn_vpl VALUES ("EC3_7","022_3_7","ECC","3","7","7","फाड़नेन टेम, आरु सीवनेन बी टेम, हुगा रयनेन टेम, आरु बुलने बी पाको टेम छे। ");
INSERT INTO dhn_vpl VALUES ("EC3_8","022_3_8","ECC","3","8","8","मोंग करनेन टेम, आरु किचवायनेन बी टेम; लड़ायनेन टेम, आरु मेळाका हुयनेन बी टेम छे। ");
INSERT INTO dhn_vpl VALUES ("EC3_9","022_3_9","ECC","3","9","9","काम करने वाळान क हेकी मेहनत सी काय फायदो हुये? ");
INSERT INTO dhn_vpl VALUES ("EC3_10","022_3_10","ECC","3","10","10","हांव देखीयो की परमेश्वर मानसो पोर कोतरो दुखोन भार नाखलु छे। ");
INSERT INTO dhn_vpl VALUES ("EC3_11","022_3_11","ECC","3","11","11","त्यो सब काय असो बनायो कि आपसी टेम पर त्या घाटाळा रये; ओळी त्यो मानुसन मन मा जलोम रयने वाळो गियान पयदा करीयो, ते बी जो काम परमेश्वर करीयो, त्यो शुरु सी लीन आखरी तक मानुस समझी नी सके। ");
INSERT INTO dhn_vpl VALUES ("EC3_12","022_3_12","ECC","3","12","12","हांव यो जान लेदो कि मानुसन करता सुक करने आरु जीवन भरीन भलाय करने सिवाय, आरु दिसरो काहलो बी काम वारु नी हय; ");
INSERT INTO dhn_vpl VALUES ("EC3_13","022_3_13","ECC","3","13","13","आरु यो बी परमेश्वरन दान छे कि मानुस खाय- पीये आरु आपसा सब मेहनत मा सुख सी रये। ");
INSERT INTO dhn_vpl VALUES ("EC3_14","022_3_14","ECC","3","14","14","हांव यो जानो कि जो काय परमेश्वर करे त्यो जलोम बनलो रयसे; नी ते उनामा काहय वोदाड़से आरु नी ते घटाड़से; परमेश्वर असो अतरान करीन करे कि लोगहन हेकी बीक माने। ");
INSERT INTO dhn_vpl VALUES ("EC3_15","022_3_15","ECC","3","15","15","जो काय हुयो त्यो इना सी बी पेहले हुय चुकीयो; जो हयने वाळो छे, त्यो बी हुय चुकलो छे; आरु परमेश्वर वितली वातोन क वोळी-वोळी पछो करे। ");
INSERT INTO dhn_vpl VALUES ("EC3_16","022_3_16","ECC","3","16","16","ओळी हांव दुनिया मा काय देखियो कि नियावन जागा मा अन्यायन काम हुये, आरु वारला जागा मा बी भुण्डला कामे हुये। ");
INSERT INTO dhn_vpl VALUES ("EC3_17","022_3_17","ECC","3","17","17","हांव मन मा कयो, परमेश्वर धरमी आरु कुमनिया दुयन क नियाव करसे, काहकी हेका पास मा एक एकन वाराम आरु एक एक कामन टेम छे। ");
INSERT INTO dhn_vpl VALUES ("EC3_18","022_3_18","ECC","3","18","18","हांव मन मा कयो, “यो अतरान करीन हुय रीयो कि परमेश्वर मानुसन पारख करे कि देख सके कि त्या जनवार सारका छे।” ");
INSERT INTO dhn_vpl VALUES ("EC3_19","022_3_19","ECC","3","19","19","काहकी जसी मानुसन वसीत् जनवारीयान बी हालत हुये; दुयन चीत हालत रये, जसो एक मरे तसोत् दिसरो बी मरे। आखान सांस एक सारकी छे, आरु मानुस जनवारीया सी बढ़ीन नी हय; सब काय वायबार छे। ");
INSERT INTO dhn_vpl VALUES ("EC3_20","022_3_20","ECC","3","20","20","आखरी मा सब एकुत् जागा मा जात रये। आखा धुळाम पछा भेसकाय जाय। ");
INSERT INTO dhn_vpl VALUES ("EC3_21","022_3_21","ECC","3","21","21","काय मानुसन जीव उपर जाय आरु जनवारीयान जीव नेचो जाईन धुळा मा भेसकाय जाय? यो कुन जाने? ");
INSERT INTO dhn_vpl VALUES ("EC3_22","022_3_22","ECC","3","22","22","हांव यो देखीयो कि इना सी काय वारु नी हय कि मानुस आपसा कामोम खुश रये काहकी हेको वाटो योत् छे; कुन हेको पछळ हुयने वाळी वातोन क पछो देखाड़ सके? ");
INSERT INTO dhn_vpl VALUES ("EC4_1","022_4_1","ECC","4","1","1","तव हांव त्यो सब भुण्डलो काम देखीयो जो दुनिया मा हये। आरु काय देखियो, कि आंधारो छेलने वाळान क डुळान आसा उहूय रीया, आरु हेनको कोय बी सुख आपने वाळो नी! आंधारो करने वाळान हात मा ताकोत हुती, पुन हेनको कोय शाँती आपने वाळो नी हुतो। ");
INSERT INTO dhn_vpl VALUES ("EC4_2","022_4_2","ECC","4","2","2","अतरान करीन हांव हेनु जीवतलान क जो हाल तक जीवता छे हेनकी बराबरी मा हांव हेनु मरलान क जो मर गयला छे, जादा वारु मानिस। ");
INSERT INTO dhn_vpl VALUES ("EC4_3","022_4_3","ECC","4","3","3","पुन हेनु दुयन सी जादा वारु त्यो छे जो हाल लोगुन पोयदा हुयो नी, नी या भुन्डला काम देखे जो धरती पर हुये। ");
INSERT INTO dhn_vpl VALUES ("EC4_4","022_4_4","ECC","4","4","4","तव हांव आखी मेहनतन काम आरु सब सफल काम क देखियो जो लोहगन आपसा साते वाळा सी कुहरायन कारण सी करे। यो बी वायबार छे। आरु वाहळाक धरने जोसो छे। ");
INSERT INTO dhn_vpl VALUES ("EC4_5","022_4_5","ECC","4","5","5","विनअकलियो हात पर हात मेलीन बठ रये, आरु आपसा क बरबाद करे। ");
INSERT INTO dhn_vpl VALUES ("EC4_6","022_4_6","ECC","4","6","6","मुठ भरीन मनन सुख, दुय मुठ मेहनत सी वारु छे, जो मानु वाहळाक धरने बराबर छे। ");
INSERT INTO dhn_vpl VALUES ("EC4_7","022_4_7","ECC","4","7","7","हांव धरती पर ओळी यी बी वात वायबार देखियो। ");
INSERT INTO dhn_vpl VALUES ("EC4_8","022_4_8","ECC","4","8","8","कोय एखलो रये आरु हेको कोय नी हय; नी हेको पोर्यो हय, नी भाईस हय, तेबी हेकी मेहनत खतम नी हये; नी ते हेका डुळा धन सी धापे; आरु नी त्यो कये, कि हांव कुनी वाटे मेहनत करो आरु आपसा क सुक सी दुर राखरीयो? यो बी वायबार छे। ");
INSERT INTO dhn_vpl VALUES ("EC4_9","022_4_9","ECC","4","9","9","एक सी दुय जन रयनो वारु छे काहकी हेनकी मेहनतन फोव वारु जड़े। ");
INSERT INTO dhn_vpl VALUES ("EC4_10","022_4_10","ECC","4","10","10","काहकी कदाम हेनु मा सी एक पड़े, ती दिसरो हेको उठाड़े; पुन विखु उना पर जो एखलोत हयीन पड़े आरु हेको कोय उठाड़ने वाळो नी रये। ");
INSERT INTO dhn_vpl VALUES ("EC4_11","022_4_11","ECC","4","11","11","ओळी कदाम दुय जन एखटा सुवे ती ताता रयसे, पुन कोय एखलो रयीन कसो तातो हुयसे। ");
INSERT INTO dhn_vpl VALUES ("EC4_12","022_4_12","ECC","4","12","12","कदाम कोय एखला क कोमजुर ते करे, पुन दुय हेको सामनो कर लेय। जो दुवड़ो तीन दुवड़ा सी बनलो रये, त्यो छाटो नी टुटे। ");
INSERT INTO dhn_vpl VALUES ("EC4_13","022_4_13","ECC","4","13","13","अकोल वाळो जुवान गरीब रयीन बी असला डाहला आरु विनअकलिया राजा सी वारु छे, जो राय नी माने, ");
INSERT INTO dhn_vpl VALUES ("EC4_14","022_4_14","ECC","4","14","14","होय सोके की त्यो जुवान राजान घोराना मा पोयदा होयो होय, नीते होय सोके की हेरी पोयदावारी गोरब्या मुलकोम होयी होय, ");
INSERT INTO dhn_vpl VALUES ("EC4_15","022_4_15","ECC","4","15","15","हांव सब जीवतलान क जो धरती पर चाले फिरे हेनको देखियो कि त्या हेना दिसरा पोर्यान क सात मा चाल दीदो, जो हेनको जागो हात करने करीन उबो हुय रीयो। ");
INSERT INTO dhn_vpl VALUES ("EC4_16","022_4_16","ECC","4","16","16","त्या आखा लोगहन गिनाये नी अतरा सवटा हुता। ते बी आवने वाळी पीढी हेका सी खुश नी हये। छाचली यो बी वायबार आरु वाहळानक धरनो छे। ");
INSERT INTO dhn_vpl VALUES ("EC5_1","022_5_1","ECC","5","1","1","जव तु परमेश्वरन मन्दिर मा जाय, तव चोकचोळीयो रयीन चालजी; समळने करीन सातले जानो विनअकलियान बादा चढ़ावने सी वारु छे; काहकी त्या नी जाने कि भुण्डलो काम करे। ");
INSERT INTO dhn_vpl VALUES ("EC5_2","022_5_2","ECC","5","2","2","आपसा मुय सी कोय वात छाटलो झुन निकाळे, आरु नी उतवाळी मा मनन वात परमेश्वरन सामने डेखाड़े, काहकी परमेश्वर सोरग मा छे आरु तु धरती पर छे; अतरान करीन थारा बुल थुड़ाक रयनो जुवे। ");
INSERT INTO dhn_vpl VALUES ("EC5_3","022_5_3","ECC","5","3","3","काही जसो कामन जादा हुयने क कारण सपनो देखे, तसोत् घण सवटी वात करने वाळो विनअकलियो कोवाये। ");
INSERT INTO dhn_vpl VALUES ("EC5_4","022_5_4","ECC","5","4","4","जव तु परमेश्वर वाटे मानता माने; तव हेको पुरो करने मा मुड़ो झुन हुये; काहकी त्यो विनअकलिया सी खुश नी हुये। जो मानता तु मानलो छे हेको पुरी करजी। ");
INSERT INTO dhn_vpl VALUES ("EC5_5","022_5_5","ECC","5","5","5","मानता मानीन पुरी नी करने सी मानता नी माननो वारु छे। ");
INSERT INTO dhn_vpl VALUES ("EC5_6","022_5_6","ECC","5","6","6","कोय बुल कयीन आपसा पाप मा झुण फसे, आरु परमेश्वरन दुतन सामने यो झुण कये की यो भुल सी हुयो; थारो बुल समळीन परमेश्वर काह नराज हुये, आरु थारा हातन काम क नाश करे। ");
INSERT INTO dhn_vpl VALUES ("EC5_7","022_5_7","ECC","5","7","7","काहकी जादा सपना सी रिकामी वात जादा हुये; पुन तु परमेश्वरन बीक मानजी। ");
INSERT INTO dhn_vpl VALUES ("EC5_8","022_5_8","ECC","5","8","8","कदाम तुमु कोय परदेश मा गरीब लोगहन क वेला पाड़तला देखु, कदाम वाँ सारी नियाव बिगड़तो देखु ती घबरायनो नी काहकी एक आदिकारी से मोटो दिसरो रये। जिनाक इनी आखी वातन खबर रये, आरु हेका बी जादा मोटा रये। ");
INSERT INTO dhn_vpl VALUES ("EC5_9","022_5_9","ECC","5","9","9","धरती पर क ओन आखा वाटे छे, पुन खेती सी राजान बी काम निकळे। ");
INSERT INTO dhn_vpl VALUES ("EC5_10","022_5_10","ECC","5","10","10","पोयस्यान लालुच करने वाळो पयसिया सी कदी नी धापे; आरु नी ते असो मानुस जिनाक धनन लालचियो छे, नोफा सी यो बी वायबार छे। ");
INSERT INTO dhn_vpl VALUES ("EC5_11","022_5_11","ECC","5","11","11","जव धन वोदे तव हेको खाने वाळा बी वोदे। आरु हेका मालिक क उना सी काय फायदो होये? अतरोत की त्यो हेका धोनोक आपसा डुळा सी देखे। ");
INSERT INTO dhn_vpl VALUES ("EC5_12","022_5_12","ECC","5","12","12","मेहनत करने वाळो थुड़ो खाय या जादा, ते बी हेकी नींद गुळी रये; पुन धनीन धन वोदनेन कारण हेकेक निंद नी आवे। ");
INSERT INTO dhn_vpl VALUES ("EC5_13","022_5_13","ECC","5","13","13","हांव धरती पर एक भुण्डली वातोन क देखीयो, धनी मानुस आपसा घाटा वाटे धन एख्टो करे। ");
INSERT INTO dhn_vpl VALUES ("EC5_14","022_5_14","ECC","5","14","14","आरु त्यो काहला भुण्डला काम उजड़ी जाय, आरु हेका घर मा पोर्यो पयदा हुये पुन हेका हात मा काहय बी नी रये। ");
INSERT INTO dhn_vpl VALUES ("EC5_15","022_5_15","ECC","5","15","15","जसो त्यो माय न पेटम रयीन निकळीयो तसोत् पछो जात रयसे; नांगरोत् जसो आवलो हुतो, आरु आपसी मेहनतन बदले काहय बी हात करे जिनाक त्यो आपसा हात मा लीन जाय सके। ");
INSERT INTO dhn_vpl VALUES ("EC5_16","022_5_16","ECC","5","16","16","यी घणी भुण्डली वात छे, जसो त्यो आवलो हुतो ठीक तसोत् याँ सी पछो जासे। हेको आपसी मेहनत सी काय फायदो हुयो? ");
INSERT INTO dhn_vpl VALUES ("EC5_17","022_5_17","ECC","5","17","17","त्यो रिकामी मेहनत करीयो, त्यो आपसा पुरा जीवन मा निराशा मा आरु दु:ख मा, चिन्ता आरु बिमारी मा, आरु किचवालो जीवन जीवतो रयो। ");
INSERT INTO dhn_vpl VALUES ("EC5_18","022_5_18","ECC","5","18","18","समळ, जो वारली वात हांव देखीयो, जी वारु छे त्यो यो कि मानुस खाय पीये आरु आपसी मेहनत सी जो त्यो धरती पर करे, आपसी सारी उमर भरीन जो परमेश्वर हेको आपलो छे, सुख सी रये; काहकी हेको वाटो योत् छे। ");
INSERT INTO dhn_vpl VALUES ("EC5_19","022_5_19","ECC","5","19","19","पुन हर एक मानुस जिनाक परमेश्वर धन सम्पत्ति आपलो छे, हेको सुख करनेन ताकत बी आपलो छे त्यो आपसा काम क माननो जुळे आरु सुख सी मेहनत करे। यो परमेश्वरन आपलो वाटो छे। ");
INSERT INTO dhn_vpl VALUES ("EC5_20","022_5_20","ECC","5","20","20","इना जीवन न दाहड़ा हेकेक ढेरका फोम नी रये, काहकी परमेश्वर हेकी समळीन हेका मन क सुखी राखे। ");
INSERT INTO dhn_vpl VALUES ("EC6_1","022_6_1","ECC","6","1","1","हांव धरती पर एक आरु बुराय देखीयो, जेका भार सी मानुस दड़पायलो रये। ");
INSERT INTO dhn_vpl VALUES ("EC6_2","022_6_2","ECC","6","2","2","त्या बुराय यी छे; परमेश्वर मानुस क धन आरु विजुत आपे, आरु मानुस क आपसी मरजीन अनसारे सब काय जड़ जाय। हेको काहली बी चीजन कमती नी रये। पुन हेना मानुस क परमेश्वर हेका माईन खानेन नी देय; बाकीन अनजानियो मानुस हेकी धन सम्पत्ति क खाय; यो वायबार आरु घणी दु:खन वात छे। ");
INSERT INTO dhn_vpl VALUES ("EC6_3","022_6_3","ECC","6","3","3","कदाम मानुसन सोव पोर्या पयदा हुये, आरु त्यो नाम्बी उमर तक जीवतो रये, दुय भाग उमर हात करे, पुन कदाम त्यो जीवन सुख क हात नी करे, मरने पर आखरी वगेवाळनेन रीत भी नी जड़े, ती हांव यो कयीस; असला मानुस सी ते आधा मयनान मरलो पयदा हुयलो बाळो वारु छे। ");
INSERT INTO dhn_vpl VALUES ("EC6_4","022_6_4","ECC","6","4","4","मरलो पोर्यो इनी धरती पर रीकामो आवे, आरु आंधारलाम खुवाय जाय, आंधारान परदो हेकेक ढाक देय। ");
INSERT INTO dhn_vpl VALUES ("EC6_5","022_6_5","ECC","6","5","5","त्यो दाहड़ान विजाळा क नी देखीयो, आरु नी हेको जिवनन काहय अनसारो जड़ियो। ते बी हेना पोर्याक हेना जादा उमर जड़ने वाळा मानुस सी जादा वारु आराम जड़ीयो। ");
INSERT INTO dhn_vpl VALUES ("EC6_6","022_6_6","ECC","6","6","6","होव, चाहे त्यो दुय हजार साल जीवे, पुन कदाम त्यो जीवनन सुख हातुत् नी करीयो, ती हेको काय फायदो? काय आखान आखा एकुत् जागा पर नी जाय? ");
INSERT INTO dhn_vpl VALUES ("EC6_7","022_6_7","ECC","6","7","7","मानुस खाने कोरीन मेहनोत कोरे, ते वी हेरो पेट नी भोराये। ");
INSERT INTO dhn_vpl VALUES ("EC6_8","022_6_8","ECC","6","8","8","जो अकोल वाळो छे त्यो काहली वात मा विनअकलिया रयीन वारु छे? आरु गरीब जो यो जाने कि इना जीवन मा काहले रीतिये सी चालनो जुवे, त्यो बी उना सी काहली वात मा वोदीन छे। ");
INSERT INTO dhn_vpl VALUES ("EC6_9","022_6_9","ECC","6","9","9","डुळा सी देख लेनो मनन इच्छा सी वारु; यो बी वाहळाक धरनो छे। ");
INSERT INTO dhn_vpl VALUES ("EC6_10","022_6_10","ECC","6","10","10","जो काय बी मानुस छे, हेको नाम युगन शुरु सी मेकलो छे, आरु यो उजेन्तो छे कि त्यो उना सी जो हेका सी ताकत वाळो छे लड़ाय नी कर सके। ");
INSERT INTO dhn_vpl VALUES ("EC6_11","022_6_11","ECC","6","11","11","जिवनन वाराम जतरो विचार करो, ततरोत त्यो वायबार लागे, ती असला जीवन सी मानुस क काय फायदो? ");
INSERT INTO dhn_vpl VALUES ("EC6_12","022_6_12","ECC","6","12","12","काहकी मानुसन नाना जीवन मा जो त्यो साहळान सारको विते कुन जाने कि हेको करीन वारु काय छे? काहकी मानुस क कुन देखाड़ सके कि हेका बाद मा दुनिया मा काय हुयसे? ");
INSERT INTO dhn_vpl VALUES ("EC7_1","022_7_1","ECC","7","1","1","वारलो नाव मोंहगा इत्तर सी आरु मोतन दाहडू पयदावारीन दाहड़ा सी वारु छे। ");
INSERT INTO dhn_vpl VALUES ("EC7_2","022_7_2","ECC","7","2","2","टुळान काखानो खाने सी दु:ख वाळा घरन खानो खाये त्यो वारु छे; काहकी सब मानुसन आखरी यो छे, आरु जो जीवतो छे त्यो मन लगाड़ीन इना पर विचार करसे। ");
INSERT INTO dhn_vpl VALUES ("EC7_3","022_7_3","ECC","7","3","3","हासने सी दु:ख वारु छे, काहकी मुय परुन दु:ख सी मन सधरे। ");
INSERT INTO dhn_vpl VALUES ("EC7_4","022_7_4","ECC","7","4","4","अकोल वाळा मानुस न जीव ते दु:ख झेलने वाळा परिवार पर लागलो रये, पुन विनअकलियान ममन सुख करने वाळान घर भेणी लागलो रये। ");
INSERT INTO dhn_vpl VALUES ("EC7_5","022_7_5","ECC","7","5","5","विनअकलियान गीत समळने सी अकोल वाळान डाट समळनो वारु छे। ");
INSERT INTO dhn_vpl VALUES ("EC7_6","022_7_6","ECC","7","6","6","काहकी विनअकलियान हासनो हांडान नेचो धपतला लकड़ा पर सेकने बराबर रये; यो बी वाय बार छे ");
INSERT INTO dhn_vpl VALUES ("EC7_7","022_7_7","ECC","7","7","7","छाचली आंधारा सी अकोलवाळो गांडवाय जाय; आरु मानुसन क वेलापाड़ीन मांगलो धन अकोल क खतम कर देय। ");
INSERT INTO dhn_vpl VALUES ("EC7_8","022_7_8","ECC","7","8","8","काहलास कामन शुरु हुयने सी हेको खतम हुयनो वारु छे; आरु गम राखने वाळो डाहवाळा मनसु सी वारु छे। ");
INSERT INTO dhn_vpl VALUES ("EC7_9","022_7_9","ECC","7","9","9","आपसा मन मा उतवाळीयो रीस झुण करे, काहकी रीस विनअकलियात् जुन मन मा रये। ");
INSERT INTO dhn_vpl VALUES ("EC7_10","022_7_10","ECC","7","10","10","यो नी कयनो की वितिया दाहड़ा मा इना सी वारु काय हुतो? काहकी यो तु अकोल सी नी पुछतो। ");
INSERT INTO dhn_vpl VALUES ("EC7_11","022_7_11","ECC","7","11","11","अकोल राजो सारकी छे, राजोन तोसी एक वारली चीज छे आरु तेनु मानसो जुगु नोफान वात कोवाये जे कोळी पोर रोवे। ");
INSERT INTO dhn_vpl VALUES ("EC7_12","022_7_12","ECC","7","12","12","काहकी अकोलन आड़ रिपियान आड़ मा काम आवे; पुन गियानन फायदो यो छे कि अकोल सी हेको राखने वाळान जीव न राखवाळी हुये। ");
INSERT INTO dhn_vpl VALUES ("EC7_13","022_7_13","ECC","7","13","13","परमेश्वरन काम क देखो; जिनी चीज क त्यो आड़प करलो छे, हेको कुन सुदो कर सके? ");
INSERT INTO dhn_vpl VALUES ("EC7_14","022_7_14","ECC","7","14","14","सुकन दाहड़ा सुक मान, आरु दु:खन दाहड़ेन वारा विचार कर; काहकी परमेश्वर दुयन क एक सात राखलो छे, जिना से मानुस हेको बाद हुयने वाळी वातोन क नी समझे। ");
INSERT INTO dhn_vpl VALUES ("EC7_15","022_7_15","ECC","7","15","15","आपसा रीकामा जीवन मा हांव यो सब काय देखियो; कोय बी धरमी आपसा नियावन काम करतो जाईन नाश हुय जाय, आरु बुरो मानुस बुराय करतो जाईन ढेरकी उमर हात करे ");
INSERT INTO dhn_vpl VALUES ("EC7_16","022_7_16","ECC","7","16","16","आपसाक घण धोरमी झुण बनावे, आरु नी ते आपसाक घणो अकलो वाळो बनावजी; तु कायक आपसा क नाश क कारण हये? ");
INSERT INTO dhn_vpl VALUES ("EC7_17","022_7_17","ECC","7","17","17","घणो भुण्डो बी झुण बने, आरु नी बुरो हयजी; तु काह थारी टेम सी पेहले मरे? ");
INSERT INTO dhn_vpl VALUES ("EC7_18","022_7_18","ECC","7","18","18","यो वारु छे की तु इनी वातन क धरीन रय आरु उनी वात पर सी बी हाथ झुण उठावे; काहकी जो परमेश्वर क बीक माने त्यो इनी सब वेला सी पार हुय जासे। ");
INSERT INTO dhn_vpl VALUES ("EC7_19","022_7_19","ECC","7","19","19","अकोलुत् सी नगरन दस आदिकारीयान आश राखने मा अकोल वाळान क जादा ताकत जड़े। ");
INSERT INTO dhn_vpl VALUES ("EC7_20","022_7_20","ECC","7","20","20","धरती पर काहय बी असो धरमी मानुस नी हय जो भलाय करे आरु जिना सी पाप नी हयो हय। ");
INSERT INTO dhn_vpl VALUES ("EC7_21","022_7_21","ECC","7","21","21","जतरी वात कये सब पर कान झुण लगाड़े, असो नी हय कि तु यी वात समळे कि थारो चाकरीया थारी बुराय करे। ");
INSERT INTO dhn_vpl VALUES ("EC7_22","022_7_22","ECC","7","22","22","काहाकी तु जाने कि तु बी घणी वार दिसरान क सराप दीदलो छे। ");
INSERT INTO dhn_vpl VALUES ("EC7_23","022_7_23","ECC","7","23","23","यो सब हांव अकोल सी जाचीयो; हांव कयो, हांव अकोल वाळो हुय जाईस, पुन यो म्हार सी दुर रयो। ");
INSERT INTO dhn_vpl VALUES ("EC7_24","022_7_24","ECC","7","24","24","त्यो जी वात दुर आरु घणो उंडो छे, हेको पुरावो कुन ली सके? ");
INSERT INTO dhn_vpl VALUES ("EC7_25","022_7_25","ECC","7","25","25","हांव आपसा मन लगाड़ीयो कि अकोल न वाराम जानो; कि हेको हेरो आरु हेको पुरावो जानो, आरु कुमनियान बुराय आरु बुराय जो गांडवाय छे, हेको जानु। ");
INSERT INTO dhn_vpl VALUES ("EC7_26","022_7_26","ECC","7","26","26","आरु हांव मोत सी बी जादा पीड़ा वाळी एक आरु चीज देखीयो, मतलब उनी बायजात क जेको नाव फंदो आरु जाळ छे आरु जेका हाथ मा हाथकड़ी छे, जिना ओदमी सी परमेश्वर खुश छे चोत् हेरेसी वाचसे, पुन पापी हेरो शिकार होयसे। ");
INSERT INTO dhn_vpl VALUES ("EC7_27","022_7_27","ECC","7","27","27","देख, उपदेशक कये, हांव गियान वाटे अलग अलग वतोन क जाचीन देखियो आरु यी वात निकळी, ");
INSERT INTO dhn_vpl VALUES ("EC7_28","022_7_28","ECC","7","28","28","जिनाक म्हारो मन हाय तक हेरी रयो, पुन जड़्यो नी। हजार मा सी हांव एक ओदमी क हात करीयो, पुन हेनु मा एक बी बायजात क नी देखीयो। ");
INSERT INTO dhn_vpl VALUES ("EC7_29","022_7_29","ECC","7","29","29","देखु, हांव अतरीत वात क देखीयो, कि परमेश्वर मानुस क सुदो बनायो, पुन त्या घण सवटा विचार निकाळीया। ");
INSERT INTO dhn_vpl VALUES ("EC8_1","022_8_1","ECC","8","1","1","अकोल वाळा तसो कुन छे? आरु काहली वातन मतलब कुन लगाड़ सके? मानुसन अकोलन कारण मुय चमके, आरु हेका मुय परु दु:ख दुर हुय जाय। ");
INSERT INTO dhn_vpl VALUES ("EC8_2","022_8_2","ECC","8","2","2","हांव तुसे सोला आपो की परमेश्वरन ओगोव वायदान कोरता राजान हुकुमोन पाळोन पाळ। ");
INSERT INTO dhn_vpl VALUES ("EC8_3","022_8_3","ECC","8","3","3","राजान होजरी मा जागु छुड़ने कोरने कोरीन तावनी मा झुन कोरे, काहनी भुन्डली वातोन कोरता वा नी होयु, काहकि हेनाक गोंहवे तोसो कोरसे। ");
INSERT INTO dhn_vpl VALUES ("EC8_4","022_8_4","ECC","8","4","4","काहकी राजा न बुल मा ते ताकत रये आरु कुन हेकेक कय सके कि तु काय करे? ");
INSERT INTO dhn_vpl VALUES ("EC8_5","022_8_5","ECC","8","5","5","जो हुकुम माने, त्यो पीड़ा सी वाच जासे आरु ओकोलवाळु मानुस वारली टेम आरु वारला कामोन नेम जाने। ");
INSERT INTO dhn_vpl VALUES ("EC8_6","022_8_6","ECC","8","6","6","काहकी हर एक न वारामा टेम आरु कामोन नेम रये, मानुस क दु:ख हेको वाटे घण भारो छे। ");
INSERT INTO dhn_vpl VALUES ("EC8_7","022_8_7","ECC","8","7","7","मानुस यो नी जानतो कि काय हुयने वाळो छे, काहकी काहलो मानुस हेको हुयने वाळी वातोन क देखाड़ सके? ");
INSERT INTO dhn_vpl VALUES ("EC8_8","022_8_8","ECC","8","8","8","असो कोय मानुस नी जिनान हक मा जीव चाले ");
INSERT INTO dhn_vpl VALUES ("EC8_9","022_8_9","ECC","8","9","9","जतरा काम धरती पर हुये हेनु सबन क धियान सी देखने मा यो सब काय हांव डेखीयो आरु यो बी देखियो कि एक मानुस दिसरा मानुस पर आदिकारी बनी आपसे उपर नुकशान लावे। ");
INSERT INTO dhn_vpl VALUES ("EC8_10","022_8_10","ECC","8","10","10","ओळी हांव कुमनियान क गाड़तला देखियो, जो चुखला जागा मा आया जाया करता हुता आरु जिनान नगर मा बी त्या असो करतला वाँ हेनको फोम नी रयो; यो बी वायबार छे। ");
INSERT INTO dhn_vpl VALUES ("EC8_11","022_8_11","ECC","8","11","11","भुण्डला कामन डण्ड न हुकुम उतवाळीयो जड़ जाय इना कारण मानुसन मन भुण्डला काम करने इच्छा सी भरायलो रये। ");
INSERT INTO dhn_vpl VALUES ("EC8_12","022_8_12","ECC","8","12","12","चाहे पापी सोव कावा पाप करे आपसा दाहड़ा वदाड़े, ते बी मखे पाको छे कि जो परमेश्वर सी बीहे आरु हेको सामने जानीन बीक मा वाले हेनो वारुत् हुये; ");
INSERT INTO dhn_vpl VALUES ("EC8_13","022_8_13","ECC","8","13","13","पुन पापी न वारलो नी हुये, आरु नी हेका जीवन उमर नाम्बी हुये, काहकी त्यो परमेश्वरन बीक नी मानतो। ");
INSERT INTO dhn_vpl VALUES ("EC8_14","022_8_14","ECC","8","14","14","एक आरु वात छे, जो धरती पर हुये यो बी रीकामो छे, धरमी मानुस क बुरा मानुसन फोव भुगतनो पड़े, आरु बुरा मानुस क वारला मानुस न वारला फल जड़ जाय, हांव कयो यो बी वायबार छे। ");
INSERT INTO dhn_vpl VALUES ("EC8_15","022_8_15","ECC","8","15","15","तव हांव सुक मनावनो वारु समझियो, काहकी धरती पर मानुस वाटे खाने पीने आरु सुख मनावने क छुड़ीन आरु काहय बी वारु नी हय, काहकी परमेश्वर हेको धरती पर योत् वातड़ो काम आपलो छे, हेको सुख लेने मा मद्त जड़से। ");
INSERT INTO dhn_vpl VALUES ("EC8_16","022_8_16","ECC","8","16","16","जव हांव अकोल हात करने आरु सब काम देखने करीन जो धरती पर करिया जाय तेनु कामोक सोमेजने कोरीन म्हार मन क लगाड़ीयो, कि कसा मानुस रात ने दाहड़ु जागता रये। ");
INSERT INTO dhn_vpl VALUES ("EC8_17","022_8_17","ECC","8","17","17","तव हांव परमेश्वरन आखा कामन क देखीयो जो धरती पर करीया जाय, चाहे मानुस हेका पुरावा क जानने करीन कतरी बी मेहनत कर लेय, ते बी हेको नी जानाये; कदाम अकोलवाळो कये कि हांव हेको समझीस ते बी त्यो हेको पतो नी कर सके। ");
INSERT INTO dhn_vpl VALUES ("EC9_1","022_9_1","ECC","9","1","1","हांव इनी सब वातोन क मन लगाड़ीन विचारियो कि इनी सब वातोन क पुरावो हात करोम, कि काहली रीति सी धोरमी आरु अकोल वाळा लोगहन आरु हेनका काम परमेश्वरन हात मा छे; मानुसन अगोळ आखी भातीन वात छे पुण त्यो यो नी जानतो कि त्या वात मोंगाळि छे या बुरी। ");
INSERT INTO dhn_vpl VALUES ("EC9_2","022_9_2","ECC","9","2","2","आखी वात आखा वाटे सारकी छे, छाचु हय या खुड़ावलो, वारलो, चुखलो या विटुळ बली चढ़ावने वाळा या नी बली नी चढ़ावने वाळा आखान हालत सारकीत् हुये। जसी धोरमी मानुसन हालत, तसीत् पापीन हालत; जसी कसम खाने वाळान हालत हुये, तसीत् हालत कसम खाने सी बीने वाळान हुये। ");
INSERT INTO dhn_vpl VALUES ("EC9_3","022_9_3","ECC","9","3","3","जो काय धरती पर करियो जाय उना मा यो एक गुनु छे कि सब लोगहन न एक सारकीत् हालत हुये; आरु मानुसन मनो मा बुराय भरायली छे, आरु जव तक त्या जीवता रये हेका मन मा गांडवाय भराय रये, आरु हेका बाद त्यो मरला मा जाईन भेसकाय जाय। ");
INSERT INTO dhn_vpl VALUES ("EC9_4","022_9_4","ECC","9","4","4","पुन जो जिवतला मा छे, हेको भुरसू छे, काहकी जीवतलो कुतरो मरला नाहार सी वदीन छे। ");
INSERT INTO dhn_vpl VALUES ("EC9_5","022_9_5","ECC","9","5","5","काहकी जो जीवतला छे त्या अतरो ते जाने कि त्या मरसे, पुन मरला काय बी नी जाने, आरु नी हेनको काहय बदलो जड़े, काहकी हेनको फोम करनो मिट जासे। ");
INSERT INTO dhn_vpl VALUES ("EC9_6","022_9_6","ECC","9","6","6","हेनको मोंग आरु दुश्मनी आरु हेनकी डाहळाय नाश हुय गयी, आरु जो काय धरती पर हुये हेना मा हेनको वाटे आरु कोय जलोमको वाटो नी रयसे। ");
INSERT INTO dhn_vpl VALUES ("EC9_7","022_9_7","ECC","9","7","7","थार घर जात रय, आरु खुशी सी रोटा खाया कर, आरु मन मा सुख सी थारो अंगुरन रस पिया कर, काहकी परमेश्वर थारा कामो सी खुश हुयलो छे। ");
INSERT INTO dhn_vpl VALUES ("EC9_8","022_9_8","ECC","9","8","8","थारा छिंदरा जलोम उजळा रये, आरु थारा मुनका पर तेल लागलो रये। ");
INSERT INTO dhn_vpl VALUES ("EC9_9","022_9_9","ECC","9","9","9","आपसा जीवन वायबार दाहड़ा जो त्यो धरती थारे वाटे टाकलो छे, थारी मोंगाळी लाड़ीन क सात मा विताड़जी, काहकी थारे वाटे थारी मेहनत जो तु दाहड़ान नेचो करे थारो योत् वाटो छे। ");
INSERT INTO dhn_vpl VALUES ("EC9_10","022_9_10","ECC","9","10","10","जो काम तुखे जड़े हेको थारी ताकोत लगाड़ीन करजी, काहकी आंधारा कुण्डा मा जासारी तु जाने वाळो छे, नी काम नी युक्ति नी गियान नी ते ओकल छे। ");
INSERT INTO dhn_vpl VALUES ("EC9_11","022_9_11","ECC","9","11","11","ओळी हांव देखीयो धरती पर जूरभरीन दवड़ने वाळो नि जीके, आरु नी ते लड़ाय मा ताकत वाळा जीके नी अकोल वाळा लोगहन क रोटा जड़े, आरु सझदार क धन, आरु नी गियान वाळा पर दया हुये, या सब टेमन हको तळे छे। ");
INSERT INTO dhn_vpl VALUES ("EC9_12","022_9_12","ECC","9","12","12","मानुस आपसी टेम क नी जानतो। जसी माछली जाळो मा फोस जाय आरु चिल्‌ला फांदे पोड़ जाय तसोत् मानुस बी दु:ख भरीया टेमो मा जो हेनु पर उचकाळुन आय पड़े, फस जाय। ");
INSERT INTO dhn_vpl VALUES ("EC9_13","022_9_13","ECC","9","13","13","हांव दाहड़ान नेचो इनीये भातीन अकोल क बी देखलो छे, जो मेखे मोटी मलम पड़ी। ");
INSERT INTO dhn_vpl VALUES ("EC9_14","022_9_14","ECC","9","14","14","एक नानलो नगर हुतो, जिनाम थुड़ांक लोगहन हुता; आरु काहलो मोटलो राजा हेको घेर लिदो, हेका विरुद मा धाड़ो बान्धीयो। ");
INSERT INTO dhn_vpl VALUES ("EC9_15","022_9_15","ECC","9","15","15","उना नानला नगर मा एक अकोल वाळो मानुस रयतो हुतो पुन गरीब हुतो, त्यो हेकी अकोल सी उना शहर क वाचाड़ लीदो। ओळी बी उना गरीब क भुल गीया। ");
INSERT INTO dhn_vpl VALUES ("EC9_16","022_9_16","ECC","9","16","16","तव हांव कयो, कदाम उना गरीब मानुसन अकोलन कोय विजूत नी करीया, हेकी वात पर धियान नी दीदा तेबी हांव कयो; ताकत सी अकोल मोटी छे। ");
INSERT INTO dhn_vpl VALUES ("EC9_17","022_9_17","ECC","9","17","17","विनअकलियान वीच मा राजा न आयेड़ने सी अकोल वाळान बुल समळी लेनो वारुछ। ");
INSERT INTO dhn_vpl VALUES ("EC9_18","022_9_18","ECC","9","18","18","लड़ायन हतियार सी अकोल वारु छे पुन एक पापी घण सवटी भलाय क नाश करे। ");
INSERT INTO dhn_vpl VALUES ("EC10_1","022_10_1","ECC","10","1","1","मरला मखड़ान कारन वारु गंधायने वाळो तेल सड़ने आरु गंधायने लाग जाय; आरु थुड़ीक डाहळाय, अकोल आरु विजुत क घटाय देय। ");
INSERT INTO dhn_vpl VALUES ("EC10_2","022_10_2","ECC","10","2","2","ओकोलवाळान मोन वारली वात भेनी लागलो रोवे पुन विनअकलियान मोन बुराय भेनी लागलो रोवे। ");
INSERT INTO dhn_vpl VALUES ("EC10_3","022_10_3","ECC","10","3","3","जव विनओकलीयो वाट्‌ये चाले ती हेका चालनेन लारेत् हेरी विनओकोल देखाय जाय। जेरेसी आखा मानसे देख लेये की त्यो विनओकलीयो छे। ");
INSERT INTO dhn_vpl VALUES ("EC10_4","022_10_4","ECC","10","4","4","कदाम तुमरा आदिकारीन रीस तुमरे पर भड़के, टी आपसो जागो झुण छुड़ता, काहकी गोम राखने सी मोटा मोटा पाप रुक जाय। ");
INSERT INTO dhn_vpl VALUES ("EC10_5","022_10_5","ECC","10","5","5","एक बुराय छे जो हांव धरती पर देखीयो, त्यो राज कोरन्यान भुल सी हये; ");
INSERT INTO dhn_vpl VALUES ("EC10_6","022_10_6","ECC","10","6","6","विनअकलीयान क उचला जागा पर बठाड़े, आरु मातभर लोगहन नेचा बठे। ");
INSERT INTO dhn_vpl VALUES ("EC10_7","022_10_7","ECC","10","7","7","हांव पावरीयान क घुल्ला पर जातला आरु आदिकारीयान क पावरीयान सारका धरती पर चालतला देखीयो। ");
INSERT INTO dhn_vpl VALUES ("EC10_8","022_10_8","ECC","10","8","8","जो खाडो खोदे त्यो उनात् मा पड़से आरु भीतड़ो तुड़े हेको घोड़सु ठुनुक देसे। ");
INSERT INTO dhn_vpl VALUES ("EC10_9","022_10_9","ECC","10","9","9","जो सेड़ान क दगड़ो हटाड़े हेको दगड़ा सी झट लागसे। आरु जो सेड़ान लाकड़ा काटे हेको हेका सी बीक लागसे। ");
INSERT INTO dhn_vpl VALUES ("EC10_10","022_10_10","ECC","10","10","10","कदाम कुलाहड़ी भटड़ी हय आरु हेकी धार क तीखी नी करे, ती तेखे काम मा लावनेम जादा ताकत लगाड़नो पड़से। पुन काम ते पुरो अकोल सी हये। ");
INSERT INTO dhn_vpl VALUES ("EC10_11","022_10_11","ECC","10","11","11","कदाम मंत्र बुलने वाला सी पेहले घोड़सु ठुनुक दी देय, ती मंत्र बुलनेवाळाक काय बी फायदो नी हये। ");
INSERT INTO dhn_vpl VALUES ("EC10_12","022_10_12","ECC","10","12","12","अकोल वाळान बुलन लारे दया हुये, पुन विनअकलियो आपसा बुलन लारे नाश हुय जाय। ");
INSERT INTO dhn_vpl VALUES ("EC10_13","022_10_13","ECC","10","13","13","हेका बुलन शुरु हुयनो विनअकोल सी, आरु हेको खतम हुयनो मोटा दु:ख सी गांडवायनो हुये। ");
INSERT INTO dhn_vpl VALUES ("EC10_14","022_10_14","ECC","10","14","14","विनकलियो घणी वातन क वदाड़ीन कये, ती कोय मानुस नी जानतो की काय हुयसे, आरु कोय देखाड़ सके कि हेको बाद मा हुयने वाळो छे? ");
INSERT INTO dhn_vpl VALUES ("EC10_15","022_10_15","ECC","10","15","15","विनअकलियान क काम करने सी थाक जाय, या तक कि त्यो नी जानतो कि नगर भेणी कसो जानो। ");
INSERT INTO dhn_vpl VALUES ("EC10_16","022_10_16","ECC","10","16","16","ए देश थारे उपर विखु जव थारो राजा पावरीयो छे आरु थारा आदिकारीया दाहड़ीन खाने पीने मा लाग जाय। ");
INSERT INTO dhn_vpl VALUES ("EC10_17","022_10_17","ECC","10","17","17","ए देश तु सयाळो छे जव थारो राजा वारला घराना माईन छे; आरु थारा आदिकारीया टेम पर खाय, आरु त्यो बी छाकने करीन नी पुन ताकत वोदाड़ने करीन। ");
INSERT INTO dhn_vpl VALUES ("EC10_18","022_10_18","ECC","10","18","18","आळसीन कारण सी घरन छत नेचो हुटपड़े आरु सुसतीन कारण सी घर चुळने लाग जाय। ");
INSERT INTO dhn_vpl VALUES ("EC10_19","022_10_19","ECC","10","19","19","लोगहन खानो खाईन खुशी मारे, आरु मोंद सी खुशी जड़े; आरु रिपिया सी सब काय जड़ जाय। ");
INSERT INTO dhn_vpl VALUES ("EC10_20","022_10_20","ECC","10","20","20","आपसा मन मा बी राजा क भुण्डलो बुल झुण कये, नी ते धनी मानुस क थार घरन कुठार मा बी भुण्डला बुल झुण कये; काहकी कोय आकाश चिल्‌ला थारा बुल क लीजात रयसे, आरु उड़ने वाळो जन्तु उनी वात क उजेन्ती कर देसे। ");
INSERT INTO dhn_vpl VALUES ("EC11_1","022_11_1","ECC","11","1","1","आपसा रोटान क पानीन ऊपर न्हाक दे, काहकी घण दाहड़ान क बाद तु हेको पछो हात करीस। ");
INSERT INTO dhn_vpl VALUES ("EC11_2","022_11_2","ECC","11","2","2","सात नी पुन आठ जना क ढासाड़ दे, काहकी तु नी जानटो की धरती पर काय पिड़ा आय पड़से। ");
INSERT INTO dhn_vpl VALUES ("EC11_3","022_11_3","ECC","11","3","3","कदाम वादळा मा पानी भरायलो छे, तव हेको धरती पर रेड़ देय; आरु झाड़का चाहे दोखेवरे पड़े या बोखेवरे पड़े तेबी जिना जागा पर झाड़ पड़से व्हान पड़ रयसे। ");
INSERT INTO dhn_vpl VALUES ("EC11_4","022_11_4","ECC","11","4","4","जो वाहळान क देखतो रयसे तेखे बीज नी वेराये, आरु जो वादळान क डेखतो रयसे तेखे काटाये नी। ");
INSERT INTO dhn_vpl VALUES ("EC11_5","022_11_5","ECC","11","5","5","जसो वाहळान चालनो वाट क नी जाने आरु काहली रीति सी भारपायेन पेटम बाळान डील वोदे, तसोत् तु परमेश्वरन काम क नी जानतो जो सब काय करे। ");
INSERT INTO dhn_vpl VALUES ("EC11_6","022_11_6","ECC","11","6","6","सोंदारे वेगोत् उठीन बीज वेर, आरु साँतो बी आपसा हात क झुण रुके; काहकी तु नी जानतो कि कुन सफल हुयसे, यो या त्यो या दुयु वारु निकळसे। ");
INSERT INTO dhn_vpl VALUES ("EC11_7","022_11_7","ECC","11","7","7","विजाळो पटे असो रये, आरु तप क देखने सी डुळान क सुक जड़े। ");
INSERT INTO dhn_vpl VALUES ("EC11_8","022_11_8","ECC","11","8","8","कदाम मानुस घणा साल तक जीवतो रये, ती हेनु आखा मा खुशी रये; पुण यो फोम राख कि आंधरला दाहड़ा बी घण सवटा रयसे। जो काय हये त्यो वायबार छे। ");
INSERT INTO dhn_vpl VALUES ("EC11_9","022_11_9","ECC","11","9","9","ए जुवानिया तारी जुवानी कुशी कर, आरु आपसी जुवानीन दाहड़ा मा खुश रय; आपसा मनन कर आरु आपसा डुळा नजरन अनसारे चाल। पुण यो जानीन रय कि इनी आखी वातन वाराम परमेश्वर थारे सी नियाव लेसे। ");
INSERT INTO dhn_vpl VALUES ("EC11_10","022_11_10","ECC","11","10","10","आपसा मन मा सी परेशानी क निकाळ दे, आरु डील मा रयीन दु:ख क दुर कर काहकी बाळपनो आरु जवानी दुयु वायबार छे। ");
INSERT INTO dhn_vpl VALUES ("EC12_1","022_12_1","ECC","12","1","1","आपसी जुवानीन दाहड़ा मा आपसा बनावने वाळा परमेश्वर क फोम राख, इना सी पेहल कि पीड़ान दाहड़ा आरु त्या साले आवे, जिनु मा तु म्हारो मन इनु मा नी लागतो। ");
INSERT INTO dhn_vpl VALUES ("EC12_2","022_12_2","ECC","12","2","2","इना सी पेहेल की दाहड़ो आरु विजाळो आरु तारागण आंधरा हुय जाय, आरु पानी पड़नेन वादळो पछो घेरु बनाय लेय; ");
INSERT INTO dhn_vpl VALUES ("EC12_3","022_12_3","ECC","12","3","3","उना दाहड़ा मा तारे घोरुन राखवाळिया कापने लागसे, आरु दात खानो चावनो छुड़ देसे, आरु खिड़कीम रयीन देखने वाळा डुळा आंधळा हुय जासे, ");
INSERT INTO dhn_vpl VALUES ("EC12_4","022_12_4","ECC","12","4","4","आरु तुमरा कानटान सोयड़ोकोन ओवाज नी सोमवाये, आरु चक्की दळनेन ओवाज धीरी हुय जासे, आरु भोळभाके चिल्लान आयेड़तात् उठ जासे, आरु सब गावने वाळान बुल कम हुय जासे। ");
INSERT INTO dhn_vpl VALUES ("EC12_5","022_12_5","ECC","12","5","5","आरु जो ऊचो रयसे वाँ चढ़ने सी तुको बीक लागसे। गाव गळी मा तु बकवादी कहवाइस आरु बादामन झाड़ फुलने लागसे, आरु टिड्या घसड़ाइन चालने लागसे, आरु भुख बढ़ने वाळो फोव पछो काम नी आवे; काहकी मानुस आपसा जलोमका घर मा जात रयसे आरु रोड़ने वाळा सयड़के-सयड़के फिरसे। ");
INSERT INTO dhn_vpl VALUES ("EC12_6","022_12_6","ECC","12","6","6","उना टेम पर चाँदीन तार दुय टुकड़ा हुय जासे आरु सोनान वाटको टुट जासे; आरु झरोन धड़े गुळो फुट जासे, आरु कुन्डा धड़े घड़घट्‌यो टुट जासे। ");
INSERT INTO dhn_vpl VALUES ("EC12_7","022_12_7","ECC","12","7","7","जव धुळू जसो हतो तसोत् धुळा मा भेसकाय जासे, आरु जीव परमेश्वरन पास मा पछी जात रयसे जो हेको आपलो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EC12_8","022_12_8","ECC","12","8","8","सभा उपदेशक यो कये, सब काय वायबार छे, सब काय वायबार छे। ");
INSERT INTO dhn_vpl VALUES ("EC12_9","022_12_9","ECC","12","9","9","सभा उपदेशक जो अकोल वाळो हुतो, त्यो लोगहन क गियान बी सिकाड़तो रयो, आरु धियान लगाड़ीन जाँची पारखीन घण सवटा सिकापन क वचन चोळदिन राखतो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EC12_10","022_12_10","ECC","12","10","10","उपदेशक मनभावे असा बुले हेरीन खरी-खरी यी छाची वात लिख दिदो। ");
INSERT INTO dhn_vpl VALUES ("EC12_11","022_12_11","ECC","12","11","11","अकोल वाळान बुले आर वाळी तिखली लाकड़ी सारका रये, आरु सभान डाहडान बुले गाड़ला खीळान सारका छे, काहकी एकुत् गुवाळ्या रयीन भेटे। ");
INSERT INTO dhn_vpl VALUES ("EC12_12","022_12_12","ECC","12","12","12","ए म्हारा पोर्या इनु मा रयीन चुकसी करनो सीक। घण सवटी किताबन लिखला काम खतम नी हुये, आरु जाडा भणन डिल काजे हरबड़ाय देय। ");
INSERT INTO dhn_vpl VALUES ("EC12_13","022_12_13","ECC","12","13","13","सब काय समळाड़ी देदो आखरी वात यी छे कि परमेश्वरन बीक मान आरु हेका हुकुम क पाळन कर; काहकी मानुसन काम योत् छे। ");
INSERT INTO dhn_vpl VALUES ("EC12_14","022_12_14","ECC","12","14","14","काहकी परमेश्वर मानुस क सब काम आरु आखी ढाकायली वातन चाहे ची वारु हय या भुण्डी, हेको नियाव करसे।");
INSERT INTO dhn_vpl VALUES ("EK1_1","027_1_1","EZK","1","1","1","ढेड़ वीस ने चोवथा मोहनान पाचवे दाहड़े, हांव बन्दियो क विच कोबार नदीन धड़े हुतो, तव् सोरोग उगड़ी गोयो, आरु हांव न परमेश्वर क दोरसोन देख्यो। ");
INSERT INTO dhn_vpl VALUES ("EK1_2","027_1_2","EZK","1","2","2","योहोयाकीन राजान बांदाय क पाचवे वोरीस क चोवथे मोहनेन पाचवे दाहड़ेन, ");
INSERT INTO dhn_vpl VALUES ("EK1_3","027_1_3","EZK","1","3","3","कोसदियो क देस मा कोबार नोंदी क धड़े, योहोवा क बुल बुजी क पुर्या योहेजकेल पुजारान यां पुग्यो: आरु योहोवा क ताकोत उना पोर उजेन्ती हुयी। ");
INSERT INTO dhn_vpl VALUES ("EK1_4","027_1_4","EZK","1","4","4","जव हांव देखने लाग्यो, ती यो देख्यो कि उत्तर भेनी आंजी उठी, आरु आगठा पुठी मोटी आँजी आवी रय, आरु उना मोटला वादळा क च्यारु मेर विजाळो छे, जेरेसी आगठो रोह-रोह कोरीन विजळी सारको चोमकी रोयो छे। ");
INSERT INTO dhn_vpl VALUES ("EK1_5","027_1_5","EZK","1","5","5","तव् आगठा मा सी चार जिवधारिया सारका काहीन निकळ्या। हेनको रुप मानसो सारको हुतो, ");
INSERT INTO dhn_vpl VALUES ("EK1_6","027_1_6","EZK","1","6","6","पुन उना मा सी होरीकोन चार‍ चार मुय आरु चार चार पाखड़ा हुता। ");
INSERT INTO dhn_vpl VALUES ("EK1_7","027_1_7","EZK","1","7","7","हेनका पाय सुदा हुता, आरु हेनका पायोन पाटल्या पाडल्यान खुर्या जोसा हुता; आरु त्या झलकायता जाईन पीतळ क जसा चमकता हुता। ");
INSERT INTO dhn_vpl VALUES ("EK1_8","027_1_8","EZK","1","8","8","हेनका च्यारु मेर पाखड़ा क नेचा मानसो सारका हात हुता। हेनका चारुन मुय आरु पाखड़ा ओसा भातीन हुता: ");
INSERT INTO dhn_vpl VALUES ("EK1_9","027_1_9","EZK","1","9","9","हेनका पाखड़ा एक दिसरा सी भेसकायला हुता; त्या आपसा आपसा अगळ सुदात चालता हुता, आरु वोवता नी हुता। ");
INSERT INTO dhn_vpl VALUES ("EK1_10","027_1_10","EZK","1","10","10","हेनका अगळ क मुयोन रुप मानसो सारको हुतो आरु हेनका च्यारो जेवड़्ये क मुय नाहरो सारको, डाख्र्‌यो क भेनी मुय बुईल सारको हुतो, आरु च्यारु क पछळ क मुय चिल्‌ला सारको हुतो। ");
INSERT INTO dhn_vpl VALUES ("EK1_11","027_1_11","EZK","1","11","11","हेनका मुय ओसाज हुता। हेनका मुय आरु पाखड़ा उपोर क भेनी ओलोग ओलोग हुता, होरीक जीवधारि क दुय दुय पाखड़ा हुता, जे एक दीसरा क पाखड़ा सी भेसकायला हुता, आरु दुय दुय पाखड़ा सी हेको डिल ढाकायलो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EK1_12","027_1_12","EZK","1","12","12","त्या सुदा आपसा आपसा अगळुत चालता हुता; जेंखेर जीव जानो चाहतो हुतो, त्या तेंखेरुत जाता हुता, आरु चालता टेमे ववता नी हुता। ");
INSERT INTO dhn_vpl VALUES ("EK1_13","027_1_13","EZK","1","13","13","जीवधारिया क रुप आगठा एने धपतली मशाल क सारको देखा पोड़तो हुतो, आरु त्यो आगठो जीवधारियो क विच एंखेर तिंखेर चालतो फिरतो मोटो विजाळो आपतो रोयो; आरु उना आगठा सी विजळी निकळी हुती। ");
INSERT INTO dhn_vpl VALUES ("EK1_14","027_1_14","EZK","1","14","14","जिवधारियोन क चालनो फिरनो विजळी सारको हुतो ");
INSERT INTO dhn_vpl VALUES ("EK1_15","027_1_15","EZK","1","15","15","जव हांव जीवधारियो क देखतोत हुतो, ती देख्यो कि धरती पोर हेनका पास च्यार मुयोन गिनायोन ओनसारे, एक एक चाकटा हुता। ");
INSERT INTO dhn_vpl VALUES ("EK1_16","027_1_16","EZK","1","16","16","चाकटा क रुपो आरु घड़ाय ओसी हुती चे सोरोगोन सोनान मणी सारकी चोमोक रोया हुता। च्यारोन बोनावट एक जोसी हुती; बोनावट ओसी हुती, मानु एक चाकटा क धड़े दिसरो चाकटो होय। ");
INSERT INTO dhn_vpl VALUES ("EK1_17","027_1_17","EZK","1","17","17","चालते टेमे त्या आपसा च्यारु मेर चाल सोकता हुता, आरु चालने मा वोवता नी हुता। ");
INSERT INTO dhn_vpl VALUES ("EK1_18","027_1_18","EZK","1","18","18","उना‍ च्यारु चाकटा क घेरवीन बेसका मोटा आरु बीहाड़े ओसा हुता, आरु हेनका घेरा मा च्यारु मेर डुळात डुळा भोरायला हुता। ");
INSERT INTO dhn_vpl VALUES ("EK1_19","027_1_19","EZK","1","19","19","जोत्यार जीवधारिया चालता हुता, तव् चाकटा वी हेनका पुठी चालता हुता; आरु जव् जीवधारिया धोरती पोर सी उठतो हुता, तव चाकटा वी उठतो हुता। ");
INSERT INTO dhn_vpl VALUES ("EK1_20","027_1_20","EZK","1","20","20","जेंखेर जीव जानो चाहेय, तेंखेरुत त्या जाता, आरु चाकटा जीवधारियो क पुठी उठतो हुता; काहकी हेनको जीव चाकटा मा हुतो। ");
INSERT INTO dhn_vpl VALUES ("EK1_21","027_1_21","EZK","1","21","21","जव त्या चालता हुता तव ये वी चालता हुता; आरु जव् जव् त्या उबा होयता हुता तव् ये वी उबा होयता हुता; आरु जव् त्या धोरती पोर सी उठतो हुता तव‍ चाकटा वी हेनका पुठी उठतो हुता; काहकी जीवधारियो क जीव चाकटा मा हुतो। ");
INSERT INTO dhn_vpl VALUES ("EK1_22","027_1_22","EZK","1","22","22","जीवधारियो क मुनका उपोर वादळा मोंडळी सारको काहीन हुतो जो बोरोफ क सारको बिहाड़े ओसो चोमेकतो हुतो, आरु त्यो हेनका मुनका उपोर वेरवायलो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EK1_23","027_1_23","EZK","1","23","23","वादळामोंडळी क नेचो, हेनका पाखड़ा एक दिसरा भेनी सुदा खोरवायला हुता; आरु होरीक एक जीवधारि क दुय दुय आरु ओवी वी पाखड़ा हुता जेरेम सी डिल ढाँकायलो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EK1_24","027_1_24","EZK","1","24","24","हेनका चालते टेमे हेनका पाखड़ा क पाखड़ान क ओवाज मेसे घोना सोटा पानी, ओळी घोनी ताकोतवाळी बुली, ओळी सेना क हालचाल सारकी समवायतली हुती; आरु जव् त्या उबा हयतला, तव् आपसा पाखड़ा टांग देता हुता। ");
INSERT INTO dhn_vpl VALUES ("EK1_25","027_1_25","EZK","1","25","25","ओळतेन हेनका मुनका उपोर जी वादळा मोंडळी हुती, हेका उपोर सी एक बुल समळाय पोड़तो हुतो; आरु जव् त्या उबा होयता हुता, तव् आपसा पाखड़ा टांग लेता हुता। ");
INSERT INTO dhn_vpl VALUES ("EK1_26","027_1_26","EZK","1","26","26","जीवधारियो क मुनका क उपोर वादळा मोंडळी हुती। हेका वादळा मोंडळी क उपोर राजगादी क सारको काहीन हुतो। यो राजगादी मानु नीलम दोगड़ा क बोनलो हुतो। राजगादी सारको एना जागा पोर कुदु बोठलो हुतो, एना पोर मानुस सारको थुड़ोक देखायतो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EK1_27","027_1_27","EZK","1","27","27","हेका कड़्याम सी लीन उपोर भेनी मेसे चोमकावला पितळ सारको देखा पोड़्यो, आरु हेका धड़े आरु च्यारु मेर आगठा सारको देखा पोड़तो हुतो; ओळतेन उना मानुस क कड़्याम सी लीन नेचो भेनी वी मेसे काहीन आगठा सारको देखा पोड़तो हुतो; आरु हेना च्यारु मेर विजाळो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EK1_28","027_1_28","EZK","1","28","28","जसो जेठवड़ीन दाहड़ा मा बाम देखाय पोड़तलो, तसोज च्यारु मेर क विजाळो देखा पड़तो हुतो। योहोवा क महिमा क रुप असोत हुतो। ओको देखीन, हांव मुयोन भुरसे हिट पोड़्यो, तव् हांव एक बुल समळ्यो जसो कुदु वात कोरतो हय। ");
INSERT INTO dhn_vpl VALUES ("EK2_1","027_2_1","EZK","2","1","1","त्यो मारती कव्यो, “हे मनख्यान ओवलियाद, आपसा पायोन भुरसे उबो होय, आरु हांव तारसी वात कोरीस।” ");
INSERT INTO dhn_vpl VALUES ("EK2_2","027_2_2","EZK","2","2","2","जसोज त्यो मारेसी यो कव्यो, तसोज जीव न मारेम सोमायीन मारा पायोन भुरसे उबो कोर देदो; आरु ज मारे सी वात कोरतो हुतो हांव ओकी समळ्यो। ");
INSERT INTO dhn_vpl VALUES ("EK2_3","027_2_3","EZK","2","3","3","त्यो मारे सी कव्यो, “हे मनख्यान ओवलियाद, हांव तुखे इसराएलियो क पास एने लोड़ाय करनेवावा मुलकोन क पास मुकलो, जे मारे विरुद लोड़ाय कोरला छे; हेनका डाहडा आरु त्या वी आज क दाहड़े लगुन मारा विरुद्ध गुनु कोरता चाल्या छे।” ");
INSERT INTO dhn_vpl VALUES ("EK2_4","027_2_4","EZK","2","4","4","एनी पीढ़ी क लोगहन जेनका पास हांव तुखे मुकलो, त्या विनलाज्या आरु एक होट्या छे; पोरबु योहोवा ओसु कोवे। ");
INSERT INTO dhn_vpl VALUES ("EK2_5","027_2_5","EZK","2","5","5","आरु तु उना सी कोहजो, पोरबु योहोवा यो कोवे छे, एना सी त्या, जे लोड़ाय कोरनेवाळा घरानान छे, चाहाय त्या समळ्या नी समळ्या, ते वी त्या ओतरा जान लेसे कि हामरा वीच एक कागळ्यो होयलो छे। ");
INSERT INTO dhn_vpl VALUES ("EK2_6","027_2_6","EZK","2","6","6","ऐ मनख्यान ओवलियाद, तु उना सी नी बिहजी; चाहाय तुके काटा, उंटकटारा आरु विछा क विच वी रोहनो पोड़े, ती वी हेनका बुल सी नी बिहनो; कोदाम त्या लोड़ायन्या घरल्यात होय, ती वी नी ते हेनका बुल सी बोहनो, आरु नी हेनका मुय देखीन तारो मोन काचो होय। ");
INSERT INTO dhn_vpl VALUES ("EK2_7","027_2_7","EZK","2","7","7","एकालिय चाहेय त्या समळे एने नी समळे; ते वी तु मारा बुल उना सी कोहनो, त्या ते मोटला लोड़ाख्या छे। ");
INSERT INTO dhn_vpl VALUES ("EK2_8","027_2_8","EZK","2","8","8","“पुन हे मनख्यान ओवलियाद, जो हांव तारेसी कोहो, हेको तु समळी ले, उना लोड़ाख्यान घरानान जोसो तु वी लोड़ाख्या नी बोननो, जो हांव तुखे आपो, हेको मुय उघाड़ीन खाय ले।” ");
INSERT INTO dhn_vpl VALUES ("EK2_9","027_2_9","EZK","2","9","9","तव हांव निंगा कोर्‌यो की आरु काय देख्यो, कि मारे भेनी एक हात मारे भेनी छे आरु उना मा एक किपात छे। ");
INSERT INTO dhn_vpl VALUES ("EK2_10","027_2_10","EZK","2","10","10","हेको त्यो मारा अगळ उघाड़ीन खवळ्यो, आरु त्या दुयो ओखे लिखली हुती; आरु जे उनामा लिखलो हुतो, त्या कालापिली एने शोक आरु दुख सी भोरायला बुल हुता। ");
INSERT INTO dhn_vpl VALUES ("EK3_1","027_3_1","EZK","3","1","1","त्यो मारेसी कव्यो, “हे मनख्यान ओवलियाद, जो तुखे जड़्यो छे हेको खाय ले; एने एनी किपात क खा, ती जाईन इसराएल क घराना सी वात कोर।” ");
INSERT INTO dhn_vpl VALUES ("EK3_2","027_3_2","EZK","3","2","2","हांव आपसो मुय उघाड़्यो, आरु त्यो मेसे खाने क लिय किपात आप्यो। ");
INSERT INTO dhn_vpl VALUES ("EK3_3","027_3_3","EZK","3","3","3","त्यो मारे सी कव्यो, “हे मनख्यान ओवलियाद, यी किपात जो हांव आपो छे ओको जिरवी ले, आरु आपसो पेट भोर ले।” एने हांव न ओको खाय लेदो; आरु मारा मुय मा त्यो भावर सारको गुळो लाग्यो। ");
INSERT INTO dhn_vpl VALUES ("EK3_4","027_3_4","EZK","3","4","4","त्यो मारे सी ओळी कव्यो, “हे मनख्यान ओवलियाद, तु इसराएल क घराना क पास जाईन हेको मारा बुल समळ। ");
INSERT INTO dhn_vpl VALUES ("EK3_5","027_3_5","EZK","3","5","5","काहकी तु काहनी कोसली बुली एने काठी बुलीवाळी जाति क पास नी मुकेलतु, पुन इसराएल क घराना क पास मुकल्यो जातो छे। ");
INSERT INTO dhn_vpl VALUES ("EK3_6","027_3_6","EZK","3","6","6","कोसली बुली एने काठी बुलीवाळी बेसकीत जाती क पास जो तारी वात समझ नी सकें, तु नी मुकलायतो। विनभुरसे कोदी हांव तुखे ओसा क पास मुकलतो ती त्या ताती समळता। ");
INSERT INTO dhn_vpl VALUES ("EK3_7","027_3_7","EZK","3","7","7","पुन इसराएल क घरानावाळा तारी समळने सी मोना कोरसे; त्या मारी वी समळने सी मोना कोरता छे; काहकी इसराएल क आखा घराना विनलाज्या आरु वातड़ा मोनोन छे। ");
INSERT INTO dhn_vpl VALUES ("EK3_8","027_3_8","EZK","3","8","8","देख, हांव तारा मुख क हेनका मुख अगळ, आरु तारा माथा क हेनान माथा क अगळ, वातड़ो मोन कोर देयो। ");
INSERT INTO dhn_vpl VALUES ("EK3_9","027_3_9","EZK","3","9","9","हांव तारा माथा क हीरा क सारको वातड़ो कोर देयो जो चकमक दोगड़ा सी वी वातड़ो होये; एकालिय तु हेना सी नी बिहजी, आरु नी हेनका मुय देखीन तारो मोन काचो होये; काहकी त्या लोड़ायन घोराना छे।” ");
INSERT INTO dhn_vpl VALUES ("EK3_10","027_3_10","EZK","3","10","10","ओळी त्यो मारे सी कव्यो, हे मनख्यान ओवळीयाद, जोतरा बुले हांव तारे सी कोहो, त्या आखा काळजा मा राख आरु कानटा सी समळ। ");
INSERT INTO dhn_vpl VALUES ("EK3_11","027_3_11","EZK","3","11","11","“आरु उना केदड़ा क पास जाईन, जे तारा मुलकोन जातिन भाईस छे, उना सी वाते कोरजी आरु कोहजी, पोरबु योहोवा ओसो कोवे छे; चाहाय त्या समळे, एने नी समळे।” ");
INSERT INTO dhn_vpl VALUES ("EK3_12","027_3_12","EZK","3","12","12","तव परमेश्वरन जीव न मेसे उठाड़्यो, आरु हांव आपसा पछळ मोटी घड़घड़ाहट क भेळ एक बुल समळ्यो हुयो कयो परमेश्वरन मोहिमा बोरकोत वावी छे। ");
INSERT INTO dhn_vpl VALUES ("EK3_13","027_3_13","EZK","3","13","13","आरु हेनका भेळुत उना जीवधारियो क पाखड़ान बुल, जो एक दिसरा सी लागला हुता, आरु उना भेळ क चाकटा क बुल आरु एक मोटी घड़घड़ाहट समळाय पोड़ी। ");
INSERT INTO dhn_vpl VALUES ("EK3_14","027_3_14","EZK","3","14","14","तव जीव मेसे उठाड़ीन ली गोय, आरु हांव काठा दुख सी भोरायलो होतो आरु मोनम धपतो जाईन चाली गुयो; आरु योहोवान ताकोत मारे मा समायली हुती; ");
INSERT INTO dhn_vpl VALUES ("EK3_15","027_3_15","EZK","3","15","15","आरु हांव उना केदड़ा क पास आया जे कोबार नोंदी क धड़े पोर तेलाबीब सोहरो मा रोहता हुता। आरु चाँ हांव सात दाहड़ा लगुन हेनका वीच दुखी होयीन बोठलु रोहु। ");
INSERT INTO dhn_vpl VALUES ("EK3_16","027_3_16","EZK","3","16","16","सात दाहड़ा वित्या ने ओळतेन पोरबु योहोवा क यो बुल मारे पास पुग्यो, ");
INSERT INTO dhn_vpl VALUES ("EK3_17","027_3_17","EZK","3","17","17","हे मनख्या क ओवलियाद, हांव न तुख इसराएल क घराना क लिय फेरा देन्याक नेवाड़ कोरलो छे। जव जव तु मारा मुय क बुल समळसे, तव तव हेनको मारा भेनी सी चेतावनी आपजी। ");
INSERT INTO dhn_vpl VALUES ("EK3_18","027_3_18","EZK","3","18","18","कदाम हांव पापी सी कोहीस, तु छाचीन मोरीस, आरु कदाम यु हेनको नी चेतावनी नी आपीस, आरु नी हेनको आपसा भुंडी वाट छुड़ने क लिय चोकचोयु कोरीस की त्या चेतावनी समळीन आपसो जीव वाचाड़ लेये, ती, हे मनख्या, समळ, त्यो पापी आपसा भुडा कामो क लिदे ते मोरसेत, पुन हांव हेकी मोत क गुनु तारे सी लेखो लीस। ");
INSERT INTO dhn_vpl VALUES ("EK3_19","027_3_19","EZK","3","19","19","पुन कदाम तु पापीक चेतावनी आपे, आरु त्यो आपसा भुंडा काम आरु भुंडी वाट सी नी फीरे, ती त्यो ते आपसा भुंडा काम मा फोसलो होईन मोर जासे; पुन तु आपसा जीव क वाचाड़ीस। ");
INSERT INTO dhn_vpl VALUES ("EK3_20","027_3_20","EZK","3","20","20","ओवी जव धोरमी लोगहन धोरोम सी फिरीन कुटिल काम कोरने लागे, आरु हांव हेनका अगळ ठुकर राखो, ती त्यो मोर जासे, काहकी तुन जो हेको नी चेतावनी आप्यो, एकालिय त्यो आपसा पाप मा फोसलो होईन मोरसे; आरु जे धोरोम क काम त्यो कोरलो होय, हेनो फोम नी राख्यो जासे, पुन हेनका लुहुय क लेखो हांव तारेसी लीस। ");
INSERT INTO dhn_vpl VALUES ("EK3_21","027_3_21","EZK","3","21","21","पुन कदाम तु धोरमी क असो कोविन चेतावनी आपे, की त्यो पाप नी कोरे, आरु त्यो पाप सी वाच जाय, ती त्यो चेतावनी क मानने क कारण छाचिन जिवतलो रोहसे, आरु तु आपसो जीव क वाचाड़ीस। ");
INSERT INTO dhn_vpl VALUES ("EK3_22","027_3_22","EZK","3","22","22","पोरबु योहोवा क ताकोत मारे पोर होयी, आरु त्यो मारे सी कव्यो, “उठीन खयड़ा मा जा; आरु चां हांव तारे सी वात कोरीस।” ");
INSERT INTO dhn_vpl VALUES ("EK3_23","027_3_23","EZK","3","23","23","तव हांव उठीन खयड़ा मा गुयो, आरु चाँ काय देख्यो, कि योहोवा क सेक जसो मेसे कोबार नदीन धोड़े, तसोज याँ वी देखा पोड़तो छे, आरु हांव मुयोन भुरसे हिट पोड़यो। ");
INSERT INTO dhn_vpl VALUES ("EK3_24","027_3_24","EZK","3","24","24","तव जीव न मारेम सोमायीन मेसे पायोन भुरसे उबो कोर देदो; ओळी त्यो मारे सी कोहने लाग्यो, जा आपसा घर क धड़े झपला बोंद कोरीन बठलो रोव। ");
INSERT INTO dhn_vpl VALUES ("EK3_25","027_3_25","EZK","3","25","25","हे मनख्यान ओवलियाद, देख, त्या लोगहन तुखे दुयड़ा सी हापकीन बाँदिन राखसे, आरु तु निकळीन हेनका वीच नी जावाये। ");
INSERT INTO dhn_vpl VALUES ("EK3_26","027_3_26","EZK","3","26","26","हांव तारी जीप तारा तालु सी लागाड़ीस; जेरेसी तु हुगु रोहिन हेनको लोड़नेवाळा नी होय, काहकी त्या लोड़ायन्या घोरानान छे। ");
INSERT INTO dhn_vpl VALUES ("EK3_27","027_3_27","EZK","3","27","27","पुन जव जव हांव तारे सी वात कोरो, तब तब तारा मुय क उघाड़िस, आरु तु उना सी असो कोहजी, पोरबु योहोवा असो कोवे छे, तु समळतो छे त्यो समळी ले आरु नी जो नी समळतो त्यो नी समळे, त्या ते लोड़ायन घराना छेत। ");
INSERT INTO dhn_vpl VALUES ("EK4_1","027_4_1","EZK","4","1","1","हे मनख्यान ओवलियाद, तु एक इटड़ो चुट ले, आरु हेको आपसा अगळ मेक। ऐरे वाद, तु उना पोर योरुसालेम सोहोर क एक चित्र खींच ले; ");
INSERT INTO dhn_vpl VALUES ("EK4_2","027_4_2","EZK","4","2","2","तव हेको च्यारु मेर सी घेरवीन हेका विरुद्ध किलो बोनाव आरु हेका अगळ दमदमा बोंदा: आरु छावनी नाख, आरु हेका च्यारु मेर लोड़ायन तियारी लागाड़। ");
INSERT INTO dhn_vpl VALUES ("EK4_3","027_4_3","EZK","4","3","3","तव तु लुहड़ान तोवी लीन हेको लुहड़ा क भितड़ो मानीन आपसा आरु हेका सोहोर क वीच उबो कोर, तव आपसा मुय हेका अगळ कोरीन हेकी घेराबोन्दी कोर, एने रीते सी तु हेको घेरवीन राखजी। यो इसराएल क घराना क लिय सोहलानी कोवायसे। ");
INSERT INTO dhn_vpl VALUES ("EK4_4","027_4_4","EZK","4","4","4","ओळी तु डाखरे कोड़ दीन इसराएल क घराना क ओधोरोम आपसा उपोर मेक, काहकी जोतरा दाहड़ा तु उना कोड़ लुटलु रोहिस, तोतरा दाहड़ा लगुन उना लोगहन क ओधोरोम क भार वेठतो रोहीस। ");
INSERT INTO dhn_vpl VALUES ("EK4_5","027_4_5","EZK","4","5","5","हांव न हेनका ओधोरोम क साल क सारका तारे लिय दाहड़ा टाकला छे, एने तीन सोव नब्बे दाहड़ा; होतरा दाहड़ा लगुन तु इसराएल क घोराना क ओधोरोम क भार वेठतो रोव। ");
INSERT INTO dhn_vpl VALUES ("EK4_6","027_4_6","EZK","4","6","6","जव ओतरा दाहड़ा पुरा होय जाय, तव तु जेवड़ु कोड़ दीन योहुदा क घराना क ओधोरोम क भार वेठ लेजो; हांव हेनका लिय वी आरु तारे लिय एक सोव वरीस क बोदले एक दाहड़ु एने चाळीस दाहड़ा टाकला छे। ");
INSERT INTO dhn_vpl VALUES ("EK4_7","027_4_7","EZK","4","7","7","तु योरुसालेम क घेरवने क लिय हात उघाड़ीन आपसो मुय ओथू कोरिन हेनका विरुद्ध भोगवानो वोगे गोथी वात कोरजी। ");
INSERT INTO dhn_vpl VALUES ("EK4_8","027_4_8","EZK","4","8","8","देख, हांव तुसे दुयड़ा सी बाँदिस, आरु जव लगुन हेको घेरवनेन दाहड़ा पुरा नी होये तव तक तु कोड़ नि ली सोकीस। ");
INSERT INTO dhn_vpl VALUES ("EK4_9","027_4_9","EZK","4","9","9","तु गँहव, जोव, सेम, मसुर, बाजरा, आरु कठिया गँहव, लीन एक टाहरा मा मेकीन उनासी रुटा बनवाड़्या कोरजो। जोतरा दाहड़ा तु कोड़ पोर लुटलो रोहिस, तोतरा दाहड़ा तीन सोव नब्बे दाहड़ा लगुन हेको खाया कोरजो। ");
INSERT INTO dhn_vpl VALUES ("EK4_10","027_4_10","EZK","4","10","10","जो भोजन तु खासे, हेको तुल तुलीन खाजी, एने दाहड़ीन एक पाव भोरीन खाया, आरु हेको टेम टेम पोर खानो। ");
INSERT INTO dhn_vpl VALUES ("EK4_11","027_4_11","EZK","4","11","11","तु पानी वी मापीन पीजी; एने एक लिटर। तु पानी वी टाकला टेमो मा पीजी। ");
INSERT INTO dhn_vpl VALUES ("EK4_12","027_4_12","EZK","4","12","12","जसो जोव क रुटा खाया जाये छे तसोज तु आपसा रुटा खाने। तु हेको मानसोन हागारोन कण्डा पोर लोगहन क डुला क अगळ सेकजो। ");
INSERT INTO dhn_vpl VALUES ("EK4_13","027_4_13","EZK","4","13","13","योहोवा न कव्यो, ओस कोरीन इसराएल उना जातियो क विच आपसा आपसा रुटा दुर होयला सी खाया कोरसे, जाँ हांव हेको जोबरोन पुगाड़ीस। ");
INSERT INTO dhn_vpl VALUES ("EK4_14","027_4_14","EZK","4","14","14","तव हांव न कव्यो, हाय, योहोवा परमेश्वर देख, मारो मोन कोदी विटळ नी हुयो, आरु नि ते मारा बचपन सी लीन हेमी लगुन आपसी मोत सी मोरीयाम एने फाड़ला ढुरोन मास खादो, आरु नी कुदा भातीन मांस मारा मुयोम कोदी गोयो छे। ");
INSERT INTO dhn_vpl VALUES ("EK4_15","027_4_15","EZK","4","15","15","पोरबु मारे सी कव्यो, वारु तारी विनता मेसे स्वीकार छे। तु मानसोन हागारोन कण्डान जागा पोर गाय क गुबर क कण्डा पोर आपसा रुटा सेकनो। ");
INSERT INTO dhn_vpl VALUES ("EK4_16","027_4_16","EZK","4","16","16","पोरबु न मारे सी यो वी कोव्यो, हे मनख्यान ओवलियाद, देख, हांव योरुसालेम मा खानो पानीन आसरा काजे छेटो कोरीस; एकालिय चाँ क लोगहन तुल तुलीन आरु फिकुर कोर कोरीन रुटा खाया कोरसे; आरु माप मापीन आरु दुखी होईन पानी पिया कोरसे। ");
INSERT INTO dhn_vpl VALUES ("EK4_17","027_4_17","EZK","4","17","17","आरु एना सी हेनका रुटा आरु पानीन घटि होयसे; आरु त्या आखा की आखा घाबरायसे, आरु आपसा ओधोरोम मा फोसलो हुया सुख जासे। ");
INSERT INTO dhn_vpl VALUES ("EK5_1","027_5_1","EZK","5","1","1","हे मनख्यान ओवलियाद, एक निसानली तलवार ले, आरु हेको नावटान सारको पावड़ान काम मा लावीन आपसा मुनका आरु दाड़ी क झटा बुड़ नाख, तव तुलनेन काटो लीन छटान वाटो पाड़। ");
INSERT INTO dhn_vpl VALUES ("EK5_2","027_5_2","EZK","5","2","2","जव सोहोर क घेरवनेन दाहड़ा पुरा होये, तव सोहोर क धड़े एक तीहाई आगठा मा नाखिन धपाड़जी, आरु एक तिहाई क वाहवा मा उड़ावजी, आरु हांव तलवार हापकिन ओका पछळ चालाड़ीस। ");
INSERT INTO dhn_vpl VALUES ("EK5_3","027_5_3","EZK","5","3","3","तव इना मा सी इतराकसा झटा लीन आपसा छिंदरान कुरे बांदजी। ");
INSERT INTO dhn_vpl VALUES ("EK5_4","027_5_4","EZK","5","4","4","ओळी एनु मा सी इतराक सा लीन आगठा क वीचमा नाखजी कि त्या आगठा मा धप जाय, तव ओकाज मा सी एक भपकु भड़कीन इसराएल क आखा घराना मा जात रोहसे। ");
INSERT INTO dhn_vpl VALUES ("EK5_5","027_5_5","EZK","5","5","5","हे पोरबु योहोवा ओसो कोवे छे: योरुसालेम ओसोज छे; हांव न हेको दिस रादेसोन क विच मा मेकलो, आरु त्या च्यारु धड़े देसो सी घिरायला छे। ");
INSERT INTO dhn_vpl VALUES ("EK5_6","027_5_6","EZK","5","6","6","त्यो मारा कायदा क विरुद काम कोरीन दिसरा मुलको सी जादा पाप कोर्या, आरु मारा कायदा क विरुद च्यारु धड़े क देसो क लोगहन सी जादा गुनु कोरला छे; काहकी त्या मारा कायदा क तुच्छ जान्या, आरु त्या मारी विधियो पोर नी चाल्या। ");
INSERT INTO dhn_vpl VALUES ("EK5_7","027_5_7","EZK","5","7","7","ओतरा कोरीन पोरबु योहोवा ओसो कोवे छे: तुमु लोगहन जे आपसा च्यारु धड़ेन जातियो सी जादा हुल्लड़ कोरे, आरु नी मारी विधियो पोर चालता, नी मारा कायदा क मानता आरु आपसा‍ च्यारु धड़ेन जातियो क कायदान ओनसारे वी नी कोर्या, ");
INSERT INTO dhn_vpl VALUES ("EK5_8","027_5_8","EZK","5","8","8","ओस कोरीन पोरबु योहोवा ओसो कोवे छे: देख, हांव आपसोज तारे विरुद्ध छे; आरु दिसरी जातियो क देखता हांव तारे वीच नियाय क काम कोरीस। ");
INSERT INTO dhn_vpl VALUES ("EK5_9","027_5_9","EZK","5","9","9","तारा आखा भुंनला कामो न कोरता हांव तारे वी ओसो कोरीस, जसो हेमी लगुन नी कोर्‌यो, आरु नी ओगो ओळी कोरीस। ");
INSERT INTO dhn_vpl VALUES ("EK5_10","027_5_10","EZK","5","10","10","एकालिय तारा विच पुर्या आपसा आपसा बास क, आरु बास आपसा आपसा पुर्यान मांस खासे; आरु हांव तुखेक डोन आपीस, ओवी जे मानसे वाच जासे, तिनुक हांव च्यारु मेर रिवन्या तिवन्या कोर दिस। ");
INSERT INTO dhn_vpl VALUES ("EK5_11","027_5_11","EZK","5","11","11","आरु पोरबु योहोवा न यो बुल छे, कि मारा जीवन नु कोसोम, एकालिय कि तु न मारा चुखला जागा क आपसा आखा भुंनला मुरती आरु आखा भुनला कामो सी विटळ कोरलो छे, हांव तुख घोटाड़ीस, आरु तारे पोर दोयान निंगा नी कोरीस, आरु तारे पोर काहिन वी गीन नी कोरीस। ");
INSERT INTO dhn_vpl VALUES ("EK5_12","027_5_12","EZK","5","12","12","तारी एक तिहाई ते मोरली सी मोरसे, आरु तारा वीच भुख सी मोर मिटसे; एक तिहाई तारे आड़े धड़े तलवार सी मार्या जासे; आरु एक तिहाई क हांव च्यारु मेर तितर बितर कोरीस आरु तलवार हापकीन हेनका पछळ चालाड़ीस। ");
INSERT INTO dhn_vpl VALUES ("EK5_13","027_5_13","EZK","5","13","13","ओस कोरीन मारी रीस कोम होयसे, आरु आपसी रीस उना पोर आखी भड़कावीन मेसे शांती जोड़से; आरु जव हांव आपसी जलजलाहट उना पोर पुरी रिती सी भोड़की पोड़ीस, तव त्या जान लेसे कि हांव योहोवात न जलन मा आवीन यो कोवलु छे। ");
INSERT INTO dhn_vpl VALUES ("EK5_14","027_5_14","EZK","5","14","14","हांव तुख च्यारु धड़ेन मुलुकोन वीच, आखा आवने जाने वाळा देखतात उजाड़ीस, आरु तारी नावधराई कोरावीस। ");
INSERT INTO dhn_vpl VALUES ("EK5_15","027_5_15","EZK","5","15","15","“ओतरान कोरीन जव हांव तुसे रीस आरु रिसवाईन आरु बेसका तिखा रीसो भेळ डोन आपीस, तव तारा च्यारु मेर क जाती क अगळ नावधराई, ठट्ठा, भनाय, आरु भंगलाय होयसे, काहकी हांव योहोवा न यो कोहलो छे। ");
INSERT INTO dhn_vpl VALUES ("EK5_16","027_5_16","EZK","5","16","16","यो उना टेम मा होयसे, जव हांव उना लोगहन क नास कोरने क लिय तुमरे पोर बेसको तीखा तीर चालाड़ीस, तुमरे वीच काळ वोदाड़ीस, आरु तुमरा ओनोन काळ एने खाने काय नी जोड़से। ");
INSERT INTO dhn_vpl VALUES ("EK5_17","027_5_17","EZK","5","17","17","हांव तुमरा वीच काळ आरु जोंगली जोनवारे मुकलीस जे तुमुक विन ओवलियाद कोरसे; आरु मरी आरु लुहुय तुमरा वीच चालतो रोहसे; आरु हांव तुमरे पोर तलवार चालाड़ माँगीस, मेसे योहोवा न ओसो कोयो छे।” ");
INSERT INTO dhn_vpl VALUES ("EK6_1","027_6_1","EZK","6","1","1","ओळी योहोवा क यो बुल मारे यां पुग्यो: ");
INSERT INTO dhn_vpl VALUES ("EK6_2","027_6_2","EZK","6","2","2","“हे मनख्यान ओवलियाद, आपसो मुय इसराएल क बोयड़ा क भेनी कोरीन हेका विरुद्ध नबुवत कोर, ");
INSERT INTO dhn_vpl VALUES ("EK6_3","027_6_3","EZK","6","3","3","आरु कय, हे इसराएलन बयड़ा, पोरबु योहोवा क बुल समलु! पोरबु योहोवा टेकड़ा आरु बोयड़ा सी, आरु नाळा आरु घाटी गोथु ओसु कोवे: देखु, हांव तुमरे पोर तलवार चालाड़ माँगीस, आरु तुमरा पुजा क उँचा जागा क नास कोरीस। ");
INSERT INTO dhn_vpl VALUES ("EK6_4","027_6_4","EZK","6","4","4","तुमरी वेदी उजड़से आरु तुमरा दाहड़ान मुरतिया तुड़ाय जासे; आरु हांव तुमरे मा सी मोरला माईन क तुमरा मुरत्यांन अगळ नाख दीस। ");
INSERT INTO dhn_vpl VALUES ("EK6_5","027_6_5","EZK","6","5","5","हांव इसराएलियो क शव क हेनकी मुरतियो क अगळ मेकीस, आरु हेनका हाड़का क तुमरा वेदियो क आड़े धोड़े वेरवी दिस। ");
INSERT INTO dhn_vpl VALUES ("EK6_6","027_6_6","EZK","6","6","6","तुमरा जोतरा बोसाड़ला सोहोर छे, त्या आखा ओसा उजाड़ जासे, कि तुमरा पुजान उँचा जागा वी उजाड़ होय जासे, तुमरा वेदियाँ उजड़ी जासे आरु हिट पाड़से, तुमरा मुरतिया जात रोहसे आरु तुमरा दाहड़ान मुरतिया काटाय जासे: आरु तुमरी आखी कारीगरी मिटाय जासे। ");
INSERT INTO dhn_vpl VALUES ("EK6_7","027_6_7","EZK","6","7","7","तुमरे वीच मोरलात पोड़से, आरु तुमु जान लेसु कि हांव योहोवा छे।” ");
INSERT INTO dhn_vpl VALUES ("EK6_8","027_6_8","EZK","6","8","8","“ती वी हांव कोतोरक वाचाड़ीन राखीस। एकालिय जव तुमु देस देस मा खोरवाय जासु, तव मुलको मुलकोनक वीच तुमरा काहीन लोगहन तलवार सी वाच जासे। ");
INSERT INTO dhn_vpl VALUES ("EK6_9","027_6_9","EZK","6","9","9","त्या वाचला लोगहन, उना जातियो क विच, जेनुमा त्या बाँदाय होय जासे, मेसे फोम कोरसे; आरु यो वी कि हामरो व्यभिचारी काळजो योहोवा सी कोसो छेटो गयलो छे, आरु व्यभिचारीणी सारकी हामरा डुळा मुरतीयो पोर कोसी लागली छे, जेरेसी योहोवा क मोन टुटलो छे। एने रिते सी उना भुंनला कारण, जो त्या आपसा आखा भुनला काम कोरीन कोरला छे, त्या आपसा निंगा मा भुंनला कोहायसे। ");
INSERT INTO dhn_vpl VALUES ("EK6_10","027_6_10","EZK","6","10","10","तव त्या जान लेसे कि हांव योहोवा छे, आरु हेनकी आखी नुकसानी कोरने क हांव जो यो कोयो छे। चो वायेत नी कोयो।” ");
INSERT INTO dhn_vpl VALUES ("EK6_11","027_6_11","EZK","6","11","11","पोरबु योहोवा ओसो कोवे छे: “आपसा हात मारीन आपसा पाय नाखीन कोह, इसराएल क घोराना क आखा भुंनला कामो पोर थु! थु! काहकी त्या तलवार, भुख, आरु मोरी सी नास होय जासे। ");
INSERT INTO dhn_vpl VALUES ("EK6_12","027_6_12","EZK","6","12","12","जो छेटो होय त्यो मोरीस सी मोरसे, आरु जो धड़े होय त्यो तलवार सी मार नाख्यो जासे: आरु जो वाचीन सोहोर मा रोहता होईन घेरो जाय, त्यो भुकलोत मोरसे। ओस करीन हांव आपसी जलजलाहट उना पोर आखे रीते सी उतारीस। ");
INSERT INTO dhn_vpl VALUES ("EK6_13","027_6_13","EZK","6","13","13","जव होर एक उचा बोयड़ा आरु बोयड़ा क होर एक चोटी पोर, आरु होर एक निळा झाड़ क नेचा, आरु होर एक जादा अंजीर झाड़न साहवा मा, जाँ जाँ त्या आपसी आखी मुरत क सुखदायक गंदायन्या तेल चोड़ावे छे, चाँ हेनका मोरला लोगहन आपसी वेदी क आड़ेधोड़े आपसी मुरत क विच मा पोड़ रोहसे; तव तुमु लोगहन जान लेसु की हांव योहोवा छे। ");
INSERT INTO dhn_vpl VALUES ("EK6_14","027_6_14","EZK","6","14","14","हांव आपसा हात हेनका विरुद्ध वोदाड़ीन उना देस क आखा घोरो भेळ जोंगोल सी लीन रिबला सोहोर लोगुन उजाड़ कोर दिस। तव त्या जान लेसे कि हांव योहोवा छे।” ");
INSERT INTO dhn_vpl VALUES ("EK7_1","027_7_1","EZK","7","1","1","पोरबु योहोवा क यो बुल मारे पास पुग्यो, ");
INSERT INTO dhn_vpl VALUES ("EK7_2","027_7_2","EZK","7","2","2","“हे मनख्यान ओवलियाद, समळ। पोरबु योहोवा इसराएल क धोरतीन वाराम ओसो कोवे छे: कि नास हुयो; च्यारु खुना भेळ देस क नास आय गयलो छे। ");
INSERT INTO dhn_vpl VALUES ("EK7_3","027_7_3","EZK","7","3","3","ए इसराएल, सोमोव। तारो चेहलो वी आय गयो आरु हांव आपसा रीस तारे पोर भड़काविन तारा चालचालोन ओनसारे तुसे डोन आपीस; आरु तारा आखा भुंनला कामोन फोव तुसे आपीस। ");
INSERT INTO dhn_vpl VALUES ("EK7_4","027_7_4","EZK","7","4","4","मारी गिनोन निंगा तारे पोर नी होयसे, आरु नी हांव गीन नी कोरो, आरु जव लगुन तारा भुंनला पाप तारेम बोनला रोहसे तव लगुन हांव तारा चालचलन क फोव तुसे आपीस। तव जान लेसे कि हांव योहोवा छे। ");
INSERT INTO dhn_vpl VALUES ("EK7_5","027_7_5","EZK","7","5","5","“पोरबु योहोवा ओसो कोवे छे: पिड़ा क वाद पिड़ा! देख, तारे पोर पीड़ा आवे छे। ");
INSERT INTO dhn_vpl VALUES ("EK7_6","027_7_6","EZK","7","6","6","चेहलो आय गयलो छे, आखान चेहलो आवलो छे; त्यो तारे विरुद्ध जागलो छे। देखु, त्यो आवेत। ");
INSERT INTO dhn_vpl VALUES ("EK7_7","027_7_7","EZK","7","7","7","हे देसम रोहन्या, तारे लिय चक्र फिर चुक्यो, टेम आय गयो, दाहड़ा धड़े छे; बोयड़ा पोर खुशीन बुलन दाहड़ा नी, हुल्लड़न होयसे।” ");
INSERT INTO dhn_vpl VALUES ("EK7_8","027_7_8","EZK","7","8","8","हेमी थुड़ाक दाहड़ा मा हांव आपसी जलजाहट तारे पोर भोड़कावीस, आरु तारे फोर आखो कोप उथलावीस आरु तारा चालचलन ओनसारे तुखे डोन आपीस। तारा भुंनला कामोन फोव तुसे भुगताड़ीस। ");
INSERT INTO dhn_vpl VALUES ("EK7_9","027_7_9","EZK","7","9","9","मारी गिनोन निंगा तारे पोर नी होयसे आरु नी हांव तारे पोर गीन नी कोरीस हांव तारा चालचलन क फोव तुसे भुगताड़ीस, आरु तारा भुंनला पाप तारे मा बोनला रोहसे। तव तुमु जान लेसु कि हांव योहोवा डोन आपने वाळो छे। ");
INSERT INTO dhn_vpl VALUES ("EK7_10","027_7_10","EZK","7","10","10","“देखु, उना दाहड़ा, त्या आवेत छे! चक्र फिर चुक्यो, लाकुड़ फुग गोय, डाहवाय फुलो छे। ");
INSERT INTO dhn_vpl VALUES ("EK7_11","027_7_11","EZK","7","11","11","लोड़ाय वोदती वोदती पापोन डोन बोन गुयो; उना मा सी काहीन नी वाचसे, आरु निजी हेनकी गोड़दी, नी हेनका धोन मा सी काहिन रोहसे: आरु नी उना मा सी कुदान लिय विलाप समळाय से।” ");
INSERT INTO dhn_vpl VALUES ("EK7_12","027_7_12","EZK","7","12","12","टेम आय गुयो, दाहड़ा धड़े आय गुया छे; नि ते मुले लेनेवाळा खुशी कोरे आरु नी वेचने वाळा शोक कोरे, काहकी हेनकी आखी गोड़दी पोर रीस भोड़की उठलो छे। ");
INSERT INTO dhn_vpl VALUES ("EK7_13","027_7_13","EZK","7","13","13","चाहाय त्या जिवतला रोहे, तेवी वेचायली चिज क पास कोदी पोछो नी जोड़से; काहकी दर्शन नी यी वात देसन आखी गोड़दी पोर घोटसे, कुदु नी पोछो आवसे; कुय वी मानुस जो ओधोरोम मा जिवतला रोहे छे, ताकोत नी धोर सोकसे। ");
INSERT INTO dhn_vpl VALUES ("EK7_14","027_7_14","EZK","7","14","14","“त्या नरसिंगा फुँक्या आरु आखो काहीन तियार कोर देदो; पुन लोड़ाय मा कुय नी जातो काहकी देसन आखी गोड़दी पोर मारी रीस भोड़की छे।” ");
INSERT INTO dhn_vpl VALUES ("EK7_15","027_7_15","EZK","7","15","15","“सोहोरोन खोयड़े वेरीन तलवार टांगाय रोय, आरु सोहोर क धड़े महामारी एने काळन साहळो छे। जे सोहोर क खयड़े खयड़ा मा छे, त्या वेरीन तलवार सी मोत क घाट उतार जातो छे: आरु जे सोहोर क धोड़े छे, हेनको महामारी आरु काळ खाय जाये छे। ");
INSERT INTO dhn_vpl VALUES ("EK7_16","027_7_16","EZK","7","16","16","जे मानसे तलवार, महामारी आरु काळ सी वाच जाता छे, त्या बोयड़ा पोर ढास जाता छे। ये वाचला लोगहन ओसा छे मानु घाटो रोहनेवाळा पेरवा। होरीक वाचला मानसे आपसा आपसा ओधोरोम क लिय शोक मोनाय रोया छे। ");
INSERT INTO dhn_vpl VALUES ("EK7_17","027_7_17","EZK","7","17","17","हेनका हात मा ताकोत नि रोयो। बिक सी हेनका पाय कोमजुर छे; ");
INSERT INTO dhn_vpl VALUES ("EK7_18","027_7_18","EZK","7","18","18","त्या पोसतावो करने क लिय कोड़्या मा गोंटान छिंदरा पेहरीन। आतंक न हेनको ढाक लेदो छे। हेनका चेहरा सी ग्लानी टोपोक रोय। हेनका पोसतावान कारन आपसा मुनका क बुड़ देसे। ");
INSERT INTO dhn_vpl VALUES ("EK7_19","027_7_19","EZK","7","19","19","त्या आपसी चाँदी वाटो मा नाख देसे, आरु हेनका सोना विटळ कोहायसे; योहोवा क जलन क दाहड़ा हेनका सोना चाँदि हेनको नी वाचाड़से, नी उनासी उनाक जिव निरसो होयसे, नी हेनको पेट भोरायसे। काहकी त्या हेनका ओधोरोम क ठुकर क कारण होयला छे। ");
INSERT INTO dhn_vpl VALUES ("EK7_20","027_7_20","EZK","7","20","20","झुटा शान-सोकत क लिय त्या एना सोना चाँदी क गोहना बोनावता हुता। सोना-चाँदि सीत त्या घाड़ायीन मुरतिया आरु दिसरा घाड़ायन चिजे बोनावला हुता, एकालिय हांव एना सोना चाँदि क विटळ चिज बोनाय दिस, ओतरान कोरता हांव हेन्दरे जुगु विटोव चिज मेकीस। ");
INSERT INTO dhn_vpl VALUES ("EK7_21","027_7_21","EZK","7","21","21","“हांव यो सोनो चाँदि पारकान हातोम लुटोन रुप मा आप दिस। आखी कळी क भुण्डला हको लुट लेसे आरु सोना चाँदीन मुरतिया क विटोळ कोर देसे। ");
INSERT INTO dhn_vpl VALUES ("EK7_22","027_7_22","EZK","7","22","22","ओतरोत नी, हांव उनासी आपसो मुय फेरवी लीस, ताकि विधर्मी मारा मन्दिर रुपी भंडारन जागा मा भोरायसे, आरु हेको विटोळ कोर देसे। ");
INSERT INTO dhn_vpl VALUES ("EK7_23","027_7_23","EZK","7","23","23","“त्या हेको खाली कोर देसे। आखा देस आरु योरुसालेम सोहोर लुहुयवाळो आरु लोड़ायन्या कामोन सी भोराय गुयो छे। ");
INSERT INTO dhn_vpl VALUES ("EK7_24","027_7_24","EZK","7","24","24","एकालिय हांव राजोम आखा भुनला मुलुक क भोड़कावीस कि त्या इसराएल पोर लोड़ाय कोरे। त्या आवसे, आरु इसराएलियो क घोरो पोर होक कोर लेसे। ओसो हांव हेन्दरी मोटाय घाड़ाय क धुळा मा मिलाय दीस, आरु हेनका चुखलो जागो विटोळ होय जासे। ");
INSERT INTO dhn_vpl VALUES ("EK7_25","027_7_25","EZK","7","25","25","सत्यनास होयने पोर छे, तव हेरने पोर वी हेनको शांती नी जोड़से। ");
INSERT INTO dhn_vpl VALUES ("EK7_26","027_7_26","EZK","7","26","26","पिड़ा पोर पीड़ा आवसे आरु उड़ती जाईन वातो पोर वात समवायसे; आरु लोगहन कागळीया सी दर्शन नी वात पुछसे, पुन पुजारा क पास सी वेवोस्थान, आरु डाहलाक पास सी सम्मति आपनेन ताकोत जाती रोहसे। ");
INSERT INTO dhn_vpl VALUES ("EK7_27","027_7_27","EZK","7","27","27","राजा ते शोक कोरसे, आरु रईस उदास सारको छिंदरा पेहरसे, आरु देस क लोगहन क हाथ ढिला पोड़से। हांव हेनका चलन क ओनसारे हेनाका सी वेवहार कोरीस, आरु हेनकी कोमाय क सारको हेको डोन आपीस; तव त्या जान लेसे कि हांव योहोवा चे।” ");
INSERT INTO dhn_vpl VALUES ("EK8_1","027_8_1","EZK","8","1","1","ओळी छोटवे वरीस क छोटवे मोहनान पाँचवे दाहड़े को जोत्यार हांव आपसा घोर मा बठ्यो हुतो, आरु यहुदियो क डाहला मारे अगळ बोठला हुता। तेने टेमे पोरबु योहोवान ताकोत मारेम आवी। ");
INSERT INTO dhn_vpl VALUES ("EK8_2","027_8_2","EZK","8","2","2","तव हांव देख्यो कि आगठा सारको एक रुप देखा पोड़्यो, हेको कोड़्या सी नेचले धोड़े आगठो छे, आरु हेका कोड़्या सी उपोर पीतळ सारको चोमकी रोयो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EK8_3","027_8_3","EZK","8","3","3","त्यो हात ओगो कोरीन मारा मुनकान झोटा धोरियो; आरु जीव न मेसे कळी आरु वादळा क विच मा चुटीन परमेश्वर को देखाड़ला दोरसोन मा योरुसालेम क मन्दिर क धड़े, आँगना क उना झोपला क धोड़े पुगाड़ देदा जेरो मुय बोखेवरे भेनी छे; आरु जिनामा उना घाड़ायीन मुरती को जागो हुतो हेका कारण सी घाड़ाय जागे। ");
INSERT INTO dhn_vpl VALUES ("EK8_4","027_8_4","EZK","8","4","4","ओळी चाँ इसराएल क परमेश्वर क सेक तसोज हुतो जसो हांव कोबार नोंदीन कातरे देख्यो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EK8_5","027_8_5","EZK","8","5","5","त्यो मार सी कयो, “हे मानुसोन ओवलियाद, आपसा डुळा बोखेवरे भेनी देख।”अत: हांव आपसा डुळा बोखेवरे भेनी कोरीन देख्यो कि वेदी क झपला क बोखेवरे भेनी उना भोरायनीया झोपला मात त्यो घाड़ायन मुरती बोनायो। ");
INSERT INTO dhn_vpl VALUES ("EK8_6","027_8_6","EZK","8","6","6","तव त्यो मार सी कयो, “हे मानुस नी ओवलियाद, काय तु देखे छे कि ये काय कोर रोया? इसराएल क घोराना कायत मोटा घाड़ायीन काम याँ कोरतला, कि हांव आपसा चुखला जागा सी छेटा होय जाम; पुन तु एना सी वी जादा घाड़ायीन काम देखसे।” ");
INSERT INTO dhn_vpl VALUES ("EK8_7","027_8_7","EZK","8","7","7","तव त्यो मेसे आँगना क झपला पोर ली गुयो, आरु हांव देख्यो, कि भितड़ा मा एक डुचो छे। ");
INSERT INTO dhn_vpl VALUES ("EK8_8","027_8_8","EZK","8","8","8","तव त्यो मार सी कयो, “हे मानुस नु ओवलियाद, भीतड़ाक फुड़,” एकालिय हांव भितड़ा क फुड़ीन काय देख्या की एक झपलो छे। ");
INSERT INTO dhn_vpl VALUES ("EK8_9","027_8_9","EZK","8","9","9","त्यो मार सी कयो, “धड़े जाईन देख कि ये लोगहन यां कोसा कोसा आरु बेसका घाड़ायीन काम कोर रोया।” ");
INSERT INTO dhn_vpl VALUES ("EK8_10","027_8_10","EZK","8","10","10","हांव धड़े जाईन देख्यो कि च्यारु धड़ेन भितड़ा पोर भाति भातिन रेंगनेवाळा जिवे आरु घाड़्च्या जोनवारोन चित्र, आरु इसराएलियो क लारे पुजायनेवाळा देवी देवताओं क चित्र बनावला छे! ");
INSERT INTO dhn_vpl VALUES ("EK8_11","027_8_11","EZK","8","11","11","इसराएल क घोरानान डाहला मा गोथा सोत्तोर मानसे जेनका वीच मा सापान क पुर्‌यो याजन्याह वी छे, त्यो उना चित्रो क अगळ उबो छे, आरु होरीक मानु आपसा हात मा धूपदान लीन छे, आरु धूप क धुवाड़ा क वादळान गोंदाय उठ रोय। ");
INSERT INTO dhn_vpl VALUES ("EK8_12","027_8_12","EZK","8","12","12","तव त्यो मार सी कयो, “हे मानुसन ओवलियाद, काय तु न देख्यो कि इसराएल क घराना क डाहला आँधरला मा आपसा पुजान घोरोम काय कोर रोया? ये कोवे धे, कि पोरबु हामुक नी देखतो। त्यो ते हामरा देस क छुड़ीन चाली गुयो छे।” ");
INSERT INTO dhn_vpl VALUES ("EK8_13","027_8_13","EZK","8","13","13","ओळी त्यो मार सी कयो, “तु एनु सी आरु वी जादा घाड़ायीन काम देखीस जो त्या कोरे।” ");
INSERT INTO dhn_vpl VALUES ("EK8_14","027_8_14","EZK","8","14","14","तव त्या मेसे योहोवा क भवन क उना झपला क पास ली गुया जे बोखेवरे भेनी हुतो आरु चाँ बायरा बोठला तम्मुज देवता जुबु रोड़ रोया हुता। ");
INSERT INTO dhn_vpl VALUES ("EK8_15","027_8_15","EZK","8","15","15","तव त्यो मार सी कयो “हे मानुस नी ओवलियाद काय तुन यो देख्यो? ओळी एना सी वी मोटा घाड़ायीन काम तु देखीस।” ");
INSERT INTO dhn_vpl VALUES ("EK8_16","027_8_16","EZK","8","16","16","तव त्यो मेसे योहोवा क भवन क धड़े आँगना मा ली गुयो: आरु चाँ योहोवा क भवन क झपला क पास मन्डप आरु वेदी क विच थुड़ाक पोच्चीस मानसे आपसा वासाक योहोवा क भवन न आरु आपसो मुय उगेनवे भेनी कोरला हुता; आरु त्या उगेवने भेनी दाहड़ा क वांद रोया हुता। ");
INSERT INTO dhn_vpl VALUES ("EK8_17","027_8_17","EZK","8","17","17","तव त्यो मार सी कयो, “हे मानुस नु ओवलियाद, काय तु न यो देख्यो? काय योहुदा क घराना जुगु घाड़ायीन काम कोरनो जो त्या याँ कोरे नानी वात छे? त्या आपसा देस क घाड़ाय सी भोर देदा, आरु ओळी यास आवीन मेसे रीस देवाड़े। पुन त्या मानु मुय बोनावीन मेसे वेला पाड़े। ");
INSERT INTO dhn_vpl VALUES ("EK8_18","027_8_18","EZK","8","18","18","एकालिय हांव वी रीसवायला सारको काम कोरीस, नी हांव गीन कोरो। मारा डुळा सी सातायीन त्या ढासी नी सोके। त्या उचा बुल सी मेसे आयड़से ती वी हेनकी विनत नी सोमळो।” ");
INSERT INTO dhn_vpl VALUES ("EK9_1","027_9_1","EZK","9","1","1","ओळी त्यो मार कानटा मा उचा बुल सी आयड़ीन कयो, “सोहोर क आदाकारी क आपसा आपसा हात मा नास कोरनेन होतियार लीन धड़े आवु।” ");
INSERT INTO dhn_vpl VALUES ("EK9_2","027_9_2","EZK","9","2","2","एना पोर छव मानसे बोखवरे भेनी उपेरला झपलान वा सी आपसा हात मा मारनेन होतियार लिन आया; आरु हेनका वीन सोनोन छिंदरा पेहरला, कोड़्या मा लिखनेन दवात बाँदला एक आरु मानुस हुतो; आरु त्या आखा भवन क धड़े जाईन पीतळ क वेदी क धड़े उबो हुयो। ");
INSERT INTO dhn_vpl VALUES ("EK9_3","027_9_3","EZK","9","3","3","तव इसराएल क परमेश्वर क सेक करुब, पोर सी, जेनका उपोर त्यो रोया कोरतो हुतो, भवन क डेवढ़ी पोर उठ आयो हुतो; आरु त्यो उना सोनोन छिंदरा पेहरला मानसो क जे कोड़्या मा दवात बाँदला हुता, आयड़िया। ");
INSERT INTO dhn_vpl VALUES ("EK9_4","027_9_4","EZK","9","4","4","आरु योहोवा न उना सी कोयु, “एना योरुसालेम सोहोर क धड़े ओथान ओथा जाईन जोतरा मानसे उना आखा घाड़ायन कामोन कारन जे उनामा कोरे, दोम भोरता आरु दुखन कोरता आयड़े, हेनका माथा पोर सोहलानी लागाड़ दे।” ");
INSERT INTO dhn_vpl VALUES ("EK9_5","027_9_5","EZK","9","5","5","तव त्यो मारा समळतेन दिसरा सी कयो, “सोहोर मा हेनका पोछोळ चालीन मारता जावु; कुदा पोर गीन नी कोरनो आरु नी एक वी मानुस तुमरा डुळा सी वाचीन ढासनो नी जुवे ");
INSERT INTO dhn_vpl VALUES ("EK9_6","027_9_6","EZK","9","6","6","डाहला, जुवान, कुवारला, बाळ-बोच्‌चा, बायरा, आखाक मारीन नास कोरु, पुन जिना कुदा मानसोन माथा पोर ची सोहलानी होय, हेका धड़े नी जानो। मारा चुखला जागात सी शुरु कोरु। आरु त्या उना डाहला सी शुरु कोर्या जे परमेश्वरन भवनन अगळ हुता।” ");
INSERT INTO dhn_vpl VALUES ("EK9_7","027_9_7","EZK","9","7","7","ओळी त्यो उनासी कयो, “भवन काजे विटोळ कोरु, आरु आँगनाक धोड़ो सी भोर देवु, चालु, खोयड़े निकळु।” तव त्या निकळीन सोहोर मा मारने लाग्या। ");
INSERT INTO dhn_vpl VALUES ("EK9_8","027_9_8","EZK","9","8","8","जव त्या मार रोया हुता, आरु हांव एखलु रोय गुयो, तव हांव मुयोन भुरसे हिट पोड़्यो आरु आयड़ीन कयो, “हाय पोरबु योहोवा! काय तु आपसी रीस योरुसालेम पोर भड़कावीन इसराएल क आखा वाचला वी नास कोरीस?” ");
INSERT INTO dhn_vpl VALUES ("EK9_9","027_9_9","EZK","9","9","9","तव त्यो मार सी कयो, “इसराएल आरु योहुदा क घराना क भुनला काम बेसका जादात छे, याँ लगुन कि आखो देस लुहुय सी भोराय गुयो छे, आरु सोहोर पाप सी भोराय गुयो छे। काहकी त्या कोवे छे, योहोवा न कळी को छुड़ देदो आरु योहोवा काय नी देखतो। ");
INSERT INTO dhn_vpl VALUES ("EK9_10","027_9_10","EZK","9","10","10","एकालिय हांव हेनका कामोन फोव हेनकाज माथा पोर आपीस। हामं उना पोर गीनोन निंगा नी कोरीस। एक वी मानुस मारा डुळा सी वाचीन डासी नी सोकसे।” ");
INSERT INTO dhn_vpl VALUES ("EK9_11","027_9_11","EZK","9","11","11","तेने टेमे हांव देख्यो कि, जेरा कोड़्या मा लिटोन सांयोन डोब्बी बांदलो हुतो, यी खोबोर लायो, “पोरबु, जसो तु मेसे हुकुम आपलो हुतो, तसोज हांव कोर देदो।” ");
INSERT INTO dhn_vpl VALUES ("EK10_1","027_10_1","EZK","10","1","1","हांव डुळा उचा कोर्‌यो आरु यो देख्यो: करुब, मुनका उपोर वादळामोण्डळी छे, आरु एनु वादळामोण्डळी मा राजगादी सारको काहीन छे, जो नीलमणि सारको चोमकी रोयो। ");
INSERT INTO dhn_vpl VALUES ("EK10_2","027_10_2","EZK","10","2","2","ओळी योहोवा न उना सोनोन छिंदरा पेहरला मानुस सी कयो, “फिरनेवाळा चाकटा क विच करुब, क नेचो जा आरु आपसी दुयो मुठोक करुब, क वीच क अंगारा सी भोरीन सोहोर पोर खोव्‌वी दे।” त्या मार देखता देखता हेनका विच मा गोयो। ");
INSERT INTO dhn_vpl VALUES ("EK10_3","027_10_3","EZK","10","3","3","जव त्या मानसे धड़े गुया, तव त्या करुब, भोवनोन दोखेवरो उबो हुतो; आरु वादळो आँगना मा भोरायलो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EK10_4","027_10_4","EZK","10","4","4","तव योहोवान सेक करुब, क उपर सी उठीन भवन क पोयड़ी पोर आय गुयो: आरु वादळो भवन मा भोराय गुयो; आरु त्यो आँगनो योहोवान ताकोतन विजाळा सी भोराय गुयो। ");
INSERT INTO dhn_vpl VALUES ("EK10_5","027_10_5","EZK","10","5","5","करुब, क पाखड़ा क बुल खयड़े आंगनाम लगुन समळाय देदो हुतो, त्यो ताकोतवाळो परमेश्वर क बुलनेन सारको बुल हुतो। ");
INSERT INTO dhn_vpl VALUES ("EK10_6","027_10_6","EZK","10","6","6","जब त्यो सोनोन छिंदरा पेहरला मानुस क फिरने क धड़े करुब, क वीच मा सि आगठो लेने हुकुम आप्यो, तव त्यो हेनका विच मा जाईन एक चाकटा क धड़ उबो हुयो। ");
INSERT INTO dhn_vpl VALUES ("EK10_7","027_10_7","EZK","10","7","7","तव करुब, क वीच सी एक करुब, न आपसो हात ओगो करीन, उना आगठा मा सी जो करुब, क बिच मा हुती, काहिन चुटीन सोनोन छिंदरा पेहरला मानुस क मुठ मा आप देदो; आरु त्यो हेको लीन खयड़े चाली गुयो। ");
INSERT INTO dhn_vpl VALUES ("EK10_8","027_10_8","EZK","10","8","8","करुब, क पाखड़ा क नेचा ते मानसोन हात सारको काहिन देखा पोड़तो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EK10_9","027_10_9","EZK","10","9","9","तव हांव देख्यो कि करुब, क धड़े चार चाकटा छे: एक एक करुब, क धड़े एक चाकटो छे। चाकटा क रुप रंग किमती दोगड़ा सारको चोमोकन्यो छे। ");
INSERT INTO dhn_vpl VALUES ("EK10_10","027_10_10","EZK","10","10","10","आखा चाकटा रुप, च्यारु एक सारका देखायतला, जोसा एक चाकटा क वीच दुसरो चाकटो होय। ");
INSERT INTO dhn_vpl VALUES ("EK10_11","027_10_11","EZK","10","11","11","चालनेन टेमे त्या आपसी च्यारु अलंगो क ताकुत सी चालतला छे: आरु चालते टेमे वोवतला नी, पुन जेंखेर हेनको मुनको रोहतलो त्या तेंखेरुत हेका पछळ चालतला छे आरु चालते टेमे त्या ववतला नी। ");
INSERT INTO dhn_vpl VALUES ("EK10_12","027_10_12","EZK","10","12","12","हांव देख्यो कि करुब, क आखो डीलोम वासो, हात आरु पाखड़ा मा एने हेनका धड़ेन चाकटा मा वी आखा भेनी डुळा डुळा छे। ");
INSERT INTO dhn_vpl VALUES ("EK10_13","027_10_13","EZK","10","13","13","मार सोमवता एनु चाकटाक चक्कर कोयो, फिरनेवाळा टायरा। ");
INSERT INTO dhn_vpl VALUES ("EK10_14","027_10_14","EZK","10","14","14","एक एकोन च्यार‍ च्यार मुय हुता: एक मुयोन ते करुब, सारको, दुसर मुय मानसो सारको, तीसरो मुय नाहरो सारको, आरु चवथो मय घुवोड़ चिल्‌ला सारको। ");
INSERT INTO dhn_vpl VALUES ("EK10_15","027_10_15","EZK","10","15","15","करुब, भुमी पोर सी उठ गुया। ये त्यात जीवधारि छे, जे हांव न कोबार नोंदी क पास देख्यो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EK10_16","027_10_16","EZK","10","16","16","जब जब त्या करुब, चालता हुता तब तब त्या चाकटा हेनका पास पास चालता हुता; आरु जव जव करुब, कळ पोर सी उठने क लिय आपसा पाखड़ा उठावतला तव तव चाकटा हेनका पास सी नी वोवता हुता। ");
INSERT INTO dhn_vpl VALUES ("EK10_17","027_10_17","EZK","10","17","17","जव त्या उबा होयतला तव ये वी उबा होयतला हुता। आरु जव त्या उठतो तव ये वी हेनका भेळ उठतो हुता; काहकी जिवधारियो क जीव एनुम रोहती हुती। ");
INSERT INTO dhn_vpl VALUES ("EK10_18","027_10_18","EZK","10","18","18","योहोवान सेक भवन क पाटड़ी पोर सी उठीन करुब, क उपोर बोस गोयो ");
INSERT INTO dhn_vpl VALUES ("EK10_19","027_10_19","EZK","10","19","19","तव करुब, आपसा पाखड़ा चुटीन मार देखता देखता कळी पोर सी उठीन निकळी गुया; आरु चाकटा वी हेनका भेळ भेळ गुया, आरु त्या आखा योहोवा क भवन क उगेनले झपला मा उबा हुय गुया; आरु इसराएल क परमेश्वर क सेक क हेनका उपोर बोस रयो। ");
INSERT INTO dhn_vpl VALUES ("EK10_20","027_10_20","EZK","10","20","20","ये त्यात जीवधारि छे जे हांव न कोबार नोंदी क पास इसराएल क परमेश्वर क नेचो देखलो हुतो, आरु हांव न जान लेदो कि त्या वी करुब, छे। ");
INSERT INTO dhn_vpl VALUES ("EK10_21","027_10_21","EZK","10","21","21","एक एक क चार मुय आरु च्यार पाखड़ा आरु पाखड़ा क नेचा मानसो सारका हात वी हुता। ");
INSERT INTO dhn_vpl VALUES ("EK10_22","027_10_22","EZK","10","22","22","हेनका मुखो क रुप त्यो छे जे हांव कोबार नोंदी क धड़े देखलो हुतो। हेनका मुख काय पुन हेनका आखा डिल वी तसोज हुतो। त्या सुदा आपसा आपसा ओगळुत चालता हुता। ");
INSERT INTO dhn_vpl VALUES ("EK11_1","027_11_1","EZK","11","1","1","तव आत्मा ने मेसे उठाड़ीन योहोवा न भवन क उगेनला झपला क धड़ जेको मुय उगेनले भेनी छे, पुगाड़ देदो; आरु चाँ हांव न काय देख्यो, कि झपलात मा पच्चीस मानसे छे। हांव हेनका वीच अज्जुर क पुर्‌यो याजन्याह क आरु बनायाह क पुर्‌यो पलत्याह क देख्यो, जो प्रजा क डाहलो हुतो। ");
INSERT INTO dhn_vpl VALUES ("EK11_2","027_11_2","EZK","11","2","2","तव त्यो मार सी कयो, “हे मानुस नु ओवलियाद, जे मानसे एना सोहोर मा भुनलो कोरनेन आरु भुनलो कोरनेन विचार कोरता होय त्या येज छे। ");
INSERT INTO dhn_vpl VALUES ("EK11_3","027_11_3","EZK","11","3","3","ये कोवे छे, घर बनावने क टेम धड़े नी, यो सोहोर हांडो आरु हामु उनामा क मास छे। ");
INSERT INTO dhn_vpl VALUES ("EK11_4","027_11_4","EZK","11","4","4","एकालिय हे मानुस क ओवलियाद, एनका विरुद्ध भोगवानो वोगे गोथी वात देखाड़, भोगवानो वोगे गोथी वात।” ");
INSERT INTO dhn_vpl VALUES ("EK11_5","027_11_5","EZK","11","5","5","तव योहोवा क जीव मार पोर उतरीयो, आरु मार सी कयो, असो कोह, योहोवा असो कोवे छे: हे इसराएल क घोराना, तुमु ओसाज कोहला छे: जो काहीन तुमरा मोनोम आवे छे, ओको हांव जानो छे। ");
INSERT INTO dhn_vpl VALUES ("EK11_6","027_11_6","EZK","11","6","6","तुमु ते एना सोहोर मा बेसका मार नाखला पुन हेका वाटोक धोड़ो सी भोर देदला छे। ");
INSERT INTO dhn_vpl VALUES ("EK11_7","027_11_7","EZK","11","7","7","“ओस कोरीन पोरबु योहोवा असो कोवे छे: जेनु मानसोक तुमु एनाम मार नाखला छे, हेनका शव एना सोहोररुपी हांडाम क मांस छे: आरु तुमु एका वीच सी निकळी जासु। ");
INSERT INTO dhn_vpl VALUES ("EK11_8","027_11_8","EZK","11","8","8","तुमु तलवार सी बिहता होय, आरु हांव तुमरे पोर तलवार चालाड़ीस, पोरबु योहोवान यो बुल छे। ");
INSERT INTO dhn_vpl VALUES ("EK11_9","027_11_9","EZK","11","9","9","हांव तुमुक एरेम सी निकाळीन पारकादेस क हात मा कोर देसु, आरु तुमुक डोन आपाड़ीस। ");
INSERT INTO dhn_vpl VALUES ("EK11_10","027_11_10","EZK","11","10","10","तुमु तलवार सी मारीन पाड़सु, आरु हांव तुमरा डोन इसराएल क देस क काकड़ पोर चुकाड़ीस; तव तुमु जान लोसु कि हांव योहोवा छे। ");
INSERT INTO dhn_vpl VALUES ("EK11_11","027_11_11","EZK","11","11","11","यो सोहोर तुमरे जुगु हंडा नी बोनसे, आरु नी तुमु एनामा क मास होयसु; हांव तुमरा डोन इसराएल क देस क काकड़ पोर चुकाड़ीस। ");
INSERT INTO dhn_vpl VALUES ("EK11_12","027_11_12","EZK","11","12","12","तव तुमु जान लेसु कि हांव योहोवा छे; तुमु ते मारा कायदा पोर नी चाल्या, आरु मारा कायदा क तुमु नी मान्या; पुन आपसा च्यारु भेनीन मुलुकोन रितियो पोर चाल्या होय।” ");
INSERT INTO dhn_vpl VALUES ("EK11_13","027_11_13","EZK","11","13","13","हांव ओस कोरीन भोगवानो वोगे गोथी वात कोर रोयो हुतो किक बनायाह क पुर्‌यो पलत्याह मोर गुयो। तव हांव मुयोन भुरसे हिट पोड़्यो उचा बुल सी आयड़ी उठ्यो, आरु कयो, “हाय पोरबु योहोवा, काय तु इसराएल क वाचला क सत्यानास कोर नाखसे?” ");
INSERT INTO dhn_vpl VALUES ("EK11_14","027_11_14","EZK","11","14","14","तव योहोवा क यो बुल मार पास पुग्यो, ");
INSERT INTO dhn_vpl VALUES ("EK11_15","027_11_15","EZK","11","15","15","“हे मानुस नु ओवलियाद, योरुसालेम क निवासियो न तारे धड़े भास्यो सी, पुन इसराएल क आखा घराना सी वी कहलो छे कि तुमु योहोवा क पास सी छेटा होय जावु, यो देस हामरा होक मा आप देदलो छे। ");
INSERT INTO dhn_vpl VALUES ("EK11_16","027_11_16","EZK","11","16","16","कदाम तु उना सि कोवे, पोरबु योहोवा असो कोवे छे: हांव तुमुक छेटा छेटान मुलको मा बसाड़ियो आरु देस देस मा वेरावेर कोर देदो छे, तेवी जिना देसो मा तुमु आवला होय, उना मा हांव आपसो तुमरे लिय थुड़ाक दाहड़ा लगुन चुखला जागाम रोहिस। ");
INSERT INTO dhn_vpl VALUES ("EK11_17","027_11_17","EZK","11","17","17","एकालिय उनासी कोह, पोरबु योहोवा असो कोवे छे: हांव तुमुक मुलुक मुलुकोम क लोगहन क विच मा वेरविस, आरु जिना देसोम तुमु वेरावेरा कोरला छे, उनामा सी तुमुक एकठा कोरीस, आरु तुमुक इसराएल क जागो आपीस। ");
INSERT INTO dhn_vpl VALUES ("EK11_18","027_11_18","EZK","11","18","18","त्या चाँ पुगीन उना देस क आखा घाड़ायीन मुरते आरु आखा घाड़ायीन काम वी उनामा सी छेटो कोरसु। ");
INSERT INTO dhn_vpl VALUES ("EK11_19","027_11_19","EZK","11","19","19","हांव हेनका काळजा एक कोर दीस, आरु हेनका धड़े नोवली आत्मा उपजाड़ीस, आरु हेनका डील मा सी दोगड़ा सारको काळजो निकाळीन हेको मांस क काळजो आपीस, ");
INSERT INTO dhn_vpl VALUES ("EK11_20","027_11_20","EZK","11","20","20","जेरेसी त्या मारा कायदा पोर दाहड़ी चाल्या कोरे आरु मारा कायदाक माने; आरु त्या मारी पोरजा कोहायसे, आरु हांव हेनको परमेश्वर कोहाईस। ");
INSERT INTO dhn_vpl VALUES ("EK11_21","027_11_21","EZK","11","21","21","कदाम त्या लोगहन जे आपसी घाड़ायीन मुरती आरु घाड़ायीन कामोम मोन लागाड़ीन चालता रोहे छे, हेनको हांव असो कोरीस की हेनकी चाल हेनका मुनका पोर पोड़से, पोरबु योहोवा क यो बुल छे।” ");
INSERT INTO dhn_vpl VALUES ("EK11_22","027_11_22","EZK","11","22","22","करुब न आपसा पाखड़ा खवळ्या। चाकटा वी हेनका भेळ भेळा चाल्या। करुब, क उपोर इसराएल क परमेश्वर क सेक हुतो। ");
INSERT INTO dhn_vpl VALUES ("EK11_23","027_11_23","EZK","11","23","23","देखता देखता योहोवा क सेक सोहोरोन विच सी निकळीन वादळा मा उठ गुयो। हांव देख्यो कि योहोवा क ताकोत उना बोयड़ा पोर रोय गुयो जो सोहोर क उगेनले भेनी छे। ");
INSERT INTO dhn_vpl VALUES ("EK11_24","027_11_24","EZK","11","24","24","ओळी हांव परमेश्वर क जीव क लारे यो दर्शन देख्यो: आत्मा न मेसे उठाड़्यो आरु कोसदि देस मा निकाळीन मारी जाति भाय बोन्या क मेसे पुगाड़ देदो। ऐरे वाद दर्शन सोर गुयो। ");
INSERT INTO dhn_vpl VALUES ("EK11_25","027_11_25","EZK","11","25","25","तव जोतरी वाते योहोवा न मेसे देखाड़्यो हुतो, ची हांव न बांदायला क बताड़्यो। ");
INSERT INTO dhn_vpl VALUES ("EK12_1","027_12_1","EZK","12","1","1","ओळतेन योहोवा क यो बुल मार पास पुग्यो, ");
INSERT INTO dhn_vpl VALUES ("EK12_2","027_12_2","EZK","12","2","2","“हे मानुस नु ओवलियाद,” तु लोड़ाय कोरनेवाळा घराना क विच मा रोहे छे, जेनका देखने क लिय डुळा ते छे, पुन नी देखे, आरु समळने क लिय कानटा ते छे पुन नी समळे; काहकी त्या लोड़ाय कोरनेवाळा घरानान छे। ");
INSERT INTO dhn_vpl VALUES ("EK12_3","027_12_3","EZK","12","3","3","“एकालिय हे मानुसोन ओवलियाद, दिसु बाँदायीन सोमान तियार कोरीन हेनका देखतात उठ जाजी, हेनका देखतात आपसा जागाक छुड़ीन दीसरे जागे जाजी। कदाम त्या लोड़ाय कोरनेवाळा घरानान छे तीवी पाको छे कि त्या धियान देये। ");
INSERT INTO dhn_vpl VALUES ("EK12_4","027_12_4","EZK","12","4","4","ओतरान कोरीन तु दाहड़ा क देखतात बाँदाय क सोमान क जोसो आपसो सोमान निकाळजी, आरु ती तु साँतो बाँदाय मा जानेवाळ क जोसो हेनका देखतात उठ जाजी। ");
INSERT INTO dhn_vpl VALUES ("EK12_5","027_12_5","EZK","12","5","5","हेनका देखतात भितड़ा क फुड़ीन ओकाज सी आपसो सोमान निकाळजी। ");
INSERT INTO dhn_vpl VALUES ("EK12_6","027_12_6","EZK","12","6","6","हेनका देखतात हेको आपसा खाँदा पोर चुटीन आँदारलाम निकाळजी, आरु आपसो मुय ढाँक रोहजी कि धरती तुसे नी देखा पोड़े; काहकी हांव तुसे इसराएल क घराना क लिय एक सोहलानी बोनावला छे।” ");
INSERT INTO dhn_vpl VALUES ("EK12_7","027_12_7","EZK","12","7","7","हेकी हुकुमन ओनसारे हांव तसोह कोर्‌यो। दिसु हांव आपसो सोमान बाँदाय क सोमाज क जोसो निकाळ्यो, आरु साँतो आपसा हात सी भितड़ा क फुड़्यो; ओळतेन आँदरलाम सी सोमान निकाळीन, हेनका देखतात आपसा खाँदा पोर चुटीन चाली गुयो। ");
INSERT INTO dhn_vpl VALUES ("EK12_8","027_12_8","EZK","12","8","8","संदारे योहोवा क यो बुल मार पास पुग्यो, ");
INSERT INTO dhn_vpl VALUES ("EK12_9","027_12_9","EZK","12","9","9","“हे मानुस नु ओवलियाद,” काय इसराएल क घराना न उना लोड़ाय कोरनेवाळा घराना न तुसे यो नी पुछ्या, यो तु काय कोर रोयु? ");
INSERT INTO dhn_vpl VALUES ("EK12_10","027_12_10","EZK","12","10","10","तु उना सी कोव, पोरबु योहोवा असो कोवे छे: यो ताकोतवाळो बुल योरुसालेम क डाहला मानुस आरु इसराएल क आखा घरानान वाराम छे जेका विच मा त्या रोहे छे। ");
INSERT INTO dhn_vpl VALUES ("EK12_11","027_12_11","EZK","12","11","11","तु उनासी कोव, हांव तुमरा लिय सोहलानी छे; जसो हांव न कोर्‌यो छे, तसोज इसराएली लोगहन सी वी कोर्‌यो जाए; हेनको चुटीन बाँदाय मा जानो पोड़से। ");
INSERT INTO dhn_vpl VALUES ("EK12_12","027_12_12","EZK","12","12","12","हेनका विच मा जे डाहला छे, त्या आँधारला मा आपसा खाँदा पोर भार चुटीन निकळसे, त्या आपसा सोमान निकाळने क लिय भितड़ तुड़से, आरु आपसा मुय ढाँक रोहसे कि हेको जागा नी देखा पोड़े। ");
INSERT INTO dhn_vpl VALUES ("EK12_13","027_12_13","EZK","12","13","13","हांव उना पोर आपसी जाळ खोव्‌वीस, आरु त्या मार फांदा मा फोस जासे; आरु हांव उना कोसदियो क देस क बेबीलोन शोहोरोम मा पुगाड़ दिस; कदाम त्या उना सोहोर मा मोर जासे, तेवी हेको ओनी देखाड़से। ");
INSERT INTO dhn_vpl VALUES ("EK12_14","027_12_14","EZK","12","14","14","जोतरा हेनका सहायक हेका आड़े धोड़े होयसे, हेनको आरु हेनकी आखी टुळीक हांव आखे छोमकीर वेरवी दीस; आरु तलवार हापकीन हेनका पछळ चालाड़ीस। ");
INSERT INTO dhn_vpl VALUES ("EK12_15","027_12_15","EZK","12","15","15","“जव हांव उना मुलुक मुलुकोम वेरवी दीस आरु देस देस मा इतरेन तितरे कोर दिस, तव त्या जान लेसे कि हांव योहोवा छे। ");
INSERT INTO dhn_vpl VALUES ("EK12_16","027_12_16","EZK","12","16","16","कदाम हांव उना मा सी थुड़ाक लोगहन क तलवार, भुक आरु मोरने सी वाचाड़ीन राखीस; आरु त्या आपसा घाड़ायीन कामोक उना जातियोम वाराम कोरसे हेनका विच मा त्या पुगसे; तव त्या जान लेसे की हांव योहोवा छे।” ");
INSERT INTO dhn_vpl VALUES ("EK12_17","027_12_17","EZK","12","17","17","तव योहोवा को यो बुल मार पास पुग्यो, ");
INSERT INTO dhn_vpl VALUES ("EK12_18","027_12_18","EZK","12","18","18","“हे मानुस नु ओवलियाद, कापता जाईन आपसो रुटो खाजी आरु थरथरायता आरु फीकुर कोरता जाईन आपसो पानी पीजो, ");
INSERT INTO dhn_vpl VALUES ("EK12_19","027_12_19","EZK","12","19","19","आरु एना देस क लोगहन सी यो कोहजी, कि पोरबु योहोवा योरुसालेम आरु इसराएल का देस मा रोहनेवाळान वारा असो कोवे छे; त्या आपसा रुटा फीकुर पुटी खासे, आरु आपसा पानी बिकोम पीसे; काहकी देस आपसा आखा रोहनेवाळा क गाँडाय सी आपसी आखी भरपुरी सी छेटा होय जासे। ");
INSERT INTO dhn_vpl VALUES ("EK12_20","027_12_20","EZK","12","20","20","बोसला सोहोर उजड़ी जासे, आरु देस वी उजाड़ होय जासे, तव तुमु लोगहन जान लेसु की हांव योहोवा छे।” ");
INSERT INTO dhn_vpl VALUES ("EK12_21","027_12_21","EZK","12","21","21","ओळतेन योहोवा को यो बुल मार पास पुग्यो, ");
INSERT INTO dhn_vpl VALUES ("EK12_22","027_12_22","EZK","12","22","22","“हे मानुस नी ओवलियाद,” यो काय कोहाड़ो छे जे तुमु लोगहन इसराएल क देस मा कोया कोरतला, दाहड़ा जादा होय गुयला छे, आरु दर्शन नी काय वात पुरी नी होयी? ");
INSERT INTO dhn_vpl VALUES ("EK12_23","027_12_23","EZK","12","23","23","एकालिय उना सी कोय, पोरबु योहोवा असो कोवे छे, हांव एनी कहावत को बोंद कोरीस; आरु एना कोहाड़ाक इसराएल पोर ओळी नी चालसे। तु उना सी कोय कि त्या दाहड़ा आहना आय गुयला छे, आरु दर्शन नु आखी वाते पुरी होयने वाळी छे। ");
INSERT INTO dhn_vpl VALUES ("EK12_24","027_12_24","EZK","12","24","24","“काहकी इसराएल क घराना मा नी ते आरु जादा झुट दर्शन नी काय वात आरु नी काय चिकनी चुपड़ी वात ओळी कोवायसे। ");
INSERT INTO dhn_vpl VALUES ("EK12_25","027_12_25","EZK","12","25","25","काहकी हांव योहोवा छे, जोत्यार हांव कोह, तव ते बुल हांव कोहो, त्यो पुरो होय जासे। उनामा वार नी होयसे, पुन हे लोड़ाय कोरनेवाळा घराना, तुमरात दाहड़ा मा हांव बुल कोहीस, आरु त्या पुरो होय जासे, पोरबु योहोवा नु यो बुल छे।” ");
INSERT INTO dhn_vpl VALUES ("EK12_26","027_12_26","EZK","12","26","26","ओळी योहोवा क यो बुल मार पास पुग्यो, ");
INSERT INTO dhn_vpl VALUES ("EK12_27","027_12_27","EZK","12","27","27","“हे मानुस नी ओवलियाद देख, इसराएल क घरानान लोगहन यो कोय रोया छे, जे दर्शन त्या देखे, त्या बेसका दाहड़ा वाद पुरो होयनेवाळा छे; आरु की त्या छेटान टेमोन वाराम भोगवानो वोगे गोथी वात कोरे छे। ");
INSERT INTO dhn_vpl VALUES ("EK12_28","027_12_28","EZK","12","28","28","एकालिय तु उना सी कोय, पोरबु योहोवा असो कोवे छे: मार काहना बुल को पुरो होयनेम ओळी वार नी होयसे, पुन जो बुल हांव कोहो त्यो छाचिन पुरो होयसे, पोरबु योहोवा को यो बुल छे।” ");
INSERT INTO dhn_vpl VALUES ("EK13_1","027_13_1","EZK","13","1","1","योहोवान यो बुल मारेन्चा पुग्यो, योहोवा न मार सी कयो, ");
INSERT INTO dhn_vpl VALUES ("EK13_2","027_13_2","EZK","13","2","2","“हे मानुसन ओवलियाद,” “इसराएल क जो कागळीयो आपसाज मोन सी भोगवानो वोगे गोथी कोरे, हेनका विरुद भोगवानो वोगे गोथी वात कोरीन तु कोय, योहोवा को बुल समळ!” ");
INSERT INTO dhn_vpl VALUES ("EK13_3","027_13_3","EZK","13","3","3","पोरबु योहोवा असो कये: हाय, उना विन ओकलीया कागळीया पोर जो आपसाज जीव पछळ भोटकी जाय, आरु काहनो दोरसोन नी आपलो हय! ");
INSERT INTO dhn_vpl VALUES ("EK13_4","027_13_4","EZK","13","4","4","हे इसराएल, तारा कागळीया खाढान कुल्या सारका बोनला छे। ");
INSERT INTO dhn_vpl VALUES ("EK13_5","027_13_5","EZK","13","5","5","तुमु खाढा बुजीन इसराएल क घराना जुगु भीतड़ा नी सुदारीया, जेरेसी त्या योहोवा क दाहड़े लोड़ाय मा उबा नी रये। ");
INSERT INTO dhn_vpl VALUES ("EK13_6","027_13_6","EZK","13","6","6","त्या लोगहन जे कोवे, योहोवा क यो बुल छे, जव हांव थार को मुकल्यो नी हुतो। तुमु मार सी होर कोरता होय की हांव तुमरी झुटी भोगवानो वोगे गोथी वात को पुरो कोरो? ते वी योहोवा हेनुक नी मुकल्यो ");
INSERT INTO dhn_vpl VALUES ("EK13_7","027_13_7","EZK","13","7","7","काय तुमरो दोरसोन झुटो नी होय, आरु काय तुमरो झुट मुटन वेवहार नी कोहतला? तुमु कोहता होय, योहोवा भगवाण यो बुल छे; पुन हांव न काय नी कयो। ");
INSERT INTO dhn_vpl VALUES ("EK13_8","027_13_8","EZK","13","8","8","एना कारण सी मारो मालिक योहोवा हांय छाचीत् काहय कयसे, त्यो कये, तमु झुठ कया। तमु हसला दर्शन देखिया जो छाचा नी हुता। हतरान करीन हांव परमेश्वर हांय तुमरे विरुध्द मा छे। मारो मालिक योहवा यीत् वात कयो। ");
INSERT INTO dhn_vpl VALUES ("EK13_9","027_13_9","EZK","13","9","9","योहोवा कयो हांव हेनु कागळीयान क डण्ड आपीस जे झुटला दर्शन देखीया आरु जे झुट कया। हांव हेनको मार लोगहन मा सी अलग करीस। हेनका नाव इसराएल न परिवार न सुची मा नी रये। चे इसराएलोन मुलुकोम नी भोराय सोके, एनासी तुमु जान लेसु की हांव योहोवा भोगवान छे। ");
INSERT INTO dhn_vpl VALUES ("EK13_10","027_13_10","EZK","13","10","10","“त्या झुटा कागळीया ताळ-ताळ मारा मानसो की झुट कोया। कागळीया ते कोयो की शांती रोहसे आरु त्या शांती नी होय। लोगहन को भीतड़ो वातड़ो कोरनो छे आरु लोड़ायीन तियारी कोरनो छे। पुन त्या टुटला भितड़ा पोर नीपीन एक पातळो चोप नीप रोया। ");
INSERT INTO dhn_vpl VALUES ("EK13_11","027_13_11","EZK","13","11","11","हे मोनखीया, नीपनो चुपेड़नो कोरनेवाळा झुटा कागळीया सी कोव की भितड़ो हिट पोड़से; काहकी घोनु छाटू मोटलु पानी पोड़से, आरु मोटला मोटला गारा वी पोड़से, आरु घोनी आँजी वी पोड़से। ");
INSERT INTO dhn_vpl VALUES ("EK13_12","027_13_12","EZK","13","12","12","जोत्यार भितड़ो हिट पोड़से तोत्यार काय मानसे तुमरे सी यो नी कोवसे, तुमु भितड़ा पोर नीपीया ने चुपड़ीया, त्यो कां गोयो?” ");
INSERT INTO dhn_vpl VALUES ("EK13_13","027_13_13","EZK","13","13","13","ओतरान कोरीन पोरबु योहोवा ओसो कोवे : हांव रीसोन मोटली आंजी उहवाड़ीस। मारा रीसोन कारण मोटलु पानी पोड़से। हांव रीसोम मोटा मोटा गारा पाड़ीस, आरु हेको नास कोस दिस। ");
INSERT INTO dhn_vpl VALUES ("EK13_14","027_13_14","EZK","13","14","14","इने रिते जेना भितड़ाक तुमु नीपनो चुपेड़नो कोरला छे, हेको हांव धुवाम भेसकी दिस। हांव हेकी कुड़ची लोगुन उखाय दिस। जोत्यार त्या पोड़से तोत्यार तुमु वी उना मा डाबायीन मोर जासु। तोत्यार तुमुक मालुम होयसे की हांव ही पोरबु छे। ");
INSERT INTO dhn_vpl VALUES ("EK13_15","027_13_15","EZK","13","15","15","“ऐने रीते हांव भितड़ा पोर, आरु हेको नीपनेवाळा कागळीया पोर आपसी रीस उतारीस। तोत्यार हांव तुमुक पुछीस, कां गोयो तुमरो भितड़ो, आरु कां गोया हेनाक चुपेड़नीया?” ");
INSERT INTO dhn_vpl VALUES ("EK13_16","027_13_16","EZK","13","16","16","ये इसराएलोन कागळीया योरुसालेमन वारु रीते विनता कोरता हुता। ये योरुसालेमोन शांतिन सोपना देखता हुता, पुन होंया शांति हुतीत नी। मालीक पोरबुन यो बुल छे। ");
INSERT INTO dhn_vpl VALUES ("EK13_17","027_13_17","EZK","13","17","17","हे मानसो, हेमी तु आपनी जातीन भाय बोन्यान पोरायटान सांबु आपसो मुय उघाड़। ये आपसात मोनोम भोगवानो वोगे गोथी वात कोरे। तु झुटी भोगवानो वोगे गोथी वात कोरनेवाळा एनु कागळ्यायोन सांबु विनता कोर। ");
INSERT INTO dhn_vpl VALUES ("EK13_18","027_13_18","EZK","13","18","18","उनासी कोव, मालीक पोरबु ओसो कोवे की: “बाय तुमरे पोर पिड़ा आवसे। तुमु मानसोन कुहनीया पोर पेहेरने जुगु छिंदरान तावीज सीवु, तुमु मानसोन मुनका पोर बांदने जुगु खास तावी बोनावु। तुमु कोवे की यी चिजे मानसोन जिवोनक वाचाड़ने कोरीन जादुन ताकोत राखे। तुमु ओतरोत आपसी जिवाय राखने कोरीन हेनु मानसोन जाव मा फाँदे पोड़ जाय? ");
INSERT INTO dhn_vpl VALUES ("EK13_19","027_13_19","EZK","13","19","19","तुमु मुठ भोरीन जोव गोंहोंव आरु थुड़ाक रुटान भुकरा लीन मारा आपना मानसोन ओगोळ मेसे विटोळ कोरला छे। तुमु ओसा मानसोन मार नाखु, जेनुक मोरनो नी जुवे; आरु ओसा मानसोक जिवतेला राखु, जेनुक जिवतेला नी रोहनो जुवे। तुमु मारा मानसो सी झुट कोहु, जेनुक झुट सोमोळनो गोंहवे। ");
INSERT INTO dhn_vpl VALUES ("EK13_20","027_13_20","EZK","13","20","20","“ओतरान कोरीन मालिक पोरबु ओसु कोवे: तुमु जेनु तावीजोन लारे जिवोक शिकार कोरे, हांव, हेनका विरुद छे। हांव हेनको, तुमरा बाजीबोनोक, बाहोम सी उतराय लीस, आरु जीवोक तुमरा जावोम सी छुड़ावीन चिल्‌लान तोसु उड़ाय दिस। ");
INSERT INTO dhn_vpl VALUES ("EK13_21","027_13_21","EZK","13","21","21","हांव तुमरा डाहडान बुरकाक नुचड़ी नाखीस, आरु आपसा मानसोक तुमरा हातोम सी छुड़ाय लीस। त्या ओळी कोदी तुमरा हातोन शिकार नी बोने। तोत्यार तुमुक पोतु चालसे कि हांव पोरबु छे। ");
INSERT INTO dhn_vpl VALUES ("EK13_22","027_13_22","EZK","13","22","22","“हांव धोरमी मानसोक डोगायने नी देदो, पुन तुमु आपसी झुटी भोगवानो वोगे गोथी वातो सी हेनको डोगाड़ीया। तुमु भुंडा मानसोक खुश कोरु की त्या आपसा भुण्डला कामोक नी छुड़े। कदाम भुंडला आपसो भुंडो काम छुड़ देय ती त्या जिवतेला रोहे। ");
INSERT INTO dhn_vpl VALUES ("EK13_23","027_13_23","EZK","13","23","23","ओतरान कोरीन हे नोबियो! तुमु ओळी कोदी झुटा दोरसोन नी देखसु, आरु नी विचार कोरसु। हांव तुमरा जावोम सी आपसा लोगहोन को छुड़ाय लीस। तोत्यार तुमुक पोतु चालसे की हांवुत पोरबु छे।” ");
INSERT INTO dhn_vpl VALUES ("EK14_1","027_14_1","EZK","14","1","1","इसराएलोन थुड़ाक डाहला म्हारे यां आया, आरु त्या मार ओगोळ वात कोरने बोठ गोया। ");
INSERT INTO dhn_vpl VALUES ("EK14_2","027_14_2","EZK","14","2","2","उनात टेमे पोरबु यो बुल मेसे जोड़्यो। पोरबु म्हार सी कयो, ");
INSERT INTO dhn_vpl VALUES ("EK14_3","027_14_3","EZK","14","3","3","ऐ मनुसोन पुर्या, ये मानसे ते आपसीत मुर्ती आपसा मोनोम बोसाड़ लेदा, आरु ये धोरमोन वाटे चालने से पेहेलुत आपसा ओगोळ पाप कोर रोया, ती काय ये ठुकर नी खासे? ये मारी मोरजी जानने कोरीन तारेन चा आवला छे। काय हांव इनुक जोपाप आपीस? कोदी नी। ");
INSERT INTO dhn_vpl VALUES ("EK14_4","027_14_4","EZK","14","4","4","तु इनुक यी वात कोय दे, आरु इनुसी कोव, मालिक पोरबु ओसो कोवे, इसराएली घोरानान जे मानसे आपसा देवोन मुरती आपसा मोनोम बोसाड़से, आरु ओसा धोरोमोन वाटे चालने सी पेहेल आपसा ओगोळ भुनला कामे कोरे, आरु म्हार मोरजी जानने जुगु कागळीयान चां आवसे, ती हेनको हांव म्हारे रीते जोपाप आपीस; त्या आपसी निगिनाये ओतरी मुरतीन सारको बेस डोन जोड़से। ");
INSERT INTO dhn_vpl VALUES ("EK14_5","027_14_5","EZK","14","5","5","जेरेसी इसराएलोन घोरानो, जो आपसी मुरतीन लारे मेसे छुड़ीन छेटा होय गोयला छे, हेनुक हांव तिंदरा मोनोन लारे फोसाड़ीस। ");
INSERT INTO dhn_vpl VALUES ("EK14_6","027_14_6","EZK","14","6","6","ओतरान कोरीन इसराएलोन घोराना सी कोव, मालिक पोरबु ओसु कोवे: इसराएलोन घोराना पोसतावु कोरु। आपसी मुरतीया छुड़ देवु; आरु आपसा भुंनला कामोक छुड़िन। ऐ इसराएलोन घोराना, मारे भेनी आत रोवु। ");
INSERT INTO dhn_vpl VALUES ("EK14_7","027_14_7","EZK","14","7","7","काहकी इसराएलोन घोराना मा सी आरु हेनका विच रोहनेवाळा पारका मा सी वी कुय काहा नी होय, जे मार पोछोळ चालनो चाहाय छुड़ीन आपसी मुरतीयाक आपसा मोनोम बोसाड़ीया कोरे, आरु आपसा पापन ठुकोर आपसा ओगोळ राखे, आरु तोत्यार मार सी आपसी काहानी वात पुछने कोरीन कागळीयान चा आया, ती हेनको हांव योहोवा आपसुत जोपाप आपीस। ");
INSERT INTO dhn_vpl VALUES ("EK14_8","027_14_8","EZK","14","8","8","हांव तिना मानसोन विरुद होयीन हेनको सार दीस, आरु सोहलानी राखीस; आरु हेनको कोहाड़ो चालाड़ीस आरु हेनुक आपसा मानसो मा गोथु नास कोरीस; तोत्यार तुमु मानसे जान लेसु की हांव योहोवा छे। ");
INSERT INTO dhn_vpl VALUES ("EK14_9","027_14_9","EZK","14","9","9","“आरु कागळीया धुकु खायीन काहनलो बुल कोया होय, ती जानु की हांव योहोवा उना कागळीयाक धुकु आपलो छे; आरु हांव आपसो हात हेनका विरुद ओगु कोरीन तिनाक आपसा मानसो इसराएल मा गोथु नास कोरीस। ");
INSERT INTO dhn_vpl VALUES ("EK14_10","027_14_10","EZK","14","10","10","त्या आखा मानसे आपसा आपसा भुंनला कामोन भार हुचलसे, जोसो कागळीया सी पुछनेवाळान भुंनला काम कोहायसे, तोसोत कागळीयान वी पाप कोहायसे। ");
INSERT INTO dhn_vpl VALUES ("EK14_11","027_14_11","EZK","14","11","11","काहाकी इसराएलोन घोराना ओगोळ म्हारे पोछोळ चालनो नी छुड़ु आरु नी आपसा भाति भातिन गुनान लारे ओगा विटोळ बोने; पुन त्या मार लोगहन बोने आरु हां हेनको परमेश्वर कोहायीस, पोरबु योहोवान यो बुल छे।” ");
INSERT INTO dhn_vpl VALUES ("EK14_12","027_14_12","EZK","14","12","12","योहोवान यो बुल म्हारे यां पुग्यो, ");
INSERT INTO dhn_vpl VALUES ("EK14_13","027_14_13","EZK","14","13","13","हे मानसोन पुर्या, जोत्यार काहनला देसोन लोगहन मार सी धुकु कोरीन पापी होय जाय, आरु हां आपसो हात ओगु कोरीन उना देसन विरुद् उना मा खानेन घोटी कोर दोम, आरु उना देसम काळोन टेम लाय दोम उनाम सी मानसे आरु ढुरोक दुयोक नास कोरो, ");
INSERT INTO dhn_vpl VALUES ("EK14_14","027_14_14","EZK","14","14","14","ती चाहाय उना मा नुह, दानियेल, आरु अय्युब ये तीनु मानसे होय, ती वी आपसा धोरमोन लारे कुदु आपसोत जिव वाचाड़ सोकसे; पोरबु योहोवान यो बुल छे। ");
INSERT INTO dhn_vpl VALUES ("EK14_15","027_14_15","EZK","14","15","15","कोदाम हांव काहनला देसोम जोंगली जोनवारे मुकलो जे हेनको कुसेनतात आरु त्यो उजाड़ नाखे, आरु जीवोनोन कारण काय उनामा होयीन नी जाय, ");
INSERT INTO dhn_vpl VALUES ("EK14_16","027_14_16","EZK","14","16","16","तु चाहाय उनामा त्या तीन मानसे होय, ती वी पोरबु योहोवान यो बुल छे, मारा जिवनोन आन, नी त्या पुर्याक आरु नी पोरायटाक वाचाड़ सोकसे, त्या ते ऐखला वाचसे; पुन देस उजाड़ होय जासे। ");
INSERT INTO dhn_vpl VALUES ("EK14_17","027_14_17","EZK","14","17","17","कोदाम हांव उना देस पोर तलवार हापकीन कोहो, हे तलवार उना देस पोर चाल; आरु ऐने रीते हांव उना मा सी मानसो आरु ढुरोक नास कोरो, ");
INSERT INTO dhn_vpl VALUES ("EK14_18","027_14_18","EZK","14","18","18","ती चाहाय उनामा त्या तीन धरमी मानसे वी होय, ती वी पोरबु योहोवान यो बुल छे, मार जोवनोन आन, नी ते पुर्याक आरु नी पोरायटाक वाचाड़ सोकसे, त्या ते ऐखला वाच जासे। ");
INSERT INTO dhn_vpl VALUES ("EK14_19","027_14_19","EZK","14","19","19","“कोदाम हांव उना देस मा महामारी मुकली सोको। हांव उना लोगहन पोर मारि रीसोन पानी पाड़ीस। हांव आखा मानसो आरु जोनवारीयाक उना देस सी छेटु कोर दिस। ");
INSERT INTO dhn_vpl VALUES ("EK14_20","027_14_20","EZK","14","20","20","ती चाहाय नुह, दानियेल आरु अय्युब वी उनाम होय, तीवी, पोरबु योहोवान यो बुल छे, मारा जिवनोन आन, त्या नी पुर्याक आरु पोरायटाक वाचाड़ सोकसे, आपसा भुंनला कामोन लारे त्या कुय आपसान जीवोक वाचाड़ सोकसे।” ");
INSERT INTO dhn_vpl VALUES ("EK14_21","027_14_21","EZK","14","21","21","“काहाकी पोरबु योहोवा ओसो कोवे: हांव योरुसालेम पोर आपसी च्यारु डोन पुगाड़ीस, तलवार, काळ, भुंनला जीवे आरु महामारी, जेरेसी मानसे आरु ढुरे आखा उनाम नास होये। ");
INSERT INTO dhn_vpl VALUES ("EK14_22","027_14_22","EZK","14","22","22","ती वी उनामा थुड़ाक पुर्या पोरायटा वाचसे जे चां सी निकाळीन तुमरे चां पुगाड़ीस, आरु तुमु हेनको चालचालोन आरु कामोक देखीन हेनी पीड़ान वारा जो हांव योरुसालेम पोर नाखीस, पुन जोतरी पीड़ा हांव उना पोर नाखीस, उना आखान वाराम शांति जोड़से। ");
INSERT INTO dhn_vpl VALUES ("EK14_23","027_14_23","EZK","14","23","23","जोत्यार तुमु हेनको चालचालोन आरु काम देखु, तोत्यार त्या तुमरी शांतिन कारण होयसे; आरु तुमु जान लेसु की हांव योरुसालेम मा जो काहीन कोर्‌यो, त्यो विगुर कारण नी कोर्य पोरबु योहोवान यो बुल छे।” ");
INSERT INTO dhn_vpl VALUES ("EK15_1","027_15_1","EZK","15","1","1","पोरबु योहोवान यो बुल मारे यां पुग्यो, पोरबु मारेसी कोयो, ");
INSERT INTO dhn_vpl VALUES ("EK15_2","027_15_2","EZK","15","2","2","ऐ मानसोन ओवलियाद, आखा झाड़ोम ओंगुरोन डाळ्या काय कामे आवे? काय ओंगुरोन डाळ्या धोपाड़नेन निंगा सी जोंगोलोन झाड़कान लाकड़ा सी वारु रोहे? ");
INSERT INTO dhn_vpl VALUES ("EK15_3","027_15_3","EZK","15","3","3","काय सुतार हेरा लाकड़ाम सी काहीन सोमान बोनावे? काय मानसे खुटा बोनावे आरु टाहरा हेरेसी टांगे? ");
INSERT INTO dhn_vpl VALUES ("EK15_4","027_15_4","EZK","15","4","4","नी, मोनख्या, ओंगुरोन डाळ्या लाकड़ाम आगलोत आगठाम धोपाड़नेम काम आवे। आगठो हेरे दुयो धोड़े गोथो सिलगीन रुखड़ु कोर देय, आरु हेका वीच वाळो आदरीतो धोपलो रोय जाय``````। देखाड़, काय होयो काहनला काम मा आय सोके? ");
INSERT INTO dhn_vpl VALUES ("EK15_5","027_15_5","EZK","15","5","5","ऐने रीते जोत्यार होयो नी धोपलो हुतो, तोत्यार वी त्यो काहानला काम मा नी हुतो। आरु हेमी जोत्यार आगठाम रुखड़ु होय गोयलो छे, ती काय हुयो काहनला कामोम आय सोके? ");
INSERT INTO dhn_vpl VALUES ("EK15_6","027_15_6","EZK","15","6","6","एरेन कोरीन! मालिक पोरबु ओसु कोवे: जोसु हांव जोंगोलोन आखा झाड़कान लाकड़ा मानसोन जातीक धोपाड़ने जुगु आपलो छे, तोसोत हांव योरुसालेमोन रोहनीया वेरीन हातोम आप दिस; काहकी त्या ओंगुरोन डाळ्यान लाकड़ा सारका रिकामा होय गोलया छे। ");
INSERT INTO dhn_vpl VALUES ("EK15_7","027_15_7","EZK","15","7","7","हांव उनासी मुय फेरवी लिस आरु उना पोर मारी रीस आगठा सारकी भोड़ेकसे। कोदाम त्या आगठा सी वाच निकोळसे, ती वी आगठो उनाक रुखड़ु कोर देसे। जोत्यार हांव रीस मा हेनु सी मुय फेरवी लिस, तोत्यार तुमुक मालुम पोड़से की हांव पोरबु छे। ");
INSERT INTO dhn_vpl VALUES ("EK15_8","027_15_8","EZK","15","8","8","हाव हेनको देस उजाड़ कोर दिस, काहकी त्या मारे सी धुकु कोरला छे, पोरबु योहोवान यो बुल छे। ");
INSERT INTO dhn_vpl VALUES ("EK16_1","027_16_1","EZK","16","1","1","ओळी पोरबु योहोवान यो बुल मारेन चां पुग्यो, ");
INSERT INTO dhn_vpl VALUES ("EK16_2","027_16_2","EZK","16","2","2","ऐ मानसोन ओवलियाद, योरुसालेमोक हेरा आखा भुंनला कामोक देखाड़, जे हुये कोरला छे। ");
INSERT INTO dhn_vpl VALUES ("EK16_3","027_16_3","EZK","16","3","3","तु उनासी यो कोव: ए योरुसालेम पोरबु योहोवा ओसो कोवे की: तारी पोयदावारी आरु तारी उपजोन कनानी जातिन देस मा होयली छे। तारो बास एमोरी राज्यान हुतो आरु आयीस हित्ती राज्यान हुती। ");
INSERT INTO dhn_vpl VALUES ("EK16_4","027_16_4","EZK","16","4","4","काय तु आपसी पोयदावारीन वारा यो जाने? जेने दाहड़े तु पोयदा होयलु, तेने दाहड़े नी तारी नाल काट्या, आरु नी तुखे चुखु कोरने कोरीन पानी सी उंगवाड़ीया। सोमोळ, तेने दाहड़े तारा डीलो पोर नोन नी चुपड़ीया, आरु नी तुसे छिदरा मा वेटाया। ");
INSERT INTO dhn_vpl VALUES ("EK16_5","027_16_5","EZK","16","5","5","तार पोर कुदु गिन नी कोर्‌यो, आरु नी तारे जुगु गिन कोरीन कुदु तारी नाल काट्यो। ");
INSERT INTO dhn_vpl VALUES ("EK16_6","027_16_6","EZK","16","6","6","जोत्यार हांव तारे धोड़े गोथु निकयु, तोत्यार हांव तुसेक लुहुय सी सोनायलु देख्यु। हांव तारेसी कोयो, ऐ लुहुय मा सोनायला! जिवतलो रोहे, ");
INSERT INTO dhn_vpl VALUES ("EK16_7","027_16_7","EZK","16","7","7","आरु खेतोन तोरा सारको वोद! ऐने तु वोद आरु वोदता वोदता जुवान होय गोय। तु घाटाळी होय गोय। तारा मुनकान झोटा पायोन पाटलीयाक छिमायने लाग्या। ते वी, ऐ योरुसालेम, तु उगाड़ली होती! तारा डिलो पोर काहनलो छिंदरो नी हुतो। ");
INSERT INTO dhn_vpl VALUES ("EK16_8","027_16_8","EZK","16","8","8","हांव ओळी तारे धोड़े सी निकळ्यो, आरु तारे पोर निंगा कोर्‌यो, ती देख्यु की तारु उमोर मोंग कोरनेन जुगु होय गोयली छे। हांव तारा डील पोर आपसो चादरो नांख देदो, आरु यो तारों नांगरा काजे ढांक देदु। हांव ओन खायीन तुसेक बुल आप्यो, आरु तारे पुठी वायदा बांद्यो, आरु ओस कोरीन तु मारी लाड़ी बोन गोय, पोरबु योहोवान यो बुल छे। ");
INSERT INTO dhn_vpl VALUES ("EK16_9","027_16_9","EZK","16","9","9","तोत्यार हांव तुसेक पानी सी उंगवाड़ीयो आरु तारा डिलो सी लुहुय धुयु। हांव तारा डीलो पोर तेल लागाड़्यु। ");
INSERT INTO dhn_vpl VALUES ("EK16_10","027_16_10","EZK","16","10","10","हांव तुसे साड़ी पेहरायो, जेरे पोर बेल-बुटे लागाड़ला हुआ। हांव तारा पायोम चाटीया पेहरायो। आरु हांव तुसे सुंदर रेशोमोन आरु मोंगलो छिंदरो बुरको पेहरायु। ");
INSERT INTO dhn_vpl VALUES ("EK16_11","027_16_11","EZK","16","11","11","हांव तुसे गोयना सी सोजाय देदु। तारा हातोम बाजीबोन आरु गोवाम हार पेहरायु। ");
INSERT INTO dhn_vpl VALUES ("EK16_12","027_16_12","EZK","16","12","12","हांव तारा नाकोम कुचू पेहरायु, कानटाम टुकरीया पेहरायु, आरु मुनका पोर मुकुट मेक्यु। ");
INSERT INTO dhn_vpl VALUES ("EK16_13","027_16_13","EZK","16","13","13","हांव तुसे सोना चाँदीन गोयना सी सोजाड़ देदु। तारा छिंदरा सुतीन सुवावा आरु रेशोमोन हुताम जेरे पोर कसीदा लागाड़लो हुतो। तु मेदान रुटू, ऐने भावरोन रोस आरु तेल मा चुड़लो खानो खाती हुती। तु बेसकी घाटाळी आरु रानी बोनने लायक होय गोय। ");
INSERT INTO dhn_vpl VALUES ("EK16_14","027_16_14","EZK","16","14","14","तु आपसी घाटाळी हुती कोरीन नावसादाय होती। यो आखो काहीन ओतरान कोरीन होयो काहाकि हांव मुलुक ओतरो जादा घाटाळो बोनायप! पोरबु योहोवान यो बुल छे। ");
INSERT INTO dhn_vpl VALUES ("EK16_15","027_16_15","EZK","16","15","15","पुन तु मारे पोर भुरसु नी कोरीन आपसी घाटाळो होयने पोर भुरसु कोरी। तु आपसा रुपोन नावसादाय होयने सी भुनला विचार कोरने लागी। तु वाट चालती मानसोक धोरीन उनासी छिनावो काम कोरावतली। ");
INSERT INTO dhn_vpl VALUES ("EK16_16","027_16_16","EZK","16","16","16","तु आपसा छिंदरा लीन रोंग बिरेंगा उचा जागा बोनाय लेदी, आरु उना पोर भुनला काम कोरी, ओसा भुंनला काम कोरी जे नी कोदी होया आरु नी होयसे। ");
INSERT INTO dhn_vpl VALUES ("EK16_17","027_16_17","EZK","16","17","17","जो सोनो चाँदीन घाटाळा गोयना हांव तुसे आप्यो हुतो, उना सी मानसोन मुरतिया बोनाय लेदी, आरु उना सी वी भुनला काम कोरने लागी; ");
INSERT INTO dhn_vpl VALUES ("EK16_18","027_16_18","EZK","16","18","18","आरु आपसा बेल हाथो कोरीन विंजला छिंदरा निकाळीन तेनुक ढांक देदी, आरु मार जेतुन क तेल आरु गोंदायनियो धूप तेल तेनुक ओगोळ चोड़ावी। ");
INSERT INTO dhn_vpl VALUES ("EK16_19","027_16_19","EZK","16","19","19","हांव तुमुक रुटा, मधु, आरु तेल आप्यु। पुन तुमु जो खानो देव मुरतियाक आप्या। तुमु ते तेना आपसा झुटा देवताक खुश कोरने जुगु गंदायन्यो कोरीन भेट कोर्या। तुमु तेनु झुटा देवताओं पुठी छिनावाय सारका रोया! पोरबु योहोवान यो बुल छे। जो ओसो हुयो। ");
INSERT INTO dhn_vpl VALUES ("EK16_20","027_16_20","EZK","16","20","20","तुमु ते मारे जुगु पुर्या आरु पोरायटा पोयदा कोरला हुता। तु ऐनु पुर्या पोरायटान बादा चोड़ाय दे काहकी छे मुरतिया हेनुक खाय लेय तोसे। काय ये तारा छिनावान काम नानली वात छे? ");
INSERT INTO dhn_vpl VALUES ("EK16_21","027_16_21","EZK","16","21","21","तु आगठान बादाम चोड़ावने जुगु मार पुर्याक मारी, आरु हेनुक आगठा मा चुयनी देदी। ");
INSERT INTO dhn_vpl VALUES ("EK16_22","027_16_22","EZK","16","22","22","तु मेसेक छुड़ी आरु यो छिनावो काम कोरी आरु तु आपसो चो टेम कोटी फोम नी कोरी जोत्यार तु नानली पोराय हुती। तु फोम नी कोरी, कि जोत्यार हांव तुसेक खुवे लेदु ती तु उगाड़ली हुती आरु लुहुय मा सोनायली हुती, ");
INSERT INTO dhn_vpl VALUES ("EK16_23","027_16_23","EZK","16","23","23","तारा हेनु आखा भुंनला कामो पोछोळ काय हुयो? हाय, तार पोर हाय! पोरबु योहोवान यो बुल छे। ");
INSERT INTO dhn_vpl VALUES ("EK16_24","027_16_24","EZK","16","24","24","तु ते एक टिलो बोनाय लेदी, आरु आखा एक जागाम एक उचो जागो बोनाय लेदी; ");
INSERT INTO dhn_vpl VALUES ("EK16_25","027_16_25","EZK","16","25","25","आरु एक एक वाटोम मुंडास्या पोर वी तु आपसो उचो जागो बोनावीन आपसी घाटाळी कोरीन छिनावो काम कोराय देदी, आरु होरीक सोवारीक बुलावीन भुंनलो काम कोरावीन मोटली छिनावाय होय गोय। ");
INSERT INTO dhn_vpl VALUES ("EK16_26","027_16_26","EZK","16","26","26","तु ते आपसा धोड़े वावा मिसरी मानसो सी वी, जे आरेगला ने जोबरा छे, छिनावो कोरी आरु मेसे रीस देवाड़ने कोरीन आपसो छिनावो जादा कोरती गोय। ");
INSERT INTO dhn_vpl VALUES ("EK16_27","027_16_27","EZK","16","27","27","ओतरान कोरीन हांव तुसेक डोन आप्यु। हांव तुसे तारा निज वाटा सी छेटो कोर देदु, तुसेक तारा देस सी निकाय देदु, आरु तुसे तारा भुकला दुश्मन पोलिस्ती बायरान हातोम कोर देदु। यो तारो मोटलो पाप देखीन लाजवायती होती। ");
INSERT INTO dhn_vpl VALUES ("EK16_28","027_16_28","EZK","16","28","28","ऐ योरुसालेम, ती ओस्सुर पुठी छिनावो कोरने लाग गोय। पुन तुसे पुरी नी पोड़ सोके। तारी कोदी होर नी भागे। ");
INSERT INTO dhn_vpl VALUES ("EK16_29","027_16_29","EZK","16","29","29","वेपारी जातीन कोसदि सी वी तु छिनावो कोरी। ओळी वी तारी होर नी भागी आरु यो तु आपसा छिनावाक जादा कोरती गोय। ");
INSERT INTO dhn_vpl VALUES ("EK16_30","027_16_30","EZK","16","30","30","पोरबु योहोवान यो बुल छे, कि तारो काळजो ओतरो काहा लालची छे! तु विनलाजाय छिनावान काम कोरे। ");
INSERT INTO dhn_vpl VALUES ("EK16_31","027_16_31","EZK","16","31","31","तु होरीक सोड़कोन छिंडा पोर आपसो टिलो आरु होरीक जागाम आपसो उचो जागो बोनावली छे, काय ऐना मा तु छिनावाय नी कोहाये? काहकी तु ओसी कोमाय पोर हासे। ");
INSERT INTO dhn_vpl VALUES ("EK16_32","027_16_32","EZK","16","32","32","तु छिनावाय लाड़ी छे। तु पारका मानसोक आपसा धेनीन बोदलो तेंदरे पुठी सुवे। ");
INSERT INTO dhn_vpl VALUES ("EK16_33","027_16_33","EZK","16","33","33","मानसे छिनावाय काजे तेरी किमोत आपे। पुन तु ते पारका मानसोक, आपसा पोर हासनीया दुसतीदार काजे लुभावने कोरीन आपसाक पोस्या आपे की त्या आखा जागा सी तारें चा आवे आरु तार पुठी छिनाळो कोरे। ");
INSERT INTO dhn_vpl VALUES ("EK16_34","027_16_34","EZK","16","34","34","इने रीते तारो छिनावो दिसरा छिनाया सी ओंदो छे। तारे पोछोळ कुदु छिनायो नी चालतो, आरु तु कुदा सी किमोत वी नी लेये, पुन तु आपे; इने रीते तु ओंदी कोहाये। ");
INSERT INTO dhn_vpl VALUES ("EK16_35","027_16_35","EZK","16","35","35","ओतरान कोरीन, ऐ छिनावाय, योहोवान बुल सोमोळ, ");
INSERT INTO dhn_vpl VALUES ("EK16_36","027_16_36","EZK","16","36","36","पोरबु योहोवा ओसु कोवे: तु ते छिनावा मा बेस विनलाजाय होयीन, आपसो डील आपसे वाये लागनियाक देखाड़े, आरु आपसी मुरतियो पुठी भुंनलो कार कोरी, आरु आपसा पुर्यान लुहुय उहवाड़ीन हेनुक बादा चोड़ावली छे, ");
INSERT INTO dhn_vpl VALUES ("EK16_37","027_16_37","EZK","16","37","37","एने रीते देख, हांव तारा आखा तारे वाये लाग रोहला छे, आरु जोतरा सी तु मोंग लागाड़ली, आरु जोतरा सी तु घाड़ाय राख रोय, उना आखाक च्यारु मेर सी तारे विरुद एकठा कोरीन हेनको तारा डील उगाड़लो कोरीन देखाड़िस, आरु त्या तारो डील देखसे। ");
INSERT INTO dhn_vpl VALUES ("EK16_38","027_16_38","EZK","16","38","38","तोत्यार हांव तुसेक डोन आपीस, जोसो छिनायाक आरु मारनीया बायराक आपे; आरु रीस आरु घाड़ाय सी तारो लुहुय उहवाड़ीस। ");
INSERT INTO dhn_vpl VALUES ("EK16_39","027_16_39","EZK","16","39","39","इने रीते हांव तुसे हेनका होकोम कोर दिस; आरु त्या तारा आसरान किला काजे उदार देसे, आरु तारा उचा जागाक तुड़ देसे, त्या तारा आखा छिंदराक निकाळसे, आरु तारा आखा घाटाळा गोयनाक हापकी लेसे, आरु तुसे उगाड़लो कोरीन छुड़से। ");
INSERT INTO dhn_vpl VALUES ("EK16_40","027_16_40","EZK","16","40","40","तोत्यार तारे विरुद् एक सोवटा मानसोक कोरीन त्या तारे पोर दोगड़ाटसे, आरु आपसी तोलवार सी चुर्या चुर्या कोर देसे। ");
INSERT INTO dhn_vpl VALUES ("EK16_41","027_16_41","EZK","16","41","41","त्या तारा घोरोम आगठो लागाड़ीन धोपाड़ देसे, आरु तुसे आड़काट मानसोन देखतात डोन आपसे; आरु हांव तारो छिनावो बोंद कोरावीस, आरु तु ओळी छिनावा जुगु किमोत नी आपे। ");
INSERT INTO dhn_vpl VALUES ("EK16_42","027_16_42","EZK","16","42","42","जोत्यार हांव तारे पोर रीसोन आगठो हुगो नी होयसे, तोत्यार तारे पोर ओळी नी किचवायो पुन हुगु होय जाइस, ओळी नी रिसवायो। ");
INSERT INTO dhn_vpl VALUES ("EK16_43","027_16_43","EZK","16","43","43","तु जो आपसा नानला होतो तेनु दाहड़ान फोम नी राखे, पुन ऐनी आखी वातोन लारे मेसे वायकेड़ा उड़ाय, ओतरान कोरीन हांव तारो चालचालोन तारा मुनका पोर नाखीस आरु तु आपसा आखा पोछला घाड़ायीन कामो सी आरु जादा माहापाप नी कोरसे, पोरबु योहोवान यो बुल छे। ");
INSERT INTO dhn_vpl VALUES ("EK16_44","027_16_44","EZK","16","44","44","देख, आखा कोहाड़ु कोहनिवाळा तारा वाराम यु कोहाड़ो कोहसे, जोसी आईस तोसी पोराय। ");
INSERT INTO dhn_vpl VALUES ("EK16_45","027_16_45","EZK","16","45","45","तारी आईस जी आपसा धेनी आरु पुर्या सी घाड़ाय कोरती हुती, तु वी तोसीत तेरीन पोराय कोहायी; आरु तारी बोहोनस्या जे आपना आपना धेनी आरु पुर्या सी घाड़ाय कोरती होती, तु वी तोसीत तेंदरी बोहनीस निकळी। तारी आईस हित्ती राजोन आरु बास एमोरी राजोन हुतो। ");
INSERT INTO dhn_vpl VALUES ("EK16_46","027_16_46","EZK","16","46","46","तारी मोटली बोहनीस सोमरोन छे, ची आपसा पोरायटा पुठी तारे डाखरीये ओख्ये रोहे, आरु तारी नानली बोहनीस, ची तारे जेवड़्ये ओख्ये रोहे त्या पोरायटा भेळ सोदोम छे। ");
INSERT INTO dhn_vpl VALUES ("EK16_47","027_16_47","EZK","16","47","47","ऐ योरुसालेम, तु पेहलेन तिंदरे सारको घाड़ायीन काम नी कोर्‌यो नी ते तिंदरे जोसो सारको भुंनलो वेवहार नी कोर्‌यो। पुन थुड़ाक टेम मा भुंनला काम कोरनेम तु तेनुक पोछोव कोर देदु; तु तेनुसी जादा बिगड़ी गोयु। ");
INSERT INTO dhn_vpl VALUES ("EK16_48","027_16_48","EZK","16","48","48","ऐ योरुसालेम, हांव पोरबु योहोवान यो बुल छे, मार जीवनोन आन, तारी बोहनीस सोदोम आपसा पोरायटा भेळ तारे आरु तारा पोरायटा सारको काम नी कोर्या। ");
INSERT INTO dhn_vpl VALUES ("EK16_49","027_16_49","EZK","16","49","49","देख, तारी बोहनीस सोदोम आरु हेरा पोरायटा पापी हुता। तिंदरे जु जोरुरोत सी जादा खानोन होतो आरु हेनका पास बेसको जादा टेम हुतो। त्या विखावाळा खाने नी होतो तेनु मानसोन मोदोत नी कोरतेला। ");
INSERT INTO dhn_vpl VALUES ("EK16_50","027_16_50","EZK","16","50","50","सोदोम आरु हेरा पोरायटा आड़काट घाड़च्या होय गोया आरु मारे ओगोळ बेसका पाप कोरने लाग्या। जोत्या हांव हेनुक हेंदरो कामोन कोरता देख्यु ति हांव डोन आप्यो। ");
INSERT INTO dhn_vpl VALUES ("EK16_51","027_16_51","EZK","16","51","51","ओळतेन सोमरोन तारा पापोन आदा वी पाप नी कोर्या, तु ते तेरेसी वोदीन घाड़ायन काम कोर्‌यो, आरु आपसो बेस घाड़ाइन कामोन लारे आपसी बोहनीस तारे गोथी कोम गुनाकी कोवायी। ");
INSERT INTO dhn_vpl VALUES ("EK16_52","027_16_52","EZK","16","52","52","ओतरान कोरीन तुमु लाजवायनो जुवे। तुमु आपसी बोहनीसुन सी आपसा सी वारु लागनेवाली बोनावला छे। तुमु बेसका पाप कोरला छे ऐने तुमुक लाज आवनो जुवे। ");
INSERT INTO dhn_vpl VALUES ("EK16_53","027_16_53","EZK","16","53","53","जोत्यार हांव पोरायटा भेळ सोदोम आरु सोमरोन काजे बंदुवाय सी छुड़ाय लावीस, तोत्यार हेंदरे विच तारा बांदायलाक वी पोछा ली आवीस, ");
INSERT INTO dhn_vpl VALUES ("EK16_54","027_16_54","EZK","16","54","54","जेरेसी तुसे लाज आवे, आरु आपसा आखा कामोक देखीन लाज आवनो जुवे, काहकी तु हेंदरी शान्तिन कारण होयली छे। ");
INSERT INTO dhn_vpl VALUES ("EK16_55","027_16_55","EZK","16","55","55","तारी बोहनीस सोदोम आरु सोमरोन आपसा आपसा पोरायटा पुठी आपसी पेहलुन टेम होती चां पुग जासे, आरु तु वी आपसा पोरायटा पुटी आपसी पेहली टेम होती तोसा ओळी पुगसु। ");
INSERT INTO dhn_vpl VALUES ("EK16_56","027_16_56","EZK","16","56","56","वित्या दाहड़ाम तु घाड़साय होती आरु आपसी बोहनीस सोदोमोन वायकेड़ा कोरतेली। पुन तुमु तोसा ओळी कोर सोकसु। ");
INSERT INTO dhn_vpl VALUES ("EK16_57","027_16_57","EZK","16","57","57","तुमु यो डोन जोड़ने सी पेहेल आपसा धोड़ेवाळा सी वायकेड़ा कोरने सी पेहेल कोरला हुता। एदोमोन पुर्या ऐने पोलिस्ती हेमी तुमरा वायकेड़ा उड़ावसे। ");
INSERT INTO dhn_vpl VALUES ("EK16_58","027_16_58","EZK","16","58","58","पुन हेमी तुसेक आपना मोटला पाप आरु घाड़ायीन कामोन भार आपसुत् हुचलनो पोड़लो छे, योहोवा भोगवानोन यो बुल छे। ");
INSERT INTO dhn_vpl VALUES ("EK16_59","027_16_59","EZK","16","59","59","पोरबु योहोवा ओसो कोवे: हांव तारे पुठी ओसो वेवहार कोरीस जोसो तु कोरलो छे, काहकी तु ते वायदाक तुड़ीन आन काजे उदुड़ जानलो छे। ");
INSERT INTO dhn_vpl VALUES ("EK16_60","027_16_60","EZK","16","60","60","ते वी हांव तारा नानला होता तेनु दाहड़ान आपसा वायदाक फोम कोरावीस, आरु तारे पुटी जोलेमकु वायदु बांदीस। ");
INSERT INTO dhn_vpl VALUES ("EK16_61","027_16_61","EZK","16","61","61","जोत्यार तु आपसी बोहनीस काजे आपसी मोटली आरु नानली बोहनीस काजे खुवे लेये, तोत्यार तु आपसो चाल चालोन फोम कोरीन लाजे पोड़नो पोड़से; आरु हांव हेनुक तारा पोरायटा कोहाड़ीस; पुन यो तारा वायदान ओनसारे नी कोरीस। ");
INSERT INTO dhn_vpl VALUES ("EK16_62","027_16_62","EZK","16","62","62","हांव तारे पुठी आपसा वायदाक एक जागे कोरीस, आरु तोत्यार तु जान लीस की हांव योहोवा छे। ");
INSERT INTO dhn_vpl VALUES ("EK16_63","027_16_63","EZK","16","63","63","जेरेसी तु फोम कोरीन लाजे पोड़े, आरु लाजे मोरीन ओळी कोदी मुय नि उगाड़े। यो तेने टेमे होयसे, जोत्यार हांव तारा आखा कामोक ढांक लीस, पोरबु योहोवान यो बुल छे। ");
INSERT INTO dhn_vpl VALUES ("EK17_1","027_17_1","EZK","17","1","1","पोरबु योहोवान यो बुल मारेंचा पुग्यो: ");
INSERT INTO dhn_vpl VALUES ("EK17_2","027_17_2","EZK","17","2","2","हे मानसोन ओवलियाद, इसराएलन घोराना सी यी छुड़ेवनाय काहानी कोव आरु काहानी कोव: ");
INSERT INTO dhn_vpl VALUES ("EK17_3","027_17_3","EZK","17","3","3","पोरबु योहोवा ओसु कोवे; एक नाम्बला पाखड़ावाळो, पाखड़ा सी भोरलो आरु भात भातीन रोंगोन मोटला उकाब चिल्‌लान लोबानोन जायीन एक वेलावाळान फुनगी चुट लेदो। ");
INSERT INTO dhn_vpl VALUES ("EK17_4","027_17_4","EZK","17","4","4","तोत्यार चो तेनी फुनगीन आखासी उपोरुन पातळी डाळ काजे तुड़ लेदो, आरु चो लेन देन कोरनेवाळा देश मा ली जायीन वेपारीन हाटोम लागाड़्यो। ");
INSERT INTO dhn_vpl VALUES ("EK17_5","027_17_5","EZK","17","5","5","तोत्यार तेना देसोन बिजोक लीन एक पीयोत खोतोम वेर्‌यो, आरु चो बोंदा धोड़े वाळा जागाम मोजनु झाड़ सारको बीज वेर्‌यो। ");
INSERT INTO dhn_vpl VALUES ("EK17_6","027_17_6","EZK","17","6","6","चो उगीन नानीस वेलायने वाळा ओंगुरोन वेला होय गोया जेरेसी डाळ्या नेचा वोळने लाग्या, आरु तेरा मुवे तेरे नेचा खोव्‌वाया, ऐने रीते सी चो ओंगुरोन वेला होईन कनखा फुड़ने आरु पानटा सी भोरायने लाग्यो। ");
INSERT INTO dhn_vpl VALUES ("EK17_7","027_17_7","EZK","17","7","7","ओळतेन एक आरु नांबला पाखड़ावाळा आरु पाखड़ा सी भोरायला मोटलो उकाब चिल्लो हुतो; आरु त्यो ओंगुरोन वेला उना जागा सी जां त्यो लागाड़लो हुतो, उना दिसरा उकाब भेनी आपसा मुवे खोव्‌वायने आरु आपसा डाळ्या नेचो कोरने लाग्य