﻿USE sofia;
DROP TABLE IF EXISTS sofia.dhgduwadha_vpl;
CREATE TABLE dhgduwadha_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES dhgduwadha_vpl WRITE;
INSERT INTO dhgduwadha_vpl VALUES ("PR3_5","021_3_5","PRO","3","5","5","Nhunum ŋarru yaka mä-ṉiṉ’thunma God-Waŋarrwuḻim yulthayuman yana. Dhäwul mä-yuwalktjiya nhuŋguwaywurum marŋgiyinyarawu, ḻinygu dhäwul nhunu dhaŋu marŋgi bukmakkum nhäwu malaŋuwu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Dhaŋun banha ŋuwakurrum dhäwu. Ga dhäwum dhaŋu God-Waŋarrwuŋun Gäthuꞌmiŋuwuŋ, ga ŋaykaṉam nhan banha Djesu. Nhanmam banha Christnha, Maŋutji-dhunupayumandan banha nhan God-Waŋarryu ŋätjil bäkumiŋgan. Ga dhäwum nhanguŋ yakan dhaŋu bitjan dhäya gamꞌ ŋurruyirrꞌyunma: ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Dhäwul mu nhan banha Djesuyu ŋurruyirrꞌyuwanam warkthuwanam, ŋarru God-Waŋarryum banha ḻinygu djuyꞌyuwan yolŋuny yäkuny Djonnham. Nhän banha Djondhu dhukam nhanbal Djesuwum yäkthuwan. Ga ŋätjil mu nhan banha ḻinygu yakan God-Waŋarryum bäki banha nhanguwayma djawarrkminy yolŋuny yäkuny Yitjayany. Ga bitjan nhan banha ŋätjilim wukirri gamꞌ: “Ŋäkan warra! Dhaŋum ŋaya yaka djuyꞌyuna yolŋunhan dhäwuminhan nyäkuway. Nhan ŋarru dhukan yäkthun nhuŋgun. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ga ŋarruŋam nhan ŋarru banhayam yolŋu ŋunha wiraŋḻin ŋayiḻim yolŋunharraḻin, ga ŋunhalayan nhan barkthu banha djawarrkthum, ‘Bukmak yolŋu birrkamiŋa, gatjuy, ŋamaŋamayunmiyan nhangum Garraywum. Ga dhukam dhunupayuman, bala gumurr-ŋuwatjiyan nhangu.’ ” Ga bitjan nhan banha Yitjayayum wukirri. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","6","Ga banhayam yolŋu yäku Djonnha banha Buku-ḻupthumandamin yolŋu. Ga nyenanam nhan yakan banha guŋnharran yolŋunharraŋan ŋayiŋam galki yana maniŋa yäkuŋa Djodannha. Ga girriꞌyum nhan yakan banha dhaṯthunminam gamulwuḻ bulkaꞌyum, ga biralma nhangu djämawuyma wäyinguru bulkaꞌyu. Ga ŋatham nhan yakan ṉokan ga ḏetjnha ga gukun. Djonma yakan banha nyenan bitjan banha God-Waŋarrwu djawarrkmi yolŋu yäku Yilaydja yakan nyenan ŋätjil. Ga bilanyamiyum guḻkun yakan banha yolŋum warra ŋarruŋan Djurutjalamŋurum ga birrkamiŋuru ŋayiŋuru bewaḻi Djudiyaŋuru makaŋuru, ga ŋarruŋanam yakan balan Djongun yana ḏoyꞌyuwan. Ga ŋarruŋanam dhanal banha, ḻinygu dhanal banha djälmiyin dhanal ŋarru nhäma nhanany, ga ŋäma nhanguŋ dhäwu nhalpiyan nhan bayiŋ yaka marŋgiyuman. Ga bitjan nhan yakan dhanaliny wäŋanam, “Wäy, yulparra, rakaraŋan warra dhawaṯthuman nhumaliŋguway maḻikum malany, bala bilyuwan, bala yana ganakan, mä nhan ŋarru God-Waŋarryum nhumaliŋgu baya-rakaraman. Ḏupthuwan warra dhuwan maḻikum malany bala buku-ḻupthuwan mä ŋarru bayiŋuyam yaka maŋutji-rakaram banha nhumam ḻinygun ŋuwakurrun.” Ga banha dhanal ŋarruŋan maḻikum malany dhanaliŋguway rakaran dhawaṯthumanam, bala nhan dhanaliny yakan buku-ḻupthumanan ŋunhalan Djodannha maniŋam. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ga bitjan nhan dhanaliŋgu wäŋanam, “Yo, dhikam yaka waripum yolŋu ŋarruŋa biyapulnha walꞌŋu dhika djuḻkthumana yaka nhänanham. Ga ŋayapim dhaŋu dhäwul yana ganaꞌ ŋunhukum nhangu djalkiriwuywum yapthumandawu. Räywuy dhaŋu ŋayam yolŋu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ŋayam yaka nhumaliny dhaŋu buku-ḻupthuman gapuyu yana waŋganydhu, ŋarru nhanmam ŋarru banha God-Waŋarryum rarryun Dhuyu Birrimbirrnha nhumaliŋgum, banha yaka djuḻkthumana.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ga bilanyamiyum nhan Djesum ŋarruŋanan beŋurum Galaliŋurum makaŋuru ŋayiŋuru, yäkuŋuru Nätjiritjŋurum, nhan ŋarru Djongun ḏoyꞌyun. Bala nhan Djondhum nhanany Djesunham buku-ḻupthumanan banhalayan Djodannha maniŋam. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ga banha nhan Djesu gapuŋurum dhawaṯthuwan, bala banha djiwarrꞌma ḻapthuwanan. Ga God-Waŋarrwum Dhuyu Birrimbirrma yarrupthuwanan nhanguḻ bilanyan bitjan wäyin yäku murryil. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Bala dhanal ŋäkulan rirrakayma wäŋan yakan bitjan, “Dhaŋun banha nyäku marrkapmim gäthuꞌmiŋu. Ŋaya yaka marimin goŋmiyim nhanguḻ.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ga bewaḻiyam dhurrwaraŋuru, bala nhän Dhuyu Birrimbirryum djawyuwanan Djesunham gänaŋuḻin ŋayiḻi wiraŋḻin. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ga ŋunhalayan ŋayilpiꞌŋan nhan yakan banha nyenanam 40-n walum. Ga waripum yakan banhalaya nyenan wakinŋumin wäyin malany. Ga banhalayan nhanany yakan banha Djaytindhum dharrwunuwan. Ŋarru nhanmam dhäwulnha nhanbal malthuwan. Bala banha djiwarrꞌpuyma dhäwumim yolŋu warra ḏoyꞌyuwanan guŋgaꞌyundawum nhangu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Waŋganymiyum waluyu dhanal gathanan Djonnham banha Buku-ḻupthumandaminham yolŋuny bala djuḏupꞌthumanan dharruŋguḻin. Bala nhanmam banha Djesum ŋarruŋan balan Galaliḻin makaḻi, mä nhan ŋarru rakaraman God-Waŋarrwum ŋuwakurrum dhäwu banhalayan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ga bitjan nhan yakan wäŋanam, “Ŋäkan warra, yulparra! Garraywum dhaŋu walu ḻinygun ḏoyꞌyuwanan! Ga yolŋum warra ŋarru banha guḻkun yana marŋgiyim banha God-Waŋarrwum ŋarru rom nhanguway ŋarruŋanhamiŋgana, ga dhaŋun banha yulŋum djinaŋun bala. Gatjuy bilyuwan warra mayaliꞌ-golanhamiŋurum romŋuru, bala ḏitjuwan, bala malthuwan nhangun God-Waŋarrwun dhärukkum. Bala mä-yuwalktjiyan bayikuyan God-Waŋarrwu ŋuwakurruwun yana dhäwuꞌwum.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Waŋganymiyum nhan yakan Djesu ŋarruŋan ŋunha räy-warryuwan guḻunꞌgu Galaliwuywu. Ga ŋunhalam nhan maḻŋꞌthuman yolŋuny yäkuny Djäymannha ga guthaꞌmiŋuny nhangu Wanduruny. Banhalaya dhupal nyin ŋarirri boyan ganybuyu. Banhayan bili dhupaliŋgu banha djämam. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Bala nhan Djesum gawaꞌyuwanan dhupaliŋgu bitjanan, “Wäy, yulpulay! Gu malthuwan wulay nyäkun. Ŋayam ŋarru nhumaliny marŋgiyuman nhuma ŋarru yaka gaṯthuman yolŋunhan warrany.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ga banha dhupal ŋäkulam bilanyawuyma bala dhupal yana gananan banha ganybum, bala dhunupan yana malthuwanan nhangu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ga bitjan bala nhan Djesu ŋarruŋan ga nhäŋal nhan Djibidiwun yothuny wulanynha. Ga maḻamarrma banha wäwaꞌmiŋu yäku Djayim ga guthaꞌmiŋum nhanbal yäku ga Djon. Ga bitjanaya bili dhupalim yakan ganybu dhunupayuman marthaŋayŋa. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Bala nhan Djesum gawaꞌyuwanan dhupaliŋgu bitjanan, “Wäy, gu malthuwan wulay nyäkun!” Bala dhupal gananan dhupaliŋguway mäḻuꞌmiŋunham ga djämaminham warrany balayan bili marthaŋayḻin. Bala dhupal ŋarruŋanan malthuwanan nhanbal. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Bala dhanal ḏoyꞌyuwanan ŋunhalan Gapuniyamnha ŋayiŋa, nhan Djesu ga banhaya yolŋu warra banha dhanal yakan bämaraꞌyuwan nhanany. Ga Nyenanhamiyun Waluyu, nhan Djesum ŋarruŋanan balan Djuwwuḻ biryamiḻin buṉbuḻi, nhan ŋarru yaka marŋgiyumana dhanaliny banhalayan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ga banha yakan yolŋuyum warrayu ŋäkulam nhanany wäŋanharam ṉirryuwanan, ḻinygu nhan banha marŋgin marimin bayikuya mala dhäwuꞌwu. Ga djuḻkthumanhan yaka ŋunha Djuwwum rom-marŋgikunhamiwum warrawu marŋgiyumanda. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ga bilanyamiyu bili nhanmam yolŋu maḻikumi birrimbirrmi gulŋiyan balaya buṉbuḻi ŋarru dhä-rirrakaymin, ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","yatjuwan ŋarruŋan bitjan, “Wäy, Djesu ŋayi Nätjuritjpuy, nhäwu nhunu rälim gämurruꞌ ŋupan? Nhalpiyan nhunu ŋarru, baḏuwaḏuyunna ŋanapiliny, ŋatja? Ŋanapum dhaŋu dharaŋganatj nhuna, nhunum dhaŋu banhayan banha Maŋutji-dhunupayumandan yolŋu God-Waŋarrwuŋun dhawuꞌ-nhinathuŋganda ŋätjiliŋuwuynha. Nhunum dhaŋu God-Waŋarrwun banha Dharrpalnha Yolŋu, nhänharran.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Bala nhan Djesum dhäruk-guŋganminan dhaykuwanan manapan dhanaliny bitjanan, “Maꞌ mukthuwan, ga dhawaṯthuwan djinakuḻiyam yolŋuwuḻ!” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Bala nhan bayiŋuya maḻikuyum birrimbirryu rurrꞌrurryuwanan banha yolŋunham mariminan dhika. Bala nhan yana dhawaṯthuwanam dhä-rirrakaymin. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ga yolŋuyum warrayu banha banhalayam biryamiŋam buṉbuŋa nhäŋalam mä-maŋmaŋdhuwanan. Bala dhanal ŋarruŋan wäŋanharaminan bitjanan, “Nhän dhaŋum? Dhaŋum nhan ga dhäruk gathan maḻikuwun birrimbirrwu dhawaṯthumandawu, ga dhanalim yaka nhanany ŋunha dhärukma mäyaman yana. Nhä nhan yaka dhaŋu ŋalmaliny yuṯayun romdhum marŋgiyuman?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Bala yakan banha dhäwum ŋarruŋanan ḻatjuwarrꞌyuwanan banhalayam makaŋa ŋayiŋa Galalim. Yolŋum warra ŋarruŋan banha rakaranhaminan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ga banha dhanal ŋarruŋan dhawayawaṯthuwanam beŋurum banha biryamiŋurum buṉbuŋuru, bala nhan Djesum ŋarruŋan balan Djäymanguḻin ga Wanduruwuḻin ŋayiḻi. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ga banhalaya yakan Djäymangu mukulꞌmiŋu rumaruꞌ rirrikthuwan gorrmurꞌyu. Ga banha nhan Djesu ga malthundamim warra nhangu gulŋiyanam, bala nhanmam baya yolŋu yuṯthuwan bala rakaranan bitjanan, “Dhaŋu nyin worruŋu rirrikthun gorrmurꞌyu.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Bala nhan Djesum ŋarruŋanan balayan banha worruŋuwuḻin dhäykawuḻ, bala gathanan nhanany ŋarambiyan bala ṉakanhamiŋganan. Bala dhunupan yana banha gorrmurꞌma winyaꞌyuwanan. Bala nhan banha worruŋum dhäyka dhawaṯthuwanam bala ŋarruŋan galŋa-rrarrayuwanan ŋathawun dhanaliŋgu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ga banha ŋarruŋan walum gulŋiyan, bala yakan yolŋuyum warrayu rerriminham warrany bangalanan, ga maḻikuminham birrimbirrminy yolŋuny warrany balan Djesuwuḻin ḏukthumandawun. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ga guḻkun banha marimin yolŋum warra ḻuŋꞌthuwan balayam buṉbuḻi, be mu yakan mala-nhinathuŋganmin. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ga guḻkunhan nhan yakan banha yolŋunham warrany ḏukthuman, waripuŋa ga waripuŋa rerriŋurum. Ga ḏukthumanam nhan dhanaliny yakan bukmaknhan yana. Ga guḻku nhan yakan dhawaṯthuman maḻikunham birrimbirrnha malany. Ga dhanalim banha maḻikum birrimbirr mala marŋgiyinan nhangu, bala nhan Djesuyum dhurrwara-mukthumanan dhanaliny. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ga waripuyun waluyu ŋarru munhakumin, nhan Djesum ṉakamanan bala ŋarruŋanan dhawaṯthuwanan buṉbuŋurum. Ga ŋarruŋanam nhan banha gänaŋuḻin bukumiŋgandawum mä dhupal ŋarru Mäḻuꞌmiŋu nhangu wäŋanharami. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ga banha nhan Djäyman ga waripum malthundami warra ṉakamanam yakurrŋurum bala dhanal ranganan nhangu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ga banha dhanal nhanany maḻŋꞌthumanam bala dhanal bitjanan wäŋanam, “Wäy! Marrkapmi, guḻkun yaka dhaŋu yolŋum warra nhuŋu rangam.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ga nhanmam bitjan dhanaliŋgu buku-ganitjuman, “Ŋuwakurru dhuwaniyam. Ŋarru ŋalma ŋarru dhaŋu ŋurruŋum yaka ŋarruŋa ḻiwꞌyuman ŋunha waripumurru ŋayimurru mala. Dhaŋu banha ŋayi mala banha yaka galkiwatj dhäyaꞌdhaya. Ḻinygu ŋaya yaka djälmiyi ŋaya ŋarru rakaraman dhanaliŋgu banha Ŋuwakurrum Dhäwu, bili dhaŋuya mu nyäku banha warkma.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ga bewaḻiyam dhurrwaraŋuru bala nhan yakan ŋarruŋanan djuḏuꞌyuwanan Galalimurrun makamurru, mä nhan yakan rakaranan dhäwun ŋuwakurrun God-Waŋarrwuruynha ŋunhalan Djuwwuḻ biryamiŋan buṉbuŋa malaŋa. Ga bitjanaya bili nhan yakan banha maḻikunham birrimbirrnha malany ŋaŋꞌŋaŋdhuwan yolŋuwurum warrawuru. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ga bilanyamiyum waluyu yolŋu burrunhdhiyaꞌmi ŋarruŋan nhanguḻ Djesuwuḻ. Bala nhan bunꞌkumu-djipthuwanan ŋäŋꞌthuwanan guŋgaꞌyundawun bitjanan, “Marrkapmi, guŋgaꞌyuwa nhänany! Ŋayam marŋgi banha nhunum ŋarru dhaŋu maḻikuny rerriny dhirrkthirrknha nyäkuru winyaꞌyumana, bilaŋ nhunu djälma, mä ŋarru yaka yolŋum warra nyäku dhäwulnha bulum milnyaŋꞌthun.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Bala nhan Djesum wuyuwanan nhangu bala ŋarambiyaꞌ djarryuwanan, ga gathan nhan nhanany bala wäŋanan, “Djäl ŋaya dhaŋu, ŋaya ŋarru ḏukthumana nhuna. Ḻinygun nhunu dhaŋu ŋuwatjinan!” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ga dhunupan nhan banha ḏirramum ŋuwatjinan, winyaꞌyuwanan banha rerrim nhangura. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ga wäŋan nhan Djesu wanyuyun dhärukthum bala djuyꞌyuwanan nhanany ŋayiḻin ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","bitjanan, “Ŋuwatjuma yana guyaŋiyam! Ḻinygun nhunu dhaŋu ŋuwatjinan, ga dhäwulnha nhunu ŋarru rakaramam yolŋuwuḻim warrawuḻ. Bayikuya bili yana mala-ŋurrkanhayŋuwu Mawtjitjku romgum malthuwa banha ŋätjiliŋuwun. Ga bala ŋatjil ŋurruŋum ŋarrya ŋunha djirrikaymiwuḻ yolŋuwuḻ ga nhän ŋarru nhuna dhuwan rumbalma nhäma banha nhuŋgu rerrim yulthan yana winyaꞌyuwan. Bala nhunu ŋarru mundhurrnha guŋgan buku-wikaman God-Waŋarrnhan, mä ŋarru banha guḻkun yolŋum warra marŋgiyi banha nhunu dhaŋu ŋuwatjinan.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ga banha nhan banhaya yolŋu dhawaṯthuwanam bala nhan yakan ḻiwꞌyumanan rakaranam dhäwum birrkaꞌmilin ŋayilim. Ga guḻkun yakan banha yolŋum warra ranganam nhanbal Djesuwum. Ga dhäwulnha banha nhanbayim ŋarruŋan ŋunha yolŋu guḻkumiḻim ŋayiḻi, bili banha yolŋuyum warrayu nhanany gunganan, banham nhan yakan banhalayan bäyman wirwiryuwanam ŋayilpiꞌŋan ŋayiŋam. Ŋarru yolŋum warra yakan rangan yana nhangu, nhänharawun yakan djälmiyin. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ga bilaŋ nhämunhaꞌ banha walu djuḻkthuwan, bala nhan Djesum ḏitjuwanan balaya Gapuniyamḻin. Ga yolŋum warra ŋarruŋan banha rakaranhaminan Djesunham banha nhan ḻinygun yakan banhalayan ŋayiŋan nyenan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ga yolŋum warra ŋarruŋan banha ḻuŋꞌthuwanam birrkamiŋurun. Ga gulŋiyan ŋarruŋan ga dhaŋaŋ, be mu yakan mala nhinathuŋganmin, dhurrwaramurrum ŋaṉbawꞌyuwan. Bala nhan Djesuyum yakan marŋgiyumanan dhäwun rakaran God-Waŋarrwuruynha ŋayaŋuwuy. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ga banha nhan yakan baḏak wäŋan, dhanalim ḏämbunharrayum yolŋuyu warrayu yakan golanan gaṉuŋnham yolŋuny balan Djesuwuḻin. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ga bilin banha guḻkun marimin yolŋum warra yakan mala-ḻuŋꞌthumanminam banhalayam, ga bayaŋun banha dhanaliŋgum dhuka ŋalawitjan dhanal ŋarru banha yolŋuny banhayany goḻam Djesuwuḻ. Bala dhanal ŋalthuwanan ŋunha ŋapaḻin balaꞌpalaḻin, bala ŋarŋgan dhanal warkthuwan ŋunha garramatma dhunupa yana banha ŋalaŋa yakan Djesu dhäyan. Ga banha nhan ŋunha balaꞌpalam ḻapthuwan, bala dhanal yarrupthumanan banha yolŋunham ŋarru gayanhꞌthamin. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ga banha nhan Djesuyum dhanaliny nhäŋal bala nhan marŋgiyinan banha dhanal yultha yana nhanguḻ mä-yuwalkin. Bala nhan banha gaṉuŋnham yolŋuny bitjanan wäŋan, “Ḻinygun ŋaya dhaŋu nhuŋgu maḻikum rom baya-rakaranan.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ga banhalaya yakan ŋaḻapaḻmi Rom-marŋgikunhami yolŋu warra ḏäpthuwan, ŋarru ŋäkul dhanal banha Djesunham bilanyawuyma dhäruk wäŋanhara bala dhanal ŋayaŋu-maḻikinan, dhäwulnha dhanal galŋa-ŋuwatjinam bayiŋuya. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Bala dhanal bitjanan wäŋanharaminam, “Nhä dhaŋum, goṉanharran bilanyawum wäŋanharawu, ŋatja? Dhaŋu bayiŋ nhanbay yana God-Waŋarryu yolŋuwum warrawu baya-rakaram maḻikuwuyma rombuy. Nhalpiyan nhan yaka dhaŋu guyaŋim, yana warri nhan dhaŋu rrambaŋin dhupal God-Waŋarrnha, ŋatja? Dhaŋum nhan dhä-waripuŋuyinan bitjanam!” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ŋarru nhanmam banha Djesum dhanaliŋgu marŋgiyin bala nhan bitjanan wäŋan, “Dhäwul warra bitja guyaŋiya! ");
INSERT INTO dhgduwadha_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","10","Nhalpiyan dhika ŋaya ŋarru wäŋam? Banha ŋaya ŋarru bitjanma wäŋa, ‘Maꞌ, ḻinygun ŋaya nhuŋgu maḻikum rom baya-rakaranan’, nhumam dhaŋu yaka marŋgi banha nhan ŋarru bitjanya maḻŋꞌthun, wilak bayaŋun. Ga banha ŋaya ŋarru wäŋa bitjanma gamꞌ, ‘Maꞌ mäyaŋan nhuŋguway dhuwan gayanhꞌtham bala ŋarryan ŋayiḻin’, ga ŋärrun nhuma ŋarru banha nhämam banha ŋayam dhaŋu Yuwalkŋum Walꞌŋu Yolŋu dhaŋun. Ga ŋaya mu yaka dhaŋu ganydjarrma gathan baya-rakaranhawum yolŋuwum warrawu maḻikuwum.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Ga bewaḻiyam dhurrwaraŋuru bala nhan Djesum wäŋanan bayikuya gaṉuŋgum yolŋuwu bitjanan, “Yo, ŋäkan! Dhaŋum nhunu bilin ḏukthuwanan, gatjuy ṉakaman ga mäyaŋan nhuŋguway gayanhꞌtham bala ŋarryan ŋayiḻin.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ga banha nhan bayiŋuya yolŋuyu ŋäkulam bala yana ṉakamanan. Ga gayanhꞌtham nhanguway mäyan bala yana ŋarruŋanan dhawaṯthuwanan. Ga dhanalim banha yolŋuyum warrayu nhäŋalam mel-dhawaṯthuwanan, ganyimꞌthuwanan manapan bitjanan, “Dhaŋum ŋanapu gäthuran djinaŋun bala bilanyawuyma nhäŋal. Yultha yana nhan dhaŋu God-Waŋarrma ganydjarr yindim!” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ga bewaḻiyam nhan Djesu biyapul banha ŋarruŋan bala raŋiḻi Galaliḻi guḻunḻi. Ga guḻkun banha yolŋum warra gumurr-yuṯthuwanam nhangu bala nhan yakan rakaranan dhanaliŋguḻ God-Waŋarrwun ŋayaŋu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ga banhalaya yakan yolŋu nyenan yäku Lebay, Yalpiyatjku gäthuꞌmiŋu. Ga warkthuwanam nhan yakan banha molu-rrupiya ḻuŋꞌthuman yäku tax, banha Rawumbuywu gapmangu. Ga banha nhan Djesu ŋarruŋanam, bala nhan nhäŋalan Lebaynhan. Bala nhan bitjanan wäŋan, “Wäy wälaŋ, gu malthuwan nyäku!” Ga banha nhan Djesuny bilanyawuyma ŋäkul, bala nhan banha Lebayma ṉakamanam bala dhunupan yana malthuwanan nhangu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ga bewaḻiyam bala nhan Djesum ga malthundamim warra nhangu yakan nyenan banhalayan Lebaywuḻin ŋayiŋa rrambaŋin dhanalin ḻunduꞌmiŋun warra nhanbal Lebaywu banha rrupiya-wapthumandamin warra. Ga waripum yakan banhalaya yolŋu warra nyenan banha dhanal bayiŋ yaka Djuw malayu dhanaliny rakaram raypirri-waḏatjmin. Ga ŋunhalaya bili ŋurrukŋa yakan ḏäpthuwan yolŋu warra banha dhanal bayiŋ ga djälmiyi buthuru-bitjundawu nhangu Djesuwu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ga bilanyamiyum banhalaya yakan nyenan rom-marŋgikunhami warra Baratjiwuru ŋurrukŋuru. Bala dhanal nhäŋalan nhanany Djesunham nhan yakan ŋatha ṉokan banha tax djämamiwuḻin warrawuḻ ga dhuwurr-maḻikumiwuḻin yolŋuwuḻ warrawuḻ. Bala dhanal ŋäŋꞌthuwanan banha Djesuwum malthundaminham warrany bitjanan, “Wäy! Nhäwu yaka dhaŋu ŋunha nhumaliŋgum marŋgikunhami nyena tax djämamiwuḻim warrawuḻ, ga dhuwurr-maḻikumiwuḻim yolŋuwuḻ warrawuḻ?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ga nhanmam banha Djesuyum dhanaliny ŋäkul, bala nhan bitjanan dhanaliŋgu wäŋan, “Rerrimi yana yolŋu warra ŋarru ŋarruŋa marrŋgitjkuḻim, dhäwul ḏäwalamim. Ŋayam dhaŋu ŋarruŋan räli maḻikuwu yolŋuwu warrawu, yaka bayikuyam yolŋuwu banha dhanal bayiŋ ga be rom-dhunupa rakaranhami.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Waŋganydhum waluyu, yolŋu warra Baratjiŋuru ŋurrukŋuru yakan ŋoy-ŋathanharrami nyenan, yana bayiŋ romgun malthuwan. Ga nhäŋal dhanal banha Djongu Buku-ḻupthumandamiwu malthundaminy warrany dhanal yakan ŋoy-ŋathanharrami nyenan. Ga dhäwul dhanal banha Djesunham ga nhangum malthundaminy warrany nhäŋal bilanyaḻim. Bala yolŋum warra ḏoyꞌyuwanan nhangu Djesuwum bala dhä-wirrkaꞌyuwanan bitjanan, “Wäy, ŋanapum bayiŋ yaka dhaŋu ŋoy-ŋathanharrami nyena, bili romgu ŋanapu yaka malthun. Ga ŋunha yaka Djongum malthundami warra bitjanaya bili. Ga nhäwun yaka dhaŋu nhuŋgum malthundami warra dhäwulma bitjanaya nyena?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Bala nhan Djesuyum mayaḻiꞌmin dhäwu rakaran bitjanan, “Ḻinygu mu nhumam dhaŋu marŋgi: banha bayiŋ yolŋu wulay mäyanharami ga yolŋum warra bayiŋ banha dhäwulnha dhurrwara-yapthunma ŋathaŋurum, banham dhanal bayiŋ ga ŋatham ṉoka mu maranhuyumanmi. Ga banhayam ḏirramu banha nhan ŋarru mäyam dhäykany nhanguway, banha nhan ŋarru yaka banhalaya nyena, banham ŋarru yaka yolŋuyum warrayu ŋatham ṉoka mu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ga banha dhanal ŋarru banhayany ḏirramuny djawyunma, bala ŋarru banha ḻunduꞌmiŋum warra nhangu ŋayaŋu-maḻikin, ga ŋärrun dhanal ŋarru yaka ŋoy-ŋathanharramim nyena.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Bala nhan Djesuyum waripun dhäwu dhanaliŋgu rakaran mayaliꞌmin bitjanan, “Dhäwul ŋarru dhaŋu yolŋuyu djawarꞌyun dhä-manapan yuṯam manydjarrkaꞌ ŋunha ŋätjiliŋuḻim manapan. Ḻinygu yalalam nhan ŋarru banha girrimꞌ rurrwuyunma bala ŋarru banha yuṯam manydjarrkaꞌ dhurŋꞌthuna nyumukuṉinyꞌtjin, bala ŋarru banha girrimꞌ barryuna. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ga bilanya bili: dhäwul ŋarru dhaŋu yuṯa borum wiyikaꞌ rarryun ŋunha ŋätjiliŋuḻim batjiḻi, ḻinygu nhan ŋarru banha barryuna bala ŋarru wiyikamꞌ yuṯthuna. Yuṯam borum wiyikaꞌ ŋarru rarryun yuṯaḻi yana batjiḻi.” Bitjan nhan yakan banha dhanaliŋgu Djesuyu rakaranam, banha nhanguŋum yuṯam marŋgiyumanda ŋarru dhäwulnha maŋutji-manapan balam banha nhä dhanal bayiŋ yaka Baratjiyu warrayu marŋgiyuman. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Waŋganymiyum Nyenanhamiyu Waluyu Djesu ga malthundami warra nhangu yakan ŋarruŋan dhuka-ŋupan, ŋarru gätnimurru berrathamurru. Bala nhangu malthundamiyum warrayu ŋarruŋan bakpakthumanan muḻkurrnha ŋathan bala ŋarruŋan ṉokanan, bili dhanal banha marryaꞌyinan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ga dhanalim banha Baratjiyum yolŋuyu warrayu nhäŋalan dhanaliny bala bitjanan rakaran Djesuwuḻim, “Wäy! Nhäwu yaka dhaŋu nhuŋgurum malthundamiyu warrayu romma ŋalmaliŋgu bakthuman? Dhaŋu dhanal ŋarruŋ ŋunha ŋathan wapthuman djinaŋun warri Nyenanhamiyun Waluyu. Yaka dhanal ŋarru yaka bitjan!” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Bala nhan dhanaliŋgu buku-ganitjuman, bitjanan, “Wäy, yulparra, guyaŋi mu nhuma yaka banhayam dhäwu banha bilinyamiyu waluyu yakan Ḻiya-ŋärraꞌmi yäku Yabithaya nyenan. Ga dhanalim banha Daybitma ga malthundamim warra nhanbal marryaꞌyinan, bala dhanal yana ŋarruŋanan bala gulŋiyanan bala Djuwwuḻin biryamiḻin warrawꞌḻi, bala ŋarruŋan wapthumanan banha ŋatham. Ga rom yakan barraŋgaꞌyuwan banha ŋarru djirrikaymiyun yana ṉokam banhayam ŋatham, dhäwulnha gulkuꞌyum. Ga nhanmam banha Daybitthum ga malayum nhanguru ṉokan yana, ga dhäwulnha dhanaliny banha yolŋuyum warrayu rom-nyamirꞌyuwan.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ga biyapul nhan Djesu bitjan wäŋan, “Wäy yulparra, dhäwul warra meṉguŋam, banha God-Waŋarrwum Nyenanhamim Walu ŋarru yaka djäma guŋgaꞌyundawu yolŋuwu. Dhäwul nhan banha yolŋuny djäma nhan ŋarru yaka bayikuyan bili yana Nyenanhamiwun Waluwu romgu malthun. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ḻinygu ŋayam dhaŋu Yuwaḻkŋum Walꞌŋu Yolŋu, nyäkuwaynha dhaŋu dhunupam banha ŋaya ŋarru wäŋa yolŋuny nhä nhan ŋarru djäma, wo dhäwul nhan ŋarru djäma bilanyayu Nyenanhamiyu Waluyu.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ga bewaḻiyam nhan Djesu ḏitjuwanan balan Djuwwuḻ biryamiḻin buṉbuḻi. Ga ŋunhalam nhan maḻŋꞌthuman yolŋunhan ŋarru goŋ-dhoṯnhan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ga banhalaya yakan Baratji warra ŋaḻapaḻmi dhäyaꞌdhayan ŋarru dharr-witjan dhanal yakan banha Djesunham nhäŋal ŋala nhan ŋarru ḏukthuman yolŋuny Nyenanhamiyu Waluyu, mä dhanal ŋarru nhangu Djesuwu mari-ḏoyꞌyun bayikuwuynha. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Bala nhan Djesum gawawꞌyuwanan banha goŋ-dhoṯkum yolŋuwu bitjanan, “Wäy! Gu, ṉakaman rälin, ga djinalan dharriya gumurrŋan, mä ŋarru guḻkuyun yana nhämam.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Bala nhan Djesum wäŋanan banha Baratjiwum yolŋuwu warrawu bitjanan, “Nhalpiyan yaka ŋalmaliŋgum rom wäŋa djinakum banha Nyenanhamiwum Waluwu? Nhä mu dhaŋu dhunupa ŋalma ŋarru ŋuwakurrum djäma yolŋuwum warrawu bilanyayum waluyu, wo ŋalma ŋarru ga maḻikun yana warkthun? Nhalpiyan dhika ŋaya ŋarru wälŋayuman, wo nhalpiyan ŋayaŋu-maḻikuyumana,” Ga dhanalim banha Baratjim warra dhäwulnha nhangu buku-ganitjuman. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Bala nhan ŋarruŋan Djesuyum nhäŋalan yolŋunham warrany, ga mariminan nhan banha dhanaliŋgu maḏakarritjinam, warwuyuwanan manapan ḻinygu dhanal banha ŋayaŋu-wanyumin. Banham dhanal yakan romgun yana dhanaliŋguwaywuru mariminam malthuwan. Bala nhan Djesum wäŋanan bayikuya goŋ-dhoṯkum bitjanan, “Maꞌ goŋ djarrꞌyuwan!” Bala nhan banha yolŋum ŋarambiyam djarryuwanan, bala nhan yana ŋuwatjinan dhunupayinan yana. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Bala banha Baratjim yolŋu warra ŋarruŋanan ḻatjuwarrꞌyuwanan ga ŋunhalan bala dhanal ḻuŋꞌthumanminan waripun yolŋu warra, Geŋ Yaritkun ŋaḻapaḻmi ŋurru-warryundayŋun warra. Ga banhalayan dhanal yakan wäŋanharaminam boyandawun nhangu Djesuwum. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Waŋganymiyum waluyu nhan Djesu ga malthundami warra nhanŋu ŋarruŋan balan yindiḻin guḻunꞌḻi Galaliḻin. Ga guḻkun banha yolŋum warra nhangu malthuwanam, ḻinygu dhanal ŋäkul banha nhä nhan yakan Djesuyu warkthuwan. Ga yolŋum warra banha ŋarruŋanam beŋuru Galaliŋuru makaŋuru ga Djudiyaŋuru makaŋuru ga Yidumiyaŋuru makaŋuru. Ga waripum banha yolŋu warra ŋarruŋan beŋurun ŋayiŋuru Djurutjalamŋurun ga Djaydanŋurun ga Däyaŋurun. Ga guḻku waripu yolŋu warra ŋarruŋan beŋuru Djodanŋurun maniŋuru ŋarru galiꞌ dhimurruŋurun. Ga bukmak dhanal yakan banha ḏuktukmiyinam dhanal ŋarru dhanaliway yana nhäma nhanany Djesuny. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Ga guḻkunhan nhan banha Djesuyu ḏukthuman bilanyamiyum waluyu. Ga guḻku yolŋu warra yakan djälmiyin dhanal ŋarru nhanany gathan mä dhanal ŋarru ŋuwatji. Bala ŋarruŋan banha yolŋum warra giṯthuwanan, ḏurꞌṯuryunminan ŋarruŋan ŋunha galkin yanan nhangurumurrun, bala nhan wäŋanan nhangu malthundamiwum warrawu bitjanan, “Wäy, marthaŋay warra nyäkuḻ mäyaŋ, ḻinygu bayaŋun dhaŋu dhaḻakarrma nyäku. Banha ŋarru dhaŋu yolŋuyum warrayu nhänany djorkumam, ŋayam ŋarru marthaŋayḻin ŋalthun.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ga waripum banha yolŋu warra balaya ŋarruŋan maḻikumin birrimbirrmi malany. Ga banha dhanal bayiŋuya yolŋuyu warrayu nhäŋal Djesunham, bala yakan birrimbirryum mala djalkthuwanan yolŋunham warrany munathaꞌḻin bala ŋarruŋan yatjuwanan bitjanan, “Nhunum dhaŋu God-Waŋarrwun Gäthuꞌmiŋu.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ŋarru nhanmam dhanaliny banha dhurrwara-mukthumanan bitjanan, “Dhäwul nhuma ŋarru yolŋuwuḻim warrawuḻ rakaram, yol Ŋaya dhaŋu!” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Bala nhan Djesum ŋarruŋanan bukuḻin ŋalthuwan bala gawawꞌyuwanan ḏirramuwun warrawu banha dhanaliŋgu yakan ŋayaŋu dhä-manapan nhanguḻ Djesuwuḻ, malthundawun nhangu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ga djarrꞌyuwanam nhan banha 12-nhan ḏirramunham warrany mä dhanal ŋarru yaka nhangu malthuna bitjana ḻinygu, dhaŋum djuyꞌyundan warra nhangu. Ga ŋarruŋam dhanal ŋarru yaka birrkamiḻin ŋayiḻim dhäwun ŋarru yaka rakaram God-Waŋarrwuruynha yolŋuwuḻin warrawuḻ. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ga guŋan nhan dhanaliny ganydjarr, mä dhanal ŋarru yaka maḻikuny birrimbirrnha malany dhawaṯthumana yolŋuwuḻim warrawuḻ. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Ga dhaŋu banha yolŋum warra gamꞌ: Djäyman (banha Djesuyu nhanany yäku gunyan Beta), ga Djayim, ga Djon, dhaŋum wulay banha Djibidiwun gäthuꞌmiŋu wulay. (Ga Djesuyum dhupaliny banha waripun yäku guŋan, ‘Bawunatjnha’ mayaliꞌ ‘Murryuꞌmurryundamin’.) ga Wanduru, ga Bilip, ga Bäthalamiyaw, ga Mathiyu, ga Dumitj, ga Djayim (Yalpiyatjku gäthuꞌmiŋu), ga Dhadayatj, ga Djäyman, (banha nhan yakan malthuwan Djalatkun malawu), ga Djudatj Gariyatnha (dhaŋun banha yolŋu mulkuruyin Djesuwum.) ");
INSERT INTO dhgduwadha_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yo, bala nhan Djesum ga malthundamim warra nhangu yarrupthuwanan bukuŋurum. Ŋarruŋanam dhanal banha bala buṉbuḻin gulŋiyan. Ga bitjanaya ḻinygu banha yolŋum warra ḻuŋꞌthuwan guḻkun marimin, ga dhäwulyinan banha dhanaliŋgu walum ŋathawum nyäŋꞌthundawu nhangu Djesuwum ga malthundamiwum warrawu nhanguru. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ga be yol yolŋu ŋarruŋan ga rakaran nhanguḻ gurruṯumiwuḻ warrawuḻ, “Gu ŋunha yaka Djesum bawaꞌyuna, djämayun malaŋuyu!” bitjan. Bala dhanal gurruṯumim warra nhangu ŋarruŋanan mä dhanal ŋarru nhanany gaḏaymana ŋayiḻin. Dhanal ŋarru yaka dhanaliwaynha nhangu djäka. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Manymak, ga rom-marŋgikunhami yolŋu warra ḏoyꞌyuwan beŋuru Djurutjalamŋuru ga bitjanaya ḻinygu dhanal Djesuny nhäŋal, bala bitjanan dhanal wäŋan, “Wäy, yulparra, dhäwul nhuma ŋarru yaka djinakum malthun, bili ganydjarrma nhan bayiŋ yaka dhaŋu mäyam Djaytinguŋ banha nhan buŋgawan maḻikuwun birrimbirrwu malawu, ga waripum nhan banha ŋaykaṉa Beltjibulnha. Ga bilanyawun nhan bayiŋ yaka dhaŋu maḻikunham birrimbirrnha mala dhawaṯthuman.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ga nhanmam banha Djesum marŋgiyin banha nhalpiyan dhanal yakan wäŋan, bala nhan gawaꞌyuwanan dhanaliŋgu, “Gu, rälin ŋarrya ga buthuru-witjuwa warra nyäku,” bitjan. Bala nhan dhanaliŋgu dhäwun rakaran mä warraŋulyumanan. Ga bitjan nhan banha wäŋanam gamꞌ, “Nhalpiyana nhan ŋarru banha Djaytindhum boyan Djaytinnham? Dhaŋum mayaliꞌnharran rom. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ŋäka warra! Banha ŋarru yaka yolŋu warra boyanmi waŋganybuyma ŋayiwuy, dhanalim ŋarru ganydjarrnharrayin bala ŋarru malam dhawarꞌyuna. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ga banha ŋarru yaka waŋgany bäpurru yolŋu warra bitjan ḻinygu boyanmi, bala ŋarru banha yolŋum warra gurruṯumim latjuwarryuna malam, bala ŋarru dhawarꞌyuna. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ga bilayaya ḻinygu, banha ŋarru yaka Djaytindhu boyan malanham nhanguway, bala ŋarru banha bukmaknha dhanal ganydjarrnharrayim bala ŋarru dhäwulyin, dhawarꞌyuna ŋarru! ");
INSERT INTO dhgduwadha_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ga ŋäkan warra dhaŋum mayaliꞌmin dhäwu ŋaya ŋarru rakaram: Waŋgany yolŋu ḏukṯukmiyin nhan ŋarru girriꞌ manaŋi ŋunha wanyuwuḻ yolŋuwuḻ. Ga ŋurruŋum nhan ŋatjil ŋarru mataꞌyuman banha wanyunham yolŋuny, ga ŋärrun nhan ŋarru girrimꞌ malany wapthuman. Yo, dhaŋu nhan banha mayalimꞌ gamꞌ djinalaŋam dhäwuŋa: Djaytinma, nhän banhaya wanyu yolŋu, ga ŋayam banha waripun yolŋu banha nhan mataꞌyumanan nhanany, banhayam ŋayan Djesun. Ga djinaŋum bala ŋaya yaka wapthumana nyäkuwayma yolŋuny warrany beŋurum nhangurum goŋŋa. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Dhaŋum waripun yulthan dhäruk ŋaya ŋarru rakaram: Bilaŋ nhunu ŋarru maḻikuyuman wäŋa God-Waŋarrwum, wilak nhan ŋarru God-Waŋarryu nhuŋgu baya-rakaram. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ga banha nhunu ŋarru maḻikuyuman wäŋa nhangum Dhuyu-Birrimbirrwum, nhanmam ŋarru banha God-Waŋarryum dhäwulnha nhuŋgum baya-rakaram, ga yanatj ḻinygu-u-u ga ŋayi barkthu dhaŋu dhä-dhawarꞌyu!” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ga bitjan nhan banha Djesu wäŋanam, ḻinygu dhanal nhangu banha bitjan wäŋan, “Dhaŋum yolŋu maḻikumi birrimbirrmi.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ga bewaḻiyam Djesuwu ŋäṉḏiꞌmiŋu ga guthaꞌmiŋu warra nhangu ranganan. Bala dhanal yakan dhäyaꞌdhayanan warraŋulnha banhalaya buṉbuŋa, banha ŋalaŋa nhan yakan marŋgiyumanan yolŋuny warrany. Ga djuyꞌyuwan dhanal yolŋuny garrꞌyundawu nhangu Djesuwu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ga bilanymiyum nhanmam yakan banha Djesuyum marŋgiyumanan yolŋunhan warrany. Bala nhan yolŋum ŋarruŋanan, bala bitjanan wäŋan, “Wäy! Dhaŋu ŋäṉḏiꞌmiŋu nhuŋgu ga guthaꞌmiŋu warra yaka rangam nhuŋgu,” bitjan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Bala nhan Djesum bitjanan wäŋan, “Yol warra dhika nyäku gurruṯumim?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Bala nhan ŋarruŋan nhäŋalan ḻiwꞌyumanan banha yolŋunham warrany banha yakan ḏäpthuwan. Bala nhan bitjanan wäŋan, “Dhaŋun warra dhaŋu nyäkum ŋäṉḏiꞌmiŋu ga guthaꞌmiŋu warra. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Banha nhan bilaŋ yol yolŋu ŋayaŋu-malthundami God-Waŋarrwum ŋayaŋuwu, banhayan warra dhaŋu nyäkum galkiwuyma gurruṯumi warra.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Waŋganymim nhan Djesu balaya ḏitjuwan Galaliḻi. Ga guḻkun banha marimin yolŋum warra ḻuŋꞌthuwanam nhanguḻ balayam. Bala nhanmam banha marthaŋayḻin ŋalthuwan, bala dhanal yarrkyarrkthuman marthaŋaynham mä gaŋga barrkuḻi, bala nhan nyenanan ga bewaḻiyan nhan yakan banha dhäwum dhanaliŋgu rakaran, marŋgiyumanam dhanaliny. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ga guḻku nhan yakan banha dhäwum mayaliꞌmiŋanam rakaran, mä dhanalim yakan banha yolŋuyum warrayu dharaŋganan yana. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Yo, ŋäkan warra. Waŋgany yolŋu djälmiyin nhan ŋarru maŋutji ŋatha yaka djalkthun bala munathaḻiꞌ mä ŋarru ŋatha banha ŋuthan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Bala nhan ŋarruŋan djalkthuwanan. Ga waripum banha maŋutji gälkin mä bayiŋ bärrkuḻi, dhukamiḻi. Ga dhanalim banha wäyindhum nhäŋal bala ŋarruŋan ṉokanan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ga baḏaknha yana nhanmam yakan banha bayiŋuyam yolŋuyu maŋutjim djalkthuwan, waripum yakan gälkin bitjanan bala, ga waripum gälkin bäthumiḻin ŋayiḻi. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ga ŋatham banha maŋutjim ŋuwatjinan ŋuthan bondin, ga banha nhan walum gorrmurꞌyin mariminam bala banha ḏukitjma baṉḏanydjinan, räwaktjinan, bala waŋayinan, ḻinygu bäthun yana banha, ga dhäwulnha munathamꞌ. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ga mawaŋganynha nhan ŋarruŋan bala maŋutjim djalkthuwan, ga waripum banha maŋutji gälkin ḏimirrꞌṯimirrmiḻin. Bala bayiŋuyam banha ḏimirrꞌṯimirryum djorkuwanan, ganydjarrnha dhawarꞌyuman ŋuthandawun. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ga waripum banha ŋatha gälkin ŋuwakurruḻin munathaꞌḻi. Bala ŋarruŋan ŋatham ŋuthanam buṯ-bitjanan. Ga banha ŋatham ŋuwatjin, waŋganybuyma guḻunbuy giḻyuwanan yakan guḻkun yana marimin dhika. Ga waripuŋa-a-a ga guḻku yana, ga waripuŋa ga bilanya ḻingu, ga bitjanan bala. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Bilaŋ nhuma buthurumim, ŋäkam warra ŋuwatjuman, mä nhuma ŋarru dharaŋgan yana dhaŋu mayalimꞌ.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Bala dhanal ŋarruŋanan gananan banha guḻkunham yolŋuny warrany. Bala nhan yakan Djesum ga malthundamim warra nhanbal ga waripum yolŋu warra gänan nyenan. Bala dhanal dhä-wirrkaꞌyuwanan nhanany bitjanan, “Gu wilak rakaraŋan ŋanapiliŋgu banhayam mala dhäwu banha nhunu yakan rakaran, ḻinygu dhäwul ŋanapu banha dharaŋgan. Nhäwuy banha dhäwu nhunu yakan rakaran?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Bala nhanma Djesum wäŋan bitjanan, “Nhumaliŋgum djinakum warrawu, banha nhuma bayiŋ yaka djämamiŋgan God-Waŋarrwu romnha, ŋayam ŋarru warraŋulyumana nhumaliŋguḻ mayalimꞌ. Ga waripuŋuwum yolŋuwu banha dhanal dhäwul djinalaŋa malaŋa, dhanalim ŋarru yaka banha dhäwun yana ŋäma. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Dhaŋu ŋaya ŋarru rakaraman gamꞌ, mä ŋarru banha dhärukma nhangu God-Waŋarrwum ŋunha wukirriwuyma maḻŋꞌthuna yulthayin. ‘Yolŋuyum bayiŋ banha nhäma nhänany djämaḻim. ŋarru dhanal ŋarru dhäwulnha dharaŋganma, nhä banhaya mayaliꞌ. Ga ŋämatj dhanal ŋarru yulŋum buthuruyum, ŋarru dhäwulnha dhanal ŋarru banha ŋuwatjumanma dharaŋgan. Ga banha dhanal warri ŋuwatjumarram dharaŋgarra, dhanalim warri banha bilyuwarran God-Waŋarrwuḻin. Ŋarru dhäwul dhanal banha djäl dhanal ŋarru djinakum dhäwuꞌwu marŋgiyi. Ga nhanmam ŋarru banha God-Waŋarryum dhäwulnha dhanaliŋgum baya-rakaram maḻikuwuyma rombuy.’ ” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Bala nhan Djesum dhanaliŋgu wäŋan bitjanan, “Wäy, buku-djulŋimi, dhäwul nhuma yaka dhaŋu dhäwum dharaŋgan, ŋatja? Ga banha nhuma yaka dhäwulma dharaŋgan dhaŋum banha gumurr-yalŋgim dhäwu, ga nhalpiyana nhuma ŋarru dharaŋgan ŋunham banha waripum mala dhäwu? ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Djinalaŋam dhäwuŋa, yolŋu ŋarruŋan maŋutjiwu lämu-nyipandawu. Ga dhaŋum nhan bilanyan, banha yolŋuyu bayiŋ yaka rakaram God-Waŋarrwun dhäruk yolŋuwuḻin warrawuḻ. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Yo, ga ŋatham nhan banha djalkthuwan, ga ḻurrkunꞌma gälkin balan bitjan dhukaḻin. Ga dhukam banha wanyun marimin, ga dhäwulnha nhan banha ŋatham ŋuthan. Yo, ga bayiŋuyam ŋathayu yaka maŋutji-rakaram God-Waŋarrwun dhäruk. Ga ḻurrkunꞌthu yolŋuyu warrayu bayiŋ ŋäma dhärukma nhangu ŋayaŋuyum wanyuyun, bilanyan bitjan banha dhuka wanyu. Ga wäyindhum yaka maŋutji-rakaram Djaytinnhan banha nhan bayiŋ djawyuna banhaya dhäruknha yolŋuwuḻin ŋayaŋuŋuru. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ga banha nhan ŋatha gälkin bäthumiḻim, bayiŋuyam yaka maŋutji-rakaram banhayan yolŋuny banha nhan bayiŋ ŋäma banha dhärukma ŋayaŋuyum ŋuwakurruyun bala mäyaman yana. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Bala bayiŋ waripuyum yolŋuyu nhäman banha nhan bayiŋ banhaya yolŋu mä-yuwaltji bayikuya dhäwuꞌwu, bala nhan bayiŋ mari-watjuna nhangu. Bala nhan ŋarru banhayam yolŋu gulyuna dhärukŋam bala ḏiltji-guŋanmin God-Waŋarrwum ga dhärukkum nhangu, bili ŋatham banha maŋutjim dhäwulnha wärrurrꞌma gulŋiyan ṉiṉꞌthuwanam. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ga banha nhan ŋatha gälkin ḏimirrꞌṯimirrmiḻim, ga gulkurun banha ŋatham ŋuthan, ḻinygu yakan banha maḻikuyun mulmuyu djorkuwan. Ga bayiŋuyam yaka maŋutji-rakaram banhayanhan yolŋuny banha dhanal bayiŋ ŋäma God-Waŋarrwum dhäruk, ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","bala bayiŋ banha waripuyun malaŋuyu djorkumam. Waripun ga waripun bayiŋ dhethuŋgan wälŋaḻi, nhäwu dhanal djäl. Ga rrupiyan yaka marimim guyaŋi, ga be nhäwun warwuyun, guḻkuwun, girriꞌwun. Bala bayiŋ banha djinaŋuyan mala gulyumanma God-Waŋarrwurum dhärukŋuru, ga dhäwulnha nhan ŋarru banha ŋuwatjumanma nyena nhanguwayma yana God-Waŋarrwum. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ga djinalam dhäwuŋa, ŋatha banha gälkin ŋuwakurruḻim munathaꞌḻi, banhayam maŋutji ŋuthanan yaŋaraꞌmiyinan ŋuwatjinan, bala ŋathamiyinan. Ga djinaŋum yaka maŋutji-rakaram banhayan yolŋuny banha nhan bayiŋ ŋäma God-Waŋarrwum dhäruk bala djämamiŋgana yana. Yo, bilanyan dhanal banha yulŋum bitjan banha waŋganybuynha gätniꞌwuy, giḻyuwanan yakan guḻkun yana mariminan dhika. Ga waripuŋa-a-a ga guḻku yana, ga waripuŋa ga bilanya bili.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Bala nhan Djesum bitjanan wäŋan, “Banha bayiŋ yolŋuyu lanhdhirram dhuŋgurꞌyun, ga yakan nhan ŋarru banha banikinꞌthum dhurrthurryun, ŋatja? ... wo ŋoyḻim betḻim gunyan. Banham nhan ŋarru ŋalthumana garramatḻin, mä ŋarru banha guḻkuꞌyun yana nhämam riwarraḻin. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ga bilanyayan banha yulŋum God-Waŋarrwum dhärukku. Nhä malany yaka ŋoya djuḻuḻyundam, banhayam nhanbayin yana ŋarru God-Waŋarryun dhawaṯthuman, bala guḻkum yolŋu warra ŋarru marŋgiyin. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Maꞌ, bilaŋ nhunu buthurumim, ŋuwatjuman nhänany ŋäkam mä nhunu ŋarru dharaŋgan yana. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ga guyaŋiya ŋarrya bala dhärukma nhänany. Banha nhunu ŋarru nyäku marimim buthuru-bitjun, nhanmam ŋarru God-Waŋarryum nhuŋgu guŋana nhanguway dharaŋgandami rom, banha nhunu ŋarru yaka dharaŋgana nhäm mala banha ŋuwakurrum marimim. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ga bilaŋ nhunu yolŋu djäl marŋgiyinyarawum God-Waŋarrwurum ŋayaŋuwu, nhunum ŋarru yana gaḏamandjin. Ga bayiŋ nhunu ŋarru dhäwulma yaka ŋayaŋumiyi, nhanmam ŋarru gulyumana nhuna dharaŋandaŋurum, banhayam nhunu ŋarru dhuŋayin nhangum God-Waŋarrwum.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ga biyapul nhan Djesu wäŋan bitjan, “Marŋgiyi nhuma ŋarru nhalpiyan yaka God-Waŋarrwu banha gurruṯumi warra ŋuthan. Yo, dhaŋum dhäwu mayaḻiꞌmin: Yolŋu djälmiyin nhan ŋarru lämu-nyipan maŋutji ŋatha, bala nhan ŋarruŋan banha ŋatham djalkthuwanan munathaꞌḻin, bala gananan banhaya maŋutjim banhambalayan, bala nhanbayim banha ŋarruŋanan ŋayiḻin. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Manymak, munha ga munha ŋarruŋan djuḻkthuwan ga dhäwulnha nhan banha bayiŋuya yolŋuyu guyaŋin banhaya maŋutjim ŋatham. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Bala ŋarruŋan banha maŋutjim mala ŋuthanam gänan yana. Yo, bala banha ḏukitjma dhamanyꞌtjuwanan, bitjanan ŋarruŋan ŋurru-dhawaṯthuwan. Ga yaka wiyin, bala yaŋaraꞌmiyinan, ga ŋärrun muḻkurrma ŋathamiyin. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ga banha ŋatham muḻkurrma wanyuyin, bala yolŋum warra marŋgiyinan banha ŋatham ḻinygun ŋuwatjinan, bala nhan ŋarruŋanan gulkthundawun bayikuya ŋathawum. Yo, yulparra, God-Waŋarryu dhaŋu nhanbay bayiŋ yaka djämam ŋuthanmaramam.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ga biyapul nhan Djesuyu rakaran waripun mayaliꞌmi dhäwu bitjan, “Dhaŋum ŋaya yaka waripun dhäwu nhumaliŋgu guyaŋi, banha nhumaliny ŋarru guŋgaꞌyuna, nhuma ŋarru dharaŋgana, nhalpiyan ŋarru yaka God-Waŋarrwu gurruṯumi warra ŋuthan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","God-Waŋarrwum dhaŋu gurruṯumi yolŋu warra bilanya bitjan nyumukuṉinyꞌ marimi maŋutji. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ga banha ŋarru banhaya maŋutji gälki munathaꞌḻim bala ŋarru banha maŋutjim ŋuthana buṯ-bitjana, ga yanatj ḻinygu ga yindiyi ŋarru, bala ŋarru baṉamꞌ mala wanyuyin, ga warrawꞌnha banha yulŋum. Bala ŋarru wäyinma ŋarruŋan bala yalunꞌ ŋamaŋamayun balaya warrawꞌḻim. Yo, bitjana ŋarru banha God-Waŋarrwum yolŋu warra gurruṯumim ŋuthan, yindiyin yana.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yo, bitjanan nhan yakan banha Djesuyu marŋgiyumanam yolŋunham warrany. Ga guḻkumi nhan yakan banha dhäwum mala rakaran mayaliꞌmiŋganam. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ga banha dhanal yakan dhanaliwayma ŋapa nyenan, Djesum ga malthundamim warra nhangu, nhanmam bayiŋ dhanaliŋguḻ mayalimꞌ dhawaṯthumarran. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ga banha ŋarruŋan walum gulŋiyan, nhanmam yakan baḏak yana Djesum nyenan marthaŋayŋa. Bala nhan wäŋanan nhanguwaywuḻ malthundamiwuḻim warrawuḻ bitjanan, “Gu, ŋalmam ŋarruŋan djinaŋun marthaŋayyun ŋunha galiꞌḻin.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Bala dhanalim banha malthundamim warra yana ŋalthuwanan, bala ŋarruŋanan. Ga gananan dhanal banha guḻkunham yolŋuny warrany bäymaŋuḻin. Ga waripu banha yolŋu marthaŋaymi warra malthuwanya dhanaliŋgu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","Bala nhan banha Djesum ŋoyanan ŋunha dhurpuŋam marthaŋayŋa, muḻkurr nhan ḏämbuwuyḻi ŋalthuwan bala ŋoyanan. Ga gandarrŋam bala dhanaliŋgu watan ŋoy-gurrŋanꞌnha yindin marimin ḏoyꞌyuwan, boyanan dhanaliny ŋarruŋan. Ga ḏowum yakan wapthuwanan bala gapum dhaŋaŋdjinan marthaŋayŋam, gaḻki warri banha marthaŋayma guḻwuḻyuwarran. Ga dhanalim banha malthundamim warra nhangu mariminan dhika biyaṉiyinam bala dhanal yana dhukaranan nhanany Djesunham, “Wäy Marŋgikunharami, ṉakama, waŋayin ŋalma ŋarru dhaŋu, guḻwuḻyuna ŋalma ŋarru, ... dhäwul nhunu yaka dhaŋu warwuyunma, ŋatja?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Bala nhan Djesum yakurrŋurum ṉakamanam bala dhunupan nhan wäŋanan wanyuyun dhärukthum, watawum bitjanan, “Gulyuwan!” ga ḏowuwum nhan bitjan wäŋan, “Ḻinygun dharraḏayiyan!” bitjan. Bala dhunupan banha watam gulyuwanan gälkinyaŋurum, ga ḏowum ŋarruŋan nyimdhuwanan bala wapurarrnha ŋoyan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Bala nhan Djesum wäŋanan dhanaliŋgu bitjanan, “Nhäwu nhuma biyaṉiyinam? ... dhäwul nhuma yaka dhaŋu nyäku ma-yuwalkmiyi, ŋatja?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Bala dhanalim banha mariminan dhika biyaṉiyinam, mä-maŋmaŋdhuwanan manapan bala ŋarruŋan bitjanan wäŋanharamin, “Nhäŋal nhuma? Ŋunha watayum ga gapuyum ŋäkul nhanany wäŋanhawuy! Dhaŋum yuwalknha ganydjarrmin yolŋu, ŋatja?” bitjan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Djesum ga nhangu malthundamim warra buḏapthuwanan bayikuyam banha guḻungu Galiliwurum, ga dhawaṯthuwanam dhanal banha ŋunha galinꞌ, galkin yana ŋayiŋa yäkuŋa Garatjaŋan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","6","Ga banha nhan Djesu marthaŋayŋurum wapthuwan bala yolŋuyun nhanany nhäŋal ŋarru maḻikumiyun birrimbirrmiyu, ŋarru dhawaṯthuwanam nhan banha beŋuru bäyma yana moluŋuru, banha nhan yakan nyenan ŋunhalaya wiyinŋumi. Ga guḻkumi yakan yolŋuyu warrayu birrkaꞌyuwan garrwiꞌyuwan rranhdhiŋdhu malaŋuyu, ga waripum bayiŋ ṉukun wulanynha ḏapthumarra, ŋarru gulkurun, nhanmam yakan bakthuman yana ga ḻarryuman. Ga dhäwulnha nhan yakan bilaŋ yolkuḻ yolŋuwuḻ ganydjarryum nyenan. Bitjan ḻinygu walu-ŋupan ga munha-ŋupanam nhan yakan buku-wirwiryuwanam bayitjanam bukumurrum molumurrum djolarran, yatjuwan ŋarruŋan ga mitmitthunminan bäthuyun djinbulkthun. Manymak, ga banha nhan ŋunhuŋuya ḏirramuyu nhäŋal Djesunham ŋunha yana bärrkuḻi bala nhan yana yuṯthuwanan gumurrꞌyuwanan bala bunꞌkumu-djipthuwanan gumurrḻin nhanguḻ. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ga bitjan nhan Djesu wäŋanam banha maḻikuwum birrimbirrwu gamꞌ, “Way, gatjuy dhawaṯthuwan djinakuḻim yolŋuwuḻ, maꞌ,” bitjan. Bala nhan banha maḻikum birrimbirr waŋanan wirrkin yatjuwan, “Djesu, Gäthuꞌmiŋu God-Waŋarrwu, banha nhan djiwarrꞌwuy, nhalpiyana nhunu ŋarru nhanany dhaŋu yulŋum? God-Waŋarrwuḻ yäkuyu ŋaya nhunany yaka ŋäŋꞌthun, dhäwul nhänany rrorru.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Bala nhan Djesuyum dhä-wirrkaꞌyuwanan nhanany bitjanan, “Yol bili nhunu dhaŋu ŋaykaṉam?” bitjan. Ga nhanmam rakaranhamin bitjan, “Ŋayam dhaŋu ŋaykaṉa ‘Ŋapa-malami’, bili guḻku marimi nyäkura yaka dhaŋu maḻikum birrimbirr mala nyena,” bitjan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Bala yakan banha maḻikum birrimbirr mala nhanguḻ banha ḏirramuwuḻim giriŋꞌthuwanan wäŋan Djesunham bitjanan, “Dhäwul ŋanapiliny ŋaŋꞌŋaŋdhuwa dhawurum ŋayiŋuru!” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Manymak, ga ŋunhalaya ḻinygu galki yana bukuŋa 2000 bikipiki malany yakan nyenan, ŋathawu yakan rangan waŋgiꞌ-waŋgiyuwan ŋarruŋan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Bala nhan bayiŋuya maḻikuyum birrimbirryu wäŋanan mariminan Djesunham bitjanan, “Wäy, balan ŋanapiliny djuyꞌyuwam, mä ŋanapu ŋarru gulŋiyam ŋunha bikipikiwuḻin warrawuḻ,” bitjan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Bala nhan Djesuyum ŋäkulan dhanaliny ga bitjanan nhan wäŋan gamꞌ, “Maꞌ ... ŋarriyan warra!” Bala ŋarruŋan banha maḻikum birrimbirr dhawaṯthuwanan ḏirramuwuḻim ga gulŋiyanam yakan bikipikiwuḻin warrawuḻ. Ga dhanalim yakan banha bikipikim warra yuṯthuwanan, ḏurꞌṯuryunminan ŋarruŋan, bala yana buku-ḻarryuwanan bukuŋurum, bala gapuḻin guḻunḻin guḻwuḻyuwan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ga dhanalim banha bikipiki djägamim warra yuṯthuwanam balan bitjanan ŋayiḻin malaŋuḻi, bala dhanal ŋarruŋan rakaranan bukmakkuḻin yana banha nhä ŋunhalaya maḻŋꞌthuwan. Ga guḻkuyun yolŋuyum warrayu yakan banha gananam dhanaliŋguway ŋayim malany, djälmiyinan dhanal banha nhänharawun banha nhä banhalaya maḻŋꞌthuwan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ga banha dhanal ŋarruŋan Djesuwuḻim, bala dhanal nhäŋalan banha ḏirramunham banha nhanguḻ yakan ŋätjil nyenan guḻku marimi maḻiku birrimbirr malany. Ga nyenanam nhan yakan banha ḏämbum ŋuwakurrun ga girriꞌmin dhaṯthundan. Ga banha dhanal yolŋuyum warrayu nhäŋal, bala dhanal biyaṉinan, ḻinygu dhanal banha dharaŋganan, banha ŋarru ga bitjanayam yolŋuyu maḻikunham birrimbirrnha dhawaṯthuman banham yolŋu biyapulnha walꞌŋu ganydjarrmin. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ga dhanaḻim yakan banha maŋutji-marŋgimiyum dhäwun rakaran waripuwun yolŋuwu warrawu, bayikuwuynha banha ḏirramuwuynha ga bikipikiwuynha malany. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Bala dhanalim banha yolŋuyum warrayu yakan wäŋanan Djesunham ŋarruŋanharawun yana. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ga djinaŋmu bili nhan yakan Djesu ŋalthuwanam marthaŋayḻim, bala nhanmam banhayam ḏirramu banha nhanguḻ yakan ŋätjil nyenan maḻiku birrimbirr malany, wäŋanan yakan mariminan dhika giriŋꞌthuwanan bitjanan, “Dhaŋum ŋaya ŋarru nhuŋgu malthuna yana!” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ŋarru nhanmam Djesum yakaꞌyuwanan nhangu, ga wäŋan nhan nhangu bitjanan, “Gatjuy, nhunum balaya ḏitjuwa gurruṯumiwuḻ warrawuḻ nhuŋguwaywuḻ, ga rakaraŋ dhanaḻiŋguḻ banha nhä nhuŋguḻ God-Waŋarryu ŋuwakurru warkthuwan, ga nhalpiyan nhan nhuŋgu maŋutji-wuyuwan.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Bala nhan banha ḏirramum ŋarruŋanan ḏitjuwanan balaya makaḻi ŋayiḻi Dikapulitjḻin, bala yana ŋarruŋan rakaranan bukmakkuḻin, banha nhalpiyan nhan yakan Djesuyu warkthuwan nhanguḻ. Ga guḻkuyun banha yolŋuyum warra dhäwum nhanguŋ ŋäkul ganyimꞌthuwanan bitjanan, “Yo ... yuy Wamarrkani!” bitjanan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ga bewaḻiyam dhurrwaraŋuru nhan Djesu ga malthundamim warra nhangu ḏoyꞌyuwanan marthaŋayyum ŋunha galiꞌŋan bayikuyam guḻungu, ŋayiŋa yäkuŋa Gapuniyamnha. Ga banha dhanal yakan marthaŋayŋurum wapthuwan, ga malamin banha yolŋum warra ḻuŋꞌthuwan nhanguḻ. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ga banhalaya malaŋa yakan ḏirramu yäku Djäratj dhäyan banha nhan ŋurruḏawalaŋu Djuwwu biryamiwu buṉbuwu. Ga banha nhan nhäŋal Djesunham, bala nhan yana bunꞌkumu-djipthuwanan munathaꞌḻin gumurrḻin nhanguḻ. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Bala nhan wäŋanan mäḻiŋganminan Djesuwuḻin bitjanan gamꞌ, “Marrkapmi! Yothu nyäku ŋunha dhäyka 12-mi dhuŋgarrami rirrikthun yaka, galki nhan ŋarru ŋunha rakunydjin! Buku-djulŋi ŋatjil ŋarrya gu, ga goŋ-ŋalthuwa nhanguḻ mä nhän ŋarru ŋuwakurryi, ga dhäwulnha waŋayim.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ga ŋärrun nhan Djesu malthuwanam nhangu Djäratjkum. Ga gulkun banha marimin yolŋum warra yakan malthuwanam dhupaliŋgu ŋarru ḏur-ṯuryunminan ŋarruŋan bala. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ga banhalaya malaŋa yakan dhäyka ŋarruŋan, ŋarru nhan yakan banha rirrikthuwanam ŋurru-maḻikuyu. Ŋarru wiyinꞌŋumi nhan yakan banha 12-nha dhuŋgarram gathan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ga guḻkumi nhan yakan ŋarruŋan märrŋgitjkuḻ warrawuḻ guŋgaꞌyundawu ŋarru gulkurun. Ga warrpamꞌthuwan nhan yakan banha rrupiyam nhanguway djalkthuwan dhanaliŋguḻ, ŋarru bayaŋun nhan banha yuwalkma ŋuwatjiny, ga rerrim banha mariminan yindiyin. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","29","Ga banha nhan bayiŋuya dhäykayu ŋäkul Djesunham, bala nhan bitjanan guyaŋinam, “Bilaŋ ŋaya ŋarru dhaŋu girrimꞌ nhanbal gathan ŋayam ŋarru yana manymaktjin.” Bala nhan yana ŋarruŋanan ḏiltjimurrun dhaḻakarr-yarpuwan yolŋuwuḻin warrawuḻ malamurrun. Ga banha nhan goŋ-djarryuwanam baṯnha gathan girrimꞌ nhanbal. Bala dhunupan nhangu banha ŋurru-maḻikum gulyuwanan, bala nhan dhäkay-ŋäkulan banha rerriyum nhanany gananan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ga bilanyamiyu bili yana nhanmam Djesuyum dhäkay-ŋäkulan nhanguwaḻ nhan rumbalyum, banha nhanany ganydjarryum gananan. Bala nhan gulyuwanan, bala gumurr-bilyuwanan bala dhä-wirrkaꞌyuwanan dhanaliny bitjanan, “Yolthu nyäku girrimꞌ gathan?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ga dhanalim banha malthundamim warra nhangu bitjanan wäŋan, “Nhäŋa ŋatjil dhaŋu yolŋuny warrany miṯtji, ŋapa-ŋalthumanmi ŋarruŋ bala ḏurꞌ-ṯuryunmi nhuŋgurumurru, nhäwu nhunu bitjanam wäŋan, guḻkun dhaŋu marimin yolŋum warra,” bitjan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Bala nhan Djesum ḏawaꞌyuwanam bala ŋarruŋan nhäŋalan yolŋunham warrany mä nhan ŋarru maḻŋꞌthuman yolthu nhangu banha girriꞌ gathan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Bala dhunupan yana banha dhäykam marŋgiyinan bala nhan marrmarryuwanan ŋarruŋan biyaṉuyum nhanguwaywuḻ nhan, bala nhan djalkiri dhatharꞌyuwanan bala yana bunꞌkumu-djipthuwanan gumurrḻin nhanguḻ Djesuwuḻin bala rakaranhaminan, “Marrkapmi, ŋaya banha nhuŋgu girriꞌ gathan.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Bala nhan Djesum wäŋanan nhangu bitjanan, “Wäy ... gäthu, bilin nhunu dhaŋu nyäku mä-yuwalkmiyinan, ga ḻinygun nhunu dhaŋu rerriŋurum ḏukthuwanan. Gatjuy ŋarryan ŋoy-ŋuwatjiyan bilin nhunu dhaŋu dhawaṯthuwanan dhaŋga-ḏirrŋurum,” bitjan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ŋarru nhanmam yakan banha Djesum baḏak yana wäŋan, bala dhanalim banha yolŋum warra ḏoyꞌyuwanan dhäwumim beŋurum Djäratjkuḻim ŋayiŋuru, bala dhanal rakaranan bitjanan, “Wäy, ŋayim dhaŋu ŋonuŋ bay! Dhäwulnha nhanany biyapulma ḻay-ḻayyuma Marŋgiyumandaminham,’ bitjan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ga nhanmam banha Djesuyum dhanaliny djuḻkthumanan ŋäkul, bala nhan bitjanan Djäratjkuḻim wäŋan, “Dhäwul warwuyuwa ga biyaṉiya, yana mä-yuwalktjiya nyäku,” bitjan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Bala nhan Djesum bitjanan wäŋan, “Gulꞌyuwan nhumam waripum warra ga dhaŋum ŋarru ŋalinyuŋgum malthun dhanaliwaynha yana Betan ga dhupalin wäwaꞌmanydjin Djayimnha ga Djonnha ga bilin.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ga banha dhanal Djäratjkuḻim ŋayiŋa ḏoyꞌyuwan bala dhanal nhäŋalan yolŋunham warrany dhanal ŋarruŋan galŋa-rrarrayuwanan, warkthuwanan ŋarruŋan dhika waripun ga waripun bäpurruwun romgu. Ga waripum yolŋu warra yakan ŋätjinyaraminan, ga waripu yakan gurrumꞌnha ŋätjin ga waripum dhä-rirrakaymin manikaynha yuṯuŋgurrnha rakaran. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Bala nhan Djesum gulŋiyanan balayan ŋayiḻi, bala nhan wäŋanan dhanaliŋgu bitjanan, “Nhä nhuma yaka dhaŋu galŋarrarrayunma, nhä guyaŋin yana warri dhaŋu bäpurrun? Ga nhäwu nhuma yaka dhaŋu ŋätjinyaramim? Dhaŋum wirrkuḻ yothu dhäwul nhan waŋayin, dhaŋum nhan ga yakurr yana ŋoya.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ga dhanalim banha yolŋuꞌ-yolŋuyum warrayu warkuꞌyuwanan, gitkitthunminan manapan nhangu. Bala nhan yakan Djesuyum wäŋanan dhanaliny bitjanan, “Gatjuy nhumam bukmaknha yana dhawaṯthuwa.” Bala dhanal bukmaknha yakan dhawayawaṯthuwanam bunbuŋurum. Manymak, ga gaḏaymanam nhan ŋäṉḏiꞌmiŋuny yana ga nhananhan mäḻuꞌmiŋunhan Djäratjnhan ga ḻurrkunꞌnhan malthundaminy warrany nhanguway, bala dhanal gulŋiꞌ-gulŋiyanan balayan buṉbuḻin banha ŋalaŋa yakan yothu wirrkuḻ ŋoyan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Bala nhan Djesuyum ŋarambiyan nhanany gathan banha wirrkuḻnham, bala wäŋanan dhanaliŋguwaymurrun dhärukmurru Arram-murrun, “Dalitha gom!” (Mayaliꞌ “Wirrkuḻ dhäyka ṉakaman.”) ");
INSERT INTO dhgduwadha_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","43","Ga dhunupan yana nhan banha wirrkuḻma ṉakamanan, bala yana ŋarruꞌŋarruŋanan. Bala nhan Djesum wäŋanan, “Gatjuy bilaŋ nhä warra nhanbal guŋa nhan ṉokan,” bitjan. Ga guḻkuyun banha nhäŋalam ŋayaŋu-ganyimꞌthuwanan bala nhan Djesuyum wäŋanan dhanaliny mariminan dhika bitjanan, “Dhäwul yana rakaraŋ bilaŋ yolkum yolŋuwu djinakuwuyma,” bitjan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Bala nhan Djesum ŋarruŋanan gananan banhayam ŋayi Gapuniyamma, bala ḏitjuwan balan nhanguwaywuḻin ŋayiḻi Nätjuritjḻin, ga bukmak yana banha malthundamim warra nhangu malthuwanya. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ga waripuŋuyun Djuwwuḻ Nyenanharamiyu Waluyu, nhan yakan Djesuyum marŋgiyumanan guḻkunhan yolŋunham warrany ŋunhalam banha biryamiŋam buṉbuŋa. Ga banha dhanal yakan ŋäkulam nhanany banha nhä nhan yakan dhanaliny marŋgiyuman bala dhanal bitjanan wäŋanharaminam, “Wäy, dhaŋum yolŋu gaḏamannha ŋatja? Ŋalaŋa nhan yakan dhaŋu marŋgiyinam djinakum mala? Ga ŋalaŋuru nhan yakan dhaŋu ganydjarrma mäyan ŋayaŋu-ganyiŋꞌthundamiwum romgu warkthundawu? ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Dhaŋum dhaŋu banha balaꞌ-dhuḻꞌyundami gayꞌ yolŋu! Banha ŋalma djinakuwuynha waŋganybuynha ŋayiwuy, ga marŋgi mu ŋalma dhaŋu nhangu ŋäṉḏiꞌmiŋuwum Meriwum. Ga marŋgi ŋalma nhangu wäwaꞌmiŋuwum warrawu Djayimgum ga Djawutjipkum ga Djudatjkum ga Djäymangum, ga marŋgi ŋalma nhangu yapaꞌmiŋuwum warrawu.” Bala yakan banha yolŋum warra nhangu dhäwulnha gumurr-ŋuwatjinam, ŋurru-bilꞌbilyuwanan dhanal yakan nhangu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ŋarru nhanmam Djesum bitjanan wäŋan, “Banha ŋarru God-Waŋarrwum djawarrkmi yolŋu ŋarruŋa waripuḻim ŋayiḻi, ga dhanalim bayiŋ banha ŋayi nininyŋuyum yolŋuyu warrayu dhäruk nhanany mäyam ga mä-ŋalthun nhangu. Ga banha nhan ŋarru nhanguwaywuḻim ŋayiḻi ŋarruŋa, nhanguwaywuḻim walꞌŋu yolŋuwuḻ warrawuḻ gurruṯumiwuḻim warrawuḻ, ga dhanalim bayiŋ banha yolŋuyum warrayu dhäwuḻnha nhanany dhärukma mäyam, ga mä-ŋalthun nhangu.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6a","Ga ganyimꞌthuwanan nhan banha Djesuyum nhäŋal, bili yolŋum warra banha ŋayaŋum-wanyuꞌyinan ga dhäwulnha dhanal banha biyapuḻ bitjuwalak mä-yuwalktjin. Ga dhäwuḻnha nhan yakan banha ganydjarrmim rom malany bäki mariminam, ḻurrkunꞌnha yana, banham nhan yakan waŋga-waŋganyguḻin rerrimiwuḻim yolŋuwuḻ warrawuḻ goŋ-ŋalthuwan, bala ḏukthumanan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_6b","071_6_6b","MRK","6","6b","6b","Bala nhan ŋarruŋan Djesuyum marŋgiyumanan yolŋuꞌ-yulŋunham warrany buku-ḻiwꞌyumanan banhalayam makaŋa ŋayiŋa. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ga ḻuŋꞌthuman nhan banha 12-nham malthundaminy warrany nhanguway nhan, bala nhan ŋarruŋan gänaŋꞌthumanan dhanaliny bulalꞌ ga bulalꞌ ga bulalꞌ, ga bitjan nhan banha wäŋanam dhanaliŋgu, “Maꞌ ŋarryan warra ŋayiḻin malaŋuḻi ga marŋgiyuman yolŋunham warrany God-Waŋarrwuruynha. Ŋaya nhumaliny yaka dhaŋu ganydjarrma guŋana nhuma ŋarru yaka dhawaṯthumana maḻikunham birrimbirrnha malany. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Ga dhäwul mäyaŋ guḻkum girriꞌ, ḻinygu nhän mu ŋarru nhuŋgu banha God-Waŋarryu djämam ŋätjilmiŋganma. Dharpan yana mäyaŋam gaṉdjiꞌyunminyarawun ga djalkiriwuynha dhuwan ṉukuŋa nhuŋguḻ ga dhuwan bili girrimꞌ galŋayu nhunu yaka golam. Ga dhäwul golaŋ ŋunhuŋ nhäm ŋatham ga rrupiyam ga bilaŋ nhä batjim. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ga banha nhuma ŋarru ḏoyꞌyun birrkamiŋam ŋayiŋa ga gawawꞌyunma dhanal ŋarru nhumaliŋgu gumurr-ŋuwatjim bitjuwalak, bitjanma ŋarru wäŋa, ‘Gu, ŋunhal nhuma ŋarru nyäkuḻ buṉbuŋa ŋoya,’ nhumam yana ŋarryan ga ŋoya nhuma ŋarru banhalaya buṉbuŋa ga yana ḻinygu-u-u, ga wark nhumaliŋgu ŋarru dhawarꞌyun, ga ŋärrun ganakam dhanaliny. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ga banha nhuma ŋarru ḏoyꞌyun birrkamiŋam ŋayiŋa ga dhäwulma nhumaliŋgu ŋarru banha ŋayi-bayikuwuyma yolŋu warra gumurr-ŋuwatji, ga dhäwul dhanal ŋarru ḏukṯukmiyi ŋänharawu nhuŋgu, nhumam ŋarru ganana banhayam ŋayi bala munathamꞌ djalkiriŋurum ḏawaṯawayuwan bayikuwuyma ŋayiwuy, bala bitjan waŋiya dhanaliŋgu, ‘Dhaŋu nhuma dhäwul nyäku djälmiyin buthuru-witjundawum, maꞌ, ga bayiŋ ŋarru bilaŋ nha marim nhumaliŋgu maḻŋꞌthun, banham nhumaliŋguwaynha mari,’ bitjan yana, bala ŋarryan.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Yo, bala dhanal banha malthundamim warra ŋarruŋanan barrkuwaḻyinan bulalꞌnha ga bulalꞌnha waripuḻin ga waripuḻin ŋayiḻim. Ga banhalayan dhanal yakan rakaranam yolŋuꞌ-yulŋuwum bitjanam, “Gulyuwan warra dhuwurr-maḻikuŋurum nhumaliŋguwayŋuru nhuma bala malthuwan God-Waŋarrwun yulthawun yana dhukawum.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ga guḻkun marimin dhanal yakan banha maḻikunham birrimbirrnha malany dhawaṯthuman yolŋuwurum warrawuru. Ga guḻkuwuḻ dhanal yakan rerrimiwuḻim yolŋuwuḻ wiyikamꞌ rrarryuwan muḻkurrḻim, ŋarru ḻurrkunꞌ yana, dhäwul guḻku, mä dhanal yana ŋuwatjinan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ga bilanyamiyum waluyu guḻkuyun yakan banha yolŋuyum warrayu dhäwum ŋäkul Djesuwuruyma. Ga nhän banha yindiyum buŋgawayu yäkuyu Geŋ Yaritthum ŋäkul yana ganydjarr nhanguruy. Ga bitjanan yakan banha waripum yolŋu warra wäŋan, “Dhaŋum nhän ŋatja, Djonnha banha ḏämbu-ḻupthumandamin yolŋu, ŋarru Djesuwurun rumbalyum, dhaŋu nhan barpuru biyapul wälŋayi rakunyŋurum, ga djinaŋuyan nhan yaka dhaŋu Djesuyu banha ŋayaŋu-ganyimꞌthunamim rom warkthun.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ga waripum yolŋu warra yakan wäŋan bitjanan, “Dhaŋum baya Yilaydjan ŋatja banha God-Waŋarrwun djawarrkmi bamanꞌŋuwuynha?” Ga biyapul waripum bitjuwalak yolŋu warra wäŋan bitjan, “Yaka dhaŋum Yilaydja, dhaŋum bilaŋ yolnha waripun God-Waŋarrwun djawarrkmi bamanꞌŋuwuynha.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ga banha nhan Yaritthum ŋäkul banha nhä ŋarruŋan yolŋu warra rakaranhamin bala nhan yana dhäruk-guŋganminan bitjanan, “Dhaŋum Djonnha banha Buku-ḻupthumandamin yolŋu. Ga ḻinygu mu ŋaya banha ŋätjil yana dhäruk-guŋanminam nyäkuḻ djämamiwuḻim warrawuḻ bitjanam, ‘Gatjuy gupan warra nhanany gulkthuwa.’ Ga dhaŋum nhan ḻinygun wälŋan.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Yo, bitjan banha maḻŋꞌthuwanam gamꞌ ŋätjilim. Banha yindiwu buŋgawawu yäkuwu Geŋ Yaritku yakan yukuyukuꞌmiŋu nyenan yäku Bilip, ga dhäykam nhangu banha yäku Yiritiya. Bala nhan banha yindiyum buŋgawayu Geŋ Yaritthum djawyuwanan nhanguru yukuyukuꞌmiŋuwum dhäykany. Manymak, guḻkumi nhan yakan Djon ŋarruŋan ga wäŋan nhan yakan maŋutji-dhunupa Yaritkum, bitjan, “Dhäwul nhunu ŋarru dhaŋum djawyun, dhaŋum nhuŋgu yukuyukuꞌmiŋuwun dhäyka. Dhaŋum nhunu yaka bakthumana ŋalmaliŋgu romnha, Djuwun bäpurruwu.” Ŋarru nhanmam banha Yaritthum mäyan yana banha dhäykanham. Bala nhan yana dhäruk-guŋanminan nhangu djämamiwum warrawu dhanal ŋarru Djonnham dhethuŋgana dharruŋguḻin. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ga bitjanan ḻinygu nhan yakan banha Djondhum ŋayaŋu-biyarrthanan wäŋanam, bala ŋarruŋan banha dhäykam ŋoy-dhäyanan nhangu Djongum, ga ḏukṯukmiyinam nhan yakan mariminan murrkayꞌkunharawun yana boyanharawum nhangu, ŋarru dhäwul nhan bilaŋ dhukam maḻŋꞌthuman. Bala nhan Yaritthum yakan gathanan Djonnham dharruŋguŋan, ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ga bitjan nhan banha dhäruk-guŋanminam djägamiwuḻim warrawuḻ gamꞌ, “Djinakum nhuma ŋarru yaka ŋuwatjuman yana djäka.” Ga mariminan nhan yakan banha yindiyum buŋgawayu Yaritthum Djonnham mäyu-ḏapthuman mä-biyaṉiyin manapan. Ga marŋgi nhan banha, banha nhanany God-Waŋarryu bitjuwalak djuyꞌyuwan ga nhäpa nhan banha ŋayaŋu-dhunupa bilanya yolŋu ŋuwakurru. Ga djäl nhan banha marimi nhangu nhan ŋarru yaka ŋäma nhanany wäŋanhara dhäwuḻi rakaranhaḻi. Ŋarru guḻkumi nhan yakan banha Djondhu ŋayaŋu-maḻikuyuman nhanany banha nhan bayiŋ dhäwum rakararra. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Manymak, ga waŋganymiyum waḻuyu dhanal ŋarruŋan ḻuŋꞌthuwanan ŋathawun nyaŋꞌthundawu, bilanyamiyum dhanal guyaŋin banha Yaritkum dhawal-guyaŋinyaran walu. Manymak, ga bilanyamiyum nhan banha bayiŋuya dhäykayum yäkuyu Yiritiyayum yakan guyaŋinan bitjanan, “Yä-a-a, dhaŋum ŋaya ŋarru bäyarran Djonnham bayikuwuynha.” Ga guḻkun banha gämurrumꞌ yolŋu warra ŋarruŋan balaya ŋathawum nyaŋꞌthundawu, bilanya bitjan ŋurru-warryundayŋu gapman warra, ga maḏakarritjmiwu miriŋuwu warrawu buŋgawaꞌmiŋu, ga ŋaḻapaḻmin ŋunhukuwuynha makawuy ŋayiwuy warra ŋunha Galaliwuynha. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Yo, nyaŋꞌthuwanan dhanal ŋarruŋan banha ŋatham ga gapum, ga banhalaya yakan wirrkuḻ dhäyka marryuwan, ŋarru nhan banha wakuꞌmiŋum bayikuyan dhäykawu yäkuwu Yiritiyawun. Yo, marryuwanam nhan yakan banha wirrkuḻma ŋuwatjumanan dhika. Bala nhan banha yindim buŋgawa Yaritma ga yolŋum warra mariminan dhika mä-maŋmaŋdhuwanam nhanguru buŋgulyum. Bala nhan banha Yaritma gawaꞌyuwanan nhangu bitjanan, “Banha nhunu ŋarru nhänany ŋäŋꞌthun bilaŋ nhäwu nhunu djäl, ŋayam ŋarru guŋana yana nhunany. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ga bilaŋ nhunu djälma, ŋayam ŋarru mala-wulkthumana bukmaknha yana, ga ŋala ŋayi maka malany nyäkuḻ gumurrŋa, ŋaya ŋarru gulkthumana nhuŋgun ga nyäkuwaynha. Ga banha ŋarru dhäwulma bitjanya maḻŋꞌthun, ŋaya yaka ŋäŋꞌthun, nhan ŋarru nhänany God-Waŋarryum dhä-girꞌyuna yana.” bitjan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ga nhanmam banha wirrkuḻma dhäyka ŋarruŋan ŋätjil dhawaṯthuwan bala ŋäṉḏiꞌmiŋuwu rangan ga ŋäŋꞌthuwan nhan bitjan, “Wäy ... ŋäṉḏi, nhäwu ŋaya ŋarru ŋunha yindinham buŋgawany ŋäŋꞌthun?” bitjan. Bala nhanmam banha ŋäṉḏiꞌmiŋum wäŋan bitjanan, “Gatjuy ... buku-djulŋi, ŋäŋꞌthuwam Djongurun yana muḻkurrwum.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Bala nhan banha wirrkuḻma balaya ḏitjuwan yuṯthuwan Yaritkuḻ, bala bitjanan wäŋan, “Yindi buŋgawa, djälma ŋaya dhaŋu nhunu ŋarru muḻkurr gulkthun Djonnha banha Ḏämbu-ḻupthumandaminy yolŋuny, djinaŋun bala yana, ga gunyanma nhunu ŋarru banha muḻkurrma biḻitḻin, bala guŋana nyäkuḻin,” bitjanan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ga banha nhan Yaritthum bilanyawuyma ŋäkul, bala nhan yana ŋayaŋum-maḻikiyinan mä-dhumbalꞌyuwanan manapan. Ŋarru dhäwulnha nhan yakan banha ḏukṯukmiyin nhan ŋarru dhawumꞌ nhanguway bakthuman, ḻinygu nhan banha dhawuꞌ-nhinathuŋganam nhanany dhuliꞌnamaran ŋaḻapaḻmiwuḻin. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Bala nhan banha Yaritma gawaꞌyuwanan miriŋuwurun buŋgawaꞌmiŋuwum bala dhäruk-guŋanminan, “Gatjuy ŋarryan ŋunha dharruŋguḻin banha ŋala yaka Djon nyena bala gupan nhanany gulkthuma.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Bala dhanal banha mäyanan nhanany gupam bala gunyanan biḻitḻin bala golanan banha wirrkuḻwuḻin. Ga nhanmam banha bayiŋuya wirrkuḻyum mäyan bala guŋanam ŋunha ŋäṉḏiꞌmiŋuwuḻin. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ga banha dhanal Djonguḻ malthundamiyum warrayu ŋäkul dhäwum nhanguruy banha nhan waŋayinam, bala dhanal yana ŋarruŋanan ga mäyanan nhangu rumbalma bala moluḻin märrkitjkuwan. Ga bitjanan nhan yakan banha Yaritthum guyaŋin be warri nhan banha Djesum Djonnha banha Buku-ḻupthumandamin yolŋu. Ga bilanya banha dhäwum. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Manymak, ga banha dhanal nhangu malthundamim yolŋu warra gumurr-ḏitjuwanam djämaŋurum, bala dhanal yakan rakaranan Djesuwuḻim nhä dhanal yakan warkthuwan ga nhä dhanal yakan marŋgiyuman yolŋuny warrany. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ga bilanyamiyum yakan banha guḻkun marimin yolŋum warra ranganam nhangu Djesuwum, ga dhäwulnha banha dhanaliŋgum walu ŋathawum nyaŋꞌthundawu, Djesuwum ga nhangu malthundamiwum warrawu. Bala nhan wäŋanan banha malthundamiwum warrawu bitjanan, “Go, ŋalma ŋatjil ŋarruŋa ŋay, bilaŋ nhäḻi gänaŋuḻi ŋayiḻi mä ŋalma ŋarru ŋirꞌyunmi.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Bala dhanal ŋalthuwanan marthaŋayḻin bala ŋarruŋanan gänaŋuḻin ŋayiḻi. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ga guḻkuyun yakan banha yolŋuyum warrayu nhäŋalam banha goyurrma marthaŋayma ŋalambal yakan yuṯthuwan. Bala yakan banha yolŋum warra ḻawꞌyuwanan goyurr-ŋupanan banha marthaŋaynhan ŋarru ŋunha ḏiltji-djawꞌyuwanan, ga dhanalin banha ŋurruŋum ḏoyꞌyuwan ŋunhalayam ŋayiŋa. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ga banha nhan Djesu wapthuwanam marthaŋayŋurum bala yakan banha yolŋum warra gäḻkuḻanan nhangu. Ga banha nhan Djesuyu nhäŋalam dhanaliny malam bitjanan, banha dhanal dhäwulnha marŋgi nhalpiyan dhanal ŋarru yaka nyena, bilanyan dhanal banha bitjan bimbi malany djäganharran. Bala nhan mariminan dhika ŋayaŋu-wuyuwanam dhanaliŋgu. Bala nhan yakan marŋgiyumanan dhanaliny God-Waŋarrwuruynha rom, ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","walu-ŋupanan ga yanatj ḻinygu ga räy-bilyuwan. Bala banha malthundamim warra nhangu wäŋanan, “Wäy, räy-bilyuwanan dhaŋu ga bayaŋun dhaŋu ŋatham, gatju-wilak waŋiya dhaŋu yolŋuny warrany, dhanal ŋarru ŋatha dhanaliŋguway mäyam dhaŋu yaꞌ buṉbu guḻkuꞌmiŋa ŋayiŋa.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ga nhanmam Djesum bitjanan waŋan, “Dhäwul dhuwanma ŋuwakurru. Nhumapi yana dhanaliny maranhu-guŋa.” Ga dhanalim ŋäŋꞌthuwan nhanany mä-dhumbalꞌyuwan manapan bitjan, “Wäy, ŋalaŋa dhika ŋanapm ŋarru maḻŋꞌthuman bilanyam rrupiya malany, djinakum yolŋuwu warrawu maranhuwu? Dhaŋum ŋarru yolŋu warkthun waŋgany dhuŋgarra, ŋatja, dhaluŋꞌthun ŋatjil rrupiyany, ga ŋärrun nhan ŋarru ŋatham banha wuŋiḻiꞌyun.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ga nhanam Djesum wäŋan, “Maḻŋꞌthuma warra ŋatjil yolthu yaka bilaŋ ŋatha golam?” Bala dhanal ranga-ranganan ga ḏitjuwanam dhanal bala rakaranan bitjanan, “Goŋ-waŋgany dhaŋu dämbam ga bulalꞌ ŋarirrimꞌ.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Bala nhan Djesum wäŋanan dhäruk-guŋanmin malthundamiwum warrawuḻ nhanguḻ bitjanan, “Maꞌ, waŋiyan dhaŋu yolŋunham warrany dhanal ŋarru nyenan mulmuŋan, ŋarru malaŋa ga malaŋa.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Bala yakan banha yolŋum warra mala-wulkthumanminan waripum yolŋu warra 100 malaŋa ga waripum ga 50 ga bitjanan bala, ga bitjan mu yakan nyenanam. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Bala nhan Djesuyum banha goŋ-waŋganyma dämba ga ŋarirrimꞌ wulaynha mäyanan. Bala buku-garrwartjinan balan djiwarrꞌḻin, bala buku-wikanan God-Waŋarrnhan, bala bakthumanan bala guŋanan ŋunha malthundamiwuḻin warrawuḻ mä dhanalim ŋarru guŋaꞌ-guŋana ŋunha yolŋuwun warrawu malaḻin ga malaḻin. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ga nyaŋꞌthuwanam dhanal ŋarruŋan banha ŋatham ga bukmak yana ganaꞌyin. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ga nyaŋꞌthuwanam dhanal ŋarruŋan bala ga dhawar. Bala yakan banha malthundamiyum warrayu wapthumanan bäytjinyaram ŋatha, ga dhaŋaŋguwanam dhanal banha 12 batjim malany. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ga bilaŋ nhämunha banha 5000, ḏirramum mala, ga bayaya banha dhäykam warra ga yumurrkum bilanyaya ḻinygu mu mala. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ga bondi yana nhan banha Djesuyum wäŋan nhangu malthundaminham warrany bitjanam, “Wäy yulparra, nhumam ŋarryan marthaŋayun ŋunha raypaḻin Bithdjaydaḻin.” Bala dhanal ŋarruŋanan buḏapthuwanan bayikuya guḻungum, ga nhanbayim Djesum ŋurrꞌyuwanan banhalayan bäyman, ga yolŋuny warrany ŋatjil yakan djuyꞌyuwan ḏitjuman ŋayiḻi. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ga banha dhanal yolŋum warra ḻatjuwarrꞌyuwan, bala nhanbayim Djesum bukuḻin ŋalthuwan bukumiŋgandawun. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","50","Ga banha ŋayim munhakuyin, bala nhan Djesum yarrupthuwanan bukuŋurum. Ga dhanalim banha malthundamim warra nhangu marthaŋaymim bilanyamiyum ŋunhalan dhulmuŋan. Ga mariminan dhanaliny yakan banha watayum gumurr-nhinathuŋgan ga marimin yana dhanal yakan banha ḻiwꞌyuwanam. Ga munhakumin nhan Djesuyum guyurr-ŋupanan dhanaliny, ŋarru ŋarruŋanam nhan yakan ŋapamurrun gapumurrun. Ga djinaŋmu ḻinygu nhan ŋarruŋan banha djuḻkthumanam dhanaliny marthaŋayminham warrany, bala dhanal nhanany nhäŋalan. Bala biyaṉiyinan dhanal banha nhangu mariminan dhika ŋapa-ŋayathanminan dhä-wirrkaꞌyunminan bitjanan, “Wäy-y-y nhän yaka dhaŋum ŋarruŋa wuŋiḻi yolŋu ŋatja?” Ŋarru nhanmam Djesum wäŋan, “Ŋaya dhaŋu ... ŋaya, yulparra. Yaka warra biyaṉiyiya!” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Bala nhan Djesum ŋalthuwanan balan marthaŋayḻin bala watam banha wapurarryinan. Ga dhanalim banha malthundamim warra nhangu mariminan dhika mä-maŋmaŋdhuwanan bayikuyam romgu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ga bili mu dhanal banha nhäŋalam nhanany Djesunham banha nhan ganydjarryu nhanguwaywuḻ nhan maranhu-guŋan yolŋuny warrany 5000-nha malany. Ga baḏak yana dhanalim dhäwul yana dharaŋgan nhangu ganydjarrma, bili dhanaliŋgu banha ŋayaŋum wanyu yana. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ga banha dhanal ḏoyꞌyuwanam ŋunha galimꞌ banha bayikuyam guḻungu, bala dhanal baḻaꞌŋum ḏupthuwanan banhalayan ḻinygu gumurrŋan ŋayiŋa Ginatjaritnha. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ga banha dhanal yakan wapthuwanam marthaŋayŋurum, bala guḻkuyun yolŋuyum warrayu nhäŋalam nhanany dharaŋganan bala wäŋanan bitjanan, “Dhaŋun Djesum ḻinygun ḏoyꞌyuwanan yulparra.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","56","Bala yakan yolŋum warra yuṯthuwanan, rakaranhaminan ŋarruŋan buku-ḻiwꞌyumanan, ga dhaŋun räli yolŋuyum warrayu yakan gola-gulanan rerriminham yolŋuny warrany. Ga ŋalambal nhan yakan Djesu ŋarruŋan banhalaya ŋayiŋa, dhanalim yolŋuyum warrayu ŋäkul yana, ga bitjan mu yakan guyukan rerriminham yolŋuny warrany bala ŋarruŋan gunyanan yakurrkuwanan, ŋarru ŋurru-ḏakthunminan yakan, banhalaya maraŋuŋa ŋayiŋa. Ga bitjan dhanal yakan banha guyaŋinam gamꞌ, “Banha dhanal ŋarru girrimꞌ nhangu Djesuwu gathan, dhanalim ŋarru ŋuwakurruyin yana.” Ga banha dhanal gathanam nhangu girrimꞌ bala dhanal ŋuwakurruyinan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Waŋganymiyum waluyu Djuwwu rom-waṯaŋu warra Baratji warra, ga mä ḻurrkunꞌ rom-marŋgikunhami warra ŋayi Djurutjalambuyyu guwatjman dhanal Djesuny. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","5","Ga banhayam yolŋu warra bayiŋ ga marimi yana dhanaliŋguwaywun romgu malthun. Bilanya mala rom gamꞌ: banha ŋarru yolŋu djälmiyi ŋathawu nyaŋꞌthundawu, ŋurruŋum dhanal bayiŋ be goŋ-rurrwuyunmi ga ŋärrun ŋatham ṉoka, romgu yana malthun. Ga banha dhanal ŋarru ŋatham mäyam bilaŋ ŋalaŋam yolŋu guḻkuꞌmiŋam ŋayiŋa, ŋurruŋum dhanal bayiŋ waḏapthun ḏarrtjalkunharami romgu malthun. Ga ŋärrun banikinꞌma malany rurrwuyun, bilanya bitjan djuypanꞌ mala, ŋathawuy biyarrthanda rupa mala, ga gapuwuy wurkthunda ga gäp ga biḻit ga guḻku waripu ga waripu. Warrpamꞌ ŋarru rurrwuyun, romgu bayikuya malthun. Ga bilaŋ ŋarru waripu Djuw yolŋu warra dhäwulma malthun bayikuya romgu, dhanalim ŋarru banha Baratjim yolŋu warra maḏakarritjin dhanaliŋgu. Ga bilanyaḻin dhanal banha Djesuwum malthundaminy warrany nhäŋal, bala dhanal maḏakarritjinan dhanaliŋgu, ḻinygu dhanal yakan ŋatha ṉokan, goŋdhu-rurrwuyundanharramiyun, dhäwulnha romgu malthuwan. Bala dhanal rom-nyamirꞌyuwanan nhananham Djesunham bitjanan, “Nhäwu bayiŋ yaka dhaŋu nhuŋguru malthundamiyum warrayu ŋatha ṉoka goŋdhu-rurrwuyundanharramiyum? Romnha dhanal bayiŋ yaka dhaŋu bakthuman ŋaḻapaḻmiwun!” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","7","Bala nhan Djesuyum buku-ganitjuman bitjanan, “Nhumam dhaŋum gali-märrmanꞌ yolŋu warra. Dhunupamu nhan banha yolŋuyu yäkuyu Yitjayayum bamanꞌma wukirri God-Waŋarrnham dhäruk bitjanam gamꞌ, ‘Dhaŋum yolŋu warra bayiŋ yaka wokthun nyäku dhärukthu yana waŋganydhu, ga dhäwul ŋayaŋuyum. Dhäwul dhanal bayiŋ yaka dhaŋu yultham nyäku buku-ŋalthun, ga marŋgiyumanma dhanal bayiŋ yaka yolŋuwun yana romma malany, be warri banham God-Waŋgarrwuŋun rom bokmanda. Ga gathanma dhanal bayiŋ ga dhaŋu yolŋuwun yana romma malany,’ bitjan. Bilanyayan dhaŋu nhumam. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","9","Ḏiltji-guŋanminan nhuma God-Waŋarrwuŋum rom-nyipanda malany, bala nhuma bayiŋ yaka dhaŋu malthunma yolŋuwun yana romgum. Gaḏamannha warra dhaŋu nhumam marimin dhaŋum warra maḻikuyumandawum djämawu! ");
INSERT INTO dhgduwadha_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Dhaŋum banha rom nhanguŋ God-Waŋarrwuŋ, banha nhan guŋan Mawtjitjkuḻ bilanya gamꞌ, ‘Mä-ŋalthuwa nhuŋguway ŋäṉḏiꞌmiŋuwum ga mäḻuꞌmiŋuwum.’ Ga bulum nhan bitjan wäŋan gamꞌ, ‘Bilaŋ ŋarru yolŋu dhä-waripuŋuyi wäŋa ŋäṉḏiꞌmiŋuwu ga mäḻuꞌmiŋuwu, ŋunha yaka romma barraŋgaꞌyun bilanyanham yolŋuny nhuma ŋarru boyana yana waŋayumana.’ ");
INSERT INTO dhgduwadha_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Yo, bitjan nhan banha God-Waŋarryum romma gunyan, ŋarru nhumam bayiŋ dhaŋu waripuyumana marŋgiyumanma bitjana gamꞌ, ‘Ŋunha nhuŋgu ŋäṉḏiꞌmiŋu ga mäḻuꞌmiŋu yaka djälmiyi, nhunu ŋarru guŋgaꞌyun dhupaliny, ŋarru nhunum banha bilin dhawuꞌ-nhinathuŋanan God-Waŋarrnhan, ŋarru baḏak yana nhunu yaka dhaŋu mäyu-ḏapthuman, ga dhäwulnha nhunu ŋarru dhupaliny banha guŋgaꞌyunma.’ ");
INSERT INTO dhgduwadha_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ga bilanyawun ŋaya banha bitjanam rakaran nhumaliŋguḻ ŋätjilim, nhumam banha galiꞌḻin-ḏupthuwan nhangum God-Waŋarrwum rom, bala bilyumanan nhuma, ga waripun rom gunyan. Ga guḻku mu nhuma yakan dhaŋu romma malany bilꞌ-bilyuman.’ ");
INSERT INTO dhgduwadha_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Bewaḻiyam dhurrwaraŋuru nhan Djesu gawawyuwanan yolŋuwum warrawu bala bitjanan wäŋan, “Dharr-bitjan warra ŋäkam, mä nhuma ŋarru dharaŋgan yana. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nhä bayiŋ banha gulŋiya ŋunha guḻunḻi, dhäwul bayiŋ banha bayiŋuyam yolŋuny ŋayaŋu-maḻikuyuman. Ga nhä bayiŋ banha dhawaṯthuna ŋalmaliŋguru ŋayaŋuŋurun bayiŋuyan bayiŋ banha maḻikuyumanma. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Bayiŋ nhuma buthurumim warra, ŋäkam warra ŋuwatjuman!” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Bala nhan Djesum ga malthundamim warra nhangu ŋarruŋanan gananan yolŋunham warrany bala gulŋiyanan buṉbuḻin. Bala dhanal dhä-wirrkaꞌyuwanan Djesunham bitjanan, “Marrkapmi, ŋatjil rakaraŋ ŋanapiliŋgu mayaliꞌ bayikuwuy dhäwuꞌwuy.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Bala nhanmam Djesuyum buku-ganitjuman dhanaliŋgum bitjanan, “Nhalpiyan nhuma yaka dhaŋu dhäwul dharaŋganma, ŋatja? Bilanya nhan dhaŋu mayalimꞌ gamꞌ: nhä bayiŋ yolŋuyu ṉoka banhayam ŋuwakurru, bili ŋarru banha dhawaṯthun mu. Ŋarru nhä bayiŋ banha dhawaṯthun ŋayaŋuŋurun, banhayan nhän yakam ŋuwakurru.” (Ga bitjanam nhan banha wäŋan, banha bukmakma dhaŋu ŋatha malany ḏarrtjalk ṉokanharawum.) ");
INSERT INTO dhgduwadha_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","“Ga nhä bayiŋ banha yolŋuwuḻ dhawaṯthun ŋayaŋuŋurun, bayikuyan nhan bayiŋ banha God-Waŋarrma marimin yana milnyaŋꞌthun, gulyumana bayiŋ ŋalmaliny God-Waŋarrwuḻin. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Djinaŋun malaŋuyu romdhu maḻikuyu ŋalmaliny bayiŋ gulyumanma nhanguḻ gamꞌ: guyaŋi yaka maḻikun yana nhä malany, ga marrambaꞌ-djawꞌyundami rom, ga manaŋgan rom, ga boyan yolŋuny murrkayꞌyuman, ");
INSERT INTO dhgduwadha_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ga räy-wanyuyi, ga gupa-wakalmiŋgandami rom, ga dhuwurr-maḻiku, ga yalkum yaka, ga mayaliꞌ-wilkthundami rom, ga djäl-gänaŋumi, ga maŋutji-ḏiyꞌ rom, gupa-waŋanharami rom, ga marŋgi-rakaranhami rom, ga romnharran, ga ŋayaŋu-ḏäl rom. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Yo, bilanyayan banha maḻikum mala bayiŋ yaka dhawaṯthun dhawurum ŋayaŋuŋurum, bala maḻikuyumana ŋalmaliŋgu ŋayaŋun. Ga bitjanaya bili bayiŋ banha God-Waŋarrnham gulyumana ŋalmaliŋguru, banhayam God-Waŋarrwuḻim milnyaŋꞌmin.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Bewaḻiyam dhanal banha Djesum ga nhangu malthundamiyum warrayu gananan banhayam ŋayi. Ga ŋarruŋanam dhanal banha buṉbu-guḻkumiḻin ŋayiḻim yäkuḻi Däyaḻin. Ga ḏoyꞌyuwan dhanal banhalaya ŋayiŋa bala dhanal gulŋiyanan buṉbuḻin, ḻinygu dhäwul nhan Djesu ḏukṯukmiyin dhanal ŋarru yolŋu warra nhangu marŋgiyi, banha nhan yakan banhalayan nyenan. Ŋarru gulkurun nhan banha djuḻuḻꞌyumanminam. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Ga banhalaya yakan dhäyka nyenan ŋarru nhan banha dhäwul Djuw-m bäpurru. Ga yolŋum nhan banha dhawal-guyaŋinyaram ga Bänitjawuy, makaŋam Djiriya. Ga banha nhan Djesunham ŋäkul ḏoyꞌyundam bala nhan ŋarruŋanan bala wäŋanan nhangu bitjanan, “Buku-djulŋi, ŋatjil ŋunha maḻikuny birrimbirrnha ḏupthuwa wakuꞌmiŋuwuḻ nyäkuḻ dhäykawuḻ.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Bala nhan Djesum mayaliꞌmurrun wäŋan, “Dhaŋum ŋarru ŋurruŋum ŋatha ṉoka yumurrkuꞌyu, ga bäytjinyaran muṉguynha ŋarru banha wuŋgandhum ṉoka.” Bilanya banha mayalimꞌ gamꞌ: ŋurruŋum nhan ŋarru Djesuyu guŋgaꞌyun nhanguway nhan yolŋuny warrany Djuw malany ga ŋärrun nhan ŋarru guŋgaꞌyun waripunham bäpurruny yolŋuny warrany. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Bala nhan banha dhäykayum buku-ganitjuman bitjanan, “Yultha yana dhuwaniyam, marrkapmi. Ŋarru nhanmam bayiŋ banha wuŋgandhum ṉoka yana gälkinyaram ŋatha bewaḻim banha yumurrkuꞌwurum biḻitŋuru.” Ga djinalaŋam banha bilanyan mayaliꞌ gamꞌ: banha nhan yakan Djesuyu nhanguwayma yolŋuny warrany guŋgaꞌyuwan, ga bitjanaya ḻinygu nhan ŋarru banha waripunham yolŋuny warrany guŋgaꞌyunya. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ga banha nhan Djesuyu bilanyawuyma ŋäkul bala nhan bitjanan wäŋanam, “Wäy, dhaŋum nhunu yulthan yana wäŋanam. Gatjuy, ŋarryan ŋayiḻin ḻinygun banha maḻikum birrimbirr yuṯthuwanan wakuꞌmiŋuwuḻim nhuŋguru.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Bala nhan banha dhäykam ḏitjuwanan ŋayiḻin. Ga ḏoyꞌyuwanam nhan ŋayiŋam, nhäŋalam nhan banha wakuꞌmiŋunham nhan yakan ŋoyanam yakurr-ŋuwatjinan, ḻinygun nhangura banha maḻikum birrimbirr dhawaṯthuwanan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ga dhurrwaraŋuru bewaḻiyam nhan Djesuyum gananan banhayam ŋayi Däyam, bala ŋarruŋan balan Djäydanḻin, ŋarru dhukam nhan banha mäyanam ŋunha räy-warryuwanan, gumurr-djawꞌyuwan ŋoymurrun ŋarkulaꞌmurrun. Ga mä-waŋganynha ŋarruŋan balan Galaliḻin guḻunḻi ga ḏoyꞌyuwan dhanal banhalayan ŋayiŋa makaŋa yäkuŋa ‘Dikapulitjnha’. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ga banhalayam yakan yolŋu nyenan dhoŋuluꞌ banha ḻunduꞌmiŋuyu warrayu nhanany ḏupꞌthuwan balaya Djesuwuḻ. Ga ŋäŋꞌthuwan dhanal bitjan, “Buku-djulŋi, ŋatjil goŋ-ŋalthuwa djinakuḻ yolŋuwuḻ mä nhan ŋarru ŋuwatjin.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Bala nhan Djesuyum gaḏaymanan banha dhoŋululꞌnham gänaŋuḻin, bala nhan ŋopurrnha gulŋiyan nhanguḻ buthuruḻin, bulalꞌḻin yana. Ga dhupthuwan nhan ŋopurrḻi nhanguwaywuḻi, bala gathanan banha yolŋunham ŋäṉarrnha. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ga buku-garrwartjin nhan djiwarrꞌḻi bala yindi-ŋirꞌyuwanan bala wäŋanan dhärukmurrun nhanguwaymurrun Arram-murrun bitjanan, “Yipatha!” (Bilanya gamꞌ mayaliꞌ, “Ḻapthuwan!”) ");
INSERT INTO dhgduwadha_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ga bitjanam nhan banha wäŋan bala banha yolŋuwum buthurum ḻapthuwanan, ga ŋäṉarrma nhangu banha dhayaḻayinan ŋuwakurruyinan yana, bala nhan yakan wäŋanam ŋuwatjumanan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Bala dhupal ḏitjuwanan balaya yolŋuwuḻ warrawuḻ. Ga bitjan nhan Djesuyu dhanaliny dhurrwara-mukthumanam, “Dhäwul nhuma ŋarru rakaram yolŋuwuḻim warrawuḻ banha ŋaya dhaŋu yolŋuny ḏukthuman.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ga yolŋuyum warrayu banha ŋäkul dhäwum, ga mariminan dhanal banha mä-maŋmaŋdhuwanam. Ga bitjanan dhanal yakan banha rakaranhaminam, “Nhän dhaŋum ŋayaŋu-ganyimꞌthundamin rom ŋatja! Djinaŋum yolŋuyu yaka ŋuwakurrun marimin djäma. Buthuru-dhumukthum yaka ŋäman ga dhäruknharram yaka wäŋan.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","3","Waŋganymiyum waluyu guḻku marimi yolŋu warra buku-ḻuŋꞌthuwan nhanguḻ Djesuwuḻ ŋänharawu dhäwuwun. Ḻinygu dhanal yakan nhangu banha malthuwan ḻurrkunꞌnha walum, ga dhawul yakan banha biyapuḻma ŋatha ŋoyan. Bala nhan Djesum gawawꞌyuwanan nhangu malthundamiwum warrawu bala wäŋanan bitjanan, “Ŋayaŋu-wuyuwanan ŋaya dhaŋu djinakum yolŋuwu warrawu. Guḻkun dhaŋu yolŋum warra barpuru bärrkuŋurum ŋarruŋa ga ḻinygun dhanal ḻurrkunꞌnha walum bitjan mala-manapanma ŋalmaliŋguḻ ga yanatj ḻinygu-u-u ga ŋatha ŋalmaliŋgu yawungu dhawarꞌyun. Ga dhäwulnha ŋalma ŋarru dhanaliny dhaŋu djaṉŋarrminham djuyꞌyun, dhanal bayiŋ bayan ŋunhuŋ gandarrŋan ḏalalakthu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ga dhanalim banha malthundamim warra nhangu buku-ganitjuman, “Wäy, buku-djulŋi, dhaŋum dhaŋu ŋayilpinꞌ ŋayi, ... nhalpiyana ŋalma ŋarru dhanaliny maranhu-guŋanma ... nhaliyun?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ga nhanmam Djesuyum dhä-wirrkaꞌyuwan dhanaliny, “Nhämunhaꞌ nhuma yaka ŋatham gathan?” Ga dhanalim buku-ganitjuman, “Marrkapmi, 7 yana dhaŋu dämbam.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Bala nhan Djesuyum wäŋanan dhanaliny, “Maꞌ ḏäpthuwan warra munathaꞌḻin.” Bala nhan banha ḻurrkunꞌma ḏämba mäyanan bala buku-wikanan God-Waŋarrnhan. Ga bakthuman nhan bitjan yumurrkuꞌkuwan bala ŋarruŋan guŋanan malthundamiwuḻin nhanguwaywuḻ. Ga dhanalim ŋarruŋan guŋanan ŋunha yolŋunhan warrany. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ga ḻurrkunꞌ dhanal yakan guyam mala ŋayathan. Ga buku-wikan nhan God-Waŋarrnha bayikuya ŋarirriꞌwu, bala guŋanan malthundamiwuḻin warrawuḻ bala dhanalim ŋarruŋan yolŋunhan warrany guŋan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Ga bukmakma banha yolŋum warra ga 4000 malam. Ga nyaŋꞌthuwanam dhanal ŋarruŋan banha ŋatham ga maranhuyin yana. Ga banha dhanal dhawarꞌyuwanam nyaŋꞌthundaŋurum bala ŋarruŋan banha malthundamiyum warrayu wapthumanan bäytjinyaram ŋatha, ga dhaŋaŋguwan dhanal 7 batjim malany. Ga bewaḻiyam dhurrwaraŋuru nhan Djesuyum yakan yänguwanan dhanaliny ŋayiḻin. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ga banha dhanal yolŋum warra yakan ŋarruŋan ŋayiḻim, bala nhan Djesum ga malthundamim warra nhangu ŋalthuwanan marthaŋayḻin bala dhanal ŋarruŋanan, ŋayiḻin yäkuḻi Dalmanuthaḻin. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ga banha dhanal Djesu ga nhämunha banha yakan malthuwan nhangu, ḏoyꞌyuwan banhalaya ŋayiŋa Dalmanutham. Ga ḻurrkunꞌ yolŋu warra bewaḻiya banha Baratjiwuru malaŋuru ŋarruŋan balaya nhanguḻ Djesuwuḻ, bala dhanal yakan dhäruk-ḏupthunminan mä dhanal ŋarru bawaꞌkuŋan nhanany. Ga bitjan dhanal banha nhanany wäŋanam dhä-wirrkaꞌyuwanam, “Go, wilak maŋutji-guŋa ŋanapiliŋguḻ ŋayaŋu-ganyimꞌthundami rom mä ŋanapu ŋarru nhäma ga mä-yuwalkmiyi banha nhunu yultha yana yaka ganydjarr gathan God-Waŋarrwuŋ!” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Bala nhan Djesum yindi-ŋirꞌyuwanan ga wäŋan nhan bitjanan, “Banha ŋaya bayiŋ bilanyawuyma ŋäma, banham nhuma bayiŋ nhänany ŋayaŋu-ḻiyuna! Nhäwu nhuma yaka dhaŋu ŋayaŋu-ganyimꞌthundamiwum romgu ŋäŋꞌthun? Dhäwul warra bitja waŋiya. Yultha dhaŋu ŋayaŋu-ganyimꞌthundamim rom yaka ŋoya, ŋarru ŋaya ŋarru dhäwulnha nhumaliŋgu maŋutji-wuŋanma.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ga bewaḻiyam nhan Djesum ŋarruŋanan gananan yolŋunham warrany bala dhanal malthundamim warra nhangu ŋarruŋan buḏapthuwanan marthaŋayyun bayikuya guḻunꞌku ŋunha galiꞌḻin. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Manymak, bala dhanal Djesum ga malthundamim warra nhangu ŋarruŋanan. Ga gandarrŋam guḻunŋam bala dhanal guyaŋinan banha dhanal meṉguwan ŋathawu mäyanharawu. Ga waŋganynha dhanal yakan banha dämbam golan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ga nhanmam banha Djesuyum dhanaliny ŋäkul, dhanal ŋarruŋan wäŋanharamin ŋathawuy bala nhan bitjanan, “Dharraḏayiya, ga djäga warra ŋay, mä nhumaliny ŋarru dhäwul mu mayaliꞌ-golamam Geŋ Yaritthum ga Baratjiyum yolŋuyu warrayu, bilanya dhanaliŋgu banha dhärukma bitjan ŋathawuy ḏululꞌyumanda.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ga banha dhanal malthundamiyum warrayu nhanguḻ ŋäkul bala dhanal mä-dhumbalꞌyuwanan. Bala dhanal yakan wäŋanharaminan, “Nhalpiyan nhan dhaŋu marrkapma wäŋan, ... wilak ŋalma dhäwul ŋatha guyukan?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ga nhanmam banha Djesum marŋgiyin dhanaliŋgu nhalpiyan dhanal yakan guyaŋin, bala nhan bitjanan, “Nhä nhuma yaka dhaŋu ŋathawuyma yana wäŋanharami, ... dhäwul nhuma banha nyäku mayalimꞌ mäyan? Nhä nhumaliŋgu dhaŋu muḻkurrma dhumuknha, ŋatja? ");
INSERT INTO dhgduwadha_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ḻinygu mu nhuma yakan dhaŋu nhäŋalam, ŋarru nhuma dhäwulnha banha dharaŋganam. Dhaŋum nhuma dhuŋamin nhänharawum. Ga ḻinygu nhuma yakan banha ŋäkulam, ga dhäwul yana nhuma dharaŋganam, ga banham nhuma dhuŋamin yana ŋänharawum. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nhän nhuma dhaŋu buku-dhumuktjinan, ŋatja? Banha ŋaya dämba malany bakꞌ-bakthuman ga maranhu-guŋgan 5000-nha yolŋuny warrany? Ga nhämunhaꞌḻi batjiḻim nhuma banha bäytjinyaram ŋatha malany wapthuman?” Ga dhanalim buku-ganitjuman bitjan, “12-mu banha batjim, marrkapmi!” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ga biyapul nhan Djesuyu dhä-wirrkaꞌyuwan, “Nhä nhuma yaka dhaŋu guyaŋi mu, banha ŋaya bakthuman 7 ŋatha malany maranhu-guŋandawu 4000-gu yolŋuwu warrawu? Ga nhämunhaꞌḻi batjiḻim nhuma banha bäytjinyaram ŋatha malany wapthuman?” Ga dhanalim buku-ganitjuman, “Yo, 7 banha batjim marrkap!” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Bala nhan Djesum bitjanan wäŋan, “Yultha dhaŋum, bili mu nhuma dhaŋu nhäŋalam nhumaliŋguru maŋutjiyum, ŋarru nhäwun nhuma yaka dhaŋu dhäwulma dharaŋgan banha ŋalaŋuru nyäku yaka ganydjarr ŋarruŋa?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ga bewaḻiyam nhan Djesu ga malthundamim warra nhangu ḏoyꞌyuwanan ŋunhalan Bithdjaydam-n ŋayiŋa. Ga banhalayam dhanal yolŋuyu warrayu guyukan bambaynhan yolŋuny nhanguḻ Djesuwuḻ, ga ŋäŋꞌthuwan dhanal Djesuny nhan ŋarru gathan banha bambaynha yolŋuny, mä nhan ŋarru ŋuwatji. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Bala nhan Djesuyum garrꞌyuwanan banha bambaynham yolŋuny gänaŋuḻin ŋayiḻi. Bala nhan dhupthuwanan nhanany maŋutjim bala gathanan, bala dhä-wirrkaꞌyuwanan, “Ŋalan, nhäŋalan, ... nhunu?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ga nhanmam banha yolŋum buku-garrwartjinam ga ḏawaꞌyuwan nhan bala djarrpuḏayꞌḻi ga dhunupaḻi galiꞌḻi, bala buku-ganitjumanan, “Dhaŋu ŋaya yaka yolŋunham warrany nhäman, ŋarru mä gaŋga, bilanya bitjan dharpa malany nyin maliꞌ-maliyun!” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ga biyapul nhan Djesu ŋarambiya-ŋalthuwan banha yolŋuwuḻ maŋutjiḻi. Ga mariminan nhan yakan banha bambayma yolŋu maŋutji-ḏukṯukmiyinam nhänharawun yana. Bala nhan banha bayiŋuya yolŋuyum ŋuwatjuwmanan nhäŋal, ḻinygun nhangu banha maŋutjim ḻapthuwanan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Bala nhan Djesuyum djuyꞌyuwanan banha yolŋunham bitjanan, “Ŋarryan ŋayiḻin, ga dhäwulnha ḏitjuwa Bithdjaydaḻim.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ga bewaḻiyam nhan Djesum ga malthundamim warra nhangu yakan ḻiwꞌyumanan ŋarruŋan ŋunhalam Djitjariya Bilipayma ŋayiŋa. Ga ŋunhalaya gandarrŋam bala nhan Djesuyum ŋäŋꞌthuwanan nhanguway malthundaminham warrany bitjanan, “Wäy, yulparra, nhalpiyan bayiŋ yaka banha yolŋuyum warrayu rakaram, ... yol dhaŋu ŋayam?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ga dhanalim buku-ganitjuman bitjan, “Yolŋuyum warrayu nhunany bayiŋ yaka dhaŋu rakaram yana warri nhunu dhaŋu Djonnha banha Buku-ḻupthundamin yolŋu. Ga waripuyum warrayu nhuna bayiŋ yaka rakaram be warri nhunu Yilaydjan banha ŋaḻapaḻnha yolŋu God-Waŋarrwun djawarrkmi bamanꞌŋuwuynha. Ga waripuyum nhuna yaka rakaram, dhaŋu nhunu waripun God-Waŋarrwu djawarrkmi yolŋu bamanꞌŋuwuynha.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ga biyapul nhan Djesuyu dhä-wirrkaꞌyuwan, “Wäy-y, nhumapim yaka nhalpiyan nhänany guyaŋi, ... yol dhaŋu ŋayam?” Bala nhan Betayum nhangu buku-ganitjuman bitjanan, “Marrkapmi, dhaŋum nhunu Christ banha Maŋutji-dhunupayumandan yolŋu God-Waŋarrwuŋun gänaŋꞌthundan ŋätjiliŋuwuynha.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Bala nhan Djesuyum dhanaliny dhurrwara-mukthumanan bitjanan, “Dhäwulnha nhuma ŋarru guḻkuwuḻim rakaraŋ ŋay!” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ga bewaḻiyam nhan Djesuyum rakaranan nhanguway malthundamiwum warrawu bitjanan, “Ŋayapi yana dhaŋu Yuwalkŋum Walꞌŋu Yolŋu, dhäwulnha wiripu. Yo, yalalaŋumim ŋayam barkthu banha marimin yana dhaŋgaḏirryum, ḻinygu ŋurru-warryundayŋuyum warrayu ga ŋurruŋu-djirrikaymiyum ga rom-marŋgikunhamiyum yolŋuyu warrayu nhänany barkthu ḻikandhu-ḏupthun, bala dhanal barkthu nhänany boyun waŋayumun yana. Ga bulalꞌ munha barkthu djuḻkthu bala ŋaya barkthu wälŋayin rakunyŋurum.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ga banha nhan Djesu rakaranhaminam, bala nhan Betayum nhanany barkan warryuwan bala dhaykuwanan raypirriꞌyuwanan nhanany bitjanan, “Marrkapmi, dhäwul nhunu bitja waŋiya! Ŋayam ŋarru dhanaliny gulyumana nhuŋguru boyandaŋurum rakunykunhaŋurum.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ga bitjanam nhan banha Betam wäŋan dhäwul God-Waŋarrwurum ŋayaŋuyu. Bala nhan Djesum bilyuwanam bala ŋarruŋan nhäŋalan malthundaminham warrany nhanguway, bala nhan maḏakarritjthun dhärukthum wäŋan Betanham bitjanan, “Mukthuwa! Dhuwanma yaka Djaytinnha wäŋa banha nhan buŋgawan waŋawun malaŋuwu. Gatjuy yuṯthuwan. Dhaŋu nhunu yaka yolŋuwurun ŋayaŋuyu wäŋa, dhäwul God-Waŋarrwurum ŋayaŋuyu.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Bala nhan Djesuyum waripunham yolŋuny warrany ga malthundaminy warrany nhanguway yurrumꞌthuman, bala nhan dhanaliny yakan marŋgiyumanan bitjanan, “Bilaŋ nhan ŋarru yolŋu yaka djälmiyi nyäkum malthundawu, nhan ŋarru yaka bitjanma ḻinygu nyäkum malthun, banham nhan ŋarru meṉguman nhanguwayma ŋayaŋu, ga malthunma nhan ŋarru God-Waŋarrwun ŋayaŋuwu, bayaya ŋarru banha yolŋu djälmiyi boyandawum nhangu waŋayumandawum. Ga nhanmam ŋarru yaka bitjana ḻinygu malthuna yana, bitjan bayiŋ yolŋuyu ḻawꞌyuman nhanguway dharpa-mälakthumanda ḻambarryu, bala ŋarruŋan gumurrꞌyuna rakunydjinyarawun yana. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ga banha ŋarru yaka yolŋu nyena nhanguwaywurum wälŋayu, ga ḻuŋꞌthuman ŋarru yaka be nhä mala rom, yana yaka yinḏikunharami, bayikuyam yolŋuwu ŋarru banha nhäm mala ga wälŋam nhangu winyaꞌyuna yana. Ŋarru banham yolŋu, banha nhan ŋarru waŋayi ḻinygu nhan bayiŋ yaka nyäku malthun, ga rakaram bayiŋ yaka God-Waŋarrwun yana rom, yalalaŋumim nhan barkthu gi banha nyinayim wälŋam dhawarꞌyundanharran. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Maꞌ ŋäkan warra! Bilaŋ nhunu yolŋu ṉukunydjam walꞌŋu, ŋunhuŋ nhä guḻkumim, ga bayiŋ nhan ŋarru banha God-Waŋarryum nhunany ḏupthunma, ga nhän nhunu ŋarru banha mäyamam? Dhäwulnha! ");
INSERT INTO dhgduwadha_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ga bayiŋ nhunu yaka mäyu-ḏapthuman nhä malany djinakuwuy munathaꞌwuy, banham nhunu ŋarru dhäwulnha buku-djuḻkthuman guŋan ŋunhuŋ nhä wälŋawum nhuŋguwaywuru ḏitjumandawu! ");
INSERT INTO dhgduwadha_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Yo, ŋäkan warra! Dhaŋum yaka djinaŋum bala yolŋuyum warrayu djinalam munathaꞌŋam warkthun guḻkun marimin maḻikum rom malany. Ga dhäwulnha dhanal yaka ŋayaŋumiyim malthundawum God-Waŋarrwum. Ga bayiŋ nhunu ŋarru yaka räy-nhinathuŋganmi nyäkum malthundawu, ga marŋgiyumandawum nyäku, ŋayam ŋarru bitju bili nhuŋgum räy-nhinathuŋganmi, ga dhäwulnha nhunanham rakaraŋ ŋunhalam God-Waŋarrwuḻim gumurrŋa. Ḻinygu ŋayam barkthu banha Yuwalkŋum Walꞌŋu Yolŋu, ḏitjun bewaḻi djiwarrꞌŋurum ŋapa-malamin ŋanapun djiwarrꞌwuynha dhäwumin yolŋu warra. Ga yarrupthum ŋanapu barkthu banha djiwarrꞌŋurum djeŋarraꞌyakaynha bäyman guŋgurrkuŋgurrnha, ga bilanyamiyun ŋarru banha yolŋuyum warrayu dharaŋgum nhänany. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yo, yaka warra meṉguŋam nyäku dhärukma ŋay! Djinalaŋam malaŋa dhaŋu nhuma yaka dhäya-dhäya, banha nhuma bayaŋu yana waŋayin, yalalaŋumiyum nhuma barkthu banha ḻurrkunꞌthun yana yolŋuyum warrayu nhäŋun nhan ŋarru God-Waŋarryum nhanguway romnham ŋarruŋanharamiŋgun, ganydjarryum yindiyun walꞌŋu marimin.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ga 6 walu djuḻkthuwan, bala nhan Djesuyum garrꞌyuwanan Betanham ga Djayimnham ga Djonnham, mä dhanal ŋarru bukuḻin ŋarruŋa yolŋunharraḻin. Ga banha dhanal ŋunha bukum gathan bala dhanal nhäŋal Djesunham nhan waripuŋuyinan maŋutjiŋam dhanaliŋguḻ. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ga girrimꞌ nhangu yakan banha biyapulnha walꞌŋu dhika djaḻkarrꞌyuwan, gaywaraŋun yana lanyiŋnha bäyman, banha yaka djuḻkthumana bilaŋ nhä watharr marimi girriꞌ. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ga ganyimꞌthuwanan dhanal banha nhäŋalam nhanany Djesunham nhan yakan wäŋan bayikuḻin banha ŋätjiliŋuwuḻin ŋaḻapaḻwuḻi wulaykuḻ, Yilaydjawuḻin ga Mawtjitjkuḻin. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Ga mariminan dhanal banha malthundamim warra biyaṉiyinam, ga nhanmam banha Betam mä-dhumbalꞌyuwanan bala nhan guyaŋinyanharran wäŋan bitjanan gamꞌ, “Wäy Garray, ŋuwakurrun dhaŋum marimin, ŋatja? Nhä banha ŋuwakurru ŋanapu ŋarru nhumaliŋgu warrawꞌma malany warkthun? ... waŋganyma nhuŋgu ga waŋganyma Yilaydjawu ga waŋganyma Mawtjitjkun?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ga bewaḻim bala waŋupinin maḻŋꞌthuwan bala yana dhurrthurrꞌyuwanan dhanaliny. Bala dhanal ŋäkulan rirrakaynha nhan yakan wäŋan beŋuru maŋanŋurum bitjanan gamꞌ, “Ŋäkan warra! Dhuwaniyan banha nyäkuwayma walꞌŋu gäthuꞌmiŋu marrkapma. Nhanguwaynha yana warra buthuru-bitjuwam!” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ga banha dhanal ŋäkul rirrakayma, ga ḏawaꞌyuwanam, ga nhäŋalam dhanal Djesunhan yana nhanapinyaynhan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ga bewaḻiyam bala nhan Djesum ga malthundamim warra nhangu ŋarruŋanan yarrupthuwanan bukuŋurum. Bala nhan Djesuyum wäŋanan dhanaliny bitjanan, “Nhä nhuma banha nhäŋal, dhäwulnha nhuma ŋarru rakaram yolŋuwuḻim warrawuḻ. Ŋaya mu dhaŋu Yuwalkŋum Walꞌŋu Yolŋu. Ŋurruŋum ŋaya barkthu waŋayi, ga biyapul ŋaya barkthu banha wälŋayi. Ga ŋärrun nhuma barkthu banha yolŋuwuḻim warrawuḻ rakaraŋ.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ga baṯ-bitjanan dhanal yakan banha dhärukma nhanany Djesunham gathan, ga dhäwulnha dhanal banha yolŋuwuḻim warrawuḻ rakaran. Bala dhanalim banha ḻurrkunꞌma nhangu malthundami warra yakan dhä-wirrkaꞌyunmin bitjanminan, “Nhäwu nhan banha bitjanam wäŋan? Be nhan barkthu biyapul wälŋayi rakunyŋurum? Nhalpiyun barkthu banha bitjum maḻŋꞌthu?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Bala dhanal nhanany dhä-wirrkaꞌyuwanan bitjanan, “Nhäwu bayiŋ yaka banha Rom-marŋgikunhamiyum warrayu rakaram banha nhan ŋarru Yilaydjam ŋurruŋum ḏoyꞌyu, ga ŋärrun barkthu nhanmam Christma banha Maŋutji-dhunupayumandam yolŋu ḏoyꞌyu? Ga nhunupim yaka nhalpiyana guyaŋi way, Marrkapmi?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Bala nhan Djesuyum buku-bakthumanam bitjanan, “Yultha dhuwanma. Nhän ŋatjil ŋarru banha banhaya bamanꞌŋuwuy ŋaḻapaḻ yäku Yilaydja ŋurruŋum ḏoyꞌyu, ŋätjilmiŋganma dhukam yäkthun nhangum banha Maŋutji-dhunupayumandawum Yolŋuwu banha nhan God-Waŋarryu nhanany ŋätjilmiŋgan dhä-ŋätjil yana. Ga nhäwun nhumam bayiŋ yaka dhaŋu djinaŋum warrayu dhäwulma banha dharaŋgan banhayam mala dhäwu banha wukirriwuyma ŋunha God-Waŋarrwuḻim djorraꞌŋa, bayikuwuyma banha Yuwalkkuruyma Walꞌŋu Yolŋuwuy? Ŋarru ḻinygu mu dhanal banha dhäwum nhanguruy wukirri, ga yolŋuyum warrayu nhanany ŋarru bukuyu-ḏupthuna bala dhanal ŋarru boyana nhanany waŋayumana. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Gatjuy, ŋuwatjuman warra ŋäkam! Banhayam banha ŋätjiliŋum yolŋu Yilaydjam ḻinygu nhan ḏoyꞌyuwan. Ŋarru yolŋum warra dhanaliŋguwaynha ŋayaŋuwu malthuwan bala maḻikuyumanan nhananham nhäŋal. Ga bilanyaya dhanal yakan banha ŋätjiliŋuyum djawarrkmiyu warrayu dhärukma wukirri ŋätjilim.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ga banha dhanal Djesu ga ḻurrkunꞌ malthundami warra nhangu ḏoyꞌyuwanam waripuwum warrawu malthundamiwu, bala dhanal nhäŋalan guḻkunhan yolŋunham warrany. Bala banha yolŋum warra ḻuŋꞌthuwanan bala yakan nhäŋalan Djesuwun banha malthundaminy warrany dhanal ŋarruŋan dhaykunharamin ŋunha rom-marŋgikunhami yolŋu warra. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ga banha dhanal yolŋuyum warrayu nhäŋalam nhanany Djesunham bala dhanal ganyimꞌthuwanan, ḻinygu dhanal banha bitjan guyaŋin yana warri nhan yakan baḏak nyenan ŋunhalaya bukuŋa. Bala dhanal gumurr-yuṯthuwanan nhangu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Bala nhan Djesuyum dhä-wirrkaꞌyuwanan dhanaliny bitjanan, “Nhäwuy nhuma yaka dhaŋu dhaykunhamim?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ga nhanmam waŋganyma yolŋu bitjanan wäŋan gamꞌ, “Marrkapmi, ŋäka nhänany! Dhaŋu ŋaya yothuny ḏirramuny nyäkuway guyukan, mä nhunu ŋarru ḏukthuman nhanany. Dhäwul nhan dhaŋu dhäruknharra ga dhaŋu nhanany bayiŋ yaka maḻikuyu birrimbirryu mala gathan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ga banha nhanguḻ bayiŋ maḻikum birrimbirr gulŋiya bala nhan bayiŋ nhanany butparkthumana nyin munathaꞌḻin. Bala nhanguḻ bayiŋ dhurrwaraŋurum ŋarruŋ ŋälma djalkthunmin bala nhan bayiŋ rirra-rathanmin. Ga rumbalma nhangu bayiŋ banha wanyuyin bilanyan bitjan dharpan. Ga ŋäŋꞌthuwan ŋaya dhaŋu malthundaminy warrany nhuŋgu guŋgaꞌyundawu, dhawaṯthumandawu djinaku birrimbirrwu, ŋarru gulkurun.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ga banha nhan Djesuyu bilanyawuyma ŋäkul bala nhan mariminan maḏakarritjtjinam dhanaliŋgu ga bitjan nhan wäŋanam, “Nhä nhuma dhaŋu yolŋum warra dharaŋgandanharran, linygu mu ŋaya bayiŋ yaka nhumaliny dhaŋu marŋgiyumanma bitjan mu bili yana, ga nhä nhumam yaka dhaŋu dhiryun marŋgiyim? Dhäwul nhuma yaka dhaŋu nyäku yuwalkma mä-yuwalkmiyi, ŋatja? Nhämunhaꞌmin ŋaya ŋarru nhumaliŋgu gäḻkuḻamam? Gu, guyukaŋan warra yothunham rälin!” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Bala dhanal ḻawꞌyumanan banha yothunham bala guyukaŋan nhanany Djesuwuḻin. Ga banha nhan bayiŋuya maḻikuyum birrimbirryu nhäŋal Djesunham bala nhan ḏupthuwanan banha yothunham munathaꞌḻin, baya yakan djalkthunmin, ga dhurrwaramurrum ŋarruŋan ŋälma yuṯthuwanan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Bala nhan Djesuyum dhä-wirrkaꞌyuwanan banha mäḻuꞌmiŋunham bitjanan, “Nhätha nhan yakan dhaŋu bitjanam?” Bala nhan banha mäḻuꞌmiŋuyum rakaranan, “Bilanyamiyu banha nhan yutjuwaḻa yana. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Wiyinŋumi nhan yakan dhaŋu maḻikum birrimbirr djälmiyi nhangu boyandawum. Ga bitjan ḻinygu nhan bayiŋ yaka nhanany djalkthun, waripum bayiŋ ḏupthun gurthaḻin ga waripum bayiŋ gapuḻin guḻwuḻyuman. Ga buku-djulŋi ŋatjil ŋalinyuny guŋgaꞌyuwa, gu? Bayiŋ dhaŋu gumurr-yalŋgim, maꞌ maŋutji-wuyuwan ŋalinyuŋgu, ga ḏukthuman dhaŋu yothunham.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Bala nhan Djesum bitjanan wäŋan, “Nhäwu nhunu bitjanam wäŋan, ‘Bayiŋ dhaŋu gumurr-yalŋgim’? Ŋayam ŋarru dhaŋu djäma yana, bayiŋ nhunu ŋatjil ŋarru mä-yuwalktji nyäku!” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Bala yana nhan banha bäpaꞌmiŋum mäḻiŋganminan bitjanan, “Marrkapmi, ḻinygun ŋayam dhaŋu mä-yuwalktjinan. Gu, guŋgaꞌyuwan nhänany mä nyäku ŋarru mä-yuwalktjinyaram marimin yana wanyuyi.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ga bilanyamiyum waluyu nhan Djesuyum nhäŋalan guḻkunhan yolŋunham warrany dhanal ŋarruŋan giṯthuwan räli malami. Bala nhan dhäruk-guŋanminan bayikuya maḻikuwum birrimbirrwu bitjanan, “Nhunu dhaŋu birrimbirr, dhawaṯthuwan djinakuḻim yothuwuḻ, mä nhan ŋarru ŋäman ga wäŋan! Ga dhäwulnha biyapulma ḏitjuwa nhanguḻ.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ga banha nhan bayiŋuya maḻikuyum birrimbirryu ŋäkul Djesunham wäŋanhara, bala nhan yatjuwanan mariminan dhika. Bala nhan banha yothum gälkinan, ḏalalakthuwanan, bitjan yakan rakunynha ŋoyan. Bala yakan banha yolŋum warra rakaranhaminan banhalayam, “Wäy, ḻinygun nhan dhaŋu waŋayinan!” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Bala nhan Djesuyum ŋarambiyan nhanany gathan bala ṉakanhamiŋganan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Bala dhanal Djesum ga malthundamiyum warrayu nhanguru gananan banhayam ŋayi, bala gulŋiyanan buṉbuḻin. Bala dhanal ŋunhalam dhä-wirrkaꞌyuwanan Djesunham bitjanan, “Wäy, nhäwu banha ŋanapum dhäwul dhawaṯthuman banhayam maḻikuny birrimbirrnha?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Bala nhan Djesum wäŋanan bitjanan, “Ŋuwatjuma ŋäkam! Bilanyayam banha birrimbirr mala maḻikun marimin. Ga banha nhuma ŋarru yaka dhäwulma bukumiŋgan guŋgaꞌyundawum, nhumam ŋarru dhäwulnha bilanyanham birrimbirrnha mala dhawaṯthuman yolŋuwuḻim.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ga bewaḻiyam nhan Djesum ga malthundamiyum warrayu nhanguru gananan banhayam ŋayi bala dhanal ŋarruŋan Galaliḻin makaḻi ŋayiḻi. Ga dhäwulnha nhan yakan banha djälmiyin dhanal ŋarru yolŋum warra nhangu mariŋgiyi banha nhan yakan ŋunhalaya nyenan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Yo, djälmiyinam nhan yakan, nhan ŋarru ga malthundaminhan warrany nhanguway marŋgiyuman. Ga bitjan nhan wäŋanam gamꞌ, “Yaka wiyinꞌma, bala dhanal barkthu nhänany ŋarambiyaꞌ-guŋun waripuwuḻin mulkuruwuḻin yolŋuwuḻ warrawuḻ. Bala dhanal barkthu nhänanham banha Yuwalknham Walꞌŋu Yolŋuny boyun murrkayꞌyumun. Ga waŋayi ŋaya barkthu yulŋum, ŋarru ŋaya barkthu biyapul wälŋayi dhurrwaraŋuru bulalꞌŋurum munhaŋuru.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Yo bitjan nhan yakan banha Djesuyum rakaran, ŋarru nhangu banha malthundamim warra mä-dhumbalꞌyuwanan. Ga dhäwulnha dhanal banha biyapulma nhanany dhä-wirrkaꞌyuwan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ga bewaḻiyam dhanal Djesum ga malthundamim warra nhangu ŋarruŋanan, ga ḏoyꞌyuwan dhanal ŋayiŋa yäkuŋa Gapuniyamnha. Ga banha dhanal djuḏupthuwanam buṉbuḻim bala nhan Djesuyum dhä-wirrkaꞌyuwanan dhanaliny bitjanan, “Wäy, yulparra, nhäwuy nhuma yakan banha dhäruk-ḏupthunminam?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ga dhanalim banha dhäwulnha nhangu buku-ganitjuman banha nhäwuy dhanal yakan wäŋanharamin dhuka-ŋupan, yol ŋarru banha ŋurruŋuyi bewaḻiya malaŋuru. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Bala nhan Djesum nyenanan bala nhan yakan dhanaliny marŋgiyumanan bitjanan, “Bilaŋ nhunu yaka ŋunhuŋ yol yolŋu djälmiyi nhunu ŋarru ŋurruŋuyim, nhunum ŋarru bitjan bitjuwalak dhaŋu gayꞌ yolŋu, djämamin yana birrkaꞌmiwun yolŋuwu.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Bala nhan Djesuyum yothunham ḻawꞌyumanan bala dhangiꞌyuwanan nhanany, ga gunyanam nhanany ṉapuŋgaꞌḻin gumurrḻin dhanaliŋguḻ, bala nhan bitjanan wäŋanam, ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Bayiŋ nhunu ŋarru bilaŋ yol yolŋu gumurr-ŋuwatji yolŋuwu räywuywum, ḻinygu nhan banha nyäkun yolŋu, banhayam nhunu nyäkun gumurr-ŋuwatjin. Ga bayiŋ nhunu nyäkum gumurr-ŋuwatjin, banham nhunu gumurr-ŋuwatjin nyäkun mäḻuꞌmiŋuwu, bayikuyan banha nhan nhänany djarrꞌyuwan ŋarruŋanharawu räli dhambal munathaꞌḻi ŋayiḻi.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ga bewaḻiyam dhurrwaraŋuru bala nhan Djesuwum malthundami yäku Djonma wäŋanan bitjanan, “Wäy, Marrkapmi, ŋunha ŋanapu yolŋuny nhäŋal nhan yakan maḻikuny birrimbirrnha dhawaṯthuman nhuŋguru yäkuyu. Ŋarru ŋanapum gulyuman nhanany, ḻinygu nhan banha yaka ŋalmaliŋgura malaŋa.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Bala nhan Djesum bitjanan dhanaliŋgu buku-bakthuman, “Dhäwul nhuma warri banha gulyumarra dhanaliny, ḻinygu banha ŋarru yaka yolŋuyu warkthun ganydjarrmim rom nyäkurum yäkuyu, ga yalalam nhanmam ŋarru banha dhäwulnha nyäkum maḻikuyuman wäŋa. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ga bilaŋ nhan yolŋu dhäwulma baku-ŋayathandami, banhayam nhan ŋalmaliŋguran galiꞌŋa. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ŋuwatjuma guyaŋiyam! Bilaŋ nhan ŋunhuŋ yolthu nhuna guŋgaꞌyuwan ḻinygu dhanal marŋgi banha nhunum bayiŋ yaka malthun Christ-kum, nhanmam ŋarru banha God-Waŋarryum banhayanham yolŋuny dhäwulnha yana meṉgum, bayaya banha nhan gapum yana nhuŋgu guŋan.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ga biyapul nhan Djesu wäŋan bitjan, “Bilaŋ ŋarru ŋunhuŋ yolthu yolŋuyu maŋutji-warryun nyäkum yothuny maḻikuḻim romḻi, bala nhan ŋarru banha gulyuna nyäkuru mä-yuwalktjinyaŋurum, ŋuwakurrum nhangu banha bayikuyam yolŋuwu maŋutji-warryundamiwum nhanany ŋarru mayaŋꞌnha mataꞌyuman rakiꞌyun, yindiyun bäthuyu, bala ḏupthuna dhulmuḻin ḏamurruŋꞌḻin gapuḻi, mä nhan ŋarru guḻwuḻyuna. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ga bayiŋ nhuŋguru goŋdhu ŋarru bilaŋ nhä maḻikum warkthun, nhunum yana gulkthuman banhayam goŋ, ḻinygu ŋuwakurrum nhuŋgu nhunu ŋarru djiwarrꞌḻim gulŋiyi goŋ waŋganymin. Ga bayiŋ nhunu baḏak yana goŋ-märrmaꞌmim, nhunanham barkthu ḏupthun balan gurthaḻin banha dhä-girꞌyundamiḻin ŋayiḻi. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ga banhayam dhaŋu maḻikun marimin ŋayi. Ga gurtham bayiŋ dhäwulnha bulŋuyuktji ŋunhalayam ŋayiŋa. Ga mewirrimꞌ bayiŋ yaka wälŋan yana gaḻyun, maḻikuyumana bayiŋ yaka ŋunhuŋ nhän malany. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ga bayiŋ nhuŋguru ṉukuyum goḻan nhuna maḻikuḻim, gulkthuman yana dhaŋuyam ṉuku, ḻinygu ŋuwakurrum nhuŋgu nhunu ŋarru barkthu djiwarrꞌḻim gulŋiyi ṉuku waŋganymin. Ga bayiŋ nhunu baḏak yana ṉuku märrmaꞌmim nhunanham barkthu ḏupthu balan gurthaḻin banha dhä-girꞌyundamiḻin ŋayiḻi. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ga banhayam dhaŋu maḻikun marimin ŋayi. Ga gurtham bayiŋ banha dhäwulnha bulŋuyuktji banhalayam ŋayiŋa. Ga mewirrimꞌ bayiŋ yaka wälŋan yana gaḻyun, maḻikuyumana bayiŋ yaka bilaŋ nhän malany. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ga bayiŋ nhuŋguru maŋutjiyum nhuna golan maḻikuḻim romḻi, nhunum yana ḏulŋurrꞌyuwan maŋutjim nhuŋguway bala ḏupthuwan, ḻinygu ŋuwakurrum nhuŋgu nhunu barkthu djiwarrꞌḻim gulŋiyi maŋutji waŋganymin, ga bayiŋ nhunu maŋutji märrmaꞌmim yana, nhunanham barkthu ḏupthu ŋunha gurthaḻin banha dhä-girꞌyundamiḻin ŋayiḻi. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘Ga banhayam dhaŋu maḻikun marimin ŋayi. Ga gurtham bayiŋ banha dhäwulnha bulŋuyuktji banhalayam ŋayiŋa, ga mewirrimꞌ bayiŋ yaka wälŋan yana gaḻyun maḻikuyuman bayiŋ yaka ŋunhuŋ nhän malany,’ ga bilanya. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Yo, ga God-Waŋarryum ŋarru banha birrkaꞌyunna nhanguwayma malthundaminy warrany gumurr-ḏälmurrun rommurru, bitjan bayiŋ yaka yolŋuyu ḏämbaꞌḏambakum nhanguway gaṉany dhunupayuman gurthayu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Manymak, djeꞌlam dhaŋu ŋuwakurru, bayiŋuyan bayiŋ banha ŋathanham dhäkaymiŋgan. Ga banha ŋarru dhäkayma dhawarꞌyun banham ŋarru maḻikun, bala bayiŋ djalkthuna. Yo, nhumam bitjayan bitjan banha djeꞌlan, dhäkaymiŋganmiyan mä nhuma ŋarru yaka ŋuwatjumana nyenam yolŋuwuḻim warrawuḻ malaŋa, ga mä-ŋuwatjinyamin ŋarru yaka bukmaknha. Bilanya dhaŋu! Mä gaŋga warra dhaykunharamiyam, yol ŋarru buŋgawayi ga yol räywuy!” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Bala nhan Djesum ŋarruŋanan balan Djudiyaḻin makaḻi ŋayiḻi. Ga waripum nhan bitjanan bala ŋarruŋan Djodinḻin maniḻi galki gali dhimurruŋan. Ga guḻkun banha yolŋum warra ḻuŋꞌthuwan nhanguḻ. Ga biyapul nhan yakan Djesuyu marŋgiyuman. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ga Baratji yolŋu warra balaya ŋarruŋan bala dhanal dhä-wirrkaꞌyuwanan nhanany, yäna birrkaꞌyuwan bitjan, “Nhalpiyan yaka ŋunha ŋalmaliŋgum rom wäŋa, ... nhan ŋarru ḏirramuyu ganan nhanguway dhäykanham bala djuyꞌyunna nhanany?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ga nhanmam Djesuyum buku-ganitjumanan bitjanan, “Guyaŋiya ŋatjil, nhalpiyan yaka ŋunha Mawtjitjkum Rom wäŋa bayikuyam banha ŋalmaliŋgurum romgu?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Bala dhanalim buku-ganitjuman bitjanan, “Ŋunha ŋalmaliŋguram mala-ŋurrkanhayŋuwum Mawtjitjkum yaka rom barraŋgaꞌyuwan ŋalmaliŋgum bitjan gamꞌ: Ŋurruŋum nhan ŋarru djorraꞌ ŋatjil wukirri gananminyarawu, ga ŋärrun nhan ŋarru gananma nhanany.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Bala nhan Djesuyum buku-ganitjumanam bitjanan, “Ŋäka warra! Yuwalkmu nhan banha mala-ŋurrkanhayŋuyum Mawtjitjthum bitjanayam rom gunyan, ḻinygu nhuma dhaŋu ŋayaŋu-wanyumi warra. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ga dhäwul warra banhayam dhäwuny meṉguŋ ŋay, banha ŋurruyirrꞌyundam, banha nhan God-Waŋarryu bokman dhaŋu djiwarrꞌ ŋayi ga dhaŋu munathanyꞌ ŋayiny! Ŋunha yaka wukirriwuyma dhäya bitjan gamꞌ, ‘God-Waŋarryu banha bokman yolŋunham, ḏirramuny ga dhäykany. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ga bayikuyan gämurruꞌwu nhan ŋarru banha ḏirramuyum ganan nhanguway ŋäṉdiꞌmiŋunham ga mäḻuꞌmiŋunham, bala ŋarruŋan ga mäyaman nhanguway dhäykanham, mä dhupal ŋarru yaka nyenam ŋayaŋu-waŋganynha, ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ga bulalꞌma banha ŋarru waŋganydjin.’ ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ga banha nhan God-Waŋarryu dhupaliny waŋganyguwanam, ga dhäwulnha ŋarru banha dhupaliny bilaŋ yolthum gänaŋꞌthuman, ḻinygu banhayam dhaŋu maḻikun marimin rom!” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ga bewaḻiyam nhan Djesu ga malthundami warra nhangu gulŋiyanan buṉbuḻin gänaŋuḻin. Ga banhalayan dhanal yakan ŋäŋꞌthuwanan nhanany Djesunham bitjanan, “Nhä mu nhunu yakan banha ŋanapiliny marŋgiyumanam yuṯayuṯaŋumim?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Bala nhan Djesuyum buku-ganitjuman bitjanan, “Bilaŋ ŋarru ḏirramuyu ganan nhanguway dhäykany ga mäyam ŋarru ŋunha waripunham, banhayam nhan ga marrambanꞌ warkthun. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ga bilanyaya bili dhäykawum. Banha nhan ŋarru ganan nhanguway dhuwayꞌmiŋuny bala yuṯthuna ga waripunhan mäyam, banhayam nhan marrambanꞌ warkthuwan.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Waŋganymiyum, yolŋuyu warrayu guyukan dhanaliŋguway yumurrkunyꞌ bala Djesuwuḻ, mä nhan ŋarru goŋ-ŋalthun dhanaliŋguḻ ga bukumiŋgan ŋäŋꞌthun God-Waŋarrnha mä nhangu ŋarru banha ŋayaŋu-ŋuwatjinyaramim rom maḻŋꞌthuna dhanaliŋguran. Bala dhanalim banha malthundamiyum warrayu dhaykuwanan dhanaliny ŋaŋꞌŋaŋdhuwanan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ga banha nhan Djesuyu dhanaliny bilanyaḻim nhäŋal, bala nhan maḏakarritjtjinan nhangu malthundamiwum warrawu bala nhan wäŋanan bitjanan, “Yaw, dhäwul dhaŋum yumurrkuꞌnham ŋaŋꞌŋaŋdhuwa, ḻinygu God-Waŋarrwum dhaŋu yolŋu warra bilanyan bitjan dhaŋun warra, gayꞌ. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Yo, ŋuwatjuma warra bitja guyaŋiyam. Bayiŋ ŋarru banha yolŋu yaka yuwalkma walꞌŋu djälmiyi God-Waŋarrwum, dhanalim ŋarru yulthan yana ŋayaŋumiyim nhangu, bitjan dhaŋu warra yumurrkuꞌ yaꞌ yultha bayiŋ yaka ŋayaŋumiyi dhanaliŋguwaywu ŋäṉḏiꞌmiŋuwu ga mäḻuꞌmiŋuwu. Ga banha dhäwulma, dhanalim ŋarru banha dhäwulnha yana God-Waŋarrwum yumurrkuꞌ.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ga dhurrwaraŋuru bewaḻiyam bala nhan Djesuyum dhanaliny yakan yumurrkunham ḻawꞌḻawyumanan, bala nhan goŋ-ŋalthuwanan bala bukumiŋganan God-Waŋarrwuḻin nhan ŋarru dhayuŋgana nhanguway ŋayaŋu-ŋuwatjinyamim rom dhanaliŋguḻin, bukmakkuḻin yana. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ga banha nhan Djesu yakan gurkuꞌyuwanam ŋarruŋanharawum, bala nhangu banha ḏirramum ḏoyꞌyuwanan. Bala bunꞌkumu-djipthuwanan nhan gumurrḻin Djesuwuḻin bala nhan dhä-wirrkaꞌyuwanan bitjanan, “Ŋuwakurru Marŋgikunharami, ŋaya nhuna dhä-wirrkaꞌyun ŋatjil. Bilanya dhaŋu gamꞌ: Nhalpiyan dhika ŋaya ŋarru yulŋum, mä ŋaya ŋarru yultham yana marŋgiyi banha ŋaya barkthu djiwarrꞌŋam nyenay God-Waŋarrwuḻim wiyiŋumim, wälŋa-dhawarꞌyundanharram?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Bala nhanmam Djesuyum buku-ganitjuman bitjanan, “Nhäwu nhunu dhaŋu bitjanam wäŋan, ‘Ŋuwakurru Marŋgikunharami’? bitjanam. Dhäwul dhaŋu bilaŋ yol yolŋu yuwalkma walꞌŋu ŋuwakurru, God-Waŋarr dhaŋu nhanbayin yana ŋuwakurrum. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ḻinygu mu nhuma dhaŋu God-Waŋarrwum dhäruk-guŋanminyarawu marŋgi banha yaka bitjan wäŋa, ‘Dhäwul yolŋuny boya waŋayuma; Dhäwul marrambaꞌyiya; Dhäwul manaŋiya; Dhäwul yalkuŋ rakaraŋ; Dhäwul mayaliꞌ-wilkthuwa yolŋuny, bala ŋarriya manaŋiyan nhanbal nhäm malany; Mä-ŋalthuwa nhuŋguway ŋäṉḏiꞌmiŋuwum ga mäḻuꞌmiŋuwum.’ ” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Bala nhan banhayam yolŋu bitjanan buku-ganitjuman, “Yultha yana marrkapmi marŋgikunharami. Ŋayam yakan dhaŋu gathan ga malthuwan djinakuyam romgu bewaḻi ḻinygu banha ŋaya yothu yana.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Bala nhan yakan Djesuyum nhäŋalan banhaya yolŋunham ŋayaŋuyum mä-ŋuwatjinyarayun bala nhan bitjanan wäŋan, “Gatjuy, ḏitjuwan ŋayiḻin ga djalimnha nhuŋguway nhäm malany warrpamꞌthuwan yana. Ga banha nhunu ŋarru rrupiyam mäyam bala mala-wulkthuman banhayam, bala guŋan ŋunha ŋurruwuykminhan yolŋuny warrany. Bala nhunu ŋarru nyäkun malthun. Ga yalalam nhan ŋarru God-Waŋarryum nhuŋgum buku-ḏitjuman guŋan nhä mala ŋunhalan djiwarrꞌŋan.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ga banha nhan bayiŋuya yolŋuyu bilanyawuyma ŋäkul Djesunham, bala nhangu ŋayaŋum-maḻikinan. Bala nhan ŋayiḻim ŋarruŋan galŋa-maḻikiyinan, ḻinygu nhan banha yuwalk yana ṉukunydjamꞌ. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Bala nhan Djesuyum nhäŋalan ŋarruŋan, bala nhan wäŋanan nhanguway malthundamiwum warrawu bitjanan, “Gumurr-wanyun dhaŋu marimi ṉukunydjaꞌwum yolŋuwu gulŋiyinyarawu balam djiwarrꞌḻim!” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ga banha dhanal malthundamiyum warrayu ŋäkul nhanany bilanywuyma wäŋanhara bala dhanal mä-dhumbalꞌyuwanan. Ga nhanmam Djesum biyapul wäŋan bitjan, “Ŋäkam warra ŋuwatjuma! Wanyu dhaŋu marimi gulŋiyinyarawu God-Waŋarrwuḻim gurruṯumiḻim romḻi. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Guyaŋiya banha wäyinꞌnha yäkuny gamuḻnha, yindi nhan banha marimi, ga gumurr-ḏäl nhangu banha gulŋiyinyarawum ŋunha yutjuwaḻamurrum ŋarŋgamurru, banha girriꞌwuy djawarꞌyunda ṉel. Yo, bilanyayan banha yulŋum ṉukunydjaꞌwum yolŋuwu, marimin yana gumurr-wanyun gulŋiyinyarawu God-Waŋarrwuḻim romḻi.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ga nhalpiyan nhan yakan banha Djesu wäŋan, dhanalim banha marimin mä-dhumbalꞌyuwanam. Bala dhanal dhä-wirrkaꞌyunminan bitjanan, “Ga bilaŋ nhan yaka dhaŋu yultham wäŋa, ga yolnha ŋarru barkthu gi banha nyenay ŋunhalam djiwarrꞌŋam nhanguram God-Waŋarrwuḻim?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Bala nhan Djesuyum dhanaliny ŋarruŋan nhäŋalan, ga bala bitjanan nhan wäŋanam, “Yolŋum ŋarru banha dhäwul gänam gulŋiya God-Waŋarrwuḻim Romḻi nhanguwaywurum ŋayaŋuyu. Ŋarru yaka warra meṉguŋam, nhanmam ŋarru banha God-Waŋarryum djäma yana nhä malany bukmak.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ga nhanmam Betayum buku-ganitjuman bitjanan, “Marrkapmi, ŋanapum dhaŋu bili ganan nhä malany ŋanapiliŋguwayma, bala malthuwanan nhuŋgun. Ga nhä dhika ŋanapiliŋgum buku-ḏitjumanda?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Bala nhan Djesum bitjanan wäŋan, “Ŋaya nhumaliŋgu rakaraman! Bayiŋ ŋarru yolŋu djälmiyi malthundawu nyäkum, bala ŋarruŋan ganana ŋarru nhanguway ŋäṉḏiꞌmiŋuny ga mäḻuꞌmiŋuny ga yumurrkunyꞌ nhanguway nhan ga yukuyukuꞌmiŋuny warrany nhanguway ga ŋayi nhanguway ga djäma nhanguway ga nhä malany girriꞌ nhanguway, bala nhan ŋarru ŋarruŋan yaka buku-ḻiwꞌyumana yolŋuwun warrawu dhäwun ŋuwakurrun rakaram nyäkuruynha. Ga yalalaŋumiyum nhangum barkthu banha buku-ḏitjumu biyapulnha walꞌŋu guḻkun marimin, bukuḻin-ŋalthumu barkthu. Nhä malany nhan ganan, nhangum barkthu guḻkun buku-ḏitjumu. Ga ŋayaŋu-ḻiyundamim rom nhan barkthu gi banha mäyaŋ yana, ḻinygu nhan yakan banha nyäku malthuwan. Ga yalalaŋumin banha barkthu dhaŋu munathaꞌ ŋayi dhawarꞌyum, bala nhan barkthu banha nyinayim wiyinŋumin wälŋa-dhawarꞌyundanharran ŋunhalan galkin yana God-Waŋarrwuḻin. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ga bayiŋ ŋarru yaka yolŋu bitjanma ḻinygu guyaŋinyarami yindikunharamim, banhayam nhan ŋarru nyumukuṉinyꞌtjin, räywuynha. Ga räywuyma barkthu ŋurruŋuyin, gämurruꞌŋun nhan yolŋu.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ga bilanyamiyum dhanal banha ŋarruŋanan balan Djurutjalamḻin, ga nhanmam yakan banha Djesum ŋurruŋun ŋarruŋan, bala dhanalim banha malthundamim warra ga waripum yolŋu warra yakan ŋapa-munguyuwanan nhanany. Ga guyaŋin dhanal ŋarruŋan banha dhärukma nhanany bitjandam wäŋanhara, “Yolŋuyum warrayu nhänany barkthu boyun ŋunhalam Djurutjalamma.” Ga mariminan dhanaḻim banha dhumbalꞌyuwan, biyaṉiyinan manapan. Bala nhanmam dhanaliny Djesuyum ŋäkul bala nhan ḻuŋꞌthumanan nhanguway malthundaminham warrany, bala nhan biyapul rakaranhamin dhanaliŋguḻ, banha nhalpiyu dhanal barkthu yolŋuyu warrayu nhanany ŋunhal Djurutjalam. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ga bitjan nhan banha wäŋanam, “Ŋäkan warra yulparra! Dhaŋum ŋalma yaka ŋarruŋan yulŋum Djurutjalamḻin. Ga dhaŋun ŋaya yulŋum Yuwalkŋum Walꞌŋu Yolŋu, dhaŋum dhanal barkthu nhänany ŋarambiya-guŋun ŋurruŋu-djirrikaymiwuḻin warrawuḻ ga rom-marŋgikunhamiwuḻin warrawuḻ. Bala dhanal barkthu nyäku yoranhamin waŋayinyarawum. Bala dhanal barkthu nhänany ŋarambiya-guŋan ŋunha waripuwuḻin yolŋuwuḻ warrawuḻ, banha dhanal dhuŋanmin God-Waŋarrwu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ga ŋunhalayan bala dhanal barkthu nhänany goṉa-wikaŋam. Dhupthun dhanal barkthu nhänany ga bartjumun nyin, ŋanaknha nhänany boyu. Ga dhurrwaraŋuru bewaḻiyam bala dhanal ŋarru nhänany murrkayꞌyumun boyu. Yo, yultha yana ŋaya barkthu banha waŋayim, ga bulalꞌ munha barkthu djuḻkthu bala ŋaya barkthu biyapul banha wälŋayi.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ga bewaḻiyam dhurrwaraŋuru bala dhupal banha Djibidiwum gäthuꞌmiŋu wulay, Djayimma ga Djonma, ŋarruŋanan guwatjmanan Djesunham. Bala dhupal ŋäŋꞌthuwanan nhanany bitjanan, “Wäy, Marrkapmi Marŋgikunharami, dhaŋu ŋalinyu yaka dhäruk nhuŋgu gathan.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Bala nhan Djesuyum dhupaliny dhä-wirrkaꞌyuwanan bitjanan, “Nhäwu nhuma ŋarru ŋäŋꞌthunma?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ga dhupalim bitjan wäŋan, “Wäy, Marrkapmi, yalalaŋumiyum nhunum barkthu dhaŋu ŋurruwuŋmin walꞌŋu, ŋurru-warryundamin ŋanapiliŋgu. Ga bilaŋ nhunu ŋarru bitjanaya bili ŋalinyuŋgum guyaŋi? Mä ŋarru ŋalinyum nhuŋguran galiꞌŋa. Waŋganyma ŋarru yaka nyena nhuŋgura dhunupaŋa galiꞌŋa, ga waripum ŋarru nyena wiṉꞌkuŋa galiꞌŋa.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ga nhanmam Djesuyum buku-ganitjuman bitjanan, “Dhäwul nhuma dhaŋu marŋgi nhäwu nhuma yaka dhaŋu ŋäŋꞌthun. Ŋayam barkthu dhaŋu yalalaŋumiyum dhaŋgaḏirryun marimin yana. Ŋalan? Nhalpiyun nhumam barkthu, ... bitju bili dhaŋgaḏirryu bitjan ŋaya, ga yanatj ḻinygu ga waŋayi barkthu?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ga dhupalim wäŋan, “Ŋe, ... bitju mu bili, Marrkapmi.” Bala nhanmam Djesuyum buku-ganitjuman bitjanan, “Yo, yuwalk yana nhuma barkthu banha dhaŋgaḏirryum, bitju mu bili bitjan ŋaya. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Wäy-y, banhayam ŋarru nhanbayin yana God-Waŋarryun mala-djarryuꞌ, yol barkthu nyenay dhunupaŋa ga yol wiṉꞌkuŋa galiꞌŋa. Ga ḻinygu nhan banha ŋätjil yana mala-djarrꞌyuwanam. Banhayam dhaŋu dhäwul nyäku mala-djarrꞌyundawu,” bitjan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ga banha dhanal waripuyum malthundamiyu warrayu ŋäkul dhupaliŋguŋ dhärukma banha ŋäŋꞌthundam, bala dhanal maḏakarritjinan dhupaliŋgu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Bala nhan Djesuyum dhanaliny ḻuŋꞌthumanan bala bitjanan wäŋan, “Marŋgi mu nhuma dhaŋu: banha dhaŋu djinaŋum bala ŋurru-warryundayŋum yolŋu warra bilanyayan, rom-wanyumin, buŋgawakunharamin dhanal bayiŋ yaka yolŋuwun warrawu guḻkuꞌwun. Bilanyan yaka dhaŋu maḻŋꞌthunma buku-ḻiwꞌyumanma djinalam munathaꞌŋam ŋayiŋa. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ŋarru nhumam ŋarru dhäwul bitjanya. Ga bayiŋ nhunu ŋunhuŋ yol yolŋu djinal malaŋa yaka djälmiyi ŋurruŋuyinyarawum, nhunum ŋatjil ŋarru djämamiyi waripuwu yolŋuwu warrawu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ga bayiŋ nhan yolŋu djäl ŋurruŋuyinyarawum, nhanmam ŋarru djämami bukmakkun yana yolŋuwu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ḻinygu ŋayam banha Yuwalkŋum Walꞌŋu Yolŋu dhäwul räli ŋarruŋan dhanal ŋarru yaka yolŋu warra nyäku warkthun. Ŋayam banha räli ŋarruŋan, mä ŋaya ŋarru yaka djäma yolŋuwun warrawu. Ŋayam banha ŋarruŋan ŋaya ŋarru waŋayin mundhurr-guŋanmin, mä ŋarru bayiŋuyam bäyarran, ḏitjumana ŋarru yolŋunhan beŋurun maḻikuŋurun romŋuru.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yo, Djesu ga malthundami warra nhangu ga waripu yolŋu warra guḻku marimi ḏoyꞌyuwan ŋunhal Djarikawnha ŋayiŋa. Ga banha dhanal gananam banhayam ŋayi, bitjanam yolŋu yakan bambay nyenan galiꞌŋa dhukaŋa yäku Bätimayatj, Dimayatjku gäthuꞌmiŋu, ŋäŋꞌthuwan nyinan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ga banha nhan bayiŋuya ŋäkul nhanany Djesunam banha Nätjiritjpuynam djuḻkthundam, bala nhan yatjuwanan yindiyun rirrakayyum bitjanan, “Djesu, Daybitkuḻ yarraṯaŋa, ḻinygun ŋanapu wiyinŋumin yakan dhaŋu gäḻkuḻanam nhuŋgu. Gu, maŋutji-wuyuwan nyäku.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Bala dhanal yolŋuyum warrayu ŋäkul nhanany yatjundam, bala dhanal ŋarruŋan dhaykuwanan nhanany bitjanan, “Ye, ... mukthuwan!” Ŋarru nhanmam mariminan dhika yatjuwan bitjanan, “Djesu! Daybitkuḻ yarraṯaŋa, maŋutji-wuyuwa nyäku!” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Bala nhan Djesum gulyuwanan bala wäŋanan, “Gu, rälin warra nhänany guyukaŋ!” Ga dhanalim ŋarruŋan nhanguḻ, bala wäŋanan bitjanan, “Ye, bilin, mukthuwan. Ŋunha nhuŋgu nhan yaka gawaꞌyuna. Maꞌ, gu ṉakaman!” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bala nhanmam banha Bätimayatjthum ŋäkul, bala yana yapthumanan nhanguway gärruŋma bala ṉakamanam ga bondin yana ŋarruŋanam-Djesuwuḻim.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Bala nhan Djesuyum nhanany dhä-wirrkaꞌyuwan bitjanan, “Nhäwu nhunu djälma?” Ga nhanmam banha bambayyum buku-ganitjuman bitjanan, “Buku-djulŋi, djälmiyi ŋaya yaka dhaŋu nhänharawun.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ga biyapul nhan Djesu wäŋan nhangu, “Ḻinygun nhunu dhaŋu mä-yuwalktjinan, ŋayam ŋarru ḏukthumana nhuna. Yo, bilin nhunu dhaŋu ŋuwatjinan, gatjuy ŋarryan!” Bala nhan Bätimayatjkum maŋutjim dhunupan ḻapthuwanan. Ga bewaḻiyam nhan yakan malthuwanan Djesuwun. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yo, Djesum ga malthundamim warra nhangu yakan ŋarruŋanan bala. Ga banha dhanal yakan ŋarruŋanam Djurutjalamḻim, bala dhanal ŋarruŋan bukuyu ŋayathan bulalꞌnha ŋayim yäku Bithanin ga Batpatjnha, ŋunhalayan bukuŋa yäkuŋa Wolipŋan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Bala nhan Djesuyum wäŋanan nhanguway bulalꞌnham malthundaminy wulaynha bitjanan, “Gatjuy nhumam ŋarryan wulay. Ga banha nhuma ŋarru banhalayam ŋayiŋa ḏoyꞌyun, ga maḻŋꞌthumanma nhuma ŋarru wäyinnha yäkuny duŋꞌkiny, dhäya ŋarru yaka garrwiꞌyunda dharpaŋa. Ga dhäwul nhan banha buŋgannharra yulŋum. Ga yapthuman nhuma ŋarru rakiꞌ, bala rälin golaŋ nyäkuḻ. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ga banha ŋarru yolŋuyum dhä-wirrkaꞌyun, ‘Nhäwu nhuma yaka dhaŋu yapthumanma?’ bitjanma, nhumam ŋarru bitjana wäŋa, ‘Garray dhaŋu djinaku djälmiyin, ga yalŋuwa nhan ŋarru ḏitjuman nhuŋgu.’ ” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ga banha dhupal ŋarruŋanam bala dhupal nhäŋalan banha duŋꞌkinham, ŋarru yutjuwaḻa, dhäyan nyinan garrwiꞌyunda gumurrŋa yana buṉbuŋa. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Bala banha yolŋuyum warrayu dhä-wirrkaꞌyuwanan dhupaliny bitjanan, “Wäy! Yulpulay, nhäwu nhuma yaka dhaŋu duŋꞌkiwuḻim yapthuman?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ga dhupalim wäŋan, “Garray dhaŋu djinaku djälmiyin, ga yalŋuwa ŋanapu ŋarru ḏitjuman.” Bala dhanal yana dhayuŋganan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bala dhupalim banha guyukanan banha duŋꞌkinham Djesuwuḻin. Ga ŋunhalam dhanalim ŋarruŋan banha ŋäkirrinyawuyma girriꞌ dhanaliŋguway ŋalthumanan duŋꞌkiwuḻin ŋarakaḻi, bala nhan Djesum ŋalthuwanan nhanguḻ ŋarakaḻim, bala ŋarruŋanan Djurutjalamḻin. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ga guḻkuyun yakan banha yolŋuyum warrayu ŋäkirrinyawuyma girriꞌ dhanaliŋguway rarrꞌyuwan dhukaḻim. Ga waripuyum yolŋuyu warrayu ŋarruŋan bakꞌpakthuman baṉan manꞌtjarrmin bitjan guḻwirri baṉa, banha yakan dhäyaꞌdhayan galiꞌmurru dhukamurru. Bala dhanal ŋarruŋan dhukaḻin rarrꞌyuwan mä nhan ŋarru yaka duŋꞌkim gayanhꞌthamurrun ŋarruŋa. Ga rom dhanaliŋgu yakan ŋoyan dhanal ŋarru bitjan goŋmiwum yolŋuwu gumurr-ŋuwatji. Ga waripum yolŋu warra yakan ŋarruŋan gumurrmurru, ga waripum warra dhurputj yakan ŋarruŋan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ga bitjanan dhanal ŋarruŋan banha yatjunminam gamꞌ, “Yo yo-yo, Hosanna! God-Waŋarr marrkapmi, dhaŋu ŋanapu yaka wokthuna nhuŋgu! Dhaŋum nhan ga ŋarruŋam God-Waŋarrwurun yäkuyum. Nhän banha God-Waŋarryu nhanany djuyꞌyuwanam, ga dhaŋun nhan rälin yaka ŋarruŋam. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Yo, yo-yo! Hosanna! God-Waŋarr marrkapmi, dhaŋu ŋanapu yaka wokthuna nhuŋgu! God-Waŋarr marrkapmi, nhunum ŋarru dhaŋunham yolŋuny buŋgawayumana bukmakkun yana Djuwwum yolŋuwu warrawu, bilanyan bitjan banha mala-ŋurrkanhayŋuny nhangu Geŋ Daybitnha. Yo, yo-yo! Hosanna! God-Waŋarr marrkapmi, dhaŋu ŋanapu yaka wokthuna nhuŋgu! God-Waŋarr, ŋunha djiwarrꞌŋam nhunum dhaŋu yindi-marimi!” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ga banha dhanal Djesu ga malthundami warra ḏoyꞌyuwanam ŋunhalam banha God-Waŋarrwuḻim Dharrpalŋam Buṉbuŋa, bala nhan ŋarruŋan nhäŋalan ḻiwꞌyumanan, banha mungurrma malany banhalaya ḻoḻuŋa, banha yakan djingaryuwan ḻiwꞌyuman. Bala banha walum giḻyuwanan, bala nhan Djesuyum gananan banhayam buṉbu bala ḏitjuwanan ŋarruŋan balan Bithaniḻin, ga dhanalin banha malthundamin warra nhangu galkiwuynha 12-nha. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ga waripuyun waluyu djaḏawꞌyundayun nhan Djesu ga malthundamim warra nhangu ŋarruŋanan beŋurum Bithaniŋurum balan Djurutjalamḻin. Ga gandarrŋam bala nhan Djesum marryaꞌyinan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Bala nhan nhäŋalan dharpan, dhäyan yakan galiꞌŋa dhukaŋa. Banhayam dharpa bilanyan bitjan muthirꞌ. Ga ŋarruŋan nhan galkiyin borumgu maḻŋꞌthumandawu ŋarru dhäwulnha. Yo, marwaṯma guḻku yakan goyuwan ŋarru borumnha bayaŋum, ḻinygu dhäwul banha bayikuya walum borumdjinyarawum. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Bala nhan Djesum wanyuyun dhärukthum wäŋan bayikuya dharpawum bitjanan, “Dhäwul ŋarru yolŋuyum biyapulma nhuŋguŋum borum ṉoka!” bitjan. Ga dhanalim banha malthundamiyum warrayu nhanguru ŋäkul nhanany bilanyaḻim wäŋanharaḻi. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Bala nhan Djesum ga malthundamim warra nhangu ŋarruŋanan balan Djurutjalamḻin. Ga biyapul nhan ŋarruŋan balaya God-Waŋarrwuḻ Dharrpalḻi Buṉbuḻi. Ga banhalaya goḏuŋa ŋayiŋa banha yakan ḻoḻuwunuwan Dharrpalnhan Mungurrnha, yolŋuyum warrayu ŋarruŋan wäyinnha mala wuŋiḻiꞌyuwan mundhurrwu-guŋandawu. Ga waripum dhanal yakan buku-djuḻkthumanmin banhalaya rrupiya. Dhäwulnha dhanal banha bayikuya buṉbuwum rumꞌrumdhuwan, maḻikun dhanal yakan warkthuwan. Ga waripuyum yolŋuyu warrayu yakan rrupiyan malany buku-djuḻkthuman, ga waripuyum yakan goŋ-djuḻuḻꞌyuwanan, manaŋinan manapan. Bala nhan yakan Djesuyum dhanaliny bukmakkuwanan yana dhawaṯthuman beŋurum banha mungurrŋurum, djalkthuwanan nhan ŋarruŋan dhanaliŋgu daybuḻma, rrupiya manapanan ga nyenanhamin mala dhanaliŋgu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ga gulyumanan nhan yakan banha yolŋunham warrany girriꞌŋurum guyukanharaŋuru, banha dhanal yakan ŋunhawitjan mungurrmurru räy-ŋarrꞌŋarr ŋarruŋan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Bala nhan Djesuyum yakan dhanaliny marŋgiyumanan guḻkunhan yana bitjanan, “Bamanꞌ ŋätjil nhan God-Waŋarr wäŋan nhanguḻ djawarrkmiwuḻ yolŋuwuḻ nhan ŋarru wukirri dhäruk djorraꞌḻi bitjan, ‘God-Waŋarrwum Buṉbu ŋarru yaka dhäya bukmakku yana bäpurruwu yolŋuwu buku-ŋalthundawu.’ Ga nhumam dhaŋum Buṉbuny rrorru, yanawarri dhaŋu manaŋganmiwun buṉbu.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ga banha dhanal ŋurruŋu-djirrikaymiyum ga rom-marŋgikunhamiyum warrayu ŋäkul, banha nhanany Djesunham banha nhä nhan yakan djäma, bala dhanal mariminan ŋayaŋu-maḻikinam. Bala dhanal yakan wäŋanharaminan dhukawun rangan boyandawun nhangu, ŋarru dhanal dhäwul banha biyaṉiyinam nhangu ḻinygu bukmakma yolŋu warra yakan banha Djesuwun mariminam djälmiyin, ḻinygu nhan yakan dhanaliny ŋuwatjuman marŋgiyumanan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ga banha walum gulŋiyan bala dhanal Djesum ga malthundamim warra nhangu ŋarruŋanan beŋurum Djurutjalamŋurum balan Bithaniḻin. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","21","Ga waripuyun djaḏawꞌyundayu waluyu nhan Djesum ga malthundami warra nhangu ḏitjuwan balaya Djurutjalamḻi. Ga gandarrŋam dhanal djuḻkthumanan banhayam dharpany banha nhan Djesuyu wäŋan wanyuyu dhärukthu. Ga dhanalim banha malthundamim warra nhangu mariminan yana ganyimꞌthuwanam, ḻinygu dhanal banha nhäŋal dharpam räwaknha yakan dhäyan, rakunynha, bewaḻi ḻinygu marwatŋuru ga baṯ-gathan ŋunha wärrurrꞌ. Bala nhan Betayum dhäruknha guyaŋin Djesunhan banha nhalpiyan nhan wäŋan bayikuya dharpawu. Bala nhan Betam bitjanan wäŋan, “Marŋgikunharami, dhaŋun banha dharpam räwaknha nyin dhäya rakunynha, banha nhunu wanyuyu dhärukthu wäŋan!” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Bala nhan Djesum bitjanan wäŋan, “Banha nhuma ŋarru God-Waŋarrwum mä-yuwalktji, nhunum ŋarru bitjanya bili warkthun bitjan ŋaya. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ga banha nhuma ŋarru yultham mä-yuwalktji warrpamꞌthum yana ŋayaŋuyu, ga dhäwulma mä-yuḻkthun, nhumam ŋarru wäŋan dhaŋuny gayꞌ bukuny ŋayiny nhan ŋarru ṉakamana bala gapuḻin ḏamurruŋꞌḻin ḻupthun. Nhanmam ŋarru God-Waŋarryum giṯthumana yana bukuny ŋayiny. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Yo, dhäwul warra meṉguŋam. Banha nhunu ŋarru yultham yana mä-yuwalktji, nhunum ŋäŋꞌthuwan nhänany birrkaꞌmiwun, ga nhanmam ŋarru guŋana yana. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ga banha nhunu ŋarru bukumiŋganma, ŋurruŋum ŋatjil guyaŋiya: Bayiŋ nhunu yolŋuny ŋayaŋu-maḻikuyuman, ŋarrya ŋätjil, ga doyꞌyuwa nhangu ga baya-rakaraŋ, dhäwul guyaŋiya bäyarraꞌwu. Ga banha nhunu ŋarru bitjanayam warkthun, nhanmam ŋarru God-Waŋarryum baya-rakaraman nhuŋgum, nhä malany maḻiku banha nhunu yakan warkthuwan. Nhunum dhanaliŋgu ŋatjil baya-rakaraŋ, ga ŋärrun bukumiŋga God-Waŋarrwuḻim. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ga banha nhunu yolŋu dhuŋam baya-rakaranharawu, nhanmam ŋarru God-Waŋarryum banha dhäwulnha nhuŋgum maḻiku mala meṉgum.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ga banha dhanal ḏoyꞌyuwan Djurutjaḻamma bala dhunupan dhanal djuḏupthuwanam mungurrḻin banha yakan ḻoḻuwunuwan God-Waŋarrwu Dharrpal Buṉbu. Ga dhanalim banha ŋurruŋu-djirrikaymim ga Djuwwu ŋurru-warryundayŋum warra ga rom-marŋgikunhamim yolŋu warra ḏoyꞌyuwanan nhangu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Bala dhanal dhä-wirrkaꞌyuwanan Djesunham bitjanan, “Wäy, gu rakaraŋan wilak ŋanapiliŋgu, yolthu nhuna banha wäŋanam djinakum buṉbuwum ḏarrtjalkkunharawu? Yolthu nhuna dhaŋu barka-nhinathuŋganam?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ŋarru nhanmam banha Djesum marŋgiyin dhanaliŋgu. Bala nhan bitjanan buku-ganitjuman, “Ŋaya ŋatjil nhumaliny ŋäŋꞌthun, ŋayꞌ. Nhuma ŋatjil ŋarru nyäku rakaram, ga ŋärrun ŋayam ŋarru nhumaliŋgum rakaram. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Marŋgi nhuma banha Djongum, banha Buku-ḻupthumandamiwum yolŋuwu? Yolthu banha nhananham barka-nhinathuŋgan yolŋuwum warrawu buku-ḻupthumandawu? God-Waŋarryu, wo yolŋuyu? ");
INSERT INTO dhgduwadha_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Bala dhanalim banha wäŋanharamin bitjanminan, “Wäy, nhalpiyana ŋalmam ŋarru dhaŋu buku-ganitjuman nhangu? Banha ŋalma ŋarru bitjanma wäŋa, ‘God-Waŋarryu nhanany banha wäŋan,’ bitjanma. Ga nhanmam ŋarru bitjana wäŋa, ‘Ga nhäwun nhumam banha nhangum Djongum dhäwul mä-yuwalkin dhärukku?’ ");
INSERT INTO dhgduwadha_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ga banha ŋalma ŋarru bitjanma wäŋa, ‘Yolŋuyu warrayu nhanany banha wäŋa bayikuya djämawu,’ bitjanma, dhanalim ŋarru yolŋum warra maḏakarritjtjin, ḻinygu dhanal marŋgi banha dhaŋu Djonma yolŋu God-Waŋarrwu djawarrkmi.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Bala dhanal bitjanan buku-ganitjumanam, “Dhäwul ŋanapu dhaŋu marŋgi!” Ga ŋärrun nhanmam Djesum dhanaliŋgu buku-ganitjuman bitjanam, “Ŋayam ŋarru dhäwul yana nhumaliŋgum rakaram yolthu nhänany banha barka-nhinathuŋgan.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ga bewaḻiyam dhurrwaraŋuru nhan Djesu biyapul wäŋan bayikuya banha ŋurruŋu-djirrikaymiwu ga rom-marŋgikunhamiwu ga Djuwwu ŋurru-warrundayŋuwu warrawu. Ga bitjan nhan banha dhäwum rakaran mayaliꞌmiŋganam gamꞌ, “Waŋganymiyum waluyu nhan ŋayi-waṯaŋu yolŋu ḏukṯukmiyin nhän ŋarru borum, wuḻuymuŋꞌtjinya lämu-nyipan. Yo, ga ŋurruŋum nhan ŋätjil ḻerrꞌyuwan ŋayiny baṉarraꞌyuman, dharpa gulkthuwan, bala ḻoḻun warkthuwan. Ga balaꞌpala nhan djäma yaŋaraꞌ garramatḻi melꞌŋuwun djägamiwu nyenanhawu. Ga banikinꞌ nhan yindi gunyan bayikuya borumgun wiyikaꞌwun. Bala nhan yolŋunhan warrany mäyan djägaminhan warrany, mä dhanal ŋarru yaka djägan bayikuya borumgun. Ga yalala ŋarru banha borumdjim bala dhanal ŋarru gänaŋꞌthumana nhangum bayikuyam ŋayi-waṯaŋuwum yolŋu. Manymak, bala nhan banha ŋayi-waṯaŋum ŋarruŋanan waripuḻin ŋayiḻi. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ga banha nhan walum galkiyin borumgum gulkthundawu, bala nhan banha ŋayi-waṯaŋuyum djuyꞌyuwanan nhanguway djämaminham, mä nhan ŋarru balayan ŋarruŋam borum-djägamiwuḻin warrawuḻ dhanal ŋarru nhangum borum mala-wulkthumana bewaḻiyam gätniŋurum. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ga dhanalim banha yolŋuyum warrayu nhäŋalan bala barkan warryuwan bala boyanan, bala ḏupthuwanan nhanany warraŋulḻin goŋ-waŋaranhan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ga biyapul nhan banha ŋayi-waṯaŋuyu djuyꞌyuwan waripunham djämaminy. Ga dhanalim banha borum-djägamiyum warrayu muḻkurrnha yakan djuḏulꞌyuwan maŋguꞌ-yuṯthumanan ga baya nhan djetji guḻkumiyin. Bala dhanal nhanany dhawaṯthumanan bewaḻiyam goŋ-waŋaran. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ga biyapul nhan banha djuyꞌyuwan waripunham djämaminy. Ga dhanalim banha boyan murrkayꞌyuman. Ga mä-waŋganynha yakan banha bilanyayam maḻŋꞌthuwan. Waripuny dhanal djämaminy boyan yana, ga waripunham dhanal boyan waŋayumanan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Yo, ga waŋganynha yakan banha yolŋum nyenan, gäthuꞌmiŋun nhanbal, ḏirramun, banha nhan yakan mariminan nhangu mä-ŋuwatjin. Ga bitjanan nhan banha mäḻuꞌmiŋuyum guyaŋin, ‘Banha ŋaya ŋarru gäthuꞌmiŋunham nyäkuway djuyꞌyun, dhanalim ŋarru banha nhangun gumurr-ŋuwatjim ga buthuru-witjunma.’ ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Bala nhan djuyꞌyuwanan nhanguway gäthuꞌmiŋunham balayan. Ga dhanalim banha borum-djägamiyum warrayu nhäŋal gäthuꞌmiŋunham bala dhanal wäŋanharaminan, ‘Wäy, yulparra, nhäŋa ŋatjil warra dhaŋu! Dhaŋum nhan gäthuꞌmiŋunhan mäḻuꞌmiŋuyum djuyꞌyuwan. Ga yalalaŋumim ŋarru banha mäḻuꞌmiŋum waŋayi, bala nhännha barkthu banha djinaŋun bukmakma nhä malany mäyaŋ nhanguŋum. Gu, ŋalma boyana waŋayumana nhangu gäthuꞌmiŋunham, mä ŋarru dhaŋu bukmakma nhäm mala ŋalmaliŋgun.’ ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Bala dhanal gathanan nhanany, ga boyanam dhanal nhanany murrkayꞌyumanan, waŋayumanan yana. Bala dhanal nhangu rumbalma ḏupthuwanan warraŋulḻin, ḏiltji-ḏuwaṯthumanan bayikuya banha ḻoḻuwum.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Bala nhan Djesuyum dhä-wirrkaꞌyuwanan banha ŋaḻapaḻminham bitjanan, “Nhalpiyana nhumam yaka guyaŋi? Nhalpiyana nhan ŋarru bayiŋuya ŋayi-waṯaŋuyum yolŋuyu guyaŋi ŋunha borum-djägaminham warrany? Banham nhan ŋarru ŋarruŋan yana bala boyana waŋayumana banha borum-djägaminham warrany. Bala nhan ŋarru banhayam ŋayi borummim guŋan waripuwuḻin yolŋuwuḻ warrawuḻ djägawu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ḻinygu mu nhuma dhaŋu marŋgimi banha God-Waŋarrwuḻim Djorraꞌŋa yaka bitjan dhäya, ‘Waŋganyma banha bäthu dhanal djämamiyum warrayu ḏupthuwanan, ḻinygu dhanal maḻiku rakaranan. Ŋarru banhayam bäthu ŋuwakurruꞌŋun walꞌŋu, ga banhayan nhan djalkirim. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ga God-Waŋarryun nhanbayim banha mäyanam bala manymak rakaranan. Ga marimin banha maŋutji-wiḏiꞌmin yulŋum!’ ” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ga dhanalim ŋaḻapaḻmiyum dharaŋganan yana banha nhan Djesuyum yakan dhanalinhan waywayyuwan bayiŋuyam dhäwuyu. Dhanalim banha bilanyan ŋaḻapaḻmim warra bitjan banha borum-djägamin warra. Ga mariminan dhanal banha ŋayaŋu-maḻikinam. Ga djälyinam dhanal yakan banha Djesuwum ŋayathandawun, dhanal ŋarru nhanany dharruŋguḻin dhethuŋgan. Ŋarru dhanal yakan banha yolŋuwun warrawu biyaṉiyinam, bala dhanal yana ŋarruŋanan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ga dhurrwaraŋuru bewaḻiyam Djuwwuḻ ŋurru-warryundayŋuyu ḻuŋꞌthuman yolŋuny warrany banha Baratjiny yolŋuny warrany ga Geŋ Yaritku ḻunduꞌmiŋuny warrany. Bala dhanal djuyꞌyuwanan banha yolŋunham warrany balan Djesuwun mayaliꞌ-wilkthundawun, mä nhan ŋarru be nhalpiyan maḻikuyuman wäŋa, mä dhanal ŋarru mari-ḏoyꞌyuna nhangu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bala dhanal wäŋanan nhangu Djesuwum bitjanan, “Marŋgikunharami, bukmak ŋanapu dhaŋu marŋgi nhuŋgum, banha nhunum bayiŋ yaka dhaŋu ŋuwakurru yana warkthun, ga wäŋa nhunu bayiŋ yaka yultha yana ga dhunupa. Ga dhunupa nhunu dhaŋu mala-djarryundami yolŋu, ḻinygu nhunu bayiŋ yolŋuwu yaka djäma rrambaŋiyuman bukmakku yana, ŋaḻapaḻmiwu ga yaka birrkamiwu. Ga God-Waŋarrwum dhäruk nhunu bayiŋ yaka yuwalk yana marŋgiyuman. Ŋanapu ŋäŋꞌthun nhuna ŋay... Nhä banha dhunupa ŋalmaliŋgu Djuwwum bäpurruwu ŋalma ŋarru yaka molum-rrupiya buku-ḏitjuman Rawumbuywum gapmangu yäku tax-ma, banha dhanal buŋgawan djinakun ŋayiwu ŋarakawu?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ga nhanmam banha Djesum marŋgiyin dhanaliŋgu ŋayaŋuwu. Ga banha nhan warri bitjarram wäŋarra, ‘Dhäwul dhuwanma ŋuwakurru, nhuma ŋarru wuŋiḻiꞌyun dhanaliny banha molu-rrupiya tax,’ bitjarram, ga nhanmam warri banha mariḻin gulŋiyarra Rawumanguḻin gapmanguḻ warrawuḻ. Ga banha nhan warri yorarram bitjarram, ‘Yuw, Gatjuynha wuŋiḻiꞌyuwan warra djinaŋuyam wawaṉḏayu,’ bitjarram. Ga banham nhan mariḻin dhethuŋganmin Djuwwuḻin yolŋuwuḻ warrawuḻ, ḻinygu dhäwulnha dhanal yakan ḏukṯukmiyin dhanal ŋarru yaka Rawumbuy buŋgawa warra dhanaliŋgu buŋgawayi. Bala nhan Djesum bitjanan wäŋan, “Yaka nhänany warra mayaḻiꞌ-wilkthuwa. Milkuwa wilak nyäkuḻ wawaṉḏa, ŋaya nhäma.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Bala dhanal guŋganan nhanguḻ Djesuwuḻ waŋgany ŋaraka. Ga nhäŋal nhan, bala wäŋanan bitjanan, “Yol dhaŋum wuŋiḻi ga ŋaykaṉa djinalaŋam wawaṉḏaŋa ŋarakaŋa?” Ga dhanalim buku-ganitjuman, “Dhuwanma wuŋiḻi nhännha Djetjan banha nhan buŋgawan Rawumbuywun Gapmangu!” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Bala nhan Djesum bitjanan wäŋan, “Gatjuy, ḏitjuman warra guŋa nhä malany nhangum bayikuyam Rawumbuywum gapmangu. Ga nhä malany banha nhangum God-Waŋarrwum bitjaya bili nhangum ḏitjuma guŋa.” Ga guḻkuyun banha ŋäkulam nhanany dhärukma ṉirrꞌyuwanan, linygu nhan dhanaliŋgu banha buku-ganitjumanam djambatjthun dhärukthum. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ga waripu miṯtji yolŋu warra yäku Djatutjiyu yakan yolŋuny warrany marŋgiyuman, be barkthu dhäwulnha yolŋum warra wälŋayi rakunyŋurum. Ga bilanyamiyum dhanal birrkaꞌyuwan mayaliꞌ-wilkthuwan Djesuny. Ga bitjan dhanal nhangu wäŋanam, ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Marŋgikunharami, bitjan ŋunha Mawtjitjthum wukirri God-Waŋarrwum rom: Banha ŋarru yolŋuyu dhäykany mäyam, ga waŋayi nhan ŋarru walkurnharra, bala nhanguru yukuyukuꞌmiŋuyun ŋarru banha dhäykanham mäyam. Ga yalalaŋumi dhupal ŋarru banha yothum maḻŋꞌthuman, nhangun bayikuyan waŋawun ḏirramuwu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ga nhämi dhaŋum gamꞌ? Guḻku dhanal yakan banha nyenanam, 7 wäwaꞌmanydjim warra. Ga nhän ŋatjil ŋaḻapaḻyu wäwaꞌmiŋuyu mäyanam banha dhäykanham bala waŋayinan, ga dhäwulnha nhan yothum nhanbal guyukan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Bewaḻim nhännha malpurayun mäyan banhayany dhäykany, yana bayiŋ romgun malthuwan. Ga waŋayin nhan banha ḏirramum yothunharra yana. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ga bitjanan ḻinygu yakan banha maḻŋꞌthuwanam bukmakkun yana dhanaliŋgu wäwaꞌmanydjiwum warrawu. Ga bukmak dhanal yakan banha romgum malthuwan, ga bukmakthu dhanal banha mäyanam banhaya dhäykanham. Ga bukmak yana dhanal banha waŋayinam yothunharran yana. Ga dhä-yurputjnha nhan dhäykam waŋayin. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ga djinakun ŋanapu ŋarru nhunany dhaŋu dhä-wirrkaꞌyunma, gamꞌ: Banha ŋarru God-Waŋarryu yolŋunham warrany wälŋayumu rakunyŋurum ŋunhalam djiwarrꞌŋam, ga banha barkthu banhaya wäwaꞌmanydjim warra ga banhaya dhäykam wälŋayi, ga yolkun nhan barkthu banha dhäykam, ḻinygu guḻkuꞌwura dhanaliŋguḻ nhan yakan banha nyenanam?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ga nhanmam Djesum wäŋan bitjanan, “Bukmak yana nhuma dhaŋu djarrpiꞌmi warra. Dhäwul yana nhuma dhaŋu God-Waŋarrwum dhärukku yultham marŋgi, ga dhäwul nhuma marŋgi nhanguru ganydjarrwu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Banha barkthu yolŋum warra wälŋayi rakunyŋurum, banhayam dhanal ŋarru bilanyan bitjan God-Waŋarrwun dhäwumin warra, djiwarrꞌwuynha yolŋu warra. Dhanalim barkthu banha dhäwulnha mäyanharami ŋunhalayam. Bukmakma yolŋu warra ŋunhalam djiwarrꞌŋam barkthu waŋganynha yana mala. Dhäwulnha barkthu banha yolŋum warra dhawuꞌ-nhinathuŋganmi dhäykany, ga biyapul mäyanharami. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Nhumam yaka dhaŋu bitjan guyaŋi yana warri ŋarru dhäwulnha yolŋum warra wälŋayi rakunyŋurum. Guyaŋiya warra banha dhäwu Mawtjitjkuŋ ŋunha God-Waŋarrwuḻ Dhuyuŋa Djorraꞌŋa: banha nhan nhäŋal dhaŋutha dharpaŋa, ga God-Waŋarr yakan wäŋan nhanguḻ bitjan, ‘Ŋayam dhaŋu God-Waŋarr dhanaliŋgu Yipurayimgu ga Yitjakku ga Djaykupku.’ ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Dhäwul nhan bitjan wäŋan banha nhan bilanyamiyu bili yana waluyu dhanaliŋgu God-Waŋarr. Banham nhan bitjanam wäŋan, ḻinygu nhan God-Waŋarr dhanaliŋgu djinakun bala waluwu, linygu dhanal banhayam yolŋu warra wälŋan yaka nyena God-Waŋarrwuḻin, dhäwulnha dhanal rakuny. Ḻinygu wälŋami yolŋu warra bayiŋ yaka banha God-Waŋarrwum buku-ŋalthun, dhäwul rakunymi. Werra nhumaliŋguŋ dhuwan guyaŋinyaram.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ga ŋunhalaya yakan nyenan waŋgany rom-marŋgikunharami yolŋu, mäkiriꞌ-witjuwan nhan yakan Djesuwu. Ga bitjan nhan banha guyaŋinam: banha nhan Djesuyum ŋuwakurrun yana dhanaliŋgu dhärukma buku-ḏitjuman Djatutjiwum warrawu. Bala nhan ŋäŋꞌthuwanan nhanany Djesunham bitjanan, “Nhä dhaŋu ŋurruŋum marimim walꞌŋu God-Waŋarrwum rom?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ga nhanmam Djesuyum buku-ganitjuman bitjanan, “Dhaŋu banha ŋurruŋum walꞌŋu rom ŋunha God-Waŋarrwuḻim djorraꞌyu yaka rakaram bitjan gamꞌ, ‘Ŋäkam warra ŋuwatjuma, nhumam Yitjuralpuyŋuyum yolŋuyu warrayu! God-Waŋarr yana dhaŋu nhanbay ŋurruŋum buŋgawa ŋalmaliŋgum, dhäwul yaka dhaŋu waripu yolŋu nyena bilanya bitjan nhän. Ga nhanguway yana ŋalma ŋarru yaka dhaŋu mäkiri-witjunma! ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ga mä-ŋuwatjim ŋarru yaka dhaŋu djinakum God-Waŋarrwu ŋuwatjuman yana, yaka bukuyu-djinꞌkayŋuyu. Ŋunhuŋun bala mä-ŋuwatjiyam nhangu djinawaꞌyun ŋayaŋuyum, ga bukmakthu yana nhuŋguḻ dhäkay-ŋanharayu, ga guyaŋinyarayu. Ga mä-ŋuwatjiya God-Waŋarrwum bukmakthu yana nhuŋguḻ ganydjarryum, bitjan nhunu bayiŋ ŋunhuŋ nhäwu mala ganydjarr-ḻawꞌyuman djämawu.’ ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ga dhaŋu nhan banha waripum rom bilanya bili bitjan ŋunha ŋurruŋu rom, dhaŋun gamꞌ: ‘Gatjuy, mä-ŋuwatjiyan ŋunha waripuwum yolŋuwu warrawu bitjaya bili bitjan nhunu bayiŋ ga nhuŋguway nhunu mä-ŋuwatji.’ Dhaŋun banha bulalꞌnha rom wulanynha biyapulma walꞌŋu ŋurruŋu.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Bala nhan banha rom-marŋgikunhamim yolŋu bitjanan wäŋan, “Yultha dhaŋuyam! God-Waŋarr yana dhaŋu nhanbay ŋalmaliŋgum ŋurruŋu buŋgawa. Dhunupa yana nhunu dhaŋu bitjanam wäŋan banha ‘Dhäwulnha dhaŋu bilaŋ waripum God-Waŋarr, ... nhanbayin yana waŋganynha, ga ḻinygun!’ ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Dhika ŋalma ŋarru yaka ŋuwatjuman nhangu God-Waŋarrwum mä-ŋuwatji, dhäwul buku-djinbumam. Yultha yana ŋalma ŋarru yaka nhanbal mä-ŋuwatji ŋunhuŋ bala djinawaꞌyu ŋalmaliŋguru ŋayaŋuyu. Ga bitjanaya ḻinygu ŋalma ŋarru nhangu mä-ŋuwatji dhäkay-ŋänharayum, ga guyaŋinyarayum, bitjan ŋalma bayiŋ ga warrꞌwarryun guyaŋi bilaŋ nhä mala. Ga bitjan nhangu mä-ŋuwatji ganydjarryum ŋalmaliŋguwaywuru bitjan bayiŋ ŋalma ganydjarr-ḻawꞌyuman ŋunhuŋ nhäwu djämawu. Ga bitjanaya ḻinygu ŋalma ŋarru banha waripuwum yolŋuwu mä-ŋuwatji, bitjan ŋalma bayiŋ nyin ŋalmaliŋguway mä-ŋuwatji. Dhuwaniyan banha rom wulanynha ŋurruŋum ŋalmaliŋgu. Yo, djuḻkthumana nhan yaka djinaŋum romdhu, dhaŋum banha waripunham romnha malany, banha nhä ŋalma bayiŋ yaka mundhurr-guŋan, wo biyarrthan bayiŋ wäyin mundhurr-guŋandawu.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ga banha nhan Djesuyu nhanany bilanyawuyma ŋäkul bala nhan djambatjthun dhärukthum wäŋan bayikuyam ḏirramuwu, ga bitjanan nhan buku-gänitjumanam, “Bilin nhunu dhaŋu dharaŋganan, dhaŋu nhunu yaka guyaꞌ-guyaŋin nhunu ŋarru God-Waŋarrnham buŋgawayumana nhuŋguwaywuru wälŋayum.” Ga dhäwulnha banha biyapulma bilaŋ yol yolŋu dhurrwara-wapthuwan wäŋan nhangu, ḻinygu dhäwulnha ŋarru banha bilaŋ yolthu nhanany dhärukma djuḻkthuman. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ga bilanyamiyum nhan yakan baḏak Djesuyum dhanaliny marŋgiyuman yolŋunham warrany ŋunhal God-Waŋarrwura Dharrpalŋa Buṉbuŋam. Ga bitjan nhan rakaranam, “Marŋgi mu nhuma dhaŋu banha Daybitma yakan nyenan be bamanꞌ ŋätjil, ga dhanalim yakan dhaŋu nhumaliŋgurum rom-marŋgikunhamiyu rakaran, be warri banha God-Waŋarrwum Maŋutji-dhunupayumanda barkthu maḻŋꞌthu nhanguran Daybitkuran yarraṯaŋuru be nhäꞌmiŋu, nhanguran ŋarru yarraṯaŋa maḻŋꞌthu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Yo, ŋätjil nhan banha God-Waŋarrwuḻ Dhuyu Birrimbirryu dhäruk-guŋan Daybitkuḻ dhäwuꞌwu wukirriwu bitjan: ‘God-Waŋarr wäŋan nyäkuḻim buŋgawawuḻ bitjanan, “Gu rälin ŋarrya, ga djinalan nyiniyam nyäkuran dhunupaꞌŋuŋan galiꞌŋam, mä nhunun ŋarru banha galkim nyäkuram, ga baya ŋaya ŋarru miriŋuny nhuŋgu dhuṉuwapthuman, bala nhunu ŋarru yaka ṉuku-goyuman dhanaliŋguḻ.’ ” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_37a","071_12_37a","MRK","12","37a","37a","Ga nhananhan banha yakan Maŋutji-dhunupayumandanhan yolŋuny nhan Geŋ Daybithum buŋgawa rakaranan. Ga nhäwun nhan banha be Daybitkuram yarraṯaŋa buŋgawaꞌmiŋu nhangum Daybitkum?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_37b","071_12_37b","MRK","12","37b","37b","Ga guḻkuyu yakan banha yolŋuyum warrayu ŋäkul nhanany Djesunham dhärukma, ga mä-ŋuwatjin dhanal banha nhangu marimin dhika. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ga baḏak nhan yakan banha Djesuyum marŋgiyuman yolŋunham warrany, bala nhan bitjanan wäŋanam, “Wäy, djäga warra ŋay, ŋunhukum banha rom-marŋgikunhamiwum warrawu! Dhaŋum dhanal bayiŋ yaka yindikunharamin. Ga banha dhanal bayiŋ doꞌḻim ŋarruŋa, ga girrimꞌ dhanal bayiŋ yaka guyukam wikarran be marimin, mä ŋarru yolŋuyum warrayu nhämam dhanaliny bala wokthuna dhanaliŋgu, ga bitjana wäŋa, ‘Yo, nhämi way yolŋu,’ bitjana. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ga banha dhanal bayiŋ biryamiḻim buṉbuḻi ŋarruŋa buku-ŋalthundawum, wo ŋathamiḻim ŋayiḻi, dhanalim bayiŋ ŋuwakurruwun yana nyenanhamiwum rangam, mä ŋarru yaka yolŋuyu warrayu nhäma dhanaliny balaya. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ŋarru dhanal bayiŋ yaka banha bawaꞌ-guŋan ŋunha buku-gurthawuynham dhäykany warrany bala yaka manaŋin buṉbun mala dhanaliŋgu. Ga bewaḻiyam dhurrwaraŋuru bala dhanal bayiŋ ŋarruŋan balan biryamiḻin buṉbuḻi bala nyin bukumiŋgana, djakaꞌ-wikarra be, mä ŋarru yolŋuyum warrayu dhanaliny ŋuwakurru-rakaraman. Ŋarru nhanmam God-Waŋarryum barkthu banha dhanaliny marimin yana dhä-girꞌyum maḻikuwuyma.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ga bewaḻiyam nhan yakan banha Djesum gumurrma nyenan balan ḻinygu banha ŋalaŋa yakan banikinꞌ rrupiyawuy dhäyan ŋunhal banha God-Waŋarrwuḻ Dharrpalŋa Buṉbuŋa. Ga nhäŋal nhan yakan banha yolŋuny warrany waripuny ga waripuny dhanal ŋarruŋan rrupiya malany rarrꞌyuwan balaya rupaꞌḻi. Ga ṉukunydjaꞌyu yolŋuyu warrayu ŋarruŋan rarrꞌyuwan yinḏimi rrupiya. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ga bulum banha gurrupuruŋun buku-gurthawuynha dhäyka ḏoyꞌyuwan, ga gunyanam nhan banha bulalꞌnha yutjuwaḻan marimin ŋaraka rrupiya, dhäwulnha yindi. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Bala nhan Djesum gawawꞌyuwanan nhangu malthundamiwum warrawu bitjanan, “Dhaŋum ŋaya ŋarru dhunupa yana nhumaliŋgu rakaram: Djinaŋum dhäykayu guŋan warrpamꞌthuwanan, djuḻkthumana yaka ṉukunydjaꞌwuŋum mundhurr-guŋanda. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Djinaŋum ṉukunydjaꞌyu yolŋuyu warrayu guyaŋin yana warri dhanal guḻku gunyan. Ga ŋunha ŋayiŋam dhanaliŋgu ŋarruŋ guḻku yana rrupiya ŋalthunmi. Ga nhanmam djinaŋum dhäykayu warrpamꞌthuwanan guŋan, dhäwulnha nhän bilaŋ dhurpuꞌyuman rrupiya nhanguwayma nhan ŋathawu.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Bala nhan Djesum ga malthundamim warra nhanbal dhawayawaṯthuwanan beŋurum banha God-Waŋarrwuḻim Dharrpalꞌŋam Buṉbuŋa. Bala nhan waŋganyma yolŋu wäŋan bitjanan, “Wäy Marŋgikunharami, nhäŋa ŋatjil dhaŋu yaꞌ, dhaŋum latjunꞌ buṉbu ŋatja? Nhän dhaŋum bäthu malany yinḏimin marimin, ŋatja?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ga nhanmam Djesum wäŋan bitjanan, “Dhaŋu nhuma yaka nhäma latjuꞌ buṉbu, dhaŋum barkthu bakthun. Ga dhäwulnha ŋarru gi banha biyapulma djinal dhäyi. Bala ŋarru yaka dhaŋu bäthum mala ŋoya bakthundan.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Bala dhanal banha Djesum ga malthundamim warra nhanbal ŋarruŋanan balan bukuḻin yäkuḻi Wolipḻin banha dhupal yakan nhänharamin God-Waŋarrwu Dharrpal Buṉbu, ga banhalayan dhanal yakan nyenanam. Bala dhanal banha ḻurrkunꞌma malthundami warra yäku Betam ga Djayimma ga Djonma ga Wandurum ŋarruŋanan guwatjmanan Djesunhan bala dhanal dhä-wirrkaꞌyuwanan, ");
INSERT INTO dhgduwadha_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Marrkapmi, ŋatjil ŋanapiliŋgu rakaraŋ dhunupayuma, nhä nhunu yakan banha rakaranam. Nhätha ŋarru banha yolŋuyum bakthumu dhaŋum buṉbuny, ga nhaliyu ŋanapu ŋarru marŋgiyim?” bitjan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ga nhanmam Djesum wäŋan, “Djäga warra ŋarrya yulŋum, mä nhumaliny ŋarru dhäwul mu yolŋuyum mayaliꞌ-wilkthu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Guḻkun ŋarru banha yolŋum warra ḏoyꞌyu, ga bitjun waŋatji, ‘Ŋaya dhaŋu Maŋutji-dhunupayumandam,’ ga guḻkunhan dhanal barkthu banha yolŋunham warrany mayaliꞌ-wilkthun. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ga mariwuyma nhuma barkthu banha ganydjarrma ŋäku. Ga waripu yolŋu warra barkthu ḏoyꞌyu bala ŋarruŋay dhäwu-golanharamin waripuwuynha mariwuy. Ŋarru nhumam dhäwulnha ŋoy-buṉakiya bayiŋuyam mala dhäwuyu, ŋay? Mariwuyma nhuma ŋarru dhäwu ŋäku yana, bäymaŋuḻi ga bärrkuḻi, ŋarru banhayam dhäwul yana dhä-dhawarꞌyundamim walu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Guḻku ga guḻku barkthu banha marim malany gamurruꞌ-dhawaṯthu. Yolŋu warra waŋgany bäpurrum barkthu mari-ḏoyꞌyun waripuŋuwun bäpurruwu. Ga waŋganybuyma ŋarakawuy ŋayiwuy barkthu mari-ḏoyꞌyu waripuŋuḻin ŋayiḻi. Bala barkthu banha ŋayim dhaŋum nhanbayim marrmarryun, ṉiṉḏa-warrꞌwarryun. Ga ŋatham barkthu banha dhawarꞌyun wiyiŋumiwun waluwu, ga yolŋum warra ŋarru banha marimin djaṉŋarryim. Ga ŋurruŋum ŋarru banha dhuwaniyan mala mari maḻŋꞌthu, ga bulum barkthu banha yinḏin marimin mari maḻŋꞌthu. Bitju nhan barkthu banha maḻŋꞌthum gamꞌ: Bitjan bayiŋ dhäykayu ŋurruyirrꞌyuna ŋämaꞌŋaman rerrin yothuwun dhäwal-guyaŋinyarawun. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Djägan warra nhumaliŋguway yulŋum, mä nhumaliny ŋarru yaka mu yolŋuyum warrayu bawaꞌ-wikaŋ. Yolŋum warra nhumaliŋgu ŋarru ŋurru-bilꞌpilyun bili nhumam bayiŋ yaka banha nyäku malthun. Ga ŋayathu dhanal barkthu nhumaliny bala ḏupthun dhä-wirrkaꞌyandawun, bala ŋarru bartjumun nhumaliny ŋunhalam biryamiŋam buṉbuŋa. Ga dhäyanhamiŋgun dhanal barkthu nhumaliny ṉapuŋgaḻin yana gumurrḻin buŋgawawuḻin warrawuḻ ga gapmanguḻin yolŋuwuḻ warrawul. Ga bilanyamiyum nhunum barkthu banha nhänanham rakaraŋun yolŋuwuḻin warrawuḻ, ");
INSERT INTO dhgduwadha_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","mä ŋarru banha bukmakthun bäpurruꞌyum ŋäku dhäwum nyäkuruwuy. Yo, ŋurruŋum ŋarru banha bukmakthum bäpurruyu dhäwu ŋätjil ŋuwakurru ŋäku, ga ŋärrun barkthu banha walum dhä-dhawarꞌyu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Yo, yolŋuyum warrayu nhumaliny barkthu banha mataꞌyumun bala bangalaŋ nhumaliny dhä-wirrkaꞌyundawun, ŋarru nhumam ŋarru dhäwul yana warwuyun nhalpiyan nhuma ŋarru wäŋa. Nhännha ŋarru banha Dhuyu-Birrimbirryun nhumalinham dhäruk-guŋan wäŋanharawum. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ga bayiŋ ŋarru banha yolŋu mä-yuwalkmiyi nyäkum, yolŋuyum gurruṯumiyum warrayu ŋarru nhanany boyun waŋayumun yana. Wäwaꞌmanydjim ŋarru boyanmi waŋayinyarawun. Ga mäḻuꞌmiŋuyum ŋarru waŋayumun boyu nhanguwayma walkurnha warrany. Ga yumurrkumꞌ ŋarru banha ŋapa-bilyun ŋäṉḏiꞌmiŋuwum ga mäḻuꞌmiŋuwum, yolŋunhan ŋarru dhupaliŋgu dharrwunuŋ. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ga guḻkun yolŋum warra nhumaliŋgu barkthu ŋaramurryim, ḻinygu nhuma bayiŋ yaka nyäku malthun. Ga banha nhunu ŋarru yaka wanyum yana dhäya ga dhäwulma nhunu ŋarru mä-djawaryun, nhanmam ŋarru God-Waŋarryum nhunany wälŋayumana.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ga baḏak nhan yakan banha Djesum wäŋan bitjan, “Dhikam barkthu maḻikun marimin maḻŋꞌthu. Ga dhäyim nhan barkthu banhayam God-Waŋarrwuran Dharrpalŋan Buṉbuŋam ŋunhal Djurutjalamnha, maḻikuyumun barkthu banhayan ŋayiny, banha dhäwulnha warri yultham bitjarra maḻŋꞌthuwarra. Ŋarru, girriꞌ-ŋuwatjiyan ki nyiniyam,” bitjan. (Ga bayiŋ nhunu yaka nhäma dhaŋu dhäwuny, marŋgiyiyan yana ga yuwalknha dharaŋgam, ga bitja bili nhunum girriꞌ-ŋuwatjiya nyiniya.) Ga baḏak nhan nyin banha Djesum wäŋan bitjan, “Banha nhuma ŋarru bilanyawuyma nhäŋu, banham dhä-dhawarꞌyundamim walu galŋaꞌkalŋan yana. Ga banha nhumam ŋarru Djudiyawuyyum yolŋuyu warrayu bilanyawuyma nhäŋu, ṉakaman bala yuṯthuwan ŋunha bukuꞌpukumiḻin ŋayiḻi. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ga banha nhunu yaka warraŋulma nhuŋguwaywuḻ buṉbuŋa ŋarruꞌŋarruŋa, dhäwulnha yuṯthuwa ḏitjuwa djinawaꞌḻim buṉbuḻi be nhäwum ŋolkaŋ. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ga banha nhunu yaka ḏiltjiŋam nyena, dhäwulnha yuṯthuwa nhuŋguwaywuḻ buṉbuḻim girriꞌwum nhuŋguwaywuru, yuṯthuwan bala ganydjarryun. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ga gumurr-wanyun barkthu banha marimin galŋa-ŋonuŋmiwum ga yothu-yalŋgimiwum dhäykawu warrawu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Bukumiŋgan God-Waŋarrwuḻim, mä ŋarru banha gumurr-wanyum rom maḻŋꞌthu bilanyamiyu waluyu, banha nhan gumurr-yalŋgin yuṯthundawum nhawun yolŋuwum. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ga djinaŋum mariyu ŋarru yolŋum warra galŋam-marimin dhaŋga-ḏirryum, maḻikuyin ŋarru. Bewaḻi ḻinygu banha nhan God-Waŋarryu ŋurruŋu ŋurruyirrꞌyuwan dhaŋu ŋayi, bilanymiyu yakan banha yolŋum warra ŋurruyirrꞌyuwanam dhaŋga-ḏirryuwan. Ŋarru djinaŋum mariyu barkthu banha yolŋum warra marimin galŋam-maḻiki. Ga yalalam dhäwulnha nhan ŋarru banha biyapulma bilanya gumurr-wanyu maḻŋꞌthu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ga banha nhan ŋarru God-Waŋarryu dhäwulma banhaya mariny gulyumu, nhanmam ŋarru yolŋum warra warrpamꞌnha yana murrmurryu. Ŋarru God-Waŋarryum banha ḻinygun nhanguwayma yolŋuny warrany gänaŋꞌthumanan, ga dhäwulnha nhan ŋarru nhäma dhanaliny waŋayinyaḻim, bala nhan ŋarru banha marim guṯikuman, mä dhanal ŋarru wälŋayi. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ga banha barkthu yolŋu bitjum waŋatji, ‘Dhaŋun ŋanapu ḻinygun maḻŋꞌthumanan banha Maŋutji-dhunupayumandanham yolŋuny, dhaŋun nhan yulŋum.’ Nhumam dhäwulnha mä-yuwalktjiya. Ga banha dhanal ŋarru bitjanma wäŋa, ‘Ŋunhan bala nhan, ya ŋunhan,’ dhäwul yana mä-yuwalktjiya. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Guḻkuyu barkthu banha yolŋuyum warrayu rakaraŋ bitjun, “Ŋaya dhaŋu God-Waŋarrwuŋum Maŋutji-dhunupayumanda yolŋu.” Ga waripum ŋarru bitju waŋatji, “Ŋaya dhaŋu djawarrkmim yolŋu,” ŋarru yultham dhanal barkthu nhumaliny mayaliꞌ-wilkthu, ga bitju mu dhanal barkthu banha ŋayaŋu-ganyimꞌthundamim rom malany warkthu. Ga bitju dhanal barkthu banha guyaŋim, ‘Gu, ŋalma bawa-guŋan dhaŋu God-Waŋarrwu mala-djarrꞌyundany yolŋuny warrany.’ Ŋarru gulkurun dhanal barkthu banha bitjum warkthu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Gatjuy djägan warra! Dhaŋum ŋaya yaka rakaraman nhumaliŋgu yulŋum, mä ŋarru banhayam walu ḏoyꞌyu, nhumam ŋarru yaka girriꞌ-ŋuwatjin nyena bayikuyam.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ga bulum nhan Djesuyu bitjanan rakaran, “Ga dhurrwaraŋuru banha yindiŋurum mariŋuru, ‘walum ŋarru warumuktjan, ga ŋaḻindim ŋarru dhäwulnha bulum djarraṯawunmiyi. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ga ganyum mala barkthu ḻarryun djiwarrꞌŋurum, ga nhä mala ganydjarr bilaŋ nhäwu malaŋuwu ŋunha djiwarrꞌŋam ŋarru rurrꞌrurryun.’ ");
INSERT INTO dhgduwadha_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ga bewaḻiyam barkthu banha yolŋuyum warrayu nhäŋun nhänanham banha Yuwalknham Walꞌŋu Yolŋuny. Ga yarrupthum ŋaya barkthu djiwarrꞌŋurum rälim waŋupiniꞌyun. Ga guḻkuyun yolŋuyum ŋarru banha nhäŋum nhänany djeŋarraꞌyakaynha dhikan, bäyman galumanyaŋnha, ganydjarrmin. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Bala ŋaya ŋarru djuyꞌyuna God-Waŋarrwum djiwarrꞌpuynham dhäwuminy yolŋuny warrany, dhanal ŋarru ḻuŋꞌthumana nyäkum mala-djarrꞌyundanham yolŋuny warrany dhaŋu buku-ḻiwꞌyuman yaka nyena, beŋuru dhimurruŋuru ga ḏupthun bärraꞌḻi ga dhawuru bala ḻuŋgurrmaŋuru ga yanatj ḻinygu-u-u ga djalathaŋ wapthun.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ga baḏak nhan yakan banha Djesum wäŋan bitjan, “Banha nhuma bayiŋ nhäma marwatma dharpany galadarꞌyundam, bala nhuma bayiŋ marŋgiyin banha dharratharramim walu galkin, ");
INSERT INTO dhgduwadha_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Yo, banha nhuma ŋarru bilanyawuyma nhäma, bayiŋuyam yaka banha gumurr-wanyuyum romdhu maŋutji-rakaram nyäku ḏoyꞌyundamim walu galkin. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Dhaŋum ŋaya ŋarru dhunupa yana nhumaliŋgu rakaram! Dhawuru ŋurrukŋuru, dhaŋu nhuma yaka dhäyaꞌthaya, waripum nhuma barkthu banha wälŋa yana nyenay, ga nhäŋu yana nhuma barkthu bilanya gumurr-wanyum rom malŋꞌthunda. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Yo! Nhä mala bukmakma ŋarru dhawarꞌyun, ŋunha djiwarrꞌ ŋayi ga dhaŋu munathaꞌ ŋayi ŋarru dhawarꞌyuna. Ŋarru dhärukma nyäku ŋarru banha dhäwulnha dhawarꞌyu, banhayam ŋarru yaka dhäyan yana wiyinŋumin, dhawarꞌyundanharran.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ga biyapul nhan Djesu wäŋan bitjan, “Dhäwul dhaŋu waŋgany yolŋu marŋgi nyäkum waluwu ḏitjundawu. Ŋunha God-Waŋarrwu djiwarrꞌwuy dhäwumi yolŋu warra dhäwul marŋgimi. Ga ŋayapim dhaŋu dhäwul yana marŋgi. Nhanbayin yana dhaŋu mäḻuꞌmiŋun nyäku marŋgim, ga ḻinygun. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Gatjuy, gaḏamandjiya warra gi nyinayim, ḻinygu nhuma dhaŋu dhäwul marŋgi bayikuyam banha waluwu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Dhaŋu ŋaya ŋarru dhäwu nhumaliŋgu rakaram mayaliꞌmi: Waŋganydhum waluyu ŋayi-waṯaŋuyu yolŋuyu ganan nhanguway ŋayiny bala ŋarruŋanan bärrkuḻin ŋayiḻi. Ga wäŋan nhan nhanguway djämaminy warrany, dhanal ŋarru yaka djäma yulŋum, ga djäga nhanbal nhäwum malanyŋuwu ŋuwatjuman yana. Ga wäŋan nhan dhurrwara-djägaminham warrany dhanal ŋarru yaka dhuka-nhäma yana, ga gumurr-ḏitjun nhan ŋarru. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ga bayaŋun dhanal banha marŋgim nhaliyu waluyu nhan ŋarru banha gumurr-ḏitjun. Wilak nhan ŋarru walu gulŋiyinyarayu ḏoyꞌyun nhä wilak gandarryu munhayu, nhä wilak munhakumi. Yo, yulparra, nhumam dhaŋu bilanyayan bitjan banha djämamin yolŋu warra, ga bayaŋun nhuma dhaŋu marŋgi nhätha ŋaya ŋarru ḏitju räli. Gatjuy, nhumam ŋarrya girriꞌ-ŋuwatjiyan yulŋum. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Dhuka-nhäŋan warra nyiniyam, bitjan banha yolŋu dhurrwara-djägami yaka dhäya dhuka-nhäma nyin yana, mä nhan ŋarru dhäwul nhuna maḻŋꞌthuman wawuŋuḻim. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Dhaŋu ŋaya ŋarru wäŋan nhumaliny, ga guḻkuny yolŋuny warrany, ‘Gatjuy djägam warra ŋuwatjuman, dhuka-nhänharayun.’ ” Yo, djinalan nhan dhäwum banha Djesuyum gunyan, banha nhan yakan rakaran nhanguwaywu malthundamiwu warrawu ŋunhalaya bukuŋa yäkuŋa Wolip. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","2","Yo, bala dhanal ŋurruŋu-djirrikaymim yolŋu warra ga rom-marŋgikunhamim warra ḻuŋꞌthuwanan, bala yakan wäŋanharaminan nhalpiyan dhanal ŋarru Djesuny ŋayathan, ŋarru gayul, ḻinygu dhanal yakan marimin banha djälmiyin dhanal ŋarru waŋayumana nhanany. Bala dhanal bitjanan wäŋanam, “Wäy, gäḻkulam ŋalma ŋay, ḻinygu rom ŋalmaliŋgu yaka dhaŋu yindi ŋarruŋa. Dhanal bayiŋ yolŋun warra ŋalmaliŋgu mari-ḏoyꞌyu, ḻinygu dhanal nhangu dhaŋu Djesuwum djälnha marimin.” Ga banha dhanal bitjanam wäŋan ḻinygu banha bulalꞌnha yana walum bala banhayam ŋarru rom ŋurruyirrꞌyuna banha Räy-djuḻkthumandamim Walu, ga waripu rom yäku Ḏambanharra Ŋatha. Ga bayiŋuyam waluyu dhanal bayiŋ guyaŋiyarra dhanaliŋguway ŋaḻapaḻminy, gurruṯuminy warrany, banha dhanal ŋarruŋan, ganan ŋayiny yäkuny Yetjipnha. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ga nhanman yakan banha Djesum nyenan ŋunhalan ŋayiŋa yäkuŋa Bithanin, ŋatha yakan ṉokan Djäymangura ŋayiŋa. Ga ŋätjilim nhan yakan banha Djäymanma nyenan rerrimi, burrundhiyaꞌyu yakan buṉakin. Ŋarru nhan banha ḻinygun ŋuwakurrun. Ga yaka wikarram bala dhäykan banhambal gulŋiyan goŋ-muṉuŋgarriꞌmin, ŋarru bäthu banha yulŋum. Ga guyukanan nhan yakan buŋgan-bäw, ga buŋganma banha ŋuwakurrun dhika marimin, ŋarru rrupiya yindimin. Ga ḻapthuman nhan banha muḻkurr muṉuŋgarrim, bala rarryuwanan buŋgan-bäwꞌma Djesuwuḻin muḻkurrḻi. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ga dhanalim banha yolŋuyum warrayu nhanany dhaykuwanan bitjanan, “Wäy! Nhäwu nhunu dhaŋu buŋgan-bäwꞌma djalkthuwan? ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Bilaŋ warri nhunu dhaŋu djalimnha rrupiyawun yindiwun, ga rrupiyam nhunu warri banha guŋarra ŋunha ŋurruwuykkun yolŋuwu warrawu.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Bala nhan Djesum wäŋanan dhanaliŋgu bitjanan, “Ganaka warra nhanany. Yaka warra nhangu mari-ḏoyꞌyuwa. Dhaŋum nhan ŋuwakurrun warkthuwan nyäku. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ŋunham banha ŋurruwuykma yolŋu warra ŋarru yaka nyena nhumaliŋguḻ djinal bitju bili, ga bilanyamiyun nhuma barkthu dhanaliny banha guŋgaꞌyum. Ŋarru ŋayam ŋarru dhaŋu nhumaliŋguḻ dhäwulnha wikarra nyena, guṯin nyäkum walu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Dhaŋum ŋaya barkthu waŋayin bala dhanal ŋarru nyäku rumbalma märrkitjkuŋun. Ga djinaŋum banha dhäykayu rarryuwan nyäkuḻ dhaŋum buŋgan-bäwꞌma, banhayam nhan bitjan ŋätjilmiŋganan nyäku rumbalnha. Ga ŋuwakurrun nhan dhaŋu marimin yulŋum bitjanam warkthuwan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ŋäka warra nhänany. Dhaŋum ŋaya ŋarru nhumaliŋgu yulthan yana rakaram. Banha barkthu ŋarruŋay yolŋum warra dhaŋu dhäwum rakaranhami buku-ḻiwꞌyumum, ga ŋäku yana dhanal barkthu djinakuruy dhäykawuyma dhäwu, banha nhä nhan nyäku warkthuwan ŋuwakurru gäthura. Ga guḻkun ŋarru banha yolŋum warra nhangu marŋgiyi.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ga dhurrwaraŋuru bewaḻiyam nhanmam banha waŋganyma yolŋu yäku Djudatj-Gariyatma bewaḻiyam malaŋa banha 12-kurum malthundamiŋuru ŋarruŋanan. Yo, ŋarruŋanam nhan banha guwatjmanam banhayanhan banha ŋurruŋu-djirrikayminhan warrany, mä nhännha ŋarru dhanaliny guŋgaꞌyunma ŋarambiya-guŋanma Djesunham dhanaliŋguḻ. Ga rakaran nhan dhanaliŋguḻ nhanguway ŋayaŋum. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ga banha dhanal ŋaḻapaḻmiyum warra ŋäkulam bala dhanal ŋoy-ŋuwatjinan. Bala dhanal dhawuꞌ-nhinathuŋganan nhanany bitjanan, “Bayiŋ nhunu ŋarru Djesuny ŋanapiliŋguḻ ŋarambiyaꞌ-guŋanma, ŋanapum ŋarru nhuna wuŋiḻiꞌyuna bayikuwuyma.” Bala nhan Djudatjma ŋarruŋanan, bala yakan dhukawun rangan nhalpiyan nhan ŋarru Djesuny dhanaliŋguḻ guŋan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ga bitjan ḻinygu dhuŋgarra ŋupan banha ŋurruyirrꞌyundamiyu waluyu Djuwwuḻ romŋa, dhanal bayiŋ dämba ŋomarra bayikuya romgu yäkuwu Ḏambanharrawu Ŋathawu, ga ḻiyun dhanal bayiŋ bimbiny romgu yäkuwu Räy-djuḻkthumandamiwu Waluwu. Manymak, ga bilanyayu bili yana waluyu, dhanalim banha malthundamiyum warrayu wäŋanan nhanany Djesunham bitjanan, “Ŋalaŋa ŋayiŋam ŋanapu ŋarru ŋatham banha Räy-djulkthumandamim ŋätjilmiŋgan?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Bala nhan Djesum wäŋanan nhanguway malthundaminham wulanynha bitjanan, “Gatjuy ŋarryan wulay balan Djurutjalamḻin. Ga banha nhuma ŋarru ḏoyꞌyunma bala nhuma ŋarru nhämam ḏirramunhan nhan ŋarru yaka ḻambarryu guyukam banikinꞌmi gapu. Ga malthuwa wulay nhangu, ga gulŋiya nhan ŋarru buṉbuḻim, ga nhumam ŋarru malthun yana nhangu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ga ŋunhalam djinawamꞌ nhuma ŋarru wäŋan buŋgawanhan bayikuya buṉbuwum, ga bitjan nhuma ŋarru nhangu rakaramam gamꞌ, ‘Wäy, ŋunha Marŋgikunharami ŋäŋꞌthuwan ŋalaŋa ŋalinyu ŋarru Räy-djuḻkthumandamim ŋatha ŋamaŋamayun, mä ŋarru ŋanapu ṉoka, nhanbay ga ŋanapu nhanguru malthundamiyu warrayu.’ ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Bala nhan bayiŋuya buŋgawayum maŋutji-wuŋanan ŋunhan banha garramatnha balaꞌpala, ḻinygun dhäyan yaka, bäkiwun ŋalmaliŋgu, ga ŋunhalayan nhuma ŋarru banha ŋatham ŋalmaliŋgu ŋamaŋamayun.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Bala dhupal banha malthundamim wulay ŋarruŋanan. Ga banha dhupal Djurutjalamma ḏoyꞌyuwan, ga maḻŋꞌthumanam dhupal banhaya ḻinygu banha nhalpiyan nhan yakan Djesuyu dhupaliŋguḻ rakaran. Ga ŋunhalayan dhupal banha Räy-djulkthumandamim ŋatha ŋamaŋamayuwan. Ga goŋ-dhawarꞌyuwan dhupal, bala ḏitjuwanan Djesuwuḻin. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ga banha ŋarruŋan walum gulŋiyan, bala nhan Djesum ga malthundamim warra nhangu banha 12-ma ŋarruŋanan balayan ŋayiḻi. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ga banha dhanal ŋarruŋan ŋatham ṉokan, bala nhan Djesum wäŋanan dhanaliŋgu bitjanan, “Yultha yana ŋaya ŋarru dhaŋum nhumaliŋgu rakaram. Dhaŋu gayꞌ djinalaŋa malaŋa ŋatha ŋalma ŋarruŋ ṉoka rrambaŋi, waŋganyma yolŋu ŋarru mulkuruyin nyäku,” bitjan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Bala dhanalim banha malthundamim warra nhangu galŋa-maḻikinan bayiŋuyam dhärukthum nhanguḻ. Bala dhanal ŋarruŋan dhä-wirrkaꞌyuwanan nhanany bitjanan, “Wäy, ... yolthu way, ... ŋaya ŋatja, Marrkapmi?” bitjanan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Bala nhan Djesum bitjanan wäŋan, “Waŋganydhum yaka djinal malaŋa ŋathan ḻupthuman banikinꞌḻin, ŋalinyun rrambaŋin, banhayan yolŋu ŋarru nyäku mulkuruyim. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Guyaŋiya warra, ŋayam dhaŋu Yuwalkŋum Walꞌŋu Yolŋu waŋayin ŋarru, bitjan yana bili bitjan ŋunha yaka God-Waŋarrwura Dharrpalŋa Djorraꞌŋa wukirriwuy dhäya. Ga yindin marimin ŋarru banha bayikuyam gumurr-golanharamiwum yolŋuwu mari maḻŋꞌthu. Ga manymakma nhangu nhan warri dhäwul dhawal-wuyaŋiyarra.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ga baḏak dhanal yakan banha ṉokan ŋatham, bala nhan Djesuyum dämban mäyan ga buku-wikan God-Waŋarrnhan bayikuya. Ga bakthuman nhan, bala ŋarruŋan guŋanan dhanaliny. Ga wäŋan nhan bitjan, “Dhaŋum dämba nyäkun rumbal. Maꞌ mäyaŋan bala nyaŋthuwan.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ga bitjanya bili nhan mäyan wiyikaꞌ banikinꞌmi ga buku-wikan nhan God-Waŋarrnha, bala nhan guŋanan banha wiyikamꞌ ŋunha malthundamiwuḻin warrawuḻ wurkthundawun. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Bala nhan bitjanan wäŋan, “Dhaŋum borum wiyikaꞌ nyäku maŋgunꞌ, banha barkthu djalkthunmin guḻkuwun yolŋuwum wälŋakunharawun. Ga ŋätjil nhan banha God-Waŋarryu warkthuwan gumurrkunhaminyawuyma rom wälŋakunharawu guḻkuwum yolŋuwu. Djinaŋun banha maŋguꞌyun nyäkuḻ ŋarru romnham ŋarruŋanhamiŋgana, maḻŋꞌthuna ŋarru yuwalktjin. Maꞌ, mäyaŋan bala wurkthuwan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ga dhaŋun gamꞌ, dhäwulnha ŋaya barkthu biyapulma borum wiyikaꞌ wurkthu, ga baya ŋalinyu ŋarru rrambaŋin nyenay ŋunhalan djiwarrꞌŋan God-Waŋarrwuran romŋa.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ga dhurrwaraŋuru bewaḻiyam bala dhanal manikaynha miyaman God-Waŋarrwuḻin. Bala dhanal ŋarruŋanan balan bukuḻin yäkuḻi Wolipḻin. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ga banha dhanal yakan ŋarruŋanam bala, bala nhan Djesuyum rakaranan ŋätjilmiŋganan bitjanan, “Yalŋuwam banha munhakum nhuma ŋarru dhaŋum warra yuṯthuna nyäkura, ganana nhänany. Yo, ŋätjil mu yana banha waŋganydhu yolŋuyu dhäwum banha wukirri Dhuyuḻim Djorraꞌḻi bitjanam gamꞌ, ‘God-Waŋarryum ŋarru boyana waŋgayumana banha wäyin-djägaminham, bala nhangu ŋarru bimbim mala ḻatjuwarrꞌyun.’ ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ŋayam ŋarru waŋayin. Ŋarru ŋaya barkthu biyapul wälŋayi bala ŋurruŋu-djuḻkthun nhumaliŋgum, ga ŋunhalan ŋaya ŋarru nhumaliŋgu gäḻkuḻamam Galaliŋan makaŋa. Yo, ŋunhalayan nhuma barkthu nhänany nhäŋum.’ ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ga nhanmam Betam wäŋan bitjanan, “Ŋayam ŋarru nhuna dhäwul ganan, marrkapmi. Bayatj ŋarru banha dhaŋum warra ḻatjuwarrꞌyu, ŋarru ŋayam dhäwul.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ga nhanmam Djesum wäŋan bitjanan, “Ŋäka nhäna ŋuwatjuma Beta. Djinaŋum bala munhaku, yalalam nhunu ŋarru nyäku dhä-bayaŋuꞌyuna ŋarru ḏämbu-ḻurrkunꞌmin, ga ŋärrun nhan ŋarru banha wäyinma guḻawurrma ŋätji bulalꞌmim.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ga nhanmam Betam buku-ḏuwatthuwan wäŋan bitjan, “Dhäwul dhaŋu ŋayam ŋarru nhuŋu mä-dhumbalꞌyun, baya banha ŋaya ŋarru waŋayim!” Ga dhanalim banha waripum ḻunduꞌmiŋu warra ga bitjanaya bili wäŋan dharaŋanda yana dhäruk. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ga banha dhanal Djesum ga malthundamim warra nhangu ḏoyꞌyuwanam banhalayam ŋayiŋa yäkuŋa Githtjamanim, bala nhan Djesum wäŋanan, “Djinal warra ḏäpthuwa, ŋaya ŋarru bukumiŋgan God-Waŋarrwuḻ,” bitjan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","34","Bala nhan gaḏaymanam Betanhan ga Djayimnhan ga Djonnhan, bala dhanal bitjanan bala ŋarruŋan. Ga banha dhanal yakan ŋarruŋanam, bala nhan bitjanan wäŋanam dhanaliŋguḻ, “Wäy, yulparra, ŋayaŋum nyäku dhaŋu mariminan dhika ŋonuŋdjin, wilak ŋaya ŋarru dhaŋu waŋayin. Djinal warra ḏäpthuwa, ŋarru djäga warra gi yulŋum,” bitjan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Ga ŋarruŋan nhan mä bilaŋ gaŋga, bala nhan gälkinan munathaꞌḻin bala bukumiŋganan, “Mäḻu nyäku marrkapmi, dhäwulnha dhaŋu nhuŋgum gumurr-wanyu bilaŋ nhäwum mala djämawu. Mäḻuꞌ, ḏukṯukma ŋaya dhaŋu nhunu ŋarru yarrkthumana dhaŋu marim nyäkura. Ŋarru ŋayapim ŋarru dhaŋu nhuŋguwaynha yana djälwum malthun, yakan nyäkuwayma ŋaya,” bitjanan nhan yakan banha bukumiŋganam. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ga ḏitjuwan nhan balaya malthundamiwuḻ warrawuḻ nhanguwaywuḻ, ga maḻŋꞌthumanam nhan dhanaliny yakurrḻin. Ga dhirrꞌyuwan nhan dhanaliny, bala nhan Betawuḻin bitjanan wäŋan, “Wäy, nhalpiyan nhunum yaka dhaŋu, ŋoya yana? Dhäwul ŋarru nhuma dhaŋu bilaŋ mä guṯim yana biraꞌyun? ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Djäga warra nhumaliŋguway, ga bukumiŋgan warra God-Waŋarrwuḻin, mä nhumaliny ŋarru banha ŋunhuŋ nhäyum birrkaꞌyun, nhumam ŋarru yaka dhäya wanyun yana. Ḻinygu ŋayaŋum nhuŋgu yaka dhuwan djälmiyi nhunu ŋarru yaka dhäya wanyu yana, ŋarru rumbalma nhuŋgu dhuwan ganydjarrnharrayinan yalŋgiyinan,” bitjan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ga biyapul nhan Djesu ŋarruŋan bukumiŋgandawu, ga bitjanaya bili nhan bukumiŋgan bilanyaya bili yana dhäruk. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ga ṉakaman nhan, ga ḏitjuwan bukumiŋgandaŋurum ga maḻŋꞌthumanam dhanaliny yakurrḻin, yindiyu dhanaliny yakurryu dhurrthurryuwan. Ga banha dhanal ḏurryuwanam bala goṉayinan, ga dhäwulnha dhanal nhangu bilaŋ buku-ganitjumanam. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ga biyapul nhan ḏämbu ḻurrkunꞌmin gumurr-ḏitjuwan bukumiŋgandawu. Ga banha nhan ḏitjuwanam bala wäŋanan nhan bitjanan, “Ḻinygun, yakurrŋam warra rrurꞌyuwan! Walum dhaŋu galkin, nhan ŋarru bayiŋuyam yolŋuyu ŋarambiya-guŋana banha Yuwalkŋunham Walꞌŋu Yolŋuny maḻikumiwuḻin yolŋuwuḻ warrawuḻ. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Maꞌ! Ḏurryuwan warra ŋalma ŋarruŋan. Nhäŋan warra, dhaŋun nhan banha yolŋum banha nhan dhanaliny guŋgaꞌyuwan ŋayathandawu nyäku.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ga ŋurruŋu-djirrikaymiyu ga rom-marŋgikunhamiyu warrayu ga Djuwwu ŋurru-warrundayŋuyu warrayu djuyꞌyuwan waripunhan yolŋuny warrany Djudatjkum ŋapawu malthundawu. Ga nhanmam yakan banha Djesum baḏak wäŋan, bala nhan Djudatjma ḏoyꞌyuwanan ŋapa-malamin. Ga ŋarruŋanam dhanal yakan malkarr, goŋ gaṉamin, ga goŋ birkuꞌmin warra, gathandawun nhangu Djesuwun. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ga ḻinygu nhan banha Djudatjthum dhanaliŋgu rakaran bitjan, “Banha yolnha ŋaya ŋarru burumunꞌ wälkum banhayan banha yolŋunham nhuma ŋarru gathanma.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ga banha dhanal ḏoyꞌyuwanam bala nhan Djudatjma ŋarruŋanan Djesuwuḻin bala wäŋanan, “Marŋgikunharami,” bitjanam bala wälkuwanan nhanany, mä banham nhan maŋutji-wuŋanan dhanaliŋguḻ banha yolnha dhanal ŋarru gathan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Bala banha waripum yolŋu warra djalkiri-dhatharꞌyuwanan bala gathanan Djesunham. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Bala banha waŋganydhum Djesuwuru ḻunduꞌmiŋuyu yikin dhawaṯthuman bala yana buthurun gulkthuman, liya-ŋärraꞌmiwun yolŋuwu djämaminy. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Bala nhan Djesum wäŋanan bayikuya yolŋuwum warrawu bitjanan, “Nhäwu nhuma rälim ŋarruŋan malkarrma? Dhäwul ŋaya dhaŋu maḏakarritj yolŋu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ŋayam yakan bitjan ḻinygu walu-ŋupan marŋgiyuman yolŋuny warrany ŋunhalam God-Waŋarrwuram Dharrpalŋam Buṉbuŋa, ga dhäwul nhumam nhänany bilanyamiyum gathan, ... ŋarru dhaŋum nhumaliŋgun walu. Yo, bitjan mu nhan yaka ŋunha wukirriwuyma dhäya ŋätjiliŋuwuyma God-Waŋarrwuḻim Djorraꞌŋa,” bitjanan nhan Djesu wäŋanam. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Bala banha Djesuwum ḻunduꞌmiŋu warra biyaṉiyinan bala dhanal yuṯthuwanan, gananan nhanany banhambalayan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ga banhalaya yakan gurrmulyu ḏirramuyu ŋapa-munguyuwan Djesuny, ŋarru dhurrthurryunminam nhan banha manydjarrkaꞌyu. Ga bitjanaya ḻinygu dhanal banha nhananham ŋayathan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ŋarru dhanal nhanany banha baḏatjuwan, ga girrinꞌ yana dhanal nhangu gathanam. Ga nhanbayim yakan yuṯthuwan ŋayiḻim girriꞌnharran, ḻinygu nhan banha mariminan biyaṉiyin. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Bala dhanal banha Djesunham guyukanan balan ḻiya-ŋärraꞌmiwuḻin ŋayiḻi. Ga balayan yakan banha ŋaḻapaḻmim ḻuŋꞌthuwan bukmak yana, ŋurruŋu-djirrikaymi warra ga rom-marŋgikunhami warra ga Djuwwu ŋurru-warryundayŋu warra. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ga banha dhanal Djesuny guyukanam, ga nhanmam yakan banha Betam malthuwan bala, balaya ḻiya-ŋärraꞌmiwuḻ ŋayiḻi, ŋarru djuḻuḻꞌyuwan ŋarruŋan bala. Ga gulŋiyan dhanal rrambaŋi, bala nhan mala-manapanan nyenan biḻitjumanguḻin warrawuḻ banha yakan ḏäpthuwan ratjuwan gurthaŋa. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ga ŋunhalam banha djinawamꞌ buṉbuŋam dhanalim banha ŋurruŋu-djirrikaymiyum warrayu yakan dhäwunꞌ maḻŋꞌthuman Djesuwuruynha, mä dhanal ŋarru dhä-girꞌyuna nhanany maḻikuwuynha warkpuy. Ŋarru dhäwul dhanal banha maḻŋꞌthumanam bilaŋ nhäm maḻikum nhangura. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Yo, guḻkuny dhanal yakan yolŋuny warrany mäyan maŋutji-marŋgiminy mä dhanal ŋarru yalkum dhäwu nhanguruy rakaram, ga dhäwum mala dhanaliŋguŋ yakan bärrkuwaḻyinan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Yo, waripu yolŋu warra banha maŋutji-marŋgimi ṉakaꞌṉakaman bala yakan yalkuwanan dhäwu rakaran ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","bitjanan, “Dhaŋum ŋanapu yolŋuny ŋäma nhan bitjan wäŋa, ‘Dhaŋum ŋaya ŋarru bakthumana God-Waŋarrwum Dharrpalma Buṉbu yolŋuwuŋum goŋbuy dhuḻꞌyunda. Ga ḻurrkunꞌthum waluyu waripun buṉbu ŋarru ŋalthu, ga banhayam dhäwulnha yolŋuwuŋ ŋarambiyawuy.’ ” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ga dhäwum dhanal yakan banha rakaranam dhäwulnha dhunupam. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Bala nhan banha ḻiya-ŋärraꞌmim yolŋu ṉakamanan gumurrŋan yolŋuwuḻin warrawuḻ bala wäŋanan Djesunham bitjanan, “Dhaŋu yaka yolŋuyum warrayu rakaram be warri nhunu maḻikun warkthuwan. Ŋäma mu nhunu yaka dhanaliny? Nhäwu nhunu yaka dhaŋu mukthunma yana nyena?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ŋarru nhanmam Djesum dhäwulnha dhanaliŋgu buku-ganitjuman. Mukthuwanan nhan yakan nyenan. Bala nhan banha ḻiya-ŋärraꞌmim wäŋanan bitjanan, “Maꞌ, rakaraŋan ŋanapiliŋgu. Nhunu dhaŋu Maŋutji-dhunupayumandam yolŋu, ŋatja? .... God-Waŋarrwum gäthuꞌmiŋu?’ ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ga nhanmam Djesum bitjanan wäŋan, “Yo, ŋaya mu dhaŋu. Ga yalalam nhuma ŋarru nhäman Yuwalkŋunham Walꞌŋu Yolŋuny, ŋaya ŋarru yaka nyenam ganydjarrmin, dhunupaꞌŋuŋan God-Waŋarrwuran galiꞌŋam ŋunhalan djiwarrꞌŋan. Ga ḏitjum ŋaya barkthu räli djiwarrꞌŋurum waŋupiniyun. Bilanyawuynha nhuma barkthu banha nhänany nhäŋum.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Bala nhanmam banha ḻiya-ŋärraꞌmim yolŋu mariminan dhika maḏakarritjin, bala ŋarruŋan girrinꞌ nhanguway barrꞌparryuman, ga wäŋan nhan yatjuwan bitjan, “Ḻinygun ŋalma dhaŋu ŋäkulan nhanany dhärukma guḻkuyun wäŋanharam, banha nhan dhä-waripuŋuyinan wäŋan nhangun God-Waŋarrwun. Dhäwulnha ŋalma ŋarru biyapulma maŋutji-marŋgimiwuŋum dhäwu ŋäma. Nhalpiyana nhumam yaka guyaŋi, way?” bitjan. Ga dhanalim banha bukmakma yolŋum warra yoranan, “Yo, boyan nhanany murrkayꞌyuman.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Bala ŋarruŋan banha waripuyum yolŋuyu warrayu Djesunham dhupthuwanan. Ga garrwiꞌyuwan dhanal nhanany maŋutji manydjarrkaꞌyu bala yakan bartjumanan, ga wäŋan dhanal bitjan, “Maꞌ rakaraŋ wilak, yolthu nhuna ḻiyuwan?” Bala banha biḻitjumandhum warrayu Djesunham djawyuwanan bala yakan boyanan nhanany. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Ga bilanyamiyum nhanmam yakan Betam baḏak yana nyenan ratjumanmin. Ga banhalaya ḻiya-ŋärraꞌmiwuḻ buṉbuŋa djämamiyu dhäykayu nhäŋal Betany banhambalaya, bala bitjanan waŋan, “Wäy, nhunum dhaŋu Djesuwu ḻunduꞌmiŋu, ŋatja? ... bayikuya yolŋuwu banha ŋayi Nätjiritjpuywu?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ga nhanmam Betam buku-ganitjuman bitjan, “Dhäwul dhuwanma dhunupa. Yaka dhaŋu ŋaya marŋgi nhäwuy nhunu yaka dhaŋu wäŋa.” Bala yana nhan Betam dhawaṯthuwanan galiꞌḻin ga dhunupan yana banha guḻawurrma ŋätjinan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ga biyapul nhan bayiŋuya djämamiyu dhäykayu Betany nhäŋal, ga wäŋan nhan yolŋuny warrany banha yakan dhäyaꞌ-dhayan bitjan, “Dhaŋum yolŋu Djesuwu yana ḻunduꞌmiŋu yulparra.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ga nhanma Betam wäŋan, “Dhäwul! ... yaka ŋayam!” Ga yaka mu wikarra ga waripuyum yolŋuyu nhanany wäŋan bitjan, “Nhunupi yana dhaŋu, dhaŋum nhunu ŋayi Galaliwuy.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Bala nhanmam banha Betam mariminan dhika ŋayaŋu-maḻikinam bala nhan wäŋanan, “Dhäwul, yaka ŋayam dhaŋu marŋgi. God-Waŋarr dhaŋu nyäkum marŋgi, ga banha ŋaya yaka yalkumam, nhanmam ŋarru nhänany God-Waŋarryum dhä-girꞌyuna.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ga dhunupan yana banha guḻawurrma ŋätjinan, banhayam buku-bulalꞌyinan. Bala nhan Betayum guyaŋinan banha nhalpiyan nhanguḻ Djesu wäŋan bitjan, “Ŋärrun nhan ŋarru banha guḻawurrma ŋätji ḏämbu-bulalꞌmim, nhunum ŋatjil ŋarru nyäku mä-dhumbalꞌyu ḏämbu-ḻurrkunꞌmi.” Bala yana nhan Betam ŋätjinan mariminan dhika murruyꞌ-murruyyuwanan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ga munhakumin, bala dhanal banha Djuwwu ŋaḻapaḻmim ḻuŋꞌthuwanan bala yoranan Djesuwum dhä-girꞌyundawun waŋayinyarawun yana. Bala dhanal mataꞌyumanan nhanany Djesunham ŋarambiyan, bala dhanal ŋaḻapaḻmiyum guyukanan nhanany balan Bäylitkuḻin banha nhan Rawumbuy gapman buŋgawa. Ga wäŋan dhanal Bäylitnha nhan ŋarru nhanany mala-djarrꞌyuna. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Bala nhan Bäylitthum dhä-wirrkaꞌyuwanan nhanany bitjanan, “Nhunu dhaŋu buŋgawa Djuwwum yolŋuwu bäpurruwu?” Ga nhanmam Djesum buku-ganitjuman bitjan, “Dhuwaniyan bili yana dhärukma.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ga dhanalim banha ŋurruŋu-djirrkaymiyum warrayu rakaranam yakan Bäylitkuḻim bitjanan, “Djinaŋum yolŋuyu yakan warkthuwan guḻkun marimin maḻikum rom mala.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Bala nhan Bäylitma bitjanan nhangu wäŋan, “Ŋäma mu nhunu yaka? Ŋunham dhanal yaka nhunanhan rakaramam be maḻikuwuynha warkthunda. Dhäwulnha nhunu ŋarru dhaŋu bilaŋ wäŋam?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ŋarru nhanmam Djesum dhäwulnha wäŋan, bala yakan banha Bäylitma mä-maŋmaŋdhuwanan nhangu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ga bitjan ḻinygu dhuŋgarra-ŋupan dhanal bayiŋ Djuw bäpurru yolŋu warra buku-ḻuŋꞌthumanmi waŋganygu romgu yäkuwu Räy-djuḻkthumandmiwu Waluwu. Ga bitjan bili nhan bayiŋ Rawmanbuyyu Gapmandhu dhawaṯthumarra waŋganynha yolŋuny dharruŋguŋuru, yolku dhanal bayiŋ Djuwyu bäpurruyu ŋäŋꞌthuwarra. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Yo, ga bilanyamiyum yakan yolŋu yäku Barabatjnha gulŋiyan ga mala nhangu bili dhanal yakan mari-ḏoyꞌyuwan Rawumbuywu gapmangu warrawu. Ga waripunham yolŋuny dhanal bayiŋ boyarran waŋayumarran yana. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Manymak, dhanalim banha Djuw malam yolŋu warra ŋarruŋanan bala ŋäŋꞌthuwanan Bäylitnham waŋganygun ḏapthumandawuywu yolŋuwu dhawaṯthumandawu, bitjan nhan bayiŋ yaka ŋätjil bitjanya warkthun. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Bala nhan Bäylitthum wäŋanan bitjanan, “Yolnha dhika ŋaya ŋarru dhawaṯthumanma? Nhämi dhaŋu banha Djuw-malawum yindinham buŋgawany?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ŋarru nhan banha Bäylitma ŋätjil yana mariŋgiyin banha dhanal ŋurruŋu-djirrikaymiyum warrayu golanam nhanany Djesunham balam nhanguḻim, ḻinygu dhanal yakan banha maŋutji-ḏiyꞌyuwan nhanany. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ŋarru dhanalim banha ŋurruŋu-djirrikaymiyum warrayu yakan dharꞌthar-guŋanan yolŋunham warrany dhanal ŋarru Bäylitnham ŋäŋꞌṯhun Barabatjkun yana dhawaṯthumandawum. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ga biyapul nhan Bäylitthu dhä-wirrkaꞌyuwan banha yolŋunham warrany, “Nhalpiyana ŋaya ŋarru dhaŋum gayꞌ yolŋuny, banha nhuma bayiŋ yaka rakaram be nhan buŋgawa Djuwwu yolŋuwu warrawu?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ga dhanalim guḻkun yana wäŋan yatjuwanam bitjanan, “Boyan yana nhanany waŋayuman! Ga dhuḻꞌyuwan nhanany mälakthumandamiḻin dharpaḻi!” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Bala nhanmam Bäylitma wäŋan, “Nhä yulŋum? Nhä nhan nhumaliŋgu maḻikum warkthuwan?” Ŋarru dhanalim banha mariminan yana yatjunminam wäŋan, “Boyan yana nhanany waŋayuman, bala dhuḻꞌyuwan dharpaḻin!” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Bala nhan Bäylitma yoranan dhanaliŋgu, djäl-ŋuwatjumanan dhanaliny. Bala yana nhan Barabatjnhan dhawaṯthumanam. Ga wäŋan nhan Rawumbuywuḻim miriŋuwuḻ warrawuḻ bartjumandawun nhangu Djesuwum. Ga banha dhanal nhanguru bartjumandaŋam goŋ-dhawarꞌyuwan bala nhan Bäylitma bitjanan wäŋan miriŋuwuḻim, “Gatjuy mäyaŋan warra nhanany bala dhuḻꞌyuwan nhanany mälakthumandamiḻin dharpaḻi bala ganakan banhambalayan, baya nhan ŋarru waŋayi.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Dhurrwaraŋuru bewaḻiyam bala dhanal miriŋuyum warrayu ŋarruŋan maŋutji-warryuwanan Djesunham dhawaṯthumanan balan banha warraŋulḻin goḏuḻi. Ga gawaꞌyuwan dhanal waripuwun miriŋuwu warrawu, malamiwun yana, guḻkun banha marimin yulŋum, balayan yakan dhawaṯthuwan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ga ŋalthuman dhanal nhanguḻ djakaꞌ wikarra mikuꞌmi girriꞌ bitjan bayiŋ yindiwun buŋgawawu girriꞌ. Ga maḻŋꞌthuman dhanal ḏirriṯirri bala dhoṯkuwan djoŋguꞌkuwanan warkthuwan, bala yana nhinathuŋganan ṉiṉꞌthumanan nhanguḻ muḻkurrḻin. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Bala dhanal nhanany yakan warkuꞌyuwanan, “Dhaŋun nhan yindim buŋgawa, Djuwwum warrawu!” bitjanan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Bala dhanal muḻkurrnha nhanany yakan boyan dharpayun, ga dhupthuwan dhanal nhanany bala yakan warkuꞌyuwanan, bunꞌkumu-djipthuwanan nhanguḻ buku-ŋalthuwanan manapan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ga banha dhanal warkuꞌyundaŋurum nhanguḻ dhawarꞌyuwan, bala dhanal yapthumanan nhanguḻ mikuꞌmim girriꞌ bala gunyanam nhanguwaynha girriꞌ. Bala nhanany miriŋuyum warrayu guyukanan dhawaṯthumanan dhuḻyundawun mälakthumandaḻin dharpaḻi. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ga banha dhanal ŋarruŋan gumurr-dhawaṯthuwanam beŋurum Djurutjalamŋurum, bala dhanal gandarrŋam maḻŋꞌthuman yolŋunhan yäkuny Djäymannhan ŋayi Djäriniwuynhan. Ga mäḻuꞌmiŋum nhan banha dhupaliŋgu Yaliktjandawu ga Ropatjku. Bala dhanal nhanany barkan warryuwan bala dharꞌthar-wuŋanan nhanany Djesunham dharpawun golanharawu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Bala dhanal ḏoyꞌyuwanan ŋunhalayan ŋayiŋa yäkuŋa Gulgathan, mayaliꞌ, ‘Muḻkurr Ŋaraka Ŋayi’. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ga banhalayan dhanal banha Djesunham guŋan wiyikanꞌ borumnha maŋutji-manapanda mirritjinꞌ yäku merr, mä ŋarru burrumunuŋgum nhanany rumbalnha. Ŋarru nhanbayim banha Djesuyum dhäwulnha wurkthuwan banhayam borum wiyikaꞌ. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Bala dhanal nhanany Djesunham dhuḻꞌyuwanan mälakthumandaḻin dharpaḻi. Bala ṉakanhamiŋganan banha dharpam, bala gunyanan. Ga walum banha goḏarrꞌmi yana, räyyu-waluyu. Bala yakan banha miriŋum warra buḻꞌyuwanan dopulunꞌ girriꞌwun nhanguru mäyanharawu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Bala dhanal dhäruknha wukirri banha nhäwuy dhanal nhanany dhä-girꞌyuwan, bala dhuḻꞌyuwanan balayan bukuḻin dharpaḻi, banha Djesu yakan goyuwan. Ga bitjan yakan banha barraŋgaꞌyuwanam, gamꞌ, ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ga bitjanya bili dhanal banha manaŋgannham ḏirramuny wulanynha ŋalthuman, waŋganynham dhanal dhuḻꞌyuwan dhunupaꞌŋuḻi galiꞌḻi nhanguḻ Djesuwuḻ, ga waŋganynham ga wiṉꞌkuḻin galiꞌḻi. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Dhaŋum dhäruk biliŋuwuynha wukirriwuynha God-Waŋarrwuran Dhuyuŋan Djorraꞌŋa bilanya gamꞌ, “Banham dhanal bitjanam nhanany rakaran, yana warri nhanmam romnharran yolŋu.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ga banha yakan yolŋum warra ŋarruŋan djuḻkthumanam nhanany, ga ḏawaḏawꞌyuwan dhanal ŋarruŋan, warkuꞌyuwan manapan nhanany. Ga bitjan nhangu wäŋan, “Wäy, be mu nhunum ŋarru dhaŋu bakthuman ŋunha banha God-Waŋarrwum Dharrpalma Buṉbu, ga biyapul nhunu ŋarru be dhuḻꞌyu ḻurrkunꞌthum waluyu? ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Gu, wilak birrkaꞌyuwan yapthumanmiyan dhawuruya dharpaŋurum, mä ŋanapu ŋarru nhäma bala mä-yuwalktjin nhuŋgu, banha nhunu God-Waŋarrwum be gäthuꞌmiŋu?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ga bitjanya bili dhanalim banha ŋurruŋu-djirrikaymiyum ga rom-marŋgikunhamiyum yolŋuyu warrayu warkuꞌyuwan nhanany Djesuny. Ga bitjan dhanal wäŋan gamꞌ, “Wäy, dhaŋu nhan yakan ŋunha waripuny yolŋuny warrany wälŋayuman, ... ga dhäwulnha nhan ŋarru dhaŋu nhanbayim wälŋakunharami? ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Dhaŋu nhan yakan ‘Maŋutji-dhunupayumanda’ rakaranhamin, be God-Waŋarrwuŋ djuyꞌyunda ŋätjiliŋuwuy. Ga waripuyum yolŋuyu warrayu yakan rakaran be warri nhan dhaŋu Yindin Buŋgawa Djuwwun warrawu. Ga banha yultham, nhan ŋarru yapthuna dharpaŋurum mä ŋalma ŋarru nhäma bala mä-yuwalktjin.” Ga bulalꞌ yolŋu wulay yakan banhalaya goyuwan rrambaŋi dhanal Djesu. Ga bitjanaya ḻinygu dhupalim nhanany yakan warkuꞌyuwan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ga walum banha ḏämbuyun waluyu, ŋarru munhayun banha dhurrthurryuwanam warrpamꞌthuwanan banhayam ŋarakany ŋayiny, bitjan munhakun. Ga goyuwan yakan banha munham ga yanatj ḻinygu-u-u ga räy-bilyuwan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Bala nhan ŋunhalam Djesum yatjuwanan dhärukmurrun nhangurumurru Arram-murrun bitjanan, “Eloi, Eloi, lema sabachthani?” (mayaliꞌ, God-Waŋarr nyäku, God-Waŋarr nyäku, nhäwu nhunu nyäku räy-nhinathuŋganminam?”) ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ga banhalaya yakan yolŋu warra dhayaꞌdhayan, ga ŋäkul dhanal banha Djesuny yatjundam. Bala dhanal bitjanan wäŋan, “Way, ŋäka warra! Ŋunham nhan yaka Yilaydjawun gawaꞌyun.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Bala nhan waŋganyma yolŋu yuṯthuwanan bala yalŋgin gadharran mäyan bala borumḻin wiyikaꞌḻin ḻupthuman. Bala mamꞌthuman nhan dharpaḻin bala ŋarruŋan garrwarkuwanan Djesuwuḻin, mä nhan ŋarru wurkthun banhaya wiyikaꞌ borum. Bala nhan bitjanan wäŋanam, “Bulnha ŋatjil ŋalma gäḻkuḻam ŋay, nhan bayan bilaŋ Yilaydjan yarrupthu guŋgaꞌyundawun nhangu.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Bala nhan Djesum mariminan yatjuwan, bala waŋayinan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ga bilanyamiyu ḻinygu ŋunhal Djurutjalamma nhanmam banha manydjarrkamꞌ God-Waŋarrwuram Dharrpalŋam Buṉbuŋa banha yakan gungan dharrpalnhan goḏuny yolŋuwurun, banhayam yarrarꞌyuwanan, beŋuru ḻinygu bukuŋuru ga ḏupthuwan ŋunha ŋoyḻi, bala yana bärrkuwaḻyinan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ga ŋunhalaya Gulgatha yolŋu yakan dhäyan ŋurru-warryundayŋu miriŋuwu warrawu, ga nhäŋal nhan yakan Djesuny beŋuru ŋoyŋuru dharpaŋuru banha nhan milma waŋayin. Bala nhan wäŋanan, “Nhän way! Dhaŋum yuwalknha yana yolŋu God-Waŋarrwun Gäthuꞌmiŋu, ŋatja?” bitjanan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Ga banhalaya yakan dhäyka warra dhäya-dhayan, ŋarru mä bärrku. Ga banhayam dhäyka warra bayiŋ garra Djesuwu malthuwarra, ga guŋgaꞌyuwarra nhanany ŋunhal Galali. Ga dhaŋu warra banha yulŋum gamꞌ: Meri Magdalawuy, Djalumi, ga waripu Meri, ŋäṉḏiꞌmiŋu dhupaliŋgu gurrmulwu wulayku Djayimgu ga Djawutjipku, ga guḻku banha waripu dhäyka warra banha dhanal ŋapawu malthuwan nhangu Djesuwu bala Djurutjalamḻi. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Yo, ga waŋayinam nhan banha Djesum waluyum Biraydin räy-bilyundayun. Ga dhurrwaraŋuru bewaḻiyam bala nhan Djawutjipthum guyaŋinan nhan ŋarru Djesunham rumbal yapthumana mälakthumandamiŋurum dharpaŋuru. Ga yolŋum nhan banha ŋayi Yaramithiyawuy, ga ŋurrukŋurum nhan banha Djuwwuḻ ŋaḻapaḻmiwuḻ ŋärraꞌŋuru. Ga ŋuwakurru nhan banha yolŋum. Yo, ga dhuka-nhäŋal nhan yakan banha God-Waŋarrwum romgu-ŋarruŋanhamiŋgandawum. Ga ŋärrun banha waripum walu djaḏawꞌyun banhayam banha Djuwwun bäpurruwu Nyenanhamin Walu, nhanmam Djawtjipma ṉakamanan, bala yana ŋarruŋanan ŋayaŋu-mulkaꞌyinan Bäylitkuḻin ga wäŋanan, “Nhalpiyan ŋaya ŋarru Djesunham rumbal mäyaman?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Bala nhan banha Bäylitthum ganyimꞌthuwanan ŋäkul, bala bitjanan wäŋan, “Nhä, bilin nhan waŋayinan?” Bala nhan dhäruk-guŋganminan banha miriŋuwun buŋgawawu guwatjmandawun nhangu, ga dhä-wirrkaꞌyuwan nhan bitjan, “Nhä, yulthan nhan waŋayinam?” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Bala nhan banha miriŋuwurum buŋgawayu rakaran bitjanan, “Yuw, yulthan yana!’ Bala nhan Bäylitthum dhayuŋganan Djesunham rumbal Djawutjipkuḻin. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ga nhanmam Djawutjipthum wuŋiḻiꞌyuwanan manydjarrkanꞌ rrupiya yindimin, ga balaya nhan ḏitjuwan Gulgathaḻi Djesuwun rumbalwu mäyanharawu beŋurun dharpaŋurun. Ga bayiŋuyan nhan manydjarrkaꞌyu nhanany garrwiꞌyuwanam, bala dhanal gunyanan nhanany mathirraḻin, banhambalayan banha dhanal ŋätjilmiŋgan ŋangiꞌyuwan bala yana gaḻꞌkaḻyumanan yindin marimin bäthum dhurrwarawum dhaḻꞌyundawu. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ga dhupalim banha Meri Magdalawuyma ga Meri Djawutjipkum ŋäṉḏiꞌmiŋu maŋutji-marŋgin wulay ŋalambal dhanal banha Djesuny rumbal märrkitjkuwan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ga banha Djuwwu Nyenanharamim Walu dhawarꞌyuwanam ŋunhuŋun yuṯuŋgurr-munhamiyun. Ga dhanalim banha Meri Magdalawuyma ga Djalumim ga Merim banha Djayimgum ŋäṉḏiꞌmiŋu ŋarruŋanan buŋgan-bäwꞌwun wuŋiḻiꞌyundawu mä dhanal ŋarru ŋuwatjumana yana ŋarambiya-ŋuwatjim nhangu rumbalwum. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ga Djandin ŋarruŋan djaḏawꞌyuwan, bala dhanal dhäykam warra ŋaykanan balan mathirraḻin. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Ga banha dhanal yakan ŋarruŋanam dhuka-ŋupanam, bala dhanal ŋarruŋan wäŋanharaminan, “Yolthu ŋalmaliŋgu ŋarru ŋunha bäthum giṯthuman dhurrwaraŋurum? Bathalan ŋunha marimin yulŋum.” Ga banha dhanal ḏoyꞌyuwan ŋunhalayam, bala nhäŋal bäthum galiꞌŋan yakan dhäyan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ga gulŋiyan dhanal balaya mathirraḻi bala nhäŋal gurrmulnhan ḏirramuny girriꞌ watharrmin yakan nyenan. Ga mariminan dhanal banha ganyimꞌthuwanam. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ga bitjan nhan banha dhanaliŋgu wäŋanam, “Dhäwul warra biyaṉiyiya. Dhaŋum nhuma yaka Djesuwun rumbalwum rangam ŋayi-Nätjiritjpuywun banha nhanany dhanal boyan rakunyguwan. Ḻinygun nhanany banha God-Waŋarryum wälŋayumanan rakunyŋurum, ga dhäwulnha nhan dhaŋum. Nhäŋan warra, dhaŋun banha dharapulma banha dhanal märrkitjkuwan nhangu rumbalma. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Maꞌ ḏitjuwan warra balaya ga rakaraŋ nhangu malthundamiwuḻim warrawuḻ mä dhanal ŋarru ḏitjuna Galaliḻin makaḻi. Ga bitja rakaraŋam banha nhanmam ŋarru ŋätjilin ŋarruŋa, ga banha dhanal ŋarru ḏoyꞌyunma, ŋunhalayan dhanal ŋarru nhanany maḻŋꞌthumanma. Ga rakaraŋ yana Betawuḻim. Yo, ḻinygu mu nhan banha Djesuyum ŋätjil dhanaliŋguḻ bitjanam rakaran,” bitjan nhan banha gurrmulma wäŋan. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ga nhäŋal dhanal banha dhäykayum warrayu dharapulma bala yana dhäruk-mukthuwanan bala dhawaṯthuwanan mathirraŋurum, bala yuṯthuwanan. Ga dhäwulnha dhanal banha bilaŋ yolkum dhäwu rakaran, ḻinygu dhanal banha mariminan biyaṉiyinam. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ga Djandi walu djaḏawꞌyuwan ŋarru goḏarrꞌmin, nhan Djesum maŋutji-wuŋanminan Meri Magdalawuywuḻin. Djinakuḻin banha dhäykawuḻ nhan Djesuyum dhawaṯthuman djabinham maḻikuny mala birrimbirrnha ŋätjilim. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Bala nhan yana Merim ŋarruŋanan malthundamiwun ḏoyꞌyuwan, dhanal ŋarruŋan ŋätjinyaramin. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Bala nhan Meriyum dhanaliŋgu rakaran bitjanan, “Yulparra, Garrayma dhaŋu biyapul yawungu wälŋayi, ga ḻinygun dhaŋu ŋayam nhanany nhäŋalan.” Ga dhanalim bitjan wäŋan ḻinygu dhanal mä-yuḻkthuwan nhanany, “Nhä nyin dhaŋum djinaŋum rakaram way!’ ");
INSERT INTO dhgduwadha_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ga biyapul nhan Djesu maŋutji-wuŋanmin bulalꞌwuḻin malthundamiwuḻ wulaykuḻ, banha dhupal ŋarruŋan bala yuṯthuwan ḏiltjimurru. Ga waripuŋuyinan nhan banha rumbalma dhupaliŋguram maŋutjiŋa. Ga ŋärrun dhupal nhanany banha dharaŋganam. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Bala dhupal ḏitjuwanan balaya Djurutjalamḻi ga rakaran malthundamiwuḻim warrawuḻ bitjanan, “Wäy, yulparra ŋäka warra, ḻinygun dhaŋu ŋalinyum nhäŋalan nhanany Djesunham ŋunhalan dhukaŋan!” Ŋarru dhanalim banha ḻunduꞌmiŋum warra bitjanan wäŋan, “Dhäwul wulay yalkuwa.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ga dhurrwaraŋuru bewaḻiyam bala nhan Djesum nhanbayim milkunhaminan 11-guḻin malthundamiwuḻ warrawuḻ, dhanal ŋarruŋan ŋatha ṉokan. Bala nhan dhaykuwanan dhanaliny bitjanan, “Dhaŋu nhuma ŋayaŋu-wanyumin yolŋu warra. Ḻinygu mu yakan banha yolŋuyum warrayu nhumaliŋguḻ rakaran, banha dhanal nhäŋal nhänany dhanaliŋguwaywuḻ maŋutjiyu, ŋarru nhumam dhäwulnha dhanaliŋgu mä-yuwalktjin. Ga dhaŋum ŋaya ŋayapin nhumaliŋgu nhawun ḏoyꞌyuwan. Yuwalk yana ŋaya banha waŋayinam, ga bulu ŋaya dhaŋu wälŋayi. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Gatjuy ŋarryan warra ga rakaraŋan manymakma dhäwu nyäkuwuruyma bukmakkuḻin yana yolŋuwuḻim warrawuḻ, dhaŋu buku-ḻiwꞌyuman yaka nyena munathaꞌŋa ŋayiŋa. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ga bilaŋ nhan ŋarru ŋunhuŋ yol yolŋu mä-yuwalktjim nyäku, ga buku-ḻupma mäyam, nhanmam ŋarru God-Waŋarryum dhanaliny wälŋayumana. Ga bilaŋ nhan ŋarru ŋuyulktjim, dhäwulma nyäku mä-yuwalktji nhananham ŋarru banhayam yolŋuny dhä-girꞌyuna bala ŋarru ḏupthuna warraŋulḻin djiwarrꞌŋurum. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ga banha ŋarru yolŋu warra yaka mä-yuwalktjim, dhanalim ŋarru yaka djämam ŋayaŋu-ganyimꞌthundamin romma malany, banha ŋarru yaka bayiŋuyam maŋutji rakaram banha banhayam God-Waŋarrwun ganydjarr. Ga nhänhanan dhanal ŋarru yaka banha ŋaykaṉam bäki wakinŋumiwum birrimbirrwu dhawaṯthumandawu. Ga wäŋam dhanal ŋarru yaka banha waripun mulkurun dhärukma. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ga bayiŋ dhanal ŋarru bilaŋ bäpim gathan, nhä wilak botjinma ṉoka, dhanalim ŋarru banha dhäwulnha rirrikthun. Ga goŋ-ŋalthun dhanal ŋarru rerrimiwuḻim yolŋuwuḻ, ga dhanalim ŋarru banha ḏukthuna yana.” ");
INSERT INTO dhgduwadha_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ga banha nhan yakan Djesu wäŋanam malthundamiwuḻim warrawuḻ nhanguḻ, ga dhawarꞌyuwanam, bala nhan God-Waŋarryum mäyanan nhanany balan djiwarrꞌḻin. Ga ŋunhan nhan yulŋum nyenan yaka God-Waŋarrwuḻin dhunupaŋan yana galiꞌŋam, mä dhupal ŋarru ŋunha rrambaŋin yaka warkthunma. ");
INSERT INTO dhgduwadha_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Bala dhanalim banha malthundamiyum warrayu dhärukma nhanany mäyanan. Bala dhanal dhäwun ŋarruŋan rakaran Djesuwuruynha ŋuwakurrun buku-ḻiwꞌyumanan. Ga nhanmam God-Waŋarryum yakan dhanaliŋgu guŋanan ganydjarrma mä dhanal ŋarru yaka djämam ŋayaŋu-ganyimꞌthundamin romma, banha nhan Djesuyu dhanaliŋgu rakaran dhä-ŋatjil. Ga guḻkun yakan banha yolŋum warra Djesuwum mä-yuwalktjin, ḻinygu dhanal dharaŋganan banha banhayam ŋuwakurrum dhäwu yulthan yana. Ga banha dhanal ḻurrkunꞌma dhäyka warra ḏoyꞌyuwanam Betawum ga malthundamiwum warrawu, bala dhanal rakaranan dhanaliŋguḻ banha gurrmulnhan banha nhan yakan wäŋan dhanaliŋgu ŋunhal mathirraŋa. Ga dhurrwaraŋuru bewaḻiyam bala nhan Djesum dhäruk-guŋanminan nhanguḻ malthundamiwuḻim warrawuḻ dhanal ŋarru banhayam Ŋuwakurrum Dhäwu rakaraman buku-ḻiwꞌyumana, djinal munathaꞌŋam ŋayiŋa. Djinaŋum yaka dhäwuyu rakaram banha God-Waŋarryum ŋarru wälŋayumana yolŋunham warrany maḻikuŋurum romŋuru, mä dhanal ŋarru yaka nyenam nhanguran djiwarrꞌŋan wälŋa-dhawarꞌyundanharran. Dhaŋum Ŋuwakurrun Dhäwu ga yulthan yana. Ga djinakun gämurruꞌwu nhan dhaŋu dhawarꞌyundanharram dhäwu. ");
INSERT INTO dhgduwadha_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Djesum wäŋan nhanguru malthundamiwum, bitjan, “Dhuyu Birrimbirrma ŋarru ŋarruŋan nhumaliŋguḻ, bala nhan ŋarru ganydjarrma nhumaliny guŋana, mä nhuma ŋarru yaka rakaraman nhänany ŋunhalan Jerusalemnha, ga Judiya’ŋa ŋayiŋa, ga ŋunha Samariyaŋa ŋayiŋa, ga waripum nhuma ŋarru ŋarruŋa banha ŋalaŋa yaka yolŋu warra nyena dhaŋu buku-liw’yuman, bala yana rakaraŋan nhänany.” ");
INSERT INTO dhgduwadha_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","10","Ga banha nhan Djesuyu dhawar'yuwanam rakaran, bala nhan Godthum mäyanan nhanany balan djiwarr’ḻin. Bala nhanguru malthundamiyum warrayu yakan nhäŋalan nhanany. Bala bewaḻiyam nhan maŋandhun gungan nhanany Djesunham, bala nhanguru malthundamiyum warrayu dhäwulnha bulum nhanany nhäŋal. Ŋarru dhanalim yakan banha baḏaknha yana nhäŋal bala garramaṯḻim, bala beŋuruyam bulal’nha yolŋu wulay malŋ’ṯhuwan girri’ watharrrminy, dhäyan yakan galkin yana dhanaliŋguḻ. ");
INSERT INTO dhgduwadha_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Bala dhupal wäŋanan, “Nhuma ḏirramu warra Galaliwuy, nhäwu nhuma yaka dhaŋu dhäyam, nhämam balam garramatlim? Bilin nhan Godthun mäyanan Djesunham balan djiwarr’ḻin. Ŋarru nhan barkthu bulu ḏitju räli, bitju bili yana banha nhuma nhäŋal nhanany ŋarruŋanhaḻi.”");
ALTER TABLE dhgduwadha_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
