﻿USE sofia;
DROP TABLE IF EXISTS sofia.dhg_vpl;
CREATE TABLE dhg_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES dhg_vpl WRITE;
INSERT INTO dhg_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","Banha ŋalma bayiŋ marim warraṯthun, nhanmam ŋarru Godthum ŋalmaliny guŋga’yun bitjanna bili. Ŋarram ŋalma bayiŋ banha nhanguḻ, bili nhän banha ŋalmaliŋgu ŋurrwum’ ga nhän bayiŋ banha ŋalmaliny wanyuyumanma. ");
INSERT INTO dhg_vpl VALUES ("PR3_5","021_3_5","PRO","3","5","5","Ŋayaŋu-ṉiṉ’thuwa God-Waŋarrwuḻim gulitjtjuma yana. Ga ŋangawul mä-ŋalthuwa nhuŋguwaywurum bitjuwayiŋ gayilinydjilwu, ḻinygu ŋangawul nhunu dhaŋu marŋgi bukmakkum nhäwu malanyŋuwu. ");
INSERT INTO dhg_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Dhaŋum ŋuwakurrun yana dhäwu. Ga dhäwum dhaŋu God-Waŋarrwuruy Gäthuꞌmiŋuwuruy, ga yäkum nhan banha Djesu. Nhanmam dhaŋu Christnha, Maŋutji-yunupayumandan banha nhan God-Waŋarryu bäkumiŋgan ŋätjil. Ga dhäwum nhanguruy gayŋa dhaŋu bitjan gamꞌ ŋurruꞌyirryun: ");
INSERT INTO dhg_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ŋangawul mu nhan banha Djesum ŋurruyirrꞌyuwanam djämam bitjuwayiŋ, ŋarru God-Waŋarryum banha ḻinygu yänguwan yolŋuny yäkuny Djonnha. Nhän banha Djondhu batjiwarrma nhangu Djesuwum yäkthuwan. Ga ŋätjil mu nhan banha ḻinygu gayŋan God-Waŋarryum bäki nhanguway djawarrkminy yolŋuny yäkuny Yitjayany. Ga bitjan nhan banha ŋätjilim wukirri gamꞌ: “Ŋäka warra! Dhaŋu ŋaya gayŋa yänguman yolŋunhan dhäwuminhan nyäkuway. Nhan ŋarru batjiwarrnha yäkthun nhuŋgun. ");
INSERT INTO dhg_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ga ŋarram nhan ŋarru banhayam yolŋu ŋunha wiraŋḻin waŋgalaḻ yolŋunharraḻin ga ŋunhalayan nhan barkthu gayŋi djawarrkthum, ‘Bukmak yolŋu bawalamiŋa, gatjuy ŋamaŋamayunmiyan nhangum Garraywum. Batjiwarrma dhuṉḏaykuŋan, gumurr-ŋuwatjiyan nhangu.’” ");
INSERT INTO dhg_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","6","Ga banhayam yolŋu yäku Djonnha banha Ḏämbu-ḻupthumandamin yolŋu. Ga nyenanam nhan gayŋan banha guŋnharran yana yolŋunharraŋan ŋirrimaŋa galki banha mayaŋꞌŋa yäkuŋa Djodannha. Ga girriꞌyum nhan bayiŋ gayŋarra dhaṯthunmiyarram gämuḻwuru bulkaꞌyu, ga biralma nhangu djämawuy warrakanꞌkuru barrwaṉdhu. Ga ŋatham nhan bayiŋ gayŋarra guwamarra ḏetjnha ga gukun. Djonma gayŋan banha nyenan bitjan bitjuwayiŋ banha God-Waŋarrwu djawarrkmi yäku Yilaydja gayŋan nyenan ŋätjil. Ga bilanyamiyum guḻkun banha yolŋum warra ŋaykan dhawuru Djurutjalamŋurum ga bawalamiŋurun ŋirrimaŋuru bewaḻi Djudiyaŋurun makaŋuru, ŋarranam bitjuwayiŋ balayam Djongum waythuwan. Ga ŋirrimbuwanam dhanal banha, ḻinygu dhanal gayŋan djälmiyin dhanal ŋarru nhäma nhanany, ga ŋäma nhanguŋ dhäwu nhalpiyan nhan gayŋan marŋgikuwan. Ga bitjanan nhan gayŋan dhanaliny garruwanam, “Way, waraparra, rakaraŋan warraŋulkuŋan warra nhumaliŋguway barrakinyma mala, bala ŋanydjaḻaꞌyuwan, bala yana guŋnharruman, mä nhan ŋarru God-Waŋarryum nhumaliŋgu baya-rakaraman. Djalkthuwan warra dhuwan barrakinyma malany bala ḏämbu-ḻupthuwan mä ŋarru banha bayiŋuyam maŋutji-rakaraman banha nhumam ḻinygun bitjuwayiŋ ŋuwakurrun.” Ga banha dhanal ŋarran barrakinyma dhanaliŋguway rakaran warraŋulkuwanam, bala nhan dhanaliny gayŋan ḏämbu-ḻupthumanan ŋunhalayan Djodannha mayaŋꞌŋam. ");
INSERT INTO dhg_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ga bitjan nhan dhanaliŋgu garruwan, “Dhika gayŋa waripum yolŋu ŋarra bulun walꞌŋu djuḻkthumana gayŋa nhänanham. Ga ŋayapim dhaŋu ŋangawul bitjuwayiŋ ganaꞌ ŋunhukum nhangu djalkiriwuywum yapthumandawu, räywuy dhaŋu ŋayam yolŋu ŋangawul ŋurruwuŋmi. ");
INSERT INTO dhg_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ŋayam gayŋa nhumaliny dhaŋu ḏämbu-ḻupthuman garmakthu yana waŋganydhu. Ŋarru, nhanmam ŋarru banha God-Waŋarryum nhumaliŋgum rarryu Dhuyu-Birrimbirrnhan, banham gayŋa biyapulnha wal'ŋu djuḻkthumana.” ");
INSERT INTO dhg_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ga bilanyamiyum nhan Djesum ŋarranan bewaḻim Galaliŋurum makaŋuru ŋirrimaŋuru yäkuŋuru Nätjiritjŋurum, nhan ŋarru Djongun waythun. Bala nhan Djondhum nhanany Djesunham ḏämbu-ḻupthumanan banhalayan Djodannha mayaŋꞌŋam. ");
INSERT INTO dhg_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ga banha nhan Djesu bitjuwayiŋ garmakŋurum walman, bala banha djiwarrꞌma ḻapthuwanan. Ga God-Waŋarrwum Dhuyu Birrimbirrma yarrupthuwanan nhanguḻ bilanyan bitjuwayiŋ bäwarraṉ murryil. ");
INSERT INTO dhg_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Bala dhanal ŋäkulan rirrakaynha garruwan gayŋan bitjan, “Dhaŋun banha nyäku marrkapma gäthuꞌmiŋu. Ga marimin yana ŋaya bayiŋ gayŋa dhaŋu goŋmiyim nhanguḻ.” ");
INSERT INTO dhg_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ga dhurrwaraŋuru bewaḻiyam, bala banha Dhuyu-Birrimbirryum djakawarruwanan Djesunham gänaŋuḻin ŋirrimaḻi, wiraŋḻin. ");
INSERT INTO dhg_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ga banhalayan ŋayilpiꞌŋan nhan gayŋan banha nyenanam 40-n walum. Ga waripum gayŋan banhalaya nyenan wakinŋumin wäyinꞌ malany. Ga banhalayan nhanany gayŋan banha Djaytindhum bitjuwayiŋ dharrwunuwan. Ŋarru nhan ŋangawul bitjuwayiŋ malthuwanam nhangu. Bala banha djiwarrꞌwuyma dhäwumim yolŋu warra waythuwanan guŋgaꞌyundawum nhangu. ");
INSERT INTO dhg_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Waŋganymim waluyu dhanal ŋayathanan Djonnham banha Ḏämbu-ḻupthumandaminham bala dhethuŋganan dharruŋguḻin. Bala nhanmam banha Djesum ŋarran balan Galaliḻin makaḻi, mä nhan ŋarru rakaraman God-Waŋarrwuruynha ŋuwakurrun dhäwu banhalayan. ");
INSERT INTO dhg_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ga bitjan nhan gayŋan garruwanam, “Ŋäkan warra! Garraywum dhaŋu walu ḻinygun waythuwanan! Ga yolŋum ŋarru banha bukmaknha yana marŋgiyim banha God-Waŋarryum barkthu romma nhanguway ŋarranharamiŋgana, ga dhaŋun banha yulŋum djinaŋun bala. Gatjuy, biluwan warra mayaliꞌ-wutjparrundamiŋurum romŋuru, bala ḏirruwan, bala malthuwan nhangun God-Waŋarrwun yängum. Bala mä-wulitjtjiyan bayikuyan God-Waŋarrwun ŋuwakurruwun yana dhäwuꞌwum.” ");
INSERT INTO dhg_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Waŋganymiyum nhan gayŋan Djesum ŋarran ŋunha wuḏuy-djakawarruwan guḻungu Galaliwuywu. Ga banhalayam nhan maḻŋꞌthuman yolŋuny yäkuny Djäymannhan ga guthaꞌmiŋuny nhangu Wanduruny. Banhalaya dhupal nyin ŋarirri guwatharan ganybuyu. Banhayan ḻinygu dhupaliŋgu djämam. ");
INSERT INTO dhg_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Bala nhan Djesum guykuyyuwanan dhupaliŋgu bitjanan, “Wäy, warapulay, gu! Malthuwan wulay nyäkun. Ŋayam ŋarru nhumaliny marŋgikum nhuma ŋarru gayŋa gaṯthuman yolŋunhan warrany.” ");
INSERT INTO dhg_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ga banha dhupal ŋäkulam bilanyawuyma bala dhupal guŋnharrumanan banha ganybum bala dhuṉḏaynha yana malthuwanan nhangu. ");
INSERT INTO dhg_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ga bitjan bala nhan Djesu ŋarran ga nhäŋal nhan Djibidiwun yothuny wulanynha. Ga wakinma banha wäwaꞌmiŋum yäku Djayim ga guthaꞌmiŋum nhangu yäku ga Djon. Ga bitjanya ḻinygu dhupalim gayŋan ganybu dhuṉḏaykuwan marthaŋayŋa. ");
INSERT INTO dhg_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Bala nhan Djesum guykuyyuwanan dhupaliŋgu bitjanan, “Way, gu malthuwan wulay nyäkun!” Bala yana dhupal guŋnharrumanan dhupaliŋguway moriꞌmiŋunham ga djämaminham warrany balayan marthaŋayḻin. Bala dhupal ŋarranan malthuwanan nhangu. ");
INSERT INTO dhg_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Bala dhanal waythuwanan ŋunhalan Gapuniyamnha waŋgalaŋa, nhan Djesu ga banhaya yolŋu warra banha dhanal gayŋan bämaraꞌyuwan nhanany. Ga Nyenanharamiyun Waluyu, nhan Djesum ŋarranan balan Djuwwuḻ biryamiḻin buṉbuḻi, nhan ŋarru gayŋa marŋgiyumana dhanaliny banhalayan. ");
INSERT INTO dhg_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ga banha gayŋan yolŋuyum warrayu bitjuwayiŋ ŋäkulam nhanany garrundam, ṉirruwanan, ḻinygu nhan banha marŋgin bitjuwayiŋ marimin bayikuyam mala dhäwuꞌwu. Ga djuḻkthumana gayŋa banha Djuwwum rom-marŋgikunhamiwu warrawu marŋgiyumanda. ");
INSERT INTO dhg_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ga bilanyamiyu ḻinygu nhanmam yolŋu barrakinymi birrimbirrmi gulŋiyan balaya biryamiḻi buṉbuḻi ŋarru dhä-rirrakaymin, ");
INSERT INTO dhg_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","yatjuwan ŋarran bitjan, “Wäy, Djesu ŋirrima Nätjuritjpuy, nhä nhunu rälim gämurruꞌ ŋupan? Nhalpiyana nhunu ŋarru, baḏuwaḏuyuna ŋanapiliny ŋatja? Ŋanapum dhaŋu dharaŋganatj nhuna, nhunum dhaŋu banhayan banha Maŋutji-yunupayumanda yolŋu God-Waŋarrwuŋun dhawuꞌ-nhinathuŋganda ŋätjiliŋuwuynha. Nhunum dhaŋu God-Waŋarrwun banha Dharrpalnha Yolŋu, nhänharran.” ");
INSERT INTO dhg_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Bala nhan Djesum yän-guŋanminan, dhaykuwanan manapan nhanany bitjanan, “Maꞌ mukthuwan, ga walmiyan djinakuḻiyam yolŋuwuru!” ");
INSERT INTO dhg_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Bala nhan bayiŋuya barrakinydhum birrimbirryu rurrꞌrurryuwanan banhaya yolŋunham mariminan yana. Bala yana nhan banha dhawaṯthuwanam dhä-rirrakaymin. ");
INSERT INTO dhg_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ga yolŋuyum warrayu banha banhalayam biryamiŋam buṉbuŋa nhäŋalam mä-maŋmaŋdhuwanan. Bala dhanal ŋarran garrunminan bitjanan, “Nhä dhaŋum? Dhaŋu nhan gayŋa yän-ŋayathan ŋunha barrakinygu birrimbirrwu dhawaṯthumandawu, ga dhanalim gayŋa nhanany ŋunha yänma warraṯthuna yana. Nhän nhan gayŋan dhaŋu ŋalmaliny yuṯan romma marŋgikum?” ");
INSERT INTO dhg_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Bala gayŋan banha dhäwum ŋarranan ḻatjuwarrꞌyuwanan banhalayam makaŋa ŋirrimaŋa Galalim. Yolŋum warra ŋarran banha rakaranhaminan. ");
INSERT INTO dhg_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ga banha dhanal ŋarran dhawayawaṯthuwanam bewaḻim banha biryamiŋurum buṉbuŋuru, bala nhan Djesum ŋarran balan Djäymanguḻin ga Wanduruwuḻin ŋirrimaḻi. ");
INSERT INTO dhg_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ga banhalaya gayŋan Djäymangu mukulꞌmiŋu rumaruꞌ rirrikthuwan gorrmurꞌyu. Ga banha nhan Djesu ga guyurrꞌmiŋu warra nhangu gulŋiyanam, bala nhanmam baya yolŋu gätthuwan bala rakaranan bitjanan, “Dhaŋu nyin worruŋu rirrikthun gorrmurꞌyu.” ");
INSERT INTO dhg_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Bala nhan Djesum ŋarranan balayan banha baṯamiwuḻin, bala ŋayathanan nhanany ŋarambiyan bala ṉakanharamiŋganan. Bala dhuṉḏaynha yana banha gorrmurꞌma winyaꞌyuwanan. Bala nhan banha baṯamim dhawaṯthuwanan bala ŋarran galŋa-rrarrayuwanan ŋathawun dhanaliŋgu. ");
INSERT INTO dhg_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ga banha ŋarran bitjuwayiŋ walum gulŋiyan bala ŋarran banha yolŋuyum warrayu rerriminhan warrany gutjpaꞌ-gutjparruwan ga barrakinyminhan birrimbirrminy yolŋuny warrany balayan Djesuwuḻin ḏukthumandawun. ");
INSERT INTO dhg_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ga guḻkun banha marimin yolŋum warra ḻuŋꞌthuwan balayam buṉbuḻi, be mu gayŋan mala-nhinathuŋganmin. ");
INSERT INTO dhg_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ga guḻkunhan nhan gayŋan banha yolŋunham warrany bitjuwayiŋ ḏukthuman, waripuŋuru waripuŋuru rerriŋuru. Ga ḏukthumanam nhan dhanaliny gayŋan bukmaknhan yana. Ga guḻku nhan gayŋan dhawaṯthuman barrakinyma birrimbirr mala. Ga dhanalim banha barrakinyma birrimbirr mala marŋgiyin nhangu, bala nhan Djesuyum dhurrwara-mukthumanan dhanaliny. ");
INSERT INTO dhg_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ga waripuyun waluyu ŋarru munhamurrun, nhan Djesum bitjuwayiŋ ṉakamanan bala nhan walmanan buṉbuŋurum. Ga ŋarranam nhan banha gänaŋuḻin bukumiŋgandawun mä dhupal ŋarru moriꞌmiŋu nhangu garrunmi. ");
INSERT INTO dhg_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ga banha nhan Djäyman ga waripum banha guyurrꞌmiŋu warra bitjuwayiŋ ḏurruwanam yakurrŋurum bala dhanal gayŋan ranganan nhangu. ");
INSERT INTO dhg_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ga banha dhanal nhanany maḻŋꞌthumanam bala dhanal bitjanan garruwan, “Marrkapmi, guḻkun gayŋa dhaŋu yolŋum warra nhuŋu rangam.” ");
INSERT INTO dhg_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ga nhanmam bitjan dhanaliŋgu ḏämbu-ganitjuman, “Ŋuwakurru dhuwanma. Ŋarru ŋalma ŋarru dhaŋu ŋurruŋum gayŋa ŋarra ḻiwꞌyuman ŋunha waripumurru ŋirrimamurru mala. Dhaŋu banha ŋirrima mala banha ŋarra galkiwatj djingaꞌ-djingaryun. Ḻinygu ŋaya gayŋa djälmiyi ŋaya ŋarru rakaram dhanaliŋgu bitjuwayiŋ Ŋuwakurru Dhäwu, ḻinygu dhuwaniya mu nyäku banha warkma.” ");
INSERT INTO dhg_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ga dhurrwaraŋuru bewaḻiyam, bala nhan gayŋan ŋarranan djuḏuꞌyuwanan Galalimurrun makamurru, mä nhan ŋarran rakaranan dhäwun ŋuwakurrun God-Waŋarrwuruynha ŋunhalayan Djuwwuḻ biryamiŋan buṉbuŋa malaŋuŋa. Ga bitjanya ḻinygu nhan gayŋan banha barrakinyma birrimbirr malany ŋaŋꞌŋaŋdhuwan yolŋuwurum warrawuru. ");
INSERT INTO dhg_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ga bilanyamiyum waluyu yolŋu burrundhiyaꞌmi ŋarran nhanguḻ Djesuwuḻ. Bala nhan bunꞌkumu-djipthuwanan ŋäŋꞌthuwanan guŋgaꞌyundawun bitjanan, “Marrkapmi, guŋgaꞌyuwa nhänany! Ŋayam marŋgi banha nhunu ŋarru dhaŋu burrunhdhiyany rerriny nyäkuru winyaꞌyuman, bayiŋ walꞌŋu nhunum djäl, mä ŋarru gayŋa yolŋum warra nyäku ŋangawulnha biyapulma bitjuwayiŋ milnyaŋꞌthun.” ");
INSERT INTO dhg_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Bala nhan Djesum wuyuwanan nhangu bala ŋarambiyaꞌ djarryuwanan, bala ŋayathanan nhanany bala garruwanan, “Djäl ŋaya dhaŋu, ŋaya ŋarru ḏukthumana nhuna. Ḻinygun nhunu dhaŋu ŋuwatjinan!” ");
INSERT INTO dhg_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ga dhuṉḏaynha yana nhan banha ḏirramum ŋuwatjinan, winyaꞌyuwanan banhaya rerrim nhanguru. ");
INSERT INTO dhg_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ga garruwan nhan Djesu wanyuyu yändhu bala yänguwanan nhanany ŋirrimaḻin, ");
INSERT INTO dhg_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","bitjanan, “Ŋuwatjuma yana guyaŋiyam! Ḻinygun nhunu dhaŋu ŋuwatjinan ga ŋangawulnha nhunu ŋarru rakaramam yolŋuwuḻim warrawuḻ. Bayikuya ḻinygu yana mala-ŋurrkanhayŋuwu Mawtjitjku romgum malthuwa banha ŋätjiliŋuwu. Bala ŋatjil ŋurruŋum maŋgarra ŋunha ḏalkarramiwuḻ yolŋuwuḻ ga nhän ŋarru nhuna dhuwan rumbal bitjuwayiŋ nhäma banha nhuŋu rerrim gulitjnha yana winyaꞌyuwan. Bala nhunu ŋarru mundhurrnha guŋan buku-wuŋana, mä ŋarru banha bukmaknha yolŋum warra bitjuwayiŋ marŋgiyi banha nhunu dhuwan ŋuwakurrun.” ");
INSERT INTO dhg_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ga banha nhan banhaya yolŋu bitjuwayiŋ dhawaṯthuwanam bala nhan ŋarran ḻiwꞌyumanan warri rakaranam dhäwum bawalamiŋan ŋirrimaŋam. Ga guḻkun gayŋan banha yolŋum warra bitjuwayiŋ ranganam nhangu Djesuwum. Ga ŋangawulnha banha nhanbayim ŋarran ŋunha yolŋu guḻkumiḻim ŋirrimaḻi ḻinygu banha yolŋuyum warrayu nhanany bitjuwayiŋ djorkuwanan, banham nhan gayŋan banhalayan bäyman bitjuwayiŋ wirwiryuwanam ŋayilpiꞌŋan waŋgalaŋam. Ŋarru gayŋan banha yolŋum warra ŋaykan rangan yana, nhänharawu gayŋan djälmiyin nhangu. ");
INSERT INTO dhg_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ga bilaŋ nhämunhaꞌ bitjuwayiŋ walu djuḻkthuwan, bala nhan Djesum ḏirruwanya bala Gapuniyamḻi. Ga yolŋum warra ŋarran banha rakaranhaminan Djesunham banha nhan gayŋan ḻinygun banhalayan bitjuwayiŋ ŋirrimaŋam nyenan. ");
INSERT INTO dhg_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ga yolŋum warra ŋarran ḻuŋꞌthuwanam bawalamiŋurun. Ga gulŋiyan ŋarran ga dhaŋaŋ, be mu gayŋan malaꞌyuwan, dhurrwaramurrum ŋaṉbawꞌyuwan. Bala nhan Djesuyum gayŋan marŋgikuwanan dhäwun rakaran God-Waŋarrwuruynha ŋayaŋuwuy. ");
INSERT INTO dhg_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ga banha nhan gayŋan baḏak bitjuwayiŋ garruwan, dhanalim ḏämbunharrayum yolŋuyu gayŋan gutjparruwan gaṉuŋnhan yolŋuny balaya Djesuwuḻ. ");
INSERT INTO dhg_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ga ḻinygun banha guḻkun marimin bitjuwayiŋ yolŋum warra gayŋan mala-nhinathuŋganmin banhalayam, ga ŋangawulnha banha bitjuwayiŋ dhanaliŋgum batjiwarr ŋalawitjan dhanal ŋarru yolŋuny banhaya gutjparrun Djesuwuḻ. Bala dhanal ŋalthuwanan ŋunha ŋapaḻin balaꞌpalaḻi bala ŋarŋgan dhanal warkthuwan ŋunhalam garramatꞌma dhuṉḏay yana ŋalaŋa gayŋan Djesu dhäyan. Ga banha ŋunha balaꞌpalam bitjuwayiŋ ḻapthuwan bala dhanal yarrupthumanan banha yolŋunham gayanhꞌthaminhan. ");
INSERT INTO dhg_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ga banha nhan Djesuyum dhanaliny nhäŋal bala nhan yana marŋgiyinan banha dhanal gayŋan gulitj yana nhanguḻ mä-wulitjmiyin. Bala nhan banha gaṉuŋguḻim yolŋuwuḻ bitjanan garruwan, “Ḻinygun ŋaya dhaŋu nhuŋgu barrakinyma rom baya-rakaranan.” ");
INSERT INTO dhg_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ga banhalaya gayŋan ŋaḻapaḻmi Rom-marŋgikunhami yolŋu warra ḏäpthuwan. Ga banha dhanal ŋäkulam Djesunham bilanyawuyma garrunda bala dhanal ŋayaŋum barrakinydjinan, ŋangawulnha dhanal galŋa-ŋuwatjin bayiŋuyam. ");
INSERT INTO dhg_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Bala dhanal bitjanan garrunmin, “Nhä nhan dhaŋu goṉanharran bilanyawum garrundawu. Dhaŋu bayiŋ gayŋa nhanbay yana God-Waŋarryu yolŋuwum warrawu baya-rakaram barrakinybuyma rombuy. Nhalpiyan nhan gayŋa dhaŋu guyaŋinyaramim, yana warri nhan dhaŋu rrambaŋin dhupalin God-Waŋarrnha? Dhaŋum nhan dhä-waripuŋuyinan bitjanam!” ");
INSERT INTO dhg_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ŋarru nhanmam banha Djesum dhanaliŋgu marŋgiyin, bala nhan bitjanan garruwan, “Ŋangawul warra bitjaya guyaŋiya! ");
INSERT INTO dhg_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","10","Nhalpiyan dhika ŋaya ŋarru garrunma? Bayiŋ ŋaya ŋarru bitjanma, ‘Maꞌ, ḻinygun ŋaya nhuŋgu barrakinyma baya-rakaranan’, nhumam dhaŋu ŋangawul marŋgi banha ŋarru bitjanyam maḻŋꞌthun, wilak ŋangawulnha. Ga banha ŋaya ŋarru garrun bitjanma, ‘Maꞌ warraṯthuwan nhuŋguway dhuwan gayanhꞌtham bala maŋgarran ŋirrimaḻin’, ga ŋärrun nhuma ŋarru banha nhämam banha ŋayam dhaŋu Gulitjŋum walꞌŋu Yolŋu dhaŋun. Ga ŋaya mu gayŋa dhaŋu ganydjarrma ŋayathan baya-rakaranhawum yolŋuwum warrawu barrakinygum.” ");
INSERT INTO dhg_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Ga dhurrwaraŋuru bewaḻiyam bala nhan Djesuyum garruwanan banhaya gaṉuŋnham yolŋuny bitjanan, “Yo, ŋäkan! Dhaŋum nhunu ḻinygun bitjuwayiŋ ḏukthuwanan, gatjuy, ṉakaman ga warraṯthuwan nhuŋguway gayanhꞌtham bala maŋgarran waŋgalaḻin.” ");
INSERT INTO dhg_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ga banha nhan bayiŋuya yolŋuyu ŋäkulam, bala yana nhan ṉakamanan. Ga gayanhꞌtha nhan nhanguway warraṯthuwan bala yana ŋarranan dhawaṯthuwanan. Ga dhanalim banha yolŋuyum warrayu nhäŋalam maŋutji-dhawaṯthuwanan, ganyimꞌthuwanan manapan bitjanan, “Dhaŋum ŋanapu gäthuran djinaŋun djunama bilanyawuyma nhäŋal. Gulitj yana nhan dhaŋu God-Waŋarrma ganydjarr murrukay.” ");
INSERT INTO dhg_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ga bewaḻiyam nhan Djesu biyapulya bitjuwayiŋ ŋarran raŋiḻin Galaliḻin guḻunꞌḻi. Ga guḻku banha yolŋum warra gumurr-gätthuwanam nhangu bala nhan gayŋan rakaranan dhanaliŋguḻ God-Waŋarrwun ŋayaŋu. ");
INSERT INTO dhg_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ga banhalaya gayŋan yolŋu nyenan yäku Lebay, Yalpiyatjku gäthu'miŋu. Ga warkthuwanam nhan gayŋan banha molu-rrupiya ḻuŋ'thuman yäku tax banha Rawumbuywu gapmangu. Ga banha nhan ŋarran Djesu bala gätthuwanam, bala nhan nhäŋalan Lebaynhan. Bala nhan bitjanan garruwan, “Wäy wälaŋ, gu malthuwan nyäku!” Ga banha nhan Djesuny bilanyawuyma ŋäkul, bala nhan Lebayma ṉakamanam bala dhuṉḏaynha yana malthuwanan nhangu. ");
INSERT INTO dhg_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ga bewaḻiyam bala nhan Djesum ga guyurrꞌmiŋum warra nhangu gayŋan nyenan banhalayan Lebaywuḻim ŋirrimaŋa, rrambaŋin dhanalin ḻunduꞌmiŋun warra nhangu Lebaywu banha rrupiya-wapthumandamin warra. Ga waripum gayŋan banhalaya yolŋu warra nyenan banha bayiŋ gayŋa Djuw malayu dhanaliny rakaram banha dhanal raypirri-waḏatjmin. Ga ŋunhalaya ḻinygu ŋurrukŋa gayŋan ḏäpthuwan yolŋu warra banha dhanal bayiŋ gayŋa djälmiyi bitjuwayiŋ buthuru-bitjundawu nhangu Djesuwu. ");
INSERT INTO dhg_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ga bilanyamiyu banhalaya gayŋan nyenan rom-marŋgikunhami warra Baratjiwuru ŋurrukŋuru. Bala dhanal nhäŋalan nhanany Djesunham nhan gayŋan ŋatha bitjuwayiŋ guwaman bayikuḻya banha tax djämamiwuḻ warrawuḻ ga dhuwurr-barrakinymiwuḻ yolŋuwuḻ warrawuḻ. Bala dhanal ŋäŋꞌthuwanan banha guyurrꞌmiŋunham warrany bitjanan, “Nhäwu gayŋa ŋunha nhumaliŋgum marŋgikunhami nyena tax djämamiwuḻim warrawuḻ ga dhuwurr-barrakinymiwuḻim yolŋuwuḻ warrawuḻ?” ");
INSERT INTO dhg_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ga nhanmam banha Djesuyum dhanaliny ŋäkul, bala nhan bitjanan dhanaliŋgu garruwan, “Rerrimi yana yolŋu warra ŋarru ŋarra marrŋgitjkuḻim, ŋangawul ḏäwalamim. Ŋayam dhaŋu ŋarran rälim barrakinymiwu yolŋuwu warrawu, ŋangawul bayikuyam yolŋuwu banha dhanal bayiŋ gayŋa be rom-dhunupa rakaranhamim.” ");
INSERT INTO dhg_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Waŋganymiyum, yolŋu warra Baratjiwuru ŋurrukŋuru gayŋan ŋoy-ŋathanharramin nyenan yana bayiŋ romgun malthuwan. Yo, ga nhäŋal dhanal Djongu banha Ḏämbu-Ḻupthumandamiwu malthundaminy warrany dhanal gayŋan bitjanya ḻinygu ŋoy-ŋathanharrami nyenan. Ga ŋangawul dhanal banha Djesuwum guyurrꞌmiŋuny warrany nhäŋal bilanyaḻim bitjuwayiŋ. Bala banha yolŋum warra waythuwanan nhangu Djesuwum bala dhä-wirrkaꞌyuwanan bitjanan, “Wäy, ŋanapum bayiŋ gayŋa dhaŋu ŋoy-ŋathanharrami nyena, romgu bitjuwayiŋ malthun. Ga ŋunha gayŋa Djongum malthundami warra bitjanya ḻinygu. Ga nhäwu bayiŋ gayŋa banha nhuŋgum guyurrꞌmiŋu warra ŋangawulma bitjanya nyena?” ");
INSERT INTO dhg_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Bala nhan Djesuyum mayaḻiꞌmin dhäwu rakaran bitjanan, “Ḻinygu mu nhuma dhaŋu marŋgi: Banha bayiŋ yolŋu wulay bitjuwayiŋ warraṯthunmi, ga yolŋum warra bayiŋ banha ŋangawul dhurrwara-yupthu ŋathaŋurum, banham dhanal bayiŋ ŋarra ŋatham guwaman mu maranhukunharami. Ga banhaya ḏirramu banha nhan ŋarru warraṯthun baṯaminy nhanguway, banha nhan ŋarru gayŋa banhalayam nyena, banham ŋarru gayŋa yolŋuyum warrayu ŋatham guwaman mu. ");
INSERT INTO dhg_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ga banha nhan ŋarru banhayany ḏirramuny bitjuwayiŋ djakawarruna, bala ŋarru banha ḻunduꞌmiŋum warra nhangu ŋayaŋu-barrakinydjin ga ŋärrun dhanal ŋarru gayŋa ŋoy-ŋathanharramim nyena.” ");
INSERT INTO dhg_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Bala nhan Djesuyum waripun dhäwu dhanaliŋgu rakaran mayaliꞌmi, “Ŋangawul ŋarru dhaŋu yolŋuyu dhamin-yarpum yuṯa bitjuwayiŋ manydjarrkaꞌ ŋunha ŋätjiliŋuḻ manapan. Ḻinygu yalala nhan ŋarru banha girrimꞌ rurrwuyun, bala ŋarru banha yuṯam manydjarrkaꞌ dhurŋꞌthuna yutjuwaḻyin, bala ŋarru banha girrimꞌ bitjuwayiŋ barruna. ");
INSERT INTO dhg_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ga bilanya ḻinygu: Ŋangawul ŋarru dhaŋu yuṯa borum wiyikaꞌ rarrun ŋunha ŋätjiliŋuḻ yilipiḻ, ḻinygu nhan ŋarru banha barruna bala ŋarru wiyikamꞌ gätthuna. Yuṯam borum wiyikaꞌ ŋarru rarrun yuṯaḻ yana yilipiḻ.” Bitjan nhan gayŋan banha dhanaliŋgu Djesuyum rakaran, banha nhanguŋum yuṯam marŋgiyumanda ŋarru ŋangawulnha maŋutji-manapan balam banha nhä bayiŋ dhanal gayŋa Baratjiyu warrayu marŋgiyuman. ");
INSERT INTO dhg_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Waŋganymiyu Nyenanharamiyu Waluyu Djesu ga guyurrꞌmiŋu warra nhangu ŋarran ŋaykan batjiwarr-ŋupan, ŋarru gätnimurru berrathamimurru. Bala nhanguru ŋarran guyurrꞌmiŋuyum warrayu ganitjumanan muḻkurrnha ŋathan bala ŋarran guwamanan, ḻinygu dhanal djaṉŋarryin. ");
INSERT INTO dhg_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ga dhanalim banha Baratjiyum yolŋuyu warrayu nhäŋal dhanaliny, bala bitjanan rakaran Djesuwuḻim, “Nhäwu gayŋa dhaŋu nhuŋgurum guyurrꞌmiŋuyu warrayu romma ŋalmaliŋgu ganitjuman? Dhaŋu dhanal ŋarra ŋatha ŋunha wapthuman djinaŋ warri Nyenanharamiyun Waluyu. Ŋangawul dhanal ŋarru gayŋa bitjan!” ");
INSERT INTO dhg_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Bala nhan dhanaliŋgu ḏämbu-wanitjumanan, “Wäy, waraparra, guyaŋi mu nhuma gayŋa banhayam dhäwu banha bilinyamiyu waluyu banha Ḻiya-ŋärraꞌmi yäku Yabithaya gayŋan nyenan? Ga dhanalim banha Daybitma ga malthundamim warra nhangu djaṉŋarryinan bala dhanal yana ŋaykanan bala gulŋiyanan balayan Djuwwuḻin biryamiḻin warrawꞌḻi bala dhanal ŋarran wapthumanan banha ŋatham. Ga rom gayŋan barraŋgaꞌyuwan banha ŋarru ḏalkarramiyun yana guwaman banhayam ŋatha, ŋangawulnha bitjuwayiŋ bukmakthum. Ga nhanmam banha Daybitthum ga malayum nhanguru guwaman yana ga ŋangawul dhanaliny banha yolŋuyum warrayu bitjuwayiŋ rom-nyamirꞌyuwan.” ");
INSERT INTO dhg_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ga biyapul nhan Djesu bitjan garruwan, “Wäy waraparra, yaka warra meṉguŋ, banha God-Waŋarryum Nyenanharamim Walu djäma guŋgaꞌyundawu yolŋuwu. Ŋangawul nhan banha yolŋuny djäma nhan ŋarru gayŋa bayikuyan ḻinygu yana Nyenanharamiwun Waluwu romgu malthun. ");
INSERT INTO dhg_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ḻinygu ŋayam dhaŋu Gulitjŋum Walꞌŋu Yolŋu, nyäkuwaynha dhaŋu dhunupam bitjuwayiŋ ŋaya ŋarru garrun yolŋuny nhä nhan ŋarru djäma, wo ŋangawul nhan ŋarru djäma bilanyayu Nyenanharamiyu Waluyu.” ");
INSERT INTO dhg_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ga bewaḻiyam nhan Djesu ḏirruwanan balan Djuwwuḻin biryamiḻin buṉbuḻi. Ga ŋunhalayam nhan maḻŋꞌthuman yolŋuny ŋarru ŋarambiya-dhoṯnhan. ");
INSERT INTO dhg_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ga banhalaya gayŋan Baratji ŋaḻapaḻmi djingaꞌdjingaryuwan ga dharr-witjan dhanal gayŋan nhäŋal Djesuny ŋala nhan ŋarru ḏukthuman yolŋuny Nyenanharamiyu Waluy mä dhanal ŋarru nhangu bayikuwuynha Djesuwum bitjuwayiŋ mari-waythun. ");
INSERT INTO dhg_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Bala nhan Djesum guykuyuwanan bayikuya ŋarambiya-dhoṯkum yolŋuwu bitjanan, “Gu ṉakama räli, djinal djingaryuwa gumurrŋa, mä ŋarru bukmakthu yana nhämam.” ");
INSERT INTO dhg_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Bala nhan Djesum garruwanan bayikuya Baratjiwum yolŋuwu warrawu bitjanan, “Nhalpiyan gayŋa ŋalmaliŋgum romma garrun djinakum banha Nyenanharamiwum Waluwu? Nhä mu dhaŋu dhuṉḏay ŋalma ŋarru ŋuwakurru djäma yolŋuwu warrawu bilanyayu waluyu, wo ŋalma ŋarru gayŋa barrakinynha djäma? Nhalpiyan ŋayam ŋarru yolŋunham wälŋayuman, wo nhalpiyana guwatharaman murrkay'yumana, ŋatja?” Ga dhanalim banha Baratjim warra nhangu ŋangawulnha bitjuwayiŋ ḏämbu-ganitjuman. ");
INSERT INTO dhg_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Bala nhan Djesuyum gayŋan yolŋunham warrany nhäŋalan, ga mariminan nhan banha dhanaliŋgu maḏakarritjtjinam ga warwuyuwanan manapan ḻinygu dhanal banha ŋayaŋu-wanyumin. Banham dhanal gayŋan romgun yana bitjuwayiŋ dhanaliŋguwaywuru mariminam malthuwan. Bala nhan Djesum garruwan bayikuya ŋarambiya-dhoṯkum bitjanan, “Maꞌ ŋarambiya djarruwan!” Bala nhan banha yolŋum ŋarambiya djarruwanam bala nhan banha ŋuwatjinan dhuṉḏayyinan yana. ");
INSERT INTO dhg_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Bala banha Baratjim yolŋu warra ŋaykanan ḻatjuwarrꞌyuwanan, ga ŋunhalan bala dhanal ḻuŋꞌthumanminam waripun yolŋu warra, Geŋ-Yaritkun ŋaḻapaḻmi gämurruꞌ-warrundayŋun mala. Ga banhalayan dhanal gayŋan banha garrunminam guwatharanharawum nhangu Djesuwum. ");
INSERT INTO dhg_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Waŋganydhum waluyu nhan Djesu ga guyurrꞌmiŋu warra nhangu ŋarran ŋunha murrukayḻin guḻunꞌli Galaliḻin. Ga guḻkun banha yolŋum warra nhangu malthuwan ḻinygu dhanal ŋäkul banha nhä nhan gayŋan Djesuyu bitjuwayiŋ djäma. Ga yolŋum warra banha ŋaykan bewaḻi Galaliŋuru makaŋuru ga Djudiyaŋuru makaŋuru ga Yidumiyaŋuru makaŋuru. Ga waripum banha yolŋu warra ŋirrimbuwan beŋurun ŋirrimaŋuru Djurutjalamŋurun ga Djaydanŋurun ga Däyaŋurun. Ga guḻku waripu yolŋu warra ŋaykan bewaḻi Djodanŋurun mayaŋꞌŋuru ŋarru gali dhimurruŋurun. Ga bukmak dhanal gayŋan banha ḏukṯukmiyin dhanal ŋarru dhanaliway yana nhäma nhanany Djesuny. ");
INSERT INTO dhg_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Ga guḻkunhan nhan gayŋan banha Djesuyum ḏukthuman bilanyamiyuyam waluyu, ga guḻku yolŋu warra gayŋan ḏukṯukmiyin dhanal ŋarru nhanany ŋayathan, mä dhanal ŋarru ŋuwatji. Bala ŋarran banha yolŋum warra giṯthuwanan, ḏurꞌṯuryunminan ŋarran ŋunha galkin yanan nhangurumurrun, bala nhan garruwanan nhanguwaywuru guyurrꞌmiŋuwum warrawu bitjanan, “Marthaŋay warra nyäkuḻ warraṯthuwa, ḻinygu ŋangawulyinan dhaŋu dhaḻakarrma nyäkum. Banha ŋarru dhaŋu yolŋuyum warrayu nhänany djorkumam, ŋayam ŋarru marthaŋayḻin ŋalthun.” ");
INSERT INTO dhg_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ga waripum banha yolŋu warra banhambal ŋirrimbuwan barrakinymin birrimbirrmi mala. Ga banha dhanal bayiŋuya yolŋuyu warrayu nhäŋal bitjuwayiŋ Djesunham, bala gayŋan banha birrimbirryum mala djalkthuwanan banha yolŋunham warrany munathaꞌḻin bala gayŋan yatjuwanan bitjanan, “Nhunum dhaŋu God-Waŋarrwu Gäthuꞌmiŋu.” ");
INSERT INTO dhg_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ŋarru nhanmam banha dhanaliny dhurrwara-mukthuman bitjan, “Ŋangawul nhuma ŋarru dhaŋu yolŋuwuḻim warrawuḻ rakaram, yol Ŋaya dhaŋu!” ");
INSERT INTO dhg_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Bala nhan Djesum ŋarranan bukuḻin ŋalthuwan bala guykuyyuwanan yolŋuwun ḏirramuwun warrawu banha dhanaliŋgu ŋayaŋu bitjuwayiŋ dhä-manapan nhanguḻ Djesuwuḻ, malthundawun nhangu. ");
INSERT INTO dhg_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ga djarrꞌyuwanam nhan banha 12-nha ḏirramunham warrany mä dhanal ŋarru gayŋa nhangu malthuna yana bitjana ḻinygu, dhaŋum djuyꞌyundan warra nhangu. Ga ŋarran dhanal ŋarru gayŋa bawalamiḻin ŋirrimaḻi dhäwun ŋarra rakaram God-Waŋarrwuruynha yolŋuwuḻin warrawuḻ. ");
INSERT INTO dhg_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ga guŋan nhan dhanaliny ganydjarr, mä dhanal ŋarru gayŋa barrakinynha birrimbirr mala dhawaṯthuman yolŋuwurun warrawuḻ. ");
INSERT INTO dhg_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Ga dhaŋu banha yolŋum warra gamꞌ: Djäyman (banha Djesuyu nhanany yäku nhinathuŋgan Beta) ga Djayim ga Djon, dhaŋum wulay Djipitiwun gäthuꞌmiŋu wulay. (Ga Djesuyum dhupaliny waripun yäku guŋan, ‘Bawanatjitjnha’ mayaliꞌ ‘Murryuꞌmurryundamin’.) ga Yanduru ga Bilip ga Bäthalamiyaw ga Mathuyu ga Dumitj ga Djayim (Yalpiyatjku gäthuꞌmiŋu) ga Dhadayatj ga Djäyman, (banha nhan gayŋan malthuwan Djalatkun malawu) ga Djudatj Gariyatnha (nhännha banha dhaŋun yolŋu mulkuruyin Djesuwum.) ");
INSERT INTO dhg_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yo, bala nhan Djesum ga guyurrꞌmiŋum warra nhangu yarruyarrupthuwanan bukuŋurum. Martjmartjtjuwanam dhanal bala buṉbuḻin gulŋiꞌ-gulŋiyan. Ga bitjanya ḻinygu banha yolŋum warra ḻuŋꞌthuwan guḻkun marimin, ga ŋangawulyinan banha walum dhanaliŋgu ŋathawum guwamandawu nhanguway Djesuwum ga guyurrꞌmiŋuwum warrawu nhanguru. ");
INSERT INTO dhg_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ga be yol yolŋu ŋarran ga rakaran nhanguḻ gurruṯumiwuḻ warrawuḻ, “Gu ŋunha ŋarra Djesum bawaꞌyuna, djämayun, malaŋuyu!” bitjan. Bala banha gurruṯumim warra nhangu ŋirrimbuwanan mä dhanal ŋarru nhanany gaḏaymana ŋirrimaḻin. Dhanal ŋarru gayŋa dhanaliwaynha nhangu bitjuwayiŋ djäka. ");
INSERT INTO dhg_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Manymak, ga rom-marŋgikunhami yolŋu warra waythuwan bewaḻi Djurutjalamŋuru ga bitjanya ḻinygu dhanal Djesuny nhäŋal, bala bitjanan dhanal garruwan, “Way, waraparra, ŋangawul nhuma ŋarru gayŋa djinakum malthun, ḻinygu ganydjarrma nhan bayiŋ gayŋa dhaŋu warraṯthunma Djaytinguŋ banha nhan buŋgawan bitjuwayiŋ barrakinygun birrimbirrwu malaŋuwu, ga waripum nhan banha yäku Beltjibulnha. Ga bilanyawuyan nhan bayiŋ gayŋa dhaŋu barrakinynham birrimbirrnha malaŋuny walmaranhamiŋgan.” ");
INSERT INTO dhg_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ga nhanmam banha Djesum marŋgiyin banha nhalpiyan dhanal gayŋan garruwan, bala nhan guykuyyuwanan dhanaliŋgu, “Gu, räli warra maŋgarra ga buthuru-witjuwa warra nyäku,” bitjan. Bala nhan dhanaliŋgu dhäwun rakaran mä buḻarryumanan. Ga bitjan nhan garruwanam gamꞌ, “Nhalpiyana nhan ŋarru banha Djaytindhum guwatharam Djaytinnham yana? Dhuwanma mayaliꞌnharran rom. ");
INSERT INTO dhg_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ga ŋäka warra! Banha ŋarru gayŋa yolŋu warra guwatharanharami waŋganybuyma ŋirrimawuy, dhanalim ŋarru ganydjarrnharrayin bala ŋarru malam dhawarꞌyuna. ");
INSERT INTO dhg_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ga banha ŋarru gayŋa waŋgany bäpurru yolŋu warra bitjan ḻinygu guwatharanharami, bala ŋarru banha yolŋum warra gurruṯumim bärrkuwaḻyin malam, bala ŋarru dhawarꞌyuna. ");
INSERT INTO dhg_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ga bilanyaya ḻinygu, banha ŋarru gayŋa Djaytindhum guwatharam malanham nhanguway, bala ŋarru banha bukmaknha yana dhanal ganydjarrnharriyim bala ŋarru ŋangawulyin, dhawarꞌyuna ŋarru! ");
INSERT INTO dhg_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ga ŋäkan warra dhaŋum mayaliꞌmin dhäwu ŋaya ŋarru rakaram: Waŋgany yolŋu ḏukṯukmiyin nhan ŋarru girriꞌ manaŋi bewaḻi wanyuwuru yolŋuwuru. Ga ŋurruŋum ŋatjil nhan mataꞌyuman banhayam wanyunham yolŋuny, ga ŋärrun nhan girrimꞌ malany nhangu wapthuman. Yo, dhaŋu nhan banha mayalimꞌ gamꞌ djinalaŋam dhäwuŋa: Djaytinma, nhän banhaya wanyu yolŋu, ga ŋayam banha waripun yolŋu banha nhan mataꞌyumanan nhanany, banhayam ŋayan Djesun. Ga djinaŋum bala ŋaya ŋarra wapthumana nyäkuwayma yolŋuny warrany bewaḻim nhangurum goŋŋuru. ");
INSERT INTO dhg_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Dhaŋum waripun gulitjnha yana yän ŋaya ŋarru rakaram: Bayiŋ nhunu ŋarru barrakinydjuman garrun nhangu God-Waŋarrwu, wilak nhan ŋarru God-Waŋarryum nhuŋgu baya-rakaram. ");
INSERT INTO dhg_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ga bayiŋ ŋarru nhunu barrakinydjuman garrun nhangun Dhuyu-Birrimbirrwun, nhanmam ŋarru banha God-Waŋarryum ŋangawulnha nhuŋgum baya-rakaram, ga yanatj ḻinygu-u-u ga waŋgala ŋarru barkthu dhaŋu dhä-yawarꞌyu!” ");
INSERT INTO dhg_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ga bitjanam nhan banha Djesu garruwan ḻinygu dhanal nhangu banha bitjan garruwan, “Dhaŋum yolŋu barrakinymi birrimbirrmi.” ");
INSERT INTO dhg_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ga bewaḻiyam Djesuwu ŋäṉḏiꞌmiŋum ga guthaꞌmiŋum warra nhangu ranganan. Bala dhanal gayŋan djingaꞌ-djingaryuwanan warraŋulnha banhalaya buṉbuŋa banha ŋalaŋa nhan gayŋan marŋgikuwan yolŋuny warrany. Ga yänguwan dhanal yolŋuny gaḏaymandawu nhangu Djesuwu. ");
INSERT INTO dhg_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ga bilanyamiyum nhanmam gayŋan banha Djesuyum marŋgikuwanan bitjuwayiŋ yolŋunhan warrany. Bala banha yolŋum ŋarranan, bala bitjanan garruwan, “Dhaŋu ŋäṉḏiꞌmiŋu nhuŋgu ga guthaꞌmiŋu warra rangam gayŋa nhuŋgu,” bitjan. ");
INSERT INTO dhg_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Bala nhan Djesum bitjanan garruwan, “Yol warra dhika nyäkum gurruṯumi?” ");
INSERT INTO dhg_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Bala nhan ŋarran nhäŋalan ḻiwꞌyumanan banhaya yolŋunhan warrany banha ŋarran ḏäpthuwan. Bala nhan bitjanan garruwan, “Dhaŋuy warra dhaŋu nyäkum ŋäṉḏiꞌmiŋu ga guthaꞌmiŋu warra. ");
INSERT INTO dhg_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Banha nhan ŋunhuŋ yol yolŋu ŋayaŋu-malthundami God-Waŋarrwurum ŋayaŋuwu, banhayan nhan nyäkum walꞌŋu galkiwuyma gurruṯumi.” ");
INSERT INTO dhg_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Waŋganymim nhan Djesu balaya ḏirruwan Galaliḻin. Ga guḻkun dhika marimin yolŋum warra ḻuŋꞌthuwan nhanguḻ balayam. Bala nhanmam banha marthaŋayḻin ŋalthuwan, ga gaŋga yana yarrkyarrkthuman marthaŋayma, bala nyenanan ga bewaḻiyan nhan gayŋan banha dhäwum dhanaliŋgu bitjuwayiŋ rakaran, marŋgikuwanam dhanaliny. ");
INSERT INTO dhg_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ga guḻku nhan gayŋan banha dhäwum mayaliꞌmiŋganam rakaran, mä dhanalim banha yolŋuyum warrayu dharaŋgan yana. ");
INSERT INTO dhg_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Yo, ŋäkan warra: Waŋgany yolŋu djälmiyin nhan ŋarru maŋutji ŋatha djalkthun ŋunha munathaḻꞌ mä ŋarru ŋathan ŋuthanma. ");
INSERT INTO dhg_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Bala nhan ŋarran djalkthuwanan. Ga waripum banha maŋutji gälkin mä bayiŋ bärrkuḻin, batjiwarrḻin bitjuwayiŋ. Ga dhanalim banha bäwarraṉ'thum nhäŋal bala barrtjuwanan ŋarran guwamanan dhawar'yumanan. ");
INSERT INTO dhg_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ga baḏaknha nhanmam ŋarran bala bayiŋuya yolŋuyum maŋutjim djalkthuwan, waripum ŋarran gälkin bitjanan bala, ga waripum gälkin ṉutjurrumiḻin ŋirrimaḻi. ");
INSERT INTO dhg_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ga ŋatham banha maŋutjim ŋuwatjinan ŋuthan waḏutjan, ga banha nhan walum bitjuwayiŋ gorrmurꞌyin mariminam bala banha ḏukitjma baṉḏanydjinan, guwaruwanan, bala waŋayinan, ḻinygu ṉutjurrun yana banha, ga ŋangawulnha munathamꞌ. ");
INSERT INTO dhg_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ga mawaŋganynha nhan ŋarran bala banha maŋutjim djalkthuwan, ga waripum banha maŋutji gälkin ḏimirrꞌṯimirrmiḻin. Bala bayiŋuyam banha ḏimirrꞌṯimirryum djorkuwanan, ganydjarrnha dhawarꞌyuman ŋuthandawun. ");
INSERT INTO dhg_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ga waripum banha ŋatha gälkin ŋuwakurruḻin munathaḻꞌ. Bala banha ŋatham ŋuthanan buṯ-bitjanan. Ga banha nhan ŋatham bitjuwayiŋ ŋuwatjin, waŋganybuy ḻoḻuwuy giḻyuwanan gayŋan guḻkun yana marimin dhika. Ga waripuŋa-a-a ga guḻku yana, ga waripuŋa ga bilanya ḻinygu, ga bitjanan bala. ");
INSERT INTO dhg_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Bayiŋ nhuma buthurumim, ŋäkam warra ŋuwatjuman, mä nhuma ŋarru dharaŋgan yana dhaŋum dhäwu.” ");
INSERT INTO dhg_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Bala dhanal ŋaykanan guŋnharrumanan banha guḻkunham yolŋuny warrany. Bala nhan gayŋan Djesum ga guyurrꞌmiŋum warra nhangu, ga waripum yolŋu warra guŋnharran nyenan. Bala dhanal dhä-wirrkaꞌyuwanan nhanany bitjanan, “Gu rakaraŋan ŋanapiliŋgu banhayam malany dhäwu banha nhunu gayŋan rakaran, ḻinygu ŋangawul ŋanapu dharaŋgan. Nhäwuy ḻinygu banha dhäwum malany?” ");
INSERT INTO dhg_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ga nhanmam Djesum garruwan bitjanan, “Nhumaliŋgum djinakum warrawu banha nhuma bayiŋ gayŋa ŋarranharamiŋgan banha God-Waŋarrwu romnha, ŋayam ŋarru warraŋulyumana nhumaliŋguḻ mayalimꞌ. Ga waripuŋuwum yolŋuwu banha dhanal ŋangawul bitjuwayiŋ djinalaŋa gayꞌ malaŋa, dhanalim ŋarru gayŋa banha dhäwun yana ŋäma. ");
INSERT INTO dhg_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Dhaŋu ŋaya ŋarru rakaraman gamꞌ, mä ŋarru banha yänma nhangu God-Waŋarrwum ŋunha wukirriwuyma maḻŋꞌthuna gulitjtjin yana: ‘Yolŋuyum bayiŋ gayŋa banha nhäma nhänany djämaḻim, ŋarru dhanal bayiŋ ŋangawulnha dharaŋganma, nhä banhaya mayaliꞌ. Ga ŋämatj dhanal bayiŋ yulŋum buthuruyum, ŋarru ŋangawulnha dhanal bayiŋ ŋuwaḻyumanma bitjuwayiŋ dharaŋgan. Ga banha dhanal warri mälkuwarram dharaŋgarra, dhanalim warri banha biluwarran ḏirruwarran God-Waŋarrwuḻin. Ŋarru ŋangawul dhanal banha djäl dhanal ŋarru djinakum bitjuwayiŋ dhäwuꞌwu marŋgiyi. Ga nhanmam ŋarru banha God-Waŋarryum ŋangawulnha dhanaliŋgum baya-rakaramam barrakinybuyma rombuy.’” ");
INSERT INTO dhg_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Bala nhan Djesum dhanaliŋgu bitjanan garruwan, “Wäy, buku-djulŋimi, ŋangawul nhuma gayŋa dhaŋu dhäwum dharaŋgan, ŋatja? Ga bayiŋ nhuma ŋarru ŋangawulma bitjuwayiŋ dharaŋgan dhaŋum gumurr-yalŋgim dhäwu, ga nhalpiyana nhuma ŋarru banha dharaŋgan ŋunham bala waripum malany dhäwu? ");
INSERT INTO dhg_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Djinalaŋam dhäwuŋa, yolŋu ŋarran maŋutjiwu lämu-nhinathuŋgandawu. Ga dhaŋum nhan bilanyan, bitjuwayiŋ yolŋu bayiŋ ŋarra bala rakaraman God-Waŋarrwuŋun yän yolŋuwuḻin warrawuḻ. ");
INSERT INTO dhg_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Yo, ga ŋatham nhan banha djalkthuwanam, ga ḻurrkunꞌma banha gälkin ŋunha batjiwarrŋan. Ga batjiwarrma banha wanyun marimin ga ŋangawulnha nhan banha bitjuwayiŋ ŋatham ŋuthan. Manymak, ga bayiŋuyam ŋathayu gayŋa maŋutji-rakaram God-Waŋarrwuŋun yän. Ga ḻurrkunꞌthu yolŋuyu warrayu bayiŋ ŋäma yänma nhangu ŋayaŋuyum wanyuyun, bilanyan bitjuwayiŋ banhaya batjiwarr wanyu. Ga bäwarraṉꞌthum gayŋa maŋutji-rakaram Djaytinnhan banha nhan bayiŋ djakawarruna banhaya yännhan yolŋuwurun ŋayaŋuŋuru. ");
INSERT INTO dhg_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ga banha nhan ŋatha gälkin ṉutjurrumiḻim, bayiŋuyam gayŋa maŋutji-rakaram banhayan yolŋuny banha nhan bayiŋ ŋäma yänma ŋayaŋuyu ŋuwakurruyu bala warraṯthuna yana. ");
INSERT INTO dhg_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Bala bayiŋ waripuyum yolŋuyu nhäman banha nhan bayiŋ banhayam yolŋu mä-wulitjmiyin bayikuyan yängun, bala nhan bayiŋ mari-waythuna nhangu. Bala nhan ŋarru banhayam yolŋum guluna yänŋurum ŋänhaŋuru bala ḏiltji-guŋanmin God-Waŋarrwum ga yängum nhanguru, ḻinygu ŋatham banha maŋutjim ŋangawuḻ bitjuwayiŋ wärrurrꞌma ṉiṉꞌthuwan gulŋiyan. ");
INSERT INTO dhg_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ga banha nhan ŋatha gälkin ḏimirrꞌṯimirrmiḻim, ga gulkurun banha ŋatham bitjuwayiŋ ŋuthan, ḻinygu gayŋan banha barrakinydhun mulmuyum djorkuwan. Ga bayiŋuyam gayŋa maŋutji-rakaram banhayanhan yolŋuny banha dhanal bayiŋ ŋäma God-Waŋarrwum yän, ");
INSERT INTO dhg_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","bala bayiŋ banha waripuyun malaŋuyu djorkumam. Waripun, waripun bayiŋ dhethuŋgan wälŋaḻi, nhäwu dhanal djäl. Ga rrupiyan gayŋa marimim guyaŋi ga be nhäwun warwuyun, guḻkuwun, girriꞌwun. Bala bayiŋ banha djinaŋuyan mala galmuman God-Waŋarrwurum yängu, ga ŋangawulnha nhan ŋarru banha nyena ŋuwatjumanma nhanguwayma yana God-Waŋarrwum. ");
INSERT INTO dhg_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ga djinalam dhäwuŋa, ŋatha banha gälkin ŋuwakurruḻim munathaꞌḻi, banhayam maŋutji ŋuthanan yaŋaraꞌmiyinan ŋuwatjinan, bala ŋathamiyinan. Ga djinaŋum gayŋa maŋutji-rakaram banhayan yolŋuny banha nhan bayiŋ ŋäma God-Waŋarrwum yän bala djämamiŋgana yana. Yo, bilanyan dhanal banha yulŋum nhawun banha waŋganybuy ḻoḻuwuy giḻyuwanan gayŋan guḻkun yana marimin dhika. Ga waripuŋa-a-a ga guḻku yana, ga waripuŋa ga bilanya ḻinygu.” ");
INSERT INTO dhg_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Bala nhan Djesum bitjanan garruwan, “Banha bayiŋ yolŋuyu lanhdhirra dhuŋgurꞌyun, ŋangawul nhan bayiŋ banha banikinꞌthum bitjuwayiŋ dhurrthurryun, ŋatja?... wo ŋoyḻim betḻim dhethuŋgan. Banham nhan ŋarru ŋalthuman ŋunha garramatḻi, mä ŋarru bukmakthu yana nhämam gaykarraŋḻi. ");
INSERT INTO dhg_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ga bilanyayan banha yulŋum God-Waŋarrwurum yängu. Nhä malany gayŋa ŋoya djuḻuḻyunda, banhayam nhanbayin ŋarru God-Waŋarryun yana dhawaṯthumu, bala bukmakma yolŋu warra barkthu bitjuwayiŋ marŋgiyin. ");
INSERT INTO dhg_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Maꞌ, bayiŋ nhunu buthurumim ŋuwatjuman nhänany ŋäkam mä nhunu ŋarru dharaŋgan yana. ");
INSERT INTO dhg_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ga guyaŋiya maŋgarra yänma nhänany. Bayiŋ nhunu ŋarru gayŋa marimim yana nyäku mäkiri-witjun, nhanmam ŋarru God-Waŋarryum nhuŋguḻ guŋana nhanguway dharaŋandamim rom, banham nhunu ŋarru gayŋa dharaŋgana nhäm malany banha ŋuwakurrum marimim. ");
INSERT INTO dhg_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ga bayiŋ nhunu yolŋu djäl marŋgiyinyarawu God-Waŋarrwurum ŋayaŋuwu, nhunum ŋarru yana gaḏamandjin. Ga bayiŋ nhunu ŋarru banha ŋangawulma bitjuwayiŋ ŋayaŋumiyi, nhanmam ŋarru banha gulumana nhuna dharaŋandaŋurun, banhayam nhunu ŋarru dhuŋayin nhangun God-Waŋarrwun.” ");
INSERT INTO dhg_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ga biyapulma nhan Djesu garruwan bitjanan, “Marŋgiyi nhuma ŋarru nhalpiyan ŋarru gayŋa God-Waŋarrwu bitjuwayiŋ gurruṯumi warra ŋuthan. Yo, dhaŋum dhäwu mayaḻiꞌmin: Yolŋu djälmiyin nhan ŋarru ḻämu-nhinathuŋgan maŋutji ŋatha, bala nhan ŋarran banha ŋatham djalkthuwanan munathaꞌḻin, bala guŋnharrumanan banhaya maŋutjim banhambalayan, ga nhanbayim bitjuwayiŋ ŋarranan ŋirrimaḻin. ");
INSERT INTO dhg_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Manymak, munha ga munha bitjuwayiŋ djuḻkthuwan ga ŋangawulnha nhan gayŋan bayiŋuya yolŋuyum guyaŋin banhaya maŋutjim ŋatham. ");
INSERT INTO dhg_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Bala ŋarran banha maŋutjim mala ŋuthanan guŋnharran yana. Yo, bala banha ḏukitjma dhamanyꞌtjuwanan, bitjan ŋarran ŋurru-walman. Ga yaka wikarra, bala yaŋaraꞌmiyinan, ga ŋärrun muḻkurrma ŋathamiyin. ");
INSERT INTO dhg_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ga banha ŋatham bitjuwayiŋ muḻkurrma wanyuyin, bala yolŋum marŋgiyinan banha ŋatham ḻinygun ŋuwatjinan, bala nhan ŋarru ŋarran gulkthundawun bayikuya ŋathawun. Waraparra, God-Waŋarryu dhaŋu nhanbay bayiŋ ŋarra djämam bitjuwayiŋ ŋuthanmaramam.” ");
INSERT INTO dhg_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ga biyapulya nhan Djesuyu rakaran waripun mayaliꞌmi dhäwu bitjan, “Dhaŋu ŋaya gayŋan waripu dhäwu nhumaliŋgu guyaŋin, banha ŋarru nhumaliny guŋgaꞌyun nhuma ŋarru dharaŋgan, nhalpiyan ŋarru gayŋa God-Waŋarrwu gurruṯumi warra ŋuthan. ");
INSERT INTO dhg_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","God-Waŋarrwum dhaŋu gurruṯumi yolŋu warra bilanya bitjuwayiŋ yutjuwaḻnha marimin maŋutji. ");
INSERT INTO dhg_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ga banha ŋarru banhaya maŋutjim bitjuwayiŋ gälki munathaꞌḻim bala ŋarru banha maŋutjim ŋuthana ŋarra buṯ-bitjana ga yanatj ḻinygu ga marralyi ŋarru, bala ŋarru baṉamꞌ mala wanyuyin. Ga warrawꞌnha banha yulŋum. Bala ŋarru bäwarraṉꞌma ŋarran bala yalunꞌ ŋamaŋamayun banhalayam warrawꞌŋa. Yo, bitjanyan ŋarru banha God-Waŋarrwum yolŋu warra gurruṯumim ŋuthan ŋarra, yindiyin yana mala.” ");
INSERT INTO dhg_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yo, bitjanyan nhan gayŋan banha Djesuyu marŋgikuwanam yolŋunham warrany. Ga guḻkumi nhan gayŋan dhäwu malany mayaliꞌmiŋgan rakaran. ");
INSERT INTO dhg_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ga banha dhanal gayŋan dhanaliwayma ŋapa nyenan, Djesum ga guyurrꞌmiŋum warra yana nhangu, nhanmam bayiŋ dhanaliŋguḻ mayalimꞌ bitjuwayiŋ dhawaṯthumarran. ");
INSERT INTO dhg_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ga banha ŋarran walum giyawuḻyin nhanmam gayŋan baḏak yana Djesum nyenan marthaŋayŋa. Bala nhan garruwanan nhanguwaywuḻ guyurrꞌmiŋuwuḻim warrawuḻ bitjanan, “Gu, ŋalmam ŋirrimbuman djinaŋun marthaŋayyun ŋunha galiꞌḻin.” ");
INSERT INTO dhg_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Bala dhanalim banha guyurrꞌmiŋum warra ŋalꞌŋalyuwanan bala ŋirrimbuwanan. Ga guŋnharrumanan dhanal banha guḻkunham yolŋuny warrany bäymaŋuḻin. Ga waripu bitjuwayiŋ yolŋu marthaŋaymi warra malthuwanya dhanaliŋgu. ");
INSERT INTO dhg_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","Bala nhan banha Djesum gayŋiyanan ŋunhal dhurpuŋam marthaŋayŋa, muḻkurr nhan ḏämbuwuyḻi ŋalthuwan bala gayŋiyanan. Ga gandarrŋam bala watan ŋoy-gurrŋanꞌnha murrukaynha marimin waythuwan dhanaliŋgu, guwatharanan dhanaliny ŋarran, ga ḏowum gayŋan wapthuwanan bala garmakma dhaŋaŋdjinan marthaŋayŋam, gaḻki warri banha marthaŋayma waḏapthuwarran. Ga dhanalim banha guyurrꞌmiŋum warra nhangu mariminan yana biyaṉiyinam, bala dhanal gayŋan ṉakaranharamiŋganan Djesunham, “Wäy Marŋgikunhami ṉakama, waŋayin ŋalma ŋarru, guḻwuḻyuna ŋalma ŋarru,... ŋangawul nhuna gayŋa dhaŋu warwuyunma, ŋatja?” ");
INSERT INTO dhg_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Bala nhan Djesum gayŋiŋurum ṉakamanam bala dhuṉḏaynha yana nhan garruwanam wanyuyun yändhum watawum, “Guluwan!” ga ḏowuwum nhan bitjan garruwan, “Ḻinygun dharraḏayiyan!” bitjan. Bala dhuṉḏaynha yana banha watam guluwanan gälkinyaŋurum ga ḏowum ŋarran nyimdhuwanan bala wapurarrnha gayŋiyan. ");
INSERT INTO dhg_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Bala nhan Djesum garruwanan dhanaliŋgu bitjanan, “Nhäwu nhuma biyaṉiyinam?... ŋangawul nhuma gayŋa nyäkum mä-wulitjmiyi?” ");
INSERT INTO dhg_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Bala dhanalim banha mariminan biyaṉiyin, mä-maŋmaŋdhuwanan manapan bala ŋarran bitjanan garrunmin, “Nhäŋal nhuma? Ŋunha watayum ga garmakthum ŋäkul nhanany garrunda! Dhaŋum gulitjnha ganydjarrmin yolŋu!” bitjan. ");
INSERT INTO dhg_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Djesu ga nhangu guyurrꞌmiŋum warra buḏapthuwanan bayikuyam banha Galaliwuywum guḻungu, ga dhawaṯthuwanam dhanal ŋunha galinꞌ galkin yanan ŋirrimaŋam yäkuŋa Garatjaŋan. ");
INSERT INTO dhg_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","6","Ga banha nhan Djesu marthaŋayŋurum yapthuwan ga yolŋuyu nhanany nhäŋal ŋarru barrakinymiyu birrimbirrmiyu, ŋarru walmanam nhan banha bewaḻiya bäyma moluŋuru, banha nhan gayŋan nyenan banhalaya wikarraŋumi. Ga guḻkumi gayŋan yolŋuyu warrayu birrkaꞌyuwan garrwiꞌyuwan djeṉdhu malaŋuyu, ga waripum bayiŋ ṉuku wulanynha ḏapthumarra, ŋarru gulkurun, nhanmam gayŋan bakthuman ga ḻarrunmaran. Ga ŋangawulnha nhan gayŋan ŋunhuŋ yolkuḻim yolŋuwuḻ ganydjarryum nyenan. Bitjarra ḻinygu munha-ŋuparra ga walu-ŋuparra nhan bayiŋ gayŋarra buku-wirwiryumarram bayitjarram bukumurrum molumurrum girriꞌ-nharran, djolarranꞌ, yatjuwarra gayŋarra ga mitmitthunmiyarra ṉutjurruyu djinbulkthu. Manymak, ga banha nhan bayiŋuya ḏirramuyu nhäŋal Djesunham ŋunha yana bärrkuḻi bala yana gätthuwanan gumurrꞌyuwanan bala bunꞌkumu-djipthuwanan gumurrŋan nhanguḻ. ");
INSERT INTO dhg_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ga bitjan nhan Djesu garruwanam banha barrakinygum birrimbirrwu gamꞌ, “Way! Gatjuy dhawaṯthuwan djinakuruyam yolŋuwurum, maꞌ,” bitjan. Bala nhan banha barrakinyma birrimbirr garruwan yatjuwanan, “Djesu, Gäthuꞌmiŋu God-Waŋarrwu, banha nhan djiwarrꞌwuy, nhalpiyana nhunu ŋarru nhanany dhaŋu yulŋum? God-Waŋarrwuru yäkuyu ŋaya nhunany gayŋa ŋäŋꞌthun, ŋangawul nhänany baḏuwaḏuyuwa.” ");
INSERT INTO dhg_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Bala nhan Djesuyum dhä-wirrkaꞌyuwanan nhanany bitjanan, “Yol ḻinygu nhunu dhaŋu ŋaykaṉam?” bitjan. Ga nhanmam rakaranhamin bitjan, “Ŋayam dhaŋu yäku Ŋapa-malami, bili guḻku marimi nyäkuḻ gayŋa dhaŋu barrakinyma birrimbirr malany nyena,” bitjan. ");
INSERT INTO dhg_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Bala gayŋan banha barrakinyma birrimbirr mala bayikuḻ ḏirramuwurum giriŋꞌthuwanan garruwan Djesunham bitjanan, “Ŋangawul ŋanapiliny ŋaŋꞌŋaŋdhuwa dhawurum waŋgalaŋuru!” ");
INSERT INTO dhg_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Manymak, ga banhalaya bili galki yana bukuŋa 2000 bikipiki malany gayŋan nhumaꞌnhuman ŋathawu rangan. ");
INSERT INTO dhg_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Bala bayiŋuya barrakinydhum birrimbirryu malaŋuyu garruwanam mariminan Djesunham bitjanan, “Wäy, balan ŋanapiliny yänguŋam, mä ŋanapu ŋarru gulŋiyam ŋunha bikipikiwuḻin malaŋuwuḻ,” bitjan. ");
INSERT INTO dhg_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ga banha nhan Djesuyu ŋäkulam dhanaliny ga bitjanan nhan garruwanam, “Ma'... ŋaykaŋan warra!” Bala gayŋan banha barrakinyma birrimbirr dhawaṯthuwanan ḏirramuwuḻim bala gulŋiyan bikipikiwuḻin. Bala gayŋan banha bikipikim mala ḻurrunḏanan, ḏur'ṯuryunminan ŋarran, bala gayŋan ḏämbu-ḻarruwanan bukuŋurum, garmakḻin guḻunḻin yana, bala gayŋan guḻwuḻyuwanan. ");
INSERT INTO dhg_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ga dhanalim banha bikipiki djägamim warra gätthuwanam balan bitjanan ŋirrimaḻin malaŋuḻi, bala dhanal ŋarran rakaranan bukmak yana banha nhä gayŋan banhalaya maḻŋꞌthuwan. Ga guḻkuyun yolŋuyum warrayu gayŋan gananam dhanaliŋguway ŋirrimam malany, djälmiyinan dhanal banha nhänharawun banha nhä banhalaya maḻŋꞌthuwan. ");
INSERT INTO dhg_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ga banha dhanal ŋarran Djesuwuḻim, bala dhanal nhäŋalan banhayam ḏirramuny banha nhanguḻ gayŋan ŋätjil nyenan guḻku marimi birrimbirr malany. Ga nyenanam nhan gayŋan muḻkurr ŋuwakurrun ga girriꞌmin dhaṯthunminyaran. Ga banha dhanal yolŋuyum warrayu nhäŋal, bala dhanal yana biyaṉiyinan, ḻinygu dhanal yana dharaŋganan banha ŋarru gayŋa bitjanyam yolŋuyu barrakinynham birrimbirrnha walmanharamiŋgan bilanyayam banha yolŋu biyapulnha walꞌŋu ganydjarrmin. ");
INSERT INTO dhg_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ga dhanalim banha maŋutji-marŋgimiyum gayŋan dhäwun rakaran waripuwum yolŋuwu warrawu, nhanguruynha banha ḏirramuywuruynha ga bikipikiwuynha mala. ");
INSERT INTO dhg_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Bala dhanalim banha yolŋuyum warrayu gayŋan garruwan Djesunham ŋarranharawun yana. ");
INSERT INTO dhg_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ga djinaŋmu ḻinygu nhan gayŋan banha Djesu ŋalthuwanam marthaŋayḻim, bala nhanmam banhayam ḏirramu banha nhanguḻ gayŋan ŋätjil nyenan barrakiny birrimbirr mala, garruwanan gayŋan mariminan dhika giriŋꞌthuwanan bitjanan, “Dhaŋum ŋaya ŋarru nhuŋgu malthuna yana!” ");
INSERT INTO dhg_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ŋarru nhanmam Djesum yakaꞌyuwan nhangu, ga garruwan nhan nhangu bitjan, “Gatjuy nhunum balaya ḏirruwa gurruṯumiwuḻ nhuŋguwaywuḻ, ga rakaraŋ dhanaliŋgu banha nhä nhuŋgu God-Waŋarryu ŋuwakurru warkthuwan, ga nhalpiyan nhan nhuŋgu maŋutji-wuyuwan.” ");
INSERT INTO dhg_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Bala nhan banha ḏirramum ŋarranan ḏirruwanan balaya makaḻi ŋirrimaḻi Dikapulitjḻin, bala yana ŋarran rakaranan bukmakkuḻin, banha nhalpiyan nhan Djesuyu warkthuwan nhangu. Ga bukmakthum banha yolŋuyu warrayu ŋäkulam dhäwum nhanguŋ ganyimꞌthuwanan bitjanan, “Yo... yuy wamarrkani,” bitjanan. ");
INSERT INTO dhg_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ga dhurrwaraŋuru bewaḻiyam nhan Djesu ga guyurrꞌmiŋum warra nhangu waythuwanan marthaŋayum ŋunha galinꞌ bayikuyam guḻungu, yäkuŋa ŋirrimaŋa Gapuniyamnha. Ga banha dhanal gayŋan marthaŋayŋurum yapthuwan, ga malamin banha yolŋum warra ḻuŋꞌthuwan nhanguḻ. ");
INSERT INTO dhg_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ga banhalaya malaŋa gayŋan yolŋu yäku Djäratj dhäyan banha nhan ŋurruḏawalaŋu Djuwwu biryamiwu buṉbuwu. Ga banha nhan Djesunham nhäŋal, bala yana nhan ŋarranam bala bunꞌkumu-djipthuwanan munathaꞌḻin gumurrŋan nhanguḻ. ");
INSERT INTO dhg_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Bala nhan gayŋan garruwanan mäḻiŋganminan Djesuwuḻin bitjanan gamꞌ, “Marrkapmi! Yothu nyäku ŋunha baṯami 12-mi dhuŋgarrami rirrikthun gayŋa, galki nhan ŋarru ŋunha waŋayin! Buku-djulŋi ŋatjil maŋgarra gu, ga goŋ-ŋalthuwa nhanguḻ mä nhän ŋarru ŋuwatjin, ga ŋangawulnha waŋayim.” ");
INSERT INTO dhg_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ga ŋärrun nhan Djesum malthuwan nhangu Djäratjkum. Ga guḻkun banha marimin yolŋum warra gayŋan malthuwanam dhupaliŋgu ŋarru ḏurꞌ-ṯuryunminan dhanal ŋarran. ");
INSERT INTO dhg_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ga banhalaya malaŋa gayŋan ŋarran baṯami, ŋarru nhan banha ŋaraka-djetjimi. Ga mä wikarraŋumin nhan banha 12-nha dhuŋgarram rirrikthuwan. ");
INSERT INTO dhg_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Guḻkumi nhan gayŋan ŋarran marrŋgitjkuḻ warrawuḻ guŋgaꞌyundawu ŋarru gulkurun. Ga warrpamꞌthuwanan nhan banha rrupiyam nhanguway djalkthuwan dhanaliŋguḻ, ŋarru ŋangawulnha nhan banha gulitjma ŋuwatjin, ga rerrim ŋarran banha mariminatj murrukayyin. ");
INSERT INTO dhg_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","29","Ga banha nhan bayiŋuya baṯamiyu ŋäkulam Djesunham, bala nhan bitjanan guyaŋinam, “Bayiŋ ŋaya ŋarru girrimꞌ nhangu ŋayathan ŋayam ŋarru yana ŋuwatjin.” Bala yana nhan ŋarranan ḏiltjimurrun dhaḻakarr-yarpuwanan yolŋuwuwurun warrawuḻ malamurrun. Ga banha nhan goŋ-djarryuwanam baṯnha ŋayathan girrimꞌ nhangu. Bala dhuṉḏaynha nhangu banha gämurruꞌ-barrakinyma guluwanan, bala nhan dhäkay-ŋäkulan banha rerriyum nhanany guŋnharrumanan. ");
INSERT INTO dhg_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ga bilanyamiyu ḻinygu yana nhan Djesuyum dhäkay-ŋäkulan nhanguwaywuru nhan rumbalyum, banha ganydjarryum nhanany guŋnharrumanan. Ga guluwan nhan, bala gumurr-biluwanan bala dhä-wirrkaꞌyuwanan dhanaliny bitjanan, “Yolthu nyäku girrimꞌ ŋayathan?” ");
INSERT INTO dhg_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ga dhanalim banha guyurrꞌmiŋum warra nhangu garruwan bitjan, “Nhäŋa ŋatjil dhaŋu yolŋuny warrany mala, ŋapa-ŋalthumanmi ŋarra ḏurꞌ-ṯuryunmi nhuŋgurumurru. Nhäwu nhunu bitjanyam garruwan, guḻkun dhaŋu marimin yolŋum warra,” bitjan. ");
INSERT INTO dhg_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Bala nhan Djesum ḏawaꞌyuwanam bala ŋarran nhäŋalan yolŋunhan warrany mä nhan ŋarru maḻŋꞌthuman yolthu nhangu banha girriꞌ ŋayathan. ");
INSERT INTO dhg_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ga dhuṉḏaynha yana banha baṯamim marŋgiyinan bala marrmarryuwanan ŋarran biyaṉuyum nhanguwaywuru nhan, bala yana djalkiri-dhatharꞌyuwanan bala yana bunꞌkumu djipthuwanan gumurrḻin nhanguḻ Djesuwuḻin bala rakaranhaminan, “Marrkapmi, ŋaya banha nhunany ŋayathan.” ");
INSERT INTO dhg_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Bala nhan Djesum garruwanan nhangu bitjanan, “Wäy... gäthu, bili nhunu nyäku mä-wulitjmiyin, ga ḻinygun nhunu dhaŋu ḏukthuwanan rerriŋurum. Gatjuy maŋgarram ŋoy-ŋuwatjiyan ḻinygun nhunu dhaŋu walmanan dhaŋga-ḏirrŋurum,” bitjan. ");
INSERT INTO dhg_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ga nhanmam gayŋan banha Djesum baḏak yana garruwan, bala dhanalim banha yolŋum warra waythuwanan dhäwumim bewaḻim Djäratjkurum ŋirrimaŋuru, bala dhanal rakaranan bitjanan, “Wäy... ŋirrima dhaŋu ŋonuŋ. Ŋangawulnha biyapulma dhuwan Marŋgikunhaminham ḻay-ḻayyuma,” bitjan. ");
INSERT INTO dhg_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ga nhanmam banha Djesuyum dhanaliny djuḻkthuman ŋäkul, bala nhan bitjanan Djäratjkum garruwan, “Yaka warwuyuwa ga biyaṉiyiya, yana mä-wulitjmiyiya nhänany,” bitjan. ");
INSERT INTO dhg_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Bala nhan Djesum bitjanan garruwan, “Guluwan nhumam waripum warra ga dhaŋum ŋarru ŋalinyuŋgum malthun dhanaliwaynha yana Betan ga dhupalin wäwaꞌmanydjin Djayimnha ga Djonnha ga ḻinygun.” ");
INSERT INTO dhg_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ga banha dhanal Djäratjkuḻim ŋirrimaŋa waythuwan bala dhanal nhäŋalan yolŋunham warrany dhanal ŋarran galŋa-rrarrayuwanan, djäman ŋarran dhika nhän waripun waripun bayikuyan bäpurruwun romgu. Ga waripum yolŋu warra gayŋan ŋätjinyaraminan, waripu nyin gurrumꞌ ŋätjin ga waripum dhä-rirrakaymin manikaynha yuṯuŋgurrnha rakaran. ");
INSERT INTO dhg_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Bala nhan Djesum gulŋiyanan balayan ŋirrimaḻin, bala nhan garruwanan dhanaliŋgu bitjanan, “Nhä nhuma ŋarra dhaŋu galŋa rrarrayunma djäma, nhä guyaŋin yana warri dhaŋu bäpurrun? Ga nhäwu nhuma gayŋa dhaŋu ŋätjinyamim? Dhaŋum wirrkuḻ yothu ŋangawul nhan waŋayin, dhuwanma nhan gayŋa yakurr yana gayŋiya.” ");
INSERT INTO dhg_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ga dhanalim banha yolŋuꞌ-yolŋuyum warkuꞌyuwanan, gitkitthunminan manapan nhangu. Bala nhan gayŋan Djesuyum gukuwanan dhanaliny bitjanan, “Gatjuy nhumam bukmaknha yana walmiyan.” Bala dhanal bukmaknha gayŋan dhawayawaṯthuwanam bunbuŋurum. Manymak, ga gaḏaymanam nhan ŋäṉḏiꞌmiŋunhan yana ga nhananhan bäpaꞌmiŋunhan Djäratjnhan ga ḻurrkunꞌnhan guyurrꞌmiŋuny warrany nhanguway, bala dhanal gulŋiꞌ-gulŋiyanan balayan mungurrḻi banha ŋalaŋa gayŋan yothu wirrkuḻ gayŋiyan. ");
INSERT INTO dhg_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Bala nhan Djesuyum goŋnha nhanany ŋayathan banhayam wirrkuḻnham, bala garruwanan dhanaliŋguwaywurumurrun yänmurru Arram-murrun, “Dalitha gom!” (Mayaliꞌ “Wirrkuḻ ṉakaman!”) ");
INSERT INTO dhg_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","43","Ga dhuṉḏaynha yana nhan banha wirrkuḻma ṉakamanan, bala yana ŋarraꞌ-ŋarranan. Bala nhan Djesum garruwanan, “Gatjuy ŋunhuŋ nhä warra nhanany guŋa nhän guwaman,” bitjan. Ga bukmakthum banha nhäŋalam ŋayaŋu-ṉirruwanan, bala nhan Djesuyum garruwanam dhanaliny mariminan yana bitjanan, “Ŋangawul yana rakaraŋ ŋunhuŋ yolkum yolŋuwu djinakuwuyma,” bitjan. ");
INSERT INTO dhg_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Bala nhan Djesum ŋarranan guŋnharrumanan banhayam ŋirrima Gapuniyamma, bala ḏirruwanan balan nhanguwaywuḻin waŋgalaḻi Nätjuritjḻin, ga bukmak yana banha guyurrꞌmiŋum warra nhangu malthuwanya. ");
INSERT INTO dhg_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ga waripuŋuyun Djuwwuḻ Nyenanharamiyu Waluyu, nhan gayŋan Djesuyum marŋgikuwanam guḻkunhan yolŋunham warrany ŋunhalan banha biryamiŋan buṉbuŋam. Ga banha dhanal gayŋan ŋäkulam nhanany banha nhä nhan gayŋan dhanaliny marŋgiyuman bala dhanal bitjanan garrunminam, “Wäy, dhaŋum yolŋu gaḏamannha. Ŋalaŋa nhan gayŋan dhaŋu marŋgiyinam djinakum mala? Ga ŋalaŋuru nhan gayŋan dhaŋu ganydjarrma warraṯthuwan ŋayaŋu-ṉirrundamiwum romgu warkthundawu? ");
INSERT INTO dhg_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Dhaŋum dhaŋu banha buṉbu-dhuḻꞌyundami gayꞌ yolŋu! Dhaŋum ŋalma djinakuwuy mu ḻinygu waŋganybuy yana waŋgalawuyma, ga marŋgi mu ŋalma dhaŋu nhangu ŋäṉḏiꞌmiŋuwum Meriwum. Ga marŋgi ŋalma dhaŋu nhanguru wäwaꞌmiŋuwum warrawu yäkuwu Djayimgum ga Djawutjipkum ga Djudatjkum ga Djäymangum, ga marŋgi ŋalma nhangu yapaꞌmiŋuwu warrawu.” Bala gayŋan banha yolŋum warra nhangu ŋangawulnha bitjuwayiŋ gumurr-ŋuwatjinam, ŋurru-bilꞌbiluwanan dhanal gayŋan nhangu. ");
INSERT INTO dhg_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ŋarru nhanmam Djesum garruwan bitjan, “Banha bayiŋ God-Waŋarrwum djawarrkmi yolŋu ŋarra waripuḻim ŋirrimaḻi ga dhanalim banha bayiŋ ŋirrima nininyŋuyum yolŋuyu warrayu yän warraṯthun ga mä-ŋalthun nhangu. Ga banha nhan ŋarru ŋarra nhanguwaywuḻin ŋirrimaḻi, nhanguwaywuḻim walꞌŋu yolŋuwuḻ warrawuḻ gurruṯumiwuḻim warrawuḻ, ga dhanalim bayiŋ banha yolŋuyum warrayu ŋangawulnha yän-warraṯthum, ga mä-ŋalthum nhangu.” ");
INSERT INTO dhg_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6a","Ga ganyimꞌthuwanan nhan banha Djesuyum nhäŋal, bili yolŋum warra banha ŋayaŋum-wanyuyinan ga ŋangawulnha dhanal gayŋan banha biyapulma bitjuwayiŋ mä-wulitjtjin. Ga ŋangawulnha nhan gayŋan banha ganydjarrmim rom bäki mariminam, ḻurrkunꞌnha yana, yana nhan ŋarran waŋgaꞌ-waŋganyguḻin yolŋuwuḻim rerrimiwuḻim warrawuḻ goŋ-ŋalthuwan bala ḏukthumanan. ");
INSERT INTO dhg_vpl VALUES ("MK6_6b","071_6_6b","MRK","6","6b","6b","Bala nhan ŋarran Djesuyum marŋgikuwanam yolŋuꞌ-yulŋunham warrany ḏämbu-ḻiwꞌyumanan banhalayam yuṯuŋgurrŋa waŋgalaŋa. ");
INSERT INTO dhg_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ga ḻuŋꞌthuman nhan banha 12-nha guyurrꞌmiŋuny warrany nhanguway nhan, bala nhan ŋarran gänaŋꞌthumanan dhanaliny burrpar ga burrpar ga burrpar, ga bitjanan nhan banha garruwanam dhanaliŋgu, “Maꞌ maŋgarran warra ŋirrimaḻin malaŋuḻi ga marŋgikuŋan yolŋunhan warrany God-Waŋarrwuruynha. Ŋaya nhumaliny gayŋa dhaŋu ganydjarrma guŋana nhuma ŋarru dhawaṯthumana barrakinyma birrimbirr mala. ");
INSERT INTO dhg_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Ga ŋangawul warraṯthuwa guḻkum girriꞌ ḻinygu nhän mu ŋarru nhuŋgu God-Waŋarryu djämam ŋätjilmiŋganma. Ḏarpan yana warraṯthuwam gaṉdjiꞌyunminyarawun ga djalkiriwuy dhuwan ṉukuŋa nhuŋguḻ ga dhuwaniya ḻinygu girrimꞌ dhuwan galŋayu nhunu gayŋa gutjparrun. Ga ŋangawul gutjparruwa ŋunhuŋ nhä ŋatha ga rrupiya ga ŋunhuŋ nhä yilipi. ");
INSERT INTO dhg_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ga bayiŋ nhuma ŋarru waythunma bawalamiŋam ŋirrimaŋa ga guykuyyunma dhanal ŋarru nhumaliŋgu gumurr-gayanꞌthanmim bitjuwayiŋ, bitjanma nhan ŋarru garrun, ‘Gu, ŋunhal nhuma ŋarru nyäkuḻ buṉbuŋa gayŋiya,’ nhumam yana maŋgarran ga gayŋiyan banhalayam buṉbuŋa ga yanatj ḻinygu-u-u, ga djäma nhumaliŋgu ŋarru dhawarꞌyun, ga ŋärrun dhanaliny guŋnharrumam. ");
INSERT INTO dhg_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ga banha nhuma ŋarru waythun bawalamiŋa ŋirrimaŋa ga ŋangawulnha nhumaliŋgu ŋarru banha ŋirrima bayikuwuyma yolŋu warra gumurr-ŋuwatji, ga ŋangawul dhanal bitjuwayiŋ ḏukṯukmiyin ŋänharawu nhuŋgu, nhumam ŋarru guŋnharrumana yana banhayam ŋirrima bala munathamꞌ djalkiriŋurum ḏawaṯawayuwan bayikuwuyma ŋirrimawuy, ga bitjan garruwam dhanaliŋgu, ‘Dhaŋu nhuma ŋangawul bitjuwayiŋ djälmiyin nyäku mäkiri-witjundawu, ga bayiŋ ŋarru banha ŋunhuŋ nhä mari nhumaliŋgu maḻŋꞌthun, banham nhumaliŋguwaynha mari,’ bitjan yana, ŋangawulnha ḏawaꞌyuwam, yana ŋapayu-guŋnharrumana dhanaliny.” ");
INSERT INTO dhg_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Yo, bala dhanal banha guyurrꞌmiŋum warra ŋaykanan bärrkuwaḻyinan burrpaꞌ-burrparnha waripuḻin ga waripuḻin ŋirrimaḻi, ga banhalayam dhanal ŋarran rakaranam yolŋuꞌ-yulŋuwum bitjanan, “Guluwan warra dhuwurr-barrakinyŋurum nhumaliŋguwaywuru nhuma bala malthuwam God-Waŋarrwurun gulitjkun batjiwarrwum.” ");
INSERT INTO dhg_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ga guḻkun marimin dhanal gayŋan banha barrakinyma birrimbirr malany dhawaṯthuman yolŋuwurum warrawuḻ. Ga guḻkuwuḻ banha rerrimiwurum yolŋuwuru dhanal gayŋan wiyikamꞌ rarruwan muḻkurrḻim ŋarru ḻurrkunꞌ yana, ŋangawul guḻku, mä dhanal gayŋan ŋuwatjtjinan. ");
INSERT INTO dhg_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ga bilanyamiyum waluyu guḻkuyun gayŋan banha yolŋuyum warrayu Djesuwuruyma ŋäkul. Ga nhän banha yindiyum buŋgawayu yäkuyu Geŋ Yaritthum ŋäkul yana ganydjarrma nhanguruy. Ga bitjanan gayŋan banha waripum yolŋu warra garruwan, “Dhaŋum nhän ŋatja Djon banha Buku-ḻupthumandami ŋarru Djesuwurun rumbalyum, dhaŋu nhan yawungu biyapul bitjuwayiŋ wälŋayi rakunyŋurum, ga djinaŋuyan nhan gayŋa dhaŋu Djesuyu bitjuwayiŋ ŋayaŋu-ṉirrundamim rom djäma.” ");
INSERT INTO dhg_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ga waripum yolŋu warra gayŋan garruwan bitjanminan, “Dhaŋum wilak Yilaydjan ŋatja banha God-Waŋarrwun djawarrkmi ŋätjiliŋuwuynha?” Ga biyapul waripu bitjuwaŋ yolŋu warra garruwan bitjan, “Ŋangawul dhaŋum Yilaydja, dhaŋum ŋunhuŋ yol waripu God-Waŋarrwu djawarrkmi ŋätjiliŋuwuy.” ");
INSERT INTO dhg_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ga banha nhan Yaritthu ŋäkulam banha nhä ŋarran yolŋu warra rakaranhamin bala nhan yana yän-guŋanminan bitjanan, “Dhaŋum Djonnha banha Buku-ḻupthumandamin yolŋu. Ga ḻinygu mu ŋaya banha ŋätjil yana yänma guŋanmi nyäkuḻ djämamiwuḻim warrawuḻ bitjan, ‘Gatjuy gupan warra nhanany gulkthuwa,’ Ga dhaŋum nhan ḻinygun wälŋan.” ");
INSERT INTO dhg_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Yo, bitjan nhan banha maḻŋꞌthuwanam gamꞌ ŋätjilim. Bayikuya yindiwu buŋgawawu yäkuwu Geŋ Yaritku gayŋan yukuyukuꞌmiŋu nyenan yäku Bilip, ga baṯami nhangu yäku Yiritiya. Bala nhan bayiŋuya yindiyum buŋgawayu Geŋ Yaritthum malikanan banha yukuyukuꞌmiŋuwum nhanguwaywuru baṯaminy. Manymak, guḻkumi nhan gayŋan Djon ŋarran ga garruwan nhan gayŋan maŋutji-yunupa Yaritku bitjan, “Ŋangawul nhunu djakawarruwa dhuwan yukuyukuꞌmiŋuwu nhuŋguru baṯaminy. Dhuwanma nhunu ŋarru ganitjumana ŋalmaliŋgu romnha, Djuw bäpurruwun.” Ŋarru nhanmam banha Yaritthum warraṯthuwan yana banha baṯaminy. Bala nhan banha yän-wuŋanminan nhanguru djämamiwum warrawu dhanal ŋarru Djonnham dhethuŋgana dharruŋguḻin. ");
INSERT INTO dhg_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ga bitjanan ḻinygun nhan gayŋan banha Djondhum bitjuwayiŋ ŋayaŋu-guwarumanan garruwan, bala ŋarran banha baṯamim ŋoy-dhäyanan nhangu Djongum, ga ḏukṯukmiyinam nhan gayŋan banha mariminan yana murrkayꞌkunharawun yana guwathanharawum nhangu, ŋarru ŋangawul nhan ŋunhuŋ batjiwarr maḻŋꞌthumarra. Bala nhan Yaritthum gayŋan ŋayathanan Djonnham dharruŋguŋan, ");
INSERT INTO dhg_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ga bitjan nhan banha yän-wuŋanminam djäkamiwuḻim gamꞌ, “Djinakum nhuma ŋarru gayŋa ŋuwatjuman yana djäka.” Ga marimin nhan gayŋan banha yindiyum buŋgawayu Yaritthum bitjuwayiŋ Djonnham mäyu-ḏapthuman mä-biyaṉiyinan manapan. Ga marŋgi nhan banha, banha nhanany God-Waŋarryu bitjuwayiŋ yänguwan ga nhäpa nhan banha ŋayaŋu-dhuṉḏay bilanya yolŋu ŋuwakurru. Ga djäl nhan banha marimi nhangu nhan ŋarru gayŋa ŋäma nhanany garrunda dhäwuḻi rakaranhaḻi. Ŋarru guḻkumi nhan gayŋan banha Djondhu bitjuwayiŋ ŋayaŋu-barrakinydjuman nhanany banha nhan bayiŋ ŋunhuŋ garruwarram dhäwum rakararra. ");
INSERT INTO dhg_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Manymak, ga waŋganymiyum waluyu dhanal ŋarran ḻuŋꞌthuwanan ŋathawun guwamandawu, bayitjaniyam dhanal guyaŋin banha Yaritkun waŋgala-wuyaŋinyaran walu. Manymak, ga bilanyamiyun nhan banha bayiŋuya baṯamiyum yäkuyu Yiritiyayum bitjuwayiŋ guyaŋin bitjanan, “Yä-a-a, dhaŋun ŋaya ŋarru bäyarran Djonnham bayikuwuynha.” Ga guḻku bitjuwayiŋ gämurruꞌ yolŋu warra ŋarran banhambal ŋathawu guwamandawu bilanya bitjuwayiŋ ŋurru-warrundayŋu gapman warra ga maḏakarritjmiwu mariŋuwu warrawu buŋgawaꞌmiŋu ga ŋaḻapaḻmin ŋunhukuwuynha makawuy ŋirrimawuy mala ŋunha Galaliwuynha. ");
INSERT INTO dhg_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Yo, guwamanan dhanal ŋarran ŋatham ga garmakma, ga banhalaya gayŋan wirrkuḻ baṯami marruwan, ŋarru nhan banha wakuꞌmiŋum bayikuyan baṯamiwum yäkuwu Yiritiyawun. Yo, marruwanam nhan gayŋan banha wirrkuḻma ŋuwatjumanan dhika. Bala nhan banha yindim buŋgawa Yaritma ga yolŋum warra mariminan bitjuwayiŋ mä-maŋmaŋdhuwanam nhanguru marrundayum. Bala nhan Yaritma guykuyyuwanan nhangu bitjanan, “Bayiŋ nhunu ŋarru nhänany ŋäŋꞌthun ŋunhuŋ nhäwu nhunu djäl, ŋayam ŋarru guŋana yana nhunany. ");
INSERT INTO dhg_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ga bayiŋ nhunu djälma ŋaya ŋarru mala-wulkthumana bukmaknha yana, ga ŋala waŋgala maka malany nyäkuḻ bitjuwayiŋ goŋŋa, ŋaya ŋarru gulkthumana nhuŋgun ga nyäkuwaynha. Ga banha ŋarru dhuwan ŋangawulma bitjanya maḻŋꞌthun ŋaya gayŋa ŋäŋꞌthun nhan ŋarru nhänany God-Waŋarryum dhä-girꞌyuna yana.” bitjan. ");
INSERT INTO dhg_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ga nhanmam banha wirrkuḻma baṯami ŋarran ŋatjil dhawaṯthuwan ŋunha ŋäṉḏiꞌmiŋuwu rangan ga ŋäŋꞌthuwan nhan, “Wäy... ŋäṉḏi,... nhäwu ŋaya ŋarru ŋunha yindinham buŋgawany ŋäŋꞌthun?” bitjan. Ga nhanmam banha ŋäṉḏiꞌmiŋuyum garruwan bitjanan, “Gatjuy... buku-djulŋi ŋäŋꞌthuwam Djongurun yana muḻkurrwum.” ");
INSERT INTO dhg_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Bala yana nhan banha wirrkuḻma ḏirruwanya gätthuwan balaya Yaritkuḻ, bala bitjanan garruwan, “Yindi buŋgawa, ḏukṯukma ŋaya dhaŋu nhunu ŋarru gupan gulkthun Djonnhan banha Ḏämbu-ḻupthumandaminy yolŋuny djinaŋun bala yana, ga gunhanma nhunu ŋarru banha muḻkurrma biḻitlin, bala guŋana nyäkuḻin,” bitjanan. ");
INSERT INTO dhg_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ga banha nhan bitjuwayiŋ Yaritthum bilanyawuyma ŋäkul, bala yana nhan ŋayaŋum-barrakinydjinan mä-yumbalꞌyuwanan manapan. Ŋarru ŋangawulnha nhan gayŋan banha ḏukṯukmiyin nhan ŋarru dhawumꞌ nhanguway ganitjuman, ḻinygu nhan banha dhawuꞌ-nhinathuŋganam nhanany dhulinaꞌmaran bitjuwayiŋ ŋaḻapaḻmiwuḻin. ");
INSERT INTO dhg_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Bala nhan Yaritma guykuyyuwanan mariŋuwun buŋgawaꞌmiŋuwu bala yän-wuŋanminan, “Gatjuy maŋgarra ŋunha dharruŋguḻ ŋala gayŋa Djon nyena bala gupan nhanany gulkthuwa.” ");
INSERT INTO dhg_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Bala dhanal banha warraṯthuwanam nhanany gupam muḻkurr-manapanan bala gunhanan biḻitlin bala gutjparruwanan bayikuḻiyan wirrkuḻwuḻin. Ga nhanmam banha bayiŋuya wirrkuḻyum ŋawatthuwan bala guŋanam ŋunha ŋäṉḏiꞌmiŋuwuḻin nhanguwaywuḻ nhan. ");
INSERT INTO dhg_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ga banha dhanal Djonguḻ guyurrꞌmiŋuyum warrayu ŋäkul dhäwum nhanguruy waŋayinyaram, bala dhanal yana ŋarranan ga warraṯthuwanan nhangu rumbalma bala moluḻin märrkitjkuwan. Ga bitjanyan nhan gayŋan banha Yaritthum guyaŋin yana warri nhan Djesum Djonnha banha Buku-ḻupthumandamin yolŋu. Ga bilanya nhan banha dhäwum. ");
INSERT INTO dhg_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Manymak, ga banha dhanal banhaya guyurrꞌmiŋum yolŋu warra nhangu Djesuwu gumurr-ḏirruwanam bewaḻim djämaŋurum, bala dhanal gayŋan rakaranan Djesuwuḻim nhä dhanal gayŋan djäma ga nhä dhanal gayŋan marŋgikuwan yolŋuny warrany. ");
INSERT INTO dhg_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ga bilanyamiyum gayŋan banha guḻkun marimin yolŋum warra rangan nhangum Djesuwum, ga ŋangawulnha dhanaliŋgu banha bitjuwayiŋ walum ŋathawum guwamandawu, Djesuwum ga nhanguru guyurrꞌmiŋuwum warrawu. Bala nhan garruwanan bayikuya guyurrꞌmiŋuwum warrawu bitjanan, “Go, ŋalma ŋatjil ŋaykam ŋay, ŋunhuŋ ŋalambal guŋnharraḻ ŋirrimaḻ mä ŋalma ŋarru ŋirꞌyunmi.” ");
INSERT INTO dhg_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Bala dhanal wapwapthuwanan marthaŋayḻin bala ŋaykanan gänaŋuḻin ŋirrimaḻi. ");
INSERT INTO dhg_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ga guḻkuyun gayŋan banha yolŋuyum warrayu nhäŋalam banha goyurrma marthaŋaynham nhäḻi gayŋan banha gätthuwan. Bala banha yolŋum warra ḻawꞌyuwanan goyurr-ŋupanan banha marthaŋayma ŋarru ḏiltji-djakawarruwanan, ga dhanalin warri banha ŋurruŋum waythuwan banhalayam ŋirrimaŋa. ");
INSERT INTO dhg_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ga banha nhan Djesu yapthuwanam marthaŋaŋurum bala gayŋan banha yolŋum warra gäḻkuḻanan nhangu. Ga banha nhan Djesuyu nhäŋalam dhanaliny malam, bitjanan, banha dhanal ŋangawul bitjuwayiŋ marŋgi nhalpiyan dhanal ŋarru gayŋa nyena, bilanyan dhanal banha bitjuwayiŋ bimbi malany djäganharraŋan. Bala nhan mariminan ŋayaŋu-wuyuwanam dhanaliŋgu, ga marŋgikuwanam nhan gayŋan dhanaliny banha God-Waŋarrwum Rom ");
INSERT INTO dhg_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","ŋurruyirrꞌyuwanam ḏämbuyu-waluyu ga yanatj ḻinygu-u-u, ga räy-wiluwan. Bala banha guyurrꞌmiŋum warra nhangu garruwanan, “Wäy, räy-wiluwanan dhaŋu ga ŋangawulnha dhaŋu ŋatham, gatju-wilak garruwa dhuwan yolŋuny warrany dhanal ŋarru ŋatha dhanaliŋguway warraṯthun dhaŋu yaꞌ waŋgalaŋa malaŋuŋa.” ");
INSERT INTO dhg_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ga nhanmam Djesum bitjan ḏämbu-ganitjuman, “Ŋangawul dhuwanma ŋuwakurru. Nhumapi yana dhanaliny maranhu-wuŋa.” Ga dhanalim dhä-wirrkaꞌyuwan nhanany mä-yumbalꞌyuwanan manapan bitjan, “Wäy, ŋalaŋa yika ŋanapum ŋarru maḻŋꞌthuman bilanyayam rrupiyany malany djinakum yolŋuwu malawu maranhu-wuŋandawu? Dhaŋum ŋarru yolŋu gayŋa djäma waŋganynha dhuŋgarra, ŋatja, dhaluŋꞌthun ŋathil rrupiyany, ga ŋärrun nhan ŋarru ŋatham bitjuwayiŋ wuŋiḻiꞌyun.” ");
INSERT INTO dhg_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ga nhanmam Djesum garruwan, “Maḻŋꞌthuma warra, yolthu gayŋa ŋunhuŋ ŋatha gutjparrun?” Bala dhanal ranga-ranganan ga ḏirruwan dhanal bala rakaranan bitjanan, “Goŋ-waŋgany dhaŋu dämbam ga burrpar ŋarirrimꞌ.” ");
INSERT INTO dhg_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Bala nhan Djesuyum garruwanan yän-wuŋan ŋunha guyurrꞌmiŋunham nhanguway nhan bitjanan, “Maꞌ garruwan dhaŋu yolŋunham warrany dhanal ŋarru nyenam mulmuŋan ŋarru malaŋa ga malaŋa ga malaŋa.” ");
INSERT INTO dhg_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Bala gayŋan yolŋum mala-wulkthuwanan waripu yolŋu warra 100 malaŋa ga waripu ga 50 ga bitjanan bala, ga be mu gayŋan nyenan. ");
INSERT INTO dhg_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Bala nhan Djesuyum banha goŋ-waŋganyma dämba ga ŋarirrimꞌ wulanynha warraṯthuwanan. Ga ḏämbu-garrwartjin nhan djiwarrꞌḻi buku-wuŋan God-Waŋarrnha, bala ganiꞌ-ganitjumanan bala guŋanan ŋunha guyurrꞌmiŋuwuḻin warrawuḻ nhanguwaywuḻ mä banha dhanalim ŋarran guŋaꞌ-guŋan ŋunha yolŋuwun warrawu malaḻin malaŋuḻ. ");
INSERT INTO dhg_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ga guwamanam dhanal ŋarran banha ŋatham ga bukmak yana bitjuwayiŋ ganaꞌyinam. ");
INSERT INTO dhg_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ga guwaman dhanal ŋarran ga dhawar, bala gayŋan banha guyurrꞌmiŋuyum warrayu wapthumanan bäytjinyaram ŋatha, ga dhaŋaŋguwanam dhanal duwalp yilipim malany. ");
INSERT INTO dhg_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ga ŋunhuŋ nhämunha banha 5000, ḏirramum yana mala, ga bayaya banha baṯamim warra ga yumurrkum bilanyaya ḻinygu mu mala. ");
INSERT INTO dhg_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ga dhuṉḏaynha yana nhan banha Djesuyum garruwan nhanguway guyurrꞌmiŋunham warrany bitjanan, “Wäy waraparra, nhumam mangarran marthaŋayyun ŋunha galiꞌḻin ŋunha Bithdjaydaḻin.” Bala dhanal ŋaykanan buḏapthuwanan bayikuya guḻungum, ga nhanbayim Djesum ŋurrꞌyuwanan banhalayan bäyman, ga yolŋuny warrany ŋatjil gayŋan yänguwan ḏirrunmaran ŋirrimaḻi. ");
INSERT INTO dhg_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ga banha dhanal yolŋum warra ḻatjuwarrꞌyuwan, bala nhanbayim Djesum bukuḻin ŋalthuwan bukumiŋgandawun. ");
INSERT INTO dhg_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","50","Ga banha waŋgalam munhakuyin bala nhan Djesum yarrupthuwanan bukuŋurum. Ga dhanalim banha guyurrꞌmiŋum warra nhangu marthaŋaymim warra bilanyamiyum ŋunhalan dhulmuŋan garmakŋa. Ga mariminan dhanaliny gayŋan banha watayum gumurr-nhinathuŋgan ga mariminan dhanal gayŋan banha ḻiwꞌyuwanam. Ga munhamurrun nhan Djesuyum goyurr-ŋupan dhanaliny, ŋarru ŋarranam nhan gayŋan banha ṉukuyun ŋapamurrun garmakmurru. Ga djinaŋmu ḻinygu nhan ŋarran banha djuḻkthumanam dhanaliny marthaŋayminham warrany bala dhanal nhanany nhäŋalan. Ga biyaṉiyinam dhanal banha nhangu mariminan yulŋum ŋapa-ŋayathanan dhä-wirrkaꞌyunminan bitjanminan, “Wäy-y-y nhä gayŋa dhaŋu ŋarra way, maliꞌ yolŋu ŋatja?” Ŋarru nhanmam Djesum garruwan, “Ŋaya... ŋaya dhaŋu waraparra. Ŋangawul warra biyaṉiyiya!” ");
INSERT INTO dhg_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Bala nhan Djesum ŋalthuwanan balayan marthaŋayḻin bala watam banha wapurarryinan. Ga dhanalim banha guyurrꞌmiŋum warra nhangu mariminan mä-maŋmaŋdhuwanam bayikuyam romgu. ");
INSERT INTO dhg_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ga ḻinygu mu dhanal banha nhäŋalam nhanany Djesunham banha nhan ganydjarryu nhanguwaywuḻ maranhu-wuŋan malaminy yolŋuny warrany djuḻkthuman gayŋa 5000 mala. Ga ŋangawul yana dhanal banha dharaŋganam nhangu ganydjarrma, ḻinygu dhanaliŋgu banha ŋayaŋum wanyuyinan. ");
INSERT INTO dhg_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ga banha dhanal waythuwanam ŋunha galimꞌ bitjuwayiŋ bayikuyam guḻungu, bala dhanal baḻaŋum ḏupthuwanan banhalaya ḻinygu gumurrŋan ŋirrimaŋan Ginatjaritnha. ");
INSERT INTO dhg_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ga banha dhanal gayŋan ḻarruwanam marthaŋayŋurum, bala guḻkuyun banha yolŋuyum warrayu ḻinygun nhäŋalan dhanaliny bala guykuyyunminan bitjanan, “Gu, gu, waraparra dhaŋun Djesum ḻinygun waythuwanan.” ");
INSERT INTO dhg_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","56","Bala gayŋan yolŋum warra gätthuwanan, rakaranhaminan ŋarran ḏämbu-ḻiwꞌyumanan, ga dhaŋun räli yolŋuyum warrayu ŋarran gutjpa-gutjparruwanan rerriminhan yolŋuny warrany. Ga ŋalambal nhan Djesu bitjuwayiŋ ŋarran banhalaya ŋirrimaŋa, dhanalim yolŋuyum warrayu ŋäkul ga bitjan mu ŋarran gutjpa-gutjparruwanam rerriminham yolŋuny warrany bala ŋarran ŋurru-ḏakthunminan, rarrꞌyuwanan ŋarran yorrkuwanan banhalayan banha maraŋuŋan ŋirrimaŋa. Ga bitjanan dhanal banha guyaŋinam gamꞌ, “Bayiŋ dhanal ŋarru banha girrimꞌ yana nhangu Djesuwu ŋayathan dhanalim ŋarru ŋuwatjin yana.” Ga banha dhanal bitjuwayiŋ ŋayathanam nhangu girrimꞌ dhanalim ŋuwatjinan yana. ");
INSERT INTO dhg_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Waŋganydhum waluyu Baratji ŋurruk Rom-ŋayathandayŋu warra, ga mä ḻurrkunꞌ Djuwwu Rom-marŋgikunharami warra ŋirrima Djurutjalambuyyu guwatjman dhanal Djesuny. ");
INSERT INTO dhg_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","5","Ga banhayam banha yolŋu warra bayiŋ gayŋa marimin yana dhanaliŋguwaynha yana romgum bitjuwayiŋ malthun. Bilanyan mala rom gamꞌ: bayiŋ ŋarru yolŋu djälmiyi ŋathawu guwamandawu, ŋurruŋum dhanal ŋarru goŋ-rurrwuyunmi romgu yana malthun ga ŋärrun ŋatham guwaman. Ga banha dhanal ŋarru ŋatha warraṯthun ŋunhuŋ ŋalaŋa yolŋu guḻkuꞌmiŋa ŋirrimaŋa, ŋurruŋum dhanal ŋatjil ŋarru waḏapthun romgu malthun. Ga ŋärrun banikinꞌma malany rurrwuyun bilanya bitjuwayiŋ djuypanꞌ mala, ŋathawuy biyarrthanda rupa mala, ga garmakpuy wurkthunda ga gäp ga biḻit ga guḻku waripu waripu. Bukmakkum ŋarru rurrwuyun, romgu bayikuya malthun. Ga bayiŋ ŋarru banha waripu Djuw yolŋu ŋangawul gayŋa malthun banha nhalpiyan gayŋa rom barraŋgaꞌyun, dhanalim ŋarru banha Baratjim yolŋu warra maḏakarritjtjin dhanaliŋgu. Ga bilanyaḻi dhanal banha Djesuwum guyurrꞌmiŋuny warrany nhäŋal, bala dhanal banha Baratjim ŋurruk maḏakarritjinan dhanaliŋgu, ḻinygu dhanal gayŋan ŋatha guwaman, goŋdhu-rurrwuyundanharramiyun, ŋangawulnha bitjuwayiŋ romgu malthuwan. Bala dhanal gayŋan rom-nyamirꞌyuwanan nhanany Djesunham bitjanan, “Nhäwu bayiŋ gayŋa banha nhuŋgurum guyurrꞌmiŋuyu warrayu bitjanyam ŋatha guwaman goŋdhu-rurrwuyundanharramiyum? Banham dhanal bayiŋ gayŋa bitjanyam romnha bitjuwayiŋ ganitjuman ŋunha ŋaḻapaḻmiwuŋun!” ");
INSERT INTO dhg_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","7","Bala nhan Djesum ḏämbu-ganitjuman bitjanan, “Nhumam dhaŋum yolŋu warra gali-märrmaꞌ warra. Dhuṉḏaymu nhan banha yolŋuyu yäkuyu Yitjayayum bamanꞌma wukirri God-Waŋarrnham yän bitjanam gamꞌ, ‘Dhaŋum yolŋu warra bayiŋ gayŋa wokthun nyäku yändhu yan waŋganydhu, ga ŋangawul bitjuwayiŋ ŋunhuŋum ŋayaŋuyum. Ŋangawulnha dhanal bayiŋ gayŋa dhaŋu gulitjumanma nyäku buku-ŋalthun, ga marŋgikumam dhanal bayiŋ gayŋa yolŋuwun yana romma malany, yana warri banhayam God-Waŋarrwun rom malany. Ga baṯ-bitjanma dhanal bayiŋ gayŋa dhaŋu ŋayathan yolŋuwuŋun yana romma malany.’ Bilanyayan dhaŋu nhumam. ");
INSERT INTO dhg_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","9","Guŋnharrumanan nhuma God-Waŋarrwuŋum rom nhinathuŋganda malany, bala nhuma bayiŋ gayŋa dhaŋu malthunma yolŋuwun yana romgum. Gaḏamanmin dhaŋu nhumam marimin dhaŋuyma warra bilanyawum barrakinydjumandawum djämawu! ");
INSERT INTO dhg_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Dhaŋum banha rom nhanguŋ God-Waŋarrwuŋ, banha nhan guŋan Mawtjitjkuḻ bilanya gam', ‘Mä-ŋalthuwa nhuŋguway ŋäṉḏi'miŋuwum ga mori'miŋuwum.’ Ga biyapulma nhan bitjan gam', ‘Bayiŋ ŋarru yolŋu dhä-warranydjaḻ'yi garrun ŋäṉḏi'miŋuwu ga mori'miŋuwu, ŋunha gayŋa romma barraŋga'yun banha bilanyanham yolŋuny ŋalmam ŋarru guwatharaman waŋayumana yana.’ ");
INSERT INTO dhg_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Yo, bitjanya nhan banha God-Waŋarryum rom nhinathuŋgan, ŋarru nhumam bayiŋ gayŋa dhaŋu waripuyumana marŋgiyuman bilanyan gamꞌ, ‘Ŋunha nhuŋgu ŋäṉḏiꞌmiŋu ga moriꞌmiŋu gayŋa djälmiyi ŋunhuŋ nhäwu bitjuwayiŋ, ŋarru nhunum banha ḻinygun banhayam dhawuꞌ-nhinathuŋgan God-Waŋarrnhan, ŋarru baḏak yana nhunum gayŋa banha mäyu-ḏapthuman, ga ŋangawulnha nhunu ŋarru banha dhupalinham bitjuwayiŋ guŋan.’ ");
INSERT INTO dhg_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ga bilanyawuyan ŋaya banha bitjanyam rakaran nhumaliŋgu ŋätjilim, nhumam banha barꞌparyumanan nhangum God-Waŋarrwum rom, bala bilumanan nhuma, ga waripun rom nhinathuŋgan. Ga guḻku mu nhuma gayŋan dhaŋu romma malany biluꞌ-biluman.” ");
INSERT INTO dhg_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Dhurrwaraŋuru bewaḻiyam nhan Djesu guykuyyuwanan yolŋuwun warrawu bala bitjanan garruwan, “Dharr-bitjan warra ŋäkam, mä nhuma ŋarru dharaŋgan yana. ");
INSERT INTO dhg_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nhä bayiŋ banha gulŋiya ŋunha guḻunḻi, ŋangawul bayiŋ banha bayiŋuyam yolŋuny ŋayaŋu-barrakinydjuman. Ga nhä bayiŋ dhawaṯthuna ŋalmaliŋguru ŋayaŋuŋurun, bayiŋuyan bayiŋ banha barrakinydjumanma. ");
INSERT INTO dhg_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Bayiŋ nhuma mäkiriꞌmim warra, ŋäkam warra ŋuwaḻyuman!” ");
INSERT INTO dhg_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Bala nhan Djesum ga guyurrꞌmiŋum warra nhangu ŋaykanan guŋnharrumanan yolŋunham warrany bala gulŋiyanan buṉbuḻin. Bala dhanal dhä-wirrkaꞌyuwanan Djesunham bitjanan, “Marrkapmi, ŋatjil rakaraŋ ŋanapiliŋgu banha mayaliꞌ bayikuy dhäwuꞌwuy.” ");
INSERT INTO dhg_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Ga nhanmam Djesum ḏämbu-ganitjuman dhanaliŋgu bitjanan, “Nhalpiyan nhuma gayŋa dhaŋu ŋangawul yana dharaŋganma, ŋatja? Bilanya nhan banha mayalim' gam': nhä bayiŋ yolŋuyu guwaman banhayam ŋuwakurru, ḻinygu ŋarru banha walma mu. Ŋarru nhä banha bayiŋ walman ŋayaŋurun, banhayan nhan bitjuwayiŋ barrakinyma.” (Ga bitjanam nhan banha garruwan, ḻinygu bukmakma dhaŋu ŋatha malany ḏarrtjalk yana guwamandawum.) ");
INSERT INTO dhg_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","“Ga nhä banha bayiŋ yolŋuwuḻ dhawaṯthun ŋayaŋuŋuru, bayikuyam nhan bayiŋ gayŋa God-Waŋarrma marimin yana milnyaŋꞌthun, gulumana bayiŋ ŋalmaliny nhangurun God-Waŋarrwurun. ");
INSERT INTO dhg_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Djinaŋ malaŋuyu barrakinydhu ŋalmaliny bayiŋ banha gulumanma nhanguḻ gamꞌ: guyaŋi ŋarru gayŋa barrakinynha yana nhä mala, ga marrambaꞌ-djakawarrundami rom, ga manaŋgan rom ga guwatharam yolŋuny mokuy-yupthuman ga ");
INSERT INTO dhg_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","räy-wanyuyi, goṯa-wakalmiŋgandami rom, ga dhuwurr-barrakinydji, ga djängum, ga mayaliꞌ-wilkthundami rom, ga djäl-gänaŋumi, ga maŋutji-ḏiyꞌ rom, goṯa-garrundami rom, ga marŋgi-rakaranhami rom, ga räy-ŋarrꞌŋarr rom, ga ŋayaŋu-wanyu rom. ");
INSERT INTO dhg_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Yo, bilanyayan banha barrakinyma mala bayiŋ gayŋa walma dhawurum ŋayaŋuŋurum, ga barrakinydjumana ŋalmaliŋgu ŋayaŋunhan. Ga bitjanya ḻinygu bayiŋ banha God-Waŋarrnham bitjuwayiŋ gulumana ŋalmaliŋgurun, banhayam nhanguḻim God-Waŋarrwuḻim milnyaŋꞌmin.” ");
INSERT INTO dhg_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Bewaḻiyam dhanal Djesuyum ga nhanguru guyurrꞌmiŋuyum warrayu guŋnharrumanan banhayam ŋirrima. Ga ŋarranam dhanal ŋirrima-guḻkumiḻin ŋirrimaḻi yäkuḻi Däyaḻin. Ga waythuwan dhanal banhalaya ŋirrimaŋa bala dhanal gulŋiyanan buṉbuḻin, ḻinygu ŋangawul nhan gayŋan banha Djesum ḏukṯukmiyin dhanal ŋarru yolŋum warra nhangu marŋgiyi banha nhan gayŋan banhalayam bitjuwayiŋ nyenan. Ŋarru gulkurun nhan banha djuḻuḻꞌyuwanam. ");
INSERT INTO dhg_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Ga banhalaya gayŋan baṯami nyenan ŋarru nhan banha ŋangawul Djuw bäpurrum. Ga yolŋum nhan banha waŋgala-wuyaŋinyaram ga Bänitjawuy, makaŋam Djiriya. Ga banha nhan Djesunham ŋäkul waythundam bala nhan ŋarranan bala garruwanan nhangu bitjanan, “Buku-djulŋi, ŋatjil ŋunha barrakinynha birrimbirrnha ḏupthuwa wakuꞌmiŋuwuru nyäkuru baṯamiwuru.” ");
INSERT INTO dhg_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Bala nhan Djesum mayaliꞌmurrun garruwan, “Dhaŋum ŋarru ŋurruŋum ŋatha guwaman yumurrkuꞌyu, ga muṉguynha ŋarru banha wärruŋdhum guwaman.” Bilanya banha mayalimꞌ gamꞌ: ŋurruŋum nhan ŋarru Djesuyu guŋgaꞌyun nhanguway nhan yolŋuny warrany Djuw malany ga ŋärrun nhan ŋarru guŋgaꞌyun waripunham bäpurruny yolŋuny warrany. ");
INSERT INTO dhg_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Bala nhan banha baṯamim ḏämbu-ganitjuman bitjanan, “Gulitj yana marrkapmi. Ŋarru bayiŋ banha wärruŋdhum guwaman yana gälkinyaram ŋatha bewalim banha yumurrkuꞌwurum biḻitŋuru.” Ga djinalaŋam banha bilanya mayaliꞌ gamꞌ: banha nhan gayŋa Djesuyu nhanguwayma yolŋuny warrany guŋgaꞌyun, ga bitjanya ḻinygu nhan ŋarru banha waripunham yolŋuny warrany guŋgaꞌyunya. ");
INSERT INTO dhg_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ga banha nhan Djesuyu bilanyawuyma ŋäkul bala nhan bitjanan garruwan, “Way, dhaŋum nhunu mä-wulitjnha yana garruwan. Gatjuy maŋgarran ŋirrimaḻin, ḻinygun banha barrakinyma birrimbirr gätthuwanan wakuꞌmiŋuwurum nhuŋguru.” ");
INSERT INTO dhg_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Bala nhan banha baṯamim ḏirruwanan ŋirrimaḻin. Ga banha nhan ŋirrimaŋam waythuwan, nhäŋalam nhan banha wakuꞌmiŋunham nhan gayŋan gayŋiyanan yakurr-ŋuwatjinan, ḻinygun nhanguru banha barrakinyma birrimbirr walmanan. ");
INSERT INTO dhg_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ga dhurrwaraŋuru bewaḻiyam Djesuyum guŋnharrumanan banhayam ŋirrima Däyam, bala ŋarranan balan Djaydanḻin, ŋarru batjiwarrma nhan warraṯthuwan ŋunha räy-warruwan, gumurr-djawꞌyuwan ŋoymurru ŋarkulaꞌmurrun. Ga mä-waŋganynha ŋaykan balan Galaliḻin guḻunḻi ga waythuwan dhanal banhalayan ŋirrimaŋa makaŋa yäkuŋa ‘Dikapulitjnha’. ");
INSERT INTO dhg_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ga banhalaya gayŋan yolŋu nyenan dhoŋuluꞌ banha ḻunduꞌmiŋuyu warrayu nhanany gutjparruwan balaya Djesuwuḻ. Ga ŋäŋꞌthuwan dhanal bitjan, “Buku-djulŋi ŋatjil goŋ-ŋalthuwa djinakuḻ yolŋuwuḻ mä nhan ŋarru ŋuwatji.” ");
INSERT INTO dhg_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Bala nhan Djesuyum gaḏaymanan banhaya dhoŋuluꞌnham gänaŋuḻin, bala nhan ŋarambiyan gulŋiyan nhanguḻ buthuruḻin, burrparḻi yana. Ga ŋarambiyaḻ nhan nhanguwaywuḻ dhupthuwan, bala ŋayathanan banha yolŋunhan ŋäṉarrnha. ");
INSERT INTO dhg_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ga ḏämbu-garramattjin nhan djiwarrꞌḻi bala yindi-ŋirꞌyuwanan bala garruwanan yänmurrun nhanguwaywurumurru Arrammurrun bitjanan, “Yipatha!” Bilanya gamꞌ mayaliꞌ, “Ḻapthuwan!” ");
INSERT INTO dhg_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ga bitjanam nhan banha garruwan bala banha yolŋuwum buthurum ḻapthuwanan, ga ŋäṉarrma nhangu banha dhayaḻyinan ŋuwatjinan yana, bala nhan gayŋan garruwanam ŋuwatjumanan. ");
INSERT INTO dhg_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Bala dhupal ḏirruwanan balaya yolŋuwuḻ warrawuḻ. Ga bitjan nhan Djesuyu dhanaliny dhurrwara-mukthumanam, “Ŋangawul nhuma ŋarru rakaram yolŋuwuḻim banha ŋaya dhaŋu yolŋuny bitjuwayiŋ ḏukthuman.” ");
INSERT INTO dhg_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ga yolŋuyum warrayu banha ŋäkulan dhäwum, ga mariminan dhanal banha mä-maŋmaŋdhuwanam. Ga bitjanan dhanal gayŋan banha rakaranhaminam, “Nhän dhaŋum ŋayaŋu-ganyimꞌthundamin rom, ŋatja! Djinaŋum yolŋuyu gayŋa ŋuwakurrun marimin djäma. Buthuru-dhumukthum gayŋa ŋäman ga yännharram gayŋa garruna.” ");
INSERT INTO dhg_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","3","Waŋganymiyum waluyu guḻku marimi yolŋu warra ḏämbu-ḻuŋꞌthuwan balaya Djesuwuḻ ŋänharawu dhäwuwu. Ga ḻinygu dhanal gayŋa nhangu banha malthunma ḻurrkunꞌnha walum, ga ŋangawulnha banha bitjuwayiŋ biyapulma ŋatha gayŋan ŋoyan. Bala nhan Djesum guykuyyuwanan nhanguway guyurrꞌmiŋuwum warrawu bala garruwan bitjanan, “Ŋayaŋu-wuyuwanan ŋaya dhaŋu djinakum yolŋuwu warrawu. Guḻkun dhaŋu yolŋum warra gayŋa yawungu bärrkuŋurum ŋaykam ga ḻinygun dhanal ḻurrkunꞌnha walum bitjuwayiŋ mala-manapanma ŋalmaliŋguḻ ga yanatj ḻinygu-u-u ga ŋatha ŋalmaliŋgu yawungu dhawarꞌyun. Ga ŋangawulnha ŋalma ŋarru dhanaliny dhaŋu yängum djaṉŋarrminham, dhanal bayiŋ bayan ŋunhuŋ gandarrŋam ḏalalakthun.” ");
INSERT INTO dhg_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ga dhanalim banha guyurrꞌmiŋum warra nhangu ḏämbu-ganitjuman, “Wäy, buku-djulŋi dhaŋum dhaŋu ŋayilpinꞌ ŋirrima,... nhalpiyana ŋalma ŋarru dhanaliny maranhu-wuŋanma, nhaliyun?” ");
INSERT INTO dhg_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ga nhanmam Djesuyum dhä-wirrkaꞌyuwan dhanaliny, “Nhämunhaꞌ gayŋa nhumam ŋatha ŋayathan?” Ga dhanalim ḏämbu-ganitjuman, “Marrkapmi, djabin yana dhaŋu dämbam.” ");
INSERT INTO dhg_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Bala nhan Djesuyum garruwanan dhanaliny, “Maꞌ ḏäpthuwan maŋgarra garminydjarrkŋan.” Bala nhan banha ḻurrkunꞌma ḏämba warraṯthuwanan bala buku-wuŋan God-Waŋarrnhan. Ga ganitjuman nhan bitjan yumurrkuꞌkuwan bala ŋarran guŋanan guyurrꞌmiŋuwuḻin nhanguwaywuḻ. Ga dhanalim ŋarran guŋan ŋunha yolŋunhan warrany. ");
INSERT INTO dhg_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ga ḻurrkunꞌ dhanal gayŋan guya mala ŋayathan. Ga buku-wuŋan nhan God-Waŋarrnha bayikuya guyawu, bala guŋanan guyurrꞌmiŋuwuḻin warrawuḻ bala dhanalim ŋarran yolŋunhan warrany guŋan. ");
INSERT INTO dhg_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Ga bukmakma banha yolŋum warra ga 4000 malam. Ga guwamanam dhanal ŋarran banha ŋatham ga maranhuyin dhanal bukmak yana. Ga dhawarꞌyuwanam dhanal guwamandaŋurum bala banha guyurrꞌmiŋuyum warrayu wapthumanan ŋarran bäytjinyaram ŋatha, ga dhaŋaŋguwanam dhanal djabin yilipim malany. Ga dhurrwaraŋuru bewaḻiyam nhan gayŋan Djesuyum yänguwanan dhanaliny ŋirrimaḻin. ");
INSERT INTO dhg_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ga banha dhanal yolŋum warra bitjuwayiŋ ŋaykanam ŋirrimaḻim, bala nhan Djesum ga guyurrꞌmiŋum warra nhangu ŋalthuwanan gayŋan marthaŋayḻin bala dhanal ŋarranan, ŋirrimaḻin yäkuḻi Dalmanuthaḻin. ");
INSERT INTO dhg_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ga banha dhanal Djesu ga bukmak banha nhämunha gayŋan malthuwan nhangu waythuwanan banhalayan waŋgalaŋa Dalmanuthan. Ga ḻurrkunꞌ yolŋu warra bewaḻi banha Baratjiwuru malaŋuru ŋarran nhanguḻ balaya Djesuwuḻ, bala dhanal gayŋan yän-ḏupthunminan mä dhanal ŋarru bawaꞌkuŋan nhanany. Ga bitjan dhanal nhanany garruwanam birrkaꞌyuwanam, “Maꞌ wilak maŋutji-wuŋan ŋanapiliŋguḻ ŋayaŋu-ṉirrundamim rom mä ŋanapu ŋarru nhäman ga mä-wulitjmiyin banha nhunu gulitj gayŋa ganydjarr ŋayathan God-Waŋarrwuŋ!”. ");
INSERT INTO dhg_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Bala nhan Djesum yindi-ŋirꞌyuwanan ga garruwan nhan bitjanan, “Banha ŋaya bayiŋ bilanyawuyma ŋäma, banham nhuma bayiŋ nhänany ŋayaŋu-ḻiyuna! Nhäwu nhuma gayŋa dhaŋu ŋayaŋu-ganyimꞌthundamiwum romgu ŋäŋꞌthun? Ŋangawul warra bitjaya ŋäŋꞌthuwa. Gulitj gayŋa dhaŋu ŋayaŋu-ganyimꞌthundamim rom gayŋiya, ŋarru ŋaya ŋarru ŋangawulnha bitjuwayiŋ djämam, yana bayiŋ nhumaliŋgum nhänharawu.” ");
INSERT INTO dhg_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ga bewaḻiyam nhan Djesum ŋarranan guŋnharrumanan yolŋunham warrany bala dhanal guyurrꞌmiŋum warra nhangu ŋaykanan buḏapthuwanan marthaŋayyun bayikuyam guḻungu, ŋunha galiꞌḻin. ");
INSERT INTO dhg_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Manymak, bala dhanal ŋarranan Djesum ga guyurrꞌmiŋum warra nhangu. Ga gandarrŋam banha guḻunŋa bala dhanal guyaŋinan banha dhanal meṉguwan ŋathawu warraṯthundawu. Ga waŋganynha dhanal gayŋan banha dämbam bitjuwayiŋ gutjparruwan. ");
INSERT INTO dhg_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ga nhanmam banha Djesuyum dhanaliny bitjuwayiŋ ŋäkul, dhanal gayŋan garrunmin ŋathawuy bala nhan bitjanan, “Dharraḏayiya, ga djägakunhamiya warra, ŋay, mä ŋarru nhumaliny ŋangawul mu mayaliꞌ-wilkthun ŋunhuŋum Geŋ Yaritthum ga Baratjiyum yolŋuyu warrayu. Bilanya dhanaliŋgu banha yänma malany bitjuwayiŋ ŋathawuy ḏululꞌyumanda.” ");
INSERT INTO dhg_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ga banha dhanal guyurrꞌmiŋuyum warrayu nhanguḻ ŋäkul bala dhanal mä-yumbalꞌyuwanan. Bala dhanal gayŋan garrunminan, “Nhalpiyan nhan dhaŋu marrkapꞌma garruwan,... linygu wilak ŋalma ŋangawul ŋatha gutjparruwan?” ");
INSERT INTO dhg_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ga nhanmam Djesum marŋgiyin dhanaliŋgu nhalpiyan dhanal gayŋan guyaŋin, bala nhan bitjanan, “Nhä nhuma gayŋa dhaŋu ŋathawuyma yana garrunmi... ŋangawul nhuma banha nyäku mayalimꞌ warraṯthuwan? Nhä nhumaliŋgu dhaŋu muḻkurrma dhumuktjinan? ");
INSERT INTO dhg_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ḻinygu mu nhuma gayŋan nhäŋalam, ŋarru nhuma ŋangawul yana dharaŋganam. Dhaŋum nhuma bitjuwayiŋ dhuŋamin nhänharawun. Ga ḻinygu nhuma gayŋan ŋäkulam, ga ŋangawul yana nhuma dharaŋgan, ga banhayam nhuma dhuŋamin bitjuwayiŋ ŋänharawun. ");
INSERT INTO dhg_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nhän nhuma dhaŋu ḏämbu-dhumuktjinan, ŋatja? banha ŋaya dämba malany ganiꞌ-ganitjuman ga maranhu-wuŋan 5000-nha yolŋuny warrany? Ga nhämunhaꞌḻi yilipiḻim nhuma banha bäytjinyaram ŋatha malany wapthuman?” Ga dhanalim ḏämbu-ganitjuman bitjan, “12-mu banha yilipim, marrkap!” ");
INSERT INTO dhg_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ga biyapul nhan Djesuyu dhä-wirrka'yuwan, “Nhä nhuma gayŋa dhaŋu guyaŋi mu banha ŋaya gani'-ganitjuman djabin ŋatha malany maranhu-wuŋandawu 4000-gu yolŋuwu warrawu? Ga nhämunha'ḻi yilipiḻim nhuma banha bäytjinyaram ŋatha malany wapthuman?” Ga dhanalim ḏämbu-ganitjuman, “Yo, djabin banha yilipi marrkap!” ");
INSERT INTO dhg_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Bala nhan Djesum bitjanan garruwan, “Gulitj dhuwan, ḻinygun nhuma dhaŋu nhäŋalan nhumaliŋguru maŋutjiyum, ŋarru nhäwun nhuma gayŋa ŋangawulma dharaŋgan banha ŋalaŋuru nyäku bayiŋ gayŋa ganydjarr ŋarra?” ");
INSERT INTO dhg_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ga bewaḻiyam nhan Djesu ga guyurrꞌmiŋum warra nhangu waythuwanan banhalayan Bithdjaydan waŋgalaŋa. Ga banhalayam dhanal yolŋuyu gutjparruwan bambaynha yolŋuny nhanguḻ Djesuwuḻ, ga ŋäŋꞌthuwan dhanal Djesuny nhan ŋarru ŋayathan banhaya bambaynha yolŋuny mä nhan ŋarru ŋuwatjin. ");
INSERT INTO dhg_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Bala nhan Djesuyum gaḏaymanan banha bambaynham yolŋuny gänaŋuḻin bewaḻiyam ŋirrimaŋuru. Bala nhan dhupthuwanan nhanany maŋutjim bala ŋayathanan, bala nhan dhä-wirrkaꞌyuwanan, “Ŋalan, nhäŋalan... nhunu?” ");
INSERT INTO dhg_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ga nhanmam banha yolŋum ḏämbu-garrwartjin ga ḏawaꞌyuwan nhan djarrpuḏayḻi ga dhunupaḻi galiḻi, bala ḏämbu-ganitjumanan, “Dhaŋu ŋaya gayŋa yolŋunham warrany nhäman, ŋarru mä bayiŋ gaŋga, bilanyan bitjuwayiŋ ḏarpa malany nyin maliꞌ-maliꞌyun!” ");
INSERT INTO dhg_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ga biyapulya nhan Djesu ŋarambiya-ŋalthuwan bayikuḻ yolŋuwuḻ maŋutjiḻi. Ga marimanan nhan gayŋan banha bambayma yolŋu maŋutji-ḏukṯukmiyinam nhänharawun yana. Bala nhan gayŋan bayiŋuya yolŋuyum ŋuwaḻyumanan nhäŋal. Ga ḻinygun nhangu banha maŋutjim bitjuwayiŋ ḻapthuwanan. ");
INSERT INTO dhg_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Bala nhan Djesuyum yänguwanan banhaya yolŋunham bitjanan, “Maŋgarran ŋirrimaḻin, ga ŋangawulnha ḏirruwa Bithdjaydaḻim.” ");
INSERT INTO dhg_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ga bewaḻiyam nhan Djesum ga guyurrꞌmiŋum warra nhangu buku-ḻiwꞌyumanan gayŋan ŋarran ŋunhalayam Djitjariya Bilipayma waŋgalaŋa. Ga banhalaya gandarrŋam bala nhan Djesuyum ŋäŋꞌthuwanan nhanguway guyurrꞌmiŋunham warrany bitjanan, “Wäy, waraparra, nhalpiyan bayiŋ gayŋa banha yolŋuyum warrayu rakaram,... yol dhaŋu ŋayam?” ");
INSERT INTO dhg_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ga dhanalim buku-ganitjuman, “Yolŋuyum warrayu nhuna bayiŋ gayŋa rakaram be warri nhunu Djonnha banha Buku-ḻupthumandamin yolŋu. Ga waripuyum warrayu nhuna bayiŋ gayŋa rakaram be warri nhunu Yilaydjan banha ŋaḻapaḻnha yolŋu God-Waŋarrwun djawarrkmi bamanꞌŋuwuynha. Ga waripuyum nhuna bayiŋ gayŋa rakaram dhaŋu nhunu waripu bitjuwayiŋ God-Waŋarrwuŋ djawarrkmi bamanꞌŋuwuy.” ");
INSERT INTO dhg_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ga biyapul nhan Djesuyu dhä-wirrkaꞌyuwan, “Wäy-y, nhumapim gayŋa nhalpiyan nhänany guyaŋi,... yol dhaŋu ŋayam?” Bala nhan Betam ḏämbu-ganitjuman nhangu bitjanan, “Marrkapmi, nhunum dhaŋu Christ banha Maŋutji-dhunupayumanda yolŋu God-Waŋarrwuŋun gänaŋꞌthumanda ŋätjiliŋuwuynha.” ");
INSERT INTO dhg_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Bala nhan Djesuyum dhanaliny dhurrwara-mukthumanan bitjanan, “Ŋangawulnha warra bukmakkum rakaraŋ, ŋay!” ");
INSERT INTO dhg_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ga bewaḻiyam nhan Djesuyum rakaranan nhanguway guyurr'miŋuwum warrawu bitjanan, “Ŋayapin yana dhaŋu Gulitjŋum Wal'ŋu Yolŋu, ganam' bitjuwayiŋ. Yo, yalalaŋumim ŋaya barkthu marimin yana dhaŋgaḏirryum ḻinygu ŋurru-warrundayŋuyum malayu ga ŋurruŋu-ḏalkarramiyum ga rom-marŋgikunharamiyum yolŋuyu warrayu nhänany barkthu ḻikandhu-ḏupthun, bala dhanal barkthu nhänany guwatharaŋun waŋayumun yana. Ga burrpar munha barkthu djuḻkthu bala ŋaya barkthu wälŋayin rakunyŋurum.” ");
INSERT INTO dhg_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ga banha nhan Djesu bitjuwayiŋ rakaranhaminam, bala nhan Betayum nhanany barkan warruwan bala dhaykuwanan nhanany bitjanan, “Marrkapmi, ŋangawul nhunu bitjayam garruwa! Ŋayam ŋarru dhanaliny guluman nhuŋguru guwatharanharaŋurum.” ");
INSERT INTO dhg_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ga bitjanyam nhan banha Betam garruwan ŋangawul God-Waŋarrwurum bitjuwayiŋ ŋayaŋuyu. Bala nhan Djesum ŋanydjaḻaꞌyuwanan bala ŋarran nhäŋalan guyurrꞌmiŋunham warrany nhanguway, bala nhan maḏakarritjthun yändhum garruwan Betanham bitjanan, “Mukthuwa! Dhuwanma gayŋa Djaytinnha garrun banha nhan buŋgawan waŋawun malaŋuwu. Gatjuy gätthuwan. Dhaŋu nhunu gayŋa yolŋuwuru ŋayaŋuyu garrun, ŋangawul God-Waŋarrwuru ŋayaŋuyu.” ");
INSERT INTO dhg_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Bala nhan Djesuyum waripunham yolŋuny warrany ga guyurrꞌmiŋunham warrany nhanguway yurrumꞌthumanan, bala nhan dhanaliny gayŋan marŋgikuwanan bitjanan, “Bayiŋ nhan ŋarru yolŋu gayŋa djälmiyi nyäkum malthundawu, nhan ŋarru gayŋa bitjanma ḻinygu malthun nyäkum, banhayam nhan ŋarru meṉguman bitjuwayiŋ nhanguwayma ŋayaŋu ga malthun ŋarru God-Waŋarrwurun ŋayaŋuwu, bayaya ŋarru banha yolŋu djälmiyi guwatharanharawum nhangu waŋayumandawun yana. Ga nhanmam ŋarru gayŋa bitjana ḻinygun malthuna yana, bitjan bayiŋ yolŋuyu ḻawꞌyuman nhanguway ḏarpa-mälakthumanda ḻambarryu, bala bayiŋ gumurrꞌyuna ŋarra waŋayinyarawun yana. ");
INSERT INTO dhg_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ga bayiŋ ŋarru yolŋu gayŋa nyena nhanguwaywurun yana wälŋawu, yurrumꞌthuman ŋarru ŋarra be nhä malany rom, yana bitjuwayiŋ murrukaykunharami, bayikuyam yolŋuwu ŋarru banha nhäm mala ga wälŋam nhangu winyaꞌyuna yana. Ŋarru banham yolŋu, banha nhan ŋarru waŋayi ḻinygu nhan bayiŋ gayŋa nyäkum malthun, ga rakaram bayiŋ gayŋa God-Waŋarrwun yana rom, yalalaŋumim nhan barkthu gayŋi banha nyinayim wälŋam dhawarꞌyundanharran. ");
INSERT INTO dhg_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Maꞌ ŋäkan warra! Bayiŋ nhunu yolŋu ṉukunydjam walꞌŋu, ŋunhuŋ nhä guḻkuꞌmim, ga bayiŋ nhan ŋarru banha God-Waŋarryum nhunany bitjuwayiŋ ḏupthunma, ga nhän nhunu ŋarru banha warraṯthunma? Ŋangawulnha! ");
INSERT INTO dhg_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ga bayiŋ nhunu gayŋa mäyu-ḏapthuman nhä malany djinakuwuy munathaꞌwuy, banham nhunu ŋarru ŋangawulnha buku-djuḻkthumanma guŋan ŋunhuŋ nhä wälŋawum nhuŋguwaywuru ḏirrunmaranharawu! ");
INSERT INTO dhg_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Yo, ŋäkan warra! Dhaŋum gayŋa djinaŋum djunama yolŋuyum warrayu djinalaŋam munathaꞌŋam djäma guḻkun marimin barrakinyma rom malany. Ga ŋangawulnha dhanal gayŋa ŋayaŋumiyu malthundawu bitjuwayiŋ God-Waŋarrwum. Ga bayiŋ nhunu ŋarru gayŋa räy-nhinathuŋganmi nyäkum malthundawu, ga marŋgikunhawum nyäkuru, ŋayam ŋarru bitjuya ḻinygu nhuŋgum räy-nhinathuŋganmi, ga ŋangawulya nhunanham rakaraŋ ŋunhalam God-Waŋarrwuḻim gumurrŋa. Ḻinygu ŋayam barkthu banha Gulitjŋum Walꞌŋu Yolŋu, ḏirrun bewaḻi djiwarrꞌŋurum ŋapa-malamin ŋanapun djiwarrꞌwuynha dhäwumin yolŋu warra. Ga yarrupthum ŋanapu barkthu banha djiwarrꞌŋurum djeŋarraꞌyakaynha bäyman galumanyaŋnha, ga bilanyamiyun barkthu banha yolŋuyum warrayu dharaŋgum nhänany. ");
INSERT INTO dhg_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yo, ŋangawul warra meṉguŋam nyäku yänma, ŋay! Djinalaŋa malaŋa dhaŋu nhuma ŋarra djingaryun, banha nhuma ŋangawul yana bitjuwayiŋ waŋayin, yalalaŋumiyum nhuma barkthu banha ḻurrkunꞌthun yana yolŋuyum warrayu nhäŋun nhan ŋarru God-Waŋarryum nhanguway romnham ŋarranharamiŋgun, ganydjarryum marimin walꞌŋu murrukayyun.” ");
INSERT INTO dhg_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ga 6 bitjuwayiŋ walu djuḻkthuwan bala nhan Djesuyum gaḏaymanan Betanhan ga Djayimnhan ga Djonnhan, mä dhanal ŋarru bukuḻin ŋaykam yolŋunharraḻin. Ga banha dhanal ŋunha ḏämbum ŋayathan bala dhanal nhäŋalam Djesunham nhan waripuŋuyinan buyum maŋutjiŋam dhanaliŋguḻ. ");
INSERT INTO dhg_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ga girrimꞌ nhangu gayŋan banha biyapulnha walꞌŋu dhika miḻŋꞌmiḻŋdhuwan, gaywaraŋun yana lanyiŋnha bäyman, banha gayŋa djuḻkthumana bilaŋ nhä watharr marimi girriꞌ. ");
INSERT INTO dhg_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ga ganyimꞌthuwanan dhanal banha nhäŋalam nhanany Djesunham nhan gayŋan garruwanam bayikuḻiyan ŋätjiliŋuwuywuḻin ŋaḻapaḻwuḻ wulaykuḻ, Yilaydjawuḻin ga Mawtjitjkuḻin. ");
INSERT INTO dhg_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Ga mariminan dhanal banha guyurrꞌmiŋum warra biyaṉiyinam ga nhanmam banha Betam mä-yumbalꞌyuwanan bala nhan banha guyaŋinyanharran garruwanam bitjanan gam, “Wäy Garray, ŋuwakurrun dhaŋu marimin bay! Nhä banha ŋuwakurru ŋanapu ŋarru nhumaliŋgu warrawꞌma malany warkthun?... waŋganyma nhuŋgu ga waŋganyma Yilaydjawu ga waŋganyma Mawtjitjkun?” ");
INSERT INTO dhg_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ga bewaḻiyam bala waŋupinin maḻŋꞌthuwan bala yana ŋäkirrinan dhanaliny. Bala dhanal ŋäkulan rirrakaynha nhan gayŋan garruwan bewaḻiya waŋupiniꞌŋurum bitjanan gamꞌ, “Ŋäkan warra! Dhuwaniyan banha nyäkuwayma walꞌŋu gäthuꞌmiŋu marrkapma. Nhanguwaynha warra buthuru-bitjuwam!” ");
INSERT INTO dhg_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ga banha dhanal bitjuwayiŋ ŋäkulam rirrakayma, ga ḏawaꞌyuwanam ga nhäŋalam dhanal Djesunhan yana nhanapinyaynhan. ");
INSERT INTO dhg_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ga bewaḻiyam bala nhan Djesum ga guyurrꞌmiŋum warra nhangu martjmartjuwanan yarrupthuwanan bukuŋurum. Bala nhan Djesuyum garruwanan dhanaliny bitjanan, “Nhä nhuma dhaŋu bitjuwayiŋ nhäŋal, ŋangawulnha nhuma ŋarru rakaramam yolŋuwuḻim warrawuḻ. Ŋaya mu dhaŋu Gulitjŋum Walꞌŋu Yolŋu. Ŋurruŋum ŋaya ŋarru waŋayi ga biyapulya ŋaya barkthu banha wälŋayi. Ga ŋärrun nhuma barkthu banha gayŋi yolŋuwuḻim warrawuḻ rakaraŋ.” ");
INSERT INTO dhg_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ga baṯ-bitjanan dhanal gayŋan banha yänma nhanany Djesunham ŋayathan ga ŋangawulnha dhanal banha yolŋuwuḻim rakaran. Bala dhanalim banha ḻurrkunꞌma nhangu guyurrꞌmiŋu warra gayŋan dhä-wirrkaꞌyunminan bitjanminan, “Nhäwu nhan banha bitjanyam garruwan? Be nhan barkthu biyapul wälŋayi rakunyŋurum? Nhalpiyun banha barkthu bitjuyam maḻŋꞌthu?” ");
INSERT INTO dhg_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Bala dhanal nhanany dhä-wirrkaꞌyuwanan bitjanan, “Nhäwu bayiŋ gayŋa banha Rom-marŋgikunhamiyum warrayu rakaram banha nhan ŋarru Yilaydja ŋurruŋum waythu, ga ŋärrun barkthu nhanmam Christma banha Maŋutji-yunupayumandam yolŋu waythu? Ga nhunupim gayŋa nhalpiyana guyaŋi way, Marrkapmi?” ");
INSERT INTO dhg_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Bala nhan Djesum ḏämbu-ganitjuman bitjanan, “Gulitj dhuwanma. Nhän ŋatjil ŋarru banha banhaya bamanꞌŋuwuy ŋaḻapaḻ yäku Yilaydja ŋurruŋum waythun, ŋätjilmiŋganma batjiwarrma yäkthun nhangum banha Maŋutji-yunupayumandawum Yolŋuwu banha nhan God-Waŋarryu ŋätjilmiŋgan dhä-ŋätjil yana. Ga nhäwun nhumam bayiŋ gayŋa dhaŋu djinaŋum warrayu ŋangawulma bitjuwayiŋ dharaŋgan banhayam malany dhäwu ŋunha wukirriwuyma God-Waŋarrwuḻim djorraꞌŋa, bayikuwuyma banha Gulitjŋuwuruyma Walꞌŋu Yolŋuwuruy? Ŋarru ḻinygu mu dhanal banha bitjuwayiŋ dhäwum nhanguruy wukirri, ga yolŋuyum warrayu nhanany banha ḏämbuyu-ḏupthuwanan bala dhanal ŋarru guwatharaman nhanany waŋayumana yana. ");
INSERT INTO dhg_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Gatjuy ŋuwatjuman warra mäkiri-witjuwam. Banhayam banha ŋätjiliŋum yolŋu Yilaydjam ḻinygu nhan waythun. Ŋarru yolŋum warra dhanaliŋguwaynha ŋayaŋuwu malthuwan bala barrakinydjumanan nhananham nhäŋal. Ga bilinyayan banha dhanal gayŋan ŋätjiliŋuwuyyum djawarrkmiyu warrayu yänma wukirri ŋätjilim.” ");
INSERT INTO dhg_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ga banha dhanal Djesu ga ḻurrkunꞌ banha guyurrꞌmiŋu warra nhangu waythuwanam waripuwum warrawu guyurrꞌmiŋuwu, bala dhanal nhäŋalan guḻkunhan yolŋuny warrany. Bala banha yolŋum warra ḻuŋꞌthuwanan bala gayŋan nhäŋalan Djesuwun banha guyurrꞌmiŋuny warrany dhanal gayŋan dhaykunharamin ŋunha rom-marŋgikunharami yolŋu warra. ");
INSERT INTO dhg_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ga banha dhanal bitjuwayiŋ yolŋuyum warrayu nhäŋalam nhanany Djesunham bala dhanal ganyimꞌthuwanan ḻinygu dhanal banha bitjan guyaŋin yana warri nhan gayŋan baḏak yana nyenan ŋunhalaya bukuŋa. Bala dhanal gumurr-gätthuwanan nhangu. ");
INSERT INTO dhg_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Bala nhan Djesuyum dhä-wirrkaꞌyuwanan dhanaliny bitjanan, “Nhäwuy nhuma gayŋa dhaŋu dhaykunharamim?” ");
INSERT INTO dhg_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ga nhanmam waŋganyma yolŋu bitjanan garruwan gamꞌ, “Marrkapmi ŋäka nhänany! Dhaŋu ŋaya yothuny ḏirramuny nyäkuway gutjparruwan mä nhunu ŋarru ḏukthuman nhanany. Ŋangawul nhan dhaŋu yännharra ga dhaŋu nhanany bayiŋ gayŋa barrakinydhu birrimbirryu mala ŋayathan. ");
INSERT INTO dhg_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ga banha nhanguḻ bayiŋ barrakinyma birrmbirr gulŋiya bala nhan bayiŋ nhanany butparkthumana nyin munathaꞌḻin. Bala nhanguḻ bayiŋ dhurrwaraŋurum ŋarruŋ ŋälma gatjkatjuna bala nhan bayiŋ gayŋa rirra-rathanmin. Ga rumbalma nhangu bayiŋ wanyuyin bilanyan bitjuwayiŋ ḏarpan. Ga ŋäŋꞌthuwan ŋaya dhaŋu guyurrꞌmiŋuny warrany nhuŋgu guŋgaꞌyundawu, dhawaṯthumandawu djinaku birrimbirrwu, ŋarru gulkurun.” ");
INSERT INTO dhg_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ga banha nhan Djesuyu bilanyawuyma ŋäkul bala yana nhan maḏakarritjtjinan dhanaliŋgu ga bitjanan nhan garruwanam, “Nhä nhuma dhaŋu yolŋum warra dharaŋandanharram, ḻinygu mu ŋaya gayŋan nhumaliny dhaŋu marŋgiyumanam bitjan mu ḻinygu yana, ga nhä nhuma gayŋa dhaŋu dhiryun marŋgiyim? Ŋangawul nhuma gayŋa nyäku dhaŋu gulitjma mä-wulitjmiyi, ŋatja? Nhämunhaꞌmin ŋaya ŋarru nhumaliŋgu gäḻkuḻamam? Gu, gutjparruwan warra dhuwan yothunham rälin!” ");
INSERT INTO dhg_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Bala dhanal ḻawꞌyumanan banhaya yothunham bala gutjparruwanan nhanany Djesuwuḻin. Ga banha nhan bayiŋuya barrakinydhu birrimbirryu nhäŋal Djesunham bala nhan yana ḏupthuwanan banha yothunham munathaꞌḻin baya gayŋan djalkthunmin, ga dhurrwaramurrum ŋarran ŋälma gatjkatjuwanan. ");
INSERT INTO dhg_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Bala nhan Djesuyum dhä-wirrkaꞌyuwanan banha moriꞌmiŋunham bitjanan, “Nhätha nhan gayŋan dhaŋu bitjanam?” Bala nhan banha moriꞌmiŋuyum bitjanan rakaranan, “Bilinyamiyu banha nhan yutjuwaḻ yana. ");
INSERT INTO dhg_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Wikarraŋumi nhan gayŋan dhaŋu barrakinyma birrimbirr djälmiyin nhangu guwatharanharawum. Ga bitjan ḻinygu nhan bayiŋ gayŋa nhanany djalkthun, waripum bayiŋ ḏupthun ŋorrtjaḻin ga waripum bayiŋ garmakḻin guḻwuḻyuman. Ga buku-djulŋi ŋatjil ŋalinyuny guŋgaꞌyuwa, gu? Bayiŋ dhaŋu gumurr-yalŋgim, maꞌ maŋutji-wuyuwan ŋalinyuŋgu, ḏukthuman dhaŋum yothunham.” ");
INSERT INTO dhg_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Bala nhan Djesum bitjanan garruwan, “Nhäwu nhunu bitjanam garruwan, ‘Bayiŋ dhuwan gumurr-yalŋgim’? Ŋayam ŋarru dhuwan djäma yana, bayiŋ nhunum ŋatjil ŋarru mä-wulitji nyäkum!” ");
INSERT INTO dhg_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Bala yana nhan banha moriꞌmiŋum mäḻiŋganminan bitjanan, “Marrkapmi, ḻinygun dhaŋu ŋayam mä-wulitjmiyinan. Gu, guŋgaꞌyuwan nhanany, mä nyäku ŋarru mä-wulitjinyaram marimin yana wanyuyi!” ");
INSERT INTO dhg_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ga bilanyamiyum waluyu nhan Djesuyum nhäŋalan guḻkunhan yolŋunham warrany dhanal ŋarran giṯthuwan räli malami. Bala nhan yän-wuŋanminan bayikuya barrakinygum birrimbirrwu bitjanan, “Nhunu dhaŋu birrimbirr, walmiyan djinakuruya yothuwurum, mä nhan ŋarru ŋäman ga garruna! Ga ŋangawulnha biyapulma gulŋiya nhanguḻ!” ");
INSERT INTO dhg_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ga banha nhan bayiŋuya barrakinydhum birrimbirryu ŋäkulam Djesunham garrunda, bala nhan yatjuwanam mariminan. Bala nhan banha yothum bitjuwayiŋ gälkinan, ḏalalakthuwanan, nhawun nyin rakunynha gayŋiyan. Bala gayŋan banha yolŋum warra rakaranhaminan banhalayam, “Wäy ḻinygun nhan dhaŋu waŋayinan!” ");
INSERT INTO dhg_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Bala nhan Djesuyum ŋarambiyan nhanany ŋayathan bala ṉakanharamiŋganan. ");
INSERT INTO dhg_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Bala dhanal Djesuyum ga guyurrꞌmiŋuyum warrayu nhanguru guŋnharrumanan banhayam ŋirrima bala gulŋiyan buṉbuḻin. Bala dhanal banhalayam dhä-wirrkaꞌyuwanan Djesunham bitjanan, “Wäy, nhäwu banha ŋanapum ŋangawul walmanharamiŋgan banhayam barrakinynha birrimbirrnha?” ");
INSERT INTO dhg_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Bala nhan Djesum garruwan bitjanan, “Ŋuwatjuma ŋäkam! Bilanyayam banha birrimbirr mala barrakinymin marimin. Ga bayiŋ nhuma ŋarru gayŋa ŋangawulma bitjuwayiŋ bukumiŋgan guŋgaꞌyundawum, nhumam ŋarru ŋangawulnha bilanyanham birrimbirrnha mala dhawaṯthuman yolŋuwurum.” ");
INSERT INTO dhg_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ga bewaḻiyam bala nhan Djesuyum ga guyurrꞌmiŋuyum warrayu nhanguru guŋnharrumanan banhayam ŋirrima bala dhanal ŋarran Galaliḻin makaḻi waŋgalaḻi. Ga ŋangawul nhan gayŋan banha djälmiyin dhanal ŋarru yolŋum warra bitjuwayiŋ nhangu marŋgiyi banha nhan gayŋan banhalayam nyenan. ");
INSERT INTO dhg_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Yo, djälmiyinam nhan gayŋan, nhan ŋarru gayŋa guyurrꞌmiŋunhan warrany yana nhanguway marŋgiyuman. Ga bitjan nhan garruwanam gamꞌ, “Yaka wikarra, bala dhanal barkthu nhänany ŋarambiya-guŋun waripuwuḻin mulkuruwuḻin yolŋuwuḻ. Bala dhanal barkthu nhänanham banha Gulitjŋunham Walꞌŋu Yolŋuny guwatharaŋun murrkayꞌyumun. Ga waŋayi ŋaya barkthu yulŋum, ŋarru ŋaya barkthu biyapulya bitjuwayiŋ wälŋayi dhurrwaraŋuru burrparyum munhayu.” ");
INSERT INTO dhg_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Yo, bitjanyan nhan gayŋan banha Djesuyum rakaran, ŋarru nhangu banha guyurrꞌmiŋum warra mä-yumbalꞌyuwanan. Ga ŋangawulnha dhanal banha biyapulma bitjuwayiŋ nhanany dhä-wirrkaꞌyuwan. ");
INSERT INTO dhg_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ga bewaḻiyam bala dhanal Djesum ga guyurrꞌmiŋum warra nhangu ŋaykanan, ga waythuwan dhanal waŋgalaŋa yäkuŋa Gapuniyamnha. Ga banha dhanal gulŋiyanam buṉbuḻim bala nhan Djesuyum dhä-wirrkaꞌyuwanan dhanaliny bitjanan, “Wäy, nhäwuy mu nhuma ŋarran banha batjiwarr-ŋupanam dhurrwara-ḏupthunmin?” ");
INSERT INTO dhg_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ga dhanalim banha ŋangawulnha nhangu ḏämbu-ganitjuman banha nhäwuy dhanal ŋarran garrunmin batjiwarr-ŋupan, yol gayŋa ŋurruŋuyi bewaḻiya ŋurrukŋuru. ");
INSERT INTO dhg_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Bala nhan Djesum nyenanan bala nhan gayŋan dhanaliny marŋgikuwanan bitjanan, “Bayiŋ nhunu gayŋa ŋunhuŋ yol yolŋu djälmiyi nhunu ŋarru ŋurruŋuyim, nhunum bayiŋ bitjun bitjuwayiŋ dhaŋu gayꞌ yolŋu djämamin yana bawalamiwun yolŋuwu.” ");
INSERT INTO dhg_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Bala nhan Djesuyum yothunhan ḻawꞌyuman bala dhangiꞌyuwanan nhanany, bala gunhanan ṉapuŋggaꞌḻin gumurrḻin dhanaliŋguḻ, bala nhan bitjanan garruwan, ");
INSERT INTO dhg_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Bayiŋ nhunu ŋarru ŋunhuŋ yol yolŋu gumurr-ŋuwatji räywuywum yolŋuwu nhawun djinakum gay' yothuwu, ḻinygu nhan banha nyäku bitjuwayiŋ yolŋu, banhayam nhunu nyäkun gumurr-ŋuwatjin. Ga bayiŋ nhunu nyäkum gumurr-ŋuwatjin, banham nhunu gumurr-ŋuwatjin nyäkuru mori'miŋuwun, bayikuyan banha nhan nhänany djarr'yuwan ŋarranharawu räli dhambal munathaḻ' waŋgalaḻ.” ");
INSERT INTO dhg_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ga dhurrwaraŋuru bayiwaḻiyam bala nhan Djesuwum guyurrꞌmiŋu yäku Djonma garruwan bitjanan, “Way marrkapmi, ŋunha ŋanapu yolŋuny nhäŋal nhan gayŋan barrakiny birrimbirr walmanharamiŋgan nhuŋguru yäkuyu. Ŋarru ŋanapum nhanany guluman ḻinygu nhan banha ŋangawul ŋalmaliŋguḻ bitjuwayiŋ malaŋuru.” ");
INSERT INTO dhg_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Bala nhan Djesum bitjanan dhanaliŋgu ḏämbu-ganitjuman, “Ŋangawul nhuma warri banha gulumarra nhanany. Ḻinygu banha nhan ŋarru gayŋa yolŋuyu djäma ganydjarrmim rom nyäkurum yäkuyu, ga yalalam nhan ŋarru banha ŋangawulnha nyäkum barrakinydjuman garrun. ");
INSERT INTO dhg_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ga bayiŋ nhan yolŋu ŋangawulma bitjuwayiŋ baku-ŋayathandami, banhayam nhan ŋalmaliŋguran galiꞌŋa. ");
INSERT INTO dhg_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ŋuwatjuma guyaŋiyam! Bayiŋ nhan bilaŋ yol yolŋu marŋgi banha nhunu bayiŋ gayŋa malthun Maŋutji-yunupayumandawum yolŋuwu, bala dhanalim ŋarru nhuna guŋgaꞌyuna. Nhanmam ŋarru banha God-Waŋarryum banhayanham yolŋuny ŋangawulnha bitjuwayiŋ meṉgum, bayaya banha nhan ŋunhuŋ garmak yana nhangu bitjuwayiŋ guŋan.” ");
INSERT INTO dhg_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ga biyapul nhan Djesu garruwan bitjan, “Bayiŋ ŋarru ŋunhuŋ yolthu yolŋuyu maŋutji-warrun nyäku yothuny barrakinyḻi romḻi, bala nhan ŋarru banha bitjuwayiŋ guluna nyäkurum mä-wulitjinyaŋuru, ŋuwakurrum banha bayikuyam yolŋuwu maŋutji-warrundamiwum nhanany ŋarru mayaŋnha mataꞌyuman rakiꞌyun, murrukaymiyun ṉutjurruyu, bala ḏupthuna dhulmuḻin ḏamurruŋꞌḻin garmakḻi, mä nhan ŋarru guḻwuḻyuna. ");
INSERT INTO dhg_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ga bayiŋ nhuŋguru goŋdhu bitjuwayiŋ ŋunhuŋ nhä barrakiny warkthuwan, nhunum gulkthuwan banhayam goŋ. Ḻinygu ŋuwakurrum nhuŋgu nhunu ŋarru barkthu djiwarrꞌḻim gulŋiyi goŋ waŋganymin. Ga bayiŋ nhunu baḏak yana goŋ-burrparmim, nhunanham barkthu ḏupthu ŋunha ŋorrtjaḻin ŋunha dhä-girꞌyundamiḻin waŋgalaḻi. ");
INSERT INTO dhg_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ga banhayam dhaŋu barrakinynha marimin waŋgala. Ga ŋorrtjam bayiŋ ŋangawulnha ŋulipalyi ŋunhayam waŋgalaŋa. Ga mewirrimꞌ bayiŋ gayŋa wälŋan yana gaḻun, barrakinydjumana bayiŋ ŋarra ŋunhuŋ nhäm malany. ");
INSERT INTO dhg_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ga bayiŋ nhuŋguru ṉukuyu gutjparruwan nhuna barrakinyḻi, gulkthuman dhuwan ṉukunham. Ḻinygu ŋuwakurrum nhuŋgu nhunu ŋarru barkthu djiwarrꞌḻim djuḏupthu ṉuku waŋganymin. Ga bayiŋ nhunu baḏak yana ṉuku burrparmim nhunanham barkthu ḏupthu ŋunha ŋorrtjaḻin banha dhä-girꞌyundamiḻin waŋgalaḻi. ");
INSERT INTO dhg_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ga banhayam dhaŋu barrakinynha marimin waŋgala. Ga ŋorrtjam bayiŋ banha ŋangawulnha ŋulipalyi ŋunhayam waŋgalaŋa. Ga mewirrimꞌ bayiŋ gayŋa wälŋan yana gaḻun, barrakinydjumana bayiŋ gayŋa yana ŋunhuŋ nhäm malany. ");
INSERT INTO dhg_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ga bayiŋ nhuŋguru maŋutjiyu nhuna gutjparruwan barrakinyḻi romḻi, nhunum yana ḏulŋurrꞌyuwan maŋutjim nhuŋguway bala ḏupthuwan, ḻinygu ŋuwakurrum nhuŋgu nhunu barkthu djiwarrꞌḻim gulŋiyi maŋutji waŋganymin, ga bayiŋ nhunu maŋutji burrparmim yana, nhunanham barkthu ḏupthu ŋunha ŋorrtjaḻin ŋunha dhä-girꞌyundamiḻin waŋgalaḻi. ");
INSERT INTO dhg_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘Ga banhayam dhaŋu barrakinynha marimin waŋgala. Ga ŋorrtjam bayiŋ banha ŋangawulnha ŋulipalyi banhalayam waŋgalaŋa. Ga mewirrimꞌ bayiŋ gayŋa wälŋan yana gaḻun, barrakinydjumana bayiŋ ŋarra ŋunhuŋ nhäm malany,’ ga bilanya. ");
INSERT INTO dhg_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Yo, ga God-Waŋarryum ŋarru banha birrkaꞌyuna nhanguwayma malthundaminy warrany gumurr-wanyumurrun rommurru, bitjan bayiŋ gayŋa yolŋuyu ḏämbaꞌḏambakum nhanguway gaṉany dhuṉḏayyuman ŋorrtjayu. ");
INSERT INTO dhg_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Manymak, djeꞌlam dhaŋu ŋuwakurru, bayiŋuyan bayiŋ banha ŋathanham dhäkaymiŋgan. Ga banha ŋarru dhäkim dhawarꞌyun banham barrakinynha bitjuwayiŋ, bala bayiŋ djalkthuna. Yo, nhumam bitjan nhawun banha djeꞌlan, dhäkaymiŋganmiyan mä nhuma ŋarru gayŋa ŋuwatjumana nyenam yolŋuwuram warrawura malaŋa, mä-ŋuwatjinyaramin ŋarru gayŋa bukmaknha. Bilanya dhaŋu! Mä gaŋga warra dhaykunharamiyam, yol ŋarru buŋgawayi ga yol räywuy!” ");
INSERT INTO dhg_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Bala nhan Djesum ŋarranan balan Djudiyaḻin makaḻi waŋgalaḻi. Ga balan bitjanan waripuḻin ŋirrimaḻi ŋunha bala mayaŋꞌŋa Djodannha galki galiꞌ dhimurrun. Ga guḻkun gayŋan banha yolŋum warra ḻuŋꞌthuwan nhanguḻ. Ga biyapulya nhan gayŋan Djesuyum bitjuwayiŋ marŋgikuwan. ");
INSERT INTO dhg_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ga Baratji yolŋu warra balaya ŋaykan bala dhanal gayŋan dhä-wirrkaꞌyuwanan nhanany, yäna gayŋan birrkaꞌyuwan, bitjan, “Nhalpiyan mu gayŋa ŋunha ŋalmaliŋgum rom garrun,... nhan ŋarru ḏirramuyu guŋnharrumana nhanguway baṯaminynham bala yänguman nhanany?” ");
INSERT INTO dhg_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ga nhanmam Djesum ḏämbu-ganitjuman bitjan, “Guyaŋiya ŋatjil, nhalpiyan gayŋa banha Mawtjitjkum rom garrun bayikuyam banha ŋalmaliŋgurum romgu?” ");
INSERT INTO dhg_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ga dhanalim ḏämbu-ganitjuman, “Ŋunha ŋalmaliŋguru mala-ŋurrkanhayŋuwum Mawtjitjkum gayŋa rom barraŋgaꞌyun ŋalmaliŋgum bitjan: Ŋurruŋum nhan ŋarru djorraꞌ ŋatjil wukirri guŋnharrumanminyawu, ga ŋärrun nhan ŋarru gananma nhanany.” ");
INSERT INTO dhg_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Bala nhan Djesum ḏämbu-ganitjuman bitjanan, “Ŋäka warra! Gulitjmu nhan banha mala-ŋurrkanhayŋuyum Mawtjitjthum bitjanyam rom nhinathuŋgan, ḻinygu nhuma dhaŋu ŋayaŋu-wanyumi. ");
INSERT INTO dhg_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ga ŋangawul warra banhayam banha dhäwuny meṉguŋ ŋay, banha ŋurruyirrꞌyundam, banha nhan God-Waŋarryu bokman dhaŋu djiwarrꞌ waŋgala ga dhaŋu munathanyꞌ waŋgalany! Ŋunha gayŋa wukirriwuy djingaryun bitjan gamꞌ, ‘God-Waŋarryu banha bokman yolŋunham, ḏirramuny ga baṯaminy. ");
INSERT INTO dhg_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ga bayikuyan gämurruꞌwu nhan ŋarru banha ḏirramuyum bitjuwayiŋ guŋnharruman nhanguway ŋäṉḏiꞌmiŋunham ga moriꞌmiŋunham, bala ŋarran ga warraṯthuna nhanguway baṯaminhan, mä dhupal ŋarru nyenan ŋayaŋu-waŋganynha, ");
INSERT INTO dhg_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ga burrparma banha bitjuwayiŋ waŋganydjinan.’ ");
INSERT INTO dhg_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ga banha nhan God-Waŋarryu dhupaliny waŋganydjumanam, ga ŋangawulnha ŋarru banha dhupaliny bitjuwayiŋ ŋunhuŋ yolthum bärrkuwaḻyuman, ḻinygu banhayam dhaŋu barrakinynha marimin rom!” ");
INSERT INTO dhg_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ga bewaḻiyam nhan Djesu ga guyurrꞌmiŋu warra nhangu gulŋiyanan buṉbuḻin guŋnharran. Ga banhalayan dhanal gayŋan ŋäŋꞌthuwanam nhanany Djesunham bitjanan, “Nhä mu nhunu gayŋan banha ŋanapiliny marŋgikuwanam yuṯayuṯaŋumim?” ");
INSERT INTO dhg_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Bala nhan Djesum ḏämbu-ganitjuman bitjanan, “Bayiŋ ŋarru ḏirramuyu guŋnharruman nhanguway baṯaminy ga warraṯthun nhan ŋarru ŋunha waripunhan, banhayam nhan gayŋa marrambanꞌ warkthun. ");
INSERT INTO dhg_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ga bilanyaya ḻinygu baṯamiwum. Bayiŋ nhan ŋarru guŋnharruman nhanguway dhuwayꞌmiŋuny bala gätthun ga waripunhan warraṯthun, banhayam nhan marranbanꞌ bitjuwayiŋ warkthuwan.” ");
INSERT INTO dhg_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Waŋganymim, yolŋuyu warrayu gutjparruwan dhanaliŋguway yumurrkunyꞌ Djesuwuḻ, mä nhan ŋarru dhanaliŋguḻ goŋ-ŋalthun ga ḏämbumiŋgan ŋäŋꞌthun God-Waŋarrnha mä nhangu ŋarru banha ŋayaŋu-ŋuwatjinyamim rom maḻŋꞌthuna dhanaliŋguran. Bala dhanalim banha guyurrꞌmiŋuyum warrayu dhaykuwanan dhanaliny ŋaŋꞌŋaŋdhuwanan. ");
INSERT INTO dhg_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ga banha nhan Djesuyum dhanaliny nhäŋal bilanyaḻim bala nhan maḏakarritjtjinan nhanguwaywuru guyurrꞌmiŋuwum warrawu bala nhan garruwan bitjanan, “Yaw, ŋangawul dhuwan yumurrkuꞌnham ŋaŋꞌŋaŋdhuwa, ḻinygu God-Waŋarrwum dhaŋu yolŋu warra bilanyayan bitjuwayiŋ dhaŋuynha warra, gayꞌ. ");
INSERT INTO dhg_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Yo, ŋuwatjuma warra bitja guyaŋiyam. Bayiŋ ŋarru banha ŋunhuŋ yol gulitjma walꞌŋu gayŋa djälmiyi God-Waŋarrwum, dhanalim ŋarru gulitjumana yana ŋayaŋumiyim nhangu, bitjana bitjuwayiŋ dhaŋuy warra yumurrkuꞌ bayiŋ gulitjuman gayŋa ŋayaŋumiyi dhanaliŋguwaywu ŋäṉḏiꞌmiŋuwu ga moriꞌmiŋuwu. Ga banha ŋangawulma, dhanalim ŋarru banha ŋangawulnha yana God-Waŋarrwum bitjuwayiŋ yumurrkuꞌ.” ");
INSERT INTO dhg_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ga dhurrwaraŋuru bewaḻiyam bala nhan Djesuyum dhanaliny gayŋan yumurrkuꞌnham ḻawꞌḻawyumanan, bala nhan gayŋan goŋ-ŋalthuwanan bala ḏämbumiŋganan God-Waŋarrwuḻin nhan ŋarru dhayuŋgana nhanguway ŋayaŋu-ŋuwatjinyamim rom dhanaliŋguḻin, bukmakkuḻin yana. ");
INSERT INTO dhg_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ga banha nhan Djesu gayŋan gurkuꞌyuwanam ŋarranharawum, bala nhangu ḏirramun waythuwan. Ga ḏämbu-nyilŋꞌthuwan nhan Djesuwuḻ gumurrŋa bala nhan dhä-wirrkaꞌyuwanan bitjanan, “Ŋuwakurru Marŋgikunhami, ŋaya nhuna dhä-wirrkaꞌyun ŋatjil. Bilanya dhaŋu gamꞌ: Nhalpiyan dhika ŋaya ŋarru yulŋum, mä ŋaya ŋarru gulitjma yana marŋgiyi banha ŋaya barkthu djiwarrꞌŋam nyenay God-Waŋarrwuḻim wikarraŋumim, wälŋa-dhawarꞌyundanharran?” ");
INSERT INTO dhg_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ga nhanmam Djesum dämbu-ganitjuman, “Nhäwu nhunu dhaŋu bitjanam garruwan, ‘Ŋuwakurru Marŋgikunharami’?, bitjanam. Ŋangawul dhaŋu ŋunhuŋ yol yolŋu gulitjma walꞌŋu ŋuwakurru, God-Waŋarr dhaŋu nhanbayin yana ŋuwakurrum. ");
INSERT INTO dhg_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ḻinygu mu nhuma dhaŋu God-Waŋarrwurum yän-wuŋanminyarawu marŋgi banha gayŋa bitjan garrun, ‘Ŋangawul yolŋuny guwatharaŋ waŋayuma; Ŋangawul marrambaꞌyiya; Ŋangawul manaŋiya; Ŋangawul djänguŋ rakaraŋ; Ŋangawul mayaliꞌ-wilkthuwa yolŋuny, bala maŋgarra manaŋiyan nhangu nhäm malany; Mä-ŋalthuwa nhuŋguway ŋäṉḏiꞌmiŋuwum ga moriꞌmiŋuwum.’” ");
INSERT INTO dhg_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Bala nhan banhayam yolŋu bitjanan ḏämbu-ganitjuman, “Gulitj yana marrkapmi Marŋgikunhami. Ŋayam gayŋan dhaŋu ŋayathan ga malthuwan djinakuyam romgu bewaḻi ḻinygu yana banha ŋayam yothu mu yana.” ");
INSERT INTO dhg_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Bala nhan gayŋan Djesuyum nhäŋalan banhaya yolŋunham ŋayaŋuyum-mä-ŋuwatjinyarayun bala nhan bitjanan garruwan, “Gatjuy ḏirruwan ŋirrimaḻin ga djalimnha nhuŋguway nhäm malany warrpamꞌthuwan yana. Ga bayiŋ nhunu ŋarru rrupiyam warraṯthun bala mala-wulkthuman banhayam, bala guŋa ŋunha ŋurruwuykminhan yolŋuny warrany. Bala nhunu ŋarru nyäkun malthun. Ga yalalam nhan ŋarru God-Waŋarryum ḏämbu-ḏirrumana guŋan nhuŋgum nhä mala ŋunhalan djiwarrꞌŋan.” ");
INSERT INTO dhg_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ga banha nhan bayiŋuya yolŋuyu bilanyawuyma ŋäkul Djesunham, bala nhangu ŋayaŋum-barrakinydjinan. Bala nhan ŋirrimaḻim ŋirrimbuwan galŋa-barrakinydjinan, ḻinygu nhan banha gulitj yana ṉukunydjaꞌ. ");
INSERT INTO dhg_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Bala nhan Djesuyum nhäŋalan ŋarran, bala nhan garruwan nhanguru guyurrꞌmiŋuwum warrawu bitjanan, “Gumurr-wanyun dhaŋu marimin bitjuwayiŋ ṉukunydjaꞌwum yolŋuwu gulŋiyinyarawu balam djiwarrꞌḻim!” ");
INSERT INTO dhg_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ga banha dhanal guyurrꞌmiŋuyum warrayu ŋäkulam nhanany bilanywuyma garrunda bala dhanal mä-yumbalꞌyuwanan. Ga nhanmam Djesum biyapul bitjuwayiŋ garruwan bitjan, “Ŋäkam warra ŋuwatjuma! Wanyu dhaŋu marimi gulŋiyinyarawu God-Waŋarrwuḻim gurruṯumiḻim Romḻi. ");
INSERT INTO dhg_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Guyaŋiya banha warrakanꞌnha yäkuny gamuḻnha. Murrukay nhan banha marimi, ga gumurr-wanyun nhangu banha gulŋiyinyarawu ŋunha yutjuwaḻmurrum ŋarŋgamurru, banha girriꞌwuy djawarꞌyunda ṉel. Yo, bilanyayan banha yulŋum ṉukunydjaꞌwum yolŋuwu, marimin yana gumurr-wanyu gulŋiyinyarawu God-Waŋarrwuḻim gurruṯumiḻim Romḻi.” ");
INSERT INTO dhg_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ga nhalpiyan nhan gayŋan banha Djesu bitjuwayiŋ garruwan, banham dhanal mariminan mä-yumbalꞌyuwan. Bala dhanal gayŋan dhä-wirrkaꞌyunminan bitjanan, “Ga, bayiŋ nhan gayŋa dhuwan gulitjma bitjuwayiŋ rakaram, ga yolnha ŋarru barkthu gayŋi banha nyenay ŋunhalam djiwarrꞌŋam nhanguram God-Waŋarrwuram?” ");
INSERT INTO dhg_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Bala nhan Djesuyum dhanaliny ŋarran nhäŋalan, ga bitjanan nhan garruwanam, “Yolŋum ŋarru banha ŋangawul guŋnharram gulŋiya God-Waŋarrwuḻim Romḻi nhanguwaywurum ŋayaŋuyu. Ŋarru ŋangawul warra meṉguŋam, nhanmam ŋarru banha God-Waŋarryum djäma yana nhä malany bukmak.” ");
INSERT INTO dhg_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ga nhanmam Betam ḏämbu-ganitjuman bitjanan, “Marrkapmi. Ŋanapum dhaŋu ḻinygu guŋnharruman nhä malany ŋanapiliŋguwayma bala ŋanapu malthuwan nhuŋgun. Ga nhä yika ŋanapiliŋgum ḏämbu-ḏirrunmaranhara?” ");
INSERT INTO dhg_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Bala nhan Djesum bitjanan garruwan, “Ŋaya nhumaliŋgu rakaraman! Bayiŋ ŋarru yolŋu djälmiyi malthundawu nyäkum, bala ŋarran guŋnharrumana ŋarru nhanguway ŋäṉḏiꞌmiŋuny ga moriꞌmiŋuny ga yumurrkunyꞌ nhanguway nhan ga yukuyukuꞌmiŋuny warrany nhanguway ga ŋirrima nhanguway ga djäma nhanguway ga nhä malany girriꞌ nhanguway, bala nhan ŋarru ŋarran gayŋa ḏämbu-ḻiwꞌyumana yolŋuwun warrawu dhäwun ŋarra ŋuwakurrun rakaram nyäkuruynha. Ga yalalaŋumiyum nhangum ŋarru banha ḏämbu-ḏirrunmaraŋ bulun walꞌŋu guḻkun marimin bukuḻin-ŋalthumu barkthu. Nhä malany nhan guŋnharruman, nhangum barkthu guḻkun ḏämbu-ḏirrunmaraŋ. Ga ŋayaŋu-ḻiyundamim rom barkthu nhan gayŋi warraṯthu yana, ḻinygu nhan bayiŋ gayŋa banha nyäku bitjuwayiŋ malthun. Ga yalalaŋumin baya barkthu dhaŋu munathaꞌ waŋgala dhawarꞌyu, bala nhan barkthu banha gayŋi nyinayim wikarraŋumin, wälŋa-dhawarꞌyundanharran ŋunhalan galkin yanan God-Waŋarrwuran. ");
INSERT INTO dhg_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ga bayiŋ ŋarru gayŋa yolŋu bitjanma ḻinygu guyaŋinyarami yindikunharamim, banhayam nhan ŋarru nyumukuṉinydjin, räywuynha. Ga banha räywuyma yutjuwaḻma ŋarru barkthu ŋurruŋuyin, gämurru'ŋun nhan yolŋu.” ");
INSERT INTO dhg_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ga bilanyamiyum dhanal banha ŋaykanan balan Djurutjalamḻin ga nhanmam gayŋan banha Djesum ŋurruŋun bitjuwayiŋ ŋirrimbuwan ga dhanalim guyurrꞌmiŋum warra ga waripum yolŋu warra gayŋan ŋapa-munguyuwanan nhanany. Ga guyaŋin dhanal ŋarran yän nhanany garrunda bitjanda, “Yolŋuyum warrayu nhänany barkthu guwatharaŋun ŋunhalam Djurutjalamma.” Ga mariminan dhanal banha bitjuwayiŋ bawaꞌyuwanam, biyaṉiyinan manapan. Ga nhanmam dhanaliny Djesuyum ŋäkul bala nhan ḻuŋꞌthumanan nhanguwayma guyurrꞌmiŋuny warrany ga biyapul nhan bitjuwayiŋ rakaran dhanaliŋgu banha nhalpiyu barkthu yolŋuyu warrayu nhanany ŋunhal Djurutjalam. ");
INSERT INTO dhg_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ga bitjan nhan garruwan, “Ŋäka warra nhuma! Dhaŋum ŋalma gayŋa ŋaykaman yulŋum Djurutjalamḻin. Ga dhaŋun ŋaya yulŋum Gulitjŋum Walꞌŋu Yolŋu, dhaŋum dhanal barkthu nhänany ŋarambiya-guŋun ŋurruŋu-ḏalkarramiwuḻin warrawuḻ ga rom-marŋgikunhamiwuḻin warrawuḻ. Bala dhanal ŋarru nyäku yoranharamin waŋayinyarawun. Bala dhanal barkthu nhänany ŋarambiya-guŋun ŋunha waripuwuḻin yolŋuwuḻ warrawuḻ, banha dhanal dhuŋanmin God-Waŋarrwu. ");
INSERT INTO dhg_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ga ŋunhalayan dhanal barkthu nhänany goṉa-wuŋum. Dhupthun dhanal barkthu nhänany ga bartjumun nyin, ŋanaknha nhänany guwatharaŋ. Ga dhurrwaraŋuru bewaḻiyam bala dhanal nhänany barkthu murrkayꞌyumun guwatharaŋ. Ga gulitj yana ŋaya barkthu banha waŋayim, ga munha burrpar barkthu djuḻkthu bala ŋaya barkthu biyapulya bitjuwayiŋ wälŋayi.” ");
INSERT INTO dhg_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ga dhurrwaraŋuru bewaḻiyam bala dhupal banha Djibidiwum gäthuꞌmiŋu wulay Djayimma ga Djonma ŋarranan guwatjmanan Djesunhan. Bala dhupal ŋäŋꞌthuwanan nhanany bitjanan, “Marrkapmi Marŋgikunhami, dhaŋu ŋalinyu gayŋa yän nhuŋgu ŋayathan.” ");
INSERT INTO dhg_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Bala nhan Djesuyum dhupaliny dhä-wirrkaꞌyuwanan bitjanan, “Nhäwu nhuma ŋarru ŋäŋꞌthunma?” ");
INSERT INTO dhg_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ga dhupalim bitjanan garruwan, “Marrkapmi, yalalaŋumiyum nhunum ŋarru dhaŋu ŋurruwuŋmin walꞌŋu ŋurru-warrundami ŋanapiliŋgu. Ga bilaŋ nhunu ŋarru bitjanya ḻinygu ŋalinyuŋgum guyaŋi? Mä ŋarru ŋalinyun nhuŋguram galki. Waŋganyma ŋarru nyena nhuŋguḻ dhunupaꞌŋuŋa galiꞌŋa ga waripum ŋarru nyena wiṉꞌkuŋuŋan galiꞌŋa.” ");
INSERT INTO dhg_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ga nhanmam Djesum ḏämbu-ganitjuman, “Ŋangawul nhuma dhaŋu marŋgi nhäwu nhuma gayŋa dhaŋu ŋäŋꞌthun. Ŋayam barkthu dhaŋu yalalaŋumiyum dhaŋgaḏirryun marimin yana. Ŋalan? Nhalpiyu nhumam barkthu... bitjuya ḻinygu dhaŋgaḏirryu bitjan ŋaya, ga yanatj ḻinygu ga waŋayi barkthu?” ");
INSERT INTO dhg_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ga dhupalim garruwan, “Ŋe... bitju mu ḻinygu, Marrkapmi.” Ga nhanmam Djesum ḏämbu-ganitjuman bitjanan, “Yo, gulitj yana nhuma ŋarru banha dhaŋgaḏirryum, bitju yana ḻinygu bitjan ŋaya. ");
INSERT INTO dhg_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Wäy-y, banhayam ŋarru nhanbayin yana God-Waŋarryun mala-yarrꞌyu, yol barkthu nyenay dhunupaꞌŋuŋa ga yol wiṉꞌkuŋa galiꞌŋa. Ga ḻinygu nhan banha ŋätjil yana mala-yarrꞌyunma. Banhayam dhaŋu ŋangawul nyäku mala-djarrꞌyundawu.” ");
INSERT INTO dhg_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ga banha dhanal waripuyum guyurrꞌmiŋuyu warrayu ŋäkul dhupaliŋguŋ yänma bitjuwayiŋ ŋäŋꞌthundam, bala dhanal maḏakarritjinan dhupaliŋgu. ");
INSERT INTO dhg_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Bala nhan Djesuyum dhanaliny yurrumꞌthumanan bala bitjanan garruwan, “Marŋgi mu nhuma dhaŋu: banha dhaŋu djinaŋum bala ŋurru-warrundayŋu yolŋu warra bilanyayan, rom-wanyumin, buŋgawakunharamin dhanal bayiŋ gayŋa yolŋuwum warrawu bukmakkun. Bilanyan gayŋa dhaŋu maḻŋꞌthunma buku-ḻiwꞌyumana yana djinalam munathaꞌŋam waŋgalaŋa. ");
INSERT INTO dhg_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ŋarru nhumam ŋarru ŋangawul bitjanya. Ga bayiŋ nhunu ŋunhuŋ yol yolŋu dhawuru malaŋuru gayŋa djälmiyi ŋurruŋuyinyarawum, nhunum ŋatjil ŋarru djämamiyi waripuwu yolŋuwu warrawu. ");
INSERT INTO dhg_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ga bayiŋ nhan yolŋu djäl ŋurruŋuyinyarawum, nhanmam ŋarru djämami bukmakkun yana yolŋuwu. ");
INSERT INTO dhg_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ḻinygu ŋayam banha Gulitjŋum Walꞌŋu Yolŋu ŋangawul räli ŋarran dhanal ŋarru gayŋa yolŋu warra bitjuwayiŋ nyäku djäma. Ŋayam banha räli ŋarran, mä ŋaya ŋarru gayŋa djäma yolŋuwu warrawu. Ŋayam banha ŋarran ŋaya ŋarru waŋayin mundhurr-wuŋanmin, mä ŋarru bayiŋuyam bäyarran, ḏirrumana ŋarru yolŋunhan bewaḻin barrakinyŋurun romŋuru.” ");
INSERT INTO dhg_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yo, Djesu ga guyurrꞌmiŋu warra nhangu ga waripu yolŋu warra guḻku marimi waythuwan ŋunhalan Djarikawnha ŋirrimaŋa. Ga banha dhanal guŋnharrumanam banhayam ŋirrima, bitjanam yolŋu gayŋan bambay nyenan galiꞌŋa batjiwarrŋa yäku Bätimayatj, Dimayatjku gäthuꞌmiŋu, ŋäŋꞌthuwan nyin. ");
INSERT INTO dhg_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ga banha nhan bayiŋuya ŋäkulam nhanany Djesuny banha Nätjiritjpuynha djuḻkthundam, bala nhan yatjuwanan murrukayyun rirrakayyum bitjanan, “Djesu, Daybitkuŋ mala-guwatharanhara, ḻinygun ŋanapu wikarraŋumin gayŋan gäḻkuḻanam nhuŋgu. Gu, maŋutji-wuyuwan nyäku.” ");
INSERT INTO dhg_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ga banha dhanal yolŋuyum warrayu ŋäkulam nhanany yatjundam bala dhanal ŋarran dhaykuwanan nhanany, “Ye,... mukthuwa!” Ga nhanmam mariminan yatjuwan bitjan, “Djesu! Daybitkuŋ mala-guwathanhara maŋutji-wuyuwa nyäku!” ");
INSERT INTO dhg_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Bala nhan Djesum guluwanan bala bitjanan garruwan, “Gu, räli warra nhanany gutjparruwa!” Ga dhanalim ŋarran nhanguḻ, bayikuḻiya bala garruwanan, “Ye, ḻinygun mukthuwan. Ŋunha nhuŋgu nhan gayŋa guykuyyuna. Maꞌ, gu ṉakaman!” ");
INSERT INTO dhg_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ga nhanmam banha Bätimayatjthum ŋäkul bala yana yupthumanan nhanguway gärruŋma bala djingaryuwanan bondin yana, bala djartjar-bitjanan Djesuwuḻin. ");
INSERT INTO dhg_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Bala nhan Djesuyum nhanany dhä-wirrkaꞌyuwanan, “Nhäwu nhunu djälma?” Ga nhanmam banha bambayma ḏämbu-ganitjuman bitjan, “Buku-djulŋi, djälmiyi ŋaya gayŋa dhaŋu nhänharawun.” ");
INSERT INTO dhg_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ga biyapul nhan Djesu garruwan nhangu, “Ḻinygun nhunu dhaŋu bitjuwayiŋ mä-wulitjmiyinan, ŋayam ŋarru ḏukthumana nhuna. Yo, ḻinygun nhunu dhaŋu dukthuwanan, gatjuy maŋgarran!” Bala nhan Bätimayatjkum maŋutjim dhuṉḏaynha yana ŋuwatjinan. Ga bewaḻiyam nhan gayŋan malthuwanan Djesuwun. ");
INSERT INTO dhg_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yo, Djesum ga guyurrꞌmiŋum warra nhangu ŋarran ŋaykanan bala. Ga banha dhanal gayŋan ŋirrimbuwan Djurutjalamḻim bala dhanal ŋarran bukuyu ŋayathanan burrparma ŋirrima yäku Bithanin ga Batpatjnha ŋunhalayan bukuŋa yäkuŋa Wolipŋan. ");
INSERT INTO dhg_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Bala nhan Djesuyum garruwan nhanguway burrparnham guyurrꞌmiŋuny wulanynha bitjanan, “Gatjuy maŋgarran wulay. Ga bayiŋ nhuma ŋarru banhalayam ŋirrimaŋa waythun, maḻŋꞌthuman nhuma ŋarru bäwarraṉꞌnha yäkuny duŋꞌkiny djingaryun ŋarru gayŋa garrwiꞌyunda ḏarpaḻ. Ga ŋangawul nhan banha buŋgannharra yulŋum. Ga yapthuman nhuma ŋarru rakiꞌ, bala rälin nyäkuḻ gutjparrun. ");
INSERT INTO dhg_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ga bayiŋ ŋarru yolŋuyu dhä-wirrkaꞌyun bitjan, ‘Nhäwu nhuma gayŋa dhuwan duŋꞌkinham yapthuman?’ bitjanma, nhumam ŋarru bitjan garrun, ‘Garray ŋunha djinaku djälmiyin, ga yalŋuwa nhan ŋarru ḏirruman nhuŋgu.’” ");
INSERT INTO dhg_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ga banha dhupal bitjuwayiŋ ŋarranam bala yana dhupal nhäŋalan banha duŋꞌkinham, ŋarru yutjuwaḻ, djingaryuwan nyin garrwiꞌyunda gumurrŋa yana buṉbuŋa. ");
INSERT INTO dhg_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Bala banha yolŋuyum warrayu dhä-wirrkaꞌyuwanan dhupaliny bitjanan, “Way! Nhäwu nhuma gayŋa dhuwan duŋꞌkinham yapthuman?” ");
INSERT INTO dhg_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ga dhupalim garruwan, “Garray dhaŋu djinaku djälmiyin, ga yalŋuwa ŋanapu ŋarru ŋunhuŋ ḏirruman.” Bala dhanal bitjuwayiŋ dhayuŋganan. ");
INSERT INTO dhg_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bala dhupalim banha gutjparruwanan duŋꞌkinham Djesuwuḻin. Ga ŋunhalam dhanalim ŋarran banha ŋäkirrinyawuyma girriꞌ dhanaliŋguway ŋalthuman duŋꞌkiwuḻin ŋarakaḻ, bala nhan Djesum ŋalthuwanan nhanguḻ ŋarakaḻim bala ŋarranan Djurutjalamḻin. ");
INSERT INTO dhg_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ga guḻkuyun ŋarran banha yolŋuyum warrayu ŋäkirrinyawuyma girri' dhanaliŋguway rarr'yuwan batjiwarrḻim. Ga waripuyum yolŋuyu warrayu ŋarran gani'-ganitjuman baṉan ŋarru man'tjarrmi guḻwirri, banha ŋarran djingaryuwan gali'murru batjiwarrmurru. Bala dhanal ŋarran batjiwarrḻin rarr'yuwan mä nhan ŋarru gayŋa banha duŋ'kim gayanh'thamurrun ŋarra. Rom dhanaliŋgu gayŋan ŋoyan dhanal ŋarru bitjan goŋmiwum yolŋuwu gumurr-ŋuwatji. Ga waripu yolŋu warra gayŋan ŋaykan gumurrmurru, ga waripu warra dhurputj gayŋan martjmartjtjuwan. ");
INSERT INTO dhg_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ga bitjanan dhanal ŋarran banha yatjunminam, “Yo yo-o-oy! Hosanna! God-Waŋarr marrkapmi, dhaŋu ŋanapu bayiŋ gayŋa wokthun yana nhuŋgu! Dhaŋum nhan gayŋa ŋarram God-Waŋarrwurun yäkuyum. Nhän banha God-Waŋarryu nhanany yänguwanam, ga dhaŋun nhan rälin ŋarranam. ");
INSERT INTO dhg_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Yo, yo-o-oy! Hosanna! God-Waŋarr marrkapmi, dhaŋu ŋanapu bayiŋ gayŋa wokthun yana nhuŋgu! God-Waŋarr marrkapmi, nhunum ŋarru dhaŋunham yolŋuny buŋgawayumana bukmakkun yana Djuwwum yolŋuwu warrawu, bilanyan bitjuwayiŋ nhangu banha mala-ŋurrkanhayŋuny Geŋ-Daybitnha. Yo, yo-o-oy! Hosanna! God-Waŋarr marrkapmi, dhaŋu ŋanapu bayiŋ gayŋa wokthun yana nhuŋgum! God-Waŋarr, ŋunha djiwarrꞌŋam nhunum dhaŋu murrukay!” ");
INSERT INTO dhg_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ga banha dhanal Djesu ga guyurrꞌmiŋu warra bitjuwayiŋ waythuwanam ŋunhalam banha God-Waŋarrwuḻim Dharrpalŋam Buṉbuŋa bala nhan ŋarran nhäŋalan ḻiwꞌyumanan, bukmak yana banha mungurr malany banhalaya bitjuwayiŋ ḻoḻuŋa, banha ŋarran djingaryuwan ḻiwꞌyuman. Bala banha walum giḻyuwanan, bala nhan Djesuyum guŋnharrumanan banhaya buṉbum bala ḏirruwanan ŋarran balan Bithaniḻin, ga dhanalin banha guyurrꞌmiŋun warra nhangu galkiwuynha, 12-nha. ");
INSERT INTO dhg_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ga waripuyun waluyu djaḏawꞌyundayu nhan Djesu ga guyurrꞌmiŋu warra nhangu ŋarran martjmartjtjuwan bewaḻi Bithaniŋuru balan Djurutjalamḻin. Ga gandarrŋam bala nhan Djesum djaṉŋarryinan. ");
INSERT INTO dhg_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Bala nhan nhäŋalan ḏarpan, djingaryuwan gayŋan galiꞌŋa batjiwarrŋa. Banhayam ḏarpa bilanya bitjuwayiŋ muthir. Ga ŋarran nhan galitjin borumgu maḻŋꞌthumandawu ŋarru ŋangawulnha.Yo, djamarrinyꞌma guḻku gayŋan goyuwan ŋarru borumnha ŋangawulma, ḻinygu ŋangawul banha bitjuwayiŋ bayikuya walum borumdjinyarawum. ");
INSERT INTO dhg_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Bala nhan Djesum wanyuyun yändhu garruwan bayikuya ḏarpawum bitjanan, “Ŋangawulnha ŋarru yolŋuyum biyapulma nhuŋguŋum borum guwaman!” bitjan. Ga dhanalim banha guyurrꞌmiŋuyum warrayu nhanguru ŋäkul nhanany bilanyaḻim garrundaḻi. ");
INSERT INTO dhg_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Bala nhan Djesum ga guyurrꞌmiŋum warra nhangu ŋarran ŋaykanan balan Djurutjalamḻin. Ga biyapulya nhan ŋirrimbuwan balaya bitjuwayiŋ God-Waŋarrwuḻ Dharrpalḻi Buṉbuḻi. Ga banhalaya goḏuŋa ŋirrimaŋa banha gayŋan ḻoḻuwunuwan Dharrpalnhan Mungurrnha, yolŋuyu warrayu ŋarran warrakanꞌ mala wuŋiḻiꞌyuwan mundhurrwu-guŋandawu. Ga waripum dhanal gayŋan buku-djuḻkthumanmin banhalaya rrupiya. Ŋangawul dhanal banha bayikuya buṉbuwum bitjuwayiŋ rumꞌrumdhuwan, barrakinynha dhanal djäma. Ga waripuyum yolŋuyu warrayu banha dhanal gayŋan rrupiya malany buku-djuḻkthuman banham dhanal gayŋan waripum goŋ-djuḻuḻꞌyuwanan, manaŋinan manapan. Bala nhan gayŋan Djesuyum dhanaliny bukmakkuwanan yana dhawaṯthuman bewaḻiyam mungurrŋuru, djalkthuwanan nhan gayŋan dhanaliŋgu daybuḻma, rrupiya manapanan ga nyenanharamin mala dhanaliŋgu. ");
INSERT INTO dhg_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ga gulumanan nhan gayŋan banha yolŋunham warrany girriꞌŋurum gutjparrundaŋuru, banha dhanal gayŋan bayitjaniya bitjuwayiŋ mungurrmurru räy-ŋarrꞌŋarr ŋaykan. ");
INSERT INTO dhg_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Bala nhan Djesuyum gayŋan dhanaliny marŋgikuwanan bukmaknhan yana bitjanan, “Bamanꞌ ŋätjil nhan God-Waŋarr garruwan nhanguḻ djawarrkmiwuḻ yolŋuwuḻ nhan ŋarru wukirri yän djorraꞌḻi bitjan, ‘God-Waŋarrwum Buṉbu ŋarru gayŋa dhäya bukmakku bäpurruwu yolŋuwu buku-ŋalthundawu.’ Ga nhumam dhaŋu Buṉbuny rrorru, yanawarri dhaŋu manaŋganmiwun ḻuŋꞌthumanminyawun buṉbu.” ");
INSERT INTO dhg_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ga banha dhanal ŋurruŋu-ḏalkarramiyum ga rom-marŋgikunhamiyum warrayu ŋäkul bitjuwayiŋ Djesunham banha nhä nhan djäma, bala dhanal mariminan ŋayaŋu-barrakinydjinam. Bala dhanal gayŋan garrunminan batjiwarrwun rangan guwatharanharawun nhangu, ŋarru dhanal gayŋan banha biyaṉiyin nhangu ḻinygu bukmakma yolŋu warra gayŋan djälmiyinan Djesuwum mariminan, ḻinygu nhan gayŋan dhanaliny ŋuwatjuman yana marŋgikuwan. ");
INSERT INTO dhg_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ga banha walum bitjuwayiŋ nyilŋꞌthuwan bala dhanal Djesum ga guyurrꞌmiŋum warra nhangu ŋarranan bewaḻi Djurutjalamŋurum balan Bithaniḻin. ");
INSERT INTO dhg_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","21","Ga waripuyun djaḏawꞌyundamiyu waluyu nhan Djesu ga guyurrꞌmiŋum warra nhangu ḏirruwan balaya Djurutjalamḻi. Ga gandarrŋam dhanal djuḻkthumanan banhayan ḏarpa banha nhan Djesuyu garruwan bitjuwayiŋ wanyuyu yändhu. Ga dhanalim banha guyurrꞌmiŋum warra nhangu mariminan yana ganyimꞌthuwan, ḻinygu dhanal banha nhäŋalam ḏarpam gayŋan räwaknha djingaryun, rakunynha, bewaḻi ḻinygu marwatŋuru ga baṯ-ŋayathan ŋunha wärrurr. Bala nhan Betayum yännha guyaŋin Djesunhan banha nhalpiyan nhan garrun bayikuya ḏarpawu. Bala nhan Betam bitjanan garruwan, “Marŋgikunhami, dhaŋun banha ḏarpam räwaknha nyin djingaryun, rakunynha, banha nhunu wanyuyu yändhu garrun!” ");
INSERT INTO dhg_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ga nhanmam Djesum bitjanan garruwan, “Bayiŋ nhuma ŋarru God-Waŋarrwum mä-wulitmiyi, nhumam ŋarru bitjanya ḻinygu djäma bitjuwayiŋ ŋaya. ");
INSERT INTO dhg_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ga banha nhuma ŋarru gulitjtjumanma mä-wulitjtji warrpamꞌthum yana ŋayaŋuyu, ga ŋangawulma bitjuwayiŋ mä-yuḻkthun, nhumam ŋarru garrun dhaŋuny gayꞌ bukuny ŋirrimany nhan ŋarru ṉakamana bala garmakḻin ḏamurruŋꞌḻin ḻupthun. Nhanmam ŋarru God-Waŋarryum giṯthumana yana banhayam bukuny ŋirrimany. ");
INSERT INTO dhg_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Yo, ŋangawul warra meṉguŋam. Banha nhunu ŋarru gulitjtjumanma yana mä-wulitjtji, nhunum ŋäŋꞌthuwa nhanany bawalamiwun, ga nhanmam ŋarru guŋana yana nhuŋgu. ");
INSERT INTO dhg_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ga banha nhunu ŋarru bukumiŋganma, ŋurruŋum ŋatjil guyaŋiya: Bayiŋ nhuna yolŋuyu bitjuwayiŋ ŋayaŋu-barrakinydjuman, maŋgarra ŋatjil ga waythuwa nhangu ga baya-rakaraŋan, ŋangawulnha guyaŋiya bäyarraꞌwum. Ga bayiŋ nhunu ŋarru bitjanyam djäma, nhanmam ŋarru God-Waŋarryum baya-rakaraman nhuŋgum nhä malany barrakiny banha nhunu gayŋan djäma. Nhunum dhanaliŋgu ŋatjil baya-rakaraŋ, ga ŋärrun bukumiŋga God-Waŋarrwuḻim. ");
INSERT INTO dhg_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ga banha nhunu yolŋu dhuŋam baya-rakaranharawu, nhanmam ŋarru God-Waŋarryum banha ŋangawulnha nhuŋgum barrakiny malany meṉgum.” ");
INSERT INTO dhg_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ga banha dhanal waythuwan Djurutjaḻamma bala dhuṉḏaynha dhanal banha gulŋiyanam balan mungurrḻi banha gayŋan ḻoḻuwunuwan God-Waŋarrwu Dharrpal Buṉbu. Ga dhanalim banha ŋurruŋu-ḏalkarramim ga Djuwwu-ŋurru-warrundayŋum warra ga rom-marŋgikunharamim yolŋu warra waythuwanan nhangu, ");
INSERT INTO dhg_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","bala dhanal gayŋan dhä-wirrkaꞌyuwanan Djesunhan bitjanan, “Gu, rakaraŋan wilak ŋanapiliŋgu, yolthu nhuna banha garrunma djinakum buṉbuwum ḏarrtjalkkunharawu? Yolthu nhuna barka-nhinathuŋganma?” ");
INSERT INTO dhg_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ŋarru nhanmam banha Djesum marŋgiyin dhanaliŋgu. Bala nhan bitjanan ḏämbu-ganitjuman, “Ŋaya ŋatjil nhumaliny ŋäŋꞌthun ŋayꞌ. Nhuma ŋatjil warra nyäku rakaraŋ, ga ŋärrun ŋaya ŋarru nhumaliŋgum rakaram. ");
INSERT INTO dhg_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Marŋgi nhuma Djongu, banha Buku-ḻupthumandamiwum yolŋuwu? Yolthu banha nhananham barka-nhinathuŋgan yolŋuwum warrawu buku-ḻupthumandawu? God-Waŋarryu, wo yolŋuyu?” ");
INSERT INTO dhg_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Bala dhanalim gayŋan garrunminan bitjanan, “Way, nhalpiyana ŋalmam ŋarru ḏämbu-ḏirruman nhangum? Banha ŋalma ŋarru bitjanma garrun, ‘God-Waŋarryu nhanany banha garruwan,’ bitjanma, ga nhanmam ŋarru bitjana garrun, ‘Ga nhäwu nhumam banha nhangu Djongum ŋangawulma bitjuwayiŋ mä-wulitjtjin yängu?’ ");
INSERT INTO dhg_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ga banha ŋalma ŋarru bitjanma garrun, ‘Yolŋuyu warrayu nhanany banha garruwan bayikuya djämawu,’ bitjanma, dhanalim ŋarru yolŋum warra maḏakarritjtjin, ḻinygu dhanal marŋgi banha dhaŋu Djonma God-Waŋarrwu djawarrkmi yolŋu.” ");
INSERT INTO dhg_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Bala dhanal bitjanan ḏämbu-ganitjuman, “Ŋangawul ŋanapu dhaŋu marŋgi!” Ga ŋärrun nhanmam Djesum dhanaliŋgu ḏämbu-ganitjuman bitjanam, “Ŋayam ŋarru ŋangawulya nhumaliŋgum rakaram yolthu nhänany bitjuwayiŋ barka-nhinathuŋgan.” ");
INSERT INTO dhg_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ga dhurrwaraŋuru bewaḻiyam nhan Djesu biyapulya bitjuwayiŋ garruwan bayikuḻ banha ŋurruŋu-ḏalkarramiwuḻ ga rom-marŋgikunhamiwuḻ ga Djuwwuḻ ŋurru-warrundayŋuwuḻ warrawuḻ. Ga bitjan nhan banha dhäwum rakaran mayaliꞌmiŋganam gamꞌ, “Waŋganymiyu waluyu ŋirrima-waṯaŋu yolŋu ḏukṯukmiyin nhän ŋarru borum, wuḻuymuŋꞌtjinya lämu-nhinathuŋgan. Yo, ŋurruŋum nhan ŋatjil ḻerrꞌyuwan ŋirrimany gaykarraŋguwan, ḏarpa gulkthuwan, bala ḻoḻun botjan. Ga balaꞌpala nhan djäma yaŋaraꞌ garramatḻi milꞌŋuwun djägamiwun nyenanharawu. Ga banikinꞌ nhan murrukay nhinathuŋgan bayikuya borumgun bitjuwaŋ wiyikaꞌwun. Bala nhan yolŋunhan warrany warraṯthuwan djägaminhan warrany, mä dhanal ŋarru gayŋa djäga bayikuya borumgu. Ga yalala ŋarru banha borumma borumdji bala dhanal ŋarru bärrkuwaḻyumana nhangum bayikuyam ŋirrima-waṯaŋuwum. Manymak, bala nhan banha ŋirrima-waṯaŋum ŋarranan bärrkuḻin waŋgalaḻi. ");
INSERT INTO dhg_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ga banha nhan walum galitjin borumgum gulkthundawu bala nhan bayiŋuya ŋirrima-waṯaŋuyum yänguwanan nhanguway djämaminhan, mä nhan ŋarru balayan bitjuwayiŋ ŋarra banha borum-djägamiwuḻin warrawuḻ dhanal ŋarru nhangum borum mala gänaŋꞌthumana bewaḻiyam gätniŋuru. ");
INSERT INTO dhg_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ga dhanalim banha yolŋuyum warrayu nhäŋal nhanany bala barkan warruwan bala guwatharanan, bala ḏupthuwanan nhanany warraŋulḻin goŋ-waŋaranhan. ");
INSERT INTO dhg_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ga biyapul nhan banha bayiŋuya ŋirrima-waṯaŋuyu yänguwan waripuny djämaminy. Ga dhanalim banha borum-djägamiyum warrayu muḻkurrnha nhanany gayŋan djuḏulꞌyuwan maŋguꞌ-burrwurrꞌyumanan ga baya nhan djetji guḻkumiyin. Bala dhanal nhanany dhawaṯthumanan bewaḻiyam goŋ-waŋaranhan. ");
INSERT INTO dhg_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ga biyapul nhan bitjuwayiŋ yänguwan waripunham djämaminy. Ga dhanalim banha guwatharan nhanany murrkayꞌkuwanan. Ga mä-waŋganynha gayŋan banha bilanyayam bitjuwayiŋ maḻŋꞌthuwan. Waripuny dhanal djämaminy guwatharan yana, ga waripunham dhanal guwatharan rakunyguwanan. ");
INSERT INTO dhg_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Yo, ga waŋganynha gayŋan banha yolŋum bitjuwayŋ nyenan, gäthu'miŋun nhangu, ḏirramun, banha nhan gayŋan mariminan nhangu mä-ŋuwatjin. Ga bitjanan nhan gayŋa banha mori'miŋuyum guyaŋin, ‘Banha ŋaya ŋarru gäthu'miŋunham nyäkuway yängum, dhanalim ŋarru banha nhangun bitjuwayiŋ makmakthunma bala mäkiri-witjuna nhangu.’ ");
INSERT INTO dhg_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Bala nhan yänguwanan nhanguway gäthuꞌmiŋunham balayan. Ga dhanalim banha borum-djägamiyum warrayu nhäŋal banhaya gäthuꞌmiŋunham bala dhanal garrunminan, ‘Way, waraparra nhäŋa warra dhaŋu! Dhaŋum nhan gäthuꞌmiŋunhan moriꞌmiŋuyum yänguwan. Ga yalalaŋumi ŋarru banha moriꞌmiŋum waŋayi bala barkthu banha nhännha djinaŋun bukmakma nhä malany warraṯthu nhangum. Gu, ŋalma guwatharaman waŋayumana nhangu gäthuꞌmiŋunham, mä ŋarru banha bukmakma nhäm mala ŋalmaliŋgun’ ");
INSERT INTO dhg_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Bala dhanal ŋayathanan nhanany, ga guwatharanam dhanal nhanany murrkayꞌkuwanan, waŋayumanan yana. Bala dhanal nhangu rumbalma ḏupthuwan warraŋulḻin, ḏiltji-duwaṯthumanan bayikuya ḻoḻuwum borummiwum.” ");
INSERT INTO dhg_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Bala nhan Djesuyum dhä-wirrꞌkayuwanan banha ŋaḻapaḻminham bitjanan, “Nhalpiyana nhumam gayŋa guyaŋi? Nhalpiyana nhan ŋarru bayiŋuya ŋirrima-waṯaŋuyum yolŋuyu guyaŋi ŋunha borum-djägaminham warrany? Banham nhan ŋarru ŋarran yana bala guwatharaman rakunguman banha borum-djägaminham warrany. Bala nhan ŋarru banhayam ŋirrima borummim guŋan waripuwuḻin yolŋuwuḻ warrawuḻ djägawu. ");
INSERT INTO dhg_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ḻinygu mu nhuma dhaŋu marŋgimi banha ŋunha God-Waŋarrwuram Djorraꞌŋa gayŋa bitjan djingaryun, ‘Waŋganyma banha ṉutjurru dhanal djämamiyu warrayu ḏupthuwanan ḻinygu dhanal barrakiny rakaranan. Ŋarru banhayam ṉutjurru ŋuwakurruꞌŋun walꞌŋu, ga banhayan nhan djalkirim. ");
INSERT INTO dhg_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ga God-Waŋarryum nhanbayim banha warraṯthuwan bala ŋuwakurru-rakaranan. Ga marimin banha maŋutji-wiḏiꞌmin yulŋum!’” ");
INSERT INTO dhg_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ga dhanalim banha ŋaḻapaḻmiyum dharaŋganan yana banha nhan Djesuyum gayŋan dhanalinhan bitjuwayiŋ waywayyuwan bayiŋuyam dhäwuyu. Dhanalim banha banhayam ŋaḻapaḻmim bilanyan bitjuwayiŋ banha borum-djägamin warra. Ga mariminan dhanal banha ŋayaŋu-barrakinydjinam. Ga djälmiyinam dhanal gayŋan banha Djesuwum ŋayathandawun, dhanal ŋarru nhanany dharruŋguḻin dhethuŋgan. Ŋarru dhanal gayŋan banha yolŋuwun warrawu biyaṉiyinam, bala yana dhanal martjmartjuwanan. ");
INSERT INTO dhg_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ga dhurrwaraŋuru bewaḻiyam Djuwwuru ŋurru-warrundayŋuyu ḻuŋꞌthuman yolŋuny warrany bewaḻi bala Baratjiny yolŋuny warrany ga Geŋ Yaritku ḻunduꞌmiŋuny warrany. Bala dhanal yänguwanan banhayam yolŋuny warrany balan Djesuwun mayaliꞌ-wilkthundawun, mä nhan ŋarru be nhalpiyan barrakinydjuman garrun, mä dhanalim ŋarru mari-waythuna nhangu. ");
INSERT INTO dhg_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bala dhanal garruwanan nhangu Djesuwum bitjanan, “Marŋgikunhami, bukmak ŋanapu dhaŋu marŋgi nhuŋgum, nhunum bayiŋ gayŋa dhaŋu ŋuwakurru yana djäma, ga garrun nhunu bayiŋ gayŋa gulitjtjuman yana dhuṉḏay. Ga dhuṉḏay yana nhunu mala-djarrꞌyundami yolŋu, ḻinygu nhunu bayiŋ gayŋa djäma rrambaŋiyuman bukmakku yana, ŋaḻapaḻwu ga yaka ŋaḻapaḻwu. Ga God-Waŋarrwum yän nhunu bayiŋ gayŋa gulitjtjuman yana marŋgi-wuŋan. Gu rakaraŋan ŋanapiliŋgu, nhä banha dhuṉḏay ŋalmaliŋgu Djuwwum bäpurruwu ŋalma ŋarru gayŋa rrupiya ḏämbu-ḏirruman Rawumbuywum gapmangu yäku tax-ma, banha dhanal buŋgawan bitjuwayiŋ bayikuyan ŋirrimawu ŋarakawu?” ");
INSERT INTO dhg_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ga nhanmam banha Djesum marŋgiyin dhanaliŋgu ŋayaŋuwu. Ga banha nhan warri bitjarram garruwarra, ‘Ŋangawul dhuwan ŋuwakurru, nhuma ŋarru wuŋiḻiꞌyun dhanaliny banha tax rrupiya,’ bitjarram, nhanmam warri banha mariḻin gulŋiyarra Rawumanguḻin gapmanguḻ warrawuḻ. Ga banha nhan warri yorarram bitjarram, ‘Yuw, wuŋiḻiꞌyuwan warra djinaŋuyam rrupiyayu,’ bitjarram, ga banham nhan mariḻi dhethuŋganmin Djuwwuḻin yolŋuwuḻ warrawuḻ, ḻinygu ŋangawul dhanal gayŋan ḏukṯukmiyin dhanal ŋarru gayŋa Rawumbuy buŋgawa warra dhanaliŋgu buŋgawayi. Bala nhan Djesum bitjanan garruwan, “Ŋangawul nhänany warra mayaliꞌ-wilkthuwa. Rrupiya warra nyäkuḻ guŋa ŋaya wilak nhäma.” ");
INSERT INTO dhg_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Bala dhanal guŋanan nhanguḻ Djesuwuḻim waŋganynha ŋaraka. Ga nhäŋal nhan, bala garruwan bitjanan, “Yol dhaŋum wuŋiḻi ga yäku djinalaŋam rrupiyaŋa ŋarakaŋa?” Ga dhanalim ḏämbu-ganitjuman, “Dhuwanma wuŋiḻi nhännha Djetjan banha nhan buŋgawan Rawumbuywun Gapmangu!” ");
INSERT INTO dhg_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Bala nhan Djesum bitjanan garruwan, “Gatjuy, ḏirruman warra guŋa nhä malany nhangum bayikuyam Rawumbuywum gapmangu. Ga nhä malany banha nhangu God-Waŋarrwu, bitjaya ḻinygu nhangum ḏirrunmaraŋ guŋa.” Ga bukmakthum banha ŋäkulam nhanany yänma ṉirruwanan, ḻinygu nhan dhanaliŋgu banha ḏämbu-ḏirrunmaranam djämbatjthun yändhum. ");
INSERT INTO dhg_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ga waripu ŋurruk yolŋu warra yäku Djatutji banha dhanal bayiŋ gayŋa marŋgikum yolŋuny warrany, banha barkthu gayŋi ŋangawul be yolŋu warra rakunyŋuru wälŋayi. Ga bilanyamiyu dhanal birrkaꞌyuwan mayaliꞌ-wilkthuwan Djesuny. Ga bitjan dhanal banha nhangu garruwanam, ");
INSERT INTO dhg_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Marŋgikunhami, bitjan ŋunha Mawtjitjthum wukirri God-Waŋarrwum romnha, gamꞌ: Banha ŋarru yolŋuyu baṯaminy warraṯthun, ga waŋayin nhan ŋarru bitjuwayiŋ walkurnharra yana, bala nhanguru yukuyukuꞌmiŋuyun ŋarru banha baṯaminham warraṯthun. Ga yalŋuwa dhupal ŋarru banha yothum bitjuwayiŋ maḻŋꞌthuman, nhangun bayikuyan rakunygun ḏirramuwum. ");
INSERT INTO dhg_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ga nhämi dhaŋum, gayꞌ? Guḻku dhanal gayŋan banha nyenanam, djabin wäwaꞌmanydji warra. Ga nhän ŋatjil ŋaḻapaḻyu wäwaꞌmiŋuyu warraṯthuwan baṯaminy bala waŋayinan, ga ŋangawul nhan banha bayiŋuya baṯamiyum ŋunhuŋ yothum nhangu gutjparruwan. ");
INSERT INTO dhg_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Bala banha malpurayun warraṯhuwan banhaya baṯaminham yana bayiŋ romgun bitjuwayiŋ malthuwan. Bala nhan banha ḏirramum waŋayinan, walkurnharra yana. ");
INSERT INTO dhg_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ga bitjanan ḻinygun gayŋan banha bilanyayam maḻŋꞌthuwan bukmakkun yana dhanaliŋgu wäwaꞌmanydjiwum warrawu. Ga bukmak dhanal gayŋan banha bitjuwayiŋ romgum malthuwan, ga bukmakthu dhanal banha warraṯthuwanam banhayanham baṯaminy. Ga bukmak yana dhanal banha waŋayinam yothunharra yana. Ga dhä-yurputjnha nhanmam banhaya baṯamim bitjuwayiŋ waŋayin. ");
INSERT INTO dhg_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ga djinakun ŋanapu ŋarru nhunany dhaŋu dhä-wirrkaꞌyunma, gayꞌ: Banha ŋarru barkthu God-Waŋarryu yolŋunham warrany wälŋayumu rakunyŋurum ŋunhalam djiwarrꞌŋam, ga banha barkthu banhaya wäwaꞌmanydji warra ga banhaya baṯami bitjuwayiŋ rakunyŋurum wälŋayi, ga yolkun nhan barkthu banha baṯamim, ḻinygu bukmakkuḻ yana dhanaliŋguḻ nhan gayŋan banha bitjuwayiŋ nyenanam?” ");
INSERT INTO dhg_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ga nhanmam Djesum garruwan bitjanan, “Bukmak yana nhuma dhaŋu djarrpiꞌmi. Ŋangawul yana nhuma dhaŋu God-Waŋarrwurum yängu gulitjma marŋgi, ga ŋangawul nhuma marŋgi nhangu ganydjarrwu. ");
INSERT INTO dhg_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ga banha barkthu yolŋum warra wälŋayi rakunyŋurum, banhayam dhanal barkthu bilanyan bitjuwayiŋ God-Waŋarrwun dhäwumi mala, djiwarrꞌwuynha yolŋu warra. Dhanalim ŋarru barkthu gayŋi banha ŋangawulnha warraṯthunmi ŋunhalam. Bukmakma yolŋu warra ŋunhalam djiwarrꞌŋam barkthu waŋganynha yana mala. Ŋangawulnha barkthu gayŋi banha yolŋu warra dhawuꞌ nhinathuŋganmi baṯaminy ga biyapul gayŋi barkthu warraṯthunmi. ");
INSERT INTO dhg_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Nhumam gayŋa dhaŋu bitjan guyaŋi yana warri barkthu ŋangawulnha gayŋi yolŋum warra wälŋayi rakunyŋurum. Guyaŋiya warra banha dhäwu Mawtjitjkuruy ŋunhal God-Waŋarrwura dhuyuŋa djorraꞌŋa: banha nhan nhäŋal ŋorrtja ḏarpaŋa, ga God-Waŋarr gayŋan garruwan nhanguḻ bitjan, ‘Ŋayam dhaŋu God-Waŋarr dhanaliŋgu Yipurayimgu ga Yitjakku ga Djaykupku.’ ");
INSERT INTO dhg_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ŋangawul nhan bitjan garruwan banha nhan bayinyamiyu yana waluyu dhanaliŋgu God-Waŋarr. Banham nhan bitjan garruwan, ḻinygu nhan God-Waŋarr dhanaliŋgu djinakun bala waluyu, ḻinygu dhanal banhayam yolŋu warra wälŋan gayŋa nyena God-Waŋarrwuran, ŋangawul dhanal rakunymi. Ḻinygu wälŋami yolŋu warra bayiŋ gayŋa banha God-Waŋarrwum buku-ŋalthun ŋangawul rakunymi. Werra nhumaliŋguŋ dhuwan guyaŋinyaram.” ");
INSERT INTO dhg_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ga ŋunhalaya gayŋan nyenan waŋgany rom-marŋgikunharami yolŋu, mäkiriꞌ-witjuwan nhan gayŋan Djesuwu. Ga bitjan nhan gayŋan banha guyaŋinam: banha nhan Djesuyum bitjuwayiŋ ŋuwakurrun yana dhanaliŋgu yänma ḏämbu-ḏirrunmaran Djatutiwum warrawu. Bala nhan ŋäŋꞌthuwanan nhanany Djesunham bitjanan, “Nhä dhaŋu ŋurruŋum marimim walꞌŋu God-Waŋarrwum Rom?” ");
INSERT INTO dhg_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ga nhanmam Djesum ḏämbu-ganitjuman bitjanan, “Dhaŋu banha ŋurruŋum walꞌŋu rom ŋunha God-Waŋarrwurum djorraꞌyu gayŋa rakaram bitjan gamꞌ, ‘Ŋäkam warra ŋuwatjuma, nhumam Yitjuralpuyum yolŋuyu warrayu! God-Waŋarr yana dhaŋu nhanbay ŋurruŋum buŋgawa ŋalmaliŋgum, ŋangawul gayŋa dhaŋu waripu yolŋu nyena bilanya bitjuwayiŋ nhän. Ga nhanguway yana ŋalma ŋarru gayŋa banha mäkiri-witjunma! ");
INSERT INTO dhg_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ga mä-ŋuwatjim ŋarru gayŋa dhaŋu djinakum God-Waŋarrwu ŋuwatjuman yana, ŋangawul ḏämbuyu-djinꞌkayŋuyu. Ŋunhuŋun bala mä-ŋuwatjim nhangu djinawaꞌyun ŋayaŋuyu, ga bukmakthu yana nhuŋguru dhäkay-ŋanharayu, ga guyaŋinyarayu. Ga mä-ŋuwatjiya God-Waŋarrwu bukmakthu yana nhuŋguḻ ganydjarryu, nhawun nhunu bayiŋ ŋunhuŋ nhäwu mala bitjuwayiŋ ganydjarr-ḻawꞌyuman djämawu.’ ");
INSERT INTO dhg_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ga dhaŋu nhan banha waripum rom bilanya ḻinygu nhawun ŋunha ŋurruŋu rom, dhaŋun gamꞌ: ‘Gatjuy, mä-ŋuwatjiyan ŋunha waripuwum yolŋuwu bitjaya ḻinygu nhawun nhunu bayiŋ gayŋa nhuŋguway nhunu mä-ŋuwatji.’ Dhaŋun banha burrparnha rom wulanynha biyapulma walꞌŋu ŋurruŋu.” ");
INSERT INTO dhg_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Bala nhan banha rom-marŋgikunhamim yolŋu bitjanan garruwan, “Gulitj dhuwaniyam! God-Waŋarr yana dhaŋu nhanbay ŋalmaliŋgum ŋurruŋu buŋgawa. Dhuṉḏay yana nhunu dhuwan bitjanam garruwan banha ‘Ŋangawul dhaŋu ŋunhuŋ waripu God-Waŋarr,... nhanbayin yana waŋganynha, ga ḻinygun!’ ");
INSERT INTO dhg_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Dhika ŋalma ŋarru gayŋa ŋuwatjuman yana nhangu God-Waŋarrwum mä-ŋuwatji, ŋangawul ḏämbu-djinbum. Gulitjuman yana ŋalma ŋarru gayŋa nhangu mä-ŋuwatjim ŋunhuŋ yana djinawaꞌyu ŋalmaliŋguwaywuru ŋayaŋuyu. Ga bitjanya ḻinygu ŋalma ŋarru nhangu mä-ŋuwatji ŋalmaliŋguru dhäki-ŋänhayum, ga guyaŋinyarayum, bitjan ŋalma bayiŋ warrꞌ-warrun guyaŋi ŋunhuŋ nhä. Ga bitjan nhangu mä-ŋuwatji ganydjarryu ŋalmaliŋguwaywuru nhawun bayiŋ ŋalma ganydjarr-ḻawꞌyuman ŋunhuŋ nhäwu djämawu. Ga bitjanya ḻinygu ŋalma ŋarru gayŋa banha waripuwum yolŋuwu mä-ŋuwatji, bitjuwayiŋ ŋalma bayiŋ nyin ŋalmaliŋguway mä-ŋuwatji. Dhuwaniyan banha rom wulanynha ŋurruŋum bitjuwayiŋ ŋalmaliŋgu. Yo, djuḻkthumana nhan gayŋa djinaŋum romdhu, dhaŋum banha waripunham mala romnha, banha bilaŋ nhä ŋalma bayiŋ gayŋa mundhurr-wuŋan, wo guwaruman bayiŋ bäwarraṉꞌ mundhurr-guŋandawu.” ");
INSERT INTO dhg_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ga banha nhan Djesuyu nhanany bilanyawuyma ŋäkul banha nhan djambatjthum yändhu garruwan banhayam ḏirramu, bala nhan bitjanan nhangu ḏämbu-ḏirrumanam, “Ḻinygun nhunu dhaŋu bitjuwayiŋ dharaŋganan, dhaŋu nhunu bitjanan bitjuwayiŋ nhunu gayŋa guyaꞌ-guyaŋin nhunu ŋarru God-Waŋarrnham buŋgawayumana nhuŋguwaywuru wälŋayum.” Ga ŋangawulnha banha biyapulma ŋunhuŋ yolŋu warra dhurrwara-wapthuwan garrundawum nhangu, ḻinygu ŋangawulnha ŋarru banha ŋunhuŋ yolthu nhanany yänma djuḻkthuman. ");
INSERT INTO dhg_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ga bilanyamiyum nhan gayŋan Djesuyum baḏak dhanaliny marŋgikuwanan yolŋunham warrany banhalayan God-Waŋarrwuran Dharrpalŋan Buṉbuŋam. Ga bitjan nhan rakaranam, “Marŋgi mu nhuma dhaŋu banha Daybitma gayŋan nyenan be wala baman'ŋätjil yana. Ga dhanalim gayŋa dhaŋu nhumaliŋgurum rom-marŋgikunhamiyu rakaran, be warri banha God-Waŋarrwum Maŋutji-yunupayumanda barkthu maḻŋ'thu nhanguran Daybitkuran yarraṯaŋuru, be nhä'miŋu, nhanguran barkthu yarraṯaŋuru maḻŋ'thu. ");
INSERT INTO dhg_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Yo, ŋätjil nhan banha God-Waŋarrwuru Dhuyu-Birrimbirryu yän-wuŋan Daybitkuḻ dhäwuꞌwu wukirriwu bitjan: God-Waŋarr garruwan nyäkuḻim buŋgawawuḻ bitjan, ‘Gu rälin maŋgarra, ga djinalan nyiniyam nyäkuran dhunupaꞌŋuŋan galiꞌŋam, mä nhunun ŋarru banha galkim nyäkuram, ga baya ŋaya ŋarru mariŋuny nhuŋgu gälkinyamiŋgan, bala nhunu ŋarru gayŋa ṉuku-woyuman dhanaliŋguḻ.’ ");
INSERT INTO dhg_vpl VALUES ("MK12_37a","071_12_37a","MRK","12","37a","37a","Ga nhananhan banha Maŋutji-yunupayumandanhan yolŋuny nhan Daybitthum gayŋan buŋgawa rakaranam. Ga nhäwun nhan banha be Daybitkum marratjaꞌmiŋu buŋgawaꞌmiŋum nhangum bitjuwayiŋ Daybitkum?” ");
INSERT INTO dhg_vpl VALUES ("MK12_37b","071_12_37b","MRK","12","37b","37b","Ga guḻkuyu gayŋan banha yolŋuyum warrayu ŋäkulam nhanany Djesunham yän, ga mä-ŋuwatjin dhanal nhangu marimin yana. ");
INSERT INTO dhg_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ga baḏak nhan gayŋan banha Djesuyum bitjuwayiŋ marŋgikuwan yolŋunham warrany, bala nhan bitjanan garruwan, “Wäy, djäga warra ŋay, ŋunhukum rom-marŋgikunhamiwum warrawu! Dhaŋu dhanal bayiŋ gayŋa murrukaykunharami, ga girrimꞌ dhanal bayiŋ nhinathuŋgan wikarran be marimin, mä ŋarru yolŋuyum warrayu nhäma dhanaliny bala wokthuna dhanaliŋgu ga bitjana garrun, ‘Yo, nhämi way yolŋu,’ bitjana, banha dhanal bayiŋ doꞌḻim ŋarra. ");
INSERT INTO dhg_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ga banha dhanal bayiŋ biryamiḻim buṉbuḻi ŋarra buku-ŋalthundawum, wo ŋathamiḻim ŋirrimaḻi, dhanalim bayiŋ ŋuwakurruwun yana nyenanharamiwum rangam, mä ŋarru gayŋa yolŋuyu warrayu nhäma dhanaliny banhambal. ");
INSERT INTO dhg_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ŋarru dhanal bayiŋ gayŋa banha bawa'-guŋan ŋunha ḏämbu-ŋorrtjawuynham baṯaminy warrany bala ŋarra manaŋin buṉbuṉ mala dhanaliŋgu. Ga dhurrwaraŋuru bewaḻiyam bala dhanal bayiŋ ŋarran ŋunha biryamiḻin buṉbuḻi bala nyin bukumiŋgana, djaka'-ŋupana be, mä ŋarru yolŋuyum warrayu dhanaliny ŋuwakurru-rakaraman. Ŋarru nhanmam barkthu dhanaliny banha God-Waŋarryum marimin yana dhä-gir'yum barrakinybuyma.” ");
INSERT INTO dhg_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ga bewaḻiyam nhan gayŋan Djesum gumurrma nyenan balayan ḻinygu banha ŋalaŋa gayŋan banikinꞌ rrupiyawuy djingaryuwan ŋunhal banha God-Waŋarrwura Dharrpalŋa Buṉbuŋa. Ga nhäŋal nhan gayŋan yolŋuny warrany waripuny waripuny dhanal ŋarran rrupiya bitjuwayiŋ rarrꞌyuwan balaya rupaꞌḻi. Ga ṉukunydjaꞌyu yolŋuyu warrayu ŋarran rarrꞌyuwan murrukay rrupiya. ");
INSERT INTO dhg_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ga biyapulma banha ŋurruwuyknha baṯami waythuwan, ga gunhanam nhan banha burrpar yutjuwaḻnha marimin ŋaraka rrupiya, ŋangawulnha murrukay. ");
INSERT INTO dhg_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Bala nhan Djesum guykuyyuwanan nhanguru guyurrꞌmiŋuwun warrawu bitjanan, “Dhaŋum ŋaya ŋarru dhuṉḏay nhumaliŋgu rakaram: Djinaŋum gayꞌ baṯamiyu guŋan warrpamꞌthuwanan, djuḻkthumana gayŋa ŋunha bukmakku nukunydjaꞌwu warrawu mundhurr-guŋanda. ");
INSERT INTO dhg_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Djinaŋum ṉukunydjaꞌyu yolŋuyu warrayu guyaŋin yana warri dhanal guḻku gunhan. Ga ŋunha ŋirrimaŋam dhanaliŋgu ŋarra guḻku yana rrupiya ŋalthunmi. Ga nhanmam djinaŋum baṯamiyu warrpamꞌthuwanan guŋan, ŋangawulnha ŋunhuŋ dhurpuꞌyuman rrupiya nhanguwayma nhan ŋathawu.” ");
INSERT INTO dhg_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Bala nhan Djesum ga guyurrꞌmiŋum warra nhangu ŋarran ŋaykanan dhawayawaṯthuwanan bewaḻiyam banha God-Waŋarrwurum Dharrpalŋurum Buṉbuŋuru. Bala nhan waŋganyma yolŋu garruwan bitjanan, “Way Marŋgikunhami, nhäŋa ŋatjil dhaŋu, latju dhaŋu buṉbu. Nhän dhaŋum ṉutjurru malany murrukaymin marimin, ŋatja?” ");
INSERT INTO dhg_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ga nhanmam Djesum garruwan bitjanan, “Dhaŋu nhuma gayŋa nhäma latjuꞌ buṉbu, dhaŋum ŋarru ganitjin. Ga ŋangawulnha ŋarru gayŋa biyapul djinal djingaryun. Bala ŋarru gayŋa dhaŋu ṉutjurrum mala ŋoyan ganikannha.” ");
INSERT INTO dhg_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Bala dhanal banha Djesum ga guyurrꞌmiŋum warra nhangu ŋaykanan balan bukuḻin yäkuḻi Wolipḻin banha dhupal gayŋan nhänharamin God-Waŋarrwu Dharrpal Buṉbu, ga banhalayan dhanal gayŋan banha nyenanam. Bala dhanal banha ḻurrkunꞌma guyurrꞌmiŋu warra yäku Betam ga Djayimma ga Djonma ga Wandurum ŋarranan guwatjmanan nhanany Djesunham bala dhä-wirrkaꞌyuwanan, ");
INSERT INTO dhg_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Marrkapmi, ŋatjil ŋanapiliŋgu rakaraŋ dhuṉḏaykuŋ, nhä nhunu gayŋan banha rakaran. Nhätha ŋarru banha yolŋuyum bitjuwayiŋ dhaŋum buṉbuny ganitjumu, ga nhaliyu ŋanapu barkthu banha marŋgiyim?”, bitjan. ");
INSERT INTO dhg_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ga nhanmam Djesum garruwan, “Djäka warra maŋgarra, mä ŋarru nhumaliny ŋangawul yolŋuyum mayaliꞌ-wilkthun. ");
INSERT INTO dhg_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Guḻku barkthu gayŋi dhaŋu yolŋum warra bitjuwayiŋ waythu ga bitju garru, ‘Ŋaya dhaŋu Maŋutji-yunupayumandam,’ ga guḻkunhan dhanal barkthu gayŋi banha yolŋunham warrany bitjuwayiŋ mayaliꞌ-wilkthu. ");
INSERT INTO dhg_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ga mariwuyma nhuma barkthu ganydjarrma ŋäkun. Ga waripu yolŋu warra barkthu waythu bala ŋarray dhäwu-golanharamin waripuwuynha mariwuy. Ŋarru nhumam ŋangawulnha ŋoy-wuṉakiya bayiŋuyam mala dhäwuyu, ŋay? Mariwuyma nhuma ŋarru gayŋa dhäwu bitjuwayiŋ ŋäku yana, bäymaŋuḻi ga bärrkuḻi, ŋarru banhayam ŋangawul yana dhä-yawarꞌyundamim walu. ");
INSERT INTO dhg_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ga guḻku guḻku barkthu gayŋi banha marim mala bitjuwayiŋ ŋurru-yawaṯthu. Yolŋu warra waŋgany bäpurru ŋarru mari-waythu waripuŋuwun bäpurruwu. Ga waŋganybuyma ŋarakawuy ŋirrimawuy barkthu mari waythu waripuŋuḻi ŋirrimaḻi. Bala barkthu ŋarray waŋgalam dhaŋum nhanbayim marrmarryun, ṉiṉḏa-barrꞌparrun. Ga ŋatham barkthu banha dhawarꞌyun wikarraŋumiwun waluwu, ga yolŋum ŋarru marimin djaṉŋarryi. Ga ŋurruŋum ŋarru banha dhuwaniya mari mala bitjuwayiŋ maḻŋꞌthu. Ga bulum barkthu murrukaynha marimin mari maḻŋꞌthu. Bitju nhan barkthu banha maḻŋꞌthum gam: Nhawun bayiŋ baṯamiyu ŋurruyirrꞌyuna bitjuwayiŋ ŋämaꞌŋaman rerrin yothuwan waŋgala-wuyaŋinyawun. ");
INSERT INTO dhg_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Djäkan warra nhumaliŋguway yulŋum, mä ŋarru barkthu nhumaliny ŋangawulmu yolŋuyum warrayu bawaꞌ-guŋu. Yolŋum warra nhumaliŋgu ŋarru ŋurru-bilꞌpilun ḻinygu nhuma bayiŋ gayŋa banha nyäku malthun. Ga ŋayathu dhanal barkthu nhumaliny bala gutjparrun dhä-wirrkaꞌyundawun, bala gayŋi bartjumun nhumaliny ŋunhalan biryamiŋan buṉbuŋa. Ga dhäyanharamiŋgum dhanal barkthu nhumaliny ṉapuŋgaḻ yana gumurrḻi buŋgawawuḻ warrawuḻ ga gapmanguḻin yolŋuwuḻ warrawuḻ. Ga bilanyamiyuyan nhunum barkthu gayŋi nhänanham bitjuwayiŋ rakaraŋ yolŋuwuḻim warrawuḻ, ");
INSERT INTO dhg_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","mä ŋarru barkthu bukmakthum bäpurruꞌyu ŋäkun nyäkuruyma dhäwu. Yo, ŋurruŋum ŋarru gayŋi dhaŋu bukmakthum bäpurruyu dhäwu ŋatjil ŋuwakurru ŋäku, ga ŋärrun barkthu banha walum dhä-yawarꞌyu. ");
INSERT INTO dhg_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Yo, yolŋuyum warrayu nhumaliny barkthu mataꞌyumun bala gutjparrun nhumaliny dhä-wirrkaꞌyundawun, ŋarru nhumam ŋarru ŋangawul bitjuwayiŋ warwuyun nhalpiyan nhuma ŋarru garrun. Nhännha ŋarru barkthu banha Dhuyu-Birrimbirryun nhumalinham yän-wuŋu garrundawum. ");
INSERT INTO dhg_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ga bayiŋ ŋarru banha yolŋu mä-wulitjmiyi nyäkum, yolŋuyum gurruṯumiyum warrayu ŋarru nhanany guwatharaŋun waŋayumun yana. Wäwa'manydjin ŋarru guwatharanharami rakunygunharamin yana. Ga bitjuya ḻinygu barkthu mori'miŋuyum guwatharaŋ dhanaliŋguway wäwunŋunhan yumurrkuny'. Ga yumurrkum' ŋarru barkthu ŋapa-bilun ŋäṉḏi'miŋuwum ga mori'miŋuwum, yolŋunhan dhupaliŋgu dharrwunuŋ. ");
INSERT INTO dhg_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ga guḻkun yolŋum warra nhumaliŋgu barkthu ŋaramurryim, ḻinygu nhuma bayiŋ gayŋa nyäku bitjuwayiŋ malthun. Ga banha nhunu ŋarru gayŋa wanyum yana djingaryun ga ŋangawulma nhunu ŋarru mä-djawaryu, nhanmam ŋarru God-Waŋarryum nhunany wälŋakuŋun.” ");
INSERT INTO dhg_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ga baḏak nhan gayŋan banha Djesum garruwan bitjan, “Dhikayam barkthu barrakinynha marimin yana be nhän maḻŋꞌthu. Ga djingaryum nhan barkthu gayŋi banha banhalayan God-Waŋarrwuran Dharrpalŋan Buṉbuŋam ŋunhalan Djurutjalamnha, barrakinydjumun barkthu banhayan ŋirrima, banha ŋangawul nhan warri gulitjma bitjarra maḻŋꞌthuwarra. Ŋarru, girriꞌ-ŋuwatjiyan gayŋiya nyiniyam,” bitjan. (Ga bayiŋ nhunu gayŋa nhäma dhaŋu dhäwuny, marŋgiyiya yana ga gulitjuma dharaŋgam, ga bitjuya ḻinygu nhunum girriꞌ-ŋuwatjiyan gayŋiya nyiniya.) Ga baḏak nhan nyin banha Djesum bitjuwayiŋ garruwan bitjan, “Banha nhuma ŋarru bilanyawuyma nhäŋu, banham dhä-yawarꞌyundamim walu galŋaꞌkalŋan. Ga bayiŋ nhumam ŋarru Djudiyawupuyŋuyum yolŋuyu warrayu bilanyawuy nhäŋu, ṉakamam bala gätthuwan yana ŋunha bukuꞌpukumiḻin ŋirrimaḻim. ");
INSERT INTO dhg_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ga banha nhunu gayŋa warraŋulma nhuŋguwaywuḻ buṉbuŋa ŋarraꞌŋarra, ŋangawulnha gätthuwa ḏirruwa djinawaꞌḻim buṉbuḻi be nhäwum ŋolkaŋ. ");
INSERT INTO dhg_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ga banha nhunu gayŋa ḏiltjiŋam nyena, ŋangawulnha gätthuwa nhuŋguwaywuḻ buṉbuḻim girriꞌwum nhuŋguway, gätthuwan bala wandhan yana. ");
INSERT INTO dhg_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ga gumurr-wanyun barkthu banha marimin yothumiwum baṯamiwu warrawu bilanyamiyuyam waluyu. ");
INSERT INTO dhg_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Bukumiŋgan God-Waŋarrwuḻim, mä ŋarru banha gumurr-wanyum rom maḻŋꞌthu bilanyamiyu waluyu, banha nhan gumurr-yalŋgin gätthundawum bitjuwayiŋ yolŋuwum. ");
INSERT INTO dhg_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ga djinaŋum mariyu barkthu yolŋum warra galŋam marimin dhaŋga-ḏirryum, barrakinydjin ŋarru. Bewaḻi ḻinygu banha nhan God-Waŋarryu ŋurruŋu bitjuwayiŋ ŋurruyirrꞌyuwan dhaŋu waŋgalany, bilanyamiyu gayŋan banha yolŋum warra ŋurruyirrꞌyuwanam dhaŋga-ḏirryuwan. Ŋarru djinaŋum mariyu barkthu yolŋum warra marimin galŋam-barrakinydji. Ga yalalam ŋangawulnha nhan barkthu banha biyapulma bilanyaya gumurr-wanyu maḻŋꞌthu. ");
INSERT INTO dhg_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ga banha nhan ŋarru God-Waŋarryu ŋangawulma banhaya mariny gulunmaraŋ, nhanmam ŋarru yolŋum warra warrpamꞌnha yana murrmurryu. Ŋarru God-Waŋarryum banha ḻinygun bitjuwayiŋ nhanguwayma yolŋuny warrany gänaŋꞌthumanan, ga ŋangawul nhan ŋarru nhäma dhanaliny waŋayinyaḻi bala nhan ŋarru banha marim guṯikuŋun, mä dhanal ŋarru wälŋayi. ");
INSERT INTO dhg_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ga banha barkthu yolŋu bitju garru, ‘Dhaŋun ŋanapu ḻinygun maḻŋꞌthumanan banha Maŋutji-yunupayumandanham yolŋuny, dhaŋun nhan yulŋum.’ Nhumam ŋangawulnha mä-wulitjiya. Ga banha dhanal ŋarru bitjanma garrun, ‘Ŋunhan bala nhan, ya ŋunhan,’ ŋangawul yana mä-wulitjiya. ");
INSERT INTO dhg_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Guḻkuyu yolŋuyu barkthu gayŋi rakaraŋ bitjun, “Ŋaya dhaŋu God-Waŋarrwuŋum Maŋutji-yunupayumanda yolŋu.” Ga waripum ŋarru bitju garru, “Ŋaya dhaŋu djawarrkmim yolŋu,” ŋarru gulitjma dhanal ŋarru gayŋi banha nhumalinhan mayaliꞌ-wutjparru. Ga bitju mu dhanal barkthu gayŋi banha ŋayaŋu-ganyimꞌthundamim rom mala djäma. Ga bitju dhanal barkthu gayŋi guyaŋim, ‘Gu, ŋalma bawa-guŋan dhaŋu God-Waŋarrwu mala-djarrꞌyundany yolŋuny warrany.’ Ŋarru gulkurun dhanal barkthu banha bitjuyam djäma. ");
INSERT INTO dhg_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Gatjuy djäkan warra! Dhaŋum ŋaya gayŋa rakaraman nhumaliŋgu yulŋum, mä ŋarru banhayam walu waythu, nhumam ŋarru gayŋa girriꞌ-ŋuwatjin nyena bayikuyam.” ");
INSERT INTO dhg_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ga biyapulma nhan Djesuyu bitjan gayꞌ rakaran, “Ga dhurrwaraŋuru banha murrukayŋurum mariŋuru, walum ŋarru munhaꞌyun ga wirrmum ŋarru ŋangawulnha biyapulma djarraṯawunmiyi. ");
INSERT INTO dhg_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ga ganyum mala barkthu ŋarray burrulꞌyun djiwarrꞌŋurum ga nhä malany ganydjarr ŋunhuŋ nhäwu malaŋuwu ŋunha djiwarrꞌŋam ŋarru rurrꞌrurryun. ");
INSERT INTO dhg_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ga bewaḻiyam bala barkthu yolŋuyum warrayu bukmakthum nhäŋun nhänanham banha Gulitjŋunham Walꞌŋu Yolŋuny. Ga yarrupthum ŋaya ŋarru djiwarrꞌŋurum rälim waŋupiniꞌyun. Ga bukmakthum yolŋuyu ŋarru banha nhäŋum nhänany djeŋarraꞌyakaynha dhikan, bäyman galumanyaŋnha, ganydjarrmin. ");
INSERT INTO dhg_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Bala ŋaya ŋarru djuyꞌyun God-Waŋarrwum djiwarrꞌwuynham dhäwuminy yolŋuny warrany, dhanal ŋarru barkthu yurrumꞌthumun nyäkum mala-yarrꞌyundanham yolŋuny warrany dhaŋu buku-ḻiwꞌyuman ŋarra ḏäpthun, bewaḻi dhimurruŋuru ga ḏupthun bärraꞌḻi ga dhawuru bala ḻuŋgurrmaŋuru ga yanatj ḻinygu-u-u ga djalathaŋḻi wapthun.” ");
INSERT INTO dhg_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ga baḏak nhan gayŋan banha Djesum garruwan bitjan, “Banha nhuma bayiŋ nhäma marwatnha ḏarpany galaḏarꞌyundam nhumam bayiŋ marŋgiyin banha dharratharramim walu galkin. ");
INSERT INTO dhg_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Yo, banha nhuma ŋarru bilanyawuyma nhäma, bayiŋuyam banha gumurr-wanyuyum romdhu gayŋa maŋutji-rakaraman nyäku waythundawum walu galitjinan. ");
INSERT INTO dhg_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Dhaŋum ŋaya ŋarru dhuṉḏay yana nhumaliŋgu rakaram! Dhawuru gayꞌ ŋurrukŋuru, dhaŋu nhuma ŋarra djingaꞌdjingaryun, waripum warra nhuma barkthu gayŋi wälŋa yana nyenay, ga nhäŋu yana nhuma barkthu bilanya gumurr-wanyu rom maḻŋꞌthunda. ");
INSERT INTO dhg_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Yo! Nhäm mala bukmakma barkthu dhawarꞌyun, ŋunha djiwarrꞌ waŋgala ga dhaŋu munathaꞌ waŋgala, dhawarꞌyun ŋarru. Ŋarru yänma nyäku ŋarru banha ŋangawulnha dhawarꞌyu, banhayam ŋarru gayŋa djingaryuna yana wikarraŋumin, dhawarꞌyundanharran.” ");
INSERT INTO dhg_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ga biyapulma nhan Djesu garruwan bitjanan, “Ŋangawul dhaŋu ŋunhuŋ waŋgany yolŋu marŋgi nyäkum waluwu ḏirrundawu. Ŋunha God-Waŋarrwu djiwarrꞌwuy dhäwumi yolŋu warra ŋangawul marŋgimi. Ga ŋayapi dhaŋu ŋangawul yana marŋgi. Nhanbayin yana dhaŋu Moriꞌmiŋun nyäku marŋgim, ga ḻinygun. ");
INSERT INTO dhg_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Gatjuy, djambatjiya warra gayŋiya nyiniyam, ḻinygu nhuma ŋangawul dhaŋu marŋgi bayikuyam bitjuwayiŋ waluwu. ");
INSERT INTO dhg_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Dhaŋu ŋaya ŋarru dhäwu nhumaliŋgu rakaram mayaliꞌmi: Waŋganydhum waluyu ŋirrima-waṯaŋuyu yolŋuyu guŋnharruman nhanguway ŋirrimany bala ŋarranan bärrkuḻin ŋirrimaḻi. Ga garruwan nhan nhanguway djämaminy warrany, dhanal ŋarru gayŋa djäma yulŋum, ga djäka nhanguru nhäwum malanyŋuwu ŋuwatjuman yana. Ga garruwan nhan dhurrwara-djäkaminham warrany dhanal ŋarru gayŋa batjiwarr-nhäma yana, ga gumurr-ḏirrun nhan ŋarru. ");
INSERT INTO dhg_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ga ŋangawul dhanal banha bitjuwayiŋ marŋgi nhaliyu waluyu nhan ŋarru banha gumurr-ḏirrun. Wilak nhan ŋarru walu gulŋiyinyarayu waythun nhä wilak gandarryu munhayu, nhä wilak munhamurru. Yuw, waraparra, nhumam dhaŋu bilanyayan bitjuwayiŋ banha djämamin yolŋu warra, ga ŋangawul nhuma dhaŋu marŋgi nhätha ŋaya ŋarru ḏirrun räli. Gatjuyꞌ, nhumam maŋgarra girriꞌ-ŋuwatjiyan yulŋum. ");
INSERT INTO dhg_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Batjiwarr-nhäŋan warra gayŋiya nyiniyam, bitjuwayiŋ banha yolŋu dhurrwara-djäkami bayiŋ gayŋa djingaryun batjiwarr-nhäma nyin yana, mä nhan ŋarru ŋangawul nhuna maḻŋꞌthuman wawuŋuḻim. ");
INSERT INTO dhg_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Dhaŋu ŋaya ŋarru garruna nhumaliny, ga bukmaknha yolŋuny warrany, ‘Gatjuy djäkam warra ŋuwatjuman, batjiwarr nhänharayun.’” Yo, djinalan nhan dhäwum bitjuwayiŋ Djesuyum gunhan, banha nhan gayŋan rakaran nhanguwaywuru guyurrꞌmiŋuwu warrawu ŋunhalaya bukuŋa yäkuŋa Wolip. ");
INSERT INTO dhg_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","2","Yo, bala banha ŋurruŋu-ḏalkarramim yolŋu warra ga rom-marŋgikunhamim warra yurrumꞌthuwanan bala dhanal gayŋan garrunminan nhalpiyan dhanal ŋarru Djesuny bitjuwayiŋ ŋayathan, ŋarru gayul, ḻinygu dhanal gayŋan marimin yana djälmiyin dhanal ŋarru waŋayumana nhanany, bala dhanal bitjanan garrunminam, “Wäy, gäḻkuḻam ŋalma ŋay, ḻinygu rom ŋalmaliŋgu gayŋa dhaŋu murrukay bitjuwayiŋ ŋarra. Dhanal bayiŋ yolŋun warra ŋalmaliŋgu mari-waythu, ḻinygu dhanal nhangu dhaŋu Djesuwum djälnha bitjuwayiŋ marimin.” Ga banha dhanal bitjanam garrunmin ḻinygu banha burrparnha yana walum bala banhayan ŋarru rom gämurruꞌyirryun banha Räy-djuḻkthumandamin Walu ga waripu rom yäku Ḏambanharra Ŋatha. Ga bayiŋuyam waluyu dhanal bayiŋ guyaŋiyarra dhanaliŋguway ŋaḻapaḻminy, gurruṯuminy warrany, banha dhanal ŋaykan guŋnharruman ŋirrimany yäkuny Yetjipnha. ");
INSERT INTO dhg_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ga nhanmam gayŋan banha Djesum nyenan ŋunhalan ŋirrimaŋa yäkuŋa Bithanin, ŋatha gayŋan guwaman Djäymangura ŋirrimaŋa. Ga ŋätjilim nhan gayŋan banha Djäymanma nyenan rerrimi, burrundhiyaꞌyu gayŋan buṉakin. Ŋarru nhan banha ḻinygun bitjuwayiŋ ŋuwakurrun. Ga yaka wikarra bala baṯamin banhambalaya gulŋiyan goŋ muṉuŋgarriꞌmin, ŋarru ṉutjurru banha yulŋum. Ga gutjparruwanam nhan gayŋan wuŋiḻi-ŋuwakurru, ga warrpurum banha ŋuwakurrun dhika marimin, ŋarru rrupiya murrukaymin. Ga ḻapthuman nhan banha muḻkurr yana muṉuŋgarrinyꞌ, bala rarruwanan wuŋiḻi-ŋuwakurrum Djesuwuḻin muḻkurrḻi. ");
INSERT INTO dhg_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ga dhanalim banha yolŋuyum warrayu nhanany dhaykuwanan bitjanan, “Nhäwu nhunu dhaŋu wuŋiḻi-ŋuwakurrum djalkthuwan? ");
INSERT INTO dhg_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nhunu warri dhaŋu djalimnha rrupiyawun murrukaywun, ga rrupiyam nhunu warri banha guŋarra ŋunha ŋurruwuykminhan yolŋuny warrany.” ");
INSERT INTO dhg_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Bala nhan Djesum garruwan dhanaliŋgu bitjanan, “Guŋnharruma warra nhanany. Ŋangawul warra nhangu mari-waythuwa. Dhaŋum nhan ŋuwakurrun bitjuwayiŋ djäma nyäkun. ");
INSERT INTO dhg_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ŋunham banha ŋurruwuykma yolŋu warra ŋarru gayŋi nyenay nhumaliŋguḻ djinal bitju ḻinygu, ga bilanyamiyun nhuma barkthu dhanaliny ŋarray banha guŋgaꞌyum. Ŋarru ŋayam ŋarru dhaŋu nhumaliŋguḻ yakan wikarra nyena, guṯin nyäkum walu. ");
INSERT INTO dhg_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Dhaŋu ŋaya barkthu waŋayin bala dhanal ŋarru nyäku rumbalma märrkitjkuŋun. Ga djinaŋum banha baṯamiyu rarruwan nyäkuḻ dhaŋu wuŋiḻi-ŋuwakurrum, banhayam nhan bitjan ŋätjilmiŋganan nyäku rumbalnha. Ga ŋuwakurrun nhan dhaŋu marimin yulŋum bitjanyam djäma. ");
INSERT INTO dhg_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ŋäka warra nhänany. Dhaŋum ŋaya ŋarru nhumaliŋgu gulitj yana rakaram. Banha barkthu ŋarray yolŋum warra dhaŋum dhäwu rakaranhami be wala ḏämbu-ḻiwꞌyumum, ga ŋäku yana dhanal barkthu djinakuruy baṯamiwuruyma dhäwu, banha nhä nhan nyäku djäma bitjuwayiŋ ŋuwakurru gäthura. Ga guḻkun ŋarru banha nhangu yolŋum warra bitjuwayiŋ marŋgiyi.” ");
INSERT INTO dhg_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ga dhurrwaraŋuru bewaḻiyam nhanmam banha waŋganyma yolŋu yäku Djudatj-Gariyatma bewaḻiyam malaŋuru banha 12-kurum guyurrꞌmiŋuwuru ŋarranan. Yo, ŋarranam nhan banha guwatjmanam banhayanhan banha ŋurruŋu-ḏalkarraminhan warrany, mä nhännha ŋarru dhanaliny guŋgaꞌyunma goŋ-guŋanma Djesunham dhanaliŋguḻ. Ga rakaran nhan dhanaliŋguḻ nhanguway ŋayaŋu. ");
INSERT INTO dhg_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ga banha dhanal bayiŋuya ŋaḻapaḻmiyu bitjuwayiŋ ŋäkulam bala dhanal ŋoy-ŋuwatjinan. Bala dhanal dhawuꞌ-nhinathuŋganan nhanany bitjanan, “Bayiŋ nhunu ŋarru Djesuny ŋanapiliŋguḻ goŋ-guŋan, ŋanapum ŋarru nhuna wuŋiḻiꞌyuna bayikuwuyma.” Bala nhan Djudatjma ŋarranan, bala gayŋan batjiwarrwun rangan nhalpiyan nhan ŋarru Djesuny dhanaliŋguḻ guŋan. ");
INSERT INTO dhg_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ga bitjarra ḻinygu dhuŋgarra ŋuparra ŋunhuŋ ŋurruyirrꞌyundamiyu waluyu Djuwwuḻ Romŋa, dhanal bayiŋ dämba ŋomarra ŋunhuku romgu yäkuwu Ḏambanharrawu Ŋathawu, ga ḻiyuwarra dhanal bayiŋ bimbiny romgu yäkuwu Räy-djuḻkthumandamiwu Waluwu. Manymak, ga bilanyayu ḻinygu yana waluyu, dhanalim banha guyurrꞌmiŋuyum warrayu garruwanan nhanany Djesunham bitjanan, “Ŋalaŋa waŋgalaŋam ŋanapu ŋarru ŋatham banha Räy-djuḻkthumandamim ŋätjilmiŋgan?” ");
INSERT INTO dhg_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Bala nhan Djesuyum garruwanan nhanguway guyurrꞌmiŋunhan wulanynha bitjanan, “Gatjuy maŋgarran wulay balan Djurutjalamḻin. Ga banha nhuma ŋarru waythunma bala nhuma ŋarru nhämam ḏirramunhan nhan ŋarru gayŋa garaŋayu gutjparrun banikinꞌmi makati. Ga malthuwa wulay nhangu, ga gulŋiya nhan ŋarru buṉbuḻ, nhuma ŋarru malthun nhangu. ");
INSERT INTO dhg_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ga ŋunhalam djinawamꞌ nhuma ŋarru garrun buŋgawany bayikuya buṉbuwu, ga bitjan nhuma ŋarru nhangu rakaramam gamꞌ, ‘Wäy, ŋunha Marŋgikunhami ŋäŋꞌthuwan ŋalaŋa ŋalinyu ŋarru Räy-djuḻkthumandamim ŋatha ŋamaŋamayun, mä ŋarru ŋanapu guwaman bitjuwayiŋ, nhanbay ga ŋanapu nhanguru guyurrꞌmiŋuyu warrayu.’ ");
INSERT INTO dhg_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Bala nhan ŋarru bayiŋuya buŋgawayum maŋutji-wuŋana ŋunhan banha garramatnha balaꞌpala, ḻinygun dhäyan gayŋan, bäkiwun ŋalmaliŋgu, ga ŋunhalayan nhuma ŋarru banha ŋatham ŋalmaliŋgu ŋamaŋamayun.” ");
INSERT INTO dhg_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Bala yana dhupal banha malthundamim wulay ŋarranan. Ga banha dhupal Djurutjalamma waythuwan, ga maḻŋꞌthumanam, dhupal banhaya ḻinygu banha nhalpiyan nhan gayŋan Djesuyu dhupaliŋguḻ rakaran. Ga ŋunhalayan dhupal banha Räy-djulkthumandamim ŋatha ŋamaŋamayuwan. Ga goŋ-dhawarꞌyuwan dhupal bala ḏirruwanan Djesuwuḻin. ");
INSERT INTO dhg_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ga banha ŋarran walum guṉiyirrꞌyuwan bala nhan Djesum ga guyurrꞌmiŋum warra nhangu banha 12-ma ŋarranan balayan waŋgalaḻ. ");
INSERT INTO dhg_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ga banha dhanal ŋarran ŋatham guwaman, bala nhan Djesum garruwanan bitjanan, “Gulitj yana ŋaya ŋarru dhaŋum nhumaliŋgu rakaram. Dhaŋu gayꞌ djinalaŋa malaŋa ŋatha ŋalma ŋarra dhaŋu guwaman rrambaŋi, waŋganyma yolŋu ŋarru nyäku mulkuruyin,” bitjan. ");
INSERT INTO dhg_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Bala dhanalim banha guyurrꞌmiŋum warra nhangu galŋam-barrakinydjinan bayiŋuyam yändhum nhanguru, bala dhanal ŋarran dhä-wirrkaꞌyuwanan nhanany bitjanan, “Wäy,... yolthu way... ŋaya ŋatja Marrkapmi?” bitjanan. ");
INSERT INTO dhg_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Bala nhan Djesum bitjanan garruwan, “Waŋganydhum gayŋa dhawuru malaŋuru ŋathan ḻupthuman banikinꞌḻin, ŋalinyun rrambaŋin, banhayan yolŋu ŋarru nyäku mulkuruyim. ");
INSERT INTO dhg_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Guyaŋiya warra, ŋayam dhaŋu Gulitjŋum Walꞌŋu Yolŋu ŋarru waŋayin bitjan yana ḻinygu bitjuwayiŋ ŋunha gayŋa God-Waŋarrwura Dharrpalŋa Djorraꞌŋa wukirriwuy djingaryun. Ga murrukaynha marimin ŋarru bayikuyam gumurryu-gutjparrundamiwum yolŋuwu mari maḻŋꞌthun. Ga ŋuwakurrum nhangu nhan warri ŋangawul waŋgala-wuyaŋiyarra.” ");
INSERT INTO dhg_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ga baḏak dhanal ŋarran banha guwaman ŋatham, bala nhan Djesuyum dämban warraṯthuwan bala ḏämbu-wuŋanan God-Waŋarrnhan bayikuya. Ga ganitjuman nhan, bala guŋanan ŋarran dhanaliny. Ga garruwan nhan bitjan, “Dhaŋum dämba nyäkun rumbal. Maꞌ warraṯthuwa bala guwaman.” ");
INSERT INTO dhg_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ga bitjanya ḻinygu nhan warraṯthuwan wiyikaꞌ banikinꞌmi, ga ḏämbu-wuŋan nhan God-Waŋarrnha, bala nhan guŋanan banha wiyikamꞌ ŋunha guyurrꞌmiŋuwuḻin wurkthundawun. ");
INSERT INTO dhg_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Bala nhan bitjanan garruwan, “Dhaŋum borum wiyikaꞌ nyäkun maŋguꞌ, banha ŋarru barkthu djalkthunmi guḻkuwun yolŋuwum wälŋakunharawu. Ga ŋätjil nhan banha God-Waŋarryu djäma gumurrkunhaminyara rom wälŋakunharawu guḻkuwu yolŋuwu. Djinaŋun banha nyäkurun maŋguꞌyu ŋarru romnham ŋarranharamiŋgan, maḻŋꞌthuna ŋarru gulitjtjin. Maꞌ warraṯthuwa bala wurkthuwan. ");
INSERT INTO dhg_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ga dhaŋun gamꞌ, ŋangawulnha ŋaya ŋarru biyapulma borum wiyikaꞌ wurkthu, ga baya barkthu ŋalinyu rrambaŋin bitjuwayiŋ nyenay ŋunhalan djiwarrꞌŋan God-Waŋarrwuran romŋa.” ");
INSERT INTO dhg_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ga dhurrwaraŋuru bewaḻiyam bala dhanal manikaynha miyaman God-Waŋarrwuḻin. Bala dhanal ŋaykanan balan bukuḻin yäkuḻi Wolipḻin. ");
INSERT INTO dhg_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ga banha dhanal ŋarran ŋaykanam bala, bala nhan Djesuyum rakaranan ŋätjilꞌyuwanan bitjanan, “Yalŋuwam banha munhakum nhuma ŋarru dhaŋuyma warra gätthuna nyäkuru, guŋnharrumana nhänany. Yo, ŋätjil mu yana banha waŋganydhu yolŋuyu dhäwum bitjuwayiŋ wukirri Dhuyuḻim Djorraꞌḻi bitjanam gamꞌ, ‘God-Waŋarryum ŋarru guwatharaman waŋayumana banha wäyin-djägaminham, bala nhangu ŋarru bimbim mala ḻatjuwarrꞌyuna.’ ");
INSERT INTO dhg_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ŋayam ŋarru waŋayin. Ŋarru ŋaya barkthu dhaŋu biyapulya wälŋayi bala ŋaya barkthu ŋurruŋu-djuḻkthun nhumaliŋgu, ga ŋunhalan ŋaya barkthu nhumaliŋgu gäḻkuḻaŋum Galaliŋan makaŋa. Yo, ŋunhalayan nhuma barkthu nhänany nhäŋum.” ");
INSERT INTO dhg_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ga nhanmam Betam garruwan bitjanan, “Ŋayam ŋarru nhuna ŋangawul guŋnharruman, marrkapmi, bayatj ŋarru banha dhaŋum warra ḻatjuwarrꞌyu, ŋarru ŋayam yaka.” ");
INSERT INTO dhg_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ga nhanmam Djesum garruwan bitjanan, “Ŋäka nhänany ŋuwatjuma Beta. Djinaŋum bala munhaku, yalalam, nhunu ŋarru nyäku dhä-bayaŋuꞌyuna ŋarru ḏämbu-ḻurrkunꞌmin, ga ŋärrun nhan ŋarru banha wäyinma gurrwawum ŋätji burrparmim.” ");
INSERT INTO dhg_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ga nhanmam Betam ḏämbu-dhuwaḻyuwan garruwan bitjanan, “Ŋangawul dhaŋu ŋayam ŋarru nhuŋgu dhä-bayaŋuꞌyun, bayatj banha ŋaya ŋarru waŋayim!” Ga dhanalim banha waripum ḻunduꞌmiŋu warra ga bitjanya ḻinygu garruwan dharaŋanda yana yän. ");
INSERT INTO dhg_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ga banha dhanal Djesu ga guyurrꞌmiŋu warra nhangu waythuwanam banhalayam ŋirrimaŋa yäkuŋa Githtjamanim, bala nhan Djesum garruwanan, “Djinal warra ḏäpthuwa, ŋaya ŋarru bukumiŋgan God-Waŋarrwuḻ,” bitjan. ");
INSERT INTO dhg_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","34","Bala nhan gaḏaymanam Betanhan ga Djayimnhan ga Djonnhan, bala dhanal bitjanan bala ŋaykan. Ga banha dhanal ŋarran bala martj-martjuwanam, bala nhan bitjanan garruwanam dhanaliŋguḻ, “Waraparra, ŋayaŋum nyäku dhaŋu mariminan yana ŋonuŋdjin bitjuwayiŋ ŋaya ŋarru dhaŋu waŋayin. Djinal warra ḏäpthuwa, ŋarru djäka gayŋiya yulŋum,” bitjan. ");
INSERT INTO dhg_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Ga ŋarran nhan mä bayiŋ gaŋga, bala nhan gälkinan munathaꞌḻin bala ḏämbumiŋganan, “Mori nyäku marrkapmi, ŋangawulnha dhaŋu nhuŋgum gumurr-wanyu ŋunhuŋ nhäwum mala djämawu. Moriꞌ, ḏukṯukma ŋaya dhaŋu nhunu ŋarru yarrkthumana dhaŋu marim nyäku. Ŋarru ŋayapim ŋarru gayŋa dhaŋu nhuŋguwaynha yana djälwum malthun, ŋangawulnha nyäkuwayma ŋaya,” bitjanan nhan gayŋan bukumiŋganam. ");
INSERT INTO dhg_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ga ḏirruwan nhan balaya guyurrꞌmiŋuwuḻ warrawuḻ nhanguwaywuḻ ga maḻŋꞌthumanam nhan dhanaliny gayŋiyinyaraḻin. Ga dhirrꞌyuwan nhan dhanaliny, bala nhan Betawuḻin garruwan bitjanan, “Wäy, nhalpiyan nhunum gayŋa dhaŋu, gayŋiya yana? Ŋangawul nhuma ŋarru dhaŋu mä ŋunhuŋ guṯim yana biraꞌyun? ");
INSERT INTO dhg_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Djäka warra nhumaliŋguway, ga ḏämbumiŋgan warra God-Waŋarrwuḻin mä nhumaliny ŋarru banha ŋunhuŋ nhäyum birrkaꞌyun, nhumam ŋarru gayŋa dhäyam wanyun yana. Ḻinygu ŋayaŋum nhuŋgu gayŋa dhuwan djälmiyi nhunu ŋarru gayŋa dhäya wanyu yana, ŋarru rumbalma nhuŋgu dhuwan ganydjarrnharrayinan yalŋgiyinan,” bitjan. ");
INSERT INTO dhg_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ga biyapulya nhan Djesu ŋarran ḏämbumiŋgandawu, ga bitjanya ḻinygu nhan ḏämbumiŋgan bilanyaya ḻinygu yana yän. ");
INSERT INTO dhg_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ga ṉakaman nhan, ga ḏirruwan bewaḻim bukumiŋgandaŋurum ga maḻŋꞌthumanam dhanaliny yakurrḻi yana, murrukayyun dhanaliny yakurryu bitjuwayiŋ bulukthuwan. Ga banha dhanal ḏurruwanam bala goṉayinan, ga ŋangawulnha dhanal nhangu ŋunhuŋ ḏämbu-ḏirrunmaranam. ");
INSERT INTO dhg_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ga biyapulma nhan ḏämbu ḻurrkunꞌmin gumurr-ḏirruwan bukumiŋgandawu. Ga banha nhan ḏirruwanam bala garruwanam nhan bitjanan, “Ḻinygun yakurrŋurum warra guluwan! Walum dhaŋu galitjinan, nhan ŋarru bayiŋuyam yolŋuyu goŋ-guŋana banha Gulitjŋunham Walꞌŋu Yolŋuny barrakinymiwuḻin yolŋuwuḻ warrawuḻ. ");
INSERT INTO dhg_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Maꞌ! Ḏurruwan warra ŋalma ŋarran. Nhäŋan warra, dhaŋun nhan banhayam yolŋu banha nhan guŋgaꞌyuwan dhanaliny ŋayathandawu nyäku.” ");
INSERT INTO dhg_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ga ŋurruŋu-ḏalkarramiyu malaŋuyu ga rom-marŋgikunhamiyu warrayu ga Djuwwu ŋurru-warrundayŋuyu warrayu yänguwan waripuny yolŋuny warrany Djudatjkum ŋapawu malthundawu. Ga nhanmam gayŋan banha Djesum baḏak bitjuwayiŋ garruwan, bala nhanmam Djudatjma waythuwanan ŋapa-malamin. Ga ŋaykanam dhanal gayŋan banha malkarr, goŋ gaṉami, ga goŋ birkuꞌmi mala, ŋayathandawum nhangu Djesuwum. ");
INSERT INTO dhg_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ga ḻinygu nhan banha Djudatjthum dhanaliŋgu rakaran bitjan, “Banha yolnha ŋaya ŋarru burumunꞌ wälkum banhayanhan yolŋuny nhuma ŋarru ŋayathanma.” ");
INSERT INTO dhg_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ga banha dhanal waythuwanam bala nhan Djudatjma ŋarranan Djesuwuḻin bala garruwanan bitjanan, “Marŋgikunhami,” bitjanan, bala wälkuwanan nhanany, mä bayiŋuyam maŋutji-wuŋanan dhanaliŋguḻ banha yolnha dhanal ŋarru bitjuwayŋ ŋayathan. ");
INSERT INTO dhg_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Bala banha waripum yolŋu warra djalkiri-dhatharꞌyuwanan bala ŋayathanan nhanany Djesunham. ");
INSERT INTO dhg_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Bala banha waŋganydhum Djesuwuru ḻunduꞌmiŋuyu yikin dhawaṯthuman bala yana buthurun gulkthuwan, ḻiya-ŋärramiwun yolŋuwu djämaminy. ");
INSERT INTO dhg_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Bala nhan Djesum garruwan bayikuya yolŋuwum warrawu bitjanan, “Nhäwu nhuma rälim ŋaykan malkarrma? Ŋangawul ŋaya dhaŋu maḏakarritj yolŋu. ");
INSERT INTO dhg_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ŋayam gayŋan bitjan ḻinygu walu-ŋupan marŋgikuwan yolŋunham warrany ŋunhalam God-Waŋarrwuram Dharrpalŋam Buṉbuŋa, ga ŋangawultji nhumam nhänany bilanyamiyuyam ŋayatharra... ŋarru dhaŋun nhumaliŋgu walum. Yo, bitjan mu nhan gayŋa ŋunha wukirriwuyma dhäya ŋätjiliŋuwuyma God-Waŋarrwuram Djorraꞌŋa,” bitjanan nhan Djesu garruwanam. ");
INSERT INTO dhg_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Bala banha Djesuwum ḻunduꞌmiŋu warra biyaṉiyinan bala dhanal gätthuwanan, guŋnharrumanan nhanany banhambalayan. ");
INSERT INTO dhg_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ga banhalaya gayŋan gurrmulyu ḏirramuyu ŋapa-munguyuwan Djesuny, ga ŋäkirriyumanminam nhan banha manydjarrkaꞌyu. Ga bitjanya ḻinygu dhanal banha nhananham ŋayathan. ");
INSERT INTO dhg_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ŋarru dhanal nhanany baḏatjuwanan ga ŋayathanam dhanal nhangu banha manydjarrkanꞌ. Ga nhanbayim gayŋan gätthuwan waŋgalaḻim djolarranꞌ, girriꞌnharran ḻinygu nhan banha biyaṉiyinan mariminan. ");
INSERT INTO dhg_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Bala dhanal banha Djesunham gutjparruwanan balan ḻiya-ŋärraꞌmiwuḻin ŋirrimaḻim. Ga balayan ŋarran banha ŋaḻapaḻmim ḻuŋꞌthuwan bukmak yana, ŋurruŋu-ḏalkarrami warra ga Rom-marŋgikunhami warra ga Djuwwu ŋurru-warrundayŋu warra. ");
INSERT INTO dhg_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ga banha dhanal Djesuny gutjparruwanam, ga nhanmam gayŋan Betam malthuwan bala, balaya ḻiya-ŋärraꞌmiwuḻ ŋirrimaḻi, ŋarru djuḻuꞌdjuḻuḻyuwan ŋarran bala. Ga gulŋiyan dhanal rrambaŋi yana balayam, bala nhan mala-manapanan nyenan biḻitjumanguḻin warrawuḻ banha ŋarran ḏäpthuwan ratjuwan ŋorrtjaŋa. ");
INSERT INTO dhg_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ga ŋunhalam banha djinawamꞌ buṉbuŋam dhanalim banha ŋurruŋu-ḏalkarramiyum warrayu gayŋan dhäwunꞌ maḻŋꞌthuman Djesuwuruynha, mä dhanal ŋarru dhä-girꞌyuna nhanany barrakinybuynha warkthunda. Ŋarru ŋangawul dhanal banha maḻŋꞌṯhunmaran ŋunhuŋ nhäm barrakinyma nhangura. ");
INSERT INTO dhg_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Yo, guḻkuny dhanal yolŋuny warrany warraṯthuwan maŋutji-marŋgiminy mä dhanal ŋarru djänguman dhäwu nhanguruy rakaram, ga dhäwum mala dhanaliŋguŋ gayŋan bärrkuwaḻyinan. ");
INSERT INTO dhg_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Yo, waripu yolŋu warra bitjuwayiŋ maŋutji-marŋgimi ṉakaꞌ-ṉakaman bala gayŋan djänguwanan dhäwu rakaran ");
INSERT INTO dhg_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","bitjanan, “Dhaŋum ŋanapu yolŋuny ŋäma nhan bitjan garrun, ‘Dhaŋum ŋaya ŋarru ganitjumana God-Waŋarrwum Dharrpalma Buṉbu yolŋuwuŋum goŋbuy dhuḻꞌyunda. Ga ḻurrkunꞌthum waluyu waripun buṉbu ŋarru ŋarray ŋalthu, ga banhayam ŋangawulnha yolŋuwuŋ goŋbuy.’” ");
INSERT INTO dhg_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ga dhäwum dhanal gayŋan banha rakaranam ŋangawulnha bitjuwayiŋ dhuṉḏayma. ");
INSERT INTO dhg_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Bala nhan banha ḻiya-ŋärraꞌmim yolŋu ṉakamanan gumurrŋan yolŋuwuran warrawuḻ bala garruwan Djesuwum bitjanan, “Dhaŋu gayŋa yolŋuyum warrayu rakaram be warri nhunu barrakiny djäma. Ŋäma mu nhunu gayŋa dhanaliny? Nhäwu nhunu gayŋa dhaŋu mukthunma yana nyena?” ");
INSERT INTO dhg_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ŋarru nhanmam Djesum ŋangawulnha ḏämbu-ganitjuman. Mukthuwanan nhan gayŋan nyenan. Bala nhan banha ḻiya-ŋärraꞌmim garruwan bitjanan, “Maꞌ, rakaraŋan ŋanapiliŋgu. Nhunu dhaŋu banha Maŋutji-yunupayumandam yolŋu ŋatja... God-Waŋarrwum gäthuꞌmiŋu?” ");
INSERT INTO dhg_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ga nhanmam Djesum garruwan bitjanan, “Yo, ŋaya mu dhaŋu. Ga yalalam nhuma ŋarru nhänanham Gulitjŋunham Walꞌŋu Yolŋuny nhäman, ŋaya ŋarru gayŋa nyenam ganydjarrmin, dhunupaꞌŋuŋan God-Waŋarrwuran galiꞌŋam ŋunhalan djiwarrꞌŋan. Ga ḏirru ŋaya barkthu räli djiwarrꞌŋurum waŋupiniꞌyu. Bilanyawuynha nhuma ŋarru nhänany nhäŋum.” ");
INSERT INTO dhg_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Bala nhanmam banha ḻiya-ŋärraꞌmim yolŋu mariminan maḏakarritjin, bala ŋarran girrinꞌ nhanguway barruꞌwarrunmaran, ga garruwan nhan yatjuwanan bitjanan, “Ḻinygun ŋalma dhaŋu ŋäkulan nhanany yänma bukmakthun garrundam, banha nhan dhä-waripuŋuyinan garruwan nhangun God-Waŋarrwun. Ŋangawul ŋalma ŋarru biyapulma maŋutji-marŋgimiwuŋum dhäwu ŋäma. Nhalpiyana nhumam gayŋa guyaŋi way?” bitjan. Ga dhanalim banha bukmakma yolŋum warra yoranan yana bitjanan, “Yo, guwatharanharaŋun nhanany murrkayꞌkuŋan.” ");
INSERT INTO dhg_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Bala ŋarran banha waripuyum yolŋuyu warrayu Djesunham dhupthuwanan. Ga garrwiꞌyuwan dhanal nhanany maŋutji manydjarrkaꞌyu bala gayŋan bartjunmaranan, ga garruwan dhanal bitjan, “Maꞌ rakaraŋ wilak, yolthu nhuna ḻiyuwan?” Bala banha biḻitjumandhum warrayu Djesunham djakawarruwanan, bala gayŋan guwatharanan nhanany. ");
INSERT INTO dhg_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Ga bilanyamiyuyam nhanmam gayŋan banha Betam baḏak yana nyenan ratjumanmin. Ga banhalaya ḻiya-ŋärraꞌmiwuḻ buṉbuŋa djämamiyu baṯamiyu nhäŋal Betany banhambalaya, bala bitjanan, “Nhunum dhaŋu Djesuwu ḻunduꞌmiŋu ŋatja?... bayikuya yolŋuwu ŋirrima Nätjiritjpuywu?” ");
INSERT INTO dhg_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ga nhanmam Betam ḏämbu-ganitjuman bitjan, “Yaka dhuwanma dhunupa. Ŋangawul dhaŋu ŋaya marŋgi nhäwuy nhunu gayŋa dhaŋu garrun.” Bala yana nhan Betam walmanan galiꞌḻin ga dhuṉḏaynha yana banha gurrwawum ŋätjinan. ");
INSERT INTO dhg_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ga biyapul nhan bayiŋuya djämamiyu baṯamiyu Betany nhäŋal, ga garruwan nhan yolŋuwuḻ warrawuḻ banha ŋarran dhäyaꞌ-dhayan bitjan, “Dhaŋum yolŋu Djesuwu yana ḻunduꞌmiŋu.” ");
INSERT INTO dhg_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ga nhanmam Betam garruwan, “Ŋangawul! ... yaka ŋayam!” Ga yaka mu wikarra ga waripuŋuyum yolŋuyu nhanany garruwan bitjan, “Nhunupi yana dhaŋum, dhaŋum nhunu ŋirrima Galaliwuy.” ");
INSERT INTO dhg_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Bala nhanmam banha Betam mariminan galŋa-barrakinydjin bala nhan garruwanam bitjanan, “Ŋangawul, yaka ŋayam dhaŋu marŋgi. God-Waŋarr dhaŋu nyäkum marŋgi, ga banha ŋaya gayŋa djängumam, nhanmam ŋarru nhänany God-Waŋarryum dhä-girꞌyuna.” ");
INSERT INTO dhg_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ga dhuṉḏaynha yana banha gurrwawum ŋätjinan, banhayam ḏämbu-burrparyinan. Bala nhan Betayum guyaŋinan banha nhalpiyan nhanguḻ Djesu garruwan bitjan, “Ŋärrun nhan ŋarru banha gurrwawum ŋätji ḏämbu-burrparmim, nhunum ŋatjil nyäku ŋarru mä-wambum ḏämbu-ḻurrkunꞌmi.” Bala yana nhan Betam ŋätjinan mariminan dhika murruyꞌ-murruyyuwanan. ");
INSERT INTO dhg_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ga munhamurrun bala dhanal banha Djuwwu ŋaḻapaḻmim ḻuŋ'thuwanan bala yoranhaminan nhangu Djesuwum guwatharanharawum rakunygunharawun. Bala dhanal mata'yumanan nhanany Djesunham ŋarambiyam bala gutjparruwanan bayiŋuya ŋaḻapaḻmiyum balan nhanguḻin Bäylitkuḻin banha nhan Rawumbuywu gapmangu buŋgawa. Ga garruwan dhanal Bäylitnha nhan ŋarru nhanany mala-djarr'yuna. ");
INSERT INTO dhg_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Bala nhan Bäylitthum dhä-wirrkaꞌyuwanan nhanany, “Nhunu dhaŋu buŋgawa Djuwwum yolŋuwu bäpurruwu?” Ga nhanmam Djesum ḏämbu-ganitjuman bitjan, “Dhuwaniyan ḻinygu yana yänma.” ");
INSERT INTO dhg_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ga dhanalim banha ŋurruŋu-ḏalkarramiyum warrayu rakaranam gayŋan Bäylitkuḻim bitjanan, “Djinaŋum yolŋuyu gayŋan warkthuwan guḻkun marimin barrakinyma rom malany.” ");
INSERT INTO dhg_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Bala nhan Bäylitma bitjanan nhangu garruwan, “Ŋäma mu nhunu gayŋa? Ŋunham dhanal ŋarra nhunany rakaramam be barrakinybuynha warkthunda. Ŋangawulnha nhunu ŋarru dhaŋu ŋunhuŋ garrunma?” ");
INSERT INTO dhg_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ŋarru nhanmam Djesum ŋangawulnha garruwan, bala gayŋan banha Bäylitma mä-maŋmaŋdhuwanan nhangu. ");
INSERT INTO dhg_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Yo, bitjarra ḻinygu dhuŋgarra-ŋuparra dhanal bayiŋ gayŋa Djuw bäpurru yolŋu warra ḏämbu-manapanmi waŋganygu rom yäkuwu Räy-djuḻkthumandamiwu Waluwu. Ga bitjarra ḻinygu nhan bayiŋ Rawumanbuyyu Gapmandhu dhawaṯthumarra waŋganynha yolŋuny dharruŋguŋuru, yolku dhanal bayiŋ Djuwyu bäpurruyu ŋäŋꞌthuwarra. ");
INSERT INTO dhg_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Yo, ga bilanyamiyuyam gayŋan yolŋu yäku Barabatjnha gulŋiyan ga mala nhangu ḻinygu dhanal gayŋan mari-waythuwan Rawumbuywu gapmangu malaŋuwu. Ga waripunham warrany dhanal guwatharan waŋayumanan yana. ");
INSERT INTO dhg_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Manymak, dhanalim banha Djuw malam yolŋu warra ŋarranan bala ŋäŋꞌthuwanam Bäylitnham waŋganygun ḏapthumandawuywum yolŋuwu dhawaṯthumandawu, bitjuwayiŋ nhan bayiŋ gayŋarra ŋätjil bitjarra warkthuwarra. ");
INSERT INTO dhg_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Bala nhan Bäylitthum garruwanan bitjanan, “Yolnha ŋaya ŋarru dhawaṯthumanma? Nhämi dhaŋu banha Djuw-malawum yindinham buŋgawany?”. ");
INSERT INTO dhg_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ŋarru nhan banha Bäylitma ŋätjil yana marŋgiyin banha dhanal ŋurruŋu-ḏalkarramiyum warrayu gutjparruwanam nhanany Djesunham balayam nhanguḻim, ḻinygu dhanal gayŋan banha marimin yana maŋutji-ḏiyꞌyuwan nhanany. ");
INSERT INTO dhg_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ŋarru dhanalim banha ŋurruŋu-ḏalkarramiyum warrayu gayŋan dharꞌthar-wuŋanan yolŋunham warrany dhanal ŋarru Bäylitnham ŋäŋꞌthun Barabatjkun yana dhawaṯthundawum. ");
INSERT INTO dhg_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ga biyapul nhan Bäylitthu dhä-wirrkaꞌyuwan banha yolŋunham warrany, “Nhalpiyana ŋaya ŋarru dhaŋum gayꞌ yolŋuny, banha nhuma bayiŋ gayŋa rakaram be nhan yindi-buŋgawa Djuwwu yolŋuwu warrawu?”. ");
INSERT INTO dhg_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ga dhanalim bukmaknha yana garruwan yatjuwanan bitjanan, “Guwatharaŋan nhanany waŋayumun yana! Dhuḻ'yuwan nhanany mälakthumandawuyḻin ḏarpaḻi!” ");
INSERT INTO dhg_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ga nhanmam Bäylitma garruwan, “Nhä yulŋum? Nhä nhan nhumaliŋgu barrakinyma warkthuwan?” Ŋarru dhanalim banha mariminan yana yatjunminan garruwan, “Guwatharaŋun nhanany waŋayumun yana, dhuḻ'yuwan bitjan ḏarpaḻin!” ");
INSERT INTO dhg_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Bala nhanmam Bäylitma yoranan dhanaliŋgu, djäl-ŋuwatjumanan dhanaliny. Bala yana nhan Barabatjnham dhawaṯthumanan. Ga garruwan nhan Rawumbuywuḻim mariŋuwuḻ warrawuḻ bartjumandawun nhangu Djesuwum. Ga banha dhanal nhanguru bartjumandaŋurum goŋ-dhawarꞌyuwan bala nhan Bäylitma bitjanan garruwan mariŋuwuḻim, “Gatjuy warraṯthuwan warra nhanany bala dhuḻꞌyuwan nhanany mälakthundamiḻin ḏarpaḻi bala guŋnharruman banhambalayan, baya nhan ŋarru waŋayi.” ");
INSERT INTO dhg_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Dhurrwaraŋuru bewaḻiyam bala banha mariŋuyum warrayu ŋarran maŋutji-warruwanan Djesunham dhawaṯthumanan balan waripuḻin goḏuḻi. Ga guykuyyuwan dhanal waripuwu mariŋuwu warrawu malamiwun yana, guḻkun banha marimin yulŋum, balayan gayŋan dhawaṯthuwan. ");
INSERT INTO dhg_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ga ŋalthuman dhanal nhanguḻ djakaꞌ wikarra mikuꞌmi girriꞌ nhawun yindiwun buŋgawawu girriꞌ. Ga maḻŋꞌthuman dhanal ḏirriṯirri bala dhoṯkuwanan, djoŋguꞌkuwanan djäma, bala yana ṉiṉꞌthuman nhanguḻ muḻkurrḻin. ");
INSERT INTO dhg_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Bala dhanal gayŋan nhanany warkuꞌyuwanan bitjanan, “Dhaŋun nhan yindim buŋgawa, Djuwwu malawum!” bitjanan. ");
INSERT INTO dhg_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Bala dhanal gayŋan muḻkurrnha nhanany guwatharan ḏarpayun, ga dhupthuwan dhanal nhanany bala gayŋan warkuꞌyuwanan, bunꞌkumu-djipthuwanan nhanguḻ buku-ŋalꞌthuwanan manapan. ");
INSERT INTO dhg_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ga banha dhanal warkuꞌyundaŋurum dhawarꞌyuwan, bala dhanal yapthumanan nhanguḻ minyꞌtjimim girriꞌ bala nhinathuŋgan nhanguwaynha girriꞌ. Bala nhanany mariŋuyum warrayu gutjparruwanan dhawaṯthumanan, dhuḻyundawun mälakthumandaḻin ḏarpaḻi. ");
INSERT INTO dhg_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ga banha dhanal ŋarran gumurr-yawaṯthuwanam bewaḻim Djurutjalamŋurum bala dhanal gandarrŋam maḻŋꞌthuman yolŋunhan yäkuny Djäymannhan ŋirrima Djäriniwuynhan. Ga moriꞌmiŋum nhan banha dhupaliŋgu Yaliktjandawu ga Ropatjku. Bala yana dhanal nhanany barkan warruwan bala dharꞌthar-wuŋanan nhanany bayikuyan Djesuwurun ḏarpawun gutjparrundawu. ");
INSERT INTO dhg_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Bala dhanal waythuwanan banhalayam ŋirrimaŋa yäkuŋa Gulgatham, mayaliꞌ, ‘Muḻkurr Ŋaraka Ŋirrima’. ");
INSERT INTO dhg_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ga banhalayan dhanal Djesunham bitjuwayiŋ guŋan wiyikanꞌ borumnha maŋutji-manapanda mirritjinꞌ yäku merr, mä ŋarru bayiŋuyam ŋayamuṉuŋꞌkuman nhanany rumbalnha. Ŋarru nhanbayim banha Djesuyum ŋangawulnha wurkthuwan banhayam borum wiyikaꞌ. ");
INSERT INTO dhg_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Bala dhanal nhanany Djesunham dhuḻꞌyuwanan mälakthumandaḻin ḏarpaḻi. Bala ṉakanharamiŋganan banha ḏarpam, bala nhinathuŋganan. Ga walum banha goḏarrꞌmi yana, räyyu-waluyu. Bala gayŋan banha mariŋum warra wakalŋinan dopulunꞌ girriꞌwun nhanguru warraṯthundawu. ");
INSERT INTO dhg_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Bala dhanal dhäruknha wukirri banha nhäwuy dhanal nhanany bitjuwayiŋ dhä-girꞌyuwan, bala dhuḻꞌyuwanan banhayam ḏämbuḻin ḏarpaḻi, banha Djesu gayŋan goyuwan. Ga bitjan gayŋan banha barraŋgaꞌyuwanam, ");
INSERT INTO dhg_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ga bitjanya ḻinygu dhanal banha manaŋgannham ḏirramuny wulanynha ŋalthumanya, waŋganynham dhanal dhuḻꞌyuwan dhunupaꞌŋuḻ galiḻi nhanguḻ Djesuwuḻ, ga waŋganyma ga wiṉꞌkuŋuŋan galiꞌŋa. ");
INSERT INTO dhg_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Dhaŋum yän biliŋuwuynha wukirriwuynha God-Waŋarrwuran Dhuyuŋan Djorraꞌŋa bilanya gamꞌ, “Banham dhanal bitjanam nhanany rakaran, yana warri nhanmam barrakinynha, romnharran yolŋu.” ");
INSERT INTO dhg_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ga banha gayŋan yolŋu warra ŋaykan djuḻkthuman nhanany, ga ḏawaḏawaꞌyuwan dhanal gayŋan, warkuꞌyuwan manapan nhanany. Ga bitjan nhangu garruwan, “Wäy, be mu nhunum ŋarru dhaŋu ganitjumun ŋunham banha God-Waŋarrwum Dharrpalma Buṉbu, ga biyapul nhunu barkthu be dhuḻꞌyu ḻurrkunꞌthum waluyu? ");
INSERT INTO dhg_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Gu, wilak birrkaꞌyuwan yupthumanmiyan dhawuruya ḏarpaŋurum, mä ŋanapu ŋarru nhäma bala mä-wulitjin nhuŋgu, banha nhunu God-Waŋarrwum be gäthuꞌmiŋu?” ");
INSERT INTO dhg_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ga bitjanya ḻinygu dhanalim gayŋan banha ŋurruŋu-ḏalkarramiyum ga rom-marŋgikunhamiyum yolŋuyu warrayu warkuꞌyuwan nhanany Djesuny. Ga bitjan dhanal gayŋan garruwan gamꞌ, “Way, dhaŋu nhan gayŋan ŋunha waripuny yolŋuny warrany wälŋakuwan... ga ŋangawulnha nhan ŋarru dhaŋu nhanapinyaynham wälŋakunharami? ");
INSERT INTO dhg_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Dhaŋu nhan gayŋan ‘Maŋutji-yunupayumanda’ rakaranhamin, be God-Waŋarrwuŋ yängunhara ŋätjiliŋuwuy. Ga waripuyum yolŋuyu warrayu gayŋan rakaran be warri nhan dhaŋu Yindi Buŋgawa Djuwwu malawu. Ga banha gulitjma, nhan ŋarru yapthuna ḏarpaŋurum mä ŋalma ŋarru nhäma bala mä-wulitjtjin.” Ga burrpar ḏirramu wulay gayŋan banhalaya bitjuwayiŋ goyuwan rrambaŋi dhanal Djesu. Ga bitjanya ḻinygu dhupal gayŋan nhanany bitjuwayiŋ warkuꞌyuwan. ");
INSERT INTO dhg_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ga walum banha ḏämbuyun waluyu, ga munhayum banha bulukthuwanan warrpamꞌthuwanan banhayam ŋarakany waŋgalany, bitjuwayiŋ munhakun. Ga goyuwan gayŋan banha munham yanatj ḻinygu-u-u ga räy-wiluwan. ");
INSERT INTO dhg_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Bala nhan ŋunhalam Djesum yatjuwanan yänmurrun nhangurumurru Aram-murrun bitjanan, “Eloi, Eloi, lema sabachthani?” (mayaliꞌ, “God-Waŋarr nyäku, God-Waŋarr nyäku, nhäwu nhunu nyäku räy-nhinathuŋganminam?”) ");
INSERT INTO dhg_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ga banhalaya gayŋan yolŋu warra djingaꞌdjingaryuwan, ga ŋäkul dhanal banha Djesuny yatjunda. Bala dhanal bitjanan garruwan, “Way ŋäka warra! Ŋunham nhan gayŋa Yilaydjawun guykuyyun.” ");
INSERT INTO dhg_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Bala nhan waŋganyma yolŋu gätthuwanan bala yalŋgi gadharra warraṯthuwan bala borumḻin wiyikaꞌḻin ḻupthuman. Ga mamꞌthuman nhan ḏarpaḻi bala ŋarran garrwarkuwanan Djesuwuḻin, mä nhan ŋarru wurkthun banhaya wiyikaꞌ borum. Bala nhan bitjanan garruwan, “Bulnha ŋatjil ŋalma gäḻkuḻam ŋay, nhan bayan bayiŋ Yilaydja yarrupthu guŋgaꞌyundawu nhangu.” ");
INSERT INTO dhg_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Bala nhan Djesum mariminan yatjuwan, bala yana waŋayinan. ");
INSERT INTO dhg_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ga bilanyamiyu ḻinygu ŋunhalam Djurutjalamma nhanmam banha manydjarrkamꞌ God-Waŋarrwuram Dharrpalŋam Buṉbuŋa banha gayŋan galmuwan ŋunha dharrpalnhan goḏuny yolŋuwurun, banhayam bitjuwayiŋ yarrarꞌyuwanan, bewaḻi ḻinygu ḏämbuŋuru ga ḏupthuwan ŋunha ŋoyḻi, bala yana bärrkuwaḻyinan. ");
INSERT INTO dhg_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ga ŋunhalaya Gulgathaŋa gayŋan yolŋu dhäyan, ŋurru-warrundayŋu mariŋuwu warrawu, ga nhäŋal nhan gayŋan nhanany Djesuny bewaḻi ŋoyŋuru ḏarpaŋuru banha nhan milma bitjuwayiŋ waŋayinam. Bala nhan garruwanan, “Nhän way! Gulitj yana dhaŋum yolŋu God-Waŋarrwu Gäthuꞌmiŋu, ŋatja?” bitjanan. ");
INSERT INTO dhg_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Ga banhalaya gayŋan baṯami warra dhäya-dhayan, ŋarru mä bärrku. Ga banhayam baṯami warra bayiŋ gayŋarra Djesuwu malthuwarra, ga guŋgaꞌyuwarra nhanany ŋunhal Galali. Ga dhaŋuy warra banha yulŋum gamꞌ: Meri Magdalawuy, Djalumi, ga waripu Meri, ŋäṉḏiꞌmiŋu dhupaliŋgu gurrmulwu wulayku Djayimgu ga Djawutjipku, ga guḻku banha waripu bitjuwayiŋ baṯami warra banha dhanal ŋapawu malthuwan nhangu Djesuwu bala Djurutjalamḻi. ");
INSERT INTO dhg_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Yo, ga waŋayinam nhan banha Djesum waluyum Biraydin räy-wilundayun. Ga dhurrwaraŋuru bewaḻiyam bala nhan Djawutjipthum guyaŋinan nhan ŋarru Djesunham rumbal yapthumana bewaḻi mälakthumandaŋurum ḏarpaŋuru. Ga yolŋum nhan banha ŋirrima Yaramithiyawuy, ga ŋurrukŋurum nhan Djuwwuru ŋaḻapaḻmiwuru ŋärraꞌŋuru. Ga ŋuwakurru nhan banha yolŋum. Ga batjiwarr-nhäŋal nhan gayŋan banha God-Waŋarrwuru romgu-ŋarranharamiŋgandawun. Ga ŋärrun banha ŋarru waripum bitjuwayiŋ walu djaḏawꞌyun banhayam Djuwwun bäpurruwu Nyenanharamin Walu, nhanmam Djawtjipma ṉakaman, bala yana ŋarranan ŋayaŋu-mulkaꞌyinan Bäylitkuḻin bala garruwanan, “Nhalpiyan ŋaya ŋarru Djesunham rumbal warraṯthuna?” ");
INSERT INTO dhg_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Bala nhan banha Bäylitthum ganyimꞌthuwanan ŋäkul, bala bitjanan garruwan, “Nhä, ḻinygun nhan waŋayinan?” Bala nhan yän-wuŋanminan bayikuya mariŋuwurun buŋgawawu guwatjmandawu nhangu, ga dhä-wirrkaꞌyuwan nhan bitjan, “Nhän, gulitjnha nhan waŋayinam?” ");
INSERT INTO dhg_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Bala nhan banha mariŋuwurum buŋgawayu rakaran bitjanan, “Yuw, gulitjnha yana!” Bala nhan Bäylitthum dhayuŋganan Djesuwum rumbal Djawutjipkuḻin. ");
INSERT INTO dhg_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ga nhanmam Djawutjipthum wuŋiḻiꞌyuwan manydjarrkanꞌ rrupiya yindimin, ga balaya nhan ḏirruwan Gulgathaḻi Djesuwun rumbalwun warraṯthundawu beŋurun ḏarpaŋurun. Ga bayiŋuyan nhan manydjarrkaꞌyu nhanany garrpiyanam, bala dhanal gunhanan nhanany mathirraḻin, banhambalayan banha dhanal ŋätjilmiŋgan ŋangiꞌyuwan banhaya ṉutjurruny. Bala dhanal gaḻꞌkaḻumanan murrukaynha marimin ṉutjurrum, dhurrwarawum dhaḻꞌyundawu. ");
INSERT INTO dhg_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ga dhupalim banha Meri Magdalawuyma ga Meri Djawutjipkum ŋäṉḏiꞌmiŋu maŋutji-marŋgin wulay ŋalambal dhanal Djesuny bitjuwayiŋ märrkitjkuwan. ");
INSERT INTO dhg_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ga banha Djuwwu Nyenanharami Walu bitjuwayiŋ dhawarꞌyuwanam banham ŋunhuŋun yuṯuŋgurr-munhamiyun. Ga bewaḻiyam bala dhanalim Meri Magdalawuyma ga Djalumim ga Merim banha Djayimgum ŋäṉḏiꞌmiŋu ŋarranan buŋgan-bäwgun wuŋiḻiꞌyundawu mä dhanal ŋarru ŋuwatjuman yana goŋ-ŋuwatji nhangu rumbalma. ");
INSERT INTO dhg_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ga Djandin ŋarran djadawꞌyuwan, bala banha muṉgam ŋaykanan balayan mathirraḻin. ");
INSERT INTO dhg_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Ga banha dhanal ŋarran ŋaykanam bala batjiwarr-ŋupanam, bala dhanal garrunminan, “Yolthu ŋalmaliŋgu ŋarru ŋunha ṉutjurrum giṯthuman dhurrwaraŋurum? Murrukaynha ŋunha marimin yulŋum.” Ga banha dhanal waythuwanam ŋunhalayam bala nhäŋalan banha ṉutjurrum, galiꞌŋan gayŋan djingaryuwan. ");
INSERT INTO dhg_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ga gulŋiyan dhanal banhambalaya mathirraḻ bala nhäŋalam gurrmulnhan ḏirramuny girriꞌ lanyiŋminhan dhika, nyenan gayŋan. Ga mariminan dhanal banha ganyimꞌthuwanam. ");
INSERT INTO dhg_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ga bitjan nhan dhanaliŋgu garruwan, “Ŋangawul warra biyaṉiyiya. Dhaŋum nhuma gayŋa Djesuwu rumbalwum rangam ŋirrima-Nätjiritjpuywu banha dhanal nhanany guwatharan rakunyguwan. Ḻinygun nhanany banha God-Waŋarryum wälŋakuwanan rakunyŋurum, ŋangawulnha nhan dhaŋum. Nhäŋan warra, dhaŋun dharapulma banha dhanal märrkitjkum nhangu rumbal. ");
INSERT INTO dhg_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Maꞌ ḏirrun nhuma ŋarru balaya ga rakaraŋ nhanguru guyurrꞌmiŋuwum warrawu mä dhanal ŋarru ḏirruna Galaliḻin makaḻi. Ga bitja rakaraŋ banha nhanmam ŋarru ŋätjilin ŋarra, ga banha dhanal ŋarru waythum, ŋunhalayan dhanal ŋarru nhanany maḻŋꞌthumum. Ga rakaraŋ yana Betawuḻim. Yo, ḻinygu mu nhan Djesuyum banha ŋätjil dhanaliŋguḻ bitjanyam rakaran,” bitjan nhan gurrmulma garruwan. ");
INSERT INTO dhg_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ga nhäŋal dhanal banha muṉgayum dharapulma bala yana yän-mukthuwanan bala walmanan mathirraŋurum, bala yana gätthuwanan. Ga ŋangawulnha dhanal banha ŋunhuŋ yolkum dhäwum bitjuwayiŋ rakaran ḻinygu dhanal banha mariminan biyaṉiyinam. ");
INSERT INTO dhg_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ga Djandi goḏarr, djaḏawꞌyundamiyu waluyu nhan Djesum maŋutji-wuŋanminan Meri Magdalawuywuḻin. Djinakuḻiyan banha baṯamiwuḻ nhan Djesuyum walmanharamiŋgan djabinma barrakiny mala birrimbirr ŋätjilim. ");
INSERT INTO dhg_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Bala yana nhan Merim ŋarranan guyurrꞌmiŋuwun waythuwan, dhanal ŋarran ŋätjinyaramin. ");
INSERT INTO dhg_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Bala nhan Meriyum dhanaliŋguḻ rakaranan bitjanan, “Waraparra, Garrayma dhaŋu biyapul yawungu wälŋayi, ga ḻinygun dhaŋu ŋayam nhanany nhäŋalan.” Ga dhanalim bitjan garruwan ḻinygu dhanal mä-yulkthuwan nhanany, “Nhä nyin dhaŋu djinaŋum rakaram way!” ");
INSERT INTO dhg_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ga biyapulma nhan Djesu maŋutji-wuŋanmin burrparwuḻin guyurrꞌmiŋuwuḻ wulaykuḻ, banha dhupal ŋarran bala gätthuwan ḏiltjimurru. Ga waripuŋiyinan nhan banha rumbalma dhupaliŋguram maŋutjiŋa. Ga ŋärrun, dhupal nhanany banha dharaŋganam. ");
INSERT INTO dhg_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Bala dhupal ḏirruwanya balaya Djurutjalamḻi ga rakaran guyurrꞌmiŋuwuḻ warrawuḻ bitjanan, “Way, ŋäka warra! Ḻinygun dhaŋu ŋalinyum nhäŋalan nhanany Djesunham ŋunhalan batjiwarrŋan!” Ŋarru dhanalim banha ḻunduꞌmiŋum warra bitjan barraŋgaꞌyuwan, “Ŋangawul wulay djänguŋ.” ");
INSERT INTO dhg_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ga dhurrwaraŋuru bewaḻiyam bala nhan Djesum nhanapinyay nhan maŋutji-wuŋanminan 11-guḻin guyurrꞌmiŋuwuḻ warrawuḻ, dhanal ŋarran ŋatha guwaman. Bala nhan dhaykuwanan dhanaliny bitjanan, “Dhaŋu nhuma ŋayaŋu-wanyumi yolŋu warra. Ḻinygu gayŋan banha yolŋuyum warrayu nhumaliŋguḻ rakaran banha dhanal nhänany nhäŋal dhanaliŋguwaywuru maŋutjiyu, ŋarru nhumam ŋangawul dhanaliŋgu mä-wulitjtjin. Ga dhaŋum ŋaya ŋayapin nhumaliŋgu bitjuwayiŋ waythuwan. Gulitj yana ŋaya banha waŋayinam, ga biyapulya ŋaya dhaŋu bitjuwayiŋ wälŋayin. ");
INSERT INTO dhg_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Gatjuy maŋgarran warra ga rakaraŋan ŋuwakurrum dhäwu nyäkuruyma bukmakkuḻin yana yolŋuwuḻim warrawuḻ, ḏämbu-ḻiwꞌyuman ŋarra nyena dhaŋu munathaꞌŋa waŋgalaŋa. ");
INSERT INTO dhg_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ga bayiŋ nhan ŋarru ŋunhuŋ yol yolŋu mä-wulitjtjim nyäku, ga buku-ḻupma warraṯthun, nhanmam ŋarru God-Waŋarryum dhanaliny wälŋayumana. Ga bayiŋ nhan ŋarru ŋuyulktjim, ŋangawulma nyäku mä-wulitjtji nhananham ŋarru banhayam yolŋuny dhä-girꞌyuna bala ŋarru ḏupthuna warraŋulḻin djiwarrꞌŋurum. ");
INSERT INTO dhg_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ga banha ŋarru yolŋu warra gayŋa mä-wulitjtjim, dhanalim ŋarru gayŋa djämam ŋayaŋu-ṉirrundamin romma malany banha ŋarru gayŋa bayiŋuyam maŋutji-rakaram banha banhayam God-Waŋarrwun bitjuwayiŋ ganydjarr. Ga nhänanhan dhanal ŋarru gayŋa banha yäkum bitjuwayiŋ bäki wakinŋumiwum birrimbirrwu dhawaṯthumandawu. Ga garrunma dhanal ŋarru gayŋa banha waripun mulkurun yänma. ");
INSERT INTO dhg_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ga bayiŋ dhanal ŋarru ŋunhuŋ bäpiny ŋayathan, nhä wilak guwaman dhanal ŋarru botjinꞌ, dhanalim ŋarru banha ŋangawulnha rirrikthun. Ga goŋ-ŋalthun dhanal ŋarru rerrimiwuḻim yolŋuwuḻ, ga dhanalim ŋarru banha yana ḏukthuna.” ");
INSERT INTO dhg_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ga banha nhan gayŋan Djesu garruwanam guyurrꞌmiŋuwuḻim nhanguwaywuḻ, ga dhawarꞌyuwanam, bala nhan God-Waŋarryum warraṯthuwanan nhanany balan djiwarrꞌḻin. Ga ŋunhayan nhan yulŋum nyenam gayŋa God-Waŋarrwuran dhuṉḏayŋan yana galiꞌŋam, mä dhupal gayŋa ŋunha rrambaŋin bitjuwayiŋ djämam. ");
INSERT INTO dhg_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Bala dhanalim banha guyurrꞌmiŋuyum warrayu yänma nhanany warraṯthuwanan. Bala dhanal ŋarranan dhäwun banha Djesuwuruynha ŋuwakurrun rakaran ḏämbu-ḻiwꞌyumanan. Ga nhanmam God-Waŋarryum gayŋan guŋan dhanaliŋguḻ ganydjarrnha mä dhanal ŋarru gayŋa djämam ŋayaŋu-ganyimꞌthundamin rom, banhan nhan Djesuyu dhanaliŋgu rakaran. Ga guḻkun gayŋan banha yolŋum warra bitjuwayiŋ mä-wulitjmiyinam Djesuwum, ḻinygu dhanal dharaŋganan banha banhayam Ŋuwakurrum Dhäwu gulitjnha yana. ");
INSERT INTO dhg_vpl VALUES ("MK16_21","071_16_21","MRK","16","21","21","Ga banha dhanal banhaya ḻurrkunꞌ baṯami waythuwan bitjuwayiŋ Betawum ga guyurrꞌmiŋuwum warrawu, bala dhanal rakaranan dhanaliŋguḻ banhayany gurrmulnhan banha nhan gayŋan garruwan dhanaliŋgu ŋunhal mathirraŋa. ");
INSERT INTO dhg_vpl VALUES ("MK16_22","071_16_22","MRK","16","22","22","Ga dhurrwaraŋuru bewaḻiyam bala nhan Djesum yän-wuŋanminan nhanguwaywuru guyurrꞌmiŋuwum warrawu dhanal ŋarru banhayam Ŋuwakurrum Dhäwu nhanguruyma rakaraman ŋarra buku-ḻiwꞌyumana, djinal munathaꞌŋam waŋgalaŋa. Djinaŋum gayŋa dhäwuyu rakaram banha God-Waŋarryum ŋarru wälŋakuman yana yolŋunham warrany barrakinyŋurum romŋuru, mä dhanal ŋarru gayŋa nyenam nhanguran djiwarrꞌŋan wälŋa-dhawarꞌyundanharran. Dhaŋum Ŋuwakurru Dhäwu gulitjnha yana. Ga djinakun gämurruwu nhan dhaŋu bitjuwayiŋ dhawarꞌyundanharram dhäwu. ");
INSERT INTO dhg_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Ga banhalayam banha Bithiliyamma dhupalim Meriyum ga Djawutjipthum ŋangawulnha bitjuwayiŋ mungurrma ŋunhuŋ maḻŋ’thuman maḻŋ’thuman, bala dhupal banha gayŋiyinam ŋunhalan wäyinguran waŋgalaŋa banha gayŋan wäyingu mala ŋatha mala ŋalthunmin. Nyenanan dhupal ŋarran bala nhan Meriyum waŋgala-wuyaŋinan yothunham, ga garrpiyan nhan nhanany manydjarrka’yu, bala nhan nhanany yorrkuwanan banhambalayan mumumiḻin bala’palaḻi. ");
INSERT INTO dhg_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ga yaka wikarra, bilanyamiyuya ḻinygu munhayu ŋunhal bala mä galki nhawun yolŋu warra nyin ḏäpthuwan wäyingu bimbiwu dhanal gayŋan dharray. ");
INSERT INTO dhg_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Bitjanam yolŋu mala dhanaliŋgu waythuwan dhäwumi djiwarr’ŋuru bala gayŋan djingaryuwanan. Ga djarraṯawundhum dhanaliny banha monyguwanan bala dhanal biyaṉiyinan. ");
INSERT INTO dhg_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ga nhanmam banha dhäwumim bitjanan garruwan gam’, “Ŋangawul Ŋangawul warra biyaṉiyiya, dhaŋu ŋaya nhumaliŋgu dhäwu gutjparruwan ŋuwakurru,….nhumaliŋgu ga bukmakku yolŋuwu warrawu dhaŋu ḏämbu-ḻiw’yuman gayŋa nyena dhaŋu munatha’ŋa waŋgalaŋa. ");
INSERT INTO dhg_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","12","Dhaŋu djinaŋ djunama munhayu baṯamiyu waŋgala-wuyaŋin yothuny ŋunhaya Bithiliyam, ŋunhaya buŋgawawuḻ yäkuwuḻ Daybitkuḻ waŋgalaŋa. Gatjuy maŋgarran warra rangaŋan nhangu ga maḻŋ’thumanma nhuma ŋarru banha yothunham nhan ŋarru nyin gayŋiya garrwi’yunda manydjarrka’mi. Ga gayŋiyam nhan gayŋa banha wäyingura ŋathamiŋa bala’palaŋam. Bala nhuma ŋarru marŋgiyin banha dhaŋum dhäwu gulitjŋu yana. Nhännha ŋarru banha djinaŋuyan yolŋunham warrany wälŋakuŋ. Dhuwaniyan nhan banha Christ-ma Maŋutji-dhunupayumandam God-Waŋarrwuŋum dhawu’-nhinathuŋganda, dhaŋu nhan yänguwanan nhanany rälin nhan ŋarru nhumaliŋgu barka-warrundamin yolŋu.” ");
INSERT INTO dhg_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ga banha dhanal nhangu guyurr'miŋum warra bitjuwayiŋ ḏämbu-manapanminam bala dhanal Djesunham dhä-wirrka'yuwanan bitjanan, “Garray nhän?...dhaŋun banhayam walu banha nhunu ŋarru nhunupin bitjuwayiŋ buŋgawayi Yitjuralwum bäpurruwu?” ");
INSERT INTO dhg_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ga nhanmam Djesum dhanaliŋgu ḏämbu-ḏirrunmaran bitjan, “Nhanguway yana banhayam Bäniwu walu...ŋangawul dhaŋu nhumam ŋarru djinakuyam waluwu marŋgiyi. ");
INSERT INTO dhg_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ŋarru Dhuyu-Birrimbirrma ŋarru waythun nhumaliŋgu bala nhan ŋarru ganydjarrma nhumaliŋgu guŋana bala nhuma ŋarru ŋarra rakaraman yolŋuwum warrawu nyäkuruynha djinal Djurutjalam ga djinal Djudiya makaŋa waŋgalaŋa ga Djamariya waŋgalaŋa, ga biyapul nhuma ŋarru ŋarray buku-ḻiw'yumun djinal munatha'ŋam waŋgalaŋa bala nhuma barkthu ŋarray rakaraŋun yolŋuwuḻim warrawuḻ nyäkuruynha. ");
INSERT INTO dhg_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","10","Ga banha nhan Djesuyu rakaranam dhanaliŋgu bala nhan God-Waŋarryum warraṯthuwanan Djesunham garramaṯḻin. Bala dhanalim gayŋan banha guyurr'miŋuyum warrayu nhanguru nhäŋalan nhanany dhupuwanan nhan ŋarran bala dhawuṯthuwan. Bala yana waŋupinim maḻŋ'thuwanan bala djorkuwanan Djesunham ga ŋangawulnha banha dhanalim guyurr'miŋuyum warrayu nhanguru biyapulma nhanany nhäŋal. Ŋarru dhanalim gayŋan baḏaknha yana dhupuwan garramatḻim...ga bitjanam yolŋu wulay burrpar girri' watharrmi wulay djingaryuwanan gayŋan galkin yana dhanaliŋguḻ. ");
INSERT INTO dhg_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ga bitjanan dhupal banha garruwanam, “Nhuma yolŋu warra ŋirrima Galaliwuy warra,..nhäwu nhuma gayŋa dhaŋu dhupumam garramatḻim? Ḻinygun nhan ŋunha God-Waŋarryum warraṯthuwanan Djesunham djiwarr'ḻin, ŋarru nhan barkthu biyapulya bitjuwayiŋ ḏirru räli bitju yana ḻinygu banha nhalpiyan nhuma nhäŋal nhanay ŋarranharaḻi bala djiwarr'ḻi. ");
INSERT INTO dhg_vpl VALUES ("CL1_1","081_1_1","COL","1","1","1","Dhaŋum djorra nyäkuŋ Bolwuŋ banha ŋaya dhaŋu djarr'yunda God-Waŋarrwuŋ. Ga djarr'yuwanam nhan nhänany ŋaya ŋarru djuy'yundamin yolŋu nhangun Djesu-Christkun. Ga nhän mu dhaŋu waripum Dimithi wäwa'miŋu ŋalmaliŋgu Garraywurumi. ");
INSERT INTO dhg_vpl VALUES ("CL1_2","081_1_2","COL","1","2","2","Ga nhumaliŋgu ŋalinyu gayŋa dhaŋu yängumam Garraywurumiwu warrawu banha nhuma gayŋa nyena dhuwaniya ŋirrimaŋa yäkuŋa Gulutjay. Ŋaya gayŋa bukumiŋgan nhumaliŋgu mä nhan ŋarru God-Waŋarrma nhumaliŋgu maŋutji-wuyunna ga nyenam nhuma ŋarru gayŋa mägayayun romdhum. ");
INSERT INTO dhg_vpl VALUES ("CL1_3","081_1_3","COL","1","3","3","Banha ŋanapu bayiŋ manapanmim bala ŋanapu bayiŋ buku-guŋanma God-Waŋarrnham banha nhan bäpa'miŋu ŋalmaliŋguru Garraywu Djesu-Christku. ");
INSERT INTO dhg_vpl VALUES ("CL1_4","081_1_4","COL","1","4","4","Bilin ŋanapu dhaŋu dhäwum nhumaliŋguruy ŋäman banha nhuma gayŋa marimin yan mä-nhinathuŋganmi Djesu-Christkuḻim, ga djämam nhuma bayiŋ gayŋa ŋuwakurrun yana marimin guŋga'yunma ŋarra ŋunha God-Waŋarrwuruminham yolŋuny warrany bukmaknhan yan ŋayaŋuyum mä-ŋuwatjinyarayun. ");
INSERT INTO dhg_vpl VALUES ("CL1_5","081_1_5","COL","1","5","5","Ga nhä malany nhuma gayŋan banha ŋuwakurru dhäwu malany ŋäkul bitjuwayiŋ Djesuwuruyma, bayikuyam nhuma ŋarru gayŋa marimim gatjpu'yun, gäḻkuḻaŋan warra batjiwarr-nhäŋan bayikuyam banha ŋuwakurruwum malanyŋuwu banha gayŋa ŋoya ŋunha djiwarr'ŋa djägaŋa ŋuwakurruŋa.ss ");
INSERT INTO dhg_vpl VALUES ("JM1_1","089_1_1","JAS","1","1","1","Ŋayam dhaŋu Djayim, ga djämamim ŋaya dhaŋu yolŋu nhangu God-Waŋarrwu ga Garraywu Djesu-Christku. Yo, marrkapmi warra, wukirrim ŋaya gayŋa dhaŋu yänma nhumaliŋgu Djuw malawu 12-kun banha bäpurruwu, bayikun warrawu banha Godkurun yolŋuwum warrawu bukmakkun yana, banha nhuma gayŋan bärrkuwaḻyin waŋgalaḻi malaŋuḻi. ");
INSERT INTO dhg_vpl VALUES ("JM1_2","089_1_2","JAS","1","2","2","Wäwa ga yapa warra nyäku, yanan warra ŋoy-ŋuwatjiyan nyiniyam banha nhuma ŋarru ŋayaŋu-barrakinydjinyamiḻim romḻi gulŋiya, ");
INSERT INTO dhg_vpl VALUES ("JM1_3","089_1_3","JAS","1","3","3","ḻinygu bayiŋuyam ŋayaŋu-barrakinydjinyaramiyum romdhu gayŋa yana bitjuwayiŋ birrka'yun nhuna. Ga bayiŋ nhunu ŋarru gayŋa bitjan ḻinygu mä-wulitjmiyi Garraynham yana, ga ŋangawulma nhunu ŋarru nhanany mä-yuḻkthun, ga dhurrwaraŋuru bewaḻiyam banha, bala nhunum ŋarru gayŋa banhayam yänan bitjuwayiŋ ŋarra ŋayaŋu-wanyumurrum. ");
INSERT INTO dhg_vpl VALUES ("JM1_4","089_1_4","JAS","1","4","4","Yo, bitju ḻinygu gayŋi maŋgarram wawu yana banha ŋunhuŋ ŋalawitjanma rommurru, ga ŋangawulnha guluwa gandarrŋam ga gälkiyam, mä nhunum ŋarru rom-ŋuwatjin ga gana'yin nhangurum djämawu.''. ");
INSERT INTO dhg_vpl VALUES ("JM1_5","089_1_5","JAS","1","5","5","Yo. Ŋarru bayiŋ nhunu ŋarru gayŋa banha dhumbal'yunma, ga ŋangawulma nhunu marŋgi nhalpiyan nhunu ŋarru gayŋa banha djäma nhä wilak garrun banhalaya romŋa ŋayaŋu-barrakinydjinyamiŋurum, yana bukumiŋgan God-Waŋarrwuḻin Mori'wuḻin, ŋäŋ'thuwan nhanany bitjan gam', “God-Waŋarr Mori, nhalpiyan dhika ŋaya ŋarru yulŋum? Dhaŋu ŋaya gayŋa baḏak yana dhumbal'yun,” bitja ŋäŋ'thuwa, bala nhanmam ŋarru nhuna yana marŋgikuman. Bili God-Waŋarryum bayiŋ banha guŋan ŋunhuŋ nhäm mala mäyu-dhapinyayyun bukmakkun yana yolŋuwum warrawu, ŋangawulnha nhan ŋarru nhuŋu banha ŋuyulktjim. ");
INSERT INTO dhg_vpl VALUES ("JM1_6","089_1_6","JAS","1","6","6","Ŋarru ŋäŋ'thunma nhunu ŋarru banha God-Waŋarrnham waŋganydhun yana gämurru'yum, mä-wulitjtjinyarayun yana nhuŋguwaywuḻ nhunu, gatjpu'yuwan gayŋi warraṯthundawun yana. Ga bayiŋ nhunu ŋarru gayŋa banha guyaŋi mäyu-dhumbal'yundayum bitjanma gam', “Wilak nhan ŋarru dhaŋu guŋan nyäku, wilak ŋangawulnha baya,” bitjanma, 'Nhunum ŋarru banhayam ŋangawulnha warraṯthun ŋunhuŋ nhäm nhanguŋum Garraywuŋum. Ga banha nhan mä-wulitjinyanharram yolŋu banham nhan bilanyan bitjuwayiŋ banha ŋunhuŋ nhä banha bayiŋ gayŋa wakwakthun bala-räli garmakmurru, gutjparrun bayiŋ gayŋa watayu ga ḏowuyu galwaŋ'thuman bayiŋ bawalamin. ");
INSERT INTO dhg_vpl VALUES ("JM1_7","089_1_7","JAS","1","7","8","Yo, bilanyayam banha yolŋu ŋayaŋu-burrparnha, ḏämbu-yumuknha bilanyan bilanyan, ŋangawulnha nhan bayiŋ bayiŋ gayŋi banha ŋarray waŋganymurrum yana batjiwarrmurru mä-wulitjtjinyamurrum yana. Ga ŋangawulnha ŋarru bilanyayum yolŋuyu warraṯthun God-Waŋarrwuŋum ŋunhuŋ nhä malany. ");
INSERT INTO dhg_vpl VALUES ("JM1_9","089_1_9","JAS","1","9","9","Ga nhuma banha ŋurruwuykmi yolŋu warra Garraywalaŋumi, banha nhuma gayŋa dhuwaniya nyena gurrupuruŋumi, nhumam goŋmiyiyan, ḻinygu nhumam ŋarru banha ṉukunydja'yin God-Waŋarrwurun romdhu. ");
INSERT INTO dhg_vpl VALUES ("JM1_10","089_1_10","JAS","1","10","10","Ga nhumam banha ṉukutjam' yolŋu warra Garraywurumi, nhumam ŋarru gayŋa banyayam goŋmiyin nyena, bayatj nhan ŋarru gayŋa banha nhumaliŋguḻ God-Waŋarryum girrim' ga rrupiyam mala bitjuwayiŋ djalkthun nhumaliŋguru. Ḻinygu nhanmam ŋarru banha ṉukunydjam yolŋu waŋayin muŋbunuman, bitjanna bitjuwayiŋ bayiŋ banha wurrki' räwaktji bala ḻarryunna. ");
INSERT INTO dhg_vpl VALUES ("JM1_11","089_1_11","JAS","1","11","11","Yo, wurrkim' bayiŋ gayŋa banha mä-guṯi yana djingaryun ga banha bitjuwayiŋ ḏaykunma gorrmur'yi, bala bayiŋ banha wurrkim' räwaktjin, ga dhuṉḏaynha bayiŋ banha ḻarryunna yana; mä-guṯi yana nhan bayiŋ banha ŋuwatjumanma djingaryun Ga nhän ŋarru banha ṉukunydja' yolŋu bitjanya ḻinygu waŋayi, bilanyamiyu bili yana waluyu banha nhan ŋarru gayŋa ḻay-ḻayyun ŋunhuŋ nhäyu malanyŋuyu nhanguwaywuru nhan. ");
INSERT INTO dhg_vpl VALUES ("JM1_12","089_1_12","JAS","1","12","12","Yo. Bayiŋ nhunu ŋarru gayŋa banha bitjanma bili ŋarra wanyum yana bayitjanma banha marimurrum ga ŋayaŋu-barrakinytjinyamurrum, ga ŋangawulma bitjuwayiŋ nhunu ŋarru gulyun gandarrŋam, 'Nhunum ŋarru banyayam yana gayŋa ŋayaŋu-djulŋitjin, ḻinygu dhurrwaraŋuru bewaḻiyam banha nhan ŋarru God-Waŋarryum nhuna nhäŋum ŋayaŋu-ḏarrtjalknha ŋunhuŋ nhänharran bewaḻiyam banha birrka'yundaŋurum, nhanmam ŋarru nhuna guŋan gulitjnha yana wälŋa djeŋarra'min, banhayan wälŋa banha nhan ŋätjil wäwunguwan banhayany yolŋuny warrany banha dhanal bayiŋ gayŋa mäŋuwatji nhangu. ");
INSERT INTO dhg_vpl VALUES ("JM1_13","089_1_13","JAS","1","13","13","Yo, ga bayiŋ nhuna ŋarru ga banha guwaḻ-ṉirr'yuman ŋunhuŋ nhäyu romdhu, ga nhunum ŋangawul garruwa bitjam, “God-Waŋarryu dhaŋu guwaḻ-ṉirr'yuman nhänany djinakum barrakinygu.” Ŋangawul nhunum bitjaya garruwa garrun, ḻinygu God-Waŋarrma dhaŋu ŋuwakurru ŋangawul nhanany bayiŋ gayŋa banha ŋunhuŋ yolthum dharrwunuŋ ŋunhuŋ nhäwum mala barrakinykum djämawu ga nhän ŋarru God-Waŋarryu ŋangawul yolŋuny dharrwunum barrakinyḻi romḻi. ");
INSERT INTO dhg_vpl VALUES ("JM1_14","089_1_14","JAS","1","14","14","Ŋarru gulitjma bayiŋ banha yolŋunham dharrwunum bayiŋuya ḻinygu yana nhanguwaywuru nhan barrakinydhu djälyu, bayiŋuyan bayiŋ banha nhanany gaṯthumanma, bala nhan bayiŋ gälkin barrakinyḻ. ");
INSERT INTO dhg_vpl VALUES ("JM1_15","089_1_15","JAS","1","15","15","Ga banha nhan ŋarru gayŋa yolŋu bitjanma ḻinygu nhanguwayma nhan djälwu malthun, bewaḻiyam nhanguŋ guyaŋanhaŋuru djarrpi'ŋurum ŋarru walma ga barrakinynha yana, bala nhan ŋarru banha ŋärrun bitjuwayiŋ djäma barrakinyma, ga banha barrakinyma ŋarru ŋuthanna murrukayyin ŋayaŋuŋam nhanguḻ, yana ḻinygu-u-u, ga waŋayi nhan ŋarru nhanguwaywuru nhan barrakinydhu. ");
INSERT INTO dhg_vpl VALUES ("JM1_16","089_1_16","JAS","1","16","16","Marrkapmi warra nyäku wäwa ga yapa, ŋangawul warra mayali'-gutjparrunmiyam nhumalinhawuynham nhuma. ");
INSERT INTO dhg_vpl VALUES ("JM1_17","089_1_17","JAS","1","17","17","God-Waŋarryum bayiŋ gayŋa banha guŋan yolŋuwum warrawu ŋuwakurru yana nhä malany, ŋangawul nhan bayiŋ gayŋa guŋan barrakinyma. Ga nhä banha ŋuwakurrum mala gayŋa ŋoya, banhayam guŋanda nhanguŋ God-Waŋarrwuŋ, bayikuŋya Mori'wuŋ banha nhan djäma bukmak baḏayala' dhaŋu djiwarr'ŋa waŋgalaŋa banha bayiŋ gayŋa baḏayala'miŋgan dhaŋuny munathany' waŋgalany ga ŋangawulnha nhan banha bilanya bitjuwayiŋ wuŋiḻi' banha bayiŋ gayŋa yana mali'-maliyun. Ŋarru nhanbayim banha God-Waŋarrma bayiŋ gayŋa ŋangawulnha bilyun ga djambi; nhanbayim banha djambinharran. ");
INSERT INTO dhg_vpl VALUES ("JM1_18","089_1_18","JAS","1","18","18","God-Waŋarryum ŋalmaliny banha djarr'yuwan ŋalma ŋarru banha nhanguwaynha yana yolŋum warra bayitjanyan banha ŋalma warraṯthuwan yuṯan wälŋa nhangurumurrun gulitjmurrun yana dhäwu'murrum, bayikuḻ warrawuḻ banha waripuwuḻim yolŋuwal warrawuḻ, ŋurruŋun wal'ŋu banha waripuwuḻim wälŋamiwuḻ warrawuḻ banha nhan bokman. ");
INSERT INTO dhg_vpl VALUES ("JM1_19","089_1_19","JAS","1","19","19","Marrkapmi warra nyäku wäwa ga yapa, buthuru-bitjuwam God-Waŋarrwurum yängu ŋuwatjuma yana, rukitjtjiyan manapa, ga ŋangawul dhä-wapthuwa yänaya bondiŋuwum rakaranhawu marŋgikunharawu Bulnha ŋatjil maŋgarra gäḻkuḻaŋ ŋurruŋum ŋatjil nhunupi ŋarru gayŋa nyena banhalaya God-Waŋarrwuḻ yänŋa. Ga ŋangawul yänayam ŋaramurryiya ŋunhuŋ yolkum yolŋuwu, ");
INSERT INTO dhg_vpl VALUES ("JM1_20","089_1_20","JAS","1","20","20","bili ŋangawulnha nhunu ŋarru bayiŋuyam ŋaramurryum yändhu ga ŋayaŋuyu nhuŋguwaywuḻ nhunu galitjuman yolŋunham, mä dhanal ŋarru nyena dhuwurr-dhunupa God-Waŋarrwuḻ ŋuwakurruŋ romŋa. ");
INSERT INTO dhg_vpl VALUES ("JM1_21","089_1_21","JAS","1","21","21","Guŋnharruman ŋunhuŋ nhäm malany banha barrakinyma, bala djalkthuwan yana. Ŋangawulnha gayŋi bulum djäma ŋunhuŋ nhäm barrakinyma; yana nyilŋ'thummanmiyan nhunapinya nhunu God- Waŋarrwuḻin buthuru-bitjuwan nhangu bala warraṯthuwan banhayam dhärukma banha nhan nhinathuŋgan dhuwaniya nhuŋguḻ ŋayaŋuḻi, ḻinygu banhayam yän ganydjarrmi ganydjarr gayŋa gutjparrun wälŋakunharawu nhuŋu. ");
INSERT INTO dhg_vpl VALUES ("JM1_22","089_1_22","JAS","1","22","22","Yo, ŋäkam God-Waŋarrwum yän, bala djämamiŋgan yana banha nhalpiyan nhan gayŋa God-Waŋarr garrun nhuŋguḻ. Bayiŋ nhunu ŋarru gayŋa banha ŋäma guŋnharrumanma, banhayam bitjuwayiŋ nhunu gayŋa mayali'-wilkthunmin nhunapinyan nhunu. ");
INSERT INTO dhg_vpl VALUES ("JM1_23","089_1_23","JAS","1","23","23","Ga bayiŋ nhan ŋarru gayŋa yolŋuyu ŋäma gananma yana God-Waŋarrwum yän, ga ŋangawulma nhan ŋarru banha ŋunhuŋ djämamiŋganma, yängum malthun nhangum God-Waŋarrwum, banhayam nhan yolŋu bilanyan bitjuwayiŋ banha yolŋu bayiŋ gayŋa nhänharami giḻatjlil. ");
INSERT INTO dhg_vpl VALUES ("JM1_24","089_1_24","JAS","1","24","24","Yo, nhänharamim nhan bayiŋ banha, bala nhan bayiŋ ŋarran, ga dhuṉḏaynha nhan bayiŋ banha meṉgunharamin nhäyiny nhan banha yolŋu. ");
INSERT INTO dhg_vpl VALUES ("JM1_25","089_1_25","JAS","1","25","25","God-Waŋarrwum dhaŋu rom ḏarrtjalk ŋunhuŋ nhänharra yana, gulyuman bayiŋ gayŋa yolŋuny barrakinyŋuru romŋuru. Ga banha nhan ŋarru gayŋa yolŋu bulnha ŋatjil ŋarruŋ ŋunhi maŋgarra nhäma ŋatjil ŋarra marŋgiyi ŋatjil ŋarru ŋarra God-Waŋarrwuru romgu, ga ŋangawulma nhan ŋarru guŋnharruman, baḏak ŋarru ŋarra djäma bayiŋuya yändhu, bala nhanmam ŋarru God-Waŋarryum nhanany guŋana ŋuwakurrun ŋunhuŋ nhäm malany, ga bukmak banha nhanguŋum djämawuyma ŋarru ŋarra ŋuwatjin yana dhika. ");
INSERT INTO dhg_vpl VALUES ("JM1_26","089_1_26","JAS","1","26","26","Ga bayiŋ nhan ŋarru gayŋa yolŋu rakaranhami yanawarri nhan romgu malthundami ŋarru ŋangawul nhan bayiŋ gayŋa banha yänma nhanguway goli-nhinathuŋgu, banhayam nhan bayiŋ gayŋa baḏuwaḏuyunmin nhanapinyay nhan, ga nhäm mala nhan ŋarru gayŋa banha djäma, banhayam wakalnha yana waliwaliŋun. ");
INSERT INTO dhg_vpl VALUES ("JM1_27","089_1_27","JAS","1","27","27","Ga dhaŋun banha rom ŋamakurrum gam'; banha ŋarru gayŋa djäl-ŋuwatjuman God-Waŋarrnham Mori'nham, 'Nhunum yana warri ŋarru gayŋa banha nyenam dharrpalnha yana ga dhukunnharran. Ga guŋga'yunna nhunu ŋarru gayŋa banha dhurrwara ŋäṉḏinharraminham warrany ga ḏämbu-gurthapuynham baṯaminy warrany, ga ŋangawulnha gayŋi biyapulma warkthuwa barrakinyma rom banha djinakuwuyma banha munatha'wuyma. ");
INSERT INTO dhg_vpl VALUES ("JM2_1","089_2_1","JAS","2","1","1","Wäwa ga yapa warra nyäku, banha nhunu gayŋa mä-nhinathuŋganmi ŋalmaliŋguḻ Garraywuḻim Djesu-Christkuḻim banha nhan gayŋa nyena ŋunha djarraṯawun'miyi, ga ŋangawulnha nyamir'yuwam gänaŋ'thumam ŋunha waripuŋunham yolŋuny, ga ŋunha nhunu ŋarru gayŋa ŋurru-djarr'yun yana mä-ŋuwatji yol nhuŋguḻ ŋayaŋuŋa. ");
INSERT INTO dhg_vpl VALUES ("JM2_2","089_2_2","JAS","2","2","2","Bayiŋ nhuma ŋarru banha ḻuŋ'thumanmi waŋgany-manapanmi buku-ŋal'thundawum, ga bayiŋ ŋarru banha ṉukunydja' yolŋu gulŋiya girri'-ŋuwakurrumi ga goŋ-bulaymi nhumaliŋguḻ, ga bilanyamiyu bilanyamiyu nhan waripun yolŋu gulŋiya ŋurruwuyk'nha girri-räwakmin ");
INSERT INTO dhg_vpl VALUES ("JM2_3","089_2_3","JAS","2","3","4","Ga bayiŋ nhunu ŋarru banha garrun bayikuyam ṉukunydja'wum yolŋuwu bitjanna gam', “Go 'Nhunum djinal nyiniya ŋuwakurruŋa nhinanhawuyŋa,” bitjanna, ga bewaḻiyam nhunu ŋarru banha bilyun bala nhunu ŋarru banha ŋurruwuykkum yolŋuwu garrun bitjanna, Nhunum ŋunhal bala djingaryuwa wo wo djinal nyiniya ŋoyŋa ṉukuŋal nyäkuḻ bitjanma, banhayam bitjuwayiŋ nhunu gayŋa bärrkuwaḻyumana dhupaliny, ga guyaŋaŋinyaram banha nhuŋguŋ barrakinyma yana marimin ŋangawulnha dhunupa. ");
INSERT INTO dhg_vpl VALUES ("JM2_5","089_2_5","JAS","2","5","5","Yo, ŋäkam warra wäwa warra ga yapa warra ŋuwatjuman yana. God-Waŋarryum banha djarr'yuwanam ŋurruwuykminy mu dhawurum waŋgalaŋuru munatha'ŋurum, mä dhanalin ŋarru banha ṉukunydja'yim ŋunha mä-nhinathuŋganminyawuyŋam bala waṯaŋuyin ŋarru ŋunhukun banha nhangurun romgum ga waŋgalawum, banha nhan dhawu'-nhinathuŋgan banhayany warrany banha nhan bayiŋ gayŋa mä-ŋuwatji dhanaliŋgu. ");
INSERT INTO dhg_vpl VALUES ("JM2_6","089_2_6","JAS","2","6","6","Yo, nhumam gayŋan banha nyamir'yuwanatj nhäŋal ŋunha ŋurruwuykminham yolŋuny warrany. Gatjuy rakaraŋan; yolthu nhumaliny bayiŋ gayŋa banha rom-nyamir'yun, bala dhethuŋgana bayiŋ dharruŋguḻin? Dhanal mu banha ṉukunydja'yu yolŋuyu warrayu bayiŋ banha nhumaliny mariḻim dhethuŋgan. ");
INSERT INTO dhg_vpl VALUES ("JM2_7","089_2_7","JAS","2","7","7","Dhanalin bayiŋ gayŋa banha djinaŋuyan yolŋuyu warrayu warku'yunma nhanany Garraynham nhumaliŋgu. ");
INSERT INTO dhg_vpl VALUES ("JM2_8","089_2_8","JAS","2","8","8","Yo, ŋunha ŋätjiliŋuyum gayŋa djorra'yu rakaram bitjan, “Mä-ŋuwatjiya gayŋi waripuwum yolŋuwu warrawu bitju bitjuwayiŋ nhunu bayiŋ gayŋa mä-ŋuwatji nhuŋuwuy nhunu.” Ga bayiŋ nhunu ŋarru gayŋa banha bayikuyam yana yängu malthun banhayam bitjuwayiŋ nhunu gayŋa nyenan gulitjŋan banhalayan God-Waŋarrwuḻin romŋa. ");
INSERT INTO dhg_vpl VALUES ("JM2_9","089_2_9","JAS","2","9","9","Ga bayiŋ nhunu ŋarru gayŋa mä-ŋuwatji ŋurru-djarr'yunma yana, banhayam nhunu dhuwurr-barrakinytjinan ḻinygu nhanmam gayŋa ŋunha romma barraŋga'yun nhuŋu banha 'Nhunum rom-ganitjumandami. ");
INSERT INTO dhg_vpl VALUES ("JM2_10","089_2_10","JAS","2","10","10","Ga bayiŋ nhan ŋarru gayŋa yolŋuyu rom ŋayathan God-Waŋarrwum yana, ga bayiŋ nhan ŋarru banha bakthuman waŋgany ŋunhuŋ yutjuwaḻ rom banhayam nhan yolŋu ḻinygun rom-ganitjumandamin God-Waŋarrwuḻim maŋutjiŋa, ga bayiŋuyam gayŋa mayali'-rakaram banha nhan ḻinygun bakthumanan bukmakkuwanan yana banha God-Waŋarrwum rom mala. ");
INSERT INTO dhg_vpl VALUES ("JM2_11","089_2_11","JAS","2","11","11","Yo, God-Waŋarryum banha waŋgany yana romma nhinathuŋgan bilanya gam', gam', “Ŋangawul marramba'yiya,” ga waripum rom nhan nhinathuŋgan bilanya gam', “Ŋangawul guwatharaŋ murrkay'kuŋ yolŋuny.” Waripum wilak nhunu gayŋan banha nyenan nhuŋguwaywuḻ nhunu baṯamiwuḻ, nhä wilak ḏirramuwuḻ, ŋangawul gayŋan djäma marramba', ga bayiŋ nhunu ŋarru bitjuwayiŋ guwatharam yolŋuny murrkay'kuman, banhayam bitjuwayiŋ nhunu bilanyayam yolŋu rom-ganitjumandamin. ");
INSERT INTO dhg_vpl VALUES ("JM2_12","089_2_12","JAS","2","12","13","Yo, God-Waŋarrwurum mel-wuyundamiyu bayiŋ gayŋa banha djuḻkthumana dhä-gir'yundaminham romnha, mä ŋali ŋarru gayŋa banha gulitjtjumana yana mä-ŋuwatji yolŋuwum warrawu. Ga mala-djarr'yunma nhan ŋarru ŋalmaliny God-Waŋarryum bayiŋuya ḻinygu yana romdhum banha nhalpiyan ŋalma gayŋan märr-ŋuwatjin waripuwu yolŋuwu warrawu. God- Waŋarrma ŋarru banha ŋangawul maŋutji-wuyun bayikum yolŋuwu banha nhan ŋangawul bayiŋ gayŋa maŋutji-wuyun waripuwu bitjuwayiŋ yolŋuwu Ga bayiŋ nhunu yolŋu mel-wuyundami wiripuŋuwum yolŋuwu, ga nhanmam ŋarru banha bitjanya ḻinygu yana maŋutji-wuyunya God-Waŋarrma nhuŋgum; ŋangawulnha nhan ŋarru nhuna banha barrakiny-rakaramam ŋunhuŋ ga dhä-gir'yunma nhunany. Ga bayikuya gämurru'wu ŋaya gayŋa dhaŋu garrunma bitjanma gam'. Banha nhunu ŋarru garrunma, ga djämam ŋunhuŋ nhäm, garruwam gayŋi ga djämam banhaya ḻinygu yana banha nhä nhan bayiŋ gayŋa God- Waŋarryu manymak rakaram ");
INSERT INTO dhg_vpl VALUES ("JM2_14","089_2_14","JAS","2","14","14","Wäwa ga yapa warra nyäku, bayiŋ nhan ŋarru ŋunhuŋ yol yolŋu rakaranhami bitjanmi, “Ŋayam bayiŋ gayŋa dhaŋu mä-wulitjmiyi God-Waŋarrwu,” bitjanma, ŋarru ŋangawulnha nhan bayiŋ banha djämamiŋganma banha yänma nhanguway nhan, nhä banhayam? … ŋuwakurru? Ŋangawul Ŋangawulnha nhan ŋarru banhayam yolŋu wälŋayi bilanyayum mä-wulitjtjinyayu. ");
INSERT INTO dhg_vpl VALUES ("JM2_15","089_2_15","JAS","2","15","15","Bayiŋ nhan ŋarru gayŋa Garraywurumi yolŋu nyena gurrupuruŋum, ŋathanharram ŋunhuŋ nhänharram, girri'nharram, ");
INSERT INTO dhg_vpl VALUES ("JM2_16","089_2_16","JAS","2","16","16","ga 'Nhunum ŋarru nhangu garrun bitjanna, “God-Waŋarryu nhuna ŋarru guŋga'yun. Nyenayim gayŋi marrparaŋdji, ga guwama ŋarra maranhuyiya,” ga bayiŋ nhunu ŋarru garrun bitjanyam, ga ŋangawulma nhunu ŋarru guŋan nhangu ŋunhuŋ nhä, nhä dhuwaniyam? … ŋuwakurru? Ŋangawul ");
INSERT INTO dhg_vpl VALUES ("JM2_17","089_2_17","JAS","2","17","17","Ga bayiŋ nhunu ŋarru gayŋa muḻkurryum yana waŋganydhum mä-wulitjmiyi ga ŋangawulma djäma ŋunhuŋ nhäm ŋuwakurrum, bitjuwayiŋ milkumam nhuŋguway nhunu mä-wulitjtjinyaram, banhayam bitjuwayiŋ nhuŋu mä-wulitjtjinyaram wakalnha, ŋangawulnha gulitj; ŋangawulnha ŋarru banha bilanyayum mä-wulitjtjinyarayu wälŋakum ŋunhuŋ yolnha yolŋuny ");
INSERT INTO dhg_vpl VALUES ("JM2_18","089_2_18","JAS","2","18","18","Waripum wilak ŋarru banha yolŋu bitjanna garrun, “Waripum bayiŋ gayŋa banha yolŋu mä-nhinathuŋganmin yana, ga waripuŋuyum yolŋuyu bayiŋ gayŋa warkthun ŋuwakurrun rom, ŋarru burrparyi yana banha ŋuwakurru yana wulanynha,” bitjan. Ŋarru ŋayam ŋarru ḏämbu-ḏirruman dhanaliŋgum bitjanna, “Ŋalawitjan dhika ŋayam ŋarru gayŋa nhäma nhuŋgum bitjuwayiŋ mä-nhinathuŋganda, bayiŋ nhunu ŋarru gayŋa ŋangawulma warkthun ŋunhuŋ nhäm ŋuwakurrum?” Ŋarru 'Nhunum yana warri ŋarru banha nhäman nhänany ŋuwakurruḻim djämaḻi, bala nhunu ŋarru banha dharaŋgana banha ŋayam gayŋa dhaŋu gulitj yana mä-wulitjmiyi God-Waŋarrwum. ");
INSERT INTO dhg_vpl VALUES ("JM2_19","089_2_19","JAS","2","19","19","'Nhunum gayŋa ŋunhuŋ mä-wulitjmiyi mu banha nhanbayin dhaŋu waŋganynha yana God-Waŋarrma? Yo, banhayam ŋuwakurru. Ga dhanalim banha wakinŋum mala birrimbirr marŋgiya banha nhanbay yana dhaŋu waŋganynha yana God-Waŋarrma, bala dhanal bayiŋ gayŋa ŋunha biyaṉiyin mariminan yan, marrmarryuna ŋarru ŋarra manapan nhangu God-Waŋarrwum, ŋarru ŋangawul yana dhanal ŋarru wälŋayim bayiŋum banha dhanaliŋguwaywurum guyaŋinyarayu. ");
INSERT INTO dhg_vpl VALUES ("JM2_20","089_2_20","JAS","2","20","20","Nhä nhunu dhaŋu muḻkurrnharra? Ŋaya nhuna marŋgi-wuŋan. Banha nhan ŋarru gayŋa yolŋu mä-wulitjmiyi God-Waŋarrwum, ŋarru ŋangawulnha nhan bayiŋ gayŋi banha djäma ŋuwakurrum, bayikuyam yolŋuwu mä-nhinathuŋganda ŋunhuŋ nhän, nhäŋiniŋ'nha, rakunynha. Ŋangawulnha nhan ŋarru wälŋayi bilanyayum märr-nhinathuŋganminyawuyyu. ");
INSERT INTO dhg_vpl VALUES ("JM2_21","089_2_21","JAS","2","21","21","Nhäwuy nhan banha God-Waŋarryu ŋayaŋu-dhunupam rakaran ŋalmaliŋgum mala-ŋurrkanhayŋuny Yipurayimnhan Yipurayimdhum banha yän-warraṯthuwan God-Waŋarrnham, bala yana nhan guŋanan nhanguway nhan gäthu'miŋunham Yitjaknham God-Waŋarrwun, yana warri nhanany nhan guwathararra rakunyguwarra banhalaya ŋal'-ŋalyumandawuyŋa ṉutjurruŋa, mundhurr guŋana nhangu God-Waŋarrwu. Ga nhanmam God-Waŋarryum nhäŋal nhanany Yipurayimnham, bala nhan marŋgiyinan yana dharaŋganan banha nhanmam gulitjuman yana mä-nhinathuŋganmin God-Waŋarrwuḻ, ḻinygu nhan banha djäma banhaya ḻinygu yana dharaŋanda, banha nhalpiyan nhan God-Waŋarr nhanguḻ garruwan. ");
INSERT INTO dhg_vpl VALUES ("JM2_22","089_2_22","JAS","2","22","22","Guyaŋiya ŋatjil, bala marŋgiyiyan. Yipurayimguny mä-nhinathuŋganda gayŋa djäma waŋganyŋa yana. Gulitjuman yana nhan banha märr-nhinathuŋganmin God-Waŋarrwuḻim, bala nhan gayŋan djämam banhayan bili yana banha nhalpiyan nhan God-Waŋarryu rakaran nhanguḻ. Ŋangawul nhan nhanany banha mä-wulitjmiyinam yana, ga ḻinygun, banham nhan djämamiŋganan nhangu yänma ");
INSERT INTO dhg_vpl VALUES ("JM2_23","089_2_23","JAS","2","23","23","God-Waŋarryum ḻinygun banha yänma nhinathuŋgandan banha gayŋa garrun bitjanna gam', Yipurayim gayŋan banha mä-nhinathuŋganmin God-Waŋarrwuḻ, bala nhan yana nhanany ŋayaŋu-dhuṉḏaynha rakaran, banhayam nhan bitjuwayiŋ mämiyinan nhangu Ga djinakuyan banha gämurru'wu nhanmam nhanany banha God-Waŋarryum rakaran bitjanan, ‘Ḻundun nhan nhangu God-Waŋarrwun.’ ");
INSERT INTO dhg_vpl VALUES ("JM2_24","089_2_24","JAS","2","24","24","Yo, ḻinygun nhunu dhuwan nhäŋalan dharaŋganan? Bayiŋ nhunu ŋarru gayŋa banha yän warraṯthun God-Waŋarrnham, ga djämam nhunu ŋarru gayŋa ŋuwaḻyumanma yana, bala nhanmam ŋarru God-Waŋarryum nhuna ŋayaŋu-dhuṉḏaynha rakaraŋ ga bayiŋ nhunu ŋarru gayŋa garrun yänma yana waŋganyma bitjanma, Ŋayam gayŋa dhaŋu gulitjuman yana mä-wulitjtji God- Waŋarrwum nhanmam ŋarru God-Waŋarryum nhuna ŋangawul yänayam ŋayaŋu-dhunupa rakaram. ");
INSERT INTO dhg_vpl VALUES ("JM2_25","089_2_25","JAS","2","25","25","Yo, guyaŋiya ŋatjil balaya ḏirruwa banhaya dhuwurr-barrakinynha baṯaminy yäkuny Rayapnha, banha nhan gayŋan nyenan be baman' ŋätjil. Nhanmam banhayam gumurr-ŋuwatjin yolŋuwu wäŋa-Yitjuralpuywu dhäwu-gutjparrundamiwu wulayku nhanguwaywuḻ nhan ŋirrimaḻi. Ga dhanalim warri waripuyum yolŋuyu warrayu guwatharan banhaya dhäwuminy wulanynha, ŋarru bayiŋuyan baṯamiyun guŋga'yuwan djuḻuḻ'yumanan bitjuwayiŋ dhupaliny bala wälŋakuwanan, bala nhan djuy'yuwanan dhupalim waripuŋumurrun batjiwarrmurru. Ga nhanmam God-Waŋarryum nhäŋal nhanany banha baṯaminham, nhalpiyan nhan gayŋan banha djäma ŋuwatjuman bilanyamiyuya, bala nhan God-Waŋarryum nhanany ŋayaŋu-dhunupan rakaran ");
INSERT INTO dhg_vpl VALUES ("JM2_26","089_2_26","JAS","2","26","26","Yo. Bayiŋ ŋarru banha yolŋum waŋayi, ga birrimbirryum nhanguḻ baykuḻ yolŋuwuḻ ŋarru guŋnharrumana nhanany, ga banhayanham rumbalma nhangu ŋarru gayŋa ŋoyan yana wälŋanharran. Ga bilanya bili yana dhaŋu ŋalmaliŋgum Garraywurumiwum yolŋuwu warrawu. Bayiŋ nhan ŋarru banha yolŋu garrun bitjanma gam', “Ŋayam gayŋa dhaŋu mä-nhinadhuŋganmi God-Waŋarrwuḻ yana,” bitjanma, ga ŋangawul bitjuwayiŋ nhan ŋarru gayŋa djämam ŋuwakurrum bayiŋuyam yolŋuyu, bayikuyam yolŋuwu mä-wulitjtjinyaram rakunynha, ŋangawulnha nhan ŋarru banha ŋunhuŋ yolma yolŋu wälŋayi bilanyayum mä-wulitjtjinyayu. ");
INSERT INTO dhg_vpl VALUES ("JM3_1","089_3_1","JAS","3","1","1","Wäwa ga yapa warra nyäku, ŋangawul ŋalma ŋarru gayŋa banha bukmak bitjuwayiŋ djälmiyi marŋgikunhawum ḻinygu marŋgikunhamiwum yolŋuwu warrawu gayŋa dhaŋu dhä-gir'yunda ŋoya murrukay marimi ");
INSERT INTO dhg_vpl VALUES ("JM3_2","089_3_2","JAS","3","2","2","Ga waripum ŋali bayiŋ bukmakthu yolŋuyu warrayu baḏatjtjun bitjuwayiŋ, bala ŋali bayiŋ gälkin. Ga bayiŋ nhan ŋarru ŋunhuŋ yol yolŋu gulunmaranhami ; ŋatjil nhanapinya nhan ŋäṉarr dhaŋu, ga ŋangawul nhan ŋarru garrun ŋunhuŋ waŋgany barrakiny yän ga banhayam nhan yolŋu rom-dhunupan ḻinygun; ga bitjanya ḻinygu nhan ŋarru banha bukmak yana nhanapinyay nhan rumbalma ḏaḏawyumanmi barrakinyŋurum mala. ");
INSERT INTO dhg_vpl VALUES ("JM3_3","089_3_3","JAS","3","3","3","Ga nhäŋa ŋatjil dhaŋu yän gam'. Banha nhan bayiŋ ŋarra yolŋu ŋalthun yarraman'ŋa, ŋurruŋum ŋatjil nhan ŋarru bayiŋuyam yolŋuyu nhinathuŋgan yutjuwaḻ djimuku' dhurrwaraḻi baykuḻ yarraman'kuḻ. Ga banha nhan ŋarru gayŋa gutjparrun banhaya yarraman'nha dhurrwara-bayikumiyuyam girri'miny, nhanmam ŋarru ŋarra bayiŋuya yutjuwaḻyum girri'yu ŋanydja'-ŋanydjaḻayuman banhaya yarraman'nha, nhäḻi nhan ŋarru banha yolŋu djälmiyi ŋarranhawu nhangu bayikuya yarraman'ku. ");
INSERT INTO dhg_vpl VALUES ("JM3_4","089_3_4","JAS","3","4","4","Guyaŋiya ŋatjil marthaŋaynha bilanyaya ḻinygu murrukay marimi. Banha bayiŋ gayŋa watayu murrukayyu nhanany gutjparrun bala räli ŋarru bilanyayu bili yana yutjuwaḻyu girri'yu yäkuyu goliyu nhan bayiŋ yolŋuyu marthaŋay-gutjparrundamiyu ŋarra bilu'biluman banhayany marthaŋaynha, banha nhäḻi nhan bayiŋ gayŋa yolŋu bitjuwayiŋ djälmiyi ŋarranharawu. ");
INSERT INTO dhg_vpl VALUES ("JM3_5","089_3_5","JAS","3","5","5","Ga bilanyaya ḻinygu banha yolŋuwum ŋäṉarr dhaŋu; yutjuwaḻ marimi nhan rumbalma, ŋarru ganydjarrmin. Nhanmam bayiŋ gayŋa banha bayiŋuyam ŋäṉarryuny djämam murrukaynha mariminan yänma bulwata-nhinathuŋgana bayiŋ ŋarra. Gatjuy guyaŋiya ŋatjil warra. Banha nhan bayiŋ yutjuwaḻma ŋorrtja ŋäṉarrma guwarun birrŋ'thuna ga guwarunma nhan bayiŋ banha gunguyuyumana warrpam'thuna dhika, bawalamin darpam malany. ");
INSERT INTO dhg_vpl VALUES ("JM3_6","089_3_6","JAS","3","6","6","Yo. Ga yolŋuwum dhaŋu ŋäṉarr dhaŋu ŋupandayŋu yana bitjuwayiŋ banhaya ŋorrtja. Yo, yolŋuwum dhuwal rumbal guḻku marimi marimi, bilanya bitjuwayiŋ maŋutji, ŋurru, ga buthuru ga dhikan nhän malany. Ŋarru ŋäṉarrma dhaŋu marimin yana barrakinynha; djinaŋuyan bayiŋ gayŋa banha bukmaknhan rumbalnham barrakinydjumana, ga bayiŋuyan bitjuwayiŋ bayiŋ gayŋa banha baḏuwaḏuyunma bawalamin, ḻinygu banhayam barrakinyma yän ŋorrtjayinyaram bayiŋ gayŋa banha walmam dhawaṯthun bewaḻin yana dhä-gir'yundamiŋurun waŋgalaŋaŋuru. ");
INSERT INTO dhg_vpl VALUES ("JM3_7","089_3_7","JAS","3","7","7","Yo, yolŋum dhaŋu marŋgi nhalpiyan nhan ŋarru maŋutji-wuṯtji'yuman wäyinnha mala ŋarranharaminy ga buṯthundaminy ga gaḻundaminy, ga ŋunha banha ŋarirriny malaŋuny ga miyapununy; yolŋuyu gayŋa ganydjarr ŋayathan mä nhan ŋarru gayŋa yal'yuman nhä malany ");
INSERT INTO dhg_vpl VALUES ("JM3_8","089_3_8","JAS","3","8","8","Ŋarru ŋangawulnha nhan gayŋi ŋunhuŋ yolthu waŋganydhu ŋayathu ganydjarr gulyumanda bayikuya nhanguwaywuru nhan ŋäṉarrwum. Yolŋum dhaŋu ŋäṉarr barrakiny yana marimi, bilanya bitjuwayiŋ banha girri' walŋa-wulk botjin'; ŋangawul nhan ŋarru gulumaranhami garrundaŋuru barrakinyŋuru. ");
INSERT INTO dhg_vpl VALUES ("JM3_9","089_3_9","JAS","3","9","10","Yo, ḻundu warra marrkapmi warra, djinaŋ mu banha ŋäṉarryum ŋalmaliŋguḻ ŋalma bayiŋ ga garrun wokthun ga märr-yiŋgatji ŋalmaliŋguru Garraywun ga God-Waŋarrwun Moriwun. Ga djinaŋuya bili yana ŋäṉarryu ŋalma bayiŋ gayŋa banha dhä-yarrkthun nyamir'yun ŋunha waripuny yolŋuny, banha nhan bilanyaya mu ḻinygu yana dharaŋanda birrimbirrmi bitjuwayiŋ nhanbay yana God-Waŋarrnha, ga dhuwaniyam ŋangawulnha ŋuwakurru. ");
INSERT INTO dhg_vpl VALUES ("JM3_11","089_3_11","JAS","3","11","11","Nhäyiny nhunu bayiŋ banha maŋutjiŋurum garmak maḻŋ'thuman waluyu rarranhdharrwirriyum? Raypiny wo dhäkay-murrkthunda? ");
INSERT INTO dhg_vpl VALUES ("JM3_12","089_3_12","JAS","3","12","12","Yo, ga ŋunhuŋ nhunu bayiŋ wuḻuymuŋ'ku dhakal warraṯthun bewaḻi munydjutjŋuru ḏarpaŋuru? Ga ŋunhuŋ nhunu bayiŋ raypinyma garmak warraṯthun, bewaḻi moṉukŋuru garmakŋuru? ");
INSERT INTO dhg_vpl VALUES ("JM3_13","089_3_13","JAS","3","13","13","Ŋunhuŋ gayŋa yol yolŋu nyena djinal nhumaliŋgura malaŋa banha nhan marŋgi marimi ḻiya-djambatjnha wal'ŋu Godkurum romgu? Gatjuy maŋutji-wuŋan dhuwaniya romnham banha nhunu ŋarru gayŋa nyenam ga djämam ŋuwatjuman yana ga dhuṉḏaynha, ŋayaŋuyum nyilŋ'thumandamiyun ga djambatjthun guyaŋinyarayu. ");
INSERT INTO dhg_vpl VALUES ("JM3_14","089_3_14","JAS","3","14","14","Ga bayiŋ nhuŋguḻ gayŋa banha ŋayaŋuŋa ŋoya maŋutji-ḏiy'ma yana gayŋa ŋanak-barrakinydjuman yana nhunu ŋarru gayŋa nyena, ga guyaŋinyami nhunu ŋarru gayŋa nhunapinya nhunu, ŋangawulnha gayŋi djängumam rakaraŋ guḻu'-guḻukthunmiyam yana gayŋi ŋapa-dhurrthurryum banha gulitjnham romnha. ");
INSERT INTO dhg_vpl VALUES ("JM3_15","089_3_15","JAS","3","15","15","Ga bilanyayam banha djambatj-guyaŋinyara ŋangawulnha God-Waŋarrwuŋum, bili bilanyayam banha batjiwarr ga rom djinakuwuy bayma yana munatha'wuy, dhawaṯthun bayiŋ gayŋa yolŋuwuŋun guyaŋinyara, ŋurukuŋun banha buŋgawawuŋun, Waŋawuŋun guŋanda. ");
INSERT INTO dhg_vpl VALUES ("JM3_16","089_3_16","JAS","3","16","16","Ga bayiŋ gayŋa banha nhuŋguḻ maŋutji-ḏiy'ma ŋoya ga galŋa-wanyuyinyaramim rom, bala ŋarru gayŋa banha ŋayaŋuŋurum nhuŋguḻ walma marin, bala ŋarru gayŋa banha yolŋum warra guwatharanhamin bärrkuwaḻyumanmin ga gurruṯunharrayin. ");
INSERT INTO dhg_vpl VALUES ("JM3_17","089_3_17","JAS","3","17","17","Ga nhangum banha God-Waŋarrwum djambatjma-guyaŋinyara bewaḻi djiwarr'ŋurum, nhan ŋarru gayŋa gutjparrun ŋalmaliny ḏarrtjalkkuman yana ŋunhuŋ nhänharrayumana, ga mägayan ga mä-yolŋumin ga ŋayaŋum gurrum'nha ga guŋga'yundamin, ga gulitjnha yana. ");
INSERT INTO dhg_vpl VALUES ("JM3_18","089_3_18","JAS","3","18","18","Yo, ga banhayam yolŋu warra banha dhanal bayiŋ gayŋa djälmiyi waripuwu yolŋuwu dhanaliŋgu dhanal ŋarru gayŋa nyena mäwayaŋan/betjŋan yana, bilanyayun ŋarru gayŋa banha yolŋuyu warra djäma ŋuwaḻyumana yana. Ga bayiŋuyam djämayu dhanaliŋguru ŋarru banha yolŋum warra dhuwurr-dhunupayin. ");
INSERT INTO dhg_vpl VALUES ("JM4_1","089_4_1","JAS","4","1","1","Wäy, nhäwu mu nhuma bayiŋ gayŋa banha dhaŋu yolŋum warra guwatharanhami ga dhaykunharami bala-räli'yunmim? Yo, gulitj mu nhuma bayiŋ gayŋa banha bitjanyam, bili ŋunha ŋayaŋum nhumaliŋgu bayiŋ gayŋa banha guwatharanhami yana, marin bayiŋ gayŋa djingar'yun, bili djinaŋuyan banha wanaŋa-ḏokundjinyamiyun romdhu gayŋa djäl-gänaŋumiyun romdhu, bala rumbalyum bayiŋ gayŋa banha nhumaliŋguḻ djämamiŋgana. ");
INSERT INTO dhg_vpl VALUES ("JM4_2","089_4_2","JAS","4","2","2","Djälmiyi mu nhuma bayiŋ ga banha marimi yana ŋunhuŋ nhäwum malaŋuwu, ŋarru ŋangawulnha nhanmam ŋarru nhuŋu wekam bayiŋuyan waripuŋuyun yolŋuyu, bala nhumam bayiŋ dhuṉḏaynha yana ŋaramurryirra nhangu, bala yana guwathanharawun nhangu djälmiyi murrkay'kunharawun. Waripum nhuma bayiŋ ga banha ŋangawulnha bukumirriyaŋ bayikuya malaŋuwu banha nhäwu nhuma bayiŋ ga djälmiyi. Ga djinaŋuyan banha ŋurruynydja nhuma bayiŋ gayŋi ŋangawulma warraṯthu banhayam mala. ");
INSERT INTO dhg_vpl VALUES ("JM4_3","089_4_3","JAS","4","3","3","Waripum nhuma bayiŋ ga banha nhanany God-Waŋarrnha ŋäŋ'thun mu, ŋarru guyaŋim nhuma bayiŋ ga djarrpi'kum yana; nhumam djäl nhumaliŋguru nhuma ŋayaŋu-djulŋitjinyaraw nyenanhawu, ga ŋangawulnha nhuma bayiŋ gayŋi guyaŋi ŋunha waripuŋunham yolŋuny guŋga'yundawu. Yo, bilanyayum guyaŋinyarayu djarrpi'kunharayum nhuma bayiŋ bitjuwayiŋ ŋäŋ'thun God-Waŋarrnha, ga bayiŋuyam ŋurruyu nhumam bayiŋ banha ŋangawulnha bitjuwayiŋ warraṯthum God-Waŋarrwuŋum. ");
INSERT INTO dhg_vpl VALUES ("JM4_4","089_4_4","JAS","4","4","4","Ŋangawul yana nhuma dhuwal ŋangawul nhuma dhaŋu yana marŋgim ŋatja? Banha nhuma bayiŋ ga marrkapthun djinakuwuywum yana banha munatha'wuywuny nhäwu malaŋuwu, banhayam bitjuwayiŋ nhunu God-Waŋarrwun miriŋu. Ga bayiŋ bitjuwayiŋ nhe ga guyaŋi ḻunduthinyarawnydja dhiyakun munathawny'tja wäŋaw, banhayam nhuma gulitjnha yana God-Waŋarrwun miriŋuny. ");
INSERT INTO dhg_vpl VALUES ("JM4_5","089_4_5","JAS","4","5","5","Nhalpiyan nhe bayiŋ ga banha dhärukma ŋunha Ŋäthiliŋuŋurnydja Djorra'ŋa ŋäma mä-yuḻkthun mu? Banha ga rakaraŋ bitjan gam', “God-Waŋarrma bayiŋ ga marimi yana marraṉa'yirr nhanukiyingalaŋuwnydja nhan Birrimbirr banha nhan nhinadhuŋgan ŋalmaliŋguḻ,” bitjanma. ");
INSERT INTO dhg_vpl VALUES ("JM4_6","089_4_6","JAS","4","6","6","Bili gulitjma nhangu banha God-Waŋarrwum mä-ŋuwatjinyara ga guŋga'yunawuy ŋalmaliŋgum biyapulnha murrukay, djuḻkthuman ga ganydjarrma bayikuya malaŋuwu banha djälwuny ŋalmaliŋguru. Ga bilanyawun banha ŋayaŋuw nhan ga ŋunha Ŋäthiliŋuŋurnydja Djorra'ŋurnydja dhärukma garrun bitjanna gam', “Banhayam yolŋu banha nhan bayiŋ ga garrwar-lakaranhamirrnydja nhanapinya nhan, nhanmam God-Waŋarryun bayiŋ ga banha ŋapay-ŋurrkaman balanyaranhany yolŋum. Ŋarru nhan bayiŋ ga guŋga'yundja ga mä-ŋuwatji bayikuyan bili yana yolŋuwu banha nhan bayiŋ ga nyilŋ'thumanmin nhanapinya nhan.” ");
INSERT INTO dhg_vpl VALUES ("JM4_7","089_4_7","JAS","4","7","7","Bitjan nyilŋ'thumanmiyan nhunapinya nhe God-Waŋarrwum, bala dhärukma gayŋi warraṯthuwan nhanany. Yaka'yuwam gayŋi garruwa bayikuyan buŋgawawun Mokuywun. Nhananhan gayŋi ŋangawulma yän warraṯthuwa; yana nhanany bitjan ŋaŋ'ŋaŋ'thuwan, bala nhanmam ŋarru yana gätthunna, winya'yunna ŋarru nhuŋguru. ");
INSERT INTO dhg_vpl VALUES ("JM4_8","089_4_8","JAS","4","8","8","Go maŋgarran galitjiyan God-Waŋarrwuḻin, ga nhanmam ŋarru bitjanya ḻinygu yana galitji nhuŋguḻin. Gatjuy goŋma warra rurrwuyunmiyan nhumam banha dhuwurr-barrakinymim yolŋu warra, ga ŋayaŋum warra bitjan ḏarrtjalkkunhamiyan nhumalinhawuynha, nhuma banha gali'-märrmam' yolŋu warra. ");
INSERT INTO dhg_vpl VALUES ("JM4_9","089_4_9","JAS","4","9","9","Ŋätjiya ŋatjil warra galŋa-warwumiyiya. Ga ŋangawul gayŋi gitkitthuwam yana galŋa-djulŋiyiyam, nyä'yuwa ŋatjil, goṉayiya manapa bayikuya nhuŋguwaywuru nhunu barrakinygu romgu. Rom-nyamir'yunmiyan, ga biluwan guŋnharruman banhayam goṯawatjnha yana. ");
INSERT INTO dhg_vpl VALUES ("JM4_10","089_4_10","JAS","4","10","10","Bitjan nyilŋ'thummanmiyan nhunapinya nhunu Garraywuḻim maŋutjiŋa, bala nhanmam ŋarru nhuna ŋalthumanma garrwarkuman ŋurruŋuyumana. ");
INSERT INTO dhg_vpl VALUES ("JM4_11","089_4_11","JAS","4","11","11","Wäwa ga yapa warra nyäku, ŋangawul nhuma ŋarru gayŋa banha goṯa-warrunmim nhumalinhawuynham nhuma, ḻinygu nhumam dhaŋu wäwa'manydjin warra Garraywuḻin romŋuru. Bayiŋ nhunu ŋarru gayŋa banha Garraywuruminy yolŋuny warrany nyamir'yun ga goṯa-warrun, banhayam bitjuwayiŋ nhunu gayŋa God-Waŋarrwun rom nyamir'yun ga goṯa-warrun. Ga bayiŋ nhunu ŋarru gayŋa banha ŋayaŋuyum nhuŋguwaywuḻ nhunu nyamir'yun banha God-Waŋarrwum rom, bayiŋuyam gayŋa maŋutji-rakaram banha nhunum ŋangawulnha biyapul bitjuwayiŋ buthuru-bitjundami ga yän-warraṯthundami yolŋu, ŋarru banhayam nhunu yolŋu bilanyayam rom-mala-djarr'yundamin God-Waŋarrwurun romgu. ");
INSERT INTO dhg_vpl VALUES ("JM4_12","089_4_12","JAS","4","12","12","God-Waŋarrnha banha nhanbayin waŋganynha yana rom-guŋandamim ga mala-djarr'yundamim. Yo nhanbayin yana ŋarru banha waŋganydhun wälŋakumam ga biyapul nhan ŋarru buwayakkum. Ga nhäwun banha nhunum bayiŋ gayŋa nyamir'yun waripunham yolŋuny ");
INSERT INTO dhg_vpl VALUES ("JM4_13","089_4_13","JAS","4","13","13","Ŋäka ŋatjil warra nhanany, nhuma bayiŋ warrayu banha nhuma bayiŋ gayŋa garrwar-rakaranhami bitjanmi, “Djinaŋ bala nhä wilak barkthu goḏarr', ŋayam ŋarru ŋarran balayan murrukayḻin waŋgalaḻi, ga nyenayim ŋaya ŋarru barkthu ŋunhalayan waŋgany dhuŋgarra, ga djämam ŋaya ŋarru gayŋi banha, ga baya ŋaya ŋarru..... ga ṉukunydja'yi.” ");
INSERT INTO dhg_vpl VALUES ("JM4_14","089_4_14","JAS","4","14","14","Yo, waripum nhunu bayiŋ garrun bitjanya ŋarru gulitjma nhunu banha ŋangawul nhuŋguway nhunu marŋgi nhä nhuŋgu ŋarru banha maḻŋ'thun waripuŋuyu waluyu. Ḻinygu ŋalim dhaŋu yolŋum bilanyan bitjuwayiŋ wakuluŋgul'nha; dhumbuḻ yana ŋali ŋarru gayŋa nyena, bala ŋali ŋarru yana wiḏi'yuna. ");
INSERT INTO dhg_vpl VALUES ("JM4_15","089_4_15","JAS","4","15","15","Bitjan nhunu ŋarru gayŋa banha gulitjma garrun, Ŋunham Garrayma nhanbayim nyäku djäl ŋaya ŋarru gayŋa nyena djinal waŋgalaŋa wälŋa yana ga ga djäma ŋaya ŋarru gayŋa yana ŋunhuŋ nhä malany Bitjan ŋalma ŋarru gayŋa banha gulitjma garrun, ḻinygu nhanbay dhaŋu God-Waŋarr yana marŋgim ŋaliŋgu nhätha ŋalma ŋalma barkthu ŋarray waŋa'waŋayi. ");
INSERT INTO dhg_vpl VALUES ("JM4_16","089_4_16","JAS","4","16","16","Ŋarru nhumam bayiŋ gayŋa banha guḻuḻukthunmi yindi-rakaranhami nhumalinhawuynha nhuma ga dhuwaniyam bitjuwayiŋ ŋangawul dhunupa banha nhuma ŋarru gayŋa bitjanyam ḻanydjatthumanmim ");
INSERT INTO dhg_vpl VALUES ("JM4_17","089_4_17","JAS","4","17","17","Ga bayiŋ nhunu marŋgi nhä nhan banha dhunupa rom, ga ŋangawulnha bitjuwayiŋ nhunu ŋarru gayŋa banha djämam banhayam ŋuwakurrum rom, banhayam nhunu dhuwurr-barrakinynha yolŋu. ");
INSERT INTO dhg_vpl VALUES ("JM5_1","089_5_1","JAS","5","1","1","Yo, nhumam ṉukunydjam' yolŋu warra, rrupiya-guḻkumim mala, ŋätjiya ŋatjil warra murruy'-murruyuwan, ḻinygu barrakinynha marimin ŋarru nhumaliŋgum maḻŋ'thun ŋoy-gulŋiyinyamin rom. ");
INSERT INTO dhg_vpl VALUES ("JM5_2","089_5_2","JAS","5","2","2","Nhumam gayŋan ḻuŋ'thuman nhumaliŋguwuy nhuma guḻku marimi marimi ŋunhuŋ nhä malany buku-manguwan ŋarran, ŋarru banyayam nhä malany nhumaliŋgu ŋarru winya'yun barkthu, buruŋgulktjin ŋarru, ga ŋuwakurrum girri' mala nhumaliŋgu ŋarru banha ḏuŋgulmiyin, guwamun ŋarru ŋarray djirriḻtjirriḻyun/moŋ'muŋdhun. ");
INSERT INTO dhg_vpl VALUES ("JM5_3","089_5_3","JAS","5","3","3","Yo ḻinygun nhumaliŋgu gayŋan banha rrupiyam mel-wiḏi'mim mala dhulwirmiyinan, ga ga bitjuya nhumaliŋgu barkthu banha rumbalma guwarumu ŋorrtjayum räwakkuŋun yana. Ŋarru baḏak yana nhumam ŋarru gayŋa dhaŋu ḻuŋ'thuman buku-mangum nhä malany, ga ḏaykunma ŋarra dhaŋu gumurr-galitjin dhä-yawar'yundamim. ");
INSERT INTO dhg_vpl VALUES ("JM5_4","089_5_4","JAS","5","4","4","Waripuyum warrayu gayŋan djäma nhumaliŋgu marimin yana, wapthuman ŋarran gulkthuwan borum malany ŋarru ŋangawulnha nhumam ŋuwatjumarra ḏämbu-ḏirrunmaran balam dhanaliŋgum bayikuwuyma djämawuy yänan bitjuwayiŋ nhuma gayŋan banha mayali'-gutjparruwan dhanaliny. Ga djinaŋum bala banhayam warra banha dhanal gayŋan djäma nhumaliŋgu, dhanalim gayŋan dhaŋu guykuyuna balan Garraywuḻin, rakaraman gayŋa nhumaliny, bala yana nhanmam ŋarru God-Waŋarryum ŋäkulan dhanaliny rirrakayma, bala nhan ŋarru yana guŋga'yunna dhanaliny, ḻinygu nhanmam ŋunha Garrayma Ŋutu-Ḏäl. ");
INSERT INTO dhg_vpl VALUES ("JM5_5","089_5_5","JAS","5","5","6","Djinal munatha'ŋam waŋgalaŋa nhuma gayŋan nyenan ŋuwatjuman yana, galŋa-ŋuwatjin, ṉukunydja'kunhamin. Yo, banha bayiŋ buliki'yi guwaman ŋarra guḻku marimi mulmu, bala nhan bayiŋ ŋuthanna murrukayyin murrukayyin. Bala nhanmam ŋarru banha yolŋum ŋarran bala ḻiyuna nhanany rakunyguman yana guwamandawun. Ga bitjanyan nhumam gayŋan banha ŋuthanmaran, gandarr-murrukaykunharamin nhumalinhawuynha nhuma, bawalamiyu yana ŋunhuŋ nhäyu malaŋuyu. Ŋarru galkin nhuma ŋarru dhuwal waŋayin. Ḻinygu nhuma gayŋan banha barrakiny-rakaran ŋunha yolŋuny warrany dhuwurr-dhunupaminy, bala nhuma gayŋan guwatharanan dhanaliny murrkay'kuwanan, banha ŋangawul gayŋan dhanalim ḏämbu-ḏirruman nhumaliŋgu. ");
INSERT INTO dhg_vpl VALUES ("JM5_7","089_5_7","JAS","5","7","7","Yo, wäwa ga yapa warra nyäku, bulnha ŋatjil ŋarra maŋgarram bala, gäḻkuḻaŋ ŋarray Garraywum, ga yana ḻinygu ga waythu nhan ŋarru. Nhäŋa ŋatjil ŋunha gätni-djämaminy, bala marŋgiyiyan nhangurumurrun. Banha nhan bayiŋ ŋarra gätni-djämamiyu yolŋuyu lämu-nhinathuŋgan ŋatha munatha'ḻi, bala nhan bayiŋ gayŋa banha gäḻkuḻamam baḏaknha yana ga yanatj ḻinygu-u-u, ga baya ŋarru ŋurru-djuḻ'yun ŋurruŋu waltjaṉ, ga bewaḻiyam nhan ŋarru dharyun murrukaynha waltjaṉ ga dhawar, ga ŋatha ŋuwakurruyan walu bala nhan ŋarru ŋarra gulkthunna ŋatham banha ŋuwakurrum borumma. ");
INSERT INTO dhg_vpl VALUES ("JM5_8","089_5_8","JAS","5","8","8","Ga nhumam bitjaya bili ŋayaŋu-gäḻkuḻanhamiya maŋgarra bitjuwayiŋ banha gätni-djämami mala, ga ŋangawul gulyuwa gandarrŋam, ḻinygu nhanmam ŋarru Garrayma galki waythuna. ");
INSERT INTO dhg_vpl VALUES ("JM5_9","089_5_9","JAS","5","9","9","Wäwa ga yapa warra nyäku, ŋangawul yana nhuma ŋarru gayŋa banha goṯa-warrunmim bala-räli'yunmim, mä ŋarru God-Waŋarryum ŋangawul mu nhumaliny rom-nyamir'yu. Nhäŋa ŋatjil nhanany dhuwaniya Mala-djarr'yundaminy Yolŋuny, dhuwaniyan dhäyan nhan gayŋa galkin yanan dhurrwaraŋan. ");
INSERT INTO dhg_vpl VALUES ("JM5_10","089_5_10","JAS","5","10","10","Yo, wäwa ga yapa warra, guyaŋiya ŋatjil banha djawarrkminy warrany be baman'ŋuwuynha mala, banha dhanal bayiŋ gayŋarra garruwarra Garraywuru yäkuyu yäkuyu. Dhanalim gayŋan banhayam warra buṉakin ŋayaŋu-barrakinydjin dhika marimin yana, ŋarru dhanal gayŋan banha ŋarranam bitjan ḻinygu yana ŋoy-wanyuyin bayitjanya banha marimurru. Ga nhumam ŋarru gayŋa malthun dhanaliŋguwaynha yana, munguyuwam ŋarra goyurrma ŋupa dhanaliwaynhan yana. ");
INSERT INTO dhg_vpl VALUES ("JM5_11","089_5_11","JAS","5","11","11","Yo, nyenanam dhanal gayŋan banha bitjan ḻinygu yana mukthuwan gulitjuman bayitjanya banha marimurrum rommurru. Ga bayikuwuyma ŋalma bayiŋ ga dhanaliŋgu djinaŋum bala wokthunna ga manymak-rakaraman gayŋa banhayanham warrany djawarrkminham mala. Ḻinygu mu nhuma gayŋan ŋäkul baman'ŋuwuynham yolŋuny Djawupnham nyenanam nhan gayŋan banha romŋam dhaŋga'-ḏirryundamiŋan, ŋarru wiyinŋumin. Ŋarru bitjan ḻinygu nhän ŋarran banha märr-nhinathuŋganmin nhanguḻi Garraywuḻim ŋayaŋuyum-wurrkurrumdhu ga yalŋuwaŋumin ŋunha dhawar'yundamiyun bala nhan ŋarru Garrayyum nhanany guŋan guḻkun dhika marimin ŋunhuŋ nhäm malany ŋuwakurrum. Yo, nhanmam gayŋan banha Garrayma maŋutji-wuyuwan ga mä-ŋuwatjin nhangu nhan gayŋan banha mariminan yana. ");
INSERT INTO dhg_vpl VALUES ("JM5_12","089_5_12","JAS","5","12","12","Wäwa ga yapa warra nyäku, buthuru-bitjuwam warra ŋuwatjuma yana; dhaŋum yän mariminan wal'ŋu ŋurruŋun. Ŋangawul mayali'-gutjparruwa yändhu nhuŋguwaywuḻ nhunu wo Garraywuḻim yäkuyu. Ga ŋangawul garruwa bitjam gam', “God-Waŋarr Gulitj,” bitjam, ga ŋangawul garruwa yändhu wanyuyum, yäku-rakaraŋ ŋunha djiwarr'nham waŋgalany, ga dhaŋu munathany' waŋgalany, ga ŋunhuŋ nhä yäku-rakaraŋ waripu ŋangawul yana. Bayiŋ nhunu ŋarru guyaŋi yoranharawum, nhunum yänan bitjuwayiŋ yoraŋan, märr-waŋganydjiya yana bitja gam', “Yo,” bitjan. Ga bayiŋ nhunu ŋarru guyaŋi yaka'yundawum, nhunum yaka'yuwan yana, banhayan ḻinygu yana waŋganynha yänma ga ḻinygun. Bala nhan ŋarru banha God-Waŋarryum nhuna manymak-rakaraman. ");
INSERT INTO dhg_vpl VALUES ("JM5_13","089_5_13","JAS","5","13","13","Bayiŋ ŋarru ŋunhuŋ yol yolŋu nhumaliŋguḻ malaŋuru gulŋiya ŋayaŋu-barrakinydjinamiḻi romḻi, nhanmam ŋarru bayiŋuyam yolŋuyu bukumiŋgana God-Waŋarrwuḻin. Ga bayiŋ nhan ŋarru gayŋa ŋunhuŋ yol yolŋu goŋmiyim nyena, nhanmam ŋarru gayŋa yänan bitjuwayiŋ manikaynha miyaman, wokthunna ŋarru gayŋa God-Waŋarrwun manikaymurrun. ");
INSERT INTO dhg_vpl VALUES ("JM5_14","089_5_14","JAS","5","14","14","Ga bayiŋ nhumaliŋguḻ malaŋa yolŋu gayŋa rirrikthunma, nhanmam ŋarru guykuyuna ḻuŋ'thumana banhayanhan warrany banha barka-nhinathuŋgandanhan warrany, banha dhanal bayiŋ gayŋa djäga Godkurumiwu yolŋuwu warrawu, bala dhanal ŋarru bukumiŋgana nhangu, ga biḏi'yun wiyika'yun nhanany muḻkurrnha yäkumurrum Garraywurumurrun. ");
INSERT INTO dhg_vpl VALUES ("JM5_15","089_5_15","JAS","5","15","15","Ga bayiŋ dhanal ŋarru gayŋa banha bukumiŋgan bitjanyam, mä-nhinathuŋganminyarayum, nhanmam ŋarru banyayam rerrimim yolŋu ḏukthunna yana wälŋayin, ḻinygu nhanbayin ŋarru banham Garrayyun ṉakanharamiŋgan nhanany ḏäwalayumanma, bala ŋarru yana baya-rakaraman nhangu banha barrakinyma mala banha nhan gayŋan djäma. ");
INSERT INTO dhg_vpl VALUES ("JM5_16","089_5_16","JAS","5","16","16","Yo, banha nhuma bayiŋ gayŋa djäma barrakinyma yana, ŋarru ŋangawulnha dhurr'thurryuwam djuḻuḻ'yumam banhayam; yänan bitjuwayiŋ rakaranhamiyan warra nhumalinhawuynham nhuma bala-räli'yunmiyan, dhawaṯthuman bitjan rakaraŋan banhayam barrakinyma, bala yana guŋnharruman. Ga bitjan warra gayŋi bukumiŋgan nhumaliŋguwuy nhuma bala-räli'yunmiyan yana, mä nhuma ŋarru wälŋayin buŋgaṯthunna manapan warrpam'thuna. Ga banha nhän ŋarru gayŋa rom-dhunupam yolŋu bukumiŋgan, nhangum bayikuyam yolŋuwu bukumiŋgandam biyapulnha dhika dhulmu-ganydjarrmin, banhayam nhan ŋuwakurrun. ");
INSERT INTO dhg_vpl VALUES ("JM5_17","089_5_17","JAS","5","17","17","Banyayam banha baman'ŋuwuyma yolŋu yäku Yilaydjam bilanya ḻinygu yolŋu yana bitjuwayiŋ ŋalma. Bukumiŋganam nhan gayŋan banha God-Waŋarrwuḻim, ŋäŋ'thuwanam nhanany gayŋan waltjaṉgun gulumandawu, bala banha waŋgalam munatham' gayŋan dhäyan waltjaṉnharran yana wikarraŋumin, ŋangawulnha gayŋan banha waltjaṉma dharyuwan ḻurrkun' dhuŋgarra ga 6-ŋaḻindi. ");
INSERT INTO dhg_vpl VALUES ("JM5_18","089_5_18","JAS","5","18","18","Ga biyapul nhan Yilaydja bukumiŋgan God-Waŋarrwuḻ, ŋäŋ'thuwan nhanany waltjaṉgu djuy'yundawu, ga dhuṉḏaynha yana banha waltjaṉma dharyuwanan, bala banha munatham' waŋgala biyapul bitjuwayiŋ wälŋayin, ga ŋatham mala banha ŋuthanan ŋuwatjinan. ");
INSERT INTO dhg_vpl VALUES ("JM5_19","089_5_19","JAS","5","19","19","Wäwa ga yapa warra nyäku, bayiŋ ŋarru banha ŋunhuŋ yolthu yolŋuyu gananma banha God-Waŋarrwum rom, bala ŋarru gätthunna barrakinyḻin, ga bayiŋ nhunu ŋarru ŋunhuŋ yolthu yolŋuyu waŋganydhu ḏirrumanma nhanany God-Waŋarrwuḻim, ga banyayam bitjuwayiŋ ŋuwakurrun mariminan. ");
INSERT INTO dhg_vpl VALUES ("JM5_20","089_5_20","JAS","5","20","20","Ga bayiŋ nhunu ŋarru gayŋa banha bitjanyam ḏirruman dhuwurr-barrakinyminham yolŋuny, mä nhan ŋarru ŋangawulnha bulum djäma barrakiny, banhayam bitjuwayiŋ nhunu nhanany djakawarruwanan bewaḻin banha waŋayinyamiŋurun romŋuru, ga barrakinyma mala rom dhanaliŋgu ŋarru banha baya-rakaraman bukmakkuman yana. Ga bilanya. ");
ALTER TABLE dhg_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
