﻿USE sofia;
DROP TABLE IF EXISTS sofia.dgz_vpl;
CREATE TABLE dgz_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES dgz_vpl WRITE;
INSERT INTO dgz_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Iesu Keriso ani sibabasi mega anenen onin e taueniwa, ap gapan Eibaraam naewa mega yan ge yan onamuin ene Devit yanen. Devit naewa mega yan ge yan onamuin ene Iesu yanen. ");
INSERT INTO dgz_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Eibaraam orup Aisik baraen, Aisik orup Diekap baraen, Diekap orup Diuda tase gwani den semon. ");
INSERT INTO dgz_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Diuda orup Peres ge Sara semon inamu Teima, Peres orup Esiron baraen, Esiron orup Ram baraen, ");
INSERT INTO dgz_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram orup Aminadap baraen, Aminadap orup Nason baraen, Nason orup Salomon baraen, ");
INSERT INTO dgz_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salomon orup Boas baraen inewa Reap. Boas orup Obet baraen inewa Rut, Obet orup Diesi baraen, ");
INSERT INTO dgz_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Diesi Ayop Devit baraen, Devit Yuraya kwapuraewa naise, gapan Solomon baraen, ");
INSERT INTO dgz_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon orup Reaboam baraen, Reaboam orup Abaidia baraen, Abaidia orup Esa baraen, ");
INSERT INTO dgz_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Esa orup Diosapat baraen, Diosapat orup Dioram baraen, Dioram orup Usaya baraen, ");
INSERT INTO dgz_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usaya orup Diotam baraen, Diotam orup Eas baraen, Eas orup Esekaya baraen, ");
INSERT INTO dgz_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekaya orup Manasa baraen, Manasa orup Emon baraen, Emon orup Diosaya baraen, ");
INSERT INTO dgz_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","amba Diosaya orup Diekonaya, gwani wai den semon. Wam ame gapan at Babilon nagirewa tauan at Isurero nagirewa up tamon at muga ewagai sia entan amon. ");
INSERT INTO dgz_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","At Babilon nagirewa up tamon amone, at muga gan wanumune amba sia entan ewagai onamone, gapan Diekonaya orup Siatiero baraen, Siatiero orup Serababero baraen, ");
INSERT INTO dgz_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serababero orup Abiut baraen, Abiut orup Elayakim baraen, Elayakim orup Eso baraen, ");
INSERT INTO dgz_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Eso orup Sedok baraen, Sedok orup Akim baraen, Akim orup Eliut baraen, ");
INSERT INTO dgz_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliut orup Eliesa baraen, Eliesa orup Matan baraen, Matan orup Diekap baraen, ");
INSERT INTO dgz_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Diekap orup Diosep baraen. Diosep Meri memewa amba Meri Iesu inewa. Amba Iesu Meri potap yanen, me God wa watu eneni Keriso, God om enuni apanewa. ");
INSERT INTO dgz_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ap gapan, Eibaraam ani sibabasi mega yan ge yan onamuin ene amba Devit yaneni ameme iragi aonagaet pusi nawan degede (14) amba Devit ani sibababasi mega yan ge yan onamuin ene amba at Babilon nagirewa tauan at Isurero nagirewa up tamon amone ameme iragi aonagaet pusinawan degede (14) amba at Babilon up tamon amone nagirewa ame ani sibabasi mega yan ge yan onamuin ene amba Keriso yaneni ameme iragi aonagaet pusinawan degede (14). ");
INSERT INTO dgz_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Iesu Keriso anenen yaneni guturewa mam, Me inewa Meri apan Diosep ganganasen dere naine mutapen, go namu tobot ya tane gapan, Meri mek anuni Guewa Posewa Woup Seni amun mega gapan bagup tan. ");
INSERT INTO dgz_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Diosep me apan kakae tamanawa menan Meri umam ya anupen menan karaua ae veat anun, menan me imup ununke uon ae veat anu taiwandin. ");
INSERT INTO dgz_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Go mame anuiwandini, Diosep enok ineni gapan God anea mega da taue anega dien, “Diosep apan Devit ani sibabaseawa, Meri wara naitapen menan pa gega ak, tap ya anu, iwa dim da me potap digumin taniwa ame Guewa Woup Seni amun mega gapan tan. ");
INSERT INTO dgz_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Me orup apan baraepi, amba ge yaua Iesu diai, iwa waenapan mega koewa muga anu ae vepen menan taueta.” ");
INSERT INTO dgz_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ayop God nop mega namu wani mame iragi tan tavewa venasen ame God no oise waiwandini apanewa gamup anega wan, ");
INSERT INTO dgz_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Waenoro ini denawa bagup tapi, amba orup apan baraepi, me yaua Imanuero diain, (Imanuero gueguewa ame God den inanup wandia). ");
INSERT INTO dgz_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Menan, wam ame Diosep enok ine kandae yon wandeni gapan Ayop anea mega anen dieni di tan. Ap menan me waen Meri naisen. ");
INSERT INTO dgz_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Go mu dere wainan da ya inane go mondi iniwanumune aiwandin eni orup apan yanen. Amba Diosep orup ame yaua Iesu dien. ");
INSERT INTO dgz_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Apan Erot ayop tani wamewa Iesu at Diudia pa sewa Betiriem gapan yanen. Iesu yaneni ewap, buanae batnagine nagirewa upi, wam dotouini arige gapan Ierusalem tauan amba singui waenapan inamup anega wayawamon, ");
INSERT INTO dgz_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Diu nagire ayop egawa da mapa yaneni amba? Nu buanae, me paua mega da, wam dotouini gapan yawatoni menan wa taragaset wa onanton.” ");
INSERT INTO dgz_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ayop Erot, amba Ierusalem pa nagirewa den, oit ame anune gapan mu seke tane amba gop anune. ");
INSERT INTO dgz_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ap menan, Ayop Erot pirisi bawarewa ge waenapan iup wadidiamuine nagirewa munan wan tauane. Me singui anega wayawamon, “Mesaya yanat mega at ambe gapan yanapen wane?” ");
INSERT INTO dgz_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Mu gare anega wadiane, “At Diuda pa Betiriem gapan yaneta. Iwa God nop mega watagaet waiwandini apanewa ok ap anega sen, ");
INSERT INTO dgz_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Go e, Betiriem nagirewa, at Diuda gapan, sewa sewa iragi gapan pa sewa ega epara da uon, go amun ega wandia, iwa e yaumakayap Ayop da taueta, me ne waenapan nega, Isurero nagirewa, kwayup tamota.” Mu ayop Erot ap anega wadiane. ");
INSERT INTO dgz_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Boge ayop Erot buanae batnagine nagirewa karaua venamu wan tauane, iwa wam ansena buanae erewa muga da yawane anupen menan, singui wayawamon. ");
INSERT INTO dgz_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ap anuni amba, ayop Erot buanae batnagine nagirewa Betiriem watu enamoni gapan anega diamon, “Aisen, amba orup ame yoa yambuni tan. Yop tan en me yawanewa menawaet onaen oit wadianegen, amba ne den ange tauap me wa taragasep.” ");
INSERT INTO dgz_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Erot nop ame wan anune ewap mu di amon, amba buanae wam dotouini gapan sia yawane. Ap menan mu daramumu wan aton aigap da anune. Buanae ame namumup di aiwandin yao nau amuiwanumune amba Iesu ambagan wandeni arewa taueni aigap yonen. ");
INSERT INTO dgz_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Pa gwanap unum amon, mu orup inewa Meri dere yawamon amba omanimup enun wa taragasene. Boge mu momorap muga watapan amba yan garaet muga muga Iesu wanane. Yan ame agim gwayayame den yananagaetawa amba dagin irinewa amba oma ose tutu denawa. Puraput ame garewa muga baware. ");
INSERT INTO dgz_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Entane, ayop Erot ine ya amopen menan tagigirewa God enoga wadiamoni menan negin ugupe gapan ewagai at muga sia amon. ");
INSERT INTO dgz_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Mu amone ewap, Ayop God anea mega da Diosep inap enoga taue anega wadien, “Ge ao yona, orup ine dere tambumo, tap aisen, aipa at Idip gapan waniene, ne wadiaepen amba sia onaen iwa ayop Erot orup togurep boepen menan yoa tapen taiwan.” ");
INSERT INTO dgz_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Menan Diosep ao yon wande, orup ine dere tambumo mum oap at Idip di amon. ");
INSERT INTO dgz_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Mu ap mepe di wanumuin ene Erot bop tan amba sia ewagai onamone. Ma venaseni menan God noa watagaet waiwandini apanewa wani tavewa tauen. Me gamup God anega wan, Otuna at Idip gapan wa oitapen tau aeta. ");
INSERT INTO dgz_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Wam ame Ayop Erot buanae batnagine nagirewa amatamu taiwandin mu negin ugup amone oisewa anuni ugu gangan naen. Menan ita nagire megawa wa oimon orup apan otu kamontua en muga derewa amba gauarapewa den, pa Betiriem amba mainepe den iragi guritamen. Buanae batnagine nagirewa wataget buanae ere venaseni gapan anune menan mu Iesu yaneni wamewa wadiane ayop Erot anuni gapan me orup guritamepen menan en muga om tan. ");
INSERT INTO dgz_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ap gapan, watageta apanewa Dierimaya, God no oise waiwandini tavewa tauen. Me anega wan, ");
INSERT INTO dgz_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Pa sewa Rama gapan unuk da anuivin, irip turup waiwanum. Watageta waen Reisero dugup mega naewa, munan irip waiwan, amba imua to aramepen menan umap uon, iwa naewa mega gase borit wane. ");
INSERT INTO dgz_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ayop Erot boeni ewap, at Idip gapan, Ayop God anea mega da Diosep enoga die anega wan, ");
INSERT INTO dgz_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Ge ao yona, orup ine dere tambumo amba at Isurero ak, orup togurapen tane nagirewa gaseget borit wane,” ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Menan Diosep yon wande, orup ine dere tambumo, at Isurero di amon. ");
INSERT INTO dgz_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Wam ame Erot otua, yaua Akelaus, mamewa uewa ware at Diudia gapan ayop tan. Ap oisewa Diosep anuni menan me at ame aepen tani tap anun. God enoga tagigit manega wadien anun, ‘Mapa ya wainge.’ Ap menan totnage at Galili arige aen. ");
INSERT INTO dgz_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ap mepe tauane, pa sewa bawarewa Nasaret gapan wanumone. Menan God no oise watagaet waiwanumune nagire nop muga tavewa tauapen menan ap mepe om inen. Nop muga ame Iesu menan anega wan, Waenapan pa Nasaret apanewa diain. ");
INSERT INTO dgz_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","En arugataet uon tani ewap, Dion, dup iamuini apanewa, at Diudia pua at kaimewa gapan taue opata anega waiwandin, ");
INSERT INTO dgz_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“E inak koewa taiana ae vean, imuya entanen iwa God toemu mega amunewa inayap tauapen taiwan,” ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Mame gapan, watageta apanewa Aisaya, God nop oit mega waiwandini tavewa manega tauen, ame anega wan, Apan da pua, at kaimewa gapan, opata anega waiwandin. Ayop nuga negin mega wa tarasen, wat tamanamene amba tauep. Ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Dion wanup mega man kameru etua gume den eniwandin, amba berip mega, man etua paniwandin. Me taba paki ge onaro naiwandin. ");
INSERT INTO dgz_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Pa Ierusalem nagirewa amba at Diudia iragi ge kaum Diodan asepa gan mapa gan nagire den Dion ine tauan. ");
INSERT INTO dgz_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Mu da da koewa muga vesiwanumune nagirewa kaum Diodan gapan dup iamuiwandin. ");
INSERT INTO dgz_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Wam ameme anu tumat dugupewa yaua Parisi ge Sadusi nagirewa aruga Dion dup iamopen menan ine tauane go Dion anega diguguramon, “Guegue ega mokare seram naewa umap! E darinaya da enuni gapan tap anu, dup iaet wa, amba God wae wae nemoro mega tawa aisepen taiwanin? ");
INSERT INTO dgz_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Koewa ega yamu entanet wane, garewa inak tamanawa gapan yambuni ta aisiwanian. ");
INSERT INTO dgz_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ek mondi anega ya wane, ‘Nu omayan baewa Eibaraam menan God atonunu anuiwan,’ ap ya wane. Wapena anun, e Eibaraam naewa megenat wane ya umap, iwa God Eibaraam naewa mega upi gwat ma wapi di venat mutain. ");
INSERT INTO dgz_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Wapena anun, endi mame di oma visiwa, gurini apanewa nugusepen nauase wandia. Oma da da tavewa kakaewa ya iamopi gure ireta. ");
INSERT INTO dgz_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","E koewa ega anu ae veana menan kaum gapan dup iaivin. Go apan da ne evinap oniwan, me God Guewa Woup Seniwa ge oma yamewa merao gapan dup iaiwandata. Me baware, ne uon, me pusi okomewa tambupen menan ne umanap uon. ");
INSERT INTO dgz_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Me iman taue oma makewa bongameta, makewa kakaewa ai bongame mek mini siwandata amba pokewa mek mini siwandata. Makewa kakaewa tambu ae dugupa eneta go pokewa yaibobot oma meraovewa gapan uatamep yagimota.” ");
INSERT INTO dgz_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Amba Iesu at Galili ae ve, Dion dup iapen menan kaum Diodan onen. ");
INSERT INTO dgz_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Go Dion anu yave Iesu dup ya iat anuni menan, anega dien, “Ge dimen inanap tauaan? Ne piup apanewa, ge gare dup ianegepo umap.” ");
INSERT INTO dgz_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Go Iesu gare wadien, “Wam endiwa menan dup ianegewa umap. Nu ap tata God ayamat mega di tait.” Iesu ap wani, Dion umap wan. ");
INSERT INTO dgz_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Menan Dion Iesu dup ien. Dup ieni boge Iesu kaum ae ve kwatata ao dotoueni. Amba kiman ase watapen, boge God Guewa Woup Seniwa nenip bairantan mini kimani visiwandin Iesu wapip wanden. ");
INSERT INTO dgz_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Amba nop da kimani anega tauen, “Ma ne otun iragenawa, ne menan anu gurinawa, me gamup ne imuna ae meare tau aen,” nop ap anega kimani tauen. ");
INSERT INTO dgz_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Boge God Guewa Woup Seni Iesu nau pua aen, Seitan pusi warup tayawapen menan. ");
INSERT INTO dgz_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Taba uon sinunu in doreni wam ge mum apane dere uon tani ewap me enup aren. ");
INSERT INTO dgz_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Seitan, pusi warup taini apanewa, me inap taue anega wan, “Ge God Otua wanigewa, gwat ma diamo taba buredi venat musep na.” ");
INSERT INTO dgz_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Go Iesu gare anega wan, “God nop mega ok anega seane, Waenapan inak muga ibariwa taba naine megenat uon, go God nop waini gapan inak wariwanum,” ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Boge Seitan sia nau pa sewa Ierusalem dot ae ware God Paewa aigarip aigap iragenawa gapan baraen ap mepe yaoyao yonen. ");
INSERT INTO dgz_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Seitan anega dieni, “Ge God Otua wanigewa, map mepe bup ta wa kugunak aipa piupa wanik, iwa God nop mega ok anega seane, God wap anea mega upi taue, genan kwayupaga yaentuk ta naugep vitai, Anea nanimup di warak nauge vise pia bat gimagain, pusiga agima ya en manamai.” ");
INSERT INTO dgz_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Seitan ame wani Iesu gare wadien, “Ne ap ya tain, iwa God nop mega ok anega seane, Ayop gega God irewa yawapen menan ya nanamasewa.” ");
INSERT INTO dgz_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Sia Seitan Iesu wat naue tunup ideve aigapewa dot ae, boge piup at at iragi toemu kakae guragut muga muga ewasen. ");
INSERT INTO dgz_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ewase Iesu anega dien, “Ge iak poe inanap ta wa taragat nimanegewa, toemu mame iravi genain,” ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Go Iesu gare anega dien, “Seitan, ae venek, asira ak! God nop mega ok anega seane, Nu Ayop nuga God megenat wa taragaset, ayamat mega taivinait.” ");
INSERT INTO dgz_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Boge Seitan Iesu ae ve aen, amba anea tauan Iesu wat agoasen. ");
INSERT INTO dgz_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Wam ame ewap, Ayop Erot ita mega nagirewa Dion, waenapan dup iamuini apanewa, waran gwat nokap baraene. Iesu oit ame anuni gapan, me ewagai at Galili sia aen. ");
INSERT INTO dgz_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Me at Galili taueni, me pa sewa mega Nasaret gapan ya wanden go ae ve aen pa sewa da, kaum awan etope, yaua Kaponiam gapan iniwandin. At ame dugup Sebulon ge Naptali arik muga aen. ");
INSERT INTO dgz_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ap venaseni gapan God nop mega watagaet waiwandini apane Aisaya wani tavewa tauen. Aisaya ok anega sen, ");
INSERT INTO dgz_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","At Sebulon ge at Naptali, negin aen awan bawarewa tauiniwa, kaum Diodan asepa gan, at Galili ian ugupe aruga wanumuine arewa. ");
INSERT INTO dgz_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Waenapan ameme imu pose mum tauen iniwanumune, ganat baware yawain. Bop guewa inamup wandini nagirewa, ganat inamup taueta. Aisaya ok anega sen. ");
INSERT INTO dgz_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Wam ame use aeniwa, Iesu opata mega erewa wan, “Koewa ega gapan imuya entan tan, toemu kimaniwa onen mananiwan.” ");
INSERT INTO dgz_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Iesu kaum awan Galili etop ap aiwandini, me apan tase gwani dere yawamon, Saimon, yaua dawa Pita, amba me gwaniwa Anduru. Mu ia muga kauma uariwanum, mu meo dawane taine nagirewa. ");
INSERT INTO dgz_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Iesu anega wan, “Ewanap onaen, ta ewaepen gapan e waenapan dawane tan.” ");
INSERT INTO dgz_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","No utap, mu ia muga ae vean amba me ewap amon. ");
INSERT INTO dgz_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ap mepe use amonewa, me tase gwani derewa sia yawamon, yaumua Diemis ge Dion, ame apan Sebedi otu waiwa. Mu kabum muga gwanap ia muga nadi waran tata kakayat taiwanunum. Amba Iesu venamu wan. ");
INSERT INTO dgz_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ap gine tutup kabum muga ge mamamua ae vemon amba Iesu ewap amon. ");
INSERT INTO dgz_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Iesu at Galili iravi tau ge tau aen. Diu nagirewa iup anuine paewa gwanap wadidiam wandin. God toemu mega Oise Kakaewa opata gapan waiwandin. Amba waen apan enkana ankana nagirewa amba vek gine ugup ugup iragi wat inakam mumiwandin. ");
INSERT INTO dgz_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Me ap taiwandini oisewa, at Siria iragi senare tau aen. Menan waenapan vek muga ugup ugup iragi tambumon me inap tauane. Ame ugu vegaek baware anuine nagirewa, airampu wa guguramoniwa, wam wam gapan vek daram daram taine nagirewa, amba pusi nani itani waniwa, me iragi wat inakam mumen. ");
INSERT INTO dgz_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Waenapan arugataet at ugup ugup gapan tauane ewap amuiwanumun. At ugup ugup ame yaumua, at Galili ge at Diudia amba pa sewa yaua Pa Aonagaet, amba pa sewa Ierusalem, amba kaum Diodan asepa gan wanumuinewa. ");
INSERT INTO dgz_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Wam da, Iesu waenapan to iamene yawamo, menan me dot ae tunup nawanep ae wanden. Me wadiamot megawa inewa tauan iamene. ");
INSERT INTO dgz_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Amba me opata mega manega wan, ");
INSERT INTO dgz_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Guewa gapan dai momeni nagirewa, God wat aipakam mumiwan, toemu kimaniwa amun megawa iravi mugawa di. ");
INSERT INTO dgz_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","God wat aipakam megawa, irip turup waine nagirewa mugawa, iwa mu wabibigam mumeta. ");
INSERT INTO dgz_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Imua ae bigaren taine nagirewa, God wat aipakam megawa wariwanum, iwa mu piup ma yon borain. ");
INSERT INTO dgz_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Waenapan tamana tapen menan, imu pose kanda mutane taine nagirewa, God wat aipakam mega munep umamup tamota. ");
INSERT INTO dgz_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Waenapan munan bagu sisi anuine nagirewa, God wat aipakam mumeta, God gare munan bagu sisi anuta. ");
INSERT INTO dgz_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Potamu nenengawa nagirewa, God wat aipakam mega wariwanum, evi amba mu God yawain. ");
INSERT INTO dgz_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","God menan nonup baigan barine nagirewa, God wat aipakam mega mu inamup, iwa God otu waiwa diamota. ");
INSERT INTO dgz_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","God menan inak tamana taine nagirewa, wa koeragam mumiwanumune menan, God wat aipakam mumiwan, toemu kimaniwa amun megawa iravi mugawa di. ");
INSERT INTO dgz_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Waenapan nenan nipep diae wa koeragam imaepi nop koewa ugup ugup inayap aopan wapi ame gapan aton anun amba God wat aipakam imaeta. ");
INSERT INTO dgz_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Menan daramuya wap, aton tan, iwa kiman gapan garewa ega arita. Ap mini, e umayap, wataget God no oise waiwanumune nagirewa wa koeragam mumane.” ");
INSERT INTO dgz_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Iesu sia anega wan, “Taba siuran den natawa dansewa da di, ap mini sia e piup ma siuran megawa, go siuran dansewa mega ni nen sepiwa, e anenen tane amba dansewa sia wata? Ame umap uon, siuran ame denanu mini ae damagep, waenapan tau gagap amuin. ");
INSERT INTO dgz_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","E piup ma ganat megawa. Sewa baware da awana tune gungunu ya wanumoin go pa iravi aroga yaviwanumain. ");
INSERT INTO dgz_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Apan dun mega ire ware karaua unup ninokap ya baraeta. Go dun aroga baraepi ame gapan waenapan pa gwanape iravi ganat muneta. ");
INSERT INTO dgz_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ap umap, ganat ega waenapan inamup ganase wap, ame gapan mu kakaewa ega taianawa yavepi mamaya kimani wandini mu wa taragatain.” ");
INSERT INTO dgz_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Iesu sia wan, “Iup namua amba God noa waiwanumune nagire nop muga den, ise wat mutapen menan ya tauan, ap ya anu nimanegene. Go nop muga tavewa mega tauapen menan tauan. ");
INSERT INTO dgz_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ne tave di wadiaivin, wam da piup ge kiman aiwandan uon tata go namu God iup mega iravi, semu otu koentu den, aiwandan tavewa mega iragi taitamep amba uon tata. ");
INSERT INTO dgz_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ap menan orup ansena iup namua semu otu koentu to paise yone ae evene wai iup namua to paitapen wadiamopi, mu toemu kimaniwa gwanap nutu uoni nagirewa diamoin, go mu da da iup namua ayamase ta amba waenapan iup mame wadiamopi mu toemu kimaniwa gwanap mu bawarewa nagirewa diamoin. ");
INSERT INTO dgz_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ne ma kaimakaet wadiaivin. E God menan inak tamana taiana ame Parisi nagirewa ge iup wadidiaine nagirewa tat muga garawasepiwa e toemu kimaniwa tauai go e ya tanewa e ya tauai.” ");
INSERT INTO dgz_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Iesu sia wadidiamon, “Waenapan watageta nagirewa wane guturewa e anuyan. Ame mam, Apan da ya togura boep. Go waenapan da togurep boepiwa, me ware wanene paewa gapan tauain. Watagaet ap anega wane. ");
INSERT INTO dgz_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Go ne sia aigap wadiaivin, e da da evenae wai inamup gari gangan anunewa, ap gapan wanene tae itan enapen tain. Sia, evenae da kaimakaet nipep anega dianewa, ‘Ge dantaga uon di!’ Ap gapan kansoro nagirewa namumup wanene taepen menan yonai. Amba waenapan da bumbawam nagirewa diamonewa, ap gapan oma merao arewa aisepen taiwanin. ");
INSERT INTO dgz_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ap menan, God Paewa gwanap, puraput sine watarewa gapan, puraput gega yan tapen anua go evenaga da inap ta koeragamean ap me anua, ");
INSERT INTO dgz_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","menan puraput gega God ya wana, ap mepe ae ve, go evenaga baigane ta amba sia onak, yan garaet gegawa God wan. ");
INSERT INTO dgz_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Evenaga da koewa gega menan wanene tagepen anupi, menawaet ni gwane ae amupen, wat nauge wanene paewa tauepi tawa. Negina wa nengamene uon tap. O uon wandepiwa, wanene i apanewa nanip bat gimageta amba wanene i apane punip nagirewa nanimup bat gimagain, mu waregep gwat nokap bat gimagain. ");
INSERT INTO dgz_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Tave di waivin, ge ya tau agai, wanene garewa mega iragi taitamewa amba tau agai,” ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Iesu sia wadiamon, “Waenapan watageta nagirewa wane guturewa e anuyan. Ame, Togane tapatap ya tane. Wataget ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Go ne nop ewakewa wadiaivin, orup da waen yave, imua gapan wainan gogo den tat anupiwa ame gaset wainan gogo waen ame den tan. ");
INSERT INTO dgz_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Menan yamaga nutup nauge aep koewa tawa, ae ma warup aipa uat ena aep. Etuga semua da wakaumawa ame kakae di, iwa ap ya tawa ge tawaga uruga oma meravewa gapan uat enagain. ");
INSERT INTO dgz_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Amba naniga nutup wat nauge ae koewa tapiwa, to ketnak aipa uat! Naniga ame wakaumeawa ame kakae iwa ap ya tawa ge tawaga uruga oma meravewa gapan uat enagain.” ");
INSERT INTO dgz_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Iesu sia wadiamon, “Watageta nagirewa anega wane, Apan ansena da waen mega ae veat anupi, waenewa ae vea vea ogewa waenewa se wanep. Ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Go ne endi aigap sia wadiaivin, apan ansena da waenewa union ae ya veta, go waenewa apan dawa den aeni menan ae vepiwa, ame umap. Go waenewa union ae vepiwa memewa ta pariseni gapan waen ame apan dawa naiseni togane tapatap di tata, amba naiseni apanewa ap anega den sia di.” Ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Iesu sia wadidiamon, “Watageta nagirewa anega wane, e den anuyan, Agi ega ya to paitane, go Ayop inap agi wayana, wat natan om gapan taiwanian. Watageta mu ap wane. ");
INSERT INTO dgz_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Go ne ewake wadidiaivin, evenae wai munat wa agiat mumane nop ega tavewa mu anupen menan tanop ya tone. Kiman amun mega gapan den tanop ya tone iwa kiman God wandini arewa. ");
INSERT INTO dgz_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Amba piup amun mega gapan den tanop ya tone iwa piup mame, God pusiwa amuini arewa. Pa sewa Ierusalem, God wandini arewa, amun mega gapan den ya tone iwa pa sewa ame Ayop bawarewa God pa megawa. ");
INSERT INTO dgz_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Amba iaya gapan tanop ya tone iwa ap tane iaya gumewa daiton da pomponu go pumpuni ya entan tata, ap menan iwa dimen iaya gapan tanop toi. ");
INSERT INTO dgz_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Menan agi tavewa wandepiwa, tave di wapen, amba agi tave uon wandepiwa ame uon di wapen. Ame use aigapewa da sia wawa, ame Seitan arok wana taueta.” ");
INSERT INTO dgz_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Iesu sia wadiamon, “Watageta nagirewa anega wane, e anuyan. Apan da evene yame make warupepi, gare yone evenewa yame make warupep. Evene no done to bunaepi, gare yone evenewa no done to bunaep. Mu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Go ne sia aigap wadiaivin, waenapan da inagap koewa tapi garewa ya tane. Orup da nawanegap togepi gare ya ta go nawanega yamu entane sia togep. ");
INSERT INTO dgz_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Amba apan da enu yawage wa wanup gega aigape warupe, wanup gauarape menan den wapiwa, goandage ya anu den sia wan. ");
INSERT INTO dgz_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Apan da wandap aepen anuni, ge ik mega yongotu ago ta aget wapi go ge wandap wat ak. ");
INSERT INTO dgz_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Apan ansena inagap mup wapi di wan amba puraput gega mondi wariwandan evi sia genat wapi goandage ya wa.” Ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Iesu sia wadidiamon, “Watageta nagirewa anega wane anuyan, Pa maineyape nagire munan anu guran, amba anavi ega tandayat muman. Watageta nagirewa ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Go ne sia aigap wadiaivin anavi ega munan anu guran. Amba ta koeragam imaine nagirewa munan God inap mup wan. ");
INSERT INTO dgz_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ame tanewa, e Mamaya kimaniwa otu waiwa. Iwa me wapi wam mega kakaewa koewa nagirewa dere aigamup ganase waiwandata, amba ugin watu enep tamanawa taine ge gegerawa taine nagirewa aigamup visiwandata. ");
INSERT INTO dgz_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Waenapan imumu potamu inayap warepi ame e gare mugenat munan anu guranewa, ap gapan God wat aipakam mega ya warai. Iwa koewa taine nagirewa mu den ap anega di, mu evene wai den muk gare gare baigan taiwanum. ");
INSERT INTO dgz_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Amba evenak waigawa mugenat gaunamu tawa, piup gueguewa taine om daiton di taiana, aigapewa da uon. Iwa ya anu tumasine nagirewa mu ap anega di, evene wai den muk gare gare taiwanum. ");
INSERT INTO dgz_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ap menan kakaevet tan, e Mamaya kimaniwa kakaevet taini mini.” ");
INSERT INTO dgz_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Iesu sia wadidiamon, “E God menan kakaewa tanewa waenapan yawaepen menan ya tane, iwa waenapan yawaepen menan tanewa, Mamaya kimaniwa garewa da ya eneta. ");
INSERT INTO dgz_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Guegue ame mam. Kayakayawan taine nagirewa puraput munapen tanewa, pum upunan opata gapan upine ya wadiamone, ame da wa da ta taine nagirewa ap mini ya tane. Mu yaumu ao warapen menan iup anuine paewa ge negin gagap ap anega taiwanum. Ne tave di wadiaivin, mu garewa mugawa uruga piupa gase warane. ");
INSERT INTO dgz_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Go wam ame kayakayawan nagirewa wan dim dim da munanewa, evenae wai oit ame den ya anupen menan tan. ");
INSERT INTO dgz_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ap menan taiana oisewa karaua wandep amba Mamaya kimaniwa imuya yaviniwa garewa ega aroga eneta.” ");
INSERT INTO dgz_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Iesu sia wadidiamon, “Amba wam ame God inap mup tapen tanewa, da wa da ta taine nagirewa mini ya tane! Mu atonu den iup anuine paewa gwanap, pa pa nambaya den, waenapan yawamopen menan apan apane den aopan aopan mup taiwanum. Ne tave di waivin, mu garewa muga uruga di warane. ");
INSERT INTO dgz_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Go wam ame mup tapen tanewa, pa ega ega gwanap unuk aisen tonan boran, amba Mamaya ya yavianawa inap mup wan. Me mup ega karaua imuya potaya gapan waiana ame yavini gapan garewa eneta. ");
INSERT INTO dgz_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Amba wam ame e God inap mup tapen tanewa, ya anu tumasine nagirewa mini mup memo mawagamen ya waiwanian. Mu aopan anega anune, ‘Nu nononga wata God nuga anuta.’ ");
INSERT INTO dgz_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","E ap umap ya tane, iwa Mamaya imuya asigip tan ap menan mup ega me imua namu anun amba evi waiwanin. ");
INSERT INTO dgz_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ap menan mup manega wan, Mamanua kimani, yauga ao warat genan ayamat taivinain. ");
INSERT INTO dgz_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Toemu gega amunewa inanup tauiwandan. Kimani anuan taiana mini piup gapan ta nuningan. ");
INSERT INTO dgz_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Taba nuga wam wam nuningawa endi den nun. ");
INSERT INTO dgz_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Koewa inanup taine anuton ae vivin menan, koewa nuga anu ae ve. ");
INSERT INTO dgz_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Dim dim da pusinup ya warup naune age. Koewa Taini Apanewa ya mananepen menan ise wataningan. ");
INSERT INTO dgz_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Wam ame waenapan da koewa inagap tapi, ge koewa mega anu ae veawa, ge Mamaga kimaniwa koewa gega anu ae veta. ");
INSERT INTO dgz_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Go waenapan da koewa muga anu ae ya veawa, ge Mamaga kimaniwa koewa gega anu ae ya veta.” ");
INSERT INTO dgz_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Iesu sia wadiamon, “Wam ame God menan, sinunu in dorawa, da wa da ta taine nagirewa mini ya ta ameme yawaget gegawa nawanega gaip ya top, ginak namuk ya tam davep, da wa da ta taine nagirewa mini ya ta. Nop nega mondi uon anun di waivin. Da wa da ta taine nagirewa garewa mugawa uruga piup gapan gase waran. ");
INSERT INTO dgz_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Go wam ame sinunu in dorawa, ginak namuk bigi wat amba onaro iagap den wat. ");
INSERT INTO dgz_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ame menan waenapan iragi ge sinunu in doringianawa ya yavep, go Mamaga da ya yavinewa megenat yawagep, dim da karaua taingianawa garewa gega me di geneta.” ");
INSERT INTO dgz_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Iesu sia wadiamon, “Piupa ek ingane enan kwan puraput diri gagap ya se dorane, ap mepe wan dim dim puakaeta amba denip eneta, koe tata, amba ap mepe den up nagirewa benak unum amo up tain. ");
INSERT INTO dgz_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Go God menan anuiwaniampina garewa ega aupa kimani diri gagap se dorane. Ao mepe wan dim dim ya puakaeta amba denip ya eneta, koe ya tata, amba ap mepe up nagirewa benak unum amo up ya tain. ");
INSERT INTO dgz_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kwan puraput ega wandini arewa, imuya ap mepe wandeta.” ");
INSERT INTO dgz_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Iesu sia wadiamon, “Yamaya ame etuya dun megawa. E yamaya kakae wandepiwa, e etuya uruga ganat bararaeta. ");
INSERT INTO dgz_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Go e yamaya koerage tapiwa, e etuya uruga sisip tau aeta. Boge e ganat inayapewa ame sisip tau aeta. Ap menan ganat ega sisip wandepiwa, sisip ame sisip aigap iragenawa, uni gware den.” ");
INSERT INTO dgz_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Iesu sia wadiamon, “Amba nao apane da aritawa mega dere wanumopiwa, ame gauaramup nao ya taiwandata iwa aritawa mega dawa imua waren amba dawa imua ya wat kakayasen. Da noa wareta, amba da tandayaseta. God ge moni dere dere om daiton tambu tapen umap uon, daiton warai dawa wakaumai.” ");
INSERT INTO dgz_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Menan Iesu wadiamot mega anega wadiamon, “Ap menan ne wadiaepena anun, inak ega menan gop ya yagiai wandan. Inak ega warapen menan taba ge kaum ambagan tam na na amba etuya okomewa ambagan tam ena ena ap menan gopewa ya anune. Iwa inak wariana ame ibariwa, go taba ame gauarap. Amba sia etuya ame ibariwa go etuya okomewa ame gauarap. ");
INSERT INTO dgz_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nenip guegue muga yao anun. Taba naewa ya veriwanum, den daupam tane dugupa ya eniwanum go God kimaniwa taba muga muniwan. Amba God anu gurat mega inanup ame aigap amba den me anu gurat mega nenip inamup ame gauarap, ap menan gop ya yagiep taiwanian. ");
INSERT INTO dgz_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","E da da inak ega ya wakaumepen menan gop anuiwaniampina ame kakae uon. Gop ap anunewa, pia nonongantuk sia ya waniai. ");
INSERT INTO dgz_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Amba dim menan gan gorogot gope anuiwanin? Rarema yanine ame ase anun. Mu nao ya taiwanum amba wapimu menan ya anuiwanum. ");
INSERT INTO dgz_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Go wapena anun. Ayop Solomon kakae guragut mega arugataet go me en wanup kakaewa rarema ame enini umap da ya eniwandin. Rarema mega ame aigap iragen. ");
INSERT INTO dgz_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ap den sia, God unawat ame kwayupe tainiwa go wam konintu da i apane dayup taue to baraep kurat wapi amba ireta. Menan God unawat kwayup taini apanewa enan den taiwan. Ap menan sisi kwayup aigap di ta eneta. Kaiwan, e God inap otu da anu tumasiana nagirewa. ");
INSERT INTO dgz_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Menan e gop anu anega ya wane, ‘Nu taba dim da nait?’ o ‘kaum amba nait?’ o ‘gan gorogot dim da panait?’ ");
INSERT INTO dgz_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","God tandayasine nagirewa wan dim dim mame iragi nanamu amuiwanum, amba wan dim dim ame munan anuiana, e Mamaya kimaniwa me asik tan. ");
INSERT INTO dgz_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Go namu, God toemu mega ge inak tamanawa megawa, yoa tan, amba wan dim dim mame iragi amba den sia eneta. ");
INSERT INTO dgz_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ap menan imanawa gope endi ya anune. Tauepi amba itan mega anun. Endiwa mega endi anun amba imana megawa mek mini imana amba anun.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Iesu sia wadiamon, “Waenapan wanene uniunion ya tamone, ap tane, God iman gare wanene taeta. ");
INSERT INTO dgz_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Menan wanene upine tamoa, God gare ap umap wanene taeta, amba om enua, om ame sia enueta. ");
INSERT INTO dgz_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Iwa dimen evenae wai koewa muga otu kamontu, kaiko umap, yamamupe toborini yawayan waiwanin? Go koewa ega ek mini den, kaiko baware oma ni koni mini, yamayap toborini ek ingane ya yawayan waiwanin? ");
INSERT INTO dgz_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Amba ge kaiko evenaga yamap wandini warupapen menan anega diai, ‘Enda, kaiko yamagap warupapen taian.’ Go baware yamagap toborini ya yavingi? Ame iwa dimen ap anega taingi? ");
INSERT INTO dgz_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ge da wa da ta taiana apanewa. Koewa gega baware oma nikoni mini yamagape namu warup, yangut ta kakayase, amba evenaga kaiko yamape amba warup. ");
INSERT INTO dgz_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","God nop mega kakaewa da waenapan koeragewa ya munane, iwa mu okoi mini entan ewagai sia arayain. Ap umap sia God nop oit mega kakaewa da waenapan koeragewa ya munane iwa mu tuan mini pusip am kukutnage sia entane age getao semu semu se aeta.” ");
INSERT INTO dgz_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Iesu sia wadiamon, “Mup gapan God wayawane me gare eneta. Amba imutuan anune gare me ewaeta. Amba sia tonan mega ken ken tone gare enan watapeta. ");
INSERT INTO dgz_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Iwa waenapan da da God inap pot pot mup waiwanumampina ame garewa di warain. Dim da yoa taiwanumampina ame tautanain. Amba tonan mega ken ken toiwanumampina ame munan watapeta. ");
INSERT INTO dgz_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ap mini sia, e ansena da otu waia taba buredi menan mup wapi e gare agim munai go? Ae, ap anega uon. ");
INSERT INTO dgz_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Amba mu meo menan mup wapi e gare mokare munai? Ae, ap anega uon. ");
INSERT INTO dgz_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ap menan e koevet iragen go otu waiawa kakaewa garaet munapen asigiap di, go e taiana otu kamontu. Iwa Mamanu God kimaniwa garaet kakaewa aigap tainiwa, ap menan da da God inap mup wainewa me kakae guragut yan aiman ta muniwan. ");
INSERT INTO dgz_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Menan waenapan e inayap dim dim da tat anuianawa, e mu inamup, ap umap sia tan. Iwa apan Mosis iup namua seni amba God noa waiwanumune nagire wane guegue muga ameme di.” ");
INSERT INTO dgz_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Iesu sia wadiamon, “God tuni tonanewa kampon kamponawa ame unuk aisen. Iwa negin pepetawa amba sensenawa, negin ame aeniwa, merao arewa tauen, amba waenapan arugataet negin ap amuiwanum. ");
INSERT INTO dgz_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Go inak neginewa ame kaimake den amba tonan otu koentu gapan tauiniwa, ame tau aeni inak arewa tauen, amba waenapan agiap mugenat negin ame taniwanum.” ");
INSERT INTO dgz_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Iesu sia wadidiamon, “God oit mega tave uoni waine nagirewa munan agun anun. Mu baigan mane sip umap inayap tauain, go mu potamup anan okoie wasipen mini. ");
INSERT INTO dgz_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ganongae tavewa mokot ya ieta. Amba ipuni tavewa baip ya ieta. Menan oma tavewa iamuini ame ire yao anuiana mini, e waenapan iramu muga mu tat muga gapan yao anuianawa. ");
INSERT INTO dgz_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ame umap, oma kakaewa iragi tave iamuini kakaevet, go oma koewa tave iamuini koevet. ");
INSERT INTO dgz_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ap umap oma kakaewa, tavewa koevet ya iamota, amba oma koeragewa tavewa kakae ya iamota. ");
INSERT INTO dgz_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Oma da da tavewa kakaewa ya iamopi i apane gure ireta. ");
INSERT INTO dgz_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Menan God oit mega tave uoni waine nagirewa tat muga muga gapan iramu yao kakayatait.” ");
INSERT INTO dgz_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Iesu sia wadiamon, “Orup da da, ‘Ayop nega, Ayop nega’ ap anega dianegepi, mu uruga toemu kimaniwa ya unum amoin, go da da Mamana kimaniwa ayamase tainewa, mugenat at ap me tauain. ");
INSERT INTO dgz_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Wanene uiwa wamewa gapan, waenapan arugataet inanap anega wain, ‘Ayop nega, Ayop nega, amun gega gapan God oisewa wadidiamuinton amba airampu wa oimoton tau amon amba kiman paua baware ge kiman yo paua mega ugup ugup tainton.’ ");
INSERT INTO dgz_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Go ne aroga di diamoin, ‘E ne asiginap uon. E asira aisen, e koewa taiana nagirewa!’” ");
INSERT INTO dgz_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Iesu sia wadiamon, “Ap menan da da nop nega ma iragi anu waren tayao wareyao gapan barainiwa, ame gapan i guine dena pa mega bonawan aigap tuni umap. ");
INSERT INTO dgz_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ugin visen, ningoe tauen amba taik tawak taue pa ame naseni go ya beuren, iwa sewa mega bonawan gapan di ene kakayasen. ");
INSERT INTO dgz_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Go da da nop nega anu waren go tayao wareyao gapan ya barainiwa, ame i guine uoni apanewa pa mega upun gapan tuni umap. ");
INSERT INTO dgz_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ugin visen, ningoe tauen amba taik tawak taue pa ame naseni amba unuke den beure geare orare enun.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Wam ame wan dim dim mame iragi Iesu waitameni, to iam baware ame anuiwanumune imumu yon wanden wa taragasene. ");
INSERT INTO dgz_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Iwa me wadidiamoni oisewa ame iup wadidiamuine apanewa mini da uon, go aroe amunu den wadidiamuini apane da mini. ");
INSERT INTO dgz_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Wam ame, Iesu tunup arigewa gapan aoma vise taueni, waenapan to iam baware da me ewap amon. ");
INSERT INTO dgz_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Apan daiton da vek bo’o wareni taue me namup omanip enu amba anega wan, “Ayop, gek anua gapan, tanege ne kakae tap.” ");
INSERT INTO dgz_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Iesu naniwa endimase amba apan wareni, anega dien, “Ne anuivin, kakae ta!” No utap vek bo’o gamupewa siran taran amone me inakaen. ");
INSERT INTO dgz_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Boge Iesu apan anega dien, “Endi inak mame inagap tana oisewa waenapan da ya wadiamo noga botakamian. Amba tamana age pirisi ine taua vek gega uon tani yavep. Yavepi watageta apane Mosis vek mame inak warepi gaunewa garaet God inap wanapen diagepi, ge wan. Garaet ame wanawa, ap gapan waenapan yawage anuin, ame vek gega uon tan.” ");
INSERT INTO dgz_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Wam da, Iesu pa Kaponiam aen. Pa Kaponiam unugeniwa, ita yame apanewa da, mainap taue ago wanapen menan singui anega tayaven, ");
INSERT INTO dgz_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Ayop, ne nao nega apanewa pa gapan etua in wanden amba koevet wat yapiwan.” ");
INSERT INTO dgz_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Iesu gare wadien, “Ne ongep amba wat inakamain.” ");
INSERT INTO dgz_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Wani go ita yame apanewa gare anega wan, “Ayop negawa, ne wan menan pa nega tauapan taingi, go ya taua iwa ne koerage. Go nop gega amunu den megenat wawa nao nega taini apanewa inakaeta. ");
INSERT INTO dgz_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Iwa ne, ayop nega den, apan upinewa epara muga gauarap waingina apanewa amba den ita nagire upi gauaranapewa nona wariwanum. Da ak diapena di aeta. Da onak diapena di oneta. Da nao ma ta diapena di tata. Ap menan ge wawa, ne nao nega tainiwa di inakaeta.” ");
INSERT INTO dgz_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Wam ame Iesu nop ap anuni, me no kap wan, to entaneni boge waenapan aruga evip onamone nagirewa anega diamoni, “Ne wapena anun, anu tumat nimanegeni apane ma miniwa da at Isurero gapan ya yawan! ");
INSERT INTO dgz_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Sia wapena anun, Diu uon ian ugupe nagirewa aruga at at iragi wam dotoueni amba wam geareni taue toemu kimaniwa gapan wanumoin. Omayan baewa Eibaraam ge Aisik ge Diekap taba tanam nain. ");
INSERT INTO dgz_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Toemu kimaniwa dugup megawa ame e Diu nagirewa di, go upi ya anu tumasiwaniana menan God sisipu aipa uat imaeta. At ame gapan irip wa asi kitonak wanumain.” ");
INSERT INTO dgz_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Iesu nop ame wani ita yame apanewa inap sia wadien, “Ge ak. Anu tumat nimanegeana menan ap umap nao gega taini apanewa inakaeta,” ap anega wan. Wam airase ame Iesu wani omewa gapan nao mega apanewa inakaen. ");
INSERT INTO dgz_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Wam ame Iesu Pita paewa unuk aeni, ap mepe, Saimon Pita tapunewa vek ato itanigaet tan, parata eragi gagap iniwandin yaven. ");
INSERT INTO dgz_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Iesu naniwa wareni gapan boge vek amun ame torot wan. Menan Pita tapunewa ao yone Iesu taba mega tunu wanen. ");
INSERT INTO dgz_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Amba wam augariwandiniwa, airampu waramoni nagirewa aruga tambumon me inap tauane. Iesu nop mega amunugaet waiwandini gapan airampu up oimon tau amon amba vek ugup ugup nagirewa iravi wat inakam mumen. ");
INSERT INTO dgz_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Mame tani gapan God noa wataget waiwandini apane Aisaya nop anenen wani tavewa tauen. Aisaya anega wani, Me megenat vek ato enkana angkana nugawa me wa pakisen. ");
INSERT INTO dgz_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Amba Iesu waenapan arugataet enpanane yawamoni menan me wadiamot megawa kaum awan asepa gan amopen diamon. ");
INSERT INTO dgz_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Boge ap mepe iup wadidiamuini apane da Iesu ine taue anega wadien, “Wadianiana apanewa, ne ge ewagap ongep ap at at agingawa den yona ivingat anuivin.” ");
INSERT INTO dgz_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Iesu gare anega wan, “Ewatap piup nokap wande wande arewa den amba nenip dugup muga oma onep den wandia, go Kimani Vitana Apanewa wagat wanige iana bare bare arewa da uon, menan ne evinap ongepen menan kaimake den.” ");
INSERT INTO dgz_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Wadiamot mega da me inap anega dien, “Ayop negawa, namu angep mamana boepi tup amba ongain.” ");
INSERT INTO dgz_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Go Iesu gare wadien, “Mamaga etua ae ve evinap onak. Ya anu tumat taine nagirewa vemone mu bonigawa di tumop.” ");
INSERT INTO dgz_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Boge Iesu kabum gwanap dotouen wadiamot mega den amon. ");
INSERT INTO dgz_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Amba taik aritavet da aroe den awan gagap tauen, kaum namara ao yon wanden kabum gwanewa no dotouepen tan. Go Iesu aup iniwandin. ");
INSERT INTO dgz_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ap menan, watu enamot nagirewa amon Iesu wa kandasen anega wan, “Ayop, nu nonan napen taiwan!” ");
INSERT INTO dgz_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Wane me gare wadiamon, “E anu tumat ega ne inanap otu kamontu. Iwa dimen tawa taiwanin?” Boge Iesu kaimakaet ase diamo wani gapan taik ge kaum doak ame tom wa ae bigaren. ");
INSERT INTO dgz_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Mu ap yawane tarage singui anega wane, “Akae, apan ma dime dena da? Me wani taik ge kaum nop mega anune wariwanum,” ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Wam ame asepa gan kaum eto yamunewa at yaua Gadara tauane. Apan dere ameme waenapan borit waine kaimewa sine arewa gapan me inap tauane. Mu anan taiwanumune menan, waenapan da negin ame ya amuiwanumun. ");
INSERT INTO dgz_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Iesu ine tauane nop baware anega wan, “Iesu, God otua, nu inanup dim da tat anu tauaan? Evi amba ta koeragam nimanewa oisewa anutoni go endi namu ta koeragam nimanai?” Ap anega wane. ");
INSERT INTO dgz_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Mu mainamup tuan arugataet, taba naiwanumune yawamon. ");
INSERT INTO dgz_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Airampu Iesu inap kayawantuk anega wane, “Ge up oine tau anetawa, watu enane tuan potamup unuget.” ");
INSERT INTO dgz_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Iesu gare anega wan, “A, umap, tau aisen!” Iesu anega wani gapan, airampu apan ae vean tau amon tuan potap unumon. Unumone tuan togana serarat vitan kauma geamon none namon. ");
INSERT INTO dgz_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Tuan kwayup taine nagire yawamone tap serarat amon, pa sewa bawarewa tauan, oit mame iragi wadidiamone, apan dere airampu waramone oitamu den wan. ");
INSERT INTO dgz_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Boge pa sewa bawarewa uruga Iesu yawapen tauane. Amba wam ame Iesu yawane, mu kaimakaet anega diane, “Enda, ge at nuga ae ve ak.” ");
INSERT INTO dgz_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Iesu kabum gagap dotoue, kaum gamu to ketnage ase pa mega tauen. ");
INSERT INTO dgz_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Amba apan upi, pusi nani itani wani apanewa da eragia baraen waran tauan. Amba Iesu mu anu tumat muga me inap aritavet tane yaveni menan Iesu vek apanewa inap anega wan, “Apan negawa, ne koewa gega anun ae viangin.” ");
INSERT INTO dgz_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Mame gapan, iup wadidiamuine nagirewa upi muk ingane anega wane, “Apan ambe da tauen, nop God mini ta wat wan taiwan?” ");
INSERT INTO dgz_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Singui muga, Iesu imua anuni menan gare wayawamon, “Iwa dimen imuya potaya gapan anu koeam nimanek wanin? ");
INSERT INTO dgz_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ne nop daitonawa wana vek apanewa koewa mega anu ae viangin, o nop derewa ame manega wapena, ao yone aep, kaimake dena ansenawa? ");
INSERT INTO dgz_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Go e asigip taepen menan, Kimani Vitana Apanewa piupa waenapan koewa muga anu ae vepen menan aro amun warana ame endi to ewayain.” Amba Iesu vek apanewa sia anega dien, “Ne endi diagiangin, ao yon eragi gega wat pa ak!” ");
INSERT INTO dgz_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Wani boge no utap, ao yon wande eragi mega ware, boge pa mega aen. ");
INSERT INTO dgz_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ame gapan to iamene nagirewa mame yawane, potamu tap bararaen, amba God wa atonasen, iwa aro amun ma miniwa, God waenapan muneni menan. ");
INSERT INTO dgz_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ap mepe Iesu ap use aiwandini, me apan da yaua Matiu yaven, me moni bogamine paewa gwanap ae wanden. Iesu me anega wadien, “Evinap onak.” Boge Matiu ao yon wande me ewap aen. ");
INSERT INTO dgz_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Amba Iesu wa ewamot mega den Matiu pa mega gapan taba naiwanumune. Ap mepe moni bongamine ge koewa taine nagirewa tauan den tanam wanumone. ");
INSERT INTO dgz_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Parisi nagirewa upi mame yawane menan, Iesu wa ewamot mega singui tayawamon, “Iwa dimen wadiaet egawa moni bongamine amba koewa taine nagirewa den tanamon taba naiwan?” ");
INSERT INTO dgz_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Iesu nop muga anuni gare anega wan, “Vek nagirewa nuat apanewa menan anu guriwanum go kakaewa nagirewa nuat apanewa menan ya anuiwanumun. ");
INSERT INTO dgz_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Go aisen anuan sese tan, God wani tavewa anu kakayasen. God anega wan, Man toyan nenan iriana menan ne ya anuivin go Imuya potaya waenapan inamup warapen menan anuivin.” Iesu God nop mega semu ame wani sia wadiamon, “Menan ne muk ingane kakaewa anune nagirewa munan ya tauan, go koewa taine nagirewa imu posewa ge inak muga entan tapen menan tauan.” ");
INSERT INTO dgz_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Wam da apan Dion, waenapan dup iamuini apanewa, wa ewamot megawa Iesu ine tauan singui wayawan, “Iwa dimen nu amba Parisi nagirewa den, God menan pot pot sinunu in dorivin amba God inap mup waivin. Go wadiamot gegawa God menan sinunu in ya doriwanum?” ");
INSERT INTO dgz_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Iesu gare anega wan, “Naine mutat i apanewa barip mega gapan wandepiwa me evene waiwa sinunu in ya dorain, iwa aton anuiwanum. Go wam evi da tauepiwa, naine mutat i apanewa waseam wat nau amopiwa, wam ame gapan sinunu in dorain, bagu sisi anupi menan.” Ame wani tavewa naine mutat i apanewa Iesu me di. ");
INSERT INTO dgz_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Amba iup namua ge iup ewakewa guegue mega wadiamopen menan Iesu maibe gapan manega wan, “Waenapan wanup namua bebep wapi nadi warapen men semu ewakewa ya wabenagep. Wabenagepi ewakewa den koe tata amba wanup gine daiton uon, da vevera da kaimake den menan bebep baware wata. ");
INSERT INTO dgz_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Guegue da sia mam. Apan da kaum wain ewakewa man etu namua kaum menan taginamene gwanap ya wa damagep. Damagepi kaum mek tutut wapi etua tuk wata amba kaum wa damagep etua den koe tata! Menan kaum wain ewakewa man etua ewakewa gapan damagep, ap tata dere dere kakaevet di wanumoin.” Iesu ap anega wadiamon. ");
INSERT INTO dgz_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Me nop mame waiwandini newap, Diu nagire ayop muga da ine taue amba namup omanip enu anega wan, “Ne orana gaset boen. Go age naniga aigap barae, me inakaep.” ");
INSERT INTO dgz_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Wani boge Iesu yone apan evip aen, wadiamot megawa den amon. ");
INSERT INTO dgz_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Waen da en aonagaet pusinawan dere vek ewatop taiwandin. Iesu ap aiwandini gapan waen ame garivi taue wanup mega ginewa inasen. ");
INSERT INTO dgz_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Waen mek ingane anega anuni, ‘Ne wanup mega gine otu da megenat inatapenawa, ne inak warain,’ ap anega anun. ");
INSERT INTO dgz_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Inaseni Iesu to entane waen yave anega wadien, “Orana, gop ya anu. Anu tumat nimanegeana menan inak wariagi.” Amba wam koni otu ame gapan waen ame inakaen. ");
INSERT INTO dgz_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ap ewap Iesu Diu nagire ayop muga ame pa mega unugeni viriko upuniwanumun, amba to iam baware ame nop gede gede waiwanumune yawamon. ");
INSERT INTO dgz_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Me anega diamon, “Ae vean tau aisen. Orup waen ma bop ya tan go aup iniwan.” Ap wani menan waenapan verea kaura tan top wane. ");
INSERT INTO dgz_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","To iam baware ame wa oimon nambae vitane ewap, Iesu orup waen ine ae nanip waren, boge ao yon wanden. ");
INSERT INTO dgz_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Mame tani oisewa wasenamene at gine ame senare tau aen. ");
INSERT INTO dgz_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Iesu at ame ae ve, ap use aiwandini, apan dere yame borat mutanewa me ewap amon, ven anega kaimakaet waiwanumun, “Apan Devit naewa, nunan baguk sisi anu.” ");
INSERT INTO dgz_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Iesu ae pa gwanap unuk aeni gapan, mu inap tauan, amba Iesu singui anega tayawamon, “Ne amun nega gapan wat inakam imaepen men anu tumat nimanek wanin go?” Mu gare wane, “E, Ayop nugawa nu ap menan di anuivin.” ");
INSERT INTO dgz_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Boge me yamamu inase amba anega wan, “Yamaya yangut tat anu tumat tayana menan e inak itai.” ");
INSERT INTO dgz_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Me ap wani gapan mu yamamu kakae sia tan yawan. Amba Iesu tagigit kaimakaet anega diamon, “Orup da mame asik tapi tawa agun yao anun.” ");
INSERT INTO dgz_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Go mu tau amonewa, me oisewa at ame iragi wa sesenamene. ");
INSERT INTO dgz_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Mu tau amuiwanumune newap, apan da nop ya waini iwa airampu potap wandeni menan waran Iesu ine tauan. ");
INSERT INTO dgz_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Iesu airampu ame wa oisen tau aeni, boge apan ame nop wan. Menan to iam baware ame tarage anega wane, “Manegawa anenen? Nu ma miniwa namu at Isurero gapan da ya yawaton.” ");
INSERT INTO dgz_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Go Parisi nagirewa nipep anega wane, “Airampu bawarewa mugawa Seitan amun mega Iesu waneni gapan Iesu airampu upi wa oimuiwandin tauane amuiwanum.” ");
INSERT INTO dgz_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Iesu pa sewa bawarewa amba otu koentua iragi tau ge tau aen, iup anuine paewa gwanap kiman toemu mega Oise Kakaewa wadidiam wandin amba vek ato engkana angkana nagirewa gine ugup ugup wat inakam mumiwandin. ");
INSERT INTO dgz_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Me waenapan arugataet yawamoni imu pose munan anu guren. Gop anune iwa mu ago muga uon, ame man sip kwayup taini mini kwayup tamuini apane da uon, nutumu uon amba itan bagu sisi wariwanumun. ");
INSERT INTO dgz_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Boge me wadiamot mega anega wadiamon, “Yawan. Maup inin geraget taiwan go daupam taine nagirewa otu agiap da. ");
INSERT INTO dgz_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ap menan maup Ayopewa inap mup wan amba me daupam tata nagirewa watu enamop, bongamepen amop.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Iesu wadiamot mega aonagaet pusinawan dere munan wan tauane, amba aro amun mega vek nagirewa wat inakam mumapen amba airampu wa oimopen menan munen. ");
INSERT INTO dgz_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Watu enamot mega nagirewa yaumua mam. Namu iragen Saimon (yaua dawa Pita), amba gwaniwa Anduru amba Diemis ge gwaniwa Dion, mu dere apan Sebedi otu waiwa. ");
INSERT INTO dgz_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilip amba Batolomio amba Tomas ge Matiu (me moni bongamini apanewa) amba Diemis, apan Alopias otua, amba Tadias. ");
INSERT INTO dgz_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Upine den ame, Saimon (at daitonawa nagirewa munan anu waini apanewa) amba Diudes Iskeriot (Iesu omine evi wapi apanewa). Watu enamot mega nagirewa yaumua ameme. ");
INSERT INTO dgz_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Apan aonagaet pusinawan dere mame, Iesu nop den pusiga pan pan tamo amba watu enamo, anega wadiamon, “Diu uoni ian ugupe nagirewa yaumakamup ya tau aisene o ian Sameria pa sewa mugawa da ya unugene. ");
INSERT INTO dgz_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Mu ae vemon go pa Isurero nagirewa inamu aisen iwa mu man sip mini pua amone. ");
INSERT INTO dgz_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Aisen oit ma opata gapan wan, ‘Kiman toemu mega di mananiwan,’ anega wadiam wadiam aisen. ");
INSERT INTO dgz_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Vek nagirewa wat inakam muman, borit wanewa sia inak muse yon wanumot wane mu da da etu sitat kakae tap, airampu waramoniwa wa oimone tau amop. E garaet warayana menan e gare garaet wat agoat muman. ");
INSERT INTO dgz_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ap aisene, moni agim make tutup gine ugup ugup ya tambune, ");
INSERT INTO dgz_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ap ega menan ik enagun da ya enane, en wanup daiton daiton megenat tambun. O pusia okomewa o kaipat den ae sean mondigataet di aisen. Iwa dim da da menan bambam tanewa waenapan enepi e waran. ");
INSERT INTO dgz_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Pa sewa ansena da e unugenewa, baigan apane ap mepe yoa tayawan tanane amba pa mega gapan wanien ene amba sia aisen. ");
INSERT INTO dgz_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pa ame unugenewa, gaun munan iramu yawamon. ");
INSERT INTO dgz_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Pa ame baigan amba ago nagirewa wanumopiwa, nonup ega pa ame gapan wandep. Go mu ya waup imaepiwa, God inap mup wa, God wat aipakam mega mu inamup ya wandep. ");
INSERT INTO dgz_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Waenapan ansena da ya waup imaepi o nop ega ya anupi pa muga ame ae vean aisen, koewa muga ae bat munapen menan pusia atabobo toninigamen aisen, ame tane yam tatak munapen. ");
INSERT INTO dgz_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ne tavewa di wadiaivin. Nop nega mondi uon anun di waivin. God wanene mega wamewa gapan, pa sewa da da e ya waup imaene, koewa tane pa sewa Sodom ge Gomora nagirewa God wanene mega arita warane omewa mini ya yawain go pa ameme baware iragen yawain.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Iesu sia wadidiamon, “Wapena anun, e man sip otua ame baigan mane umap watu enaivin go waenapan anan eyaoe wasipen umap nimakamup waniai. Ap menan mokare Dimat asik mega mini tan amba nenip bairantan ugu wat museni mini wanien. ");
INSERT INTO dgz_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Waenapan tamu gop agun anun, iwa mu tambue amo wanene paewa taue amba iup anuine paewa gwanap gaut gapan gurayain. ");
INSERT INTO dgz_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","E ne dugup nega nagirewa menan, wanene taepen menan ayop bawarewa nagire ugup ugup namup tam nauyae amoin. Mame gapan, oitana wadidiamone Diu uon ian ugupe nagirewa den anupen menan. ");
INSERT INTO dgz_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Go wam ame e tambuepiwa, dim da o anenen wawa menan gop ya anune. Iwa wam ame nop wapen tanewa God nop dim da enep di wai. ");
INSERT INTO dgz_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Menan ame e nop ega da uon, go e Mamaya Guewa nop e gamuyap waiwandata. ");
INSERT INTO dgz_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ap wamewa gapan, tase gwani gare gare omine wap borit wain, amba ine mame wai muk orup mugawa omine wain, amba otu waiwa ugu gangan ine mame inamup tain, ap tapi gapan upi taue ine mame guramo boniga semoin. ");
INSERT INTO dgz_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Waenapan iragi nenan tandayat imayain, go e da tumban amun ae yonanewa, wam verisiwa gapan e inak warai. ");
INSERT INTO dgz_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Wam ame at daiton gapan wa kokoeragam imaepi, ae vean, tap serarat at da ugup aisen. Ne tave di wadiaivin, God No Oise Kakaewa wadiamopen menan e at Isurero sewa muga iragi ya tauitamai, go namu Kimani Vitana Apanewa tauain. ");
INSERT INTO dgz_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Wadiamot nagirewa wadidiamuine mugawa paina ya yamasep, amba nao nagirewa ayop mugawa paina ya yamasep. ");
INSERT INTO dgz_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Menan anut yoa taine nagirewa wadiat mugawa mini tap, amba nao nagirewa bawarewa mugawa mini tap. Ne dugup da ayopewa Bieseboro, yaua dawa Seitan, koerage eboewa dianegene menan dugup nega nagirewa, wagup koerage aigap sia diamoin.” ");
INSERT INTO dgz_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Iesu sia wadidiamon, “Ta koeragam imaine nagirewa tamu ya tane. Endi dim dim iravi ukum umane evi amba God aroga watapeta. Amba endi dim dim iravi gungunu tainewa evi amba yao anuin. ");
INSERT INTO dgz_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Dim da ne sisip gapan karaua wadiaena, e aroga wam ganasewa gapan waenapan wadiamon. Amba dim da simura darinayap wadiaena, e namboya aroga wadiamon. ");
INSERT INTO dgz_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mu da etuya togurep boepi menan tamu ya anune iwa guaya den ya togurain. Go God tawa taiwanian iwa etuya ge guaya dere dere oma meravewa gapan wa koeragam mumeta. ");
INSERT INTO dgz_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Muguap dere garewa ame agim make dendeniwa daiton gapan une taiwanum. Go ame daiton da Mamanua God ya anuini gapan pia ya geare boeta. ");
INSERT INTO dgz_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Amba ap mini sia, me enan aigap anuini menan iae gumewa daiton daiton iae bonewa gapan me iragi batnak itamen. ");
INSERT INTO dgz_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ap menan dim dim menan tap ya anune. Iwa God yamap muguap aruga ame bawarewa da uon go e God yamap bawarewa di.” ");
INSERT INTO dgz_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Iesu sia wadiamon, “E da da oit negawa waenapan wadiamonewa, gare ne Mamana kimaniwa e ne wa ewamot nagirewa diain. ");
INSERT INTO dgz_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Go e da da waenapan namup tandayat nimanegenewa, Mamana kimaniwa namup waboborayain.” ");
INSERT INTO dgz_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Iesu sia wadidiamon, “Ne nonup piupa wat onge tauat ya anun, go ne nonup ya waran ongen go ita anan wat tauan. ");
INSERT INTO dgz_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ne nop nega anu tumasepen o ya anu tumasepen menan mame otu dere notatae wain amba ine ore dere notatae wain, amba e wagini dere anu tumasepen o ya anu tumasepen men den notatae wain. ");
INSERT INTO dgz_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Menan e anavi ega aigap iragenawa ame e dugup ega daitona nagirewa di. ");
INSERT INTO dgz_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Orup da me ine mame o otu wai go ore wai munan bumaga tantan anun amba nenan otu koentu anuiwandapinawa, ame ne wadiamot nega da uon. ");
INSERT INTO dgz_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Menan orup da ne wadiamot nega tat anupiwa, namu me mek dim da anuini tandayase, ae di vep, amba ne yauna menan, pot poraet ugu vegaek bagu sisi anu, evinap oniwandan. ");
INSERT INTO dgz_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Amba orup da da muk inak mugawa menan anu gurane tainewa, ame inak muga wakaumain, go orup da da mu inak muga nenan anu gure wakaumepiwa, mu inak kakaewa tautanain.” ");
INSERT INTO dgz_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Iesu sia wadiamon, “Waenapan da da waup imaepiwa ne den waupanegain. Amba da da waupanegepiwa, ame Mamana watu enanegeni den waupain. ");
INSERT INTO dgz_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Apan da yone evenewa God nop mega waini menan waupepiwa, me God nop mega waini apanewa, ame garewa mega om daiton God inap wareta. Amba sia apan da yone evenewa God menan kakaewa taini menan waupepiwa me God menan kakae taini apanewa, ame garewa mega om daiton God inap wareta. ");
INSERT INTO dgz_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Amba waenapan da da kaum kasigawa use wa ewamot nega nutu uoni da wanepiwa, ne tave di wadiaivin, ne inap anu bambamat da uon, orup ame garewa mega kimani wareta.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Iesu wa ewamot mega aonagaet pusinawan dere nop pusi pan pan tamon uon tani ewap, me ap mepe use sia ae, sewa arugataet, at Galili gapan, tau ge tau ae opata wadidiam wandin. ");
INSERT INTO dgz_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Wam ame, Dion, waenapan dup iamuini apanewa, gwat nokap wandeni gapan, Keriso anenen taiwandini oisewa anun. Menan wadiamot megawa upi watu enamon Iesu ine tauan. ");
INSERT INTO dgz_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Amba Iesu inap singui anega wayawan, “Nu amase taintoni Keriso ge me di go gare apan da ugup tauapen amase tait?” ");
INSERT INTO dgz_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Iesu gare wadiamon, “Ewagai sia aisen, anenen yao anuiwaniana Dion wadian. ");
INSERT INTO dgz_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Yame borat mutane nagirewa sia yangut taiwanum, pusiwa wabeberugaseni nagirewa ap sia amuiwanum. Vek bo’o nagirewa sia inak musiwanum, darine borat mutane sia anuiwanum. Bop tane nagirewa sia inak mutane yon wanumuiwanum. God No Oise Kakaewa kayakayawan taine nagirewa wadidiamuivin. ");
INSERT INTO dgz_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Waenapan ne dim dim wa taingina menan ya tandayat nimanegepiwa aton anuiwanumain,” Iesu ap anega wadiamon. ");
INSERT INTO dgz_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Boge, Dion wadiamot megawa sia entan amone. Ap gapan, Iesu Dion oisewa ap mepe wanumune nagirewa anega wadiamon, “Dion yawapen menan at kaimewa aiseana, dim da yawat anuyan? Taik unawat payagameni tawagewa yawapen aisean go? ");
INSERT INTO dgz_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ame uon wandepi e dim da yawapen menan aisean? Apan da wanup ganganataet eneni yawapen menan aisean go? Anun, wanup kakaewa enine nagirewa ame ayop yau taneni pa muga gapan ininewa, go at kaimewa gapan da uon. ");
INSERT INTO dgz_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Go endi e dim da yawapen men pua aisean? God nop mega waini apanewa da yawapen aisean go? E, ap me di. Wapena anun. Tave di Dion apan ap me di go me aigap iragenawa. ");
INSERT INTO dgz_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ap menan wataget God Dion oisewa wani ok anega seane, Wapena anun. Ne oit nega wapi apanewa namu watu enapen, negin genan wa taraseta. Ok ap anega sean.” ");
INSERT INTO dgz_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Iesu sia anega wan, “Menan ne wadiaepena anun, waenapan iragi yanane yaumakamup Dion megenat aigap. Go kiman gueguewa iup ewakewa gapanawa ame, evi amba God toemu mega gapan orup da God navewa otu kamontu iragena tapi, watat aigapewa wareta, go Dion me gauarap wandeta iwa Dion iup namua gapan taueni apanewa. ");
INSERT INTO dgz_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Wataget Dion dup iam wandini wamewa gapan onin eni endi mame tauen, piup nagirewa upi God toemu mega amunua kaimakaet nanamasep yon borapen menan anun. ");
INSERT INTO dgz_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","God nop mega wataget waiwanumune nagirewa, apan Mosis den, God dim evi tapi noa waiwanumun ene amba Dion tauen. ");
INSERT INTO dgz_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Menan watageta nagirewa Elaidia sia tauat wane, apan ame Dion, ma me di. Nop mame anu tumat tai go? ");
INSERT INTO dgz_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Menan darinaya den wandepi, ae anun.” ");
INSERT INTO dgz_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“E Diu nagirewa inat waniet ega gueguewa dim da umap? E orup otu iamene kae taine umap. Mu toga uaren gare gare ise ma anega waiwanum, ");
INSERT INTO dgz_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nu sinao enan toivin go e tarep ya taiwanin. Nu urae angingin enan waivin go irip turup ya waiwanin!’ ");
INSERT INTO dgz_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Tavewa ame mam, Dion waenapan dup iamuini apane yoneni God men taba virip viwandin kaum wain da ya nan. Ap tani menan e noyam anega wayan, ‘Airampu da potap wandia.’ ");
INSERT INTO dgz_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ap anega wayan, go ne Kimani Vitana Apanewa tauana taba kaum wain den naingin menan anega noyam wayan, ‘Apan ase yawan! Me taba paututuma naiwan amba kaum wain pot pot naini menan bumbawam taiwan. Amba den moni bongamine ge inak koewa taine nagirewa evenan tamon.’ E ap anega wayan, go God nop mega tavewa di wandia. God dim da da me waenapan gamumup ta oniwandini ame God anuini taine nagirewa mu wa ewamoin.” ");
INSERT INTO dgz_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Amba Iesu pa ugup ugup nop kaimakaet diamon. Iwa namu inamup ae kiman paua baware ugup ugup wa taiwandin yawane go koewa muga ae ya veane. ");
INSERT INTO dgz_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Iesu itan baware inamup tauepi oisewa namu manega wadiamon, “Kaiwan, pa Korasin Diu nagirewa, kaiwan, pa Besaida Diu nagirewa, itan baware yawai. Iwa yaumakayap yo baware taingina go ame Diu uoni nagirewa pa Taya ge pa Saidon ya yawan. Yawapo koewa muga ae ve yamu entanepo bagu sisi magunewa wara wanumopo. Go e yo baware taingina yawayan go imuya potaya ya entanean. ");
INSERT INTO dgz_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Menan God wanene mega wamewa gapan, pa Taya ge pa Saidon nagirewa itan yawain go e itan baware iragen yawai. ");
INSERT INTO dgz_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Den ian Diu nagirewa pa Kaponiam gapan. Ek anuyan taiana gapan kiman dot aitai go? Ae, ya dot aitai go God merao arewa gapan uatam imaeta. Iwa yo paua ame e inayap taingina watageta pa Sodom nagirewa ya yawan. Yawapo God pa muga ya wat momagepo. ");
INSERT INTO dgz_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Wapena anun. God wanene mega wamewa gapan, pa Sodom nagirewa itan yawain go e itan baware iragen yawai.” ");
INSERT INTO dgz_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Wam ame gapan Iesu Mamewa inap mup anega wan, “Maman, ge piup kiman ayopewa. Ne gaun inagap waiangin, iwa anut bawarewa nagirewa nop maibe tavewa anuine nagirewa den nop gega ya anu awapen men karaua baraean, go ok ya tane nutu uoni nagirewa nop gega wa ewamoan. ");
INSERT INTO dgz_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tave di, Maman, ap venasepen menan atonu den anu taan.” ");
INSERT INTO dgz_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Iesu sia anega wan, “Ne Mamana dim dim iragi nanin gwanap sen. Amba ne God otua ame waenapan da asigimup ya tanegene go Mamana megenat ne me Otua asigip tanegen. Amba sia waenapan da Mamana ya asigimup tane go ne, me Otua, ne negenat asigip tan. Ap menan ne Mamana guegue megawa waenapan da da ta ewamot anupena di ta ewamoin.” ");
INSERT INTO dgz_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Iesu sia anega wan, “Ne inanap onaen, iragi itan ega ega baware tambu panop to onai wanian garia yaveni, menan iragi wagat enain. ");
INSERT INTO dgz_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ne panop nega waran amba inanap anu awan, iwa ne ayamat bibiga taina apanewa, ap gapan e guaya wagat tautaneta. ");
INSERT INTO dgz_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ne panop nega itani den uon go bemta.” ");
INSERT INTO dgz_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Diu pura muga bawarewa wamewa gapan da, Iesu nao egak da, maup taue wandeni, ame berip aiwandin. Wadiamot mega den amon, enup aramoni menan mu taba uit verane maup taue wandeni makewa kukunagen tavewa nane. ");
INSERT INTO dgz_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ame gapan, Parisi nagire upi yawamo anega wan, “E iwa dimen pura bawarewa iup nuga paina yamat wanin?” ");
INSERT INTO dgz_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Iesu gare anega wadiamon, “Wataget da apan Devit evene wai den enup aguguramon tane oisewa ok gapan e iravi batnak anuyan. ");
INSERT INTO dgz_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Devit evene wai den, enup aguguramoni menan God Paewa unuk amon amba God men taba buredi tugu seane, ian pirisi mugenat nainewa, ame iup mega den go mu tambu nane. ");
INSERT INTO dgz_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Den apan Mosis iup namua seni batnagean go uon? Nop ame anega waiwan, wagat wamewa gapan pirisi God Paewa gwanap nao tainewa menan mu wagat wamewa iup mega to paisiwanum. Go mame gapan God yamap mu koewa da ya tane. ");
INSERT INTO dgz_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Go wapena anun. God Paewa baware, go aigap iragenawa mame endi tauen. ");
INSERT INTO dgz_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","God watagaet ok seni tavewa e anu kakayasean go uon? God anega wan, Man nenan iriana menan ne ya anuivin go Imuya potaya waenapan inamup warapen menan anuivin, ap anega wan. Nop ma tavewa da e asik tapo, wadiamot negawa koerage ya diamopo amba uniunion ya diguguramopo. ");
INSERT INTO dgz_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Iwa ne Kimani Vitana Apanewa pura bawarewa ayopewa menan ne dim da umap wapena, ameme di.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Iesu at ame ae ve, amba iup anuine paewa gwanap unuk aen. ");
INSERT INTO dgz_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Apan da, naniwa nutup parakaeni, ap mepe den wanden. Iup wadidiamuine ge Parisi nagirewa den Iesu enu yave wapen anune menan singui wayawan, “Iup nuga anenen waiwan? Apan da wagat wamewa gapan vek apane da wat inakamepi ame iup to paiseta go uon?” ");
INSERT INTO dgz_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Me gare wadiamon, “E ansena da man sip ega, wagat wamewa gapan, urata gearepiwa, pan warup barai go uon? ");
INSERT INTO dgz_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Man menan anuiana otu koentu go waenapan munan anuiana ame aigap iragen. Ap menan apan da wagat wamewa gapan inak kakaewa da tapi ame iup paina ya yamasiwan.” ");
INSERT INTO dgz_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Boge me apan die anega wan, “Naniga endimat.” Menan me endimat anuni boge naniwa dawa mini kakae tan anun. ");
INSERT INTO dgz_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Go Parisi nagirewa pa ae ve amone amba Iesu to boniga baraet wan nopewa paniwanumun. ");
INSERT INTO dgz_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Iesu togurapen oisewa waiwanumune anuni menan, totnage at ame ae ve aen. Waenapan aruga me ewap amon. Me vek nagirewa mugawa iravi wat inakam mumen. ");
INSERT INTO dgz_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ap tani oisewa tagigire diamon me oisewa da ya wapen. ");
INSERT INTO dgz_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Menan watageta God no oise waiwandini apanewa Aisaya wani tavewa tauen. God Aisaya gamup anega wan, ");
INSERT INTO dgz_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Mame ne nao nega apanewa, ma ne om enunawa, me menan anu gurinawa, amba imuna ae bigarin aton anuinawa. Ne Guana me aigap barain amba me amun nega gapan, ian ugupe nagirewa wat inakam mumapena nopewa wadidiamota. ");
INSERT INTO dgz_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Me notatae ya wata o kaimakaet negin gagap ve ya wata. ");
INSERT INTO dgz_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Gaian gua kwekwerawa ya to imokameta, amba dun otu koentu yagiriniwa me ya wa gureta, ap mini nutu boeni nagirewa, ya wa koeragam mumeta o diguguramota. Go tayaviwandan amba nop tamanawa gapan, koewa garao mumeta. ");
INSERT INTO dgz_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","At at iravi, piup mame gapanawa, anu dao muga me inap tain. ");
INSERT INTO dgz_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Waenapan upi naumon Iesu inap tauan, apan da yame borasen nop ya wainiwa, iwa me airampu potap. Iesu apan ame wat inakameni, me yangut ta nop wan. ");
INSERT INTO dgz_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Waenapan iravi ap yawane gapan seke tan tarak anega wan, “Iesu me Devit naewa Keriso go?” ");
INSERT INTO dgz_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Go Parisi nagirewa, ap anune gapan, nipep anega dian, “Airampu bawarewa mugawa, yaua Bieseboro, amun waneni gapan me airampu up oimuiwandin tau amuiwanum.” ");
INSERT INTO dgz_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Go Iesu mu imumu gapan dim da anune mek anuni menan anega wadiamon, “Toemu da da engirit wangirit ta waiwanumampina dumari amoin. Amba sia dugup da todum wadum taiwanumampina mu iragi ora amoin. ");
INSERT INTO dgz_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Menan ne Seitan ago megawa wandepo ap gapan airampu mega wa oisepenawa ame Seitan toemu mega endumeta, ap gapan toemu mega uon di tata. ");
INSERT INTO dgz_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ne airampu Bieseboro aroewa gapan wa oitapo dugup ega nagirewa airampu wa oimop tau amopi amun da muneni gapan taiwanum? Bieseboro munen go? Ek wadiamot ega ap anega diguguramopo mu gare ebo diaepo. ");
INSERT INTO dgz_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Uon, ne God Guewa amun neneni gapan airampu wa oimuivin. Ap taina menan God toemu mega amunewa inayap tauen. ");
INSERT INTO dgz_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Seitan me aro apane mini da. Menan up apane anenen amba aro apane paewa unuge amba kwan puraput mega tambuta? Up tat anupiwa, me namu aro apane ware damiga pane barae amba kwan puraput tambuta. Ap mini ne Seitan aroewa yamasen.” ");
INSERT INTO dgz_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Iesu sia wan, “Waenapan da da me imua inanap ya wandiniwa, orup ame tandayat nimanegen taiwan. Amba sia orup da ya tananegen nao ya tainiwa, ame ne nao nega wa koeragamiwan. ");
INSERT INTO dgz_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Nop nega mondi uon anun di waivin. God waenapan koewa muga ge wawa koko muga taine iragi anu ae veta. ");
INSERT INTO dgz_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Amba orup da da Kimani Vitana Apanewa inanap nop koevet wapiwa, God koewa mega ameme anu ae veta. Go orup da da God Guewa inap notatae koevet ta wapiwa, God koewa mega ame anu ae ya veta, ame wam endiwa amba wam eviwa den anu ae ya viwandata.” ");
INSERT INTO dgz_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ap me menan Iesu Parisi nagirewa inamup sia anega wan, “Oma kakaewa, tavewa kakaewa iamota, amba oma koeragewa, tavewa koeragewa iamota. Ap gapan oma daiton daiton tavewa iepi irewa mega gapan gapan yavinewa. ");
INSERT INTO dgz_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","E iae guine itap atap mokare mini taianawa, anenen amba nop kakaewa gamuyap venaseta? Ame uon di. Iwa koewa kakaewa imu pose no dotouen arasiniwa gamup nomu gapan nop waiwanum. ");
INSERT INTO dgz_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Menan, apan kakaewa, wan dim dim kakaewa mega imu pose gapan enen waboren wandini tambun taiwan, amba apan koerage, wan dim dim koerage imu pose enen waboren wandini tambun taiwan. ");
INSERT INTO dgz_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Go ne wadiaivin, wam uiwa gapan da da nop koe koevet wane garewa wanene warain. ");
INSERT INTO dgz_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Iwa wam uiwa gapan e nop ega kakaewa koewa diaepi omewa gapan wanene taeta.” ");
INSERT INTO dgz_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Boge Parisi upi ge iup wadidiamuine nagirewa den me inap anega wane, “Wadianet nugawa, kiman yo mega da ta nu yawat anuivin.” ");
INSERT INTO dgz_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Wane go Iesu gare wadiamon, “E yo ugup ugup paua mega yawat anuyan waiwanin iwa inak ega koevet iragen, ya anu tumat nimanegiwanin! Go kiman paua mega da ya enain go Diona yo paua mega megenat yawai. ");
INSERT INTO dgz_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Iwa Diona wam yampo ge mum yampo meo bawarewa da bagup wande en, ap umap Kimani Vitana Apanewa piup nokap wam yampo ge mum yampo wanigain. ");
INSERT INTO dgz_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Menan Nineva nagire e endi iniana nagirewa den yone digugurayain iwa apan Diona opata wadidiamoni gapan pa Nineva nagirewa koewa muga ae vean imumu wat entanen. Diona apan bawarewa di, go apan da Diona aigap wandini mapa wandia! ");
INSERT INTO dgz_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Watageta ayope Solomon nop dima mega baware anupen men ayop waen da yaua Siba at wandap onen. Solomon anut mega baware go apan anut baware iragenawa da endi taueni wandia go nop mega ya anuiwanin. Ap menan God wanene taepi wamewa gapan ayop waen Siba ame e endi iniana nagire den yone diguguraeta.” ");
INSERT INTO dgz_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Iesu nop da sia wan, “Airampu apan potap taue aen, at darakawa arewa none enu wande wande arewa yop taiwandin go da ya yaven. Ya yaveni menan ");
INSERT INTO dgz_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","anega anun, ‘Ne pa nega namu wanigena ap menan sia entan angain.’ Ae taueni apan ame posewa kakae, pa tarase dim dim sese kakayat taine mini yaven. ");
INSERT INTO dgz_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Menan sia ae airampu koerage iragenawa nani yamunaet yamu dere tanam tauen boge apan potap unum wanumon. Namu airampu daiton wandeni gapan anan otu da taiwandin go evi aruga potap unumone gapan airampu anan aigap iragen taiwanumun. Ap umap, wam uiwa gapan, e Diu nagirewa, inak koewa gapan iniana menan itan baware ame yawai.” ");
INSERT INTO dgz_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Iesu iam baware ame inamup nop waiwandini newap, me inewa ge gwani waiwa pa garip yoniwanumun, Iesu inap nop wapen amase taiwanumune. ");
INSERT INTO dgz_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Orup da Iesu anega wadien, “Inaga ge gwanik waiga yawagepen menan tauane, itapa pa garip yoniwanum.” ");
INSERT INTO dgz_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Go Iesu gare wadien, “Inana ge gwanin wainawa da?” ");
INSERT INTO dgz_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Boge Iesu wa ewamot mega inamup nani piru enumo amba anega wan, “Ne inana ge gwanin waina mame di! ");
INSERT INTO dgz_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Waenapan da da ne Mamana kimaniwa nop mega anune amba gueguewa tainewa ame ne inanawa amba gwanin wainawa.” ");
INSERT INTO dgz_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Wam ame daiton gapan Iesu pa ae ve ae kaum awan etop wanden. ");
INSERT INTO dgz_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Waenapan arugataet nop mega anupen menan tauan enpanane. Ap menan Iesu kabum gwanap dotou ae wanden, amba waenapan gerata yonan. ");
INSERT INTO dgz_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nop aruga maibe gapan anega wadidiamon, “Apan da oma makewa mega verapen menan aen. ");
INSERT INTO dgz_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Nao mega gapan uasiwandin, upi negina geamon, waenapan aigap amu tau amon amba boge nenip tauan enun nan. ");
INSERT INTO dgz_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Amba makewa upi agim gagap geamone ap mepe piup baware uon. Oma makewa tuk tak wan serarat yanan, ");
INSERT INTO dgz_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","kai warane go wam dotouini gapan, serarat kurat wan, iwa visimu bobou. ");
INSERT INTO dgz_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Makewa upi ganongae berip geamone amba kai waran go gaian yan doran umamon boge borit wane. ");
INSERT INTO dgz_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Amba makewa upi piup kakaewa gapan geamon. Ame yanan dorane tavewa iamoni arugataet mek arugataet da iam ge iam tan. Tavewa apane nani yamunaet (100) o apane yampo (60), o apane daiton aonagaeta mini aigap iamon. ");
INSERT INTO dgz_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Darinaya den wandepi nop nega anun!” ");
INSERT INTO dgz_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Iesu wadiamot mega ine tauan singui anega wayawan, “Iwa dimen waenapan inamup maibe gapan diamuingi?” ");
INSERT INTO dgz_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Me gare anega wan, “God toemu mega karaua wandini tavewa watap enen gase di yawayan anuiwanin go waenapan upinewa inamup uon. ");
INSERT INTO dgz_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Iwa nop nega anune taine nagirewa God tavewa aigap aruga muneta. Go ya anune taine nagirewa nop otu da anune taine den sia waseamota. ");
INSERT INTO dgz_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Waenapan upinewa menan maibe gapan megenat wadiamuivin. Ap wadiamuingina iwa mega ame mu yangut tain go ya yao awain. Amba mu anuin go ya anu awain. ");
INSERT INTO dgz_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Mu inamup iravi taitamene menan watageta apane Aisaya wani tavewa tauen. Aisaya anega wan, Mu aigap aigap di anuin go da ya di anu awain. Mu aigap aigap di yawain go da ya di yao awain. ");
INSERT INTO dgz_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Iwa waenapan mam potamu gware den, menan imumu borat musiwanum. Amba darinamu gware den menan ya di anuiwanum, amba yamamu borasen. Menan mu da anu ave ave umap uon. Iwa mu yamamu gapan yavepi amba darinamu gapan anupi, amba imumua gapan anu kakayasepi, menan inanap onamop wat inakam mumapena tawa taiwanum. ");
INSERT INTO dgz_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","17","Wataget, God noa waiwanumune nagire amba kakaewa taine nagirewa den endi e dim dim yavisiana yawapen menan taiwanumun go mu da ya yawane. Amba endi dim dim da anuisiana anupen menan taiwanumun go mu da ya di anune. Go God wat aipakam imaeni menan e yao aviwanin amba anu aviwanin!” ");
INSERT INTO dgz_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Iesu sia anega wan, “Oma makewa uaseni maibewa tavewa wadiaepena anun. ");
INSERT INTO dgz_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Makewa negina geamone guegue ame, waenapan God toemu mega oisewa anuiwanumun go mu ya anu aviwanumun menan Seitan tauen nop oit ame potamupe up taiwan. ");
INSERT INTO dgz_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Amba makewa piup baware uon gwat aigap geamone gueguewa ame, waenapan nop ere anune atonu den anun. ");
INSERT INTO dgz_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Go koni ame gapan mu visimu ae ae umap uon koni bobou otu da megenat aen menan potamup ya waren. Go evi amba pusi warup inamup taueni gapan mu aro muga uon tan menawaet inak wakaumane. ");
INSERT INTO dgz_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Amba sia makewa ganongae berip geamone gueguewa ame, waenapan nop anun go piup itan megawa o aton megawa o moni puraput imumu waren menan God inap imu pose ya waren amba kiman inak mega kakaewa da inamup ya venasen menan tavewa da ya iane. ");
INSERT INTO dgz_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Amba makewa piup kakaewa gapan geamone gueguewa ame, waenapan nop anu kakayasene. Bumagamu totanen anu warane ayamase yaentuk mantuk taiwanumune ae ya vene, menan inak muga tavewa mega kakaevet apane nani yamunaet (100) o apane yampoa (60) o apane daiton aonagaetawa (30) tavewa dim da vereni aigap ien aewan.” ");
INSERT INTO dgz_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Iesu maibe da sia wadiamon, “Toemu kimaniwa guegue ame manega, apan da makewa kakaewa nao mega gapan veren. ");
INSERT INTO dgz_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Mum tauen amba waenapan iravi aup iniwanumune newap, anavi mega da taue gaian berip vere aen. ");
INSERT INTO dgz_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Tavewa iam wanumune wamewa gapan, nao nagirewa gaian den yanane ire yawane. ");
INSERT INTO dgz_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Menan piup i apanewa ine tauan anega wan, ‘Bawarewa nugawa, ge naewa kakaewa aia nao gega gapan veraana go anenen amba gaian den yanane?’ ");
INSERT INTO dgz_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Me gare wadiamon, ‘Anavi nega da tan.’ Wani mu singui sia wayawan, ‘Ge wa, nu anet gaian ame ae ma bunait?’ ");
INSERT INTO dgz_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Me gare anega wan, ‘Ae, uon, iwa gaian koewa bunaepen tane newap kakaewa den bunawai. ");
INSERT INTO dgz_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ae veane biroto yane aiwandan, e maup matagamepen wamewa tauep. Wam ame gapan maup matagamepi nagirewa ne anega diamoin, namu omaya irapen gaianewa bunaen itapu panan amba omaya iran. Boge kakaewa tambun tobot tan onaen dugup nega gwanap sean.’” ");
INSERT INTO dgz_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Iesu maibe noa da sia anega wadiamon, “Toemu kimaniwa guegue manega, apan da oma baip makewa ware ae nao mega gapan veren. ");
INSERT INTO dgz_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Oma baip makewa ame otu koentu iragenawa go kai ware entanen oma baware iragen tan. Menan nenip tauan dugup muga oma ame naniwa gapan iragi waramone.” ");
INSERT INTO dgz_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Maibe da sia anega wadiamon, “Toemu kimaniwa amun mega buredi tutut waini mini, ame waen da, buredi tutut wapen menan atagin mini potap wa damage kwaviro tan amba iravi tutut wan. God toemu mega amunewa ap anega.” ");
INSERT INTO dgz_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Iesu nop ugup ugup iravi maibe gapan waenapan wadidiamon. Gutut o nop da aroga da ya wadiamon go maibe gapan megenat waiwandin. ");
INSERT INTO dgz_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ap menan God noa wataget waiwandini apanewa, dim da anenen wani tavewa tauen. Me Iesu oisewa anega wan, Ne nona maibe gapan watapain, Ap gapan anut dim dim iravi piup ta venaseni wamewa gapan, gungunu wande oniwandini, ne wat matagamain. Ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Iesu waenapan ae vemo pa gwanap aeni gapan. Wadiamot megawa ine tauan anega wane, “Gaian egagawa maibewa anenen waan wadiane anut.” ");
INSERT INTO dgz_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Iesu gare anega wan, “Apan oma makewa kakaewa vereni ame Kimani Vitana Apanewa. ");
INSERT INTO dgz_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Egak ame piup mam amba makewa kakaewa ame God toemu mega nagirewa. Amba gaian yaninewa ame Seitan otu waiwa. ");
INSERT INTO dgz_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Anavi gaian taue vereni ame Seitan. Maup ame wam verisiwa, amba daupam taine nagirewa ame God anea megawa. ");
INSERT INTO dgz_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Menan wam verisiwa gapan gaian bunave omaya irain. ");
INSERT INTO dgz_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Gueguewa ame, Kimani Vitana Apanewa anea nega watu enamoin. Tauepi toemu nega gwanap koewa ta parisine nagirewa bongam mumain. ");
INSERT INTO dgz_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Bongam mumepi oma meraovewa gapan uatam mumain, ap mepe irip turup wa amba asi kitonak wanumain. ");
INSERT INTO dgz_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Go inak tamanawa taine nagirewa Mamanua toemu mega gapan, ganat muga wam mini wa ganatamain. Darinaya den wandepi nop ma anun.” ");
INSERT INTO dgz_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Iesu sia wadidiamon, “Toemu kimaniwa guegue ame kwan puraput karaua egaga tu umine umap. Wam da, apan kwan puraput ame yao matagameni, me menawaet karaua uap sia umen. Boge me atonu den aen amba kwan puraput megawa iragi ase une ta, amba agim make ame gapan egak ame une tan. Iwa kwan puraput karaua wandiniwa ame kakaewa mega aigap iragen. Menan kwan puraput karaua umeni den megawa.” ");
INSERT INTO dgz_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Iesu sia wadidiamon, “Toemu kimaniwa dim yan kakaewa une tata anune yoa taine umap. ");
INSERT INTO dgz_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Wam ame daiton kakaewa da tautanen go garewa arita iragen. Menan me ae kwan puraput mega iragi une taitamen amba agim make ware yan kakaewa ame une tan.” ");
INSERT INTO dgz_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Toemu kimaniwa ame ia umap, awana ae antap ene amba meo gine ugup ugup upain. ");
INSERT INTO dgz_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Meo upane no dotoueni, meo upine nagirewa ia warupane gerata aen. Boge mu ae wanumon amba bongamen meo kakaewa kaepot gapan enan, go meo koewa aipa uatamen. ");
INSERT INTO dgz_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Wam uiwa tauepi ma mini da venaseta. Anea taue koewa kakaewa yan semota. ");
INSERT INTO dgz_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Amba koewa taine nagirewa oma meraovewa gapan uaseta, ap mepe irip turup wa amba asi kitonak wanumain.” ");
INSERT INTO dgz_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Iesu ameme wadidiamoni singui wayawamon, “Ne iravi wana anu aviwanin go?” Mu gare wane, “E, nu gase anuton.” ");
INSERT INTO dgz_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Menan Iesu sia wadiamon, “Nop nega guegue ame da da Diu nagirewa iup namua anu kakayase evi amba nop nega anu kakayasepi ame kakae guragut namua ge kakae guragut ewakewa dere den tambuine mini.” ");
INSERT INTO dgz_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Iesu maibe noa wan uon tani at ame ae ve aen. ");
INSERT INTO dgz_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Me pa sewa mega, Nasaret, taueni gapan, iup anuine paewa gwanap wadidiamon. Menan waenapan no i kap wane amba nipep anega wan, “Apan ma dima ge yo paua mame aroewa iragi ambagan waren? ");
INSERT INTO dgz_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Go me pa tuini apane otua mo. Inewa yaua Meri. Amba gwani wai apan Diemis, Diosep, Saimon ge Diudes. ");
INSERT INTO dgz_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Amba domare wai iravi nu den inivin. Me mondi pa otua megenat, go dima arita ge yo paua ugup ugup iragi ma amba waren taiwan?” ");
INSERT INTO dgz_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Menan mu anu koeam Iesu inap anune. Go Iesu gare wadiamon, “God no oise waini apane viripe ya taine ame pa sewa megawa amba mek pa mega gwanap wanumuine nagirewa mugenat.” ");
INSERT INTO dgz_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ame menan ap mepe yo paua arugataet ya tan iwa mu anu tumat muga da uon. ");
INSERT INTO dgz_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Wam ame gapan, ayop Erot, at Galili ayopewa, Iesu oisewa anuni, ");
INSERT INTO dgz_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","amba me gauarape megawa anega diamon, “Iesu yo paua ugup ugup taiwandini iwa me dup iamuini apanewa Dion di, bop gapan sia yon wanden taiwan!” ");
INSERT INTO dgz_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Erot ap anega wani iwa wataget Erot gwaniwa Pilip waenewa yaua Erodias up ta naisen. Erot up ta naiseni menan Dion anega diguren, “Narawagawa waraana iup paina yamasean.” Ap anega wani menan, Erot ita nagirewa diamon, ‘Dion waran gwat nokap baraene.’ ");
INSERT INTO dgz_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Erot Dion to boniga baraet anun go waenapan tamu anuni iwa mu Dion God no oise waini apanewa da anune. ");
INSERT INTO dgz_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Erot yaneni wamewa baripe gapan, me wainewa Erodias orewa yone, Erot evene wai den tarep munan waren. Erot tarep ame yaveni me aton aritavet anun. ");
INSERT INTO dgz_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Menan waenoro ame inap kaimakaet wa agiasen, dim da menan anu wapi di ta wanat wan. ");
INSERT INTO dgz_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Menan inewa, Erodias, me orewa wadieni gapan, orewa anega wan, “Dion waenapan dup iamuini apanewa iwa to nugut sera gapan barao ma nen, endi ma me di!” ");
INSERT INTO dgz_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Erot waenoro ame mup mega wan anuni bagu sisi anun. Go evene wai barip men tauane yamamup waenoro wanat wa agiaseni menan Dion iwa to nugusepen wan. ");
INSERT INTO dgz_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Boge ita nagirewa watu enamon gwat noke tauan, Dion mege gamu to ketnagene. ");
INSERT INTO dgz_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Dion i bonewa sera gapan baraen wat onamon, waenoro ame wanane, waenoro wat ae inewa ine taue wanen. ");
INSERT INTO dgz_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Dion wadiamot mega tauan etua wat amon urata tun. Tune amon Iesu oit wadian. ");
INSERT INTO dgz_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Dion boeni oisewa anuni gapan Iesu totnage kabum ware awan Galili to nuguse, waenapan uoni are aen. Go waenapan oisewa anune menan pa sewa gapan pusimup ewap amone. ");
INSERT INTO dgz_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Iesu kabum gapan asepagan taue, gerata enaseni gapan waenapan arugataet to iamene yawamon. Iesu munan bagu sisi anuni menan vek muga muga wat inakam mumen. ");
INSERT INTO dgz_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Mum gine di taiwandini gapan, wadiamot megawa ine tauan anega wan, “At ma waenapan uoni arewa, amba wam gaset gearen mum di tauapen taiwan menan waenapan to iam baware mame watu enamot amo, taba upi pa gwanap muk muk une ta nap.” ");
INSERT INTO dgz_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Go Iesu gare wadiamon, “Mu ya amop. E taba da munane nap.” ");
INSERT INTO dgz_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","“Ae, nu anenen munait? Nu taba nuga inanupe buredi magamene nani yamunaet amba meo dere mugenat.” ");
INSERT INTO dgz_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ap anega wane Iesu sia wan, “Tambu onaen, mapa nenan.” ");
INSERT INTO dgz_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Amba Iesu waenapan iragi unawat gagap wanumopen diamon. Amba Iesu taba buredi magamene nani yamunaet amba meo dere den ame tambu kiman ao yave, God inap gaun wan, amba paise paise ta waenapan taba munapen men, wa ewamot megawa munen. ");
INSERT INTO dgz_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Waenapan iravi taba tavewa nane bagumu bim wan. Nane ewap, wadiamot megawa semua bongamen kaenat aonagaet pusinawan dere enane no dotouen. ");
INSERT INTO dgz_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Apan ap mepe taba tavewa nane arugataet 5000 umap, waen orup den batnagetawa aigap den sia. ");
INSERT INTO dgz_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Amba Iesu wadiamot megawa kabum gagap kaum etop asepagan namu amop amba me evi aet wan. Amone, Iesu waenapan to iam baware ame watu enamon amone. ");
INSERT INTO dgz_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Amba God inap mup wapen menan tunup arigewa dot aen. Mum gine me megenat ap mepe wanden. ");
INSERT INTO dgz_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Go kabum gaset awan bumagewa gapan aen, keta yon wanden iwa taik taue kabum nasiwandin gapan. ");
INSERT INTO dgz_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Mum igoe dena gapan Iesu munan kaum awan gagap pusip ap oniwandin. ");
INSERT INTO dgz_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Wam ame wadiamot megawa awan gagap ap oniwandin yawane, mu tap baware anun anega wane, “Ma guagup da tauia.” Amba ta den senao vebobop wane. ");
INSERT INTO dgz_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Menan gine tutup Iesu menawaet anega wan, “Ma ne, tap ae vean gop ya anune.” ");
INSERT INTO dgz_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Wani Pita gare anega wan, “Ayop negawa, ge tavewa wanigewa wa, ne awan gagap ongep.” ");
INSERT INTO dgz_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“Umap di, onak.” Iesu ap wani menan Pita kabum ae ve, awana geare, ap pusip awan gagap Iesu tanapen onen. ");
INSERT INTO dgz_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Go Pita taik eparaewa yaveni menan tap ta kauma aipa di unuk aiwandin, menan wawa sisi tan, “Ayop inak nen!” ");
INSERT INTO dgz_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Boge menawaet, Iesu Pita ma warupeni anega dien, “Ge anu tumat gega ne inanap kaimake den uon, iwa dimen anu bambam taingi?” ");
INSERT INTO dgz_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Amba mu kabum dotouane gapan taik tom wan. ");
INSERT INTO dgz_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Kabum gwanap wanumone nagirewa iravi Iesu wa taragasen anega wane, “Tavewa di, ge God otua.” ");
INSERT INTO dgz_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Mu awan ame gamu to nugusene boge at Generaset gerata enasene. ");
INSERT INTO dgz_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Pa nagirewa Iesu ire yawane sep at at watu enamon vek nagirewa iravi tam onamot wan. ");
INSERT INTO dgz_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Mu Iesu wanup mega gine siwa inasepen menan mup wane, orup da da wanup mega ginewa inatanewa iragi inak mutane. ");
INSERT INTO dgz_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Wam ame gapan Parisi nagirewa amba iup wadidiamuine nagirewa den pa Ierusalem gapan tauan amba Iesu singui wayawane, ");
INSERT INTO dgz_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Iwa dimen wadiamot gegawa omayan baewa guturewa iup mega to paisiwanum? Mu God menan namu nanimu bigi ya warane amba taba naiwanum.” ");
INSERT INTO dgz_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Iesu gare wadiamon, “E iwa dimen gutut ega ayamase tapen men God iup mega paina yamasiwanin? ");
INSERT INTO dgz_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","God anega diaen, ‘Inae mamae virimu tan amba da da mamewa o inewa ta koeragamepi ame togurep di boep di.’ ");
INSERT INTO dgz_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Go e ugup anega waiwanin, Apan da da ine mame anega wadiamopi, ‘Nu enat wa agiat imaetoni ya enait nu God wanait.’ Ap anega wapi ine mame virimu ya taiwanum, go e umap waiwanin. ");
INSERT INTO dgz_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Menan e gutut ega ayamase tapen menan God nop mega ayamase ya taiwanin. ");
INSERT INTO dgz_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","E da wa da ta taiana nagirewa. Watageta apanewa Aisaya tave di wan. Me God no oise gapan enan manega wan, ");
INSERT INTO dgz_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Waenapan iravi nomu gapan viripana den taiwanum, go imumu potamu ne inanap ya wariwanum. ");
INSERT INTO dgz_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","E wa taragat nimanegepen menan umap uon, iwa gutut ega ek anuiana gapan wadiamuiana menan. Aisaya enan ap anega wan.” ");
INSERT INTO dgz_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Iesu waenapan munan wan tauane anega wadiamon, “Wapena anun. Di anu kakayasen. ");
INSERT INTO dgz_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Waenapan taba ugup ugup naine gapan imumu God yamap bigip ya taiwan. Go dim da no utap aoma tauiniwa, ame gapan imumu bigip taiwan.” ");
INSERT INTO dgz_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Iesu ame wani menan wadiamot mega ine tauan anega wane, “Parisi nagirewa nop mame waana gunat wane ge asik taan?” ");
INSERT INTO dgz_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Iesu gare wan, “Waenapan iragi da da oma naewa Maman kimaniwa ya vereniwa me visiwa den ae ma bunaeta. ");
INSERT INTO dgz_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Parisi nagirewa ae vemon! Mu yamamu borat mutane nagirewa mini. Yame boraseni apanewa evene yame boraseniwa wat nau aepi dere dere urata geamoin.” ");
INSERT INTO dgz_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pita singui wayaven, “Maibe waana ame wan dim dim imunu wat bigiminiwa ame tavewa wa ewan.” ");
INSERT INTO dgz_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Iesu sia wan, “E da ya anu kakayat wanin? ");
INSERT INTO dgz_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Iwa dimen asik ya tayan? E asigiap, waenapan taba ugup ugup naine ni etavewa gapan wande amba tau aeta. ");
INSERT INTO dgz_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Go wan dim dim ame noa gapan aoma tauini ame imu pose gapan tauiwan ap me gapan imuya God yamap wabigimiwan. ");
INSERT INTO dgz_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Imuya potaya gapan koewa ega anuyan taiwanin. Koewa ega guegue ame koewa tapen, togurep boepen, wainan gogo tapen, up tapen, evenae wae oise aopan ugup wapen, amba nuaroro wapen. ");
INSERT INTO dgz_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Menan iravi mame gapan wabigim imainiwa, go nania bigi ya warayan amba taba tambuyan naianawa, ap gapan God yamap ya bigim imaeta.” ");
INSERT INTO dgz_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Iesu at ame ae ve pa Taya ge pa Saidon arigewa aen. ");
INSERT INTO dgz_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Aeni at Keinan waen da ap mepe ininiwa Iesu ine taue ve uma anega wan, “Ayop nega, apan Devit naewa, bagu sisi nenan anu! Ne orana airampu potap wandini gapan vek baware taiwan.” ");
INSERT INTO dgz_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Iesu nop da gare ya wan. Menan wa ewamot mega tauan Iesu inap anega wan, “Waen ma wa oise aep, iwa pot pot ewanup yonen mup waiwan.” ");
INSERT INTO dgz_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Go Iesu gare anega wadiamon, “God ne Isurero nagirewa munan watu enanegen, iwa Isurero nagirewa mu man sip pua amone umap. Go waen mame at ugupe waene da.” ");
INSERT INTO dgz_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Iesu ap anega wani go waen ame taue me namup omanip enu anega wan, “Ayop, ago nen!” ");
INSERT INTO dgz_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Iesu waen ame gare maibe gapan anega wadien, “Orup otu taba muga eyao ya munait, ame kakae uon.” ");
INSERT INTO dgz_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Wani waen ame gare wan, “E, ayop negawa, ge tave di waingi. Go pa i apane taba watara naini semua geamuine eyao den naiwanum.” ");
INSERT INTO dgz_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Boge Iesu gare anega wan, “Ge kaimakaet anu tumat nimanegeana menan, oraga menan anuana genan di tain.” Amba me orewa wam airase ame gapan inakaen. ");
INSERT INTO dgz_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Iesu sia ae, kaum Galili etop tau aiwandin eni amba togan dore ae wanden. ");
INSERT INTO dgz_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Waenapan arugataet ine tauan. Engirit wangirit nagirewa, pusi nani tom tam wane nagirewa, yame borat mutane nagirewa, no borat mutane nagirewa, aruga upi den aian tauan Iesu namup daum enun. Me iragi wat inakam mumen. ");
INSERT INTO dgz_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Wat inakam mumeni menan waenapan tarak wan. No borat mutane nop waiwanumune, pusi nani tom tam wane nagirewa sia kakae tane, yame borat mutane nagirewa sia yangut taiwanumun. Ap yawane menan waenapan mu Isurero God mugawa wa taragasene. ");
INSERT INTO dgz_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Amba Iesu wadiamot mega munan wan tauane anega wadiamon, “Ne waenapan ma munan bagu sisi anuivin. Mu tanamo wanigen wam yampo gaset uon tan amba endi taba da ya nane. Wapimu negina torot wapi tawa menan, mondi enup agut ya watu enamot anuivin.” ");
INSERT INTO dgz_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Wadiamot mega singui anega wayawan, “Nu taba amba tambut umanup tap amba to iam baware ma watumoit, at ma kaimewa arewa mini, taba da uon?” ");
INSERT INTO dgz_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ap wane Iesu singui wayawamon, “Taba buredi animpo inayap wanumam?” Mu gare wane, “Nu buredi nani yamu dere amba meo otu kamontu upi den.” ");
INSERT INTO dgz_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Iesu to iam baware ame diamon piupa ae wanumon. ");
INSERT INTO dgz_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Boge me taba buredi meo den tambu amba God inap gaun wani, paise paise ta wadiamot mega munen amba mu waenapan munane. ");
INSERT INTO dgz_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Mu iragi nane umap tamon amba Iesu wadiamot megawa semua bongamen kaenat nani yamu dere enane no dotouane. ");
INSERT INTO dgz_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Apan ap mepe taba nane arugataet 4000 umap go waen ge orup ya batnagene. ");
INSERT INTO dgz_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Iesu to iam baware ame watu enamoni ewap, me kabum dotoue amba at Magadan aen. ");
INSERT INTO dgz_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Parisi ge Sadusi nagirewa upi Iesu ine tauan pusip warup yawapen menan mup anega wan, “Ge aro kimaniwa paua da ta nu yawat anuivin.” ");
INSERT INTO dgz_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Me gare wadiamon, “Mum gine tauepi, e anega wai, ‘Imana at tarasep umap di wandeta, iwa endi kiman gwane popo sirot wan dendeni tan.’ ");
INSERT INTO dgz_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Amba mumaget, e anega wai, ‘Endi ame ugin taueta, iwa kiman gwane irok kambu ene wa guguren.’ E piup ge kiman gwanewa guegue mega anenen venasini yawa wat mega, ame asigip tayan. Go God endi dim dim da tainiwa ya anu aviwanin. ");
INSERT INTO dgz_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Koewa tane God tandayasine nagirewa aro kimaniwa paua da yawat anuiwanum. Go God noa wataget waiwandini apane Diona paua mega megenat wa ewain.” Iesu ap wani ae vemo tau aen. ");
INSERT INTO dgz_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Wam da mu awan gamu to nugusen amone ame Iesu wadiamot megawa taba buredi napen menan imumu borat mutane menan ya tambun. ");
INSERT INTO dgz_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ame gapan, Iesu anega wadiamon, “Agun anun, Parisi ge Sadusi nagirewa koewa muga anu kakayasen. Guegue muga ame buredi tutut wapen menan atagin potap enine mini.” ");
INSERT INTO dgz_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Mu nop ame waran amba yaumakamup baraen wawa mutan amba anega wan, “Mame wani iwa nu taba buredi da ya tam onantoni menan waiwan.” ");
INSERT INTO dgz_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Mu imumua dim da anune ame Iesu anuni menan anega wan, “E anu tumat ega otu koentu, iwa dimen taba buredi ya warat waiwanin? ");
INSERT INTO dgz_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","E ya di anu aviaisi. Ne namu buredi magamene nani yamunaet gapan apan aruga 5000 munan nane amba semua bongameana kaenat animpo enayan? Asigip tayan go uon? ");
INSERT INTO dgz_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Amba evi buredi magamene nani yamu dere gapan apan 4000 munan nane amba semua bongameana kaenat animpo enayan? ");
INSERT INTO dgz_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Menan iwa dimen nop nega ya anu kakayat wanin? Ne taba buredi menan ya waivin. Buredi tutut wapen menan atagin mini enine ap umap Parisi ge Sadusi nagirewa guegue muga agun anupen menan waivin!” ");
INSERT INTO dgz_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Me ap wani gapan, wadiamot mega di anu awan. Me buredi tutup wapen menan atagin mini enine menan ya wan go Parisi ge Sadusi nagirewa nop muga wadidiamuine menan agun anupen diamon. ");
INSERT INTO dgz_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Wam da Iesu pa sewa yaua Sisaria Pilipai arigewa gapan taueni, wadiamot mega singui ta wayawamon, “Waenapan ne Kimani Vitana Apanewa ne da dianek wanum?” ");
INSERT INTO dgz_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Mu gare anega wane, “A, ge Dion waenapan dup iamoni apane diagiwanum. Waenapan upi ge watageta God noa waiwandini apane da, ame Elaidia o Dieremaya o apan dawa diagiwanum.” ");
INSERT INTO dgz_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Menan Iesu mu inamup singui anega wayawamon, “Umap, go e ne da dianegiwanin?” ");
INSERT INTO dgz_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimon Pita gare anega wan, “Ge God mega wa watu enageni Keriso. Ge God yaibobot wandini Otua.” ");
INSERT INTO dgz_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Pita ap wani Iesu gare wadien, “Saimon, apan Dion otua, God wat aipakam mega ge inagap iwa ma aroga waingiana ame apan da ya wadiagen, go ne Mamana kimaniwa wadiagen. ");
INSERT INTO dgz_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Wapena anu. Ge yauga Pita (gueguewa ame gwat bonawan), amba gwat ma gagap ne dugup nega tuin. Amba bop aroewa dugup negawa ame ya toboreta. ");
INSERT INTO dgz_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Toemu kimaniwa tonane tumtumewa ne genian. Ge dim da piupa panawa, kiman gapan den paneta amba dim da ge piupa vetawa kiman gapan den veseta.” ");
INSERT INTO dgz_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Iesu ame ap anega wani wadiamot mega kaimakaet sia diamon, “Ne God mega wa watu enanegeni Keriso waenapan ya wadiamone.” ");
INSERT INTO dgz_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Iesu wam ame use aeni nop ere watape wa ewamot mega aroga anega wadiamuiwandin, “Ne Ierusalem angep. Ap mepe waenapan dimae waine nagire amba pirisi bawarewa ge iup wadidiamuine nagire den nanimup ugu vegaek bagu sisi baware anu tanain. Amba toguranegep bonigatain. Toguranegep bonigasepena amba wam yampoa God amun mega gapan inak nigat yon wanigain.” ");
INSERT INTO dgz_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ap anega wani menan Pita Iesu nau asira ae amba digure anega wan, “Ayop, ap ya di venasep! Mu ap anega toguragepen tapi God watanamota. Ge nop ap mini ya wa.” ");
INSERT INTO dgz_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Iesu entane Pita anega diguren, “Ge Seitan mini, tau garinap ak. Ge oma ibariwa mini namuna boringi go God wan dim dim mega iagap ya baraingi, go apan iak guine gapan waingi.” ");
INSERT INTO dgz_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Amba Iesu wadiamot mega anega wadiamon, “Orup da inanap onat anupiwa, namu me mek dim da anuini tandayase, ae di vep, amba ne yauna menan, pot poraet ugu vegaek bagu sisi anu, bop mega ware evinap oniwandan. ");
INSERT INTO dgz_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Amba orup da da muk inak mugawa menan anu gurane tainewa, ame inak muga wakaumain, go orup da da mu inak muga nenan anu gure wakaumepiwa, mu inak kakaewa tautanain. ");
INSERT INTO dgz_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Amba sia, orup da piup puraput mega iravi tambu inak yaibobot mek wa koeamepi o wakaumepi, ame tavewa uon! Me garewa om dim da gapan inak yaibobot sia une ta wat naseta? ");
INSERT INTO dgz_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Wam uiwa gapan, ne, Kimani Vitana Apanewa, Mamana kakae guragut mega ganasewa warap amba anea mega den tauapena amba waenapan kakaewa koewa taiwanumune garewa muga muga munain. ");
INSERT INTO dgz_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ne tave di wa agiat imaivin. E da da mapa yoniana ya borit wai Kimani Vitana Apanewa toemu nega den tauapena yawanegene amba borit wai.” ");
INSERT INTO dgz_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Wam nani yamu daiton uon tani Iesu God inap mup wapen menan apan Pita, Diemis ge gwaniwa Dion tambumo mugenat tunup bawarewa da dot amon. ");
INSERT INTO dgz_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ap mepe namumup yawane Iesu etua ugup entanen. Me gine namua wam mini ganase wan amba wanup mega pomponu ganase wa tau aen. ");
INSERT INTO dgz_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Yawane boge watageta apane Mosis ge Elaidia venat mutan Iesu den nop waiwanumun. ");
INSERT INTO dgz_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pita Iesu inap anega wan, “Ayop nugawa, nu ge den mapa wanin antoni menan ame kakae di. Menan ge anua pa namdat otu da yampo tumoit. Daiton gegawa da Mosis megawa da Elaidia megawa.” ");
INSERT INTO dgz_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita nop mame waiwandini irikup pomponu aigamup taue, waboboramon amba mu irikup potap wanumon. Nop da irikup potap anega tauen, “Ma ne Otun iragenawa, da ne menan anu gurinawa, me inap atonua anuivin. Nop mega anun!” ");
INSERT INTO dgz_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Iesu wadiamot mega nop ame anune gapan tap aritavet anun ap menan gine namu piupa to kukutnagene. ");
INSERT INTO dgz_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Iesu taue inatamo anega wan, “Ao yonan tap ae vean.” ");
INSERT INTO dgz_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Wam ame mu yangut ao tane, mu yawane apan upi uon Iesu megenat. ");
INSERT INTO dgz_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Tunup gapan mu vit onam wanumune, Iesu no botakam mume anega wan, “Dim da venasen yawayana oisewa waenapan da ya wadiamone. Ne Kimani Vitana Apanewa bonigasep sia inak nigasepena amba wadiamon.” ");
INSERT INTO dgz_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Wadiamot mega singui anega wayawane, “Iwa dim men iup wadidianine nagirewa apan Elaidia namu tauep amba Mesaya evi tauat waiwanum?” ");
INSERT INTO dgz_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Iesu gare anega wadiamon, “Tave di, Elaidia namu di taue negin wat tamanameta. ");
INSERT INTO dgz_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Go wapena anun. Elaidia gaseget namu tauen. Waenapan ire ya yawane menan koewa inap tat anune gapan di tane. Negin ame gine daiton gapan Kimani Vitana Apanewa den ta koeragam nimanegep ugu vegaek bagu sisi anu tanain.” ");
INSERT INTO dgz_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ap wani gapan, wadiamot mega anu awane ame inamup Dion dup iamuini apanewa menan waiwandat anun. ");
INSERT INTO dgz_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Tunupa vit onamone gapan, iam iam da potap tauane, ap mepe apan da Iesu ine taue amba namup omanip enu anega wan, ");
INSERT INTO dgz_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Ayop, otuna menan bagu sisi anu! Airampu da potap wandia seke take taiwan vek baware anuiwan. Wam wam omaya geariwan o kauma geariwan. ");
INSERT INTO dgz_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ne wa ewamot gega inamup waran tauan go mu ya wat inakamene.” ");
INSERT INTO dgz_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ap wani Iesu gare wadiamon, “Akae, koewa taiana nagirewa, ya anu tumat nimanek wanin. Ne wam animpo mini tanae wanigepen amba anu tumat tai? Orup ame wat onaen.” ");
INSERT INTO dgz_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Wat tauane gapan Iesu airampu kaimakaet diguren, amba airampu orup ae ve tau aen, orup boge inakaen. ");
INSERT INTO dgz_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Amba wadiamot mega karaua Iesu ine tauan singui wayawan, “Iwa dim men airampu wa oitatoni go ya tau aen?” ");
INSERT INTO dgz_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Iesu gare wadiamon, “Iwa anu tumat ega otu kamontu. Ne tave di wadiaivin. E anu tumat ega baip makewa otu kamontua mini wandepiwa e tunup ma, mapa ao yone asepa aet wane, ame di aeta. Menan anu tumat nimanegene gapan dim da men wanewa di venaseta.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Wam da, Iesu wadiamot mega den at Galili tau ge tau amuiwanumune gapan me anega wadiamon, “Kimani Vitana Apanewa anavi waranege apan upi nanimu gwanap bat nimanegain. ");
INSERT INTO dgz_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Mu ne toguranegep bonigasepena amba wam yampoa God aro mega gapan inak nigat sia yon waingain.” Amba wadiamot mega bagu sisi baware anu tanane. ");
INSERT INTO dgz_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Iesu ge wadiamot mega pa Kaponiam tauane ewap, God Paewa menan moni bongamine nagirewa Pita inap tauan singui anega wayawan, “Wadiaget gegawa God Paewa menan moni siwan go uon?” ");
INSERT INTO dgz_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pita gare anega wan, “E, me den di siwan.” Pita ap anega wani amba pa unuk aen, boge Iesu namu iragen Pita inap singui anega wayaven, “Saimon, ge dim da anuingi? Piup at at ayopewa ansena moni muga sinewa? At i nagirewa siwanum o ian ugupe at ame wanumuine nagirewa mugenat siwanum?” ");
INSERT INTO dgz_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita gare wan, “Ugupe nagirewa mugenat siwanum.” Iesu gare wan, “E, tave di. Menan at i nagirewa ya siwanum. Menan nu ya seapen iwa nu God toemu mega nagirewa. ");
INSERT INTO dgz_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Go God Paewa moni bongamine nagirewa gunat inanup ya anupen menan ge age kaum awan gapan kimai gega uat. Meo erewa warupawa noa watapa ap mepe gwat make da yawai. Wat age moni bongamine nagirewa mun, ap gapan garewa nuga ta.” Pita Iesu anenen wani gapan di tan. ");
INSERT INTO dgz_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Wam ame gapan Iesu wa ewamot mega ine tauan anega wayawan, “Toemu kimaniwa potap nu orup ansena da baware iragenawa?” ");
INSERT INTO dgz_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Menan Iesu orup otu da menan vene wan taue yaumakamup yonen. ");
INSERT INTO dgz_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Amba anega wan, “Ne tave di wadiaivin, e orup otu menawaet anu tumasine mini imuya ya wat entanenewa, toemu kimaniwa ya tauai. ");
INSERT INTO dgz_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ap menan waenapan da da orup otu mini muk inga ingane wat otutamepi, toemu kimaniwa gwanap mu baware iragena di tain. ");
INSERT INTO dgz_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Amba mu da da orup otu ma miniwa ne yauna gapan waupepi ne den waupanek wanum.” ");
INSERT INTO dgz_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Iesu sia anega wan, “Go orup otu ma umap anu tumat nimanegene go ta pariset apane koewa ta ewamopen menan naumo amopi, ap gapan ta pariset apane ame itan baware yaveta. Menan namu me waenapan upi wa parit mumepi tawa menan gwat itani dena megap pansine puimani pakit uasep borit wapi ame umap di. ");
INSERT INTO dgz_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kaiwan, piup nagirewa pot pot koewa ugup ugup pusimup wariwan. Menan waenapan koewa tapen menan pusia di warup yawain, go kaiwan ta pariset apanewa.” ");
INSERT INTO dgz_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Ge nanigawa o pusigawa wat nauge ae koewa tapiwa, to ketnak aipa uat! Ap tom wapi gomunaet inak arewa ageawa ame kakae, iwa ge koewa ya veawa ge tawaga uruga yaibobot omae meravewa gapan uat enagain. ");
INSERT INTO dgz_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Amba ge yamaga wat nauge ae koewa tapiwa, aoma wa totnak aipa uat! Ameme yamaga yamunaet inak arewa ageawa ame kakae, iwa ge koewa ya veawa ge tawaga uruga oma meravewa gapan uat enagain.” ");
INSERT INTO dgz_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Iesu sia anega wan, “Agun anun orup da anu koeam anu tumasini otua ma mini ya tamop. Ame wadiaena iwa kiman gapan orup ame anea mugawa pot pot Mamanu kimaniwa namup yoniwanum. ");
INSERT INTO dgz_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Kimani Vitana Apanewa God negin mega wakaumene nagirewa imumu wat inakam mumapen men tauan. ");
INSERT INTO dgz_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Orup da ge, inagap man sip gega apane nani yamunaet (100) wanumopiwa, wam da man sip daiton wakaumewa, ge man sip upinewa 99 pua ae vemo, daitona ame yoa agai. ");
INSERT INTO dgz_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Wapena anun. Man mega daiton ame yavepi aton baware anuta go upinewa ya kaumeni, munan aton otu koentu anuta. ");
INSERT INTO dgz_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ame gine daiton, e Mamaya kimaniwa anut megawa ame anu tumasini otua ma miniwa da ya wakaumat anuiwan.” ");
INSERT INTO dgz_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Iesu sia wadidiamon, “Tatae gwani koewa da tapiwa, me koewa mega vetavet tapen menan, karaua age koewa mega yamap wa ewat, ap mepe dere yaumakayap egenat. Me nop gega anupi ame gapan ge evenaga koewa gapan gaset wat entanaan. ");
INSERT INTO dgz_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Go ya anupi, evenaga daiton o dere upi mugenat tambu sia aisene koewa mega mu den anup. Iwa God nop mega gapan inak kakaewa ge koewa om warapen menan orup daiton megenat ya wata go orup dere yampo den yao anu wap. ");
INSERT INTO dgz_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Go e inayap tanda ta ya anut anupiwa, Iesu dugup mega nagirewa me koewa mega wadiamone anup. Go orup ame nop muga den tanda ta ya anupiwa, e me inap ya anu tumasini otua mini taiwanian.” ");
INSERT INTO dgz_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ne tave di wadiaivin, e dim da piupa pananewa, kiman gapan den paneta amba dim da e piupa vetanewa kiman gapan den veseta. ");
INSERT INTO dgz_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Sia wapena anun. E dere piup ma gapan dimen da anune umap tap menan mup wanewa ame ne Mamana kimaniwa me ta eneta. ");
INSERT INTO dgz_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Menan dere o yampo nenan tobot ta yauna gapan mup wapiwa ne ap mepe mu den inamup wanigain.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pita Iesu ine taue singui wayaven, “Ayop, evenana wam ame koewa inanap tapiwa, koewa mega wam animpo anu ae veain? Anu se dorapen wam nani yamunaet nani yamu dere go?” ");
INSERT INTO dgz_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Iesu gare wadien, “Ne wadiagivin, wam nani yamunaet nani yamu dere uon, go wam wam anu ae vingan.” ");
INSERT INTO dgz_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Koewa anu ae vepen noa anu awapen menan gutut ma gapan toemu kimaniwa guegue da wadiain. Ayop da nao mega taine nagirewa moni puakewa garewa entan sia wanapen menan wan. ");
INSERT INTO dgz_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Me taitamepen taiwandini gapan, apan da moni puakewa mega arugataet iragen sia wanapen menan namup wat onamon. ");
INSERT INTO dgz_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Koni ame gapan me garewa tata umap uon, menan ayop ame anega wan, ‘Orup ma amba waenewa ge otu waiwa den amba kwan puraput muga iragi une ta amba garewa taitamep.’ ");
INSERT INTO dgz_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ayop mega ap anega wani menan nao mega tainiwa ame omanip enu anega wan, ‘Ayop negawa, wabibigam nimanek amba garewa iravi taitamain.’ ");
INSERT INTO dgz_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ap wani gapan ayop mega bagu sisi anun garewa mega iravi anu ae ve ya taitamepen menan vesen tau aen. ");
INSERT INTO dgz_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Nao apane namua ame tau aeni gapan, me nao mega daitonawa da taneni. Evenewa ame, me inap garewa otu kamontu yogup tan go ya taitamen. Menan megap ware kaimakaet anega dien, ‘Garewa nega nen.’ ");
INSERT INTO dgz_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nao taini dawa ameme omanip enu anega wan, ‘Wabibigam nimanek amba ewagai sia genain.’ ");
INSERT INTO dgz_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Go nao taini apane namua ame bagu sisi ya anun go evenewa gwat nokap barae garewa mega wanepi amba tau aet wan. ");
INSERT INTO dgz_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nao taine nagire upine, inak koewa mame tan yawane, ap menan bagumu koe tan amon oisewa ame ayop muga wadian. ");
INSERT INTO dgz_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Menan ayop ame nao taini apanewa namua menan ven wan. Taueni anega diguren, ‘Ge nao nega koerage taiana apanewa. Mup inanap waana ne garewa nega inagapewa ae vean. ");
INSERT INTO dgz_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ne inagap bagu sisi anuna mini iwa dimen ge nao gega daitonawa menan bagu sisi ya anuan?’ ");
INSERT INTO dgz_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Menan ayop apane gari gangan naen nao taini apanewa namua ame gwat noke watu enen, tone etua vege aritavet anun, amba garewa iragi taitamepi amba tau aet dien. ");
INSERT INTO dgz_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Gutut ame ap umap sia, evenae wai da koewa muga potayap den anu ae ya veanewa, Mamana kimaniwa garewa ega ega ap umap di eneta.” ");
INSERT INTO dgz_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Iesu nop mega ameme wan uon tani, at Galili ae ve ae amba at ginewa Diudia kaum Diodan asepagan dotou aen. ");
INSERT INTO dgz_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Waenapan aruga me ewap amon, amba ap mepe me wat inakam mumen. ");
INSERT INTO dgz_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ian Parisi nagire upi ine tauan pusi warup tap Iesu nop ebo wapen menan singui wayawan, “Apan da waenewa tandayase ae vepiwa iup nuga paina yamaseta go?” ");
INSERT INTO dgz_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Iesu gare anega wan, “God nop mega batnagean go uon? Ame ere mangan God piup kiman tan venat mutane gapan apan ge waen tamon. ");
INSERT INTO dgz_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Iwa mame menan apan ine mame ae vemo ae waen da naisepi gapan, dere tobot tap etumu daiton entaneta. ");
INSERT INTO dgz_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ap gapan mu mini mini sia ya wanumoin go endi mu daiton. Ap menan God tobot tamoni gapan waen apan da seu ya enumop.” ");
INSERT INTO dgz_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Parisi nagirewa nop ap anune gapan sia anega wayawan, “Ame umap, go iwa dimen apan Mosis iup anega sen, ame apan da waenewa ae veapen ogewa warepi gapan me, ok ame aroewa gapan, waenewa watu enep aeta?” ");
INSERT INTO dgz_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Iesu gare anega wan, “E imuya gware den! Mosis waen ae vemopen umap wani iwa e imuya gware dena menan, go erewa gapan God ap anega da ya anun. ");
INSERT INTO dgz_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Sia wapena anun, apan ansena da waenewa union ae ya veta, go waenewa ame apan dawa den aeni menan ae vepiwa, ame umap. Go union i uon, waenewa tandayat ae ve ae, amba waen da ugup naisepiwa ame gapan togane tapatap di tata.” ");
INSERT INTO dgz_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ap anune menan Iesu wadiamot mega me inap anega wane, “Inak map anegawa waenapan yaumakamup venat wandapinawa ame kakaewa ya naine nisinampen. Menan mondi goroa waninetawa ame umap di.” ");
INSERT INTO dgz_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Iesu gare wadiamon, “Nop mame waenapan iravi ya wat natain, ame kaimake den go da da God wa watumoni mugenat anu tain. ");
INSERT INTO dgz_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Iwa upi burumu pokaet, mu ap anega ine wai potamup yanane, upinamu ap anega apan nanimup tum tamone o siget warane, amba upi toemu kimaniwa menan goroa mondi wanumoin. Apan da da nop ma warat anupi warep.” ");
INSERT INTO dgz_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Amba, waenapan upi otu waiwa bawarewa amba amapewa den Iesu naniwa iamup seapen menan tambun onamone, go wadiamot megawa diguguramon watanamone. ");
INSERT INTO dgz_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Go Iesu orup otua munan anega wan, “Orup otua ae vemone, nenan onamop, ya watanamone, iwa God toemu mega orup otua ma miniwa mugawa.” ");
INSERT INTO dgz_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Wam ame, me naniwa iamup seni, amba me ap mepe ae vemo aen. ");
INSERT INTO dgz_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Wam ame gapan tamaru da taue Iesu inap singui anega wayaven, “Wadianet kakaewa, ne map anenen tap amba yaibobot inagewa yon borain?” ");
INSERT INTO dgz_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Iesu gare wadien, “A, dimen ne apan kakaewa dianegingi? Orup kakaewa da uon go God megenat kakae. Ge inak yaibobot unuget anua, God iup mega ayamase di ta kakayat.” ");
INSERT INTO dgz_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Apan ame gare wan, “Iup ansena da?” ");
INSERT INTO dgz_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Iesu gare anega wan, “Orup da ya togura boep. Wainan gogo ya taingan. Up ya taingan. Evenaga koewa da tani yawaana ame ebo aopan, ugup ya enu yawa waingan. Inaga mamagawa ayamase ta muningan. Amba gek ingane genan anuiana mini, evenak waigawa munan anu guringan.” ");
INSERT INTO dgz_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Apan tamaru ame anuni sia anega wan, “Ne iup mame waran iravi ta ongingin endi mame tauen. Ne da ya di taingina ame dim da?” ");
INSERT INTO dgz_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Iesu gare anega wan, “Ge inak gega tamanagaet di waniget anua age wan dim dim gegawa iragi ase une ta moni ame wara amba kwan purapuse uoni nagirewa mun. Amba ge kiman kakae guragut megawa aupa evi amba warai. Ap tawa amba ewanap onak.” ");
INSERT INTO dgz_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Apan tamaru ame, nop ame anuni gapan bagu sisi den aen, iwa kwan puraput mega arugataet. ");
INSERT INTO dgz_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Iesu wadiamot mega anega wadiamon, “Ne tave di wadiaivin, puraput nagirewa God toemu mega unuk amopen ame inamup kaimake iragen! ");
INSERT INTO dgz_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Man bawarewa da, kainok ninoke gapan unuk tau aepen tapi ame umap uon. Ap umap, kwan purapuse dena apane da, God toemu mega unuk aepi ame den umap uon di, go kaimakewa mega aigap iragen.” ");
INSERT INTO dgz_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Wadiamot mega nop ame anune gop baware anun anega wane, “Akae, God toemu mega unugepen kaimakewa da di, ap menan da inak ewakewa ware kimani unugeta?” ");
INSERT INTO dgz_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Iesu kem kem yawamo gare anega wan, “Waenapan muk ingane aro muga tainewa gapan ya unugain, go God inap kaimake den uon menan dim dim tat anuini mek di tata.” ");
INSERT INTO dgz_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Amba Pita Iesu anega wadien, “Ge anu. Nu dim dim nuga iragi ae veat evigap onanton. Garewa dim warait?” ");
INSERT INTO dgz_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Iesu sia anega wan, “Ne tave di wadiaivin, wam uiwa gapan wan dim dim iragi entan tapi gapan Kimani Vitana apanewa ayop watarewa nega gagap oya oyae den ae wanigepena e aonagaet pusinawan dere wadiaet nega nagirewa ayop watarewa ega ega gagap waniai. E Isurero nagire dugup ega ega aonagaet pusinawan dere kakaewa koewa muga wanene tamoi. ");
INSERT INTO dgz_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ap gapan da da nenan anu gure, pa o tase gwaniwa o domare waiwa o mame waiwa o ine waiwa o otu waiwa o nao mugawa, ae vemopi, ap omewa apane nani yamunaet mini aigap sia garewa warain amba inak yaibobot den tautanain. ");
INSERT INTO dgz_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Menan waenapan endi evi yonine nagirewa, wam ame gapan, namu yonain. Amba endi namu yonine nagirewa, wam ame gapan, evi yonain.” ");
INSERT INTO dgz_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Iesu wadiamot megawa anega wadiamon, “Toemu kimaniwa guegue ame ma mini, piup i apanewa da mumaget ese goe den ae apan nao tapen menan tambu watu enamon ame egak mega gapan nao tapi moni munapen diamon. ");
INSERT INTO dgz_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Mu nop gare gare wane gapan me moni yaua denarias daiton wam daiton menan munat wa amba nao watu enamon. ");
INSERT INTO dgz_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Wam nawanenupe wareni upi une gare gare taine arewa gapan mondi yoniwamune yawamon. ");
INSERT INTO dgz_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Me anega diamon, ‘E den sia aisen nao nega tan amba dim da tane tamanaepiwa ne garewa ega enain.’ ");
INSERT INTO dgz_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Wani mu nao amon. Amba wam ianupe wareni amba sia wam airase yampoa wareni gapan ap mepe gine daiton tan, ame upi sia tambu me nao mega tapen watu enamon. ");
INSERT INTO dgz_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Amba uiwa me sia aeni upi mondi di yoniwanumune yawamon. Menan singui tayawamon, ‘E iwa dimen wam ma uruga mondi dim da ya tayan yonayan iwanin?’ ");
INSERT INTO dgz_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Mu gare anega wane, ‘Iwa waenapan da nao ya nunane.’ Menan mu inamup anega wan, ‘E den sia aisen, egak nega gapan nao tan.’ ");
INSERT INTO dgz_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Wam ame mum gine taueni, nao i apanewa taue gauarape mega die anega wan, ‘Nao nagire venamu wa tauep garewa muga muga mun. Uiwa tauane nagirewa gapan muna aen e ere tauane nagirewa inamup tauep.’ ");
INSERT INTO dgz_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Nao nagirewa tauane garewa muga munen, ame gapan wam uiwa nao tauane nagirewa namu garewa muga muga denarias daiton tambune. ");
INSERT INTO dgz_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ap menan namu nao tapen watu enamoni nagirewa, anega anun, ‘Nu namu tauatoni menan garewa aigap sia tambuit,’ ap anega anune. Go garewa muga om daiton ame megenat tambune. ");
INSERT INTO dgz_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ap menan nao i apane inap gunat anun anega wan, ");
INSERT INTO dgz_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Uiwa tauane nagirewa wam koni daiton megenat nao tane go garewa nuga om daiton. Go nu wam baware aranen amun gatok arat pit taton.’ ");
INSERT INTO dgz_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Go nao i apane gare wadiamon, ‘Oru ma, ne koewa da inayap ya tan. Nu mumaget agi watoni moni garewa denarias daiton enat waton. ");
INSERT INTO dgz_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ega ega waran aisen. Ne eviwa namua gine daiton munat anuivin ame ne negenat. ");
INSERT INTO dgz_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ne moni nega dim da tat anupena di tain ame ne negenat di e ya watananegene. Uiwa tauane nagirewa baware munana menan e anu koeam mumiwanin go?’” ");
INSERT INTO dgz_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Amba Iesu nop uiwa anega wan, “Ap menan, namu wadiena ameme di, endi evi yonine nagirewa, wam ame gapan, namu yonain. Amba endi namu yonine nagirewa, wam ame gapan, evi yonain.” ");
INSERT INTO dgz_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Iesu pa Ierusalem dot aiwandini gapan, wadiamot mega aonagaet pusinawan dere neginaet anega wadidiam aiwandin, ");
INSERT INTO dgz_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Wapena anun. Nu pa Ierusalem dot anivin, amba Kimani Vitana Apanewa waranege amo pirisi bawarewa amba waenapan iup wadidiamuine nanimu gwanap bat nimanegain amba toguranegepen noa panain. ");
INSERT INTO dgz_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Diu nagire waranege Diu uoni nagirewa nanimu gwanap bat nimanegain. Diu uoni nagirewa nipep dianege wa koeragam nimanegain. Giton en ananege amba wagu gapan tonek wanumain. Amba toguranegep bonigatain go wam yampoa gapan inak nigat sia yon wanigain.” ");
INSERT INTO dgz_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Amba Iesu wa ewamot mega, tase gwani dere, Diemis ge Dion, inamu den Iesu ine tauane. Inamua omanip enu dim da menan anuni mup wan. ");
INSERT INTO dgz_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Iesu waen ame wayaven, “Ge dim da menan anuingi?” Waen ame gare wan, “Otun waina dere mam, toemu gega amunewa warawa gapan mu den bawarewa tap amba mainaga nutup gapan da senip gapan ae wanumop.” ");
INSERT INTO dgz_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Go Iesu gare wan, “E dim da da asik ya tayan amba mup waiwanin. Ne bagu sisi kaumewa napena e den nai go?” Mu gare anega wane, “E, nu den nait.” ");
INSERT INTO dgz_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Menan Iesu sia wan, “Tave di e nai, go mainena nutup o senip gapan ya ve enapen waniai. At mame muna muna Mamana tata kakayat ta muneni nagirewa mugawa.” ");
INSERT INTO dgz_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Iesu wadiamot mega aonagaeta upine nagirewa, mup mame oisewa anune gapan tase gwani derewa inamup ugu gangan mutan. ");
INSERT INTO dgz_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Go Iesu munan wan tauane anega wadiamon, “E asigiap, ian ugupe nagirewa bawarewa muga tamu taiwanum amba gauarapewa wagup warapen menan inamup tayaviwanum. ");
INSERT INTO dgz_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Go e ap anega ya tai. Da me yaumakayap bawarewa tat anupiwa me nao ega taini apanewa entanep. ");
INSERT INTO dgz_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Amba da me namu yonat anupiwa, me nao kaimakaet enan tap. ");
INSERT INTO dgz_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ap umap sia Kimani Vitana Apanewa piup nagirewa ta warit imaepen tauan e ta warit nimanegepen ya tauan. Menan bop tapena waenapan koewa muga garewa mega iravi warain.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Iesu wa ewamot mega tanamo pa Dieriko ae ve aiwandini, to iam baware da me ewap den amuiwanumun. ");
INSERT INTO dgz_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Apan dere yame borat mutane negin etop wanumone, ame mu Iesu tau aiwandini oisewa anune menan mu ve anega wan, “Iesu watageta apane Devit naewa, bagu sisi nunan anu!” ");
INSERT INTO dgz_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Namu onamone nagirewa anega diguguramon, “Nop ae vean,” go mu uma sia anega wan, “Apan Devit naewa, bagu sisi nunan anu!” ");
INSERT INTO dgz_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Iesu ame anuni menan, ae yone mu inamup anega wayawamon, “Ne inayap dim da tat anuiwanin?” ");
INSERT INTO dgz_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","“Ayop nugawa, yamanu watap nuna, yangut tat anuivin.” ");
INSERT INTO dgz_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Iesu bagua munan anu amba naniwa yamamup inatamon. Gine tutup mu yamamu i pak wan yangut tan amba me ewap amon. ");
INSERT INTO dgz_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Iesu, wadiamot megawa den, pa Ierusalem maniwanumune gapan, mu pa namu tauan at ame Oma Olip Yanane Tunupewa. Ap mepe wadiamot dere watu enamo ");
INSERT INTO dgz_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","anega diamon, “Pa sewa namunupe uta aisen tauanewa, use tauan man donki amba me otua da den damiga taumone yawamoi. Man dere ame vetamon, tam onaen, mapa tauan. ");
INSERT INTO dgz_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ap mepe, orup da yawae singui anega wayawaepiwa, ‘E dim da taiwanin?’ Gare manega wan, ‘Ayop nuga, man donki mame munan wan tauaton.’ Amba orup ame, ap anupi gapan, menawaet man ame nenan watu enamota.” ");
INSERT INTO dgz_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Iesu ap anega wani ame nop dim da watageta God no oise waiwandini apanewa da wani tavewa tauen. Me manega wan, ");
INSERT INTO dgz_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Ierusalem nagirewa inamup anega wai, ‘Yawan, Ayop ega, inayap tauiwan, ae bibigaren, man donki gagap oniwan. Apan ame man donki otua gagap oniwan.’ ");
INSERT INTO dgz_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Menan Iesu wadiamot mega wadiamoni gapan gapan di tan. ");
INSERT INTO dgz_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Mu man donki otu dere tambun onamon wanup muga gagap yogune, amba Iesu dore gagap wanden. ");
INSERT INTO dgz_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Waenapan arugataet wanup muga negina yogune, ame taiwanumune newap upinamu oma naniwa ketnagen tauan negina den yogun. ");
INSERT INTO dgz_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","To iam baware ame namup onam wanumune amba evip onam wanumune den nomu ainagasen anega waiwanumun, “Apan Devit otua, gaun baware inagap, God wat aipakamini apanewa, Ayop yaua gapan tauiagi! God paina wandiniwa yaua ao warivin,” ap anega waiwanumun. ");
INSERT INTO dgz_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Iesu pa Ierusalem taueni gapan, pa sewa ame garivi nau bambam mumeni menan anega wane, “Apan ma da?” ");
INSERT INTO dgz_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","To iam baware ame gare anega wan, “Ma Iesu, God no oise wainiwa, me at Galili gapan pa Nasaret apanewa.” ");
INSERT INTO dgz_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Iesu Ierusalem taueni amba God Paewa sin gwanap unuk aen. Ap mepe, wan dim dim muga gare gare une taiwanumune nagirewa gut oimon tau amone. Moni entan wantan taiwanumune watarewa aie yamu tanamon amba watat gapan mu nenip bairantan une taiwanumunewa den baime uatamen. ");
INSERT INTO dgz_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Amba me anega diamon, “God nop mega ok anega sean, Ne pa nega, waenapan ne inanap mup waine paewa, ok ap anega sean. Go e taiana up nagire pa muga karauawa mini entanen!” ");
INSERT INTO dgz_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ap mepe, God Paewa gwanap yame borat mutane amba pusi nani gegerawa tane nagirewa me inap tauane wat inakam mumen. ");
INSERT INTO dgz_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Go pirisi bawarewa amba iup wadidiamuine nagire den Iesu inak kakae taiwandini yawane menan garimu yaven. Orup otu God Paewa gwanap Iesu inap gaun anega waiwanumun, “Apan Devit naewa, gaun baware inagap.” Mu ap wane, pirisi bawarewa amba iup wadidiamuine nagirewa anune. ");
INSERT INTO dgz_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Menan mu Iesu anega dian, “Orup otu diak wanumune ge anuingi go uon?” Iesu gare anega wan, “E, mame God nop mega namua gapan ya batnak anuyan? Wataget nop mega ok ap anega seane, Maman God, aton genapen men orup otu amape den, tavewa gapan wa taragat gimagiwanum. Ok ap anega sean.” ");
INSERT INTO dgz_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Iesu ame wani ewap waenapan pa Ierusalem gapan ae vemo ae pa Betani gapan inen. ");
INSERT INTO dgz_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mumaget Iesu entane Ierusalem aiwandini gapan enup aren. ");
INSERT INTO dgz_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Menan oma baip negin etop yaveni, me ae iap taueni go tavewa da ya yaven, baewa megenat. Boge me oma anega dien, “Ge tavewa gega da sia ya iai!” Gine tutup oma imokae kurat wan. ");
INSERT INTO dgz_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Wadiamot megawa yawane no i kap wan anega wayawan, “Oma anenen menawaet wae inen?” Mu singui tayawane. ");
INSERT INTO dgz_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Iesu gare wadiamon, “Ne tave di wadiaivin, e anu tumat ega wandepiwa amba anu bambam ya tanewa, oma baip inap tana megenat uon, go aigap manega di tai, tunup inap anega wane, ‘Ao yon asepa puimani geak,’ ap anega diane ame di tata. ");
INSERT INTO dgz_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","E anu tumat tanewa gapan dim da menan anun mup God inap wanewa ame e enep warai.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Iesu God Paewa sin gwanap unuk ae opata wadidiam wandini gapan pirisi bawarewa ge waenapan namu yoyo nagire den ine tauan anega wayawan, “Ge amun ansena da waran gapan dim dim mame taingi? Amun mame, da genen?” ");
INSERT INTO dgz_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Iesu gare wadiamon, “Ne singui nega daiton den, namu wayawain, garewa wadianegenewa amba da aro amun neneni gapan taina ame wadiain. ");
INSERT INTO dgz_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Singui nega mam, Apan Dion dup iamuiwandiniwa ame amun mega aupa kimani ware taiwandin go, gare mapa piupa waenapan upi inamup ware taiwandin?” Mu iragi nop waran yaumakamup seyao wareyao muk inga ingane tan amba anega wan, “Endi nu kiman amun mega ware taiwandat wata, me anega dianeta, ‘E dimen Dion nop mega ya anu tumasiwanin?’ ");
INSERT INTO dgz_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Go nu endi anega watawa, ‘Amun waenapan inamup ware taiwandin,’ waenapan ma iragi gwara toguguranain iwa mu asigimup Dion me God watu eneni apanewa.” ");
INSERT INTO dgz_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ap anega anuiwanumune menan Iesu singui mega garewa anega wadian, “Dion amun ame wareni arewa nu oare.” Menan Iesu ap anega diamon, “Ap menan ne den amun nega amba warana gapan ugup ugup mame taina ya wadiain.” ");
INSERT INTO dgz_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Iesu anega wadiamon, “Ne gutut da wadiain. Apan da otu wai dere den. Mamewa otua namua ine taue anega dien, ‘Otunawa endi age nao nega di ta!’ ");
INSERT INTO dgz_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Otua ame gare anega wan, ‘Ne tanda’. Go otua ame, evi amba imua entan tan amba ae nao tan. ");
INSERT INTO dgz_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Boge mamewa ae otua dawa ine taue anega dien, ‘Otunawa endi age nao nega di ta!’ Orup ame wan, ‘Maman, ne angain.’ Go otua ame ya aen. ");
INSERT INTO dgz_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Menan orup ansena mamewa noa waren?” Iesu singui ame wani gapan, Diu ayop mugawa gare anega wan, “Orup namua mamewa noa waren.” Menan Iesu anega wadiamon, “Ne tave di wadiaivin moni bongamine, ame koewa taine nagirewa, amba negin gagape waene den, mu namu God toemu mega kimaniwa tauain go e evi den ya tauai. ");
INSERT INTO dgz_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Iwa Dion taueni e inak tamanawa neginewa to ewaet wa tauen go e anu tumat me inap ya tayan, go koewa taine nagirewa me inap anu tumasene. Mu anu tumasene yawayana gapan den e imuya ya entane anu tumasean.” ");
INSERT INTO dgz_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Iesu sia wan, “Maibe da sia wapena anun. Apan da taba gureip naewa vere sin ikukuk taun. Gureip kaumewa magose warapen menan gwat bonawan gapan urasewa waren. Gopat tapen men dagurak paina tun. Egak mega kwayup ta maup gapan semu baware garewa muga warapen menan nao nagirewa munan wan tauane amba me at da ugup aen. ");
INSERT INTO dgz_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Maup wamewa taueni gapan piup i apane nao mega nagirewa upi watu enamon, amo egak mega amase taine nagire inamup tauan, maup semua i apane wanapen menan mup wan. ");
INSERT INTO dgz_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Go kwayup taine nagirewa gut oimon, mu daiton gaut enane dawa togurane boen amba yampoa agima toguran. ");
INSERT INTO dgz_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Egak i apanewa namu nao taine nagirewa aruga ya watu enamon go evi aruga watu enamon amon. Tauane egak kwayup taine nagirewa inamup gine daiton sia tane. ");
INSERT INTO dgz_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ui iragenawa, me otua inamup watu ene anega anun, ‘Mu ne otuna viripewa tain.’ ");
INSERT INTO dgz_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Otua watu enen oniwandin amase taine nagire paina yawan muk ase ma anega wawa mutan, ‘Piup i apane otua oniwan. Apan mam iman egak ma yon boreta, menan anet togurat boep, amba egak mame boge nu yon borat.’ ");
INSERT INTO dgz_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Menan waran sin garip uat enan togurane boen. ");
INSERT INTO dgz_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ap menan wam ame nao i apanewa tauepi nao nagirewa inamup anenen tata?” ");
INSERT INTO dgz_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Iesu singui wani ayop nagirewa gare anega wan, “I apane taue koerage pia inine nagire gut momak mumeta amba egak mega waenapan upi munep kwayup tain. Maup wamewa gapan gapan taba mega wanain,” ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Iesu ayop nagire sia wadiamon, “Ame umap di go God nop mega ok seane e batnagean. Ok ame anega waiwan, Agim ame pa tuine nagirewa tandayasen, koerage dian, go God agim ame ware entanen amba pa tuine danewa venasen. Ayop mame kakae di tan menan nu tarage waivin. Ok ap anega sean. ");
INSERT INTO dgz_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ap menan, wapena anun, God toemu megawa e waseae amba amun mega eneni waseaeta, waenapan ugup, God menan yambuni ta amuine nagirewa, muneta. ");
INSERT INTO dgz_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Menan waenapan da da agim ame aigap onan geamopiwa, ame kaime no topait wa pait ta seta, go gare agim ame orup da aigap gearepiwa ame to gogotonagep atabobo venaseta,” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Pirisi bawarewa Parisi nagirewa den mu asigimup, Iesu gutut ame mu koewa muga menan waiwandin. ");
INSERT INTO dgz_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Menan mu ugu gangane den Iesu to warat anun go waenapan guramopi tawa anun, iwa waenapan Iesu God noa waini apanewa da anune menan. ");
INSERT INTO dgz_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Iesu maibe gapan sia anega wadiamon, ");
INSERT INTO dgz_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Toemu kimaniwa guegue manega, ayop da otua waen naitapen tani barip mega tan. ");
INSERT INTO dgz_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Me nao mega nagirewa watu enamon amo, da da barip gagewa onamot wani ame wadiamop onamopen, go mu iravi tanda wane. ");
INSERT INTO dgz_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Menan me nao nagirewa upi sia watu enamon, nop manega wadiamopen menan watu enamon, ‘E iravi onaen iwa ne antaba gaset tunun sese kakayat tan. Man nega kao ine otu dere guran amba wan dim dim iragi gaset ta kakayasen, ganawan barip aige onaen.’ ");
INSERT INTO dgz_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Go mu nop muga to kayasen amba daiton nao mega aen, dawa wan dim dim mega une gare gare taini arewa aen. ");
INSERT INTO dgz_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Upinamu nao nagire megawa tambun guramone borit wan. ");
INSERT INTO dgz_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ayop ame ugu gangan naen menan ita nagirewa mega watu enamon amon koewa tane nagirewa enu girigamen guran pa sewa muga uta it baimene. ");
INSERT INTO dgz_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ame tani amba me nao nagirewa mega upine diamon, ‘Naine mutat baripewa tata kakayat gaset tan, go waenapan venamu wana mu koerage menan ya tauep. ");
INSERT INTO dgz_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ap menan negin ni enoa ise tau ase tau aisen amba waenapan da tautanamonewa munan wane barip aigewa onamop,’ ap anega diamon. ");
INSERT INTO dgz_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ap menan nao nagirewa tau amon, waenapan iragi negin gage gage upamon togonen, mu da da iragi tanamonewa, kakaewa ge koewa, ai onamone amba naine mutat baripe paewa gwanap barat mutane. ");
INSERT INTO dgz_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Barip wamewa gapan ayop ame taue apan da naine mutat wanupewa ya panen yaveni menan singui anega wayaven, ");
INSERT INTO dgz_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‘Enda, ge anenen amba mapa unuk tauan go naine mutat wanupewa ya panaana?’ Apan ame nop uon tan. ");
INSERT INTO dgz_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","No uon wandeni menan ayop nao mega nagirewa diamon, ‘Orup ame pusi nani taun garip sisipu aipa uat enan.’ At sisip ame gapan waenapan irip waiwanumun amba asi kitonak wanumun.” Iesu maibe ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Amba Iesu sia anega wan, “God waenapan aruga munan waiwan go agiap om enumon.” ");
INSERT INTO dgz_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ian Parisi nagirewa tau amon, Iesu anenen tap nop wabambamasepen menan nopewa panan. ");
INSERT INTO dgz_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Wadiamot muga upi amba Erodian nagirewa den, Iesu ine watu enamone tauane anega wayawan, “Wadianet nugawa, nu asiginup ge waenapan muk anen wane taine ame menan ge imuga potaga ya wariniwa, go ge nop tavewa gapan God dim dim anuini om ap gapan tainampen neginewa wadianianawa. ");
INSERT INTO dgz_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Menan nu singui nuga mam. At Rom ayopewa Sisa nu moni se wanata ame gapan nu Mosis iup mega yamatait go uon?” ");
INSERT INTO dgz_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Go mu nanamaset wan taiwanumune Iesu me asigip tan, menan me anega wan, “E da wa da ta taiana nagirewa dimen wayawanek wanin? ");
INSERT INTO dgz_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Endi moni gwat make da ewanegen.” Mu gwat make da wat onamone. ");
INSERT INTO dgz_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Iesu singui wayawamon, “Yawan, moni mame gamup da yaua o guewa ok seane?” ");
INSERT INTO dgz_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Mu gare anega wan, “Ame ayop Sisa guewa mega gamup wandia.” Menan Iesu anega wan, “Ap menan, wan dim dim Sisa mega wandepi ame Sisa di wanapen. God mega wandepi, ame God di wanapen.” ");
INSERT INTO dgz_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Wam ame mu nop mame anune tarak wan, menan mu ae vean amon. ");
INSERT INTO dgz_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Wam ame daiton, dugup Sadusi nagire, upi Iesu inap tauan. Mu dugup anu tumat muga gapan waenapan manega wadidiam wanumun, “Borit wata sia ya inak nitait.” ");
INSERT INTO dgz_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Menan Iesu inap singui anega wayawan, “Wadianet nugawa, watageta apane Mosis nunan iup anega sen, ‘Apan da waenewa otu uon boepi gapan me gwaniwa kwapura ame naise tasewa uewa orup se wanep.’ ");
INSERT INTO dgz_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Endi apan upi tatap gwanip yananewa nanin yamunaet yamunewa dere mugenat wanumon. Namu bonewa mugawa waen naiseni go me otu uon boen menan gwaniwa ewap yaneni, tasewa kwapuraewa sia naisen ");
INSERT INTO dgz_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Gwaniwa orup da ya baraeni amba boen. Gwaniwa yampoa kwapura sia naisen. Ap anega ta amo wanumune dugup daiton apan nani yamu dere waen ap daiton naitan. ");
INSERT INTO dgz_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Amba uiwa waen kwapura ame den sia boen. ");
INSERT INTO dgz_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ap menan endi apan nanin yamunaet yamune dere waen ame naitanewa go wam uiwa gapan waenapan inak muse sia yon wanumopi waen ame apan ansenawa waenewa?” ");
INSERT INTO dgz_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Iesu Sadusi nagirewa gare wadiamon, “E aopan waiwanin iwa ok seane e asik ya tayan amba God aro amun mega den e oare. ");
INSERT INTO dgz_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Go waenapan borit wane evi amba sia yon wanumopi inak yaibobot eviwa gapan mu gare gare ya naine mutain, den ore wai naine mutapen menan ya munain. Iwa mu anea umap wanumoin sia ya borit wain. ");
INSERT INTO dgz_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Inak muta muta nagirewa gueguewa ame God wataget wat arogamen. Iwa watageta gapan God e inayap anega wan, ");
INSERT INTO dgz_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Omae baewa Eibaraam, otua Aisik, amba upewa Diekap, mu God muga daiton ame ne di. Ap gapan endi nu asiginup ame waenapan kabaniwa ge bonigawa mu God yamap iravi kabani wanumamun, iwa mu guamu den.” ");
INSERT INTO dgz_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Wam ame waenapan nop mame wadiamon anune, tarak wane. ");
INSERT INTO dgz_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Parisi nagirewa Iesu Sadusi nagire nop muga wa toboboramoni oisewa anune menan todagon wanumon. ");
INSERT INTO dgz_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Apan muga da, me waenapan iup wadidiamuini amba Diu iup muga anu kakayasini otua, pusi warup ta Iesu irewa yawapen menan watu enane. Singui anega wayaven, ");
INSERT INTO dgz_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Wadianet nugawa, God iup mega ansena baware iragen?” ");
INSERT INTO dgz_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Iesu gare wan, “Ge Ayop gega God, imuga potaga gapan, guaga gapan, epara guin pakao gega gapan, iak guine gapan, menan ae anu guringan. ");
INSERT INTO dgz_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Iup mame aigap iragen. ");
INSERT INTO dgz_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Derewa ap umap sia manega. Gek genan ae anu guriana mini, evenak waiga pa mainagape wanumuine nagirewa munan den anu guringan ");
INSERT INTO dgz_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mosis iup mega iragi amba God no oise waine nagirewa nop muga den iup dere mame onemup aoma yap enane wanumamun.” ");
INSERT INTO dgz_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Wam ame gapan, Parisi nagirewa iam wanumone gapan, Iesu singui wayawamon, ");
INSERT INTO dgz_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“God mega wa watu eneni Keriso dim da anuiwanin? Me da naewa megawa?” Mu gare anega wane, “Me apan Devit naewa.” ");
INSERT INTO dgz_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","44","Iesu sia wan, “Keriso me Devit naewa wane tavewa di go iwa dimen God Guewa ayop Devit wa ewaseni gapan me Keriso Ayop megawa dien? Iwa watageta bukaewa, yaua Sam, gapan Devit Keriso evi amba me denip mega gapan tauapen menan ok anega sen, God yone Ayop anega wadien, ‘Nanina nutup arigewa gapan ae wanigingan, ne anavi gega tambup gauaragap singapena menan.’ ");
INSERT INTO dgz_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Nop ma gapan, Devit yone Keriso inap me Ayop diwandin go Devit namu yaneni apanewa amba Keriso evi yanen menan anenen entane Devit naewa mega ayop dien?” Iesu singui ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Iesu singui wayawamoni Parisi nagirewa gare wa wa da uon. Wam ame gapan waenapan singui evi da sia ya wayawat anun. ");
INSERT INTO dgz_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Boge Iesu to iamene nagire ge wa ewamot mega anega diamon, ");
INSERT INTO dgz_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Iup wadidiaine ge Parisi nagirewa mugenat watageta apane Mosis iup mega gueguewa wa arogamine nagirewa. ");
INSERT INTO dgz_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ap menan wadiaepi anu tan go guegue muga taine gapan ya tane. Iwa mu da wa da ta taine nagirewa. ");
INSERT INTO dgz_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Mu iup ni enowa mega anu geonagene, go nop muga itani den waenapan ae natam wanum. Ap menan waenapan nop ame ware tapen menan umamup uon. Go waenapan wat agoat mumapen menan ya anuiwanumun. ");
INSERT INTO dgz_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Mu waenapan yawamopen men guegue muga taiwanum. God nop mega seane namu bonap ge nanip paniwanum. Amba God menan wanup muga ginewa ragigie den eniwanum. Ap taine gapan waenapan yawamone anu tumat nagirewa diamuiwanum. ");
INSERT INTO dgz_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Barip arewa gapan waenapan virimu tat amba watat kakaewa munat anuiwanum amba iup anuine paewa gwanap watat kakaewa gapan wanumot anune taiwanum. ");
INSERT INTO dgz_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Une arewa gapan gaunamu wat anune amba wadiamuine nagirewa diamot anuiwanumun. ");
INSERT INTO dgz_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Go e iravi wadiamot nagirewa ya diaepen iwa wadiaet ega daiton megenat wandia amba e iravi tase gwani, dugup daitonawa. ");
INSERT INTO dgz_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Amba piup apane da maman ya diane, iwa e Mamaya daiton kimani wandia. ");
INSERT INTO dgz_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Orup da e namu yoyo ya diaepen, iwa e namu yoyo egawa daiton megenat, ame Mesaya. ");
INSERT INTO dgz_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Da me yaumakayap bawarewa tat anupiwa me nao ega taini apanewa entanep. ");
INSERT INTO dgz_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ap umap sia, orup da da muk ingane yaumua ao wabawaraminewa ame God aoma wat otutam mumeta, amba waenapan da muk ingane yaumua aoma wat otutaminewa ame God ao wabawaram mumeta.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Iesu sia anega wadiamon, “Anun, Parisi amba iup wadidiamuiana nagirewa, e da wa da ta taiana nagirewa, itan baware yawai. Waenapan God anupen men taine watanamuiwanin. E God ya anut anuiwanin go God anut anuine nagirewa watanamuiwanin. ");
INSERT INTO dgz_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Anun, waenapan iup wadidiamuiana Parisi nagirewa den, e da wa da ta taiana nagirewa itan baware yawai. Kwapura nagirewa puraput muga garaet tambuiwanin. Waenapan yawaepen men God inap mup nononga waiwanin. Ap taiana menan God itan bawarevet eneta. ");
INSERT INTO dgz_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Anun, waenapan iup wadidiamuiana ge Parisi nagirewa den, e da wa da ta taiana nagirewa itan baware yawai. Apan daiton guegue ega anu tapen men puiman asepa gan at at iragi den yoa taiwanian. Orup ame waranewa me guegue egawa asik tapi gapan koewa ega megenat ya tata go aigap sia taiwandata. Menan e merao arewa aisene itan baware yawai go apan ame aigap iragen yaveta. ");
INSERT INTO dgz_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Anun, e negin asigipewa nagirewa go e yamaya borasen, itan baware yawai. Iwa e waenapan anega wadidiam wanin, orup da God Paewa inap agi wapi, amun ya wareta, go agi ame God Paewa gwanap puraput yananagaet gwayayame den gamup wapi, agi ame tavewa venaseta. ");
INSERT INTO dgz_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","E yamae borasen bumbum bambam! Ap ya wai, iwa God Paewa ame aigap amba puraput yananagaet gwayayam denawa gauarap iwa God Paewa gwanap wanumune menan God wat aipakam mumen. ");
INSERT INTO dgz_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Amba sia, e anega wadidiam wanin, orup da God Paewa gwanap God menan yan garaet sine watarewa gapan agi wapi, ame amun ya wareta, go orup ame yan garaet ame gapan agi wapi ame tavewa venaseta. ");
INSERT INTO dgz_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ap menan e yamaya borasen! Aritawa ansenawa, yan garaetawa o gare yan ame wat aipakamini watarewa? ");
INSERT INTO dgz_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ap menan, me da agi watat inap waniwa me wan dim dim iragi gagapewa gapan den agi waiwan. ");
INSERT INTO dgz_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Menan me da God Paewa gapan agi wapi, God nuga pa gwanap wandini inap den waiwan. ");
INSERT INTO dgz_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kiman amun mega gapan agi wapi ame God ae wandini arewa gapan den agi waiwan. ");
INSERT INTO dgz_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Anun, waenapan iup wadidiamuiana ge Parisi nagirewa den, da wa da ta taiana itan baware yawai. Iwa kutut ugup ugup danse dena aonagaet tambuiana daiton ewagai sia God men bariana ame kakae. Go God menan koewa wat tamanam gueguewa amba God baigan mega gueguewa ya taiwanin. Kutut ugup ugup upi God men barat anune umap di go guegue bawarewa den taiwanian. ");
INSERT INTO dgz_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","E negin asigipe nagirewa yamaya borasen. Iup otu koentu iravi ayamase taiwanin go iup bawarewa e to paisiwanin. ");
INSERT INTO dgz_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Anun, waenapan iup wadidiamuiana ge Parisi nagirewa den, e da wa da ta taiana itan baware yawai. E taba naine yogupewa ge kaum naine sipewa gariwa megenat bigi guriwanin, go e potaya iragi wan dim dim koewa gui togon tayan wandia. ");
INSERT INTO dgz_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","E Parisi nagirewa yamaya borasen. Namu sip yogup gwanewa bigi warane amba gariwa den kakae wandeta. ");
INSERT INTO dgz_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Kaiwan, waenapan iup wadidiamuiana ge Parisi nagirewa den, e da wa da ta taiana itan baware yawai. E yawaet ega etuya gapan kakae yaviwanum go guegue ega koerage, e yawaet ega garia gapan kakae go gwanapewa apan boeni kaimewa no dotouen amba wan dim dim iragi puakaini aninke dena, e ap umap. ");
INSERT INTO dgz_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","E yawaet ega ap me di, garip kakae go gwanapewa potayap ebo aopan bararaen amba koerage.” ");
INSERT INTO dgz_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Iesu sia wadiamon, “Anun, waenapan iup wadidiamuiana ge Parisi nagirewa den, e da wa da ta taiana itan baware yawai. God noa wataget waiwanumune amba kakaewa taiwanumune nagirewa omae baewa guramone amba borit wane kaima muga arewa kwayup taiwanin. ");
INSERT INTO dgz_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ap tayan anega waiwanin, ‘Nu omayan baewa wamewa den waninepo mu God noa waiwanumune nagire guramone borit wane nu ap umap ya tapo.’ ");
INSERT INTO dgz_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ap anega wane, ek ae enu yawayan waiwanin, iwa guramone nagirewa naewa muga e me di. ");
INSERT INTO dgz_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Omae bae koewa muga ya taitamene go endi e taitamen. ");
INSERT INTO dgz_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Guegue ega mokare seram naewa umap. God merao arewa aiset wapi e anenen mainep tau aitai? Umap uon. ");
INSERT INTO dgz_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ap menan God noa anune waine amba dima nagirewa amba Mosis iup mega wadidiaine nagirewa den inayap watu enamuivin. Go e upi guramone borit wain amba upi oma gapan gut batam mumai, amba upine iup anuiana pae gwanap gaura guramoi amba pa sewa sewa gapan wa koeragam mumane gapan gut oimop tau ge tau amoin. ");
INSERT INTO dgz_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ap tane menan waenapan at at iravi kakaewa taiwanumune nagirewa guramone garewa inayap taueta. Erewa gapan ame apan kakaewa Eiboro, namu to boniga baraene amba oniwandin e amba Berekaya otua Sekaraya God Paewa man irine watarewa yaumakap e omae baewa tone boen. ");
INSERT INTO dgz_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ne tave di wadiaivin. Koewa ame garewa endi waniana nagirewa inayap taueta.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Iesu Ierusalem menan anega wan, “Ierusalem, O kaiwan Ierusalem nagirewa! God noa waine nagirewa guramuiwanian borit waiwanum upi inayap watu enamoni agima guramuiwanian. Wam wam aruga kumkum otu wai ai bongamen magua gauarap enini, ne ap umap waenapan gega ai dangonet anun taivin, go e ap anega ya tat anu nimanegiwanin! ");
INSERT INTO dgz_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ap menan yawan, God Paewa, Ierusalem gapan, konintu amba e Diu anavi egawa taue to benagep pokaet wandeta. ");
INSERT INTO dgz_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Amba iman e sia ya yawanegai. Go wam ansena evi da amba e ne inanap anega wai, ‘Ayop yaua amunewa gapan tauiagi, ap menan God wat aipakam gimagia,’ ap gapan, ne sia yawanegai.” Iesu ap anega wadiamon. ");
INSERT INTO dgz_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Iesu God Paewa ae ve amba tau aiwandini gapan wa ewamot mega me inap tauan anega wane, “God Paewa amba pa mainepewa upine den iravi kakaevet di tumone!” ");
INSERT INTO dgz_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Go Iesu gare anega wadiamon, “E pa mame iragi yaviana menan nop nega anun. Wamewa da tauepi gapan anavi ega taue pa ma iragi to bebenak ae seain, gwat da daiton didi batamene diriga aita ya wanumoin,” ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Wam ame evip, Iesu Oma Olip Yanane Tunupewa gapan wandeni, wa ewamot mega inap tauan wam paua anupen menan mugenat karaua singui wayawan, “Pa mame iragi to bebenak ae seapen wamewa andi amba taueta? Amba wam verisiwa amba ge sia tauapen wamewa taiwandapina, paua mega dim dim da namu taue aiwandapina yavinain?” ");
INSERT INTO dgz_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Iesu gare wadiamon, “Agun anun, waenapan da da aopan wababayan imaepi tawa. ");
INSERT INTO dgz_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","E yao kakayat amba wanien, da aopan wababayan imaepi tawa. Waenapan iman arugataet taue, amba anega waiwanumain, ‘Ne Mesaya,’ amba arugataet ebo ewamoin. ");
INSERT INTO dgz_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ita anan tapi oisewa anui amba ita anan tapen tapi oisewa anui go tap ya anune. Ita anan ame iravi taiwanumain go ap gapan wam verisiwa ya taueta. ");
INSERT INTO dgz_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ita anan agagae taue aiwandapina yawanewa, ame tap ya anu gurane. Wankakao ge puinunu amba inak aru ap mini namu venase di tau aeta, go wam uiwa ap mepe ya taueta. ");
INSERT INTO dgz_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Go mame iragi itan bagu sisi erewa da. ");
INSERT INTO dgz_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ap wamewa, waenapan e panae togugurae amba wa koeragam imain upi gurayep borit wai. E ne dugup nega nagirewa menan waenapan iravi at at gapan tandayat imain. ");
INSERT INTO dgz_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Wam ame gapan waenapan arugataet anu tumat taine entan ta ae veain amba tanda ta ominamu gare gare wain. ");
INSERT INTO dgz_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Wam ame gapan, God oit mega tave uoni waine nagirewa aruga yone waenapan aruga aopan wababayan mumain. ");
INSERT INTO dgz_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Koewa wabawaremep amba baigan kakaewa to umep bigaret wane taiwanum. ");
INSERT INTO dgz_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Go e da da nenan aro ta waniwaniampina inak yaibobot di wariwaniai. ");
INSERT INTO dgz_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Amba God toemu mega No Oise Kakaewa at at iragi piup ma gapan wadidiam wanumain amba waenapan munan tani oisewa iravi anuin, boge wam verisiwa taueta.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Iesu sia anega wan, “Nop mame batnagine nagirewa batnagepi anu kakayasep. God noa wataget waiwandini apane Daniero namu wani ap me tauepi mam. Apan da pa Ierusalem God Paewa wabigamepen menan guewa koewa iragen da wat taue endavep yawai. ");
INSERT INTO dgz_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ap yawanewa gapan, e at Diudia gapan wanienawa tap serarat aise tunupa dot aitai. ");
INSERT INTO dgz_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Amba apan da pa aigarip wandepi pa gwanape puraput mega da ya warep go serarat tap aep. ");
INSERT INTO dgz_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Amba orup da egaga wandepi me wanup mega menan ewagai ya aep. ");
INSERT INTO dgz_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Wam ame inepi wamewa, kaiwan, waen bagu dena o orup otu ine amape nagirewa inamup kaimake den! ");
INSERT INTO dgz_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Tap aise aise bodu wamewa go pura bawarewa wagat wamewa gapan ya venasepen menan God inap mup waiwanian. ");
INSERT INTO dgz_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Iwa wam ame gapan ita anan bagu sisi baware iragen taueta, erewa gapan ma onin en mame tauini ap mini da ya venasen amba inak ap mini da sia ya venaseta. ");
INSERT INTO dgz_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Menan wam ame om mega God ya wat oninkamepo, waenapan iragi borit waitamepo, go om enumoni nagirewa mugenat munan wam ame wat oninkameta.” ");
INSERT INTO dgz_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Wam ame gapan waenapan da anega wapi, ‘Yawan, Mesaya ma tauen!’ o ‘Atapa tauen!’ da ya di anu tumasene. ");
INSERT INTO dgz_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Iwa Mesaya eboewa amba God noa tave uoni waine nagirewa taue yo paua aigape taiwanumain. God om enumoni nagirewa aopan wababayan mumapen tayawaiwanumain. ");
INSERT INTO dgz_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Wapena anun. Ne mame ya venaseni gapan namu e wadiaen. ");
INSERT INTO dgz_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Amba da orup da anega wadiaepi, ‘Onaen yawan, Mesaya at kaimewa gapan sia tauen wandia,’ ap anega wapi yawapen ya aisene. Mu sia anega wapi, ‘Onaen Keriso sia tauen karaua wandia,’ ap anega wapi, nop muga ya anu tumasene. ");
INSERT INTO dgz_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Iwa yangwan warin kiman ganase waini mini, Kimani Vitana Apane wam nega sia tauepi gapan waenapan yawanegain. ");
INSERT INTO dgz_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Maibe nega ma anun. Bonigawa etua wandepi arewa gapan, nenip tukau, etua napen menan ap mepe iamain.” ");
INSERT INTO dgz_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Iesu sia wadiamon, “Ita anan bagu sisi baware wamewa ame uon tapi gapan wam pumpuni ta, sisip taueta, amba siragam ganase sia ya wata. Buanae kimani aoma geareta, amba kiman aroewa da da erere goyago amoin. ");
INSERT INTO dgz_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ap gapan, Kimani Vitana Apanewa wam ame gapan tauapen tapena, paua nega kimani venaseta amba at at iragi piupawa irip turup wain iwa ne amun baware, oya oya ganasewa nega den irikup nokap tauapena yawanege seke tain. ");
INSERT INTO dgz_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Pum upunepi gapan, anea nega watu enamopen, waenapan negawa piup etoa asiwa iragi wa upamoin.” ");
INSERT INTO dgz_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Oma baip guegue mega yawane gapan anun. Gua ewake topi anuiwanin, bodu wamewa konintu taiwan. ");
INSERT INTO dgz_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ap umap sia, e wan dim dim mame tau aiwandapinawa, e anega anui, ne konintu tonana yonivin. ");
INSERT INTO dgz_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ne nop tavewa wadiaepen anun. Endi mame piupa yanane wanumamune nagirewa, wam muga gapan wan dim dim mame venat taue aep amba borit wain. ");
INSERT INTO dgz_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Piup ge kiman iman ise wat museta, go ne nop negawa di wande aiwandata.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Iesu sia wadiamon, “Ne God otua, sia tauapena wamewa orup da daiton asigip ya di tan, anea kimaniwa den oare amba ne den oare, go Mamana kimaniwa megenat asigip tan. ");
INSERT INTO dgz_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kimani Vitana Apanewa sia tauapena wamewa ame apan Noa wam mega gapan waenapan taiwanumune ap umap sia di tain. ");
INSERT INTO dgz_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Menan, wataget Noa wam megawa gapan waenapan wanumon, taba kaum nana kakayat taiwanumun, amba waen ge apan naine musiwanumun. Mu ap anega taiwanumune gapan, Noa kabum mega gwanewa unuk aen amba boge ningoe taue umamon borit wane. ");
INSERT INTO dgz_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Wam ame gapan ningoe oniwandini waenapan mu oare amba umamon mom yapen tau aen. Ap umap Kimani Vitana Apanewa sia tauapena wam ame e den oare. ");
INSERT INTO dgz_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Sia tauapena, apan dere nao taiwanumampina, daiton warain da ae veain. ");
INSERT INTO dgz_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Amba sia, wam ame gapan, waen dere taba napen menan kanu etua wariwanumampina, daiton wat angain amba dawa ae veain. ");
INSERT INTO dgz_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ap menan nene yamam taiwanian, iwa e oare wam ansena Ayop ega taueta. ");
INSERT INTO dgz_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Amba sia anu awan. Pa i apanewa wam ansena up apane tauapo anupo me nene yamam ta wandepo, amba up apane ame warup oisepo, ap gapan pa mega ya benak unuk aepo. ");
INSERT INTO dgz_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ap mini Kimani Vitana Apanewa wam ansena sia tauapena e oare, ap menan yama agun taiwanian.” ");
INSERT INTO dgz_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ayop Iesu maibe gapan gare anega wan, “Pa i apane nao mega taini asigip tan menan noa warini apanewa ware pa mega kwayup tapen dien. Amba nao mega taini apanewa ame ago nagire upine taba muga muga muniwandapen menan die amba at ugupe daio aen. ");
INSERT INTO dgz_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","I apane ae sia entan tauepi wamewa gapan, nao waneni apanewa nao mega taiwandapina yavepi nao taini apanewa ame aton arita anuta. ");
INSERT INTO dgz_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Tave di waivin, me nao kakae tani menan, pa i apane puraput mega iragi kwayup tapen dieta. ");
INSERT INTO dgz_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Go nao taini apanewa mek ingane koewa anega anupiwa, ‘Ne Ayop nega menawaet ya taueta.’ ");
INSERT INTO dgz_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ap anuni menan, nao nagirewa upinewa gaura bim bim guramo ae semo amba nao ae ve taba kaum kaimake dena na, bumbawam ta aiwandata. ");
INSERT INTO dgz_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ap taiwandapina, pa i apanewa tauepi wamewa me oare menan me tauepi seke tata. ");
INSERT INTO dgz_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","I apane taue wanene baware tata amba wam uiwa gapan apan ame God ya anu tumasene ge borit wane nagirewa at muga aeta. Ap mepe mu irip turup wa asi kitonagiwanumain.” ");
INSERT INTO dgz_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Iesu sia wadidiamon, “Wam ame gapan, toemu kimaniwa guegue mega manega, waenoro aonagaet da dun muga tambun naine mutat baripe da i apane tautanapen menan tau amon. ");
INSERT INTO dgz_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Waenoro nani yamunaeta bumbawam nagirewa amba waenoro nani yamunaeta ame asigipewa. ");
INSERT INTO dgz_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Menan bumbawam nagirewa dun muga tambune go kaum muga senunawa da den ya utan tam amon. ");
INSERT INTO dgz_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Waenoro asigipe dun muga tambune amba kaum muga senunawa den tam amon. ");
INSERT INTO dgz_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Barip i apane taua taua wam nononga ase ma di tan, ap menan waenoro iragi aup enu keo tan di iniwanumune. ");
INSERT INTO dgz_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Mum gagewa gapan apan da nop kaimakaet ve anega wan, ‘Naita naita apane tauia! Tau aisen tanan!’ ");
INSERT INTO dgz_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Boge waenoro iravi kanda mutan yonan amba dun muga ni tunu paitamon. ");
INSERT INTO dgz_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Waenoro bumbawam tainewa yonan waenoro asigipe singui ta anega wayawamon, ‘Oruma kaum upi gem nunan, dun nuga yame gaup wapen taiwanumun.’ ");
INSERT INTO dgz_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Asigipe waenoro gare anega wan, ‘Ae uon. Kaum enan amba nunan ame umap uon anuivin. Garewa aisen une taine arewa tauan ek da une di tan.’ ");
INSERT INTO dgz_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Go wam ame mu une tapen menan amone, naine mutat i apane tauen. Waenoro upine tata kakayat tane menan apan muga tanan naine mutat baripewa menan pa gwanap unum amon amba tonan boren. ");
INSERT INTO dgz_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Evi amba upinamu sia tauan anega wane, ‘Bawarewa! Bawarewa! Tonan nunan watap!’ ");
INSERT INTO dgz_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Go me gare wadiamon, ‘Wapena anun. Ne e oare,’ ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ap menan nene yamam taiwanian, iwa ne wam ansenawa gapan tauapena e oare.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Iesu sia wan, “Wam eviwa guegue da wadiain. Ayop da negin nononga aepen tani, nao mega taine nagire munan wa anu dao mume kwan puraput mega munen. ");
INSERT INTO dgz_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Nao tat muga muga gapan moni mega ap munen. Daiton moni nani yamunaet wanen. Dawa moni dere wanen. Dawa daiton wanen amba ap aen. ");
INSERT INTO dgz_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Moni nani yamunaet tambuni apanewa menawaet ware ae nao ta amba nani yamunaet aigap sia waren. ");
INSERT INTO dgz_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Moni derewa apanewa ap umap tani amba dere aigap sia waren. ");
INSERT INTO dgz_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Go moni daiton wareni apanewa wat ae piup urat ware amba moni mega karaua urata tu umen. ");
INSERT INTO dgz_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ayop mugawa wam nonongataet wandeni ewap entan taue nao nagire mega moni waran dim da tane menan singui tayawamon. ");
INSERT INTO dgz_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Apan moni nani yamunaet tambuni, nani yamunaet aigap den sia ware taue anega wadien, ‘Ayop negawa, ge moni nani yamunaet nenaana ne garewa aonagaet genian.’ ");
INSERT INTO dgz_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ayop mega gare wadien, ‘Ge umap di, nao nega kakae di taan nona wariana apanewa. Ne otu kamontu genana gapan nona wara ta agingian. Ap menan puraput nega baware kwayup tamopen bat gimagivin. Aton nega geniangina gapan wanigingan.’ ");
INSERT INTO dgz_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Apan moni dere tambuni ine taue anega wan, ‘Ayop negawa, moni dere nenaana ne garewa degede genian.’ ");
INSERT INTO dgz_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ayop mega gare wadien, ‘Ge umap di, nao nega kakae di taan nona wariana apanewa. Ne otu kamontu genana gapan nona wara ta agingian. Ap menan puraput nega baware kwayup tamopen bat gimagivin. Aton nega geniangina gapan wanigingan.’ ");
INSERT INTO dgz_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Amba apan moni daiton wareni ine taue anega wan, ‘Ayop negawa, ne asigip tagen ge kaimake dena apanewa, ge taba ya veriana go naingi piup ya enuiana go bongamingi. ");
INSERT INTO dgz_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Menan ne taga anun angena moni gega karaua urata tu uman. Yao, dim da gegawa mame.’ ");
INSERT INTO dgz_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ayop mega gare dien, ‘Ge koerage, nao ya taan endave wandave den taiana apanewa. Ge anuana ne nawan uon, taba ya veran naivin, amba piup ya enun bongamivin. ");
INSERT INTO dgz_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Menan iwa dimen ge moni nega enine arewa gapan bondan mini ya baraan aigap da ya waraan? Ge ap tapo ne entan tauana gapan, moni enine arewa kwayup taine apanewa, ap mepe moni enaana menan, moni maup mega otu da aigap nenapo.’ ");
INSERT INTO dgz_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ayop ap anega wani orup upine diamon, ‘Apan ma moni mega daiton waseasen, ame moni aonagaeta neneni apanewa wanan. ");
INSERT INTO dgz_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Wapena anun. Nop nega anune taine nagirewa God nop upi sia muneta. Go ya anune taine nagirewa nop otu da anunewa ame sia waseamota. ");
INSERT INTO dgz_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Amba apan koewa endi waran garip sisipu aipa uat enan. Ap mepe mu irip turup wa asi kitonagiwanumain.’” Iesu maibe gapan ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Iesu sia wadiamon, “Wam uiwa gapan, ne, Kimani Vitana Apanewa, Mamana kakae guragut mega ganasewa warap amba ayop watarewa nega gagap ae wanigepena gapan ne anea nega den, ");
INSERT INTO dgz_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","piup at at nagirewa iravi namunap todagon wanumoin. Man kwayup taini apanewa man gout ge man sip yan semopi mini ne waenapan yan semoin. ");
INSERT INTO dgz_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Kakaewa taine nagirewa, man sip umap nanina nutup gapan seain amba koewa taine nagirewa, man gout umap senip gapan seain. ");
INSERT INTO dgz_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ame uon tapi, ne, waenapan ayop mugawa, nanina nutup gapan wanumopi nagirewa anega wadiamoin, ‘Onaen! e iravi Mamana wat aipakam imaini nagirewa! Piup ta venasen oneni paua gapan toemu tata kakayat enan ta baraeni yon boran. ");
INSERT INTO dgz_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Onaen, iwa ne enup aranegen menan e taba nenayan nan, ne megana pakaraeni menan e kaum nenayan nan, ne at ugupewa apane da tauan e warupanege pa ega gwanap bat nimanegean. ");
INSERT INTO dgz_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ne nin aroga waingena e gan gorogot pan nenayan, ne vek tana e amatana tayan. Amba ne gwat nokap wanigena gapan e nenan daio tauayan.’ ");
INSERT INTO dgz_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ne ap anega wadiamopena nanina nutup wanumopi kakaewa taine nagirewa gare anega wain, ‘Ayop nugawa, wam ansena enup arageni yawaget taba genaton o megaga pakaraeni kaum genaton? ");
INSERT INTO dgz_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Amba wam ansena ge oarewa nu waupaget pa gwanap bat gimageton? o gan gorogot yoa taingian amba nu gan gorogot pan genaton? ");
INSERT INTO dgz_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Amba wam ansena vek waragen amataga taton o gwat noke waingean yawaget daio inagap onanton?’ ");
INSERT INTO dgz_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ap anega wapi ne, waenapan ayop mugawa, gare anega wadiamoin, ‘Ne tave di wadiaivin, dim da e, ne dugup nega nutu uoni nagirewa inamup ma daiton da munan tanewa, e ame ne inanap tayan.’ ");
INSERT INTO dgz_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Amba ne waenapan nanina senip gapan wanumopi nagirewa anega wadiamoin, ‘Ae venek aisen, e da God inayap ugu gangan ta yaibobot meravewa Seitan amba anea mega den tata kakayat tane gapan wanien. ");
INSERT INTO dgz_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Wataget ne enup aranegen go e taba ya nenayan, ne megana pakaraen go e kaum ya nenayan, ne at ugupewa apane da tauan go e ya warupanege pa ega gwanap bat nimanegean. ");
INSERT INTO dgz_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ne nin aroga waingena go e gan gorogot ya pan nenayan, ne vek tan go e amatana ya tayan. Amba ne gwat nokap wanigena go e nenan daio ya tauayan.’ ");
INSERT INTO dgz_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ap anega wapena mu gare wayawanegain, ‘Ayop nugawa, wam ansena enup arageni o megaga pakaraeni o ge oarewa o gan gorogot yoa taingian o vek waraan o gwat noke waingean go nu ago ya genaton?’ ");
INSERT INTO dgz_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ap anega wapi ne gare anega wadiamoin, ‘A, wapena anun. Dugup nega nutu uoni apane da ap inap ya tayana, e ne inanap den ya tayan.’” ");
INSERT INTO dgz_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Iesu sia anega wadiamon, “Menan koewa taine nagirewa itan yaibobot yaviwanumain go God menan kakaewa taine nagirewa inak yaibobot wanum amuiwanumain.” ");
INSERT INTO dgz_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Iesu nop mega ame wadidiamon uon tani, me wa ewamot mega anega wadiamoni, ");
INSERT INTO dgz_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“E asigiap di, wam dere ewap Paina Yamaseni Baripewa taueta. Ame gapan waenapan Kimani Vitana Apanewa oma korosi gapan toguranegepen menan waranegain.” ");
INSERT INTO dgz_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Wam ame gapan pirisi bawarewa ge Diu namu yoyo nagirewa den, pirisi bawarewa ayop muga, apan Kayapas, pa mega gapan iamene. ");
INSERT INTO dgz_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Amba mu anenen ta amba Iesu karaua ware togurapen neginewa noa panan waiwanumun go waenapan tamu den anuiwanumun. ");
INSERT INTO dgz_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Menan anega wan, “Barip wamewa gapan Iesu ya warait iwa waenapan ita anan tapi tawa.” ");
INSERT INTO dgz_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Amba Iesu pa sewa Betani gapan, apan Saimon vek bo’o namu ware kakae tani apanewa pa mega gwanap wanden. ");
INSERT INTO dgz_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Wam ame waen da oma osewa kaum pokarik gwat pomponu gapan ta eneni, ame ware tauen. Ame tutua aigap iragen amba garewa mega baita da uon. Amba Iesu taba naiwandini gapan taue iap damagen. ");
INSERT INTO dgz_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Iap wa damageni gapan Iesu wa ewamot mega ugu gangan tane menan noyam anega wane, “Iwa dimen kaum ame uniunion danamiwan? ");
INSERT INTO dgz_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Oma ose tutu den mame une ta moni baware wara waenapan purapuse uoni kayakayawan taine nagirewa munapen.” ");
INSERT INTO dgz_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Mu anen wane Iesu imua gapan anuni menan gare anega wadiamon, “Waen ma ae veane anut mega gapan di taiwandan. Waen mame dim da inanap tani iwa den gapan di taiwan amba yaunewa mega kakae iragen. ");
INSERT INTO dgz_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","E iman kayakayawan taine nagire den nimakamup tanam waniai, go pot pot ne ya waranegiwaniai. ");
INSERT INTO dgz_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Me oma ose tutu dena mame tasi di seneniwan, ame gapan ne iman bonigasepen tu negepi wamewa menan. ");
INSERT INTO dgz_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ne tave di wadiaivin, ambagan da God No Oise Kakaewa ma piup iragi gapan wadidiamopi, waen mame dim da tani oisewa anupen menan wadidiam wanumain.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Amba wadiamot mega aonagaet pusinawan dere da yaua Diudes Iskeriot. Me pirisi bawarewa inamup Iesu omine wapen menan aen. ");
INSERT INTO dgz_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Me anega wadiamon, “Ne Iesu naniap baraepenawa e garewa animpo nenai?” Ap anega wani menan agim make muga apane daiton apan da aonagaet (30) wanane. ");
INSERT INTO dgz_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ap mepe boge use aeni, Diudes wam arok da ware Iesu nanimup baraepen menan yowa taiwandin. ");
INSERT INTO dgz_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Barip yaua Taba Buredi Ya Tutut Waine Baripewa tugupen wamewa taueni menan Iesu wadiamot megawa ine tauan anega wayawan, “At ansena gapan nu ane tata kakayat tat barip nugawa mame nat anuingi?” ");
INSERT INTO dgz_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Me gare wadiamon, “Pa sewa bawarewa, Ierusalem, aisenewa apan da yawane amba me anega dian, Wadianet apanewa anega wan, ‘Ne om enu nenane wamewa konintu taiwan. Menan ne wa ewamot nega den Paina Yamaseni Baripewa pa gega gapan tugut anuivin.’” ");
INSERT INTO dgz_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Iesu wadiamoni gapan mu barip ame napen menan tata kakayat tane. ");
INSERT INTO dgz_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Wam ame mum gine taueni, Iesu wa ewamot mega aonagaet pusinawan dere tanamo taba napen menan ae wanumon. ");
INSERT INTO dgz_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Naiwanumune me anega wan, “Ne tavewa di wadiaivin, e daiton da ominana wapen taiwanin.” ");
INSERT INTO dgz_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ap anune gapan mu bagu sisi baware di anun amba nop me inap daiton daiton singui wan, “Ayop, nenan waingi go?” ");
INSERT INTO dgz_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Wane Iesu gare wadiamon, “Apan daiton da ameme wam mame ne den buredi ware sip kundaun gapan kaum pisit gwanap antap enepiwa ameme di. ");
INSERT INTO dgz_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","God negin mega, ame ok gapan seane, Kimani Vitana Apanewa gase wat neneni ap omewa gapan bonigatain, go kaiwan, ominana wani apanewa itan baware yaveta. Apan ame ya yanapo ame kakae iwa ominana ya wapo.” ");
INSERT INTO dgz_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Iesu ap anega wadiamoni gapan, omine wani apane Diudes Iesu wayaven, “Ayop negawa, nenan waingi go?” Iesu gare wan, “E, ge me di.” ");
INSERT INTO dgz_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Taba naiwanumune gapan, Iesu taba buredi semua ware God inap gaun wa, wa paise wa ewamot mega mune, amba anega wan, “Tambun nan. Mame etunawa.” ");
INSERT INTO dgz_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Sip ware, God inap gaun wani mune anega wan, “E iragi mame gapan at nugut tan. ");
INSERT INTO dgz_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kaum wain mame deninawa. God e waenapan mega, ne denina gapan agi ewakewa wa agiat imaeta. Bonigasepena denip mame tau visepi gapan waenapan aruga koewa muga wat museta. ");
INSERT INTO dgz_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Wapena anun. Kaum wain mame ne sia ya nain go Mamana God toemu mega tauepi e den tanae sia nain.” ");
INSERT INTO dgz_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Wam ame God inap mu wak da wane amba mu tunup Olip dot amon. ");
INSERT INTO dgz_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Boge Iesu anega wadiamon, “Endi mum mame gapan e iragi tap ae venek aitai, iwa watageta apanewa da God nop mega ok anega sen, God anega wan, Ne man sip kwayup taini apanewa topena, man mega punanan wat amoin, ok ap anega sen. ");
INSERT INTO dgz_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Go ne bonigasep amba inak nigat yon waingepena ne at Galili gapan namu tauain e evi amba tauai.” ");
INSERT INTO dgz_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Wani Pita Iesu wadien, “Mu iragi tap ae vege amoin, go genan ne tap ya angain.” ");
INSERT INTO dgz_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Pita wani go Iesu gare wadien, “Pita, ne wapena anu. Endi wam koni yampoa gapan ge waboboranegai amba kumkum nop wata.” ");
INSERT INTO dgz_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pita anega wan, “Ae, ge bop tawa ne den bop di tain, ne ya waboboragain.” Amba wa ewamot upinewa ap anega nomanagaet wane. ");
INSERT INTO dgz_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Amba Iesu wa ewamot mega den at yaua at Getsemani amon, amba me anega diamon, “Ne asirantu angep God inap mup wapena e mapa ae wanien.” ");
INSERT INTO dgz_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Me Pita ge apan Sebedi otu wai dere tanam asirantu amon, amba me bagu sisi anu tanen amba bumage tuk wan. ");
INSERT INTO dgz_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Boge Pita evene dere den inamup anega wadiamon, “Ne bagu sisi aritavet anu tanan ap gapan bumagana tuk wan, nene yangwan doranek wan. Mapa waniene ne den tananegen amba nene yamam taiwanian.” ");
INSERT INTO dgz_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ap anega wani amba asirantu aen, amba me gine namu pia ae to kutnage mup anega wan, “Maman, ge men anu gurawa, ugu vegaek anupena ao waseanek, go mame ne anut negawa uon go gek anuiana gapan di ta.” ");
INSERT INTO dgz_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Boge me entane ae wa ewamot mega ine taue aup iniwanumune yawamon. Menan Pita inap anega wan, “E da wam airase daiton ne den tananege nene yamam ya tayan. ");
INSERT INTO dgz_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Nene yamam tan, God inap mup wan, iwa pusi warup da inayap tauepi tawa. Iwa guanu epara tat anuiwan go etunu itani waiwan.” ");
INSERT INTO dgz_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Evi sia aeni God inap mup anega wan, “Maman, itan bagu sisi sipewa ma ne nat wa nenaana ya wat age ae vea ne nap, ap gapan gek anuiana ame venaseta.” ");
INSERT INTO dgz_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Wam ame, me sia entan taueni, mu aup iniwanumune yawamoni mu yamamu itani wan. ");
INSERT INTO dgz_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Menan ae vemo ae mup koni yampoa uap sia tan. ");
INSERT INTO dgz_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Boge entane wa ewamot mega inamup taue anega wadiamon, “E aup inin kakayat taiwanin go? Yawan, wam nega onen di mananiwan, amba Kimani Vitana Apanewa waranege koewa taine nagirewa nanimup bat nimanegain. ");
INSERT INTO dgz_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ao yonane anepen! Yawan, ominana wani apane mame tauen!” ");
INSERT INTO dgz_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Iesu nop ame waiwandini gapan, apan Diudes wa ewamot mega aonagaet pusinawan dere apane da tauen. Pirisi bawarewa ge waenapan dimae waine nagirewa den, waenapan aruga watu enamone kereba kepata tambun tauane. ");
INSERT INTO dgz_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Diudes, omin wani apanewa paua ta ewamopen menan namu waenapan anega wadiamon, “Apan ame gaune tap ua topenawa, ap me di.” ");
INSERT INTO dgz_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Tauane boge Diudes Iesu ine taue anega wan, “Wadidianet nugawa, baigan ge inagap wandep.” Anega wani boge ua ton. ");
INSERT INTO dgz_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Iesu Diudes anega dien, “Enda, ge dim da menan anu tauana menaevet di ta.” Boge mu Iesu ambot warane. ");
INSERT INTO dgz_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ame gapan, Iesu evenewa daiton da kereba mega ware, amba pirisi bawarewa ayop mugawa nao mega apanewa da darinewa to kuasen. ");
INSERT INTO dgz_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Go Iesu anega dien, “Kereba gega arewa gapan sia barao! Iwa waenapan da da kereba tambuinewa, mu kereba waniwa gapan borit wainewa. ");
INSERT INTO dgz_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","E oare go ne Mamana vene wapena, me menawaet anea arugataet watu enamota, amba nenan anan tain. ");
INSERT INTO dgz_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Go ap tapo God nop mega oitana wataget seane tavewa ya tauapo. Go mu waranegene gapan nop ame tavewa mame venasen.” ");
INSERT INTO dgz_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Iesu apan aruga tauane singui wayawamon, “Endi, ne up apanewa mini waranegepen menan kereba ge kepata tam tauayan? Ne wam, wam God Paewa gapan wanigingina ya waranegean go endi waranegepen menan tauayan. ");
INSERT INTO dgz_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Go ma iragi taiwaniana iwa wataget God no oise waiwanumune nagirewa ne oitana ok seane tavewa tauapen men taiwanin.” Boge wa ewamot mega iragi ae vean tap amon. ");
INSERT INTO dgz_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Amba Iesu kaimakaet waran nau amon pirisi ayop mugawa apan Kayapas pa mega amon. Pa mega gapan waenapan iup wadidiamuine ge dimae waine nagirewa den iam iam tan wanumon. ");
INSERT INTO dgz_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Go Pita wandap isipa evi oniwandin amba Pirisi ayop mugawa pa mega nimakap arok da gapan tauen. Gwanap unuk aeni, mu Iesu inap anenen tapi yao anupen menan, ita gopare taine nagire tanamo ae wanden. ");
INSERT INTO dgz_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Pa gwanap, pirisi bawarewa ge kansoro nagirewa uruga Iesu inap nop eboewa yoa tan nau amo togurep boepen menan taiwanumun. ");
INSERT INTO dgz_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Waenapan aruga tauane amba ebo aopan gapan Iesu koewa mega yop tane, go mu me koewa mega da ya tanane. Uiwa gapan apan dere tauan anega wan, ");
INSERT INTO dgz_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Apan ma namu da anega wani, ‘Ne God Paewa wabenagep amba wam yampo gwanap sia tu waborain.’” ");
INSERT INTO dgz_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Boge pirisi bawarewa da ao yone amba Iesu anega wayaven, “Ge nop muga waine garewa wai go uon? Mu oitaga waine ge anenen anuingi?” ");
INSERT INTO dgz_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Go Iesu no uon wanden. Pirisi bawarewa mugawa me inap anega wan, “God yaibobot wandini apanewa amun mega gapan diagivin. Wadian, ge God mega wa watu enageni Mesaya go uon? Ge God Otua go uon?” ");
INSERT INTO dgz_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Wani Iesu gare wan, “E, ge ap me di waiagi! Go ne wapena anun. Wam evi amba da, Kimani Vitana Apanewa God Aro Iragenawa mainewa nutup gapan ae waingepena amba irikup gagap sia tauapena yawanegai.” ");
INSERT INTO dgz_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Boge pirisi bawarewa wanup mega wabebenage anega wan, “Me God inap wawa koko taiwan! Iwa dim men koewa mega upine yoa tait? Me God inap wawa koko taini e gase anuyan. ");
INSERT INTO dgz_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Menan e dim da anuiwanin?” Mu gare anega wan, “Me koewa mega garewa menan di boep.” ");
INSERT INTO dgz_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Boge mu gine namu gitona en anan toiwanumun. Upi gine namu pan boran tuiwanumune nipep anega wan, ");
INSERT INTO dgz_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Ge God Keriso mega waingewa iagap wa anut da togen.” ");
INSERT INTO dgz_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ap mepe, Pita pa nimankewa arok da gapan ae wandeni amba nao taine waenewa da taue anega dien, “Ge Iesu at Galili apanewa den tautana ingiana apanewa da.” ");
INSERT INTO dgz_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Go me iragi namumup wabobore anega wan, “Ge dim da waingiana ne oare.” ");
INSERT INTO dgz_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Boge me tonan noa tau aiwandiniwa, ap mepe waen da sia yave waenapan anega diamon, “Apan ma Iesu at Nasaret apane den iwandiniwa.” ");
INSERT INTO dgz_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pita sia wabobore anega wan, “God yawanegiwan, apan ame waiana ne oare!” ");
INSERT INTO dgz_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Wam koni otu da ewap, waenapan upi amena yaoyao yoniwanumunewa, Pita ine use amon amba anega wan, “Tave di, ge apan ame da iwa e nop waiana megaya daiton di!” ");
INSERT INTO dgz_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Boge Pita kaimakaet anega wan, “Ne ebo wapena God ugu gangan mega yawain. Apan ame men waiana ne oare!” Boge gine tutup kumkum nop wan. ");
INSERT INTO dgz_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Iesu Pita nop namu anenen Iesu dieni boge anu aven, ame, “Wam yampo waboboranegai amba kumkum nop wata.” Ame gapan Pita tau pa garip ae irip koevet wan. ");
INSERT INTO dgz_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Mumaget ese goe den, pirisi bawarewa amba waenapan dimae waine nagire den Iesu anen ta amba togurep boepen menan nopewa panan wawa mutan. ");
INSERT INTO dgz_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Mu waran pan nao amon, Rom nagirewa ayop muga om enuni apanewa Pailat wanan. Pailat ame at Diudia kwayup taini apanewa. ");
INSERT INTO dgz_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Wam ame Diudes, Iesu omine wani apanewa, Iesu togurapen oisewa anuni menan bagu sisi anun imua entanen amba moni gwat make apane daiton apan da aonagaet (30) pirisi bawarewa amba dima waine nagirewa ewagai munat anu aen. ");
INSERT INTO dgz_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Taueni anega wadiamon, “Ne koerage tan iwa ne denip kakaewa omine wan.” Mu gare anega wane, “Ame anenen, ame gegawa di.” ");
INSERT INTO dgz_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Menan Diudes gwat make God Paewa gwanap aipa uatame tau aen. Boge me tau ae mek ingane kwip enen. ");
INSERT INTO dgz_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Pirisi bawarewa gwat make ame bongamene amba anega wan, “Ma God Paewa menan yan ya tait, iwa apan boeni moniewa menan iup nuga watananiwan.” ");
INSERT INTO dgz_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Gwat make ame nopewa panan wane ewap mu ian ugupe nagirewa ap mepe borit wapi kaima muga tumopen arewa une tapen menan seane. At ame yaua Unup Taine arewa une tan. ");
INSERT INTO dgz_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ap menan at ame yaua ‘Apan Deniwa Piupewa’ diane, onin eni endi mame tauen. ");
INSERT INTO dgz_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ap gapan watageta apane Dierimaya God no oise ok se wani tavewa tauen. Ok anega sen, Mu moni gwat make apane daiton apan da aonagaet, at Isurero gapan, apan daiton garewa mega seane. ");
INSERT INTO dgz_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Moni ame gapan unup warini apanewa piup mega une tan. God dianegeni at umap di tan. Apan Dierimaya ok ap anega sen. ");
INSERT INTO dgz_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Iesu piup ayopewa Pailat namup yoneni ayop singui anega wayaven, “Ge Diu nagirewa Ayop mugawa go?” Iesu gare wan, “E, ge ap me di waiagi.” ");
INSERT INTO dgz_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Amba pirisi bawarewa amba waenapan dimae waine nagire den enu yawan wane go no uon wanden. ");
INSERT INTO dgz_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Menan Pailat sia singui wayaven, “Mu nop aruga gapan enu yawagene waine anuingi go uon?” ");
INSERT INTO dgz_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Go Iesu sia no uon wanden, nop muga kaimakaet wane go garewa da ya wan. Ap menan piup ayopewa imua upese anun. ");
INSERT INTO dgz_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Piup ayopewa gutut muga en en taine ame Paina Yamaseni Baripewa gagap, gwat noke apane waenapan om enu wapi gapan wat vesine tauen ainiwa. ");
INSERT INTO dgz_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Wam ame gapan, dayakam taini apane da, yaua Barabas, gwat nokap baraene wande en. ");
INSERT INTO dgz_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ap menan wam ame waenapan to iamene gapan, Pailat singui wayawamon, “Apan ansena da ne enan wat vetat anuiwanin? Apan Barabas wat vetat anuiwanin o Iesu, yaua da Keriso, wat vetat anuiwanin?” ");
INSERT INTO dgz_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailat singui ame wayawamoni iwa imup anuni Diu nagire ayop mugawa Iesu anu koeamene menan wat onamon wanane. ");
INSERT INTO dgz_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Wam ame Pailat wanene watarewa gapan wande nau taiwandini me waenewa nop da menan watu ene anega wan, “Ge apan kakaewa ame inap dim da da ya ta, iwa me menan ne muma enok gapan aritavet wat yapan.” ");
INSERT INTO dgz_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Go pirisi bawarewa amba dima waine nagire waenapan datnak mumane Barabas wat vesep tau aep amba Iesu togurep boepen menan wane. ");
INSERT INTO dgz_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Piup ayopewa Pailat singui sia wayawamon, “Apan dere ma ansena da ne enan wat vetapen tau oneta?” Waenapan gare wan, “Barabas tau onep.” ");
INSERT INTO dgz_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pailat sia anega wan, “Iesu, yaua da Keriso, inap dim da tain?” Mu iragi anega wan, “Oma korosi gapan to endawane boep.” ");
INSERT INTO dgz_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pailat gare wan, “Iwa dimen boeta? Me koewa dim da tan?” Go waenapan nop kaimakaet aigap sia waiwanumun, “Korosi gapan boep!” ");
INSERT INTO dgz_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pailat imua anun, ‘Mu nop nega ya anuiwanum ita anan tapen taiwanum.’ Menan yamamup paua kaum gapan nani bigi ware anega wadiamon, “Apan ame boepi koewa da inanap ya taueta ek di.” ");
INSERT INTO dgz_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Diu nagirewa iravi gare wan, “Me boepi intanewa nu iravi aiganup amba otun wainu aigamup tau ge tau aiwandata.” ");
INSERT INTO dgz_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Boge Barabas wat vesen tau aen. Amba ita nagirewa diamone mu Iesu waran gaut gapan tone amba oma korosi gapan togurapen men wat amon. ");
INSERT INTO dgz_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Amba piup ayopewa ita mega nagirewa Iesu waran apan bawarewa pa mega gwanap amon. Ita nagirewa iravi ap mepe wanumone munan wan Iesu namup tauan. ");
INSERT INTO dgz_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Wanup mega waseasen ayop wanupe buinip pan wanan. ");
INSERT INTO dgz_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Amba wanup dendeniwa pan wanane amba ipuni wagam waran Iesu iap tonat wanane amba gerok da wanane naniwa nutup gapan waren. Ayop paua ame inap tane namup omanimup enun nipep anega wan, “Kaewa kaewa, Diu nagire ayop mugawa!” ");
INSERT INTO dgz_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Mu gitona en anan amba gerok waran iap toiwanumune. ");
INSERT INTO dgz_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Mu nipep diane ewap, wanup dendeniwa pan wanane, ame wabutunagen amba wanup mega sia pan wanan. Boge mu oma korosi gapan togurapen menan wat nau amon. ");
INSERT INTO dgz_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Mu tau amuiwanumune at Sairini apane da yaua Saimon mu nanamasen wane gapan Iesu korosi mega waren. ");
INSERT INTO dgz_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Amone at yaua Apan I Kaime Arewa (Iburu nop muga gapan Golugata diane) tauan. ");
INSERT INTO dgz_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ap mepe mu Iesu wapiwa vege ya anupen menan kaum wain oma baewa sisi dena gotonak en wanane yamot anu ae ven. ");
INSERT INTO dgz_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ita nagirewa Iesu oma korosi gapan to endawanewa amba mu wanup mega yan seapen menan kae otu da tane. ");
INSERT INTO dgz_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ap ewap mu ae wanumon amba Iesu kem kem yaviwanumune. ");
INSERT INTO dgz_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Mu enu yawan wane ogewa me iap paina oma ginap tobatam endawan anega seane, ‘Ma Iesu Diu nagirewa Ayop mugawa.’ ");
INSERT INTO dgz_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Wam ame gapan up apane dere den oma korosi gapan gut batamene, da Iesu mainewa nutup gapan, amba da senip gapan gut dawamon. ");
INSERT INTO dgz_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Waenapan tau ise amo tau use amo taiwanumune nagirewa no peromen Iesu inap nipep anega waiwanumune, ");
INSERT INTO dgz_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Ge God Paewa tobenage amba wam yampo gwanap sia tut waana apanewa, gek ingane inagit. Ge God Otua waingewa, oma ae ve vit onak.” ");
INSERT INTO dgz_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ame umap sia pirisi bawarewa amba waenapan iup wadidiamuine ge dimae waine nagirewa den nipep anega wane, ");
INSERT INTO dgz_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Me upi inak munen, go mek ingane inak ya wareta! Me Isurero Ayop nugawa go? Oma ae ve visepi gapan nu me inap anu tumatait. ");
INSERT INTO dgz_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Me God tumap wandiwan menan God anupi endi mame di wat inakamep. Iwa me anega wani, ‘Ne God Otua.’” ");
INSERT INTO dgz_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ap uap sia, up apane den gut batam mumane ap anega nipep den me inap wane. ");
INSERT INTO dgz_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Wam ianupe wariwandini gapan, piup ame iravi mum tatarin tunu taue aeni amba wam airase yampoa waren. ");
INSERT INTO dgz_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Wam airase yampoa wareni gapan Iesu nop uma ve anega wan, “Eli, eli, lama sabak tani.” Ap anega wani guegue, “God negawa, God negawa, ge dimen ae venek agi?” ");
INSERT INTO dgz_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Wam ame gapan, waenapan upi ap mepe yoniwanumune nagirewa nop ame ‘Eli, eli’ wan anune menan mu anega wan, “Me apan Elaidia vene waiwan.” ");
INSERT INTO dgz_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Amba apan muga da serarat ae kaum warupini wanupewa waren. Kaum sisi dena yaua viniga gapan ae antapene gerok ginap enu, Iesu megewa pakaraeni men napen wanen. ");
INSERT INTO dgz_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Go evene wai anega wan, “Ae ve ya wana. Watageta apane Elaidia taue wat inakameta go uon amase tait.” ");
INSERT INTO dgz_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Iesu ve baware sia wani boge guewa puk wa tau aen. ");
INSERT INTO dgz_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ap wamewa gapan God Paewa gwanap wanup God wandini arewa tonan pan boriniwa aoma bebep wa vise ase ma wanden dere entanen. Piup menao manao tan amba gwat bonawan tuk tak wan. ");
INSERT INTO dgz_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ame gapan den, kaima arewa urat no ikap wan amba waenapan etumu gapan wataget potamu woup seni borit wane nagirewa inak mutan sia yon wanumon. ");
INSERT INTO dgz_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Mu urata tau onamon, amba Iesu boe inakae yon wandeni ewap mu Ierusalem unumon amba pa nagirewa aruga yawamon. ");
INSERT INTO dgz_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Wam ame ita yamewa apane gauarape mega den Iesu kwayupe taiwanumune yamamup yawane, piup menao manao tan amba ame ugup ugup ta tau aen. Mu tap baware anun amba anega wane, “Tavewa di, me God Otua.” ");
INSERT INTO dgz_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Wam ame gapan waen aruga painantuk yonan yaviwanumun. Mu Iesu at Galili gapan oneni kwayupe tapen menan ewap onamon. ");
INSERT INTO dgz_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mu yaumakamup waen Meri Makdalin amba apan Diemis ge Diosep inamua, Meri, amba apan Sebedi otu wai Diemis ge Dion inamua den. ");
INSERT INTO dgz_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Mum gine, Iesu wadiamot mega, puraput apane da yaua Diosep pa sewa Arimatia apanewa tauen. ");
INSERT INTO dgz_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ae, Ayop Pailat ine taue me Iesu etua menan singui wayaven amba Pailat wanapen menan umap wan. ");
INSERT INTO dgz_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Diosep Iesu etua ware wanup kakaewa nononga da gapan viri viri ware panen. ");
INSERT INTO dgz_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Paneni uon tani amba wat amon dagup ewakewa, mek megawa, gwat bonawan gapan kaiseniwa, ame gapan baraen. Gwat pepeta baware da wabaiman onamon tonan toboran amon. ");
INSERT INTO dgz_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Waen Meri Makdalin amba Meri dawa dagup yamunewa gapan amena wanumon yaviwanumun. ");
INSERT INTO dgz_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Inane woup sen, ame Diu wagat wamewa gapan, pirisi bawarewa amba Parisi nagire den, ayop Pailat ine tauan anega wan, ");
INSERT INTO dgz_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“Ayop nugawa, wataget nop tave uoni waiwandini apanewa kabani wandeni me anega wan, ‘Bonigasepena wam yampo ewap inak nigat sia yon waingain.’ ");
INSERT INTO dgz_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Me ap wani menan, ita nagirewa watu enamo wan amo dagup tonane kwayupe tap aepi wam yampo uon tapi amba onamot diamon. Ap ya tawa, Iesu wa ewamot mega taue etua up ta amoin. Ame gapan waenapan aopan anega wadiamoin, ‘Iesu boen go inakae sia yon wanden.’ Ap gapan Iesu ebo aopan namu ta waiwandini ame otu kamontu go eviwa ebo aopan ame kai ware baware tata.” ");
INSERT INTO dgz_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Boge Pailat gare anega wadiamon, “Umap ita nagirewa upi tam aisen, ek asik ega gapan dagup kwayup tan.” ");
INSERT INTO dgz_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Anega diamon amon, dagup tonanewa agim tainamua inamat batamen iwa Iesu etua up tapi ame inamat tak wapi irewa gapan yawapen menan tane. Amba ita nagirewa tonan kwayupewa ap mepe semone. ");
INSERT INTO dgz_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Diu pura muga bawarewa wamewa uon tani ewap, woup seni mumaget iragen Meri Makdalin ge Meri dawa den dagup yawapen amon. ");
INSERT INTO dgz_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ap mepe piup menao manao baware tan iwa Ayop anea mega kimani vise taue amba dagup unum amuine tonanewa gwat wabaim ae barae amba gagap ae wande en. ");
INSERT INTO dgz_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Yawat mega yangwan mini amba wanup mega pomponugaet. ");
INSERT INTO dgz_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ita nagirewa tonan kwayup taiwanumune yawane tawa tan bop umap geamone. ");
INSERT INTO dgz_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Anea waen anega wadiamon, “Tap ya tane. Ne asik tan e Iesu yawapen tauayan, me oma korosi gapan to endawanewa. ");
INSERT INTO dgz_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Me mapa ya wandia. Me wani omewa tauen menan me gaset inakae yon wanden. Onaen me baraene arewa yawan. ");
INSERT INTO dgz_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Menan menawaet di aisen amba wa ewamot mega wadiamon. Iesu bop gapan sia yon wandeni at Galili gapan namu taueta e evi amba tauan ap mepe yawai. Anun, ne di wadiaivin.” ");
INSERT INTO dgz_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ap menan waen ikananam tan dagupa tauan tanini den go potamu aton bararaen, amba serarat wa ewamot mega wadiamopen amon. ");
INSERT INTO dgz_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ap amone gapan mu Iesu tautanane amba me anega wan, “Baigan inayap wandep.” Waen ine tauan me airanip warane amba wa taragasene. ");
INSERT INTO dgz_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Boge Iesu anega wadiamon, “Tap ya tane. Aisen dugup nega nagirewa wadiamone, mu at Galili amop, ap mepe yawanegain.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Waen negin amuiwanumune gapan, ita nagire tonan kwayup taiwanumune, upi pa Ierusalem amon amba pirisi bawarewa anenen venaseni oisewa wadidiamon. ");
INSERT INTO dgz_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Wam ame pirisi bawarewa ge dimae waine nagirewa iam iam tan amba wawa mutan amba mu ita nagire ame ebo wapen menan gwat make aritavet munan. ");
INSERT INTO dgz_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Amba ita nagirewa anega diamon, “E nop manega wan, ‘Mum oap, nu aup inintoni gapan, Iesu wa ewamot mega tauan etua up ta amon.’ Ap anega wadiamon. ");
INSERT INTO dgz_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Go nop oit mame ae piup ayopewa ine tauepi gapan e dim da tayana me anu ae veta amba itan ya enapen menan nu watanait.” ");
INSERT INTO dgz_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ap menan ita nagirewa moni muga tambun amba amon, nop anenen diamone di tan. Amba gutut eboewa ameme Diu nagirewa iragi anun wa sesenamene onin eni, endi mame di tauen. ");
INSERT INTO dgz_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Amba Iesu wa ewamot megawa aonagaet pusinawan daiton at Galili amon tunup da ame Iesu amot diamoni tauan. ");
INSERT INTO dgz_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ap mepe yawane gapan mu wa taragasen, go upi gego anun. ");
INSERT INTO dgz_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Boge Iesu inamup taue anega wan, “Maman piup kiman amunewa iravi nenen. ");
INSERT INTO dgz_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ap menan piup at at iragi tau aisen, ne wadidiaingina ap umap wa aisen amba waenapan ne wadiamot nega entan muman. Maman amba ne Otua ge Guewa Woup Seniwa den amun nuga gapan dup iamuiwanian. ");
INSERT INTO dgz_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ne wadiaena mini e wadiamone amba nop nega iravi ayamase tap. Tave di ne pot poraet e den wanigepen aiwandan, evi wam verisiwa taueta.” ");
INSERT INTO dgz_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","God Otua Iesu Keriso No Oise Kakaewa erewa mame. ");
INSERT INTO dgz_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Watageta God no oise waiwandini apanewa Aisaya oit mega ok manega sen, God anega wan, Wapena anun, ne oit nega wapi apanewa, namu watu enapen negin genan wareta. ");
INSERT INTO dgz_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Apan da pua, at kaimewa gapan, opata ve anega waiwandin, ‘Ayop nuga negin mega wa tarasen, wat tamanamene amba tauep.’ ");
INSERT INTO dgz_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Aisaya anenen wani tavewa venasen, ame apan Dion waenapan dup iamopen menan pua taue opata anega waiwandin, “E inak koewa taiana ae vean, imuya entanen ne dup iaepena amba God koewa ega anu ae veta.” ");
INSERT INTO dgz_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Waenapan aruga, at Diudia gapan amba pa Ierusalem nagire den Dion yao anupen men tauiwanumun. Koewa muga vetaet taiwanumun amba Dion kaum Diodan gapan dup iamuiwandin. ");
INSERT INTO dgz_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Dion wanup mega man kameru etua gume den eniwandin, amba berip mega, man etua paniwandin. Me taba mega naiwandini ame paki ge onaro. ");
INSERT INTO dgz_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Me opata gapan anega waiwandin, “Apan da evinap oniwandini me aiganap aroe amunu den taueta, amba ago otua ayop mega pusi okomewa vesini mini, ne ap wat agoaset anun, go ne kakae uon. ");
INSERT INTO dgz_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ne kaum iragen gapan dup iaivin go me God Guewa Woup Seniwa gapan dup iaiwandata.” ");
INSERT INTO dgz_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Wam ame, Dion opata waiwandini ewap, Iesu at Galili pa Nasaret ae ve ae Dion ine tauen boge kaum Diodan gapan Dion yone Iesu dup ien. ");
INSERT INTO dgz_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ame gine tutup, Iesu kaum ae ve kwatata ao dotoueni, amba kiman ase watapen, boge God Guewa Woup Seniwa nenip bairantan mini kimani visiwandin Iesu wapip doren. ");
INSERT INTO dgz_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Doriwandini amba nop da kimani anega tauen, “Ge ne otun iragenawa, imuna genan anu gurivin. Ge gamugap ne imuna ae meare tau aen.” ");
INSERT INTO dgz_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Wani ewap, God Guewa Woup Seni Iesu nau at kaimewa aen. ");
INSERT INTO dgz_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Wam apane dere (40) pua wande eni gapan Seitan Iesu pusiwa warupe yaven. Anea tauan wat agoasene amba ap mepe man puawa den wanumune. ");
INSERT INTO dgz_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","At Galili bawarewa nagirewa Dion waran gwat noke baraene ewap Iesu at Galili taue God Nop Oit Mega Kakaewa opata gapan wadidiam wandin. ");
INSERT INTO dgz_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Me anega wani, “God om enuni wamewa tauen, toemu mega amunewa tauapen taiwan. Koewa ega ae vean imuya entanen God Oit Mega Kakaewa anu tumasen.” ");
INSERT INTO dgz_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Iesu kaum awan Galili etop ap aiwandini, amba me Saimon, gwaniwa Anduru dere yawamon. Mu ia muga kauma antap eniwanumun, mu meo dawane taine nagirewa. ");
INSERT INTO dgz_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Iesu anega wadiamon, “Ewanap onaen, ne ta ewaepen e waenapan dawane tan.” ");
INSERT INTO dgz_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Boge ap gine tutup, mu ia muga ae vean amba me ewap amon. ");
INSERT INTO dgz_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Use sia aeni, apan Sebedi otu wai Diemis gwaniwa Dion dere yawamon. Mu kabum muga gwanap, ia muga nadi waran tata kakayat taiwanunum. ");
INSERT INTO dgz_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Boge Iesu venamu wan. Menan mamewa ago mega den kabum gagap ae vemon dere Iesu ewap amon. ");
INSERT INTO dgz_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Iesu wadiamot mega den pa Kaponiam ame vit amon. Ian Diu pura muga bawarewa wamewa gapan Diu nagire opata waine paewa gwanap wadidiam wandin. ");
INSERT INTO dgz_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Me opata waiwandini gapan waenapan iragi no i kap wan, iwa me nop aroe amunu den waiwandin go iup wadidiamuine nagirewa nop muga amunu uon. ");
INSERT INTO dgz_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Airampu potap wandeni apanewa da taue ap mepe wanden amba Iesu opata waiwandini gapan ");
INSERT INTO dgz_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","airampu senao uma anega wan, “Akae, ge Iesu pa Nasaret apanewa dim da inanup tat wa tauaan? Ge wa koeam nimanepen men tauan go? Ge orup ansena da ne asiginap di, ge God mega potaga Woup Seni apanewa.” ");
INSERT INTO dgz_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Iesu airampu ame anega dien, “Nop ae ve apan ae ve tau ak!” ");
INSERT INTO dgz_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Airampu apan ware enu menawase senao wa tau aen. ");
INSERT INTO dgz_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Waenapan ap yawanewa, iragi seke tan no i kap wan anega wawa mutane, “Ma anenen da taiwan? Nop ewakewa da? Nop mega aroe amunu den airampu up oimuiwandin tau amuiwanum.” ");
INSERT INTO dgz_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Iesu inak ame tani oit mega at Galili iragi senare tau aen. ");
INSERT INTO dgz_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Iup anuine paewa ae veane amba Diemis ge Dion tanam apan Saimon ge Anduru pa muga amon. ");
INSERT INTO dgz_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Pa tauane Saimon tapunewa vek ato itanigaet ta eragi gagap iniwandini ame oisewa Iesu wadiane. ");
INSERT INTO dgz_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Menan Iesu me inap ae nanip ware ao endaveni gapan vek amun ame torot wan. Boge Pita tapunewa ao yone taba munen. ");
INSERT INTO dgz_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Amba mum gine taiwandiniwa, vek nagirewa amba airampu waramoni nagirewa aruga tambumon me inap tauane. ");
INSERT INTO dgz_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ap menan pa nagirewa iragi tauan tonan barat mutan. ");
INSERT INTO dgz_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Vek ugup ugup iravi wat inakam mumen. Upi airampu potamup wanumone up oimon tau amon. Airampu Iesu ire yawan wapen tane go Iesu nop ae veapen menan yam ta yawamo wan. ");
INSERT INTO dgz_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mum igoe den, Iesu pa ae ve, God inap mup wapen menan waenapan uoni arewa aen. Ap mepe mup waiwandin. ");
INSERT INTO dgz_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Go Saimon evene wai den me yoa taiwanumune. ");
INSERT INTO dgz_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Amba Iesu yawane gapan, mu anega wane, “Waenapan iragi yoga taiwanum.” ");
INSERT INTO dgz_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Go Iesu gare wan, “Ne God toemu mega Oise Kakaewa at at iragi opata gapan wadidiamopen menan ongen. Ap tapen menan nu pa sewa da da den anet.” ");
INSERT INTO dgz_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ap menan mu at Galili pa sewa tau ge tau amuiwanumune. Iesu Diu nagirewa iup anuine paewa gwanap opata waiwandin, den airampu upe oimuiwandin. ");
INSERT INTO dgz_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Vek bo’o apanewa da Iesu ine taue namup omanip enu mup anega wan, “Ayop, gek anua gapan, tanege ne kakae tap.” ");
INSERT INTO dgz_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Iesu apan ame inap bagu sisi anuni menan naniwa endimase wapiwa inase anega wan, “Ne men anuivin, kakae ta!” ");
INSERT INTO dgz_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Gine tutup vek bo’o gamupewa siran taran amone me inakaen. ");
INSERT INTO dgz_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Wat inakameni menan nop kaimakaet anega wadien, “Endi inak mame inagap tana oisewa waenapan da ya wadiamo, noga botakamian. Amba tamana age pirisi ine taua vek gega uon tani yavep. Yavepi watageta apane Mosis vek mame inak warine gaunewa garaet God inap wanapen wani ame diagepi, ge di wan. Garaet ame wanawa, ap gapan waenapan yawage anuin, ame vek gega uon tan.” Amba Iesu apan ame wa oisen aen. ");
INSERT INTO dgz_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Go apan ame inak wareni oisewa at at iragi wadidiamon. Nop ame senareni menan Iesu pa sewa baware ame da aroga ase ya tauiwandin go at gine bigareni gapan ap mepe iwandin. Go ap mepe, waenapan at at iravi Iesu inap tauiwanumun. ");
INSERT INTO dgz_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Wam animpo da uon tani ewap, Iesu pa Kaponiam sia entane aen. Amba me pa taueni oisewa waenapan anun. ");
INSERT INTO dgz_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Menan waenapan arugataet tauan to iamene at bararaen arok da ya wanden. Amba me God no oise wadidiam wandin. ");
INSERT INTO dgz_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Apan degede pusi nani itani wani apanewa da eragia baraen waran tauan. ");
INSERT INTO dgz_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Go pa gwanewa waenapan amborane menan mu gwanap amo amo umap uon, menan apan waran pa aigarip dot amon, unenek napewa gapan to awan eragi mega gagap antapenane visen. Waenapan aru ame iam wanumone nimakamup vise, Iesu namup tamana ae wanden. ");
INSERT INTO dgz_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Amba Iesu mu anu tumat baware tane yawamo anuni menan Iesu vek apanewa inap anega wan, “Otunawa, ne koewa gega anun ae viangin.” ");
INSERT INTO dgz_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Iesu ap wani gapan, iup wadidiamuine nagire ap mepe den wanumone. Mu Iesu koewa anu ae veni noa anune menan muk imumup singui anega anun, ");
INSERT INTO dgz_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","‘Apan ma ambe da tauen, nop God mini wat wan taiwan? Me God inap wawa koko taiwan! God megenat waenapan koewa muga anun ae viniwa, apan iragen da koewa anu ae ya veta.’ ");
INSERT INTO dgz_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Singui muga, Iesu imua gapan anuni menan gare wayawamon, “Iwa dimen imuya potaya gapan ap anega anuiwanin? ");
INSERT INTO dgz_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ne nop daitonawa wana ame vek apanewa koewa mega anun ae viangin, o nop derewa ame manega wapena, ‘Ao yone, eragi mega ware aep,’ nop kaimake dena ansenawa? ");
INSERT INTO dgz_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Go e asigip taepen menan, Kimani Vitana Apanewa piupa waenapan koewa muga anu ae vepen menan aro amun warana ame endi to ewayain.” Menan Iesu vek apanewa sia anega dien, ");
INSERT INTO dgz_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ne endi diagiangin, ao yon eragi gega wat, pa ak!” ");
INSERT INTO dgz_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ap wani boge no utap, waenapan namumup, ao yon wande eragi mega ware, pa mega aen. Menan mu nomu i kap wan God yaua ao waran anega wane, “Nu wataget inak map anega da ya yawaton.” ");
INSERT INTO dgz_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Wam da, Iesu entane kaum awan Galili etoa sia aen. Ap mepe waenapan arugataet ine tauane menan me wadidiam wandin. ");
INSERT INTO dgz_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Amba use sia aiwandini gapan apan Livai (yaua dawa Matiu), apan Alopias otua yaven. Me moni bongamini apane da menan moni bongamine paewa gapan wanden. Iesu me inap anega dien, “Evinap onak.” ");
INSERT INTO dgz_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Wam ame, Iesu me wadiamot megawa den apan Livai pa mega gapan taba naiwanumun. Ap mepe moni bongamine amba God iup mega ya anuine nagirewa aruga den taba naiwanumun, iwa waenapan ame Iesu ewap onam wanumun. ");
INSERT INTO dgz_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Parisi nagire ge iup wadidiamuine nagire Iesu yawan amba wadiamot megawa inamup noyam anega wane, “Iwa dimen moni bongamine amba koewa nagirewa den tanamon taba naiwan?” ");
INSERT INTO dgz_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Iesu nop muga waiwanumune ame anuni menan gare anega wan, “Vek nagirewa nuat apanewa menan anu guriwanum go kakaewa nagirewa nuat apanewa menan ya anuiwanum. Menan ne muk ingane kakaewa anune nagirewa munan ya tauan, go koewa taine nagirewa imu posewa ge inak muga entan tapen menan tauan.” ");
INSERT INTO dgz_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Dion, waenapan dup iamuini apanewa, wadiamot megawa ge Parisi wadiamuine nagire den God menan wam da da taba sinunu iniwanumun. Waenapan upi Iesu inap anega wayawan, “Apan Dion, waenapan dup iamuini apanewa, wadiamot megawa amba Parisi nagire wadiamot muga den God menan pot pot taba sinunu iniwanum amba den God inap mup waiwanum. Go iwa dimen wadiamot gegawa God menan taba sinunu ya iniwanum?” ");
INSERT INTO dgz_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Iesu gare anega wadiamon, “Naine mutat i apanewa barip mega gapan wandepiwa, me evene waiwa taba virip ya veain, iwa aton anuiwanum. ");
INSERT INTO dgz_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Go wam evi da, naine mutat i apanewa waseam wat nau aepiwa, wam ame gapan taba virip veain, bagu sisi anune menan.” ");
INSERT INTO dgz_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Waenapan wanup namua bebep wapi nadi warapen men semu ewakewa wabenage aigap bare nadi ya warep. Wabenagepi ewakewa den koe tata amba wanup gine daiton uon, da vevera da kaimake den. ");
INSERT INTO dgz_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Guegue da sia mam. Apan da kaum wain ewakewa man etu namua kaum menan taginamene gwanap ya wa damagep. Wa damagepi kaum mek tutut wapi etua tuk wata amba kaum wa damagep etua den koe tata! Ap anega uon, go waenapan kaum wain ewakewa etua ewakewa gapan wa damagep!” ");
INSERT INTO dgz_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Diu pura muga bawarewa wamewa gapan, Iesu nao egak da, maup taue wandeni, ame berip aiwandin. Wadiamot mega den aiwandin, mu taba uit verane maup taue wandeni makewa kukunagen tavewa nane. ");
INSERT INTO dgz_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ame gapan, Parisi nagire upi yawamon Iesu inap anega wan, “Mu iwa dimen pura bawarewa iup nuga paina yamat wanum?” ");
INSERT INTO dgz_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Iesu gare anega wadiamon, “Wataget da apan Devit evene wai den enup aguguramon tane oisewa ok gapan e iravi batnak anuyan go? ");
INSERT INTO dgz_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Wam ame gapan pirisi ayop mugawa yaua Abayata wanden. Devit evene wai den, enup aguguramoni menan me God pa mega unuk ae God men taba buredi tugu seane, ian pirisi mugenat nainewa, ame iup mega den go Devit aibu na amba upi evene wai den munen. ");
INSERT INTO dgz_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Pura bawarewa wamewa ame waenapan ago tamopen menan God ta baraen, go waenapan pura bawarewa iupewa ayamase tapen menan ya tamon. ");
INSERT INTO dgz_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ap menan ne Kimani Vitana Apanewa pura bawarewa ayopewa menan ne dim da umap wapena, ameme di.” ");
INSERT INTO dgz_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Wam da sia, Iesu iup anuine paewa sia unuk aeni, apan da, naniwa nutup in wandeni, ap mepe den. ");
INSERT INTO dgz_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Iesu apan ame wagat wamewa gapan wat inakameta go uon menan waenapan kem kem yaviwanumun. Parisi nagirewa Iesu apan ame wat inakamepi mu Iesu ware wanene tapen anun. ");
INSERT INTO dgz_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Iesu nani in wandeni apanewa anega dien, “Onak, waenapan namumup mapa yon.” Ap wani apan ame ao yone ase ma one Iesu namup yonen. ");
INSERT INTO dgz_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Iesu waenapan inamup anega wan, “Ne singui da inayap waiangin. Nu pura bawarewa iup nuga dim da waiwan? Pura bawarewa gapan waenapan inamup kakaewa tain go koewa tain? Mu inakam mumain go waenapan wa danigam mumain?” Ap anega wani go waenapan no uon wanumon. ");
INSERT INTO dgz_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Amba Iesu ugu gangane den ase ma yawamoni amba bagu sisi munan anu guren, iwa mu imu pose iragi gware den wanumon. Iesu apan nani in wandeni ame anega dien, “Naniga ase endimat.” Me naniwa ase endimaseniwa boge kakae tan. ");
INSERT INTO dgz_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Parisi nagirewa pa gwanape tau amon apan Erot waenapan mega den Iesu to boniga baraepen noa barim wanumun. ");
INSERT INTO dgz_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Iesu at ame ae ve wadiamot nagirewa mega tanamo ae kaum awan Galili tauan. Waenapan arugataet me ewap amon. Ian ame at Galili amba at Diudia, ge pa Ierusalem nagirewa. ");
INSERT INTO dgz_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ge Idumea nagirewa, amba kaum Diodan asepagan wanumuine nagirewa den, amba at Taya ge at Saidon ameme iragi den Iesu taiwandini oisewa anun tauan. ");
INSERT INTO dgz_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Iesu waenapan aru ame yawamoni menan me wadiamot mega nagire diamon mu kabum da warep me gwanap wandepen menan diamon, iwa waenapan taue kapet nasepi tawa. ");
INSERT INTO dgz_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ap mepe Iesu waenapan arugataet wat inakam mumen, menan vek nagirewa Iesu inatapen menan muk gare gare inpakit wa pakit taiwanumun. ");
INSERT INTO dgz_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ame airampu potamup wanumone nagirewa, Iesu yawane gapan, iragi namup beaut geamon senao anega waiwanumun, “Ge God otua di.” ");
INSERT INTO dgz_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Go Iesu kaimakaet nomu botakame anega diamon, “Ne God Otua ame waenapan ya wadiamone.” ");
INSERT INTO dgz_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Amba Iesu togan dore munan anuni apane yaumu wan dot amon inewa tauan. ");
INSERT INTO dgz_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Amba Iesu apan aonagaet pusinawan dere om enumo, yaumu watu enamot mega nagirewa diamon. Iwa me den iwanumampen amba opata mega wadidiamopen menan om enumon. Amba me watu enamop amo nop oit kakaewa wadidiamopen. ");
INSERT INTO dgz_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Amba den aro amun ware waenapan airampu potamupe up oimop tau amopen. ");
INSERT INTO dgz_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Om enumoni nagire yaumua mam. Saimon (yaua dawa, Iesu dieni ame Pita). ");
INSERT INTO dgz_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sebedi otu wai Diemis gwaniwa Dion, amba Iesu mu dere yaumua da Boanoges diamon. (Yaumua ame guegue kiman ait waini mini waine nagirewa). ");
INSERT INTO dgz_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Upi Anduru ge Pilip ge Batolomio ge Matiu, ge Tomas ge Alopias otua, Diemis, ge Tadias, ge Saimon (waenapan mega men yonini apanewa). ");
INSERT INTO dgz_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Amba Diudes Iskeriot Iesu omine wapi apanewa. Iesu watu enamot megawa yaumua ap me. ");
INSERT INTO dgz_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Amba Iesu pa mega sia aen, at ame taueni gapan waenapan aruga tauan barat mutane gapan wadiamot megawa den taba muga na na wamewa wakauman. ");
INSERT INTO dgz_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Waenapan upi ebo anega wane, “Iesu bumbawam taiwan,” menan Iesu denip mega daitonawa nagirewa me wat nau amopen menan tauan. ");
INSERT INTO dgz_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Iup wadidiamuine nagire pa Ierusalem vit onamone nagirewa tauane, upi Iesu inap wawa koko anega wane, “Airampu bawarewa mugawa yaua Bieseboro potap unugen wandia. Airampu ame Iesu amun waneni gapan Iesu airampu up oimuiwandin tau amuiwanum.” ");
INSERT INTO dgz_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Parisi nagirewa ap wane menan Iesu waenapan iragi wan tauane amba nop maibe gapan anega diamon, “Seitan mek ingane anenen wa oiseta? Uon di. ");
INSERT INTO dgz_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Toemu da da engirit ta waiwanumampina ame dumari amoin. ");
INSERT INTO dgz_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Amba sia dugup da todum wadum taiwanumampina mu iragi ora amoin. ");
INSERT INTO dgz_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ap umap Seitan toemu mega endumepiwa, toemu mega uon di tata. ");
INSERT INTO dgz_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Seitan me aro apane mini da. Menan up apane, up tat anupiwa, anenen amba aro apane paewa unuge kwan puraput mega tambuta, me namu aro apane ware damiga pane barae amba evi kwan puraput mega tambuta.” ");
INSERT INTO dgz_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Iesu sia anega diamon, “Nop nega mondi uon anun di waivin. God waenapan koewa muga wawa koko muga den iragi anu ae veta. ");
INSERT INTO dgz_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Go orup da God Guewa inap notatae koevet ta wapiwa, God koewa mega ame anu ae ya veta, koewa mega usenagaet wande aiwandata.” ");
INSERT INTO dgz_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iesu ap me wani iwa iup wadidiamuine nagire anega wane, “Airampu da potap unugen wandia.” ");
INSERT INTO dgz_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Wam ame gapan, Iesu inewa ge gwani waiwa pa garip tauan yoniwanumun. Iesu wap onapen menan orup da watu enane aen. ");
INSERT INTO dgz_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Amba waenapan aruga ikukuk enpanan ae wanumone ame Iesu anega wadian, “Inaga ge gwanik waiga yawagepen menan tauane, itapa pa garip yoniwanum.” ");
INSERT INTO dgz_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Amba Iesu anega wayawamon, “Inana ge gwanin wainawa da?” ");
INSERT INTO dgz_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Boge me ikukuk yawamoni sia anega wan, “Ne inana ge gwanin waina mame di! ");
INSERT INTO dgz_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Waenapan da da God nop mega anune amba gueguewa tainewa ame ne inanawa amba gwanin wainawa.” ");
INSERT INTO dgz_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Wam da sia, Iesu kaum awan yaua Galili etop ap mepe sia wadidiamuiwandin. Ame waenapan arugataet da tauan iamene at bararaen menan me awana kabum gagap dotoue ae wande en, amba waenapan iragi kaum awan etop wanum tau amone. ");
INSERT INTO dgz_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Nop aruga maibe gapan anega wadidiamon, nop daiton ame mam, ");
INSERT INTO dgz_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Wapena anun. Apan da oma makewa mega verapen aen. ");
INSERT INTO dgz_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nao mega gapan uasiwandin, upi negina geamone nenip tauan enun nan. ");
INSERT INTO dgz_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Amba makewa upi agim gagap geamone ap mepe piup baware uon. Oma makewa tuk tak wan serarat yanane, ");
INSERT INTO dgz_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","kai warane go wam dotouini gapan, serarat kurat wan iwa visimu bobou. ");
INSERT INTO dgz_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Makewa upi ganongae berip geamone amba kai waran go gaian yan doran umen boge borit wane. ");
INSERT INTO dgz_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Amba makewa upi piup kakaewa gapan geamon. Ame yanan dorane tavewa iamone arugataet mek arugataet da iam ge iam tane. Tavewa apane nani yamunaet (100) o apane yampo (60), o apane daiton aonagaeta mini aigap iamon. ");
INSERT INTO dgz_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Darinaya den wandepi nop nega anun!” ");
INSERT INTO dgz_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ame ewap Iesu megenat di wanden yawanewa, watu enamot nagire mega aonagaet pusinawan derewa amba upinewa ap mepe wanumonewa, Iesu maibe mame wani menan singui wayawane. ");
INSERT INTO dgz_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Me gare wadiamon, “God toemu mega karaua wandini tavewa watap enen gase di yawayan anuiwanin, go waenapan upinewa maibe gapan megenat wadidiamuivin. ");
INSERT INTO dgz_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ap wadiamuingina iwa mega ame mu yangut tain go ya yao awain. Amba mu anuin go ya anu awain, iwa God inap entan onamop koewa muga anu ae vepi tawa.” ");
INSERT INTO dgz_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Iesu sia wayawamon, “Apan oma makewa uasiwandini maibewa wadiaena e ya anuyan menan da sia wapena anenen anui? ");
INSERT INTO dgz_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Maibe tavewa mam. Nao verini apanewa ame God nop mega waini apanewa. ");
INSERT INTO dgz_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Makewa negina geamone guegue ame waenapan God toemu mega oisewa anuiwanum, go Seitan tauen nop oit ame potamupe up taiwan. ");
INSERT INTO dgz_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Amba makewa piup baware uon gwat aigap geamone gueguewa ame waenapan nop ere anune atonu den anun. ");
INSERT INTO dgz_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Go koni ame gapan mu visimu ae ae umap uon, visimu bobou otu da megenat aen menan potamup ya waren. Go evi amba pusi warup inamup taueni gapan mu aro muga uon tan menawaet inak wakaumane. ");
INSERT INTO dgz_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Amba sia makewa ganongae berip geamone gueguewa ame, waenapan nop anun ");
INSERT INTO dgz_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","go piup itan megawa o aton megawa o moni puraput imumu waren menan God imu pose ya waren amba kiman inak mega kakaewa da inamup ya venasen menan tavewa da ya ian. ");
INSERT INTO dgz_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Amba makewa piup kakaewa gapan geamone gueguewa ame, waenapan nop anu kakayasene. Bumagamu totanen anu waran ayamase yaentuk mantuk di taiwanumune ae ya vene, menan inak muga tavewa mega kakaevet apane nani yamunaet (100) o apane yampoa (60) o apane daiton aonagaetawa (30) tavewa dim da verine aigap ien aewan.” ");
INSERT INTO dgz_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Iesu sia wadidiamon, “Apan da dun mega pa wat onepi amba baraeta? Unup nokap wat eneta o diguma baraeta? Ae uon, paina aroga sineta. ");
INSERT INTO dgz_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Menan ap mini sia, dim dim iravi karaua tainewa wam da arogameta. Dim dim iragi ukum umanewa evi amba ganat gapan aroga tauain. ");
INSERT INTO dgz_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Darinaya den wandepiwa nop nega anun. ");
INSERT INTO dgz_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ap menan ae anu guran, nop nega yaentuk anuiwanian. Upi wanene tamonewa, God gare ap umap wanene taeta, amba om enunewa, om ap umap sia enueta go aigap kaimake den enueta. ");
INSERT INTO dgz_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Orup da da mu nop nega anu warepiwa, ame God nop upi sia aigap aigap muneta. Go orup da da ya anu warepiwa, nop otu da namu anun waranewa, God nop ame sia waseamo aeta.” ");
INSERT INTO dgz_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ame Iesu anega wan, “God toemu mega guegue manega. Apan da oma makewa naewa egak mega gapan veramon. ");
INSERT INTO dgz_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Mum gapan apan ame aup ininiwa amba wam gapan yapagen dotogen tainiwa, oma makewa veramoni ame pamagen di yaniwanum, go anenen yanine apan ame, me oare. ");
INSERT INTO dgz_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Piup mek ingane tavewa wat matakamen baria. Namu dumen amba yanen amba tavewa iniwa. ");
INSERT INTO dgz_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Oma tavewa maup inin geraget tani, amba nao ame i apanewa kereba mega waren di guria, iwa maup matakamepen wamewa gaset inen. Endi God toemu mega amunua ap anega.” ");
INSERT INTO dgz_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ambagan Iesu diamo anega wan, “Endi God toemu mega guegue anenen wat amba venaseta, o nop yaunewa anenen wapena amba anu kakayatai? ");
INSERT INTO dgz_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Gueguewa mam, oma make potape mini. Oma baip makewa ame otu koentu iragen, go apan verepi ");
INSERT INTO dgz_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","amba kai ware entanep oma baware iragen tata. Nenip taue dugup muga oma ame nani naniwa gapan iragi gungunup waramoin.” ");
INSERT INTO dgz_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Iesu nop ugup ugup iravi maibe gapan waenapan wadidiamon. ");
INSERT INTO dgz_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nop aroga da ya wan go maibe gapan waenapan wadidiam wandin. Go wadiamot mega mugenat tanamo wandeniwa, maibe tavewa iravi aroga wadiamon. ");
INSERT INTO dgz_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Wam ame mum ginewa taueniwa, Iesu watu enamot nagire mega anega diamon, “Kaum awan to nuguset asepagan anepen.” ");
INSERT INTO dgz_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ap mepe waenapan ae vemon Iesu kabum namu dore wanden amba evip wadiamot megawa dorane boge tanan amon. Kabum upi den amon. ");
INSERT INTO dgz_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ap amuiwanumune gapan taik aritavet da aroe den awan gagap tauen. Kaum dotoue kabum gwanap geariwandin amba kabum awana unugepen tan. Mu iragi bop nonokap tauapen taiwanumun. ");
INSERT INTO dgz_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Go Iesu kabum nimere gapan iwa utugan gapan enu aup iniwandin. Menan mu wa kandasen anega wane, “Wadianet nugawa, nu bop tapen taivin nunan anuingi go uon?” ");
INSERT INTO dgz_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Boge Iesu kandae taik ge kaum baware ame kaimakaet ase diamo anega wan, “Ae bigagit! Ununke uon wainge!” Boge taik ge kaum baware ame tom wa ae bigaren. ");
INSERT INTO dgz_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Iesu singui anega wayawamon, “E tap iwa dimen taiwanin? E anu tumat ega ne inanap otu kamontu.” ");
INSERT INTO dgz_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Go mu tap aigap sia tan tarak anega wawa mutan, “Akae, ma dim apan da? Taik ge kaum diamoni boge noa di warane.” ");
INSERT INTO dgz_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ame Iesu, watu enamot nagire mega den tanam, kabum gapan awan Galili ame gamu to nugusen pa sewa Gerasin tauan. ");
INSERT INTO dgz_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Iesu kabum ae ve piupa viseni pa apane da airampu potap wandeni Iesu ine serarat tauen. ");
INSERT INTO dgz_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Apan ame kaima arewa gapan ininiwa, go waenapan da apan ame ware damiga ya taup umap, ame damik kaimake dena gapan panine go umap uon di. ");
INSERT INTO dgz_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Wam da da pusiwa naniwa damiga paniwanumun go nani vikimen pusiwa damik gwat gan ae tomagen siniwa. Waenapan warat anune go me gure pakit uatamen. ");
INSERT INTO dgz_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Mum wam kaima arewa amba tunupa den ve ao wan wapiwa mek ingane gwat gapan totomagen denip tauiniwa. ");
INSERT INTO dgz_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Apan ame Iesu paina yaveni serarat ae namup taue omanip enun. ");
INSERT INTO dgz_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","amba Iesu airampu inap kaimakaet anega dien, “Apan ae ve, tau ak!” Ap menan airampu nop kaimakaet anega wan, “God Paina Iragenawa Otua Iesu, inanap dim tat anu tauaan? Kaiwan, ya ta koeragam nimanegepen menan God yamap agi wa.” ");
INSERT INTO dgz_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Anega wani Iesu singui wayaven, “Ge yauga anen?” Airampu arugataet potap unuk wanumone menan airampu gare anega wan, “Nu airampu arugataet waninan menan nu yaunu ‘Arugataet’.” ");
INSERT INTO dgz_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Airampu arugataet ame Iesu inap kayawan mini anega wan, “At ma gapan ya wa oine.” ");
INSERT INTO dgz_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ap mepe, togana tuan arugataet taba naiwanumun. ");
INSERT INTO dgz_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Menan airampu Iesu nanamasen anega wane, “Wa oine, nu tuan potamup unuget.” ");
INSERT INTO dgz_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Menan Iesu anega wan, “A, umap tau aisen!” Airampu apan ae vean tau amon tuan potap unumon. Unumone tuan togana serarat vitan kauma geamone none namon. Tuan ameme arugataet mek arugataet (2000) da. ");
INSERT INTO dgz_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Tuan kwayup taine nagire yawamone tap serarat amon pa pa, at at oit wadidiamon. Pa nagire oit anune gapan serarat tauan anen tane yawapen onamone. ");
INSERT INTO dgz_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ame waenapan amon Iesu inewa tauanewa, airampu arugataet potap wanumone apanewa i guine tamana tan, wanup ene ap mepe ae wanden yawane menan mu tap ase anu guran. ");
INSERT INTO dgz_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Amba inak mame yamap ase yawane nagirewa, amon inak ame anenen apan ge tuan inamup venaseni oisewa waenapan iravi wadiamon. ");
INSERT INTO dgz_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Menan at Gerasin nagire iragi Iesu at muga ae ve aepen menan tapawan wane. ");
INSERT INTO dgz_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Iesu kabum gagap dorapen tani airampu potap tau amone apanewa taue anega kayawan mini wan, “Tatan, gende anepen.” ");
INSERT INTO dgz_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Go Iesu watane anega wadien, “Ewagai pa ak, ap mepe Ayop God anenen genan tan amba imua inagap wareni oisewa denip gega daitona nagirewa wadidiam.” ");
INSERT INTO dgz_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Wani, apan ae pa sewa da da iragi aonagaet yaua Dekapolis gapan Iesu menan tani oisewa wadiam wadiam aeni menan waenapan no i kap wan. ");
INSERT INTO dgz_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ame Iesu kabum dotoue kaum awan eto yamunewa sia entan aeni, ap mepe waenapan arugataet tauan awan etop ikukuk enpanane. ");
INSERT INTO dgz_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Diu nagire opata waine paewa kwayup taini apane da ap mepe den, me yaua Diairas. Me Iesu yaveni gapan ine taue namup omanip enu, wae wae ta anega wan, ");
INSERT INTO dgz_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","“Ne orana boepen taiwan. Kaiwan endi onak naniga iap bare, me inak ware wande ep.” ");
INSERT INTO dgz_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Anega wani Iesu dere amon. Go waenapan aru ame git git amon Iesu ase kapet natane. ");
INSERT INTO dgz_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Amba waenapan aru ameme yaumakamup waen da vek ewatop wareni en mega aonagaet pusinawan dere uon tan. ");
INSERT INTO dgz_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Amba dom gigit nagirewa wa tomagepen men tane go me di wat ire aiwandin, me agim make mega iragi ap mepe danam oitamen, go vek ame uon tata bumagap di aiwandin. ");
INSERT INTO dgz_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Amba waen ame Iesu dim da taiwandini oisewa anuniwa, mek ingane anega anuni, ‘Ne wanup mega ginewa megenat inatapenawa, ne inak warain,’ ap anega anuni menan waenapan aru ame napamup garivi taue Iesu wanup mega inasen. ");
INSERT INTO dgz_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Inaseni boge ewatop taiwandini tom wan, menan me ugu wapi ae doron anuni me vek mega gaset uon tan inak waren. ");
INSERT INTO dgz_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Iesu aro amun mega gamupe tau aen anun. Ap menan ikukuk to entane waenapan aru ame to iam wanumune anega wayawamon, “Wanup nega da inasen?” ");
INSERT INTO dgz_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Wadiamot megawa gare anega wane, “Waenapan aru ma to iamene kapet natagiwanumune yawamoan amba dimen da waraget wan waingi?” ");
INSERT INTO dgz_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Go Iesu yangut ikukuk di tanau iwandin ame wanup mega da inaseni otua ire yawapen taiwandin. ");
INSERT INTO dgz_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Amba Iesu wanup mega inaseni waenewa ae anuni me gase inak waren, ap menan taue Iesu namup nikapu enu, tap anu gure dararame den wanup inaseni oisewa iragi wadien. ");
INSERT INTO dgz_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ap wani Iesu waen anega wadien, “Oranawa, anu tumat nimanegeana menan inak wariagi. Nonup gapan ak, vek gega uon tan.” ");
INSERT INTO dgz_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Iesu nop ame waiwandini gapan, sep nagirewa upi Diairas pa mega gapan tauan oit Diairas anega wadiane, “Oraga gase boen. Ap menan wadianini apanewa Iesu menan gamben gamben sia ya wa taingan.” ");
INSERT INTO dgz_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Iesu nop ame anuni Diairas inap anega wan, “Tap ya anu. Aigap sia anu tumat nimanegewa, oraga inakaeta!” ");
INSERT INTO dgz_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Iesu waenapan upi watanamon go Pita ge Diemis ge Diemis gwaniwa, Dion mugenat tautan amon. ");
INSERT INTO dgz_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ame tanam ae Diairas pa mega tauane gapan orup waen ame boeni menan waenapan irip turup ap mepe waiwanumune yawamon. ");
INSERT INTO dgz_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Pa unuk aeni Iesu waenapan anega wayawamon, “E dimen gego anu tayan irip turup waiwanin? Irip ae vean, me mondi aup iniwan, ya boen.” ");
INSERT INTO dgz_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Iesu nop ap wani menan waenapan iragi verea kaura tan top nop wane. Go Iesu waenapan wa oimon namboya vitan. Amba Iesu yone orup ame ine mamewa amba watu enamot mega apan yampo tanam pa gwanewa enugutane ame gwanap unuk amon, orup bonigawa ap mepe iniwandin. ");
INSERT INTO dgz_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Amba Iesu orup waen boeni nanip ware anega dien, “Tarita koum,” nop ame guegue, “Orup waen, ao yon wanik!” ");
INSERT INTO dgz_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Iesu nop ap wani no utap orup waen ame ao yon wande ap pa gwane ikukuk aen. Menan waenapan iragi daramu wan no i kap wan. Orup waen ame en mega aonagaet pusinawan dere. ");
INSERT INTO dgz_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Go Iesu anega diamon, “Ne tana oisewa waenapan ya wadiamone.” Iesu ine mame anega wadiamon, “Oraya, taba da wanane nap.” ");
INSERT INTO dgz_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ap mepe Iesu at ame ae ve amba pa sewa mega di aen, watu enamot mega den tanam amon. ");
INSERT INTO dgz_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ap mepe wam pura bawarewa taueniwa, iup anuine paewa gwanap ere wadidiamon. Waenapan nop mega anuiwanumune gapan no i kap wan, anega waiwanumun, “Apan ma dima ge yo paua mame aroewa iragi ambagan waren taiwan? ");
INSERT INTO dgz_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Go me pa tuini apane otua mo? Inewa yaua Meri. Amba gwani wai apan Diemis, Diosep, Saimon ge Diudes. Amba domare wai iravi nu den inivin. Me mondi pa otua megenat.” Amba waenapan bagumu sisi wan Iesu tandayasene. ");
INSERT INTO dgz_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Go Iesu gare wadiamon, “God no oise viripe ya tainewa ame pa sewa megawa amba mek pa mega gwanap wanumuine nagirewa mugenat di.” ");
INSERT INTO dgz_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Inap ya anu tumasene menan kiman paua mega bawarewa da ap mepe ya tan. Vek nagirewa otu dere naniwa wapip se wat inakam mumen. ");
INSERT INTO dgz_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Me nop uon tan, iwa waenapan me inap anu tumat da uon. Ap menan Iesu sewa mega ae ve sewa ugupewa da gapan opata ap mepe wadiam wandin. ");
INSERT INTO dgz_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Amba Iesu watu enamot mega aonagaet pusinawan dere munan wan tauane, amba aro amun mega airampu wa oimopen menan munen. Iesu apan dere dere watu enamon. ");
INSERT INTO dgz_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Anega wadiamon, “Aisene negin purapuse da den ya tam aisene. Taba go moni ega da den ya tambune go kaipat ega megenat tambun. Pusi okomewa megenat enan go wanup senunawa den ya tambune. ");
INSERT INTO dgz_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ame aisene amba pa da atonu den waupaepiwa, ap mepe iniwanian, ap tapen wamewa tauepiwa, amba pa ame ae vean aisen. ");
INSERT INTO dgz_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Go at da waenapan da da ya waupaepi pa muga ae vean aisen, koewa muga ae bat munapen menan pusia atabobo toninigamen aisen, ame tane yam tatak munapen.” ");
INSERT INTO dgz_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Iesu wadiamot megawa tau amone opata anega wadidiam wanumun, “Koewa ega ae vean imuya entanen.” ");
INSERT INTO dgz_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Amba den airampu waenapan potamupewa up oimone tau amuiwanumune amba vek nagirewa oma Olip osewa iamup gemiwanumune inak wariwanumun. ");
INSERT INTO dgz_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Iesu yaua senare aiwandini waenapan iragi asigip tane menan ayop Erot, at Galili ayopewa, Iesu oisewa anun. Waenapan anega waiwanumun, “Iesu yo paua ugup ugup taiwandini iwa, Dion, dup iamuini apanewa, bop gapan sia yon wanden taiwan.” ");
INSERT INTO dgz_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Amba upinewa anega wane, “Iesu watageta apanewa Elaidia.” Upi anega wane, “Me watagaet God nop mega waiwandini apane da umap taiwan.” ");
INSERT INTO dgz_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Wane go apan Erot anuni anega wan, “Iesu me Dion di. Wataget ne wan apan nega Dion megewa to nugusen boen go sia inakae yon wanden.” ");
INSERT INTO dgz_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","19","Apan Erot gutut mega mam. Me gwaniwa Pilip waenewa Erodias up ta naisen. Dion dup iamoni apanewa ayop Erot anega diwandin, “Narawagawa waraana iup paina yamasean.” Dion ap waiwandini menan Erot waenewa ame, yaua Erodias, garewa tot anun go memewa watanen. Go waenewa Dion inap gari gangan naeni, iwa Dion Erot waenewa ameme wainan gogo taiwandat dien menan Erot wan ita mega nagirewa waran, taun gwat noke baraen. ");
INSERT INTO dgz_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Erot me Dion tawa anuni menan tantan mega taiwandin. Me anuini Dion apan kakaewa imu pose woup am seni apanewa. Amba den me Dion opata mega anupen men wam da da gapan anutaet tainiwa. ");
INSERT INTO dgz_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Amba waen Erodias Dion topen neginewa da yop ta tautanen, ame Erot yaneni wamewa baripe gapan. Namu yoyo nagirewa ge ita yamewa nagirewa ge at Galili bawarewa mugawa iravi barip ame menan tauan. ");
INSERT INTO dgz_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Barip taiwanumune gapan Erodias orewa taue Erot evene wai den tarep munan waren. Mu tarep ame yawane gapan aton anune. Erot aton anuni menan waenoro ame anega wadien, “Ge dim da men anu wawa ne di genain. Mame di wa agiat gimagivin, ");
INSERT INTO dgz_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ame ne yon tau nega upi seu enu genapen yon borai.” ");
INSERT INTO dgz_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Boge waenoro tau ae inewa singui tayaven, “Inan, ne dim da men mua wain?” Inewa gare wan, “Ge Dion dup iamuini apanewa iwa to nugut genapen mua wa.” ");
INSERT INTO dgz_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Waenoro ame serarat ae ayop Erot ine taue mup anega wan, “Daragi mame di Dion waenapan dup iamuini apanewa iwa to nugut sera gapan barao ma di nen!” ");
INSERT INTO dgz_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Erot waenoro ame mup mega wan anuni bagu sisi anun. Go evene wai barip men tauane yamap waenoro wanat wa agiaseni menan ae ya veat anun. ");
INSERT INTO dgz_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Menan Erot ita apane mega da watu enen gwat noke taue Dion mege gamu to ketnagen. ");
INSERT INTO dgz_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Dion i bonewa sera gapan bare wat onen, waenoro ame ase wanen. Waenoro wat ae inewa wanen. ");
INSERT INTO dgz_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Amba Dion wadiamot megawa oit ame anunewa tauan etua waran amon amba urata tune. ");
INSERT INTO dgz_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Iesu watu enamot mega nagire sia entan tauane amba dim dim tane oisewa iragi Iesu wadian. ");
INSERT INTO dgz_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Go waenapan aruga tau ge amo taiwanumune menan taba muga na na wamewa uon tan. Iesu wadiamot mega anega wadiamon, “Egenat onaene anet at iumai toni arewa da gapan ap mepe nonan banu warat.” ");
INSERT INTO dgz_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ap mepe mu mugenat amon. Mu kabum waran at iumai toni arewa ame amon. ");
INSERT INTO dgz_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Go waenapan oise anune menan pa sewa gapan pusimup ewap amone. ");
INSERT INTO dgz_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Iesu kabum gapan asepagan taue, gerata enaseni gapan me waenapan arugataet yawamoni imu pose munan anu guren. Bagu sisi anuni iwa mu ago muga da uon, ame man sip kwayup taini mini, kwayup tamuini apane da uon, nutumu uon amba itan bagu sisi wariwanumun. Ap menan me nop ugup ugup arugataet wadidiam wandin. ");
INSERT INTO dgz_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Mum gine di taiwandini gapan, wadiamot megawa ine tauan anega wan, “At ma waenapan uoni arewa, amba wam gaset gearen mum di tauapen taiwan. ");
INSERT INTO dgz_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Menan waenapan to iam baware mame watu enamot amo, taba upi pa gwanap muk muk une ta nap.” ");
INSERT INTO dgz_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Wane go Iesu gare wadiamon, “Ae, ap anega uon. E taba da munane nap.” Go mu gare anega wane, “A, nu anenen munait? Anet taba buredi une tat munat nain go? Taba garewa baware nu moni apane aonagaet (200) sea sea umap uon.” ");
INSERT INTO dgz_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ap wane menan Iesu sia wayawamon, “E taba buredi magamene animpo tambuyan? Aisen yawan.” Amo yawane anega wan, “Nu taba buredi magamene nani yamunaet amba meo dere ap mugenat.” ");
INSERT INTO dgz_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Amba Iesu waenapan iragi unawat gagap ae wanumopen diamon. ");
INSERT INTO dgz_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Upi apane nani yamunaet (100) upi apane dere apan da aonagaet (50) iam iam tan wanum wanum amone. ");
INSERT INTO dgz_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Amba Iesu taba buredi magamene nani yamunaet meo dere den ame tambu kiman ao yave God inap gaun wa amba paise paise ta waenapan taba munapen men, wa ewamot megawa munen. Meo dere den paise munen boge mun ge mun amon. ");
INSERT INTO dgz_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Waenapan iravi taba tavewa nane bagumu bim wan. ");
INSERT INTO dgz_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Nane ewap, wadiamot megawa taba semua bongamen kaenat aonagaet pusinawan dere enane no dotouen. ");
INSERT INTO dgz_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Apan ap mepe taba tavewa nane arugataet 5000 umap, waen orup den batnagetawa aigap den sia. ");
INSERT INTO dgz_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Amba Iesu wadiamot megawa kabum gagap kaum etop asepagan pa sewa Betsaida namu amop amba me evi aet wan. Iesu waenapan to iam baware ame watu enamon amone. ");
INSERT INTO dgz_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Amba me waenapan wa oimoni ewap, God inap mup wapen menan togan dot aen. ");
INSERT INTO dgz_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Mum gine me megenat ap mepe wanden. Kabum gaset ae awan bumagewa tauen. ");
INSERT INTO dgz_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Me wadiamot mega yawamoni, kabum waran to entanepen menan tapanan taiwanumun iwa taik taue kabum nasiwandin gapan. Mum igoe dena gapan Iesu munan kaum gagap pusip ap oniwandin boge garawat mum tau aepen taiwandini. ");
INSERT INTO dgz_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Wam ame wadiamot megawa kaum gagap ap oniwandin yawane, mu tap baware anun anega wane, “Ma guagup da tauia!” Amba tap den senao vebobop wane. ");
INSERT INTO dgz_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Mu iravi yawan tap baware anun go Iesu anega diamon, “Ma ne, tap ae vean gop ya anune.” ");
INSERT INTO dgz_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Kabum gagap dotoueni gapan taik tom wabigare tau aen. Wadiamot mega anu waramasene imumu puk wan. ");
INSERT INTO dgz_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Iesu namu taba buredi paise paise ta waenapan muneni ap gueguewa mu ya anu awan iwa imumu kaimake wan. ");
INSERT INTO dgz_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Mu awan ame gamu to nugusene at Generaset gerata en natane. ");
INSERT INTO dgz_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Kabum ae veane waenapan Iesu ire menawaet yawane, ");
INSERT INTO dgz_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","menan serarat amon at at ise tau ase tau amon vek ato nagirewa eragia se onam wanumun. Iesu amba wandeni arewa gapan ap mepe amon. ");
INSERT INTO dgz_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","At at pa pa Iesu tau ge tau aeni gapan waenapan vek nagirewa une gare gare taine arewa gapan sean wanumon. Mu Iesu wanup mega gine siwa den inasepen menan mup wane, orup da da Iesu wanup mega ginewa inatanewa iragi inak mutane. ");
INSERT INTO dgz_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Wam da gapan Parisi nagirewa amba iup wadidiamuine nagirewa den pa Ierusalem gapan onamone tauan Iesu ikukuk nau panan. ");
INSERT INTO dgz_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Iesu wadiamot megawa upi taba nanimu bigi den naiwanumune mu yawamon. Parisi nagirewa God menan nani bigi warine mini, mu nani bigi ya waran. ");
INSERT INTO dgz_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Parisi ge Diu nagirewa den guegue muga ap anega. Isimure wai guegue ap taiwanumune menan mu ap anega sia taiwanum. Ap gapan mu God menan nani bigi warane amba nainewa. ");
INSERT INTO dgz_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ap gapan mu taba da une gare gare taine arewa gapan une tane ya nain, namu God menan nanimu bigi ware amba nain. Amba den yogup sip unup dim dim den ap mini God menan bigi wariwanum, wataget ugup ugup taiwanumune ap den sia taiwanum. ");
INSERT INTO dgz_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Parisi iup wadidiamuine nagire den Iesu inap anega wawa koko tan, “Iwa dimen wadiamot gegawa omayan baewa guturewa iup mega to paisiwanum? Mu God menan namu nanimu bigi ya warane amba taba naiwanum.” ");
INSERT INTO dgz_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ap wane menan Iesu garewa anega wadiamon, “E da wa da ta taiana nagirewa. Apan Aisaya e evi taiwaniampina oisewa namu tave di wan. God enan anega wan, E iravi noya gapan viripana den taiwanin, go imuya potaya ne inanap ya wariwan. ");
INSERT INTO dgz_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","E wa taragat nimanegepen menan umap uon iwa gutut ega ek anuiana gapan wadiamuiana menan. ");
INSERT INTO dgz_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","God iup mega tandayasean gare apan iragen nop muga anuyan taiwanin.” ");
INSERT INTO dgz_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Iesu sia wadidiamon, “God nop mega ae vea gare iup ega tapen men daramuya dima wayan taiwanin. ");
INSERT INTO dgz_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Iwa watageta apanewa Mosis anega diaen, Inae mamae virimu tan amba da da mamewa o inewa ta koeragam mumepi, ame togurep di boep. Ap anega sen. ");
INSERT INTO dgz_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Go e ugup anega waiwanin, Apan da da ine mame anega wadiamopi, ‘Nu enat wa agiat imaetoni ya enait nu God wanait.’ Ap anega wapi ine mame virimu ya taiwanum go e umap waiwanin. ");
INSERT INTO dgz_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ame gapan ine mame ayamase tat anuine watanam wanin. ");
INSERT INTO dgz_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Menan e gutut ega tapen menan God nop mega ayamase ya taiwanin. Inak eboewa ame naewa ega den wadidiamuiana gapan guegue ap miniwa ugup ugup den taiwanin.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Iesu waenapan munan wan tauane anega wadiamon, “Wapena di anun, anu kakayasen. ");
INSERT INTO dgz_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Waenapan taba ugup ugup naine gapan imumu God yamap bigip ya taiwan. Go dim da no utap aoma tauiniwa, ame gapan imumu God yamap bigip taiwan.” ");
INSERT INTO dgz_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Mame ewap Iesu waenapan ae vemo pa gwane unuk aeni wadiamot mega maibe wani iwa anupen menan singui wayawan. ");
INSERT INTO dgz_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","“E da ya anu kakayat wanin? Iwa dimen asik ya tayan? E asigiap, taba ugup ugup naiana gapan imuya potaya God yamap bigip ya tata. ");
INSERT INTO dgz_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Taba ap me nane gapan imuya potayap ya taueta go ni etavewa gapan wande amba tau aeta.” Ap wani gapan, Iesu taba ugup ugup iragi kakae diamon. ");
INSERT INTO dgz_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Iesu sia wadidiamon, “Go wan dim dim ame noa gapan aoma tauini ame imu pose gapan tauiwan, ap me gapan imuya God yamap bigip tan. ");
INSERT INTO dgz_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Imuya potaya gapan koewa anuyan taiwanin. Koerage anuiwanin, wainan gogo taiwanin, dim dim up taiwanin, apan naniap borit waiwanum, ");
INSERT INTO dgz_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","gwep gorogot nau guguraiwan amba evenae wai puraput muga men wayan baguya kandaiwan amba koewa ugup ugup taiwanin. Evenae wai imua aopan wariwanin, koewa ek tayan kakae tat anuiwanin. Upi anu koeam mumiwanin, nuaroro waiwanin, apan apan taiwanin, amba bumbawam mini taiwanin. ");
INSERT INTO dgz_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Koewa ameme iravi imuyap potayap wandia menan iravi mame gapan di God yamap wabigim imainiwa.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Iesu yone ae pa sewa Taya tauen. Amba me taue pa gwane unuk aeni oisewa waenapan da ya anupen menan tan, go mu iragi asigip tane. ");
INSERT INTO dgz_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ap mepe waen da orewa airampu potap wanden, waen ame Iesu taueni oisewa anun. Ap menan menawaet taueni boge Iesu namup nikapu enun. ");
INSERT INTO dgz_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Me Diu uoni Gurik noa waini waenewa pa sewa Ponisia at Siria gapan tauen. Waen ame Iesu inap noek noek wan airampu orewa potape warup oirenep tau aepen menan waiwandin. ");
INSERT INTO dgz_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ap wani, Iesu maibe gapan me namu Diu nagirewa ago tamopen menan taueni oisewa anega wadien, “Orup otu namu watumot. Go orup otu taba muga eyao ya munait, ame tamana uon.” ");
INSERT INTO dgz_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Diu uoni waen ame sia anega wan, “E, ayop negawa, ge tave di waingi. Go orup otu taba watara naine gapan semua geamuine eyao den nainewa.” ");
INSERT INTO dgz_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Waen ap wani menan Iesu anega gare wadien, “Nop nega wana garewa kakaevet di waana menan pa ak. Airampu oraga potap wandeni gase tap tau aen.” ");
INSERT INTO dgz_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Iesu ap wani boge waen ame pa ae yaveni airampu orewa potape taue aen, me kakae ta aup parata iniwandin yaven. ");
INSERT INTO dgz_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Iesu at Taya ae ve at Saidon arige pa iragi aonagaet yaua Dekapolis den tau ge tau aiwandin amba kaum Galili etoa sia tauen. ");
INSERT INTO dgz_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Iesu ap mepe wandeni gapan, waenapan upi darine borasen nop memo waini apanewa da Iesu inap wat onamon. Iesu naniwa wapip barae wat inakamepen menan mup dagin dagin waiwanumun. ");
INSERT INTO dgz_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Boge Iesu apan ame ware waenapan ae vemo asira sensenui ae, nani piru apan darine nokap ene, amba naniwa giton ene apan meriwa inasen. ");
INSERT INTO dgz_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Amba Iesu ao kimani yangut ta, gaup kaimakaet warupeni amba apan anega dien, “Epata.” Nop ame guegue darine purut wap. ");
INSERT INTO dgz_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Wani boge apan darinewa purut wan megewa awasen nop kin kin aroga ase wan. ");
INSERT INTO dgz_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Iesu ame tani oisewa pa pa ya wadidiamopen menan no botakamen. Aigap aigap ap diamoni go mu ya anun aigap aigap wadidiam wanumun. ");
INSERT INTO dgz_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Amba waenapan nop oit mame anune iragi no i kap wan anega wane, “Iesu wan dim dim taini iragi kakae iragen megenat. Darine boraseni sia anuiwan, mege boraseni sia nop waiwan,” ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Wam da sia waenapan arugataet tauan amba Iesu inap sia iamene go taba muga uon tan. Iesu wadiamot mega munan wan tauane anega wadiamon, ");
INSERT INTO dgz_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ne waenapan ma munan bagu sisi anuivin. Mu tanamo wanigen wam yampo gaset uon tan amba taba na na da uon. ");
INSERT INTO dgz_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Wapimu negina torot wapi tawa menan, mondi enup agut ya watu enamot anuivin.” ");
INSERT INTO dgz_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Wadiamot mega singui anega wayawan, “Nu taba amba tambut umanup tap amba to iam baware ma watumoit, at ma kaimewa arewa mini, taba da uon?” ");
INSERT INTO dgz_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Wane Iesu singui wayawamon, “Taba buredi animpo inayap wanumam?” Mu gare wane, “Nani yamu dere.” ");
INSERT INTO dgz_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Iesu to iam baware ame diamon piupa ae wanumon. Boge me taba buredi tambu amba God inap gaun wani, paise paise ta wadiamot mega munen amba mu waenapan munane. ");
INSERT INTO dgz_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Meo otu koentu upi den aie God inap gaun wa waenapan munapen menan den diamon. ");
INSERT INTO dgz_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Mu iragi nane umap tamon amba semua bongamen kaenat nani yamu dere enane no dotouane. ");
INSERT INTO dgz_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Waenapan ap mepe taba nane arugataet 4000 umap. Iesu waenapan wa oimon amone. ");
INSERT INTO dgz_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Amba me boge wadiamot mega tanam kabum gwanap dotouan at Dalomanuta amon. ");
INSERT INTO dgz_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Parisi ge Sadusi nagirewa upi Iesu ine tauan pusi warup ta yawapen menan singui anega wayawan, “Ge aro kimaniwa paua da ta nu yawat anuivin.” ");
INSERT INTO dgz_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nop ame wane Iesu gari yaven anega wadiamon, “Endi iniana nagirewa iwa dim men kimaniwa yo paua mega yawat anuiwanin? Nop nega mondi uon anun di waivin. Ne paua daiton da ya ta ewain.” ");
INSERT INTO dgz_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Boge Iesu kabum gwanap dotoue kaum yamu asepagan aen. ");
INSERT INTO dgz_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Mu awan gamu to nugusen amon. Iesu wadiamot megawa taba buredi na na mega upi tambu tambu imumu borat mutane, magamene daiton megenat kabum gagap baraen. ");
INSERT INTO dgz_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Amba Iesu tagigit kaimakaet diamon, “Agun anun, Parisi nagirewa ge ayop Erot koewa muga anu kakayasen. Mu guegue muga ame buredi tutut wapen menan atagin potap enine mini.” ");
INSERT INTO dgz_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Mu nop ame waran amba yaumakamup baraen wawa mutan amba anega wan, “Mame wani iwa nu taba buredi da ya tam onantoni menan waiwan.” ");
INSERT INTO dgz_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Iesu nop muga imup anun men anega wayawamon, “E anu tumat ega otu koentu, iwa dimen taba buredi ya warat waiwanin? Imuya potaya kaimake wan go? ");
INSERT INTO dgz_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","E yamaya den go ya yaviwanin darinaya den go ya anuiwanin. Ne wana iwa dimen ya anuiwanin? E anuyan go uon? ");
INSERT INTO dgz_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","E ya di anu aviaisi. Ne wata buredi magamene nani yamunaet gapan apan aruga 5000 munan nane amba semua bongameana kaenat animpo enayan?” Mu gare anega wan “E, nu kaenat aonagaet pusinawan dere enaton.” ");
INSERT INTO dgz_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Iesu sia wayawamon, “Amba ewap buredi magamene nani yamu dere gapan apan 4000 munan nane amba semua bongameana kaenat animpo enayan?” Mu gare anega wan, “E, nu kaenat nani yamu dere enaton.” ");
INSERT INTO dgz_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ap wane Iesu singui wayawamon, “E sia ya anu kakayat wanin go?” ");
INSERT INTO dgz_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Amba Iesu wadiamot mega tanamo pa sewa Besaida tauan. Waenapan upi yame boraseni apanewa da waran Iesu inewa tauane amba naniwa wapip inase wat inakamepen menan noek noek waiwanumune. ");
INSERT INTO dgz_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Menan Iesu apan ame nanip ware pa sewa garip nau aen. Aeni apan yamap giton en anen naniwa wapip ae inase singui anega wan, “Endi ge yangut taingi?” ");
INSERT INTO dgz_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Apan yangut paina ase ma yave anega wani, “Ne apan yawamuivin go mu oma ap amuine mini yawamuivin,” ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Menan Iesu naniwa dere sia apan yamap use waboren. Boge apan yame ase meret wa kakayasen birom barom taini uon tan yangut kakaevet taiwandin. ");
INSERT INTO dgz_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Iesu apan ame pa wa oiseni, anega dien, “Pa sewa ase inamup ya age go pa gega di ak,” ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Wam da Iesu, wadiamot megawa den, pa sewa yaua Sisaria Pilipai arigewa gapan tauane, negina wadiamot mega singui wayawamon, “Waenapan ne da dianek wanum?” ");
INSERT INTO dgz_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Mu gare anega wane, “A, ge Dion waenapan dup iamoni apane diagiwanum. Upi watageta apane Elaidia diagiwanum. Upi ge God noa waiwandini apane da diagiwanum.” ");
INSERT INTO dgz_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Menan Iesu mu inamup singui anega wayawamon, “Umap, go e ne da dianegiwanin?” Saimon Pita gare anega wan, “Ge God mega wa watu enageni Keriso.” ");
INSERT INTO dgz_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Iesu ame anega wani wadiamot mega kaimakaet sia diamon, “Ne God mega wa watu enanegeni Keriso ame waenapan ya wadiamone.” ");
INSERT INTO dgz_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Iesu wam ame use aeni nop ere watape wa ewamot mega aroga anega wadiamuiwandin, “Ne Ierusalem angep. Ap mepe waenapan dimae waine nagire amba pirisi bawarewa ge iup wadidiamuine nagire den nanimu gapan ugu vegaek bagu sisi baware anu tanain. Amba toguranegep bonigatain. Toguranegep bonigasepena amba wam yampoa God amun mega gapan inak nigat sia yon wanigain.” ");
INSERT INTO dgz_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ap anega wani menan Pita Iesu nau asira ae amba, ap anega ya wapen menan dien. ");
INSERT INTO dgz_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Go Iesu entane wadiamot mega upi yawamoni amba me Pita anega diguren, “Ge Seitan mini, tau garinap ak. Ge oma ibariwa mini namuna boringi go God wan dim dim mega iagap ya baraingi, go apan iak guine gapan waingi.” ");
INSERT INTO dgz_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Amba wadiamot megawa waenapan den iragi onamopen wan tauane anega wadiamon, “Orup da inanap onat anupiwa, namu me mek dim da anuini tandayase, ae di vep, amba ne yauna menan, pot poraet ugu vegaek bagu sisi anu, korosi mega ware evinap oniwandan. ");
INSERT INTO dgz_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Amba orup da da muk inak mugawa menan anu gurane tainewa, ame inak muga wakaumain, go orup da da mu inak muga nenan, amba God No Oise Kakaewa menan anu gure wakaumepiwa, mu inak kakaewa tautanain. ");
INSERT INTO dgz_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Amba sia, orup da piup puraput mega iravi tambun go inak mega mek wa koeamepi o wakaumepi, ame tave uoni inagewa! ");
INSERT INTO dgz_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Me garewa om dim da gapan inak mega sia une ta wat naseta? ");
INSERT INTO dgz_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Waenapan endiwa mu koerage amba God menan ya anuiwanum. Da da umamuna anupi amba nop nega menan umam den anupi ne, Kimani Vitana Apanewa, wam da amba, Mamana kakae guragut ganasewa mega warap anea mega potamu woup seniwa den sia tauapena gare umamumu anuin.” ");
INSERT INTO dgz_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Iesu sia wadiamon, “Ne tave di wa agiat imaivin. E da da mapa yoniana ya borit wai Kimani Vitana Apanewa amun nega den tauapena yawanegene amba borit wai.” ");
INSERT INTO dgz_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Wam nani yamu daiton uon tani Iesu God inap mup wapen menan apan Pita, Diemis ge gwaniwa Dion tambumo mugenat tunup da dot amon. Ap mepe Iesu etua ugup entanen yawane. ");
INSERT INTO dgz_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Wanup mega pomponu ganase wa tau aen. Waenapan wanup bigi gurine umap da om ya inen go mek pomponugaet iragen. ");
INSERT INTO dgz_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Yawane boge watageta apanewa Mosis ge Elaidia venat mutan Iesu den nop waiwanumune yawamon. ");
INSERT INTO dgz_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pita Iesu anega dien, “Ayop nugawa, nu ge den mapa wanin antoni menan ame kakae di. Menan pa namdat otu da yampo tumoit. Daiton gegawa da Mosis megawa da Elaidia megawa.” ");
INSERT INTO dgz_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Go Pita ge upine den tap baware anu gurane, menan me anu waramat gapan ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Irikup pomponu aigamup taue, waboboramon amba mu irikup potap wanumon. Nop da irikup potap anega tauen, “Ma ne Otun iragenawa, da ne menan anu gurinawa, me inap atonu anuivin. Nop mega anun!” ");
INSERT INTO dgz_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nop ap taueni boge Iesu wadiamot megawa ikukuk yawane go apan dere ame oak mutane amba Iesu megenat wanden yawan. ");
INSERT INTO dgz_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tunup gapan mu vit onam wanumune, Iesu no botakam mume anega wan, “Dim da venasen yawayana oisewa waenapan da ya wadiamone. Ne Kimani Vitana Apanewa bonigasep sia inak nigasepena evip amba wadiamon.” ");
INSERT INTO dgz_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Iesu nop ame wani wadiamot mega potamup boge wanden, go anega wawa mutan, “Me boe sia yon wandepi, tavewa anenen?” ");
INSERT INTO dgz_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Wadiamot mega singui anega wayawane, “Iwa dim men iup wadidianine nagirewa apan Elaidia namu tauat waiwanum?” ");
INSERT INTO dgz_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Iesu gare wadiamon, “Ne wapena anun. Elaidia gaseget namu tauen. Waenapan ire ya yawane menan koewa inap tat anune gapan di tane. Ame God nop mega namua gapan ap anega seane. Amba sia anega seane, Kimani Vitana Apanewa ta koeragam nimanegepi ugu vegaek bagu sisi anu tanain.” ");
INSERT INTO dgz_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Tunupa vit onamone gapan, iam iam da potap tauane. Wadiamot mega upi sia tautanamon. Ap mepe, waenapan iam baraen amba iup wadidiamuine nagirewa den arak maken wariwanumune yawamon. ");
INSERT INTO dgz_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Go waenapan iragi Iesu yawanewa imumu puk wan atonu den waupane. ");
INSERT INTO dgz_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ap menan Iesu singui wayawamon, “E dim da arage makene tanamoyan wariwanin?” ");
INSERT INTO dgz_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Waenapan berip apan da gare anega wani, “Wadianiana apanewa, airampu da otuna potap unugen wandia noa borasen menan genan wat ongen. ");
INSERT INTO dgz_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Airampu otuna waren pia ae toiwan amba orup gitutu nop tauiwan, no gitnagiwan, kaime i dat enun taiwan. Ne wadiamot gegawa airampu oirenapen men diamona go umamup uon. Wane go airampu tap ya tau aen.” ");
INSERT INTO dgz_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Iesu nop ame anuni garie den anega wadiamon, “Akae, koewa taiana nagirewa, ya anu tumat nimanek wanin. Ne wam animpo mini tanae wanigepen amba anu tumat tai? Orup ame wat onaen.” ");
INSERT INTO dgz_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Orup wat onamone airampu Iesu yave orup ware enu menawasen orup pia geare nikao makao tan gitutu nop tauen. ");
INSERT INTO dgz_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Iesu orup mamewa singui wayaven, “Otuga koewa mame wam ansena waren?” Me gare anega wan, “A, me orup otu wandeni gapan di waren. ");
INSERT INTO dgz_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Amba airampu orup ame waren oma yamewa ge kauma uarene togurep boepen menan wam arugataet ap anega di taiwandin. Aro ge inagap wandepiwa bagu sisi nunan anu ago di nun.” ");
INSERT INTO dgz_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Iesu gare wadien, “Dim men gego waingi? Anu tumat nimanegewa dim dim iravi tai.” ");
INSERT INTO dgz_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Iesu ame waniwa orup ame mamewa kaimakaet anega wan, “Ne anu tumat gimagivin. Go umap uon. Ago nena anu tumat nega baware tap.” ");
INSERT INTO dgz_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Waenapan aruga serarat toga uaren ta tauane, Iesu yawamoni me airampu kaimakaet anega dien, “Ge yauga no borat ge darine borat airampuewa, endi ne yam ta yawagen waian, tau ak, orup ma potap sia ya unuge.” ");
INSERT INTO dgz_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Airampu Iesu nop mega anuni ve baware wa orup ware enu menawase pia uat ene boge tau aen. Tau aeni orup pia boe bonigawa umap wanden waenapan uruga yawane anega wan, “Gase boen.” ");
INSERT INTO dgz_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Go Iesu orup nanip ware endaven ao yon wanden. ");
INSERT INTO dgz_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Amba Iesu pa gwane unuk aeni, wadiamot mega singui mugenat waiwanumun, “Iwa dim men nu airampu ame wa oitatoni go ya tau aen?” ");
INSERT INTO dgz_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Iesu gare wadiamon, “Iwa mam. Airampu ma miniwa mup aroewa megenat gapan tap taue aeta.” ");
INSERT INTO dgz_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","At ame ae ve at Galili tau amon. Iesu wadiamot mega wadidiamopen anuni menan karaua amon amba anega wadiam wandin, ");
INSERT INTO dgz_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","“Kimani Vitana Apanewa anavi waranege apan upi nanimu gwanap bat nimanegain. Mu ne toguranegep bonigasepena amba wam yampoa God aro mega gapan inak nigat sia yon waingain.” ");
INSERT INTO dgz_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Go Iesu bop tapi oisewa waiwandini, wadiamot mega nop iwa ya anu kakayasene, tap tan. Menan singui da sia ya wayawane. ");
INSERT INTO dgz_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ame amone, Iesu pa mega pa sewa Kaponiam gapan tauane. Amba Iesu wadiamot mega anega singui wayawamon, “Negin gagap dim da menan aigap waiwanian?” ");
INSERT INTO dgz_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Go wadiamot nagire orup ansena bawarewa tata, mu negin gagap nop ap waiwanumune menan Iesu singui wani umam anune menan garewa ya wane. ");
INSERT INTO dgz_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Iesu ap mepe ae wande wadiamot mega aonagaet pusinawan dere munan wan ine tauane anega wadiamon, “Da me yaumakayap bawarewa tat anupiwa me nao ega taini apanewa entanep!” ");
INSERT INTO dgz_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Amba Iesu orup otu da wan namumup yonen. Ame ware tainamup bare anega wan, ");
INSERT INTO dgz_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Waenapan da da orup otu ma umap nenan waupepi ne den waupanek wanum. Waupanegepi negenat ya waupanek wanum go Mamana watu enanegeniwa den waupiwanum.” ");
INSERT INTO dgz_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Apan Dion Iesu wadien, “Ayop nugawa, nu yawatoni apan da ge yauga gapan airampu wa oimuiwandin menan nu watanaton iwa me nu den ya inat nimanen.” ");
INSERT INTO dgz_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Go Iesu gare wadiamon, “Ae, ya watanane. Apan da amun nega gapan kiman paua da wa tapi ne ya wa koeragam nimanegeta. ");
INSERT INTO dgz_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Iwa orup da da anavi ega ya tapi mu evenae waiawa. ");
INSERT INTO dgz_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Amba waenapan da da kaum kasigawa e ne wa ewamot nega menan enepiwa, ne tave di wadiaivin, ne inap anu bambamat da uon, orup ame garewa mega kimani wareta.” ");
INSERT INTO dgz_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Go orup otu ma anu tumat nimanegini mini e anu tumat nimanegene go ta pariset apane koewa ta ewamopen menan naumo amopi, ap gapan ta pariset apane ame itan baware yaveta. Gwat itani dena megap pane puimani wat enep boepi ame umap di. ");
INSERT INTO dgz_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Menan ge nanigawa wat nauge ae koewa tapiwa, to ketnak aipa uat! Ap tom wapi gomunaet inak arewa ageawa ame kakae iwa ap ya tawa ge tawaga uruga yaibobot omae meravewa gapan uat enagain. ");
INSERT INTO dgz_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ge pusigawa wat nauge ae koewa tapiwa, to ketnak aipa uat! Ap tom wapi gomunaet inak arewa ageawa ame kakae iwa ap ya tawa ge tawaga uruga yaibobot omae meravewa gapan uat enagain. ");
INSERT INTO dgz_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Amba ge yamaga wat nauge ae koewa tapiwa, aoma wa totnak aipa uat! Ameme yamaga yamunaet inak arewa ageawa ame kakae iwa ap ya tawa ge tawaga uruga oma meravewa gapan uat enagain. ");
INSERT INTO dgz_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ap mepe mokare kaka waenapan wapimu pot pot di naiwanumain amba yaibobot meraovewa yagit mumiwandata. ");
INSERT INTO dgz_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ap mepe waenapan iragi oma yame yagimop God wanene mega gapan mu wawa sisi taiwanumain. ");
INSERT INTO dgz_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Amba siuran kakae di, go dansewa mega menawaet ni nen garepiwa, ap gapan e anenen tane amba dansewa sia wata? Menan siuran ek gamuyap di wande ep, ap mini baigan nonup gare gare ta aisiwanian.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Amba Iesu at Galili ae ve ae amba at ginewa Diudia kaum Diodan asepagan dotou aen. Ap mepe waenapan aruga me ine sia tauane menan Iesu namu taini umap sia God noa wadidiam wandin. ");
INSERT INTO dgz_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ian Parisi nagire upi ine tauan pusi warup tap Iesu nop ebo wapen menan singui wayawan, “Apan da waenewa tandayase ae vepiwa iup nuga paina yamaseta go?” ");
INSERT INTO dgz_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Iesu gare singui wayawamon, “Watageta apanewa Mosis iup namua baraeni anenen wan?” ");
INSERT INTO dgz_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Mu anega wane, “A, Mosis ok anega sen, Apan da waenewa ae veapen ogewa sepiwa gapan me, ok ame aroewa gapan, waenewa wa oisep aeta.” ");
INSERT INTO dgz_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Wane, Iesu sia anega wadiamon, “E imuya gware dena menan Mosis waen ae vemopen umap wan. ");
INSERT INTO dgz_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Go God ere mangan piup kiman tan venat mutane gapan, apan ge waen tamon. ");
INSERT INTO dgz_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","God ap anega tani menan apan ine mame vemo waen da naisepi gapan, ");
INSERT INTO dgz_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","mu dere tobot tap etumu daiton entaneta. Ap gapan mu mini mini wanumone go endi mu daiton. ");
INSERT INTO dgz_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ap menan God tobot tamoni gapan waenapan da seu ya enumop.” ");
INSERT INTO dgz_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Mu pa gwanap amone gapan, wadiamot megawa Iesu wani guegue wayawan. ");
INSERT INTO dgz_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Me gare anega wadiamon, “Apan da waenewa ae ve waen da ugup sia naisepiwa me togane tapatap tata. ");
INSERT INTO dgz_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ap umap sia, waen da memewa ae ve apan da ugup sia naisepiwa me togane tapatap tata.” ");
INSERT INTO dgz_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Amba, waenapan upi otu waiwa bawarewa amba amapewa den Iesu naniwa iamup seapen menan tambun tauane, go wadiamot megawa diguguramon watanamone. ");
INSERT INTO dgz_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Iesu ame yawamoni gapan gari yaven anega diamon, “Orup otua ae vemone, nenan onamop, ya watanamone, iwa God toemu mega orup otua ma miniwa mugawa. ");
INSERT INTO dgz_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ne tave di wadiaivin, e orup otu menawaet anu tumasine mini imuya yamu ya entanenewa, God toemu megawa ya tauai.” ");
INSERT INTO dgz_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ame wani boge orup otu bumagap ma tambu naniwa wapimup se wat aipakam mumen. ");
INSERT INTO dgz_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Negina ap aiwandini apan da serarat taue namup omanip enu singui wayaven, “Wadianet kakaewa, ne map anenen tap amba yaibobot inagewa yon borain?” ");
INSERT INTO dgz_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Iesu gare wan, “A, dimen ne apan kakaewa dianegingi? Orup kakaewa da uon go God megenat kakae. ");
INSERT INTO dgz_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ge God iup mega anuingi. Orup da ya togura boep. Wainan gogo ya taingan. Up ya taingan. Evenaga koewa da tani yawaana, ame ebo aopan ugup ya enu yawa waingan. Imuga nop koe koe ya anuingan. Amba inaga mamagawa ayamase ta muningan. Iup ap anega waiwan.” ");
INSERT INTO dgz_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Iesu wani apan ame sia wan, “Wadianek apanewa, ne orup otunap waingena gapan ne iup mame waran iravi ta ongingin endi mame tauen.” ");
INSERT INTO dgz_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Iesu apan ame yaveni imua pose inap waren anega wadien, “Ge daiton da ya taan. Age wan dim dim gegawa iragi ase une ta amba moni ame kwan purapuse uoni nagirewa mun. Amba ge kiman kakae guragut megawa aupa evi amba warai. Ap tawa amba ewanap onak.” ");
INSERT INTO dgz_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Apan ameme piup puraput mega inap arugataet menan Iesu wan anuni gine namu en kukutume bagu sisi anu aen. ");
INSERT INTO dgz_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Iesu waenapan ikukuk yawamoni wadiamot megawa anega wadiamon, “Puraput nagirewa God toemu mega unuk amopen ame inamup kaimakewa da di!” ");
INSERT INTO dgz_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ap anega wani gapan wadiamot megawa seke tane. Iesu sia wadiamon, “God toemu mega unuk amopen ame kaimakewa da di! ");
INSERT INTO dgz_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Man bawarewa da, kainok ninoke gapan unuk tau aepen tapi ame umap uon. Ap umap, kwan purapuse dena apane da God toemu mega unuk aepi ame den umap uon go kaimakewa mega aigap iragen.” ");
INSERT INTO dgz_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Wadiamot mega nop ame anune gop baware anun anega wane, “Akae, God toemu mega unugepen kaimakewa da di, ap menan inak ewakewa da ware kimani unugeta?” ");
INSERT INTO dgz_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Iesu kem kem yawamoni gare anega wan, “Waenapan muk ingane aro muga tainewa gapan ya unugain, go God inap kaimake den uon menan dim dim tat anuini mek di tata.” ");
INSERT INTO dgz_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Amba Pita Iesu anega wadien, “Ge anu. Nu dim dim nuga iragi ae veat evigap onanton. Garewa dim da warait?” ");
INSERT INTO dgz_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Iesu gare anega wan, “Nop nega mondi uon anun di waivin. Da da nenan anu gure amba God No Oise Kakaewa menan, pa o tase gwaniwa o domare waiwa o mame waiwa o ine waiwa o otu waiwa o nao mugawa, ae vemopi, ");
INSERT INTO dgz_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","mu garewa warain, ap omewa apane nani yamunaet mini aigap sia vemoinewa ame pa ge tase gwani o domare wai o ine wai o otu wai o nao mugawa warain. Amba mame gapan God nop mega anuyan taiana menan waenapan wawa koko inayap tain. Go inak eviwa tauepi gapan yaibobot inagewa warai. ");
INSERT INTO dgz_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Menan waenapan endi evi yonine nagirewa, wam ame gapan, namu yonain. Amba endi namu yonine nagirewa, wam ame gapan, evi yonain.” ");
INSERT INTO dgz_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ap mepe Iesu waenapan den tanam neginaet Ierusalem amuiwanumun. Iesu namu yone upam aiwandin. Wadiamot megawa anu waramat anune amba waenapan upi ta den amuiwanumun. Neginaet wadiamot mega aonagaet pusinawan dere tambu asira sensenui ae amba me inap dim dim venasepi oisewa anega wadidiam aiwandin, ");
INSERT INTO dgz_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Wapena anun. Nu pa Ierusalem dot anivin, amba Kimani Vitana Apanewa waranege amo pirisi bawarewa amba waenapan iup wadidiamuine mu nanimu gwanap bat nimanegain amba toguranegepen noa panain. Diu nagire waranege Diu uoni nagirewa nanimu gwanap bat nimanegain. ");
INSERT INTO dgz_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Diu uoni nagirewa nipep dianege wa koeragam nimanegain. Giton en ananege amba wagu gapan tonek wanumain. Amba toguranegep bonigatain go wam yampoa gapan inak nigat sia yon wanigain.” ");
INSERT INTO dgz_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Apan Sebedi otu wai Diemis ge Dion Iesu ine tauan anega wadian, “Wadianiana apanewa, nu bagu sisi nuga menan mup inagap wata di ta nunai go?” ");
INSERT INTO dgz_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Wane Iesu singui wayawamon, “Endi ne dim da da ta enat anuiwanin?” ");
INSERT INTO dgz_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","“A, yauga baware tap toemu gega kakae guragut den waingewa nu orup ansena da wa, da mainaga nutup gapan amba da wa senip gapan ae waninet, gapan nu den bawarewa tat.” ");
INSERT INTO dgz_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Wane go Iesu gare wadiamon, “E dim da da asik ya tayan amba mup waiwanin. Ne bagu sisi kaumewa napena e den nai go? Ne itan ugu vegaek anu tanapena e den tanai go?” ");
INSERT INTO dgz_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Mu gare anega wane, “E, nu den warait.” Iesu sia wadiamon, “Tave di e nai, amba ne itan ugu vegaek anu tanapena e den tanai. ");
INSERT INTO dgz_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Go at mame muna muna Mamana tata kakayat ta muneni nagirewa mugawa.” ");
INSERT INTO dgz_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Iesu wadiamot mega aonagaeta nagirewa, mup mame oisewa anune gapan tase gwani derewa inamup ugu gangan mutan. ");
INSERT INTO dgz_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Go Iesu munan wan tauane anega wadiamon, “E asigiap, ian ugupe nagirewa bawarewa muga aro muga gapan itan muniwanum amba mu aroewa ap warane menan aton taiwanumun. ");
INSERT INTO dgz_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Go e ap anega ya tane, da me yaumakayap bawarewa tat anupiwa, me nao ega taini apanewa entanep. ");
INSERT INTO dgz_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Amba da me namu yonat anupiwa, me nao ayamat enan tap. ");
INSERT INTO dgz_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ap umap sia, Kimani Vitana Apanewa piup nagirewa ta warit imaepen tauan, e ta warit nimanegepen ya tauan. Menan bop tapena waenapan koewa muga garewa mega iravi warain.” ");
INSERT INTO dgz_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Iesu wa ewamot mega tanamo pa Dieriko ae ve aiwandini, to iam baware da me ewap den amuiwanumun. Apan yame boraseni apanewa da, ap mepe negin etop, ae wande moni menan mup waiwandin. Apan ame yaua Batimias, Timias otua. ");
INSERT INTO dgz_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Batimias Iesu pa Nasaret apanewa oniwandini oisewa anuni menan nop kaimakaet no ainagase senao anega wan, “Iesu watageta apane Devit naewa, bagu sisi nenan anu!” ");
INSERT INTO dgz_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Waenapan aruga anega diguran, “Nop ae ve,” go me uma sia anega wan, “Apan Devit naewa, bagu sisi nenan anu.” ");
INSERT INTO dgz_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Iesu ae yone anega wadiamon, “Wane onep.” Mu ase amon yame boraseni apanewa wadian, “Imuga potaga aro tap. Ao yon, Iesu genan waiwan.” ");
INSERT INTO dgz_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Apan Batimias tumarim yon wande, wanup wa totnak aipa uarene Iesu ine tauen. ");
INSERT INTO dgz_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Iesu singui wayaven, “Ne inagap dim da tat anuingi?” Apan ame gare anega wan, “Ayop, ne yangut tat anuivin.” ");
INSERT INTO dgz_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","“A, umap, ganawan ak. Ge anu tumat nimanegean menan inak gitaan.” Iesu ame wani, no utap apan ame yamewa ase watapen yangut ta neginaet Iesu ewap aen. ");
INSERT INTO dgz_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Iesu pa sewa dere, yaumua Betpadi ge Betani, maniwandiniwa sewa da ap mepe tunup yaua Oma Olip Yanane Tunupewa wakiap tauen. Ap mepe wadiamot dere watu enamo ");
INSERT INTO dgz_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","anega diamon, “Pa sewa namunup utapa ame aisen tauanewa, use tauan man donki otua da damiga taune yawai. Man ame gagap namu orup da ya amone. En vetan, wat onaen, mapa tauan. ");
INSERT INTO dgz_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Apan da anega wayawaepi, ‘E dim da taiwanin,’ e gare manega wadian, ‘Ayop nuga man donki menan wan tauaton amba gagap ae tauepi boge menawaet mapa sia watu eneta.’” ");
INSERT INTO dgz_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Iesu ap wani wadiamot mega amon man donki otua negin tonan ginap damiga taune yawan kwip vetan. ");
INSERT INTO dgz_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Vetane mondigawa nagirewa singui wayawamon, “Man otua dimen wat vesiwanin?” ");
INSERT INTO dgz_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Iesu namu wadiamoni nop ap sia wadiamone boge man warapen menan umap wan ame di wat amon. ");
INSERT INTO dgz_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Mu boge waran amon Iesu inewa tauan, amba wanup aigape muga da waran man donki gagap aoma baraene amba Iesu wat agoasene man donki ame gagap wanden. ");
INSERT INTO dgz_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Waenapan wanup mega aigape gaun wanapen men negina memegamene aen, amba Iesu taue gagap aen. Amba waenapan upi oma bae kaime den negin etop guran negina yogune gagap aen. ");
INSERT INTO dgz_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","To iam baware ame namup onam wanumune amba evip onam wanumune den nomu ainagasen anega waiwanumun, “Kaewa kaewa, gaun baware inagap, God wat aipakamini Ayopewa, God yaua gapan tauiagi! ");
INSERT INTO dgz_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nu omayan baewa Devit amun mega sia waraan tauiagi God wat aipakam gimagia. God paina wandiniwa yaua ao warivin,” ap anega waiwanumun. ");
INSERT INTO dgz_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Iesu pa Ierusalem taue God Paewa unuk ae dim dim iravi ikukuk yao nau aen. Mum gine taueni menan wadiamot mega aonagaet pusinawan dere tautanamo sia pa Betani amon. ");
INSERT INTO dgz_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Inane woup seni, pa Betiriem ae vean amon pa Betani tau amuiwanumune gapan Iesu enup aren. ");
INSERT INTO dgz_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Amba negin etop asirantu oma baip da yaven, me ae iap taueni, tavewa da ya yaven, go baewa megenat. Iwa makewa inini wamewa ya tauen. ");
INSERT INTO dgz_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Boge me oma ame anega dien, “Ge tavewa gega da waenapan sia ya nain!” Ap anega wani wadiamot megawa anune. ");
INSERT INTO dgz_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Pa Ierusalem tauane boge Iesu God Paewa unuk aen. Ap mepe, wan dim dim muga gare gare une taiwanumune nagirewa gut oimon tau amone. Moni entan wantan taiwanumune watarewa me aie yamu tanamon amba watat gapan mu nenip bairantan une taiwanumunewa den baime uatamen. ");
INSERT INTO dgz_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Amba waenapan God Paewa gwanap dim dim tam onam wanumat anune Iesu watanamon. ");
INSERT INTO dgz_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Amba me anega diamon, “God nop mega ok ap anega seane, Ne pa nega, waenapan ne inanap mup waine paewa. Ok anega sean. Go e tayan up nagire pa muga karauawa mini entanen!” ");
INSERT INTO dgz_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Pirisi bawarewa ge iup wadidiamuine nagirewa den Iesu tani oisewa ap anune menan mu anenen ta togurapen noa barim wanumun. Go mu waenapan tamu anun iwa Iesu wadidiam wandini tarage waiwanumun. ");
INSERT INTO dgz_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Boge mum gine gapan Iesu amba wadiamot mega den pa sewa Ierusalem ae ve amon. ");
INSERT INTO dgz_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Inane woup seni mumaget Iesu wadiamot mega sia onamon amba baip ine tauane ame visiwa gapan kurat wa dore wae inen yawan. ");
INSERT INTO dgz_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Wam ap Iesu anen wani Pita anu ase anega dien, “Tatan, oma ata yao! Wata diaana wae ine boen!” ");
INSERT INTO dgz_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Pita ap wani Iesu gare wan, “God inap anu tumasen. ");
INSERT INTO dgz_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ne tave di wadiaivin, e anu tumat ega wandepiwa amba anu bambam ya tanewa, amba tunup inap anega wane, ‘Ao yon asepa puimani geak,’ ap anega diane ame di tata. ");
INSERT INTO dgz_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ap menan dim da menan anun mup God inap wanewa, namu gase warayana mini anu tumat tan, amba mup wanewa di eneta. ");
INSERT INTO dgz_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ao yona God inap mup waingawa gapan waenapan da koewa inagap tapi, ge koewa mega anu ae veawa, ge Mamaga kimaniwa koewa gega anu ae veta. ");
INSERT INTO dgz_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Go waenapan da koewa muga anu ae ya veawa, ge Mamaga kimaniwa koewa gega anu ae ya veta.” ");
INSERT INTO dgz_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Amba pa Ierusalem sia tauan. Iesu God Paewa gwanap ap yone iwandini gapan pirisi bawarewa ge waenapan namu yoyo muga nagire den ine tauan ");
INSERT INTO dgz_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","anega wayawan, “Ge amun ansena da waran gapan dim dim mame taingi? Amun mame, da genen?” ");
INSERT INTO dgz_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Iesu gare wadiamon, “Ne singui nega daiton den, namu wayawain gare wadianegenewa amba da aro neneni gapan taina ame wadiain. ");
INSERT INTO dgz_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Singui nega mam, Apan Dion dup iamuiwandiniwa ame amun mega aupa kimani ware taiwandin go, gare mapa piupa waenapan upi inamup ware taiwandin?” ");
INSERT INTO dgz_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Mu iragi nop waran yaumakamup seyao wareyao muk inga ingane tan amba anega wan, “Endi nu kiman amun mega ware taiwandat wata, me anega dianeta, ‘E dimen Dion nop mega ya anu tumasiwanin?’ ");
INSERT INTO dgz_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Go nu endi anega watawa, ‘Amun waenapan inamup ware taiwandin,’ waenapan ma iragi gwara toguguranain iwa mu anune Dion me God watu eneni apanewa.” ");
INSERT INTO dgz_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ap anega anuiwanumune menan Iesu singui mega garewa anega wadian, “Dion amun ame wareni arewa nu oare.” Menan Iesu anega diamon, “Ap menan ne den amun nega amba waran gapan ugup ugup ma taina oisewa ya wadiain.” ");
INSERT INTO dgz_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Iesu maibe noa anega wadiamon, “Maibe da sia wapena anun. Apan da taba gureip naewa vere sin ikukuk taun. Ni vetnagepen urasewa waren. Gopat tapen men dagurak paina tun. Egak mega kwayup tapen nagire munan wan tauane amat tapen men diamo amba me at da ugup aen. ");
INSERT INTO dgz_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Maup wamewa taueni nao mega taini da maup semua tam onepen menan kwayup taine nagire inamup watu enen. ");
INSERT INTO dgz_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Egak taueni gapan kwayup taine nagirewa waran toin en mondi watu enane aen. ");
INSERT INTO dgz_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","I apanewa nao mega taini da ugup sia watu enen ae taueni mu waran inamu tosisitnagen umam no mini tain en veane aen. ");
INSERT INTO dgz_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nao taini apane da sia watu eneni togurane boen. Ap umap upi aruga sia watu enamuiwandin go kwayup taine nagirewa yonan upi siget muniwanumune, upi gurane borit waiwanumun.” ");
INSERT INTO dgz_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Amba nao i apanewa me otua daiton iragenawa megenat wandeni ame otua imua inap di wareniwa. Menan ui iragenawa, me otua inamup watu ene anega anun, ‘Mu ne otuna viripewa tain.’ ");
INSERT INTO dgz_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Go otua inamup taueni kwayup taine nagire paina yawan muk ase ma anega wawa mutan, ‘Piup i apane otua oniwan. Apan mam iman egak ma yon boreta, menan anet togurat boep, amba egak mame boge nu yon borat.’ ");
INSERT INTO dgz_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Menan waran sin garip uat enan togurane boen. ");
INSERT INTO dgz_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ap menan wam ame nao i apanewa tauepi nao nagirewa inamup anenen tata? Tauepi, nao kwayup taine nagire gut momak mumeta amba egak mega waenapan upi munep kwayup tain.” ");
INSERT INTO dgz_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Iesu ayop nagire sia wadiamon, “God nop mega ok seane e batnagean. Ok ame ap anega waiwan, Agim ame pa tuine nagirewa tandayasen, koerage dian, go God agim ame ware entanen amba pa tuine danewa venasen. ");
INSERT INTO dgz_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ayop mame kakae di tani menan nu tarage waivin. Ok ap anega sean.” ");
INSERT INTO dgz_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Iesu ap wani Diu bawarewa nagirewa asigimup, Iesu gutut ame mu koewa muga menan waiwandin. Ap menan me warapen anune go waenapan tamu anune menan Iesu ae vean amon. ");
INSERT INTO dgz_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ian Parisi nagirewa amba Erodian nagirewa den, Iesu anenen i wabambamasepen menan nopewa panan. Menan wadiamot muga upi, Iesu ine watu enamone. ");
INSERT INTO dgz_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Tauane anega wayawan, “Wadianet nugawa, nu asiginup ge waenapan muk anen wane taine ame menan ge imuga potaga ya wariniwa, go ge nop tavewa gapan God dim dim anuini om ap gapan tainampen neginewa wadianianawa. Menan nu singui nuga mam. At Rom ayopewa Sisa nu moni se wanata ame gapan nu Mosis iup mega paina yamatait go uon?” ");
INSERT INTO dgz_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Go mu nanamaset wan taiwanumune Iesu me asigip tan, menan me anega wan, “E dimen wayawanek wanin? Endi moni gwat make da wat ewanegene yawap.” ");
INSERT INTO dgz_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Mu gwat make da wat onamone. Iesu singui wayawamon, “Yawan, moni ame gamup da yaua o guewa wandia?” Mu gare anega wan, “Ame ayop Sisa guewa mega gamup wandia.” ");
INSERT INTO dgz_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Menan Iesu anega wan, “Ap menan, wan dim dim Sisa mega wandepi ame Sisa di wanapen. God mega wandepi, ame God di wanapen.” Nop ap anega gare wani menan mu no i kap wane. ");
INSERT INTO dgz_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Dugup Sadusi nagire, upi Iesu inap tauan. Mu dugup anu tumat muga gapan waenapan manega wadidiam wanumun, “Borit wata sia ya inak nitait.” ");
INSERT INTO dgz_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Menan Iesu inap singui anega wayawan, “Wadianet nugawa, watageta apane Mosis nunan iup anega sen, ‘Apan da otu uon boepi gapan me gwaniwa kwapura mega ame naise, tasewa uewa orup se wanep.’ ");
INSERT INTO dgz_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Endi apan upi tatap gwanip yananewa nanin yamunaet yamunewa dere mugenat wanumon. Namu bonewa mugawa waen naiseni go me otu uon boen. ");
INSERT INTO dgz_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Menan gwaniwa ewap yaneni, tasewa kwapuraewa sia naisen. Gwaniwa orup da ya baraeni amba sia boen. Gwaniwa yampoa kwapura ame sia naisen amba ap umap sia tan. ");
INSERT INTO dgz_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ap anega ta amo wanumune dugup daiton apan nani yamu dere waen ap daiton naitan go iragi otu uon borit wane. Amba uiwa waen ame den boen. ");
INSERT INTO dgz_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ap menan waenapan upi anega anu tumat taiwanum, borit wane nagirewa sia inak muse yon wanumoin go endi apan nanin yamunaet yamune dere waen ame naitanewa wam uiwa gapan waenapan inak muse sia yon wanumopi waen ame apan ansenawa waenewa?” ");
INSERT INTO dgz_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Iesu Sadusi nagirewa gare wadiamon, “E aopan waiwanin iwa e ok seane asik ya tayan amba God aro amun mega den e oare. ");
INSERT INTO dgz_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Go waenapan borit wane evi amba sia yon wanumopi inak yaibobot eviwa gapan mu gare gare ya naine mutain den ore wai naine mutapen menan ya munain. Iwa mu anea umap kiman gapan wanumoin menan mu gare gare ya naine mutain. ");
INSERT INTO dgz_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Inak muta muta nagirewa gueguewa ame God wataget wat arogamen. E, Sadusi nagirewa, namu batnageana go ya anuyan ame wataget wam da Mosis ap aiwandini oma ut yagit wandin yaveni God anega wadien, ‘Omae baewa Eibaraam, otua Aisik, amba upewa Diekap, mu God muga daiton ame ne di.’ ");
INSERT INTO dgz_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ap gapan endi nu asiginup ame waenapan kabaniwa ge borit wanewa mu God yamap iravi kabani wanumamun, iwa mu guamu den. Menan e nop ame aopan di waiwanin.” Iesu ap anega wadiamon. ");
INSERT INTO dgz_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Sadusi nagirewa notatae gare gare waiwanumune waenapan iup wadidiamuini apane da yawamuiwandin. Mu singui wane, Iesu garewa kakaevet wadiamon anuni menan apan ame Iesu singui anega wayaven, “God iup mega ansena aigap iragenawa?” ");
INSERT INTO dgz_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ap wani Iesu gare wadien, “Iup aigap iragenawa ame. Isurero nagirewa, anun. Ayop God nugawa me megenat Ayop di. ");
INSERT INTO dgz_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Amba ayop gega God, imuga potaga gapan, guaga gapan, epara guin pakao gega gapan, iak guine gapan, ae anu gura imuga warep. ");
INSERT INTO dgz_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Iup derewa ap umap sia manega. Gek genan ae anu guriana mini, evenak waiga pa mainagape wanumuine nagirewa munan den ae anu gura imuga warep. Iup dere mame aigamup aigap iragenawa da den uon.” ");
INSERT INTO dgz_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Wani iup wadidiamuini apanewa Iesu sia wadien, “Wadianek negawa, nop gega tavewa di. Ayop nuga God me megenat God di tavewa daiton me megenat, me mainep God da den uon. Ge tavewa di waiagi. ");
INSERT INTO dgz_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Amba ayop nuga God, imunu potanu gapan, guanu gapan, epara guin pakao nuga gapan, ian guine gapan, ae anu gurat imunu warep amba nuk nunan ae anu gurintoni mini, evenanu wainu pa mainanupe wanumuine nagirewa munan den anu gurinampen. Iup dere ameme baware iragen. Waenapan God men man irepi o garewa da ugup wanepi guegue ame gauarap go iup dere mame aigap iragen.” ");
INSERT INTO dgz_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Apan ame anut mega baware gapan wani Iesu anu gare anega wadien, “God toemu mega tonanewa nop yoningi, wandap uon.” Iesu ap wani boge waenapan tap tan singui da sia ya wayawane. ");
INSERT INTO dgz_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Iesu God Paewa gwanap waenapan wadidiam wandini gapan singui anega wayawamon, “Iup wadidiaine nagirewa dim men anega waiwanumune, ‘God wa watu eneni Mesaya me watageta apane Devit naewa?’ ");
INSERT INTO dgz_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Wataget amba di God Guewa Woup Seniwa apan Devit aro waneni gapan Devit Mesaya evi amba me denip mega gapan tauapen menan anega wan, God yone Ayop nega Mesaya anega wadien, ‘Nanina nutup arigewa gapan ae wanigingan, ne anavi gega tambumopen aro gega gauarap wanumoin.’ God nop mega Devit ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Nop ma gapan, Devit yone Mesaya inap me Ayop diwandin go Devit namu yaneni apanewa amba Mesaya evi yanen. Menan Mesaya ame Devit naewa megenat uon go aigapewa di.” Iesu ap anega wani, waenapan atonu den anun. ");
INSERT INTO dgz_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Iesu waenapan manega wadidiamon, “God iup mega wadidiaine nagirewa munan ae yao kakayasen amba yon iwanian. Ian ame mondi yonane wanup kakae guragut enane, waenapan ase yawamopen menan apan apan tainewa, amba taba une taine arewa gapan amopi waenapan gaun munat anuiwanum. ");
INSERT INTO dgz_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Amba den Diu opata waine paewa o barip gagewa gapan watat kakae iragena gagap wanumot anuiwanum. ");
INSERT INTO dgz_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Go mu waen kwapura kaimakaet enu yawamon wane gapan kwapura puraput ge pa mugawa den tambune. Ap tane go mup paewa gapan waenapan yamamup muk ingane tap kakae tapen menan, God inap mup wa nonongaminewa. Koewa ap tainewa menan wanene muga koevet taine nagirewa wanene mugawa ame aigamup taueta.” ");
INSERT INTO dgz_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Iesu Ierusalem God Paewa gwanap wandeni gapan waenapan God menan moni garaet enine arewa gapan eniwanumune yawamon. Puraput nagirewa moni aruga eniwanumune. ");
INSERT INTO dgz_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Den me yaveni inak daiton yaven kwapura koentu da taue moni mega dendeniwa dere otu uiwa ame enen. Moni ame baware uon. ");
INSERT INTO dgz_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Iesu wadiamot mega munan wan tauane anega wadiamon, “Ne tave di waivin e anun, kwapura koentua ma yan mega tani arita, kwan puraput nagirewa yan muga tane gauarap. ");
INSERT INTO dgz_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Iwa mu yan tanewa bondan muga omewa anun gapan tan. Go waen kwapura koentu mame kayawan tainiwa, evi ware na iniwanda wanda iragi yan taitamen.” ");
INSERT INTO dgz_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Iesu Ierusalem God Paewa gapan tau aeni wadiamot mega da Iesu anega dien, “Wadianiana apanewa, pa baware ase yao gwat gapan tune kakae di tumone!” ");
INSERT INTO dgz_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Go Iesu gare anega wadiamon, “E pa mame iragi yaviana menan nop nega anun. Wamewa da tauepi gapan anavi ega taue pa ma iragi to bebenak ae seain, gwat da daiton didi batamene sia diriga aita ya wanumoin.” ");
INSERT INTO dgz_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Wam ame evip, Iesu Oma Olip Yanane Tunupewa gapan wandeni, wa ewamot mega, apan Pita ge Diemis ge Dion ge Anduru inap tauan wam ame paua anupen menan karaua singui wayawan, ");
INSERT INTO dgz_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Wan dim dim arita mame andi amba venasiwandata? Amba wam verisiwa amba ge sia tauapen wamewa taiwandapina, paua mega dim dim da namu taue aiwandapina yavinain?” ");
INSERT INTO dgz_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Iesu gare wadiamon, “Agun anun waenapan da da aopan wababayan imaepi tawa. ");
INSERT INTO dgz_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","E yao kakayat amba wanien, da aopan wababayan imaepi tawa. Waenapan iman arugataet taue, amba anega waiwanumain, ‘Ne Keriso,’ amba arugataet ebo ewayain. ");
INSERT INTO dgz_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ita anan tapi oisewa anui amba ita anan tapen tapi oisewa anui go tap ya anune. Ita anan ame iravi di taiwanumain go wam verisiwa ya taueta. ");
INSERT INTO dgz_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ita anan agagae taue aiwandapina yawanewa, ame tap ya anu gurane. Wankakau ge puinunu amba inak aru ap mini namu venase di tau aeta, go wam uiwa ap mepe ya taueta. Go mame iragi itan bagu sisi erewa da. ");
INSERT INTO dgz_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ek ingane kwayup ta aisiwanian. E ne dugup nega nagirewa menan, wanene taepen menan ayop bawarewa nagirewa ugup ugup namup tam nauyae amoin. Mame gapan, oitana wadidiamone Diu uon ian ugupe nagirewa den anupen menan. ");
INSERT INTO dgz_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","God toemu mega No Oise Kakaewa at at iragi piup ma gapan wadidiam wanumampena amba wam verisiwa taueta. ");
INSERT INTO dgz_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Go wam ame e tambuepiwa, dim da wawa menan gop ya anune. Iwa wam ame nop wapen tanewa God nop dim da enep di wai. Iwa nop ega da uon, go e Mamaya Guewa nop e gamuyap waiwandata. ");
INSERT INTO dgz_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ap wamewa gapan, tase gwani gare gare omine wap borit wain, amba ine mame muk orup mugawa omine wain, amba otu waiwa ugu gangan ine mame inamup tain, ap tapi gapan upi taue ine mame guramo boniga semoin. ");
INSERT INTO dgz_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Waenapan iragi nenan tandayat imayain, go e da da nenan tumban amun ae yonanewa, wam verisiwa gapan e inak warai.” Iesu ap anega wadiamon. ");
INSERT INTO dgz_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Nop mame batnagine nagire batnagepi anu kakayasep. Apan da pa Ierusalem God Paewa wabigimepen menan guewa koewa iragen da wat taue endavep yawai. Ap yawanewa gapan, e at Diudia gapan wanienawa tap serarat aise tunupa dot aitai. ");
INSERT INTO dgz_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Amba apan da pa aigarip wandepi puraput mega warapen menan pa gwane ya aep, wam wakaumepi tawa menan tap aep. ");
INSERT INTO dgz_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Amba orup da egaga wandepi me wanup mega menan ewagai sia pa ya aep. ");
INSERT INTO dgz_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Wam ame inepi wamewa, kaiwan, waen bagu dena o orup otu ine amape nagirewa inamup kaimake den! ");
INSERT INTO dgz_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Tap aise aise bodu wamewa gapan mame iravi ya venasepen menan God inap mup waiwanian. ");
INSERT INTO dgz_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Iwa wam ame gapan ita anan bagu sisi baware iragen taueta, erewa gapan ma onin en endi mame tauini gapan ap mini da ya venasen, amba inak ap mini da sia ya venaseta. ");
INSERT INTO dgz_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Menan wam ame God ya wat oninkamepo, waenapan iragi borit waitamepo, go om enumoni nagirewa mugenat munan wam ame wat oninkamen. ");
INSERT INTO dgz_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Wam ame gapan waenapan da anega wapi, ‘Yawan, Keriso ma tauen’ o ‘Atapa tauen,’ da ya di anu tumasene. ");
INSERT INTO dgz_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Iwa Keriso eboewa amba God noa tave uoni waine nagirewa taue yo paua aigap taiwanumain. God om enumoni nagirewa aopan wababayan mumapen taiwanumain. ");
INSERT INTO dgz_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Menan agun anun. Dim dim iravi evi tauepi oisewa namu wadidiaen.” ");
INSERT INTO dgz_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Iesu sia wadiamon, “Ita anan bagu sisi baware wamewa ame uon tapi ame wam pumpuni ta, sisip taueta, amba siragam ganase sia ya wata. ");
INSERT INTO dgz_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Buanae kimani aoma geamoin, amba kiman aroewa iravi erere goyago amoin. ");
INSERT INTO dgz_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Wam ame tauepi ne Kimani Vitana Apanewa amun baware kakae guragut ganasewa nega den irikup nokap vitapena yawanegain. ");
INSERT INTO dgz_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Amba anea nega watu enamopen, waenapan negawa piup etoa asiwa iragi wa upamoin.” ");
INSERT INTO dgz_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Oma baip guegue mega yawane gapan anun. Gua ewake topi yao anui, bodu wamewa konintu taiwan. ");
INSERT INTO dgz_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ap umap sia, e wan dim dim mame tau aiwandapinawa, e anega anui, ne konintu tonana yonivin. ");
INSERT INTO dgz_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ne nop tavewa wadiaepen anun. Endi mame piupa yanane wanumamune nagirewa, wam muga gapan wan dim dim mame venat taue aep amba borit wain. ");
INSERT INTO dgz_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Piup ge kiman iman ise wat museta, go ne nop negawa di wande aiwandata.” ");
INSERT INTO dgz_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Iesu sia wadiamon, “Ne sia tauapena wamewa, orup da daiton asigip ya di tan, anea kimaniwa den oare amba ne den oare, go Mamana kimaniwa megenat asigip tan. ");
INSERT INTO dgz_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ap menan nene yamam taiwanian, iwa e oare wam ansena Ayop ega taueta. ");
INSERT INTO dgz_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Guegue da manega wain. Apan da pa ae ve daio aepi waenapan mega nao muga muga muneta amba tonan kwayup taini apanewa gopat tapen men die aeta. ");
INSERT INTO dgz_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Tonan kwayupe taini apanewa ap umap e nene yamam tan. Pa i apanewa wam ansena entan sia tauepi e oare. Mum gine o mum gagewa o woup sese o mumaget wam ansena tauepi e oare. ");
INSERT INTO dgz_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Aup boniga ya inane iwa me taue yawaepi tawa menan nene yamam taiwanian. ");
INSERT INTO dgz_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Dim da inayap wana waenapan iragi den wadiamuivin. Nene yamam tan.” ");
INSERT INTO dgz_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ap mepe Paina Yamaseni Baripewa ge Taba Buredi Ya Tutut Waine Baripewa wam dere namumup wanden. Wam ame gapan pirisi bawarewa ge iup wadidiamuine nagirewa den, mu anenen ta amba Iesu karaua ware togurapen neginewa noa panan waiwanumun. ");
INSERT INTO dgz_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Mu anega wan, “Barip wamewa gapan Iesu ya warait iwa waenapan ita anan tapi tawa.” ");
INSERT INTO dgz_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Amba Iesu pa Betani gapan apan Saimon vek bo’o namu ware kakae tani apanewa pa mega gwanap wanden. Ame gapan waen da oma osewa da pokarik gapan enane, ame ware tauen, me tutua aigap iragen amba garewa mega arita iragen. Amba pokarik to dume Iesu iap damagen. ");
INSERT INTO dgz_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Iap wa damageni gapan ap mepe wanumune nagirewa upi ugu gangan tane menan noyam anega wane, “Iwa dimen kaum ame danamiwan? ");
INSERT INTO dgz_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Oma ose tutu den mame une ta moni arugataet (300 aigap) wara amba waenapan purapuse uoni kayakayawan taine nagirewa munapen.” Mu waen ame inap ugu gangan tan kaimakaet wane. ");
INSERT INTO dgz_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Mu dim da wane Iesu imua gapan anuni menan gare anega wadiamon, “Waen ma ae veane anut mega gapan di taiwandan. Waen mame dim da inanap tani iwa den gapan di taiwan amba yaunewa mega kakae iragen. ");
INSERT INTO dgz_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","E iman kayakayawan taine nagire den nimakamup tanam waniai, menan munat anune di munan. Go pot pot ne ya tananege waniai. ");
INSERT INTO dgz_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Iman bonigasepen tunegepi menan me oma ose tutu dena mame tasi di seneniwan. ");
INSERT INTO dgz_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ne tave di wadiaivin, ambagan da God No Oise Kakaewa ma piup iragi gapan wadidiamopi, waen mame dim da tani oisewa anupen menan wadidiam wanumain.” ");
INSERT INTO dgz_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Amba wadiamot mega aonagaet pusinawan dere da yaua Diudes Iskeriot. Me pirisi bawarewa inamup Iesu omine wapen menan aen. ");
INSERT INTO dgz_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Taueni mu aton anun moni garewa wanapen wa agiasen. Wam ap gapan Diudes arok da ware Iesu yan tapen menan amase taiwandin. ");
INSERT INTO dgz_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Barip yaua Taba Buredi Ya Tutut Waine Baripewa tugupen wamewa tauen. Wam ame gapan Paina Yamaseni baripewa guturewa taine menan waenapan man sip otua tambun guramone borit wan. Menan Iesu wadiamot megawa ine tauan anega wayawan, “At ansena gapan nu ane tata kakayat tat barip nugawa mame nat anuingi?” ");
INSERT INTO dgz_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Iesu pusi panamo anega wan, “Wapena anun. Aisen pa sewa ame tauan, apan da kaum undan wat aepi tautanan amba evip aisen, pa da dorepi den doran. ");
INSERT INTO dgz_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Pa i apane anega wadian, Wadianini apanewa anega wan, ‘Ne pa gwane ansena ange wadiamot nega den Paina Yamaseni Baripewa nait?’ ");
INSERT INTO dgz_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Apan ame, pa gwane aigapewa baware da ame gapan watat iravi gaset tata kakayat tane amena ewaeta. Ap mepe taba wat iran.” ");
INSERT INTO dgz_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ap anega wani menan, mu amon pa tauan amba Iesu wani no usewa gapan yao ge yao di amon. Amba pa ap me gapan Paina Yamaseni tabaewa, ap mepe wat iran. ");
INSERT INTO dgz_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Wam ame mum gine taueni, Iesu wa ewamot mega aonagaet pusinawan dere tanamo taba napen menan ae wanumon. ");
INSERT INTO dgz_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Taba naiwanumune Iesu anega wan, “Ne tavewa di wadiaivin, e daiton da ominana wapen taiwanin.” ");
INSERT INTO dgz_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ap anune gapan mu bagu sisi baware di anun amba nop me inap daiton daiton singui wan, “Ayop, nenan waingi go?” ");
INSERT INTO dgz_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ap wane Iesu gare wadiamon, “Apan ame aonagaet pusinawan dere apane da yogup daiton taba dere nata apanewa ominana wata. ");
INSERT INTO dgz_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","God negin mega, Kimani Vitana Apanewa gase wat neneni ap omewa gapan bonigatain, go kaiwan, ominana wapi apanewa itan baware yaveta!” ");
INSERT INTO dgz_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Taba naiwanumune gapan Iesu taba buredi semua ware God inap gaun wa, wa paise wa ewamot mega mune, amba anega wan, “Tambun nan. Mame etunawa.” ");
INSERT INTO dgz_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Amba sip ware God inap gaun wani munen iragi at nugut tan. ");
INSERT INTO dgz_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Amba anega wan, “Kaum wain mame deninawa. Bonigasepena denip mame tau visepi gapan waenapan aruga koewa muga wat museta. Ne denina gapan God e waenapan mega agi ewakewa wa agiat imaeta. ");
INSERT INTO dgz_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Wapena anun. Kaum wain mame ne sia ya nain go Mamana God toemu mega tauepi wamewa gapan e den tanae sia nain.” ");
INSERT INTO dgz_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Wam ame God inap mu wak da wane boge mu tunup Olip dot amon. ");
INSERT INTO dgz_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Boge Iesu anega wadiamon, “Endi mum mame gapan e iragi ae venek tap aitai, iwa wataget ok map anega seane, Ne man sip kwayup taini i apanewa topena, man sip mega punanan wat amoin. Ok ap anega sean. ");
INSERT INTO dgz_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Go ne bonigasep amba inak nigat yon waingepena ne at Galili gapan namu tauain e evi amba tauai.” ");
INSERT INTO dgz_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ap wani Pita Iesu anega dien, “Mu iragi tap ae vege amoin, go genan ne tap ya angain.” ");
INSERT INTO dgz_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Pita ap wani go Iesu gare wadien, “Pita, ne wapena anu. Endi ge wam koni yampoa gapan waboboranegewa amba kumkum wam koni dere nop wata.” ");
INSERT INTO dgz_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pita kaimakaet sia anega wan, “Ae, ge bop tawa ne den di bonigatain, ne ya waboboragain.” Amba wa ewamot upinewa ap anega nomanagaet wane. ");
INSERT INTO dgz_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Amba Iesu wa ewamot mega den at yaua Getsemani amon, amba me anega diamon, “Mapa wanien, ne asirantu angep God inap mup wap.” ");
INSERT INTO dgz_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ame wani Pita ge Diemis ge Dion tanam asirantu amon, amba me bagu sisi anu taneni gapan bumage tuk wan. ");
INSERT INTO dgz_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Boge Pita evene wai dere den anega diamon, “Ne bagu sisi aritavet anu tanan ap gapan bumagana vege waiwan. Mapa ne den tananegen wanien nene yamam taiwanian.” ");
INSERT INTO dgz_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Ap anega wani amba asirantu aen, amba me gine namu pia ae to kutnage mup anega wan, “Maman, ge aro dim dim tat anuana di tai, menan ge men anu gurawa, ugu vegaek anupena ao waseanek, go mame ne anut negawa uon go gek anuiana gapan di ta.” ");
INSERT INTO dgz_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Boge me entane ae wa ewamot mega inamu taue aup iniwanumune yawamon. Menan Pita inap anega wan, “E da wam airase daitona mini ne den tananege nene yamam ya tai? ");
INSERT INTO dgz_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Nene yamam tan, God inap mup wan, iwa pusi warup da inayap tauepi tawa. Iwa guanu epara tat anuiwan go etunu itani waiwan.” ");
INSERT INTO dgz_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Menan ae vemo ae mup koni yampoa uap sia tan. ");
INSERT INTO dgz_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Wam ame, me sia entan taueni, mu aup iniwanumune yawamoni mu yamamu itani wan. Mu seke tane nop gare da wa wa uon. ");
INSERT INTO dgz_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Boge entane wa ewamot mega inamup taue anega wadiamon, “E aup inin kakayat din taiwanin? Yawan, wam nega onen di mananiwan, amba Kimani Vitana Apanewa waranege koewa taine nagirewa nanimup bat nimanegain. ");
INSERT INTO dgz_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ao yonane anepen! Yawan, ominana wani apane mame tauia!” ");
INSERT INTO dgz_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Iesu nop ame waiwandini gapan, apan Diudes wa ewamot mega aonagaet pusinawan derewa apane da tauen. Pirisi bawarewa ge waenapan dimae waine nagirewa amba iup wadidiamuine nagirewa den, waenapan aruga watu enamone ita gaut tambun tauane. ");
INSERT INTO dgz_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Diudes, omin wani apanewa paua ta ewamopen menan namu waenapan anega wadiamon, “Apan ame gaune tap ua topenawa, ap me di waran.” ");
INSERT INTO dgz_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Tauane boge Diudes Iesu ine taue anega wan, “Wadianet nugawa, baigan ge inagap wandep.” Ap anega wani boge ua ton. ");
INSERT INTO dgz_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ua toni ewap ita nagirewa Iesu kaimakaet wat natane. ");
INSERT INTO dgz_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ame gapan, da den yoneni apanewa kereba mega ware, amba pirisi bawarewa ayop mugawa nao mega apanewa da darinewa to kuasen. ");
INSERT INTO dgz_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Iesu apan aruga tauane ame singui wayawamon, “Endi, ne up apanewa mini waranegepen menan ita gaut den tam tauayan? ");
INSERT INTO dgz_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ne wam, wam God Paewa gapan wanigingina ya waranegean go endi waranegepen menan tauayan. Endi waranegeana God nop mega gapan oitana ok seane tavewa tauapen men taiwanin.” ");
INSERT INTO dgz_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Boge Iesu wa ewamot mega iragi ae vean tap amon. ");
INSERT INTO dgz_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Orup tamaru da Iesu ewap aiwandini ame wanup kakae da viri viri wareni, ap gapan ita nagirewa den warapen tane ");
INSERT INTO dgz_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","go wanup mega wa totnagene ni aroga tap aen. ");
INSERT INTO dgz_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Amba Iesu kaimakaet waran nau pirisi ayop mugawa pa mega amon. Pa mega gapan waenapan iup wadidiamuine ge dimae waine nagirewa den iamen wanumon. ");
INSERT INTO dgz_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Go Pita wandap isipa evi oniwandin amba Pirisi ayop mugawa pa mega nimakap arok da gapan tauen. Gwanap unuk aeni ame ita gopare taine nagire tanam wande irot menan oma tugun iram wanumun. ");
INSERT INTO dgz_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pa gwanap, pirisi bawarewa ge kansoro nagirewa uruga Iesu inap nop eboewa yoa tan nau amo togurep boepen menan taiwanumun. ");
INSERT INTO dgz_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Apan aruga yonan ebo imup waiwanumune go Iesu ebo mega da ya tautanan. ");
INSERT INTO dgz_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Uiwa gapan upi yonan ebo imup anega wane, ");
INSERT INTO dgz_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Apan ma namu da anega wani, ‘Ne God Paewa wabenagep amba wam yampo gwanap negenat sia tu waborain.’” ");
INSERT INTO dgz_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Go nop mame waiwanumune gapan, tavewa mini da uon. ");
INSERT INTO dgz_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Boge pirisi bawarewa da ao yone Iesu anega wayaven, “Ge nop muga waine garewa wai go uon? Mu oitaga waine ge anenen anuingi?” ");
INSERT INTO dgz_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Go Iesu no uon wanden. Pirisi bawarewa mugawa me inap anega wan, “Ge God mega wa watu enageni Keriso go uon? Ge God Kakae iragenawa Otua go uon?” ");
INSERT INTO dgz_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Iesu gare anega wan, “E, ne ap me di. Go ne wapena anun. Wam evi amba da, Kimani Vitana Apanewa God Aro Iragenawa mainewa nutup gapan ae waingepena amba irikup gagap sia tauapena yawanegai.” ");
INSERT INTO dgz_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Boge pirisi bawarewa wanup mega wabebenage anega wan, “Me God inap wawa koko taiwan! Iwa dim men koewa mega upine yoa tait? ");
INSERT INTO dgz_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Me God inap wawa koko taini e gase anuyan. Menan e dim da anuiwanin?” Mu gare anega wan, “Me koewa mega garewa menan di boep.” ");
INSERT INTO dgz_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Boge mu gine namu gitona en anan toiwanumun. Upi gine namu pan boran tuiwanumune ame nipep anega wan, “Ge God Keriso mega waingewa imugap anu wa, da togen.” Boge ita nagirewa Iesu waran amon den to popounagene. ");
INSERT INTO dgz_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ap mepe, Pita pa nimankewa arok da gapan ae wandeni amba nao taine waenewa da tauen. ");
INSERT INTO dgz_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pita oma irasiwandini gapan waen ame Pita kem kem yave anega wan, “Ge Iesu at Nasaret apanewa tautana ingiana apanewa da.” ");
INSERT INTO dgz_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Go me iragi namumup wabobore anega wan, “Ge dim da waingiana ne oare.” Ap wani boge ae tonan nop wandeni kumkum nop wan. ");
INSERT INTO dgz_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ap mepe nao taini waenewa ame sia Pita yave waenapan anega diamon, “Apan ase Iesu den iwandini apanewa da.” ");
INSERT INTO dgz_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Go Pita sia wabobore anega wan, “Uon, ne uon!” Wam koni otu da ewap, waenapan upi Pita anega sia dian, “Ge Iesu apan mega da di iwa ge den at Galili apanewa!” ");
INSERT INTO dgz_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pita kaimakaet sia anega diamon, “Ne ebo wapena amba God ugu gangan mega yawap. Apan ame men waiana ne oare!” ");
INSERT INTO dgz_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ap wani boge kumkum koni derewa wan. Iesu Pita nop namu anenen dieni boge anu aven, ame, “Ge wam yampo waboboranegai amba kumkum nop koni derewa wata.” Ame gapan Pita irip koevet wan. ");
INSERT INTO dgz_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Woup sen pirisi bawarewa ge iup wadidiamuine amba dima waine kansoro nagirewa den, iravi Iesu inap anenen tapi menan wawa mutan. Mu waran pan nau amon piup Rom ayopewa Pailat wanan. ");
INSERT INTO dgz_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pailat Iesu singui wayaven, “Ge Diu nagirewa Ayop mugawa go?” Iesu gare wan, “E, ge ap me di waiagi.” ");
INSERT INTO dgz_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Amba pirisi bawarewa enu yawan wan. ");
INSERT INTO dgz_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Apan Pailat Iesu sia wayaven, “Mu nop aru ma enu yawagene waine gare da wai go uon?” ");
INSERT INTO dgz_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Iesu no uon wandeni menan Pailat imua upese anun. ");
INSERT INTO dgz_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Diu nagirewa gutut muga en en taine ame Paina Yamaseni Baripewa gagap, piup ayopewa, gwat noke apane da waenapan om enu wapi gapan wat vesine tauen ainiwa. ");
INSERT INTO dgz_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Wataget apan upi bawarewa nagirewa inamup ita anan tane menan bawarewa nagire gare aian gwat noke sean. Wam ame gapan, dayakam taini apane da, yaua Barabas, gwat nokap baraene wande en. ");
INSERT INTO dgz_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Menan, wam ame barip aigap, waenapan Pailat inap gwat noke orup da wat vesep tau aepen menan tauane. ");
INSERT INTO dgz_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Menan Pailat singui anega wayawamon, “E Diu nagire Ayop egawa Iesu enan ne wat vetapen tau aet anuiwanin go?” ");
INSERT INTO dgz_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailat singui ame wayawamoni iwa imup anuni Diu nagire ayop mugawa Iesu anu koeamene menan wat onamon wanane. ");
INSERT INTO dgz_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Go pirisi bawarewa waenapan wa datnak mumane menan Barabas wat vesep tau aepen wane. ");
INSERT INTO dgz_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pailat sia wayawamon, “Iesu e Diu nagire Ayop egawa waiana inap ne dim da tain?” ");
INSERT INTO dgz_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Mu kaimakaet anega wane, “Oma korosi gapan to endawane boep.” ");
INSERT INTO dgz_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pailat gare wan, “Iwa dimen boeta? Me koewa dim da tan?” Go waenapan nop kaimakaet aigap sia waiwanumun, “Korosi gapan boep!” ");
INSERT INTO dgz_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pailat waenapan aton anupen menan umap wan amba gwat noke apanewa Barabas wat vesen tau aen. Amba ita nagirewa diamone mu Iesu waran gaut gapan tone amba oma korosi gapan togurapen men wat nau amon. ");
INSERT INTO dgz_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Amba piup ayopewa ita mega nagirewa Iesu waran apan bawarewa pa mega gwanap amon. Ita nagirewa iravi ap mepe wanumone munan wan Iesu namup tauan. ");
INSERT INTO dgz_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Wanup mega waseasen ayop wanupe buinip pan wanan amba ipuni wagam waran iap tonat wanan. ");
INSERT INTO dgz_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Amba Iesu inap nipep anega wan, “Kaewa kaewa, Diu nagire ayop mugawa!” ");
INSERT INTO dgz_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Mu gitona en anan amba gaut da waran iap tone. Me namup omanip enun nipep den wa atonasen. ");
INSERT INTO dgz_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Mu nipep diane ewap, wanup buinip pan wanane ame wabutunagen amba wanup mega sia pan wanan. Boge mu oma korosi gapan togurapen menan wat nau amon. ");
INSERT INTO dgz_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Wam ame gapan Saimon at Sairini apanewa at da gapan oniwandin. Me Aleksanda ge Rupas mamamua. Ita nagirewa Iesu oma korosi mega wat aepen menan nanamasen wane. ");
INSERT INTO dgz_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Amone at yaua Apan I Kaime Arewa (Iburu nop muga gapan Golugata diane) ap tauane. ");
INSERT INTO dgz_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ap mepe mu Iesu wapiwa vege ya anupen menan kaum wain oma baewa sisi dena den gotonak en wanane go me yamaet yave ae ven. ");
INSERT INTO dgz_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ita nagirewa Iesu oma korosi gapan to endawanewa amba mu wanup mega yan seapen menan kae otu da tan. ");
INSERT INTO dgz_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mumaget wam nani yamu degede wareni Iesu korosi gapan tobatamen. ");
INSERT INTO dgz_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Enu yawan wane ogewa oma ginap tobatamen endawane ok anega seane, “Ma Diu Nagirewa Ayop Mugawa.” ");
INSERT INTO dgz_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Wam ame gapan up apane dere den oma korosi gapan gut batamene da Iesu naniwa nutup gapan amba dawa senip gapan dawamon. ");
INSERT INTO dgz_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Wataget God nop mega ok seane tavewa tauen, Waenapan anega wan, Iesu koewa nagirewa den enam wanden. ");
INSERT INTO dgz_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Waenapan tau ise amo tau use amo taiwanumune nagirewa no peromen Iesu inap nipep anega waiwanumune, “Yauapo, ge God Paewa tobenage amba wam yampo gwanap sia tut waana apanewa, ");
INSERT INTO dgz_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","menan gek ingane inagit, oma ae ve vit onak!” ");
INSERT INTO dgz_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ame umap sia pirisi bawarewa amba waenapan iup wadidiamuine ge dimae waine nagirewa den nipep anega wane, “Me upi inak muniwan, go mek ingane inak ya wareta! ");
INSERT INTO dgz_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Me Isurero Ayop nugawa go? Oma ae ve visepi gapan nu yawat amba me inap anu tumatait.” Ap uap sia, up apane den gut batam mumane ap anega nipep den me inap wane. ");
INSERT INTO dgz_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Wam ianupe wariwandini gapan, piup ame iravi mum tatarin tunu taue aeni amba wam airase yampoa waren. ");
INSERT INTO dgz_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Wam airase yampoa wareni gapan Iesu nop uma ve anega wan, “Eli, eli, lama sabak tani.” Ap anega wani guegue, “God negawa, God negawa, ge dimen ae venek agi?” ");
INSERT INTO dgz_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Wam ame gapan, waenapan upi ap mepe yoniwanumune nagirewa nop ame wan anune, mu anega wan, “Me apan Elaidia vene waiwan.” ");
INSERT INTO dgz_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Amba apan muga da serarat ae kaum warupini wanupewa waren. Kaum sisi dena gapan ae antapene gerok ginap enu Iesu megewa pakaraeni men napen wanen. Apan ame anega wan, “Mapa amat tait, anse, apan Elaidia taue korosi gapan wat viseta go uon yawapen menan!” ");
INSERT INTO dgz_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Iesu ve baware sia wani boge guewa tau aen boen. ");
INSERT INTO dgz_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ap wamewa gapan God Paewa gwanap wanup God wandini arewa tonan pan boriniwa aoma bebep wa vise ase ma wanden dere entanen. ");
INSERT INTO dgz_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ita yamewa apanewa Iesu korosi mega namup yone Iesu anenen boeni ase yaveni menan me anega wan, “Tavewa di, apan ma God Otua.” ");
INSERT INTO dgz_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Waen upi den paina yonan yaviwanumun. Yaumakamup waen Meri Makdalin ge Salomi ge Meri, apan Dioses amba evip yaneniwa apan Diemis dere inamua. ");
INSERT INTO dgz_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Wataget Iesu at Galili gapan wandeni waen ameme ewap amon kwayup taiwanumun. Evi pa Ierusalem dot aeni gapan waen ameme, amba upi den ewap dot onamon. ");
INSERT INTO dgz_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Imana wagat wamewa menan taba endi bongamen tunun. Wam ame mum gine, ");
INSERT INTO dgz_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","apan Diosep at Arimatia apanewa me Diu nagire kansoro muga da ame taue kansoro upine inap ayamat tainewa. God toemu mega amunewa inamup tauapen menan den amat taiwandin. Me epara ta apan Pailat ine ae Iesu etua menan mup wan. ");
INSERT INTO dgz_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pailat Iesu gase boeni oisewa anuni me no kap wan. Menan ita yamewa menan wan taueni singui wayaven, “Iesu gase boen go uon?” ");
INSERT INTO dgz_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","“E, me gase boen,” ap anega wadieni menan Pailat Iesu etua Diosep wanat wan. ");
INSERT INTO dgz_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Diosep wanup kakae ewake da nononga pepeku une tani gapan etua wa totnak wat vise wanup gapan viri viri ware amba dagup da gwat gapan kaitane gwanap baraen. Baraeni gwat pepeta baware da wabaim onamon tonan toboran. ");
INSERT INTO dgz_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Iesu etua baraene arewa waen Meri Makdalin ge Meri apan Dioses inewa yawan asigip tane. ");
INSERT INTO dgz_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Diu nagirewa wagat muga wamewa uon tani Meri Makdalin ge Salomi ge Meri apan Diemis inewa kaum ose tutu dena une tan Iesu etua enu iat anun. ");
INSERT INTO dgz_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Menan wam pura bawarewa wamewa gapan woup seni mumaget iragen dagup yawapen amon. ");
INSERT INTO dgz_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ame amone, negina muk anega wawa mutan, “Dagup tonanewa gwat da wabaim nuneta?” ");
INSERT INTO dgz_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Wane iwa gwat ame baware iragen. Tauan yawane gwat, gase wabaiman ase baraene yawan. ");
INSERT INTO dgz_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Dagup gwanap unuk amone, ap mepe apan tamaru da yawane, wanup mega pomponu nononga pane amba at mainewa nutup gapan ae wanden. Yawane tap kaimamu doren. ");
INSERT INTO dgz_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Apan ame anega wadiamon, “Baguya ya arep. Iesu at Nasaret apanewa oma korosi gapan togurane boen baraene yawapen tauayan. Baraene arewa yawan. Inakae sia yon wanden mapa ya wandia. ");
INSERT INTO dgz_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Menan menawaet di aisen amba wa ewamot mega, apan Pita den, wadiamon. Me at Galili gapan namu taueta e evi amba tauai. Ap mepe namu wadiaeni arewa gapan wandep yawai,” ap anega wadiamon. ");
INSERT INTO dgz_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Waen ame dagup ae veane nene yangwane den serarat amon. Waenapan da ya wadiamone iwa mu tap anune. ");
INSERT INTO dgz_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Pura bawarewa gapan woup sese Iesu bop gapan yon wandeni ewap, me namu Meri Makdalin inap venasen. Wataget waen ame airampu nani yamu dere potap unumone Iesu wa oimon tau amon. ");
INSERT INTO dgz_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Boge waen ame Iesu yaveni oisewa ae Iesu evene wai den tanamon ini ame wanumon bagu sisi anun irip turup waiwanumune taue wadiamon. ");
INSERT INTO dgz_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Waen ame Iesu inakae sia yon wanden yaveni oisewa wani mu ya anu tumasene. ");
INSERT INTO dgz_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ap me ewap, Iesu wadiamot mega apan dere ap pua amuiwanumune gapan Iesu gine namu ugup ta inamup tauen. ");
INSERT INTO dgz_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Taue sia aeni apan dere ameme pa Ierusalem entane sia amon wadiamot upinewa wadiamon go mu ya anu tumat muman. ");
INSERT INTO dgz_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Iesu uiwa megawa, apan mega aonagaet pusinawan daiton taba naiwanumune nimakamup ase venasen. Bop gapan sia yon wandeni waenapan da da yawane amba wadiamot mega wadiamone go imumu gware wan amba anu tumat ya tane menan Iesu upe diguguramon. ");
INSERT INTO dgz_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Amba me wadiamon, “Piup ginewa at at iragi aisen, waenapan Oitana Kakaewa wadidiamon. ");
INSERT INTO dgz_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Waenapan da da anu tumasep dup iamopi God inak ewakewa muneta. Go ya anu tumasepi God nemoro mega yawain. ");
INSERT INTO dgz_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Waenapan ne anu tumat nimanegepi gapan paua mame den ta amoin. Amun nega gapan airampu wa oimop tau amoin. Merimu tobayanep nop ewakewa ian ugupe nagirewa waine mini wain. ");
INSERT INTO dgz_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Mokare warepi ya aramota amba iapa da napi ya borit wain. Nanimu vek nagire wapip sepi inak mutain.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ayop Iesu nop mame wadiamon uon tani ewap God aro mega gapan kiman dot ae God mainewa nutup gapan ae wanden. ");
INSERT INTO dgz_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Boge wadiamot mega tauan at at asiwa donewa iragi amon, Nop Oit Kakaewa waenapan wadiamone. Mu opata wadidiamone gapan Ayop muga aro mega munen ap menan kiman paua ugup ugup den taiwanumune. Paua ugup ugup yawane menan waenapan mu opata muga anu tumasen. ");
INSERT INTO dgz_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ae, apan nega Tiopilas, gaun nega inagap waian. God waenapan nimakanup ugup ugup taiwandini no oise seapen men waenapan arugataet tayao wareyao tanau amuiwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ok ame seanewa, mu Iesu den tanan erewa gapan mu iwanumune den yaviwanumune amba no oise waiwanumune nagirewa, inamup nu anutoni ame seane, da ugup ya seane. ");
INSERT INTO dgz_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ap menan, Iesu guturewa ere ibariwa gapan, ameme ne ae yao anu kakayasepen men anu guran taingina. Ap menan, ayop nega Tiopilas, kakaewa ameme, nop oit ame se genat anuna. ");
INSERT INTO dgz_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Iwa, nop oit ame gapan, ge asigip tagep, ame nop anenen anuana, ame nop tavewa di, menan ok mame sivin. ");
INSERT INTO dgz_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Wam da, apan Erot at Diudia ayop muga ta wandeni wamewa gapan, ap mepe Diu pirisi apan da yaua Sekaraya wanden. Me dugup Abaidia apanewa. Me waenewa, yaua Ilisabet, mu dere pirisi nave taine dugupewa naewa. ");
INSERT INTO dgz_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Apan Sekaraya waenewa Ilisabet dere mu kakaevet ta amuiwanumune iwa mu God iup mega iravi ayamase tainewa. ");
INSERT INTO dgz_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Mu dere otu uon irak mutane, iwa Ilisabet orup da ya wara wara mini. Mu en nononga otu uon wanumoin en aeta guramon. ");
INSERT INTO dgz_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Wam da, Sekaraya dugup mega nagirewa nao semon taiwanumune, menan me pirisi nao muga God men tainewa ame taiwandin. ");
INSERT INTO dgz_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Menan, dugup mega guegue muga gapan, apan Sekaraya om enun wane God Paewa unuk ae tutu dena omaewa iu iriwandapen dien. ");
INSERT INTO dgz_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ame oma tutu dena iu God Paewa gwanap irapen wam airasewa ame taueni menan waenapan iragi tauan God Paewa sin panane gwanap, iamen, God inap mup taiwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Wam ame gapan, Sekaraya God Paewa gwanap wandeni, oma tutu dena iu irine watarewa mainewa nutup gapan God anea mega da ap mepe ase venase yoniwandin. ");
INSERT INTO dgz_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Apan Sekaraya anea use yaveni, me imua puk wan tap ase anu guren. ");
INSERT INTO dgz_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Go anea anega wadien, “Sekaraya, tap ya ta. God inap mup waingiana anu gimagiwandin. Menan waenaga Ilisabet iman orup apan bat geneta, ame ge yaua Dion diai. ");
INSERT INTO dgz_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Me yanepi ge aton anui amba imuga potaga tarep wareta, amba den waenapan aruga daramumu wata! ");
INSERT INTO dgz_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Iwa orup ame God yamap bawarewa tata kaum wain go kaimake dena kaumewa upi ya nata. Orup ame inewa potap wandeni wamewa gapan God Guewa Woup Seniwa imu pose no dotoueta. ");
INSERT INTO dgz_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Me at Isurero nagire aruga Ayop muga God inap imumu wat entan mumeta. ");
INSERT INTO dgz_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Watageta apane Elaidia aro amun mega ap umap Dion wa taiwandata. Waenapan wadiamopi gapan mame waiwa entane otu waiwa munan sia onamoin. Amba God tandayasine nagirewa entane kakaewa nagire ewap amoin. Ap anega tapi gapan waenapan iragi bongam bongam ta Ayop sia tauapen menan amasewa ta wanumoin.” ");
INSERT INTO dgz_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Amba Apan Sekaraya anea singui wayaven, “Otuna oisewa wadianegiana tavewa di wandepi ne anenen ta amba asigip tain? Ne waenana dere aeta guranen.” ");
INSERT INTO dgz_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Anea gare anega wan, “Ne Gebero, God namup yonina apanewa, ame God watu enanegen, nop oit kakaewa mame wadiagepen ongen. ");
INSERT INTO dgz_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Wapena anu. Nop nega evi amba tavewa di tauepi noa ya anu tumaseana menan nok borasep wanigai, otuga yanepi amba nop sia wai.” Anea ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Koni ap gapan, waenapan iragi Sekaraya menan pa garip amat wanumon anu bambam taiwanumun, iwa di menan Sekaraya pa gwanap nononga wandia. ");
INSERT INTO dgz_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Wanumone, Sekaraya pa garip ma taue oneniwa, nop wapen tani umap uon no borasen. Ap menan waenapan anega anun pa gwanap paua da utupa yaven. Me nop wawa umap uon menan naniwa gapan guegue ta ewamuiwandin. ");
INSERT INTO dgz_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Me God nave taitameni amba pa mega aen ");
INSERT INTO dgz_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Mame ewap, Sekaraya waenewa Ilisabet bagup tani. Ap menan, siragam nani yamunaet pa mainan bore wanden. ");
INSERT INTO dgz_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ap gapan Ilisabet mek anega wan, “God bagu sisi nenan anu ago neneni iwa ne orup ya seana menan umam nega waenapan yamamup wat musen.” ");
INSERT INTO dgz_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ilisabet bagup tani siragam mega nani yamu daitonawa gapan God anea mega Gebero watu enen at Galili pa yaua Nasaret tauen. ");
INSERT INTO dgz_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ap mepe waenoro ini denawa, yaua Meri, iniwandin. Apan Diosep, watageta apane Devit naewa, ganganasen. ");
INSERT INTO dgz_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Anea ame waenoro inap taue anega wan, “Nonup inagap wandep. God ge inagap wandia amba wat aipakam gimaginiwa.” ");
INSERT INTO dgz_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Go Meri nop ame anuni bagua aguren, iwa anea nop wani ase anu bambamase anega anuni, gaun ma tavewa dim da. ");
INSERT INTO dgz_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Anea sia wadien, “Meri, baguga ya arep, iwa God garaet mega inagap tauen. ");
INSERT INTO dgz_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nop ma ae anu! Ge iman bagup tai orup apan barewa amba yaua Iesu diai. ");
INSERT INTO dgz_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Otuga Ayop bawarewa tata, yaua dawa God Paina Iragena Otua diaine. Amba God, omae baewa apan Devit ayop tani umap, God Iesu ware apan Devit watat mega gagap barep ayop ta wandeta. ");
INSERT INTO dgz_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Menan Iesu, apan Diekap naewa megawa, ayop mugawa wande aiwandata amba Iesu toemu mega no ya utu taeta.” ");
INSERT INTO dgz_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Gare Meri anea ase anega dieni, “Ne waenoro wanik anginawa, inak arita mame inanap anenen venaseta?” ");
INSERT INTO dgz_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Anea gare anega wan, “God Guewa Woup Seniwa inagap taueta, God amun mega to umageta. Ap gapan digumin tai amba otuga yanepiwa God Otua, posewa woup seni apanewa diain. ");
INSERT INTO dgz_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Wapena anu. Ge asigigap dugup gega waenewa Ilisabet, aeta ton go me bagup tan. Waenapan otu uon iragaet diane go endi me bagup tan wandini siragam mega nani yamunaet yamu daiton. ");
INSERT INTO dgz_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Iwa God inap kaimake den uon, me aroe amunu den, dim dim wapi venaseta.” ");
INSERT INTO dgz_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Meri anuni sia wan, “Umap. Ne Ayop ayamat mega taina waenewa, menan ge anenen dianegeana inanap di venaseta.” Meri ap wani amba anea ae ve aen. ");
INSERT INTO dgz_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Wam ame gapan Meri menawaet yon wandeni boge tunup arige, at Diudia gapan, pa da ap mepe aen. ");
INSERT INTO dgz_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ame taueni, apan Sekaraya pa mega unugeni amba Ilisabet gaune tan. ");
INSERT INTO dgz_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ilisabet Meri gaun mega anuni gapan Ilisabet orup potapewa vitagen doragen tan anun. Ap tani Ilisabet imu pose iragi God Guewa Woup Seniwa bararaen. ");
INSERT INTO dgz_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Menan Ilisabet Meri inap kaimakaet anega wan, “God wat aipakam mega inanup viseni gapan wat aipakam aigapewa ge waraan. Amba orup barewa den wat aipakameta!” ");
INSERT INTO dgz_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Den Meri inap anega wani, “Ne kakae uon go Ayop nega inewa yawanegepen tauaana menan ne aton anuivin. ");
INSERT INTO dgz_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ame menan ne gaun gega anuna gapan otuna bagunape atonu den vitagen doragen tan. ");
INSERT INTO dgz_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","God genan ta wadiageni tavewa tauepi ge anu tumaseana menan wat aipakam gimagen.” ");
INSERT INTO dgz_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Boge Meri God menan anega wan, “Imuna gapan God wa taragasivin. ");
INSERT INTO dgz_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","God wat inakam nimanegeniwa menan inap atonua anuivin. ");
INSERT INTO dgz_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Iwa, ne me nao mega waenewa, ne umap uon, go me anu nimanegen. Wam endiwa mame use aeniwa gapan, waenapan iragi anega dianegain, ‘Ge God wat aipakam gimageni waenewa.’ ");
INSERT INTO dgz_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Iwa God aro amun apanewa aigap iragenawa, inanap ugup ugup tani menan. Tavewa di, me yaua woup am sen. ");
INSERT INTO dgz_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Naewa naewa yan aiwandata, iravi God inap anu gure wa taragase ta amuiwanumampina, menan mu bagu sisi muga anuiwandata. ");
INSERT INTO dgz_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Me amun mega waenapan wa ewamon. Apan apan muk ingane wat wane taine nagirewa, me gut marimeta. ");
INSERT INTO dgz_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Amba den piup namu yoyo taine nagirewa yaumu aoma waren, go kayakayawan taine nagirewa yaumu ao waren. ");
INSERT INTO dgz_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Enup aramuine nagirewa wan dim dim kakaewa munen, amba puraput dena nagirewa mondi up oimon amon. ");
INSERT INTO dgz_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Me nao nagire mega, ian Isurero ago munen. Me imu ya oaraen go wat agoat nimanen. ");
INSERT INTO dgz_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ap menan nu, omayan baewa Eibaraam, ge naewa naewa mega wande aeniwa den, nunan bagu sisi anu wa agiat nimaneni, endi mame tauen.” ");
INSERT INTO dgz_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Menan Meri Ilisabet tane ap mepe iniwanumune siragam yampo uon tani amba entane pa mega sia aen. ");
INSERT INTO dgz_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ilisabet orup bare bare wamewa taueni me orup apan baraen. ");
INSERT INTO dgz_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Pa nagire, dugup mega den, yaneni oisewa anune tautanan aton tan, iwa Ayop Ilisabet menan anu gureni gapan, inak kakaewa ame ta waneni menan. ");
INSERT INTO dgz_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Orup ame ae yane wandeni, wam nani yamu yampoa uon tani, orup apan ame mu waran etua tum tap God dugup mega entanepen menan amon. Mu orup ame wagup mamewa yaua Sekaraya diat wane. ");
INSERT INTO dgz_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Go inewa anega wadiamon, “Uon, orup ma yaua Dion diapen.” ");
INSERT INTO dgz_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Waenapan yonan anega wane, “Ame anenen? Ge dugup gega gapan wagup da ap anega uon.” ");
INSERT INTO dgz_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Sekaraya no borasen wandeni menan waenapan paua ta ewasene, dim wagup da wadiamopen menan tane. ");
INSERT INTO dgz_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Menan orup yaua sea sea onaewa menan wan. Mu wat wanane amba kem kem yaviwanumune. Apan Sekaraya ok anega sen, “Me yaua Dion.” Seni waenapan ok mega yawane no i kap wan. ");
INSERT INTO dgz_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ok seni boge Sekaraya noa borat wandeni nop wan. Meriwa itani wani bem wan boge nop ere God wa atonasen. ");
INSERT INTO dgz_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Pa nagire ap yawane menan tap gop anu gurane seke tan. Ap gapan ian Diudia, tunupa wanumuine nagirewa, inak mame oisewa anune menan nopewa panan wane. ");
INSERT INTO dgz_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Amba waenapan inak mame oisewa anunewa, anu waramat tan manega waiwanumun, “Orup ma kai warepi anenen taiwandata?” iwa mu anune Ayop God aro amun mega orup inap wandia. ");
INSERT INTO dgz_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Boge God Guewa Woup Seniwa, Sekaraya potap taue aro amun waneni gapan wam eviwa noa namu anega wan, ");
INSERT INTO dgz_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Nu Isurero nagirewa ayop nuga God wa atonasivin. Inanup taue vetanen. ");
INSERT INTO dgz_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Watageta apanewa Devit, me God nave tainiwa, dugup mega gamup wat inakam nimanini apanewa, da inanup watu enen. ");
INSERT INTO dgz_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Watageta God no oise waiwanumune, imu pose woup am seni nagirewa, dim evi tapi oisewa anega wan, ");
INSERT INTO dgz_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","‘Anavi nuga amba anu koeam nimanine nagirewa, aro amun muga gapan vetaneta.’ ");
INSERT INTO dgz_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Anega taiwandapina, nu omayan baewa wataget munan bagu sisi anuni menan, wa agiat mumeni ame imu ya oaraen. ");
INSERT INTO dgz_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","God nu omayan baewa Eibaraam inap anega wa agiasen, ");
INSERT INTO dgz_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","‘Anavi ega aro amun muga gapan vetaepenawa, ame gapan e nao nega tai, ap gapan tap da ya anune.’ ");
INSERT INTO dgz_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ame gapan, nu wam wam pot pot imunu woup am sep, ge kakae guragut God namup yonat, inat wainet nuga gapan tainampen. ");
INSERT INTO dgz_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","77","Sekaraya God nop mega ame wani sia orup Dion anega dien, Otunawa, God ge God Paina Iragenawa, nop mega waingawa, otua diageta. God waenapan megawa koewa muga anu ae vepen, inak ewakewa munapen neginewa wadiamuingai. Ap taingawa gapan Ayop nuga neginewa namu waringapina, me amba taueta. ");
INSERT INTO dgz_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","God nugawa bagu sisi nunan anuiwan, kaimakaet ya dianeta. Menan wam ganat mega ewa enuini mini, God om enuni apanewa, inanup taueta. ");
INSERT INTO dgz_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ap wamewa gapan waenapan sisipu inine nagirewa, amba bop tawa taine nagirewa ganat nuneta. Amba baigan negine gapan tam naune aeta.” ");
INSERT INTO dgz_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Orup mega Dion Guewa aro waniwandini gapan kai ware doriwandin. Isurero nagirewa ere wadidiamopen men at kaimewa gapan iniwandin eni amba aroga tauen. ");
INSERT INTO dgz_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Wam ame gapan, ayop bawarewa Sisa Ogastas, toemu mega at Rom gapan, nop baraen, waenapan iragi batnak mumapen, yaumu buka aritawa gapan enapen menan wan. ");
INSERT INTO dgz_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Apan Kwirinias at Siria ayope taiwandini ap wamewa gapan namu batnak mumiwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ap menan, waenapan iragi pa sewa muga muga iragenawa amon. Yaumu buka aritawa gwanap enapen amon. ");
INSERT INTO dgz_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Menan, apan Diosep den yon wande pa sewa Nasaret, at Galili gapan ae ve amba pa sewa mega iragenawa Betiriem, at Diudia gapan, dot aen. Iwa Diosep watageta apane Devit dugup mega naewa, amba watageta apanewa Devit pa sewa Betiriem gapan yanen. ");
INSERT INTO dgz_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Diosep Meri naitapen menan wat nugut veane wanden, ap menan mu dere, yaumua buka aritawa gwanap enapen menan Betiriem amon. Meri bagup tan, orup baraepen menan taiwandin. ");
INSERT INTO dgz_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ap mepe, Betiriem gapan wanumone, orup bare bare wamewa tauen. ");
INSERT INTO dgz_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Go pa gwanap ina ina at arok umap uon, iwa waenapan aruga tauan at warane umap tan. Ap menan man kao paewa amon. Orup mega namua apan baraen, wanupa wa panamen amba man kao taba naine arewa gapan ae baraen. ");
INSERT INTO dgz_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","At ame gapan, man sip kwayup taine nagirewa muma pua uta man muga kwayup tamuiwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Boge Ayop God anea mega da inamup venasen. God ganat mega ine maine ikukuk ganase wan. Tap nene yangwan doramon. ");
INSERT INTO dgz_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Go anea anega wadiamon, “Tap ya tane. Wapena anun. Ne nop oit kakaewa da wat ongen, waenapan iravi anupi aton aigap iragen anuin. ");
INSERT INTO dgz_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Iwa endi mame, apan Devit pa sewa mega Betiriem gapan, wat inakam imaini otua gase yanen. Me Ayop di, God mega wa watu eneni Keriso. ");
INSERT INTO dgz_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ne paua ma ewaingina gapan pa aisene, ame orup wanupa wa panamen, man kao taba naine arewa gapan ae baraene wandini yawai.” ");
INSERT INTO dgz_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Anea ap anega wani boge upine kimaniwa barat mutan, anea namua tanan, God inap anega wa atonasen, ");
INSERT INTO dgz_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“God kimani paina iragen yaua ao warivin. Piupa wanumuine nagire atonamu anuini gapan, God baigan mega warain.” ");
INSERT INTO dgz_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ap anega wane anea kimani sia dot amon. Man kwayup taine nagirewa anega wawa mutan, “Pa Betiriem anepen inak mame venaseni oisewa Ayop wadianeni yawapen.” ");
INSERT INTO dgz_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ame boge ao yonan, irut yani amone. Amone tauan, Meri ge Diosep amba orup mugawa, man taba naine arewa gapan ae baraene wandeni den yawamon. ");
INSERT INTO dgz_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ame orup mame yawanewa, anea gaset orup mame nopewa anen wadiamoni iragi ase wat senamene. ");
INSERT INTO dgz_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Man sip kwayup taine nagire oit ame wane waenapan anune no i kap wane. ");
INSERT INTO dgz_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Go Meri inak kakae iragen mame venaseni menan imua upe se wande anuiwandin. ");
INSERT INTO dgz_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Man sip kwayup taine nagire entan sia amone. Anea anen wadiamoni inagewa yawane menan God yaua ao waran, wa atonasiwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Wam nanin yamunaet yamunewa yampo uon tani ewap, Iesu God dugup mega intum tapen menan paua mega etua tunane amba yaua Iesu dian. Yaua ame anea namu dien amba inewa evi digumin tan. ");
INSERT INTO dgz_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Amba Diosep ge Meri, apan Mosis iup namua seni kwayup tapen menan naninanan ta dup iapen wamewa tauen. Amba Iesu God ire di wanapen menan pa Ierusalem dot amon. ");
INSERT INTO dgz_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Iwa wataget God nop mega ok anega seane, Orup namua apan yanepiwa ame Ayop God ase ire di wanep. ");
INSERT INTO dgz_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Nop mega den anega wan, Orup yaneni menan nenip bugip dere, o bairantan otua dere tambun gut iran, God wa atonasen. Iesu ine mame, iup mame tapen menan Ierusalem dot amon. ");
INSERT INTO dgz_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Wam ame gapan, ap mepe Ierusalem gapan, apan da yaua Simion iniwandin. Me apan kakae iragen iwa God men pot pot anu taiwandin. Isurero nagirewa ao sia wat nagat mumapen menan amat taiwandin. Ap gapan God Guewa Woup Seniwa Simion inap den wandiwandin. ");
INSERT INTO dgz_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Guewa ame Simion namu manega wadien, God mega wa watu enepi Keriso namu tauep yavepi amba Simion boeta. ");
INSERT INTO dgz_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","God Guewa wadieni menan Simion God Paewa gwanap aen. Amba Iesu ine mame apan Mosis iup baraeni gueguewa tapen menan God Paewa gwanap Iesu wat amon. ");
INSERT INTO dgz_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Amba Simion amawa Iesu bumagap ma wareni boge God inap anega wa atonasen, ");
INSERT INTO dgz_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Ayop negawa, wa agiat nimanegeana tavewa tauia, menan endi ne nao gega taina apanewa, baigan gapan bonigatain. ");
INSERT INTO dgz_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Iwa inak ewakewa nunepi, otua watu enaana mame, nek yamanap ase yaviangin. ");
INSERT INTO dgz_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ame ge gaset waenapan iragi menan anu ta baraean. ");
INSERT INTO dgz_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Orup ma ganat otua, Diu uon ian ugupe nagirewa, ganat mega gapan guegue gega yao anu awain. Me Isurero gapan yaneni menan ian ugupewa nagirewa, nu ian Isurero nagirewa, wa atonat nimanain. ");
INSERT INTO dgz_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simion Iesu oisewa ap anega wani menan ine mame dere no i kap wane. ");
INSERT INTO dgz_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simion Iesu ine mame wat aipakam mumeni amba inewa Meri anega wadien, “Wapena anu. Otuga mam Isurero nagire aruga upi wat momak mumapen, amba upi wat inakam mumapen menan God watu enen. Me God ire yaoyao paua mega da go waenapan aruga wawa koko tain. ");
INSERT INTO dgz_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ap wawa koko tapi imumu koeragewa ame wat arogameta. Amba ita enugin vegewa anuiana umap bumagaga enup vegewa anui.” Ap anega wadien. ");
INSERT INTO dgz_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ap mepe God nop mega waini kwapura da yaua Ana iniwandin. Me dugup yaua Asa. Me mamewa yaua Panuero. Me waen aeta di, wataget waenoro ini dena wandeni gapan apan naisen, en nani yamunaet nani yamu dere den iniwandin, amba memewa boen. ");
INSERT INTO dgz_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ap gapan me kwapura ta wandeni en mega apane degede, amba apan da naniwa degede (84) uon tan. Me Ierusalem gapan God Paewa gwanap pot poraet aiwandin. Mum wam pot pot God wa atonasepen menan mup waiwandin, amba wam da da gapan taba virip taiwandin. ");
INSERT INTO dgz_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simion nop mega uon tani amba waen Ana taue God wa atonasiwandin. Amba den Ierusalem gapan wat inakam mumapen menan amat taiwanumune nagirewa, Iesu oisewa wadidiamon. ");
INSERT INTO dgz_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Diosep ge Meri orup muga ewake yaneni menan God iup mega iragi tane uon tani amba, at Galili pa muga Nasaret ewagai sia entan amon. ");
INSERT INTO dgz_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Amba Iesu aroe den kai wat doriwandin. Me i namu iragi dima opata no dotouen, amba God kakae guragut mega iragi aigap visiwandin. ");
INSERT INTO dgz_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","En da da gwanap Iesu ine mame barip yaua Paina Yamaseni Baripewa napen menan pa Ierusalem dot amuiwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Iesu en mega aonagaet pusinawan dere taeuni gapan mu barip ame menan Ierusalem sia dot amon. ");
INSERT INTO dgz_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Barip uon tani ewap, ine mame entane ewagai pa sia amuiwanumune, go Iesu Ierusalem gapan wanden ae ve amon, go ine mame da ya anune. ");
INSERT INTO dgz_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Mu anega anun, ‘Orup den anivin.’ Menan wam daiton uon tani amba, anu awane menan, den tanam amuiwanumune nagirewa ge dugup muga nagirewa potamup, Iesu menan yop tan. ");
INSERT INTO dgz_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Yop tane ya yao matagamene menan pa Ierusalem ewagai sia entan amon. Tauane Iesu yoa tane. ");
INSERT INTO dgz_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Wam yampo uon tani amba God Paewa gwanap yao matagamen. Iesu ap mepe, wadidiamuine nagirewa nimakamup ae wande singui gare gare wawa musiwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Iesu nop waiwandini anune menan, waenapan no i kap wan, iwa me nop anu kaonage garewa waiwandini menan. ");
INSERT INTO dgz_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ine mame yawane seke tan, amba inewa singui wayaven, “Otunawa, ge dimen map anega tanean? Mamaga dere gop yaginen yoga tainton.” ");
INSERT INTO dgz_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Iesu gare wan, “Dimen yona taiwanin? Ne Mamana Pa mega gwanap wanik angina, e anuiwanin go?” ");
INSERT INTO dgz_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Iesu nop ame wani mu da ya di anu awane. ");
INSERT INTO dgz_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Boge Iesu ine mame nomu ware ao yon wande tanam Nasaret vit amon. Go inewa inak ap iravi anu tam se doriwandin. ");
INSERT INTO dgz_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Iesu kai wariwandin anut mega baware taiwandin. Ap gapan, God ge waenapan iravi den Iesu menan atonu anuiwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","At Rom bawarewa da, Taibirias Sisa, en mega aonagaet pusin yamunaet (15) ayop taiwandini gapan, gauarape mega upi at Isurero ayope taiwanumun. Gauarape nagire yaumua apan Pontias Pailat, at Diudia ayopewa, ge apan Erot, at Galili ayopewa ge Erot gwaniwa Pilip, at Ituria ge Tekonaetis ayopewa, ge apan Laisanias, at Abilini ayopewa. ");
INSERT INTO dgz_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Amba ap wamewa gapan, apan Anas ge Kayapas pirisi ayop muga taiwanumun. Wam ame, Sekaraya otua, Dion, at kaimewa gapan iniwandin. Ap mepe, God nop mega me inap tauen. ");
INSERT INTO dgz_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Inap taueni menan kaum Diodan arige tau ge tau ae opata anega waiwandin, “E koewa taianawa ae vean, imuya entanen anu tumat dupewa ian amba God koewa ega anu ae veta.” ");
INSERT INTO dgz_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Watageta God nop mega waiwandini apanewa Aisaya Dion oisewa ok anega sen, Apan da pua, at kaimewa gapan, opata anega waiwandin. Ayop nuga negin mega wa tarasen, wat tamanamene amba tauep. ");
INSERT INTO dgz_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Bumak ae ao iragi piup tu enane pon tap. Tunup endao wandao iragi tu ponamene taue aep. Negin gegerawa iragi wat tamanamene tamana tap, amba negin ae ao taniwa momagene pon tap. ");
INSERT INTO dgz_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Amba ap gapan, waenapan at at iravi, God inak ewakewa nunini apanewa ame yao anu asigip tain. ");
INSERT INTO dgz_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Dion dup iamopen menan waenapan aruga inewa onam wanumune, amba me anega wadiamon, “Guegue ega mokare seram naewa umap! E darinaya da enuni gapan God wae wae nemoro mega tawa aisepen taiwanin? ");
INSERT INTO dgz_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Inak ega koewa taiana ame ae vean garewa imuya entanen amba kakaewa yambuni ta aisiwanian. Ek mondi anega ya wane, ‘Nu omayan baewa Eibaraam menan God atonunu anuiwan,’ ap anega ya wane. Wapena anun, e Eibaraam naewa megawa megenat wane ya umap, iwa God Eibaraam naewa upi gwat ma wapi venat mutain. ");
INSERT INTO dgz_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Wapena anun, endi mame di oma visiwa arogamen, gurini apanewa nugusepen nauase wandia. Oma da da tavewa kakaewa ya iamopi gure ireta.” ");
INSERT INTO dgz_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Dion anega wani menan waenapan iragi singui anega wayawan, “Endi ame nu anenen tait?” ");
INSERT INTO dgz_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Me gare wadiamon, “E da da etua okomewa dere wanumopi, da ware, orup da uoniwa wanep. Amba e da da taba inayap wandepiwa den ap anega tan.” ");
INSERT INTO dgz_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ian moni bongamine nagirewa Dion dup iamopen menan den tauan anega wayawan, “Wadianet apanewa, nu endi anenen tait?” ");
INSERT INTO dgz_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Dion gare anega wadiamon, “Rom iup muga omewa gapan moni bongamepen diaene, aigap sia ya bongamene.” ");
INSERT INTO dgz_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Amba Rom ita nagirewa upi Dion anega wayawan, “Nu anenen, nu dim da tait?” Me gare wadiamon, “Apan da puraput mega menan aopan ega ya wane, up tapen menan kaimakaet ya nanam mumane. Nao ega garewa menan gunat ya anu wane.” ");
INSERT INTO dgz_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ap menan, waenapan iragi God inak ewakewa munapen menan amat taiwanumun, amba anu bambam den taiwanumun, iwa Dion taueni mu imumup anega anun, ‘Dion God mega wa watu eneni Keriso go uon?’ ");
INSERT INTO dgz_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ap anega anune menan Dion gare wadiamon, “Ne kaum iragen gapan dup iaivin go ayop da evinap oniwandini. Me God Guewa Woup Seniwa ge oma yamewa merao gapan dup iaiwandata. Me aiganap aroe amunu den oniwan, amba ago otua ayop mega pusi okomewa vesini mini, ne ap wat agoaset anun, go ne kakae uon. ");
INSERT INTO dgz_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Me iman taue oma makewa bongameta, makewa kakaewa ai bongame mek mini siwandata amba pokewa mek mini siwandata. Makewa kakaewa tambu ae dugupa eneta go pokewa tam ae da ya togura gura omae yamewa gapan uatamep yagimota.” ");
INSERT INTO dgz_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Amba Dion nop ugup ugup gapan, oit mega kakaewa mu anu tapen men wadidiam wandin. ");
INSERT INTO dgz_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Go wam ame gapan, ayop Erot Dion inap gari gangan naen iwa Dion namu anega diguren, “Ge apan koerage, narawaga Erodias up ta naitaan.” Amba Erot inak koe koe upinewa den taiwandini menan Dion aigap sia diguren. ");
INSERT INTO dgz_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ap menan, evi amba, Erot wan ita mega nagirewa Dion waran gwat noke baraene, mame tani Erot koewa mega aigap iragenawa tan. ");
INSERT INTO dgz_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Go Dion gwat noke ya baraene wamewa gapan, wam da, Dion waenapan iravi dup iamon uon tani ewap Iesu ware den dup ien. Amba Iesu God inap mup taniwa, kiman ase watapen. ");
INSERT INTO dgz_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Boge God Guewa Woup Seniwa nenip bairantan mini kimani visiwandin e Iesu wapip wanden. Wandeni nop da kiman gapan anega tauen, “Ge Otun iragenawa, imuna genan anu gurivin. Ge gamugap ne imuna ae meare tau aen.” ");
INSERT INTO dgz_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","38","Iesu God menan nao ere taiwandini, en mega apane daiton apan da aonagaet (30). Dugup mega se ge se manega onam wanumun endi mame tauen. God ere Adam nanip tan. Adam orup Set baraen. Set orup Inos baraen. Inos orup Keinan baraen. Kenan orup Maalaleo baraen. Maalaleo orup Dieret baraen. Dieret orup Inok baraen. Inok orup Metusela baraen. Metusela orup Lemek baraen. Lemek orup Noa baraen. Noa orup Sem baraen. Sem orup Apaksat baraen. Apaksat orup Keinan baraen. Keinan orup Sila baraen. Sila orup Iba baraen. Iba orup Pelek baraen. Pelek orup Reu baraen. Reu orup Seruk baraen. Seruk orup Neo baraen. Neo orup Tera baraen. Tera orup Eibaraam baraen. Eibaraam orup Aisik baraen. Aisik orup Diekap baraen. Diekap orup Diuda baraen. Diuda orup Peres baraen. Peres orup Esiron baraen. Esiron orup Anai baraen. Anai orup Atmin baraen. Atmin orup Aminadap baraen. Aminadap orup Nason baraen. Nason orup Salomon baraen. Salomon orup Boas baraen. Boas orup Obet baraen. Obet orup Diesi baraen. Diesi orup Devit baraen. Devit orup Netan baraen. Netan orup Matata baraen. Matata orup Mena baraen. Mena orup Melea baraen. Melea orup Elayakim baraen. Elayakim orup Dionam baraen. Dionam orup Diosep baraen. Diosep orup Diuda baraen. Diuda orup Simion baraen. Simion orup Livai baraen. Livai orup Matat baraen. Matat orup Diorim baraen. Diorim orup Eliesa baraen. Eliesa orup Diosua baraen. Diosua orup O baraen. O orup Elemadam baraen. Elemadam orup Kosam baraen. Kosam orup Adi baraen. Adi orup Meluki baraen. Meluki orup Narai baraen. Narai orup Siatiero baraen. Siatiero orup Serababero baraen. Serababero orup Resa baraen. Resa orup Dioanan baraen. Dioanan orup Dioda baraen. Dioda orup Diosek baraen. Diosek orup Semein baraen. Semein orup Matatayas baraen. Matatayas orup Maat baraen. Maat orup Nagai baraen. Nagai orup Esili baraen. Esili orup Neum baraen. Neum orup Emos baraen. Emos orup Matatayas baraen. Matatayas orup Diosep baraen. Diosep orup Dianai baraen. Dianai orup Meluki baraen. Meluki orup Livai baraen. Livai orup Matat baraen. Matat orup Elai baraen. Elai orup Diosep baraen. Diosep orup Iesu mamewa uon go waenapan mamewa dian. ");
INSERT INTO dgz_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Iesu kaum Diodan gapan dup ieni imu pose iragi Guewa Woup Seni no dotouen boge Diodan ae ve amba Guewa naue at kaimewa aen. ");
INSERT INTO dgz_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Wam apane dere (40) pua wande en, Seitan taue Iesu nanamase pusi warup taiwandin. Wam ame gapan, me taba da ya na amba iniwandin e, wam uiwa gapan enup one manen anun. ");
INSERT INTO dgz_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Seitan taue anega wadien, “Ge God Otua wanigewa, gwat ma wa taba buredi venasep na.” ");
INSERT INTO dgz_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Wani Iesu gare anega wan, “God nop mega ok anega seane, Waenapan inak muga ibariwa taba naine megenat uon.” ");
INSERT INTO dgz_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ap mepe, Seitan Iesu wat naue tunup ideve dot ae, boge piup ma kakae guragut mega iragi ewasen. ");
INSERT INTO dgz_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ewase anega wadien, “Piup ma iragi wande aeniwa amba aro amun megawa iragi neneni wandia. Ap menan ne orup da wanat anupena di wanain. ");
INSERT INTO dgz_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Menan, ge iak poe inanap ta wa taragat nimanegewa, toemu mame iravi genain.” ");
INSERT INTO dgz_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Iesu sia wan, “God nop mega ok anega sean, Nu Ayop nuga God megenat wa taragaset, ayamat mega taivinait.” ");
INSERT INTO dgz_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Amba Seitan Iesu pa Ierusalem wa upe naue aeni, God Paewa aigarip bare anega dien, “Ge God Otua wanigewa, map mepe pi ta aipa piupa wanigewa, pusiga ya en manai. ");
INSERT INTO dgz_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Iwa God nop mega ok anega seane, God wap anea mega taue genan amataga yaentuk ta naugep vitai. ");
INSERT INTO dgz_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Anea nanimup di warak nauge vise pia bat gimagain, pusiga agima en manamewa tawa.” ");
INSERT INTO dgz_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Iesu gare sia wan, “God nop mega ok anega seane, Ayop gega God uniunion pusi warup ya tayawa.” ");
INSERT INTO dgz_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ap gapan, Seitan pusi warup ugup ugup Iesu inap tayavin en, ae ve anega anuni, wam kakaewa da inepi amba sia tayawain. ");
INSERT INTO dgz_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Iesu God Guewa amunewa aigap wareni gapan at Galili entan aen. Oit mega at at iragi anu wa ge wa amon. ");
INSERT INTO dgz_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Amba me Diu nagirewa opata waine paewa gapan gapan wadidiam wandin. Ap gapan waenapan iravi me wa atonasiwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ameme Iesu kai wareni arewa pa Nasaret sia aen. Ian Diu pura muga bawarewa wamewa gapan, guegue mega namua taiwandini mini, Diu opata waine paewa unuk aen. Ap mepe me waenapan inamup God nop mega batnagepen menan yonen. ");
INSERT INTO dgz_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Menan, ap mepe wanumune nagire God nop mega waiwandini apane Aisaya ok mega seni ame wanane. Iesu watape nop yoa ta yave inamup anega batnagen, ");
INSERT INTO dgz_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“God Guewa mega potanap bararaen, iwa kayakayawan taine nagirewa, oit mega kakaewa wadidiamopen menan om enunegen. Itan panamoni nagirewa ne wapena gapan mu vetamoin, ap menan watu enanegen. Yame borat mutane nagirewa yangut tapen, itan muga wat nagasepen menan tauan. ");
INSERT INTO dgz_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Amba God waenapan mega wat inakam mumapen wamewa, gase taueni oisewa wadidiamopen menan ongen.” ");
INSERT INTO dgz_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Iesu ok ame batnagen uon tani tobore pa kwayup taini apane ok wane amba ae wanden. Ap mepe wanumone nagirewa iragi Iesu kem kem yaviwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Me sia anega wadiamon, “Nop ame anuyana, God nop megawa wataget ok di seane, ap me batnagingina tavewa endi mame tauen.” ");
INSERT INTO dgz_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Menan, waenapan iragi nop mega anune dansewa aigap menan wa atonasen go mu anega wan, “Ma Diosep otua diawa, go anut baware ma amba waren taiwan?” ");
INSERT INTO dgz_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Menan Iesu gare anega diamon, “Ne asiginap, e konintu maibe mame inanap anega wadianegai, ‘Ge pa gega nagirewa den wat inakam mum!’ Amba sia wadianegai, ‘Ge pa Kaponiam gapan yo ugup ugup taingiana oitaga anutoni ap mini endi mapa at pa gega gapan sia ta nu yawat.’” ");
INSERT INTO dgz_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Boge Iesu sia wan, “Ne nop tavewa di wadidiaivin. God nop mega waini apanewa da, ame mek pa mega gapan opata wapiwa go waenapan mega ya anu warain amba ya waupain. ");
INSERT INTO dgz_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ne tave di waivin ne tandayat nimanegenewa guegue ma mini venaseta. Wataget di at ma Isurero gapan God nop mega waiwandini apanewa Elaidia iniwandini wamewa gapan, waen kwapura aruga wanumon. En yampo dawa semu wam marakapu tauen, ugin da ya wan, amba at at iravi enup baware tau aen. ");
INSERT INTO dgz_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Go God Elaidia watu eneni ian Diu waen kwapura inamup ya tauen, go ian ugupe waen da, at Saidon pa Sarepat gapan, inap watu enen. ");
INSERT INTO dgz_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Guegue da sia mam. Wam da ugup gapan, at Isurero gapan waenapan aruga vek bo’o waramon. Go God nop mega waiwandini apanewa Elaisia, ian Diu apan da ya wat inakamen. Go at ugupe, Siria apanewa yaua Neimen, megenat wat inakamen.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Opata waine paewa gapan wanumone nagirewa Iesu nop mega anune gari gangan mutane. ");
INSERT INTO dgz_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Menan yonane boge Iesu nanamasene sewa bawarewa garip tau aen. Waran amon, pa sewa muga togana onan konintua ame gapan uat enapen tane. ");
INSERT INTO dgz_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Amone go Iesu waenapan nimakamup endume boge tau aen, go waenapan da ya warane. ");
INSERT INTO dgz_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ap gapan, Iesu at Galili pa Kaponiam ame vit aen. Ian Diu pura muga bawarewa wamewa gapan Diu nagire opata waine paewa gwanap wadidiam wandin. ");
INSERT INTO dgz_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Me opata waiwandini gapan waenapan iragi no i kap wan, iwa me nop aroe amunu den waiwandin. ");
INSERT INTO dgz_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Opata waine paewa gwanap, apan da airampu potap den wanden. Airampu senao uma anega wan, ");
INSERT INTO dgz_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Akae, ge Iesu pa Nasaret apanewa dim da inanup tat wa tauaan? Ge wa koeam nimanepen men tauan go? Ge orup ansena ne asiginap di, ge God mega potaga Woup Seni apanewa.” ");
INSERT INTO dgz_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Amba Iesu airampu kaimakaet use anega dien, “Nok borasep, apan ae ve tau ak!” Boge airampu apan ware waenapan nimakamup wat aipa uare boge tau aen, go apan siget da ya waren. ");
INSERT INTO dgz_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Waenapan ap yawanewa, iragi seke tan no i kap wan anega wawa mutane, “Nop ma anenen da? Nop mega aroe amunu den airampu up oimuiwandin tau amuiwanum.” ");
INSERT INTO dgz_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Iesu inak ame tani oit mega at ame ikukuk wande aeni, iragi senare tau aen. ");
INSERT INTO dgz_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ap ewapewa, Iesu opata waine paewa ae ve aeni apan Saimon pa mega tauen. Ap mepe, Saimon tapunewa vek ato itanigaet tan, ap menan waenapan Iesu wat inakamepen menan singui wayawane. ");
INSERT INTO dgz_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ame Iesu waen ame watat mega ginap yone, vek ame kaimakaet die wa pakisen, boge waen ame kakae tan. Menan me ao yone taba tunu munen. ");
INSERT INTO dgz_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Amba wam augariwandiniwa, vek ugup ugup nagirewa inap naumo onamon. Naniwa wapimup se ge se aeni, iragi wat inakam mumen. ");
INSERT INTO dgz_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Iesu ap taiwandiniwa, airampu arugataet waenapan potamupewa up oimon tau amon. Airampu iravi no yani den tauamon anega waiwanumun, “Ge God Otua di!” Go Iesu airampu pakit uatame, nop ae veapen menan diguguramon, iwa mu asigip tane me God mega watu eneni Keriso. ");
INSERT INTO dgz_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Inane woup sen, Iesu pa ae ve waenapan uoni arewa aen. Go waenapan me yoa tain en amba yawanewa menan me vemo aepen taiwandiniwa wat nasep wandepen menan taiwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Go me gare wadiamon, “Ne God toemu mega oise kakaewa ameme at at iragi wadidiamopen menan ongen. Ap tapen menan God watu enanegen.” ");
INSERT INTO dgz_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ap wani ewap, me at Diudia, ian Diu opata waine pa muga muga gapan opata wadidiamuiwandin. ");
INSERT INTO dgz_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Wam da Iesu kaum awan Genesaret etop yone, God nop mega wadidiam wandin. Waenapan nop mega anupen menan ikukuk enpanan, anuiwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Iesu kaum etop kabum dere yawamon. Meo upine nagirewa kabum dere ame ae ve amon, ia muga bigi guriwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Boge Iesu kabum daiton gwanap dotouen. Kabum ame apan Saimon megawa. Me gagap dore Saimon anega wadien, “Etop otu da ve asirantu aisen.” Wani menan Saimon ap tan amba Iesu kabum ame gagap ae wande waenapan opata wadidiam wandin. ");
INSERT INTO dgz_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Iesu waenapan nop wadidiamon uon tani ewap, me Saimon ase die anega wan, “Kabum gega wara, awan bumagap asirantu anet, ia gega meo menan ae antapena yawat.” ");
INSERT INTO dgz_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Wani Saimon gare wan, “Aritawa negawa, nu muma nao kaimakaet da tayavinton go meo da ya di upaton. Go endi ge waingiana menan ne ia sia antapena yawain.” ");
INSERT INTO dgz_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Amba apan Saimon evenewa den, Iesu wani noa waran den tanewa. Meo mek arugataet da upane, ia muga taniwa tom tam wapen tan. ");
INSERT INTO dgz_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ap menan evene wai, upi kabum dawa gapan wanumone, munan sisi tatau wane, tauan ago munan. Onamone meo warupen kabum dere ame enane no dotouen amba itaniwa gapan kabum kauma unugepen tane. ");
INSERT INTO dgz_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimon Pita inak mame yaveni, Iesu namup nikapu enu anega wan, “Ayop, ge venek asira ak, iwa ne apan koerage!” ");
INSERT INTO dgz_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","10","Saimon evene wai, Diemis ge Dion, apan Sebedi otu wai, tanamoni no i kap wan iwa meo arugataet yawane menan. Go Iesu Saimon anega dien, “Tap ya anu gura, wam koni mame use aeniwa ge meo upamoiana mini ge waenapan upamuingai.” ");
INSERT INTO dgz_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ame boge mu kabum muga, meo den, en turunagene kwatata dotouane amba wan dim dim muga iravi ae vemon, boge Iesu ewap amon. ");
INSERT INTO dgz_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Wam da, Iesu pa sewa da gapan wandeni. Ap mepe apan da epi no iragi omat na kakaurasen iniwandin. Me Iesu yaveni namup nikapu enu anega wan, “Ayop negawa, ge men di anua wat inakam nimanegai!” ");
INSERT INTO dgz_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Iesu naniwa endimase apan wapiwa inase anega dien, “Ne men anuivin, omat siran taran amop!” Boge no use gapan apan etua kakae tan. ");
INSERT INTO dgz_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Menan Iesu apan ame ase kaimakaet anega wadien, “Endi inak mame inagap tana oisewa waenapan da ya wadiamo noga botakamian. Amba pirisi ine age vek gega uon tani yavep. Yavepi watageta apane Mosis vek mame inak warepi gaunewa garaet God inap wanapen diagepi, ge God inap gaun garaet ap wawa gapan waenapan yawage anuin ame vek gega uon tan.” ");
INSERT INTO dgz_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Iesu anega wadieni go apan ame inakaeni oisewa senare tau aen. Ap menan waenapan arugataet Iesu nop mega anupen amba vek muga wat inakam mumapen menan tauiwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Go Iesu me wam wam da waenapan ae vemon aen, at iumai toni arewa gapan, pakaraen wanden mup tainiwa. ");
INSERT INTO dgz_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Wam da Iesu waenapan wadidiam wandini. Parisi ge iup wadidiamuine nagire pa sewa da da at Galili ge Diudia amba pa sewa Ierusalem gapanawa upi ap mepe den wanumon, Iesu nop mega anuiwanumune. Ap wamewa gapan God aro amun Iesu vek nagirewa wat inakam mumapen menan waniwandin. ");
INSERT INTO dgz_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Amba apan upi, pusi nani itani wane apanewa da eragia baraen waran tauan. Pa gwane unuk amo Iesu namup baraet anun tane. ");
INSERT INTO dgz_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Go pa gwanewa waenapan amborane menan mu gwanap ya amon, go apan waran pa aigari dot amon unenek napewa gapan to awan eragi mega gagap antapenane visen. Waenapan aru ame iam wanumone nimakamup vise, Iesu namup tamana ae wanden. ");
INSERT INTO dgz_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Amba Iesu mu anu tumat muga baware ame tane yao anuni gapan Iesu vek apanewa inap anega wan, “Apan negawa, ne koewa gega anun ae viangin.” ");
INSERT INTO dgz_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Iesu ap wani menan, iup wadidiamuine ge Parisi nagire den Iesu koewa anu ae veat wani anune, muk imumup anega anun, ‘Apan ambe da tauen, nop God mini ta wat taiwan? God megenat waenapan koewa muga anun ae viniwa, apan da koewa anu ae ya veta.’ ");
INSERT INTO dgz_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Singui muga imumup anunewa, Iesu imua gapan anuni menan gare wayawamon, “Iwa dimen imuya potaya gapan ap anega anuiwanin? ");
INSERT INTO dgz_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ne nop daitonawa wana vek apanewa koewa mega anu ae veat wan, o nop derewa ame manega wapena, ‘Ao yon ap ak,’ kaimake dena ansenawa? ");
INSERT INTO dgz_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Go e asigip taepen menan, Kimani Vitana Apanewa piupa waenapan koewa muga anu ae vepen menan aro amun warana ame endi to ewayain.” Amba Iesu vek apanewa sia anega dien, “Ne endi diagiangin, ao yon eragi gega wat pa ak!” ");
INSERT INTO dgz_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Wani boge no utap, waenapan namumup, ao yon wande eragi mega ware, God wa atonasiwandin eni boge pa mega aen. ");
INSERT INTO dgz_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Waenapan iragi imumu yon wanden amba God wa atonasen anega wane, “Wam endiwa inak bawarewa da ya yavintoni venasen yawaton.” ");
INSERT INTO dgz_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Mame ewap, Iesu pa ae ve tau ae, moni bongamini apane da yaua Livai moni bongamine paewa gapan wanden yave anega dien, “Evinap onak.” ");
INSERT INTO dgz_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Wani boge apan Livai yone wan dim dim mega iragi ae ve Iesu ewap aen. ");
INSERT INTO dgz_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Livai Iesu menan pa mega gapan barip baware tan moni bongamine nagire amba waenapan aruga upi den tanamo taba naiwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Go Parisi nagire ge iup wadidiamuine nagire Iesu yawan amba wadiamot megawa inamup noyam anega wane, “Iwa dimen moni bongamine amba koewa nagirewa den tanamoyan taba naiwanin?” ");
INSERT INTO dgz_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Iesu nop muga waiwanumune ame anuni menan gare anega wan, “Vek nagirewa nuat apanewa menan anu guriwanum go kakaewa nagirewa nuat apanewa menan ya anuiwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Menan ne muk ingane kakaewa anune nagirewa munan ya tauan, go koewa taine nagirewa imu posewa ge inak muga entan tapen menan tauan.” ");
INSERT INTO dgz_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Waenapan upi Iesu inap anega wayawan, “Apan Dion, waenapan dup iamuini apanewa, wadiamot megawa amba Parisi nagire wadiamot muga den God menan pot pot taba virip taiwanumun amba God inap mup waiwanum. Go wadiamot gegawa God menan taba virip ya taiwanum.” ");
INSERT INTO dgz_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Gare Iesu anega wadiamon, “Naine mutat i apanewa barip mega gapan wandepiwa me evene waimua taba virip ya veain, iwa aton anuiwanum. ");
INSERT INTO dgz_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Go wam evi da, naine mutat i apanewa waseam wat nau aepiwa, wam ame gapan taba virip veain, bagu sisi anune menan.” ");
INSERT INTO dgz_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Amba iup namua ge iup ewakewa guegue mega wadiamopen menan Iesu maibe gapan manega wan, “Waenapan wanup namua bebep wapi nadi warapen men semu ewakewa ya wabenagep. Wabenagepi ewakewa den koe tata amba wanup gine daiton uon, da vevera da kaimake den. ");
INSERT INTO dgz_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Guegue da sia mam. Apan da kaum wain ewakewa man etu namua kaum menan taginamene gwanap ya wa damagep. Damagepi kaum mek tutut wapi etua tuk wata amba kaum wa damagep etua den koe tata! ");
INSERT INTO dgz_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ap anega uon, go waenapan kaum wain ewakewa etua ewakewa gapan wa damagep! ");
INSERT INTO dgz_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Guegue sia mam. Waenapan kaum wain namua napi ewakewa ya nap. Mu anega wain, ‘Namua dansewa aigap, ewakewa dansewa uon.’” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Diu pura muga baware wamewa gapan da, Iesu nao egak da, maup taue wandeni, ame berip aiwandin. Wadiamot mega den amon taba uit verane maup taue wandeni makewa kukunagen etua warapen menan nanimup gotonagen amba tavewa ao nane. ");
INSERT INTO dgz_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ame gapan, Parisi nagire upi yawamo anega wan, “E iwa dimen pura bawarewa iup nuga paina yamat wanin?” ");
INSERT INTO dgz_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Iesu iup namua tavewa wadiamopen menan anega gare wadiamon, “Wataget da apan Devit evene wai den enup aguguramon tani oisewa ok gapan e iravi batnak anuyan. ");
INSERT INTO dgz_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Devit enup agureni menan God Paewa unuk ae amba God men taba buredi tugu sean, ian pirisi mugenat nainewa, ame iup mega den go me ware nan. Amba upi evene wai munen nane.” ");
INSERT INTO dgz_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Iesu wani sia anega wadiamon, “Ne Kimani Vitana Apanewa pura bawarewa ayopewa menan ne dim da umap wapena, ameme di.” ");
INSERT INTO dgz_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Amba Diu pura bawarewa mugawa dawa gapan, Iesu Diu opata waine paewa unuk ae waenapan wadidiam wandin. Apan da, naniwa nutup parasi tani, ap mepe den wanden. ");
INSERT INTO dgz_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Iup wadidiamuine ge Parisi nagirewa den Iesu enu yawa wapen anun. Ap menan Diu pura bawarewa, ame wagat wamewa gapan, Iesu apan ame wat inakameta go uon menan yama yama yaviwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Go mu imumu gapan ame anuiwanumune, Iesu me asigip tan menan nani parasi dena apanewa anega dien, “Onak, waenapan namumup mapa yon.” Wani apan ao yone ase ma one namup yonen. ");
INSERT INTO dgz_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Iesu waenapan inamup anega wan, “Ne singui wayawaian. Nu pura bawarewa iup nuga dim da waiwan? Pura bawarewa gapan waenapan inamup kakaewa tain go koewa tain? Mu inakam mumain go waenapan wa danigam mumain?” ");
INSERT INTO dgz_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Wani amba Iesu yangut ikukuk yawam naumo aeni, boge apan nani parasi dena ame anega dien, “Naniga ase endimat.” Me ase endimaseniwa boge kakae tan. ");
INSERT INTO dgz_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Go iup wadidiamuine ge Parisi nagirewa ame, anu dagimen, no kwapi aran, Iesu inap dim da tapen noa barim wanumun. ");
INSERT INTO dgz_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Wam ame gapan Iesu God inap mup wapen menan togan da dot aen. Mum ame, ap mepe yaugai wande, God inap mup taiwandin, woup sen. ");
INSERT INTO dgz_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Woup seni, wadiamot mega iragi munan wan, tauane amba apan aonagaet pusinawan dere om enumo, yaumu watu enamot mega nagirewa diamon. ");
INSERT INTO dgz_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ame yaumua mam. Saimon (yaua dawa, Iesu dieni ame Pita), ge Saimon gwaniwa Anduru, ge Diemis, ge Dion, ge Pilip, ge Batolomio, ");
INSERT INTO dgz_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ge Matiu, ge Tomas, ge Diemis (mamewa Alopias), ge Saimon (waenapan mega men yonini apanewa), ");
INSERT INTO dgz_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ge Diudes (mamewa Diemis), ge Diudes Iskeriot (Iesu omine wapi apanewa). Watu enamot mega nagirewa yaumua ameme. ");
INSERT INTO dgz_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Boge Iesu tunupa aupa wandeni watu enamot mega tanamo aoma vitan pona yonan. Ap mepe, wadiamot nagirewa aruga wanumone. Mu arugataet at Diudia ge pa Ierusalem amba puiman etop pa sewa dere Taya ge Saidon gapan tauan. ");
INSERT INTO dgz_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Mu Iesu nop mega anupen menan amba vek muga ugup ugup, ge airampu wa koeragam mumini nagirewa, wat inakam mumapen menan tauan. Iesu amun mega tau aen amba iravi wat inakam mumiwandin. ");
INSERT INTO dgz_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ap menan, waenapan iragi Iesu inasepen taiwanumun, iwa aro amun me gamupewa ase tau aiwandini. Ap gapan mu iragi inak wariwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Iesu wadiamot megawa anega wadiamon, “Kayakayawan taiana nagirewa aton anun, iwa God menan anuyan gututuguyan taiana, menan God toemu mega ame egawa. ");
INSERT INTO dgz_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Amba e da da enup iniana nagirewa, e aton tan, iwa evi amba kiman maup mega gagap dorai. Amba irip turup waiana nagirewa aton anun, iwa evi amba top wa aton tai. ");
INSERT INTO dgz_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Amba, piup gapan waenapan da da anu koeam imaepi, o tandayat imaepi, o nipep diaepi, amba yauya wa koeamepi, e aton anun, iwa ne Kimani Vitana Apanewa, nenan itan wariwaniana menan. ");
INSERT INTO dgz_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Wam ame tauepi aton anun, imuya tarep warep, iwa e garewa wara wara arita iragen, aupa kiman gapan enan wanden, amat taiwan. Aton anun, iwa ta koeragam imaine nagire, omaya baewa God nop mega waiwanumune nagire, ap umap wa koeragam mumane. ");
INSERT INTO dgz_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ae kaiwan, e puraput nagirewa. Aton endi anuiana wam da uon tata. ");
INSERT INTO dgz_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kaiwan, e endi maup nagirewa. Enup evi amba araeta. Kaiwan, e top waiana nagirewa. Evi amba bagu sisi anui irip turup wai. ");
INSERT INTO dgz_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ae kaiwan, e da wa da ta taiana nagirewa, yauya waenapan ao warine go tavewa uon, iwa wataget mu omae baewa, God nop mega tave uoni waiwanumune nagire, yaumu ap umap ao sia di wariwanumun, go mu wanene muga aigap warane.” ");
INSERT INTO dgz_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Iesu sia anega wadiamon, “E darinaya den, wapena anun. Anavi egawa munan anu guran, amba anu koeam imaine nagirewa, e yonan inamup kakaewa taiwanian. ");
INSERT INTO dgz_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Wa koeragam imaine nagirewa, munan God inap mup wan. Nipep diaine nagire, gare wa aipakam muman. ");
INSERT INTO dgz_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Amba orup da nawaneyap topi, gare ya tone go nawane yamu entanene sia top. Amba orup da etuya okome da ega aigape warupepi wanup gauarape men den wapi, ya watanane, ae veane, da den di warep. ");
INSERT INTO dgz_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Waenapan da da mup inayap wapi, e di munan. Amba orup da dim dim ega warepi, waseasepen menan sia ya wane. ");
INSERT INTO dgz_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Menan waenapan e inayap dim dim da tat anuianawa, e mu inamup, ap umap sia tan. ");
INSERT INTO dgz_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Waenapan imumu potamu inayap warepi, e gare munan mugenat anu mumane, ap gapan God wat aipakam mega ya warai. Iwa koewa taine nagirewa evene wai den muk gare gare baigan ap anega taiwanum. ");
INSERT INTO dgz_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Amba sia, inak kakae inayap tapi nagire mugenat e gare inamup inak kakae tane, ap gapan God wat aipakam mega ya warai. Iwa koewa taine nagire baigan ap anega den taiwanum. ");
INSERT INTO dgz_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Amba, evenae wai puakewa ega enapen menan amase taianawa, ap gapan God wat aipakam mega ya warai. Iwa koewa taine nagire puakewa muga warapen menan gare gare ap anega taiwanum. ");
INSERT INTO dgz_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Uon! go guegue ugup manega tan. Anavi egawa munan anu guran, inak kakaewa inamup taiwanian. Amba wan dim dim garaet asenagaet munan, garewa entan sia enapen amasewa ya tane. Ap tanewa, garewa ega iman aritavet aupa kimani warai. Amba den, God Paina Iragenawa otu waiwa waniai. Iwa God noegasine amba gaun inap ya waine nagirewa munan den bagu sisi anuiwan menan enan den tata. ");
INSERT INTO dgz_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ap menan Kimani Mamanu inayap bagu sisi anu gurini mini, waenapan inamup bagu sisi anu guriwanian.” ");
INSERT INTO dgz_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Waenapan wanene uniunion ya tamone, ap tane, e iman God wanene mega gapan ya tauai. Ya diguguramone, God gare ya diguguraeta. Amba koewa muga anu ae veane, God gare koewa ega anu ae veta. ");
INSERT INTO dgz_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Wan dim dim ega asenagaet munane, ap tanewa garewa evi amba God gare aritavet eneta. Garewa enepi ik ega enane no araseta. Menan yan otu kamontu munane gare otu kamontu warai, amba yan baware munane, gare baware warai.” ");
INSERT INTO dgz_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Iesu waiwandini maibe sia anega wan, “Apan yame borat mutane dere, ame dawa yone dawa wat naue ap aeta go? Uon! ap tapiwa, mu dere urata geamoin. ");
INSERT INTO dgz_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Amba sia, wadiamot nagirewa wadidiamuine mugawa paina ya yamasep. Go evi amba wadiam kakayat mumepiwa ap gapan mu wadiamuini apanewa den om inamop.” ");
INSERT INTO dgz_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Amba Iesu sia wan, “Iwa dimen evenae wai koewa muga otu kamontu, kaiko umap, yamamupe toborini yaviwanin? Go koewa ega baware, oma ni koni umap, yamayape toborini ya anuiwanin? ");
INSERT INTO dgz_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Amba ge kaiko evenaga yamap wandini warupapen menan anega diai, ‘Enda, kaiko yamagap warupapen taian’ Go baware yamagap toborini ya yavingi? Ame iwa dimen ap anega taingi? Ge da wa da ta taiana apanewa. Koewa gega baware oma nikoni yamagape namu warup, yangut ta kakayase, amba evenaga kaiko yamape warupai.” ");
INSERT INTO dgz_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ap me menan Iesu sia anega wan, “Oma kakaewa, tavewa koevet ya iamota, amba oma koerage, tavewa kakaewa ya iamota. ");
INSERT INTO dgz_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ap gapan oma daiton daiton tavewa iepi irewa mega gapan gapan yavinewa. Ap menan ganongae, tavewa baip ya ieta. Ipuni, tavewa mokot ya ieta. ");
INSERT INTO dgz_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ap umap, apan kakaewa, wan dim dim kakaewa mega imu pose gapan enen waboren wandini tambun taiwan, amba apan koerage, wan dim dim koerage imu pose enen waboren wandini tambun taiwan. Ap mini sia koewa kakaewa imu pose no dotouen arasiniwa gamup nomu gapan nop waiwanum.” ");
INSERT INTO dgz_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Iesu sia anega wadiamon, “Dimen ayop ega dianegean go nop waina gapan ya taiwanin? ");
INSERT INTO dgz_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Waenapan da da inanap taue nop nega anu tapi guegue muga manega wa ewayain. ");
INSERT INTO dgz_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Apan da pa mega tupen menan ibariwa urat bumaga tantan waren amba sewa bonawan aigap ae antapenan amba tuini mini. Amba ningoe tawak da taue ise nasiwandin go ya wabaimen, iwa pa tu kayasen. ");
INSERT INTO dgz_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Go da da nop nega anune go ya tapi, mu apan da pa mega upuna tuni mini. Urat ya ware pa ibariwa pia tun amba ningoe taue pa ise nasiwandin boge wabaim gearen, iragi wat musen uon tan.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Iesu nop ameme wan uon tani ewap, me pa Kaponiam aen. ");
INSERT INTO dgz_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ap mepe, at Rom ita yame apanewa iniwandin. Nao mega taini da menan anuiniwa vek wa guren, konintu bop tapen taiwandin. ");
INSERT INTO dgz_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Amba ita yame apanewa ame Iesu oit mega anuni menan Diu dimae waine nagire upi watu enamon amon, Iesu wap one vek apanewa wat inakamepen menan. ");
INSERT INTO dgz_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Sep amone Iesu ine tauanewa noek noek wan, anega diane, “Ita yamewa ame apan kakaewa menan onak ta warit. ");
INSERT INTO dgz_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Iwa me nu Diu nagirewa nunan anu gureni menan, amba nu opata waine paewa da tun nunen.” ");
INSERT INTO dgz_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Boge, Iesu ao yon wande den tanam aen. Onam wanumune ita yamewa pa mega di maniwandini gapan ita yamewa evene wai upi, Iesu diapen menan, sia watu enamon amba Iesu inap tauan oit wan, “Ayop negawa, gek anu bambam da ya ta, ne wan menan pa nega tauapan taingi, go ya taua iwa ne koerage. ");
INSERT INTO dgz_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Endi ap menan nek inaga onge onge go ne kakae uon. Nop gega amunu den megenat wawa nao nega tainiwa inakaeta. ");
INSERT INTO dgz_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Iwa ne, ayop nega den, apan upinewa epara muga gauarap waingina apanewa amba den ita nagire gauaranap nona wariwanum. Da ak diapena di aeta. Da onak diapena di oneta. Da nao ma ta diapena di tata. Ap menan ge wawa, ne nao nega tainiwa di inakaeta.” ");
INSERT INTO dgz_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Iesu nop ame anuni, me noa ase ginin wan, to entaneni boge waenapan aruga evip onamone nagirewa anega diamoni, “Ne wapena anun, anu tumat nimanegeni apane ma miniwa da at Isurero gapan ya yawan.” ");
INSERT INTO dgz_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Sep nagirewa ame ewagai sia amon pa tauane, nao apanewa ame inakae wanden yawane. ");
INSERT INTO dgz_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ap ewap, Iesu ge wadiamot megawa, amba waenapan aruga den, pa yaua Nein dot amon. ");
INSERT INTO dgz_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Iesu pa Nein tonane noa maniwandini gapan, pa nagirewa bop apane da watat gapan baraen, wat ororom warupan onam wanumun. Bop apane ame waen kwapura da otua daiton iragenawa ame boen. Pa nagirewa arugataet waen ame tautanan amon. ");
INSERT INTO dgz_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Boge, ap gapan Iesu waen kwapura ame yaveni menan bumagewa tuk wan bagu sisi arita anun, menan anega dien, “Irip ya wa.” ");
INSERT INTO dgz_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Amba Iesu aeni otua boen eragia wa panam baraene ame naniwa gapan ase inasen gapan wat amone nagire ae yonan. Boge Iesu anega wan, “Apan tamaru, ne diagiangin, ao yon wanik!” ");
INSERT INTO dgz_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Iesu ap wani boge apan bonigawa ao yon wande nip endave nop erewa wan. Menan Iesu orup ame ware inewa wanen. ");
INSERT INTO dgz_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Waenapan iravi tap baware anun God wa atonasen, amba anega wane, “Nop waini apane baware da nimakanup tauen. Nu wat inakam nimanepen men tauen.” ");
INSERT INTO dgz_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ap menan, Iesu oit mega at Diudia amba piup ikukuk wande aeni iragi ukum ume tau aen. ");
INSERT INTO dgz_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Dion, dup iamuini apanewa, wadiamot megawa Iesu inak aru mame taiwandini no oisewa Dion wadian. Ap anuni gapan, Dion apan dere venamu wan tauane. ");
INSERT INTO dgz_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Amo, Ayop Iesu wayawapen men namu anega wan wadiamon, “Nu amat taitoni Keriso ge me di go gare apan da ugup tauapen amase tait?” Sep apane dere nop mame anune boge Iesu wayawapen amon. ");
INSERT INTO dgz_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Iesu inap tauane anega wayawan, “Dion, dup iamuini apanewa, watu enanen. Nu amat taitoni Keriso ge me di go gare apan da ugup tauapen amase tait? Ap wayawagepen men onanton.” ");
INSERT INTO dgz_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Wam ameme gapan, sep apane dere, Iesu vek ugup ugup nagirewa wat inakam mumen airampu waenapan potamupe up oimon tau amone, yawan. Yame borat mutane nagirewa aruga watap mumeni yame i pak wan yangut sia taiwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Mu ap yawane menan, Iesu anega wadiamon, “Ewagai sia aisen, anenen yao anuiwaniana Dion wadian. Yame borat mutane nagirewa sia yangut taiwanum, pusiwa wabeberugaseni nagirewa ap sia amuiwanum. Vek bo’o nagirewa sia inak musiwanum, darine borat mutane sia anuiwanum. Bop tane nagirewa sia inak mutane yon wanumuiwanum. God oit mega kakaewa kayakayawan taine nagirewa wadidiamuivin. ");
INSERT INTO dgz_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Waenapan ne ya tandayat nimanegepiwa aton anuiwanumain,” Iesu ap anega wadiamon. ");
INSERT INTO dgz_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Boge Dion sep mega dere entan amone. Ap ewapewa, Iesu Dion oisewa ap mepe wanumune nagirewa anega wadiamon, “Dion yawapen menan at kaimewa pua aiseana dim da yawat anuyan? Apan da i guine aro uoni yawapen aisean go? ");
INSERT INTO dgz_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ame uon wandepi e dim da yawapen menan aisean? Apan da wanup ganganataet eneni yawapen menan aisean go? Anun, wanup kakaewa enine ge kwan puraput nagirewa ame ayop yau taneni pa mega gapan ininewa, go at kaimewa gapan pua da uon. ");
INSERT INTO dgz_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Go endi e dim da yawapen men pua aisean? God nop mega waini apanewa da yawapen aisean go? E, me ap me. Wapena anun. Tave di Dion apan ap me di go me aigap iragenawa. ");
INSERT INTO dgz_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Me menan wataget God Dion oisewa wani ok anega seane, Wapena anun. Ne oit nega wapi apanewa namu watu enain, negin genan wareta.” ");
INSERT INTO dgz_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Iesu sia anega wan, “Menan ne wadiaepena anun, waenapan iragi yanane yaumakamup Dion megenat aigap. Go kiman gueguewa iup ewakewa gapan ame, evi amba God toemu mega gapan orup da God nave otu kamontu iragena tapi watat aigapewa wareta, go Dion me gauarap wandeta iwa Dion iup namua gapan taueni apanewa.” ");
INSERT INTO dgz_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Iesu ame waiwandini waenapan amba moni bongamine nagirewa den darine entap anun amba iragi umap wan anega wane, “God nop mega tavewa di.” Iwa mu namua God anu tumat tane gapan, Dion inap amone dup iane. ");
INSERT INTO dgz_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Go Parisi ge iup wadidiamuine nagire, God munan anuini tandayasene iwa Dion dup iamopen men ya amon. ");
INSERT INTO dgz_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Iesu sia wadiamon, “Endi piup mame gapan iniana nagire guegue ega anen wapena amba om ineta? E inak ega anenen? ");
INSERT INTO dgz_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","E orup otu pa pa namboya kae taine umap. Mu gare isewa mawa anega noyam pot poraet waiwanum, ‘Nu sinao tuivin go e tarep ya taiwanin. Nu urai angingin waivin go irip ya waiwanin.’ ");
INSERT INTO dgz_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Tavewa ame mam, Dion waenapan dup iamuini apane yoneni God men taba virip viwandin kaum wain da ya nan. Ap tani menan e noyam anega wayan, ‘Airampu da potap wandia.’ ");
INSERT INTO dgz_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Go ne Kimani Vitana Apanewa tauana taba kaum wain den naingin menan anega noyam wayan, ‘Ase kem kem yawan! Me taba paututuma naiwan amba kaum wain pot pot naini menan bumbawam taiwan. Amba den moni bongamini ge inak koewa taine nagirewa evenan tan.’ Menan e noyam pot poraet waiana nagirewa. ");
INSERT INTO dgz_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","E ap anega waiwanin go God nop mega tavewa di wandia. God dim da da me waenapan gamumup ta oniwandini ame God anuini taine nagirewa mu wa ewamoin.” ");
INSERT INTO dgz_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Wam da, Parisi apane da Iesu den mum gine tabaewa napen men vene wan onen. Iesu pa mega taueni taba napen menan ae wanden. ");
INSERT INTO dgz_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Pa sewa ame gapan, koewa taini waenewa da wanden. Iesu Parisi apane pa mega gapan taba naiwandin oisewa anuni menan me kaum pokari da gwat gapan kaitane kaum tutu dena ame damage ware tauen. ");
INSERT INTO dgz_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Iesu aup parata ine taba naiwandini gapan waen ame Iesu pusip ae yone irip waiwandin. Irip waiwandini yame doge vise Iesu pusip enun. Amba waen ame i gume nononga gapan Iesu pusiwa muse darakamen. Pusiwa ua ton amba kaum tutu dena aigap wa damagen. ");
INSERT INTO dgz_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ap gapan, apan Parisi, Iesu onat wani apanewa, waen tani yaveni mek ingane anega wan, “Apan ma God watu enep nop oit mega waini apane wandepo waen mame wakaiseni me koewa taini waenewa anupo.” ");
INSERT INTO dgz_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Iesu nop megawa anuni menan, gare anega wadien, “Apan nega Saimon, nop wadiagepena anu.” Saimon gare wan, “Wadianet negawa, anenen anuingi? Wadianek.” ");
INSERT INTO dgz_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Iesu maibe gapan sia wan, “Apan dere moni amase taini apanewa da inap amo mup wane amba moni ase ma totnagen. Moni amase taini apanewa moni baware 500 totnagen apan daiton wanen amba dawa moni otu koentu apane dere apan da aonagaet (50) totnak wanen. ");
INSERT INTO dgz_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Garewa sia wanapen wamewa taueni. Go apan dere ame moni totnagene, moni amase taini apanewa ise sia wanapen menan umap uon. Ap menan moni amase taini apanewa puakewa mugawa ase musen, moni sia ya wanapen menan diamon. Ap menan orup ansena moni amase taini apanewa inap aton aigap anuta?” ");
INSERT INTO dgz_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Iesu singui wani Saimon gare wadien, “Apan ap moni puakewa mega baware inape anu ae veni me aton aigap anuta.” Saimon wani Iesu gare wadien, “E, tave di waiagi.” ");
INSERT INTO dgz_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Wani boge Iesu waen inap entane Saimon sia anega wadien, “Waen ma yavingi. Ne pa gega tauana pusina bigi warapen kaumewa ya nenaan. Go waen mame, me yame doge gapan pusina puakame amba i gume gapan mut darakamen. ");
INSERT INTO dgz_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ne tauana gaunana ta ua ya tonegean go waen mam ayamat nega baware tan pusina ua toiwandin en wandia. ");
INSERT INTO dgz_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Amba den Diu gutut nuga menan ya anuan, ame ganip kaumewa ianap ya geman. Go waen mam kaum tutu dena pusinap gemen. ");
INSERT INTO dgz_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ap menan wapena anu. Ne waen mam koewa mega aruga ise wat mutana menan me gare ne inanap baigan arita tan. Go waenapan koewa muga aruga uon God anu ae veni mu gare otu da megenat God menan anuiwanumun.” ");
INSERT INTO dgz_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Iesu nop ame wani waen inap sia wadien, “Ne koewa gega gaset ise wat mutan.” ");
INSERT INTO dgz_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Iesu ap wani menan waenapan upi den tauan ap mepe taba naiwanumune mugenat anega wawa mutan, “Ma apan ansena da tauen, amba waenapan koewa muga ise mutat waiwan?” ");
INSERT INTO dgz_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Go Iesu waen inap sia wadien, “Anu tumat nimanegeana menan inak ewakewa wariagi. Yaema baigan gapan ak.” ");
INSERT INTO dgz_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Wam koni da amba, Iesu wadiamot megawa aonagaet pusinawan dere den, God toemu mega no oise kakaewa wadidiamopen menan, pa bawarewa ge otu koentua gapan opata wa ge wa tau aiwandin. ");
INSERT INTO dgz_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Waen upi den tautanan amon. Waen ame upi Iesu namu vek muga wat inakam mumen amba airampu potamup up oimon tau amone. Waen da ame yaua Meri (yaua dawa ame Makdalin) wataget airampu nani yamunaet nani yamu dere potap wanumone Iesu up oimon tau amon. ");
INSERT INTO dgz_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Waen dawa apan Susa waenewa Dioana. Apan Susa me ayop Erot gauarape mega da. Waen dawa yaua Susana amba waen upinewa aruga den Iesu tautanan amon. Waen mame moni muga gapan Iesu, wadiamot mega den, kwayup tamuiwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Wam da, waenapan arugataet iam wanumone amba waenapan upi sia pa ugup ugup Iesu inap tauiwanumune gapan. Iesu maibe anega wadiamon. ");
INSERT INTO dgz_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Apan da oma makewa mega verapen menan aen. Nao mega gapan uasiwandin, upi negina geamon waenapan aigap amu tau amon amba boge nenip tauan enun nan. ");
INSERT INTO dgz_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Amba makewa upi agim gagap geamone ap mepe piup baware uon. Oma makewa tuk tak wan yananewa, kai warane go serarat kurat wan iwa piup daraka, kaum uon. ");
INSERT INTO dgz_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Makewa upi ganongae berip geamone amba kai waran go gaian yan doran umen boge borit wane. ");
INSERT INTO dgz_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Amba makewa upi piup kakaewa gapan geamon. Ame yanan dorane tavewa ieni arugataet mek arugataet da ie ge ie tan. Tavewa apane nani yamunaet (100) iamon.” Iesu ame wani kaimakaet anega wan, “Darinaya den wandepi nop nega anun.” ");
INSERT INTO dgz_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Iesu maibe wani menan, wadiamot mega tavewa anupen menan singui wayawane. ");
INSERT INTO dgz_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Iesu gare anega wadiamon, “God toemu mega karaua wandini tavewa watap enen gase di yawayan anuiwanin go waenapan upinewa menan maibe gapan megenat wadiamuivin. Ap wapena iwa mega ame mam, Mu yangut tain go ya yao awain. Mu anuin go ya anu awain. ");
INSERT INTO dgz_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Maibe mame tavewa mam. Oma makewa ame God nop megawa. ");
INSERT INTO dgz_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Amba makewa negina geamone guegue ame waenapan nop anuiwanumun go mu ya anu tumat tapen iwa Seitan taue nop potamupe up taiwan. ");
INSERT INTO dgz_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Amba makewa piup baware uon gwat aigap geamone gueguewa ame, waenapan nop ere anune atonu den anun go potamup ya waren. Go evi amba pusi warup wamewa inamup taueni gapan mu aro muga uon tan menawaet inak wakaumane. ");
INSERT INTO dgz_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Amba sia makewa ganongae berip geamone gueguewa ame, waenapan nop anun go piup itan megawa o aton megawa o moni puraput imumu waren menan God imu pose ya waren amba kiman inak kakaewa da inamup ya venasen. ");
INSERT INTO dgz_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Amba makewa piup kakaewa gapan geamone gueguewa ame, waenapan nop anu kakayasene. Bumagamu totanen anu warane ayamase yaentuk mantuk taiwanumune ae ya vene, menan inak muga tavewa mega kakaevet ien aewan.” ");
INSERT INTO dgz_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Maibe da sia God nop mega menan Iesu anega wan, “Apan dun mega ire ware karaua unup ninokap o aup inine wantarewa gauarap ya baraeta. Go waenapan pa dorepi ganat yawapen menan aroga paina baraeta. ");
INSERT INTO dgz_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Menan dun ame gapan, dim dim iravi karaua tainewa wam da arogameta. Dim dim iragi ukum umanewa evi amba ganat gapan aroga tauain. ");
INSERT INTO dgz_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ap menan ae anu guran, nop nega yaentuk anuiwanian. Iwa orup da da mu anu avepiwa, ame God nop upi sia aigap aigap muneta. Go orup da da ya anu avepiwa, nop otu da namu anun waranewa, God nop ame sia waseamo aeta.” ");
INSERT INTO dgz_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Amba Iesu inewa ge gwani wai Iesu yawapen menan onamon, go umap uon iwa waenapan barat mutane. ");
INSERT INTO dgz_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Menan orup da taueni boge Iesu anega wadien, “Inaga ge gwanik waiga yawagepen menan tauane, itapa pa garip yoniwanum.” ");
INSERT INTO dgz_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Go Iesu waenapan anega wadiamon, “Waenapan da da God nop mega anune amba gueguewa tainewa ame ne inanawa amba gwanin wainawa.” ");
INSERT INTO dgz_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Wam da Iesu wadiamot mega den kabum gagap dorane amba anega wadiamon, “Kaum awan yamu asepa gan anepen,” wani boge amon. ");
INSERT INTO dgz_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ame kabum gapan amuiwanumune, Iesu aup inen. Amba taik aritavet da aroe den awan gagap tauen. Kaum dotoue kabum gwanap geariwandin amba kabum awana unugepen tan. Mu iragi bop nonokap tauapen taiwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ap menan, watu enamot nagirewa amon Iesu wa kandasepen menan anega wan, “Ayop, ayop, borit wapen taivin!” Boge Iesu kandaeni taik ge kaum doak ame eniwandiniwa kaimakaet ase diamo wan boge taik ge kaum doak ame tom wa ae bigaren. ");
INSERT INTO dgz_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Amba me anega diamon, “E anu tumat ega ne inanap otu kamontu.” Go mu tap tan tarak anega wawa mutan, “Akae, apan ma anenen da? Taik ge kaum diamoni boge noa di warane.” ");
INSERT INTO dgz_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ame Iesu, watu enamot nagire mega den tanam, kabum gapan awan Galili ame gamu to nugusen at Gerasin tauan. ");
INSERT INTO dgz_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Iesu kabum ae ve piupa viseni pa apane da airampu arugataet potap wanumune Iesu ine tauen. Airampu potap unuk wanumon wam nononga ni aroga wande en. Me pa ae ve pua ae, borit wane tumuine arewa gapan yone iniwandin. ");
INSERT INTO dgz_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Wam wam aruga airampu apan wariwandin menan pa nagire pusiwa naniwa damik kaimake dena gapan panan baraen yama yama yaviwanumun. Go me damik to totomage amba airampu to bambamasene pua aen. Apan ame Iesu yave senao wan namup omanip enu amba Iesu airampu inap kaimakaet anega dien, “Apan ae ve tau ak!” Ap menan airampu nop kaimakaet anega wan, “God Paina Iragenawa Otua Iesu, inanap dim tat anu tauaan? Kaiwan, ya ta koeragam nimanege.” ");
INSERT INTO dgz_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ap anega wani Iesu singui wayaven, “Ge yauga anen?” Airampu arugataet potap unuk wanumone menan apane gare anega wan, “Ne yauna ‘Nu arugataet.’” ");
INSERT INTO dgz_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Airampu arugataet ame Iesu inap kayawan mini anega wan, “Piup mum sisip usenagaet wandini arewa ame gapan ya wa oinene.” ");
INSERT INTO dgz_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ap mepe, togana tuan arugataet taba naiwanumun. Menan airampu Iesu nanamasen anega wane, “Wa oinewa, nu tuan potamup ununait.” Menan Iesu anega wan, “A, umap tau aisen!” ");
INSERT INTO dgz_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Airampu apan ae vean tau amon tuan potap unumon. Unumone tuan togana serarat vitan kauma geamon none namon. ");
INSERT INTO dgz_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Tuan kwayup taine nagire yawamone tap serarat amon pa pa at at oit wadidiamon. ");
INSERT INTO dgz_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Pa nagire oit anune gapan serarat tauan anen tani yawapen onamone. Iesu ine tauane airampu namu potap wanumone apanewa Iesu pusip ae wanden yawan. Me i guine kakae tan, gan gorogot ene wanden. Mu apan ame yawane tap anu guran. ");
INSERT INTO dgz_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Amba waenapan da da inak mame yamamup ase yawane Iesu wat inakameni oisewa waenapan upinewa wadidiamon. ");
INSERT INTO dgz_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Go at Gerasin nagire iragi tap anu gurane menan Iesu at muga ae vepen wan. Ap menan Iesu kabum gagap sia dore aepen taiwandin. ");
INSERT INTO dgz_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ap gapan, inakaeni apanewa Iesu inap anega wan, “Tatan, gende anepen,” go Iesu entane anega wan, ");
INSERT INTO dgz_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ak, pa gega gapan God anenen tageni oisewa wadidiam.” Wani boge apan ame pa daiton daiton sewa mega gapan ae God inap tani oisewa wa ge wa aen. ");
INSERT INTO dgz_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Iesu ewagai kaum awan asepa gan entane sia taueniwa, waenapan iragi atonu den waupane, iwa Iesu menan naine nambene taiwanumune menan. ");
INSERT INTO dgz_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ambagan, Diu nagire opata waine paewa kwayup taini apane da yaua Diairas Iesu ine taue namup omanip enu wae wae ta anega wan, “Pa nega onak. ");
INSERT INTO dgz_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Orana daiton iragenawa, en mega aonagaet pusinawan dere, vek waren bop tapen taiwan.” Iesu tautane aeni, waenapan aruga gigigit kapet nau amon. ");
INSERT INTO dgz_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Waenapan ameme nimakamup waen da en aonagaet pusinawan dere vek ewatop taiwandin, go waenapan da ya wat inakamene. Vek mega men garewa dom gigit nagirewa moni munitamen go vek uon ya tan. ");
INSERT INTO dgz_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Iesu ap aiwandini gapan waen ame garivi taue wanup mega ginewa inasen boge ewatop mega tonaren. ");
INSERT INTO dgz_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Menan Iesu waenapan anega wayawamon, “Da inat tanegen?” Iravi uonagaet wane, menan Pita Iesu anega dien, “Ayop nugawa, waenapan aruga ma to iamene enpanagene, gigigit kapet natagiwanum. Menan da inataget wan, wayawaningi?” ");
INSERT INTO dgz_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Go Iesu gare wan, “Ae, da inat tanegen. Iwa ne anuna aro gamunape tau aen.” ");
INSERT INTO dgz_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Boge inaseni waenewa, Iesu imua anuni anun menan ine taue kaime pagagak ta namup omanip enu waenapan yamamup anega wan, “Ewatop nega uon tapen men inat tagen boge inak nigasen.” ");
INSERT INTO dgz_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Boge Iesu waen ame anega dien, “Oranawa, anu tumat nimanegeana menan inak wariagi. Baigan gapan ak.” ");
INSERT INTO dgz_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Nop ame waiwandini gapan, Diairas, Diu opata waine paewa kwayup taini apanewa ame, pa mega apane da me ine taue anega wadien, “Oraga gase boen. Ap menan wadianini apanewa Iesu menan gamben sia ya wa taingan.” ");
INSERT INTO dgz_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Iesu nop ame anuni Diairas inap anega wan, “Tap ya anu. Aigap sia anu tumat nimanegewa, oraga inakaeta.” ");
INSERT INTO dgz_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Amba Iesu apan Diairus pa mega taueniwa, Pita, Dion ge Diemis amba boeni ine mamewa den mugenat pa gwanap amon go waenapan upinewa watanamon. ");
INSERT INTO dgz_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Koni ameme gapan, orup waen boeni menan waenapan irip turup ap mepe waiwanumune, go Iesu anega wadiamon, “Irip ae vean, me mondi aup iniwan, ya boen.” ");
INSERT INTO dgz_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Iesu nop ap wani menan waenapan iragi verea kaura top nop wan iwa mu asigimup orup waen ame gase boen. ");
INSERT INTO dgz_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Go Iesu ae taue orup waen naniwa ware inap anega wan, “Orup negawa, ao yon wanik!” ");
INSERT INTO dgz_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Orup waen guewa mega tau aeni sia entane one potap unugen, boge menawaet ao yon wanden. Ap menan Iesu anega wadiamon, “Taba da wanane nap.” ");
INSERT INTO dgz_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Orup waen ame ine mame daramumu wan, go Iesu anega diamon, “Ne tana oisewa waenapan ya wadiamone.” ");
INSERT INTO dgz_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Iesu watu enamot mega aonagaet pusinawan dere munan wan tauane, amba aro amun mega vek nagirewa wat inakam mumapen amba airampu wa oimopen menan munen. ");
INSERT INTO dgz_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Aro ame muneni gapan God toemu mega oisewa wadidiamopen amba vek nagirewa wat inakam mumapen menan watu enamon. ");
INSERT INTO dgz_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Me anega wadiamon, “Negin aisiwaniampina mondigataet aisen. Kaipat go taba go moni ega da den ya tambune. Wanup senunawa den ya tambune. ");
INSERT INTO dgz_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ame aisene amba pa da atonu den waupaepiwa, ap mepe iniwanian, ap tapen wamewa tauepiwa, amba pa ame ae vean aisen. ");
INSERT INTO dgz_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Go at da waenapan da da ya waupaepi pa muga ae vean aisen koewa muga ae bat munapen menan pusia atabobo toninigamen aisen, ame tane yam tatak munapen.” ");
INSERT INTO dgz_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Iesu ma iravi wani boge watu enamot megawa amon. God Oit Mega Kakaewa pa pa tau ge tau wadiam wadiam amuiwanumun amba vek nagirewa wat inakam mumiwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Wam ame gapan, at Galili ayop muga Erot, Iesu oisewa anuni anu bambam tan. Iwa waenapan upi anega waiwanumun, “Dion, dup iamoni apanewa boeni sia inakae yon wanden.” ");
INSERT INTO dgz_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Amba upi anega waiwanumun, “Watageta apanewa Elaidia boeni sia inakae yon wanden.” Upi den sia anega waiwanum, “God nop mega wataget waiwandini apane da boeni sia inakae yon wanden.” ");
INSERT INTO dgz_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Go ayop Erot anega wan, “Ne wana menan ita nagirewa Dion waran i gamu to nugutane boen. Go endi mame da? Ne nop inapaet anuivin.” Ap menan me Iesu da ase yawapen menan taiwandin. ");
INSERT INTO dgz_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Iesu watu enamot mega nagirewa sia entan tauane, amba anenen taiwanumune oisewa Iesu wadian. Anuni boge naumo pa Besaida amon, mugenat ap mepe wanumon. ");
INSERT INTO dgz_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Go waenapan me amba aeni asigip tane menan Iesu evip amon. Ap menan Iesu waupamon, God toemu mega oisewa wadidiamon, amba vek nagirewa inak warat anuiwanumune nagirewa wat inakam mumen. ");
INSERT INTO dgz_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Wan gine taniwa gapan watu enamot megawa aonagaet pusinawan dere Iesu ine tauan anega wan, “Waenapan aru ma wa oimo, at sewa bawarewa amba pa pa amo taba napen ge aup inapen arewa menan yop tap. Iwa at ma waenapan uoni arewa.” ");
INSERT INTO dgz_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Go Iesu gare wadiamon, “Ae, e taba da munan.” Mu gare anega wan, “Nu taba nuga buredi magamene nani yamunaet meo dere mugenat. Go nu sia ane waenapan aru mame taba muga une ta munait?” ");
INSERT INTO dgz_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Apan ap mepe wanumone arugataet 5000 mini amba waen aigap sia den. Iesu watu enamot megawa anega wadiamon, “Waenapan apane dere apan da aonagaet (50) iam iam ta wanum wanum amopen menan wadiamon.” ");
INSERT INTO dgz_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Watu enamot nagirewa Iesu wani gapan gapan tane. ");
INSERT INTO dgz_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Amba Iesu taba buredi magamene nani yamunaet meo dere den ame tambu kiman ao yave God inap gaun wan amba paise paise ta waenapan taba munapen men, wa ewamot megawa munen. ");
INSERT INTO dgz_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Waenapan iravi taba tavewa nane bagu i bim wan. Nane ewap, wadiamot megawa semua bongamen kaenat aonagaet pusinawan dere enane no dotouen. ");
INSERT INTO dgz_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Wam da, Iesu megenat God inap mup taiwandini gapan, watu enamot mega den wanumon. Me singui anega wayawamon, “E anuiwaniana, waenapan ne da dianegiwanum?” ");
INSERT INTO dgz_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Mu upi gare manega wane, “A, ge Dion waenapan dup iamoni apane dianegiwanum. Upi watageta apane Elaidia dianegiwanum. Upi ge God nop mega waiana apane da wataget boeni sia yon wandet dianegiwanum.” ");
INSERT INTO dgz_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Menan Iesu mu inap singui anega wayawamon, “E, umap, go e ne da dianegiwanin?” Boge Pita gare wan, “Ge God wa watu enageni mega Keriso.” ");
INSERT INTO dgz_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pita ap anega wani menan Iesu waenapan upinewa oit ame ya wadiamopen men kaimakaet diamon. ");
INSERT INTO dgz_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Iesu anega wan, “Kimani Vitana Apanewa ugu vegaek bagu sisi baware anu tanain. Waenapan dimae waine nagire amba pirisi bawarewa ge iup wadidiamuine nagire den tandayat nimanege toguranegepi bonigatain. Toguranegep bonigasepena amba wam yampoa God amun mega gapan inak nigat yon wanigain.” ");
INSERT INTO dgz_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Amba Iesu waenapan iragi anega wadiamon, “Orup da inanap onat anu tapiwa, namu me mek dim da anuini tandayase, ae di vep, amba ne yauna menan, pot poraet ugu vegaek bagu sisi anu, evinap oniwandan. ");
INSERT INTO dgz_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Amba orup da da muk inak mugawa menan anu gurane tainewa, ame inak muga wakaumain, go orup da da mu inak muga nenan anu gure wakaumepiwa, mu inak kakaewa tautanain. ");
INSERT INTO dgz_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Amba sia, orup da piup puraput mega iravi tambupi go inak mega mek wa koeamepi o wakaumepi, ame tavewa, umap uon! ");
INSERT INTO dgz_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Waenapan da da umamuna tapiwa, ne Kimani Vitana Apanewa kakae guragut nega ganasewa den Maman anea mega potamu woup seniwa kakae guragut muga ganasewa den sia tauapena gare umamumu tain. ");
INSERT INTO dgz_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Wapena anun imuya ya oaraep. E da da endi mapa yoniana ya borit wai go God toemu mega amunewa tauepi yawane amba borit wai.” ");
INSERT INTO dgz_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Nop ame wani amba wam nani yamunaet nani yamu yampo ewap, Iesu God inap mup wapen menan apan Pita, Diemis ge Dion tambumo tunup da dot aen. ");
INSERT INTO dgz_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ap mepe Iesu mup taiwandini gapan me gine namu ugup entanen, amba en wanup mega pomponugaet ganase wan. ");
INSERT INTO dgz_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Amba watageta apane wai Mosis ge Elaidia venat mutan Iesu den nop waiwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Apan dere ameme God oya oyae mega den tauan amba God Iesu pa Ierusalem gapan boepi anuni menan ap noa waiwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita evene wai dere den aup iniwanumun, go mu nene nanan tan yamamu ase meret di wa kakayaseni amba Iesu oya oya mega ganasewa amba apan dere tautanamo yoniwanumune yawamon. ");
INSERT INTO dgz_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Apan dere Iesu ae veapen taiwanumune gapan Pita Iesu inap anega wan, “Ayop nugawa, nu e den mapa wanineta ame kakae. Pa namdat otu da yampo tumoit. Daiton gegawa da Mosis megawa da Elaidia megawa.” Pita anu waramat gapan ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita nop mame waiwandini irikup guguk wa aigamup taue waboboramon amba mu irikup potap wanumon ap menan Pita evene wai den tap tan. ");
INSERT INTO dgz_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Nop da irikup potap anega tauen, “Ma ne Otun iragenawa, om enuna menan nop mega di anuiwanian.” ");
INSERT INTO dgz_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nop ame uon tani amba mu Iesu megenat wanden yawan. Mu inak ame venasen yawane oisewa waenapan da ya wadiamon. ");
INSERT INTO dgz_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Inane woup sen, amba Iesu, watu enamot mega den, tunupa vit onamon, ap mepe waenapan aruga tautanamon. ");
INSERT INTO dgz_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Waenapan nimakamup apan da Iesu inap nop kaimakaet wan, “Kaiwan, wadianet nugawa, otuna daiton iragenawa inap bagu sisi anu. ");
INSERT INTO dgz_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Airampu ma otuna waren anap antapeniwan, boge orup ve waiwan daram daram taiwan, gwitutu nop tauiwan. Airampu waren di enkakait nau iwan ae da ya vea vea mini taiwan. ");
INSERT INTO dgz_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ne wadiamot gega airampu wa oisep tau aepen men wayawamon go mu ya umap. Wane go orup ya inakaen.” ");
INSERT INTO dgz_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Amba Iesu gare anega wan, “Akae, koewa taiana nagirewa, ya anu tumat nimanek wanin. Ne wam animpo mini tanae waingepen amba anu tumat tai?” Ap wani amba Iesu apan ame inap anega wan, “Otua wat mapa onak.” ");
INSERT INTO dgz_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Orup ame waran onam wanumune, airampu orup ame ware patunen pia gearen amba ware enu menawasen. Go Iesu airampu kaimakaet die wa oise amba orup wat inakame ware mamewa wanen. ");
INSERT INTO dgz_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Amba waenapan God aro amun mega ap yawane gapan tarak wan. Iesu inak mame tani menan waenapan yawan nenen bubup taiwanumun. Menan Iesu wadiamot mega anega wadiamon, ");
INSERT INTO dgz_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Endi wadiaepena di anuiwanian imuya ya oaraep. Waenapan Kimani Vitana Apanewa waranege anavi nega nanimu gwanap bat nimanegain.” ");
INSERT INTO dgz_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Go Iesu watu enamot mega nop mame waiwandini mu da ya di anu awane. Nop mame iwa mega karaua ukum umen wandia, ap menan mu ya anu awane go tap anun. Tap anune menan mu singui sia ya wayawane. ");
INSERT INTO dgz_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Iesu wadiamot megawa mu ansena da bawarewa tata menan gare gare notatae waiwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Iesu mu imumu potamu ase yave anuni menan orup otu da ware tainamup bare yonen. ");
INSERT INTO dgz_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Amba Iesu anega wadiamon, “Waenapan da da orup otu ma miniwa nenan waupepi ame ne den waupanek wanumain. Ne waupanegepi Mamana watu enanegeni den wa upiwanumain. Apan da yaumakayap otu kamontu iragenawa me bawarewa iragen.” ");
INSERT INTO dgz_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Amba Dion Iesu inap anega wan, “Ayop nugawa, nu yawatoni apan da ge yauga gapan airampu wa oimuiwandin menan nu watanaton iwa me nu den ya inat nimanen.” ");
INSERT INTO dgz_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Go Iesu gare wadiamon, “Ya watanane. Iwa orup da da anavi ega ya tapi mu evenae waiawa.” ");
INSERT INTO dgz_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Iesu kiman dot aepen wamewa maniwandini menan, Iesu gine namu ware entane pa Ierusalem neginaet di dot aiwandin. ");
INSERT INTO dgz_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Iesu evi pa da tauapen menan sep nagire namu watu enamon Iesu at mega ta kakayasepen menan at Sameria gapan pa da tauane. ");
INSERT INTO dgz_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Go Iesu pa Ierusalem neginaet di dot aiwandini pa nagirewa yawane menan Sameria pa nagirewa Iesu ya waupan. ");
INSERT INTO dgz_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Watu enamot mega dere, yaua Diemis ge Dion mu ya waupane ame yawane menan gare Iesu anega wayawan, “Ayop nugawa, ge anenen anuingi? Nu God inap mup wat merao kimani watu enep waenapan mam yagimop borit wain go?” ");
INSERT INTO dgz_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ap anega wane menan Iesu entane diguguramon, ");
INSERT INTO dgz_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","amba pa da ugup amon. ");
INSERT INTO dgz_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ap mepe neginaet amuiwanumune, apan da Iesu ine taue anega wan, “Ge amba amba da agewa, ne evigap ongingain.” ");
INSERT INTO dgz_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Iesu gare anega wadien, “Ewatap piup nokap wande wande arewa den amba nenip dugup muga oma onep den wandia, go Kimani Vitana Apanewa wagat wanige iana bare bare arewa da uon, menan ne evinap ongepen menan kaimake den.” ");
INSERT INTO dgz_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Iesu apan dawa inap anega wan, “Evinap ongingan.” Go apan ame gare anega wan, “Ayop negawa, namu angep mamana boepi tup amba ongain.” ");
INSERT INTO dgz_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Go Iesu gare wadien, “Ya anu tumat taine nagirewa vemone mu bonigawa di tumop. Go ge ak, God amun mega taueni oisewa wadidiam.” ");
INSERT INTO dgz_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Amba apan da ugup sia Iesu inap anega wan, “Ayop negawa, evigap ongingain go namu wa angep dugup nega gaune tamop amba.” ");
INSERT INTO dgz_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Go Iesu gare wadien, “Waenapan da da God nave ere tapi ae ve sia entan pa muga amot anupi, me God toemu mega menan nao tata umap uon.” ");
INSERT INTO dgz_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Mame ewap, Iesu wadiamot mega apane yampo apan da aonagaet pusinawan dere (72) upi nao mega men wa nugut mumen. Iesu tau ge tau aepi arewa gapan apan dere dere namu watu enamon. Me evi amba ap mepe tau ge tau aeta. ");
INSERT INTO dgz_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Iesu anega wadiamon, “Taba arugataet inin geraget tan wandia, go daupam tata nagirewa aruga uon. Ap menan maup i apanewa, God inap mup wane, watu enamop nao mega daupam tata nagirewa aruga tauepi maup mega tambupen amop. ");
INSERT INTO dgz_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Menan endi aisen, go anun! E man sip otua ame baigan mane umap watu enaivin go waenapan anan eyao wasipen umap nimakamup waniai. ");
INSERT INTO dgz_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ap gapan, moni igewa o ik pokaetawa, o pusi okomewa da den ya tambune. Amba waenapan negina gaun ya tane iwa wam ega wakaumene tawa. ");
INSERT INTO dgz_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Amba pa da da dorane namu manega wadiamon, ‘Nonup inayap wande ep.’ ");
INSERT INTO dgz_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Baigan nonup apane da, pa ap me gapan wandepiwa, gare nonup gaun ega me aigap visep. Go nonup apane da ya wandepi nonup gaun ega inayap sia onep. ");
INSERT INTO dgz_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","At da tauane, baiganaya tapi nagirewa inamup ap mepe pa daiton ame gapan wanien. Taba kaum da enepiwa, tanam nan. Dim da enepiwa tambun. Iwa nao taine nagirewa garewa muga den wariwanum. ");
INSERT INTO dgz_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Pa sewa da tauane amba waenapan waupaepi taba enepi ame aibu nan. ");
INSERT INTO dgz_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Vek nagire ap mepe wanumopi, wat inakam muman den anega wadiamon, ‘God toemu mega onen manaiwan.’ ");
INSERT INTO dgz_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pa da da tauane waenapan ya waup imaepi pa namboya yonan anega wadiamon, ");
INSERT INTO dgz_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Koewa tayana menan pa atabobo mega toninigamianit. Ya waup nimanean go ma ae di anu kakayasen, God toemu mega onen manaiwan.’ Ap anega wadiamon. ");
INSERT INTO dgz_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Endi wadiaepena anun. Gop ya anune, God wanene mega wamewa gapan, pa sewa da da e ya waup imaene, koewa taine pa sewa Sodom nagirewa God wanene mega arita warane omewa mini ya yawain go pa ameme baware iragen yawain.” ");
INSERT INTO dgz_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Iesu itan baware inamup tauepi oisewa namu manega wadiamon, “Kaiwan, pa Korasin Diu nagirewa, kaiwan, pa Besaida Diu nagirewa, itan baware yawai. Iwa yaumakayap yo baware taingina go ame Diu uoni nagirewa pa Taya ge pa Saidon ya yawan. Yawapo koewa muga ae ve yamu entanepo bagu sisi magunewa wara wanumopo. Go e yo baware taingina yawayan go imuya potaya ya entanean. ");
INSERT INTO dgz_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Menan God wanene mega wamewa gapan, pa Taya ge pa Saidon nagirewa itan yawain go e itan baware iragen yawai. ");
INSERT INTO dgz_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Den ian Diu nagirewa pa Kaponiam gapan. Ek anuyan taiana gapan kiman dot aitai go? Ae, ya dot aitai go God merao arewa gapan utam imaeta.” ");
INSERT INTO dgz_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Iesu ame wani amba wadiamot mega anega wadiamon, “Waenapan da da nop ega anupi nop nega den anuiwanumain. Amba da da tandayat imaepi ame ne den tandayat nimanegain. Amba da da ne tandayat nimanegepi ame ne Mamana, watu enanegeni, den tandayasiwanumain.” ");
INSERT INTO dgz_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Wadiamot mega apane yampo apan da aonagaet pusinawan dere (72) namu Iesu watu enamoni ame atonu den sia tauan Iesu anega wadian, “Ayop nugawa, ge yauga gapan airampu diamuintoni, nonu waran tap tau amuiwanumun.” ");
INSERT INTO dgz_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Amba Iesu gare anega wan, “Seitan kimani yangwan mini wat vese geareni ne yawan. ");
INSERT INTO dgz_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Wapena anun. Amun nega enana ap menan anavi ega Seitan aro mega iravi inayap aroe uon tan. Anan mokarewa o gayu gagap amune ya araeta. Amun nega enana menan dim dim da ya one araeta. ");
INSERT INTO dgz_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Tavewa di, airampu noya warane go ap menan atonua arita ya tane go God kiman gapan yauya buka gapan ok seni menan aton aritavet ap menan taiwanian.” ");
INSERT INTO dgz_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Wam ame gapan God Guewa Woup Seniwa Iesu potap no dotoueni menan atonu den anega wan, “Maman, ge piup kiman Ayopewa. Ne gaun inagap waiangin, iwa anut bawarewa nagirewa nop maibe tavewa anuine nagirewa den nop gega ya anu awapen men karaua baraean go ok ya taine anut baware uoni nagirewa nop gega wa ewamoan. E, Maman, atonu den ap anu taan.” ");
INSERT INTO dgz_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Iesu Mamewa inap wan uon tani amba waenapan sia wadiamon, “Ne Mamana dim dim iragi nanin gwanap sen. Amba ne God otua ame waenapan da asigimup ya tanegene go Mamana megenat Otua asigip tan. Amba sia waenapan da Mamana ya asigimup tane go ne, me Otua, ne negenat asigip tan. Ap menan ne Mamana guegue megawa waenapan da da ta ewamot anupena di ta ewamoin.” ");
INSERT INTO dgz_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Nop ame wani amba Iesu wadiamot mega inamup ise to entane mugenat karaua anega diamon, “Dim dim iravi yawayana menan aton anun! ");
INSERT INTO dgz_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Iwa wapena anun. Wataget, God noa waiwanumune nagire amba Diu ayop nagire ugup ugup den endi e dim dim yavisiana yawapen menan taiwanumun go mu da ya yawane. Amba endi dim dim da anuisiana anupen menan taiwanumun go mu da ya di anune.” ");
INSERT INTO dgz_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Iup wadidiamuini apane da yone Iesu pusip warupe irewa yawapen menan singui manega wayaven, “Wadianek negawa, ne anenen tap amba yaibobot inagewa usenagaet wandini yon borain?” ");
INSERT INTO dgz_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Iesu gare anega wan, “Ge singui gega garewa God nop mega namua gapan ok seane anenen waiwan? Guegue mega ansena tavewa anuingi?” ");
INSERT INTO dgz_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Amba apan mame gare anega wan, “Nop mega manega waiwan, ‘Ge ayop gega God imuga potaga gapan, guaga gapan, epara guin pakao gega gapan, iak guine gapan, ayop gega God menan ae anu guringan. Amba gek genan ae anu guriana mini, evenak waiga pa mainagape wanumuine nagirewa munan den anu guringan.’” ");
INSERT INTO dgz_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Apan ame wani Iesu gare anega wan, “Nop garewa tamana di waiagi, menan inak mame taingawa ge yaibobot inagewa gapan in agingai.” ");
INSERT INTO dgz_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Go apan ame mek ingane apan kakae waenapan yawa anupen menan, me Iesu singui da sia wayaven, “Pa mainenape nagirewa ambe da?” ");
INSERT INTO dgz_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Iesu gare anega wadien, “Gutut da wadiagain. Apan da pa Ierusalem ae ve pa Dieriko vit aiwandini gapan, up nagire waran wanup puraput mega seasen, epi tokait wakait tane, bop konintu ae bat vean amon. ");
INSERT INTO dgz_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Amba ian Diu pirisi apane da neginaet vit oniwandin. Tone apanewa ae yaveni go mainap sensenui tau aen. ");
INSERT INTO dgz_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ap umap sia dugup Livai apane da taueni tone apanewa yaveni go mainap sensenui tau aen. ");
INSERT INTO dgz_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Amba Diu nagirewa anavi muga, at Sameria apane da, ap aiwandin taue tone apane yaveni bagu sisi menan anu guren. ");
INSERT INTO dgz_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ine taue ganip kaumewa mone dena umap ge kaum wain den omat no utap ae geme okom panen. Tauni amba man donki mega gagap barae wat nau ae daio nagire inine paewa taue bare kwayup tan. ");
INSERT INTO dgz_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Inane woup sen, apan Sameria ame moni mega upe, daio nagire inine paewa i apane ase wane, anega wadien, ‘Apan ma kwayup ta. Ange entan tauapena kwayup taingawa menan moni ma uon tapi da sia genain,’ ap anega wan.” ");
INSERT INTO dgz_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Gutut uon tani amba Iesu iup wadiamuini apane ame inap singui anega wayaven, “Endi ge imuga anenen anuingi? Gutut gapan up nagire apan ton wanup puraput mega seasen amon amba apan yampo tauan yawane mu ansena da tone apanewa pa mainepe nagirewa mini ago tan?” ");
INSERT INTO dgz_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Apan ame gare anega wan, “Tone apane inap bagu sisi anuni apanewa pa mainepe apane mini ago tan.” Iesu nop ame anuni gapan anega wadien, “Tave di waiagi. Ak, ap tani umap ta.” ");
INSERT INTO dgz_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Wam da, Iesu wadiamot mega den ap amuiwanumune amba pa sewa da tauan. Ap mepe waen da yaua Mata mu waupamo amba pa mega gwanap naumo aen. ");
INSERT INTO dgz_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mata gwaniwa waen, yaua Meri, taue Iesu pusip ae wande me nop mega anuiwandin. ");
INSERT INTO dgz_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Go Mata nao wan dim dim ap mepe ta ta mega tapen menan taiwandin. Ap menan Iesu nop mega ya anun. Go evi amba me Iesu ine taue gunat anega wan, “Ayop, ne gwanina ae venegen nao aru ma negenat taingina menan ge anenen anuingi? Ge wadia me one ago tanegep.” ");
INSERT INTO dgz_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Go Iesu gare anega dien, “Mata, Mata! Ge wan dim dim aruga mame menan gop ge bagu sisi anu guran taingi. ");
INSERT INTO dgz_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Anut daiton megenat aigap iragen, ame nop nega anupen. Ap menan gwaniga Meri kakaewa da om enun, menan ne ya watanain.” ");
INSERT INTO dgz_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Wam da Iesu at da gapan wande God inap mup waiwandin. Mup uon tani amba wadiamot mega da anega wadien, “Ayop nugawa, Dion, dup iamoni apanewa wadiamot megawa God inap mup wapen guegue wa ewamoni ap umap wa ewan.” ");
INSERT INTO dgz_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Boge anega wadiamon, “God inap mup wane manega wan, Mamanua, yauga ao warat genan ayamat taivinain. Toemu gega amunewa inanup tauiwandan. ");
INSERT INTO dgz_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Taba nuga wam wam nuningawa endi den nun. ");
INSERT INTO dgz_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Koewa inanup tane anuton ae vivin, menan koewa nuga anu ae ve. Dim dim da pusinu ya warup naune age.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Boge Iesu sia anega wadiamon, “Mup tat mega tavewa mega mam. Mum gagewa da gapan e evenaya paewa aisene mup anega wanewa, ‘Enda, evenanu da oniwandini endi mame tauen go me taba wanapen menan nu inanup uon. Ap menan taba buredi magamene yampo nunawa umap?’ ");
INSERT INTO dgz_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Go evenaya gare manega wadiaepiwa, ‘Ya anu nimanegene. Tonan gase boran, otun waina den aup inivin. Ne yonap taba ya enain,’ ap anega wapiwa e anenen tai? ");
INSERT INTO dgz_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Wapena anun. Evenaya menan yone taba ya eneta go sia wayao wayao taiwaniampinawa menan yone taba megenat uon go wan dim dim arugataet eneta. ");
INSERT INTO dgz_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ameme mini ne aigap sia wapena anun. Mup gapan God wayawane me gare eneta. Amba imutuan anune gare me ewaeta. Amba sia tonan mega ken ken tone gare enan watapeta. ");
INSERT INTO dgz_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Iwa waenapan da da God inap pot pot mup waiwanumampina ame garewa di warain. Dim da yoa taiwanumampina ame tautanain. Amba tonan mega ken ken toiwanumampina ame munan watapeta. ");
INSERT INTO dgz_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ap mini sia, e ansena da otu waia man meo men mup wapi e gare mokare sisiwa munai go? Ae, ame uon. ");
INSERT INTO dgz_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O otu wai kumkum bagua men mup wapi e gare gayu munai go? Ap mini e ya taianawa. ");
INSERT INTO dgz_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ap menan e koewa taiana nagirewa go otu waiawa kakaewa garaet munapen asigiap di, go e taiana otu kamontu. Iwa Mamanu God garaet kakaewa aigap tainiwa, ap menan God inap mup wane Guewa Woup Seniwa aigap di eneta.” ");
INSERT INTO dgz_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Wam da, Iesu no boraseni apane da airampu potap oirenen tau aen, airampu tap aeni gapan apan ame boge nop wan. Ap mepe wanumuine nagirewa inak ame yawane no i kap wan. ");
INSERT INTO dgz_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Go upi yawane nipep anega wan, “Airampu bawarewa mugawa yaua Bieseboro Iesu amun mega waneni gapan me airampu up oimuiwandin tau amuiwanum.” ");
INSERT INTO dgz_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Upi Iesu irewa yawapen menan aopan anega wayawane, “Ge aro kimaniwa yo paua da ta, nu yawat.” ");
INSERT INTO dgz_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Go Iesu mu imumu gapan dim da anune mek anuni menan anega wadiamon, “Toemu da da engirit ta waiwanumampina dumari amoin. Amba sia dugup da todum wadum taiwanumampina mu iragi ora amoin. ");
INSERT INTO dgz_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ap umap Seitan toemu mega endumepiwa, toemu mega uon di tata. Ap menan iwa dimen Bieseboro amun neneni gapan airampu upi wa oimop tau amot dianek wanin? ");
INSERT INTO dgz_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ne ap tapo dugup ega nagirewa airampu wa oimop tau amopi amun da muneni gapan taiwanum? Bieseboro munen go? Ek wadiamot ega ap diguguramopo mu gare ebo diaepo. ");
INSERT INTO dgz_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Uon, ne God amun neneni gapan airampu wa oimuivin. Ap taina menan God toemu mega amunewa inayap tauen. ");
INSERT INTO dgz_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Seitan me aro apane mini da. Apan ame ita kepata den, pa mega kwayup tapi up nagire ya tauain. ");
INSERT INTO dgz_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Go apan da aro mega baware iragen taue pa i apane topi garawase pa doreta. I apane namu imua manega anun, ‘Ita kepata nega dena menan ne aro apanewa.’ Go aro baware iragena apane taue ita kepata mega sease ae se boge puraput mega tambu yan se evene wai muneta. ");
INSERT INTO dgz_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Waenapan da da me imua inanap ya wandiniwa, orup ame tandayat nimanegen taiwan. Amba sia orup da ya tananegen nao ya tainiwa, ame ne nao nega wa koeragamiwan.” ");
INSERT INTO dgz_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Iesu nop da sia wan, “Airampu apan potap taue aen, at darakawa arewa ise ase aiwandini amba nonan enu wande wande arewa yop taiwandin go ya yaven. Ya yaveni menan mek anun, ‘Ne pa nega namu wanigena ap menan sia entan angain.’ ");
INSERT INTO dgz_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ae taueni apan ame posewa kakae pa tarase dim dim sese kakayat tani yaven. ");
INSERT INTO dgz_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Menan sia ae airampu upi nani yamunaet yamu derewa koerage iragen ame tanam tauan apan potap unum wanumon. Namu airampu daiton wandeni gapan anan otu da taiwandin go evi aruga potap unumone gapan airampu anan aigap iragen taiwanumun.” ");
INSERT INTO dgz_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Iesu nop mame waiwandini gapan, waenapan nimakamup, waen da ve anega wan, “Bat gimage watugeni waenewa wat aipakam me inap wande ep.” ");
INSERT INTO dgz_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Go Iesu gare anega wan, “Ge ap waingi go God nop mega anuine taine nagirewa wat aipakam aigap wariwanum.” ");
INSERT INTO dgz_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Waenapan arugataet inap sia tauiwanumune menan Iesu anega wadiamon, “Waenapan endi ma use yan ainiwa inak muga koevet iragen. Mu yo ugup ugup paua mega yaviwanumat anune waiwanum, go kiman paua mega da ya munain go apan Diona yo paua mega megenat yawain. ");
INSERT INTO dgz_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Watageta apane Diona pa Nineva nagirewa inamup paua wa ewaseni ap umap sia God paua mega Kimani Vitana Apanewa endi iniana nagirewa wa ewaeta. ");
INSERT INTO dgz_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Watageta ayope Solomon nop dima mega baware anupen men ayop waen da yaua Siba at wandap tauen. Solomon anut mega baware go apan anut baware iragen da endi taueni wandia go nop mega ya anuiwanin. Ap menan God wanene taepi wamewa gapan ayop waene Siba ame e endi iniana nagire den yone diguguraeta. ");
INSERT INTO dgz_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Amba sia Nineva nagire e endi iniana nagirewa den yone digugurayain iwa apan Diona opata wadidiamoni gapan pa Nineva nagirewa koewa muga ae vean imumu wat entanen. Diona apan baware di go apan da Diona aigap wandini mapa wandia!” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Iesu sia anega wan, “Apan da dun mega ire ware karaua ya baraeta o ware unup ninokap ya wat eneta. Go waenapan pa dorepi ganat yawapen menan aroga yaumakap baraeta. ");
INSERT INTO dgz_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ap mini, yamaya etuya dun ganat megawa. Menan e yamaya kakae wandepiwa, e ugu wapi uruga ganat no dotoue wandeta. Go yamaya koe tapiwa, e ugu wapi den mum tatarin tau aeta. ");
INSERT INTO dgz_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ap menan yambuni wanien ganat potayape mum tunupi tawa. ");
INSERT INTO dgz_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ap me menan, etuya iravi ganase wapi amba semu otu da den mum da uon, e ganat ega dun wariana ganasewa mini ewa mega gapan waniai.” ");
INSERT INTO dgz_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Iesu nop mega ame wan uon tani ewap, Parisi apane da taba napen men vene wan dere pa gwanap amon watara ae wanumon. ");
INSERT INTO dgz_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Parisi apane ame, Iesu naniwa bigi ya gureni yaven, ap menan Iesu Diu nagire guegue muga ya tan. Parisi apane ame yave anu bambamasen. ");
INSERT INTO dgz_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Menan Iesu apan ame anega dien, “E Parisi nagirewa, e taba naine yogupewa ge kaum naine sipewa gariwa megenat bigi guriwanin, go e potaya iragi wan dim dim koewa gui togon taiana wandia. ");
INSERT INTO dgz_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","E bumbawam nagirewa! God gariwa megenat ya tan, go gwanapewa den ap anega sia di tan. ");
INSERT INTO dgz_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ap menan imuya ge potaya kakaewa gapan, iravi kayakayawan taine nagirewa munan, ap gapan imuya etuya dere den bigi wat aiwandata. ");
INSERT INTO dgz_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Kaiwan, Parisi nagirewa itan baware yawai. Iwa kutut ugup ugup danse dena aonagaet tambuiana daiton ewagai sia God men bariana ame kakae. Go God menan koewa wat tamanam gueguewa amba God anu gurat mega gueguewa ya taiwanin. Kutut ugup ugup God men baraet anune ame umap di, go nop bawarewa derewa ame den taiwaniampen. ");
INSERT INTO dgz_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Kaiwan, Parisi nagirewa, itan baware yawai. Iwa opata waine paewa gapan watat kakae iragen gagap waniepen imuya waren taiwanin. Amba sia antaba une arewa gapan e gaunaya waenapan yaentuk mantuk diait anuiwanin. ");
INSERT INTO dgz_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kaiwan, itan baware yawai. E kaima arewa pu waboreni mini, ame waenapan bigip piup nokapewa wandeni mu asigip ya tane menan aigap tauane amuiwanum.” Iesu ap anega dien. ");
INSERT INTO dgz_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Iesu ame wani menan iup wadidiamuini apanewa anega wan, “Wadianet nugawa, Parisi nagire inamup ap waingianawa, ame nu den di diguguranean.” ");
INSERT INTO dgz_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Iesu gare wan, “Kaiwan, e iup wadidiamuiana nagirewa, e den itan baware yawai! E iup ni enowa mega anu geonageana menan, nop ega itani den waenapan ae natam wanin. Ap menan mu nop ame ware tapen menan umamup uon. Go e mu wat agoat mumapen menan ya anuiwanin. ");
INSERT INTO dgz_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","Kaiwan, itan baware yawai. E omaya baewa watageta God nop mega waiwanumune nagire guriwanumun. Omae baewa koewa ame tane e umap wayan iwa mu guriwanumune nagirewa kaima muga arewa ben tayan kwayup taiwanin. ");
INSERT INTO dgz_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Iwa inak mame venasepen menan God dima mega namu anu anega wan, ‘Ne nop nega waiwanumampen nagirewa amba watu enamot nega nagire den, Diu nagire inamup watu enamoin, amba Diu nagirewa upi guramop borit wain amba upinewa wa koeragam mumain,’ God ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ap menan, endi iniana nagire God kaimakaet wanene taeta iwa God nop mega waiwanumune nagirewa piup ma ere mangan ta venasen onin en endi mame gapan guramone menan. ");
INSERT INTO dgz_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ame tave di, watageta apane Eiboro namu ton boniga baraeni oniwandin amba apan Sekaraya God Paewa woup am seni watarewa ge man irine watarewa yaumakap ton boeni menan bop muga garewa endi iniana nagirewa inayap taueta. ");
INSERT INTO dgz_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Kaiwan, iup wadidiamuiana nagirewa, itan baware yawai. Waenapan God anupen men taine watanamuiwanin. E God ya anut anuiwanin go God anut anuine nagirewa watanamuiwanin.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Iesu ae vemo aepen tan go Parisi ge iup wadidiamuine nagire den koevet diguran amba singui gapan anenen Iesu wabambamasepi warapen menan tane. ");
INSERT INTO dgz_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Koni ap gapan, waenapan arugataet iragen da tauan, to iam iwanumune, ap mepe barat mutan, evene wai den kapet natamuiwanumun. Ap gapan, Iesu wadiamot mega namu anega wadiamon, “Buredi tutut wapen menan atagin mini enane, ap umap Parisi nagirewa nop muga watutunak gene taine men ae yao kakayasen. Iwa mu da wa da ta taine nagirewa amba mu koewa muga e imuya warepi tawa. ");
INSERT INTO dgz_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Yao kakayasen, iwa dim dim iravi ukum umine, wam evi amba God wa arogameta. Dim dim da gungunu tainewa, wam evi amba aroga taueta. ");
INSERT INTO dgz_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ap mini, nop da da muma karaua wane ame wamu amba anuin. Amba sia nop da da simura pa gwanap wanewa, ame pa namboyap oit aroga wain.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Iesu sia anega wan, “Evenan wainawa, ne wadiaepena anun. Waenapan etuya megenat toguguraep borit wai, ame mu tamu ya tai, iwa guaya den ya to koeragamain. ");
INSERT INTO dgz_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Go da tawa tapen menan wadiain. Ame God tawa daiton anun. Iwa me toguguraep borit wane go aigap sia aro amun mega wandia, ap gapan guaya merao arewa gapan uatameta. Menan, e God tawa taiwanian! ");
INSERT INTO dgz_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Nenip muguap nani yamunaet garewa muga baware uon, ame moni agim make dendeniwa dere mugenat gapan une tainewa. Go nenip iragi, daiton daiton, God munan anuiniwa. ");
INSERT INTO dgz_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ap umap sia, God iae gume daiton daiton iragi batnak itaminiwa. Ap menan tap ya anune. God enan aigap tata iwa garewa ega tapi nenip arugataet om mega garao mumen.” ");
INSERT INTO dgz_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Iesu sia anega wan, “Wapena anun. Orup da da, waenapan yaumakamup anega wapi, ‘Ne Iesu otu waiwa’ ame ne Kimani Vitana Apanewa, wam eviwa, God anea mega namumup gare anega wain, ‘Ge ne orup negawa.’ ");
INSERT INTO dgz_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Go waenapan yaumakamup orup da waboboranegepi ne God anea mega namup gare evi amba waboborain. ");
INSERT INTO dgz_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Orup da da Kimani Vitana Apanewa inanap nop koevet wapiwa, God koewa mega ameme anu ae veta. Go orup da da God Guewa inap notatae ta wapiwa, God koewa mega ame anu ae ya veta. ");
INSERT INTO dgz_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Wam evi da amba, waenapan pusia warupapen menan wat naue Diu opata waine paewa gwanap amopi, ap gapan ek tantanaya ta ta ge nop wa wa gopewa ya anune. ");
INSERT INTO dgz_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Iwa wam ame gapan nop anenen wawa Guewa Woup Seniwa amba wadiaeta.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Orup da waenapan aru ame iam wanumone berimup Iesu anega dien, “Wadianet nugawa, tatana da, mamana wan dim dim yon boreni, ame tagu mega, ae ve nun aeni, ame upi yan se nenep.” ");
INSERT INTO dgz_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Go Iesu gare wadien, “Apan negawa, bagu sisi ega tamanamepen menan orup ambe ne tat wan?” ");
INSERT INTO dgz_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Boge Iesu waenapan iravi anega wadiamon, “Ae yao kakayasen amba taiwanian! Gui togon tane tawa menan agun anu kakayasen. Apan da inak kakaewa warapen menan wan dim dim yon boreni ame inak ibariwa uon.” ");
INSERT INTO dgz_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Amba Iesu maibe gapan anega wadiamon, “Kwan puraput apanewa da at piup mega taba kakae guragut veramon amba arugataet yaniwandin. ");
INSERT INTO dgz_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Mek imua anun, ‘Taba nega aruga semo semo paewa gase bararaen. Ne dim da tain? ");
INSERT INTO dgz_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Endi ne map anega tain. Sea sea paewa benak mumain amba bawarentu tumop, amba taba ge puraput nega gwanap semoin. ");
INSERT INTO dgz_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ap tumopena nek ingane anega wain, Enda, taba puraput en aruga munan seaan. Menan wagat wanigingan amba taba kaum gega naingan amba aton taingan,’ mek ingane ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Go God apan ame anega dien, ‘Ge bumbawam apanewa. Mum ma endiwa gapan ge inak gega waseagepen, bogitai. Bogisewa taba puraput goandage waana da tambuta?’ God ap anega dien. ");
INSERT INTO dgz_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Inak mame orup da da muk munan anu gurane wan dim dim diriga aita seane tainewa. Go mu God menan ya anu tapi menan mu maup nagirewa uon, go mu bumbawam nagirewa.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Menan Iesu wadiamot mega anega wadiamon, “Ap menan ne wadiaepena anun, inak ega menan gop ya yagiai wandan. Inak ega warapen menan taba ambagan tam nai amba wanup ambagan tam enai ap menan gopewa ya anune. ");
INSERT INTO dgz_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Iwa inak wariana ame ibariwa, go taba ame gauarap. Amba sia etuya ame ibariwa go en wanup megawa ame gauarap. ");
INSERT INTO dgz_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Nenip wao guegue muga yao anun. Taba ya veriwanum, ya tuiwanum dugupa ya siwanum go God taba muga muniwan. Amba e garewa ega nenip garewa garawase aigap aen, ap menan gop ya yagiep. ");
INSERT INTO dgz_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ame den, e gop anuiana gapan borit wapen wamewa ya garawatai amba inak gega wam upi sia use intum ya tai. ");
INSERT INTO dgz_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ap menan wam otu da bobou inak ega gapan sia use intum ya taianawa iwa dimen wan dim dim aritawa men gope yagien taiwanin? ");
INSERT INTO dgz_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Endi rarema yanine ame ase anun. Mu nao ya taiwanum amba wapimu okomewa menan ya anuiwanum. Go wapena anun. Ayop Solomon kakae guragut mega arugataet go me en wanup kakaewa rarema ame enini umap da ya eniwandin. Rarema mega ame aigap iragen. ");
INSERT INTO dgz_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ap den sia, God unawat ame kwayupe tainiwa go wam daiton megenat iwa iman kurat wapi piup i nagirewa omaya irain. Menan God unawat menan ap anun taini apanewa, enan den taiwan. Ap menan sisi kwayup aigap di ta eneta. Kaiwan, e God inap otu da anu tumasiana nagirewa. ");
INSERT INTO dgz_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Menan, taba kaum ega yoa ya tane. Imuya gop ya anuiwanian. ");
INSERT INTO dgz_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Iwa God tandayasine nagirewa, at at iragi, wan dim dim mame miniwa yoa taiwanum. Menan Mamaya kimaniwa bagu sisi egawa asigip tan. Menan gop ya yagiep taiwanian. ");
INSERT INTO dgz_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Go gare, inak ega gapan namu iragen, God toemuewa yangure taiwanian. Amba gare God taba en wanup ega den eneta.” ");
INSERT INTO dgz_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Iesu sia anega wan, “Menan waenapan nutuya uoni nagirewa, e gop ya anune, iwa Mamaya toemu mega amunewa atonu den enat anuiwan. ");
INSERT INTO dgz_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Puraput ega ase une tan amba moni ame purapuse uoni nagirewa munan. Ap gapan moni ige egawa bebep ya wata iwa garewa ega kimani barene wandepi uon ya tata. Amba sia aupa up nagire da up ya tain amba kensere ya ketnak nata. ");
INSERT INTO dgz_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Iwa, e puraput ega kakaewa ambagan wandini, imuya potaya ap wandini arewa gapan ap mepe den wandia.” ");
INSERT INTO dgz_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Iesu sia anega wan, “Pa ayope da nao mega taiana nagirewa umap wanien. Ayop ame naine mutat baripe napen menan aepi, ago mega pa amat taiwanumain. Sia taue, tonan ken ken topi ago mega serarat watapain. E ap umamup en wanup ega en en kakayat tan, aitambu wantambu tan, nene yamam taiwanian. ");
INSERT INTO dgz_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Tavewa di, ago nagire wanumo nene yamam taiwanumampina pa i apane taue yawamopi mu aton anuin. Amba pa i apane en wanup mega kakaewa entan ta nao nagire wanupewa eneta amba, ago nagire megawa ae wanumot diamo amba taue taba muga muneta. ");
INSERT INTO dgz_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","I apane mum gagap o woup yumewa gapan sia entan pa tauepi ago mega nene yamam taiwanumampina yawamopi, mu aton anuin. ");
INSERT INTO dgz_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Amba sia anu awan. Pa i apanewa wam ansena up apane tauepi anupo nene yamam ta wandepo, gapan up apane warup oisepo, amba pa mega ya benak unuk aepo. ");
INSERT INTO dgz_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ap mini Kimani Vitana Apanewa wam ansena sia tauapena e oare, ap menan yama agun taiwanian.” ");
INSERT INTO dgz_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Apan Pita Iesu singui wayaven, “Ayop nugawa, ge maibe ame nunan waan o waenapan iravi munan den waan?” ");
INSERT INTO dgz_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ayop Iesu maibe gapan gare anega wan, “Pa i apane nao mega taini asigip ta noa warini apanewa ware pa mega kwayup tapen dien. Amba nao mega taini apanewa ame ago nagire upine taba muga muga muniwandapen menan die amba at ugupe daio aen. ");
INSERT INTO dgz_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","I apane ae sia entan tauepi wamewa gapan, nao waneni apanewa nao mega taiwandapina yavepi nao taini apanewa ame aton arita anuta. ");
INSERT INTO dgz_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ame menan, pa i apane puraput mega iragi kwayup tapen dieta. ");
INSERT INTO dgz_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Go nao taini apanewa mek anega anupiwa, ‘Ne ayop nega menawaet ya taueta.’ Ap anuni menan, nao nagirewa upinewa gaura bim bim guramo ae semon amba nao ae ve taba kaum kaimake dena na, bumbawam ta aiwandata. ");
INSERT INTO dgz_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ap taiwandapina, pa i apanewa tauepi wamewa me oare iwa me menan amat ya taiwandin boge me taueta. I apane taue gamu to keketnage semu semu ta ae se amba God ya anu tumasene ge borit wane nagirewa at muga gapan baraeta. ");
INSERT INTO dgz_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ap menan, nao taini da ayop mega noa anun go amat nene yamam ya tapi ame garewa gaura kaimakaet to papaunageta. ");
INSERT INTO dgz_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Go nao taini apane dawa ayop mega noa ya anu aven menan koevet tani ame garewa gaura otu kamontu tota. God nao mega baware enepi ame garewa baware warapen anuiwan. Amba aigap sia enepi garewa aigap sia warapen anuiwan.” ");
INSERT INTO dgz_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Iesu sia anega wan, “Ne piup ma omaya iramopen men tauan. Tave di, ne namunap iramopo ame kakae! ");
INSERT INTO dgz_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ne itan ugu vegaek anu tanapena ame dup mini ianegepi wandia. Tave di, serarat dup ianegepo, ame kakae iwa ne nononga anu sisimepena tandaewa anuivin. ");
INSERT INTO dgz_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ne pia nonup enapen tauat anuiwanin go ap menan ya tauan. Ne seu todumapen tauan. ");
INSERT INTO dgz_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ap menan, endi mame use aeniwa, waenapan nani yamunaet pa daiton inine nugut mumain amba derewa yone yampoa den gare gare nenan notatae wain. ");
INSERT INTO dgz_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Apan otua dere gare gare nenan notatae wain. Waen orewa dere waginiwa ewa dere nenan notatae wain.” ");
INSERT INTO dgz_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ap mepe, Iesu waenapan sia anega wadiamon, “E yangut tane amba irikup gwagwara yawane anega wai, ‘Ma ugin taueta,’ ame boge ugin di taueta. ");
INSERT INTO dgz_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","At sirit bubup tapi yawane anega wai, ‘Endiwa amun viseta,’ ame boge di viseta. ");
INSERT INTO dgz_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","E da wa da ta taiana nagirewa. E piup ge kiman gwanewa guegue mega anenen venasini yawa wat mega, ame asigip tayan. Go iwa dimen God endi dim dim da tainiwa ya anu aviwanin?” ");
INSERT INTO dgz_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Iesu sia anega wan, “Amba sia, iwa dimen guegue kakaewa koewa ya anu aviwanin? ");
INSERT INTO dgz_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Evenaya koewa ega men diguguraepi amba nauyae wanene nagirewa namumup aisene tawa menan e namu baigan tapen neginewa yop taiwanin. Iwa baigan ya tanewa, apan ame nauyae wanene nagirewa namumup yonane amba wanene nagirewa punip nagirewa nanip seaep, amba gwat noke gapan seaep wanien. ");
INSERT INTO dgz_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Wapena anun. Gwat noke seaepi ap mepe di waniai. Evenaya garewa mega iragi seane amba e tau aitai,” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Wam ame gapan, waenapan upi ap mepe wanumone Iesu inap anega wan, “Galili nagire da God men man gure iriwanumune ayop Pailat ita mega nagire tauan toguguramon borit wan.” ");
INSERT INTO dgz_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Iesu gare anega singui wayawamon, “Endi e anuiwanianawa, ian Galili nagirewa inak muga koevet iragen menan mu ap anega borit wane? Amba Galili nagirewa upinewa koewa muga baware uon menan ya borit wan? ");
INSERT INTO dgz_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ap menan uon! Ne wadiaepena anun. E imuya potaya ya entan tanewa, mu umamup e iravi borit wai. ");
INSERT INTO dgz_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Amba sia, wata waenapan aonagaet pusin yamunaet pusin yamu yampo (18) at Sailoam, Ierusalem gapan, wanumone pa nononga da beure aigamup geare natamon borit wan. E anuiwanianawa mu inak muga koewa bumagap iragen aeni menan borit wane amba upinewa, Ierusalem gapan wanumuine, mu umamup uon? ");
INSERT INTO dgz_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ap da uon! Wapena anun. E imuya potaya ya entan tanewa, mu umamup e iravi borit wai.” ");
INSERT INTO dgz_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Iesu maibe gapan anega wadiamon, “Apan da egak mega gapan oma baep veren yaniwandin. Me tavewa iepi menan nawan tani yangut taiwandin, go me tavewa da onep ya yaven. ");
INSERT INTO dgz_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Menan me egak kwayup taini apane inap anega wan, ‘Yao, oma ma en yampo gapan, ne ongingin baip ma tavewa da iepi menan nawan tanan taivin go da ya yaviangin. Menan ge to ae barao. Iwa dimen wanden, piup taba mega mondi wapasimiwan.’ ");
INSERT INTO dgz_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Go kwayup taini apanewa gare anega wan, ‘Ayop negawa, ae vea bodu daiton megenat sia wandep yawat, amba ne piup sia enu, noa borap denanu aigap seap. ");
INSERT INTO dgz_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Amba oma mame bodu uta namunupewa tave iepiwa, ame kakae. Go ya iepiwa, amba to ae bat.’” ");
INSERT INTO dgz_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Diu pura muga bawarewa wamewa gapan da, Iesu Diu nagire opata waine paewa gwanap wadidiam wandin. ");
INSERT INTO dgz_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ap mepe, waen da airampu wareni menan vek tan amba gari wakautamen yon iwandin en aonagaet pusin yamunaet pusin yamu yampo (18) uon tan. ");
INSERT INTO dgz_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Iesu waen ame yaveni anega dien, “Waen nega, ne vek gega endi mame di vesiangin.” ");
INSERT INTO dgz_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Boge Iesu naniwa waen ame aigap baraeni gapan, no utap gariwa endimasen tamana tan, yon wande amba God wa atonasen. ");
INSERT INTO dgz_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Iesu wagat wame gapan wat inakameni menan Diu opata waine paewa ame aritawa apanewa da gari gangan naen menan waenapan anega wadiamon, “Pura daiton gwanap, ame wam nani yamunaet nani yamu daiton nao ta ta wamewa wanumam. Menan wam ap me gapan inak warapen menan onaen go pura nuga bawarewa wagat wamewa gapan umap uon.” ");
INSERT INTO dgz_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Amba Iesu gare anega wadien, “E da wa da ta taiana nagirewa! Pura bawarewa gapan e den nao taiwanin iwa kaum munapen menan man kao ge man donki ega vetayan kaum napen men tam naumo aisiwanin. ");
INSERT INTO dgz_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Waen ma, watageta apane Eibaraam naewa, go Seitan panen vek mega en aonagaet pusin yamunaet pusin yamu yampo (18) wande en. Iwa dimen waen mam pura bawarewa wamewa gapan vek mega ya wat vetat dianek wanin?” ");
INSERT INTO dgz_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Iesu nop mame wani menan, enu yawan waiwanumune nagirewa iragi umam wa guguramon. Go waenapan, Iesu nao kakae guragut ame taiwandini menan aton taiwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Iesu sia anega wan, “God toemu mega amunua dim da mini? Guegue ansena da wapena amba e anu kakayatai? ");
INSERT INTO dgz_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Guegue mega ame, oma baip makewa naewa mini. Naewa ame otu koentu go apan da vereni kai ware oma baware tan amba pu nenipewa onep dugup warane, nat enane ininewa.” ");
INSERT INTO dgz_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Iesu sia wan, “Guegue ega ansena da wapena God toemu mega anu awai? ");
INSERT INTO dgz_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Waen da, buredi tutut wapen menan atagin mini potap wa damage kwaviro tan iravi tutut wan. God toemu mega ap anega.” ");
INSERT INTO dgz_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Iesu pa Ierusalem aiwandini gapan pa sewa otu koewa bawarewa den tau ge tau ae wadidiam wandin. ");
INSERT INTO dgz_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Apan da singui wayaven, “Ayop nugawa, iman waenapan aruga o otu dere mugenat inak ewakewa tautanain?” Iesu gare anega dien, ");
INSERT INTO dgz_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Anun, kiman tonanewa kampon kampon ap menan kaimakaet utu unuk dotou aisepen menan tan. Iwa iman waenapan aruga unuk amopen menan tain go mu ya unuk amoin. ");
INSERT INTO dgz_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ap gapan, pa i apanewa yone tonan toboreta. E pa garip waniene tonana ere ken ken to anega wai, ‘Ayop nugawa, tonan nunan watap.’ Go me gare wadiaeta, ‘Ne ya asiginap, e amba tauayan waiwanin?’ ");
INSERT INTO dgz_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Amba e anega wai, ‘Taba kaum tautanaget nainton amba ge pa nuga namboya opata wadidianean.’ ");
INSERT INTO dgz_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Go pa i apane sia gare anega wadiaeta, ‘Ne e oare, e amba tauayan waiwanin? ae venek asira aisen, inak koe koevet taiana nagirewa!’ ");
INSERT INTO dgz_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Wam ame gapan, ap mepe irip turup wan, ni kweramen asiginimen taiwaniai amba watageta apane Eibaraam, me otua Aisik amba upewa Diekap ge God nop mega waiwanumune nagire den God toemu mega gapan wanumuine yawamoi, go e garip inkae ankae wa irip waiwaniai. ");
INSERT INTO dgz_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Wam ame gapan, waenapan piup at at iravi tauan God toemu mega gapan taba nain. ");
INSERT INTO dgz_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ap menan, endi evi yonine nagirewa, wam ame gapan, mu namu yonain. Amba endi namu yonine nagirewa, wam ame gapan, mu evi yonain.” ");
INSERT INTO dgz_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Wam ame gapan Parisi nagire upi Iesu ine tauan anega wadien, “Ayop Erot toget anuiwan. Ap menan ge at ma ae ve, ak.” ");
INSERT INTO dgz_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Go Iesu anega wadiamon, “Aisen, ebo aopan apanewa ame manega wadian, ‘Ge anu, endiwa amba imanawa ne airampu gut oimop amba den vek nagirewa wat inakam mumivin. Go wam yampoa nao nega uon tata.’ Nop mame apan Erot wadian. ");
INSERT INTO dgz_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Go endiwa amba imanawa den ne angina neginewa gapan di angingain pa Ierusalem amba tauain. Iwa, God noa waini apanewa amba amba da togurep boepi ame tamana uon. Go Ierusalem gapan megenat di togurep boeta!” ");
INSERT INTO dgz_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Menan Iesu Ierusalem menan anega wan, “Ierusalem, O Ierusalem nagirewa! God noa waine nagirewa guramuiwanian borit waiwanum upi inayap watu enamoni agima guramuiwanian. Wam wam aruga kumkum otu wai ai bongamen magua gauarap enini, ne ap umap waenapan gega ai dangonet anun taivin, go e ap anega ya tat anu nimanegiwanin! ");
INSERT INTO dgz_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ap menan yao, God Paewa, Ierusalem gapan, konintu amba pokaet wande aiwandata. Amba iman e sia ya yawanegai. Go wam ansena evi da amba e ne inanap anega wai, ‘Ayop yaua amunewa gapan tauiagi, ap menan God wat aipakam gimagia,’ ap gapan, ne sia yawanegai.” ");
INSERT INTO dgz_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Pura bawarewa wamewa da gapan, Iesu Parisi ayope da pa mega gapan taba napen men aen. Mu ap mepe wanumone, waenapan me ebo da wapi anupen menan kem kem yaviwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ap gapan, vek ugu wapi, tutut tatat wani apane da Iesu ine tauen. ");
INSERT INTO dgz_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Menan, Iesu Parisi ge iup wadidiamuine nagire den singui wayawamon, “Endi wagat wame gapan wat inakamepenawa iup nuga paina yamatain go?” ");
INSERT INTO dgz_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Go mu singui mega garewa da ya wan, no uon wanumone. Ap menan Iesu vek apan ame ware wat inakame watu enen aen. ");
INSERT INTO dgz_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Amba Iesu sia wayawamon, “Pura bawarewa gapan, e otuya o man ega da kaum menan urat warane urasewa gapan gearepi, wagat wame gapan serarat warupai go uon?” ");
INSERT INTO dgz_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Nop ame anune go garewa wapen menan umap uon, menan no uon di wanumon. ");
INSERT INTO dgz_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ap mepe, Iesu yawamoni, waenapan taba napen menan tauan go iravi watat kakaewa gapan wanumopen menan nanamu taiwanumun. Ap menan maibe gapan anega wadiamon, ");
INSERT INTO dgz_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Apan da naine mutapen baripe genan wapi, watat kakaewa da yop ya ta, wanige, iwa apan bawarewa da evi tauepi menan, ");
INSERT INTO dgz_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","barip i apane, e dere enan wani, go inagap taue anega wadiageta, ‘Bawarewa taueni menan watat gega mame apan ma ve wan,’ ap anega wapi umame den etop asira age ae wanigai. ");
INSERT INTO dgz_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Go guegue ame ya tane gare ma tan. Genan wapi etop wainge amba i apane taue yawagepi anega wata, ‘Enda, at ma ae ve age watat kakaewa paina ao gapan wainge.’ Ap anega wapi, waenapan ap mepe wanumopi viriga tain. ");
INSERT INTO dgz_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ap umap sia, orup da da muk ingane ao wat bawaramene tainewa ame God aoma wat otutam mumeta, amba waenapan da muk aoma wat otutamene tainewa ame God ao wabawaram mumeta.” Iesu anega wan. ");
INSERT INTO dgz_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Iesu barip i apane, Parisi apane ame, inap anega wan, “Ge wam ianupewa o mum gine tabaewa napen menan, evenak waigawa o tatak gwanik amba dugup gegawa o evenak waiga pa mainagape puraput dena nagire munan ya wa. Iwa mu wam da gare genan wain ap menan ge garewa gega ewagai warai. ");
INSERT INTO dgz_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Go barip tawa, puraput uoni nagire, enkana ankana nagire, pusi berok mutanewa nagire amba yame borat mumeni nagire munan wa. ");
INSERT INTO dgz_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Waenapan ame garewa gega ya genain, ap menan God wat aipakam gimageta. God wam uiwa gapan wapi ame kakae tane borit wane nagirewa inak muse sia yon wanumopi ap mepe garewa gega warai.” ");
INSERT INTO dgz_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Orup da, ap mepe Iesu den naiwandini, nop ame anuni menan anega wan, “Waenapan God toemu mega gapan taba naiwanumampina ame aton aigap anuin.” ");
INSERT INTO dgz_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Boge Iesu apan ame die anega wan, “Ne gutut wapena anun. Apan da barip baware tapen taiwandin waenapan arugataet da munan sep baraen. ");
INSERT INTO dgz_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Barip wamewa gapan, barip i apanewa ame nao nagirewa wa oimon amo gaset sep munan wani nagirewa wadiamon anega wane, ‘Onaen, wan dim dim iragi ta seton amat wandia.’ ");
INSERT INTO dgz_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Go mu iravi imumu daiton tan tanda di wane. Apan namua sep apane anega wadien, ‘Enda, sintan nega ma anu. Ne at piup ewake une tana yawapen angewan barip gage ya ongain.’ ");
INSERT INTO dgz_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Apan da sia anega wan, ‘Enda, sintan nega ma anu. Man kao nega aonagaet une tana menan ange upa semo yawapen taivin ap menan barip gage ya ongain.’ ");
INSERT INTO dgz_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Amba apan da sia anega wan, ‘Ne waen ewake naitan menan barip gage ya ongain.’ ");
INSERT INTO dgz_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Boge sep apane sia entan taue barip i apane oit muga wadien. Barip i apane gari gangan naen anega wadien, ‘Serarat ak! negin negin, pa namboe namboe ame gapan kaya kayawan tanewa, pusi nani koe tanewa, yame borat mutanewa amba dai tanane nagirewa iragi wa upam onaen.’ ");
INSERT INTO dgz_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Sep apane ae amba entan sia taue anega wan, ‘Ayop negawa, wadianegeana di tan. Waenapan tauan go pa ya barat mutan.’ ");
INSERT INTO dgz_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ap menan, barip i apane sia wadien, ‘Waenapan pa nega barat mutapen men sia ak nein nein iragi yop ta waenapan yawamoa kaimakaet wa naumo onak,’ barip i apane ap anega dien. ");
INSERT INTO dgz_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ne wadiaepena anun. Waenapan namu venamu di wana nagirewa, mu barip nega da den ya tananek nain.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Wam da, Iesu waenapan aruga tautan amuiwanumune gapan, Iesu inamup anega wan, ");
INSERT INTO dgz_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Waenapan da da ewanap yonat anupi nenan anu gurat aigap anup. Ine mame, waene otu, tase gwani, domare waiwa amba mek inak megawa ya tandayat mumiwandapinawa ame ne wadiamot nega ya di tain. ");
INSERT INTO dgz_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ap menan, orup da da ne yauna menan ugu vegaek bagu sisi anu, evinap ya onamopiwa, ame ne wadiamot nega ya di tain. ");
INSERT INTO dgz_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ame anupen menan nop ma anun. Orup da pa nononga ao tu dorat anupiwa, me namu ae wande, moni om ta, pa ame tu wabora bora omewa wat nugut ae barepi amba pa ame tuta. ");
INSERT INTO dgz_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Me namu ap ya tapiwa, pa ibariwa sewa megenat ene ae veta iwa moni umap uon, ap gapan konintu wanumone nagirewa yave wawa koko anega wain, ");
INSERT INTO dgz_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Apan ma pa tut wa tani go ya tun waboria,’ ap anega wain.” ");
INSERT INTO dgz_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Iesu maibe dawa, gine daiton, anega wan, “Nop da sia mam. Ayop da yone ayop dawa inap anan warat anupiwa me namu ae wande imua upe se anega anuta, ‘Ne ita nega nagire 10,000 den go me ita mega nagire 20,000, nu garao mumait go?’ ");
INSERT INTO dgz_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Uon anupi, anavi mega wandap onam wanumampina gapan me nao nagirewa sep watu enamo nonup warup barepen noa wain. ");
INSERT INTO dgz_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ap umap, dim dim ega da ae ya veanewa, wadiamot nega ya tai.” ");
INSERT INTO dgz_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Amba Iesu sia anega wan, “Siuran kakae, go dansewa mega menawaet ninen garepiwa, ap gapan e anenen tane amba dansewa sia wata? Ame umap uon. ");
INSERT INTO dgz_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Dansewa mega ap uon tapiwa, waenapan taba kakae sia tapen menan den ya danamain go siuran ame denanu mini aipa uare ae di veain. Darinaya den wandepi wana anun.” ");
INSERT INTO dgz_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Wam da, moni bongamine amba koewa taine nagirewa Iesu nop mega anupen menan tauan. ");
INSERT INTO dgz_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Parisi ge iup wadidiamuine nagire yawamone gunare den anega wan, “Iesu koewa taine nagirewa waupamo taba tanamon naiwan.” ");
INSERT INTO dgz_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Menan Iesu maibe gapan anega diamon, ");
INSERT INTO dgz_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“E orup da man sip gega apane nani yamunaet (100) inagap wanumopiwa. Wam da man sip daiton wakaumewa, ge man sip upinewa 99 pua ae vemoi, daitona ame yoa agai. ");
INSERT INTO dgz_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Daiton ame yawawa, ge aton aigap di anui amba man sip ame wara onegap barae wat ongai. ");
INSERT INTO dgz_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ge pa gega tauawa gapan evenak waigawa, pa mainagape wanumune nagirewa den munan wap onamop anega wadiamoi, ‘Aton anuivin iwa man daiton wakaumana go yop tan amba sia waran.’ ");
INSERT INTO dgz_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Menan endi wadiaepena anun. Gutut mame wana ap umap sia, orup daiton inak mega koewa tainiwa, me imu posewa amba inak megawa wat entan tapi menan kimani, anea iravi den, atonua aigap iragen anuin. Go waenapan upinewa (99) ame mu koewa muga uon anune menan, kimani, anea iravi den, inamup aton otu kamontu anuin.” ");
INSERT INTO dgz_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Iesu sia anega wan, “Amba sia, waen da moni gwat make mega aonagaet inap. Daiton wakaumepi, me dun ire pa kuyokuyo to, yambuni yop tapi amba yaveta. ");
INSERT INTO dgz_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Yavepi evene wai pa mainape den munan wap onamop anega wadiamota, ‘Aton anuivin iwa moni nega wakaumana sia waran,’ ap anega wata. ");
INSERT INTO dgz_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Menan, endi wadiaepena anun. Maibe wana ap umap sia, orup daiton inak mega koewa entan tapi menan aupa kimani God anea mega aton baware di tain.” ");
INSERT INTO dgz_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Iesu anega wadiamon, “Apan da otu wai dere. ");
INSERT INTO dgz_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Gwaniwa mamewa anega dien, ‘Maman, kwan puraput yan se negawa nen.’ Menan mamewa seu enu yan se tase dere di munen. ");
INSERT INTO dgz_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Wam animpo mini amba, gwaniwa tambuni ao yone at wandap da di aen. Ae erere goyago ta di danamen. ");
INSERT INTO dgz_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Iravi wakaumeni amba at ame gapan wankakau baware da tau aen, ap mepe enup aren. ");
INSERT INTO dgz_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ap menan me ao yone at ame apane da inap nao wat nasen, amba apan ame tuan mega amat tamuiwandin. ");
INSERT INTO dgz_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Tuan kanu etua tunu munen naiwanumune me den nat anun, go waenapan da kanu ya wanane. ");
INSERT INTO dgz_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Wam ame, anu aven namu anenen taiwandiniwa, mek anega anun, ‘Maman nao mega nagirewa antaba arugataet naiwanum, go ne mapa enup aranegiwandin bop konintu tapen taivin. ");
INSERT INTO dgz_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","At ma ae veap ewagai angep tauap mamana inap anega wain, Maman, koewa God inap tan den inagap tana kakae uon. ");
INSERT INTO dgz_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ne otuga dianek dianek go ne kakae uon, go tanege nao ayamat gega taine apanewa mini da tap.’ ");
INSERT INTO dgz_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ap menan otua at ame ae ve yone mamewa ine di aen. Otua isipa wandap oniwandin gapan, mamewa yaveni otua menan bagu sisi anun. Boge mamewa serarat ae dana taun ua ton. ");
INSERT INTO dgz_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Otua anega wan, ‘Maman, ne koewa God inap tan den inagap tana kakae uon. Ne otun dianek dianek ne kakae uon.’ ");
INSERT INTO dgz_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Go mamewa nao nagire megawa diamo anega wan, ‘Serarat wanup gogotaewa wat onaen pan wanan. Den naniwa kwasip wat enan ge pusi okomua en wanan. ");
INSERT INTO dgz_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Amba man kao otu uruavewa togurane barip tat wat aipakamepen. ");
INSERT INTO dgz_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Iwa otuna boen, go endi me inakaen, me wakaumat anun, go endi tautananegia,’ wani boge barip menan tugun wat aipakamene. ");
INSERT INTO dgz_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Koni ap gapan, tasewa egaga iwandin. Ame onin e pa auge taueni, sinao tarep doak ame anun. ");
INSERT INTO dgz_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Menan nao taini apane da vene wan onen singui wayaven, ‘Utu dimen sinao tarep taiwanin?’ ");
INSERT INTO dgz_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Nao taini apanewa ame gare anega wan, ‘Gwaniga sia tauen menan mamaga yone man uruavewa da toguren mame barip tuguiwanum, iwa me inak ware pa sia taueni menan.’ ");
INSERT INTO dgz_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Tasewa nop ame anuni gari gangan naeni menan pa gwane ya unuk aen. Menan mamewa garip taue ae nanamasen pa gwanap onapen dien. ");
INSERT INTO dgz_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Go otua ame anega wan, ‘Maman, wapena anu. Ne en arugataet inagap waingen ayamat taingin amba nop gega waingiana ame noga da ya to kayasen taingin. Go ne ap taingina menan man da ya nenan amba barip evenan waina den ya tanam nan. ");
INSERT INTO dgz_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Go ge otuga ame, yone moni gega ware negin gagape waene wai muniwandin uon tan, ma pa taueni amba ge yonaan man uruavewa da togut wanaan.’ ");
INSERT INTO dgz_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ap wani menan, mamewa gare anega wan, ‘Otunawa, ge wam wam inanapaet waingianawa, menan wan dim dim nega ame iravi gegawa. ");
INSERT INTO dgz_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Go endi onge wat aipakamet aton tapen, iwa gwaniga mam boet anutoni, go inak ware sia tauen, me wakaumat anutoni go me sia tautananen.’” ");
INSERT INTO dgz_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Iesu wadiamot mega gutut ma anega wadiamon, “Puraput apane da nao mega kwayup taini apane den wanumon. Orup upine tauan i apane ame anega wadian, puraput gega kwayup tainiwa upi ebo aopan tan wakaumiwan. ");
INSERT INTO dgz_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Menan, i apane apan ame menan wan taueni anega wadien, ‘Oitaga anuina ma dim da gapan? Ge daragi moni nega anenen taana oisewa wadianek, iwa endi ne wa tonak gimagian, nao gega mame uon di tan.’ ");
INSERT INTO dgz_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Puraput kwayup taini apane mek ingane anega anun, ‘Endi map anenen tain? Aritawa nega nao nega ae veat dianegen. Ne nao piup tupen menan umap uon amba den mondi moni menan mup ae wainga wainga umam anuin. ");
INSERT INTO dgz_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","O, endi gase anuna. Ap tapena gatawan nao nega mapa wakaumapena, evenan waina aruga pa muga muga gapan waup nimanegain.’ ");
INSERT INTO dgz_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ap anega anuni menan, me manega tan. Manapawa, ayop mega inap, waenapan da da moni totnagene nagirewa munan wan tauan. Apan namu inap taueni singui wayaven, ‘Enda, ge ayop nega moni puakewa garewa animpo wanapen wandia?’ ");
INSERT INTO dgz_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Apan ame gare wan, ‘Ae, ne kaum ganip monewa mini udan baware 100 wanapen wandia.’ Ap anega wani menan, kwayup taini apane manega wan, ‘Umap, garewa gega ogewa ma wara, ae wanik, amba ugup da manega se, ame udan baware 50 wanapen megenat ogewa se.’ ");
INSERT INTO dgz_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Apan dawa taueni kwayup taini apane singui wayaven, ‘Ge ayop nega garewa animpo wanai.’ Apan derewa gare anega wan, ‘A, ne garewa taba uit kaenat enana 1000 wanapen.’ Ap anega wani menan, kwayup taini apane sia anega wan, ‘Garewa gega ogewa wara ok manega se, taba uit kaenat enapena 800 megenat wanap.’ ");
INSERT INTO dgz_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Kwayup taini apanewa eboewa ap anega taiwandini. Amba ayop mega oisewa ame anuni gapan kwayup taini apanewa wa atonase anega wan, ‘Ge asik taana apanewa.’ Ayop mega me wa atonasen iwa piup gapan koewa nagirewa iamupe baware taiwanum go God ganat mega nagirewa iamupe baware ya taiwanum. Ap menan kwayup taini apanewa puraput gapan waenapan aruga evenan tamoni mini taiwanian. ");
INSERT INTO dgz_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Menan, ne wadiaepena anun. Piup monie purapuse gapan piup nagirewa aton muningan amba evenan taingan, iwa evi amba puraput ega uon tapi gapan evenak waigawa yaibobot paewa gapan waup gimagain.” ");
INSERT INTO dgz_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Amba Iesu sia anega wan, “Waenapan guegue muga manega, orup da wan dim dim otu kamontua tamana di kwayup taiwandapinawa, evi amba wan dim dim bawarewa tamana di kwayup taiwandata. Go orup da wan dim dim otu kamontua ebo aopan gapan ta koeragamepiwa, evi amba wan dim dim baware den ebo aopan gapan ta koeragameta. ");
INSERT INTO dgz_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ap gapan sia, ge piup monie purapuse ebo aopan gapan wa koeragam taianawa. God den ya anu tumat gimageta iwa me kimani yaibobot kakae guragut megawa ge wakaumewa tawa. ");
INSERT INTO dgz_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ap sia den, waenapan puraput muga genane go ge yambuni kwayup ya taana menan puraput upine garaet gegawa da ya genain. ");
INSERT INTO dgz_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Amba nao apane da aritawa mega dere wanumopiwa, ame gauaramup nao ya taiwandata iwa aritawa mega dawa menan anu guriwandata amba dawa anu koeamiwandata. Da noa wareta, amba da tandayaseta. Ap umap God men anuiana moni tandayatai moni men anuiana God tandayatai.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Nop ame wani, Parisi nagire Iesu nipep diane iwa mu moni menan anu gurine nagirewa. ");
INSERT INTO dgz_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Menan Iesu gare anega wadiamon, “Ek kakaewa ega waenapan wadiamuiwanin go God imuya yaviwan. Waenapan dim dim yave imua waren menan anu gurane tainewa ame God yamap aninke den. ");
INSERT INTO dgz_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Iup namua God nop mega waiwanumune nagire nop muga den oniwandin en amba Dion tauen. Dion taueni God Nop Oit Kakaewa ap gapan endi ma onini, menan waenapan aruga opata gapan wadidiam wanumam. Ame gapan den waenapan iravi God toemu mega muk use enu wanane, unuk amopen menan taiwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Go piup ge kiman wat mutapen ame bemta go God iup mega namua semu otu koentu ase muta muta umap uon, kaimake iragen. Menan, iup namua wande aiwandata. ");
INSERT INTO dgz_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Apan da waenewa ae ven amba waen da ugup sia naisepiwa, ame inak koewa wainan gogo taiwan, amba waen memewa ae ven apan da ugupewa sia naisepiwa ame inak koewa wainan gogo di taiwan.” ");
INSERT INTO dgz_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Iesu gutut da anega wan, “Ap mepe kwan purapuse dena apane da me en wapagin mega tutup dena wat ene pot pot antaba kakae guragut na aigap dore iniwandin. ");
INSERT INTO dgz_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Me pa mega tonanewa gapan dai apane da yaua Lasiros ugu wapi e omasi den wande en, amba wan dim dim mua wainiwa. Menan pot pot wat tauan tonana bariwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Apan kwan purapuse dena ame antaba napi semuroro pia geamopi aibu napen menan anu wanden, amba eyao den tauan omat mega yamot naiwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Evi amba Lasiros wam mega tauen boen, amba anea kimani vitan waran amon omae baewa Eibaraam mainep baraen. Ame ewap, kwan purapuse dena apane bop tan tune. ");
INSERT INTO dgz_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Boeni amba ae koewa nagirewa borit wane amone wanumuine arewa gapan wande ugu wapi vege wa guren, yangut ao tani Eibaraam wandap da aupa yaven, Lasiros mainep den wanden. ");
INSERT INTO dgz_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ame yaveni menan, ven anega wan, ‘Maman Eibaraam bagu sisi nenan anu! Lasiros watu ena vit one nani piru kauma antapene merinap baraep wat iroramep, iwa ne oma meravewa gapan waingen yaginegiwan!’ ");
INSERT INTO dgz_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Go Eibaraam gare wan, ‘Otunawa ma yao anu, wataget piupa kabani waingeana wamewa gapan wan dim dim kakae guragut inagap no tantan, go Lasiros wan dim dim menan wat ire taiwandin. Endi me mapa kakaewa gapan yaentuk wandia, ap garewa ameme waingean oma yagiriwandin vek anuingi. ");
INSERT INTO dgz_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Amba den endi mame e amba nu yaumakanup bumak kapit kanama da garaet ta baraene wandia, menan orup da da mapa enan asepagan ya onamoin gare amena nunan mapagan ya onamoin.’ ");
INSERT INTO dgz_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Menan purapuse dena apane sia anega wan, ‘Kaiwan, Maman Eibaraam, ne inagap waiangin, Lasiros watu ena vit ae mamana pa mega tauep. ");
INSERT INTO dgz_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Iwa, ap mepe, ne gwanin waina nani yamunaet vemo ongen wanumamun. Ame darine enumop, mu oma merao arewa mame tauepi tawa.’ ");
INSERT INTO dgz_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Go Eibaraam gare anega wan, ‘Ae, apan Mosis iup megawa amba God nop mega waiwanumune nagire ok semonewa, aipa inamup wandia. Mu ap gapan yave anuin.’ ");
INSERT INTO dgz_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Go purapuse dena apane sia anega wan, ‘Ae, Maman Eibaraam, ame ya umap. Go apan da namu boe sia inakae yon wande inamup aepi, ame nop mega anuin amba imumu gapan entanain.’ ");
INSERT INTO dgz_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Go Eibaraam gare sia anega dien, ‘Go mu apan Mosis amba God noa waiwanumune nagirewa nop muga den ya anu warepiwa, ame boeni otua da sia inakae yon wandepiwa, nop mega den ya anu warain.’” ");
INSERT INTO dgz_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Iesu wadiamot mega anega wadiamon, “Waenapan da da pusia di warup yawain, go kaiwan ta parisepi apanewa. ");
INSERT INTO dgz_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Iwa ta pariset apanewa agim kanama da megap pansin antapene me ware puimania uat enepi, ame kakae iwa evi sia aro uoni nagirewa upi ta koeragam mumepi tawa. Go ame otu koe, iwa ta pariset apanewa me wanene aigap wareta. Gwat itani den megamup tau sisinamo puimani pakit uasep borit wapi ame umap di. ");
INSERT INTO dgz_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ap menan yambuni wanien! Ame gapan den, tatae gwani koewa da tapiwa, me koewa mega vetavet tapen menan, kaimake den di dia wa. Me vetaet tapiwa, ame gapan koewa mega anu ae ve. ");
INSERT INTO dgz_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Amba den, me wam daiton gapan, koewa nani yamunaet yamu dere ge inagap ta amba koni nani yamunaet yamu dere taue anega diagepiwa, ‘Ne vetavet taivin,’ ame wapi ge koewa mega anu ae ve.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Iesu watu enamot mega Iesu anega dian, “Nu aigap sia anu tumat gimagepen menan wat agoat niman.” ");
INSERT INTO dgz_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Me gare anega wadiamon, “Oma baip make naewa otu koentu. E otu ap umap anu tumat nimanegene ame aroe gapan oma mokot ata anega diane, ‘Visik den ao bun yon wanik, ak puimania ae yan,’ ame no utayap di tata.” ");
INSERT INTO dgz_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Iesu anega wan, “Nao ega taine nagirewa inamup anenen anuiwanin? Egaga nao taini o man ega kwayup taini ame mum gine entan pa tauepiwa ge anega ya diai, ‘Serarat onak ae wanik, taba wat na.’ ");
INSERT INTO dgz_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Go gare manega wadiai, ‘Ak, taba nega da ta nen. Taba naingapena amase ge nenan bongam bongam ta amat wainge. Ne naitamepena amba ge taba gega ewap amba na.’ ");
INSERT INTO dgz_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Nao gega taini apanewa wadiana gapan tapi menan gaun wanai go?” Singui garewa Iesu mek anega wan, “Ae, ya wanai iwa ame nao mega di taiwan. ");
INSERT INTO dgz_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Endi e ap umap sia. E dim da tat God diaeni, ame taitamenewa amba e ek gare gare anega wai, ‘Nu nao taitoni nagirewa megenat di, nu bawarewa uon. Wadianeni gapan di taivin.’” ");
INSERT INTO dgz_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Iesu pa Ierusalem dot aiwandini gapan, me at Sameria ge Galili yaumakewa poup tanatan muga gapan aiwandin. ");
INSERT INTO dgz_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Pa sewa da taueni gapan, vek bo’o tane apan aonagaet paina yawan. ");
INSERT INTO dgz_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Mu Iesu asirantu wandap yawane gapan ven kaimakaet anega wan, “Ayop nuga Iesu, bagu sisi nunan anu!” ");
INSERT INTO dgz_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Iesu yawamoni anega wan, “Aisene, pirisi nagirewa vek ega kem kam yawaep.” Iesu ap wani menan, mu negina amuiwanumune gapan vek muga uon tan. ");
INSERT INTO dgz_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Amba apan ameme da, mek ingane ae yaveni, omat gaset siran taran amone kakae tan menan, ewagai Iesu inewa sia one amba senave den God wa atonasiwandin. ");
INSERT INTO dgz_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Apan ame Iesu ine taueni, boge namup nikapu enu amba inap gaun wan. Apan mame Sameria apanewa, (Diu uon go Diu nagirewa anavi mugawa). ");
INSERT INTO dgz_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ap menan Iesu anega wan, “Ne vek bo’o tane apane wai aonagaet wat inakam muman. Daiton megenat sia entan tauen, upine amba amon? ");
INSERT INTO dgz_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","At ugupe apane ma megenat God yaua ao warapen sia tauen go Diu apane wai iwa dimen ya tauan?” ");
INSERT INTO dgz_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Boge Iesu apan ame anega dien, “Ao yon wanik ak. Anu tumat nimanegeana menan inak wariagi.” ");
INSERT INTO dgz_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Wam da, Parisi nagirewa Iesu singui wayawan, “God toemu mega andi amba taueta?” Amba Iesu gare anega wan, “God toemu mega tauepi yamayap ase ya yawai. ");
INSERT INTO dgz_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Menan apan da anega ya wata, ‘Yawan, mame tauen o yawan, ata me tauen.’ Ap anega uon, iwa God toemu mega gaseget tauen endi nimakayap wandia.” ");
INSERT INTO dgz_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Boge Iesu me wadiamot mega anega wadiamon, “Wam oniwan, evi amba Kimani Vitana Apanewa wam nega daiton endi waingina ame sia yawat anui, go ya yawai. ");
INSERT INTO dgz_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Amba waenapan upi Kimani Viseni apanewa menan anega wain, ‘Yawan, me itapa tauen,’ o ‘Yawan, taueni ase me,’ ap yawapen menan ya aisene, ewamup ya yonane iwa nop muga tavewa uon. ");
INSERT INTO dgz_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Go yangwan warin kiman ganase waini mini, Kimani Vitana Apane wam nega sia tauepi gapan waenapan yawanegain. ");
INSERT INTO dgz_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Go iman namu iragen, ugu vegaek arugataet da anu wat ireta amba waenapan endi ma wanumune nagirewa enu tandaya nimanegain. ");
INSERT INTO dgz_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Kimani Vitana Apanewa sia tauapena wamewa ame apan Noa wam mega gapan waenapan taiwanumune ap umap sia di tain. ");
INSERT INTO dgz_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Menan, wataget Noa wam megawa gapan, waenapan wanumon, taba kaum nana kakayat taiwanumun, amba waen ge apan naine musiwanumun. Ap anega tane aeni, Noa ae kabum mega gwanewa dotou aen amba boge ningoe tauen umamon borit wane. ");
INSERT INTO dgz_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Amba watageta apane Lot wam mega gapan ap anega den sia tane. Taba naiwanumun, une gare gare taiwanumun, antaba veriwanumun, amba pa tuiwanumun ap anega taiwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Go apan Lot pa Sodom ae ve tau aeni gapan oma yamewa aupa kimani aoma ugin mini vise waenapan iragi yagit guguramon. ");
INSERT INTO dgz_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Wataget taiwanumune ap mini, iman Kimani Vitana Apanewa sia tauapena wamewa gapan, waenapan ap umap sia di tain. ");
INSERT INTO dgz_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Wam ame inepi gapan apan da pa mega aigarip wandepi puraput mega pa gwanap tambupen menan sia ya vit aeta go ae ve tap serarat aeta. Ap umap sia, orup da egaga wandepi pa ewagai ya entan aeta. ");
INSERT INTO dgz_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Watageta apane Lot waenewa tani ap guturewa sia anun. ");
INSERT INTO dgz_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Menan anun, orup da me inak mega menan anu gure taiwandapinawa, inak mega wakaumeta. Go orup da nenan anu gure inak mega wakaumepiwa, ame inak wareta. ");
INSERT INTO dgz_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Endi ne wadiaepena anun. Ne sia tauapena wamewa gapan apan dere eragi daiton gapan aup inepi daiton wat angain amba dawa ae veain. ");
INSERT INTO dgz_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Amba sia, wam ame gapan, waen dere taba napen menan kanu etua wariwanumampina, daiton wat angain amba dawa ae veain.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Amba sia, apan dere nao tapi da wat angain amba dawa ae veain. ");
INSERT INTO dgz_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Iesu anega wani menan, wadiamot megawa singui anega wayawan, “Ayop, inak ma iman amba venaseta?” Iesu gare wan, “Maibe da wapena anun. Bonigawa etua amba wandepi arewa gapan, nenip gingiman, etua napen menan ap mepe iamain.” ");
INSERT INTO dgz_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Amba Iesu gutut ma watu enamot nagire mega wadiamop anu gapan, mu wam wam mup taine ae ya veapen menan manega wadiamon. ");
INSERT INTO dgz_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Pa sewa bawarewa da gapan, waenapan wanene tamuini apanewa da ap mepe wanden. Apan ame God viriwa ya tainiwa amba waenapan munan ya anuiniwa. ");
INSERT INTO dgz_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Amba ap mepe, waen kwapura da pot pot aen wanene tamuini apanewa ame ine tauen anega wainiwa, ‘Ne anavi nega paina yamasepen menan wat agoat nimanek!’ ");
INSERT INTO dgz_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Wam nonongataet, kwapura ame ap taiwandini gapan, wanene apanewa waen nop mega tanda ta ago ya wanat anun. Go evi amba sia, mek ingane anega anun, ‘Ne God inap tap ya anuivin amba waenapan munan ya anuivin. ");
INSERT INTO dgz_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Go kwapura ma pot pot wayawanegen waiwan, ap menan me aton anupen menan me mup wani ap omewa gapan di tain. Iwa ap ne ya tapena amba me pot pot manega taiwandapinawa, ne inak nega koe di tata!’” ");
INSERT INTO dgz_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Iesu sia wadiamon, “Gutut ame gapan, wanene apanewa ame, me apan kakae uon iwa God tawa amba waenapan munan ya anuiniwa go me ap anega tan. ");
INSERT INTO dgz_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ap gapan nu God nuga, me kakae iragen menan waenapan mega mum ge woup dim kakaewa menan God inap mup wainewa, God me waenapan garewa muga muniwandata, me ase ma da ya ta amba muneta.” ");
INSERT INTO dgz_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Iesu mek sia anega wan, “Den ne wadiaepena anun, God serarat wat agoat mume anavi muga toboramota. Go Kimani Vitana Apanewa sia tauapena piup gapan anu tumat nimanek wanumampina nagirewa da den yawamoin go?” ");
INSERT INTO dgz_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Waenapan upi muk ingane ae anuine muk kakae wanumot anuiwanum amba waenapan upinewa iragi koewa diamuiwanum. Ap taine nagirewa, guegue muga tamanamepen menan Iesu maibe gapan mu inamup anega wan, ");
INSERT INTO dgz_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Wam da, apan dere Ierusalem God Paewa gapan mup wapen men dot amon. Da Parisi apanewa, da moni bongamini apanewa. ");
INSERT INTO dgz_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Amba Parisi apanewa taue mek mini asira wandeni, ao yon wande mup manega tan, ‘Maman God, ne waenapan upinewa taine mini ya tainawa, mu yonane up tainewa, inak koe koe tainewa, negin gagap wainan gogo ise ta ase ta tainewa amba moni bongamini apane ase wandini mini den ya tainawa. ");
INSERT INTO dgz_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Amba, maman God, ne pura daiton daiton gwanap wam dere genan taba virip taivin amba ne garewa nega warina, semua aonagaet genan den barivin.’ ");
INSERT INTO dgz_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Go moni bongamini apanewa asirantu yone, i kaut enu amba bagu sisi anuni menan naniwa toganep pom pom to, God inap mup anega waiwandin, ‘Maman God, ne apan koerage bagu sisi nenan anu,’ ap anega wan.” ");
INSERT INTO dgz_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Iesu sia anega wan, “Wapena anun. God moni bongamini apanewa koewa mega anu ae veni gapan me pa mega aen, go God Parisi apanewa mup mega ya anun, pa mega mondi di aen. Ap gapan orup da da mek ingane yaua ao warepiwa, garewa God aoma wat otutameta, go orup da mek yaua aoma wat otutamepiwa, gare God me yaua paina ao wareta.” ");
INSERT INTO dgz_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Amba, waenapan upi otu waiwa bawarewa amba amapewa den Iesu naniwa iamup seapen menan tambun onamone, go wadiamot megawa yawamo diguguramon watanamone. ");
INSERT INTO dgz_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Go Iesu orup otua munan anega wan, “Orup otua ae vemone, nenan onamop, ya watanamone, iwa God toemu mega orup otua ma miniwa mugawa. ");
INSERT INTO dgz_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Wapena anun, tave di waivin. Waenapan da orup otu ma mini God ya anu tumasepiwa, me God toemu mega ya unugeta.” ");
INSERT INTO dgz_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Diu nagirewa, ayop muga da, Iesu singui wayaven, “Wadianet kakaewa, ne map anenen tap amba yaibobot inagewa yon borain?” ");
INSERT INTO dgz_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Iesu gare anega wan, “A, dimen ne apan kakaewa dianegingi? Orup kakaewa da uon go God megenat kakae. ");
INSERT INTO dgz_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Endi ge God iup mega mame asigigap tan go uon? Me iup mega mame, Wainan gogo ya taingan. Orup da ya togura boep. Up ya taingan. Evenaga koewa da tani yawaana, ame ebo aopan ugup ya enu yawa waingan. Inaga mamagawa ayamase ta muningan.” ");
INSERT INTO dgz_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Apan ame gare anega wan, “Ne orup otu waingena gapan ne iup mame waran iravi ta ongingin endi mame tauen.” ");
INSERT INTO dgz_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nop mega anuni Iesu sia anega wan, “Go ge inak daiton megenat garawasingi. Ame wan dim dim gegawa iragi ase une ta amba kwan purapuse uoni nagirewa mun. Amba ge kimaniwa kakae guragut megawa aupa evi amba warai. Ap tawa amba ewanap onagai.” ");
INSERT INTO dgz_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Go ayop apane, nop ame anuni gapan bagu sisi anun, iwa kwan puraput mega arugataet. ");
INSERT INTO dgz_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Apan ame bagu sisi anuni menan Iesu anega wan, “Puraput nagirewa God toemu mega unuk amopen ame inamup kaimake iragen! ");
INSERT INTO dgz_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Man bawarewa da, kainok ninoke gapan unuk tau aepen tapi ame umap uon. Ap umap, kwan purapuse dena apane da God toemu mega unuk aepi ame den umap uon go kaimakewa mega aigap di.” ");
INSERT INTO dgz_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Iesu ap wani menan waenapan manega anune, ame God wat aipakam mumeni gapan kwan puraput nagirewa puraput aruga tambune, menan uoni nagirewa anenen tain. Ap menan, waenapan Iesu inap singui anega wayawan, “Akae, God toemu mega unugepen kaimakewa da di, ap menan da inak ewakewa ware kimani unugeta?” ");
INSERT INTO dgz_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Iesu gare anega wan, “Waenapan muk ingane aro muga tainewa gapan ya unugain, go God inap ap me kaimake den uon, menan dim dim tat anuini me di tata.” ");
INSERT INTO dgz_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Apan Pita Iesu anega wadien, “Endi yao, nu dim dim nuga iragi ae veat evigap onanton. Nu inanup anenen?” ");
INSERT INTO dgz_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Iesu sia anega wan, “Nop tave di waivin, orup da da God toemu mega menan pa megawa o waenewa o tase gwaniwa o ine mamewa o otu waiwa ae vemopi, ");
INSERT INTO dgz_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","piupa inak mame gapan God wat aipakam mega aigap tautaneta amba wam eviwa inak yaibobot wariwandata.” ");
INSERT INTO dgz_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Iesu yao tomage gapan watu enamot mega aonagaet pusinawan dere anega wadiamon, “Wapena anun. Nu pa Ierusalem dot anivin. Ao mepe God noa wataget waiwanumune nagirewa Kimani Vitana Apanewa oitana ok seane iragi tavewa taueta. ");
INSERT INTO dgz_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Diu nagire waranege waenapan ugupe nagire nanimu gwanap bat nimanegain. Ugupe nagire nipep dianege wa koeragam nimanegain. Giton en ananege amba ");
INSERT INTO dgz_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","wagu gapan tonek wanumain. Amba toguranegepi bonigatain go wam yampoa gapan inak nigat sia yon waingain.” ");
INSERT INTO dgz_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Iesu ap anega wani go mu da ya anu awan. Iwa imumu ase to waramen. ");
INSERT INTO dgz_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ap mepe sewa arita da yaua Dieriko maniwandiniwa, yame boraseni apanewa da, ap mepe negin etop, ae wande moni menan mup waiwandin. ");
INSERT INTO dgz_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Yame boraseni apane ame, waenapan aruga tau amone ununkewa anuni menan singui ma wayawamon, “Ma dim da taiwanin?” ");
INSERT INTO dgz_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Mu gare anega wadian, “Iesu at Nasaret apanewa tauen aewan.” ");
INSERT INTO dgz_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Yame boraseni boge kaimakaet ven anega wan, “Iesu watageta apane Devit naewa, bagu sisi nenan anu!” ");
INSERT INTO dgz_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Namu onamone nagirewa anega diguran, “Nop ae ve,” go me uma sia anega wan, “Apan Devit naewa, bagu sisi nenan anu.” ");
INSERT INTO dgz_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Iesu ame anuni menan, ae yone yame boraseni apane me inap wat onamopen menan diamon. Me ine taueni gapan Iesu me inap anega wayaven, ");
INSERT INTO dgz_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ne inagap dim da tat anuingi?” Apan ame gare anega wan, “Ayop, ne yangut tat anuivin.” ");
INSERT INTO dgz_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","“Umap, yangut ta. Anu tumat nimanegeana menan inak wariagi.” ");
INSERT INTO dgz_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Iesu ame wani, no utap apan ame yamewa ase watapen yangut tan. Menan Iesu ewap ae God wa atonasiwandin. Waenapan ap yawane menan iravi God wa atonasiwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Iesu pa sewa Dieriko taue aiwandin. ");
INSERT INTO dgz_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Pa sewa ame gapan puraput baware apane yaua Sakias iniwandin. Me moni bongamine nagirewa bawarewa mugawa. ");
INSERT INTO dgz_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Sakias apan Iesu waine, me dime den menan yawat anu gure taiwandin, go me da ase ya yaven, iwa me apan oninke amba waenapan aru ame iamen, toborane, napamup wanden. ");
INSERT INTO dgz_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Menan, Iesu neginaet oniwandini gapan me namup serarat aeni boge oma da yaua Sikamo pain dore, Iesu yawapen men onep wanden. ");
INSERT INTO dgz_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Iesu oma iap taueni paina ao yave anega wan, “Sakias, serarat vit onak. Wam ma endiwa pa gega gapan waingain.” ");
INSERT INTO dgz_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakias menawaet viseni boge atonu den Iesu gaunewa tan. Amba dere pa mega amon. ");
INSERT INTO dgz_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Waenapan ap mepe iam wanumune, ap yawane gapan notatae anega wane, “Iesu apan koewa pa mega gapan dere wanumopen menan aen.” ");
INSERT INTO dgz_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Pa gwanap, Sakias yone Ayop Iesu anega wadien, “Ayop, ne wapena anu. Ne endi wan dim dim nega yon borana upi seu enup kwan purapuse uoni nagirewa munain. Amba den orup da da puraput muga ebo aopan gapan karaua tambuna garewa degede aigap gapan gapan sia munain.” ");
INSERT INTO dgz_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Menan Iesu gare anega dien, “Wam ma endiwa, dun ganat pa gega tauen, iwa ge watageta apane Eibaraam naewa di. ");
INSERT INTO dgz_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ne, Kimani Vitana Apanewa, God inak mega wakaumene nagirewa yomu tap inak ewakewa munapen menan tauan.” ");
INSERT INTO dgz_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Iesu waenapan aruga wadidiam wandin gapan mu nop mega anuiwanumun. Ap gapan Iesu Ierusalem tauapen tani menan mu God toemu mega gine tutup da ase venaset anuiwanumun iwa mu anune Iesu pa Ierusalem tauepi gapan me piup iravi ayopewa tata. Ap anune menan Iesu maibe gapan sia anega wadiamon, ");
INSERT INTO dgz_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Apan aritawa da, at wandap ayop tapen menan ae amba ewagai sia entan tauapen tan. Sia entan tauepi, me at mega gapan ayop muga taiwandata. ");
INSERT INTO dgz_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Aepen tani namup nao nagirewa mega aonagaet munan wan tauane. Moni mega gwat make daiton daiton mune amba anega wadiamon, ‘Moni mame tambun nao tan. Ne mawanap moni watu doriwaniampen menan moni mame eniangin. Ne tauapena gapan sia nenan.’ Amba me at wandap di ayop tapen menan aen. ");
INSERT INTO dgz_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Go aritawa ame, at ame waenapan megawa ayop muga ya tat anune menan tanda tan amba sep nagire watu enamon at wandape nagirewa ame anega wadiamon, ‘Nu apan aritawa ma, ayop nuga ya tat anuivin.’ ");
INSERT INTO dgz_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Go me gaset ayop tan, menan evi amba at mega sia tauen. Taueni amba anega wadiamon, ‘Nao nega taine nagire moni munana wane onamop. Mu moni munana ame watu dorane omewa anupen menan.’ ");
INSERT INTO dgz_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Nao taini apane namua taue anega wan, ‘Ayop negawa, moni gega daiton nenaana ne garewa ase aigap sia tambun aonagaet genian.’ ");
INSERT INTO dgz_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ayop apane anega wan, ‘Ge nao nega ta kakayat neniana apanewa. Ne otu kamontu genana gapan nona wara ta agingian menan pa sewa baware aonagaet ayopewa endi tat diagiangin.’ ");
INSERT INTO dgz_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Nao taini apane derewa taue anega wan, ‘Ayop negawa, moni gega daiton nenaana ne garewa ase aigap sia tambun nani yamunaet genian.’ ");
INSERT INTO dgz_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ayop apane sia wan, ‘Umap, ne pa baware nani yamunaet ayopewa endi tat diagiangin.’ ");
INSERT INTO dgz_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Nao taini dawa inap taue anega wan, ‘Moni gega nenaana sia wat ongena mam. Ne warana wanup muku gapan wa panam karaua baraen wanden. ");
INSERT INTO dgz_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ap tana iwa ge kaimakaet taiana apanewa menan taga tan. Dim dim gega da uoni union waringi. Ge nawak uon taba ya veringi go mondi naingi.’ ");
INSERT INTO dgz_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ayop apan ame anega wadien, ‘Ge nao koerage taiana apanewa! Nop gega waana gapan ne diguragain. Ne kaimake taina apanewa amba dim dim nega da uoni ame union warivin amba nawan uon taba ya verina go mondi naivin, ame ge asigigap. ");
INSERT INTO dgz_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Menan iwa dimen ge moni nega enine arewa gapan bondan mini ya baraan aigap da ya waraan? Ge ap tapo ne entan tauana gapan, moni enine arewa kwayup taine apanewa, ap mepe moni enaana menan, moni maup mega otu da aigap nenapo.’ ");
INSERT INTO dgz_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ayop anega digureni amba mainap yonane nagire anega wadiamon, ‘Apan ma moni mega daiton waseasen, ame moni aonagaeta neneni apanewa wanan.’ ");
INSERT INTO dgz_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Go mu anega wane, ‘Ayop nugawa, me moni gaset aonagaet tambuni, aigap wanat sia waingiana?’ ");
INSERT INTO dgz_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ayop apane sia wan, ‘Wapena anun. Nop nega anu taine nagirewa God nop upi sia muneta. Go ya anune taine nagirewa nop otu da anunewa ame sia waseamota. ");
INSERT INTO dgz_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Menan endi ne ayop ya tapen menan tandayat nimanegine nagirewa tambun onaen, namunap mapa guran boniga ae semon.’” ");
INSERT INTO dgz_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Iesu gutut mame waiwandin uon taniwa ewap, me pa Ierusalem namu dot aiwandin. ");
INSERT INTO dgz_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Iesu pa sewa dere, yaumua Betpadi ge Betani, maniwandiniwa sewa da ap mepe tunup yaua Oma Olip Yanane Tunupewa wakiap taueni. Ap mepe wadiamot dere watu enamo ");
INSERT INTO dgz_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","anega diamon, “Pa sewa namunup utapa ame aisen tauanewa, use tauan man donki otua da damiga taune yawai. Man ame gagap namu orup da ya amone. En vetan, wat onaen, mapa tauan. ");
INSERT INTO dgz_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ap mepe, orup da yawae singui anega wayawaepiwa, ‘Man ame iwa dimen wat vesiwanin?’ Gare manega wan, ‘Ayop nuga, man donki mame menan wan tauaton.’” ");
INSERT INTO dgz_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Watu enamoni, dere amonewa gaset Iesu anen anen wani gapan yawane. ");
INSERT INTO dgz_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Man donki ine tauan amba wat vesiwanumune gapan, man i apane singui wan, “E man donki ame dimen wat vesiwanin?” ");
INSERT INTO dgz_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Amba mu gare anega wane, “Nu ayop nuga, man donki mame menan wan tauaton.” ");
INSERT INTO dgz_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Mu boge waran amon Iesu inewa tauan, amba wanup aigape muga da waran man donki gagap aoma baraene amba Iesu wat agoasene man donki ame gagap wanden. ");
INSERT INTO dgz_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Iesu man gagap ap aiwandini, waenapan wanup aigape muga tambu tauan amba negina memegamene aen, amba Iesu taue gagap aen. ");
INSERT INTO dgz_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Oma Olip Yanane Tunupewa neginewa viseni gapan, ap mepe Iesu pa Ierusalem mainep tauen, ap gapan wadiamot mega aruga iravi atonu den God wa atonasen ve waiwanumun iwa mu Iesu yo ge kiman paua ugup ugup taiwandin yaviwanumune menan. ");
INSERT INTO dgz_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Mu anega wane, “Ge Ayop nugawa. God amun mega gapan tauiagi menan wat aipakam gimagia. Nonup kimani paina wandia amba oya oyae den God inap!” ");
INSERT INTO dgz_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Parisi nagire ap mepe den. Senao ame anune menan gunat tan amba Iesu anega dian, “Wadianet nugawa, wadiamot gega atonuga manega waiwanumune menan diguguramo, nop ae vep!” ");
INSERT INTO dgz_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Go Iesu gare anega wadiamon, “Wapena anun. Mu nop virip vepiwa, agim ata gare ao yone wa atonat nimanegain.” ");
INSERT INTO dgz_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Iesu pa Ierusalem konintu taue ase yaveni gapan, bumagewa tuk wan Ierusalem menan irip wan, ");
INSERT INTO dgz_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","amba anega wan, “Ierusalem nagirewa, baigan negine e endi anu kakayasepen menan anuivin. Go e tanda taiana menan negin ame oagaen wandia ap menan e ya anu awai. ");
INSERT INTO dgz_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","E baigan negine endi anu kakayasepen menan anuivin iwa, wam oniwan, anavi ega taue tonum ikukuk enu panayain, amba tainamu yamu yamu amboboraep wainiai, amba Ierusalem gapan yonep umap tapiwa ame sin dotoue garip onamoin. ");
INSERT INTO dgz_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Amba anavi ega pa mame taue e otu wai den gut kokoeam imayain, ap gapan gwat daiton didi batamene gwarewa diri gagap da ya wandeta. Koewa ma iravi e inayap venaseta iwa God wat inakam imaepan taueni e ya anuina menan.” ");
INSERT INTO dgz_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Iesu Ierusalem taueni amba God Paewa unuk aen. Ap mepe, wan dim dim muga gare gare une taiwanumune nagirewa gut oimon tau amone. ");
INSERT INTO dgz_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Me anega diamon, “God nop mega ok anega sean, Ne pa nega, waenapan ne inanap mup waine paewa. Ok anega sean. Go e taiana up nagire pa muga karauawa mini entanen!” ");
INSERT INTO dgz_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Amba Iesu wam wam God Paewa gapan God noa wadidiam wandin. Go Pirisi bawarewa ge iup wadidiamuine nagirewa ge ian Diu bawarewa mugawa upi den, Iesu waran togurapen tane. ");
INSERT INTO dgz_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Go mu ware togut togut neginewa da ya anun amba taiwanumun, iwa pa nagire Iesu inap darinamu pemagen nop mega anuiwanumune menan. ");
INSERT INTO dgz_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Wam da Iesu God Paewa gapan waenapan wadidiam wandin amba God Oit Mega Kakaewa opata taiwandini gapan pirisi bawarewa ge iup wadidiamuine nagire amba waenapan dimae waine nagirewa den Iesu ine tauan anega wane, ");
INSERT INTO dgz_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“Ge amun ansena da waran gapan dim dim mame taingi? Amun mame, da genen?” ");
INSERT INTO dgz_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Menan Iesu gare anega wadiamon, “Ne den singui inayap wayawaepen taivin. ");
INSERT INTO dgz_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Singui nega mam, apan Dion dup iamuiwandiniwa ame amun mega aupa kimani ware taiwandin go, gare mapa piupa waenapan upi inamup ware taiwandin?” ");
INSERT INTO dgz_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Singui mega anune muk wawa mutan anega wane, “Endi nu kiman amun mega ware taiwandat wata, me anega dianeta, ‘E dimen Dion nop mega ya anu tumasiwanin?’ ");
INSERT INTO dgz_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Go nu endi anega watawa, ‘Amun waenapan inamup ware taiwandin,’ ap anega watawa, waenapan ma iragi gwara toguguranain iwa mu anun Dion me God watu eneni apanewa.” ");
INSERT INTO dgz_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Anega anuiwanumune menan Iesu singui mega garewa anega wadian, “Dion amun ame wareni arewa nu oare.” ");
INSERT INTO dgz_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Menan Iesu anega diamon, “Ap menan ne den amun nega amba warana gapan ugup ugup mame taina ya wadiain.” ");
INSERT INTO dgz_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Iesu maibe gapan waenapan anega wadiamon, “Apan da nao egak mega da veren, amba amase taine nagire egak kwayup tapen menan semoni amba ae vemo at da ugup aen, en nononga di wande en. ");
INSERT INTO dgz_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Taba maup wamewa taueni gapan piup i apane nao mega apane da watu enen ae egak mega amase taine nagire inamup tauen, maup semua i apane wanapen menan mup wan. Go amase taine nagirewa to papaunagen wa oisene mondi aen. ");
INSERT INTO dgz_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Menan i apane, nao mega apane dawa sia watu enen tauen. Go sia to papaunagen me inap ta umamasene menan nao apane ame mondi aen. ");
INSERT INTO dgz_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ap menan, nao i apane apan yampoa sia watu enen. Egak amase taine nagirewa me epi tosisitnagen warup uat enane tau aen. ");
INSERT INTO dgz_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Amba nao i apane anuan sese anega tan, ‘Ne map anenen tain? Ne otuna imuna inap warina watu enain. Anse, ne otuna yave viripewa tain go?’ ");
INSERT INTO dgz_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Otua watu enen oniwandin e egak amase taine nagire paina yawan muk ase ma anega wawa mutan, ‘Piup i apane otua oniwan. Apan mam iman egak ma yon boreta, menan anet togurat boep, amba egak mame boge nu yon borat.’ ");
INSERT INTO dgz_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Menan waran sin garip uat enan togurane boen.” Iesu ap anega wan. Amba Iesu anega singui wayawamon, “Ap tane menan piup i apane inamup anenen tamota? ");
INSERT INTO dgz_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Tave di, me taue egak amase taine nagirewa guramop borit wap, amba egak mega ware waenapan ugupewa munep kwayup tain.” Waenapan nop ame anune menan anega wan, “Akae, manega ya venasep, nu tanda!” ");
INSERT INTO dgz_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ap wane menan, Iesu kem kem usenagaet yawamo anega wayawamon, “Go God nop mega ok mame anega seane iwa mega anenen wai? Agim ame pa tuine nagirewa tandayasen, koerage dian, go God agim ame ware entanen amba pa tuine danewa venasen. ");
INSERT INTO dgz_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Menan waenapan da da agim ame aigap onan geamopiwa, ame kaime no topait wa pait ta semuroro ta seta, go gare agim ame orup da aigap gearepiwa ame to gogotonagep atabobo venaseta.” ");
INSERT INTO dgz_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Iesu maibe mame waiwandini menan, pirisi bawarewa ge iup wadidiamuine nagire den Iesu ambot warapen menan negin yop taiwanumun. Iwa mu asigimup maibe ame mu koewa muga menan waiwandin. Go mu waenapan tamu anun menan Iesu evi amba to warat anun. ");
INSERT INTO dgz_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","To warapen menan amat taiwanumune nagirewa, Iesu enu yawa wapen menan gopat nagirewa karaua moni munan amba Iesu inap watu enamon. Mu mondigawa nagirewa mini tan iwanumun go singui tangui gapan Iesu nop da wabambamasepiwa, ap gapan mu anu to ware amo, at ame bawarewa apanewa nani gwanap barain. ");
INSERT INTO dgz_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ap menan, wam da, mu Iesu inap singui anega wayawan, “Wadianet nugawa, nu asiginup ge waenapan muk anen wane taine ame menan ge imuga potaga ya wariniwa, go ge nop tavewa gapan God dim dim anuini om ap gapan tainampen neginewa wadianianawa. ");
INSERT INTO dgz_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Menan nu singui nuga mam. At Rom ayopewa Sisa nu moni se wanata ame gapan nu Mosis iup mega yamatait go uon?” ");
INSERT INTO dgz_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Go mu nanamaset wan taiwanumune Iesu me asigip tan, menan me anega wan, ");
INSERT INTO dgz_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Endi moni agim makewa da ewanegen. Yao, moni ame gamup da yaua o guewa ok seane?” Mu gare anega wan, “Ame ayop Sisa yaua ge guewa.” ");
INSERT INTO dgz_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Me sia wadiamon, “Ap menan, wan dim dim Sisa mega wandepi ame Sisa di wanapen. God mega wandepi, ame God di wanapen.” ");
INSERT INTO dgz_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Mu nop mega anune gapan gare tarak wan no uon wanumon. Waenapan namumup Iesu nop da anenen wa koeamep warapen menan tane go umap uon. ");
INSERT INTO dgz_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Amba dugup Sadusi nagire, upi Iesu inap tauan. Mu dugup anu tumat muga gapan waenapan manega wadidiam wanumun, “Borit wata sia ya inak nitait.” ");
INSERT INTO dgz_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Menan Iesu inap singui anega wayawan, “Wadianet nugawa, watageta apane Mosis nunan iup ogewa anega sen, ‘Apan da waenewa otu uon boepi gapan me gwaniwa kwapura ame naise tasewa uewa orup se wanep.’ ");
INSERT INTO dgz_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Endi apan upi tatap gwanip yananewa nanin yamunaet yamunewa dere mugenat wanumon. Namu bonewa mugawa waen naiseni go me otu uon boen. ");
INSERT INTO dgz_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Menan gwaniwa ewap yaneni, tasewa kwapuraewa sia naiseni go otu uon boen. ");
INSERT INTO dgz_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Amba yampoa yaneni, waen ame naiseni go otu uon sia boen. Amba upinewa iragi ap anega tan orup ya sean amba borit wane. ");
INSERT INTO dgz_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Amba uiwa waen kwapura ame den sia boen. ");
INSERT INTO dgz_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Menan endi apan nanin yamunaet yamune dere waen ame naitanewa go wam uiwa gapan waenapan inak muse sia yon wanumopi waen ame apan ansenawa waenewa?” ");
INSERT INTO dgz_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Iesu nop ame gare anega wadiamon, “Endi waenapan naine musiwanum amba ore wai naine mutapen men muniwanum. ");
INSERT INTO dgz_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Go waenapan borit wane evi amba sia yon wanumopi inak yaibobot eviwa gapan mu gare gare ya naine mutain den ore wai naine mutapen menan ya munain. ");
INSERT INTO dgz_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Iwa mu anea umap wanumoin sia ya borit wain. Ame mu God otu waiwa iwa mu bop gapan God amun mega gapan sia yon wanumopi menan. ");
INSERT INTO dgz_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Borit wane nagirewa evi sia inak muse yon wanumopi ame tavewa apan Mosis ok namua seni gapan wa ewanen. Oma ut yagit wandin yaveni guturewa gapan ok anega sen, God anega wan ‘Omae baewa Eibaraam, otua Aisik, amba upewa Diekap, mu God muga daiton ame ne di.’ ");
INSERT INTO dgz_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Nop ame gueguewa mam, waenapan kabaniwa ge bonigawa mu God yamap iravi kabani wanumamun, iwa mu guamu den.” ");
INSERT INTO dgz_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Iesu ap anega wani menan iup wadidiamuine nagire upi anega wan, “Wadianet nugawa, nop gega kakae di waan.” ");
INSERT INTO dgz_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ap anega wane iwa mu tap tan inap singui sia ya wayawan. ");
INSERT INTO dgz_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Iesu singui Sadusi nagirewa anega wayawamon, “Anenen gapan God wa watu eneni Keriso mega me watageta apane Devit naewa? ");
INSERT INTO dgz_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Ame tave di, go? Iwa watageta bukaewa, yaua Sam, gapan Devit Keriso evi amba me denip gapan tauapen menan ok anega sen, God yone Ayop anega wadien, ‘Nanina nutup arigewa gapan, ae wanigingan, ne anavi gega tambup, gauaragap singapena menan.’ ");
INSERT INTO dgz_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Nop ma gapan, Devit yone Keriso inap me Ayop diwandin go Devit namu yaneni apanewa amba Keriso evi yanen menan anenen entane Devit naewa mega ayop dien?” Iesu singui ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Waenapan Iesu nop mega anuiwanumune gapan wadiamot mega sia anega wadiamon, ");
INSERT INTO dgz_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“God iup mega wadidiaine nagirewa munan ae yao kakayasen amba yon iwanian. Ian ame mondi yonane wanup kakae guragut enane, waenapan ase yawamopen menan apan apan tainewa, amba taba une taine arewa gapan amopi waenapan gaun munat anuiwanum. Amba den Diu opata waine paewa o barip gagewa gapan watat kakae iragena gagap wanumot anuiwanum. ");
INSERT INTO dgz_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Go mu waen kwapura kaimakaet enu yawamon wane gapan kwapura puraput ge pa mugawa den tambune. Ap tane go mup paewa gapan waenapan yamamup muk ingane tap kakae tapen menan, God inap mup wa nonongaminewa. Koewa ap tainewa menan wanene baware aigap yawain.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ap mepe, Iesu yangut ao taiwandini, me kwan puraput nagirewa upi yawamon pa Ierusalem, God Paewa gwanap, moni garaet muga enine arap eniwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Den me yaveni inak daiton yaven, kwapura koentu da taue moni mega dendeniwa dere otu ame enen. ");
INSERT INTO dgz_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Iesu yaveni anega wan, “Ne tave di waivin e anun, kwapura koentua ma yan mega tani arita, kwan puraput nagirewa yan muga tane gauarap. ");
INSERT INTO dgz_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Iwa mu yan tanewa bondan muga omewa anun gapan tan. Go waen kwapura koentu mame kayawan tainiwa, evi ware na iniwanda wanda iragi yan taitamen.” ");
INSERT INTO dgz_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Iesu wadiamot mega upi God Paewa yawane anega wan, “God Paewa yawat mega kakae iragen iwa waenapan garaet muga God wananewa ap gapan gwat kakae guragut gapan kaitan tune.” Go Iesu gare anega wadiamon, ");
INSERT INTO dgz_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“E pa mame endi yavisiana menan waiwanin. Wamewa iman tauepi gapan Diu anavi ega taue pa ma iragi to bebenak ae seain, gwat da daiton didi batamene diriga aita ya wanumoin.” ");
INSERT INTO dgz_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Mu gare singui wayawan, “Wadianet nugawa, wan dim dim arita mame andi amba venasiwandata? Amba venasepen taiwandapina, paua mega dim dim da namu taue aiwandapina yavinain?” ");
INSERT INTO dgz_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Iesu gare anega wan, “E yao kakayat amba wanien, da aopan wababayan imaepi tawa. Waenapan iman arugataet taue, ne yauna gapan ebo aopan waiwanumain, ‘Ne Keriso, God wa watu enanegeni di, tauan waivin, God wam mega mame tauen.’ Ap wapi go ewamup ya aisene. ");
INSERT INTO dgz_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ita anan agagae taue aiwandapina yawanewa, ame tap ya anu gurane. Inak aru mame namu venase di tau aeta, go wam uiwa ap mepe ya taueta.” ");
INSERT INTO dgz_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Amba den Iesu anega diamon, “Piup da da ge toemu da da yon wanumo ita anan gare gare tain. ");
INSERT INTO dgz_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Amba sia, piup nutanut enu tau aeta, enup wankakao tau aeta amba vek ato bararae tau aeta. Dim dim koewa ugup ugup taueta den kiman gapan paua ugup ugup tauepi yao seke take taiwaniai. ");
INSERT INTO dgz_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Inak mame venasepen taiwandapinawa, waenapan namu ta koeragam imain amba Diu opata waine paewa gapan wanene tayain amba gwat noke gapan seayain. E ne dugup nega nagirewa menan, wanene taepen menan ayop baware nagirewa ugup ugup namup tam nauyae amoin. ");
INSERT INTO dgz_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Mame gapan, ne oitana wadidiamopen menan wam ega arogawa ame venaseta. ");
INSERT INTO dgz_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Go endi namu anu yao se yao ya tane. Wam namuyape onini tantan ega tapen menan gop ya anuiwanian, ");
INSERT INTO dgz_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","iwa ne nop dimat enapena gapan, gapan di waiwanian ame anavi ega ya watanayain go mu nop ega garewa wapen gapan waramatain, umap ya wain. ");
INSERT INTO dgz_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ap gapan, e inae mamae, tatae gwani, amba dugup egawa evene wai den yone ominaya wap, amba waenapan guraep borit wai. ");
INSERT INTO dgz_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nenan waenapan iravi anu koeam imain. ");
INSERT INTO dgz_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Go gop ya anune, iwa wan dim dim ontotu baware mame da ya one araeta. ");
INSERT INTO dgz_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Iwa nenan kaimakaet ta waniwaniampina inak di wariwaniai.” ");
INSERT INTO dgz_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Iesu sia anega wan, “Anavi nagire pa Ierusalem taue ikukuk enpanepi gapan e anui, pa Ierusalem konintu wa koeamain. ");
INSERT INTO dgz_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ame venasepi wamewa gapan, at Diudia nagirewa tap serarat tunup dot amop. Pa Ierusalem gapan wanumuine nagirewa ae ve amop amba egaga inine nagirewa pa Ierusalem sia entan ya tauep. ");
INSERT INTO dgz_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Iwa wae wae nemoro mame one aigamup wandepi ame wataget God nop mega ap ok seane inepi wamewa. ");
INSERT INTO dgz_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Wam ame inepi wamewa, kaiwan, waen bagu dena o orup otu ine amape nagirewa inamup kaimake den! Piupa anan bagu sisi baware yawai amba God gari gangan mega inayap taueta. ");
INSERT INTO dgz_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ap gapan den, waenapan upi ita no utap boniga inain amba upi at at ugup ugup tam naumo amoin. Diu uon ian ugupe nagirewa pa Ierusalem wa koeragam wanumain. Amba God om enuni wamewa gapan ma iravi uon tata.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Iesu sia anega wan, “Wam ame gapan, paua ugup ugup yawat mega wam gapan, siragam gapan amba buanae gapan muk muk tapi waenapan irewa yawain. Amba piup gapan, at da da wande aeniwa iman puiman nikuru enu one toponage ame gapan den tap baware anuin. ");
INSERT INTO dgz_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Wam ame gapan, borit wa seke seke ta ise geam ase geam taiwanumain iwa dim dim da piup gapan venasepi tawa. Ame gapan kiman aroewa ame ugup ugup erere goyago amoin. ");
INSERT INTO dgz_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ap wamewa tauepi, Kimani Vitana Apane paua nega kimani tapena yawai. Amun baware, oya oya ganasewa nega den irikup nokap tauapena yawanegai. ");
INSERT INTO dgz_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Wan dim dim mame venase tau aiwandapina gapan, ao yon wanien, yangut ao kiman yawai, iwa God konintu wat inakam imaeta.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Iesu maibe gapan anega wadiamon, “Yangut tan, oma baip ge oma upine den guegue muga yawamon. ");
INSERT INTO dgz_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Gua ewake topi anuiwanin, bodu wamewa konintu taiwan. ");
INSERT INTO dgz_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ap umap sia, e wan dim dim mame tau aiwandapinawa, e anega anui, God toemu mega aroewa konintu taueta. ");
INSERT INTO dgz_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ne nop tavewa wadiaepen anun. Endi mame piupa yanane wanumamune nagirewa, wam muga gapan wan dim dim mame venat taue aep amba borit wain. ");
INSERT INTO dgz_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Piup ge kiman iman ise wat museta, go ne nop negawa di wande aiwandata.” ");
INSERT INTO dgz_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Iesu sia anega wan, “Ap menan yambuni wanien, wam ega wakauman baripaet ya ta isiwanian, kaum kaimake dena usenagaet ya naiwanian, amba wan dim dim piup ma megawa menan ya anu guran taiwanian. Iwa denkoe patukarewa muk waini mini God wam mega ap umap inayap tauepi tawa. ");
INSERT INTO dgz_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Wam ameme waenapan at at iragi inamup taueta. ");
INSERT INTO dgz_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ap menan nene yamam wam wam pot poraet taiwanian. Itan bagu sisi wamewa ameme inayap tauepi kaimakaet di waniepen menan inap mup waiwanian. Amba den Kimani Vitana Apanewa namunap yonan tap ya anupen menan mup waiwanian.” Iesu anega wan. ");
INSERT INTO dgz_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Amba Iesu God Paewa, Ierusalem gapan, pot pot wadiam wandin go mum gine me pa Ierusalem ae ve Oma Olip Yanane Tunupewa dot ae ap mepe iniwandin. ");
INSERT INTO dgz_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Menan waenapan wam wam pot poraet mumaget iragen, Iesu nop mega anupen menan God Paewa tauiwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Diu nagirewa barip muga yaua Taba Buredi Ya Tutut Waine Baripewa yaua da Paina Yamaseni Baripewa konintu taiwandin. ");
INSERT INTO dgz_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ap gapan, pirisi bawarewa iup wadidiamuine nagire den anenen ta amba Iesu karaua ware togurapen neginewa noa panan waiwanumun iwa waenapan tamu den anuiwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Amba Seitan apan Diudes, yaua da Iskeriot, potap unugen. Diudes me Iesu wadiamot mega aonagaet pusinawan derewa apane da. ");
INSERT INTO dgz_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Menan, Diudes ao yon wande boge pirisi bawarewa ge God Paewa ita yamewa nagire den tanamo, amba Iesu omine wani anenen to warapen menan noa wan. ");
INSERT INTO dgz_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nop mega wan anune mu aton anun menan garewa moni wanat wane. ");
INSERT INTO dgz_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Apan Diudes nop ame tanam wan, umap tani gapan, ae negin arogawa da yave, amba Iesu karaua ware munapen menan amat taiwandin. ");
INSERT INTO dgz_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Barip Taba Buredi Ya Tutut Waine Baripewa yaua da Paina Yamaseni Baripewa napen taiwanumune. Wam ame gapan, Diu nagire gutut muga ayamat tapen menan man sip otua upi tambun gurane. ");
INSERT INTO dgz_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Menan, Iesu apan Pita ge Dion watu enamo anega wadiamon, “Aisen Paina Yamaseni Baripewa wanin nana arewa da yop tan amba wan dim dim bongam bongam tan.” ");
INSERT INTO dgz_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Mu singui wayawan, “Endi ge taba nana at ansena gapan bongam bongam tat anu nimaningi?” ");
INSERT INTO dgz_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","“A, wapena anun. Aisen pa sewa ame tauane, apan da kaum udan wat aepi apanewa tautanan amba evip aisen pa da dorepi den doran. ");
INSERT INTO dgz_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Pa i apane anega wadian, ‘Wadianini apanewa anega wan, Ne pa gwane ansena ange wadiamot nega den Paina Yamaseni Baripewa nait?’ ");
INSERT INTO dgz_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Apan ame, pa gwane aigapewa baware da ame gapan watat iravi gaset tata kakayat tane amena ewaeta. Ap mepe taba wat iran.” ");
INSERT INTO dgz_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ap anega wani menan, mu amon pa tauan amba Iesu wani no usewa gapan yao ge yao di amon. Amba pa ap me gapan Paina Yamaseni tabaewa, ap mepe wat iran. ");
INSERT INTO dgz_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Taba nana wamewa taueniwa, Iesu watu enamot mega nagire den taba wantarewa gapan ae wanumon. ");
INSERT INTO dgz_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Iesu anega wadiamon, “Ugu vegaek bagu sisi amba tanain go namu Paina Yamaseni Baripe mame e den napen taiangina menan imuna potana waria. ");
INSERT INTO dgz_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Wapena anun, piup gapan, barip nega uiwa mame naian. Iwa iman barip mame tavewa God toemu mega gapan arogamepi amba ne barip mame sia nain.” ");
INSERT INTO dgz_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ap anega wani sip ware God inap gaun wa anega wadiamon, “Oma wain makewa kaumewa ma waran, ek yan ase ma sean nan. ");
INSERT INTO dgz_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Wapena anun. Kaum wain mame ne sia ya nain go God toemu mega tauepi amba sia nain.” ");
INSERT INTO dgz_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Amba Iesu taba buredi semua ware God inap gaun wa, wa paise watu enamot mega mune, amba anega wan, “Mame etunawa enan bariangin. Anu nimanegepen menan taba mame naiwanian.” ");
INSERT INTO dgz_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ap umap sia, taba nane ewap, Iesu sip wareni boge anega diamon, “Kaum wain mame deninawa enan tau viseniwa, God e waenapan mega, ne denina gapan agi ewakewa wa agiat imaeta. ");
INSERT INTO dgz_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Go anun! taba naitoni wantarewa gapan ominana wani apanewa da mapa inanap den wandia. ");
INSERT INTO dgz_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","God negin mega, Kimani Vitana Apanewa gase wat neneni ap omewa gapan bonigatain, go kaiwan, ominana wani apanewa itan baware yaveta.” ");
INSERT INTO dgz_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ap anega wani gapan watu enamot mega muk ase ma wawa mutan anega waiwanumun, “Nu nimakanup orup ansena da inak koewa ame tata?” ");
INSERT INTO dgz_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Amba, watu enamot megawa mu apan ansena da bawarewa tata menan gare gare notatae waiwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Menan Iesu yone anega wadiamon, “God ya anuine nagirewa ayop mugawa kaimakaet wapi gauarap wanumune nagirewa nop ame bagu sisie den anu wariwanum. Go ayop mugawa ame muk anega anune, ‘Nu gauarape nagirewa munan ago taintoni nagirewa.’ ");
INSERT INTO dgz_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Go e ap anega ya tane. Go gare e orup da ayop taniwa, ame aoma vise orup mondigawa mini tap. Amba ayop egawa aoma vise ayamat taini apanewa mini tap. ");
INSERT INTO dgz_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Menan endi, apan aritawa da, apan wantat gapan wandiniwa bawarewa o taba mega waniniwa bawarewa? Tave di, apan bawarewa ame wantat gapan wandini apanewa. Go ne, yaumakayap tauan, taba enina apanewa mini tainawa. ");
INSERT INTO dgz_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Tave di, ne itan bagu sisi ugup ugup anu taningina e ne inanap wainean. ");
INSERT INTO dgz_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ap menan, endi ne Mamana toemu mega amunewa neneni ap umap ne God toemu mega amunewa enain. ");
INSERT INTO dgz_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Menan toemu nega gapan taba ge kaum nega nai. Amba den ayop watarewa ega ega gagap waniai amba Isurero nagire dugup ega aonagaet pusinawan dere kakaewa koewa muga wanene tamoi.” ");
INSERT INTO dgz_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Iesu anega wan, “Saimon, Saimon, nop ma anu. Tavewa ge otarewa pemagine mini e koewa kakaewa yan seapen amba ta koeragam imaepen menan Seitan e iraya yawapen men God inap singui wayaven. ");
INSERT INTO dgz_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Go Saimon, ge anu tumat kin kin anuiana ame aoma ya vitapen menan God inap genan mup waingin. Iwa koewa gega tawa amba nenan sia ongewa ameme gatawan tatak gwanik wat kaimagam mumapen taingan.” ");
INSERT INTO dgz_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pita gare anega wan, “Ayop negawa, ge gwat noke agewa o bop menan agewa, ne den angepen menan amat tan di wanigain.” ");
INSERT INTO dgz_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Wani go Iesu gare wadien, “Pita, ne wapena anu. Endi wam koni yampoa gapan ge waboboranegai amba kumkum nop wata.” ");
INSERT INTO dgz_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Iesu wadiamot mega singui wayawamon, “Manap ne watu enaen aiseanawa, moni igewa da uon, ik pokaetawa da uon, amba pusi okomewa den uon, wam ame gapan e wan dim dim menan bumbam da tayan go uon?” Mu gare anega wane, “Uon, inanup iravi umap.” ");
INSERT INTO dgz_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ap menan Iesu anega wadiamon, “Wataget ap umap di iwanian go endi moni igewa o ik da inayap wandepiwa ame den di tambun. Amba den inak kwayupe menan kereba inayap ya wandepi wanup ega ase une tan amba garewa gapan kereba da une tan. ");
INSERT INTO dgz_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Iwa wapena anun. Wataget God nop mega ok seane tavewa mega ne me di. Mu ok anega seane, Waenapan anega wan, ‘Me koewa nagire garewa muga den waren.’ Oitana ok ap anega seane, menan ap anega di venaseta.” ");
INSERT INTO dgz_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Amba watu enamot upi anega wan, “Ayop nugawa, ma yao. Nu kereba dere den tambuton.” Go Iesu gare manega diamon, “Ap anega ya tane, kereba ega ae sean.” ");
INSERT INTO dgz_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Amba Iesu pa Ierusalem ae ve tau ae, pot pot taini mini sia Oma Olip Yanane Tunupewa dot aen amba wadiamot megawa evip amon. ");
INSERT INTO dgz_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ap mepe tauane anega wadiamon, “God inap mup wan dim dim da pusia warupepi tawa.” ");
INSERT INTO dgz_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ap gapan Iesu mu ae vemo mainantup asira aen, boge omanip enu mup anega wan, ");
INSERT INTO dgz_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Maman, ge men anu gurawa, ugu vegaek anupena ao waseanek, go mame ne anut negawa uon go gek anuiana gapan di ta.” ");
INSERT INTO dgz_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ame gapan anea aupa kimani taue, inap venase amba epara wanen. ");
INSERT INTO dgz_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Amba Iesu bagu sisi anu taneni baware iragen menan God inap mup kaimakaet sia di waiwandin. Gatok denip mini taue vise piupa seu endumen. ");
INSERT INTO dgz_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Mup mega uon tani ewap, ao yone watu enamot mega inamu ae yawamoni, bagu sisi arita anu tanane iwa mu aup iniwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Me anega diamon, “Iwa dimen aup iniwanin? Ao yonan, God inap mup wan, iwa pusi warup da inayap tauepi tawa.” ");
INSERT INTO dgz_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Iesu nop ap waiwandini gapan, apan Diudes, watu enamot mega aonagaet pusinawan dere apane da, apan aruga naumo onen. Iesu ware ua topen men tauen. ");
INSERT INTO dgz_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Go Iesu singui anega wayaven, “Diudes, endi ge ua gega gapan Kimani Vitana Apanewa ominana taingi?” ");
INSERT INTO dgz_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Watu enamot mega Iesu warapen menan tane yawan, anune menan mu singui anega wayawan, “Ayop, kereba nuga ma gapan guramoit?” ");
INSERT INTO dgz_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Boge Iesu watu enamot da yone pirisi ayop mugawa ago megawa darinewa nutup to kuasen. ");
INSERT INTO dgz_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","To kuaseni menan Iesu watu enamot megawa anega diamon, “Anan ae vean, mame da sia ya tane!” Amba Iesu apan ame darinewa wat enasen, kakae tan. ");
INSERT INTO dgz_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Amba pirisi bawarewa ge God Paewa ita yamewa nagire ge waenapan dimae waine nagire Iesu warapen men tauane gapan Iesu inamup anega wan, “Endi, ne up apanewa mini waranegepen menan kereba ge kepata tam tauayan? ");
INSERT INTO dgz_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ne wam, wam God Paewa gapan wanigingina ya waranegean go endi waranegepen taiwanin. Sisip aroewa wamewa mame di taueni menan e koewa tapen amunewa ap gapan di tauen.” ");
INSERT INTO dgz_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ap mepe boge ita nagirewa Iesu to waran amba pirisi aritawa mugawa pa mega nau amone. Pita kara karaua ewamup wandap oniwandin. ");
INSERT INTO dgz_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Pirisi aritawa mugawa pa mega sinewa gwanap arok da gapan ita nagirewa irot menan oma watu tugun iragi ap mepe enpanan wanumon, amba Pita taue ap mepe den tanam wanden. ");
INSERT INTO dgz_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Amba ap mepe nao taine waenewa da taue, Pita oma ganasewa gapan wanden mana mana use yave anega wan, “Apan mame Iesu den iwandini apanewa da!” ");
INSERT INTO dgz_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Go Pita ae wabobore anega wan, “Ae, waen negawa, apan ame ne oare.” ");
INSERT INTO dgz_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Amba wam koni ap gapan sia apan da den Pita yave anega wan, “Ge Iesu ewap ingiana ap da den di!” Go Pita sia anega wan, “Ae, apan negawa, ne uon.” ");
INSERT INTO dgz_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Wam airase da sia uon tani ewap, apan da ugup kaimakaet anega wan, “Apan ma at Galili apanewa, Iesu enana tan ini di!” ");
INSERT INTO dgz_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Go Pita sia anega wan, “Apan negawa, ge anen waingiana ne oare!” Pita nop mame waiwandini gapan, kumkum boge no utap wan. ");
INSERT INTO dgz_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ap gapan, Ayop Iesu to entane Pita kem kem yaven. Muma wani Pita sia anu aven, ‘Mum endiwa ge koni yampo waboboranegewa amba kumkum wata.’ ");
INSERT INTO dgz_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Anuni boge garip tau ae irip koevet wan. ");
INSERT INTO dgz_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ap mepe, ita nagirewa Iesu warane nipep dian to papaunagen. ");
INSERT INTO dgz_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Amba Iesu yamewa pan boran amba ton anega diwanumune, “Imugap wa anut, endi da togen?” ");
INSERT INTO dgz_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Anega wa koeragamene nop aruga sia nipep ugup ugup waiwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ap gapan, woup ase nenen waiwandiniwa, Diu Kansoro nagirewa ame dima waine nagirewa ge pirisi bawarewa ge iup wadidiamuine nagire tauan iragi ap mepe, pa gwanap, to iamen. Ita nagire Iesu wat onamon. ");
INSERT INTO dgz_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ap gapan, Kansoro nagirewa Iesu anega singui wayawan, “Wa anut, ge God mega wa watu enageni Keriso di go uon?” Iesu gare anega wan, “Ne wadiaepena e ya anu tumat nimanegai. ");
INSERT INTO dgz_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Amba ne gare singui wayawaepena, e garewa ya wadianegai. ");
INSERT INTO dgz_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Go endi mame use wande aeniwa, Kimani Vitana Apanewa, God Aigap Iragenawa mainewa nutup gapan ae wanigain.” ");
INSERT INTO dgz_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Amba mu iragi singui anega sia tane, “Ap waana gueguewa ame ge God Otua di?” Iesu gare anega wan, “E, ap me di waiaisi.” ");
INSERT INTO dgz_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Iesu ap wani menan, Kansoro nagirewa gare anega wan, “Endi nu dimen no oise wadian dian nagirewa munan waivin? Mame no kaime gapan gaset mek ebo wani anuton.” ");
INSERT INTO dgz_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Wam ame gapan, kansoro nagirewa yonan, Iesu waran, Rom ayop mugawa apan yaua Pailat ine wat nau amon. ");
INSERT INTO dgz_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ap mepe tauane anega enu yawan waiwanumun, “Nu apan mam waenapan nuga aopan wababayan mumiwandini menan waraton. Amba ayop nuga bawarewa Sisa moni mega ya waniwanumampen menan diamuiwan. Amba me mek ayop da God mega wa watu eneni Keriso waiwan.” ");
INSERT INTO dgz_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Menan apan Pailat Iesu singui wayaven, “Ge Diu nagirewa Ayop mugawa go?” Iesu gare wan, “E, ge ap me di waiagi.” ");
INSERT INTO dgz_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Apan Pailat pirisi bawarewa, waenapan den anega wadiamon, “Apan ma koewa mega da ne ya yaviangin.” ");
INSERT INTO dgz_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Go mu kaimakaet sia waiwanumun, “Iesu waenapan wadidiam wandini gapan wa danigam mume taiwandin. Namu at Galili amba at Diudia iravi mame den ap anega taiwandin.” ");
INSERT INTO dgz_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailat nop ame anuni menan singui anega wayawamon, “Me at Galili apanewa go?” ");
INSERT INTO dgz_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","“E, me at ame apanewa di,” anega wane menan at Galili Rom ayopewa yaua Erot, me pa Ierusalem daio taueni menan me inap watu enen. ");
INSERT INTO dgz_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Erot inap tauane gapan, ayop Erot Iesu yaveni aton baware tan iwa Iesu oit mega wataget anuiwandin yawat anun. Amba Iesu yo da tapi yawat anun. ");
INSERT INTO dgz_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ap menan, ayop Erot singui tangui arugataet wayaviwandin, go Iesu no uon wanden. ");
INSERT INTO dgz_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Pirisi bawarewa ge iup wadidiamuine nagire den yonan enu yawan kaimakaet dian waiwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ame gapan, Ayop Erot ita mega nagirewa den, Iesu wa koeragamen nipep dian. Amba waran, ayop guegue mega mini wanup kakaewa pan wanan amba ayop Pailat inap sia watu enan. ");
INSERT INTO dgz_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Wataget ayop dere Erot ge Pailat anavi taiwanumun go wam ame gapan mu evenan tan. ");
INSERT INTO dgz_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Amba ayop Pailat pirisi bawarewa ge Diu bawarewa nagire upi amba waenapan iravi den munan wan, tauan. ");
INSERT INTO dgz_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Amba anega diamon, “Apan ma inanap wat nau onayan amba waenapan aopan wababayan mumiwandini oise wayan. Menan namuyap singui tangui gapan ne me enu yawan wan. Go endi wapena anun. E koewa mega aruga batnagean go koewa mega da ne ya tautanan. ");
INSERT INTO dgz_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Amba sia ayop Erot den koewa mega da ya yaven menan nunan watu enen sia onen. Koewa mega boe boe da ya tan. ");
INSERT INTO dgz_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ap menan ne wapen mondi gaut arep amba tau aeta,” ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Iwa Pailat ian Diu nagirewa aton munapen menan, en gapan gapan Paina Yamaseni Baripe wamewa gapan, gwat noke apane da wat vesep tau aepen tainiwa. ");
INSERT INTO dgz_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Nop ap anune menan waenapan iragi, ve anega wan, “Iesu wat aisen togurane boep. Gwat noke apane Barabas nunan wat veta tau aep.” ");
INSERT INTO dgz_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Wataget da apan Barabas pa Ierusalem gapan Rom bawarewa nagirewa inamup ita anan tapen men waenapan anan datnak mumen amba me upi guramon borit wane menan bawarewa nagire waran gwat noke baraene iniwandin. ");
INSERT INTO dgz_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Go Pailat Iesu veset tau aet anuni menan waenapan aigap aigap diamo wan. ");
INSERT INTO dgz_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Go waenapan senao wa ge wa di taiwanumun, anega waiwanumun, “Oma korosi gapan togurane boep! Togurane boep!” ");
INSERT INTO dgz_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Amba Pailat koni yampoa sia diamo anega wayawamon, “Iwa dimen togurat waiwanin? Koewa mega dim da tan? Koewa mega boe boe da ne ya tautanan. Ap menan ne wapen gaura to vep amba tau aeta.” ");
INSERT INTO dgz_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Go waenapan Iesu di boepen menan senao paina iragen da waiwanumun. Menan Pailat nop muga anun. ");
INSERT INTO dgz_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ap menan Pailat Iesu boet wan. ");
INSERT INTO dgz_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Gwat noke apanewa Barabas, wataget pa nagirewa anan datnak mumen amba waenapan upi guramon borit wane apanewa, Pailat wat vesen tau aen. Go Iesu ware anut muga anuine tapen menan ase munen. ");
INSERT INTO dgz_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Iesu wat nau amuiwanumune gapan, apan yaua Saimon at mega Sairini at wandap da gapan Ierusalem oniwandin, negina tautanan. Iesu oma korosi mega waseasen Saimon onep baraene ware Iesu ewap aen. ");
INSERT INTO dgz_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Waenapan arugataet den ororom warupiwanumun, ame nimakamup waen upi den ap mepe bagu sisi anu tanan menan irip wa amuiwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ap menan, Iesu inamup to entane anega wadiamon, “Pa Ierusalem waene wai, nenan irip ya wane go otu wai den ek ingane iria wan. ");
INSERT INTO dgz_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Iwa, wam oniwandini waenapan iman anega wain, ‘Waen otu uon irak musinewa amba orup waen am ya mun yawane nagirewa mu inak muga endi bemta, menan mu aton taiwanum.’ ");
INSERT INTO dgz_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Wam ame gapan waenapan tunup inap anega wain, ‘Tunup, beut git aiganup aoma geak, nu borit wat!’ Amba togan inap anega wain, ‘Togan ge ukum umane gwanap karaua waninet!’ ");
INSERT INTO dgz_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Endi wam kakaewa gapan waenapan koewa mame tainewa, wam iman wanene wamewa gapan mu anenen tain? Iwa endi ma e duewa ega wamewa gapan go evi amba tane inaepi wamewa, e anenen tai?” ");
INSERT INTO dgz_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Amba ap mepe, up apane da dere, Iesu den guramo boniga semopen menan naumo amon. ");
INSERT INTO dgz_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Amone at yaua Apan I Kaime Arewa tauan. Ap mepe apan koerage dere Iesu den oma korosi gapan paina gut batam dawamone, dawa nutup arigewa gapan amba dawa senip arigewa gapan dawamon. ");
INSERT INTO dgz_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Amba Iesu God inap anega mup wan, “Maman, koewa muga anu ae ve. Dim da taine mu oare.” Ita nagirewa wanup mega orup ambe da wareta, menan kae otu da tane amba waran. ");
INSERT INTO dgz_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Amba ap mepe yonane nagirewa yangut taiwanumun go Diu nagire bawarewa mugawa wawa koko inap anega wan, “Waenapan upi wat inakam mumen. Menan endi me God mega wa watu eneni Mesaya wandepiwa, mek ingane wat inakamep yawat.” ");
INSERT INTO dgz_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ap mini sia, ita nagirewa onam Iesu inewa tauan nipep wan. Amba mu kaum sisi dena yaua viniga wanat anun. ");
INSERT INTO dgz_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Mu anega wan, “Ge Diu nagire ayop mugawa waingewa gek ingane wa inagita nu yawaget.” ");
INSERT INTO dgz_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Amba, ap mepe, Iesu korosi mega i kaimap ok manega sean tobatamene, Ma Diu Nagire Ayop Mugawa. ");
INSERT INTO dgz_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Amba, up apanewa da, den to endawanewa, Iesu inap wawa koko ta anega wan, “Ge God mega wa watu enageni Mesaya di? Menan gek ingane wa inagit amba nu den wa inak nitat!” ");
INSERT INTO dgz_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Go up apanewa dawa anega diguren, “Ge God tawa anuingi go uon? Nu yampo koerage dianene. ");
INSERT INTO dgz_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Go gende itan nunane, iwa nu inak nuga koewa taitoni yamewa menan itan ma warianit. Go apan mame koewa mega da uon.” ");
INSERT INTO dgz_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Amba apan ame Iesu anega dien, “Iesu wam ma endiwa toemu gega posewa unugewa ne den anu nimanek.” ");
INSERT INTO dgz_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Iesu gare anega wadien, “Wapena anu. Wam ma endi nu gende at kakaewa kiman tauait.” ");
INSERT INTO dgz_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Wam ianupe wariwandini gapan, piup ame iravi mum tatarin tunu sisip taue ae wanden aeni amba wam airase yampoa waren. Iwa wam ganasewa uon tan. Amba Ierusalem God Paewa gwanap wanup nononga antapenanewa ame yaumakap bebep wa ase ma wanden. ");
INSERT INTO dgz_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ame boge Iesu wawa sisi kaimakaet ta anega wan, “Maman, ne guana nanik gwanap ae bariangin.” Wani boge gaup mega uiwa use puk wa tau aen boge boen. ");
INSERT INTO dgz_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ita yamewa apane da, ame yaveni, God yaua ao ware anega wan, “Tave di, apan ma kakaewa di, koewa da ya tan.” ");
INSERT INTO dgz_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Amba, waenapan aruga ewan tauan amba ita nagire dim da taiwanumune yawane bagu sisi anun kaiwan baiwan wain en boge pa muga muga entan amon. ");
INSERT INTO dgz_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Iesu evene waiwa, amba waen upi at Galili gapan tautan onamone den, mu wandap yonan yaviwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ap mepe apan da yaua Diosep, pa sewa yaua Arimatia apanewa da, wande en. Me apan kakae amba ian Diu nagirewa kansoro muga apanewa da. Me evene wai, Kansoro nagirewa, namu Iesu noa panan wan to waran taiwanumune go me den ya taiwandin, iwa me God toemu mega onini nauase tainiwa. ");
INSERT INTO dgz_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Me ayop Pailat ine ae mup anega wan, “Iesu etua nen.” Amba Pailat umap wan. ");
INSERT INTO dgz_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Menan me Iesu etua wa totnak wat vise wanup nononga kakaewa gapan viri viri waren amba dagup ewakewa da nanip kaitanewa gapan baraen. Dagup ap me namu da ya danamene. ");
INSERT INTO dgz_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Mum gine ameme Diu nagirewa barip menan taba bongamiwanumun, menan Diu pura bawarewa wamewa imanawa amba taueta. ");
INSERT INTO dgz_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Amba ian waen at Galili gapan Iesu tautanan onamone ame Diosep ewap amon amba dagupa anenen baraene gueguewa yawan. ");
INSERT INTO dgz_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Boge mu pa sia entan amon. Kaum tutu denawa Iesu etua enu iapen menan bongam bongam ta seapen menan amon. Amba wam pura bawarewa menan mu God iup mega wani ame viriwa tan menan wagat wanumon. ");
INSERT INTO dgz_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Diu pura muga bawarewa wamewa uon tani, wam namupewa, mumaget iragen, ian waen ame, kaum tutu denawa waran dagup amon. ");
INSERT INTO dgz_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ame tauane, dagup tonanewa no aroga wanden iwa gwat baware tonan borane ame baim wa tau aen yawane. ");
INSERT INTO dgz_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Menan, mu dagup gwanewa unuk amone go Ayop Iesu etua ya yawan. ");
INSERT INTO dgz_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Anu bambamatan wanumone boge apan dere wanup muga ganase den enan mainamup yoniwanumune yawamone. ");
INSERT INTO dgz_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Waen tap kaime doran menan pia nikapu enun. Apan anega wayawamon, “E dimen mapa kaima arewa gapan inakaeni apanewa yowa taiwanin? ");
INSERT INTO dgz_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Me mapa uon, me gaset inakae yon wanden! Iesu wataget at Galili gapan wandeni nop wadiaeni anu awayan go uon? ");
INSERT INTO dgz_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Iesu manega wan, ‘Ne Kimani Vitana Apanewa ian ugupe nagirewa nanimu gwanap bat nimanegain amba oma korosi gapan toguranegep bonigatain amba wam yampoa gapan ne inak nigat sia yon wanigain.’” ");
INSERT INTO dgz_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Boge waen ameme nop ap anune gapan, Iesu nop mega anen wani ame ase anu awane. ");
INSERT INTO dgz_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Menan, mu menawaet amone Iesu watu enamot mega aonagaet pusinawan daiton amba waenapan upi den inamup tauan oit wadidiamon. ");
INSERT INTO dgz_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Waen ap wadidiamone nagire yaumua Meri Makdalin, waen Dioana, ge Meri (otua apan Diemis) amba waen upine den. ");
INSERT INTO dgz_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Wadidiamone go mu nop muga ebo mini anune menan ya anu tumasen. ");
INSERT INTO dgz_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Go Pita yon wande, dagup yawapen menan serarat aen. Dagup taue kaut enu, wa panam taune wanupewa megenat gwanap wanden yaven. Boge Pita pa mega ae, inak mame venaseni menan anu yao seyao ta aiwandini. ");
INSERT INTO dgz_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Wam ame daiton, Iesu wadiamot mega dere pa Ierusalem ae vean pa Emeas amon. At ame wandap uon, (ame 10 kilomita mini). ");
INSERT INTO dgz_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Mu inak wan dim dim aruga ame venaseni, no oisewa gare gare wan amuiwanumun. ");
INSERT INTO dgz_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ap waiwanumune gapan Iesu inamup tauen den amon. ");
INSERT INTO dgz_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Mu Iesu yawane go irewa ya yawan anune iwa God yamamu toboboren. ");
INSERT INTO dgz_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Iesu singui anega wayawamon, “E ap aisiwaniana gapan dim noa da gare gare wawa isiwanin?” Ap wani gapan, mu bagu sisi anune amba gine namu ae bigat mutane ae yonan. ");
INSERT INTO dgz_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Apan dere, dawa yaua Kiliopas gare anega wan, “Ge Ierusalem daio ageanawa wam ap gapan dim da ta waiwanumune ge da ya anuana menan waingi go?” ");
INSERT INTO dgz_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Iesu gare anega wan, “Dim dim da venasiwandin?” Apan ame gare anega wan, “A, nu Iesu pa Nasaret apane oisewa waivin. Me God nop mega waini apane amba waenapan namumup nop wat ge tat mega aroe amunu den. ");
INSERT INTO dgz_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Go Pirisi bawarewa amba ayop nuga nagire upi den Iesu waran ian ugupe nagire nanimu gwanap baraen oma korosi gapan tone boen. ");
INSERT INTO dgz_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Me nu Isurero nagire anavi nuga aro muga gapan vetanep tau anepen men anuton. Inak baware mame venaseni, wame yampoa endi mame. ");
INSERT INTO dgz_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Go endi waen nuga upi mumaget iragenawa dagup yawapen amone, go mondi pokaet yawan tauan amba wabambam nimanene. Amba den anega wane, ‘Nu anea dere yawamoton. Anea ame anega wane, Iesu me inakae yon wanden.’ Waen oit ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Waenapan nuga tanam waninetoni, upi dagup amone waen oit wane ap uap sia Iesu ya yawane.” ");
INSERT INTO dgz_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Apan dere nop ap waiwanumune menan Iesu gare anega diamon, “E bumbam anenen da tayan waiwanin. God nop mega wataget waiwanumune nagire nop muga menawaet ya anu tumat wanin. ");
INSERT INTO dgz_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Mu ok anega seane, God mega wa watu eneni Keriso ugu vegaek bagu sisi anu tanep amba oya oya mega kimaniwa gapan wagup wareta.” ");
INSERT INTO dgz_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ap gapan, Iesu watageta nagirewa Mosis namu amba God nop mega waiwanumune nagire den Iesu oit mega, ok gapan seane, gueguewa wadidiamon. ");
INSERT INTO dgz_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Amba pa Emeas maniwanumunewa, Iesu wa garawat mume taue namu aepen tan. ");
INSERT INTO dgz_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Go mu anega wan watanane, “Onge tanak inat, ma wan gine gaset tan, mum di tauapen taiwan,” ap anega wane menan tanamo pa gwanap aen. ");
INSERT INTO dgz_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Amba taba napen menan Iesu ae wande, buredi ware God inap gaun wa, wa paise amba munen. ");
INSERT INTO dgz_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Muneni gapan, God yamamu watapen, Iesu ire ase yawane boge oagaen, da sia ya yawan. ");
INSERT INTO dgz_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Mu gare gare anega wan, “Iesu negina God nop mega gueguewa wadidian wandini nu potanu oma yame mini yagiriwandin.” ");
INSERT INTO dgz_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Boge mu wam ameme di yonan ewagai sia entan pa Ierusalem amon. Tauane Iesu watu enamot mega aonagaet pusinawan daiton amba waenapan upine den tanam wanumone yawamon, ");
INSERT INTO dgz_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","go pa wanumuine nagire namu anega wan, “Ayop nuga di yon wanden apan Saimon inap venasen.” ");
INSERT INTO dgz_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Amba apan dere ame neginaet amuiwanumune gapan anenen venasen yawane oisewa wadidiamon, amba Iesu den taba napen tane gapan buredi wa paiseni wamewa gapan ire yawane oisewa den wadiamon. ");
INSERT INTO dgz_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Mu inak mame yawane oise waiwanumune, Iesu me mek taueni boge nimakamup yone anega diamon, “Nonup inayap wande ep.” ");
INSERT INTO dgz_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Mu boeni apane guewa da yawat anune menan guamu pua aen tap anu gurane. ");
INSERT INTO dgz_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Menan Iesu anega diamon, “E di menan nene yangwan doraen taiwanin? Iwa dimen imuyap gego den anuiwanin? ");
INSERT INTO dgz_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nanina pusina yawan ma ne di! Onaen wat anu nimanegen amba yawanegen, ne etuna kaimana den go guewa etua kaimewa uon.” ");
INSERT INTO dgz_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Iesu nop ame wani, boge naniwa ge pusiwa siran ewamon. ");
INSERT INTO dgz_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Mu aton anuiwanumune go anu bambamat inamup di wandeni menan, me singui anega tamon, “E taba nana da den?” ");
INSERT INTO dgz_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Menan mu meo bonigawa da wat onam wanan. ");
INSERT INTO dgz_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Iesu boge ware, watu enamot megawa yamamup nan. ");
INSERT INTO dgz_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Amba Iesu sia wadiamon, “Ne manap tanaen wanigena, inak map anega venasepi oisewa, namu wadiaen ame Apan Mosis ge God nop mega waiwanumune nagire amba den buka Sam seane nagirewa oitana iravi ok seane mame di venasia.” ");
INSERT INTO dgz_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ap gapan me God nop mega mu anu awapen menan imumu watapen. ");
INSERT INTO dgz_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Amba Iesu anega wadiamon, “Wataget God nop mega ok anega seane, God om enuni Keriso da tauepi ugu vegaek anu bop tata, amba wam yampoa ewap me bop gapan, sia inakae yon wandeta. ");
INSERT INTO dgz_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ap menan Keriso me yaua gapan inak koewa anu ae veat, ge wat entan tapen no oisewa, namu pa Ierusalem gapan, amba at at iragi wadidiamoin. Ok ap anega sean. ");
INSERT INTO dgz_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Inak ma yaviana no oise ase wasenamene nagirewa e me di. ");
INSERT INTO dgz_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Amba ne nek Mamana kimani agi mega wani ne enan watu enain, go e mapa Ierusalem gapan amat taiwanian amba aro amun da aupa kimani aigayap visepi waran amba tau aisen.” ");
INSERT INTO dgz_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Amba Iesu wadidiamot mega naumo taue at Betani mainep tauan. Ap mepe nani ao wadave wat aipakam mumen. ");
INSERT INTO dgz_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Wat aipakam mumiwandiniwa gapan, me pusiwa ao bunen boge ae vemo, God aro mega gapan kiman dot aen. ");
INSERT INTO dgz_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ame boge waenapan mega Iesu wa taragasene atonu den sia entanen pa Ierusalem amon. ");
INSERT INTO dgz_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ap mepe God Paewa gwanap pot pot usenagaet God inap wa atonasiwanumun. ");
INSERT INTO dgz_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ere mangan ap mepe God Nop Oit mega, Iesu, wande en. Nop ame God den, amba Nop ame God di. ");
INSERT INTO dgz_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Tavewa di, ere mangan me God den wande en. ");
INSERT INTO dgz_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Me gamup wan dim dim iragi venat mutan, amba me gamup gine mawap da ya wandia. ");
INSERT INTO dgz_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Me inap ap mepe inak, amba inak ame waenapan iragi ganat mugawa. ");
INSERT INTO dgz_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ganat ame sisipu yagiriniwa, go sisip ganat ya toboriniwa. ");
INSERT INTO dgz_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Wam nugawa gapan God apan da watu eneni, me yaua Dion. ");
INSERT INTO dgz_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Dion ganat tavewa iragenawa ewamopen menan tauen, amba me gamup waenapan iragi anu tumat tapen menan tauen. ");
INSERT INTO dgz_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Dion mek ingane ganat uon, go me mondi waenapan ganat tavewa ewamopen tauen. ");
INSERT INTO dgz_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Iesu ganat tavewa di piup ma gapan tauiniwa. Me tauepi ganasewa iragi enup piup ma gapan mun ge mun aiwandata. ");
INSERT INTO dgz_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ere mangan wan dim dim iravi Iesu gamup venasen go me piup ma gapan taue wandeni, waenapan irewa ya yawan anu awane. ");
INSERT INTO dgz_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Piup ma mek megawa di tauen go me taueni me waenapan megawa tandayasene. ");
INSERT INTO dgz_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Go da iragi Iesu warepiwa amba anu tumat me yaua gapan tapiwa, Iesu tamana di diamon God otu waiwa entan mumeta. ");
INSERT INTO dgz_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","God otu waiwa entanamoni ame waenapan deniwa gapan uon, inewa mamewa anut muga gapan uon, waenapan muk ingane anut muga gapan den uon, go Iesu anu tumasene gapan otu waiwa entanamon yanane. ");
INSERT INTO dgz_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nop ame entanen apan venasen amba wandet megawa nu yaumakanup. Oya oya mega nu yawaton. Oya oya mega aigap iragen iwa God mek otua daiton iragenawa di. Me imu pose wat aipakam ge nop tave iragenawa no dotouen. ");
INSERT INTO dgz_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Dion nop tavewa Iesu menan ve anega waiwandin, “Apan daiton menan wainginawa, me ewanap oniwandini, me aritawa go ne uon, iwa me namunap yaibobot ine wande oniwandin.” ");
INSERT INTO dgz_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","17","God iup Mosis gamup nuneni ame wat aipakam erewa go endi nop tave iraganewa Iesu gamup tauen, iwa me imu pose kakaewa no dotoueni gapan wat aipakam mega arugataet tauini ame aigap aigap iragi waritoniwa. ");
INSERT INTO dgz_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Orup da daiton God ya di yaven, go God Otua daiton megenat Mamewa yave anun iwa mek Mamewa mainep wandiniwa. Amba me piup ma taueni God Mamewa irewa to ewanen. ");
INSERT INTO dgz_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Apan Dion gutut mega mam. Wam ame Diu pa Ierusalem gapan pirisi gauarape mugawa den watu enamone Dion inap tauan, singui wayawan, “Ge da?” ");
INSERT INTO dgz_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Dion ya wa umen go oit aroga wadiamon, “Ne God om enuni apanewa, Keriso uon.” ");
INSERT INTO dgz_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Boge mu singui wayawan, “Go ge da? Ge apan Elaidia go?” Me gare wan, “Ae, ne ap uon.” Mu sia wayawan, “Ge God nop mega wataget waingianawa apanewa ameme go?” Me gare wan, “Uon.” ");
INSERT INTO dgz_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Uiwa mu anega wane, “Ge da? Nop garewa nuna wat anet watu enanene nagirewa wadiamot. Gek ingane oitaga anen waingi?” ");
INSERT INTO dgz_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Wataget God nop mega waiwandini apane Aisaia nop wani mini Dion gare anega wan, Ne at kaimewa gapan pua opata waingina apanewa. Ayop negin mega wat tamanamene amba tauep. ");
INSERT INTO dgz_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Wam ame gapan Parisi nagirewa upi sia apan Dion singui anega wayawane, “Ge God om enuni apanewa, Keriso uon waingi o Elaidia o God watageta noa waiwandini apanewa ameme uon waingi, go ge iwa dimen dup iamuingi?” ");
INSERT INTO dgz_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","27","Dion gare wan, “Ne kaum gapan dup iaivin go apan ame evinap oniniwa, me aigap iragenawa menan pusi okomu damigewa en veta veta ne umanap uon. Go apan ame daiton da yaumakayap yonini e oare.” ");
INSERT INTO dgz_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nop mame gare gare wane arewa kaum Diodan asepagan, at Betani ap mepe Dion waenapan dup iamuiwandini gapan. ");
INSERT INTO dgz_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Inane woup sen Iesu Dion inap oniwandin yaveni anega wan, “Ase yawan, God man sip mega otua, waenapan koewa nuga garewa wat museta. ");
INSERT INTO dgz_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Apan ase me menan om tan anega wana, me ewanap oniniwa me aritawa di, go ne uon iwa me namunap yaibobot ine wande oniwandin. ");
INSERT INTO dgz_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ne namu nek den Iesu oare, go Isurero nagirewa Iesu anu awapen menan ne tauan dup iamuivin.” ");
INSERT INTO dgz_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Boge Dion Iesu guturewa wadiamon, “God Guewa nenip Bairantan mini visiwandin wapip doreni yawan. ");
INSERT INTO dgz_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Namua me da ne oare go waenapan dup iamopen watu enanegeni manega wadianegeni menan ne asigip tan, ‘Apan ansena yawa Guewa vise gamup dorepi ameme evi Guewa Woup Seniwa den dup iamuiwandata,’ me ap anega wadianegen. ");
INSERT INTO dgz_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ne yawan tavewa di venasen menan wadiaivin, Apan mame God otua di.” ");
INSERT INTO dgz_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Inane woup sen Dion wadiamot mega dere den ap mepe sia yoniwanumun, ");
INSERT INTO dgz_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Iesu ap aiwandini Dion yave anega wan, “Yawan, God man sip mega otua.” ");
INSERT INTO dgz_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Wam ame Dion wadiamot mega dere nop wan anunewa, mu Iesu ewap amon. ");
INSERT INTO dgz_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Iesu ewagai entane yaveni ewap onam wanumune yawamo singui wan, “E dim da men anuiwanin?” Mu gare wan, “Rabai, ge amba iningi?” Nop Rabai wane gueguewa ame wadianiniwa apanewa. ");
INSERT INTO dgz_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Iesu gare wan “Onaen, amba e yawai.” Ap menan mu amon amba inini arewa yawan, amba wam ame yaugai tanan wanumon. Wanumone aeni wam airase degedeawa wareni menan ap mepe inane. ");
INSERT INTO dgz_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Apan dere ame Dion wan anun Iesu ewap amone ame dawa Anduru, Saimon Pita gwaniwa. ");
INSERT INTO dgz_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Gine tutup Anduru ae tasewa Saimon tautane wadien, “Nu God Mesaya mega yawaton.” Mesaya tavewa ame Keriso amba gueguewa ame God om enuni apanewa. ");
INSERT INTO dgz_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Amba tasewa waren Iesu ine aen. Iesu kem kem yave anega dien, “Ge Saimon Dion yauga Sipas diagivin” (Sipas tavewa Pita gueguewa gwat bonawan). ");
INSERT INTO dgz_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Inane woup seni, Iesu at Galili aet anun. Pilip yowa ta taneni anega dien, “Ewanap onak.” ");
INSERT INTO dgz_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilip me pa Besaida at Galili apanewa, Anduru ge Pita pa muga daitonawa. ");
INSERT INTO dgz_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilip ae yop ta apan Nataniero tane anega dien, “God nop namua gapan, apan Mosis ge God oise waine nagirewa apan daiton menan ok sean anega wan. Apan daiton ameme nu yawaton. Apan ame Iesu, Diosep otua, at Nasaret apanewa.” ");
INSERT INTO dgz_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniero anega wan, “At koewa Nasaret! Asepa dim da kakaewa tau onepi menan waingi?” Pilip gare wan, “Onak yao.” ");
INSERT INTO dgz_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Wam ame Nataniero Iesu ine oniwandin yave Nataniero menan anega wan, “Me mek tamana Isurero apanewa di, me inap ebo da uon.” ");
INSERT INTO dgz_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniero anega wan, “Anenen amba asik tanegean?” Iesu gare wan, “Ne namu ge oma baip iap wanigean yawagen Pilip venaga evi amba wan.” ");
INSERT INTO dgz_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Boge Nataniero aroga wan, “Wadianianawa apanewa, ge God otua, Isurero Ayop nugawa.” ");
INSERT INTO dgz_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Menan Iesu anega wan, “Ge anu tumat tanegean iwa baip iap wanigean yawagen wana menan. Endi wana ame otu koentu go inak bawarewa evi amba tapen yawanegai. ");
INSERT INTO dgz_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ne tamana tavewa di wadiaivin, kiman watapep God anea mega Kimani Vitana Apanewa aiganap vitagen doragen taiwanumampinawa e yawanegai.” Iesu ap anega diamon. ");
INSERT INTO dgz_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Wam dere uon tani ewap, naine mutat baripewa da sewa bawarewa yaua Keina at Galili gapan tane. Iesu inewa ap mepe den wanden. ");
INSERT INTO dgz_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Amba Iesu ge wa ewamot mega den tanamo naine mutat baripewa ame gapan venamu wane tauan. ");
INSERT INTO dgz_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ap mepe kaum wain uon tan menan Iesu inewa yone me anega dien, “Mu kaum wain inamup iragi uon tan.” ");
INSERT INTO dgz_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Iesu gare wan “Ae inan, ge dimen wadianeget waan taingi? Ne wam nega ya tauia.” ");
INSERT INTO dgz_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Go Iesu inewa yone waenapan nao nagire ame anega diamon, “Me anen wadiaepi gapan di tan.” ");
INSERT INTO dgz_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Pa ap me gapan unup no um baware iragenawa nani yamunaet nani yamu daiton pa gwanap seane iwa barip wamewa waenapan arugataet tauepi menan. Unup no um baware iragenawa tat mega mu Diu nagirewa anu tumat muga iupewa gapan. Ian Diu nagirewa anu tumat iup muga arugataet. Iup da ameme orup da pa gwanap aet anupiwa namu pusi nani bigi ware amba unuk aeta. Ap menan pa pa gapan unup no um baware iragenawa daiton daiton tonana sinewa. ");
INSERT INTO dgz_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Iesu nao nagire ame anega diamon, “Unup no um ame kaum utan gemane no dotou dotou aep.” Me ame wani gapan mu iragi kaum utan gemane unup iragi no dotou dotou aen. ");
INSERT INTO dgz_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Boge me anega sia diamon, “Kaum upi geman tambun barip ma i apane ine aisen.” Ame Iesu anen wani no usewa gapan di tane. ");
INSERT INTO dgz_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Amba barip i apanewa kaum wain venaseni ame na anun, go me kaum wain ame amba taueni me oare. Nao nagire kaum ame utan gemiwanumune mugenat asigimup tane. Boge barip ame i apanewa, naine mutat apane ame wandeni vene wan tauen, ");
INSERT INTO dgz_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","anega dien, “Waenapan iragi kaum wain kakaewa imumu wareni namu yan seane waenapan venamu wane tauane ame nainewa, amba kaum wain ni nen seniwa ame evi amba yan sene nane aton tainewa, go ge endi kaum wain gega kakaevet gine ambot waingean endi mame waran tauiagi?” ");
INSERT INTO dgz_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Endi mame Iesu yo mega erewa at Galili pa Keina gapan to ewamon. Mame gapan me kiman oya oya mega ta ewamon, ap menan watu enamot mega imu pose waren inap anu tumat tane. ");
INSERT INTO dgz_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Mame tani ewap Iesu inewa, wa ewamot megawa, ge tase gwani tanam at pa Kaponiam ae wam upinewa den ap mepe wanumone. ");
INSERT INTO dgz_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ian Diu Paina Yamaseni Baripewa tuguinewa wamewa da konintu taiwandin, ap menan Iesu at Ierusalem dot aen. ");
INSERT INTO dgz_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ap mepe God Paewa sin gwanap namboya waenapan, man kao, sip ge nenip bairantan une taiwanumun, amba upine wanumon moni entan wantan taiwanumune Iesu yawamon. ");
INSERT INTO dgz_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Boge me gaut bunum nanip tani ware waenapan amba man sip ge kao gut oimon tau amon. Moni entan taiwanumune togoyam wagoyam ta, ge moni entan taiwanumune watarewa tambu yamu en tanamon. ");
INSERT INTO dgz_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Iesu nenip bairantan une taine nagirewa anega diamon, “At ma gan iragi tam tau aisen! E anenen menan Mamana God Paewa wat entan tayan wan dim dim une taine paewa mini entanen!” ");
INSERT INTO dgz_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Iesu ap me waniwa, wa ewamot mega wataget God no oise kakaewa gapan seane ame ase anu awane. Ame anega seane, Pa gega men anu gurana menan potana oma yame mini yagiriwan. ");
INSERT INTO dgz_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Iesu ame tani menan, Ian Diu nagirewa yonan singui anega wayawan, “Endi ge yo ansena da ta ewane yawat gapan aro amun arita mame waran taiana nu anu tumat gimaget!” ");
INSERT INTO dgz_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Iesu garewa anega wadiamon, “God Paewa ma ae wabenagene wam yampoa gwanap ne sia tu waborain.” ");
INSERT INTO dgz_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Go Diu nagirewa sia anega wane, “God Paewa ame tune en apane dere apan da nani yamunaet nani yamu daiton gapan tu waborane go endi ge waingiana wam yampoa gwanap tu waborat waingi?” ");
INSERT INTO dgz_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Go Iesu God Paewa menan ya waiwandin go mek etua menan waiwandin. ");
INSERT INTO dgz_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Amba Iesu bop ta sia yon wandeni ewap wa ewamot mega nop mame Iesu waniwa ap mepe darinamu purut wan ase anu awane. Amba God oit mega ge Iesu mek anen waiwandiniwa iragi anu tumat tane. ");
INSERT INTO dgz_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ierusalem gapan Paina Yamaseni Baripewa tuguiwanumune Iesu ap mepe den wande yo ge paua ugup ugup taiwandin waenapan arugataet to iamen, yawan anu tumasiwanumun. ");
INSERT INTO dgz_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Go Iesu mek ae anuiwandini ya anu tumat mumiwandin iwa me waenapan imumu potamu asigip tan. ");
INSERT INTO dgz_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Den me anuiwandini orup da yone waenapan oitamu me da ya wadieta. Iwa waenapan imu pose anenen anuine me asigip tan. ");
INSERT INTO dgz_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ap mepe, Ierusalem gapan, Parisi apan da yaua Nikodimas wande en Me Diu nagirewa namu yoyo muga da. Gutut mega mam. ");
INSERT INTO dgz_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Me muma Iesu inap taue anega wan, “Wadianiana apanewa, nu asiginup ge wadianet da God inap ongean. Iwa ge yo ugup ugup taianawa, orup da God me inap ya wandepiwa ge taianawa mini ya tata.” ");
INSERT INTO dgz_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Nop garewa Iesu aroga anega wan, “Ne tavewa di wadiagivin, God toemu mega orup da daiton ya unugeta. Orup da me Guewa Woup Seniwa gapan ya yanepiwa me God toemu mega ya unugeta.” ");
INSERT INTO dgz_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodimas singui anega wan, “Apan arita tani anenen amba sia yaneta? Tavewa di me inewa potap unuk ae wam derewa sia yaneta go?” ");
INSERT INTO dgz_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Iesu gare wan, “Ne tave di wadiagivin, orup da me kaum ge Guewa Woup Seniwa gapan ya yanepiwa me God toemu mega ya unugeta. ");
INSERT INTO dgz_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Etua gapan yanepi etua di, go Guewa Woup Seniwa gapan yanepi ame guewa di. ");
INSERT INTO dgz_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ne sia di yanapen menan waingina anu seke ya ta. Ge iravi tanamo mek sia di yanan. ");
INSERT INTO dgz_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Taik arik ansena tauat anuini gapan tauen aewan. Ge taik ununkewa megenat anui, go at ambe gapan oniwan o at ambe gapan aewan ge anu wawa da umap uon. Ap mini daiton daiton Guewa anuini gapan yanapen.” ");
INSERT INTO dgz_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodimas singui sia anega wan, “Ma anenen venaseta?” ");
INSERT INTO dgz_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Iesu gare wan, “Ge Isurero nagire wadiamot mugawa dimen ge inak ma iragi ya anuitamiagi? ");
INSERT INTO dgz_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ne tave di wadiagivin, nu asiginupe gapan waivin amba gutut waitoni ame yawatoni gapan waivin, go waenapan e gutut nuga ya di anuyan warisi. ");
INSERT INTO dgz_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ne piup guegue mega wadiagena ge ya anu tumat nimanegean. Anenen amba kiman guegue mega wadiagepena ge anu tumat nimanegai? ");
INSERT INTO dgz_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Waenapan daiton da kiman ya dot aen, go daiton megenat kimani aoma taueni, ame ne, Kimani Vitana apanewa. ");
INSERT INTO dgz_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Mosis mokare guewa at kaimewa gapan iap eneni mini, Kimani Vitana apanewa paina ao iap enain. ");
INSERT INTO dgz_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ap menan da da ne anu tumat nimanegepiwa inak yaibobot warain.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Iwa God piup nagirewa munan bumaga tantan anu gureni menan otua daiton iragena nunen. Ap menan da da God otua anu tumasepiwa guamu ya wakaumain go inak yaibobot warain. ");
INSERT INTO dgz_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","God otua watu enen piup ma taueni tavewa waenapan wanene tamopen menan ya tauen, go me gamup waenapan inak warapen menan tauen. ");
INSERT INTO dgz_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Mu da da anu tumasepiwa koewa gapan wanene ya tamota, go mu da da ya anu tumasepiwa gaseget God wanene mega gapan yonane, iwa God otua daiton iragenawa ya anu tumasene. ");
INSERT INTO dgz_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","God wanene ame tamopi tavewa ame mam, ganat piup tauen, go ya anu tumasene nagirewa mum sisip imumu wareni menan ganat tandayasene iwa mu inak muga koevet. ");
INSERT INTO dgz_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Mu iragi koewa taine ganat tandayasiwanum, iwa koewa muga ganat arogamepi tawa menan mu ganat gapan ya tauain. ");
INSERT INTO dgz_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Go mu da da ganat warane den tamana ininewa, ganat inap tauain iwa mu den aroga ase yao anuin ame mu dim da tainewa mu God gamup taiwanum. ");
INSERT INTO dgz_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Mame ewap, Iesu amba wa ewamot megawa at Diudia arige use amone, ap mepe wam animpo mini den tanamo wandeni amba anu tumat dupewa iamuiwanumune. ");
INSERT INTO dgz_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ap wamewa at ugupewa at Aenon, at Seilim konintu, Dion dup iam wandin, iwa at ame gapan kaum aruga, amba waenapan aruga pot poraet dup iamot wan tauiwanumun. ");
INSERT INTO dgz_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Mame tane ewap ita nagirewa Dion waran gwat noke baraene. ");
INSERT INTO dgz_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Dion wa ewamot megawa amba Diu apan da den God yamap bigip muga wat mutapen gueguewa menan notatae waiwanumun. ");
INSERT INTO dgz_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Mu Dion ine tauan anega wane, “Wadianiana, apan ap me ge den Diodan asepagan daiton menan guturewa wawa kakayat taingianawa, ame waenapan dup iamuiwan, amba mu iragi me inap amuiwanum.” ");
INSERT INTO dgz_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Dion gare wan, “Apan da tat mega aroewa God kimani wanini gapan megenat taiwan. ");
INSERT INTO dgz_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","E ek gutut nega wana anuyan, ne, God om enuni apanewa, Keriso uon go ne me namup watu enanegen ongena apanewa. ");
INSERT INTO dgz_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Waenapan negawa, waen apan ganganaseni megawa di. Apan ame, me evenewa, naine mutat gapan me amase taiwandata. Menan naine mutat apane noa anupiwa me aton anuta. Ne naine mutat apane evenewa mini amba aton ame negawa potanap no dotouen iwa Iesu taueni menan. ");
INSERT INTO dgz_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Iesu ne aiganap aiwandata go ne me gauarap angingain.” ");
INSERT INTO dgz_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Kimani viseni apanewa me aigap iragenawa. Go piupa yaneni apanewa piup megawa, amba piup guegue mega wainiwa. ");
INSERT INTO dgz_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Kimani Viseni apanewa dim da aupa yaveni ge anuni oisewa waiwan go waenapan noa ya wariwanum. ");
INSERT INTO dgz_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Apan ansena da Iesu nop mega ware di anu kakayaseni, me aroga ase manega wata, “God ame tavewa di.” ");
INSERT INTO dgz_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Iwa God wa watu eneni apanewa, Iesu God oise wainiwa iwa God Guewa Woup Seniwa om aigapewa Iesu waniniwa. ");
INSERT INTO dgz_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Mamewa otua menan anu gureni menan dim dim iragi Otua nani bagup baraen. ");
INSERT INTO dgz_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Orup ansena me God otua anu tumasepiwa inak yaibobot wariwandata, orup ansenawa da God mek otua tandayasepiwa me inak da ya wareta go God nemoro mega ware me inap baraeta. ");
INSERT INTO dgz_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ian Parisi nagirewa Iesu nop oit mega anune me waenapan wa upamuiwandin ge dup iamuiwandin arugataet ewap amuiwanumune, go Dion ewap amuine aruga uon. ");
INSERT INTO dgz_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Go dup ame Iesu ya iamuiwandin, go wadiamot megawa ame taiwanumun. ");
INSERT INTO dgz_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ambagan Iesu ian Parisi nagire nop ame Iesu menan waiwanumune anuni at Diudia ame ae ve ewagai at Galili sia aen. ");
INSERT INTO dgz_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","At Diudia ge Galili nimakamup at Sameria wanden, ap menan Iesu piup Sameria tau ge tau aiwandini. ");
INSERT INTO dgz_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Sewa da ap mepe Sameria gapan yaua Saika tauen, at piup da watageta apane Diekap otua Diosep ire di ve waneni ame mainep. ");
INSERT INTO dgz_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Diekap kaum men urat ware tu matakameni ap mepe wanden. Amba Iesu ap nonongataet oniwandin wam ianupewa wareni menan epi torot wan amba kaum tu matakamene ame no kaimap ae wanden. ");
INSERT INTO dgz_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Iesu kaum no kaimap wandeni, wam ame den wadiamot mega vean at sewa baware da ame taba une tapen amon. At Sameria waen da kaum urat ame gapan utapen tauen. Iesu waen ame anega dien, “Kaum da ut nena napena umap?” ");
INSERT INTO dgz_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","At Sameria waen ame gare anega wan, “Ge Diu apanewa amba ne Sameria waen go endi ge kaum ut genapen waingi?” (Sameria nagirewa naine sipewa ian Diu sip ame gapan sia ya nain, amba ugup ugup ap mini den iwa mu dere anavi wanumamun.) ");
INSERT INTO dgz_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Iesu sia wadien, “God genat anuni ge oare amba kaum mut nenat wana ne da ge oare. Anu nimanegepo amba God genat anupo, ge mup inanap wapo, ne inak yaibobot kaumewa genapo.” ");
INSERT INTO dgz_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Waen ame Iesu anega dien, “Ge yaibobot kaumewa ame endi amba utai? Kaum aipa urata diawa, den ge kaum uta uta pokewa da ya waraana. ");
INSERT INTO dgz_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Endi waingiana ge yauga ao waran mamanu Diekap yaua aoma waringi, me urat ma ware kaum tu matakam nuneniwa megenat gamup naivin. Otu waiwa ge man tap megawa iragi ap mepe den naiwanumun.” ");
INSERT INTO dgz_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Iesu gare sia wan, “Orup da kaum iragen ma napiwa me megewa sia pakaraiwandata. ");
INSERT INTO dgz_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Go orup da kaum ne wanapen napiwa, me megewa sia ya pakaraeta. Amba tave di kaum ne wanapena ame kaum urewa bot bot yaugai potap di tauiwandata ame yaibobot inagewa tautaneta.” ");
INSERT INTO dgz_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Waen ame Iesu anega dien, “Enda, kaum ure dena ame nen! Napena megana sia ya pakaraep amba urat ma gapan kaum utapen menan da sia ya ongep.” ");
INSERT INTO dgz_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Iesu waen ame anega dien, “Ak, memaga wadia, dere sia onaen.” ");
INSERT INTO dgz_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Waen ame entane gare anega wan, “Ne memana da uon.” Iesu waen anega sia dien, “Ge memak uon waana ame tavewa di waan. ");
INSERT INTO dgz_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ge namu apan nani yamunaet naimoana, go endi apan den wanik agiana ame ge memaga uon. Tavewa di, endi ge gaseget memak uon waana ame tavewa gapan di waan.” ");
INSERT INTO dgz_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Waen ame Iesu dien, “Enda, ne anuingina ge God nop mega waiana apanewa da. ");
INSERT INTO dgz_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nu at Sameria isimuran ge omayan bae wataget tunup ma gapan God wa taragasiwanumun, go Diu nagirewa e anega waiwanin, wa taragaset arewa Ierusalem gapan megenat di.” ");
INSERT INTO dgz_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Boge Iesu anega wani, “Waen negawa, anu tumat nimanek, wam konintu taiwan amba e Mamana God tunup ma gapan ya anu tumatai amba Ierusalem gapan den ya anu tumasiwaniai. ");
INSERT INTO dgz_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ian Sameria e wa taragaset ega tavewa ya anuiwanin go nu Diu nagirewa wa taragaset nugawa iwa mega den anuivin, iwa inak ibariwa Diu nagirewa inamup tauen aewan. ");
INSERT INTO dgz_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Wam usira wandeni onin en endi gaset tauen ame waenapan Guewa Woup Seniwa ge tavewa gamup Maman God wa taragatain. God waenapan ap umapewa God yomu taiwan. ");
INSERT INTO dgz_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","God me Guewa di, ap menan Guewa aro amun megawa tavewa gapan waenapan Maman God wa taragasep.” ");
INSERT INTO dgz_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Waen ame sia anega wan, “Ame tauepi ne asiginap, me Mesaya inak nunini apanewa Keriso, me tauepiwa anu tumat nuga guegue mega iragi wa ewaneta.” ");
INSERT INTO dgz_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Waen ame ap anega wani, Iesu gare entanen aroga anega dien, “Inak enini apanewa mame diagivin.” ");
INSERT INTO dgz_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Iesu nop ame waiwandini, me watu enamot mega taba une tapen amone sia entan tauane. Tauan yawane Iesu waen ame dere nop waiwanumune yawane anu bambamat anune go singui manega da ya tayawane, “Ge dim menan waen inap nop waingi, dim menan nop dere waiwanin?” ");
INSERT INTO dgz_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Boge, waen ame kaum pokarik mega ae veniwa, entane sewa bawarewa ame sia ae waenapan anega diamon, ");
INSERT INTO dgz_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Onaen, apan da ne da ya anuina ge da ya taina noa iragi wadianegeni ame yawan. Endi anuiana ameme God om enuni apanewa Keriso di, go?” ");
INSERT INTO dgz_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Boge waenapan pa sewa ame ae vean tauan Iesu yawapen amon. ");
INSERT INTO dgz_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Pa sewa nagirewa onam wanumunewa Iesu watu enamot megawa nanamasen anega wane, “Wadianet nugawa, taba ma wat nan.” ");
INSERT INTO dgz_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Go Iesu anega diamon, “Ne taba nega wandia go e asigip ya tayan.” ");
INSERT INTO dgz_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Iesu nop ame wani, watu enamot mega gare gare ase ma manega wawa mutan, ‘Orup da taba gaset tam taue wanen nan?’ ");
INSERT INTO dgz_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ame waiwanumune anuni, Iesu anega wani, “Watu enanegeni anut mega navewa amba nao mega neneni taitamepena ame ne taba negawa. ");
INSERT INTO dgz_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","E asigiap e naewa veranewa, siragam degede uon tapi ame maup wamewa. Ne wadiaep, yamaya uarenan nao egak yawan gaseget maup taue aen daupam menan inin geraget tan wandia. Go God daupam mega wam wam di wande aiwandata. ");
INSERT INTO dgz_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Daupam taini apanewa garewa mega tawanane wariwan ameme maup taue aeni ame bongamiwan. Maup ame tavewa Iesu anu tumasine nagirewa. Mu inak yaibobot wanumoin. Ap menan vereni apanewa ge daupam taini apanewa mu dere aton tain. ");
INSERT INTO dgz_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Wataget wane nopewa ame tavewa di, Apan da verepi amba apan dawa daupam tata. ");
INSERT INTO dgz_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Navewa e ya tayan go taba maupewa taueni bongamepen menan watu enaen. Ame waenapan upinewa nao kaimakaet tane, go nao muga ginewa e ta yon borapen aisewan.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Waen ame Iesu yave oisewa wan anune menan Ian Sameria nagirewa pa sewa baware ame gapan wanumune iragi Iesu anu tumasene. Waen ame pa nagirewa anega wadiamoni, “Ne da ya anuna da ya taina noa aruga me wadianegen.” ");
INSERT INTO dgz_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ap menan Sameria nagirewa Iesu ine tauan kaimakaet wan watanane. Ap menan Iesu mu tanamo wam dere wanden. ");
INSERT INTO dgz_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ap mepe wandeni gapan me nop mega waiwandiniwa waenapan imu pose wat entanen boge arugataet anu tumat tane. ");
INSERT INTO dgz_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Mu iragi waen ame anega diane, “Nu, ge Iesu oise wadianeana ap me megenat anu tumat ya taivin, go me nop wani nuk anutoni gapan. Tave di, apan mame waenapan wat inakam mumini apanewa.” ");
INSERT INTO dgz_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Wam dere uon tani ewap, Iesu at Galili di aen. ");
INSERT INTO dgz_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Iesu namu da anega wani, “God nao mega taini apanewa at piup mega iragenawa nagirewa viriwa da ya tainewa.” ");
INSERT INTO dgz_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Amba me at Galili taueni at ame nagirewa iragi atonu den Iesu warupane. Iwa mu iragi Ierusalem gapan wanumone, Paina Yamaseni Baripewa gapan Iesu yo mega ugup ugup taiwandini mu iragi ap mepe den yaviwanumun. ");
INSERT INTO dgz_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Wam da sia Iesu me at mega daio sewa bawarewa Keina at Galili aen. Wataget ap mepe me yo mega erewa tan, kaum iragen wan wain venasen. Den ap mepe Kaponiam apan aritawa da otua vege den at Kaponiam gapan iniwandin. ");
INSERT INTO dgz_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Apan ame Iesu at Diudia gapan one at Galili taueni oisewa anuni menan me ae Iesu inewa taue noek noek manega waiwandini, “Vit onak ne otuna wat inakamepen iwa otuna bop konintu di.” ");
INSERT INTO dgz_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Iesu anega dien, “Ne yo nega paua ugup ugup tapena yawaneget anuyan taiwanin? Yo ya tapenawa e ya anu tumat nimanegai.” ");
INSERT INTO dgz_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Nao aritawa apanewa ame anega wani, “Ayop otuna boepi tawa menawaet vit onak.” ");
INSERT INTO dgz_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Iesu gare wan, “Ganawan ak otuga inakaeta.” Apan ame Iesu nop mega anu tumaseni ao yon wande di aen. ");
INSERT INTO dgz_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Apan ame neginaet di aiwandini nao nagire mega onamon negina tautanan, otua oisewa anega wadiane, otuga gaset kakae tan. ");
INSERT INTO dgz_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Apan aritawa ame singui wayamon, “E wane anup otuna wam airase ansenawa gapan inak waren?” Mu anega wadiane, “Wata wam airase daitonawa gapan otuga kakae tan.” ");
INSERT INTO dgz_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Boge Kaponiam aritawa apane anuni, wam airase daitonawa ap omewa gapan Iesu anega me dieni, “Ge otuga inakaeta.” Ap menan apan ame ge waenapan pa mega gapan ininewa iragi Iesu anu tumasiwanumun. ");
INSERT INTO dgz_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Mame Iesu at Diudia gapan ase ma taue yo mega derewa pa Keina, at Galili gapan taniwa. ");
INSERT INTO dgz_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Wam ame ewap da, Diu nagirewa barip muga menan Iesu pa Ierusalem dot aen. ");
INSERT INTO dgz_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Pa Ierusalem gapan tonan da yaua Man Sip tonane diane. Tonan ame mainantup kaum awan da ian Iburu nop muga gapan yaua Betsaida diane. Kaum awan ame etop, pa namdat nani yamunaet ikukuk tumone. ");
INSERT INTO dgz_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ap mepe enkana ankana nagirewa arugataet ininewa, upi yame borat mutanewa, upi pusi nani gegerawa, upi ugu wapi in wandeniwa. ");
INSERT INTO dgz_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","At ame nagirewa anu tumat manega taiwanumun, Anea da vise kaum awan (yaua Betsaida) menawasep amba orup da kauma awan gapan namu tauepi etua kakae tata. ");
INSERT INTO dgz_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ap mepe vek apane da pusi nani in wandeniwa en mega apane daiton aonagaet nani yamunaet nanin yamu yampo (38) wande en. ");
INSERT INTO dgz_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Wam ame Iesu apan ap mepe iniwandin yaveni gapan me anu aven, apan ma vek tan en nonongataet di wanden. Me singui inap wan, “Ge inak warat anuingi?” ");
INSERT INTO dgz_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Apan ame gare wan, “Kaiwan, ago da uon, orup da inanap mapa uon ago nenep ae kaum menao manao taini gapan taua taua. Nek ta yawan ae tauapen taingina go upi namunap vit amone namu ae tauiwanum.” ");
INSERT INTO dgz_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Boge Iesu inap anega wan, “Ao yon, eragi gega pait ae ma wara ak.” ");
INSERT INTO dgz_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ame no utap apan inakaen. Me eragi mega ae ma ware boge aen. Yo mame venaseniwa, Diu nagirewa wagat wamewa gapan gapan. ");
INSERT INTO dgz_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ap menan Diu nagirewa inak wareni apane inap wane, “Diu pura muga bawarewa wagat wamewa ge eragi waran ingiana ame iup paina yamasingi.” ");
INSERT INTO dgz_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Go Iesu gare anega wan, “Apan ansena tanegen inak warana ame inanap anega wan, eragi gega pait ae ma wara ap ak.” ");
INSERT INTO dgz_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Menan mu singui anega tayawane, “Ame orup ambe da wan amba ge eragi ae ma wara ap agean?” ");
INSERT INTO dgz_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Inak waneni apanewa me oare ame da, iwa Iesu boge ap mepe waenapan barat mutane gapan karaua totnak taue yaumakamup aen. ");
INSERT INTO dgz_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Evi amba Iesu apan ame God Paewa gwanap taneni anega dien, “Yao anu kakayat, ge gaset inak waraan. Ap menan koewa da sia ya ta iwa koewa iragenawa da sia waragepi tawa.” ");
INSERT INTO dgz_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Apan ame aeni taue Diu namu yoyo nagire anega wadiamon, “Wat inakam nimanegeni apanewa ame yaua Iesu.” ");
INSERT INTO dgz_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ian Diu nagirewa Iesu inap wawa koko tane, iwa Iesu wam pura bawarewa iupewa to paiseniwa amba apan ame den wat inakameni menan. ");
INSERT INTO dgz_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Iesu anega diamon, “Ne Mamana God nao mega ta onin en mame tauia, ap menan ne den nao taivingain.” ");
INSERT INTO dgz_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ap menan ian Diu nagire Iesu topen menan anu sisimen taiwanumun, iwa wam pura bawarewa iupewa to paiseni megenat uon go God mek mame iragena waiwandiniwa amba mek ingane God den om inat wa taiwandini menan. ");
INSERT INTO dgz_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Iesu garewa manega wadiamon, “Ne tave di wadiaivin, ne Mamana God otua ne di, ap menan dim dim da ne negenat ya di tain iwa Mamana dim da taniwa ne gaset yawana gapan ap umape megenat di taingapen iwa ne, God otua, Mamana umapewa tainawa. ");
INSERT INTO dgz_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Mamana nenan anu gureni menan dim da anun taini ta ewanegiwan. Yo ugup ugup yawayana ame gauarap, evi amba Mamana ewanegep ne yo aigape di taingain e yawane amba kuin tarak wai. ");
INSERT INTO dgz_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ne Mamana waini bop tane nagire inak musinewa. Otua ne ap mini orup da da imuna warepiwa ne inak wanain. ");
INSERT INTO dgz_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Mamana waenapan wanene ya tamota go wanene tata aroewa ne nenen. ");
INSERT INTO dgz_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ap menan waenapan iragi i omani seane Mamana viriwa taine mini ap anega ne inanap tain. Menan ne otua Iesu waenapan viripana ya tapi Mamana, ne watu enanegeni, viriwa mu den ya tain, iwa Mamana watu enanegeni menan. ");
INSERT INTO dgz_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Nop tavewa di wadiaivin, da da nona anu amba wa watu enanegeni apanewa God anu tumasepiwa inak yaibobot wariwandata. Orup ame God ya wanene tata go bop arewa gapan am ninigame inak arewa dotou aen. ");
INSERT INTO dgz_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ne tave di wadiaivin, wam usira wandeni onin en ma gaset tauen bop nagire God otua nona anuin amba mu da da anupiwa inak warain. ");
INSERT INTO dgz_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Mamana me mek inak urewa di menan, me otua, ne, inak urewa nenen. ");
INSERT INTO dgz_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Amba ne wanene tapen aroewa neneni iwa ne Kimani Vitana apanewa. ");
INSERT INTO dgz_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ap menan seke ya tane, wam oniwan borit wane nagirewa nona anu ");
INSERT INTO dgz_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ao yon wanumoin, mu kakae tane nagirewa mu ao yone inak warain, go mu koewa tane nagirewa ao yone wanene tautanain. ");
INSERT INTO dgz_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ne nek ingane dim da ya tain, go dim da Mamana wadianegeni ap gapan wanene tamuivin. Ne wanene nega tamana iragen iwa ne nek nenan ya taivin go Mamana imu pose warapen menan taivin.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Iesu sia anega wan, “Ne nek ingane oit nega wapenawa, oit nega aroewa uon. ");
INSERT INTO dgz_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Go God oitana waiwan amba ne asiginap anenen me oit nega wainiwa ame tavewa di. ");
INSERT INTO dgz_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","E Dion inap singui tayawapen menan waenapan watu enamoyan amba me oit nega tavewa di wadiaen. ");
INSERT INTO dgz_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ne waenapan da oitana wapen menan yowa ya taivin go Dion ne oitana wadiaeni gapan e inak warapen menan nop mame wadiaivin. ");
INSERT INTO dgz_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Dion me dun mini yagire ganasewa muniwandin, ap gapan e wam koni otu da ganat mega atonu tayan. ");
INSERT INTO dgz_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Go ne inak nega gueguewa itaniwa aigap Dion mega mini uon. Nao nega iragena Mamana taitamet wa neneni, mame di taivin. Nao nega mame tavewa wadiaivin ame God wa watu eneni apanewa ne me di. ");
INSERT INTO dgz_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Amba Mamana watu enanegeni mek ingane gutut negawa waiwan. E Mamana nop waini da ya anuyan o irewa da ya yawayan, ");
INSERT INTO dgz_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","o nop mega potayap dugup ya waren wandia, iwa e ya anu tumasiwanin me daiton da ne watu enanegeniwa. ");
INSERT INTO dgz_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","God nop mega namua ok seane pot pot batnagiwanin iwa nop ame gwanap inak yaibobot warayana anuiwanin. Nop ame oitana waiwan. ");
INSERT INTO dgz_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Go e inanap tanda taiwanin inak wara wara menan onaet ya anuiwanin. ");
INSERT INTO dgz_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ne apan wa atonat mega ne ya warain, ");
INSERT INTO dgz_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","go ne asik taena ame, God baigan mega potayap ya wandia. ");
INSERT INTO dgz_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ne Mamana Kimaniwa yaua gapan tauan, go e ya waranegean, go ne asiginap orup ugupe da ambagan mek yaua gapan tauepi, e menawaet warai. ");
INSERT INTO dgz_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","E gare gare wa atonat taiwanin go God wa atonat imaepen yowa ya taiwanin ap menan anenen amba anu tumat nimanegai? ");
INSERT INTO dgz_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Go Mamana namup e tandayat nimanegiana menan ne ya anu koeragam imain go Mosis, e anu daviana apanewa, me anu koeragam imaeta. ");
INSERT INTO dgz_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","E Mosis anu tumasiwaniampinawa, ne den anu tumat nimanegai, iwa me ok nenan se wan. ");
INSERT INTO dgz_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Go Mosis ok se wani ya anu tumaseana, anenen amba ne wapena anu tumat tai?” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Wam mame ewap, Iesu kaum awan Galili kabum gagap to nuguse eto yamu dotou aen, kaum awan ame yaua dawa wainewa, Taibirias. ");
INSERT INTO dgz_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Iesu yo mega paua ugup ugup ta vek nagire wat inakam mumiwandin gase yawane menan waenapan iragi to iamen ewap kaum etop ikukuk pusimup amon. ");
INSERT INTO dgz_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Boge Iesu togan dot ae wadiamot mega tanamo den wanden. ");
INSERT INTO dgz_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Wam ame gapan ian Diu nagirewa Paina Yamaseni Baripewa konintu tauiwandin. ");
INSERT INTO dgz_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ap mepe wanumone Iesu yangut tani waenapan arugataet da to iamen inewa onam wanumune yawamon. Menan Pilip anega dien, “Nu taba une amba tat waenapan aru ma munat nain?” ");
INSERT INTO dgz_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Me singui ame wani mondi Pilip pusip warup yawapen menan, go anenen ta ta inagewa me gaset anun. ");
INSERT INTO dgz_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilip gare anega dien, “Akae Ayop, nu bodu daitona navewa tatawa, garewa nugawa agim make warat, taba une ta munat, ame umap uon, iwa waenapan daiton daiton semu otu otu napi umamup ya tamota!” ");
INSERT INTO dgz_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Amba Iesu wadiamot megawa apane da, Anduru, Saimon Pita gwaniwa, anega wan, ");
INSERT INTO dgz_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Orup apan otu da mapa buredi magamene nani yamunaet amba meo kamontua dere mapa tambun, go waenapan aru mame mu napi umamup ya di tata.” ");
INSERT INTO dgz_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Menan Iesu wadiamot mega anega diamon, “Waenapan diamone, ap mepe unawat aigap ae wanumop.” Boge waenapan ap mepe ae wanumone. Apan paua muga arugataet da (5000 mini) wanumon. ");
INSERT INTO dgz_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Boge Iesu buredi magamene ame tambu God inap gaun wan, yan aiman se munen muk anuine gapan amba tam naiwanumun, amba meo ap anega den sia tan. ");
INSERT INTO dgz_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Waenapan taba ame nane iragi umamup tan. Iesu wadiamot mega anega diamon, “Taba nan semua veanewa iragi bongamen, da danam danam ya tapen.” ");
INSERT INTO dgz_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ap menan buredi magamene ge meo semua veane bongam enane kaenat aonagaet pusinawan dere no dotou wane. ");
INSERT INTO dgz_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Taba nane ewap, waenapan iragi Iesu yo ame tan yawane anega waiwanumun, “Tavewa di, apan mame God noa waini apanewa da, nu piup ma gapan amase taintoniwa mame tauen.” ");
INSERT INTO dgz_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Waenapan nop barim onamo Iesu nanamase wap ayop muga tapen menan waiwanumune. Iesu ame anuni menan tanda ta megenat togan dot aen. ");
INSERT INTO dgz_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Wam ame mum gine, Iesu wadiamot mega, mugenat, kaum awan baware Galili ame vit amon. ");
INSERT INTO dgz_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ap mepe kabum gagap dotouen awan ame gamu to nugusen at Kaponiam amuiwanumune, mum tauen. Wam ame Iesu den intum ya tamon. ");
INSERT INTO dgz_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ame gapan taik baware tauen kaum tuewa tonagasiwandin. ");
INSERT INTO dgz_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Mu bara tan awan nimakap tauane (6 kilomita mini) ap mepe Iesu kaum gagap ap mu gambenamu oniwandin yawan tap anu guran. ");
INSERT INTO dgz_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Go Iesu anega diamon, “Ma ne, tap ya anune.” ");
INSERT INTO dgz_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Mu boge daramu wan Iesu wat agoasene kabum gwanap dotouen, menawaet kabum amot anuiwanumune arewa gapan awan etop ase enasen. ");
INSERT INTO dgz_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","23","Woup seni amba, waenapan, ayop buredi wat aipakam munen nane arewa gapan wanumone, Iesu wadiamot mega mugenat kabum daiton ame gapan dotou amone yawamone. Mu Iesu den ya aet anun iwa kabum dawa da uon. Go ame mumagetawa kabum upi at Taibirias gapan tauan. ");
INSERT INTO dgz_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Menan waenapan yawamone Iesu go wadiamot mega ap mepe den uon, boge mu kabum upi gapan sia dotouan Iesu yowa at Kaponiam amon. ");
INSERT INTO dgz_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Waenapan Iesu yowa tane kaum awan ame eto yamune gapan yawane singui wayaviwanumun, “Wadianiana apanewa, ge mapa andi tauan?” ");
INSERT INTO dgz_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Iesu gare wan, “Ne tavewa gapan di wadiaivin, ne yona taiwaniana iwa e yo paua nega yawayana menan uon, go iwa e taba nayan bagu kaume yaneni menan sia onayan. ");
INSERT INTO dgz_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Taba koe taini navewa menan ya taiwanian go yaibobot tabaewa menan navewa taiwanian. Yaibobot tabaewa ame God Kimani Vitana apanewa, ne, enain. Iwa Mamana God amun mega nene umap wani menan.” ");
INSERT INTO dgz_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Iesu ame wani mu singui ase sia wayaviwanumun, “Nu God anuini navewa nu ansenawa da tata me aton anuta?” ");
INSERT INTO dgz_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Iesu gare sia wan, “God nao megawa mam, wa watu enanegeni otua ne di anu tumat nimanek waniampen.” ");
INSERT INTO dgz_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ap menan mu anega sia diane, “Endi ge yo ansena da sia tai gapan nu yawat anu tumat gimagait? Ge dim da tai? ");
INSERT INTO dgz_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Nu isimuran wainu wataget at kaimewa gapan taba mana nane, Oise Kakaewa gapan ok seane wandia, Me buredi mana kimaniwa munen nane.” ");
INSERT INTO dgz_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Iesu anega wadiamon, “Ne tavewa di wadiaivin, buredi mana ame Mosis muneni ame kiman tabaewa da uon, ne Mamana taba buredi tave iragenawa kimaniwa di eniwandata. ");
INSERT INTO dgz_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Amba God buredi megawa kimani viseni ameme ne me di amba ne waenapan inak yaibobot muningain.” ");
INSERT INTO dgz_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Mu sia wayaviwanumun, “Arita nugawa, wam mame use aeniwa gapan buredi mame pot pot nuningan.” ");
INSERT INTO dgz_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Menan Iesu gare wadiamon, “Ne inak yaibobot tabaewa, da ne dirin wapun menan nanamuna tapiwa me enup ya areta. Me ne di anu tumat nimanek wandapinawa, me mege ya pakaraiwandata. ");
INSERT INTO dgz_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Go ne gaset namu wadiaen, e yawanegiwanin go e ya di anu tumat nimanegisi. ");
INSERT INTO dgz_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Mamana da da imu pose entan ta nenepi ame nanamuna onamoin, ame nenan onamopi ne ya up oimoin. ");
INSERT INTO dgz_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Iwa ne kimani vit ongena, Mamana God dim da anuini tapen menan ongen, nek anut nega men uon. ");
INSERT INTO dgz_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Endi God watu enanegeni apanewa anut mega mam, me neneni waenapan da daiton mini ya wakaumapen go wam verisiwa tauepi ne tapena inak muse iravi ao yon wanumoin. ");
INSERT INTO dgz_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ne Mamana anuini ame waenapan ne yawanege anu tumat nimanegepi mu yaibobot inagewa tautanain. Amba wam verisiwa ne tapen inak muse ao yon wanumoin.” ");
INSERT INTO dgz_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Nop ma wani, iam Diu nagirewa gwen gurut wan notatae wane, iwa me anega wani menan, “Ne Kimani Vitana tabaewa.” ");
INSERT INTO dgz_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Menan mu anega wane, “Ma Iesu apan Diosep otua ine mame nu asiginup iwa dimen me anega waiwandini ne Kimani Vitana tabaewa?” ");
INSERT INTO dgz_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Iesu anuni me gare anega wan, “Gare gare gwen gurut ek waiana ae vean, ");
INSERT INTO dgz_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Orup da da mu aro muga gapan inanap ya onamoin go Mamana watu enanegeni wa upamopi inanap tauain. Amba ame wam uiwa gapan, ne tapen inak muse ao yon wanumoin. ");
INSERT INTO dgz_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Wataget God nop oit mega waiwanumune nagire ok anega seane, God mek waenapan wadidiamuiwandata. Nop ame tavewa waenapan da da darine pemak Mamana nop wapi anupiwa amba me inap yao asik tapiwa ame nenan onamoin. ");
INSERT INTO dgz_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Waenapan da Mamana ya yawane, ame God den wandini otua megenat Mamana yaven. ");
INSERT INTO dgz_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ne tavewa di wadiaivin, orup da anu tumat taiwandapinawa yaibobot inagewa wareta. ");
INSERT INTO dgz_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ne inak tabaewa. ");
INSERT INTO dgz_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","E isimurae wai wataget at kaimewa gapan taba mana nane go mu borit wane. ");
INSERT INTO dgz_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Go taba endi mame kimani vit oneni ame ugup, orup da napiwa me ya boeta. ");
INSERT INTO dgz_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ne yaibobot tabaewa Kimani Vitanawa, orup da taba mame napiwa yaibobot wande aiwandata. Taba mame ne etunawa ame ne iragi piup ma munan inak gamup wariwanumain.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Iesu nop mame waiwandin anune menan, ian Diu nagirewa ugu gangane den nop kaimakaet gare gare anega wane, “Apan ma nive mone anenen nunep nata waiwan?” ");
INSERT INTO dgz_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Iesu anega sia diamon, “Ne tavewa di wadiaivin, e kimani viseni apanewa etua ge deniwa ya nanewa, kiman inak megawa da potayap uon. ");
INSERT INTO dgz_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Orup da da ne etuna ge denina napiwa mu yaibobot inagewa gapan wanumoin. Amba wam uiwa gapan ne tapen mu inak muse ao yon wanumoin. ");
INSERT INTO dgz_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ap menan, ne etunawa ame inak tabae iragenawa amba deninawa inak kaume iragenawa. ");
INSERT INTO dgz_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Orup da da etuna ge denina napiwa ame mu ne potanap wanumoin amba ne mu potamup wanik angingain. ");
INSERT INTO dgz_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ne Mamana yaibobot wandiniwa watu enanegen menan ne wanik angin iwa Mamana gamup, ap umap sia orup da ne gamunap inak tabaewa naiwandapinawa me wande aiwandata iwa ne gamunap. ");
INSERT INTO dgz_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","E isimurae omae bae taba mana nane borit wane, go taba buredi mame kimani viseniwa menan orup da taba mame na iniwandapinawa me yaibobot wande aiwandata.” ");
INSERT INTO dgz_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Iesu nop mame waiwandini ame iam iam paewa at Kaponiam gapan wadidiamuiwandin. ");
INSERT INTO dgz_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Nop mame anune Iesu wadiamot mega anega wane, “Ma anenen opata ma kaimake den, da anu wareta?” ");
INSERT INTO dgz_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Iesu mawap wane go Iesu imua gapan anuni, wadiamot mega aigap doran waiwanumune menan me anega wan, “Nop mam kaimake den waingina menan endao imaewan? ");
INSERT INTO dgz_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Endi ne namu kimani waingena arewa sia angepen yawanege e anenen anui! ");
INSERT INTO dgz_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Mame Guewa Woup Seniwa yonen inak muniwan, go nu etunua inak da ya muniniwa. Ne inak nopewa wadiaena ame God Guewa aroewa gapan tavewa arogameta, amba nop ame inak muniniwa. ");
INSERT INTO dgz_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Endi ne waingina e upi anu tumat ya taisi.” Iesu ame wani iwa ere mangan iragen Iesu me asigip tan orup ansena ya anu tumasiniwa amba orup ambe da omine wata. ");
INSERT INTO dgz_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Iesu sia anega wan, “Ap menan ne namu wadiaena orup da mek aro mega gapan inanap ya oneta go Mamana imu pose entan tapi gapan amba oneta.” ");
INSERT INTO dgz_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Wam mame use aeni gapan wadiamot mega upi tandayasen ae vean, amba ewap da sia ya amon. ");
INSERT INTO dgz_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Iesu apan aonagaet pusinawan derewa anega wayawamon, “Endi e den ae venek aiset anuiwanin go?” ");
INSERT INTO dgz_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Amba Saimon Pita garewa wadien, “Ayop, nu aneta da menan anait? Ge nop gegawa megenat yaibobot inagewa. ");
INSERT INTO dgz_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nu anuton anu tumat taivin ge God watu eneni potaga woup seni apanewa daiton iragenawa.” ");
INSERT INTO dgz_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Iesu entan gare wan, “E aonagaet pusinawan derewa nagirewa om ne enuyen. Go e yaumakayap orup daiton megenat koerage.” ");
INSERT INTO dgz_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Iesu ame wani Diuda apan Saimon Iskeriot otua menan wan. Me apan aonagaet pusinawan derewa ame da go evi me Iesu ominewa wata. ");
INSERT INTO dgz_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Mame ewap, Iesu at Galili gapan ikukuk tau ge tau aen, amba at Diudia den ya aen iwa Diu nagirewa togurapen amase ap mepe taiwanumune. ");
INSERT INTO dgz_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Go wam ame Diu nagire dugup wanup gapan tune baripe konintu tan. ");
INSERT INTO dgz_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Iesu gwani waiwa denip mega daitonawa me inap anega wane, “Ge at ma ae ve amba at Diudia ak, ap me gapan wa ewamot gegawa Diudia gapanawa yo paua ugup ugup gega yawain. ");
INSERT INTO dgz_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Iwa orup ansena da yaua aroga tauat anuiniwa karaua ya tata. Ap menan wataget ge inak ugup ugup taingiana, gek ingane piup ma to ewat.” ");
INSERT INTO dgz_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Iesu mek gwani waiwa anu tumat da me inap ya tane menan ap anega wane. ");
INSERT INTO dgz_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Go Iesu inamup wan, “Wam nega tamanawa ya di onen tauia, go wam ega union da di. ");
INSERT INTO dgz_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Piup ma e ya tandayat imaiwan, go ne tandayat nimanegiwan iwa mu koewa muga wat arogam mumivin. ");
INSERT INTO dgz_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","E barip gage aisen. Ne endi barip ame gage ya di dot ongain, iwa endi mame ne wam nega tamanawa da uon.” ");
INSERT INTO dgz_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Mame wani ewap me Galili gapan wande en. ");
INSERT INTO dgz_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ap menan, gwani waiwa barip menan amone ewamup, me den aen, aroga uon, go karaua. ");
INSERT INTO dgz_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Endi yawat mega barip ame gagap Diu nagirewa Iesu menan yangut tan singui waiwanumun, “Apan ame amba?” ");
INSERT INTO dgz_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","To iam baware ameme gapan nop simura wa agagam baraene senaren. Upi wane, “Me apan kakae” upi gare wan, “Uon, me waenapan ebo ewamuiniwa.” ");
INSERT INTO dgz_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Go Iesu menan da daiton aroga ya di wane iwa Diu nagire tamu tane. ");
INSERT INTO dgz_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Barip tane uon ya tan amba yaumakap Iesu God Paewa dot ae opata wadidiamon. ");
INSERT INTO dgz_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Diu nagirewa no i kap wane amba anega wan, “Apan ma anut amba anenen waren, anut yowa da ya tainiwa?” ");
INSERT INTO dgz_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Iesu gare wan, “Dim da wadiaingina ma negawa uon go God watu enanegeniwa me inap tauen. ");
INSERT INTO dgz_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Da da God nop mega anu tapiwa, ne God amun mega gapan waivin o nek waivin, ame mu anuin. ");
INSERT INTO dgz_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Me da mek megenat menan nop wainiwa, mek yaua ao wabawaramepen men mek ingane waiwan, go da me watu eneni menan nao tan yaua ao wabawaramepen men tainiwa apan ame tavewa, ap mepe me inap ebo da uon. ");
INSERT INTO dgz_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mosis God iup mega da enen go uon? Go daiton iup da amat ya taiwanin. Dimen wat toguranegepen menan taiwanin?” ");
INSERT INTO dgz_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Mu gare wane, “Ge airampu wa guragen. Ma da toguragepen taiwan?” ");
INSERT INTO dgz_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Iesu inamup anega wan, “Ne yo daiton pura bawarewa gapan tan e iragi yao ugu gangan anuyan. ");
INSERT INTO dgz_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Iwa dimen? Mosis God paua mega apan etuya tunapen ok seni iup ame enen. (Tat mega tamana di mame Mosis inap ya tauen go mame apan Eibaraam amba isimuran wainu upi den). Ap menan e orup otu upi etumu pura bawarewa gapan tunamoyan. ");
INSERT INTO dgz_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Orup da pura bawarewa gapan etua tunepiwa menan ame Mosis iup mega ya topaitayan, iwa dimen pura bawarewa gapan apan wat inakamena e ugu gangan inanap taiwanin? ");
INSERT INTO dgz_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Guegue ase yavianawa gapan wanene ya tane, tavewa gapan wanene tan.” ");
INSERT INTO dgz_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Nop ame gapan waenapan upi pa Ierusalem gapan singui tayawamon, “Apan ma togurapen taine apanewa? ");
INSERT INTO dgz_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Me mame nop aroga di waiwan, iwa dimen mu ya watanane? Ap menan Iesu me God om enuni apanewa, Keriso di anuiwanumun? ");
INSERT INTO dgz_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Go nu anuivin apan ma ambagan tauen, wam ame God om enuni apanewa, Keriso tauepiwa da daiton ya anuin me at ambe gapan tauen.” ");
INSERT INTO dgz_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Menan Iesu God Paewa gapan yone wadidiam wandini ve anega wan, “Tave di, e ne asigiap amba den anuyan ne at Galili gapan tauan. Go God, ne kiman gapan watu enanegeni, me da e ya yao anuyan. Piupa Vitana aro amun nega gapan ya wanik angin go God tavewa iragenawa watu enanenegen gamup wanik angin. ");
INSERT INTO dgz_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ne God asiginap tan iwa ne me inap tauan amba me watu enanegen.” ");
INSERT INTO dgz_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ap me wani menan Iesu warapen tane, go umap uon, iwa togurapen wamewa ya di tauia. ");
INSERT INTO dgz_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ap me gapan waenapan arugataet to iam ame berip me inap anu tumat tane. Mu anega wane, “God wa watu eneni mega Keriso taue yo paua arugataet tata, go Iesu taini mini aigape orup da ya tata!” ");
INSERT INTO dgz_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","To iam baware ame gapan Parisi nagirewa waenapan nop simura waiwanumune anune menan mu ge pirisi nagirewa, God Paewa amat taine nagirewa Iesu to warapen menan watu enamone. ");
INSERT INTO dgz_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Iesu anega wan, “Ne inayap wanigepena wam koni bobou otu da, amba boge watu enanegeni apanewa ine angain. ");
INSERT INTO dgz_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","E yona tai, go e ya tananegai. Ne amba wanigepena e ya tauai.” ");
INSERT INTO dgz_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Diu nagirewa muk gare gare anega wane, “Apan ma anut mega gapan amba aepi nu me ya tanat waiwan? Me wandap Diu nagirewa ian Gurik at muga arige gapan wanumuinewa mu inamup ae wadidiamopen menan waiwan go? ");
INSERT INTO dgz_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Me manega waini tavewa dim da? ‘E yona tai, go e ya tananegai. Ne amba angepena e ya tauai?’” ");
INSERT INTO dgz_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Barip ame wam verisiwa gapan, Iesu ao yon wande amba nop kaimakaet anega wan, “Da da megewa pakaraepiwa, me inanap one amba kaum nap. ");
INSERT INTO dgz_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","God nop mega namua ok anega seane, Me da da ne anu tumat nimanegepiwa, me gamup inak yaibobot, kaume urewa bobot wa taue aiwandata.” ");
INSERT INTO dgz_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Iesu inak yaibobot kaumewa maibe mini wani, tavewa ame Guewa Woup Seniwa menan wan. Da da anu tumasepiwa Guewa Woup Seniwa evi da mu warain. Iwa Iesu wam ame gapan kiman ya dot aen, go evi amba Iesu kimani aepi Guewa Woup Seniwa watu en muneta. ");
INSERT INTO dgz_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nop mega anuiwanumune waenapan upi anega wane, “Tave di apan ma Keriso tauapen menan God noa waini apanewa.” ");
INSERT INTO dgz_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Upi anega wane, “Me God wa watu eneni mega Keriso di.” Go upi gare wane, “Uon, iwa Keriso at Galili gapan ya taueta. ");
INSERT INTO dgz_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","God oise kakaewa namua seane ame, Keriso, me Devit naewa, at Betiriem gapan taueta, (at Betiriem ame apanewa Devit iniwandini arewa).” ");
INSERT INTO dgz_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Menan waenapan seu enun iwa Iesu gagap wane. ");
INSERT INTO dgz_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Upi warapen anun, go da ya to warane. ");
INSERT INTO dgz_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Menan God Paewa amase taine nagirewa ewagai amon pirisi bawarewa amba Parisi nagirewa mu singui wayawamon, “Iwa dimen Iesu ya wat onayan?” ");
INSERT INTO dgz_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Amase taine nagirewa aroga gare wan, “Apan daiton da nop manega ya waiwandini ame Iesu me waiwan.” ");
INSERT INTO dgz_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Parisi nagirewa gare kaimakaet diamon, “E waiana Iesu e den pusiap warupen go? ");
INSERT INTO dgz_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Diu namu yo yo nagirewa, iup namua anut warine nagirewa, ge nu Parisi nagirewa da Iesu ya anu tumat taton. ");
INSERT INTO dgz_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Uon! Go orup mondigawa, iup ya anuine nagirewa, mugenat Iesu anu tumat tane. Ai! God nemoro mega inamup wandep.” ");
INSERT INTO dgz_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodimas erewa gapan Iesu ine ae amba Parisi nagirewa den tobot daitonawa, singui anega wayawamon, ");
INSERT INTO dgz_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Iup nuga manega waiwan, orup da namu wanene ya ta go me dim da taniwa e namu yao anun amba wanene tan.” ");
INSERT INTO dgz_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Mu gare wan, “Ge den at Galili apanewa go? Ge yambuni God iup mega namua gapan yop ta, God oise waini apanewa da at Galili gapan ya taueta.” ");
INSERT INTO dgz_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ame wane gapan mu daiton daiton pa muga muga amon. ");
INSERT INTO dgz_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Go Iesu tunup Olip, Ierusalem mainepewa, dot aen. ");
INSERT INTO dgz_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Amba mumaget iragen Iesu Ierusalem vit ae God Paewa sin gwanap namboya tauen, ap mepe waenapan iragi ikukuk nau panane me boge ae wande opata wadidiamuiwandin. ");
INSERT INTO dgz_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Amba God iup mega amase tainewa ge Parisi nagirewa togane tapatap tani waenewa da waran tauan. Waen ame waenapan namumup wane yonen. ");
INSERT INTO dgz_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Amba Iesu anega diane, “Wadianet nugawa, waen ma togane tapatap tani menan wara tauaton. ");
INSERT INTO dgz_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Apan Mosis iup mega manega waiwan, ame waen togane tapatap ap anega tainiwa agima togurep boep. Menan endi ge anen wai?” ");
INSERT INTO dgz_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Mu singui mame waiwanumune iwa Iesu pusi warupep ebo wa gapan God iup mega da yamasepen menan. Go Iesu kaut enu nani piru gapan ok pia ae siwandin. ");
INSERT INTO dgz_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Mu yaugai di singui yasiwamumune, me ao endimase anega diamon, “Endi e orup ansena koewa da inap uon wandepiwa, orup ame namu agim ware waen mame top ne yawap.” ");
INSERT INTO dgz_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Iesu nop ame wani amba, kaut sia enu ok piupa siwandini. ");
INSERT INTO dgz_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Waenapan nop mame anune menan tap daiton daiton di amuiwanumun, aeta nagirewa namu di amon. Ap menan Iesu waen ame den mugenat wanumune. ");
INSERT INTO dgz_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Iesu gari sia endimase waen ame anega dien, “Waenapan mapawa ambagan? Orup da koewa gegawa menan da ya wa koeragam gimagen?” ");
INSERT INTO dgz_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Waen gare wan, “Ayop, orup da ya wa koeragam nimanegen.” Amba Iesu nop uiwa anega dien, “Endi ne den koewa gega gapan ya wa koeragam gimagain. Go ganawan, ak koewa da sia ya ta.” ");
INSERT INTO dgz_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Wam ame gapan, Iesu waenapan ame anega sia wadidiam wandin, “Ne piup ma dun ganat megawa, orup da ne evinap oniwandapinawa me ap mum sisip gapan da ya aeta go inak dune ganasewa wareta.” ");
INSERT INTO dgz_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Go ian Parisi Iesu diane, “Ge gek oitaga waingi amba yauga wat bawaramepen menan taingi menan nop gega tavewa uon.” ");
INSERT INTO dgz_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Iesu gare wan, “Ame endi nek nenan anu ta guringapenawa, ne nop oit nega tavewa di, iwa ne amba tauana arewa ge angepena arewa e oare go ne asiginap. ");
INSERT INTO dgz_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Piup om mega gapan e wanene tamuianawa go ne ap mini orup da inap ya tainawa. ");
INSERT INTO dgz_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","17","E iup ega gwanap ok manega seane, Apan evene siwa naun nop daiton dere waine ame tavewa. Ap menan endi ne anut nega gapan wanene tapenawa tamana venaseta, iwa ne negenat ya wanik angin. Ne mamana me watu enanegeniwa den yonivin. ");
INSERT INTO dgz_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ne nop oit nega nek waivin, amba ne watu enanegeni Mamana God, sina nauiniwa.” ");
INSERT INTO dgz_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ian Parisi nagirewa singui anega wane, “Ge Mamaga endi ambagan?” Iesu gare anega wan, “E ya asigiap tanegean amba den ne Mamana ya asigiap tayan, endi e asik tanegepoa e Mamana den asigip tapo.” ");
INSERT INTO dgz_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Iesu nop mame waiwandini God Paewa yan garaet sine mainep ap mepe opata wadidiam wandin, ap waiwandini waenapan da ya to warapen tane, iwa wam mega iragena ya tauen. ");
INSERT INTO dgz_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Nop ap me uap Iesu sia diamon, “Ne angepena e yona taiwaniai, go ne amba angepena e ap mepe ya tauai, amba e koewa ega den borit wai.” ");
INSERT INTO dgz_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Iesu nop mame wani Diu nagire singui muk wa wa mutan, anega wane, “Mek ingane togurep boeta? Endi ap menan Iesu anega wan, ‘Ne amba angepena e ap mepe ya tauai?’” ");
INSERT INTO dgz_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Go Iesu aigap di waiwandin, “E aoma isira mapa ne aigap aupa, e piup ma megawa, ne piup ma megawa uon. ");
INSERT INTO dgz_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ne gaset wadiaena, ne Keriso ya anu tumat tanegenewa, tavewa di, e koewa ega den borit wai.” ");
INSERT INTO dgz_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Mu singui wayawan, “Enda ge da?” Iesu gare wan, “Ne gaset gaset amba di wadiae angingin. ");
INSERT INTO dgz_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ne wanene ega tae tae arugataet di. Go Mamana watu enanegeni apanewa nop mega tavewa di, me inap gego da uon. Amba ne nop, me gamup anuinawa ne piup ma waenapan iragi wadidiamoin.” ");
INSERT INTO dgz_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Iesu Mamewa God menan waiwandini mu da ya di anu awane. ");
INSERT INTO dgz_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ap menan Iesu anega wan, “Ne Kimani Vitana apanewa ao waran to endawanegene e anu awai ne Keriso di. Menan noa wainawa nek anut nega gapan ya taivin, go Mamana anen wadianegeni gapan di taivin. ");
INSERT INTO dgz_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Endi watu enanegeni inanap di wandia. Me ae wat, vetanegen negenat da ya waingiangin iwa ne pot pot dim da taina God anuini imua ame wabibigamina menan aton anuiwan.” ");
INSERT INTO dgz_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Me nop waiwandini waenapan aruga imu pose iravi me inap waren, amba anu tumat tane. ");
INSERT INTO dgz_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ian Diu me inap anu tumasenewa, Iesu anega diamon, “Endi e nop nega wat kakayasenewa, e ne wadiaet nega iragenawa di. ");
INSERT INTO dgz_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ap menan nop tave tavewa e asigip tai, amba nop tavewa ega vetaeta.” ");
INSERT INTO dgz_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Mu garewa anega diane, “Nu Eibaraam naewa! Nu orup da pusi nani wanawase da ya taton. Endi ame anenen vetanep tau anait?” ");
INSERT INTO dgz_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Iesu sia anega wan, “Ne tavewa di wadiaivin, waenapan da koewa tainewa ame koewa ayamase di taiwanum. ");
INSERT INTO dgz_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Dugup da gapan nao ayamat mondi kaimakaet taini otua go wam da ayamase apanewa dugup ame ae ve garip aeta, iwa me dugup ame otua uon. Go dugup ame otu iragenawa di wande aiwandata iwa me dugup megawa di. ");
INSERT INTO dgz_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Menan God mek otua ne vetaepen tau aisenewa ame di vetae kakayasen. ");
INSERT INTO dgz_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ne anuivin e Eibaraam naewa, go endi e toguranegepen amase taiwanin iwa nop nega wana warayan potayap da ya wandia. ");
INSERT INTO dgz_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ne wadiaingina Mamana inap yawan anuina gapan wadiaivin go e taiana ame mamaya ame wadiaeni gapan di taiwanin.” ");
INSERT INTO dgz_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Mu gare wane, “Eibaraam nu mamanua.” Iesu sia wan, “Go endi Eibaraam otu tasine wandepiwa, e wan dim dim Eibaraam taiwandini ame uap taiwaniampen! ");
INSERT INTO dgz_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ne nop tavewa wadiaina apanewa, God no utap di anun waivin. Go endi e toguranegepen taiwanin. Eibaraam ma miniwa da ya tan. ");
INSERT INTO dgz_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Amba ne yawaena e tat ega ame Eibaraam mini da uon, ap menan e Eibaraam naewa da uon.” Diu nagirewa anega wane, “Nu nain gagape otu tasinewa uon. Nu mamanua ame God nuga megenat di.” ");
INSERT INTO dgz_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Iesu anega diamon, “Go endi e mamaya God di wandepiwa, e imuya potaya nenan anu guriwaniampen. Iwa ne God inap ongen mame waingian, amba ne nek ya ongen, go God watu enanegen. ");
INSERT INTO dgz_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Di menan ne nop nega waingina aroga iragen ase ya anuiwanin? Iwa mamaya piupawa darinaya toboren. ");
INSERT INTO dgz_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","E mamaya piupawa ame Seitan otu tasinewa e me. Amba e mamaya inak megawa taiwaniat anuiwanin. Wataget ere mangan me togut wagut apanewa wande en, me nop tavewa da ya wat nat wande en, ap menan me nop mega iragenawa ame ebo aopan apanewa, amba eboewa mamewa. ");
INSERT INTO dgz_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ne nop tavewa gapan waingina go e mamaya ewap aisiana menan ne ya anu tumat nimanegiwanin. ");
INSERT INTO dgz_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Endi ne koewa tainawa, e da yao matakamiwanin? Go ne nop tavewa di wainawa, dimen ya anu tumat tanek wanin? ");
INSERT INTO dgz_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Orup da God otua di wandepiwa God anen wainiwa me anuta. Go e God nop mega ya anuiana menan e God otu wai uon.” ");
INSERT INTO dgz_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ian Diu nagire gare anega diane, “Endi nu Sameria apanewa diagitoni ge airampu potagap den waintoni ame tavewa di waivin?” ");
INSERT INTO dgz_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Iesu anega wan, “Ne airampu da potanap uon. Go ne Mamana viripewa taina ap mini e virina ya taiwanin. ");
INSERT INTO dgz_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ne nek yauna ya wabawaramivin go God ne virina tainiwa menan ne yauna wabawarameta. Amba me wanene taini apanewa. ");
INSERT INTO dgz_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ne tave di waivin, orup da nop nega wat kapet wandepiwa me bop da inap ya taueta.” ");
INSERT INTO dgz_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ian Diu mame menan aigap doran sia wane, “Endi nu asiginup ge airampu potagap wandiniwa! Eibaraam boen ge God nop mega waiwanumune nagirewa den borit wane, go endi ge anega waingiana orup da nop gega wat kapet taiwandapinawa me ya boeta? ");
INSERT INTO dgz_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Endi ge Eibaraam amba watageta God noa waiwanumune aigamup? Eibaraam boen amba God watageta noa waiwanumune nagire borit wane. Ge anenen, endi anuingiana ge da?” ");
INSERT INTO dgz_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Iesu gare anega wan, “Go endi ne nek oya garie den wa taingapenawa oya gari ame tavewa da uon. Ne Mamanawa menan endi God ega waiana, oya oya mega neniniwa. ");
INSERT INTO dgz_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ame e den God asigiap ya tayan, go ne asiginap tan. Endi ne God ya asiginap wapoa ne ware ame ne umayap ebo wapo. Go ne me asiginap tana menan nop mega ayamase taivin. ");
INSERT INTO dgz_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","E omae baewa Eibaraam Guewa Woup Seni wadien anun ame ne nao tat nega wamewa tauapen tani atonua anun. Ap menan Eibaraam bet ine yaveni aton tan.” ");
INSERT INTO dgz_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ian Diu sia anega wane, “Ge bodu gega apane dere aonagaet ya tauiagi, go ge Eibaraam yawaan?” ");
INSERT INTO dgz_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Iesu anega wan, “Ne tavewa di wadiaivin, ne watageta da di waingen amba Eibaraam yanen.” ");
INSERT INTO dgz_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Iesu nop mame waniwa mu agim tambun topen tane, go Iesu waenapan yamamu ware karau ta God Paewa arige ae ve aen. ");
INSERT INTO dgz_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Iesu me neginaet aiwandini, apan da ine potap yame borasen yaneni yaven. ");
INSERT INTO dgz_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Me wa ewamot mega singui me inap anega wane, “Wadianet nugawa apan ma koewa me tani gapan go gare ine mame tane menan yame borasen yanen?” ");
INSERT INTO dgz_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Iesu anega wan, “Apan ma koewa mega gapan uon den ine mame koewa muga gapan uon. Go me yame boraseni iwa megawa ame God amun mega me inap arogamepen menan ma venasen. ");
INSERT INTO dgz_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nu wam ganase wandeni gapan God, ne watu enanegeni, nao mega menawaet di tainampen, iwa mum oniwan mum gapan daiton da nao ya tata. ");
INSERT INTO dgz_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ne piup ma gapan wanik anginawa, ne piup ma ganat mugawa di.” ");
INSERT INTO dgz_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Anega wani ewap me giton piupa ene tan motok entanen amba tambu apan yamap ao batamen. ");
INSERT INTO dgz_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Iesu anega dien, “Ak, yamaga kaum awan Sailoam gapan bigi wat.” (Nop Sailoam gueguewa ame Watu Enen.) Menan apan ae yamewa ap mepe bigi wareni, boge yame meret wan yangut ta amba pa mega aen. ");
INSERT INTO dgz_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Apan ameme evene waiwa amba mu da da namu yaviwanumune inamup mupaet wan nani mese eneni, mu singui anega wane, “Apan ma daiton pot pot wanden mup tainiwa?” ");
INSERT INTO dgz_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Upi wane “Ameme di.” Upinewa anega wane, “Uon, me yawat mega apan ap umap.” Go apan mek ingane wan, “Ne apan ameme di.” ");
INSERT INTO dgz_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Mu anu kakayasepen menan singui wane, “Da anenen amba yamaga watapen?” ");
INSERT INTO dgz_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Me gare wan “Apan yaua Iesu piup upi ware motok ta yamanap batamen, me dianegen ange kaum Sailoam, gapan bigi warat wan menan angen kaum Sailoam, gapan bigi waran, boge yangut tan.” ");
INSERT INTO dgz_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Mu singui sia wayawane, “Apan mame endi amba?” Me gare wan, “Ne oare.” ");
INSERT INTO dgz_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Apan namu yame borasen wandeniwa mu waran Parisi nagirewa inamup tauan. ");
INSERT INTO dgz_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yawat mega wam ame Iesu motok ta apan yamewa watapeni ap me pura bawarewa wamewa. ");
INSERT INTO dgz_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Menan Parisi nagirewa singui me inap tane anenen amba yamewa kakae tan. Me gare wan, “Apan da yamana motok batamen. Amba bigi waran endi yangut taivin.” ");
INSERT INTO dgz_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Parisi upi anega wane, “Apan mame God inap ya tauen, iwa me pura bawarewa iup mega topaisen.” Go waenapan upi singui wane, “Anenen amba koewa taini apane yo aru baware ma tata?” Menan mu imumu tum gigit waren. ");
INSERT INTO dgz_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ap menan uiwa gapan mu entanan apan yame boraseni inap singui wan, “Ge yamaga Iesu watapen. Endi me menan anenen waingi.” Apan gare wan, “Me God noa wainiwa.” ");
INSERT INTO dgz_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Go Diu nagirewa apan ame tamana di me ine potap yame boraseni, ya anu tumasene menan ine mame munan sepe amon. ");
INSERT INTO dgz_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ine mame tauane amba mu singui wane, “Mame e orup egawa? Orup ega yaneni gapan namu yame borasen? Ame anenen endi yangut taiwan?” ");
INSERT INTO dgz_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ine mamewa anega wane, “Nu anuivin me nu otunua. Amba yame borasen yaneni nu asiginup. ");
INSERT INTO dgz_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Go endi anenen amba me yangut taiwan, go da yamewa watapeni, nu oare. Mek singui tayawan, me orup arita di, mek ingane oit mega di wata.” ");
INSERT INTO dgz_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Me ine mame manega wane iwa mu Diu nagirewa tamu anune, iwa Diu nagirewa nop namu bariman wane orup da Iesu me Keriso di anu tumasepiwa ame dugup paewa gwanap warupe garip uat enain. ");
INSERT INTO dgz_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ap menan ine mame ap anega wane, “Me orup arita di, mek ingane oit mega di wata.” ");
INSERT INTO dgz_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Koni derewa mu apan namu yame boraseni menan wane. Mu singui anega wayawane, “God yamap tave di wa, nu asiginup apan mame koewa tainiwa.” ");
INSERT INTO dgz_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Me gare wan, “Me koewa tainiwa go gare uon, ne oare. Daiton megenat ne asik tana, ne yamana borasen go endi ne yangut taivin!” ");
INSERT INTO dgz_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Boge mu singui tayawan, “Me anenen tagen? Anenen ta amba yamaga watapen?” ");
INSERT INTO dgz_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Me gare wan, “Ne gaset wadiaena e ya anu warayan. Iwa dimen sia anupen waiwanin? E wa ewamot mega den entan imaep Iesu anu tumat tat anuiwanin?” ");
INSERT INTO dgz_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Boge mu togo uaren tan anega wane, “Ge apan ma wadiamot megawa di! Nu wadianet nugawa Mosis! ");
INSERT INTO dgz_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nu asiginup God nop Mosis inap wan go apan mame nu oare anenen da amba tauen.” ");
INSERT INTO dgz_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Apan gare wan, “Endi ame anenen! Me amba taueni e oare yamana me di watapen. ");
INSERT INTO dgz_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","E nu den asiginup God me koewa nagire nop muga ya anuiniwa. God apan tamanawa nao menan taini noa anuiniwa. ");
INSERT INTO dgz_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Waenapan da apan inewa potap yame borasen yaneniwa ame wat inakameni oisewa da ya wane anuton. ");
INSERT INTO dgz_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Menan apan ma God inap ya tauepiwa me dim kakaewa da ya di tata.” ");
INSERT INTO dgz_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Mame gapan mu gare wane, “Ge anenen e koewa inak ega gapan ap anegataet den yanianawa koewa ame guegue dimen wadianingi!” Amba mu me garip uat enane tau aen. ");
INSERT INTO dgz_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Iesu mu namu yame boraseni apanewa garip uat enane tau aeni oisewa anun amba wam da me apan ame taneni gapan Iesu anega singui wayaven, “Ge Kimani Viseni apanewa anu tumasingi?” ");
INSERT INTO dgz_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","“Me da?” apan singui anega wan. “Wadianege amba ne me inap anu tumat tap.” ");
INSERT INTO dgz_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Iesu anega wan, “Ge endi mame yavingianawa, ame tave di, daiton da, mame nop inagap waiwan.” ");
INSERT INTO dgz_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Boge apan anega wan, “Ayop, ne anu tumat taivin,” amba me i poe Iesu inap ta wa taragasen. ");
INSERT INTO dgz_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Iesu anega wan, “Ne wanene menan piup ma tauan, menan yame borat mutanewa yangut tain amba mu da yangut tainewa yame borat mutain, ame gapan ne gamunap seu enu munain.” ");
INSERT INTO dgz_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Parisi upi ap mepe me den nop anen wani anun menan anega wan, “Dim da? Nu den yaman borasen?” ");
INSERT INTO dgz_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Iesu anega wan, “E yamaya boraseniwa, e koewa inayap da uon, go endi e yangut kakaevet tat waianawa menan koewa ega di wandia, iwa tandayat nimanegean menan.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Iesu anega wan, “Ne tavewa di wadiavin, apan da man sip sin mega tonanewa gapan ya unugepiwa, go negin ugupewa gapan sin pain dore gwanap gearepi ame up ge togut wagut taini apanewa. ");
INSERT INTO dgz_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Go apan da tonana unugepiwa ame man sip kwayup taine i apanewa di. ");
INSERT INTO dgz_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Tonan kwayup taini apanewa tonan watap wanep, amba sip kwayup taini apanewa sip mega yaumu gapan gapan wap, mu noa ire anune ewap tauane amuinewa. ");
INSERT INTO dgz_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ame mek man megawa iragi naumo taue garip amopiwa, me use namumup aep, amba sip mega ewap ororom warup amoin, iwa me noa ire anune menan. ");
INSERT INTO dgz_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Go mu apan da ugupewa evip ya di amoin, tave di, mu tap ae ve amoin, iwa apan ugupewa ame noa mu oare.” ");
INSERT INTO dgz_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Iesu gutut mame guegue anupen maibe mini waiwandin, go me wadidiam wandini mu da ya di anu awane. ");
INSERT INTO dgz_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ap menan Iesu sia wan, “Ne tavewa gapan di wadiaivin. Man sip tonanewa ne. ");
INSERT INTO dgz_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Namu yo yo ebo taine nagirewa namunap tauanewa ame up ge togut wagut nagirewa, ap menan man sip nomu ire da ya anune. ");
INSERT INTO dgz_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ne tonan, orup da ne gamunap unuk aepiwa me inak wareta. Me ne gamunap unuge ge use taue aepi amba at kakaewa tautaneta. ");
INSERT INTO dgz_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Up apanewa ame up tapen ge togut wagut amba wa koeamepen megenat di oniwan, go ne tauana ame gamunap inak wariwaniampen amba inak ame di wat kakayasinampen menan.” ");
INSERT INTO dgz_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Iesu sia anega wan, “Ne man sip kwayup taini i apane kakaewa. Sip kwayupe kakaevet taini apanewa inak mega man sip menan wakaumepen menan anun taiwan. ");
INSERT INTO dgz_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Apan da man sip amasewa tan garewa den warini ame man sip i apanewa uon, menan okoi wasipen da onep yavepi, me sip ae vemon tap di aewan. Amba okoi wasipen ma tauen sip gut ise se ase se tata. ");
INSERT INTO dgz_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Apan ame tap aepiwa iwa, me mondi nao tan garewa warini apanewa menan. Kwayup yaentuk ya ta kakayasiwan. ");
INSERT INTO dgz_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ne man sip kwayupe kakaewa. Ne man sip iragi asiginap tamon amba mu iragi asigimup tanegene. ");
INSERT INTO dgz_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ap umap sia ne Mamana ne asigip tanegen amba ne me asiginap tan amba inak negawa man sip munan wakaumain. ");
INSERT INTO dgz_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ne sip nega upinewa wanumam go endi sin mame gwanap uon, ap menan ne den tambumopen sin gwanap onamot anuivin, amba mu den nona ire anupi gapan dugup daiton kwayup taini i apane daiton den wanumoin. ");
INSERT INTO dgz_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ne Mamana inanap anu guriniwa iwa megawa ame ne inak nega piup iragi munan wakaumain amba inak nega ae ma sia wat angain. ");
INSERT INTO dgz_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Waenapan da ne inak nega ase ya waseanegain, go negenat inak nega ae bat munain. Ne inak nega ae barae barae amun megawa ge inak nega ae ma wara sia angepen amun mega ne gase waran. Ne inak nega ae barapena ame ne Mamana God anuni gapan di.” ");
INSERT INTO dgz_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Iesu nop mame waiwandini menan, Diu, nagirewa sia ae seu enun nop mame aigap doran waiwanumun. ");
INSERT INTO dgz_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Upi anega wane “Me airampu tauan potap unugen menawasene bumbam tan waiwan, menan iwa dimen nop mega anupen taiwanin?” ");
INSERT INTO dgz_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Go upine anega wane, “Airampu apan potap unugepi nopewa wat mega map anega uon. Airampu apanewa apan yame boraseni anenen wat inakameta?” ");
INSERT INTO dgz_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","At Ierusalem gapan God Paewa Wat Aipakamepen Baripewa tauen, ame aunari wamewa gapan. ");
INSERT INTO dgz_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Iesu God Paewa sin gwanap namboya wanden. Iesu apan Solomon sewae gotugue arewa gapan ap yon iwandin. ");
INSERT INTO dgz_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Diu nagirewa tauan Iesu ikukuk nau panan waiwanumun, “Ge guegue gega anupen menan nononga wandia go konintu wa wainai? Endi ge God om enuni apanewa Keriso wandepiwa, aroga iragen ase ma wadian.” ");
INSERT INTO dgz_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Iesu gare wan, “Ne gaset wadiaen, go e anu tumat ya tayan. Ne yo ugup ugup Mamana yaua gapan tainawa, ame ne paua nega ta ewaiwan. ");
INSERT INTO dgz_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Go e ya di anu tumasiwanin, iwa e man sip negawa uon. ");
INSERT INTO dgz_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ne sip nega nona ire anuinewa, ne iravi asiginap tamon, amba mu evinap yonane inewa. ");
INSERT INTO dgz_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ne yaibobot inagewa muninawa, amba mu borit da ya di wain. Waenapan da nanin gwane gapan sia ya waseanek amoin. ");
INSERT INTO dgz_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Mu gaset ne Mamana ma di nenen, me waenapan iragi aigamup. Orup da, anu tumat apanewa Mamana nani ninokap gapan sia ya warupeta. ");
INSERT INTO dgz_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ne amba Mamanawa nu dere gine daiton.” ");
INSERT INTO dgz_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Nop ame anune gapan Diu nagirewa agim bun topen tane. ");
INSERT INTO dgz_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Go Iesu anega diamon, “Ne Mamana God gamup, yo ugup ugup arugataet da ta ewaen, go endi yo ansenawa menan agima tonegepen taiwanin?” ");
INSERT INTO dgz_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Diu nagirewa anega gare wan, “Nu upine menan agima ya togepen taivin, go ge nop koevet di waingi, iwa ge apan iragen di go gek waan God di waingi,” Diu nagirewa ap anega gare wane. ");
INSERT INTO dgz_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Iesu gare wadiamon, “God no oise kakaewa namua ega gapan ok manega seane go uon? E piup ma god megawa diaivin. ");
INSERT INTO dgz_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","E asigiap God nop mega ame entan wantan da ya tata, nop mega di wande aiwandata. Ap menan God Diu namu yo yo nagirewa inamup piup ma god megawa ap anega diamoniwa nop ame tamana di. ");
INSERT INTO dgz_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ap mini Mamana God wat nugut kiman gapan watu enanegeni piup ma tauan menan ne God mek otua waivin. Ap menan dimen God nop mega koevet waingat dianegiwanin? ");
INSERT INTO dgz_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ne Mamana mini ya di tapenawa e da ya di anu tumat nimanegai. ");
INSERT INTO dgz_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Go endi ne Mamana God umap tainawa. Go ne nop nega ya di anu tumasenewa, ame ne yo nega yawan gapan anu tumat taiwanian. Ame gapan Mamana ne potanap wandia, amba ne Mamana potap waingina, anu awai.” ");
INSERT INTO dgz_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ap menan sia to warapen tane, go tap yamamu ware totnage aen. ");
INSERT INTO dgz_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Boge Iesu ewagai sia kaum Jordan gamu to nuguse yamu dotoue wataget Dion waenapan dup iam wandini arewa ame aen. Ap mepe wanden. ");
INSERT INTO dgz_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Amba waenapan arugataet Iesu inap tauan. Amba gare gare anega wane, “Dion yo paua ugup ugup da ya di tan. Go dim dim da me apan Iesu menan nop waiwandini ame iravi tavewa di.” ");
INSERT INTO dgz_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","At ame gapan waenapan arugataet Iesu anu tumasene. ");
INSERT INTO dgz_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","At Betani gapan apan da yaua Lasiros vek ta wanden. Me domare wai dere ame Mata amba gwaniwa Meri. Waen Meri mame, me evi da amba kaum tutu dena ware Ayop aigap wageme amba Ayop pusiwa me igumewa gapan mut daragamen. ");
INSERT INTO dgz_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Menan Lasiros domare waiwa Iesu inap nop watu enan, “Ayop, naunu daiton da menan anu guriana ame vek tan.” ");
INSERT INTO dgz_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Nop ame taueni Iesu anuni, amba anega wan, “Vek mame koevet iragen, go iwa megawa God oya oya megawa menan venasen amba God mek otua oya oya megawa ao wareta.” ");
INSERT INTO dgz_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Iesu Mata amba gwaniwa Meri ge Lasiros munan anu guriniwa. ");
INSERT INTO dgz_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Dena, go wam ame Lasiros vek tan oise anuni me serarat inamu ya aen go wam dere sia wande amba aen. ");
INSERT INTO dgz_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Boge wa ewamot mega inamup anega wan, “Nu yonane ewagai Diudia anepen.” ");
INSERT INTO dgz_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Mu anega wane, “Go wadianet nugawa, wata konintu Diu nagire gwara toguragepen tane, dimen sia ewagai at ame agepen taingi?” ");
INSERT INTO dgz_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Iesu maibe gapan anega wan, “Wam airase aonagaet pusi nawan dere (12) ganasewa wandia. Apan da wamu yonen ap iniwa pusiwa ya enuta, iwa me piup ganat megawa gapan ini menan. ");
INSERT INTO dgz_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Mum wamewa megenat ap aepi pusiwa enuta, iwa ganat me inap uon.” ");
INSERT INTO dgz_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Nop mame wani ewap, me use dotoue wadiamon, “Evenanua Lasiros gearen aup iniwan, go ne at ase me angep wa kandasepen ao yonep.” ");
INSERT INTO dgz_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Wa ewamot mega gare anega wane, “Ayop, me mondi aup iniwandapinawa mek amba kandaeta.” ");
INSERT INTO dgz_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Iesu apan Lasiros boeni nopewa waiwandini, go me wa ewamot mega anune aup mondigawa iniwandat anun. ");
INSERT INTO dgz_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Menan boge oit aroga wadiamon, “Lasiros bop tan, ");
INSERT INTO dgz_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","go e kakaewa ega menan, e anu tumat ega wabawaramepen menan Lasiros inap menawaet ya angen. Menan ame gapan e anu tumat ega wabawaramepiwa ne aton anuin. Endi nu me inap anepen.” ");
INSERT INTO dgz_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Boge Tomas (yaua dawa Naturup), wa ewamot upine inamup anega diamon, “Ao yonane, Iesu den anepen me boepi nu den borit wat.” ");
INSERT INTO dgz_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Wam ame Iesu pa Betani konintu tauiwandini, oit wane anuni Lasiros boen dagupa baraene wandeni wam degede gaset uon tan. ");
INSERT INTO dgz_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Pa Betani ae Ierusalem taueniwa koni otu da nonongantuk (3 kilomita mini), ");
INSERT INTO dgz_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Diu nagirewa arugataet Ierusalem gapan tauane, Mata ge Meri naumu boeni tanamo bagu sisi tonengamepen, naumu wakaumane menan. ");
INSERT INTO dgz_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Wam ame Mata Iesu oniwandini oisewa anuni, me negina Iesu tautanapen menan aen, go Meri pa wande en. ");
INSERT INTO dgz_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","“Ayop,” Mata Iesu inap wan, “Ge mapa wanigepo nauna bop ya di tapo. ");
INSERT INTO dgz_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Go ne anuivin endi ma den di God inap mup anen wawa me geneta.” ");
INSERT INTO dgz_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Menan Iesu waen inap anega wan, “Ge naugawa ao sia yon wandeta.” ");
INSERT INTO dgz_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Amba Mata gare wan, “Ne anuivin me ao sia yon wandeta wam verisiwa gapan.” ");
INSERT INTO dgz_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Amba Iesu me inap anega wan, “Borit wane nagirewa inak ware ao sia yon wanumopen ibariwa amba inak yaibobot ibariwa ne me di. Me da anu tumat nimanegepiwa boeta go inak sia wareta. ");
INSERT INTO dgz_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Amba waenapan da da ansena ine wande anu tumat nimanek wandapinawa bop ya tata. Ge nop nega mame anu tumasingi?” ");
INSERT INTO dgz_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Menan Mata anega wan, “Umap, Ayop, ne anu tumasivin ame ge God om enuni apane, Keriso, God mek otua da piupa tauat wa tauana apanewa.” ");
INSERT INTO dgz_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Amba mame wani ewap Mata ewagai ae gwaniwa Meri wa upe asira amon amba anega wan, “Wadianini apanewa mapa, amba me genan waiwan.” ");
INSERT INTO dgz_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Wam ame Meri anuni menawaet ao yone Iesu inap aen. ");
INSERT INTO dgz_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Endi yawat mega Iesu pa sewa ya di tauia, go me Mata tautaneni arewa gapan ap mepe wandia. ");
INSERT INTO dgz_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Wam ame Diu nagire Meri tanan pa wanumon bagu sisi tonengam wanumune, Meri mek menawaet ao yon wande tau aen yawane menan mu Meri ewap amon. Meri tau aeni mu anune babat gage ae irip wat anune. ");
INSERT INTO dgz_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Wam ame Iesu amba yoniwandini arewa, Meri taue Iesu yaveni, Meri Iesu pusip gearen nikapu enu amba anega wan, “Ayop ge mapa wanigepo, nauna bop ya di tapo.” ");
INSERT INTO dgz_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Wam ame Iesu waen Meri irip waiwandin yaveni amba Diu nagire waen tanan onamone ap menan mu den irip waiwanumune, me guewa gapan bumaga tantan anu tanen. ");
INSERT INTO dgz_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Amba me singui anega wan, “E amba baraean?” Mu gare wane, “Ayop, onage yao.” ");
INSERT INTO dgz_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Iesu irip wan. ");
INSERT INTO dgz_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Boge Diu nagire anega wane, “Yawan Lasiros menan anu guriniwa.” ");
INSERT INTO dgz_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Go upinewa anega wane, “Me apan yame boraseni yamewa watapeniwa go anenen menan Lasiros bop gapan ya watanen?” ");
INSERT INTO dgz_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Iesu bagu sisi bumaga tantan sia anuni one babat arewa tauen. Ame dagup tonanewa gwat parata ma toboriniwa. ");
INSERT INTO dgz_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Iesu anega wan, “Gwat wabaim ase baraen.” Amba Mata, Lasiros domarewa anega wan, “Go, Ayop, wam degede wandeni endi mame etua gase aninke wan.” ");
INSERT INTO dgz_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Boge Iesu anega wan, “Ne namu ge wadiagena ame anu tumat tawa, ge God oya oya mega yawai.” ");
INSERT INTO dgz_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Menan mu gwat wabaimen ase baraene. Boge Iesu yangut ao ta amba anega wani, “Maman, ne nona anuana menan gaun inagap waivin. ");
INSERT INTO dgz_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ne asiginap ge pot pot nona anuianawa, go manega waiangina, iwa waenapan mapa yoniwanumune kakaewa muga menan, amba ge ne watu enanegeana anu tumat tanegepen.” ");
INSERT INTO dgz_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Wam ame anega wani, Iesu tumban amu ve wan, “Lasiros, tau onak!” ");
INSERT INTO dgz_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Bop apanewa tau onen, pusi nani wanup gapan viri viri waran, gine namu pan borane ame tau onen. Iesu anega mu inamup wani, “Bop wanupewa butunagen ae veane me tau aep.” ");
INSERT INTO dgz_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ap menan, Diu arugataet Meri inewa daio tauane, Iesu dim da tani yawan me inap anu tumat tane. ");
INSERT INTO dgz_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Go Iesu dim da tani oisewa upi amon Parisi nagire wadiamone. ");
INSERT INTO dgz_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Boge pirisi bawarewa nagirewa ge Parisi nagirewa kansoro muga iam iam menan wane. Iam iam gapan mu anega wane, “Endi nu dim da tait? Apan mame yo paua arugataet taiwan. ");
INSERT INTO dgz_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nu manega ae veat ta aepiwa mu iragi me anu tumat tain, amba boge Rom nagirewa taue nu kansoro nuga epara muga waseamoin amba at piup nugawa waseanaine.” ");
INSERT INTO dgz_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Boge mu yaumakamup apan daiton, yaua Kayapas en ame gapan me pirisi bawarewa ta wande eni nop ao ainagase anega wan, “E dim da asik ya di tayan. ");
INSERT INTO dgz_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","E da ya di anu avisi ame kakaewa nunan apan daiton da boep iwa ame gapan piup nuga waseanepi tawa.” ");
INSERT INTO dgz_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Me megenat menan mame ya wan, go en ame gapan me pirisi bawarewa ta wande en menan me eviwa noa wan, ame Iesu boepi ian Diu nagire munan, ");
INSERT INTO dgz_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","amba Diu nagirewa mugenat munan uon go God otu waiwa punanan wat amone munan den, ame gapan naumo tobot mumep daiton tapen. ");
INSERT INTO dgz_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Menan wam ame use aeniwa mu Iesu inak mega waseasepen menan negin yop tane. ");
INSERT INTO dgz_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ap menan Iesu Diu nagire Ierusalem gapan inamup tage aroga da ya tan. Go garewa me ewagai totnage at piup gwat mugenata arige konintu, pa da yaua Eparam aen. Ap mepe me wa ewamot mega den wande en. ");
INSERT INTO dgz_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Wam ame konintu taiwandin Diu nagire Paina Yamaseni Baripewa, waen apan aruga at muga muga ae vean pa Ierusalem anu tumat iupewa ayamase tapen menan pusi nani bigi ware amon bongam bongam namu tap amba Paina Yamaseni Baripewa evi amba tugupen wa amon. ");
INSERT INTO dgz_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Mu Iesu menan yangut pot pot di taiwanumun, amba mu God Paewa sin gwanap namboya yonan singui gare gare wane, “Ge anen anuingi? Iesu barip menan ya di taueta?” ");
INSERT INTO dgz_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Go pirisi ayop mugawa amba Parisi nagirewa nop pusi pan pan tamone ame orup ansena da Iesu amba wandep yavepi me one oit wap amba mu amo Iesu ware panapen. ");
INSERT INTO dgz_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Paina Yamaseni Baripewa manamui wandin wam nani yamunaet yamu daiton namumup wandeni, Iesu at Betani tauen, ame apan Lasiros wandini arewa, me namu boen Iesu wat inakameni apanewa. ");
INSERT INTO dgz_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Map mepe Iesu taueni menan Lasiros wat inakameni baripewa tugune. Mata taba yan siwandini, taba nana watarewa ap gapan waenapan wanumune. Lasiros ap mepe den tanam wande en. ");
INSERT INTO dgz_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Boge Meri oma da osewa pokarik gapan enane, ame ware tauen, me tutua aigap iragen amba garewa mega baita da uon. Me ware Iesu pusip wa damage amba i gume tau vitane ame gapan sia mut darakamen. Amba oma ose ame tutua pa ame gwanewa iragi bararaen. ");
INSERT INTO dgz_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Go Iesu wadiamot mega da, apan Diudes Iskeriot, gatawan Iesu omine wapiwa, ap mepe den wandeni, me anega wan, ");
INSERT INTO dgz_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Oma ose tutu dena mame une ta moni wara waenapan purapuse uon kayakayawan taine nagirewa muna muna anenen menan? Moni ame bodu daitona garewa mega warine ame omewa.” ");
INSERT INTO dgz_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Me nop mame waniwa iwa me pura puse uoni nagire munan ya anuiwan go iwa me up apanewa, wadiamot nagire moni muga igewa amase tainiwa, moni me inap sine gapan up tan inak taniniwa. ");
INSERT INTO dgz_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Iesu gare anega wan, “Waen ma ae veane anut mega di taiwandan. Inak tamanawa di, me oma ose tutu dena mame tasi di seneniwan, ame gapan ne iman bonigasepen tunegepi wamewa menan. ");
INSERT INTO dgz_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","E iman kayakayawan taine nagire den nimakamup tanam waniai, go ne pot pot ya waranegiwaniai.” ");
INSERT INTO dgz_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Wam koni ap gapan, Ian Diu waene apane arugataet Iesu Betani gapan wandeni yawan inewa onamon. Iwa Iesu menan megenat ya onamone go me Lasiros boen wat inakamen yon wandeni den yawapen menan onamon. ");
INSERT INTO dgz_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ap menan pirisi bawarewa yonanewa nagirewa Lasiros den topen menan noa barimene. ");
INSERT INTO dgz_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Lasiros inakaen yawane menan Diu nagirewa arugataet Iesu aigaven amon anu tumat muga iravi Iesu inap bariwanumun. ");
INSERT INTO dgz_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Inane woup seniwa waenapan aru ame barip ame menan tauanewa Iesu Ierusalem oniwandin oisewa anune. ");
INSERT INTO dgz_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Boge mu yonan oma naniwa bae nini den ketnagen tambun, amon negina tautanan ve senao waiwanumun, Iesu ge paina iragen! God wat aipakamini Ayopewa Isurero, God yaua gapan tauiagi! ve senao ap anega wane. ");
INSERT INTO dgz_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Iesu man donki otua, namu yop ta wareni gapan, gagap wande aen, no oise kakaewa namua gapan ok seane anega wan, ");
INSERT INTO dgz_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Tap ya anune, ae waenapan nega Ierusalem nagirewa, yawan, Ayop ega, man donki otua gagap wanden oniwan. ");
INSERT INTO dgz_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Mame venaseniwa Iesu wadiamot mega da ya di anu awane. Go evi amba Iesu kiman dot ae oya oya wareni gapan mame venaseni gueguewa ok namua wataget sean wane omewa gapan venaseni ame mu anu awan. ");
INSERT INTO dgz_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Iesu, apan Lasiros wat inakameni, ap wamewa gapan waenapan aru ame Iesu Lasiros wat inakameni ase yawane, mu Lasiros oisewa ise wa asewa amon. ");
INSERT INTO dgz_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Menan waenapan arugataet Iesu tautanapen amone, iwa me yo paua mame tan oisewa anune menan Ierusalem negine amuiwanumune. ");
INSERT INTO dgz_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ap menan pirisi nagirewa gare gare ase ma wawa mutan anega wane, “Yawan, nu taintoniwa tavewa da uon. Endi uon, endi ase yawat mega waenapan ma gaset iragi Iesu ewap amone.” ");
INSERT INTO dgz_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Endi Ian Gurik nagirewa upi nimakamup ap mepe Ierusalem gapan wanumuine den barip ame gagewa wa taragasepen dot amon. ");
INSERT INTO dgz_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Amone apan Pilip, inewa tauan, (Pilip pa Betsaida, at Galili apanewa) mup muga inap anega wane, “Ae apan nugawa, nu Iesu yawat anuivin.” ");
INSERT INTO dgz_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pilip mup ame tauen anuni boge ae Anduru wadien amba Pilip ge Anduru sia entanen Iesu wadiane. ");
INSERT INTO dgz_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Iesu gare wan, “Mamana God Kimani Vitana apanewa oya oya nega ao wara wara wamewa gaset tauen. ");
INSERT INTO dgz_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Endi ne nop tavewa di wadiaivin, tamudu makewa daiton megenat, go me pia geare boepiwa, me naewa wabawaramep aruga tata. ");
INSERT INTO dgz_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Apan da inak mega menan imu pose warep anu gure taiwandapinawa me inak wakaumeta, go apan da inak mega piup ma gapana tandayasiwandapinawa me inak mega yaibobot inagewa wat nat wandeta. ");
INSERT INTO dgz_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Orup da nenan ayamat tat anupi, me yon wande evinap onep, ne amba waingina arewa, nao nega ayamase tainiwa me ap mepe den wandeta. Orup ame nenan ayamat tainiwa Mamana menan anu gure viriwa tata.” ");
INSERT INTO dgz_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Iesu sia anega wan, “Endi menan ne bumagana vege waia, ap menan ne anen wain? ‘Maman wam koni mame gapan iana warupai,’ anega wain? Uon, ne endi wam koni mame miniwa menan tauan.” Iesu anega wan. ");
INSERT INTO dgz_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","“Maman yauga oya oyae den ao wat!” Boge nop da kimani anega tauen, “Ne yauna oya oyae den gaset ao waran, amba yauna oya oyae den sia ao warain.” ");
INSERT INTO dgz_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Waenapan ame iam wanumone nop kimaniwa ame anun anega wane, “Ma ait da kimani waia,” amba upine anega wane, “Anea nop Iesu diwan.” ");
INSERT INTO dgz_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Menan Iesu anega wan, “Nop endi kimani taueni mame e inak ega menan, ne nenan uon. ");
INSERT INTO dgz_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Wam ma endi ganawan piup koewa muga wanene tapen wamewa, endiwa piup ma namu yoyo taini ayopewa, Seitan, to oirenep taue garip aeta. ");
INSERT INTO dgz_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Go ne, piup ma gapan ne paina to endawanegepiwa waenapan iravi wa upamopen nek nenan onamoin.” ");
INSERT INTO dgz_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Iesu nop mame waniwa me bop mega gapan anenen ta ewamo boepi noa waiwandin. ");
INSERT INTO dgz_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Waenapan ame iam wanumone ao waiwanumun, “Nu God nop mega namua gapan anutoni ame Keriso tunano di wande aiwandata. Endi ge ame anenen waingi? Kimani Viseni apanewa paina to endavep boeta? Kimani Viseni apanewa ame da?” ");
INSERT INTO dgz_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Boge Iesu anega wadiamon, “E dun ganat mame inayap nononga ya wandeta, dun mame wandini gapan wat aisiwanian iwa sisip taue anap antapen imaepi tawa. Apan da sisipu ainiwa me aini neginewa me oare. ");
INSERT INTO dgz_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Menan anu tumat ega dun ame gapan ap mepe wandep, ame menan e dun ganat ame otu waiwa entan imaep.” Iesu nop ame waiwandini uon taniwa, me boge waenapan inamup karau ta at ame ae ve aen. ");
INSERT INTO dgz_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Iesu yo ge paua ugup ugup mame yamamup di taiwandin. Go Diu nagirewa aruga Iesu inap da ya di anu tumasene. ");
INSERT INTO dgz_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Mame taiwanumunewa apan Aisaia God nop mega wataget waiwandini ame tavewa tauapen menan venasiwandin. Ame Aisaia manega sen, Ayop negawa. Oit nuga mu ya anu tumasen. Aro amun gega ewamoan yawan, go usenagaet ya anu tumat gimak wanum. ");
INSERT INTO dgz_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Iesu nop mega mu anu tumat ya di tane tavewa mega ame apan Aisaia nop mame wataget den se wan, ");
INSERT INTO dgz_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","God yamamu toboboren ge imu pose to musen, ap tani yamamu gapan da God yavep, ge imu pose gapan da anu avepi, amba entan God menan onamop, amba wat inakam mumepi menan tawa iragi toboboren. ");
INSERT INTO dgz_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaia mame wani, iwa me watagetawa Guewa Woup Seniwa gapan Iesu oya oya mega yaveni menan Aisaia no oise mame ap anega sen. ");
INSERT INTO dgz_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Go waenapan arugataet ge Diu davewa yonanewa upi den Iesu anu tumasene. Go mu anu tumat muga aroga ase ya wan, iwa ian Parisi nagirewa wanumone tamu tan, ap wapiwa dugup paewa gapan up oimop tau amopi tawa. ");
INSERT INTO dgz_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Mu ap anega tanewa iwa mu waenapan wa atonat muga menan imumu waren, go God wa atonat mega men imumu ya ware kakayasen. ");
INSERT INTO dgz_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Menan Iesu no ainagase nop uma anega wan, “Apan da ne anu tumat nimanegepiwa, ame ne negenat ya anu tumat nimanegiwan, go ne watu enanegeni inap den anu tumasiwan. ");
INSERT INTO dgz_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Me yangut ta ne yawanegepiwa, ne watu enanegeniwa den yaveta. ");
INSERT INTO dgz_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ne piup ma tauana ganat di tauan, menan waenapan da anu tumat nimanegepiwa, mu sisip gapan ya wanumoin. ");
INSERT INTO dgz_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ame orup da nop nega anuiwan go me ya anun tainiwa, ne wanene me inap ya tain. Ne tauana piup ma wanene tapen ya tauan, go wat inakam mumapen menan tauan. ");
INSERT INTO dgz_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Go wanene apanewa den wandia menan orup da tandaeyat nimanege nop nega ya wariwandapinawa, ame wanene mega den wandia, wam uiwa gapan, iwa ne nop nega tandayasene menan. Ne nop God Mamana wadiapenawa ame waenapan wanene tamota. ");
INSERT INTO dgz_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Iwa den, nop ma nek ianap ya waivin, go ne Mamana me watu enanegeni ame wadiae diae ge anenen wawa ame wani gapan di waivin. ");
INSERT INTO dgz_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ne anuivin God nop megawa ame up naunen yaibobot neginewa gapan aewan, ap menan ne anen waingina ame Mamana wadianegeni uap di waivin.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","3","Den Paina Yamaseni Baripewa konintu taiwandini, wam ame gapan mum gine tabaewa naiwanumune. Amba Iesu asigip tani wam gaset tauen me piup ma ae ve amba Mamewa ine aepen. Seitan Diudes Iskeriot apan Saimon otua, inap taue Iesu omine wapen menan dien. Go God Mamewa ik amun megawa iragi Iesu sin waneni, Iesu gaset asik ta kakayasen, amba Iesu God inap taueni sia ewagai God ine aepen di anun taiwan. Iesu waenapan megawa piupa wanumunewa munan anu guriniwa menan endi me anu gurat mega tave iragenawa wadiamot mega to ewamopen tan. ");
INSERT INTO dgz_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ap menan Iesu ao yon wande, wanup mega garipe warup ase barae atup wanupewa kankamup panen. ");
INSERT INTO dgz_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ame ewap, kaum kabum gapan wageme ap mepe erewa wa ewamot mega pusimu bigi waramoni, atup wanupewa kankamup paneni gapan mut daragam mumen. ");
INSERT INTO dgz_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Me ta oniwandin Saimon Pita ine tauen, Pita me inap anega wani, “Ayop, ge pusina bigi di warai?” ");
INSERT INTO dgz_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Iesu gare anega wan, “Dim da taingina endi ma ge ya anu awai, go evi utapa amba ge asik tai.” ");
INSERT INTO dgz_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pita sia anega wan, “Uon, ge pusina da bigi ya warai.” Iesu gare anega wan, “Ne bigi ya warapenawa, ge ne upinana uon.” ");
INSERT INTO dgz_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Saimon Pita gare anega wan, “Ayop, pusina megenat uon go naninawa amba ianawa den bigi wat!” ");
INSERT INTO dgz_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Iesu gare anega wan, “Apan daiton da dup ieniwa ame pusiwa megenat bigi wareta iwa me pusip ap aeni menan pusiwa bigip tan go me ugu wapi iragi kakae di. Endi e iravi kakae di, go orup daiton kakae uon.” ");
INSERT INTO dgz_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Me ame wani iwa orup da me omine wapi me asigip tan menan anega wani, “E iragi kakae go orup daiton da kakae uon.” ");
INSERT INTO dgz_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Wam ame pusimu bigi waritameni, me wanup entan mega pane amba at mega gapan sia ae wanden. Amba Iesu singui anega tayawamon, “E inayap dim da tanawa e anu awayan go uon? ");
INSERT INTO dgz_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","E Wadiaet ge Ayop dianek wanin ame tavewa di dianek wanin. ");
INSERT INTO dgz_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Menan endi mame ne ayop wadiaet egawa pusia bigi warian, e ap mini pusia gare gare bigi wariwanian. ");
INSERT INTO dgz_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ne dim da tanawa ame guegue ta ewaen, e ap umap ta aisen. ");
INSERT INTO dgz_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ne tave di wadiaivin, nao taini apanewa ayop mega ya garawaseta, ap mini sep apanewa da watu eneni ya garawaseta. ");
INSERT INTO dgz_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Endi mame iragi asik tayana, ame taiwaniampinawa God e wat atonat imaeta.” ");
INSERT INTO dgz_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Iesu anega wan, “Ne da da om enuena, ne asiginap. Ne nop mame iragi inayap ya waivin, go orup daiton megenat. Ap menan ok watagetawa seane tavewa tauapen menan waivin, Orup da mapa taba nega den naini, me gariwa gamunap entani wan. ");
INSERT INTO dgz_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ya venaseni go ominana wani oisewa endi namu mame wadiaivin, menan wam ame venasepiwa e anu tumat tai ame God watu enanegeni ame ne me di. ");
INSERT INTO dgz_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nop nega mondi uon anun di waivin. Waenapan da da dugup nega watu enamopena waupamopi ne den waupanek wanum. Amba waupanegepi Mamana watu enanegeni den waupiwanum.” ");
INSERT INTO dgz_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Nop mame wani ewap Iesu bagu sisi guewa gapan anuni amba nop anega wan, “Ne tavewa di wadiaivin, e daiton da ominana wapen taiwanin.” ");
INSERT INTO dgz_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Me wa ewamot mega gare gare ase ma yayao mutan, anune imumu puk wan, ma da menan waiwan. ");
INSERT INTO dgz_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Yaumakamup wadiamot mega da, Iesu me menan anu guriniwa, Iesu mainep wanden. ");
INSERT INTO dgz_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Saimon Pita apan ame die anega wan, “Wayao ma da menan me waiwan?” ");
INSERT INTO dgz_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Apan ame Iesu gamup ase dave me singui anega tayaven, “Ayop, orup ansena da?” ");
INSERT INTO dgz_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Iesu gare wan, “Apan daiton da ameme wam mame ne buredi warap sip kundaun gapan kaum pisit antap enap wanapenawa ameme di.” Boge me buredi ware Diudes Iskeriot wanen. ");
INSERT INTO dgz_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Diudes taba wareni Seitan mek menawaet potap unugen, menan Iesu Diudes die anega wan, “Dim da tat anu taana menawaet di ta.” ");
INSERT INTO dgz_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Go mu da daiton ya di anu awane dimen Iesu manega me inap wan. ");
INSERT INTO dgz_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Koni ame Diudes wadiamot moni mugawa kwayupe me taiwandin menan, upi anune Iesu barip menan taba une tapen men inap nop waiwandat anun, go upi anune gare kayakayawan nagire munat anun. ");
INSERT INTO dgz_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Diudes buredi ame ware menawaet tau aen. Ame muma. ");
INSERT INTO dgz_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Diudes aeni amba Iesu anega wan, “Endi Kimani Vitana apanewa Mamana God oya oya mega wabawaramen. ");
INSERT INTO dgz_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Mamana God ne gamunap oya oya aigap wariniwa menan ne oya oya nega aigap wabawarameta amba ne oya oya nega menawaet di wat arogameta. ");
INSERT INTO dgz_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Orup tasin negawa, ne nononga ya di tanae wanigain. E yona tai amba koni da, Diu wadiamona mini, endi sia ne wadiaivin, amba angepena ap mepe e ya onayai. ");
INSERT INTO dgz_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Iup ewakewa ne enivin, imuya warep baigan tan gare gare anu guriwanian. Ne enan anu gurana mini, e den anu gurat ega gare gare taiwanian. ");
INSERT INTO dgz_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","E ek gare gare anu guriniampinawa, ame gapan waenapan iravi asik tayain ame e ne wa ewamot negawa.” ");
INSERT INTO dgz_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saimon Pita Iesu inap singui anega wan, “Ayop, ge amba agingi?” Iesu gare wan, “Ne amba angingina endi ge ya ongai, go evi amba onagai.” ");
INSERT INTO dgz_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pita singui sia anega wan, “Ayop, dimen endi ne ewagap ya ongain? Inak nega genan wakaumet anuivin.” ");
INSERT INTO dgz_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Boge Iesu gare anega wan, “Tamana di ge inak gega nenan di wakaumai? Ne tave di waivin, ge wam koni yampo waboboranegewa amba kumkum nop wata.” ");
INSERT INTO dgz_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Iesu anega wan, “E imuya potaya nene yangwan ya doriwandan, God inap anu tumasen, amba ne den anu tumat nimanegen. ");
INSERT INTO dgz_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ne Mamana pa mega gwanewa arok arugataet da di wanumam, endi ap me da uon wandepoa, ne da ya wadiaepo. Endi ne at ega da amu watupen menan ap mepe angewan. ");
INSERT INTO dgz_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Amba ne ange at ega da amu watupenawa, ne sia entan ongep tambue ange ne wanigina arewa gapan ap mepe den di waninait. ");
INSERT INTO dgz_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Negin ae ne wanigepena arewa taueni ame e asigip tayan.” ");
INSERT INTO dgz_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Apan Tomas Iesu anega dien, “Ayop, ge agewa arewa nu oare, ap menan negin ame nu anenen asiginup tait?” ");
INSERT INTO dgz_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Iesu gare anega wan, “Ne negin di, ne nop tavewa di, ne inak iragenawa di. Orup da God inap tauapen menan, negin daiton megenat ne gamunap di. ");
INSERT INTO dgz_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Endi e anu kakayat nimanegenewa, ne Mamana den anu kakayatai. Endi koni mame use aeniwa, e Mamana asigiap iwa ne gamunap yawayan.” ");
INSERT INTO dgz_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Apan Pilip anega wan, “Ayop, Mamaga God to ewan.” ");
INSERT INTO dgz_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Iesu gare wan, “Pilip, wam arita mame nimakayap den di ininginawa, ge asik ya di tanegiagi? Orup da da ne yawaneginewa ame Mamana God den di yaviwanumun. Endi ge ame anenen God Mamewa sia to ewaget waingi? ");
INSERT INTO dgz_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Endi, ame ne Mamana potap wanik anginawa amba Mamana ne potanap wandiniwa endi ge anu tumat ya taingi? Ne nop ma ase wadiaina ame nek negawa uon go ame Mamana potanap nao wariniwa gapan waivin. ");
INSERT INTO dgz_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ne ma wapenawa e di anu tumat nimanegen, ame ne Mamana potap wanik angin amba Mamana ne potanap wandia, o gare yo paua ugup ugup taingina ame gapan ase yao anu tumasen. ");
INSERT INTO dgz_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ne tavewa di wadiaivin, orup da da anu tumat nimanegepiwa, ne dim dim da tainginawa me ame umap taiwandata. Gosi me tapen tapiwa ame aigapewa da taiwandata, iwa ne Mamana ine angewan. ");
INSERT INTO dgz_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Amba dim dim da men yauna gapan mup waiwaniampinawa ne ta eningain, ap gapan ne Mamana oya oya mega aigap wabawaramain. ");
INSERT INTO dgz_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Menan dim dim da men anune, yauna gapan mup wane, ne di tain.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Iesu sia anega wan, “E imuya potaya nenan di anu guriwaniampinawa, e nop nega waran taiwaniai. ");
INSERT INTO dgz_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Amba ne Mamana inap mup wapen wat ago ega da sia enep tanae wande aiwandata, ");
INSERT INTO dgz_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ame Guewa Woup Seniwa nop tavewa wainiwa. Guewa ame piup waenapan ma ya warain, iwa mu da ya yao asik tane, go e asigiap di iwa Guewa gamunap yawayan, ame e den tanaen wandiniwa amba potayap wande aiwandata. ");
INSERT INTO dgz_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ne inanam mini ae ya wat veta veain, ne e inayap sia di ongingain. ");
INSERT INTO dgz_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","konintu amba piup ma da sia ya yawanegain, go e di yawanegiwaniai, iwa ne inak gapan wanik angina menan e den inak gapan di waniai. ");
INSERT INTO dgz_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Wam ame gapan e manega anui ne Mamana potap wanik angingain e ne potanap den waniwaniai amba ne e potayap wanik angingain. ");
INSERT INTO dgz_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Orup da da nop nega anune warinewa, ame nenan anu gurine waene apane ap me. Ame nenan anu gurinewa garewa Mamana munan anu gureta, ne ap umap sia munan anu gurain amba ne inamup ase to ewamoin.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Menan Diudes, (apan mame Diudes Iskeriot uon go da ugup), me anega wan, “Go Ayop dimen ge nugenat to ewanet waingi, iwa dimen waenapan den ya to ewamoi?” ");
INSERT INTO dgz_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Iesu gare entane sia wan, “Orup da nenan anu guriniwa, ame opata nega wariwandata. Mamana me menan anu gureta amba nu me inap tauat den tana waninait. ");
INSERT INTO dgz_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Go orup da nenan ya anu guriniwa, ame nop nega ya anu taiwandata. Amba opata ma anuiana ame nek negawa uon, ame Mamana watu enanegeni nopewa. ");
INSERT INTO dgz_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Nop arita ugup ugup wadiae ongingina amba endi mame den tanaen waingena gapan wadiaen. ");
INSERT INTO dgz_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Go wat ago egawa ame Guewa Woup Seniwa, ame Mamana yauna gapan watu eneta, me dim dim iravi wa ewaeta, amba ne anen wadiaenawa imuya den wa aveta. ");
INSERT INTO dgz_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Nonup nega inayap ae viangin, nonup nega eniangin. Piup ma nonup mega eniniwa tavewa uon, ame mini ne ya eniangin, menan potaya nene yangwan ya dorep, tap den ya anuiwanian. ");
INSERT INTO dgz_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ne wadiaena e gase anuyan, ame ‘Ne angepena amba e inayap ewagai sia tauain.’ E nenan di anu guranewa ne Mamana menan angepena e daramuya wata, iwa Mamana ne aiganap amba ne me gauarap. ");
INSERT INTO dgz_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ne mame endi wadiaingina evi amba venaseta, ap me venasepiwa e yawan anu tumat tai. ");
INSERT INTO dgz_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Endi e den nop nononga ya wa nonongamain. Iwa piup ma ayopewa, Seitan, oniwan. Go ne me aroewa da ya wat nat nimanegeta, ");
INSERT INTO dgz_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Go ta koeragam nimanegeta. Ame gapan waenapan iragi yao asik tap ame ne Mamana menan anu guran amba Mamana nop waini no usewa gapan gapan di taivin. Endi onaene at mame ae di ve anepen.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Iesu wa ewamot mega anega diamon, “Ne oma wain kaimewa mini di, amba ne Mamana nao i apanewa. ");
INSERT INTO dgz_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Naniwa ansena da makewa ya iamopiwa Mamana ketnagen ae siniwa. Naniwa ansena make iwandapinawa ayane warep makewa arugataet den sia iamopen menan. ");
INSERT INTO dgz_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Endi menan inayap nop wainginawa ame gapan e gaset kakae tayan. ");
INSERT INTO dgz_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","E ne den wanien, amba ne e den waningain. Ap mini naniwa da mek megenat wandepiwa makewa ya ieta, go oma naniwa ame, oma wain kaimewa ni enoa gapan enasepi makewa ieta. Ap mini sia di e ne inanap ya wanienewa, e makewa ya iai. ");
INSERT INTO dgz_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ne wain kaimewa mini di. E damik naniwa. Ne den uon e dim da da ya tai. Ap menan apan ansena ne den ya wandepiwa amba ne me den ya wanigepenawa, me makewa da ya ieta. ");
INSERT INTO dgz_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Apan ansena ne den ya wandiniwa, me yawat mega naniwa wae inen geariniwa mini, naniwa ap me ae ma tambune oma yame gapan uasine yagimuiniwa. ");
INSERT INTO dgz_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ne e den wanigepenawa, amba nop nega inayap wandepiwa, dim da men anu mup wanewa ameme Mamanua God eneta. ");
INSERT INTO dgz_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ne Mamana oyaoewa wabawaramepen menan e makewa arugataet ian, ame gapan e ne wa ewamot negawa ek ingane to ewat taiwanian. ");
INSERT INTO dgz_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Mamana nenan anu gurini mini, ne enan anu guran. Endi anu gurat nega potap wanien. ");
INSERT INTO dgz_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ne Mamana nop mega ayamase tan menan ne me anu gurat mega potap wainginawa. Ap mini e nop nega ayamase taiwaniampinawa, anu gurat nega potap wanien, ");
INSERT INTO dgz_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ne mame wadiaena iwa aton nega e potayap no dotouep, amba aton egawa mame bararaep umayap tata. ");
INSERT INTO dgz_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ne nop nega ayamase tat mega mam, Ne enan anu gurana mini, e baigan tan gare gare anu guriwanian. ");
INSERT INTO dgz_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Orup da me evene wai munan inak mega bop gapan wakaumepiwa, baigan anu gurat ap mini, ame aigap iragenawa. ");
INSERT INTO dgz_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Iup nega wapena taiwaniampinawa, e ne evenan wainawa. ");
INSERT INTO dgz_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Endi ma e ne nao nagire ya diaivin, iwa nao apane ayop mega nao anenen taini yaunewa me oare. Garewa, ne evenan waina diaivin, dim dim iragi Mamana inap asik tanawa gapan ne wadiena e gaset asik tayan. ");
INSERT INTO dgz_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","E ya om enu nimanegean, go ne e om enuen. E om enuena iwa e aisen makewa iwaniampen, amba makewa ega ame nononga wande aiwandata. Amba dim da ne yauna gapan mup wanewa Mamana eneta. ");
INSERT INTO dgz_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Mame ne nop negawa di gare gare anu guriwaniampen. ");
INSERT INTO dgz_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Piup tandayat imaepiwa, iaya barao anun, iwa mega ame namu ne tandayat nimanegen. ");
INSERT INTO dgz_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","E piup megawa di wanienewa, piup enan anu gureta iwa e piup megawa. Go ne om enuen menan e piup megawa uon, iwa ap menan piup tandayat imaiwan. ");
INSERT INTO dgz_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nop inayap waingina sia anun, Nao apanewa aritawa mega da ya garawaseta. Menan mu nop negawa ayamase tapiwa, ap menan egawa ayamase den tain, go mu ta kokoeragam nimanegepi, mu den ta kokoeragam imayain. ");
INSERT INTO dgz_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Mu negin manegawa gapan inayap tain iwa e ne yauna gapan taianawa amba mu God watu enanegeni mu oare. ");
INSERT INTO dgz_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Go endi ne tauana amba wadiamona go mu nop nega tandayasene, menan mu koewa muga wandia amba ebo aopane wawa da uon. ");
INSERT INTO dgz_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Me da tandayat nimaneginiwa Mamana den tandayasiwan. ");
INSERT INTO dgz_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Amba sia, ne yo dim da da tana mu nimakamup apan da ap mini ya tainiwa, go mu ne yo nega ya anu tumasiwanum, menan mu koewa muga wandia. Iwa endi yo aruga ma yawane go Mamana dere tandayat nimanwanum. ");
INSERT INTO dgz_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Go mame venaseni God oit nop mega namua gapan ok anenen seane tavewa venasepen, Mu tandayat nimanegene, go tavewa da uon. ");
INSERT INTO dgz_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ne Mamana inapewa Guewa Woup Seniwa watu enapena ame inayap taueta. Ame Guewa tavewa iragenawa da Mamana inap tauen ainiwa, me ne inak nega tavewa ta ewamota. ");
INSERT INTO dgz_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Amba e den ne inak nega tavewa ta ewamuiwanian iwa e erewa gapan tananegean ma onaninton.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Amba Iesu sia wan, “Endi nop arita mame wadiaingina anu tumat ega ya wakaumepen menan. ");
INSERT INTO dgz_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Tave di wam da oniwan, mu dugup paewa gwanap up oiep tau aitai, amba orup da gurae boniga seae amba me manega anuta, ‘Ne yan aiman garaet God wanivin.’ ");
INSERT INTO dgz_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Mu inak koe koe mame inayap taiwanumain iwa Mamanawa go gare ne mu asigimup ya tane. ");
INSERT INTO dgz_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ne mame wadiaena menan wam da tauepi ame ne tagigiraya wana e ase anu awai.” Iesu ap anega wan. Iesu sia anega wan, “Nop mame erewa gapan ya wadiaena iwa ne inayap den waingena menan. ");
INSERT INTO dgz_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Go endi ne me watu enanegeniwa ine angewan, go daiton da singui anega da ya wayawanegean, ‘Ge amba agewan?’ ");
INSERT INTO dgz_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Nop aruga mame waingina menan e bagu sisi den anuiwanin. ");
INSERT INTO dgz_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Go ne tavewa di wadiaivin. Ame e kakaewa ega menan ne angewan. Ame ne da ya angepenawa, ne e wat ago ega Guewa Woup Seniwa da enan ya watu enapen oneta. Go ne angain amba me watu enain. ");
INSERT INTO dgz_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Amba wat ago egawa ame tauepiwa, me waenapan mu koewa muga wat matagamep mu anuin, amba God negin mega tamanawa wat matagamep mu anuin, amba den God wanene mega wat matagamep mu anuin. ");
INSERT INTO dgz_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Koewa muga wat matagamepi iwa iragena ame waenapan ya anu tumat nimanegiwanum. ");
INSERT INTO dgz_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","God negin mega tamanawa wat matakamepi iwa mega ne God negin mega tamanawa taitamen menan ne Mamana God ine angewan. ");
INSERT INTO dgz_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Amba God wanene mega wat matagamepi iwa piup ayopewa, Seitan, God wanene mega gapan tauen wandia, ap mini God piup nagirewa wanene tamota. ");
INSERT INTO dgz_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ne nop arugataet da wadiae diae di, go e da ya waran tanau aisene umap. ");
INSERT INTO dgz_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Wat ago ega, Guewa Woup Seniwa, nop tavewa megenat di wainiwa, me amat taep tavewa gapanaet ta aisiwaniai, iwa mek anuini nopewa ya wadidiewandata go me nop kimani wadiane noa gapanaet di waiwandata, amba utapa venasepi nopewa den wadidiewandata. ");
INSERT INTO dgz_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Guewa Woup Seniwa ap me di nop negawa da ware inayap taue wadiap amba e asigip tai. Ap gapan oya oya nega wabawarameta. ");
INSERT INTO dgz_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Dim dim iragi Mamana megawa iragi ame negawa di. Endi ap menan ne anega wana dim dim iragi negawa ame Guewa Woup Seniwa ware to ewaep iravi asigip tai.” ");
INSERT INTO dgz_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Amba Iesu sia anega wan, “Wam koni otu da e da sia ya yawanegai, amba ame ewap wam koniwa da e sia yawanegai.” ");
INSERT INTO dgz_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ap anega wani gapan Iesu watu enamot mega upi gare gare ase ma wawa mutan anega wane, “Iwa dimen nop map anega wani, koni otu da nu sia ya yawait, amba koni otu da nu me sia yawait, amba me Mamewa inewa aeta?” ");
INSERT INTO dgz_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Mu nop ame anupen men di waiwanumun, “Me nop wam koni otu da wani tavewa dim da? Nu nop ma wani nu ya di anu avianit.” ");
INSERT INTO dgz_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Iesu yawamoni nop mame menan singui wayawapen taiwanumune menan me anega diamon, “Endi ne manega wana, wam koni otu da e da sia ya yawanegai, amba ame ewap koniwa da e sia yawanegai, ap menan gagap dorayan din wanauiwanin? ");
INSERT INTO dgz_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Endi ne nop tavewa di wadiaivin, e iman irip turup wan bagu sisi warai, go piup ma da da aton taiwanumain, e bagu sisi warai go bagu sisi ega aton entaneta. ");
INSERT INTO dgz_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ap mini waen da orup baraeni vegewa anun, iwa orup bare bare wamewa taueni menan. Go me orup mega yaneni me vek wat ire taiwandini imu borasen, iwa orup mega yaneni atonu tani menan. ");
INSERT INTO dgz_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Menan e den, endiwa bagu sisi den wara wara wamewa, go ne sia yawaepena e aton tai, amba waenapan da aton ega ya waseae amoin. ");
INSERT INTO dgz_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Wam ap me gapan e wan dim dim da menan ne inanap mup sia ya wayawanegai. Endi ne tavewa di wadiavin, e dim dim da men anunewa yauna gapan mup wanewa Mamana eneta. ");
INSERT INTO dgz_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Oniwandine endi ma taueni, e dim dim da mupewa yauna gapan da ya wayan. Mup wanewa e warai amba aton ega di wande aiwandata. ");
INSERT INTO dgz_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ne nop maibe gapan wadiaingin. Ame wadidiaingina iwa tavewa ukum umingin endi wam oniwandin nop gutut map anegawa da sia ya wain. Go Mamana oisewa aroga ase wadiain. ");
INSERT INTO dgz_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Wam ame yauna gapan mup waiwanian go enan ne dim da da Mamana inap mup ya wayawain. ");
INSERT INTO dgz_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Uon, iwa Mamana e enan mek imua waren menan me mup ega garewa eneta. Mamana enan imua waren iwa e nenan imuya wareni menan, amba anu tumat tayana ne me inap di ongen. ");
INSERT INTO dgz_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Tave di, ne Mamana inap ongen piup ma posewa unugen, endi ne piup ae viangin Mamana inewa sia angewan.” Iesu ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Boge Iesu wadiamot mega anega wane, “Endi ganawan nop aroga iragen waiagi nop ukum da sia ya umiagi. ");
INSERT INTO dgz_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Endi nu anuivin ge wan dim dim iravi anuitamean menan ge anuingiana orup da singui tangui ya wayawaget anuingi, iwa ge namu me singui mega anuan amba me evi wata. Mame taana menan nu anu tumat taianit ge God inap di ongean.” ");
INSERT INTO dgz_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Iesu gare ap anega wan, “Tamana di, anu tumat taiasi? ");
INSERT INTO dgz_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Go wam oniwan, amba gaset tauen, amba e punanan waran daiton daiton pa ega ega aitai. Amba e negenat wat veta aroga venegai go ne negenat ya wanigain, ame Mamana inanap den wandia. ");
INSERT INTO dgz_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ne wan dim dim mame wadiaingina, ame gapan ne gamunap e nonup warai. Piup ma gapan itan bobon aritavet eniwan. Go imuya potaya gan tumban amu yonane bigarep, iwa ne piup ma aroewa gaset ae wabigamen.” ");
INSERT INTO dgz_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Iesu mame wani ewap, me kimani yangut ao ta amba mup wan, “Maman, wam gaset tauen. Otugawa oya oya nega ao wat, gare ne ge oya oya gega ao warain amba waenapan to ewamoin. ");
INSERT INTO dgz_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Iwa ge aro epara waenapan kwayup tamopen menan nenaana ap menan mu iragi da da ge nenaanawa ame ne inak munain. ");
INSERT INTO dgz_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Endi inak yaibobot mam, Ame mu asik tagepen ge God daiton tave iragenawa amba ne, Iesu Keriso, ge watu enanegeanawa ameme asik tapen. ");
INSERT INTO dgz_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ne piup ma gapan tauan nao nenaana taitamena gapan oya oya gega wat bawaramen. ");
INSERT INTO dgz_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ap menan endi, Maman, oya oya nega ge ao wat, namu gende wainintoni piup ya venaseni gapan ap umap omewa inep.” Iesu ap anega mup wan. ");
INSERT INTO dgz_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Iesu sia anega mup wan, “Ne wa ewamot negawa piup ma gapan nenaana inamup wat matakam gimagen. Mu iragi gegawa, go ge nenaana amba mu nop gega ayamase tane menan. ");
INSERT INTO dgz_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Endi mu asik tane wan dim dim ge nenaanawa ame iragi ge inagap tauiwanum. ");
INSERT INTO dgz_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Menan nop ge nenaana ne wadiamona amba mu warane. Ap menan mu den gaset asik tane ne ge inagap tauan, amba mu anu tumat tane ame ge watu enanegean. ");
INSERT INTO dgz_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ne mu munan mup waivin. Ne piup ma gapan waenapan iravi munan mup ya waivin, go wa ewamot nagirewa ge nenaanawa munan mup waivin, iwa mu iragi gegawa. ");
INSERT INTO dgz_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Waenapan negawa ame gegawa, amba waenapan gegawa ame negawa, amba oya oya ne inanap tauiniwa ame mu gamumup oniwan. ");
INSERT INTO dgz_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ne piup ma gapan nononga ya wanigain, go endi ne inagap ongivin. Go mu piupa sia di wanumoin, menan Mamana potaga woup seniwa, ge yauga aroewa nenaana gapan papat munan ta mu daiton tap ame nu gende daiton tatoni mini. ");
INSERT INTO dgz_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ne tanamon wanigena wamewa ne papat munan tan amba kwayupamu yambuni tan yauna ame nenaana gapan. Daiton da ya wakauman. Go at koewa aepen menan yaneni apanewa megenat wakauman, iwa ame gapan God ok namua seane tavewa venasepen menan. ");
INSERT INTO dgz_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Konintu ne inagap ongain, go piup ma gapan wanigen nop nega ma wainginawa, menan ame mu aton nega warep potamu no dotouep inamup ene pone inep. ");
INSERT INTO dgz_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ne nop gega munan menan piup ma tandayat mumane, iwa mu piup ma mugawa uon ap mini ne den piup ma megawa uon. ");
INSERT INTO dgz_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mup nega waingina ame wa ewamot negawa piup ma gapan ge tam agepen menan uon go ame ge papat muga tapen koewa apane, Seitan, ya maninamopen menan. ");
INSERT INTO dgz_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Mu piup ma mugawa uon, ap mini ne piup ma megawa uon. ");
INSERT INTO dgz_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Maman, nop gega tavewa gapan mu wat aipakam kakayat mum. ");
INSERT INTO dgz_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ge piup gapan watu enanegeana mini, ne piup gapan watu enamon. ");
INSERT INTO dgz_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ne wa ewamot negawa wat agoat mumapen menan ne nek ingane wat aipakamen, ap gamup mu waenapan piup ma gapan wat agoat mumapen menan ne nop gega tavewa gapan wa ewamot negawa wat aipakam kakayat mumain.” Iesu ap anega mup wan. ");
INSERT INTO dgz_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Iesu sia anega mup wan, “Ne mup nega, wadiamot nega mugenat munan uon, go mu gamumup da da anu tumat tanegepi munan den. ");
INSERT INTO dgz_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Amba mu den iragi daiton tapen menan. Mamana, ge ne potanap wanik agi amba ne ge potagap wanik angin ap mini munan mup waivin mu den tanane wanumoin ap me gapan piup nagirewa anu tumat tanep ame ge ne watu enanegean. ");
INSERT INTO dgz_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Oya oya ame ge nenaana ne munan ame gapan nu daiton tatoni mini mu den daiton tap. ");
INSERT INTO dgz_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ne mu potamup wanigepen amba ge ne potanap wanigepen ap gapan mu den uruga naumo one tobot tamo kakayasep amba piup nagirewa ame ge watu enanegeana ame mu anu tumat tain. Menan piup nagirewa manega anuin, nenan anu guringiana mini anu tumat nagirewa munan anu guringi. ");
INSERT INTO dgz_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Maman, kiman piup ya venaseni gapan ge nenan anu guringian menan oya oya nenaana. Endi ne manega anuivin, orup da da nenaanawa ne amba wanigepenawa ame mu den tanamo wanigain ame gapan oya oya ge nenaana ame ganasewa mu den yavep. ");
INSERT INTO dgz_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Maman kakae iragenawa, piup anu waramat tagiwanum go ne anu gimagivin amba anu tumat taine nagirewa asigimup ame ge watu enanegean. ");
INSERT INTO dgz_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ge inak gega ne wa ewamona amba sia di wa ewamuingain ap me gapan baigan ne inanap taingiana ame mu inamup wandep amba ne nek mu potamup waingain.” Iesu ap anega mup wan. ");
INSERT INTO dgz_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Iesu Mamewa inap mup wan uon tani, me wadiamot mega tanam at bumak nape da yaua Kidron, Ierusalem mainap konintu di, ame to nuguse asepagan dotou amon. Yamu asepagan ap mepe nao egak da wande en, amba Iesu wadiamot mega den egaga dotou amon. ");
INSERT INTO dgz_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Endi apan Diudes Iesu omine wani, at ameme asigip tan, iwa Iesu wadiamot mega den wam wam pot pot gapan ap mepe iamiwanumun. ");
INSERT INTO dgz_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ap menan Diudes, Rom ita nagire ge God Paewa amase taine nagirewa, koniwa da wat nugutan iragi tanam egaga ap mepe tauane. Mu pirisi ge Parisi aritawa yonanewa watu enamon. Mu dun iran ita gaut muga tambun tauan. ");
INSERT INTO dgz_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Iesu dim da inap venasepen taiwandini asigip tani menan tau ae anega wayamon, “Endi e orup ansena menan anuiwanin?” ");
INSERT INTO dgz_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Mu garewa anega wane, “Iesu at Nasaret apanewa.” Iesu anega wan, “Ne me di,” (Diuda omin apanewa ap mepe den tanam yoniwandin). ");
INSERT INTO dgz_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ame Iesu anega waniwa, “Ne me di,” mu tap nitue use tan pia geamone. ");
INSERT INTO dgz_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Iesu singui sia wayawamon, “Endi e da menan anuiwanin?” Mu anega wane, “Iesu at Nasaret apanewa.” ");
INSERT INTO dgz_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Iesu gare wan, “Ne gaset wadiaena, ne mame. Go endi ne yona taiwaniampinawa, apan ma upinewa ae vemone amop.” ");
INSERT INTO dgz_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Inak mame venaseniwa ame Iesu gaset namu manega waiwandini, “Daiton da nenaana ya wakauman,” ame om inapen menan venasen. ");
INSERT INTO dgz_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Boge Saimon Pita kereba megawa da wareni ame ware pirisi bawarewa ame nao apane mega topen tani boge darinewa nutup to kuasen, (nao apane ame yaua Malukas). ");
INSERT INTO dgz_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Go Iesu Pita ase anega dien, “Kereba gega mek ae di bat! Endi ne Mamana negeni itanewa di warapen taivin, e ya watananegene!” ");
INSERT INTO dgz_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Boge Rom ita anan nagirewa ge namu yoyo mugawa ge Diu God Paewa amase taine nagirewa amon Iesu to waran. Mu damiga panan, ");
INSERT INTO dgz_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","amba waran namu Anas inewa tauan, apan Kayapas ame nemnagewa. Bodu ame Kayapas pirisi aritawa wanupe ware wanden. ");
INSERT INTO dgz_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Apan Kayapas ame namu Diu nagire pusi tau tau ta anega waniwa kakaewa ame Diu nagire munan apan daiton boep. ");
INSERT INTO dgz_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Pita ge wadiamot apan da Iesu waran amone ewap amuiwanumun. Wa ewamot apan dawa ameme pirisi aritawa asigip tani menan, me Iesu den tane pirisi aritawa pa sin mega namboya unuk aen. ");
INSERT INTO dgz_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Go Pita tonan garip amat wanden. Amba wadiamot ame, pirisi aritawa asigip taniwa, ewagai sia taue, tonan kwayup taini waene da die amba Pita wat unuk aen. ");
INSERT INTO dgz_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Waen ame Pita yave anega dien, “Ge Iesu wadiamot mega da go?” Pita gare wan, “Ae, ne ap me uon.” ");
INSERT INTO dgz_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Irot waramon menan nao nagirewa ge God Paewa amase taine nagirewa epi amunu wap amba wanumopen men oma iran ikukuk nau panan iramuiwanumun, menan Pita inamup ase ae den tanamo oma irasiwandin. ");
INSERT INTO dgz_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Koni ame gapan, pirisi aritawa namua, Anas, Iesu nop opata anenen wani amba Iesu wadiamot mega oit muga anupen menan Iesu singui yasiwandini. ");
INSERT INTO dgz_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Iesu anega wan, “Ne nop aroga iragen Diu nagirewa iragi wadiamon,” Iesu gare anega wan, “Ne pot pot nop opata waine paewa ge God Paewa gwanap wadiamuingin, ap mepe Diu iragi anupen menan iam tauiwanumun, go ne nop da karaua ya wan. ");
INSERT INTO dgz_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Endi dimen singuat nimanegingi? Waenapan ame nop waingin anuiwanumune ame wayawam, ne nop waingina mu asigip.” ");
INSERT INTO dgz_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Iesu nop mame waniwa, God Paewa amase taini apane da Iesu gine namup to arame, kaimakaet anega wani, “Endi nop garewa pirisi aritawa wadia dia nopewa map anega?” ");
INSERT INTO dgz_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Menan Iesu toni apanewa inap gare wan, “Ne nop da me inap wa koeamenawa, endi nop wa koeamena ame to ewam. Go ne nop tavewa gapan di waingina ge endi di menan union ginan namun to waramean?” ");
INSERT INTO dgz_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Anas Iesu damiga panane wandeni boge watu enen pirisi aritawa Kayapas inewa aen. ");
INSERT INTO dgz_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ame Pita yone oma irasiwandini, waenapan ap mepe singui inap wane, “Ge Iesu wadiamot mega da, go?” Me wabobore anega wani, “A, ne uon.” ");
INSERT INTO dgz_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Pirisi aritawa ame nao mega tainewa da, dugup mega daitonawa apanewa gata Pita darine to kuaseniwa, ma taue Pita wayaven, “Ae, ge apan gata Iesu den egaga yawagenawa?” ");
INSERT INTO dgz_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Sia Pita waboboren, me ap wani no utap kumkum nop wan. ");
INSERT INTO dgz_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Mumaget iragen Iesu Kayapas pa mega gapan wat naun ian Rom ayopewa, Pailat, ine amon. Amba Diu epimu ya wabigimet anune menan pa arita ame gwanewa den ya unuk amon, iwa mu Paina Yamaseni Baripewa wan sepi tuguin. Amba Paina Yamaseni Baripewa iupewa topaise barip ya tugupi tawa. ");
INSERT INTO dgz_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Menan Pailat tau garip one wayawamon, “Apan ma taparit mega dim da yawa amba wayan?” ");
INSERT INTO dgz_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Mu gare wane, “Endi me koewa apane uon wandepiwa, nu endi wara ase ya genait.” ");
INSERT INTO dgz_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pailat anega wan, “Ek waran anuiana iupewa gapan wanene tan.” Diu nagirewa gare wan, “Go nu orup da paina to endao endao aroewa da nu inanup uon.” ");
INSERT INTO dgz_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Iesu bop anenen ta paina to endavepi noa Iesu namu waiwandini ame tavewa tauapen menan nop ma venase tau aen. ");
INSERT INTO dgz_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pailat pa mega gapan unuk ae amba Iesu me inap wat tauapen wan. Iesu taueni amba me Iesu inap singui wan, “Ge Diu nagirewa ayop arita mugawa go?” ");
INSERT INTO dgz_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Iesu gare wan, “Endi ame gek di anuan waingi, go gare waenapan da oitana wadiagene?” ");
INSERT INTO dgz_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pailat gare wan, “Ne Diu apanewa da uon. Go ge dim da taana menan ge waenapan gega amba pirisi ayopewa wat nauge onam nenan?” ");
INSERT INTO dgz_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Iesu anega wan, “Toemu negawa ame piup ma mega uon. Ame wandepiwa, ne Diu toguranegepen menan amatana taine nagire tantanana nenan anan tain, Diu nagirewa ya waranegepen menan. Go toemu negawa at ma gapan da uon.” ");
INSERT INTO dgz_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pailat anega wani, “Endi ge ayop aritawa di?” Iesu gare wan, “Ap me di waingiana, ne ayop aritawa di. Mame menan ne piup ma gapan tauan, waenapan nop tavewa anu kakayasepen menan. Tavewa mame menan ne yanan. Waenapan nop tavewa gambene wanumuinewa ame nop nega anuin.” ");
INSERT INTO dgz_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pailat singui anega wan, “Nop tavewa ame dim da?” Nop mame waniwa me sia tau garip ae Diu nagirewa anega diamon, “Ne koewa da me inap ya tautanan. ");
INSERT INTO dgz_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Go endi e guegue ega da inanap wandiniwa, orup da agim noke baraene wandiniwa ame Paina Yamaseni Baripewa wamewa gapan wat vetane tau aeta. Endi anuiwaniana ne ian Diu ayop aritawa egawa Iesu wat vetapen tau aeta go?” ");
INSERT INTO dgz_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Mu gare senao ase wane, “Me uon! Barabas watu en nun!” Barabas me ita anan koevet taiwandini apanewa da. ");
INSERT INTO dgz_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Boge apan Pailat Iesu gaut gane denawa gapan toiwanumat wan. Boge mu Iesu gaura tone. ");
INSERT INTO dgz_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Amba ita nagirewa ipuni wagam waran Iesu iap tonat wanane. Amba wanup buinip pan wanane iwa mu piup ayop muga ap me guegue tane. ");
INSERT INTO dgz_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Mu Iesu inap dot amo ge amo tan, anega waiwanumun, “Kaewa kaewa Diu nagire ayop aritawa mugawa!” amba mu gine namup toiwanumun. ");
INSERT INTO dgz_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Koni daiton sia Pailat tau one amba Diu nagire inamup anega wan, “Yawan, ne me naun inayap ongivin iwa ne yop tana koewa da me inap ya tanan.” ");
INSERT INTO dgz_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Wam ame ita nagirewa Iesu ipuni wagam warane iap tonasen amba wanup buinip pan wanan amba waran Pailat inap tauan, Pailat anega wadiamon, “Apanewa mame!” ");
INSERT INTO dgz_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Mek menawaet pirisi nagirewa amba ita nagirewa Iesu yawane, mu ve anega wan, “To endawan! To endawan!” Go Pailat gare anega wan, “Apan ek waran amba to endawan. Nek nenan, koewa me inapewa ne da ya tautanan.” ");
INSERT INTO dgz_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Diu nagire gare anega wane, “Nu iup nuga wandia, amba iup ame wainiwa me boepen di, iwa mek ingane God otua wan.” ");
INSERT INTO dgz_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Wam ame Pailat nop mame anuni, boge me tap aritavet anun, ");
INSERT INTO dgz_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","amba me entane pa mega gwanap aen. “Ge at ambe gapan tauaan?” Iesu singui wayaven, go Iesu nop gare da ya wan. ");
INSERT INTO dgz_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","“Ge nop inanap wawa tanda taingi?” Pailat anega wan. “Ge anu avingi ne wat vetagepen go to endawagepen aroewa inanap wandia?” ");
INSERT INTO dgz_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Iesu gare anega wan, “Ge God aro amun ame ya genapo ge bawarewa inanap ya tapo. Ibariwa ameme apan da ne waranege ge nanik gwanap baraeniwa me koewa megawa arita iragen.” ");
INSERT INTO dgz_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Amba, Pailat Iesu vesep tau aepen tan, go Diu nagire ve uma waiwanumun, “Apan ma wat veta tau aepiwa ge Rom nagirewa bawarewa iragenawa muga Sisa evenewa uon. Iwa Iesu ayop mek tan wainiwa Sisa uewa warapen taiwan. Da ayop mek ta wapi ame ayop bawarewa Sisa anavi megawa.” ");
INSERT INTO dgz_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Wam ame Pailat mame wane anuni, Iesu nau tau one amba Pailat wanene watat mega gagap ae wanden, at ameme yaua gwat gwaratan tane arewa (Iburu nop muga yaua dawa Gabata diane). ");
INSERT INTO dgz_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Wam imanawa Paina Yamaseni Baripewa menan endi Diu nagirewa taba bongam bongam ta napen taiwanumune wamewa. Wam ame ianupe wareni gapan, Pailat Diu nagire anega diamon, “Ayop aritawa ega mam.” ");
INSERT INTO dgz_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Go mu ve uma wane, “Wat asira aisen! wat aisen! To endawane boep!” Pailat singui wan, “Ne ayop aritawa ega to endawain?” Pirisi namu yoyo muga nagirewa gare wane, “Nu ayop aritawa nuga da uon go Sisa megenat.” ");
INSERT INTO dgz_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pailat uiwa gapan Iesu ware munen amo to endawapen menan. Ap menan ita nagirewa Iesu waran amat tane. ");
INSERT INTO dgz_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Mu Iesu nanamasene oma korosi wat aen. Boge Iesu nau amon at yaua Apan I Kaime Arewa tauan (Iburu nop muga gapan Golugata diane). ");
INSERT INTO dgz_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ap mepe mu korosi gapan tobatamen endawan, apan dere den guramon yamu yamu dawamon amba Iesu yaumakamup. ");
INSERT INTO dgz_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Apan Pailat ok tata kakayat ta munen korosi gagap tobatamen. Ok anega seni, ‘Ma Iesu at Nasaret apanewa. Diu nagirewa ayop mugawa,’ ok ap anega sen. ");
INSERT INTO dgz_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ian Diu nagirewa aruga ok ma batnagene, iwa Iesu tone arewa pa Ierusalem konintu, amba den nop paupe yampo, Iburu nop mugawa, Latin nop mugawa amba Gurik nop mugawa gapan ok seane. ");
INSERT INTO dgz_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Diu pirisi namu yoyo mugawa ororom warupan amon Pailat inap noyam manega wane, “Nu tanda anuivin, ‘Diu nagire ayop mugawa’ ya sea go anega se, ‘Apan ma mek anega wan, Ne Diu nagirewa ayop mugawa’ ap anega se.” ");
INSERT INTO dgz_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pailat gare anega wan, “Ok dim da seana, ap me di sean.” ");
INSERT INTO dgz_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Wam ame ita nagirewa Iesu oma korosi gapan tobatamen, mu wanup mega tambun, yan i degede seane, apan animpo om muga gapan, Iesu wanup mega gauarape megenat wanden. Wanup mame taginamene intume no usewa da uon, amba wanup nononga daiton aipa aupa. ");
INSERT INTO dgz_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ap menan mu anega gare gare wane, “Nu wanup ma ya benagepen. Nu kae otu da tayawat amba da wareta.” Mame tane ame God nop mega ok namua seane tavewa tauapen menan anega wani, Mu wanup nega yan sean ase ma tambun, amba wanup nega warapen menan kae tan. Amba ap me ita nagire tanewa. ");
INSERT INTO dgz_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Iesu korosi mega mainep yoniwanumune me mek inewa, me inewa gwaniwa, Meri, apan Kolopas waenewa, amba Meri Makdalin. ");
INSERT INTO dgz_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Menan Iesu inewa ap mepe yaven, amba wa ewamot da me menan anu guriniwa konintu mainep yoniwandin, menan inewa inap anega wan, “Inan kaiwan, ase me endi ge otugawa.” ");
INSERT INTO dgz_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Amba wadiat mega inap wan, “Endi ma, ge inagawa.” Wam ame use aeniwa, wadiat apane mame Iesu inewa pa mega gapan kwayup taiwandin. ");
INSERT INTO dgz_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Evi amba, God nop mega namua ok seane tavewa tauapen menan amba Iesu me nao mega iragi taitamen anuni menan, Iesu anega wan, “Ne megana pakaraia.” ");
INSERT INTO dgz_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Unup sera da kaum sisi dena yaua viniga no dotouen ap mepe wanden, menan ita apanewa wanup kauma aipa antapene puakame amba gerok ginap panen, Iesu nop use baraen. ");
INSERT INTO dgz_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Wam ame kaum mut mut tani, Iesu anega wan, “Iragi taitamen.” Ap gapan, me guewa tau aen nawane pae waren. ");
INSERT INTO dgz_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Endiwa wam bongam bongam wamewa amba wam aigapewa Diu nagirewa pura bawarewa amba Paina Yamaseni Baripewa wamewa menan Diu nagire anune kakae uon iwa bonigawa etumu korosi muga muga gapan ya wanumopen. Ap menan, mu amo Pailat singui tayave pusimu kaimamu topapaisep menawaet borit wap amba etumu tambu vitapen. ");
INSERT INTO dgz_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Pailat umap wani menan, ita nagirewa tauan up apane Iesu mainap to endawane namua pusi kaime topapaisen amba up apane dawa ap anega den tane. ");
INSERT INTO dgz_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Go mu Iesu ine tauan yawane gaset boen menan, mu pusi kaimewa ya paitane. ");
INSERT INTO dgz_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ap menan garewa ita apane da Iesu itaya bembenip enun denip ge kaum to tamage tau visen. ");
INSERT INTO dgz_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Apan da ame yaveni guturewa wan, me anuni gutut ameme tavewa di. Amba yamap yaveni apanewa nop mega ame tavewa di ap menan e den anu tumat tan. ");
INSERT INTO dgz_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Dim dim ma iragi tan venaseniwa ame gapan God mega nop namua ok seane tavewa tauapen, ok ame manega sen, Kaimewa daiton da sep ya wan. ");
INSERT INTO dgz_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Amba sia God nop namua ok dawa gapan manega seane, Apan daiton da mu itaya enune. Itaya enune nagirewa muk den me ase yawan. ");
INSERT INTO dgz_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Evi amba, Diosep at Arimatia apane ae Pailat Iesu etua warapen menan singui tan. Diosep Iesu wadiat mega da, go karaua anu tumat taiwandini iwa Diu nagire tamu tan. Pailat umap wani me taue Iesu etua wat aen. ");
INSERT INTO dgz_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Diosep ge Nikodimas dere amon, Nikodimas ame namu Iesu ine daio muma taueni apanewa. Apan Nikodimas ame oma ose tutu dena gotonak, yaumua Elo ge Mer, ene wat onen, itan mega paua ik tuat dere enepi ame om inen. ");
INSERT INTO dgz_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Apan dere ame Iesu etua oma osewa tutu dena gapan enu iran amba wanup nononga da gapan viri viri warane. Mame tane Diu nagire borit wane tumuine guegue muga gapan tan. ");
INSERT INTO dgz_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","At ap mepe Iesu to endawane ap mainep egak da wande en, dagup ewakewa da egaga ap mepe, dagup ameme gapan namu daiton da boeni ya baraene. ");
INSERT INTO dgz_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Iesu etua dagup konintu wandiniwa gapan baraene iwa mu wam ame Diu nagire bongam bongam muga aritawa da wamewa nanamu tane. ");
INSERT INTO dgz_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Pura namunupewa ame wam ibariwa gapan mumaget iragen, mum igoe den wandeni, Meri Makdalin yon wande dagup yawapen aeni dagup tonanewa agim wabaimene no aroga yaven. ");
INSERT INTO dgz_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Boge me serarat aeni Saimon Pita ge wadiamot apan da, Iesu apan ame menan anu guriniwa, ame anega diamon, “Akae, ayop etua dagupa wat tau amba amone, endi nu oare wat amon amba baraene!” ");
INSERT INTO dgz_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Menan Pita ge wadiat apan dawa dagup yawapen menan amon. ");
INSERT INTO dgz_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Mu dere serarat amone, go apan dawa Pita wat garawase dagup namu tauen. ");
INSERT INTO dgz_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Wadiat apane ame kaut enuni dagup gwane yangut tani, wanup en totnak baraene ame megenat geat wanden yaven go me ya unuk aen. ");
INSERT INTO dgz_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Go Saimon Pita, taue tamana dagup gwanewa unuk aen, me wa panam baraene wanupewa wanden yaven. ");
INSERT INTO dgz_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ap mepe bop taine gapan tumuine wanupewa Iesu iap ikukuk panane den wanden. Tumuine wanupewa ap me gapan wa panam baraene, mek mini wanden. ");
INSERT INTO dgz_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Amba wadiat apan dawa dagup namu taueni, den sia unuk aen, yaveni amba anu tumat tan. ");
INSERT INTO dgz_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Mu wataget God no oise kakaewa namua gapan Iesu bop gapan yon wandepi no oise waiwanumune ame da ya di anu awane go ma venaseni gapan mu di anu awane. ");
INSERT INTO dgz_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Wadiamot dere ame ewagai pa muga amon, ");
INSERT INTO dgz_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","go Meri ewamup taue, dagup garip yone irip waiwandin. Meri iri den kaut enu dagup gwanewa yangut tani, ");
INSERT INTO dgz_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","anea dere, wanup muga pomponugaet, Iesu etua wandeni arap wanumone. Anea daiton iap use ma wanden amba dawa pusip use wandeni. ");
INSERT INTO dgz_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Mu singui wayawane, “Waen ge irip dimen waingi?” Meri gare anega wan, “Ayop nega waenapan da wat amon. Endi ne oare amba baraene wandia.” ");
INSERT INTO dgz_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Meri nop wani ewap to entane Iesu yoniwandin use yaven go Iesu irewa ya yao aven. ");
INSERT INTO dgz_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Iesu anega wan, “Waen ge, dimen irip waingi? Ge da yowa taingi?” Meri me egak i apanewa da anuni menan anega wan, “Ge ayop negawa etua wat agean go? Baraena arewa wadianege ne ange warap.” ");
INSERT INTO dgz_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Iesu ase dien, “Meri.” Gine tutup Meri gambenewa to entane ian Diu nop muga gapan anega wan, “Rabonai” (nop ame guegue, Wadianet Nugawa). ");
INSERT INTO dgz_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ap me gapan Iesu anega wan, “Ae venek, ya waranege, iwa ne Mamana inewa sia entanen ya angen. Go wa ewamot negawa menan ak amba oitana mame wadiam, ‘Ne entanan, ne Mamanawa amba e Mamayawa, ne God negawa amba e God egawa inap angepen taivin.’” ");
INSERT INTO dgz_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Boge Meri Makdalin ware wadiamot nagire inamu aen anega wan, “Ne Ayop yawan!” amba me Iesu wadieni oisewa ase wadiamon. ");
INSERT INTO dgz_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Wam ame pura ibariwa mum gine, wa ewamot nagire iravi at daiton to dagonen. Diu nagirewa tamu anune menan tonan gin kapet tan wanumune. Boge Iesu ap mepe inamup venase anega wan, “Nonup inayap wandep.” ");
INSERT INTO dgz_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Mame wani ewap, me naniwa ge bembeniwa ewamon. Boge wa ewamot nagire mega aton aigap di anune, iwa mu ayop yawane menan. ");
INSERT INTO dgz_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Iesu sia wan, “Nonup inayap wande ep Mamana watu enanegeni mini, ne watu enaiangin.” ");
INSERT INTO dgz_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Nop ame wani gaup aigamup upune anega wan, “Guewa Woup Seniwa waran. ");
INSERT INTO dgz_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","E orup da koewa mega anu ae veanewa, koewa mega uon tata. E koewa mega anun ae ya veanewa, koewa mega wandeta.” ");
INSERT INTO dgz_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Endi apan Tomas (me yaua dawa Naturup) apan aonagaet pusinawan derewa apan ame da. Wam ame Iesu wadiamot mega inamup venasen, me wa ewamot upinewa den ya tanam wanden. ");
INSERT INTO dgz_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Menan Tomas evi amba taueni, wa ewamot upinewa me anega diane, “Nu Ayop yawaton.” Go Tomas anega diamon, “Ne anu tumat ya taivin go me naniwa ikoko tone guinewa yawap nanina pirua wat enapenawa amba bembeniwa gwin den wat anupenawa ap gapan ne anu tumat tain.” ");
INSERT INTO dgz_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Pura daiton uon tani ewap wa ewamot nagire Tomas den tanam wanden. Ame tonan iravi gin kapet tan wanumone, go Iesu taue yaumakamup yone anega diamon, “Nonup inayap wande ep.” ");
INSERT INTO dgz_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Boge Iesu Tomas ise anega dien, “Nanina ma yao, nanik piru wat onak mapa bat nanina guin wat anu. Naniga endimat bembeninap bat anu. Anu bambam ae ve anu tumat ta.” ");
INSERT INTO dgz_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas yone Iesu anega dien, “Ayop negawa amba God negawa!” ");
INSERT INTO dgz_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Boge Iesu anega dien, “Iwa ge ase ma yawanegeana menan ge anu tumat taiagi. Go waenapan da da ya yawaneginewa go mu anu tumat tainewa mu wat atonat aigape warain.” ");
INSERT INTO dgz_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Iesu yo paua arugataet da wa ewamot mega namumup taiwandin, go nop ap me buka ma gapan den ya seane. ");
INSERT INTO dgz_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Go endi nop oit mame seanewa ame Iesu me God om enuni apanewa, Keriso di, amba me God otua di, e anu tumat tapen menan. Ap anu tumat taiwaniampinawa e Iesu yaua gapan inak warai. ");
INSERT INTO dgz_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Evi da sia Iesu wa ewamot mega inamup venasen, awan Galili etop (yaua dawa Taibirias diane). Tani gueguewa manega di, ");
INSERT INTO dgz_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Pita, Tomas, Nataniero pa sewa mega Keina at Galili apanewa, Sebedi otu waiwa, amba wa ewamot da dere ap mepe den tobot tan wanumon. ");
INSERT INTO dgz_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saimon Pita anega diamon, “Ne meo dawane angewan.” Amba mu anega wane, “Nu ge den anait.” Menan mu iragi tau amon kabum gwanap dotouan, go mum ame dawan tane meo da ya warupane. ");
INSERT INTO dgz_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Woup seni, mumaget iragen Iesu awan etop gerata yonen, go wa ewamot nagire Iesu irewa da ya yao awane. ");
INSERT INTO dgz_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Iesu inamup anega diamon, “Oruma, meo da upayan?” Mu gare anega wane, “Uon.” ");
INSERT INTO dgz_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Menan me anega diamon, “Ia egawa kabum nutup arigewa gapan antap enane amba e upi upai.” Me wani no utap tane gapan, ia wa panan tain en amba warupane iwa meo arugataet. ");
INSERT INTO dgz_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Boge wa ewamot da Iesu menan anu guriniwa Pita inap anega wan, “Ase Ayop!” Mek menawaet Saimon Pita nop ame anuni, “Ase me Ayop,” me wanup mega garipewa me namu warup ase baraeni sia ware kankamup paneni boge bup ta kauma gearen, ");
INSERT INTO dgz_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Wa ewamot upinewa kabum waran Pita ewap amon, ia meo no dotoueni den warupen onam wanumune, iwa kaum etoa nononga uon, damik wagu dere intum tapo om mega mini. ");
INSERT INTO dgz_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Onamon piup tauane gapan, meo omaya yagit wandin yawan amba taba buredi upi den yawamon. ");
INSERT INTO dgz_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Iesu mu inamup anega wan, “Meo endi ma ewake upayana upi tam onaen.” ");
INSERT INTO dgz_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Amba Saimon Pita kabum mainep ae ia okokok warup one kaum etoa tauen. Ap mepe meo bawarewa mugenataet, apane nani yamunaet nani yamu dere apan da aonagaet pusinawan yampo (153), dena go meo arugataet ame ia da bebep ya wan. ");
INSERT INTO dgz_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Iesu inamup anega wan, “Onaen mumageta tabaewa nan.” Wa ewamot da singui ya tane “Ge da?” iwa mu asik tane me Ayop di. ");
INSERT INTO dgz_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Iesu one, taba buredi ware muneni, amba meo ap umap den sia munen. ");
INSERT INTO dgz_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Mame endi yawat mega wam koni yampoa Iesu bop ta inakae yon wandeni ewap wa ewamot mega inamup venaseniwa. ");
INSERT INTO dgz_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Wam ame mu taba nane ewap, Iesu Saimon Pita inap singui wayaven, “Saimon apan Dion otua ma upi nenan anuiwanumune mini ge tave di nenan bumaga tantan anu guringi go?” Saimon Pita gare anega wan, “Umap, Ayop, ge asigigap ne genan anu gurivin.” Iesu gare wan, “Man sip otu nega watu muingan.” ");
INSERT INTO dgz_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Sia Iesu anega wan, “Saimon apan Dion otua ge tave di bumagan tantan nenan anu guringi go?” Saimon Pita gare anega wan, “Umap, Ayop, ge asik taan ne genan anu gurivin.” Iesu sia anega wan, “Man sip nega kwayup tamuingan.” ");
INSERT INTO dgz_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Wam koni yampoa Iesu Pita inap anega wan, “Saimon apan Dion otua ge tave di nenan anu guringi go?” Pita bumagap anu tanen iwa Iesu koni yampoa me inap singui wayaven, ‘Ge tave di nenan anu guringi go?’ Me gare anega wan, “Ayop negawa ge iragi anuitamingi. Ge asik taan ne genan anu gurivin.” Iesu gare anega wan, “Man Sip otua negawa watumuingan. ");
INSERT INTO dgz_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ne nop tavewa di wadiaivin, ge wam ame tamaru gapan wanigeana gan gorogot gek ingane pana amba aget anuana gapan agingian, go apan tave tawa naniga en nonongame, orup dawa naniga damik gapan panep amba ya aget anuiana arewa wat nauge aeta.” ");
INSERT INTO dgz_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Iesu nop mame wani guegue ame, Pita evi amba anenen ta ae amba bop tapi ap gapan God oya oya mega wabawaramepi oisewa Iesu namu wan. Boge Iesu me inap anega wan, “Pusin wakukurup amu amu onak.” ");
INSERT INTO dgz_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pita entane yaveni ame wa ewamot da, Iesu me inap anu guriniwa, ewamup oniwandin yaven. (Mame da Iesu toganep dave Paina Yamaseni Baripewa nane gapan anega wani, “Ayop ma da ominaga wata?”) ");
INSERT INTO dgz_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Wam ame Pita yaveni, me Iesu inap singui wan, “Ayop, amba me anenen?” ");
INSERT INTO dgz_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Iesu gare anega wan, “Ne anupenawa me wande aiwandapina amba ne ewagai sia entan tauain, ame ge inagap anenen? Ge mek ewanap di onak.” ");
INSERT INTO dgz_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Iwa Iesu nop mame wani menan nop oit senare tau aen amba wadiamot megawa manega anu waramat ta wane, “Iesu wadiat mega da, Iesu me inap anu guriniwa apanewa, me ya di boeta.” Go Iesu anega ya wani, “Me ya boeta.” Go me manega megenat wan, “Ne anupenawa me wande aiwandapina amba ne ewagai sia entan tauain, ame ge inagap anenen?” ");
INSERT INTO dgz_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ne Iesu wadiat mega, yavina apanewa, ameme nop mame wadidiaivin, ok mame sivin. Ne anuivin nop mame tavewa di. ");
INSERT INTO dgz_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Iesu piup ma gapan yo ugup ugup baita da ya tan. Go me taniwa oisewa iragi buka gapan ok ae seapoa ne anuingina ame piup uruga gapan buka iragi arok muga umap ya di tapo. ");
INSERT INTO dgz_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Kaewa kaewa gwanina Tiopilas, ge asigigap, ne buka nega daitonawa gwanap Iesu nao ere watape iragi wadidiam aiwandin eni amba kiman dot aeni, ame oisewa namu inagap ok sean. Go Iesu namu om enumoni watu enamot mega inamup Guewa Woup Seniwa gamup nop pusi panamoin eni amba kiman dot aen. ");
INSERT INTO dgz_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Iesu ugu vegaek anu bop tani sia yon wandeni anu kakayasepen menan wam apane dere gapan me aroga inamup tauen. Me wadiamot mega tamana di yawane amba me God toemu mega oisewa wadidiamuiwandin. ");
INSERT INTO dgz_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Wam daiton ame Iesu wadiamot mega iragi tanamo wandeni Iesu anega diamon, “Pa Ierusalem ae ya ve aisene go Mamana God Guewa garaet enat wa agiat imaeni men wadiaena tavewa warapen menan amase mapa tan. ");
INSERT INTO dgz_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Dion waenapan kaum gapan dup iamuiwandin, go wam konintu amba God Guewa Posewa Woup Seniwa gapan dup iaeta.” ");
INSERT INTO dgz_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Menan wadiamot mega me singui anega wayawan, “Ayop, Rom nagirewa nu at piup nuga warane, wam mame gapan ge at piup nuga Isurero ewagai sia nunai?” ");
INSERT INTO dgz_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Iesu gare wan, “Ne Mamana wamewa om enuini apanewa, me megenat asigip tan. E iragi mame ya anu anu. ");
INSERT INTO dgz_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Go Guewa Posewa Woup Seniwa aigayap visepi, e aro amun warai. Amba iragi nop oit nega wa aitai, at Ierusalem, Diudia iragi, amba Sameria, amba den at piup uruga oitana wadidiam wanian.” ");
INSERT INTO dgz_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Nop mame wani ewap, yamamup Iesu pusiwa ao bunae kiman dot aen, dot aiwandini irikup taue yamamup waboren. ");
INSERT INTO dgz_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Menan kimani yangut ao kem kem yaviwanumune gapan, apan dere wanup pomponu enan mainemup venat mutan yonan, amba anega wan, ");
INSERT INTO dgz_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","“At Galili nagirewa, iwa dimen yonayan kiman gwane ao yaviwanin? Iesu mame yawayan dot aeni, ewagai tauapen tapi anenen yawayan dot aeni ap umap sia taueta.” ");
INSERT INTO dgz_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Amba ap mepe tunup yaua Olip gapan entanen pa Ierusalem sia amon, Diu nagire pura bawarewa muga iup mega kwayupe tane menan mu ap nononga ya amon go konintu amon amba pa sewa Ierusalem tauan. ");
INSERT INTO dgz_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Wam ame mu tauanewa mu inine paewa, pa aigapewa dot amon. Tauane apane yaumua mam, Pita, Dion, Diemis, Anduru, Pilip, Tomas, Batolomio, Matiu, Alopias otua Diemis, Saimon namu ian Rom nagirewa wa oimopen taiwandini apanewa amba Diudes apan Diemis otua. ");
INSERT INTO dgz_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Iesu wa ewamot megawa, Iesu gwani waiwa, Meri Iesu inewa, amba waen upi den, mu iragi imu pose daiton tobot tan wam wam ap mepe mup taiwanumun. ");
INSERT INTO dgz_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ame gapan, wam da, Iesu anu tumat taine nagirewa tobot tane ame paua muga apane nani yamunaet nani yamu daiton (120) ap mepe iam wanumune. Amba Pita yaumakamup yone anega wadiamon, ");
INSERT INTO dgz_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","“Tatan, gwanin, apan Diudes anenen tapi oisewa wataget Guewa Woup Seni gapan apan Devit wani no utap ame tavewa mame tauen. Ame Diudes nu nao nuga daitona apanewa, negin ta, ita nagirewa naumo tauen Iesu panan waran.” ");
INSERT INTO dgz_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Diudes Iesu omine wani garewa agim make ap gapan piup da une tan. Me une tani piupewa gapan me geare boen bagua tuk wa ase ma wanden amba nia iragi aroga tauen. ");
INSERT INTO dgz_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Oit ma pa Ierusalem gapan wanumone nagirewa iragi anune, menan mu piup ame nop muga gapan yaua Akelodama diane. Akelodama (gueguewa ame, apan deniwa piupewa). ");
INSERT INTO dgz_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Amba Pita sia wan, “God no oise namua kakaewa buka Sam gapan ok anega seane, Pa mega pokaet wandep, waenapan gwanap ya wanumop. Nao mega apan dawa ware namu yoyo tap. ");
INSERT INTO dgz_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Ap menan Diudes garewa, apan da, Ayop nuga inakae sia yon wandeni oisewa nu den Iesu oisewa yonat wadidiamot anuini apanewa om enuit. Amba apan ap me, nu den tana intoni apanewa amba erewa Dion dup iam wandini gapan watape ta oneni wam mame taueni amba God aro mega gapan Iesu kiman dot aen yaveni apan ameme Diudes uewa wareta.” ");
INSERT INTO dgz_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ap menan mu apan dere om enumone. Da yaua Diosep Basabas (yaua dawa den mu asik tane ame Diastas) amba apan dawa me yaua Matayas. ");
INSERT INTO dgz_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Boge mu mup anega wane, “Ayop nugawa, ge waenapan iragi imunu potanu yavitamianawa. Apan Diudes watu enamot gega navewa ae ve at mega aeni apan dere mame ansena da ge om enuana to ewan.” ");
INSERT INTO dgz_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Mup wane, God apan ansena men anuni mu yao anupen menan iraga yaoyao kaewa otu da tane gapan apan Matayas om mega enturunagen. Ap menan apan Matayas Iesu watu enamot megawa aonagaet pusinawan daiton ame den tobot tan yonan. ");
INSERT INTO dgz_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Iesu kiman dot aeni wam aonagaet ewap, wam yaua Pentikos gapan, Iesu anu tumasine nagirewa mu pa daiton iamen wanumon. ");
INSERT INTO dgz_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Amba unuk baware da taik tawak mini kimani tauen, taik ununkewa pa gwanewa bararaen. ");
INSERT INTO dgz_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Mu iamup daiton daiton merao meriwa yan se yagim wandin yawan. ");
INSERT INTO dgz_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","God Guewa Posewa Woup Seni gine daiton potamup taue aro muneni gapan merimu to bayanen ian da da nop muga ugup ugup ya anuine nopewa gapan waiwanumune. ");
INSERT INTO dgz_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Pentikos wamewa gapan, God ayamase taine ian Diu nagirewa, at at iragi gapan Ierusalem Pentikos baripewa menan tauan iamen. ");
INSERT INTO dgz_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Mu nop waiwanumune ununkewa anunewa seke tane no i kap wane amba iragi at ap me gapan to iamen iwa mu anune daiton daiton nop muga muga gapan waiwanumune. ");
INSERT INTO dgz_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Waenapan arugataet ame imumu yon wanden menan tarak anega wane, “Yawamon! waenapan mame nop waiwanumune anuintoni mu iragi Galili nagirewa? ");
INSERT INTO dgz_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Go anenen nu anuintoni iragi nop nuga nuga gapan waiwanum? ");
INSERT INTO dgz_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","At nuga ugup ugup gapan tauaton ame, Patia, Midia, Ilam, Mesopotemia, Diudia, Kapadosia, Pontas, Eisia, ");
INSERT INTO dgz_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","11","Pirigia, Pampilia, Idip, Libia arigewa at Sairini mainep, nu upi at Rom gapan tauaton amba nu upi at Kurit ge Arebia nagirewa. Nu Diu nagirewa ge ian ugupe Diu guegue nuga tat anuine nagirewa. Anuintoni iragi nop nuga nuga gapan God anenen baware iragen tani oisewa waiwanum.” ");
INSERT INTO dgz_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Anu bambam den tarak gare gare wan, “Ma tavewa dim da?” ");
INSERT INTO dgz_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Go upinewa wawa koko tan anega wane, “Kaum sisi denawa aritavet nane!” ");
INSERT INTO dgz_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Go Pita, Iesu watu enamot mega aonagaet pusinawan daiton nagirewa den tanamon, ao yon wande iam iam baware ame inamup opata kaimakaet anega wan, “Evenan waina, Diu nagirewa, e da da mapa Ierusalem gapanawa. Neman guran nop anen wapena anun. ");
INSERT INTO dgz_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Waenapan ma kaum kaimake dena nat ya anune iwa ma mumaget wam airase nani yamunaet nani yamu degede megenat. ");
INSERT INTO dgz_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Go watageta God oisewa waiwandini apane Dioero endi ma anenen venaseni nopewa wataget ok manega sen, ");
INSERT INTO dgz_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","God anega wan, ‘Wam verisiwa gapan waenapan ugup ugup, ne Guana aigamup wagemain. E otu waiawa ge ora waiawa God wadiamopi nopewa wain. E tamaru egawa bet ine yawain, amba e aeta egawa enok inain. ");
INSERT INTO dgz_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Wam ame gapan ne Guana nao nega waene apanewa, aigamup den wagemain, amba mu ne nop oit nega wain. ");
INSERT INTO dgz_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ne kiman ge piup gapan, denip amba oma yamewa, ge dagin uni gware dena gapan ne yo paua ta ewamoin. ");
INSERT INTO dgz_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Wam mum tunuta, siragam dendeni tata. Iragi mame venasepi ewap Ayop wam mega bawarewa taueta. ");
INSERT INTO dgz_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Amba waenapan da da Ayop Iesu menan wap, anu tumasepiwa ame inak warain.’ ");
INSERT INTO dgz_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ian Isurero, nop ma iragi anun, Iesu at Nasaret apanewa, me aigap iragen. God Iesu kakae guragut megawa ta ewaepen menan yo kimani paua baware ugup ugup ame Iesu gamup tan. E mame iragi anuyan, iwa endi mame yamayap venasen. ");
INSERT INTO dgz_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","God Iesu eneni go e God iup mega ya anuine nagirewa den, wara korosia toyan. Go mame God anut mega wataget anenen venaset anuni gapan di venasen. ");
INSERT INTO dgz_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Go God Iesu bop gapan wat inakamen ap menan bop gapan me wat vesen, iwa bop aroewa wat nat wat nat umap uon. ");
INSERT INTO dgz_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Wataget apan Devit Iesu bop aroewa ya wat nasepi oisewa namu manega wan, Ne Ayop nega God pot pot imunap yavivin. Ne dararam ya tain iwa me mainanap wandia. ");
INSERT INTO dgz_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ap menan ne potanap aton anuivin, amba nonap wa atona gimagingain. Ne tamana di bonigatain go anu dao gimage gapan iningain. ");
INSERT INTO dgz_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Iwa guana borit waine nagire at muga aepi, ap mepe ge ae ya venegai. Ne ayamase den nao gega pot poraet taina apanewa, menan epina ya puakaet anuingi. ");
INSERT INTO dgz_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Inak neginewa ge wa ewanegingai gende gende wanineta, menan aton nega baware anuingain.” ");
INSERT INTO dgz_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Pita opata aigap sia wan, “Tatan, gwanin, ne gego den ya wadiaivin, ame omayan baewa Devit bop tan amba tune, kaima mega ma wanden oneni endi mame wandia. ");
INSERT INTO dgz_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Watageta apanewa Devit, God no oise waiwandiniwa menan God wa agiaseni ame Devit me asigip. God Devit inap agi wan, ame Devit ani sibabasi mega da evi amba Ayop dieta amba Devit watat mega gagap wandeta. ");
INSERT INTO dgz_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","God dim da tapi Devit namu anun menan Iesu boe inakae sia yon wandepi oisewa manega wan, Me kaima arewa gapan ae ya veta, etua mega ya puakaeta. ");
INSERT INTO dgz_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Devit wataget wani tavewa tauen. God aro mega gapan Iesu bop gapan wat inakamen. Nu mame iravi venasen yawatoni nagirewa ame oisewa waivin. ");
INSERT INTO dgz_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Iesu kiman dot aeni endi mame God mainewa nutup gapan wandia. Mamewa Guewa Posewa Woup Seniwa otua Iesu wa agiaseni gapan wanen. Amba Iesu Guewa ame aoma wagemen, endi ma me di yawaton anuivin. ");
INSERT INTO dgz_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Devit kiman ya dot aen go Iesu menan anega wan, Ayop Mamewa God, me Ayop inap anega wan, ‘Mainena nutup gapan wanigingan, ne anavi gega iravi tambumop gauaragap semopena menan.’ Devit ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","God nop mame wani iwa mega ame at Isurero nagirewa iragi tavewa ma anu kakayasepen menan. Tavewa mame di, apan Iesu, e oma korosi gapan togurayana, ame God Ayop nuga dien amba God om enuni apanewa Keriso den dien,” Pita ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Wam ame Pita wani anune, koewa muga menan bumagamu tuk tak wan amba Pita ge Iesu watu enamot mega upinewa den singui tayawamon, “Orup ma, nu anenen tait?” ");
INSERT INTO dgz_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pita gare anega wadiamon, “E iragi daiton daiton inat waniet ega gapan imuya entan tane amba Iesu yaua gapan dup iai, God koewa ega anu ae veapen menan. Ame gapan Guewa Posewa Woup Seniwa warai, ame God garaet megawa. ");
INSERT INTO dgz_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","God agi mame enen, ge otu waiawa munan den, amba den waenapan wandapewa munan. Ap me Ayop God waenapan munan wapiwa me munan tata.” ");
INSERT INTO dgz_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita tagigiramu nop arugataet wan, amba me anega sia wan, “Endi piup gapan waenapan koewa taine bararaen ap menan inak ega kwayupe ek di tan.” ");
INSERT INTO dgz_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ap menan, Pita wani nopewa anun warane nagirewa dup iane ameme paua mugawa wam ame arugataet 3000 mini tauen. ");
INSERT INTO dgz_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Anu tumat taine nagirewa wam wam Ierusalem gapan uat enan Iesu watu enamoni nagire nop oit waiwanumune anuiwanumun, den nop oit gare gare wawa mutan, buredi paise paise tan ian sean naiwanumun, amba den iragi iamen mup wariwanumun. ");
INSERT INTO dgz_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Waenapan iragi Iesu watu enamot mega yo ugup ugup taiwanumune yaviwanumune menan imu pose yon wanden. ");
INSERT INTO dgz_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Iesu anu tumasine nagire iragi daiton to iamen wan dim dim muga yan aiman sean gare gare ise wan ase wan taiwanumun. ");
INSERT INTO dgz_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Den at piup ge wan dim dim muga yon boranewa iragi une tan moni waran pura puse uoni nagire munan. ");
INSERT INTO dgz_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Wam wam God Paewa Ierusalem gapan iame wanumen amba pa muga gapan buredi paise paise tan naiwanumun. Taba atonu den naiwanumun amba daiton da goandage ya anun. ");
INSERT INTO dgz_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ap menan, mu God wa atonasiwanumun. Ap gapan waenapan upine imumu wareni menan mu iragi baigan gapan wanumone. Ap menan wam wam God inak ewakewa munat anuni nagirewa aigap aigap intum tamuiwanumun. ");
INSERT INTO dgz_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Wam da mup wapen wamewa, wam airase yampoa, wareni gapan Pita ge Dion God Paewa Ierusalem amon. ");
INSERT INTO dgz_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","God Paewa, sin panane tonane da, yaua Tonan Yawat Kakaewa diane. Tonan ame gapan apan da pusi waberugasen dai tanen, inewa potap yaneni boge wande en. Wam wam wat amon tonana ap mepe bariwanumune wanden. Iwa waenapan da da God Paewa unuk onam wanumune gapan, inamup moni mu dagin dagin waiwandapen menan. ");
INSERT INTO dgz_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Wandeni Pita ge Dion unuk amuiwanumune yawamo, dim da da wanapen men mua dagin dagin da inamup wan. ");
INSERT INTO dgz_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Mu vek apane ame kem kem asenagaet yawane amba Pita anega dien, “Ae ma yawan.” ");
INSERT INTO dgz_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Vek apane ao yawamo anega anuni, ma moni da nenapen taiwanum. ");
INSERT INTO dgz_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Go Pita anega dien, “Endi ne moni da inanap uon, go endi dim da inanapewa, ap me genain, Iesu Keriso Nasaret apanewa yaua gapan diagiangin, ao yona ap ak!” ");
INSERT INTO dgz_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Amba Pita me naniwa nutup ao wareni gapan me yon wanden, boge apan pusi ni koniwa kakae ta aro waren. ");
INSERT INTO dgz_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ame pusip amu yone karapun vitagen doragen ta ase ae ma on taiwandin. Boge Pita ge Dion tanam God Paewa unuk ae aton ta karapun dore God wa atonasiwandin. ");
INSERT INTO dgz_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Waenapan yawane apan ame ap ae God wa atonasiwandin yawan. ");
INSERT INTO dgz_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ame yawane God pa sin mega Tonan Yawat Kakaewa gapan wande en moni mua waini apanewa ire yawan, yawane waenapan tap no i kap wan, iwa inak ame anenen venasen yawane menan. ");
INSERT INTO dgz_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Inak wareni apanewa Pita ge Dion ase tam natam wandeni gapan waenapan aruga no i kap baita ya wane amba inamup tauan. At ame yaua Solomon sewae pue mega diane, ap mepe God Paewa gapan wanumon. ");
INSERT INTO dgz_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pita yawamoni anega wadiamon, “At Isurero nagirewa apan ma pusiwa kakae tani menan dimen noya i kap waiwan? Dimen kem kem yawaniwanin? Apan ma ap aeni aro nuga gapan o guegue nuga tat gapan ya aewan, go nu Iesu anu tumasintoni gapan me ap aewan. ");
INSERT INTO dgz_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Omayan baewa Eibaraam, ge Aisik ge Diekap, mu God muga daiton. Ame God Iesu, God nao mega taini apanewa, yaua wabawaramen. Go e wara togurep boepen menan bawarewa nagire nanimu gwanap barayan, go Pailat wa oisep tau aet wani go e wa watanayan. ");
INSERT INTO dgz_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Daiton Iesu, me apan tamanawa, posewa woup seniwa go e waboborayan. Amba garewa e apan koewa, waenapan guramon borit wane apanewa gwat ninoke wandeni wat vesep tau aepen menan Pailat inap mup wayan. ");
INSERT INTO dgz_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","E Inak Ibariwa apanewa togurayan boen, go God aroewa gapan wan amba Iesu sia inakae yon wanden, ame nu yawatoni oisewa mame waivin. ");
INSERT INTO dgz_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Iesu me inap anu tumasintoni gapan apan ma da e yao anuiana kakae sia tan. ");
INSERT INTO dgz_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Tatan gwanin, ne asiginap, e amba aritawa ega den, anu bambamase menan Iesu togurayan. ");
INSERT INTO dgz_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Watageta, God no oise waiwanumune nagirewa, Mesaya Iesu evi ugu vegaek bagu sisi anu tanepi oisewa namu wane, ame tavewa endi tauapen menan God wani gapan e Iesu togurayan. ");
INSERT INTO dgz_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ap menan endi mame e vetavet tan amba God inap entanen. Ame tanewa God koewa ega ise wat museta. Ap taiwaniampina nonan banu wara wara wamewa Ayop inap taueta. ");
INSERT INTO dgz_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Amba Iesu ame God mega, enan om enuni apanewa, Keriso watu eneta. ");
INSERT INTO dgz_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Iesu endi kimani wandia, God dim dim iragi ewake sia tap amba taueta. Wam ame menan God watageta no oise waiwanumune potamu woup seni nagirewa gamumup ap agi wan. ");
INSERT INTO dgz_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Watageta apane Mosis agi ame Iesu menan anega wan, Ayop God egawa, e yaumakayap apan da, ne umanap, om enup, yone God no oise wata. Me dim da wadiaepi, e ae di anun. ");
INSERT INTO dgz_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Waenapan da da me nop mega ya anupiwa, God waenapan mega intum den ya tain go garip borit wain. ");
INSERT INTO dgz_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Tavewa di, God no oise waiwanumune nagirewa, watageta apane Samuero gapan amba me ewap ma onini nagirewa iragi, endi mame venasiwandini menan waiwanumun. ");
INSERT INTO dgz_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","E, oit ame waiwanumune nagire naewa mugawa. God omae baewa namu munat wa agiat mumeni endi e den wariwanin. Menan God apan Eibaraam anega wadien, ‘Naewa gega wanumopi gamumup ne waenapan at at iravi wat aipakam mumingain.’ ");
INSERT INTO dgz_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ap wani menan, wam mame God nao mega apanewa, Iesu, om enun, nu Diu nagirewa inamup namu watu enen. Iwa God Iesu gamup wat aipakam imaepi gapan e koewa ega daiton daiton wat entan tapen menan.” Pita ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita ge Dion yaugai waenapan opata di wadidiamuiwanumune, ian Diu Pirisi muga ge God Paewa tonana yonine nagire bawarewa mugawa, amba Sadusi dugup nagirewa tauan. ");
INSERT INTO dgz_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Pita ge Dion Iesu ao yon wandeni oisewa ge borit wane nagirewa sia yon wanumopi oisewa waenapan wadidiamon. Diu pirisi muga ap anune menan, notatae wane. Ap menan Pita ge Dion tambumon. ");
INSERT INTO dgz_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Mu gwat noke enamon iwa mum taueni menan. Woup sepi amba singui tayawamopen. ");
INSERT INTO dgz_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Go waenapan aruga Pita ge Dion God oise waiwanumune anune ame imumu waren anu tumat tane. Ap menan wam ame gapan apan mugenataet anu tumat tan intum tane arugataet (5,000 mini) wanumon. ");
INSERT INTO dgz_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Inane woup seni Diu bawarewa mugawa, iup wadiamuine nagirewa den amba dima waine nagire iragi Ierusalem gapan iamen. ");
INSERT INTO dgz_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Pirisi aritawa muga Anas amba Kayapas, Dion, Aleksanda amba Anas dugup mega upi den at daiton iamen nop barimen. ");
INSERT INTO dgz_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Amba Pita ge Dion wane namumup yonane amba singui wayawamon, “E ma dim da taiwanin? E aro amun da yaua gapan warayan taiwanin?” Diu bawarewa muga ap anega waiwanumune. ");
INSERT INTO dgz_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","God Guewa Pita potap no dotouen, aro waneni gapan nop garewa anega wadiamon, “Waenapan amase yonayana ge ayop nagirewa, ");
INSERT INTO dgz_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","endi singui arita mame wayana inak kakae mame yawayan vek apane inakaeni menan. ");
INSERT INTO dgz_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ap menan e, amba ian Isurero nagirewa iragi mame anun, apan pusi waberugaseni endi kakae tan yoniwandini iwa mega mame, Iesu Keriso Nasaret apane e togurayana go God wani gapan me sia ao yon wanden. ");
INSERT INTO dgz_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Iesu me gwat umap. E pa gwat gapan tuiana nagirewa, gwat ame bontait dia aipa uarean, menan Iesu tandayasean. Go God sia ware baraen, pa mega aigap tuiwan ap menan pa sewa amit iragenawa Iesu me di. ");
INSERT INTO dgz_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Inak tana tana neginewa ambagan da uon di, iwa piup ma gapan, kiman gauarap apan daiton megenat God nuneni me yaua gapan nu inak warait. Apan ame Iesu di.” Pita ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Mu Pita ge Dion kaimakaet tumban amu yonan waiwanumune yawamon, amba anu awane, mu anut arita uoni nagirewa menan mu tarage wane. Amba mu Iesu den iniwanumune anun. ");
INSERT INTO dgz_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Go koni ame gapan apan wat inakamene Pita ge Dion tanamo yoneni yawan menan nop da wawa uon tamon. ");
INSERT INTO dgz_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Menan kansoro nagirewa wa oimone tau pa garip amon amba mugenat wawa mutan, anega waiwanumune, ");
INSERT INTO dgz_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Nu apan ma inamup dim da tait? Waenapan iragi pa Ierusalem gapan ininewa yo paua mame tane mu asigimup amba nu ya waboboramoit. ");
INSERT INTO dgz_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Go oitamu seset ya wa aepen menan Iesu oisewa noa sia ya wapen diamoit.” ");
INSERT INTO dgz_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Boge mu venamu wane pa gwanap sia onamot wane tauane amba Iesu oisewa sia ya wapen, waenapan sia ya wadidiamopen menan kaimakaet diamon. ");
INSERT INTO dgz_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Go Pita ge Dion nop gare anega wane, “Nop seyao wareyao ek inga ingane ta yawan God yamap ansena kakae, God nop mega warait go nop ega warait? ");
INSERT INTO dgz_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ap menan nu dim da yao anutoni gapan di wait.” ");
INSERT INTO dgz_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Kansoro nagirewa nop mame menan tut om tane menan mu wa oimone amon. Mu itan munat anune go waenapan tamu anune menan ya munan iwa Pita ge Dion yo ma tane menan waenapan God wa atonasiwanumun. ");
INSERT INTO dgz_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Pusi waberugaseni apanewa wat inakameni me orup otu uon, go en mega apane dere (40) upi aigap den. ");
INSERT INTO dgz_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Wa oimone ewap Pita ge Dion ewagai entan amon evene wai inamup tauan. Amba pirisi nagirewa ge waenapan dimae waine nagirewa nop iragi inamup wane ame oisewa wadidiamon. ");
INSERT INTO dgz_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Oit ame anune imumu daiton gapan God inap mup anega wan, “Ayop nuga iragenawa, piup, kiman, puiman amba wan dim dim iragi nu den waan ta venat nitaton. ");
INSERT INTO dgz_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ge watageta Guaga Woup Seniwa gapan nu omayan bae Devit no utap taueni manega wan, Iwa dim men Diu uoni ian ugupe nagirewa, ugu gangan taiwanum? Amba Diu nagirewa God dim da tat anuni, wa koeragamepen taiwanum, go umap uon. ");
INSERT INTO dgz_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","God om enuni apanewa Keriso dere anut muga toborapen, menan piup ayopewa waenapan muga bongamiwanum, bawarewa nagirewa iam iam taiwanum. ");
INSERT INTO dgz_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ame watageta apanewa Devit wani tavewa tauen iwa Erot ge Pontias Pailat dere at ugupe nagirewa amba Diu nagirewa at ma Ierusalem gapan iamen wanumune amba nao gega taiwandini posewa woup seni, om enuni apanewa, Iesu to boniga baraet anun noa karaua panane. ");
INSERT INTO dgz_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Go ge dim da ta venaset namu anuana amba wam om enuana ame gapan mu di tane. ");
INSERT INTO dgz_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ayop nuga God, endi guranepen menan sia taiwanum ge yawam. Menan nao gega taintoni nagirewa kaimakaet tumban amu yonat nop gega epara ta wadidiamopen menan aro nun. ");
INSERT INTO dgz_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Yo paua ugup ugup ta, inak munapen menan naniga endimat, nao gega taini posewa woup seni apanewa Iesu yaua gamup.” ");
INSERT INTO dgz_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Mu mup tane ewap mu ambagan to iamen wanumone paewa nutanut enun. Amba mu iragi Guewa Woup Seniwa potamup no dotou mumeni gapan God nop mega epara ta waiwanum. ");
INSERT INTO dgz_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","33","Ame gapan, Iesu watu enamot mega aro amun aigap iragena waran Ayop Iesu bop gapan yon wandeni oisewa wa kakayasen wa nau amuiwanumun. God baware iragen garaet ta warit mumiwandin. God wat aipakam mega aigamup viseni amba Iesu anu tumasine nagire iragi imu pose wat entanen daiton tan. Menan ao yonan puraput tap muga gauda ya wane, go iragi tobot tan danamiwanum. ");
INSERT INTO dgz_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Menan orup da puraput menan ya wat ire taiwandin. Wam ame gapan, at piup aigapewa, pa gwanapewa ame iragi une tan moni tam tauane ");
INSERT INTO dgz_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","amba Iesu watu enamot mega munane. Ame boge tambun yan aiman ase ma sean Iesu anu tumasine ame purapuse uoni nagire muniwanumun. ");
INSERT INTO dgz_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ap taiwanumune, apan Diosep, dugup mega Livai, at Saiparas gapan yaneni apanewa tauen. Iesu watu enamot mega nagirewa me yaua dawa Banabas wainewa (Banabas gueguewa ame dadak apanewa otua). ");
INSERT INTO dgz_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Me piup mega une ta amba moni iravi ware one Iesu watu enamot mega nagirewa munen. ");
INSERT INTO dgz_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Wam ame gapan, apan yaua Ananayas waenewa Sapira den, memewa piup muga da ase une tane garewa warane. ");
INSERT INTO dgz_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Go memewa piup garewa agim make wareni semua otu da karaua ae tam nasen. Waenewa anuni umap den wan, amba semu upine tam ae Iesu watu enamot mega munen. ");
INSERT INTO dgz_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ap menan Pita yone anega dien, “Ananayas, ge dimen Seitan arok wanaan taue potagap unugen amba God Guewa Woup Seniwa inap ebo waan, at piup une ta garewa waraana agim make upine dimen karaua ae wat nataan? ");
INSERT INTO dgz_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Piup ame wataget gega di wande en amba ase une taan. Ame une taana ewap agim make ame gega bondan di baraean wande en. Menan dim da anen tagen amba koe koe mame anu taan? Ame waenapan inap ebo ya waan go ame God inap ebo ewasean.” ");
INSERT INTO dgz_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Apan Ananayas nop ame anuni boge beure geare ae boen. Apan ame boeni no oise iragi waenapan bunao mumen anune tap anun. ");
INSERT INTO dgz_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Amba apan tamaru upi ma tauan epiwa eragi gapan wa panamen, iri turu uon, wat amon urata tun. ");
INSERT INTO dgz_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Wam airase yampoa uon tani ewap, Ananayas waenewa taueni, pa gwane use unugen. Memewa boeni me oare. ");
INSERT INTO dgz_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Menan, Pita waen ame singui tan, “Wadianek ge memaga dere piup ega ase une tayana garewa iragi mame di?” Waen Sapira gare wan, “E, om mega iragi ap me di.” ");
INSERT INTO dgz_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ap menan Pita anega sia dien, “Iwa dimen memaga dere wawa itayan amba God Guewa ire yawapen tayan? Endi ita yao, apan memaga tune nagire tonana yoniwanum. Endi ge sia wat nauge amoin.” ");
INSERT INTO dgz_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Pita nop ap anega wani boge waen ame namup beure geare ae boen. Boge apan tonana yoniwanumune ma tauan waen boniga yawan, boge waran tau amon memewa tune mainap tun. ");
INSERT INTO dgz_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Nop oit ame aeni, Iesu anu tumasine nagirewa ge waenapan upine den anune tap gop den anun. Iwa inak arita ame venaseni menan. ");
INSERT INTO dgz_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Iesu watu enamot megawa waenapan yaumakamup kiman yo ge paua megawa ugup ugup taiwanumun. Iesu dugup mega nagirewa iragi God Paewa gwanap apan Solomon sewae pue mega gapan ap mepe tauga tanatan tan tobot tan iam wanumun. ");
INSERT INTO dgz_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","14","Ame gapan waen ge apan arugataet anu tumat tane, menan Iesu dugup mega nagirewa intum tane paua mega taue aigap aen. Amba ya anu tumasine nagirewa Iesu dugup mega wa atonat muman go tap tan intum ya tamon. ");
INSERT INTO dgz_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Iesu watu enamot mega nagirewa kakaevet taiwanumune menan vek nagirewa pa pa gapan tambumon eragi gagap semone wanumon. Iwa mu Pita mainamup tau aepi Pita gungun mega upi vek nagirewa aigamup tau aep inak mutat anun. ");
INSERT INTO dgz_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Menan sewa iragi pa Ierusalem ikukuk wanumone nagirewa vek nagire mugawa amba airampu wa guguramoni nagirewa tam onamone, iravi inak mutane. ");
INSERT INTO dgz_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Amba pirisi bawarewa ayop mugawa, me evene wai Sadusi nagirewa den, Iesu watu enamot mega inamup ugu gan gan koevet tan iwa waenapan aruga Iesu watu enamot mega nagirewa munan anuiwanumun. Ap menan mu wa koeragam mumapen menan anun. ");
INSERT INTO dgz_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ame gapan mu watu enamot nagirewa panamon tambun amon gwat noke gapan semon. ");
INSERT INTO dgz_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Go mum ame gapan Ayop God anea mega taue gwat noke tonanewa watape amba naumo ae anega diamon, ");
INSERT INTO dgz_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Aisen, God Paewa gwanap inak ewakewa mame oisewa waenapan iragi wadidiamon.” ");
INSERT INTO dgz_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ap menan woup seni gapan, anea wani no utap mu God Paewa gwanap yonan inak ewakewa oisewa wadidiamon. Amba pirisi bawarewa ayop mugawa, me evene wai den yonan Diu kansoro nagirewa dimae waine nagirewa den iravi munan wan tauan iamen. Ame gapan mu Iesu watu enamot mega nagirewa gwat ninoke gapan upam onamot wan. ");
INSERT INTO dgz_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","God Paewa tonan amase taine nagirewa amon gwat noke tauane go Iesu watu enamot mega gwanap da uon menan entan amone bawarewa muga inamup tauane amba oit manega wadiamone, ");
INSERT INTO dgz_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Nu gwat ninoke tauatoni tonan iragi gitnak mumane amba God Paewa tonan amase taine nagirewa tonan noa gapan gapan yoniwanumun. Nu tonan watapetoni apan upi gwanap uon.” ");
INSERT INTO dgz_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Oit mame anune gapan, God Paewa amase taine nagire, bawarewa mugawa ge pirisi bawarewa mugawa anu bambamasen, imumu upase anun ma anenen tau amon. ");
INSERT INTO dgz_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Imumu upan sean anuiwanumune gapan, apan da taue anega wan, “Yao! apan ame e tambumo gwat noke semoyana mu endi God Paewa gwanap opata gapan waenapan wadidiam wanum.” ");
INSERT INTO dgz_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ame gapan, God Paewa tonan amase taine bawarewa mugawa amba God Paewa tonan amase taine nagirewa upi den, amo Iesu watu enamot mega upam onamon. Mu ya guramone go mondi naumo onamone iwa waenapan God Paewa tonan amase taine nagirewa gwara guramopi tawa menan. ");
INSERT INTO dgz_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Naumo onamone iam iam paewa gwanap kansoro nagirewa namup yonat diamon. Amba pirisi bawarewa ayop mugawa singui tayawamon, ");
INSERT INTO dgz_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Nu nop kaimakaet diaetoni, e opata gapan Iesu oisewa da sia ya waiwaniampen. Go yawan, endi e nop oit ega pa Ierusalem gaset senare tau aen ame nu Iesu deniwa garewa yao nao aninat waiwanin.” ");
INSERT INTO dgz_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pita, Iesu watu enamot mega upi tanamo gare anega wadiamon, “Nu God noa di anu warait go apan noa ya anu warait. ");
INSERT INTO dgz_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","E oma korosi gapan Iesu togurayan boen. Go nu, omayan baewa den, God nugawa daiton, wani gapan Iesu inakae sia yon wanden. ");
INSERT INTO dgz_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Amba God wani gapan Iesu kiman dot aen aro amun wanupe ware God mainewa nutup gapan wandia. Me ap tani iwa mega ame nu Isurero nagirewa koewa nuga ae ve imunu entanet me koewa nuga ame anu ae vepen menan. Me Ayop nugawa, wat inakam nimanini apanewa. ");
INSERT INTO dgz_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Nu wan dim dim mame yavintoni amba oisewa waintoni nagirewa go nugenat uon, God Guewa Woup Seniwa den waiwan. God ayamase taine nagirewa yan aiman muga ame Guewa Woup Seniwa munen.” ");
INSERT INTO dgz_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kansoro nagirewa nop mame anune, garimu di ganganean gure boniga semot anun. ");
INSERT INTO dgz_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Go Parisi apan da yaua Gamelio, Parisi iup muga wadidiamuini apanewa, waenapan iravi me ayamase tainewa, kansoro gapan yoneni ame, Iesu watu enamot mega nagire wam konintu mini pa garip amot wan. ");
INSERT INTO dgz_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Mu garip amone. Amba Gamelio kansoro nagirewa anega wadiamon, “Isurero apane waiwa, neman guran e namu anu kakayasen, amba apan ma inamup taiwanian. ");
INSERT INTO dgz_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Iwa e anuyan, en namua apan da yaua Tiudas taueni anega wan, ‘Ne apan bawarewa da,’ menan apan 400 intum tan ewap amon. Go waenapan, apan ame tone boen evene wai tap punanan wat amon, anu tumat mega uon tan. ");
INSERT INTO dgz_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Wam ap me ewap, apan dawa yaua Diudes, at Galili apanewa, waenapan paua muga batnak mumapen wamewa yonen. Me den waenapan upam aen go me tone boen evene wai iragi tap punanan wat amon. ");
INSERT INTO dgz_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ap menan, ne manega wadiaivin, apan mame ae di vemon, watu enamone amop! Iwa muk imua gapan muk taiwanumampina ame uon tata. ");
INSERT INTO dgz_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Go God aro muneni gapan taiwanumampinawa, e ya di watanamoi, iwa e God inap anan tat wayan taiwanin, ame gapan iravi wakaumai.” Gamelio nop wani kansoro nagirewa anu waran. ");
INSERT INTO dgz_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Mu Iesu watu enamot mega nagirewa venamu wane sia onamon tauane amba wagu gan guramon. Iesu oisewa sia ya waiwanumampen menan tantanewa diamon amba watu enamone amon. ");
INSERT INTO dgz_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Iesu watu enamot mega Kansoro ae vemone amone gapan, mu aton aigap anune iwa God kakae diamoni menan amba Iesu menan umam anune, ame kakae di. ");
INSERT INTO dgz_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Amba wam wam pot pot God Paewa gwanap amba waenapan pa muga muga gapan oise kakaewa, Iesu me God om enuni apanewa Keriso di, ap anega wadidiam wanum. ");
INSERT INTO dgz_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Wam ame ewap, Iesu anu tumat nagirewa aruga taiwanumune gapan wam wam agim make yan sean kayakayawan taine nagirewa ago muniwanumun. Diu ame Gurik noa waine nagirewa kwapura mugawa agim make ame ya muniwanumune menan Diu ame Iburu noa waine nagirewa inamup gunat anu wane. ");
INSERT INTO dgz_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Iesu watu enamot megawa aonagaet pusinawan dere, anu tumat nagirewa munan wan tauane, amba anega diamon, “Nu God nop oit mega ae veat amba taba ge moni megenat yan ta aneta ame koerage. ");
INSERT INTO dgz_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ap menan, tatan gwanin, e yaumakayap apan nani yamunaet nani yamu dere om enumon. Mu da da anut aigap asik tane amba waenapan yamamup inat wanumot muga kakae iragen ge God Guewa gapan dima mega potamup no dotoueni nagirewa om enumon. Nu wat entan tamot nao ma intanewa taue mu onemup aep. ");
INSERT INTO dgz_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ame gapan, nu Iesu watu enamot mega nagirewa God nao mega ya wakaumait, go wam wam God inap mup wainampen, amba nop mega opata gapan wadidiamopen taivinait.” ");
INSERT INTO dgz_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Waenapan nop muga ame anune gapan, iragi atonu den umap wane. Ap menan mu Sitiven, me anu tumat kaimakaet taini apanewa amba God Guewa aro waneni gapan God nave taini apane om enun. Amba upine sia Pilip ge Porokoras ge Naikano ge Timon ge Pamenas amba Nikolas, at Antiok apanewa, me Diu apanewa uon go Diu gueguewa taini apanewa, om enumone. ");
INSERT INTO dgz_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Iesu watu enamot megawa aonagaet pusinawan dere, mup wan, nanimu iamup semon, wat aipakam mumane. ");
INSERT INTO dgz_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ap menan God nop mega senare tau aen. Ap mepe, pa Ierusalem gapan anu tumat nagirewa paua muga menawaet ao doren, amba Diu pirisi mugawa arugataet Iesu anu tumasen. ");
INSERT INTO dgz_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","God Sitiven aro wane garaet wat aipakameni gapan waenapan yaumakamup yo paua ugup ugup wa taiwandin. ");
INSERT INTO dgz_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Go Diu waenapan upi watanan. Waenapan ame Diu opata waine paewa yaua Vetamone Nagirewa, at Sairini ge Aleksandia gapan tauane nagirewa. Mu ge Diu nagirewa Silisia ge Eisia gapan tauane, Sitiven den notatae waiwanumun. ");
INSERT INTO dgz_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Go God Guewa Sitiven anut baware waneni menan gare da ya wane. ");
INSERT INTO dgz_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ap menan Diu nagirewa ame apan upi aopan wapen menan karau wadiamone. Amba mu aopan waenapan inamup anega wan, “Sitiven mame, apan Mosis ge God dere wa koeragam mume wan, anuton.” ");
INSERT INTO dgz_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ap me gapan mu pa nagirewa, dima waine nagirewa ge iup wadidiamuine nagirewa anan menan datnak muman. Ap menan waenapan ame Sitiven warup oitan waran tauan, Diu kansoro nagirewa iam iam muga taiwanumune gapan namumup yonen. ");
INSERT INTO dgz_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Amba ebo aopan imup waine nagirewa tauane anega wan, “Apan mame God Paewa ge Mosis iup namua seni den pot pot wa koeamiwan. ");
INSERT INTO dgz_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nu me manega wan anuton, apan Iesu at Nasaret apanewa God Paewa mame wabenageta amba Mosis gutut nuneni gapan inintoniwa ame wat entaneta, anega wan.” ");
INSERT INTO dgz_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Iam iam ame gapan wanumone nagirewa iragi Sitiven kem kem yaviwanumune, amba mu yawane me gine namu anea mini ganase den wan. ");
INSERT INTO dgz_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Pirisi bawarewa, ayop mugawa Sitiven singui wayaven, “Oitaga wane anutoni ame tavewa di go?” ");
INSERT INTO dgz_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Sitiven gare wan, “Maman wainawa, tatan gwanin, neman guran nop wapena anun! Nu omayan baewa Eibaraam at Eran ya aeni namup, at Mesopotemia gapan iniwandini, God oya oya mega ganase denawa me inap venasen. ");
INSERT INTO dgz_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","God anega dieni, ‘Piup ge waenapan gega ae vemo ak, agingapina amba piup ame ne to ewagepena ap mepe ak.’ ");
INSERT INTO dgz_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ap menan me at mega Kadea ae ve amba at Eran taue tabara to ap mepe botakae wande en. Eibaraam Mamewa boeni ewap God at ame gapan wat nau one piup mame endi initoniwa arewa Isurero tauen. ");
INSERT INTO dgz_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Go God wam ame gapan Eibaraam piup mame semu otu da ya di wanen. Go God Eibaraam wa agiaseni tavewa ame Eibaraam ani sibabasi mega munapen menan at piup mame mu evi amba yon borain. Go wam ame gapan Eibaraam orup da ya baraen. ");
INSERT INTO dgz_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","God anega dien, ‘Ge ani sibabasie gega at ugupe gapan en 400 wanumoin, piup muk mugawa uon. At i nagirewa gauaramup nao kaimakaet garewa uoni tap gapan wa koeragam mumain. ");
INSERT INTO dgz_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Go piup ame i nagirewa ne wanene tamoin, evi amba ani sibabasi gega ae ve tau onamo at ma gapan wa taragat nimanegain.’ ");
INSERT INTO dgz_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Boge God mu God muga wandepen amba kwayup tamopen menan Eibaraam orup apan etua tum tapen paua wanen. Waneni Eibaraam otua Aisik yaneni pura daiton uon tani ewap etua tum tan. Evi amba Aisik otua Diekap etua tum tan. Amba Diekap me otu waiwa aonagaet pusinawan dere, nu omayan baewa i nagirewa, etumu tum tan.” ");
INSERT INTO dgz_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Sitiven opata aigap sia wan, “Omayan baewa daiton ame Diosep. Diosep inap tase gwani anu koeamen. Ap menan mu Diosep waran Idip nagirewa agim make uoni navewa kaimakaet tapen menan inamup ase une tane. Go God Diosep inap den wanden. ");
INSERT INTO dgz_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Itan bagu sisi mega iragi arugataet go God kwayup mega gapan me ta aiwandin. Wam ame gapan God Diosep wat agoase anut waneni menan, at Idip, ayop mugawa Pero, Diosep inak mega yave aton tan. Ap menan Pero at Idip ge pa mega aruga, iravi Diosep kwayup tapen menan dien. ");
INSERT INTO dgz_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Wam ame evip, wankakao baware da at Idip ge Keina taueni gapan waenapan bagu sisi arita anun. Nu omayan baewa taba yoa at muga Keina gapan tane go ya tanan. ");
INSERT INTO dgz_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ap gapan apan Diekap taba at Idip gapan wandeni oisewa anun. Ap menan me otu waiwa ame, nu omayan baewa i nagirewa, daio muga erewa at Idip watu enamon. ");
INSERT INTO dgz_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Mu daio muga derewa gapan, Diosep tase waiwa irewa ya yawane menan anega diamon, ‘Ne gwania di.’ Boge Pero Diosep dugup mega gutut muga anun. ");
INSERT INTO dgz_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Menan, Diosep sep mega mamewa Diekap inap watu enen. Diekap ge dugup mega waenapan iragi 75 nagirewa me inap onamot wan. ");
INSERT INTO dgz_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ap menan Diekap otu wai den at Idip ora amone amba ap mepe borit wane. ");
INSERT INTO dgz_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Go evi amba, waenapan mu kaimamu tam at Keina onamon amba at muga pa Sekem gapan tumon. Namu apan Eibaraam at Emo nagirewa piup muga ame une tani gapan waenewa ap mepe tun. Menan omae bae kaimamu at ap mepe den tumon.” Sitiven ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Sitiven sia anega wan, “God Eibaraam wa agiaseni tavewa konintu tauapen taiwandin menan, waenapan nugawa at Idip gapan yanane senare tau aen. ");
INSERT INTO dgz_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ayop Pero ewakewa da, at Idip gapan yoneni go nu omayan baewa Diosep namu dim da Idip gapan tani guturewa me oare. ");
INSERT INTO dgz_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Menan ebo aopan gapan waenapan nuga, Isurero nagirewa, wa koeragam mumen. Me iup kaemakaet baraeni ame, Isurero orup da yanepi kwayup ya tapen go pa garip sep borit wain. Iup ame gapan me Isurero nagirewa wa koeragam mumen. ");
INSERT INTO dgz_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Wam ame gapan orup Mosis yanen, God yamap me orup kakae da, mondigawa da uon. Orup Mosis yaneni gapan siragam yampo me pa gapan kwayup tane. ");
INSERT INTO dgz_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Wandeni amba iup dena menan garip baraene go ya bop tan iwa Pero orewa orup Mosis ware megawa di wa wat aen. ");
INSERT INTO dgz_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Menan Mosis, kai ware baware tani gapan at Idip dima muga iragi anuitamen amba nop mega waiwandini, amunu den. ");
INSERT INTO dgz_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Mosis en mega apane dere wandeni gapan me dugup mega Isurero nagirewa munan anuni menan inat wanumot muga anenen yawapen menan inamup aen. ");
INSERT INTO dgz_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Inamup taueni, Idip apane da, Isurero orup da to koeragameni yaven. Mosis, Isurero apan ame aigavene ae Idip apan ame ton boen. ");
INSERT INTO dgz_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mosis imua anuni, waenapan mega naumo at Idip ae ve amopen menan God me om enun, ap anega anun, go Isurero nagirewa ap anega ya anune. ");
INSERT INTO dgz_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Inane woup sen, Mosis Isurero nagirewa inamup sia aeni gapan, Isurero apan dere anan wariwanumune inamup tauen. Me wa totomak mumapen ta anega diamon, ‘Apan negawa, e tatap gwanip, iwa dimen ek ingane anan wariwanin?’ ");
INSERT INTO dgz_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Go evene ta koeragameni apane dawa Mosis in pakisen asira aen amba anega dien, ‘Da bawarewa nuga tat diagen amba wanene inanup taingi? ");
INSERT INTO dgz_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Idip apanewa wata toguraan boeni mini endi ge toguranegepen taingi?’ ");
INSERT INTO dgz_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nop ame anuni menan Mosis tap at Midian ora aen amba ap mepe botakae wanden, amba waen naiseni, orup apan dere sen. ");
INSERT INTO dgz_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","En apane dere tau aeni ewap, Mosis at kaimewa tunup Sainai mainap pua wanden. Ap mepe anea da Mosis inap taueni, pua oma merave den yagirini mini venasen yaven. ");
INSERT INTO dgz_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mosis oma yagit wandini arewa yaveni, me imua upese anun. Ame konintu yao kakayaset anu dotou aiwandini me Ayop God noa anega wani anun, ");
INSERT INTO dgz_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Omayak baewa Eibaraam ge Aisik ge Diekap God muga daiton ne me di.’ Mosis nop ame anuni tap kaime doren yame agumen. ");
INSERT INTO dgz_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Amba God sia wan, ‘Pusik okomu upa amena ae se, piup ame gagap yoningiana ame pose woup seni piupewa, ayamase ta. ");
INSERT INTO dgz_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Waenapan nega at Idip gapan wanumuine yawamuingina. Wa koeragam mumiwanumune kakae uon di. Ne mu irip turup muga anun wat vetamopen menan kimani vit ongen. Menan endi watu enagiangin ge entane at Idip sia ak.’ ");
INSERT INTO dgz_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Wataget Isurero nagirewa Mosis inap garimu yaven nomu gapan tandayasen anega wane, ‘Da bawarewa nuga tat diagen amba wanene inanup taingi?’ Go anea pua oma yagit wandini gamup God mek di Mosis om enun amba Isurero nagirewa ayop muga, wat vetamopen apane dien. ");
INSERT INTO dgz_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Mame Mosis at Idip taueni gapan kiman paua ugup ugup tani Isurero nagirewa tam naumo aen. Me Puiman Dendeniwa gapan yo bawarewa da tan amba at kaimewa gapan yo ge paua taiwandini en apane dere (40) uon tan. ");
INSERT INTO dgz_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mame Mosis watagetawa Isurero nagirewa anega diamon, ‘God no oise waini apane da, ne umanap, ek denip ega gapan evi amba watu eneta.’ ");
INSERT INTO dgz_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mame Mosis wataget Isurero nagirewa den at kaimewa gapan wanumone. Mosis omayan baewa den wanden amba anea Tunup Sainai gapan Mosis wadieni gapan God inak wande bobot iupewa ware Isurero nagirewa muneni wadiam wadiam onin en nu inanup mame tauen. ");
INSERT INTO dgz_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Go nu omayan baewa Mosis nop mega ayamase ya tane go Mosis tandayasen amba imu pose ewagai Idip sia entan amot anun. ");
INSERT INTO dgz_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Mu Mosis tasewa, Eron anega diane, ‘Apan Mosis mame at Idip gapan upe naune oneni me dim da me inap venaseni nu oare! Ap menan god da nanigap ta nuna ame naune aep,’ ap anega diane. ");
INSERT INTO dgz_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Wam ame gapan man kao otua guewa nanimup tane. Guewa tane ame inap man garaet guran, iran yaua ao warapen baripewa tugun. ");
INSERT INTO dgz_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ap tane menan God gari yaveni gapan, wam, siragam amba kiman buanae mega inamup wa taragasiwanumune me ya watanamon. God nop mega ok seane ame om inen, O Isurero nagirewa, at kaimewa gapan en apane dere (40), man garaet gurayan iriana ame nenan uon. ");
INSERT INTO dgz_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Go e god yaua Molak pa mega, man epiwa gapan tune, wa taragase kawanem ena taiwanian. Amba God ega dawa yaua Repan me buanae mega guewa kaitayan. Ame god dere e wa taragat mumapen menan kaitamoyanawa. Ap menan at Babilon asewa ora watu enain. God anega wan.” Sitiven ap anega opata wan. ");
INSERT INTO dgz_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Sitiven sia anega wan, “Nu omayan bae nugawa at kaimewa gapan wanumune God pa mega man epiwa gapan tune. God Paewa ame yaua God Den Wandia dian. Pa ame tupen menan God Mosis wa ewasen yaveni omewa gapan tun. ");
INSERT INTO dgz_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Mosis boeni amba God apan Diosua aro amun mega wanen. Diosua gamup at ugup ugup i nagirewa upe oimon amone amba Isurero nagirewa piup muga waseamone ame gapan omayan baewa God pa mega yaua God Den Wandini diane ame wat onamon. Ap mepe, en nononga wande en aiwandin eni apan Devit wamewa tauen. ");
INSERT INTO dgz_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","God Devit atonu anun menan Devit gare God inap mup anega wan, ‘Apan Diekap amba nu dugup nugawa God daitonawa ame ge, pa kakaewa genan tut anuivin.’ ");
INSERT INTO dgz_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Tupen men mup wani go ya tun. Go mek otua Solomon God pa mega kakaewa ame tun. ");
INSERT INTO dgz_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Pa tune go God Paina Iragenawa apan nanip tune paewa gapan ya ininiwa. Ap gapan watageta God no oise waini apan da anega wan, ");
INSERT INTO dgz_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Kiman ame watat negawa amba piup ame, ne pusina gapan amun yoninawa. Pa dime dena nenan tui? Ne nonan banu warapena arewa, ambagan wandia? ");
INSERT INTO dgz_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Wan dim dim mame iravi taitameni apanewa ame ne me di. God ap anega wan.” ");
INSERT INTO dgz_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Sitiven opata mega kansoro nagirewa wadiam waiwandini endi kaimakaet anega wan, “E imuya potaya gware wani nagirewa. Imuya potaya God ya waren menan nop mega ya anuiwanin. E omae bae God Guewa Woup Seniwa tandayasene ap umap e tandayasiwanin. ");
INSERT INTO dgz_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Watageta, e omayae bae God noa waiwanumune apane iravi wa koeragam muman. God no oise waine nagirewa God nao taini apanewa Iesu tauapen oisewa waiwanumune go mu guramone borit wane. Me mame di tauen go e Iesu omine wayan boge toyan boen. ");
INSERT INTO dgz_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","E anea gamup God iup mega wariana nagirewa go iup ame ayamase ya di anuyan taiwanin.” Sitiven ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Kansoro nagirewa Sitiven opata mega anune gapan ugumu gangan naen, amba anan menan no kwapi arane. ");
INSERT INTO dgz_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Go God Guewa Woup Seniwa Sitiven potap wande aro waneni gapan kiman ao yave God kakae guragut mega ganasewa God mainewa nutup gapan Iesu yoniwandin yaven. ");
INSERT INTO dgz_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Men anega wan, “Yawan, kiman watapen yavivin. Kimani viseni apanewa God mainewa nutup gapan yoniwan!” ");
INSERT INTO dgz_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Sitiven ap anega wani Diu nagirewa nop vero vero wane darinamu waboboran dagimen set tat wa tau amon Sitiven waran. ");
INSERT INTO dgz_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Okokok warupan tau amon pa sewa garip aipa uarenan gwara ton. Gwara toiwanumune nagirewa wanup muga aigapewa totnagen iraga yaoyao menan apan tamaru Sol pusip seane. ");
INSERT INTO dgz_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Gwara toiwanumune Sitiven God inap mup anega wan, “Ayop nega Iesu, guana wat.” ");
INSERT INTO dgz_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Wani omanip enu nop uma sia anega wan, “Ayop negawa, koewa muga anu ae ve.” Wani boge ae beure geare bop tan. ");
INSERT INTO dgz_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Sol waenapan tone boen ase yave anega wan, “Umap.” God menan pot pot anun taiwanumune apane wai upi irip turup bawarevet wan amba Sitiven etua tun. Wam ame Ierusalem gapan wa koeragam aritavet da Iesu dugup mega nagirewa inamup tane. Ap menan, Iesu dugup mega nagirewa iravi punanan waran at Diudia ge at Sameria amon go Iesu watu enamot mega aonagaet pusinawan dere mugenat Ierusalem gapan wanumon. ");
INSERT INTO dgz_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Apan Sol den Iesu dugup mega nagirewa gut okonak mumiwandini. Pa pa iragi tau ge tau ae waenapan upe okonage ae gwat nokap semuiwandin. ");
INSERT INTO dgz_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Iesu anu tumasine nagirewa da da punanan wat amone nagirewa at at Iesu oisewa wadidiam wanumun. ");
INSERT INTO dgz_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ap gapan den, Pilip at Sameria gapan pa bawarewa ame vit ae Keriso oise wadidiam wandin. ");
INSERT INTO dgz_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Pilip nop amunu den ge yo ugup ugup taiwandini menan waenapan keam ton yaviwanumun. ");
INSERT INTO dgz_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Yo ame taiwandin gapan airampu no yani den waenapan potap tap tau amuiwanumun, ge pusi gegerawa amba etumu gwade waniwa inak waran ap amon. ");
INSERT INTO dgz_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ap menan at Sameria gapan inak ame yawane waenapan ni gwane ao tan aton tane. ");
INSERT INTO dgz_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Wam ame gapan, at Sameria gapan, apan da yaua Saimon, banao pa sewa ame gwanap taiwandin. At Sameria nagirewa yawan seke tan no i kap waiwanumun. Saimon mek ingane yaua wabawarame aritawa apane da wa taiwandin. ");
INSERT INTO dgz_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Waenapan iragi aigapewa ge gauarapewa nagirewa nop mega neman guran anune anega wane, “Apan Saimon mam, nu God nugawa, yaua Aro Aigap Iragenawa, kimani aoma viseni apanewa mame di.” ");
INSERT INTO dgz_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Me wam wam nuat mega taiwandini menan waenapan nomu i kap wan tarage waiwanumune amba me ewap di amuiwanumun. ");
INSERT INTO dgz_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pilip taue God toemu mega oisewa kakaewa amba Iesu guturewa den wadidiamon. Nop ame waenapan anu tumasene gapan mu dup iamon. ");
INSERT INTO dgz_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saimon mek ingane den Iesu anu tumat ta dup ien. Pilip ap aiwandini Saimon den tane aiwandin iwa Pilip yo kimani paua baware ugup ugup taiwandini Saimon yave no kap wan. ");
INSERT INTO dgz_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Wam ame at Sameria nagirewa God noa anu warane oisewa Iesu watu enamot mega nagirewa pa Ierusalem gapan anun. Ap menan mu Iesu watu enamot megawa dere Pita ge Dion watu enamone Sameria nagirewa inamup amon. ");
INSERT INTO dgz_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Wam ame mu tauanewa, Sameria anu tumat nagirewa munan mup wane ame Guewa Woup Seniwa inamup tauep warapen menan. ");
INSERT INTO dgz_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Iwa mu Iesu anu tumat tane amba Iesu yaua gapan dup iamon go Guewa Woup Seniwa aigamup ya visen. ");
INSERT INTO dgz_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Boge Pita ge Dion nanimu iamup seane amba mu Guewa Posewa Woup Seni warane. ");
INSERT INTO dgz_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Iesu watu enamot megawa dere ap anega tane gapan God Guewa yan muneni ame apan Saimon ase yaven. Menan Saimon aro ame warapen menan garewa munat anu, ");
INSERT INTO dgz_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","anega wadiamon, “Aro mame ne den nenane amba da da nanina iamup seapena mu Guewa Woup Seniwa den warain.” ");
INSERT INTO dgz_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Go Pita gare anega wan, “Ge evi amba moni gegawa den merao arewa age bogitai! Iwa ge God aro ma nuniniwa moni gapan une tat anuan! ");
INSERT INTO dgz_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ge nu den nao daitonawa da uon iwa ge inak gega God yamap ebo aopan no dotouen. ");
INSERT INTO dgz_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ma koewa gega entan tapen anua, God inap vetavet ta, mup wa. Ayop, ge imuga koewa anuana, anu ae veta go uon, ne oare, ");
INSERT INTO dgz_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","iwa gek anu koeam tan sisiwa potagap no dotouen menan koewa panagen yavivin.” ");
INSERT INTO dgz_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Amba Saimon tap anu Pita ge Dion anega diamon, “Ayop inap nenan mup wa oitana koewa gat waana inanap ya tauep.” ");
INSERT INTO dgz_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Wam ame Pita ge Dion Ayop Iesu inak mega gapan dim dim ase yawane ame guturewa wadidiamone amba mu entanen pa Ierusalem sia amon. Mu sewa Sameria pa muga arugataet tau ge tau amon God No Oise Kakaewa opata gapan wadiam amuiwanumun. ");
INSERT INTO dgz_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Go Pilip ap mepe wandeni gapan, God anea mega da apan Pilip inap taue anega dien, “Negin Ierusalem ae Gasa taueni, at kaimewa negin ap me ak.” ");
INSERT INTO dgz_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Boge me ao yone neginaet aiwandin eni at Itiopia gorowa apane da tautanen. Apan ame, at Itiopia ayop mugawa waenewa yaua Kandasi, ame moni mega kwayupe taini aritawa muga yonen. Me God inap mup wapen men Ierusalem aen. ");
INSERT INTO dgz_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Aeni ame ewagai sia entan neginaet pimai mega man osi warupiwanumune ame gagap wande aiwandin. Buka da watageta apane Aisaya God nop mega ok seni ame batnak aiwandin. ");
INSERT INTO dgz_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Amba God Guewa Pilip anega dien, “Age pimai gagap amoine ase mainep mainep agingan.” ");
INSERT INTO dgz_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Boge Pilip serarat ae osi pimai warupiwanumune ame ine taueni apan gorowa ame watageta apane Aisaya buka mega batnak wandin anun. Menan Pilip anega wayaven, “Ge ok ame batnagingiana iwa anuingi go uon?” ");
INSERT INTO dgz_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Itiopia apanewa gare anega wan, “Ne anenen anu awain, go orup da guegue mega wadianegepiwa, ne iwa mega anu awain.” Ap wani boge, Pilip dore pimai mega gagap dere wanumopen menan wan. ");
INSERT INTO dgz_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Boge apan gorowa ame God no oise seane koni da anega batnagiwandin, Me man sip togurapen amoine mini, ge man sip otua gume ketnagiwanumune gapan, no uon wandini mini, me nop da daiton ya wan. ");
INSERT INTO dgz_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Me inap ta koeamene umame anun, amba mu wanene eboewa gapan tane go me no uon wanden, Me inak mega piup ma gapana uon tani menan, naewa mega da uon. Ap menan me oisewa waenapan da wadidiamuiwandata. ");
INSERT INTO dgz_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Amba gorowa apane ame Pilip singui tayaven, “Endi wadianek apan Aisaya ma da nop mega waiwan, mek menan waiwan go orup da menan waiwan?” ");
INSERT INTO dgz_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Amba Pilip boge Aisaya nop mega ame uap sia wadien ge nop oit kakaewa gapan Iesu oisewa den wadien. ");
INSERT INTO dgz_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Pilip ge gorowa apan ame neginaet amoin ene kaum da tauane, apan gorowa ame anega wan, “Kaum da ma yao, kaum ma gapan dup ianek ianek anenen?” ");
INSERT INTO dgz_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Pilip gare wadien, “Ge imuga potaga God anu tumasewa ne dup iagain.” Goroa apane gare wan, “Iesu Keriso God Otua di, ne anu tumasivin.” ");
INSERT INTO dgz_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Boge man osi pimai mega warupen gagap amuiwanumune wan ae yonan. Ame Pilip ge gorowa apane ap mepe ae vitan kaum amon, boge Pilip gorowa apane ame ware dup ien. ");
INSERT INTO dgz_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Wam ame mu kaum ae vean amba kwatata ae ma dotouane, ame gine tutup God Guewa aroewa gapan Pilip wat oagasen, menan gorowa apane Pilip da sia ya yaven go me neginaet atonu den aen. ");
INSERT INTO dgz_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pilip ap mepe oagaeni boge at ugupewa yaua Asidot ap mepe ase matagaen amba ap ta God No Oise Kakaewa opata gapan pa sewa sewa iragi wadiam wadiam aeni amba at Sisaria tauen. ");
INSERT INTO dgz_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Pa sewa Ierusalem gapan apan Sol Iesu anu tumasine nagirewa guramopen menan tue ene waiwandin. Me pirisi ayop mugawa ine aen. ");
INSERT INTO dgz_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Aro warapen ogewa ware amba at Damaskas aepen menan mupe wan. Ok ame wapi gapan Iesu anu tumasine nagirewa, waen ge apan ap mepe wanumopi damiga panamo ai okonak pa Ierusalem ewagai entan onapen menan aen. ");
INSERT INTO dgz_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Menan Sol entane Damaskas di aiwandin eni amba pa maniwandini gapan, menawaet kiman ganasewa gamup enun, ine maine iragi ganase wan. ");
INSERT INTO dgz_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Kiman ganat ewa enuni Sol man osi gagap onana pia gearen nop da inap anega tauen anun, “Sol, Sol, ge dimen ta koeragam nimanegingi?” ");
INSERT INTO dgz_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sol gare singui wan, “Ayop, ge da?” Amba nop ame anega sia tauen, “Ma ne Iesu ta koeragam nimanegingi. ");
INSERT INTO dgz_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Endi ao yon pa Damaskas ak, ap mepe apan da dim da tapen menan wadiageta.” ");
INSERT INTO dgz_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Tanam amone apane wai yonan kiman ganasewa yawan ununke anun go mu no gwade wan. Nop wani anune go nop da wani tavewa ase ya yawan. ");
INSERT INTO dgz_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol piupa ao yone yangut tapen tani, go yamewa borasen. Evene wai nanip waran amon pa Damaskas tauan. ");
INSERT INTO dgz_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Sol yamewa wam yampoa boraseni wanden ap wamewa gapan kaum ge taba da ya naiwandin. ");
INSERT INTO dgz_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Iesu wadiamot mega da yaua Ananayas at Damaskas gapan wande en. Bet ine gapan Ayop Iesu yaveni, amba Iesu anega wan, “Ananayas.” Me gare wan, “Ne mam, Ayop negawa.” ");
INSERT INTO dgz_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Wani Ayop Iesu sia wadien, “Ge ao yon, negin da yaua Tamanawa ak. Apan Diudes paewa gapan Sol, at Tasas apanewa, age yop ta. Sol endi God inap mup waiwan. ");
INSERT INTO dgz_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Me bet ine manega yaven, apan Ananayas ine tauep, yame boraseni watapep yangut sia tapen menan naniwa iap barae mup wan.” ");
INSERT INTO dgz_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananayas Iesu nop mega anuni gare wadien, “Ayop negawa, apan Sol ame waenapan gega at Ierusalem gapan kaimakaet ta koeragam mumiwandini oisewa apan arugataet wadianegene anun. ");
INSERT INTO dgz_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Mapa Damaskas tauen pirisi bawarewa aro waneni gapan inagap anu tumat taintoni taunepen menan tauen.” ");
INSERT INTO dgz_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Iesu gare Ananayas dien, “Sol nao nega arita da tapen menan ne om enun. Ap menan ge di ak. Me Diu ian ugupe nagirewa amba mu ayop mugawa den amba at Isurero nagirewa oitana wadidiamota. ");
INSERT INTO dgz_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nenan ugu vegaek bagu sisi baware anupi nek wa ewatain.” ");
INSERT INTO dgz_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Menan Ananayas aeni boge apan Diudes pa mega taueni me naniwa Sol iap baraeni ap anega wan, “Sol, apan negawa, Ayop Iesu watu enanegen. At mame ongingiana gapan, me apan negina yawaanawa daiton ameme di. Me watu enanegen menan ge yangut sia tapen amba Guewa Posewa Woup Seni potagap no dotouepen menan tauan.” ");
INSERT INTO dgz_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Wani boge meo epi yarewa mini Sol yamewa gapan tot tat wa geamone me sia yangut tan. Ao yoneni Ananayas Sol Iesu anu tumat dupewa gapan ien. ");
INSERT INTO dgz_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Sol taba nani gapan aro mega sia tauen. Sol aro wareni ewap, me at Damaskas gapan wam agiap Iesu anu tumat taine nagirewa ap mepe tanamo wande en. ");
INSERT INTO dgz_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Wam ame gapan me opata ere Diu opata waine paewa gwanap, anega wadiamon, “Iesu me God otua di.” ");
INSERT INTO dgz_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Mu da iragi me wan anunewa tarak anega wane, “Apan mame pa Ierusalem gapan Iesu anu tumasine nagirewa enu girigam mume taiwandini apanewa go? Me mapa taueni iwa mega mu tambumo ae pirisi bawarewa munep gwat noke gapan seat anu tauen go?” ");
INSERT INTO dgz_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ap anega wane go Sol aro ta opata di waiwandin. Me opata gapan aigap di ewamuiwandini ame Iesu me God om enuni apanewa Keriso di. Diu pa Damaskas wanumuine nagirewa nop gare wapen tane go umap uon. ");
INSERT INTO dgz_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Wam aruga taue ewagai aeni ewap, Diu nagirewa Sol to boniga baraet anun menan nop panan. ");
INSERT INTO dgz_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Mu Sol menan mum wam pot poraet togurapen menan pa sewa sin gapan tonana Sol menan nauase taiwanumun. Go Sol omine wane oisewa anun. ");
INSERT INTO dgz_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Mum da Sol kaenat gwanap unugen damik panan amba wadiamot megawa pa sewa Damaskas sin garip kaenat ame damigewa gapan enuanane vise tau aen. ");
INSERT INTO dgz_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sol pa Ierusalem aeni Iesu wadiamot mega nagirewa intum tamot anun, go mu iragi tawa tane, iwa mu Sol Iesu anu tumaseni oisewa da mu ya anu tumasene. ");
INSERT INTO dgz_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Go apan da yaua Banabas, Sol ware Iesu watu enamot megawa ine nau tauen. Taueni amba Banabas Sol gutut mega anega wadiamon, “Sol ap daio Damaskas negina aiwandini gapan Ayop Iesu ire yaveni amba Iesu me inap nop dien. Evi amba Sol pa Damaskas gapan Iesu oisewa epara ta wadidiamon.” ");
INSERT INTO dgz_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Banabas ap anega wani menan Sol tanam wanden pa Ierusalem gapan ise ase momonagaet yone iwandin amba Iesu oisewa eparae den wadidiam wandin. ");
INSERT INTO dgz_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Sol nop kaimakaet Diu ame Gurik noa waine nagirewa den tanamo gare gare waiwanumune, go mu togurep boet anun di taiwanumun. ");
INSERT INTO dgz_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Tot wan tane oisewa Iesu anu tumasine nagirewa anune menan mu Sol waran vit amon pa Sisaria tauan amba Sol watu enane at Tasas aen. ");
INSERT INTO dgz_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Wam ame gapan Iesu dugup megawa ikukuk wanumunewa at Diudia, Galili amba Sameria iragi nonup gapan wanumen. Ap gapan Guewa Woup Seniwa aroe muneni gapan paua muga kai ware doren amba Iesu viriwa taiwanumun. ");
INSERT INTO dgz_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita at da da daio tan. Wam da God waenapan mega pa Lida gapanawa inamu den daio aen. ");
INSERT INTO dgz_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Apan da yaua Aeneas tautanen, me dai tanen eragi gagap aup parata iniwandini en mega nani yamunaet nani yamu yampo wande en. ");
INSERT INTO dgz_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pita apan ame anega dieni, “Aeneas, Iesu Keriso wat inakam gimagiwan. Ao yon eragi gega pait,” boge Aeneas menawaet ao yon wanden. ");
INSERT INTO dgz_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Waenapan aru ame pa Lida ge Saron gapan wanumuinewa, inak ame yawan boge imu pose wat entanen Ayop anu tumasene. ");
INSERT INTO dgz_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Pa da ame yaua Diopa ap mepe Iesu wadiamot waenewa da yaua Tabita (ian Gurik yaua muga gapan ame Dorokas diane) me inat wandet mega kakae iragen wanden. Me waenapan purapuse uoni ame ago tamuiniwa. ");
INSERT INTO dgz_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Koni ame gapan me vek waren boen, etua bigi ton pa diri gagap tune ame aigapewa gwanap baraene wande en. ");
INSERT INTO dgz_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Pa Lida ae Diopa taueni ame konintu di, nononga uon. Ap menan pa Diopa Iesu anu tumasine nagire, Pita pa Lida gapan wandeni oise anun, menan apan dere sep watu enamon amon Pita anega diane, “Mek menawaet ao yona nunan mapa di tau.” ");
INSERT INTO dgz_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ap menan Pita oit ame anuni yone tanam di aen. Pa ame taueni wat naun pa aigape ame gwanewa dot amon. Pa ame gwanewa unugeni waen kwapura mugenataet tauan nau panan irip turup waiwanumune, Tabita kabani wandeni gapan en wapagin etumu okome taginam muneni ame tambun Pita ewasene. ");
INSERT INTO dgz_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pita waen ame wa oimon tauan garip amone, me omanip enu God inap mup wan. Boge waen boe wandeni inap entane anega wan, “Tabita ao yon wanik,” boge waen ame yame emeramen, Pita ao yaveni boge yone nip endaven. ");
INSERT INTO dgz_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pita waen nanip ao waren yon wanden. Pita Iesu anu tumasine nagirewa ge waen kwapura ame munan wan tauan, waen boeni ame sia inakaeni ewamon. ");
INSERT INTO dgz_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Pita ame tani oisewa at Diopa iragi senare tau aen amba waenapan anune boge Ayop Iesu anu tumasene. ");
INSERT INTO dgz_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pita wam agiap da pa Diopa gapan man epi getaven darakamini apane da yaua Saimon dere inane. ");
INSERT INTO dgz_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Pa Sisaria gapan ap mepe apan da yaua Konilias iniwandin. Me Rom ita nagirewa arita mugawa at Italia gapan. ");
INSERT INTO dgz_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Me God menan pot pot anu taiwandini gapan dugup mega den God wa taragasiwanumun. Kayakayawan nagirewa wat agoat mumiwandin amba pot pot me God inap mup waiwandin. ");
INSERT INTO dgz_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Wam da, wam airase yampoa wareni gapan me bet ine God anea mega da aroga pa unugiwandini yaven. Anea anega dien, “Konilias!” ");
INSERT INTO dgz_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Boge Konilias tap tan, kem kem yaviwandini gare singui anega wan, “Ayop, dim da?” Anea ame gare wan, “Ge mup gega waingian amba kayakayawan nagirewa wat agoat mumingiana ame God yao anu gimagiwan ap menan ge garaet gega genapen taiwan. ");
INSERT INTO dgz_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Menan endi ge apan da watu enamo pa Diopa amo apan da yaua Saimon Pita wat onamop. ");
INSERT INTO dgz_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Me man epi getaven darakamini apane dawa yaua Saimon den wandiwan. Pa ame puiman etop tun.” ");
INSERT INTO dgz_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Nop ame dieni gapan anea boge ae ve aen. Konilias nao mega apanewa dere amba ita apanewa daiton munan wan tauan. Ita apane God menan pot pot anu taiwandini apanewa, Konilias inap ayamase kaimakaet di tainiwa. ");
INSERT INTO dgz_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Me dim dim iragi inap venaseni oisewa wadiamon amba watu enamon pa Diopa amon. ");
INSERT INTO dgz_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Inane woup sen, wam ianupe wareni mu ap wandap amon amba pa sewa Diopa maniwanumune, ap wamewa gapan, Pita pa aigarip mup wapen dot aen. ");
INSERT INTO dgz_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Mup waiwandini enup aren nat anun. Go pa gwanap antaba ewake wat iriwanumune. Ame gapan Pita bet ine manega yaven. ");
INSERT INTO dgz_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Me kiman watapen ao yaven amba yawat mega wanup baware da mini ginewa degede en memegamen aoma piupa visiwandini yaven. ");
INSERT INTO dgz_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Wanup ame gwanapewa man tap gine ugup ugup, ame wariwa ge mokare den gine ugup ugup amba nenip gine ugup ugup wanumone yawamon. ");
INSERT INTO dgz_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Boge nop da kiman gapan anega wadien, “Pita, ao yona, gut na.” ");
INSERT INTO dgz_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pita gare wan, “Ayop ame umap uon! Ne antaba koeragewa ian ugupe nagire mugawa iup gega topaitapena tawa menan ne ya nainawa.” ");
INSERT INTO dgz_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","God sia wan, “God taba dim dim da kakae diamoni ge koerage ya dia.” ");
INSERT INTO dgz_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Mame koni yampo venaseni amba wanup ame ene wabore ewagai kimani sia aen. ");
INSERT INTO dgz_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pita bet ine yaveni ame tavewa dim da menan anu waramase wande anuan sese taiwandini newap Konilias watu enamoni apan yampo Saimon pa mega yoa tan, wa ewamon, tauane pa tonana yonan. ");
INSERT INTO dgz_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Mu yonane singui wan, “Daio apane yaua Saimon Pita mapa iniwan go?” ");
INSERT INTO dgz_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pita wande bet ineni ame tavewa dim da menan anuan sese taiwandini gapan Guewa Woup Seniwa anega wadien, “Saimon, apan yampo yoga taiwanum. ");
INSERT INTO dgz_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ao yon vit ak. Mu tanam agepen menan gego ya anu iwa ne watu enamon.” ");
INSERT INTO dgz_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","God Guewa wani menan, Pita vit ae amba apan ame anega diamon, “Yoa taiana apanewa ne mame. Iwa dimen ma onayan?” ");
INSERT INTO dgz_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Mu gare anega wan, “Ita apanewa Konilias watu enanen tauaton. Me apan kakaewa, God wa taragasiniwa amba waenapan iragi me viriwa tainewa. God anea mega da Konilias wadieni menan nu ge nauge pa mega anet, amba ge nop dim da wawa me anupen menan wan.” ");
INSERT INTO dgz_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Boge Pita apan ame upamo pa mega gwanap semon inane. Inane woup sen, mu Pita upan den nau amon amba Iesu dugup mega nagirewa upi pa Diopa gapanawa mu den tanam amon. ");
INSERT INTO dgz_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Wam ame amuin en inane, sia amon at Sisaria tauan. Ap mepe Konilias amba dugup mega evene wai den munan wani tauan, amase taiwanumun. ");
INSERT INTO dgz_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pita pa unuk aepen taiwandini Konilias tautane namup geare wa taragasen. ");
INSERT INTO dgz_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Go Pita nanip ao ware anega wan, “Ao yon, ne den apan iragen di, ne bawarewa uon.” ");
INSERT INTO dgz_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Amba mu dere nop waiwanumune pa unuk amone amba Pita waenapan aruga ame to iam tan wanumone yawamon. ");
INSERT INTO dgz_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pita mu anega wadiamon, “Nu Diu gutut nuga e anuiwanin. Diu uon ian ugupe nagirewa den union ya waninait, pa ega daio ya anait. Go endi waenapan da imumu koevet ya diaepen menan God ewanegen. ");
INSERT INTO dgz_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ap menan nenan wayan ne tanda ya wan boge di ongen. Go endi ne singui wayawaivin, e sepana dimen watu enamoyan?” ");
INSERT INTO dgz_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Konilias gare wan, “Wam degede taue ewanup aeni gapan wan airase yampo, ma miniwa, ne pa nega gwanap mup taingina apan da wanup mega ganase den namunap yone ");
INSERT INTO dgz_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","amba anega wan, ‘Konilias, God mup gega anun amba kayakayawan taine nagirewa wat agoat mumingiana ame yawage anun. ");
INSERT INTO dgz_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ap menan sep nagire ame pa Diopa watu enamo apan Saimon ame yaua dawa Pita nau onamop. Me man epi getaven darakamini apane dawa yaua Saimon ame pa mega puiman etop iniwan.’ ");
INSERT INTO dgz_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Menan ne sep gine tutut genan watu enan, amba ame ongeana kakae di. Ap menan endi nu iravi ma mepe God namup iam iam taivin amba Ayop nop wadiageni ame nu wadiane anut anuivin.” ");
INSERT INTO dgz_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pita opata ere manega wan, “Ne endi di anu kakayasivin ame God yamap waenapan iragi gine daiton di. ");
INSERT INTO dgz_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Piup at at iragi gapan waenapan da da God wa taragasepi nop mega ayamase ta amopi God waupamota. ");
INSERT INTO dgz_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","God oit mega Isurero nagirewa inamup watu eneni e asik tayan. Oit kakaewa ame Iesu Keriso tani menan God baigananu tani anuton. Ap menan Iesu wan dim dim iravi Ayopewa. ");
INSERT INTO dgz_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","At Diudia gapan dim da venaseni e anuiwanin, ame namu at Galili dup iamopen oisewa Dion opata gapan waiwandini amba ");
INSERT INTO dgz_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","God anenen da Iesu at Nasaret apanewa Guewa Woup Seniwa aroewa gapan uriri tan, amba Iesu yone at at iravi nao mega kaimakaet taiwandin amba da da Seitan nani gwanap wanumuine nagirewa wat inakam mumiwandin, iwa God me den inap wande en, ame iravi e anuyan. ");
INSERT INTO dgz_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Iesu pa Ierusalem amba pa ugup ugup den nao taiwandin yavintoni oisewa waivin. Amba mu oma korosi gapan tobatamen endawane boen, ");
INSERT INTO dgz_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","go wam yampoa gapan God wan me inakae sia yon wanden, ame tani ewap Iesu waenapan inamup taueni yawane. ");
INSERT INTO dgz_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Waenapan iragi ya yawane, go God gaset om enunen Iesu boe sia yon wandeni ewap taba kaum den natoni nagirewa nugenat yawaton. ");
INSERT INTO dgz_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","God nu Iesu oisewa kakaewa waenapan at at iragi wadiamopen dianen amba God daiton me Iesu om enuni ame kabaniwa ge borit wane nagirewa wanene tamopi oisewa God wadidiamopen dianen. ");
INSERT INTO dgz_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Watagaet God no oise waiwanumune nagirewa me guturewa manega wane, da da Iesu anu tumasepiwa me gamup God koewa muga anu ae veta.” Pita ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita nop opata waiwandini gapan, opata anuiwanumune nagirewa Guewa Woup Seniwa aigamup visen. ");
INSERT INTO dgz_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Pita, at Diopa gapan tanan onamone Iesu anu tumasine ian Diu nagirewa, nomu i kap wan. Iwa Guewa Woup Seniwa God garaet Diu nagirewa muneni endi ian ugupe aigamup wagemeni yawane menan. ");
INSERT INTO dgz_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Amba Guewa aroewa gapan mu merimu tobayanen ian ugup ugup nop muga wane amba God wa atonasiwanumune, Diu nagirewa anun. Menan Pita anega wan, ");
INSERT INTO dgz_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Waenapan mam, nu umanup God Guewa potamup tauen. Ap me menan iragi kaum gapan dup iamopen menan da watanamota?” ");
INSERT INTO dgz_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Wani Iesu yaua amun mega gapan dup iamopen diamon. Dup iamone amba pa nagirewa Pita wam upi den ap mepe wanumot wane. ");
INSERT INTO dgz_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ian ugupe nagirewa God nop mega den anu tumasene oisewa Iesu watu enamot megawa amba anu tumat taine nagirewa at Diudia gapan oisewa ame anune. ");
INSERT INTO dgz_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Menan Pita Ierusalem aeni. Ap mepe epimu tum aramon anu tumat taine nagirewa Pita diguran anega wane, ");
INSERT INTO dgz_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Ge age apan epimu tum ya aramoni nagire ame tanamo pa muga gwanap taba den naan!” ");
INSERT INTO dgz_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pita tavewa di wan dim dim taiwandini venat musiwanumune ame oisewa ere anega wadidiamon, ");
INSERT INTO dgz_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Ne pa sewa Diopa gwanap mup taingina, ame gapan bet inan yawan. Ne yawana ame wan dim dim baware da wanup mini pepeta kimani en memegamene, viseni ame ginewa degede den enuanene. Visiwandin ne amba wanigena arewa gapan tauen. ");
INSERT INTO dgz_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ne gwanewa yangut tan yawana ame man tap puawa gine ugup ugup, ame wariwa ge mokare den gine ugup ugup amba nenip gine ugup ugup wanumone yawamon. ");
INSERT INTO dgz_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Kiman gapan nop da inanap taueni anega anun, ‘Pita, ao yon, gut na.’ ");
INSERT INTO dgz_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ne gare anega wadian, ‘Ayop, ame umap uon! Ne antaba koeragewa ian ugupe nagire mugawa iup gega topait tapena tawa menan ne ya nainawa.’ ");
INSERT INTO dgz_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Nop sia kimani taueni anega wan, ‘God taba waenapan dim dim da kakae diamoni ge koerage ya dia.’ ");
INSERT INTO dgz_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Mame koni yampo venaseni amba wanup ame ene wabore ewagai kiman sia dot aen. ");
INSERT INTO dgz_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Wanup kimani sia dot aeni gapan, apan yampoa pa sewa Sisaria gapan nenan watu enamone ne pa ambagan wanigena ap mepe tauane. ");
INSERT INTO dgz_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Mu Diu uon, go ian ugupe nagirewa. Ne gego ya anupen menan, God Guewa anega wadianegen, ‘Tap ya anu mu den di tanam ak.’ Pa Diopa Iesu anu tumat nagirewa nani yamu daiton mame ne den tanam aneton. Anetoni pa sewa Sisaria tauaton amba Konilias pa mega iravi unugeton. ");
INSERT INTO dgz_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Unuk anetoni, Konilias gutut mega wadianen. Anea da pa mega taueni me yaven. Anea anega wadien, ‘Sep nagire ame pa Diopa watu enamo, apan Saimon ame yaua dawa Pita nau onamop. ");
INSERT INTO dgz_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Me nop enan wa tauepi ame gamup e ge dugup egawa den iragi inak warai.’ ");
INSERT INTO dgz_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ne tauan nop ere watapan waingina gapan, Guewa Woup Seniwa nu potanup taueni ap umap Diu uon go ian ugupe nagirewa potamup den tauen. ");
INSERT INTO dgz_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ame gapan ne Iesu namu wadianeni anu awan, me anega wadianen, ‘Dion waenapan kaum gapan dup iamon, go e Guewa Woup Seniwa gapan dup iai.’ ");
INSERT INTO dgz_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","God yan garaet ta nuneni mini ame gine daiton ian ugupewa munen. Ne God nao mega anenen watanain, ame umap uon!” Pita ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Mu Pita gutut mega anune gapan imumu entanen amba aigap sia ya diguran go God wa atonasene anega wane, “Tavewa di, God ian ugupe nagirewa koewa muga veta veta imumu entanepen inak ewake warapen menan neginewa tun!” ");
INSERT INTO dgz_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Mu apan Sitiven togurane wamewa gapan Iesu dugup mega nagirewa ta koeragam muman at at punanan wat amon. Amone upi at Ponisia, Saiparas, amba pa Antiok den tauan Iesu oisewa Diu nagirewa mugenat wadiam wanumun, ian ugupe nagire den ya wadidiam wanumune. ");
INSERT INTO dgz_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Go upi at Saiparas ge at Sairini Iesu anu tumasine nagirewa punanan wat amone pa Antiok tauan Ayop nuga Iesu Keriso oisewa Diu uon go ugupe nagirewa den wadidiamon. ");
INSERT INTO dgz_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","God aro mega muneni gapan waenapan aruga nop muga anu tumasen, Ayop nuga Iesu inap imumu entanen. ");
INSERT INTO dgz_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Pa Antiok nagirewa imumu entanene oisewa Iesu dugup mega pa Ierusalem nagire anune menan apan Banabas mu inamup watu enane. ");
INSERT INTO dgz_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Pa Antiok taueni, God waenapan wat aipakam mumiwandin yaveni menan aton anun. Amba Banabas mu iragi dadak munen anega wadiamon, “Ayop Iesu inap imuya potaya iragi gapan di wat nasiwaniampen, nop mega wariwanian.” ");
INSERT INTO dgz_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabas me apan kakae anu tumat ge Guewa Woup Seniwa me potap no dotouen amba waenapan paua arugataet Ayop inap naumo aen. ");
INSERT INTO dgz_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Amba apan Banabas, Sol yoa tapen menan at Tasas aen. ");
INSERT INTO dgz_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Yaveniwa, me wat nau pa Antiok ewagai onen. Banabas ge Sol, ap mepe dere, en daiton gapan Iesu dugup mega nagirewa den wanumon amba waenapan aruga wadidiamon. At Antiok gapan Iesu dugup mega nagirewa namu yaua Kuristian diamon. ");
INSERT INTO dgz_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Wam mame gapan, God no oise waine nagirewa upi pa Ierusalem gapan pa Antiok amone. ");
INSERT INTO dgz_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Apan ap me da yaua Agabas. Me ao yone amba God Guewa aroewa gapan evi venasepen noa namu anega wan, “Wankakao baware da konintu at at iravi tau aeta.” (Wankakao mame venaseni Rom nagirewa ayopewa Kolodias ayop ta wandeni wamewa gapan tauen.) ");
INSERT INTO dgz_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Nop evi venasepen namu wani menan, Antiok Iesu dugup mega nagirewa ago muk anut muga muga gapan moni bongamen, at Diudia gapan inine nagirewa garaet munat anun. ");
INSERT INTO dgz_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ap menan, Antiok Iesu dugup mega nagirewa mame di tane, moni bongamene Banabas ge Sol munane amba Diudia Iesu dugup mega namu yo yo nagirewa munapen menan mu tam amone. ");
INSERT INTO dgz_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Wam ame gapan ayop Erot Iesu dugup mega nagirewa upi wa koeragam mumen. ");
INSERT INTO dgz_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Me wani gapan ita nagirewa Dion tasewa Diemis waran tuma engurane boen. ");
INSERT INTO dgz_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Erot ap tani gapan, Diu nagirewa aton anune, me ap yaveni menan ita mega nagirewa Pita to warapen diamon. Mame tane wamewa ame Taba Buredi Tutut Ya Waini Baripewa gapan, yaua dawa ame Paina Yamaseni Baripewa. ");
INSERT INTO dgz_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ita nagirewa Pita waran gwat nokap baraen. Ap mepe ita nagirewa i degede tomagen apan degede yon ge yon amon Pita amase taiwanumune. Paina Yamaseni Baripewa tugup uon tapi ewap, ayop Erot Pita ware aroga baraep Diu nagire togurapen menan munat anun. ");
INSERT INTO dgz_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ap menan Pita wat nasen gwat noke gapan di wande en, go Iesu anu tumasine nagirewa Pita menan wam wam mup dandamunagaet God inap waiwanumun. ");
INSERT INTO dgz_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Mum ame woup sepiwa gapan, ayop Erot Pita Diu nagire munat anun. Go muma Pita God Paewa tonana yonine apan dere yaumakamup aup iniwandin. Damik kaimake dena gapan naniwa yamu yamune ita nagirewa nanimu den panamone amba gwat noke tonanewa God Paewa tonana yonine nagirewa upi ap mepe amat taiwanumune. ");
INSERT INTO dgz_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Wanumone menawaet ununke uon da, Ayop anea mega taue ap mepe yonen, amba ganasewa gwat noke en ganatamen. Anea Pita onewa gapan to kandase amba anega dien, “Serarat, ao yon.” Wani boge Pita nanip damik panane butut batat wa geamone. ");
INSERT INTO dgz_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Anea Pita sia dien, “Pusiga okome en, wanup gega den pan.” Pita ame tani anea sia wan, “Wanup gega aigapewa den wat en ewanap onak.” ");
INSERT INTO dgz_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pita gwat noke ae ve taue anea ewap aen. Anea anenen taiwandini, Pita me da ya anu aven, anuni me bet ine yaviwandat anun. ");
INSERT INTO dgz_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Tonan amase taine nagirewa garawat garawat amone amba uiwa tonan intanigaet gware denawa ame watapane pa sewa arige gapan amon. Tonan ame mek ingane watap munen, amba mu tauan gwat noke paewa garip tau amone. Mu neginaet vit amuiwanumune gapan anea ame boge Pita ae ve oagaen. ");
INSERT INTO dgz_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Oageni, Pita mek di anu anega wan, “Endi Iesu nenan tani tavewa di ne gwat noke garip tauan, bet inine mini da uon. Ayop Iesu anea da watu enen papat nega tan. Ayop Erot aro megawa amba Diu nagirewa inanap tat anune den ne ya yawapen menan anea ta warit nimanegen.” ");
INSERT INTO dgz_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Wam ame Pita anu aveni menan me Dion, yaua dawa Mak inewa Meri pa mega aen. Pa ame gapan waenapan arugataet tobot tan Pita menan God inap mup waiwanumun. ");
INSERT INTO dgz_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pita tonana ken ken toiwandini, amba nao waenewa da yaua Roda tonan watapapen menan tauen. ");
INSERT INTO dgz_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Taue, Pita noa ire anu daramu wan, aton tan waenapan wadiamopen menan entane use sia aen go tonan ya watapen. Me anega wadiamon, “Pita tonana yoniwan!” ");
INSERT INTO dgz_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Anune go manega wane, “Ge iaga bambamaen waingi!” Go waen nop mega tavewa menan aigap aigap wa ge wa di taiwandin. Menan pa nagirewa anega wan, “Apan tonanawa, Pita uon, go ame anea mega kwayup tainiwa tauen taiwan.” ");
INSERT INTO dgz_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Go Pita tonana ken ken nonongataet di toiwandin, menan mu tonan watapan yawane nomu i kap wan. ");
INSERT INTO dgz_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pita mu nop ae veapen menan naniwa gapan ta ewamon amba Ayop anenen ta gwat nokap nau tau aeni oisewa wadiamon. Amba me anega wan, “Diemis ge Iesu anu tumasine nagirewa den oit ma wadiamon.” Pita ap wani boge ae vemo at da aen. ");
INSERT INTO dgz_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Inane woup seni, gwat noke amase taine nagirewa Pita gwat nokap dim da anenen tani menan anu waramasen amba yoa at at iragi taitamen. ");
INSERT INTO dgz_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ayop Erot Pita yoa taiwanumampen menan diamon. Mu yoa tain en da ya di yawane gapan Erot gwat noke amase taine nagirewa singui arugataet wayawamo amba mu gurep borit wapen menan wan. Amba Erot Diudia ae ve pa Sisaria taue wanden, wam koni otu da ap mepe wanden. ");
INSERT INTO dgz_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Wam ame den Erot pa Taya ge pa Saidon nagirewa inamup gari gangan naen menan ian ame iame Erot yave baigan tapen menan amon. Tauane namu Erot pa mega kwayup taini ayopewa yaua Balastas evenan tan amba imua waren. Ap tane amba ayop Erot namup tauan baigan tapen menan singuiasene, iwa taba muga Erot egak mega gapan wariwanumune menan. ");
INSERT INTO dgz_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Menan Ayop Erot baigan tapen wamewa om enuni gapan, ayop wanupewa mega wat ene amba ayop watat mega gagap ae wande waenapan inamup opata wan. ");
INSERT INTO dgz_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Opata wani gapan waenapan kaimakaet ve anega wane, “Anun, god da inanup waiwan, apan umanup mini da uon!” ");
INSERT INTO dgz_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ame gine tutup Ayop anea mega Erot to baimen gearen amba motamot posewa na ugunagene boge boen, iwa me God ya wa atonasen amba waenapan me God mini wa taragasiwanumune me ya watanamon. ");
INSERT INTO dgz_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Go God nop mega yaugai di senare tau aen. ");
INSERT INTO dgz_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Wam ame Banabas ge Sol ap muga Ierusalem amo tauan sia entan onamone apan Dion Mak den tanam amon. ");
INSERT INTO dgz_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","At pa Antiok gapan, Iesu dugup mega nagirewa gapan, upi wadiamot nagirewa amba upi God oise opata waine nagirewa. Upi mu yaumua mame, Banabas, Simion yaua dawa Epi Pumpuniwa apanewa, Lusias at Sairini apanewa ge apan Manaen ayop Erot gwep mega daitonawa, amba Sol. ");
INSERT INTO dgz_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Antiok Iesu dugup mega nagirewa God menan taba virip tan amba God wa taragasiwanumune gapan, Guewa Woup Seniwa anega diamon, “Ne Banabas ge Sol om enumon, nao munat anuna menan, mu nugut ma nenan.” ");
INSERT INTO dgz_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ap menan mu taba virip tane amba mup gapan nanimu iamup sean Banabas ge Sol watu enamone amon. ");
INSERT INTO dgz_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Apan dere ame, Guewa Woup Seniwa negin muga ta watu enamoni menan mu vit amone at Selusia tauan ap mepe kabum gagap dotouan, puiman topaneni at Saiparas amon. ");
INSERT INTO dgz_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","At ame gapan pa sewa yaua Salamis tauane, Diu nagirewa opata waine pa muga muga gwanap God nop mega opata wadidiamon. Dion Mak mu den ap mepe ago muga taiwandin. ");
INSERT INTO dgz_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Puiman topaneni ame ikukuk pa pa iravi daio amon amba pa Papos tauan. Ap mepe Diu nuat apane yaua Ba-Iesu tautanane (ian Gurik noa gapan Elimas diane). Me God nop mega tave uon waini apanewa. ");
INSERT INTO dgz_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ba-Iesu at ame ayop mugawa yaua Sogias Polas evenewa. Sogias me anut apane menan Banabas ge Sol inewa onamo God nop mega wadiapen menan nop watu enen. ");
INSERT INTO dgz_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Go nuat apane Ba-Iesu, watanamon. Me ayop mega Polas Iesu oisewa ya anupen menan watanen. ");
INSERT INTO dgz_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ap menan Sol, yaua dawa Pol, Guewa Woup Seniwa potap no dotoueni gapan, Elimas kem kem ase yave ");
INSERT INTO dgz_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","amba anega diguren, “Ge Seitan umapewa di! Ge inak kakaewa anavi megawa. Koewa ugup ugup ge potagap no dotouen amba pot pot waenapan wababayan mumingi. ");
INSERT INTO dgz_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Menan wapena anu, endi Ayop Iesu aroewa gapan yamaga boraseta amba wam animpo gapan ge yangut sia ya tai, wam ganasewa da ya di yawai.” Ap wani gine tutup sisip taue me yamewa aoma umasen, amba me orup da nanip wat nau amopen menan momak anuiwandin. ");
INSERT INTO dgz_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Wam ame dim da venasen piup Ayop mugawa, Sogias Polas yaveni amba anu tumat tan den no kap wan, iwa God oisewa anuni menan. ");
INSERT INTO dgz_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","At Papos gapan, Pol evene waiwa tanamo kabum gagap at Pampilia gapan pa sewa Poga tauane. Ap mepe Dion Mak ae vemo ewagai pa Ierusalem sia aen. ");
INSERT INTO dgz_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Pa Poga ve use amone at Pisidia gapan pa yaua Antiok Diu pura bawarewa wamewa gapan tauan. Ap menan Diu opata waine paewa unuk amon ae wanumon. ");
INSERT INTO dgz_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Apan Mosis iup namua seni ogewa amba wataget God no oise waiwanumune seane ogewa den batnagen. Uon tani ewap, pa ame kwayup taine nagirewa Pol ge Banabas singui wayawamon, “Tatan anega, waenapan dadak diamo diamo guturewa da inayap wandepi ame wane umap di.” ");
INSERT INTO dgz_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pol yone, waenapan nop ae veapen menan naniwa wadave amba anega wadiamon, “At Isurero waene apanewa amba e ian ugupe nagirewa da God wa taragasianawa, nop nega neman guran anun! ");
INSERT INTO dgz_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Nu at Isurero nagirewa God nuga omayan baewa at Idip wanumone gapan God om enumon amba Idip gapan naewa muga aruga tan. Mu aruga tane amba God aro mega gapan at Idip gapan naumo tau aen. ");
INSERT INTO dgz_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Tau amone, en apane dere (40) at kaimewa gapan iniwanumune koewa taiwanumune go God imu pose inamup ae bigaren. ");
INSERT INTO dgz_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","At Keina gapan God ian ugup ugupe nagirewa nani yamu dere gut momak mumeni amba waenapan mega Isurero nagirewa at Keina munen yon borane. ");
INSERT INTO dgz_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Mame tani aeni enewa iragi 450 gwanap venasen. Mame ewap, wa tamanam mumine nagirewa God om enumoni Isurero nagirewa kwayup tamopen menan munen. Ap aeni, God no oise waini apanewa Samuero wam mega tauen. ");
INSERT INTO dgz_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Samuero wam mega gapan, omayan baewa ayop muga bawarewa da endawapen mupe wane, menan God apan Kis otua Sol munen. Sol dugup mega yaua Bendiman apanewa, me Ayop en apane dere (40) ta wande en. ");
INSERT INTO dgz_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Watageta apane Sol ayop taiwandini go evi amba God wa totnagen amba apan Devit ayop muga tan. Devit oisewa God manega wan, ‘Apan Diesi otua Devit ne yao tanana ame nek bumaganapewa. Me evi amba wan dim dim ne tat anuina me tata.’ ");
INSERT INTO dgz_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Apan Devit ani sibabasi megawa ame God nunan wa agiaseni apane ge wat inakam nugawa, ame Iesu, God om enuni ware tauen. ");
INSERT INTO dgz_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Iesu tauapen tani namup, apan Dion waenapan at Isurero nagirewa iragi vetavet tapen opataewa wa amba dup iamuiwandin. ");
INSERT INTO dgz_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Dion nao mega uon tapen taiwandini gapan waenapan inamup singui anega wayawamon, ‘Ne da anu nimanek wanin? Apan amase taiana ne uon. Go anun, ewanap apan bawarewa da taueta go ne bawarewa uon. Ne ago otua ayop mega pusi okomewa vesini mini ne ap wat agoaset anun go ne umanap uon.’ ");
INSERT INTO dgz_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Tatan gwanin, Eibaraam otu tasinewa, amba ian ugupe God wa taragasiana nagirewa, wapena anun, Iesu inak ewakewa nunat wani oise kakaewa mame inanup tauen. ");
INSERT INTO dgz_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ierusalem wanumuine nagirewa mu arita mugawa den, nu inak nunini apanewa Iesu irewa ya yao anu kakayasene. Pot pot pura bawarewa gapan gapan wataget God no oise waiwanumune nagire seane ogewa batnagiwanumune go ya anu awane. Ap menan Iesu boepi oisewa wataget God nop mega namua gapan seane tavewa tauapen menan Iesu togurapen wan.” Pol ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Pol opata mega sia waiwandin, “Iesu koewa mega da ya tanan go mu di boet anun amba Ayop Pailat inap anega wane, ‘Ge togura boep.’ ");
INSERT INTO dgz_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ugup ugup iravi wataget God no oise namua gapan seane taitamene gapan Iesu etua oma korosi gapan aoma wa totnagen vitan amba wat amon dagupa baraen. ");
INSERT INTO dgz_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Go God wan Iesu inakae sia yon wanden. ");
INSERT INTO dgz_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Iesu inakae sia yon wandeni gapan, at Galili pa Ierusalem tanam amone nagirewa wam aruga inamup venasiwandin yaviwanumun. Waenapan ameme endi at Isurero nagirewa yawane oisewa wadidiam wanum. ");
INSERT INTO dgz_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Menan, nu endi God oise kakaewa ame wadiaivin. Oit ame God omayan bae nagirewa munat wa agiat mumeni nu mu naewa muga inanup tauen. Me wat inakam nimanini apanewa munapen menan manega wa agiat mumeni ta munen, ‘Iesu boepi ne wapen inakae sia yon wandeta.’ Ok da sia buka namua yaua Sam paup derewa gapan God Iesu menan anuni oisewa anega sen, Ge ne otunawa, amba endi ne ge mamaga entan nimanegeta. ");
INSERT INTO dgz_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Amba nop da sia buka namua gapan seane ame gapan God tavewa di wan Iesu bop gapan inakae sia yon wanden, go etua ya puakaeta. Ok ap anega sean, God anega wan, Watageta apanewa Devit wat aipakam, ge kiman kakae guragut nega me wanapen menan, wa agiasena ame iravi tavewa mega di e enain. ");
INSERT INTO dgz_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ap menan ok da sia, buka Sam gapan, aroga Iesu wat aipakam mega menan anega sean, Nao nega taini apanewa etua ya puakaepen menan dian. ");
INSERT INTO dgz_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Nop ame God wani Devit menan ya wan iwa Devit wam mega gapan God dim da anuni taitameni amba me boen. Boeni omae baewa den tune etua puakaen. ");
INSERT INTO dgz_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Go God wan Iesu ao yon wandeni etua ya puakaen. ");
INSERT INTO dgz_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Ap menan, waenapan negawa, nop mame di anu kakayasen ame God Iesu gamup koewa nuga anu ae veapen oisewa opata gapan wadidiaivin. Wataget apan Mosis iup namu seni gapan koewa nuga garewa ya musen go Iesu anu tumasetoni menan God koewa nuga wat musen. ");
INSERT INTO dgz_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","God oise waiwanumune nagirewa wane ame inayap tauepi tawa menan amat ek ingane di tan. Mu anega wan, ");
INSERT INTO dgz_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Yawan, e nipep waiana, wapena anun. E God aroewa yawane no i kap wap, amba tavewa da ya yawai go mondi borit wai, iwa ne wan dim dim da baware di tapen taivin, go e ya anu tumat tai. Apan da ne tana oisewa wadiaepi, go den e ya anu tumat tai.” ");
INSERT INTO dgz_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pol opata mega uon tani, Banabas dere Diu nagirewa opata waine paewa ae vean tau amuiwanumune gapan Diu ge ian ugupe nagirewa da God wa taragasine anega wan, “Wam pura bawarewa utat sia onaen nop ame sia wadianen.” ");
INSERT INTO dgz_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Wam ame waenapan to iamen wanumone yap marimen amon, Diu nagirewa amba Diu uoni go Diu guegue muga taine nagirewa aruga Pol ge Banabas ewamup amon. Menan Iesu watu enamot megawa dere ame waenapan God garaet mega gapan wanumopen menan aigap wadidiamon. ");
INSERT INTO dgz_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Pura ame use aigapewa pa sewa ame gapan iragi tobot tan iamen, Ayop nop mega anut wan tauan. ");
INSERT INTO dgz_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Wam ame Diu nagire to iam baware ame yawane da di anu koeam mumane ap menan Pol dim da waiwandini mu nipep waiwanumun. ");
INSERT INTO dgz_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Go Pol ge Banabas tumban amu yonan nop aigap sia kaimakaet anega diamon, “God nop mega e inayap namu wadiaeton go e inak yaibobot tandayaseana menan watananean, ap menan nu endi ian ugupe, Diu uoni nagirewa ane wadiamoit. ");
INSERT INTO dgz_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Iwa God anega dianeni, Ne Diu uon go ian ugupe nagire ganat mugawa entan imaena, menan waenapan at at iravi inak yaibobot nega warain.” Ap anega diamon. ");
INSERT INTO dgz_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ian ugupe nagirewa Pol nop mega ame anune menan aton anun God nop mega ao waran. Amba da da inak yaibobot warapen menan God ganganat mumeni nop mega anu tumasen. ");
INSERT INTO dgz_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","God nop mega at ame iragi seset wa tau aen. ");
INSERT INTO dgz_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Go Diu nagirewa tanda anun menan God menan taine waen bawarewa mugawa amba apan bawarewa muga den, anan datnak muman. Mu Pol ge Banabas wa koeragam mumapen menan anan datnagene, amba mu at muga ae ve amopen menan upa oimone. ");
INSERT INTO dgz_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Menan waenapan koewa ae bat munapen menan Pol ge Banabas pusimu atabobo toninigamen ae vean amon pa Aikoniam tauan. ");
INSERT INTO dgz_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Go Iesu dugup mega nagirewa pa Antiok gapan aton baware anun amba Guewa Woup Seni potamup bararaen den aro muniwandin. ");
INSERT INTO dgz_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","At Aikoniam tauane amba Pol ge Banabas Diu nagirewa opata waine paewa unuk amon. Ap mepe mu opata kakae di waiwanumune menan ame Diu amba ian ugupe nagirewa paua muga arugataet anu tumasene. ");
INSERT INTO dgz_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Go namu venaseni ap umap sia venasen, Diu nagirewa upinamu da da nop ya anu tumasene ame ian ugupe nagirewa anan datnak muman. Amba Iesu dugup megawa nagirewa nop eboewa diamone. ");
INSERT INTO dgz_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Go Pol ge Banabas wam nononga ap mepe wanumon. Ayop oisewa epara tan wadidiam wanumun. Mu opata muga tavewa di ewamopen menan God garaet aro mega muneni gapan kiman yo paua mega ugup ugup taiwanumun. ");
INSERT INTO dgz_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Menan waenapan pa sewa ame gapanawa seu enun, upi Diu nagire arige yonan amba upinamu Iesu watu enamot gambenamu yonane. ");
INSERT INTO dgz_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Amba upi ian ugupe nagirewa ge Diu nagire, bawarewa muga den, Iesu watu enamot megawa dere ta koeragam mumapen amba gwara guramopen anun. ");
INSERT INTO dgz_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Go mu oit ame anune gapan tap serarat at Laekonia pa sewa Listura ge mainepewa at sewa Dobi den tauan amba at ame ikukuk amon. ");
INSERT INTO dgz_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ap mepe mu oise kakaewa opata gapan di wadidiam wanumun. ");
INSERT INTO dgz_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Pa Listura gapan pusi waberugaseni apanewa da ap mepe wande en, anega da inewa potap da ap anega yanen, ap den ya ainiwa. ");
INSERT INTO dgz_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Me neman gure Pol nop waiwandini ame anuiwandin. Pol kem kem apan ame asenagaet yave manega anun, apan mame inakaepen men anu tumasiwan. ");
INSERT INTO dgz_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Ap menan Pol me inap kaimakaet ve anega wan, “Pusigap amu, ao yon!” Wani pusi koe tani apanewa karapun doren amba ap erewa mega aen. ");
INSERT INTO dgz_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Pa nagirewa Pol dim da tani yawane menan mu nop muga Laekonia gapan ve wan, “God nuga dere mame apan venat mutan tauan!” ");
INSERT INTO dgz_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Menan Banabas mu god muga aritawa yaua Sus diane amba Pol mu opata waini god muga yaua Omis dian. ");
INSERT INTO dgz_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","God muga Sus mup paewa pa sewa sin garip mainep tune wanden. Sus pirisi mugawa, ae man kao ge rarema ben wat sin tonanewa tauen, iwa me amba waenapan yan garaet muga Iesu watu enamot megawa dere munat anu taiwanumune. ");
INSERT INTO dgz_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Go wam ame Pol ge Banabas mu dim da tat wan taiwanumune oise anune, menan mu wanup aigapewa muga benagen amba to iam ame berip ve wa ge wa serarat amon anega diamon, ");
INSERT INTO dgz_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Waenapan, ma iwa dimen taiwanin? Nu apan iragen e umayap di! Nu Iesu oise kakaewa wadiaepen menan tauaton ame gapan e naniap gwat kaitayana god eboewa egawa ame ae veapen. Go God tavewa kabani wandiniwa, piup kiman puiman gagape den wan venat mutanewa, me anu tumat tapen menan imuya inap entanan! ");
INSERT INTO dgz_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Wataget oniwandini piup nagirewa muk anut mugawa taiwanumune go God ya watanamon. ");
INSERT INTO dgz_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Go me inak tat megawa aroga di wande en ameme wat aipakam mega tauiwandini nu yavintoni gapan anuivin me wandia. Wat aipakam mega ame wam gapan ugin watu eniniwa, amba taba gine ugup ugup wam muga muga gapan yaniwanumat diamuiwan. Taba nuga nuniniwa den potanu aton nuniwan.” ");
INSERT INTO dgz_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Go nop mame Pol wani amba Banabas dere watanamot anun go waenapan sia man gura munat anun. ");
INSERT INTO dgz_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ma ewap, Diu nagirewa upi at Pisidia pa sewa Antiok ge pa sewa Aikoniam gapan den tauan amba to iam ame nanam mumane. Menan mu Pol gwara ton okokok pa garip warup tau amon, anune me boet anun. ");
INSERT INTO dgz_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Go Iesu anu tumasine nagirewa Pol inap tauan me enpanane gapan me ao yon wande ewagai pa sewa Listura aen. Inane woup sen Banabas dere amon pa sewa Dobi tauan. ");
INSERT INTO dgz_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Mu pa sewa Dobi gapan Iesu oit mega kakaewa wadidiamone waenapan aruga anu tumat tane. Amba Pol ge Banabas ewagai sia amon, pa Listura tau amon, pa Aikoniam tau amon, amba at Pisidia gapan pa sewa Antiok tauan. ");
INSERT INTO dgz_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Mu Iesu dugup mega nagirewa aro munan amba dadak diamone nop tavewa gapan anu tumat ta di wanumopen menan. Den mu anega wane, “God toemu mega gwanap anepen menan itan bagu sisi ugup ugup namu yao anuit.” ");
INSERT INTO dgz_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Iesu dugup mega pa pa gapan namu yoyo nagirewa om enumone dugup daiton daiton amat tapen semone. God menan taba virip tan mup wan amba namu yoyo nagirewa ame Ayop inap asenagaet di munane, iwa mu da da anu dao mumine nagirewa. ");
INSERT INTO dgz_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Amba at Pisidia tau amone ewape at Pampilia tauan. ");
INSERT INTO dgz_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ap mepe mu Iesu oisewa pa Poga gapan opata wadiamone ae vean at Atalia vit amon. ");
INSERT INTO dgz_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Pa Atalia gapan kabum gagap ewagai at Antiok sia amon. Namu Antiok gapan mu erewa gapan God nao warapen menan Iesu dugup mega nagirewa mup gapan wat aipakam mumeni anega wan, “Maman God, apan mame kwayup tam.” Ap anega mup wane boge amon, sia entan onamone, nao munane taitamen. ");
INSERT INTO dgz_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Pa Antiok tauane, mu Iesu dugup mega nagirewa iravi iamepen menan wan. Iesu dugup mega nagirewa iravi todagonen gapan God mu gamumup dim da tani amba ian ugupe Iesu anu tumat neginewa watap muneni oisewa wadidiamon. ");
INSERT INTO dgz_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Amba mu ap mepe Iesu anu tumasine nagirewa den tanamon wam nononga di wanumon. ");
INSERT INTO dgz_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Wam ameme at Diudia Iesu anu tumat tane nagirewa upi at Antiok vit onamon amba at Antiok Iesu dugup mega nagirewa anega diamon, “Mosis iup God inap wareni ame menan apan epiwa paua tum ya tapiwa God inak ewakewa ya waneta.” ");
INSERT INTO dgz_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pol ge Banabas ap mepe den. Ap menan mu yone Diudia nagirewa den notatae aritavet wane. Ap wane menan Antiok Iesu dugup mega nagirewa Pol, ge Banabas amba upi den om enumone pa Ierusalem dot amopen menan. Ierusalem gapan mu Iesu watu enamot megawa ge Ierusalem Iesu dugup mega kwayup tamuine nagirewa den epiwa tum arini noa wayawamopen menan amoin. ");
INSERT INTO dgz_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Iesu dugup mega nagirewa watu enamone. Amba mu pa Ierusalem amuinewa neginaet at Ponisia ge at Sameria tau ge tau amon. Diu uon go ian ugupe nagirewa imumu God inap entanene oisewa Iesu dugup mega nagirewa ap mepe wanumuine wadidiam amon. Gutut mame wane gapan Iesu dugup mega nagirewa iravi aton aigap di anun. ");
INSERT INTO dgz_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Mu pa Ierusalem tauane gapan, Iesu dugup mega nagirewa, Iesu watu enamot mega nagirewa amba kwayup tamuine nagirewa den waupamon. Pol ge Banabas God dim dim iragi mu gamumup tani oisewa wadidiamon. ");
INSERT INTO dgz_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Go Parisi dugup muga upi Iesu anu tumasine nagirewa yonan anega wane, “Ian ugupe nagirewa epimu tum di tap amba Mosis iup namu se wani ayamase tap.” ");
INSERT INTO dgz_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ame wane menan Iesu watu enamot mega nagirewa ge dugup kwayup tamuine nagirewa iamen. ");
INSERT INTO dgz_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Nop nonongataet wayao seyao taiwanumune ewap, Pita ao yon wande amba nop anega wadiamon, “Tatan gwanin, e anuyan watagentuk di God e yaumakayap om enunegen ame ian ugupe ne non utap Iesu Oise Kakaewa anupi amba anu tumat tain. ");
INSERT INTO dgz_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","God waenapan iravi imumu anuitamini apanewa menan ian ugupe nagirewa, Diu uoni, evenan tat anun. Ap menan Guewa Woup Seniwa nu nuneni ap umap den munen. ");
INSERT INTO dgz_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Me yamap nu iravi gine daiton ap menan ian ugupe nagirewa Iesu anu tumat tane menan God mu koewa muga anu ae ven. ");
INSERT INTO dgz_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ap menan endi iwa dimen God pusip warup yaviwanin? Iup nuga itaniwa nu omayan baewa amba nu den kwayupe ya taintoni iwa itan baware iragen. Iwa dimen Iesu anu tumat taine nagirewa itan ame onemup seait? ");
INSERT INTO dgz_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ame umap uon, ya seait iwa nu God Ayop Iesu garaet nuneni gapan wat inakam nimanen, ap mini ian ugupe nagirewa mu den ap anega.” ");
INSERT INTO dgz_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ap wani, Pol ge Banabas yonane God ian ugupe munan yo ge kiman paua baware ugup ugup anenen mu gamumup taiwandini oisewa wadidiamon, menan to iamene nagirewa iravi no uon wanumon, neman guran anuiwanumun. ");
INSERT INTO dgz_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Mu nop wane uon tani ewap, apan Diemis anega wadiamon, “Tatan gwanin, nop wapena anun. ");
INSERT INTO dgz_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Oit ameme Saimon Pita gaset wadianen anenen da God namu anut mega to ewamoni ame ian ugupe nagirewa yaumakamup upi tambumop waenapan megawa entanamon. ");
INSERT INTO dgz_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Saimon wani ame tavewa di iwa wataget God no oise waiwanumune nagirewa nop mame den anega seane, God anega wan, ");
INSERT INTO dgz_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Mame ewap ne sia tauain, amba Devit toemu mega ta koeragamene, ne to bongamep inak munain. Pa sewa wabenagene, ne sia tuin. ");
INSERT INTO dgz_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ap tapena gapan, waenapan iravi, piup gapan, inanap tauain, Diu uoni ian ugupe nagirewa den tauain, iwa mu ne waenapan negawa gaset diamona menan. ");
INSERT INTO dgz_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ne ayop di, namu wadiaena evi taueta. God ap anega wan.” ");
INSERT INTO dgz_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Ap menan, Diemis aigap sia wadiamon, “Ne anuingina mam, ian ugupe imumu God inap entanene nagirewa nu kaimakaet wat itan da ya munat. ");
INSERT INTO dgz_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Go manega ok inamup enu wadiamoit, ame nanimup god eboewa guewa kaitane ameme antaba irine god muga munapen ame tabaewa ya nap. Amba waen ge apan wainan gogo ya tap. Amba man mege wat imokaminewa ya nap. Amba deniwa da ya nap. ");
INSERT INTO dgz_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Iup mame ian ugupe nagirewa asik tane iwa en arugataet gapan Mosis iup mega Diu pura bawarewa gapan batnaginewa amba pa da da gapan wadidiamuinewa menan mu anune.” Diemis ap anega wadiamon. ");
INSERT INTO dgz_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ap menan Iesu watu enamot mega nagirewa, dugup kwayup tamuine nagirewa amba Iesu anu tumasine nagirewa iragi den nop panane apan mugawa wa watu enamop, Pol ge Banabas tanamo pa Antiok amot wan. Ap wane apan Diudes, yaua da Basabas amba apan Sailas mu den watu enamon. Iesu anu tumat nagirewa apan dere mame virimu tainewa. ");
INSERT INTO dgz_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Mu den ok manega watu enan, Kaewa kaewa tatan gwaninua ian ugupe Iesu anut tumasiana nagirewa, pa Antiok, Siria amba at Silisia gapan iniwanin. Nu Iesu watu enamot megawa amba Ierusalem dugup mega, kwayup taintoni nagirewa den gaun inayap waivin. ");
INSERT INTO dgz_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Nu anuton apan ame upi mapa inanup tau onamone aro da ya munaton, amba am dauro taen, opata muga wane iae guine wa koeamene. ");
INSERT INTO dgz_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ap menan nu iragi iametoni amba imunu daiton manega anuton. Apan dere nu potanup watu enamoton. Apan dere, ame evenan wainu kakaewa, ame Banabas ge Pol, tanam inayap onamot waton. ");
INSERT INTO dgz_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Banabas ge Pol, nu ayop nuga Iesu menan, nao taine ge bop tawa ya anuine, apane waiwa. ");
INSERT INTO dgz_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Potanup amuine apan dere ame Diudes ge Sailas, mu nu dim da ok gapan seatoniwa nop gapan, sia aigap di wadiain. ");
INSERT INTO dgz_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","God Guewa Woup Seniwa nu den imunu daiton gapan, iup itan mega da e oneyap ya seapen menan anutoni, go nop mame megenat ayamase tapen, ");
INSERT INTO dgz_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Waenapan nanimup god eboewa guewa kaitane, ameme antaba irine god muga munapen ame tabaewa ya nane. Amba man deniwa ya nane. Amba man mege wat imokaminewa ya nane. Amba waen ge apan wainan gogo ya tane. Koewa mame iragi ya taiwaniampinawa ame e kakae di tai. Nop otu nuga mame uon tan. Gaun inayap waianit. Mu ok ap anega watu enan. ");
INSERT INTO dgz_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Oit wat amone nagire pa Antiok tauane. Amba Antiok Iesu dugup mega nagirewa ok ame munan. ");
INSERT INTO dgz_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Dadak nopewa ame ok gwanap wane waenapan iravi nop bibigawa anune aton baware tan. ");
INSERT INTO dgz_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Diudes ge Sailas mu den God oise wainewa, menan tase gwani dadak munep aritavet amun imumu to kimepen menan wam nononga wadidiamon wanumun. ");
INSERT INTO dgz_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Wam nononga wanumone amba pa Antiok Iesu dugup mega nagirewa baigane den watu enamone ewagai Ierusalem sia amon. ");
INSERT INTO dgz_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Go apan Sailas ya aet anuni menan ap mepe wanden. ");
INSERT INTO dgz_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Amba Pol ge Banabas pa Antiok gapan di wanumon, ap mepe mu upinamu aruga den ayop nopewa gapan di wadidiam wanumun. ");
INSERT INTO dgz_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Wam da Pol Banabas anega wadien, “Pa sewa sewa daio nu namu ane wadidiamotoni mu anenen taiwanumune anupen menan ewagai sia daio inamup ane yawamopen.” ");
INSERT INTO dgz_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banabas apan Dion Mak den aet anun. ");
INSERT INTO dgz_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Go Pol Dion Mak ya aet anun iwa wata pa Pampilia tauane gapan me yone ae vemo ewagai pa Antiok aeni menan. ");
INSERT INTO dgz_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ame menan Pol ge Banabas Dion Mak aigap noyam notatae warane amba dum marimen amon. Banabas Dion Mak den kabum gagap at Saiparas amon. ");
INSERT INTO dgz_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Amba Pol apan Sailas om enu. Amba Antiok Iesu dugup mega nagirewa Pol ge Sailas munan mup wane, God kwayupe gapan wat aipakam mumane amba Pol ge Sailas tau amon. ");
INSERT INTO dgz_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Amone at Siria ge Silisia tau ge tau amone, Iesu dugup megawa wadidiamone anun imumu wat kaimagamepen aroewa muniwanumun. ");
INSERT INTO dgz_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Apan Pol, Sailas den, pa Dobi tauan amon amba pa Listura tauan. Iesu wadiamot apane da yaua Timoti ap mepe iniwandin. Timoti inewa Diu waen da Iesu anu tumat taini waenewa, go me mamewa ian Gurik apane da. ");
INSERT INTO dgz_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Iesu dugup mega nagirewa, pa Listura ge Aikoniam gapan, Timoti kakaewa taini oise tarage wane. ");
INSERT INTO dgz_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pol imup me den wat nau daio aet anun. Go at Aikoniam ame gapan Diu nagirewa aruga wanumon amba Timoti mamewa ian Gurik apanewa mu asigimup. Ap menan Diu nagirewa aton anupen menan God paua mega Timoti epiwa tum tan. ");
INSERT INTO dgz_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Mu pa sewa sewa tau ge tau amone, pa Ierusalem Iesu watu enamot megawa amba dugup kwayup tamuine nagirewa iam iam gapan ok seane ame tavewa anu tapen menan, mu ap muga gapan, waenapan iravi wadidiamone. ");
INSERT INTO dgz_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ap tane menan at iravi gapan Iesu dugup mega nagirewa wat kaimagam muman ap menan Iesu anu tumat tane nagirewa paua muga kai ware aigap aen. ");
INSERT INTO dgz_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pol ge evene wai den at Pirigia ge Galesia tau ge tau amon iwa me at Eisia paua mega gapan opata ya wapen menan Guewa Woup Seniwa mu watanamon. ");
INSERT INTO dgz_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Wam ame mu Misia paup tanatan mega tauane amba at Bitinia gwanap unumopen tayawane go Iesu Guewa mu watanamon. ");
INSERT INTO dgz_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Watanamoni menan mu at Misia mainep tau amone vitan pa Toroas puiman etop tauane. ");
INSERT INTO dgz_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Mum ame gapan Pol bet ine yaveni at Masedonia apanewa yone inap mup anega waiwandini, “Paina yamat onaen at Masedonia tauan amba wat agoat nimanen.” ");
INSERT INTO dgz_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pol bet ine yaveni ewap, nu at Masedonia anet anuton iwa God Oise Kakaewa mu wadidiamopen menan dianeni anuton. ");
INSERT INTO dgz_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Nu pa Toroas gapan kabum gagap dotouat tamana anetoni pa Samotures tauaton inaton, woup sen sia anet pa Niapolis tauaton. ");
INSERT INTO dgz_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Puiman etoa ae veat pusinup anet at Pilipai tauaton. Pa sewa Pilipai ame sewa bawarewa at Masedonia gapan, ap mepe ian Rom nagirewa aruga iniwanumun. Nu ap mepe wam agiap mini den wanineton. ");
INSERT INTO dgz_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Diu Pura bawarewa muga gapan nu pa sewa sin mega garawaset kauma aneton. Iwa nu Diu nagirewa at ame gapan God inap mup waine arewa anuton. Nu ap mepe ae waninet amba waen iamen wanumone inamup nop erewa waton. ");
INSERT INTO dgz_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Mu wanumon nop nuga anuiwanumune waen da daiton yaua Lidia, pa sewa Tayataira wanup buinip tambun une gare gare tainiwa. Me God tavewa wa taragasini menan God me imu pose watapeni amba Pol nop wani bemta anun. ");
INSERT INTO dgz_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Wam ame, waen ame amba pa mega gapan iniwanumune nagirewa iragi Iesu anu tumat gapan dup iamoton. Amba waen Lidia inanup anega wani, “Apan negawa, ne Ayop nuga Iesu anu tumasena oitana anuyana menan onaen pa nega gapan iniwanian.” Wa ge wa tani menan nu pa mega aneton. ");
INSERT INTO dgz_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Wam da sia kauma Diu nagirewa mup waine arewa anetoni nao kaimake garewa uoni taini waenoro da tautanaton. Waen ame guewa koewa airampu da potap wande en. Waen ame guewa koewa aroewa gapan namup dim da venasepiwa yave waiwandin. Ap waiwandini gapan garewa bawarewa wariwandin go i nagirewa seasiwanumun. ");
INSERT INTO dgz_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Waen mame nu ewanup aiwandin amba nop ve nunan manega waiwandin, “Ian ma mu God aigap iragena menan nao tainewa! E inak wara wara neginewa wadidiaiwanum!” ");
INSERT INTO dgz_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Waen mame nop ame pot poraet waiwandini menan Pol gari yaven, boge me entane airampu yam ta yave wan, “Iesu Keriso yaua gapan, waen ae ve tau ak.” Boge gine tutup airampu waen ae ve tau aen. ");
INSERT INTO dgz_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","I nagirewa, waen ap me munan nao tan moni warine nao sia ya taiwandin yawan. Ap menan Rom baware muga inap noyam wapen menan, Pol ge Sailas tambumon okonagen amone une gare gare taine arewa tauan. ");
INSERT INTO dgz_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Bawarewa muga inamup anega wane, “Apan dere mame Diu nagirewa go nu at nuga nagirewa wa koeragam mumiwanum. ");
INSERT INTO dgz_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Gutut muga nu tat dianene go tata iup nuga paina yamatait. Nu at Rom nagirewa iup muga den to paitait.” ");
INSERT INTO dgz_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Pa nagirewa iravi intum tan amba Pol ge Sailas wa koeragam muman. Ap menan, Rom iup kwayup taine bawarewa mugawa Pol ge Sailas wanup muga aigapewa ae benak sean bunum gapan guramot diamon. ");
INSERT INTO dgz_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Wam ame apan dere tambumon bunum gapan kaimakaet guramon amba gwat noke kwayup taini apanewa kwayup ta kakayat mumapen dian. ");
INSERT INTO dgz_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ap anuni menan gwat noke amat taine apanewa gwat noke bumagap iragen semon, oma nikoni tambun pusimu kapet mumane wanumon. ");
INSERT INTO dgz_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Mum bumagewa gapan Pol ge Sailas mup tan amba wak God inap waiwanumun, amba gwat noke gapan upinamu den wanumone nagirewa wak muga anuiwanumun. ");
INSERT INTO dgz_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Wak waiwanumune gapan unuk bawarewa da tauen piup nutanut enun gwat noke pa sewa ibariwa menao manao tane sep tap wapen tan. Amba gwat noke tonanewa iragi ingane tap sen no aroga, amba kaimake dena damigewa nanimu panamone imup butut batat wane. ");
INSERT INTO dgz_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Gwat noke kwayup taini apanewa wa kandasen yonen. Me gwat noke tonan iravi no tapamone menan tum ware mek ingane bumage entanapen tan iwa me gwat noke nagirewa gaset tap tau amot anuni menan. ");
INSERT INTO dgz_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Go Pol kaimakaet anega wan, “Gek ingane bumagaga ya entana, nu iravi mapa!” ");
INSERT INTO dgz_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Gwat noke kwayup taini apane dun menan mup wani amba wareni gapan serarat taue Pol ge Sailas namup omanip enu tap pagagak tan. ");
INSERT INTO dgz_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Amba ao yonen, Pol ge Sailas naumo garip aen amba singui anega wayawamon, “Bawarewa negawa, ne dim da tap, amba God inak mega warain?” ");
INSERT INTO dgz_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Mu gare wan, “Ayop Iesu anu tumat tawa ge God inak mega ewakewa warai, ge amba pa gega nagirewa den.” ");
INSERT INTO dgz_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Wane amba pa mega nagirewa den God nop mega wadidiamon. ");
INSERT INTO dgz_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Mum ame gapan gwat noke kwayupewa mu tambumon epimu gaura guramon siget munane ame omasewa denipe bigi waramon, amba me pa mega nagirewa iravi den anu tumat dupewa iamone. ");
INSERT INTO dgz_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Dup iamoni ewap, me Pol ge Sailas tam naumo one pa mega taue amba taba tunu munen. Me pa mega nagirewa den Iesu anu tumasene menan aton baware anun. ");
INSERT INTO dgz_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Inane woup seni at Rom wanene taine nagirewa punip nagirewa watu enamone gwat noke tauane anega wane, “Apan dere ame vetamone tau amop.” ");
INSERT INTO dgz_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Menan gwat noke kwayupe taini apanewa Pol anega dien, “Wanene nagirewa nop watu enane ge amba Sailas vetaep tau aisepen menan wane. Menan nonup gapan aisen.” ");
INSERT INTO dgz_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Go Pol punip nagirewa gare anega diamon, “Nu wanene aopan tanean amba koewa nuga da e ya yawayan amba waenapan yaumakamup gaura guranean, ame anenen? Nu Rom apane wai di, go gwat noke senean! Iwa dimen karaua watu enanet anuiwanin? Ame umap uon! ae venen, wanene nagirewa muk di onamo amba tam naune amop.” ");
INSERT INTO dgz_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Punip nagirewa wanene taine Rom baware mugawa nop mame wadiamone gapan, wanene nagirewa tap tane iwa Pol ge Sailas, mu at Rom apane waiwa oise anune menan. ");
INSERT INTO dgz_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Menan wanene taine gwat noke amon Pol ge Sailas potamu wabibigamen amba naumo onamone pa sewa muga ae ve at da ugup amopen menan mup wane. ");
INSERT INTO dgz_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pol ge Sailas gwat noke ae ve tau amone ewap waen Lidia pa mega amon. Ap mepe Iesu dugup mega upi tautanamon amba dadak diamon. Boge mu at ame ae ve amon. ");
INSERT INTO dgz_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Apan Pol ge Sailas pa Ampipolis ge pa Apolonia tau amone pa Tesalonaeka tauan. Ap mepe Diu nagire opata waine paewa wanden. ");
INSERT INTO dgz_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Taini asigiwa gapan, Pol pa ameme gapan Diu nagirewa tanamon Iesu nopewa wadiamuiniwa. Diu pura bawarewa wam yampo gapan Pol nop i davewa Diu nagirewa tanam gare gare wawa musiwanumun. Pol waenapan imu pose wat entanepen menan nop ");
INSERT INTO dgz_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ni enowa geonage anega wadiamon, “God anuni gapan Iesu nunan ugu vegaek anu boe yon wanden. Union ya boen. Iesu mame oisewa wadiaena me Keriso, God wa watu eneni megawa.” ");
INSERT INTO dgz_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Diu nagire upinewa ge Gurik God iup mega anuine nagirewa arugataet amba waen yaumu taneni aruga mu imu pose entan tamon amba Pol ge Sailas intum tamon. ");
INSERT INTO dgz_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Go Diu nagire anu koeam mumane menan naina yoyo nagirewa bongamen tobot tamon amba anan tapen menan nanam mumane. Ap tane gapan, pa nagirewa iravi, Pol ge Sailas ae guramopen menan yomu tane amon apan Dieson pa mega tauane. Pol ge Sailas pa gwanap anune menan pa tobebenagen. ");
INSERT INTO dgz_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Go ya yawamone gapan mu apan Dieson amba Iesu dugup mega nagirewa upi den tambumon okokok upamon, pa sewa airasewa inamup tauane anega wane, “Pol ge Sailas at at iravi koevet ta onamuin ene, endi mame tauan ");
INSERT INTO dgz_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","amba apan, Dieson ma, wa atonat mume upamo pa mega gapan semon. Mu iravi ayop nuga bawarewa Sisa iup baraeni tandayasiwanum, go gare mu ayop muga dawa, Iesu menan waiwanum.” ");
INSERT INTO dgz_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Nop mame wane gapan pa sewa airasewa nagirewa amba to iam ame nagirewa iragi arara babara wan. ");
INSERT INTO dgz_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ap menan pa sewa baware nagirewa Dieson me evene wai den anega diamon, “E ebo tayana menan garewa nunan amba pa aisen.” Ap anega wane menan mu garewa munane amba amon. ");
INSERT INTO dgz_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ap menan mum ase di wa guguriwandini gapan, Iesu dugup mega nagirewa yonan Pol ge Sailas watu enamone pa Beria amon. Mu at ap mepe tauanewa boge Diu opata waine paewa dot amon. ");
INSERT INTO dgz_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Pa Beria gapan Diu nagirewa mu kakae, iwa namu pa Tesalonaeka Diu nagirewa tane mini da ya tane, menan Pol oit mega wadiamoni gapan mu aton den anun. Mu pot pot nop anu awapen menan God ok mega namua gapan batnagen yaviwanumun, Pol dim da wani ame tavewa di go uon ap anupen menan. ");
INSERT INTO dgz_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Mu aruga anu tumat tane. Ian Gurik kwan puraput waene waiwa amba Gurik apane wai den, aruga anu tumat tane. ");
INSERT INTO dgz_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Go Tesalonaeka nagirewa Pol Beria gapan God nop mega wadiam wandiniwa oise anune gapan mu at Beria to iam onamone amba Beria nagirewa anan datnak mumane. ");
INSERT INTO dgz_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","At Beria Iesu dugup mega nagirewa anan tapen oisewa anune menawaet Pol amba apan upi den puiman eto watu enamone amone, go apan Sailas ge Timoti ap mepe wanumon. ");
INSERT INTO dgz_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Pol wat amone nagirewa wat nau amon pa Atensi tauan. Tauane pa muga ewagai entan amopen tane menan Pol anega diamon, “Apan Sailas ge Timoti nao muga asepa uon tapi serarat onamo inanap tauep.” Ap diamoni mu amon. ");
INSERT INTO dgz_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pol pa Atensi gapan Sailas ge Timoti me inap tauapen amase taiwandini gapan, me at Atensi yangut tan bagu sisi anun iwa Atensi nagirewa god muga ugup ugup guewa nanimup kaitane inamup wa taragasiwanum. ");
INSERT INTO dgz_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Menan me Diu nagirewa opata waine paewa ugup ugup aiwandini amba Diu ge God anuine ian ugupe nagirewa den gare gare wawa musiwanumun. Amba sia orup da da mondi tauane pa sewa namboya wanumuine nagirewa den tanam nop waiwandini. ");
INSERT INTO dgz_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Anut nagirewa upi dugup muga yaua Epikurian ge Stoic ame den nop gare gare waiwanumun. Mu upi Pol inap nipep anega wan, “Apan mam anut uoni bumbawam tan menan dim da anun waiwan?” Upi gare nop anega wane, “Me ugupe nagirewa god muga oisewa da waiwan.” Mu ap anega wane iwa Pol Iesu oise kakaewa amba ao yon wandeni oisewa opata gapan wadidiam wandin. ");
INSERT INTO dgz_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Menan mu Pol wat nau amon iam iam arewa muga ame togan yaua Ariapagas gapan tauan. Ap mepe iam iam tan amba me inap anega wan, “Nop ewakewa gega waingiana nu oare. ");
INSERT INTO dgz_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Anut ugupe da waana gapan nu anu bambamasivin. Menan gueguewa wadianet nu anut anuivin.” ");
INSERT INTO dgz_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Mu ap anega tane iwa wam wam gapan pa Atensi nagirewa at ugupe daio tauane nagirewa nop oit muga ewakewa anupen menan pot poraet nop gare gare mondi waiwanumun. ");
INSERT INTO dgz_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Togan Ariapagas gapan iam iam tane, Pol yone opata anega wadiamon. “Pa Atensi apane waiwa, ne wapena anun. Ne yawaingina e pot pot god ega aruga munan anuiwanin. ");
INSERT INTO dgz_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Pa ega ikukuk angena naniap kaitayana god ega mup inap taiana watarewa yavingina. Amba god ega da watarewa gagap ok anega seane yawan, ‘Watat mam God oarewa megawa.’ E dim da oarewa inap wa taragasiana endi ne wapena anun. ");
INSERT INTO dgz_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","God ame, me piup kiman amba wan dim dim iragi wan venat nitaton. God ame piup kiman Ayopewa iragenawa amba pa apan nanip tune gwanap da ya iniwan. ");
INSERT INTO dgz_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Me inap anenen tat ago wanait? Ame umap uon, iwa me inak ibariwa, wan dim dim kakae guragut amba inak nuniniwa gapan nu inak warivin. ");
INSERT INTO dgz_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Me apan daiton, yaua Adam, tani gapan piup waenapan iravi me naewa mega yanaton. Piup at at punanan wat aneton, inintoni ibariwa God. Wam ansena gapan ininait at ambe gapan waninait me namu wan evi amba venasen. ");
INSERT INTO dgz_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ameme taiwandini iwa waenapan God yoa tapen menan. Me wandap uon go mainanup konintu di wandia. ");
INSERT INTO dgz_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Watageta apane ok anega sen, God wani gapan nu yonaton inivin waninivin. Apan ega da den ok manega sen, Nu iravi God naewa megawa. ");
INSERT INTO dgz_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Nu God naewa di waninetawa, manega ya anuinampen, apan tat mega kakaewa gapan nanip agim bangae gwayayame dena god gueguewa kaitane ame God di. Iwa God gueguewa ap mini da uon, me kabani wandia. ");
INSERT INTO dgz_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Watageta wamewa waenapan God ya anu awane menan koewa muga me ya batnagen. Go endi waenapan iravi koewa nuga ae veat imunu entanepen men dianiwan. ");
INSERT INTO dgz_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Iwa piup iravi wanene tamopen menan apan daiton om enun. Om enuni apanewa ame wanene tamana di taneta. Me ameme di tapi wa ewanepen menan God om enuni apane ame boe inakae sia yon wanden.” Pol opata ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Mu Pol apan Iesu yon wanden oise wani anune menan upi nipep diane go upi Pol anega diane, “Nu nop gega sia anut anuivin.” ");
INSERT INTO dgz_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Diane menan Pol ae vemo aen. ");
INSERT INTO dgz_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Apan Daionisias at Ariapagas apanewa ge waen yaua Damaris amba upi den mu Iesu anu tumasene, amba Pol tanam amon. ");
INSERT INTO dgz_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Mame ewap Pol at Atensi ae ve pa Korin tauen. ");
INSERT INTO dgz_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Pa ap me gapan Diu apane da yaua Akila at Pontas gapan yaneni apanewa, ap mepe iniwandin. Namu, waenewa Pirisela dere at Itali gapan wanumone, wam ame at Itali ayope bawarewa yaua Kolodias Diu nagire gari yawamon pa mega Rom ae vepen diamoni menan mu ae vean pa Korin tauan. Menan Pol apan ame waene dere yawamopen aen. ");
INSERT INTO dgz_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Pa muga gapan den wanden iwa mu nao muga daitonawa ame pa wanup gapan tumuine ame taginamene une tainewa. Pol ap mepe wandeni nao ame taiwandin. ");
INSERT INTO dgz_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Diu pura bawarewa da da gapan Pol Diu nagirewa opata waine paewa gwanap tanamo nop waiwandin. Diu ge Gurik nagirewa Iesu oisewa anu tumasepen menan nop kaimakaet inamup waiwandin. ");
INSERT INTO dgz_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Wam ame Sailas ge Timoti at Masedonia gapan tauane. Tauane menan, Pol me nao mega ae veni amba wam wam opata gapan Iesu me God om enuni apane Keriso di ap anega Diu nagirewa wadidiam wandin. ");
INSERT INTO dgz_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Go Diu nagirewa Pol watanan wa koeragamene menan Pol wanup mega ware atabobo pem pem ta amba anega wadiamon, “God wanene taep gapan e itan egawa ame ek egawa di, ne inanap da ya taueta. Endi ma use aeniwa ne Diu uoni go ian ugupe inamup ange wadidiamoin.” ");
INSERT INTO dgz_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Pol ap wani, Diu nagirewa ae vemo Diu uoni God wa taragasini apan da yaua Taitias Diastas pa mega taue ap mepe iniwandin. Pa mega Diu opata waine paewa mainap. ");
INSERT INTO dgz_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Diu opata waine paewa namu yoyo apane da yaua Kurisipas waene otu wai den Ayop Iesu anut tumasen. Pa Korin nagirewa aruga Iesu oisewa anune amba anut tumat tane gapan iragi Iesu anu tumat dupewa gapan iamon. ");
INSERT INTO dgz_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Mum da, Pol bet ine gapan, Ayop Iesu yave Pol inap nop anega dien, “Tap gop ya anu, nop nega di waingan, nok uon ya wanige, ");
INSERT INTO dgz_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Iwa ne ge den wanik angin. Apan da amborage ya togeta, iwa ne waenapan nega pa sewa ma gwanap arugataet wanumamun.” ");
INSERT INTO dgz_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Ap menan Pol en daiton derewa semu ap mepe wande en, waenapan God nop mega wadidiam wandin. ");
INSERT INTO dgz_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Evi at Rom apane yaua Galio, at Guris ayope tani gapan, Diu nagirewa iame Pol anu koeamen menan waran wanene paewa amon. ");
INSERT INTO dgz_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Mu wanene apanewa Galio inap anega wane, “Apan ma negin ugupe gapan God wa taragasepen waiwan menan me iup paina yamasen, nu waenapan wababayan nimaniwan.” ");
INSERT INTO dgz_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pol gare wapen tani go ayop Galio Diu nagirewa anega wadiamon, “Pol aopan da go koewa da tani oisewa e wapo ne anu imaepo, ");
INSERT INTO dgz_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","go mame anuiangina ame e nop ega o yaua ugup ugup o iup ega gapan notatae waiwanin menan e ek wa kakayasen. Menan wan dim dim ap gapan ne wanene ya tain.” ");
INSERT INTO dgz_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ap diamoni amba wanene paewa gapan Diu nagirewa up oimon. ");
INSERT INTO dgz_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Garip amone Diu nagirewa opata waine paewa kwayup taini apane yaua Sosenis kaimakaet waran wanene paewa namboyap tone. Ap tone gapan ayop Galio gari yaven yawamo ae vemon. ");
INSERT INTO dgz_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pol pa Korin gapan wam aruga di wanden. Amba me tase gwani ae vemo amba kabum gagap at Siria aen. Tanamo aeni nagirewa yaumua Akwila waene Pirisela dere. Go namu pa Senkiria gapan God inap dim dim wa agiaseni ame tapen menan Pol i gume ware ae sen. ");
INSERT INTO dgz_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Mu pa Epesas tauane, Pol Pirisela ge Akwila ap mepe ae vemon. Me megenat Diu nagire opata waine paewa gwanap unuk ae amba Diu nagirewa den nop gare gare waiwanumun. ");
INSERT INTO dgz_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Waenapan Pol nonongantuk inamup wandepen menan anune menan singuiasene go Pol me tanda wan. ");
INSERT INTO dgz_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Me ae vemopen tani gapan agi anega diamon, “God anut mega wandepiwa ne entan sia inayap tauain.” Wani boge pa Epesas ae ve kabum gagap aen. ");
INSERT INTO dgz_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Pol pa Sisaria taueni kabum ae ve pa Ierusalem ae amba waenapan mega gaun inamup wan. Wani pa Antiok ewagai aen. ");
INSERT INTO dgz_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Pa Antiok gapan wam agiap da wandeni ewap, Pol at Galesia ge at Pirigia ame gapan ikukuk tau ge tau ae Iesu dugup mega nagirewa iravi wa kaimagam mumiwandin. ");
INSERT INTO dgz_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Wam ame, Diu apane da yaua Apolos at Aleksandia gapan yanen, pa Epesas tauen. Me God nop mega opata wat mega kakae iragen amba God ok mega namua iragi anu kakayasen. ");
INSERT INTO dgz_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Namu waenapan upi Apolos Iesu inak megawa wadidiane menan endi me atonu den Iesu oisewa tamanagaet wadidiam wandin. Go me Dion waenapan dup iamoni oisewa megenat anun. ");
INSERT INTO dgz_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Diu opata waine paewa gapan Apolos aro ta tumban amu yone God no oise wadidiamon. Wam da apan Akwila, waenewa Pirisela den, opata mega anune menan apan Apolos pa muga wat nau amon amba God negin mega tamanawa aigap sia Apolos wa ewasen. ");
INSERT INTO dgz_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Evi amba, Apolos at Guris aet anuni menan, Epesas Iesu dugup mega nagirewa me wa agoasene menan Gurik Iesu dugup mega nagirewa inamup ok seane. Iwa Iesu wadiamot upi asepa at Gurik gapan Apolos waupapen menan. Apolos ok muga ware at Guris taueni gapan, God garaet mega gapan, anu tumat tane nagirewa God no oise wadidiam wandini. Mu opata mega anune gapan imumu wat kaimagamen, aro baware waran. ");
INSERT INTO dgz_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Iwa, pa nagirewa iame wanumone gapan Apolos yone nop kaimakaet aroe den God nop mega, namua gapan, Iesu me God watu eneni Keriso wa ewamon. Diu nagirewa upi ya anut anune menan mu nop gare diane, go me epara ta gare wadiamoni gapan Diu nagirewa inamup nop uon tan. ");
INSERT INTO dgz_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apan Apolos pa Korin gapan wande en. Ap wamewa gapan, Pol pa Epesas tauen. Ap mepe Iesu wadiamot mega nagirewa upi yomu tani ame yawamo, ");
INSERT INTO dgz_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","amba singui wayawamon, “Wam ame e anu tumat tayana ame e Guewa Pose Woup Seniwa warayan go uon?” Mu gare anega wane, “Ae uon, nu Guewa Woup Seniwa da ya anuton.” ");
INSERT INTO dgz_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Menan Pol singui sia wayawamon, “E guegue ambe gapan dup iayaen?” Mu gare wane, “Apan Dion waenapan dup iamoni guegue mega gapan dup ianen.” ");
INSERT INTO dgz_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pol sia wadiamon, “Dion dup guegue mega ame koewa anu ae ve sia entanapen dupewa. Me waenapan anega wadiamon, ‘Ewanap tauepi apanewa inap anu tumasen, ame Iesu di.’” ");
INSERT INTO dgz_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Mame wani, mu Ayop Iesu yaua gapan dup iamon. ");
INSERT INTO dgz_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Dup iamone amba Pol naniwa iamup seni gapan Guewa Woup Seniwa mu potamup tauen, amba merimu tobayanen ian ugupe noa wan, amba God no oise den waiwanumun. ");
INSERT INTO dgz_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Apan anu tumat dupewa iamoni ame apan aonagaet pusinawan dere. ");
INSERT INTO dgz_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pol Diu nagirewa opata waine paewa aeni siragam yampo gwanap pura gapan gapan, epara ta, nop kaimakaet wadidiamon. God toemu mega amunua oisewa nop tavewa mu anupen menan Pol waenapan den nop gare gare waiwanumun. ");
INSERT INTO dgz_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Go upi epara tan ya anu tumaset waiwanumun. Mu aroga Iesu anu tumat neginewa inap wawa koko ta wane. Ap menan Pol mu ae vemo, wadiamot nagirewa tambu aen. Mu wam ame use aeniwa iam iam paewa yaua Tiranas gapan pot pot waenapan den anu tumat nopewa ame seyao wareyao taiwanumun. ");
INSERT INTO dgz_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Mame taiwanumune aeni en dere uon tan. Ame wamewa gapan at Eisia arige wanumuine nagirewa, Diu ge Diu uoni ian ugupe nagirewa iravi Iesu oisewa anune. ");
INSERT INTO dgz_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","God Pol gamup kiman yo paua baware ugup ugup taiwandini. ");
INSERT INTO dgz_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Menan Pol wanup megawa da paniwandiniwa den atup megawa ame waenapan ap me tambun vek nagire inamup amone. Wanup ap gapan inak mutan airampu potamup wanumone tau amon. ");
INSERT INTO dgz_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","14","Diu apan upi, at da da tau ge tau amon, amba airampu waenapan potamupewa wa oimopen taiwanumune. Diu pirisi ayop mugawa yaua Sikiva otu waiwa nani yamu dere mu ap den taiwanumun. Mu iravi Ayop Iesu yaua aroewa gapan airampu wa oimot wan taiwanumune, anega dian, “Apan Pol opata Iesu yaua waini aroewa gapan airampu ge tau ak!” ap anega wan taiwanumune. Wam da Sikiva otu wai apan da potap airampu wandeni inap ap anega diane. ");
INSERT INTO dgz_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Go airampu gare diamon, “Ne Iesu asik tan amba Pol den asik tan, go e da?” ");
INSERT INTO dgz_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Airampu ap wani, apan airampu potape wandeni ame yone set wa aigamup wandeni gure baime ene apan apan tan. Wanup muga benak ae sen, epimu aroga siget munen, amba mu pa garip serarat tau amon. ");
INSERT INTO dgz_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Diu amba ian ugupe nagirewa den, oit ame anune menan tap baware anun. Menan mu Iesu viriwa aigap di tane. ");
INSERT INTO dgz_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Menan Iesu anu tumasine nagirewa, kayao banao koewa muga vetavet aroga tan. ");
INSERT INTO dgz_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Nuat taine amba banao nagirewa aruga buka muga iravi tam tauane, waenapan yamamup omaya iramon. Buka iravi iramone garewa muga moni 50,000 mini. ");
INSERT INTO dgz_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Negin manegawa gapan Ayop nop megawa senare tau aen amba Iesu dugup mega nagirewa anu tumat muga kai wariwandin. ");
INSERT INTO dgz_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Wan dim dim ma iragi venaseni ewap, Pol imua upe se pa Ierusalem aet anuni menan at Masedonia ge at Guris tau ge tau aeni, amba pa Ierusalem tauat anun. Pol manega wan, “Pa Ierusalem tauapena amba den ange pa Rom yawat anuivin.” ");
INSERT INTO dgz_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ap anuni menan ago mega dere Timoti ge Erastas at Masedonia watu enamon go me wam upine den at Eisia gapan wanden. ");
INSERT INTO dgz_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Wam ame gapan Ayop Iesu anu tumat inagewa taine menan pa Epesas gapan anan da tuk wan. ");
INSERT INTO dgz_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ap gapan, gwat keri mini, go gwayayame dena, gapan nanip kaisini apane da yaua Demitias, at Epesas gapan wandiniwa. Me gwat ame gapan god muga yaua Atemas mup paewa gueguewa otu kamontua arugataet kaitamuiniwa. Ap kaisiwanumune gapan apan Demitias evene wai den garewa baware ap gapan wariwanumune. ");
INSERT INTO dgz_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Menan god muga kaisine nagirewa apan upi nao muga ap umap taine den Demitias venamu wan tauan. Tauane amba Demitias anega wadiamon, “Tatan gwanin, e asigiap nu kaisitoni garewa baware di warivin. ");
INSERT INTO dgz_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Go e asigiap, apan Pol me opata gapan anega wadiamuiwan, apan da nanip god nuga gueguewa kaisepiwa ame god da uon, ap opata wani gapan waenapan arugataet at Epesas gapan amba at Eisia paua gapan uruga oit ame anu tumasiwanum. ");
INSERT INTO dgz_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ap anu tumasepi menan waenapan guewa kaisitoni ya tambupen menan anuin. Amba koewa dawa ame waenapan nu god nuga baware Artemas amba me mup paewa ae antapenain. Nu at Eisia nagire piup iravi den god nuga Atemas aigap wa taragasivin, menan ap tapi ame koerage.” ");
INSERT INTO dgz_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Nop ame pa nagirewa den anune gapan, mu ugu gangan mutane amba mu ve erewa anega wan, “Nu pa Epesas nagirewa god nuga baware Atemas.” ");
INSERT INTO dgz_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ap anega wane menan pa iragi arara babara wa taiwanumun. Amba Epesas nagirewa Gaias ge Aristakas tambumone, mu Pol at Masedonia gapan tanam onamone apane waiwa. Pa nagirewa mu ai okonagen amba iam iam taine paewa gwanap toga uaren ta tauan. ");
INSERT INTO dgz_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pol anut mega to iam ame gapan wadidiamopen waenapan imumu wap bigarepen menan aet anun. Go Iesu dugup mega nagirewa me ya aepen menan watanane. ");
INSERT INTO dgz_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Amba at ame kansoro nagirewa upi, mu Pol evene wai, nop watu enan mup anega wane, “Enda, iam iam taine paewa ya age iwa mu togepi tawa.” ");
INSERT INTO dgz_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Iam iam paewa gapan waenapan iravi anu waramasene iwa upi itap wa atap wa taiwanumun. Waenapan aruga iam iam ame gapan tauane, iwa mu oare. ");
INSERT INTO dgz_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Diu nagirewa apan muga da yaua Aleksanda iam iam nagirewa namumup baraene, ap menan anu waramasene nagirewa anega anune, arara babara ibariwa apan ma me di. Aleksanda yone waenapan nop ae vep me gare wadiamopen menan naniwa wadaven. ");
INSERT INTO dgz_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Go wam ame iam iam nagirewa me ire yawane me Diu apanewa, menan mu iragi senao wa ge wa tan anega wan, “Nu pa nuga Epesas, god nuga Artemas me aigap iragen!” Ap anega senao waiwanumune amba wam airase dere uon tan. ");
INSERT INTO dgz_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Senao waiwanumune pa sewa kwayup ok sini apanewa baigan tapen men watanamo amba anega diamon, “Pa Epesas waenapan negawa, wapena anun. Waenapan iravi asik tane nu pa Epesas nagire god nuga baware Atemas mup paewa kwayup taitoni nagirewa. Gwat kimani viseni viriwa kwayupe den taivin. ");
INSERT INTO dgz_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Apan da nop ame ya waboboreta menan nop ae vean bumbawam da ya tane. ");
INSERT INTO dgz_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","E apan dere mam naumo onayan go mu god nuga mup paewa gwanap puraput da up ya tan, god nuga yaua da ya wa koeamen. ");
INSERT INTO dgz_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Demitias evene wai den apan da enu yave wat anupiwa ame wanene paewa watapane bawarewa nagirewa gwanap wanumam menan mugenat wat tamanamain. ");
INSERT INTO dgz_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Go nop da aigap sia wat anunewa, waenapan iragi ap mepe iamet amba nop ame sia wait. ");
INSERT INTO dgz_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Menan ma dimen taiwanin? Ibariwa nu oare. Bawarewa nugawa nu anan tat anu enu yawan wapi, nu gare anenen wait?” ");
INSERT INTO dgz_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ap anega wani iam iam tobore boge pa wa oimon. ");
INSERT INTO dgz_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Wam ame arak maken wane uon tani, Pol wadiamot nagirewa munan wan tauane amba dadak diamoni ewap, gaun wan boge at Masedonia aen. ");
INSERT INTO dgz_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","At Masedonia tau ge tau aiwandini Iesu dugup mega nagirewa iravi epara mun aiwandin eni amba at Guris tauen. ");
INSERT INTO dgz_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Ap mepe siragam yampo wandeni. Amba me kabum gagap at Siria aepen taiwandini gapan Diu nagirewa karaua me tot wane oisewa anuni menan ewagai entane at Masedonia aen. ");
INSERT INTO dgz_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Apan Sopata (mamewa Piras) at Beria apanewa Pol den aen. Apan upi tanamo aeni ame at Tesalonaeka apan dere Aristakas ge Sekundas, amba apan Gaias, Dobi apane, amba Eisia apane dere Toropimas ge Taitikas, amba Timoti den. ");
INSERT INTO dgz_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Apan ame namu pusimup amon pa Toroas tauane gapan nunan amat tan. ");
INSERT INTO dgz_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Go nu barip yaua Taba Buredi Tutut Ya Waini Baripe tugune ewap, ame nu kabum gagap at Pilipai aneton, amba wam nani yamunaet uon tani ewap, at Troas gapan apan upinewa ame tautanamoton, ap mepe mu den pura daiton tanam wanineton. ");
INSERT INTO dgz_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Pura ame ibariwa mum gine, taba buredi ame paise paise ta napen menan iameton. Ap mepe, Pol God nop mega waenapan wadidiamuiwandin. Me woup sese aet anuni menan nop nonongataet wa aiwandini mum gagewa tauen. ");
INSERT INTO dgz_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Pa ame diri gagap tune, nu watat aigapewa gwanap wanineton. Ap mepe dun aruga iran seane. ");
INSERT INTO dgz_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Orup apan da, yaua Yutikas, taik tonanewa gapan dore wande en. Pol nop nonongataet waiwandini gapan, Yutikas aup boniga ine beuren, pa diri gagap tune watat yampoa gapan onana visen. Waenapan vit amone ae ma warane go me gase boen. ");
INSERT INTO dgz_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pol yone vit ae, amba Pol ae geare Yutikas aigap ine bumagap wat nase anega wadiamon, “Gop ya anune me sia inakaen, kabani wandia.” ");
INSERT INTO dgz_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Anega wani amba pa sia dot ae, taba buredi paise nan. Nane nop nononga sia tanamo waiwandin woup seni amba me ae vemo aen. ");
INSERT INTO dgz_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Apan Yutikas kabani wat pa mega amon, ame gapan mu imumua bigaren, aton anune. ");
INSERT INTO dgz_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","14","Pol dianeni menan, nu namu pa Asos kabum gagap anetoni go Pol pusip aet anun. Pa Asos gapan Pol tautananen kabum gapan dotouen amba pa Mitilini aneton. ");
INSERT INTO dgz_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Sia anet inaton woup seni pa Kaios tauaton. Sia tau aneton, woup seni pa Samos tauaton amba wam use aigapewa anet pa Mailitas tauaton. ");
INSERT INTO dgz_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pol Pentikos baripewa menan serarat pa Ierusalem taut anuni menan me wam mega Eisia gapan ya wakaumat anun. Ap menan me pa Epesas daio ya tapen anun, menan pa Epesas ya tauapen menan nu kabum gagap negin garigat tau aneton. ");
INSERT INTO dgz_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Menan, pa Mailitas gapan, Pol Epesas Iesu dugup mega kwayup taine nagirewa onamopen menan sep watu enen. ");
INSERT INTO dgz_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Wam ame mu tauane, Pol mu anega diamon, “Wataget at Eisia namu tauana yaumakayap iningina amba endi den ap menan guegue nega iragi e asigiap. ");
INSERT INTO dgz_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","E anuyan, Diu nagirewa pot pot toguranegepen menan taiwanumune go ne ae bigat nigasen, irin den Ayop Iesu navewa taingin. ");
INSERT INTO dgz_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","E anuyan, pa ega ega gwanap wadidiaingina, ame ta warit noa iravi wadiaingina, karaua da ya baraen. ");
INSERT INTO dgz_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ne ian Diu ge ugupe nagirewa God mu koewa muga anu ae vepen menan mu namu vetavet wa amba Iesu anu tumasepen menan inamup aroga waingina. ");
INSERT INTO dgz_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","God Guewa Woup Seniwa ne pa Ierusalem anget dianegeni menan ne angewan go dim da ap mepe inanap tauepi, ame ne oare. ");
INSERT INTO dgz_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Go mame megenat ne asiginap, Guewa manega wadianegen, pa tau ge tau ongepena, ita anan, gwat ninoke megenat tautaningain. ");
INSERT INTO dgz_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Go dim da uon, ne etuna menan ya anuivin amba bop tawa den ya anuivin. Ne anut nega bawarewa ame nao nega Ayop Iesu neneni ame God No Oise Kakaewa, amba me garaet mega gueguewa, waenapan wadidiamopen, gapan nao nega taitamepen menan anuivin. ");
INSERT INTO dgz_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","E yaumakayap ise tau ase tau angingina amba God toemu mega amunewa oisewa wadiaena nagirewa go endi ne anuivin, da sia ya yawanegai. ");
INSERT INTO dgz_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Ap menan, ne nop bawarewa ma wapena e neman guran anun, e dim da wadiaena nop nega tandayasenewa, ame ek di, itan ne inanup da uon. ");
INSERT INTO dgz_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Iwa God anut ge tat mega iravi wadiaena, ne daiton da ya karaua baraen. ");
INSERT INTO dgz_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Menan e, Iesu dugup mega kwayup taiana nagirewa, yambuni wanien. God Guewa Iesu anu tumat nagirewa naniap seni menan kwayupe taiwanian iwa Iesu korosi gagap God aigaven tani gapan nunan boen. Ap menan Iesu dugup mega nagirewa kwayup taiwanian, sip kwayup taini apane mini. ");
INSERT INTO dgz_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Wapena anun, ne ae veae angepena ewap, apan upi okoi wasipen mini tauain. Enan bagu sisi mu ya anuin go Iesu dugup mega nagirewa gure oimop ewai amoin. ");
INSERT INTO dgz_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Amba waenapan ega da da Iesu wadiamot negin mega ame ae veapen menan ebo aopan wain amba Iesu dugup mega nagirewa upi naumo negin ugup amoin. ");
INSERT INTO dgz_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Ap menan, yama taiwanian, ne enan tana anu nimanek wanian iwa enan en yampo gwanap mum ge woup irin den e iragi wadidiaingin. ");
INSERT INTO dgz_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Endi God nani gwanap seaivin. God nop mega gapan garaet ta warit imaeni ame gapan kwayup taep. Nop mega ame batnagene gapan aro tai. Ap gapan den God wat aipakam mega iravi tanai, wat aipakam ame God waenapan mega munan. ");
INSERT INTO dgz_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ne gwat make go wanup ega da yawana ame imuna ya waren. ");
INSERT INTO dgz_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Menan, e di anu awan, ne naninap nao taingina gapan evena wainan den iningina dim da menan anuintoni, garewa ne taingin. ");
INSERT INTO dgz_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Nao kaimakaet ap taingina gapan ne to ewaena ame nu aro uoni nagirewa ta warit mumapen. Menan Ayop nuga Iesu wani anu nau aninan. Me anega wani, ‘Nu wan dim dim waenapan ase munata, ame aton aigap tautanait, go waenapan wan dim dim nunepiwa ame aton gauarap tautanait.’” ");
INSERT INTO dgz_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pol nop mega uon tani ewap, omanip enun waenapan den God inap mup wan. ");
INSERT INTO dgz_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ame gapan mu iragi iri den Pol waran gaune tan ua ton. ");
INSERT INTO dgz_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Pol evi sia ya yavepi nopewa wadiamoni menan, mu bagu sisi baware anun. Menan Pol kabum gapan watu enapen menan, tanan amon. ");
INSERT INTO dgz_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Waenapan den gaun gare gare tatoni amba bagu sisi baware den ae vemot aneton, nu kabum gagap dotouat tamana ane pa Kos tauaton. Inaton, woup seni anet at Rodes tauaton, amba anetoni pa Patara tauaton. ");
INSERT INTO dgz_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ap mepe, kabum da ugup sia at Ponisia aepen tan menan nu ame gagap dotouat aneton. ");
INSERT INTO dgz_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Puiman topaneni at Saiparas senip arige gapan ase yawatoni amba mainep tau at Siria menan di aneton. Nu pa Taya tauat amba ae vitaton iwa kabum i nagirewa puraput muga ap mepe ae seat anune menan. ");
INSERT INTO dgz_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Iesu dugup mega nagirewa yomu tat yawamotoni ame pura daiton den ap mepe tanam wanineton. God Guewa anenen Ierusalem gapan Pol inap venasepiwa wadiamoni menan Iesu dugup mega nagirewa Pol pa Ierusalem ya aepen dian. ");
INSERT INTO dgz_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Daio nuga wamewa uon tani, ame nu ae vemot sia aneton. Iesu anu tumasine apane, waene otu wai den tanamo pa sewa aveat amba puiman etop gerata omaninup enut mup waton. ");
INSERT INTO dgz_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Amba gaun gare gare ta watoni ewap nu kabum gagap dotouaton, amba mu ewagai pa amon. ");
INSERT INTO dgz_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Pa Taya ae veat ap sia anet pa Tolemas tauaton. Iesu dugup mega nagirewa yawamot gaun waton amba wam daiton mu den wanineton. ");
INSERT INTO dgz_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Inaton woup seni anet pa Sisaria tauaton amba oise kakaewa waini apane Pilip pa mega gapan wanineton. Namua, pa Ierusalem Iesu dugup mega nagirewa, Pilip waenapan agim make yan se munapen amba Iesu dugup mega nagirewa kwayup tamopen menan om enun. ");
INSERT INTO dgz_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Pilip ore waiwa, ame degede waenoro ini denawa ap mepe wanumuinewa. Mu God nop mega opata gapan wainewa. ");
INSERT INTO dgz_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Ap mepe wam animpo da waninetoni God nop mega waini apane da yaua Agabas at Diudia gapan vit oneni evi venasepi oisewa namu wan. ");
INSERT INTO dgz_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Inanup taue amba Pol berip kankamup panini ware mek pusi nani paneni amba evi venasepen noa namu anega wadien, “Guewa Woup Seniwa anega waiwan, Berip mame panana mini Ierusalem Diu nagirewa apan Pol ware panain amba ian ugupe nani gwanap barain.” ");
INSERT INTO dgz_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Nop ma anutoni gapan, pa nagirewa amba nu den, Pol pa Ierusalem ya dot aepen menan nu irin den watanaton, Pol anega diaton, “Apan nugawa, ge Ierusalem ya agai.” ");
INSERT INTO dgz_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Go Pol gare anega wan, “Iwa dimen e iragi iri den anega potana todum wadum taiwanin? Ne pananegepi megenat ya anuivin, go den pa Ierusalem gwanap Ayop Iesu menan bonigasepen menan anuivin.” ");
INSERT INTO dgz_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Nu watanaton go me epara ta di aet anun, ap menan nu ae veat anega waton, “Umap, God anuni gapan venasep.” ");
INSERT INTO dgz_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Wam animpo amba nu puraput nuga, sese kakayat tat, amba pa Ierusalem dot aneton. ");
INSERT INTO dgz_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Iesu wadiamot nagirewa upi pa Sisaria gapan tauan tautananen, amba naunen apan Neson, at pa mega anet den waninet wan. Neson at Saiparas gapan taueni apanewa amba me Iesu erewa gapan anu tumat tani apanewa da. ");
INSERT INTO dgz_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Pa Ierusalem tauatoni gapan Iesu dugup mega nagirewa atonu den waup nimanen. ");
INSERT INTO dgz_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Inaton woup seni Pol amba nu iragi apan Diemis inap daio aneton. Ierusalem Iesu dugup mega kwayup taine nagire amena Diemis den tanam wanumon. ");
INSERT INTO dgz_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pol gaun inamup wani amba God aro waneni gapan Diu uoni nagirewa yaumakamup nao mega taiwandini oisewa wadiamon. ");
INSERT INTO dgz_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Mu nop ma anune, mu God wa atonasen. Amba mu Pol inap anega wane, “Tatan Pol, mapa Diu nagirewa arugataet Iesu anu tumasene, amba God iup mega tantanewa waiwanum, ame ge asigigap. ");
INSERT INTO dgz_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Go mu ge oitaga anega anune, ame ge ian ugupe at muga gapan wanumuine Diu nagirewa iravi Mosis iup namua seni amba Diu gutut nuga tat mega ae veapen amba orup apan etua muga paua tum ya tapen wadidiamuingiana, ap anune. ");
INSERT INTO dgz_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ge mapa tauana oisewa mu di anuin, ap menan ge dim da tai? ");
INSERT INTO dgz_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Menan nu wadiageta gapan ta. Apan degede mapa mu agi God inap wane. ");
INSERT INTO dgz_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Mu imumu woup sepen menan God yamap paua tapi, ge den tanam ta. God garaet wanat anune garewa ge munan se amba mu i gume ware ae seain. Boge Diu nagirewa iragi anu awain oit gega namu anune tavewa uon, go gek ingane Mosis iup namua seni ayamase taiana apanewa. ");
INSERT INTO dgz_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Go Diu uon, ian ugupe Iesu anu tumasine nagirewa guegue nuga iragi ya tapen menan ok manega inamup enuton, Waenapan nanimup god eboewa guewa kaitane ameme antaba wat irine god muga munapen ame tabaewa ya nane. Amba man deniwa ya nane. Amba man mege wat imokaminewa ya nane. Amba waen ge apan wainan gogo ya tane.” ");
INSERT INTO dgz_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Pol apan degede ame den tanam ae inen. Woup seni imumu God yamap woup sepen menan paua tan. Tane God Paewa unuk ae agi wane gueguewa wam ansena gapan uon tapi amba God menan man irinewa oisewa den pa nagire wadiamon. ");
INSERT INTO dgz_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Wam ame pura daiton uon tapen taiwandini, at Eisia Diu nagirewa, upi God Paewa gwanap Pol yawan. Menan waenapan ame uruga anan datnak mumane Pol waran. ");
INSERT INTO dgz_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Mu senao anega wane, “At Isurero apane wai tawarit nimanen! Apan mam, at at iravi tau ge tau aiwandini, waenapan iravi nu Diu nagirewa tandaya nimanen amba Mosis iup seni ae veapen amba God Paewa gapan tandae den wadidiam wandin. Amba den Diu uoni nagirewa, tambun God Paewa mapa naumo onen. Ap tani God Paewa, virip arewa mame wabigimen!” ");
INSERT INTO dgz_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Mu ap anega wane iwa mu at Epesas apan da yaua Toropimas, Diu uoni apanewa, Pol den pa Ierusalem tauane yawamo anega anun, Pol apan Toropimas den God Paewa gwanap amone. ");
INSERT INTO dgz_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Menan arara babara wane, pa nagirewa iravi toga uaren tan tauan, Pol okokok warupan God Paewa garip tau amon. Boge, God Paewa tonan amase taine nagirewa God Paewa tonan iravi toboramon. ");
INSERT INTO dgz_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ierusalem nagirewa Pol top boepen taiwanumune arara babara waiwanumune oisewa at Rom ita nagirewa baware mugawa inap tauen anun. ");
INSERT INTO dgz_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Me oit ame anuni gapan, menawaet ita yame bawarewa upi amba gauarapewa nagirewa tambu serarat waenapan to iam ame nimakamup tauan. Waenapan Pol toiwanumune gapan ita nagirewa yawane menan Pol ae veane. ");
INSERT INTO dgz_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ita yamewa Pol inap taue damik dere kaimake dena gapan Pol panapen diamon. Panane amba ita yamewa apanewa singui wayaven, “Apan ma da? Me koewa dim da tan?” ");
INSERT INTO dgz_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","To iam ame gapan upi nop senao waiwanumun amba upi senao ugup waiwanumune. Arak maken mame gapan ita yamewa tavewa yope tan, go Pol dim da tani me ya anun. Ap menan ita nagirewa Pol warupe pa muga amopen diamon. ");
INSERT INTO dgz_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Wat amone, nesip gine tauane gapan waenapan arugataet guguk wa tauane menan Pol paina ao waran dot amon. ");
INSERT INTO dgz_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Pa nagirewa, Pol evip onamone kaimakaet ve anega waiwanumun, “Toguran wat aisen!” ");
INSERT INTO dgz_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Ita nagirewa Pol pa muga gwanap wat amopen taiwanumune gapan, Pol ita yamewa inap anega singui wayaven, “Ne nop inagap wapena, umap?” Ita yame ame gare anega wan, “Ge nop Gurik waiana apanewa? ");
INSERT INTO dgz_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Go ne anuna ge at Idip apane anun. Apan ame watageta Rom kansoro nagirewa inamup tandayasiwandin anan datnak mumeni amba 4000 ita nagirewa naumo at kaimewa aen, ge apan ap me go?” ");
INSERT INTO dgz_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pol gare wan, “Ae, ne ap da uon. Ne Diu apanewa at Silisia pa sewa Tasas gapan yanan. Ne pa sewa bawarewa ame apanewa. Ne waenapan wadiamot anuivin, ame umap go?” ");
INSERT INTO dgz_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Ita yamewa umap wani menan Pol nesipa yone waenapan nop ae veapen menan naniwa ao wadaven. Wam ame mu nop ae veane, me Iburu nop muga gapan inamup nop wan. ");
INSERT INTO dgz_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Pol anega wan, “Maman wainawa, tatan gwaninawa, enu yawanegean waiana garewa wapena anun.” ");
INSERT INTO dgz_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Nop muga Iburu gapan wani menan waenapan nop iragi ae vean. Pol sia anega wadiamon, ");
INSERT INTO dgz_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Ne Diu apanewa, at Silisia pa sewa Tasas gapan yanan. Go ne Ierusalem gapan kai waran baware tan amba wadianegeni apanewa ame Gamelio, nu omayan bae iup muga baware ame seane wadidianegeni anu kakayasen. E endi God menan amunugaet taiwaniana ap umap ne taingin. ");
INSERT INTO dgz_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Iesu anu tumat negin megawa gapan amuine nagirewa ne wa koeragam mumingin amba upi borit wane. Amba waenapan ame kaimakaet tambun panamon amba gwat noke semuingin. ");
INSERT INTO dgz_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Ne oitana mame pirisi baware mugawa amba kansoro nagirewa iragi mu asigimup, ne tave di waivin mu den wain. Mu inamup namu yoyo ogewa seanewa tambun. Ap me tambuna menan Damaskas angena. Iesu anu tumasine nagirewa, waen ge apan ap mepe da wanumopi, damiga panamo aibu okonak pa Ierusalem ewagai entan ongepen menan angen. ");
INSERT INTO dgz_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Wam ianupe mini ne Damaskas neginewa angen pa Damaskas maningina gapan, dun ganat baware da kimani aoma gamunap enun ganasewa inan mainen bararaen. ");
INSERT INTO dgz_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ne piupa geanegena nop anuna anega wani ‘Sol, Sol dimen ta koeragam nimanegingi?’ ");
INSERT INTO dgz_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ne gare wan, ‘Ayop, ge da?’ Ayop anega wan, ‘Ne Iesu at Nasaret apanewa ta koeragam nimanegingi.’ ");
INSERT INTO dgz_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Mu tanam ongena nagire nop wani da ya anune, go mu ganat megenat yawane. ");
INSERT INTO dgz_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ne gare wan, ‘Ayop, ne anenen tain?’ Ayop gare anega wan, ‘Ao yon Damaskas ak, ap mepe orup da wadiageta.’ ");
INSERT INTO dgz_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ne tanam ongena nagirewa nanimup waranegene at Damaskas aneton, iwa kiman kapesiewa enun menan yaman borasen. ");
INSERT INTO dgz_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Apan yaua Ananayas ap mepe wanden. Me God menan anun taini apanewa, Diu iup nuga ayamase taiwandini, Diu pa Damaskas nagire iravi ayamat tainewa. ");
INSERT INTO dgz_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ananayas ne inanap tauen. Me inanap yone anega wan, ‘Gwaninawa Sol, yangut sia ta.’ Boge yangut tana, ase me yawan. ");
INSERT INTO dgz_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Me anega wan, ‘Wataget omayan bae God mugawa om enu geneni navewa tapen, den Apan Tamanawa ire yawapen, amba nop mega wapi anupen. ");
INSERT INTO dgz_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Dim da ge yawa anuanawa oisewa waenapan inamup wa senamepen menan. ");
INSERT INTO dgz_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Endi, dimen nononga tait? Ao yon, dup iagepen ge koewa gega bigi warep.’ ");
INSERT INTO dgz_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Wam animpo ewap ne pa Ierusalem entan angena, God Paewa gwanap, God inap mup waingina ame gapan bet inan yawan. ");
INSERT INTO dgz_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Ne Ayop yawana me anega dianegen, ‘Menawaet at Ierusalem ae di ve ak iwa ge guturana waingawa mu noga ya di anu warain.’ ");
INSERT INTO dgz_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ne gare wan, ‘Ayop, mu asigimup Diu opata waine paewa gwanap tau ge tau angena mu da da anu tumat gimagine nagirewa gwat nokap semon guramuingin. ");
INSERT INTO dgz_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Amba wam ame oitaga waini apane Sitiven togurane boeni ame ne ap mepe den yonan yawamon umap wan. Amba Sitiven toguriwanumune nagirewa wanup muga ne amat taingina. Menan ne nop nega warain.’ ");
INSERT INTO dgz_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Ayop sia dianegen, ‘Ge at wandap ian ugupe nagirewa inamup watu enagepen, ak!’” ");
INSERT INTO dgz_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Waenapan Pol nop mega anuiwanumune, go mu nop uiwa ame Ayop me Diu uoni nagirewa inamup aepen dieni anune menan mu sia nop ya anut anune amba nomu ainagasen amba senao anega waiwanumun, “Piup ma gapan me wat mutan! Me tone boep! Me wande wande umap uon!” ");
INSERT INTO dgz_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Mu senao waiwanumune, wanup aigape muga totnak ase uatamen amba ugu gangan anune menan piup ataboboewa tam ao uatam wanumun. ");
INSERT INTO dgz_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Ita yamewa Pol ware pa muga amopen diamon. Ita nagirewa Pol waran pa gwanap amone. Gwanap tauane, Diu nagirewa Pol inap ugu gangan anu senao manega waiwanumune tavewa anupen menan ita yamewa Pol gaut gapan kaimakaet topen diamon. ");
INSERT INTO dgz_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Mu naniwa endimasen gaura topen di taiwanumune gapan, Pol ita apanewa, amena yoniwandini, anega dien, “Ne at Rom gapan aro warana apanewa, koewa da ya tan. E ya wayawanegean amba tonegepen taiwanin? E at Rom iupewa da topaisiwanin.” ");
INSERT INTO dgz_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Wam ame ita apanewa nop ma anuni, me ae ita yamewa inap singui anega tayaven, “Apan ame nu at nuga Rom apane da. Ge dim da tai?” ");
INSERT INTO dgz_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Ap menan ita yamewa ae Pol inap singui anega wayaven, “Wadianek, ge at Rom apanewa da go?” Pol gare wan, “E, ne ap me di.” ");
INSERT INTO dgz_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ita yamewa Pol inap sia dien, “Ne agim make baware at Rom i nagirewa munana gapan ne at Rom entan nimanegen.” ");
INSERT INTO dgz_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Pol gare wan, “Go ne at Rom gapan yanana apanewa.” Pol wani boge ita nagirewa iravi tap anun ae ve asira amon. Ita yamewa den tap anun iwa Pol, at Rom apanewa, damiga panane menan. ");
INSERT INTO dgz_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Inane woup sen. Ita yamewa Pol damik vese amba tavewa anu kakayasepen menan Diu kansoro nagirewa iam iam tapen diamon, Pol singui wayawapen menan. Diu kansoro nagirewa iam iam tauane gapan, me Pol ware taue wan, mu namumup yonen. ");
INSERT INTO dgz_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pol kansoro nagirewa ame kem kem yawamoni amba anega wadiamon, “Tatan gwaninawa, ne wataget amba endi den God ne asigip tan. Ne imuna bigaren, ian guine kakaewa gapan ne koewa da ya tan, mame tauan nop waivin.” ");
INSERT INTO dgz_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Anega wani menan pirisi aritawa mugawa, apan yaua, Ananayas, Pol mainep wanumuine nagirewa Pol no to ponamepen diamon. ");
INSERT INTO dgz_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Tone boge Pol gare wan, “Oma gega etua yavingi go posewa ya yavingi. Garewa God amba togep. Ge iup nuga gapan wanene tanegepen menan amena wanik agi, go ne toneget diamoana ame iup nuga paina yamasean.” ");
INSERT INTO dgz_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Pol mainep yoniwanumune nagirewa Pol anega dian, “Ge iwa dimen God pirisi baware mega, ayop nugawa wa koeamingi?” ");
INSERT INTO dgz_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pol gare wan, “Kaiwan, tatan gwanin, me bawarewa nugawa ap me, ne ya anun. God nop mega anega seane, ‘Ge waenapan ayop mugawa ya wa koeame.’” ");
INSERT INTO dgz_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Boge Pol kansoro nagirewa dugup dere Parisi amba Sadusi nagirewa ap mepe iam wanumone anuni menan, kansoro nagire inamup anega wan, “Tatan gwanina, ne mamana dugup mega Parisi amba ne den dugup Parisi apanewa. Ne anu dao nega ame borit wane nagirewa God inakam mumepi sia yon wanumopi anu tumasivin menan endi mame wanene tanek wanin.” ");
INSERT INTO dgz_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Wani boge dugup Parisi ge Sadusi nagirewa ere notatae waiwanumune menan kansoro nagirewa seu endumane. ");
INSERT INTO dgz_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","To iam ame to dumane iwa mega dugup Sadusi nagirewa anega anu tumat taiwanum, ame borit wane nagirewa God sia inaka mumep yon wanumopen da den uon amba anea o guewa gine ugup ugup da uon, anut muga ap anega. Go Parisi nagirewa ap iravi anu tumat taiwanum. ");
INSERT INTO dgz_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ap menan nop baware da verat mutan wane, amba Parisi nagirewa upi iup wadidiamuinewa, mu ao yonan garewa kaimakaet anega wan, “Nu apan ma koewa dim da tani nu ya yavivin. Nu anuivin anea da, o guewa da, me inap nop wan!” ");
INSERT INTO dgz_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Notatae baware gare gare wan amba toto mutapen taiwanumune menan ita yamewa Pol menan tap anun iwa kansoro nagirewa Pol yamu yamu wa totomagepi tawa. Ap menan ita nagirewa diamoni, anan taine nagire yaumakamup vit amon, Pol waseamon ita nagirewa pa muga amon. ");
INSERT INTO dgz_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Mum ame gapan, Ayop Iesu Pol inap taue anega wan, “Aro ta wanik! Pa Ierusalem gapan oitana waingiana mini pa Rom gapan den oitana waingan.” ");
INSERT INTO dgz_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Inane woup seni ame Diu nagire Pol togurapen menan nope karaua panan. Muk nop anega barimen wan amba taba ge kaum ya napen menan virip tan amuiwanumun, Pol togurepi amba nain. ");
INSERT INTO dgz_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Nop karaua panan togurapen wane nagirewa apane dere (40) amba aigap den sia. ");
INSERT INTO dgz_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Mu amon, pirisi bawarewa amba dima waine nagirewa anega wadiamon, “Nu wa agi kaimakaet God yaua gapan tatoni ame nu dim da ya nait go aninan, Pol togurat boepi amba taba ge kaum nait. ");
INSERT INTO dgz_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Menan e ge kansoro nagirewa den at Rom ita nagirewa bawarewa mugawa inap nop manega watu enane. Pol gutut mega wap anu kakayasepen menan ita nagirewa Pol wat onamop. Aopan anega wane amba wat onam wanumampina, Pol togurapen menan nauase waninait.” ");
INSERT INTO dgz_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Go Pol wanugewa, apan tamaru da, nop ma paniwanumune anuni me ae ita nagirewa pa muga unuge Pol oit wadien. ");
INSERT INTO dgz_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Boge Pol ita apane vene wan oneni amba anega wadien, “Tamaru ma ware ita yamewa ine ak, me oit da wadiat anuiwan.” ");
INSERT INTO dgz_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ap menan ita apane ame, ita yamewa inap taue anega wan, “Waratoni apanewa Pol nenan wan amba orup mame ge inagap wat ongepen wan iwa nop da wadiagepen anuiwan.” ");
INSERT INTO dgz_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ita yamewa Pol wanugewa nanip wat nau asirantu amon mugenat wanumone singui wayaven, “Ge dim nop da wadianegepen tauaan?” ");
INSERT INTO dgz_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Pol wanugewa gare anega wan, “Wam imanawa Diu nagirewa ge diagep Pol wara kansoro namumup tauapen menan wawa mutane ame Pol mu inamup nop wap anu kakayasepen menan aopan aopan waiwanumun. ");
INSERT INTO dgz_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Go mu nop muga ya anu iwa apan muga apane dere (40) amba aigap den, Pol togurapen menan nauat ponamene, negina wanumamun. Mu God yaua gapan agi kaimakaet wawa mutane ame taba ge kaum ya nain, Pol togurepi amba nat wane. Endi mu gaseget nauat wanumam, nop gega amase taiwanum.” Pol wanugewa ap anega wan. ");
INSERT INTO dgz_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Ita yamewa anega wan, “Oit ma wadianegeana ame waenapan da sia ya wadiamo.” Amba Pol wanugewa watu enen, aen. ");
INSERT INTO dgz_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Ita yamewa ame, ita apane dere venamu wan tauane, amba nop anega wadiamon, “Ita nagirewa iragi 200 amba man hosi gagap amopi nagirewa apane yampo aonagaet (70) amba ita tambupi nagirewa 200, muma aup ina ina wamewa gapan pa Sisaria di amop. ");
INSERT INTO dgz_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Man osi Pol menan wanan, e den hosi gagap kwayup ta aisen, Ayop Pilik ine tauan.” ");
INSERT INTO dgz_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Amba ita yame ame ok da manega enun, ");
INSERT INTO dgz_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Kaewa kaewa, ayop nega Pilik ge bawarewa negawa, ne yauna Kolodias Laisias. ");
INSERT INTO dgz_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Diu nagirewa apan ma ware togurep boepen taiwanum. Go me at Rom apanewa da anuna menan ita nega nagirewa den anet waseam onanton. ");
INSERT INTO dgz_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Mu dimen enu yawan waiwanumune, ame anu kakayaset anuna menan, Diu kansoro nagirewa muga namup Pol wat nau angen. ");
INSERT INTO dgz_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ange tauana anun, koewa mega boe boe o gwat noke bare bare tani iwa mega da ne ya anuna. Go Pol inap singui yasiwanumune ame Diu nagirewa iup muga gapan taiwanumun. ");
INSERT INTO dgz_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Mu karaua togurat anune oisewa anuna menan inagap watu eniangin. Diu nagirewa sia enu yawat anupi ge namugap yone wapen menan ne Diu nagirewa ap anega diamon. Ok nega otu mame uon tan.” ");
INSERT INTO dgz_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Ap gapan ita nagire ayop muga diamoni gapan Pol waran muma amon, pa sewa Antipatis tauan. ");
INSERT INTO dgz_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Inane woup sen, ita nagire ame pusimup onamone ae vemon, ewagai entanan pa muga, Ierusalem sia amon. Man osi gagape nagirewa mugenat Pol den amon. ");
INSERT INTO dgz_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Pa Sisaria tauane, bawarewa ayop Pilik inap tauane amba ita bawarewa muga ok enuni ame wanane amba Pol me nanip gwanap baraen. ");
INSERT INTO dgz_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Ayop Pilik ok ame batnageni amba Pol singui tayaven, “Ge at ansena gapan tauan?” Pol gare wan, “Ne at Silisia apanewa.” ");
INSERT INTO dgz_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Amba Pol inap anega wan, “Ge enu yawagen wane nagirewa mapa tauepi ame gapan wanene tagain.” Wani amba Erot pa mega namua gwanap Pol yambuni wandepen menan, ita mega nagirewa kwayup tat diamon. ");
INSERT INTO dgz_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Wam nani yamunaet uon tani ewap, pirisi bawarewa aigamupewa, yaua Ananayas, amba dima waine nagirewa upi, tanamo pa Sisaria vit amon. Mu wanene noa tamanamini apanewa, yaua Totalas, den amone. Pa Sisaria tauane amba ayop Pilik namup yonane, apan Pol koewa taini oisewa wap anupen menan. ");
INSERT INTO dgz_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Wam ame Pol vene wane pa gwanap unuk aeni gapan apan Totalas Pol koewa tani oisewa ere anega wan, “Bawarewa nugawa, apan Pilik. Nu nonup gega gauarap aton nonongataet di ta onaninton, nunan anuana menan nu koewa nuga aruga wat tamanam nimanean. ");
INSERT INTO dgz_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Ap taingiana menan nu pot pot atonuga den gaun baware inagap anuivin. ");
INSERT INTO dgz_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Go wam gega ya wakaumat anuivin menan baguga inanup anu ame nop nuga otu mame ge anupen menan nu mup inagap waivin. ");
INSERT INTO dgz_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Apan Pol mam, me koerage iragen yawaton. At at iragi amba Diu nagirewa den anan tapen menan nanam mumiwandin. Me anu tumat dugupewa, yaua Neserinis, God inap ebo aopan anuine apanewa da. ");
INSERT INTO dgz_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Apan Pol mame, Ierusalem gapan God Paewa wa koeamet wani menan nu waraton. ");
INSERT INTO dgz_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Iup nuga gapan wanene tat anuton go ita yamewa apan Laisias taue kaimakaet naninup wasean aen. ");
INSERT INTO dgz_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Sia enu yawat wat anutoni namugap yonapen dianen. Ge Pol singui wayawawa dim dim iravi enu yawat watoni oisewa wadiagep anui.” ");
INSERT INTO dgz_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Totalas Pol ap anega digureni gapan, Diu nagirewa den anega wan, “E, nop mega tavewa di waiwan.” ");
INSERT INTO dgz_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Ayop Pilik, Pol me inap nop wapen menan nani piru tan. Pol gare anega wadien, “Nu anuivin ge en arugataet at nuga gapan wanene taingiana menan namugap yonan, nop muga garewa wadiagepen menan ne atonu den wadiagain. ");
INSERT INTO dgz_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Waenapan wayawamoa, ame mu wap anui, nu wam garinup aeni, wam aonagaet pusi nawan dere megenat gapan, God wa taragasepen menan Ierusalem dot angen. ");
INSERT INTO dgz_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","God Paewa gwanap o Diu opata waine pa gwanap o Ierusalem gapan, at ap me gapan notatae da ya waingin amba waenapan anan ya datnak mumingin. ");
INSERT INTO dgz_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Endi mondi enu yawanegene waiwanum go tavewa da mu ya wadiagain. ");
INSERT INTO dgz_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Go nop daiton gapan mu tavewa di waiwanum, ame ne Iesu anu tumat neginewa gapan God, nu omayan bae God nugawa, ne wa taragasivin. Go Iesu anu tumat neginewa ame mu aopan dian Apan Mosis iup megawa ge God noa wataget waiwanumune nagire ok seane den ne anu tumasivin. ");
INSERT INTO dgz_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Ne waenapan mame taine mini ne anu dao God inap taivin. Anu dao tavewa ame, waenapan kakaewa amba waenapan koewa, mu iravi borit wane evi wam uiwa gapan inak muse sia yon wanumoin. ");
INSERT INTO dgz_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ap menan, ne God ge waenapan namumup bigat nigat wanik wanigepen taivin menan pot pot wa panan di ta dorivin. ");
INSERT INTO dgz_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Amba ne en animpo mini pa Ierusalem gapan ya waingena menan, ne yan garaet waenapan nega, Ierusalem gapan munat anuna menan wat ongen. Den man da God inap gura irat anun. ");
INSERT INTO dgz_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Ame gapan ne God yamap imuna woup sepen paua tan. Guegue ame taingina waenapan mame yawanegene. Ap gapan ne inanap, waenapan da ap mepe ya iame amba dim da da koewa ya taiwanumune. ");
INSERT INTO dgz_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Go Diu nagirewa at Eisia gapan wanumuine ap mepe den yawanegen. Tandayat nimanegene mu mapa namugap tauapo enu yawanek wapo. ");
INSERT INTO dgz_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Go ian ame ya tauane menan, Diu nagirewa mapa ne wataget kansoro nagirewa namumup yonan menan koewa nega da yawane endi ame wadiagep. ");
INSERT INTO dgz_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Go namumup yonana, nop daiton megenat kaimakaet manega wan, ‘Ame borit wane nagirewa evi inak muse sia yon wanumot anuna menan endi e wanene tanek wanin.’” ");
INSERT INTO dgz_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Boge, ayop Pilik, me Iesu anu tumat neginewa asigip tani menan wanene ame toborat anun, amba anega wan, “Ita yamewa yaua Laisias mapa tauepi amba ge koewa da taan go uon ame ne amba wadiagain.” ");
INSERT INTO dgz_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Menan ita nagirewa mega ame Pol kwayupe yambuni tapen dien go ap ap otu da aet anupi me ya watanep. Pol dimen anuni evene wai taue wanep. ");
INSERT INTO dgz_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Wam animpo amba ayop Pilik waenewa, ame Diu waen da yaua Durusila, dere tauan. Pol menan wan taueni amba Pol Iesu Keriso inap anu tumasepi gueguewa wadiamoni mu anune. ");
INSERT INTO dgz_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Pol inak tamanawa, ingane wat tamanam, amba wanene wam evi tauepi gueguewa ugup ugup mam waiwandini menan, ayop Pilik tap anu amba anega dien, “Endiwa menan ame umap! Ganawan ak. Ne nao nega wamewa arok da wandepi ame ne nop sia genan watu enain.” ");
INSERT INTO dgz_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Pilik Pol gwat ninoke ae veapen menan agim make da garaet karaua wanat anuiwandini. Menan pot poraet nop dere gare gare waiwanumun, go Pol agim make da ya wanen. ");
INSERT INTO dgz_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","En dere uon tani, ayop Pilik nao da ugup aen. Garewa mega Posias Pestas tauen, uewa waren. Pilik Diu nagire me yaua ao warapen menan Pol gwat nokap di wandet wa ae ve aen. ");
INSERT INTO dgz_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Apan Pestas, Pilik uewa wareni gapan, wam yampo ewap, pa Sisaria ae ve amba pa Ierusalem dot aen. ");
INSERT INTO dgz_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Ap mepe, pirisi baware nagirewa amba Diu namu yoyo nagirewa, 