﻿USE sofia;
DROP TABLE IF EXISTS sofia.dgc_vpl;
CREATE TABLE dgc_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES dgc_vpl WRITE;
INSERT INTO dgc_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Saye i listaa du apo-apo ni Jesu Cristo a gébwat ta lahi ni Dabid, a lahi be ni Abraham. ");
INSERT INTO dgc_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ti Abraham i ama ni Isak; ti Isak i ama ni Hakob, a siya man dén i ama de Huda a pépétwadi. ");
INSERT INTO dgc_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ti Huda i ama ni Pares sakay ni Sara (ti Tamar i ina de). Ti Pares i ama ni Esrom, éy ti Esrom éy ama ni Aram. ");
INSERT INTO dgc_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ti Aram i ama ni Aminadab; ti Aminadab i ama ni Nason; ti Nason i ama ni Salmon; ");
INSERT INTO dgc_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ti Salmon i ama ni Boos (ti Rakab i ina na). Ti Boos i ama ni Obed (ti Rut i ina na). Ti Obed i ama ni Hese, ");
INSERT INTO dgc_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","at ti Hese i ama ni Hari Dabid. Sakay ti Dabid i ama ni Solomon (tu ina na éy tu dati a asawa ni Urias). ");
INSERT INTO dgc_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ti Solomon i ama ni Roboam; ti Roboam i ama ni Abias, at ti Abias i ama ni Asa. ");
INSERT INTO dgc_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Nadid, ti Asa i ama ni Hosapat; éy ti Hosapat i ama ni Horam, a siya i ama ni Osias. ");
INSERT INTO dgc_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ti Osias éy siya i ama ni Hotam, a ama man dén siya ni Akas; at ti Akas i ama ni Esekias. ");
INSERT INTO dgc_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ti Esekias i ama ni Manases; ti Manases i ama ni Amos, a siya i ama ni Hoseas. ");
INSERT INTO dgc_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ti Hoseas i ama de Hekonias a pépétwadi. Nadid, saya tu panahun a nipéngiagton du Judeo ta Babilonia. ");
INSERT INTO dgc_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nadid, to kéagton de ta Babilonia, éy naging anak ni Hekonias ti Salatiel. Sakay ti Salatiel i ama ni Sorobabel. ");
INSERT INTO dgc_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ti Sorobabel i ama ni Abiud, a siya i ama man dén ni Eliakim; at ti Eliakim i ama ni Asor. ");
INSERT INTO dgc_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ti Asor i ama ni Sadok; ti Sadok i ama ni Akim; ti Akim i ama ni Eliud. ");
INSERT INTO dgc_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ti Eliud i ama ni Eleasar; ti Eleasar i ama ni Matan, a siya i ama ni Hakob. ");
INSERT INTO dgc_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Sakay ti Hakob i ama ni Hose a asawa ni Maria. Ey siya i ina ni Jesus a ngéngahinan de a Cristo. ");
INSERT INTO dgc_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Samakatuwid, éy sapulu éy ta épat a salin a lahi sapul ni Abraham a hanggan ni Dabid. Sakay sapulu be éy ta épat a salin sapul ni Dabid a hanggan ta panahun a niagton side ta Babilonia. Sakay sapulu be éy ta épat a salin sapul to kéagton de ta Babilonia a hanggan ni Cristo. ");
INSERT INTO dgc_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Nadid, kona se i pinéngienaka ni Jesu Cristo. Ti Maria a ina na, sakay ti Hose, éy nagkasundu dén side a magasawa. Pero bagu side nagagum, éy méngilog dén ti Maria. (Saya i gimet na Banal a Espiritu.) ");
INSERT INTO dgc_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ey ti Hose a maging asawa na, pékabaheta na a méngilog dén siya, éy talaga na siya a hiwalayan, pero lihim san, monda éwan masanike ti Maria ta harap na banuwan. Mahusay tu ugali ni Hose. ");
INSERT INTO dgc_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nadid, pégisip-isip na pabi ta éya, éy nipatagenép diya i esa a anghel, a kinagi na kan diya, a “Hose, diyan ka méganteng. Tulosén mo san a asawan ti Maria, dahilan i ilog naa éy gimet ina na Banal a Espiritu. ");
INSERT INTO dgc_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Magenak siya ta lélake. Ey ta pégenak na,” kagi na, “éy ngahinan mo siya ni Jesus, da siya ngani i méngiligtasa du sakup na a tolay ta kasalanan de.” ");
INSERT INTO dgc_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nadid, nanyari ya de Maria, a monda matupad tu nipekagi na Panginoon to purupeta to araw. I kinagi naa, éy ");
INSERT INTO dgc_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Mangilog i esa a madiket, a tulos magenak siya ta lélake; Sakay ngahinan de siya a Manwel.” (I kahulugen na éya, éy “Kaguman tam i Diyos.”) ");
INSERT INTO dgc_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Nadid, kélukag ni Hose, éy sinunud na tu utus diya no anghel, a pinakasalan na ti Maria. ");
INSERT INTO dgc_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pero éwan na siya inadenean a hanggan éwan linumwas tu anak. Ey to kéenak na, éy nginahinan na ta Jesus. ");
INSERT INTO dgc_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Nadid, nienak ti Jesus ta Betlehem ta Hudea to panahun ni Hari Herod. Ey to nikeenak na dén, éy dinumemét ta Jerusalem i sénganya a Matalinung a lélake, a gébwat side ta sikatan. ");
INSERT INTO dgc_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Nagpakipakelagip side a kinagi de, a “Ahe tu nienak a hari kan na Judeo? Da neta me ta sikatan a linumitaw tu biton a tanda no nikeenak na. Kanya inumange kame se a sumamba kame diya.” ");
INSERT INTO dgc_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nadid ti Hari Herod, pékabaheta na ta éya, éy naligalig siya, éy kona be du tolay ta Jerusalem. ");
INSERT INTO dgc_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kanya pinapisan na du mataas a padi sakay du maistu ta rilihiyon, a nipakelagip na dide éng ahe kan ienak tu tiniyak dén na Diyos a tagapagligtas. ");
INSERT INTO dgc_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ey kinagi de diya, a “Ienak kan siya ta Betlehem ta Hudea; tukoy me ya, da saye tu nisulat du purupeta: ");
INSERT INTO dgc_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Sikam a taga Betlehem, lalo a tanyag i banuwan moya kesira du iba a banuwan ta Hudea, da ienak sina i esa a lélake a mataas, a siya i mamahala du étanan a sakup ko a tolay a Israel.’” ");
INSERT INTO dgc_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nadid, pékabati ni Hari Herod ta éya, éy nipauwet na ta lihim du Matalinung, a monda ipakelagip na dide éng nikésiya linumitaw to biton dide. ");
INSERT INTO dgc_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Sakay tulos pinéglakad na side ta Betlehem, a pinagbilinan na side a kinagi na, a “Ikad moy dén ahayukén moy tu anak. Ey péketa moy diya,” kagi na, “éy ikagi moy diyakén, a monda makaangeék be sa a sumamba diya.” ");
INSERT INTO dgc_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Nadid, pékabati de to bilin no hari, éy néglakad dén side. Ey tu biton a neta de a linumitaw to éya éy neta de man dén. Tulos inunonod de a hanggan hinumintu to némo no édsean no anak. ");
INSERT INTO dgc_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ey mésahat du Matalinung to péketa de to biton. ");
INSERT INTO dgc_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ey késdép de to bile, éy neta de de Maria a patena, éy linumuhud side a sinumamba to anak. Sakay inukad de tu kébil de, a inatdinan de tu anak ta kaluub--gintu, sakay kamangyan, sakay pulurida i niatéd dia. ");
INSERT INTO dgc_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ey nadid, to késoli du Matalinung ta banwan de, éy dinumiman side ta iba dén a dilan, da pinégkagian dén side na Diyos to tagenép de a diyan side magsoli ni Herod. ");
INSERT INTO dgc_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nadid, to kéhektat dén du Matalinung, éy nipatagenép ni Hose i esa a anghel a gébwat ta Panginoon. Kinagi na kan diya, a “Umikat ka dén, Hose, a kébilén mo agad di patenaa ta Egipto. Sakay diyan kam sa huméhektat hanggan éwan ko kagin diko, da ahayukén ni Herod i anaka a bunon na.” ");
INSERT INTO dgc_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Nadid, pékabati ni Hose ta éya, éy inumikat siya agad, éy to kélép be san a éya éy ginuminan dén side a mététena, a inumange side ta Egipto. ");
INSERT INTO dgc_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ey édsa sa side a négiyan a hanggan to nikate ni Hari Herod. Nanyari ya a monda matupad tu nipekagi na Panginoon to purupeta to araw, a “Utusan ko tu anak ko, a paluwasén ta Egipto.” ");
INSERT INTO dgc_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Nadid ti Herod, pékapospos na a linoko siya du Matalinung, éy méiyamut siya a tahod. Kanya nipabunu na du étanan a anak a lélake ta Betlehem, sakay ta palebut na Betlehem. Nipabunu na du étanan a anak a mabulol, a hanggan du te idad ta éduwa a taon. Da éduwa dén a taon i nakalipasa sapul to nipaketa de to biton a tanda. I isipa ni Herod éy ipabunu na maka ti Jesus a anak. ");
INSERT INTO dgc_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Kona sa éy natupad ngani dén tu kinagi ni Purupeta Heremias to araw, a ");
INSERT INTO dgc_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Mabati ta banuwan na Rama i mégsésangitén a mégsésangitén. Du apo ni Rakel a bébe, éy pégsangitan de du anak de. Sala de a wile-wilen side, da pate dén du anak de.” ");
INSERT INTO dgc_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Nadid, to nikate ni Herod, éy nipatagenép tu anghel ni Hose, a kinagi na kan, a ");
INSERT INTO dgc_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Hose, umégkat ka dén, a sumoli kam dén a mététena ta banuwan na Israel, da minate dén tu hari a gustu na a ipabuno tu anak moy.” ");
INSERT INTO dgc_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Nadid, pékabati ni Hose ta éya, éy inumégkat dén siya, a tulos nagsoli dén side a mététena ta Israel. ");
INSERT INTO dgc_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pero pékabaheta ni Hose a ti Arkelao i hari dén ta Hudea, a siya i kapalit no ama na a Herod, éy méganteng siya a umange sa. Ey huway siya a pinégkagian na Diyos to tagenép na, kanya inumange side ta Galilea. ");
INSERT INTO dgc_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ey mégiyan sa side ta banuwan na Nasaret. Ey dahil ta éya, éy natupad tu nihula du purupeta to araw, a kinagi de a taga Nasaret kan tu tiniyak na Diyos a maghari ta mundua. ");
INSERT INTO dgc_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nadid, ta panahun a éya, éy dinumemét ti Juan a Mégbinyag ta ilang a lugar ta Hudea, a nagsapul sa siya a mégtoldu. ");
INSERT INTO dgc_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Magsisi kam a ibutan moy du kasalanan moy,” kagi na, “da adene dén a maghari i Diyos.” ");
INSERT INTO dgc_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ti Juan i pinégkagiana ni Purupeta Isayas to nipégkagi na to araw, a “Te magpahayag ta ilang a lugar, a i kagi naa du tolay éy dapat maghanda side ta kédemét na Panginoon, a husayén de be i péglakaden na.” ");
INSERT INTO dgc_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Nadid, tu badu ni Juan, éy ginamet ta buk na hayup. Sakay tu sinturon na éy katat. I kékanén naa éy pésah sakay pitukan. ");
INSERT INTO dgc_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ey inumange diya du tolay a taga Jerusalem, sakay du taga Hudea, sakay dudu mégiyan ta magdibilew ta Hordan. ");
INSERT INTO dgc_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ey nipagtapat de i étanan a kasalanan de, a tulos bininyagen side ni Juan ta dinuma na Hordan. ");
INSERT INTO dgc_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Pero péketa ni Juan ta meadu a Pariseo sakay Saduseo a inumange diya a ipabinyag, éy kinagi na dide, a “Sikam éy magkadukés kam a tolay. Anya i kailangan moya ta éye? Akala moy wade a makaginan kam ta parusa na Diyos? ");
INSERT INTO dgc_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Baguén moy pa,” kagi na, “i ugali moya, a patunayan moy a nagsisi kam dén a talaga. ");
INSERT INTO dgc_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Diyan kam umasa a agawén kam na Diyos da apo kam ni Abraham, da éwan ya tu kabuluhan ta Diyos. Da maski di bituae,” kagi na, “éy maari na Diyos a gemtén a maging apo ni Abraham. ");
INSERT INTO dgc_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","“Tandaan moy,” kagi ni Juan, “mara i parusa na Diyos, éy wasay. Ey mehanda dén nadid tu wasay a pagpukan du kayo. Eng mara, sikam éy kayo kam. Ey du étanan a kayo a éwan magbunga ta mahusay a bunga, éy pukanén, sakay ibut ta apoy. ");
INSERT INTO dgc_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Sakén éy binyagen ta kam ta dinom a monda matukuyan kam a pinagsisian moy dén i kasalanan moy. Pero te ménegipo diyakén a dumemét. Eng iparehoék moy diya, éy éwanék tu pasa, da mataas siya diyakén. Siya éy binyagen na kam ta Banal a Espiritu, sakay ta apoy. ");
INSERT INTO dgc_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Mara,” kagi ni Juan, “i pamuhubaan naa ta tolay, éy bilao. Mara te kébil siya a bilao, monda tapan na tu béges na. Ey tu mahusay a béges, éy iedton na ta bile na, éy tu lupés, éy itutod na ta apoy a éwan maadép.” ");
INSERT INTO dgc_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Nadid, dinumemét ti Jesus a gébwat ta Galilea, a inumange siya ni Juan a ipabinyag. ");
INSERT INTO dgc_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ey sésawayén siya ni Juan, a kinagi na, a “Mésanikeék a sakén i magbinyaga diko. Sakén i kailangana a binyagen mo!” ");
INSERT INTO dgc_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Pero, “Ewan,” kagi ni Jesus. “Saye i dapat a gemtén ta a monda matupad i kaluuben na Diyos.” Ey nadid, to pégkagi ni Jesus ta éya, éy pinumayag ti Juan. ");
INSERT INTO dgc_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ey to nipangbinyag na dén ni Jesus, éy inumahawas siya to dinom. Ey minapilak i langet, a tulos neta na i Espiritu na Diyos a dinumibi a koman i dagalan, éy inumapon diya. ");
INSERT INTO dgc_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ey négkagi nadid i boses ta langet, a “Séˈ ina i anak ko a mahal, éy mésayaék diya.” ");
INSERT INTO dgc_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Nadid, tu Banal a Espiritu, éy niange na ti Jesus ta ilang a lugar, a monda tokson siya ni Satanas. ");
INSERT INTO dgc_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ey nagkulasiyon sa ti Jesus ta épatapulu a aldew. Ey mégalép siya. ");
INSERT INTO dgc_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ey inumange diya ti Satanas, a kinagi na, a “Eng anak ka na Diyos a talaga, éy gamitén mo i kapangyarian mua a paging tinapayén mo di bitoae.” ");
INSERT INTO dgc_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ey mégidel ti Jesus, a kinagi na, a “I kagia ta kasulatan na Diyos, éy éwan san kanén i ikabuhay mia, éngˈwan salita be na Diyos i ikabuhaya na tolay.” ");
INSERT INTO dgc_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Nadid, niange siya ni Satanas ta paluku no Templo ta Jerusalem. ");
INSERT INTO dgc_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Eng siko i anak na Diyos,” kagi na, “éy tumépduk ka dén. Ewan ka maanya, da i kagia ta kasulatan na Diyos, éy utusan kan na Diyos du anghel na a mangalaga diko. Sakay agawén de ka kan,” kagi ni Satanas, “monda éwan ka mebagsak ta bito.” ");
INSERT INTO dgc_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ey mégidel man dén ti Jesus, a kinagi na, a “I kagi a iba ta kasulatan, éy ‘Ewan maari a puhubaan na tolay i Diyos, éng aguman na.’” ");
INSERT INTO dgc_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Nadid, huway a niange siya ni Satanas ta melélangkaw a buked, a nipatan-aw na diya i étanan a banubanuwan ta mundua, sakay tu kayamanan de. ");
INSERT INTO dgc_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Sakay kinagi na ni Jesus, a “Iatéd ko diko i étanan a éya, éng dumapa ka san a sumamba diyakén.” ");
INSERT INTO dgc_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Pero kinagi ni Jesus, a “Umadeyo ka dén, Satanas. Da utus be na kasulatan na Diyos, éy ‘Panginoon mo a Diyos, éy siya san i sambaan mua; éy siya be san i péniwalaan mua.’” ");
INSERT INTO dgc_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Nadid, gininanan siya ni Satanas. Ey dinumemét sa du anghel diya, a inaguman de siya. ");
INSERT INTO dgc_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Nadid, pékabaheta ni Jesus a nipihesu dén ti Juan, éy nagsoli siya ta Galilea. ");
INSERT INTO dgc_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ewan dén siya négiyan ta Nasaret, éngˈwan ta Kapernaum dén. I éya a banuwan éy édse ta digdig na diget, ta pag-itan na Sabulon éy ta Neptali. ");
INSERT INTO dgc_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nanyari ya a monda matupad tu nihula ni Purupeta Isayas: ");
INSERT INTO dgc_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Du taga Sabulon sakay du taga Neptali, éy side du édse ta adene na diget, to dibilew na Hordan. Sakay du éwan Judeo a mégiyan ta Galilea. ");
INSERT INTO dgc_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Side i mégiyan ta kedikléman. Pero meta de i ngéngahinan de a Demlag. Side a mégiyan ta kedikléman a méganteng side ta kamatayan. Ipaliwanag dide na Demlag, da mégiyan dide i Panginoon.” ");
INSERT INTO dgc_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Sapul ta éya a oras, éy négtétolduén ti Jesus, a kinagi na, a “Magsisi kam a ibutan moy du kasalanan moy, da adene dén a maghari i Diyos.” ");
INSERT INTO dgc_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","To péglakad ni Jesus ta digdig na diget na Galilea, éy neta na i éduwa a lélake a ménggila. Patwadi side ti Simon, éy ti Andres. (Tu palayaw ni Simon éy ti Pedro.) ");
INSERT INTO dgc_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Kinagi na dide, a “Kumuyoyog kam diyakén a maging alagad ko. Sapul nadid, éy éwan kam dén mangalap ta ikan,” kagi na, “éngˈwan i alapén moya éy tolay a para diyakén.” ");
INSERT INTO dgc_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ey pékabati du éduwa ta éya, éy basta gininanan de tu gila de, a kinumuyog side ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Tulos side a néglakad, éy neta de de Santiago éy ti Juan, a patwadi, a anak side ni Sebedeo. Kaguman de tama de to abeng, a mégayoma side to rambat de. Ey dinulawan side ni Jesus, ");
INSERT INTO dgc_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","éy agad de gininanan tu abeng, sakay tama de, a kinumuyog be side ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Nadid, méglebut ti Jesus ta étanan a Galilea, a mégtoldu siya du tolay du kapilya de, sakay mégpahayag siya ta Mahusay a Baheta tungkul ta péghari na Diyos. Sakay pinahusay na be du tolay ta étanan a sakisaket de. ");
INSERT INTO dgc_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Tulos tanyag siya ta étanan a Siria. Kanya niange de diya i étanan a te saket, sakay du te hirap, sakay du hinayup, sakay du mégkaramre, sakay du pile. Ey pinahusay na side a étanan. ");
INSERT INTO dgc_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ey tinétagubet siya na meaadu a tolay a gébwat ta Galilea, sakay ta Dekapolis, sakay ta Jerusalem, sakay ta Hudea; sakay tolay be a gébwat ta dibilewa na Hordan. ");
INSERT INTO dgc_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Nadid, péketa ni Jesus du meaadu a tolay, éy nanohobuk siya to buked. Sakay inumeknud sa siya a magtoldu; éy inumadene diya dudu alagad na. ");
INSERT INTO dgc_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Saye i péngtoldu naa dide: ");
INSERT INTO dgc_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Masuwerte du mababa, a Diyos san i asaan dia, da masakup side na kaharian na. ");
INSERT INTO dgc_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Masuwerte du mélungkut, da pakasayaén side na Diyos. ");
INSERT INTO dgc_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Masuwerte du magkabait, da atdinan side na Diyos to nipangako na. ");
INSERT INTO dgc_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Masuwerte du pumilit a gumamet ta kaluuben na Diyos, da iatéd dide na Diyos i gustu de. ");
INSERT INTO dgc_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Masuwerte du mekagbi, da kagbian be side na Diyos. ");
INSERT INTO dgc_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Masuwerte du méniwala ta Diyos ta matapat, da meta de i Diyos. ");
INSERT INTO dgc_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Masuwerte du mégpayo du méglébug, da side i bilang tunay a anak na Diyos. ");
INSERT INTO dgc_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Masuwerte du lélokon na tolay dahil to péniwala de ta Diyos, da masakup side na kaharian na Diyos. ");
INSERT INTO dgc_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Masuwerte kam dahil ta péngahew dikam du tolay,” kagi ni Jesus, “sakay ta péngloko de dikam, sakay ta péngupos de dikam a mebuli. O, bagay lélokon de kam da sikam i sakup ko, éy masuwerte kam. ");
INSERT INTO dgc_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Bagay kona sa, éy dapat masaya kam, da dikél i gantimpala moy ta langet. Da tandaan moy, kona be sa i péngloko de du purupeta a neditol dikam.” ");
INSERT INTO dgc_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Sikam a alagad ko, mara sikam i asen ta mundua,” kagi ni Jesus, “da sikam i magpahusay du tolay ta mundua. Pero éng maibut tu asen, a tumablal dén tu sida, éy pakodyan moy a mamasoli to asen na? Ewan dén nadid tu pasa. Kanya ibut san dén a tulos yudakén na tolay. ");
INSERT INTO dgc_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Sikam i demlag a magpaliwanag ta tolay ta mundua,” kagi ni Jesus. “Ewan meliso i banuwan a édse ta buked. ");
INSERT INTO dgc_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Mara, éwan tu mégtab ta simbu a taklében na ta pégtakalan. Engˈwan, iedton na ta lamesa, monda matanglawan du édse ta bile. ");
INSERT INTO dgc_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nadid, kona be sa i mahusay a gimet moy; diyan moy iliso. Ipeta moy du tolay i mahusay a ugali moy, monda purién de Tama moy ta langet. ");
INSERT INTO dgc_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Diyan moy isipén a inumangeék se a monda paibut ko tu utus ni Moises, sakay tu pégtoldu du purupeta,” kagi ni Jesus. “Ewan! Ewanék se kanya inumange éy paibut ko, éngˈwan para ipaliwanag ko ya, sakay ganapén ko. ");
INSERT INTO dgc_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Da tandaan moy ye: éwan maibut i maski isesa a utus ta libru na Diyos, hanggan éwan maibut i langet éy ta mundua. ");
INSERT INTO dgc_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kanya i sindu manglabag ta maski isesa a utus a éye, a itoldu na i kona sa ta tolay, éy siya i mababaa ta kaharian na Diyos. Pero tu manugsug ta utus a éye, a itoldu na i kona sa ta tolay, éy siya i mataasa ta kaharian na Diyos. ");
INSERT INTO dgc_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Da tandaan moy ye: i pégsunud moya ta Diyos, éng koman san i pégsunud du maistu ta rilihiyon sakay du Pariseyo, éy éwan kam makasdép ta kaharian na Diyos.” ");
INSERT INTO dgc_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Tukoy moy dén i dati a utus,” kagi ni Jesus, “a ‘Diyan ka mémuno, sakay sindu makabuno éy hukumén na huwes.’ ");
INSERT INTO dgc_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pero nadid i kagin kua dikam, éy tu maiyamut ta kapareho na, éy hukumén siya. Tu mangdusta ta kapareho na, éy bistaan siya. Sakay tu mégkagi ta kapareho na a ‘Luku-luku ka,’ éy meange ta apoy ta impiyerno. ");
INSERT INTO dgc_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Kanya éng mégatang ka ta Diyos, sakay maala-ala mo a te kasalahan ka to kaguman mo, ");
INSERT INTO dgc_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","éy ginanan mo pa tu iatang mo ta harap no Templo, sakay ange ka pa mékipagkasundu diya. Ey nadid, magsoli ka a tulos magatang ka ta Diyos. ");
INSERT INTO dgc_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Eng te méngiabla diko ta huwes,” kagi ni Jesus, “éy mékipéguhon ka diya hanggan éwan kam pabi humarap ta huwes. Dahilan éng dumemét i oras na asuntu moy, éy iatéd na ka ta huwes, a tulos iatéd de ka ta pulis, a tulos mepihesu ka dén. ");
INSERT INTO dgc_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Eng kona sa, éy éwan ka makaluwas hanggan éwan mo mabayaden i étanan a kasalanan mo.” ");
INSERT INTO dgc_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Tukoy moy dén tu dati a utus,” kagi ni Jesus, “a diyan ka kan méngibébi. ");
INSERT INTO dgc_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pero nadid i kagin kua dikam, éy maski lumameng i lélake to bébe, a éwan tama i isip naa diya, éy te kasalanan siya, da méngibébi dén siya diya ta isip na. ");
INSERT INTO dgc_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kanya nadid,” kagi na, “éng na mata mo i mangatéd diko ta ipagkasala mo, éy lékwabén mo sakay ibut mo! Da maigi pa éy maibutan ka ta esa a kasangkapan na bégi mua kesira ta buu ka a ibut ta impiyerno. ");
INSERT INTO dgc_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Eng na kamét mo be sana i mangatéd diko ta ipagkasala mo, éy kétulén mo sakay ibut mo! Maigi pa, éy maibutan ka ta esa a kasangkapan na bégi mua kesira ta buu ka a ibut ta impiyerno.” ");
INSERT INTO dgc_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“I kagi be ya no utus a iba, éy bagay hiwalayan kan na lélake tu asawa na, éy dapat a atdinan siya ta katibayan ta péghiwalay. ");
INSERT INTO dgc_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pero sakén,” kagi ni Jesus, “i kagin kua dikam, éy bagay hiwalayan no lélake tu asawa na a éwan be néngilélake, sakay paasawa siya a huway, i lélake a éya éy te kasalanan, da nisonson na tu asawa na a méngilélake. Sakay éng te mangasawa to bébe a hiniwalayan éy méngibébi be.” ");
INSERT INTO dgc_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Nabati moy be dén tu dati a utus, a diyan ka kan sumésida to pinanumpaan mo a pangako, éngˈwan tupadén mo tu sinumpaan mo ta Panginoon. ");
INSERT INTO dgc_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pero iba i kagin kua dikam,” kagi ni Jesus, “éy diyan kam sumésumpa éng mangako kam. Diyan moy kékagin a sistigu moy i langet, da saya i édsean na Diyos. ");
INSERT INTO dgc_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Sakay diyan moy kékagin a sistigu mo i luta, da Diyos i tagapamahala ta éya. Sakay diyan moy be kékagin a sistigu mo i Jerusalem, da saya i banuwan na Mataas a Hari. ");
INSERT INTO dgc_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Sakay diyan mo isumpa a ‘Ikate ko,’ da besa a siko i mamahala ta buhay mua. ");
INSERT INTO dgc_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Maigi pa, i kagi mo san dén éy ‘O,’ o dikaya ‘Ewan’. Da éng méngisumpa ka éy gébwat ya ni Satanas.” ");
INSERT INTO dgc_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Tukoy moy dén tu dati a utus,” kagi ni Jesus, “a ‘Tu mangbuhék ta mata mua, éy buhékén mo kan be, sakay tu manuntuk ta ngipén mua, éy suntukén mo kan be ta ngipén naa.’ ");
INSERT INTO dgc_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pero nadid éy iba i utus kua dikam: a diyan kam lumaban ta mangloko dikam. Eng te mangsapuk diko ta padingel mua, éy iadene mo pa i lipat. ");
INSERT INTO dgc_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Eng te méngiabla diko a monda maalap na i badu mua, éy iatéd mo be diya tu diyaket mo. ");
INSERT INTO dgc_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mara, éng ipépilit diko no sundalu a ipakébil tu karga na ta esa a kilumetru, éy hustuén mo dén a éduwa a kilumetru. ");
INSERT INTO dgc_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mangatéd ka ta mékeged diko, sakay diyan mo péngawanan tu mékedem diko.” ");
INSERT INTO dgc_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Tukoy moy dén tu dati a utus, a ‘Mahalén mo kan tu kadimoy mo, sakay kaiyamutan mo tu kalbug mo.’ ");
INSERT INTO dgc_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pero iba i utus kua dikam,” kagi ni Jesus. “I utus kua, éy mahalén moy be tu kalbug moy, sakay ipanalangin moy du mangloko dikam. ");
INSERT INTO dgc_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Eng pakunan moy sa, éy umaheg kam dén Nama moy a Diyos. Da entan moy, éwan patanglawén na Diyos tu bilag du mahusay san a tolay, éngˈwan pati du medukés a tolay. Ey kona be sa tu uden, paudinan na be du makasalanan a tolay. ");
INSERT INTO dgc_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mara du mahal dikam, éng side san i mahalén moya, éy anya pa i gantimpala a uhayén moy? Maski du méngdédaya a tolay, éy kona sa i ugali de. ");
INSERT INTO dgc_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Sakay éng du kakaguman moy san i bébatién moya, éy anya i mégimet moya kesira du iba a tolay? Maski du éwan mékidiyos a tolay, éy kona sa i ugali de. ");
INSERT INTO dgc_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kanya sikam éy dapat mahusay kam, a kona Nama moy ta langet.” ");
INSERT INTO dgc_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Mangilag kam a diyan moy san gemtén i mahusay ta harap na tolay a monda purién de kam. Eng kona sa i gemtén moya,” kagi ni Jesus, “éy éwan kam tu maalap a gantimpala moy a gébwat Nama moy a Diyos. ");
INSERT INTO dgc_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Kanya éng maglimos ka, éy diyan mo dén ipeta ta tolay a iba. Saya i ugalia du palalo a tolay bagay manglimos side ta kapilya sakay ta karsada. Gustu de a meta na tolay tu péglimos de, monda purién de side. Ey tandaan moy ye: purién side na tolay a talaga, pero séˈ san ya i gantimpala de. Ewan side tu gantimpala a gébwat ta Diyos. ");
INSERT INTO dgc_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Kanya sikam,” kagi ni Jesus, “éng manglimos kam, éy diyan moy dén ikagi ta maski ti ésiya, ");
INSERT INTO dgc_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","monda melihim i péglimos moya. Ey gantian kam Nama moy ta langet to ginimet moy a lihim, da meta na.” ");
INSERT INTO dgc_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Bagay manalangin kam,” kagi ni Jesus, “éy diyan kam uméaheg du palalo. Mégwari-wari side a mékidiyos, a manalangin side ta harap du tolay ta kapilya sakay ta karsada, monda mabati du tolay i panalangin de. Ey purién side na tolay a talaga. Pero séˈ san ya i gantimpala a maalap de. ");
INSERT INTO dgc_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kanya sikam, éng manalangin kam, éy somdép kam ta lubuk na bile moy, sakay iseradu moy tu pintuan. Sakay manalangin ka sa a isesa Nama mo, éy siya éy gantian na ka a talaga, da meta na i étanan a gimet mo a lihim. ");
INSERT INTO dgc_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Eng manalangin kam, éy diyan moy pakadun tu kagi moy, a kona ta panalangin du éwan mékidiyos a tolay. Side, i akala dia, éy baten side na Diyos dahil ta kaatakdug na panalangin de. ");
INSERT INTO dgc_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Diyan kam uméaheg dide, da tukoy dén Nama moy a Diyos i kailangan moy bagu moy ikagi diya. ");
INSERT INTO dgc_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Nadid, kona se i panalangin moya: ‘Améng a Diyos ta langet, Purién maka dén na tolay i ngahen mua. ");
INSERT INTO dgc_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Siko maka dén i maghari ta mundua. Sundin maka dén na tolay ta mundua i kaluuben mo a kona ta langet. ");
INSERT INTO dgc_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Atdinan mo kame ta kanén me nadid a aldew; ");
INSERT INTO dgc_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Sakay patawadén mo kame ta kasalanan me; éy sikame éy patawadén me be du te kasalanan dikame. ");
INSERT INTO dgc_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Sakay diyan mo kame iharap ta mahigpit a mamuhuba dikame, éngˈwan iadeyo mo kame ta medukés.’ ");
INSERT INTO dgc_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Dahilan,” kagi ni Jesus, “éng patawadén moy i te kasalanan dikam, éy patawadén kam be Nama moy ta langet. ");
INSERT INTO dgc_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pero éng éwan moy patawadén du te kasalanan dikam, éy éwan kam be patawadén Nama moy.” ");
INSERT INTO dgc_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Bagay magkulasiyon kam, éy diyan kam malungkut tu mudet, a kona du palalo a tolay,” kagi ni Jesus. “Side, éy éwan side mégayus, sakay légian de tu mata de, monda meta du tolay a mégkulasiyon side. Ey purién side na tolay a talaga. Pero séˈ san ya i gantimpala a maalap de. ");
INSERT INTO dgc_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kanya sikam, bagay magkulasiyon kam, éy magayus kam san, sakay magidemos kam, ");
INSERT INTO dgc_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","monda éwan mapospusan na tolay a mégkulasiyon kam. Basta Tama moy san i nakapospusa ta gimet moy; éy gantian na kam, da meta na i étanan a gimet moy a lihim.” ");
INSERT INTO dgc_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Diyan kam magimbak ta kayamanan moy ta munduae,” kagi ni Jesus. “Da kutamén ya a talaga, sakay pikasén, sakay takawén. ");
INSERT INTO dgc_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Maigi pa, éy gemtén moy i kaluuben na Diyos. Saya i mégeimbak moya ta kayamanan moy ta langet. Ey éwan ya mebut, da éwan sa tu kutam, sakay pikas, sakay éwan sa tu mégtako. ");
INSERT INTO dgc_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Dahilan éng ahe i édsean na kayamanan na tolay, éy siya be san ya i alélahanén naa. ");
INSERT INTO dgc_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Na mata mua,” kagi ni Jesus, “éy saya i pinakang-simbu na bégi mua. Kanya éng medemlag i mata mua, éy mademlagen be i étanan a bégi mo. ");
INSERT INTO dgc_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pero éng mediklém i mata mua, éy mediklém be i étanan a bégi mo. Samakatuwid, éng éwan mo tukoy i tama, éy mediklém i isip mua.” ");
INSERT INTO dgc_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ewan maari,” kagi ni Jesus, “tu isesa a utusan a makasunud ta éduwa a amo na. Dahilan, éng éduwa i amo naa, éy mahal na san tu esa, sakay kaiyamutan na tu esa. Maniwala siya to amo na a esa, sakay lukoén na tu esa. Ey nadid, kona sa dikam--éwan kam maari a méniwala ta Diyos, éng kuhata san i gustu moya. ");
INSERT INTO dgc_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Kanya i pégtoldu kua dikam,” kagi na, “éy diyan kam métageg ta buhay moy, éng anya i kanén moy éy ta badu moy. Da tandaan moy, éng nilalang kam na Diyos, éy bakit isipén moy a éwan na kam atdinan ta kanén moy éy ta badu moy? ");
INSERT INTO dgc_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Entan moy di manuka. Ewan side méghasik; éwan side mégladey; éwan side tu budega. Pero atdinan side Nama moy ta kanén de. Ey sikam, éwan kam beman higit a mahalaga ta manok? ");
INSERT INTO dgc_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ataay,” kagi ni Jesus, “éng dumemét i oras a ikate mo, maari ka beman a magpaatakdug ta buhay mo ta maski esa a oras, éng mabalisa ka? ");
INSERT INTO dgc_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Bakit métageg kam ta badu moy? Isipén moy éng kodya i kébékyaga na bulaklak. Ewan side mégtarabaho, éwan side mégimet ta badu. ");
INSERT INTO dgc_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pero i mégebadu dia, éy memahal pa to badu no mayaman a hari to araw, a ti Hari Solomon. ");
INSERT INTO dgc_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ey nadid,” kagi ni Jesus, “éng bihisan na Diyos i bulaklak ta kona sa, maski sandali san i buhay de, éy anya, éwan na kam pabaduan? Bakit kétihék i péniwala moya diya? ");
INSERT INTO dgc_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kanya diyan kam mabalisa éng ahe i paketan moya ta kanén moy sakay ta inumén moy, sakay ta badu moy. ");
INSERT INTO dgc_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Saya i ugalia du iba a tolay a éwan mékidiyos. Pero Tama moy ta langet, éy tukoy na dén i kailangan moya. ");
INSERT INTO dgc_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Kanya sikam, éy pilitén moy a maghari i Diyos dikam, sakay gemtén moy san i kaluuben na, éy iatéd na dikam i étanan a kailangan moy. ");
INSERT INTO dgc_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Sakay diyan kam métageg ta dumemét dikam ta esa a aldew. Bagu moy isipén éng dumemét dén. Tama dén tu péngisip moy ta kabuhayan moy nadid a aldew.” ");
INSERT INTO dgc_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Diyan kam mégpintas ta kapareho moy, monda éwan kam pintasan na Diyos,” kagi ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","“Da pintasan kam na Diyos ayun ta pégpintas moy to kapareho moy. Tu gemtén moy ta iba, éy siya be ya i gemténa dikam na Diyos. ");
INSERT INTO dgc_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mara, bakit pépintasan mo tu kaguman mo a te buhék tu mata, éy siko éwan mo mapansing tu adigi ta mata mua? ");
INSERT INTO dgc_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kodya i pégkagi mua to kaguman mo, a ‘Kadon, ibutan ko i buhék mua,’ pero te adigi ka san tu mata? ");
INSERT INTO dgc_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Mégkukunwari ka bale a éwan ka tu kasalanan! Ibutan mo pa tu adigi ta mata mua, monda maketa ka ta mahusay a maibutan tu buhék to mata no kaguman mo. ");
INSERT INTO dgc_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Mara,” kagi ni Jesus, “diyan moy iatéd ta aso i mahalaga a bagay, da péngigewat mo, éy basta kagitén na ka a talaga. Ey kona be sa i kagi na Diyos, éng ipahayag mo ta medukés a tolay, éy basta habuhabukan na ka san, da éwan na be tukoy i kabuluhan na éya diya.” ");
INSERT INTO dgc_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Eng mékeged kam ta Diyos, éy atdinan na kam. Eng mégahayok kam, éy paketan na kam. Eng tumuktuk kam ta pintuan na Diyos, éy bukasan na kam. ");
INSERT INTO dgc_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Dahilan maski ti ésiya i magagida ta Diyos, éy atdinan na. Sakay tu mégahayok, éy paketan na. Sakay tu mégtuktuk, éy bukasan siya. ");
INSERT INTO dgc_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Anya,” kagi ni Jesus, “éng magaged du anak moy ta tinapay, éy anya i iatéd moya, bito? ");
INSERT INTO dgc_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O éng magaged dikam ta ikan, éy anya i iatéd moya, ulag? ");
INSERT INTO dgc_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nadid, entan moy; maski makasalanan kam a tolay, éy atdinan moy du anak moy ta mahusay. Ey Tama moy ta langet, éwan na beman iatéd i mahusay ta mékeged diya? ");
INSERT INTO dgc_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Gustu moy a aguman kam na tolay, tama? Pero i utus kua dikam, éy sikam i mangaguma dide. Saya i kahulugina no kautusan ni Moises, sakay tu pégtoldu du purupeta. ");
INSERT INTO dgc_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Somdép kam ta mepiit a pintuan ta langet. Da melawa i pintuan ta impiyerno, a éwan mehirap a dimanén a tamo ta éya. Kanya meadu i umangea ta éya. ");
INSERT INTO dgc_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pero tu pintuan ta langet, éy mepiit, sakay mehirap i dimanén a tamo ta éya. Kanya kétihék san i maketaa ta éya.” ");
INSERT INTO dgc_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Mangilag kam du mebuli a purupeta,” kagi ni Jesus. “Umange side dikam a koman side i mebait, pero metapang side, a lokon de kam a talaga. ");
INSERT INTO dgc_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Kanya subukan moy du mégtoldu ta kagi na Diyos, monda mapospusan moy éng mebuli side, bagay meta moy tu ugali de. Mara entan moy, mapitas beman i mahusay a bunga ta medukés a kayo? Ewan, ");
INSERT INTO dgc_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","da i bunga na medukés a kayo, éy medukés be. Ey kona be sa i tolay, éng medukés siya, éy medukés be i ugali na. ");
INSERT INTO dgc_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ewan makapagbunga tu mahusay a kayo ta medukés a bunga,” kagi ni Jesus. “Sakay éwan makapagbunga tu medukés a kayo ta mahusay a bunga. ");
INSERT INTO dgc_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ey tu bawat kayo a éwan mégbunga ta mahusay, éy pukanén sakay ibut ta apoy. ");
INSERT INTO dgc_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kona sa, éy mapospusan moy be du mebuli a purupeta, bagay meta moy tu bunga de. ");
INSERT INTO dgc_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Te meadu a méngdulaw diyakén a Panginoon. Pero éwan side a étanan i makasdép ta kaharian na Diyos. Basta du sumésunud Nama ko ta langet i makasdépa. ");
INSERT INTO dgc_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kédemét na aldew na péghukum, éy meadu i mégkagi diyakén, a ‘Panginoon, tanggapén mo kame, da nagtoldu kame ta ngahen mua, sakay pinaibut me du dimonyo, sakay ginimet me i makataka-taka dahil ta péniwala me diko.’ ");
INSERT INTO dgc_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pero i sengbet kua dide, éy ‘Ewan, éwan ta kam minatenggi. Umadeyo kam dén, sikam a mégimet ta medukés.’” ");
INSERT INTO dgc_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Maski ti ésiya i mégbati ta kagi kua, éng sundin na, éy ikahalimbawa na éy tu lélake a matalinung a nagpataknég ta bile na to bito. ");
INSERT INTO dgc_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Maski naguden ta mebakség, sakay binumihéng, sakay binagyo, éy éwan natumba, da te taknég to bito. ");
INSERT INTO dgc_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pero,” kagi ni Jesus, “du makabati ta kagi kua, sakay éwan na sundin, éy ikahalimbawa na éy tu lélake a luku-luku a nagbile san to baybay. ");
INSERT INTO dgc_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ey naguden ta mebakség, sakay binumihéng, tulos binagyo, éy basta minatumba, a tulos minawasak a tahod.” ");
INSERT INTO dgc_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Nadid, kétapos dén ni Jesus a mégtoldu ta éya, éy mégpégtaka a tahod du tolay to pégtoldu na, ");
INSERT INTO dgc_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","da éwan siya mégtoldu a kona du maistu na rilihiyon de, éngˈwan neta de a te kapangyarian siya ta pégtoldu na. ");
INSERT INTO dgc_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Nadid, namulnok ti Jesus to buked, éy tinagubet siya na meadu a tolay. ");
INSERT INTO dgc_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ey inumadene diya i lélake a te saket a ketong. Linumuhud siya ta harap ni Jesus, a kinagi na, a “Panginoon, éng maari, éy pahusayénék pad.” ");
INSERT INTO dgc_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ey ti Jesus, éy kembilan na siya, a kinagi na, a “Maari, maghusay ka dén.” Ey to pégkagi na ta éya, éy bigla a naibut tu ladu na. ");
INSERT INTO dgc_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ey kinagi ni Jesus, a “Diyan mo kékagin i éye ta maski ti ésiya, éngˈwan umange ka pa pumeta ta padi, a mahusay ka dén. Sakay atdinan mo tu padi,” kagi ni Jesus, “ta péngiatang na diko, a kona to niutus ni Moises. Saya i pagpatunay mua ta tolay a mahusay ka dén.” ");
INSERT INTO dgc_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Nadid, késdép ni Jesus ta Kapernaum, éy inumadene diya i esa a kapitan na sundalu a taga Roma, a mékiohon diya. ");
INSERT INTO dgc_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Kinagi na diya, a “Panginoon, tu utusan ko éy te karamre, a te datay san dén ta bile, a masiyadu a méghirap.” ");
INSERT INTO dgc_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ey kagi ni Jesus, a “Umangeék sina a pahusayén ko siya.” ");
INSERT INTO dgc_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Pero kinagi no kapitan, a “Mésanikeék diko a umange ka ta bile me, da mataas ka diyakén. Basta kagi mo san dén, Panginoon, éy maghusay tu utusan ko. ");
INSERT INTO dgc_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Maski sakén,” kagi no kapitan, “éy te mégutus be diyakén a heneral; sakay sakén, mégutusék be du sundalu ko, éy sundin de san. Ey kona be sa du katulung ko. Kanya éng magutus ka san, Panginoon, éy maghusay siya a talaga.” ");
INSERT INTO dgc_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nadid, pékabati ni Jesus ta éya, éy nagtaka siya, a kinagi na du umunonod diya, a “Sapul to éya, éy éwan ko pabi neta i maski isesa a Judeo a méniwala diyakén a kona ta kapitanae. ");
INSERT INTO dgc_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Tandaan moy ye,” kagi ni Jesus, “meadu i éwan Judeo a magébwat ta sikatan sakay ta sahéman, a dumulug side ta kaharian ta langet. Ey négdipon side de Abraham, sakay ti Isak, sakay ti Hakob. ");
INSERT INTO dgc_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pero meadu dikam a Judeo, i ibut ta kedikléman ta luwas na kaharian. Ey édsa side a mégsésangitén a mégéadiyoyén ta hirap de.” ");
INSERT INTO dgc_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ey nadid, kinagi ni Jesus to kapitan, a “Ikad mo dén. Manyari ina ayun to péniwala mo.” Ey tu utusan no kapitan, naghusay dén to oras a éya. ");
INSERT INTO dgc_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Nadid, késdép ni Jesus to bile ni Pedro, éy neta na tu manugeng na, a te katidug siya, a mahigpit a mepalang. ");
INSERT INTO dgc_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Tulos kembilan ni Jesus tu kamét na, éy minaibut tu palang na, a tulos inumégkat a nagasikaso diya. ");
INSERT INTO dgc_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","To kélép a éya, éy niange du tolay ni Jesus i meadu a hinayup a tolay. Ey esa san a kagi na, éy pinaibut na dide du medukés a espiritu. Sakay pinahusay na be du étanan a méladu. ");
INSERT INTO dgc_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ey saya i nipangtupada to hula ni Purupeta Isayas to araw, a “Alapén ni Cristo i étanan a saket tam, sakay ibutan na i étanan a hirap tam.” ");
INSERT INTO dgc_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nadid, péketa ni Jesus ta meaadu a tolay a dumédulug diya, éy inutusan na du kakaguman na a maghanda a umahabes ta dibilew. ");
INSERT INTO dgc_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Péghanda de pabi, éy inadenean siya no esa a maistu ta rilihiyon, a kinagi na, a “Maistu, kumuyugék diko maski ahe i angayan mo.” ");
INSERT INTO dgc_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ey kinagi diya ni Jesus, a “Isipén mo pa, da entan mo, maski aso, éy te pégiyanan. Sakay du manok éy te lobun a pégiyanan de. Pero sakén a lélake a gébwat ta langet, éy éwanék tu katidugen.” ");
INSERT INTO dgc_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Sakay kinagi be diya no alagad na a esa, a “Panginoon, kumuyogék diko; pero pabayanék pad pa, monda angen ko pa ielbéng tama ko.” ");
INSERT INTO dgc_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","“Ewan,” kagi ni Jesus. “Kumuyog ka dén nadid. Pabayan mo du éwan méniwala ta Diyos a méngielbéng to ama mo.” ");
INSERT INTO dgc_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Nadid, sinumakay ti Jesus to abeng, a kaguman na du alagad na. ");
INSERT INTO dgc_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Mamaya-maya, inabut side ta ditaw na mesibét a unos, a hanggan da talaga side a matabwan. Ey tidug san ti Jesus. ");
INSERT INTO dgc_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kanya linukag siya du alagad na, a kinagi de, a “Panginoon, tulungan mo kame! Omléd kitam dén!” ");
INSERT INTO dgc_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ey ti Jesus, kéégkat na, éy kinagi na dide, a “Bakit méganteng kam? Kétihék bale pabi i péniwala moya diyakén.” Tulos sinaway na tu pahés sakay tu diget, a agad tinumahimik dén. ");
INSERT INTO dgc_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ey nagtaka du alagad, a kinagi de, a “Anya wade i lélakeae? Maski pahés éy ta diget, éy méniwala side diya!” ");
INSERT INTO dgc_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nadid, kédemét de Jesus ta banuwan na tolay a Gadareno ta dibilew, éy sinambat side na éduwa a lélake a hinayup, a gébwat side to kapusanto. Metapang side, kanya éwan tu mangahas a dumédiman ta éya. ");
INSERT INTO dgc_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Agad side a dinumulaw, a “Anya i pékialam mua dikame, siko a Anak na Diyos? Inumange ka se a pahirapan mo kame? Maski éwan me pabi oras a maghirap?” ");
INSERT INTO dgc_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nadid, te meadu sa a babuy to tapat de, a alagaan du tolay. ");
INSERT INTO dgc_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ey du dimonyo a édse to éduwa a lélake, éy pinékiohon de ni Jesus, a “Eng ibutan mo kame, éy pasdépén mo kame pad ta bégi di babuy yae.” ");
INSERT INTO dgc_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","“Nay, ikad moy dén sa,” kagi ni Jesus. Kanya inumibut side to éduwa, a tulos sinomdép side du babuy. Ey bigla a minagpaginan du babuy a bulnok, a sinumegbu to diget, a tulos de a minalimés. ");
INSERT INTO dgc_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nadid, du mégbantay du babuy, éy ginuminan side. Ey kédemét de to banuwan de, éy nibaheta de i étanan a nanyari; pati tu nanyari to éduwa a hinayup. ");
INSERT INTO dgc_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kanya inumange sa du étanan a tolay ta banuwan, monda meta de ti Jesus. Ey péketa de diya, éy nipékiohon de diya a humektat siya to lugar de. ");
INSERT INTO dgc_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Nadid, sinumakay de Jesus to abeng de, a inumahabes man dén side, a tulos nagsoli side to banuwan de. ");
INSERT INTO dgc_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ey du tolay sa, kembil de diya i esa a lumpu. Siya éy te katidug san to kama na. Ey ti Jesus, péketa na a méniwala side diya, éy kinagi na to lumpu, a “Patibayén mo i isip mua, Anéng. Pinatawad ka dén ta kasalanan mo.” ");
INSERT INTO dgc_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Nadid, du maistu sa ta rilihiyon, pékabati de to kinagi ni Jesus, éy mégisip side a, “Anya i lélake a éye; isip na Diyos siya?” ");
INSERT INTO dgc_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Pero ti Jesus, tukoy na dén i isip dia, a kinagi na dide, a “Bakit mégisip kam ta kona sina a medukés? ");
INSERT INTO dgc_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Tama,” kagi na, “maari i maski ti ésiya a mégwari-wari a magpatawad ta kasalanan na tolay. Pero ti ésiya i maaria a makapagpalakad ta lumpu a tolay? ");
INSERT INTO dgc_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nadid,” kagi na, “sakén i lélake a gébwat ta langet; éy patunayan ko dikam a te kapangyarianék a magpatawad ta kasalanan, a péglakadén ko i lumpuae.” Nadid, kinagi ni Jesus to lumpu, a “Nay, umégkat ka dén, a alapén mo dén i kama mua, a ikad mo dén ta bile moy.” ");
INSERT INTO dgc_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Nadid, pékabati no lumpu ta éya, éy inumégkat ngani dén, sakay nagsoli ta bile na. ");
INSERT INTO dgc_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ey du tolay sa, péketa de ta éya, éy méganteng side, a pinuri de i Diyos da nangatéd ta tolay ta kona sa a kapangyarian. ");
INSERT INTO dgc_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Nadid, to kéhektat ni Jesus ta éya, éy neta na i esa a lélake a ti Mateo i ngahen na. Te eknud siya to pégsingihan ta buwes. Ey kinagi ni Jesus diya, a “Kumuyog ka diyakén a maging alagad ko.” Ey tinumaknég ti Mateo, a inumunonod diya. ");
INSERT INTO dgc_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Nadid, to péngan ni Jesus to bile ni Mateo, éy inumange be sa a nékidipon dide i meadu a makasalanan a tolay, sakay du mégpabuwes. (Side i méngdaya ta tolay.) Ey édsa be sa du alagad ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ey du Pariseyo, péketa de, éy kinagi de du alagad ni Jesus, a “Bakit mékidipon tu maistu moy du makasalanan a tolay?” ");
INSERT INTO dgc_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ey ti Jesus, pékabati na dide, éy kinagi na, a “Bakit? Du mahusay éy éwan side tu kailangan ta magamot, éngˈwan du te saket. ");
INSERT INTO dgc_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ikad moy dén,” kagi na, “sakay isipén moy i kahulugen na éye; da kagi na Diyos, a bakén a regalo moy i gustu naa, éngˈwan tu kagbi moy ta tolay. Da sakén, éy éwanék se inumange a monda tumulung du mahusay a tolay. Engˈwan, du makasalanan i tulungan kua.” ");
INSERT INTO dgc_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nadid, du alagad ni Juan a Mégbinyag, éy inumange side ni Jesus, a kinagi de diya, a “Sikame, éy medalas kame a mégkulasiyon. Ey kona be sa du Pariseyo. Pero du alagad mo, éy bakit éwan side mégkulasiyon?” ");
INSERT INTO dgc_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ey kinagi ni Jesus dide, a “Ataay, maari beman a mégsisi i tolay éng kaguman de pabi i ikasal? Bagay éwan dén sa tu kadimoy de a ikasal, éy saya i oras de a magsisi a magkulasiyon. ");
INSERT INTO dgc_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Ewan tu nagtagpi ta bigu a resato to dati dén a badu,” kagi ni Jesus. “Da éng kona sa, éy péknetén no bigu tu dati, éy lalo dén a melawa tu ébut no badu. ");
INSERT INTO dgc_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ewan be tu méngiasék ta bigu a alak ta dati a pégaskanan. Bagay kona sa i ginamet, éy pomtak tu pégaskanan, da dati, a tulos mebulak tu alak. Sakay mawasak be dén tu pégaskanan. Maigi pa éy iasék i bigu a alak ta bigu be a pégaskanan. Eng kona sa éy pareho side a male.” Bébe a Minangkébil Ni Jesus ");
INSERT INTO dgc_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Nadid, to pégkagi pabi ni Jesus du Pariseyo, éy dinumemét sa i esa a mataas a Judeo. Linumuhud siya ta harapa ni Jesus, a kinagi na, a “Minate dén tu anak ko. Kita pad dén a itupu pad i kamét mua diya, monda mabuhay siya.” ");
INSERT INTO dgc_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ey kinumuyog ti Jesus diya. Pati du alagad na. ");
INSERT INTO dgc_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","To péglakad de, éy kaununod na i esa a bébe a labindalawa dén a taon a mégdédigién. Kinagi na dén to isip na, a “Eng makbilan ko san i damit naa, éy maghusayék dén.” Kanya inumadene siya to adég ni Jesus, sakay kembilan na tu ontok san no badu na. ");
INSERT INTO dgc_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ey sinumuleg ti Jesus, éy péketa na diya, éy kinagi na, a “Anéng, diyan ka méganteng. Pinahusay ka dén na péniwala mo diyakén.” Ey to éya be san, éy naghusay tu bébe. ");
INSERT INTO dgc_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Nadid, kédemét de to bile no mataas a Judeo, éy neta de du mégtogtog ta mosiko, sakay du meadu a tolay a mepehéng. ");
INSERT INTO dgc_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ey kinagi ni Jesus dide, a “Lumwas kam dén! Ewan minate i anaka; natidug san.” Ey pinégngihitan de ti Jesus. ");
INSERT INTO dgc_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Pero nadid, to kéluwas du tolay, éy sinomdép ti Jesus, éy kembilan na tu kamét no anak, éy inumégkat. ");
INSERT INTO dgc_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ey kinumalat ta étanan a banuwan ta éya i nanyaria. ");
INSERT INTO dgc_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Nadid, kéhektat ni Jesus ta éya, éy tinagubet siya na éduwa a lélake a buhék. Mégdulaw side a kinagi de, a “Apo ni Dabid, kagbian mo kame!” ");
INSERT INTO dgc_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ey késdép ni Jesus to bile, éy inumadene diya du buhék. Ey kinagi ni Jesus dide, a “Méniwala kam a magimet ko ye?” “O, Panginoon,” kagi de. ");
INSERT INTO dgc_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ey nadid, kembilan na i mata dia, a kinagi na, a “Manyari dikam ayun ta péniwala moy.” ");
INSERT INTO dgc_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ey naketa dén side. Ey pinagbilinan side ni Jesus ta mahigpit, a “Diyan moy ye iyébaheta ta maski ti ésiya.” ");
INSERT INTO dgc_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pero kéhektat de, éy nibébaheta de ta étanan i tungkul ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nadid, to kéhektat du buhék a pinahusay na, éy niange de ni Jesus i esa a bulol a hinayup. ");
INSERT INTO dgc_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ey to pémaibut na to dimonyo, éy négkagi dén tu bulol. Ey nagtaka du tolay, a kinagi de, a “Sapul to éya, éy éwan tu mineta a kona se ta Israelae.” ");
INSERT INTO dgc_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pero du Pariseyo, kinagi de, a “Ti Satanas a mayor du dimonyo i nangatéda diya ta kapangyarian na a mégpaibut du dimonyo.” ");
INSERT INTO dgc_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Nadid, linebut ni Jesus i étanan a banubanuwan ta éya, a nagtoldu siya du kapilya. Nipahayag na i Mahusay a Baheta tungkul ta péghari na Diyos, sakay pinahusay na du tolay ta étanan a sakisaket de. ");
INSERT INTO dgc_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ey péketa na du meaadu a tolay, éy kinagbian na side, da mehirap i buhay de, a éwan tu méngtulung dide. Koman side i tupa a éwan tu mégpastor dide. ");
INSERT INTO dgc_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kanya kinagi na du alagad na, a “Meadu i gapasén, pero kulang i magapas. ");
INSERT INTO dgc_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ipanalangin moy to te koo ta kapahayan, a paange na i meadu a magapas ta kapahayan na.” ");
INSERT INTO dgc_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Nadid, pinauwet ni Jesus du labindalawa a alagad na, sakay inatdinan na side ta kapangyarian de a magpaibut ta medukés a espiritu, sakay magpahusay ta étanan a te saket. ");
INSERT INTO dgc_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Saye i ngahina du labindalawa a apostol: purumeru ti Simon a pinalayawan de a Pedro, sakay ti Andres a wadi na. Sakay ti Santiago éy ti Juan, a anak side ni Sebedeo. ");
INSERT INTO dgc_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Sakay ti Pelip éy ti Bartolome; ti Tomas éy ti Mateo (siya tu mégpabuwes). Ti Santiago a anak ni Alpeo, éy ti Tadeo; ");
INSERT INTO dgc_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","pati ti Simon a taga Kanan, éy ti Hudas Iskarote, a néngitokyon ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Pinéglakad ni Jesus diden ya, a pinagbilinan na side, a “Diyan kam uméange ta banuwan du éwan Judeo, maski ta banuwan na Samaritano. ");
INSERT INTO dgc_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Engˈwan, itoldu moy san du kapareho tam a Judeo, a lahi ni Israel. Mara side ya du nebut a tupa ni Israel. ");
INSERT INTO dgc_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ipahayag moy dide,” kagi na, “a adene dén a maghari i Diyos. ");
INSERT INTO dgc_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Sakay pahusayén moy du te saket, sakay buhayén moy du pate. Pahusayén moy du te ketong, sakay paibutén moy du dimonyo. Ey tandaan moy, da inatdinan kam na Diyos ta éwan tu bayad, éy kona kam be sa a mangatéd kam be ta éwan tu bayad. ");
INSERT INTO dgc_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Ta péglakad moy,” kagi ni Jesus, “éy diyan kam mégkébil ta kuhata, ");
INSERT INTO dgc_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","sakay diyan kam be mégkébil ta suput, sakay ta pégbaraduan moy. Diyan mo be kébilén i reserba a sinelas, maski sahukod. Da dapat aguman kam du tolduan moy. ");
INSERT INTO dgc_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Maski ahe a banuwan i demtan moy,” kagi na, “éy ahayukén moy i mahusay a tolay a tulusan moy, sakay tumulos kam sa a hanggan éwan kam maglakad. ");
INSERT INTO dgc_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Késdép moy ta tulusan moy a bile, éy batién moy du édsa sa, a kagi moy, a ‘Demtan kam maka na kapayapaan.’ ");
INSERT INTO dgc_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nadid, éng mahusay du tolay ta éya a bile, a tanggapén de kam, éy kagbian side na Diyos a talaga. Pero éng éwan side mahusay, éy bawen moy tu nipangbati moy dide. ");
INSERT INTO dgc_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Eng du tolay ta banuwan, éy éwan de kam tanggapén, éy humektat kam sa, a ihalimbawa moy dide a ipagpag moy ta tikéd moya tu alikabuk. ");
INSERT INTO dgc_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Kédemét na aldew na péghukum,” kagi ni Jesus, “éy lalo a mehirap i mabati du tolay ta éya a banuwan kesira to nabati du taga Sodoma, sakay du taga Gomora to araw.” ");
INSERT INTO dgc_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Tandaan moy,” kagi ni Jesus, “péglakadén ta kam du medukés a tolay. Mara, koman kam i tupa a méglakad ta lubuk du metapang a aso. Mangilag kam dide, pero dapat mebait kam be dide. ");
INSERT INTO dgc_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mangilag kam, da te tolay a méngitokyon dikam ta gubiyerno. Sakay balbalén de kam ta kapilya de. ");
INSERT INTO dgc_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Dahil diyakén, éy iharap de kam ta gubernador sakay hari. Saya i oras moy a pégpatunay moy diyakén dide, sakay pati du éwan Judeo éy patunayan moy. ");
INSERT INTO dgc_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Bagay bistaan de kam,” kagi na, “éy diyan kam métageg éng anya i katuwiran moya dide. Da kédemét na oras, éy iatéd san dikam i katuwiran moya dide. ");
INSERT INTO dgc_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Da éwan sikam i mégkagia, éngˈwan i Espiritu Nama moy i magpakagia dikam ta katuwiran moy. ");
INSERT INTO dgc_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Kédemét na éya a hirap, éy itokyon na tolay du top de a ipabuno. Ey kona be sa i gemténa na lélake to anak de. Sakay du anak éy labanan de dema de, a ipabuno de be side. ");
INSERT INTO dgc_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Sakay kaiyamutan kam na étanan, da méniwala kam diyakén. Pero tu maniwala diyakén a matapat a hanggan éwan siya mate, éy siya i meligtasa. ");
INSERT INTO dgc_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Bagay lélokon de kam to banuwan a édsean moy,” kagi ni Jesus, “éy guminan kam ta banuwan a esa. Tandaan moy, éwan moy pabi maabut i étanan a banuwan na Israel, éy dumeméték dén. Ey sakén i lélake a gébwat ta langet. ");
INSERT INTO dgc_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Ewan mataas tu alagad to maistu na; éwan be mataas tu utusan to amo na. ");
INSERT INTO dgc_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kanya sikam a alagad ko, éy gemtén de dikam tu kona to gégemtén de diyakén a amo moy. Eng ngahinanék de a Satanas, éy lalo dén a medukés i pégpintas de dikam.” ");
INSERT INTO dgc_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Kanya diyan kam méganteng ta tolay,” kagi ni Jesus. “Da maski anya i gemtén de nadid ta lihim éy lumitaw ta esa a panahun. Maski anya i nipamen de nadid, éy mehayag ta esa a panahun. ");
INSERT INTO dgc_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Tu kinagi ko dikam nadid ta lihim, éy ihuway moy a ipahayag ta étanan. ");
INSERT INTO dgc_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Diyan moy antingan du mamuno ta bégi moy, da éwan be side makabuno ta kaliduwa moy. I dapat moy a antingan éy Diyos, da siya i magpakatea ta tolay. Sakay siya i méngibuta ta kaliduwa ta impiyerno. ");
INSERT INTO dgc_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Mara,” kagi ni Jesus, “makabugtong kam ta éduwa a dignés ta esa san a sentimos. Ey maski mura side, éy éwan side mate éng éwan kaluuben Nama mo. ");
INSERT INTO dgc_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ey sikam, mahigit pa sa i péngalaga na dikam. Maski na buk moya, éy nabilang na a étanan. ");
INSERT INTO dgc_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kanya, diyan kam méganteng: mahalaga kam diya kesira du meadu a dignés. ");
INSERT INTO dgc_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Maski ti ésiya i méngipagtapat du tolay, a méniwala siya diyakén, éy ipagtapat ko be Nama ko ta langet. ");
INSERT INTO dgc_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pero maski ti ésiya i tumanggia diyakén ta harap na tolay, éy itanggi ko be Nama ko ta langet.” ");
INSERT INTO dgc_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Diyan moy isipén a kanyaék se inumange éy magpayapa ta mundua. Da éwanék se inumange a magpayapa ta mundua, éngˈwan dahil diyakén, éy maglaban i tolay ta mundua. ");
INSERT INTO dgc_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Dahil diyakén, éy maglébug du patena; sakay maglébug du magmanugeng. ");
INSERT INTO dgc_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Sakay tu kalbug na tolay éy du mététena na. ");
INSERT INTO dgc_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Tu magmahal ta ama na éy ta ina na ta higit pa diyakén, éy éwan siya maari a ipasakup diyakén. Sakay tu magmahal ta anak na ta higit pa diyakén, éy éwan be siya maari a ipasakup diyakén. ");
INSERT INTO dgc_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Sakay éwan maari a ipasakup diyakén i tolay, éng éwan siya kumuyog diyakén a pabayan na i buhay na, maski bunon siya. ");
INSERT INTO dgc_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Dahilan, tu maghangad a meligtas i buhay na, éy mebut a talaga. Pero tu mégpabaya ta buhay na alang-alang diyakén, éy siya i mabuhaya a éwan tu katapusan.” ");
INSERT INTO dgc_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Maski ti ésiya i tumanggapa dikam,” kagi ni Jesus, “éy bilang tinanggapék na be. Sakay tu tumanggap diyakén, éy bilang tinanggap na be tu nagpaange se diyakén. ");
INSERT INTO dgc_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Sakay tu tumanggap ta purupeta da utusan siya na Diyos, éy atdinan siya na Diyos ta kabahagi na gantimpala na éya a purupeta. Sakay tu tumanggap to mahusay a tolay a mékidiyos, dahil to pékidiyos na, éy atdinan siya na Diyos ta kabahagi na gantimpala na éya a tolay. ");
INSERT INTO dgc_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Sakay maski ti ésiya i mangatéda ta maski esa a baso a dinom ta esa diden ye a mababa, da siya i alagad ko, éy atdinan be siya na Diyos ta gantimpala na.” ");
INSERT INTO dgc_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nadid, kétapos ni Jesus a nagbilin du labindalawa a alagad na, éy hinumektat sa siya, da umange siya a magtoldu du banubanuwan ta palebut ta éya. ");
INSERT INTO dgc_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ey ti Juan a Mégbinyag, to édse na ta pihesu, éy nabaheta na tu gégemtén ni Cristo. Kanya pinéglakad ni Juan du alagad na, ");
INSERT INTO dgc_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","a ange de pakelagip diya éng siya ngani dén i nipangakua na Diyos a umange se a tagapagligtas de, o maguhay pa side ta esa? ");
INSERT INTO dgc_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ey to pégpakelagip de ni Jesus ta éya, éy kinagi na dide, a “Magsoli kam ni Juan, a ikagi moy diya i mineta moy ta éye, ");
INSERT INTO dgc_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","a naketa dén du buhék, nakapaglakad du lumpu, naghusay dén du te ketong, nakabati dén du tuléng, sakay nabuhay dén du pate. Sakay ikagi moy be ni Juan, a tinétolduan ko du pobre ta Mahusay a Baheta. ");
INSERT INTO dgc_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Sakay kagi moy be diya a masuwerte du tolay a éwan mégidel diyakén.” ");
INSERT INTO dgc_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nadid, to kéhektat dén du alagad ni Juan, éy négkagi ti Jesus du tolay sa ta tungkul ni Juan. “To kéluwas moy ni Juan ta ilang a lugar,” kagi na, “éy bakit inumange kam diya? Gustu moy wade meta i lélake a mehina a koman san i lamon a sésébyugén na pahés? ");
INSERT INTO dgc_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","O siguru gustu moy meta i lélake a te badu ta kamahalan? Pero éwan, da du te badu ta kamahalan éy mégiyan side ta bile na hari. ");
INSERT INTO dgc_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","I gustu moy ngani sa a meta moy éy purupeta! O, tama ya. Ey maigi ngani ti Juan du iba a purupeta. ");
INSERT INTO dgc_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Da ti Juan i nihulaa to kasulatan, to pégkagi na, a ‘Tandaan moy. Siya i pinakangbégi ko. Pégdetulén ko siya diko, monda paghandaén na du tolay ta demtan mo.’ ");
INSERT INTO dgc_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Tandaan moy,” kagi ni Jesus, “du étanan a tolay ta mundua, éy éwan tu mataas ni Juan a Mégbinyag. Pero i mababaa a tolay ta kaharian na Diyos, éy mataas side diya. ");
INSERT INTO dgc_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Sapul to pégtoldu ni Juan a Mégbinyag, a hanggan nadid, éy pumépilit du tolay a ipasakup ta kaharian na Diyos. Ey du metapang, éy pilitén de a somdép. ");
INSERT INTO dgc_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Dahilan, du étanan a purupeta, sakay tu utus ni Moises, éy nagpahayag side tungkul ta péghari na Diyos, a hanggan to panahun ni Juan. ");
INSERT INTO dgc_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ey nadid, éng gustu moy a maniwala, éy siya ngani dén ina ti Elias a kagi de a dumemét. Da nihula de a magsoli siya. ");
INSERT INTO dgc_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Eng makabati kam, éy baten moy ya. ");
INSERT INTO dgc_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Pakodyan ko a méngihalimbawa di tolaya nadid?” kagi ni Jesus. “Mara, kapareho side na anak a te eknud ta plasa, a mégpépintasén side ta kaéyag de. ");
INSERT INTO dgc_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Mara kagi de dide, a ‘Tinogtogen me kam, pero éwan kam nagsayaw. Ey to pégsanget me, éy éwan kam nalungkut dikame.’ ");
INSERT INTO dgc_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ey kona be sa di tolaya,” kagi ni Jesus, “da ugali ni Juan, éy nagkulasiyon, a éwan méginom ta alak, éy pinintasan de a hinayup. ");
INSERT INTO dgc_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Pero sakén, éy mahusayék a méngan éy ta méginom, éy pintasanék de be, a kagi de a medémoték a méngan éy ta méginom. Sakay pintasanék de be a mékiagumék du mégpabuwes sakay du makasalanan. Pero pabayan moy ya. Tukoy moy éng tama i gimet ko bagay meta moy tu bunga ko, éng mahusay.” ");
INSERT INTO dgc_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Nadid, pinagsisian ni Jesus du banubanuwan, da ginimet na dén dide i meadu a makataka-taka, pero éwan side nagsisi to kasalanan de. ");
INSERT INTO dgc_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Kakakagbi kam,” kagi na, “sikam a taga Korasin! Kakakagbi kam, sikam a taga Betsayda! Da ginimet ko dén ta harap moy i meadu a makataka-taka, éy éwan kam nagsisi. Pero du tolay ta Tiro sakay ta Sidon to araw, éng neta de maka to araw tu mineta moy, éy talaga nagsisi side. Nagbadu maka dén side ta kostal, sakay mégiknud ta abu, monda magpatunay side a nagsisi side a talaga. ");
INSERT INTO dgc_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Kanya ta péghukum na Diyos, éy masiyadu a mehirap i sapitén moy kesira ta sinapit du taga Tiro éy ta Sidon. ");
INSERT INTO dgc_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Sakay sikam a taga Kapernaum,” kagi ni Jesus, “i pégpalalo moya éy makaabut kam ta langet, pero i abutén moy sana éy impiyerno! Pero éng mineta maka du taga Sodoma to araw i mineta moya a makataka-taka, éy éwan side nibagsak na Diyos, da talaga a nagsisi side. ");
INSERT INTO dgc_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Kanya tandaan moy, ta péghukum na Diyos, éy masiyadu a mehirap i sapitén moy kesira ta sinapit na Sodoma!” ");
INSERT INTO dgc_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Nadid, nanalangin ti Jesus, a kinagi na, a “Mégpasalamaték diko, Améng. Siko i Panginoon ta langet éy ta mundua. Salamat, Améng, da éwan mo nipékipospos tu kaluuben mo du matalinung a mataas a tolay; éngˈwan i néngipaliwanagen mua éy du mababa. ");
INSERT INTO dgc_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","O ngani, Améng, da kona sa i gustu mua.” ");
INSERT INTO dgc_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Nadid, kinagi na du alagad na, a “Tama ko a Diyos, éy inatdinanék na ta étanan. Ey éwan tu makatukoy diyakén, éng éwan Tama ko san. Ey éwan be tu nakatukoy Nama ko, éng éwan sakén san a anak na, sakay du nagpahayagen ko tungkul diya. ");
INSERT INTO dgc_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Umadene kam diyakén, sikam a étanan a pagel dahil ta medégi a kébil moy, sakay paimangén ta kam. ");
INSERT INTO dgc_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Sundin moy san i utus kua, sakay magadal kam diyakén. Da sakén éy mebaiték a mababa, éy paimangén ko i buhay moya. ");
INSERT INTO dgc_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ey melagin i utus kua, sakay éwan medégi i pakébil kua dikam.” ");
INSERT INTO dgc_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","To esa a aldew a pangilin, éy dinumiman de Jesus to kapahayan. Ey nagalép du alagad na; kanya nagkétoh side ta tégesa a ohay, a kékéselén de. ");
INSERT INTO dgc_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ey péketa dide du Pariseyo, éy kinagi de, a “Entan mo i gimet di alagad mua! Bawal ina éng pangilin, da tarabaho ina!” ");
INSERT INTO dgc_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","“Ewan,” kagi ni Jesus. “Bakit, éwan moy wade nabasa tu ginimet ni Dabid to araw, to pégalép de sakay du kaguman na? ");
INSERT INTO dgc_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Basta sinomdép siya to bile na Diyos. Ey tu te déton sa a tinapay a para ta Diyos, éy kinan na; sakay pinakan na be du kaguman na. Ey bawal kan ya ta utus,” kagi ni Jesus, “da du padi san i maari kana a méngan ta éya. ");
INSERT INTO dgc_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Bakit, éwan moy wade be nabasa tu utus ni Moises, a mégtarabaho du padi ta tuwing pangilin, da gemtén de i tungkulin de ta lubuk no Templo. Ey maski bawal kan ya, éy éwan side tu kasalanan. ");
INSERT INTO dgc_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ey sakén éy laloék a mahigpit kesira to Templo. ");
INSERT INTO dgc_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","“Ewan moy maka pinintasan du éwan tu kasalanan éng tukoy moy maka dén i kahulugen na kagi a éye na Diyos, a ‘Bakén a regalo moy i gustu kua, éngˈwan kagbi moy ta tolay.’ ");
INSERT INTO dgc_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Da sakén i lélake a gébwat ta langet,” kagi ni Jesus. “Ey sakén i mégkagia éng anya i tama a gimet ta aldew a pangilin.” ");
INSERT INTO dgc_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Nadid, hinumektat sa ti Jesus, a inumange to kapilya de a esa. ");
INSERT INTO dgc_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ey te lélake sa a pile tu kamét. Ey te tolay be sa a iba, a gustu de a iabla ti Jesus a manglabag ta utus. Kanya pinuhubaan de siya a kinagi de, a “Anya wade, labag ta utus éng magamot ta tolay ta pangilin, o éwan?” ");
INSERT INTO dgc_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ey kinagi ni Jesus dide, a “Eng mara sikam, éng melokbung tu tupa moy ta ébut, éy anya, éwan moy beman iahawas bagay pangilin! ");
INSERT INTO dgc_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ey higit pa a mahalaga i tolay kesira ta tupa. Kanya éwan bawal ta utus tam éng aguman tam i te hirap ta pangilin.” ");
INSERT INTO dgc_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nadid, kinagi ni Jesus to pile tu kamét, a “Iolnat mo i kamét mua.” Ey to péngiolnat na, éy naghusay dén a kapareho no kamét na a esa. ");
INSERT INTO dgc_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ey linumwas sa du Pariseyo, a néguhon side éng kodya i pamuno dia ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Nadid, pékatukoy ni Jesus ta hangad de, éy hinumektat sa siya. Ey meadu i tinumagubet diya. Ey pinahusay na du étanan a te ladu, ");
INSERT INTO dgc_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","a pinagbilinan na side a diyan de iyébaheta i tungkul diya. ");
INSERT INTO dgc_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Saya i pangtupada to nihula ni Purupeta Isayas to araw, a ");
INSERT INTO dgc_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Siya ya i utusan ko a pinili ko,” kagi na Diyos. “Siya i mahal ko a késayaan ko. Iatéd ko diya i Espiritu ko, sakay ipahayag na i katutuhanan ta tolay. ");
INSERT INTO dgc_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ewan siya makipaglébug, éwan siya mepehéng, éwan siya mégdulaw ta karsada ta banuwan; ");
INSERT INTO dgc_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","éwan na paghirapén du mehina a tolay, éwan na édépén i simbu a mégkulidépdép. Pumilit siya a hanggan éwan manalo i katutuhanan; ");
INSERT INTO dgc_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Siya i asaan na étanan a tolay.” ");
INSERT INTO dgc_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nadid, niange de ni Jesus i esa a lélake a buhék sakay bulol pa siya, da hinayup. Ey pinahusay na; tulos nakapégkagi dén sakay naketa dén. ");
INSERT INTO dgc_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ey nagtaka du étanan a tolay, a kinagi de a “Séˈ wade ye i apoa ni Dabid a nihula de?” ");
INSERT INTO dgc_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pero du Pariseyo, pékabati de ta éya, éy kinagi de, a “Kanya makapégpaibut siya du dimonyo éy inatdinan siya ni Satanas ta kapangyarian na. Ti Satanas a mayor du dimonyo.” ");
INSERT INTO dgc_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Pero tukoy ni Jesus i isip de, a kinagi na dide, a “Eng mara, maski ahe a banuwan, éng néglébug side, éy bumagsak a talaga. Sakay maski ahe a bile, éng néglébug side, éy éwan male i buhay de. ");
INSERT INTO dgc_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ey nadid sakén, bakit kagi moy a inatdinanék kan ni Satanas ta kapangyarian na a magpaibut du katulung na a dimonyo? Lélbugén beman ni Satanas i sarili na? Eng kona sa,” kagi ni Jesus, “éy bumagsak siya a talaga. ");
INSERT INTO dgc_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Bakit kagi moy a gébwat ni Satanas i kapangyarian ko a mangpaibut ta dimonyo? Ey anya du tolay moy? Eng ibutan de i dimonyo, éwan beman gébwat ta Diyos i kapangyarian de? Kanya side i mégpatunaya a kakabulyan tu péngupos moy diyakén! ");
INSERT INTO dgc_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Pero éng Espiritu na Diyos i nangatéda diyakén ta kapangyarian ko a magpaibut du dimonyo, éy saya i katunayana a dumemét dén dikam i péghari na Diyos ta tolay. ");
INSERT INTO dgc_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Da éwan tu makapagpaibut du kasakupan ni Satanas, éngˈwan na pa matalo ti Satanas. Pero éng natalo na dén siya, éy maari na dén a alapén i kasakupan na. ");
INSERT INTO dgc_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Tu éwan kampi diyakén,” kagi ni Jesus, “éy kontara diyakén. Ey tu éwan tumulung diyakén a méngidulug ta tolay, éy nangangahulugen éy paadeyoén na du tolay diyakén. ");
INSERT INTO dgc_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","Kanya tandaan moy, pagpasensiyaan i tolay ta maski anya a kasalanan de, sakay ta péngupos de ta tolay. Maski ta péngupos de diyakén a nagébwat ta langet, éy pagpasensiyaan side na Diyos. Pero tu mangupos ta Banal a Espiritu, éy saya i éwana pagpasensiyaan na Diyos, maski nadid, a hanggan nikésiya.” ");
INSERT INTO dgc_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Tu mahusay a kayo, éy mégbunga ta mahusay a bunga. Ey tu medukés a kayo,” kagi na, “éy mégbunga ta medukés a bunga. Da matenggi mo tu kayo bagay meta mo i bunga naa. ");
INSERT INTO dgc_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ey kona be sa dikam, sikam a magkadukés a tolay! Pakodya moy a mégkagi ta mahusay, bagay medukés kam? Da i kagi moya, éy siya be san i édse ta isip moya. ");
INSERT INTO dgc_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Dahilan i mahusay a tolay, éy gemtén de i mahusay. Ey du medukés a tolay, éy gemtén de i medukés. ");
INSERT INTO dgc_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Ey tandaan moy,” kagi ni Jesus, “kédemét na péghukum, éy panagutan na tolay i bawat kinagi de a medukés. ");
INSERT INTO dgc_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Makay parusaan kam dahil to kinagi moy, o makay meligtas kam.” ");
INSERT INTO dgc_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nadid, du maistu ta rilihiyon, sakay du Pariseyo, éy inumange side ni Jesus, a kinagi de diya, a “Maistu, ipeta mo dikame i tanda a makataka-taka.” ");
INSERT INTO dgc_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","“Diden ye a lahi a Judeo éy magkadukés,” kagi ni Jesus. “Pinabayan moy dén i Diyos. Piliténék moy a ipeta ko dikam i tanda, pero éwanék tu ipeta dikam a tanda, éngˈwan tu nanyari san ni Purupeta Honas to araw. ");
INSERT INTO dgc_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Eng kodya ti Honas a étélo a aldew to tiyan no dikél a ikan, éy konaék be sa, sakén a lélake a gébwat ta langet, a étéloék be a aldew ta disalad na luta. ");
INSERT INTO dgc_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“Kédemét na péghukum na Diyos,” kagi ni Jesus, “éy tumaknég du taga Ninibe a iabla de kam a lahi a Judeo, da nagsisi side to pégtoldu ni Honas dide. Ey nadid éy te mataas ni Honas ta éye a mégtoldu dikam, éy éwan kam mégsisi. ");
INSERT INTO dgc_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Pati tu hari a bébe a taga Kabagatan to araw, éy tumaknég be siya ta péghukum a mangiabla dikam. Da siya éy inumange se a gébwat ta adeyo, monda baten na i memahal a pégtoldu ni Solomon. Ey nadid te mataas ni Solomon ta éye a mégtoldu dikam, éy éwan moy bébaten.” Méniwala Ta Diyos Ta Hustu ");
INSERT INTO dgc_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Bagay umibut tu medukés a espiritu ta bégi na tolay,” kagi ni Jesus, “éy méglebut ta ilang a lugar a mégahayok ta imangan na. Nadid, éng éwan tu meeta, ");
INSERT INTO dgc_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","éy kagi na, a ‘Magsoliék to kinagébwatan ko a négiyanan ko.’ Ey kédemét na éy dinemtan na a éwan tu lasén, sakay melinis a mahusay dén. ");
INSERT INTO dgc_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Kanya inakit na i pitu a iba a espiritu a medukés pa diya, éy sinomdép side a négiyan sa side. Kanya lalo a medukés to neditol i kalagayan na éya a tolay. Ey nadid, éy kona be sa i manyaria dikam a medukés a lahi a éye!” ");
INSERT INTO dgc_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nadid, to pégtoldu pabi ni Jesus, éy dinumemét sa dena na sakay du tétotop na. Méguhay side ta luwas, a gustu de mékiohon diya. ");
INSERT INTO dgc_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Te négkagi diya, a “Kéye ta luwas dena mo éy du tétotop mo, a gustu de ka a uhunén.” ");
INSERT INTO dgc_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Pero kinagi ni Jesus, a “Ti ésiya i ina kua sakay ta tétotop kua?” ");
INSERT INTO dgc_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ey nitoldu na du alagad na, a kinagi na, a “Side ye di ina kua, sakay top ko, ");
INSERT INTO dgc_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","dahilan, du mangtupad ta utus Nama ko ta langet, éy side di ina kua éy ta tétotop ko.” ");
INSERT INTO dgc_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nadid, to éya a mismo a aldew, éy linumwas ti Jesus to bile, a inumange siya a mégiknud to digdig no diget. ");
INSERT INTO dgc_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ey meaadu i dinumuluga diya, a hanggan da sinumakay ti Jesus to abeng, a négiknud sa a mégtoldu du tolay. Ey side éy te taknég san to baybay. ");
INSERT INTO dgc_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ey tinolduan na side ta halimbawa a kona se: “Eng mara,” kagi na, “éy te esa kan a lélake a mégsabug to binhi na. ");
INSERT INTO dgc_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ey to pégsabug na éy te sénganya wade a butil a minepégsek to dilan. Ey kinan na manok. ");
INSERT INTO dgc_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ey te sénganya wade be a nepégsek to bito-bito. Ey agad kan side a nagtubu, da melapis i luta ta éya. ");
INSERT INTO dgc_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pero minalanés side, da mepasi i bilag, éy éwan kan masiyadu i gimot de. ");
INSERT INTO dgc_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ey te sénganya wade be a nepégsek to kalamonan, éy nailongan na lamon. ");
INSERT INTO dgc_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ey tu iba a binhi, éy nesabug kan dén ta mahusay a luta. Ey nagohay side. Te tégsésandaan, te tégéném a pulu, te tégétélo a pulu a butil i bawat ohay. ");
INSERT INTO dgc_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ey nadid,” kagi ni Jesus, “éng makabati kam, éy baten moy ya.” ");
INSERT INTO dgc_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nadid du alagad ni Jesus, nipakelagip de diya éng bakit purus a halimbawa i gamitén naa, bagay mégtoldu siya du tolay. ");
INSERT INTO dgc_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ey kinagi ni Jesus dide, a “Ipeta san dikam na Diyos i kahulugen na lihim tungkul ta péghari na ta tolay. Pero du iba a tolay, éy éwan. ");
INSERT INTO dgc_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Dahilan side a mégéisipén ta itoldu kua, éy dagdagen na Diyos i isip de, monda mapospusan de ta mahusay. Pero du metamad a mégisip ta itoldu kua, éy bawasan na Diyos tu isip de a hanggan éwan side tu mapospusan. ");
INSERT INTO dgc_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kanya halimbawa i gemtén ko, bagay mégtolduék dide; da maski metaék de, a mégbati side diyakén, éy éwan de mapospusan. ");
INSERT INTO dgc_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Natupad ngani dén dide tu nihula ni Isayas, to pégkagi na ta kagi na Diyos, a ‘Mégbati kam a mégbati, éy éwan moy be mapospusan; lumameng kam a lumameng, éy éwan kam be maketa ta katutuhanan. ");
INSERT INTO dgc_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Da mehina i isipa di tolay a éye; Mehirap a makabati i talinga dia, nikihép de i mata dia. Dahilan, sala de a meta, sala de a makabati, sala de a mapospusan. Da sala de a magsoli diyakén,’ kagi na Diyos, ‘monda pahusayén ko side.’ ");
INSERT INTO dgc_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Pero sikam a alagad ko,” kagi ni Jesus, “éy masuwerte kam, da maketa kam, sakay makabati kam ta katutuhanan. ");
INSERT INTO dgc_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Tandaan moy, meadu i purupeta sakay mahusay a tolay a gustu de meta i meeta moya, pero éwan de neta. Sakay gustu de a mabati i mébati moya, pero éwan de nabate.” ");
INSERT INTO dgc_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Baten moy i kahulugen na halimbawa tungkul ta mégsabug,” kagi na. ");
INSERT INTO dgc_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","“Mara du mégbati ta kagi a tungkul ta péghari na Diyos, sakay éwan de napospusan, éy kapareho side no binhi a nepégsek to dilan. Ey dumemét ti Satanas, a inagew na ta isip de tu kagi a nabati de. ");
INSERT INTO dgc_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ey tu nepégsek to bito-bito, mara saya i makabatia ta kagi na Diyos, a masaya side a tanggapén de agad. ");
INSERT INTO dgc_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pero éwan side makatagal, da kapareho side no binhi a éwan nakagimot. Méniwala side ta sandali, pero kédemét na paghirap de, dahil ta péniwala de, éy ginanan de tu tinanggap de. ");
INSERT INTO dgc_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ey tu nepégsek to kalamonan, mara saya i makabatia ta kagi na Diyos, pero éwan magbunga tu kagi na Diyos ta isip dia, da kapareho side no binhi a nailongan. Mara i nakailonga dide éy tu pégisip de ta kabuhayan de sakay ta kayamanan de. ");
INSERT INTO dgc_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ey tu binhi a nesabug ta mahusay a luta,” kagi ni Jesus, “mara saya i makabatia ta kagi na Diyos, a mapospusan de. Ey magbunga i kagi na Diyos ta isip de ta tégsésandaan, éy ta tégéném a pulu, éy ta tégétélo a pulu.” ");
INSERT INTO dgc_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Nadid, kinagi na dide i esa man dén a halimbawa: “I pégharia na Diyos,” kagi na, “éy kapareho no lélake a naghasik ta mahusay a binhi to uma na. ");
INSERT INTO dgc_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ey to esa kan a kélép, a tidug san side, éy dinumemét tu kalbug na, a tulos na nihasik to kapahayan i medukés a lamon. Sakay minéglakad. ");
INSERT INTO dgc_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nadid, to pégtubu no pahay, a nagohay dén, éy minagtubu be kan tu lamon a magkadukés. ");
INSERT INTO dgc_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ey du utusan no lélake, éy inange de kan a kinagi de diya, a ‘Ewan beman mahusay a binhi tu nihasik mo to uma mo? Bakit melamon nadid?’ ");
INSERT INTO dgc_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ey kinagi kan no lélake, a ‘Saya i gimita no esa a kalbug tam.’ ‘Ey anya,’ kagi de kan, ‘gustu mo bagutén me diden ya?’ ");
INSERT INTO dgc_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‘Diyan moy,’ kagi na kan. ‘Makay pati pahay éy mabagut moy. ");
INSERT INTO dgc_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Basta pabayan moy dén a mégtubu a kapareho na pahay, a hanggan ta pégladéy. Ey ta pégladéy,’ kagi na, ‘éy utusan ko san du magladéy, a bagutén de pa du lamon, sakay bédbéden de a monda ipatutod ko. Sakay tu pahay éy ipalunpun de ta kamalig ko.’” ");
INSERT INTO dgc_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Nadid, kinagi na dide i esa man dén a halimbawa: “I péghari na Diyos,” kagi na, “éy kapareho na éye: Te esa kan wade a lélake a nagmula ta isesa a bukél na mustasa to uma na. ");
INSERT INTO dgc_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kakétihékan ya ta maski anya a bukél, pero éng magtubu dén éy kadikélan ya ta étanan a kayo, a hanggan makapaglobun du manok ta tingi-tingi na.” ");
INSERT INTO dgc_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Nadid, kinagi na dide i esa man dén a halimbawa: “I péghari na Diyos,” kagi na, “éy kapareho no pégpaalsa a ihalu no bébe to étélo a takal a arina, éy umalsa tu étanan a linamas.” ");
INSERT INTO dgc_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Nadid, i étanan a kinagi ni Jesus a éya du tolay, éy purus a halimbawa. Ewan tu kinagi dide a éwan halimbawa. ");
INSERT INTO dgc_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Saya i pangtupada to nihula no purupeta to araw, a “Halimbawa kan i gamitén ni Cristo, bagay magtoldu siya dide. Ipaliwanag na dide i bagay a éwan tu nakapospos sapul to nipanglalang ta mundua.” Tungkul To Lamon To Kapahayan ");
INSERT INTO dgc_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Nadid, gininanan ni Jesus du tolay, a sinomdép to bile. Ey nipakelagip diya du alagad na éng anya i kahulugina no halimbawa tungkul to lamon to kapahayan. ");
INSERT INTO dgc_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ey kinagi ni Jesus dide, a “Tu méghasik ta mahusay a binhi éy sakén a lélake a gébwat ta langet. ");
INSERT INTO dgc_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Tu uma éy na mundua. I mahusay a binhi éy du tolay a pégharian na Diyos, sakay du magkadukés a lamon éy du tolay a pégharian ni Satanas. ");
INSERT INTO dgc_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ey tu kalbug de a naghasik to lamon, éy ti Satanas ngani dén. I panahun a pégladéy éy saya i katapusan na mundua. Sakay du anghel i magladéya. ");
INSERT INTO dgc_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Eng kodya i pémuhuna to lamon a tutudén, éy kona be sa i pamuhuna na anghel du tolay ta katapusan na mundua. ");
INSERT INTO dgc_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ey sakén i lélake a gébwat ta langet. Ey utusan ko du anghel ko a angen de puhunén du étanan a tolay ta kaharian ko a nangatéd ta pagkasala, sakay puhunén de be du étanan a mégimet ta medukés. ");
INSERT INTO dgc_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Sakay tulos ibatikal de ta dikél a apoy. Ey édsa sa side a mégsésangitén a mégéadiyoyén ta hirap de. ");
INSERT INTO dgc_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ey nadid magdemlag a koman i bilag du mahusay a tolay, ta kaharian Nama de. Nadid,” kagi ni Jesus, “éng makabati kam, éy baten moy ya.” ");
INSERT INTO dgc_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“I péghari na Diyos,” kagi na, “éy koman i kayamanan a te liso to uma. Mineta ya no esa a tolay, éy tinapohan na a huway, a mépagés siya a tahod. Nadid, minéglakad siya a nibugtong na i étanan a ari-arian na, sakay binugtong na i uma a éya. ");
INSERT INTO dgc_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Kona be sa, i péghari na Diyos éy koman i esa a lélake a mégnigosiyo ta memahal a perlas. ");
INSERT INTO dgc_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Nadid, naketa dén siya ta esa a perlas a mahalaga, éy minéglakad sakay nibugtong na i étanan a ari-arian na, sakay binugtong na tu perlas. ");
INSERT INTO dgc_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Kona be sa,” kagi ni Jesus, “i péghari na Diyos éy kapareho be na esa a dikél a rambat a nibatikal to diget, sakay nakaalap ta meadu a sari-sari a ikan. ");
INSERT INTO dgc_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ey nadid, da minaputat dén éy hinela de to baybay, sakay négiknud sa du tolay a monda bukod-bukudén de du ikan. Du mahusay a ikan, éy niasék de to pégdétonan de, pero du medukés éy nibut de dén. ");
INSERT INTO dgc_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Nadid,” kagi na, “kona be sa i manyaria ta katapusan na mundua! Dumemét du anghel a ibukod de du medukés to mahusay. ");
INSERT INTO dgc_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Sakay ibatikal de du medukés ta dikél a apoy. Ey édsa sa side a mégsésangitén a mégéadiyoyén ta hirap de. ");
INSERT INTO dgc_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“Ey anya, napospusan moy dén i étanan a éya,” kagi ni Jesus du alagad na. Ey “O,” kagi de. ");
INSERT INTO dgc_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","“Kanya ngani i bawat makapospos ta kagi na Diyos,” kagi ni Jesus, “éng ipasakup be siya ta péghari na Diyos diya, éy koman siya tu lélake a makaalap to bodega na ta bigu sakay ta dati be.” ");
INSERT INTO dgc_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Nadid, to nipégkagi dén ni Jesus diden ya a halimbawa, éy hinumektat sa siya, ");
INSERT INTO dgc_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","a nagsoli to sarili na a banuwan. Ey kédemét na sa, éy nagtoldu siya du tolay to kapilya de. Ey nagtaka du nakabati diya. I kinagi dia, éy “Ahe i nangalapana na éya a lélake ta karunungan naa? Kodya i pékagimet naa ta makataka-taka? ");
INSERT INTO dgc_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ewan beman saye tu anak no karpentero tam?” kagi de. “Ti ésiya pa ina, éng éwan anak san ni Maria? I top na a lélake éy de Santiago, ti Hose, ti Simon, sakay ti Hudas. ");
INSERT INTO dgc_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Sakay du tétotop na a bébe, éy mégiyan pabi se side,” kagi de. “Bakit mégpataas siya?” ");
INSERT INTO dgc_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Kona sa tu kinagi du tolay to banwan ni Jesus. Kanya éwan side naniwala diya ta éya. Ey kinagi ni Jesus tungkul ta éya, a “I purupeta éy iyégalang ta maski ahe. Pero ta sarili na a banuwan, sakay sarili na a bile, éy éwan siya iyégalang.” ");
INSERT INTO dgc_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ey nadid, éwan minagimet ti Jesus ta éya ta meadu a makataka-taka, da éwan side méniwala diya. ");
INSERT INTO dgc_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nadid, to panahun a éya, éy nabaheta ni Mayor a Herod i tungkul ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","To pékabaheta na, éy kinagi na du utusan na, a “Siya ti Juan a Mégbinyag a nabuhay a huway. Kanya makagimet siya ta makataka-taka.” ");
INSERT INTO dgc_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Kanya binuno ti Juan, éy pinintasan na ti Mayor a Herod, a kinékagi na ni Herod, a “Ewan maari a mékiagum ka ni Herodias, da asawa ina ni wadi mo.” (Ti Herodias éy asawa ni Pelip a wadi ni Herod). Kanya nipadikép ni Herod ti Juan, a nipihesu. ");
INSERT INTO dgc_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Gustu na be ipabunu ti Juan, pero méganteng siya du Judeo, da kagi de a purupeta ti Juan. ");
INSERT INTO dgc_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nadid, kédemét no kapanganakan ni Herod, éy nagsayaw to harap du bisita na tu anak ni Herodias a madiket. Ey ti Mayor a Herod, éy mésahat siya to madiket. ");
INSERT INTO dgc_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Kanya nipangako na a iatéd na diya i maski anya a agidén na. ");
INSERT INTO dgc_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ey nadid, tu nibilin diya nena na, éy kinagi no madiket a, “Gustu ko éy iatéd mo diyakén nadid i penggan a te déton sa tu ulo ni Juan a Mégbinyag!” ");
INSERT INTO dgc_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nadid masiyadu a nagsisi ti Herod, pero éwan siya nakaidel, dahil to nipangako na ta harap du bisita na. Kanya niutus na du sundalu a iatéd de to madiket. ");
INSERT INTO dgc_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ey nipaputol na ti Juan to pihesuan. ");
INSERT INTO dgc_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ey niedton de tu ulo na to penggan, sakay niatéd de be to madiket. Sakay nitulos na dén nena na. ");
INSERT INTO dgc_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ey du alagad ni Juan, éy inumange sa side a nangalap to bangkay na, a tulos de nielbéng. Ey to péngielbéng de, éy inange de nibaheta ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","To pékabati ni Jesus ta éya, éy sinumakay siya to abeng a inumange siya to esa a lugar a éwan tu tolay. Pero du tolay, pékabaheta de a hinumektat dén siya, éy tinumagubet side, a namaybay side a linumekaw. ");
INSERT INTO dgc_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ey to képundu ni Jesus to baybay, éy neta na i meaadu a tolay, éy kinagbian na side. Sakay pinahusay na du te saket dide. ");
INSERT INTO dgc_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nadid, to giapon dén, éy kinagi du alagad ni Jesus, a “Maistu, apon dén, sakay édse kitam ta ilang a lugare. Péglakadén mo dén di tolayae du bariyo-bariyo ta éye, monda makabugtong side ta kanén de.” ");
INSERT INTO dgc_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","“Diyan moy side péglakadén,” kagi ni Jesus, “sikam i mangatéda dide ta kanén de.” ");
INSERT INTO dgc_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","“Ey pakodyan tam,” kagi de, “lima san a momon i bilon tama a tinapay, sakay éduwa a pindang?” ");
INSERT INTO dgc_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","“Dah, iatéd moy se,” kagi na. ");
INSERT INTO dgc_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nadid, pinaeknud na du tolay to kalamonan, sakay inalap na tu lima a tinapay, sakay tu éduwa a pindang. Ey tinumangad siya ta langet a nagpasalamat ta Diyos. Sakay pinuseng-puseng na tu tinapay, a niutus na du alagad na a nihayin de du tolay. ");
INSERT INTO dgc_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ey minéngan side a étanan a minabsog side. Ey hinempésan du alagad tu sobha, éy naputat pa tu sapulu éy ta éduwa a gatang! ");
INSERT INTO dgc_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ey lima a libu a lélake i minéngana ta éya; bukod san du bébe éy ta anak. ");
INSERT INTO dgc_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Nadid, pinasakay ni Jesus du alagad na to abeng, a pinégdetol na side ta dibilew. Ey siya, éy pinasoli na du tolay ta bile de. ");
INSERT INTO dgc_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ey to kéhektat de, éy nanohobuk ti Jesus to buked, a monda manalangin. Ey kédemét no kélép, éy édsa sa siya a isesa. ");
INSERT INTO dgc_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Du alagad, éy kéya dén side ta ditaw, a sésalpukén side na tagmék, da songsong tu abeng. ");
INSERT INTO dgc_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Nadid, to tamo a amulaldew, éy tinumagubet dide ti Jesus, a méglakad ta dibo na diget. ");
INSERT INTO dgc_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ey du alagad, péketa de diya a méglakad ta dibo na digita, éy inumanteng side a tahod, a kinumélanget side, a kinagi de a “Bélet.” ");
INSERT INTO dgc_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pero kinagi dide ni Jesus, a “Diyan kam méganteng, a sakén ye.” ");
INSERT INTO dgc_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Nadid, kinagi ni Pedro, “Eng siko ngani ina, Panginoon, éy paangenék pad sina ta dibo na digita.” ");
INSERT INTO dgc_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ey “Kadon,” kagi ni Jesus. Kanya inumogsad ti Pedro to abeng, a méglakad ta dibo na digita a inumadene ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pero to pékapansing na to pahés, éy inumanteng siya, a nagsapul a inomléd. “Agawénék mo, Panginoon,” kagi na. ");
INSERT INTO dgc_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Nadid, agad siya ginewat ni Jesus. Sakay kinagi na, a “Bakit mégalanganin ka, Pedro? Kétihék bale san i péniwala mo diyakén.” ");
INSERT INTO dgc_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ey nadid, késakay de to abeng, éy hinumintu tu pahés. ");
INSERT INTO dgc_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ey du alagad, sinumamba side diya, a kinagi de, a “Tunay ka ngani a anak na Diyos!” ");
INSERT INTO dgc_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Nadid, to kéahabes de, éy pinumundu side ta Genesaret. ");
INSERT INTO dgc_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ey du tolay ta éya, pékatenggi de ni Jesus, éy nibaheta de agad du étanan a bariyo ta éya, monda niange de diya i étanan a te ladu. ");
INSERT INTO dgc_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ey nékiohon side diya éng maari, éy kébilan du te ladu i ontok san na badu na. Ey du étanan a nangkébil to badu na, éy naghusay. ");
INSERT INTO dgc_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Nadid éy te inumange ni Jesus a Pariseyo, sakay maistu na rilihiyon, a gébwat side ta Jerusalem. Kinagi de diya, a ");
INSERT INTO dgc_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Bakit du alagad mo, éy lélabagén de tu pégtoldu a nipamana dikitam du ninunu tam? Da éng méngan side, éy éwan de ugisan i kamét de a kona ta ugali na rilihiyon tam.” ");
INSERT INTO dgc_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","“Ey sikam,” kagi ni Jesus, “bakit lélabagén moy i utus na Diyos a monda sugsugén moy tu ugali na rilihiyon moy? ");
INSERT INTO dgc_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Da kagi na utus na Diyos, éy ‘Igalang mo tama mo éy tena mo, sakay tu mégkagi ta medukés ta ama na éy ta ina na, éy dapat ipabuno siya.’ ");
INSERT INTO dgc_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pero sikam, éy iyétoldu moy a maski te hirap tu ama no lélake, éy ta ina na, éy éwan siya tu kailangan a tumulung dide, da iatéd na ta Diyos i metulung na maka dide a kuhata. ");
INSERT INTO dgc_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Kanya pébayan moy tu utus na Diyos, alang-alang ta mana moy a pégtoldu. ");
INSERT INTO dgc_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Sikam a mégkukunwari a éwan kam tu kasalanan!” kagi ni Jesus. “Tama bale i nihulaa ni Isayas tungkul dikam: ");
INSERT INTO dgc_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Diden ya a tolay,’ kagi na Diyos, ‘éy igalangék de ta labi dia; pero ta isip dia éy éwan. ");
INSERT INTO dgc_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ewan tu pasa tu pégsamba de diyakén, da kagi de éy gébwat ta Diyos tu pégtoldu de, pero éwan.’” ");
INSERT INTO dgc_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Nadid, pinaadene ni Jesus du tolay diya, sakay kinagi na dide, a “Mégbati kam a isipén moy i kagin kuae: ");
INSERT INTO dgc_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ewan tu isubu na tolay i makapagpadukésa diya ta mata na Diyos; éngˈwan tu bumébéswal ta labi na tolay, éy saya i magpadukésa diya.” ");
INSERT INTO dgc_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Nadid, kétapos na éya, éy inumadene du alagad ni Jesus, a kinagi de diya, a “Napospusan mo a mégdamdam du Pariseyo to kinagi mo?” ");
INSERT INTO dgc_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","14","“Pabayan moy side,” kagi ni Jesus. “Bagutén Nama ko i bawat halaman a éwan na nimula. Palagi side a mégakay ta tolay, pero buhék be side. Bagay buhék i magakay ta buhék be, éy pareho side a matépduk ta ébut.” ");
INSERT INTO dgc_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ey kinagi ni Pedro, a “Ipaliwanag mo dikame i kahulugina no nihalimbawa mo.” ");
INSERT INTO dgc_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","“Ataay,” kagi ni Jesus, “éwan moy bale be napospusan? ");
INSERT INTO dgc_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ewan moy tukoy i isubu moy éy tumulos san ta tiyan, sakay iyétay moy? ");
INSERT INTO dgc_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pero tu bumébéswal ta labi, éy kagi ya a gébwat ta isip na tolay. Saya i magpadukésa ta tolay, da méngatéd dide ta kasalanan de. ");
INSERT INTO dgc_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Dahilan, ta isip na tolay i kégébwatan na medukés. Da mégisip side ta pémuno, péngibébi, péngilélake, pégtako, mégbuli-buli, sakay péngupos. ");
INSERT INTO dgc_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Diden ya i magpadukésa ta tolay. Pero tu méngan a éwan maguges ta kamét, éwan ya kasalanan.” ");
INSERT INTO dgc_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Nadid, hinumektat sa ti Jesus a inumange ta dumanég a se na Tiro sakay ta Sidon. ");
INSERT INTO dgc_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Te bébe sa a taga Kananea a inumadene ni Jesus a kinékagi na ta medegsén, a “Panginoon, Apo ni Dabid! Kagbianék mo! Tu anak ko a bébe, éy binang-aw na dimonyo, sakay masiyadu siya a méghirap.” ");
INSERT INTO dgc_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pero ti Jesus, éy éwan sinumengbet diya. Sakay kinagi diya du alagad na, a “Péglakadén mo dén siya! Mepehéng siya a umunonod dikitam.” ");
INSERT INTO dgc_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ey kinagi ni Jesus, éy “Du Judeo san i niutusa diyakén Nama ko; du tupa ni Israel a netawtaw.” ");
INSERT INTO dgc_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pero nadid, inumadene tu bébe a linumuhud ta harap ni Jesus, a kinagi na, a “Tulunganék pad, Panginoon.” ");
INSERT INTO dgc_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","“Ewan maari a alapén ko tu kanén na anak,” kagi ni Jesus, “a monda ipakan ko du aso.” ");
INSERT INTO dgc_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","“Tahod ngani, Panginoon,” kagi no bébe, “pero du aso éy méngan be side ta mumo a métépduk to lamesa no amo de.” ");
INSERT INTO dgc_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Kanya nadid, éy kinagi ni Jesus diya, a “Dikél i péniwala mo! Pumayagék ta nipékiohon mua.” Ey to éya be san a oras éy naghusay tu anak na. ");
INSERT INTO dgc_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Nadid, hinumektat sa ti Jesus a inumange siya ta diget na Galilea. Ey sinumangkay siya to buked ta éya, a négiknud sa siya. ");
INSERT INTO dgc_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ey dinumemét diya i meaadu a tolay, a te kébil side ta pile, sakay buhék, sakay lumpu, sakay bulol, sakay meadu pa a iba. Niedton de du te ladu ta harapa ni Jesus, éy pinahusay na side. ");
INSERT INTO dgc_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ey dudu tolay sa, éy nagtaka side to péketa de a mégkagi dén du bulol, sakay méképéglakad dén du lumpu, sakay méketa dén du buhék. Ey nagpuri side ta Diyos. ");
INSERT INTO dgc_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Nadid, dinulawan ni Jesus du alagad na, a kinagi na dide, a “Kagbian ko di tolay a éye. Etélo dén a aldew a kaguman ko side éy éwan dén side tu makan. Sala ko side a péglakadén a mégalép; makay kapuyén side ta dilana.” ");
INSERT INTO dgc_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ey kinagi du alagad na, a “Ahe i pangalapan tama ta ipakan tam dide ta ilanga a lugare?” ");
INSERT INTO dgc_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","“Ey sénganya,” kagi na, “i bilon moya sina a tinapay?” “Pitu a momon,” kagi de, “sakay sénganya a kékétihék a ikan.” ");
INSERT INTO dgc_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Nadid, pinaeknud na dudu tolay to luta. ");
INSERT INTO dgc_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Sakay inalap na tu pitu a tinapay sakay du ikan. Nadid, to pégpasalamat na ta Diyos, éy pinuseng-puseng na ya, sakay niatéd na du alagad na, a tulos nihayin de du tolay. ");
INSERT INTO dgc_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ey minéngan side a étanan a minabsog side. Nadid, hinempésan du alagad tu sobha, éy naputat pa tu pitu a gatang. ");
INSERT INTO dgc_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Epat a libu a lélake i minéngana ta éya; bukod pa du bébe éy ta anak. ");
INSERT INTO dgc_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Nadid, pinéglakad ni Jesus dudu tolay, sakay sinumakay siya to abeng, a naglakad ta Magadan. ");
INSERT INTO dgc_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Nadid, inumange ni Jesus i sénganya a Pariseyo, sakay du Saduseyo. Puhubaan de siya a pilitén de a ipeta na dide i tanda a makataka-taka ta langet. ");
INSERT INTO dgc_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ey kinagi ni Jesus dide, a “Mépospusan moy i tanda na panahun, da éng apon dén éy kagi moy a mahusay i panahun ta gabia, da medemlag i langet. ");
INSERT INTO dgc_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ey ta gagabi éy kékagin moy a maguden, da mediklém i langet. Nabasa moy bale i tanda ta langet, pero éwan moy tukoy du tanda a mégpatunay diyakén! ");
INSERT INTO dgc_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Diden ye a lahi a Judeo éy magkadukés,” kagi ni Jesus. “Pinabayan moy dén i Diyos. Piliténék moy a ipéta ko dikam i tanda, pero éwanék tu ipeta dikam a tanda, éngˈwan tu nanyari san ni Purupeta Honas to araw.” Nadid, to pégkagi ni Jesus ta éya dide, éy gininanan na side. ");
INSERT INTO dgc_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nadid, kédemét de ta dibilew, éy naleksapan bale du alagad a nagkébil ta bilon de a tinapay. ");
INSERT INTO dgc_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ey kinagi ni Jesus dide, a “Mangilag kam ta pégpaalsa du Pariseyo sakay du Saduseyo.” ");
INSERT INTO dgc_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ey du alagad, pékabati de ta éya, éy mégpéguhon side éng anya i kahulugen na éya. “Kodya éwan kitam tu kébil a tinapay,” kagi de. “Kanya na wade kinagi i éya.” ");
INSERT INTO dgc_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ey tukoy ni Jesus tu uhon de, kanya kinagi na dide, a “Bakit péguhunan moy a éwan kam tu bilon a tinapay? Masiyadu a kétihék tu péniwala moy! ");
INSERT INTO dgc_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ewan moy beman tukoy a éwan tinapay i pégkagian kua? Bakit, éwan moy natandaan tu pémuseng-puseng ko to lima a tinapay a para ta lima a libu? Sénganya a gatang i sobha a nihempés moy? ");
INSERT INTO dgc_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Sakay tu pitu a tinapay para ta épat a libu, éy sénganya a gatang i sobha a nihempés moy? ");
INSERT INTO dgc_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Bakit, éwan moy napospusan a bakén a tinapay i pégkagian kua? Engˈwan, i pégkagian kua a talaga éy mangilag kam ta pégpaalsa du Pariseyo, sakay du Saduseyo.” ");
INSERT INTO dgc_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Nadid, to pégkagi ni Jesus ta éya, éy napospusan de dén a bakén a tinapay i pangilagen dia, éngˈwan tu pégtoldu du Pariseyo sakay du Saduseyo. ");
INSERT INTO dgc_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Nadid, to kédemét de Jesus ta Sesarea-Pilipo, éy kinagi na du alagad na, a “Ti ésiyaék kan ayun ta kagi na tolay? Ti ésiya kan i lélake a gébwat ta langet?” ");
INSERT INTO dgc_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ey kinagi du alagad na, a “I kagi kana na iba éy ti Juan ka kan a Mégbinyag. Kagi man dén na iba a ti Elias ka kan. Ey te iba be a mégkagi a ti Heremias ka, o purupeta ka kan a esa.” ");
INSERT INTO dgc_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","“Ey sikam,” kagi ni Jesus, “anya i isip moya? Ti ésiyaék?” ");
INSERT INTO dgc_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ey kinagi ni Simon Pedro, a “Siko i Cristo a tiniyak na Diyos a tagapagligtas ta mundua! Siko i anak na tunay a Diyos.” ");
INSERT INTO dgc_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","“Masuwerte ka, Simon,” kagi ni Jesus, “da éwan tolay i néngipaliwanag ta éya diko, éngˈwan Tama ko ta langet. ");
INSERT INTO dgc_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ey tandaan mo, i pégngahen kua diko éy Pedro (kahulugen ni Pedro ta kagi na Judeo éy bito). Ey ta dibo na bitoae, éy pataknégén ko i simbaan ko, du sakup ko a tolay; éy éwan side madaig na kapangyarian ni Satanas. ");
INSERT INTO dgc_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Iatéd ko diko a siko i tagapamahala du pégharian na Diyos a tolay. Tu ipagbawal mo ta mundua éy ipagbawal be ta langet, sakay tu pakultaden mo ta mundua, éy pakultaden be ya ta langet.” ");
INSERT INTO dgc_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nadid, to pégkagi na ta éya ni Pedro, éy nibilin na du alagad na ta mahigpit a diyan de kékagin ta maski ti ésiya a siya i Cristo a tiniyak na Diyos a tagapagligtas. ");
INSERT INTO dgc_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nadid, sapul ta éya a oras, éy nipagtapat dén ni Jesus du alagad na a kailangan a umange siya ta Jerusalem, a magtiis sa ta meadu, a pahirapan siya du te tungkulin a Judeo. “Ipabunoék de,” kagi na. “Sakay ta ikatélo a aldew éy mabuhayék.” ");
INSERT INTO dgc_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ey ti Pedro, pékabati na ta éya, éy nikabukod na ti Jesus, a pinégkagian na siya, a “Panginoon,” kagi na, “diyan ka mégkagi ta kona sa. Ewan ka mate ta kona sa.” ");
INSERT INTO dgc_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pero hinumarap ti Jesus diya a kinagi na, a “Umadeyo ka dén, Satanas! Sésawayénék mo. Ewan ka mégisip ta kaluuben na Diyos, éngˈwan ta kaluuben na tolay.” ");
INSERT INTO dgc_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nadid, kinagi ni Jesus du alagad na, a “Eng ti ésiya i te gustu a ipasakup diyakén, éy kailangan éy pabayan na pa i sarili na, sakay kumuyoyog diyakén, a maski bunon siya na tolay. ");
INSERT INTO dgc_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Dahilan tu maghangad a meligtas tu buhay na, éy mebut a talaga. Pero tu mégpabaya ta buhay na alang-alang diyakén, éy siya i mabuhaya a éwan tu katapusan. ");
INSERT INTO dgc_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Anya i pékinabanga na esa a tolay éng siya i mayamana ta étanan, éng éwan na makamtan i buhay a éwan tu katapusan? Anya beman i bayada na tolay a mate a monda magsoli tu buhay na? ");
INSERT INTO dgc_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Da sakén i lélake a gébwat ta langet. Ey magsoliék se a talaga a kébil ko i kapangyarian Nama ko, sakay kaguman ko du anghel ko. Ey kédemét ko, éy gantian ko du étanan a tolay ayun to ginimet de. ");
INSERT INTO dgc_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ey tandaan moy ye,” kagi na. “Te sénganya se dikam a éwan mate hanggan éwanék de meta a magsoli se a maghari. Sakén a lélake a gébwat ta langet.” ");
INSERT INTO dgc_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nadid, kélipas na éném a aldew, éy kinuyog ni Jesus de Pedro, sakay de Santiago a patwade (ti Juan i wadi na). Nanohobuk side to melangkaw a buked. ");
INSERT INTO dgc_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ey to édsa de sa, éy neta de a nabagu tu idsura ni Jesus. I mata naa éy nagdemlag a koman i bilag, sakay linumatak i badu naa a medemlag be dén. ");
INSERT INTO dgc_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ey du étélo a alagad, éy neta de nadid ti Moises sakay ti Elias, a kauhon ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ey ti Pedro, kinagi na ni Jesus, a “Panginoon, maigi pa éy édse kitam san dén. Eng gustu mo, éy pagbile me kam ta étélo a kékétihék a bile; esa diko, esa ni Moises, sakay esa ni Elias.” ");
INSERT INTO dgc_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nadid, mégkagi pabi ti Pedro, éy tinaklében side no medemlag a kuném. Ey kinagi no boses to kuném, a “Séˈ ina i mahal kua a anak, a kasahatan ko a tahod. Baten moy siya.” ");
INSERT INTO dgc_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ey du étélo a alagad, pékabati de ta éya, éy inumanteng side a tulos side minedapa. ");
INSERT INTO dgc_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Pero inadenean side ni Jesus a kembilan na side, a kinagi na, a “Tumaknég kam dén, a diyan kam méganteng.” ");
INSERT INTO dgc_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ey to kéadngas de, éy éwan side tu mineta, éngˈwan basta ti Jesus. ");
INSERT INTO dgc_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nadid, namulnok side to buked, éy kinagi ni Jesus dide, a “Diyan moy kékagin ta maski ti ésiya i mineta moya, hanggan éwanék mabuhay a huway, sakén a lélake a gébwat ta langet.” ");
INSERT INTO dgc_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ey kinagi du alagad diya, a “Bakit du maistu ta rilihiyon, éy kékagin de a meditol kan se ti Elias a umange, bagu tu tagapagligtas ta mundua?” ");
INSERT INTO dgc_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","“Tahod ngani,” kagi ni Jesus, “umange pa se ti Elias a talaga, a monda paghandaén na i étanan. ");
INSERT INTO dgc_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pero tandaan moy, inumange dén se ti Elias, pero éwan siya natenggi na tolay. Basta linoko de siya ayun to gustu de. Kona be sa sakén, pahirapanék de be. Sakén a lélake a gébwat ta langet.” ");
INSERT INTO dgc_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Nadid, to pégkagi dén ni Jesus ta éya, éy napospusan dén du alagad a ti Juan bale a Mégbinyag i pinégkagian naa. ");
INSERT INTO dgc_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nadid, késoli de to meadu a tolay, éy inumadene diya i esa a lélake, a linumuhud ta harapa ni Jesus, a kinagi na, a ");
INSERT INTO dgc_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Panginoon, kagbian mo tu anak ko. Basta manghimatay siya, a masiyadu i hirap naa éng sumingga, da medalas siya a metumba ta apoy, o dikaya ta dinom. ");
INSERT INTO dgc_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ey niange ko dén siya du alagad mo,” kagi na, “pero éwan de napahusay.” ");
INSERT INTO dgc_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ey kinagi ni Jesus, a “Medukés a lahi di tolaya ta éye, da éwan kam méniwala! Pakodyan ko se a magtiis dikam? Nay, iange moy se tu anak.” ");
INSERT INTO dgc_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Nadid, to péngkébil de to anak diya, éy pinégkagian ni Jesus tu dimonyo, éy inumibut dén siya to anak, sakay tu anak éy naghusay agad. ");
INSERT INTO dgc_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kétapos na éya, éy nipakelagip du alagad ni Jesus ta lihim, éng bakit éwan de napaibut tu dimonyo. ");
INSERT INTO dgc_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ey kinagi ni Jesus, éy “Da kétihék pabi i péniwala moya. Da tandaan moy, tu péniwala moy ta Diyos, maski koman san i kadikél na bukél na mustasa, éy makagimet kam ta maski anya. Maski kagi moy ta bukida inaeh, a ‘Umadeyo ka,’ éy umadeyo ina a talaga. ");
INSERT INTO dgc_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pero i kona sa a dimonyo, éy éwan moy mapaibut éngˈwan kam pa manalangin, sakay magkulasiyon.” ");
INSERT INTO dgc_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nadid, kédulug du alagad ta Galilea, éy kinagi ni Jesus dide, a “Sakén a lélake a gébwat ta langet, éy itokyonék de, ");
INSERT INTO dgc_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","sakay bunonék de. Pero mabuhayék a huway ta ikatélo a aldew.” Ey du alagad, pékabati de ta éya, éy mélungkut side. ");
INSERT INTO dgc_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Nadid, kédemét de ta Kapernaum, éy du mégsingeh ta buwes para ta Templo, éy kinagi de ni Pedro, a “Anya, méngatéd tu maistu moy ta buwes para ta Templo?” ");
INSERT INTO dgc_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ey “O,” kagi ni Pedro, “méngatéd siya.” Nadid, kédemét ni Pedro to bile, éy kinagi agad ni Jesus diya, a “Anya i isip mua, Simon? Ta munduae, éy ti ésiya i méngatéda ta buwes ta hari, du sarili na a top, o du éwan na kaguman?” ");
INSERT INTO dgc_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","“Du éwan na kaguman,” kagi ni Pedro. Ey kinagi ni Jesus, a “Nadid, éng kona sa, du top na hari, éy éwan side tu kailangan a mangatéd. Ey sikitam, da top kitam na Diyos, éy éwan kitam be tu kailangan a mangatéd ta para ta bile na a Templo. ");
INSERT INTO dgc_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero maski kona sa,” kagi ni Jesus, “éy maigi pa éy mangatéd kitam, monda éwan side mégingél dikitam. Kanya umange ka nadid ta diget, Pedro, a manogbek. Ey tu purumeru a ikan a maalap mo, éy patuyabén mo tu labi na, éy meta mo sa i plata. Alapén mo a tulos ibayad mo ta buwes tam.” ");
INSERT INTO dgc_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ta éya a oras, éy kinagi du alagad ni Jesus, a “Ti ésiya i mataasa ta kaharian na Diyos ta langet?” ");
INSERT INTO dgc_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ey ti Jesus, dinulawan na tu esa a anak, sakay pinataknég na ta harap dia. ");
INSERT INTO dgc_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“Tandaan moy ye,” kagi na. “Eng éwan kam magbagu, a magpababa a kona ta anakae, éy éwan kam makasdép ta kaharian na Diyos. ");
INSERT INTO dgc_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Da maski ti ésiya i magpakababa a kona ta anakae, éy siya i mataasa ta kaharian na Diyos. ");
INSERT INTO dgc_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Sakay maski ti ésiya i tumanggap ta esa a kona se a anak, dahil ta péniwala na diyakén, éy bilang sakén dén i tinanggap naa.” ");
INSERT INTO dgc_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Maigi pa ta esa a tolay, éy kalukalan ta bito i leg naa, sakay ietbung ta ditaw, kesira ta makapangatéd siya ta ipagkasala na mababa a tolay a méniwala diyakén. ");
INSERT INTO dgc_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mehirap a talaga i kalagayan na tolay ta mundua, dahilan éy te méngatéd dide ta ipagkasala de. Ewan maibut maski nikésiya i tolay a méngatéd ta kasalanan. Pero makaanteng i kesapitan na kona sa a tolay! ");
INSERT INTO dgc_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Eng na kamét mua, o dikaya na tikéd mua i mangatéd diko ta ipagkasala mo,” kagi ni Jesus, “éy kétulén mo sakay ibut mo! Maigi pa éy umange ka ta langet a putéd, kesira ta éduwa i kamét mo éy ibut ka pa ta apoy a éwan tu kéédép. ");
INSERT INTO dgc_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Sakay éng na mata mua i mangatéd diko ta ipagkasala mo, éy lugitén mo sakay ibut mo! Maigi pa éy umange ka ta langet a buhék, kesira ta éduwa i mata mua éy ibut ka ta apoy ta impiyerno.” ");
INSERT INTO dgc_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Mangilag kam,” kagi ni Jesus, “a diyan moy apién i maski ti ésiya a anak. Da tandaan moy, du anghel a mégalaga dide éy palagi side a kaharap Nama ko.” ");
INSERT INTO dgc_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(Da inumange se i lélake a gébwat ta langet a monda iligtas na du tolay a mebut.) ");
INSERT INTO dgc_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Anya i isip moya a gemtén na esa a tolay a te alila ta sandaan a tupa éng mebut i esa dide? Ginanan na a talaga du siyam a pulu éy ta siyam to pégpastoran na dide, a monda ahayukén na tu nebut. ");
INSERT INTO dgc_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ey nadid, pag mineta na ya éy masahat siya diya a talaga, kesira du nabuhay na a tupa a éwan minebut. ");
INSERT INTO dgc_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Nadid, kona man sa, éy éwan kaluuben Nama moy ta langet a mapahamak i maski esa diden ye a mababa a tolay.” ");
INSERT INTO dgc_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Eng magkasala diko i esa a top mo, éy gombék ka diya sakay méguhon kam a éduwa ta éwan tu makabati dikam. Eng méniwala siya diko, éy magsuyuan kam a huway a kona to dati. ");
INSERT INTO dgc_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Nadid, éng éwan siya méniwala diko, éy mangalap ka ta manga éduwa a kaguman mo, a monda sistiguan de éng anya i péguhunan moya. ");
INSERT INTO dgc_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nadid, éng éwan be siya méniwala dide, éy kagin moy ya du kakaguman moy ta simbaan. Sakay éng éwan pa siya méniwala du kakaguman moy ta simbaan, éy ibilang moy siya a medukés, a adeyo dén ta Diyos. ");
INSERT INTO dgc_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Tandaan moy ye: tu ipagbawal moy ta mundua éy ipagbawal be ta langet, sakay tu pakultaden moy ta mundua, éy pakultaden be ya ta langet. ");
INSERT INTO dgc_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Ey tandaan moy ye, éng te éduwa dikam ta éye ta munduae a magkaisa a manalangin, éy talaga a pagkaluuben kam Nama ko ta langet. ");
INSERT INTO dgc_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Dahilan maski ta ahe, éng te éduwa o dikaya étélo a magkapisan dahil ta péniwala de diyakén, éy édsaék be sa dide.” Utusan a Ewan Mégpatawad ");
INSERT INTO dgc_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Nadid, inumadene ti Pedro ni Jesus, a kinagi na, a “Panginoon, sénganya a beses a patawadén ko tu kaguman ko a sosoli a magkasala diyakén? Maski pitu a beses, patawadén ko pa?” ");
INSERT INTO dgc_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","“Maski higit pa ta éya i kasalanan na diko, éy patawadén mo pa,” kagi ni Jesus. “Maski pitu a pulu a beses, éy patawadén mo pa siya. ");
INSERT INTO dgc_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Dahilan i pégharia na Diyos éy kapareho na éye: Mara te hari kan a kinagi na a pagbayadén na du utusan na, da te utang side diya. ");
INSERT INTO dgc_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ey tu neditol a nipauwet na, éy tu te utang a meaadu a libu-libu a pisu. ");
INSERT INTO dgc_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Anya da éwan siya tu ibayad, éy inutusan kan no amo na, a ibugtong de siya, pati tu asawa na, sakay du anak na, sakay étanan a ari-arian na, monda makabayad. ");
INSERT INTO dgc_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Nadid tu utusan, éy linumuhud kan siya to harap no amo na, a nékikakagbi. ‘Pakultadenék mo ta esa a panahun,’ kagi na kan, ‘éy bayaden ko i étanan a utang ko diko.’ ");
INSERT INTO dgc_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nadid, kinagbian kan siya no amo na; kanya pinatawad na to étanan a utang na, sakay pinéglakad na siya. ");
INSERT INTO dgc_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Pero nadid, kéhektat sa no utusan, éy neta na kan tu kaguman na a te utang be diya ta sandaan san a pisu. Ey kembilan na siya agad a sinakal, a kinagi na kan, a ‘Nay, magbayad ka dén to utang mo diyakén.’ ");
INSERT INTO dgc_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ey tu sinakal na, éy linumuhud diya a tinumawad diya. ‘Pakultadenék mo pa,’ kagi na, ‘éy bayaden ta ka.’ ");
INSERT INTO dgc_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pero tu utusan, éy éwan kan siya pinumayag; éngˈwan nipepihesu na hanggan éwan siya makabayad. ");
INSERT INTO dgc_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Ey du kakaguman de a utusan, péketa de ta nanyari a éya, éy mégisip-isip kan side, a tulos inumange side to amo de a niabla de i étanan a nanyari. ");
INSERT INTO dgc_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ey pékabaheta no amo de, éy nipauwet na kan tu utusan na. ‘Siko, napakasiyadu ka a dukés!’ kagi na kan. ‘Isip ko pinatawad ta ka ta étanan a utang mo, da nékikakagbi ka diyakén. ");
INSERT INTO dgc_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kinagbian ta ka, pero siko éy éwan mo kagbian tu kaguman mo!’ ");
INSERT INTO dgc_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ey nadid, dahil ta iyamut no amo na, éy nipepihesu na kan siya hanggan éwan na mabayaden tu utang na a étanan. ");
INSERT INTO dgc_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Ey nadid,” kagi ni Jesus, “kona be sa i gemténa dikam Nama ko ta langet, éng éwan moy patawadén du kaguman moy.” Ta Méghiwalay a Pasawa ");
INSERT INTO dgc_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Nadid, kétapos ni Jesus a mégtoldu, éy hinumektat siya ta Galilea, a tulos na ta Hudea, ta dibilewa na Hordan. ");
INSERT INTO dgc_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Meadu a tolay i tinumagubet diya ta éya, éy pinahusay na sa side. ");
INSERT INTO dgc_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Te Pariseyo a inumadene diya ta éya, a talaga de siya a pagkamalién ta kagi na. I kinagi dia, éy “Maari wade a hiwalayan na lélake i asawa na ta maski anya a dahilan?” ");
INSERT INTO dgc_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ey kinagi ni Jesus, a “Ewan moy wade pabi nabasa to kasulatan, to pénglalang na Diyos, éy ginimet na i lélake éy ta bébe. ");
INSERT INTO dgc_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Sakay kinagi be na Diyos, éy ‘Dahilan ta éya, éy ginanan no lélake dena na éy tama na, monda mékiagum to asawa na; éy maging isesa side.’ ");
INSERT INTO dgc_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kanya éwan dén side éduwa,” kagi ni Jesus, “éngˈwan esa san dén side. Kanya i pinagagum na Diyos, éy diyan péghiwalayén na tolay.” ");
INSERT INTO dgc_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","“Nadid, éng kona sa,” kagi du Pariseyo, “éy bakit niutus ni Moises a atdinan kan na lélake tu asawa na ta kasulatan ta péghiwalay, bagu na siya hiwalayan?” ");
INSERT INTO dgc_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","“Dahil ta kaktog na isip moya,” kagi ni Jesus, “kanya kam pinakultaden ni Moises a hiwalayan moy i asawa moya. Pero éwan sa kona to sapul. ");
INSERT INTO dgc_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ey tandaan moy ye, maski ti ésiya a lélake, éng humiwalay ta asawa na, sakay éwan na be siya nipéngilélake, éng mangasawa siya ta iba, éy méngibébi dén siya a talaga ta mata na Diyos.” ");
INSERT INTO dgc_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","“Eng kona sa,” kagi du alagad, “éy maigi pa éy diyan dén mangasawa.” ");
INSERT INTO dgc_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ey kinagi ni Jesus, a “Ewan maari a tupadén na lélake i éya, éng éwan du pinagkaluuben san na Diyos. ");
INSERT INTO dgc_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Dahilan éy te iba-iba a lélake a éwan makaasawa: i sénganya éy dahilan ta katétubu de a kalagayan de; kanya nagkakuna sa du iba éy dahilan ta gimet na iba a tolay dide. Sakay te lélake be a éwan makaasawa dahil ta tarabaho de ta Diyos. Eng maari, éy tanggapén moy dén i pégtoldu ko a éye.” ");
INSERT INTO dgc_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Te nagkébil du anak de ni Jesus, a monda itupu na i kamét na dide a ipanalangin na side. Ey pinégkagian side du alagad. ");
INSERT INTO dgc_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Pero kinagi ni Jesus, a “Pabayan moy di anaka a umadene diyakén. Diyan moy side sésawayén. Dahilan éy méghari i Diyos ta kona sina.” ");
INSERT INTO dgc_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ey tulos nitupu na dide i kamét naa bagu siya hinumektat. ");
INSERT INTO dgc_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Te esa a lélake a inumange ni Jesus, a kinagi na diya, a “Maistu, anya wade i mahusay a gemtén ko, a monda magkamiték ta buhay a éwan tu katapusan?” ");
INSERT INTO dgc_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ey kinagi ni Jesus, a “Bakit pakelagipanék mo éng anya i mahusaya? Isesa san i mahusaya. Eng gustu mo a magkamit ta buhay a éwan tu katapusan, éy sundin mo i utus na Diyos.” ");
INSERT INTO dgc_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","“Ahe a utus,” kagi na. Ey kagi ni Jesus, a “Diyan ka mamuno, diyan ka méngibébi, diyan ka mégtako, diyan ka mégbuli-buli, ");
INSERT INTO dgc_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","sakay igalang mo tama mo éy ta ina mo, sakay mahalén mo i kapareho mo a kaparis ta pégmahal mo ta bégi mua.” ");
INSERT INTO dgc_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","“Sinunud ko dén ina a étanan,” kagi no lélake, “anya pa i dapat ko a gemtén?” ");
INSERT INTO dgc_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ey kinagi ni Jesus diya, “Eng gustu mo a maging mahusay ka, éy ange mo ibugtong tu ari-arian mo. Sakay tu kabugtungan na, éy iatéd mo du mahirap. Eng pakunan mo sa, éy te kayamanan ka dén ta langet. Ey nadid, sumoli ka se a kumuyoyog ka diyakén.” ");
INSERT INTO dgc_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nadid, pékabati no lélake ta éya, éy nalungkut dén siya, a hinumektat dén, da napakayaman siya. ");
INSERT INTO dgc_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ey kinagi ni Jesus du alagad na, a “Mehirap a talaga a makasdép i mayaman ta kaharian na Diyos. ");
INSERT INTO dgc_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Makasdép beman i kabayo ta ébut na digum? Mas lalo a mehirap a makasdép i mayaman ta kaharian na Diyos.” ");
INSERT INTO dgc_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nadid, pékabati du alagad ta éya, éy nagtaka side a tahod, a kinagi de, a “Eng kona sa, éy ti ésiya i makaligtasa?” ");
INSERT INTO dgc_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ey tinitigen side ni Jesus, a kinagi na, a “Tama ngani; éwan maari i tolay a mangiligtas ta bégi na. Pero magimet na Diyos i maski anya.” ");
INSERT INTO dgc_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nadid, kinagi ni Pedro, a “Entan mo, Panginoon. Sikame, éy gininanan me dén i étanan, a kinumuyog kame diko. Anya i gantimpala mia?” ");
INSERT INTO dgc_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","“Tandaan moy ye,” kagi ni Jesus; “sakén i lélake a gébwat ta langet. Pag maghariék ta bigu a mundu, éy sikam a alagad ko a labindalawa, éy maghari kam be du labindalawa a lahi na Judeo, du apo-apo ni Israel. ");
INSERT INTO dgc_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Sakay i maski ti ésiya a magtiis a guminan ta bile na éy ta tétotop na éy ta ina na éy ta ama na, éy ta anak na éy ta luta na alang-alang diyakén, éy atdinan siya na Diyos ta dubli-dubli a gantimpala na nadid, sakay atdinan na be siya ta buhay a éwan tu katapusan. ");
INSERT INTO dgc_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pero meadu du mataas nadid, éy side i mababaa; sakay du mababa nadid, éy side i mataasa ta éya.” ");
INSERT INTO dgc_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Nadid, kinagi ni Jesus, a “I paghari na Diyos éy kapareho na éye: Mara te lélake a linumuwas to amulaldew, a mangenta ta magtarabaho to luta na. ");
INSERT INTO dgc_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Du neditol a inalap na, éy nagkasundu side a mamisu i upa de ta maghapun. Ey pinaange na side to luta na. ");
INSERT INTO dgc_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Mamaya-maya, éy linumwas siya a huway to alas nuwebe i bilag, éy neta na du tolay a te taknég san to palengke. ");
INSERT INTO dgc_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ey kinagi na dide, a ‘Magtarabaho kam be dén ta luta ko, éy upaan ta kam ta gustu moy.’ Ey tulos side a nagtarabaho. ");
INSERT INTO dgc_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Mamaya-maya, linumwas man dén siya to alas dose i bilag, sakay to alas tres, éy kona be sa i ginamet naa. ");
INSERT INTO dgc_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Nadid, to manga alas singku dén, éy linumwas man dén siya a huway, éy naketa man dén siya ta éwan tu tarabaho. Ey kinagi na dide, a ‘Bakit tu kataknég moy san se nadid a maghapun?’ ");
INSERT INTO dgc_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","‘Ey éwan kame tu tarabaho,’ kagi de. ‘Ey sigi,’ kagi no lélake, ‘magtarabaho kam dén diyakén ta luta ko yae.’ ");
INSERT INTO dgc_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Nadid, késibig de to apon, éy kinagi no lélake to porman, a ‘Nay, dulawan mo dén du mégtarabaho, sakay atdinan mo side ta upa de. Bayaden mo pa du ménegipo bagu du neditol.’ ");
INSERT INTO dgc_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Nadid, du nagsapul a nagtarabaho to alas singku, éy upaan na side ta mamisu. ");
INSERT INTO dgc_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Kanya du neditol, pégsingeh de éy akala de éy upaan side ta mahigit pa du ménegipo. Pero mamisu bale be san i upa dia. ");
INSERT INTO dgc_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ey to pénanggap de, éy naglekramo side to te koo to luta. ");
INSERT INTO dgc_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Bakit,’ kagi de, ‘esa oras san du ménegipo a mégtarabaho, pero sikame, éy nagtiis kame ta pasi no bilag to maghapun. Bakit pareho kame san tu upa?’ ");
INSERT INTO dgc_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ey kinagi no lélake dide, a ‘Anya, kadimoy, dinaya ta kam? Isip ko nagkasundu kitam ta upa a mamisu ta maghapun? ");
INSERT INTO dgc_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Alapén moy dén i upa moya, sakay méglakad kam dén. Eng gustu ko upaan ko du ménegipo ta kapareho na upa moya, ");
INSERT INTO dgc_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","éy éwan ko beman magimet i gustu ko ta sarili ko a kuhata? Ataay, managhili kam beman da gustu ko mangatéd ta mahusay?’ ");
INSERT INTO dgc_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Kanya,” kagi ni Jesus, “du ménegipo nadid a méniwala, éy side i mégdetol ta esa a panahun. Sakay du neditol nadid, éy side i ménegipua ta éya.” ");
INSERT INTO dgc_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Nadid, to péglakad de Jesus ta Jerusalem, éy nibukod na du labindalawa a alagad na, a kinagi na dide, a ");
INSERT INTO dgc_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Entan moy, umange kitam nadid ta Jerusalem. Sakén i lélake a gébwat ta langet. Ey ta éya éy itokyonék de du mataas a padi sakay du maistu ta rilihiyon. Ey side i magpabunua diyakén. ");
INSERT INTO dgc_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ey itugénék de di dayuan yae a éwan Judeo. Ey side éy tétoksonék de sakay balbalénék de, sakay ipakoék de ta kudos. Ey ta ikatélo a aldew, éy mabuhayék a huway.” ");
INSERT INTO dgc_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nadid, éy inumadene ni Jesus tu asawa ni Sebedeo, a kaguman na du anak na a éduwa. Ey linumuhud siya diya a nékiohon diya. ");
INSERT INTO dgc_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","“Anya i gustu mua?” kagi ni Jesus. Ey kinagi no bébe, a “Maano, atdinan mo i éduwa a éye a anak ko ta katungkulan de a side i bisi mo, a side i kaguman mo éng maghari ka.” ");
INSERT INTO dgc_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","“Ewan moy tukoy i pékiohon moya,” kagi ni Jesus. “Kaya moy wade a matiis i hirapa a tiisén ko?” “O,” kagi de, “kaya me.” ");
INSERT INTO dgc_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","“I hirap a tiisén ko éy matiis moy ngani be,” kagi ni Jesus, “péro éwan sakén i bahala éng ti ésiya i bisi ko, a kaguman ko a maghari. I éya a kinagi moy éy para du pinaghandaan Nama ko.” ");
INSERT INTO dgc_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nadid, to pékabati ta éya du sapulu a iba a alagad, éy nagingél side du patwadi. ");
INSERT INTO dgc_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kanya pinaadene side ni Jesus a étanan, a kinagi na dide, a “Tukoy moy dén du mataas a tolay, éy mégéutusén side du mababa. ");
INSERT INTO dgc_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","27","Pero diyan sa kona i ugali moya. Engˈwan, éng ti ésiya dikam i gustu a mataas, éy dapat a maging utusan siya. ");
INSERT INTO dgc_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kona sa sakén a lélake a gébwat ta langet,” kagi ni Jesus. “Ewanék se inumange a monda utusan ko i tolay, éngˈwan sakén i utusan na tolay. Sakay inumangeék be se a monda iatéd ko i buhay ko a monda matubus ko i meadu a tolay.” ");
INSERT INTO dgc_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Nadid, to kéhektat de ta Heriko, éy meadu i inumunonoda ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ey nadid éy te éduwa a buhék a te eknud to digdig no dilan. Ey pékabati de a sumalegéd dén ti Jesus, éy dinumulaw side a kinagi de, a “Panginoon, Apo ni Dabid, kagbian mo kame pad!” ");
INSERT INTO dgc_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ey du tolay sa, sinaway de side a diyan side tu pehéng. Pero lalo pa side a dinumulaw, a kinagi de, a “Panginoon, kagbian mo kame!” ");
INSERT INTO dgc_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Nadid, pékabati dide ni Jesus, éy dinulawan na side a kinagi na dide, a “Anya i gustu moya a gemtén ko dikam?” ");
INSERT INTO dgc_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ey kinagi de, a “Panginoon, pabulagén mo kame pad.” ");
INSERT INTO dgc_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ey ti Jesus, éy kinagbian na side, a kembilan na i mata dia. Ey agad side naketa, tulos kinumuyog side diya. ");
INSERT INTO dgc_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nadid, dinumemét dén side ta Betpage, sakay ta Buked na Olibo, a adene dén side ta Jerusalem. Ey pinégdetol ni Jesus i éduwa a alagad na. ");
INSERT INTO dgc_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Ikad moy dén ta bariyua ta dibilew yae,” kagi na, “éy meta moy sa agad i kabayo a te egut, a te anak. Ukadén moy a iange moy se diyakén. ");
INSERT INTO dgc_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Eng te magpakelagip dikam, éy kagi moy a kailangan na Panginoon, éy iatéd na agad dikam.” ");
INSERT INTO dgc_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nadid, éy nanyari ya a monda matupad tu nihula no purupeta to araw, a kinagi na, a ");
INSERT INTO dgc_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Kagi moy du tolay ta Jerusalem, a ‘Entan moy, dumemét dikam tu hari moy. Mebait siya, sakay te sakay ta bul-o a kabayo.’” ");
INSERT INTO dgc_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Nadid, inumange sa du alagad a ginimet de tu utus ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Tulos nitugén de ni Jesus tu kabayo sakay tu anak na, sakay sinapinan de side to damit de. Sakay sinumakay ti Jesus. ");
INSERT INTO dgc_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ey meadu a tolay i naglatag ta damit de to kamino a dimanén ni Jesus. Du iba éy nagkétol ta sanga-sanga, a nilatag de be to dimanén na. (Saya i pénggalang dia ta hari.) ");
INSERT INTO dgc_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nagpagdulaw du tolay a mégdetol sakay du ménegipo, a kinagi de, a “Mabuhay i apuae ni Dabid a maghari. Basbasan maka na Diyos i lélakeae a pinaange na se! Purien be siya ta langet!” ");
INSERT INTO dgc_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nadid, késdép ni Jesus ta Jerusalem, éy nagulo i buu a banuwan. “Ti ésiya wade ina?” kagi de. ");
INSERT INTO dgc_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ey meadu a négkagi a “Ti Jesus ina, a purupeta siya a taga Nasaret, ta Galilea.” ");
INSERT INTO dgc_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Nadid, sinomdép ti Jesus to Templo, a pinaibut na sa du mamugtong sakay du mégpabugtong. Sakay pinégpasakéb na du lamesa du mégpalit ta kuhata, sakay du pégeknuden du mégtinda ta palapati. ");
INSERT INTO dgc_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","I kinagi naa éy “Isip ko nabasa ta libru na Diyos a i bile na Diyos éy dulawén de a bile a panalanginan. Ey bakit nadid, dahil dikam, kanya dulawén de a bile na mégdaya!” ");
INSERT INTO dgc_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Du buhék sakay du pile, éy inumange side ni Jesus to Templo, éy pinahusay na side. ");
INSERT INTO dgc_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ey du mataas a padi sakay du maistu ta rilihiyon, péketa de ta memahal a ginimet na, éy mégingél side. Sakay mégingél be side du anak a mégpégdulaw ta lubuk no Templo, a “Mabuhay i apua ni Dabid a maghari!” ");
INSERT INTO dgc_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","“Entan mo,” kagi de ni Jesus, “éwan mo mébati i kékagin di anaka? Mégkamali side!” “Nabati ko,” kagi ni Jesus. “Ataay, éwan moy bale pabi nabasa i kona sa a kagi ta libru na Diyos, a ‘Tinolduan mo kan du anak a monda purién de ka ta mahusay’?” ");
INSERT INTO dgc_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ey nadid, to pégkagi ni Jesus ta éya, éy hinumektat siya a linumwas ta banuwan, a inumange ta Betania. Ey minatidug sa siya. a Kayo a Ewan Mégbunga ");
INSERT INTO dgc_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Nadid, to gagabi dén, éy nagsoli ti Jesus ta banuwan. Habang méglakad siya éy mégalép dén. ");
INSERT INTO dgc_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ey péketa na to kayo a igos to digdig no dilan, éy inadenean na. Pero éwan siya tu mineta a bunga na. Kanya kinagi na to kayo, a “Ewan ka dén magbunga a hanggan, maski nikésiya!” Ey agad nalanés tu don na. ");
INSERT INTO dgc_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Péketa du alagad ta éya, éy nagtaka side. “Bakit nalanés agad i kayo a éye,” kagi de. ");
INSERT INTO dgc_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ey kinagi ni Jesus dide, a “Tandaan moy, éng méniwala kam, a éwan kam mégalanganin, éy magimet moy be i ginamet ko a éye ta kayoae. Ey éwan san ina. Maski kagi moy ta buked a éye, a ‘Umibut ka sina a bumatikal ka ta diget ya,’ éy manyari ya a talaga. ");
INSERT INTO dgc_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Sakay maski anya i agidén moya ta panalangin, éy maalap moy, éng méniwala kam diyakén.” ");
INSERT INTO dgc_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Nadid, sinomdép dén ti Jesus to Templo. Ey to pégtoldu na sa, éy inumadene sa diya du mataas a padi sakay du matétanda. Kinagi de diya, a “Anya i katungkulan mua a magimet ta kona sina a gimet mo? Ti ésiya i néngatéda diko ta katungkulan mua a ina?” ");
INSERT INTO dgc_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ey kinagi ni Jesus, a “Pakelagipan ta kam be. Nadid, éng sengbeténék moy, éy kagin ko be dikam éng anya i katungkulan ko a mégimet ta éye a gimet ko. ");
INSERT INTO dgc_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ahe gébwat na katungkulana ni Juan a kanya nagbinyag siya--Diyos wade, o ta tolay?” Nadid, méguhon-uhon side, éng anya i sengbet dia ni Jesus. “Eng kagin tam a gébwat ta Diyos tu katungkulan ni Juan,” kagi de, “éy pégkagian na kitam a talaga éng bakit éwan kitam naniwala ni Juan. ");
INSERT INTO dgc_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Pero éng kagin tam a tolay san i nagutusa ni Juan, éy makay paginglan kitam di tolay a éye, da isip de a purupeta ti Juan a gébwat ta Diyos tu katungkulan na.” ");
INSERT INTO dgc_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kanya kinagi de ni Jesus, a “Ewan me tukoy.” Ey “Maari,” kagi ni Jesus, “da éwanék moy sinengbet, éy éwan ta kam be sengbitén éng anya i katungkulan ko a mégimet ta ginimet ko.” Masuwayin Nama Na a Diyos ");
INSERT INTO dgc_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Anya i isip moya ta éye?” kagi ni Jesus. “Eng mara, te lélake a te anak ta éduwa a lélake be. Inutusan na tu panganay a pinagtarabaho to luta na.” ");
INSERT INTO dgc_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ey kinagi no anak, a “Mégtamadék, Améng.” Pero mamaya-maya éy nagbagu tu isip na, a tulos nagtarabaho. ");
INSERT INTO dgc_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nadid, inutusan be no lélake tu anak na a esa. Ey inumo siya nama na, pero éwan be siya tinumulos. ");
INSERT INTO dgc_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Nadid,” kagi ni Jesus, “ti ésiya diden ya a éduwa i sinumunuda to kaluuben nama na?” “Ey tu panganay,” kagi du tolay. “Tama,” kagi ni Jesus. “Ey tandaan moy ye. Du medukés a tolay, maski du pampam a bébe, éy meditol side a masakup ta paghari na Diyos, kesira dikam a Judeo. ");
INSERT INTO dgc_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Da inumange dikam ti Juan, a nagtoldu dikam ta tama a ugali, éy éwan kam diya naniwala. Pero pinaniwalaan siya du medukés a tolay, sakay du pampam. Ey maski neta moy dén ya, éy éwan kam pabi nagsisi sakay naniwala diya.” Du Judeo Du Purupeta ");
INSERT INTO dgc_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Baten moy i esa pa a halimbawa,” kagi ni Jesus. “Eng mara, te esa a lakay a nagmula ta ubas to uma na. Sakay kinudal na. Sakay nagkotkot siya ta pégégikan na ta ubas. Sakay nagbile siya ta pégbantayan na. Sakay nientarega na tu uma na du kahati na, sakay inumange siya ta iba a lugar. ");
INSERT INTO dgc_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Nadid, kédemét na panahun na pégpitas ta ubas, éy pinaange sa no lakay du utusan na, a monda alapén de tu kabahagi na to bunga no ubas. ");
INSERT INTO dgc_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pero du kahati na, péketa de du utusan no amo de, éy binalbal de tu esa, sakay binunu de tu esa, sakay binatibatikal de tu esa. ");
INSERT INTO dgc_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ey tu lakay, éy pinaange na man dén sa du iba a utusan, a meadu pa kesira du négdetol. Pero kona be sa i ginimita du kahati na dide. ");
INSERT INTO dgc_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Tu katapusan a pégutus na, éy tu anak na dén a lélake. ‘Igalang de tu anak ko a talaga,’ kagi na. ");
INSERT INTO dgc_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Pero du kahati na, péketa de to anak na, éy kinagi de a ‘Siya i magmanaa; bunon tam dén, monda koo tam dén i lutaae a mana na.’ ");
INSERT INTO dgc_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kanya kembilan de siya a niluwas de to uma, sakay binunu de! ");
INSERT INTO dgc_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Nadid,” kagi ni Jesus, “anya i isip moya to lakay a te uma? Ta késoli na, éy anya wade i gemtén na du kahati na?” ");
INSERT INTO dgc_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ey kinagi du mégbati ni Jesus, a “Bunuén na a talaga diden ya a medukés a tolay, sakay ientarega na tu uma na ta iba a kahati na, du mangatéd diya ta kabahagi na éng panahun dén na pégpitas ta ubas.” ");
INSERT INTO dgc_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","“Ey nadid,” kagi ni Jesus, “éwan moy bale pabi nabasa i éya a kagi ta kasulatan? ‘Tu bito kan a inidelan du mégbile, da isip de a éwan tu pasa, éy siya bale i mahalagaa a bito a panuluk na bile. Saya i ginimet na Diyos, a saya i pagtakaan tama!’ ");
INSERT INTO dgc_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Kanya nadid,” kagi ni Jesus du tolay sa, “éy besa dén sikam a Judeo i paghariana na Diyos, éngˈwan iba a banuwan a sumunud diya ta mahusay. ");
INSERT INTO dgc_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Maski ti ésiya i mebagsaka ta éya a bito, éy mate siya. Sakay i bagsakana na éya a bito éy mahémsit.” ");
INSERT INTO dgc_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nadid, du mataas a padi sakay du Pariseyo, pékabati de du halimbawa ni Jesus, éy naisip de a side du tauhan a medukés i pinégkagian naa. ");
INSERT INTO dgc_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kanya talaga de a dekpén ti Jesus; pero inumanteng side du tolay, da tukoy dén du tolay a purupeta siya. a Mégidel a Dumulug ");
INSERT INTO dgc_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Nadid, huway ti Jesus a négkagi dide ta halimbawa. Kinagi na, a ");
INSERT INTO dgc_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“I pagharia na Diyos éy kapareho na éye: Eng mara te hari a naghanda ta anyaya; mara éy kasal ya na anak na a lélake. ");
INSERT INTO dgc_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ey inutusan na du utusan na a angen de uwitén du kinombida na. Pero pénguwet de dide, éy mégidel side a dumulug. ");
INSERT INTO dgc_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Kanya tu hari, éy nagutus siya du utusan na a iba, a pinagbilinan na side, a ‘Kagi moy du kinombida ko a hinanda ko dén i pagkasalan. Kagi moy dide a binunu ko dén du baka ko, sakay du pinatabi ko a bul-o. Sakay kagi moy dide a nahanda dén i étanan, a paangen moy se side ta pégkasalanae.’ ");
INSERT INTO dgc_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Pero éwan naniwala du kinombida. Basta inumange san side ta gustu de. Tu esa éy inumange san to uma na; tu esa man éy inumange to pégtindaan na. ");
INSERT INTO dgc_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Sakay du iba éy dinuklos de du utusan no hari, a linoko de side, sakay binuno de side. ");
INSERT INTO dgc_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Nadid tu hari, éy mégingél siya a tahod. Ey pinaange na sa du sundalu na, sakay pinabunu na diden ya a tolay, sakay nipatutod na tu banuwan de. ");
INSERT INTO dgc_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Nadid, kinagi na du utusan na, a ‘Nakahanda dén i pagkasalan, pero éwan dén se maari a umange du kinombida ko. ");
INSERT INTO dgc_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kanya nadid, éy umange kam dén du kamino a meadu a tolay, sakay akitén moy du étanan a meta moy a makipagkasal ta éye.’ ");
INSERT INTO dgc_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Nadid, inumange dén du utusan du kamino, sakay pinadulug de i étanan a meta de, pati du medukés, sakay du mahusay. Kanya naputat ta kombidadu tu bile a pégkasalan. ");
INSERT INTO dgc_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Nadid, késdép no hari a monda entan na du tolay sa, éy mineta na sa i esa a éwan tu badu a pékipagkasal. ");
INSERT INTO dgc_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‘Kadimoy,’ kagi na, ‘bakit sinomdép ka se a éwan tu badu a pékipagkasal?’ Ey éwan nakasengbet tu tolay. ");
INSERT INTO dgc_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Kanya nadid, kinagi no hari du utusan na, a ‘Gapusén moy i kamét naa sakay na tikéd naa, sakay ibut moy siya ta kedikléman ta luwas. Ey ta éya, éy mégsésangitén siya a mégéadiyoyén ta hirap na.’ ");
INSERT INTO dgc_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ey tandaan moy,” kagi ni Jesus, “meadu i inakit na Diyos ta kaharian na, pero kétihék san i napili.” ");
INSERT INTO dgc_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nadid, néguhunan du Pariseyo éng pakodyan de a pagkamalién ti Jesus ta kagi na. ");
INSERT INTO dgc_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Kanya pinaange de diya du alagad de, a kaguman be i sénganya a alagad ni Herod. “Maistu,” kagi de, “tukoy me a matapat ka, a iyétoldu mo ta mahusay i gustu na Diyos a gemtén na tolay. Sakay éwan mo ugali a manuyu ta mataas a tolay, da éwan ka kumampi ta mataas a tolay. ");
INSERT INTO dgc_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nadid,” kagi de, “anya i isip mua? Labag wada ta utus tam éng bumuwes kitam ta hari ta Roma, o éwan?”. ");
INSERT INTO dgc_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Nadid, tukoy dén ni Jesus a pépuhubaan de san siya. Kanya kinagi na dide, a “Sikam a mégkukunwari a éwan tu kasalanan! Bakit gustu moy a magkamaliék? ");
INSERT INTO dgc_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Dah, ipeta moy diyakén i kuhata moy a pagbuwes.” To pégkagi na ta éya, éy niatéd de diya i esa a plata. ");
INSERT INTO dgc_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","“Kéˈ ni ésiya i éye a letrato?” kagi ni Jesus, “sakay kéˈ ni ésiya a ngahen i nakasulatae?” ");
INSERT INTO dgc_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Ey tu hari ta Roma,” kagi de. “Tama,” kagi ni Jesus. “Nadid, tu koo na hari ta Roma, éy iatéd moy diya. Pero tu para ta Diyos, éy iatéd moy ta Diyos.” ");
INSERT INTO dgc_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nadid, du Judeo sa, pékabati de ta éya a mahusay a sengbet ni Jesus, éy nagtaka side. Ey hinumektat sa side diya. ");
INSERT INTO dgc_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nadid, ta éya a mismo a aldew, éy inumange ni Jesus i sénganya a Saduseyo. (I Saduseyo, éy éwan side méniwala a mabuhay i tolay a huway.) ");
INSERT INTO dgc_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Maistu,” kagi de, “nitoldu ni Moises i kona se: Eng mate kan tu lélake a éwan pabi tu anak, éy tu wadi na éy dapat asawan na tu kayong na a bilo, monda magenak siya, para te anak tu aka na a minate. ");
INSERT INTO dgc_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nadid, Maistu,” kagi de, “éy te pitu a pépétwadi a lélake to éya dikame. Ey nangasawa tu panganay. Ey minate siya a éwan pabi tu anak. Kanya inasawa be no wadi na tu kayong na a bilo. ");
INSERT INTO dgc_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ey kona be sa i nanyaria to ikaduwa, hanggan to ikatélo, a hanggan to ikapitu. ");
INSERT INTO dgc_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kéte de a étanan, éy minate be tu bébe. ");
INSERT INTO dgc_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","“Ey nadid, Maistu,” kagi du Saduseyo, “saye i gustu mia a mapospusan: Nitoldu mo a te buhay kan i tolay a huway. Eng talaga a kona sa, éy ti ésiya dide a pitu i maging asawa na ta kébuhay du tolay a huway, da inasawa de siya a étanan?” ");
INSERT INTO dgc_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ey kinagi ni Jesus dide, a “Mali kam a tahod, da éwan moy tukoy i kasulatan na Diyos, sakay éwan moy tukoy i kapangyarian na Diyos. ");
INSERT INTO dgc_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Dahilan ta kébuhay na tolay a huway éy éwan dén maari a mangasawa side, da kapareho dén side du anghel ta langet. ");
INSERT INTO dgc_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ey sikam a Saduseyo,” kagi ni Jesus, “éy bakit isip moy a éwan mabuhay i tolay a huway? Ewan moy wade pabi nabasa tu kasulatan na Diyos? Kinagi sa na Diyos, a ");
INSERT INTO dgc_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Sakén i Diyos a péniwalaan ni Abraham, sakay ni Isak, sakay ni Hakob.’ Kahulugina na éya, éy méniwala side nadid ta Diyos, maski minate side to araw, da buhay dén side nadid ta langet.” ");
INSERT INTO dgc_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nadid du tolay sa, pékabati de ta éya a nitoldu ni Jesus, éy nagtaka side diya. ");
INSERT INTO dgc_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Nadid du Pariseyo, pékabaheta de a natalo ni Jesus du Saduseyo, éy nagmiting side. ");
INSERT INTO dgc_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","I esa dide, a maistu ta rilihiyon, éy pinakelagipan na ti Jesus, a monda pagkamalién na maka siya. ");
INSERT INTO dgc_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Maistu,” kagi na, “ahe i mahalagaa a utus ta kasulatan na Diyos?” ");
INSERT INTO dgc_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ey kinagi ni Jesus, a “Mahalén mo i Panginoon mo a Diyos ta mahigpit, a isipén mo siya a palagi. ");
INSERT INTO dgc_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Saya i mahalagaa a utus. ");
INSERT INTO dgc_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Sakay tu ikaduwa a kapareho na éy kagi na a ‘Mahalén mo tu kapareho mo a kona ta pégmahal mo ta bégi mo.’ ");
INSERT INTO dgc_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Diden ya a éduwa a utus,” kagi ni Jesus, “éng sundin moy side, éy natupad moy dén du étanan a utus ni Moises, sakay du étanan a pégtoldu du purupeta.” ");
INSERT INTO dgc_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Nadid, to pégmiting pabi du Pariseyo, éy kinagi ni Jesus dide, a ");
INSERT INTO dgc_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Anya i isip moya tungkul ta tiniyak na Diyos a tagapagligtas? Ti ésiya i ninuno naa?” “Ti Hari Dabid,” kagi de. ");
INSERT INTO dgc_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","“Eng kona sa,” kagi ni Jesus, “éy bakit dinulaw siya ni Dabid a amo na? Ey tu nagpakagi ni Dabid ta éya éy tu Banal a Espiritu. Da kinagi ni Dabid, a ");
INSERT INTO dgc_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Kinagi na Diyos to amo ko, a “Mégiknud ka ta tagirilan kuae a hanggan mapasuku ko diko du kalaban mo.”’ ");
INSERT INTO dgc_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Nadid ti Dabid, éy dinulaw na a amo na tu tagapagligtas. Eng kona sa, éy bakit kékagi moy a ninuno siya ni Dabid?” ");
INSERT INTO dgc_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","To pégkagi ni Jesus ta éya, éy éwan tu nakasengbet dia. Ey éwan dén tu nangahas a nagpakelagip diya a huway. ");
INSERT INTO dgc_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nadid, kinagi ni Jesus du tolay sa, sakay du alagad na, a ");
INSERT INTO dgc_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Du maistu ta rilihiyon sakay du Pariseyo, éy tukoy tam a side i tagapagpaliwanag ta kautusan ni Moises. ");
INSERT INTO dgc_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kanya dapat sundin moy i pégtoldu de,” kagi na, “pero diyan moy ahigén i gimet dia, da éwan de gégemtén i iyétoldu de. ");
INSERT INTO dgc_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Dagdagen de i mehirap a utus ta rilihiyon de, a pilitén de du tolay a manugsug; pero éwan de side tulungan. ");
INSERT INTO dgc_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Sakay gemtén de i mahusay ta harap na tolay, monda purién de side. Kanya niegut de tu kasulatan na Diyos ta bégi dia, sakay mégbihis side ta memahal! ");
INSERT INTO dgc_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Gustu de be a mégiknud ta pégiknuden na mataas a tolay ta anyayaan, sakay ta kapilya. ");
INSERT INTO dgc_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Sakay gustu de a saloduan side du tolay ta plasa na banuwan. Sakay gustu de a dulawén side a maistu. ");
INSERT INTO dgc_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Pero sikam,” kagi ni Jesus, “éy diyan kam pédulaw a maistu, da isesa i Maistu moy. Sakay sikam a étanan éy minégtop kam. ");
INSERT INTO dgc_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Sakay diyan moy dédulawén a améng i maski ti ésiya a tolay ta mundua, da isesa i Ama moy, éy siya tu Ama moy ta langet. ");
INSERT INTO dgc_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Sakay diyan kam be pédulaw a amo, da isesa i Amo moy, tu pinili na Diyos a maghari. ");
INSERT INTO dgc_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Sakay i mataas dikam éy siya i dapat utusan moy. ");
INSERT INTO dgc_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Dahilan du pumilit a magmataas, éy pakasaniken side na Diyos. Pero du magpababa, éy pataasén side na Diyos.” ");
INSERT INTO dgc_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Kagbi kam, sikam a maistu ta rilihiyon, sakay sikam a Pariseyo. Mégwari-wari kam a éwan kam tu kasalanan!” kagi ni Jesus. “Harangan moy du tolay monda éwan side mapagharian na Diyos. Idel moy dén a pasakup ta péghari na Diyos, sakay harangan moy be du iba a gustu a pasakup! ");
INSERT INTO dgc_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Kagbi kam, sikam a maistu ta rilihiyon, sakay sikam a Pariseyo. Mégwari-wari kam a éwan kam tu kasalanan! Lélakadén moy i digita, sakay abutén moy i maski adeyo a lugar, a monda makaakit kam ta maski isesa a tolay a pasakup ta rilihiyon moy. Sakay éng maakit moy dén i tolay, éy lalo a mahigpit i parusa na ta impiyerno, da pasakup dén dikam. ");
INSERT INTO dgc_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Kagbi kam, sikam a mégakay ta tolay, pero buhék kam be!” kagi ni Jesus. “I pégtoldu moya, éng isumpa na tolay ta Templo, éy éwan kan tu kailangan a mangtupad to pangako na. Pero éng isumpa na ta gintu ta Templo, éy kagi moy a dapat tupadén na i sumpa na. ");
INSERT INTO dgc_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mali kam! Sikam a buhék a luku-luku! Ahe i lalo a mahalaga, tu gintu o tu Templo a mégpabanal to gintu? ");
INSERT INTO dgc_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Sakay kagi moy be, a éng isumpa na tolay to pégatangan, éy éwan kan siya tu kailangan a mangtupad to pangako na. Pero éng isumpa na to te déton sa a regalo, éy kagi moy a dapat tupadén na tu sumpa na. ");
INSERT INTO dgc_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Buhék kam a mégkamali! Ahe i lalo a mahalaga, tu regalo, o tu pégatangan a mégpabanal to regalo? ");
INSERT INTO dgc_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kanya ngani, éng isumpa na tolay to pégatangan, éy bilang isumpa na be dén i étanan a te déton sa. ");
INSERT INTO dgc_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Sakay tu isumpa ta Templo, éy bilang isumpa na be dén ta Diyos a mégiyan sa. ");
INSERT INTO dgc_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Sakay tu isumpa ta langet, éy bilang isumpa na be dén ta Diyos, sakay pati ta pégiyanan na Diyos. ");
INSERT INTO dgc_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Kagbi kam, sikam a maistu ta rilihiyon, sakay sikam a Pariseyo,” kagi ni Jesus. “Mégwari-wari kam a éwan kam tu kasalanan! Iatéd moy ta Diyos i ikasapulu na kabuhayan moy, a hanggan ta atong moy a éwan tu halaga. Pero kinaleksapan moy i lalo a mahalaga a utus, ta pégimet ta mahusay, sakay ta péngagbi ta tolay, sakay ta matapat a ugali. Mangatéd kam ta Diyos. Pero gemtén moy be i mahalaga a utus. ");
INSERT INTO dgc_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","“Sikam a mégakay ta tolay, pero buhék kam be! Sundin moy i éwan mahalaga a utus, pero du mahalaga a utus na Diyos, éy pébayan moy! ");
INSERT INTO dgc_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Kagbi kam, sikam a maistu ta rilihiyon, sakay sikam a Pariseyo,” kagi ni Jesus. “Mégwari-wari kam a éwan kam tu kasalanan! Ugisan moy du tasa moy sakay du penggan moy, pero i ihayin moy sa éy medukés, da inalap moy to péngdaya moy, sakay to kedémot moy. ");
INSERT INTO dgc_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Buhék kam a Pariseyo! Pahusayén moy pa i ihayin moya ta penggan moy, monda melinis be du penggan. ");
INSERT INTO dgc_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Kagbi kam, sikam a maistu ta rilihiyon, sakay sikam a Pariseyo. Mégkukunwari kam a éwan kam tu kasalanan! Kapareho kam na melatak a pantiyung, a kamahalan i luwas na, pero i disalad na éy putat ta buyok sakay tulang na pate. ");
INSERT INTO dgc_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ey kona be sa dikam! Ta péketa dikam na tolay, éy memahal kam, pero i katutuhanana éy putat kam ta kakabulyan sakay kasalanan.” ");
INSERT INTO dgc_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Kagbi kam, sikam a maistu ta rilihiyon, sakay sikam a Pariseyo,” kagi ni Jesus. “Mégkukunwari kam a éwan kam tu kasalanan! Ginimet moy du pantiyung du purupeta to araw, sakay pinahusay moy du pantiyung du mahusay a tolay. ");
INSERT INTO dgc_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","I kékagin moya, éy ‘Eng sikame maka i buhaya to panahun pa du apo tam éy éwan me ipabuno du purupeta.’ ");
INSERT INTO dgc_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Aminén moy bale a sikam i apoa du nagpabuno du purupeta! ");
INSERT INTO dgc_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Sigi! Tapusén moy i sinapulan du apo moy! ");
INSERT INTO dgc_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Sikam a magkadukés a tolay! Pakodyan moy a makaiwas ta hukum ta impiyerno? ");
INSERT INTO dgc_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kanya ngani éy paangen ko dikam i magtoldu ta kagi na Diyos, sakay du makapospos ta Diyos. Pero bunuén moy i sénganya dide. Sakay du agum éy ipako moy ta kudos. Du iba éy yabatén moy ta kapilya moy. Sakay du iba éy lélokon moy side maski ahe angayan de. ");
INSERT INTO dgc_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ey dahil ta éya, i étanan a parusa a para du nagbuno ta tolay éy meange dikam. Sapul to nipamuno to éwan tu kasalanan a ti Abel, a hanggan to nipamuno ni Sakarias, a anak ni Barakias. Binuno moy ti Sakarias to sélat no lamesa a pégatangan sakay to Templo. ");
INSERT INTO dgc_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","O, dumemét ina a talaga. I parusa dahil ta étanan a éya, éy meange du tolay ta éye.” ");
INSERT INTO dgc_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Ayhay, sikam a taga Jerusalem. Kagbi kam,” kagi ni Jesus. “Palagi kam a mémuno du purupeta! Palagi moy a batibatikalén du paangen dikam na Diyos! Ayhay, meadu a beses éy gustu ko maka a mégalaga dikam ta kapareho na manok éng léképan na du anak na, pero idel moy! ");
INSERT INTO dgc_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kanya nadid éy pabayan ta kam dén. ");
INSERT INTO dgc_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ey tandaan moy,” kagi ni Jesus, “éwanék moy dén meta a huway, a hanggan éwan dumemét i oras a kagin moy, a ‘Basbasan maka na Diyos tu lélake a pinaange na se.’” ");
INSERT INTO dgc_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Nadid, kéhektat de Jesus to Templo, éy nitoldu diya du alagad na tu Templo, a memahal. ");
INSERT INTO dgc_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","“O,” kagi ni Jesus, “pero i Templo a ina a te itan moy, éy tandaan moy ye: dumemét i oras a éwan sina tu mabuhay a bito a te tupo ta kapareho na a bito ta dingding naa. Matibatibag side a étanan!” ");
INSERT INTO dgc_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Nadid, inumeknud ti Jesus ta buked na Olibo; éy du alagad na, éy nipakelagip de diya ta lihim, a “Nikésiya i deméta na éya a kinagi mo, Panginoon? Anya wade i tandaa na huway a késoli mo se, sakay ta katapusan na mundua?” ");
INSERT INTO dgc_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","“Mangilag kam,” kagi ni Jesus, “monda éwan de kam pagkamalién. ");
INSERT INTO dgc_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Dahilan éy meadu a umange se a mégkagi a side i Cristo a tiniyak na Diyos a tagapagligtas ta mundua. Ey meadu side a pagkamalién a tolay. ");
INSERT INTO dgc_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Makabaheta kam ta meadu a gera, pero ta pékabaheta moy, éy diyan kam métageg. Dumemét a talaga i meadu a gera, pero éwan ya tanda na katapusan. ");
INSERT INTO dgc_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Dahilan éy maglaban-laban du banubanuwan. Sakay dumemét i meadu a alép, sakay te lindul ta iba-iba a lugar. ");
INSERT INTO dgc_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","I étanan a éya éy sapul pabi na hirap a dumemét. ");
INSERT INTO dgc_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Kédemét na panahun a éya,” kagi ni Jesus, “éy itokyon de kam, monda pahirapan de kam sakay bunuén. Sakay kaiyamutan kam na étanan a tolay, da méniwala kam diyakén. ");
INSERT INTO dgc_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kédemét na éya éy umibut i meadu ta péniwala de diyakén. Sakay maiyamut side ta kakaguman de, a itokyon de be du kakaguman de. ");
INSERT INTO dgc_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Dumemét be i meadu a kakabulyan a purupeta a kagin de a gébwat side ta Diyos, a tulos de a pagkamalién i meadu. ");
INSERT INTO dgc_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Lumalo a lumalo i medukés a ugali ta mundua, a hanggan éwan mahalén na tolay i kapareho na. ");
INSERT INTO dgc_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pero du matapat a méniwala diyakén a hanggan ta katapusan, éy meligtas side. ");
INSERT INTO dgc_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Sakay ipahayag de ta buu a mundu i Mahusay a Baheta tungkul ta péghari na Diyos, monda mapospusan na étanan a banuwan. Ey nadid éy dumemét i katapusan.” ");
INSERT INTO dgc_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Nadid,” kagi ni Jesus, “dumemét i oras a meta moy ta Templo tu kontara ta Diyos a mangsida, a kona to kinagi ni Purupeta Danyel. (Sikam a magbasa ta éye, éy isipén moy ye.) Péketa moy ta éya, éy ");
INSERT INTO dgc_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","du édse ta Hudea, éy dapat guminan side ta buked. ");
INSERT INTO dgc_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Sakay du édse ta luwas no bile de, éy diyan dén side sumésdép a mangalap ta kasangkapan de. ");
INSERT INTO dgc_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Sakay du édse ta uma éy diyan dén umuli a mangalap ta badu de. ");
INSERT INTO dgc_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kakakagbi du mabuktet sakay du te mabulol ta panahun a éya! ");
INSERT INTO dgc_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ipanalangin moy a éwan metaun i kéginan moy ta taglamig, o dikaya ta aldew na pangilin. ");
INSERT INTO dgc_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Dahilan ta panahun a éya,” kagi ni Jesus, “éy du étanan a tolay éy magdanas side ta dikél a kahirapan. Ewan pabi nakekenaman na tolay i kona sa a hirap sapul to péglalang ta mundua a hanggan nadid. Pero éwan tu kéhuway i kona sa a panahun. ");
INSERT INTO dgc_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Pero paseplutén san na Diyos i éya a panahun, da éng éwan na paseplutén éy éwan tu mabuhay a tolay. Kanya paseplutén na, éy alang-alang du pinili na a tolay a sakup na. ");
INSERT INTO dgc_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Nadid,” kagi ni Jesus du alagad na, “éng te mégkagi dikam, a ‘Kéye dén se tu tiniyak na Diyos a tagapagligtas,’ o te mégkagi a ‘Kéye na dén sina,’ éy diyan kam méniwala. ");
INSERT INTO dgc_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Da te lumitaw ngani a kakabulyan a tolay, a kagi de a side i tiniyak na Diyos a tagapagligtas, sakay kagi du iba, a purupeta side a gébwat ta Diyos. Sakay ipeta de be i makataka-taka a tanda, monda lukoén de, éng maari, du méniwala be ta Diyos. ");
INSERT INTO dgc_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ey tandaan moy ina, da kinagi ko dén ya dikam bagu dumemét. ");
INSERT INTO dgc_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Kanya éng kagin dikam na tolay, a ‘Edsa ta éya a ilang tu tiniyak na Diyos a tagapagligtas,’ éy diyan kam sa uméange. Sakay éng te mégkagi a ‘Edse dén siya ta lubuk na bileae,’ éy diyan kam be méniwala. ");
INSERT INTO dgc_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Dahilan,” kagi ni Jesus, “i demét ko a se éy koman i kilat a bigla a mademlagen i kabuuana na langet. Sakén i lélake a gebwat ta langet. ");
INSERT INTO dgc_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Eng ahe i édseana na pate, éy séˈ man dén ya i dulugéna du wakwak.” ");
INSERT INTO dgc_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Nadid, kétapos na kahirapan a éya,” kagi ni Jesus, “éy dumiklém i bilag sakay ta bulan, sakay matékneg du biton a gébwat ta langet, da mayégyég side. ");
INSERT INTO dgc_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ey nadid, éy pumeta ta langet i tanda na kédemét ko, sakén a lélake a gébwat ta langet. Tulos magsanget i étanan a tolay ta mundua. Nadid, metaék de ta kuném a dumibi ta lutaa a maghari, a kébil ko i kapangyarian ko. ");
INSERT INTO dgc_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nadid, magténog ta medegsén i tambuli, a tulos ko paangen du anghel ko ta maski ahe ta mundua, sakay ta langet, a monda tipunén de du étanan a sakup ko a tolay.” ");
INSERT INTO dgc_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Isipén moy i kahulugina na halimbawaae na kayo a igos,” kagi ni Jesus. “Bagay mégogbus i tingi-tingi na, éy tukoy moy a adene dén i késinag. ");
INSERT INTO dgc_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Nadid, kona be sa, bagay meta moy i étanan a éya a nihula ko, éy tukoy moy dén a adene dén i kédemét ko--a mégsapul dén. ");
INSERT INTO dgc_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Tandaan moy, manyari pa i étanan a éya bagu mate i étanan a tolay a buhay nadid. ");
INSERT INTO dgc_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Maibut i langet éy ta luta, pero i kagi ko éy éwan maibut.” ");
INSERT INTO dgc_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Pero éwan tu nakapospos ta oras na kédemét na éya,” kagi ni Jesus. “Maski du anghel ta langet, maski sakén a anak na Diyos--basta Tama ko san i nakapospusa ta éya. ");
INSERT INTO dgc_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","38","Sakén i lélake a gébwat ta langet. I kédemét ko éy kapareho na kédemét no bihéng to panahun ni Noe. I tolay to éya éy basta méngan side sakay méginom side, sakay mégasawa side, hanggan to oras a késakay de Noe to barko. ");
INSERT INTO dgc_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Sakay dinumemét tu bihéng a éwan de tukoy. Ey basta meanod side a étanan. Ey nadid, kona be sa i manyaria ta kédemét ko, sakén a gébwat ta langet. ");
INSERT INTO dgc_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ta panahun a éya,” kagi na, “éy te éduwa a lélake a mégtarabaho ta uma; maalap tu esa, éy tu esa éy mawahak. ");
INSERT INTO dgc_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Sakay te éduwa a bébe a mégkaguman side a mégiling, éy maalap tu esa, éy tu esa éy mawahak. ");
INSERT INTO dgc_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Kanya sikam, éy bantayan moy, da éwan moy tukoy éng nikésiya i deméta na Panginoon moy. ");
INSERT INTO dgc_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ey tandaan moy ye,” kagi ni Jesus, “éng mara tu lélake, éng napospusan na maka i kédeméta a kélép no nagtako to bile na, éy binantayan na maka, monda éwan maka nakasdép tu nagtako. ");
INSERT INTO dgc_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kanya sikam, éy dapat nakahanda kam a palagi, da éwan moy be tukoy i oras a kédemét ko; sakén a lélake a gébwat ta langet.” ");
INSERT INTO dgc_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Ti ésiya wade i matapat a utusan a matalinung?” kagi ni Jesus. “Mara siya tu pinamahalaa no amo na du iba a utusan na, a siya i bahala a manggastos dide. ");
INSERT INTO dgc_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Masuwerte i éya a utusan, éng demtan siya no amo na a mégtarabaho ta kona sa. ");
INSERT INTO dgc_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ey ientarega diya no amo na i étanan a ari-arian na. ");
INSERT INTO dgc_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero éng medukés i éya a utusan, a maisipan na a male pabi bagu magsoli tu amo na, ");
INSERT INTO dgc_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","sakay tulos na a lukoén du kaguman na a utusan, sakay méngan sakay mékipéginom du méglalasing, ");
INSERT INTO dgc_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","éy demtan siya no amo na ta oras a éwan na tukoy. ");
INSERT INTO dgc_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ey parusaan na siya ta mahigpit, sakay iagum na siya ta édsean du mégpalalo a mégkagi a éwan side tu kasalanan. Saya i lugara a mégsésangitén i tolay, a mégéadiyoyén side ta hirap de.” ");
INSERT INTO dgc_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Saya i kaparehua na késdép ta kaharian na Diyos,” kagi ni Jesus. “Mara te sapulu a madiket a linumuwas a sambatén de tu lélake a kasalén. Bawat esa dide éy te kébil a simbu. ");
INSERT INTO dgc_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Tu lima dide éy éwan side nakahanda, da éwan side nagisip. Sakay tu lima éy matalinung. ");
INSERT INTO dgc_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","4","Du matalinung, éy nagkébil side ta simbu, sakay nagpataan side ta langis. Ey du éwan nakahanda, éy te simbu be side, pero éwan side nagpataan ta langis de. ");
INSERT INTO dgc_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nale i kédeméta no kasalén. Kanya nagtongka du madiket, a nakatidug side a étanan. ");
INSERT INTO dgc_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Nadid, to hatinggabi dén, éy te nagdulaw, a ‘Dumemét dén tu kasalén! Nay! Ange moy dén sambatén!’ ");
INSERT INTO dgc_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Agad inumikat du sapulu a madiket, sakay hinusay de du simbu de. ");
INSERT INTO dgc_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ey du éwan nakahanda, éy kinagi de du matalinung, a ‘Atdinan moy kame ta kétihék a langis. Mégédép-édép dén di simbu miae.’ ");
INSERT INTO dgc_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","‘Makay éwan ye hustu dikitam a étanan,’ kagi du matalinung. ‘Maigi pa éy umange kam ta tindaan a mamugtong ta para koo moy.’ ");
INSERT INTO dgc_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Kanya minaglakad du lima a madiket a éwan nakahanda. Ey habang mamugtong side éy dinumemét dén tu kasalén. Ey du lima a nakahanda éy kaguman na a sinomdép to pégkasalan, sakay sineraduan de tu pintuan. ");
INSERT INTO dgc_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Mamaya-maya, éy dinumemét dén du lima a madiket a éwan nakahanda. ‘Panginoon,’ kagi de, ‘bukasan mo kame.’ ");
INSERT INTO dgc_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Pero i sengbet sana dide no kasalén, éy ‘Ewan, da éwan ta kam tukoy.’ ");
INSERT INTO dgc_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Kanya bantayan moy,” kagi ni Jesus, “da éwan moy tukoy i oras a kédemét ko.” a Pégentaregaan Ta Kuhata ");
INSERT INTO dgc_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“I paghari na Diyos éy kapareho na éye,” kagi ni Jesus. “Eng mara, te lélake a méglakad, a dinulawan na pa du utusan na, a pégentaregaan na side ta ari-arian na. ");
INSERT INTO dgc_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Inatdinan na ta kuhata i bawat esa dide, hanggan ta kaya de a pagnigosiyo. Inatdinan na i esa ta lima a libu a pisu; i esa man éy éduwa a libu; sakay tu esa pa éy sanlibu. Ey nadid, hinumektat siya. ");
INSERT INTO dgc_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Nadid, tu tinumanggap ta lima a libu a pisu, éy nagtinda-tinda siya, éy nakatubu siya ta lima pa a libu. ");
INSERT INTO dgc_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ey kona be sa tu tinumanggap ta éduwa a libu, éy nakatubu be ta éduwa pa a libu. ");
INSERT INTO dgc_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pero tu tinumanggap ta sanlibu, éy nagkotkot siya ta lutaa sakay niliso na tu kuhata no amo na. ");
INSERT INTO dgc_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Nale a panahun, éy sinumoli tu amo du étélo a utusan, éy pinagbayad na side. ");
INSERT INTO dgc_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kéadene no tinumanggap ta lima a libu, éy kinagi na, a ‘Amo, saye tu lima a libu a pisu a niatéd mo diyakén. Sakay séˈ be ye i lima a libu a tubu no tinda ko.’ ");
INSERT INTO dgc_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ey kinagi no amo na, a ‘Mahusay tu ginamet mo. Mahusay ka a utusan a matapat. Nadid, da nagtapat ka ta kétihék a éye a halaga, éy pamahalaén ta ka ta dikél a halaga. Somdép ka se, a mékihati ka ta kasayaan kua.’ ");
INSERT INTO dgc_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Nadid, inumadene be tu tinumanggap ta éduwa a libu a pisu, a kinagi na, a ‘Amo, saye tu nientarega mo diyakén a éduwa a libu. Sakay séˈ be ye i éduwa a libu a tubu no tinda ko.’ ");
INSERT INTO dgc_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ey kinagi no amo na, a ‘Mahusay tu ginamet mo. Mahusay ka a utusan a matapat. Nadid, da nagtapat ka ta kétihék a éye a halaga, éy pamahalaén ta ka ta dikél a halaga. Somdép ka se, a mékihati ka ta kasayaan kua.’ ");
INSERT INTO dgc_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Nadid, inumadene be tu tinumanggap ta sanlibu a monda mangatuwiran. ‘Amo,’ kagi na, ‘tukoy ko a meingél ka a lélake, a alapén mo tu éwan mo koo. ");
INSERT INTO dgc_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nagantengék diko, kanya nikotkot ko ta luta tu kuhata mo. Séˈ dén ye tu kuhata mo a sanlibu; isoli ko dén diko.’ ");
INSERT INTO dgc_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","‘Medukés ka a utusan!’ kagi no amo na. ‘Akala mo bale dén a alapén ko tu éwan ko koo? ");
INSERT INTO dgc_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Eng kona sa, éy bakit éwan mo san nihulug ta bangko, monda te naalapék maka nadid a tubu na?’ ");
INSERT INTO dgc_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Nadid, kinagi na du iba sa, a ‘Nay, alapén moy diya i sanlibu a pisu, sakay iatéd moy to te sapulu a libu. ");
INSERT INTO dgc_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Dahilan, tu tolay a pégkatiwalaan ko to nientarega ko diya, éy dagdagen ko pa siya. Pero tu éwan ko pégkatiwalaan, éy alapén ko be tu kétihék a nientarega ko diya. ");
INSERT INTO dgc_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ey nadid, i utusan kuae a éwan tu pasa, éy ibut moy dén ta kedikléman ta luwas. Saya i pégsangitana du tolay a mégéadiyoyén ta hirap de.’” ");
INSERT INTO dgc_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Nadid,” kagi ni Jesus, “kédemét ko se a maghari, éy kaguman ko du étanan a anghel, sakay maghariék, da sakén i lélake a gébwat ta langet. ");
INSERT INTO dgc_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ta panahun a éya, éy matipun ta harapan kua i étanan a tolay. Ey pabukudén ko du mahusay a kona ta gimet na mégalila ta tupa éy ta kambing. ");
INSERT INTO dgc_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Du tupa éy iedton na ta dumanég ta kawanan na; du kambing éy dumanég ta kawihe na. ");
INSERT INTO dgc_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Nadid, ta péghari ko,” kagi ni Jesus, “éy kagin ko du édse ta dumanég ta kawanan ko, a ‘Kamon se, sikam a kinagbian Nama ko. Somdép kam dén a mégiyan kam ta kaharian a nihanda dikam sapul pa to pénglalang ta mundua. ");
INSERT INTO dgc_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Da sakén,’ kagi ko, ‘to pégalép ko éy pinakanék moy. Pati to pégeplék ko éy pinenomék moy; sakay maski éwanék moy natenggi, éy pinatulosék moy. ");
INSERT INTO dgc_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","To éwanék tu badu, éy pinabaduanék moy; to kéladu ko, éy dinalawék moy; sakay to képihesu ko éy dinalawék moy be.’ ");
INSERT INTO dgc_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Nadid, éng mégkagiék ta éya, éy sumengbet du mahusay a tolay, a kagi de a, ‘Panginoon, nikésiya i nipagalép mua a pinamakan me diko? Sakay ta ahe ka nageplék a pinenom me ka? ");
INSERT INTO dgc_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nikésiya i nipamatulos mia diko sakay pinabaduan me ka? ");
INSERT INTO dgc_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Sakay nikésiya me ka mineta a minaladu, sakay nikésiya me ka mineta ta pihesuan, a dinalaw me ka?’ ");
INSERT INTO dgc_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Nadid, pégkagi du mahusay ta éya, éy kagin ko dide, a ‘Tandaan moy, to pénggimet moy ta éya a tulung du top ko a mahirap, éy bilang sakén dén ya i tinulungan moya.’ ");
INSERT INTO dgc_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ey nadid, éy kagi ko man dén du dumanég ta kawihe kua, a ‘Umadeyo kam diyakén, sikam a nisumpa na Diyos! Sikam éy meange kam ta apoy a éwan maadép, a handa dén a para ni Satanas sakay du utusan na. ");
INSERT INTO dgc_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Da sakén,’ kagi ko, ‘to pégalép ko éy éwanék moy pinakan. To pégeplék ko éy éwanék moy pinenom. ");
INSERT INTO dgc_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","To kébisita ko dikam, éy éwanék moy pinatulos, da éwanék moy natenggi. Sakay to éwanék tu badu, éy éwanék moy pinabaduan. Sakay to kéladu ko sakay to képihesu ko éy éwanék moy dinalaw.’ ");
INSERT INTO dgc_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Nadid, éng mégkagiék ta éya dide, éy kagin de, a ‘Panginoon, nikésiya i nipaketa mia diko a nagalép, sakay nageplék, sakay naladu, sakay ta pihesuan, sakay ta éwan tu badu, a éwan me ka tinulungan? Nikésiya i éwan mia diko nipamatulos?’” ");
INSERT INTO dgc_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ey pégkagi de ta éya diyakén, éy kagin ko dide, a ‘Tandaan moy, to niidel moy a tumulung du mahirap, éy bilang sakén dén ya i inidelan moya.’ ");
INSERT INTO dgc_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Nadid, diden ya a tolay,” kagi ni Jesus, “éy itugén side ta pégparusaan a éwan tu katapusan. Pero du mahusay, éy atdinan side ta buhay a éwan tu katapusan.” ");
INSERT INTO dgc_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Nadid, kétapos ni Jesus a mégtoldu ta éya, éy kinagi na du alagad na, a ");
INSERT INTO dgc_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Tukoy moy dén a éduwa a aldew san dén éy Piyesta dén na Ala-ala. Ey sakén a gébwat ta langet, éy itokyonék de, a ipakoék de ta kudos.” ");
INSERT INTO dgc_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Nadid, du mataas a padi, sakay du matétanda, éy nagmiting side to bile no mataas a padi, a ti Kaipas. ");
INSERT INTO dgc_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Naguhunan de a ipadikép ti Jesus ta lihim, sakay ipabunu de. ");
INSERT INTO dgc_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","“Pero éwan nadid a piyesta,” kagi de, “makay maligalig di tolaya.” ");
INSERT INTO dgc_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Nadid, édsa ti Jesus ta Betania, to bile ni Simon a te ketong to araw. ");
INSERT INTO dgc_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ale na a méngan sa, éy inumadene diya i esa a bébe a te kébil a boti a putat ta memahal a pabango; sakay nibulak na ta uloa ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ey du alagad, péketa de ta éya, éy nagingél side. “Bakit,” kagi de, “kakenga dén ina! ");
INSERT INTO dgc_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nibugtong mo maka ina ta mahal, sakay niatéd mo du mahirap i kabugtungan naa.” ");
INSERT INTO dgc_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Tukoy dén ni Jesus tu kinagi de, kanya kinagi na, a “Bakit péginglan moy i bébea? Mahusay i gimet na diyakén. ");
INSERT INTO dgc_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Palagi a kaguman moy du mahirap,” kagi na, “pero sakén éy éwanék male a kaguman moy. Makatulung kam dide ta maski nikésiya, pero sakén éy éwan. ");
INSERT INTO dgc_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Mahusay da binulakan na i bégi kua ta pabangoae. Iduwel na dén ya diyakén, da ielbéngék dén. ");
INSERT INTO dgc_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Tandaan moy, maski ta ahe i pagtolduan dia ta Mahusay a Baheta, éy ipaala-ala de be i ginimita na éye a bébe diyakén.” ");
INSERT INTO dgc_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Nadid, tu esa du labindalawa, a ngéngahinan de a Hudas Iskarote, éy nékipéguhon siya du mataas a padi, ");
INSERT INTO dgc_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","a kinagi na dide, a “Sénganya i iatéd moya diyakén éng itokyon ko dikam ti Jesus?” Ey nagkasundu side a inatdinan de siya ta étélo a pulu a kuhata a plata. ");
INSERT INTO dgc_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ey sapul ta éya, éy mégisip dén ti Hudas ta oras a péngitokyon na ni Jesus dide. ");
INSERT INTO dgc_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Nadid, kédemét na oras no piyesta a péngan de ta melapis a tinapay, éy kinagi du alagad ni Jesus, a “Ahe i paghandaan me ta péngapon tam nadid a Piyesta na Ala-ala?” ");
INSERT INTO dgc_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ey kinagi ni Jesus dide, a “Umuli kam ta banuwan, a kagi moy to lélake ta éya, a ‘Dumemét dén i takda a oras no Maistu me.’ Kagi moy diya a méngapon kitam ta bile na nadid a Piyesta na Ala-ala.” ");
INSERT INTO dgc_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Nadid, sinunud du alagad tu nibilin ni Jesus, sakay nihanda de tu péngapon de para ta Piyesta na Ala-ala. ");
INSERT INTO dgc_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nadid, to kélép a éya, éy néngan sa de Jesus, a kaguman na du labindalawa a alagad na. ");
INSERT INTO dgc_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Hanggan méngan side, éy kinagi ni Jesus, a “Tandaan moy, esa dikam i méngitokyon diyakén.” ");
INSERT INTO dgc_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ey du alagad, pékabati de ta éya, éy nalungkut side, a kinagi na bawat esa dide, a “Sakén wade, Panginoon.” ");
INSERT INTO dgc_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","“Tu kasabay ko a néngisawsaw ta tinapay ta sabawae,” kagi na, “éy siya i méngitokyona diyakén. ");
INSERT INTO dgc_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Kailangan a mateék ayun to nisulat du purupeta to araw, pero kagbi tu méngitokyon diyakén! Maigi pa éy éwan dén nienak.” ");
INSERT INTO dgc_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Nadid, kinagi ni Hudas, a “Maistu, sakén wade?” “Siko ngani dén,” kagi ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nadid, to péngan de, éy inalap ni Jesus tu kanén de a tinapay, éy to pégpasalamat na ta Diyos, éy pinuseng-puseng na a nitagtag na du alagad na. “Kanén moy dén ye,” kagi na, “a saye i bégi kua.” ");
INSERT INTO dgc_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nadid, inalap na tu tasa a te lasén a alak. Ey to pégpasalamat na dén, éy nigewat na dide, a kinagi na, a “Inumén moy dén ye, sikam a étanan. ");
INSERT INTO dgc_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Da saye i digi kua, a saye i tanda na pangako na Diyos. Ey mebulak alang-alang ta meadu a tolay. Saye i pégpatawad ta kasalanan na tolay. ");
INSERT INTO dgc_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ey tandaan moy,” kagi ni Jesus, “éwanék dén uminom ta alak, éng éwan magpisan kitam a uminom ta bigu a alak ta kaharian Nama ko.” ");
INSERT INTO dgc_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nadid, to pégkanta de ta kanta ta Diyos, éy naglakad dén side ta buked na Olibo. ");
INSERT INTO dgc_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Nadid, kinagi ni Jesus du alagad na, a “Nadid a kélép éy ginananék moy a étanan, da nisulat du purupeta to araw, a ‘Ta ipagpabuno na Diyos to Pastor, éy matibuhahak du tupa.’ ");
INSERT INTO dgc_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pero kébuhay ko a huway,” kagi ni Jesus, “éy mégditulék dikam ta Galilea.” ");
INSERT INTO dgc_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Nadid, kinagi ni Pedro, a “Sakén, Panginoon, éy éwan ta ka ginanan, maski ginanan ka du iba.” ");
INSERT INTO dgc_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","“Ewan, Pedro,” kagi ni Jesus, “da tandaan mo, nadid a kélép, bagu magtarakot tu tandang, éy itanggiék mo ta pentélo a éwanék mo kaguman.” ");
INSERT INTO dgc_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ey “Ewan,” kagi ni Pedro, “maski mateék a kaguman mo éy éwan ta ka itanggi!” Ey kona be sa i kinagia du étanan a alagad. ");
INSERT INTO dgc_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Nadid, kinuyog ni Jesus du alagad na ta Getsemani. Ey kinagi na dide, a “Mégiknud kam pa se, a manalanginék ta dumanég a sae.” ");
INSERT INTO dgc_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ey kinuyog na ti Pedro sakay du éduwa a anak ni Sebedeo. Ey nalungkut ti Jesus a métageg. ");
INSERT INTO dgc_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ey kinagi na dide, a “Métagegék tu isip, a komanék i mate. Maguhay kam se a mékipagpuyat kam diyakén.” ");
INSERT INTO dgc_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nadid, kéadeyo na ta kétihék, éy dinumapa a ménalangin. “Améng,” kagi na, “éng maari éy iadeyo mo diyakén i paghirap ko. Pero éwan na kaluuben kua i masunud, éngˈwan na kaluuben mo i masunud.” ");
INSERT INTO dgc_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nadid, késoli na éy dinemtan na a tidug du étélo a alagad. Ey kinagi na ni Pedro, a “Talaga bale a éwan kam makapagpuyat a maski esa a oras a kaguman ko? ");
INSERT INTO dgc_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Magpuyat kam sakay manalangin kam, monda éwan kam madaig na mangpuhuba dikam. Méniwala kam diyakén ta isip moya, pero i bégi moya éy mehina.” ");
INSERT INTO dgc_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nadid, huway siya a inumadeyo dide a ménalangin. “Améng,” kagi na, “éng éwan maibut i paghirap kua, éy manyari maka dén i kaluuben mo.” ");
INSERT INTO dgc_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nadid, késoli na a huway, éy dinemtan na man dén side a tidug, da mégtongka side a tahod. ");
INSERT INTO dgc_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Kanya pinabayan na side to ikatélo, a soli na a ménalangin, a ménalangin siya ta kona to kinagi na to ditol. ");
INSERT INTO dgc_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Nadid, nagsoli man dén siya du alagad a kinagi na dide, a “Tidug kam bale pabi? Entan moy, dumemét dén i oras a péngitokyon de diyakén du makasalanan a tolay. ");
INSERT INTO dgc_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Nay, umikat kam dén a kitam dén. Dumemét dén i méngitokyon diyakén.” ");
INSERT INTO dgc_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Mégkagi pabi ti Jesus éy dinumemét dén ti Hudas, tu esa du labindalawa. Te kaguman siya a meadu a tolay a gébwat side du mataas a padi sakay du matétanda. Sakay te kébil side a sondang éy ta gahoti. ");
INSERT INTO dgc_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Bagu pa side dinumemét ta éya, éy kinagi dén ni Hudas dide, a atdinan na side ta tanda, monda matukoy de ti Jesus. “Tu ahoben ko,” kagi na, “éy siya i dekpén moya.” ");
INSERT INTO dgc_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Kanya nadid, éy inumadene ti Hudas ni Jesus, a binati na siya, a tulos na inahoben. ");
INSERT INTO dgc_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ey kinagi ni Jesus diya, a “Bakit, Kadimoy, magenya ka se?” Ey to pégkagi na ta éya, éy dinikép de siya. ");
INSERT INTO dgc_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Nadid, tu kaguman ni Jesus a esa, éy binagut na tu sondang na, a tinegpas na tu utusan no mataas a padi, a minahipas i talinga naa. ");
INSERT INTO dgc_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Pero kinagi ni Jesus diya, a “Ikaluban mo i sondang mua! I lumaban ta sondang, éy sondang be i katayan naa. ");
INSERT INTO dgc_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ewan moy beman tukoy, a mékiohonék san Nama ko, éy paangen na se agad i mahigit pa ta labindalawa a batalyon na anghel? ");
INSERT INTO dgc_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero éng kona sa éy éwan matupad i kasulatan na Diyos tungkul ta hirap ko.” ");
INSERT INTO dgc_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Nadid, kinagi ni Jesus du tolay sa a nanikép diya, a “Bakit te armas kam a sondang éy ta kayo a panikép diyakén? Ataay, tulisanék beman a metapang? Aldew-aldew éy mégtolduék ta Templo. Bakit éwanék moy sa dinikép? ");
INSERT INTO dgc_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pero manyari ye a monda matupad tu nihula du purupeta ta kasulatan na Diyos.” Ey to pégkagi ni Jesus ta éya, éy gininanan siya du alagad na. ");
INSERT INTO dgc_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nadid, du nangdikép ni Jesus, éy nitugén de siya to bile ni Kaipas, a mataas a padi. Mégmiting sa nadid du maistu ta rilihiyon sakay du matétanda. ");
INSERT INTO dgc_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Tinumagubet dide ti Pedro, pero adeyo san. Kédemét ni Pedro to bile no mataas a padi, éy sinomdép siya to karsada no bile, sakay négeknud sa a kaguman du guwardia, monda meta na éng anya i manyaria. ");
INSERT INTO dgc_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nadid, du mataas a padi sakay du te tungkulin a Judeo, éy mégahayok pabi side ta magsistigu ta kakabulyan a kontara ni Jesus, monda te katuwiran side a ipabuno siya. ");
INSERT INTO dgc_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pero éwan side tu meeta, maski meadu a kaharap a mégkagi ta kakabulyan tungkul diya. I katapusana, éy te éduwa a hinumarap, ");
INSERT INTO dgc_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","a kinagi de, a “Kagi na ina a lélake a maari na kan a hukatén i Templo na Diyos, sakay huwayén na kan a pataknégén ta étélo san a aldew.” ");
INSERT INTO dgc_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nadid, tinumaknég tu mataas a padi, a kinagi na ni Jesus, a “Ewan ka beman tu isengbet di mégpehaya diko?” ");
INSERT INTO dgc_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pero éwan négkagi ti Jesus. Kanya kinagi no mataas a padi, a “Ta ngahen na tunay a Diyos, i utus kua diko éy isumpa mo dikame éng siko a talaga i anaka na Diyos. Ikagi mo dén éng siko i Cristo a tiniyak na Diyos a tagapagligtas ta tolay ta mundua.” ");
INSERT INTO dgc_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ey kinagi ni Jesus, a “O, kona to kinagi mo. Ey tandaan moy ye, sapul nadid éy metaék moy a mégiknud a magdatig kame ta Diyos, a kagumanék na a maghari. Sakén i lélake a gébwat ta langet. Sakay metaék moy a dumemét a te sakay ta kuném ta langet.” ");
INSERT INTO dgc_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Nadid, to pékabati no padi ta éya, éy pinéknet na tu badu na a sarili, a kinagi na, a “Méglapastangan siya ta Diyos! Mégwari-wari siya a anak na Diyos! Bakit kailangan tam pa a mégbati du magsistigu diya ta kasalanan na? Da nabati tam dén nadid i pégkagi na a kontara ta Diyos! ");
INSERT INTO dgc_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Anya i isip moya?” kagi na. “Ey dapat mate siya,” kagi de. ");
INSERT INTO dgc_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nadid, linoktaben de tu mata ni Jesus, sakay sinésuntuk de. Sinapuk siya du iba, a kinagi de, a ");
INSERT INTO dgc_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Nay, Cristo, tukuyan mo éng ti ésiya i nanuntuka diko!” ");
INSERT INTO dgc_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Nadid ti Pedro, éy te eknud pabi to karsada no bile. Ey inadenean siya no esa a bataan, a kinagi na diya, a “Siko bale i kagumana ni Jesus a taga Galilea!” ");
INSERT INTO dgc_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pero nitanggi ni Pedro ta harapan du étanan sa. “Ewan ko tukoy tu kagi mo,” kagi na. ");
INSERT INTO dgc_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Nadid, kéange ni Pedro to kudal to karsada, éy neta siya no esa pa a bataan, a tulos kinagi na du édsa sa, a “Siya ina i kagumana ni Jesus a taga Nasaret.” ");
INSERT INTO dgc_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pero nitanggi ni Pedro a huway, a nisumpa na, a “Ewan ko natenggi i éya a lélake.” ");
INSERT INTO dgc_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mamaya-maya, éy inumadene ni Pedro du édsa sa, a kinagi de, a “Kaguman na ka ngani a esa. Napospusan me ta pégkagi mua!” ");
INSERT INTO dgc_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","“Bakén a sakén,” kagi ni Pedro, “isumpa ko! Parusaanék na Diyos éng magbuli-buliék! Ewan ko tukoy i éya a lélake!” Ey nadid, bigla a nagtarakot tu tandang. ");
INSERT INTO dgc_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ey naala-ala nadid ni Pedro tu kinagi ni Jesus diya, a “Bagu magtarakot i tandang, éy itanggiék mo ta pentélo.” Ey to pékaala-ala na ta éya, éy linumuwas siya sakay nagsanget ta mahigpit. ");
INSERT INTO dgc_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nadid, to gagabi dén, du mataas a padi sakay du matétanda éy néguhunan de éng pakodyan de a ipabuno ti Jesus. ");
INSERT INTO dgc_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ey nipagapus de siya sakay nitugén de ni Gubernador Pilato. ");
INSERT INTO dgc_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Nadid, ti Hudas a néngitokyon diya, pékabati na a bunon de ti Jesus, éy nagsisi siya, sakay nisoli na du padi tu kuhata a étélo a pulu a plata. ");
INSERT INTO dgc_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Nagkasalaék,” kagi na, “da nitokyon ko i lélake a éwan tu kasalanan.” “Ey anya i pékialam mia diko?” kagi du padi. “Bahala ka sina!” ");
INSERT INTO dgc_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Nadid, nibatikal ni Hudas tu kuhata to lubuk no Templo; sakay hinumektat sa siya a tulos na a nagusot. ");
INSERT INTO dgc_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ey du padi, éy inalap de tu kuhata, a kinagi de, a “Pagenyaan tam i kuhatae? Labag ta utus a iedton tam ta pégabuluyan ta Templo, da kabayaden ye na buhay na tolay.” ");
INSERT INTO dgc_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ey nagkasundu side a ibugtong de to luta no mégimet ta binga, monda gemtén de a péglébngan na dayuan. ");
INSERT INTO dgc_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kanya i luta a éya éy dédulawén de a “Luta na Dige” a hanggan nadid. ");
INSERT INTO dgc_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Nadid, to nipamugtong de ta éya, éy natupad dén tu nihula ni Purupeta Heremias to araw. I nisulat naa, éy “Inalap de tu kuhata a étélo a pulu a plata (da séˈ san ya i nihalaga de ta buhay ni Cristo), ");
INSERT INTO dgc_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","sakay nibugtong de to luta no mégimet ta binga, a kona to niutus diyakén na Panginoon.” ");
INSERT INTO dgc_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Nadid, niharap de ti Jesus to gubernador. Ey kinagi na diya, a “Siko wade beman i haria na Judeo?” “O,” kagi ni Jesus, “kona to kinagi mo.” ");
INSERT INTO dgc_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nadid, to péngpehay diya du mataas a padi sakay du matétanda, éy éwan siya sinumengbet. ");
INSERT INTO dgc_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kanya kinagi ni Pilato diya, a “Bakit éwan ka sumengbet? Ewan mo mébati i iyépehay dia diko?” ");
INSERT INTO dgc_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pero éwan sinumengbet ti Jesus, maski esa a kagi. Kanya nagtaka a tahod tu gubernador. ");
INSERT INTO dgc_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Nadid, tuwing piyesta, éy ugali na gubernador a magpaluwas ta isesa a pihesu, maski ti ésiya i gustu du tolay. ");
INSERT INTO dgc_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ey ta éya a panahun éy te esa sa a tanyag a pihesu a ngéngahinan de a ti Barabas. ");
INSERT INTO dgc_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kanya nadid, to kédulug du tolay sa, éy kinagi ni Pilato dide, a “Ti ésiya i gustu moya a paluwasén ko, ti Barabas o ti Jesus a ngéngahinan moy a Cristo?” ");
INSERT INTO dgc_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Tukoy dén ni Pilato a nitugén de ti Jesus diya da ménaghili side diya. ");
INSERT INTO dgc_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Sakay pati, to pégeknud ni Pilato to hukuman, éy kinagi diya no utusan, a “Nipekagi diyakén no asawa mo, a diyan ka kan mékialam ta lélake a ina a éwan tu kasalanan, da nagtagenép kan siya ta medukés to kélép se tungkul diya.” ");
INSERT INTO dgc_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Nadid, du mataas a padi sakay du matétanda, éy pinégkagian de dén du tolay, a i agidén dia ni Pilato éy ti Barabas i paluwasén na, sakay ti Jesus i pabuno dia. ");
INSERT INTO dgc_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kanya to pégpakelagip dide no gubernador éng ti ésiya i gustu dia a paluwasén na, éy ti Barabas i nisengbet dia. ");
INSERT INTO dgc_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","“Eng kona sa,” kagi ni Pilato, “éy anya i gemtén kua ni Jesus a ngéngahinan moy a Cristo?” “Ipako mo siya ta kudos,” kagi de. ");
INSERT INTO dgc_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","“Bakit,” kagi ni Pilato, “anya i kasalanan na?” Pero lalo de san a nidulaw, a “Ipako mo siya ta kudos!” ");
INSERT INTO dgc_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Nadid, pékaisip ni Pilato a éwan siya tu mégimet, sakay adene be dén du tolay a magligalig, éy nagpaalap siya ta dinom sakay inugisan na i kamét naa ta harap du tolay. (Saya i nihalimbawa naa dide a éwan siya tu kasalanan.) “Ewanék tu kapanagutan ta ikatea na éye a lélake,” kagi na “Sikam i bahala.” ");
INSERT INTO dgc_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ey kinagi du tolay, a “Panagutan me i ikate na; sikame sakay du anak me!” ");
INSERT INTO dgc_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ey nadid, pinaluwas ni Pilato ti Barabas, sakay nipabalbal na ti Jesus, a tulos niatéd na dide monda ipako de ta kudos. ");
INSERT INTO dgc_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Nadid du sundalu, éy niange de ti Jesus ta lubuk no bile no gubernador, sakay dinumulug sa diya du étanan a sundalu. ");
INSERT INTO dgc_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Sakay inibutan de tu badu na, sakay sinolotan de siya ta badu a medideg, da saya i kolor na damit na hari. ");
INSERT INTO dgc_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Sakay nagkawekaw side ta lanot a meset, a nisoklop de to ulo na, a kurona na kan. Ey pinakbilan de siya ta kayo a baston na kan. Ey tinokso de siya a linumuhud side diya, a kinagi de, a “Mabuhay i hariae na Judeo!” ");
INSERT INTO dgc_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","a tulos de siya a linéloktaben, sakay pinépakol-pakol de siya. ");
INSERT INTO dgc_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ey kétapos de a nangloko diya, éy inibutan de tu badu na a medideg, sakay pinabaduan de man dén to sarili na a damit. Sakay pinaluwas de siya a ipako ta kudos. ");
INSERT INTO dgc_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Nadid, to péglakad de, éy mineta de tu lélake a ti Simon i ngahen na, a taga Sirene. Ey pinilit de siya a minangbékle to kudos ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ey kédemét de to lugar a ngéngahinan de a Golgota (a i kahulugen na éy Bungu), ");
INSERT INTO dgc_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","éy inatdinan de ti Jesus ta alak a te halu a gamot a meapsot, pero to pékakenam na éy éwan na ininom. ");
INSERT INTO dgc_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nadid, to péngipako de dén to kudos, éy nagpalabunutan side a hinati-hati de tu damit na. ");
INSERT INTO dgc_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Sakay négiknud sa side a bantayan de. ");
INSERT INTO dgc_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Sakay niekpét de tu sulat to kudos ta uluan naa, a ikagi no sulat tu niabla de diya. I kagi naa éy “SIYA YE TI JESUS, A HARI NA JUDEO.” ");
INSERT INTO dgc_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ey nipako de be sa i éduwa a tulisan a kasabay ni Jesus, a nitolnék de side ta magtembang a tagirilan ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Nadid, du sumésalegéd sa, éy dinédusta de ti Jesus, ");
INSERT INTO dgc_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","a kinagi de, a “Siko bale i manghukata ta Templo, sakay ipataknég mo a huway ta étélo san a aldew! Bakit éwan mo iligtas i bégi mua? Eng siko i anak na Diyos éy umogsad ka dén ta kudusa!” ");
INSERT INTO dgc_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Sakay du te tungkulin a Judeo, éy dinédusta de be siya, a kinagi de, a ");
INSERT INTO dgc_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Entan moy, niligtas na kan du iba. Pero i bégi naa éy éwan na meligtas. Hari kan siya na Israel. Nadid, éng umogsad san siya ta kudusa, éy maniwala kitam diya! ");
INSERT INTO dgc_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Umasa siya ta Diyos,” kagi de, “a kagi na a anak na kan siya. Nadid, éng gustu siya na Diyos, éy bakit éwan na siya iligtas?” ");
INSERT INTO dgc_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Sakay pati du éduwa a tulisan a kasabay na a nipako, éy dinédusta de be siya. ");
INSERT INTO dgc_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Nadid, sapul to tanghali, éy nagdiklém a hanggan to alas tres. ");
INSERT INTO dgc_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ey to manga alas tres dén, éy kinagi ni Jesus ta medegsén, a “Eli, Eli, lema sabaktani?” a i kahulugen na, éy “Diyos ko! Diyos ko! Bakit pinabayanék mo?” ");
INSERT INTO dgc_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ey du sénganya a te taknég sa, éy nabati de siya, a akala de éy dédulawan na ti Purupeta Eliyas. ");
INSERT INTO dgc_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ey agad minaginan i esa dide a nangalap ta damit, sakay nibisa na to tuba, sakay niedton na ta ontok no kayo, a nipasépsép na ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pero kinagi du iba sa, a “Diyan ka pa! Entan tam pa éng dumemét ti Eliyas a méngiligtas diya.” ");
INSERT INTO dgc_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ey nadid, dinumulaw ti Jesus a huway, a tulos na dén a nahéngsétan. ");
INSERT INTO dgc_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Nadid, tu kortina a dikél ta lubuk no Templo, éy bigla a minapéknet sapul ta ontok a hanggan ta sidung. Sakay naglindul, sakay pinomtak du dadéngli. ");
INSERT INTO dgc_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Nabukasan be i meadu a lébéng, a tulos nabuhay i meadu a tolay a minaniwala ta Diyos. ");
INSERT INTO dgc_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Linumuwas side to lébéng de, sakay to kébuhay dén ni Jesus, éy sinomdép side ta Jerusalem, éy meadu i minaketaa dide. ");
INSERT INTO dgc_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nadid, tu kapitan sakay du sundalu a kaguman na a nagbantay ni Jesus, pékabati de to lindul, sakay ta étanan a nanyari, éy néganteng side a tahod, a kinagi de, a “Tunay bale ye a anak na Diyos!” ");
INSERT INTO dgc_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Edsa be sa i meadu a bébe a mégtan-aw. Sapul pa ta Galilea éy kinumuyoyog dén side ni Jesus, a side i katulung naa. ");
INSERT INTO dgc_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Kabilang dide éy ti Maria Magdalena, sakay ti Maria a ina ni Santiago sakay ti Hose, sakay tu asawa ni Sebedeo. ");
INSERT INTO dgc_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nadid, to giapon dén, éy dinumemét sa i esa a mayaman a lakay a taga Arimatea. I ngahen na éy ti Hose. Ey alagad be siya ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Inumange siya ni Pilato a inaged na tu bangkay ni Jesus. Ey niutus ni Pilato a iatéd de diya. ");
INSERT INTO dgc_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ey inalap ni Hose tu bangkay, sakay sinaputan na to bigu a manta, ");
INSERT INTO dgc_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","sakay nielbéng na to sarili na a péglébngan, a éwan pabi nale a nipaébut to pader. Ey nadid, nigulung de tu dikél a bito a nitakléb de to pintuan no lébéng, sakay néglakad. ");
INSERT INTO dgc_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ey ti Maria Magdalena sakay tu esa pa a Maria, éy édsa sa side a te eknud to tapat no lébéng. ");
INSERT INTO dgc_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Nadid, to gagabi dén a sabadu, du mataas a padi sakay du Pariseyo, éy inumange side ni Pilato. ");
INSERT INTO dgc_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“Gubernador,” kagi de, “natandaan me tu kinagi na éya a mebuli a lélake to kébuhay na pabi, a mabuhay kan siya a huway makalipas i étélo a aldew. ");
INSERT INTO dgc_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kanya maari éy ipabantay mo pad i lébéng naa, a hanggan ta ikatélo a aldew. Makay umange sa du alagad na a takawén de tu bangkay na, sakay kagin de du tolay a nabuhay dén a huway. Eng magkona sa side, éy mas mahigpit i ménegipo a kakabulyan kesira to neditol.” ");
INSERT INTO dgc_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pékabati ni Pilato ta éya, éy kinagi na dide, a “Maari, mangalap kam ta sundalu, sakay pabantay moy dide ta mahusay.” ");
INSERT INTO dgc_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kanya nadid, inumange side to lébéng, sakay dinétonan de ta tanda tu takléb na a bito, sakay pinabantay de tu lébéng, monda masiguru de a éwan tu mékialam to bangkay ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nadid, kélipas no pangilin, a simba dén a amulaldew, éy inumange ti Maria Magdalena to lébéng, sakay tu esa a Maria. ");
INSERT INTO dgc_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ey kédemét de sa, éy bigla a linumindul ta mesibét, a tulos dinumibi i esa a anghel a gébwat ta langet. Siya éy nigulung na tu bito a takléb no lébéng, sakay inumeknud sa siya. ");
INSERT INTO dgc_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Tu idsura na éy koman i kilat a makadile, sakay tu badu na éy melélatak a tahod. ");
INSERT INTO dgc_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ey du sundalu a mégbantay sa, namégpég side ta anteng de to anghel, a tulos natumba side a koman side i pate. ");
INSERT INTO dgc_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Nadid, kinagi no anghel to éduwa a bébe, a “Diyan kam méganteng. Tukoy ko a ahayukén moy ti Jesus, siya a nipako de. ");
INSERT INTO dgc_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Pero éwan se siya,” kagi na, “da nabuhay dén a kona to kinagi na. Kamon se, entan moy i lébéng naa. ");
INSERT INTO dgc_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Sakay méglakad kam dén a kagin moy du alagad na a nabuhay dén a huway, a mégdetol dén siya dide ta Galilea. Meta moy siya ta éya. Tandaan moy i kinagi kua dikam.” ");
INSERT INTO dgc_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Nadid, pékabati du bébe ta éya a kagi no anghel, éy agad side hinumektat to lébéng. Sakay naginan side a nibaheta de du alagad i nanyaria. Ey méganteng side a mésahat. ");
INSERT INTO dgc_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","To péginan de, éy sinambat side ni Jesus, a binati na side. Ey inumadene side a kinébkében de i tikéd naa, sakay sinumamba side diya. ");
INSERT INTO dgc_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ey kinagi ni Jesus dide, a “Diyan kam méganteng. Angen moy kagin du top ko a umange side ta Galilea, éy metaék de sa.” ");
INSERT INTO dgc_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nadid, péglakad pabi du bébe, éy inumange ta banuwan du sundalu a nagbantay to lébéng, sakay nibaheta de du padi i nanyaria. ");
INSERT INTO dgc_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ey néguhon side du matétanda. Sakay inatdinan de du nagbantay ta kuhata, ");
INSERT INTO dgc_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","a kinagi de dide, a “Basta ibaheta moy du tolay a inumange sa du alagad na, a tinako de tu bangkay na to kétidug moy. ");
INSERT INTO dgc_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Diyan kam méganteng,” kagi de. “Eng mabaheta ni Gubernador a natidug kam kan, éy sikame i bahala a mégkagi diya, monda éwan na kam parusaan.” ");
INSERT INTO dgc_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Kanya du nagbantay, éy tinanggap de tu kuhata, sakay ginamet de tu nibilin de dide. Ey hanggan nadid éy saya i péniwalaa du Judeo. ");
INSERT INTO dgc_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nadid, du sapulu éy ta esa a alagad, éy inumange side ta Galilea, a hanggan to buked a nibilin dide ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ey to péketa de sa diya, éy sinumamba side diya; pero i sénganya dide éy nagalanganin side. ");
INSERT INTO dgc_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ey kinagi ni Jesus dide, a “Niatéd diyakén Nama ko i étanan a kapangyarian ta langet éy ta mundua. ");
INSERT INTO dgc_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kanya umange kam ta maski ahe ta mundua, a gemtén moy a maging alagad ko i tolay ta étanan a banubanuwan. Binyagen moy side ta ngahen Nama tam, sakay sakén a anak na, sakay ta Banal a Espiritu. ");
INSERT INTO dgc_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Itoldu moy dide i étanan a niutus ko dikam. Ey tandaan moy, sakén i kaguman moy a palagi, hanggan ta katapusan na mundua.” ");
INSERT INTO dgc_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Saye i Mahusay a Baheta a tungkul ni Jesu Cristo, a anak na Diyos. ");
INSERT INTO dgc_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","To pégtoldu ni Juan a Mégbinyag, éy saya i sapul na éya a baheta a kinumalat. Ti Juan i nangtupada to dati a kagi na Diyos to anak na, a nisulat ni Isayas. “Tandaan moy,” kagi na Diyos to anak na, “te lélake a pégdetulén ko diko, monda paghandaén na du tolay ta demtan mo.” ");
INSERT INTO dgc_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ti Juan i pinégkagiana ni Purupeta Isayas to nipégkagi na, a “Te magpahayag ta ilang a lugar, a i kagi naa du tolay éy dapat maghanda side ta kédemét na Panginoon, a husayén de be i péglakaden na.” ");
INSERT INTO dgc_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Nadid, dinumemét ti Juan ta ilang a lugar, a mégtoldu siya du tolay a dapat magsisi side ta kasalanan de, a tulos ipabinyag side, monda pagpasensiyaan side na Diyos ta kasalanan de. ");
INSERT INTO dgc_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ey du étanan a tolay ta Hudea sakay ta Jerusalem, éy inumange side ni Juan. Ey nipagtapat de i étanan a kasalanan de, a tulos bininyagen side ni Juan ta dinuma na Hordan. ");
INSERT INTO dgc_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Nadid, i badua ni Juan, éy ginamet ta buk na hayup. Sakay tu sinturon na éy katat. I kékanén na éy pésah sakay pitukan. ");
INSERT INTO dgc_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","To pégtoldu na du tolay, éy kinagi na, a “Te lélake a ménegipo diyakén a dumemét. Eng iparehoék moy diya,” kagi na, “éy éwanék tu pasa, da mataas siya diyakén. ");
INSERT INTO dgc_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Sakén éy binyagen ta kam ta dinom. Pero siya éy binyagen na kam ta Banal a Espiritu.” ");
INSERT INTO dgc_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Nadid, to panahun a éya, éy dinumemét ti Jesus a gébwat ta Nasaret, Galilea; éy bininyagen siya ni Juan ta dinom ta Hordan. ");
INSERT INTO dgc_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ey to kéahawas ni Jesus to dinom, éy neta na a minapilak i langet, a tulos dinumibi diya i Espiritu na Diyos a koman i dagalan. ");
INSERT INTO dgc_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ey tulos négkagi nadid i boses ta langet, a “Siko i anak ko a mahal, éy mésayaék diko.” ");
INSERT INTO dgc_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Nadid, tu Espiritu, éy niange na ti Jesus ta ilang a lugar. ");
INSERT INTO dgc_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ey édsa sa siya ta épat a pulu a aldew, a tétokson siya ni Satanas ta éya. Ey te hayup be sa a mealiyas. Ey inaguman siya du anghel ta éya. ");
INSERT INTO dgc_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Nadid, to péngipihesu de ni Juan, éy nagsoli ti Jesus ta Galilea. Ey nagpahayag siya ta Mahusay a Baheta na Diyos ta éya. ");
INSERT INTO dgc_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Oras dén na Diyos a maghari,” kagi na. “Magsisi kam dén, a ibutan moy du kasalanan moy, sakay maniwala kam ta Mahusay a Baheta.” ");
INSERT INTO dgc_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Nadid, to péglakad ni Jesus to digdig na diget na Galilea, éy neta na de Simon a patwadi ti Andres, a ménggila side. ");
INSERT INTO dgc_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ey kinagi na dide, a “Kumuyoyog kam diyakén a maging alagad ko. Sapul nadid, éy éwan kam dén mangalap ta ikan, éng éwan i alapén moya éy tolay a para diyakén.” ");
INSERT INTO dgc_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ey pékabati du éduwa ta éya, éy basta gininanan de tu gila de, a kinumuyog side ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ey to pémaybay de man dén ta kétihék, éy neta de de Santiago éy ti Juan a patwadi, a anak side ni Sebedeo. Te eknud side to abeng de, a mégayoma side to rambat de. ");
INSERT INTO dgc_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ey dinulawan side ni Jesus; éy agad gininanan de tama de to abeng, sakay du iba sa a mégtarabaho, a kinumuyog be side ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Nadid, inumange side ta Kapernaum. Ey to aldew a pangilin, éy inumange ti Jesus to kapilya de ta éya. Ey nagtoldu siya du tolay sa. ");
INSERT INTO dgc_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ey du tolay, éy mégpégtaka side a tahod to pégtoldu na, da éwan siya mégtoldu a kona du maistu ta rilihiyon de, éngˈwan neta de a te kapangyarian siya ta pégtoldu na. ");
INSERT INTO dgc_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nadid, sinomdép to kapilya i esa a lélake a hinayup. Dinumulaw siya a négkagi, a ");
INSERT INTO dgc_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Jesus, siko a taga Nasaret, anya i pékialam mua dikame? Bunuén mo kame wade a manga hayup? Natenggi ta ka a siko i tiniyak na Diyos a tagapagligtas!” ");
INSERT INTO dgc_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ey ti Jesus, éy sinaway na tu hayup, a kinagi na, a “Tama dén! Umibut ka dén ta ina a lélake!” ");
INSERT INTO dgc_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nadid tu medukés a hayup, pékabati na ta éya, éy pinagkaramre na tu lélake. Ey nagkélanget siya, a tulos inumibut dén to lélake. ");
INSERT INTO dgc_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ey du tolay sa, éy mégpégtaka side, a kinagi de, a “Anya wade i lélakeae? Iba i pégtoldu naa. Utus na san, éy sumunud du medukés a hayup diya!” ");
INSERT INTO dgc_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ey dahil ta éya, éy nabaheta agad du étanan a tolay ta éya a lugar i tungkul ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nadid, hinumektat ti Jesus to kapilya, a inumange siya to bile de Simon a patwadi, a kaguman na be ti Santiago sakay ti Juan. ");
INSERT INTO dgc_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ey tu manugeng ni Simon éy te katidug sa siya, a mepalang siya to ladu na. Ey kinagi de ni Jesus a méladu siya. ");
INSERT INTO dgc_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ey kembilan ni Jesus tu kamét na a pinaégkat, éy naibut tu palang na, a tulos nagasikaso siya dide. ");
INSERT INTO dgc_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Nadid, to kélép a éya, a giapon dén, éy niange de ni Jesus i étanan a te ladu, sakay du hinayup. ");
INSERT INTO dgc_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ey du étanan a tolay ta éya a banuwan, éy dinumulug side ta harap na éya a bile. ");
INSERT INTO dgc_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ey pinahusay ni Jesus i meadu a te ladu, sakay pinaibut na i meadu a dimonyo. Ey sinaway na du dimonyo a mégkagi, da tukoy de siya, a siya i gébwata ta Diyos. ");
INSERT INTO dgc_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Nadid, to gagabi pabi a tahod, a mediklém pabi, éy inumikat ti Jesus a linumwas to bile. Ey inumadeyo siya dudu bile sa, a monda manalangin. ");
INSERT INTO dgc_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Pero de Simon éy tinumagubet side diya, a inahayok de siya. ");
INSERT INTO dgc_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ey péketa de diya éy kinagi de, a “Maistu, éahayukén ka man dén du tolay a étanan.” ");
INSERT INTO dgc_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Pero kinagi ni Jesus dide, a “Kitam dén. Umange kitam du iba a bariyo. Kanyaék se inumange éy magpahayagék be du tolay ta iba-iba a bariyo.” ");
INSERT INTO dgc_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Kanya naglebut ti Jesus ta étanan a Galilea, a nagtoldu siya du tolay du kapilya de, sakay pinaibut na i meadu a dimonyo. ");
INSERT INTO dgc_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Nadid, te esa a lélake a te saket a ketong a inumadene ni Jesus. Linumuhud siya diya a mékiohon. “Eng maari,” kagi na, “éy pahusayénék pad.” ");
INSERT INTO dgc_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ey ti Jesus, éy kinagbian na siya, éy kembilan na, a kinagi na, a “Maari, maghusay ka dén.” ");
INSERT INTO dgc_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ey to pégkagi na ta éya, éy bigla a naibut tu ladu na, a mahusay dén siya. ");
INSERT INTO dgc_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ey pinéglakad siya ni Jesus, a kinagi na diya ta mahigpit, ");
INSERT INTO dgc_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","a “Diyan mo kékagin i éye ta maski ti ésiya; éngˈwan umange ka pa pumeta ta padi, a mahusay ka dén. Da mahusay ka dén,” kagi na, “éy atdinan mo tu padi ta péngiatang na diko, a kona to niutus ni Moises. Saya i pagpatunay mua ta tolay a mahusay ka dén.” ");
INSERT INTO dgc_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pero tu lélake, to péglakad na dén, éy basta binébahetaan na i bawat meta na ta nanyaria diya, hanggan éwan nabaheta na étanan a tolay ta éya a lugar. Kanya ti Jesus éy éwan dén siya maari a pumeta ta tolay maski ta ahe a banuwan. Basta tumétulos siya ta adeyo ta banuwan. Pero maski adeyo siya, éy palagi a dumédulug diya i meadu a tolay. ");
INSERT INTO dgc_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","To esa man dén a aldew, éy nagsoli ti Jesus ta Kapernaum. Ey nabaheta du tolay a kaya man dén siya to bile na. ");
INSERT INTO dgc_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ey dinumulug i meaadu a tolay to bile, a hanggan da mepiit side. Maski ta harap no bile, éy mepiit. Ey mégtoldu ti Jesus dide. ");
INSERT INTO dgc_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nadid, te épat a tolay a dinumemét sa, a te kébil side a lélake a lumpu. ");
INSERT INTO dgc_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pero éwan side makaadene ni Jesus, dahil ta meaadu a tolay. Kanya binutbut de to atép to némo ni Jesus, sakay nitostos de tu ayod a édsean no lumpu. ");
INSERT INTO dgc_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ey ti Jesus, péketa na a méniwala side diya, éy kinagi na to lumpu, a “Anéng, pinatawad ka dén ta kasalanan mo.” ");
INSERT INTO dgc_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Nadid, du maistu sa ta rilihiyon, pékabati de to kinagi ni Jesus, éy mégisip side, a ");
INSERT INTO dgc_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Bakit mégkagi siya ta kona sa? Isip na wade a Diyos siya! Diyos san i makapagpatawad ta kasalanan na tolay.” ");
INSERT INTO dgc_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ey ti Jesus, éy tukoy na dén i édse ta isip dia. Ey kinagi na dide, a “Bakit mégisip kam ta kona sina? ");
INSERT INTO dgc_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Tama,” kagi na, “a maari i maski ti ésiya a mégwari-wari a mégpatawad ta kasalanan na lumpuae. Pero ti ésiya i maari a makapagpalakad ta lumpu a tolay? ");
INSERT INTO dgc_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nadid,” kagi na, “éy sakén i lélake a gébwat ta langet. Ey patunayan ko dikam a te kapangyarianék a magpatawad ta kasalanan, a péglakadén ko i lumpuae.” Nadid, kinagi ni Jesus to lumpu, a ");
INSERT INTO dgc_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nay, umégkat ka dén, a alapén mo dén i ayod mua, a ikad mo dén ta bile moy.” ");
INSERT INTO dgc_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Nadid, pékabati no lumpu ta éya, éy inumégkat dén siya, a inalap na tu ayod na, sakay linumuwas siya to bile. Ey du tolay sa, péketa de ta éya, éy mégtaka side a tahod, sakay pinuri de i Diyos. Sakay kinagi de a “Nadid kitam san naketa ta kona sa!” ");
INSERT INTO dgc_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Nadid, nagsoli man dén ti Jesus ta sabeng ta Galilea. Ey dinumulug diya i meadu a tolay, éy nagtoldu siya dide. ");
INSERT INTO dgc_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ey to péglakad na, éy neta na i esa a lélake a mégpabuwes, a te eknud to pégsingihan ta buwes. Ti Lebi i ngahen naa, a anak ni Alpeyo. Ey kinagi ni Jesus diya, a “Kumuyog ka diyakén a maging alagad ko.” Ey tinumaknég ti Lebi, a inumunonod siya ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Nadid, to péngan ni Jesus to bile ni Lebi, éy nékidipon be sa i meadu a medukés a tolay sakay du mégpabuwes. (Side i méngdaya ta tolay.) Dahilan éy te meadu a kumékuyoyog ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ey du maistu sa ta rilihiyon na Pariseyo, péketa de a mékidipon ti Jesus du medukés a tolay, éy kinagi de du alagad ni Jesus, a “Bakit mékidipon siya du makasalanan a tolay?” ");
INSERT INTO dgc_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ey ti Jesus, pékabati na dide, éy kinagi na dide, a “Bakit? Du mahusay éy éwan side tu kailangan ta magamot, éngˈwan du te saket. Ey sakén éy éwanék se inumange a monda tumulung du mahusay a tolay. Engˈwan, du makasalanan i tulungan kua.” ");
INSERT INTO dgc_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nadid, du Pariseyo sakay tu alagad ni Juan, éy ugali de a mégkulasiyon, ayun to rilihiyon de. Kanya te iba a tolay a nagpakelagip ni Jesus éng bakit éwan be mégkulasiyon du alagad na. “Eng mégkulasiyon du alagad du Pariseyo, sakay du alagad ni Juan a mégbinyag,” kagi de, “éy bakit éwan mégkulasiyon du alagad mo?” ");
INSERT INTO dgc_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ey kinagi ni Jesus dide, a “Ataay, maari beman a mégkulasiyon i tolay éng kaguman de pabi i ikasal? Ewan! Eng kaguman de pabi siya, éy éwan pabi side mégkulasiyon, da mésaya side. ");
INSERT INTO dgc_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Bagay éwan dén sa tu kadimoy de a ikasal, éy saya i oras de a magkulasiyon. ");
INSERT INTO dgc_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Ewan tu nagtagpi ta bigu a resato to dati dén a badu,” kagi ni Jesus. “Da éng kona sa, éy péknetén no bigu tu dati, éy lalo dén a melawa tu ébut no badu. ");
INSERT INTO dgc_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ewan be tu méngiasék ta bigu a alak ta dati a pégaskanan. Bagay kona sa i ginamet, éy pomtak tu pégaskanan, da dati, a tulos mebut tu alak. Sakay pati tu pégaskanan, éy sayang be dén. Maigi pa éy iasék i bigu a alak ta bigu be a pégaskanan.” ");
INSERT INTO dgc_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Nadid, to esa a aldew a pangilin, éy dinumiman de Jesus to kapahayan. Ey to péglakad de, éy nagkétoh du alagad na ta tégesa a ohay, a kékéselén de. ");
INSERT INTO dgc_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ey du Pariseyo, éy kinagi de ni Jesus, a “Entan mo du alagad mo! Bakit gemtén de i bawal ta pangilin? Bilang tarabaho ina!” ");
INSERT INTO dgc_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","“Ewan,” kagi ni Jesus. “Bakit, éwan moy wade nabasa tu ginimet ni Dabid to araw, to pégalép de sakay du kaguman na? ");
INSERT INTO dgc_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Basta sinomdép siya to bile na Diyos. Ey tu te déton sa a tinapay a para ta Diyos, éy kinan na; sakay pinakan na be du kaguman na. Ey bawal kan ya ta utus, da du padi san i maari kana a méngan ta éya. Nanyari ya to panahun ni Abiyatar, to panahun a padi siya a mataas. ");
INSERT INTO dgc_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Tandaan moy,” kagi ni Jesus, “lalo a importante i tolay kesira ta pangilin a aldew. Kanya san ginimet na Diyos i pangilin éy monda makaimang i tolay ta tarabaho de. ");
INSERT INTO dgc_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ey sakén a lélake a gébwat ta langet, éy sakén i mégkagia éng anya i tama a gimet ta aldew a pangilin.” ");
INSERT INTO dgc_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","2","Nadid, éy inumange ti Jesus to kapilya de a esa. Ey te lélake sa a pile tu kamét. Ey du Judeo sa, éy sinubukan de siya, éng gamutén na tu lélake ta pangilin, monda maka éy iabla de siya a manglabag ta utus. ");
INSERT INTO dgc_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ey ti Jesus, éy kinagi na to pile tu kamét, a “Kadon se.” ");
INSERT INTO dgc_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ey kinagi na du mégsubuk diya, a “Anya, bawal beman ta utus tam éng aguman tam i te hirap ta pangilin? Isip ko bawal san éng pahirapan tam i tolay?” Ey du mégsubuk diya, éy éwan side sinumengbet diya. ");
INSERT INTO dgc_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ey ti Jesus éy lélamengén na side, a mégingél siya dide. Ey mélungkut be siya dide, da mekétog side tu isip. Ey kinagi na nadid to pile tu kamét, a “Iolnat mo i kamét mua.” Ey to péngiolnat na éy naghusay dén. ");
INSERT INTO dgc_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ey du Pariseyo sa a nagsubuk diya, éy linumwas sa side; sakay néguhunan de éng kodya i pamunu dia ni Jesus. Ey kaguman de be du tolay ni Herod. ");
INSERT INTO dgc_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Nadid, pékatukoy ni Jesus ta hangad dia, éy hinumektat sa siya a inumange ta sabeng. Ey kaguman na du alagad na. Ey meadu i tinumagubet diya, a gébwat side ta Galilea, sakay ta Hudea, ");
INSERT INTO dgc_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","sakay ta Jersualem, sakay ta Idumea, sakay ta dumanég a sa na Hordan, sakay ta Tiro, sakay ta Sidon. Kanya dinumulug diya diden ya a tolay, éy dahilan éy nabaheta de i ginimet naa. ");
INSERT INTO dgc_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Ginamot na i meaadu a tolay a te sakisaket. Kanya du te ladu, éy pumépilit side a umadene diya, monda makakbil side diya. Kanya ti Jesus éy nipedahik na tu abeng a sinakayan na. Dinumitaw siya ta kétihék, monda éwan siya sésélditén na tolay. ");
INSERT INTO dgc_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Sakay du hinayup a tolay, bagay meta de ti Jesus éy basta minatumba side ta harap na, a dinumulaw side, a i kinagi dia, éy “Siko i anaka na Diyos.” ");
INSERT INTO dgc_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ey ti Jesus éy pinégkagian na side ta mahigpit, a diyan de iyébaheta i tungkul diya. Na a Labindalawa ");
INSERT INTO dgc_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Nadid, pénohobuk ni Jesus to esa a buked, éy pinauwet na du tolay a gustu na a maging alagad na. Ey kédemét de diya, ");
INSERT INTO dgc_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","éy pinili na i labindalawa, a side i kaguman na. I pégdulaw naa dide éy apostol. Side i utusan na a uméange ta iba-iba a lugar, a magpahayag ta Diyos. ");
INSERT INTO dgc_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ey inatdinan na side ta kapangyarian de a magpaibut ta dimonyo. ");
INSERT INTO dgc_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Du labindalawa a apostol a pinili na éy ti Simon, a pinalayawan na a Pedro; ");
INSERT INTO dgc_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","sakay ti Santiago éy ti Juan, a anak side ni Sebedeo. (Pinalayawan side ni Jesus, a Boanerges, a i kahulugen na éy koman i kéduh.) ");
INSERT INTO dgc_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Du iba a apostol éy ti Andres, sakay ti Pelip, sakay ti Bartolome, sakay ti Mateo, sakay ti Tomas, sakay ti Santiago a anak ni Alpeo, sakay ti Tadeo, sakay ti Simon a taga Kanan, ");
INSERT INTO dgc_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","sakay ti Hudas Iskarote, a néngitokyon ni Jesus. I Kapangyarian Na Ni Satanas ");
INSERT INTO dgc_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Nadid, nagsoli ti Jesus to bile na. Ey dinumulug man dén diya i meaadu a tolay. Ewan side maari a méngan, dahil ta kakadu na tolay. ");
INSERT INTO dgc_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ey du tétotop ni Jesus, pékabati de a te meaadu a dumédulug diya, éy inumange side diya a uwitén, da isip de éng luku-luku dén siya. ");
INSERT INTO dgc_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Pero du maistu ta rilihiyon ta éya, a gébwat ta Jerusalem, éy kinagi de, a “Kanya makapégpaibut siya du dimonyo éy inatdinan siya ni Satanas ta kapangyarian na. Ti Satanas a mayor du dimonyo.” ");
INSERT INTO dgc_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Kanya kinagi ni Jesus dide i halimbawa. “Pakodyan a lébugén ni Satanas i sarili na?” kagi na. ");
INSERT INTO dgc_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","“Eng mara, maski ahe a banuwan, éng néglébug side éy masida side a talaga. ");
INSERT INTO dgc_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Sakay maski ahe a bile, éng néglébug side, éy éwan male i buhay dia. ");
INSERT INTO dgc_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ey nadid sakén, bakit kagi moy a inatdinanék kan ni Satanas ta kapangyarian na a magpaibut du katulung na a dimonyo? Eng lébugén ni Satanas i sarili na, éy bumagsak siya a talaga. Ewan male i buhay na. ");
INSERT INTO dgc_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Ewan tu makapagpaibut du kasakupan ni Satanas, éngˈwan na pa matalo ti Satanas. Pero éng matalo na dén siya, éy maari na dén a alapén i kasakupan na. ");
INSERT INTO dgc_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Tandaan moy,” kagi ni Jesus, “pagpasensiyaan na Diyos i tolay ta maski anya a kasalanan de, sakay ta péngupos de ta tolay. ");
INSERT INTO dgc_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pero tu mangupos ta Banal a Espiritu, éy saya i éwana pagpasensiyaan, maski nadid, a hanggan nikésiya. I kona sa éy te kasalanan a pirmi, a éwan maibut.” ");
INSERT INTO dgc_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Kinagi ni Jesus i éya da nangupos side diya, a te medukés kan siya a espiritu. ");
INSERT INTO dgc_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Nadid, éy dinumemét sa tu ina ni Jesus, sakay du tétotop na. Naguhay side ta luwas no bile, a nipauwet de siya. ");
INSERT INTO dgc_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ey du meadu a tolay a te eknud ta palebut ni Jesus to lubuk, éy kinagi di diya, a “Kéye dén ta luwas dena mo, éy du tétotop mo, a nipauwet de ka.” ");
INSERT INTO dgc_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ey kinagi ni Jesus, a “Ti ésiya i ina kua sakay ta tétotop kua?” ");
INSERT INTO dgc_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ey kélameng ni Jesus du tolay ta palebut na, éy kinagi na, a “Side ye di ina kua, sakay top ko! ");
INSERT INTO dgc_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","I maski ti ésiya a mangtupad ta utus Nama ko, éy side ya di ina kua éy ta tétotop ko.” ");
INSERT INTO dgc_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Nadid, inumange man dén ti Jesus to digdig no diget. Ey meaadu i dinumuluga diya, a hanggan da sinumakay ti Jesus to abeng, sakay dinumitaw ta kétihék, sakay inumeknud sa siya a mégtoldu du tolay. Ey side éy édse side to baybay, a mégbati. ");
INSERT INTO dgc_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ey tinolduan na side ta meadu a halimbawa. ");
INSERT INTO dgc_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Baten moy,” kagi na. “Te esa kan a lélake a mégsabug to binhi na. ");
INSERT INTO dgc_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ey to pégsabug na éy te sénganya wade a butil a minepégsek to dilan. Ey kinan na manok. ");
INSERT INTO dgc_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ey te sénganya wade be a nepégsek to bito-bito. Ey agad kan side nagtubu, da melapis i luta ta éya. ");
INSERT INTO dgc_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pero minalanés side, da mepasi i bilag, éy éwan kan masiyadu i gimot de. ");
INSERT INTO dgc_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ey te sénganya wade be a nepégsek to kalamonan, éy éwan kan be nagbunga, da nailongan na lamon. ");
INSERT INTO dgc_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ey tu iba a binhi, éy nesabug kan dén ta mahusay a luta. Ey tinumubu i éya, a nagohay ta tégtétélo a pulu a butil, sakay ta tégéném a pulu, sakay ta tégsésandaan a butil i bawat ohay. ");
INSERT INTO dgc_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ey nadid,” kagi ni Jesus, “éng makabati kam, éy baten moy ya.” ");
INSERT INTO dgc_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Nadid, to kéhektat dén du meadu a tolay, éy du alagad na éy nipakelagip de ni Jesus ayun to nihalimbawa na du tolay. ");
INSERT INTO dgc_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ey kinagi ni Jesus dide, a “Ipeta san dikam na Diyos i kahulugen na lihim tungkul ta péghari na ta tolay. Pero du tolay a éwan sakup na kaharian na Diyos, éy halimbawa san i kékagin kua dide, ");
INSERT INTO dgc_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","monda maski metaék de, sakay mégbati side diyakén, éy éwan de mapospusan. Da sala de a magsoli ta Diyos, a monda pagpasensiyaan na side.” Tungkul To Pégsabug ");
INSERT INTO dgc_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","“Bakit,” kagi ni Jesus, “éwan moy beman mépospusan i kahulugen na éya a halimbawa? Eng kona sa, éy kodya i pékapospos moya du iba a halimbawa? ");
INSERT INTO dgc_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mara, tu nisabug no lélake éy éwan binhi, éngˈwan kagi na Diyos. ");
INSERT INTO dgc_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","I sénganya a tolay éy koman side tu binhi a minepégsek to dilan, to pégsabug no lélake ta kagi na Diyos. Eng makabati side, éy dinumemét agad ti Satanas dide, a inagaw na tu kagi a nabati de. ");
INSERT INTO dgc_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","I iba a tolay éy koman side tu binhi a nepégsek to bito-bito. Side, éng mabati de i kagi na Diyos, éy masaya side, a tanggapén de agad. ");
INSERT INTO dgc_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pero éwan side makatagal, da kapareho side no binhi a éwan nakagimot. Méniwala side ta sandali. Pero kédemét na paghirap de dahil ta péniwala de, éy basta ginanan de tu tinanggap de. ");
INSERT INTO dgc_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","I iba a tolay éy koman side tu binhi a nepégsek to kalamonan. Makabati side ta kagi na Diyos; ");
INSERT INTO dgc_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","pero éwan magbunga tu kagi na Diyos ta isip dia, da kapareho side no binhi a nailongan. Mara i nangilonga dide éy tu pégisip de ta kabuhayan de sakay ta kayamanan de, sakay ta pénggustu dia ta sari-sari. Kanya éwan side mégbunga. ");
INSERT INTO dgc_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Pero i iba a tolay, éy koman side tu binhi a minesabug ta mahusay a luta. Eng makabati side ta kagi na Diyos, éy tanggapén de. Ey magbunga side ta tégétélo a pulu, sakay ta tégéném a pulu, sakay ta tégsésandaan.” ");
INSERT INTO dgc_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","“Anya wade,” kagi ni Jesus, “taben na tolay i simbu, a monda tulos taklében de ta pégtakalan? O isahok de beman ta kama? Ewan, da iedton de ta lamesa. ");
INSERT INTO dgc_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ey maski anya a meliso nadid, éy mademlagen ta esa a panahun. Sakay maski anya i ilihim na tolay nadid, éy mehayag ta esa a panahun. ");
INSERT INTO dgc_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nadid,” kagi ni Jesus, “éng makabati kam, éy baten moy ya. ");
INSERT INTO dgc_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","“Nadid,” kagi na, “isipén moy tu kagi ko dikam. Da pintasan kam na Diyos ayun ta pégpintas moy ta kapareho moy. Sakay lalo a mahigpit i pégpintas na Diyos dikam. ");
INSERT INTO dgc_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Dahilan side a mégéisipén ta itoldu kua, éy dagdagen na Diyos i isip dia, monda mapospusan de ta mahusay. Pero du metamad a mégisip ta itoldu kua, éy bawasan na Diyos tu isip de a hanggan éwan side tu mapospusan.” ");
INSERT INTO dgc_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Nadid, kinagi ni Jesus, a “I péghari na Diyos éy kapareho no lélake a naghasik ta binhi to luta na. ");
INSERT INTO dgc_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ey tidug siya ta kélép-kélép; umikat siya ta aldew-aldew. Ey tulos san a tumétubu tu nihasik na. Pero éwan mépospusan no lélake éng anya i mégpatubua to nihasik na. ");
INSERT INTO dgc_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Basta luta san i mégpatubua. Tulos a nagtagatod. Tulos a nagbuktet. Tulos a mégwasawas. ");
INSERT INTO dgc_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ey bagay nalutu dén tu pahay, éy tulos mégladey dén tu lélake, da oras dén a mégladey.” ");
INSERT INTO dgc_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","“Nadid,” kagi ni Jesus, “anya wade i kapareho na péghari na Diyos? Anya wade i halimbawaa na éya? ");
INSERT INTO dgc_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","I kaparehua na éya éy tu isesa a bukél na mustasa a nimula no lélake to luta. Kakétihékan ya ta maski anya a bukél ta mundua. Pero éng imula mo, ");
INSERT INTO dgc_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","éy kadikélan ya ta étanan a kayo, a huméhabéng ta meadu, a hanggan makapaglobun du manok ta lédum naa.” ");
INSERT INTO dgc_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Kona sa i pégtoldu ni Jesus du tolay, a gamitén na i meadu a halimbawa, ayun ta kaya de a mapospusan. ");
INSERT INTO dgc_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ewan siya tu kinagi dide a éwan halimbawa. Pero éng bukod de Jesus, a du alagad na san i kaguman naa, éy nipaliwanag na dide i étanan a kahulugen no kinagi na du tolay. ");
INSERT INTO dgc_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nadid, giapon dén na éya a aldew, éy kinagi ni Jesus du alagad na, a “Umahabes kitam dén ta dibilew.” ");
INSERT INTO dgc_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ey sinumakay dén side to abeng a te sakay dén ti Jesus, sakay gininanan de dén du tolay. Ey te iba be sa a abeng, a inumunonod dide. ");
INSERT INTO dgc_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Mamaya-maya, éy inabut side na mesibét a unos, a tulos sésalpukén na tagmék tu abeng, a hanggan da talaga a matabwan dén tu abeng. ");
INSERT INTO dgc_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ey ti Jesus éy tidug pabi siya to dipos, a te punganan siya. Ey linukag siya du alagad na, a kinagi de, a “Maistu, diyan mo kame pébayan! Omléd kitam dén!” ");
INSERT INTO dgc_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ey ti Jesus éy inumégkat siya, a tulos sinaway na tu pahés, sakay kinagi na to pahés, a “Tama dén, tumahimik ka dén.” Ey hinumintu dén tu pahés, sakay tinumahimik dén tu diget. ");
INSERT INTO dgc_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ey kinagi na du alagad na, a “Bakit inumanteng kam? Ewan kam wade pabi méniwala diyakén?” ");
INSERT INTO dgc_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ey nagtaka du alagad, a kinagi de, a “Anya wade i lélakeae? Maski pahés éy ta diget, éy méniwala side diya!” ");
INSERT INTO dgc_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Nadid, dinumemét de Jesus ta banuwan na tolay a Gadareno ta dibilew. ");
INSERT INTO dgc_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ey to kéahawas de to abeng, éy sinambat side no esa a lélake a hinayup, a gébwat to kapusanto. ");
INSERT INTO dgc_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Siya éy nale a négiyan to kapusanto. Ey éwan dén tu maari a méngiegut diya. Maski kadena éy éwan maari, ");
INSERT INTO dgc_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","da ginapus de dén siya ta meadu a beses ta kadena sakay bangkiling. Pero tu kadena éy binabégsot na, sakay tu bangkiling éy tinétéltég na san. Ey éwan tu tolay a makagipos diya. ");
INSERT INTO dgc_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Aldo éy ta kélép éy basta méglélebutén siya to lébélbéng sakay du bukibuked, a mégkékélesén siya, sakay tinétalinguan na i bégi naa ta bito. ");
INSERT INTO dgc_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nadid, pékatan-aw na ni Jesus, éy naginan siya a linumuhud diya, ");
INSERT INTO dgc_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","sakay dinumulaw ta mebagség, a kinagi na, a “Anya i pékialam mua diyakén, Jesus? Siko i anak na mataas a Diyos! Diyanék pad péparusaan!” ");
INSERT INTO dgc_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Kinagi na dén i éya, da inutusan dén ni Jesus tu medukés a espiritu a umibut dén to lélake. ");
INSERT INTO dgc_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ey kinagi ni Jesus diya, a “Ti ésiya i ngahen mua?” “Ti keaduan,” kagi na, “i ngahen kua; da meadu kame.” ");
INSERT INTO dgc_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ey dinumaying siya ni Jesus, a “Diyan pad iyébut didi hayupa ta adeyo.” ");
INSERT INTO dgc_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Nadid, te meadu sa a babuy a mégkan ta disat no buked ta éya. ");
INSERT INTO dgc_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ey du dimonyo a édse to lélake, éy pinékiohon de ni Jesus, a “Iagton mo kame san ta bégi didi babuy yae, a pasdépén mo kame dide.” ");
INSERT INTO dgc_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ey pinumayag dén ti Jesus. Kanya du dimonyo éy inumibut side to lélake, a tulos sinomdép side du babuy. Ey bigla a minagpaginan du babuy a bulnok, a sinumegbu side a étanan to diget, a tulos de a minalimés. Manga éduwa side a libu a babuy. ");
INSERT INTO dgc_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nadid, du mégbantay du babuy, éy ginuminan dén side. Ey nibébaheta de du étanan to banuwan de. Ey du tolay, éy inumange side ni Jesus, monda meta de éng anya i nanyaria. ");
INSERT INTO dgc_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ey kédemét de ni Jesus, éy neta de tu lélake a hinayup, a te eknud dén siya, a mahusay dén. Sakay te badu dén siya. Ey inumanteng du tolay. ");
INSERT INTO dgc_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ey du tolay a minaketa ta éya a nanyari, éy nibaheta de du iba i tungkul to lélake, sakay du babuy. ");
INSERT INTO dgc_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ey nipékiohon de ni Jesus a humektat siya to lugar de. ");
INSERT INTO dgc_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Nadid, pékasakay ni Jesus to abeng de, éy tu lélake a ginamot na, éy nékiohon siya ni Jesus éng maari siya a kumuyog. ");
INSERT INTO dgc_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pero sinaway ni Jesus. “Sumoli ka san nadid ta bile moy,” kagi na, “sakay ikagi mo dide i ginimet na Diyos diko, éng kodya i nipangagbi naa diko.” ");
INSERT INTO dgc_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Kanya tu lélake, éy nagsoli siya, a inumange siya ta Dekapolis, sakay nibaheta na du tolay éng anya i ginimita ni Jesus diya. Ey mégtaka du étanan a nakabati. ");
INSERT INTO dgc_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Nadid, to kéahabes de Jesus to kinagébwatan de, éy sinambat man dén siya na meadu a tolay to édse na pabi ta sabeng. ");
INSERT INTO dgc_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ey inumadene diya i esa a Judeo, a ti Hayro i ngahen naa. Siya tu tagapamahala to kapilya ta éya. Ey péketa na ni Jesus éy dinumapa siya ta harap na, ");
INSERT INTO dgc_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","a dinumaying diya. “Adene a mate tu anak ko,” kagi na. “Umange ka pad a itupu mo i kamét mua diya, monda maghusay siya, monda éwan siya mate.” ");
INSERT INTO dgc_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ey kinumuyog ti Jesus diya. Ey te meaadu be a tolay a kinumuyog be, a hanggan da mepiit side ta palebut ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","To péglakad de éy kaunonod ni Jesus i esa a bébe a te saket. Labindalawa dén a taon siya a mégdédigién. ");
INSERT INTO dgc_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nagpagamot siya ta meadu a doktor, a hanggan da ginasta na dén tu kuhata na a étanan. Pero éwan siya nagamot, éngˈwan lumélalo san tu saket na. ");
INSERT INTO dgc_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","To pékabaheta na ni Jesus, éy kinagi na to isip na, a “Eng makbilan ko san i damit naa, éy maghusayék dén.” Kanya inumadene siya to adég ni Jesus, ");
INSERT INTO dgc_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","sakay kembilan na tu badu na, éy basta naghusay siya agad. Ey nabati na a nagamot dén i bégi naa. ");
INSERT INTO dgc_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Pero ti Jesus, agad na naramdaman a te nagkébil diya, a tulos nagamot. Kanya sinumuleg siya, sakay kinagi na du tolay, a “Ti ésiya i minangkébila ta badu kuae?” ");
INSERT INTO dgc_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ey du alagad na, éy kinagi de diya, a “Bakit, Maistu, ipakelagip mo ya? Meséldit-séldit kitam didi tolayae! Meadu i méngkébil diko!” ");
INSERT INTO dgc_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ey linameng ni Jesus du tolay, éng ti ésiya i nangkébil diya. ");
INSERT INTO dgc_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ey tu bébe, pékabati na a naghusay dén siya, éy inumanteng siya a tahod. Tulos tinumokém siya to tikéd ni Jesus, sakay kinagi na diya i buu a katutuhanan. ");
INSERT INTO dgc_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","“Anéng,” kagi ni Jesus, “diyan ka méganteng. Pinahusay ka dén na péniwala mo diyakén. Ikad mo dén. Mahusay ka dén.” ");
INSERT INTO dgc_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Nadid, mégkagi pabi ti Jesus to bébe, éy te dinumemét a gébwat to bile no mataas a Judeo, a kinagi de diya, a “Minate dén tu anak mo. Diyan mo dén abalaén i maistua.” ");
INSERT INTO dgc_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Pero ti Jesus, pékabati na to kinagi de to mataas a Judeo, éy kinagi na diya, a “Diyan ka méganteng. Umasa ka san diyakén” ");
INSERT INTO dgc_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ey sinaway ni Jesus du iba a kumuyog dide. Basta ti Pedro san i kaguman na, sakay de Santiago a patwadi, sakay tu mataas a Judeo. ");
INSERT INTO dgc_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nadid, kédemét de to bile no mataas a Judeo, éy neta ni Jesus a méligalig du tolay sa, a mégpégsanget side. ");
INSERT INTO dgc_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ey sinomdép siya, a kinagi na dide, a “Bakit méligalig kam a mégpégsanget? Ewan minate i anaka. Natidug san siya.” ");
INSERT INTO dgc_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ey du tolay sa, éy pinégngihitan de san ti Jesus. Ey ti Jesus, éy pinaluwas na side to bile. Basta i kaguman na sana to lubuk éy tu ina no anak, sakay tu ama na, sakay tu alagad na a étélo. Sakay sinomdép side to kuwarto no anak, ");
INSERT INTO dgc_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","sakay kembilan ni Jesus tu kamét na, sakay kinagi na diya, a “Anéng, umégkat ka dén.” ");
INSERT INTO dgc_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ey tu anak, éy inumégkat siya agad, sakay tulos siya a méglakad. I idad na sana éy sapulu éy ta éduwa a taon. Ey du tolay sa, éy mégpégtaka side a tahod. ");
INSERT INTO dgc_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ey nibilin dide ni Jesus ta mahigpit, a diyan de iyébaheta ta maski ti ésiya i nanyaria. Sakay inutusan na be side a mégpakan to anak. ");
INSERT INTO dgc_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Nadid, hinumektat sa ti Jesus, a nagsoli siya to sarili na a banuwan. Ey kinumuyog du alagad na. ");
INSERT INTO dgc_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ey to pangilin a aldew, éy nagtoldu siya du tolay to kapilya sa. Ey du meadu a nakabati diya, éy nagtaka side. “Ahe i nangalapana na éya a lélake ta éya a pégtoldu na?” kagi de. “Ahe i gébwat na karunungan naa? Kodya i pékagimet naa ta makataka-taka? ");
INSERT INTO dgc_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ewan beman saye tu anak no karpintero tam?” kagi de. “Ti ésiya pa ina,” kagi de, “éng éwan anak san ni Maria? Sakay i top na éy de Santiago, ti Jose, ti Hudas, sakay ti Simon. Sakay du tétotop na a bébe, éy mégiyan pabi se side dikitam.” Kanya éwan side naniwala diya ta Nasaret. ");
INSERT INTO dgc_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ey kinagi ni Jesus dide, a “I purupeta éy iyégalang ta maski ahe. Pero ta sarili na a banuwan, sakay ta sarili na a bile, éy éwan siya iyégalang.” ");
INSERT INTO dgc_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ey nadid, éy éwan minagimet ti Jesus ta éya ta makataka-taka a gimet, da éwan side méniwala diya. Basta nitupu na i kamét na ta séngasénganya a tolay a te ladu, a pinahusay na side. ");
INSERT INTO dgc_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ey mégtaka siya, da éwan side naniwala diya. Nadid, linebut ni Jesus du bariyo-bariyo ta éya, a nagtoldu siya du tolay. ");
INSERT INTO dgc_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ey nipauwet na du alagad na a labindalawa, sakay pinéglakad na side ta tégdéduwa, a monda mégtoldu side. Sakay inatdinan na side ta kapangyarian a monda maari side a mégpaibut du medukés a espiritu. ");
INSERT INTO dgc_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Pinagbilinan na side, a “Diyan kam mégkébil ta bilon moy,” kagi na. “Maski suput, maski kuhata,” kagi na, “éy diyan moy kébilén. ");
INSERT INTO dgc_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Basta sahukod i kébilén moya, sakay magsinelas kam. Sakay diyan moy kébilén i pégpalitan moy a badu. ");
INSERT INTO dgc_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Sakay ta késdép moy ta tulusan moy a bile,” kagi na, “éy tumulos kam sa a hanggan éwan kam maglakad. ");
INSERT INTO dgc_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Eng du tolay ta esa a banuwan, éy éwan de kam tanggapén, o éng sala de a bébaten tu ipahayag moy, éy basta humektat kam sa, a ihalimbawa moy dide a ipagpag moy ta tikéd moya tu alikabuk. Saya i tanda moya dide a te kasalanan side.” ");
INSERT INTO dgc_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nadid, to pégkagi ni Jesus ta éya du alagad na, éy hinumektat side, a nagtoldu side du tolay a dapat de a ibutan tu ugali de a makasalanan. ");
INSERT INTO dgc_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Sakay pinaibut de i meadu a dimonyo; sakay i meadu a tolay a te ladu, éy nikulo de dide i langis, éy naghusay side. ");
INSERT INTO dgc_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nadid, ti Hari Herod éy nabaheta na i nanyaria, da tanyag dén ti Jesus. Te sénganya a tolay a kagi de a siya éy ti Juan a Mégbinyag, a minabuhay dén. Kanya makagimet kan siya ta makataka-taka, kagi de. ");
INSERT INTO dgc_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","I iba éy akala de éy ti Elias siya. Sakay kagi du iba éy purupeta kan siya, a kona du purupeta na Diyos to araw. ");
INSERT INTO dgc_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Pero ti Hari Herod, pékabaheta na ta gégemtén ni Jesus, éy kinagi na, a “Talaga a siya dén ya ti Juan, a pinaputol ko. Minabuhay man dén siya!” ");
INSERT INTO dgc_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Kanya binuno ti Juan, éy pinintasan na ti Herod, a kinékagi na ni Herod, a “Ewan maari a mékiagum ka ni Herodias, da asawa ina ni wadi mo.” (Ti Herodias éy asawa ni Pelip a wadi ni Herod. Pero inagew siya ni Herod.) Kanya nipadikép ni Herod ti Juan, a nipihesu. ");
INSERT INTO dgc_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Sakay ti Herodias a bébe, éy méiyamut siya ni Juan. Gustu na siya a ipabuno, pero éwan na kaya, ");
INSERT INTO dgc_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","da sinaway siya ni Hari Herod. Ti Herod éy méganteng siya ni Juan, da tukoy na a mahusay siya a lélake, a éutusan na Diyos. Sakay pati, éng mébati na ti Juan a mégkagi, éy mégtaka siya. Kanya gustu na be a mabati. ");
INSERT INTO dgc_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nadid, dinumemét dén tu pagkékataon ni Herodias. Kédemét no kapanganakan ni Herod, éy naganyaya siya, éy édsa be sa du te tungkulin a tolay ta banuwan. ");
INSERT INTO dgc_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ey tu anak ni Herodias a madiket, éy nagsayaw siya to harap du lélake. Ey mésahat de Herod to pégsayaw na. Kanya kinagi ni Hari Herod diya a iatéd na diya i maski anya a gustu na. ");
INSERT INTO dgc_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nipangako na diya, a kinagi na, a “Kagi mo san éng anya i gustu mua, éy iatéd ko dén diko. Maski hanggan ta kalahati na kayamanan ko,” kagi na. ");
INSERT INTO dgc_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ey tu madiket, pékabati na ta éya, éy inumange siya nagpakelagip to ina na éng anya maka i agidén naa. “Agidén mo tu ulo ni Juan a Mégbinyag,” kagi nena na. ");
INSERT INTO dgc_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ey tu madiket, nagsoli siya agad to hari, a kinagi na, a “I gustu kua, éy iatéd mo diyakén nadid i penggan a te déton sa tu ulo ni Juan a Mégbinyag!” ");
INSERT INTO dgc_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nadid, pékabati no hari ta éya, éy masiyadu dén siya a nagsisi. Pero éwan siya makaidel, dahil to nipangako na ta harap du bisita na. ");
INSERT INTO dgc_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Kanya inutusan na agad tu sundalu a umange mangalap to ulo ni Juan. Ey tu sundalu, éy inange na pinutulan ti Juan. ");
INSERT INTO dgc_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Sakay niedton na tu ulo na to penggan, sakay niatéd na to madiket. Sakay siya éy nitulos na dén nena na. ");
INSERT INTO dgc_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ey du alagad ni Juan, pékabaheta de, éy inumange sa side mangalap to bangkay na, a tulos de nielbéng to pantiyung. ");
INSERT INTO dgc_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Nadid, du apostol, éy sinumoli side ni Jesus, a kinagi de diya i ginamet de, sakay tu nitoldu de du tolay. ");
INSERT INTO dgc_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ey te meaadu nadid a tolay a uméange ni Jesus a aldew-aldew, a hanggan éwan be maari de Jesus a méngan. Kanya kinagi ni Jesus du alagad na, a “Kitam dén mabukod ta adeyo, monda éwan kitam maabala, monda makaimang kam.” ");
INSERT INTO dgc_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Tulos sinumakay side to abeng a inumange side to esa a lugar a éwan tu tolay. ");
INSERT INTO dgc_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pero du meadu a tolay, pékatan-aw de dide a hinumektat, éy tinumagubet side, da tukoy de a de Jesus side. Ey naginan side a namaybay a linumekaw, éy neditol side a dinumemét to punduan de Jesus. ");
INSERT INTO dgc_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ey nadid, to képundu ni Jesus to baybay, éy neta na i meadu a tolay. Ey kinagbian na side, da koman side i tupa a éwan tu pastor a mégalaga dide. Tulos nagtoldu siya dide. ");
INSERT INTO dgc_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nadid, to giapon dén, éy kinagi du alagad diya, a “Maistu, apon dén, sakay édse kitam ta ilang a lugarae. ");
INSERT INTO dgc_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Péglakadén mo dén di tolayae du bariyo-bariyo ta palebut ta éye, monda makabugtong side ta kanén de.” ");
INSERT INTO dgc_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","“Ewan,” kagi ni Jesus. “Sikam éy pékanén moy side.” “Ey pakodyan me?” kagi de. “Pamugtungén mo kame beman ta éduwa a datos a kuhata a tinapay a ipakan tam dide?” ");
INSERT INTO dgc_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","“Ey sénganya,” kagi na, “i bilon moya sina a tinapay? Angen moy entan.” Ey péketa du alagad, éy kinagi de, a “Te lima kitam a momon a tinapay, sakay éduwa a pindang.” ");
INSERT INTO dgc_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","40","Nadid, pinaeknud ni Jesus du tolay to kalamonan ta éya, ta puktu-puktu a téglélimapulu éy ta tégsésandaan. ");
INSERT INTO dgc_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Sakay inalap na tu lima a tinapay, sakay tu éduwa a pindang. Ey tinumangad siya ta langet a nagpasalamat ta Diyos. Sakay pinuseng-puseng na tu tinapay, a niutus na du alagad na a ihayin de du tolay. Ey kona be sa tu pindang. ");
INSERT INTO dgc_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ey néngan side a étanan, a minabsog side. ");
INSERT INTO dgc_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ey hinempésan du alagad tu sobha, éy naputat pa tu sapulu éy ta éduwa a gatang! ");
INSERT INTO dgc_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ey du minéngan ta éya a tinapay éy lima a libu a lélake. ");
INSERT INTO dgc_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nadid, pinasakay ni Jesus du alagad na to abeng, a pinégdetol na side ta dibilew ta Betsayda. Ey siya, éy pinasoli na du tolay ta bile de. ");
INSERT INTO dgc_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ey to kéhektat de, éy nanohobuk ti Jesus to buked, a monda manalangin. ");
INSERT INTO dgc_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kédemét no kélép, éy édsa du alagad ta ditaw, éy édse ti Jesus to luta. ");
INSERT INTO dgc_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ey neta na a mehirap i pégaud dia, da sinongsong side no pahés. Nadid, to tamo a amulaldew, éy tinumagubet ti Jesus dide, a méglakad ta dibo na diget. Talaga a lampasan na side, ");
INSERT INTO dgc_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","éy neta de siya a méglakad ta dibo no diget, tulos kinomhad side, da akala de éng bélet, ");
INSERT INTO dgc_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","éy méganteng side a étanan diya. Pero kinagi ni Jesus dide, a “Diyan kam méganteng. Sakén ye.” ");
INSERT INTO dgc_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ey sinumakay siya to abeng, a tulos hinumintu dén tu pahés. Ey mégtaka du alagad, ");
INSERT INTO dgc_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","da maski tu ginamet ni Jesus a tinapay, éy éwan de pabi napospusan éng ti ésiya siya. Ewan side méatutu. ");
INSERT INTO dgc_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Nadid, to kéahabes de, éy pinumundu side ta Genesaret. ");
INSERT INTO dgc_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ey to kéahawas de, éy du tolay sa, éy natenggi de a de Jesus side. ");
INSERT INTO dgc_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ey naginan side agad du bawat bariyo ta éya, sakay niange de diya dudu kabébayan de a te ladu. Hinamaka de side to nakabahetaan de ni Jesus a lugar. ");
INSERT INTO dgc_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kanya ti Jesus, maski ahe i demtan naa a banuwan, éy du tolay sa, éy pakatidugén de du kakaguman de a te ladu to dimanan na. Ey nékiohon side diya, éng maari, éy kébilan du te ladu i ontok san no badu na. Ey du étanan a nangkébil to badu na, éy naghusay side. ");
INSERT INTO dgc_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Nadid, du Pariseyo sakay i sénganya du maistu ta rilihiyon a gébwat ta Jerusalem, éy dinumulug side ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ey neta de du alagad ni Jesus, a éwan de inugisan i kamét dia bagu méngan, ayun ta rilihiyon na Pariseyo. ");
INSERT INTO dgc_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Da ugali a dati na Judeo, éy maguges side bagu méngan, ayun ta ugali a nipamana dide du ninunu de. ");
INSERT INTO dgc_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Sakay utus be no rilihiyon de, éy éwan de maari a kanén i bébugtungén dia, éng éwan de pa wahasikan ta dinom. Ey te meadu pabi side a sunudén a ugali a iba, éng kodya i péguges ta iba a kasangkapan de. ");
INSERT INTO dgc_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kanya du Pariseyo, éy kinagi de ni Jesus, a “Bakit du alagad mo, éy éwan de sésundin tu pégtoldu a nipamana dikitam du ninunu tam? Da éng méngan side, éy éwan de ugisan i kamét dia a kona ta ugali na rilihiyon tama?” ");
INSERT INTO dgc_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","“Sikam a mégkukunwari a éwan kam tu kasalanan!” kagi ni Jesus. “Tama bale i nihulaa ni Isayas tungkul dikam: ‘Diden ya a tolay,’ kagi na Diyos, ‘éy igalangék de ta labi dia; pero ta isip dia éy éwan. ");
INSERT INTO dgc_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ewan tu pasa tu pégsamba de diyakén, da kagi de éy gébwat ta Diyos tu pégtoldu de, pero éwan.’ ");
INSERT INTO dgc_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Bakit,” kagi ni Jesus, “éy sugsugén moy tu ugali du ninunu moy, pero i utus na Diyos éy pébayan moy. ");
INSERT INTO dgc_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Bihasa kam,” kagi na, “a méngibut ta utus na Diyos, a monda ahigén moy tu ugali du ninunu moy. ");
INSERT INTO dgc_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Da utus na Diyos a esa, éy ‘Igalang mo tama mo éy tena mo, sakay tu mégkagi ta medukés ta ama na éy ta ina na, éy dapat ipabuno siya.’ ");
INSERT INTO dgc_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Pero sikam,” kagi ni Jesus, “éy iyétoldu moy a maski te hirap tu ama no lélake, éy ta ina na, éy éwan siya tu kailangan a tumulung dide, da iatéd na ta Diyos i metulung na maka dide a kuhata. ");
INSERT INTO dgc_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kanya pébayan moy tu utus na Diyos alang-alang ta mana moy a pégtoldu. Ey te meadu kam be a iba a ugali a medukés.” ");
INSERT INTO dgc_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Nadid, pinaadene man dén ni Jesus du tolay diya, sakay kinagi na dide, a “Baten moy i kagin kuae, a isipén moy ye: ");
INSERT INTO dgc_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ewan tu isubu na tolay i makapagpadukésa diya ta mata na Diyos; éngˈwan tu bumébéswal ta labi na tolay, éy saya i magpadukésa diya. ");
INSERT INTO dgc_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Eng makabati kam, éy baten moy ya!” ");
INSERT INTO dgc_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Nadid, to kéhektat ni Jesus du tolay, a sinomdép to bile éy nipakelagip diya du alagad na i kahulugen no nihalimbawa na du tolay. ");
INSERT INTO dgc_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","“Ewan moy be napospusan?” kagi ni Jesus. “Ewan moy tukoy tu isubu na tolay, éy éwan ya mégpadukés diya, ");
INSERT INTO dgc_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","da éwan uméange ta isip na, éngˈwan tumulos ta tiyan na san, tulos iyétay na.” (Saya i nipabatia ni Jesus a maari a méngan ta maski anya a kalase a kanén.) ");
INSERT INTO dgc_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","“Pero tu bumébéswal ta labi na tolay,” kagi na, “éy saya i magpadukésa ta tolay. ");
INSERT INTO dgc_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Dahilan, ta isip na tolay, éy saya i kégébwatan na mégpadukés dide. Da mégisip side ta medukés, péngibébi, pégtako, pémuno, ");
INSERT INTO dgc_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","péngilélake, pénaghili, sakay méngloko side ta tolay, sakay bastos side, méngupos side, mégpalalo side, sakay iba a gimet de a medukés. ");
INSERT INTO dgc_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Gébwat diden ya ta isip na tolay,” kagi ni Jesus. “Saya i mégpadukésa ta tolay.” ");
INSERT INTO dgc_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Nadid, hinumektat ti Jesus ta éya, a inumange ta Tiro sakay ta Sidon. Ta éya éy sinomdép siya to esa a bile ta lihim, monda éwan mapospusan na tolay i tinulusan naa. Pero éwan siya makaiwas du tolay. ");
INSERT INTO dgc_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Te bébe sa a te anak a hinayup no medukés a espiritu. Siya, pékabaheta na ni Jesus, éy inumange siya diya agad, sakay dinumapa siya to tikéd na. ");
INSERT INTO dgc_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Nadid, i éya a bébe éy éwan Judeo, da taga Siria siya. Dinumaying siya ni Jesus, a ibutan na tu dimonyo to anak na. ");
INSERT INTO dgc_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Pero kinagi ni Jesus, a “Dapat pékanén ko pa du anak. Ewan maari a alapén ko tu kanén na anak,” kagi na, “a monda ipakan ko du aso.” ");
INSERT INTO dgc_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nadid tu bébe, tukoy na a i kahulugina no kinagi ni Jesus, éy dapat tulungan na pa du Judeo, bagu du éwan Judeo. Kanya kinagi na, a “Tahod ngani, Panginoon. Pero maski du aso éy méngan be side ta mumo a métépduk to lamesa no amo de.” ");
INSERT INTO dgc_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","“Tama tu kagi mo,” kagi ni Jesus. “Ikad mo dén sumoli ta bile moy. Naibut dén tu dimonyo to anak mo.” ");
INSERT INTO dgc_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Pékabati no bébe ta éya, éy hinumektat dén siya. Ey kédemét na to bile, éy dinemtan na tu anak na a te katidug san to kama, a naibut ngani dén tu dimonyo diya. ");
INSERT INTO dgc_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Nadid, hinumektat de Jesus ta Tiro. Ey tinumulos side ta Sidon, a hanggan ta sabeng ta Galilea sakay ta Dekapolis. ");
INSERT INTO dgc_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ta éya, éy te tolay a niange de diya i esa a lélake a tuléng, a utal pa, a nékiohon side ni Jesus, a itupu na i kamét na diya, monda maghusay. ");
INSERT INTO dgc_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ey nikabukod siya ni Jesus ta adeyo du tolay sa, sakay sinoldut na to toldu na tu talinga na, sakay pinugetan na be ta laway na tu dila na. ");
INSERT INTO dgc_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Sakay tinumangad ti Jesus ta langet, a inumangés ta dikél, sakay kinagi na to lélake, a “Mabukasan i talinga mua.” ");
INSERT INTO dgc_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","To pégkagi ni Jesus ta éya, éy basta makabati dén tu lélake, sakay makakagi dén siya ta mahusay. ");
INSERT INTO dgc_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ey kinagi ni Jesus dide a étanan, a diyan de iyébaheta ta maski ti ésiya i nanyaria. Pero maski nibilin na dide i kona sa, éy lalo de san a nibaheta. ");
INSERT INTO dgc_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ey du nakabati, éy nagtaka side a tahod. “Memahal i gimet na éya a lélake,” kagi de. “Maski du tuléng éy pékabaten na side, sakay du bulol éy pégkagién na side ta mahusay.” ");
INSERT INTO dgc_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","To esa man dén a aldew, éy te meaadu man dén a tolay a dinumulug ni Jesus. Ey éwan side tu kanén. Ey dinulawan ni Jesus du alagad na, a kinagi na dide, a ");
INSERT INTO dgc_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Kagbian ko di tolay a éye. Etélo dén a aldew a kaguman ko éy éwan dén side tu makan. ");
INSERT INTO dgc_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Eng péglakadén ko side ta bile de a mégalép, éy kapuyén side a talaga ta dilan. Ey te sénganya dide a gébwat ta adeyo.” ");
INSERT INTO dgc_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ey kinagi du alagad, a “Ahe i pangalapan tama ta ipakan tam dide ta ilanga a lugare?” ");
INSERT INTO dgc_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","“Ey sénganya i bilon moya a tinapay?” kagi ni Jesus. Ey “Pitu a momon,” kagi de. ");
INSERT INTO dgc_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nadid, pinaeknud ni Jesus du tolay to luta. Sakay inalap na tu pitu a tinapay. Ey to pégpasalamat na ta Diyos, éy pinuseng-puseng na, sakay niatéd na du alagad na, a monda ihayin de du tolay. Ey nihayin de dén dide. ");
INSERT INTO dgc_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ey te kétihék be side a ikan. Ey nagpasalamat be ti Jesus ta Diyos a para dide, sakay nipehayin na be dide du tolay. ");
INSERT INTO dgc_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ey néngan side a étanan, a minabsog side. Ey hinempésan de tu sobha, éy naputat pa tu pitu a gatang. ");
INSERT INTO dgc_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Te manga épat a libu a lélake a minéngan ta éya. Ey nadid éy pinéglakad ni Jesus du tolay. ");
INSERT INTO dgc_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Sakay tulos sinumakay de Jesus to abeng, a inumange side ta Dalmanuta. ");
INSERT INTO dgc_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Nadid, inumange ni Jesus i sénganya a Pariseyo, a mékipégsuway side diya. Pilitén de siya a ipeta na dide i tanda a makataka-taka ta langet, monda puhubaan de siya. ");
INSERT INTO dgc_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ey naghimutuk ti Jesus tu isip, a kinagi na dide, a “Bakit piliténék di lahi a éye a Judeo, a ipeta ko dide i tanda? Talaga a éwan tu ipeta dide a tanda.” ");
INSERT INTO dgc_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ey to pégkagi ni Jesus ta éya, éy gininanan na side. Sinumakay man dén de Jesus to abeng de, a tamo side ta dibilew. ");
INSERT INTO dgc_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Nadid, kinaleksapan de a magkébil ta bilon de a tinapay. Basta isesa san i kébil dia to abeng. ");
INSERT INTO dgc_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ey kinagi ni Jesus du alagad na, a “Mangilag kam ta pégpaalsa du Pariseyo, sakay ni Herod.” ");
INSERT INTO dgc_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ey du alagad, éy mégpéguhon side éng anya i kahulugen na éya. “Kodya éwan kitam tu kébil a tinapay,” kagi de. “Kanya na wade kinagi i éya.” ");
INSERT INTO dgc_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Tukoy ni Jesus tu uhon de, kanya kinagi na dide, a “Bakit péguhunan moy a éwan kam tu bilon a tinapay? Masiyadu a kétihék tu péniwala moy! Bakit mehina pabi i isip moya? ");
INSERT INTO dgc_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Te mata kam,” kagi na, “pero éwan kam wade maketa. Te talinga kam, pero éwan kam wade makabate. Ewan moy beman tukoy a éwan tinapay i pégkagian kua? Bakit, éwan moy natandaan ");
INSERT INTO dgc_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","tu pémuseng-puseng ko to lima a tinapay a para ta lima a libu? Sénganya a gatang i sobha a nihempés moy?” Ey “Labindalawa,” kagi de. ");
INSERT INTO dgc_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Sakay tu pitu a tinapay a para ta épat a libu,” kagi na, “éy sénganya a gatang i sobha a nihempés moy?” “Ey pitu,” kagi de. ");
INSERT INTO dgc_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","“Ey éwan moy bale mépospusan tu kinagi ko?” kagi na. ");
INSERT INTO dgc_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Nadid, kédemét de ta Betsayda, éy du tolay sa, éy niange de ni Jesus i esa a lélake a buhék, a mékiohon side diya a kébilan na siya. ");
INSERT INTO dgc_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ey ti Jesus, éy kinabitan na tu buhék, a linumuwas side to bariyo. Nadid, linoktaben na tu mata no buhék, sakay nitupu na tu kamét na diya, sakay kinagi na diya, a “Anya, maketa ka dén?” ");
INSERT INTO dgc_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ey tu lélake, to péglameng-lameng na, éy kinagi na, a “Maketaék dén ta tolay, pero mediklém, a koman side i kayo a méglakad.” ");
INSERT INTO dgc_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ey nadid, nitupu man dén ni Jesus i kamét naa diya. Ey nadid, péglameng na man dén, éy naketa dén siya ta mahusay. ");
INSERT INTO dgc_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ey pinaglakad siya ni Jesus to bile na, a nibilin na diya, a “Diyan ka sumésoli ta bariyuae.” ");
INSERT INTO dgc_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Nadid, inumange de Jesus du bariyo-bariyo ta Sesarea-Pilipo. Ey to péglakad de, éy kinagi ni Jesus du alagad na, a “Ti ésiyaék kan ayun ta kagi na tolay?” ");
INSERT INTO dgc_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ey kinagi du alagad, a “I kagi kana na iba éy ti Juan ka kan a Mégbinyag. Kagi man dén na iba a ti Elias ka kan. Ey te iba be a mégkagi a purupeta ka kan a esa.” ");
INSERT INTO dgc_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","“Ey sikam,” kagi ni Jesus, “anya i isip moya? Ti ésiyaék?” Ey kinagi ni Pedro, a “Siko i Cristo a tiniyak na Diyos a tagapagligtas ta mundua!” ");
INSERT INTO dgc_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ey nibilin dide ni Jesus, a diyan de kékagin ta maski ti ésiya a siya i Cristo. ");
INSERT INTO dgc_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Nadid, éy nipagtapat ni Jesus du alagad na a siya tu lélake a gébwat ta langet; éy dapat magtiis siya ta meadu, sakay idelan siya du te tungkulin a Judeo. “Sakay ipabunuék de,” kagi na. “Sakay ta ikatélo a aldew éy mabuhayék.” ");
INSERT INTO dgc_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nipaliwanag ya ni Jesus dide ta mahusay, monda mapospusan de. Ey ti Pedro, pékabati na ta éya, éy nikabukod na ti Jesus, a pinégkagian na siya. ");
INSERT INTO dgc_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pero ti Jesus, késuleg na, a neta na du alagad na, éy pinaginglan na ti Pedro. “Umadeyo ka dén, Satanas,” kagi na. “Ewan ka mégisip ta kaluuben na Diyos, éngˈwan ta kaluuben na tolay.” ");
INSERT INTO dgc_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Nadid, pinauwet ni Jesus du tolay, sakay du alagad na. “Eng ti ésiya i te gustu a ipasakup diyakén,” kagi na, “éy kailangan éy pabayan na pa i sarili na, sakay kumuyoyog diyakén, a maski bunon siya na tolay. ");
INSERT INTO dgc_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Dahilan tu maghangad a meligtas tu buhay na, éy mebut a talaga. Pero tu mégpabaya ta buhay na alang-alang diyakén, sakay ta mahusay a baheta, éy siya i mabuhaya a éwan tu katapusan. ");
INSERT INTO dgc_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Anya beman i pakinabanga na esa a tolay éng siya i mayamana ta étanan, éng éwan na makamtan i buhay a éwan tu katapusan? ");
INSERT INTO dgc_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Anya beman i bayada na tolay a mate a monda magsoli tu buhay na? ");
INSERT INTO dgc_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","I maski ti ésiya a mégpabaya diyakén nadid a panahun a medukés, sakay tu mégpabaya ta pégtoldu kua,” kagi ni Jesus, “éy sakén éy pabayan ko be side ta késoli ko se a kaguman ko du anghel ko, a te kébilék ta kapangyarian Nama ko. Da sakén i lélake a gébwat ta langet. ");
INSERT INTO dgc_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","“Natandaan moy,” kagi ni Jesus. “Te sénganya se dikam a éwan mate hanggan éwan de meta i pégsapul na Diyos a maghari ta tolay.” ");
INSERT INTO dgc_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nadid, kélipas na éném a aldew, éy kinuyog ni Jesus de Pedro, sakay ti Santiago sakay ti Juan; éy nanohobuk side to melangkaw a buked. Ey to édsa de sa, éy neta de a nabagu tu idsura ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","I badu naa éy linumatak a hanggan méngislap dén. Ewan tu makapagpalatak ta damit a kona ta éya. ");
INSERT INTO dgc_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ey du étélo a alagad, éy neta de nadid ti Elias sakay ti Moises, a kauhon ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ey ti Pedro, éy kinagi na ni Jesus, a “Panginoon, maigi pa éy édse kitam san dén. Pagbile me kam ta étélo a kékétihék a bile; esa diko, esa ni Moises, sakay esa ni Elias.” ");
INSERT INTO dgc_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Talaga a éwan napospusan ni Pedro i kékagin naa, da méganteng side a tahod. ");
INSERT INTO dgc_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Nadid éy tinaklében side no kuném. Ey kinagi no boses to kuném, a “Séˈ ina i mahal kua a anak. Baten moy siya.” ");
INSERT INTO dgc_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ey kélameng du alagad, éy éwan dén side tu mineta, éngˈwan ti Jesus san dén. ");
INSERT INTO dgc_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nadid, namulnok side to buked, éy kinagi ni Jesus dide, a “Diyan moy kékagin ta maski ti ésiya i mineta moya, hanggan éwanék mabuhay a huway, sakén a lélake a gébwat ta langet.” ");
INSERT INTO dgc_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ey sinunud de tu kinagi na, pero mégpéguhon side éng bakit kagi ni Jesus a mabuhay siya a huway. ");
INSERT INTO dgc_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ey kinagi de ni Jesus, a “Bakit du maistu ta rilihiyon, éy kékagin de a meditol kan se ti Elias a umange, bagu tu tagapagligtas ta mundua?” ");
INSERT INTO dgc_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","“Tutuhanan ya,” kagi ni Jesus, “umange pa se ti Elias a talaga, a monda paghandaén na i étanan. Ey sikam,” kagi na, “bakit wade nabasa to kasulatan, a tu lélake a gébwat ta langet, éy maghirap kan siya ta meadu, a apién siya na tolay? ");
INSERT INTO dgc_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ey tandaan moy, inumange dén se ti Elias. Pero linoko de siya, ayun to gustu de. Ey tinupad dén ya to nabasa ta tungkul diya.” (Kinagi ni Jesus tungkul ni Juan a Mégbinyag.) ");
INSERT INTO dgc_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Nadid, késoli de Jesus du iba a alagad a nawahak, éy neta de a te meadu sa a tolay. Ey du maistu ta rilihiyon, éy mékipégpasuway side du alagad. ");
INSERT INTO dgc_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ey du tolay, péketa de ni Jesus, éy nagtaka side. Ey naginan side diya a binumate diya. ");
INSERT INTO dgc_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ey kinagi ni Jesus du alagad na, a “Anya i pégpasuwayan moya?” ");
INSERT INTO dgc_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ey kinagi no esa a lélake ta éya, a “Maistu, niange ko dén i anak ko yae diko, da te medukés a espiritu diya a mégpabulol diya. ");
INSERT INTO dgc_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Bagay atagén siya no espiritu, éy basta palugmukén na siya, tulos mégbugak i labi naa, sakay mégngilét-ngilét siya, sakay mégkaramre. Ey nékiohonék dén du alagad mo, Maistu, a ibutan de tu espiritu, éy éwan de kaya.” ");
INSERT INTO dgc_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ey kinagi ni Jesus dide, a “Ayhay i lahi di tolayae, da éwan kam méniwala! Pakodyan ko se a magtiis dikam? Nay, iange moy se tu anak.” ");
INSERT INTO dgc_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Nadid, péngiange de to anak diya, éy neta no espiritu ti Jesus, a tulos pinagkaramre na to anak, tulos nalugmuk siya, sakay nagbileg-bileg siya, a nagbugak i labi naa. ");
INSERT INTO dgc_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ey kinagi ni Jesus to ama na, a “Nagsénganya beman dén ye diya?” “Ey sapul to kéanak na,” kagi na. ");
INSERT INTO dgc_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“Ey tu espiritu éy medalas a patumbaén na siya ta apoy, o dikaya ta dinom, a talaga na siya a bunon. Kagbian mo kame, Maistu,” kagi no ama na, “a tulungan mo kame, éng maari.” ");
INSERT INTO dgc_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","“Bakit kagi mo, ‘Eng maari,’” kagi ni Jesus. “Eng méniwala ka ta Diyos, éy makagimet ka ta maski anya.” ");
INSERT INTO dgc_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","“Ey méniwalaék,” kagi no ama no anak. “Patibayén pad i péniwala ko, monda hustu dén!” ");
INSERT INTO dgc_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nadid, péketa ni Jesus ta mas meadu a tolay a méginan a tamo diya, éy pinégkagian na tu medukés a espiritu. “Siko a espiritu a mégpabulol sakay mégpatuléng, umibut ka dén ta bégi na anaka ina, sakay diyan ka dén sumésoli diya a huway!” ");
INSERT INTO dgc_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nadid, pégkagi ni Jesus ta éya, éy nagkéles tu espiritu, sakay pinagkaramre na tu anak ta mahigpit, sakay inumibut siya diya. Ey tu anak, éy koman dén i bangkay i idsura naa, a akala du tolay a minate dén. ");
INSERT INTO dgc_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pero kembilan ni Jesus tu kamét na a inégkat, éy tinumaknég siya. ");
INSERT INTO dgc_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ey to késdép de Jesus to bile, éy kinagi diya du alagad na, a “Bakit éwan kame maari a magpaibut to espiritu ta anak yae?” ");
INSERT INTO dgc_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ey kagi ni Jesus, a “I kona sa a hayup éy éwan moy mapaibut éng éwan kam pa manalangin.” ");
INSERT INTO dgc_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Nadid, hinumektat sa side, a inumange side ta lihim ta Galilea, da sala ni Jesus a mépospusan du tolay éng ahe i angayan naa, ");
INSERT INTO dgc_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","da tétolduan na du alagad na san. I kinagi naa dide, éy “Sakén a lélake a gébwat ta langet, éy itokyonék de, sakay bunonék de. Pero ta ikatélo a aldew éy mabuhayék a huway.” ");
INSERT INTO dgc_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ey du alagad, pékabati de ta éya, éy éwan de napospusan i kahulugen naa. Ey mésanike side a mégpakelagip diya ta kahulugen naa. ");
INSERT INTO dgc_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Nadid, to édse de to bile ta Kapernaum, éy nipakelagip ni Jesus dide éng anya i pégpasuwayan dia to dilan. ");
INSERT INTO dgc_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pero mésanike side a sumésengbet, da nagpasuway side éng ti ésiya i mataasa dide. ");
INSERT INTO dgc_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Kanya inumeknud ti Jesus, sakay kinagi na du labindalawa a alagad na, a “Maski ti ésiya i te gustu a mataas du kaguman na, éy dapat maging mababa siya du kaguman na. Dapat maging katulung siya du kaguman na. Saya i ibilanga na Diyos a mataas.” ");
INSERT INTO dgc_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nadid, to pégkagi na ta éya, éy inalap na tu esa a anak, a pinataknég na ta harap dia. Nadid, to péngkélkél na diya éy kinagi na dide, a ");
INSERT INTO dgc_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Maski ti ésiya i tumanggap ta esa a kona se a anak, dahil ta péniwala na diyakén, éy bilang sakén dén i tinanggap naa. Sakay tu tumanggap diyakén, éy bilang tinanggap na be tu nagpaange se diyakén.” ");
INSERT INTO dgc_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Nadid, ti Juan, éy kinagi na ni Jesus, a “Maistu, neta me i esa a lélake a nagpaibut du dimonyo a gégamitén na i ngahen mua, éy sinaway me siya, da éwan sakup na gurupu tam.” ");
INSERT INTO dgc_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","“Ewan,” kagi ni Jesus. “Diyan moy sésawayén i kona sa a tolay. Dahilan i maski ti ésiya a gemtén i memahal a gimet ta pamag-itan na ngahen kua, éy éwan siya agad mangupos diyakén. ");
INSERT INTO dgc_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Dahilan,” kagi na, “tu éwan kontara dikitam éy kampi siya dikitam. ");
INSERT INTO dgc_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ey tandaan moy, maski ti ésiya a mangatéd dikam ta maski esa a baso a dinom, da sakup kam ni Cristo, éy atdinan be siya na Diyos ta gantimpala na.” ");
INSERT INTO dgc_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Maigi pa ta esa a tolay, éy kalukalan ta bito i leg naa, sakay ietbung ta diget, kesira ta makapangatéd siya ta ipagkasala na mababa a tolay a méniwala diyakén. ");
INSERT INTO dgc_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kanya,” kagi ni Jesus, “éng na kamét mua i mangatéd diko ta ipagkasala mo, éy kétulén mo dén! Maigi pa éy umange ka ta langet a putéd, kesira ta éduwa tu kamét éy umange ka ta apoy a éwan tu kéédép. ");
INSERT INTO dgc_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Sakay na tikéd mua, éng siya i mangatéd diko ta ipagkasala mo,” kagi na, “éy kétulén mo dén. Maigi pa éy umange ka ta langet a putéd tu tikéd, kesira ta éduwa tu tikéd mo éy ibut ka ta apoy. ");
INSERT INTO dgc_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Sakay éng na mata mua i mangatéd diko ta ipagkasala mo, éy lugitén mo! Maigi pa éy umange ka ta kaharian na Diyos a buhék, kesira ta éduwa i mata mua éy ibut ka ta apoy na impiyerno. ");
INSERT INTO dgc_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ta éya éy éwan mate i éhés, sakay tu apoy éy éwan maadéadép. ");
INSERT INTO dgc_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Dahilan,” kagi ni Jesus, “i étanan a tolay, éy asinan side ta apoy. ");
INSERT INTO dgc_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Mahusay i asen. Pero éng maibut tu asen, a tumablal dén tu sida, éy pakodyan moy a mamasoli to asen na? Ey kona be sa dikam, a dapat mahusay kam a koman i asen. Sakay négkasuyuan kam.” Ta Méghiwalay a Pasawa ");
INSERT INTO dgc_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Nadid, hinumektat sa de Jesus, a tinumulos side ta Hudea, ta dibilewa na Hordan. Ey dinumulug man dén diya i meaadu a tolay. Ey tinolduan na side, ayun to ugali na. ");
INSERT INTO dgc_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ey te Pariseyo a inumange diya ta éya, a talaga de siya a pagkamalién ta kagi na. I kinagi dia, éy “Maari wade a hiwalayan na lélake i asawa na?” ");
INSERT INTO dgc_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ey kinagi ni Jesus dide, a “Anya tu nisulat ni Moises tungkul ta éya?” ");
INSERT INTO dgc_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","“Pinakultaden kitam ni Moises,” kagi de, “a hiwalayan tam tu asawa tam, éng atdinan tam side ta kasulatan ta péghiwalay.” ");
INSERT INTO dgc_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","“Dahil ta kaktog na isip moya,” kagi ni Jesus, “éy nisulat ni Moises i éya. ");
INSERT INTO dgc_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero to pénglalang na Diyos ta mundua, éy ginimet na i lélake éy ta bébe. ");
INSERT INTO dgc_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Sakay kinagi be na Diyos, a ‘Dahilan ta éya éy ginanan no lélake dena na éy tama na, monda mékiagum to asawa na; ");
INSERT INTO dgc_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","éy maging isesa side.’ Kanya éwan dén side éduwa,” kagi ni Jesus, “éngˈwan esa san dén side. ");
INSERT INTO dgc_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kanya i pinagagum na Diyos, éy diyan péghiwalayén na tolay.” ");
INSERT INTO dgc_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Nadid, késoli de Jesus to bile de, éy nipakelagip diya du alagad na i tungkul ta éya. ");
INSERT INTO dgc_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ey kinagi ni Jesus dide, a “Maski ti ésiya a lélake a humiwalay ta asawa na, sakay mangasawa siya ta iba, éy méngibébi siya ta mata na Diyos. ");
INSERT INTO dgc_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ey kona be sa tu bébe a humiwalay ta asawa na,” kagi na, “éng mangasawa siya ta iba a lélake, éy méngilélake siya ta mata na Diyos.” ");
INSERT INTO dgc_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nadid, te nagkébil du anak de ni Jesus, a monda kébilan na side a ipanalangin na side. Pero pinégkagian side du alagad. ");
INSERT INTO dgc_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ey péketa ni Jesus ta éya, éy mégingél siya, sakay kinagi na du alagad na, a “Pabayan moy di anaka a umadene diyakén. Diyan moy side sésawayén, dahilan éy méghari i Diyos ta kona sina. ");
INSERT INTO dgc_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Tandaan moy, éng éwan kam umasa ta Diyos a kapareho na kéasa na anak to ina na, éy éwan kam makasdép ta kaharian na.” ");
INSERT INTO dgc_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ey to pégkagi ni Jesus ta éya, éy inalap na du anak a kinélkél; sakay nitupu na i kamét naa dide, a nipanalangin na side. ");
INSERT INTO dgc_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Nadid, to kéhektat sa de Jesus, éy te lélake a méginan a sambat diya. Ey kéabut na ni Jesus, éy linumuhud siya diya a kinagi na diya, a “Mahusay ka a maistu; kagin pad éng anya wade i gemtén kua a monda makaalapék ta buhay a éwan tu katapusan.” ");
INSERT INTO dgc_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","“Bakit dédulawénék mo a mahusayék?” kagi ni Jesus. “Ewan tu mahusay éng éwan Diyos. ");
INSERT INTO dgc_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Tukoy mo dén i kautusan na Diyos: diyan ka mamuno, diyan ka méngibébi, diyan ka mégtako, diyan ka mégbuli-buli, diyan ka méngdaya, sakay igalang mo tama mo éy ta ina mo. Basta sundin mo san diden ya a utus.” ");
INSERT INTO dgc_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","“Maistu,” kagi na, “sinunud ko dén ina side a étanan sapul to kéanak ko.” ");
INSERT INTO dgc_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Nadid ti Jesus, éy te itan na tu lélake, a mahal na siya. “Te esa pa a bagay a kulang diko,” kagi na. “Angen mo ibugtong tu ari-arian mo. Sakay tu kabugtungan na éy iatéd mo du mahirap. Eng pakunan mo sa, éy te kayamanan ka dén ta langet. Ey nadid éy sumoli ka se a kumuyoyog ka diyakén.” ");
INSERT INTO dgc_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nadid, pékabati no lélake ta éya, éy nalungkut dén siya. Ey hinumektat san dén siya, da napakayaman siya. ");
INSERT INTO dgc_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ey kinagi ni Jesus du alagad na, a “Mehirap a talaga a makasdép du mayaman ta kaharian na Diyos.” ");
INSERT INTO dgc_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ey mégtaka du alagad na ta éya a kinagi na. Ey kinagi ni Jesus, a “Tahod ngani. Maniwala kam a mehirap a talaga a somdép ta kaharian na Diyos. ");
INSERT INTO dgc_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Makasdép beman i kabayo ta ébut na digum? Mas lalo a mehirap a makasdép i mayaman ta kaharian na Diyos.” ");
INSERT INTO dgc_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Nadid, lalo a nagtaka du alagad ta éya, a kinagi de, a “Eng kona sa, éy ti ésiya i makaligtasa?” ");
INSERT INTO dgc_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ey te itan side ni Jesus, a kinagi na, a “Tama ngani; éwan maari i tolay a mangiligtas ta bégi na. Pero magimet na Diyos i maski anya.” ");
INSERT INTO dgc_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Nadid, kinagi ni Pedro, a “Entan mo, Panginoon. Sikame, éy gininanan me dén i étanan, a kinumuyog kame diko.” ");
INSERT INTO dgc_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","“O,” kagi ni Jesus. “Sakay tandaan moy: i maski ti ésiya a magtiis a guminan ta bile na éy ta tétotop na éy ta ina na éy ta ama na, éy ta anak na éy ta luta na alang-alang diyakén, sakay ta Mahusay a Baheta, ");
INSERT INTO dgc_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","éy atdinan siya na Diyos ta dubli-dubli a gantimpala na nadid a panahun. Da atdinan na Diyos i kona sa ta meaadu pa a bili-bile, sakay tétotop na, sakay éena na, sakay éanak na, sakay luta na. Pero demtan de be i kahirapan. Ey ta panahun a dumemét, éy makamtan na be i buhay a éwan tu katapusan. ");
INSERT INTO dgc_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pero meadu du mataas nadid,” kagi ni Jesus, “éy side i mababaa ta éya. Sakay du mababa nadid, éy side du mataas ta éya.” ");
INSERT INTO dgc_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Nadid, méglakad side a tamo ta Jerusalem, éy neditol ti Jesus du alagad na to dilan. Ey méganteng side. Ey méganteng be du tolay a umunonod dide, da te meadu a kontara ni Jesus ta Jerusalem. Ey nadid éy nibukod na du labindalawa a alagad na, sakay kinagi na dide i manyaria diya. ");
INSERT INTO dgc_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Entan moy,” kagi na. “Kédemét tam ta Jerusalem, éy itokyonék de du mataas a padi ta éya, sakay du maistu ta rilihiyon. Ey side i magpabuno diyakén, sakén a lélake a gébwat ta langet. ");
INSERT INTO dgc_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Itugénék de di dayuan yae a éwan Judeo. Ey side éy tétoksonék de sakay loktabenék de, sakay balbalénék de, sakay bunonék de. Ey kélipas na étélo a aldew, éy mabuhayék a huway.” ");
INSERT INTO dgc_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Nadid ti Santiago sakay ti Juan, a anak ni Zebedeo, éy nékiohon side ni Jesus. “Maistu,” kagi de, “éng maari, éy te kagin kame diko.” ");
INSERT INTO dgc_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","“Ey anya i gustu moya?” kagi ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","“Ey atdinan mo kame pad,” kagi de, “ta katungkulan me a sikame i bisi mo, a sikame i kaguman mo éng maghari ka.” ");
INSERT INTO dgc_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","“Ewan moy tukoy i pékiohon moya,” kagi ni Jesus. “Kaya moy wade be a matiis i hirap a tétiisén ko? Mabinyagenék ta hirap. Kaya moy wade be a mabinyagen ta éya?” ");
INSERT INTO dgc_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ey “O,” kagi de, “kaya me.” “I hirap a tiisén ko éy matiis moy ngani be,” kagi na, “sakay mabinyagen kam be ta pangbinyagen diyakén. ");
INSERT INTO dgc_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pero éwan sakén i bahala éng ti ésiya i bisi ko, a kaguman ko a maghari. I éya a kinagi moy éy para du pinaghandaan Nama ko.” ");
INSERT INTO dgc_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nadid, pékabati ta éya du sapulu a iba a alagad, éy nagingél side de Santiago. ");
INSERT INTO dgc_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kanya pinaadene side ni Jesus a étanan, a kinagi na, a “Tukoy moy dén a du tagapamahala du tolay éy mégéutusén side du mababa. ");
INSERT INTO dgc_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","44","Pero diyan sa kona i ugali moya. Engˈwan, éng ti ésiya dikam i gustu a mataas, éy dapat a maging utusan siya. ");
INSERT INTO dgc_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kona sa sakén a lélake a gébwat ta langet. Ewanék se inumange a monda utusan ko i tolay, éngˈwan sakén i utusan na tolay. Sakay inumangeék be se a monda iatéd ko i buhay ko a monda matubus ko i meadu a tolay.” ");
INSERT INTO dgc_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nadid, éy inumange de Jesus ta Heriko. Ey to kéhektat na ta éya, a kaguman na du alagad na, sakay du meadu a iba a tolay, éy te esa a lélake a buhék a te eknud to digdig no dilan, a mékilimos. Ti Bartimeo i ngahen naa, a anak ni Timeo. ");
INSERT INTO dgc_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ey siya, pékabaheta na a sumalegéd dén ti Jesus a taga Nasaret, éy dinumulaw siya a kinagi na, a “Jesus, Apo ni Dabid, kagbianék pad!” ");
INSERT INTO dgc_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ey du tolay sa, éy sinaway de siya a diyan siya tu pehéng. Pero lalo pa siya a dinumulaw. “Apo ni Dabid,” kagi na, “kagbianék mo!” ");
INSERT INTO dgc_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nadid, pékabati ni Jesus diya, éy hinumintu siya, a kinagi na, a “Iange moy se siya.” Kanya dinulawan de tu buhék, a “Nay,” kagi de, “diyan ka méganteng. Umégkat ka dén; péuwet na ka.” ");
INSERT INTO dgc_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ey tu buhék éy linumuksu siya a tinumaknég, sakay inibutan na tu ulés na, sakay inumange siya ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ey kinagi ni Jesus diya, a “Anya i gustu mua a gemtén ko diko?” “Maistu,” kagi na, “Gustu ko maketaék.” ");
INSERT INTO dgc_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ey “O,” kagi ni Jesus, “ikad mo dén. Dahil ta péniwala mua, éy mahusay ka dén.” Ey to pégkagi ni Jesus ta éya, éy naketa siya agad. Ey tulos inumunonod siya ni Jesus to dilan. ");
INSERT INTO dgc_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Nadid, dinumemét dén side ta Betpage sakay ta Betania, sakay ta buked na Olibo, a adene dén side ta Jerusalem. Ey pinégdetol ni Jesus i éduwa a alagad na. ");
INSERT INTO dgc_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Ikad moy dén ta bariyua ta dibilew yae,” kagi na, “ey meta moy sa agad i bul-o a kabayo a éwan pabi tinolduan, a te egut. Ukadén moy a iange moy se. ");
INSERT INTO dgc_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Eng te magpakelagip dikam éng bakit ukadén moy, éy kagi moy a kailangan na Panginoon; sakay kagi moy a isoli tam agad.” ");
INSERT INTO dgc_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Nadid, inumange sa du alagad a éduwa, éy neta de i bul-o a kabayo a te egut dén to pintuan no bile. Ey to péngukad de, ");
INSERT INTO dgc_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","éy nipakelagip dide du tolay sa éng bakit éukadén de. ");
INSERT INTO dgc_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ey kinagi de dide tu nibilin ni Jesus. Ey pinakultaden de side. ");
INSERT INTO dgc_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ey nitugén de tu kabayo ni Jesus, sakay sinapinan de siya to damit de, sakay tulos sinumakay ti Jesus. ");
INSERT INTO dgc_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ey meadu a tolay i naglatag ta damit de to kamino a dimanén ni Jesus. Du iba a tolay éy nagkétol side ta meadu a mehabéng a sanga-sanga, a nilatag de be to dimanén na. (Saya i pénggalang dia ta hari.) ");
INSERT INTO dgc_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ey du tolay a mégdetol diya, sakay du ménegipo, éy nagpagdulaw side, a kinagi de, a “Mabuhay! Basbasén maka na Diyos i lélakeae a pinaange na se! ");
INSERT INTO dgc_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Basbasén maka na Diyos i kaharian napo tam a Dabid a dumemét! Purién be i Diyos ta langet!” ");
INSERT INTO dgc_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Nadid, késdép ni Jesus ta Jerusalem, éy tinumulos siya to Templo. Ey to péngenta na ta éya, éy linumuwas siya a sinumoli ta Betania, da apon dén. Ey kaguman na du alagad na. a Kayo a Ewan Mégbunga ");
INSERT INTO dgc_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Nadid, to gagabi, éy nagsoli de Jesus ta Jerusalem a gébwat ta Betania. Ey mégalép ti Jesus. ");
INSERT INTO dgc_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ey pékatan-aw na to kayo a igos a mehabéng tu don, éy inumadene siya diya, monda meta na éng te bunga dén. Pero péketa na, éy don san dén i édsea diya, da éwan pabi panahun a mégbunga. ");
INSERT INTO dgc_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Kanya kinagi na to kayo, a “Ewan dén tu méngan ta bunga a gébwat diko, a hanggan!” Ey nabati du alagad na tu kinagi na. ");
INSERT INTO dgc_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Nadid, kédemét de ta Jerusalem éy sinomdép ti Jesus to Templo. Ey pinaibut na sa du mamugtong sakay du mégpabugtong. Sakay pinégpasakéb na du lamesa du mégpalit ta kuhata, sakay du pégeknuden du mégtinda ta palapati. ");
INSERT INTO dgc_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Sakay sinaway na du te kébil a dumiman to Templo. ");
INSERT INTO dgc_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Sakay tinolduan na du tolay, a kinagi na, a “Isip ko nabasa ta libru na Diyos a i bile na Diyos éy dulawén de a bile a panalanginan a para du étanan a tolay ta mundua. Ey bakit nadid, dahil dikam, kanya dulawén de a bile na mégdaya!” ");
INSERT INTO dgc_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ey du mataas a padi sakay du maistu ta rilihiyon, éy nabati de tu kinagi na. Kanya nagahayok side ta pagkékataon de a magpabuno ni Jesus. Méganteng side diya, da mégtaka du tolay ta pégtoldu naa. ");
INSERT INTO dgc_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ey ta éya a giapon éy hinumektat de Jesus ta banuwan. ");
INSERT INTO dgc_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Nadid, to kagagabian na, a méglakad de Jesus to dilan, éy natan-aw de tu kayo a igos, éy nalanés dén a hanggan to gimot na. ");
INSERT INTO dgc_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ey naala-ala ni Pedro tu kinagi ni Jesus to kayo. Ey kinagi na diya, a “Entan mo, Maistu; tu kayo a igos a nisumpa mo, éy minalanés dén!” ");
INSERT INTO dgc_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","“Tandaan moy,” kagi ni Jesus du alagad na, “éng méniwala kam ta Diyos, ");
INSERT INTO dgc_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","éy maari moy a utusan i buked yae a umibut sina a bumatikal ta diget. Eng éwan kam mégalanganin, sakay maniwala kam a manyari tu utus moy, éy manyari a talaga. ");
INSERT INTO dgc_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kanya maski anya i ipanalangin moya, éy maniwala kam a alapén moy, éy alapén moy a talaga i maski anya a agidén moy. ");
INSERT INTO dgc_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Pero éng ménalangin kam, éng te tolay a te kasalanan dikam, éy pagpasensiyaan moy pa, monda Tama moy ta langet, éy pagpasensiyaan na kam be ta kasalanan moy. ");
INSERT INTO dgc_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Eng éwan moy patawadén i iba a tolay, éy éwan kam be patawadén Nama moy ta kasalanan moy.” ");
INSERT INTO dgc_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nadid, sinomdép man dén de Jesus ta Jerusalem. Ey to péglakad ni Jesus to Templo, éy inumadene diya du te tungkulin a Judeo. ");
INSERT INTO dgc_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ey kinagi de diya, a “Anya i katungkulan mua a mégimet ta kona sina a gimet mo? Ti ésiya i nangatéda diko ta katungkulan mua a ina?” ");
INSERT INTO dgc_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ey kinagi ni Jesus, a “Pakelagipan ta kam be. Eng sengbiténék moy, éy kagin ko be dikam éng anya i katungkulan ko a mégimet ta éye a gimet ko. ");
INSERT INTO dgc_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ahe gébwat na katungkulana ni Juan a kanya nagbinyag siya--Diyos wade, o ta tolay?” ");
INSERT INTO dgc_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Nadid, du te tungkulin, éy méguhon-uhon side, éng anya i sengbet dia ni Jesus. “Eng kagin tam a gébwat ta Diyos i katungkulan ni Juan,” kagi de, “éy pégkagian na kitam a talaga éng bakit éwan kitam naniwala ni Juan. ");
INSERT INTO dgc_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Pero éng kagin tam a tolay san i nagutusa ni Juan, éy makay magingél dikitam didi tolay a éye.” Négkagi du te tungkulin ta kona sa da méganteng side du tolay, da kagi du tolay a purupeta ti Juan a gébwat ta Diyos i katungkulan naa. ");
INSERT INTO dgc_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kanya kinagi de ni Jesus, a “Ewan me tukoy.” Ey “Maari,” kagi ni Jesus, “da éwanék moy sinengbet, éy éwan ta kam be sengbitén éng anya i katungkulan ko a mégimet ta ginimet kua.” Du Judeo Du Purupeta ");
INSERT INTO dgc_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Nadid, négkagi ti Jesus du tolay ta halimbawa a kagi. “Eng mara,” kagi na, “éy te esa a lakay a nagmula ta ubas to uma na. Sakay kinudal na. Sakay nagkotkot siya ta ébut a pégégikan na ta ubas. Sakay nagbile siya ta pégbantayan na. Sakay nientarega na tu uma na du kahati na, sakay inumange siya ta iba a lugar. ");
INSERT INTO dgc_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Nadid, kédemét na panahun na pégpitas ta ubas, éy pinaange sa no lakay tu utusan na, a monda alapén na tu kabahagi na to bunga no ubas. ");
INSERT INTO dgc_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ey du kahati na, péketa de to utusan no amo de, éy binalbal de siya, sakay pinéglakad de siya a éwan tu kébil. ");
INSERT INTO dgc_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kanya tu lakay, éy pinaange na sa tu utusan na a esa. Pero du kahati na, éy linoko de be siya, a tinalengwan de tu ulo na. ");
INSERT INTO dgc_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ey pinaange man dén no lakay i esa pa a utusan na. Pero binunu de siya. Ey kona be sa tu ginimet de du iba a utusan no amo de a lakay. I sénganya éy binalbal de, sakay i iba éy binunu de. ");
INSERT INTO dgc_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Nadid, te minabuhay pabi tu lakay a isesa san dén a utusan; éy siya éy tu anak na a mahal na. Kanya i katapusana, éy pinaange na tu anak na to uma na. ‘Talaga a igalang de tu anak ko,’ kagi na. ");
INSERT INTO dgc_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Pero du kahati na, péketa de to anak na, éy kinagi de a ‘Siya i magmanaa; bunon tam dén, monda koo tam dén i lutaae a mana na.’ ");
INSERT INTO dgc_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Tulos dinikép de siya sakay binunu de. Sakay nibut de tu bangkay na to digdig no uma. ");
INSERT INTO dgc_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Ey nadid,” kagi ni Jesus, “anya i isip moya to lakay a te uma? Umange sa siya a talaga a bunon na diden ya a tolay, sakay ientarega na tu uma na ta iba a tolay! ");
INSERT INTO dgc_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ey nadid,” kagi ni Jesus, “anya i kahulugina na éya a halimbawa? Bakit, éwan moy bale pabi nabasa i éye a kagi ta kasulatan? ‘Tu bito kan a inidelan du mégbile, da isip de a éwan tu pasa, éy siya bale i mahalagaa a bito a panuluk na bile. ");
INSERT INTO dgc_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Saya i ginimet na Diyos, a saya i pagtakaan tama!’” ");
INSERT INTO dgc_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Nadid, du te tungkulin a Judeo, pékabati de ta éya, éy naisip de a side du kahati a pinégkagian ni Jesus to halimbawa. Kanya gustu de a dekpén ti Jesus. Pero inumanteng side du tolay. Kanya pinabayan de san siya, a hinumektat side ta éya. ");
INSERT INTO dgc_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Nadid, du te tungkulin a Judeo, éy pinaange de ni Jesus i sénganya a Pariseyo, sakay i sénganya a alagad ni Herod, monda puhubaan de siya, éng pagkamalién de maka siya ta kagi na. ");
INSERT INTO dgc_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","“Maistu,” kagi de, “tukoy me a matapat ka, a iyétoldu mo ta mahusay i gustu na Diyos a gemtén na tolay. Sakay éwan mo ugali a manuyu ta mataas a tolay, da éwan ka kumampi ta mataas a tolay. Nadid,” kagi de, “anya i isip mua? Labag wade ta utus tam éng bumuwes kitam ta hari ta Roma, o éwan?” ");
INSERT INTO dgc_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nadid, tukoy dén ni Jesus a pépuhubaan de san siya. Kanya kinagi na dide, a “Bakit gustu moy a magkamaliék? Dah, atdinanék moy ta esa a kuhata moy a pagbuwes.” ");
INSERT INTO dgc_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Nadid, to péngipeta de diya ta esa a plata, éy kinagi na dide, a “Kéˈ ni ésiya i éye a letrato, sakay kéˈ ni ésiya a ngahen i nakasulatae?” “Ey tu hari ta Roma,” kagi de. ");
INSERT INTO dgc_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","“Ey tama,” kagi ni Jesus. “Ey nadid, tu koo na hari ta Roma, éy iatéd moy diya. Pero tu para ta Diyos, éy iatéd moy ta Diyos.” Nadid, du Judeo sa, pékabati de ta éya a mahusay a sengbet ni Jesus, éy nagtaka side diya. ");
INSERT INTO dgc_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Nadid, éy inumange ni Jesus i sénganya a Saduseyo. (I Saduseyo, éy éwan side méniwala a mabuhay i tolay a huway.) ");
INSERT INTO dgc_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Maistu,” kagi de, “nisulat ni Moises i kona se: Eng mate kan tu lélake a te asawa, éy éwan pabi side tu anak, éy tu wadi na, éy dapat asawan na kan tu kayong na a bilo, monda magenak siya, para te anak tu aka na a minate. ");
INSERT INTO dgc_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Nadid, Maistu,” kagi de, “éy te pitu a pépétwadi a lélake to éya. Ey nangasawa tu panganay. Ey minate siya a éwan pabi tu anak. ");
INSERT INTO dgc_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kanya inasawa be no wadi na tu kayong na a bilo. Ey minate be siya a éwan pabi tu anak. Ey kona be sa tu ikatélo. ");
INSERT INTO dgc_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ey kona be sa a hanggan to ikapitu. Ey minate side a étanan a éwan pabi tu anak. Ey i katapusana éy minate be tu bébe. ");
INSERT INTO dgc_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","“Ey nadid, Maistu,” kagi du Saduseyo, “saye i gustu mia a mapospusan: Nitoldu mo a te buhay kan i tolay a huway. Eng talaga a kona sa, éy ti ésiya dide a pitu i maging asawa na ta kébuhay du tolay a huway, da inasawa de siya a étanan?” ");
INSERT INTO dgc_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ey kinagi ni Jesus dide, a “Mali kam a tahod, da éwan moy tukoy i kasulatan na Diyos, sakay éwan moy tukoy i kapangyarian na Diyos. ");
INSERT INTO dgc_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Dahilan ta kébuhay na tolay a huway, éy éwan dén maari a mangasawa side, da kapareho dén side du anghel ta langet. ");
INSERT INTO dgc_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ey sikam a Saduseyo,” kagi ni Jesus, “éy bakit isip moy a éwan mabuhay i tolay a huway? Ewan moy wade pabi nabasa tu kasulatan ni Moises, to kéharap na to kayo a mégdingat? Kinagi na Diyos ni Moises, a ‘Sakén i Diyos a péniwalaan ni Abraham, sakay ni Isak, sakay ni Hakob.’ ");
INSERT INTO dgc_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Kahulugina na éya, éy méniwala side nadid ta Diyos, maski minate side to araw, da buhay dén side nadid ta langet. Kanya mali kam!” kagi ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Nadid, i esa a maistu ta rilihiyon, éy neta na a mékipégpasuway side ni Jesus. Sakay neta na a mahusay tu sengbet ni Jesus dide. Kanya kinagi na diya, a “Maistu, ahe i mahalagaa a utus ta kasulatan na Diyos?” ");
INSERT INTO dgc_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ey kinagi ni Jesus, a “Saye i mahalaga a utus: ‘Tandaan moy, sikam a Israel; i Panginoon tam a Diyos, éy siya san i Panginoon ta étanan. ");
INSERT INTO dgc_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Dapat mahalén mo i Panginoon mo a Diyos ta mahigpit, a isipén mo siya a palagi.’ Saya i mahalagaa a utus. ");
INSERT INTO dgc_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Sakay tu ikaduwa a utus a kapareho na éy kagi na, a ‘Mahalén mo tu kapareho mo a kona ta pégmahal mo ta bégi mo.’ Ewan tu iba a utus a mas mahalaga diden ya a éduwa,” kagi ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nadid, tu maistu ta rilihiyon, éy kinagi na ni Jesus, a “Tama ngani, Maistu, tu kagi mo, a i Panginoon tam a Diyos, éy siya san i Panginoon ta étanan, da éwan tu iba a Diyos. ");
INSERT INTO dgc_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Sakay tama be tu kinagi mo, Maistu, a dapat mahalén na tolay i Diyos ta mahigpit, a isipén na siya a palagi. Sakay tama be tu kinagi mo, a dapat mahalén tam tu kapareho tam a kona ta pégmahal tam ta bégi tam. Diden ya a éduwa a utus,” kagi no maistu, “éy mas mahalaga a sundin tam ya kesira ta pégatang tam ta hayup a para ta Diyos, sakay ta iba a péngatéd tam ta Diyos.” ");
INSERT INTO dgc_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nadid, neta ni Jesus a mahusay i sengbita no maistu ta rilihiyon. Ey kinagi na diya, a “Adene ka bale dén a ipasakup ta Diyos.” Ey kétapus na éya, éy éwan tu nangahas a nagpakelagip ni Jesus a huway. Tungkul Ta Tagapagligtas ");
INSERT INTO dgc_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Nadid, to pégtoldu ni Jesus to Templo, éy te nipakelagip siya du tolay. “Du maistu ta rilihiyon,” kagi na, “éy bakit kagi de a tu tiniyak na Diyos a tagapagligtas éy ninuno siya ni Hari Dabid? ");
INSERT INTO dgc_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Pero dinulaw siya ni Dabid a amo na! Ey tu nagpakagi ni Dabid ta éya éy tu Banal a Espiritu. Da kinagi ni Dabid, a ‘Kinagi na Diyos to amo ko, a “Mégiknud ka ta tagirilan kuae a hanggan mapasuku ko diko du kalaban mo.”’ ");
INSERT INTO dgc_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Nadid ti Dabid, éy dinulaw na a amo na tu tagapagligtas. Eng kona sa, éy bakit kagi du maistu moy a ninuno siya ni Dabid?” Nadid du tolay, éy gustu de a bébaten ti Jesus. ");
INSERT INTO dgc_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ey to pégtoldu na, éy kinagi na dide, a “Mangilag kam du maistu ta rilihiyon. Gustu de a mégbihis ta memahal a badu, monda meta du tolay a mataas side. Sakay gustu de a saloduan side du tolay ta plasa na banuwan. ");
INSERT INTO dgc_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Sakay gustu de be a umeknud ta pégiknuden na mataas a tolay ta anyayaan, sakay ta kapilya. ");
INSERT INTO dgc_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Sakay ugali de be a ménalangin ta atakdug, monda isip du tolay a banal side. Pero éng te bébe a bilo, éy agiwén de san tu luta na. Kanya parusaan side na Diyos ta lalo a mahigpit!” ");
INSERT INTO dgc_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Nadid, to édsa ni Jesus to Templo, éy inumeknud siya to tapat no kahon a pégabuluyan. Ey te itan na du tolay a nitékneg de i kuhata to kahon. Neta na i meadu a mayaman a tolay a nitékneg de sa i meadu a kuhata. ");
INSERT INTO dgc_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ey nadid, éy neta na be i esa a bilo a bébe a pobri, éy nitékneg na sa i éduwa san a sentimos. ");
INSERT INTO dgc_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ey kinagi ni Jesus du alagad na, a “Entan moy i bilo yae. Tu nitékneg na sina to kahon a para ta Diyos, éy bilang mahigit pa to niabuluy du étanan a iba a tolay. ");
INSERT INTO dgc_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Dahilan du iba, éy niabuluy de ta Diyos tu sobha de san. Pero siya, maski pobri siya, éy niatéd na dén i étanan a kuhata na. Ewan siya tu buhay a pamugtong ta kabuhayan na.” ");
INSERT INTO dgc_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Nadid, kéhektat de Jesus to Templo, éy kinagi diya no alagad na a esa, a “Entan mo, Maistu, memahal a tahod i pader na Templuae. Sakay kamahalan i bile naa!” ");
INSERT INTO dgc_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ey “O,” kagi ni Jesus. “Pero i Templo a ina a te itan moy, éy dumemét i oras a éwan sina tu mabuhay a bito a te tupo ta kapareho na a bito ta dingding naa. Matibatibag side a étanan!” ");
INSERT INTO dgc_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Nadid, te eknud de Jesus ta buked na Olibo to tapat no Templo. Ey de Pedro, sakay ti Santiago sakay ti Juan sakay ti Andres, éy négkagi side ni Jesus ta lihim. ");
INSERT INTO dgc_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Maistu,” kagi de, “nikésiya i deméta na éya a kinagi mo? Anya wade i tandaa a monda mapospusan me a dumemét dén i éya a hirap?” ");
INSERT INTO dgc_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","“Mangilag kam,” kagi ni Jesus, “monda éwan kam pagkamalién na tolay. ");
INSERT INTO dgc_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Da te meadu a talaga a umange se a mégkagi a side i Cristo a tiniyak na Diyos a tagapagligtas ta mundua. Ey pagkamalién de i meadu a tolay. ");
INSERT INTO dgc_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Eng makabaheta kam ta meadu a gera, éy diyan kam métageg. Dumemét a talaga i meadu a gera, pero éwan ya tanda na katapusan. ");
INSERT INTO dgc_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Dahilan éy maglaban-laban du banubanuwan. Sakay te meadu a lindul ta iba-iba a lugar, sakay dumemét i meadu a alép. I étanan a éya éy sapul pabi na hirap a dumemét. ");
INSERT INTO dgc_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Pero sikam, éy mangilag kam. Da kédemét na éya a panahun éy itokyon de kam, sakay méngidimanda side dikam, sakay balbalén de kam ta kapilya de. Sakay tumaknég kam ta harap na gubernador sakay hari, da méniwala kam diyakén. Saya i oras moy a pégpatunay moy diyakén dide. ");
INSERT INTO dgc_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Dapat mepahayag ta étanan a tolay ta mundua i Mahusay a Baheta. ");
INSERT INTO dgc_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Eng dekpén de kam, sakay bistaan de kam,” kagi ni Jesus, “éy diyan kam métageg éng anya i katuwiran moya dide. Eng dumemét i éya a oras, éy basta kagi moy san i iatéd na Diyos a katuwiran moy. Da éwan sikam i mégkagia, éngˈwan i Banal a Espiritu i magpakagia dikam ta katuwiran moy. ");
INSERT INTO dgc_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Ta éya a panahun,” kagi ni Jesus, “éy itokyon na tolay du top de a ipabuno. Ey kona be sa i gemténa du lélake ta anak de. Sakay du anak éy labanan de be dema de, a ipabuno de be side. ");
INSERT INTO dgc_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Sakay kaiyamutan kam na étanan, da méniwala kam diyakén. Pero du maniwala diyakén a matapat a hanggan ta katapusan, éy meligtas side.” ");
INSERT INTO dgc_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Nadid,” kagi ni Jesus, “dumemét i oras a meta moy ta Templo tu kontara ta Diyos a mangsida. (Sikam a magbasa ta éye, éy isipén moy ye.) Péketa moy ta éya, du édse ta Hudea, éy dapat guminan side ta buked. ");
INSERT INTO dgc_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Sakay du édse ta luwas no bile de, éy diyan dén side sumésdép a mangalap ta kasangkapan de. ");
INSERT INTO dgc_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Sakay du édse ta uma éy diyan dén umuli a mangalap ta badu de. ");
INSERT INTO dgc_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kakakagbi du mabuktet sakay du te mabulol ta panahun a éya! ");
INSERT INTO dgc_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ipanalangin moy a éwan metaun i éya a kahirapan ta taglamig. ");
INSERT INTO dgc_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Dahilan ta panahun a éya,” kagi ni Jesus, “éy magdanas i étanan a tolay ta dikél a kahirapan. Ewan pabi nakekenaman na tolay i kona sa a hirap sapul to péglalang na Diyos ta mundua, a hanggan nadid. Pero éwan tu kéhuway i kona sa a panahun. ");
INSERT INTO dgc_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ey paseplutén san na Panginoon i éya a panahun, da éng éwan na paseplutén éy éwan tu mabuhay a tolay. Kanya paseplutén na, éy alang-alang du pinili na a tolay a sakup na. ");
INSERT INTO dgc_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Nadid,” kagi ni Jesus, “éng te mégkagi dikam, a ‘Kéye dén se tu tiniyak na Diyos a tagapagligtas,’ o te mégkagi, a ‘Kéye na dén sina,’ éy diyan kam méniwala. ");
INSERT INTO dgc_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Da te lumitaw ngani a kakabulyan a tolay, a kagi de a side i tiniyak na Diyos a tagapagligtas, sakay kagi du iba, a purupeta side a gébwat ta Diyos. Sakay ipeta de be i makataka-taka a tanda, monda lukoén de, éng maari, du méniwala ta Diyos. ");
INSERT INTO dgc_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mangilag kam, da kinagi ko dén ya dikam bagu dumemét.” ");
INSERT INTO dgc_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Nadid, ta éya a panahun, kétapus na éya a kahirapan,” kagi ni Jesus, “éy dumiklém i bilag sakay ta bulan, ");
INSERT INTO dgc_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","sakay matékneg i biton a gébwat ta langet, da mayégyég side. ");
INSERT INTO dgc_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Nadid, sakén a lélake a gébwat ta langet, éy metaék de ta kuném a dumibi ta lutaa a maghari, a kébil ko i kapangyarian ko. ");
INSERT INTO dgc_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Tulos paangen ko du anghel ko ta maski ahe ta mundua, a hanggan ta langet, monda tipunén de du étanan a sakup ko a tolay.” ");
INSERT INTO dgc_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Isipén moy i kahulugina na halimbawaae na kayo a igos,” kagi ni Jesus. “Bagay mégogbus i tingi-tingi na, éy tukoy moy a adene dén i késinag. ");
INSERT INTO dgc_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Nadid, kona be sa, bagay meta moy i étanan a éya a nihula ko, éy tukoy moy dén a adene dén i kédemét ko--a mégsapul dén. ");
INSERT INTO dgc_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Tandaan moy, manyari pa i étanan a éya bagu mate i étanan a tolay a buhay nadid. ");
INSERT INTO dgc_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Maibut i langet éy ta lutaa, pero i kagi ko éy éwan maibut.” ");
INSERT INTO dgc_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Pero éwan tu nakapospos ta oras na kédemét na éya. Maski du anghel ta langet, maski sakén a anak na Diyos--basta Tama ko san i nakapospusa ta éya. ");
INSERT INTO dgc_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kanya sikam, éy bantayan moy, da éwan moy tukoy éng nikésiya i deméta na éya. ");
INSERT INTO dgc_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“I kédemét ko, éy kona se,” kagi ni Jesus. “Eng mara, te lélake a méglakad ta adeyo. Ey ta péglakad na, éy atdinan na pa i bawat esa a tauhan na ta tungkulin de a tarabaho de. Sakay ibilin na to mégbantay a dapat magbantay siya ta mahigpit. ");
INSERT INTO dgc_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Kanya sikam,” kagi ni Jesus du alagad na, “éy bantayan moy, da éwan moy tukoy éng nikésiya i demét kua--éng giapon, éng kélép, éng amulaldew, o éng gagabi. ");
INSERT INTO dgc_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","37","Mangilag kam, makay bigla i demét kua, a makay demtan ta kam a tidug. Saye i bilin kua du étanan a tolay: bantayan moy!” ");
INSERT INTO dgc_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nadid, éduwa a aldew bagu Piyesta na Ala-ala, sakay piyesta a péngan de ta melapis a tinapay. Ey du mataas a padi, sakay du maistu ta rilihiyon éy néguhunan de a ipadikép ti Jesus ta lihim, sakay ipabunu de. ");
INSERT INTO dgc_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","“Pero éwan nadid a piyesta,” kagi de; “makay maligalig du tolay.” ");
INSERT INTO dgc_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Nadid, édsa ti Jesus ta Betania, to bile ni Simon a te ketong to araw. Ale na a méngan sa, éy inumange sa i esa a bébe a te kébil a boti a putat ta pabango a memahal. Siya éy binukasan na tu boti, sakay nibulak na to ulo ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ey du sénganya a tolay sa, péketa de ta éya, éy nagingél side. “Bakit,” kagi de, “sayang dén i pabangua! ");
INSERT INTO dgc_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nibugtong mo maka ina ta mahigit pa ta étélo a datos a kuhata, sakay niatéd mo du mahirap i kabugtungan naa.” Kona sa i pégpintas dia to bébe. ");
INSERT INTO dgc_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Pero kinagi ni Jesus dide, a “Pabayan moy siya. Bakit péginglan moy siya? Mahusay i gimet na diyakén. ");
INSERT INTO dgc_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Palagi a kaguman moy du mahirap,” kagi ni Jesus, “maski nikésiya éy makatulung kam dide. pero sakén éy éwan, da éwanék male a kaguman moy. ");
INSERT INTO dgc_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Gemtén na dén i kaya na a para diyakén. Nibulak na dén ya diyakén da iduwel na diyakén, da ielbéngék dén. ");
INSERT INTO dgc_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ey tandaan moy, maski ta ahe i pégtolduan dia ta Mahusay a Baheta, éy ipaala-ala de be i ginimita na éye a bébe diyakén.” ");
INSERT INTO dgc_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Nadid ti Hudas Iskarote, a esa du labindalawa a alagad, éy inumange siya du mataas a padi, a monda itokyon na ti Jesus dide. ");
INSERT INTO dgc_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ey du padi, pékabati de to kagi na, éy mésahat side. Ey kinagi de diya a atdinan de siya ta kuhata. Ey sapul ta éya, éy mégisip dén ti Hudas ta oras a péngitokyon na ni Jesus dide. ");
INSERT INTO dgc_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Nadid, kédemét na oras no piyesta a péngan de ta melapis a tinapay, éy saya i oras de a mégbuno ta tupa. Ey du alagad ni Jesus, éy kinagi de diya, a “Ahe i paghandaan me ta péngapon tam nadid a Piyesta na Ala-ala?” ");
INSERT INTO dgc_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ey inutusan na i éduwa a alagad na, a kinagi na dide, a “Umuli kam ta banuwan. Ey ta éya éy kasambat moy i esa a lélake a te kébil a dinom. Basta kumuyog kam diya ");
INSERT INTO dgc_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ta bile de. Sakay kagi moy to te bile ta éya, a ‘Tu Maistu me éy gustu na a mapospusan éng ahe i kuwarto a péngaponan me ta Piyesta na Ala-ala.’ ");
INSERT INTO dgc_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Eng kagin moy diya i éya,” kagi ni Jesus, “éy ipeta na dikam tu kuwarto ta ontok a nakahanda dén. Ey saya i paghandaan moya ta pangapon tam.” ");
INSERT INTO dgc_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Nadid, to pégkagi dén ni Jesus ta éya, éy inumuli dén tu éduwa ta banuwan. Ey nanyari tu étanan a kinagi ni Jesus dide. Ey naghanda sa side ta péngapon de a para ta Piyesta na Ala-ala. ");
INSERT INTO dgc_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nadid, to kélép a éya, éy dinumemét sa ti Jesus, a kaguman na du alagad na a labindalawa. ");
INSERT INTO dgc_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ey to péngan de, éy kinagi ni Jesus, a “Tandaan moy, esa dikam i méngitokyon diyakén. I esa dikam a mékidipon ta éye nadid.” ");
INSERT INTO dgc_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ey du alagad, pékabati de ta éya, éy nalungkut side, a kinagi na bawat esa dide, a “Besa a sakén!” ");
INSERT INTO dgc_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ey kinagi ni Jesus, a “Ewan tu iba, éngˈwan i esa dikam a labindalawa. Tu kasabay ko a néngisawsaw ta tinapay ta sabawae,” kagi na, “éy siya i méngitokyona diyakén. ");
INSERT INTO dgc_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Kailangan a mateék ayun to nisulat du purupeta to araw, pero kagbi tu méngitokyon diyakén! Maigi pa éy éwan dén nienak.” ");
INSERT INTO dgc_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nadid, to péngan de, éy inalap ni Jesus tu kanén de a tinapay, éy to pégpasalamat na ta Diyos, éy pinuseng-puseng na a nitagtag na du alagad na. “Kanén moy dén ye,” kagi na, “a saye i bégi kua.” ");
INSERT INTO dgc_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Nadid, inalap na tu tasa a te lasén a alak. Ey to pégpasalamat na dén, éy nigewat na dide, éy ininom de a étanan. ");
INSERT INTO dgc_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ey kinagi na dide, a “Saye i dige kua, a saye i tanda na pangako na Diyos. Ey mebulak alang-alang ta meadu a tolay. ");
INSERT INTO dgc_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ey tandaan moy, éwanék dén uminom ta alak, éng éwanék uminom ta bigu a alak ta kaharian na Diyos.” ");
INSERT INTO dgc_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nadid, to pégkanta de ta kanta ta Diyos, éy naglakad dén side ta buked na Olibo. Siya Ni Pedro ");
INSERT INTO dgc_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Nadid, kinagi ni Jesus du alagad na, a “Talaga a ginananék moy a étanan, da nisulat du purupeta to araw, a ‘Ta ipagpabuno na Diyos to Pastor, éy matibuhahak du tupa.’ ");
INSERT INTO dgc_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pero ta kébuhay ko a huway,” kagi ni Jesus, “éy meditulék dikam ta Galilea.” ");
INSERT INTO dgc_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Nadid, kinagi ni Pedro, a “Sakén, éy éwan ta ka ginanan, maski ginanan ka du iba.” ");
INSERT INTO dgc_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","“Ewan, Pedro,” kagi ni Jesus, “da tandaan mo, nadid a kélép, bagu magtarakot i tandang ta pénduwa, éy itanggiék mo ta péntélo a éwanék mo kaguman.” ");
INSERT INTO dgc_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","“Ewan,” kagi ni Pedro, “maski mateék a kaguman mo éy éwan ta ka itanggi!” Ey kona be sa i kinagia du étanan a alagad. ");
INSERT INTO dgc_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nadid, éy inumange de Jesus ta Getsemani. Ey kinagi ni Jesus du alagad na, a “Mégiknud kam pa se, a umangeék sinae a manalangin.” ");
INSERT INTO dgc_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","I kaguman na sana éy de Pedro san, sakay ti Santiago sakay ti Juan. Ey métegeg ti Jesus. ");
INSERT INTO dgc_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ey kinagi na dide, a “Métagigék tu isip, a komanék i mate. Maguhay kam se a mékipagpuyat kam.” ");
INSERT INTO dgc_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nadid, kéadeyo na ta kétihék, éy dinumapa siya a nanalangin a éng maari éy malipas san diya i hirap na a dumemét. ");
INSERT INTO dgc_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“Améng,” kagi na, “maari ka a magimet ta maski anya. Iadeyo mo pad diyakén i paghirap ko. Pero éwan na kaluuben kua i masunuda, éngˈwan na kaluuben mo i masunud.” ");
INSERT INTO dgc_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Nadid, késoli na éy dinemtan na a tidug du étélo a alagad. Ey kinagi na ni Pedro, a “Simon, tidug kam bale! Ewan kam beman makapagpuyat a maski esa a oras a kaguman ko? ");
INSERT INTO dgc_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Magpuyat kam sakay manalangin kam, monda éwan kam madaig na mangpuhuba dikam. Méniwala kam diyakén ta isip moya, pero i bégi moya éy mehina.” ");
INSERT INTO dgc_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nadid, huway siya a inumadeyo dide a manalangin a huway ta pareho san a kagi. ");
INSERT INTO dgc_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Sakay sinumoli siya dide a huway, a dinemtan na man dén side a tidug, da mégtongka side a tahod. Ey éwan side tu kagi diya, da mésanike side. ");
INSERT INTO dgc_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Huway man dén siya a manalangin, éy késoli na dide ta pentélo, éy kinagi na dide, a “Tidug kam bale pabi! Tama dén. Dumemét dén i oras a péngitokyon de diyakén du makasalanan a tolay. ");
INSERT INTO dgc_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Nay, umikat kam dén a kitam dén. Dumemét dén tu méngitokyon diyakén.” ");
INSERT INTO dgc_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Nadid, to pégkagi pabi ni Jesus, éy dinumemét dén ti Hudas, tu esa du labindalawa. Te kaguman siya a meadu a tolay a gébwat side du te tungkulin a Judeo. Ey te kébil side a sondang éy ta gahoti. ");
INSERT INTO dgc_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Bagu pa side dinumemét ta éya, éy kinagi dén ni Hudas dide a atdinan na side ta tanda, monda matukoy de ti Jesus. “Tu ahoben ko,” kagi na, “éy siya i dekpén moya, a iange moy du amo moy.” ");
INSERT INTO dgc_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Kanya nadid, éy inumadene ti Hudas ni Jesus, a binati na siya, a tulos na inahoben. ");
INSERT INTO dgc_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ey du kaguman ni Hudas, éy tulos dinikép de ti Jesus. ");
INSERT INTO dgc_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ey tu kaguman ni Jesus a esa, éy binagut na tu sondang na, a tinegpas na tu utusan no mataas a padi, a minahipas i talinga naa. ");
INSERT INTO dgc_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Nadid, kinagi ni Jesus du tolay sa a nanikép diya, a “Bakit te armas kam a sondang éy ta kayo a panikép diyakén? Ataay, tulisan ék beman a metapang? ");
INSERT INTO dgc_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Aldew-aldew éy mégtolduék ta Templo. Bakit éwanék moy sa dinikép? Pero sigi kam dén, monda matupad tu nihula du purupeta ta kasulatan na Diyos.” ");
INSERT INTO dgc_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ey to pégkagi ni Jesus ta éya, éy gininanan siya du alagad na. ");
INSERT INTO dgc_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Nadid, to péngiange de ni Jesus ta banuwan, éy te esa a lélake a nangtonod-tonod dide, a te alikébkéb san a damit. Ey neta de siya, a talaga de siya a dekpén. ");
INSERT INTO dgc_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Pero to péngkébil de diya, éy pinabayan na tu damit na, a ginuminan dén a uba. Te Tungkulin a Judeo ");
INSERT INTO dgc_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Nadid, éy nitugén de ti Jesus to bile no mataas a padi. Ey napisan dén sa du étanan a te tungkulin a Judeo. ");
INSERT INTO dgc_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ey tinumagubet dide ti Pedro ta éya. Ey tulos sinomdép be siya to karsada no bile. Sakay inumeknud sa siya a kaguman na du guwardia, a nékipagdengdeng siya to apoy de. ");
INSERT INTO dgc_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Nadid, du mataas a padi sakay du te tungkulin a Judeo, éy mégahayok pabi side ta magsistigu ta kakabulyan a kontara ni Jesus, monda te katuwiran side a ipabuno siya. Pero éwan side tu meeta, ");
INSERT INTO dgc_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","da maski meadu a kaharap a mégkagi ta kakabulyan tungkul diya, éy éwan paripareho i abla dia. ");
INSERT INTO dgc_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Tinumaknég i sénganya dide, a kinagi de, a ");
INSERT INTO dgc_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nabati me i ina a lélake a négkagi a maari na kan a hukatén i Templo na Diyos a ginimet na tolay, sakay huwayén na kan a pataknégén ta étélo san a aldew; sakay éwan kan tulungan na tolay.” ");
INSERT INTO dgc_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pero pati tu abla de éy éwan paripareho. ");
INSERT INTO dgc_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nadid, tinumaknég tu mataas a padi, a kinagi na ni Jesus, a “Ewan ka beman tu isengbet di mégpehaya diko?” ");
INSERT INTO dgc_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Pero te ginék san ti Jesus, a éwan siya sinumengbet diya. Ey kinagi diya no mataas a padi a huway, a “Anya, kagi mo dén éng siko a talaga i anak na Diyos. Ikagi mo éng siko i Cristo a tiniyak na Diyos a tagapagligtas ta tolay ta mundua.” ");
INSERT INTO dgc_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ey “O,” kagi ni Jesus, “sakén ngani dén ya. Ey sikam éy metaék moy a mégiknud a magdatig kame ta Diyos, a kagumanék na a maghari. Sakén i lélake a gébwat ta langet. Sakay metaék moy a dumemét a édseék ta kuném ta langet.” ");
INSERT INTO dgc_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Nadid, pékabati no padi ta éya, éy pinéknet na tu badu na a sarili, a kinagi na, a “Méglapastangan siya ta Diyos! Mégwari-wari siya a anak na Diyos! Bakit kailangan tam pa a mégbati du magsistigu diya ta kasalanan na? Da nabati tam dén nadid i pégkagi na a kontara ta Diyos! Anya i isip moya?” kagi na. Ey du mégbati to kagi no padi, éy kagi de a étanan a dapat mate siya. ");
INSERT INTO dgc_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Nadid, i sénganya dide, éy linoktaben de tu mata ni Jesus. Sakay tinaklében de tu mata na to damit, sakay sinésuntuk de siya, a kinagi de diya, a “Nay, tukuyan mo éng ti ésiya i nanuntuka diko!” Sakay du guwardia ta éya, éy sinésapuk de siya. ");
INSERT INTO dgc_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Nadid, édse pabi ti Pedro to karsada no bile. Ey tu esa a bataan no padi, ");
INSERT INTO dgc_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","péketa na ni Pedro a mégdengdeng, éy te itan na siya, sakay kinagi na, a “Siko bale i kagumana ni Jesus a taga Nasaret!” ");
INSERT INTO dgc_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pero nitanggi ni Pedro. “Ewan ko tukoy tu kagi mo,” kagi na. Ey minabukod dén ti Pedro to kudal to karsada, tulos nagtarakot i tandang. ");
INSERT INTO dgc_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Mamaya-maya éy neta man dén siya no bataan, tulos kinagi na du édsa sa, a “Siya ngani i kaguman na a esa.” ");
INSERT INTO dgc_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pero nitanggi man dén ni Pedro. Mamaya-maya man dén, éy du tolay sa éy kinagi de ni Pedro, a “Diyan ka sumuway. Siko i kaguman na a esa, da taga Galilea ka be.” ");
INSERT INTO dgc_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","“Bakén a sakén,” kagi ni Pedro, “isumpa ko! Parusaanék na Diyos éng mégbuli-buliék! Ewan ko tukoy i éya a lélake a kékagin moy!” ");
INSERT INTO dgc_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Nadid, to pégkagi ni Pedro ta éya, éy bigla a nagtarakot tu tandang ta penduwa. Ey naala-ala ni Pedro tu kinagi ni Jesus diya, a “Bagu magtarakot tu tandang ta penduwa, éy itanggiék mo ta pentélo.” Ey to pékaala-ala na ta éya, éy tulos minagsanget siya ta mahigpit. ");
INSERT INTO dgc_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Nadid, to gagabi dén, éy nagmiting du te tungkulin a Judeo, sakay néguhunan de éng pakodyan de ti Jesus. Ey nipagapus de siya sakay niange de ni Gubernador Pilato. ");
INSERT INTO dgc_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ey kinagi ni Pilato diya, a “Siko bale i haria na Judeo?” Ey “O,” kagi ni Jesus, “kona to kinagi mo.” ");
INSERT INTO dgc_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ey nadid, da pinehayan siya du mataas a padi ta meadu a kasalanan, ");
INSERT INTO dgc_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","éy kinagi ni Pilato diya, a “Meadu i iyépehay dia diko! Anya i katuwiran mua?” ");
INSERT INTO dgc_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pero éwan sinumengbet ti Jesus. Ey nagtaka ti Pilato. ");
INSERT INTO dgc_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Nadid, tuwing piyesta, éy ugali ni Pilato a magpaluwas ta isesa a pihesu, maski ti ésiya i gustu du tolay. ");
INSERT INTO dgc_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ey nadid éy édsa dén to pégpihesuan i esa a lélake a nakabuno, a ti Barabas i ngahen naa. Siya éy kaguman na du iba a tolay to péngligalig de ta banuwan. ");
INSERT INTO dgc_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nadid, dinumulug du tolay ni Pilato, a mékiohon side diya a dapat paluwasén na i esa a pihesu. ");
INSERT INTO dgc_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ey kinagi ni Pilato, a “Gustu moy a paluwasén ko dikam tu hari na Judeo?” ");
INSERT INTO dgc_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Tukoy dén ni Pilato a du padi éy nitugén de ti Jesus diya da ménaghili side diya. ");
INSERT INTO dgc_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Nadid, du mataas a padi, éy pinégkagian de dén du tolay, a i pékiohon dia ni Pilato éy paluwasén na ti Barabas kesira ni Jesus. Ey to pékiohon de ni Pilato ta éya, ");
INSERT INTO dgc_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ey kinagi na dide, a “Eng kona sa, éy anya i gemtén kua to lélake a ngéngahinan moy a hari na Judeo?” ");
INSERT INTO dgc_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","“Ipako mo siya ta kudos,” kagi de. ");
INSERT INTO dgc_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","“Ey bakit,” kagi ni Pilato; “anya i kasalanan naa?” Pero du tolay, éy lalo de san a nidulaw, a “Ipako mo siya ta kudos!” ");
INSERT INTO dgc_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Nadid ti Pilato, éy gustu na a mékisuyu siya du tolay. Kanya pinaluwas na ti Barabas dide. Sakay nipabalbal na ti Jesus, a tulos niatéd na du sundalu, monda ipako de ta kudos. ");
INSERT INTO dgc_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Nadid du sundalu, éy niange de ti Jesus ta lubuk no bile no gubernador, sakay pinadulug de sa du étanan a sundalu. ");
INSERT INTO dgc_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Sakay sinolotan de ti Jesus ta badu a medideg, da saya i kolor na damit na hari. Sakay nagkawekaw side ta lanot a meset, a nisoklop de to ulo na, a kurona na kan. ");
INSERT INTO dgc_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Sakay sinumalodu side diya, a kinagi de, a “Mabuhay i hari na Judeo!” ");
INSERT INTO dgc_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Sakay pinépakol-pakol de siya, sakay linéloktaben de siya, sakay linumuhud side diya. ");
INSERT INTO dgc_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ey nadid, kétapus de a nangloko diya, éy inibutan de tu badu na a medideg, sakay pinabaduan de man dén to sarili na a damit. Sakay pinaluwas de siya a ipako ta kudos. ");
INSERT INTO dgc_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Nadid, to péglakad de, éy nasambat de i esa a lélake a somdép ta banuwan; éy pinilit siya du sundalu a minangbékle to kudos ni Jesus. I ngahen no lélake éy ti Simon a taga Sirene. Siya tu ama ni Alehandro sakay ti Rupus. ");
INSERT INTO dgc_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ey niange de ti Jesus to lugar a ngéngahinan de a Golgota (a i kahulugen na éy Bungu). ");
INSERT INTO dgc_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ta éya éy inatdinan de ti Jesus ta alak a te halu a gamot. Pero inidelan na. ");
INSERT INTO dgc_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ey nipako de siya to kudos. Sakay nagpalabunutan side a hinati-hati de tu damit na, éng ti ésiya i makaalapa ta bawat piraso. ");
INSERT INTO dgc_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","To péngipako de diya, éy alas nuwebe dén na gagabi. ");
INSERT INTO dgc_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Sakay te sulat to kudos a te kagi to abla de diya. I kagi naa éy “TU HARI NA JUDEO.” ");
INSERT INTO dgc_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ey nipako de be sa i éduwa a tulisan a kasabay ni Jesus, a nitolnék de side ta magtembang a tagirilan ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Nadid, du sumésalegéd sa, éy dinédusta de ti Jesus, a kinagi de, a “Hala! Siko bale i manghukata ta Templo, sakay ipataknég mo a huway ta étélo san a aldew! Bakit éwan mo iligtas nadid i bégi mua. ");
INSERT INTO dgc_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Nay, umogsad ka dén ta kudusa!” ");
INSERT INTO dgc_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ey kona be sa du mataas a padi, éy pinintasan de be siya, a kinagi de, a “Entan moy, niligtas na kan du iba. Pero i bégi naa éy éwan na meligtas. ");
INSERT INTO dgc_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Eng Cristo siya, a hari na Judeo, éy bakit éwan siya umogsad ta kudusa, monda meta tam a maniwala kitam diya?” Sakay pati du éduwa a kasabay na a nipako, éy dinédusta de be siya. ");
INSERT INTO dgc_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Nadid, kédemét na tanghali, éy nagdiklém a hanggan to alas tres. ");
INSERT INTO dgc_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ey to alas tres dén, ey kinagi ni Jesus ta medegsén, a “Eloi, Eloi, lema sabaktani,” a i kahulugen naa, éy “Diyos ko! Diyos ko! Bakit pinabayanék mo?” ");
INSERT INTO dgc_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ey du sénganya a te taknég sa, éy akala de a dédulawan na ti Purupeta Eliyas. ");
INSERT INTO dgc_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ey minaginan i esa dide a nangalap ta damit, sakay nibisa na to tuba, sakay niedton na ta ontok no kayo, sakay nipasépsép na ni Jesus. Sakay kinagi na, a “Entan tam pa éng dumemét ti Eliyas a méngiogsad diya ta kudusa.” ");
INSERT INTO dgc_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Nadid, éy dinumulaw ti Jesus, a tulos nabégsot i angés naa. ");
INSERT INTO dgc_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ey nadid, tu kortina a dikél ta lubuk no Templo, éy bigla a minapéknet sapul ta ontok a hanggan ta sidung. ");
INSERT INTO dgc_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Sakay tu kapitan du sundalu, éy te taknég san siya ta harap no kudos. Ey péketa na éng kodya a minate ti Jesus, éy kinagi na, a “Tunay bale ye a anak na Diyos!” ");
INSERT INTO dgc_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nadid, éy édsa be sa i sénganya a bébe a mégtan-aw. Kabilang dide éy ti Maria Magdalena, sakay ti Maria a ina no kétihék a Santiago, sakay ni Hose, sakay ni Salome. ");
INSERT INTO dgc_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Side du kakaguman ni Jesus to édse na pabi ta Galilea, a side i katulung naa. Sakay te meadu be a iba a bébe ta éya, a kinumuyog ni Jesus ta Jerusalem. ");
INSERT INTO dgc_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Nadid, i éya a aldew éy disperas. Ta gabia éy pangilin na Judeo. Ey to giapon, ");
INSERT INTO dgc_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","éy dinumemét sa ti Hose a taga Arimatea. Siya éy sakup du konsiyal na Judeo, a iyégalang siya du tolay. Sakay inumasa be siya ta kédemét na Diyos a maghari. Ey nadid éy éwan siya mésanike a umange ni Pilato a mékiohon diya éng makaalap siya to bangkay ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ey pékabati ni Pilato ta éya, éy isip na a makay buhay pabi ti Jesus. Kanya pinauwet na tu kapitan du sundalu, a nipakelagip na diya éng talaga a minate dén ti Jesus. ");
INSERT INTO dgc_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ey to pékabaheta na to kapitan a minate ngani dén, éy pinakultaden na ti Hose a umange mangalap to bangkay na. ");
INSERT INTO dgc_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ey namugtong pa ti Hose to manta a damit a pagsapot. Sakay pineogsad na dén tu bangkay to kudos, sakay sinaputan na to manta, sakay nielbéng na siya to kuweba a ginimet de to pader. Sakay nigulung de tu bito a nitakléb de to pintuan no lébéng. ");
INSERT INTO dgc_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ey ti Maria Magdalena sakay ti Maria a ina ni Hose, éy neta de tu néngielbéngan dia. ");
INSERT INTO dgc_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Nadid, kélipas no pangilin, ti Maria Magdalena, sakay ti Maria a ina de Santiago, sakay ti Salome, éy namugtong side ta don a mesépot, a monda ipahid de to bangkay ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ey nadid, to simba dén a amulaldew, éy inumange side to lébéng. ");
INSERT INTO dgc_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Habang méglakad side éy péguhunan de, a “Ti ésiya wade i maakit tama a méngigulung to bito a takléb no pintuan?” kagi de, ");
INSERT INTO dgc_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","“da medégi.” Ey kédemét de sa, éy neta de a negulung dén tu bito. ");
INSERT INTO dgc_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tulos sinomdép side to lébéng. Ey neta de sa i esa a lélake a te eknud sa, a melélatak i badu naa. Ey méganteng side. ");
INSERT INTO dgc_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","“Diyan kam méganteng,” kagi no lélake. “Tukoy ko a ahayukén moy ti Jesus a taga Nasaret, siya a nipako de. Pero éwan se siya, da nabuhay dén! Entan moy i lébéng naa, a éwan se siya. ");
INSERT INTO dgc_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nadid,” kagi na, “éy ange moy pégkagian du alagad na, sakay ti Pedro be, a nabuhay dén siya, a magdetol siya dikam ta Galilea. Ey meta moy siya ta éya, a kona to kinagi na dikam.” ");
INSERT INTO dgc_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ey du bébe, pékabati de ta éya, éy ginuminan side a linumuwas to lébéng, da méganteng side a tahod. Ey éwan side négkagi ta maski ti ésiya to mineta de, dahil to anteng de. ");
INSERT INTO dgc_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Nadid, to kébuhay ni Jesus to simba a gagabi, éy pinumeta pa siya ni Maria Magdalena. Siya tu bébe a inibutan ni Jesus ta pitu a dimonyo. ");
INSERT INTO dgc_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Sakay siya, éy inumange négkagi ta éya du iba a alagad ni Jesus. Dinemtan na side a mégsanget. ");
INSERT INTO dgc_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ey pékabati de to kagi no bébe, a neta na ti Jesus a buhay dén, éy éwan side naniwala diya. ");
INSERT INTO dgc_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ey kétapos na éya, éy pinumeta man dén ti Jesus ta éduwa a alagad na a iba to péglakad de to dilan. Ey iba dén i idsura naa. ");
INSERT INTO dgc_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ey side, éy nagsoli side a négkagi du iba. Pero éwan be side naniwala dide. ");
INSERT INTO dgc_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Katapusana, éy pinumeta ti Jesus du sapulu éy ta esa a alagad na to péngan de. Ey pinégkagian na side, da éwan side naniwala diya, sakay éwan side naniwala du nagbaheta dide a buhay dén siya. ");
INSERT INTO dgc_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Sakay kinagi na dide, a “Umange kam ta maski ahe ta mundua, sakay magpahayag kam ta Mahusay a Baheta ta étanan a tolay. ");
INSERT INTO dgc_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","I maski ti ésiya a maniwala, a tulos ipabinyag, éy meligtas side. Sakay du éwan maniwala, éy hukumén side na Diyos. ");
INSERT INTO dgc_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","“Ey saye du tanda a édse du méniwala diyakén,” kagi ni Jesus; “makapagpaibut side du dimonyo ta pamag-itan na ngahen kua. Sakay mégkagi side ta iba-iba a kagi a éwan mapospusan na tolay. ");
INSERT INTO dgc_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Sakay éng kébilan de i ulag, o éng inumén de i lasun, éy éwan side maanya. Sakay éng itupu de tu kamét de du te ladu, éy maghusay side.” ");
INSERT INTO dgc_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nadid, to pégkagi ni Jesus dide, éy inumontok siya ta langet, a kaguman na dén sa i Diyos a méghari. ");
INSERT INTO dgc_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ey du alagad éy inumange dén side ta iba-iba a banubanuwan, a nagpahayag ta kagi na Diyos. Ey inaguman side na Panginoon. Nagpatunay siya du tolay a katutuhanan tu nipahayag de, da inatdinan na side ta tanda a makapangyarian. ");
INSERT INTO dgc_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Mahal ko a Teopilo: Meadu dén i tolay a néngisulat tungkul to ginimet ni Jesus, to pégiyan na dikitam ta mundua. ");
INSERT INTO dgc_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","I nisulat dia éy tu nibaheta du kakaguman ni Jesus dikitam. Side du minaketa to ginamet ni Jesus, a tulos néngipahayag side ta éya a Mahusay a Baheta. ");
INSERT INTO dgc_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kanya nadid, Apo Teopilo, éy inisip ko a mahusay éng isulat ko nadid diko i tama a baheta tungkul ta éya, da sakén éy inadal ko i éya sapul to sapul na. ");
INSERT INTO dgc_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Kanya isulat ko nadid i éye diko, monda mapospusan mo ta mahusay i buu a katutuhanan tungkul to nabaheta mo dén a ginimet ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Nadid, to panahun ni Hari Herod ta Israel, éy te esa a padi, a ti Sakarias i ngahen naa. Sakup siya du padi a ngéngahinan de a Abias. Tu asawa na éy ti Elisabet, a lahi be siya du padi, da apo be siya ni Padi Aron to araw. ");
INSERT INTO dgc_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Mahusay a ugali ta mata na Diyos diden ya a pasawa, a sésundin de ta mahusay i utus na Diyos. ");
INSERT INTO dgc_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pero éwan side tu anak, da baug dén ti Elisabet, sakay matanda dén side a pasawa. ");
INSERT INTO dgc_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nadid, to esa a aldew, éy te nanyari ni Sakarias. Ta éya a aldew, éy édse dén siya ta Templo, a ginamet na i tarabaho na padi, da kalewas siya no kagurupu na a tagapanalangin ta éya. ");
INSERT INTO dgc_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ey nadid, ayun ta ugali du padi, éy nagpalabunutan side éng ti ésiya dide i somdépa ta Templo a mégsuub ta Diyos. Ey ta éya a aldew, éy ti Sakarias i nakabunuta. Kanya siya dén i sinomdépa. ");
INSERT INTO dgc_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ey du iba a tolay, éy nawahak side ta luwas, a nanalangin side ale ni Sakarias a mégsuub ta lubuk. ");
INSERT INTO dgc_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Nadid, mégsuub pabi ti Sakarias, éy pinumeta diya i esa a anghel a gébwat ta Diyos, a te taknég siya ta giled no lamesa a pégsuuben. ");
INSERT INTO dgc_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","To péketa ni Sakarias to anghel, éy inumanteng siya. ");
INSERT INTO dgc_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pero kinagi diya no anghel, a “Diyan ka méganteng, Sakarias. Nabati dén na Diyos tu panalangin mo diya. Mangilog a talaga tu asawa mo, a magenak siya ta lélake. Ey ta kéenak na, Sakarias,” kagi na, “éy ngahinan mo siya ni Juan. ");
INSERT INTO dgc_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Siya i kasahatan moya, sakay te meadu be a iba a tolay a masaya diya! ");
INSERT INTO dgc_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Siya i maging memahal a lélake ta mata na Diyos,” kagi no anghel. “Ey kailangan éwan siya maginom ta maski anya a kélasing. Ey sapul ta kéenak na, éy édse diya i Banal a Espiritu. ");
INSERT INTO dgc_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Siya éy pasolen na i meadu a Judeo ta Panginoon de a Diyos. ");
INSERT INTO dgc_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Utusan siya na Diyos, Sakarias,” kagi na, “a te kapangyarian siya a kapareho ni Purupeta Elias to araw. Pagkasunduén na du patena, sakay pagbaguén na i isip du masuwayin, monda umaheg side du tolay a mahusay. Mégdetol siya ni Cristo, a paghandaén na du tolay ta demtan na.” ");
INSERT INTO dgc_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","“Pakodyan ko a mapospusan éng katutuhanan i éya a kinagi mo,” kagi ni Sakarias, “da lakayék dén, sakay bakés be dén tu asawa ko?” ");
INSERT INTO dgc_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","“Ti Gabrielék,” kagi no anghel. “Kagumanék na Diyos, a siya i nagpaangea se diyakén a mégkagi diko ta éya a mahusay a kagi. ");
INSERT INTO dgc_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pero siko, Sakarias, da éwan ka méniwala diyakén, a matupad a talaga i éya a kinagi ko, éy maging bulol ka dén nadid, a hanggan ta kédemét na éya a nipangako ko diko, a magenak tu asawa mo.” ");
INSERT INTO dgc_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nadid, habang édse ti Sakarias to lubuk no Templo, éy mégéuhayén du tolay ta luwas, éng bakit minale siya. ");
INSERT INTO dgc_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Mamaya-maya, kéluwas na, éy éwan siya makakagi. Basta lingguwahe san i kagi naa dide. Kanya tukoy du tolay a te nipeta i Diyos diya to lubuk. ");
INSERT INTO dgc_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nadid, kétapos no panahun ni Sakarias a mégtarabaho to Templo, éy nagsoli dén siya to bile de. ");
INSERT INTO dgc_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ey ta éya éy nangilog dén ti Elisabet a asawa na. Lima a bulan a éwan siya linumwas to bile. ");
INSERT INTO dgc_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Kinagbianék dén na Diyos,” kagi na, “a inibutan na dén tu sanike ko, da mabuktiték dén.” ");
INSERT INTO dgc_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Nadid, to ikaéném dén a bulan no buktet ni Elisabet, éy i Diyos éy pinaange na ti Anghel Gabriel ta Bariyo Nasaret ta Galilea. ");
INSERT INTO dgc_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Pinaange na siya ta esa a madiket ta éya a i ngahen naa éy ti Maria. I éya a madiket, éy éwan pabi inadenean na lélake. Pero sinakad dén no lélake, a ti Hose i ngahen na, a apo siya ni Hari Dabid. ");
INSERT INTO dgc_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ey tu anghel, éy inumange siya ni Maria, a kinagi na diya, a “Maria, édse diko i Diyos, a kagbian na ka.” ");
INSERT INTO dgc_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ey ti Maria, pékabati na to kagi no anghel, éy métageg siya, a mégéisipén siya éng anya wade i kahulugina na éya a kinagi na. ");
INSERT INTO dgc_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ey kinagi no anghel diya, a “Diyan ka méganteng, Maria, da mahal ka na Diyos. ");
INSERT INTO dgc_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Gemtén na Diyos a mangilog ka, a tulos magenak ka ta lélake. Ey ta kéenak na, Maria,” kagi na, “éy ngahinan mo siya ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Siya éy maging mataas, a dulawén de siya a anak na mataas a Diyos. Ey i Panginoon Diyos,” kagi no anghel, “éy gemtén na a maging hari siya, a kona to apo na a Hari Dabid to araw. ");
INSERT INTO dgc_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Sakay maghari siya du Judeo a éwan tu hanggan. Ey éwan tu katapusan i péghari naa!” ");
INSERT INTO dgc_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","“Ey pakodya ye,” kagi ni Maria, “da éwanék pabi tu asawa?” ");
INSERT INTO dgc_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","“Umange diko i Banal a Espiritu,” kagi no anghel, “sakay umédse diko i kapangyarian na Diyos. Kanya tu ienak mo, éy dulawén de a banal a anak na Diyos. ");
INSERT INTO dgc_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ey entan mo ti dada mo a Elisabet, Maria. Kagi de a baug kan siya. Pero nadid, maski bakés dén siya, éy mabuktet dén siya. ");
INSERT INTO dgc_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Da makagimet i Diyos ta maski anya.” ");
INSERT INTO dgc_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","“Ey maari,” kagi ni Maria, “da utusanék na Panginoon, éy tanggapén ko i kaluuben na diyakén.” Nadid, pégkagi ni Maria ta éya, éy gininanan siya no anghel. ");
INSERT INTO dgc_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Nadid, ta éya a panahun, éy inumange ti Maria to esa a banuwan ta buked ta Hudea, ");
INSERT INTO dgc_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","a bumisita siya to dada na a Elisabet. Ey kédemét na to bile de, éy sinomdép siya a binati na tu dada na. ");
INSERT INTO dgc_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ey ti Elisabet, pékabati na to boses ni Maria, éy bigla a linuminés tu anak na ta tiyan na, éy tulos inumasék i Banal a Espiritu ni Elisabet. ");
INSERT INTO dgc_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Tulos kinagi na ni Maria ta medegsén, a “Masuwerte ka, Anéng, ta maski ti ésiya a bébe, da tu anak mo, éy siya i mahaléna na Diyos! ");
INSERT INTO dgc_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Salamat ta Diyos,” kagi ni Elisabet, “da bumisita dén diyakén tu ina na Panginoon ko! ");
INSERT INTO dgc_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Da entan mo, Maria,” kagi na, “to pékabati ko diko, éy linuminés tu anak ko ta tiyan kua, dahil ta kasahatan naa. ");
INSERT INTO dgc_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Masuwerte ka dén, Anéng, da naniwala ka dén to kinagi diko na Panginoon!” ");
INSERT INTO dgc_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Nadid, kinagi ni Maria i kona se: “Purién ko i Diyos ta isip kua! ");
INSERT INTO dgc_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Mésayaék, da Diyos i tagapagligtas kua. ");
INSERT INTO dgc_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Sakén i utusan na a mababa, éy pinansingék dén na Diyos. Sapul nadid, éy dédulawénék na tolay a masuwerteék, ");
INSERT INTO dgc_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","dahil ta memahal a gimet na mataas a Diyos diyakén. Siya i banal. ");
INSERT INTO dgc_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Kékagbian na du umanteng diya, ta maski nikésiya a panahun. ");
INSERT INTO dgc_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Sakay gemtén na i kapangyarian na a ibutan na du palalo a tolay, a patahantaén na i gayak dia. ");
INSERT INTO dgc_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Pinababa na dén du mataas, sakay pinataas na dén du mababa. ");
INSERT INTO dgc_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Du mégalép éy atdinan na side ta kanén de, sakay du mayaman éy paibutén na side a éwan side tu kébil a kanén. ");
INSERT INTO dgc_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","“Nadid, éy inaguman na Diyos i katulung na a Israel. Ewan na naleksapan tu pangako na du apo-apo tam, a mangagbi dikitam. Kinagbian na ti Abraham. Sakay kagbian na be sikitam a apo-apo na, a éwan tu katapusan.” Saya i katapusana no kinagi ni Maria. ");
INSERT INTO dgc_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ey kétapos na éya, éy tinumulos ti Maria to bile no dada na ta manga étélo a bulan, bagu nagsoli siya to bile na. ");
INSERT INTO dgc_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nadid, kédemét na oras, éy nagenak ti Elisabet ta lélake. ");
INSERT INTO dgc_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ey du tétotop na sakay du karatig na, pékabaheta de a nagenak dén, éy mésaya side diya, da kinagbian dén siya na Diyos. ");
INSERT INTO dgc_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ey nadid, to ikawalu dén a aldew a idad no anak, éy dinumulug side to bile de Elisabet, a monda bugitén de tu anak, sakay ngahinan de. Talaga de a ngahinan siya ni Sakarias, da saya tu ngahen no ama na. ");
INSERT INTO dgc_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pero “Ewan,” kagi no ina na. “Maigi pa éy ngahinan tam siya ni Juan.” ");
INSERT INTO dgc_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","“Ey bakit,” kagi de. “Ewan ka tu top a maski isesa a te ngahen ta kona sa!” ");
INSERT INTO dgc_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Tulos nisenyas de ni Sakarias éng anya i gustu na a ngahen no anak na. ");
INSERT INTO dgc_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ey nihalimbawa ni Sakarias dide a atdinan de siya ta panulatan na. Ey to péngiatéd de diya, éy nisulat na i ngahen a Juan. Ey péketa du tolay ta éya, éy nagtaka side. ");
INSERT INTO dgc_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Nadid, bigla a nakapégkagi agad ti Sakarias, a tulos nagpasalamat siya ta Diyos. ");
INSERT INTO dgc_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ey inumanteng dén du karatig na, éng anya i kahulugen na éya. Ey i éya a nanyari, éy nabahibaheta dén ta lebuta na éya a lugar ta Hudea. ");
INSERT INTO dgc_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ey du étanan a nakabaheta, éy mégéisipén side ta éya a anak, éng maging anya siya. Da neta du tolay a édse diya i kapangyarian na Diyos. ");
INSERT INTO dgc_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Nadid, ti Sakarias a ama no anak, éy édse diya i Banal a Espiritu, éy naghula siya. ");
INSERT INTO dgc_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Salamat ta Panginoon,” kagi na. “Siya i Diyos a péniwalaan du tolay a Israel! Da inumange se siya a méngiligtas du tolay na. ");
INSERT INTO dgc_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Paangen na dén se i tagapagligtas dikitam, a lahi siya no katulung na a Dabid. ");
INSERT INTO dgc_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","“Ey nadid,” kagi ni Sakarias, “saye tu kinagi na Diyos to araw, to nipahula na du mahusay a purupeta na: ");
INSERT INTO dgc_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","I nipangako na Diyos, éy agawén na kitam du kalaban tam, a iligtas na kitam du méiyamut dikitam. ");
INSERT INTO dgc_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nangako siya a kéagbian na du apo-apo tam, a éwan na kaleksapan tu nipangako na dide to araw. ");
INSERT INTO dgc_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Nipangako na be to apo tam a Abraham, ");
INSERT INTO dgc_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","a agawén na kitam du kalaban tam, a monda éwan kitam méganteng a méniwala ta utus na. ");
INSERT INTO dgc_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ibilang na kitam a tolay na, sakay ibilang na kitam a éwan tu kasalanan, monda makaadene kitam diya a palagi.” ");
INSERT INTO dgc_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nadid, pinégkagian ni Sakarias tu anak na, a saye tu kinagi na: “Siko a anak ko,” kagi na, “éy ngahinan de ka a purupeta na mataas a Diyos. Siko, Duduy, éy meditol ka ni Cristo a magtoldu, a siko i magpahanda du tolay ta demtan na. ");
INSERT INTO dgc_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Siko i magbahetaa du tolay, a iligtas side na Panginoon, a pagpasensiyaan na side ta kasalanan de. ");
INSERT INTO dgc_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","I Diyos a péniwalaan tam, éy mebait siya, a kagbian na i tolay. I kédemét na a gébwat ta langet éy koman i sikat na bilag. ");
INSERT INTO dgc_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Matalo na i diklém, da tanglawan na du mégiyan ta diklém a mamakate dide, a monda igiya na side a mékiagum ta Diyos.” Saya tu kinagi ni Sakarias. ");
INSERT INTO dgc_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Nadid, tu anak de Sakarias, éy ti Juan i ngahen naa. Ey dinumikél siya ta mahusay, a natutu be siya tu isip. Ey tu diniklan na éy ta melawa a ilang a lugar. Saya i pégiyanan na a hanggan éwan dinumemét tu oras na a umange nagpahayag du tolay a Israel. ");
INSERT INTO dgc_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Nadid, ta éya a panahun, éy nagpasensos ti Hari Agosto ta tolay. I utus na, éy kailangan a magpalista i étanan a tolay ta sarili de a banuwan. ");
INSERT INTO dgc_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Saya tu purumeru a sensos, to panahun pabi ni Kirinio a gubernador ta Siria. ");
INSERT INTO dgc_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kailangan a umange i étanan a tolay ta sarili de a banuwan a magpalista. ");
INSERT INTO dgc_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Kanya ti Hose a katipan ni Maria, éy gininanan na i Bariyo Nasaret ta Galilea, a inumange siya ta Betlehem ta Hudea. Kailangan siya a magpalista ta éya, da taga Betlehem tu apo na a Dabid to araw, éy ti Hose éy lahi siya ni Dabid. ");
INSERT INTO dgc_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ey kaguman na sa ti Maria a katipan na. Ey siya éy mabuktet dén. ");
INSERT INTO dgc_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ey nadid, to édsa de pabi sa, éy dinumemét dén i oras ni Maria a magenak. ");
INSERT INTO dgc_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ey kéenak no anak na a panganay a lélake, éy binalutan na ta damit, sakay pinatidug na to pénganan du baka, da éwan dén side meubus to bile a tétulusan. ");
INSERT INTO dgc_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Nadid, ta éya a kélép, éy te sénganya a lélake ta adene ta Betlehem, a mégpastor side du tupa de. ");
INSERT INTO dgc_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ey bigla a pinumeta dide i esa a anghel a gébwat ta Panginoon, a tulos dinumemlag ta palebut dia i demlag na Diyos. Ey méganteng side a tahod. ");
INSERT INTO dgc_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ey kinagi no anghel dide, a “Diyan kam méganteng. Te ibahetaék dikam a memahal a baheta. I éye a baheta éy kasahatan na meaadu a tolay. ");
INSERT INTO dgc_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","To mamaya se,” kagi na, “éy nienak dén ta Betlehem tu Panginoon moy a tagapagligtas moy, a ti Cristo. ");
INSERT INTO dgc_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ey saye i tanda naa dikam,” kagi no anghel, “éy meta moy sa tu anak a te balut ta damit, a te katidug to pénganan na baka.” ");
INSERT INTO dgc_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Nadid, to pégkagi no anghel ta éya, éy bigla a inumagum diya i meaadu a tahod a anghel a iba, a mégpégkanta side ta puri ta Diyos. ");
INSERT INTO dgc_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Salamat ta Diyos ta langet,” kagi de, “da du mahalén na a tolay ta mundua, éy dumemét dide i kapayapaan!” ");
INSERT INTO dgc_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nadid, kéhektat dén du anghel a nagsoli ta langet, éy kinagi du mégpastor, a “Kitam dén ta Betlehem a entan tam éng anya i nanyaria, a nibaheta dikitam na Panginoon.” ");
INSERT INTO dgc_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Kanya inumange sa side agad, éy dinemtan de de Hose, a nagenak dén ti Maria, a te katidug tu anak na to pénganan na baka. ");
INSERT INTO dgc_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ey du mégpastor, éy nibaheta de du tolay sa tu kinagi no anghel dide a tungkul to anak. ");
INSERT INTO dgc_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ey du étanan a nakabati, éy nagtaka side. ");
INSERT INTO dgc_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ey ti Maria, éy inisip na san i étanan na éya, a éwan na kaleksapan i éya. ");
INSERT INTO dgc_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ey du mégpastor, éy nagsoli dén side, a pépurién de i Diyos dahil to mineta de, da kona bale to kinagi dide no anghel. ");
INSERT INTO dgc_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ey nadid, to ikawalu dén a aldew no idad no anak, éy binugit de siya. Ey nginahinan de siya ni Jesus, da saya tu kinagi no anghel ni Maria bagu siya nangilog. ");
INSERT INTO dgc_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Nadid, dinumemét dén i oras a péngtupad de Maria ta utus ni Moises ta tungkul ta pégenak na bébe. Kanya kembil de tu anak de ta Jerusalem, monda ipalagay de siya a iatéd ta Diyos tu buhay na. ");
INSERT INTO dgc_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Saye i utus a esa ta kasulatan na Diyos, a “Tu panganay kan a anak, éng lélake, éy koo na Diyos.” ");
INSERT INTO dgc_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ey inumange be sa side, monda iatang de i éduwa a palapati, o dikaya éduwa a dagalan, ayun ta utus na Diyos. ");
INSERT INTO dgc_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Nadid, te lakay a mégiyan ta Jerusalem, a ti Simeon i ngahen na. Mahusay siya a lakay a mékidiyos. Ey umasa siya a umasa, a agawén na Diyos du Israel ta kahirapan de. Ey édse diya ta mahusay i Banal a Espiritu. ");
INSERT INTO dgc_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ey nipaliwanag diya na Banal a Espiritu a éwan siya mate hanggan éwan na meta tu tiniyak na Diyos a tagapagligtas. ");
INSERT INTO dgc_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ey nadid, ta éya a aldew, éy pinéglakad siya na Espiritu na Diyos, a pinasdép na siya to Templo. Ey mamaya-maya, éy neta na a sinomdép de Maria a métatena, a talaga de a tupadén tu kailangan de a para to anak de, ayun to utus ni Moises. ");
INSERT INTO dgc_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ey ti Simeon, éy inalap na tu anak a kinélkél, a tulos nagpasalamat siya ta Diyos. ");
INSERT INTO dgc_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Anin, Panginoon,” kagi na, “maski mate ék dén nadid, da tinupad mo dén tu nipangako mo diyakén, ");
INSERT INTO dgc_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","a nipeta mo dén diyakén tu pinaange mo se a tagapagligtas ta tolay. ");
INSERT INTO dgc_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Siya ye i nihanda mua a tagapagligtas, a patanyagén mo ta buu a tolay. ");
INSERT INTO dgc_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Siya ye i magpaliwanaga du éwan Judeo a tolay ta plano mua. Dahil diya,” kagi ni Simeon, “éy tumanyag du tolay mo a Israel.” ");
INSERT INTO dgc_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nadid, du ina no anak, pékabati de ta éya a kagi ni Simeon, éy nagtaka side. ");
INSERT INTO dgc_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ey tu lakay a Simeon, éy binasbasan na side a métatena, sakay kinagi na ni Maria, a “I anak moyae, éy siya i pinilia na Diyos. Dahil diya éy mapahamak i meadu a tolay ta Israel. Sakay pati éy dahil diya éy te meadu be a meligtas. Siya i tandaa na Diyos. Ey te meadu a manglabag diya. ");
INSERT INTO dgc_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Dahil diya,” kagi ni Simeon, “éy mehayag i isip na meadu a tolay. Sakay siko, Maria, éy dumemét diko i dikél a kalungkutan mo, dahil ta gemtén de ta anak mua.” ");
INSERT INTO dgc_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Nadid, te purupeta a bakés a édsa be to Templo. Tu ngahen na éy ti Ana, a anak ni Panuel, a sakup siya na lahi ni Aser. Matanda dén siya a bakés, a walu a pulu a taon i idad na. Nale dén siya a nabilo. Pitu san a taon a nékiagum siya to asawa na, éy minate dén tu asawa na. I éya a bakés, éy éwan na géginanan tu Templo. Aldo éy ta kélép éy édsa sa siya a sumésamba ta Diyos. Sakay pamensan-mensan siya a mégkulasiyon, sakay ménalangin. ");
INSERT INTO dgc_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nadid, to pégkagi dén ni Simeon de Maria, éy dinumemét tu bakés dide, a tulos nagpasalamat siya ta Diyos, sakay tulos nipahayag na tu anak du étanan a uméasa ta kédemét na méngiligtas du Israel. ");
INSERT INTO dgc_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nadid, de Maria a pasawa, pékatupad de to kautusan ni Moises, éy nagsoli dén side ta Galilea, a hanggan to banuwan de a Nasaret. ");
INSERT INTO dgc_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ey tu anak de a ti Jesus, éy dinumikél siya a mesibét dén i bégi naa. Ey matalinung siya. Ey inaguman siya na Diyos ta mahusay. ");
INSERT INTO dgc_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Nadid, taon-taon, tuwing Piyesta na Ala-ala, éy uméange du magulang ni Jesus ta Jerusalem a mamiyesta. ");
INSERT INTO dgc_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ey ti Jesus, to labindalawa dén a taon tu idad na, éy kinumuyog siya dide. ");
INSERT INTO dgc_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ey kétapos no piyesta, éy nagsoli dén side, pero kineginanan de ti Jesus ta Jerusalem. Du magulang na éy éwan de napansing a nawahak siya, ");
INSERT INTO dgc_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","éngˈwan akala de éy kaguman de dén to gurupu de. Naghapun side a naglakad bagu de napansing a éwan siya kaguman. Nipépakelagip de siya du kakaguman de. ");
INSERT INTO dgc_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ey nadid, da éwan de neta, éy nagsoli side ta Jerusalem a mégahayok side diya. ");
INSERT INTO dgc_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Etélo side a aldew a nagahayok diya, bagu de mineta to Templo. Dinemtan de siya a kaguman na du matétanda a maistu na Judeo. Mégbati siya dide, sakay mégpakelagip. ");
INSERT INTO dgc_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ey du étanan sa a nakabati diya, éy nagtaka side, da neta de a matalinung i sengbet naa du maistu. ");
INSERT INTO dgc_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ey du magulang na, péketa de ta éya, éy nagtaka be side diya. Ey kinagi no ina na diya, a “Anin, Duduy, bakit beman kona sina i ginimet mo dikame? Nale kame dén tama mo a mégéahayukén diko.” ");
INSERT INTO dgc_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","“Bakit ahayukénék moy?” kagi ni Jesus. “Ewan moy beman tukoy a dapat édseék ta bileae Nama ko?” ");
INSERT INTO dgc_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ey éwan napospusan dena na i kahulugina no kinagi na. ");
INSERT INTO dgc_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ey kétapos na éya, éy kinumuyog ti Jesus dide, a nagsoli dén side ta Nasaret. Ey siya, éy sinunud na dena na ta mahusay. Ey tu ina na, éy alélahanén na i étanan a nanyari. ");
INSERT INTO dgc_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ey ti Jesus, éy dinumikél siya ta mahusay, a natutu be siya tu isip. Ey lalo a kinasahatan siya na Diyos, sakay du tolay, éy mésahat be side diya. ");
INSERT INTO dgc_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Nadid, to ikasapulu dén éy ta lima a taon ni Tiberio a naghari, éy inutusan na Diyos ti Juan a magsapul siya a mégtoldu. Tu Juan a anak ni Sakarias. Mégiyan pabi nadid ti Juan ta melawa a ilang a lugar. Nanyari ye to panahun pabi ni Ponsio Pilato a gubernador ta Hudea. Ti Herod éy mayor ta Galilea. Tu wadi na a Pelip éy mayor ta Iturea sakay ta Trakonite. Sakay ti Lisanis éy mayor ta Abilinia. Sakay ti Anas éy ti Kaipas, éy side i mataas a padi. ");
INSERT INTO dgc_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ey ti Juan, tulos naglebut siya du iba-iba a banubanuwan ta Hordan, a nagtoldu siya du tolay, a dapat magsisi side ta kasalanan de, a tulos ipabinyag side, monda pagpasensiyaan side na Diyos ta kasalanan de. ");
INSERT INTO dgc_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","I éya a gimet ni Juan, éy saya i kinagia ni Purupeta Isayas to nipégkagi na, a “Te magpahayag ta ilang a lugar, a i kagi na du tolay éy dapat maghanda side ta kédemét na Panginoon, a husayén de be tu péglakaden na. ");
INSERT INTO dgc_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Du étanan a lébak a édse to dilan na, éy tapuhan. Du étanan a buked, éy pantayén. Du kiwél-kiwél a kamino, éy padiretyuén. Ey du mebito a dilan, éy patagén. ");
INSERT INTO dgc_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Monda du étanan a tolay ta mundua, éy mapospusan de a agawén na Diyos du tolay na!” ");
INSERT INTO dgc_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nadid, to pégtoldu ni Juan, éy dinumulug diya i meaadu a tolay a ipabinyag. Ey kinagi ni Juan dide, a “Sikam éy magkadukés kam a tolay. Anya i kailangan moya ta éye? Akala moy wade a makaginan kam ta parusa na Diyos? ");
INSERT INTO dgc_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Baguén moy pa,” kagi na, “i ugali moya, a patunayan moy a nagsisi kam dén a talaga. Diyan kam umasa a agawén kam na Diyos da apo kam ni Abraham, da éwan ya tu kabuluhan ta Diyos. Da maski di bituae,” kagi na, “éy maari na Diyos a gemtén a maging apo ni Abraham! ");
INSERT INTO dgc_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ey tandaan moy,” kagi ni Juan, “mara i parusa na Diyos, éy wasay. Ey mehanda dén nadid tu wasay a pagpukan du kayo. Eng mara, sikam éy kayo kam. Ey du étanan a kayo a éwan magbunga ta mahusay a bunga, éy pukanén, sakay ibut ta apoy.” ");
INSERT INTO dgc_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ey du tolay, pékabati de ta éya a kagi ni Juan, éy kinagi de diya, a “Magenya kame, monda éwan kame parusaan na Diyos?” ");
INSERT INTO dgc_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ey kinagi ni Juan dide, a “Eng te éduwa ka a badu, éy iatéd mo i esa ta éwan tu badu. Ey kona be sa du te kanén.” ");
INSERT INTO dgc_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Nadid, te sénganya a mégpabuwes a inumange ni Juan a ipabinyag. Ey kinagi de be diya, éng anya i dapat gemtén de. ");
INSERT INTO dgc_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ey kinagi ni Juan dide, a “Diyan kam mégsingeh ta higit pa ta utus dikam na gubiyerno.” ");
INSERT INTO dgc_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ey te sundalu be sa. Ey kinagi de ni Juan, “Ey sikame, anya i dapat gemtén me?” “Ey diyan kam mangalap ta sapilitan, sakay diyan kam mégpehay ta éwan katutuhanan, sakay diyan kam méglekramo ta suweldu moy.” ");
INSERT INTO dgc_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nadid, dahil to pégtoldu ni Juan, éy nagsapul du tolay a uméasa diya, a akala de a makay ti Juan wade dén tu tiniyak na Diyos a tagapagligtas dide. ");
INSERT INTO dgc_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ey, “Ewan,” kagi ni Juan. “Besa a sakén i tagapagligtasa na Judeo. Sakén éy binyagen ta kam ta dinom. Pero te ménegipo diyakén a dumemét. Eng iparehoék moy diya, éy éwanék tu pasa, da mataas siya diyakén. Siya éy binyagen na kam ta Banal a Espiritu, sakay ta apoy. ");
INSERT INTO dgc_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Mara,” kagi ni Juan, “i pamuhubaan naa ta tolay, éy bilao. Mara te kébil siya a bilao, monda tapan na tu béges na. Ey tu mahusay a béges, éy iedton na ta bile na. Ey tu lupés, éy itutod na ta apoy a éwan maadép.” ");
INSERT INTO dgc_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Nadid, kona sa éy meadu i nitoldu ni Juan du tolay. Hinahatulan na side, sakay pinahayagen na side ta Mahusay a Baheta. ");
INSERT INTO dgc_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","Pero ti Mayor a Herod, éy nipihesu na ti Juan. Kanya nipihesu na siya, éy dahilan éy pinégkagian siya ni Juan, da inagew na ti Herodias a asawa no wadi na. Sakay pinégkagian na be siya to kasalanan na a iba. Ey tu kasalanan ni Herod a dikél, éy tu néngipihesu na ni Juan. ");
INSERT INTO dgc_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nadid, to kétapos ni Juan a nagbinyag ta meadu a tolay, éy bininyagen na be ti Jesus. Ey to nipagpabinyag ni Jesus, a manalangin pabi siya, éy minapilak i langet, ");
INSERT INTO dgc_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","a tulos dinumibi diya i Banal a Espiritu, a te bégi a koman i dagalan. Ey négkagi nadid i boses ta langet, a “Siko i anak kua a mahal, éy mésayaék diko.” ");
INSERT INTO dgc_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Nadid ti Jesus, to pégsapul na a mégtoldu, éy manga étélo a pulu a taon i idad na. Ayun ta isip na tolay, éy anak kan siya ni Hose, a anak ni Eli, ");
INSERT INTO dgc_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","a anak ni Matat. I éya a Matat éy anak ni Lebi, a anak ni Melki. Ey ti Melki man dén éy anak ni Hana, a anak ni Hose. ");
INSERT INTO dgc_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ti Hose éy anak ni Matatias, a anak ni Amos. I éya a Amos éy anak ni Nahum, a anak ni Esli. Ti Esli éy anak man dén ni Nage, ");
INSERT INTO dgc_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","a anak ni Maat, a anak ni Matatias. Ti Matatias éy anak ni Semey, a anak ni Hose. Ti Hose éy anak ni Huda, ");
INSERT INTO dgc_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","a anak ni Hoana. Ey ti Hoana éy anak man dén ni Resa, a anak ni Sorobabel, a anak ni Salatiel, a anak man dén ni Neri. ");
INSERT INTO dgc_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ti Neri éy anak ni Melki, a anak ni Adi. Ti Adi éy anak ni Kosam, a anak ni Elmodam, a anak ni Eri. ");
INSERT INTO dgc_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ti Eri man dén éy anak ni Hosue, a anak ni Elieser, a anak ni Horim, a anak ni Matat. Ti Matat éy anak ni Lebi, ");
INSERT INTO dgc_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","a anak ni Simeon, a anak ni Huda. Ey i éya a Huda éy anak man dén ni Hose. Ey ti Hose éy anak ni Honan, a anak ni Eliakim, ");
INSERT INTO dgc_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","a anak ni Melea. I éya a Melea éy anak ni Mainan, a anak ni Matata, a anak ni Natan, a anak ni Dabid. ");
INSERT INTO dgc_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ti Dabid éy anak ni Hese, a anak ni Obed; éy ti Obed éy anak man dén ni Boos. Ey ti Boos éy anak ni Salmon, a anak ni Nason, ");
INSERT INTO dgc_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","a anak ni Aminadab, a anak ni Admin. Ti Admin éy anak man dén ni Arni, a anak ni Esrom, a anak man dén ni Pares. I éya a Pares éy anak ni Huda, ");
INSERT INTO dgc_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","a anak ni Hakob. Ti Hakob éy anak ni Isaak, a anak man dén ni Abraham. I éya a Abraham éy anak ni Tare, a anak ni Nakor. ");
INSERT INTO dgc_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ti Nakor éy anak ni Serug, a anak ni Ragaw, a anak man dén ni Peleg; éy ti Peleg éy anak ni Heber, a anak ni Sala. ");
INSERT INTO dgc_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ti Sala éy anak ni Kainan, a anak ni Arpasad, a anak man dén ni Sem. Ti Sem éy anak ni Noe, a anak ni Lamek, ");
INSERT INTO dgc_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","a anak ni Matusalem, a anak ni Enok. Ti Enok éy anak ni Hared, a anak ni Mahalalel, a anak ni Kainan. ");
INSERT INTO dgc_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ti Kainan éy anak ni Enos, a anak man dén ni Set. Ey ti Set éy anak ni Adan, a anak na Diyos. ");
INSERT INTO dgc_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Nadid, nagsoli dén ti Jesus a gébwat ta Hordan. Ey édse diya ta mahusay i Banal a Espiritu. Ey tu Espiritu, éy niange na siya ta ilang a lugar, para ta épat a pulu a aldew. ");
INSERT INTO dgc_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ey ta éya, éy tinétokso siya ni Satanas. Ey ta lubuk na éya a panahun, éy éwan siya néngan. Ey to katapusan, éy mégalép dén siya. ");
INSERT INTO dgc_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ey kinagi ni Satanas diya, a “Eng anak ka na Diyos a talaga, éy gamitén mo i kapangyarian mua a paging tinapayén mo di bitoae.” ");
INSERT INTO dgc_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ey mégidel ti Jesus, a kinagi na, a “I kagia ta kasulatan na Diyos, éy éwan san kanén i ikabuhay mia, éngˈwan salita be na Diyos i ikabuhaya na tolay.” ");
INSERT INTO dgc_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Nadid ti Satanas, éy niange na ti Jesus ta melangkaw, sakay nipatanaw na diya i étanan a banubanuwan ta mundua ta esa san a minutus. ");
INSERT INTO dgc_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","“Sakén i te kooa diden ya a étanan,” kagi ni Satanas. “Ey maari ko a iatéd i éya ta maski ti ésiya a gustu ko. Nadid, éng sumamba ka diyakén, éy iatéd ko diko i étanan a kayamanan na éya, a siko i te kapangyariana dide.” ");
INSERT INTO dgc_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ey ti Jesus, éy mégidel man dén siya, a kinagi na ni Satanas, a “I utus na kasulatan na Diyos, éy Panginoon mo a Diyos, éy siya san i sambaan mua, sakay siya be kan san i péniwalaan mua.” ");
INSERT INTO dgc_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Nadid, éy niange na ti Jesus ta paluku no Templo ta Jerusalem. “Eng siko i anak na Diyos,” kagi na, “éy tumépduk ka dén. Ewan ka maanya, ");
INSERT INTO dgc_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","da i kagia ta kasulatan na Diyos, éy utusan kan na Diyos du anghel na a mangalaga diko. ");
INSERT INTO dgc_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Sakay agawén de ka kan,” kagi ni Satanas, “monda éwan ka mebagsak ta bito.” ");
INSERT INTO dgc_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ey mégidel man dén ti Jesus, a kinagi na, a “Te kagi a iba, a éwan kan maari a puhubaan na tolay i Diyos, éng aguman na.” ");
INSERT INTO dgc_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ey nadid, kétapos ni Satanas a nangtokso ni Jesus, éy gininanan na siya, a naguhay siya ta esa a pagkékataon. ");
INSERT INTO dgc_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Nadid, éy nagsoli dén ti Jesus ta Galilea. Ey édse diya i kapangyarian na Banal a Espiritu. Ey du tolay sa, éy nabahibaheta de siya. ");
INSERT INTO dgc_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ey nagtoldu siya du tolay du kapilya de, éy pinépuri siya du étanan a tolay. ");
INSERT INTO dgc_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nadid éy inumange dén ti Jesus to diniklan na a banuwan a Nasaret. Ey to pangilin a aldew, éy inumange siya to kapilya de, a kona ta ugali na. Ey tinumaknég siya to miting de, a mégbasa ta kasulatan. ");
INSERT INTO dgc_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ey nigewat de diya tu libru a nisulat ni Purupeta Isayas. Ey binuklat na, éy saye tu binasa na: ");
INSERT INTO dgc_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Edse diyakén i Espiritu na Panginoon, da piniliék na a magpahayag du mahirap ta Mahusay a Baheta. Inutusanék na a magpahayag du pihesu, a agawén side, sakay du buhék, éy makabulag side, sakay du mahirap, éy ilibri side. ");
INSERT INTO dgc_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Inutusanék na a magpahayagék ta kédemét na Panginoon a mangiligtas dide.” ");
INSERT INTO dgc_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Nadid, pékabasa dén ni Jesus ta éya, éy tiniklup na tu libru, sakay nisoli na to lélake, sakay inumeknud siya a mégtoldu. Ey te itan siya du étanan a tolay to kapilya, éng anya i kagi naa. ");
INSERT INTO dgc_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","“I éya a hula a binasa ko dikam,” kagi na, “éy natupad dén nadid a aldew ta harap moya.” ");
INSERT INTO dgc_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ey du tolay, pékabati de ta éya, éy kagi de a mahusay siya a lélake. Ey nagtaka side to kinagi na a memahal. Ey kagi du iba, a “Ewan beman siya tu anak ni Hose?” ");
INSERT INTO dgc_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ey kinagi ni Jesus dide, a “Siguradu éy kagi moy diyakén i halimbawa, a ‘Nay, éng doktor ka, éy pahusayén mo pa i sarili mua.’ O kagi moy siguru diyakén, a ‘Bakit éwan mo gemtén ta éye tu nabaheta me a ginimet mo kan ta Kapernaum?’ ");
INSERT INTO dgc_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Talaga,” kagi ni Jesus, “éwan tanggapén na tolay i purupeta, éng gébwat siya ta banuwan de. ");
INSERT INTO dgc_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Tandaan moy,” kagi na; “to panahun ni Purupeta Elias, éy éwan naguden ta étélo éy ta kalahati a taon, a hanggan mégalép i tolay. Ey te meadu a bébe a bilo ta Israel ta éya a panahun, a naghirap. ");
INSERT INTO dgc_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pero entan moy,” kagi ni Jesus, “i Diyos éy éwan na inutusan ti Elias a mangtulung ta maski isesa dide. Engˈwan, i tinulungan na sana éy tu bilo ta Sidon a taga Sarepta. Ey siya éy éwan bale Judeo! ");
INSERT INTO dgc_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","“Sakay to panahun ni Purupeta Eliseo, éy te meadu a te saket a ketong,” kagi ni Jesus. “Pero éwan ginamot ni Eliseo i maski isesa dide. Engˈwan, basta ti Naaman san a taga Siria i ginamot naa. Ey siya éy éwan be Judeo!” ");
INSERT INTO dgc_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nadid, to pégkagi ni Jesus ta éya du tolay to kapilya, éy naiyamut side diya. ");
INSERT INTO dgc_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ey kembilan de ti Jesus a inibutan de siya to banuwan de. Niange de siya to taytay no buked ta éya, a talaga de siya a itogpal to buked. ");
INSERT INTO dgc_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pero ti Jesus, éy basta nagsoli siya a naglakad to lubuk de, a hinumektat siya dide. ");
INSERT INTO dgc_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nadid, éy inumange ti Jesus ta Kapernaum ta Galilea. Ey tuwing pangilin, éy nagtoldu siya du tolay ta éya. ");
INSERT INTO dgc_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ey du tolay, éy mégpégtaka side a tahod to pégtoldu na, da neta de a te kapangyarian siya ta pégtoldu na. ");
INSERT INTO dgc_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ey nadid éy te esa a lélake to kapilya ta éya a hinayup, a te medukés a espiritu diya. Ey dinumulaw siya ta medegsén, a kinagi na, a ");
INSERT INTO dgc_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Jesus, siko a taga Nasaret, anya i pékialam mua dikame? Bunon mo kame wade a manga hayup? Natenggi ta ka a siko i tiniyak na Diyos a tagapagligtas!” ");
INSERT INTO dgc_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ey ti Jesus, éy sinaway na tu hayup, a kinagi na, a “Tama dén! Umibut ka dén ta ina a lélake!” Ey tu dimonyo, pékabati na ta éya, éy pinalugmuk na tu lélake, a tulos inumibut dén siya to lélake, a éwan na siya pinasakitan. ");
INSERT INTO dgc_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ey du tolay sa, éy mégpégtaka side, a kinagi de, a “Anya wade i kagi na lélakeae? Te kapangyarian siya, a iutus na san du medukés a espiritu, éy umibut side ta tolay!” ");
INSERT INTO dgc_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ey kétapos na éya, éy nabaheta du étanan a tolay ta éya i tungkul ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Nadid, hinumektat ti Jesus to kapilya, a inumange siya to bile ni Simon. Ey tu manugeng ni Simon éy méladu siya, a mepalang. Ey kinagi de ni Jesus a te ladu siya. ");
INSERT INTO dgc_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ey inumange ti Jesus diya, a pinégkagian na tu palang na. Ey naibut tu palang na, a tulos inumégkat siya a nagasikaso siya dide. ");
INSERT INTO dgc_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nadid, to giapon dén, éy du tolay sa a te kaguman a te ladu, éy niange de side ni Jesus. Ey ti Jesus, éy nitupo na tu kamét na dide, éy pinahusay na side a étanan. ");
INSERT INTO dgc_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Sakay te meadu be a tolay a minaibut dide du dimonyo. Ey medegsén tu kinagi de ni Jesus, a “Siko i anaka na Diyos!” kagi de. Pero pinégkagian side ni Jesus, a sinaway na side a mégkagi, da tukoy de a siya i Cristo a tiniyak na Diyos a tagapagligtas. ");
INSERT INTO dgc_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Nadid, to gagabi dén, éy hinumektat sa ti Jesus, a inumange siya ta adeyo du tolay. Pero du tolay, éy inahayok de siya. Ey péketa de diya, éy talaga de siya a sawayén a maglakad. ");
INSERT INTO dgc_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pero “Ewan maari,” kagi na, “da te kailanganék a mégpahayag be du tolay ta iba-iba a banuwan. Kanyaék se pinaange na Diyos, éy monda ipahayag ko i Mahusay a Baheta tungkul ta péghari na Diyos.” ");
INSERT INTO dgc_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Kanya tulos nagpahayag ti Jesus ta meadu a kapilya ta palebut na Hudea. ");
INSERT INTO dgc_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","To esa a aldew, éy édsa ti Jesus to digdig no diget ta Genesaret. Ey te meaadu a tolay a dumédulug diya, a pépilitén de a umadene diya, da gustu de a mégbati ta pégtoldu na ta kagi na Diyos. ");
INSERT INTO dgc_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ey ti Jesus éy neta na i éduwa a abeng a te pundu dén to baybay. Ey du te koo dide, éy inugisan de du panti de. ");
INSERT INTO dgc_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ey nadid, da pépiitén du tolay ti Jesus, éy sinumakay siya to abeng a esa, a koo ni Simon, sakay kinagi na diya, a itulak na tu abeng, a dumitaw ta kétihék. Ey to kéditaw de, éy inumeknud sa ti Jesus, a tulos nagtoldu siya du tolay. ");
INSERT INTO dgc_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ey nadid, kétapos ni Jesus a nagtoldu, éy kinagi na ni Simon, a “Nay, Iditaw moy pa i abinga ta bétong yae, sakay itékneg moy sa i pantia, monda makaalap kam.” ");
INSERT INTO dgc_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ey “Maistu,” kagi ni Simon, “nagdamag kame to kélép se a nagpanti, éy éwan kame tu nalap. Pero éng siko i te utusa, éy puhubaan me man dén.” ");
INSERT INTO dgc_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nadid, to péngitékneg de to panti de, éy meaadu bale side a naalap, a hanggan da talaga a mapéknet tu panti. ");
INSERT INTO dgc_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ey pinayapayan de du kaguman de to iba a abeng, a aguman de side. Ey pinutat de du éduwa a abeng ta ikan, a hanggan da talaga a omléd side. ");
INSERT INTO dgc_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Ey de Simon Pedro, éy nagtaka side a tahod to dinikép de a ikan. I kakaguman ni Simon éy de Santiago sakay ti Juan, a patwade side a anak ni Sebedeo. Ey ti Simon, péketa na ta nanyaria, éy linumuhud siya ni Jesus, a kinagi na, a “Diyan ka umadene diyakén, Panginoon, da meaduék a kasalanan!” Ey kinagi ni Jesus diya, a “Diyan ka méganteng; sapul nadid éy éwan ka dén mangalap ta ikan, éngˈwan tolay a para diyakén.” ");
INSERT INTO dgc_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ey nadid, to péngidahik de to abeng de to baybay, éy basta gininanan de i étanan, sakay kinumuyog side ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","To esa a aldew, éy édse ti Jesus to esa a banuwan. Ey te lélake ta éya a putat i bégi na ta saket a ketong. Ey siya, péketa na ni Jesus, éy dinumapa siya, a nékiohon siya ni Jesus. “Panginoon,” kagi na, “éng maari, éy pahusayénék pad.” ");
INSERT INTO dgc_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ey ti Jesus, éy kembilan na siya, a kinagi na, a “Maari, maghusay ka dén.” Ey to pégkagi na ta éya, éy bigla a naibut tu ladu na. ");
INSERT INTO dgc_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ey kinagi ni Jesus diya, a “Diyan mo kékagin i éye ta maski ti ésiya, éngˈwan umange ka pa pumeta to padi, a mahusay ka dén. Sakay atdinan mo tu padi,” kagi na, “ta péngiatang na diko, a kona to niutus ni Moises, a saya i pagpatunay mua ta tolay a mahusay ka dén.” ");
INSERT INTO dgc_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pero nadid, lalo a nabaheta du tolay i tungkul ta kapangyarian ni Jesus, a tulos meaadu pa i tolay a dumédulug diya, a monda mégbati side diya, sakay gustu de a magamot side ta ladu de. ");
INSERT INTO dgc_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kanya ti Jesus éy palagi siya a uméange ta ilang a lugar, monda makaadeyo siya dide a manalangin. ");
INSERT INTO dgc_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","To esa a aldew, éy mégtoldu ti Jesus. Ey te eknud sa i sénganya a Pariseyo sakay maistu ta rilihiyon. Ey side éy gébwat ta iba-iba a banuwan ta Galilea, sakay ta Hudea, sakay ta Jerusalem. Ey édse nadid ni Jesus i kapangyarian na Diyos a magamot ta tolay. ");
INSERT INTO dgc_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ey du iba a tolay sa, éy kembil de ni Jesus i esa a lélake a lumpu, a te katidug siya to kama na. Talaga de siya a iesdép to bile a égsean ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pero éwan de kaya, da mepiit tu bile da meadu a tolay. Kanya nisangkay de tu lumpu to atép no bile, sakay binutbut de tu atép, sakay nitostos de tu kama a édsean no lumpu, a hanggan ta harapa ni Jesus to lubuk. ");
INSERT INTO dgc_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ey ti Jesus, péketa na a méniwala side diya, éy kinagi na to lumpu, a “Kadimoy, pinatawad ka dén ta kasalanan mo.” ");
INSERT INTO dgc_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ey du maistu ta rilihiyon, sakay du Pariseyo, pékabati de ta éya, éy kinagi de ta lihim, a “Ti ésiya i lélakeae, a mégwari-wari a Diyos siya? Diyos san i makapagpatawad ta kasalanan na tolay.” ");
INSERT INTO dgc_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ey ti Jesus, éy tukoy na dén i isip dia, a tulos kinagi na dide, a “Bakit mégisip kam ta kona sina? ");
INSERT INTO dgc_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Tama,” kagi na, “maari i maski ti ésiya a mégwari-wari a magpatawad ta kasalanan na tolay. Pero ti ésiya i maaria a makapagpalakad ta lumpu a tolay? ");
INSERT INTO dgc_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nadid,” kagi na, “éy sakén i lélake a gébwat ta langet. Ey patunayan ko dikam a te kapangyarianék a magpatawad ta kasalanan, a péglakadén ko i lumpuae.” Nadid, kinagi ni Jesus to lélake a lumpu, a “Nay, umégkat ka dén, a alapén mo dén i kama mua, a ikad mo dén ta bile moy.” ");
INSERT INTO dgc_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ey nadid, pégkagi ni Jesus ta éya, éy basta inumégkat agad tu lumpu ta harap du tolay, sakay inalap na tu katidugen na, sakay nagsoli siya to bile na, a mégpépasalamatén dén siya ta Diyos. ");
INSERT INTO dgc_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ey dudu tolay sa, éy mégpégtaka side a tahod a tahod. Ey pinépuri de i Diyos, a kinagi de, a “Makataka-taka a gimet i mineta tama nadid ta éye!” ");
INSERT INTO dgc_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Nadid, kétapos na éya, éy neta ni Jesus i esa a lélake a mégpabuwes, a ti Lebi i ngahen na, a te eknud siya to pégsingihan ta buwes. Ey kinagi ni Jesus diya, a “Kumuyog ka diyakén a maging alagad ko.” ");
INSERT INTO dgc_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ey ti Lebi, éy basta tinumaknég siya, sakay pinabayan na san tu tarabaho na, sakay inumunonod dén siya ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Nadid, da gustu ni Lebi ti Jesus, éy nipaghanda na siya ta dikél a anyaya to bile na. Ey to péngan de, éy nékidipon be sa i meadu a iba a mégpabuwes, sakay iba a medukés a tolay, ");
INSERT INTO dgc_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ey du Pariseyo, sakay du kaguman de a maistu ta rilihiyon, péketa de dide, éy kinagi de du alagad ni Jesus, a “Bakit mékidipon kam du makasalanan a tolay?” ");
INSERT INTO dgc_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ey ti Jesus, pékabati na dide, éy kinagi na, a “Bakit? Du mahusay éy éwan side tu kailangan ta magamot, éngˈwan du te ladu. ");
INSERT INTO dgc_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ey sakén éy éwanék se inumange a monda tumulungék du mahusay a tolay, éngˈwan du makasalanan i tulungan kua.” ");
INSERT INTO dgc_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Nadid du tolay, éy kinagi de ni Jesus, a “Du alagad ni Juan, éy palagi side a mégkulasiyon, sakay ménalangin. Ey kona be sa du alagad du Pariseyo,” kagi de. “Ey bakit du alagad mo, éy éwan? Basta méngan side.” ");
INSERT INTO dgc_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ey kinagi ni Jesus dide, a “Ataay, pilitén moy beman a mégkulasiyon i tolay éng kaguman de pabi i ikasal? Ewan! ");
INSERT INTO dgc_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Bagay éwan dén sa tu kadimoy de a ikasal, éy saya i oras de a magkulasiyon.” ");
INSERT INTO dgc_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ey tulos kinagi ni Jesus dide i esa pa a halimbawa. “Ewan tu mangpéknet ta badu a bigu,” kagi na, “a itagpi ta badu a dati. Da éng kona sa, éy sayang tu badu a bigu, sakay pati tu bigu éy éwan kapareho no dati. ");
INSERT INTO dgc_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ey éwan be tu méngiasék ta bigu a alak ta dati a pégaskanan. Da éng kona sa i ginamet de, éy pomtak tu pégaskanan, da dati, a tulos mebut tu alak. Ey sayang be dén tu pégaskanan. ");
INSERT INTO dgc_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Maigi pa, éy dapat iasék i bigu a alak ta bigu be a pégasakanan! ");
INSERT INTO dgc_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Sakay pati, éng mara ininom mo dén i dati a alak, éy sala mo a kenaman i bigu, da lalo a mehasa tu dati a alak.” ");
INSERT INTO dgc_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Nadid, to esa a aldew a pangilin, éy dinumiman de Jesus to kapahayan. Ey to péglakad de, éy nagkétoh du alagad na ta tégesa a ohay, a kékéselén de, a kanén de. ");
INSERT INTO dgc_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ey du Pariseyo, éy kinagi de, a “Bakit, gemtén moy i bawal ta pangilin? Bilang tarabaho ina!” ");
INSERT INTO dgc_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ey kinagi ni Jesus dide, a “Ewan! Bakit, éwan moy wade nabasa tu ginimet ni Dabid to araw, to pégalép de sakay du kaguman na? ");
INSERT INTO dgc_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Basta sinomdép siya to bile na Diyos. Ey tu te déton sa a tinapay a para ta Diyos, éy inalap na a kinan na; sakay pinakan na be du kaguman na. Ey bawal kan ya ta utus, da du padi san i maari kana a méngan ta éya. ");
INSERT INTO dgc_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ey sakén a lélake a gébwat ta langet,” kagi ni Jesus, “éy sakén i mégkagia éng anya i tama a gimet ta aldew a pangilin.” ");
INSERT INTO dgc_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Nadid, to pangilin a esa, éy sinomdép ti Jesus to kapilya a magtoldu. Ey te lélake sa a pile tu kamét. ");
INSERT INTO dgc_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ey du te tungkulin a Judeo, éy sinubukan de ti Jesus, éng gamutén na tu lélake ta pangilin, monda maka éy iabla de siya a manglabag ta utus. ");
INSERT INTO dgc_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pero tukoy ni Jesus tu isip de. Ey kinagi na to pile tu kamét, a “Kadon se. Tumaknég ka se.” Ey tu lélake, éy tinumaknég siya to harap de. ");
INSERT INTO dgc_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ey kinagi ni Jesus du mégsubuk diya, a “Anya, bawal beman ta utus tam éng aguman tam i te hirap ta pangilin? Isip ko bawal san éng pahirapan tam i tolay?” ");
INSERT INTO dgc_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ey ti Jesus éy lélamangén na side, sakay kinagi na to lélake a pile, a “Iolnat mo i kamét mua.” Ey to péngiolnat na, éy naghusay dén. ");
INSERT INTO dgc_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ey du nagsubuk diya, éy méiyamut side a tahod diya. Ey négpéguhon side éng anyan de siya. ");
INSERT INTO dgc_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Nadid, ta éya a panahun, éy inumange ti Jesus to buked a manalangin. Ey nagdamag siya a nanalangin ta Diyos. ");
INSERT INTO dgc_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ey to gagabi dén, éy pinauwet na du alagad na, sakay pinili na i labindalawa dide, a side i ngéngahinan na a apostol. ");
INSERT INTO dgc_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","I ngahen dia éy ti Simon, a pinalayawan na a Pedro, sakay ti Andres a wadi na, sakay ti Santiago éy ti Juan, sakay ti Pelip, sakay ti Bartolome, ");
INSERT INTO dgc_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","sakay ti Mateo éy ti Tomas, sakay ti Santiago a anak ni Alpeo, sakay ti Simon a metapang, ");
INSERT INTO dgc_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","sakay ti Hudas a anak ni Santiago, sakay ti Hudas Iskarote a néngitokyon ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Nadid, késoli de Jesus a gébwat to buked, éy hinumintu side to dénak, a kaguman na i meadu a alagad na. Ey dinumulug sa diya i meaadu a tolay a gébwat ta Hudea, sakay ta Jerusalem sakay ta Tiro éy ta Sidon. ");
INSERT INTO dgc_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Inumange sa side a mégbati diya, sakay monda pahusayén na side ta sakisaket dia. Ey inumange be sa i meadu a hinayup, éy naghusay be side. ");
INSERT INTO dgc_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ey meadu a tolay a pumépilit a mangkapot diya, da te kapangyarian siya ta bégi naa a mégpahusay ta te ladu. Ey naghusay side a étanan. ");
INSERT INTO dgc_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ey tinolduan ni Jesus du alagad na, a kinagi na dide, a “Masuwerte kam a mababa, da masakup kam na kaharian na Diyos. ");
INSERT INTO dgc_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Masuwerte kam, sikam a mégalép, da atdinan kam na Diyos ta gustu moy. Masuwerte kam, sikam a mégsanget nadid, da pakasayaén kam na Diyos. ");
INSERT INTO dgc_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Masuwerte kam éng méiyamut dikam i tolay, o éng idelan de kam, o éng ahewén di kam, o éng kagi de a medukés kam da sakup kam na lélake a gébwat ta langet. ");
INSERT INTO dgc_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Eng dumemét dikam i kona sa, éy dapat masaya kam, da saya i tandaa a dikél i gantimpala moya ta langet. Da kona be sa i péngloko de du purupeta to araw. ");
INSERT INTO dgc_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Pero sikam a mayaman nadid, éy kagbi kam, da malipas dén i buhay moya a malaya! ");
INSERT INTO dgc_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Sakay sikam a te meadu a kanén nadid, éy kagbi kam be, da dumemét dikam i alép! Sakay sikam a masaya nadid, éy kagbi kam be, da dumemét dikam i pégsanget moy! ");
INSERT INTO dgc_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Sakay sikam a iba, éy kagbi kam be,” kagi ni Jesus, “éng purién kam na tolay, da kona be sa i ginamet du tolay to araw du mégbuli-buli a purupeta.” ");
INSERT INTO dgc_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Nadid,” kagi ni Jesus, “saye i utus kua dikam: mahalén moy du kalbug moy. Sakay du méiyamut dikam, éy gemtén moy dide i mahusay. ");
INSERT INTO dgc_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Sakay du mégdusta dikam, éy kagi moy dide i mahusay a kagi. Sakay ipanalangin moy du mangloko dikam. ");
INSERT INTO dgc_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Eng te mangsapuk diko ta padingel mua, éy iadene mo pa i lipat. Sakay éng te mangalap ta diyaket mua, éy iatéd mo be diya tu badu mo. ");
INSERT INTO dgc_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mangatéd ka ta mékeged diko, sakay éng te mangalap ta koo mo, éy diyan mo dén ipeesoli. ");
INSERT INTO dgc_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Gustu moy a aguman kam na tolay. Pero i utus kua dikam, éy sikam i mangaguma dide. ");
INSERT INTO dgc_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Mara du mahal dikam, éng side san i mahalén moya, éy anya, purién kam beman na Diyos? Da maski du makasalanan a tolay, éy mahalén de du mégmahal be dide. ");
INSERT INTO dgc_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","O éng tulungan moy san du mégtulung be dikam, éy purién kam beman na Diyos? Da maski du makasalanan a tolay, éy kona be sa i ugali dia. ");
INSERT INTO dgc_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","O éng i potangan moy sana éy du makabayad dikam, éy bakit umasa kam a purién kam na Diyos? Da maski du makasalanan a tolay, éy mégpotang side, monda patubuan de tu nipotang de. ");
INSERT INTO dgc_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Kanya sikam,” kagi ni Jesus, “I maigia éy mahalén moy du kalaban moy, sakay gemtén moy dide i mahusay. Sakay magpotang kam, a diyan kam umasa a bayaden de dikam. Eng kona sa i gimet moya, éy maging anak kam dén na mataas a Diyos, sakay gumanti siya dikam ta mahusay. Dahilan i Diyos, éy kagbian na be du medukés a tolay. ");
INSERT INTO dgc_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kanya sikam éy dapat mangagbi kam, a kona Nama moy ta langet.” ");
INSERT INTO dgc_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Diyan kam mégpintas ta kapareho moy, monda éwan kam pintasan na Diyos.” kagi ni Jesus. “Sakay diyan moy sisién i iba a tolay, éy éwan kam sisién na Diyos. Engˈwan, pagpasensiyaan moy san du iba, éy pagpasensiyaan kam be na Diyos. ");
INSERT INTO dgc_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mangatéd kam ta iba a tolay, éy mangatéd be i Diyos dikam. Eng kona sa i ugali moya, éy atdinan kam na Diyos ta meadu, a higit pa ta kaya moy a kébilén. Tu takalan moy a gamitén moy éng méngatéd kam ta iba, éy siya be ya i takalan a gamitén na Diyos bagay méngatéd siya dikam.” ");
INSERT INTO dgc_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Nadid, kinagi ni Jesus du tolay i iba a halimbawa. “Ewan maari i buhék a mégakay ta buhék be,” kagi na. “Da éng kona sa, éy sabay side a matépduk ta ébut. ");
INSERT INTO dgc_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ewan mataas tu alagad to maistu na. Pero éng nakaadal dén siya ta hustu, éy makaaheg siya to maistu na. ");
INSERT INTO dgc_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Bakit pépintasan mo tu kaguman mo a te buhék tu mata, éy siko éy éwan mo mapansing tu adigi ta mata mua? ");
INSERT INTO dgc_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Kodya i pégkagi mua to kaguman mo, a ‘Kadon, Wadeng, ibutan ko i buhék mua,’ pero éwan mo meta a te adigi ka san tu mata? Mégwari-wari ka bale a éwan ka tu kasalanan! Ibutan mo pa tu adigi ta mata mua, monda maketa ka ta mahusay a maibutan mo tu buhék to mata no kaguman mo.” ");
INSERT INTO dgc_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“I mahusay a kayo,” kagi ni Jesus, “éy éwan mégbunga ta medukés a bunga. Sakay i medukés a kayo éy éwan mégbunga ta mahusay a bunga. ");
INSERT INTO dgc_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kanya i maski anya a kayo, éy tukoy mo éng mahusay, o éngˈwan, bagay meta mo i bunga naa. Tandaan moy, éwan mapitas i mahusay a bunga ta medukés a kayo. ");
INSERT INTO dgc_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ey kona be sa i tolay,” kagi ni Jesus; “du mahusay a tolay, éy gemtén de i mahusay. Sakay du medukés a tolay, éy medukés be i gimet dia. Dahilan i ugali na tolay, éy gemtén de i édse ta isip dia.” ");
INSERT INTO dgc_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Bakit ngéngahinanék moy a Panginoon moy, pero éwan moy sésundin i utus kua dikam?” kagi ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","“I maski ti ésiya a umange diyakén, sakay bébaten na i kagi kua, a tulos sundin na, ");
INSERT INTO dgc_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","éy ikahalimbawa naa éy tu lélake a mégbile ta matibay a bile. Siya i mégkotkot ta medisalad a pundasiyon, a itupu na tu bile na ta bito. I éya a bile, maski binihéng, éy éwan natumba, da matibay. ");
INSERT INTO dgc_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pero tu mégbati ta kagi kua a éwan na sundin, éy ikahalimbawa naa éy tu lélake a mégbile ta bile a éwan tu pundasiyon. Eng bihéngén i éya a bile, éy bumagsak agad, a tulos mawasawasak dén.” ");
INSERT INTO dgc_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nadid, kétapos ni Jesus a mégtoldu ta éya, éy inumange siya ta Kapernaum. ");
INSERT INTO dgc_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ey te kapitan a sundalu ta éya a taga Roma. Siya éy te utusan a mahal na, a te ladu, a adene dén a mate. ");
INSERT INTO dgc_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kanya tu kapitan, pékabaheta na ni Jesus, éy nibilin na ta sénganya a matétanda a Judeo, a pékiohon de ni Jesus a angen na pahusayén tu utusan. ");
INSERT INTO dgc_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ey du matétanda, nékiohon side ni Jesus ta mahigpit. “Dapat tulungan mo i éya a kapitan,” kagi de, ");
INSERT INTO dgc_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","“da mahal na kitam a Judeo, sakay siya i nagpatolnéka ta kapilya mia ta éye.” ");
INSERT INTO dgc_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Kanya kinumuyog ti Jesus dide. Ey to kétamo de pabi to bile no kapitan, éy pinasambat no kapitan du kadimoy na ni Jesus, a kinagi de ni Jesus, a “Panginoon, i gustua no kapitan me, éy diyan ka kan tumulos ta bile na; mésanike siya diko, da mataas ka diya. ");
INSERT INTO dgc_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","8","Kanya éwan siya i nangangea diko, Panginoon, éy mésanike siya. I kinagia dikame no kapitan me,” kagi de, “éy maski siya kan, éy te mégutus be diya a heneral, sakay siya éy mégutus kan be siya du sundalu na. Maski anya i utus na kana du sundalu na, éy gemtén de. Ey kona be sa tu katulung na, kagi na. Kanya siko, Panginoon,” kagi de, “éng mégkagi ka san a maghusay tu utusan, éy maisip dén no kapitan me a maghusay siya a talaga, maski adeyo ka.” ");
INSERT INTO dgc_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nadid, pékabati ni Jesus ta éya, éy nagtaka siya. Ey sinumuleg siya a kinagi na du umunonod diya, a “Sapul to éya, éy éwan ko pabi neta i maski isesa a Judeo a méniwala diyakén a kona ta éya a kapitan!” ");
INSERT INTO dgc_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ey nadid, to késoli dén du kadimoy no kapitan to bile de, éy dinemtan de dén tu utusan na a mahusay dén. ");
INSERT INTO dgc_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nadid, kétapos na éya, éy inumange de Jesus ta Nain. Ey kaguman na du alagad na, sakay i meadu pa a tolay. ");
INSERT INTO dgc_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ey to kéadene de to banuwan, éy nasambat de i meaadu a tolay a lumuwas, a te usung side ta pate, a tamo side ta péglébngan. Ey tu lélake a minate a kébilén de, éy siya tu anak no bilo a bébe a isesa. ");
INSERT INTO dgc_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ey tu Panginoon, péketa na to bilo éy kinagbian na siya a tahod, a kinagi na diya, a “Diyan ka mégsanget.” ");
INSERT INTO dgc_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ey kembilan ni Jesus tu kabaong. Ey du te usung diya, éy nihintu de. Ey kinagi ni Jesus to bangkay, a “Anéng, umégkat ka dén.” ");
INSERT INTO dgc_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ey tulos inumeknud to lélake, a tulos na dén a minégkagi. Ey ti Jesus, éy niange na dén siya to ina na. ");
INSERT INTO dgc_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ey du tolay sa, éy inumanteng dén side a étanan. Ey pinuri de dén i Diyos, a kinagi de, a “Dinumemét bale dén i mataas a purupeta dikitam!” Sakay kinagi du iba, a “Dinumemét bale dén i Diyos a mangagaw siya du tolay na!” ");
INSERT INTO dgc_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ey i éya a gimet ni Jesus éy nabaheta dén ta étanan a banubanuwan ta éya. ");
INSERT INTO dgc_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ey du alagad ni Juan, éy nakabaheta be side ta gégemtén ni Jesus, tulos nibaheta de siya ni Juan to pégpihesuan. ");
INSERT INTO dgc_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ey ti Juan, éy pinaange na i éduwa a alagad na ni Jesus. “Ipakelagip moy diya,” kagi ni Juan, “éng siya ngani dén i nipangakua na Diyos a umange se a tagapagligtas tam, o maguhay kitam pa ta esa?” ");
INSERT INTO dgc_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","21","Ey du alagad ni Juan, kédemét de ni Jesus, éy dinemtan de siya a mégpahusay du meadu a te saket, sakay du hinayup. Sakay mineta de be siya a nagpahusay ta meadu a buhék. Ey kinagi de ni Jesus, a “Ti Juan a Mégbinyag, éy pinaange na kame se diko. I gustu na a mapospusan.” kagi de, “éng siko kan a talaga tu nipangako na Diyos a umange se a tagapagligtas me, o maguhay kame pa ta esa?” ");
INSERT INTO dgc_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ey kinagi ni Jesus dide, a “Basta kagi moy san ni Juan i mineta moya ta éye, a méketa dén du buhék, sakay du lumpu éy mékapaglakad dén side. Sakay kagi moy be diya a naghusay dén du te saket a ketong, sakay mékabati dén du tuléng. Sakay nabuhay a huway du pate. Sakay kagi moy be ni Juan a tinétolduan ko du mahirap a tolay ta Mahusay a Baheta. ");
INSERT INTO dgc_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ey masuwerte a talaga,” kagi ni Jesus, “du éwan mégidel diyakén.” ");
INSERT INTO dgc_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Nadid, to kéhektat dén du alagad ni Juan, éy négkagi ti Jesus du tolay sa ta tungkul diya. “To kéluwas moy ni Juan ta ilang a lugar,” kagi na, “éy bakit kam inumange diya? Gustu moy wade meta tu lélake a mehina a koman san i lamon a sésébyugén na pahés? ");
INSERT INTO dgc_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","O siguru gustu moy meta tu lélake a te badu ta kamahalan? Pero éwan, da du te badu ta kamahalan, éy mégiyan side ta bile no hari. ");
INSERT INTO dgc_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","I inange moy ngani sa a meta moy éy purupeta! O, tama ya. Ey maigi ngani ti Juan du iba a purupeta. ");
INSERT INTO dgc_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Da ti Juan i nihulaa to kasulatan, to pégkagi na, a ‘Tandaan moy,’ kagi na Diyos; ‘siya i pinakangbégi ko. Pégdetulén ko siya diko, monda paghandaén na du tolay ta demtan ko.’ ");
INSERT INTO dgc_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Tandaan moy,” kagi ni Jesus, “du étanan a tolay ta mundua éy éwan tu mataas ni Juan. Pero i mababaa a tolay ta kaharian na Diyos, éy mataas side diya. ");
INSERT INTO dgc_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","“Ey du étanan a tolay a nakabati ni Juan, sakay pati du medukés a tolay, éy nipasakup dén side ta Diyos, a nipabinyag side ni Juan. ");
INSERT INTO dgc_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pero du Pariseyo, sakay du maistu ta rilihiyon, éy inidelan de i kaluuben na Diyos dide, a sala de a ipabinyag ni Juan. ");
INSERT INTO dgc_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Pakodyan ko a méngihalimbawa di tolaya nadid?” kagi ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","“Mara, kapareho side na anak a te eknud ta plasa, a mégpépintasén side ta kaéyag de. Mara kagi de dide, a ‘Tinogtogen me kam, pero éwan kam nagsayaw. Ey to pégsanget me, éy éwan kam nalungkut dikame.’ ");
INSERT INTO dgc_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ey kona be sa di tolaya,” kagi ni Jesus, “da ugali ni Juan, éy nagkulasiyon, a éwan méginom ta alak, éy pinintasan de a hinayup. ");
INSERT INTO dgc_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Pero sakén, éy mahusayék a méngan éy ta méginom, éy pintasanék de be, a kagi de a medémoték a méngan éy ta méginom. Sakay pintasanék de be a mékiagumék du makasalanan a tolay, sakay du mégpabuwes. ");
INSERT INTO dgc_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pero pabayan moy ya. Tukoy moy éng tama i gimet ko bagay meta moy du bunga ko, éng mahusay.” ");
INSERT INTO dgc_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Nadid i esa a Pariseyo, éy inakit na ti Jesus a méngan to bile na. Ey inumange sa ti Jesus a méngan. ");
INSERT INTO dgc_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ey nadid, te bébe ta éya a banuwan a medukés i ugali naa. Ey pékabaheta na a méngan ti Jesus to bile no Pariseyo, éy binugtong na i esa a boti a te lasén a pabango, ");
INSERT INTO dgc_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","sakay inumange siya to bile. Ey sinuménsén siya to adég ni Jesus, a mégsanget siya. Tulos binisa na tu tikéd ni Jesus to léwa na, sakay pinahiden na to buk na, sakay inahoben na tu tikéd na, sakay nibulak na tu pabango. ");
INSERT INTO dgc_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ey tu Pariseyo, péketa na ta éya, éy kinagi na ta isip na, a “Eng tunay a purupeta ti Jesus, éy tukoy na a medukés i éya a bébe, a sawayén na siya a mangkébil diya.” ");
INSERT INTO dgc_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ey nadid, kinagi ni Jesus to Pariseyo, a “Simon, te istoriaék diko.” “Ey anya, Maistu?” kagi no Pariseyo. ");
INSERT INTO dgc_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Eng mara,” kagi ni Jesus, “éy te lélake a nagpotang ta éduwa a tolay. I utang no esa éy lima kan a datos a kuhata. Ey tu utang no esa man éy limapulu san a kuhata. ");
INSERT INTO dgc_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ey nadid, da pareho side a éwan nakabayad to lélake, éy pinagpasensiyaan na side a éduwa, a pinabayan na san dén tu utang de diya. Ey nadid, Simon,” kagi ni Jesus, “anya i isip mua? Ti ésiya dide a éduwa i magmahala to lélake a nagpotang?” ");
INSERT INTO dgc_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","“Ey siguru,” kagi ni Simon, “éy tu te utang ta dikél, da pinagpasensiyaan siya no lélake ta mahigit pa to esa.” “Ey tama ka,” kagi ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ey nadid, péngsuleg ni Jesus to bébe, éy kinagi na to Pariseyo, a “Entan mo i bébeae, Simon. Siya i kahulugina na éya a halimbawa. Da to késdép ko ta bile moyae, éy éwanék mo inatdinan ta dinom a pagugisan ko ta tikéd kua. Pero siya, éy inugisan na ta léwa na, a pinahiden na ta buk na. ");
INSERT INTO dgc_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ey to késdép ko se, Simon, éy éwanék mo inahoben. Pero siya, sapul to késdép ko, éy éwan tu tahan ta pégéahob na ta tikéd kuae. ");
INSERT INTO dgc_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ewan mo pinahiden i ulo kua ta maski mura a langis. Pero siya, éy nipahid na i memahal a pabango ta tikéd kua. ");
INSERT INTO dgc_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ey nadid, Simon,” kagi ni Jesus, “i dikél a pégmahal na a nipeta na diyakén, éy saya i katunayana a pinagpasensiyaan dén siya ta kasalanan na a meadu. Pero tu te kétihék san a kasalanan, éng pagpasensiyaan ko, éy kétihék be i pégmahal na diyakén.” ");
INSERT INTO dgc_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nadid, kinagi ni Jesus to bébe, a “Pagpasensiyaan ka dén na Diyos ta kasalanan mo.” ");
INSERT INTO dgc_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ey du iba a tolay a méngan ta éya, pékabati de ta éya, éy kinagi de ta isip dia, a “Anya i lélakeae? Bakit isip na a siya i maaria a mangibut ta kasalanan na tolay ta Diyos?” ");
INSERT INTO dgc_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ey kinagi ni Jesus to bébe, a “Neligtas ka dén dahil ta péniwala mo diyakén. Ikad mo dén, a diyan ka métageg.” ");
INSERT INTO dgc_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nadid, kétapos na éya, éy tinumulos ti Jesus du banubanuwan, a nagpahayag siya ta Mahusay a Baheta tungkul ta péghari na Diyos. Ey kaguman na du labindalawa a alagad na. ");
INSERT INTO dgc_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ey kaguman na be i séngasénganya a bébe a pinahusay ni Jesus ta saket. Sakay du iba a bébe a pinahusay na a hinayup. I esa dide éy ti Maria Magdalena, a inibutan ni Jesus ta pitu a dimonyo. ");
INSERT INTO dgc_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Sakay tu esa man dén éy ti Juana a asawa ni Kusa. (Ti Kusa éy mataas a katulung ni Hari Herod.) Sakay kaguman de be ti Susana, sakay meadu be a iba a bébe. Side a bébe, éy ginégastos de tu ari-arian de ta péngtulung de de Jesus. ");
INSERT INTO dgc_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nadid, te meaadu a tahod a tolay a dinumulug ni Jesus, a gébwat ta iba-iba a banuwan. Ey kinagi ni Jesus dide i halimbawa a éye. ");
INSERT INTO dgc_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Eng mara,” kagi na, “éy te esa kan a lélake a mégsabug to binhi na. Ey to pégsabug na éy te sénganya wade a butil a minepégsek to dilan, a kineyudak na tolay, sakay kinan na manok. ");
INSERT INTO dgc_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ey te sénganya wade be a nepégsek to bito-bito; éy to kétubu na ta kétihék, éy minalanés, da memade san tu mebito a luta. ");
INSERT INTO dgc_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ey te sénganya wade be a nepégsek to kalamonan, éy nailongan na lamon. ");
INSERT INTO dgc_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ey tu iba a binhi, éy nesabug kan dén ta mahusay a luta. Ey tinumubu ina. I bawat butil éy nagohay ta tégsésandaan. Ey nadid,” kagi ni Jesus, “éng makabati kam, éy baten moy ya.” ");
INSERT INTO dgc_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nadid, du alagad ni Jesus, éy nipakelagip de diya éng anya i kahulugen na éya a halimbawa. ");
INSERT INTO dgc_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ey kinagi ni Jesus, a “Ipeta san dikam na Diyos i kahulugen na lihim a tungkul ta péghari na ta tolay. Pero du iba a tolay, éy halimbawa san i iyétoldu kua dide, da maski metaék de, a sakay mégbati side diyakén, éy éwan de mapospusan.” ");
INSERT INTO dgc_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Nadid, saye i kahulugen no halimbawa tungkul ta mégsabug,” kagi ni Jesus. “Mara tu binhi, éy saya tu kagi na Diyos. ");
INSERT INTO dgc_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ey tu dilan a nepégsikan na sénganya a butil, éy saya du tolay a makabati ta kagi na Diyos. Pero dumemét ti Satanas dide, a agewén na ta isip de tu kagi a nabati de, monda éwan side méniwala a tulos meligtas side. ");
INSERT INTO dgc_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ey tu mebito a luta a nepégsikan na iba a butil, éy saya du tolay a makabati ta kagi na Diyos, a tanggapén de, a tulos masaya side. Pero éwan side makatagal, da éwan makagimot tu binhi ta isip dia. Méniwala side ta sandali san, pero pabayan de éng dumemét dide i kahirapan de. ");
INSERT INTO dgc_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ey tu kalamonan a nepégsikan na iba a butil, éy saya du tolay a makabati ta kagi na Diyos, pero éwan mégbunga tu kagi na Diyos ta isip dia, da i nakailonga dide éy tu pégisip de ta kabuhayan de, sakay ta kayamanan de, sakay ta kasayaan de. ");
INSERT INTO dgc_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ey tu mahusay a luta a minesabugen na iba a butil, éy saya du tolay a makabati ta kagi na Diyos, a tulos tanggapén de ta isip de, a sésundin de a hanggan magbunga ta mahusay.” ");
INSERT INTO dgc_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Anya wade,” kagi ni Jesus; “taben moy i simbu, a tulos taklében moy ta pégtakalan? O isahok moy ta kama? Ewan, da iedton moy ta lamesa, monda matanglawan du somdép ta bile. ");
INSERT INTO dgc_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ey maski anya a meliso nadid, éy mademlagen ta esa a panahun. Sakay maski anya i ilihim na tolay nadid, éy mehayag ta esa a panahun. ");
INSERT INTO dgc_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Nadid,” kagi ni Jesus, “éy isipén moy tu kagi ko dikam. Dahilan du mégéisipén ta itoldu kua, éy dagdagen na Diyos i isip dia. Pero du metamad a mégisip ta itoldu kua, éy bawasan na Diyos i akala de a édse to isip de a hanggan éwan side tu mapospusan.” ");
INSERT INTO dgc_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Nadid, éy dinumemét sa tu ina ni Jesus sakay du top na. Pero éwan side nakaadene diya, dahil ta meaadu a tolay. ");
INSERT INTO dgc_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ey kinagi du tolay diya, a “Kéye dén ta luwas dena mo éy du tétotop mo, a gustu de ka meta.” ");
INSERT INTO dgc_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ey kinagi ni Jesus du tolay sa, a “Du mégbati ta kagi na Diyos, a sakay sundin de, éy side i ina kua éy ta tétotop ko.” ");
INSERT INTO dgc_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","To esa a aldew, éy sinumakay de Jesus to abeng, sakay kinagi na du alagad na, a “Umahabes kitam dén ta dibilew.” ");
INSERT INTO dgc_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ey to péglakad de, éy nekatidug ti Jesus. Ey inabut side na mesibét a unos, a hanggan da talaga a matabuwan tu abeng, a adene dén side a mabagbag. ");
INSERT INTO dgc_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Kanya linukag siya du alagad na, a kinagi de, a “Maistu, omléd kitam dén!” Ey ti Jesus, kéikat na éy sinaway na tu pahés sakay tu dikél a tagmék, éy hinumintu side, a tulos a naglantap dén tu diget. ");
INSERT INTO dgc_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ey kinagi na du alagad na, a “Bakit, éwan kam bale pabi méniwala diyakén?” Ey du alagad, éy nagtaka side, a inumanteng dén side, a kinagi de, a “Anya wade i lélakeae? Sawayén na san i pahés éy ta tagmék, éy méniwala side diya!” ");
INSERT INTO dgc_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Nadid éy inumange side ta banuwan na tolay a Gadereno, a édse ta dibilew na Galilea. ");
INSERT INTO dgc_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ey to kéahawas ni Jesus, éy sinambat siya no esa a lélake a taga éya, a hinayup. Nale siya a uba, sakay éwan siya mégiyan to bile, éngˈwan mégiyan dén siya to kapusanto. ");
INSERT INTO dgc_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Meadu dén a beses éy bébang-awén siya no dimonyo. Sakay pati éy dinikép siya du tolay, a ginapus de tu kamét na sakay na tikéd na ta kadena. Pero basta binabégsot na tu kadena, sakay tulos pinaginan siya no dimonyo ta ilang a lugar. Nadid, péketa na ni Jesus, éy kinumélanget siya a linumugmuk to harap na, a kinagi na diya ta medegsén, a “Anya i pékialam mua diyakén, Jesus? Siko i anak na mataas a Diyos! Diyanék pad parusaan!” Kinagi dén no hinayup i éya, da inutusan dén ni Jesus tu medukés a espiritu a umibut dén diya. ");
INSERT INTO dgc_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ey kinagi ni Jesus diya nadid, a “ti ésiya i ngahen mua?” Ey “ti keaduan,” kagi na, “i ngahen kua.” Kanya kinagi na i éya, éy te meadu a dimonyo a mégiyan diya. ");
INSERT INTO dgc_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","32","Nadid, éy te meadu sa a babuy a mégkan to disat no buked ta éya. Ey du dimonyo a édse to lélake, éy dinumaying side ni Jesus, a diyan na side iébut ta pégparusaan a lugar ta Dinatagen, éngˈwan, pakultaden na side a umagton ta bégi du babuy. Ey pinaagton sa side ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Kanya du dimonyo, éy inumibut side to lélake, a tulos sinomdép side du babuy. Ey du étanan a babuy, éy nagpaginan side a bulnok, a sinumegbu side to diget, a tulos de a minalimés. ");
INSERT INTO dgc_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ey nadid, du mégbantay du babuy, péketa de ta éya, éy ginuminan side. Ey nibébaheta de du étanan to banuwan de. ");
INSERT INTO dgc_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ey du tolay, éy inumange side ni Jesus, monda meta de éng anya i nanyaria. Ey kédemét de ni Jesus, éy neta de sa tu lélake a hinayup, a éwan dén tu dimonyo diya, a te eknud san siya to harap ni Jesus, a mahusay dén. Sakay te badu dén siya. Ey du tolay éy inumanteng side. ");
INSERT INTO dgc_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ey du tolay sa a minaketa to nanyari, éy nibaheta de du iba éng kodya a naghusay tu lélake a hinayup. ");
INSERT INTO dgc_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ey du tolay a Gadareno, éy nipékiohon de ni Jesus a humektat siya to lugar de, da méganteng side a tahod. Kanya sinumakay man dén de Jesus to abeng de, sakay hinumektat dén side. ");
INSERT INTO dgc_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ey tu lélake a ginamot ni Jesus, éy gustu na a kumuyog. ");
INSERT INTO dgc_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Pero kinagi ni Jesus diya, a “Sumoli ka san nadid ta bile moy, sakay ikagi mo dide i ginimet na Diyos diko.” Kanya tu lélake, éy nagsoli siya to banuwan na, a nibaheta na du étanan a tolay sa tu ginimet ni Jesus diya. a Minangkébil Ni Jesus ");
INSERT INTO dgc_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nadid, késoli de Jesus to kinagébwatan de to dibilew, éy tinanggap siya du tolay, da nale side a naguhay diya. ");
INSERT INTO dgc_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ey inumadene diya i esa a lélake, a ti Hayro i ngahen na, a tagapamahala to kapilya ta éya. Ey dinumapa siya to harap ni Jesus, a dinumaying diya a umange to bile na, ");
INSERT INTO dgc_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","da tu anak na a isesa, a dalagita, éy adene a mate. Ey to péglakad ni Jesus to bile na, éy meaadu a tolay a kinumuyog, a hanggan da mepiit dén tu dilan a péglakaden na. ");
INSERT INTO dgc_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ey to péglakad de éy kaununod ni Jesus i esa a bébe a te saket. Labindalawa dén a taon siya a mégdédigién. Inubus na dén tu kabuhayan na ta pégpagamot na, pero éwan tu makagamot diya. ");
INSERT INTO dgc_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ey nadid, éy inumadene siya to adég ni Jesus, sakay kembilan na tu ontok san no badu na. Ey basta naghusay siya agad. ");
INSERT INTO dgc_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ey ti Jesus, éy kinagi na, a “Ti ésiya i nangkébila diyakén?” Ey to éwan tu nangamin, éy kinagi ni Pedro, a “Bakit, Maistu, ipakelagip mo ya? Meséldit-séldit kitam didi tolayae! Meadu i méngkébil diko!” ");
INSERT INTO dgc_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ey “Ewan,” kagi ni Jesus; “naramdaman ko a te nangkébil diyakén, a naghusay ta pamag-itan na kapangyarian kua.” ");
INSERT INTO dgc_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ey tu bébe, péketa na a éwan bale nelihim tu ginimet na, éy namégpég siya to anteng na, a tulos tinumokém to tikéd ni Jesus. Sakay kinagi na ta harap du tolay sa éng bakit na kembilan ti Jesus, sakay éng kodya siya a naghusay agad. ");
INSERT INTO dgc_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ey kinagi ni Jesus diya, a “Anéng, pinahusay ka dén na péniwala mo diyakén. Ikad mo dén.” ");
INSERT INTO dgc_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Nadid, mégkagi pabi ti Jesus to bébe, éy te lélake a dinumemét a gébwat to bile no tagapamahala to kapilya, a kinagi na diya, a “Minate dén tu anak mo. Diyan mo dén abalaén i maistua.” ");
INSERT INTO dgc_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pero ti Jesus, pékabati na to kinagi na, éy kinagi na to tagapamahala, a “Diyan ka méganteng. Umasa ka san diyakén, éy maghusay tu anak mo.” ");
INSERT INTO dgc_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ey nadid, kédemét de to bile, éy sinaway ni Jesus du iba a somdép. Basta i pinasdép na sana éy de Pedro, sakay ti Juan, sakay ti Santiago, sakay tu magulang no anak. ");
INSERT INTO dgc_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ey to késdép de, éy mégsésangitén dén du tolay to lubuk, dahil to anak. “Diyan kam mégsanget,” kagi ni Jesus. “Ewan minate i anaka. Natidug san siya.” ");
INSERT INTO dgc_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ey du tolay sa, éy pinégngihitan de san ti Jesus, da tukoy de a nate dén tu anak. ");
INSERT INTO dgc_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Pero ti Jesus, éy kembilan na tu kamét na, sakay kinagi na diya, a “Anéng, umégkat ka dén!” ");
INSERT INTO dgc_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ey minabuhay dén tu anak, a inumégkat siya agad. Ey inutusan side ni Jesus a magpakan diya. ");
INSERT INTO dgc_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ey tu magulang na, éy mégtaka side a tahod. Ey nibilin dide ni Jesus a diyan de iyébaheta ta maski ti ésiya i nanyaria. ");
INSERT INTO dgc_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Nadid, nipauwet ni Jesus du labindalawa a alagad na, sakay inatdinan na side ta kapangyarian a monda maari side a mégpaibut du dimonyo, sakay mégpahusay du te saket. ");
INSERT INTO dgc_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Tulos pinéglakad na side a mégpahayag ta tungkul ta péghari na Diyos ta tolay. Sakay inutusan na side a mégpahusay du te ladu. ");
INSERT INTO dgc_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","“Diyan moy kébilén i bilon moya,” kagi na. “Maski sahukod, maski suput, maski kanén moy, maski kuhata, maski pégbaraduan moy, éy diyan moy kébilén. ");
INSERT INTO dgc_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Sakay éng somdép kam ta tulusan moy a bile,” kagi na, “éy tumulos kam sa a hanggan éwan kam maglakad. ");
INSERT INTO dgc_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Sakay du tolay na esa a banuwan, éng éwan de kam tanggapén, éy ta kéhektat moy ta éya, éy ihalimbawa moy dide a ipagpag moy ta tikéd moya tu alikabuk. Saya i tanda moya dide a te kasalanan side.” ");
INSERT INTO dgc_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Nadid, to pégkagi ni Jesus ta éya du alagad na, éy hinumektat side a inumange side ta meadu a bariyo-bariyo. Nagpahayag side ta Mahusay a Baheta, sakay pinahusay de be i meadu a tolay a te ladu. ");
INSERT INTO dgc_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Nadid, ti Mayor a Herod, éy nabaheta na i étanan a gégemtén ni Jesus. Ey nagulo dén siya tu isip, da kagi na sénganya a tolay a ti Jesus éy ti Juan kan a Mégbinyag, a minabuhay kan dén. ");
INSERT INTO dgc_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Sakay i iba éy akala de éy ti Elias siya, a nagsoli kan dén a gébwat ta langet. Sakay kagi du iba, a ti Jesus kan i esa du purupeta to araw, a minabuhay dén. ");
INSERT INTO dgc_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Pero, “Ewan,” kagi ni Herod, “da pinaputol ko dén ti Juan. Pero ti ésiya wade,” kagi na, “i éya a lélake a mébaheta ko?” Kanya ti Herod, éy pilitén na a meta ti Jesus. ");
INSERT INTO dgc_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Nadid, du apostol, éy nagsoli dén side ni Jesus, a kinagi de diya i ginimet de. Ey inakit side ni Jesus, a umange side to esa a lugar a éwan tu tolay, ta Betsayda. ");
INSERT INTO dgc_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pero du meadu a tolay, pékabaheta de to inangayan de, éy tinumagubet side. Ey pékaabut de de Jesus, éy tinanggap na side, sakay nagtoldu siya dide ta tungkul ta péghari na Diyos ta tolay. Sakay pinahusay na be du te ladu. ");
INSERT INTO dgc_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nadid, to giapon dén, éy du alagad éy kinagi de ni Jesus, a “Maistu, péglakadén mo dén di tolayae, monda umange side du bariyo-bariyo ta palebut ta éye, a matidug sa side, sakay monda maketa sa side ta kanén de. Da édse kitam, Maistu, ta ilang a lugare,” kagi de. ");
INSERT INTO dgc_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Pero kinagi ni Jesus dide, a “Sikam éy pékanén moy side.” “Ey pakodyan tam,” kagi de, “i bilon tama éy lima san a momon a tinapay, sakay éduwa a pindang. Ataay,” kagi de, “gustu mo umuli kame beman a mamugtong ta kanén a para didi meaadua a tolaye!” ");
INSERT INTO dgc_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Te manga lima a libu a lélake ta éya.) Ey kinagi ni Jesus du alagad na, a “Pégiknuden moy du tolay ta puktu-puktu a téglélimapulu.” ");
INSERT INTO dgc_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ey kona ngani dén sa i ginimet dia. ");
INSERT INTO dgc_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ey inalap ni Jesus tu lima a tinapay, sakay tu éduwa a pindang, sakay tinumangad siya ta langet a nagpasalamat ta Diyos; sakay pinuseng-puseng na tu tinapay sakay tu ikan, sakay niutus na du alagad na a nihayin de du tolay. ");
INSERT INTO dgc_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ey néngan side a étanan, a minabsog side. Ey hinempésan du alagad tu sobha, éy naputat pa tu sapulu éy ta éduwa a gatang! ");
INSERT INTO dgc_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","To esa a aldew, éy nanalangin ti Jesus a isesa, éy inumadene diya du alagad na. Ey kinagi na dide, a “Ti ésiyaék kan ayun ta kagi na tolay?” ");
INSERT INTO dgc_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ey kinagi du alagad, a “I kagi kana na iba éy ti Juan ka kan a Mégbinyag. Kagi man dén na iba a ti Elias ka kan. Ey te iba be a mégkagi a purupeta ka kan a nabuhay a huway.” ");
INSERT INTO dgc_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","“Ey sikam,” kagi ni Jesus, “anya i isip moya? Ti ésiyaék?” Ey kinagi ni Pedro, a “Siko i Cristo a tiniyak na Diyos a tagapagligtas ta mundua!” ");
INSERT INTO dgc_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ey nibilin dide ni Jesus, a diyan de kékagin ta maski ti ésiya a siya i Cristo. ");
INSERT INTO dgc_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ey nipagtapat ni Jesus du alagad na a siya tu lélake a gébwat ta langet; éy dapat magtiis siya ta meadu, sakay idelan siya du te tungkulin a Judeo. “Sakay ipabunoék de,” kagi na. “Sakay ta ikatélo a aldew éy mabuhayék.” ");
INSERT INTO dgc_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Sakay kinagi ni Jesus du étanan sa, a “Eng ti ésiya i te gustu a ipasakup diyakén, éy kailangan éy pabayan na a aldew-aldew i sarili na, sakay kumuyoyog diyakén, a maski bunon siya na tolay. ");
INSERT INTO dgc_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Dahilan tu maghangad a meligtas tu buhay na, éy mebut a talaga. Pero tu mégpabaya ta buhay na alang-alang diyakén, éy siya i mabuhaya a éwan tu katapusan. ");
INSERT INTO dgc_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Anya i pékinabanga na esa a tolay éng siya i mayamana ta étanan, éng éwan na makamtan i buhay a éwan tu katapusan? ");
INSERT INTO dgc_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","I maski ti ésiya a mégpabaya diyakén nadid, sakay tu mégpabaya ta pégtoldu kua,” kagi ni Jesus, “éy sakén éy pabayan ko be side ta késoli ko se a kaguman ko du anghel ko, a te kébilék ta kapangyarian Nama ko. Da sakén i lélake a gébwat ta langet. ");
INSERT INTO dgc_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ey tandaan moy ye,” kagi na. “Te sénganya se dikam a éwan mate hanggan éwan de meta i pégsapul na Diyos a maghari ta tolay.” ");
INSERT INTO dgc_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Nadid, kélipas na manga walu a aldew, éy kinuyog ni Jesus de Pedro, sakay ti Juan, sakay ti Santiago. Ey inumange side to melangkaw a buked, a manalangin. ");
INSERT INTO dgc_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ey to pénalangin na, éy nabagu dén tu mata na. Sakay tu badu na, éy linumatak a dinumemlag dén. ");
INSERT INTO dgc_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ey bigla a te éduwa a lélake ta éya, a kauhon ni Jesus. Ti Moises side, sakay ti Elias, ");
INSERT INTO dgc_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","a medemlag be side. Pinéguhunan de i adene dén a ikate ni Jesus ta Jerusalem. ");
INSERT INTO dgc_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Nadid de Pedro, éy tidug dén side, pero bigla side a nalukag, a neta de ti Jesus a nangislap, sakay tu éduwa a kaguman na a te taknég sa. ");
INSERT INTO dgc_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ey nadid, to péglakad du éduwa, éy kinagi ni Pedro ni Jesus, a “Maistu, maigi pa éy édse kitam san dén. Pagbile me kam ta étélo a kékétihék a bile; esa diko, esa ni Moises, sakay esa ni Elias.” (Talaga a éwan napospusan ni Pedro i kékagin naa.) ");
INSERT INTO dgc_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nadid, mégkagi pabi ti Pedro, éy tinaklében side no kuném. Ey inumanteng du alagad, da kinumulabut dide tu kuném. ");
INSERT INTO dgc_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ey kinagi no boses to kuném, a “Séˈ ina i anak kua a pinili ko. Baten moy siya.” ");
INSERT INTO dgc_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ey to pékabati de ta éya, éy éwan dén tu éduwa a lélake a nékiohon ni Jesus. Ey éwan pabi kinagi du alagad tu mineta de ta maski ti ésiya, éngˈwan lalo de a nilihim. ");
INSERT INTO dgc_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Nadid, to kagagabian, a késoli de a gébwat to buked, éy nasambat de i meaadu a tolay. ");
INSERT INTO dgc_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ey kinagi no esa a lélake dide, a “Maistu, entan pad i anak kuae a isesa! ");
INSERT INTO dgc_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Hinayup siya. Basta éatagén siya no espiritu, a tulos mégkélanget siya, sakay pégkaramrién na siya a hanggan mégbugak i labi naa. Palagi a pésakitan na siya, Maistu, sakay éwan na siya pébayan. ");
INSERT INTO dgc_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ey nékiohonék dén du alagad mo, Maistu, a ibutan de tu espiritu, pero éwan de kaya.” ");
INSERT INTO dgc_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ey kinagi ni Jesus, a “Medukés a lahi di tolaya ta éye, da éwan kam méniwala! Pakodyan ko se a mégtiis dikam, a ménatili dikam? Nay,” kagi na to lélake, “iange mo se tu anak mo.” ");
INSERT INTO dgc_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nadid, to péngiadene de to anak, éy bigla a pinalugmuk siya no dimonyo, tulos pinagkaramre na siya. Pero pinégkagian ni Jesus tu medukés a espiritu, sakay pinahusay na tu anak, sakay nisoli na siya nama na. ");
INSERT INTO dgc_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ey du étanan a tolay sa, éy nagtaka side ta dikél a kapangyarian na Diyos. Nadid, mégtaka pabi dudu tolay ta étanan a ginégimet ni Jesus, éy kinagi na du alagad na, ");
INSERT INTO dgc_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","a “Tandaan moy i kagi ko a éye dikam: Sakén i lélake a gébwat ta langet. Ey itokyonék de a talaga.” ");
INSERT INTO dgc_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pero du alagad, éy éwan de napospusan i éya a kinagi ni Jesus dide. Da niliso dide na Diyos i kahulugen na. Ey nasanike side a nagpakelagip diya éng anya i kahulugen na éya a kagi. ");
INSERT INTO dgc_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Nadid, négpasuway du alagad éng ti ésiya dide i mataasa. ");
INSERT INTO dgc_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ey ti Jesus, éy tukoy na dén i isip dia. Kanya inalap na tu esa a anak, sakay pinataknég na siya to giled na, ");
INSERT INTO dgc_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","sakay kinagi na dide, a “Maski ti ésiya i tumanggap ta kona se a anak dahil ta péniwala na diyakén, éy bilang sakén dén i tanggapén naa. Sakay tu tumanggap diyakén, éy bilang tanggapén na be tu nagpaange se diyakén. Dahilan,” kagi na, “tu mababa dikam, éy siya i mataasa ta mata na Diyos.” ");
INSERT INTO dgc_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Nadid, kinagi ni Juan, a “Maistu, neta me i esa a lélake a nagpaibut du dimonyo a gégamitén na i ngahen mua, éy sinaway me siya, da éwan sakup na gurupu tam.” ");
INSERT INTO dgc_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","“Ewan,” kagi ni Jesus, “diyan moy sésawayén i kona sa a tolay. Dahilan,” kagi na, “tu éwan kontara dikam, éy kampi siya dikam.” ");
INSERT INTO dgc_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Nadid, te sénganya san dén a panahun, éy umontok dén ti Jesus ta langet. Ey naisip na dén a umange siya ta Jerusalem. ");
INSERT INTO dgc_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ey inutusan na i sénganya a neditol diya. Ey mineditol side, a sinomdép side to esa a banuwan ta Samaria, monda ipaghanda de ta tulusan na. ");
INSERT INTO dgc_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pero du tolay a Samaritano ta éya, éy éwan de siya tanggapén, da tukoy de a tumulos siya ta Jerusalem. ");
INSERT INTO dgc_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ey ti Santiago éy ti Juan, péketa de ta éya, éy kinagi de, a “Anya, Panginoon, gustu mo wade éy magpadibe kame ta apoy a gébwat ta langet, monda mapuksa side?” ");
INSERT INTO dgc_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Pero pinaginglan side ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ey tinumulos san side ta iba a banuwan. ");
INSERT INTO dgc_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Nadid, to péglakad de, éy te esa a lélake a kinagi na ni Jesus, a “Kumuyugék diko maski ahe i angayan mo.” ");
INSERT INTO dgc_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ey kinagi ni Jesus diya, a “Isipén mo pa, da entan mo, maski aso, éy te pégiyanan. Sakay du manok éy te lobun a pégiyanan de. Pero sakén a lélake a gébwat ta langet, éy éwanék tu katidugen.” ");
INSERT INTO dgc_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ey kinagi ni Jesus to lélake a esa, a “Kumuyog ka diyakén a maging alagad ko.” Pero kinagi no lélake, a “O, Panginoon, pero pabayanék pad pa, monda angen ko pa ielbéng tama ko.” ");
INSERT INTO dgc_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","“Ewan,” kagi ni Jesus. “Pabayan mo du éwan méniwala ta Diyos a méngielbéng to ama mo. Pero siko, éy umange ka magpahayag ta tungkul ta kédemét na Diyos a maghari.” ");
INSERT INTO dgc_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ey kinagi diya no esa a lélake, a “Sakén, éy kumuyoyogék diko, Panginoon. Pero pakultadenék mo pa a ange magpaalam to pamiliya ko.” ");
INSERT INTO dgc_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ey kinagi ni Jesus diya, a “Tu alagad ko a mégéabalaén ta ipatarabaho ko diya, éy éwan siya maari a ipasakup ta kaharian na Diyos.” ");
INSERT INTO dgc_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Nadid, kétapos na éya, éy pinili ni Jesus i pitu a pulu a kakaguman na, a inutusan na side a péglakadén na side ta tégdéduwa, a magdetol diya ta bawat angayan na a bariyo-bariyo. ");
INSERT INTO dgc_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","“Meadu i gapasén,” kagi na, “pero kulang i magapas. Kanya ipanalangin moy to te koo ta kapahayan, a paange na i meadu a magapas ta kapahayan na. ");
INSERT INTO dgc_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ikad moy dén,” kagi na. “Péglakadén ta kam du medukés a tolay. Mara, koman kam i tupa a méglakad ta lubuk du metapang a aso. ");
INSERT INTO dgc_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Diyan moy kébilén i kuhata, o maski suput, o reserba a sinelas. Sakay diyan kam magabala a mégéuhunén du kasambat moy ta dilan. ");
INSERT INTO dgc_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Sakay éng somdép kam ta tulusan moy a bile, éy batién moy du édsa sa, a kagi moy, a ‘Demtan kam maka na kapayapaan.’ ");
INSERT INTO dgc_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ey nadid, éng mahusay du mégiyan sa, a tanggapén de kam, éy kagbian side na Diyos a talaga. Pero éng éwan side mahusay, éy bawen moy tu nipangbati moy dide. ");
INSERT INTO dgc_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ey diyan kam uméagton ta iba-iba a bile, éngˈwan tumulos kam ta isesa san a bile. Sakay diyan kam mésanike a méngan ta ihayin de dikam, da dapat aguman kam du tolduan moy. ");
INSERT INTO dgc_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Bagay dumemét kam ta esa a banuwan, éng tanggapén de kam, éy méngan kam ta ihayin de dikam. ");
INSERT INTO dgc_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Sakay pahusayén moy du te ladu ta éya a banuwan, sakay ibaheta moy dide,” kagi ni Jesus, “a adene dén a dumemét i péghari na Diyos dide. ");
INSERT INTO dgc_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pero éng dumemét kam ta banuwan, éng éwan de kam tanggapén, éy kagin moy dide, a ");
INSERT INTO dgc_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Pagpagen me i alikabuk na banuwan moya ta tikéd mia, a saya i tanda me dikam,’ kagi moy, ‘a te kasalanan kam ta Diyos.’ Sakay kagi moy be dide, a ‘Talaga a dumemét dikam i Diyos a maghari, éy inidelan moy dén!’ ");
INSERT INTO dgc_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Katutuhanan a kédemét na péghukum na Diyos, éy lalo a mehirap i sapitén du tolay na éya a banuwan, kesira to sinapit du taga Sodoma to araw!” ");
INSERT INTO dgc_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Nadid, pégisip ni Jesus du mégidel diya a banuwan, éy kinagi na, a “Kakakagbi kam, sikam a taga Korasin! Kakakagbi kam, sikam a taga Betsayda! Da ginimet ko dén ta harap moy i meadu a makataka-taka, éy éwan kam nagsisi. Pero du tolay ta Tiro sakay ta Sidon to araw, éng neta de maka to araw tu mineta moy, éy talaga a nagsisi side. Nagbadu maka dén side ta kostal, sakay mégiknud side ta abu, monda magpatunay side a nagsisi a talaga. ");
INSERT INTO dgc_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kanya ta péghukum na Diyos,” kagi ni Jesus, “éy masiyadu a mehirap i sapitén moy kesira ta sinapit du taga Tiro éy ta Sidon. ");
INSERT INTO dgc_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Sakay sikam a taga Kapernaum,” kagi na, “i pégpalalo moy éy makaabut kam ta langet, pero i abutén moy sana éy impiyerno!” ");
INSERT INTO dgc_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Nadid, kinagi ni Jesus du alagad na, a “maski ti ésiya i mégbati dikam a mégtoldu, éy bilang mégbati be side diyakén. Sakay du mégidel dikam, éy bilang idelanék de be dén. Sakay du mégidel diyakén, éy bilang idelan de be dén tu Ama ko a nagpaange se diyakén.” ");
INSERT INTO dgc_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Nadid, to késoli du pitu a pulu a alagad, éy mésahat side. “Panginoon,” kagi de, “maski du dimonyo, éy médaig me side bagay dinulaw me i ngahen mua a mégpaibut dide!” ");
INSERT INTO dgc_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ey “O,” kagi ni Jesus. “Ey sakén éy mineta ko ti Satanas a linumugmuk. Ey tu kélugmuk na éy mebakség a koman i kilat. ");
INSERT INTO dgc_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ey tandaan moy,” kagi na, “éy niatéd ko dén dikam i kapangyarian a monda maski yudakén moy i medukés a ulag, o maski kumékontara kam ni Satanas, éy éwan kam maanya. ");
INSERT INTO dgc_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pero maski madaig du medukés a espiritu dikam, éy diyan kam masahat ta éya. Engˈwan, i kasahatan moya éy da nilista dén na Diyos tu ngahen moy ta langet.” ");
INSERT INTO dgc_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nadid, ta éya a oras, éy tu Banal a Espiritu, éy pinasahat na ti Jesus. Tulos kinagi ni Jesus ta Diyos, a “Mégpasalamaték diko, Améng. Siko i Panginoon ta langet éy ta mundua. Salamat, Améng, da éwan mo nipékipospos tu kaluuben mo du matalinung a mataas a tolay; éngˈwan i néngipaliwanagen mua éy du mababa. O ngani, Améng, da kona sa i gustu mua. ");
INSERT INTO dgc_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Tama ko a Diyos,” kagi ni Jesus, “éy inatdinanék na ta étanan. Ey éwan tu makatukoy diyakén, éngˈwan Tama ko san. Ey éwan be tu nakatukoy Nama ko, éng éwan sakén san a anak na, sakay du nagpahayagen ko ta tungkul diya.” ");
INSERT INTO dgc_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Nadid, kinagi ni Jesus du alagad na ta lihim, a “Masuwerte kam a talaga, da meeta moy dén tu gimet ko! ");
INSERT INTO dgc_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Da tandaan moy, meadu i purupeta to araw, sakay hari, a gustu de a meta i meeta moya, pero éwan de neta. Sakay gustu de a mabati i mébati moya, pero éwan de nabate.” ");
INSERT INTO dgc_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Nadid, te esa a maistu ta rilihiyon na Judeo, a inumange ni Jesus a mégpakelagip diya, a monda pagkamalién na maka siya. “Maistu,” kagi na, “anya wade i gemtén kua, a monda makaabuték ta buhay a éwan tu katapusan?” ");
INSERT INTO dgc_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","“Ey anya i bébasaén mua ta libru na Diyos tungkul ta éya?” kagi ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ey kinagi no maistu ta rilihiyon, a “I kagia na Diyos to libru na, éy ‘Dapat mahalén mo i Panginoon mo a Diyos ta mahigpit, a isipén mo siya a palagi.’ Sakay i utus a esa, éy ‘Dapat mahalén mo tu kapareho mo a kona ta pégmahal mo ta bégi mo.’” ");
INSERT INTO dgc_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ey “O,” kagi ni Jesus, “tama tu sengbet mo. Sundin mo ina, éy makaabut ka ta buhay a éwan tu katapusan.” ");
INSERT INTO dgc_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nadid tu maistu, éy gustu na a maganap tu kagi na ni Jesus, monda isip du tolay a matalinung siya. Kanya kinagi na ni Jesus, a “Ti ésiya wade i kapareho ko a dapat mahalén ko?” ");
INSERT INTO dgc_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ey saye tu nisengbet ni Jesus diya a istoria: “Mara,” kagi na, “éy te esa kan a lélake a Judeo a inumange ta Heriko, a gébwat ta Jerusalem. Ey to péglakad na, éy sinanéb siya na tulisan. Dinoklos de siya, sakay inalap de tu badu na. Sakay binélbég de a hanggan kétihék a mate, sakay gininanan de. ");
INSERT INTO dgc_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","“Mamaya-maya, éy te sinumalegéd a padi a Judeo. Ey péketa no padi to te tayang a lélake, éy linumekaw siya a sinalinan na san. ");
INSERT INTO dgc_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ey mamaya-maya man dén, éy te sumalegéd be a esa a katulung ta Templo, a Judeo be siya. Ey péketa na to te tayang a lélake, éy sinalinan na be san. ");
INSERT INTO dgc_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Nadid, mamaya-maya man dén, éy te sumalegéd man dén a éwan Judeo. Samaritano siya. Ey péketa na to lélake, éy kinagbian na siya. ");
INSERT INTO dgc_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Inumadene kan siya, a ginamot na tu talitalingo na, sakay binédbéden na ta damit. Nadid, éy nisakay na siya to kabayo na, a niange na to bile a paupaan, sakay inalagaan na sa siya. ");
INSERT INTO dgc_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","“To kagabian na, éy inupaan na tu te koo to bile, a kinagi na diya, a ‘Alagaan mo siya. Ey éng mahigit pa ta éye i gastos mo diya, éy dagdagen ko san ta késoli ko,’ kagi na. ");
INSERT INTO dgc_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Ey nadid,” kagi ni Jesus to maistu, “anya i isip mua? Ti ésiya diden ya a étélo a sinumalegéd i nagpatunaya a mahalén na tu kapareho na?” ");
INSERT INTO dgc_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","“Ey siguru tu éwan Judeo a Samaritano,” kagi no maistu, “da kinagbian na tu te tayang a Judeo.” “Ey anya pa,” kagi ni Jesus. “Ey nadid, éy dapat kona be sa i ahigén mua.” ");
INSERT INTO dgc_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Nadid, to péglakad de Jesus, éy inumange side to esa a bariyo. Ey te bébe sa a ti Marta i ngahen naa. Ey siya, éy pinatulos na de Jesus to bile na. ");
INSERT INTO dgc_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ey to péghanda ni Marta to pénganan de, éy ti Maria a wadi na, éy basta te eknud san to giled ni Jesus, a mégbati to pégtoldu na. ");
INSERT INTO dgc_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ey ti Marta, éy métahanta, da meadu i handaén na. Kanya kinagi na ni Jesus, a “Panginoon, entan mo i wadi kuae, pinabayanék na dén a méghanda ta étanan a tarabaho ko. Utusan mo siya beman a tulunganék na.” ");
INSERT INTO dgc_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Pero kinagi ni Jesus diya, a “Marta, bakit méligalig ka ta sari-sari? ");
INSERT INTO dgc_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Te isesa san a mahalaga a kailangan; éy saya i gimita na wadi muae. Ey éwan maari a sawayén ta siya.” ");
INSERT INTO dgc_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","To esa a aldew, éy nanalangin ti Jesus. Ey to kétapos na, éy kinagi diya no alagad na a esa, a “Panginoon, tolduan mo kame a manalangin, a kona to pégtoldu ni Juan du alagad na to araw.” ");
INSERT INTO dgc_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ey saye tu nitoldu ni Jesus dide. “Kona se i dapat panalangin moy,” kagi na. “‘Améng,’ kagi moy, ‘Purién maka dén na tolay i ngahen mua. Siko maka dén i maghari ta mundua. ");
INSERT INTO dgc_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Atdinan mo kame ta kanén me nadid a aldew. ");
INSERT INTO dgc_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Sakay patawadén mo kame ta kasalanan me; éy sikame, Améng, éy patawadén me be du te kasalanan dikame. Sakay diyan mo kame iharap ta mahigpit a mamuhuba dikame.’” ");
INSERT INTO dgc_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Nadid, nitoldu pa dide ni Jesus i tungkul ta panalangin, a kinagi na, a “Anya wade éng te bigla a dumemét ta kélép ta bile moy, éng éwan ka tu ipakan dide? Anya wade, éng umange ka ta bile no karatig mo, a dulawan mo, a ‘Kadimoy, padimanék pad ta ipakan ko du bisita ko, ");
INSERT INTO dgc_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","da te dinumemét dén ta bile ko, éy éwanék tu ipakan dide.’ ");
INSERT INTO dgc_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ey anya wade éng sumengbet diko tu karatig mo, a ‘Ta gabia dén! Ewanék makapangatéd diko nadid, da tidug kame dén a métatena, a metamadék dén a umégkat. Ey seradu pati be dén tu pintuan me.’ ");
INSERT INTO dgc_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","“Entan moy,” kagi ni Jesus, “metamad tu karatig mo a mangatéd diko ta agidén mo, maski kadimoy mo. Pero éng pilitén mo siya a pilitén, éy umégkat siya a talaga a méngatéd diko ta maski anya a gustu mo. ");
INSERT INTO dgc_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Kanya sikam,” kagi ni Jesus, “éy kona be sa i panalangin moya ta Diyos. Eng mékeged kam ta Diyos, éy atdinan na kam. Eng mégahayok kam, éy paketan na kam. Eng tumuktuk kam ta pintuan na Diyos, éy bukasan na kam. ");
INSERT INTO dgc_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Dahilan maski ti ésiya i magagida ta Diyos, éy atdinan na. Sakay tu mégahayok, éy paketan na. Sakay tu mégtuktuk, éy bukasan siya. ");
INSERT INTO dgc_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Anya,” kagi ni Jesus, “éng magaged du anak moy ta ikan, éy anya i iatéd moya, ulag? ");
INSERT INTO dgc_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O éng magaged dikam ta bunay, éy anya i iatéd moya, kahame? ");
INSERT INTO dgc_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nadid entan moy; maski makasalanan kam a tolay, éy atdinan moy du anak moy ta mahusay. Ey Tama moy ta langet, éwan na beman iatéd i Banal a Espiritu ta magaged diya?” I Kapangyarian Na Ni Satanas ");
INSERT INTO dgc_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Nadid, pinaibut ni Jesus tu dimonyo to lélake a bulol. Ey to pékaibut na dén, éy nakapégkagi dén tu lélake. Ey nagtaka du tolay. ");
INSERT INTO dgc_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pero du iba sa a tolay, éy inupos de ti Jesus, a kinagi de, a “Kanya makapégpaibut siya du dimonyo, éy inatdinan siya ni Satanas ta kapangyarian na. Ti Satanas a mayor du dimonyo.” ");
INSERT INTO dgc_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ey te iba be sa a tolay, a pinuhubaan de ti Jesus, a kinagi de diya, a “Ipeta mo dikame i tanda a makataka-taka a gébwat ta Diyos.” (Gustu de san a meta éng te kapangyarian siya a talaga a gébwat ta Diyos.) ");
INSERT INTO dgc_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pero tukoy ni Jesus i isip de, a kinagi na dide, a “Eng mara, maski ahe a banuwan, éng néglébug side, éy bumagsak a talaga. Sakay maski ahe a bile, éng néglébug side, éy éwan be male i buhay de. ");
INSERT INTO dgc_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ey nadid sakén; bakit kagi moy a inatdinanék ni Satanas ta kapangyarian na a magpaibut du katulung na a dimonyo? Lélbugén beman ni Satanas i sarili na? Eng kona sa, éy bumagsak siya a talaga. ");
INSERT INTO dgc_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Bakit kagi moy a gébwat ni Satanas i kapangyarian ko a mangpaibut ta dimonyo? Ey anya du tolay moy? Eng ibutan de i dimonyo, éwan beman gébwat ta Diyos i kapangyarian de? Kanya side i mégpatunaya a kakabulyan tu péngupos moy diyakén! ");
INSERT INTO dgc_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pero éng ibutan ko du dimonyo ta pamag-itan na kapangyarian na Diyos, éy saya i katunayana a dumemét dén dikam i péghari na Diyos ta tolay. ");
INSERT INTO dgc_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Eng mara,” kagi ni Jesus, “te mesibét a lélake a te armas, a mégbantay ta bile na, éy mahusay san tu kasangkapan na. ");
INSERT INTO dgc_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero éng te lélake a lalo a mesibét diya, a duklusén na siya, éy madaig tu lélake a mégbantay. Sakay tu dumuklos, éy alapén na tu armas na sakay tu kasangkapan na. Ey ti Satanas, éy siya i déduklusén kua. ");
INSERT INTO dgc_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ey tu éwan kampi diyakén,” kagi ni Jesus, “éy kontara diyakén. Ey tu éwan tumulung diyakén a méngidulug ta tolay, éy nangangahulugen a paadeyuén na du tolay diyakén.” Méniwala Ta Diyos Ta Hustu ");
INSERT INTO dgc_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Bagay umibut tu medukés a espiritu ta bégi na tolay,” kagi ni Jesus, “éy méglebut ta ilang a lugar a mégahayok ta imangan na. Nadid, éng éwan tu meeta, éy kagi na, a ‘Magsoliék to kinagébwatan ko a négiyanan ko.’ ");
INSERT INTO dgc_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ey kédemét na, éy dinemtan na a éwan tu lasén, sakay melinis a mahusay dén. ");
INSERT INTO dgc_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kanya inakit na i pitu a iba a espiritu a mas medukés pa diya, sakay sinomdép side a négiyan sa side. Kanya lalo a medukés to neditol i kalagayan na éya a tolay.” ");
INSERT INTO dgc_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Nadid, to pégkagi dén ni Jesus ta éya, éy kinagi no bébe a esa ta lubuk du meadu a tolay, a “Masuwerte ngani dén tu ina mo!” ");
INSERT INTO dgc_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ey, “O,” kagi ni Jesus, “pero lalo a masuwerte du makabati ta kagi na Diyos, éng tulos de a sugsugén!” ");
INSERT INTO dgc_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nadid, to kédulug du tolay ni Jesus, éy kinagi na dide, a “Diden ye a lahi a Judeo, éy magkadukés side! Piliténék moy a ipeta ko dikam i tanda, pero éwanék tu ipeta dikam a tanda, éngˈwan tu nanyari ni Honas to araw. ");
INSERT INTO dgc_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Dahilan tu nanyari ni Honas, éy saya i katunayana du tolay ta Ninibe a pinaange siya na Diyos dide. Ey kona be sa sakén. Te manyari be diyakén a kona ni Honas; éy saya i tandaa dikam a pinaangeék se na Diyos. ");
INSERT INTO dgc_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Kédemét na péghukum na Diyos,” kagi ni Jesus, “éy tu hari a bébe a taga Kabagatan to araw, éy tumaknég siya a méngiabla dikam. Da siya, éy inumange se a gébwat ta adeyo, monda baten na i memahal a pégtoldu ni Solomon. Ey nadid éy te mataas ni Solomon ta éye a mégtoldu dikam, éy éwan moy bébaten. ");
INSERT INTO dgc_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Sakay pati du tolay a taga Ninibe, éy tumaknég be side ta péghukum, a iabla de dikam a lahi a Judeo, da nagsisi side to pégtoldu ni Honas dide. Ey nadid éy te mataas ni Honas ta éye a mégtoldu dikam; éy éwan kam mégsisi!” ");
INSERT INTO dgc_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Ewan tu mégtab ta simbu,” kagi ni Jesus, “a tulos iliso na ta ébut, o taklében na ta pégtakalan. Engˈwan, yedton na ta lamesa, monda matanglawan du somdép ta bile. ");
INSERT INTO dgc_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ey tu mata mo,” kagi na, “éy saya i pinakang-simbu na bégi mua. Kanya éng medemlag i mata mua, éy mademlagen be i étanan a bégi mo. Pero éng mediklém i mata mua, éy mediklém be i bégi mua. ");
INSERT INTO dgc_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Samakatuwid, éng éwan mo tukoy i tama, éy mediklém i isip mua. ");
INSERT INTO dgc_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kanya éng maketa tu isip mo ta mahusay, éy éwan ka tu mali tu isip. Basta tu isip mo éy medemlag a kona ta demlag na simbu.” ");
INSERT INTO dgc_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nadid, to kétapos ni Jesus a mégtoldu, éy inakit siya no esa a Pariseyo a méngan to bile de. Ey to pégeknud de a méngan, ");
INSERT INTO dgc_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","éy mégtaka tu Pariseyo, da napansing na a éwan bale naguges ti Jesus. ");
INSERT INTO dgc_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kanya kinagi ni Jesus diya, a “Bakit sikam a Pariseyo,” kagi na, “éy ugali moy a palagi a mégugues du tasa moy sakay du penggan moy, monda melinis? Pero tu ugali moy a medukés, éy éwan moy malinisan! ");
INSERT INTO dgc_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ayhay,” kagi ni Jesus, “sikam a mégkamali ta dikél! Ginamet na Diyos a talaga i meta na tolay. Pero ginamet na be i éwan meta na tolay. Kanya tukoy na i édse ta isip moya, da ginamet na be ya. ");
INSERT INTO dgc_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Eng gustu moy a ibilang kam na Diyos a melinis kam, éy mangatéd kam du mahirap a tolay. ");
INSERT INTO dgc_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Kagbi kam, sikam a Pariseyo!” kagi na. “Iatéd moy ta Diyos i ikasapulu na kabuhayan moy, a hanggan ta atong moy a éwan tu halaga. Pero pinabayan moy dén tu lalo a mahalaga a kailangan, da dayaén moy tu kapareho moy, sakay éwan moy mahal i Diyos. Maari, mangatéd kam ta Diyos. Pero gemtén moy be i mahalaga a kailangan. ");
INSERT INTO dgc_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Kagbi kam, sikam a Pariseyo!” kagi ni Jesus. “Gustu moy a mégiknud ta pégiknuden na mataas a tolay ta kapilya moy. Sakay gustu moy a saloduan kam na tolay ta plasa na banuwan. ");
INSERT INTO dgc_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kagbi kam, da kapareho kam na lébéng a éwan meta na tolay, a tulos yudakén de, a tulos meahes tu buyok ta tikéd dia!” ");
INSERT INTO dgc_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Nadid, i esa a maistu na rilihiyon, éy kinagi na ni Jesus, a “Maistu, éng mégkagi ka ta kona sina, éy pintasan mo kame be!” ");
INSERT INTO dgc_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","“Ey o ngani,” kagi ni Jesus. “Pati sikam a maistu ta rilihiyon, éy kagbi kam be! Da dagdagen moy i mehirap a utus ta rilihiyon moy, a pilitén moy du tolay a sugsugén de. Pero éwan moy side tulungan ta maski kétihék. ");
INSERT INTO dgc_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Kagbi kam! Ginimet moy du pantiyung du purupeta to araw. Pero du apo-apo moy to araw, éy side ngani dén ya di namunua dide! ");
INSERT INTO dgc_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Meramay kam a talaga du kasalanan de to araw. Da side éy binunu de du purupeta, éy sikam, éy ginimet moy du pantiyung de! ");
INSERT INTO dgc_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kanya kinagi dén na Diyos a paangen na dikam i magtoldu ta kagi na Diyos, sakay apostol. Pero bunon moy i sénganya dide. Sakay du iba éy lélokon moy side. ");
INSERT INTO dgc_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","“Kanya sikam a lahi nadid,” kagi ni Jesus, “éy parusaan kam na Diyos, dahil du purupeta a binunu du apo-apo moy to araw; ");
INSERT INTO dgc_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","sapul to nipamuno de ni Abel a hanggan to nipamuno de ni Sakarias. Ey ahe i pinamunuan de ni Sakarias éng éwan to sélat no Templo sakay to lamesa a pégatangan. O ngani, parusaan na Diyos a talaga didi tolay a éye nadid, dahil ta éya a kasalanan a ginimet de du purupeta! ");
INSERT INTO dgc_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Kagbi kam a talaga, sikam a maistu ta rilihiyon,” kagi na Jesus, “da niliso moy du tolay i katutuhanan a tungkul ta Diyos. Idel moy dén a ipasakup ta péghari na Diyos, sakay harangan moy be du iba a gustu a pasakup!” ");
INSERT INTO dgc_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Nadid, to kétapos ni Jesus a négtoldu du tolay ta éya, éy hinumektat siya ta éya a lugar. Ey du Pariseyo sakay du maistu ta rilihiyon, éy pépintasan de siya ta mahigpit. Sakay sigi san side a mékipégpasuway diya, da méiyamut side diya. ");
INSERT INTO dgc_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Gustu de a pagkamalién de siya, monda te katuwiran side a mangidimanda diya. ");
INSERT INTO dgc_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Nadid, samantala a mégtoldu pabi ti Jesus, éy dinumulug diya a dinumulug i meaadu a libu a tolay, a hanggan éwan side nagsadét-sadét a tahod. Ey kinagi ni Jesus du alagad na, a “Mangilag kam ta pégpaalsa du Pariseyo, a samakatuwid éy mangilag kam ta pégwari-wari de a banal side a tolay. ");
INSERT INTO dgc_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ey tandaan moy, maski anya i gemtén na tolay nadid ta lihim, éy lumitaw ta esa a panahun. Sakay maski anya i nipamen de nadid, éy mehayag ta esa a panahun. ");
INSERT INTO dgc_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ey maski anya i uhon moya ta lihim nadid, éy mepahayag ta étanan ta esa a panahun. Sakay maski anya i anasatén moy nadid ta lubuk na bile moy, éy te mangidulaw ta éya a kagi ta plasa na banuwan. ");
INSERT INTO dgc_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Tandaan moy ye, a kékadimoy ko,” kagi ni Jesus, “diyan moy antingan du mamuno ta bégi moy, da éwan side makabuno ta kaliduwa moy. ");
INSERT INTO dgc_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Engˈwan, i dapat moy a antingan éy Diyos, da siya i magpakatea ta tolay. Sakay pati éy siya i te kapangyarian a méngibut ta kaliduwa moy ta impiyerno. Kanya siya ngani i dapat a antingan moy a talaga! ");
INSERT INTO dgc_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Mara,” kagi ni Jesus, “makabugtong kam ta lima a dignés ta éduwa san a sentimos. Ey maski mura side, éy éwan kaleksapan na Diyos i maski esa dide. ");
INSERT INTO dgc_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ey bakit méganteng kam a makay kaleksapan kam na Diyos? Mahalaga kam diya kesira ta meadu a dignés. Maski na buk moya, éy nabilang na a étanan!” ");
INSERT INTO dgc_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Tandaan moy,” kagi ni Jesus; “maski ti ésiya i méngipagtapat du tolay, a méniwala siya diyakén, éy ipagtapat ko be siya du anghel na Diyos. Ey sakén i lélake a gébwat ta langet. ");
INSERT INTO dgc_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pero maski ti ésiya i tumanggia diyakén ta harap na tolay, éy itanggi ko be siya du anghel na Diyos. ");
INSERT INTO dgc_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Maski ti ésiya i mangupos diyakén a nagébwat ta langet, éy pagpasensiyaan side na Diyos. Pero tu mangupos ta Banal a Espiritu, éy saya i éwana pagpasensiyaan na Diyos. ");
INSERT INTO dgc_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Nadid,” kagi ni Jesus, “bagay iharap de kam du tagapamahala ta kapilya de, o éng mangidimanda side dikam ta gubernador, éy diyan kam métageg éng anya i katuwiran moya dide. ");
INSERT INTO dgc_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Da tu Banal a Espiritu i magpakagia dikam ta katuwiran moy dide.” ");
INSERT INTO dgc_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nadid, te esa a lélake du tolay sa, a kinagi na ni Jesus, a “Maistu, pégkagian mo teka ko, monda hatianék na to nipamana dikame no ama me.” ");
INSERT INTO dgc_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","“Ey anya,” kagi ni Jesus diya, “pakodyan ko a maghati to nipamana dikam no ama moy? Ewan ko tungkulin a méghati ta luta.” ");
INSERT INTO dgc_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ey nadid, tulos kinagi ni Jesus du tolay sa, a “Mangilag kam, a diyan kam medémot ta sari-sari. Dahilan maski du mayaman a tolay, éy éwan side dagdagen no yaman de tu buhay. ");
INSERT INTO dgc_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Mara,” kagi na, “éy te lélake kan a mayaman, a te luta ta meadu a pahay. ");
INSERT INTO dgc_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ey kinagi na kan, a ‘Magenyaék, da éwanék dén tu pagdétonan ta étanan a pahay ko, da meadu dén. ");
INSERT INTO dgc_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ay,’ kagi na, ‘saye i gemtén kua: hukatén ko du bodega ko a dati, a bilayan ko ta dédekél pa sa a bigu, monda hustu i pagdétonan ko ta pahay ko, sakay ta ari-arian ko.’ ");
INSERT INTO dgc_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nadid, éy kagi kan no lélake, a ‘Ah, masuwerteék, da hustu dén i gastos ko a hanggan ta maski sangan a taon. Melagen i buhay ko nadid,’ kagi na, ‘a i tarabaho ko nadid éy basta méngan, sakay maginom, sakay magsayaék.’” ");
INSERT INTO dgc_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Pero éwan,” kagi ni Jesus; “da kinagi na Diyos diya, a ‘Luku-luku ka tu isip, da nadid dén a kélép éy mate ka dén. Ey nadid,’ kagi na Diyos, ‘koo mo pabi beman i étanan ya a niimbak mo a ari-arian mo?’ ");
INSERT INTO dgc_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Ey nadid,” kagi ni Jesus, “kona sa i manyaria du mégpayaman. Medémot side ta kuhata, pero éwan de isipén i Diyos.” ");
INSERT INTO dgc_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Nadid, kinagi ni Jesus du alagad na, a “Kanya diyan kam métageg ta buhay moy, éng anya i kanén moy éy ta badu moy. ");
INSERT INTO dgc_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Da tandaan moy, éng nilalang kam na Diyos, éy bakit isipén moy a éwan na kam atdinan ta kanén moy éy ta badu moy? ");
INSERT INTO dgc_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Entan moy di manuka; éwan side méghasik; éwan side mégladey; éwan side tu bodega. Pero atdinan side na Diyos ta kanén de! Ey sikam, éwan kam beman higit a mahalaga ta manok? ");
INSERT INTO dgc_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ataay,” kagi ni Jesus, “éng dumemét i oras a ikate mo, éy maari ka beman a magpaatakdug ta buhay mo ta maski esa a oras, éng mabalisa ka? ");
INSERT INTO dgc_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","“Ey nadid, éng éwan moy kaya a paatakdugén tu buhay moy, éy bakit métageg kam pa ta kanén éy ta badu? ");
INSERT INTO dgc_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Isipén moy éng kodya i kébékyaga na bulaklak. Ewan side mégtarabaho, éwan side mégimet ta badu. Pero i mégebadu dia, éy memahal pa to badu no mayaman a hari to araw, a ti Hari Solomon. ");
INSERT INTO dgc_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ey nadid,” kagi ni Jesus, “éng bihisan na Diyos du bulaklak ta kona sa, maski sandali san i buhay de, éy anya, éwan na kam pabaduan? Bakit kétihék pa i péniwala moya diya? ");
INSERT INTO dgc_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kanya sikam, éy diyan kam mégisip a mégisip éng ahe i paketan moya ta kanén moy sakay ta inumén moy; diyan kam mabalisa ta éya. ");
INSERT INTO dgc_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Saya i ugalia du iba a tolay a éwan mékidiyos. Pero Tama moy, éy tukoy na dén i kailangan moya. ");
INSERT INTO dgc_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kanya sikam,” kagi ni Jesus, “éy pilitén moy a maghari i Diyos dikam, sakay gemtén moy san i kaluuben na, éy iatéd na dikam i kailangan moya.” ");
INSERT INTO dgc_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Sikam a alagad ko, éy diyan kam méganteng, maski kétihék kam san a gurupu, da i gustua Nama ko, éy sakupén na kam ta kaharian na. ");
INSERT INTO dgc_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ibugtong moy tu ari-arian moy, sakay iatéd moy du mahirap tu kabugtungan na. Eng kona kam sa, éy ibilang dén a te kayamanan kam dén ta langet. Ey éwan mebut tu kayamanan moy ta langet, da éwan tu mégtako ta éya, sakay éwan be sa tu kutam. ");
INSERT INTO dgc_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Dahilan éng ahe i édsean na kayamanan na tolay, éy siya be san ya i alélahanén na.” ");
INSERT INTO dgc_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Maghanda kam dén,” kagi ni Jesus, “ta koman i péghanda na utusan no mayaman a lélake. Mara du utusan a mahusay, éng maguhay side to amo de, éy maghanda side, sakay taben de be du simbu de. Ey nadid, éng dumemét tu amo de a gébwat ta kasalan, éy handa dén side a magbukas diya, a tanggapén de siya. ");
INSERT INTO dgc_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Masuwerte dén diden ya a utusan, éng demtan side no amo de a nakahanda dén. I gimita no amo de a talaga, éy pégiknudén na du utusan na, a tulos na side a pékanén. ");
INSERT INTO dgc_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","O ngani,” kagi ni Jesus, “masuwerte a talaga diden ya a utusan, éng dumemét dide tu amo de ta hatinggabi, o ta amulaldew, éng demtan na side a nakahanda dén diya. ");
INSERT INTO dgc_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Ey baten moy be i halimbawa a éye,” kagi ni Jesus. “Mara, tu te koo to bile, éng napospusan na maka i kédeméta no nagtako to bile na, éy binantayan na maka, monda éwan maka nakasdép tu nagtako. ");
INSERT INTO dgc_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kanya sikam, éy dapat nakahanda kam a palagi, da éwan moy be tukoy i oras a kédemét ko; sakén a lélake a gébwat ta langet.” ");
INSERT INTO dgc_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Nadid, kinagi ni Pedro, a “Anya, Panginoon, i éya a nihalimbawa mo dikame, éy para dikame san a alagad mo, o pati be du étanan a tolay?” ");
INSERT INTO dgc_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","“I éya a nihalimbawa ko,” kagi ni Jesus, “éy tungkul ta maski ti ésiya a matalinung a utusan a makasunud to amo na ta mahusay. Mara siya tu pinamahalaa no amo na du iba a utusan na, a siya i bahala a manggastos dide. ");
INSERT INTO dgc_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Masuwerte i éya a utusan, éng demtan siya no amo na a mégtarabaho ta kona sa. ");
INSERT INTO dgc_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ey ientarega diya no amo na i étanan a ari-arian na. ");
INSERT INTO dgc_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pero i éya a utusan, éng maisipan na a male pabi bagu magsoli tu amo na, sakay tulos na a lokoén du kaguman na a utusan; sakay éng méngan siya éy ta méglasing, ");
INSERT INTO dgc_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","éy demtan siya no amo na ta oras a éwan na tukoy. Ey parusaan na siya ta mahigpit, sakay iagum na siya ta édsean du tolay a éwan méniwala. ");
INSERT INTO dgc_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Kanya tandaan moy ye,” kagi ni Jesus; “tu utusan a nakatukoy ta kaluuben no amo na, sakay éwan na sugsugén, éy dikél i parusa na a talaga. ");
INSERT INTO dgc_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pero tu utusan a magkamali da éwan na tukoy i kaluuben no amo na, éy kétihék san i parusa na. Kanya,” kagi ni Jesus, “tu péngientaregaan ta meadu, éy siya i pag-asa du tolay. Ey tu péngientaregaan ta meaadu a tahod, éy lalo a dikél i pag-asaa diya du tolay.” ");
INSERT INTO dgc_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Nadid, kinagi man dén ni Jesus du alagad na, a “I kédemét ko ta munduae, éy koman i lélake a umange a magtutod to sikaw na, da maski ahe i demtan na kagi kua, éy te maligalig. Ey sakén, maski sala ko a te maligalig, éy gustu ko a kumalat tu kagi ko ta mundua a koman i apoy! ");
INSERT INTO dgc_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Te dumemét diyakén a paghirap ko. Kanya métagegék a hanggan éwan ya malipas. ");
INSERT INTO dgc_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Bakit, isip moy inumangeék se ta mundua, a magpayapa ta tolay? Ewan! Ewanék se inumange a magpayapa ta tolay, éngˈwan dahil diyakén éy maglaban i tolay ta mundua. ");
INSERT INTO dgc_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Sapul nadid,” kagi ni Jesus, “éng mara, ta esa a bile, éy éwan side isesa tu isip. Mara éng lima side, éy tu étélo éy méniwala diyakén, éy tu éduwa éy éwan. ");
INSERT INTO dgc_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Mara tu patena, éy éwan isesa tu isip de. Sakay tu magmanugeng, éy éwan be isesa tu isip de.” ");
INSERT INTO dgc_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Nadid, kinagi ni Jesus du tolay, a “Napospusan moy i tanda na panahun, da éng meta moy a mediklém ta sahéman, éy kagi moy a maguden. Ey mamaya éy maguden a talaga. ");
INSERT INTO dgc_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Sakay éng meta moy a salatan dén, éy kagi moy a dumemét dén i tékisinag. Ey mamaya éy tékisinag ngani dén. ");
INSERT INTO dgc_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ayhay, sikam a mégwari-wari a éwan kam tu kasalanan! Tukoy moy bale a mébasa i tanda ta langet, pero éwan moy tukoy du tanda a mégpatunay diyakén! ");
INSERT INTO dgc_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Bakit éwan moy maari a mapospusan tu tama a gimet moy? ");
INSERT INTO dgc_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","“Mara,” kagi ni Jesus, “éng te méngiabla diko ta huwes, éy mékipéguhon ka diya éng anya i pagkasunduan moya, bagu na ka iharap to huwes. Dahilan éng dumemét i oras na asuntu moy, éy iatéd na ka ta huwes, a tulos iatéd de ka ta pulis, a tulos mepihesu ka dén. ");
INSERT INTO dgc_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ey nadid, éng kona sa, éy éwan ka makaluwas hanggan éwan mo mabayaden i étanan a kasalanan mo.” ");
INSERT INTO dgc_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Nadid, te tolay a dinumemét ni Jesus, a nibaheta de diya tu ginamet ni Gubernador Pilato, a binuno na kan du sénganya a Judeo a taga Galilea, to pégatang de ta Diyos. ");
INSERT INTO dgc_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ey pékabaheta ni Jesus ta éya, éy kinagi na du tolay sa, a “Anya i isip moya? Akala moy wade a lalo a medukés i kasalanan diden ya a minate kesira du iba a taga Galilea? Akala moy wade a kanya nipabunu side na Diyos éy medukés side? ");
INSERT INTO dgc_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ewan! Da maski sikam, éng éwan kam magsisi, a ibutan moy du gimet moy a medukés, éy kona be sina i manyaria dikam, a pabunu kam be na Diyos! ");
INSERT INTO dgc_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ey anya i isip moya,” kagi na, “du sapulu éy ta walu a tolay a minate ta Siloam? To kétumba no melangkaw a bile dide, siguru i isip moya, éy pinakate side na Diyos da te kasalanan side a mas medukés ta iba a tolay ta Jerusalem? ");
INSERT INTO dgc_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Pero éwan! Da maski sikam, éng éwan kam magsisi, a ibutan moy du gimet moy a medukés, éy kona be sina i manyaria dikam, a pakaten kam na Diyos ta medukés.” Na Diyos Du Tolay a Medukés ");
INSERT INTO dgc_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Nadid, kinagi ni Jesus dide i halimbawa a éye: “Te lélake kan,” kagi na, “a nagmula to kayo a igos to luta na. Ey to esa kan wade a aldew, éy inange na pitasén tu bunga na; éy entan na, éy éwan bale dén tu bunga. ");
INSERT INTO dgc_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ey kinagi na kan to mégbantay to luta na, a ‘Entan mo, étélo dén a taon i kayoae a éwan nagbunga. Pukanén mo dén, monda éwan na abalaén i lutaa.’ ");
INSERT INTO dgc_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ey ‘Diyan mo san,’ kagi kan no mégbantay. ‘Sakén, éy lamonan ko san, sakay détonan ko ta pégpatabe i palebut naa. ");
INSERT INTO dgc_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ey nadid,’ kagi na ‘éng éwan magbunga ta esa a taon, éy papukan mo dén.’” ");
INSERT INTO dgc_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","To esa a aldew a pangilin, éy mégtoldu ti Jesus to kapilya a esa. ");
INSERT INTO dgc_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ey te bébe sa a hinayup, a kébung siya. Sapulu éy ta walu a taon a pinagkébung siya no hayup. Ey éwan siya makaolnat. ");
INSERT INTO dgc_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ey ti Jesus, péketa na diya, éy kinagi na diya, a “Bakés, maibut dén diko tu pile mo!” ");
INSERT INTO dgc_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Tulos nitupu ni Jesus tu kamét na diya, éy nakaolnat dén siya agad, a tulos pinuri na dén i Diyos. ");
INSERT INTO dgc_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pero tu tagapamahala to kapilya, éy naiyamut siya, da pinahusay ni Jesus to pangilin. Kanya kinagi na du tolay sa, a “Te éném kitam a aldew a maari kitam a mégtarabaho. Diden ya a aldew éy maari kam a pagamot. Pero ta pangilin, éy bawal dén ya.” ");
INSERT INTO dgc_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Pero kinagi ni Jesus to tagapamahala, a “Sikam a mégwari-wari a tolay kam na Diyos! Bakit! Eng te baka kam, o kabayo, éwan moy beman ukadén ta pangilin, a iange moy penumén? ");
INSERT INTO dgc_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Pero i bakésae, maski apo siya ni Abraham, a kapareho tam, éy éwanék bale maari nadid a pangilin a magligtas diya to dati a gimet ni Satanas diya! Bakit! Kagbian moy du kabayo moy; pero du kapareho moy a tolay, éy éwan moy kagbian!” ");
INSERT INTO dgc_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Nadid, pégkagi ni Jesus ta éya, éy nasanike dén du kalaban na. Pero du iba a tolay, éy masaya side to meadu a gimet na a memahal. Pagkadua Du Tolay Na Diyos ");
INSERT INTO dgc_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Nadid, kinagi ni Jesus dide, a “Anya wade i kaparehua na kédemét se na Diyos a maghari? ");
INSERT INTO dgc_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","I kaparehua na éya éy tu isesa a bukél na mustasa a nimula no lélake to uma na. Ey tinumubu dén ya a hanggan naging kayo dén, a hanggan makapaglobun du manok ta sanga-sanga na.” ");
INSERT INTO dgc_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Nadid kinagi man dén ni Jesus, a “Pakodyan ko a mangihalimbawa ta péghari na Diyos ta tolay? ");
INSERT INTO dgc_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Mara,” kagi na, “i kaparehua na éya, éy tu pégpaalsa a ihalu no bébe to étélo a takal a arina, éy umalsa tu étanan a linamas.” ");
INSERT INTO dgc_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Nadid to kétamo ni Jesus ta Jerusalem, éy tinumulos pa siya du iba-iba a bariyo, sakay du iba-iba a banuwan, a négtoldu sa siya du tolay. ");
INSERT INTO dgc_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ey kinagi diya no esa a lélake, a “Anya wade, Panginoon, kétihék wade san i meligtas na Diyos a tolay?” Ey kinagi ni Jesus dide, a ");
INSERT INTO dgc_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Tu pintuan a sésdépan ta langet, éy mepiit. Kanya pumilit kam a somdép. Te meadu a talaga a magpuhuba a somdép, éy éwan side maari; ");
INSERT INTO dgc_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","dahilan mara, tu te bile, kédemét na oras, éy seraduan na tu pintuan na. Ey nadid, éng umange kam nadid to pintuan a tumuktuk, éy éwan na kam bukasan. Eng dulawan moy, a ‘Panginoon, bukasan mo kame,’ éy i sengbet na sana dikam, éy ‘Ewan, da éwan ta kam natenggi.’ ");
INSERT INTO dgc_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Nadid,” kagi ni Jesus, “éng kagi moy diya, a ‘Ewan, Panginoon, natenggi mo kame, da négdipon kitam a minéngan; sakay tinolduan mo kame pati ta banuwan me!’ ");
INSERT INTO dgc_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Pero i sengbet na sana dikam, éy ‘Ewan, éwan ta kam natenggi. Umadeyo kam dén, sikam a mégimet ta medukés.’ ");
INSERT INTO dgc_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Nadid,” kagi ni Jesus, “kédemét na éya a oras, éy meta moy sa depu moy a Abraham ta kaharian na Diyos. Sakay meta moy be sa ti Isak, sakay ti Hakob, sakay du purupeta. Pero sikam éy ibut de kam dén. Ey ta péketa moy ta éya, éy mégsésangitén kam a mégéadiyoyén ta hirap moy. ");
INSERT INTO dgc_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Kédemét na éya a oras, éy dumulug sa i meadu a tolay, a gébwat side ta étanan a banubanuwan ta munduae. Pati éwan Judeo a tolay. Ey méngan side ta paanyaya na Diyos ta kaharian na. ");
INSERT INTO dgc_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ey tandaan moy ye,” kagi ni Jesus; “du mababa a tolay nadid, éy side i mataasa ta éya. Sakay du mataas ta éye nadid, éy side di mababaa ta éya.” ");
INSERT INTO dgc_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Nadid, ta éya a panahun, éy te sénganya a Pariseyo a dinumemét ni Jesus, a kinagi de diya, a “Ginanan mo dén i lugar a éye, da ti Mayor a Herod, éy gustu na ka a ipabuno.” ");
INSERT INTO dgc_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ey kinagi ni Jesus dide, a “Ikad moy sa a mégkagi ta éya a mayor a medukés éng anya i gemtén kua. Kagi moy diya a pahusayén ko du méladu, sakay du hinayup a tolay nadid a panahun. Ey ta esa a aldew, éy tapusén ko dén tu gimet ko. ");
INSERT INTO dgc_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ey maglakadék agad ta Jerusalem, da éwan maari a mate tu purupeta ta iba a banuwan, éng éwan ta Jerusalem. ");
INSERT INTO dgc_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Ayhay, sikam a taga Jerusalem. Kagbi kam,” kagi ni Jesus. “Palagi kam a mémuno du purupeta! Palagi moy a batibatikalén du paangen dikam na Diyos! Ayhay, meadu a beses éy gustu ko maka a mégalaga dikam ta kapareho na manok éng léképan na du anak na, pero idel moy! ");
INSERT INTO dgc_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kanya nadid, éy pinabayan ta kam dén. Ey tandaan moy,” kagi na, “éwanék moy dén meta a hanggan éwan dumemét i oras a kagin moy, a ‘Basbasan maka na Diyos tu lélake a pinaange na se.’” Saya tu kinagi ni Jesus tungkul du Judeo ta Jerusalem. ");
INSERT INTO dgc_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Nadid, to pangilin a esa, éy néngan ti Jesus to bile no mataas a Pariseyo. Ey du tolay sa, éy te itan de ti Jesus, éng anya i gemtén na. ");
INSERT INTO dgc_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ey nadid, éy te lélake sa a inumadene ni Jesus, a te beri-beri. ");
INSERT INTO dgc_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ey ti Jesus, éy nipakelagip na du Pariseyo sa éng labag ta batas a magamot ta tolay ta pangilin. ");
INSERT INTO dgc_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pero éwan side sinumengbet ni Jesus. Ey ti Jesus, tulos na pinahusay tu lélake, sakay pinéglakad na siya. ");
INSERT INTO dgc_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ey kinagi ni Jesus du tolay sa, a “Bakit, éwan kam beman mégtarabaho ta pangilin? Anya éng melokbung tu anak mo, o dikaya tu kabayo mo ta ébut--éwan moy beman agawén éng pangilin?” ");
INSERT INTO dgc_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ey to pégkagi ni Jesus ta éya, éy éwan side tu katuwiran diya. ");
INSERT INTO dgc_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Nadid, to pégiknud de a méngan to anyaya no Pariseyo, éy neta ni Jesus du kombidadu a pumilit side a mégiknud du bangko a para koo du mataas. Kanya kinagi na dide ta halimbawa. ");
INSERT INTO dgc_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Mara,” kagi na, “éng akitén de ka ta kasalan, éy diyan ka pumilit a umeknud ta lamesa a para koo du mataas. Makay te mataas diko ta éya. ");
INSERT INTO dgc_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Eng kona sa, tu nagpaanyaya, makay kagi na diko, a ‘Diyan ka sina, da pégiknuden ina na iba a lélake.’ Tulos masanike ka ta dikél, da paeknudén na ka ta lamesa ta sidung san. ");
INSERT INTO dgc_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Engˈwan,” kagi ni Jesus, “i maigi pa a gemtén mo, éy umange ka san dén a umeknud ta bangko ta sidung. Ey nadid, péketa diko no nagpaanyaya, éy kagi na, a ‘Diyan ka sina ta sidung, Kadimoy. Sumangkay ka se a mégiknud ta lamesa du mataas.’ Eng kona sa,” kagi ni Jesus, “éy purién ka du iba a méngan ta éya. ");
INSERT INTO dgc_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Dahilan du pumilit a magmataas, éy pakasaniken side na Diyos. Pero du magpababa, éy pataasén side na Diyos.” ");
INSERT INTO dgc_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Nadid, kinagi ni Jesus to Pariseyo a nagpaanyaya to pinéngan de, a “Bagay magpaanyaya ka, éy diyan mo akitén du kékadimoy mo, sakay du tétotop mo, sakay du mayaman a kabébayan mo, da side éy maari a gumanti diko, a akitén de ka be a méngan ta bile de. Ey séˈ san ya i gantimpala mua. ");
INSERT INTO dgc_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Engˈwan, i maigia éy akitén mo san du mahirap a tolay, sakay du pile, sakay du lumpu, sakay du buhék. ");
INSERT INTO dgc_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Eng kona sa i gimet mo,” kagi ni Jesus, “éy i gantimpala mua éy gébwat ta Diyos, da kinagbian mo dén du éwan maari a gumanti diko. Kédemét na oras a pabuhayén na Diyos du tolay, éy saya i oras a gantian na ka.” Na Diyos Ta Anyaya Na ");
INSERT INTO dgc_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nadid, pékabati no esa sa a lélake to kinagi ni Jesus, éy kinagi na, a “Masuwerte ngani dén du méngan ta paanyaya na Diyos ta kaharian na!” ");
INSERT INTO dgc_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ey kinagi ni Jesus diya, a “Mara te lélake kan a naghanda ta dikél a anyaya, a kinombida na du meaadu a tolay. ");
INSERT INTO dgc_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ey kédemét na aldew na anyaya, éy inutusan na tu utusan na, a kagi na kan diya, a ‘Angen mo uwitén du kinombida ko, da nahanda dén tu anyaya ko dide.’ ");
INSERT INTO dgc_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pero to pénguwet no utusan du kinombida no amo na, éy nagparaan side a étanan. I katuwiran kan no esa, éy ‘Magpasensiya ka, da te angayanék, a bisitaén ko tu binugtong ko a luta ko.’ ");
INSERT INTO dgc_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","I katuwiran no esa man, éy ‘Magpasensiya ka pa diyakén, da angen ko pa bisitaén du sapulu a baka a binugtong ko.’ ");
INSERT INTO dgc_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Sakay i katuwiran kan no esa, éy ‘Ewanék maari, da biguék pabi a kinasal.’ ");
INSERT INTO dgc_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Nadid, sinumoli kan dén tu utusan, a kinagi na to amo na i nanyaria. Ey tu amo na, pékabaheta na ta éya, éy mégingél. Ey kinagi na to utusan na, a ‘Nay, soli ka dén agad a maglebut ka ta banuwanae. Bawat meta mo a pobre a tolay,’ kagi na, ‘éy akitén mo. Sakay akitén mo be du pile, sakay du buhék, sakay du lumpu.’ ");
INSERT INTO dgc_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Mamaya-maya, soli man dén tu utusan, a kinagi na to amo na, a ‘Nasunud ko dén tu utus mo, pero kulang pabi i tolay ta paanyaya mo.’ ");
INSERT INTO dgc_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Kanya tu mégpaanyaya, éy kinagi na diya, a ‘Nay, soli ka man dén nadid a humanggan ka ta pégiyanan du pobre a tolay, sakay du tolay ta adeyo, a hanggan ta buked. Ey pilitén mo a akitén i maski ti ésiya a meta mo ta éya. Gustu ko a maputat i bile kuae,’ kagi na. ");
INSERT INTO dgc_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","‘Pero du kinombida ko dén a dati,’ kagi na kan, ‘éy éwan de dén makenaman tu nihanda ko ta éye.’” ");
INSERT INTO dgc_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nadid, to pégdema ni Jesus, éy meaadu a tahod a tolay i kinumuyuga diya. Ey kinagi na dide, a ");
INSERT INTO dgc_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Eng ti ésiya i te gustu a ipasakup diyakén a maging alagad ko, éy éwan siya maari éng éwanék na mahalén ta higit pa ta pégmahal na dena na éy tama na éy ta asawa na, éy ta anak na, éy ta top na. Sakay éng mahalén na pati i sarili na ta higit pa diyakén, éy éwan be siya maari a maging alagad ko. ");
INSERT INTO dgc_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Sakay éwan be maari a maging alagad ko i tolay éng éwan siya kumuyoyog diyakén, a pabayan na i buhay na, maski bunon siya. ");
INSERT INTO dgc_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Mara,” kagi na, “éng te esa dikam a maghanda a magimet ta melangkaw a bile, éy éwan na pa beman isipén i halaga no bile, éng hustu dén tu kuhata na a mangtapos to bile? ");
INSERT INTO dgc_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Dahilan, mara, éng éwan na pa isipén tu halaga no bile, éy makay maubus tu kuhata na bagu matapos. Eng kona sa, éy pintasan siya du kabébayan na, ");
INSERT INTO dgc_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","a kagi de, mara, a ‘Entan mo, mégpabile siya, pero éwan na kaya a tapusén.’” ");
INSERT INTO dgc_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Halimbawa man dén,” kagi ni Jesus, “éng mara, te hari a te sapulu a libu a sundalu, éng magayak siya a lumaban ta hari a esa a te duwapulu a libu a sundalu, éy éwan na beman isipén pa éng kodya i panalu naa ta hari a esa? ");
INSERT INTO dgc_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ey nadid, éng éwan na meta i panalu naa, éy utusan na agad tu katulung na a ange sambatén tu hari a esa, a monda mékikasundu siya diya, monda éwan side maglaban. ");
INSERT INTO dgc_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ey kona be sa maka dikam,” kagi ni Jesus, “a isipén moy pa. Da maski ti ésiya dikam, éng éwan moy pa pabayan i étanan a mahalén moy, éy éwan kam maari a maging alagad ko. ");
INSERT INTO dgc_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Mara i asen,” kagi ni Jesus, “éy mahusay ya. Pero éng maibut tu asen, a tumablal dén tu sida, éy pakodyan moy a mamasoli to asen na? ");
INSERT INTO dgc_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ewan dén nadid tu pasa i éya a asen. Basta ibut dén na tolay. Eng makabati kam, éy baten moy ya!” Na Diyos I Tolay a Minebut ");
INSERT INTO dgc_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nadid, du makasalan a tolay, sakay du mégpabuwes, éy dumédulug side ni Jesus, da gustu de a mébati i kagi naa. ");
INSERT INTO dgc_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ey du te tungkulin a Judeo, péketa de ta éya, éy éupusén de ti Jesus. “Bakit tanggapén na du makasalanan a tolay, a mékidipon siya dide,” kagi de. ");
INSERT INTO dgc_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","“Ey ti Jesus, pékatukoy na to péngupos de diya, éy kinagi na dide i halimbawa a éye: ");
INSERT INTO dgc_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Eng mara,” kagi na, “te esa dikam a te sandaan a tupa, éng mebut tu esa dide, éy anya wade i gemtén na? Siguradu éy pabayan na du siyam a pulu éy ta siyam a tupa na to pégpastoran de, a monda ahayukén na tu nebut, a hanggan éwan na meta. ");
INSERT INTO dgc_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ey nadid pag mineta na ya, éy masaya dén tu lélake, ");
INSERT INTO dgc_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","a kébil na dén tu tupa to bile. Ey kédemét na to bile, éy akitén na du karatig na, a kagi na dide, a ‘Mékipagsaya kam diyakén, da mineta ko dén tu tupa ko a minebut!’ ");
INSERT INTO dgc_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","“Ey nadid,” kagi ni Jesus, “i kahulugina na éya a halimbawa, éy mésahat a tahod du édse ta langet, bagay meta de i maski isesa a tolay a mégsisi a mangibut to kasalanan na. Mésahat side a talaga ta éya a isesa a tolay kesira du meadu a tolay a éwan tu kasalanan. ");
INSERT INTO dgc_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Sakay baten moy i halimbawa a éye,” kagi ni Jesus. “Eng mara, te bébe a te sapulu a plata a kuhata. Eng mebut tu esa, éy anya i gemtén na? Taben na agad tu simbu na a tulos na walisan tu bile na, a éahayukén na a hanggan éwan na meta. ");
INSERT INTO dgc_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ey nadid, ta péketa na, éy akitén na du karatig na, a kinagi na dide, a ‘Mékipagsaya kam diyakén, da mineta ko dén tu plata ko a esa a minebut!’ ");
INSERT INTO dgc_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","“Ey nadid,” kagi ni Jesus, “éy kona be sa i gimita du anghel ta langet, a mésahat be side bagay meta de i maski isesa a makasalanan a tolay a mégsisi, a mangibut to kasalanan na.” ");
INSERT INTO dgc_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Nadid, kinagi ni Jesus du tolay, a “Te lakay kan a te éduwa a anak a lélake. ");
INSERT INTO dgc_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Tu dipos, éy kinagi na kan nama na, a ‘Améng, atdinanék mo nadid ta mana ko a kabahagi ko.’ Ey inoan siya no ama na, a hinati na tu ari-arian na du éduwa a anak na. ");
INSERT INTO dgc_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Nadid, kélipas na sénganya a aldew, éy nibugtong kan no dipos tu mana na, sakay hinumektat dén a inumange ta adeyo a banuwan. Ey kédemét na ta éya, éy basta inubus na kan a inubus tu kuhata na ta nipagsunud na ta kalayaan na. ");
INSERT INTO dgc_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nadid, kéubus kan wade no kuhata na, éy dinumemét kan sa i dikél a alép, a hanggan da naghirap dén tu dipos. ");
INSERT INTO dgc_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Kanya nagpaupa kan siya to esa a lélake ta éya. Ey tu lélake, éy pinaange na kan siya to uma na, a monda bantayan na sa du babuy na. ");
INSERT INTO dgc_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ey to pégbantay kan no dipos du babuy, éy gustu na maka a méngan ta kanén du babuy, da éwan tu mémakan diya. ");
INSERT INTO dgc_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Nadid, éy kinaisipan na kan wade, a kinagi na, a ‘Bakit wade mégéeknudénék san se a hanggan mateék ta alép, éy du tarabahador nama ko, éy meadu i kanén dia! ");
INSERT INTO dgc_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ikad ko dén,’ kagi na kan, ‘ta bile nama ko, a kagin ko diya, a “Améng, te kasalananék diko, sakay ta Diyos.” ");
INSERT INTO dgc_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Sakay kagin ko be nama ko, a “Ewanék mo maari, Améng, a ibilang a anak mo. Ibilangék mo san dén a magpaupa diko.”’ ");
INSERT INTO dgc_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Nadid, pékaisip kan no dipos ta kagi na nama na, éy nagsoli dén. Ey to kéadene na kan pabi to bile nama na, éy tinan-aw siya nama na. Ey pékatan-aw na kan diya, éy kinagbian na, a basta naginan dén a sinumambat diya. Ey to péngsambat na wade diya, éy tulos na kan kinébkében, a inahob-ahoben. ");
INSERT INTO dgc_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ey tu anak na, éy kinagi na kan diya, a ‘Améng, te kasalananék diko sakay ta Diyos. Ewanék maari a ibilang mo a anak mo.’ ");
INSERT INTO dgc_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pero tu ama na, basta pinabayan na kan san tu kinagi na, a dinulawan na agad du utusan na, a kinagi na kan dide, a ‘Nay, baduan moy siya ta memahal a badu, sakay sapatusan moy siya, sakay atdinan moy ta sangkalan na.’ ");
INSERT INTO dgc_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Sakay inutusan na be side, a ‘Nay, ange moy bunuén tu pinatabi ko a baka, sakay lutuén moy. Maghanda kitam ta kasayaan tam a anyaya. ");
INSERT INTO dgc_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Entan moy,’ kagi na kan, ‘i anak kuae; akala tam éy pate dén, éy entan moy, buhay bale san. Akala tam,’ kagi na kan, ‘éy nebut dén, pero entan moy, nagsoli dén.’ Nadid, to pégkagi no ama na ta éya, éy tulos dén side a nagkasayaan. ");
INSERT INTO dgc_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Nadid, tu anak na a esa a panganay, éy éwan na kan tukoy i nanyari a éya, da édsa kan siya to uma na. Mamaya-maya, késoli na kan wade, éy nabati na i togtog na kasayaan to lubuk no bile de. ");
INSERT INTO dgc_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nadid, to pékabati na kan ta éya, éy pinakelagipan na tu utusan sa a esa éng anya i kasayaan dia. ");
INSERT INTO dgc_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ey kinagi kan no utusan, a ‘Dinumemét dén tu wadi mo. Ey binunu dén nama mo tu pinatabi na a baka. Naganyaya dén siya,’ kagi na kan, ‘da nagsoli dén tu wadi mo a mahusay san.’ ");
INSERT INTO dgc_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Nadid, pékabaheta no panganay ta éya, éy sinompél kan wade i isip naa, a nagingél dén siya. Ey mégidel siya a somdép. Ey nadid, linumuwas kan tama na a pasdépén na siya. ");
INSERT INTO dgc_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ey kinagi kan no panganay diya, a ‘Méghinanakiték diko, Améng. Bakit, sapul to kéanak ko, éy mégtétarabahoénék san diko, a sésundin ko a palagi i utus mo. Pero hanggan nadid éy éwanék mo pabi inatdinan ta maski kambing, a monda maganyayaék be du kakadimoy ko. ");
INSERT INTO dgc_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pero ti wadi ko, éy inobus na dén tu kuhata mo dahilan du pampam. Ey nadid, késoli na diko, éy tu pinatabi mo a baka éy binunu mo a para diya.’ ");
INSERT INTO dgc_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“‘Pero éwan,’ kagi kan no ama na, ‘diyan ka méghinanakit, Anéng, diyakén; da palagi ka a kaguman ko, sakay pati éy siko i te kooa ta étanan a ari-arian ko. ");
INSERT INTO dgc_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Bakit,’ kagi na kan, ‘éwan maari a magkasayaan kitam, da nagsoli dén ti wadi mo a minebut? Akala tam éy pate dén, éy nadid éy buhay bale san.’ Ewan dén,” kagi ni Jesus; “saya i katapusana na lagip.” ");
INSERT INTO dgc_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Nadid, kinagi man dén ni Jesus du alagad na i halimbawa. “Te esa kan wade a lélake a mayaman,” kagi na. “I éya a mayaman, éy te esa siya a akontan a nagentaregaan na ta ari-arian na. Pero nadid kan wade, éy nabaheta no mayaman a nékialaman no akontan tu kayamanan na. ");
INSERT INTO dgc_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Kanya nipauwet na kan siya, a kinagi na diya, a ‘Bakit pinékialaman mo kan tu nientarega ko diko! Nay, sulitan mo dén tu nientarega ko diko, a paibutén ta ka a talaga.’ ");
INSERT INTO dgc_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Nadid, inisip kan no akontan, a ‘Magenyaék, da paibuténék wade no amo ko a talaga? Ahe wade i pangalapan ko ta kabuhayan ko, da éwanék makatarabaho ta medége, sakay mésanikeék be a mékilimos. ");
INSERT INTO dgc_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ah, tukoy ko,’ kagi na kan, ‘i gimet ko, a monda tanggapénék du tolay ta bile de éng éwanék tu tarabaho.’ ");
INSERT INTO dgc_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Nadid, saye tu gimet kan wade no akontan: nipauwet na kan du te utang to amo na, a monda bawasan na tu utang de. Saya i pénuyu naa dide. Mara i kinagi na kan to esa, éy ‘Sénganya i utang mo to amo ko?’ ");
INSERT INTO dgc_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‘Ey sandaan a tapayan a langis.’ Ey ‘Nay,’ kagi na kan, ‘saye tu lista na utang mua; palitan mo a monda limapulu san dén.’ ");
INSERT INTO dgc_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Sakay i kinagi na kana to esa, éy ‘Sénganya i utang mua?’ ‘Ey sandaan a kaban a pahay.’ Ey ‘Nay,’ kagi na kan, ‘saye tu lista no utang mo. Bawasan mo, monda walu a pulu san dén tu utang mo.’ ");
INSERT INTO dgc_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Ey nadid,” kagi ni Jesus, “anya kan wade i gemtén no mayaman, éng meta na tu paraan no méngléloko a akontan na? Ey purién na siya, a ‘Memahal,’ kagi na kan, ‘i paraan no akontan ko, da naghanda siya a para ta esa a panahun.’ Entan moy,” kagi ni Jesus, “du tolay ta mundua a éwan mékidiyos, éy lalo side a matalinung a magparaan kesira du tolay a sakup na Diyos. ");
INSERT INTO dgc_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Kanya,” kagi ni Jesus, “i hatul kua dikam, éy gamitén moy tu kuhata moy a tumulung du mahirap a tolay, monda éng mate kam, éy tanggapén kam na Diyos ta langet. ");
INSERT INTO dgc_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Tandaan moy ye,” kagi ni Jesus, “tu matapat ta kétihék a tarabaho na, éy matapat be siya éng te mangatéd diya ta dikél a tarabaho na. Pero tu éwan matapat ta kétihék a tarabaho na, éy éwan matapat éng te mangatéd diya ta dikél a tarabaho na. ");
INSERT INTO dgc_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nadid, éng mara,” kagi ni Jesus, “éwan kam matapat ta kuhata na munduae, éy anya, isip moy beman ientarega dikam na Diyos tu kayamanan na ta langet? Ewan! ");
INSERT INTO dgc_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Sakay éng mara, éwan kam matapat ta koo na iba, éy éwan be dén diko tu magkatiwala a mangatéd diko ta koo mo a sarili. ");
INSERT INTO dgc_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Ewan maari,” kagi ni Jesus, “tu isesa a utusan a makasunud ta éduwa a amo na. Dahilan, éng éduwa i amo naa, éy mahal na san tu esa, sakay kaiyamutan na tu esa. Maniwala siya to amo na a esa, sakay lukoén na tu esa. Ey nadid, kona sa dikam--éwan kam maari a méniwala ta Diyos, éng kuhata san i gustu moya.” ");
INSERT INTO dgc_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Nadid, du Pariseyo a édsa sa a nakabati ta éya, éy inahew de ti Jesus, da side i te gustua ta kuhata. ");
INSERT INTO dgc_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ey kinagi ni Jesus dide, a “Sikam ngani du mégpalalo ta tolay a banal kam! Pero tukoy na Diyos i isip moya, a medukés! Ey tandaan moy, i mahalagaa ta tolay, éy saya i kéiyamutan na Diyos.” Saya tu kinagi ni Jesus tungkul du medémot ta kuhata. ");
INSERT INTO dgc_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Tandaan moy,” kagi ni Jesus, “tu utus ni Moises, sakay du sulat du purupeta na Diyos, éy saya i nagtoldua dikam a hanggan éwan dinumemét tu panahun ni Juan a Mégbinyag. Pero nadid, sapul diya, i mahalagaa, éy tu Mahusay a Baheta a tungkul ta kédemét na Diyos a maghari. Saya i importante a pahayag dikam nadid. Ey meadu a tahod i pumilit a ipasakup ta kaharian na. ");
INSERT INTO dgc_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Pero diyan moy isipén a éwan dén tu pasa nadid tu utus na Diyos a nisulat ni Moises. Engˈwan, melagin pa i langet éy ta luta a mebut, kesira ta isesa a utus ta libru na Diyos. ");
INSERT INTO dgc_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“I maski ti ésiya a lélake,” kagi ni Jesus, “éng humiwalay ta asawa na, sakay mangasawa siya ta iba, éy méngibébi dén siya a talaga ta mata na Diyos. Sakay tu lélake a mangasawa ta bébe a hinumiwalay dén to asawa na a lélake, éy ibilang ya na Diyos a méngagew.” ");
INSERT INTO dgc_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Nadid, kinagi ni Jesus, éy “Te esa kan wade a lélake a mayaman. Basta i ugali na, éy mégbébihisén kan ta memémahal a badu, sakay pati i kanén naa, éy memahal a kalase. ");
INSERT INTO dgc_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Nadid, te esa kan wade be a lélake a mahirap, a ti Lasaro kan i ngahen na. Ey te ladu siya, a nagtalitalingo i bégi naa. Ey aldew-aldew, éy mégkatidug kan san to harap no bile no mayaman. ");
INSERT INTO dgc_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","I gustu na kan sana, éy méngan siya ta mumo a gébwat to lamesa no mayaman. At sakay pati, du aso ta éya, éy dédildilan de tu néna to talitalingo na. ");
INSERT INTO dgc_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Nadid kan wade éy minate ti Lasaro a mahirap. Ey kembil siya du anghel ta édsean napo na a Abraham ta langet. Ey kétapos na éya, éy minate kan be tu mayaman, a nielbéng de. ");
INSERT INTO dgc_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ey édsa dén siya nadid ta impiyerno, a mégtiis dén siya ta mahigpit. “Nadid, to kétangad na kan wade, éy natanaw na ta adeyo ti Abraham, a kaguman na ti Lasaro. ");
INSERT INTO dgc_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ey pékatan-aw na kan dide, éy kinagi na kan ta medegsén, a ‘Boboy, Abraham, kagbianék pad. Péngiangen pad se ti Lasaro ta dinom a maski ilébléb na san i toldu naa a ipatuhog na ta labi kua. Entan mo,’ kagi na kan, ‘Boboy, mégtiisék ta mahigpit ta apoyae.’ ");
INSERT INTO dgc_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“‘Ey éwan maari, Anéng,’ kagi kan ni Abraham. ‘Tandaan mo, to buhay ka pabi, éy melagin i buhay mua, éy ti Lasaro éy mehirap i buhay na to araw. Pero nadid,’ kagi na kan, ‘masaya dén siya ta éye, éy siko, mégtiis ka dén ta ina. ");
INSERT INTO dgc_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ey entan mo,’ kagi kan ni Abraham, ‘maski gustu di tolayae a umahabes dikam, éy éwan maari, da melawa i béngawa ta pag-itan tamae. Pati di tolaya ina, éy éwan side makaahabes dikame.’ ");
INSERT INTO dgc_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“‘Nadid,’ kagi kan no mayaman, ‘paangen pad, Boboy, ti Lasaro du tétotop ko a buhay pabi ta mundua, ");
INSERT INTO dgc_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","monda papangilagén na side. Entan mo, Boboy, éném kame a pépétwadi; éng éwan na side papangilagén, éy makay tumagubet be side diyakén ta éye a pégparusaan a lugar.’ ");
INSERT INTO dgc_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“‘Ey éwan,’ kagi kan ni Abraham. ‘I pangilagen de san déna sa, éy tu nipesulat na Diyos ni Moises, sakay tu nipesulat na du purupeta. Eng mabati de i éya, éy mangilag side a talaga.’ ");
INSERT INTO dgc_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“‘Ey éwan wade maari, Boboy,’ kagi kan no mayaman, ‘da éwan de ya baten. Pero éng te dumemét dide a gébwat ta pate,’ kagi na kan, ‘éy magsisi side a talaga a baguén de tu ugali de.’ ");
INSERT INTO dgc_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“‘Ey éwan,’ kagi kan ni Abraham. ‘Eng éwan de baten tu utus ni Moises sakay du purupeta, éy éwan de be baten maski te magpailag dide a gébwat ta pate.’” ");
INSERT INTO dgc_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Nadid, kinagi ni Jesus du alagad na, a “Ewan maiwasan na tolay i méngatéd ta pagkasala de. Pero makaanteng i kesapitan na tolay a méngatéd ta ipagkasala! ");
INSERT INTO dgc_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Maigi pa ta kona sa a tolay, éy kalukalan ta bito i leg na, sakay ietbung ta diget, kesira ta makapangatéd siya ta ipagkasala na mababa a tolay. ");
INSERT INTO dgc_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Tandaan moy ya,” kagi ni Jesus, “a mangilag kam dén!” “Eng magkasala tu kaguman mo, éy pégkagian mo. Ey éng magsisi siya, éy pagpasensiyaan mo. ");
INSERT INTO dgc_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Eng mara, maski pitu a beses a magkasala diko tu kaguman mo ta esa a aldew, éng makapitu be siya a beses a kékagin na diko a mégsisi dén siya, éy pagpasensiyaan mo dén siya.” ");
INSERT INTO dgc_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Nadid du apostol, éy kinagi de ni Jesus, a “Panginoon, dagdagen mo pad i péniwala mia diko.” ");
INSERT INTO dgc_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ey kinagi ni Jesus dide, a “Mara tu péniwala moy diyakén, éng koman san i kadikél na bukél na mustasa, éy maski utusan moy i kayoae a mabuwal, a tulos mebut ta diget, éy maniwala diko tu kayo.” ");
INSERT INTO dgc_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Eng mara,” kagi ni Jesus, “te utusan a gébwat ta pégaraduan na, éy anya i kagin no amo na diya? Paeknudén na siya beman a maguhay ta kanén? ");
INSERT INTO dgc_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ewan! Engˈwan, i kailangana no utusan, éy paglutu na pa tu amo na ta kanén na, sakay ipaghayin na siya. Ey kétapos na éya, éy maari dén tu utusan a méngan. ");
INSERT INTO dgc_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ey anya,” kagi ni Jesus, “tu amo na, purién na siya beman to ginimet na? Ewan, da ugali san ya na utusan. ");
INSERT INTO dgc_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ey kona be sa dikam. Eng tapusén moy tu tarabaho moy ta Diyos, éy dapat kagi moy, a ‘Mababa kitam san a utusan, a i ginimet tam, éy kailangan tam san.’” ");
INSERT INTO dgc_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Nadid, to kéange de Jesus ta Jerusalem, éy dinumaman side ta pag-itan na Samaria éy ta Galilea. ");
INSERT INTO dgc_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ey to késdép ni Jesus to bariyo a esa, éy kasambat na i sapulu a lélake a te saket a ketong. Te taknég side ta adi-adeyo ni Jesus, ");
INSERT INTO dgc_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","sakay kinagi de diya ta medegsén, a “Jesus, Panginoon, kagbian mo kame.” ");
INSERT INTO dgc_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ey ti Jesus, péketa na dide, éy kinagi na dide, a “Umange kam pumeta du padi, a mahusay kam dén.” Ey nadid, to péglakad du sapulu, éy bigla a mahusay dén side. ");
INSERT INTO dgc_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ey tu esa dide, péketa na a mahusay dén, éy soli dén siya ni Jesus, a mégpuri dén siya ta Diyos ta medegsén. ");
INSERT INTO dgc_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ey dinumapa siya to harap ni Jesus, a nagpasalamat siya diya. Ey taga Samaria i éya a lélake. Ewan siya Judeo. ");
INSERT INTO dgc_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ey kinagi ni Jesus, a “Akala ko éy sapulu i naghusaya. Bakit isesa san i sinumolia ta éye a nagpasalamat? ");
INSERT INTO dgc_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ewan bale tu iba a magsoli ta éye a magpasalamat ta Diyos, éngˈwan basta i dayuan a éye a éwan Judeo!” ");
INSERT INTO dgc_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Nadid, to pégkagi dén ni Jesus ta éya, éy kinagi na to taga Samaria, a “Nay, umégkat ka dén, Kadimoy, a ikad mo dén. Tu nagpahusay diko, éy tu péniwala mo diyakén.” ");
INSERT INTO dgc_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Nadid, du Pariseyo éy nipakelagip de ni Jesus éng nikésiya i kédemét na panahun na Diyos a maghari ta mundua. Ey saye tu sengbet ni Jesus dide: “Ewan tu tanda a meta moy ta kédemét na éya,” kagi na. ");
INSERT INTO dgc_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","“Ewan be tu magbaheta ta éya a aldew, a ‘Dinumemét dén siya ta éye,’ o ‘Edsa dén ta éya;’ da i édseana na kaharian na Diyos, éy ta isip na tolay.” ");
INSERT INTO dgc_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Nadid, kinagi ni Jesus du alagad na, a “Te dumemét a panahun a gustu moy maka a dumeméték, pero éwan moy meta i demét ko. ");
INSERT INTO dgc_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Te tolay a mégkagi dikam a talaga, a ‘Edsa dén ta éya a banuwan tu tiniyak na Diyos a tagapagligtas,’ sakay te mégkagi dikam, a ‘Kéye dén se siya.’ Pero diyan kam méniwala dide. ");
INSERT INTO dgc_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Dahilan,” kagi ni Jesus, “i demét ko a se éy koman i kilat a bigla a mademlagen i kabuuana na langet. Sakén i lélake a gébwat ta langet. ");
INSERT INTO dgc_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero baguék se sumoli ta kona sa, éy kailangan éy dumemét pa diyakén i mahigpit a hirap ko, a idelanék du tolay ta éye nadid. ");
INSERT INTO dgc_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“I kédemét ko éy kapareho na kédemét no bihéng to panahun ni Noe. ");
INSERT INTO dgc_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Du tolay to éya a panahun éy basta méngan side sakay méginom side, sakay mégasawa side, hanggan to oras a késakay de Noe to barko. Sakay dinumemét tu bihéng, éy nalimés du tolay a étanan. Kona be sa i manyaria ta kédemét ko. ");
INSERT INTO dgc_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","I kédemét ko,” kagi ni Jesus, “éy kapareho be no nanyari ta Sodom to panahun ni Lot. Du tolay ta éya, éy basta méngan side, sakay méginom side, sakay nagbugtong side, sakay naghalaman side, sakay mégbile side; pero éwan de maisipan i Diyos. ");
INSERT INTO dgc_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ey anya i nanyaria dide to aldew a niginan ni Lot ta Sodom, éy pinaudinan side na Diyos ta apoy sakay asupre, a hanggan da minapuksa side a étanan! ");
INSERT INTO dgc_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ey nadid, éy kona be sa i manyaria ta kédemét ko, sakén a gébwat ta langet. ");
INSERT INTO dgc_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Kédemét na éya a oras,” kagi ni Jesus, “du édse ta luwas no bile de, éy diyan dén side somdép a mangalap ta kasangkapan de a edse to bile. Sakay du édse ta uma, éy diyan be side sumésoli ta bile de. ");
INSERT INTO dgc_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Natandaan moy tu asawa ni Lot, a naanya siya to talaga na a isoli to bile de. ");
INSERT INTO dgc_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Dahilan tu pumilit a meligtas tu buhay na, éy mebut a talaga. Pero tu mégpabaya ta buhay na, éy siya i mabuhaya. ");
INSERT INTO dgc_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ta éya a kélép,” kagi ni Jesus, “éng mara te éduwa a lélake a matidug ta esa a kama, éy maalap tu esa, éy tu esa éy mawahak. ");
INSERT INTO dgc_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Te éduwa a bébe a mégkaguman side a mégiling, éy maalap tu esa, éy tu esa éy mawahak. ");
INSERT INTO dgc_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Te éduwa a lélake ta uma, éy maalap tu esa, éy tu esa éy mawahak.” ");
INSERT INTO dgc_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Nadid, pékabati du alagad ta éya, éy kinagi de, a “Ta ahe manyari i éya, Panginoon?” Ey kinagi ni Jesus, a “Eng ahe i édseana du bangkay, éy édsa be sa a matipun du wakwak.” ");
INSERT INTO dgc_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Nadid, kinagi ni Jesus du alagad na i lagip a te halimbawa, monda palagi side a manalangin, monda éwan side mégsawa a manalangin. ");
INSERT INTO dgc_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","I kinagi naa, éy “Te huwes kan wade to banuwan, a éwan matapat. Ewan siya méniwala ta Diyos, sakay éwan be siya tu kagbi ta kapareho na a tolay. ");
INSERT INTO dgc_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nadid, te pobre kan wade a bébe a bilo ta éya a banuwan, a medalas a umadene to huwes a dumaying. I kinagi na kan diya, éy ‘Isuhogék mo to kalbug ko.’ ");
INSERT INTO dgc_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Nale a panahun a éwan pinansing no huwes tu bilo. Pero kédemét na oras, éy kinagi na kan to isip na, a ‘Maski éwanék méniwala ta Diyos, maski éwanék tu kagbi ta kapareho ko, ");
INSERT INTO dgc_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","éy isuhog ko i éya a bilo, monda éwanék na abalaén a aldew-aldew.’ ");
INSERT INTO dgc_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","“Nadid,” kagi ni Jesus, “tandaan moy tu naisipan no medukés a huwes. Maski éwan siya tu kagbi, éy inaguman na tu bilo, da medalas siya a mégkagi diya. ");
INSERT INTO dgc_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ey nadid i Diyos,” kagi ni Jesus, “éwan na beman aguman agad du tolay na éng medalas side a dumaying diya? ");
INSERT INTO dgc_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","O, aguman na side agad! Kanya diyan kam mégsawa a manalangin diya. Pero ta kédemét ko se a huway, éy bihira wade i demtan ko a méniwala diyakén.” Mégidel Siya Du Mégwari-wari a Mékidiyos ");
INSERT INTO dgc_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Nadid, kinagi ni Jesus ta halimbawa du sénganya sa a tolay a akala de éy banal side. Kanya ahewén de du iba a tolay. ");
INSERT INTO dgc_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Te éduwa kan wade a lélake,” kagi ni Jesus, “a sinumangkay to Templo a manalangin. Tu esa éy Pariseyo, sakay tu esa, éy mégpabuwes. ");
INSERT INTO dgc_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Nadid, tinumaknég tu Pariseyo, a nanalangin ta kona se: ‘Mégpasalamaték diko, Panginoon,’ kagi na, ‘da éwanék tu kasalanan a kona du iba a tolay. Ewanék mégdaya; éwanék méngibébi; éwanék tu mégimet a mali. Salamat, da éwanék medukés a kona ta éya a lélake a mégpabuwes. ");
INSERT INTO dgc_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Makaduwaék a beses a mégkulasiyon ta esa a simba. Sakay inatdinan ta ka ta ikasapulu a bahagi na étanan a kabuhayan ko.’ ");
INSERT INTO dgc_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Nadid,” kagi ni Jesus, “anya i nipanalangin no lélake a mégpabuwes? Basta te taknég san siya to iskina no Templo a mésanike dén. Te dugsék san siya a mégsisi, a kinagi na, a ‘Anin, Panginoon, kagbianék mo, a te kasalananék.’ ");
INSERT INTO dgc_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Entan moy,” kagi ni Jesus, “tu mégpabuwes, éy siya i pinagpasensiyaana na Diyos to késoli na to bile na. Pero tu lélake a esa, éy éwan! Dahilan du pumilit a magmataas, éy pakasaniken side na Diyos. Pero du magpababa, éy pataasén side na Diyos.” ");
INSERT INTO dgc_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","To esa man dén a aldew, éy niange du tolay du anak de a mabulol ni Jesus, monda itupu na i kamét na dide a ipanalangin na side. Ey du alagad, péketa de dide, éy pinégkagian de side. ");
INSERT INTO dgc_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pero ti Jesus, éy dinulaw na du anak, sakay kinagi na du alagad, a “Pabayan moy di anaka a umadene diyakén. Diyan moy side sésawayén. Dahilan éy méghari i Diyos ta kona sina. ");
INSERT INTO dgc_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Tandaan moy,” kagi na, “éng éwan kam umasa ta Diyos a kapareho na kéasa na anak to ina na, éy éwan kam makasdép ta kaharian na.” ");
INSERT INTO dgc_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Nadid, i esa a te tungkulin a Judeo, éy kinagi na ni Jesus, a “Maistu a mahusay, kagin pad éng anya wade i gemtén kua a monda makaalapék ta buhay a éwan tu katapusan.” ");
INSERT INTO dgc_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","“Bakit dédulawénék mo a mahusayék?” kagi ni Jesus. “Ewan tu mahusay éng éwan Diyos. ");
INSERT INTO dgc_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Tukoy mo dén i kautusan na Diyos: Diyan ka méngibébi, diyan ka mamuno, diyan ka mégtako, diyan ka mégbuli-buli; sakay igalang mo tama mo éy ta ina mo.” ");
INSERT INTO dgc_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","“Maistu,” kagi no lélake, “sinunud ko dén ina side a étanan sapul to kéanak ko.” ");
INSERT INTO dgc_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ey ti Jesus, pékabati na ta éya, éy kinagi na to lélake, a “Te esa pa a bagay a kulang diko. Angen mo ibugtong tu étanan a ari-arian mo. Sakay tu kabugtungan na éy iatéd mo du mahirap. Eng pakunan mo sa, éy te kayamanan ka dén ta langet. Ey nadid éy sumoli ka se a kumuyoyog ka diyakén.” ");
INSERT INTO dgc_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ey tu lélake, pékabati na ta éya, éy nalungkut dén siya, da napakayaman siya a tahod. ");
INSERT INTO dgc_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ey ti Jesus, péketa na a mélungkut siya, éy kinagi na, a “Mehirap a talaga a makasdép du mayaman ta kaharian na Diyos. ");
INSERT INTO dgc_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Makasdép beman i kabayo ta ébut na digum? Mas lalo a mehirap a makasdép i mayaman a tolay ta kaharian na Diyos.” ");
INSERT INTO dgc_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Nadid du tolay sa, pékabati de ta éya, éy kinagi de, a “Eng kona sa, éy ti ésiya i makaligtasa?” ");
INSERT INTO dgc_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ey kinagi ni Jesus, a “Tama ngani; éwan maari i tolay a mangiligtas ta bégi na. Pero magimet na Diyos i maski anya.” ");
INSERT INTO dgc_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Nadid ti Pedro, éy kinagi na, a “Entan mo, Panginoon. Sikame, éy gininanan me dén tu bile me, a kinumuyog kame diko.” ");
INSERT INTO dgc_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ey “O,” kagi ni Jesus; “sakay tandaan moy: i maski ti ésiya a magtiis a guminan ta bile na éy ta tétotop na éy ta ina na éy ta ama na, éy ta anak na a monda magpahayag siya ta kaharian na Diyos, ");
INSERT INTO dgc_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","éy atdinan siya na Diyos ta dubli-dubli a gantimpala na nadid a panahun. Ey ta panahun a dumemét,” kagi ni Jesus, “éy makamtan na be i buhay a éwan tu katapusan.” ");
INSERT INTO dgc_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Nadid, nibukod ni Jesus du alagad na, a kinagi na dide, a “Entan moy, umange kitam nadid ta Jerusalem. Ey ta éya, éy matupad a talaga i étanan a nisulat du purupeta to araw a tungkul diyakén a lélake a gébwat ta langet. ");
INSERT INTO dgc_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Itugénék de ta éya di dayuan yae a éwan Judeo. Ey side éy tétoksonék de, sakay lélokonék de, sakay loktabenék de. ");
INSERT INTO dgc_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Sakay balbalénék de, sakay bunonék de. Ey ta ikatélo a aldew éy mabuhayék a huway.” ");
INSERT INTO dgc_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ey du alagad, pékabati de ta éya, éy éwan de napospusan, da niliso dide na Diyos tu kahulugen na. ");
INSERT INTO dgc_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Nadid, to kéadene de Jesus ta Heriko, éy te esa a lélake a buhék a te eknud to digdig no dilan, a mékilimos. ");
INSERT INTO dgc_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ey pékabati na du tolay a sumalegéd, éy pinakelagipan na side éng bakit meadu side. ");
INSERT INTO dgc_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ey kinagi de diya a sumalegéd ti Jesus a taga Nasaret. ");
INSERT INTO dgc_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ey pékabaheta na ta éya, éy dumédulaw siya a kinagi na, a “Jesus, Apo ni Dabid, kagbianék pad!” ");
INSERT INTO dgc_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ey du tolay ta ditol, éy sinaway de siya a diyan siya tu pehéng. Pero lalo pa siya a dinumulaw. “Apo ni Dabid,” kagi na, “Kagbianék mo.” ");
INSERT INTO dgc_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nadid, pékabati ni Jesus diya, éy hinumintu siya, sakay inutusan na side a angen de tu buhék. Ey to péngiange de ni Jesus, éy kinagi na diya, a ");
INSERT INTO dgc_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Anya i gustu mua a gemtén ko diko?” “Panginoon,” kagi na, “gustu ko maketaék.” ");
INSERT INTO dgc_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ey “Maari,” kagi ni Jesus, “da méniwala ka diyakén, éy mahusay dén i mata mua.” ");
INSERT INTO dgc_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ey to pégkagi ni Jesus ta éya, éy naketa siya agad. Ey tulos inumunonod siya ni Jesus to dilan, a pépurién na i Diyos. Ey du tolay sa, péketa de ta éya, éy pinuri de be i Diyos. ");
INSERT INTO dgc_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Nadid, tulos sinomdép de Jesus ta Heriko. ");
INSERT INTO dgc_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ey ta éya éy te lélake a mayaman, a ti Sakeo i ngahen na. Medukés siya a ugali, da siya i tagapamahala du mégpabuwes ta éya. ");
INSERT INTO dgc_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Pékabaheta na a dumemét dén ti Jesus, éy pégpilitan na a entan. Pero éwan siya maari, da meaadu a tolay to dilan; sakay pati, éy medibi siya a lélake. ");
INSERT INTO dgc_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Kanya naginan siya to ditol, a inumunek to kayo to pahipad no dilan, monda meta na ti Jesus a sumalegéd. ");
INSERT INTO dgc_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ey ti Jesus, kédemét na to sahok no kayo, éy tinangad na ti Sakeo, a kinagi na diya, a “Nay, Sakeo, umogsad ka dén, da tumulosék nadid ta bile mo.” ");
INSERT INTO dgc_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ey ti Sakeo, pékabati na ta éya, éy inumogsad siya agad; éy nasahat siya a nananggap ni Jesus to bile na. ");
INSERT INTO dgc_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Pero du iba sa a tolay, péketa de a tinumulos ti Jesus to bile ni Sakeo, éy pinintasan de siya, a kinagi de, a “Bakit siya tinumulos ta medukés a lélake?” ");
INSERT INTO dgc_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nadid, tinumaknég ti Sakeo to bile na, a kinagi na ni Jesus, a “Panginoon baten pad i kagin kua diko: i kalahati na kayamanan ko, éy iatéd ko du mahirap a tolay. Sakay éng nakadayaék man ta maski ti ésiya, éy sobra pa sa i isoli ko dide. Bawat kuhata a nadaya ko, éy isoli ko i épat a bahagi.” ");
INSERT INTO dgc_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Nadid, kinagi ni Jesus, a “Nadid a aldew, éy niligtas dén na Diyos i bileae, da apo be ni Abraham i lélakeae. ");
INSERT INTO dgc_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kanyaék se inumange ta mundua, éy monda ahayukén ko du nebut a tolay, a iligtas ko side.” Pangpuhuba Na Diyos Du Sakup Na ");
INSERT INTO dgc_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nadid, adene dén ti Jesus a dumemét ta Jerusalem. Kanya du tolay, éy akala de éy dumemét dén nadid i panahun a pagharién siya na Diyos. Kanya kinagi ni Jesus dide i halimbawa, monda meta de a éwan pabi. ");
INSERT INTO dgc_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Te mataas kan wade a lélake,” kagi na, “a inumange ta adeyo a banuwan, monda matanggap na i kapangyarian na a maghari, sakay magsoli siya. ");
INSERT INTO dgc_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Bagu siya hinumektat, éy nipauwet na i sapulu a utusan na, a nientarega na ta bawat esa dide i esa a pilak a gintu. ‘Puhunan moy ina a magtinda-tinda kam’ kagi na, ‘hanggan éwanék sumoli.’ ");
INSERT INTO dgc_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Pero du kabébayan na éya a mataas a lélake, éy méiyamut kan side diya. Kanya inutusan de tu esa dide a ange mégkagi to mataas pa diya, a ‘Idel me a maghari siya dikame.’ ");
INSERT INTO dgc_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Nadid, to pékaalap no mataas a lélake to kapangyarian na a maghari, éy nagsoli kan dén. Ey kédemét na, éy nipauwet na du sapulu a utusan na, a monda meta na éng sénganya i tubua no kuhata na a nientarega na dide. ");
INSERT INTO dgc_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Tu purumeru a utusan, éy kinagi na kan, a ‘Entan mo, Amo, i tubua no nientarega mo diyakén a pilak a gintu, éy naging sapulu dén.’ ");
INSERT INTO dgc_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","‘Ah, mahusay ka a utusan,’ kagi kan no mataas. ‘Nadid, da matapat ka to nientarega ko diko, éy idéton ta ka a mayor na sapulu a banuwan.’ ");
INSERT INTO dgc_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Nadid, tu ikaduwa a utusan, éy kinagi na kan, a ‘Entan mo, Amo, i tubua no nientarega mo diyakén a pilak, éy naging lima dén.’ ");
INSERT INTO dgc_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","‘Ey tama,’ kagi kan no mataas. ‘Kanya idéton ta ka a mayor na lima a banuwan.’ ");
INSERT INTO dgc_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Nadid tu esa man a utusan, éy kinagi na kan to amo na, a ‘Saye tu nientarega mo diyakén a pilak. Basta nibalut ko san to panyo ko,’ kagi na kan, ‘monda éwan mebut. ");
INSERT INTO dgc_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Kanya éwan ko pinuhunan, éy mégantengék diko, da metapang ka. Tukoy ko a alapén mo tu éwan mo koo.’ ");
INSERT INTO dgc_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ey kinagi kan no mataas, a ‘Medukés ka a utusan! Tu kinagi mo, éy saya i katunayana a te kasalanan ka. Eng tukoy mo a metapangék, a alapén ko be i maski éwan ko koo, ");
INSERT INTO dgc_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","éy bakit éwan mo san dén nihulug ta bangko, monda makaalapék ta tubu na?’ ");
INSERT INTO dgc_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Nadid, kinagi kan no mataas du iba sa, a ‘Nay, alapén moy diya i pilak a gintu, sakay iatéd moy to te sapalu dén.’ ");
INSERT INTO dgc_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","‘Ey bakit, Amo,’ kagi de kan, ‘éy iatéd tam diya, éy te sapulu dén siya nadid a kuhata?’ ");
INSERT INTO dgc_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","‘Ey tama,’ kagi kan no mataas. ‘Ey tandaan moy, du tolay a pégkatiwalaan ko to nientarega ko dide, éy dagdagen ko pa side. Pero du éwan ko pégkatiwalaan, éy alapén ko be tu kétihék a nientarega ko dide. ");
INSERT INTO dgc_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ey nadid,’ kagi na kan, ‘diden ya a kalaban ko a mégidel diyakén a maghariék dide, éy paangen moy se side a bunon moy side ta harap kuae!’” ");
INSERT INTO dgc_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nadid, kétapos ni Jesus a négkagi du tolay, éy hinumektat siya dide, a négdetol siya dide a umange ta Jerusalem. ");
INSERT INTO dgc_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ey kéadene na ta Betpage, sakay ta Betania, sakay ta Buked na Olibo, éy pinégdetol na i éduwa a alagad na. ");
INSERT INTO dgc_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Ikad moy dén ta bariyua ta dibilew yae,” kagi na, “éy ta késdép moy sa éy meta moy sa i esa a bul-o a kabayo, a te egut, a éwan pabi tinolduan. Ukadén moy a iange moy se. ");
INSERT INTO dgc_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Eng te magpakelagip dikam éng bakit ukadén moy, éy kagi moy a kailangan na Panginoon.” ");
INSERT INTO dgc_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nadid, éy inumange sa du éduwa a alagad, éy neta de tu étanan a kinagi ni Jesus dide. ");
INSERT INTO dgc_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ey to péngukad de to kabayo, éy nipakelagip dide du te koo éng bakit éukadén de. ");
INSERT INTO dgc_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ey kinagi de dide a kailangan na Panginoon. ");
INSERT INTO dgc_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ey nitugén de tu kabayo ni Jesus. Sakay sinapinan de siya to damit de, sakay tulos pinasakay de ti Jesus. ");
INSERT INTO dgc_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Nadid, to péglakad na a sédép ta Jerusalem, éy du tolay éy naglatag side ta damit de to kamino a dimanén na. ");
INSERT INTO dgc_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nadid, to kéadene na ta Jerusalem, a kébulnok de ta Buked na Olibo, éy du meaadu a alagad na, éy nagsapul side a nagpasalamat ta Diyos ta medegsén, sakay pinépuri de siya, dahilan ta meadu a ginimet dén ni Jesus a mineta de. ");
INSERT INTO dgc_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Mabuhay!” kagi de. “Basbasén maka na Diyos i hari tamae a pinaange na se! Mapayapa maka dén i langet, a purién be i Diyos ta éya!” ");
INSERT INTO dgc_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ey du Pariseyo a édsa sa, éy kinagi de ni Jesus, a “Maistu, sawayén mo du alagad mo a mégkagi ta kona sa. Ewan tama i pégdulaw dia diko.” ");
INSERT INTO dgc_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ey “Ewan maari,” kagi ni Jesus. “Eng éwan side mégdulaw ta kona sa, éy lewasan side didi bituae a magpuri diyakén.” ");
INSERT INTO dgc_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Nadid, péketa ni Jesus ta Jerusalem, éy nahabag siya du tolay sa, a mégsanget siya dide. ");
INSERT INTO dgc_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Ayhay,” kagi na, “sikam a taga Jerusalem. Mapospusan moy maka i mangatéd dikam ta kapayapaan moy. Pero éwan, éwan moy mapospusan. ");
INSERT INTO dgc_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Dumemét dikam a talaga i oras a paghirap moy. Ey du kalaban moy éy kulungén de i banuwan moya, a hanggan éwan kam makaluwas. Sakay duklusén de kam, ");
INSERT INTO dgc_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","a puksaén de i banuwan moya. Pati du dingding a pader ta banuwan moy, éy patumbaén de a étanan. Saya i paghirap moya,” kagi ni Jesus, “da éwan moy natenggi i Diyos to péngange na dikam péngagaw.” ");
INSERT INTO dgc_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Nadid, sinomdép ti Jesus to Templo, sakay pinaibut na sa du étanan a tolay a mégtinda-tinda, ");
INSERT INTO dgc_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","a kinagi na dide, a “Isip ko nabasa ta libru na Diyos a i bile na Diyos éy dulawén de a bile a panalanginan. Ey bakit nadid, dahil dikam, kanya dulawén de a bile na mégdaya!” ");
INSERT INTO dgc_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Nadid, uméange ti Jesus to Templo a aldew-aldew, a mégtoldu. Ey du mataas a padi, sakay du iba a te tungkulin a Judeo, éy gustu de a bunon ti Jesus. ");
INSERT INTO dgc_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pero éwan de meta éng pakodya i pamunu dia diya, da meaadu a tolay a te gustu diya, sakay gustu de be a mébati i pégtoldu naa. ");
INSERT INTO dgc_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nadid, to esa a aldew, éy mégtoldu ti Jesus to Templo ta Mahusay a Baheta. Ey inumadene diya du te tungkulin a Judeo, ");
INSERT INTO dgc_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","éy kinagi de diya, a “Anya i katungkulan mua a nagimet ta kona sina a gimet mo? Ti ésiya i néngatéda diko ta katungkulan mua a ina?” ");
INSERT INTO dgc_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ey kinagi ni Jesus dide, a “Pakelagipan ta kam be. Kagi moy diyakén,” kagi na, ");
INSERT INTO dgc_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","“éng ahe i gébwat na katungkulana ni Juan a kanya nagbinyag siya; gébwat ta Diyos o ta tolay?” ");
INSERT INTO dgc_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Nadid, du te tungkulin, pékabati de ta éya, éy néguhon-uhon side, éng anya i sengbet dia ni Jesus. “Eng kagin tam a gébwat ta Diyos i katungkulan ni Juan,” kagi de, “éy pégkagian na kitam a talaga éng bakit éwan kitam naniwala ni Juan. ");
INSERT INTO dgc_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Pero éng kagin tam a tolay san i nagutusa ni Juan, éy di tolay ta palebut tamae, éy batikalén de kitam a talaga, da side éy isip de purupeta ti Juan a gébwat ta Diyos i katungkulan na.” ");
INSERT INTO dgc_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Kanya kinagi de ni Jesus, a “Ewan me tukoy.” ");
INSERT INTO dgc_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ey “Maari,” kagi ni Jesus dide, “da éwanék moy sinengbet, éy éwan ta kam be sengbitén éng anya i katungkulan ko a mégimet ta ginimet ko.” Du Judeo Du Purupeta ");
INSERT INTO dgc_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Nadid, négkagi ti Jesus du tolay ta halimbawa a kagi. “Eng mara,” kagi na, “éy te esa a lakay a nagmula ta ubas to uma na. Sakay nientarega na tu uma na du kahati na, sakay inumange siya ta iba a lugar, a nale siya ta éya. ");
INSERT INTO dgc_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ey nadid, kédemét na panahun na pégpitas ta ubas, éy pinaange sa no lakay tu utusan na, a monda alapén na tu kabahagi na to bunga no ubas. Pero du kahati na, péketa de to utusan no amo de, éy binalbal de siya, sakay pinéglakad de siya a éwan tu kébil. ");
INSERT INTO dgc_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kanya tu lakay, éy pinaange na sa tu utusan na a esa. Pero du kahati na, éy linoko de be siya, a binalbal de be. Sakay pinéglakad de be siya a éwan tu kébil. ");
INSERT INTO dgc_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ey tu lakay, éy pinaange na man dén i esa man dén a utusan. Pero siya éy pinasakitan de, sakay nibut de siya to luwas no uma. ");
INSERT INTO dgc_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Nadid, kinagi kan no lakay, a ‘Anya wade i gemtén kua? Paangen ko sa tu anak ko a mahal ko. Talaga a igalang de siya,’ kagi na. ");
INSERT INTO dgc_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pero du kahati na, péketa de to anak no amo de, éy kinagi de, a ‘Siya i magmanaa; bunon tam dén, monda koo tam dén i lutaae a mana na.’ ");
INSERT INTO dgc_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Kanya kembil de siya to adeyo to uma, sakay binuno de siya. “Nadid,” kagi ni Jesus, “anya i isip moya to lakay a te uma? Anya wade i gemtén na du kahati na? ");
INSERT INTO dgc_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Umange sa siya a talaga a bunon na diden ya a tolay, sakay ientarega na tu uma na ta iba a tolay!” Nadid, du tolay sa a nakabati ta éya a kinagi ni Jesus, éy kinagi de, a “Ewan maka kona sa i gemtén no lakay!” ");
INSERT INTO dgc_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ey linameng side ni Jesus, a kagi na, a “Eng isip moy a éwan sa kona i gemténa na Diyos, éy anya i kahulugen na éye a kagi ta kasulatan: ‘Tu bito kan a inidelan du mégbile, da isip de a éwan tu pasa, éy siya bale i mahalagaa a bito a panuluk no bile.’ ");
INSERT INTO dgc_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Maski ti ésiya i mebagsaka ta éya a bito,” kagi ni Jesus, “éy mate siya. Sakay i bagsakana na éya a bito éy mahémsit.” ");
INSERT INTO dgc_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Nadid, du te tungkulin a Judeo, pékabati de ta éya, éy naisip de a side du kahati a pinégkagian ni Jesus to halimbawa. Kanya gustu de dén a dekpén ti Jesus. Pero inumanteng side du tolay. ");
INSERT INTO dgc_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kanya sinubukan de siya, éng meta de tu pagkékataon de a mangdikép diya, monda itugén de siya ta gubiyerno. Pinaange de diya i iba a tolay a monda puhubaan de siya, éng pagkamalién de siya maka ta kagi na. Ey nagwari-wari side a matapat diya. ");
INSERT INTO dgc_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","I kinagi dia diya, éy “Maistu, tukoy me a matapat ka a mégtoldu ta tama; sakay éwan mo ugali a manuyu ta mataas a tolay. Tukoy me be a mégtoldu ka san ta tunay a kaluuben na Diyos. ");
INSERT INTO dgc_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Nadid,” kagi de, “anya i isip mua? Labag wade ta utus tam éng bumuwes kitam ta hari ta Roma, o éwan?” ");
INSERT INTO dgc_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Nadid, tukoy dén ni Jesus a pépuhubaan de san siya. Kanya kinagi na dide, a ");
INSERT INTO dgc_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Nay, ipeta moy diyakén i esa a kuhata moy a pagbuwes. Kéˈ ni ésiya i éye a letrato, sakay kéˈ ni ésiya a ngahen i nakasulatae?” “Ey tu hari tam ta Roma,” kagi de. ");
INSERT INTO dgc_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","“Ey tama,” kagi ni Jesus. “Ey nadid, tu koo na hari ta Roma, éy iatéd moy diya. Pero tu para ta Diyos, éy iatéd moy ta Diyos.” ");
INSERT INTO dgc_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Nadid, du mégsubuk diya, éy nagtaka side to sengbet na dide. Ey éwan side maari a mapilit siya a mégkagi ta mali ta harap du tolay, da éwan side tu katuwiran diya. ");
INSERT INTO dgc_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Nadid, éy inumange ni Jesus i sénganya a Saduseyo. (Du Saduseyo, éy éwan side méniwala a mabuhay i tolay a huway.) ");
INSERT INTO dgc_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Maistu,” kagi de, “nisulat ni Moises i kona se: Eng mate kan tu lélake a te asawa, sakay éwan pabi side tu anak, éy tu wadi na, éy dapat asawan na kan tu kayong na a bilo, monda magenak siya, para te anak tu aka na a minate. ");
INSERT INTO dgc_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Nadid, Maistu,” kagi de, “éy te pitu a pépétwadi a lélake to éya. Ey nangasawa tu panganay. Ey minate siya a éwan pabi tu anak. ");
INSERT INTO dgc_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Kanya inasawa no wadi na tu kayong na a bilo. ");
INSERT INTO dgc_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ey kona be sa tu ikatélo. Ey kona be sa hanggan to ikapitu. Ey minate side a étanan a éwan pabi tu anak. ");
INSERT INTO dgc_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ey katapusana éy minate be tu bébe. ");
INSERT INTO dgc_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ey nadid, Maistu,” kagi du Saduseyo, “saye i gustu mia a mapospusan: Nitoldu mo a te buhay kan i tolay a huway. Eng talaga a kona sa, éy ti ésiya dide a pitu i maging asawa na ta kébuhay du tolay a huway, da inasawa de siya a étanan?” ");
INSERT INTO dgc_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ey kinagi ni Jesus dide, a “Mali kam, da entan moy, du tolay ta munduae, éy ugali de a mangasawa. ");
INSERT INTO dgc_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pero du tolay a maari a mabuhay a huway a umange ta langet, éy éwan side mangasawa, ");
INSERT INTO dgc_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","da kapareho side du anghel ta langet, a éwan side mate a huway. Anak side na Diyos, da nabuhay dén side a gébwat ta pate. ");
INSERT INTO dgc_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ey sikam a Saduseyo,” kagi ni Jesus, “éy bakit isip moy a éwan mabuhay i tolay a huway? Ti Moises i katunayana a mabuhay i tolay a huway. Da nabasa to kasulatan, a to kéharap ni Moises to kayo a mégdingat, éy nginahinan na i Diyos a siya i Diyos a péniwalaan ni Abraham, sakay ni Isak, sakay ni Hakob. ");
INSERT INTO dgc_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Kahulugina na éya,” kagi ni Jesus, “éy méniwala side nadid ta Diyos, maski minate side to araw, da buhay dén side nadid ta langet.” ");
INSERT INTO dgc_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Nadid, to pégkagi dén ni Jesus ta éya du Saduseyo, éy du maistu ta rilihiyon ta éya, éy kinagi de, a “Tama, Maistu, tu kinagi mo.” ");
INSERT INTO dgc_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ey du Saduseyo, éy mésanike side a mékipagpasuway ni Jesus a huway. ");
INSERT INTO dgc_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Nadid, kinagi ni Jesus dide, a “Bakit kagi du tolay a tu tiniyak na Diyos a tagapagligtas éy ninuno siya ni Hari Dabid? ");
INSERT INTO dgc_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Pero dinulaw siya ni Dabid a amo na! Da kinagi ni Dabid to araw ta libru na Manga Kanta, a ‘Kinagi na Diyos to amo ko, a “Mégiknud ka ta tagirilan kuae ");
INSERT INTO dgc_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","a hanggan mapasuku ko diko du kalaban mo.”’ ");
INSERT INTO dgc_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Nadid ti Dabid, éy dinulaw na a amo na tu tagapagligtas. Eng kona sa, éy bakit kagi du maistu moy a ninuno san siya ni Dabid?” ");
INSERT INTO dgc_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nadid, hinatulan ni Jesus du alagad na. Ey du étanan a tolay sa, éy négbati side to kinagi na. ");
INSERT INTO dgc_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mangilag kam du maistu ta rilihiyon,” kagi na. “Gustu de a mégbihis ta memahal a badu, monda meta du tolay a mataas side. Sakay gustu de a saloduan side na tolay ta plasa na banuwan. Sakay gustu de be a umeknud ta pégiknuden na mataas a tolay ta anyayaan, sakay ta kapilya. ");
INSERT INTO dgc_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Sakay ugali de be a ménalangin ta atakdug, monda isip du tolay a banal side. Pero éng te bébe a bilo, éy ganggangén de san tu luta na. Kanya parusaan side na Diyos ta lalo a mahigpit!” ");
INSERT INTO dgc_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Nadid, to édse ni Jesus to Templo, éy te itan na du mayaman a tolay a nitékneg de tu kuhata to kahon a pégabuluyan. ");
INSERT INTO dgc_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ey neta na be i esa a bilo a bébe a mahirap, a nitékneg na sa i éduwa san a sentimos. ");
INSERT INTO dgc_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ey kinagi ni Jesus, a “Entan moy i bilo yae. Tu nitékneg na sina to kahon, éy bilang mahigit pa to niabuluy du étanan a iba a tolay. ");
INSERT INTO dgc_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Dahilan du iba, éy niabuluy de ta Diyos tu sobha de san. Pero siya, maski pobri siya, éy niatéd na dén i étanan a kuhata na, pati ta pamugtong ta kabuhayan na.” ");
INSERT INTO dgc_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Nadid du alagad, éy néguhunan de i tungkul ta Templo, éng kodya i kamahal na, sakay du dédekél a bito ta dingding na, sakay du dekoresiyon na a nidéton du tolay. ");
INSERT INTO dgc_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ey kinagi ni Jesus dide, a “I étanan a ina a te itan moy, éy dumemét i oras a éwan sina tu mabuhay a bito a te tupo ta kapareho na a bito ta dingding naa. Matibatibag side a étanan.” ");
INSERT INTO dgc_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","“Maistu,” kagi di, “nikésiya i deméta na éya a kinagi mo? Anya wade i tandaa a monda mapospusan me a dumemét dén i éya a hirap?” ");
INSERT INTO dgc_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","“Mangilag kam,” kagi ni Jesus, “monda éwan kam pagkamalién na tolay. Da te meadu a talaga a umange se a mégkagi a side i Cristo a tiniyak na Diyos a tagapagligtas ta mundua. Sakay ipahayag de be a dumemét dén nadid i katapusan na mundua. Diyan kam maniwala dide. ");
INSERT INTO dgc_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Eng makabaheta kam ta meadu a gera, sakay laban, éy diyan kam métageg. Dumemét a talaga i meadu a gera, pero éwan ya tanda na katapusan. ");
INSERT INTO dgc_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","“Sakay maglaban-laban du banubanuwan. ");
INSERT INTO dgc_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Sakay te meadu a lindul,” kagi na, “sakay dumemét i meadu a alép, sakay saket, ta iba-iba a lugar. Te meadu a dumemét a medukés a manyari, sakay dikél a makataka-taka ta langet. ");
INSERT INTO dgc_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Pero bagu dumemét diden ya a hirap, éy ipadikép kam pa du tolay, a pasakitan de kam. Sakay ipakébil de kam ta kapilya de, sakay ta pégpihesuan. Sakay iharap de kam du hari, sakay gubernador, da méniwala kam diyakén. ");
INSERT INTO dgc_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Saya tu pagkékataon moy a magpahayag ta Mahusay a Baheta. ");
INSERT INTO dgc_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Patibayén moy nadid i isip moya a diyan kam métageg éng anya i katuwiran moya dide, ");
INSERT INTO dgc_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","da atdinan ta kam ta tama a kagi, sakay ta isip moy a matalinung, monda du kalaban moy, éy éwan side makaidel ta katuwiran moya dide. ");
INSERT INTO dgc_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Pati du magulang moy, sakay du tétotop moy, sakay du kadimoy moy, éy itokyon de kam a ipadikép. Ey i sénganya dikam éy bunon de. ");
INSERT INTO dgc_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Sakay kaiyamutan kam na étanan, da méniwala kam diyakén. ");
INSERT INTO dgc_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","19","Pero éng pagtiisan moy san, éy umabut kam ta buhay a éwan tu katapusan. Ey éwan kam mebut a talaga.” ");
INSERT INTO dgc_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Nadid,” kagi ni Jesus, “éng dumemét i oras a meta moy a kulungén dén du sundalu i Jerusalem, éy tukoy moy a adene dén a mapuksa i éya. ");
INSERT INTO dgc_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Péketa moy ta éya, éy du édse ta Hudea, éy dapat guminan side ta buked. Sakay du édse ta lubuk na banuwan, éy dapat humektat side. Sakay du édse ta luwas na banuwan, éy diyan side sumoli ta banuwan. ");
INSERT INTO dgc_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Dahilan i éya a panahun,” kagi ni Jesus, “éy saya i oras a parusaan na Diyos du Judeo. Saya i orasa a kétupad na étanan a nihula du purupeta ta kasulatan. ");
INSERT INTO dgc_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","“Kakakagbi du mabuktet sakay du te mabulol ta panahun a éya!” kagi ni Jesus; “da mahigpit a tahod i kahirapan du Judeo ta éye a luta. ");
INSERT INTO dgc_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","I kalahati dide, éy mate side ta laban. Sakay du iba, éy dekpén de side, a iange de side a pihesu ta iba-iba a banuwan ta adeyo. Sakay i banuwan na Jerusalem, éy sakupén ya na iba a tolay a éwan Judeo, a hanggan éwan malipas i panahun de. ");
INSERT INTO dgc_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Nadid,” kagi ni Jesus, “éy dumemét ta langet i kataka-taka, a te tanda ta bilag, sakay ta bulan, sakay du biton. Sakay du tolay ta mundua, éy méligalig side, sakay méganteng be side ta ugung na diget, sakay ta dalondun na a dikél. ");
INSERT INTO dgc_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Meadu a tolay a manghimatay side tu isip, dahil ta anteng de, ale de a maguhay ta manyari ta mundua. Pati du biton, éy matékneg side, da mayégyég i langet. ");
INSERT INTO dgc_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Nadid, sakén a lélake a gébwat ta langet, éy metaék de ta kuném a dumibi ta lutaa a maghari, a kébil ko i kapangyarian ko. ");
INSERT INTO dgc_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ey nadid,” kagi ni Jesus, “éng meta moy a magsapul diden ya a nihula ko dikam, éy patibayén moy i isip moya, a dapat masaya kam, da adene dén a dumemét i kaligtasan moy.” ");
INSERT INTO dgc_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Nadid, kinagi ni Jesus dide i halimbawa a iba. “Mara tu kayo a igos,” kagi na, “sakay du kayo a iba. ");
INSERT INTO dgc_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Bagay mégogbus side, éy tukoy moy a adene dén i késinag. ");
INSERT INTO dgc_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Nadid, kona be sa, bagay meta moy i étanan a éya a nihula ko, éy tukoy moy dén a adene dén i panahun na Diyos a maghari ta mundua. ");
INSERT INTO dgc_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ey tandaan moy, manyari pa i étanan a éya bagu mate i étanan a tolay a buhay nadid. ");
INSERT INTO dgc_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Maibut i langet éy ta luta, pero i kagi ko éy éwan maibut.” ");
INSERT INTO dgc_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Mangilag kam,” kagi ni Jesus, “a diyan kam mékipégabala a méglasing, sakay mékipégsaya. Sakay diyan kam mékipégabala a mégahayok ta kabuhayan moy. Makay bigla a demtan ta kam dén a éwan kam nakahanda. ");
INSERT INTO dgc_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Dahilan, ta kédemét na péghukum, éy bigla a masakup i étanan a tolay ta maski ahe ta mundua. ");
INSERT INTO dgc_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kanya sikam, éy bantayan moy, sakay manalangin kam a palagi ta Diyos, a patibayén na i isip moya, monda mabuhay kam ta éya a kahirapan, monda éwan kam masanike a humarap diyakén ta kédemét ko, sakén a lélake a gébwat ta langet.” ");
INSERT INTO dgc_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Nadid ti Jesus, éy mégtoldu siya aldew-aldew ta Templo. Ey kélép-kélép, éy natidug siya ta Buked na Olibo. ");
INSERT INTO dgc_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ey du étanan a tolay, éy dumédulug side aldew-aldew ta amulaldew to Templo, da gustu de a mabati siya. ");
INSERT INTO dgc_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Nadid, éy adene dén i piyesta a ngéngahinan de a Piyesta na Ala-ala. Saya i piyesta a péngan de ta melapis a tinapay. ");
INSERT INTO dgc_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Du mataas a padi, sakay du maistu ta rilihiyon, éy naguhunan de a ipadikép ti Jesus ta lihim, a monda ipabuno de. Pero méganteng side du tolay, da meadu du te gustu ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nadid ti Satanas, éy inumasék dén siya ni Hudas Iskarote, a esa du labindalawa a alagad. ");
INSERT INTO dgc_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Tulos ange nékipéguhon ti Hudas du mataas a padi sakay du pulis no Templo, éng pakodyan na ti Jesus a padikép dide. ");
INSERT INTO dgc_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ey du padi, éy mésahat side, éy nagkasunduan dén side de Hudas, a atdinan de siya ta kuhata. ");
INSERT INTO dgc_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ey sapul ta éya, éy nagisip dén ti Hudas ta pagkakataon na a péngitokyon na ni Jesus dide, monda éwan mapospusan du tolay ta Jerusalem. ");
INSERT INTO dgc_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Nadid, kédemét na oras no piyesta a péngan de ta melapis a tinapay, éy saya i oras de a mégbuno ta tupa. ");
INSERT INTO dgc_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Kanya ti Jesus, éy inutusan na de Pedro éy ti Juan, a kinagi na dide, a “Ange kam maghanda ta paganyayaan tam para ta Piyesta na Ala-ala.” ");
INSERT INTO dgc_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ey “Ahe,” kagi de, “i gustu mua a paghandaan me?” ");
INSERT INTO dgc_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ey kinagi ni Jesus dide, a “Entan moy, umuli kam ta banuwan. Ey ta éya éy kasambat moy i esa a lélake a te kébil a dinom. Basta kumuyog kam diya a somdép kam ta bile a angayan na. ");
INSERT INTO dgc_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Sakay kagi moy to te bile ta éya, a ‘Tu Maistu me éy gustu na a mapospusan éng ahe i kuwarto a péngapunan me ta Piyesta na Ala-ala.’ ");
INSERT INTO dgc_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Eng kagi moy diya i éya,” kagi ni Jesus, “éy ipeta na dikam tu kuwarto ta ontok a nakahanda dén. Ey saya i paghandaan moya ta péngapon tama.” ");
INSERT INTO dgc_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Nadid, to pégkagi dén ni Jesus ta éya, éy inumuli dén du éduwa ta banuwan. Ey nanyari tu étanan a kinagi ni Jesus dide. Ey naghanda sa side ta péngapon de a para ta Piyesta na Ala-ala. ");
INSERT INTO dgc_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nadid, oras de a péngan, éy négdipon de Jesus ta éya, sakay du apostol na. ");
INSERT INTO dgc_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ey kinagi na dide, a “Gustu ko a tahod a mékidipon dikam nadid ta éye a Piyesta na Ala-ala, baguék mate! ");
INSERT INTO dgc_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Da kagin ko dikam i katutuhanan, a sapul nadid éy éwan ko dén kanén a huway i anyaya na Piyesta na Ala-ala, hanggan éwan matupad pa tu tunay a kahulugen na ta kaharian na Diyos.” ");
INSERT INTO dgc_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Nadid, inalap ni Jesus tu tasa a te lasén a alak. Ey to pégpasalamat na ta Diyos, éy kinagi na, a “Hati-hatién moy dén ye a inumén. ");
INSERT INTO dgc_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Da tandaan moy,” kagi na, “sapul nadid, éy éwanék dén uminom ta alak a huway, hanggan éwan se dumemét i péghari na Diyos ta tolay.” ");
INSERT INTO dgc_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Nadid, inalap na tu tinapay, éy to pégpasalamat na, éy pinuseng-puseng na, a nitagtag na du alagad na. “Saye i bégi kua,” kagi na: “a pabunu na Diyos a para dikam. Bagay kanén moy ye, éy maala-alaék moy.” ");
INSERT INTO dgc_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ey kona be sa tu ginamet na, ubus de a néngan, éy nigewat na dide tu alak, sakay kinagi na, a “I alakae a inumén tam, éy saye i tanda na bigu a pangako na Diyos dikam, a i katibayan naa éy tu digi ko a mebulak a para dikam. ");
INSERT INTO dgc_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Pero entan moy,” kagi na, “tu méngitokyon diyakén, éy kaguman tam san nadid ta éye a méngan! ");
INSERT INTO dgc_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Kailangan a mateék ayun to plano na Diyos. Pero kagbi a tahod tu méngitokyon diyakén!” ");
INSERT INTO dgc_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Pékabati du alagad ta éya, éy néguhunan de éng ti ésiya wade i méngitokyona ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Nadid, éy négpasuway du alagad éng ti ésiya dide i mataasa. ");
INSERT INTO dgc_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ey kinagi ni Jesus dide, a “Du hari du iba a tolay, éy mégéutusén side du tolay de. Sakay du tagapamahala, éy gustu de a purién side na tolay. ");
INSERT INTO dgc_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pero éwan maka sa kona dikam,” kagi ni Jesus. “Engˈwan, tu mataas dikam, éy dapat umaheg siya ta ugali na mababa, a ipabataan maka siya du kaguman na. ");
INSERT INTO dgc_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Mara, ti ésiya i mataasa, tu mégiknud san a méngan, o tu utusan na? Tu mégiknud a méngan, éy siya i mataasa. Pero sakén,” kagi ni Jesus, “éy maski mataasék dikam, éy komanék i utusan moy.” ");
INSERT INTO dgc_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Tukoy ko dén a matapat kam san a kinumuyoyog diyakén,” kagi ni Jesus, “maski meaduék dén a hirap. ");
INSERT INTO dgc_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ey nadid, da nidétunék dén Nama ko a maghari, éy atdinan ta kam be ta karapatan moy, ");
INSERT INTO dgc_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","a kaguman ta kam ta kaharian ko, a négdipon kitam sa, a mapisan. Sakay gemtén ta kam a sikam i magmayor du labindalawa a lahi na Judeo, a apo-apo ni Israel.” ");
INSERT INTO dgc_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Nadid, kinagi ni Jesus ni Simon Pedro, a “Simon, pinumilit dén ti Satanas, a monda puhubaan na kam ta mahigpit. ");
INSERT INTO dgc_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pero nipanalangin ta ka dén, Simon, monda éwan maibut tu péniwala mo diyakén. Ey nadid, Simon, éng magsisi ka dén, a nagsoli ka dén diyakén, éy gustu ko éy patibayén mo tu péniwala du kakaguman mo.” ");
INSERT INTO dgc_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","“Anin, Panginoon,” kagi ni Pedro, “éwan maibut tu péniwala ko diko. Maski ipihesu de kita a bunon de kita, éy éwan ta ka ginanan!” ");
INSERT INTO dgc_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","“Ewan, Pedro,” kagi ni Jesus. “Da tandaan mo, bagu magtarakot tu tandang nadid a amulaldew, éy tanggianék mo ta péntélo a éwanék mo kaguman.” ");
INSERT INTO dgc_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Nadid, kinagi ni Jesus du alagad na, a “To péglakad ko dikam to éya a mégtoldu, éy éwan ta kam pinagkébil ta kuhata, o suput, o reserba a sinelas; éy anya, kinulang kam beman ta maski anya?” “Ewan,” kagi de. ");
INSERT INTO dgc_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","“Pero nadid,” kagi ni Jesus, “éng maglakad kam a huway a magtoldu, éng te kuhata kam, éy kébilén moy dén. Sakay kébilén moy dén i suput. Sakay éng éwan kam tu sondang a armas moy, éy ibugtong moy tu badu moy ta sondang. ");
INSERT INTO dgc_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Da tandaan moy, tu kagi ta kasulatan na Diyos a tungkul diyakén, a kagi na a mebilangék kan du makasalanan a tolay, éy matupad dén ya nadid.” ");
INSERT INTO dgc_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","“Entan mo, Panginoon,” kagi du alagad, “te éduwa kitam dén se a sondang.” Ey “Tama dén ya,” kagi ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Nadid, linumuwas de Jesus ta Jerusalem, a inumange man dén side to katidugen de to Buked na Olibo. Ey kaguman na du alagad na. ");
INSERT INTO dgc_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ey kédemét de sa, éy kinagi ni Jesus du alagad na, a “Manalangin kam, monda éwan kam madaig na mangpuhuba dikam.” ");
INSERT INTO dgc_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nadid, inumadeyo siya dide ta kétihék, sakay linumuhud siya a ménalangin. ");
INSERT INTO dgc_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Améng,” kagi na, “Eng maari diko, éy iadeyo mo diyakén i paghirap ko. Pero éwan na kaluuben kua i masunud, éngˈwan na kaluuben mo i masunud.” ");
INSERT INTO dgc_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ey to pénalangin na ta éya, éy pinumeta diya i esa a anghel a gébwat ta langet, a nagpatibay diya. ");
INSERT INTO dgc_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ey nadid, dahil ta tageg na, éy nanalangin siya ta lalo a mahigpit, a hanggan i asob na éy koman i tuhog na dige, dahil to anteng na. ");
INSERT INTO dgc_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nadid, kétapos na a nanalangin, éy nagsoli siya du alagad na, a dinemtan na side a tidug, da mélungkut side. ");
INSERT INTO dgc_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","“Bakit tidug kam?” kagi na. “Umégkat kam dén, a manalangin kam dén, monda éwan kam madaig na mangpuhuba dikam.” ");
INSERT INTO dgc_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Nadid, pégkagi pabi ni Jesus ta éya, éy dinumemét sa i meaadu a tolay, a kaguman de ti Hudas, a alagad ni Jesus a esa. Ey inumadene siya ni Jesus a monda ahoben na siya. ");
INSERT INTO dgc_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ey kinagi ni Jesus diya, a “Bakit, Hudas, itokyonék mo beman ta pamag-itan na péngahob mo diyakén?” ");
INSERT INTO dgc_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Nadid, du alagad a kaguman ni Jesus, péketa de a dekpén siya du tolay, éy kinagi de diya, a “Anya, Panginoon, tegpasén me side ta sondang mia?” ");
INSERT INTO dgc_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ey tulos tu esa dide a tinegpas na tu utusan no mataas a padi, a tulos minahipas tu talinga na. ");
INSERT INTO dgc_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Pero sinaway ni Jesus du alagad na, a “Tama dén,” kagi na, “diyan moy side harangan!” Ey tulos kembilan na tu talingo no utusan, éy mahusay dén! ");
INSERT INTO dgc_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Nadid, kinagi ni Jesus du te tungkulin a Judeo sa a manikép diya, a “Bakit te armas kam a sondang éy ta kayo? Ataay, tulisanék beman a metapang? ");
INSERT INTO dgc_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Aldew-aldew éy édseék dikam ta Templo. Bakit éwanék moy sa dinikép? Pero nadid a kélép, éy saye i oras moy a mangdikép diyakén,” kagi ni Jesus, “da saye i oras a mesibét i kapangyarian ni Satanas.” ");
INSERT INTO dgc_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Nadid, éy dinikép de ti Jesus, a niange de siya to bile no mataas a padi. Ey tinonod-tonod side ni Pedro. ");
INSERT INTO dgc_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ey nadid, to harap no bile no padi, éy nagdukot side ta apoy. Ey nékiagum ti Pedro du mégeknud sa, a nékipagdengdeng be sa siya. ");
INSERT INTO dgc_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ey tu esa a bataan ta éya, péketa na ni Pedro to demlag no apoy, éy kinagi na du édsa sa, a “Siya bale ina i kagumana a esa no dinikép moy!” ");
INSERT INTO dgc_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pero nitanggi ni Pedro. “Ewan,” kagi na, “éwan ko siya tukoy!” ");
INSERT INTO dgc_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Mamaya-maya, éy mineta siya no esa a lélake, a tulos kinagi na, a “Siko i alagad na a esa!” Pero nisuway man dén ni Pedro. ");
INSERT INTO dgc_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Nadid, kélipas na manga esa a oras, éy kinagi no esa a tolay, a “Kaguman na siya a talaga, da taga Galilea be siya!” ");
INSERT INTO dgc_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pero nitanggi man dén ni Pedro, a kinagi na, a “Ewan ko tukoy tu kagi mo!” Ey nadid, to pégkagi pabi ni Pedro ta éya, éy nagtarakot tu tandang. ");
INSERT INTO dgc_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ey tu Panginoon, éy sinuleg na ti Pedro; éy nadid, péketa ni Pedro diya, éy naala-ala na tu kinagi ni Jesus diya, a “Bagu magtarakot i tandang nadid a amulaldew, éy itanggiék mo ta pentélo.” ");
INSERT INTO dgc_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ey to pékaala-ala ni Pedro ta éya, éy linumuwas siya, sakay nagsanget siya ta mahigpit. ");
INSERT INTO dgc_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Nadid, du méguwardia ni Jesus, éy linéloko de siya, sakay binébalbal de. ");
INSERT INTO dgc_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Sakay tinaklében de tu mata na ta damit, sakay sinésuntuk de, a tulos kinagi de diya, a “Nay, tukuyan mo éng ti ésiya i nanuntuka diko!” ");
INSERT INTO dgc_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Sakay meadu pa a iba a kagi i nipangdusta dia diya. ");
INSERT INTO dgc_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nadid, to gagabi dén, éy nagmiting dén du te tungkulin a Judeo. Pati du mataas a padi, sakay du maistu ta rilihiyon. Ey péngiange de ni Jesus to harap de, ");
INSERT INTO dgc_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","éy kinagi de diya, a “Anya, siko a talaga i Cristo a tiniyak na Diyos a tagapagligtas ta tolay ta mundua?” Ey kinagi ni Jesus dide, “Eng kagin ko ya dikam, éy éwan kam maniwala. ");
INSERT INTO dgc_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Sakay éng sakén i magpakelagipa dikam, éy éwan kam sumengbet diyakén. ");
INSERT INTO dgc_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pero sapul nadid, sakén a lélake a gébwat ta langet, éy magdatig kame ta Diyos, a kagumanék na a maghari.” ");
INSERT INTO dgc_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","“Ey nadid,” kagi de, “siko ngani dén i isesa a anak na Diyos, o éwan?” “Tama tu kagi moy,” kagi ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Nadid, pékabati du te tungkulin ta éya, éy kagi de, a “Bakit kailangan tam pa a mégbati du magsistigu diya ta kasalanan na?” kagi de. “Da nabati tam dén nadid tu sarili na a kagi a medukés!” ");
INSERT INTO dgc_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Nadid, du étanan sa a te tungkulin a Judeo, éy niange de ti Jesus ni Gubernador Pilato. ");
INSERT INTO dgc_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ey niabla de siya ni Pilato, a kinagi de, a “Gubernador, dinemtan me i lélake a éye, a mégtoldu ta mali du kabébayan me a Judeo, a sinaway na kan side a magbuwes to hari mo ta Roma. Sakay kagi na be a siya kan i tiniyak na Diyos a maghari.” ");
INSERT INTO dgc_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ey ti Pilato, pékabati na ta éya, éy kinagi na ni Jesus, a “Anya, siko i haria du Judeo?” Ey “O,” kagi ni Jesus, “kona to kinagi mo.” ");
INSERT INTO dgc_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ey nadid, ti Pilato éy kinagi na du mataas a padi, sakay dudu meadu sa a Judeo, a “Ewan ko meta i kasalanan na éye a lélake a monda ipaparusa ko siya.” ");
INSERT INTO dgc_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pero du Judeo, éy pépilitén de san ti Pilato, a “Ewan, medukés siya,” kagi de, “da léligaligén na du tolay ta Galilea, a hanggan ta éye, dahil ta pégtoldu naa!” ");
INSERT INTO dgc_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Nadid, pékabati ni Pilato ta éya, éy pinakelagipan na side éng taga Galilea ti Jesus. Ey, “O,” kagi de. ");
INSERT INTO dgc_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ey nadid, pékaisip na a sakup ni Herod a gubernador ta Galilea ti Jesus, éy nipeange na ti Jesus diya, da netaun dén ti Herod a binumisita ta Jerusalem. ");
INSERT INTO dgc_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ey ti Herod éy mésahat siya, da nale a panahun a nabaheta na dén siya, kanya gustu na siya a meta. I asa naa, éy makay ipeta ni Jesus diya i milagro. ");
INSERT INTO dgc_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Kanya pinakelagipan na ti Jesus ta meadu a kagi; pero éwan sinumengbet ti Jesus diya ta maski isesa a kagi. ");
INSERT INTO dgc_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ey nadid, du te tungkulin a Judeo, éy te taknég side to harap ni Herod, a tulos niabla de ti Jesus ta mahigpit. ");
INSERT INTO dgc_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Pati ti Herod, sakay du sundalu na, éy linéloko de be ti Jesus, a inéapi de. Binaduan de siya ta memahal a badu na hari, sakay pinasoli de siya ni Pilato. ");
INSERT INTO dgc_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Bagu ta éya a aldew, éy nagkalinga ti Herod sakay ti Pilato. Pero sapul ta éya a aldew, éy naging nagkadimoy dén side. ");
INSERT INTO dgc_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Nadid, pinauwet man dén ni Pilato du te tungkulin a Judeo, sakay du iba a Judeo. ");
INSERT INTO dgc_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ey kinagi na dide, a “Tu nitugén moy se a lélake, éy kinagi moy a tinolduan na kan du tolay ta mali. Pero to péngsiyasat ko diya ta harap moy, éy éwan ko mineta i kasalanan na, a kona to niabla moy diyakén. ");
INSERT INTO dgc_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ey kona be sa ti Herod, éy éwan na neta i kasalanan na. Kanya pinasoli na siya diyakén. I éye a lélake,” kagi ni Pilato, “éy éwan siya tu kasalanan a pangbunuan ko diya. ");
INSERT INTO dgc_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Kanya éy ipabalbal ko siya, sakay légsiwan ko dén.” ");
INSERT INTO dgc_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Nadid, tuwingg piyesta, éy kailangan ni Pilato a magpaluwas ta isesa a pihesu a para du tolay, da saya i ugali de. Kanya talaga na a légsiwan ti Jesus. ");
INSERT INTO dgc_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pero kinékagi du étanan a tolay ta medegsén, a “Ewan, bunon mo siya. I gustu me a légsiwan mo éy ti Barabas!” ");
INSERT INTO dgc_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Ti Barabas éy pihesu siya a lélake a nakabuno. Siya éy kaguman na du iba a tolay to péngligalig de ta banuwan.) ");
INSERT INTO dgc_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ey gustu ni Pilato a légsiwan na ti Jesus; kanya nékipégpasuway man dén siya du Judeo. ");
INSERT INTO dgc_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pero kinékagi de san ta medegsén, a “Ewan, ipako mo siya ta kudos! Ipako mo siya ta kudos!” ");
INSERT INTO dgc_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ey kinagi ni Pilato dide a huway, a “Bakit? Anya i kasalanan na? Ewanék tu meeta a kasalanan na a pamunuan ko diya. Kanya éy ipabalbal ko siya, sakay légsiwan ko dén.” ");
INSERT INTO dgc_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero du tolay, éy pépilitén de san ti Pilato ta mahigpit, a pinégkagian de siya ta medegsén, a “Ipako mo siya ta kudos.” Ey éwan nakasuway ti Pilato ta gustu de. ");
INSERT INTO dgc_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Kanya pinaayunan na side ta gustu de. ");
INSERT INTO dgc_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","I pinaluwas na sana éy tu gustu de a ti Barabas. Siya tu dati a nipihesu de, da linigalig na du tolay, sakay namunu be. Ey ti Jesus, éy nipetugén na dide a ipako ta kudos. ");
INSERT INTO dgc_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Nadid du sundalu, to péngiange de ni Jesus ta péngipakoan de, éy kasambat de i esa a lélake a somdép ta banuwan. Ti Simon i ngahen na a taga Sirene. Ey pinilit de siya minangbékle to kudos a umunonod ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Nadid, éy te meaadu pa a tolay a inumunonod be ni Jesus. Kaguman be sa i sénganya a bébe a mégsésangitén side diya. ");
INSERT INTO dgc_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ey sinuleg side ni Jesus, a kinagi na dide, a “Diyanék moy pégsangitan, sikam a taga Jerusalem a bébe. Engˈwan, i pagsangitan moy makaa, éy na bégi moya, sakay anak moy. ");
INSERT INTO dgc_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Da entan moy,” kagi na, “te dumemét a panahun a mahirap. Ey ta kédemét na, éy kagi du tolay a masuwerte du bébe a baug, a éwan tu anak a mabulol. ");
INSERT INTO dgc_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Lumalo a lumalo i éya a hirap, a hanggan umasa du tolay a kayonwan maka side du buked, monda mate side maka dén. ");
INSERT INTO dgc_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Entan moy,” kagi ni Jesus, “éng pahirapan de dén nadid tu éwan tu kasalanan, éy anya wade i gemtén dia ta esa a panahun dikam a te kasalanan?” ");
INSERT INTO dgc_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Nadid, to péngiange de ni Jesus a ipako de, éy niange de be sa i éduwa a tulisan a bunon de be. ");
INSERT INTO dgc_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ey kédemét de to lugar a ngéngahinan de a Bungu, éy nipako de ti Jesus, sakay du éduwa a tulisan. Tulos nitolnék de side ta magtembanga a tagirilan ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ey ti Jesus, éy kinagi na, a “Pagpasensiyaan mo side, Améng, da éwan de tukoy tu gemtén de.” Nadid, to péngitolnék de dén du étélo, éy hinati-hati de tu badu ni Jesus, a nagpalabunutan side éng ti ésiya i makaalapa dide. ");
INSERT INTO dgc_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ey dudu tolay ta éya, éy te taknég san side to digdig, a mégita. Ey du te tungkulin a Judeo, éy tinétokso de ti Jesus. “Entan moy,” kagi de, “niligtas na kan du iba. Ey nadid, éng siya i tiniyak na Diyos a tagapagligtas, éy bakit éwan na iligtas nadid i sarili na?” ");
INSERT INTO dgc_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Pati du sundalu sa, éy tinétokso de be siya, a ginewatan de siya ta tuba. ");
INSERT INTO dgc_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“Nay,” kagi de, “éng siko a talaga i haria na Judeo, éy iligtas mo beman i bégi mua!” ");
INSERT INTO dgc_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Nadid, te pastel to ontok no kudos ni Jesus, a i kinagi naa éy “SAYE I HARIA NA JUDEO.” ");
INSERT INTO dgc_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Nadid, tu tulisan a esa a nipako de be sa, éy pinégkagian na ti Jesus ta medukés, a “Bakit,” kagi na, “isip ko siko i tagapagligtasa ta tolay. Iligtas mo beman i bégi mua, sakay agawén mo kame be!” ");
INSERT INTO dgc_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pero tu tulisan a esa, éy pinégkagian na tu kaguman na, a “Bakit, maski mate ka, éwan ka bale umanteng ta Diyos ta langet? Entan mo,” kagi na, “pareho i parusa tama a étélo, ");
INSERT INTO dgc_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","éy tama tu gimet de dikita, da te kasalanan kita. Pero i kaguman ta a éye, éy éwan tu kasalanan.” ");
INSERT INTO dgc_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ey to pégkagi na ta éya, éy kinagi na ni Jesus, a “Alélahanénék pad, Jesus, ta kédemét mo a maghari.” ");
INSERT INTO dgc_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ey kinagi ni Jesus diya, a “Kagin ko diko i katutuhanan, a nadid a aldew éy kaguman ta ka ta langet.” ");
INSERT INTO dgc_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Nadid, sapul to tanghali, éy nagdiklém hanggan to alas tres. ");
INSERT INTO dgc_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ey nadid, tu kortina a dikél ta lubuk no Templo, éy bigla a napéknet a nahati dén. ");
INSERT INTO dgc_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ey dinumulaw nadid ti Jesus, a kinagi na, a “Améng, ientarega ko diko i kaliduwa kuae.” Ey to pégkagi na dén ta éya, éy tulos na dén nahéngsatan. ");
INSERT INTO dgc_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nadid, tu kapitan du sundalu, péketa na ta nanyaria, éy pinuri na i Diyos, a kinagi na, a “I éye a lélake, éy éwan siya tu kasalanan a talaga!” ");
INSERT INTO dgc_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ey du napisan sa a tolay a mégita, péketa de ta nanyaria, éy nagsoli side ta bile de a mélungkut a tahod. ");
INSERT INTO dgc_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ey du dati a kakaguman ni Jesus, sakay du bébe a kinumuyoyog diya sapul to kéhektat na ta Galilea, éy édsa be sa side a nangtan-aw ta nanyaria. ");
INSERT INTO dgc_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Nadid, te esa a lakay ta Jerusalem a taga Arimatea ta Hudea. Mahusay siya a lakay, a siya be i maguhaya ta kédemét na Diyos a maghari. Maski mataas be siya a Judeo, a konsiyal siya, éy éwan siya inumayun ta gustu a gemtén du kaguman na ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Siya éy inumange ni Pilato a inaged na tu bangkay ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ey nadid, éy pineogsad na dén tu bangkay to kudos, sakay sinaputan na to manta, sakay nielbéng na to kuweba a nipaébut de to pader, a éwan pabi ginamit. ");
INSERT INTO dgc_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","I éya a aldew éy disperas. Ta gabia éy pangilin na Judeo. ");
INSERT INTO dgc_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ey du bébe a kinumuyoyog ni Jesus sapul to kéhektat na ta Galilea, éy kaguman ni Hose to lébéng. Ey neta de éng kodya i pinéngielbéng dia diya. ");
INSERT INTO dgc_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ey nagsoli dén du bébe to bile de, a tulos nihanda de tu don a mesépot, a para ipahid de to bangkay ni Jesus. Ey to kagagabian na éya, éy inumimang san side, ayun ta ugali na kautusan de. ");
INSERT INTO dgc_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Nadid, to simba dén a amulaldew, éy inumange du bébe to lébéng, a kébil de sa tu hinanda de a don a mesépot. ");
INSERT INTO dgc_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ey kédemét de to kuweba a lébéng, éy dinemtan de a bukas bale dén, a negulung dén to digdig tu takléb na a bito! ");
INSERT INTO dgc_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ey késdép de to kuweba, éy éwan bale sa tu bangkay ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nadid, to pégisip-isip de éng anya i nanyaria, éy bigla a te taknég sa i éduwa a lélake, a méngislap i badu dia. ");
INSERT INTO dgc_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ey du bébe, éy inumanteng side, a dinumukog side. Ey kinagi du lélake dide, a “Bakit ahayukén moy tu buhay a tolay ta lubuk na lébéng? ");
INSERT INTO dgc_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","Ewan moy naala-ala tu kinagi ni Jesus dikam ta Galilea? I kinagi na éy kailangan éy tu lélake a gébwat ta langet, éy metugén kan siya du medukés a tolay, a tulos ipako de ta kudos. Sakay mabuhay siya ta ikatélo a aldew. Kanya éwan se siya,” kagi du éduwa, “da nabuhay dén!” ");
INSERT INTO dgc_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Nadid, pékabati du bébe ta éya, éy naala-ala de dén tu kinagi ni Jesus dide ta Galilea. ");
INSERT INTO dgc_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ey nagsoli dén side, a inumange side nagbaheta du iba a alagad ta nanyaria dide to lébéng. ");
INSERT INTO dgc_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Diden ya a bébe, éy ti Maria Magdalena, sakay ti Juana, sakay ti Maria a ina ni Santiago, sakay du kaguman de a iba a bébe. ");
INSERT INTO dgc_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pero du apostol a binahetaan de, éy akala de éy kabulyan san, kanya éwan side naniwala du bébe. ");
INSERT INTO dgc_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pero ti Pedro, éy inumégkat siya a tulos minaginan siya to lébéng a inentan. Ey kédemét na to lébéng, éy niseleg na tu lubuk, éy i neta na sana sa éy basta tu sapot na. Ey nagsoli dén siya nadid to bile de, a mégisip-isip siya éng anya i nanyaria. ");
INSERT INTO dgc_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nadid, ta éya a mismo a aldew, éy naglakad i éduwa a alagad ta Bariyo Emaus, a ikaadeyo na ta Jerusalem éy manga sapulu a kilometro. ");
INSERT INTO dgc_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ey to péglakad de, éy péguhunan de i nabaheta de a nanyari. ");
INSERT INTO dgc_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ey nadid, to péguhon de a éduwa, éy inabut side ni Jesus a kinumuyog siya dide a naglakad; ");
INSERT INTO dgc_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","pero éwan de natenggi siya. ");
INSERT INTO dgc_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ey pinakelagipan na side éng anya i péguhunan dia. Ey hinumintu side, a mélungkut a tahod i mudet dia. ");
INSERT INTO dgc_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ey kinagi no esa, a ti Kleopas i ngahen na, a “Anya gébwat ka ta Jerusalem, éy éwan mo bale nabaheta tu nanyari ta éya to esa a aldew?” ");
INSERT INTO dgc_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","“Ey anya i nanyaria?” kagi ni Jesus. Ey kinagi du éduwa, a “Te lélake a pinaange se na Diyos, a ti Jesus i ngahen na, a taga Nasaret. Ey purupeta siya,” kagi de. “Ey mahal siya na Diyos sakay du tolay, da makapangyarian tu pégtoldu na, sakay tu ginamet na du tolay éy makapangyarian pati. ");
INSERT INTO dgc_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Pero du mataas a padi,” kagi de, “sakay du tagapamahala, éy dinikép de siya sakay nitugén de ta gubernador a nipabuno. Sakay nipako de siya to kudos. ");
INSERT INTO dgc_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","“Pero sikame,” kagi de, “éy inumasa kame diya, da akala me a siya tu mangtubus dikitam a Israel du kalaban tam a taga Roma. Pero besa ina. Da nadid éy ikatélo na dén a aldew sapul to nipangbuno de. ");
INSERT INTO dgc_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ey nadid, i pégtakaan mia,” kagi de, “éy tu nibaheta dikame du kaguman me a bébe. Binisita de kan tu lébéng to gagabi se. ");
INSERT INTO dgc_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Pero éwan kan sa tu bangkay. Ey to késoli du bébe dikame, éy kinagi de a pinumeta kan dide i éduwa a anghel, a kinagi de kan a nabuhay dén siya. ");
INSERT INTO dgc_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Kanya du kaguman me a iba, éy inange de inentan tu lébéng, éy dinemtan de ngani a éwan dén tu lasén, pero éwan de neta ti Jesus.” ");
INSERT INTO dgc_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Nadid, kinagi ni Jesus to éduwa, a “Ayhay, bakit kulang i isip du tolay! Bakit mégalanganin kam a méniwala to nisulat du purupeta to araw! ");
INSERT INTO dgc_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ewan moy nabati a kailangan a mate i Cristo ta kona sa, bagu siya maghari ta mundua?” ");
INSERT INTO dgc_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Nadid, tulos ni Jesus a néngipaliwanag dide ta étanan a kagi ta kasulatan na Diyos a tungkul diya. Nitoldu na dide sapul ta libru ni Moises, a hanggan ta kasulatan du purupeta. Pero éwan de pabi natenggi a ti Jesus siya. ");
INSERT INTO dgc_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nadid, kéadene du éduwa a alagad to bariyo a angayan de, éy nagwari-wari ti Jesus a magtulos. ");
INSERT INTO dgc_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pero tu éduwa, éy ginipos de siya, a kinagi de, a “Matidug kitam pa se, da apon dén.” Kanya tinumulos ti Jesus dide. ");
INSERT INTO dgc_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ey to péngan de, éy inalap ni Jesus tu tinapay, a nagpasalamat ta Diyos. Sakay pinuseng-puseng na, a niatéd na du kaguman na a éduwa. ");
INSERT INTO dgc_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ey nadid, bigla de a natenggi siya! Pero siya, éy basta linompés ta harapan dia. ");
INSERT INTO dgc_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","“Kanya bale éy nagtaka kita a nasahat kita tu isip,” kagi de, “to nipagpaliwanag na dikita to péglakad tam to dilan!” ");
INSERT INTO dgc_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nadid, éy inumégkat side agad, a nagsoli side ta Jerusalem. Ey kédemét de du alagad a napisan sa, ");
INSERT INTO dgc_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","éy kinagi du alagad dide, a “Nabuhay ngani dén tu Panginoon! A pinumeta dén siya ni Pedro!” ");
INSERT INTO dgc_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ey “O, ngani,” kagi du éduwa, “mineta me be dén siya.” Ey tulos de a nibaheta dide i nanyaria dide to dilan, a “Bagu me siya natenggi,” kagi de, “éy to pémuseng na to kanén me a tinapay.” ");
INSERT INTO dgc_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Nadid, to péguhon de pabi ta éya, éy bigla a te taknég ti Jesus ta bélog dia, tulos kinagi na dide, a “Mapayapa kam dén.” ");
INSERT INTO dgc_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ey du alagad, éy kinumégtot side a inumanteng, a akala de éng bélet. ");
INSERT INTO dgc_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ey kinagi ni Jesus dide, a “Bakit méganteng kam? Bakit kulang pabi i péniwala moya? ");
INSERT INTO dgc_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Entan moy i kamét kua sakay na tikéd kua, a te talingo dén. Sakén dén ye. Nay,” kagi na, “kébilanék moy, a buhayék dén. Ewanék bélet,” kagi na, “da te bégiék.” ");
INSERT INTO dgc_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ey to pégkagi ni Jesus ta éya, éy nipeta na dide tu kamét na sakay na tikéd na. ");
INSERT INTO dgc_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ey du alagad, éy basta natilihan side, a mégisip-isip side éng méniwala, o éng éwan. Ey nasahat side ta dikél. Ey nadid kinagi ni Jesus dide, a “Te ipakan kam diyakén?” ");
INSERT INTO dgc_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ey inatdinan de to nituno de a ikan. ");
INSERT INTO dgc_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ey kinan na to harap de. ");
INSERT INTO dgc_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ey tulos kinagi na dide, a “Ewan moy natandaan tu kinagi ko dikam to éya, a kailangan a matupad i étanan a nipesulat na Diyos to araw a tungkul diyakén--i édse ta kautusan ni Moises, sakay ta libru du purupeta, sakay ta libru na Manga Kanta.” ");
INSERT INTO dgc_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ey nadid, tulos ni Jesus a nipaliwanag dide i kasulatan na Diyos. ");
INSERT INTO dgc_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","“Saye tu nisulat du purupeta to araw,” kagi na, “a kailangan a mate tu tiniyak na Diyos a tagapagligtas ta mundua, sakay tulos mabuhay siya a huway ta ikatélo a aldew. ");
INSERT INTO dgc_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ey nisulat de be,” kagi ni Jesus, “a ta pamag-itan no ngahen ni Cristo, éy mepahayag ta Jerusalem, a hanggan ta étanan a mundu, a pagpasensiyaan na Diyos i maski ti ésiya a tolay, éng magsisi siya, a ibutan na i kasalanan na. ");
INSERT INTO dgc_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ey sikam i magpatunaya ta étanan a éya a nanyari. ");
INSERT INTO dgc_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ey sakén a mismo,” kagi ni Jesus du alagad na, “éy paangen ko dikam tu Banal a Espiritu a nipangako dikam Nama ko. Pero maguhay kam pa ta Jerusalemae, a hanggan padibién ko dén siya dikam, da siya i mangatéda dikam ta kapangyarian moy a gébwat ta langet.” ");
INSERT INTO dgc_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Nadid, éy niange ni Jesus du alagad na ta luwas na banuwan, a hanggan ta Betania. Ey ta éya, éy niontok na tu kamét na, a nipanalangin na side. ");
INSERT INTO dgc_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ey pénalangin na pabi, éy inumadeyo siya dide, a inumontok dén ta langet. ");
INSERT INTO dgc_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ey du alagad, éy nagpagsoli dén side ta Jerusalem, a mésahat dén side diya. ");
INSERT INTO dgc_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ey ta éya, éy kéya side a palagi to Templo, a mégpépasalamatén side ta Diyos. ");
INSERT INTO dgc_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","To araw, bagu nilalang i mundua éy édsa dén tu ngéngahinan de a kagi na Diyos. Kaguman siya na Diyos, sakay pati éy Diyos ngani dén siya. ");
INSERT INTO dgc_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Sapul to sapul éy édse siya ta Diyos. ");
INSERT INTO dgc_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Pinaglalang siya na Diyos ta étanan. Maski anya a nilalang, éy siya i naglalanga. ");
INSERT INTO dgc_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Nadid, siya a ngéngahinan de a kagi na Diyos, éy saya i kégébwatan na buhay tama. Sakay siya i nagpaliwanag ta isip na tolay. ");
INSERT INTO dgc_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","I Demlag na Diyos, éy pademlagén na i diklém. I diklém éy éwan makadaig ta Demlag na Diyos. ");
INSERT INTO dgc_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Nadid, te lélake a inutusan na Diyos, a ti Juan i ngahen naa. ");
INSERT INTO dgc_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Pinaange na ti Juan du tolay, a monda ipahayag na dide i ngéngahinan tam a Demlag, monda maniwala side diya a étanan. ");
INSERT INTO dgc_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Bakén a ti Juan i Demlag; éngˈwan, i tungkulin naa éy ipahayag na du tolay i Demlag. ");
INSERT INTO dgc_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","I tunay a Demlag éy ti Jesu Cristo a dinumibi ta mundua a magpaliwanag ta isip na tolay. ");
INSERT INTO dgc_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nadid, nilalang ni Jesus i mundua. Pero to pégiyan na ta mundua, éy éwan siya tukoy na tolay, maski siya i naglalanga dide. ");
INSERT INTO dgc_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Inumange siya to sarili na a banuwan, pero du kabébayan na a Judeo, éy éwan de siya tinanggap. ");
INSERT INTO dgc_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pero du nananggap diya, a méniwala side diya a talaga, éy ginimet na side a maging anak side na Diyos. ");
INSERT INTO dgc_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ey pakodyan de a naging anak na Diyos? Nienak wade side a huway na bébe, ayun ta plano na tolay? Ewan! Da Diyos ngani dén i Ama dia. ");
INSERT INTO dgc_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Kanya nadid, tu ngéngahinan de a kagi na Diyos, éy naging tolay siya a négiyan dikame. Siya éy ti Jesus. Ey mebait siya, a katutuhanan i kagi naa. Ey sikame éy neta me i pagkadiyos na. I pagkadiyos na éy makapangyarian, da siya i isi-isesa a anak na Diyos. ");
INSERT INTO dgc_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Nipahayag siya ni Juan, a kinagi na du tolay, a “Siya ya tu kinagi ko dikam to éya, a te dumemét se a lélake a ménegipo diyakén a kalewas ko. Mataas siya diyakén,” kagi ni Juan, “da baguék nienak, éy buhay dén siya.” ");
INSERT INTO dgc_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nadid, da mahal na kitam a tahod, éy mebait siya dikitam a palagi, a kagbian na kitam. ");
INSERT INTO dgc_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","To araw éy inatdinan ni Moises du tolay ta utus na Diyos. Pero nadid éy inatdinan kitam ni Jesu Cristo ta kagbi na Diyos, sakay nipaliwanag na dikitam i katutuhanan. ");
INSERT INTO dgc_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ewan tu naketa ta Diyos, maski nikésiya. Basta tu anak na a isi-isesa, a kaguman Nama na a Diyos, éy siya i nagpahayaga diya. ");
INSERT INTO dgc_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Nadid ti Juan, éy nagbinyag siya du tolay ta Betania. Ey du tagapamahala a Judeo ta Jerusalem, éy kinagi de du padi, a “Ange moy pakelagipan ti Juan éng ti ésiya siya, éng siya i tagapagligtas ta tolay.” ");
INSERT INTO dgc_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ey nagtapat ti Juan dide. “Besa a sakén i tiniyak na Diyos a tagapagligtas,” kagi na. ");
INSERT INTO dgc_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","“Ey nadid.” kagi de, “éng éwan siko i tagapagligtas, éy ti ésiya ka? Ti Elias ka?” Ey “Ewan,” kagi ni Juan. “Ey siguru siko i mahalaga a purupetana Diyos?” Ey “Ewan be,” kagi na. ");
INSERT INTO dgc_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","“Ey ti ésiya ka,” kagi de. “Kagin pad dén, a monda te ikagi kame du nagpaange se dikame diko. Anya ka, da mégtoldu ka ta kona sa?” ");
INSERT INTO dgc_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Nadid, kinagi ni Juan, éy “Ewan moy naala-ala tu nihula ni Purupeta Isaya to araw? I nihula na, éy te dumemét kan a lélake a magpahayag ta ilang a lugar, a i kagi na kan du tolay, a dapat husayén de i péglakaden na Panginoon. Ey nadid, sakén i éya a lélake a nihula na.” ");
INSERT INTO dgc_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Nadid du Pariseyo, éy side i nagutusa dide a inumange ni Juan a nagpakelagip. ");
INSERT INTO dgc_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ey kinagi de ni Juan, éy “Nadid, éng besa ka tu tagapagligtas, éng besa ka be a ti Elias, sakay besa ka tu purupera na Diyos, éy bakit mégbinyag ka ta tolay?” ");
INSERT INTO dgc_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","“Sakén” kagi ni Juan, “éy binyagen ko i tolay ta dinom. Pero te lélake a esa ta éye a éwan moy tukoy. ");
INSERT INTO dgc_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Siya, maski ménegipo diyakén a dumemét, éng iparehoék moy diya, éy éwanék tu pasa, da mataas siya diyakén.” ");
INSERT INTO dgc_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","I éya éy nanyari ta Betania, ta dibilew na Hordan. ");
INSERT INTO dgc_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Nadid, to kagagabian na éya, éy neta ni Juan ti Jesus a tamo diya. Péketa na diya, éy kinagi na du tolay sa, a “Entan moy, siya ina i bilang tupa na Diyos. Siya i magibuta ta kasalanan na tolay ta mundua. ");
INSERT INTO dgc_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Siya ina tu kinagi ko dikam to éya a te dumemét se a lélake a ménegipo diyakén a kalewas ko. Mataas siya diyakén, da baguék nienak, éy buhay dén siya. ");
INSERT INTO dgc_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Maski sakén,” kagi ni Juan, “to ditol éy éwan ko be tukoy éng ti ésiya i tagapagligtas. Pero i tungkulin ko éy binyagen ko i tolay ta dinom a monda mepahayag dén siya ta Israel.” ");
INSERT INTO dgc_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Nadid, nipahayag ni Juan ti Jesus a huway ta kona se: “Bagu ko napospusan éng ti ésiya siya,” kagi na, “éy inutusanék na Diyos a magbinyag ta tolay. Sakay pati, éy kinagi na Diyos diyakén a meta ko i Espiritu na a dumibi to esa a lélake a tulos na umapon diya. Ey kinagi be na Diyos diyakén a siya éy binyagen na du tolay ta Banal a Espiritu.” “Nadid,” kagi ni Juan, “to esa a aldew éy nanyari tu kinagi na Diyos diyakén, a mineta ko i Espiritu na Diyos a dinumibi a gébwat ta langet a koman i dagalan. Ey tulos na inumapon ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ey nadid,” kagi ni Juan, “da mineta ko dén i éya éy sakén dén i magpatunaya dikam a siya ya a talaga i isi-isesa a anak na Diyos.” ");
INSERT INTO dgc_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Nadid, to kagagabian na éya, éy kaguman man dén ni Juan tu éduwa a alagad na. ");
INSERT INTO dgc_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ey to péketa de ni Jesus a sumalegéd, éy kinagi ni Juan du éduwa, a “Entan moy, siya ina i bilang tupa na Diyos!” ");
INSERT INTO dgc_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ey tu éduwa a alagad ni Juan, pékabati de ta éya, éy tinumagubet side ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ey ti Jesus, to késuleg na éy neta na side a tumétagubet diya. Ey kinagi na dide, a “Anya i gustu moya?” Ey “Maistu,” kagi de, “ahe i tulusan mua?” ");
INSERT INTO dgc_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","“Ey kumuyog kam,” kagi na, “éy meta moy.” Kanya kinumuyog side ni Jesus, a mineta de tu tinulusan na a bile. Ey tinumulos be sa side, da apapon dén. ");
INSERT INTO dgc_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Nadid, tu ngahen na esa dide éy ti Andres a wadi ni Simon Pedro. ");
INSERT INTO dgc_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Kanya ti Andres, éy inuwet na agad teka na, a kinagi na diya a “Kadon dén, mineta me dén tu Cristo.” (Séya i pégngahen du Judeo to lélake a éuhayén de a tiniyak kan na Diyos a tagapagligtas dide.) ");
INSERT INTO dgc_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Nadid, tulos niange ni Andres tu aka na ni Jesus. Ey péketa ni Jesus diya, éy kinagi na, a “Ti Simon ka kan, a anak ni Juan. Pero sapul nadid, i pégngahen mia diko éy Kepas.” (I kahulugen na éya, éy Pedro, sakay i kahulugen na a esa éy bito.) ");
INSERT INTO dgc_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Nadid, to kagagabian na éya éy naisipan dén ni Jesus a umange ta Galilea. Ey to péglakad na éy neta na ti Pelip. Ey kinagi na diya, a “Kumuyoyog ka diyakén a maging alagad ko.” ");
INSERT INTO dgc_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ti Pelip éy taga Betsayda. Siya be ya i banuwana de Andres a patwade. ");
INSERT INTO dgc_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Nadid ti Pelip, éy inange na ti Natanel, a kinagi na diya, a “Natanel, natandaan mo tu hinulaan du purupeta sakay ti Moises to pénulat na ta utus na Diyos, a te tagapagligtas kan a dumemét dikitam? Mineta me dén siya a talaga! Ti Jesus,” kagi na, “i ngahen na, a anak ni Hose a taga Nasaret.” ");
INSERT INTO dgc_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","“Ataay,” kagi ni Natanel, “te mégébwat bale be a mahusay a lélake ta éya a kétihék a banuwan na Nasaret?” “O,” kagi ni Pelip; “kadon, angen ta entan.” ");
INSERT INTO dgc_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nadid, péketa ni Jesus ni Natanel a gébék diya, éy kinagi na du édsa sa, a “Entan moy, i lélake a ina éy tunay a Judeo, a matapat siya.” ");
INSERT INTO dgc_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ey ti Natanel, pékabati na ta éya, éy kinagi na ni Jesus, a “Ta aheék mo a napospusan?” “Bagu ka inange ni Pelip,” kagi ni Jesus, “éy neta ta ka dén a te salendum to kayo.” ");
INSERT INTO dgc_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","“Mégtakaék,” kagi ni Natanel. “Méniwalaék dén a siko ngani dén i isi-isesa a anak na Diyos! Siko i hari mia ta Israel a talaga!” ");
INSERT INTO dgc_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","“Kanya ka wade san naniwala diyakén,” kagi ni Jesus, “éy dahilan to kinagi ko diko a neta ta ka dén a te salendum to kayo. Pero meta mo i lalo a kataka-taka ta esa a aldew. ");
INSERT INTO dgc_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Tandaan moy,” kagi ni Jesus, “meta moy i langet a bumukas a tulos du anghel a dumibi diyakén, sakay meta moy be side a umontok a gébwat diyakén. Sakén i lélake a gébwat ta langet.” ");
INSERT INTO dgc_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Nadid, kélipas na éduwa a aldew, éy te kasal ta Bariyo Kana ta Galilea. Ey édsa sa tu ina ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ey kéya be sa ti Jesus sakay du alagad na, a kinombida sa side. ");
INSERT INTO dgc_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Nadid, to pégkasayaan de pabi, éy naubus dén tu alak. Ey kinagi no ina ni Jesus diya, a “Naubus dén tu alak.” ");
INSERT INTO dgc_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","“Diyanék mo utusan, Inéng,” kagi na. “Ewan pabi oras a ipeta ko i kapangyarian ko.” ");
INSERT INTO dgc_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Nadid, kinagi no ina na du bataan sa, a “Sundin moy i maski anya a kagi na dikam.” ");
INSERT INTO dgc_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Nadid, te éném sa a tapayan a méglasén side ta manga téglélima a baldi. Side ya i hinanda du Judeo a pagugisan, ayun ta rilihiyon de. ");
INSERT INTO dgc_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ey kinagi ni Jesus du bataan sa, a “Putatén moy side ta dinom.” Ey pinutat de side. ");
INSERT INTO dgc_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Nadid, kinagi ni Jesus dide, a “Nay, isalduk moy i sénganya, a kébilén moy ta namamahala ta kasalae.” Ey sinunud de tu kinagi ni Jesus dide. ");
INSERT INTO dgc_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Nadid, tu namamahala to kasal, éy kinenaman na tu dimom, éy alak bale dén. Ey éwan na be tukoy éng ahe i gébwata na éya a alak. Basta du bataan a nagsalduk i nakapospusa. Kanya tu namamahala, éy dinulawan na tu lélake a kékasalén, ");
INSERT INTO dgc_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","a kinagi na diya, a “Bakit, isip ko ugali na tolay a iditol de pa a ipenom du kombidadu de tu memahal a kalase a alak? Nadid, bagay nakainom dén side, éy iluwas na dide tu alak a mehina. Pero siko éwan, da nadid mo san iluwas tu memahal a alak!” ");
INSERT INTO dgc_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","I éya a ginimet ni Jesus ta Kana, éy sáya i purumeru a gimet na a makataka-taka. Nagpatunay siya du tolay ta éya ta pagkadiyos na. Ey du alagad na, éy naniwala dén side a siya i tiniyak na Diyos a tagapagligtas du Judeo. ");
INSERT INTO dgc_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Nadid, kétapos na éya, éy inumange de Jesus ta Kapernaum. Kaguman na tena na, sakay du tétotop na sakay du alagad na. Ey tinumulos sa side ta sénganya a aldew. ");
INSERT INTO dgc_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Nadid, kédemét na piyesta na Judeo, éy inumange ti Jesus ta Jerusalem. I ngahen na éya a piyesta éy Piyesta na Ala-ala. ");
INSERT INTO dgc_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Kédemét na ta Jerusalem, éy sinomdép siya ta Templo. Ey to késdép na, éy neta na sa i tolay a mégtinda-tinda, a iyébugtong de i baka sakay tupa sakay palapati. Sakay neta na be sa du mégpalit ta kuhata. ");
INSERT INTO dgc_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ey naglubid ti Jesus ta pégyabat na, a tulos na side a étanan a nitabuy ta luwas na Templo. Pati du tupa sakay baka éy nitabuy na be side. Sakay du lamesa du mégpalit ta kuhata, éy binalibaleksad na side a tulos nesapwah dén tu kuhata de. ");
INSERT INTO dgc_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Sakay kinagi na du méngibugtong ta palapati, a “Nay, paluwasén moy se side. Bakit, gemtém moy beman a palengke i Bileae Nama ko?” ");
INSERT INTO dgc_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Nadid, du alagad ni Jesus, péketa de ta éya, éy naala-ala de tu nisulat ni Dabid to araw, a i kagustuan na kana ta Bile na Diyos, éy saya i kaanyaan na kan. ");
INSERT INTO dgc_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Nadid, du mataas a Judeo, éy inumange side ni Jesus a kinagi de, a “Anya i ipeta mo dikame a kataka-taka, monda meta me éng te kapangyarian ka a nagpaibut du tolay ta Templo?” ");
INSERT INTO dgc_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","“Hukatén moy i Templua,” kagi na, “éy pataknégén ko a huway ta étélo san a aldew.” ");
INSERT INTO dgc_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ey “Areh!” kagi du Judeo. “Du neditol a nagpataknég ta Templua, éy épat a pulu éy ta éném a taon a nagtarabaho side! Ey siko, isip mo beman éy mapataknég mo san ta étélo san a aldew?” ");
INSERT INTO dgc_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ewan tukoy du Judeo a nihalimbawa san ni Jesus dide tu Templo. Pero bégi na san i kinagi naa dide. ");
INSERT INTO dgc_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Nadid, to nikébuhay ni Jesus to ikatélo a aldew, éy nala-ala dén du alagad na tu kinagi na a éya. Ey naniwala side diya, sakay naniwala be side ta kasulatan na Diyos. ");
INSERT INTO dgc_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Nadid, to Piyesta na Ala-ala, éy meadu ta Jerusalem a naniwala ni Jesus, a siya i tagapagligtas dide, da neta de i ginimigimet na a kataka-taka. ");
INSERT INTO dgc_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pero ti Jesus, éy éwan siya nagkatiwala dide, da tukoy na dén side a étanan. ");
INSERT INTO dgc_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ewan siya tu kailangan ta magbaheta ta ugali na tolay diya, da tukoy na dén i isip na tolay a maski ti ésiya. ");
INSERT INTO dgc_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nadid, te esa a lakay a namamahala du Judeo, a ti Nikodemo i ngahen na. Sakup siya na rilihiyon a ngéngahinan de a Pariseyo. ");
INSERT INTO dgc_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","To esa a kélép, éy inumange siya ni Jesus a nékiohon. “Maistu,” kagi na, “napospusan me a maistu ka a gébwat ta Diyos, da éwan ka makagimet ta gégemtén mua a memahal éng éwan édse diko i Diyos.” ");
INSERT INTO dgc_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ey kinagi nadid ni Jesus to lakay, a “Tandaan mo: éng éwan ienak i tolay a huway, éy éwan siya maari a ipasakup ta kaharian na Diyos.” ");
INSERT INTO dgc_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","“Ey kodya i péngienaka ta matanda dén a tolay a huway?” kagi ni Nikodemo. “Makasdép wade siya ta tiyana nena na a monda ienak a huway?” ");
INSERT INTO dgc_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","“Tandaan mo,” kagi ni Jesus, “éng éwan ienak i tolay ta dinom sakay ta Espiritu na Diyos, éy éwan siya makasdép ta kaharian na Diyos. ");
INSERT INTO dgc_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Tu ienak ta tolay, éy meaheg ta tolay, sakay tu ienak ta Espiritu na Diyos, éy meaheg ta Diyos. ");
INSERT INTO dgc_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Diyan ka mégtaka to kinagi ko diko a kailangan a ienak i tolay a huway. ");
INSERT INTO dgc_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Mara i pahés, éy mabati mo, pero éwan mo tukoy i kégébwatan na sakay ta angayan na, da méglebut siya ta maski ahe. Nadid, éy kona be sa i tolay a ienak ta Espiritu na Diyos, a éwan mo be tukoy éng kodya.” ");
INSERT INTO dgc_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ey kinagi ni Nikodemo, a “Kodya a manyari i éya?” ");
INSERT INTO dgc_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ey “Anya,” kagi ni Jesus, “isip ko matalinung ka a maistu ta Israel, pero éwan mo beman tukoy tu kinagi ko? ");
INSERT INTO dgc_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Tandaan mo; tu napospusan me sakay tu mineta me, éy ibaheta me dikam a talaga. Pero sikam, éy éwan kam méniwala ta kagi mia. ");
INSERT INTO dgc_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nadid, éng éwan kam méniwala to kinagi ko dikam tungkul ta munduae, éy pakodyan moy a maniwala éng ibaheta ko dikam i manyaria tungkul ta langet? ");
INSERT INTO dgc_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Entan mo, éwan tu tolay ta mundua a maski ti ésiya a gébwat ta langet, éng éwan sakén san a ngéngahinan de a lélake a gébwat ta langet.” ");
INSERT INTO dgc_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Mara ti Moises to araw, to pégiyan de ta ilang a lugar, éy nagimet siya ta ulag a tanso, a niekpét na to kayo a te tolnék. Nadid, éy kona be sa i lélake a gébwat ta langet, a iekpét de be siya ta te tolnék a kayo, ");
INSERT INTO dgc_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","a monda maski ti ésiya a tolay a méniwala diya, éy mabuhay siya a éwan tu katapusan. ");
INSERT INTO dgc_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Mahal na Diyos a tahod i tolay ta mundua. Kanya pinaange na se tu anak na a isesa, monda maski ti ésiya i maniwalaa diya, éy éwan mate, éng éwan mabuhay a éwan tu katapusan. ");
INSERT INTO dgc_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ewan pinaange na Diyos tu anak na ta mundua a maghukum ta tolay, éngˈwan magligtas ta tolay. ");
INSERT INTO dgc_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Kanya nadid, maski ti ésiya a méniwala ta anak na Diyos, éy éwan siya hukumén na Diyos. Pero tu éwan méniwala éy mahukum dén, da éwan side méniwala ta isesa a anak na Diyos, a ti Jesu Cristo. ");
INSERT INTO dgc_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Nadid, inumange dén ta mundua i Demlag a ti Jesu Cristo. Pero inidelan siya du tolay. Gustu du tolay i diklém kesira ta demlag, da medukés i gimet dia. Kanya hukumén side na Diyos. ");
INSERT INTO dgc_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Dahilan i maski ti ésiya a mégimet ta medukés, éy sala de i demlag. Umadeyo side ta demlag da gustu de éwan meta i gimet de a medukés. ");
INSERT INTO dgc_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pero side a te gimet ta tama, éy umadene side ta Demlag, monda meta dén i gimet de, a ayun ta kaluuben na Diyos. ");
INSERT INTO dgc_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Nadid, kétapos na éya, éy inumange de Jesus sakay du alagad na ta Hudea. Négiyan sa side ta esa a panahun, a nagbinyag side ta tolay. ");
INSERT INTO dgc_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","I éya a panahun, éy panahun pabi ni Juan a mégbinyag, da éwan de pabi nipihesu. Ey édsa nadid ti Juan ta Enon, a mégbébinyagén sa siya du tolay, da meadu sa i dinom (adene i Enon ta Salim). Ey meadu i dumédulug sa diya a nipabinyag. ");
INSERT INTO dgc_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Nadid, du alagad ni Juan sakay tu esa a Judeo, éy négpasuway side tungkul ta pégbinyag ni Juan sakay ta pégbinyag ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Kanya inumange side ni Juan, a kinagi de diya, a “Maistu, anya tu kaguman mo a lélake to éya ta dibelew na Hordan, siya a nipahayag mo? Mégbébinyagén kan dén siya nadid ta tolay, éy meadu kan be diya a dumédulug. Bakit?” ");
INSERT INTO dgc_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","“Ewan,” kagi ni Juan du alagad na. “Tama tu gimet na. Tandaan moy, maski ti ésiya a te kapangyarian, éy Diyos i méngatéda diya. ");
INSERT INTO dgc_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ewan moy naala-ala tu kinagi ko dikam? Tu kinagi ko, éy besa a sakén i tiniyak na Diyos a tagapagligtas, éngˈwan, inutusanék san na Diyos a mégdetol diya, a paghandaén ko du tolay ta demtan na. ");
INSERT INTO dgc_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mara tu bébe a kasalén,” kagi ni Juan, “ti ésiya i te kooa sa, tu lélake a mangasawa o tu bukabli na? Tu lélake a mangasawa, siya i te koo to bébe. Tu bukabli na, éy masaya siya éng meta na side a nagagum dén. Nadid, kona be sa sakén,” kagi ni Juan. “Masayaék be éng meta ko du tolay a umange ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ti Jesus, éy maging tanyag siya a éwan tu katapusan. Pero sakén, éy malipas be san i kétanyag kua.” Saya tu kinagi ni Juan du alagad na. ");
INSERT INTO dgc_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Siya a gébwat ta langet, éy siya i mataasa. Siya a édse ta mundua, éy mégtoldu siya ta tungkul ta édse ta mundua, da séˈ san ya i kinatobuan na a lugar. Ti Jesus a gébwat ta langet, éy siya i mataasa. ");
INSERT INTO dgc_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Mégbaheta siya ta neta na éy ta nabati na, pero éwan méniwala du tolay ta kagi naa. ");
INSERT INTO dgc_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Pero side a méniwala a talaga ta kagi ni Jesus, éy side i mégpatunaya a katutuhanan i Diyos. ");
INSERT INTO dgc_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tu pinaange se na Diyos a ti Jesus, éy siya i mégkagia ta kagi na Diyos, da inatdinan siya na Diyos ta Espiritu na. ");
INSERT INTO dgc_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Mahal na Diyos tu anak na a Jesus, a inatdinan na siya ta étanan, a siya dén i te kapangyarian. ");
INSERT INTO dgc_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nadid, maski ti ésiya a méniwala ta anak na Diyos, éy mabuhay siya a éwan tu katapusan. Pero side a éwan sumunud to anak na, éy éwan de kamtan i buhay a éwan tu katapusan, éngˈwan, basta manatili dide i parusa na Diyos. ");
INSERT INTO dgc_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Nadid, du Pariseyo éy nabaheta de a bébinyagen kan ni Jesus i mas meadu a tolay kesira ni Juan. Sakay nabaheta de be a te mas meadu kan a tolay a nipasakup diya, kesira ni Juan. ");
INSERT INTO dgc_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Pero éwan ti Jesus a mismo i mégbinyaga du tolay, éngˈwan du alagad na san. ");
INSERT INTO dgc_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Kanya ti Jesus, pékabaheta na ta éya, éy gininanan na i Hudea a nagsoli siya ta Galilea. ");
INSERT INTO dgc_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ey to péglakad na, éy dinumiman pa siya ta Samaria. ");
INSERT INTO dgc_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ey to péglakad de ta éya éy dinumemét side ta banuwan na Sikar. Adene i Sikar to luta a niatéd ni Hakob to anak na a Hose to araw. ");
INSERT INTO dgc_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ey édsa be sa tu medisalad a bal-ong a kinotkotan kan ni Hakob to araw. Kédemét sa de Jesus, éy tanghali dén tu bilag. Ey inumeknud sa siya a inumimang, da napagel. ");
INSERT INTO dgc_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Du alagad na, éy tinumulos side ta banuwan a mamugtong ta kanén de. Ey, kéimang ni Jesus to bal-ong, éy te dinumemét sa a Samaritano a bébe a sumagéb. Ey kinagi ni Jesus diya, a “Penuménék mo.” ");
INSERT INTO dgc_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Tu bébe, pékabati na a mékiohon ti Jesus diya, éy nagtaka, da du Judeo, éy idel de a mékiohon du Samaritano. “Bakit,” kagi na, “mékienom ka diyakén éy Judeo ka, éy sakén éy Samaritanoék?” ");
INSERT INTO dgc_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ey kinagi ni Jesus diya, “Eng tukoy mo i iatéda na Diyos ta tolay, sakay éng tukoy mo be i mékienuma diko, éy siko maka i mékienuma diyakén. Ey atdinan ta ka maka dén ta dinom a makabuhay.” ");
INSERT INTO dgc_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","“Ey ahe i pangalapan mua ta dinom a makabuhay?” kinagi no bébe. “Ewan ka be tu pégsalduk, éy medisalad pati i balo-ongae. ");
INSERT INTO dgc_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Tu apo tam a Hakob,” kagi na, “éy saye i enuman naa, pati du anak na sakay du baka na to araw. Saye i niatéd naa dikitam a dinom. Anya, isip mo mataas ka diya, a mahusay tu dinom mo ta dinumae?” ");
INSERT INTO dgc_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ey kinagi ni Jesus, a “Du uminom ta dinom ta bal-ongae, éy mégeplék side a huway. ");
INSERT INTO dgc_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pero tu iatéd ko a dinom, éy saya i buhay a éwan tu katapusan. Ey maski ti ésiya i uminom ta éya, éy éwan siya mageplék a huway, maski nikésiya, da édse diya a palagi, a koman i bukal a éwan katian.” ");
INSERT INTO dgc_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","“Ey atdinanék pad ta kona sa a dinom,” kagi no bébe, “monda éwanék mageplék a huway, monda éwanék tu kailangan a sumagéb.” ");
INSERT INTO dgc_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ey “Nay,” kagi ni Jesus, “ikad mo dén a angen mo tu asawa mo, a soli kam se agad.” ");
INSERT INTO dgc_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","“Ey éwanék tu asawa,” kinagi no bébe. “Ah,” kagi ni Jesus, “katutuhanan a talaga tu kagi mo. ");
INSERT INTO dgc_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Da lima dén tu inasawa mo a lélake. Sakay pati tu mékiagum diko nadid, éy besa a asawa mo.” ");
INSERT INTO dgc_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","“Anin,” kagi no bébe, “purupeta ka bale! ");
INSERT INTO dgc_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Anya wade, Amay; i pégsambaan du apo me ta Diyos to éya, éy ta bukidae. Pero sikam a Judeo, éy kagi moy a ta Jerusalem kan san i tama a pégsambaan tam ta Diyos?” ");
INSERT INTO dgc_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","“Ewan, Anéng,” kinagi ni Jesus. “Tandaan mo, dumemét i oras a éwan sumésamba i tolay ta Diyos ta bukidae. Pati ta Jerusalem, éy éwan de sa sésambaén. ");
INSERT INTO dgc_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Sikam a Samaritano, éy éwan moy tukoy i sésambaan moy. Pero sikame a Judeo, éy tukoy me i sésambaan me, da tu tagapagligtas ta tolay, éy Judeo siya. ");
INSERT INTO dgc_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ey nadid,” kagi ni Jesus, “dinumemét dén i oras a késamba na tolay ta Diyos ta katutuhanan ta isip dia, side a tunay a méniwala diya. Gustu na Diyos éy sambaén siya na tolay ta kona sa. ");
INSERT INTO dgc_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","I Diyos éy Espiritu, éwan siya tu bégi. Ey side a sumamba ta Diyos, éy kailangan éy sambaén de siya ta katutuhanan ta isip dia.” ");
INSERT INTO dgc_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Nadid, kinagi no bébe, a “Tukoy ko a ta esa a panahun, éy dumemét tu tiniyak na Diyos a tagapagligtas ta tolay, siya a ngéngahinan de a Cristo. Ey ta kédemét na, éy ipaliwanag na kan dikitam i étanan.” ");
INSERT INTO dgc_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","“Ey sakén a mégkagi diko.” kagi ni Jesus, “éy sakén ngani dén ye.” ");
INSERT INTO dgc_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Nadid, dinumemét du alagad ni Jesus a gébwat ta banuwan. Ey dinemtan de siya a mégkagi to bébe. Ey nagtaka side da mékiohon siya ta bébe. Pero mésanike side a mégpakelagip éng anya i éuhunén dia. ");
INSERT INTO dgc_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ey nadid, basta pinabayan no bébe tu iyésagéb na, a nagsoli ta banuwan. Ey kédemét na ta banuwan, éy nibaheta na du kabébayan na ti Jesus, a kinagi na, a ");
INSERT INTO dgc_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Kamon, ipeta ko dikam i lélake yae a mineta ko. Siya i nakatukuya ta étanan a ginamet ko sapul to kékétihék ko! Siguru siya i Cristo a tagapagligtas dikitam!” ");
INSERT INTO dgc_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Nadid, pékabaheta du tolay to kinagi no bébe, éy linumwas side a étanan a angen de entan ti Jesus. ");
INSERT INTO dgc_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Samantala du alagad ni Jesus, éy inakit de siya a méngan. ");
INSERT INTO dgc_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ey “Ewan,” kagi ni Jesus, “da te kanénék dén a éwan moy tukoy.” ");
INSERT INTO dgc_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Pékabati du alagad ta éya, éy négpakipakelagip side a kinagi de, a “Anya wade, te namakan wade diya to édse tam ta banuwan?” ");
INSERT INTO dgc_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ey “Ewan,” kagi ni Jesus, “i kanén kua, éy tupadén ko i kaluuben na nagpaangea se diyakén, a tapusén ko i patarabaho na diyakén. ");
INSERT INTO dgc_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Kagi moy a épat pabi a bulan bagu panahun na gapasan. Pero éwan,” kagi ni Jesus. “Entan moy, éwan moy meta a handa dén nadid i araduan yae a gapasén moy? Didi tolay ya a tamo dikitam, éy side ya i gapasén moya. ");
INSERT INTO dgc_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Entan moy, maski ti ésiya a magapas ta tolay a iange diyakén, éy atdinan ko siya ta gantimpala na. Sakay du ginapas na a tolay, éy abutén de i buhay a éwan tu katapusan. Nadid, tu méngimula ta kagi na Diyos ta isip na tolay, sakay tu mégapas, éy pareho side a masahat. ");
INSERT INTO dgc_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nadid éy katutuhanan tu kékagin na tolay, a mégmula kan tu esa, pero besa kan tu mégapas, ");
INSERT INTO dgc_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","da inutusan ta kam,” kagi ni Jesus, “a mégapas ta éwan moy nimula. Mara, i kahulugen na éya éy iba du néngibaheta ta kagi na Diyos ta tolay, pero sikam i méngiangea ta tolay diyakén.” ");
INSERT INTO dgc_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Nadid, te meadu a Samaritano ta éya a nániwala ni Jesus, dahil to kinagi no bébe dide, a “Natukuyan na i étanan a ginamet ko sapul to kékétihék ko.” ");
INSERT INTO dgc_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Kanya nékiohon du Samaritano ni Jesus a tumulos siya ta banuwan de. Ey négiyan sa siya ta éduwa a aldew. ");
INSERT INTO dgc_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ey lalo a meadu i naniwala, da nabati de tu pégtoldu na. ");
INSERT INTO dgc_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ey kinagi du Samaritano to bébe, a “Naniwala kame to purumeru dahil to kinagi mo. Pero nadid méniwala kame dén a talaga da nabati me be dén tu pégtoldu na. Tukoy me nadid a talaga ngani a siya i tagapagligtasa ta tolay ta mundua.” ");
INSERT INTO dgc_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Nadid, kélipas na éduwa a aldew, éy hinumektat de Jesus, a tamo side ta Galilea. ");
INSERT INTO dgc_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Kinagi ni Jesus a éwan iyégalang du tolay tu purupeta éng kabébayan de. ");
INSERT INTO dgc_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Nadid, kédemét de Jesus ta Galilea, éy tinanggap siya du tolay sa. Kanya tinaggap de, éy natandaan de tu ginégimet na ta Jerusalem to piyesta, da namiyesta be sa du tolay a taga Galilea. ");
INSERT INTO dgc_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ey sinumoli ti Jesus ta Kana. Saya i banuwan a pinagemtan na ta dinom a alak. Nadid, te lélake sa a te tungkulin a gébwat ta Kapernaum. Tu anak na ta éya éy méladu. ");
INSERT INTO dgc_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Pékabaheta no lélake a dinumemét sa ti Jesus, éy inumange sa a nékiohon diya. Gustu na a umange ti Jesus to bile de a manggamot to anak na a adene dén a mate. ");
INSERT INTO dgc_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ey kinagi ni Jesus diya, a “Ewan kam méniwala a talaga, éng éwan moy pa meta i kataka-taka a gimet.” ");
INSERT INTO dgc_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ey kinagi no te tungkulin, a “Kumuyog ka pad pa diyakén, Maistu, bagu mate tu anak ko.” ");
INSERT INTO dgc_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ey kinagi ni Jesus diya, “Ikad mo dén, mabuhay san ya tu anak mo.” Pékabati no te tungkulin ta éya, éy naniwala siya to kagi ni Jesus, a tulos na dén a naglakad. ");
INSERT INTO dgc_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ey to péglakad na pabi a tamo to bile de, éy sinambat siya du utusan na, a kinagi de diya, a “Mahusay dén tu anak mo!” ");
INSERT INTO dgc_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ey pinakelagipan na side éng nikésiya siya nagsapul a naghusay. Ey kinagi de a “To apon se a ala una, éy naibut tu palang na.” ");
INSERT INTO dgc_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ey naala-ala na dén a séˈ bale ya i orasa no pégkagi ni Jesus, a mabuhay tu anak na. Ey naniwala side a métatena ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Nadid, saya tu ikaduwa a gimet ni Jesus a makataka-taka sapul to kédemét na ta Galilea a gébwat ta Hudea. ");
INSERT INTO dgc_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Nadid, kétapos na éya, éy inumange ti Jesus ta Jerusalem, a mamiyesta. ");
INSERT INTO dgc_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Nadid, te diposito na dinom ta Jerusalem. I édsean na éy adene ta pintuan na banuwan a sésdépan na tupa. I pégngahen na Judeo ta dinuma a éya éy Betesda. Ey to digdig no dinom éy te lima a bile. ");
INSERT INTO dgc_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Saya i édseana du te ladu a tolay a meadu. Te buhék, te pile, sakay te lumpu. Mégéuhayén side ta ipaglimet-limet no dinom. ");
INSERT INTO dgc_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Dahilan éng mensan éy te anghel kan a dumibi to dinom a tulos na a maglimet-limet to dinom, éy maghusay kan tu meditol a tolay a lumogbut, maski anya i saket na. ");
INSERT INTO dgc_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Nadid, te lélake ta éya, a te ladu ta étélo dén a pulu a taon éy ta walu. ");
INSERT INTO dgc_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ey neta siya ni Jesus, éy tukoy na a nale dén siya a te katidug ta éya. Ey kinagi na diya, a “Gustu mo a maghusay ka?” ");
INSERT INTO dgc_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ey “O,” kagi no lélake, “pero éwan ko kaya, da éwan tu méngégkat diyakén a méngilogbut ta dinomae éng maglimet-limet. Da pinuhubaan ko dén, éy keditulanék be san du kaguman ko.” ");
INSERT INTO dgc_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ey “Nay,” kagi ni Jesus, “umégkat ka dén a méglakad ka dén, a kébilén mo dén i abék mua.” ");
INSERT INTO dgc_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ey pékabati no lélake ta éya, éy bigla siya a naghusay. Ey inalap na tu abék na, a néglakad dén. Nadid, i éya a aldew, éy sabadu (I sabadu, éy pangilin na Judeo.) ");
INSERT INTO dgc_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Kanya du te tungkulin a Judeo, péketa de to lélake a naghusay, éy pinaginglan de siya, a “Bakit kakébil mo i abék mua?” kagi de. “Isip ko pangilin nadid. Labag ta batas i mégkébil ta aldew a pangilin.” ");
INSERT INTO dgc_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","“Tu lélake a nagpahusay diyakén,” kagi na, “éy inutusanék na a méglakadék, a kébilén ko dén i abék kuae; kanya kinébil ko dén.” ");
INSERT INTO dgc_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","“Ey ti ésiya i nagutusa diko a méglakad ka dén a kébilén mo i abék mua?” kagi de. ");
INSERT INTO dgc_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","“Ewan ko tukoy,” kagi no lélake. Kanya éwan na tukoy éng ti ésiya i nagpahusay diya, éy hinumektat dén ti Jesus, da meaadu i tolay ta éya. ");
INSERT INTO dgc_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Nadid, kétapos na éya, éy neta ni Jesus ta Templo tu lélake a ginamot na. Ey kinagi na diya, a “Entan mo, mahusay ka dén. Nadid éy ibutan mo dén i kasalanan mo, monda éwan ka demtan na mas mahirap pa to saket mo.” ");
INSERT INTO dgc_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Nadid tu lélake, éy inumange siya du te tungkulin a Judeo, a kinagi na a ti Jesus i nagpahusaya diya. ");
INSERT INTO dgc_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Nadid, saya i katuwirana du Judeo a mékialam ni Jesus, da pinahusay na tu lélake to pangilin. ");
INSERT INTO dgc_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pero i katuwirana ni Jesus dide, éy “Tama ko a Diyos éy mégtarabaho a palagi, maski pangilin; éy sakén éy konaék be sa.” ");
INSERT INTO dgc_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Nadid, pékabati sa du te tungkulin a Judeo, éy lalo dén a gustu de a bunon ti Jesus. Naiyamut side diya da nilabag na tu ugali de tungkul ta pangilin. Sakay naiyamut be side to kinagi na, a Diyos i ama naa. I kahulugina na éya éy kagi na éy kapareho siya na Diyos. ");
INSERT INTO dgc_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Nadid, kinagi ni Jesus dide, a “Tandaan moy ye: i tarabaho ko, éy éwan ta isip kua, éngˈwan ahigén ko i tarabaho Nama ko. Dahilan i gimet Nama ko, éy séˈ be ya i gimet kua, sakén a anak na. ");
INSERT INTO dgc_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Gustuék Nama ko. Kanya nipaliwanag na diyakén i étanan a gimet na. Ey ipaliwanag na pa diyakén i gimet ko a lalo a memahal, a monda meta moy a magtaka kam. ");
INSERT INTO dgc_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Mara Tama ko a Diyos, éy pabuhayén na i tolay a pate. Ey sakén a anak na, éy kona be sa i gimet kua, a pabuhayén ko i maski ti ésiya a gustu ko. ");
INSERT INTO dgc_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ewan be méghukum Tama ko, éngˈwan inatdinanék na ta kapangyarian a sakén i maghukuma, ");
INSERT INTO dgc_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","monda igalangék na tolay, a kona ta pénggalang de Nama ko. Tu éwan gumalang diyakén, éy éwan be siya gumalang Nama ko, da siya i nagpaangea se diyakén. ");
INSERT INTO dgc_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Tandaan moy,” kagi ni Jesus, “maski ti ésiya a mangbate ta kagi ko, a sakay méniwala be siya ta nagpaangea se diyakén, éy éwan siya mahukum. Engˈwan, bilang nabuhay dén siya ta pate, da te buhay dén siya a éwan tu katapusan. ");
INSERT INTO dgc_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Tandaan moy be ye: Dumemét i oras a pangbate du bilang pate ta kagi na anak na Diyos. Ey du makabate, éy mabuhay side a éwan tu hanggan. Ey dumemét dén nadid i éya a oras. ");
INSERT INTO dgc_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tama ko, éy siya i gébwata na buhay na tolay. Sakay sakén a anak na, éy inatdinanék na be ta kapangyarian a magpabuhay ta tolay. ");
INSERT INTO dgc_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Sakay inatdinanék na be ta kapangyarian a maghukum ta tolay,” kagi ni Jesus, “da sakén i lélake a gébwat ta langet. ");
INSERT INTO dgc_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Bakit mégtaka kam ta éye a kékagin ko? Entan moy, dumemét i oras a mabati du étanan a édsa ta lébéng i dulaw kua, ");
INSERT INTO dgc_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","a tulos de a buméswal ta lebéng dia. Sakay du nagimet ta mahusay, éy tamo side ta buhay a éwan tu katapusan. Sakay du nagimet ta medukés, éy tamo side ta péghukuman.” ");
INSERT INTO dgc_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nadid, kinagi ni Jesus, a “Ewan gébwat i kapangyarian ko ta sarili ko san, éngˈwan sundin ko san i utus Nama ko ta paghukum ko ta tolay. Kanya tama i péghukum kua. Ewan ko sundin i isip ko sana éngˈwan tupadén ko i kaluuben no nagpaange se diyakén. ");
INSERT INTO dgc_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Mara, éng sakén san i mégkagia dikam a te kapangyarianék, éy éwan kam maniwala. ");
INSERT INTO dgc_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pero éwan,” kagi ni Jesus, “da entan moy, te esa a mégpatunay diyakén. Ey tukoy ko a katutuhanan i pégkagi na tungkul diyakén. ");
INSERT INTO dgc_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mara entan moy ti Juan, to péngisiyasat moy diya, éy nipagtapat na dikam i katutuhanan a tungkul diyakén. ");
INSERT INTO dgc_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Sakén éy éwanék tu kailangan a magpatunay i lélake diyakén. Pero ipaala-ala ko dikam ti Juan, monda maniwala kam maka ta kagi na a monda meligtas kam. ");
INSERT INTO dgc_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ti Juan éy koman i demlag na simbu, da nagpaliwanag dikam ta katutuhanan. Ey gustu moy ta sandali a panahun tu nipagtoldu na dikam. ");
INSERT INTO dgc_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Pero entan moy, te iba a mégpatunay diyakén a higit pa ni Juan,” kagi ni Jesus. “I tarabaho ko a niutus diyakén Nama ko, éy side ya i sistigu kua. Side ya i mégpatunaya a pinaangeék se Nama ko a Diyos. ");
INSERT INTO dgc_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Pati Tama ko, éy mégpatunay be diyakén. Pero sikam, éwan moy nabati tu boses na, éwan moy neta tu mata na; ");
INSERT INTO dgc_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","sakay éwan kam méniwala ta kagi na, da éwan kam méniwala ta pinaange na se. ");
INSERT INTO dgc_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mégéadalén kam ta kasulatan na Diyos,” kagi ni Jesus, “da isip moy wade éng adalén moy éy mabuhay kam a éwan tu katapusan. Ey i éya a kasulatan éy mégpatunay be diyakén! ");
INSERT INTO dgc_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Pero maski patunayanék na kasulatan, éy idel moy a ipasakup diyakén, monda te buhay kam maka a éwan tu katapusan.” ");
INSERT INTO dgc_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nadid, kinagi ni Jesus, a “Sakén, éy éwan ko hangad a puriénék na tolay. ");
INSERT INTO dgc_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Pero tukoy ko a éwan moy gustu i Diyos. ");
INSERT INTO dgc_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Pinaangeék se Nama ko, a mégtoldu dikam tungkul diya; pero éwanék moy tanggapén. Pero éng dumemét dikam i esa a lélake a mégtoldu dikam, éy méniwala kam diya a talaga. ");
INSERT INTO dgc_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ewan kam maari a maniwala diyakén, da i gustu moy sana, éy purién kam na tolay; pero éwan moy gustu a purién kam na Diyos. ");
INSERT INTO dgc_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Diyan moy isipén a sakén i magablaa dikam Nama ko,” kagi ni Jesus. “Engˈwan, Ti Moises i magablaa dikam diya. Umasa kam ni Moises a siya i mangtulunga dikam, pero éwan. ");
INSERT INTO dgc_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kagi moy a méniwala kam ta kagi ni Moises, pero éwan! Eng naniwala kam ni Moises, éy méniwala kam be diyakén, da nisulaték na. ");
INSERT INTO dgc_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Nadid, éng éwan kam naniwala to nisulat ni Moises, éy pakodyan moy a maniwala ta pégtoldu kua?” a Libu a Tolay ");
INSERT INTO dgc_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Nadid éy nagsoli dén ti Jesus ta dibilew na Galilea (I ngahen a esa na éya a diget, éy Tiberias.) ");
INSERT INTO dgc_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ey te meaadu a tolay a tumétagubet diya, dahilan to mineta de a ginamet na du tolay a te ladu. ");
INSERT INTO dgc_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Nadid, inumange de Jesus ta buked, a kaguman na du alagad na. Ey négeknud sa side. ");
INSERT INTO dgc_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Saya i panahun na Piyesta na Ala-ala. ");
INSERT INTO dgc_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Nadid, pékatan-aw ni Jesus ta meaadu a tolay a tumétagubet dide, éy kinagi na ni Pelip, a “Ahe i pamugtungan tam ta ipamakan tam didi tolay yae?” ");
INSERT INTO dgc_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(To pégkagi ni Jesus ta éya, éy napospusan na dén i gemtén na, pero nipakelagip na ni Pelip da puhubaan na siya.) ");
INSERT INTO dgc_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ey kinagi ni Pelip ni Jesus, a “Pakodyan tam wade? Maski ibugtong tam i éduwa a datos a kuhata ta tinapay, éy kulang de pa a kanén!” ");
INSERT INTO dgc_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Nadid, te alagad a esa ta éya a ti Andres, a wadi ni Simon Pedro. Ey kinagi na ni Jesus, a ");
INSERT INTO dgc_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Te anak ta éye a te kébil ta lima a momon a tinapay sakay éduwa a pindang, pero gasinu san dén ye ta kakadua na tolaye.” ");
INSERT INTO dgc_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ey kinagi ni Jesus du alagad na, a “Pégiknudén moy side.” Nadid, da melawa i kalamonan ta éya, éy pinégiknud de du tolay ta éya. Te manga lima a libu a lélake (puwera du bébe sakay du anak). ");
INSERT INTO dgc_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Nadid, inalap ni Jesus tu tinapay no anak. Ey to pégpasalamat na, éy binahabahagi na tu tinapay du tolay. Pati tu éduwa a pindang, éy binahagi na be ta maski sénganya a gustu de. ");
INSERT INTO dgc_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Nadid, to kébésog de dén, éy kinagi ni Jesus du alagad na, a “Hempésén moy i sobha dia, kakenga.” ");
INSERT INTO dgc_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ey to péghempés de, éy naputat i labindalawa a gatang to sobha de a minéngan ta tinapay. ");
INSERT INTO dgc_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nadid, péketa du tolay ta éya a ginamet ni Jesus, éy kinagi de, a “Siya ngani dén ya a talaga i purupeta a pinaange se na Diyos a tagapagligtas dikitam.” ");
INSERT INTO dgc_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Pero ti Jesus, pékapospos na a pilitén de siya a talaga a maghari dide, éy gininanan na side a inumange man dén siya a isesa ta buked. ");
INSERT INTO dgc_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Nadid, to apon, éy inumange du alagad na to digdig no diget. ");
INSERT INTO dgc_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ey sinumakay side to abeng a umahabes ta Kapernaum. Kélép dén, éy éwan pabi dumédemét ti Jesus dide. ");
INSERT INTO dgc_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Nadid, inabut side na mesibét a pahés, a tulos no diget a mesalpuk-salpuk. ");
INSERT INTO dgc_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Nadid, to pégaud de ta manga pitu a kilumetru, éy bigla a neta de ti Jesus a méglakad ta dibo na digita a gébék dide. Ey inumanteng side. ");
INSERT INTO dgc_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ey kinagi ni Jesus dide, a “Diyan kam méganteng, sakén ye.” ");
INSERT INTO dgc_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Nadid, péketa de a siya ngani dén, éy pinasakay de to abeng. Ey to késakay na dén, éy agad side dinumemét to punduan de a lugar. ");
INSERT INTO dgc_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Nadid, to kagagabian na éya, éy du tolay a nawahak to tinulakan du alagad, éy inahayok de ti Jesus. Tukoy de a te dahik sa tu isesa san a abeng to apon se. Sakay tukoy de be a éwan kinumuyog ti Jesus du alagad na to kétulak de ta éya a abeng. ");
INSERT INTO dgc_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Nadid, ahayukén de pabi ti Jesus, éy te dinumemét a abeng dide a gébwat ta Tiberias. Pinumundu side to tapat no pinénganan du tolay to tinapay a niatéd dide ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Kanya du tolay, péketa de a éwan sa de Jesus, éy nipeahabes side du bigu a demét a abeng ta Kapernaum. Ey kédemét de ta éya, éy inahayok de sa ti Jesus. ");
INSERT INTO dgc_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nadid, péketa de diya éy kinagi de, a “Maistu, nikésiya ka pa se dinumemét?” ");
INSERT INTO dgc_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ey kinagi ni Jesus dide, a “Kanyaék moy inahayok, éy dahilan san to nipakan ko dikam to apon se a tinapay. Pero éwan moy maisipan i kahulugina na éya a ginamet ko a tanda. ");
INSERT INTO dgc_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Diyan kam pirmi a mégéahayukén ta kanén moy, da éwan ya matagal. Engˈwan, i ahayukén moy makaa éy tu kanén a iba a makabuhay ta tolay a éwan tu katapusan. Ey sakén i mangatéda ta éya a kanén, da inatdinanék Nama ko a Diyos ta kapangyarian ko.” ");
INSERT INTO dgc_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ey kinagi du tolay ni Jesus nadid, a “Anya i maigi a gemtén me, monda tupadén me i kaluuben na Diyos?” ");
INSERT INTO dgc_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ey kinagi ni Jesus, a “Saye i gustua na Diyos a gemtén moy: maniwala kam diyakén, da pinaangeék na se.” ");
INSERT INTO dgc_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","“Ey anya,” kagi de, “éng gustu mo a maniwala kame diko, éy gemtén mo i tanda a kataka-taka. Mara du apo tam to araw, to pégiyan de ta ilang a lugar, éy pinépakan side ni Moises ta mana a gébwat ta langet. Saya i kagia ta kasulatan na Diyos. Nadid,” kagi du tolay “éng meta me ka a magimet ta kona sa a tanda, éy maniwala kame diko.” ");
INSERT INTO dgc_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ey kinagi ni Jesus dide, a “Tandaan moy, besa ti Moises i nangatéda du apo tam ta kanén a gébwat ta langet, éngˈwan Tama ko i nangatéda. Sakay nadid, éy atdinan kam Nama ko ta tunay a kanén a gébwat ta langet. ");
INSERT INTO dgc_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Nadid, tu kanén a iatéd na Diyos, éy dinumibi a gébwat ta langet. I éya a kanén, éy saya i makabuhaya ta tolay ta mundua a éwan tu hanggan.” ");
INSERT INTO dgc_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Nadid, pékabati du tolay ta éya éy kinagi de, a “Pekanén mo kame pad a palagi ta éya a kanén.” ");
INSERT INTO dgc_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ey kinagi ni Jesus dide. a “Sakén i kanéna a ikébuhay na tolay a éwan tu hanggan. Maski ti ésiya a pasakup diyakén, éy éwan siya mégalép a huway; sakay siya a maniwala diyakén, éy éwan siya mageplék a huway. ");
INSERT INTO dgc_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nadid, anya tu kinagi ko dikam? Tu kinagi ko, éy maski mineta moy tu gimet ko a kataka-taka, éy éwan kam méniwala diyakén. ");
INSERT INTO dgc_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Pero maski ti ésiya i iatéda Nama ko diyakén, éy pásakup side diyakén. Ey sakén éy éwan ko idelan i maski ti ésiya a pasakup diyakén. ");
INSERT INTO dgc_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Da éwanék se dinumibi a gébwat ta langet a monda gemtén ko i kaluuben kua,” kagi ni Jesus; “éngˈwan i kaluuben no nagpaange se diyakén. ");
INSERT INTO dgc_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ey i kaluuben na, éy éwan tu mebut a maski isesa a tolay a niatéd na diyakén, éngˈwan gustu na éy buhayén ko side a étanan ta kédemét na katapusan na mundua. ");
INSERT INTO dgc_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Entan moy,” kagi ni Jesus; “saye i kaluuben Nama ko: Du étanan a makatukoy diyakén a anak na Diyos sakay maniwala be side diyakén, éy gustu Nama ko éy mabuhay side a éwan tu katapusan. Ey sakén i magpabuhaya ta kona sa a tolay ta katapusan na mundua.” ");
INSERT INTO dgc_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Nadid, pékabati sa du Judeo, éy pinintasan de siya. Ewan side méniwala to kinagi na a siya i kanén a dinumibi a gébwat ta langet. ");
INSERT INTO dgc_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","“Anya,” kagi de, “isip ko ti Jesus siya, a anak ni Jose. Bakit kagi na a dinumibi siya a gébwat ta langet, pero natenggi tam tu ina na éy tama na?” ");
INSERT INTO dgc_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ey kinagi dide ni Jesus, a “Diyan kam mégpintas diyakén. ");
INSERT INTO dgc_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Entan moy, éwan tu ipasakup diyakén a talaga éng éwan pa side amo-amon Nama ko. Ey du mananggap diyakén, éy pabuhayén ko side kédemét na katapusan na mundua. ");
INSERT INTO dgc_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Mara entan moy, nisulat du purupeta to araw a ipaliwanag kan na Diyos du étanan a tolay. Kanya nadid, maski ti ésiya a maniwala ta ipaliwanag Nama ko dide, éy pasakup side diyakén. ");
INSERT INTO dgc_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Pero éwan ko kagin a te tolay a minaketa ta Diyos,” kagi ni Jesus. “Ewan. Basta sakén san i naketaa ta Diyos, da gébwaték diya. ");
INSERT INTO dgc_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Tandaan moy i éye a kagi ko dikam, a maski ti ésiya a méniwala diyakén éy te buhay a éwan tu katapusan, ");
INSERT INTO dgc_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","da sakén i kanéna a ikébuhay na tolay a éwan tu hanggan. ");
INSERT INTO dgc_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mara entan moy du apo moy a négiyan ta ilang a lugar: Maski kinékan de tu mana a nipépakan dide ni Moises, éy nate be san side. ");
INSERT INTO dgc_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pero tu tunay a kanén a dinumibi a gébwat ta langet, éy iba. Maski ti ésiya a méngan ta éya a kanén, éy te buhay siya a éwan tu katapusan. ");
INSERT INTO dgc_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ey sakén i kanéna a dinumibi a gébwat ta langet a ikébuhay na tolay,” kagi ni Jesus. “Kanya maski ti ésiya a méngan ta éya a kanén éy mabuhay siya a éwan tu katapusan. Ey tu kanén a iatéd ko éy tu bégi ko. Iatéd ko a monda mabuhay i tolay ta mundua.” ");
INSERT INTO dgc_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nadid, pékabati du Judeo ta éya, éy négpasuway side, a kinagi de, a “Pakodyan na éye a lélake a méngipakan dikitam ta bégi naa?” ");
INSERT INTO dgc_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Kanya kinagi man dén ni Jesus dide, a “Katutuhanan tu kagi ko dikam; sakén i lélake a gébwat ta langet. Eng éwan kam méngan ta bégi kua sakay uminum ta digi ko, éy éwan kam mabuhay a éwan tu hanggan. ");
INSERT INTO dgc_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Dahilan i maski ti ésiya a méngan ta bégi ko sakay uminom ta digi ko, éy te buhay siya a éwan tu katapusan. Sakay pabuhayén ko siya ta katapusan na mundua. ");
INSERT INTO dgc_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Tandaan moy” kagi ni Jesus, “i bégi kua, éy sáya i tunay a kanén; sakay i digi kua, éy sáya i tunay a inumén. ");
INSERT INTO dgc_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Kanya maski ti ésiya a méngan ta bégi kua éy ta uminom ta digi ko, éy mégiyanék diya, sakay mégiyan be siya diyakén. ");
INSERT INTO dgc_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Nadid, pinaangeék se Nama ko,” kagi na. “Siya i gébwata na buhay na tolay. Kanya inatdinanék na ta buhay ko. Ey kona be sa i maski ti ésiya a méngan ta bégi ko, éy atdinan ko be siya ta buhay na. ");
INSERT INTO dgc_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Kanya sakén i tunay a kanén a dinumibi a gébwat ta langet. Besa ya tu kinékan du apo tam, da nate side. Pero du méngan ta tunay a kanén éy mabuhay side a éwan tu katapusan.” ");
INSERT INTO dgc_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Sáya tu kinagi ni Jesus to pégtoldu na du Judeo to kapilya ta Kapernaum. a Ewan Tu Katapusan ");
INSERT INTO dgc_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Nadid, nabati be du alagad na tu pégtoldu na. Kanya kinagi du keaduan de, a “Mehirap i éya a pégtoldu na. Ewan tu makatanggap ta éya a kagi.” ");
INSERT INTO dgc_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Nadid, natukoy agad ni Jesus i péngupos diya du alagad na. Kanya kinagi na dide, a “Anya, idelan moy be i éya a nitoldu ko? ");
INSERT INTO dgc_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ey anya wade i isip moya éng metaék moy a umontok to dati ko a édsean ta langet? ");
INSERT INTO dgc_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Tu ikébuhay na tolay éy Espiritu na Diyos. Tu bégi éy éwan tu kabuluhan a makabuhay ta tolay. Nadid, tu kinagi ko dikam, éy gébwat ta Espiritu, éy makabuhay ya ta tolay. ");
INSERT INTO dgc_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pero te sénganya dikam a éwan méniwala.” Négkagi ti Jesus ta kona sa, da tukoy na sapul to sapul du éwan méniwala diya, sakay tu méngitokyon diya. ");
INSERT INTO dgc_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","“Saya i katuwiran ko a négkagi dikam.” kagi na, “a éwan tu mananggap diyakén, éngˈwan pa side amo-amon Nama ko.” ");
INSERT INTO dgc_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Nadid, kétapos ni Jesus a nagtoldu ta éya, éy gininanan siya du keaduan du alagad na. Ewan dén side kinumuyoyog diya a huway. ");
INSERT INTO dgc_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ey kinagi ni Jesus du alagad na a labindalawa, a “Anya, ginananék moy be?” ");
INSERT INTO dgc_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ey “Ewan,” kagi ni Simon Pedro. “Eng ginanan me ka, éy ahe i angayan mia? Ewan tu iba a mangiligtas dikame éng éwan siko. Siko i te kagia tungkul ta buhay a éwan tu katapusan. ");
INSERT INTO dgc_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Méniwala kame diko,” kagi ni Pedro, “da tukoy me a siko i tiniyak na Diyos a tagapagligtas.” ");
INSERT INTO dgc_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ey kinagi ni Jesus, a “Pinili ta kam a labindalawa, a sikam i alagad ko a tunay. Pero i esa dikam éy dimonyo a talaga.” ");
INSERT INTO dgc_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Négkagi ti Jesus tungkul ni Hudas Iskarote, da maski sakup siya na labindalawa a alagad, éy tukoy ni Jesus a itokyon na siya ta mangdikép diya. ");
INSERT INTO dgc_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Nadid, kétapos na éya, éy nagtulos ti Jesus ta Galilea san. Ewan siya uméange ta Hudea, da gustu du te tungkulin a Judeo ta éya a bunuwén. ");
INSERT INTO dgc_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Nadid, adene dén i piyesta ta Jerusalem a ngéngahinan de a Piyesta na Tolda. ");
INSERT INTO dgc_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Kanya du tétotop ni Jesus, éy kinagi de diya, a “Ikad mo dén ta Hudea, monda meta du alagad mo ta éya i gégemtén mua. ");
INSERT INTO dgc_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Eng gustu mo a tumanyag ka a talaga,” kagi de, “éy bakit éwan mo ipeta i tarabaho mua? Umange ka ta piyesta ta Jerusalem, monda meta du tolay sa i gimet mua.” ");
INSERT INTO dgc_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Pati du tétotop ni Jesus, éy éwan be side nániwala diya; kanya pinégkagian de ta kona sa. ");
INSERT INTO dgc_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ey kinagi ni Jesus dide, a “Ewanék umange nadid ta piyesta, da éwan ko pabi oras a tumanyag. Mara sikam.” kagi na, “éy maari kam a umange ta éya ta maski nikésiya, ");
INSERT INTO dgc_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","da éwan méiyamut du tolay dikam. Pero sakén, éy méiyamut du tolay diyakén, da mégpatunayék dide a medukés i gégemtén dia. ");
INSERT INTO dgc_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Sikam san dén i mamiyestaa,” kagi na. “Pero sakén éy éwanék sa umange. Ewan ko pabi oras a tumanyag.” ");
INSERT INTO dgc_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Nadid, to pégkagi ni Jesus ta éya du top na, éy nawahak siya ta Galilea. ");
INSERT INTO dgc_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Nadid, to kéhektat dén du top na a inumange to piyesta, éy tinumagubet ti Jesus. Pero ta lihim san. ");
INSERT INTO dgc_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Nadid, du te tungkulin a Judeo ta Jerusalem, éy nipépakelagip de ti Jesus, éng ahe siya. Umasa side a umange siya ta piyesta. ");
INSERT INTO dgc_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Sakay du tolay sa, éy masiyadu i pégbébaheta de ni Jesus. Te sénganya a mégkagi a mahusay siya a lélake. Sakay te mégkagi be a “Ewan, da pagkamalién na du tolay.” ");
INSERT INTO dgc_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pero lihim san i pégbébaheta dia. Ewan tu néngipahayag diya, da méganteng side du te tungkulin a Judeo. ");
INSERT INTO dgc_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Nadid, to pégkalahati dén no piyesta, éy inumange ti Jesus ta Templo a tulos siya a mégtoldu du tolay. ");
INSERT INTO dgc_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ey du te tungkulin a Judeo, éy mégtaka side diya, da bihasa a mégtoldu. “Bakit wade matalinung i éye a lélake,” kagi de, “éy éwan be siya nagadal ta iskul tama?” ");
INSERT INTO dgc_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","“Ey dahilan,” kagi ni Jesus, “i pégtoldu kua, éy éwan ta isip kua, éngˈwan gébwat ta Diyos. Siya i nagpaangea se diyakén. ");
INSERT INTO dgc_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Eng gustu na maski ti ésiya a manupad ta kaluuben na Diyos,” kagi na, “éy mapospusan na a talaga éng ahe i gébwata na pégtoldu kua--éng gébwat ta Diyos, o éng gébwat ta isip ko sana. ");
INSERT INTO dgc_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Mara, tu mégtoldu ta isip na san, éy gustu na éy purién siya na tolay. Pero éng te mégtoldu a inutusan siya na Diyos, éy gustu na éy purién na tolay i Diyos. I pégtoldua na kona sa a tolay éy tama, a éwan tu mali-mali. ");
INSERT INTO dgc_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“Inatdinan kam ni Moises ta utus na Diyos, pero éwan moy sésundin. Ey nadid éy gustu moy a ipabunoék moy.” ");
INSERT INTO dgc_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","“Te dimonyo ka a talaga.” kagi du tolay, “éng kona sa i isip mua. Ti ésiya beman i mégpabunua diko?” ");
INSERT INTO dgc_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ey kinagi ni Jesus, a “Bakit mégtaka kam éng pahusayén ko tu lélake ta aldew na pangilin? ");
INSERT INTO dgc_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mara entan moy tu pégbugit: Inutusan kam ni Moises a bugitén moy du anak moy (éy gébwat i éya a ugali du apo tam a neditol ni Moises). Kanya bugitén moy du anak moy maski pangilin, ");
INSERT INTO dgc_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","monda tupadén moy i utus ni Moises. Nadid, éng maari kam a mégbugit maski pangilin, éy bakit mégingél kam diyakén da pinahusay ko tu lélake to pangilin? ");
INSERT INTO dgc_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kanya sikam,” kagi ni Jesus, “éy diyan moy pintasan i tolay éng éwan moy tukoy i tunay a nanyari.” Tungkul Ni Jesus ");
INSERT INTO dgc_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Nadid, i senganya du Judeo ta Jerusalem, éy kinagi de, a “Isip ko siya tu binanta de a bunon! ");
INSERT INTO dgc_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ey entan moy, maski te taknég san se siya a mégtoldu ta harap dia, éy éwan tu néképégkagi diya a maski isesa! Bakit wade,” kagi de; “siguru éwan de siya pékialaman da naisip de dén a siya i tagapagligtas tama a talaga.” ");
INSERT INTO dgc_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pero, “Ewan wade,” kagi du iba, “dahilan ta kédemét kan ni Cristo a tagapagligtas, éy éwan kan tu makapospos ta nagébwatan naa. Pero i éye, éy tukoy tam dén i pégiyanan na a banuwan.” ");
INSERT INTO dgc_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Nadid, to pégtoldu ni Jesus ta Templo, éy kinagi na, a “Isip moy tukoyék moy, sakay isip moy tukoy moy i kinagébwatan kua. Pero éwan! Ey éwanék se inumange ta isip ko san, éngˈwan, te iba a nagpaange se diyakén. Siya i tunaya. Ey sikam éy éwan moy siya tukoy. ");
INSERT INTO dgc_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Pero sakén, éy tukoy ko siya, da gébwaték diya, sakay pinaangeék na se.” ");
INSERT INTO dgc_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Nadid, to pégkagi ni Jesus ta éya, éy lalo de a gustu a dekpén siya. Pero éwan de netulos, da éwan na pabi takda a madikép. ");
INSERT INTO dgc_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Sakay meadu be a tolay to piyesta a méniwala diya. “Siya i tagapagligtas a talaga,” kagi de, “da éwan tu iba a makagimet ta kataka-taka a kona diya.” ");
INSERT INTO dgc_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Nadid du Pariseyo, nabati de tu kinékagi du tolay tungkul ni Jesus. Kanya inutusan de du pulis a angen dekpén siya. ");
INSERT INTO dgc_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ey nadid, kinagi man dén ni Jesus du tolay, a “Kétihék san dén a panahun i pékiagum kua dikam, sakay magsoliék dén to minagpaange se diyakén. ");
INSERT INTO dgc_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ey sikam, éy ahayukénék moy, pero éwan ék moy meta, da éwan kam makaange ta angayan kua.” ");
INSERT INTO dgc_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Nadid, pékabati du Judeo ta éya, éy néguhon-uhon side a kinagi de, a “Ahe wade i angayan naa? Bakit kagi na a éwan tam meta? Siguru umange siya mégiyan du Judeo ta adeyo a banuwan na Griego, monda tolduan na sa du Griego a tolay. ");
INSERT INTO dgc_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Anya wade i kahulugen no kinagi na a ahayukén tam kan siya, pero éwan tam meta? Bakit kinagi na a éwan kitam kan makaange ta angayan na? Ahe wade i angayan naa?” Kona sa i uhuna du te tungkulin a Judeo. ");
INSERT INTO dgc_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Nadid, to katapusan a aldew no piyesta ta Jerusalem, éy tinumaknég ti Jesus ta harap du tolay, a kinagi na dide ta medegsén. “Maski ti ésiya a mégeplék,” kagi na, “éy umange se diyakén a uminom. ");
INSERT INTO dgc_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Da maski ti ésiya a méniwala diyakén, éy koman dén i te bukal a dinom ta disalad na bégi na a mégbulos a ikébuhay na. Kona sa i kagia ta kasulatan na Diyos.” ");
INSERT INTO dgc_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","(I éya a kinagi ni Jesus, éy nihalimbawa na ta Espiritu na Diyos a umasék ta tolay a maniwala diya. Pero éwan pabi umasék, da bagu kona sa i gimet na Espiritu éy umontok pa ti Jesus ta langet.) ");
INSERT INTO dgc_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nadid, pékabati du tolay ta éya, éy kinagi du sénganya, a “Siya i mahalaga a purupeta na Diyos a talaga!” ");
INSERT INTO dgc_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Sakay te iba be a mégkagi, a “Siya i Cristo a tagapagligtas dikitam.” Pero, “Besa ina,” kagi du iba. “Magébwat beman i Cristo ta Galilea? ");
INSERT INTO dgc_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Isip ko i kagia ta kasulatan na Diyos éy i Cristo éy gébwat kan ta lahi ni Hari Dabid. Sakay ta kédemét na kan,” kagi de, “éy gébwat kan ta Bethlehem a banuwan ni Dabid.” (Akala de éy nienak ti Jesus ta Galilea.) ");
INSERT INTO dgc_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Kanya du tolay, éy éwan paripareho i isip dia tungkul ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","I sénganya dide, éy gustu de maka siya a dekpén. Pero éwan de nitulos. ");
INSERT INTO dgc_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Nadid, du pulis a talaga a manikép ni Jesus, éy nagsoli side du nagutus dide a Pariseyo. Ey kédemét de dide, éy kinagi du Pariseyo, a “Bakit éwan moy siya dinikép?” ");
INSERT INTO dgc_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ey kinagi du pulis, a “Mésanike kame diya, da éwan me pabi nabati i memahal a kagi a kona to kinagi na.” ");
INSERT INTO dgc_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ey “Anya,” kagi du Pariseyo, “pagkamalién na kam bale be? ");
INSERT INTO dgc_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Bakit, neta moy beman i maski isesa a mataas a Judeo a méniwala diya? Ewan! ");
INSERT INTO dgc_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Pero didi tolaya a mababa,” kagi de, “éy méniwala side da éwan de inadal tu utus ni Moises. Dumemét maka dide agad i parusa na Diyos.” ");
INSERT INTO dgc_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nadid, édsa be sa nadid ti Nikodemo, da Pariseyo be siya. Siya tu inumange nékiohon ni Jesus to kélép. Ey kinagi na dide, a ");
INSERT INTO dgc_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Bakit pépintasan moy siya agad? Isip ko i ugali tama éy éwan kitam magparusa ta tolay éng éwan tam pa mabati tu katuwiran na?” ");
INSERT INTO dgc_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ey “Anya,” kagi de ni Nikodemo, “bakit kumampi ka diya, taga Galilea ka wade be? Hala, pagadalan mo i kasulatana, éy meta mo a éwan tu purupeta a gébwat ta Galilea.” ");
INSERT INTO dgc_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Nadid, sinumoli dén du tolay ta bile de. Pero ti Jesus, éy inumange san ta Buked na Olibo a édsa side a natidug. ");
INSERT INTO dgc_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ey to kagagabian na, éy inumange man dén siya ta Templo. Ey dinumulug diya du tolay. Ey inumeknud sa siya a nagtoldu dide. ");
INSERT INTO dgc_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Nadid, to pégtoldu na, éy dinumemét sa du maistu ta rilihiyon sakay du Pariseyo, a te kébil side a bébe a nadikép de ta péngilélake. Ey niharap de siya du tolay sa. ");
INSERT INTO dgc_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ey kinagi du Pariseyo ni Jesus, a “Maistu, nadikép de i bébe a éye ta péngilélake. ");
INSERT INTO dgc_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Anyan tam siya, da utus ni Moises éy batibatikalén tam i kona se a bébe a hanggan mate? Anya i isip mua, Maistu, bunon me siya, o éwan?” ");
INSERT INTO dgc_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Kanya pinakelagipan de ti Jesus ta kona sa, éy puhubaan de siya. Gustu de maka a pégkagin siya ta mali, monda te katuwiran side a mangidimanda diya. Pero ti Jesus, éy basta hinumekten siya a pénulat na tu toldu na to luta. ");
INSERT INTO dgc_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Nadid, to pémilit de diya a pégpépakelagip, éy tinumaknég siya a kinagi na dide, a “Maari; tu éwan tu kasalanan dikam, éy siya i meditula a mangbatikal.” ");
INSERT INTO dgc_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ey to pégkagi ni Jesus ta éya éy hinumekten man dén siya a pénulat na tu toldu na to luta. ");
INSERT INTO dgc_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ey du Pariseyo, pékabati de to kagi ni Jesus, éy mésanike dén side, da tukoy de a te kasalanan be side. Kanya nétégitégesa dén side a néglakad, sapul to katandaan de. Basta i nawahaka éy ti Jesus sakay tu bébe. ");
INSERT INTO dgc_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ey tinumaknég ti Jesus a kinagi na to bébe, a “Anéng, ahe dén du nagpehay diko? Ewan tu nabuhay a mangparusa diko?” ");
INSERT INTO dgc_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ey “Ewan, Maistu,” kinagi no bébe. “Ey sakén, éy éwan ta ka be parusaan,” kagi ni Jesus, “Ikad mo dén, a diyan ka magkasala a huway.” ");
INSERT INTO dgc_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Nadid, mégtoldu man dén ti Jesus du tolay. “Sakén i Demlaga a mégpaliwanag ta tolay ta mundua,” kagi na. “Maski ti ésiya i mékiaguma diyakén, éy éwan méglakad ta mediklém. Engˈwan, édse diya i Demlag a ikébuhay na tolay.” ");
INSERT INTO dgc_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Nadid, pékabati du Pariseyo ta éya, éy kinagi de, a “Ewan kame méniwala diko, da éwan tu iba a mégpatunay diko. Engˈwan, siko be san i mégpatunaya ta sarili mua.” ");
INSERT INTO dgc_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","“Maski mégpatunayék ta sarili kua,” kagi ni Jesus “éy katutuhanan tu kagi ko, da tukoy ko i kinagébwatan ko éy ta angayan ko. Pero sikam,” kagi na, “éy éwan moy tukoy i kinagébwatan ko éy ta angayan ko. ");
INSERT INTO dgc_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Sikam, éy pintasan moy i tolay ayun ta isip moya, maski éwan moy tukoy. Pero sakén,” kagi na, “éy éwan ko ugali a mégpintas. ");
INSERT INTO dgc_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Pero éng magpintasék ta tolay, éy katutuhanan tu pintas ko, da éwan san sakén i magpintasa, éngˈwan kaguman ko be i nagpaangea se diyakén. ");
INSERT INTO dgc_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mara entan moy tu kautusan moy, i kagi naa éng te éduwa kan a mégpatunay ta maski anya a gimet, éy tanggapén moy a katutuhanan. ");
INSERT INTO dgc_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ey nadid, isip ko te éduwa a mégpatunay diyakén, sakén, sakay tu nagpaange se diyakén a Ama ko!” ");
INSERT INTO dgc_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","“Ey ahe tama mo?” kagi du Pariseyo. “Ewanék moy tukoy,” kagi ni Jesus, “sakay éwan moy be tukoy Tama ko. Eng tukoyék moy, éy tukoy moy be dén Tama ko.” ");
INSERT INTO dgc_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Saya tu kinagi ni Jesus du Pariseyo ta Templo. Tu édsean na a mégkagi, éy to tapat no pégabuloyan. Ey du te tungkulin a Judeo, éy éwan de siya nipadikép, da éwan na pabi takda a madikép. ");
INSERT INTO dgc_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Nadid, kinagi man dén ni Jesus du tolay, a “Adene dén i oras a hektatan ta kam. Ey ahayukénék moy, pero éwanék moy meta. Engˈwan basta mate kam a te kasalanan pabi. Sakay éwan kam makaange ta angayan kua.” ");
INSERT INTO dgc_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","“Bakit?” kagi du te tungkulin a Judeo. “Bakit kagi na a éwan kitam kan makaange ta angayan naa? Siguru mégusot siya, kanya éwan kitam makaange diya!” ");
INSERT INTO dgc_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ey kinagi ni Jesus dide, a “Sikam éy taga éye kam ta dibeae. Sakén éy taga ontokék. Sikam éy taga mundu kam, pero sakén éy éwan. ");
INSERT INTO dgc_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kanya katutuhanan tu kinagi ko a mate kam a te kasalanan pabi. Ey mate kam a te kasalanan pabi a talaga,” kagi ni Jesus, “éng éwan kam maniwala diyakén, a sakén ngani i pinaange se na Diyos.” ");
INSERT INTO dgc_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","“Ey ti ésiya ka beman ye?” kagi du Pariseyo. “Ey to sapul ngani pa,” kagi ni Jesus, “éy kinagi ko dén ya dikam. ");
INSERT INTO dgc_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mapintasan ta kam maka ta ugali moy, pero éwan. Dahilan tu ipahayag ko nadid ta tolay, éy tu nipaliwanag san diyakén no nagpaange se diyakén. Siya i tunaya.” ");
INSERT INTO dgc_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Nadid, du lélake a mégbati ni Jesus, éy éwan de tukoy tu kagi na a te nagpaange se diya. Ewan de napospusan a kinagi na dide Tama na a Diyos. ");
INSERT INTO dgc_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","“Sakén i lélake a gébwat ta langet,” kagi na. “Ta péngiekpét moy diyakén ta te tolnék a kayo, éy mapospusan moy dén a sakén i pinaangea se na Diyos. Sakay mapospusan moy be a éwan gébwat i pégtoldu ko ta sarili ko san; éngˈwan gébwat to nipaliwanag diyakén Nama ko. ");
INSERT INTO dgc_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Sakay tu nagpaange se diyakén, éy kaguman ko san. Ewanék na pabayan, da gégemtén ko i gustu naa.” ");
INSERT INTO dgc_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Nadid, to pégkagi ni Jesus ta éya, éy meadu i naniwala diya. ");
INSERT INTO dgc_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ey kinagi ni Jesus du Judeo a méniwala diya, a “Eng sugsugén moy i kagi kua, éy sikam i tunay a alagad ko a talaga. ");
INSERT INTO dgc_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Sakay pati, éy mapospusan moy i katutuhanan. Sakay éng mapospusan moy i katutuhanan, éy saya i magpalibria dikam.” ");
INSERT INTO dgc_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","“Ey bakit te magpalibri dikame?” kagi du Judeo. “Lahi kame be ni Abraham. Ewan kame pabi inutusan na maski ti ésiya! Bakit kagi mo a te magpalibri dikame?” ");
INSERT INTO dgc_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","“Tandaan moy,” kagi ni Jesus, “maski ti ésiya a mégkasala, éy tu kasalanan na éy saya i mégutusa diya, da sésundin na tu kasalanan na. ");
INSERT INTO dgc_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mara tu utusan, éy éwan siya mégiyan a hanggan to bile no amo na. Pero tu anak no amo na, éy mégiyan diya a palagi. ");
INSERT INTO dgc_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kanya sikam, éng ilibri kam no anak na Diyos, éy libri kam a talaga. ");
INSERT INTO dgc_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Tukoy ko,” kagi ni Jesus, “a lahi kam ni Abraham. Ey maski lahi kam ni Abraham, éy gustu moy a ipabunuék moy, da éwan moy tétanggapén i pégtoldu kua. ");
INSERT INTO dgc_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Sakén,” kagi na, “éy mégtolduék ta nipeta diyakén Nama ko. Sikam éy gemtén moy tu kinagi dikam nama moy.” ");
INSERT INTO dgc_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","“Ti Abraham,” kagi du Judeo, “éy siya i ama mia.” Ey “Ewan,” kagi ni Jesus, “dahilan, éng lahi kam ni Abraham, éy ahigén moy maka tu ugali na a mahusay. ");
INSERT INTO dgc_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Pero éwan,” kagi na, “da gustu moy a ipabunuék moy. Ey éwan sa kona tu ugali ni Abraham. Ipabunuék moy, maski kinagi ko dikam i katutuhanan a nipaliwanag diyakén na Diyos! ");
INSERT INTO dgc_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ewan moy ahigén ti Abraham, éngˈwan ahigén moy tu ama moy a esa.” Nadid, mégingél du Judeo, a kinagi de ni Jesus, a “Ewan kame mungaw. Tukoy me tama me, a Diyos i Ama mia!” ");
INSERT INTO dgc_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","“Ewan,” kagi ni Jesus. “Dahilan éng Diyos i Ama moya a talaga, éy mahalék moy, da inumangeék se a gébwat ta Diyos. Ewanék se inumange ta isip ko san, éngˈwan pinaangeék se na Diyos. ");
INSERT INTO dgc_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Bakit wade éwan moy mépospusan tu kékagin ko? Dahilan siguru éy éwan kam makatiis a mégbati ta pégtoldu kua. ");
INSERT INTO dgc_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ewan Diyos i Ama moya, éngˈwan ti Satanas, da gustu moy a sugsugén i kaluuben na. Sapul to sapul éy siya i mégbuno. Sala na i katutuhanan, da i katétubu na a ugali, éy mebuli. Siya i nagsapulana na étanan a kagi a kakabulyan. ");
INSERT INTO dgc_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Pero sakén,” kagi ni Jesus, “éy kinékagi ko dikam i katutuhanan, pero éwan kam méniwala ta kagi kua. ");
INSERT INTO dgc_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ti ésiya dikam i makapagpatunay a te kasalananék? Ewan. Ey nadid, éng mégkagiék dikam ta katutuhanan, éy bakit éwan kam méniwala? ");
INSERT INTO dgc_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Du tolay a tunay a anak na Diyos, éy mégbati side ta kagi na Diyos. Pero sikam, éy éwan kam anak na Diyos; kanya sala moy a mégbati ta kagi kua.” ");
INSERT INTO dgc_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Nadid, pékabati du Judeo ta éya, éy méiyamut side ni Jesus. “Tama bale tu kinagi me a te dimonyo ka!” kagi de. “Ewan ka Judeo, éngˈwan dayuan ka a Samaritano.” ");
INSERT INTO dgc_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ey “Ewan,” kagi ni Jesus. “Ewanék tu dimonyo. Engˈwan, pataasén ko Tama ko ta kagi ko. Pero sikam. éy pépintasanék moy ta kagi moy. ");
INSERT INTO dgc_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Pero pabayan ko san,” kagi na, “da éwan ko gustu a magpataas ta sarili ko. Pero te esa a magpataas diyakén. Ey siya i bahala. ");
INSERT INTO dgc_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Tandaan moy ye,” kagi ni Jesus, “maski ti ésiya a mangtupad ta kagi kua, éy éwan siya mate, maski nikésiya.” ");
INSERT INTO dgc_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Nadid, pékabati du te tungkulin a Judeo ta éya, éy “Alakame!” kagi de, “minate ti Abraham. Minate du purupeta na Diyos. Pero kagi na lélakeae éng tupadén na tolay i kagi na éy éwan kan side mate! Are! Hinayup siya a talaga! ");
INSERT INTO dgc_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Anya,” kagi de, “isip mo mataas ka to apo tam a Abraham a minate dén? Sakay du purupeta éy minate be side. Bakit, isip mo a siko i mataasa ta étanan ta munduae?” ");
INSERT INTO dgc_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Nadid, kinagi ni Jesus dide, “Eng mara pataasén ko i sarili ko, éy éwan ya tu pasa a magpataas diyakén. Pero éwan, da Tama ko i mégpataasa diyakén. Kagi moy a siya i Diyos moy, ");
INSERT INTO dgc_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","pero éwan, da éwan moy siya tukoy a talaga. Sakén, éy tukoy ko siya,” kagi ni Jesus. “Mara éng kagin ko a éwan ko tukoy i Diyos, éy magbuli-buliék a kona dikam, da tukoy ko siya a talaga. Sakay i kagi naa, éy tupadén ko. ");
INSERT INTO dgc_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tu apo moy a Abraham: asa na a metaék na a dumemét. Ey neta na ngani dén i demét ko, éy mésaya siya ta éya.” ");
INSERT INTO dgc_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","“Ey pakodyan mo a naketa ni Abraham,” kagi de, “éy éwan ka pabi lakay?” ");
INSERT INTO dgc_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","“Ey tandaan moy ye,” kagi ni Jesus, “bagu nienak ti Abraham, éy naleék dén a buhay.” ");
INSERT INTO dgc_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Nadid, pékabati du Judeo ta éya, éy nangalap side ta bito, a talaga de a batibatikalén. Pero éwan, da linumiso ti Jesus dide, a linumwas dén siya ta Templo. ");
INSERT INTO dgc_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Nadid, to péglakad de Jesus, éy neta de tu lélake a buhék sapul to nikeeanak na. ");
INSERT INTO dgc_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ey kinagi diya du alagad na, a “Anya wade, Maistu, bakit wade nienak i lélake a éya a buhék? Parusa ina na kasalanan na a sarili, o na kasalanan dena na?” ");
INSERT INTO dgc_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","“Ewan,” kagi ni Jesus. “Ewan ina gébwat to kasalanan na. Sakay éwan be gébwat ta kasalanan dena na. Engˈwan, kanya buhék siya, éy monda mepahayag i kapangyarian na Diyos a manghusay diya. ");
INSERT INTO dgc_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kailangan a tupadén tam i tarabaho no nagpaange se diyakén bagu malipas i panahun a pangtupad tam. Dumemét agad i kélép éy éwan tu makatarabaho. ");
INSERT INTO dgc_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Habang édseék ta mundua, éy sakén i Demlag a mégpaliwanag ta tolay ta mundua.” ");
INSERT INTO dgc_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Nadid, to pégkagi ni Jesus ta éya, éy linoktaben na tu luta a ginimet na a putik, sakay nikulo na to mata no buhék. ");
INSERT INTO dgc_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Sakay kinagi na diya, a “Ikad mo dén magidemos ta dinuma na Siloe.” Nadid inumange sa tu buhék a nagidemos. Ey to késoli na to bile, éy naketa dén siya. ");
INSERT INTO dgc_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Nadid du karatig na, sakay du dati a nakatenggi diya, éy kinagi de, a “Anya, éwan ye tu lélake a dati a te eknud a mékilimos?” ");
INSERT INTO dgc_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Isip du kalahati a tolay éy siya ngani dén ya, pero “Ewan wade ina,” kagi du iba, “neubet wade san ye.” Ey “Ewan,” kagi no lélake, “sakén ngani dén ye.” ");
INSERT INTO dgc_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","“Ey pakodyan mo a nakabulag?” kagi de. ");
INSERT INTO dgc_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","“Tu lélake a ngéngahinan de a Jesus,” kagi na, “éy nagimet ta putik to laway na, sakay nikulo na ta mata kua, sakay inutusanék na a magidemos ta Siloe. Ey to pégidemos ko sa, éy naketaék dén.” ");
INSERT INTO dgc_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","“Ey ahe dén i éya a lélake?” kagi de. Ey “Ahéy,” kagi na. “éwan ko dén tukoy.” Kodya I Nipaghusay Na ");
INSERT INTO dgc_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Nadid, to pégimet ni Jesus to putik a pagamot na to mata no buhék, éy pangilin a aldew. Kanya du tolay, éy niange de tu lélake du Pariseyo. (Da bawal kan tu ginamet ni Jesus, da pangilin.) ");
INSERT INTO dgc_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ey du Pariseyo, éy nisiyasat de diya éng pinakodya na a minaketa. Ey kinagi na dide, a “Te lélake a nikulo na tu putik ta mata kua, éy pégidemos ko, éy naketaék dén.” ");
INSERT INTO dgc_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Nadid, néguhunan du Pariseyo ti Jesus. “Ewan gébwat ta Diyos i éya a lélake,” kagi de, “da éwan siya méngilin ta sabadu.” “Ewan,” kagi du iba. “Eng makasalanan siya a tolay, éy bakit makagimet siya ta kataka-taka?” Nadid, kona sa i nipégpasuwaya du Pariseyo. Ewan side négkaisa tu isip. ");
INSERT INTO dgc_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Nadid kinagi de man dén to lélake, a “Siko, anya i isip mua, da siko kan i pinahusay na tu mata?” “Purupeta siya a talaga,” kagi na. ");
INSERT INTO dgc_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Nadid, du te tungkulin a Judeo, éy éwan side méniwala a buhék tu lélake to éya. Kanya nipauwet de dena na, ");
INSERT INTO dgc_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","a kinagi de dide, a “Anya, éng saye i anak moya a kagi moy a buhék sapul to nikeenak na, éy bakit naketa dén nadid?” ");
INSERT INTO dgc_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","“Ewan me tukoy,” kagi dena na. “Anak me ngani ina, a buhék sapul to nikeenak na. ");
INSERT INTO dgc_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pero éwan me tukoy éng kodya i nipaketa naa. Sakay éwan me be tukoy éng ti ésiya i nagpahusaya ta mata naa. Pakelagipan moy siya,” kagi de. “Mégkagi ina dikam, da te idad be dén.” ");
INSERT INTO dgc_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Kona sa i kinagi dena na du te tungkulin, da méganteng side dide. Tukoy de a nagkasunduan dén du te tungkulin a ibutan de ta kapilya de i bawat mégkagi a ti Jesus i tagapagligtas dia. ");
INSERT INTO dgc_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Kanya kinagi de dide a bahala tu anak de a sumengbet to nipakelagip de dide. ");
INSERT INTO dgc_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Kanya du te tungkulin a Judeo, éy pinauwet de man dén tu lélake a naghusay tu mata. Ey kinagi de diya, a “Isumpa mo ta Diyos éng katutuhanan tu kinagi mo dikame. Ewan maari a ti Jesus i nagpahusaya diko, da makasalanan siya a tolay.” ");
INSERT INTO dgc_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","“Ewan ko tukoy éng makasalanan siya, éngˈwan,” kagi no lélake. “Basta i tukoy ko sana, éy buhékék to éya, éy nadid éy naketaék dén!” ");
INSERT INTO dgc_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","“Ey anya i ginamet naa diko a talaga?” kagi de. “Pakodyan na a nagpabulag ta mata mua?” ");
INSERT INTO dgc_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","“Ey isip ko kinagi ko dén ya dikam,” kagi na. “Bakit éwan kam méniwala to kinagi ko? Bakit pékelagipanék moy man dén? Gustu moy wade be a maging alagad na?” ");
INSERT INTO dgc_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Nadid, pékabati du te tungkulin ta éya, éy pinaginglan de tu lélake, a kinagi de, a “Siko i alagad na a talaga. Sikame, éy alagad kame ni Moises. ");
INSERT INTO dgc_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tukoy me a ti Moises i utusan na Diyos. Pero i éya a lélake, éy éwan me tukoy éng ahe i gébwat naa.” ");
INSERT INTO dgc_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","“Mégtakaék dikam!” kagi no lélake. “Neta moy dén a pinahusay na i mata kua éy éwan moy bale tukoy i kinagébwatan naa! ");
INSERT INTO dgc_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Isip ko éwan tulungan na Diyos i tolay a makasalanan,” kagi na, “éngˈwan i tulungan na sana éy tu tunay a méniwala diya. ");
INSERT INTO dgc_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Sapul to sapul, éy éwan tu nakapagpabulag ta tolay a buhék sapul to nikeenak na. ");
INSERT INTO dgc_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Eng éwan gébwat i éya a lélake ta Diyos, éy éwan siya makagimet ta kona sa,” kagi no buhék. ");
INSERT INTO dgc_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","“Alakame!” kagi du te tungkulin. “Siko i makasalanana sapul to kéanak mo, sakay gustu mo beman a siko i mégtoldua dikame?” Ey nadid éy, inibutan de siya to pégmitingan de. ");
INSERT INTO dgc_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Nadid ti Jesus, éy nabaheta na a inibutan de tu lélake to pégmitingan de. Ey to péketa na diya, éy kinagi na a “Méniwala ka ta lélake a gébwat ta langet?” ");
INSERT INTO dgc_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","“Ti ésiya siya?” kagi no lélake. “Ikagi pad diyakén, monda maniwalaék diya.” ");
INSERT INTO dgc_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","“Ey neta mo dén siya,” kagi ni Jesus, “da sakén a mégkagi diko, éy sakén ngani dén ye.” ");
INSERT INTO dgc_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","“Ey méniwalaék dén diko, Panginoon,” kagi no lélake. Ey tulos na a sinumamba diya. ");
INSERT INTO dgc_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Nadid, kinagi ni Jesus a, “Kanyaék se inumange ta mundua, éy monda mahukum i tolay. Sakay inumangeék be se monda maketa du buhék ta katutuhanan, sakay monda mabuhék du mégkagi a meta de i katutuhanan.” ");
INSERT INTO dgc_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Nadid, du Pariseyo a te taknég sa, pékabati de ta éya, éy kinagi de, a “Anya, kagi mo a buhék kame be tu isip?” ");
INSERT INTO dgc_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","“Eng buhék kam a talaga,” kagi ni Jesus, “éy éwan kam tu kasalanan. Pero nadid, da kagi moy a meta moy i katutuhanan, éy saya i katunayana a te kasalanan kam a talaga.” ");
INSERT INTO dgc_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Tandaan moy ye,” kagi ni Jesus. “Mara tu kulungan na tupa, maski ti ésiya a umunek to kudal na a éwan dumiman to pintuan na, éy tulisan ya. ");
INSERT INTO dgc_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pero tu dumiman to pintuan na, éy siya i tunay a pastor du tupa. ");
INSERT INTO dgc_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Siya, bagay dumemét to kulungan éy bukasan siya no bantay to pintuan. Sakay tu pastor, éy dulawan na i ngahen du tupa na. Ey du tupa, éy pépansingén de tu dulaw no amo de. Ey kédulug de diya, éy iluwas na side to kulungan. ");
INSERT INTO dgc_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nadid, péngiluwas na dide, éy mégdetol siya dide, a umunonod side diya a mahusay, da tukoy de i boses naa. ");
INSERT INTO dgc_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ewan side umunonod ta iba,” kagi ni Jesus, “da éwan de tukoy tu boses na; éngˈwan ginanan de i kona sa.” ");
INSERT INTO dgc_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Saya i nihalimbawaa ni Jesus du te tungkulin a Judeo, pero éwan de napospusan i kahulugen naa. ");
INSERT INTO dgc_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Kanya nipaliwanag ni Jesus dide, a kinagi na, a “Tandaan moy: Sakén i pintuan a sésdépan na tupa. ");
INSERT INTO dgc_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Du étanan a neditol diyakén, a mégkukunwari a mataas, mara side ya i tulisan a mégtako. Pero du tunay a tupa ko, éy éwan de side pinansing. ");
INSERT INTO dgc_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Mara sakén i pintuan,” kagi na. “Eng sédpanék na maski ti ésiya a tolay, éy meligtas siya. Maari siya a tamo éy soli to kulungan ko. Sakay sakén, éy atdinan ko siya ta kanén na. ");
INSERT INTO dgc_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mara tu tulisan, éy umange siya to kulungan a magtako sakay mamuno. Pero sakén, éy inumangeék se a monda atdinan ko i tolay ta malaya a buhay. ");
INSERT INTO dgc_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Sakén i mahusay a pastor,” kagi ni Jesus. “Tu mahusay a pastor, éy iatéd na i buhay na alang-alang du tupa na. ");
INSERT INTO dgc_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","13","Pero tu upaan, éy éwan, da ginanan na san du tupa éng meta na tu aliyas a aso a dumuklos. Pabayan na du tupa da éwan siya tu pastor de, sakay éwan na side mahal, da upaan san siya. Nadid, tu aliyas a aso, éy kékagitén na side a hanggan da minasebunak side. ");
INSERT INTO dgc_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Pero sakén,” kagi ni Jesus, “éy sakén i mahusay a pastor. Nadid, tukuyék Nama ko, sakay tukoy ko be siya. Ey kona be sa sikame du tupa ko; tukoy ko side, sakay tukuyék de be. Ey iatéd ko i buhay ko alang-alang dide. ");
INSERT INTO dgc_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nadid, te tupaék be a iba,” kagi ni Jesus, “a éwan édse ta kulungan ko. Kailangan éy alagaan ko be side. Ey pansingén de i boses ko a talaga. Nadid, ta pégpasakup de diyakén éy esa side a gurupu, a sakén be i pastor dia a isesa. ");
INSERT INTO dgc_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Nadid, mahalék Nama ko, da iatéd ko i buhay kua, sakay mabuhayék a huway. ");
INSERT INTO dgc_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ewan tu tolay a te kapangyarian a mamuno diyakén, éngˈwan sakén san i bahalaa ta buhay ko, éng mateék, o éng éwan. Ey nadid, éy iatéd ko i buhay ko. Te kapangyarianék a mamakate ta buhay kua, sakay te kapangyarianék be a magpabuhay ta bégi kua. Saya i niutusa diyakén Nama ko.” ");
INSERT INTO dgc_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Nadid, to péghalimbawa ni Jesus ta éya du Judeo, éy négpasuway man dén side, dahil to kinagi na. ");
INSERT INTO dgc_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Kagi du kalahati, éy “Diyan moy siya bébaten. Luku-luku siya! Te dimonyo siya!” ");
INSERT INTO dgc_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Pero “Ewan,” kagi du iba, “bakit memahal i pégtoldu naa? Ewan méképégtoldu i luku-luku ta kona sa. Anya, makapagpabulag i luku-luku ta buhék?” ");
INSERT INTO dgc_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Nadid, oras dén na piyesta ta Jerusalem a pékaala-ala de ta Templo. Taglamig ta panahun a éya. ");
INSERT INTO dgc_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ey édse ti Jesus to kwarto ni Solomon to Templo. ");
INSERT INTO dgc_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Nadid du te tungkulin a Judeo, éy dinumulug sa side diya, a kinagi de, a “Bakit iliso mo dikame i tungkulin mo? Ipagtapat mo dikame éng siko i Cristo a tagapagligtas dikame, o éng éwan.” ");
INSERT INTO dgc_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ey kinagi ni Jesus dide, a “Isip ko kinagi ko dén ya dikam, éy éwan kam naniwala. I tinarabaho ko a niutus diyakén Nama ko, éy saya i mégpatunaya diyakén. ");
INSERT INTO dgc_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pero sikam, éy éwan kam méniwala, da éwan kam kabilang na tupa ko. ");
INSERT INTO dgc_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Du tupa ko,” kagi ni Jesus, “éy pépansingén de i boses kua, éy tukoy ko side. Sakay side, éy umunonod side diyakén. ");
INSERT INTO dgc_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ey atdinan ko side ta buhay a éwan tu katapusan. Maski nikésiya éy éwan side mepahamak. Sakay pati éy éwan tu méngagew dide diyakén. ");
INSERT INTO dgc_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tama ko, éy siya i mataasa ta étanan. Ey siya i néngientaregaa dide diyakén. Ey éwan tu méngagew du tupa na diya. ");
INSERT INTO dgc_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nadid, sakén sakay Tama ko a Diyos, éy esa kame.” ");
INSERT INTO dgc_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Nadid, pékabati du Judeo ta éya, éy inalap de man dén du bito, a talaga de man dén siya a batibatikalén. ");
INSERT INTO dgc_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ey kinagi ni Jesus dide, a “Te meadu a mahusay a ginamet ko ta harap moya, a niutus diyakén Nama ko. Ahe sina i kasalanan ko a pangbatibatikalan moy diyakén?” ");
INSERT INTO dgc_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","“Ewan to ginamet mo a mahusay i pangbatibatikalan mia diko,” kagi du te tungkulin, “éngˈwan i kasalanan mua, éy lapastangan ka ta Diyos. Mégwari-wari ka a Diyos, pero tolay ka san.” ");
INSERT INTO dgc_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","35","“Ey isip ko,” kagi ni Jesus, “éy te kagi ta kasulatan na Diyos, a nginahinan na Diyos du utusan na a diyos be side. Ey éwan malipas i kasulatan na Diyos. ");
INSERT INTO dgc_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ey nadid, bakit éwanék maari a mégkagi a anakék na Diyos, éy inutusanék be na Diyos, a pinaangeék na se ta mundua? Kagi moy a lapastanganék ta Diyos, pero éwan. ");
INSERT INTO dgc_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Entan moy,” kagi ni Jesus, “éng éwan ko gemtén i tarabaho Nama ko, éy diyan kam méniwala diyakén. ");
INSERT INTO dgc_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Per éng gemtén ko i tarabaho na, éy maski éwan kam méniwala ta kagi ko, éy maniwala kam ta gemtén kua. Da éng méniwala kam ta gemtén ko, éy mapospusan moy a édse diyakén Tama ko, sakay sakén, éy édseék be diya.” ");
INSERT INTO dgc_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Nadid du te tungkulin a Judeo, pékabati de ta éya, éy talaga de siya a dekpén a huway; pero éwan, da nakahektat siya ta éya a bile. ");
INSERT INTO dgc_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Nagsoli man dén ti Jesus ta dibilew na Hordan a hanggan to pégbinyagen ni Juan to araw. Ey tinumulos sa siya. ");
INSERT INTO dgc_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ey meadu i inumangea sa diya. I kinagia du tolay sa, éy “Ti Juan, maski éwan siya nagimet ta kataka-taka,” kagi de, “éy katutuhanan a talaga i étanan a kinagi na tungkul ta lélake a éye.” ");
INSERT INTO dgc_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ey nadid éy meadu i naniwalaa ni Jesus ta éya. ");
INSERT INTO dgc_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Nadid, te lélake a nagkasakit. I ngahen naa éy ti Lasaro a taga Betania. Ey mégiyan be diya du wéwadi na a éduwa; ti Maria sakay ti Marta. ");
INSERT INTO dgc_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Na éya a Maria, éy siya ya tu néngibulak ta pulurida to tikéd no Panginoon, a tulos na pinahiden to buk na. ");
INSERT INTO dgc_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Kanya side, péketa de a garabi dén tu saket no aka de, éy pinauwet de ti Jesus, a kinagi de a, “Panginoon, te saket tu kadimoy mo a Lasaro.” ");
INSERT INTO dgc_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ey ti Jesus, pékabaheta na ta éya, éy kinagi na, a “I katapusan na éya a saket, éy éwan mate ti Lasaro, éngˈwan, tumanyag san i kapangyarian na Diyos, monda purién du tolay i anak na Diyos.” ");
INSERT INTO dgc_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Nadid, ti Jesus, éy mahal na de Marta a pépétwadi. ");
INSERT INTO dgc_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Pero maski mahal na side, éy pinalipas na pa i éduwa a aldew bagu sa inumange dide. ");
INSERT INTO dgc_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ey kélipas na éduwa a aldew, éy kinagi na du alagad na, a “Kitam dén sumoli ta Hudea.” ");
INSERT INTO dgc_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ey “Anin, Panginoon,” kagi du alagad na, “éingengaén ka pabi du mataas a Judeo ta éya a bunon, éy gustu mo bale sa a umange a huway?” ");
INSERT INTO dgc_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","“Pabayan moy,” kagi ni Jesus. “Ewan moy meta a te labindalawa a oras ta aldew bagu dumiklém? Nadid, éng mara méglakad i tolay ta aldew, éy éwan siya maanya, da tanglawan siya na demlag. ");
INSERT INTO dgc_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Basta éng kélép i péglakad naa, éy maanya siya, da éwan tu demlag diya.” ");
INSERT INTO dgc_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Kona sa i nihalimbawa na du alagad na, monda mapospusan de a éwan pabi siya maanya nadid ta Hudea. Sakay kinagi na be dide, a “Tidug dén tu kadimoy tam a Lasaro. Kanya umange kitam sa, éy angen ko siya lukagén.” ");
INSERT INTO dgc_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","“Ey Panginoon,” kagi du alagad, “éng tidug siya, éy maghusay siya a talaga.” ");
INSERT INTO dgc_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Kanya négkagi side ta kona sa, éy akala de a tidug san ti Lasaro ta mahusay. Pero éwan; i kahulugina no kinagi ni Jesus, éy minate dén. ");
INSERT INTO dgc_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Kanya nipáliwanag dide ni Jesus a kinagi na, a “Minate dén ti Lasaro. ");
INSERT INTO dgc_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ey alang-alang dikam,” kagi na, “éy mahusay da éwanék sa to nikate na, monda meta moy i manyari, a tumibay i péniwala moya diyakén. Ey nay,” kagi na, “kitam dén diya ya nadid.” ");
INSERT INTO dgc_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Nadid, ti Tomas a kambal, éy kinagi na du kaguman na, a “Nay, kumuyog kitam diya, maski mate kitam a étanan.” ");
INSERT INTO dgc_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Nadid, kédemét de Jesus ta Betania, éy épat dén a aldew a nielbéng ti Lasaro. ");
INSERT INTO dgc_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","I Betania, éy adene ta Jerusalem, a étélo san a kilumetro i kaadeyo naa. ");
INSERT INTO dgc_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Te meadu a taga Jerusalem a Judeo a dinumalaw de Marta a patwadi, monda wili-wilen de side dahilan to aka de a minate. ");
INSERT INTO dgc_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Nadid ti Marta, pékabaheta na a dumemét dén ti Jesus, éy inange na sinambat. Pero ti Maria a wadi na, éy nawahak san to bile. ");
INSERT INTO dgc_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ey késambat ni Marta ni Jesus, éy kinagi na, a “Anin, Panginoon, éng édse ka maka se to éya, éy éwan minate teka ko. ");
INSERT INTO dgc_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ey maski nadid,” kagi ni Marta, “éy tukoy ko a atdinan ka na Diyos ta maski anya i pékiohon mua diya.” ");
INSERT INTO dgc_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","“Mabuhay a huway teka mo,” kagi ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ey, “O,” kagi ni Marta, “tukoy ko a mabuhay siya ta pémuhay na Diyos ta tolay ta katapusan na mundua.” ");
INSERT INTO dgc_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","“Tandaan mo, Marta,” kagi ni Jesus; “sakén i magpabuhay ta tolay, sakay sakén i kégébwatan na buhay na tolay. Maski ti ésiya a méniwala diyakén, éng mate siya, éy mabuhay siya. ");
INSERT INTO dgc_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Sakay tu bawat tolay a buhay nadid a méniwala diyakén, éy éwan siya mate a hanggan. Méniwala ka Marta ta éya?” ");
INSERT INTO dgc_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ey “O, Panginoon. Méniwalaék a siko i Cristo a anak na Diyos. Tukoy ko a siko i pinaangea se na Diyos a tagapagligtas dikame.” ");
INSERT INTO dgc_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Nadid, to pégkagi ni Marta ta éya, éy inange na ti wadi na a Maria. Kinagi na diya ta lihim, a “Kéye dén tu Maistu, a nipauwet na ka.” ");
INSERT INTO dgc_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ey pékabaheta ni Maria ta éya, éy inumégkat siya agad i inange na sinambat ti Jesus. ");
INSERT INTO dgc_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ewan pabi dinumemét ti Jesus to bariyo, éngˈwan, édsa pabi to pinagkasambatan de ti Marta. ");
INSERT INTO dgc_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ey du Judeo a kaguman ni Maria to bile, péketa de a linumwas siya agad, éy tinumagubet side diya, da akala de éy umange to lébéng a magsanget. ");
INSERT INTO dgc_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Nadid ti Maria, kédemét na to édsean ni Jesus, éy tinumokém siya to tikéd na, a kinagi na, a “Panginoon, éng édse ka maka se to éya, éy éwan minate teka ko.” ");
INSERT INTO dgc_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Nadid ti Jesus, péketa na diya a mégsanget, pati du Judeo a kaguman na éy mégsanget be, éy métageg siya a tahod. ");
INSERT INTO dgc_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ey kinagi na dide, a “Ahe i néngielbéngan moya diya?” Ey “Kadon,” kagi de, “Ipeta me diko.” ");
INSERT INTO dgc_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Nadid, mégsanget be ti Jesus. ");
INSERT INTO dgc_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ey du Judeo, péketa de diya a mégsanget, éy “Entan moy,” kagi de, “talaga a ginustu na a tahod ti Lasaro.” ");
INSERT INTO dgc_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Sakay kinagi du iba, a “Nagpabulag ta buhék i lélake a ina. Anya wade,” kagi de, “kaya na wade be a nagpahusay ni Lasaro éng inabut na maka a buhay?” ");
INSERT INTO dgc_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Nadid, kédemét de Jesus to lébéng, éy mélungkut man dén siya a tahod. Tu lébéng éy kuweba a te takléb a bito to pintuan na. ");
INSERT INTO dgc_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ey kinagi ni Jesus, a “Bukasan moy dén i lébénga.” Ey sala ni Marta. “Anin, Panginoon,” kagi na, “épat dén siya a aldew a nielbéng. Mebuyok dén nadid.” ");
INSERT INTO dgc_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Pero kinagi ni Jesus, a “Ewan mo naala-ala, Marta, bakén a kinagi ko dén diko, éng méniwala ka éy meta mo i kapangyarian na Diyos?” ");
INSERT INTO dgc_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Nadid, binukasan de tu lébeng, a inibutan de tu takléb na a bito. Ey tinumangad ti Jesus a kinagi na, a “Salamat, Améng, da bébatenék mo. ");
INSERT INTO dgc_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Tukoy ko, Améng, a palagiék mo a bébaten. Pero ménalanginék diko ta medegsén nadid alang-alang di tolayae, monda maniwala side a siko i nagpaangea se diyakén ta munduae.” ");
INSERT INTO dgc_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Nadid, éy kinagi ni Jesus ta medegsén, a “Lasaro, lumwas ka dén!” ");
INSERT INTO dgc_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ey to pégkagi na, éy tulos a linumwas ti Lasaro a buhay dén, a te balut pabi tu kamét na sakay tu tikéd na to sapot na. Pati tu ulo na, éy te balut pabi to sapot na. “Nay,” kagi ni Jesus, “ibutan moy tu balut na a damit, sakay pabayan moy siya a méglakad.” ");
INSERT INTO dgc_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Nadid, meadu du kaguman ni Maria a Judeo a naniwala nadid ni Jesus, dahilan to ginamet na a mineta de. ");
INSERT INTO dgc_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pero te sénganya dide a dinumiretso san side du Pariseyo a binahetaan de side to ginimet ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Kanya du Pariseyo sakay du mataas a padi, pékabaheta de ta éya, éy nagmiting side, a néguhunan de ti Jesus. “Magenya kitam?” kagi de, “Meadu i gimet na a kataka-taka. ");
INSERT INTO dgc_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Eng éwan tam siya masaway, éy ipasakup diya du étanan a Judeo. Nadid, éng mabaheta na gubiyerno ta Roma a iba i amo tam, éy umange se side a talaga a hukatén de i Templo tama, sakay pati éy bunon de i étanan a Judeo.” ");
INSERT INTO dgc_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Nadid, mégkagi ti Kaipas. Siya i mataasa du padi ta éya a taon. I kinagi na, éy “Anya kam ye. éwan kam beman tu napospusan? ");
INSERT INTO dgc_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Maigi pa éy pabunu tam i éya a lélake alang-alang du tolay. Maigi pa éy mate siya kesira dikitam a étanan a Judeo.” ");
INSERT INTO dgc_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","I éya a kinagi ni Kaipas, éy éwan ta isip na sana, éngˈwan, da siya i mataas a padi nadid, éy pinahula diya na Diyos a mate ti Jesus alang-alang du Judeo. ");
INSERT INTO dgc_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ey éwan san Judeo, éngˈwan mate be siya alang-alang du anak na Diyos maski ta ahe ta mundua, monda mapisan side a étanan. ");
INSERT INTO dgc_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Nadid, sapul ta éya a miting de, éy néguhunan du te tungkulin a Judeo éng pakodyan de a ipabuno ti Jesus. ");
INSERT INTO dgc_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kanya ti Jesus, éy éwan dén pinumeta a naglakad ta Hudea. Engˈwan inumange dén side du alagad na ta Epraim ta digdig na ilang a lugar. Ey négiyan sa side. ");
INSERT INTO dgc_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Nadid, adene a dumemét i Piyesta na Ala-ala na Judeo, éy meadu i inumange a tolay ta Jerusalem, monda tupadén de tu utus ni Moises tungkul ta péglinis ta bégi. ");
INSERT INTO dgc_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ey inahayok de sa ti Jesus, da umasa side a dumemét be siya ta piyesta. Néguhunan de siya ta Templo éng dumemét siya, o éng éwan. ");
INSERT INTO dgc_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ey du mataas a padi sakay du Pariseyo, éy kinagi de du tolay éng ti ésiya i makapospusa ta édsean ni Jesus, éy dapat ibaheta na dide, monda madikép de siya. ");
INSERT INTO dgc_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Nadid éném a aldew bagu Piyesta na Ala-ala, éy dinumemét ti Jesus ta Betania. Saya i bariyua a nangbuhayan na ni Lazaro. ");
INSERT INTO dgc_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Kédemét na éy nipaghanda de siya ta pangapon na. Ey naglamesa ti Marta ta nénganan de, éy ti Lasaro éy édsa be sa a méngan. ");
INSERT INTO dgc_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ey ti Maria, éy inalap na tu esa a boti a memahal a pulurida, a nibulak na to tikéd ni Jesus, sakay pinahiden na to buk na. Ey linumaganap tu sapot na ta étanan a lubuk no bile. ");
INSERT INTO dgc_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Nadid ti Hudas Iskarote, éy kinagi na, a ");
INSERT INTO dgc_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Bakit éwan nipabugtong i ina a pulurida ta étélo a datos a kuhata, sakay niatéd tam maka du mahirap i kabugtungan naa?” ");
INSERT INTO dgc_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Pero éwan kanya kinagi ni Hudas i kona sa éy kinagbian na du mahirap. Engˈwan, monda san éy makaalap siya ta kuhata de. Da dati a ugali na a mégbawas ta kapisanan de a kuhata. ");
INSERT INTO dgc_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ey kinagi ni Jesus ni Hudas, a “Pabayan mo siya, da handa na ye ta aldew a péglébéng diyakén. ");
INSERT INTO dgc_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Palagi a te tolay a mahirap a maari moy a matulungan,” kagi na, “pero sakén éy éwanék se dikam male.” ");
INSERT INTO dgc_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Nadid, du meadu a Judeo a mémiyesta ta Jerusalem, pékabaheta de a dinumemét dén ti Jesus ta Betania, éy inumange be sa side. Gustu de a meta ti Jesus, sakay gustu de be a meta ti Lasaro a pinabuhay na. ");
INSERT INTO dgc_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Dahil ni Lasaro, éy meadu a Judeo a pinabayan de dén du amo de a padi, a méniwala dén side ni Jesus. Kanya du padi, éy ginayak de be a bunon ti Lasaro. ");
INSERT INTO dgc_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Nadid, to kagagabian na éya, éy du meaadu a tolay a mémiyesta ta Jerusalem, éy nabaheta de a dumemét dén ti Jesus. ");
INSERT INTO dgc_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Kanya linumwas side ta banuwan a sambatén de. Ey te kébil side a don na kayo. Ey pékasambat de diya, éy binate de siya, a “Mabuhay,” kagi de, “basbasan maka na Diyos i lélakeae a pinaange na se! Basbasan maka na Diyos i hariae na Israel!” ");
INSERT INTO dgc_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Nadid, neta ni Jesus tu bul-o a kabayo a sinakayan na. Ey i éya a gimet, éy siya bale ya i nangtupada to hula a dati ta kasulatan na Diyos. I kagia na éya a hula, éy ");
INSERT INTO dgc_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Diyan kam kan méganteng, sikam a taga Jerusalem. Entan moy, ta kédemét na hari moy, éy mangabayo kan siya ta bul-o a kabayo.” ");
INSERT INTO dgc_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Du alagad na, éy éwan de naala-ala ta éya a aldew i hula a éya. Pero to késoli dén ni Jesus ta langet, éy naala-ala de a neta de a natupad bale dén to péngiangkas de ni Jesus to kabayo. ");
INSERT INTO dgc_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Nadid, du tolay a édse to lébéng ni Lasaro to péngbuhay diya ni Jesus, éy side i nagbahetaa du étanan a édse ta Jerusalem. ");
INSERT INTO dgc_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Kanya meadu a tahod dudu sinumambat ni Jesus, dahilan tu nabaheta de a ginamet na. ");
INSERT INTO dgc_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ey du Pariseyo, péketa de a mégdulug du tolay diya, éy kinagi de, a “Entan moy, natalo na kitam, da meadu a tahod i mégduluga diya a tolay!” ");
INSERT INTO dgc_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Nadid, i kagumana du Judeo a inumange ta Jerusalem a sumamba ta Diyos, éy sénganya wade a Griego. ");
INSERT INTO dgc_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Diden ya a Griego, éy inumange side ni Pelip, a kinagi de, a “Eng maari, éy mékiohon kame pad ni Jesus.” (ti Pelip, éy taga Betsayda, Galilea.) ");
INSERT INTO dgc_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Kanya ti Pelip, éy kinagi na ni Andres tu gustu du Griego, a tulos de a éduwa a kinagi ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ey ti Jesus, pékabati na ta éya, éy kinagi na, a “Dumemét ngani dén nadid i oras a ipaliwanag na Diyos a sakén i lélake a gébwat ta langet. ");
INSERT INTO dgc_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Tandaan moy,” kagi na, “mara tu esa a butil na pahay, éngˈwan memula ta luta, éy éwan tu pasa. Pero éng metépduk ta luta éy kumadu i bunga na ta meadu. ");
INSERT INTO dgc_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Nadid i tolay: maski ti ésiya a mégmahal ta bégi na, éy mebut a talaga. Pero siya a magpabaya ta bégi na, éy siya i mabuhay a éwan tu katapusan. ");
INSERT INTO dgc_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Kanya maski ti ésiya a tunay a utusan ko,” kagi ni Jesus, “éy kailangan a umunonod siya diyakén. Nadid éy kaguman ko siya a palagi ta édsean ko. Sakay éng méniwala siya diyakén, éy atdinan siya Nama ko ta gantimpala na. ");
INSERT INTO dgc_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Nadid,” kagi ni Jesus, “éy métagigék tu isip. Ey anya wade i panalangin ko Nama ko? Panalangin ko maka a agawénék na ta kahirapan ko? Ewan, da saya i hangad kua a umange ta mundua, a magtiis ta hirap.” ");
INSERT INTO dgc_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Nadid nanalangin ti Jesus a kinagi na, a “Améng, ipeta mo i kapangyarian mo ta tolay.” Ey to pégkagi na ta éya, éy te boses ta langet a kagi na, a “Nipeta ko dén i kapangyarian kua to ginamet mo. Ey nadid, éy ipeta ko man dén.” ");
INSERT INTO dgc_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nadid du tolay sa, éy nabati de be i boses ta langet, a akala de éy mégkéduh. Pero “Bakén a kéduh,” kagi du iba, “pinégkagian siya no anghel.” ");
INSERT INTO dgc_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ey kinagi ni Jesus dide, a “Kanya négkagi ta kona sa éy éwan alang-lang diyakén, éngˈwan para dikam, monda mapospusan moy a gébwaték ta Diyos. ");
INSERT INTO dgc_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Dumemét dén nadid i oras a hukumén dén i mundua. Sakay ti Satanas a amo na tolay ta mundua, éy adene dén a matalo, a ibut dén siya. ");
INSERT INTO dgc_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ey sakén,” kagi ni Jesus, “ta péngiekpét de diyakén ta te tolnék a kayo, éy paadeneén ko i étanan a tolay diyakén a ipasakup diyakén.” ");
INSERT INTO dgc_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Kinagi ni Jesus i éya a monda tukoy du tolay éng kodya i kate naa. ");
INSERT INTO dgc_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nadid kinagi du tolay ni Jesus, a “Isip me kagi na libru na Diyos a mabuhay kan i tagapagligtas a éwan tu katapusan. Nadid, tu nginahinan mo a lélake a gébwat ta langet, éng siya i tagapagligtas éy bakit kagi mo a mate siya ta kayo? Ti ésiya i lélake a gébwat ta langet?” kagi de. ");
INSERT INTO dgc_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ey kinagi ni Jesus, a “Kétihék san dén a panahun a kaguman moy i Demlag. Kanya sugsugén moy i Demlag, o makay abutén kam na diklém. Da maski ti ésiya a méglakad ta diklém, éy éwan na tukoy i angayan na. ");
INSERT INTO dgc_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Kanya sikam, éy méniwala kam ta Demlag bagu na kam ginanan, monda sikam, éy bilang anak kam na Demlag.” Nadid, to pégkagi ni Jesus ta éya, éy gininanan na du tolay a linumiso siya dide. ");
INSERT INTO dgc_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ey du tolay, éwan side naniwala ni Jesus, maski ginimet na ta harap de i meadu a kataka-taka. ");
INSERT INTO dgc_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Kanya nadid, tu nihula ni Purupeta Isayas to araw, éy natupad dén. I kinagi na to libru na, éy: “Panginoon, éwan tu naniwala to nibaheta me dide. Maski nipeta me dide i kapangyarian na Diyos, éy éwan side naniwala.” ");
INSERT INTO dgc_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Kanya éwan maari a méniwala side, éy tu kinagi ni Isayas a “iba, a ");
INSERT INTO dgc_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","binuhék kan side na Diyos, sakay pinaktog na kan be tu isip de, monda éwan de maisipan ta mahusay, monda éwan side ipasakup ta Diyos a iligtas na side.” ");
INSERT INTO dgc_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Kanya kinagi ni Isayas i éya, éy neta na to araw i pagkadiyos ni Cristo, a tulos na nibaheta siya. ");
INSERT INTO dgc_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Kona man sa, éy meadu be a te tungkulin a Judeo a méniwala diya. Pero lihim san. Ewan de ipégtapat du kaguman de, da méganteng side du Pariseyo. Makay ibutan de side to kapilya. ");
INSERT INTO dgc_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Diden ya a tolay a kona sa éy gustu de a purién side na tolay kesira ta purién side na Diyos. ");
INSERT INTO dgc_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Nadid, kinagi ni Jesus ta medegsén, a “Maski ti ésiya a méniwala diyakén, éy éwan san sakén i péniwalaan naa, éngˈwan pati tu nagpaange se diyakén a Diyos. ");
INSERT INTO dgc_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Sakay pati, tu méketa diyakén, éy meta na be tu nagpaange se diyakén. ");
INSERT INTO dgc_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Sakén i Demlag a inumange ta mundua,” kagi na. “Maski ti ésiya a maniwala diyakén, éy éwan siya manatili ta diklém. ");
INSERT INTO dgc_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nadid du makabati ta kagi kua, pero éwan de tupadén, éy éwan sakén i maghukuma dide. Da éwanék se inumange a maghukum ta tolay ta mundua, éngˈwan i hangad kua se, éy magligtas ta tolay. ");
INSERT INTO dgc_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Pero du mégidel diyakén sakay ta pégtoldu ko, éy hukumén side a talaga ta katapusan na mundua. I magpahukuma dide éy tu kagi ko. ");
INSERT INTO dgc_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Tama ya,” kagi ni Jesus, “dahilan éwanék négkagi ta sarili ko san a isip, éngˈwan Tama ko i nagutusa éng anya i kagin kua ta tolay. ");
INSERT INTO dgc_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Tukoy ko i utus Nama ko a saya i mangatéda ta buhay a éwan tu katapusan. Kanya kékagin ko ta tolay i niutus diyakén Nama ko.” ");
INSERT INTO dgc_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Nadid, éy disperas dén na Piyesta na Ala-ala. Ey tukoy dén ni Jesus a oras dén nadid a humektat siya ta mundua a sumoli dén Nama na ta langet. Sapul to éya, éy mahal ni Jesus du alagad na. Ey nadid, maski da adene siya a mate, éy nipeta na dide éng hanggan ta ahe i pégmahal naa dide. ");
INSERT INTO dgc_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","To péngan de, éy nipaisip dén ni Satanas ni Hudas Iskarote a itokyon na ti Jesus (ti Hudas a anak ni Simon). ");
INSERT INTO dgc_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ti Jesus, éy tukoy na a inatdinan siya na Diyos ta kapangyarian na ta étanan. Tukoy na a gébwat siya ta Diyos, sakay tukoy na be a sumoli ta Diyos. ");
INSERT INTO dgc_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Kanya nadid, to péngapon de, éy tinumaknég ti Jesus, a inékbus na tu badu na sakay minagken ta tuwalya. ");
INSERT INTO dgc_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Nadid nibulak na tu dinom to palanggana, sakay tulos na inugisan tu tikéd du alagad na a tégitégesa, sakay pinahiden na side to pinagkenan na a tuwalya. ");
INSERT INTO dgc_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Nadid, kéadene na ni Simon Pedro, éy kinagi ni Pedro, a “Diyan mo ugisan i tikéd kua, Panginoon, mésanikeék!” ");
INSERT INTO dgc_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","“Ewan mo pabi tukoy nadid, Pedro, i gimet ko a éye,” kagi ni Jesus, “pero ta esa a panahun, éy tukoy mo dén.” ");
INSERT INTO dgc_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","“Ewan,” kagi ni Pedro; “maski nikésiya, éy éwan ko ipauges diko i tikéd kua.” “Eng éwan ka ipauges diyakén, Pedro, éy éwan ka mékiagum diyakén a alagad ko.” ");
INSERT INTO dgc_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","“Eng kona sa, Panginoon,” kagi ni Pedro, “éy éwan san na tikéd kua, éng éwan pati na kamét kua éy ta ulo kua!” ");
INSERT INTO dgc_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","“Ewan,” kagi ni Jesus. “Mara tu bigu a négdigus, éy éwan siya tu kailangan a ugisan na tu bégi na, éngˈwan tu tikéd na san. Ey sikam, melinis kam dén. Basta isesa san dén i melégi dikam.” ");
INSERT INTO dgc_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Tukoy ni Jesus a te méngitokyon diya a esa dide, kanya kinagi na a te esa dide a melégi. ");
INSERT INTO dgc_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Nadid, to pénguges na to tikéd de, éy nisolot na tu badu na, sakay nagsoli dén to bangko na to lamesa. Sakay kinagi na dide, a “Natukoy moy wade i ginamet kua dikam? ");
INSERT INTO dgc_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Dédulawénék moy a Maistu, sakay dédulawénék moy a Panginoon. Ey tama ya,” kagi na, “da sakén ngani i Maistu moy éy ta Panginoon moy. ");
INSERT INTO dgc_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nadid, éng sakén i Panginoon moy éy ta Maistu moy, sakay inugisan ko be i tikéd moya, éy dapat a néguge-ugisan kam be ta tikéd moya. ");
INSERT INTO dgc_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Halimbawa ya tu ginamet ko dikam, monda i éya éy dapat moy a ahigén, a magpakabait kam be du kaguman moy. ");
INSERT INTO dgc_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Tandaan moy, mara tu bataan,” kagi ni Jesus, “éy éwan siya mataas to amo na. Sakay tu utusan, éy éwan siya mataas ta mégutus diya. ");
INSERT INTO dgc_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nadid, éng mapospusan moy i éye a kinagi ko dikam, sakay éng tupadén moy, éy masuwerte kam a talaga. ");
INSERT INTO dgc_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Pero éwanék mégkagi tungkul dikam a étanan.” kagi ni Jesus, “da te esa dikam a éwan masuwerte. Tukoy ta kam a pinili ko, a te esa dikam a méngitokyon diyakén. Saya i mangtupada to kagi ta kasulatan, a taraidorénék kan no kaguman ko a kadipon ko. ");
INSERT INTO dgc_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ey nadid, ihula ko ye dikam bagu manyari, monda éng manyari, éy maniwala kam a sakén i tagapagligtas a tiniyak na Diyos. ");
INSERT INTO dgc_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Tandaan moy be ye,” kagi ni Jesus; “maski ti ésiya a tumanggap ta utusan ko, éy bilang tinanggapék na be. Sakay tu tumanggap diyakén, éy bilang tinanggap na be tu nagpaange se diyakén.” ");
INSERT INTO dgc_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Nadid, kétapos ni Jesus a négkagi ta éya, éy métageg siya, a kinagi na du alagad na, a “Katutuhanan a te esa dikam a méngitokyon diyakén.” ");
INSERT INTO dgc_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ey du alagad, pékabati de ta éya, éy néglamilameng side, da éwan de napospusan éng ti ésiya i pinégkagian naa. ");
INSERT INTO dgc_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Nadid, tu esa a alagad ni Jesus a mahal na, éy te eknud to tagirilan ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ey sinenyasan siya ni Pedro, a kinagi na, a “Pakelagipan mo éng ti ésiya i négkagian naa.” ");
INSERT INTO dgc_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Kanya tu alagad, éy sinumangdih siya to salapad ni Jesus, a “nipakelagip na éng ti ésiya i négkagian naa?” ");
INSERT INTO dgc_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ey kinagi ni Jesus, a “Entan moy, isawsaw ko i tinapayae ta sabawae, sakay iatéd ko diya.” Nadid, to péngisawsaw na to tinapay, éy niatéd na ni Hudas a anak ni Simon Iskarote. ");
INSERT INTO dgc_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Nadid, to pénanggap ni Hudas to tinapay, éy tulos inumasék ti Satanas diya. Ey kinagi ni Jesus diya, a “Ikad mo dén a gemtén mo agad i gayak mua.” ");
INSERT INTO dgc_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Du alagad a iba to lamesa, éy éwan de tukoy éng bakit kinagi na ya ni Hudas. ");
INSERT INTO dgc_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Akala de san a inutusan na siya a mamugtong ta kailangan de ta piyesta. Kanya isip de i kona sa, éy ti Hudas i bahala ta kuhata de. Sakay isip du iba, éy inutusan na siya a umange maglimos du mahirap. ");
INSERT INTO dgc_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ey ti Hudas, to pénanggap na to tinapay, éy binuméswal dén. Ey kélép dén nadid. ");
INSERT INTO dgc_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Nadid, kinagi ni Jesus, a “Sakén i lélake a gébwat ta langet. Ey nadid i orasa a atdinanék na Diyos ta pagkadiyos ko. Ey mehayag be dén i kapanyarian na Diyos dahil ta gimet kua. ");
INSERT INTO dgc_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ey nadid, éng mehayag i kapangyarian na Diyos dahil diyakén, éy ipahayagék be agad na Diyos. ");
INSERT INTO dgc_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Sikam a mahal ko a anak ko,” kagi ni Jesus, “éy kétihék san dén a panahun i pékiagum kua dikam. Ahayukénék moy, pero kagin ko dikam tu kinagi ko du Judeo, a éwan kam makaange ta angayan kua. ");
INSERT INTO dgc_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nadid,” kagi na, “éy atdinan ta kam ta bigu a utus: négmahalan kam. Eng kodya i pénggustu kua dikam, éy kona be sa i négagum moya. ");
INSERT INTO dgc_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Saye i pégpatunay moya du iba a tolay a sikam i alagad ko--éng négmahalan kam.” ");
INSERT INTO dgc_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ey “Anya, Panginoon,” kagi ni Pedro. “Ahe i angayan mua a talaga?” Ey kagi ni Jesus, a “Ewan kam makakuyog diyakén nadid ta angayan kua, pero ta esa a panahun, éy tumagubet kam diyakén ta éya.” ");
INSERT INTO dgc_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","“Ey bakit éwanék makakuyog diko nadid, Panginoon,” kagi ni Pedro. “Iatéd ko i buhay ko alang-alang diko.” ");
INSERT INTO dgc_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","“Anya wade, iatéd mo i buhay mo alang-alang diyakén a talaga, Pedro? Ewan. Tandaan mo, bagu magtarakot tu tandang nadid a amulaldew, éy tanggianék mo ta pentélo a éwanék mo kaguman.” ");
INSERT INTO dgc_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Diyan kam métageg tu isip,” kagi ni Jesus. “Maniwala kam san ta Diyos, sakay maniwala kam be diyakén. ");
INSERT INTO dgc_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","3","I bilea Nama ko, éy meadu a kwa-kwarto. Ey umangeék sa a maghanda ta para koo moy. Ey nadid, ta pékahanda ko dén ta para koo moy, éy magsoliék se a angen ta kam, monda négpisan kitam ta édsean kua. Ey éwan ko ya kinagi dikam éng éwan katutuhanan. ");
INSERT INTO dgc_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ey sikam, tukoy moy dén i dilan a tamo ta angayan kua.” ");
INSERT INTO dgc_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","“Ewan, Panginoon,” kagi ni Tomas, “éwan me tukoy i angayan mua. Pakodyan me a mapospusan i dilan?” ");
INSERT INTO dgc_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","“Sakén i dilan,” kagi ni Jesus. “Sakén i mégpaliwanag ta katutuhanan. Sakay sakén i kégébwatan na buhay na tolay. Ewan tu makaange Nama ko éng éwan sakén i magpaangea sa diya. ");
INSERT INTO dgc_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Eng tukoyék moy, éy tukoy moy be dén Tama ko. Ey sapul nadid, éy tukoy moy dén siya, sakay neta moy be dén siya.” ");
INSERT INTO dgc_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","“Ey Panginoon,” kagi ni Pelip, “Ipeta mo dikame Tama mo, éy tama dén dikame.” ");
INSERT INTO dgc_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","“Naleék dén a nékiagum dikam, Pelip,” kagi ni Jesus, “éy éwanék moy bale pabi tukoy? Bakit gustu mo a ipeta ko dikam Tama ko? Ewan moy beman tukoy tu naketa diyakén, éy neta na be dén Tama ko? ");
INSERT INTO dgc_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Bakit, Pelip, éwan ka pabi méniwala a édseék Nama ko, sakay siya éy édse be diyakén? Entan moy,” kagi na du alagad na, “tu kinakagi ko dikam, éy éwan ta isip ko a sarili, éngˈwan Tama ko a mégiyan diyakén, siya i mégpatarabahua diyakén ta kaluuben na. ");
INSERT INTO dgc_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Dapat maniwala kam to kinagi ko, a édseék Nama ko, sakay siya, éy édse be diyakén. Pero éng éwan kam maniwala ta éya, éy dapat a maniwala kam dahil to tarabaho ko. ");
INSERT INTO dgc_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Tandaan moy; maski ti ésiya a maniwala diyakén, éy meaheg ta tarabaho kua. Sakay gemtén na be i mahigit pa ta tarabaho ko, da méglakadék dén Nama ko ya. ");
INSERT INTO dgc_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nadid, maski anya i agidén moya ta Diyos da méniwala kam diyakén, éy atdinan ta kam a talaga, monda ipeta ko i kapangyarian Nama ko. ");
INSERT INTO dgc_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kanya maski anya i agidén moya da méniwala kam diyakén, éy gemtén ko.” ");
INSERT INTO dgc_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Nadid, kinagi na du alagad na, “Eng gustuék moy, éy sundin moy i utus kua. ");
INSERT INTO dgc_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ey sakén, éy manalanginék Nama ko a atdinan na kam ta Espiritu na a kalewas ko, a siya i Katulung moy, a kaguman moy a éwan tu katapusan. ");
INSERT INTO dgc_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Siya ya i Banal a Espiritu na Diyos, a magpaliwanang ta katutuhanan. Du iba a tolay ta mundua, éy éwan de siya tanggapén, da ewan de meta, sakay éwan de siya tukoy. Pero sikam, éy tukoy moy siya, da ménatili siya dikam sakay mégiyan siya dikam. ");
INSERT INTO dgc_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Ewan ta kam pébayan,” kagi ni Jesus, “éngˈwan sumoliék dikam. ");
INSERT INTO dgc_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Kétihék san dén a panahun, éy éwanék dén metan na iba a tolay. Pero sikam, éy metaék moy a huway. Ey nadid, da te buhayék a éwan tu katapusan, éy kona kam be sa. ");
INSERT INTO dgc_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Nadid, kédemét na éya a oras, éy mapospusan moy a édseék Nama ko. Sakay sikam, éy édse kam diyakén. Sakay sakén, éy édseék be dikam. ");
INSERT INTO dgc_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nadid,” kagi na, “maski ti ésiya a mananggap ta utus kua, a sundin na, éy siya i mégmahala diyakén. Ey nadid, tu mégmahal diyakén, éy mahalén be siya Nama ko. Sakay sakén, éy mahalén ko be siya, a ipaliwanag ko diya i sarili ko.” ");
INSERT INTO dgc_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Nadid, te négkagi ni Jesus a ti Hudas, a i Hudas a éye, éy bakén a ti Hudas Iskarote. I kinagi naa éy, “Panginoon, bakit ipaliwanag mo dikame i sarili mo, pero éwan mo ipaliwanang du iba a tolay ta mundua?” ");
INSERT INTO dgc_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","“Eng mahalék na tolay,” kagi ni Jesus, “éy sundin na i kagi kua, éy mahal siya Nama ko. Ey sikame Tama ko, éy umange kame diya a mégiyan kame diya. ");
INSERT INTO dgc_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Sakay tu tolay a éwan méngmahal diyakén, éy éwan na sundin i kagi kua. Ey tandaan moy,” kagi ni Jesus, “i kinékagi kua dikam, éy éwan gébwat diyakén, éngˈwan kagi ya Nama ko. Siya i nagutusa diyakén. ");
INSERT INTO dgc_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Nadid,” kagi na, “éy kagin ko dén ye dikam habang kaguman ta kam pabi. ");
INSERT INTO dgc_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ey ta péngginan ko dikam, éy paangen se Nama ko i Banal a Espiritu alang-alang diyakén. Siya i Katulung moy. Magpaliwanang siya dikam ta étanan, a ipaala-ala na dikam i étanan a kinékagi ko dikam. ");
INSERT INTO dgc_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Nadid, i iwahak kua dikam, éy kapayapaan. Pero du tolay ta mundua, éy éwan side makapangatéd dikam ta kapayapaan. Pero sakén, éy iatéd ko dikam i kapayapaan kua. Kanya diyan kam métageg tu isip, sakay diyan kam méganteng. ");
INSERT INTO dgc_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nabati moy dén tu kinagi ko,” kagi ni Jesus, “a umangeék ta iba a lugar, pero sumoliék dikam. Kanya diyan kam malungkut. Eng gustuék moy a talaga éy masaya kam be, da méglakadék dén Nama ko ya. Ey siya, éy mataas siya diyakén. ");
INSERT INTO dgc_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Kinagi ko ya dikam bagu manyari, monda éng manyari, éy maniwala kam diyakén. ");
INSERT INTO dgc_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nadid, kétihék san dén a panahun, éy éwanék dén huway a mégkagi dikam, da dumemét dén i amo na tolay ta mundua, a ti Satanas. Ewan siya tu kapangyarian diyakén, ");
INSERT INTO dgc_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","éngˈwan tupadén ko san i niutus diyakén Nama ko, monda meta du tolay a mahal ko Tama ko. Nay, tapusék dén a mégkagi,” kagi ni Jesus. “Umégkat kam dén a kitam dén.” ");
INSERT INTO dgc_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Nadid, kinagi ni Jesus, a “Mara tu kayo a ubas, éy sakén i ponan na. Sakay Tama ko, siya i mégalagaa diya. ");
INSERT INTO dgc_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nadid, bawat sanga-sanga ko a éwan mégbunga, éy kétulén Nama ko. Sakay bawat sanga ko a mégbunga, éy pungusan na, monda magbunga ta mas mahigit pa. ");
INSERT INTO dgc_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nadid, sikam a alagad ko, éy melinis kam dén, dahilan to kinagi ko dikam a kagi. ");
INSERT INTO dgc_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Nadid, manatili kam diyakén, sakay sakén éy manatiliék be dikam. Mara tu sanga no kayo éy éwan makapagbunga éng éwan manatili to ponan na. Ey kona be sa dikam, a éwan kam be makapagbunga éng éwan kam manatili diyakén. ");
INSERT INTO dgc_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Mara sakén i ponan na kayo,” kagi ni Jesus. “Sikam i sanga-sanga ko. Nadid, tu manatili diyakén, sakay manatiliék be diya, éy siya i magbunga ta meadu, da éwan kam makagimet ta maski anya éng mehiwalay kam diyakén. ");
INSERT INTO dgc_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Kanya éng éwan manatili i tolay diyakén, éy ibut siya a koman i sanga no kayo, a hanggan malanés. Ey nadid, iduhu de i kona sa a sanga-sanga, sakay ibut de dén ta apoy, monda matutod side. ");
INSERT INTO dgc_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ey nadid sikam,” kagi ni Jesus, “éng manatili kam diyakén, sakay manatili be i kagi kua ta isip moya, éy maari kam a magaged ta maski anya a gustu moy, éy iatéd dikam a talaga. ");
INSERT INTO dgc_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Sakay éng magbunga kam ta meadu, éy saya i magpahayaga ta kapangyarian Nama ko. Sakay saya i katunayan moya a sikam i alagad ko a talaga. ");
INSERT INTO dgc_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nadid, éng kodya i pénggustua diyakén Nama ko, éy kona be sa i pénggustu kua dikam. Ey sikam, éy diyan moy pébayan i pénggustu kua dikam. ");
INSERT INTO dgc_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Entan moy, gustuék Nama ko a palagi, da sinunud ko dén i utus naa. Nadid, éng kona kam be sa, a sundin moy i utus kua, éy gustu ta kam be a palagi. ");
INSERT INTO dgc_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Nadid,” kagi na du alagad na, “kinagi ko dén ya dikam monda édse dikam i kasayaan ko, monda masaya kam be ta mahusay. ");
INSERT INTO dgc_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Saye i utus kua dikam, a négmahalan kam a kona ta pégmahal kua dikam. ");
INSERT INTO dgc_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Mara éng te tolay a iatéd na i buhay na alang-alang to kadimoy na, éy saya i katunayan naa a mahal na siya a tahod. ");
INSERT INTO dgc_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ey sikam i kadimoy ko a talaga, éng sundin moy i utus kua dikam. ");
INSERT INTO dgc_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Sapul nadid, éy éwan ta kam dulawén a utusan ko, éngˈwan dulawén ta kam a kadimoy ko. Dahilan du utusan, mara éwan de tukoy i gimet no amo de, da éwan na ikagi dide. Pero sakén, éy nipaliwanag ko dén dikam i étanan a kinagi diyakén Nama ko. ");
INSERT INTO dgc_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Tandaan moy,” kagi ni Jesus; “éwanék moy pinili a sakén i amo moy, éngˈwan sakén i nagpilia dikam. Sakay inutusan ta kam a magbunga ta meadu a bunga a éwan malipas, monda atdinan kam Nama ko ta maski anya i agidén moya diya, da méniwala kam diyakén. ");
INSERT INTO dgc_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ey saye i utus kua dikam, a négmahalan kam. ");
INSERT INTO dgc_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Tandaan moy,” kagi ni Jesus, “éng maiyamut dikam du iba a tolay, éy alélahanén moy a naiyamut pa side diyakén bagu side naiyamut dikam. ");
INSERT INTO dgc_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Mara éng sakup kam du iba a tolay ta mundua, éy gustu de kam be, da gustu du iba a tolay i kapareho de. Pero éwan, da pinili ta kam a nibukod ta kam dide. Kanya méiyamut side dikam, da éwan kam dén ipasakup dide. ");
INSERT INTO dgc_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Diyan moy kaleksapan tu kinagi ko dikam, a éwan mataas tu bataan to amo na. Kanya éng linokoék de éy lélokon de kam be. Eng tinupad de i kagi kua, éy tupadén de be i kagi moya. ");
INSERT INTO dgc_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Kanya mangloko side dikam, éy dahilan éy sakup ta kam. Inidelanék de, da éwan de tukoy tu nagpaange se diyakén. ");
INSERT INTO dgc_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Mara éng éwanék se inumange a nagtoldu dide,” kagi ni Jesus, “éy éwan maka side tu kasalanan. Pero nadid, éy éwan side tu katuwiran ta kasalanan de. ");
INSERT INTO dgc_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ey tu méiyamut diyakén, éy méiyamut be Nama ko. ");
INSERT INTO dgc_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Eng éwanék nagimet ta harap de ta éwan mégimet na tolay, éy éwan side tu kasalanan. Pero nadid te kasalanan side, da maski neta de i gimet ko a kataka-taka, éy méiyamut side dikame Tama ko. ");
INSERT INTO dgc_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Saye i mangtupada to kagi ta kautusan de, a éwan kan side tu katuwiran a maiyamut diyakén.” ");
INSERT INTO dgc_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ta kédemét na Katulung éy siya i méngipahayaga diyakén. Siya i Espiritu a gébwat Nama ko, a magpaliwanag ta katutuhanan. Ey sakén i magpaangea se diya. ");
INSERT INTO dgc_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Sakay sikam, éy magpahayag kam be diyakén, da sikam i kinumuyuga diyakén sapul to sapul. ");
INSERT INTO dgc_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Ey nadid, kinagi ko dén dikam i éya a étanan, a monda éwan maibut tu péniwala moy diyakén. ");
INSERT INTO dgc_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Entan moy,” kagi ni Jesus du alagad na, “dumemét i oras a paibutén de kam du kapilya de. Sakay pati, ta esa a panahun, éy te tolay a mégakala side a makatulung ta Diyos éng bunon de kam. ");
INSERT INTO dgc_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Kona sa i péngloko dia dikam, da éwan de tukoy Tama ko, sakay éwanék de be tukoy. ");
INSERT INTO dgc_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nadid, kinagi ko dén ya dikam, monda kédemét na oras a pékialaman de kam, éy maala-ala moy a nihula ko dén ye dikam. “Ewan ko kinagi dikam i éya to sapul, da kaguman ta kam pabi. ");
INSERT INTO dgc_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Pero nadid, éy kinagi ko dén dikam, da magsoliék dén ta minagpaange se diyakén. Nadid, éwan moy ipakelagip diyakén éng ahe i angayan kua. ");
INSERT INTO dgc_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Engˈwan, mélungkut kam san dahilan to kinagi ko dikam. ");
INSERT INTO dgc_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pero entan moy, kagin ko dikam i katutuhanan, a kaigian moy ye da maglakadék dén. Eng éwanék méglakad, éy éwan umange dikam tu Katulung moy. Pero éng méglakadék dén, éy paangen ko siya dikam. ");
INSERT INTO dgc_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ey kédemét na Katulung moy,” kagi ni Jesus, “éy ipaliwanag na du tolay ta mundua tungkul ta kasalanan de, sakay ta tama a gimet, sakay ta péghukum na Diyos. ");
INSERT INTO dgc_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ipaliwanag na dide a te kasalanan side, da éwan side méniwala diyakén. ");
INSERT INTO dgc_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ipaliwanag na dide a tama i gimet ko, da magsoliék dén Nama ko, éy éwanék moy meta a huway. ");
INSERT INTO dgc_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ipaliwanag na dide a hukumén side na Diyos, da hukumén dén i amo na tolay ta mundua. ");
INSERT INTO dgc_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Te meaduék pabi a itoldu dikam,” kagi ni Jesus du alagad na, “pero éwan pabi nadid, da éwan moy pabi kaya a mapospusan nadid. ");
INSERT INTO dgc_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Pero kédemét na Espiritu a magpaliwanag ta katutuhanan, éy ipaliwanag na dikam i buu a katutuhanan. Siya, éy éwan mégkagi ta sarili na a isip, éngˈwan ipaliwanag na san i kinagi na Diyos diya. Sakay ipaliwanag na be dikam i manyari ta esa a panahun. ");
INSERT INTO dgc_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Siya i magpahayaga ta kapangyarian ko, da alapén na be i kagi ko a tulos na itoldu dikam. ");
INSERT INTO dgc_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","I étanan a koo Nama ko, éy koo ko be,” kagi ni Jesus. “Kanya kinagi ko a alapén na Espiritu tu kagi ko, a itoldu na ya dikam. ");
INSERT INTO dgc_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Kétihék san dén a panahun éy éwanék moy dén meta. Nadid lumipas i kétihék man dén a panahun éy metaék moy man dén.” ");
INSERT INTO dgc_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Nadid, pékabati du alagad na ta éya a kinagi na, éy négpakipakelagip side, a kinagi de, a “Bakit kagi na a kétihék kan san dén a panahun éy éwan tam dén meta, sakay kétihék man dén a panahun éy meta tam kan dén siya a huway? Sakay anya wade be i kahulugina no kinagi na, a kona sa da magsoli kan Nama na? ");
INSERT INTO dgc_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Anya wade i kahulugina,” kagi de, “na kétihék kan a panahun?” Kona sa i uhuna du alagad, da éwan de napospusan tu kinagi ni Jesus dide. ");
INSERT INTO dgc_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Nadid ti Jesus, éy tukoy na dén a te pakelagip side diya. Kanya kinagi na dide, a “Anya, néguhunan moy wade tu kahulugen no kinagi ko? ");
INSERT INTO dgc_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Tandaan moy,” kagi na, “kédemét na éya a oras, éy magsanget kam a magsisi kam. Pero du iba a tolay ta mundua, éy masahat side. Pero kétihék san dén a panahun, éy maibut tu kalungkutan moy a masahat kam dén. ");
INSERT INTO dgc_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Mara tu bébe a mégenak, éy mégsisi siya da méghirap dén. Pero ta kéluwas no anak na, éy maibut dén tu pégsisi na, da masahat dén siya to anak na. ");
INSERT INTO dgc_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ey kona be sa dikam,” kagi ni Jesus; “magsisi kam nadid. Pero ta kédemét ko dikam a huway, éy masahat kam dén. Ey éwan tu makapagpaibut ta sahat moy. ");
INSERT INTO dgc_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Kédemét na éya a panahun, éy éwan kam magpakelagip diyakén,” kagi ni Jesus. “Engˈwan magaged kam Nama ko ta maski anya, a gamitén moy i ngahen kua, éy atdinan na kam. ");
INSERT INTO dgc_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hanggan nadid, éy éwan moy pabi ginamit i ngahen ko éng mékiohon kam ta Diyos. Kanya sapul nadid, éy mékiohon kam diya, éy atdinan na kam, monda masaya kam ta mahusay.” ");
INSERT INTO dgc_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Nadid, kagi na du alagad na, a “Kinagi ko dén dikam i meadu a halimbawa. Pero dumemét i oras a éwan halimbawa i kagin kua dikam, éngˈwan ipaliwanang ko dikam Tama ko ta medibo a kagi. ");
INSERT INTO dgc_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ta éya a panahun, éy manalangin kam Nama ko a gamitén moy i ngahen ko. Sakén, éy éwanék tu kailangan a ipanalangin ta kam Nama ko, ");
INSERT INTO dgc_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","da siya, éy gustu na kam be. Gustu na kam da ginustuék moy, a méniwala kam be a gébwaték ta Diyos. ");
INSERT INTO dgc_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ey gébwaték ngani Nama ko a Diyos.” kagi ni Jesus, “a inumangeék se ta mundua. Ey nadid, éy ginanan ko i mundua a magsoliék Nama ko.” ");
INSERT INTO dgc_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Nadid, pékabati du alagad ta éya, éy kinagi de, a “Medibo ngani dén i kagi mua, Panginoon. Ewan ya medisalad a halimbawa! ");
INSERT INTO dgc_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nadid éy tukoy me a siko i nakapospusa ta étanan,” kagi de, “da maski éwan me ka pakelagipan éy napospusan mo dén i isip mia. Kanya méniwala kame a gébwat ka ta Diyos a talaga!” ");
INSERT INTO dgc_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","“Anya, méniwala kam dén a talaga?” kagi ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","“Pero entan moy, dumemét dén nadid i oras a mahiwahiwalay kam dén a pabayanék moy, a guminan i bawat esa dikam ta bili-bile moy. Pero te kagumanék pabi, da édse diyakén Tama ko. ");
INSERT INTO dgc_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Kinagi ko dén ya dikam, monda mapayapa kam tu isip dahil diyakén. Du iba a tolay ta mundua, éy paghirapén de kam. Pero patibayén moy i isip moya, da napasuku ko dén tu amo du tolay ta mundua.” ");
INSERT INTO dgc_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Nadid, to pégkagi dén ni Jesus ta éya du alagad na, éy tinumangad siya ta langet a nanalangin. “Améng,” kagi na, “Dinumemét dén nadid i oras. Palitawén mo pad nadid i kapangyarian ko, monda palitawén ko be i kapangyarian mo. ");
INSERT INTO dgc_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Da inatdinanék mo, Améng,” kagi na, “ta kapangyarian ko ta étanan na tolay, a monda du tolay a niatéd mo diyakén, éy atdinan ko be side ta buhay a éwan tu katapusan. ");
INSERT INTO dgc_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nadid, Améng, siko i tunay a Diyos a isesa. Sakén éy ti Jesu Cristo a pinaangeék mo se. Nadid, du makatukoy dikita, éy side i te buhay a éwan tu katapusan. ");
INSERT INTO dgc_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nadid, Améng, éy nipahayag ko dén i kapangyarian mo ta munduae, a tinupad ko dén tu nipatarabaho mo diyakén. ");
INSERT INTO dgc_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Kanya nadid, Améng, éy atdinanék mo ta kapangyarian ko ta harap mua, a kona to kapangyarian ko to pékiagum ko diko to araw bagu nilalang i munduae. ");
INSERT INTO dgc_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Nipahayag ta ka, Améng,” kagi ni Jesus, “du tolay a niatéd mo diyakén--du alagad ko. Side i koo mo, éy niatéd mo side diyakén. Sinunud de tu kagi mo, ");
INSERT INTO dgc_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","kanya tukoy de a gébwat diko i étanan a niatéd mo diyakén a gimet ko. ");
INSERT INTO dgc_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ey nipahayag ko dide, Améng, tu niutus mo diyakén a mégkagi dide, éy tinanggap de dén. Ey tukoy de a gébwaték diko, sakay méniwala side a siko i nagpaangea se diyakén. ");
INSERT INTO dgc_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Ewan ko ipanalangin, Améng, du iba a tolay ta mundua,” kagi ni Jesus; “éngˈwan ipanalangin ko san du tolay a niatéd mo diyakén, da side i koo mo. ");
INSERT INTO dgc_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","I étanan a koo ko, éy koo mo be. Sakay étanan a koo mo, éy koo ko be. Ey side ya di mégpahayaga ta kapangyarian ko. ");
INSERT INTO dgc_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nadid, éy humektaték ta mundua, Améng, a magsoliék diko. Pero du alagad ko, éy mawahak side ta mundua. Améng, siko i banala. Alagaan mo pad side ta kapangyarian mua a niatéd mo diyakén. Alagaan mo side, monda maging isesa side a kona dikita. ");
INSERT INTO dgc_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","To pékiagum ko pabi dide, Améng, éy inalagaan ko side ta kapangyarian mo a niatéd mo diyakén. Inalagaan ko side, kanya éwan tu napahamak dide. Basta esa san tu napahamak dide, monda matupad tu kagi ta libru na Diyos ta tungkul diya. ");
INSERT INTO dgc_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Ey nadid, Améng, éy magsoliék diko. Ey mégkagiék dén diko nadid ta kona se, monda masakup di alagad kuae na kasayaan kua. ");
INSERT INTO dgc_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nipahayag ko dide tu kagi mo, Améng. Ey nadid, du iba a tolay ta mundua, éy méiyamut side du alagad ko, da éwan dén side umayun dide. Ey kona be sa sakén, da éwanék be umayun ta mundua. ");
INSERT INTO dgc_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ewanék ménalangin, Améng, a ibukod mo side ta mundua, éngˈwan basta alagaan mo side ta gimita ni Satanas. ");
INSERT INTO dgc_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ewanék umayun du iba a tolay ta mundua,” kagi ni Jesus. “Ey kona be sa du alagad ko, a éwan be side umayun du iba a tolay ta mundua. ");
INSERT INTO dgc_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Patibayén mo, Améng, i isip dia a sumunud diko. I katutuhanan, éy saya i magpatibaya dide. Ey tu kagi mo, saya i katutuhanana. ");
INSERT INTO dgc_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nadid, Améng, éng kodya i pégpaange mo diyakén ta munduae, éy kona be sa i pégpaange kua di alagad kua ta iba-iba a lugar ta munduae. ");
INSERT INTO dgc_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ey alang-alang dide, éy patibayén ko i isip ko a sumunud diko, Améng, monda du alagad ko, éy sumunud be side diko, ta pamag-itan na katutuhanan. ");
INSERT INTO dgc_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ey nadid, Améng,” kagi ni Jesus, “éy éwan ko ipanalangin san di alagad kuae, éngˈwan ipanalangin ko be du tolay a maniwala diyakén ta esa a panahun dahilan ta ibaheta de dide. ");
INSERT INTO dgc_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ipanalangin ko side, Améng, a maging isesa maka side a kapareho ta, da édse ka diyakén, sakay sakén éy édseék diko. Monda édse maka be side dikita. Kona maka sa, Améng, monda maniwala maka du iba a tolay ta mundua a pinaangeék mo se. ");
INSERT INTO dgc_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Inatdinanék mo, Améng, ta kataasan ko. Sakay sakén, éy inatdinan ko be side ta kataasan de, monda maging isesa side a kapareho ta. ");
INSERT INTO dgc_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nadid, éy édseék dide, sakay siko éy édse ka be diyakén, Améng, monda maging isesa side ta mahusay. Nadid,” kagi ni Jesus, “tukoy maka du tolay ta mundua a pinaangeék mo se. Sakay tukoy de maka be a gustu mo side a kona ta pénggustu mua diyakén. ");
INSERT INTO dgc_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Ey nadid, Améng, éy niatéd mo dén side diyakén. Ey gustu ko a édse maka be side diyakén ta édsean kua, monda meta de i kapangyarian ko. Inatdinanék mo, Améng, ta kapangyarian ko, da ginustuék mo bagu nilalang i mundua. ");
INSERT INTO dgc_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Améng, siko i mahusaya. Du tolay ta mundua, éy éwan de ka tukoy. Pero sakén, éy tukoy ta ka. Sakay diden ye a méniwala diyakén, éy tukoy de be a siko i nagpaangea se diyakén. ");
INSERT INTO dgc_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nipahayag ta ka dide, Améng, éy ipahayag ta ka pabi, monda masakup be side na pénggustu mua diyakén, sakay monda édseék be dide.” ");
INSERT INTO dgc_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Nadid, to kétapos ni Jesus a nanalangin, éy hinumekatat side du alagad na ta Jerusalem, a inumahabes side ta Kedron, a tulos de ta halamanan ta dibilew. ");
INSERT INTO dgc_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Nadid ti Hudas a méngitokyon ni Jesus éy tukoy na be dén i éya a lugar, da madalas de Jesus a tumétulos ta éya. ");
INSERT INTO dgc_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Kanya nadid, éy nigiya na sa du sundalu sakay du pulis, a négsolo side ta bombilya sakay sulo a kayo. Sakay te armas be side. Side du inutusan du mataas a padi sakay du Pariseyo. ");
INSERT INTO dgc_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Nadid ti Jesus, éy tukoy na dén i manyaria diya. Ey kédemét du sundalu to halamanan, éy sinambat na side, a kinagi na, a “Ti ésiya i ahayukén moya?” ");
INSERT INTO dgc_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","“Ti Jesus a taga Nasaret,” kagi de. “Ey sakén ngani dén ye,” kagi ni Jesus. Kaguman du sundalu ti Hudas. ");
INSERT INTO dgc_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Nadid, to pégkagi ni Jesus a “Sakén ngani dén ye,” éy inumisol side a tulos de a natumba. ");
INSERT INTO dgc_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ey kinagi na man dén dide, a “Ti ésiya i ahayukén moya?” Ey “Ti Jesus a taga Nasaret,” kagi de. ");
INSERT INTO dgc_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ey kinagi ni Jesus, a “Kinagi ko ngani dén dikam a sakén dén ye. Nadid, éng sakén san i haayukén moya, éy pabayan moy di kaguman kuae.” ");
INSERT INTO dgc_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Kinagi ni Jesus i éya, monda matupad tu kinagi na to éya, a éwan mebut i maski isesa du niatéd diya Nama na. ");
INSERT INTO dgc_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Nadid ti Simon Pedro, éy binagut na tu sondang na, a tinegpas na tu utusan no mataas a padi, a tulos minahipas tu talinga na. I ngahen no utusan, éy ti Malko. ");
INSERT INTO dgc_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ey “Diyan mo,” kagi ni Jesus ni Pedro, “Ikaluban mo tu sondang mo. Isip moy wade éwan ko tanggapén i hirap ko a iatéd diyakén Nama ko?” ");
INSERT INTO dgc_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Nadid du sundalu, sakay du pulis sakay tu kapitan de, éy dinikép de ti Jesus, a ginapus de, ");
INSERT INTO dgc_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","sakay kinabitan de a niange de pa to bile ni Anas. Ti Anas éy manugen ni Padi Kaipas. Ti Kaipas i mataas a padi ta éya a taon. ");
INSERT INTO dgc_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Siya i négkagia du te tungkulin a Judeo, a maigi pa éy pabunu de siya alang-alang du tolay. ");
INSERT INTO dgc_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Nadid ti Simon Pedro sakay tu esa be a alagad, éy tinumagubet side de Jesus. Ey kédemét de a éduwa to bile no mataas a padi, éy nakasdép tu alagad a esa to karsada no bile, da tukoy siya no padi. ");
INSERT INTO dgc_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pero nawahak ti Pedro ta luwas no kudal. Kanya tu alagad a esa, éy pinékiohon na to bébe a mégbantay to pintuan no kudal, a pasdépén na ti Pedro. ");
INSERT INTO dgc_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ey késdép ni Pedro, éy kinagi diya no bébe, a “Alagad ka wade na éya a lélake?” Ey “Ewan,” kagi ni Pedro. ");
INSERT INTO dgc_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Nadid, du bataan sa, sakay du pulis, éy nagpabaga side ta uging, a pégdengdengan de, da medégnin. Ey kaguman de ti Pedro, a mégdengdeng be sa. ");
INSERT INTO dgc_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Nadid tu mataas a padi éy nipakelagip na ni Jesus du alagad na sakay tu pégtoldu na. ");
INSERT INTO dgc_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ey kinagi ni Jesus diya, a “Naleék dén a mégpahayag ta pégtoldu ko ta harap du tolay. Ugali ko a palagi a mégtoldu du tolay ta kapilya sakay ta Templo, da saya i képisanana du tolay. Ewanék mégtoldu ta lihim. ");
INSERT INTO dgc_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Bakit siyasaténék mo?” kagi ni Jesus. “Siyasatén mo du tolay a nakabati diyakén. Tukoy de tu pégtoldu ko.” ");
INSERT INTO dgc_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","To pégkagi ni Jesus ta éya, éy sinapuk siya no esa a pulis, a kinagi na, a “Bakit kona sa i sengbet mua ta mataas a padi?” ");
INSERT INTO dgc_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","“Eng mali tu kinagi ko,” kagi ni Jesus, “éy kagi mo dén. Pero éng éwan ko kinagi i mali, éy bakit sinapukék mo?” ");
INSERT INTO dgc_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Nadid ti Anas, éy nipetugén na dén ti Jesus a gapus pabi ni Padi Kaipas. ");
INSERT INTO dgc_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Nadid, mégdengdeng pabi sa ti Simon Pedro, éy kinagi diya du édsa sa, a “Ewan siko i alagad na éya a lélake?” Ey “Ewan,” kagi ni Pedro. ");
INSERT INTO dgc_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Nadid, te bataan sa no mataas a padi. Top siya no lélake a tinegpas ni Pedro tu talinga na. Ey kinagi na ni Pedro, a “Isip ko neta ta ka be sa ta halamanan a kaguman na dinikép mia?” ");
INSERT INTO dgc_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pero inéwan man dén ni Pedro. Ey to péngawan na dén éy bigla a nagtarakot tu tandang. ");
INSERT INTO dgc_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Nadid éy pinaluwas de ti Jesus to bile ni Kaipas, a nitugén de to pégiyanan no gubernador. Amulaldew pabi. Ey du Judeo, éy éwan side sinomdép to pégiyanan no gubernador, da ugali na rilihiyon de, éy mehupet kan tu somdép. Ey bawal tu mehupet a méngan ta anyaya na Ala-ala. ");
INSERT INTO dgc_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Kanya linumwas dide ti Gubernador Pilato, a kinagi na, a “Anya i abla moya ta éye a lélake?” ");
INSERT INTO dgc_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ey kinagi du Judeo, a “Te kasalanan siya! Engˈwan siya tu kasalanan, éy éwan me nitugén diko.” ");
INSERT INTO dgc_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ey kinagi ni Pilato a, “Bistaan moy siya ta sarili moy a huwes.” Ey “Ewan maari,” kagi du Judeo, “da labag ta utus a pabunu me i tolay.” ");
INSERT INTO dgc_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Nanyari ya monda matupad tu kinagi ni Jesus, to pégkagi na a mate siya ta te tolnék a kayo. ");
INSERT INTO dgc_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Nadid, sinomdép man dén ti Pilato to pégiyanan na a pinauwet na ti Jesus, a kinagi na, a “Anya, siko i haria na Judeo?” ");
INSERT INTO dgc_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ey kinagi ni Jesus, a “Anya, gébwat ina ta sarili mo a isip, o te négkagi dikam ta ina?” ");
INSERT INTO dgc_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","“Ataay, Judeoék beman?” kagi ni Pilato. “Anya i kasalanan mo? Bakit nitugén ka diyakén du kabébayan mo?” ");
INSERT INTO dgc_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Kinagi ni Jesus, “I kaharian ko, éy éwan ta éye ta munduae. Mara éng édse i kaharian ko ta munduae, éy ipékilabanék du utusan ko, monda éwanék maka dekpén du Judeo. Pero éwan,” kagi ni Jesus, “da éwan édse i kaharian ko ta munduae.” ");
INSERT INTO dgc_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","“Ey nadid,” kagi ni Pilato, “hari ka a talaga?” “Kagi mo a hariék,” kagi ni Jesus, “éy séˈ ngani ya i tungkulin kua. Kanya nienakék, éy monda ipahayag ko i katutuhanan. Kanya inumangeék ta mundua. Ey maski ti ésiya a nasakup na katutuhanan, éy baten de i kagi kua.” ");
INSERT INTO dgc_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","“Ewan wade tu makapospos ta katutuhanan,” kagi ni Pilato. Nadid, to pégkagi ni Pilato ta éya, éy linumwas man dén siya du Judeo, a kinagi na dide, a “Ewanék tu meeta a kasalanan na lélake a éye a pamarusaan ko diya. ");
INSERT INTO dgc_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Nadid ayun ta ugali moy, éy paluwasén ko i esa a pihesu éng Piyesta na Ala-ala,” kagi ni Pilato. “Anya wade éng légsiwan ko i éye a lélake a hari kan na Judeo?” ");
INSERT INTO dgc_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ey, “Ewan.” kagi du tolay. “Bakén a siya, éngˈwan légsiwan mo ti Barabas!” (Ti Barabas éy tulisan.) ");
INSERT INTO dgc_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Nadid ti Pilato, éy nipayabat na ti Jesus. ");
INSERT INTO dgc_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Sakay du sundalu, éy kinawekaw de tu lanot a te set, sakay nisoklop de ta ulo naa a kurona na kan. Sakay pinabaduan de ta medingat, da saya i kolor na damit na hari. ");
INSERT INTO dgc_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Sakay nalelewas side a inumadene diya, a kinagi de a “Mabuhay! Siko a hari na Judeo!” a tulos de a sésapukén. ");
INSERT INTO dgc_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Nadid, linumwas man dén ti Pilato du meaadu a tolay, a kinagi na dide, a “Entan moy, iharap ko siya dikam, monda tukoy moy a éwanék tu meeta a kasalanan na a pamarusaan ko diya.” ");
INSERT INTO dgc_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ey nadid, niluwas de ti Jesus ta harapan dia, a te kurona a set, sakay te badu a medingat. Ey kinagi ni Pilato, a “Entan moy, saye i lélakia!” ");
INSERT INTO dgc_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ey du mataas a padi, sakay du pulis, péketa de ni Jesus, éy kinagi de ta medegsén, a “Ipako mo ta kudos!” Ey kinagi ni Pilato, a “Alapén moy siya. Sikam i méngipakua diya, da sakén, éy éwanék tu meeta a kasalanan na a pamarusaan ko diya.” ");
INSERT INTO dgc_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ey kinagi du Judeo, a “Te kautusan kame, a i kagia ta éya, éy dapat mate siya, da siya éy mégwari-wari a anak na Diyos.” ");
INSERT INTO dgc_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Nadid, pékabati ni Pilato ta éya, éy lalo siya a umanteng. ");
INSERT INTO dgc_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Kanya sinomdép man dén siya to pégiyanan na, a kinagi na ni Jesus, a “Ahe i gébwat mua a talaga?” Ey éwan sinumengbet ti Jesus. ");
INSERT INTO dgc_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ey “Bakit,” kagi ni Pilato, “éwan ka sumésengbet diyakén? Ewan mo beman tukoy a sakén i te kapangyariana a mangpaluwas diko, o dikaya ipako ta ka ta kudos?” ");
INSERT INTO dgc_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ey kinagi ni Jesus, a “Kanya ka san te kapangyarian diyakén, éy kaluuben na Diyos a niatéd diko i kapangyarian mua. Kanya tu néngitugén diyakén diko, éy siya i lalo a medukés i kasalanan na.” ");
INSERT INTO dgc_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Nadid, pékabati ni Pilato ta éya, éy lalo a gustu na a légsiwan ti Jesus. Péro mégidel du Judeo, a kinagi de diya, “Eng légsiwan mo siya, éy kontara ka ta hari tam ta Roma, da maski ti ésiya a mégwari-wari a hari, éy kalaban no hari tam ta Roma.” ");
INSERT INTO dgc_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Nadid, pékabati ni Pilato ta éya, éy niluwas na ti Jesus, sakay négiknud siya to hukuman. I édsean na hukuman éy to plasa a semento (i pégngahen de ta éya ta kagi na Judeo, éy Gabata). ");
INSERT INTO dgc_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Nadid éy disperas dén na Piyesta na Ala-ala, to tamo a tanghali. Ey kinagi ni Pilato du Judeo, a “Saye i hari moya!” ");
INSERT INTO dgc_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pero basta kinagi du tolay, a “Bunuén moy siya! Ipako moy siya!” “Anya,” kagi ni Pilato, “ipako ko bale tu hari moy ta kudos?” Ey kinagi du mataas a padi, a “Ewan kame tu hari, éng éwan tu hari tam ta Roma!” ");
INSERT INTO dgc_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Kanya niatéd ni Pilato ti Jesus dide, a ipako de ta kudos. ");
INSERT INTO dgc_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ey pinaluwas de ti Jesus ta banuwan a békle na tu kudos na. Niange de siya ta lugar a ngéngahinan de a “Bungu” (ta kagi na Judeo éy Golgota). ");
INSERT INTO dgc_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ey du sundalu, éy nipako de sa siya to kudos. Sakay nipako de be sa i éduwa a lélake a nitolnék de ta magtembanga a tagirilan ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Nagpasulat ti Pilato ta kagi to pastel, a niekpét na to kudos. I kagia to pastel éy “TI HESUS A TAGA NASARET, A HARI NA JUDEO.” ");
INSERT INTO dgc_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Meadu du Judeo a nakabasa to pastel, da adene ta banuwan i pinéngitolnékan dia to kudos ni Jesus. Ey nisulat ya ta kagi na Judeo, sakay kagi na Latin, sakay kagi na Griego. ");
INSERT INTO dgc_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Kinagi du mataas a padi ni Pilato, a “Diyan mo isulat a hari siya na Judeo; éngˈwan, i maigi a isulat mo, éy ‘Akala na éye éy hari na Judeo.’” ");
INSERT INTO dgc_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","“Ewan,” kagi ni Pilato. “Bagay nesulat dén, éy éwan dén maari a palitan.” ");
INSERT INTO dgc_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Nadid du sundalu, to péngitolnék de dén ni Jesus, éy hinati-hati de tu badu na ta épat a bahagi. Esa bahagi bawat esa a sundalu. Sakay inalap de be tu badu na a atakdug. Pero i éya, éy éwan tu nadigetan, da ginamet a buu a damit. ");
INSERT INTO dgc_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Kanya kinagi de, a “Diyan tam pépapéknitén, sayang. Subali pa, éy magpalabunutan kitam, éng ti ésiya dikitam i makaalapa.” Ey to pégpalabunutan de, éy natupad tu kagi ta kasulatan, a “Pinaghati-hati de kan tu badu na, sakay tu damit na kan, éy pinagpalabunutan de.” ");
INSERT INTO dgc_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Nadid, éy te taknég ta adene to kudos i épat a bébe: tu ina ni Jesus, sakay tu top nena na, sakay ti Maria a asawa ni Kleopas, sakay ti Maria Magdalena. ");
INSERT INTO dgc_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ey ti Jesus, péketa na nena na, sakay tu alagad na a ésa a mahal na, éy kinagi na nena na, a “Entan mo, Inéng, sapul nadid, éy siya ina i bilang anak mua.” ");
INSERT INTO dgc_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Sakay kinagi na to alagad sa, a “Nadid, éy siya i bilang ina mua.” Kanya sapul ta éya a aldew, tu alagad éy pinégiyan na tu ina ni Jesus to bile na. ");
INSERT INTO dgc_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Nadid, éy tukoy ni Jesus a naganap dén i étanan a tarabaho na. Ey kinagi na a, “Mégeplékék.” (Kinagi na ya a monda matupad tu kagi a esa ta kasulatan.) ");
INSERT INTO dgc_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Te ahung sa a putat ta tuba. Kanya nibisa de tu damit to tuba, sakay nisélpet de to kayo, sakay nisadét de to labi ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ey to péngsépsép ni Jesus to tuba, éy kinagi na a “Naganap dén.” Ey to pégkagi na ta éya, éy linuméngte dén, a tulos na dén a nahéngsatan. ");
INSERT INTO dgc_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Nadid, da disperas no piyesta, éy pékiohon du Judeo ni Pilato a papuseng na tu tikéd du étélo a nipako, monda mate side agad, a iogsad de side to kudos. Sala du Judeo a te tolnék pabi side du kudos ta kédemét na piyesta, da mahalaga ya a aldew. ");
INSERT INTO dgc_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Kanya du sundalu, éy pinuseng de tu tikéd du éduwa a tulisan a nipako a késabay ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pero kéadene de ni Jesus, éy neta de a pate dén. Kanya éwan de pinuseng i tikéd naa. ");
INSERT INTO dgc_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pero tu sundalu a esa, éy binikal na tu hawes ni Jesus to géyang, éy bigla a binumulos diya i dige sakay dinom. ");
INSERT INTO dgc_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Sakén a nanulat ta éye, éy mineta ko ngani i nanyaria ta éya. Kanya tukoy moy a katutuhanan i sistigu ko a éye dikam. Mégpatunayék dikam, monda maniwala kam. ");
INSERT INTO dgc_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Nanyari i kona sa, monda matupad tu kagi ta kasulatan, a “Ewan kan mapuseng tu tulang na a maski isesa.” ");
INSERT INTO dgc_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Sakay natupad be tu iba a kagi to kasulatan, a i kagi na, éy “Mémalasén de kan tu binikal de.” ");
INSERT INTO dgc_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Nadid, kétapos na éya, ti Hose a taga Arimatea éy nékiohon siya ni Pilato, a alapén na tu bangkay ni Jesus. Méniwala ti Hose ni Jesus, pero lihim san, da méganteng siya du te tungkulin a Judeo. Ey to pékiohon na ni Pilato, éy inoan na siya. Kanya inalap na tu bangkay. ");
INSERT INTO dgc_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Kaguman ni Hose ti Nikodemo. Siya tu nékiohon ni Jesus to kélép to araw. Ey te kébil ti Nikodemo a manga limapulu a kilo a sépot a halu-halu a gébwat ta kayo. ");
INSERT INTO dgc_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Inalap de tu bangkay ni Jesus, a sinaputan de to manta, a niagum de be sa tu mesépot, da saya i ugalia na Judeo éng maglébéng. ");
INSERT INTO dgc_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Nadid, to adene no pinéngipakoan de ni Jesus, éy te halamanan. Ey te peglébngan sa a bigu a kuweba a éwan pabi ginamit. ");
INSERT INTO dgc_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ey nielbéng de sa ti Jesus, da adene, éy mégagaw dén side, da adene dén i pangilin. ");
INSERT INTO dgc_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Nadid, to simba a gagabi, a medidiklém pabi, éy inumange ti Maria Magdalena to lébéng. Ey kédemét na sa, éy neta na a bukas dén, a naibut dén tu takléb na a bito. ");
INSERT INTO dgc_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ey naginan ti Maria a soli, a niange na nibaheta ni Simon Pedro sakay to alagad a esa a mahal ni Jesus. “Inalap de tu Panginoon to lébéng,” kagi na, “éy éwan tam tukoy éng ahe i néngiangayan dia!” ");
INSERT INTO dgc_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Nadid, pékabati ta éya ni Pedro sakay tu alagad a esa, éy inumange sa side a inentan de. ");
INSERT INTO dgc_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Pareho side a naginan, pero tu alagad a esa, éy neditulan na ti Pedro to lébéng. ");
INSERT INTO dgc_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Niseleg na tu lubuk, éy neta na san tu sapot. Pero éwan siya sinomdép. ");
INSERT INTO dgc_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Nadid, pékaabut ni Pedro to alagad a esa to lébéng, éy basta tulos na a sinomdép. Ey neta na be sa tu sapot. ");
INSERT INTO dgc_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Sakay tu panyo a nibalut to ulo ni Jesus, éy éwan na kaguman tu sapot, éngˈwan nihiwalay dén a tiniklup to digdig. ");
INSERT INTO dgc_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Nadid tu alagad a neditol, éy tinumagubet ni Pedro a sinomdép to lébéng. Ey péketa na a kona sa, éy naniwala siya a nabuhay dén ti Jesus. ");
INSERT INTO dgc_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ewan de pabi napospusan tu nikagi ta kasulatan, a mabuhay kan siya a huway. ");
INSERT INTO dgc_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ey nadid, nagsoli side a éduwa to bile de. ");
INSERT INTO dgc_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Pero nawahak ti Maria to lébéng a mégsanget. Ey késeleg na to lubuk ");
INSERT INTO dgc_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","éy neta na i éduwa a anghel a te badu ta melatak, a te eknud side to édsean no bangkay ni Jesus. Tu esa éy édse to uluan na: tu esa man éy édse to uyad na. ");
INSERT INTO dgc_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ey kinagi de diya, a “Bakit mégsanget ka, Anéng?” “Ey dahilan éy inalap de tu bangkay no Panginoon ko,” kagi na, “éy éwan ko tukoy éng ahe i néngiangayan dia.” ");
INSERT INTO dgc_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Pégkagi ni Maria ta éya, éy sinumuleg siya a neta na a te taknég sa ti Jesus. Pero éwan na tukoy a ti Jesus. ");
INSERT INTO dgc_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Akala na san éy tu mégbantay ta halamanan ta éya. Ey kinagi ni Jesus diya, a “Bakit mégsanget ka, Anéng? Ti ésiya ahayukén mua?” Ey kinagi ni Maria, a “Eng siko i nangalapa to nielbéng me ta éye, éy kagin pad éng ahe i néngiangayan mua, monda angen ko siya.” ");
INSERT INTO dgc_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ey kinagi ni Jesus, a “Maria.” Ey pékabati ni Maria ta éya, éy hinumarap siya diya, a pékatenggi na diya, a kinagi na a “Raboni!” (I kahulugina na éya, éy Maistu.) ");
INSERT INTO dgc_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ey kinagi ni Jesus diya, a “Diyanék mo kékbilan, da éwanék pabi inumontok dén Nama ko. Ikad mo dén du kakaguman tam, a kagi mo dide a umontokék Nama ko. Siya i Diyos ko. Sakay kagi mo a siya i Ama moy be sakay Diyos moy be.” ");
INSERT INTO dgc_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Nadid, to pégkagi ni Jesus ta éya, éy inumange ti Maria du alagad, a kinagi na dide a neta na dén tu Panginoon. Sakay kinagi na be dide tu nibilin na diya. ");
INSERT INTO dgc_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Nadid, to kélép na éya a aldew, a simba pabi, éy napisan du alagad ta esa a bile. Ey seradu tu pintuan, da méganteng side du te tungkulin a Judeo. Ey nadid, éy dinumemét sa ti Jesus a te taknég siya ta bélog dia. Ey kinagi na dide, a “Mapayapa kam dén.” ");
INSERT INTO dgc_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ey to pégkagi na ta éya, éy nipeta na dide tu kamét na sakay tu hawes na. Ey du alagad, péketa de to Panginoon de, éy mésahat side! ");
INSERT INTO dgc_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ey kinagi na dide a huway, a “Mapayapa kam dén. Eng kodya i nipagpaangea se diyakén Nama ko, éy kona be sa i pagpaange kua dikam ta iba-iba a lugar.” ");
INSERT INTO dgc_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ey to pégkagi na ta éya, éy inangsan na side, a kinagi na, a “Tanggapén moy i Banal a Espiritu. ");
INSERT INTO dgc_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","I patawadén moy ta kasalanan na, éy pinatawad ngani dén. Sakay tu éwan moy patawadén, éy éwan ngani patawadén.” ");
INSERT INTO dgc_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Nadid, to nipeta ni Jesus dide, éy éwan sa ti Tomas a Kambal. Siya i esa du labindalawa a alagad. ");
INSERT INTO dgc_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Kanya nibaheta diya du iba a alagad a neta de tu Panginoon. Pero éwan naniwala ti Tomas. “Baguék maniwala,” kagi na, “éy meta ko pa tu talingo no pako to palad na, a itagéd ko ta toldu kua. Sakay éng kébilan ko be tu talingo to hawes na, éy maniwalaék dén.” ");
INSERT INTO dgc_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nadid, kélipas na esa simba, éy napisan man dén du alagad to bile, a kaguman de nadid ti Tomas. Seradu san tu pintuan. Ey dinumemét ti Jesus a te takneg ta bélog dia, a kinagi na a “Mapayapa kam dén.” ");
INSERT INTO dgc_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Sakay kinagi na ni Tomas, a “Entan mo i palad kua, Tomas, a itagéd mo ta toldu mua. Nay, igewat mo se i kamét mua, a kébilan mo i hawes kua. Maniwala ka diyakén, Tomas.” ");
INSERT INTO dgc_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ey ti Tomas, basta i kinagi na, éy “Siko i Panginoon ko, sakay Diyos ko.” ");
INSERT INTO dgc_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ey kinagi ni Jesus diya, a “Méniwala ka dén da netaék mo dén. Entan mo, masuwerte a tahod du maniwala diyakén maski éwanék de meta.” ");
INSERT INTO dgc_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Nadid, ginamet ni Jesus i meadu a iba a kataka-taka ta harapan du alagad na. Pero éwan ko side nisulat ta libruae. ");
INSERT INTO dgc_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pero i nisulat ko a éye, éy monda maniwala kam ni Jesus, a siya i Cristo, a anak na Diyos a tagapagligtas monda éng maniwala kam éy te buhay kam a éwan tu katapusan. ");
INSERT INTO dgc_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Nadid, kétapos na éya, éy pinumeta man dén ti Jesus du alagad na ta diget na Tiberias. Saye i nanyaria: ");
INSERT INTO dgc_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Négagum de Simon Pedro, sakay ti Tomas a Kambal, sakay ti Natanel a taga Kana, sakay du anak ni Sebedeo, sakay éduwa pa a iba a alagad. ");
INSERT INTO dgc_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ey kinagi ni Simon Pedro, a “Ikad ko dén mangikan.” Ey kinagi du iba a “Kumuyog kame diko.” Tulos dinumitaw side to abeng de. Ey nagdamag side a nangikan, pero éwan side tu nalap. ");
INSERT INTO dgc_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Nadid, to amulaldew dén, éy te taknég ti Jesus to baybay. Ey du alagad éy éwan de tukoy a ti Jesus siya, da adeyo side. ");
INSERT INTO dgc_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ey dinulawan na side, a kinagi na, a “Anya, nakaalap kam?” Ey “Ewan,” kagi de. ");
INSERT INTO dgc_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","“Ilipat moy pa man i rambat moya ta lipata, éy makaalap kam,” kagi na. Nadid, péngitékneg de ta lipat, éy meaadu bale i nalap dia a ikan, a hanggan da éwan de kaya tu rambat a iahawas to abeng. ");
INSERT INTO dgc_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Nadid, tu alagad a esa a mahal ni Jesus éy kinagi na ni Pedro, a “Siya bale ina tu Panginoon.” Ey nadid ti Pedro, péketa na a ti Jesus ngani dén i édse to baybay, éy nagbadu siya daékbus siya, sakay sinumegbu to diget, a tulos na ta digdig. ");
INSERT INTO dgc_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Pero du iba a alagad, éy te sakay side a dinumigdig, a hela de san tu rambat a putat ta ikan. Ewan side adeyo ta baybay, basta sandaan wade san a metro. ");
INSERT INTO dgc_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Nadid, kéahawas de to baybay, éy naketa sa side ta apoy, a te ikan a nituno, sakay tinapay. ");
INSERT INTO dgc_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ey kinagi ni Jesus dide, a “Nay, iange moy se i sénganya a momon a ikan a inalap moy, a itunu tam.” ");
INSERT INTO dgc_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Kanya sinumakay man dén ti Simon Pedro to abeng, a hinela na tu rambat to baybay. Ey putat pa ta dédekél a ikan. Sandaan éy ta limapulu éy ta étélo a momon. Pero maski meadu side a tahod, éy éwan napéknet tu rambat. ");
INSERT INTO dgc_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","“Nay,” kagi ni Jesus, “méngan kitam dén.” Du alagad, éy mésanike side a mégpakelagip diya éng ti ésiya siya, da tukoy de dén a tu Panginoon siya. ");
INSERT INTO dgc_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ey inalap ni Jesus tu tinapay, sakay tu ikan, a nigewat na dide a méngan. ");
INSERT INTO dgc_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Saya i ikatélo a beses a nipeta ni Jesus du alagad na sapul to nikabuhay na. ");
INSERT INTO dgc_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nadid, kétapos de a néngan, éy kinagi ni Jesus ni Simon Pedro a, “Simon, mahalék mo wade ta mahigit pa diden yee?” Ey “O,” kagi ni Pedro, “Tukoy mo a gustu ta ka.” “Siko i pastora du tupa ko a kékétihék,” kagi ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Nadid kagi ni Jesus a huway, a “Simon, mahalék mo a talaga?” Ey “O, Panginoon. Tukoy mo a gustu ta ka.” “Pastoran mo du tupa ko.” ");
INSERT INTO dgc_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Nadid, kagi ni Jesus diya ta pentélo, a “Simon, gustuék mo a talaga?” Nadid, pékabati ni Simon Pedro a pékelagipan na siya ta pentélo, éy mélungkut siya. Ey kinagi na a “Panginoon, siko i nakapospusa ta étanan. Tukoy mo a gustu ta ka.” Ey kinagi ni Jesus, “Pastoran mo du tupa ko. ");
INSERT INTO dgc_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Tandaan mo, Simon,” kagi ni Jesus, “to kéanak mo pabi, éy nagbadu ka san ta bégi mo a naglebut ka ta maski ahe i gustu mua. Pero kélakay mo, éy igewat mo tu kamét mo a gapusén de, sakay iange de ka ta éwan mo gustu.” ");
INSERT INTO dgc_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Kinagi ya ni Jesus da ipaliwanag na ni Pedro éng kodya na a mate. Sakay kinagi na ya monda tukoy na a ipeta na i kapangyarian na Diyos ta ikate na. Ey nadid, kinagi na ni Pedro, a “Sumunud ka san diyakén.” ");
INSERT INTO dgc_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Nadid, sinumuleg ti Pedro, éy neta na tu alagad a esa to adég na. Siya tu alagad a mahal ni Jesus. Siya tu sinumangdih to salapad ni Jesus to péngan de to éya, a nipakelagip na éng ti ésiya i méngitokyona diya. ");
INSERT INTO dgc_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ey péketa ni Pedro diya, éy kinagi na ni Jesus, a “Anya wade, Panginoon, i lélakeae? Maanya siya?” ");
INSERT INTO dgc_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ey kinagi ni Jesus ni Pedro, a “Eng gustu ko a buhay siya a hanggan ta késoli ko se, éy anya i pékialam mua? Basta sumunud ka san diyakén.” ");
INSERT INTO dgc_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Dahil ta éya a kinagi ni Jesus, éy akala du tolay a méniwala diya, a éwan mate i éya a alagad. Pero éwan kinagi ni Jesus a éwan siya mate. Engˈwan, i kinagi na sana, éy “Eng gustu ko a buhay siya a hanggan ta késoli ko se, éy anya i pékialam mua?” ");
INSERT INTO dgc_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Nadid, sakén a nanulat ta libruae, éy sakén ngani dén i éya a alagad. Ey sakén i mégpatunaya ta étanan a éya a ginimet na. Ey tukoy ko a katutuhanan i isistigu kua dikam. ");
INSERT INTO dgc_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Nadid, te meaadu be a iba a ginamet ni Jesus, a éwan ko nisulat ta éye. Anya wade éng mesulat side a étanan, éy siguru éwan meubus ta kabuuan na mundua i libru na ginamet na. ");
INSERT INTO dgc_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Mahal ko a Teopilo: Nisalaysay ko dén to libru ko a esa i étanan a ginimet ni Jesus, sakay tu nitoldu na, ");
INSERT INTO dgc_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","a hanggan to aldew a niontok na ta langet. Pero bagu siya inumontok, éy nibilin na pa du lélake a pinili na a apostol na. Hinatulan na side ta pamag-itan na kapangyarian na Banal a Espiritu na Diyos. ");
INSERT INTO dgc_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Kélipas no hirap na, a nabuhay man dén, éy pinumeta siya dide ta meadu a beses, a pinatunayan na dide a buhay siya. Pinumeta siya dide ta lubuk na épat a pulu a aldew, sakay négkagi siya dide tungkul ta péghari na Diyos ta tolay. ");
INSERT INTO dgc_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Habang kakaguman de pabi siya, éy nibilin na dide a “Diyan kam pa huméhektat ta Jerusalem,” kagi na, “éngˈwan uhayén moy pa tu nipangako Nama ko, a kinagi ko dén dikam tungkul ta Espiritu na Diyos. ");
INSERT INTO dgc_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Natandaan moy, tu tungkulin ni Juan, éy bininyagen na du tolay ta dinom. Pero nadid,” kagi ni Jesus, “éy éwan dén male éy mabinyagen kam ta Banal a Espiritu.” ");
INSERT INTO dgc_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","To esa a aldew, a kapisan de ti Jesus, éy kinagi de diya, a “Anya wade, Panginoon? Panahun wade dén nadid a mapaibut mo du mégmayor dikame a dayuan, monda libri man dén i banuwan na Israel?” ");
INSERT INTO dgc_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ey kinagi ni Jesus dide, a “Tama ko san i méngitakdaa ta panahun na panggimet na. Ey éwan dén kailangan a mapospusan moy éng nikésiya ya. ");
INSERT INTO dgc_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pero sikam, ta kéogsad dikam na Banal a Espiritu, éy égse dén dikam i kapangyarian na Diyos. Tulos magpatunay kam diyakén ta Jerusalem, sakay ta Hudea, sakay ta Samaria, a hanggan ta buu a mundu.” ");
INSERT INTO dgc_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Nadid, to pégkagi na dén ta éya, éy inumontok dén siya ta langet. Ey du alagad na, habang te tangaden de pabi siya, éy nataklében siya na kuném. ");
INSERT INTO dgc_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nadid, te tangaden de pabi, éy basta bigla i éduwa a lélake a te badu a melatak a tinumaknég ta giled dia. ");
INSERT INTO dgc_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","“Sikam a taga Galilea,” kagi de, “bakit égsina kam san sina a te tangad ta langet? Ti Jesus éy kaya dén ta langet. Pero ta esa a panahun éy sumoli man dén se siya,” kagi de. “Ey késoli na éy kona be to nipaketa moy diya to niontok na.” ");
INSERT INTO dgc_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Nadid, nagsoli dén du alagad ta Jerusalem, a gébwat ta éya a buked na Olibo. I kaadeyo na banuwan to buked éy manga esa a kilumetro. ");
INSERT INTO dgc_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Diden ya éy de Pedro, Juan, Santiago, Andres, Pelipe, Tomas, Bartolome, Mateo, Santiago a anak ni Alpeo, ti Simon a metapang, sakay ti Hudas a anak ni Santiago. Nagsoli dén side to kuwarto ta ontok no bile a tinulusan de ta Jerusalem. ");
INSERT INTO dgc_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ey kaguman sa du bébe, sakay ti Maria a ina ni Jesus, sakay du top ni Jesus. Ey aldew-aldew éy pisan sa side a ménalangin. ");
INSERT INTO dgc_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nadid, nakalipas i sénganya a aldew, éy nagpisan dén i meadu a méniwala ni Jesus. Manga sandaan éy ta duwapulu side. Ey tinumaknég ti Pedro ta harap dia a mégkagi dide. ");
INSERT INTO dgc_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“A tétotop ko,” kagi na, “kailangan a matupad i te sulat ta kasulatan a kinagi na Banal a Espiritu ta pamag-itan ni Dabid. Da nihula ni Dabid ti Hudas, a méngigiya siya du manikép ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Kabilang ti Hudas dikame a alagad,” kagi ni Pedro, “da pinili be siya ni Jesus a kaguman me. ");
INSERT INTO dgc_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ti Hudas éy namugtong ta esa a sukat a luta to nibayad de diya a néngitokyon ni Jesus. Ey minate sa siya, a tulos pinomtak tu tiyan na, a tulos newadwad tu bituka na. ");
INSERT INTO dgc_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ey nabaheta dén ya na étanan a mégiyan ta Jerusalem. Kanya nginahinan de i luta a éya a Akeldama. I kahulugina na éya éy Medige a Uma. ");
INSERT INTO dgc_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Nadid, te kagi ta libru na Manga Kanta, a ‘Maibutan maka ta tolay tu bile na, sakay diyan dén sa mégiyan i maski ti ésiya.’ Sakay, ‘Te lumewas maka a iba to tungkulin na a para ta Diyos.’ ");
INSERT INTO dgc_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Kanya nadid,” kagi ni Pedro, “éy dapat kitam a magpile ta kalewas ni Hudas, monda te kaguman kame a magpatunay a nabuhay dén ti Panginoon Jesus. Kailangan éy pilién tam i esa du kaguman me sapul to péngkuyoyog dikame ni Jesus, sapul to nipangbinyag diya ni Juan a hanggan éwan siya inumontok ta langet.” ");
INSERT INTO dgc_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Nadid, pékabati de ni Pedro ta éya, éy namili side ta éduwa a lélake: ti Matias sakay ti Hose (i palayaw ni Hose éy ti Barsabas Hustu). ");
INSERT INTO dgc_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ey nanalangin side, a kagi de, a “Panginoon, siko i makapospusa ta isip na tolay a étanan. Itoldu mo pad dikame i pinili mo a lélake ta éduwa a éye ");
INSERT INTO dgc_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","a maging apostol. Ti ésiya i pinili mo, Panginoon, a lumewas to tungkulin ni Hudas, da gininanan dén ni Hudas tu tungkulin na, a inumange dén siya ta impiyerno.” ");
INSERT INTO dgc_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Nadid, kétapos de a ménalangin, éy nagpalabunutan side éng ti ésiya i pilién de. Ey ti Matias i naalap dia. Siya i nedagdag ta labindalawa a apostol. ");
INSERT INTO dgc_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Nadid, kélipas na sapulu a aldew hanggan to kéontok ni Jesus ta langet, éy dinumemét dén i Piyesta na Pentekos. Ey du méniwala ni Jesus, éy napisan dén side a étanan. ");
INSERT INTO dgc_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Nadid, bigla de a nabati i ténog a gébwat ta langet, a koman i ténog na mesibét a pahés. Ey meténog a tahod to lubuk no bile a égsean de. ");
INSERT INTO dgc_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ey mineta de i kékétihék a koman i apoy, a kinumalat a tinumupo ta bawat esa dide. ");
INSERT INTO dgc_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ey inumasék dén i Banal a Espiritu ta bégi dia a étanan, tulos négkagi side ta iba-iba a kagi, ayun ta nipagkaluub dide na Espiritu. ");
INSERT INTO dgc_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Nadid, égsa nadid ta Jerusalem i meadu a mékidiyos a Judeo, a mamiyesta side. Gébwat side ta iba-iba a banuwan. ");
INSERT INTO dgc_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Pékabati de to ténog, éy dinumulug side to bile du alagad. Nagtaka side, da nabati na bawat esa dide a mégkagi dén du alagad ta iba-iba a kagi de. ");
INSERT INTO dgc_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Mégtaka side a tahod, a kinagi de, a “Bakit, éwan beman taga Galilea san diden ina? ");
INSERT INTO dgc_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Bakit mébati tam dide i sarili tam a kagi?” ");
INSERT INTO dgc_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Du tolay sa a mégtaka éy éwan side taga Galilea, éngˈwan gébwat side ta iba-iba a banuwan a adeyo. Te taga Partia; te taga Medo; te taga Elam; te taga Mesopatamia; te taga Hudea; te taga Kapadosia; te taga Ponto; te taga Asia; ");
INSERT INTO dgc_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","te taga Pirigia; te taga Pampiliya; te taga Egipto; te taga Libya a sakup na Sirena. Sakay te binumisita sa a taga Roma a Judeo, sakay éwan Judeo a sakup dén na rilihiyon na Judeo. ");
INSERT INTO dgc_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Te égsa sa a taga Kreta, sakay Arabia. Diden ya a étanan, maski iba-iba i kagi de, éy nabati de tu ginimet na Diyos a memahal, da nibaheta dide du alagad ta kanikaniya de a kagi. ");
INSERT INTO dgc_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ey basta mégtaka side a tahod, a négpakipakelagip side éng anya i kahulugina no gégemtén du alagad. ");
INSERT INTO dgc_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pero te iba sa a pinintasan de du alagad, a kagi de a lasing san side. ");
INSERT INTO dgc_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ey nadid, tinumaknég du labindalawa a apostol, éy tulos ti Pedro a négkagi du tolay ta medegsén. “Sikam a kapareho ko a Judeo,” kagi na, “sakay sikam a binumisita ta Jerusalemae, te kaginék dikam. Baten moy, ");
INSERT INTO dgc_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","éwan lasing didi kaguman kuae, da alas nuwebe pabi na gagabi. ");
INSERT INTO dgc_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Engˈwan, saye i péngtupad to nihula ni Purupeta Hoel to araw. ");
INSERT INTO dgc_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Kinagi dén na Diyos i gemtén na ta katapusan a panahun, a iasék na kan i Espiritu na ta étanan a tolay,” kagi ni Pedro. “Tulos magpahayag kan siya du anak moy ta kagi na. Sakay du lélake moy, éy maketa kan side ta tanda a kataka-taka. Sakay du matanda moy a lélake, éy ipatagenép na kan dide. ");
INSERT INTO dgc_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Sakay du sakup na Diyos a tolay, i nihula be ni Hoel, éy iasék kan dide na Diyos i Espiritu na ta éya a panahun; tulos ipahayag de kan i Diyos. ");
INSERT INTO dgc_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Sakay ipeta na kan ta langet i pagtakaan na tolay, sakay ipeta na kan be i tanda ta munduae. Te meta kan a dige sakay apoy sakay meaadu a asok. ");
INSERT INTO dgc_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ey nadid, bagu dumemét i aldew a késoli na Panginoon a maghukum,” kagi ni Pedro, “éy dumiklém kan pa i bilag. Sakay i bulan éy maging koman i dige i kolor naa. ");
INSERT INTO dgc_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Pero i maski ti ésiya a dumaying ta ngahen na Panginoon éy meligtas. ");
INSERT INTO dgc_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Nadid, sikam a kabébayan ko a Judeo,” kagi ni Pedro, “éy baten moy i kagi kuae. Ti Jesus a taga Nasaret, éy pinatunayan na Diyos dikam a gébwat ta langet i tungkulin naa; da pinagimet siya na Diyos ta meadu a makataka-taka, sakay tanda. Ey tukoy moy dén ya, da ginimet na dén ya ta harap moya. ");
INSERT INTO dgc_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Sapul to sapul, éy tiniyak dén na Diyos a itugén na dikam ti Jesus. Ey pinabuno moy siya, da inutusan moy dén du medukés a tolay a méngipako diya ta kudos. ");
INSERT INTO dgc_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pero binuhay siya na Diyos a huway. Pinaluwas na siya to lébéng, da éwan maari a éwan mabuhay siya a huway. ");
INSERT INTO dgc_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Baten moy tu nisulat ni Dabid. Nihula na to araw a manalangin ti Jesus ta kona se: ‘Neta ko a palagi a kéye se diyakén i Panginoon. Siya i kaguman ko, monda éwanék méligalig. ");
INSERT INTO dgc_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Kanya masaya i isip kua, sakay mésahaték ta kagi kua. Dahilan maski mateék, éy umasaék a buhayénék na Diyos. ");
INSERT INTO dgc_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ewan mo pébayan tu anak mo a mahunot tu bégi na ta luta. ");
INSERT INTO dgc_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Iatéd mo diyakén i buhay a éwan tu katapusan. Pasayaénék mo, da siko i kaguman ko.’ Saya tu nisulat ni Dabid. ");
INSERT INTO dgc_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“A tétotop ko,” kagi ni Pedro, “i nisulat a éya ni Dabid, éy éwan na nibaheta tu bégi na a sarili, da napospusan tam a minate dén siya, a kéye pabi i pantiyung na ta banuwana a éye. ");
INSERT INTO dgc_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","31","Engˈwan purupeta siya. Nihula na ngani i tungkul ta kébuhay a huway ni Cristo. I Diyos, éy nisumpa na ni Dabid a ta esa a panahun éy maghari tu apo na a esa ta kaharian naa. Ey nisulat ni Dabid i éya. Ey tu apo na éy ti Cristo. Siya i éwana pabayan ta Dinatagen. Siya i éwana mahunot ta lébéng. ");
INSERT INTO dgc_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ey nadid,” kagi ni Pedro, “i éya a Jesus, éy siya dén tu binuhay na Diyos. Ey sikame i sistigua na éya, da mineta me dén. ");
INSERT INTO dgc_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ti Jesus, éy pinataas dén siya na Diyos, a kaguman na dén siya nadid a méghari ta langet. Sakay naalap na dén Nama na tu nipangako na a Banal a Espiritu. Ey nadid, i mineta moya nadid ta éye éy tu Banal a Espiritu na Diyos, a niasék na dén dikame. ");
INSERT INTO dgc_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Tukoy tam a éwan nibaheta ni Dabid i sarili na, da éwan inumontok tu bégi na ta langet. Ey te sulat ti Dabid a esa, a kona se: ‘Kinagi na Diyos to amo ko, a “Mégiknud ka ta tagirilan kuae, ");
INSERT INTO dgc_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","a hanggan mapasuku ko diko du kalaban mo.”’ ");
INSERT INTO dgc_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Kanya nadid,” kagi ni Pedro, “éy dapat mapospusan na buu a banuwan na Israel a i éya a Jesus a nipako moy to kudos, éy siya i nidéton na Diyos a Panginoon na étanan. Siya i pinili naa a maghari ta tolay na munduae.” ");
INSERT INTO dgc_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nadid pékabati du tolay ta éya a kagi ni Pedro, éy nagsisi side a minasépduan side. “Adiyoy, Akéng,” kagi de, “magenya kame?” ");
INSERT INTO dgc_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ey kinagi ni Pedro, a “Pagsisian moy sakay ibutan moy du kasalanan moy. Sakay ipabinyag kam a ipasakup kam ni Jesu Cristo, monda patawadén na kam ta kasalanan moy, sakay tanggapén moy i kaluub na Diyos, a Banal a Espiritu. ");
INSERT INTO dgc_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Dahilan i nipangako na a Espiritu éy para dikam be, sakay ta anak moy, a sakay du édsa ta adeyo a lugar. Para ina ta maski ti ésiya a pinili na Panginoon Diyos.” ");
INSERT INTO dgc_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Kona sa i péghatul ni Pedro du tolay. Meadu i pékiohon naa dide, monda méniwala side. “Umadeyo kam du magkadukés a tolay,” kagi na, “monda meligtas kam ta parusa a dumemét dide.” ");
INSERT INTO dgc_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Nadid, du méniwala to kinagi ni Pedro éy nagpabinyag side. Te manga étélo a libu a tolay a nipasakup du alagad ta éya a aldew. ");
INSERT INTO dgc_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Tulos nanatili side a mégadal ta iyétoldu dide du apostol, sakay négkakaguman side ta mahusay. Négpisan side a aldew-aldew a méngan sakay ménalangin. ");
INSERT INTO dgc_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Du étanan a tolay sa, éy méganteng side, dahil ta meadu a makataka-taka a tanda a ginimet du apostol. ");
INSERT INTO dgc_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ey du étanan a méniwala éy négpisan-pisan side ta mahusay, sakay nibugtong de i étanan a ari-arian de. ");
INSERT INTO dgc_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Sakay i kabugtungana na éya éy niatéd de du kakaguman de ayun ta kailangan na bawat esa. ");
INSERT INTO dgc_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Aldew-aldew éy négpisan side ta Templo. Sakay négdipon side ta mahusay aldew-aldew ta bili-bile de, a masaya side tu isip. ");
INSERT INTO dgc_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Mégpuri side ta Diyos; sakay du iba a tolay, éy iyégalang de side. Ey bawat esa aldew éy te tolay a bigu a méniwala, a iyédagdag na Diyos dide, a niligtas na. ");
INSERT INTO dgc_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","To esa a aldew, a alas tres tu bilag, éy inumange ti Pedro sakay ti Juan ta Templo, da oras dén na pénalangin. To késdép de ");
INSERT INTO dgc_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","to memahal a pintuan, éy te lélake sa a lumpu sapul to nikeenak na. Du kaguman na éy iwahak de sa siya aldew-aldew, monda mékilimos ta bawat sumalegéd. ");
INSERT INTO dgc_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Siya, péketa na de Pedro a somdép, éy nékeged siya ta limos. ");
INSERT INTO dgc_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ey linameng siya du éduwa, sakay kinagi diya ni Pedro, a “Oy, enta mo ye.” ");
INSERT INTO dgc_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ey linameng side no lumpu, a inumasa dén a limusan de siya. ");
INSERT INTO dgc_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pero kinagi ni Pedro diya, a “Ewanék tu kuhata, pero te ibaék a iatéd diko. Ta pamag-itan na kapangyarian ni Jesu Cristo, éy utusan ta ka a umégkat a maglakad.” ");
INSERT INTO dgc_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Nadid, kembilan ni Pedro tu kamét na a inégkat, éy bigla a nakasibét tu tikéd na a éduwa. ");
INSERT INTO dgc_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Tulos linumuksu dén siya a tinumaknég, sakay tulos na dén a naglakad. Sakay sinomdép side a étélo ta Templo. Mésahat tu lumpu, a mégluksu-luksu siya, sakay mégpuri siya ta Diyos. ");
INSERT INTO dgc_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ey du tolay ta lubuk, éy neta de siya a méglakad, a pépurién na i Diyos. ");
INSERT INTO dgc_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ey mégtaka side a tahod, da natenggi de a siya bale tu dati a égse to pintuan a mékilimos. ");
INSERT INTO dgc_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Nadid, habang te kébil siya ni Pedro sakay ni Juan, éy méginan du tolay sa a étanan a dinumulug dide, da mégtaka side. I égsean dia éy tu kwarto ni Solomon. ");
INSERT INTO dgc_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ey ti Pedro, péketa na du mégdulug dide, éy négkagi siya dide. “Sikam a kabébayan ko,” kagi na, “bakit mégtaka kam ta éye? Bakit te lamengan moy kame ta kona sina? Akala moy napalakad me siya ta sarili me san a kapangyarian, o kabanalan? Ewan! ");
INSERT INTO dgc_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Diyos ngani dén i nagpalakad ta lumpuae! Siya ya i péniwalaana depo tam a Abraham, sakay ni Isak, sakay ni Hakob. Diyos i nagpataas to utusan na a ti Jesus. Pero sikam éy nitugén moy siya du te kapangyarian, sakay inidelan moy siya ta harap ni Gubernador Pilato, maski gustu na dén a légsiwan. ");
INSERT INTO dgc_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ti Jesus i mahusay a lélake, a éwan tu kasalanan. Pero inidelan moy siya, a nipékiohon moy ni Pilato a paluwasén na ta pégpihesuan i esa a lélake a namuno, a ti Barabas. ");
INSERT INTO dgc_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Kanya sikam,” kagi ni Pedro, “éy binunu moy dén tu méngatéd dikitam ta buhay tam. Pero binuhay siya na Diyos. Ey sikame i sistigua na éya. ");
INSERT INTO dgc_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Kanya i kapangyarian na ngahen ni Jesus, éy saya i nagpahusaya ta lélake a éye. Naghusay siya da méniwala siya ta ngahen ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Ey nadid, a tétotop ko,” kagi ni Pedro, “éy tukoy ko a éwan moy tukoy tu ginimet moy, da éwan moy napospusan a anak siya na Diyos; éy kona be sa du tagapamahala moy. ");
INSERT INTO dgc_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pero tu ginimet moy a éya, éy saya i nangtupad to dati a nipahayag na Diyos ta pamag-itan du purupeta, a ti Cristo éy kailangan a maghirap. ");
INSERT INTO dgc_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Kanya nadid, i pékiohon kua dikam éy magsisi kam, sakay magsoli kam ta Diyos, monda ibutan na du kasalanan moy, ");
INSERT INTO dgc_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","sakay atdinan na kam ta mahusay a buhay; sakay pasolen na se a huway ti Jesus, a iligtas na kam. Da siya i pinili naa. ");
INSERT INTO dgc_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Pero nadid a panahun, éy kailangan a manatili pabi ti Jesus ta langet, hanggan éwan dumemét i panahun a pangbagu na Diyos ta étanan, ayun to nipahayag na ta pamag-itan du purupeta na to araw. ");
INSERT INTO dgc_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Da kinagi ni Moises a paangen kan na Diyos dikitam i esa a purupeta a kona diya. Ey gébwat kan siya dikitam, kagi na. Ey kagi be ni Moises a dapat tam siya a baten. ");
INSERT INTO dgc_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Da i maski ti ésiya kan a éwan mégbati ta éya a purupeta, éy ibutan siya na Diyos, a pakaten na. Ey nadid, i éya a purupeta éy ti Cristo. ");
INSERT INTO dgc_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ey du étanan a iba a purupeta to araw, a sapul ni Samwel, sakay du sumunud diya, éy nagpahayag be side tungkul ta panahun tam nadid. ");
INSERT INTO dgc_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ey sikam,” kagi ni Pedro, “éy lahi kam diden ya a purupeta. Kanya para dikam i pangako na Diyos du apo moy to araw. Da kinagi na Diyos ni Abraham, a gemtén na kan i mahusay du étanan a tolay ta mundua ta pamag-itan du apo-apo na. ");
INSERT INTO dgc_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ey nadid,” kagi ni Pedro, “éy pinaange dén se na Diyos tu anak na dikam, monda iligtas na kam, monda ibutan moy i ugali moy a medukés.” ");
INSERT INTO dgc_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Nadid, mégkagi pabi de Pedro du tolay, éy inumange sa dide tu kapitan na guwardia ta Templo. Kaguman na du padi, sakay du sakup na rilihiyon na Saduseo. ");
INSERT INTO dgc_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Mégingél side du éduwa a apostol, da mégtoldu side du tolay a mabuhay i tolay a huway, da nabuhay dén ti Jesus. ");
INSERT INTO dgc_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Kanya dinikép de du éduwa, sakay nipihesu de pa hanggan to gagabi, da apon dén. ");
INSERT INTO dgc_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pero du meadu a nakabate to pégtoldu ni Pedro, éy naniwala side ni Jesus. Tulos dinumagdag side ta gurupu du alagad, hanggan inumabut side a étanan ta manga lima a libu a lélake. ");
INSERT INTO dgc_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Nadid, to gagabi dén, éy nagmiting ta Jerusalem du tagapamahala a Judeo, sakay du te tungkulin. ");
INSERT INTO dgc_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Kaguman de ti Anas a mataas a padi, sakay ti Kaipas, sakay ti Juan, sakay ti Alehandro, sakay du iba a top de. ");
INSERT INTO dgc_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pinaharap de du éduwa, éy nipakelagip de éng pinakodya de a nagpahusay to lumpu. “Ahe i nangalapan moya,” kagi de, “ta kapangyarian moy a nagimet ta éya a tarabaho moy?” ");
INSERT INTO dgc_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Nadid, édse ni Pedro ta mahusay i Banal a Espiritu, tulos sinengbet na side ta katuwiran na. “Sikam a mataas,” kagi na, ");
INSERT INTO dgc_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","“éng isiyasat moy dikame nadid tungkul ta memahal a nanyari ta lumpuae, sakay éng kodya siya a naghusay, éy saye i sengbet mia: ");
INSERT INTO dgc_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","dapat mapospusan na étanan a tolay, a kanya te taknég se i lumpuae a mahusay dén éy dahil ta kapangyarian ni Jesu Cristo a taga Nasaret. Saya tu nipako moy to kudos, a tulos binuhay na Diyos. ");
INSERT INTO dgc_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Mara siya tu bito a inidelan du mégbile, da isip de éy éwan tu pasa. Ey siya bale i mahalagaa a bito a panuluk na bile. ");
INSERT INTO dgc_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Kona sa ti Jesus, da siya san i tagapagligtas ta tolay. Da maski ahe ta mundua, éy éwan tu iba a makapagligtas ta tolay, éng éwan na éya a pinili na Diyos.” ");
INSERT INTO dgc_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Nadid, du te tungkulin ta éya, péketa de a metapang de Pedro sakay ti Juan, a bihasa side a mégtoldu, éy mégtaka side dide. Da tukoy de a mababa san side a tolay, a éwan nagadal. Ey nadid éy naala-ala de a kaguman bale side ni Jesus to te buhay na pabi. ");
INSERT INTO dgc_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Sakay péketa de to lumpu a te taknég ta gileda du éduwa, a mahusay dén, éy éwan side tu maisip a katuwiran a pangparusaan de dide. ");
INSERT INTO dgc_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Kanya pinaluwas de pa side to pégmitingan de, sakay néguhon side. ");
INSERT INTO dgc_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Anya i gemtén tam diden ya a lélake?” kagi de. “Da minehayag dén ta buu a Jerusalem i ginimet dia to lumpu. Ewan kitam makasaway ta éya. ");
INSERT INTO dgc_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pero nadid, monda éwan kumalat ta lalo i éya,” kagi de, “éy basta pégkagian tam side a diyan dén side magpahayag a huway ta ngahen ni Jesus.” ");
INSERT INTO dgc_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Kanya huway de a pinauwet de Pedro, sakay pinégkagian de side a diyan side huway a mégtoldu ta ngahen ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pero kinagi dide du éduwa, éy “Isipén moy éng anya i gustu na Diyos, éng sumunud kame dikam, o éng sumunud kame diya. ");
INSERT INTO dgc_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Pero para dikame,” kagi de, “éy éwan maari a éwan me ipahayag i mineta me a ginimet ni Jesus, sakay tu pégtoldu na dikame.” ");
INSERT INTO dgc_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Nadid, du te tungkulin, pékabati de ta éya, éy pinégkagian de side ta lalo a mahigpit, sakay linégsiwan de side. Ewan side tu maisip a katuwiran de a monda parusaan de du éduwa, dahilan du iba a tolay éy mégpuri side ta Diyos dahil to nanyari. ");
INSERT INTO dgc_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Sakay pati, tu lélake a pinahusay de éy mahigit dén ta épat a pulu a taon i idad naa. ");
INSERT INTO dgc_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Nadid, pékaluwas dén de Pedro, éy nagsoli side du kakaguman de, sakay nikagi de dide tu kinagi du mataas a Judeo dide. ");
INSERT INTO dgc_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ey to pékabati de ta éya, éy pisan side a nanalangin a étanan. “Panginoon Diyos,” kagi de, “siko i nanggimet ta langet, sakay ta diget, sakay ta luta, sakay ta étanan a égse dide. ");
INSERT INTO dgc_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Siko i négkagia ta pamag-itan ni Dabid a apo me, ta tulung na Banal a Espiritu. Bakit mégingél kan du éwan Judeo a tolay, kagi ni Dabid to kasulatan na. Sakay bakit mégisip kan du tolay ta éwan tama? ");
INSERT INTO dgc_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Du hari kan, sakay du mayor, éy négagum side a lumaban side ta Panginoon, sakay tu pinili na Diyos a maghari. ");
INSERT INTO dgc_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ey nanyari dén ya, Panginoon, i éya a nihula ni Dabid, da minagagum ngani dén ta banuwanae dudu linumaban ni Jesus. Ey siya tu inutusan mo, Améng, a pinili mo a maghari. Pati ti Hari Herod, sakay ti Gubernador Pilato, éy nékiagum side du Judeo sakay du éwan Judeo, a linumaban side ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ginimet de, Améng, i étanan a bagay a dapat manyari, a nitakda mo to éya pa. ");
INSERT INTO dgc_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ey nadid, Panginoon,” kagi de, “éy enta mo, mégbanta side dikame nadid a parusaan de kame. Aguman mo kame a utusan mo, monda metapang kame a mégtoldu ta kagi mua. ");
INSERT INTO dgc_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Itupu mo i kamét mo dikame, Panginoon, monda te meadu a tolay a magamot ta panalangin me. Monda makagimet kame ta tanda a makataka-taka ta pamag-itan no anak mo a banal a ti Jesus.” ");
INSERT INTO dgc_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Nadid, kétapos de a ménalangin ta éya a kagi, éy nayégyég tu égsean de a bile, a tulos inumasék dide ta mahusay i Banal a Espiritu. Tulos metapang side a mégbaheta ta kagi na Diyos. ");
INSERT INTO dgc_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nadid, du étanan a méniwala, éy négkaesa side tu isip. Ewan tu mégkagi a koo na san tu kasangkapan na, éngˈwan para ta étanan. ");
INSERT INTO dgc_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ey tulos du apostol a mégpahayag a minabuhay a huway ti Jesus. Sakay égse dide i dikél a kapangyarian na Diyos. Sakay niatéd na Diyos i biyaya na du étanan a méniwala diya. ");
INSERT INTO dgc_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ewan side tu kailangan ta kabuhayan de, maski ti ésiya dide, dahilan du te luta éy nibugtong de; sakay du te bile, éy nibugtong de be. Sakay tu kabugtungan de, éy niatéd de ");
INSERT INTO dgc_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","du apostol. Sakay du apostol éy binahabahagi de ta maski ti ésiya dide i te kailangan. ");
INSERT INTO dgc_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Kona sa i ginimet ni Hose. Libita siya a taga Sipro. I palayaw na éy ti Bernabe, a i kahulugina na éya éy Matulungin. ");
INSERT INTO dgc_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Nibugtong na tu luta na sakay niatéd na du apostol i kabugtungan na. ");
INSERT INTO dgc_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Pero te esa a lélake a ti Ananias i ngahen na. Tu asawa na éy ti Sapira. Te luta be side a nibugtong de. ");
INSERT INTO dgc_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Pero ti Ananias, éy binawasan na pa ta lihim i kabugtungan na. Ey kaguman na tu asawa na. Basta sénganya san i niatéd na du apostol. ");
INSERT INTO dgc_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pero kinagi ni Pedro diya, a “Bakit, Ananias, éy nadaig ka dén ni Satanas? Nagbuli-buli ka dén ta Banal a Espiritu! Bakit niliso mo i kalahati no kabugtungan no luta mo? ");
INSERT INTO dgc_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Bakit?” kagi ni Pedro, “to éwan mo pabi péngibugtong to luta, éy éwan beman koo moya? Nadid, to néngibugtong moy dén, éy éwan moy beman koo i kabugtungan naa? Ewan kame nékeged diko. Bakit naisip mo a iliso dikame i kalahati na kabugtungan naa? Ewan ka nagbuli-buli dikame, Ananias, éngˈwan Diyos i pinagbuli-bulian mua.” ");
INSERT INTO dgc_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","Nadid, pékabati ni Ananias ta éya, éy basta minebagsak siya a tulos minate dén! Ey du ulito sa, éy sinaputan de ta damit, sakay nielbéng de dén. Ey du étanan a nakabaheta ta éya, éy méganteng side a tahod. ");
INSERT INTO dgc_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Nadid, kélipas na étélo a oras, éy dinumemét sa tu asawa na, a éwan siya tu malay ta nanyaria. ");
INSERT INTO dgc_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ey kinagi diya ni Pedro, a “Anya, Sapira, séˈ san ya i kabugtungana no luta moy?” Ey “O,” kagi na, “séˈ ngani san ya.” ");
INSERT INTO dgc_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","“Bakit,” kagi ni Pedro, “nagkaisa kam bale a mamuhuba ta Espiritu na Panginoon! Enta mo, Sapira, di édse ta pintuana éy side ina du naglébéng to asawa mo; sakay siko man dén i ielbéng dia nadid!” ");
INSERT INTO dgc_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Nadid, pékabati ni Sapira ta éya, éy bigla be siya a minatumba ta harap ni Pedro, a tulos nabégsot i angés naa. Ey késdép du ulito, éy neta de a minate be tu bébe. Kanya niluwas de be, a nielbéng de be to giled no asawa na. ");
INSERT INTO dgc_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ey méganteng a tahod du iba a tolay a nakabati ta éya. I Meadu a Kataka-taka ");
INSERT INTO dgc_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Nadid, ginimet du apostol i meadu a tanda a makataka-taka ta harap du tolay. Ey du étanan a méniwala, éy mégpisan-pisan side aldew-aldew to kuwarto ni Solomon ta Templo. ");
INSERT INTO dgc_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ey du iba a tolay ta Jerusalem, éwan side nangahas a mékiagum dide; pero te galang side du méniwala. ");
INSERT INTO dgc_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ey tulos a kinumadu a kinumadu aldew-aldew i méniwala ta Panginoon. Lélake éy ta bébe. ");
INSERT INTO dgc_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Sakay dudu te saket, éy niange side du kakaguman de ta karsada, a nipakatidug de ta kakama de, sakay abék de, monda éng sumalegéd ti Pedro, éy malduman maka san no anino na i sénganya dide. ");
INSERT INTO dgc_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Kanya inumange be sa i meadu a tolay a gébwat du banubanuwan ta palebuta na Jerusalem, a kembil de sa du te saket, sakay du hinayup. Ey naghusay side a etanan. ");
INSERT INTO dgc_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Nadid, du mataas a padi, éy ménaghili side a tahod du apostol. Ey kona be sa du kaguman de a Saduseo. ");
INSERT INTO dgc_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Kanya dinikép de du apostol, a nipihesu de. ");
INSERT INTO dgc_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pero to kélép, éy inumange dide i esa a anghel a gébwat ta Panginoon, a tulos binuksan na tu pintuan no pégpihesuan, sakay niluwas na side, sakay kinagi na dide, a ");
INSERT INTO dgc_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Ikad moy dén ta Templo, sakay magtoldu kam du tolay ta tungkul ta bigu a buhay.” ");
INSERT INTO dgc_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ey sinumunud du apostol. To amulaldew, éy sinomdép side ta Templo, tulos mégtoldu man dén side ta tolay sa. Mentaras mégtoldu side, éy dinumulug du mataas a padi to pégmitingan de, da talaga side a mangbista du apostol. Nadid, to képisan de, éy nipauwet de du apostol ta pégpihesuan. ");
INSERT INTO dgc_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Pero kédemét sa du pulis, éy éwan bale sa side! Kanya nagsoli du pulis ta pégmitingan, a kinagi de ");
INSERT INTO dgc_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","a éwan sa side! “Tu pintuan no pégpihesuan éy nakakandadu ta mahusay,” kagi de. “Pati du guwardia éy mégbantay san side to pintuan. Pero to péngbukas me,” kagi de, “éy éwan bale tu tolay ta lubuk!” ");
INSERT INTO dgc_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nadid tu hepe du pulis ta Templo, sakay du padi, pékabati de ta éya, éy méligalig side tu isip, éng anya i nanyaria du apostol. ");
INSERT INTO dgc_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ey to pégisip de pabi, éy te dinumemét dide a négkagi, a “Bakit? Du lélake a nipihesu moy éy kéya man dén side ta Templo a mégtoldu!” ");
INSERT INTO dgc_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Nadid tu hepe, sakay du pulis, pékabati de ta éya, éy inange de side inuwet. Pero éwan de side pinilit, da méganteng side a makay batikalén side du tolay sa a mégbati. ");
INSERT INTO dgc_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Nadid, péngiange de dide to pégmitingan de, éy siniyasat side no mataas a padi. ");
INSERT INTO dgc_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Isip ko nibawal me dikam ta mahigpit a diyan kam mégtoldu a huway ta éya a ngahen!” kagi na. “Pero entan moy i ginimet moya! Nekalat dén ta Jerusalem i pégtoldu moya! Sakay gustu moy pa a sikame i managuta to nikate na éya a lélake!” ");
INSERT INTO dgc_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pékabati de Pedro ta éya, éy kinagi de, éy “Diyos i dapat me a sundin, kesira dikam. ");
INSERT INTO dgc_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Sikam éy binunu moy ti Jesus to kudos. Pero i Diyos a péniwalaan du apo-apo tam, éy binuhay na siya. ");
INSERT INTO dgc_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Pinataas be siya na Diyos ta étanan, a siya i kaguman naa a maghari ta langet. Ti Jesus i tagapagligtas, sakay mayor siya ta étanan a tolay, monda maari du Judeo a ibutan de tu kasalanan de, tulos pagpasensiyaan side na Diyos. ");
INSERT INTO dgc_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ey sikame,” kagi ni Pedro, “i sistigua na éya. Sakay pati i Banal a Espiritu a iatéd na Diyos ta bawat méniwala diya, éy siya be ya i mégpatunaya.” ");
INSERT INTO dgc_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Nadid, pékabati du te tungkulin ta éya, éy méiyamut side a tahod, a gustu de a ipabuno du apostol. ");
INSERT INTO dgc_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pero te esa sa a Pariseyo, a ti Gameliel i ngahen naa. Maistu siya na rilihiyon na Judeo. Ey iyégalang siya du tolay. Siya, éy tinumaknég to pégmitingan de. Niutus na a iluwas de pa du apostol, ");
INSERT INTO dgc_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","tulos hinatulan na du kakaguman na. “Kabébayan ko,” kagi na; “isipén moy ta mahusay i gemtén moy di tolay a ina. ");
INSERT INTO dgc_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Tandaan moy ti Teudas to éya; nagwari-wari siya a mataas. Ey te manga épat a datos a lélake a nékiagum diya. Pero to nikate na éy nahiwahiwalay du tolay na. Ey basta naibut tu rilihiyon na. ");
INSERT INTO dgc_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ey kétapos na éya, éy minetanyag man dén i esa man dén a lélake, to panahun no sensos; ti Hudas a taga Galilea. Ey meadu be siya a tolay a nipasakup diya. Pero minate be siya, a tulos nahiwahiwalay be du tolay na. ");
INSERT INTO dgc_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Kanya nadid,” kagi ni Gamaliel, “éy diyan kitam mékialam di tolaya a éye. Pabayan moy side. Eng gébwat ta isip de sana i gimet dia, éy maibut. ");
INSERT INTO dgc_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pero éng gébwat ta Diyos, éy éwan moy maari a mabawalan. Makay sakali éy Diyos dén i labanan moya!” Nadid du te tungkulin, pékabati de ta éya a kagi ni Gamaliel, éy pinumayag side. ");
INSERT INTO dgc_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ey nadid, pinasdep de man dén du apostol, sakay binalbal de side, sakay binawalan de side a mégpahayag a huway ta ngahen ni Jesus, sakay linégsiwan de side. ");
INSERT INTO dgc_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ey du apostol, hinumektat side to pégmitingan de a mésahat, da neta de a tinanggap side na Diyos, a pinili na side a mégtiis ta hirap alang-alang ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ey sigi san side aldew-aldew a méngipahayag ni Jesus ta Templo sakay ta bili-bile, a siya i pinilia na Diyos a tagapagligtas. ");
INSERT INTO dgc_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Nadid, to panahun a éya, éy négkékakadu i méniwala ni Jesus. Pero du Judeo sa a dayuan, éy naglekramo side du taga Jerusalem a Judeo, dahilan, kagi de, éy du bilo de a bébe ta gurupu de, éy mépabayan kan side aldew-aldew bagay bahabahagién du apostol i kabuhayan. ");
INSERT INTO dgc_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Kanya du apostol éy inipun de i étanan a méniwala a mégmiting side. “Ewan maari a sikame i bahala a mégbahabahagi aldew-aldew ta gastos a para du kaguman tam a pobri,” kagi de, “da bahala kame san a mégpahayag ta kagi na Diyos. ");
INSERT INTO dgc_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Kanya, a tétotop me,” kagi de, “éy pilién moy ta kakaguman moy i pitu a lélake. Magpili kam ta matalinung a lélake a tukoy moy a égse dide ta mahusay i Banal a Espiritu. Ey sikame a apostol, éy atdinan me side ta tungkulin de a side i tagahatia ta gastos a para du pobre. ");
INSERT INTO dgc_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ey sikame,” kagi de, “éy tulos kame san a ménalangin, sakay mégtoldu ta kagi na Diyos.” ");
INSERT INTO dgc_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Nadid, pékabati du gurupu de ta éya, éy mahusay side tu isip. Tulos nagpili side ta pitu a lélake. Pinili de pa ti Esteban, da siya i méniwala a tahod, sakay égse diya ta mahusay i Banal a Espiritu. I iba a pinili de éy de Pelip, Prokoro, Nikanor, Timon, Parmenas, sakay ti Nikolas a taga Antiokia. Siya éy éwan Judeo, pero dati siya a sakup na ugali na Judeo. ");
INSERT INTO dgc_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Side éy niharap de du apostol; tulos nitupo de i kamét dia dide, sakay nipanalangin de side. ");
INSERT INTO dgc_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ey nadid, tulos nagkabahibaheta dén i kagi na Diyos. Ey lalo a négkékakadu i nipasakup ni Jesus ta Jerusalem. Sakay te meadu be a padi a méniwala. ");
INSERT INTO dgc_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Nadid ti Esteban, éy inatdinan na Diyos ta biyaya sakay ta kapangyarian na; tulos gégemtén na i meadu a kataka-taka ta harap du tolay. ");
INSERT INTO dgc_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Nadid, te iba a Judeo a inumange sa a nékipagsuway ni Esteban. Sakup side na gurupu na Libertines. Te kaguman be side a Judeo a taga Sirene, sakay Alehandera, sakay Silisia, sakay Asia. ");
INSERT INTO dgc_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pero éwan de nadaig tu karunungan ni Esteban, a niatéd diya na Espiritu. ");
INSERT INTO dgc_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Kanya side, éy sinulsulan de ta lihim i sénganya a lélake a kagin de a ti Esteban éy nabati de kan siya a méngupos ni Moises sakay ta Diyos. ");
INSERT INTO dgc_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Nadid, linigalig de du tolay sakay du te tungkulin a hanggan naiyamut side ni Esteban. Tulos dinikép de siya sakay niharap de siya du mataas a padi. ");
INSERT INTO dgc_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","To péngbista de, éy niharap de be sa du mégsistigu ta kakabulyan a kontara ni Esteban. “Palagi siya,” kagi de, “a mégkagi ta kontara ta Templo, sakay ta ugali ni Moises. ");
INSERT INTO dgc_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nabati me siya a mégkagi a hukatén kan ni Jesus i Templo tama, sakay baguén na kan i étanan a ugali tam a niutus dikitam ni Moises to araw!” ");
INSERT INTO dgc_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Nadid, du étanan a te eknud sa éy inentan de ti Esteban éy neta de i mudet na éy koman bale dén i mudet na anghel a gébwat ta Diyos. ");
INSERT INTO dgc_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Nadid, tu mataas a padi éy kinagi na ni Esteban, a “Anya, tutuhanan i éya a niabla de? Anya i katuwiran mua?” ");
INSERT INTO dgc_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ey saye i atakduga a nisengbet ni Esteban dide: “Sikam a matétanda, sakay sikam a tétotop ko,” kagi na, “baten moy i kagin kuae. To araw éy pinumeta i Diyos to apo tam a Abraham to pégiyan na kan pabi ta Mesopotamia, bagu négiyan ta Haran. ");
INSERT INTO dgc_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ey anya tu kinagi na Diyos diya? ‘Ginanan mo, Abraham,’ kagi na, ‘du tétotop mo se, sakay tu luta mo, a umange ka ta iba a lugar a ipeta ko diko.’ ");
INSERT INTO dgc_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ey nadid,” kagi ni Esteban, “éy hinumektat ti Abraham to banuwan na, a inumagton kan dén ta Haran. Ey to nikate no ama na, éy pinaagton man dén siya na Diyos ta banuwan tam a éye. ");
INSERT INTO dgc_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Pero éwan na inatdinan ti Abraham ta luta na a sarili, maski kétihék. Pero i nipangako naa diya, éy iatéd na kan diya ta esa a panahun i lutaae a étanan, a para koo na apo-apo na. Ey to péngikagi na diya ta éya, éy éwan bale pabi ti Abraham tu anak. ");
INSERT INTO dgc_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ey kinagi be na Diyos ni Abraham, a bagu mégiyan se du apo-apo na, éy mégiyan pa side ta adeyo a banuwan. Ey pilitén kan side na iba sa a tolay, a pahirapan de side ta lubuk na épat a datos a taon. ");
INSERT INTO dgc_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","‘Pero,’ kagi na Diyos, ‘éy parusaan ko diden ya a tolay a magpahirap du apo-apo mo. Sakay humektat sa du apo-apo mo,’ kagi na, ‘a umange se side a magsamba se side diyakén.’ ");
INSERT INTO dgc_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ey nadid, to pégkagi na Diyos ni Abraham, éy inutusan na siya a ipabugit, da saya i tanda no pangako na. Sakay ti Abraham, pégenak no anak na a ti Isak, éy binugit na be siya, to walu pabi a aldew i idad naa. Sakay ti Isak, anak na ti Hakob. Sakay ti Hakob, anak na du sapulu éy ta éduwa a lélake. Ey side ya di apo-apo tama to araw, sikitam a Judeo. Kanya binugit de du anak de, éy tanda ya no pangako na Dios to apo tam to araw. ");
INSERT INTO dgc_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Nadid, tu anak ni Hakob a esa, éy ti Hose. Du aka na, éy sumésene kan side diya. Kanya nibugtong de siya; tulos naging utusan siya ta Egipto. Ey kaguman sa siya na Diyos, ");
INSERT INTO dgc_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","a inaguman na siya ta étanan a hirap na ta éya. Inatdinan na kan ti Hose ta katalinungan na, monda kéharap na ni Hari Paraon, éy gustu na siya, tulos ginimet na ti Hose a naging gubernador ta étanan na banuwan na Egipto, sakay siya kan be i mayor to bile no hari. ");
INSERT INTO dgc_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Nadid, to panahun pabi ni Hose éy dinumemét i dikél a alép ta buu a Egipto a hanggan ta Kanaan. Te dikél kan a hirap, a hanggan éwan dén tu paketan du apo tam ta kanén. ");
INSERT INTO dgc_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ey ti lakay a Hakob, pékabaheta na a te pahay kan ta Egipto, éy pinaange na sa du anak na a sapulu. Saya i purumeru a bisita de ta éya. ");
INSERT INTO dgc_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Nadid,” kagi ni Esteban, “to ikaduwa a bisita de ta éya a mégipahay, éy nipatenggi kan dén ti Hose du aka na, a siya bale dén tu wadi de! Ey napospusan kan ni Hari Paraon i tungkul du tétotop ni Hose. ");
INSERT INTO dgc_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ey nadid, nipauwet ni Hose tu ama na a Hakob, sakay du pamilya na a étanan; pitu a pulu éy ta lima side a étanan. ");
INSERT INTO dgc_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ey nagkobu kan dén de Hakob ta Egipto. Ey minate kan sa siya, sakay minate be sa du apo-apo tam. ");
INSERT INTO dgc_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","I bangkay dia, éy kembil de ta Sikem, sakay nielbéng de to lébéng a binugtong ni Abraham to éya pa du anak ni Hamor. ");
INSERT INTO dgc_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Nadid, adene a matupad tu pangako na Diyos ni Abraham, éy meadu dén a tahod du Judeo ta Egipto. ");
INSERT INTO dgc_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ey nadid éy te hari dén a iba ta Egipto a éwan na kan tukoy ti Hose. ");
INSERT INTO dgc_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Siya éy pinagsamantalaan na kan du apo tam, sakay pinilit na side a ibut de du anak de a bigu, monda mate side. ");
INSERT INTO dgc_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ta panahun a éya éy nienak ti Moises, éy kamahalan kan siya a anak. Ey inalagaan siya nena na ta bile ta étélo a bulan. ");
INSERT INTO dgc_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Sakay to péngibut de diya, éy inalap siya no bébe a anak no hari, sakay pinadikél na siya a koman na i anak a sarili. ");
INSERT INTO dgc_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Sakay tinolduan de kan ti Moises ta étanan a adal na Egipto. Ey naging matalinung kan siya ta kagi éy ta gimet na. ");
INSERT INTO dgc_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Nadid,” kagi ni Esteban, “to épat a pulu a taon i idad ni Moises, éy naisipan na a umange bumisita du kapareho na a Judeo, du apo-apo ni Israel. ");
INSERT INTO dgc_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ey to kébisita na dide, éy neta na kan a apién no Egipto i esa dide. Kanya ti Moises éy nisuhog na tu Judeo, a binunu na tu Egipto. ");
INSERT INTO dgc_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Akala ni Moises éy tukoy du kabébayan na a siya i pinilia na Diyos a mangagaw dide ta hirap de. Pero éwan de kan tukoy. ");
INSERT INTO dgc_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Dahilan, to kagagabian na éya, éy neta na i éduwa a Judeo a méglébug; éy talaga na kan side a awatén. ‘Kadimoy,’ kagi na, ‘bakit méglébug kam? Pareho kam a Judeo.’ ");
INSERT INTO dgc_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Pero tu te kasalanan, basta nitogpal na kan ti Moises, a kinagi na diya, a ‘Ti ésiya i nagutusa diko a mégmayor dikame? ");
INSERT INTO dgc_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Gustu mo bale a bunonék mo a kona to ginimet mo to apon se to Egipto?’ ");
INSERT INTO dgc_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ey ti Moises, pékabati na kan ta éya, éy ginuminan dén siya ta banuwan na Egipto, a inumagton kan dén siya ta Madian. Ey nagenak sa tu asawa na ta éduwa a anak a lélake. ");
INSERT INTO dgc_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Nadid, pékalipas na épat a pulu a taon, éy égsa ti Moises ta buked na Sinay ta ilang a lugar. Ey pinumeta sa diya i esa a anghel a te tupo to kéhiték a kayo a medingat ta apoy. ");
INSERT INTO dgc_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Péketa ni Moises ta éya, éy mégtaka kan siya. Ey to kégébék na a entan, éy nabati na i boses na Diyos. ");
INSERT INTO dgc_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Moises,’ kagi na, ‘sakén i Diyos a pinéniwalaan du apo moy a ti Abraham, Isak, sakay Hakob.’ Ey ti Moises, pékabati na ta éya, éy méganteng kan siya a tahod, a mésanike dén a lumameng a huway. ");
INSERT INTO dgc_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ey kinagi na Panginoon diya, a ‘Ibutan mo, Moises, i sinelas mua, da i luta a éye éy égsean na Diyos. ");
INSERT INTO dgc_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nadid, Moises,’ kagi na Diyos, ‘éy mineta ko ngani dén i hirap du tolay ko ta Egipto, sakay nabati ko be dén i dayidaying dia diyakén. Ey nadid éy inumogsadék dén a mangagaw dide. Kadon, Moises,’ kagi na, ‘da paangen ta ka ta Egipto.’ ");
INSERT INTO dgc_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Nadid, i éya a Moises,” kagi ni Esteban, “éy siya a mismo tu lélake a inidelan dén du Judeo to purumeru, a kinagi de diya éng ti ésiya i nagutusa diya a magmayor dide. Ey Diyos ngani dén i nagutusa diya a magmayor dide, sakay mangagaw dide, ta pamag-itan no anghel a mineta na to kayo a medingat. ");
INSERT INTO dgc_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ey ti Moises éy ginimet na kan i meadu a makataka-taka ta Egipto, sakay ta Medideg a Diget, sakay ta ilang a lugar ta lubuk na épat a pulu a taon. Siya i nagpaluwasa du Judeo ta Egipto. ");
INSERT INTO dgc_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","I éya a Moises, éy siya be i négkagi du Israel, a paangen kan na Diyos dikitam i esa a purupeta a kona diya. Ey gébwat kan siya dikitam, kagi na. ");
INSERT INTO dgc_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ti Moises be i kagumana du tolay a Israel to pégiyan de to melawa a ilang a lugar. Napisan side ta buked na Sinay to pégkagi no anghel ni Moises ta éya. Tinanggap kan ni Moises ta éya i utus na Diyos a éwan malipas, monda iatéd na dikitam. ");
INSERT INTO dgc_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Pero du apo tam,” kagi ni Esteban, “éy éwan de sinunud ti Moises. Inidelan de kan siya, a gustu de maka a sumoli ta Egipto. ");
INSERT INTO dgc_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Kanya, to péglakad ni Moises to buked, éy kinagi de ni Padi Aron, a ‘Magimet ka pad ta ribultu a diyos tam, monda te méngigiya dikitam. Dahilan,’ kagi de, ‘ti Moises a néngigiya dikitam a linumwas ta Egipto, éy éwan tam tukoy éng ahe siya.’ ");
INSERT INTO dgc_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Tulos ginimet de kan i diyos-diyosan de a ribultu na baka. Sakay nagatang side to harap na. Ey mésaya side to ginimet de, a nipagpiyesta de. ");
INSERT INTO dgc_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ey dahil ta éya, éy inidelan side na Diyos, a pinabayaan na side a sumésamba ta diyos-diyosan, ayun to nakasulat ta libru du purupeta. ‘Sikam a Israel,’ kagi na Diyos, ‘bakén a sakén i inatdinan moya to niatang moy ta hayup to pégiyan moy ta ilang a lugar. ");
INSERT INTO dgc_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","I sinésambaan moya éy du diyos-diyosan a biton a Molok sakay tu biton a Rempan, sakay du iba a ginimet moy a ribultu. Kanya sakén,’ kagi na Diyos, ‘éy ibut ta kam ta dumanég a sa na Babilonia.’ ");
INSERT INTO dgc_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Nadid,” kagi ni Esteban, “to pégiyan pabi du apo-apo tam to ilang a lugar, éy nagimet side ta dikél a tolda a pégsimbaan de, a kona to niutus na Diyos ni Moises. Saya i tanda a kaguman de i Diyos. I sukat na kan éy kapareho no nitoldu na Diyos ni Moises. ");
INSERT INTO dgc_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ey to panahun ni Hosue a mayor de, éy kembil de tu tolda to késdép de ta luta a pégiyanan de. Sakay i Diyos, éy inibutan na du iba a tolay a dati a égsa sa. Ey tu tolda, éy ginamit de a hanggan ta panahun ni Hari Dabid. ");
INSERT INTO dgc_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ey kinasahatan na Diyos ti Dabid. Ey pinakelagipan na i Diyos éng siya i maari a magimet ta dikél a bile a pégiyanan na Diyos. ");
INSERT INTO dgc_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pero ti Solomon i nagimita ta éya a bile. ");
INSERT INTO dgc_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Pero entan moy,” kagi ni Esteban, “i mataas a Diyos éy éwan mégiyan ta ginimét na tolay a bile, ayun to kagi no purupeta: ");
INSERT INTO dgc_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Mégiyanék ta langet,’ kagi na Diyos, ‘sakay i mundua éy saya i te tupuana na tikéd kua. Anya i bile a gemtén moy a para diyakén. Anya,’ kagi na Diyos, ‘te kailanganék ta bile a imangan ko? ");
INSERT INTO dgc_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Sakén i nagimita ta étanan.’ ");
INSERT INTO dgc_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Pero sikam,” kagi ni Esteban, “éy mekétog i ulo moya! Ewan pabi nabagu i isip moya! Sala moy a baten i katutuhanan! Bakit éidelan moy i Banal a Espiritu? Kona be sa du apo moy to araw, éy kona kam be sa nadid! ");
INSERT INTO dgc_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Entan moy,” kagi na, “du purupeta to araw, éy linéloko side du apo moy. Sakay du naghula a dumemét se i anak na Diyos, éy binunu de side. Ey nadid, to kédemét na dén se, éy nitokyon moy siya, sakay binunu moy! ");
INSERT INTO dgc_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Sikam i néngiatdinana na anghel ta utus na Diyos to araw pero éwan moy sésundin!” ");
INSERT INTO dgc_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Nadid, pékabati du te tungkulin ta éya a kagi ni Esteban, éy méiyamut side a tahod, a mégingél side diya. ");
INSERT INTO dgc_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ey ti Esteban, basta te tangad san siya ta langet, a édse diya ta mahusay i Banal a Espiritu. Sakay neta na sa i demlag na Diyos, sakay ti Jesus a te taknég ta giled naa. ");
INSERT INTO dgc_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","“Entan moy,” kagi na, “meta ko a bukas dén i langet, sakay tu lélake a gébwat ta langet, éy te taknég siya ta giled na Diyos.” ");
INSERT INTO dgc_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ey du te tungkulin, pékabati de ta éya, éy basta tinaklében de tu talinga de, sakay hinabuhabukan de siya, sakay bigla de a dinale, ");
INSERT INTO dgc_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","sakay hinela de a niluwas to banuwan. Sakay binunu de siya a binatikal de siya ta bito. Ey du namuno diya, éy niedton de pa tu badu de to harap no esa a lélake, a i ngahen na éy ti Saulo. ");
INSERT INTO dgc_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","To péngbatibatikal de pabi diya, éy nanalangin siya, a kagi na, a “Panginoon, agawén pad i kaliduwa kua.” ");
INSERT INTO dgc_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Tulos linumuhud siya a kinagi na ta medegsén, a “Panginoon, diyan pad side sésisin ta éye a kasalanan de.” Ey to pégkagi na ta éya, éy tulos minate dén. Ey mésahat ti Saulo to kéte ni Esteban. Te sénganya sa a lélake a mékidiyos, éy side ya i néngielbénga diya, a minagsanget side diya ta meadu. ");
INSERT INTO dgc_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Nadid, ta éya a mismo a aldew, éy nagsapul du tolay ta Jerusalem a méngloko du méniwala ni Jesus. Mahigpit i pékialam de dide, a hanggan minasiwéd-sewéd dén side ta iba-iba a banuwan ta Hudea, sakay ta Samaria. Basta du apostol san i nabuhaya ta Jerusalem. ");
INSERT INTO dgc_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Samantala ti Saulo, éy pinumilit siya a mangloko du méniwala ni Jesus. Pinasdép na du tolay na ta bili-bile, sakay pinadikép na du méniwala, sakay nipepihesu na side. Lélake éy ta bébe. ");
INSERT INTO dgc_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Nadid, du minasiwéd-sewéd, éy nagpahayag side ta kagi na Diyos ta bawat banuwan a inangayan de. ");
INSERT INTO dgc_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Mara ti Pelip éy inumange siya ta Samaria, sakay nipahayag na ti Jesus du tolay sa. ");
INSERT INTO dgc_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ey side éy binate de tu kagi na, da neta de tu gimet na a kataka-taka. ");
INSERT INTO dgc_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Da neta de a nagamot dén i meadu a pile éy ta lumpu; sakay i meadu a tolay a hinayup, éy naibut dide du medukés a espiritu, a mégkélanget side. ");
INSERT INTO dgc_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Te meadu a masaya a tolay ta Samaria. ");
INSERT INTO dgc_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Te esa a lélake ta éya a ti Simon i ngahen na. Dati siya a mégimet ta pégtakaan du tolay sa, da bihasa siya a mégsalamangka. Nagpataas siya ta sarili na ta pamag-itan na galing naa. ");
INSERT INTO dgc_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Binati siya na étanan sa a tolay, da te kapangyarian kan siya a mahigpit a gébwat kan ta Diyos. ");
INSERT INTO dgc_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Naniwala side diya, da nale a panahun a mégtaka side ta galing na a iyépeta na dide. ");
INSERT INTO dgc_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pero nadid, éy nagpahayag ti Pelip dide ta Mahusay a Baheta tungkul ta péghari na Diyos ta tolay, sakay ta ngahen ni Jesu Cristo. Ey naniwala side a tulos nipabinyag side. ");
INSERT INTO dgc_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Pati ti Simon, éy naniwala be, sakay nipabinyag be siya, sakay nékiagum siya ni Pelip, da mégtaka siya to gimigimet na a makataka-taka. ");
INSERT INTO dgc_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Nadid, pékabaheta du apostol ta Jerusalem a tinanggap dén du tolay ta Samaria i kagi na Diyos, éy pinaange de sa de Pedro sakay ti Juan. ");
INSERT INTO dgc_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Side, kédemét de ta Samaria, éy nipanalangin de du tolay sa, a monda umasék dide i Banal a Espiritu, ");
INSERT INTO dgc_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","da éwan pabi dinumibi dide. Dahilan, to pékabinyag dide ni Pelip, éy ngahen san ni Panginoon Jesus i dinulawan naa. ");
INSERT INTO dgc_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Nadid ti Pedro sakay ti Juan, péngitupu de ta kamét dia dide, éy inumasék dide i Banal a Espiritu. ");
INSERT INTO dgc_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Nadid ti Simon a mégsalamangka, éy mineta na tu ginimet de Pedro, a umasék i Espiritu du tolay bagay itupu de tu kamét de dide. Kanya talaga siya a mangatéd dide ta kuhata. ");
INSERT INTO dgc_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Nay,” kagi na, “atdinanék moy be ta kabahagi na kapangyarian moya, monda éng itupu ko i kamét kua ta tolay, éy umasék be dide i Banal a Espiritu.” ");
INSERT INTO dgc_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pero ti Pedro, i kinagi naa éy “Mepahamak ka, Simon, sakay na kuhata mua. Bakit, isip mo makabugtong ka ta Espiritu na Diyos? ");
INSERT INTO dgc_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ewan ka tu kabahagi ta éye, da meeta na Diyos a medukés i isip mua. ");
INSERT INTO dgc_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Magsisi ka, Simon, ta gimet mo a medukés. Manalangin ka ta Panginoon, monda maka éy pagpasensiyaan na ka ta isip mo a medukés. ");
INSERT INTO dgc_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Da mineta ko a ménaghili ka tu isip, a nadaig ka na kasalanan mo.” ");
INSERT INTO dgc_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","“Adiyoy,” kagi ni Simon, “ipanalanginék moy pad, monda éwan tu manyari diyakén a kona to kinagi mo.” ");
INSERT INTO dgc_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Nadid, kétapos de Pedro a nagpatunay ta baheta ni Jesus ta Samaria, éy nagsoli side ta Jerusalem. Péglakad de, éy nagpahayag side ta Mahusay a Baheta ta bariyo-bariyo ta Samaria a dinaman de. ");
INSERT INTO dgc_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Nadid, te esa a anghel na Panginoon a inutusan na ti Pelip. “Ange ka,” kagi na, “dumiman to kamino a tamo ta Gasa, a gébwat ta Jerusalem.” I éya a kamino éy édse ta ilang a lugar. ");
INSERT INTO dgc_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Ey ti Pelip, pékabati na ta éya, éy néglakad dén siya. Ey katagbu na sa i esa a lélake a mégkalesa, a taga Etiopia. Gébwat siya ta Jerusalem, da inumange sa a sinumamba ta Diyos. Siya éy katulung no hari ta Etiopia a bébe. Iyégalang siya a lélake, da siya i bahala to kayamanan no hari. To péglakad no kalesa na, éy mégbasa siya ta kasulatan ni Purupeta Isaya. ");
INSERT INTO dgc_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ey tu Espiritu na Diyos, éy kinagi na ni Pelip, a “Nay, abutén mo i éya a kalesa.” ");
INSERT INTO dgc_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Kanya minaginan ti Pelip a inabut na tu kalesa, sakay nabati na tu lélake a mégbasa to kasulatan. Ey kinagi ni Pelip diya, a “Anya, mépospusan mo i kahulugina na bébasaén mo a ina?” ");
INSERT INTO dgc_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","“Ey pakodyan ko a mépospusan,” kagi na, “éng éwan tu magpaliwanag diyakén?” Tulos inakit na ti Pelip a sumakay to kalesa na. ");
INSERT INTO dgc_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ey nadid, saye i nabasaa no lélake to kasulatan: “I tupa éy éwan mégsanget bagay kébilén mo siya a bunon. Tahimik be siya bagay gupitan mo. Ey kona be sa i éya a lélake. Ta pémasaket de diya éy umaheg san siya ta tupa, a te ginék san. ");
INSERT INTO dgc_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ta péngloko de diya éy éwan side tu katuwiran. Medukes i éya a lahi a tolay, da bunon de siya.” ");
INSERT INTO dgc_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Kinagi no lélake ni Pelip, a “Ti ésiya i pinégkagiana no purupeta, sarili na a bégi, o iba?” ");
INSERT INTO dgc_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Kanya ti Pelip, éy nipaliwanag na diya i éya a kagi, tulos tinolduan na siya ta Mahusay a Baheta tungkul ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ey to péglakad de, éy dinumemét side to dinom. “Entan mo,” kagi no lélake, “te dinom dén. Maariék wade dén a binyagen?” ");
INSERT INTO dgc_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","“Maari,” kagi ni Pelip. “Eng méniwala ka dén a talaga, éy maari dén.” “Méniwalaék,” kagi na, “a ti Jesu Cristo éy anak na Diyos.” ");
INSERT INTO dgc_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Nadid, pinahintu no lélake tu kalesa, a inumogsad side a éduwa, sakay linumusung side to dinom, sakay bininyagen siya ni Pelip. ");
INSERT INTO dgc_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ey kéahawas de to dinom, éy ti Pelip éy inalap na Espiritu na Panginoon. Ewan dén siya mineta no lélake. Nagtulos san dén siya ta Etiopia a mésahat. ");
INSERT INTO dgc_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ey ti Pelip, éy édsa dén siya ta Asoto. Ey sapul ta éya éy nagpahayag siya ta Mahusay a Baheta ta étanan a banuwan a dinimanan na hanggan dinumemét siya ta Sesarea. ");
INSERT INTO dgc_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Nadid ti Saulo, éy mahigpit dén i péngloko na du tolay a méniwala ni Jesus, a bébantaén na side a bunon. Inumange siya nadid to mataas a padi, ");
INSERT INTO dgc_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","a nagpasulat siya diya ta katibayan na, a monda te ipeta siya du Judeo ta Damasko a te kapangyarian siya a mangdikép ta maski ti ésiya ta éya a nipasakup dén ta bigu a péniwala. Talaga na side a kébilén ta Jerusalem a ipihesu; maski lélake éy ta bébe. ");
INSERT INTO dgc_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Nadid, méglakad ti Saulo a tamo ta Damasko. Ey to kéadene na sa, éy bigla a sinumiklab ta palebut naa i demlag a gébwat ta langet, ");
INSERT INTO dgc_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","a tulos nalugmuk ti Saulo to luta, sakay nabati na i boses a kinagi na diya, a “Saulo, bakit lélabananék mo?” ");
INSERT INTO dgc_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","“Ti ésiya ka, Amo?” kagi ni Saulo. “Ti Jesusék,” kagi no boses. “Sakén i labanan mua. ");
INSERT INTO dgc_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Umégkat ka dén, Saulo, a somdép ka dén ta banuwan. Te mégkagi diko ta éya ta kailangan mo a gemtén.” ");
INSERT INTO dgc_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Nadid, du kakaguman ni Saulo éy basta natilihan side, da nabati de i boses, pero éwan side tu mineta a maski anya. ");
INSERT INTO dgc_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ey ti Saulo éy inumégkat dén siya, pero to kébulag na éy buhék bale dén! Kanya du kakaguman na éy kinabitan de a niange ta Damasko. ");
INSERT INTO dgc_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Nagidad sa siya ta étélo a aldew a éwan naketa, sakay éwan be siya néngan éy ta uminum. ");
INSERT INTO dgc_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Nadid, te esa a alagad ta Damasko a i ngahen na éy ti Ananias. Pinumeta diya i Panginoon, a kinagi na diya, a “Ananias.” “Anya, Panginoon,” kagi ni Ananias. ");
INSERT INTO dgc_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","“Umange ka, Ananias,” kagi na, “ta karsada ya a deretyo, a hanggan ta bile ni Hudas. Ipakelagip mo sa i esa a lélake a taga Tarso, a i ngahen na éy ti Saulo. Egsa sa siya nadid a ménalangin. ");
INSERT INTO dgc_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Sakay neta na ka ta tagenép na a sinomdép ta égsean na, sakay nitupu mo kan i kamét mua diya, monda maketa siya.” ");
INSERT INTO dgc_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","“Pero, Panginoon,” kagi ni Ananias, “meadu i nagbahetaa diyakén tungkul ta éya a lélake, a medukés i ginamet na du tolay mo ta Jerusalem. ");
INSERT INTO dgc_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Sakay du padi sa éy inatdinan de kan siya ta kapangyarian na a magpadikép du étanan a méniwala diko ta éye.” ");
INSERT INTO dgc_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","“Ey éwan,” kagi na Panginoon, “diyan ka méganteng. Da pinili ko dén siya a siya i maging katulung ko a magpahayag ta ngahen ko du Judeo sakay du éwan Judeo, sakay ta mataas a tolay. ");
INSERT INTO dgc_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Sakay ipatukoy ko diya i étanan a tiisén na alang-alang diyakén.” ");
INSERT INTO dgc_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Kanya inumange ti Ananias diya. Sinomdép siya to bile, sakay nitupu na tu kamét na ni Saulo. “Akéng,” kagi na, “pinaangeék se ni Panginoon Jesus. Siya ya tu pinumeta diko to dilan to tamo ka pabi se. Pinaangeék na se, Saulo, monda maketa ka man dén, sakay umasék diko i Banal a Espiritu.” ");
INSERT INTO dgc_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Nadid, to pégkagi ni Ananias ta éya, éy bigla a natépduk to mata ni Saulo i koman i keskes, éy naketa dén siya. Ey inumégkat dén siya agad, a tulos na dén a nipabinyag. ");
INSERT INTO dgc_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ey néngan dén siya, a sinumibét man dén i bégi naa. Nadid, tulos kaguman ni Saulo du alagad ni Jesus ta Damasko ta sénganya a aldew. ");
INSERT INTO dgc_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ey dinumiretso siya ta kapilya na Judeo, a nipahayag na dide ti Jesus, a siya i anak na Diyos a talaga. ");
INSERT INTO dgc_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Sakay du étanan a nakabati diya, éy nagtaka side. “Bakit,” kagi de. “Bakén wade a siya tu dati a mékialam du méniwala ta Jerusalem? Ewan beman siya ina tu inumange se a mangdikép du méniwala ta éye, a kébilén na du padi ta éya?” ");
INSERT INTO dgc_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ey nadid éy lalo a naging mahusay ti Saulo a mégpahayag. Nagpatunay siya a ti Jesus i Cristo a tagapagligtas. Natalo na du Judeo ta Damasko. ");
INSERT INTO dgc_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Kanya du Judeo éy ginayak de a bunon siya. ");
INSERT INTO dgc_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Aldo éy ta kélép éy sésanébén de siya ta pintuan na banuwan, a monda mabunu de siya éng lumwas. Pero napospusan dén ni Saulo tu gayak de. ");
INSERT INTO dgc_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Kanya to esa a kélép éy nisakay siya du kaguman na to gatang, sakay nitostos de to lipat no dikél a pader ta palebut na banuwan, monda makaginan siya du mamuno diya. ");
INSERT INTO dgc_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Nadid, kédemét ni Saulo ta Jerusalem, éy talaga siya a mékiagum du alagad ni Jesus, pero méganteng side diya. Ewan side méniwala a nipasakup dén siya ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Kanya kinuyog siya ni Bernabe du apostol; sakay nilagip na dide éng kodya i nipetaa na Panginoon ni Saulo to dilan ta Damasko, a négkagi diya. Sakay nilagip na be a mesipag dén ti Saulo a mégpahayag ta ngahen ni Jesus ta Damasko. ");
INSERT INTO dgc_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ey sapul ta éya, éy tinanggap de ti Saulo, a tulos négkaguman dén side ta Jerusalem. ");
INSERT INTO dgc_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ewan siya méganteng a mégpahayag ta Panginoon. Sakay nékipagpasuway be siya du Judeo a mégkagi ta Griego. Kanya ginayak de be siya a bunon. ");
INSERT INTO dgc_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ey du kakaguman na, pékabaheta de ta éya, éy niange de siya ta Sesarea, tulos pinéglakad de siya ta Tarso. ");
INSERT INTO dgc_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Kanya nadid éy natahimik man dén i buhaya du méniwala ni Jesus ta Hudea, sakay ta Galilea sakay ta Samaria. Tinumibay side sakay kinumadu side dahil ta tulung na Banal a Espiritu. Ey méniwala side ta Panginoon ta mahusay. ");
INSERT INTO dgc_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Nadid ti Pedro, éy méglebut siya a bumébisita du méniwala ta bawat banuwan Ey kédemét na ta Lida ");
INSERT INTO dgc_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","éy netaunan na i esa a lélake a lumpu, a ti Eneas i ngahen naa. Walu dén siya a taon a te saket. ");
INSERT INTO dgc_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ey kinagi ni Pedro diya, a “Eneas, pahusayén ka ni Jesu Cristo. Umégkat ka dén, a lukutén mo dén i abék mua.” Ey ti Eneas, éy tinumaknég siya agad. ");
INSERT INTO dgc_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ey du étanan a tolay sa a taga Lida sakay Saron, péketa de diya a mahusay dén, éy nipasakup be side ta Panginoon. ");
INSERT INTO dgc_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Nadid, te esa a alagad a bébe ta Hope, a i ngahen naa éy ti Tabita. I palayaw na éy ti Dorkas, sakay Ogsa. Mebait siya a bébe, a palagi siya a tumulung du mahirap. ");
INSERT INTO dgc_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","To kébisita ni Pedro ta Lida, éy naladu i éya a bébe, a tulos minate. Ey to pékapunas de éy niedton de tu bangkay na to kuwarto ta ontok. ");
INSERT INTO dgc_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Nadid, adene dén i Lida ta Hope. Ey du alagad ta Hope, pékabaheta de a kéye dén ti Pedro ta Lida, éy nipauwet de siya a umange agad ta Hope. ");
INSERT INTO dgc_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Kanya inumange ti Pedro ta Hope. Kédemét na sa, éy niange de siya to bile a égsean no minate. Ey agad dinumulug ni Pedro du meadu a bébe a bilo, a mégsanget side. Nipeta de diya tu badu de a ginamet ni Tabita to buhay pabi siya. ");
INSERT INTO dgc_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ey ti Pedro, éy pinaluwas na side a étanan to bile, sakay linumuhud siya a nanalangin. Nadid, kélameng na to bangkay, éy kinagi na, a “Tabita, umégkat ka dén.” Ey tu bébe, éy binumulag siya, éy péketa na ni Pedro éy tulos siya a inumeknud. ");
INSERT INTO dgc_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ey kembilan ni Pedro i kamét naa a pinataknég. Sakay dinulawan na dén du bilo sa, sakay du iba, tulos nipeta na siya dide a buhay dén. ");
INSERT INTO dgc_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","I éya, éy nabaheta dén ta buu a Hope, kanya meadu i méniwala ta Panginoon. ");
INSERT INTO dgc_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ey ti Pedro, éy nale siya ta Hope, a négiyan siya to bile ni Simon. Tu Simon a méglinis ta katat. ");
INSERT INTO dgc_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Nadid, ta Sesarea éy te esa a sundalu a éwan Judeo, a ti Kornelio i ngahen naa. Kapitan siya na gurupu na sundalu a Italiyano. ");
INSERT INTO dgc_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Mékidiyos siya a lélake, a méniwala side a mététena ta Diyos. Pero éwan de tukoy ti Jesus. Ugali na a méngatéd du Judeo a mahirap, sakay palagi siya a ménalangin ta Diyos. ");
INSERT INTO dgc_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","To esa a aldew, a alas tres tu bilag, éy te anghel a gébwat ta Diyos a pinumeta ni Kornelio. Sinomdép tu anghel, a kinagi na diya, a “Kornelio.” ");
INSERT INTO dgc_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ey ti Kornelio, linumameng siya a méganteng a tahod, a kinagi na, a “Anya, Amo?” Ey kinagi no anghel, a “Nabati dén na Diyos, Kornelio, tu panalangin mo, sakay tinandaan na be tu kagbi mo du mahirap. ");
INSERT INTO dgc_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","6","Kanya nadid, Kornelio,” kagi na, “éy te lélake ta Hope a ti Simon Pedro, a tinumulos siya ta bile no Simon a esa, a méglinis ta katat, a i bile dia éy égse ta digdig na diget. Ey nadid siko, Kornelio,” kagi no anghel, “éy pauwet mo siya.” ");
INSERT INTO dgc_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Nadid, kéhektat no anghel, éy dinulawan ni Kornelio du utusan na a éduwa, sakay tu badigad na a sundalu, a mékidiyos be. ");
INSERT INTO dgc_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ey nibaheta na dide i nanyaria diya, sakay pinaglakad na side ta Hope. ");
INSERT INTO dgc_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Nadid, to kagagabian na éya, éy adene dén du étélo a utusan ta Hope. Ey to tanghali, éy sinumangkay ti Pedro to atép no bile a manalangin. (Tu atép no bile éy pantay.) ");
INSERT INTO dgc_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","To pénalangin na éy mégalép siya. Habang méglutu pabi side ta kanén na, éy naketa ti Pedro ta himala. ");
INSERT INTO dgc_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Te koman i tagenép ti Pedro, a mineta na a binumukas i langet, sakay te koman i dikél a manta a iyétostos de ta lutaa, a te igut tu épat a iskina na. ");
INSERT INTO dgc_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","I lasén naa éy meadu a kalakalase a hayup, sakay ulag, sakay manok. Diden ya éy bawal a kanén na Judeo. ");
INSERT INTO dgc_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ey nabati nadid ni Pedro i boses a kinagi na, a “Nay, Pedro, alapén mo dén. Bunon mo side, sakay kanén mo dén.” ");
INSERT INTO dgc_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pero “Ewan, Panginoon,” kagi ni Pedro, “bawal ina side a kanén me.” ");
INSERT INTO dgc_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ey kinagi man dén no boses, a “Diyan mo kagin a bawal tu kagi na Diyos a mahusay.” ");
INSERT INTO dgc_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Pentélo a beses a nanyari i éya, sakay inapén tu manta a dikél ta langet. ");
INSERT INTO dgc_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Nadid, mégisip ti Pedro éng anya i kahulugina na éya a nanyari, éy dinumemét dén du étélo a utusan ni Kornelio, a nagpakelagip side éng ahe tu bile ni Simon. Te taknég side nadid to harap no bile, ");
INSERT INTO dgc_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","sakay nipakelagip de éng tinumulos ta éya ti Simon Pedro. ");
INSERT INTO dgc_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ey ti Pedro, égse pabi siya to atép a mégisip, éy kinagi diya na Espiritu na Diyos, a “Entan mo, Pedro, te étélo a lélake ta sidung a mégahayok diko. ");
INSERT INTO dgc_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Umogsad ka dén, Pedro, sakay diyan ka magalanganin a kumuyog dide, da sakén ngani dén i nagpaangea dide ta éye diko.” ");
INSERT INTO dgc_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Kanya inumogsad ti Pedro, a kinagi na du lélake, a “Sakén ti Simon Pedro. Anya i gustu moya?” ");
INSERT INTO dgc_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ey kinagi de, a “Pinaange kame se ni Kapitan Kornelio a manguwet diko. Siya éy mahusay a lélake a mékidiyos,” kagi de, “sakay iyégalang siya na étanan a Judeo. Ey nadid éy inutusan siya no esa a anghel a nipauwet na ka, monda mabati na i kagi mua diya.” ");
INSERT INTO dgc_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Nadid, pékabati ni Pedro ta éya, éy pinatulos na side to bile. Nadid, to kagagabian na, éy hinumektat side, a kaguman de ti Pedro. Sakay kinumuyog be i sénganya a Judeo a méniwala ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ey to kagagabian na éya, éy dinumemét dén side ta Sesarea. Ey naguhay ti Kornelio dide. Sakay égse be to bile na du tétotop na, sakay du kékadimoy na, da inakit na side a umange sa a maguhay dide. ");
INSERT INTO dgc_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Nadid, kédemét ni Pedro to bile, éy linumuhud ti Korneilo diya a sumamba diya. ");
INSERT INTO dgc_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pero ti Pedro, éy pinaégkat na, a kinagi na, a “Soh, diyan ka sina mégkona. Tolayék san a kapareho mo.” ");
INSERT INTO dgc_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ey tulos side a néguhon a sinomdép to bile. Ey késdép de, éy mineta ni Pedro i meadu a napisan sa a tolay a éwan Judeo. ");
INSERT INTO dgc_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ey kinagi ni Pedro dide, a “Tukoy moy dén a bawal i Judeo a mékiagum ta éwan Judeo, ayun ta rilihiyon me. Pero nikagi diyakén na Diyos a diyan ko ibilang a medukés i maski anya a kalase a tolay. ");
INSERT INTO dgc_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Kanya,” kagi ni Pedro, “to nipanguwet moy diyakén éy éwanék inumidél. Ey nadid, kagi moy éng bakit nipauweték moy.” ");
INSERT INTO dgc_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Nadid, kinagi ni Kornelio, a “To ikaépat a aldew, a alas tres i bilag, éy nanalanginék ta bile miae. Ey bigla a te taknég ta harap kua i lélake a méngislap i badu naa. ");
INSERT INTO dgc_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","‘Kornelio,’ kagi na, ‘nabati dén na Diyos tu panalangin mo sakay tinandaan na be tu kagbi mo du mahirap.’ ");
INSERT INTO dgc_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Tulos inutusanék na a pauwet ta ka ta Hope, Pedro. Sakay kinagi na be diyakén a égse ka to bile ni Simon a méglinis ta katat, ta digdig kan na diget. ");
INSERT INTO dgc_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Kanya nipauwet ta ka agad,” kagi ni Kornelio, “éy salamat, da inumange kam dén se. Ey nadid, éy meta dén na Diyos a kéye kitam dén se, monda baten me éng anya i nibilina diko na Panginoon.” ");
INSERT INTO dgc_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Nadid, pékabati ni Pedro to kinagi ni Kornelio, éy kinagi na dide, a “Tukoy ko dén nadid a maski bale éwan Judeo éy gustu na Diyos, ");
INSERT INTO dgc_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","sakay tanggapén na i tolay na maski ahe a lahe, éng méganteng side diya, sakay éng gumamet side ta mahusay. ");
INSERT INTO dgc_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ey sikam,” kagi ni Pedro, “éy nabaheta moy wade dén tu kagi na Diyos du Judeo, da nipahayag na dén i Mahusay a Baheta a tungkul ta pégkasundu dahil to gimet ni Jesu Cristo. Siya i Panginoon ta étanan. ");
INSERT INTO dgc_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","I éya a baheta, éy minepahayag dén ta buu a Hudea. Nagsapul i éya a nanyari ta Galilea, to pégtoldu ni Juan tungkul ta pégbinyag. ");
INSERT INTO dgc_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","I kagin kua éy tungkul ni Jesus a taga Nasaret. Nipagkaluub diya na Diyos i Banal a Espiritu sakay ta kapangyarian. Maski ahe i inangayan naa, éy nagimet siya ta mahusay, sakay pinahusay na du tolay a linoko ni Satanas; da kaguman siya na Diyos. ");
INSERT INTO dgc_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Sikame i sistigua ta étanan a ginimet na ta banuwan na Judeo, sakay ta Jerusalem. Kona man sa éy binunu de siya to kudos. ");
INSERT INTO dgc_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Pero binuhay siya na Diyos to ikatélo a aldew, tulos pinumeta ti Jesus du tolay. ");
INSERT INTO dgc_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Pero éwan siya pinumeta ta étanan a tolay, éngˈwan sikame san a pinili dén na Diyos a mégpatunay diya. Sakay kaguman na kame be a néngan to nikabuhay na dén. ");
INSERT INTO dgc_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Inutusan na kame,” kagi ni Pedro, “a magpahayag diya ta tolay, a siya i pinilia na Diyos a maghukum ta tolay a minate, sakay ta tolay a buhay. ");
INSERT INTO dgc_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Siya i nikékagia na étanan a purupeta to péngipahayag de a maski ti ésiya i méniwalaa diya éy pagpasensiyaan side na Diyos ta kasalanan de, dahil ta kapangyarian ni Jesus.” ");
INSERT INTO dgc_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Nadid, mégkagi pabi ti Pedro, éy dinumibi dén i Banal a Espiritu du étanan a édse to bile. ");
INSERT INTO dgc_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ey du kakaguman ni Pedro a Judeo, éy mégtaka side, da uméasék bale be i Banal a Espiritu ta maski éwan Judeo a tolay. ");
INSERT INTO dgc_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Dahilan nabati de du éwan Judeo a mégkagi ta iba-iba a kagi, sakay mégpuri side ta Diyos. Ey kinagi ni Pedro, a ");
INSERT INTO dgc_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Kapareho tam bale di tolayae a dayuan, da tétanggapén de be i Banal a Espiritu! Ti ésiya i makasawaya dide a ipabinyag?” ");
INSERT INTO dgc_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Tulos niutus ni Pedro a binyagen side ta ngahen ni Jesu Cristo. Ey kétapos na éya, éy inakit de ti Pedro a égsa pa side a sénganya a aldew. Bininyagen Na Du Ewan Judeo ");
INSERT INTO dgc_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Nadid, du apostol sakay du iba a Judeo a méniwala ta Hudea, éy nabaheta de a te éwan Judeo a nipasakup dén ta kagi na Diyos, dahil to pégtoldu ni Pedro. ");
INSERT INTO dgc_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Kanya du Judeo a méniwala ni Jesus, éy pinintasan de ti Pedro to kédemét na ta Jerusalem. ");
INSERT INTO dgc_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Bakit,” kagi de, “tinumulos ka ta bile na dayuan a éwan Judeo, a nékidipon ka pa dide? Ewan beman ya bawal ta ugali tam?” ");
INSERT INTO dgc_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Kanya ti Pedro, éy kinagi na dide i katuwiran na, a nisalaysay na dide i étanan a nanyari. ");
INSERT INTO dgc_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“To esa a bulan,” kagi na, “éy égseék ta Hope. Ey to pénalangin ko, éy naketaék ta himala. Te komanék i tagenép, a mineta ko i dikél a koman i manta ta langet a iyétostos. Te igut tu épat a iskina na. Ey dinumibi a hanggan ta tapat kua. ");
INSERT INTO dgc_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nadid, tinitigen ko éy meadu bale a kalakalase a hayup i lasén naa, sakay ulag éy ta manok. ");
INSERT INTO dgc_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Sakay nabati ko i boses a kinagi na diyakén, a ‘Nay, Pedro, alapén mo dén.’ ");
INSERT INTO dgc_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ey ‘Ewan, Panginoon,’ kagi ko, ‘bawal ina side a kanén me.’ ");
INSERT INTO dgc_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Pero kinagi diyakén a huway no boses ta langet, a ‘Diyan mo kagin a bawal tu kinagi na Diyos a mahusay.’ ");
INSERT INTO dgc_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Pentélo a beses a nanyari i éya, sakay inapén tu manta ta langet. ");
INSERT INTO dgc_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Nadid, ta éya a mismo a oras,” kagi ni Pedro, “éy dinumemét to bile a tinulusan ko i étélo a lélake a gébwat ta Sesarea, a manguwet diyakén. ");
INSERT INTO dgc_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ey inutusanék na Espiritu a diyanék mégalanganin a kumuyog dide. Kanya kinumuyogék dide to bile no esa a lélake a éwan Judeo, a ti Kornelio i ngahen naa. Sakay kinuyog ko be di énémae a kaguman ko. ");
INSERT INTO dgc_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ey ti Kornelio, éy nibaheta na dikame a pinumeta kan diya i esa a anghel to bile de, a inutusan na kan siya a pauweték na ta Hope. ");
INSERT INTO dgc_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Kinagi kan no anghel diya a sakén i magbahetaa diya ta kagi a méngiligtas diya, sakay du anak na. ");
INSERT INTO dgc_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ey nadid,” kagi ni Pedro, “to pégkagi ko pabi dide, éy dinumibi bale dide i Banal a Espiritu a kona to nanyari dikitam to sapul. ");
INSERT INTO dgc_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ey sakén, éy naala-ala ko tu kinagi na Panginoon, a mégbinyag ti Juan ta dinom, pero sikitam éy mabinyagen kitam kan ta Banal a Espiritu. ");
INSERT INTO dgc_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ey nadid, éy magenyaék? Eng inatdinan side na Diyos ta Espiritu na a kona to nipéngiatéd na dikitam to nipagpasakup tam diya, éy anya, sawayén ko beman i gimet na Diyos? Kanya tinumulusék dide.” ");
INSERT INTO dgc_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Nadid, du pinégkagian ni Pedro, pékabati de to katuwiran na, éy éwan dén side mégpintas diya. Nagpasalamat side ta Diyos, a kinagi de, a “Inatdinan bale be side na Diyos ta pagkékataon de a magsisi ta kasalanan de, a baguén de tu ugali de a monda mabuhay side; maski éwan Judeo a tolay!” ");
INSERT INTO dgc_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Nadid, du méniwala ni Jesus a minasiwéd-sewéd to pémunu de ni Esteban, éy nakaabut i sénganya dide ta Penisia, sakay ta Sipre, a hanggan ta Antiokia. Nipahayag de sa i baheta ni Jesus, pero Judeo san i néngibahetaan dia. ");
INSERT INTO dgc_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Pero te séngasénganya a Judeo a méniwala a taga Sipre sakay ta Sirene. Diden ya, kédemét de ta Antiokia, éy nibaheta de ti Cristo du tolay sa a éwan Judeo. ");
INSERT INTO dgc_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ey inaguman side na Panginoon, monda meadu sa a tolay i ipasakup ta Panginoon. ");
INSERT INTO dgc_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Nadid, pékabaheta du alagad ta Jerusalem ta éya, éy pinaange de ti Bernabe ta Antiokia. ");
INSERT INTO dgc_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ey kédemét na sa, éy neta na i mahusay a gimet na Diyos dide, éy masaya siya. Tulos hinatulan na side a manatili side a matapat ta péniwala de ta Panginoon. ");
INSERT INTO dgc_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ti Bernabe éy mahusay a lélake, a égse diya i Banal a Espiritu, sakay uméasa siya a tahod ta Diyos. Ey meadu i tolay a nipasakup ta Panginoon. ");
INSERT INTO dgc_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Kanya inumange ti Bernabe ta Tarso a ahayukén na ti Saulo. ");
INSERT INTO dgc_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ey to péketa na diya, éy kinuyog na siya a soli ta Antiokia. Esa a taon side a négiyan ta Antiokia, sakay nagtoldu side ta éya ta meadu a tolay to gurupu du méniwala. Du méniwala sa, éy side ya du neditol a ngéngahinan na tolay a Kristiano. ");
INSERT INTO dgc_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Nadid, ta éya a panahun éy te purupeta a dinumemét ta Antiokia, a gébwat side ta Jerusalem. ");
INSERT INTO dgc_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Tinumaknég i esa dide, a ti Agabo i ngahen na, sakay naghula siya ta pamag-itan na Espiritu, a te dikél kan a alép a dumemét ta mundua. I éya a hula, éy natupad ngani dén to panahun ni Hari Klaudio. ");
INSERT INTO dgc_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Kanya du méniwala sa, éy naisipan de a ipatawed de i tulung de du tétotop de ta péniwala ta Hudea, sigun ta kaya na bawat esa dide. ");
INSERT INTO dgc_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ey kona ngani sa i ginamet dia. Nipatawed de tu tulung de du matétanda sa, a ti Bernabe sakay ti Saulo i bahala a nagkébil. ");
INSERT INTO dgc_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Nadid, to panahun a éya, éy ti Hari Herod éy nékialam siya du sénganya a méniwala ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Pinutulan na pa ti Santiago a aka ni Juan. ");
INSERT INTO dgc_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ey nadid, péketa na a mésahat du Judeo ta éya, éy ti Pedro man dén i nipadikép naa. Nanyari ya to piyesta a péngan de ta melapis a tinapay. ");
INSERT INTO dgc_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pékadikép na ni Pedro, éy nipihesu na siya, a pinaguwardia na siya ta sapulu éy ta éném a sundalu. Tu plano ni Herod éy iluwas na ti Pedro ta kétapos na piyesta, monda ipabuno na siya ta harap du tolay. ");
INSERT INTO dgc_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Kanya binantayan de ti Pedro to pégpihesuan. Pero du kakaguman na a méniwala, éy mahigpit a iyépanalangin de siya. ");
INSERT INTO dgc_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","To esa a kélép éy tidug ti Pedro ta sélat na éduwa a sundalu, a ginapus siya ta éduwa a kadena. Sakay te guwardia be a mégbantay to pintuan no pégpihesuan. Ta gagabi éy saya i takdaa a aldew a ipabuno siya no hari. ");
INSERT INTO dgc_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Nadid, bigla a dinumemlag tu kuwarto a te katidugen ni Pedro, a te taknég sa i esa a anghel na Diyos. Kembilan na ti Pedro a linukag, a kinagi na, a “Nay, Pedro, umikat ka dén.” Nadid, kéégkat ni Pedro, éy basta nalékbes tu kadena ta kamét naa. ");
INSERT INTO dgc_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","“Nay,” kagi no anghel, “magbadu ka dén, sakay magsolot ka dén ta sapatus mua.” Kétapos na éya, éy kinagi na, a “Nay, magalikébkéb ka ta ulés mua, a umunonod ka diyakén.” ");
INSERT INTO dgc_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ey inumunonod ti Pedro to anghel a linumwas to pégpihesuan. Ey éwan tukoy ni Pedro éng tunay ya a nanyari. Akala na éy tagenép na san. ");
INSERT INTO dgc_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Péglakad de, éy sinalinan de san tu éduwa a guwardia. Sakay kédemét de to pintuan a bakal, éy basta binumukas dide, a tulos nakaluwas dén side. Péglakad de to esa a karsada, éy bigla a linompés tu anghel. ");
INSERT INTO dgc_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ey ta éya san naisipan ni Pedro i nanyaria diya. “Tutuhanan bale,” kagi na, “a pinaange se na Diyos tu anghel na a mangagaw diyakén ni Herod, sakay tu asaan du Judeo a manyari diyakén.” ");
INSERT INTO dgc_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Nadid, to pékaisip ni Pedro ta éya, éy nagtulos siya to bile ni Maria a ina ni Juan a dédulawén de a Markos. Te meadu sa nadid a napisan a nanalangin. ");
INSERT INTO dgc_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Tinumuktuk ti Pedro to pintuan, éy inumange tu bataan to pintuan a inentan na éng ti ésiya ya. ");
INSERT INTO dgc_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Siya, pékatukoy na to boses ni Pedro, éy éwan na siya binukasan, dahil ta pagés na; éngˈwan naginan siya ta lubuk a kinagi na du ménalangin sa a kéye dén ti Pedro to pintuan. ");
INSERT INTO dgc_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","“Oy!” kagi de, “nabang-aw ka wade.” Pero iyépilit na a siya ngani dén. Kanya kagi de a makay anghel na. ");
INSERT INTO dgc_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Samantala ti Pedro éy mégtuktuk a mégtuktuk. Ey to péngbukas de éy neta de a siya bale dén. Ey nagtaka side. ");
INSERT INTO dgc_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pero pinéypéy na side. Sakay nilagip na dide éng kodya siya a pinaluwas na Panginoon to pégpihesuan. Sakay nibilin na dide a ibaheta de de Santiago i nanyaria. Sakay hinumektat siya dide a inumange ta iba a lugar. ");
INSERT INTO dgc_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Nadid, to gagabi dén, éy naligalig dén a tahod du sundalu, da éwan de tukoy éng ahe ti Pedro. ");
INSERT INTO dgc_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ey ti Hari Herod, éy pinaahayok na siya, pero éwan de neta. Kanya siniyasat na du nagbantay, sakay nipabunu na side. Ey kétapos na éya, éy nagkobu ti Herod ta Sesarea. ");
INSERT INTO dgc_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Nadid, nale ti Hari Herod a mégingél du tolay ta Tiro sakay ta Sidon. Kanya nadid éy nagkasundu side a umange diya. Nékiohon pa side ni Blasto a bisi na, a aguman na side a mékiohon ni Herod. Gustu de a bumate ni Herod, da gébwat ta banuwan na i kabuhayan de. ");
INSERT INTO dgc_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Nadid, kédemét no katugunan de a aldew, éy nagbihis ti Herod to badu na a memahal, sakay inumeknud siya to bangko na ta harap du tolay, sakay nagtalumpati siya dide. ");
INSERT INTO dgc_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ey du tolay, pékabati de diya éy kinagi de ta médegsén, a “Ewan siya tolay, éngˈwan diyos siya a talaga!” ");
INSERT INTO dgc_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ey nadid, da éwan kinagi ni Herod a Diyos i nangtulunga diya, éy bigla a pinasakitan siya no anghel a gébwat ta Diyos. Sakay enhés siya a tulos minate dén. ");
INSERT INTO dgc_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ey tu kagi na Diyos, éy lalo a nagkabahibaheta dén. ");
INSERT INTO dgc_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ey ti Bernabe sakay ti Saulo, da natapos dén tu gimet de ta Jerusalem, éy nagsoli dén side ta Antiokia, a kinuyog de nadid ti Juan Markos. ");
INSERT INTO dgc_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Nadid, du méniwala ta Antiokia éy te sénganya dide a purupeta, sakay te séngasénganya be a mégtoldu. I ngahen dia éy ti Bernabe, sakay ti Simion Niger, ti Lusio a taga Sirene, ti Saulo, sakay ti Manaen (ti Manaen éy kaguman ni Herod to kéanak de). ");
INSERT INTO dgc_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","To esa a aldew éy nagpisan side a nagkulasiyon, monda sumamba side ta Diyos. Ey kinagi dide na Banal a Espiritu, a “Pilién moy ti Bernabe sakay ti Saulo, a ibukod moy side, monda gemtén de i tarabaho a nihanda ko dide.” ");
INSERT INTO dgc_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ey kétapos de a nagkulasiyon sakay nanalangin, éy nitupu de dide tu kamét de, sakay pinéglakad de side. ");
INSERT INTO dgc_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ti Bernabe sakay ti Saulo, éy inutusan side na Banal a Espiritu. Kanya inumange pa side ta Selusia, sakay sinumakay side ta paraw a inumahabes side ta puduka na Sipre. ");
INSERT INTO dgc_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ey kédemét de ta Salamina, éy nipahayag de du kapilya sa na Judeo i kagi na Diyos. Kaguman de be ti Juan Markos a katulung de. ");
INSERT INTO dgc_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Nilebut de i éya a puduk, a hanggan ta Papus. Ta éya éy netaunan de sa i esa a mégsalamangka a Judeo a mégwari-wari a purupeta siya. Ti Barhesus i ngahen naa. ");
INSERT INTO dgc_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Kadimoy siya no gubernador ta éya, a ti Sergio Paulo, a matalinung a lélake. Siya éy nipauwet na ti Bernabe sakay ti Saulo, da gustu na éy mabati na i kagi na Diyos dide. ");
INSERT INTO dgc_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Pero tu mégsalamangka, éy talaga na a sawayén de Bernabe, da sala na a tumanggap tu gubernador ta péniwala de. (Tu palayaw no mégsalamangka éy ti Elimas.) ");
INSERT INTO dgc_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Pero ti Saulo, éy édse diya i Banal a Espiritu. (Tu palayaw ni Saulo éy ti Pablo.) Ey linameng na tu mégsalamangka, ");
INSERT INTO dgc_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","a kinagi na diya, a “Utusan ka ni Satanas! Bakit kontara ka ta mahusay a gimet? Loko ka, a medukés ka a ugali! Bakit pakiwélén mo i katutuhanan tungkul ta Diyos? ");
INSERT INTO dgc_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Pero nadid,” kagi ni Pablo, “éy parusaan ka na Diyos. Maging buhék ka, a male a panahun éy éwan ka maketa.” Nadid, bigla a naramdaman ni Elimas a dinumiklém i mata naa, tulos nagkapa-kapa siya ta mangkabit diya. ");
INSERT INTO dgc_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ey tu gubernador, péketa na ta éya, éy naniwala siya; da néganteng siya ta pégtoldua de Bernabe tungkul ta Panginoon. ");
INSERT INTO dgc_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Nadid, tinumulak de Pablo ta Papus, a inumahabes side ta Perge-Pamilia. Pero kédemét de sa, éy gininanan side ni Juan Markos, a nagsoli siya ta Jerusalem. ");
INSERT INTO dgc_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ey sapul ta éya éy nagtulos de Pablo ta Antiokia-Pisidia. Ey to pangilin a aldew, éy sinomdép side to kapilya na Judeo to pégmiting de. ");
INSERT INTO dgc_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ey kétapos du Judeo a mégbasa to kasulatan, éy kinagi no tagapamahala sa ni Pablo éng te kagin siya du napisan sa a tolay. ");
INSERT INTO dgc_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Kanya tinumaknég ti Pablo, a niontok na i kamet naa, sakay nagtalumpati siya dide. “Sikam a Israel,” kagi na, “sakay sikam a éwan Judeo a mékidiyos, éy te kaginék dikam. ");
INSERT INTO dgc_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","I Diyos a péniwalaan na banuwan na Israel, éy siya i nangpilia du apo tam to araw, a side i tolay na. Sakay pinakadu na side to pégiyan de ta Egipto. Sakay pinaluwas na side ta éya ta pamag-itan na kapangyarian na. ");
INSERT INTO dgc_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Pinagtiisan na side to pégiyan de ta melawa a ilang a lugar ta épat a pulu a taon. ");
INSERT INTO dgc_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kétapos na éya, éy pinabuno na du tolay ta pitu a banuwan na Kanan, sakay niatéd na tu luta de du apo tam, ");
INSERT INTO dgc_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","para ta panahun na épat a datos éy ta limapulu a taon. “Kétapos na éya éy ginimet na Diyos a te huwes side a nagmayor dide, a hanggan to panahun ni Purupeta Samwel. ");
INSERT INTO dgc_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ey nadid gustu du Judeo a te hari side. Kanya pinili na Diyos i esa a lélake a gébwat ta lahi ni Bendyamin. Ti Saulo i ngahen na, a anak ni Kis. Siya i hari de para to épat a pulu a taon. ");
INSERT INTO dgc_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ey nadid, to péngibut na Diyos ni Saulo, éy pinili na ti Dabid a maghari dide. Da kinagi na Diyos a ti Dabid i gustu na kana, da tukoy na a tupadén na i kaluuben na. ");
INSERT INTO dgc_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ey nadid,” kagi ni Pablo, “tu apo ni Dabid a esa éy ti Jesus; éy ginimet na Diyos a siya i tagapagligtas du Israel, da saya i nipangako na Diyos. ");
INSERT INTO dgc_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ey bagu dinumemét ti Jesus éy mégtoldu dén ti Juan du tolay, a dapat magsisi side ta kasalanan de, a tulos ipabinyag side. ");
INSERT INTO dgc_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ti Juan, to kétapos na to tarabaho na, éy kinagi na, a ‘Akala moy éy sakén i tagapagligtas, pero éwan. Te ménegipo diyakén a dumemét,’ kagi na, ‘sakay éng iparehoék moy diya, éy éwanék tu pasa, da mataas siya diyakén.’ ");
INSERT INTO dgc_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“A tétotop ko,” kagi ni Pablo, “sikam a apo ni Abraham, sakay sikam a éwan Judeo a mékidiyos, batenék moy! I éya a baheta a méngiligtas i Diyos ta tolay, éy para dikam be! ");
INSERT INTO dgc_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Du Judeo ta Jerusalem, éy éwan de tukoy a ti Jesus i tagapagligtas. Sakay tu kasulatan du purupeta a bébasaén de ta tuwing pangilin, éy éwan de be napospusan. Kanya tinupad de to nipamuno de ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Maski éwan side tu katuwiran a magpabuno diya, éy pinilit de ti Pilato a ipabuno na siya. ");
INSERT INTO dgc_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Kanya tinupad de tu hula du purupeta, a nipabuno de siya. Ey to nikate na dén, éy nidibe de tu bangkay na to kudos, sakay nielbéng de to pantiyung. ");
INSERT INTO dgc_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Pero binuhay siya na Diyos a huway! ");
INSERT INTO dgc_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Sakay meadu a aldew a pinumeta siya du alagad na a kakuyoyog na to éya ta Jerusalem a gébwat ta Galilea. Side ya i sistigua a nabuhay dén siya. ");
INSERT INTO dgc_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Pati sikame a éduwa,” kagi ni Pablo, “éy inumange kame se a monda ipahayag me dikam i Mahusay a Baheta a nipangako na Diyos du apo tam to araw. ");
INSERT INTO dgc_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Tinupad dén na Diyos tu nipangako na dikitam, da pinabuhay na dén ti Jesus a huway. Te kagi ta ikaduwa a kanta tungkul ta éya. Siko i anak ko, kagi na, sakay sakén i ama mua. ");
INSERT INTO dgc_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Sakay kinagi be na Diyos a atdinan na siya ta mahusay a kalagayan a nipangako na ni Dabid. I kahulugina na éya,” kagi ni Pablo, “éy buhayén na ti Jesus, monda éwan mahunot i bégi naa. ");
INSERT INTO dgc_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Sakay te kagi a esa to kasulatan, a éwan na kan pabayan a mahunot tu utusan na a banal. ");
INSERT INTO dgc_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Mara ti Dabid, sinunud na i Diyos to panahun na, pero minate siya, sakay nielbéng de be siya to lébeng du apo na, tulos nahunot tu bégi na. ");
INSERT INTO dgc_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Pero ti Jesus éy éwan nahunot tu bégi na, da binuhay siya na Diyos. ");
INSERT INTO dgc_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Kanya nadid, a tétotop ko,” kagi ni Pablo, “éy dapat moy a mapospusan a dahil ni Jesus éy pagpasensiyaan kam na Diyos ta kasalanan moy. ");
INSERT INTO dgc_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Da maski sésundin moy i kautusan ni Moises, éy éwan kam pagpasensiyaan ta kasalanan moy; pero éng maniwala kam ni Jesus éy makaligtas kam ta parusa na kasalanan moya. ");
INSERT INTO dgc_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Kanya sikam,” kagi ni Pablo, “éy mangilag kam, makay makamtan moy tu nisulat du purupeta to araw. ");
INSERT INTO dgc_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Entan moy, kagi de, sikam a mégidel ta katutuhanan. Magtaka kam kan ta gimet na Diyos, pero mate kam, da éwan kam maniwala, maski ipaliwanag de dikam.” ");
INSERT INTO dgc_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Nadid, kéluwas de Pablo to kapilya, éy inakit side du tolay a sumoli side ta sabadu a esa, a magtoldu side dide a huway. ");
INSERT INTO dgc_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ey kétapos no miting, éy te meadu a tolay a tinumagubet de Pablo, éy hinatulan side de Pablo a diyan de pébayan i kagbi na Diyos dide. ");
INSERT INTO dgc_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Nadid, to esa man dén a aldew a pangilin, éy dinumulug du étanan a tolay ta banuwan, a monda mabati de tu pégtoldu ni Pablo ta kagi na Diyos. ");
INSERT INTO dgc_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Pero du mataas a Judeo, péketa de du meadu a tolay a dinumulug de Pablo, éy nanaghili side, sakay kinagi de a mali tu pégtoldu na, a medukés kan siya a lélake. ");
INSERT INTO dgc_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ey de Pablo éy ti Bernabe, éy metapang side a mégkagi. “Dapat a mégpahayag kame pa dikam ta kagi na Diyos,” kagi de, “da Judeo kam. Pero nadid, da mégidel kam, a sala moy a te buhay a éwan tu katapusan, éy pabayan me kam, a du éwan Judeo san i tolduan mia. ");
INSERT INTO dgc_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Da saya i niutusa dikame na Panginoon. Pinili na kame, kagi na, a sikame i magpaliwanag du éwan Judeo, a sikame kagi na i bahala a mégtoldu ta iba a tolay tungkul ta kaligtasan de.” ");
INSERT INTO dgc_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Nadid du éwan Judeo, pékabati de ta éya, éy mésaya side. “Kamahalan,” kagi de, “i éya a kagi de Pablo tungkul ta Diyos!” Ey nadid, du pinili dén na Diyos a para ta buhay a éwan tu katapusan, éy naniwala side. ");
INSERT INTO dgc_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Sakay tu kagi na Diyos éy lalo a nagkabahibaheta dén ta éya a lugar. ");
INSERT INTO dgc_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Pero du Judeo a mataas, éy sinulsulan de du te tungkulin a lélake ta éya, sakay i sénganya a mataas a bébe a méniwala ta Diyos. Tulos linoko de de Pablo a hanggan pinaibut de side to banuwan de. ");
INSERT INTO dgc_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ey de Pablo, kéhektat de, éy nihalimbawa de dide a nipagpag de dide tu alikabuk ta tikéd dia. I éya éy bilang sistigu de a inidelan de i Diyos. Ey nadid éy inumange side ta Ikonio. ");
INSERT INTO dgc_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ey du bigu a méniwala ta Antiokia éy mésaya side, sakay édse dide i Banal a Espiritu. ");
INSERT INTO dgc_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Nadid, kona be sa i nanyaria ta Ikonio. Ti Pablo sakay ti Bernabe, éy inumange pa side to kapilya sa na Judeo, sakay négkagi side ta mahusay, monda te meadu a Judeo a méniwala ni Jesus, sakay éwan Judeo be. ");
INSERT INTO dgc_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","3","Nale sa de Pablo a négiyan, a metapang side a nagpahayag ta kagi na Panginoon. Sakay i Diyos éy pinatunayan na du tolay tu kagi de Pablo, da inatdinan na side ta kapangyarian a magimet ta tanda a kataka-taka. Pero du Judeo a éwan méniwala, éy sinulsulan de du iba a tolay. Kinagi de a medukés du kabébayan de a nipasakup ta pégtoldu de Pablo. ");
INSERT INTO dgc_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Kanya du tolay ta banuwan a éya, éy éwan side paripareho tu isip. Du kalahati éy kinumampi side du Judeo; du iba man éy kinumampi side de Pablo. ");
INSERT INTO dgc_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Nadid, du tolay sa, sakay du konsiyal na banuwan, éy mégayak side a mangloko de Pablo, a talaga de side a batibatikalén. ");
INSERT INTO dgc_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","7","Pero de Pablo, pékabaheta de ta éya, éy ginuminan sa side a inumange side ta Likaonia. Ta éya éy nagpahayag side ta Mahusay a Baheta ta Listra, sakay ta Derbe, sakay ta bariyo-bariyo ta éya. ");
INSERT INTO dgc_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ta Listra éy te esa a lélake a éwan mékalakad. Lumpu siya sapul to nikeenak na. ");
INSERT INTO dgc_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Siya éy négbati to pégtoldu ni Pablo. Ey ti Pablo, éy neta na a méniwala siya a pahusayén maka siya na Diyos. ");
INSERT INTO dgc_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Kanya kinagi na diya ta medegsén, a “Siko, tumaknég ka dén.” Ey tu lélake, éy basta linumuksu dén siya, a tulos néglakad! ");
INSERT INTO dgc_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ey du meadu sa a tolay, péketa de to ginimet ni Pablo, éy akala de éy diyos side ti Bernabe. Kinagi de to kagi de a sarili, a “Dinumibe bale dén dikitam diden ye a éduwa a diyos, a naging tolay side!” ");
INSERT INTO dgc_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ti Bernabe éy nginahinan de ta ngahen no diyos de a Seus. Sakay ti Pablo éy nginahinan de ta ngahen no diyos de a Hermes, da bihasa ti Pablo a mégkagi. ");
INSERT INTO dgc_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ta éya a banuwan éy te bile a pégdasalan de to diyos-diyosan de a Seus. Nadid, tu bahala ta éya a bile, éy niluwas na i baka a te ulay ta bulaklak. Talaga de a bunon, a ipagatang de de Bernabe. ");
INSERT INTO dgc_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Pero de Bernabe, pékapospos de ta gemtén du tolay, éy naligalig side, a naginan side du tolay. “Adiyoy,” kagi de, ");
INSERT INTO dgc_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“diyan kam sina mégkona? Tolay kame san a kapareho moy!” kagi de. “Kanya kame se inumange éy monda ibaheta me dikam i Mahusay a Baheta ni Jesus, a monda maka éy ibutan moy tu péniwala moy ta diyos-diyosan a éwan tu pasa, a tanggapén moy i tunay a Diyos. Siya i naglalang ta mundua éy ta langet éy ta diget, sakay ta étanan a égse dide. ");
INSERT INTO dgc_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","To éya,” kagi de, “éy pinabayan na Diyos du tolay a éwan Judeo. ");
INSERT INTO dgc_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Kona man sa, éy inatdinan kam be na Diyos ta katunayan, monda matenggi moy siya ta pamag-itan no gimet na a mahusay. Ey anya i gimet na, éy siya i méngatéda dikam ta uden; siya i mégpatubu ta halaman moya; siya i méngatéda dikam ta kanén moya sakay ta kasayaan moya.” ");
INSERT INTO dgc_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Nadid, maski kona sa tu kinagi de Pablo, éy mehirap side a nangsaway dide a mégatang dide ta baka. ");
INSERT INTO dgc_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ey nadid, kétapos na éya, éy te dinumemét sa a Judeo a gébwat ta Antiokia éy ta Ikonio, a side du kalaban ni Pablo. Sinulsulan de tu tolay ta Listra a hanggan da binébatikal de ti Pablo, sakay nihela de siya a nibut de siya to banuwan de, a akala de éy minate dén. ");
INSERT INTO dgc_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Pero du tolay sa a méniwala, to kétipun de diya, éy inumégkat dén siya, a tulos sinomdép man dén siya to banuwan. Ey to kagagabian na éya éy hinumektat sa side ti Bernabe, a nagtulos side ta Derbe. ");
INSERT INTO dgc_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ta Derbe éy nagpahayag man dén de Pablo ta Mahusay a Baheta. Ey te meadu sa a nipasakup ni Jesus. Ey kéhektat de sa éy nagtulos man dén side ta Listra sakay ta Ikonio a hanggan ta Antioka-Pisidia. ");
INSERT INTO dgc_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Pinatibay de sa du bigu a méniwala, a hinatulan de side a diyan de pébayan tu péniwala de. “Magdanas kitam pa ta meadu a hirap,” kagi de, “bagu kitam makasdép ta kaharian na Diyos.” ");
INSERT INTO dgc_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Sakay pati, éy pinili de ta bawat simbaan i matétanda a mamahala. Nagkulasiyon pa side, sakay nipanalangin de side. “Tu Panginoon a péniwalaan moy,” kagi de, “éy siya i bahala a mégalaga dikam nadid.” ");
INSERT INTO dgc_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Nadid, nagtulos side ta Pisidia sakay ta Pampilia. ");
INSERT INTO dgc_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ey to pégpahayag de ta kagi na Diyos ta Perga, éy nagtulos man dén side ta Atalia. ");
INSERT INTO dgc_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ta éya éy sinumakay side to paraw, a nagsoli side ta Antiokia. Saya i hinektatan dia a banuwan to purumeru a lakad de a nagtoldu. Saya tu néngipanalanginan du kaguman de dide, a monda aguman side na Diyos ta péglebut de. Ey nadid, natapos dén tu tarabaho de. ");
INSERT INTO dgc_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Nadid, kédemét de Pablo ta Antiokia, éy pinadulug de du étanan a kakaguman de a méniwala, sakay nibaheta de dide i étanan a ginimet na Diyos du banuwan a inangayan de, éng kodya i nipangbukas naa to dilan a monda maari be du éwan Judeo a maniwala. ");
INSERT INTO dgc_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Sakay nale a panahun a négiyan sa de Pablo, a kaguman de du iba sa a méniwala ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Nadid, ta éya a panahun éy te sénganya a lélake a inumange ta Antiokia a gébwat ta Jerusalem. Tulos tinolduan de du méniwala ni Jesus ta éya. “Ewan kam meligtas,” kagi de, “éng éwan kam be ipasakup ta rilihiyon na Judeo a niutus ni Moises to araw.” ");
INSERT INTO dgc_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pero ti Pablo sakay ti Bernabe, éy nékipagpasuway side dide ta mahigpit. “Ewan tama i pégtoldu moya,” kagi ni Pablo. Nadid, da méligalig du tolay to simbaan ta éya, éy pinaange de de Pablo ta Jerusalem, a monda mékiohon side du apostol ta éya tungkul ta problema a éye: éng te kailangan du éwan Judeo a sumunud ta kautusan ni Moises, o éng éwan. ");
INSERT INTO dgc_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","To péglakad de Pablo, éy nagtulos side ta Penisia sakay ta Samaria. Nibaheta de du tolay sa a méniwala, a meadu dén a éwan Judeo a nipasakup dén ni Jesus to kinagébwatan de a banubanuwan. Ey du méniwala éy mésaya side ta éya. ");
INSERT INTO dgc_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ey kédemét de Pablo ta Jerusalem, éy tinanggap side du apostol, sakay du iba sa a méniwala. Ey kinagi dide ni Pablo i étanan a pinagimet dide na Diyos. ");
INSERT INTO dgc_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Pero du Pariseyo sa a méniwala ni Jesus éy kinagi de, a “Du éwan Judeo a méniwala ni Jesus, éy kailangan be side a ipasakup ta kautusan ni Moises.” ");
INSERT INTO dgc_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Kanya du apostol sakay du matétanda éy nagmiting side a monda péguhunan de i éya a problema. ");
INSERT INTO dgc_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Nale side a négpasuway, éy tinumaknég ti Pedro a négkagi dide. “A tétotop ko,” kagi na, “tukoy moy dén a piniliék na Diyos to éya, a sakén i magpahayag du éwan Judeo ta Mahusay a Baheta, monda mabati de a maniwala side. ");
INSERT INTO dgc_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","I Diyos, éy tukoy na dén i isip na tolay. Ey nagpatunay siya dikitam a tinanggap na be du éwan Judeo, da inatdinan na side ta Banal a Espiritu a kona to nipéngiatéd na dikitam. ");
INSERT INTO dgc_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Mahal na Diyos du éwan Judeo a kona be ta pégmahal naa dikitam, da pinagpasensiyaan na be side dahil to péniwala de diya. ");
INSERT INTO dgc_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Kanya nadid,” kagi ni Pedro, “éy bakit kontaraén moy i gimet na Diyos? Bakit pilitén moy du bigu a méniwala a éwan Judeo a sumunud ta kautusan ni Moises? Maski du apo tam to araw éy éwan side nakasunud ta éya, éy kona be sa dikitam nadid. ");
INSERT INTO dgc_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Engˈwan, kanya kitam meligtas éy dahil san ta kagbi na Panginoon Jesus dikitam. Ey kona be sa du éwan Judeo.” ");
INSERT INTO dgc_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Nadid, kétapos ni Pedro a négkagi, éy natahimik dén du iba sa. Tulos négbati side to katuwiran de Bernabe sakay ti Pablo. Nibaheta de dide tu memahal a ginimet na Diyos dide a kataka-taka, to pégtoldu de du dayuan a tolay a éwan Judeo. ");
INSERT INTO dgc_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ey kétapos de a négkagi, éy ti Santiago man dén i négkagia. “A tétotop ko,” kagi na, “batenék moy. ");
INSERT INTO dgc_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Nipaliwanag dén ni Simon Pedro éng kodya i nipagsapul na Diyos a nananggap du éwan Judeo a tolay; éng kodya i nipangpili naa ta sénganya dide a sakup na. ");
INSERT INTO dgc_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Sakay i éya éy ayun be ta hula du purupeta, da kagi to kasulatan, a ");
INSERT INTO dgc_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Magsoliék, kagi na Diyos, sakay pahusayén ko a huway i péghari ni Dabid a nasida, ");
INSERT INTO dgc_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","monda du iba be a tolay a éwan Judeo a pinili ko, éy maari be side a ipasakup diyakén.’ ");
INSERT INTO dgc_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Saya tu kinagi na Diyos to araw. ");
INSERT INTO dgc_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Kanya i isip kua,” kagi ni Santiago, “éy diyan tam abalaén du éwan Judeo a nipasakup dén ni Jesus. Diyan tam side pilitén a umaheg ta ugali tam a Judeo. ");
INSERT INTO dgc_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","I isip ko sana, éy sulatan tam side a diyan de kanén tu buhay no niatang, sakay diyan side méngibébi éy ta méngilélake; sakay diyan side méngan ta dige éy ta pilas a medige. ");
INSERT INTO dgc_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Dahilan sapul to araw éy nabati dén na tolay ta maski ahe a banuwan tu kautusan ni Moises, da bébasaén ya du Judeo ta tuwing pangilin ta kapilya de.” ");
INSERT INTO dgc_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Nadid, du apostol, pékabati de to kagi ni Santiago, éy naisipan de a péglakadén de i éduwa a lélake a kumuyog de Pablo sakay ti Bernabe a sumoli ta Antiokia. Tu napili de éy ti Hudas Barsabas, sakay ti Silas, da iyégalang side du étanan a méniwala. ");
INSERT INTO dgc_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Pinagkébil de side ta éye a sulat: “A tétotop me; sikame a apostol, éy sinulatan me kam, sikam a mégiyan ta Antiokia, sakay Siria, sakay Silisia. Sikam a éwan Judeo. Kumusta kam? ");
INSERT INTO dgc_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Nabaheta me a te tolay a nangligalig dikam, a gébwat kan side dikame, a kagi de a te kailangan kam kan a sumunud ta kautusan ni Moises. Pero éwan me side inutusan. ");
INSERT INTO dgc_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","27","Kanya nagmiting kame dén se tungkul to kinagi de dikam a mali. Ey nadid éy naisipan me a paangen me dikam tu éduwa a kaguman me, a monda mégkagi side dikam ta katutuhanan. I ngahen dia éy ti Hudas sakay ti Silas. Pinakuyog me side de kadimoy tam a Bernabe éy ti Pablo; da side éy nitaya de i buhay de ta meadu a beses alang-alang ni Panginoon tam a Jesu Cristo. ");
INSERT INTO dgc_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Da sikame, éy naisipan me dén ta pamag-itan na tulung na Banal a Espiritu, a éwan me kam pilitén a sumunud ta rilihiyon na Judeo. Basta i hatul mia dikam, ");
INSERT INTO dgc_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","éy diyan moy kanén tu buhay no niatang, sakay diyan kam méngibébi éy ta méngilélake; sakay diyan kam méngan ta dige éy ta pilas a medige. Eng sundin moy san diden ya a utus, éy tama dén. Ewan dén.” ");
INSERT INTO dgc_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Nadid, pinéglakad de de Pablo ta Antiokia, a kébilén de tu sulat. Ey kédemét de sa, éy pinatipun de du étanan a méniwala, sakay niatéd de dide tu sulat. ");
INSERT INTO dgc_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ey to pékabasa de éy mésahat side to kagi no sulat. ");
INSERT INTO dgc_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Ey ti Hudas sakay ti Silas éy nale side a naghatul dide, a pinatibay de side tu isip. ");
INSERT INTO dgc_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ey kélipas na sénganya wade a aldew, éy nagsoli ti Hudas ta Jerusalem. ");
INSERT INTO dgc_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Pero gustu ni Silas a mawahak ta Antiokia. ");
INSERT INTO dgc_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pati ti Pablo sakay ti Bernabe, éy édsa pabi side ta éya, a mégtoldu side ta kagi na Diyos, a kaguman de du iba sa a mégtoldu. Ta Adeyo a Lugar ");
INSERT INTO dgc_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Nadid, kélipas na sénganya a aldew, éy ti Pablo éy kinagi na ni Bernabe, a “Kita dén bumisita a huway du bigu a méniwala ta inangayan ta a banubanuwan to éya, éng mahusay pabi tu péniwala du tolay a tinolduan ta sa.” ");
INSERT INTO dgc_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Ey ti Bernabe éy gustu na a kuyugén de man dén ti Juan Markos. ");
INSERT INTO dgc_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pero sala ni Pablo a kuyugén, da gininanan side ni Markos to éya ta Pampilia. ");
INSERT INTO dgc_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Néglébug side ta mahigpit ta éya, a tulos naghiwalay side. Ti Bernabe éy kinuyog na ti Markos, a inumange side ta Sipre. ");
INSERT INTO dgc_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Sakay ti Pablo, éy pinili na ti Silas a kaguman na. Ey du tolay sa, éy nipanalangin de de Pablo, sakay pinéglakad de side. ");
INSERT INTO dgc_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ey nagtulos pa side ta Siria sakay ta Silisia, a patibayén de du tolay a bigu a méniwala ta éya. ");
INSERT INTO dgc_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Inumange de Pablo ta Derbe sakay ta Listra. Ta éya éy te lélake a méniwala ni Jesus, a ti Timoteo i ngahen naa. Tu ina na éy Judeo a méniwala be, pero tu ama na éy Griego. ");
INSERT INTO dgc_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Du tolay ta Listra sakay ta Ikonio, éy kagi de a mahusay a lélake ti Timoteo. ");
INSERT INTO dgc_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Ti Pablo éy gustu na kuyugén na ti Timoteo. Kanya binugit na pa siya ayun ta rilihiyon na Judeo. Binugit na siya, monda éwan side idelan du Judeo ta angayan dia a banubanuwan. Da tukoy de dén a éwan Judeo tu ama ni Timoteo. ");
INSERT INTO dgc_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Nadid, to péglakad de Pablo ta bawat banuwan, éy nipeta de du tolay ta simbaan tu sulat a ginamet du apostol ta Jerusalem. Sakay nibilin de dide a dapat sundin de tu utus to sulat. ");
INSERT INTO dgc_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Kanya du tolay ta bawat simbaan, éy lalo a tinumibay tu péniwala de, dahil to kagi ni Pablo, sakay lalo be a kinumadu du méniwala ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Nadid, nagtulos side ta Pirgia sakay Galasia, da sinaway side na Banal a Espiritu a mégpahayag ta kagi na Diyos ta Asia. ");
INSERT INTO dgc_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ey kédemét de to tapat na Misia, éy talaga side a umange ta Bitinia, pero sinaway man dén side na Espiritu ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Kanya sinalinan de san i Misia, a nagtulos side ta Troas. ");
INSERT INTO dgc_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ta éya a kélép, éy pinagtagenép na Diyos ti Pablo. Neta na kan i esa a lélake a te taknég, a taga Masedonia, a kinagi na kan diya ta mahigpit, a “Kadon. Umahabes ka pad se dikame ta Masedoniae, a tulungan mo kame.” ");
INSERT INTO dgc_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Nadid, to péngikagi ni Pablo dikame to tinagenép na, éy nagayak kame a inumahabes ta Masedonia, da neta me a gustu bale na Diyos a umange kame sa a magpahayag ta Mahusay a Baheta. ");
INSERT INTO dgc_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Nadid, tinumulak kame ta Troas, a dinumiretyo kame ta puduk na Samotrasia. Sakay to kagagabian na éya, éy nagtulos kame ta Neapolis. ");
INSERT INTO dgc_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Kéahawas me ta éya, éy inumange kame ta Pilipos, a négiyan kame sa a sénganya a aldew. I Pilipos éy dikél a banuwan ta Masedonia. Sakay meadu a taga Roma a tolay a mégiyan ta éya. ");
INSERT INTO dgc_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","To aldew a pangilin éy linumwas kame to banuwan, a inumange kame to dinom, da te pénalanginan sa a para du Judeo. Ta éya éy négkagi kame du bébe a édsa sa. ");
INSERT INTO dgc_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ey te esa a bébe ta éya a taga Tiatira, a ti Lidia i ngahen naa. I tarabaho na éy méglako ta kundiman. Mékidiyos siya a bébe. Pékabati na to kagi ni Pablo, éy pinagisip siya na Diyos ta mahusay, a monda maniwala siya a tahod to kinagi na. ");
INSERT INTO dgc_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Nadid nipabinyag siya sakay tu kabile na. Tulos inakit na kame, a kinagi na, “Eng ibilangék moy nadid a tunay a katulung na Panginoon, éy tumulos kam pad ta bile mia.” Kanya tinumulos kame to bile de. ");
INSERT INTO dgc_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","To esa a aldew, éy umange kame man dén to pénalanginan na Judeo, éy kasambat me i esa a bébe a utusan, a te bunog a méngatéd diya ta kapangyarian a makapaghula. Du amo no bébe, éy dikél i mineta de a kuhata dahil to péghula no bébe. ");
INSERT INTO dgc_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Siya éy inumunonod dikame ti Pablo, a i kékagi na ta medegsén, a “Diden ye a lélake éy utusan side na mataas a Diyos. Mégpahayag side,” kagi na, “éng kodya kam a meligtas.” ");
INSERT INTO dgc_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Kona sa i péngabala naa dikame ta meadu a aldew. Ey to esa a aldew, da naabala ti Pablo, éy sinuleg na tu bébe a uméunonod, sakay kinagi na to medukés a espiritu, a “Utusan ta ka ta pamag-itan na ngahen ni Jesu Cristo, umibut ka dén ta ina a bébe!” Ey to pégkagi na ta éya, éy inumibut dén agad to bébe. ");
INSERT INTO dgc_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Pero du amo na, péketa de a naibutan dén side to péketan de ta kuhata, éy dinikép de de Pablo sakay ti Silas, sakay niange de side du konsiyal ta banuwan. ");
INSERT INTO dgc_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Niharap de side du tagapamahala, a nidimanda de side. “Diden ye a éduwa a Judeo,” kagi de, “éy méngligalig side ta banuwan tamae. ");
INSERT INTO dgc_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Mégtoldu side ta ugali a labag ta batas tam. Taga Roma kitam, a éwan kitam maari a sumunud ta ugali a ina.” ");
INSERT INTO dgc_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Pati du meadu sa a tolay éy pinaginglan de be side. Ey du tagapamahala, éy nipaékbus de tu badu de Pablo, sakay nipabalbal de side ta meadu, ");
INSERT INTO dgc_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","sakay nipihesu de side. Sakay kinagi de to guwardia, a bantayan na side ta mahigpit. ");
INSERT INTO dgc_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Kanya tu guwardia éy niesdép na side ta medisalad a kuwarto to pégpihesuan. Sakay niegut na i tikéd dia ta sélat no éduwa a tabla. ");
INSERT INTO dgc_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Nadid, to hatinggabi dén, éy nanalangin de Pablo, sakay négkanta side ta kanta ta Diyos. Ey du iba sa a pihesu éy négbati side dide. ");
INSERT INTO dgc_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ey nadid éy bigla a linumindul ta mebagség, a tulos nayégyég tu pégpihesuan. Ey dudu pintuan na, éy basta binumukas side a étanan. Sakay naukad be du igut du étanan a pihesu. ");
INSERT INTO dgc_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ey tu guwardia, kélukag na éy mineta na a bukas dén du pintuan. Ey binagut na tu sondang na, a talaga na a bikalén tu bégi na, da akala na éy ginuminan dén du pihesu a étanan. ");
INSERT INTO dgc_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pero dinumulaw ti Pablo diya, a kinagi na a “Diyan mo bébunon i bégi mua! Kéye kame san a étanan.” ");
INSERT INTO dgc_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ey tu guwardia éy pinadingat na du simbu, sakay naginan siya de Pablo, a dinumapa siya to harap de. ");
INSERT INTO dgc_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Sakay niluwas na side, a kinagi na dide, a “Anya wade i gemtén ko, a monda meligtasék?” ");
INSERT INTO dgc_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ey kinagi de Pablo, a “Maniwala ka ta Panginoon Jesus, éy meligtas ka; siko sakay tu pamiliya mo.” ");
INSERT INTO dgc_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Tulos nipahayag dide ni Pablo tu kagi na Diyos. ");
INSERT INTO dgc_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ey to kélép be san a éya éy inugisan no guwardia tu talitalingo de Pablo, sakay tulos nipabinyag siya, sakay du mététena na. ");
INSERT INTO dgc_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Sakay pinatulos na side to bile na a pinakan. Ey mésahat side a mététena, da méniwala dén side nadid ta Diyos. ");
INSERT INTO dgc_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Pero to gagabi dén, éy du tagapamahala, éy pinaange de du pulis to pégpihesuan a paluwasén de de Pablo. ");
INSERT INTO dgc_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Kanya kinagi no guwardia, a “Niutus kan du tagapamahala a libri kam dén a lumwas. Maari kam dén a humektat.” ");
INSERT INTO dgc_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pero “Ewan,” kagi ni Pablo du pulis. “Side du te kasalanan dikame, da binalbal de kame ta harap du tolay, sakay nipihesu de kame, maski éwan kame tu kasalanan! Sakay taga Roma kame be. Ey nadid éy paluwasén de kame bale ta lihim san? Ewan maari! Side i bahala a umange se a méngiluwas dikame.” ");
INSERT INTO dgc_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Nadid, kinagi du Pulis du tagapamahala tu kinagi ni Pablo. Ey side, pékabati de a taga Roma de Pablo, éy inumanteng side, a makay iabla de side ta gubernador. ");
INSERT INTO dgc_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Kanya inumange side agad to pégpihesuan, a tinumawad, Sakay side a mismo i néngiluwasa dide ta harap du tolay, a pinékiohonan de side a humektat to banuwan de. ");
INSERT INTO dgc_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ey to kéluwas de dén, éy nagtulos pa side to bile de Lidia. Ey to péghatul de du bigu a méniwala ta éya, éy hinumektat dén side. ");
INSERT INTO dgc_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Nadid, dinumiman side ta Ampipolis sakay ta Apolonia, sakay dinumemét side ta Tesalonika. Da te kapilya sa na Judeo, ");
INSERT INTO dgc_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","éy inumange pa sa ti Pablo, da saya i ugali na. To lubuk no étélo a simba éy nékipagpasuway sa siya du tolay ta tuwing pangilin, a gégamitén na tu kasulatan na Diyos. ");
INSERT INTO dgc_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Pinatunayan na dide a tu pinili na Diyos a tagapagligtas, éy kailangan a mate pa ta hirap, sakay mabuhay a huway. “I éya a Jesus a iyépahayag me,” kagi na, “éy siya i Cristo a tagapagligtas.” ");
INSERT INTO dgc_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Naakit dén i sénganya du Judeo, a nékiagum dén side ni Pablo sakay ti Silas. Sakay te meadu be a éwan Judeo a méniwala, sakay du sénganya a mataas a bébe. ");
INSERT INTO dgc_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Pero du Judeo a iba éy nanaghili side. Kanya inakit de du istambay ta plasa na banuwan, a kaguman de, a tulos linigalig de i banuwan. Linuuben de pa tu bile ni Hason, a inahayok de sa ti Pablo sakay ti Silas, a monda idimanda de side. ");
INSERT INTO dgc_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ey nadid, da éwan de side neta, éy kembil de ti Hason a niharap to mayor. Sakay niange de be sa i iba a méniwala ni Jesus. Niabla de ti Pablo, a kinagi de to mayor, a “Diden ya a lélake, éy méngligalig side ta tolay maski ahe a banuwan! Ey nadid éy sendép de dén i banuwan tamae! ");
INSERT INTO dgc_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Sakay ti Hason,” kagi de, “éy pinatulos na side ta bile dia! Sumésuway side a étanan ta utus no hari tam ta Roma, da mégtoldu side a te iba kitam kan a hari, a i ngahen na kana éy ti Jesus!” ");
INSERT INTO dgc_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Nadid du tolay sakay tu mayor, pékabati de ta éya, éy naligalig be side. ");
INSERT INTO dgc_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Bagu de linégsiwan de Hason, éy nagaged pa side ta piyansa. ");
INSERT INTO dgc_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Nadid, ta éya be san a kélép, éy du bigu a méniwala éy pinéglakad de de Pablo sakay ti Silas ta Berea. Ey kédemét de sa éy inumange pa side to kapilya sa du Judeo. ");
INSERT INTO dgc_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Du Judeo ta Berea, éy mas mebait side kesira du Judeo ta Tesalonika. Mésahat side a mégbati to pégtoldu de Pablo, sakay bébasaén de aldew-aldew i kasulatan na Diyos, éng tahod ngani tu pégtoldu de. ");
INSERT INTO dgc_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Kanya naniwala i meadu a Judeo ta éya. Ey kona be du éwan Judeo, sakay i sénganya a mataas a bébe. ");
INSERT INTO dgc_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Pero du Judeo ta Tesalonika, pékabaheta de a nipahayag dén ni Pablo i kagi na Diyos ta Berea, éy tinumagubet side, sakay sinulsulan de du tolay sa, a monda lébugén de de Pablo. ");
INSERT INTO dgc_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Kanya du tolay sa a méniwala, éy pinéglakad de agad ti Pablo ta diget. Pero nawahak de Silas éy ti Timoteo. ");
INSERT INTO dgc_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Du néngitugén ni Pablo, éy niange de siya ta Atenas, sakay nagsoli side ta Berea, a nibilin dide ni Pablo a tumagubet agad de Silas. ");
INSERT INTO dgc_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Habang méguhay ti Pablo dide ta Atenas, éy napansing na a putat i éya a banuwan ta diyos-diyosan a ribultu. Ey nagdukés i isip naa. ");
INSERT INTO dgc_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Kanya nékipagpasuway siya du Judeo to kapilya, sakay du éwan Judeo a mékidiyos, sakay maski ti ésiya a meta na ta plasa na banuwan aldew-aldew. ");
INSERT INTO dgc_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Sakay te sénganya a mataas a maistu no iba a rilihiyon ta éya, a mékipégpagsuway be side ni Pablo. Dinédusta de siya, a kinagi de, a “Anya wade i kékagi-kagin na lélakeae a mégpalalo?” Ey kinagi du iba, a “Mégtoldu wade siya ta iba a kalase a diyos.” Kona sa i kagi dia, da mégtoldu ti Pablo tungkul ni Jesus sakay ta kébuhay a huway. ");
INSERT INTO dgc_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Niange de ti Pablo to pégmitingan du matétanda, a monda mabati de éng anya i iyétoldu naa. “Gustu me a mapospusan éng anya i pégtoldu mua,” kagi de, ");
INSERT INTO dgc_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","“da iba i pégtoldu mua, éy gustu me a mapospusan i kahulugen naa.” ");
INSERT INTO dgc_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Du tolay ta Atenas, éy éwan side tu iba a gimet, éngˈwan palagi side a méguhon-uhon ta maski anya a bigu a bagay. ");
INSERT INTO dgc_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Nadid ti Pablo, éy tinumaknég siya ta harap du matétanda, a mégkagi dide. “Sikam a taga Atenas,” kagi na, “napansing ko dén a gustu moy i sari-sari a rilihiyon, ");
INSERT INTO dgc_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","da neta ko a te meadu kam a puwesto a pégdasalan ta banuwan moyae. Sakay neta ko be tu pastel to pégdasalan moy a esa, a i kagi naa éy ‘Saye i pégdasalan tam to diyos a éwan tam pabi tukoy.’ Nadid,” kagi ni Pablo, “i éya a péniwalaan moy, maski éwan moy pabi tukoy, éy ipahayag ko dikam. ");
INSERT INTO dgc_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Siya i tunay a Diyos a nagimet ta mundua sakay ta étanan a lasén na. Siya i makapangyariana ta langet éy ta munduae. Ey maski anya a kalase a bile a pégdasalan a gemtén na tolay, éy éwan sa mégiyan i Diyos. ");
INSERT INTO dgc_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ewan be maari i tolay a méngatéd ta Diyos ta kaigian na, da éwan siya tu kailangan. Engˈwan siya i méngatéda dikitam ta buhay, sakay ta iba a kailangan tam. ");
INSERT INTO dgc_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","I étanan a kalakalase a tolay ta mundua, éy gébwat side to neditol a ginimet na Diyos a tolay. Sakay pinégiyan side na Diyos ta maski ahe ta mundua. Tiniyak dén na Diyos éng sénganya a taon i buhay na bawat tolay, sakay éng ahe i pégiyanan de. ");
INSERT INTO dgc_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ey bakit pinégiyan na Diyos i tolay ta mundua? Monda maka éy isipén de siya a matukuyan de siya. Ey éwan adeyo i Diyos ta tolay; éngˈwan adene siya ta bawat esa dikitam. ");
INSERT INTO dgc_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Siya i mégalagaa dikitam,” kagi ni Pablo. “Eng éwan siya éy éwan kitam tu buhay. Natandaan moy tu kagi no kabébayan moy a esa, a sikitam kan i anak na Diyos. ");
INSERT INTO dgc_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ey nadid, éng anak kitam na Diyos, éy bakit isipén moy a diyos du ribultu moy? Maski ribultu a bito, maski ribultu a pilak, maski ribultu a gintu, éy ginamet san ya dudu bihasa a mégimet ta ribultu. ");
INSERT INTO dgc_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Nale a panahun a éwan pinarusaan na Diyos du tolay a éwan diya nakatukoy. Pero nadid éy iyéutus na ta tolay ta maski ahe, a magsisi side, sakay ibutan de tu ugali de a medukés. ");
INSERT INTO dgc_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Tandaan moy,” kagi ni Pablo, “nitakda dén na Diyos i aldew a péghukum ta mundua. Te lélake a pinili siya a maghukum. Ey siya ti Jesus! Sakay pinatunayan kitam dén na Diyos a ti Jesus ngani dén i pinili naa, da binuhay na siya to nikate na.” ");
INSERT INTO dgc_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Nadid, to pékabati de to kagi ni Pablo tungkul ta kébuhay a huway, éy pinégngihitan siya du kalahati. Pero du iba éy gustu de a mabati a huway tu kagi na. ");
INSERT INTO dgc_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ey hinumektat ti Pablo to pégmitingan de. ");
INSERT INTO dgc_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Te sénganya a lélake a nékiagum ni Pablo, a tulos naniwala side ni Jesus. I esa dide éy ti lakay a Dionisio. Siya éy konsiyal a esa. Tu esa man éy ti bakés a Damaris. Sakay iba pa. ");
INSERT INTO dgc_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Nadid éy inumange ti Pablo ta Korinto. ");
INSERT INTO dgc_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ta éya éy netaunan na i esa a Judeo a taga Ponto, a ti Akila i ngahen naa. Tu asawa na éy ti Priskila. Kédedemét de pabi a gébwat ta Roma, da ti Gubernador Klaudio éy pinaibut na dén du Judeo ta Roma. Binumisita dide ti Pablo, ");
INSERT INTO dgc_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","sakay tinumulos siya dide, da i tarabaho de éy mégimet ta tolda. Ey siya be ya i hanap-buhay ni Pablo. ");
INSERT INTO dgc_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Tuwing pangilin, éy nékipagpasuway ti Pablo du Judeo to kapilya, a pépilitén na maka side a méniwala; maski Judeo éy ta éwan Judeo. ");
INSERT INTO dgc_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Ti Silas sakay ti Timoteo, pékaabut de ni Pablo a gébwat side ta Masedonia, éy dinemtan de a mégtoldu a aldew-aldew, a mégpatunay siya du Judeo a ti Jesus i pinilia na Diyos a tagapagligtas. ");
INSERT INTO dgc_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Pero du Judeo éy kontara side diya, a pinintasan de siya. Kanya ti Pablo éy nipeta na tu iyamut na dide, a nipagpag na dide tu alikabuk to badu na. “Sikam san dén i bahala éng mepahamak kam,” kagi na. “Ewan ko dén kapanagutan. Sapul nadid éy magtolduék du éwan Judeo.” ");
INSERT INTO dgc_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Tulos pinabayan side ni Pablo, a inumagton dén siya to bile ni Tisio Husto. Siya éy éwan Judeo a méniwala ta Diyos. Karatig no kapilya tu bile na. ");
INSERT INTO dgc_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Tu tagapamahala ta éya a kapilya éy ti Krispo. Siya éy méniwala ta Panginoon. Ey méniwala be tu kabile na. Sakay te meadu be a iba a tolay ta Korinto a nabaheta de i tungkul ni Jesus, a naniwala side, sakay nipabinyag side. ");
INSERT INTO dgc_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","To esa a kélép éy te tagenép ti Pablo, a kinagi diya na Panginoon, a “Diyan ka méganteng; itulos mo san tu pégpahayag mo, maski anya i manyaria. ");
INSERT INTO dgc_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Da égseék diko, kanya éwan ka maanya. Da te meadu a tolay a maniwala diyakén ta banuwanae.” ");
INSERT INTO dgc_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Kanya ti Pablo, éy nale siya ta éya a banuwan a nagtoldu ta kagi na Diyos. Esa a taon éy ta kalahati. ");
INSERT INTO dgc_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Nadid, to panahun ni Galion a gubernador ta Akaya, éy nagkaesa du Judeo a dekpén de ti Pablo, a nitugén de siya ta huwes. ");
INSERT INTO dgc_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Niabla de siya ni Gubernador Galion, a kinagi de, a “I éye a lélake éy akitén na du tolay a baguén de tu péniwala de ta Diyos, éy labag ya ta batas!” ");
INSERT INTO dgc_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Nadid, talaga a sumengbet ti Pablo, éy kinagi ni Galion du Judeo, a “Eng talaga a dikél i kasalanan na éye a lélake, éy baten ta kam. Pero nadid, da éwan na nilabag i batas, ");
INSERT INTO dgc_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","éy bahala kam dén. Ewan ko tanggapén i asuntu moya, da tungkul san ta rilihiyon moy i abla moya.” ");
INSERT INTO dgc_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ey to pégkagi no gubernador ta éya, éy pinaibut na du Judeo to opisina na. ");
INSERT INTO dgc_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ey du iba a tolay sa, éy dinale de tu tagapamahala to kapilya du Judeo, a ti Sostenes, sakay binélbég de siya ta harap no opisina no gubernador. Pero tu gubernador éy éwan na side pinansing. ");
INSERT INTO dgc_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Kétapos na éya, éy sénganya pa a aldew a mégiyan ti Pablo ta Korinto, sakay néglakad siya ta Siria, a kaguman na de Priskila a pasawa. Kédemét de ta Senkrea, éy nipagupet ti Pablo, da natupad na dén tu nipangako na ta Diyos. ");
INSERT INTO dgc_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","21","Kédemét de ta Epeso, éy inumange ti Pablo to kapilya ta éya, a nékipagpasuway siya du Judeo ta éya. Ey inakit de siya a tumulos dide ta male a panahun, pero inidelan na side. Sinala na. “Magsoliék se éng kaluuben na Diyos,” kagi na. Ey hinumektat siya dide a sinumakay siya to paraw. ");
INSERT INTO dgc_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Nadid, to képundu de ta Sesarea, éy inumange pa ti Pablo ta Jerusalem a binumate siya du méniwala ta éya, sakay nagsoli dén siya ta Antiokia. ");
INSERT INTO dgc_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Kélipas na sénganya a aldew ta éya, éy hinumektat man dén siya a inumange man dén ta Galasia sakay ta Pirigia, a binisita na du méniwala ta éya, a pinatibay na tu péniwala de. ");
INSERT INTO dgc_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Nadid, dinumemét ta Epeso i esa a Judeo, a ti Apolos i ngahen naa. Taga Alehandria siya. Bihasa siya a mégtalumpati, sakay tukoy na ta mahusay i kasulatan na Diyos. ");
INSERT INTO dgc_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Natolduan siya tungkul ta Panginoon, pero éwan étanan, da i tukoy na sana éy tu dati a pégtoldu ni Juan tungkul ta pégbinyag. Mesipag ti Apolos a mégkagi du tolay ta tungkul ni Jesus ");
INSERT INTO dgc_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","du kapilya du Judeo. Pero de Priskila a pasawa, pékabati de diya éy niange de siya to bile de, a monda ipaliwanag de diya i ugali na Diyos a éwan na pabi tukoy. ");
INSERT INTO dgc_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Ey nadid, naisip dén ni Apolos a umange ta Akaya. Ey du tolay to simbaan ta Epeso éy inaguman de siya. Nanulat side du kaguman de ta éya a méniwala, a dapat tanggapén de ti Apolos ta mahusay. Ey kédemét na ta éya, éy memahal tu péngtulung na du méniwala ta éya. ");
INSERT INTO dgc_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Da natalo na du Judeo ta pékipégpasuway naa dide ta harap du tolay. Ginamit na tu kasulatan na Diyos a nagpatunay dide a ti Jesus a mismo i tiniyak na Diyos a tagapagligtas ta tolay. ");
INSERT INTO dgc_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Nadid, habang kéye pabi ti Apolos ta Korinto, éy ti Pablo man éy nagtulos ta bukibuked ta Pirigia, a linumwas siya ta Epeso. Ey kédemét na sa, éy netaunan na sa i sénganya a tolay a méniwala. ");
INSERT INTO dgc_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Ey kinagi na dide éng inumange dide i Banal a Espiritu to péniwala de. Ey “Ewan,” kagi de; “éwan me pabi nabaheta a te Banal a Espiritu.” ");
INSERT INTO dgc_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","“Anya i kalase no pégbinyag dikam, éng kona sa?” kagi na. “Ey kona be to pégbinyag a nitoldu ni Juan to araw,” kagi de. ");
INSERT INTO dgc_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Ey kinagi ni Pablo dide, “i kahulugina no pégbinyag ni Juan, éy monda magpatunay du tolay a inibutan de dén tu kasalanan de. Sakay kinagi be ni Juan dide a dapat side a maniwala ta adene dén a dumemét a kalewas na. Ey ti ésiya tu kalewas na, éng éwan ti Jesus?” ");
INSERT INTO dgc_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Nadid, pékabati de ta éya, éy nipabinyag side a huway, a nipasakup side ta Panginoon Jesus. ");
INSERT INTO dgc_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ey ti Pablo éy nitupu na i kamét naa dide, a tulos inumasék dide i Banal a Espiritu; sakay tulos négkagi side ta iba-iba a kagi. Sakay pinégkagi be side na Diyos ta kagi na. ");
INSERT INTO dgc_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Manga sapulu éy ta éduwa side a tolay. ");
INSERT INTO dgc_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Nadid, to étélo a bulan éy uméange ti Pablo to kapilya du Judeo ta éya, sakay mékipagpasuway siya du tolay ta éya. Metapang siya a mégtoldu dide, a nipaliwanag na dide éng anya i kapangyarian na Diyos ta tolay. ");
INSERT INTO dgc_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Pero tu sénganya dide éy mégidel side to kagi na, a éwan side naniwala. Inupos de ti Pablo, a kagi de du napisan sa, a medukés tu ugali na Panginoon. Kanya gininanan side ni Pablo, a inumagton siya to iskul ni Tirano, a nagtoldu siya ta éya a aldew-aldew. Ey kinuyog na sa du bigu a méniwala to kapilya. ");
INSERT INTO dgc_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Nagtulos sa siya a nagtoldu to éduwa a taon. Kanya du étanan a négiyan ta Asia, éy nakabati side ta kagi na Panginoon. Pati Judeo éy ta éwan Judeo. ");
INSERT INTO dgc_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Nadid, minagimet i Diyos ta meadu a kataka-taka ta pamag-itan ni Pablo. ");
INSERT INTO dgc_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Maski anya a damit ni Pablo, éng kébilan du te saket, éy maghusay side. Sakay du tolay a hinayup, éy naibut dide du espiritu a medukés. ");
INSERT INTO dgc_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","14","Ey nadid te pitu a Judeo ta éya, a i hanap-buhay dia éy méglebut side a mégamot du tolay a hinayup, a mapaibut de kan i hayup dide. Anak side ni Padi Eskeba. Pékabaheta de ni Pablo, éy inaheg de tu ugali na. Talaga de a gamitén tu ngahen ni Jesus a magamot. I kinagi dia to medukés a espiritu, éy “Utusan me kam ta pamag-itan no ngahen ni Jesus a iyétoldu ni Pablo, a umibut kam dén.” ");
INSERT INTO dgc_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Pero tu nisengbet dide no espiritu, éy “Tenggi ko ti Jesus, sakay tenggi ko ti Pablo, pero sikam,” kagi na, “ti ésiya kam?” ");
INSERT INTO dgc_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Sakay tu lélake a hinayup, basta bigla na side a dinale, sakay binélbég na side a hanggan da ginuminan side ta éya a bile, a minatalitalingo side. Sakay uba be side, da hinéhiklas na tu badu de. ");
INSERT INTO dgc_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ey du étanan ta Epeso, éy nabaheta de i nanyaria dide, a tulos inumanteng side. Ey lalo dén du tolay a nagpuri ni Panginoon Jesus. ");
INSERT INTO dgc_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Sakay meadu du méniwala, éy nipagtapat de tu ginamet de a medukés. ");
INSERT INTO dgc_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Sakay du tolay sa a te bunog, sakay du mégtawas, éy ta mégilo, éy nagsisi be side, a niduhu de du sari-sari a kasulatan de ta harapa du étanan, sakay tinutod de dén. Ey to péngbilang de to halaga diden ya a libru, éy abut bale ta limapulu a libu a kuhata! ");
INSERT INTO dgc_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ey dahil ta éya éy lalo a négkabahibaheta dén. ");
INSERT INTO dgc_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Nadid éy nagayak ti Pablo a umange ta Masedonia sakay ta Akaya, bagu siya umange ta Jerusalem. Ey kétapos na éya éy tu plano na éy umange be siya ta Roma. ");
INSERT INTO dgc_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Kanya pinaditol na pa de Timoteo sakay ti Erasto ta Masedonia. Pero siya éy nawahak pa ta Epeso. ");
INSERT INTO dgc_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Nadid éy nanyari i dikél a ligalig ta éya, dahil du meadu a méniwala ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Te esa a lélake ta éya a mégpanday ta pilak, a ti Demetrio i ngahen naa. I hanap-buhay naa éy mégimet ta kékétihék a bibile a pilak, a nipareho na to dikél a bile no diyos-diyosan de a Diana. Ey du tarabahador ni Demetrio, éy meadu i meeta de a kuhata ta éya a iyélako de. ");
INSERT INTO dgc_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Kanya tinipun side ni Demetrio, a kinagi na dide, a “Kékaguman ko, tukoy moy a gébwat i kabuhayan tam ta gégemtén tam a bibile. ");
INSERT INTO dgc_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Sakay nabaheta moy be dén ti Pablo, a kontara tu pégtoldu na ta ugali tam, da kagi na a éwan kan diyos du gégemtén tam a ribultu. Sakay te meadu dén nadid a tolay a méniwala diya ta éye ta Epeso, sakay ta buu a Asia. ");
INSERT INTO dgc_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","I antingan kua,” kagi na, “éy makay pabayan du tolay i iyélako tam; a sakay pabayan de tu péniwala de to diyos tam a Diana, a péniwalaan na étanan a tolay ta mundua. Makay sakali éy maibut tu péngigalang de diya, éng éwan tam sawayén ti Pablo.” ");
INSERT INTO dgc_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Nadid, pékabati du tolay to kinagi ni Demetrio, éy naiyamut side a tahod, a tulos de nidulédulaw, a “Memahal i Diana na taga Epeso!” ");
INSERT INTO dgc_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Négpépehéngén side a hanggan naligalig i étanan na banuwan. Dinale de tu éduwa a kaguman ni Pablo, a ti Gayo sakay ti Aristorko, sakay dinumulug side a étanan to plasa na banuwan. ");
INSERT INTO dgc_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Ey ti Pablo, gustu na maka a umange dide, pero sinaway siya du kakaguman na. ");
INSERT INTO dgc_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Pati du sénganya a konsiyal ta éya, a kadimoy ni Pablo, éy nibilin de to esa a umange mékiohon diya a diyan siya uméange to plasa. ");
INSERT INTO dgc_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Nadid, dikél i pehéng dia, a hanggan naligalig i buu a banuwan. Sari-sari nadid i pépehéngén dia. I keaduan de, éy éwan de tukoy éng bakit minatipun side. ");
INSERT INTO dgc_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","I sénganya dide éy akala de éy bahala ti Alehandro, da pinataknég siya du Judeo ta harap dia. Niontok ni Alehandro tu kamét na, a magpatahimik dide, monda mégkagi maka siya dide ta katuwiran na. ");
INSERT INTO dgc_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Pero du tolay, péketa de a Judeo siya, éy lalo side a nagpehéng, a négkékagien side ta lubuk na éduwa a oras, a “Memahal i Diana na taga Epeso!” ");
INSERT INTO dgc_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","To katapusan na éya éy napatahimik no mayor du tolay. “Kabébayan ko,” kagi na. “Diyan kam métageg a maibut i diyos tam a Diana. Ti ésiya a tolay i éwana mékatukoy a i Epeso éy puwesto na bile ni Diana? Sakay tanyag be dén a minatépduk se to araw tu bito a gébwat ta langet a meubet diya. ");
INSERT INTO dgc_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ewan tu makapégkagi a kakabulyan i éya. Kanya mégpakahusay kam, a diyan kam méligalig. ");
INSERT INTO dgc_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Bakit abalaén moy diden ye a éduwa a lélake. Ataay, tinako de tu simbaan ni Diana? Eupusén de beman tu diyos tam? ");
INSERT INTO dgc_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Sakay de Demetrio, éng gustu de a méngidimanda, éy umange maka side ta munisipyo, da te abugadu sa. Maari side a magabla ta éya. ");
INSERT INTO dgc_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Sakay sikam, éng te kagin kam pabi tungkul ta ligalig moyae, éy maguhay kam ta miting du konsiyal. ");
INSERT INTO dgc_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Da dilikadu tu ligalig moy ta éye nadid, a makay mabintangan kitam no hari a méngligalig kitam, éy éwan kitam tu katuwiran.” ");
INSERT INTO dgc_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Nadid, kétapos no mayor a négkagi ta éya dide, éy pinasoli na side to bile de. ");
INSERT INTO dgc_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Nadid, kélipas na éya a ligalig, éy pinauwet ni Pablo du méniwala, sakay hinatulan na side. Ey kétapos na éya, éy hinumektat siya, a tinumamo ta Masedonia. ");
INSERT INTO dgc_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Tinumulos sa siya, a pinatibay na du méniwala ta éya. Ey kédemét na ta Gresia, ");
INSERT INTO dgc_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","éy tinumulos sa siya a étélo a bulan. Ey to pégayak na pabi a umange ta Siria, éy nabaheta na a ahayukén siya du Judeo a bunon. Kanya nagsoli siya ta Masedonia. ");
INSERT INTO dgc_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Tu kakaguman na nadid éy ti Sopater a taga Berea, a anak ni Piro, sakay ti Aristarko, sakay ti Segundu, a taga Tesalonika side. Kaguman na be ti Gayo a taga Derbe, sakay ti Timoteo, sakay ti Tikoko éy ti Tropimo a taga Asia, ");
INSERT INTO dgc_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","sakay sakén a ti Lukas. Nagdetol side, a naguhay side dikame ta Troas. ");
INSERT INTO dgc_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Kélipas no piyesta, éy nénegipo kame dide, a sinumakay kame to paraw ta Pilipos. Lima a aldew i linakad me, éy pinumundu kame ta Troas, a inabut me sa du kakaguman me a minégdetol. Ey esa simba kame sa a tinumulos. ");
INSERT INTO dgc_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","To simba, éy napisan kame dén a étanan, a monda umaheg kame to katapusan a péngapon na Panginoon. Ey ti Pablo éy nagdamag siya a mégkagi du napisan sa, da méglakad siya to gagabi. ");
INSERT INTO dgc_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Edsa kame to ontok no bile, sakay te meadu kame a simbu. ");
INSERT INTO dgc_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","To hatinggabi éy te ulito a te eknud to bintana, a ti Otiko i ngahen naa. Ta tongka na éy minagtongkog siya a hanggan da nakatidug; tulos bigla siya a minatépduk to sidung no melangkaw a bile. Ey to péngégkat de, éy pate bale dén. ");
INSERT INTO dgc_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Ey inumogsad ti Pablo a yinapus na. “Diyan kam méligalig,” kagi na, “buhay pabi siya.” ");
INSERT INTO dgc_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ey sinumangkay man dén siya a minéngan side. Sakay négkagi man dén ti Pablo dide a hanggan to késikat no bilag. Ey to gagabi dén, éy hinumektat kame dén. ");
INSERT INTO dgc_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ey mésahat side to ulito, da niange de siya to bile a buhay dén. ");
INSERT INTO dgc_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Nagsakay kame to paraw a tamo ta Asos. Pero ti Pablo éy ginumisot. I nibilin naa dikame éy isakay me siya ta éya. ");
INSERT INTO dgc_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","To pégtagbu me ta Asos, éy nisakay me siya, a nagtulos kame ta Mitilene. ");
INSERT INTO dgc_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Kétulak me ta éya, éy dinumemét kame to kagagabian na to tapat no puduk na Kiyo. Ey to kasunud a aldew, éy linumampas kame ta Samos; éy to kahuway man dén a aldew éy dinumemét kame ta Mileto. ");
INSERT INTO dgc_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Gustu ni Pablo a salinan me san i Epeso, monda éwan kame maabala ta Asia. Mégagaw siya, da gustu na maka a abutén i Jerusalem bagu Piyesta na Pentekos. ");
INSERT INTO dgc_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ta Mileto éy nipauwet ni Pablo du matétanda a mémahala ta simbaan ta Epeso. ");
INSERT INTO dgc_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ey kédemét de, éy naghatul siya dide. “Tukoy moy,” kagi na, “éng kodya i ugali kua sapul to kédedemét ko dikam ta Asia, ");
INSERT INTO dgc_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","a mebaiték, sakay nagtiisék ta meadu a hirap ta tarabaho ko ta Panginoon. Sakay meadu be a nékialam diyakén a Judeo. ");
INSERT INTO dgc_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Tukoy moy a éwanék méganteng a mégtoldu dikam ta maski anya a ikahusay moy, da nagpahayagék ni Jesus ta harap na meadu a tolay, sakay ta bili-bile moy. ");
INSERT INTO dgc_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Maski Judeo éy ta éwan Judeo, éy hinéhatulan ko dén side a dapat a idelan de i kasalanan de, sakay magsoli side ta Diyos, sakay maniwala ta Panginoon tam a Jesu Cristo. ");
INSERT INTO dgc_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Ey nadid,” kagi ni Pablo, “éy méglakadék ta Jerusalem, ayun ta utus diyakén na Banal a Espiritu. Sakay éwan ko tukoy éng anya i manyaria diyakén ta éya. ");
INSERT INTO dgc_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Basta i napospusan ko sana, éy nipaliwanag diyakén na Banal a Espiritu a maghirapék ta éya, sakay ipihesuék. ");
INSERT INTO dgc_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Pero éwan tu halaga i buhay ko, éngˈwan maganap ko maka san i tungkulin ko, sakay tapusén ko i tarabaho ko a niatéd diyakén na Panginoon Jesus, a mégpahayagék ta Mahusay a Baheta tungkul ta kagbi na Diyos. ");
INSERT INTO dgc_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Ey nadid éy naleék a négiyan dikam, habang mégtolduék tungkul ta péghari na Diyos ta tolay. Pero sapul nadid,” kagi ni Pablo, “éy éwanék moy dén meta a huway. ");
INSERT INTO dgc_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Kanya i kagin kua dikam nadid, éy éwan ko kapanagutan éng mapahamak i maski isesa dikam, ");
INSERT INTO dgc_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","da éwan ko niliso dikam i maski anya tungkul ta plano na Diyos. ");
INSERT INTO dgc_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Kanya mangilag kam, a alagaan moy ta mahusay du tolay na Diyos ta Epeso a nientarega dikam na Banal a Espiritu. Pastoran moy du tupa na Diyos, da side i koo na a sarili, da tinubus side na Panginoon to dige na to nikate na. ");
INSERT INTO dgc_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Eng humektaték éy tukoy ko a te metapang a aso a dumuklos dikam, a dalen de du tupa na Diyos. ");
INSERT INTO dgc_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Sakay pati éy dumemét i oras a humiwalay dikam i sénganya ta gurupu moy, a magtoldu side ta kakabulyan, a monda pagkamalién de du tolay a méniwala ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Kanya mangilag kam, a tandaan moy: aldo éy ta kélép éy tinétolduan ta kam ta mahigpit to lubuk na étélo a taon. ");
INSERT INTO dgc_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Nadid, da méglakadék dén,” kagi ni Pablo, “éy ménalanginék ta Diyos, a siya i mégalagaa dikam. Tu kagi na maka i magpatibaya dikam. Maari i Diyos a magpatibay dikam ta péniwala moy; sakay atdinan na kam be ta gantimpala moy a iatéd na du étanan a tolay na. ");
INSERT INTO dgc_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","To pégiyan ko dikam, éy tukoy moy a éwan ko hangad tu kuhata moy o dikaya tu badu moy; ");
INSERT INTO dgc_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","engˈwan nagtarabahoék san ta sarili ko, a monda maketaék ta ikabuhay ko. Ey kona be sa du kaguman ko. ");
INSERT INTO dgc_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ta étanan a pagkékataon ko, éy nipeta ko dikam a dapat kitam a magtarabaho ta mahusay, a monda matulungan tam du tolay a mahirap. Tandaan moy,” kagi ni Pablo, “tu kinagi na Panginoon, éy lalo kan a masaya tu méngatéd kesira ta tumanggap.” ");
INSERT INTO dgc_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Nadid, to pégkagi ni Pablo ta éya du matétanda, éy linumuhud side a minanalangin. ");
INSERT INTO dgc_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ey mégpégsanget side, sakay yinapus de siya a étanan. ");
INSERT INTO dgc_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","I nikalungkut dia éy tu kinagi na a éwan de dén siya meta a huway. Ey tulos niange de siya nitugén a nisakay to paraw. ");
INSERT INTO dgc_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Nadid, éy tinumulak kame dén, a inumahabes kame ta Kos. Ey to kagagabian na éya éy nagtulos kame ta Rodas sakay ta Patara. ");
INSERT INTO dgc_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ta éya éy inumagton kame to esa a paraw a tamo ta Penisia. Ey to péglakad me, ");
INSERT INTO dgc_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","éy tinan-aw me tu puduk na Sipro. Sinalinan me san ya, a nagtulos kame dén ta Siria. Ta éya éy pinumundu kame ta Tiro, da saya i néngitognana no paraw to karga na. ");
INSERT INTO dgc_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Dinemtan me sa i sénganya a tolay a méniwala, éy tinumulos kame dide ta pitu a aldew. Ey side éy kinagi de ni Pablo a diyan siya tumulos ta Jerusalem. Da kinagi dide na Espiritu na Diyos a maghirap kan siya ta éya. ");
INSERT INTO dgc_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ey to kéhektat me sa, éy kinumuyog side dikame a hanggan ta baybay. Linumuhud kame a étanan to baybay a minanalangin, ");
INSERT INTO dgc_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","sakay sinumakay kame to paraw, sakay side, éy nagsoli dén side to bile de. ");
INSERT INTO dgc_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Kétulak me sa, éy inumange kame pa ta Tolemayda. Ey nékiagum kame be sa du méniwala ni Jesus, a tinumulos kame dide ta esa a kélép. ");
INSERT INTO dgc_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ey to gagabi dén éy néglakad kame man dén. Ey kédemét me ta Sesarea, éy tinumulos kame to bile ni Pelip. Siya tu esa du pitu a lélake a pinili de to araw ta Jerusalem. I tungkulin na nadid éy mégpahayag siya ta kagi na Diyos. ");
INSERT INTO dgc_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ti Pelip éy te épat siya a anak a madiket, a bihasa be side a mégpaliwanag ta kagi na Diyos. ");
INSERT INTO dgc_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Nadid, kélipas na sénganya a aldew, éy dinumemét ta éya i esa a purupeta a i ngahen naa éy ti Agabo. ");
INSERT INTO dgc_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Kédemét na dikame, éy inalap na tu sinturon ni Pablo, sakay ginapus na i sarili na a kamét éy ta tikéd na. “Saye tu kinagi na Banal a Espiritu,” kagi na, “a tu te koo ta sinturonae, éy gapusén siya du Judeo ta Jerusalem, a tulos idimanda de siya du éwan Judeo ta éya.” ");
INSERT INTO dgc_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Ey sikame, pékabati me ta éya, éy pinékiohonan me ti Pablo a diyan siya tumulos ta Jerusalem. ");
INSERT INTO dgc_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Pero kinagi ni Pablo dikame, a “Diyanék moy sésawayén! Bakit mégsésangitén kam, a pahinaén moy i isip kua? Ewanék méganteng éng gapusénék de ta Jerusalem. Maski mateék alang-alang ta Panginoon Jesus, éy handaék dén.” ");
INSERT INTO dgc_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Nadid, péketa me a éwan mésaway ti Pablo, éy éwan me dén pinilit. “Masunud maka i kaluuben na Panginoon,” kagi me. ");
INSERT INTO dgc_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Nadid, kélipas na sénganya a aldew, éy nagayak kame a umange ta Jerusalem. ");
INSERT INTO dgc_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Sakay i séngasénganya ta Sesarea a méniwala, éy kinumuyog dikame. Niange de kame to bile no esa a lélake a ti Manason a taga Sipro. Siya éy nale a méniwala ni Jesus. Ey tinumulos kame sa. ");
INSERT INTO dgc_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Kédemét me ta Jerusalem, éy tinanggap kame agad du méniwala ta éya. ");
INSERT INTO dgc_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ey to kagagabian na éya, éy kaguman kame ni Pablo a bumisita de Santiago. Ey édsa be to miting me du étanan a matétanda a tagapamahala ta simbaan ta Jerusalem. ");
INSERT INTO dgc_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Binate side ni Pablo, sakay tulos nibaheta na dide tu nipagimet diya na Diyos du éwan Judeo a tolay, to péglebut na ta Asia sakay ta Masedonia. ");
INSERT INTO dgc_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","To pékabati de Santiago a meadu dén a éwan Judeo i nipasakup ni Jesus, éy mésaya side ta Diyos. Sakay kinagi de ni Pablo i éye: “Entan mo, wadeng, éng sénganya dén a libu a Judeo i méniwalaa ni Jesus. Ey mesipag be side a tumupad ta kautusan ni Moises. ");
INSERT INTO dgc_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ey saye i problema tama, Pablo,” kagi ni Santiago, “da side éy nabaheta de a iba kan i iyétoldu mua du Judeo a mégiyan ta adeyo ta éye. I akala dia éy iyétoldu mo dide a éwan kan dén side tu kailangan a tumupad ta kautusan ni Moises, sakay ta iba a ugali tam. ");
INSERT INTO dgc_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ey nadid, Pablo, éy mégenya kitam, da nabaheta de wade dén a dinumemét ka dén ta éye? ");
INSERT INTO dgc_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","24","Kona se i naisipan me, Pablo, a gemtén mo a monda meta du Judeo a kakabulyan san tu nabaheta de a tungkul diko: Te épat se a lélake a kaguman me. Judeo side a méniwala ni Jesus. Ey te pangako side ta Diyos, a gustu de tupadén. Kanya siko, Pablo,” kagi ni Santiago, “éng maari, éy aguman mo side a tupadén de tu pangako de ta Templo, a monda ipagupet side. Eng siko i bahala a magasta dide, éy meta du Judeo a sésundin mo bale pabi i kautusan ni Moises. ");
INSERT INTO dgc_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ey nadid,” kagi ni Santiago, “tungkul man dén du éwan Judeo a méniwala, éy éwan me side pilitén a sumunud ta ugali tam a Judeo; éngˈwan nanulat kame dén dide to éya, a basta diyan side méngan ta buhay no niatang, sakay diyan side méngibébi éy ta méngilélake, sakay diyan side méngan ta dige éy ta pilas a medige.” ");
INSERT INTO dgc_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Nadid, pékabati ni Pablo ta éya, éy pinumayag. Ey to kagagabian na éya, éy kinuyog na du épat a lélake, a inumange side to Templo a monda tupadén de tu ugali du Judeo a te pangako ta Diyos. Sakay kinagi ni Pablo du padi sa i pedsa na péngtupad de to pangako de, a itugén de ta Templo i pégatang de ta Diyos. ");
INSERT INTO dgc_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Nadid, kélipas na pitu a aldew, éy te Judeo ta éya a gébwat ta Asia, éy mineta de ti Pablo to Templo. Tulos niligalig de du meadu sa a tolay, a sakay dinale de ti Pablo. ");
INSERT INTO dgc_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Dinulawan de du kapareho de a Judeo. “Kamon dén,” kagi de, “aguman moy kame! Siya dén ye tu lélake a medukés,” kagi de, “a mégtoldu du tolay ta iba-iba a banuwan a medukés kan i rilihiyon tam a gébwat ni Moises! Sakay éwan be siya tu galang ta Templo tamae, da pinasdép na be se i tolay a éwan Judeo!” ");
INSERT INTO dgc_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Kinagi de i éya, da neta de a kaguman ni Pablo ti Toropimo to kédedemét na ta Jerusalem, éy éwan siya Judeo. Akala de éy pinasdép na siya to Templo. ");
INSERT INTO dgc_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Nadid, agad méligalig i étanan na banuwan. Dinumulug side ni Pablo a dinale de, sakay nihela de siya to Templo, sakay sineraduan de tu pintuan na. ");
INSERT INTO dgc_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Talaga de a bunon ti Pablo, éy nabaheta no kapitan du sundalu a méligalig du Judeo. (Du sundalu éy taga Roma.) ");
INSERT INTO dgc_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ey agad siya naginan dide, a kinumuyog du sundalu na. Ey du Judeo, péketa de du sundalu éy nihintu de tu pégbélbég de ni Pablo. ");
INSERT INTO dgc_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ey tu kapitan éy dinikép na siya, a nipagapus na ta kadena, sakay pinakelagipan na side éng ti ésiya siya, sakay éng anya i kasalanan naa. ");
INSERT INTO dgc_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","I nisengbita du Judeo éy basta pehéng, a éwan paripareho tu kagi de. Ey tu kapitan, da éwan na mépospusan éng anya i nanyaria, éy inutusan na du sundalu a kébilén de ti Pablo to kwarter. ");
INSERT INTO dgc_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Ey kédemét de to agdenan, éy inégkat siya du sundalu a nisangkay dahil ta kahigpit no ligalig du Judeo. ");
INSERT INTO dgc_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Da uméunonod side du sundalu, a mepehéng side a tahod, a pinégkagian de side a bunon ti Pablo. ");
INSERT INTO dgc_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Nadid, to péngiesdép de ni Pablo to kwarter, éy kinagi na to kapitan, a “Eng maari éy te kaginék diko.” Ey kinagi na ta éya ta kagi na Griego. Ey kinagi no kapitan, a “Tukoy mo bale i kagi na Griego? ");
INSERT INTO dgc_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Eng kona sa, éy besa a siko tu komander a taga Egipto a nékilaban dikame to esa a taon? Akala ko éy siko tu amo du épat a libu a tulisan to ilang a lugar?” ");
INSERT INTO dgc_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Ey “Ewan,” kagi ni Pablo, “Judeoék san a taga Tarso, tu dikél a banuwan ta Silisia. Eng maari, éy mégkagiék pad didi Judeo a éye.” ");
INSERT INTO dgc_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Nadid, da pinumayag tu kapitan, éy niontok ni Pablo tu kamét na monda tumahimik side, sakay négkagi siya dide ta kagi na Judeo. ");
INSERT INTO dgc_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“A tétotop ko a kabébayan ko,” kagi na, “baten moy i katuwiran ko a éye dikam.” ");
INSERT INTO dgc_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Nadid, du Judeo, pékabati de a mégkagi ti Pablo dide ta sarili de a kagi, éy lalo side a tinumahimik. ");
INSERT INTO dgc_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Saken,” kagi ni Pablo, “éy Judeoék. Nienakék ta Tarso, pero dinumikélék ta éye ta Jerusalem, a ti Padi Gameliel tu maistu ko. Kanya inadal ko ta mahusay i étanan a kautusan depu tam. Mesipagék be a sumunud ta Diyos a kona dikam. ");
INSERT INTO dgc_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ey anya tu ginimet ko du tolay a naniwala ni Jesus to éya, éy linoko ko side ta mahigpit, a gustu ko side a ipabuno. Dinikép ko side a nipihesu. Pati lélake éy ta bébe. ");
INSERT INTO dgc_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Maski tu mataas a padi, sakay du tagapamahala moy, éy side i sistigu ko a éwanék mégbuli-buli; da side i nangatéda diyakén ta sulat a te kapangayarianék a magdikép du tolay ta Damasko a méniwala ta éya a ugali. Sakay inumangeék be ta Damasko, a monda dekpén ko sa diden ya a tolay, a talaga ko side a kébilén ta Jerusalem a ipaparusa ko side. ");
INSERT INTO dgc_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Ey anya i nanyaria diyakén? To kéadene ko ta Damasko, a tanghali dén tu bilag, éy bigla a sinumiklab ta palebut kua i demlag a gébwat ta langet. ");
INSERT INTO dgc_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Tulos nalugmukék to luta, sakay nabati ko i boses a kinagi na diyakén, a ‘Saulo, bakit lélabananék mo?’ ");
INSERT INTO dgc_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ey kinagi ko, éy ‘Ti ésiya ka, Amo?’ Ey kinagi no boses, a ‘Ti Jesusék a taga Nasaret. Sakén i lélabanan mua,’ kagi na. ");
INSERT INTO dgc_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Ey du kakaguman ko, éy neta de tu siklab, pero éwan de nabati tu boses a négkagi diyakén. ");
INSERT INTO dgc_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ey saken éy kinagi ko, a ‘Magenyaék, Panginoon?’ Ey kinagi diyakén no Panginoon, a ‘Umégkat ka dén, a somdép ka dén ta Damasko, a te mégkagi diko ta éya ta gustu na Diyos a gemtén mo.’ ");
INSERT INTO dgc_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ey nadid, kéégkat ko, éy buhékék dén dahil to siklab. Ey du kaguman ko éy kinabitanék de a niangeék de dén ta Damasko. ");
INSERT INTO dgc_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Ta éya,” kagi ni Pablo, “éy te lélake a mékidiyos, a ti Ananias i ngahen naa. Tétupadén na i utus na rilihiyon tam, sakay iyégalang siya du étanan a Judeo ta Damasko. ");
INSERT INTO dgc_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Siya éy inumange diyakén, sakay kinagi na, a ‘Wadeng, Saulo, maghusay ka dén tu mata,’ Ey sakén, kélamang ko diya éy naketaék dén. ");
INSERT INTO dgc_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ey kinagi ni Ananias diyakén, a ‘Saulo, i Diyos a péniwalaan depu tam, éy siko ngani dén i pinili naa, da gustu na mapospusan mo i plano na, sakay ipeta na diko tu anak na a banal. Sakay nabati mo dén tu boses na. ");
INSERT INTO dgc_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Siko i magpatunaya diya ta étanan a mineta mo sakay ta minabati mo tungkul ni Jesus. ");
INSERT INTO dgc_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Kanya nadid,’ kagi ni Ananias diyakén, ‘éy diyan ka magalanganin a sumunud diya. Ipabinyag ka nadid, Saulo, a monda maibut dén diko du kasalanan mo, a dulawan mo tu ngahen na.’ ");
INSERT INTO dgc_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Nadid,” kagi ni Pablo, “éy nagsoliék ta Jerusalem. Ey to pénalangin ko ta Templo a ina, éy naketaék ta himala. ");
INSERT INTO dgc_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Neta ko i Panginoon a négkagi diyakén, a ‘Nay, Saulo, ginanan mo dén i Jerusalemae, da di Judeo a éye éy éwan de tanggapén i pégpatunay mua tungkul diyakén.’ ");
INSERT INTO dgc_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ey kinagi ko ta Panginoon, a ‘Maniwala wade side Panginoon, da tukoy de a inumangeék du étanan a kapilya, a pinarusaan ko du étanan a méniwala diko. ");
INSERT INTO dgc_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Sakay tukoy de be, Panginoon,’ kagi ko, ‘a to nipamunu de ni Esteban, éy sinulsulan ko side, sakay binantayan ko be tu badu du namuno diya.’ ");
INSERT INTO dgc_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Pero ‘Ewan,’ kagi na ‘Panginoon diyakén; ikad mo dén, da paangen ta ka ta adeyo a banuwan, a monda ipahayagék mo du iba a tolay a éwan Judeo.’” ");
INSERT INTO dgc_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Nadid, ta éya a kinagi ni Pablo, éy binati siya du Judeo. Pero nadid, da kinagi na man dén a mégpahayag siya du éwan Judeo, éy nagpehéng man dén side: “Bunon moy dén!” kagi de. “Dapat mate siya!” ");
INSERT INTO dgc_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Négkélanget side sakay nisalu de tu badu de, sakay nisapwah de be i alikabuk, da méiyamut side a tahod. ");
INSERT INTO dgc_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Ey tu kapitan, éy pinasdép na ti Pablo to kwarter, sakay inutusan na du sundalu na a balbalén de siya, monda ipagtapat na dide éng anya i kasalanan na, éng bakit mégingél du Judeo diya. ");
INSERT INTO dgc_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ey nadid, to pénggapus de dén ni Pablo, éy kinagi na to sarhento ta éya, a “Ewan beman labag ta batas i mangbalbal ta taga Roma a tolay, éng éwan mo pa bistaan?” ");
INSERT INTO dgc_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Pékabati no sarhento ta éya, éy inange na kinagi to kapitan, a “Magenya ka? Taga Roma bale i lélake a éya!” ");
INSERT INTO dgc_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Kanya tu kapitan éy inange na nipakelagip ni Pablo éng taga Roma siya a talaga. Ey “O,” kagi ni Pablo. ");
INSERT INTO dgc_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ey kinagi no kapitan, a “Dikél i ginasta ko a kuhata,” kagi na, “baguék sinakup na Roma.” “Pero sakén,” kagi ni Pablo, “éy taga Romaék sapul to kéanak ko.” ");
INSERT INTO dgc_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Nadid, du sundalu a talaga a mamalbal ni Pablo, pékabati de ta éya, éy agad side inumadeyo diya. Pati tu kapitan éy méganteng be, da siya i nagpagapusa diya, éy taga Roma bale siya. ");
INSERT INTO dgc_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","To kagagabian na éya, éy gustu no kapitan a mapospusan éng bakit iabla du Judeo ti Pablo. Kanya pinauwet na du mataas a padi, sakay du tagapamahala a Judeo. Sakay linégsiwan na ti Pablo, sakay niharap na siya dide. ");
INSERT INTO dgc_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Ey ti Pablo éy minalas na du tagapamahala sakay kinagi na dide, a “Kabébayan ko, tukoy ko a éwanék tu kasalanan ta Diyos, sapul to kéanak ko.” ");
INSERT INTO dgc_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Nadid, to pégkagi ni Pablo ta éya, éy tu mataas a padi, éy inutusan na du te taknég ta giled ni Pablo a sapukén de i labi naa. ");
INSERT INTO dgc_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ey ti Pablo éy kinagi na to mataas a padi, a “Sakupén ka maka na Diyos, siko a mégwari-wari a mahusay ka! Kagi mo a te kasalananék, pero siko i te kasalanana, da pinasapukék mo!” ");
INSERT INTO dgc_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Nadid, kinagi du te taknég to adene ni Pablo, a “Pintasan mo bale i mataas a padi?” ");
INSERT INTO dgc_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","“O bale,” kagi ni Pablo, “éng tukoy ko a siya bale i mataas a padi, éy éwan ko pinégkagian, da utus na kasulatan na Diyos a diyan tam pintasan du pinuno tam.” ");
INSERT INTO dgc_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Nadid, neta ni Pablo a te Saduseyo ta éya, sakay Pariseyo be. Kanya kinagi na dide a étanan, “A tétotop ko, sakén éy Pariseyoék sapul to kéanak ko. Kanya bistaanék nadid ta éye éy dahil to pag-asa ko a mabuhay i tolay a huway.” ");
INSERT INTO dgc_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Nadid, to pégkagi na ta éya, éy négpasuway ta mahigpit du Pariseyo sa sakay du Saduseyo. ");
INSERT INTO dgc_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Dahilan du Saduseyo éy éwan side méniwala a mabuhay i tolay a huway, sakay éwan be side méniwala a te espiritu. Pero du Pariseyo éy méniwala side ta éya. ");
INSERT INTO dgc_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Lalo side a nagpehéng, a hanggan tinumaknég i sénganya a Pariseyo a maistu, a kinagi de, a “Ewan kame tu meeta a kasalanan na éye a lélake. Anya wade éng te espiritu a négkagi diya?” ");
INSERT INTO dgc_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Kanya lalo a négingél du Saduseyo, a tulos néglébug side. Ey tu kapitan du sundalu, éy méganteng siya a pasakitan de ti Pablo. Kanya inutusan na du sundalu na a angen de agawén ti Pablo, a kébilén de ta kwarter. ");
INSERT INTO dgc_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","To éya a kélép, éy inumadene i Panginoon ni Pablo, a kinagi na diya, a “Diyan ka méganteng, Pablo. Eng kodya i péngipahayag mua diyakén ta Jerusalemae, éy kona be sa i péngipahayag mua diyakén ta Roma.” ");
INSERT INTO dgc_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Nadid, to kagagabian na éya, éy pinéguhunan dén du Judeo a bunon ti Pablo. Nanumpa side a éwan side méngan éy ta uminum hanggan éwan de mabuno ti Pablo. ");
INSERT INTO dgc_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","I nangakua ta éya a sumpa éy mahigit pa ta épat a pulu a Judeo. ");
INSERT INTO dgc_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","To pénumpa de, éy inumange side du mataas a padi, sakay kinagi de dide, a “Nipangako me a éwan kame méngan éy ta uminum hanggan éwan me pa mabuno ti Pablo. ");
INSERT INTO dgc_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Kanya sikam,” kagi de, “éy ikagi moy pad to kapitan a paangen na se dikam ti Pablo, a monda siyasatén moy siya. Ey sikame éy sanébén me siya, a bunon me siya bagu se siya dumemét.” ");
INSERT INTO dgc_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Nadid, tu anéng ni Pablo, éy nabaheta na tu plano de. Kanya inumange siya to kwarter a nikagi na ni Pablo. ");
INSERT INTO dgc_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Ey kinagi ni Pablo to sarhento ta éya, a “Iange mo i ulito a éye to kapitan, da te kagin siya diya.” ");
INSERT INTO dgc_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ey tu sarhento éy niange na tu anéng ni Pablo to kapitan, a kinagi na diya, a “Gustu ni Pablo a iange ko se diko i ulitoae, da te kagin kan siya diko.” ");
INSERT INTO dgc_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ey tu kapitan éy kinabitan na tu ulito, a pinadigdig, sakay nipakelagip na diya éng anya i kagi naa. ");
INSERT INTO dgc_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","“Du Judeo,” kagi na, “éy négkasundu dén side a mékiohon side diko a paangen mo kan tamay ko a Pablo ta miting de ta gabiya, a monda siyasatén de siya. ");
INSERT INTO dgc_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Pero diyan ka méniwala dide, Kapitan. Te épat a pulu a mangsanéb diya to dilan. Nanumpa kan side a éwan side méngan éy ta uminum hanggan éwan de siya mabuno. Ey nadid éy nakahanda dén side. Méguhay san side, éng méniwala ka dide.” ");
INSERT INTO dgc_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Nadid, pékabati no kapitan ta éya, éy pinéglakad na tu ulito, a kinagi na, a “Diyan mo kagin ta maski ti ésiya a kinagi mo ya diyakén.” ");
INSERT INTO dgc_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Nadid, dinulawan no kapitan tu sarhento na a éduwa, a kinagi na dide, a “Ihanda moy i éduwa a datos a sundalu, a kaguman be i pitu a pulu a kabayo, sakay éduwa be a datos a sundalu a te gayang. Da péglakadén ta kam nadid a kélép a alas nuwebe ta Sesarea. ");
INSERT INTO dgc_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Maghanda kam be ta kabayo a sakayan ni Pablo, da gustu ko a itugén moy siya ni gubernador. Ey alagaan moy siya ta mahusay.” ");
INSERT INTO dgc_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Nadid, nisulat no kapitan to gubernador; éy saye i nisulat naa: ");
INSERT INTO dgc_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Mahal ko a Gubernador Pelik: Kumusta ka? Gébwat ye ni Kapitan Klaudio Lisias. ");
INSERT INTO dgc_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","I lélake a éye a itugén ko sina diko éy ti Pablo. Inagaw ko siya du Judeo, da inikép de siya, a talaga de siya a bunon. Ey taga Roma siya. ");
INSERT INTO dgc_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Niharap ko siya du mataas a Judeo, a monda mapospusan ko éng anya i kasalanan na, éng anya i iabla dia diya. ");
INSERT INTO dgc_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ey neta ko a éwan bale siya tu kasalanan a pamunuan diya, o péngipihesuan diya. Engˈwan, tu abla de diya éy tungkul san to rilihiyon de. ");
INSERT INTO dgc_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Ey to pékabaheta ko a bunon siya du Judeo, éy naisip ko éy petugén ko siya diko. Sakay du Judeo a nagabla diya, éy pinégkagian ko side a umange side mégkagi diko ta dimanda dia. Ewan dén.” ");
INSERT INTO dgc_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Nadid, du sundalu éy tinupad de tu utus no kapitan de, a nitugén de ti Pablo ta Antipatrida ta éya a kélép. ");
INSERT INTO dgc_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Sakay to gagabi, éy nagsoli side. Ey du sundalu a te kabayo éy nagtulos side ta Sesarea. ");
INSERT INTO dgc_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Ey kédemét de, éy nitugén de ti Pablo to gubernador, sakay niatéd de be diya tu sulat no kapitan. ");
INSERT INTO dgc_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Ey tu gubernador éy binasa na tu sulat, sakay nipakelagip na ni Pablo éng taga ahe siya. Ey pékabati na a taga Silisia ti Pablo, ");
INSERT INTO dgc_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","éy kinagi na, a “Mégbatiék ta katuwiran mo kédemét se du néngidimanda diko.” Sakay niutus na du sundalu a bantayan de ti Pablo to bile ni Herod. ");
INSERT INTO dgc_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Nadid, kélipas na lima a aldew, éy dinumemét ti Ananias a mataas a padi, a kaguman na du matétanda a Judeo, sakay tu abugadu de a ti Tertulo. Nagharap side to gubernador, a kinagi de diya tu abla de ni Pablo. ");
INSERT INTO dgc_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Ey pénguwet de ni Pablo, éy niabla siya no abugadu. “Gubernador,” kagi na, “mahusay ka a amo me, da nale a mapayapa nadid i banuwan mia. Siko éy hinusay mo be dén i meadu a problema me. ");
INSERT INTO dgc_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Kanya mégpasalamat kame diko. ");
INSERT INTO dgc_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ey nadid, Gubernador, magpasensiya ka pad ta kagi mia diko. Monda éwan ka masiyadu a maabala, éy baten mo kame ta sandali san. ");
INSERT INTO dgc_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Dahilan,” kagi no abugadu, “éy medukés i lélake a éye. Maski ta ahe i angayan na, éy ligaligén na du Judeo. Sakay amo be siya du tolay a méniwala to lélake a taga Nasaret. ");
INSERT INTO dgc_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Higit pa ta éya, éy éwan siya tu galang to Templo me; éy dinikép me siya ta éya. Talaga me siya a bistaan ayun ta sarili me a ugali. ");
INSERT INTO dgc_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Pero ti Kapitan Lisias, éy sinaway na kame,” kagi no abugadu, “sakay nipadale na kame du sundalu na, a inalap na dikame ti Pablo. ");
INSERT INTO dgc_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Sakay inutusan kame be no kapitan a umange kame se diko. Ey nadid, Gubernador, éng siyasatén mo nadid ti Pablo, éy meta mo a katutuhanan i kagi kua diko.” ");
INSERT INTO dgc_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Pati du Judeo ta éya, éy kinagi de a tutuhanan tu kinagi no abugadu. ");
INSERT INTO dgc_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Nadid, tu gubernador éy pinakultaden na ti Pablo a mégkagi to katuwiran na. Ey kinagi ni Pablo, a “Tukoy ko, Gubernador, a nale a panahun a siko i huwes na Judeo. Kanya mésayaék da siko i pégkagian kua ta katuwiran ko. ");
INSERT INTO dgc_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Da sakén éy labindalawaék pabi a aldew sapul to kédemét ko ta Jerusalem. Kanyaék sa inumange, éy gustu ko san a sumambaék ta Diyos ta éya. ");
INSERT INTO dgc_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ey anya,” kagi ni Pablo, “di Judeo a éye, éy dinemtanék de beman a léligaligén ko du tolay ta éya? Ewan! Ewanék be nékipagsuway du Judeo ta éya, maski ta Templo, maski ta kapilya de ta éya. Kanya éwanék tu kasalanan. ");
INSERT INTO dgc_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Diden ye a Judeo éy éwan side maari a magpatunay diko ta péngpehay dia diyakén. ");
INSERT INTO dgc_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Basta i aminén ko sana éy méniwalaék ta ugali a gébwat ni Jesus, a kagi de a medukés. Saya i pégsamba kua ta Diyos. Sakay méniwalaék be ta kasulatan ni Moises, sakay tu nisulat du purupeta to araw. ");
INSERT INTO dgc_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Sakay umasaék san ta Diyos a kapareho diden ye a Judeo, a pabuhayén na a huway i étanan a tolay ta mundua. Maski du mahusay éy ta medukés. ");
INSERT INTO dgc_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Kanya, Gubernador,” kagi ni Pablo, “éy pumépiliték a mégimet ta mahusay, monda éwanék tu kasalanan ta Diyos éy ta tolay be. ");
INSERT INTO dgc_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Nadid, Gubernador, kélipas na sénganya a taon, éy nagsoliék ta Jerusalem, a monda itugén ko tu ambag me a kuhata du Judeo a te hirap, sakay méngatédék ta Diyos. ");
INSERT INTO dgc_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Ey nadid,” kagi ni Pablo, “to édse ko ta Templo, éy minetaék du Judeo a taga Asia, a tulosék de a dinikép. Pero éwanék tu kasalanan, da éwan tu ligalig ta éya diyakén. ");
INSERT INTO dgc_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Diden ya a taga Asia a nanikép diyakén, éy bakit éwan se side nadid? Eng méngidimanda side diyakén, Gubernador, éy ahe side? ");
INSERT INTO dgc_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ey nadid, da éwan se side, éy maski diden ye a Judeo, éy gustu ko ipagtapat de maka diko éng anya i kasalanan kua a mineta de to péngsiyasat de diyakén to nipagmiting de. ");
INSERT INTO dgc_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Basta i kasalanan kua siguru éy tu kinagi ko dide. Da kinagi ko dide a kanyaék de bistaan éy dahil to pag-asa ko a mabuhay i tolay a huway.” ");
INSERT INTO dgc_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Nadid, pékabati ni Gubernador Pelik to katuwiran ni Pablo, éy kinagi na du Judeo, a “Ewan ko itulos nadid i bista ni Pablo. Engˈwan uhayén ko pa ti Kapitan Lisias.” Da tu gubernador, éy tukoy na dén i ugalia du méniwala ni Jesus, a mebait side. Kanya éwan siya naniwala to abla du Judeo. ");
INSERT INTO dgc_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Sakay inutusan na tu sarhento. “Siko i bahala ni Pablo,” kagi na, “pero diyan mo siya higpitan, sakay pakultaden mo du kadimoy na a méngatéd diya ta kailangan na.” ");
INSERT INTO dgc_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Nadid, kélipas na sénganya a aldew, éy dinumemét ti Gubernador Pelik, a kaguman na tu asawa na. Tu asawa na éy Judeo, a i ngahen naa éy ti Drusila. Ey nipauwet de ti Pablo, monda mabati de tu kagi na tungkul to péniwala na ni Cristo Jesus. ");
INSERT INTO dgc_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Pero to pégkagi ni Pablo tungkul ta mahusay a ugali, sakay ta pégipos ta bégi na tolay, sakay ta péghukum na Diyos a dumemét, éy inumanteng ti Pelik. Kanya pinasoli na ti Pablo to kwarter. “Ikad mo dén,” kagi na. “Ipauwet ta ka ta esa a aldew.” ");
INSERT INTO dgc_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","I isipa ni Pelik, éy makay atdinan siya ni Pablo ta kuhata, a monda légsiwan na siya. Kanya medalas na siya a nipauwet, a mékiohon diya. ");
INSERT INTO dgc_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Nadid, kélipas na éduwa a taon, éy te iba a gubernador a linewasan na ti Pelik, a ti Porsio Pesto i ngahen naa. Ey ti Pelik, da ménuyu siya du Judeo, éy pinabayan na ti Pablo to pégpihesuan. ");
INSERT INTO dgc_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Nadid, dinumemét dén ti Pesto ta Sesarea. Ey kélipas na étélo san a aldew, éy inumange siya ta Jerusalem. ");
INSERT INTO dgc_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Ey du mataas a padi ta éya, sakay du te tungkulin a Judeo, éy kinagi de diya tu abla de ni Pablo. Nékiohon side ni Presto ");
INSERT INTO dgc_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","a pasolen na ti Pablo ta Jerusalem. Te gayak side a sanébén de siya. ");
INSERT INTO dgc_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Pero “Ewan,” kagi ni Presto, “da pihesu pabi siya ta Sesarea, éy sumoliék ta éya agad. ");
INSERT INTO dgc_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Kanya,” kagi na, “éng gustu moy a mabistaan, éy pakuyugén moy diyakén du konsiyal moy. Sakay éng te kasalanan i éya a lélake, éy idimanda de siya ta éya.” ");
INSERT INTO dgc_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Nadid, kélipas na manga siyam a aldew, éy sinumoli ti Gubernador Pesto ta Sesarea, a kakuyog na du Judeo. Ey to kagagabian na, éy nipauwet na ti Pablo, a monda bistaan de siya. ");
INSERT INTO dgc_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Ey kédemét ni Pablo, éy niéabla siya du Judeo, a nilista de i meadu a ginamet na kan a medukés. Pero éwan side maari a mégpatunay to niabla de. ");
INSERT INTO dgc_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Ey kinagi be ni Pablo tu katuwiran na. “Sumuwayék ta abla dia,” kagi na, “da éwan ko linabag i batas na Judeo sakay ta Templo. Sakay éwan ko linabag i batas na hari ta Roma.” ");
INSERT INTO dgc_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Ey ti Pesto, da ménuyu siya du Judeo, éy kinagi na ni Pablo, a “Gustu mo, Pablo, a umange ta Jerusalem, a monda bistaan de ka ta éya?” ");
INSERT INTO dgc_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Ey “Ewan,” kagi ni Pablo. “Dapat siko i mangbistaa diyakén, da siko i pinakangbégia no hari ta Roma. Ewan maari a magbista diyakén du Judeo, da éwanék tu kasalanan dide. Ey tukoy mo dén ya, Gubernador. ");
INSERT INTO dgc_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Gubernador, éng te kasalananék a pamunuan diyakén, éy éwan ko iwasan. Pero éwan katutuhanan tu abla de diyakén éy éwan maari a iatédék mo dide. Gustu ko a dumayingék to hari ta Roma, a siya san i magbistaa diyakén.” ");
INSERT INTO dgc_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Nadid, pékabati ni Pesto ta éya, éy nipakelagip na du konsiyal na; sakay kinagi na ni Pablo, “Da gustu mo a bahala tu hari a mangbista ta asuntu mo, éy maari, paangen me ka ta éya.” ");
INSERT INTO dgc_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Nadid, kélipas na sénganya man dén a aldew, éy dinumemét ta Sesarea ti Hari Agripa (besa a siya tu hari ta Roma). Ey kaguman na ti Bernise. Binumisita side ni Gubernador Pesto. ");
INSERT INTO dgc_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Da nale side ta éya, éy kinagi ni Pesto diya i tungkul ni Pablo. “Te lélake ta éye,” kagi na, “a niwahak ni Pelik to pégpihesuan to nihektat na. ");
INSERT INTO dgc_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Ey sakén,” kagi ni Pesto, “to kébisita ko ta Jerusalem, éy nidimanda siya du Judeo diyakén, a gustu de éy parusaan ko siya. ");
INSERT INTO dgc_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Pero kinagi ko dide a sikame a taga Roma, éy éwan me ugali a parusaan i tolay éng éwan me pa bistaan. Ugali me, kagi ko, éy dapat mégbati pa tu pihesu du méngidimanda diya, monda makasengbet be siya ta katuwiran na. ");
INSERT INTO dgc_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Kanya, Agripa,” kagi ni Pesto, “éy inumange se du Judeo a méngidimanda diya. Ey to kagagabian no demét de, éy nipauwet ko tu pihesu, sakay nagharapan kame a binistaan ko siya. ");
INSERT INTO dgc_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Pero du Judeo, to péngabla de diya, éy neta ko a éwan bale siya tu kasalanan a labag ta batas tam! ");
INSERT INTO dgc_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Engˈwan i néngiablaan dia diya éy tungkul san ta rilihiyon de a sarili, sakay tu lélake a minate, a ti Jesus. Pero i iyépilit ni Pablo, éy buhay kan siya. ");
INSERT INTO dgc_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ey sakén, Agripa, éy éwan ko tukoy éng anya i gemtén ko ta éya a asuntu, da tungkul san ta ugali na Judeo. Kanya nipakelagip ko ni Pablo éng gustu na a umange ta Jerusalem a monda bistaan de sa siya. ");
INSERT INTO dgc_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Pero sala ni Pablo ta éya. Gustu na éy paangen ko siya ta Roma, a monda bistaan siya na hari tam ta éya. Kanya ipabantay ko siya nadid, hanggan éwan ko siya mapaange ta Roma.” ");
INSERT INTO dgc_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Nadid, kinagi ni Agripa ni Pesto, a “Eng maari, éy gustu ko a mabati maka i katuwiran na.” “Maari,” kagi ni Pesto. “Ta gabia éy mabati mo.” ");
INSERT INTO dgc_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Nadid, to kagagabian na, éy dinumemét de Hari Agripa sakay ti Bernise to munisipyo. Ey kaguman de du mataas a sundalu, sakay du tanyag a tolay ta banuwan. Ey ti Gubernador Pesto éy nipauwet na ti Pablo. ");
INSERT INTO dgc_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","“Hari Agripa,” kagi ni Pesto, “sakay sikam a mégiknud ta éye. Saye ti Pablo. Siya ye tu lélake a nagpitisyonan dén du étanan a Judeo, a dapat kan siya a mate. ");
INSERT INTO dgc_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Pero sakén, to péngsiyasat ko diya, éy éwanék tu meeta a kasalanan na a pamunuan diya. Ey nadid, da gustu na bistaan siya no hari tam ta Roma, éy gustu ko éy paa