﻿USE sofia;
DROP TABLE IF EXISTS sofia.deutkw_vpl;
CREATE TABLE deutkw_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES deutkw_vpl WRITE;
INSERT INTO deutkw_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Im Anfang schuf Gott den Himmel und die Erde. ");
INSERT INTO deutkw_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Es war aber die Erde wüste und leer und Finsternis lag auf dem Ozean und der Geist Gottes schwebte über dem Gewässer. ");
INSERT INTO deutkw_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Da sprach Gott: Es werde Licht! Und es ward Licht. ");
INSERT INTO deutkw_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Und Gott sah, daß das Licht gut war, und Gott trennte das Licht von der Finsternis. ");
INSERT INTO deutkw_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Und Gott nannte das Licht Tag, die Finsternis aber nannte er Nacht. Und es wurde Abend und wurde Morgen, der erste Tag. ");
INSERT INTO deutkw_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Da sprach Gott: Es werde ein Veste inmitten der Gewässer und bilde eine Scheidewand zwischen den verschiedenen Gewässern. Und es geschah so. ");
INSERT INTO deutkw_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Da machte Gott die Veste als eine Scheidewand zwischen den Gewässern unterhalb der Veste und den Gewässern oberhalb der Veste. ");
INSERT INTO deutkw_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Und Gott nannte die Veste Himmel. Und es wurde Abend und wurde Morgen, der zweite Tag. ");
INSERT INTO deutkw_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Da sprach Gott: Es sammle sich das Wasser unterhalb des Himmels an einen Ort, so daß das Trockene sichtbar wird. Und es geschah so. ");
INSERT INTO deutkw_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Und Gott nannte das Trockene Erde, die Ansammlung der Gewässer aber nannte er Meer. Und Gott sah, daß es gut war. ");
INSERT INTO deutkw_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Da sprach Gott: Die Erde lasse junges Grün sprossen, samentragende Pflanzen und Fruchtbäume, welche je nach ihrer Art Früchte auf Erden erzeugen, in denen sich Same zu ihnen befindet. Und es geschah so. ");
INSERT INTO deutkw_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Da ließ die Erde junges Grün aufgehen, samentragende Pflanzen je nach ihrer Art und Bäume, welche Früchte trugen, in denen sich Same zu ihnen befand, je nach ihrer Art. Und Gott sah, daß es gut war. ");
INSERT INTO deutkw_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Und es wurde Abend und wurde Morgen, der dritte Tag. ");
INSERT INTO deutkw_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Da sprach Gott: Es sollen Leuchten entstehen an der Veste des Himmels, um den Tag und die Nacht von einander zu trennen, und sie sollen dienen zu Merkzeichen und zur Bestimmung von Zeiträumen und Tagen und Jahren. ");
INSERT INTO deutkw_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Und sie sollen dienen als Leuchten an der Veste des Himmels, um die Erde zu beleuchten. Und es geschah so. ");
INSERT INTO deutkw_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Da machte Gott die beiden großen Leuchten: die große Leuchte, damit sie bei Tage die Herrschaft führe, und die kleine Leuchte, damit sie bei Nacht die Herrschaft führe, dazu die Sterne. ");
INSERT INTO deutkw_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Und Gott setzte sie an die Veste des Himmels, damit sie die Erde beleuchteten ");
INSERT INTO deutkw_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","und über den Tag und über die Nacht herrschten und das Licht und die Finsternis von einander trennten. Und Gott sah, daß es gut war. ");
INSERT INTO deutkw_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Und es wurde Abend und wurde Morgen, der vierte Tag. ");
INSERT INTO deutkw_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Da sprach Gott: Es wimmle das Wasser von Gewimmel lebendiger Wesen, und Vögel sollen über der Erde hinfliegen an der Veste des Himmels. ");
INSERT INTO deutkw_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Da schuf Gott die großen Seetiere und alle die lebenden Wesen, die sich herumtummeln, von denen das Wasser wimmelt, je nach ihrer Art, dazu alle geflügelten Tiere je nach ihrer Art. Und Gott sah, daß es gut war. ");
INSERT INTO deutkw_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Da segnete sie Gott und sprach: Seid fruchtbar und mehrt euch und bevölkert das Wasser im Meer, und auch die Vögel sollen sich mehren auf Erden. ");
INSERT INTO deutkw_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Und es wurde Abend und wurde Morgen, der fünfte Tag. ");
INSERT INTO deutkw_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Da sprach Gott: Die Erde bringe hervor lebendige Wesen je nach ihrer Art, Vieh und kriechende Tiere und wilde Tiere je nach ihrer Art. Und es geschah so. ");
INSERT INTO deutkw_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Da machte Gott die wilden Tiere je nach ihrer Art und das Vieh nach seiner Art und alle Tiere, die auf dem Boden kriechen, je nach ihrer Art. Und Gott sah, daß es gut war. ");
INSERT INTO deutkw_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Da sprach Gott: Laßt uns Menschen machen nach unserem Bilde, uns ähnlich, und sie sollen herrschen über die Fische im Meer und über die Vögel am Himmel und über das Vieh und über alle wilden Tiere und über alles Gewürm, das auf der Erde umherkriecht. ");
INSERT INTO deutkw_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Und Gott schuf den Menschen nach seinem Bilde - nach dem Bilde Gottes schuf er ihn; als Mann und Weib schuf er sie. ");
INSERT INTO deutkw_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Da segnete sie Gott, und Gott sprach zu ihnen: Seid fruchtbar und mehrt euch und bevölkert die Erde und macht sie euch unterthan und herrscht über die Fische im Meer und die Vögel am Himmel und über alles Getier, das sich auf Erden tummelt! ");
INSERT INTO deutkw_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Und Gott sprach: Hiermit weise ich euch alle samentragenden Pflanzen an, die allenthalben auf Erden wachsen, dazu alle Bäume mit samenhaltigen Früchten - das sei eure Nahrung! ");
INSERT INTO deutkw_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Dagegen allen Tieren auf der Erde und allen Vögeln am Himmel und allem, was auf Erden kriecht, was da beseelt ist, bestimme ich alles Gras und Kraut zur Nahrung. Und es geschah so. ");
INSERT INTO deutkw_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Und Gott sah, daß alles, was er gemacht, sehr gut sei. Und es wurde Abend und wurde Morgen, der sechste Tag. ");
INSERT INTO deutkw_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","So wurden vollendet der Himmel und die Erde mit ihrem ganzen Heer. ");
INSERT INTO deutkw_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Und Gott vollendete am siebenten Tage sein Werk, das er gemacht hatte, und ruhte am siebenten Tage von all seinem Werk, das er gemacht hatte. ");
INSERT INTO deutkw_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Und Gott segnete den siebenten Tag und erklärte ihn für heilig, weil er an ihm geruht hat von all seinem Werk, das er geschaffen und gemacht hatte. ");
INSERT INTO deutkw_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Das ist die Geschichte der Entstehung des Himmels und der Erde, als sie geschaffen wurden. Zur Zeit, als Jahwe Gott Erde und Himmel machte - ");
INSERT INTO deutkw_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","es gab aber auf Erden noch gar kein Gesträuch auf den Fluren und noch sproßten keine Pflanzen auf den Fluren; denn Jahwe Gott hatte noch nicht regnen lassen auf die Erde, und Menschen waren noch nicht da, um den Boden zu bebauen; ");
INSERT INTO deutkw_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","es stieg aber ein Nebel von der Erde auf und tränkte die ganze Oberfläche des Erdbodens - ");
INSERT INTO deutkw_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","da bildete Jahwe Gott den Menschen aus Erde vom Ackerboden und blies in seine Nase Lebensodem; so wurde der Mensch ein lebendiges Wesen. ");
INSERT INTO deutkw_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Hierauf pflanzte Jahwe Gott einen Garten in Eden im fernen Osten und setzte dorthin den Menschen, den er gebildet hatte. ");
INSERT INTO deutkw_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Und Jahwe Gott ließ allerlei Bäume aus dem Boden emporwachsen, die lieblich anzusehen und deren Früchte wohlschmeckend waren, und den Baum des Lebens mitten im Garten und den Baum der Erkenntnis des Guten und Bösen. ");
INSERT INTO deutkw_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Und ein Strom ging aus von Eden, den Garten zu bewässern; alsdann teilte er sich und zwar in vier Arme. ");
INSERT INTO deutkw_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Der erste heißt Pison; das ist der, welcher das ganze Land Havila umfließt, woselbst sich das Gold findet. ");
INSERT INTO deutkw_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Und das Gold dieses Landes ist vortrefflich; dort finden sich auch Bedolachharz und Schohamsteine. ");
INSERT INTO deutkw_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Und der zweite Strom heißt Gihon; das ist der, welcher das ganze Land Kusch umfließt. ");
INSERT INTO deutkw_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Und der dritte Strom heißt Hiddekel; das ist der, welcher auf der Vorderseite von Assur fließt; und der vierte Strom, das ist der Euphrat. ");
INSERT INTO deutkw_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Da nahm Jahwe Gott den Menschen und setzte ihn in den Garten Eden, ihn zu bebauen und zu bewachen. ");
INSERT INTO deutkw_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Und Jahwe Gott gebot dem Menschen und sprach: Von allen Bäumen des Gartens kannst du nach Belieben essen; ");
INSERT INTO deutkw_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","aber von dem Baum der Erkenntnis des Guten und Bösen - von dem darfst du nicht essen; denn sobald du von ihm issest, muß du sterben! ");
INSERT INTO deutkw_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Und Jahwe Gott sprach: Es ist nicht gut für den Menschen, daß er allein sei; ich will ihm einen Beistand schaffen, wie er für ihn paßt. ");
INSERT INTO deutkw_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Da bildete Jahwe Gott aus der Erde alle Tiere des Feldes und alle Vögel des Himmels und brachte sie zum Menschen, um zu sehen, wie er sie benennen würde; und ganz, wie der Mensch sie, die lebendigen Wesen, benennen würde, so sollten sie heißen. ");
INSERT INTO deutkw_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Da gab der Mensch allem Vieh und allen Vögeln des Himmels und allen Tieren des Feldes Namen; aber für einen Menschen fand er keinen Beistand, der für ihn gepaßt hätte. ");
INSERT INTO deutkw_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Da ließ Jahwe Gott einen tiefen Schlaf auf den Menschen fallen; und als er entschlafen war, nahm er eine von seinen Rippen und füllte ihre Stelle mit Fleisch aus. ");
INSERT INTO deutkw_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Alsdann gestaltete Jahwe Gott die Rippe, die er von dem Menschen genommen hatte, zu einem Weibe und brachte sie zu dem Menschen. ");
INSERT INTO deutkw_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Da sprach der Mensch: Diese endlich ist Gebein von meinem Gebein und Fleisch von meinem Fleisch; die soll Männin heißen, denn einem Mann ist sie entnommen! ");
INSERT INTO deutkw_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Darum verläßt einer seinen Vater und seine Mutter, um seinem Weibe anzuhangen, so daß sie zu einem Leibe werden. ");
INSERT INTO deutkw_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Und sie waren beide nackt, der Mensch und sein Weib, und schämten sich nicht vor einander. ");
INSERT INTO deutkw_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Die Schlange jedoch war listig, wie kein anderes unter den Tieren des Feldes, welche Jahwe Gott gemacht hatte, und sie sprach zu dem Weibe: Hat Gott wirklich gesagt: Ihr dürft von keinem der Bäume des Gartens essen? ");
INSERT INTO deutkw_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Da sprach das Weib zu der Schlange: Von den Früchten der Bäume des Gartens dürfen wir essen. ");
INSERT INTO deutkw_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Aber von den Früchten des Baums, der mitten im Garten steht, - von denen hat Gott gesagt, dürft ihr nicht essen und dürft sie nicht anrühren, sonst müßt ihr sterben! ");
INSERT INTO deutkw_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Da sprach die Schlange zum Weibe: Ihr werdet ganz gewiß nicht sterben; ");
INSERT INTO deutkw_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","sondern Gott weiß gar wohl: sobald ihr davon eßt, da werden euch die Augen aufgethan, daß ihr werdet, wie Gott, erkennend Gutes und Böses. ");
INSERT INTO deutkw_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Da nun das Weib sah, daß der Baum gut zum Essen und eine Lust für die Augen und daß der Baum begehrenswert sei, um durch ihn klug zu werden, da nahm sie von seinen Früchten und aß und gab auch ihrem Manne, der bei ihr war, und er aß. ");
INSERT INTO deutkw_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Da wurden ihrer beiden Augen aufgethan und sie wurden gewahr, daß sie nackt seien; da nähten sie Feigenblätter zusammen und machten sich Schürze. ");
INSERT INTO deutkw_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Als sie nun die Tritte Jahwes Gottes hörten, der in der Abendkühle im Garten wandelte, da suchte sich der Mensch mit seinem Weibe vor Jahwe Gott zu verstecken unter den Bäumen des Gartens. ");
INSERT INTO deutkw_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Da rief Jahwe Gott den Menschen an und sprach zu ihm: Wo bist du? ");
INSERT INTO deutkw_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Da sprach er: Ich hörte deine Tritte im Garten; da fürchtete ich mich, weil ich nackt bin, und versteckte mich. ");
INSERT INTO deutkw_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Da sprach er: Wer hat dir verraten, daß du nackt bist? Hast du von dem Baume, von dem zu essen ich dir verboten habe, doch gegessen? ");
INSERT INTO deutkw_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Da sprach der Mensch: Das Weib, das du mir beigesellt hast, die gab mir von dem Baume und ich aß. ");
INSERT INTO deutkw_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Da sprach Jahwe Gott zu dem Weibe: Was hast du gethan! Das Weib sprach: Die Schlange verführte mich, daß ich aß. ");
INSERT INTO deutkw_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Da sprach Jahwe Gott zur Schlange: Weil du solches gethan hast, sollst du verflucht sein unter allem Vieh und unter allen Tieren des Feldes: auf deinem Bauche sollst du kriechen und Erde fressen dein Leben lang! ");
INSERT INTO deutkw_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Und ich will Feindschaft setzen zwischen dir und dem Weibe und zwischen deinem Samen und ihrem Samen; er wird dir den Kopf zermalmen und du wirst ihm die Ferse zermalmen. ");
INSERT INTO deutkw_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Zum Weibe aber sprach er: Ich will dir viel Mühsal bereiten mit Schwangerschaften; mit Schmerzen sollst du Kinder gebären. Und nach deinem Manne wirst du verlangen, er aber soll Herr sein über dich! ");
INSERT INTO deutkw_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Und zum Menschen sprach er: Weil du der Stimme deines Weibes gehorcht und von dem Baume gegessen hast, von dem ich dir gebot und sprach: Du sollst nicht von ihm essen! so soll nun der Acker verflucht sein um deinetwillen; unter Mühsal sollst du dich von ihm nähren dein Leben lang. ");
INSERT INTO deutkw_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Dornen und Gestrüpp soll er dir tragen; und du sollst das Kraut des Feldes essen. ");
INSERT INTO deutkw_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Im Schweiße deines Angesichts sollst du dein Brod essen, bis du zum Erdboden zurückkehrst, denn ihm bist du entnommen. Denn Erde bist du und zu Erde mußt du wieder werden! ");
INSERT INTO deutkw_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Und der Mensch gab seinem Weibe den Namen Eva, denn sie wurde die Stammutter aller Lebendigen. ");
INSERT INTO deutkw_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Und Jahwe Gott machte dem Menschen und seinem Weibe Röcke von Fell und zog sie ihnen an. ");
INSERT INTO deutkw_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Und Jahwe Gott sprach: Fürwahr, der Mensch ist geworden wie unsereiner, indem er Gutes und Böses erkennt; daß er nunmehr nur nicht etwa seine Hand ausstreckt und auch von dem Baume des Lebens nimmt und ißt und ewiglich lebt! ");
INSERT INTO deutkw_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Da entfernte ihn Jahwe Gott aus dem Garten Eden, damit er den Boden bebaue, dem er entnommen war. ");
INSERT INTO deutkw_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Da trieb er den Menschen aus und ließ östlich vom Garten Eden die Kerube sich lagern und die Flamme des zuckenden Schwerts, um den Weg zum Baume des Lebens zu bewachen. ");
INSERT INTO deutkw_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Der Mensch aber wohnte seinem Weibe Eva bei; da wurde sie schwanger und gebar den Kain und sprach: Einen Menschen habe ich erhalten mit Hilfe Jahwes. ");
INSERT INTO deutkw_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Hierauf gebar sie abermals, den Abel, seinen Bruder; und Abel wurde ein Schafhirt, Kain aber ein Ackerbauer. ");
INSERT INTO deutkw_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Und nach Verlauf einiger Zeit brachte Kain Jahwe ein Opfer von den Früchten des Ackers; ");
INSERT INTO deutkw_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abel aber brachte gleichfalls Opfer von den Erstlingen seiner Herde und zwar von ihrem Fett. Und Jahwe schaute mit Wohlgefallen auf Abel und sein Opfer; ");
INSERT INTO deutkw_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","auf Kain aber und sein Opfer schaute er nicht. Da wurde Kain sehr ergrimmt und es senkte sich sein Antlitz. ");
INSERT INTO deutkw_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Da sprach Jahwe zu Kain: Warum bist du ergrimmt und warum senkt sich dein Antlitz? ");
INSERT INTO deutkw_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ist's nicht also: wenn du recht handelst, so kannst du dein Antlitz frei erheben; wenn du aber nicht recht handelst, so lauert die Sünde vor der Thür und nach dir geht ihr Verlangen, du aber sollst Herr werden über sie! ");
INSERT INTO deutkw_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Da sagte Kain zu seinem Bruder Abel: Laß uns aufs Feld gehen! und als sie auf dem Felde waren, da griff Kain seinen Bruder Abel an und schlug ihn tot. ");
INSERT INTO deutkw_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Da sprach Jahwe zu Kain: Wo ist dein Bruder Abel? Er aber sprach: ich weiß nicht; bin ich etwa der Hüter meines Bruders? ");
INSERT INTO deutkw_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Da sprach er: Was hast du gethan! Horch, das Blut deines Bruders schreit zu mir vom Erdboden her! ");
INSERT INTO deutkw_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Und nun - verflucht sollst du sein, fortgetrieben von dem Boden, der seinen Mund aufgethan hat, um das Blut deines Bruders von deiner Hand in Empfang zu nehmen. ");
INSERT INTO deutkw_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Wenn du den Boden bebaust, soll er dir keinen Ertrag mehr geben; unstät und flüchtig sollst du sein auf Erden! ");
INSERT INTO deutkw_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Da sprach Kain zu Jahwe: Unerträglich sind die Folgen meiner Verschuldung. ");
INSERT INTO deutkw_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Du treibst mich jetzt hinweg vom Ackerland, und vor deinem Angesicht muß ich mich verbergen und muß unstät und flüchtig sein auf Erden, und wer mich irgend antrifft, wird mich totschlagen. ");
INSERT INTO deutkw_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Da sprach Jahwe zu ihm: Ebendarum soll, wer Kain erschlägt, siebenfältiger Rache verfallen. ");
INSERT INTO deutkw_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Und Jahwe bestimmte ein Zeichen für Kain, damit ihn nicht erschlüge, wer ihn irgend träfe. Da zog Kain hinweg vom Angesicht Jahwes und nahm seinen Aufenthalt im Lande Nod östlich von Eden. ");
INSERT INTO deutkw_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Und Kain wohnte seinem Weibe bei; da wurde sie schwanger und gebar den Henoch. Er erbaute aber eine Stadt und benannte die Stadt nach dem Namen seines Sohnes Henoch. ");
INSERT INTO deutkw_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Dem Henoch aber wurde Irad geboren und Irad erzeugte den Mehujael und Mehujael erzeugte den Methusael und Methusael erzeugte den Lamech. ");
INSERT INTO deutkw_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamech aber nahm sich zwei Weiber; die eine hieß Ada, die andere Zilla. ");
INSERT INTO deutkw_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Und Ada gebar den Jabal; der wurde der Stammvater der Zeltbewohner und Viehzüchter. ");
INSERT INTO deutkw_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Sein Bruder aber hieß Jubal; dieser wurde der Stammvater aller derer, die sich mit Zither und Schalmei befassen. ");
INSERT INTO deutkw_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Und Zilla gebar ebenfalls, nämlich den Thubalkain, den Stammvater aller derer, die Erz und Eisen bearbeiten; die Schwester des Thubalkain aber war Naama. ");
INSERT INTO deutkw_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Da sprach Lamech zu seinen Weibern: Ada und Zilla, hört meine Rede; ihr Weiber Lamechs, vernehmt meinen Spruch! Einen Mann erschlage ich für meine Wunde und einen Jüngling für meine Strieme. ");
INSERT INTO deutkw_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Wird siebenfältig Kain gerächt, so Lamech siebenundsiebzigmal! ");
INSERT INTO deutkw_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Und Adam wohnte abermals seinem Weibe bei; da gebar sie einen Sohn und nannte ihn Seth. Denn Gott hat mir, sprach sie, andere Nachkommenschaft gesetzt an Stelle Abels, weil ihn Kain erschlagen hat. ");
INSERT INTO deutkw_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Und auch dem Seth wurde ein Sohn geboren, den nannte er Enos. Damals fing man an, den Namen Jahwes anzurufen. ");
INSERT INTO deutkw_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Dies ist das Buch über die Nachkommen Adams. Als Gott den Adam erschuf, da erschuf er ihn Gott ähnlich; ");
INSERT INTO deutkw_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","als Mann und Weib erschuf er sie und er segnete sie und gab ihnen den Namen “Mensch” damals, als sie geschaffen wurden. ");
INSERT INTO deutkw_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Als nun Adam 130 Jahre alt war, erzeugte er einen Sohn, der ihm glich als sein Abbild, und gab ihm den Namen Seth. ");
INSERT INTO deutkw_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Nach der Erzeugung des Seth aber lebte Adam noch 800 Jahre und erzeugte Söhne und Töchter. ");
INSERT INTO deutkw_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Und die ganze Lebensdauer Adams, die er durchlebte, betrug 930 Jahre; sodann starb er. ");
INSERT INTO deutkw_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Als nun Seth 105 Jahre alt war, erzeugte er den Enos. ");
INSERT INTO deutkw_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Nach der Erzeugung des Enos aber lebte Seth noch 807 Jahre und erzeugte Söhne und Töchter. ");
INSERT INTO deutkw_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Und die ganze Lebensdauer Seths betrug 912 Jahre; sodann starb er. ");
INSERT INTO deutkw_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Als nun Enos 90 Jahre alt war, erzeugte er den Kenan. ");
INSERT INTO deutkw_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Nach der Erzeugung Kenans aber lebte Enos noch 815 Jahre und erzeugte Söhne und Töchter. ");
INSERT INTO deutkw_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Und die ganze Lebensdauer des Enos betrug 905 Jahre; sodann starb er. ");
INSERT INTO deutkw_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Als nun Kenan 70 Jahre alt war, erzeugte er den Mahalalel. ");
INSERT INTO deutkw_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Nach der Erzeugung Mahalalels aber lebte Kenan noch 840 Jahre und erzeugte Söhne und Töchter. ");
INSERT INTO deutkw_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Und die ganze Lebensdauer Kenans betrug 910 Jahre; sodann starb er. ");
INSERT INTO deutkw_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Als nun Mahalalel 65 Jahre alt war, erzeugte er den Jared. ");
INSERT INTO deutkw_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Nach der Erzeugung Jareds aber lebte Mahalalel noch 830 Jahre und erzeugte Söhne und Töchter. ");
INSERT INTO deutkw_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Und die ganze Lebensdauer Mahalalels betrug 895 Jahre; sodann starb er. ");
INSERT INTO deutkw_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Als nun Jared 162 Jahre alt war, erzeugte er den Henoch. ");
INSERT INTO deutkw_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Nach der Erzeugung Henochs aber lebte Jared noch 800 Jahre und erzeugte Söhne und Töchter. ");
INSERT INTO deutkw_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Und die ganze Lebensdauer Jareds betrug 962 Jahre; sodann starb er. ");
INSERT INTO deutkw_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Als nun Henoch 65 Jahre alt war, erzeugte er den Methusalah. ");
INSERT INTO deutkw_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Nach der Erzeugung Methusalahs aber wandelte Henoch in Gemeinschaft mit Gott 300 Jahre und erzeugte Söhne und Töchter. ");
INSERT INTO deutkw_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Und die ganze Lebensdauer Henochs betrug 365 Jahre. ");
INSERT INTO deutkw_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Und weil Henoch in Gemeinschaft mit Gott gewandelt hatte, so verschwand er einst, denn Gott hatte ihn hinweggenommen. ");
INSERT INTO deutkw_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Als nun Methusalah 187 Jahre alt war, erzeugte er den Lamech. ");
INSERT INTO deutkw_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Nach der Erzeugung des Lamech aber lebte Methusalah noch 782 Jahre und erzeugte Söhne und Töchter. ");
INSERT INTO deutkw_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Und die ganze Lebensdauer Methusalahs betrug 969 Jahre; sodann starb er. ");
INSERT INTO deutkw_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Als nun Lamech 182 Jahre alt war, erzeugte er einen Sohn; ");
INSERT INTO deutkw_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","den hieß er Noah, indem er sprach: Dieser wird uns aufatmen lassen von unserer Arbeit und der Mühsal unserer Hände, die uns verursacht wird von dem Boden, den Jahwe verflucht hat! ");
INSERT INTO deutkw_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nach der Erzeugung Noahs aber lebte Lamech noch 595 Jahre und erzeugte Söhne und Töchter. ");
INSERT INTO deutkw_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Und die ganze Lebensdauer Lamechs betrug 777 Jahre; sodann starb er. ");
INSERT INTO deutkw_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Als nun Noah 500 Jahre alt war, erzeugte er den Sem, den Ham und den Japhet. ");
INSERT INTO deutkw_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Als nun die Menschen anfingen, sich zu vermehren auf der Erde, und ihnen Töchter geboren wurden, ");
INSERT INTO deutkw_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","da sahen die Gottessöhne, daß die Töchter der Menschen gar schön waren, und nahmen sich zu Weibern, welche ihnen irgend gefielen. ");
INSERT INTO deutkw_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Da sprach Jahwe: Mein Geist soll nicht ewig im Menschen walten, denn auch er ist Fleisch, und seine Lebensdauer betrage 120 Jahre! ");
INSERT INTO deutkw_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Zu jener Zeit waren die Riesen auf Erden; und auch nach der Zeit, wo sich die Gottessöhne zu den Töchtern der Menschen gesellten, und diese ihnen gebaren - das sind die Recken, die in grauer Vorzeit waren, die Hochgefeierten. ");
INSERT INTO deutkw_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Als nun Jahwe sah, daß die Bosheit der Menschen groß ward auf Erden und alles Dichten und Trachten ihres Herzens allezeit nur böse war, ");
INSERT INTO deutkw_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","da bereute Jahwe, daß er die Menschen geschaffen hatte auf Erden, und war tief bekümmert. ");
INSERT INTO deutkw_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Da sprach Jahwe: Ich will die Menschen, die ich geschaffen habe, hinwegtilgen von der Erde, sowohl die Menschen, als das Vieh, das Gewürm und die Vögel des Himmels; denn es reut mich, daß ich sie geschaffen habe. ");
INSERT INTO deutkw_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Noah aber hatte Gnade bei Jahwe gefunden. ");
INSERT INTO deutkw_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Dies ist die Geschichte Noahs. Noah war ein frommer, unsträflicher Mann unter seinen Zeitgenossen; in Gemeinschaft mit Gott wandelte Noah. ");
INSERT INTO deutkw_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Und Noah erzeugte drei Söhne: Sem, Ham und Japhet. ");
INSERT INTO deutkw_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Die Erde aber war verderbt vor dem Angesichte Gottes, und die Erde wurde voll von Frevel. ");
INSERT INTO deutkw_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Da sah Gott, daß die Erde arg verderbt war; denn alles Fleisch hatte seinen Wandel verderbt auf Erden. ");
INSERT INTO deutkw_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Da sprach Gott zu Noah: Das Ende alles Fleisches ist bei mir beschlossen, denn voll ist die Erde von Frevel, den sie verüben; so will ich sie nun von der Erde vertilgen. ");
INSERT INTO deutkw_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Baue dir einen Kasten aus Gopherholz; mit lauter Zellen mußt du den Kasten erbauen und ihn inwendig und auswendig mit Harz verpichen. ");
INSERT INTO deutkw_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Und also sollst du ihn bauen: 300 Ellen betrage die Länge des Kastens, 50 Ellen seine Breite und 30 Ellen seine Höhe. ");
INSERT INTO deutkw_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ein Fenster sollst du oben an dem Kasten machen; eine Elle weit sollst du es herstellen. Und den Eingang zu dem Kasten sollst du an seiner Seite anbringen; in drei Stockwerken mit lauter Zellen sollst du ihn erbauen. ");
INSERT INTO deutkw_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Denn ich werde alsbald die Flut über die Erde kommen lassen, um alles Fleisch unter dem Himmel, das lebendigen Odem in sich hat, zu vertilgen; alles, was auf Erden ist, soll umkommen. ");
INSERT INTO deutkw_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Aber mit dir will ich einen Bund aufrichten, und du sollst in den Kasten eingehen - du und deine Söhne und dein Weib und die Weiber deiner Söhne mit dir. ");
INSERT INTO deutkw_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Und von allem Lebendigen, von allem Fleische, sollst du je zwei von allen mit hineinnehmen in den Kasten, um sie samt dir am Leben zu erhalten; je ein Männchen und ein Weibchen soll es sein. ");
INSERT INTO deutkw_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Von den Vögeln je nach ihrer Art, von dem Vieh je nach seiner Art, und von allem, was auf der Erde kriecht, je nach seiner Art sollen immer je zwei zu dir in den Kasten eingehen, damit sie am Leben bleiben. ");
INSERT INTO deutkw_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Du aber beschaffe dir von jeder Art Speise, die genossen zu werden pflegt, und speichere sie bei dir auf, damit sie dir und ihnen zur Nahrung diene. ");
INSERT INTO deutkw_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Da that Noah ganz, wie ihm Gott geheißen hatte - so that er. ");
INSERT INTO deutkw_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Da sprach Jahwe zu Noah: Gehe du und dein ganzes Haus hinein in den Kasten; denn dich habe ich rechtschaffen vor mir erfunden in diesem Geschlecht. ");
INSERT INTO deutkw_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Von allen reinen Tieren nimm dir je sieben, je ein Männchen und sein Weibchen; aber von den Tieren, die nicht rein sind, je zwei, ein Männchen und sein Weibchen. ");
INSERT INTO deutkw_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Auch von den Vögeln unter dem Himmel je sieben, ein Männchen und ein Weibchen, um auf der ganzen Erde Samen am Leben zu erhalten. ");
INSERT INTO deutkw_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Denn in noch sieben Tagen will ich regnen lassen auf die Erde vierzig Tage und vierzig Nächte lang und will alles Bestehende, das ich gemacht habe, wegtilgen von der Erde. ");
INSERT INTO deutkw_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Da that Noah ganz, wie ihm Jahwe geheißen hatte. ");
INSERT INTO deutkw_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Und Noah war 600 Jahre alt, als die Flut über die Erde kam. ");
INSERT INTO deutkw_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Da ging Noah und seine Söhne und sein Weib und die Weiber seiner Söhne mit ihm hinein in den Kasten vor den Gewässern der Flut. ");
INSERT INTO deutkw_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Von den reinen Tieren und von den Tieren, die nicht rein sind, und von den Vögeln und von allem, was auf dem Boden kriecht, ");
INSERT INTO deutkw_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","gingen je zwei zu Noah in den Kasten, ein Männchen und ein Weibchen, wie Gott Noah geboten hatte. ");
INSERT INTO deutkw_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Und nach Ablauf der sieben Tage, da kamen die Gewässer der Flut über die Erde. ");
INSERT INTO deutkw_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Im sechshundertsten Lebensjahre Noahs, im zweiten Monat, am siebzehnten Tage des Monats, an diesem Tage brachen auf alle Sprudel der großen Meerestiefe, und die Gitter des Himmels thaten sich auf. ");
INSERT INTO deutkw_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Da strömte der Regen auf die Erde, vierzig Tage und vierzig Nächte lang. ");
INSERT INTO deutkw_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","An eben diesem Tage gingen Noah und Sem und Ham und Japhet, die Söhne Noahs, und das Weib Noahs und die drei Weiber seiner Söhne mit ihnen hinein in den Kasten, ");
INSERT INTO deutkw_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","sie und alle wilden Tiere nach ihrer Art und alles Vieh nach seiner Art und alles Gewürm, das auf der Erde kriecht, nach seiner Art und alle Vögel nach ihrer Art, was irgend Flügel hatte. ");
INSERT INTO deutkw_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Die gingen hinein zu Noah in den Kasten, je zwei und zwei von allem Fleisch, das lebendigen Odem in sich hatte. ");
INSERT INTO deutkw_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Und die hineingingen, waren je ein Männchen und ein Weibchen von allem Fleisch, wie ihm Gott geheißen hatte. Und Jahwe schloß hinter ihm zu. ");
INSERT INTO deutkw_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Da kam die Flut vierzig Tage über die Erde, und das Wasser wuchs und hob den Kasten empor, so daß er über der Erde schwebte. ");
INSERT INTO deutkw_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Und die Gewässer nahmen überhand und wuchsen gewaltig auf der Erde; da fuhr der Kasten dahin auf dem Wasser. ");
INSERT INTO deutkw_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Und die Gewässer nahmen über alle Maßen überhand auf der Erde, so daß alle die hohen Berge, die irgend unter dem Himmel sind, überschwemmt wurden. ");
INSERT INTO deutkw_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Fünfzehn Ellen hoch stiegen die Gewässer, so daß die Berge überschwemmt wurden. ");
INSERT INTO deutkw_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Da kam um alles Fleisch, das sich auf der Erde regte, an Vögeln und an Vieh und an wilden Tieren, und alles Gewürm, das auf Erden kroch, und alle Menschen. ");
INSERT INTO deutkw_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Alles, was Lebensodem in seiner Nase trug, soweit es auf dem Trockenen war, das starb. ");
INSERT INTO deutkw_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","So vertilgte er alles Bestehende, was auf dem Erdboden war, sowohl Menschen als Vieh und Gewürm und die Vögel unter dem Himmel; und sie wurden vertilgt von der Erde, so daß nur Noah übrig blieb und was bei ihm im Kasten war. ");
INSERT INTO deutkw_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Und die Gewässer nahmen überhand auf Erden hundertundfünfzig Tage lang. ");
INSERT INTO deutkw_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Da gedachte Gott an Noah und an alle die wilden Tiere und an all das Vieh, welches bei ihm im Kasten war, und Gott ließ Wind über die Erde wehen, so daß die Gewässer fielen. ");
INSERT INTO deutkw_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Da schlossen sich die Sprudel der Meerestiefe und die Gitter des Himmels, und dem Regen vom Himmel wurde Einhalt gethan. ");
INSERT INTO deutkw_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Da verliefen sich die Gewässer immer mehr von der Erde und die Gewässer nahmen ab nach Verlauf der hundertundfünfzig Tage. ");
INSERT INTO deutkw_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Und im siebenten Monat, am siebzehnten Tage des Monats, ließ sich der Kasten nieder auf einem der Berge Ararats. ");
INSERT INTO deutkw_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Und die Gewässer nahmen immer weiter ab bis zum zehnten Monat; im zehnten Monat, am ersten des Monats, wurden die Gipfel der Berge sichtbar. ");
INSERT INTO deutkw_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Nach Verlauf von vierzig Tagen aber öffnete Noah das Fenster des Kastens, das er gemacht hatte, ");
INSERT INTO deutkw_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","und schickte den Raben aus; der flog hin und wieder, bis das Wasser auf Erden vertrocknete. ");
INSERT INTO deutkw_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Hierauf ließ er die Taube von sich ausfliegen, um zu erfahren, ob sich die Gewässer von der Erde verlaufen hätten. ");
INSERT INTO deutkw_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Aber die Taube fand keinen Ort, wo ihr Fuß ruhen konnte; da kehrte sie zu ihm in den Kasten zurück, denn noch war Gewässer auf dem ganzen Erdboden; und er streckte seine Hand aus und holte sie zu sich herein in den Kasten. ");
INSERT INTO deutkw_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Hierauf wartete er noch weitere sieben Tage, dann ließ er abermals die Taube aus dem Kasten ausfliegen. ");
INSERT INTO deutkw_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Da kam die Taube zur Abendzeit zu ihm und zwar mit einem frischen Ölblatt im Schnabel. Da erkannte Noah, daß sich die Gewässer von der Erde verlaufen hatten. ");
INSERT INTO deutkw_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Hierauf wartete er noch weitere sieben Tage und ließ die Taube ausfliegen; diesmal aber kehrte sie nicht wieder zu ihm zurück. ");
INSERT INTO deutkw_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Und im sechshundertersten Jahre, am ersten Tage des ersten Monats, waren die Gewässer auf Erden versiegt. Da entfernte Noah das Dach des Kastens und schaute aus: da war der Erdboden trocken geworden. ");
INSERT INTO deutkw_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Und im zweiten Monat, am siebenundzwanzigsten Tage des Monats, war die Erde ganz trocken. ");
INSERT INTO deutkw_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Da redete Gott zu Noah und sprach: ");
INSERT INTO deutkw_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Gehe heraus aus dem Kasten, du und dein Weib und deine Söhne und die Weiber deiner Söhne mit dir. ");
INSERT INTO deutkw_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Alle Tiere, welche bei dir sind, von allem Fleisch, an Vögeln und Vieh und an allem Gewürm, das auf der Erde kriecht, laß mit dir herausgehn, damit sie sich auf der Erde tummeln und fruchtbar seien und sich vermehren auf der Erde. ");
INSERT INTO deutkw_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Da ging Noah heraus und seine Söhne und sein Weib und die Weiber seiner Söhne mit ihm. ");
INSERT INTO deutkw_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Alle vierfüßigen Tiere, alles Gewürm und alle Vögel, alles was sich auf Erden regt, nach ihren verschiedenen Arten, gingen heraus aus dem Kasten. ");
INSERT INTO deutkw_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Da erbaute Noah Jahwe einen Altar und nahm von allen reinen Tieren und von allen reinen Vögeln und brachte Brandopfer dar auf dem Altar. ");
INSERT INTO deutkw_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Als nun Jahwe den lieblichen Duft roch, da sprach er bei sich selbst: Ich will hinfort die Erde nicht mehr verfluchen um der Menschen willen. Denn das Dichten des menschlichen Herzens ist böse von Jugend auf; und ich will hinfort nicht mehr alles Lebendige schlagen, wie ich gethan habe. ");
INSERT INTO deutkw_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Fortan sollen, so lange die Erde steht, nicht aufhören Säen und Ernten, Frost und Hitze, Sommer und Winter und Tag und Nacht. ");
INSERT INTO deutkw_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Da segnete Gott Noah und seine Söhne und sprach zu ihnen: Seid fruchtbar und mehrt euch und bevölkert die Erde! ");
INSERT INTO deutkw_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Und Furcht und Schrecken vor euch soll kommen über alle Tiere auf Erden und über alle Vögel unter dem Himmel, über alles, was sich auf Erden regt, und über alle Fische des Meeres: in eure Gewalt sind sie gegeben! ");
INSERT INTO deutkw_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Alles, was sich regt und lebt, soll euch zur Nahrung dienen: wie das grüne Kraut gebe ich es euch alles. ");
INSERT INTO deutkw_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Nur Fleisch, das noch sein Leben, sein Blut in sich hat, dürft ihr nicht essen. ");
INSERT INTO deutkw_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Euer eignes Blut aber will ich rächen; an jedem Tiere will ich es rächen und an einem jeden Menschen, als der sein Bruder ist, will ich das Leben des Menschen rächen. ");
INSERT INTO deutkw_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Wer Menschenblut vergießt, des Blut soll auch durch Menschen vergossen werden; denn nach seinem Bilde hat Gott den Menschen gemacht. ");
INSERT INTO deutkw_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ihr aber seid fruchtbar und mehrt euch; regt euch auf der Erde und mehr euch auf ihr! ");
INSERT INTO deutkw_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Da sprach Gott zu Noah und zu seinen Söhnen, die bei ihm waren, also: ");
INSERT INTO deutkw_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Siehe, ich errichte einen Bund mit euch und mit euren Nachkommen ");
INSERT INTO deutkw_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","und mit allen lebendigen Wesen, die bei euch sind, an Vögeln, an Vieh und an allen wilden Tieren, die bei euch sind, was irgend von den Tieren auf Erden aus dem Kasten herausgegangen ist. ");
INSERT INTO deutkw_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Und zwar will ich meinen Bund mit euch aufrichten, daß hinfort kein Geschöpf mehr hinweggetilgt werden soll durch die Wasser der Flut, und daß hinfort keine Flut mehr kommen soll, die Erde zu verheeren. ");
INSERT INTO deutkw_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Und Gott sprach: Dies sei das Zeichen des Bundes, den ich stifte zwischen mir und euch und allen lebendigen Wesen, die bei euch sind, auf alle kommenden Geschlechter: ");
INSERT INTO deutkw_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Meinen Bogen stelle ich in die Wolken, damit er als ein Zeichen des Bundes zwischen mir und der Erde diene. ");
INSERT INTO deutkw_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Und wenn ich je Wolken über der Erde anhäufe, und der Bogen in den Wolken erscheint, ");
INSERT INTO deutkw_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","so will ich an den Bund denken, der zwischen mir und euch und allen lebendigen Wesen unter allem Fleische besteht, daß die Gewässer nicht wieder zu einer Flut werden sollen, alles Fleisch zu verderben. ");
INSERT INTO deutkw_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Und wenn der Bogen in den Wolken steht, will ich ihn ansehen, um eingedenk zu werden des ewigen Bundes zwischen Gott und allen lebendigen Wesen unter allem Fleisch, das auf Erden ist. ");
INSERT INTO deutkw_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Und Gott sprach zu Noah: Dies sei das Zeichen des Bundes, den ich aufgerichtet habe zwischen mir und allem Fleisch, das auf Erden ist. ");
INSERT INTO deutkw_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Es waren aber die Söhne Noahs, die aus dem Kasten gingen, Sem und Ham und Japhet; Ham aber ist der Vater Kanaans. ");
INSERT INTO deutkw_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Das sind die drei Söhne Noahs, und von ihnen aus verzweigte sich die gesamte Bevölkerung der Erde. ");
INSERT INTO deutkw_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Und Noah, der Landmann, fing an, einen Weinberg zu pflanzen. ");
INSERT INTO deutkw_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Als er aber von dem Weine trank, wurde er trunken und lag entblößt in seinem Zelte. ");
INSERT INTO deutkw_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Als nun Ham, der Vater Kanaans, seinen Vater so entblößt sah, sagte er es seinen beiden Brüdern draußen. ");
INSERT INTO deutkw_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Da nahmen Sem und Japhet das Obergewand, legten es auf ihre Schulter und deckten rückwärts gehend die Blöße ihres Vaters zu; ihr Gesicht aber war abgewandt, so daß sie die Blöße ihres Vater nicht sahen. ");
INSERT INTO deutkw_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Als aber Noah von seinem Rausche erwachte und erfuhr, was ihm sein jüngster Sohn angethan hatte, ");
INSERT INTO deutkw_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","da sprach er: Verflucht sei Kanaan! als niedrigster Sklave soll er seinen Brüdern dienen! ");
INSERT INTO deutkw_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Dann sprach er Gepriesen sei Jahwe der Gott Sems; aber Kanaan soll ihr Sklave sein! ");
INSERT INTO deutkw_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Weiten Raum schaffe Gott für Japhet, und er wohne in den Zelten Sems; aber Kanaan soll ihr Sklave sein! ");
INSERT INTO deutkw_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Und Noah lebte nach der Flut 350 Jahre; ");
INSERT INTO deutkw_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","und die ganze Lebensdauer Noahs betrug 950 Jahre; sodann starb er. ");
INSERT INTO deutkw_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Und dies ist die Geschichte der Söhne Noahs, Sem, Ham und Japhet; und es wurden ihnen Söhne geboren nach der Flut. ");
INSERT INTO deutkw_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Die Söhne Japhets waren: Gomer, Magog, Madai, Javan, Tubal, Mesech und Tiras. ");
INSERT INTO deutkw_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Und die Söhne Gomers: Askenas, Riphath und Togarma. ");
INSERT INTO deutkw_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Und die Söhne Javans: Elisa, Tarsis, die Kittiter und die Rodaniter. ");
INSERT INTO deutkw_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Von diesen zweigten sich ab die Bewohner der Inseln der Heiden. Dies sind die Söhne Japhets nach ihren Ländern, ihren verschiedenen Sprachen, ihren Stämmen, ihren Völkerschaften. ");
INSERT INTO deutkw_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Und die Söhne Hams waren Kusch, Mizraim, Put und Kanaan. ");
INSERT INTO deutkw_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Und die Söhne Kuschs: Seba, Havila, Sabta, Raema und Sabtecha; und die Söhne Raemas waren Saba und Dedan. ");
INSERT INTO deutkw_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Und Kusch erzeugte den Nimrod; dieser fing an, ein Gewaltiger zu werden auf der Erde. ");
INSERT INTO deutkw_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Dieser war ein gewaltiger Jäger vor Jahwe; daher pflegt man zu sagen: ein gewaltiger Jäger vor Jahwe, wie Nimrod! ");
INSERT INTO deutkw_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Es erstreckte sich aber seine Herrschaft anfänglich auf Babel und Erech und Akkad und Kalne im Lande Sinear. ");
INSERT INTO deutkw_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Von diesem Lande zog er aus nach Assur und erbaute Nineve und Rehoboth-Ir und Kalah ");
INSERT INTO deutkw_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","und Resen zwischen Nineve und Kalah - das ist die große Stadt. ");
INSERT INTO deutkw_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Und Mizraim erzeugte die Luditer, die Anamiter, die Lehabiter, die Naphtuhiter, ");
INSERT INTO deutkw_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","die Patrusiter, die Kasluhiter (von denen die Philister ausgegangen sind) und die Kaphtoriter. ");
INSERT INTO deutkw_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaan aber erzeugte Sidon, seinen Erstgebornen, und Heth ");
INSERT INTO deutkw_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","und die Jebusiter, Amoriter, Girgasiter, ");
INSERT INTO deutkw_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Heviter, Arkiter, Siniter, ");
INSERT INTO deutkw_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arvaditer, Zemariter und Hamathiter; und darnach breiteten sich die Stämme der Kanaaniter aus. ");
INSERT INTO deutkw_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Und das Gebiet der Kanaaniter erstreckte sich von Zidon bis hin nach Gerar bis Gaza, bis hin nach Sodom, Gomorra, Adma und Zeboim bis Lasa. ");
INSERT INTO deutkw_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Dies sind die Söhne Hams nach ihren Stämmen und Sprachen, ihren Ländern und Völkerschaften. ");
INSERT INTO deutkw_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Aber auch Sem, dem Stammvater aller Söhne Ebers, dem älteren Bruder Japhets, wurden Söhne geboren. ");
INSERT INTO deutkw_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Die Söhne Sems sind Elam, Assur, Arpachsad, Lud und Aram. ");
INSERT INTO deutkw_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Und die Söhne Arams sind Uz, Hul, Gether und Mas. ");
INSERT INTO deutkw_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpachsad aber erzeugte Selah und Selah erzeugte Eber. ");
INSERT INTO deutkw_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Und dem Eber wurden zwei Söhne geboren; der eine hieß Peleg, weil sich zu seiner Zeit die Bevölkerung der Erde zerteilte, und sein Bruder hieß Joktan. ");
INSERT INTO deutkw_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Und Joktan erzeugte Almodad, Saleph, Hazarmaveth, Jarah, ");
INSERT INTO deutkw_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Usal, Dikla, ");
INSERT INTO deutkw_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Saba, ");
INSERT INTO deutkw_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ophir, Havila und Jobab: diese alle sind Söhne Joktans. ");
INSERT INTO deutkw_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Und ihre Wohnsitze erstreckten sich von Mesa bis gen Sephar, bis zum Ostgebirge. ");
INSERT INTO deutkw_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Das sind die Söhne Sems nach ihren Stämmen und Sprachen, ihren Ländern und Völkerschaften. ");
INSERT INTO deutkw_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Das sind die Stämme der Söhne Noahs nach ihren Sippschaften, ihren Völkern; und von ihnen zweigten sich ab die Völker auf Erden nach der Flut. ");
INSERT INTO deutkw_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Es hatte aber die ganze Menschheit eine Sprache und einerlei Worte. ");
INSERT INTO deutkw_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Als sie nun im Osten umherzogen, fanden sie eine Ebene im Lande Sinear und ließen sich daselbst nieder. ");
INSERT INTO deutkw_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Und sie sprachen zu einander: Wohlan, laßt uns Ziegel streichen und hart brennen! So diente ihnen der Ziegel als Baustein, und das Erdharz diente ihnen als Mörtel. ");
INSERT INTO deutkw_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Da sprachen sie: Wohlan, wir wollen uns eine Stadt bauen und einen Turm, dessen Spitze bis an den Himmel reicht, und wollen uns ein Denkmal machen, damit wir uns nicht über die ganze Erde hin zerstreuen. ");
INSERT INTO deutkw_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Da stieg Jahwe herab, um die Stadt und den Turm, den die Menschenkinder erbaut hatten, zu besehen. ");
INSERT INTO deutkw_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Und Jahwe sprach: Ein Volk sind sie und haben alle dieselbe Sprache, und das ist nur der Anfang ihres Thuns, und fortan wird ihnen nichts unerreichbar sein, was sie sich vornehmen werden. ");
INSERT INTO deutkw_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Wohlan, wir wollen hinabfahren und daselbst ihre Sprache verwirren, so daß keiner mehr die Sprache des andern verstehen soll! ");
INSERT INTO deutkw_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","So zerstreute sie Jahwe von dort über die ganze Erde, so daß sie davon abstehen mußten, die Stadt zu erbauen. ");
INSERT INTO deutkw_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Darum nennt man sie Babel, weil Jahwe dort die Sprache der ganzen Menschheit verwirrte und Jahwe sie von dort über die ganze Erde zerstreute. ");
INSERT INTO deutkw_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Dies ist die Geschichte Sems. Als Sem hundert Jahre alt war, erzeugte er Arpachsad, zwei Jahre nach der Flut. ");
INSERT INTO deutkw_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Nach der Erzeugung Arpachsads aber lebte Sem noch 500 Jahre und erzeugte Söhne und Töchter. ");
INSERT INTO deutkw_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Als nun Arpachsad 35 Jahre alt war, erzeugte er Selah. ");
INSERT INTO deutkw_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Nach der Erzeugung Selahs aber lebte Arpachsad noch 403 Jahre und erzeugte Söhne und Töchter. ");
INSERT INTO deutkw_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Als nun Selah 30 Jahre alt war, erzeugte er Eber. ");
INSERT INTO deutkw_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Nach der Erzeugung Ebers aber lebte Selah noch 403 Jahre und erzeugte Söhne und Töchter. ");
INSERT INTO deutkw_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Als nun Eber 34 Jahre alt war, erzeugte er Peleg. ");
INSERT INTO deutkw_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Nach der Erzeugung Pelegs aber lebte Eber noch 430 Jahre und erzeugte Söhne und Töchter. ");
INSERT INTO deutkw_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Als nun Peleg 30 Jahre alt war, erzeugte er Reu. ");
INSERT INTO deutkw_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Nach der Erzeugung Reus aber lebte Peleg noch 209 Jahre und erzeugte Söhne und Töchter. ");
INSERT INTO deutkw_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Als nun Reu 32 Jahre alt war, erzeugte er Serug. ");
INSERT INTO deutkw_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Nach der Erzeugung Serugs aber lebte Reu noch 207 Jahre und erzeugte Söhne und Töchter. ");
INSERT INTO deutkw_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Als nun Serug 30 Jahre alt war, erzeugte er Nahor. ");
INSERT INTO deutkw_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Nach der Erzeugung Nahors aber lebte Serug noch 200 Jahre und erzeugte Söhne und Töchter. ");
INSERT INTO deutkw_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Als nun Nahor 29 Jahre alt war, erzeugte er Tharah. ");
INSERT INTO deutkw_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nach der Erzeugung Tharahs aber lebte Nahor noch 119 Jahre und erzeugte Söhne und Töchter. ");
INSERT INTO deutkw_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Als nun Tharah 70 Jahre alt war, erzeugte er Abram, Nahor und Haran. ");
INSERT INTO deutkw_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Und dies ist die Geschichte Tharahs: Tharah erzeugte Abram, Nahor und Haran; Haran aber erzeugte Lot. ");
INSERT INTO deutkw_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Es starb jedoch Haran vor seinem Vater Tharah in seinem Geburtslande, zu Ur in Chaldäa. ");
INSERT INTO deutkw_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Da nahmen sich Abram und Nahor Weiber; das Weib Abrams hieß Sarai und das Weib Nahors Milka, die Tochter Harans, des Vaters der Milka und der Jiska. ");
INSERT INTO deutkw_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai aber war unfruchtbar; sie hatte kein Kind. ");
INSERT INTO deutkw_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Da nahm Tharah seinen Sohn Abram und Lot, den Sohn seines Sohnes Haran, und seine Schwiegertochter Sarai, das Weib seines Sohnes Abram, und führte sie aus Ur in Chaldäa hinweg, um in das Land Kanaan zu ziehen; und sie gelangten bis Haran und ließen sich daselbst nieder. ");
INSERT INTO deutkw_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Es betrug aber die Lebensdauer Tharahs 205 Jahre; sodann starb Tharah in Haran. ");
INSERT INTO deutkw_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Da sprach Jahwe zu Abram: Ziehe hinweg aus deinem Lande, von deiner Verwandtschaft und aus deines Vaters Hause in das Land, das ich dir zeigen werde. ");
INSERT INTO deutkw_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Und ich will dich zu einem großen Volke machen und will dich segnen und dir einen großen Namen machen, und sollst ein Segen sein! ");
INSERT INTO deutkw_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Und ich will segnen, die dich segnen, und den, der dich verwünscht, will ich verfluchen, und durch dich sollen gesegnet werden alle Völkerstämme auf Erden! ");
INSERT INTO deutkw_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Da zog Abram hinweg, wie Jahwe zu ihm gesagt hatte, und Lot zog mit ihm. Abram aber war 75 Jahre alt, als er von Haran auszog. ");
INSERT INTO deutkw_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Da nahm Abram sein Weib Sarai und Lot, seines Bruders Sohn, und alle ihre Habe, die sie besaßen, und die Seelen, die sie in Haran erworben hatten, und sie zogen aus, um sich ins Land Kanaan zu begeben, und gelangten ins Land Kanaan. ");
INSERT INTO deutkw_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Und Abram durchzog das Land bis zu der Stätte von Sichem, bis zur Orakel-Terebinthe; es waren aber damals die Kanaaniter im Lande. ");
INSERT INTO deutkw_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Da erschien Jahwe dem Abram und sprach zu ihm: Deinen Nachkommen will ich dieses Land verleihen! Da erbaute er dort Jahwe, der ihm erschienen war, einen Altar. ");
INSERT INTO deutkw_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Von da rückte er weiter vor aufs Gebirge, östlich von Bethel, und schlug sein Zelt auf, so daß er Bethel westlich und Ai östlich hatte; und er erbaute daselbst Jahwe einen Altar und rief den Namen Jahwes an. ");
INSERT INTO deutkw_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Hierauf zog Abram immer weiter und weiter nach dem Südland zu. ");
INSERT INTO deutkw_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Es kam aber eine Hungersnot ins Land. Da zog Abram hinab nach Ägypten, um sich eine Zeit lang dort aufzuhalten, denn die Hungersnot lag schwer auf dem Lande. ");
INSERT INTO deutkw_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Als er nun nahe daran war, nach Ägypten zu gelangen, sprach er zu seinem Weibe Sarai: Ich weiß gar wohl, daß du ein schönes Weib bist. ");
INSERT INTO deutkw_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Wenn dich nun die Ägypter erblicken werden, werden sie sagen: Sie ist sein Weib! und werden mich totschlagen, dich aber werden sie am Leben lassen. ");
INSERT INTO deutkw_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Bitte, sage doch, du seist meine Schwester, damit es mir wohl gehe um deinetwillen, und ich deinetwegen ungefährdet bleibe! ");
INSERT INTO deutkw_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Als nun Abram nach Ägypten gelangt war, da sahen die Ägypter, daß das Weib überaus schön war. ");
INSERT INTO deutkw_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Und als die obersten Beamten des Pharao sie zu Gesicht bekommen hatten, rühmten sie sie gegen den Pharao; da wurde das Weib in den Palast des Pharao geholt. ");
INSERT INTO deutkw_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Gegen Abram aber erzeigte er sich freigebig um ihretwillen, und es wurden ihm Schafe und Rinder und Esel, Sklaven und Sklavinnen, Eselinnen und Kamele zu teil. ");
INSERT INTO deutkw_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Jahwe aber schlug den Pharao mit schweren Plagen und sein Haus wegen Sarai, des Weibes Abrams. ");
INSERT INTO deutkw_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Da ließ der Pharao Abram rufen und sprach: Was hast du mir da angethan! Warum sagtest du mir nicht, daß sie dein Weib ist? ");
INSERT INTO deutkw_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Warum hast du behauptet: sie ist meine Schwester, so daß ich sie mir zum Weibe nahm? nun aber - hier hast du dein Weib; nimm sie und geh! ");
INSERT INTO deutkw_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Und der Pharao entbot seinetwegen Leute, daß sie ihn und sein Weib und alles, was ihm gehörte, geleiteten. ");
INSERT INTO deutkw_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Und Abram zog herauf aus Ägypten mit seinem Weibe und allem, was ihm gehörte, und Lot mit ihm, in das Südland. ");
INSERT INTO deutkw_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram aber war sehr reich an Vieh, an Silber und an Gold. ");
INSERT INTO deutkw_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Und er zog immer weiter und weiter aus dem Südland bis nach Bethel, bis zu der Stelle, wo vordem sein Zelt gestanden hatte, zwischen Bethel und Ai, ");
INSERT INTO deutkw_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","zu der Stätte des Altars, den er früher dort erbaut hatte. Und Abram rief daselbst den Namen Jahwes an. ");
INSERT INTO deutkw_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Aber auch Lot, der mit Abram zog, hatte Schafe und Rinder und Zelte. ");
INSERT INTO deutkw_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Und das Land ertrug sie nicht, daß sie hätten bei einander bleiben können; denn ihre Habe war groß, und es war unmöglich, daß sie bei einander blieben. ");
INSERT INTO deutkw_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Und es entstand Zwietracht zwischen den Hirten von Abrams Vieh und den Hirten von Lots Vieh; überdies waren die Kanaaniter und Pheresiter damals im Lande ansässig. ");
INSERT INTO deutkw_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Da sprach Abram zu Lot: Laß doch nicht Zwietracht sein zwischen mir und dir und zwischen meinen und deinen Hirten; sind wir doch Brüder! ");
INSERT INTO deutkw_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Steht dir nicht das ganze Land offen? Trenne dich lieber von mir; willst du zur Linken, so will ich rechts gehen, und willst du zur Rechten, so will ich links gehen! ");
INSERT INTO deutkw_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Da erhob Lot seine Augen und gewahrte, daß die ganze Jordansaue durchaus wohlbewässertes Land war, bevor Jahwe Sodom und Gomorra zerstörte, gleich dem Garten Jahwes, wie Ägyptenland, bis nach Zoar hin. ");
INSERT INTO deutkw_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Da wählte sich Lot die ganze Jordansaue, und Lot brach auf nach Osten, und so trennten sie sich von einander; ");
INSERT INTO deutkw_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram wohnte im Lande Kanaan, während Lot in den Städten der Aue wohnte. Und er rückte mit seinen Zelten weiter bis nach Sodom. ");
INSERT INTO deutkw_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Die Leute von Sodom aber waren böse und sündigten sehr gegen Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Jahwe aber sprach zu Abram, nachdem sich Lot von ihm getrennt hatte: Erhebe deine Augen und schaue von dem Ort, an welchem du dich befindest, nach Norden, Süden, Osten und Westen. ");
INSERT INTO deutkw_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Denn all das Land, welches du siehst, will ich dir zu eigen geben und deinen Nachkommen für immer. ");
INSERT INTO deutkw_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Und ich will deine Nachkommen so zahlreich machen, wie die Krümchen der Erde, daß deine Nachkommen so wenig zu zählen sein werden, als jemand die Erdkrümchen zu zählen vermag. ");
INSERT INTO deutkw_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Mache dich auf und durchziehe das Land nach seiner Länge und Breite, denn dir will ich es zu eigen geben! ");
INSERT INTO deutkw_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Abram aber rückte weiter mit seinen Zelten und kam und ließ sich nieder bei den Terebinthen Mamres, die sich zu Hebron befinden, und erbaute daselbst Jahwe einen Altar. ");
INSERT INTO deutkw_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Es begab sich aber zur Zeit Amraphels, des Königs von Sinear, da fingen Arioch, der König von Ellasar, Kedorlaomer, der König von Elam, und Tideal, der König der Heiden, ");
INSERT INTO deutkw_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Krieg an mit Bera, dem König von Sodom, und mit Birsa, dem König von Gomorra, Sineab, dem König von Adma, und Semeber, dem König von Zeboim, und mit dem König von Bela, das ist Zoar. ");
INSERT INTO deutkw_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Alle diese zogen vereint ins Gefilde von Siddim, das ist das heutige Salzmeer. ");
INSERT INTO deutkw_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Zwölf Jahre hindurch waren sie Kedorlaomer unterthan gewesen und im dreizehnten waren sie abgefallen. ");
INSERT INTO deutkw_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Im vierzehnten Jahre aber kam Kedorlaomer und die Könige, die mit ihm waren, und sie schlugen die Rephaiter zu Astaroth Karnaim und die Susiter zu Ham und die Emiter in der Ebene von Kirjathaim ");
INSERT INTO deutkw_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","und die Horiter auf ihrem Gebirge Seir bis nach El Paran, welches östlich von der Wüste liegt. ");
INSERT INTO deutkw_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Hierauf wandten sie um und gelangten nach En Mispat, das ist Kades; und sie schlugen das ganze Land der Amalekiter, dazu auch die Amoriter, die in Hazazon Thamar wohnten. ");
INSERT INTO deutkw_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Da zogen der König von Sodom und der König von Gomorra und der König von Adma und der König von Zeboim und der König von Bela, das ist Zoar, aus und stellten sich gegen sie in Schlachtordnung im Gefilde von Siddim, ");
INSERT INTO deutkw_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","gegen Kedorlaomer, den König von Elam, Tideal, den König der Heiden, Amraphel, den König von Sinear, und Arioch, den König von Ellasar - vier Könige gegen fünf! ");
INSERT INTO deutkw_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Im Gefilde von Siddim aber war eine Erdharzgrube an der andern. Als nun die Könige von Sodom und Gomorra fliehen mußten, versanken sie darein, und was übrig blieb, foh auf das Gebirge. ");
INSERT INTO deutkw_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Da nahmen sie die gesamte Habe von Sodom und Gomorra und ihren gesamten Mundvorrat und zogen davon. ");
INSERT INTO deutkw_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Sie nahmen aber auch Lot, den Sohn des Bruders Abrams, der in Sodom wohnte, samt seiner Habe und zogen davon. ");
INSERT INTO deutkw_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Da kam einer, der entronnen war, und berichtete es Abram, dem Hebräer; derselbe wohnte bei den Terebinthen des Amoriters Mamre, des Bruders Eskols und Aners. Diese waren im Bunde mit Abram. ");
INSERT INTO deutkw_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Als nun Abram hörte, daß sein Verwandter weggeführt worden sei als Gefangener, da ließ er seine erprobten Leute, die in seinem Hause geborenen Sklaven, dreihundert und achtzehn, ausrücken und jagte nach bis Dan. ");
INSERT INTO deutkw_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Da teilte er seine Leute in mehrere Haufen und überfiel sie des Nachts, schlug sie und verfolgte sie bis Hoba, welches nördlich von Damaskus liegt. ");
INSERT INTO deutkw_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Hierauf brachte er die gesamte Habe zurück und auch Lot, seinen Verwandten, brachte er zurück samt seiner Habe, ebenso auch die Weiber und das Volk. ");
INSERT INTO deutkw_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Als er nun Kedorlaomer und die Könige, die mit ihm waren, besiegt hatte und wieder heimkehrte, da zog ihm der König von Sodom entgegen ins Thal Save, das ist das Königsthal. ");
INSERT INTO deutkw_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Und Melchisedek, der König von Salem, brachte Brot und Wein heraus; derselbe war ein Priester des höchsten Gottes. ");
INSERT INTO deutkw_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Und er segnete ihn und sprach: Gesegnet werde Abram vom höchsten Gott, dem Schöpfer des Himmels und der Erde! ");
INSERT INTO deutkw_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Und gepriesen sei der höchste Gott, der deine Feinde in deine Hand gegeben hat! Da gab ihm Abram den Zehnten von allem. ");
INSERT INTO deutkw_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Und der König von Sodom sprach zu Abram: Gieb mir die Leute; dagegen die Habe behalte für dich. ");
INSERT INTO deutkw_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Da sprach Abram zum König von Sodom: Ich erhebe meine Hand zu Jahwe, dem höchsten Gott, dem Schöpfer des Himmels und der Erde: ");
INSERT INTO deutkw_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Nicht ein Faden, noch einen Schuhriemen, überhaupt nichts von dem, was dir gehört, nehme ich an, damit du nicht sagest, du habest Abram bereichert! ");
INSERT INTO deutkw_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ich mag nichts! Nur was die Knechte verzehrt haben, und der Anteil der Männer, die mit mir gezogen sind, Aner, Eskol und Mamre - die mögen ihr Teil nehmen. ");
INSERT INTO deutkw_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Nach diesen Begebenheiten erging das Wort Jahwes an Abram in einem Gesicht; und er sprach: Fürchte dich nicht, Abram; ich bin dein Schild - es wartet deiner reicher Lohn! ");
INSERT INTO deutkw_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Da sprach Abram: O Herr Jahwe! Was willst du mir geben, während ich doch kinderlos dahingehe, und der Erbe meines Besitzes wird Elieser sein. ");
INSERT INTO deutkw_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Und Abram sprach: Mir hast du ja keine Nachkommenschaft gegeben; so wird denn ein Leibeigener meines Hauses mich beerben. ");
INSERT INTO deutkw_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Aber das Wort Jahwes erging an ihn also: Er soll nicht dein Erbe sein, sondern einer, der von deinem Leibe kommen wird, der soll dich beerben! ");
INSERT INTO deutkw_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Und er führte ihn hinaus ins Freie und sprach: Blicke auf zum Himmel und zähle die Sterne, ob du sie zu zählen vermagst! Und er sprach zu ihm: So zahlreich sollen deine Nachkommen sein! ");
INSERT INTO deutkw_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Und er glaubte Jahwe, und das rechnete er ihm zu als Gerechtigkeit. ");
INSERT INTO deutkw_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Da sprach er zu ihm: Ich bin Jahwe, der dich ausgeführt hat aus Ur in Chaldäa, um dir dieses Land zu eigen zu geben. ");
INSERT INTO deutkw_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Und er sprach: O Herr Jahwe! Woran soll ich erkennen, daß ich es besitzen werde? ");
INSERT INTO deutkw_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Da sprach er zu ihm: Hole mir eine dreijährige Kuh, eine dreijährige Ziege, einen dreijährigen Widder, eine Turteltaube und eine junge Taube. ");
INSERT INTO deutkw_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Da holte er ihm alle diese, zerteilte sie in je zwei gleiche Teile und legte je die eine Hälfte der andern gegenüber; die Vögel aber zerteilte er nicht. ");
INSERT INTO deutkw_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Da stießen die Raubvögel herab auf die Stücke; Abram aber scheuchte sie hinweg. ");
INSERT INTO deutkw_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Als nun die Sonne untergehen wollte, da fiel ein tiefer Schlaf auf Abram, und Beängstigung, dichte Finsternis überfiel ihn. ");
INSERT INTO deutkw_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Da sprach er zu Abram: Du mußt wissen, daß deine Nachkommen Fremdlinge sein werden in einem Lande, das ihnen nicht gehört; und sie werden ihnen leibeigen sein, und jene werden sie hart bedrücken vierhundert Jahre lang. ");
INSERT INTO deutkw_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Aber auch das Volk, dem sie leibeigen sein werden, will ich richten, und darnach sollen sie ausziehen mit reicher Habe. ");
INSERT INTO deutkw_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Du aber wirst in Frieden zu deinen Vätern eingehen; du wirst begraben werden in einem schönen Alter. ");
INSERT INTO deutkw_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Und das vierte Geschlecht von ihnen wird hierher zurückkehren; denn noch ist das Maß der Schuld der Amoriter nicht voll. ");
INSERT INTO deutkw_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Als aber die Sonne untergegangen und dichte Finsternis eingetreten war, da kam ein Rauch, wie aus einem Ofen, und eine Feuerfackel, die zwischen jenen Stücken hindurchging. ");
INSERT INTO deutkw_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","An jenem Tage schloß Jahwe einen Bund mit Abram und sprach: Deinen Nachkommen will ich dieses Land geben vom Strome Ägyptens an bis zum großen Strom, dem Euphratstrom, ");
INSERT INTO deutkw_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","das Land der Keniter, der Kenissiter, der Kadmoniter, ");
INSERT INTO deutkw_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","der Hethiter, der Pheresiter, der Rephaiter, ");
INSERT INTO deutkw_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","der Amoriter, der Kanaaniter, der Girgasiter und der Jebusiter. ");
INSERT INTO deutkw_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Und Sarai, das Weib Abrams, hatte ihm keine Kinder geboren; sie hatte aber eine ägyptische Sklavin Namens Hagar. ");
INSERT INTO deutkw_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Da sprach Sarai zu Abram: Da mir Jahwe nun einmal Kinder versagt hat, so gehe doch ein zu meiner Leibmagd: vielleicht werde ich durch sie zu Kindern kommen! Und Abram gehorchte den Worten Sarais. ");
INSERT INTO deutkw_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Da nahm Sarai, das Weib Abrams, die Ägypterin Hagar, ihre Leibmagd, nachdem Abram zehn Jahre im Lande Kanaan gewohnt hatte, und gab sie Abram, ihrem Manne, zum Weibe. ");
INSERT INTO deutkw_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Und er wohnte Hagar bei, und sie wurde schwanger. Als sie aber merkte, daß sie schwanger sei, sah sie ihre Herrin geringschätzig an. ");
INSERT INTO deutkw_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Sarai aber sprach zu Abram: Die Kränkung, die mir widerfährt, komme über dich! Ich selbst habe dir meine Leibmagd abgetreten; nun sie aber merkt, daß sie schwanger ist, sieht sie mich geringschätzig an. Jahwe richte zwischen mir und dir! ");
INSERT INTO deutkw_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Da sprach Abram zu Sarai: Deine Leibmagd ist ja in deiner Gewalt; verfahre mit ihr, wie es dir gut dünkt! ");
INSERT INTO deutkw_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Da behandelte Sarai sie hart, so daß sie ihr entfloh. Da traf sie der Engel Jahwes an der Quelle in der Wüste, an der Quelle auf dem Wege nach Sur. ");
INSERT INTO deutkw_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Und er sprach: Hagar, Leibmagd Sarais, woher kommst du und wohin willst du? Sie antwortete: Ich bin auf der Flucht vor Sarai, meiner Herrin. ");
INSERT INTO deutkw_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Und der Engel Jahwes sprach zu ihr: Kehre zurück zu deiner Herrin und unterwirf dich ihrer Gewalt. ");
INSERT INTO deutkw_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Und der Engel Jahwes sprach zu ihr: Ich will deine Nachkommenschaft überaus zahlreich machen, so daß sie unzählbar sein soll vor Menge. ");
INSERT INTO deutkw_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Und der Engel Jahwes sprach zu ihr: Du bist jetzt schwanger und wirst einen Sohn gebären; den sollst du Ismael nennen, weil Jahwe die Klage über dein Elend erhört hat. ");
INSERT INTO deutkw_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Der aber wird ein Mensch wie ein Wildesel sein - seine Hand gegen jedermann und jedermanns Hand gegen ihn - und er wird allen seinen Verwandten auf dem Nacken sitzen. ");
INSERT INTO deutkw_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Da nannte sie Jahwe, der zu ihr geredet hatte: Du bist der Gott des Schauens! Denn sie sprach: Habe ich auch wirklich hier dem nachgeschaut, der mich erschaut hat? ");
INSERT INTO deutkw_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Daher nennt man jenen Brunnen “Brunnen des Lebendigen, der mich schaut”; er liegt aber zwischen Kades und Bared. ");
INSERT INTO deutkw_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Und Hagar gebar Abram einen Sohn, und Abram nannte den Sohn, den ihm Hagar geboren hatte, Ismael. ");
INSERT INTO deutkw_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram aber war sechsundachtzig Jahre alt, als Hagar dem Abram den Ismael gebar. ");
INSERT INTO deutkw_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Und als Abram neunundneunzig Jahre alt war, erschien Jahwe dem Abram und sprach zu ihm: Ich bin Gott, der Allmächtige, wandle vor mir und sei fromm, ");
INSERT INTO deutkw_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","so will ich einen Bund stiften zwischen mir und dir und will dir überaus zahlreiche Nachkommen verleihen. ");
INSERT INTO deutkw_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Da warf sich Abram nieder auf sein Angesicht und Gott redete mit ihm also: ");
INSERT INTO deutkw_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Ich bin's, der ich den Bund mit dir habe, daß du Stammvater eines Haufens von Völkern werden sollst. ");
INSERT INTO deutkw_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Darum sollst du fortan nicht mehr Abram heißen, sondern Abraham soll dein Name sein. Denn zum Stammvater eines Haufens von Völkern mache ich dich. ");
INSERT INTO deutkw_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Und ich will machen, daß deine Nachkommen überaus zahlreich werden und zu ganzen Völkern anwachsen und sogar Könige sollen von dir abstammen. ");
INSERT INTO deutkw_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Und ich will meinen Bund aufrichten zwischen mir und dir und deinen Nachkommen nach dir, nach ihren Geschlechtern, als einen ewigen Bund, daß ich dir Gott sein will und deinen Nachkommen nach dir. ");
INSERT INTO deutkw_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Und ich will dir und deinen Nachkommen nach dir das Land verleihen, in welchem du jetzt als Fremdling weilst, das ganze Land Kanaan, zum Eigentum für immer, und will ihr Gott sein. ");
INSERT INTO deutkw_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Und Gott sprach zu Abraham. Du aber sollst meinen Bund halten, du und deine Nachkommen nach dir, nach ihren Geschlechtern. ");
INSERT INTO deutkw_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Das ist der Bund, den ihr halten sollt zwischen mir und euch und deinen Nachkommen nach dir: alles, was männlich ist unter euch, soll beschnitten werden. ");
INSERT INTO deutkw_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Und zwar sollt ihr beschnitten werden am Fleisch eurer Vorhaut, und dies sei das Zeichen des Bundes zwischen mir und euch. ");
INSERT INTO deutkw_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Im Alter von acht Tagen soll alles, was männlich ist unter euch, beschnitten werden, Geschlecht für Geschlecht, sowohl der im Hause geborene, als der von irgend einem Fremden mit Geld erkaufte Sklave, der nicht deines Stammes ist. ");
INSERT INTO deutkw_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Beschnitten soll werden sowohl der in deinem Hause geborene, als der von dir mit Geld erkaufte, und so soll mein Bund an eurem Leibe bezeugt sein als ein ewiger Bund. ");
INSERT INTO deutkw_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ein unbeschnittener Mann aber, der nicht beschnitten ist am Fleische seiner Vorhaut, - ein solcher soll weggetilgt werden aus seinen Volksgenossen; meinen Bund hat er gebrochen! ");
INSERT INTO deutkw_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Und weiter sprach Gott zu Abraham: Dein Weib Sarai sollst du nicht mehr Sarai nennen, sondern Sara soll ihr Name sein. ");
INSERT INTO deutkw_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Und ich will sie segnen und will dir auch durch sie einen Sohn schenken und will sie segnen, und sie soll die Stammmutter ganzer Völker werden; Völkerbeherrscher sollen von ihr abstammen. ");
INSERT INTO deutkw_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Da warf sich Abraham nieder auf sein Angesicht und lachte, denn er dachte bei sich: Sollte wohl einem Hundertjährigen noch ein Sohn geboren werden, und sollte Sara, die neunzigjährige, noch gebären? ");
INSERT INTO deutkw_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Und Abraham sprach zu Gott: Möchte nur Ismael am Leben bleiben vor dir! ");
INSERT INTO deutkw_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Da sprach Gott: Nein! Dein Weib Sara wird dir einen Sohn gebären, den sollst du Isaak nennen, und ich werde meinen Bund mit ihm aufrichten als einen ewigen Bund für seine Nachkommen nach ihm. ");
INSERT INTO deutkw_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Aber auch in betreff Ismaels will ich dich erhören; ich will ihn segnen und ihn fruchtbar sein lassen und will machen, daß seine Nachkommen ganz überaus zahlreich werden. Zwölf Fürsten wird er zeugen, und ich will machen, daß er zu einem großen Volke wird. ");
INSERT INTO deutkw_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Aber meinen Bund werde ich aufrichten mit Isaak, den dir Sara gebären wird um diese Zeit im künftigen Jahre. ");
INSERT INTO deutkw_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Und als er seine Unterredung mit ihm geendigt hatte, fuhr Gott auf von Abraham. ");
INSERT INTO deutkw_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Da nahm Abraham seinen Sohn Ismael und alle in seinem Hause geborenen, sowie alle mit Geld von ihm erkauften Sklaven, alles, was männlich war unter den Hausgenossen Abrahams, und beschnitt an eben diesem Tage das Fleisch ihrer Vorhaut, wie Gott ihm geboten hatte. ");
INSERT INTO deutkw_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham aber war neunundneunzig Jahre alt, als er beschnitten wurde am Fleische seiner Vorhaut. ");
INSERT INTO deutkw_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Und sein Sohn Ismael war dreizehn Jahre alt, als er beschnitten wurde am Fleische seiner Vorhaut. ");
INSERT INTO deutkw_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","An eben diesem Tage wurden beschnitten Abraham und sein Sohn Ismael; ");
INSERT INTO deutkw_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","und alle seine Hausgenossen, sowohl die im Hause geborenen, als die mit Geld von Fremden erkauften Sklaven, wurden mit ihm beschnitten. ");
INSERT INTO deutkw_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Da erschien ihm Jahwe bei den Terebinthen Mamres, während er um die heißeste Tageszeit am Eingang des Zeltes saß. ");
INSERT INTO deutkw_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Als er nun aufblickte, da gewahrte er, daß drei Männer vor ihm dastanden; und als er sie sah, lief er vom Eingang des Zeltes weg ihnen entgegen und verneigte sich bis auf den Boden. ");
INSERT INTO deutkw_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Sodann sprach er: O Herr, wenn ich irgend Gnade gefunden habe vor deinen Augen, so gehe doch ja nicht an deinem Sklaven vorüber! ");
INSERT INTO deutkw_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Man soll etwas Wasser bringen, daß ihr euch die Füße wascht. Dann legt euch hin unter den Baum, ");
INSERT INTO deutkw_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","und ich will einen Bissen Brot holen, daß ihr euch stärkt; darnach mögt ihr weiter ziehn. Denn dazu seid ihr vorübergekommen bei eurem Sklaven. Da sprachen sie: Thue, wie du gesagt hast! ");
INSERT INTO deutkw_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Da eilte Abraham ins Zelt zu Sara und sagte: Hole schnell drei Maß Feinmehl, knete und backe Kuchen! ");
INSERT INTO deutkw_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Weiter aber lief Abraham zu den Rindern, holte ein zartes und schönes junges Rind und übergab es dem Diener, und dieser beeilte sich, es zuzubereiten. ");
INSERT INTO deutkw_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Sodann holte er Dickmilch und süße Milch und das junge Rind, das er zubereitet hatte, und setzte es ihnen vor; er selbst aber bediente sie unter dem Baume, während sie aßen. ");
INSERT INTO deutkw_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Da sprachen sie zu ihm: Wo ist dein Weib Sara? Er antwortete: Drinnen im Zelte. ");
INSERT INTO deutkw_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Da sagte er: ich werde übers Jahr um diese Zeit wieder zu dir kommen; dann wird dein Weib Sara einen Sohn haben. Sara aber horchte am Eingang des Zeltes, und dieses war hinter ihm. ");
INSERT INTO deutkw_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abraham und Sara waren jedoch alt und hochbetagt, so daß es Sara nicht mehr erging, wie es den Frauen ergeht. ");
INSERT INTO deutkw_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Da lachte Sara in sich hinein, indem sie dachte: Nachdem ich welk geworden bin, sollte ich noch der Liebe pflegen? und mein Gemahl ist ja auch alt. ");
INSERT INTO deutkw_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Da sprach Jahwe zu Abraham: Warum lacht doch Sara und denkt: Sollte ich wirklich noch gebären können, nachdem ich alt geworden bin? ");
INSERT INTO deutkw_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ist für Jahwe irgend etwas unmöglich? Um diese Zeit werde ich übers Jahr wieder zu dir kommen, da soll Sara einen Sohn haben! ");
INSERT INTO deutkw_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Da leugnete Sara und sprach: Ich habe nicht gelacht! Denn sie fürchtete sich. Er aber sprach: Nicht doch, du hast gelacht! ");
INSERT INTO deutkw_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Hierauf brachen die Männer von dannen auf und schauten schon hinab auf Sodom - Abraham aber ging mit ihnen, sie zu geleiten - ");
INSERT INTO deutkw_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","da sprach Jahwe: Soll ich vor Abraham geheim halten, was ich alsbald thun will, ");
INSERT INTO deutkw_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","während doch von Abraham ein großes und zahlreiches Volk ausgehen und durch ihn alle Völker auf Erden gesegnet werden sollen? ");
INSERT INTO deutkw_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Denn ich habe ihn erkoren, damit er seinen Kindern und seinem Hause nach ihm gebiete, den Weg Jahwes einzuhalten, indem sie Recht und Gerechtigkeit üben, damit Jahwe über Abraham kommen lasse, was er ihm verheißen hat. ");
INSERT INTO deutkw_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Da sprach Jahwe: Das Geschrei über Sodom und Gomorra, das ist groß, und ihre Verschuldung - wahrlich sie ist sehr schwer! ");
INSERT INTO deutkw_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Darum will ich hinab, um zu sehen, ob sie wirklich alle so gehandelt haben, wie die Gerüchte über sie melden, die vor mich gekommen sind, oder nicht; ich will es erfahren! ");
INSERT INTO deutkw_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Da wandten sich die Männer von dannen und gingen nach Sodom zu, während Abraham noch vor Jahwe stehen blieb. ");
INSERT INTO deutkw_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Und Abraham trat herzu und sprach: Willst du denn auch die Unschuldigen umbringen mit den Schuldigen? ");
INSERT INTO deutkw_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Vielleicht giebt es fünfzig Unschuldige in der Stadt. Willst du die auch umbringen und nicht vielmehr den Ort begnadigen um der fünfzig Unschuldigen willen, die darin sind? ");
INSERT INTO deutkw_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ferne sei es von dir, so etwas zu thun, daß du Unschuldige und Schuldige zugleich tötetest, und es dem Unschuldigen erginge, wie dem Schuldigen. Das sei ferne von dir! Sollte der Richter der ganzen Erde nicht Gerechtigkeit üben? ");
INSERT INTO deutkw_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Da sprach Jahwe: Wenn ich zu Sodom fünfzig Unschuldige in der Stadt finden sollte, so will ich um ihretwillen den ganzen Ort begnadigen. ");
INSERT INTO deutkw_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Da hob Abraham wieder an und sprach: Ach, Herr! Ich habe mich unterfangen, zu dir zu reden, obschon ich Erd' und Asche bin. ");
INSERT INTO deutkw_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Vielleicht werden an den fünfzig Unschuldigen fünf fehlen; willst du wegen fünfen die ganze Stadt zu Grunde richten? Da sprach er: Ich werde sie nicht zu Grunde richten, wenn ich fünfundvierzig darin finde. ");
INSERT INTO deutkw_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Da fuhr er abermals fort, zu ihm zu reden, und sprach: Vielleicht finden sich nur vierzig darin. Er antwortete: Ich will's nicht thun um der vierzig willen. ");
INSERT INTO deutkw_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Da sprach er: Ach, zürne nicht, Herr, daß ich noch weiter rede. Vielleicht finden sich nur dreißig darin. Er antwortete: Ich will's nicht thun, wenn ich dreißig darin finde. ");
INSERT INTO deutkw_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Da sprach er: Ach, Herr, ich habe mich unterfangen, zu dir zu reden; vielleicht finden sich nur zwanzig darin. Er antwortete: Ich werde sie nicht zu Grunde richten um der zwanzig willen. ");
INSERT INTO deutkw_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Da sprach er: Ach, zürne nicht, Herr, wenn ich nur das eine Mal noch rede; vielleicht finden sich nur zehn darin! Er antwortete: Ich werde sie nicht zu Grunde richten um der zehn willen. ");
INSERT INTO deutkw_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Und Jahwe ging, nachdem er das Gespräch mit Abraham geendigt hatte, von dannen; Abraham aber kehrte zurück an seinen Ort. ");
INSERT INTO deutkw_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Die beiden Engel aber gelangten nach Sodom des Abends, als Lot gerade im Thore von Sodom saß. Und als Lot sie erblickte, erhob er sich, ging ihnen entgegen und verneigte sich bis auf den Boden. ");
INSERT INTO deutkw_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Hierauf sprach er: Ach, meine Herren! Kehrt doch ein in das Haus eures Knechtes zum Übernachten und wascht euch die Füße; morgen früh mögt ihr dann eures Weges ziehen. Sie aber sprachen: Nein! wir wollen auf freier Straße übernachten. ");
INSERT INTO deutkw_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Da drang er inständig in sie, bis sie bei ihm einkehrten und in sein Haus eintraten. Hierauf bereitete er ihnen eine Mahlzeit und buk ungesäuerte Kuchen, und sie aßen. ");
INSERT INTO deutkw_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Noch hatten sie sich nicht schlafen gelegt, da umringte die männliche Bevölkerung der Stadt, die Männer von Sodom, das Haus, jung und alt, die ganze Bevölkerung von allen Enden. ");
INSERT INTO deutkw_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Die riefen Lot und sprachen zu ihm: Wo sind die Männer, die heute Abend zu dir gekommen sind? Bringe sie heraus zu uns, damit wir ihnen beiwohnen! ");
INSERT INTO deutkw_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Da ging Lot zu ihnen hinaus vor die Thür - die Thüre aber schloß er hinter sich ab - ");
INSERT INTO deutkw_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","und sprach: Liebe Brüder! Begeht doch nicht eine solche Schlechtigkeit! ");
INSERT INTO deutkw_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Hört an! Ich habe zwei Töchter, die noch mit keinem Manne zu thun gehabt haben: die will ich zu euch hinausbringen, damit ihr ihnen thut, was euch beliebt. Diesen Männern aber dürft ihr nichts thun, nachdem sie sich nun einmal in den Schatten meines Dachs begeben haben. ");
INSERT INTO deutkw_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Da schrieen sie: Pack dich weg! und sprachen: als ein einzelner ist er hergekommen, um hier als Beisasse zu wohnen, und will nun immerfort befehlen! Jetzt wollen wir dir noch übler mitspielen, als ihnen! Und sie drangen hart auf den Mann, auf Lot, ein und nahten herzu, die Thüre zu erbrechen. ");
INSERT INTO deutkw_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Da griffen die Männer hinaus und zogen Lot zu sich hinein ins Haus und verschlossen die Thüre. ");
INSERT INTO deutkw_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Die Leute aber, die vor der Thüre des Hauses waren, schlugen sie mit Blindheit, klein und groß, so daß sie sich vergeblich mühten, die Thüre zu finden. ");
INSERT INTO deutkw_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Und die Männer sprachen zu Lot: Hast du noch jemanden hier? ");
INSERT INTO deutkw_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Denn wir werden diese Stätte verderben, weil schwere Klage über sie laut geworden ist vor Jahwe; daher sandte uns Jahwe, sie zu verderben. ");
INSERT INTO deutkw_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Da ging Lot hinaus und redete mit seinen Schwiegersöhnen, die seine Töchter nehmen sollten, und sprach: Auf! verlaßt diese Stätte! Denn Jahwe will die Stadt verderben! Seine Schwiegersöhne aber dachten, er treibe nur Scherz mit ihnen. ");
INSERT INTO deutkw_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Als aber die Morgenröte anbrach, da drängten die Engel Lot zur Eile und sprachen: Auf, nimm dein Weib und deine beiden Töchter, die hier gegenwärtig sind, damit du nicht mit weggerafft wirst wegen der Sündenschuld der Stadt. ");
INSERT INTO deutkw_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Als er aber noch zögerte, da ergriffen die Männer ihn und sein Weib und seine beiden Töchter bei der Hand, weil Jahwe ihn verschonen wollte, und brachten ihn hinaus und ließen ihn draußen vor der Stadt. ");
INSERT INTO deutkw_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Und während sie sie hinausbrachten, sprachen sie: Rette dich, es gilt dein Leben! Sieh' dich nicht um und bleibe nirgends stehen in der Niederung. Auf das Gebirge rette dich, damit du nicht mit weggerafft wirst! ");
INSERT INTO deutkw_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lot aber sprach zu ihnen: Ach nein, Herr! ");
INSERT INTO deutkw_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Dein Knecht hat nun einmal Gnade gefunden in deinen Augen, so daß du mir große Barmherzigkeit bewiesest und mich am Leben erhieltest. Aber ich bin nicht imstande, mich auf das Gebirge zu flüchten; wie leicht könnte mich das Verderben ereilen, daß ich sterben müßte. ");
INSERT INTO deutkw_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Siehe, es ist da eine Stadt in der Nähe, dahin könnte ich fliehen, und sie ist nur etwas Geringfügiges; dorthin möchte ich mich flüchten - sie ist ja doch nur etwas Geringfügiges! - damit ich am Leben bleibe. ");
INSERT INTO deutkw_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Da sprach er zu ihm: Auch in diesem Stücke will ich Rücksicht auf dich nehmen und die Stadt, von der du sprichst, nicht zerstören. ");
INSERT INTO deutkw_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Flüchte dich eilends dorthin, denn ich kann nichts unternehmen, bis du hingelangt bist! Darum nennt man die Stadt Zoar. ");
INSERT INTO deutkw_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Die Sonne war bereits aufgegangen, als Lot nach Zoar gelangte. ");
INSERT INTO deutkw_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Jahwe aber ließ auf Sodom und Gomorra Schwefel und Feuer regnen von Jahwe, vom Himmel, her ");
INSERT INTO deutkw_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","und zerstörte jene Städte von Grund aus samt der ganzen Niederung und allen Bewohnern der Städte und dem, was auf den Fluren gewachsen war. ");
INSERT INTO deutkw_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Und sein Weib schaute sich hinter ihm um; da wurde sie zu einer Salzsäule. ");
INSERT INTO deutkw_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Abraham aber begab sich am andern Morgen früh an die Stätte, wo er vor Jahwe gestanden hatte. ");
INSERT INTO deutkw_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Und als er hinabschaute auf Sodom und Gomorra und den ganzen Bereich der Niederung, da sah er, wie ein Qualm vom Lande aufstieg gleich dem Qualm eines Schmelzofens. ");
INSERT INTO deutkw_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Als aber Gott die Städte der Niederung zerstörte, da gedachte Gott an Abraham und geleitete Lot hinweg aus der Zerstörung, als er die Städte von Grund aus zerstörte, in denen Lot gewohnt hatte. ");
INSERT INTO deutkw_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot aber zog von Zoar hinauf und blieb auf dem Gebirge mit seinen beiden Töchtern, denn er fürchtete sich, in Zoar zu bleiben; und er wohnte in einer Höhle mit seinen beiden Töchtern. ");
INSERT INTO deutkw_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Da sprach die ältere zu der jüngeren: Unser Vater ist alt, und es giebt niemand mehr auf Erden, der Umgang mit uns haben könnte, wie es aller Welt Brauch ist. ");
INSERT INTO deutkw_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Komm, wir wollen unserem Vater Wein zu trinken geben und uns zu ihm legen, damit wir durch unsern Vater unsern Stamm erhalten. ");
INSERT INTO deutkw_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Da gaben sie ihrem Vater in jener Nacht Wein zu trinken; sodann ging die ältere hinein und legte sich zu ihrem Vater. Er aber merkte weder, wie sie sich hinlegte, noch wie sie aufstand. ");
INSERT INTO deutkw_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Am andern Morgen aber sprach die ältere zur jüngeren: Ich habe also heute Nacht bei meinem Vater gelegen. Wir wollen ihm auch diese Nacht Wein zu trinken geben; dann geh hinein und lege dich zu ihm, damit wir durch unsern Vater unsern Stamm erhalten. ");
INSERT INTO deutkw_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Da gaben sie ihrem Vater auch in dieser Nacht Wein zu trinken, dann begab sich die jüngere hin und legte sich zu ihm. Er aber merkte weder wie sie sich hinlegte, noch wie sie aufstand. ");
INSERT INTO deutkw_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Also wurden die beiden Töchter Lots schwanger von ihrem Vater. ");
INSERT INTO deutkw_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Und die ältere gebar einen Sohn und nannte ihn Moab; das ist der Stammvater der heutigen Moabiter. ");
INSERT INTO deutkw_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Aber auch die jüngere gebar einen Sohn und nannte ihn Ben Ammi; das ist der Stammvater der heutigen Ammoniter. ");
INSERT INTO deutkw_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Und Abraham zog von dort hinweg in das Gebiet des Südlands und nahm seinen Aufenthalt zwischen Kades und Sur und verweilte auch in Gerar. ");
INSERT INTO deutkw_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Von seinem Weibe Sara aber behauptete Abraham: sie ist meine Schwester! Da sandte Abimelech, der König von Gerar, hin und ließ Sara holen. ");
INSERT INTO deutkw_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Aber Gott kam des Nachts im Traume zu Abimelech und sprach zu ihm: Du muß sterben wegen des Weibes, das du weggenommen hast, denn sie ist eine Ehefrau. ");
INSERT INTO deutkw_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimelech aber war ihr nicht zu nahe gekommen; und er sprach: Herr! du wirst doch nicht Unschuldige umbringen! ");
INSERT INTO deutkw_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Hat er doch selbst zu mir gesagt: sie ist meine Schwester! Und ebenso hat auch sie behauptet: er ist mein Bruder! In der Einfalt meines Herzens und mit reinen Händen habe ich so gehandelt! ");
INSERT INTO deutkw_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Da sprach Gott zu ihm im Traum: Auch ich weiß wohl, daß du in der Einfalt deines Herzens so gehandelt hast, und ich habe dich davor bewahrt, daß du dich gegen mich versündigtest; darum habe ich nicht zugelassen, daß du sie berührtest. ");
INSERT INTO deutkw_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","So gieb nun dem Manne sein Weib zurück, denn er ist ein Prophet, und er soll Fürbitte für dich einlegen, daß du am Leben bleibst. Wenn du sie aber nicht zurückgiebst, so wisse, daß du sterben muß samt allen, die dir angehören. ");
INSERT INTO deutkw_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Am andern Morgen früh rief Abimelech alle seine Knechte und erzählte ihnen alles, was vorgegangen war; da gerieten die Männer in große Furcht. ");
INSERT INTO deutkw_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Und Abimelech ließ Abraham rufen und sprach zu ihm: Was hast du uns angethan! Was habe ich gegen dich verschuldet, daß du über mich und mein Königreich so schwere Verschuldung gebracht hast! Was nimmermehr geschehen sollte, das hast du mir angethan! ");
INSERT INTO deutkw_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Und Abimelech sprach zu Abraham: Was hast du damit beabsichtigt, daß du so gehandelt hast? ");
INSERT INTO deutkw_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Da sprach Abraham: Ja, ich dachte, schwerlich ist irgend welche Gottesfurcht an diesem Ort zu finden; so werden sie mich denn umbringen um meines Weibes willen. ");
INSERT INTO deutkw_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Übrigens ist sie wirklich meine Schwester, die Tochter meines Vaters - nur nicht die Tochter meiner Mutter -, und sie wurde mein Weib. ");
INSERT INTO deutkw_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Als mich Gott aus meiner Heimat in die Fremde wandern ließ, da sprach ich zu ihr: Das mußt du mir zu Liebe thun: wohin wir auch kommen mögen, da gieb mich für deinen Bruder aus! ");
INSERT INTO deutkw_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Da nahm Abimelech Schafe und Rinder und Sklaven und Sklavinnen und gab sie Abraham; dazu gab er ihm sein Weib Sara zurück. ");
INSERT INTO deutkw_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Und Abimelech sprach: Mein Land steht dir offen; laß dich nieder, wo es dir gefällt. ");
INSERT INTO deutkw_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Und zu Sara sprach er: hier übergebe ich deinem Bruder tausend Silberstücke; das soll eine Ehrenerklärung für dich sein gegenüber allen, die bei dir sind, so daß du vor jedermann gerechtfertigt bist. ");
INSERT INTO deutkw_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Da legte Abraham bei Gott Fürbitte ein, und Gott heilte den Abimelech und sein Weib und seine Sklavinnen, so daß sie Kinder gebaren. ");
INSERT INTO deutkw_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Denn Jahwe hatte um Saras, des Weibes Abrahams, willen die Leiber aller Frauen im Hause Abimelechs gänzlich verschlossen. ");
INSERT INTO deutkw_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Jahwe aber hatte an Sara erfüllt, was er verheißen hatte, und Jahwe that mit Sara, wie er geredet hatte. ");
INSERT INTO deutkw_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Und Sara wurde schwanger und gebar dem Abraham einen Sohn in seinem hohen Alter um die Zeit, die Gott vorausgesagt hatte. ");
INSERT INTO deutkw_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Und Abraham nannte seinen neugebornen Sohn, den ihm Sara geboren hatte, Isaak. ");
INSERT INTO deutkw_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Und Abraham beschnitt seinen Sohn Isaak, als er acht Tage alt war, wie ihm Gott geboten hatte. ");
INSERT INTO deutkw_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraham aber war hundert Jahre alt, als ihm sein Sohn Isaak geboren wurde. ");
INSERT INTO deutkw_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Und Sara sprach: Ein Lachen hat mir Gott bereitet; jedermann, der davon hört, wird über mich lachen. ");
INSERT INTO deutkw_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Und sie sprach: Wer hätte je von Abraham gedacht, daß Sara Kinder säugen werde! und doch habe ich ihm einen Sohn geboren in seinem Alter. ");
INSERT INTO deutkw_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Und der Knabe wuchs heran und wurde entwöhnt; Abraham aber veranstaltete ein großes Mahl an dem Tage, wo Isaak entwöhnt wurde. ");
INSERT INTO deutkw_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Als nun Sara den Sohn der Ägypterin Hagar, den sie Abraham geboren hatte, lachen sah, ");
INSERT INTO deutkw_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","da sprach sie zu Abraham: Jage diese Sklavin und ihren Sohn hinweg; denn der Sohn dieser Sklavin soll nicht erben mit meinem Sohn, mit Isaak! ");
INSERT INTO deutkw_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Abraham aber mißfiel die Sache sehr um seines Sohnes willen. ");
INSERT INTO deutkw_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Da sprach Gott zu Abraham: Laß es dir nicht leid sein wegen des Knaben und wegen deiner Sklavin; gehorche Sara in allem, was sie von dir verlangt; denn nur die, die von Isaak stammen, werden als deine wahrhaften Nachkommen gelten. ");
INSERT INTO deutkw_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Aber auch den Sohn der Magd will ich zu einem Volke werden lassen, weil er dein Sohn ist. ");
INSERT INTO deutkw_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Am andern Morgen früh nahm Abraham Brot und einen Schlauch mit Wasser und gab es Hagar; das Kind aber setzte er ihr auf die Schulter und schickte sie fort. Da ging sie hinweg und irrte umher in der Steppe von Beerseba. ");
INSERT INTO deutkw_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Als nun das Wasser im Schlauche zu Ende gegangen war, da warf sie den Knaben unter einen Strauch, ");
INSERT INTO deutkw_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","ging hin und setzte sich abseits einen Bogenschuß weit; denn sie sprach: Ich kann das Sterben des Kindes nicht ansehen! Daher setzte sie sich abseits; das Kind aber begann laut zu weinen. ");
INSERT INTO deutkw_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Als nun Gott das Schreien des Knaben hörte, da rief der Engel Gottes der Hagar vom Himmel her zu und sprach zu ihr: Was ist dir, Hagar? Sei getrost! Gott hat das Schreien des Knaben gehört da, wo er liegt. ");
INSERT INTO deutkw_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Geh, hebe den Knaben auf und fasse ihn bei der Hand, denn ich will ihn zu einem großen Volke werden lassen. ");
INSERT INTO deutkw_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Und Gott that ihr die Augen auf, daß sie einen Wasserquell erblickte. Da ging sie hin, füllte den Schlauch mit Wasser und gab dem Knaben zu trinken. ");
INSERT INTO deutkw_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Und Gott war mit dem Knaben; der wuchs heran und nahm seinen Aufenthalt in der Steppe und wurde ein Bogenschütz. ");
INSERT INTO deutkw_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Er nahm aber seinen Aufenthalt in der Steppe Paran, und seine Mutter nahm ihm ein Weib aus dem Lande Ägypten. ");
INSERT INTO deutkw_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Um dieselbe Zeit sprachen Abimelech und sein Heerführer Pichol zu Abraham also: Gott ist mir dir in allem, was du thust. ");
INSERT INTO deutkw_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Darum schwöre mir jetzt bei Gott allhier, daß du an mir und meiner gesamten Verwandtschaft nimmermehr treulos handeln willst. Gleichwie ich mich freundschaftlich gegen dich erzeigt habe, sollst du dich gegen mich erzeigen und gegen das Land, in welchem du dich als Fremdling aufhältst. ");
INSERT INTO deutkw_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Da sprach Abraham: Ich will schwören. ");
INSERT INTO deutkw_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Abraham aber setzte den Abimelech zur Rede wegen des Wasserbrunnens, den die Sklaven Abimelechs mit Gewalt genommen hatten. ");
INSERT INTO deutkw_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimelech antwortete: Ich weiß nicht, wer das gethan hat; weder hast du mir etwas davon gesagt, noch habe ich bis heute davon gehört. ");
INSERT INTO deutkw_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Da nahm Abraham Schafe und Rinder und gab sie dem Abimelech, und sie schlossen einen Vertrag miteinander. ");
INSERT INTO deutkw_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abraham aber stellte die sieben Lämmer besonders. ");
INSERT INTO deutkw_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Da sprach Abimelech zu Abraham: Was sollen diese sieben Lämmer, die du besonders gestellt hast? ");
INSERT INTO deutkw_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abraham antwortete: Die sieben Lämmer mußt du von mir annehmen; das soll mir zum Zeugnis dienen, daß ich diesen Brunnen gegraben habe. ");
INSERT INTO deutkw_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Daher heißt jene Stätte Beerseba, weil sie dort einander geschworen haben. ");
INSERT INTO deutkw_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","So schlossen sie einen Vertrag zu Beerseba. Alsdann brachen Abimelech und sein Heerführer Pichol auf und kehrten zurück ins Philisterland. ");
INSERT INTO deutkw_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abraham aber pflanzte eine Tamariske zu Beerseba und rief daselbst den Namen Jahwes an, des ewigen Gottes. ");
INSERT INTO deutkw_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abraham aber verweilte lange Zeit im Philisterland. ");
INSERT INTO deutkw_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Nach diesen Begebenheiten versuchte Gott Abraham und sprach zu ihm: Abraham! Er antwortete: Hier bin ich! ");
INSERT INTO deutkw_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Da sprach er: Nimm deinen Sohn, deinen einzigen, den du lieb hast, Isaak, ziehe hin in das Land Morija und bringe ihn dort als Brandopfer dar auf einem der Berge, den ich dir sagen werde. ");
INSERT INTO deutkw_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Da gürtete Abraham am andern Morgen früh seinen Esel, nahm seine beiden Diener mit sich samt seinem Sohne Isaak, spaltete Holz zum Brandopfer, brach auf und zog nach der Stätte, von der ihm Gott gesagt hatte. ");
INSERT INTO deutkw_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Am dritten Tage aber hob Abraham seine Augen auf und erblickte die Stätte von weitem. ");
INSERT INTO deutkw_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Da sprach Abraham zu seinen Dienern: Bleibt hier mit dem Esel; ich aber und der Knabe wollen dorthin gehen und anbeten und dann wieder zu euch kommen. ");
INSERT INTO deutkw_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Hierauf nahm Abraham das Holz zum Brandopfer und legte es auf seinen Sohn Isaak, nahm in seine Hand das Feuer und das Schlachtmesser, und so gingen die beiden miteinander. ");
INSERT INTO deutkw_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Da sprach Isaak zu seinem Vater Abraham und sagte: Mein Vater! Er antwortete: Hier bin ich, mein Sohn! Da sagte er: Das Feuer und das Holz ist da; wo aber ist das Schaf zum Brandopfer? ");
INSERT INTO deutkw_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham antwortete: Mein Sohn, Gott wird schon für ein Schaf zum Brandopfer sorgen! So gingen die beiden miteinander. ");
INSERT INTO deutkw_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Als sie nun an die Stätte gelangt waren, von der ihm Gott gesagt hatte, da errichtete Abraham den Altar und legte die Holzscheite zurecht; alsdann band er seinen Sohn Isaak und legte ihn auf den Altar oben über die Scheite. ");
INSERT INTO deutkw_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Sodann reckte Abraham seine Hand aus und ergriff das Messer, um seinen Sohn zu schlachten. ");
INSERT INTO deutkw_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Da rief ihm der Engel Jahwes vom Himmel her zu und sprach: Abraham! Abraham! Er antwortete: Hier bin ich! ");
INSERT INTO deutkw_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Da sprach er: lege nicht Hand an den Knaben und thue ihm nichts zu leide! Denn nun weiß ich, daß du Gott fürchtest, da du mir deinen einzigen Sohn nicht verweigert hast. ");
INSERT INTO deutkw_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Da hob Abraham seine Augen auf und gewahrte einen Widder, der sich mit seinen Hörnern im Dickicht verfangen hatte; da ging Abraham hin, holte den Widder und brachte ihn als Brandopfer dar an Stelle seines Sohnes. ");
INSERT INTO deutkw_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Und Abraham nannte die Stätte: Jahwe sieht! Daher man noch heutiges Tages sagt: auf dem Berge, wo Jahwe erscheint. ");
INSERT INTO deutkw_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Der Engel Jahwes aber rief dem Abraham ein zweites Mal vom Himmel her zu ");
INSERT INTO deutkw_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","und sprach: Ich schwöre bei mir selbst, ist der Spruch Jahwes: dafür, daß du das gethan und mir deinen einzigen Sohn nicht verweigert hast, ");
INSERT INTO deutkw_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","will ich dich reichlich segnen und deine Nachkommen so überaus zahlreich werden lassen, wie die Sterne am Himmel und wie der Sand am Ufer des Meeres, und deine Nachkommen sollen die Thore ihrer Feinde besitzen, ");
INSERT INTO deutkw_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","und durch deine Nachkommen sollen alle Völker der Erde gesegnet werden, zum Lohne dafür, daß du meinem Befehle gehorcht hast! ");
INSERT INTO deutkw_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Hierauf kehrte Abraham wieder zu seinen Dienern zurück, und sie brachen auf und zogen miteinander nach Beerseba, und Abraham blieb in Beerseba wohnen. ");
INSERT INTO deutkw_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Nach diesen Begebenheiten wurde dem Abraham berichtet: Auch Milka hat deinem Bruder Nahor Söhne geboren, ");
INSERT INTO deutkw_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","nämlich Uz, seinen Erstgebornen, und dessen Bruder Bus und Kemuel, von dem die Aramäer stammen, ");
INSERT INTO deutkw_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","und Chesed, Haso, Pildas, Jidlaph und Bethuel; ");
INSERT INTO deutkw_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bethuel aber erzeugte Rebeka. Diese acht gebar Milka dem Nahor, dem Bruder Abrahams. ");
INSERT INTO deutkw_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Er hatte aber auch ein Kebsweib mit Namen Reuma; auch diese gebar: nämlich den Tebah, Gaham, Tahas und Maacha. ");
INSERT INTO deutkw_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Es betrug aber die Lebensdauer Saras 127 Jahre; das waren die Lebensjahre Saras. ");
INSERT INTO deutkw_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Und Sara starb zu Kirjath-Arba, das ist Hebron, im Lande Kanaan. Abraham aber ging hin, um wegen Sara zu klagen und sie zu beweinen. ");
INSERT INTO deutkw_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Sodann verließ Abraham den Leichnam und redete also zu den Hethitern: ");
INSERT INTO deutkw_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Als Fremdling und Beisaß bin ich bei euch; gebt mir ein Erbbegräbnis bei euch, damit ich meine Tote aus dem Hause bringe und begrabe. ");
INSERT INTO deutkw_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Da antworteten die Hethiter dem Abraham also: ");
INSERT INTO deutkw_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Höre uns doch an, o Herr! Als ein Fürst Gottes weilst du unter uns; in dem besten unserer Gräber begrabe deine Tote! Keiner von uns wird dir verweigern, daß du deine Tote in seinem Grabe bestattest. ");
INSERT INTO deutkw_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Da erhob sich Abraham und verneigte sich vor den Landeskindern, den Hethitern, ");
INSERT INTO deutkw_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","und redete mit ihnen also: Wenn es euch genehm ist, daß ich meine Tote aus dem Hause bringe und begrabe, so thut mir den Gefallen und legt Fürsprache für mich ein bei Ephron, dem Sohne Zohars, ");
INSERT INTO deutkw_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","daß er mir die Höhle Machpela abtrete, die ihm gehört und die ganz am Ende seines Grundstücks liegt; für den vollen Betrag soll er sie mir abtreten zum Erbbegräbnis unter euch. ");
INSERT INTO deutkw_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ephron aber saß mit da unter den Hethitern. Da antwortete Ephron, der Hethiter, dem Abraham, so daß es die Hethiter hörten, so viele ihrer durch das Thor seiner Stadt aus- und eingingen, folgendermaßen: ");
INSERT INTO deutkw_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Nicht doch, Herr! höre mich an! Ich schenke dir das Grundstück, und auch die Höhle, die darauf ist, die schenke ich dir; vor den Augen meiner Stammesgenossen schenke ich sie dir. Begrabe du nur deine Tote! ");
INSERT INTO deutkw_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Da verneigte sich Abraham vor den Landeskindern; ");
INSERT INTO deutkw_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","sodann sprach er zu Ephron, so daß es seine Landsleute hörten, also: Wenn du - höre mich einmal an! Ich zahle das Geld für das Grundstück; nimm es von mir an, damit ich meine Tote begrabe. ");
INSERT INTO deutkw_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ephron aber antwortete dem Abraham also: ");
INSERT INTO deutkw_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Höre mich doch nur an, Herr! Ein Stück Land von vierhundert Silbersekeln Wert, was hat das unter uns zu sagen? Begrabe du nur deine Tote! ");
INSERT INTO deutkw_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Und Abraham hörte auf Ephron, und Abraham wog dem Ephron den Kaufpreis dar, von dem er im Beisein der Hethiter gesprochen hatte: vierhundert Sekel Silber, wie es im Handel gäng und gäbe war. ");
INSERT INTO deutkw_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","So wurde das Grundstück Ephrons bei Machpela, gegenüber Mamre, das Grundstück mit der Höhle darauf und mit allen Bäumen, die sich auf dem Grundstück befanden in seinem ganzen Bereich ringsum, ");
INSERT INTO deutkw_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","dem Abraham zum Eigentum bestätigt im Beisein der Hethiter, so viele durch das Thor seiner Stadt aus- und eingingen. ");
INSERT INTO deutkw_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Danach begrub Abraham sein Weib Sara in der Höhle des Grundstücks Machpela, gegenüber Mamre, das ist Hebron, in Kanaan. ");
INSERT INTO deutkw_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","So wurde das Grundstück und die Höhle darauf dem Abraham zum Erbbegräbnis bestätigt von den Hethitern. ");
INSERT INTO deutkw_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham aber war alt und wohlbetagt, und Jahwe hatte Abraham gesegnet in allem. ");
INSERT INTO deutkw_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Da sprach Abraham zu seinem Sklaven, dem Hausältesten, der alles das Seinige zu verwalten hatte: Lege doch deine Hand unter meine Lende! ");
INSERT INTO deutkw_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Denn du muß mir schwören bei Jahwe, dem Gott des Himmels und dem Gott der Erde, daß du für meinen Sohn nicht ein Weib freien willst von den Töchtern der Kanaaniter, unter denen ich wohne, ");
INSERT INTO deutkw_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","sondern daß du in mein Vaterland und zu meiner Verwandtschaft ziehen willst, um für meinen Sohn Isaak ein Weib zu freien. ");
INSERT INTO deutkw_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Da antwortete ihm der Sklave: Wenn nun aber das Weib mir nicht folgen will in dieses Land, soll ich dann deinen Sohn wieder in das Land zurückbringen, aus dem du ausgewandert bist? ");
INSERT INTO deutkw_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham sprach zu ihm: Hüte dich, meinen Sohn dorthin zurückzubringen! ");
INSERT INTO deutkw_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Jahwe, der Gott des Himmels, der mich hinweggeführt hat aus dem Hause meines Vaters und aus meinem Heimatlande, der zu mir geredet und mir zugeschworen hat: Deinen Nachkkommen will ich dieses Land verleihen! - der wird seinen Engel vor dir hersenden, daß du meinem Sohn ein Weib von dort freiest. ");
INSERT INTO deutkw_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Und wenn das Weib nicht willens sein sollte, dir zu folgen, so bist du dieses Eides quitt; keinesfalls aber darfst du meinen Sohn dorthin zurückbringen. ");
INSERT INTO deutkw_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Da legte der Sklave seine Hand unter die Lende Abrahams, seines Herrn, und schwur ihm, wie er verlangt hatte. ");
INSERT INTO deutkw_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Hierauf nahm der Sklave zehn Kamele von den Kamelen seines Herrn, sowie allerlei Kleinodien seines Herrn mit sich, brach auf und zog nach Mesopotamien, nach der Stadt Nahors. ");
INSERT INTO deutkw_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Da ließ er die Kamele draußen vor der Stadt bei einem Brunnen sich lagern, um die Abendzeit, wo die Weiber herauszukommen pflegen, um Wasser zu schöpfen. ");
INSERT INTO deutkw_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Und er sprach: Jahwe, Gott meines Herrn Abraham! Laß es mir heute glücken und zeige dich gnädig gegen meinen Herrn Abraham. ");
INSERT INTO deutkw_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Wenn ich jetzt dastehe bei der Quelle, und die Töchter der Stadtbewohner herauskommen, um Wasser zu schöpfen - ");
INSERT INTO deutkw_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","wenn dann das Mädchen, zu der ich sagen werde: Neige doch deinen Krug, damit ich trinke, antworten wird: Trinke, und auch deine Kamele will ich tränken! die hast du bestimmt für deinen Diener Isaak, und daran will ich erkennen, daß du dich gegen meinen Herrn gnädig erzeigst. ");
INSERT INTO deutkw_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Noch hatte er nicht ausgeredet, da kam, den Krug auf der Schulter, Rebeka heraus, die Tochter Bethuels, des Sohnes der Milka, des Weibes Nahors, des Bruders Abrahams. ");
INSERT INTO deutkw_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Das Mädchen aber war überaus schön, eine Jungfrau, mit der noch keiner Umgang gehabt hatte; und sie stieg hinab zur Quelle, füllte ihren Krug und kam wieder herauf. ");
INSERT INTO deutkw_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Da lief ihr der Sklave entgegen und sprach: Laß mich doch ein wenig Wasser aus deinem Kruge trinken! ");
INSERT INTO deutkw_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Da sprach sie: Trinke, Herr! und eilend ließ sie den Krug hernieder auf ihre Hand und gab ihm zu trinken. ");
INSERT INTO deutkw_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Und als sie ihm genug zu trinken gegeben hatte, sprach sie: Auch für deine Kamele will ich schöpfen, bis sie sich satt getrunken haben. ");
INSERT INTO deutkw_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Und eilend goß sie ihren Krug aus in die Tränkrinne, lief wieder zur Quelle, um Wasser zu schöpfen, und schöpfte für alle seine Kamele. ");
INSERT INTO deutkw_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Der Mann aber sah ihr voll Erstaunen schweigend zu, begierig, zu erfahren, ob Jahwe Glück zu seiner Reise gegeben habe oder nicht. ");
INSERT INTO deutkw_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Als nun die Kamele sich satt getrunken hatten, da nahm der Mann einen goldenen Nasenring, einen halben Sekel schwer, und zwei Armbänder für ihre Arme, zehn Sekel Goldes schwer, ");
INSERT INTO deutkw_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","und sprach: Wessen Tochter bist du? sage es mir! Ist im Hause deines Vaters Raum für uns zum Übernachten? ");
INSERT INTO deutkw_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Sie sprach zu ihm: Ich bin die Tochter Bethuels, des Sohnes der Milka, den sie dem Nahor geboren hat. ");
INSERT INTO deutkw_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Und weiter sagte sie zu ihm: Wir haben Stroh und Futter in Fülle, sowie auch Raum zum Übernachten. ");
INSERT INTO deutkw_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Da verneigte sich der Mann und beugte sich vor Jahwe ");
INSERT INTO deutkw_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","und sprach: Gepriesen sei Jahwe, der Gott meines Herrn Abraham, der es nicht hat fehlen lassen an Huld und Treue gegenüber meinem Herrn. Den Weg hat mich Jahwe geführt zum Hause der Verwandten meines Herrn! ");
INSERT INTO deutkw_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Das Mädchen aber lief und berichtete bei ihrer Mutter, was sich zugetragen hatte. ");
INSERT INTO deutkw_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Nun hatte Rebeka einen Bruder, der hieß Laban, da lief Laban zu dem Manne hinaus an die Quelle. ");
INSERT INTO deutkw_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Als dieser den Ring und die Spangen an den Armen seiner Schwester erblickte und seine Schwester erzählen hörte: so und so hat der Mann zu mir gesagt, und kam zu dem Manne; der aber stand noch bei den Kamelen an der Quelle. ");
INSERT INTO deutkw_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Da sprach er: Komm herein, du Gesegneter Jahwes! warum stehst du draußen? ");
INSERT INTO deutkw_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Als er nun den Mann ins Haus geführt hatte, zäumte er die Kamele ab; alsdann gab er den Kamelen Stroh und Futter und brachte Wasser zum Waschen der Füße für ihn und die Männer, die bei ihm waren. ");
INSERT INTO deutkw_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Als ihm aber zu essen vorgesetzt wurde, da sprach er: Ich esse nicht eher, als bis ich meine Sache vorgebracht habe! Er antwortete: So rede! ");
INSERT INTO deutkw_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Da sprach er: Ich bin der Sklave Abrahams. ");
INSERT INTO deutkw_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Jahwe hat meinen Herrn reichlich gesegnet, so daß er zu großem Wohlstand gelangt ist, und hat ihm Schafe und Rinder, Silber und Gold, Sklaven und Sklavinnen und Kamele und Esel geschenkt. ");
INSERT INTO deutkw_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Und Sara, das Weib meines Herrn, gebar meinem Herrn einen Sohn, als sie schon hochbetagt war; dem hat er alle seine Habe übergeben. ");
INSERT INTO deutkw_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Mein Herr aber gebot mir und ließ mich darauf schwören: Du darfst meinem Sohne kein Weib freien aus den Töchtern der Kanaaniter, in deren Land ich wohne, ");
INSERT INTO deutkw_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","sondern sollst hinziehen zu meines Vaters Haus und zu meiner Verwandtschaft um meinem Sohn ein Weib zu freien. ");
INSERT INTO deutkw_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Da sprach ich zu meinem Herrn: Wenn nun aber das Weib mir nicht folgen will? ");
INSERT INTO deutkw_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Da sprach er zu mir: Jahwe, vor dessen Angesicht ich gewandelt habe, wird seinen Engel mit dir senden und dir Glück zu deiner Reise geben, daß du meinem Sohn ein Weib freiest von meiner Verwandtschaft, aus dem Hause meines Vaters. ");
INSERT INTO deutkw_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Dann sollst du meines Eides quitt sein, wenn du dich zu meiner Verwandtschaft begeben wirst; geben sie dir sie nicht, so bist du meines Eides quitt. ");
INSERT INTO deutkw_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Als ich nun heute zu der Quelle kam, da sprach ich: Jahwe, du Gott meines Herrn Abraham! Wenn du Glück geben willst zu dem Weg, auf dem ich mich befinde, so soll - wenn ich jetzt dastehe bei der Quelle - ");
INSERT INTO deutkw_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","das Mädchen, das herauskommt, um Wasser zu schöpfen, und zu dem ich sagen werde: Gieb mir doch ein wenig Wasser zu trinken aus deinem Kruge! ");
INSERT INTO deutkw_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","und das dann antwortet: Trinke und auch deine Kamele will ich tränken - die soll das Weib sein, welches Jahwe dem Sohne meines Herrn bestimmt hat. ");
INSERT INTO deutkw_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Kaum hatte ich so bei mir beschlossen, da kam Rebeka heraus, den Krug auf der Schulter, stieg zur Quelle hinab und schöpfte Wasser. Da sprach ich zu ihr: Gieb mir zu trinken! ");
INSERT INTO deutkw_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Sie aber ließ rasch ihren Krug herab und sprach: Trinke! und auch deine Kamele will ich tränken. Da trank ich und sie tränkte dann auch die Kamele. ");
INSERT INTO deutkw_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Hierauf fragte ich sie und sprach: Wessen Tochter bist du? Sie antwortete: Ich bin die Tochter Bethuels, des Sohnes Nahors, den ihm Milka geboren hat. Da legte ich den Ring an ihre Nase und die Spangen an ihre Arme. ");
INSERT INTO deutkw_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Dann verneigte ich mich und beugte mich vor Jahwe und pries Jahwe, den Gott meines Herrn Abraham, dafür, daß er mich den rechten Weg geführt hat, die Tochter des Bruders meines Herrn für seinen Sohn zu freien. ");
INSERT INTO deutkw_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Wenn ihr nun also meinem Herrn Liebe und Treue erweisen wollt, so sagt es mir; wenn aber nicht, so sagt es mir auch, damit ich mich wende zur Rechten oder zur Linken. ");
INSERT INTO deutkw_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Da antworteten Laban und Bethuel und sprachen: Das kommt von Jahwe! Wir können nichts dazu sagen, weder Schlimmes noch Gutes. ");
INSERT INTO deutkw_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka steht dir zur Verfügung; nimm sie und ziehe hin, damit sie das Weib des Sohnes deines Herrn werde, wie Jahwe geredet hat! ");
INSERT INTO deutkw_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Als nun der Sklave Abrahams diese ihre Worte hörte, verneigte er sich vor Jahwe bis auf die Erde. ");
INSERT INTO deutkw_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Dann zog der Sklave Gold- und Silbersachen und Gewänder hervor und schenkte sie Rebeka; ihrem Bruder aber und ihrer Mutter schenkte er Kleinodien. ");
INSERT INTO deutkw_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Und sie aßen und tranken, er und die Männer, die mit ihm waren, und blieben über Nacht. Am andern Morgen aber, als sie aufgestanden waren, da sprach er: Laßt mich ziehen zu meinen Herrn! ");
INSERT INTO deutkw_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Da sprachen ihr Bruder und ihre Mutter: Laß doch das Mädchen noch einige Tage oder zehn bei uns bleiben, dann mag sie ziehen! ");
INSERT INTO deutkw_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Er aber sprach zu ihnen: Haltet mich nicht auf! Jahwe hat Glück gegeben zu meiner Reise, so entlaßt mich nun, damit ich zu meinem Herrn ziehe. ");
INSERT INTO deutkw_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Da sprachen sie: Wir wollen das Mädchen rufen und sie selbst befragen! ");
INSERT INTO deutkw_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Hierauf riefen sie Rebeka und sprachen zu ihr: Willst du mit diesem Manne ziehen? Sie antwortete: Ja, ich will! ");
INSERT INTO deutkw_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Da ließen sie ihre Schwester Rebeka ziehen mit ihrer Amme und dem Sklaven Abrahams samt seinen Leuten. ");
INSERT INTO deutkw_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Und sie segneten Rebeka und sprachen zu ihr: O Schwester! Werde du zu unzähligen Tausenden, und mögen deine Nachkommen die Thore ihrer Feinde in Besitz nehmen! ");
INSERT INTO deutkw_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Hierauf brachen Rebeka und ihre Dienerinnen auf und setzten sich auf die Kamele und folgten dem Manne; und der Sklave nahm Rebeka und zog von dannen. ");
INSERT INTO deutkw_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Isaak aber war vom “Brunnen des Lebendigen, der mich schaut” gekommen; denn er wohnte im Südland. ");
INSERT INTO deutkw_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Einst war Isaak ausgegangen, um auf dem Felde zu beten, als der Abend anbrach. Als er nun aufblickte, sah er Kamele daherkommen. ");
INSERT INTO deutkw_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Als aber Rebeka aufschaute, erblickte sie den Isaak. Da sprang sie herab vom Kamel ");
INSERT INTO deutkw_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","und sprach zu dem Sklaven: Wer ist der Mann, der uns da auf dem Feld entgegenkommt? Der Sklave antwortete: Es ist mein Herr! Da nahm sie den Schleier und verhüllte sich. ");
INSERT INTO deutkw_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Hierauf erzählte der Sklave dem Isaak alles, was er verrichtet hatte. ");
INSERT INTO deutkw_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isaak aber führte sie hinein ins Zelt seiner Mutter Sara und er nahm Rebeka und sie wurde sein Weib und er gewann sie lieb; so tröstete sich Isaak über den Verlust seiner Mutter. ");
INSERT INTO deutkw_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham aber nahm nochmals ein Weib, Namens Ketura, ");
INSERT INTO deutkw_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","die gebar ihm Simran, Joksan, Medan, Midian, Jisbak und Suah. ");
INSERT INTO deutkw_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Joksan aber erzeugte Saba und Dedan; und die Söhne Dedans waren die Assuriter, die Letusiter und die Leummiter. ");
INSERT INTO deutkw_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Und die Söhne Midians waren Epha, Epher, Hanoch, Abida und Eldaa; diese alle stammen von Ketura. ");
INSERT INTO deutkw_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraham aber übergab alle seine Habe dem Isaak. ");
INSERT INTO deutkw_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Aber den Söhnen der Kebsweiber, die Abraham hatte, gab Abraham Geschenke und ließ sie noch bei seinen Lebzeiten von seinem Sohne Isaak hinweg östlich, in das Ostland ziehen. ");
INSERT INTO deutkw_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Das aber ist die Dauer der Lebensjahre Abrahams, die er durchlebt hat: 175 Jahre. ");
INSERT INTO deutkw_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Und Abraham verschied und starb in schönem Alter, alt und lebenssatt, und wurde versammelt zu seinen Stammesgenossen. ");
INSERT INTO deutkw_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Und es begruben ihn seine Söhne Isaak und Ismael in der Höhle Machpela, auf dem Grundstück des Hethiters Ephron, des Sohnes Zohars, welches Mamre gegenüberliegt, ");
INSERT INTO deutkw_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","auf dem Grundstück, welches Abraham von den Hethitern gekauft hatte: dort wurden Abraham und sein Weib Sara begraben. ");
INSERT INTO deutkw_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Nach dem Tode Abrahams aber segnete Gott seinen Sohn Isaak; Isaak aber wohnte bei dem “Brunnen des Lebendigen, der mich schaut”. ");
INSERT INTO deutkw_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Dies ist die Geschichte Ismaels, des Sohnes Abrahams, den die Ägypterin Hagar, die Leibmagd Saras, dem Abraham geboren hat. ");
INSERT INTO deutkw_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Und dies sind die Namen der Söhne Ismaels nach ihren Namen, nach ihrem Stammbaum: der Erstgeborene Ismaels Nebajoth; Kedar, Adbeel, Mibsam, ");
INSERT INTO deutkw_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Massa, ");
INSERT INTO deutkw_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Thema, Jetur, Naphis und Kedma. ");
INSERT INTO deutkw_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Das sind die Söhne Ismaels, und dies ihre Namen nach ihren Gehöften und Zeltlagern, zwölf Fürsten nach ihren Stammverbänden. ");
INSERT INTO deutkw_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Und dies war die Lebensdauer Ismaels: 137 Jahre. Und er verschied und starb und wurde versammelt zu seinen Stammesgenossen. ");
INSERT INTO deutkw_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Und sie wohnten von Havila an bis nach Sur, welches östlich von Ägypten liegt, bis nach Assur hin; allen seinen Verwandten setzte er sich auf den Nacken. ");
INSERT INTO deutkw_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Das ist die Geschichte Isaaks, des Sohnes Abrahams: Abraham erzeugte den Isaak. ");
INSERT INTO deutkw_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaak aber war vierzig Jahre alt, als er sich Rebeka, die Tochter des Aramäers Bethuel aus Mesopotamien, die Schwester des Aramäers Laban, zum Weibe nahm. ");
INSERT INTO deutkw_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isaak aber bat Jahwe für sein Weib, denn sie war unfruchtbar. Da ließ sich Jahwe von ihm erbitten, und sein Weib Rebeka wurde schwanger. ");
INSERT INTO deutkw_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Es stießen sich aber die Kinder in ihrem Leibe; da sprach sie: Wenn es so steht, warum lebe ich dann? Und sie ging hin, Jahwe zu befragen. ");
INSERT INTO deutkw_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Jahwe aber sprach zu ihr: Zwei Völker sind in deinem Leibe, und zwei Stämme werden aus deinem Schoße hervorgehen, sich zu befehden. Ein Stamm wird dem andern überlegen sein, und der ältere wird dem jüngeren dienstbar werden. ");
INSERT INTO deutkw_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Als nun ihre Zeit da war, daß sie gebären sollte, da fand sich, daß Zwillinge in ihrem Leibe waren. ");
INSERT INTO deutkw_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Da kam der erste heraus, rötlich, ganz und gar wie ein haariger Mantel; darum nannten sie ihn Esau. ");
INSERT INTO deutkw_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Darnach kam sein Bruder heraus, der hielt mit seiner Hand die Ferse Esaus; darum nannte man ihn Jakob. Isaak aber war sechzig Jahre alt, als sie geboren wurden. ");
INSERT INTO deutkw_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Als nun die Knaben heranwuchsen, wurde Esau ein tüchtiger Jäger, ein Mann der Steppe; Jakob dagegen war ein sanfter Mann, der bei den Zelten blieb. ");
INSERT INTO deutkw_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaak aber liebte den Esau, denn Wildbret war nach seinem Geschmack; Rebeka dagegen liebte mehr den Jakob. ");
INSERT INTO deutkw_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Einst kochte Jakob ein Gericht; da kam Esau ganz verschmachtet aus der Steppe. ");
INSERT INTO deutkw_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Und Esau sprach zu Jakob: Laß mich schnell essen von dem roten, dem roten da! denn ich bin ganz verschmachtet. Deshalb nannte man ihn Edom. ");
INSERT INTO deutkw_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Jakob aber sprach: Verkaufe mir zuvor dein Erstgeburtsrecht! ");
INSERT INTO deutkw_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Da sprach Esau: Ach, ich muß schließlich doch sterben; was soll mir da das Erstgeburtsrecht! ");
INSERT INTO deutkw_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Jakob sprach: Schwöre es mir zuvor zu! Da schwur er ihm und verkaufte so an Jakob sein Erstgeburtsrecht. ");
INSERT INTO deutkw_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Jakob aber gab dem Esau Brot und ein Gericht Linsen. Da aß er und trank, stand auf und ging davon; so verscherzte Esau leichtfertig sein Erstgeburtsrecht. ");
INSERT INTO deutkw_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Es kam aber eine Hungersnot über das Land - eine andere, als jene frühere Hungersnot, die zu Abrahams Zeit gewesen war -, da zog Isaak zu Abimelech, dem Könige der Philister, nach Gerar. ");
INSERT INTO deutkw_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Da erschien ihm Jahwe und sprach: ziehe nicht hinab nach Ägypten! Bleibe in dem Lande, das ich dir sagen werde! ");
INSERT INTO deutkw_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Weile als Fremdling in diesem Lande, so will ich mit dir sein und dich segnen. Denn dir und deinen Nachkommen will ich alle diese Länder geben und werde den Schwur aufrecht erhalten, den ich deinem Vater Abraham geschworen habe. ");
INSERT INTO deutkw_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Und ich werde deine Nachkommen so zahlreich werden lassen, wie die Sterne am Himmel, und werde deinen Nachkommen alle diese Länder geben, und durch deine Nachkommen sollen alle Völker auf Erden gesegnet werden, ");
INSERT INTO deutkw_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","zum Lohne dafür, daß Abraham meinem Befehl gehorcht und alles beobachtet hat, was ich von ihm forderte, meine Gebote, meine Satzungen und meine Weisungen. ");
INSERT INTO deutkw_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","So blieb Isaak in Gerar. ");
INSERT INTO deutkw_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Als sich aber die Bewohner des Orts nach seinem Weibe erkundigen, da sprach er: Sie ist meine Schwester! Denn er fürchtete sich zu sagen: Sie ist mein Weib; denn, dachte er, die Bewohner des Orts könnten mich sonst umbringen wegen Rebeka, weil sie so schön ist. ");
INSERT INTO deutkw_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Als er nun längere Zeit dort gewohnt hatte, da schaute einst Abimelech, der König der Philister, zum Fenster hinaus und sah, wie Isaak mit seinem Weibe Rebeka scherzte. ");
INSERT INTO deutkw_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Da ließ Abimelech den Isaak rufen und sprach: Also dein Weib ist sie! Wie konntest du da sagen: Sie ist meine Schwester? Isaak antwortete ihm: Ja, ich dachte, ich könnte ihretwegen etwa gar sterben müssen. ");
INSERT INTO deutkw_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Da sprach Abimelech: Was hast du uns da angethan! Wie leicht konnte irgend einer deinem Weibe beiwohnen, und du hättest damit schwere Schuld auf uns geladen. ");
INSERT INTO deutkw_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Hierauf gebot Abimelech allem Volke: Wer diesen Mann und sein Weib antastet, soll mit dem Tode bestraft werden! ");
INSERT INTO deutkw_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isaak aber säete in jenem Land und erntete in jenem Jahre hundertfältig, denn Jahwe segnete ihn. ");
INSERT INTO deutkw_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","So wurde der Mann reich und wurde immer reicher, bis er sehr reich war; ");
INSERT INTO deutkw_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","und er besaß Schafherden und Rinderherden und viele Leibeigene, so daß die Philister ihn beneideten. ");
INSERT INTO deutkw_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Es hatten aber die Philister alle die Brunnen, welche die Sklaven seines Vaters bei Lebzeiten seines Vaters Abraham gegraben hatten, verschüttet und mit Erde angefüllt. ");
INSERT INTO deutkw_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Da sprach Abimelech zu Isaak: Ziehe hinweg von uns, denn du bist uns zu mächtig geworden! ");
INSERT INTO deutkw_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Da zog Isaak von dort hinweg, schlug sein Lager im Thale von Gerar auf und blieb daselbst. ");
INSERT INTO deutkw_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Hierauf ließ Isaak die Brunnen wieder aufgraben, die die Sklaven seines Vaters Abraham gegraben und welche die Philister nach Abrahams Tode verschüttet hatten, und benannte sie wieder mit den Namen, die ihnen sein Vater gegeben hatte. ");
INSERT INTO deutkw_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Da gruben die Sklaven Isaaks im Thalgrunde nach und fanden daselbst eine Quelle mit fließendem Wasser. ");
INSERT INTO deutkw_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Die Hirten von Gerar aber gerieten in Streit mit den Hirten Isaaks und sprachen: Uns gehört das Wasser! Da nannte er die Quelle “Esek”, weil sie mit ihm gezankt hatten. ");
INSERT INTO deutkw_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Hierauf gruben sie einen anderen Brunnen, aber sie gerieten auch seinetwegen in Streit; daher nannte er ihn “Sitna”. ");
INSERT INTO deutkw_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Dann zog er weiter von dort hinweg und grub einen anderen Brunnen. Über den gerieten sie nicht in Streit; daher nannte er ihn “Rehoboth” und sprach: Nun hat uns Jahwe freien Raum geschafft, daß wir uns ausbreiten können im Lande! ");
INSERT INTO deutkw_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Alsdann zog er von dort hinauf nach Beerseba. ");
INSERT INTO deutkw_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Da erschien ihm Jahwe in selbiger Nacht und sprach: Ich bin der Gott deines Vaters Abraham! Sei getrost, denn ich bin mit dir; und ich will dich segnen und deine Nachkommen zahlreich werden lassen um meines Dieners Abraham willen! ");
INSERT INTO deutkw_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Da erbaute er daselbst einen Altar, rief den Namen Jahwes an und schlug daselbst sein Zelt auf. Hierauf gruben die Sklaven Isaaks dort einen Brunnen. ");
INSERT INTO deutkw_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Es war aber Abimelech mit Ahusat, seinem vertrauten Rat, und mit Pichol, seinem Heerführer, von Gerar zu ihm gekommen. ");
INSERT INTO deutkw_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Da sprach Isaak zu ihnen: Warum kommt ihr zu mir, da ihr doch feindlich gegen mich gesinnt seid und mich von euch getrieben habt? ");
INSERT INTO deutkw_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Sie sprachen: Wir haben wohl gesehen, daß Jahwe mit dir war; da beschlossen wir, es müsse eine gegenseitige Verpflichtung von uns und dir beschworen werden, und wollen einen Vertrag mit dir schließen, ");
INSERT INTO deutkw_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","daß du uns nicht Böses zufügen willst, wie auch wir dich nicht angetastet und dir nur Gutes erwiesen haben, indem wir dich in Frieden ziehen ließen. Du bist nun einmal der Gesegnete Jahwes! ");
INSERT INTO deutkw_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Da bereitete er ihnen ein Mahl, und sie aßen und tranken. ");
INSERT INTO deutkw_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Am andern Morgen früh aber schwuren sie sich gegenseitig; hierauf verabschiedete sie Isaak, und sie gingen in Frieden von ihm. ");
INSERT INTO deutkw_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","An demselben Tage kamen die Sklaven Isaaks und berichteten ihm in betreff des Brunnens, den sie gegraben hatten, und sprachen zu ihm: Wir haben Wasser gefunden! ");
INSERT INTO deutkw_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Da nannte er ihn Siba; daher hießt die Stadt Beerseba bis auf den heutigen Tag. ");
INSERT INTO deutkw_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Als nun Esau vierzig Jahre alt war, heiratete er Judith, die Tochter des Hethiters Beeri, und Basmath, die Tochter des Hethiters Elon. ");
INSERT INTO deutkw_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Die waren ein schwerer Kummer für Isaak und Rebeka. ");
INSERT INTO deutkw_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Als aber Isaak alt geworden war, und seine Augen stumpf waren, daß er nicht mehr sehen konnte, da rief er seinen älteren Sohn Esau und sprach zu ihm: Mein Sohn! Er antwortete ihm: Hier bin ich! ");
INSERT INTO deutkw_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Da sprach er: Ich bin nun alt geworden und weiß nicht, wann ich sterben werde. ");
INSERT INTO deutkw_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","So nimm nun dein Jagdgeräte, deinen Köcher und deinen Bogen, gehe aus in die Steppe und erjage für mich ein Stück Wild. ");
INSERT INTO deutkw_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Dann bereite mir ein Essen, wie ich es gern habe, und bringe es mir herein, daß ich esse; so will ich dir dann meinen Segen geben, bevor ich sterbe. ");
INSERT INTO deutkw_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rebeka aber hatte zugehört, als Isaak so zu seinem Sohn Esau redete. Während nun Esau in die Steppe ging, um ein Wild zu erjagen und heimzubringen, ");
INSERT INTO deutkw_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","sprach Rebeka zu ihrem Sohne Jakob: Eben habe ich zugehört, wie dein Vater zu deinem Bruder Esau redete und ihm gebot: ");
INSERT INTO deutkw_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Hole mir ein Wildbret und bereite mir ein Essen, daß ich esse; so will ich dir dann vor dem Angesicht Jahwes meinen Segen geben, bevor ich sterbe. ");
INSERT INTO deutkw_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Nun aber, mein Sohn, folge meinem Rat und thue, was ich dich heißen werde! ");
INSERT INTO deutkw_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Gehe zur Herde und hole mir von dort zwei schöne Ziegenböckchen, daß ich sie herrichte zu einem Essen für deinen Vater, wie er es gern hat. ");
INSERT INTO deutkw_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Dann muß du es deinem Vater hineinbringen, damit er davon ißt; so soll er dir dann seinen Segen geben, bevor er stirbt. ");
INSERT INTO deutkw_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Jakob aber sprach zu seiner Mutter Rebeka: Ja, aber mein Bruder Esau ist stark behaart, während ich unbehaart bin. ");
INSERT INTO deutkw_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Vielleicht wird mich mein Vater betasten; dann würde ich vor ihm dastehn wie einer, der seinen Spott mit ihm treibt, und würde Fluch über mich bringen und nicht Segen! ");
INSERT INTO deutkw_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Da sprach seine Mutter zu ihm: Auf mich falle der Fluch, der dich treffen könnte, mein Sohn; folge du nur meinem Rat, geh und hole mir! ");
INSERT INTO deutkw_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Da ging er, es zu holen, und brachte es seiner Mutter; seine Mutter aber bereitete ein Essen, wie es sein Vater gern hatte. ");
INSERT INTO deutkw_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Hierauf holte Rebeka die guten Kleider ihres älteren Sohnes Esau, die sie drinnen bei sich hatte, und zog sie ihrem jüngeren Sohne Jakob an. ");
INSERT INTO deutkw_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Die Felle der Ziegenböckchen aber legte sie ihm um seine Hände und um seinen glatten Hals; ");
INSERT INTO deutkw_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","dann gab sie ihrem Sohne Jakob das Essen nebst dem Brot, das sie gebacken hatte, in die Hand. ");
INSERT INTO deutkw_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Da ging er hinein zu seinem Vater und sprach: Mein Vater! Er antwortete: Hier bin ich! Wer bist du, mein Sohn? ");
INSERT INTO deutkw_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Da sprach Jakob zu seinem Vater: Ich bin Esau, dein Erstgeborener; ich habe gethan, wie du mir geboten hast. So setze dich nun auf und iß von meinem Wildbret, damit du mir dann deinen Segen gebest! ");
INSERT INTO deutkw_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Da sprach Isaak zu seinem Sohne: Ei wie schnell hast du etwas gefunden, mein Sohn! Er antwortete: Ja, dein Gott Jahwe ließ es mir in den Weg laufen. ");
INSERT INTO deutkw_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Da sprach Isaak zu Jakob: Tritt einmal näher, daß ich dich bestasten kann, mein Sohn, ob du wirklich mein Sohn Esau bist oder nicht! ");
INSERT INTO deutkw_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Da trat Jakob zu seinem Vater Isaak heran, und als er ihn nun betastet hatte, sprach er: Die Stimme ist Jakobs Stimme, aber die Arme sind Esaus Arme. ");
INSERT INTO deutkw_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Und er erkannte ihn nicht, weil seine Arme behaart waren, wie die seines Bruders Esau, und so segnete er ihn denn. ");
INSERT INTO deutkw_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Da sprach er: Du also bist mein Sohn Esau? Er antwortete: Ja, ich bins! ");
INSERT INTO deutkw_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Da sprach er: So bringe mir es her, damit ich esse von dem Wildbret meines Sohnes; so will ich dir dann meinen Segen geben! Da brachte er es ihm, und er aß; dann brachte er ihm Wein, und er trank. ");
INSERT INTO deutkw_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Hierauf sprach sein Vater Isaak zu ihm: Tritt herzu und küsse mich, mein Sohn! ");
INSERT INTO deutkw_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Als er nun herzutrat und ihn küßte, da roch er den Duft seiner Kleider; und er segnete ihn und sprach: Fürwahr, der Duft meines Sohns ist wie der Duft des Gefildes, das Jahwe gesegnet hat! ");
INSERT INTO deutkw_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Es gebe dir Gott Tau vom Himmel und fetten Boden und Überfluß an Korn und Wein. ");
INSERT INTO deutkw_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Es sollen Völker dir dienstbar werden und Nationen vor dir sich beugen. Du sollst ein Herr sein über deine Brüder, und vor dir sollen sich beugen die Söhne deiner Mutter. Wer irgend dir flucht, der sei verflucht, wer aber dich segnet, soll gesegnet sein! ");
INSERT INTO deutkw_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Als nun Isaak den Segen über Jakob vollendet hatte, und Jakob kaum eben hinweggegangen war von seinem Vater Isaak, da kam sein Bruder Esau heim von der Jagd. ");
INSERT INTO deutkw_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Und er bereitete gleichfalls ein Essen, brachte es seinem Vater hinein und sprach zu seinem Vater: Steh auf, mein Vater, und iß von dem Wildbret deines Sohns, damit du mir alsdann deinen Segen gebest! ");
INSERT INTO deutkw_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Da antwortete ihm sein Vater Isaak: Wer bist du? Er sprach: Ich bin dein erstgeborner Sohn Esau! ");
INSERT INTO deutkw_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Da erschrak Isaak über alle Maßen und sprach: Wer in aller Welt war denn der, der ein Wild erjagt und mir hereingebracht hat, so daß ich von allem aß, ehe du herkamst, und ihm meinen Segen gab? Nun wird er gesegnet bleiben! ");
INSERT INTO deutkw_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Als Esau diese Worte seines Vaters vernahm, da erhob er ein gar lautes und klägliches Geschrei und sprach zu seinem Vater: Segne auch mich, mein Vater! ");
INSERT INTO deutkw_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Er aber sprach: Dein Bruder kam hinterlistigerweise und nahm dir den Segen weg! ");
INSERT INTO deutkw_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Da sprach er: Ja, mit Recht nennt man ihn Jakob! Denn zweimal hat er mich nun überlistet: mein Erstgeburtsrecht hat er genommen und nun hat er mir auch den Segen weggenommen! Dann sprach er: Hast du denn keinen Segen für mich aufbehalten? ");
INSERT INTO deutkw_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Da antwortete Isaak und sprach zu Esau: Ich habe ihn nun einmal zum Herrn über dich gesetzt und alle seine Brüder habe ich ihm als Knechte untergeben und habe ihn reichlich ausgestattet mit Korn und Wein; was in aller Welt könnte ich nun für dich noch thun, mein Sohn? ");
INSERT INTO deutkw_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Da sprach Esau zu seinem Vater: Ist denn das dein einziger Segen, mein Vater? Segne auch mich, mein Vater! und Esau fing laut zu weinen an. ");
INSERT INTO deutkw_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Da antwortete sein Vater Isaak und sprach zu ihm: Fürwahr, fern von fettem Boden wird dein Wohnsitz sein und ohne Anteil am Tau des Himmels droben. ");
INSERT INTO deutkw_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Von deinem Schwerte sollst du leben und deinem Bruder sollst du dienstbar sein. Es wird aber geschehn, wenn du dich anstrengst, wirst du sein Joch abschütteln von deinem Halse. ");
INSERT INTO deutkw_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau aber war Jakob feind wegen des Segens, den ihm sein Vater gegeben hatte; und Esau dachte bei sich: Wenn erst die Zeit der Trauer um meinen Vater herangekommen ist, werde ich meinen Bruder Jakob erschlagen! ");
INSERT INTO deutkw_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Als nun der Rebeka solche Reden ihres älteren Sohnes Esau hinterbracht wurden, ließ sie ihren jüngeren Sohn Jakob rufen und sprach zu ihm: Höre, dein Bruder Esau sinnt auf Rache gegen dich und will dich erschlagen. ");
INSERT INTO deutkw_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Folge daher meinem Rate, mein Sohn! Brich auf, flieh zu meinem Bruder Laban nach Haran ");
INSERT INTO deutkw_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","und bleibe einige Zeit bei ihm, bis sich der Groll deines Bruders legt, ");
INSERT INTO deutkw_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","bis der Zorn deines Bruders von dir abläßt, und er vergißt, was du ihm angethan hast. Dann will ich hinsenden und dich von dort holen lassen. Warum sollte ich euch beide an einem Tage verlieren! ");
INSERT INTO deutkw_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Da sprach Rebeka zu Isaak: Ich bin des Lebens überdrüssig wegen der Hethiterinnen. Wenn Jakob auch so eine Hethiterin, eine Landeseingeborene, zum Weibe nehmen sollte, wozu lebe ich dann noch? ");
INSERT INTO deutkw_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Da rief Isaak Jakob herbei und segnete ihn; und er gebot ihm und sprach zu ihm: Nimm nicht ein Weib von den Töchtern Kanaans. ");
INSERT INTO deutkw_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Mache dich auf und ziehe nach Mesopotamien, zu dem Hause Bethuels, des Vaters deiner Mutter, und hole dir von dort ein Weib, eine der Töchter Labans, des Bruders deiner Mutter. ");
INSERT INTO deutkw_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Und der allmächtige Gott segne dich und mache dich fruchtbar und mehre dich, daß du zu einem Haufen von Völkern werdest. ");
INSERT INTO deutkw_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Und er verleihe dir den Segen Abrahams, dir und deinen Nachkommen mit dir, daß du das Land, in welchem du als Fremdling weilst, welches Gott dem Abraham verliehen hat, zu eigen bekommest. ");
INSERT INTO deutkw_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","So entließ Isaak den Jakob, und er zog nach Mesopotamien zu Laban, dem Sohne Bethuels, des Aramäers, dem Bruder Rebekas, der Mutter Jakobs und Esaus. ");
INSERT INTO deutkw_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Als nun Esau sah, daß Isaak den Jakob gesegnet und ihn nach Mesopotamien geschickt hatte, damit er sich von dort ein Weib hole, indem er ihn segnete und ihm gebot und sprach: Nimm nicht ein Weib von den Töchtern Kanaans! ");
INSERT INTO deutkw_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","und daß Jakob auf seinen Vater und auf seine Mutter hörte und nach Mesopotamien ging, ");
INSERT INTO deutkw_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","da merkte Esau, daß die Töchter Kanaans seinem Vater Isaak mißfielen. ");
INSERT INTO deutkw_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Daher ging Esau zu Ismael und nahm sich Mahalath, die Tochter Ismaels, des Sohnes Abrahams, die Schwester Nebajoths, zu seinen anderen Weibern hinzu zum Weibe. ");
INSERT INTO deutkw_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Da zog Jakob aus von Beerseba und machte sich auf den Weg nach Haran. ");
INSERT INTO deutkw_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Da gelangte er an eine Stätte und blieb daselbst über Nacht, denn die Sonne war untergegangen. Und er nahm einen von den Steinen dieser Stätte, lege ihn zu seinen Häupten und legte sich schlafen an selbiger Stätte. ");
INSERT INTO deutkw_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Da träumte ihm, eine Leiter sei auf die Erde gestellt, deren oberes Ende bis zum Himmel reichte, und die Engel Gottes stiegen auf ihr hinauf und herab. ");
INSERT INTO deutkw_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Und Jahwe stand vor ihm und sprach: Ich bin Jahwe, der Gott deines Vaters Abraham und der Gott Isaaks: das Land, auf dem du liegst, das werde ich dir und deinen Nachkommen verleihen. ");
INSERT INTO deutkw_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Und deine Nachkommen sollen so zahlreich werden, wie die Krümchen der Erde, und du sollst dich ausbreiten nach West und Ost und Nord und Süd, und durch dich sollen alle Völkerstämme auf Erden gesegnet werden und durch deine Nachkommen. ");
INSERT INTO deutkw_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Und ich werde mit dir sein und dich behüten überall, wohin du gehst, und werde dich zurückbringen in dieses Land. Denn ich werde dich nicht verlassen, bis ich ausgeführt, was ich dir verheißen habe! ");
INSERT INTO deutkw_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Da erwachte Jakob aus seinem Schlaf und sprach: Wahrlich, Jahwe ist an dieser Stätte, und ich wußte es nicht! ");
INSERT INTO deutkw_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Da fürchtete er sich und sprach: Wie schauerlich ist diese Stätte! Ja, das ist der Wohnsitz Gottes und die Pforte des Himmels! ");
INSERT INTO deutkw_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Frühmorgens aber nahm Jakob den Stein, den er zu seinen Häupten gelegt hatte, stellte ihn auf als Malstein und goß Öl oben darauf. ");
INSERT INTO deutkw_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Und er gab jener Stätte den Namen Bethel; vorher aber hieß die Stadt Lus. ");
INSERT INTO deutkw_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Und Jakob that ein Gelübde und sprach: Wenn Gott mit mir sein und mich behüten wird auf dem Wege, den ich jetzt gehe, und mir Brot zu essen und Kleider anzuziehen giebt, ");
INSERT INTO deutkw_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","und ich wohlbehalten zum Hause meines Vaters zurückkehren werde, so soll Jahwe mein Gott sein, ");
INSERT INTO deutkw_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","und dieser Stein, den ich als Malstein aufgestellt habe, soll ein Gotteshaus werden, und alles, was du mir geben wirst, werde ich dir getreulich verzehnten. ");
INSERT INTO deutkw_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Da machte sich Jakob auf den Weg und wanderte in das Gebiet der gegen Morgen wohnenden. ");
INSERT INTO deutkw_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Da erblickte er dort in der Steppe einen Brunnen; an dem lagerten gerade drei Herden, denn aus diesem Brunnen pflegten sie die Herden zu tränken. Über dem Brunnenloch aber lag ein schwerer Stein. ");
INSERT INTO deutkw_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Und wenn alle Herden dorthin zusammengetrieben waren, dann wälzten sie den Stein vom Brunnenloch ab und tränkten die Schafe; sodann schafften sie den Stein wieder zurück auf das Brunnenloch an seinen Ort. ");
INSERT INTO deutkw_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Da sprach Jakob zu ihnen: Liebe Brüder! woher seid ihr? Sie antworteten: Von Haran sind wir! ");
INSERT INTO deutkw_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Da sprach er zu ihnen: Kennt ihr Laban, den Sohn Nahors? Sie antworteten: Jawohl! ");
INSERT INTO deutkw_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Da sprach er zu ihnen: Geht es ihm wohl? Sie antworteten: Es geht ihm wohl! Da kommt eben seine Tochter Rahel mit den Schafen! ");
INSERT INTO deutkw_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Da sagte er: Es ist ja noch hoch am Tage und noch zu früh, das Vieh einzutreiben. Tränkt die Schafe und laßt sie dann wieder weiden! ");
INSERT INTO deutkw_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Sie sprachen: Wir können nicht, bis alle Herden zusammengetrieben sind; dann wälzt man den Stein vom Brunnenloch ab, und wir tränken die Schafe. ");
INSERT INTO deutkw_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Während er noch mit ihnen redete, war Rahel mit den Schafen ihres Vaters herangekommen, denn sie hütete die Schafe. ");
INSERT INTO deutkw_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Als nun Jakob die Rahel, die Tochter Labans, des Bruders seiner Mutter, erblickte, dazu die Schafe Labans, des Bruders seiner Mutter, da trat Jakob herzu, wälzte den Stein vom Brunnenloch ab und tränkte die Schafe Labans, des Bruders seiner Mutter. ");
INSERT INTO deutkw_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Hierauf küßte Jakob die Rahel und fing laut zu weinen an. ");
INSERT INTO deutkw_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Und Jakob berichtete der Rahel, daß er ein Vetter ihres Vaters und daß er ein Sohn Rebekas sei; da lief sie hin und berichtete es ihrem Vater. ");
INSERT INTO deutkw_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Als nun Laban solche Kunde über Jakob, den Sohn seiner Schwester, vernahm, da eilte er ihm entgegen, herzte und küßte ihn und führte ihn hinein in sein Haus; er aber erzählte dem Laban alles, was vorangegangen war. ");
INSERT INTO deutkw_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Da sprach Laban zu ihm: Ja, du bist von meinem Bein und Fleisch! Als er nun einen Monat lang bei ihm gewesen war, ");
INSERT INTO deutkw_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","da sprach Laban zu Jakob: Du bist ja doch mein Vetter! Solltest du da umsonst für mich arbeiten? Sage mir, worin soll dein Lohn bestehen? ");
INSERT INTO deutkw_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Nun hatte Laban zwei Töchter; die ältere hieß Lea, die jüngere hieß Rahel. ");
INSERT INTO deutkw_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea aber hatte glanzlose Augen, während Rahel schön von Gestalt und schön von Antlitz war. ");
INSERT INTO deutkw_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Und Jakob liebte die Rahel; darum sprach er: Ich will dir sieben Jahre um Rahel, deine jüngere Tochter, dienen! ");
INSERT INTO deutkw_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban antwortete: Besser, ich gebe sie dir, als daß ich sie einem fremden Manne gebe; bleibe bei mir! ");
INSERT INTO deutkw_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","So diente Jakob um Rahel sieben Jahre, und sie dünkten ihm wie wenige Tage, so lieb hatte er sie. ");
INSERT INTO deutkw_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Darnach sprach Jakob zu Laban: Gieb mir mein Weib - denn meine Zeit ist um -, daß ich ihr beiwohne. ");
INSERT INTO deutkw_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Da lud Laban alle Bewohner des Ortes ein und veranstaltete ein Gastmahl. ");
INSERT INTO deutkw_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Am Abend aber nahm er seine Tochter Lea und brachte sie zu ihm hinein, und er wohnte ihr bei. ");
INSERT INTO deutkw_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Und Laban gab ihr seine Sklavin Silpa, der Lea, seiner Tochter, zur Leibmagd. ");
INSERT INTO deutkw_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Am Morgen aber befand sich, daß es Lea war. Da sprach er zu Laban: Was hast du mir angethan? Habe ich nicht um Rahel bei dir gedient? Warum hast du mich denn betrogen? ");
INSERT INTO deutkw_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban antwortete: Es ist hier zu Lande nicht der Brauch, daß man die Jüngere vor der Älteren weggiebt. ");
INSERT INTO deutkw_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Führe mit dieser die Woche zu Ende, so soll dir auch die andere zu teil werden, um den Dienst, den du noch weitere sieben Jahre bei mir thun wirst! ");
INSERT INTO deutkw_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jakob aber that also und führte die Woche mit ihr zu Ende; alsdann gab er ihm auch seine Tochter Rahel zum Weibe. ");
INSERT INTO deutkw_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Und Laban gab seiner Tochter Rahel seine Sklavin Bilha zur Leibmagd. ");
INSERT INTO deutkw_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Da wohnte er auch der Rahel bei und hatte Rahel lieber, als Lea. Und er diente bei ihm noch weitere sieben Jahre. ");
INSERT INTO deutkw_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Als nun Jahwe sah, daß Lea zurückgesetzt ward, machte er sie fruchtbar, während Rahel unfruchtbar war. ");
INSERT INTO deutkw_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Da wurde Lea schwanger und gebar einen Sohn, den nannte sie Ruben, denn, sprach sie, Jahwe hat mein Elend angesehen. Nun wird mein Mann mich sicherlich lieb haben! ");
INSERT INTO deutkw_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Hierauf wurde sie abermals schwanger und gebar einen Sohn. Da sprach sie: Jahwe hat gehört, daß ich zurückgesetzt bin; darum gab er mir auch diesen. Und sie nannte ihn Simeon. ");
INSERT INTO deutkw_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Hierauf wurde sie abermals schwanger und gebar einen Sohn. Da sprach sie: Nun endlich wird mein Mann mir anhängen, da ich ihm drei Söhne geboren habe; darum nannte sie ihn Levi. ");
INSERT INTO deutkw_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Sodann wurde sie nochmals schwanger und gebar einen Sohn. Da sprach sie: Nunmehr will ich Jahwe preisen! Darum nannte sie ihn Juda. Darnach aber gebar sie weiter kein Kind. ");
INSERT INTO deutkw_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Als nun Rahel sah, daß sie dem Jakob kein Kind gebar, da wurde Rahel eifersüchtig auf ihre Schwester und sprach zu Jakob: Schaffe mir Kinder - wo nicht, so sterbe ich! ");
INSERT INTO deutkw_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Da wurde Jakob zornig über Rahel und sprach: Bin ich denn an Gottes statt, der dir Leibesfrucht versagt hat? ");
INSERT INTO deutkw_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Da sprach sie: Hier ist meine Leibmagd Bilha: wohne ihr bei, damit sie auf meinem Schoß gebäre, und auch ich durch sie zu Kindern komme! ");
INSERT INTO deutkw_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Da gab sie ihm ihre Leibmagd Bilha zum Weibe und Jakob wohnte ihr bei. ");
INSERT INTO deutkw_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Da wurde Bilha schwanger und gebar dem Jakob einen Sohn. ");
INSERT INTO deutkw_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rahel aber sprach: Gott hat mir Recht geschafft und hat mich erhört und mir einen Sohn geschenkt! Darum nannte sie ihn Dan. ");
INSERT INTO deutkw_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Hierauf wurde Bilha, die Leibmagd Rahels, abermals schwanger und gebar dem Jakob einen zweiten Sohn. ");
INSERT INTO deutkw_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Da sprach Rahel: Einen Kampf um Gott habe ich gekämpft mit meiner Schwester und habe gesiegt! Darum nannte sie ihn Naphtali. ");
INSERT INTO deutkw_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Als nun Lea sah, daß sie kein Kind weiter gebar, nahm sie ihre Leibmagd Silpa und gab sie dem Jakob zum Weibe. ");
INSERT INTO deutkw_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Da gebar Silpa, die Leibmagd Leas, dem Jakob einen Sohn. ");
INSERT INTO deutkw_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Da sprach Lea: Glück auf! und nannte ihn Gad. ");
INSERT INTO deutkw_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Hierauf gebar Silpa, die Leibmagd Leas, dem Jakob einen zweiten Sohn. ");
INSERT INTO deutkw_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Da sprach Lea: Ich Glückliche! Ja, glücklich werden mich die Weiber preisen! Daher nannte sie ihn Asser. ");
INSERT INTO deutkw_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ruben aber ging einst aus um die Zeit der Weizenernte und fand Liebesäpfel auf dem Felde; die brachte er seiner Mutter Lea. Da sprach Rahel zu Lea: Gieb mir doch ein paar von den Liebesäpfeln deines Sohnes! ");
INSERT INTO deutkw_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Sie antwortete: ist es nicht genug, daß du mir meinen Mann wegnimmst, daß du nun auch die Liebesäpfel meines Sohnes wegnehmen willst? Da sprach Rahel: Meinetwegen mag er diese Nacht bei dir schlafen zum Entgelt für die Liebesäpfel deines Sohnes. ");
INSERT INTO deutkw_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Als nun Jakob des Abends vom Felde kam, ging ihm Lea entgegen und sprach: Herein zu mir mußt du kommen, denn ich habe vollen Lohn für dich gezahlt mit den Liebesäpfeln meines Sohnes! Und er schlief in jener Nacht bei ihr. ");
INSERT INTO deutkw_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Gott aber erhörte Lea, so daß sie schwanger wurde und Jakob einen fünften Sohn gebar. ");
INSERT INTO deutkw_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Da sprach Lea: Gott hat mir meinen Lohn dafür gegeben, daß ich meinem Manne meine Leibmagd abgetreten habe. Daher nannte sie ihn Issachar. ");
INSERT INTO deutkw_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Hierauf wurde Lea abermals schwanger und gebar dem Jakob einen sechsten Sohn. ");
INSERT INTO deutkw_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Da sprach Lea: Gott hat mich beschenkt mit einem schönen Geschenk; nunmehr wird mein Mann mich hochhalten, weil ich ihm sechs Söhne geboren habe! Darum nannte sie ihn Sebulon. ");
INSERT INTO deutkw_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Darnach aber gebar sie eine Tochter, die nannte sie Dina. ");
INSERT INTO deutkw_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Da gedachte Gott an Rahel und Gott erhörte sie und machte sie fruchtbar. ");
INSERT INTO deutkw_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Da wurde sie schwanger und gebar einen Sohn. Da sprach sie: Gott hat meine Schmach hinweggenommen! ");
INSERT INTO deutkw_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Darum nannte sie ihn Joseph, indem sie sprach: Möge mir Jahwe noch einen Sohn schenken! ");
INSERT INTO deutkw_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Als nun Rahel den Joseph geboren hatte, sprach Jakob zu Laban: Laß mich heimziehen in mein Vaterland! ");
INSERT INTO deutkw_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Gieb mir meine Weiber und meine Kinder, um die ich dir gedient habe, daß ich abziehe; denn du weißt ja selbst, wie ich dir gedient habe! ");
INSERT INTO deutkw_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Da antwortete ihm Laban: Wenn ich dir irgend etwas gelte - ich spüre, daß mich Jahwe gesegnet hat um deinetwillen. ");
INSERT INTO deutkw_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Da erwiderte er: Nenne den Lohn, den du von mir forderst, so will ich dir ihn geben! ");
INSERT INTO deutkw_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Da erwiderte er ihm: Du weißt, wie ich dir gedient habe, und was aus deinem Viehstand bei mir geworden ist. ");
INSERT INTO deutkw_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Denn wenig war, was du besaßest, ehe ich herkam; aber es wuchs mit Macht, und Jahwe ließ jedem meiner Tritte Segen für dich nachfolgen - nun aber, wann soll denn ich für meine Familie sorgen? ");
INSERT INTO deutkw_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Da erwiderte er: Was soll ich dir geben? Jakob sprach: Du sollst mir gar nichts geben. Wenn du mir Folgendes zugestehst, so will ich aufs neue deine Schafe weiden und hüten. ");
INSERT INTO deutkw_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ich werde heute alle deine Schafe durchgehn und aus ihnen jedes gesprenkelte und scheckige Stück entfernen - alles, was schwarz ist unter den Lämmern und was scheckig und gesprenkelt ist unter den Ziegen. Und das soll mein Lohn sein, ");
INSERT INTO deutkw_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","und darin wird sich meine Redlichkeit erweisen: wenn du künftig meinen Lohn in Augenschein nimmst, dann soll alles, was nicht gesprenkelt und scheckig ist unter meinen Ziegen und was nicht schwarz ist unter meinen Lämmern, als gestohlen gelten. ");
INSERT INTO deutkw_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Da erwiderte Laban: Gut! Es sei, wie du gesagt hast! ");
INSERT INTO deutkw_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Und er entfernte an selbigem Tage die gestreiften und scheckigen Böcke und alle gesprenkelten und scheckigen Ziegen - alles, woran irgend etwas Weißes war - und alles, was schwarz war unter den Lämmern, und übergab es seinen Söhnen. ");
INSERT INTO deutkw_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Und er machte einen Zwischenraum von drei Tagereisen zwischen sich und Jakob; Jakob aber weidete die übrigen Schafe Labans. ");
INSERT INTO deutkw_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Da holte sich Jakob frische Stäbe von Storaxstauden, Mandelbäumen und Platanen und schälte an ihnen weiße Streifen heraus, indem er das Weiße an den Stäben bloßlegte. ");
INSERT INTO deutkw_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Dann stellte er die Stäbe, die er geschält hatte, in die Tränkrinnen, in die Wasserrinnen, wohin die Schafe zur Tränke kamen, gerade vor die Schafe hin. Und sie begatteten sich, wenn sie zur Tränke kamen. ");
INSERT INTO deutkw_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","So begatteten sich die Schafe angesichts der Stäbe; dann warfen die Schafe gestreifte, gesprenkelte und scheckige. ");
INSERT INTO deutkw_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Die Lämmer aber sonderte Jakob ab und kehrte die Gesichter der Schafe gegen alle gestreiften und schwarzen Stücke unter den Schafen Labans; so legte er sich besondere Herden an, die that er nicht zu den Schafen Labans. ");
INSERT INTO deutkw_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Und so oft die Brunstzeit der kräftigen Tiere kam, legte Jakob den Schafen die Stäbe vor Augen in die Rinnen, damit sie sich vor den Stäben begatteten. ");
INSERT INTO deutkw_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Waren es aber die schwachen Tiere, so legte er sie nicht hin; daher wurden die schwachen dem Laban, die kräftigen aber dem Jakob zu teil. ");
INSERT INTO deutkw_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","So wurde der Mann über die Maßen reich und gelangte zu vielen Schafen und Sklavinnen und Sklaven und Kamelen und Eseln. ");
INSERT INTO deutkw_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Da kam ihm zu Ohren, welche Reden die Söhne Labans führten: Jakob hat alles an sich gebracht, was unserem Vater gehörte, und von dem, was unserem Vater gehörte, hat er all diesen Reichtum zuwege gebracht. ");
INSERT INTO deutkw_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Und Jakob achtete auf die Mienen Labans; der aber bezeigte sich nicht mehr gegen ihn, wie früher. ");
INSERT INTO deutkw_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Da sprach Jahwe zu Jakob: Kehre zurück in das Land deiner Väter und zu deiner Verwandtschaft, so will ich mit dir sein. ");
INSERT INTO deutkw_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Da sandte Jakob hin und ließ Rahel und Lea rufen auf das Feld zu seiner Herde. ");
INSERT INTO deutkw_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Da sprach er zu ihnen: Ich sehe wohl, daß mir euer Vater nicht mehr dasselbe Gesicht zeigt, wie früher; aber der Gott meines Vaters war mit mir. ");
INSERT INTO deutkw_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ihr wißt, daß ich aus allen meinen Kräften eurem Vater gedient habe. ");
INSERT INTO deutkw_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Euer Vater aber hat mich betrogen und mir den Lohn zehnmal abgeändert; aber Gott ließ nicht zu, daß er mir Schaden zufügte. ");
INSERT INTO deutkw_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Wenn er sprach: die gesprenkelten sollen dein Lohn sein, so warf die ganze Herde gesprenkelte, sprach er dagegen: die gestreiften sollen dein Lohn sein, so warf die ganze Herde gestreifte. ");
INSERT INTO deutkw_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Und so entzog Gott eurem Vater das Vieh und gab es mir. ");
INSERT INTO deutkw_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Zu der Zeit aber, wo die Schafe brünstig wurden, da sah ich deutlich im Traum, wie die Böcke, die die Schafe besprangen, gestreift, gesprenkelt und gescheckt waren. ");
INSERT INTO deutkw_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Und der Engel Gottes sprach zu mir im Traum: Jakob! Ich antwortete: Hier bin ich! ");
INSERT INTO deutkw_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Da sagte er: Sieh einmal, wie alle Böcke, die die Schafe bespringen, gestreift, gesprenkelt und gescheckt sind. Denn ich habe alles gesehen, was Laban dir anthut. ");
INSERT INTO deutkw_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ich bin der Gott von Bethel, woselbst du einen Malstein gesalbt, woselbst du mir ein Gelübde gethan hast. So mache dich nun auf, ziehe aus diesem Lande und kehre zurück in dein Heimatland. ");
INSERT INTO deutkw_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Da erwiderten Rahel und Lea und sprachen zu ihm: Haben wir etwa noch Teil und Erbe im Hause unseres Vaters? ");
INSERT INTO deutkw_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Gelten wir ihm nicht als Fremde, nachdem er uns verkauft und das Geld, das er für uns bekam, längst verzehrt hat? ");
INSERT INTO deutkw_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Denn all der Reichtum, den Gott unserem Vater entzogen hat, gehört uns und unseren Kindern. So thue du nur ganz, wie Gott zu dir gesagt hat! ");
INSERT INTO deutkw_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Da setzte Jakob seine Kinder und seine Weiber auf die Kamele; ");
INSERT INTO deutkw_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","sodann führte er all sein Vieh hinweg und alle seine Habe, die er erworben hatte, das Vieh, das er besaß, welches er in Mesopotamien erworben hatte, um sich zu seinem Vater Isaak ins Land Kanaan zu begeben. ");
INSERT INTO deutkw_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Während aber Laban hingegangen war, seine Schafe zu scheren, stahl Rahel den Teraphim ihres Vaters. ");
INSERT INTO deutkw_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Und Jakob überlistete Laban, den Aramäer, weil er ihm verheimlichte, daß er fliehen wolle. ");
INSERT INTO deutkw_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Also entfloh er mit allem, was ihm gehörte; und er brach auf, setzte über den Strom und schlug die Richtung nach dem Gebirge Gilead ein. ");
INSERT INTO deutkw_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Am dritten Tage wurde dem Laban hinterbracht, daß Jakob entflohen sei. ");
INSERT INTO deutkw_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Da nahm er seine Stammesgenossen mit sich, verfolgte ihn sieben Tagereisen weit und ereilte ihn auf dem Gebirge Gilead. ");
INSERT INTO deutkw_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Gott aber kam des Nachts im Traum zu Laban, dem Aramäer, und sprach zu ihm: Hüte dich, Jakob ein böses Wort zu sagen! ");
INSERT INTO deutkw_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Da erreichte Laban den Jakob; Jakob aber hatte sein Zelt auf dem Gebirge aufgeschlagen, während Laban mit seinen Stammesgenossen sein Zelt auf dem Gebirge Gilead aufgeschlagen hatte. ");
INSERT INTO deutkw_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Da sprach Laban zu Jakob: Was soll das heißen, daß du mich überlisten wolltest und führtest meine Töchter fort wie Kriegsgefangene? ");
INSERT INTO deutkw_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Warum bist du heimlich geflohen und täuschtest mich und hast es mich nicht wissen lassen, daß ich dir hätte das Geleite geben können mit Jauchzen und Gesängen, mit Pauken und Harfen, ");
INSERT INTO deutkw_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","und hast mich meine Enkel und Töchter nicht küssen lassen? Ja, du hast thöricht gehandelt! ");
INSERT INTO deutkw_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ich hätte es wohl in der Gewalt, schlimm mit euch zu verfahren; aber der Gott deines Vaters hat in der vergangenen Nacht zu mir gesagt: Hüte dich, Jakob ein böses Wort zu sagen! ");
INSERT INTO deutkw_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Aber mag es sein, du bist nun einmal fortgegangen, weil du dich gar so sehr nach deiner Heimat sehntest - warum hast du meinen Gott gestohlen? ");
INSERT INTO deutkw_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Da antwortete Jakob und sprach zu Laban: Ja, ich fürchtete mich; denn ich dachte, du könntest mir deine Töchter entreißen. ");
INSERT INTO deutkw_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Derjenige, bei dem du deinen Gott findest, der soll nicht am Leben bleiben! Im Beisein unserer Stammesgenossen untersuche, was ich bei mir habe, und nimm dir. Jakob aber wußte nichts davon, daß Rahel ihn gestohlen hatte. ");
INSERT INTO deutkw_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Da ging Laban in das Zelt Jakobs und das Zelt Leas und in das Zelt der beiden Leibmägde und fand nichts; dann verließ er das Zelt Leas und trat in das Zelt Rahels. ");
INSERT INTO deutkw_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rahel aber hatte den Teraphim genommen, in die Kamelsänfte gelegt und sich darauf gesetzt. Und Laban durchstöberte das ganze Zelt, fand aber nichts. ");
INSERT INTO deutkw_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Da sprach sie zu ihrem Vater: O Herr, sei nicht böse, wenn ich vor dir nicht aufstehen kann; es ergeht mir, wie es den Frauen ergeht! Und er suchte und suchte, fand aber den Teraphim nicht. ");
INSERT INTO deutkw_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Jakob aber wurde zornig und schalt Laban. Und Jakob hob an und sprach zu Laban: Was habe ich verschuldet, was habe ich gefehlt, daß du mir so hitzig nachgesetzt bist? ");
INSERT INTO deutkw_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Du hast nun meinen ganzen Hausrat durchstöbert - hast du irgend etwas von deinem Hausgerät gefunden? Lege es hierher vor meine und deine Stammesgenossen, damit sie entscheiden, wer von uns beiden recht hat. ");
INSERT INTO deutkw_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Zwanzig Jahre sind es nun, daß ich bei dir bin; deine Mutterschafe und deine Ziegen haben nie eine Fehlgeburt gethan, und Widder aus deiner Herde habe ich nicht gegessen. ");
INSERT INTO deutkw_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Was zerrissen ward, habe ich dir nicht gebracht - ich selbst mußte es ersetzen; von mir fordertest du es, mochte es bei Tage oder bei Nacht geraubt sein. ");
INSERT INTO deutkw_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Bei Tage verging ich vor Hitze und des Nachts vor Frost, und kein Schlaf kam in meine Augen. ");
INSERT INTO deutkw_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Volle zwanzig Jahre habe ich dir in deinem Hause gedient: vierzehn Jahre um deine beiden Töchter und sechs Jahre um Schafe von dir; aber zehnmal ändertest du meinen Lohn! ");
INSERT INTO deutkw_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Wenn nicht der Gott meines Ahnherrn, der Gott Abrahams, er, den auch Isaak fürchtet, für mich gewesen wäre, - ja dann hättest du mich mit leeren Händen ziehen lassen! Wie ich geplagt war und mich abgearbeitet habe, hat Gott gesehen und darnach in vergangener Nacht entschieden. ");
INSERT INTO deutkw_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Da antwortete Laban und sprach zu Jakob: Mein sind die Frauen und mein sind die Kinder und mein ist das Vieh, und alles, was du erblickst, das ist mein. Aber was kann ich nun machen gegenüber diesen meinen Töchtern oder den Kindern, die sie geboren haben? ");
INSERT INTO deutkw_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Aber wohlan, laß uns einen Vertrag miteinander schließen; der soll dann Zeuge sein zwischen mir und dir. ");
INSERT INTO deutkw_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Hierauf nahm Jakob einen Stein und richtete ihn auf als Malstein. ");
INSERT INTO deutkw_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Da sprach Jakob zu seinen Stammesgenossen: Lest Steine auf! Da lasen sie Steine auf und errichteten einen Steinhaufen; dann hielten sie dort auf dem Steinhaufen das Mahl. ");
INSERT INTO deutkw_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Und Laban nannte ihn Jegar Sahadutha; Jakob aber nannte ihn Galed. ");
INSERT INTO deutkw_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Da sprach Laban: Dieser Steinhaufe ist nunmehr Zeuge zwischen mir und dir - deshalb nannte er ihn Galed - ");
INSERT INTO deutkw_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","und die Warte, indem er sprach: Jahwe möge Wache halten zwischen mir und dir, wenn wir einander ferngerückt sind. ");
INSERT INTO deutkw_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Wenn du etwa meine Töchter schlecht behandeln oder noch mehr Weiber zu meinen Töchtern hinzunehmen wolltest - wenn dann niemand bei uns ist: bedenke wohl, Gott ist Zeuge zwischen mir und dir! ");
INSERT INTO deutkw_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Da sprach Laban zu Jakob: Wohlan, dieser Steinhaufe und der Malstein, den ich aufgerichtet habe zwischen mir und dir - ");
INSERT INTO deutkw_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Zeuge soll sein dieser Steinhaufe und Zeuge soll sein der Malstein; weder ich darf über diesen Steinhaufen hinausgehen zu dir hinüber, noch darfst du über diesen Steinhaufen und diesen Malstein in böser Absicht hinausgehen zu mir herüber. ");
INSERT INTO deutkw_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Der Gott Abrahams und der Gott Nahors sei Richter zwischen uns, der Gott ihres Vaters. Jakob aber schwur bei dem, den sein Vater Isaak fürchtete. ");
INSERT INTO deutkw_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Hierauf schlachtete Jakob Opfertiere auf dem Berge und lud seine Stammesgenossen ein, das Mahl zu halten. Da hielten sie das Mahl und übernachteten auf dem Berge. ");
INSERT INTO deutkw_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Am andern Morgen früh aber küßte Laban seine Enkel und seine Töchter und nahm Abschied von ihnen. Sodann brach Laban auf und kehrte zurück an seinen Wohnsitz. ");
INSERT INTO deutkw_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Auch Jakob war seines Wegs gezogen; da begegneten ihm die Engel Gottes. ");
INSERT INTO deutkw_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Da sprach Jakob, als er sie erblickte: Das ist das Heerlager Gottes! Daher nannte er jenen Ort Mahanaim. ");
INSERT INTO deutkw_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Jakob aber sandte Boten voraus an seinen Bruder Esau nach Seir, ins Edomiterland, ");
INSERT INTO deutkw_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","und trug ihnen Folgendes auf: So sollt ihr sagen zu meinem Gebieter Esau: Dein Sklave Jakob läßt dir sagen: bei Laban habe ich geweilt und verzog dort bis jetzt. ");
INSERT INTO deutkw_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Ich kam aber in den Besitz von Rindern, Eseln und Schafen, Sklaven und Sklavinnen, und sende nun meinem Gebieter Botschaft, damit du mir wohlgeneigt werdest. ");
INSERT INTO deutkw_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Es kehrten aber die Boten zu Jakob zurück und meldeten: Wir trafen deinen Bruder Esau, als er schon unterwegs war, dir entgegenzuziehen in Begleitung von 400 Mann. ");
INSERT INTO deutkw_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Da geriet Jakob in große Furcht, und es wurde ihm bange. Sodann teilte er die Leute, die er bei sich hatte, sowie die Schafe, die Rinder und die Kamele, in zwei Heerlager. ");
INSERT INTO deutkw_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Denn er dachte: Wenn Esau das eine Lager überfällt und niedermetzelt, so kann doch das andere Lager entrinnen! ");
INSERT INTO deutkw_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Und Jakob sprach: Du Gott meines Ahnherrn Abraham und meines Vaters Isaak, Jahwe, der du zu mir sprachst: Kehre heim in dein Vaterland und zu deiner Verwandtschaft, und ich will sorgen, daß es dir wohlgeht! - ");
INSERT INTO deutkw_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","ich bin nicht wert aller der Wohlthaten und aller der Treue, die du deinem Diener bewiesen hast. Denn nur mit meinem Stab überschritt ich den Jordan da, und jetzt gebiete ich über zwei Heerlager. ");
INSERT INTO deutkw_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ach, errette mich aus der Gewalt meines Bruders, aus der Gewalt Esaus; denn ich fürchte mich vor ihm, daß er nicht etwa kommt und uns niedermetzelt, Mütter samt Kindern. ");
INSERT INTO deutkw_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Du aber hast ja verheißen: ich will sorgen, daß es dir wohlgehe, und will deine Nachkommen so zahlreich werden lassen, wie die Sandkörner am Meere, die nicht zu zählen sind vor Menge! ");
INSERT INTO deutkw_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Und er blieb dort über Nacht. Hierauf schied er einen Teil seines Besitzes aus zu einem Geschenk für seinen Bruder Esau: ");
INSERT INTO deutkw_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","200 Ziegen und 20 Böcke, 200 Mutterschafe und 20 Widder, ");
INSERT INTO deutkw_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","30 säugende Kamelinnen mit ihren Füllen, 40 junge Kühe und 10 junge Stiere, 20 Eselinnen und 10 Eselsfüllen; ");
INSERT INTO deutkw_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","diese übergab er seinen Sklaven, jede Herde besonders, und gebot seinen Sklaven: Zieht voraus und laßt jedesmal einen Zwischenraum zwischen den Herden! ");
INSERT INTO deutkw_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Sodann wies er den vordersten an: Wenn mein Bruder Esau auf dich stößt und dich fragt: Wem gehörst du an und wohin willst du und wem gehören diese da vor dir? ");
INSERT INTO deutkw_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","so sprich: Sie sind ein Geschenk deines Sklaven Jakob, das für meinen Gebieter Esau bestimmt ist; er selbst aber folgt uns auf dem Fuße nach. ");
INSERT INTO deutkw_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Ebenso wies er auch den zweiten und den dritten und alle übrigen an, welche die Herden trieben, und sprach: Ganz ebenso sollt ihr zu Esau sagen, wenn ihr ihn antrefft, ");
INSERT INTO deutkw_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","und sollt sprechen: Dein Sklave Jakob selbst folgt uns auf dem Fuße nach. Er dachte nämlich: Ich will ihn besänftigen mit dem Geschenk, das mir vorausgeht; erst dann will ich ihm unter die Augen treten, vielleicht wird er mich gnädig aufnehmen. ");
INSERT INTO deutkw_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","So ging also das Geschenk voraus, während er selbst jene Nacht im Lager zubrachte. ");
INSERT INTO deutkw_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Sodann erhob er sich in jener Nacht und überschritt mit seinen beiden Frauen, seinen beiden Leibmägden und seinen elf Söhnen die Furt des Jabbok. ");
INSERT INTO deutkw_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Hierauf brachte er sie über den Fluß hinüber und brachte hinüber alles, was ihm gehörte. ");
INSERT INTO deutkw_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Jakob aber blieb allein zurück. Da rang einer mit ihm bis zum Anbruch der Morgenröte. ");
INSERT INTO deutkw_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Und als er sah, daß er ihn nicht bezwingen könne, schlug er ihn auf die Hüftpfanne, so daß die Hüftpfanne Jakobs verrenkt ward, während er mit ihm rang. ");
INSERT INTO deutkw_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Da sprach jener: Laß mich los, denn die Morgenröte bricht an! Er antwortete: Ich lasse dich nicht los, außer, du segnest mich! ");
INSERT INTO deutkw_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Da fragte er ihn: Wie heißest du? Er antwortete: Jakob! ");
INSERT INTO deutkw_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Da sprach er: Du sollst künftig nicht mehr Jakob heißen, sondern Israel; denn du hast mit Gott und mit Menschen gekämpft und bist Sieger geblieben. ");
INSERT INTO deutkw_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Da bat Jakob: Thue mir doch deinen Namen kund! Er antwortete: Warum fragst du doch nach meinem Namen? Sodann segnete er ihn daselbst. ");
INSERT INTO deutkw_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Jakob aber nannte jene Stätte Pniel; denn, sprach er, ich habe Gott von Angesicht zu Angesicht gesehen und kam doch mit dem Leben davon. ");
INSERT INTO deutkw_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Und als er an Pniel vorüber war, ging die Sonne auf; er hinkte aber wegen seiner Hüfte. ");
INSERT INTO deutkw_vpl VALUES ("GN32_33","002_32_33","GEN","32","33","33","Darum essen die Israeliten bis auf den heutigen Tag die Spannader nicht, die über die Hüftpfanne läuft, weil er Jakob auf die Hüftpfanne, die Spannader, geschlagen hat. ");
INSERT INTO deutkw_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Als nun Jakob gewahrte, daß Esau herankam in Begleitung von 400 Mann, da verteilte er die Kinder auf Lea und Rahel und die beiden Leibmägde. ");
INSERT INTO deutkw_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Und zwar stellte er die Leibmägde mit ihren Kindern an die Spitze, dahinter Lea mit ihren Kindern und dahinter Rahel mit Joseph. ");
INSERT INTO deutkw_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Er selbst aber ging voraus und verneigte sich siebenmal bis auf den Boden, bis er ganz nahe an seinen Bruder herangekommen war. ");
INSERT INTO deutkw_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Da lief ihm Esau entgegen und schloß ihn in seine Arme, fiel ihm um den Hals und küßte ihn, und sie weinten. ");
INSERT INTO deutkw_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Als er aber aufblickte und die Frauen mit den Kindern gewahrte, fragte er: Wer sind denn diese da bei dir? Er antwortete: Die Kinder, die Gott deinem Sklaven geschenkt hat! ");
INSERT INTO deutkw_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Da traten die Leibmägde mit ihren Kindern herzu und verneigten sich; ");
INSERT INTO deutkw_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","sodann traten auch Lea und ihre Kinder herzu und verneigten sich, und darnach trat Joseph herzu und Rahel und verneigten sich. ");
INSERT INTO deutkw_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Da fragte er: Was wolltest du denn mit diesem ganzen Zug, auf den ich stieß? Er erwiderte: Ich wünschte meinen Gebieter freundlich zu stimmen. ");
INSERT INTO deutkw_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Da sprach Esau: Ich habe Besitztum genug; behalte, lieber Bruder, was dir gehört! ");
INSERT INTO deutkw_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Jakob erwiderte: Nicht doch! Wenn ich dir irgend etwas gelte, so mußt du meine Gabe von mir annehmen. Habe ich ja doch dein Antlitz erschaut, wie das eines himmlischen Wesens, indem du mich zu Gnaden annahmst. ");
INSERT INTO deutkw_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Nimm doch das Begrüßungs-Geschenk von mir an, das dir überbracht worden ist; denn Gott hat mich reich gesegnet, und ich habe vollauf! So drang er in ihn, bis er es annahm. ");
INSERT INTO deutkw_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Hierauf sagte er: Laß uns aufbrechen und weiter ziehen; ich aber will vor dir herziehen. ");
INSERT INTO deutkw_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Er antwortete ihm: Mein Gebieter sieht selbst, daß die Kinder noch zart sind, und unter den Schafen und Rindern sind säugende Tiere; wollte ich die auch nur einen Tag lang über Gebühr anstrengen, so würde die ganze Herde sterben. ");
INSERT INTO deutkw_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Mein Gebieter wolle doch vor seinem Sklaven vorausziehen; ich aber werde in aller Gemächlichkeit weiterziehen, so wie es die Kräfte der Herde, die ich zu treiben habe, und die Kräfte der Kinder zulassen, bis ich zu meinem Gebieter nach Seir gelange. ");
INSERT INTO deutkw_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Da erwiderte Esau: So will ich wenigstens einen Teil der Leute, die ich bei mir habe, bei dir lassen! Er antwortete: Wozu doch? Möchte ich nur Gnade in den Augen meines Gebieters finden! ");
INSERT INTO deutkw_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","So zog Esau an jenem Tage wiederum seines Wegs nach Seir. ");
INSERT INTO deutkw_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Jakob aber zog weiter nach Sukkoth und erbaute sich ein Haus; für sein Vieh aber errichtete er Laubhütten. Daher nennt man den Ort Sukkoth. ");
INSERT INTO deutkw_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Und Jakob gelangte wohlbehalten nach der Stadt Sichems, die im Lande Kanaan liegt, als er aus Mesopotamien kam. Und er schlug vor der Stadt sein Lager auf. ");
INSERT INTO deutkw_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Das Stück Feld aber, auf dem er sein Zelt aufgeschlagen hatte, erwarb er von den Söhnen Hemors, des Vaters Sichems, um den Preis von 100 Kesita. ");
INSERT INTO deutkw_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Und er stellte daselbst einen Altar auf und nannte ihn El, Gott Israels. ");
INSERT INTO deutkw_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Als nun einst Dina, die Tochter Leas, die sie Jakob geboren hatte, ausging, um die Bewohnerinnen des Landes zu besuchen, ");
INSERT INTO deutkw_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","da erblickte sie Sichem, der Sohn des Heviters Hemor, des Landesfürsten; der ergriff sie, wohnte ihr bei und vergewaltigte sie. ");
INSERT INTO deutkw_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Und er hing mit ganzer Seele an Dina, der Tochter Jakobs, und gewann das Mädchen lieb und suchte das Mädchen zu beruhigen. ");
INSERT INTO deutkw_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Hierauf bat Sichem seinen Vater Hemor: Wirb für mich um dieses Mädchen, daß sie mein Weib werde! ");
INSERT INTO deutkw_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Jakob aber hatte es erfahren, daß er seine Tochter Dina geschändet habe; seine Söhne aber waren mit seinem Vieh auf dem Weideplatz, und Jakob unternahm nichts bis zu ihrer Rückkehr. ");
INSERT INTO deutkw_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Da begab sich Hemor, der Vater Sichems, zu Jakob, um mit ihm Rücksprache zu nehmen. ");
INSERT INTO deutkw_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Als nun die Söhne Jakobs vom Weideplatz kamen und es hörten, da wurden sie erbittert und gerieten in großen Zorn. Denn damit, daß er die Tochter Jakobs beschlief, hatte er gethan, was als eine schwere Schandthat in Israel empfunden wurde; derartiges hätte nimmermehr geschehen sollen! ");
INSERT INTO deutkw_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Und Hemor nahm das Wort und sprach zu ihnen: Mein Sohn Sichem hat sein Herz an das Mädchen aus eurer Familie gehängt; bitte, gebt sie ihm zum Weibe ");
INSERT INTO deutkw_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","und verschwägert euch mit uns. Ihr gebt uns eure Töchter und nehmt euch unsere Töchter ");
INSERT INTO deutkw_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","und bleibt bei uns wohnen: das Land soll euch offen stehen; bleibt da und zieht in ihm umher und setzt euch fest darin! ");
INSERT INTO deutkw_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sichem aber sprach zu ihrem Vater und zu ihren Brüdern: Möchte ich doch Gnade finden in euren Augen! Was ihr auch fordern mögt, ich will es geben! ");
INSERT INTO deutkw_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Mögt ihr noch so viel an Morgengabe und Geschenken von mir verlangen, ich will's geben, wie ihr es von mir fordern werdet; nur gebt mir das Mädchen zum Weibe! ");
INSERT INTO deutkw_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Da antworteten die Söhne Jakobs dem Sichem und seinem Vater Hemor und redeten mit Arglist, weil er ihre Schwester Dina geschändet hatte, ");
INSERT INTO deutkw_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","und sprachen zu ihnen: Wir können uns nicht darauf einlassen, unsere Schwester einem Manne zu geben, der nicht beschnitten ist; denn dies gilt uns als schmachvoll. ");
INSERT INTO deutkw_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Nur unter der Bedingung wollen wir euch willfahren, wenn ihr werden wollt, wie wir, indem ihr alles, was männlich ist unter euch, beschneiden laßt. ");
INSERT INTO deutkw_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Dann wollen wir euch unsere Töchter geben und uns eure Töchter nehmen und wollen bei euch wohnen bleiben, damit wir zu einem Volke werden. ");
INSERT INTO deutkw_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Wollt ihr aber nicht darein willigen, euch beschneiden zu lassen, so nehmen wir unsere Tochter und ziehen fort! ");
INSERT INTO deutkw_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Ihr Vorschlag gefiel Hemor und Sichem, dem Sohn Hemors. ");
INSERT INTO deutkw_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Und der Jüngling zögerte nicht, so zu thun; denn er hatte Gefallen an der Tochter Jakobs, und er war der Angesehenste in seiner ganzen Familie. ");
INSERT INTO deutkw_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Da begaben sich Hemor und sein Sohn Sichem zum Stadtthor und redeten also zu ihren Mitbürgern: ");
INSERT INTO deutkw_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Diese Männer sind friedlich gegen uns gesinnt. Laßt sie sich ansiedeln im Lande und es durchziehen; hat doch das Land Raum für sie nach allen Seiten! Ihre Töchter wollen wir uns zu Weibern nehmen und ihnen unsere Töchter geben. ");
INSERT INTO deutkw_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Jedoch nur unter der Bedingung sind diese Männer willens, bei uns wohnen zu bleiben, damit wir zu einem Volke werden, wenn sich alles, was männlich ist unter uns, beschneiden läßt, wie sie selbst beschnitten sind. ");
INSERT INTO deutkw_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ihre Herden und ihre Habe und all ihr Vieh wird dann uns gehören. So wollen wir ihnen doch zu Willen sein, damit sie bei uns wohnen bleiben. ");
INSERT INTO deutkw_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Da fügten sie sich dem Vorschlage Hemors und seines Sohnes Sichem, so viele ihrer durch das Thor seiner Stadt aus und ein gingen, und alle Männer, so viele ihrer durch das Thor seiner Stadt aus und ein gingen, ließen sich beschneiden. ");
INSERT INTO deutkw_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Am dritten Tage aber, als sie wundkrank waren, da griffen die beiden Söhne Jakobs, Simeon und Levi, die Brüder der Dina, zum Schwert, überfielen die arglose Stadt und erschlugen alle Männer. ");
INSERT INTO deutkw_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Auch Hemor und seinen Sohn Sichem töteten sie mit dem Schwert, holten Dina aus dem Hause Sichems und zogen ab. ");
INSERT INTO deutkw_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Die Söhne Jakobs fielen über die Erschlagenen her und plünderten die Stadt, weil man ihre Schwester geschändet hatte. ");
INSERT INTO deutkw_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ihre Schafe, Rinder, Esel und was in der Stadt und was draußen war, nahmen sie weg ");
INSERT INTO deutkw_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","und alle ihre Habe und alle ihre kleinen Kinder und ihre Weiber führten sie fort als Gefangene und plünderten dazu alles, was in den Häusern war. ");
INSERT INTO deutkw_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Da sprach Jakob zu Simeon und Levi: Ihr habt mich ins Unglück gestürzt; denn ihr habt mich verhaßt gemacht bei den Bewohnern des Landes, den Kanaanitern und Pheresitern, während ich doch nur wenig Leute unter mir habe, wenn sie sich nun wider mich zusammenrotten und mich besiegen, so werde ich samt meiner Familie vernichtet werden. ");
INSERT INTO deutkw_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Da erwiderten sie: Durfte er unsere Schwester wie eine Hure behandeln? ");
INSERT INTO deutkw_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Da sprach Gott zu Jakob: Auf, ziehe hinauf nach Bethel, verweile dort und errichte dort einen Altar dem Gotte, der dir erschien, als du vor deinem Bruder Esau flohst. ");
INSERT INTO deutkw_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Da gebot Jakob seiner Familie und allen, die mit ihm waren: Schafft die ausländischen Götter weg, die ihr bei euch habt, reinigt euch und wechselt eure Kleider, ");
INSERT INTO deutkw_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","damit wir hinauf nach Bethel ziehen. Denn ich will dort einen Altar errichten dem Gott, der mich erhört hat in der Zeit meiner Drangsal und der mit mir war auf dem Wege, den ich gezogen bin. ");
INSERT INTO deutkw_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Da übergaben sie Jakob alle ausländischen Götter, die in ihrem Besitze waren, sowie die Ringe, die sie an ihren Ohren trugen, und Jakob verscharrte sie unter der Terebinthe, die bei Sichem steht. ");
INSERT INTO deutkw_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Sodann brachen sie auf; es lag aber ein von Gott gewirkter Schrecken auf den Städten, die rings um sie her waren, so daß man die Söhne Jakobs nicht verfolgte. ");
INSERT INTO deutkw_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Und Jakob gelangte nach Lus, welches im Lande Kanaan liegt, - das ist Bethel - samt allen den Leuten, die er bei sich hatte, ");
INSERT INTO deutkw_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","und er errichtete daselbst einen Altar und nannte die Stätte “Gott von Bethel”, weil sich ihm Gott dort offenbart hatte, als er vor seinem Bruder floh. ");
INSERT INTO deutkw_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Es starb aber Debora, die Amme der Rebeka, und wurde begraben unterhalb Bethel unter der Eiche; man nennt sie deshalb Klageeiche. ");
INSERT INTO deutkw_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Da erschien Gott dem Jakob abermals bei seiner Rückkunft aus Mesopotamien und segnete ihn. ");
INSERT INTO deutkw_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Und Gott sprach zu ihm: Du heißest Jakob; du sollst fortan nicht mehr Jakob heißen, sondern Israel soll dein Name sein. Daher nennt man ihn Israel. ");
INSERT INTO deutkw_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Und Gott sprach zu ihm: Ich bin Gott, der Allmächtige; du sollst fruchtbar sein und zahlreiche Nachkommen haben. Ein Volk, ja eine Schar von Völkern soll von dir abstammen und Könige werden aus deinen Lenden hervorgehn. ");
INSERT INTO deutkw_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Und das Land, welches ich Abraham und Isaak verliehen habe, dir will ich es verleihen und deinen Nachkommen will ich das Land verleihen. ");
INSERT INTO deutkw_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Und Gott fuhr auf von ihm an der Stätte, wo er mit ihm geredet hatte. ");
INSERT INTO deutkw_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Da errichtete Jakob einen Malstein an der Stätte, wo er mit ihm geredet hatte - ein Steinmal -, und goß ein Trankopfer darüber aus und schüttete Öl darüber. ");
INSERT INTO deutkw_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Und Jakob nannte die Stätte, woselbst Gott mit ihm geredet hatte, Bethel. ");
INSERT INTO deutkw_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Sodann zogen sie von Bethel weiter, und als sie nur noch eine Strecke Wegs bis Ephrath hatten, wurde Rahel von Geburtswehen befallen, und sie hatte eine schwere Geburt. ");
INSERT INTO deutkw_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Und als ihr die Geburt so schwer wurde, sprach die Geburtshelferin zu ihr: Sei getrost, du hast auch diesmal einen Sohn! ");
INSERT INTO deutkw_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Als aber ihr Leben entfloh - denn sie mußte sterben -, da nannte sie ihn Schmerzenskind; sein Vater aber nannte ihn Benjamin. ");
INSERT INTO deutkw_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Hierauf starb Rahel und wurde begraben an der Straße nach Ephrath, das ist Bethlehem. ");
INSERT INTO deutkw_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Und Jakob errichtete einen Malstein auf ihrem Grabe; das ist der Malstein auf dem Grabe Rahels, der noch heute vorhanden ist. ");
INSERT INTO deutkw_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Hierauf zog Israel weiter und schlug sein Lager auf jenseits von Migdal Eder. ");
INSERT INTO deutkw_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Während aber Israel in dieser Gegend wohnte, ging Ruben hin und beschlief Bilha, das Kebsweib seines Vaters. Und Israel hörte es. Es waren aber die Söhne Jakobs ihrer zwölf. ");
INSERT INTO deutkw_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Von Lea: Der Erstgeborene Jakobs, Ruben, und Simeon, Levi, Juda, Issachar und Sebulon. ");
INSERT INTO deutkw_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Von Rahel: Joseph und Benjamin. ");
INSERT INTO deutkw_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Und von Bilha, der Leibmagd Rahels: Dan und Naphtali; ");
INSERT INTO deutkw_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","und von Silpa, der Leibmagd Leas: Gad und Asser. Das sind die Söhne Jakobs, die ihm in Mesopotamien geboren wurden. ");
INSERT INTO deutkw_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Und Jakob gelangte zu seinem Vater Isaak nach Mamre, der Stadt der vier - das ist Hebron -, woselbst Abraham und Isaak als Fremdlinge geweilt hatten. ");
INSERT INTO deutkw_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Es betrug aber die Lebensdauer Isaaks 180 Jahre. ");
INSERT INTO deutkw_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Da verschied Isaak und starb und ging ein zu seinen Stammesgenossen, alt und lebenssatt, und seine Söhne Esau und Jakob bestatteten ihn. ");
INSERT INTO deutkw_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Dies sind die Nachkommen Esaus, das ist Edom. ");
INSERT INTO deutkw_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau hatte sich Kanaaniterinnen zu Weibern genommen: Ada, die Tochter des Hethiters Elon, und Oholibama, die Tochter Anas, des Sohnes Zibeons, des Horiters; ");
INSERT INTO deutkw_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","und Basmath, die Tochter Ismaels, die Schwester Nebajoths. ");
INSERT INTO deutkw_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada aber gebar Esau den Eliphas, Basmath gebar Reguel, ");
INSERT INTO deutkw_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","und Oholibama gebar Jehus, Jaelam und Korah. Das sind die Söhne Esaus, die ihm im Lande Kanaan geboren wurden. ");
INSERT INTO deutkw_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Und Esau nahm seine Weiber, seine Söhne und Töchter und alle Sklaven, die zu seinem Hausstande gehörten, sowie seine Herde, all sein Vieh und alle seine Habe, die er im Lande Kanaan erworben hatte, und zog von seinem Bruder Jakob hinweg ins Land Seir. ");
INSERT INTO deutkw_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Denn ihr Besitz war zu groß, als daß sie hätten bei einander bleiben können, und das Land, in welchem sie als Fremdlinge weilten, reichte für sie nicht aus wegen ihrer Herden. ");
INSERT INTO deutkw_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Und Esau nahm seinen Aufenthalt auf dem Gebirge Seir - Esau, das ist Edom. ");
INSERT INTO deutkw_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Dies sind die Nachkommen Esaus, des Stammvaters der Edomiter, auf dem Gebirge Seir. ");
INSERT INTO deutkw_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Dies sind die Namen der Söhne Esaus: Eliphas, der Sohn Adas, des Weibes Esaus; Reguel, der Sohn Basmaths, des Weibes Esaus. ");
INSERT INTO deutkw_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Die Söhne des Eliphas aber waren: Theman, Omar, Zepho, Gaetham und Kenas. ");
INSERT INTO deutkw_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Und Thimna war ein Kebsweib des Eliphas, des Sohnes Esaus; die gebar dem Eliphas den Amalek. Dies sind die Söhne Adas, des Weibes Esaus. ");
INSERT INTO deutkw_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Und dies sind die Söhne Reguels: Nahath, Serah, Samma und Missa. Dies waren die Söhne Basmaths, des Weibes Esaus. ");
INSERT INTO deutkw_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Und dies waren die Söhne Oholibamas, der Tochter Anas, des Sohnes Zibeons, des Weibes Esaus; die gebar dem Esau Jehus, Jaelam und Korah. ");
INSERT INTO deutkw_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Dies sind die Häuptlinge der Söhne Esaus. Die Söhne des Eliphas, des Erstgebornen Esaus, waren der Häuptling Theman, der Häuptling Omar, der Häuptling Zepho, der Häuptling Kenas. ");
INSERT INTO deutkw_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Der Häuptling Korah, der Häuptling Gaetham, der Häuptling Amalek. Dies sind die Häuptlinge von Eliphas im Lande Edom. Dies sind die Söhne Adas. ");
INSERT INTO deutkw_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Und dies waren die Söhne Reguels, des Sohnes Esaus: der Häuptling Nahath, der Häuptling Serah, der Häuptling Samma, der Häuptling Missa. Dies sind die Häuptlinge von Reguel im Lande Edom; dies sind die Söhne Basmaths, des Weibes Esaus. ");
INSERT INTO deutkw_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Und dies sind die Söhne Oholibamas, des Weibes Esaus: der Häuptling Jehus, der Häuptling Jaelam, der Häuptling Korah. Dies sind die Häuptlinge von Oholibama, der Tochter Anas, dem Weibe Esaus. ");
INSERT INTO deutkw_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Dies sind die Söhne Esaus und dies ihre Häuptlinge: das ist Edom. ");
INSERT INTO deutkw_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Dies sind die Söhne Seirs, des Horiters, die Ureinwohner des Landes: Lotan, Sobal, Zibeon, Ana, ");
INSERT INTO deutkw_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dison, Ezer und Disan. Dies sind die Häuptlinge der Horiter, die Söhne Seirs, im Lande Edom. ");
INSERT INTO deutkw_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Die Söhne Lotans aber waren Hori und Heman; und die Schwester Lotans war Thimna. ");
INSERT INTO deutkw_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Und dies sind die Söhne Sobals: Alwan, Manahath, Ebal, Sepho und Onam. ");
INSERT INTO deutkw_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Und dies sind die Söhne Zibeons: Ajja und Ana; das ist derselbe Ana, der die heißen Quellen in der Steppe fand, als er die Esel seines Vaters Zibeon weidete. ");
INSERT INTO deutkw_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Und dies sind die Söhne Anas: Dison; und Oholibama war die Tochter Anas. ");
INSERT INTO deutkw_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Und dies sind die Söhne Disons: Hemdan, Esban, Jithran und Keran. ");
INSERT INTO deutkw_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Dies sind die Söhne Ezers: Bilhan, Sawan und Akan. ");
INSERT INTO deutkw_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dies sind die Söhne Disans: Uz und Aran. ");
INSERT INTO deutkw_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Dies sind die Häuptlinge der Horiter: der Häuptling Lotan, der Häuptling Sobal, der Häuptling Zibeon, der Häuptling Ana. ");
INSERT INTO deutkw_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Der Häuptling Dison, der Häuptling Ezer, der Häuptling Disan. Dies sind die Häuptlinge der Horiter nach ihren Häuptlingen im Lande Seir. ");
INSERT INTO deutkw_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Und dies sind die Könige, welche im Lande Edom geherrscht haben, bevor es einen König der Israeliten gab. ");
INSERT INTO deutkw_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Es war König über Edom Bela, der Sohn Beors, und seine Residenz hieß Dinhaba. ");
INSERT INTO deutkw_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Als Bela gestorben war, wurde Jobab, der Sohn Serahs, aus Bosra König an seiner Statt. ");
INSERT INTO deutkw_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Als Jobab gestorben war, wurde Husam aus dem Lande der Themaniter König an seiner Statt. ");
INSERT INTO deutkw_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Als Husam gestorben war, wurde Hadad, der Sohn Bedads, König an seiner Statt, derselbe, der die Midianiter auf der Ebene von Moab schlug; und seine Residenz hieß Awith. ");
INSERT INTO deutkw_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Als Hadad gestorben war, wurde Samla aus Masreka König an seiner Statt. ");
INSERT INTO deutkw_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Als Samla gestorben war, wurde Saul aus Rehoboth am Euphratstrom König an seiner Statt. ");
INSERT INTO deutkw_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Als Saul gestorben war, wurde Baal-hanan, der Sohn Achbors, König an seiner Statt. ");
INSERT INTO deutkw_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Als Baal-hanan, der Sohn Achbors, gestorben war, wurde Hadar König an seiner Statt; seine Residenz aber hieß Pagu und sein Weib Mehetabeel, die Tochter Matreds, der Tochter Mesahabs. ");
INSERT INTO deutkw_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Dieses sind die Namen der Häuptlinge Esaus nach ihren Geschlechtern, ihren Ortschaften, ihren Namen: der Häuptling Thimna, der Häuptling Alwa, der Häuptling Jetheth, ");
INSERT INTO deutkw_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","der Häuptling Oholibama, der Häuptling Ela, der Häuptling Pinon, ");
INSERT INTO deutkw_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","der Häuptling Kenas, der Häuptling Theman, der Häuptling Mibzar, ");
INSERT INTO deutkw_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","der Häuptling Magdiel, der Häuptling Iram. Dies sind die Häuptlinge von Edom nach ihren Wohnsitzen in dem Lande, das sie in Besitz genommen hatten, das ist von Esau, dem Stammvater Edoms. ");
INSERT INTO deutkw_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jakob aber blieb wohnen im Lande, wo sein Vater als Fremdling geweilt hatte, im Lande Kanaan. ");
INSERT INTO deutkw_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Das ist die Geschichte Jakobs: Als Joseph siebzehn Jahre alt war, pflegte er mit seinen Brüdern die Schafe zu hüten - er war aber noch jung - mit den Söhnen Bilhas und Silpas, der Weiber seines Vaters; und wenn man ihnen etwas Schlimmes nachsagte, so hinterbrachte es Joseph ihrem Vater. ");
INSERT INTO deutkw_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Israel aber liebte Joseph mehr, als alle seine anderen Söhne, weil er ihm in seinem Alter geboren worden war, und er ließ ihm Ärmelkleider machen. ");
INSERT INTO deutkw_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Als nun seine Brüder gewahrten, daß ihr Vater ihn mehr liebte, als alle seine anderen Söhne, warfen sie einen Haß auf ihn und brachten es nicht über sich, ihm ein freundliches Wort zu gönnen. ");
INSERT INTO deutkw_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Einst hatte Joseph einen Traum, den erzählte er seinen Brüdern; da haßten sie ihn noch ärger. ");
INSERT INTO deutkw_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Und er sprach zu ihnen: Hört einmal, was für einen Traum ich gehabt habe! ");
INSERT INTO deutkw_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Wir waren beschäftigt, draußen auf dem Felde Garben zu binden. Da richtete sich meine Garbe auf und blieb stehen; eure Garben aber stellten sich rings herum und warfen sich vor meiner Garbe nieder. ");
INSERT INTO deutkw_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Da sprachen seine Brüder zu ihm: Willst du etwa gar König über uns werden oder über uns herrschen? Seitdem haßten sie ihn noch ärger wegen seiner Träume und wegen seiner Reden. ");
INSERT INTO deutkw_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Und ein andermal hatte er wieder einen Traum, den erzählte er seinen Brüdern und sprach: Hört, ich habe noch einen Traum gehabt! Da war die Sonne und der Mond und elf Sterne, die warfen sich vor mir nieder. ");
INSERT INTO deutkw_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Als er das seinem Vater und seinen Brüdern erzählte, da schalt ihn sein Vater und sprach zu ihm: Was ist das für ein Traum, den du da gehabt hast? Sollen etwa ich und deine Mutter und deine Brüder kommen und uns vor dir niederwerfen auf den Boden? ");
INSERT INTO deutkw_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Seitdem waren seine Brüder eifersüchtig auf ihn; sein Vater aber merkte sich die Sache. ");
INSERT INTO deutkw_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Als nun einst seine Brüder hingegangen waren, um bei Sichem die Schafe ihres Vaters zu weiden, ");
INSERT INTO deutkw_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","da sprach Israel zu Joseph: Deine Brüder weiden bei Sichem; wohlan, ich will dich zu ihnen schicken! Er erwiderte: Ich bin bereit! ");
INSERT INTO deutkw_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Da sprach er zu ihm: Geh und sieh zu, ob es deinen Brüdern und der Herde wohl geht, und bringe mir Bescheid! So schickte er ihn hinweg aus dem Thale von Hebron und er gelangte nach Sichem. ");
INSERT INTO deutkw_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Da traf ihn jemand, wie er auf freiem Felde umherrirrte, und fragte ihn: Was suchst du? ");
INSERT INTO deutkw_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Er antwortete: Meine Brüder suche ich; sage mir doch, wo sie jetzt weiden! ");
INSERT INTO deutkw_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Der Mann erwiderte: Sie sind von hier weggezogen, denn ich hörte sie sagen: Wir wollen nach Dothan gehen! Da ging Joseph seinen Brüder nach und traf sie in Dothan. ");
INSERT INTO deutkw_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Als sie ihn nun in der Ferne erblickten, und ehe er noch zu ihnen herangekommen war, da machten sie einen tückischen Anschlag wider ihn, ihn umzubringen; ");
INSERT INTO deutkw_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","da riefen sie einander zu: Da kommt ja der Träumer her! ");
INSERT INTO deutkw_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Kommt, wir wollen ihn totschlagen und in die erste beste Zisterne werfen und wollen vorgeben, ein reißendes Tier habe ihn gefressen; dann wird sich zeigen, was an seinen Träumen ist! ");
INSERT INTO deutkw_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Als Ruben das hörte, suchte er ihn aus ihren Händen zu retten und sprach: Nein, totschlagen wollen wir ihn nicht. ");
INSERT INTO deutkw_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Da sprach Ruben zu ihnen: Vergießt nur kein Blut! Werft ihn in die Zisterne da auf der Trift, aber legt nicht Hand an ihn! - um ihn aus ihren Händen zu erretten, um ihn seinem Vater zurückzubringen. ");
INSERT INTO deutkw_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Als nun Joseph zu seinen Brüdern herangekommen war, da zogen sie Joseph sein Kleid aus - das Ärmelkleid, das er anhatte -, ");
INSERT INTO deutkw_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","packten ihn und warfen ihn in die Zisterne; die Zisterne aber war leer und kein Wasser darin. ");
INSERT INTO deutkw_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Als sie sich nun hingesetzt hatten, um ihre Mahlzeit zu halten, da gewahrten sie eine Karawane von Ismaelitern, die eben aus Gilead herüberkam; deren Kamele waren beladen mit Tragakanth, Balsam und Ladanum: damit waren sie unterwegs nach Ägypten. ");
INSERT INTO deutkw_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Da sprach Juda zu seinen Brüdern: Was hätten wir davon, wenn wir unseren Bruder umbrächten und den Mord verheimlichten? ");
INSERT INTO deutkw_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Kommt, wir wollen ihn an die Ismaeliter verkaufen, nicht aber Hand an ihn legen; denn er ist unser Bruder, unser Fleisch. Seine Brüder willigten ein. ");
INSERT INTO deutkw_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Es kamen aber midianitische Händler vorüber; und sie zogen ihn heraus und holten Joseph herauf aus der Zisterne und verkauften Joseph an die Ismaeliter für zwanzig Silberstücke, und sie führten Joseph fort nach Ägypten. ");
INSERT INTO deutkw_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Als nun Ruben wieder zur Zisterne kam, da war Joseph nicht mehr in der Zisterne! Da zerriß er seine Kleider, ");
INSERT INTO deutkw_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","kehrte zurück zu seinen Brüdern und rief: Der Knabe ist verschwunden! Wo soll ich nun hin! ");
INSERT INTO deutkw_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Hierauf nahmen sie das Kleid Josephs, sodann schlachteten sie einen Ziegenbock und tauchten den Rock ins Blut. ");
INSERT INTO deutkw_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Dann schickten sie das Ärmelkleid, brachten es ihrem Vater und gaben vor: Dies haben wir gefunden - sieh doch zu, ob es der Rock deines Sohnes ist oder nicht! ");
INSERT INTO deutkw_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Und als er ihn näher angesehen hatte, da schrie er: Der Rock meines Sohnes! ein reißendes Tier hat ihn gefressen! Ja, ja, zerrissen ist Joseph! ");
INSERT INTO deutkw_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Da zerriß Jakob seine Kleider, legte ein härenes Gewand um seine Hüften und trauerte um seinen Sohn lange, lange Zeit. ");
INSERT INTO deutkw_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Und ob auch alle seine Söhne und Töchter ihn zu trösten suchten, wollte er sich doch nicht trösten lassen, sondern sprach: Trauernd werde ich zu meinem Sohne hinabsteigen in die Unterwelt! So beweinte ihn sein Vater. ");
INSERT INTO deutkw_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Die Midianiter aber verkauften ihn nach Ägypten an Potiphar, einen Verschnittenen des Pharao, den Anführer der Leibwächter. ");
INSERT INTO deutkw_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Um dieselbe Zeit trug es sich zu, daß Juda seine Brüder verließ und sich an einen Einwohner von Adullam, Namens Hira, anschloß. ");
INSERT INTO deutkw_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Dort erblickte Juda die Tochter eines Kanaaniters, Namens Sua; die nahm er zum Weibe und wohnte ihr bei. ");
INSERT INTO deutkw_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Da wurde sie schwanger und gebar einen Sohn; den nannte sie Ger. ");
INSERT INTO deutkw_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Hierauf wurde sie abermals schwanger und gebar einen Sohn; den nannte sie Onan. ");
INSERT INTO deutkw_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Sodann gebar sie noch einen Sohn; den nannte sie Sela. Und zwar befand sie sich zu Kesib, als sie ihn gebar. ");
INSERT INTO deutkw_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Juda aber freite für Ger, seinen Erstgebornen, ein Weib Namens Thamar. ");
INSERT INTO deutkw_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Nun machte sich aber Ger, der Erstgeborne Judas, Jahwe mißfällig; daher ließ ihn Jahwe sterben. ");
INSERT INTO deutkw_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Da gebot Juda dem Onan: Begieb dich zum Weibe deines Bruders und leiste ihr die Schwagerpflicht, damit du deinem Bruder Nachkommen verschaffst. ");
INSERT INTO deutkw_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Da aber Onan wußte, daß die Kinder nicht ihm gehören sollten, so ließ er es, so oft er dem Weibe seines Bruders beiwohnte, daneben fallen, um seinem Bruder nicht Nachkommen zu verschaffen. ");
INSERT INTO deutkw_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Solches Thun aber mißfiel Jahwe, daher ließ er auch ihn sterben. ");
INSERT INTO deutkw_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Da gebot Juda seiner Schwiegertochter Thamar: Bleibe als Witwe im Hause deines Vaters, bis mein Sohn Sela herangewachsen ist! Er fürchtete nämlich, es könne auch dieser sterben, wie seine Brüder. Da ging Thamar hin und blieb im Hause ihres Vaters. ");
INSERT INTO deutkw_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Als nun längere Zeit verstrichen war, starb die Tochter Suas, das Weib Judas. Nachdem Juda ausgetrauert hatte, begab er sich mit seinem Freunde, dem Adullamiter Hira, hinauf nach Thimna, um nach seinen Scherern zu sehen. ");
INSERT INTO deutkw_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Als nun Thamar berichtet ward: eben kommt dein Schwiegervater herauf nach Thimna zur Schafschur! ");
INSERT INTO deutkw_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","da legte sie ihre Witwenkleider ab, bedeckte sich mit dem Schleier, vermummte sich und setzte sich nieder da, wo es nach Enaim hineingeht, das an dem Wege nach Thimna liegt. Denn sie hatte wohl bemerkt, daß Sela herangewachsen war, und doch war sie ihm nicht zum Weibe gegeben worden. ");
INSERT INTO deutkw_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Als Juda sie erblickte, hielt er sie für eine Buhldirne; denn sie hatte ihr Gesicht verhüllt. ");
INSERT INTO deutkw_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Da bog er zu ihr ab und sprach: Laß mich dir beiwohnen! Denn er wußte nicht, daß es seine Schwiegertochter war. Sie erwiderte: Was giebst du mir dafür, daß du mir beiwohnen darfst? ");
INSERT INTO deutkw_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Er antwortete: Ich werde dir ein Ziegenböckchen von der Herde schicken! Sie sprach: Wenn du mir ein Pfand giebst bis dahin, wo du es schicken wirst. ");
INSERT INTO deutkw_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Da fragte er: Was für ein Pfand soll ich dir geben? Sie erwiderte: Deinen Siegelring, deine Schnur und den Stab, den du in der Hand hast. Da gab er es ihr und wohnte ihr bei, und sie wurde schwanger von ihm. ");
INSERT INTO deutkw_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Hierauf ging sie von dannen, legte ihren Schleier ab und zog ihre Witwenkleider an. ");
INSERT INTO deutkw_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Juda aber schickte das Böckchen durch seinen Freund, den Adullamiter, um dagegen das Pfand von dem Weibe in Empfang zu nehmen; aber er fand sie nicht. ");
INSERT INTO deutkw_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Da fragte er die Leute jenes Orts: Wo ist die Lustdirne, die hier bei Enaim am Wege saß? Sie antworteten: Hier ist keine Lustdirne gewesen! ");
INSERT INTO deutkw_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Da kehrte er zu Juda zurück und berichtete: Ich habe sie nicht gefunden, und die Leute dort haben behauptet: Hier ist keine Lustdirne gewesen! ");
INSERT INTO deutkw_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Juda erwiderte: Mag sie es behalten, wenn wir nur nicht zum Gespött werden. Ich habe richtig das Böckchen geschickt, du konntest sie aber nicht auffinden! ");
INSERT INTO deutkw_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Nach Verlauf von ungefähr drei Monaten aber wurde Juda berichtet: Deine Schwiegertochter Thamar hat gehurt und ist richtig dadurch schwanger geworden! Da gebot Juda: Führt sie hinaus, daß sie verbrannt werde! ");
INSERT INTO deutkw_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Als sie aber schon hinausgeführt war, da schickte sie zu ihrem Schwiegervater und ließ ihm sagen: Von dem Manne, dem diese Gegenstände gehören, bin ich schwanger! und ließ ihm sagen: Sieh doch zu, wem der Siegelring, die Schnüre und der Stab da gehören! ");
INSERT INTO deutkw_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Und als Juda sie näher angesehen hatte, sprach er: Sie ist in ihrem Rechte gegen mich; warum habe ich sie auch nicht meinem Sohne Sela zum Weibe gegeben! Er hatte aber fortan keinen Umgang mehr mit ihr. ");
INSERT INTO deutkw_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Als nun die Zeit da war, daß sie gebären sollte, da befand sich, daß Zwillinge in ihrem Leibe waren. ");
INSERT INTO deutkw_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Während der Geburt aber streckte einer eine Hand vor. Da nahm die Geburtshelferin einen roten Faden und band ihm den um die Hand; das wollte sagen: dieser ist zuerst herausgekommen! ");
INSERT INTO deutkw_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Er zog jedoch seine Hand wieder zurück, und nun kam sein Bruder zum Vorschein. Da rief sie: Was hast du für einen Riß für dich gemacht! Daher nannte sie ihn Perez. ");
INSERT INTO deutkw_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Darnach kam sein Bruder zum Vorschein, an dessen Hand der rote Faden war; daher nannte sie ihn Serah. ");
INSERT INTO deutkw_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Als nun Joseph nach Ägypten gebracht worden war, kaufte ihn Potiphar, ein Verschnittener des Pharao, der Anführer der Leibwächter, ein Ägypter, von den Ismaelitern, die ihn dorthin gebracht hatten. ");
INSERT INTO deutkw_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Jahwe aber war mit Joseph, so daß ihm alles gelang, und er hatte seinen Aufenthalt im Hause seines Herrn, des Ägypters. ");
INSERT INTO deutkw_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Als nun sein Herr sah, daß Jahwe mit ihm sei und daß Jahwe ihm alles gelingen ließ, was er unternahm, ");
INSERT INTO deutkw_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","da kam Joseph in große Gunst bei ihm und er mußte ihn bedienen, und er machte ihn zum Aufseher über sein Hauswesen und vertraute ihm sein gesamtes Eigentum an. ");
INSERT INTO deutkw_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Und von der Zeit an, wo er ihn zum Aufseher über sein Hauswesen und sein gesamtes Eigentum bestellt hatte, segnete Jahwe das Haus des Ägypters um Josephs willen, und der Segen Jahwes ruhte auf allem, was ihm gehörte, im Hause und draußen. ");
INSERT INTO deutkw_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Und er überließ Joseph sein gesamtes Eigentum und kümmerte sich neben ihm um gar nichts, nur daß er aß und trank. Joseph aber war schön von Gestalt und schön von Antlitz. ");
INSERT INTO deutkw_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Nach einiger Zeit nun warf das Weib seines Herrn ihre Augen auf Joseph und sprach: Schlafe bei mir! ");
INSERT INTO deutkw_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Er aber weigerte sich und sprach zu dem Weibe seines Herrn: Bedenke, mein Herr bekümmert sich neben mir um nichts im Hause und hat mir all sein Eigentum anvertraut. ");
INSERT INTO deutkw_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Er hat in diesem Hause nicht mehr Macht, als ich, und hat mir gar nichts vorenthalten, ausgenommen dich, da du sein Weib bist. Wie sollte ich nun dieses schwere Unrecht begehen und mich wider Gott versündigen? ");
INSERT INTO deutkw_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Und obgleich sie Tag für Tag auf Joseph einredete, war er ihr doch nicht zu Willen, daß er sich zu ihr gelegt und Umgang mit ihr gehabt hätte. ");
INSERT INTO deutkw_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Eines Tages aber, als er ins Haus hineingekommen war, um seinen Geschäften obzuliegen, während gerade niemand von den Hausangehörigen drinnen anwesend war, ");
INSERT INTO deutkw_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","ergriff sie ihn beim Gewand und verlangte: Schlafe bei mir! Er aber ließ sein Gewand in ihren Händen, ergriff die Flucht und lief zum Hause hinaus. ");
INSERT INTO deutkw_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Als sie nun sah, daß er sein Gewand in ihren Händen gelassen hatte und entflohen war, ");
INSERT INTO deutkw_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","da rief sie die Hausangehörigen herbei und sprach zu ihnen: Ei, seht doch, hat er uns da einen Hebräer hergebracht, daß er seinen Mutwillen mit uns treibe! Er kam zu mir herein, um bei mir zu liegen, ich aber schrie laut. ");
INSERT INTO deutkw_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Als er nun hörte, daß ich ein lautes Geschrei erhob, da ließ er sein Gewand bei mir zurück und floh und lief zum Hause hinaus. ");
INSERT INTO deutkw_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Hierauf legte sie sein Gewand neben sich, bis sein Herr heimkam. ");
INSERT INTO deutkw_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Sodann berichtete sie ihm ganz ebenso: Kommt da der hebräische Sklave, den du uns hergebracht hast, zur mir herein, um seinen Mutwillen mit mir zu treiben. ");
INSERT INTO deutkw_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Als ich aber ein lautes Geschrei erhob, ließ er sein Gewand bei mir zurück und floh zum Hause hinaus. ");
INSERT INTO deutkw_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Als nun sein Herr vernahm, was ihm sein Weib berichtete, indem sie erzählte: So und so hat dein Sklave gegen mich gehandelt! da wurde er sehr zornig. ");
INSERT INTO deutkw_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Und der Herr Josephs ließ ihn ergreifen und ins Gefängnis werfen, dahin, wo die königlichen Gefangenen gefangen saßen, und so lag er dort im Gefängnis. ");
INSERT INTO deutkw_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Aber Jahwe war mit Joseph und machte ihm die Herzen zugeneigt und verschaffte ihm die Gunst des obersten Aufsehers über das Gefängnis. ");
INSERT INTO deutkw_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Und der oberste Aufseher über das Gefängnis vertraute Joseph alle Gefangenen an, die sich im Gefängnis befanden, und alles, was dort geschah, geschah nach seiner Anordnung. ");
INSERT INTO deutkw_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Der oberste Aufseher über das Gefängnis kümmerte sich um gar nichts, was durch ihn geschah, da Jahwe mit ihm war; was er auch unternahm, das ließ Jahwe gelingen. ");
INSERT INTO deutkw_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Einige Zeit darnach aber vergingen sich der Mundschenk des Königs von Ägypten und der Bäcker gegen ihren Herrn, den König von Ägypten. ");
INSERT INTO deutkw_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Da wurde der Pharao zornig über seine beiden Verschnittenen, den Obermundschenk und den Oberbäcker, ");
INSERT INTO deutkw_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","und ließ sie in Gewahrsam legen in das Haus des Anführers der Leibwächter, ins Gefängnis, dahin, wo Joseph gefangen saß. ");
INSERT INTO deutkw_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Und der Anführer der Leibwächter gab ihnen Joseph bei, damit er sie bediene, und so waren sie längere Zeit in Gewahrsam. ");
INSERT INTO deutkw_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Da hatten sie beide in einer und derselben Nacht einen Traum und zwar jeder einen Traum von besonderer Bedeutung, der Mundschenk und der Bäcker des Königs von Ägypten, die im Gefängnis saßen. ");
INSERT INTO deutkw_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Als nun Joseph des Morgens zu ihnen hineinkam, merkte er ihnen an, daß sie verstimmt waren. ");
INSERT INTO deutkw_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Da fragte er die Verschnittenen des Pharao, die mit ihm im Gewahrsam waren im Hause seines Herrn: Warum macht ihr denn heute ein so böses Gesicht? ");
INSERT INTO deutkw_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Sie antworteten ihm: Wir haben einen Traum gehabt, und nun ist niemand da, der ihn deuten könnte. Da sprach Joseph zu ihnen: Traumdeutung hängt von Gott ab - erzählt mir einmal! ");
INSERT INTO deutkw_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Da erzählte der Obermundschenk dem Joseph seinen Traum und sprach zu ihm: Mir war's im Traum, als stehe ein Weinstock vor mir. ");
INSERT INTO deutkw_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","An diesem Weinstock waren drei Zweige, und als er nun zu treiben begann, da kamen alsbald auch Blüten zum Vorschein, und seine Kämme trugen reife Trauben. ");
INSERT INTO deutkw_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Ich aber hielt den Becher des Pharao in der Hand; und ich nahm die Trauben, drückte sie aus in den Becher des Pharao und gab sodann dem Pharao den Becher in die Hand. ");
INSERT INTO deutkw_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Da erwiderte ihm Joseph: Das ist so zu deuten: die drei Zweige bedeuten drei Tage. ");
INSERT INTO deutkw_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","In drei Tagen von heute ab wird dich der Pharao emporziehen und dich wieder auf deinen Posten setzen. Dann wirst du dem Pharao seinen Becher reichen ganz so wie früher, als du sein Mundschenk warst. ");
INSERT INTO deutkw_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Aber - denke an mich, wenn es dir wohlgeht, und thu mir die Liebe an und lege bei dem Pharao ein gutes Wort für mich ein, damit du mich aus diesem Hause befreist! ");
INSERT INTO deutkw_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Denn ich bin schmählich geraubt aus dem Lande der Hebräer, und auch hier habe ich es mit nichts verschuldet, daß sie mich ins Gefängnis geworfen haben. ");
INSERT INTO deutkw_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Als nun der Oberbäcker sah, daß er eine erfreuliche Deutung gab, da sprach er zu Joseph: In meinem Traume war es mir, als trüge ich drei Körbe mit Backwerk auf dem Haupte. ");
INSERT INTO deutkw_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Im obersten Korbe befand sich allerlei Eßware für den Pharao, wie sie der Bäcker macht; aber die Vögel fraßen sie weg aus dem Korb auf meinem Haupte. ");
INSERT INTO deutkw_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Da antwortete Joseph und sprach: Das ist so zu deuten: die drei Körbe bedeuten drei Tage. ");
INSERT INTO deutkw_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","In drei Tagen von heute ab wird dich der Pharao enthaupten lassen und ans Holz hängen; da werden dann die Vögel dein Fleisch wegfressen. ");
INSERT INTO deutkw_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Und am dritten Tage darauf, dem Geburtstage des Pharao, da veranstaltete er ein Gastmahl für alle seine Untergebenen. Da zog er den Obermundschenk und den Oberbäcker empor im Beisein seiner Untergebenen; ");
INSERT INTO deutkw_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","den Obermundschenk setzte er wieder in sein Schenkenamt ein, so daß er dem Pharao wieder den Becher reichen durfte, ");
INSERT INTO deutkw_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","den Oberbäcker aber ließ er hängen, wie ihnen Joseph vorhergesagt hatte. ");
INSERT INTO deutkw_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Der Obermundschenk jedoch dachte nicht mehr an Joseph, sondern vergaß ihn. ");
INSERT INTO deutkw_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Zwei Jahre darauf träumte einmal dem Pharao und zwar, er stehe am Nil. ");
INSERT INTO deutkw_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Aus dem Nil aber stiegen sieben Kühe herauf von stattlichem Aussehen und fetten Leibes; die weideten im Riedgras. ");
INSERT INTO deutkw_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Nach ihnen aber stiegen sieben andere Kühe aus dem Nil herauf, von häßlichem Aussehen und mageren Leibes; die stellten sich neben die ersten Kühe am Ufer des Nil. ");
INSERT INTO deutkw_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Hierauf fraßen die häßlich aussehenden und mageren Kühe die sieben schönen und fetten Kühe - da erwachte der Pharao. ");
INSERT INTO deutkw_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Als er wieder eingeschlafen war, träumte ihm abermals und zwar, es wüchsen sieben Ähren an einem Halme, dick und schön. ");
INSERT INTO deutkw_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Nach ihnen aber sproßten sieben dürre und vom Ostwind versengte Ähren auf; ");
INSERT INTO deutkw_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","diese dürren Ähren verschlangen die sieben dicken und vollen Ähren. Da erwachte der Pharao und merkte, daß er geträumt habe. ");
INSERT INTO deutkw_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Frühmorgens aber ließ es ihm keine Ruhe, da sandte er aus und ließ alle Schriftkundigen und Weisen Ägyptens herbeirufen; denen erzählte der Pharao seine Träume. Aber da war keiner, der sie dem Pharao deuten konnte. ");
INSERT INTO deutkw_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Da nahm der Obermundschenk das Wort und sprach zum Pharao: Ich muß heute meine Verschuldung in Erinnerung bringen. ");
INSERT INTO deutkw_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Der Pharao war zornig auf seine Diener und ließ sie ins Haus des Anführers der Leibwächter gefangen setzen, mich und den Oberbäcker. ");
INSERT INTO deutkw_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Da hatten wir beide in einer und derselben Nacht einen Traum, und zwar jeder einen Traum von besonderer Bedeutung. ");
INSERT INTO deutkw_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Nun war da bei uns ein hebräischer Jüngling, ein Sklave des Anführers der Leibwächter; dem erzählten wir unsere Träume, und er deutete sie uns und offenbarte uns genau, was eines jeden Traum bedeutete. ");
INSERT INTO deutkw_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Und wie er uns vorhergesagt, so ist's geschehen: mich hat man wieder auf meinen Posten gesetzt, und ihn hat man gehenkt. ");
INSERT INTO deutkw_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Da sandte der Pharao hin und ließ Joseph rufen. Da entließen sie ihn schleunigst aus dem Gefängnis, und er ließ sich scheren, wechselte seine Kleider und begab sich hinein zum Pharao. ");
INSERT INTO deutkw_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Da sprach der Pharao zu Joseph: Ich habe einen Traum gehabt, und es ist niemand da, der ihn zu deuten vermöchte. Nun habe ich aber von dir gehört: du brauchst einen Traum nur zu hören, um ihn alsbald zu deuten. ");
INSERT INTO deutkw_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Da erwiderte Joseph dem Pharao: O nein, ich nicht; aber Gott wird etwas offenbaren, was dem Pharao zum Heile gereicht. ");
INSERT INTO deutkw_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Da erzählte der Pharao dem Joseph: Mir träumte, ich stehe am Ufer des Nil. ");
INSERT INTO deutkw_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Da stiegen aus dem Nil sieben Kühe herauf, fetten Leibes und von stattlichem Aussehen, und weideten im Riedgras. ");
INSERT INTO deutkw_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Nach ihnen aber stiegen sieben andere Kühe herauf, elend und überaus häßlich anzusehen und mageren Leibes - nie habe ich in ganz Ägypten etwas so Häßliches gesehen wie sie! ");
INSERT INTO deutkw_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Hierauf fraßen die mageren und häßlichen Kühe die sieben ersten, die fetten Kühe. ");
INSERT INTO deutkw_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Aber auch als sie sie hineingefressen hatten, merkte man nichts davon, daß sie sie gefressen hatten, vielmehr war ihr Aussehen häßlich wie zuvor. Da erwachte ich. ");
INSERT INTO deutkw_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Weiter aber sah ich im Traume sieben Ähren an einem Halme wachsen, die waren voll und schön. ");
INSERT INTO deutkw_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Nach ihnen aber sproßten sieben taube, dürre, vom Ostwind versengte Ähren auf, ");
INSERT INTO deutkw_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","und die dürren Ähren verschlangen die sieben schönen Ähren. Das erzählte ich den Schriftkundigen, aber keiner kann mir Bescheid geben. ");
INSERT INTO deutkw_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Da antwortete Joseph dem Pharao: Die Träume des Pharao sind gleichbedeutend; Gott hat dem Pharao vorausverkündigt, was er demnächst thun wird. ");
INSERT INTO deutkw_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Die sieben schönen Kühe bedeuten sieben Jahre, und die sieben schönen Ähren bedeuten sieben Jahre - beide Träume sind gleichbedeutend. ");
INSERT INTO deutkw_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Und die sieben mageren und häßlichen Kühe, die nach ihnen heraufstiegen, bedeuten sieben Jahre, und die sieben leeren, vom Ostwind versengten Ähren sind, wie sich zeigen wird, sieben Hungerjahre. ");
INSERT INTO deutkw_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Deshalb habe ich vorhin zum Pharao gesagt: Was Gott zu thun vorhat, hat er dem Pharao gezeigt! ");
INSERT INTO deutkw_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Es kommen jetzt sieben Jahre, da wird großer Überfluß in ganz Ägypten herrschen. ");
INSERT INTO deutkw_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Nach ihnen aber werden sieben Hungerjahre eintreten, so daß ganz in Vergessenheit geraten wird, welcher Überfluß in Ägypten herrschte, und der Hunger wird das Land aufreiben; ");
INSERT INTO deutkw_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","und man wird nichts mehr wissen von dem Überfluß im Lande infolge dieser Hungersnot, die hinterdrein kommt, denn sie wird überaus drückend sein. ");
INSERT INTO deutkw_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Und was das betrifft, daß dem Pharao zweimal nacheinander träumte, so wisse: die Sache ist fest beschlossen bei Gott, und Gott wird sie eilends ins Werk setzen. ");
INSERT INTO deutkw_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","So wolle sich denn der Pharao einen klugen und weisen Mann ersehen, daß er ihm Ägypten unterstelle. ");
INSERT INTO deutkw_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Und der Pharao wolle dazu thun und Aufseher über das Land bestellen, um während der sieben Jahre des Überflusses den Fünften von Ägypten erheben zu lassen. ");
INSERT INTO deutkw_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Und zwar soll man den gesamten Ernteertrag der nun kommenden guten Jahre ansammeln und Getreide aufspeichern zur Verfügung des Pharao und soll den Ernteertrag in die Städte legen und aufbewahren. ");
INSERT INTO deutkw_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Dieser Vorrat soll dem Land als Rückhalt dienen für die sieben Hungerjahre, die über Ägypten kommen werden; so wird das Land nicht zu Grunde gehen durch die Hungersnot. ");
INSERT INTO deutkw_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Diese Rede fand Beifall bei dem Pharao und bei allen seinen Untergebenen. ");
INSERT INTO deutkw_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Da sprach der Pharao zu seinen Untergebenen: Könnten wir wohl einen finden, in dem der Geist Gottes ist, wie in ihm? ");
INSERT INTO deutkw_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Sodann sprach der Pharao zu Joseph: Nachdem dir Gott dieses alles offenbart hat, giebt es niemand, der so klug und weise wäre, wie du. ");
INSERT INTO deutkw_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Du sollst meinem Hause vorstehen, und deinem Befehle soll sich mein gesamtes Volk fügen - nur den Besitz des Throns will ich vor dir voraus haben. ");
INSERT INTO deutkw_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Da sprach der Pharao zu Joseph: Wohlan, ich setze dich über ganz Ägypten. ");
INSERT INTO deutkw_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Hierauf zog der Pharao seinen Siegelring von seiner Hand ab und steckte ihn Joseph an; sodann ließ er ihn mit Byssusgewändern bekleiden und legte ihm die goldene Kette um den Hals. ");
INSERT INTO deutkw_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Hierauf ließ er ihn auf dem Wagen fahren, der im Range dem seinigen folgte, und man rief vor ihm aus: Abrekh! So setzte er ihn über ganz Ägypten. ");
INSERT INTO deutkw_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Und der Pharao sprach zu Joseph: ich bin der Pharao - aber ohne deinen Willen soll niemand Hand oder Fuß regen in ganz Ägypten. ");
INSERT INTO deutkw_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Und der Pharao legte Joseph den Namen Zaphenat Paneach bei und gab ihm Asnath, die Tochter Potipheras, des Oberpriesters von On, zum Weibe; und Joseph gebot über Ägypten. ");
INSERT INTO deutkw_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Dreißig Jahre war Joseph alt, als er vor Pharao, dem König von Ägypten, stand. Darnach begab sich Joseph hinweg von dem Pharao und durchzog ganz Ägypten. ");
INSERT INTO deutkw_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Das Land aber trug in den sieben Jahren des Überflusses haufenweise. ");
INSERT INTO deutkw_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Da sammelte er den gesamten Ernteertrag der sieben Jahre, während welcher in Ägypten Überfluß herrschte, und legte Vorrat in die Städte; in einer jeden Stadt speicherte er den Ertrag der Felder auf, die rings um sie her lagen. ");
INSERT INTO deutkw_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","So häufte Joseph Getreide auf, wie Sand am Meer, in ungeheuren Massen, bis er davon abstand, es zu messen, denn es war nicht zu messen. ");
INSERT INTO deutkw_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Und Joseph wurden zwei Söhne geboren, ehe das Hungerjahr anbrach; die gebar ihm Asnath, die Tochter Poti-pheras, des Oberpriesters von On. ");
INSERT INTO deutkw_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Den Erstgeborenen nannte Joseph Manasse; denn Gott, sprach er, hat mich alle meine Not und meine gesamte Familie vergessen lassen! ");
INSERT INTO deutkw_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Den zweiten aber nannte er Ephraim; denn Gott, sprach er, hat mich fruchtbar sein lassen im Lande meiner Trübsal. ");
INSERT INTO deutkw_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Als nun die sieben Jahre des Überflusses in Ägypten vorüber waren, ");
INSERT INTO deutkw_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","da brachen die sieben Hungerjahre an, wie Joseph vorhergesagt hatte. Und zwar kam eine Hungersnot über alle Länder; aber in ganz Ägypten gab es Brot. ");
INSERT INTO deutkw_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Als nun ganz Ägypten die Hungersnot empfand, da forderte das Volk ungestüm Brot vom Pharao. Da sprach der Pharao zu allen Ägyptern: Geht hin zu Joseph: was er euch gebieten wird, das thut! ");
INSERT INTO deutkw_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Es lastete aber die Hungersnot auf aller Welt. Da eröffnete Joseph alle Kornspeicher und verkaufte den Ägyptern Getreide. Und die Hungersnot wurde immer drückender in Ägypten. ");
INSERT INTO deutkw_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Da kam alle Welt zu Joseph nach Ägypten, um Getreide zu kaufen; denn überall herrschte drückende Hungersnot. ");
INSERT INTO deutkw_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Als nun Jakob vernahm, daß es in Ägypten Getreide gebe, da sprach Jakob zu seinen Söhnen: Was zaudert ihr? ");
INSERT INTO deutkw_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Da sprach er: Ich höre mit Bestimmtheit, daß es in Ägypten Getreide giebt. Zieht hin und holt uns von dort Getreide, damit wir am Leben bleiben und nicht sterben. ");
INSERT INTO deutkw_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Da zogen zehn von den Brüdern Josephs hin, um Getreide aus Ägypten zu holen. ");
INSERT INTO deutkw_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Benjamin aber, den Bruder Josephs, ließ Jakob nicht mit seinen Brüdern ziehen; denn er trug Sorge, es könne ihm ein Unfall zustoßen. ");
INSERT INTO deutkw_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Da kamen unter denen, die hinströmten, auch die Söhne Israels hin, um Getreide zu kaufen; denn in Kanaan herrschte Hungersnot. ");
INSERT INTO deutkw_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Und Joseph, der da Machthaber war im Lande, der verkaufte aller Welt Getreide. Als nun die Brüder Josephs hereinkamen und sich bis auf den Boden vor ihm verneigten, ");
INSERT INTO deutkw_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","da erkannte Joseph seine Brüder, sobald er ihrer ansichtig wurde. Aber er stellte sich fremd gegen sie und er ließ sie hart an und fragte sie: Woher kommt ihr? Sie antworteten: Aus Kanaan, um Getreide zu kaufen. ");
INSERT INTO deutkw_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Und Joseph erkannte seine Brüder; sie aber erkannten ihn nicht. ");
INSERT INTO deutkw_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Da mußte Joseph an die Träume denken, die er in Bezug auf sie gehabt hatte. Und er sprach zu ihnen: Ihr seid Spione! Ihr seid nur hergekommen, um zu erspähen, wo das Land eine schwache Stelle hat. ");
INSERT INTO deutkw_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Sie antworteten ihm: O nein, Herr! Deine Sklaven sind vielmehr hergekommen, um Mundvorrat zu kaufen. ");
INSERT INTO deutkw_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Wir sind alle Söhne eines Mannes, wir sind ehrliche Leute; deine Sklaven sind keine Spione! ");
INSERT INTO deutkw_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Er erwiderte ihnen: Nichts da! Ihr seid hergekommen, um zu erspähen, wo das Land eine schwache Stelle hat. ");
INSERT INTO deutkw_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Sie antworteten: Unser zwölf sind deine Sklaven, lauter Brüder, Söhne eines Mannes in Kanaan; der Jüngste ist gegenwärtig noch bei unserem Vater, und einer ist verschwunden. ");
INSERT INTO deutkw_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Da sprach Joseph zu ihnen: Es ist so, wie ich euch gesagt habe: Spione seid ihr! ");
INSERT INTO deutkw_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Damit sollt ihr euch ausweisen: so wahr der Pharao lebt, ihr sollt nicht eher von hier wegziehen, bis euer jüngster Bruder hierher gekommen ist. ");
INSERT INTO deutkw_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Schickt einen von euch hin, daß er euren Bruder hole; ihr aber müßt gefangen bleiben. So sollen eure Aussagen geprüft werden, ob ihr mit der Wahrheit umgeht oder nicht. So wahr der Pharao lebt - ihr seid doch Spione! ");
INSERT INTO deutkw_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Hierauf ließ er sie drei Tage in Gewahrsam legen. ");
INSERT INTO deutkw_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Am dritten Tag aber sprach Joseph zu ihnen: Folgendes müßt ihr thun, um am Leben zu bleiben - denn ich bin ein gottesfürchtiger Mann. ");
INSERT INTO deutkw_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Wenn ihr ehrliche Leute seid, so mag einer von euch Brüdern als Gefangener zurückbleiben, da wo ihr in Gewahrsam lagt; ihr andern aber zieht hin und schafft das Getreide hin, dessen ihr für eure Familien bedürft. ");
INSERT INTO deutkw_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Euren jüngsten Bruder aber müßt ihr mir herbringen; so werden sich eure Aussagen bewahrheiten, und ihr werdet dem Tode entgehen. Und sie thaten also. ");
INSERT INTO deutkw_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Da sprachen sie einer zum andern: Wahrlich, das haben wir an unserem Bruder verschuldet; denn wir sahen seine Angst, wie er uns anflehte; aber wir blieben taub! Darum sind nun diese Ängste über uns gekommen. ");
INSERT INTO deutkw_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ruben aber sprach zu ihnen: Habe ich euch nicht gesagt: versündigt euch nicht an dem Kinde! Aber ihr wolltet nicht hören - nun aber wird Rechenschaft gefordert für sein Blut! ");
INSERT INTO deutkw_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Sie wußten aber nicht, daß Joseph sie verstand; denn sie verkehrten durch einen Dolmetscher. ");
INSERT INTO deutkw_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Da wendete er sich abseits, um zu weinen, kehrte dann wieder zu ihnen zurück und redete mit ihnen; hierauf ließ er Simeon aus ihrer Mitte greifen und vor ihren Augen fesseln. ");
INSERT INTO deutkw_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Sodann gab Joseph Befehl, ihre Säcke mit Getreide zu füllen, dabei aber einem jeden sein Geld wieder in seinen Sack zu thun, auch ihnen Zehrung mit auf den Weg zu geben. Nachdem man sie demgemäß versorgt, ");
INSERT INTO deutkw_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","luden sie ihr Getreide auf ihre Esel und zogen von dannen. ");
INSERT INTO deutkw_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Als aber einer von ihnen im Nachtquartier seinen Sack öffnete, um seinem Esel Futter zu geben, da sah er sein Geld in seinem Getreidesack obenauf liegen. ");
INSERT INTO deutkw_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Da berichtete er seinen Brüdern: Mein Geld ist wieder da, hier liegt es in meinem Getreidesack! Da entsank ihnen der Mut, und bebend sahen sie einander an und riefen: Was hat uns da Gott angethan! ");
INSERT INTO deutkw_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Als sie nun zu ihrem Vater Jakob nach Kanaan zurückgekehrt waren, berichteten sie ihm alles, was ihnen begegnet war, und sprachen: ");
INSERT INTO deutkw_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Er, der Herr des Landes, ließ uns hart an und beschuldigte uns, wir wollten das Land auskundschaften. ");
INSERT INTO deutkw_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Wir versicherten ihm zwar: Wir sind ehrliche Leute, wir sind keine Spione! ");
INSERT INTO deutkw_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Wir sind unser zwölf Brüder, Söhne eines Vaters. Einer ist verschwunden, und der Jüngste ist zur Zeit bei unserem Vater in Kanaan. ");
INSERT INTO deutkw_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Aber der Mann, der Herr des Landes, antwortete uns: Daran will ich erkennen, daß ihr ehrliche Leute seid: laßt einen von euch Brüdern bei mir zurück! Was ihr an Getreide für eure Familien bedürft, mögt ihr nehmen und abziehen. ");
INSERT INTO deutkw_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Aber bringt mir euren jüngsten Bruder her, damit ich erkenne, daß ihr keine Spione, daß ihr ehrliche Leute seid. Alsdann werde ich euch euren Bruder wiedergeben, und ihr könnt das Land frei durchziehen. ");
INSERT INTO deutkw_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Als sie aber ihre Säcke ausschütteten, fand sich das Geld eines jeden in seinem Sack. Und als sie samt ihrem Vater ihr Geld erblickten, da erschraken sie. ");
INSERT INTO deutkw_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Da sprach ihr Vater Jakob zu ihnen: Mich beraubt ihr der Kinder! Joseph ist verschwunden, und Simeon ist verschwunden und Benjamin wollt ihr wegnehmen - mich trifft das alles! ");
INSERT INTO deutkw_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Da antwortete Ruben seinem Vater: Meine beiden Söhne magst du umbringen, wenn ich dir ihn nicht zurückbringe. Vertraue mir ihn an, ich werde ihn dir zurückbringen! ");
INSERT INTO deutkw_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Er antwortete: Mein Sohn soll nicht mit euch reisen; denn sein Bruder ist tot, und er ist allein übrig. Wenn ihm ein Unfall zustieße auf dem Wege, den ihr ziehen müßt, so würdet ihr schuld daran sein, wenn ich mit meinem grauen Haar voller Jammer hinunter müßte in die Unterwelt. ");
INSERT INTO deutkw_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Es lastete aber die Hungersnot schwer auf dem Lande. ");
INSERT INTO deutkw_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Als sie nun das Getreide, das sie aus Ägypten geholt, vollständig aufgezehrt hatten, da gebot ihnen ihr Vater: zieht wieder hin, etwas Getreide für uns zu kaufen. ");
INSERT INTO deutkw_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Da antwortete ihm Juda: Jener Mann hat uns nachdrücklich eingeschärft: Ihr dürft mir nicht vor die Augen kommen, wenn ihr nicht euren Bruder mitbringt. ");
INSERT INTO deutkw_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Willst du uns also unseren Bruder mitgeben, so wollen wir hinreisen und Getreide für dich kaufen. ");
INSERT INTO deutkw_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Giebst du ihn uns aber nicht mit, so reisen wir nicht. Denn der Mann hat uns erklärt: Ihr dürft mir nicht vor die Augen kommen, wenn ihr nicht euren Bruder mitbringt. ");
INSERT INTO deutkw_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Israel antwortete: Warum habt ihr mir das zuleide gethan und dem Manne verraten, daß ihr noch einen Bruder habt? ");
INSERT INTO deutkw_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Sie antworteten: Der Mann erkundigte sich genau nach uns und unserer Familie und fragte: Ist euer Vater noch am Leben? Habt ihr noch einen Bruder? Da gaben wir ihm Bescheid, ganz wie es sich verhält. Konnten wir denn wissen, daß er nun sagen würde: Bringt euren Bruder her? ");
INSERT INTO deutkw_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Juda aber sprach zu seinem Vater Israel: Gieb mir den Knaben mit, so wollen wir aufbrechen und hinziehen, damit wir leben bleiben und nicht sterben, wir und du und unsere Kinder. ");
INSERT INTO deutkw_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ich will dir für ihn bürgen; mich sollst du für ihn verantwortlich machen. Wenn ich dir ihn nicht wiederbringe und vor Augen stelle, so will ich all meine Lebtage schuldig vor dir dastehen. ");
INSERT INTO deutkw_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Wenn wir nicht über Gebühr gezaudert hätten, so hätten wir unterdes zweimal hin- und herreisen können. ");
INSERT INTO deutkw_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Da antwortete ihnen ihr Vater Israel: Wenn es denn sein muß, so thut Folgendes: Nehmt in euren Säcken etwas von den Erzeugnissen des Landes mit und bringt dem Manne ein Geschenk: ein wenig Balsam und ein wenig Honig, Spezereien und Ladanum, Pistazien und Mandeln. ");
INSERT INTO deutkw_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Sodann nehmt den gleichen Betrag an Geld noch einmal mit: auch das Geld, das sich wiedergefunden hat oben in euren Säcken, nehmt wieder mit - vielleicht liegt ein Irrtum vor. ");
INSERT INTO deutkw_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Dazu nehmt auch euren Bruder hin, brecht auf und zieht wieder hin zu dem Manne. ");
INSERT INTO deutkw_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Und Gott, der Allmächtige, verleihe, daß sich der Mann barmherzig gegen euch erzeigt, daß er euren anderen Bruder wieder mit euch ziehen läßt, dazu auch Benjamin; ich aber - wenn es denn sein muß, nun so bin ich eben verwaist. ");
INSERT INTO deutkw_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Da nahmen die Männer das erwähnte Geschenk, nahmen auch anderes Geld mit sich, dazu Benjamin, brachen auf, zogen nach Ägypten und traten vor Joseph. ");
INSERT INTO deutkw_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Als nun Joseph wahrnahm, daß Benjamin unter ihnen sei, gebot er seinem Hausmeister: Führe diese Männer hinein ins Haus, schlachte ein Stück Vieh und richte zu; denn diese Männer sollen mittags mit mir essen. ");
INSERT INTO deutkw_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Der Mann that, wie Joseph befohlen hatte, und der Mann führte die Männer hinein in das Haus Josephs. ");
INSERT INTO deutkw_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Da fürchteten sich die Männer, daß sie ins Haus Josephs geführt wurden, und sprachen: Wegen des Geldes, das sich bei unserer ersten Anwesenheit wieder in unsere Säcke verirrte, werden wir hineingeführt: man will sich auf uns werfen, uns überfallen und uns zu Sklaven machen, samt unseren Eseln. ");
INSERT INTO deutkw_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Da traten sie an den Hausmeister Josephs heran und redeten ihn am Eingange des Hauses ");
INSERT INTO deutkw_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","also an: Bitte, mein Herr! Wir sind das erste Mal hierher gereist, nur um Getreide zu kaufen. ");
INSERT INTO deutkw_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Als wir aber ins Nachtquartier gelangt waren und unsere Getreidesäcke aufbanden, da fand sich das Geld eines jeden oben in seinem Getreidesack - unser Geld nach seinem vollen Gewicht; wir haben es jetzt wieder mitgebracht. ");
INSERT INTO deutkw_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Aber auch anderes Geld haben wir mitgebracht, um Getreide zu kaufen. Wir begreifen nicht, wer uns das Geld in die Getreidesäcke gelegt hat. ");
INSERT INTO deutkw_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Da antwortete er: Beruhigt euch; seid ohne Sorge! Euer und eures Vaters Gott hat euch heimlich einen Schatz in eure Getreidesäcke gelegt. Euer Geld ist mir zugekommen. Hierauf führte er Simeon zu ihnen heraus. ");
INSERT INTO deutkw_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Sodann brachte er die Männer ins Haus Josephs. Er gab ihnen Wasser, und sie wuschen ihre Füße, und ihren Eseln reichte er Futter. ");
INSERT INTO deutkw_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Sodann legten sie das Geschenk zurecht und warteten, bis Joseph mittags käme; denn sie hatten vernommen, daß sie dort das Mahl einnehmen sollten. ");
INSERT INTO deutkw_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Als nun Joseph ins Haus eingetreten war, brachten sie ihm das Geschenk, das sie mit sich führten, hinein und verneigten sich vor ihm bis auf den Boden. ");
INSERT INTO deutkw_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Er aber erkundigte sich nach ihrem Befinden und fragte: Geht es eurem alten Vater, von dem ihr spracht, wohl? Ist er noch am Leben? ");
INSERT INTO deutkw_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Sie antworteten: Es geht deinem Diener, unserem Vater, wohl; er ist noch am Leben. Dabei bückten sie sich und verneigten sich. ");
INSERT INTO deutkw_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Da gewahrte er Benjamin, seinen leiblichen Bruder, und fragte: ist das euer jüngster Bruder, von dem ihr mir sagtet? und sprach: Gott gebe dir Gnade, mein Sohn! ");
INSERT INTO deutkw_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Dann aber brach Joseph schnell ab, denn er wurde von tiefer Rührung ergriffen, als er so seinem Bruder gegenüberstand, und suchte, wie er seinen Thränen freien Lauf lassen könne. Daher ging er hinein in das innere Gemach und weinte sich dort aus. ");
INSERT INTO deutkw_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Dann wusch er sich das Gesicht und kam wieder heraus, that sich Gewalt an und befahl: Tragt auf! ");
INSERT INTO deutkw_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Da trug man ihm besonders auf und ihnen besonders und ebenso den Ägyptern, die mit ihm speisten. Die Ägypter dürfen nämlich nicht mit den Hebräern zusammen speisen, denn das gilt den Ägyptern als eine Verunreinigung. ");
INSERT INTO deutkw_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Sie kamen aber vor ihn zu sitzen, vom Ältesten bis zum Jüngsten genau nach dem Alter geordnet; staunend sahen die Männer einander an. ");
INSERT INTO deutkw_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Hierauf ließ er ihnen von den Gerichten vorlegen, die vor ihm standen; es war aber dessen, was man Benjamin vorlegte, fünfmal so viel, als was man allen anderen vorlegte. Sodann tranken sie mit ihm und wurden guter Dinge. ");
INSERT INTO deutkw_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Hierauf gebot er seinem Hausmeister: Fülle den Männern ihre Säcke mit Getreide, soviel sie fortbringen können; lege aber einem jeden sein Geld obenauf in seinen Sack. ");
INSERT INTO deutkw_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Und meinen silbernen Becher legst du obenauf in den Sack des Jüngsten samt dem Geld für sein Getreide. Da that jener so, wie Joseph befohlen hatte. ");
INSERT INTO deutkw_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Kaum war der Morgen angebrochen, ließ man die Männer samt ihren Eseln ziehen. ");
INSERT INTO deutkw_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Eben hatten sie die Stadt verlassen und waren noch nicht weit gekommen, da befahl Joseph seinem Hausmeister: Auf, jage den Männern nach, und wenn du sie eingeholt hast, so sprich zu ihnen: Warum habt ihr Gutes mit Bösem vergolten? Warum habt ihr meinen silbernen Becher gestohlen? ");
INSERT INTO deutkw_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ist's doch derselbe, aus dem mein Gebieter zu trinken pflegt und aus dem er wahrsagt - daran habt ihr sehr übel gethan! ");
INSERT INTO deutkw_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Als er sie nun eingeholt hatte, redete er solchergestalt mit ihnen. ");
INSERT INTO deutkw_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Sie erwiderten ihm: O Herr! warum sprichst du so? Es liegt deinen Sklaven durchaus fern, so etwas zu thun. ");
INSERT INTO deutkw_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Haben wir dir doch das Geld, das wir oben in unseren Säcken fanden, aus Kanaan wieder mitgebracht: wie sollten wir da aus dem Hause deines Gebieters Silber und Gold stehlen? ");
INSERT INTO deutkw_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Derjenige deiner Sklaven, bei dem er sich findet, der soll sterben, und wir anderen wollen dir leibeigen werden. ");
INSERT INTO deutkw_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Er antwortete: Gut! wie ihr sagt, soll es geschehen. Der, bei welchem er sich findet, soll mein Sklave werden; ihr aber sollt frei ausgehn. ");
INSERT INTO deutkw_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Da ließ ein jeder schnell seinen Sack auf den Boden herab und ein jeder öffnete seinen Sack. ");
INSERT INTO deutkw_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Er aber fing an zu suchen: bei dem Ältesten hob er an und bei dem Jüngsten hörte er auf - da fand sich der Becher im Sacke Benjamins. ");
INSERT INTO deutkw_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Da zerrissen sie ihre Kleider, beluden ein jeder seinen Esel und kehrten wieder in die Stadt zurück. ");
INSERT INTO deutkw_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Und als Juda mit seinen Brüdern in das Haus Josephs kam - dieser war gerade noch dort anwesend -, da warfen sie sich vor ihm nieder auf den Boden. ");
INSERT INTO deutkw_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Joseph aber sprach zu ihnen: Was habt ihr da angestellt! Bedachtet ihr denn nicht, daß ein Mann, wie ich, wahrsagen werde? ");
INSERT INTO deutkw_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Da antwortete Juda: Was sollen wir unserem Gebieter sagen? Was sollen wir reden und wie uns rechtfertigen, nachdem Gott die Schuld deiner Sklaven ausfindig gemacht hat! Wir gehören dir leibeigen, wir, sowie derjenige, in dessen Besitze sich der Becher gefunden hat. ");
INSERT INTO deutkw_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Er erwiderte: Ferne sei es von mir, so zu verfahren! Derjenige, in dessen Besitze sich der Becher gefunden hat, der soll mir leibeigen werden; ihr aber mögt unangefochten zu eurem Vater ziehn. ");
INSERT INTO deutkw_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Da trat Juda zu ihm heran und sprach: Bitte, mein Herr! Möchte doch dein Sklave ein freimütiges Wort an dich richten dürfen, ohne daß du darum deinem Sklaven zürnst - stehst du doch dem Pharao gleich! ");
INSERT INTO deutkw_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Mein Gebieter fragte seine Sklaven: Habt ihr euren Vater noch oder noch einen Bruder? ");
INSERT INTO deutkw_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Wir antworteten dir: Unser alter Vater lebt noch, und auch ein kleiner spätgeborener Sohn ist vorhanden. Sein leiblicher Bruder ist tot, und so ist er allein übrig von seiner Mutter und wurde der Liebling seines Vaters. ");
INSERT INTO deutkw_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Da befahlst du deinen Sklaven: Bringt ihn her zu mir, damit ich ihn mit Augen sehe! ");
INSERT INTO deutkw_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Wir erwiderten dir: Der Knabe kann seinen Vater nicht verlassen; denn würde er seinen Vater verlassen, so würde dieser sterben. ");
INSERT INTO deutkw_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Da sprachst du zu deinen Sklaven: Wenn ihr euren jüngsten Bruder nicht mitbringt, so dürft ihr mir nicht mehr unter die Augen kommen. ");
INSERT INTO deutkw_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Als wir nun zu deinem Sklaven, meinem Vater, zurückgekehrt waren, berichteten wir ihm dein Begehren. ");
INSERT INTO deutkw_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Als sodann unser Vater gebot: Zieht wieder hin, etwas Getreide für uns zu kaufen, ");
INSERT INTO deutkw_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","da antworteten wir: Wir können unmöglich hinziehn! Wenn unser jüngster Bruder mit uns geht, so wollen wir hinziehn; denn wir dürfen ja dem Manne nicht mehr unter die Augen kommen, wenn unser jüngster Bruder nicht bei uns ist. ");
INSERT INTO deutkw_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Da antwortete uns dein Sklave, mein Vater: Ihr wißt ja selbst, daß mir mein Weib nur zwei Söhne geboren hat. ");
INSERT INTO deutkw_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Der eine ging fort von mir, und ich mußte mir sagen: Sicherlich ist er zerrissen worden! und bis heute habe ich ihn nicht wiedergesehen. ");
INSERT INTO deutkw_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Wenn ihr mir nun auch diesen noch wegnehmt, und ihm ein Unglück zustoßen sollte, so wäret ihr schuld daran, wenn ich mit meinem grauen Haar in schwerem Leid hinunter müßte in die Unterwelt! ");
INSERT INTO deutkw_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Und in der That, wenn ich jetzt zu deinem Sklaven, meinem Vater, käme, und der Knabe, an dem er doch mit ganzer Seele hängt, wäre nicht bei uns, ");
INSERT INTO deutkw_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","so würde er, sobald er gewahr würde, daß der Knabe nicht mehr bei uns ist, sterben, und deine Sklaven wären schuld daran, wenn dein Sklave, unser Vater, mit seinem grauen Haar voller Jammer hinab müßte in die Unterwelt. ");
INSERT INTO deutkw_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Denn dein Sklave hat sich gegenüber meinem Vater für den Knaben verbürgt und gelobt: Wenn ich dir ihn nicht wiederbringe, so will ich mein Leben lang schuldig dastehen vor meinem Vater. ");
INSERT INTO deutkw_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Möchte somit dein Sklave an Stelle des Knaben zurückbleiben dürfen als Leibeigener meines Gebieters, der Knabe aber heimkehren dürfen mit seinen Brüdern. ");
INSERT INTO deutkw_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Denn wie könnte ich heimkehren zu meinem Vater, ohne daß der Knabe bei mir wäre! Ich könnte den Jammer nicht mit ansehen, der über meinen Vater kommen würde! ");
INSERT INTO deutkw_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Da konnte Joseph nicht länger an sich halten, wie er bisher aus Rücksicht auf seine Umgebung gethan, und rief: Laßt jedermann hinausgehen! So war niemand weiter zugegen, als sich Joseph seinen Brüdern zu erkennen gab. ");
INSERT INTO deutkw_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Da brach er in lautes Weinen aus, so daß es die Ägypter und die Höflinge des Pharao hörten. ");
INSERT INTO deutkw_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Da sprach Joseph zu seinen Brüdern: Ich bin Joseph! Lebt mein Vater noch? Aber seine Brüder vermochten ihm nicht zu antworten, so bestürzt waren sie ihm gegenüber. ");
INSERT INTO deutkw_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Da sprach Joseph zu seinen Brüdern: Tretet doch her zu mir! Und als sie herzutraten, sprach er: Ich bin euer Bruder Joseph, den ihr nach Ägypten verkauft habt! ");
INSERT INTO deutkw_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Nun aber laßt euch das nicht anfechten und geratet nicht in Unmut darüber, daß ihr mich hierher verkauft habt; denn um euch am Leben zu erhalten, hat mich Gott euch vorausgesandt. ");
INSERT INTO deutkw_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Zwei Jahre lastet nun schon die Hungersnot auf dem Lande, und noch stehen fünf Jahre bevor, in denen es kein Pflügen und kein Ernten geben wird. ");
INSERT INTO deutkw_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Gott aber schickte mich euch voraus, um Sorge zu tragen für den Fortbestand eures Stammes, und daß welche von euch am Leben blieben, daß es zu einer großen Errettung käme. ");
INSERT INTO deutkw_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Somit habt nicht ihr mich hierher geschickt, sondern Gott; er machte mich zum vertrauten Ratgeber des Pharao und zum Obersten über seinen ganzen Hof und zum Gebieter über ganz Ägypten. ");
INSERT INTO deutkw_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Zieht nun eilends hin zu meinem Vater und sagt ihm: So läßt dir dein Sohn Joseph sagen: Gott hat mich zum Herrn über ganz Ägypten gemacht; komm zu mir, säume nicht! ");
INSERT INTO deutkw_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","In der Provinz Gosen sollst du wohnen und du sollst in meiner Nähe sein, samt deinen Söhnen und deinen Enkeln, deinen Schafen und Rindern und deinem ganzen Hausstand. ");
INSERT INTO deutkw_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Und ich werde daselbst für deinen Unterhalt sorgen. Denn noch fünf Jahre wird die Hungersnot währen; da könntest du verarmen samt deiner Familie und deinem ganzen Hausstand. ");
INSERT INTO deutkw_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Ihr seht es ja mit leiblichen Augen, und mein Bruder Benjamin sieht es mit leiblichen Augen, daß ich in eigner Person zu euch rede. ");
INSERT INTO deutkw_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Meinem Vater müßt ihr ausführlich berichten über meine hohe Würde in Ägypten und über alles, was ihr gesehen habt, und müßt eilends meinen Vater hierher bringen. ");
INSERT INTO deutkw_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Hierauf fiel er seinem Bruder Benjamin um den Hals und weinte, und Benjamin weinte an seinem Halse. ");
INSERT INTO deutkw_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Sodann küßte er alle seine Brüder und weinte, indem er sie umarmt hielt; darnach besprachen sich seine Brüder mit ihm. ");
INSERT INTO deutkw_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Und die Kunde drang an den Hof des Pharao: die Brüder Josephs sind angekommen! Und der Pharao und seine Umgebung waren erfreut darüber. ");
INSERT INTO deutkw_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Da sprach der Pharao zu Joseph: Sage deinen Brüdern: beladet also nun eure Lasttiere, zieht hin nach Kanaan, ");
INSERT INTO deutkw_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","holt euren Vater und eure Familien und kommt her zu mir, so will ich euch zur Verfügung stellen, was Ägypten irgend Gutes bietet; so sollt ihr vom Besten genießen, was das Land erzeugt. ");
INSERT INTO deutkw_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Du aber gebiete ihnen: Thut also! Nehmt euch aus Ägypten Wagen mit für eure kleinen Kinder und eure Weiber und laßt euren Vater aufsteigen und kommt her. ");
INSERT INTO deutkw_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Laßt euch's aber nicht leid sein um euren Hausrat; denn was Ägypten irgend Gutes bietet, das soll euer sein. ");
INSERT INTO deutkw_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Und die Söhne Israels thaten also, und Joseph gab ihnen Wagen gemäß dem Befehl des Pharao und gab ihnen Zehrung für die Reise. ");
INSERT INTO deutkw_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ihnen allen, Mann für Mann, schenkte er Ehrenkleider, und Benjamin schenkte er 300 Silbersekel und fünf Ehrenkleider. ");
INSERT INTO deutkw_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Seinem Vater aber sandte er gleichfalls zehn Esel, beladen mit den besten Erzeugnissen des Landes, sowie zehn Eselinnen, beladen mit Getreide, Brot und Zehrung für seinen Vater auf die Reise. ");
INSERT INTO deutkw_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Alsdann verabschiedete er seine Brüder, und sie zogen ab, nachdem er sie noch ermahnt hatte: Ereifert euch nicht unterwegs! ");
INSERT INTO deutkw_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","So zogen sie fort aus Ägypten und gelangten nach Kanaan zu ihrem Vater Jakob. ");
INSERT INTO deutkw_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Da berichteten sie ihm: Joseph ist noch am Leben, ja er ist sogar Gebieter über ganz Ägypten. Da wurde er ganz starr, denn er konnte ihnen nicht glauben. ");
INSERT INTO deutkw_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Als sie ihm aber alles berichteten, was Joseph ihnen aufgetragen hatte, und als er die Wagen erblickte, die Joseph gesandt, um ihn hinzubringen, da kam wieder Leben in ihren Vater Jakob. ");
INSERT INTO deutkw_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Da sprach Israel: Genug - mein Sohn Joseph ist noch am Leben! ich will hin und ihn sehen, bevor ich sterbe. ");
INSERT INTO deutkw_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Da brach Israel auf mit seinem ganzen Hausstand und gelangte nach Beerseba; da brachte er dem Gotte seines Vaters Isaak Opfer dar. ");
INSERT INTO deutkw_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Da rief Gott in einem nächtlichen Gesicht Israel und sprach: Jakob, Jakob! Er antwortete: Ich höre! ");
INSERT INTO deutkw_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Da sprach er: Ich bin El, der Gott deines Vaters. Ziehe unbedenklich nach Ägypten, denn dort will ich dich zu einem großen Volke werden lassen. ");
INSERT INTO deutkw_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ich selbst werde mit dir nach Ägypten ziehn und ich selbst werde dich auch wieder zurückbringen; aber Joseph soll dir die Augen zudrücken. ");
INSERT INTO deutkw_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Da brach Jakob auf von Beerseba, und die Söhne Israels hoben ihren Vater Jakob, ihre kleinen Kinder und ihre Frauen auf die Wagen, die der Pharao gesandt hatte, um ihn hinzubringen. ");
INSERT INTO deutkw_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Und sie nahmen ihre Herden und ihre Fahrhabe, die sie in Kanaan erworben hatten, und gelangten nach Ägypten, Jakob mit seiner gesamten Nachkommenschaft; ");
INSERT INTO deutkw_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","seine Söhne und Enkel, seine Töchter und Enkelinnen und seine gesamte Nachkommenschaft brachte er mit sich nach Ägypten. ");
INSERT INTO deutkw_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Dies aber sind die Namen der Nachkommen Israels, die nach Ägypten kamen. Jakob und seine Nachkommen: der erstgeborene Sohn Jakobs Ruben. ");
INSERT INTO deutkw_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Die Söhne Rubens waren: Hanoch, Pallu, Hezron und Karmi. ");
INSERT INTO deutkw_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Die Söhne Simeons: Jemuel, Jamin, Ohad, Jachin, Zohar und Saul, der Sohn der Kanaaniterin. ");
INSERT INTO deutkw_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Die Söhne Levis: Gerson, Kahath und Merari. ");
INSERT INTO deutkw_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Die Söhne Judas: Ger, Onan, Sela, Perez und Serah; Ger und Onan jedoch starben in Kanaan. Die Söhne des Perez aber waren Hezron und Hamul. ");
INSERT INTO deutkw_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Die Söhne Issachars: Tola, Puvva, Job und Simron. ");
INSERT INTO deutkw_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Die Söhne Sebulons: Sered, Elon und Jahleel. ");
INSERT INTO deutkw_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Dies sind die Söhne Leas, die sie Jakob in Mesopotamien gebar, samt seiner Tochter Dina, zusammen 33 Söhne und Töchter. ");
INSERT INTO deutkw_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Die Söhne Gads aber waren: Zaphon, Haggi, Suni und Ezbon, Eri, Arodi und Areli. ");
INSERT INTO deutkw_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Die Söhne Assers: Jimna, Jisva, Jisvi, Bria, dazu ihre Schwester Serah, und die Söhne Brias waren Heber und Malkiel. ");
INSERT INTO deutkw_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Dies sind die Söhne Silpas, die Laban seiner Tochter Lea mitgab; diese gebar sie Jakob, sechzehn Seelen. ");
INSERT INTO deutkw_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Die Söhne Rahels, des Weibes Jakobs, waren Joseph und Benjamin. ");
INSERT INTO deutkw_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Dem Joseph aber wurden in Ägypten Söhne geboren; die gebar ihm Asnath, die Tochter Potipheras, des Oberpriesters von On: Manasse und Ephraim. ");
INSERT INTO deutkw_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Die Söhne Benjamins aber waren Bela und Becher und Asbel, Gera und Naaman, Ehi und Ros, Muppim und Huppim und Ard. ");
INSERT INTO deutkw_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Dies sind die Söhne Rahels, die sie Jakob gebar, zusammen vierzehn Seelen. ");
INSERT INTO deutkw_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Die Söhne Dans aber waren Husim, ");
INSERT INTO deutkw_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","und die Söhne Naphthalis: Jahzeel, Guni, Jezer und Sillem. ");
INSERT INTO deutkw_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Dies sind die Söhne Bilhas, welche Laban seiner Tochter Rahel mitgab; diese gebar sie Jakob, zusammen sieben Seelen. ");
INSERT INTO deutkw_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Die Gesamtzahl der leiblichen Nachkommen Jakobs, die nach Ägypten übersiedelten, ungerechnet die Frauen der Söhne Jakobs, betrug 66 Seelen. ");
INSERT INTO deutkw_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Die Söhne Josephs aber, die ihm in Ägypten geboren wurden, waren zwei an der Zahl. Die Gesamtzahl der Angehörigen Jakobs, die nach Ägypten gelangten, betrug siebzig. ");
INSERT INTO deutkw_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Juda aber sandte er voraus zu Joseph, damit er vor ihm nach Gosen Weisung gebe. Als sie nun nach der Provinz Gosen gelangt waren, ");
INSERT INTO deutkw_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","ließ Joseph seinen Wagen anspannen und fuhr hin nach Gosen seinem Vater Israel entgegen. Und als er mit ihm zusammentraf, fiel er ihm um den Hals und weinte lange an seinem Halse. ");
INSERT INTO deutkw_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Israel aber sprach zu Joseph: Nun will ich gern sterben, nachdem ich dich wiedergesehen habe, daß du noch am Leben bist. ");
INSERT INTO deutkw_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Da sprach Joseph zu seinen Brüdern und zu den Angehörigen seines Vaters: Ich will hin, dem Pharao Bericht zu erstatten, und will ihm sagen: Meine Brüder und die Angehörigen meines Vaters, die in Kanaan waren, sind zu mir gekommen. ");
INSERT INTO deutkw_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Und zwar sind diese Leute Schafhirten - denn sie waren Viehzüchter - und haben ihre Schafe und Rinder und ihre ganze Habe mit hergebracht. ");
INSERT INTO deutkw_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Wenn euch nun der Pharao rufen läßt und fragt: Welches ist euer Beruf? ");
INSERT INTO deutkw_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","so antwortet: Deine Sklaven sind Viehzüchter gewesen von Jugend auf bis heute, sowohl wir, wie unsere Vorfahren - damit ihr in der Provinz Gosen bleiben dürft. Die Schafhirten sind nämlich den Ägyptern ein Gegenstand des Abscheus. ");
INSERT INTO deutkw_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Hierauf ging Joseph hin, that dem Pharao Meldung und sprach: Mein Vater und meine Brüder sind mit ihren Schafen und Rindern und ihrer gesamten Habe aus Kanaan hergekommen und sind nun in der Provinz Gosen. ");
INSERT INTO deutkw_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Er hatte aber fünf aus der Zahl seiner Brüder mitgebracht, die stellte er dem Pharao vor. ");
INSERT INTO deutkw_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Da fragte der Pharao die Brüder Josephs: Welches ist euer Beruf? Sie antworteten dem Pharao: Schafhirten sind deine Sklaven, sowohl wir, wie schon unsere Vorfahren. ");
INSERT INTO deutkw_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Und sie sprachen zum Pharao: Wir sind hergekommen, um uns eine Zeitlang hier aufzuhalten, weil es an Weide gebrach für die Schafherden, die deinen Sklaven gehören; denn die Hungersnot lastet schwer auf dem Lande Kanaan. Möchten also deine Sklaven in der Provinz Gosen verweilen dürfen! ");
INSERT INTO deutkw_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Da sprach der Pharao zu Joseph: Sie mögen in der Provinz Gosen wohnen, und wenn du findest, daß besonders geeignete Leute unter ihnen sind, so mache sie zu Oberhirten über meine Herden. Und Jakob und seine Söhne gelangten zu Joseph nach Ägypten. Als nun der Pharao, der König von Ägypten, davon hörte, da sprach der Pharao zu Joseph: Also dein Vater und deine Brüder sind zu dir gekommen. ");
INSERT INTO deutkw_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Ägypten steht dir zur Verfügung; laß deinen Vater und deine Brüder im fruchtbarsten Teile des Landes wohnen. ");
INSERT INTO deutkw_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Hierauf brachte Joseph seinen Vater Jakob hinein und stellte ihn dem Pharao vor. Jakob aber begrüßte den Pharao mit einem Segenswunsch. ");
INSERT INTO deutkw_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Da fragte der Pharao Jakob: Wie viele Lebensjahre zählst du? ");
INSERT INTO deutkw_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jakob antwortete dem Pharao: Die Dauer meiner Wanderschaft beträgt 130 Jahre. Gering an Zahl und voller Trübsal waren meine Lebensjahre und reichen nicht heran an die Lebensjahre meiner Vorfahren, die sie auf der Wanderschaft zubrachten. ");
INSERT INTO deutkw_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Hierauf nahm Jakob mit einem Segenswunsch Abschied vom Pharao und ging vom Pharao hinweg. ");
INSERT INTO deutkw_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Joseph aber wies seinem Vater und seinen Brüdern Wohnsitze an und gab ihnen eigenen Besitz in Ägypten, im fruchtbarsten Teile des Landes, in der Provinz Ramses, wie der Pharao befohlen hatte. ");
INSERT INTO deutkw_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Und Joseph versorgte seinen Vater und seine Brüder und die ganze Familie seines Vaters mit Brotkorn, unter Berücksichtigung der Kinderzahl. ");
INSERT INTO deutkw_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Es gab aber in allen Landen kein Brotkorn, denn die Hungersnot war überaus drückend, und Ägypten wie Kanaan waren erschöpft infolge der Hungersnot. ");
INSERT INTO deutkw_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Schließlich brachte Joseph alles Geld an sich, das es in Ägypten und Kanaan gab, für das Getreide, das sie kaufen mußten, und Joseph lieferte das Geld ein in den Palast des Pharao. ");
INSERT INTO deutkw_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Als aber das Geld in Ägypten und Kanaan ausgegangen war, kamen alle Ägypter zu Joseph und riefen: Schaff uns Brot! oder sollen wir vor deinen Augen sterben? Denn das Geld ist zu Ende! ");
INSERT INTO deutkw_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Joseph antwortete: Tretet eure Herden ab, so will ich euch Brotkorn für eure Herden geben, wenn das Geld zu Ende ist. ");
INSERT INTO deutkw_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Da brachten sie ihre Herden zu Joseph, und Joseph gab ihnen Brotkorn für die Rosse, die Schaf- und Rinderherden und für die Esel, und versorgte sie um den Preis aller ihrer Herden in selbigem Jahre mit Brotkorn. ");
INSERT INTO deutkw_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","So ging das Jahr herum. Im folgenden Jahre aber kamen sie wieder zu ihm und sprachen zu ihm: Wir können dir nicht verhehlen, Herr: das Geld ist zu Ende, und der Besitz an Vieh ist an dich übergegangen. Nichts ist übrig, was du nehmen könntest, außer unser Leib und unsere Äcker. ");
INSERT INTO deutkw_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Sollen wir etwa vor deinen Augen zu Grunde gehen - wir und unsere Äcker? Kaufe uns und unsere Äcker um Brotkorn, so wollen wir samt unseren Äckern dem Pharao fronpflichtig werden! Aber gieb Saatkorn her, damit wir am Leben bleiben und nicht sterben, und die Äcker nicht zur Wüste werden. ");
INSERT INTO deutkw_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Da kaufte Joseph alle Äcker der Ägypter für den Pharao. Denn die Ägypter verkauften Mann für Mann ihr Feld, weil die Hungersnot auf ihnen lastete; so kam das Land in den Besitz des Pharao. ");
INSERT INTO deutkw_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Und was die Einwohner betrifft, so machte er sie zu Leibeigenen von einem Ende Ägyptens bis zum andern. ");
INSERT INTO deutkw_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Nur die Äcker der Priester kaufte er nicht an. Denn die Priester bezogen ein festes Einkommen vom Pharao und lebten von dem festen Einkommen, welches ihnen der Pharao gewährte; infolgedessen verkauften sie ihre Äcker nicht. ");
INSERT INTO deutkw_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Da sprach Joseph zu den Landesbewohnern: So habe ich euch also nunmehr samt euren Äckern für den Pharao erkauft. Da habt ihr Saatkorn, damit ihr die Äcker besäen könnt. ");
INSERT INTO deutkw_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Aber von den Erträgnissen müßt ihr ein Fünftel an den Pharao abliefern; die anderen vier Fünftel sollen euch verbleiben zum Besäen der Felder, sowie zu eurem Unterhalt und dem eurer Hausgenossen und zur Ernährung eurer kleinen Kinder. ");
INSERT INTO deutkw_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Da riefen sie: Du hast uns das Leben gerettet! Möchten wir uns deiner Huld erfreuen, o Herr, so wollen wir dem Pharao leibeigen sein! ");
INSERT INTO deutkw_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","So legte Joseph den Ägyptern die noch heute bestehende Verpflichtung auf, dem Pharao von ihren Äckern den Fünften abzuliefern; nur die Äcker der Priester fielen dem Pharao nicht zu. ");
INSERT INTO deutkw_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israel aber blieb in Ägypten, in der Provinz Gosen, wohnen, und sie setzten sich darin fest und mehrten sich, so daß sie überaus zahlreich wurden. ");
INSERT INTO deutkw_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Es lebte aber Jakob in Ägypten 17 Jahre, und es belief sich die Lebensdauer Jakobs, seine Lebensjahre, auf 147 Jahre. ");
INSERT INTO deutkw_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Als es nun mit Israel zum Sterben ging, ließ er seinen Sohn Joseph rufen und sprach zu ihm: Wenn ich dir etwas gelte, so lege deine Hand unter meine Hüfte und erweise mir die Liebe und Treue: begrabe mich nicht in Ägypten! ");
INSERT INTO deutkw_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Vielmehr möchte ich bei meinen Vorfahren liegen; darum sollst du mich wegbringen aus Ägypten und mich in ihrem Grabe beisetzen. Da antwortete er: Ich werde thun, wie du wünschest. ");
INSERT INTO deutkw_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Da sprach er: Schwöre mir! Und er schwur ihm; Israel aber verneigte sich auf das Kopfende des Bettes hin. ");
INSERT INTO deutkw_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Nach diesen Begebenheiten berichtete man Joseph: Dein Vater liegt krank! Da nahm er seine beiden Söhne, Manasse und Ephraim, mit sich. ");
INSERT INTO deutkw_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Als man nun Jakob meldete: dein Sohn Joseph ist angekommen, da nahm Israel seine Kräfte zusammen und setzte sich im Bette auf. ");
INSERT INTO deutkw_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Und Jakob sprach zu Joseph: Gott, der Allmächtige, erschien mir zu Lus in Kanaan, segnete mich ");
INSERT INTO deutkw_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","und sprach zu mir: Ich werde dich fruchtbar sein lassen und dir eine zahlreiche Nachkommenschaft verleihen und will einen Haufen von Völkern aus dir hervorgehen lassen, und dieses Land werde ich deinen Nachkommen für immer zum Besitz verleihen. ");
INSERT INTO deutkw_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Deine beiden Söhne aber, die dir in Ägypten geboren wurden, bevor ich zu dir nach Ägypten kam, die sollen mir angehören: Ephraim und Manasse - wie Ruben und Simeon sollen sie mir gelten! ");
INSERT INTO deutkw_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Die Kinder aber, die du nach ihnen erzeugt hast, sollen dir angehören; den Namen eines ihrer Brüder sollen sie führen in dem ihnen zugewiesenen Erbteil. ");
INSERT INTO deutkw_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Als ich aus Mesopotamien zurückkam, da starb mir Rahel unterwegs in Kanaan, als nur noch eine Strecke Wegs bis Ephrath war, und ich begrub sie dort am Wege nach Ephrath, das ist Bethlehem. ");
INSERT INTO deutkw_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Als aber Israel die Söhne Josephs erblickte, da fragte er: Wer sind diese da? ");
INSERT INTO deutkw_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Joseph antwortete seinem Vater: Es sind meine Söhne, die mir Gott allhier geschenkt hat! Da sprach er: Bringe sie her zu mir, daß ich sie segne. ");
INSERT INTO deutkw_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Es waren aber die Augen Israels stumpf vor Alter, so daß er nicht sehen konnte. Als er sie nun näher zu ihm herangebracht hatte, küßte und herzte er sie. ");
INSERT INTO deutkw_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Darauf sprach Israel zu Joseph: Ich hätte nimmermehr geglaubt, dich wiederzusehen: nun hat mich Gott sogar Nachkommen vor dir schauen lassen! ");
INSERT INTO deutkw_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Hierauf ließ sie Joseph wieder zurücktreten und neigte sich tief vor ihm. ");
INSERT INTO deutkw_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Da nahm Joseph die beiden, Ephraim mit seiner Rechten, so daß er zur Linken Israels stand, und Manasse mit seiner Linken, so daß er zur Rechten Israels stand, und führte sie so zu ihm heran. ");
INSERT INTO deutkw_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Da streckte Israel seine Rechte aus und legte sie auf das Haupt Ephraims, obschon er der Jüngere war, und seine Linke auf das Haupt Manasses, legte also seine Hände übers Kreuz, denn Manasse war der ältere. ");
INSERT INTO deutkw_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Sodann segnete er Joseph und sprach: Der Gott, vor dessen Angesicht meine Väter, Abraham und Isaak, gewandelt haben, der Gott, der mein Hirte war, von meinem ersten Atemzuge an bis auf diesen Tag, ");
INSERT INTO deutkw_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","der Engel, der mich errettete aus allen Nöten, er segne die Knaben, und in ihnen soll mein Name und der meiner Vorväter, Abraham und Isaak, fortleben, und sie sollen sich ungemein vermehren auf Erden. ");
INSERT INTO deutkw_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Als nun Joseph wahrnahm, daß sein Vater seine rechte Hand auf das Haupt Ephraims legte, da war ihm das störend; daher ergriff er die Hand seines Vaters, um sie vom Haupt Ephraims hinüberzulegen auf das Haupt Manasses. ");
INSERT INTO deutkw_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Dabei sprach Joseph zu seinem Vater: Nicht so, lieber Vater, denn dieser da ist der Erstgeborene; lege deine Rechte auf sein Haupt! ");
INSERT INTO deutkw_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Sein Vater aber weigerte sich und sprach: Ich weiß wohl, mein Sohn, ich weiß wohl! Auch er soll zu einem Volk und auch er soll mächtig werden. Aber bei alledem soll doch sein jüngerer Bruder mächtiger werden, als er, und seine Nachkommen sollen eine wahre Völkermenge werden. ");
INSERT INTO deutkw_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Und er segnete sie an jenem Tag, indem er sprach: Deinen Namen sollen die Israeliten brauchen, um Segen zu wünschen, indem sie sprechen: Gott mache dich Ephraim und Manasse gleich! und stellte so Ephraim dem Manasse voran. ");
INSERT INTO deutkw_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Hierauf sprach Israel zu Joseph: Ich werde nun bald sterben, aber Gott wird mit euch sein und euch in das Land eurer Väter zurückbringen. ");
INSERT INTO deutkw_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ich aber verleihe dir einen Bergrücken, den ich den Amoritern abgenommen habe mit meinem Schwert und Bogen, daß du ihn voraus habest vor deinen Brüdern. ");
INSERT INTO deutkw_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Da berief Jakob seine Söhne und sprach: versammelt euch, damit ich euch verkündige, was euch in der Folgezeit widerfahren wird! ");
INSERT INTO deutkw_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Schart euch zusammen und hört zu, ihr Söhne Jakobs, ja höret zu eurem Vater Israel! ");
INSERT INTO deutkw_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben! Mein Erstgeborener bist du, meine Kraft und der Erstling meiner Stärke - der erste an Hoheit und der erste an Macht. ");
INSERT INTO deutkw_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Du braustest auf wie Wasser - du sollst nicht der erste sein! Denn du bestiegst das Bett deines Vaters, verübtest damals Entweihung - mein Lager hat er bestiegen! ");
INSERT INTO deutkw_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon und Levi, die Brüder, - Werkzeuge des Frevels sind ihre Schwerter. ");
INSERT INTO deutkw_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ich will nichts zu schaffen haben mit ihren Entwürfen, nichts gemein haben mit ihren Beschlüssen. Denn in ihrem Zorn haben sie Männer gemordet und in ihrem Übermut Stiere verstümmelt. ");
INSERT INTO deutkw_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Verflucht sei ihr Zorn, daß er so heftig war, und ihr Grimm, daß er sich grausam erzeigte! Ich will sie verteilen in Jakob und will sie zerstreuen in Israel. ");
INSERT INTO deutkw_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Juda, dich, dich werden preisen deine Brüder! Es packt deine Hand das Genick deiner Feinde; vor dir werden sich beugen die Söhne deines Vaters. ");
INSERT INTO deutkw_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ein Löwenjunges ist Juda - vom Raube bist du, mein Sohn, hinaufgestiegen. Er hat sich gestreckt, gelagert, wie ein Löwe und wie eine Löwin: wer darf ihn aufreizen? ");
INSERT INTO deutkw_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Nicht wird das Scepter von Juda weichen, noch der Herrscherstab aus seinen Händen, bis der kommt, dem es bestimmt ist, und die Völker sich ihm unterwerfen. ");
INSERT INTO deutkw_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Er bindet an den Weinstock sein Eselsfüllen und an die Edelrebe das Junge seiner Eselin. Er wäscht in Wein sein Kleid und in Traubenblut sein Gewand, ");
INSERT INTO deutkw_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","die Augen trübe von Weinund die Zähne weiß von Milch. ");
INSERT INTO deutkw_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sebulon wird am Meeresufer wohnen, am Gestade der Schiffe, während seine Flanke sich an Zidon lehnt. ");
INSERT INTO deutkw_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Issachar ist ein knochiger Esel, gelagert zwischen den Pferchen. ");
INSERT INTO deutkw_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Und da er fand, daß Ruhe etwas Schönes, und sein Gebiet gar einladend sei, da beugte er seinen Nacken zum Lasttragen und wurde zum dienstbaren Fröner. ");
INSERT INTO deutkw_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan wird Recht schaffen seinem Volk, wie irgend einer der Stämme Israels. ");
INSERT INTO deutkw_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan wird eine Schlange an der Straße sein, eine Hornviper am Wege, die das Roß in die Fersen beißt, so daß der Reiter rückwärts sinkt. ");
INSERT INTO deutkw_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Auf dein Heil harre ich, Jahwe! ");
INSERT INTO deutkw_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad - Streifscharen scharen sich wider ihn; er aber drängt ihnen nach auf ihrer Ferse. ");
INSERT INTO deutkw_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Ascher lebt in Überfluß - ja Königsleckerbissen liefert er. ");
INSERT INTO deutkw_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naphthali ist eine freischweifende Hirschkuh; von ihm kommen anmutige Reden. ");
INSERT INTO deutkw_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Ein junger Fruchtbaum ist Joseph, ein junger Fruchtbaum am Quell. Seine Schößlinge ranken empor an der Mauer. ");
INSERT INTO deutkw_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Es setzten ihm zu und schossen und es befehdeten ihn Pfeilschützen. ");
INSERT INTO deutkw_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Doch unerschütterlich hielt sein Bogen stand, und flink regten sich seine Hände, durch die Hilfe des Starken Jakobs, von dort her, dem Hirten, dem Steine Israels, ");
INSERT INTO deutkw_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","vom Gott deines Vaters - er helfe dir! - und von Gott, dem Allmächtigen, - er segne dich mit Segensfülle vom Himmel droben, mit Segensfülle aus der Wassertiefe, die drunten lagert, mit Segensfülle aus Brüsten und Mutterschoß. ");
INSERT INTO deutkw_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Die Segnungen, die deinem Vater wurden, überragten die Segensfülle der ewigen Berge, die Pracht der ewigen Hügel. Möchten sie kommen auf das Haupt Josephs und auf den Scheitel des Fürsten unter seinen Brüdern! ");
INSERT INTO deutkw_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamin ist ein räuberischer Wolf: am Morgen verzehrt er Raub und abends verteilt er Beute. ");
INSERT INTO deutkw_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Das alles sind die Stämme Israels, zwölf an der Zahl, und das war es, was ihr Vater zu ihnen redete. Und er segnete sie, und zwar segnete er jeden einzelnen mit einem besonderen Segen. ");
INSERT INTO deutkw_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Und er gebot ihnen und sprach zu ihnen: Wenn ich eingegangen bin zu meinen Stammesgenossen, so bringt mich in die Gruft meiner Vorfahren, in die Höhle auf dem Grundstück des Hethiters Ephron, ");
INSERT INTO deutkw_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","in die Höhle auf dem Grundstück Machpela, welches gegenüber Mamre liegt in Kanaan, dem Grundstück, welches Abraham vom Hethiter Ephron zum Erbbegräbnis gekauft hat. ");
INSERT INTO deutkw_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Dort haben sie Abraham und sein Weib Sara bestattet; dort haben sie Isaak und sein Weib Rebeka bestattet, und dort habe ich Lea bestattet, ");
INSERT INTO deutkw_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","auf dem Grundstück, das mit der Höhle darauf von den Hethitern erkauft wurde. ");
INSERT INTO deutkw_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Als aber Jakob mit den Aufträgen an seine Söhne zu Ende war, legte er sich zurück auf das Bett und verschied und ging ein zu seinen Stammesgenossen. ");
INSERT INTO deutkw_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Da warf sich Joseph über seinen Vater her und weinte über ihm und küßte ihn. ");
INSERT INTO deutkw_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Sodann befahl Joseph den Ärzten, die ihm dienten, seinen Vater einzubalsamieren. Da balsamierten die Ärzte Israel ein. ");
INSERT INTO deutkw_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Darüber vergingen 40 Tage, denn diesen Zeitraum erfordert das Einbalsamieren. Die Ägypter aber hielten ihm 70 Tage lang die Totenklage. ");
INSERT INTO deutkw_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Als nun die Klagezeit vorüber war, trug Joseph den Höflingen des Pharao die Bitte vor: Wenn ich euch irgend etwas gelte, so legt für mich ein gutes Wort ein bei dem Pharao in folgender Angelegenheit: ");
INSERT INTO deutkw_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Mein Vater hat mir einen Eid abgenommen und gesagt: Ich werde nun bald sterben; in der Gruft, die ich mir in Kanaan gegraben habe, dort sollst du mich beisetzen. Daher möchte ich nun hinziehn und meinen Vater bestatten, dann werde ich wiederkommen. ");
INSERT INTO deutkw_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Da ließ ihm der Pharao antworten: Ziehe hin und bestatte deinen Vater gemäß dem Eid, den er dich hat schwören lassen. ");
INSERT INTO deutkw_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","So zog denn Joseph hin, um seinen Vater zu bestatten, und mit ihm zogen alle Untergebenen Pharaos, seine ersten Beamten und alle Würdenträger von Ägypten, ");
INSERT INTO deutkw_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","dazu alle Angehörigen Josephs, sowie seine Brüder und die Angehörigen seines Vaters; nur ihre kleinen Kinder, sowie ihre Schafe und Rinder ließen sie in der Provinz Gosen zurück. ");
INSERT INTO deutkw_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Nicht minder begleiteten ihn Wagen und Reiter, so daß es ein ganz gewaltiger Zug war. ");
INSERT INTO deutkw_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Als sie nun bis nach Goren-Haatad gelangt waren, welches jenseits des Jordans liegt, hielten sie dort eine große und sehr feierliche Totenklage ab und er veranstaltete für seinen Vater eine siebentägige Totenfeier. ");
INSERT INTO deutkw_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Als aber die Bewohner des Landes, die Kanaaniter, die Totenfeier zu Goren-haatad gewahrten, sprachen sie: Da findet eine große Totenfeier der Ägypter statt! Von daher heißt der Ort Abel Mizraim; derselbe liegt jenseits des Jordans. ");
INSERT INTO deutkw_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Seine Söhne aber verfuhren mit ihm, wie er ihnen geboten hatte. ");
INSERT INTO deutkw_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Und zwar führten ihn seine Söhne nach Kanaan über und bestatteten ihn in der Höhle auf dem Grundstück Machpela, dem Grundstück, das Abraham von dem Hethiter Ephron zum Erbbegräbnis erworben hatte, gegenüber Mamre. ");
INSERT INTO deutkw_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Hierauf kehrte Joseph, nachdem er seinen Vater bestattet hatte, nach Ägypten zurück, er und seine Brüder und alle, die mit ihm hingezogen waren, um seinen Vater zu bestatten. ");
INSERT INTO deutkw_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Da überlegten die Brüder Josephs - im Hinblick darauf, daß ihr Vater nun tot war -: Wenn nun Joseph etwa feindselig gegen uns auftreten und uns alles das Böse heimzahlen sollte, das wir ihm angethan haben? ");
INSERT INTO deutkw_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Da schickten sie eine Abordnung an Joseph und ließen ihm sagen: Dein Vater hat vor seinem Tode Folgendes angeordnet: ");
INSERT INTO deutkw_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Sprecht also zu Joseph: Ach vergieb doch deinen Brüdern ihre Sünde und Verschuldung, daß sie dir Böses angethan haben! Also vergieb uns, die wir ja auch den Gott deines Vaters verehren, unsere Sünde! Da weinte Joseph, als sie so zu ihm sprachen. ");
INSERT INTO deutkw_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Hierauf gingen seine Brüder selbst hin, warfen sich vor ihm nieder und sprachen: Hier, nimm uns zu Leibeigenen! ");
INSERT INTO deutkw_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Joseph aber erwiderte ihnen: Seid getrost! denn bin ich etwa an Gottes Statt? ");
INSERT INTO deutkw_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ihr freilich sannet Böses wider mich; Gott aber hat es zum Guten gewendet, um auszuführen, was jetzt vorliegt - viele Menschen am Leben zu erhalten! ");
INSERT INTO deutkw_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Seid also nur getrost! Ich werde für euren und eurer Kinder Unterhalt sorgen. So tröstete er sie und sprach ihnen Mut ein. ");
INSERT INTO deutkw_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Es blieben aber Joseph und die zur Familie seines Vaters gehörten in Ägypten wohnen, und Joseph wurde 110 Jahre alt. ");
INSERT INTO deutkw_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Und Joseph erlebte von Ephraim Enkel; auch Machir, dem Sohne Manasses, wurden bei Lebzeiten Josephs Söhne geboren. ");
INSERT INTO deutkw_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Joseph aber sprach zu seinen Brüdern: Wenn ich längst tot bin, wird sich Gott eurer annehmen und euch aus diesem Land in das Land bringen, das er Abraham, Isaak und Jakob zugeschworen hat. ");
INSERT INTO deutkw_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Da ließ Joseph die Söhne Israels schwören und sprach: Wenn sich Gott dereinst eurer annehmen wird, müßt ihr meine Gebeine von hier wegbringen! ");
INSERT INTO deutkw_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Und Joseph starb 110 Jahre alt. Da balsamierten sie ihn ein und legten ihn in Ägypten in einen Sarg. ");
INSERT INTO deutkw_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","So hießen die Söhne Israels, die nach Ägypten gekommen waren; mit Jakob waren sie gekommen, jeder nebst seiner Familie: ");
INSERT INTO deutkw_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Simeon, Levi und Juda. ");
INSERT INTO deutkw_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Issachar, Sebulon und Benjamin. ");
INSERT INTO deutkw_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan und Naphthali, Gad und Asser. ");
INSERT INTO deutkw_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Die Gesamtzahl der Nachkommen Jakobs aber betrug 70 Seelen; Joseph aber war schon in Ägypten. ");
INSERT INTO deutkw_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Hierauf starb Joseph und alle seine Brüder, sowie jenes ganze Geschlecht. ");
INSERT INTO deutkw_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Und die Israeliten waren fruchtbar und nahmen überhand und wurden viel und überaus zahlreich, so daß das Land von ihnen voll war. ");
INSERT INTO deutkw_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Da trat ein neuer König in Ägypten auf, der Joseph nicht mehr gekannt hatte. ");
INSERT INTO deutkw_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Der sprach zu seinen Unterthanen: Das Volk der Israeliten wird ja zahlreicher und mächtiger als wir. ");
INSERT INTO deutkw_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Wohlan, wir wollen klug gegen es verfahren, sonst könnte es allzu zahlreich werden und sich, falls wir in einen Krieg verwickelt werden, auch noch zu unseren Feinden schlagen, uns bekämpfen und aus dem Lande wegziehn! ");
INSERT INTO deutkw_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Da bestellten sie über es Fronvögte, um es zu drücken mit ihren Fronarbeiten, und es baute dem Pharao Vorratsstädte, Pithom und Ramses. ");
INSERT INTO deutkw_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Je mehr sie es aber drückten, desto mehr nahm es zu und breitete sich aus, so daß sie vor den Israeliten Angst bekamen. ");
INSERT INTO deutkw_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Da zwangen die Ägypter die Israeliten zu harter Sklavenarbeit ");
INSERT INTO deutkw_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","und verbitterten ihnen das Leben mit harter Arbeit in Lehm und Ziegeln und allerlei Feldarbeiten, lauter Arbeiten, die sie mit Zwang durch sie ausführen ließen. ");
INSERT INTO deutkw_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Der König von Ägypten aber befahl den Hebammen der Hebräer - die eine derselben hieß Sifra, die andere Pua: ");
INSERT INTO deutkw_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Wenn ihr die Hebräerinnen entbindet, so sollt ihr auf den Gebärstuhl sehen: wenn es ein Knäblein ist, so sollt ihr es ums Leben bringen; wenn es aber ein Mädchen ist, so mag es am Leben bleiben. ");
INSERT INTO deutkw_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Die Hebammen jedoch waren gottesfürchtig und führten nicht aus, was der König von Ägypten ihnen geboten hatte, sondern ließen die Knäblein am Leben. ");
INSERT INTO deutkw_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Da ließ der König von Ägypten die Hebammen rufen und fragte sie: Warum handelt ihr so und laßt die Knäblein am Leben? ");
INSERT INTO deutkw_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Die Hebammen antworteten dem Pharao: Ja, die Hebräerinnen sind nicht, wie die ägyptischen Weiber, sondern kräftig; ehe noch die Hebamme zu ihnen kommt, haben sie immer schon geboren. ");
INSERT INTO deutkw_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Gott aber ließ es den Hebammen gut ergehen, und das Volk wurde zahlreich und sehr stark. ");
INSERT INTO deutkw_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Und weil die Hebammen Gott fürchteten, verlieh er ihnen Kinderreichtum. ");
INSERT INTO deutkw_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Hierauf befahl der Pharao allen seinen Unterthanen: Alle Knäblein, die den Hebräern geboren werden, sollt ihr in den Nil werfen; alle Mädchen aber mögt ihr am Leben lassen. ");
INSERT INTO deutkw_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Ein Mann aus dem Stamme Levis aber heiratete die Tochter Levis. ");
INSERT INTO deutkw_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Da wurde die Frau schwanger und gebar einen Sohn. Als sie nun sah, daß er stattlich war, verheimlichte sie ihn drei Monate lang. ");
INSERT INTO deutkw_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Als sie ihn aber nicht länger verbergen konnte, holte sie für ihn ein Kästchen aus Papyrusschilf, verpichte es mit Asphalt und Pech und setzte es, nachdem sie das Kind hineingelegt hatte, ins Schilf am Ufer des Nils. ");
INSERT INTO deutkw_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Seine Schwester aber paßte nicht weit davon auf, um zu erfahren, was mit ihm geschehen würde. ");
INSERT INTO deutkw_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Da kam die Tochter des Pharao an den Nil, um zu baden. Während nun ihre Begleiterinnen am Ufer des Nils entlang gingen, erblickte sie zwischen dem Röhricht das Kästchen; da schickte sie ihre Sklavin hin und ließ es holen. ");
INSERT INTO deutkw_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Als sie es nun öffnete, war ein weinender Knabe darin. Sie aber fühlte Mitleid mit ihm, denn sie dachte: es wird einer von den Knaben der Hebräer sein. ");
INSERT INTO deutkw_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Da fragte seine Schwester die Tochter des Pharao: Soll ich etwa hingehn und dir eine Amme hebräischer Abkunft herbeirufen, damit sie dir das Knäblein säuge? ");
INSERT INTO deutkw_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Die Tochter des Pharao erwiderte: Ja, geh! Da ging das Mädchen hin und rief die Mutter des Knäbleins herbei. ");
INSERT INTO deutkw_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Und die Tochter des Pharao sprach zu ihr: Wenn du dieses Knäblein mitnimmst und es für mich säugst, so will ich dir den Lohn dafür bezahlen! Da nahm das Weib das Knäblein und säugte es. ");
INSERT INTO deutkw_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Als aber der Knabe herangewachsen war, brachte sie ihn der Tochter des Pharao, und sie nahm ihn als Sohn an und gab ihm den Namen Mose; denn sie sagte: Aus dem Wasser habe ich ihn ja gezogen! ");
INSERT INTO deutkw_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Zu jener Zeit aber begab sich einst Mose, als er herangewachsen war, zu seinen Volksgenossen hinaus und sah, wie sie Frondienste leisten mußten; da bemerkte er, wie ein Ägypter einen Hebräer, einen seiner Volksgenossen, schlug. ");
INSERT INTO deutkw_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Da wandte er sich nach allen Seiten um, und wie er sah, daß niemand zugegen war, erschlug er den Ägypter und verscharrte ihn im Sande. ");
INSERT INTO deutkw_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Am folgenden Tag ging er wieder hinaus, da traf er zwei Hebräer im Streit miteinander. Da fragte er den, der im Unrecht war: Warum schlägst du deinen Genossen? ");
INSERT INTO deutkw_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Der aber sprach: Wer hat dich zum Herrn und Richter über uns bestellt? Gedenkst du mich etwa auch totzuschlagen, wie du den Ägypter totgeschlagen hast? Da bekam Mose Angst, denn er sagte sich: so ist also die Sache doch ruchbar geworden! ");
INSERT INTO deutkw_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Aber auch der Pharao hörte von der Sache; da trachtete er darnach, Mose umbringen zu lassen. Mose jedoch ergriff die Flucht vor dem Pharao und begab sich nach dem Lande der Midianiter. Dort setzte er sich an den Brunnen. ");
INSERT INTO deutkw_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Der Priester der Midianiter aber hatte sieben Töchter; die kamen herbei und wollten Wasser schöpfen und die Tränkrinnen füllen, um die Schafe ihres Vaters zu tränken. ");
INSERT INTO deutkw_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Aber die Hirten kamen herzu und drängten sie auf die Seite. Da stand Mose auf, unterstützte sie und verschaffte ihren Schafen zu trinken. ");
INSERT INTO deutkw_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Als sie nun zu ihrem Vater Reguel kamen, fragte er sie: Warum kommt ihr denn heute so früh? ");
INSERT INTO deutkw_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Sie erwiderten: Ein Mann aus Ägypten hat uns vor den Hirten in Schutz genommen; dazu hat er uns sogar Wasser geschöpft und die Schafe getränkt. ");
INSERT INTO deutkw_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Da sagte er zu seinen Töchtern: Wo ist er denn? Warum habt ihr den Mann dort stehen lassen? Ladet ihn doch ein zur Mahlzeit! ");
INSERT INTO deutkw_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Mose aber entschloß sich, bei dem Manne zu bleiben, und er gab Mose seine Tochter Zipora zum Weibe. ");
INSERT INTO deutkw_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Die gebar einen Sohn, den nannte er Gersom; denn er sprach: Ein Fremdling bin ich geworden in einem fremden Lande. ");
INSERT INTO deutkw_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Da ereignete es sich lange Zeit hernach, daß der König von Ägypten starb. Da seufzten die Israeliten unter der schweren Arbeit und schrieen laut auf, so daß ihr Ruf um Befreiung von der schweren Arbeit zu Gott drang. ");
INSERT INTO deutkw_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Und Gott erhörte ihr Wehklagen und Gott gedachte an seinen Bund mit Abraham, Isaak und Jakob. ");
INSERT INTO deutkw_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Und Gott schaute auf die Israeliten und offenbarte sich ihnen. ");
INSERT INTO deutkw_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Mose aber hütete bei Jethro, seinem Schwiegervater, dem Priester der Midianiter, die Schafe. Als er nun einst die Schafe bis jenseits der Steppe trieb, gelangte er zum Berge Gottes, dem Horeb. ");
INSERT INTO deutkw_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Da erschien ihm der Engel Jahwes in einer Feuerflamme, die aus einem Dornstrauch hervorschlug. Als er aber näher zusah, da brannte der Dornstrauch, ohne daß der Dornstrauch vom Feuer verzehrt wurde. ");
INSERT INTO deutkw_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Da dachte Mose: Ich will doch hingehn und dieses merkwürdige Schauspiel betrachten, warum der Dornstrauch nicht in Feuer aufgeht. ");
INSERT INTO deutkw_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Als nun Jahwe sah, daß er hinging, um es anzusehen, da rief ihn Gott aus dem Dornbusch heraus an: Mose, Mose! Er antwortete: Ich höre! ");
INSERT INTO deutkw_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Hierauf sprach er: Tritt nicht näher herzu! ziehe deine Sandalen aus; denn die Stätte, auf die du trittst, ist heiliger Boden. ");
INSERT INTO deutkw_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Dann sprach er: Ich bin der Gott deines Vaters, der Gott Abrahams, der Gott Isaaks und der Gott Jakobs. Da verhüllte Mose sein Antlitz; denn er fürchtete sich, auf Gott hinzublicken. ");
INSERT INTO deutkw_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Jahwe aber sprach: Ich habe die Bedrückung meines Volks, das in Ägypten ist, zur Genüge angesehen und ihr Rufen um Befreiung von seinen Fronvögten gehört; ja ich weiß, wie sehr es leidet. ");
INSERT INTO deutkw_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Daher komme ich nun herab, es aus der Gewalt der Ägypter zu erretten und es wegzuführen aus jenem Land in ein treffliches und weit ausgedehntes Land, in ein Land, das von Milch und Honig überfließt, in die Wohnsitze der Kanaaniter, Hethiter, Amoriter, Pheresiter, Heviter und Jebusiter. ");
INSERT INTO deutkw_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Und nun ist der Hilferuf der Israeliten zu mir gedrungen, und ich habe wohl gesehen, wie sehr die Ägypter sie quälen. ");
INSERT INTO deutkw_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","So laß dich nun von mir zum Pharao senden und führe mein Volk, die Israeliten, aus Ägypten hinweg. ");
INSERT INTO deutkw_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Mose aber sprach zu Gott: Wer bin ich, daß ich zum Pharao gehen und daß ich die Israeliten aus Ägypten wegführen könnte? ");
INSERT INTO deutkw_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Da sprach er: Ich bin ja mit dir! Und dies soll für dich das Wahrzeichen sein, daß ich dich sende: wenn du das Volk aus Ägypten wegführst, werdet ihr Gott auf diesem Berge verehren. ");
INSERT INTO deutkw_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Und Mose sprach zu Gott: Wenn ich nun aber zu den Israeliten komme und ihnen sage: der Gott eurer Väter hat mich zu euch gesandt, und sie mich fragen: wie heißt er? was soll ich ihnen antworten? ");
INSERT INTO deutkw_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Da erwiderte Gott Mose: Der “Ich bin, der ich bin”; dann sprach er: So sollst du den Israeliten sagen: Der “Ich bin” hat mich zu euch gesandt! ");
INSERT INTO deutkw_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Hierauf sprach Gott weiter zu Mose: So sollst du zu den Israeliten sagen: Jahwe, der Gott eurer Väter, der Gott Abrahams, der Gott Isaaks und der Gott Jakobs hat mich zu euch gesandt; dies ist mein Name auf ewie Zeiten und dies meine Benennung auf Geschlecht und Geschlecht. ");
INSERT INTO deutkw_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Geh hin, rufe die Vornehmsten der Israeliten zusammen und sage ihnen: Jahwe, der Gott eurer Väter, ist mir erschienen, der Gott Abrahams, Isaaks und Jakobs, und hat zugesagt: Ich will Rücksicht nehmen auf euch und auf das, was euch widerfahren ist in Ägypten; ");
INSERT INTO deutkw_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","und ich habe beschlossen: ich will euch aus der Bedrückung in Ägypten befreien und in das Land der Kanaaniter, Hethiter, Amoriter, Pheresiter, Heviter und Jebusiter führen, in ein Land, das von Milch und Honig überfließt. ");
INSERT INTO deutkw_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Und sie werden auf dich hören; dann sollst du mit den Vornehmsten der Israeliten zum Könige von Ägypten gehen, und ihr sollt zu ihm sprechen: Jahwe, der Gott der Hebräer, ist uns begegnet; laß uns daher drei Tagereisen weit in die Steppe ziehen, um Jahwe, unserem Gott, Opfer zu bringen. ");
INSERT INTO deutkw_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Aber ich weiß, daß der König von Ägypten euch nicht gestatten wird, wegzuziehen, wenn nicht durch Zwang. ");
INSERT INTO deutkw_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Dann will ich meine Hand ausrecken und die Ägypter mit allen meinen Wunderthaten, die ich an ihnen verrichten werde, heimsuchen; hernach werden sie euch ziehen lassen. ");
INSERT INTO deutkw_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Auch werde ich diesem Volke bei den Ägyptern Ansehen verschaffen, damit, wenn ihr wegzieht, ihr nicht mit leeren Händen wegzieht. ");
INSERT INTO deutkw_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Sondern jedes Weib soll von ihrer Nachbarin und Hausgenossin verlangen, daß sie ihr silberne und goldene Geräte und Kleider leihe; die sollt ihr euren Söhnen und Töchtern anlegen und sollt so die Ägypter um ihr Eigentum bringen. ");
INSERT INTO deutkw_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Mose aber entgegnete: Wenn sie mir nun aber nicht glauben und mir nicht folgen wollen, sondern sagen: Jahwe ist dir nicht erschienen? ");
INSERT INTO deutkw_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Da sprach Jahwe zu ihm: Was hast du da in der Hand? Er antwortete: Einen Stab. ");
INSERT INTO deutkw_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Da befahl er: Wirf ihn hin auf den Boden! Als er ihn nun auf den Boden warf, verwandelte er sich in eine Schlange, und Mose ergriff vor ihr die Flucht. ");
INSERT INTO deutkw_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Da befahl Jahwe Mose: Strecke deine Hand aus und ergreife sie beim Schwanze! Da streckte er seine Hand aus und faßte sie fest an; da verwandelte sie sich in seiner Hand in einen Stab. ");
INSERT INTO deutkw_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","So müssen sie es glauben, daß dir Jahwe, der Gott ihrer Väter, der Gott Abrahams, der Gott Isaaks und der Gott Jakobs, erschienen ist. ");
INSERT INTO deutkw_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Hierauf befahl ihm Jahwe nochmals: Stecke deine Hand in deine Busentasche! Da steckte er seine Hand in die Busentasche. Als er sie aber wieder herauszog, war sie unversehens aussätzig und schneeweiß geworden. ");
INSERT INTO deutkw_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Hierauf befahl er: Stecke deine Hand nochmals in die Busentasche. Da stecke er seine Hand in die Busentasche; als er sie aber wieder herauszog, war sie unversehens seinem Fleische wieder gleich geworden. ");
INSERT INTO deutkw_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Und wenn sie dir nicht glauben und auf das erste Wunderzeichen hin nicht folgen, so werden sie auf das zweite Wunderzeichen hin glauben. ");
INSERT INTO deutkw_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Wenn sie aber auch auf diese beiden Wunderzeichen hin nicht glauben und dir nicht folgen wollen, so sollst du etwas Wasser aus dem Nil schöpfen und es auf den Boden gießen; dann soll sich das Wasser, das du aus dem Nile schöpfest, auf dem Boden in Blut verwandeln. ");
INSERT INTO deutkw_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Da sprach Mose zu Jahwe: Mit Verlaub, Herr! Ich bin kein Mann, der reden kann, sondern meine Sprache und meine Zunge sind schwerfällig. ");
INSERT INTO deutkw_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Jahwe aber antwortete ihm: Wer hat denn dem Menschen den Mund erschaffen? oder wer macht einen stumm oder taub oder sehend oder blind? Bin nicht ich es, Jahwe? ");
INSERT INTO deutkw_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Geh also nur! Ich werde dir helfen zu reden und dich unterweisen, was du sagen sollst. ");
INSERT INTO deutkw_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Er aber sprach: Bitte, Herr! sende doch lieber irgend einen andern! ");
INSERT INTO deutkw_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Da wurde Jahwe zornig über Mose und sprach: Ist denn nicht Aaron, dein Bruder, der Levit, da? Von dem weiß ich, daß er gar wohl reden kann. Zudem wird er dir entgegen kommen und eine große Freude haben, wenn er dich erblickt. ");
INSERT INTO deutkw_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Dann magst du mit ihm sprechen und ihm die Reden überweisen; ich aber werde sowohl dir, als ihm, helfen zu reden und euch unterweisen, was ihr zu thun habt. ");
INSERT INTO deutkw_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","So soll er dann für dich zum Volke reden und dein Mund sein; du aber sollst für ihn gleichsam Gott sein. ");
INSERT INTO deutkw_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Und den Stab da nimm in die Hand; damit sollst du die Wunderzeichen verrichten. ");
INSERT INTO deutkw_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Hierauf kehrte Mose zu seinem Schwiegervater Jethro zurück und sprach zu ihm: Ich möchte aufbrechen und zu meinen Verwandten in Ägypten zurückkehren, um zu sehen, ob sie noch am Leben sind. Jethro antwortete Mose: Ziehe hin, möge es dir wohlgehen! ");
INSERT INTO deutkw_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Und Jahwe sprach zu Mose in Midian: Auf! kehre nach Ägpyten zurück; denn alle die, die dir nach dem Leben trachteten, sind gestorben. ");
INSERT INTO deutkw_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Da ließ Mose sein Weib und seine Söhne auf einen Esel sitzen und brach auf nach Ägypten; den Stab Gottes aber nahm Mose in die Hand. ");
INSERT INTO deutkw_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Hierauf sprach Jahwe zu Mose: Wenn du nach Ägypten zurückkehrst, so habe acht: alle die Wunderthaten, die ich in deine Macht lege, sollst du vor dem Pharao ausführen; ich aber werde seinen Sinn verhärten, so daß er das Volk nicht wird ziehen lassen. ");
INSERT INTO deutkw_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Du aber sollst zum Pharao sagen: So spricht Jahwe: Mein erstgeborener Sohn ist Israel. ");
INSERT INTO deutkw_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Ich befehle dir hiermit: Laß meinen Sohn ziehen, damit er mich verehre; wenn du dich aber weigerst, ihn ziehen zu lassen, so werde ich deinen erstgeborenen Sohn sterben lassen! ");
INSERT INTO deutkw_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Unterwegs aber in einer Herberge überfiel ihn Jahwe und suchte ihm das Leben zu nehmen. ");
INSERT INTO deutkw_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Da nahm Zipora einen scharfen Stein, schnitt damit die Vorhaut ihres Sohnes ab und berührte damit seine Scham, indem sie sprach: Ein Blutbräutigam bist du mir! ");
INSERT INTO deutkw_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Da ließ er von ihm ab. Damals sprach sie Blutbräutigam zu den Beschneidungen. ");
INSERT INTO deutkw_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Da befahl Jahwe Aaron: Geh Mose entgegen in die Steppe! Der ging hin und begegnete ihm am Berge Gottes; da küßte er ihn. ");
INSERT INTO deutkw_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Und Mose berichtete Aaron alle Reden Jahwes, mit denen er ihn beauftragt, und alle Wunderzeichen, die er ihm anbefohlen hatte. ");
INSERT INTO deutkw_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Hierauf gingen Mose und Aaron hin und riefen alle Vornehmen der Israeliten zusammen. ");
INSERT INTO deutkw_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Und Aaron verkündete alle die Aufträge, die Jahwe Mose gegeben hatte, und dieser verrichtete die Wunderzeichen vor den Augen des Volks. ");
INSERT INTO deutkw_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Da glaubte das Volk daran, als sie vernahmen, daß Jahwe sich der Israeliten angenommen und ihre Bedrückung beachtet habe, und sie verneigten sich und warfen sich zu Boden. ");
INSERT INTO deutkw_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Hernach gingen Mose und Aaron hin und sprachen zum Pharao: So befiehlt Jahwe, der Gott Israels: Laß mein Volk ziehen, damit sie mir in der Steppe ein Fest feiern! ");
INSERT INTO deutkw_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Der Pharao aber erwiderte: Wer ist Jahwe, daß ich ihm gehorchen und Israel ziehen lassen sollte? Ich weiß nichts von Jahwe und werde Israel auch nicht ziehen lassen! ");
INSERT INTO deutkw_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Sie sprachen: Der Gott der Hebräer ist uns begegnet; laß uns also drei Tagereisen weit in die Steppe ziehen, um Jahwe, unserem Gott, Opfer zu bringen; sonst sucht er uns heim mit Pest oder Schwert. ");
INSERT INTO deutkw_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Der König von Ägypten aber erwiderte ihnen: Warum, Mose und Aaron, wollt ihr das Volk von seiner Arbeit abziehn? Geht an eure Frondienste! ");
INSERT INTO deutkw_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Und der Pharao sprach: Es ist des Volkes wahrlich schon so genug im Land, und da wollt ihr noch, daß es aufhört, Frondienste zu verrichten? ");
INSERT INTO deutkw_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","An eben demselben Tage gab der Pharao den Fronvögten, die über das Volk gesetzt waren, und seinen Aufsehern folgenden Befehl: ");
INSERT INTO deutkw_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Ihr sollt nicht mehr, wie bisher, dem Volk Häckerling liefern zur Verfertigung der Backsteine, sondern sie selbst sollen hingehen und sich Häckerling suchen. ");
INSERT INTO deutkw_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Aber die festgesetzte Zahl von Backsteinen, die sie bisher verfertigten, sollt ihr ihnen auferlegen und nichts davon ablassen. Denn sie gehen müßig; deshalb verlangen sie ungestüm: Wir wollen hingehen, um unserem Gott Opfer zu bringen! ");
INSERT INTO deutkw_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Die Arbeit muß den Leuten erschwert werden, so daß sie daran zu thun haben und nicht auf Vorspiegelungen achten! ");
INSERT INTO deutkw_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Da gingen die Fronvögte und Aufseher des Volkes hin und berichteten dem Volke: So hat der Pharao angeordnet: Ich lasse euch keinen Häckerling mehr liefern. ");
INSERT INTO deutkw_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Ihr selbst müßt hingehen, euch Häckerling zu suchen. ");
INSERT INTO deutkw_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Die Fronvögte aber setzten ihnen hart zu und befahlen: Ihr müßt Tag für Tag die volle Arbeit liefern, wie zu der Zeit, wo Häckerling da war. ");
INSERT INTO deutkw_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Den Aufsehern der Israeliten aber, welche die Fronvögte des Pharao ihnen als Vorgesetzte gegeben hatten, ließ man Schläge geben und fragte sie: Warum habt ihr den Betrag an Backsteinen, der euch bisher auferlegt war, in den letzten Tagen nicht voll geliefert? ");
INSERT INTO deutkw_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Da gingen die Aufseher der Israeliten hin und beklagten sich flehentlich beim Pharao, indem sie sprachen: O Herr! Warum lässest du uns so behandeln? ");
INSERT INTO deutkw_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Häckerling wird uns nicht mehr geliefert, und dennoch heißt es: Schafft Ziegel! Nun werden wir gar noch geschlagen! Du versündigst dich an deinem Volk. ");
INSERT INTO deutkw_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Er aber erwiderte: Faul seid ihr, faul! Deswegen sagt ihr: Wir wollen hingehen, um Jahwe Opfer zu bringen. ");
INSERT INTO deutkw_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Geht sofort an eure Arbeit; Häckerling wird euch nicht geliefert, aber den vollen Betrag an Backsteinen müßt ihr liefern! ");
INSERT INTO deutkw_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","So fanden sich die Aufseher der Israeliten in der schlimmen Lage, sagen zu müssen: Ihr bekommt von eurem täglichen Betrag an Backsteinen nichts erlassen! ");
INSERT INTO deutkw_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Als sie nun den Pharao verließen, trafen sie auf Mose und Aaron, die dort standen, um ihnen zu begegnen, ");
INSERT INTO deutkw_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","und sagten zu ihnen: Jahwe strafe euch und helfe uns zum Recht, daß ihr uns beim Pharao und seinen Höflingen in schwere Ungnade gebracht, ja ihnen das Schwert in die Hand gedrückt habt, um uns das Leben zu nehmen! ");
INSERT INTO deutkw_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Da wandte sich Mose wieder an Jahwe zu sprach: O Herr! Warum lässest du diesem Volke solches Unheil widerfahren? Wozu hast du mich denn gesandt? ");
INSERT INTO deutkw_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Denn seitdem ich zum Pharao gegangen bin, um in deinem Namen zu reden, behandelt er dieses Volk nur noch härter, und du hast dein Volk keineswegs errettet! ");
INSERT INTO deutkw_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Jahwe aber erwiderte Mose: Nun sollst du sehen, was ich dem Pharao anthun werde: von starker Hand gezwungen wird er sie ziehen lassen und von starker Hand gezwungen wird er sie aus seinem Lande treiben. ");
INSERT INTO deutkw_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Da redete Gott mit Mose und sprach zu ihm: Ich bin Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Ich bin einst als Gott, der Allmächtige, Abraham, Isaak und Jakob erschienen; aber unter meinem Namen Jahwe habe ich mich ihnen nicht offenbart. ");
INSERT INTO deutkw_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Und ich habe mit ihnen sogar auch ein Abkommen getroffen, daß ich ihnen das Land Kanaan, das Land, in dem sie als Fremdlinge weilten, zu eigen geben wolle. ");
INSERT INTO deutkw_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Nun aber habe ich das Wehklagen der Israeliten über die Knechtung, die ihnen von den Ägyptern widerfährt, erhört und gedachte an meine Zusage. ");
INSERT INTO deutkw_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Sage daher den Israeliten: Ich bin Jahwe; ich will euch erlösen von dem Frondienste, den ihr den Ägyptern leistet, und euch herausreißen aus eurer Sklavenarbeit und euch befreien mit ausgerecktem Arm und mit großartigen Machterweisen ");
INSERT INTO deutkw_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","und will euch zu meinem Volk erwählen und will euer Gott sein, und ihr sollt erkennen, daß ich Jahwe, euer Gott, bin, der euch erlöst von dem Frondienst in Ägypten, ");
INSERT INTO deutkw_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","und ich will euch in das Land bringen, das ich geschworen habe, Abraham, Isaak und Jakob zu verleihen, und will es euch zum Besitz geben, ich, Jahwe! ");
INSERT INTO deutkw_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Mose richtete dies den Israeliten aus; sie aber hörten nicht auf Mose, aus Kleinmut und weil sie so hart zu arbeiten hatten. ");
INSERT INTO deutkw_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Hierauf sprach Jahwe zu Mose also: ");
INSERT INTO deutkw_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Geh hin und fordere den Pharao, den König von Ägypten, auf, er solle die Israeliten aus seinem Lande wegziehen lassen. ");
INSERT INTO deutkw_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Mose aber redete vor Jahwe also: Haben die Israeliten nicht auf mich gehört, wie sollte denn der Pharao auf mich hören, zumal ich unbeholfen bin im Reden! ");
INSERT INTO deutkw_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Da redete Jahwe mit Mose und Aaron und ordnete sie ab an die Israeliten und an den Pharao, den König von Ägypten, um die Israeliten aus Ägypten wegzuführen. ");
INSERT INTO deutkw_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Dies sind die Familienhäupter ihrer Stammväter: Die Söhne Rubens, des Erstgeborenen Israels, waren Hanoch, Pallu, Hezron und Charmi; dies sind die Geschlechter Rubens; ");
INSERT INTO deutkw_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Und die Söhne Simeons: Jemuel, Jamin, Ohad, Jachin, Zohar und Saul, der Sohn der Kanaaniterin; dies sind die Geschlechter Simeons. ");
INSERT INTO deutkw_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Und so hießen die Söhne Levis nach ihrem Stammbaum: Gerson, Kahath, Merari. Levi aber wurde 137 Jahre alt. ");
INSERT INTO deutkw_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Die Söhne Gersons waren Libni und Simei nach ihren Geschlechtern. ");
INSERT INTO deutkw_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Und die Söhne Kahaths waren Amram, Jezear, Hebron und Usiel. Kahath aber wurde 133 Jahre alt. ");
INSERT INTO deutkw_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Und die Söhne Meraris waren Maheli und Musi; dies sind die Geschlechter Levis nach ihrem Stammbaum. ");
INSERT INTO deutkw_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram aber heiratete Jochebed, seine Muhme; die gebar ihm Aaron und Mose. Und Amram wurde 137 Jahre alt. ");
INSERT INTO deutkw_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Und die Söhne Jezears waren Korah und Nepheg und Sichri, ");
INSERT INTO deutkw_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","und die Söhne Usiels: Misael, Elzaphan und Sithri. ");
INSERT INTO deutkw_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aaron aber heiratete Eliseba, die Tochter Amminadabs, die Schwester Nahassons; die gebar ihm Nadab und Abihu, Eleasar und Ithamar. ");
INSERT INTO deutkw_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Und die Söhne Korahs waren Assir, Elkana und Abiasaph; dies sind die Geschlechter der Korahiter. ");
INSERT INTO deutkw_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleasar aber, der Sohn Aarons, heiratete eine der Töchter Putiels, die gebar ihm Pinehas; das sind die Stammhäupter der Leviten nach ihren Geschlechtern. ");
INSERT INTO deutkw_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Das waren Aaron und Mose, denen Jahwe befahl: Führt die Scharen der Israeliten aus Ägypten hinweg! ");
INSERT INTO deutkw_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Das waren die, welche dem Pharao, dem Könige von Ägypten ankündigten, daß sie die Israeliten aus Ägypten wegführen würden - Mose und Aaron. ");
INSERT INTO deutkw_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Als nun Jahwe mit Mose in Ägypten redete, ");
INSERT INTO deutkw_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","da sprach Jahwe zu Mose also: Ich bin Jahwe! Richte dem Pharao, dem Könige von Ägypten, alles aus, was ich dir sagen werde. ");
INSERT INTO deutkw_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Mose aber sprach vor Jahwe: Ich bin ja unbeholfen im Reden; wie wird der Pharao auf mich hören? ");
INSERT INTO deutkw_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Jahwe aber erwiderte Mose: Ich will dich für den Pharao wie zu einem Gotte machen; dein Bruder Aaron aber soll dein Sprecher sein. ");
INSERT INTO deutkw_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Du sollst alles, was ich dir sage, weiter berichten; dein Bruder Aaron aber soll es dem Pharao vortragen, damit er die Israeliten aus seinem Lande wegziehen läßt. ");
INSERT INTO deutkw_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Ich aber will den Sinn des Pharao verhärten und will zahlreiche Zeichen und Wunderthaten in Ägypten verrichten. ");
INSERT INTO deutkw_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Der Pharao jedoch wird euch kein Gehör geben; dann will ich Hand anlegen an die Ägypter und meine Heerescharen, mein Volk, die Israeliten, unter großartigen Machtbeweisen aus Ägypten hinwegführen. ");
INSERT INTO deutkw_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Dann sollen die Ägypter erkennen, daß ich Jahwe bin, wenn ich die Ägypter meine Macht fühlen lasse und die Israeliten aus ihrer Mitte hinwegführe. ");
INSERT INTO deutkw_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Da thaten Mose und Aaron, wie ihnen Jahwe befohlen hatte; also thaten sie. ");
INSERT INTO deutkw_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Mose aber war achtzig Jahre und Aaron dreiundachtzig Jahre alt, als sie mit dem Pharao verhandelten. ");
INSERT INTO deutkw_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Hierauf sprach Jahwe zu Mose und Aaron also: ");
INSERT INTO deutkw_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Wenn euch der Pharao auffordert: verrichtet ein Wunder! so sollst du Aaron gebieten: Auf, wirf deinen Stab vor den Pharao hin, so wird er sich in eine große Schlange verwandeln. ");
INSERT INTO deutkw_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Da begaben sich Mose und Aaron zum Pharao hinein und thaten so, wie Jahwe geboten hatte: Aaron warf seinen Stab vor dem Pharao und seinen Höflingen hin, da verwandelte er sich in eine große Schlange. ");
INSERT INTO deutkw_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Der Pharao aber ließ die Gelehrten und Zaubereikundigen rufen; da machten sie, die Zauberer von Ägypten, mittels ihrer Geheimkünste es ebenso: ");
INSERT INTO deutkw_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","ein jeder warf seinen Stab hin, da verwandelten sich diese in große Schlangen; jedoch der Stab Aarons verschlang ihre Stäbe. ");
INSERT INTO deutkw_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Aber der Sinn des Pharao blieb verhärtet, und er willfahrte ihnen nicht, wie Jahwe vorausgesagt hatte. ");
INSERT INTO deutkw_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Hierauf sprach Jahwe zu Mose: Der Sinn des Pharao ist verstockt; er weigert sich, das Volk ziehen zu lassen. ");
INSERT INTO deutkw_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Begieb dich morgen früh zum Pharao und tritt ihm, wenn er hingeht ans Wasser, am Ufer des Nils entgegen mit dem Stabe, der sich in eine Schlange verwandelt hat, in der Hand, ");
INSERT INTO deutkw_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","und sprich zu ihm: Jahwe, der Gott der Hebräer, hat mich zu dir gesandt, um dich aufzufordern: laß mein Volk ziehen, damit sie mich in der Steppe verehren. Aber du hast bis jetzt nicht gehorcht. ");
INSERT INTO deutkw_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","So spricht Jahwe: Daran sollst du erkennen, daß ich Jahwe bin: ich werde mit dem Stabe, den ich in der Hand habe, ins Wasser des Nils schlagen, so soll es sich in Blut verwandeln. ");
INSERT INTO deutkw_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Die Fische aber die im Nile sind, sollen umkommen, und der Nil soll stinken, so daß es die Ägypter ekeln wird, Wasser aus dem Nile zu trinken. ");
INSERT INTO deutkw_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Da sprach Jahwe zu Mose: Befiehl Aaron: Nimm deinen Stab und recke deine Hand aus über die Gewässer Ägyptens, über seine Bäche, Kanäle, Teiche und alle Behälter mit Wasser: es soll zu Blut werden, und Blut soll entstehen in ganz Ägypten, sowohl in hölzernen als in steinernen Gefäßen. ");
INSERT INTO deutkw_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Da thaten Mose und Aaron so, wie ihnen Jahwe geboten hatte. Und er hob den Stab und schlug damit das Wasser im Nil vor den Augen des Pharao und seiner Höflinge: da verwandelte sich alles Wasser, das im Nil war, in Blut. ");
INSERT INTO deutkw_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Und die Fische im Nil kamen um und der Nil wurde stinkend, so daß die Ägypter kein Wasser aus dem Nile mehr trinken konnten. Da entstand Blut überall in Ägypten. ");
INSERT INTO deutkw_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Die Zauberer Ägyptens aber brachten mittels ihrer Geheimkünste dasselbe zustande. Da blieb der Sinn des Pharao verhärtet, und er willfahrte ihnen nicht, wie Jahwe vorausgesagt hatte. ");
INSERT INTO deutkw_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Da wandte sich der Pharao ab und begab sich nach Hause, ohne daß er selbst dies zu Herzen nahm. ");
INSERT INTO deutkw_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Die Ägypter aber gruben insgesamt in der Umgebung des Nils nach Wasser, um es zu trinken, denn sie konnten das Wasser des Nils nicht trinken. ");
INSERT INTO deutkw_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Und die Plage, welche Jahwe mit dem Nil eintreten ließ, währte sieben volle Tage. ");
INSERT INTO deutkw_vpl VALUES ("EX7_26","003_7_26","EXO","7","26","26","Hierauf befahl Jahwe Mose: Begieb dich zum Pharao und kündige ihm an: So spricht Jahwe: Laß mein Volk ziehen, damit es mich verehre! ");
INSERT INTO deutkw_vpl VALUES ("EX7_27","003_7_27","EXO","7","27","27","Wenn du dich aber weigerst, es ziehen zu lassen, so werde ich über dein ganzes Land eine Froschplage bringen. ");
INSERT INTO deutkw_vpl VALUES ("EX7_28","003_7_28","EXO","7","28","28","Und im Nile soll's wimmeln von Fröschen, und sie sollen herauskommen und bis in deinen Palast und in dein Schlafgemach und auf dein Ruhelager dringen, sowie in die Wohnungen deiner Höflinge und deiner Unterthanen, auch in deine Backöfen und deine Teigmulden, ");
INSERT INTO deutkw_vpl VALUES ("EX7_29","003_7_29","EXO","7","29","29","ja an dich selbst, deine Unterthanen und alle deine Höflinge sollen die Frösche herankriechen. ");
INSERT INTO deutkw_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Und Jahwe sprach zu Mose: Gebiete Aaron: Recke deine Hand nebst dem Stabe aus über die Bäche, die Kanäle und Teiche und führe Frösche herbei über Ägypten! ");
INSERT INTO deutkw_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Da reckte Aaron seine Hand aus über die Gewässer Ägyptens und führte Frösche herbei, so daß sie Ägypten bedeckten. ");
INSERT INTO deutkw_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Aber auch die Zauberer brachten dies mittels ihrer Geheimkünste zustande, und führten Frösche herbei über ganz Ägypten. ");
INSERT INTO deutkw_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Da ließ der Pharao Mose und Aaron rufen und bat: Legt bei Jahwe Fürbitte ein, daß er mich und mein Volk von den Fröschen befreie; so will ich das Volk ziehen lassen, damit sie Jahwe Opfer bringen. ");
INSERT INTO deutkw_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Mose erwiderte dem Pharao: Beliebe zu bestimmen, auf wann ich für dich, deine Höflinge und Unterthanen Fürbitte einlegen soll, daß du und deine Paläste von den Fröschen befreit werden, und nur im Nile noch welche übrig bleiben. ");
INSERT INTO deutkw_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Er antwortete: Morgen! Da sprach er: Wie du es wünschtest, damit du erfahrest, daß es keinen giebt, wie Jahwe unsern Gott. ");
INSERT INTO deutkw_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Du und deine Paläste, deine Höflinge und Unterthanen sollen von den Fröschen befreit werden; nur im Nile sollen welche übrig bleiben. ");
INSERT INTO deutkw_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Als nun Mose und Aaron den Pharao verlassen hatten, da betete Mose inständig zu Jahwe in betreff der Frösche, mit denen er den Pharao heimgesucht hatte. ");
INSERT INTO deutkw_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Jahwe aber that, wie Mose erbeten hatte: da starben die Frösche, die in den Häusern, Höfen und auf den Feldern waren, hinweg, ");
INSERT INTO deutkw_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","und man schüttete sie auf zahllose Haufen zusammen; im ganzen Land aber gab es üblen Geruch. ");
INSERT INTO deutkw_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Als jedoch der Pharao merkte, daß er Luft bekommen hatte, wurde er wieder verstockt und willfahrte ihnen nicht, wie Jahwe vorausgesagt hatte. ");
INSERT INTO deutkw_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Hierauf sprach Jahwe zu Mose: Befiehl Aaron: Strecke deinen Stab aus und schlage damit den Staub auf dem Boden, so soll er sich in Stechmücken verwandeln überall in Ägypten! ");
INSERT INTO deutkw_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Und sie thaten so: Aaron reckte seine Hand nebst dem Stabe aus und schlug damit den Staub auf dem Boden. Da kamen Stechmücken an die Menschen und an das Vieh; aller Staub auf dem Boden wurde zu Stechmücken in ganz Ägypten. ");
INSERT INTO deutkw_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Da suchten die Zauberer mittels ihrer Geheimkünste ebenso Stechmücken hervorzubringen; aber sie waren es nicht imstande. Die Stechmücken aber kamen an Menschen und Vieh. ");
INSERT INTO deutkw_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Da sprachen die Zauberer zum Pharao: Das ist Gottes Finger! Aber der Sinn des Pharao blieb verstockt, und er willfahrte ihnen nicht, wie Jahwe vorausgesagt hatte. ");
INSERT INTO deutkw_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Hierauf befahl Jahwe Mose: Tritt morgen früh vor den Pharao, wenn er ans Wasser geht, und sprich zu ihm: So gebietet Jahwe: Laß mein Volk ziehen, damit es mich verehre! ");
INSERT INTO deutkw_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Denn wenn du mein Volk nicht ziehen lässest, so will ich über dich, deine Höflinge, deine Unterthanen und deine Paläste Hundsfliegen kommen lassen; die Wohnungen der Ägypter sollen voll von Hundsfliegen sein, ja selbst der Boden, auf dem sie stehen. ");
INSERT INTO deutkw_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Mit dem Lande Gosen aber, in welchem mein Volk sich aufhält, werde ich eine Ausnahme machen, so daß sich dort keine Hundsfliegen zeigen sollen, damit du erkennest, daß ich Herr bin auf Erden. ");
INSERT INTO deutkw_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Und ich will einen Unterschied machen zwischen meinem und deinem Volk; morgen soll dieses Wunder geschehen! ");
INSERT INTO deutkw_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Und Jahwe that so; da drang ein großer Schwarm von Hundsfliegen in den Palast des Pharao und die Wohnungen seiner Höflinge in ganz Ägypten, und das Land litt schwer unter den Hundsfliegen. ");
INSERT INTO deutkw_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Da ließ der Pharao Mose und Aaron rufen und sprach zu ihnen: Wohlan! bringt doch euerem Gott hier im Lande Opfer! ");
INSERT INTO deutkw_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Mose aber erwiderte: es geht nicht an, daß wir so thun; denn wir bringen Jahwe, unserem Gott, Opfer, die den Ägyptern ein Greuel sind. Wenn wir nun vor der Ägypter Augen Opfer bringen wollten, die ihnen ein Greuel sind, werden sie uns da nicht steinigen? ");
INSERT INTO deutkw_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Wir wollen drei Tagereisen weit in die Steppe ziehen und dort Jahwe, unserem Gott, ein Opfer bringen, wie er es uns geboten hat. ");
INSERT INTO deutkw_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Der Pharao aber sprach: Ich will euch ziehen lassen, damit ihr Jahwe, euerem Gott, in der Steppe opfern könnt; nur entfernt euch nicht allzuweit! Legt Fürbitte für mich ein! ");
INSERT INTO deutkw_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Mose erwiderte: O König! Sobald ich draußen bin, werde ich bei Jahwe Fürbitte einlegen, daß morgen die Hundsfliegen von dir, deinen Höflingen und Unterthanen weichen sollen; nur halte das Volk nicht abermals zum besten, indem du es doch nicht ziehen lässest, um Jahwe Opfer zu bringen. ");
INSERT INTO deutkw_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Hierauf verließ Mose den Pharao; sodann legte er Fürbitte bei Jahwe ein. ");
INSERT INTO deutkw_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Jahwe aber that, wie Mose erbeten hatte, und erlöste den Pharao, sowie seine Höflinge und Unterthanen von den Hundsfliegen, so daß auch nicht eine übrig blieb. ");
INSERT INTO deutkw_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Der Sinn des Pharao wurde jedoch auch diesmal wieder verstockt, und er ließ das Volk nicht ziehen. ");
INSERT INTO deutkw_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Hierauf befahl Jahwe Mose: Begieb dich zum Pharao und kündige ihm an: So spricht Jahwe, der Gott der Hebräer: Laß mein Volk ziehen, damit es mich verehre! ");
INSERT INTO deutkw_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Denn wenn du dich weigerst, sie ziehen zu lassen, und sie noch ferner zurückhältst, ");
INSERT INTO deutkw_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","so wird Jahwes Hand über dein Vieh auf dem Felde, die Pferde, Esel, Kamele, Rinder und Schafe kommen in Gestalt einer sehr schweren Pest. ");
INSERT INTO deutkw_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Jahwe aber wird zwischen dem Vieh der Israeliten und dem der Ägypter einen Unterschied machen: von allem, das den Israeliten gehört, soll kein Stück fallen. ");
INSERT INTO deutkw_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Hierauf bestimmte Jahwe eine Frist, indem er sprach: Morgen wird Jahwe dies über das Land bringen. ");
INSERT INTO deutkw_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Am folgenden Tage ließ Jahwe dies eintreten. Da fiel alles Vieh der Ägypter; aber von dem Vieh der Israeliten fiel nicht ein einziges Stück. ");
INSERT INTO deutkw_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Der Pharao aber sandte Boten aus; da ergab sich, daß von dem Vieh der Israeliten auch nicht ein Stück gefallen war. Hierauf wurde der Sinn des Pharao wieder verstockt, und er ließ das Volk nicht ziehen. ");
INSERT INTO deutkw_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Hierauf befahl Jahwe Mose und Aaron: Nehmt euch beide Hände voll Ofenruß, und Mose soll ihn vor den Augen des Pharao emporstreuen; ");
INSERT INTO deutkw_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","so soll er dann als eine feine Staubwolke auf ganz Ägypten fallen und sowohl an den Menschen als an den Tieren in ganz Ägypten zu Geschwüren werden, die in Blattern ausbrechen. ");
INSERT INTO deutkw_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Da nahmen sie den Ofenruß und traten vor den Pharao; dort streute ihn Mose empor, und es entstanden aufbrechende Geschwüre mit Pusteln, an den Menschen sowohl, wie an den Tieren. ");
INSERT INTO deutkw_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Die Zauberer aber waren nicht imstande, Mose die Spitze zu bieten, infolge der Geschwüre; denn die Geschwüre brachen an den Zauberern aus, wie an allen Ägyptern. ");
INSERT INTO deutkw_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Jahwe aber machte den Sinn des Pharao verstockt, und er willfahrte ihnen nicht, wie Jahwe Mose vorausgesagt hatte. ");
INSERT INTO deutkw_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Hierauf befahl Jahwe Mose: Tritt morgen früh vor den Pharao und kündige ihm an: So spricht Jahwe, der Gott der Hebräer: Laß mein Volk ziehen, damit es mich verehre! ");
INSERT INTO deutkw_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Denn diesmal will ich alle meine Plagen dich selbst, deine Höflinge und Unterthanen fühlen lassen, damit du erkennest, daß es keinen giebt, wie ich, auf der ganzen Erde! ");
INSERT INTO deutkw_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Eben hätte ich meine Hand ausrecken und dich und deine Unterthanen mit der Pest zu Grunde richten können, so daß du weggefegt worden wärest vom Erdboden. ");
INSERT INTO deutkw_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Aber ich habe dich nur deswegen verschont, damit ich dir meine Macht zu fühlen gebe, und mein Name auf der ganzen Erde gepriesen werde. ");
INSERT INTO deutkw_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Noch stemmst du dich dagegen, mein Volk ziehen zu lassen. ");
INSERT INTO deutkw_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Ich werde aber morgen um diese Zeit einen sehr schweren Hagelschlag herniederfallen lassen, dessengleichen in Ägypten nicht dagewesen ist, seitdem es erschaffen wurde, bis jetzt. ");
INSERT INTO deutkw_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Schicke daher hin und laß dein Vieh und alles, was du draußen im Freien hast, in Sicherheit bringen; denn alle Menschen und Tiere, die sich im Freien befinden und nicht in ihre Behausungen zurückziehen werden, die wird der Hagel tot schlagen. ");
INSERT INTO deutkw_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Wer sich nun von den Höflingen des Pharao vor der Drohung Jahwes fürchtete, der ließ seine Sklaven und sein Vieh in die Wohnungen flüchten. ");
INSERT INTO deutkw_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Wer aber die Drohung Jahwes unbeachtet ließ, der ließ seine Sklaven und sein Vieh im Freien. ");
INSERT INTO deutkw_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Da befahl Jahwe Mose: Recke deine Hand gen Himmel empor; so soll Hagel fallen auf ganz Ägypten, sowohl auf die Menschen, als auf die Tiere und auf alle Feldgewächse in Ägypten. ");
INSERT INTO deutkw_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Da reckte Mose seinen Stab gen Himmel empor, und Jahwe ließ Donner und Hagel entstehen und Feuer fuhr hernieder; und Jahwe ließ Hagel fallen auf Ägypten. ");
INSERT INTO deutkw_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Und es fiel ein sehr starker Hagel und unaufhörliches Feuer unter dem Hagel, wie seinesgleichen nie gefallen war in Ägypten, seitdem es von Menschen bewohnt war. ");
INSERT INTO deutkw_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Und der Hagel erschlug in ganz Ägypten alles, was im Freien war, sowohl Menschen als Tier, und alle Feldgewächse zerschlug der Hagel und alle Bäume auf dem Felde knickte er. ");
INSERT INTO deutkw_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Bloß in der Provinz Gosen, woselbst die Israeliten wohnten, fiel kein Hagel. ");
INSERT INTO deutkw_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Da sandte der Pharao Boten, ließ Mose und Aaron rufen und sprach zu ihnen: Ich habe diesmal gefehlt; Jahwe ist im Recht und ich und meine Unterthanen sind im Unrecht. ");
INSERT INTO deutkw_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Legt bei Jahwe Fürbitte ein - es ist mehr als genug an den Donnerschlägen und dem Hagel -, so will ich euch ziehen lassen und ihr sollt nicht länger hier verweilen. ");
INSERT INTO deutkw_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Mose antwortete ihm: Wenn ich zur Stadt hinausgehe, will ich meine Hände zu Jahwe ausbreiten; so sollen die Donnerschläge aufhören und der Hagel nicht mehr fallen, damit du erkennst, daß Jahwe die Erde gehört. ");
INSERT INTO deutkw_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Aber du und deine Höflinge, ich weiß es, fürchtet euch noch nicht vor dem Gott Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Der Flachs aber und die Gerste wurden vernichtet; denn die Gerste stand in Ähren und der Flachs hatte Knospen. ");
INSERT INTO deutkw_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Der Weizen jedoch und der Spelt wurden nicht vernichtet; denn sie kommen später. ");
INSERT INTO deutkw_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Hierauf verließ Mose den Pharao und ging zur Stadt hinaus; da breitete er seine Hände zu Jahwe aus, und alsbald hörten die Donnerschläge und der Hagel auf, und es strömte kein Regen mehr hernieder. ");
INSERT INTO deutkw_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Als jedoch der Pharao merkte, daß der Regen, der Hagel und die Donnerschläge aufgehört hatten, verging er sich weiter und wurde verstockt, er und seine Höflinge. ");
INSERT INTO deutkw_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Aber der Sinn des Pharao blieb verhärtet, und er ließ die Israeliten nicht ziehen, wie Jahwe durch Mose vorausgesagt hatte. ");
INSERT INTO deutkw_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Hierauf befahl Jahwe Mose: Begieb dich zum Pharao, denn ich habe seinen und seiner Höflinge Sinn verstockt, um diese meine Wunderthaten an ihm zu verrichten, ");
INSERT INTO deutkw_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","und damit du deinem Sohne und Enkel erzählst, was ich den Ägyptern angethan habe, und meine Wunderthaten, die ich an ihnen verrichtet habe, damit ihr erkennet, daß ich Jahwe bin. ");
INSERT INTO deutkw_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Da begaben sich Mose und Aaron zum Pharao und sprachen zu ihm: So spricht Jahwe, der Gott der Hebräer: Wie lange willst du dich noch weigern, dich vor mir zu demütigen? Laß mein Volk ziehen, damit es mich verehre! ");
INSERT INTO deutkw_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Denn wenn du dich weigerst, mein Volk ziehen zu lassen, so will ich morgen Heuschrecken in dein Land einfallen lassen, ");
INSERT INTO deutkw_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","und sie sollen das ganze Land bedecken, so daß man den Boden nicht mehr sehen kann; sie werden den Rest, der gerettet ward und von dem Hagel euch noch übrig gelassen ist, fressen und werden alle eure Bäume, die draußen sprießen, abfressen. ");
INSERT INTO deutkw_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Und sie werden scharenweise in deine Gemächer, die Gemächer aller deiner Höflinge und die Gemächer aller Ägypter dringen, wie es deine Ahnen und Urahnen, seit sie auf Erden sind, bisher nie erlebt haben. Hierauf kehrte er dem Pharao den Rücken und ging hinweg. ");
INSERT INTO deutkw_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Da sprachen die Höflinge des Pharao zu ihm: Wie lange noch soll uns dieser da zum Fallstrick dienen? Laß doch die Leute ziehen, damit sie ihren Gott Jahwe verehren. Siehst du denn noch nicht ein, daß Ägypten zu Grunde geht? ");
INSERT INTO deutkw_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Hierauf holte man Mose und Aaron zum Pharao zurück, und er sprach zu ihnen: Geht hin und verehrt eueren Gott Jahwe! Wer sind den eigentlich die, welche hingehen sollen? ");
INSERT INTO deutkw_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Mose erwiderte: Unsere Kinder und unsere Greise wollen wir mitnehmen, unsere Söhne und unsere Töchter, unsere Schafe und unsere Rinder wollen wir mitnehmen; denn wir haben Jahwe ein Fest zu feiern. ");
INSERT INTO deutkw_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Da erwiderte er ihnen: Nun wohl! Jahwe sei mit euch, wenn ich euch mit eueren kleinen Kindern zusammen ziehen lasse; wahrlich, ihr habt Böses im Sinne. ");
INSERT INTO deutkw_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Daraus wird nichts; die Männer dürfen hingehen und Jahwe verehren, denn dies wolltet ihr ja! Hierauf jagte man sie vom Pharao hinweg. ");
INSERT INTO deutkw_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Da befahl Jahwe Mose: Recke deine Hand aus über Ägypten und führe Heuschrecken herbei, und sie sollen über Ägypten heraufziehen und alle Bodengewächse, alles, was der Hagel übrig gelassen hat, abfressen. ");
INSERT INTO deutkw_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Da reckte Mose seinen Stab aus über Ägypten, und Jahwe ließ einen Ostwind gegen das Land hin wehen den ganzen Tag und die ganze folgende Nacht hindurch; als es Morgen wurde, hatte der Ostwind die Heuschrecken herbeigetragen. ");
INSERT INTO deutkw_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Da zogen die Heuschrecken herauf über ganz Ägypten und ließen sich nieder an allen Orten in Ägypten in ungeheuerer Menge; vorher war nie ein solcher Heuschreckenschwarm dagewesen, und es wird auch nie wieder einen solchen geben. ");
INSERT INTO deutkw_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Und sie bedeckten das ganze Land, so daß der Boden nicht mehr sichtbar war; und sie fraßen alle Gewächse auf dem Feld und alle Baumfrüchte, welche der Hagel übrig gelassen hatte, so daß gar nichts Grünes übrig blieb an den Bäumen und an den Feldgewächsen in ganz Ägypten. ");
INSERT INTO deutkw_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Da ließ der Pharao eiligst Mose und Aaron rufen und sprach: Ich habe gefehlt gegen Jahwe, eueren Gott, und gegen euch. ");
INSERT INTO deutkw_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Aber verzeih mir meinen Fehltritt nur dies eine Mal noch, und legt bei Jahwe, euerem Gotte, Fürbitte ein, daß er wenigstens diese schreckliche Plage von mir abwende! ");
INSERT INTO deutkw_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Da verließ er den Pharao und flehte zu Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Jahwe aber ließ einen sehr starken Westwind als Gegenwind wehen; der nahm den Heuschreckenschwarm mit und warf ihn ins Schilfmeer: keine einzige Heuschrecke blieb übrig im ganzen Bereiche von Ägypten. ");
INSERT INTO deutkw_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Aber Jahwe verstockte den Sinn des Pharao, und er ließ die Israeliten nicht ziehen. ");
INSERT INTO deutkw_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Hierauf gebot Jahwe Mose: Recke deine Hand gen Himmel empor, so soll Finsternis über Ägypten kommen, so daß man die Finsternis wird greifen können. ");
INSERT INTO deutkw_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Und Mose reckte seine Hand gen Himmel empor, da kam dichte Finsternis über ganz Ägypten - drei Tage lang. ");
INSERT INTO deutkw_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Keiner konnte den anderen sehen, niemand von seinem Platze weggehen, drei Tage hindurch; die Israeliten aber hatten alle Licht in ihren Wohnungen. ");
INSERT INTO deutkw_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Da ließ der Pharao Mose rufen und sprach: Geht hin, Jahwe einen Gottesdienst zu halten! Euere Schafe und Rinder jedoch müssen zurückbleiben; euere kleinen Kinder dürfen mitgehen. ");
INSERT INTO deutkw_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Mose erwiderte: Du selbst mußt uns Schlacht- und Brandopfertiere mitgeben, damit wir sie für Jahwe, unseren Gott, zurichten; ");
INSERT INTO deutkw_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","aber auch unser Vieh muß mitgehen - keine Klaue darf zurückbleiben, weil wir davon welche nehmen müssen, um Jahwe, unserem Gott, unsere Verehrung zu bezeigen; wir wissen ja nicht, wie wir Jahwe verehren sollen, bis wir dorthin kommen. ");
INSERT INTO deutkw_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Aber Jahwe verstockte den Sinn des Pharao, und er weigerte sich, sie ziehen zu lassen. ");
INSERT INTO deutkw_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Und der Pharao sprach zu ihm: Fort mit dir! Hüte dich, mir nochmals unter die Augen zu kommen; denn wenn du mir unter die Augen kommst, mußt du sterben. ");
INSERT INTO deutkw_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Mose erwiderte: Also du hast es gesagt; ich werde dir nicht mehr unter die Augen kommen! ");
INSERT INTO deutkw_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Hierauf sprach Jahwe zu Mose: Noch eine einzige Plage will ich über den Pharao und die Ägypter ergehen lassen; dann wird er euch von hier wegziehen lassen. Wenn er euch gänzlich entläßt, wird er euch sogar gewaltsam von hier wegtreiben. ");
INSERT INTO deutkw_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Schärfe den Leuten ein, ein jeder solle sich von seinem Nachbar und eine jede von ihrer Nachbarin silberne und goldene Gegenstände ausbitten. ");
INSERT INTO deutkw_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Jahwe aber verschaffte dem Volke bei den Ägyptern Ansehen; auch der Mann Mose galt sehr viel in Ägypten bei den Höflingen und Unterthanen des Pharao. ");
INSERT INTO deutkw_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Da sprach Mose: So spricht Jahwe: Um Mitternacht werde ich durch ganz Ägypten wandeln, ");
INSERT INTO deutkw_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","da soll dann sterben jeder erstgeborene Sohn in Ägypten, vom Erstgeborenen des Pharao an, der auf seinem Throne sitzt, bis zum Erstgeborenen der Sklavin, welche an der Handmühle sitzt, sowie aller erste Wurf des Viehs. ");
INSERT INTO deutkw_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Und es soll ein großes Jammergeschrei entstehen in ganz Ägypten, desgleichen noch nicht dagewesen ist und desgleichen es niemals mehr geben wird. ");
INSERT INTO deutkw_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Aber gegen keinen Israeliten soll auch nur ein Hund mucksen, weder gegen Mensch noch Vieh, damit ihr erkennt, daß Jahwe zwischen den Ägyptern und Israeliten einen Unterschied macht. ");
INSERT INTO deutkw_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Dann sollen alle diese deine Höflinge zu mir kommen, sich vor mir niederwerfen und mich bitten: Zieh doch weg samt allen deinen Leuten, die dir anhängen! und hernach werde ich wegziehen. Hierauf verließ er den Pharao in großem Zorn. ");
INSERT INTO deutkw_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Jahwe aber sprach zu Mose: Der Pharao wird euch nicht willfahren, damit meiner Wunderthaten an Ägypten viele werden. ");
INSERT INTO deutkw_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Und Mose und Aaron verrichteten alle diese Wunderthaten vor dem Pharao; Jahwe verstockte jedoch den Sinn des Pharao, so daß er die Israeliten nicht wegziehen ließ aus seinem Lande. ");
INSERT INTO deutkw_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Da sprach Jahwe zu Mose und Aaron in Ägypten folgendermaßen: ");
INSERT INTO deutkw_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Der laufende Monat soll für euch an der Spitze der Monate stehen; als erster unter den Monaten des Jahres soll er euch gelten. ");
INSERT INTO deutkw_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Sprecht zu der ganzen Gemeinde Israel folgendermaßen: Am zehnten dieses Monats soll sich ein jeder ein Lamm verschaffen, je ein Lamm für jede einzelne Familie. ");
INSERT INTO deutkw_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Wenn aber die Familie zu klein ist für ein Lamm, so soll er mit seinem Nachbar, der seinem Hause zunächst wohnt, je nach dem Betrage der Seelenzahl eines anschaffen; für so viele, als es aufzuzehren vermögen, sollt ihr ein Lamm rechnen. ");
INSERT INTO deutkw_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Ein fehlerfreies, männliches, einjähriges Lamm muß es sein; aus den Schafen oder Ziegen sollt ihr es wählen. ");
INSERT INTO deutkw_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Und ihr sollt es aufbewahren bis zum vierzehnten Tage dieses Monats, und die gesamte Gemeinde Israel soll es schlachten gegen Abend. ");
INSERT INTO deutkw_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Dann sollen sie etwas von dem Blute nehmen und es an die beiden Thürpfosten und die Oberschwelle derjenigen Häuser streichen, in denen sie es verzehren. ");
INSERT INTO deutkw_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Das Fleisch aber sollen sie in derselben Nacht essen und zwar gebraten; ungesäuerte Brote nebst bitteren Kräutern sollen sie dazu essen. ");
INSERT INTO deutkw_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Ihr sollt es nicht roh oder in Wasser gesotten verzehren, sondern am Feuer gebraten, und zwar so, daß der Kopf noch mit den Beinen und den inneren Teilen zusammenhängt. ");
INSERT INTO deutkw_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Auch sollt ihr nichts davon bis zum Morgen übrig lassen; was davon bis zum Morgen übrig bleibt, sollt ihr verbrennen. ");
INSERT INTO deutkw_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Und so sollt ihr es verzehren: mit Gürteln um den Leib, mit eueren Sandalen an den Füßen und mit dem Stabe in der Hand, und sollt es in eiliger Hast verzehren; ein Passah für Jahwe ist es. ");
INSERT INTO deutkw_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Denn ich will in derselben Nacht Ägypten durchziehen und jede Erstgeburt in Ägypten, sowohl unter den Menschen als unter dem Vieh, töten; auch alle Götter Ägyptens werde ich meine Macht fühlen lassen - ich, Jahwe! ");
INSERT INTO deutkw_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Und das Blut an den Häusern, in denen ihr seid, soll als Merkmal zu eueren Gunsten dienen; denn wenn ich das Blut erblicke, will ich schonend an euch vorübergehen und es soll euch kein Leid und Verderben treffen, wenn ich den Schlag gegen Ägypten führe. ");
INSERT INTO deutkw_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Und dieser Tag soll für euch ein Gedächtnistag sein, und ihr sollt an ihm Jahwe ein Fest feiern von Geschlecht zu Geschlecht; als eine Einrichtung auf ewige Zeiten sollt ihr ihn feiern. ");
INSERT INTO deutkw_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Sieben Tage hindurch sollt ihr ungesäuertes Brot essen; bereits am ersten Tage sollt ihr den Sauerteig von eueren Wohnungen fern halten; denn wer irgend gesäuertes Brot genießt vom ersten Tag an bis zum siebenten, der soll weggetilgt werden aus Israel. ");
INSERT INTO deutkw_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Am ersten Tag aber sollt ihr eine Festversammlung beim Heiligtum und am siebenten Tag eine Festversammlung beim Heiligtum halten. An ihnen soll ganz und gar keine Arbeit verrichtet werden; nur was ein jeder zur Nahrung braucht, darf von euch zubereitet werden. ");
INSERT INTO deutkw_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Und die Anordnung in Bezug auf die ungesäuerten Brote sollt ihr beobachten; denn an eben diesem Tag habe ich eure Heerscharen aus Ägypten weggeführt. Daher sollt ihr diesen Tag beobachten von Geschlecht zu Geschlecht als eine Einrichtung auf ewige Zeiten. ");
INSERT INTO deutkw_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Im ersten Monat, am vierzehnten Tage des Monats, am Abend, sollt ihr ungesäuertes Brot essen, bis zum Abend des einundzwanzigsten Tages des Monats. ");
INSERT INTO deutkw_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Sieben Tage hindurch darf kein Sauerteig in eueren Wohnungen zu finden sein; denn wer irgend gesäuertes Brot ißt, der soll weggetilgt werden aus der Gemeinde Israel, sowohl Fremde als Landeseingeborene. ");
INSERT INTO deutkw_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Keinen Bissen gesäuertes Brotes sollt ihr essen; überall, wo ihr auch wohnt, sollt ihr ungesäuertes Brot essen! ");
INSERT INTO deutkw_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Da berief Mose alle Vornehmsten der Israeliten und gebot ihnen: Auf! verschafft euch ein Schaf für eure Familien und schlachtet das Passah! ");
INSERT INTO deutkw_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Und nehmt ein Büschel Ysop, taucht es in das Blut, das im Becken ist, und streicht etwas von dem Blut im Becken an die Oberschwelle und die beiden Thürpfosten; aber keiner von euch soll zur Thüre seiner Wohnung hinausgehen bis morgens früh. ");
INSERT INTO deutkw_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Denn Jahwe wird durchziehen, um gegen die Ägypter einen Schlag zu führen; wenn er dann das Blut an der Oberschwelle und an den beiden Thürpfosten erblickt, wird Jahwe schonend an jener Thüre vorübergehen und dem Verderben nicht gestatten, euere Wohnungen zu betreten, um jemand heimzusuchen. ");
INSERT INTO deutkw_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Und ihr sollt dies beobachten als eine Satzung für dich und deine Kinder auf ewige Zeiten. ");
INSERT INTO deutkw_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Wenn ihr nun in das Land kommt, das euch Jahwe zu eigen geben wird, wie er verheißen hat, so sollt ihr diesen gottesdienstlichen Brauch beobachten. ");
INSERT INTO deutkw_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Und wenn euere Kinder euch dann fragen: Was habt ihr da für einen Brauch? ");
INSERT INTO deutkw_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","so sollt ihr antworten: Es ist ein Passahopfer für Jahwe, der schonend vorüberging an den Wohnungen der Israeliten in Ägypten, als er die Ägypter heimsuchte, unsere Familien aber unangetastet ließ. Da neigten sich die Leute und warfen sich zu Boden. ");
INSERT INTO deutkw_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Und die Israeliten gingen hin und thaten, wie Jahwe Mose und Aaron geboten hatte; so thaten sie. ");
INSERT INTO deutkw_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Um Mitternacht aber tötete Jahwe alle Erstgeburten in Ägypten, vom Erstgeborenen des Pharao an, der auf seinem Throne saß, bis zum Erstgeborenen des Gefangenen, der im Kerker lag, sowie alle Erstgeburten des Viehs. ");
INSERT INTO deutkw_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Da stand der Pharao samt seinen Höflingen und allen Ägyptern in jener Nacht auf, und es erhob sich ein großes Klagegeschrei in Ägypten: denn es gab kein Haus, in welchem nicht ein Toter war. ");
INSERT INTO deutkw_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Da ließ er Mose und Aaron zur Nachtzeit rufen und sprach: Auf! zieht ab, von meinem Volke weg, sowohl ihr selbst, als die Israeliten; geht hin und verehrt Jahwe, wie ihr verlangt habt! ");
INSERT INTO deutkw_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Auch euere Schafe und Rinder nehmt mit, wie ihr es verlangt habt; zieht ab und bittet auch für mich um Segen. ");
INSERT INTO deutkw_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Die Ägypter aber drängten das Volk zu schleunigem Abzug aus dem Lande; denn sie sagten sich: wir sind sonst alle des Todes! ");
INSERT INTO deutkw_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Da nahmen die Leute ihren Brotteig mit, bevor er durchsäuert war und trugen die Backschüsseln eingewickelt in ihre Obergewänder auf den Schultern. ");
INSERT INTO deutkw_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Die Israeliten aber hatten gethan, wie ihnen Mose geboten hatte, und sich von den Ägyptern silberne und goldene Geräte, sowie Kleider erbeten. ");
INSERT INTO deutkw_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Und Jahwe hatte den Leuten bei den Ägyptern Ansehen verschafft, so daß sie ihnen willfahrten; so plünderten sie die Ägypter. ");
INSERT INTO deutkw_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Da zogen die Israeliten von Ramses nach Suchoth, gegen sechshunderttausend Mann zu Fuß, die Männer abgesehen von den Kindern. ");
INSERT INTO deutkw_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Aber auch eine große Rotte zog mit ihnen, sowie Schafe und Rinder, ein gewaltiger Haufe Vieh. ");
INSERT INTO deutkw_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Da buken sie den Teig, den sie aus Ägypten mitgenommen hatten, zu Fladen ungesäuerten Brotes; denn er war nicht gesäuert, weil sie mit Gewalt aus Ägypten fortgetrieben worden waren und sich nicht mehr aufhalten noch sich Reisezehrung hatten bereiten können. ");
INSERT INTO deutkw_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Die Zeit aber, welche die Israeliten in Ägypten zugebracht hatten, betrug vierhundertunddreißig Jahre. ");
INSERT INTO deutkw_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Und nach Ablauf von vierhundertunddreißig Jahren, an eben diesem Tage, zogen alle Heerscharen Jahwes aus Ägypten weg. ");
INSERT INTO deutkw_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Eine Bewahrungsnacht Jahwes ist es, weil er sie wegführte aus Ägypten. Das ist diese Nacht Jahwes zur Beobachtung für alle Israeliten von Geschlecht zu Geschlecht. ");
INSERT INTO deutkw_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Da sprach Jahwe zu Mose und Aaron: Dies ist die Satzung in Bezug auf das Passah: kein Fremder darf es mitessen. ");
INSERT INTO deutkw_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Jeder um Geld erkaufte Sklave aber darf dann mitessen, wenn man ihn beschnitten hat. ");
INSERT INTO deutkw_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Ein Beisaß oder Lohnarbeiter darf es nicht mitessen. ");
INSERT INTO deutkw_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","In einem Hause soll es verzehrt werden; man darf nichts von dem Fleisch aus dem Hause hinaustragen. Keinen Knochen sollt ihr an ihm brechen. ");
INSERT INTO deutkw_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Die ganze Gemeinde Israel soll es halten. ");
INSERT INTO deutkw_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Und wenn sich Ausländer bei euch aufhalten und Jahwe Passah feiern wollen, so soll alles, was männlich unter ihnen ist, beschnitten werden; alsdann mögen sie herzutreten, es zu feiern, und sie sollen dann wie Landeseingeborene gelten. Ein Unbeschnittener aber darf es unter keinen Umständen mitessen. ");
INSERT INTO deutkw_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Ein und dasselbe Gesetz soll gelten für den Landeseingeborenen, wie für den Fremden, der sich in eurer Mitte aufhält. ");
INSERT INTO deutkw_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Da thaten alle Israeliten, wie Jahwe Mose und Aaron geboten hatte; so thaten sie. ");
INSERT INTO deutkw_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","An eben diesem Tage führte Jahwe die Israeliten nach ihren Scharen aus Ägypten hinweg. ");
INSERT INTO deutkw_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Da redete Jahwe mit Mose folgendermaßen: ");
INSERT INTO deutkw_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","Sondere mir alles Erstgeborene als heilig aus, alles was bei den Israeliten zuerst den Mutterschoß durchbricht, es sei Mensch oder Tier; mir soll es gehören. ");
INSERT INTO deutkw_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Und Mose sprach zum Volke: Gedenkt an diesen Tag, an dem ihr aus Ägypten, aus dem Lande, da ihr Sklaven wart, ausgezogen seid. Denn mit gewaltiger Hand hat euch Jahwe von dort weggeführt; daher darf kein gesäuertes Brot gegessen werden. ");
INSERT INTO deutkw_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Heute zieht ihr aus, im Monat Abib. ");
INSERT INTO deutkw_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Wenn dich nun Jahwe in das Land der Kanaaniter, Hethiter, Amoriter, Heviter und Jebusiter bringen wird, welches dir zu verleihen er deinen Ahnen zugeschworen hat, ein Land, welches von Milch und Honig überfließe, so sollst du diesen gottesdienstlichen Brauch in eben diesem Monat beobachten. ");
INSERT INTO deutkw_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Sieben Tage hindurch sollt ihr ungesäuerte Brote essen; am siebenten Tag aber soll Jahwe ein Fest gefeiert werden. ");
INSERT INTO deutkw_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Ungesäuerte Brote sollen die sieben Tage hindurch gegessen werden, und es darf sich kein gesäuertes Brot und kein Sauerteig bei dir vorfinden in deinem ganzen Bereich. ");
INSERT INTO deutkw_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Und an jenem Tage sollst du deinem Sohne Folgendes erzählen: Dies hat Jahwe an mir gethan, als ich aus Ägypten wegzog. ");
INSERT INTO deutkw_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Und es soll dir sein, wie ein Wahrzeichen an deiner Hand und wie ein Gedenkzeichen an deiner Stirn, damit die Unterweisung Jahwes stets in deinem Munde sei; denn mit gewaltiger Hand hat dich Jahwe aus Ägypten weggeführt. ");
INSERT INTO deutkw_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Daher sollst du diese Satzung beobachten Jahr für Jahr zur festgesetzten Zeit. ");
INSERT INTO deutkw_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Wenn dich aber Jahwe, wie er es dir und deinen Ahnen zugeschworen hat, in das Land der Kanaaniter bringen und dir dasselbe verleihen wird, ");
INSERT INTO deutkw_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","so sollst du alles, was zuerst den Mutterschoß durchbricht, Jahwe weihen; jeder erste Wurf des Viehs, der dir zu teil wird: soweit es Männchen sind, sollen sie Jahwe gehören. ");
INSERT INTO deutkw_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Jeden ersten Wurf eines Esels aber sollst du mit einem Lamm auslösen; willst du ihn aber nicht auslösen, so sollst du ihm das Genick brechen. Aber jede erste Menschengeburt unter deinen Söhnen sollst du auslösen. ");
INSERT INTO deutkw_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Und wenn dich dein Sohn einst fragen wird: Was bedeutet dies? so sollst du ihm antworten: Mit gewaltiger Hand hat uns Jahwe aus Ägypten, dem Lande, wo wir Sklaven waren, hinweggeführt. ");
INSERT INTO deutkw_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Denn als der Pharao verstockt war und uns nicht wollte ziehen lassen, hat Jahwe alle Erstgeburt in Ägypten getötet, sowohl die Erstgeborenen unter den Menschen, als den ersten Wurf des Viehs; deswegen bringe ich Jahwe jeden ersten männlichen Wurf als Opfer, und jeden Erstgeborenen unter meinen Söhnen löse ich aus. ");
INSERT INTO deutkw_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Und es soll dir wie ein Wahrzeichen an deiner Hand und wie ein Gedenkzeichen an deiner Stirn sein, daß uns Jahwe mit gewaltiger Hand aus Ägypten weggeführt hat. ");
INSERT INTO deutkw_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Als aber der Pharao das Volk hatte ziehen lassen, führte sie Gott nicht auf dem Wege nach dem Lande der Philister, obwohl dies der nächste gewesen wäre; denn Gott dachte: es könnte das Volk reuen, wenn es Kämpfe zu bestehen hätte, und sie könnten nach Ägypten zurückkehren wollen; ");
INSERT INTO deutkw_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","sondern Gott ließ das Volk auf dem Wege nach der Wüste hin gegen das Schilfmeer umbiegen, und kampfgerüstet zogen die Israeliten aus Ägypten fort. ");
INSERT INTO deutkw_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Mose aber nahm die Gebeine Josephs mit; denn dieser hatte die Söhne Israels mit schwerem Eide verpflichtet: Wenn Gott sich dereinst eurer annehmen wird, müßt ihr meine Gebeine von hier mit euch nehmen. ");
INSERT INTO deutkw_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Da brachen sie von Suchoth auf und lagerten sich in Etham, am Rande der Wüste. ");
INSERT INTO deutkw_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Jahwe aber zog vor ihnen her, Tags über in einer Wolkensäule, um ihnen den Weg zu zeigen, und des Nachts in einer Feuersäule, um ihnen Licht zu spenden, so daß sie bei Tag und bei Nacht weiter ziehen konnten. ");
INSERT INTO deutkw_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Tags über wich die Wolkensäule nicht und des Nachts stand die Feuersäule vor dem Volke. ");
INSERT INTO deutkw_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Da sprach Jahwe zu Mose folgendermaßen: ");
INSERT INTO deutkw_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Befiehl den Israeliten, abzuschwenken und sich bei Pihachiroth zwischen Migdol und dem Meere zu lagern bei Baal Zephon; in dessen Nähe sollt ihr euch lagern am Meere. ");
INSERT INTO deutkw_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Der Pharao aber wird von den Israeliten denken: Sie sind verirrt im Lande; sie sind eingeschlossen in der Wüste. ");
INSERT INTO deutkw_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Dann werde ich den Sinn des Pharao verstocken, und er wird sie verfolgen; ich aber werde am Pharao und seinem ganzen Heere meine Macht erweisen, und die Ägypter sollen erkennen, daß ich Jahwe bin. Da thaten sie so. ");
INSERT INTO deutkw_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Hierauf wurde dem Könige von Ägypten berichtet, daß das Volk entwichen sei. Da wurden der Pharao und seine Höflinge gegen das Volk umgestimmt; denn sie sagten sich: Was haben wir gethan, daß wir die Israeliten ziehen ließen, so daß sie uns keine Dienste mehr thun! ");
INSERT INTO deutkw_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Da ließ er seine Wagen anspannen und nahm sein Kriegsvolk mit sich. ");
INSERT INTO deutkw_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Und er nahm sechshundert Streitwagen mit auserlesener Mannschaft mit und alle Streitwagen der Ägypter und Wagenkämpfer auf jedem derselben. ");
INSERT INTO deutkw_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Jahwe aber verstockte den Sinn des Pharao, des Königs von Ägypten; da setzte er den Israeliten nach, während die Israeliten schlagbereit ihres Weges zogen. ");
INSERT INTO deutkw_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Da setzten die Ägypter ihnen nach und erreichten sie, wie sie am Meere lagerten, alle Pferde, Kriegswagen, Reiter und Truppen des Pharao, bei Pihachiroth in der Nähe von Baal Zephon. ");
INSERT INTO deutkw_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Als nun der Pharao nahe herangekommen war, schauten die Israeliten auf und wurden gewahr, daß die Ägypter hinter ihnen dreinzogen. Da fürchteten sie sich sehr. Und die Israeliten riefen Jahwe um Hilfe an. ");
INSERT INTO deutkw_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Zu Mose aber sprachen sie: Gab es etwa keine Friedhöfe in Ägypten, daß du uns herausgelockt hast, damit wir in der Wüste sterben? Was hast du uns angethan, daß du uns aus Ägypten wegführtest! ");
INSERT INTO deutkw_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Haben wir dir nicht gerade dies schon in Ägypten vorgehalten: Laß uns in Ruhe, wir wollen den Ägyptern Sklavendienste verrichten. Denn es wäre besser für uns, den Ägyptern Sklavendienste zu verrichten, als in der Wüste umzukommen! ");
INSERT INTO deutkw_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Mose jedoch sprach zu dem Volke: Habt keine Angst! Haltet Stand, so werdet ihr sehen, welche Hilfe euch Jahwe heute wird zu teil werden lassen; denn was ihr heute mit den Ägyptern werdet geschehen sehen, werdet ihr nie und nimmermehr an ihnen sehen. ");
INSERT INTO deutkw_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Jahwe wird für euch streiten; ihr aber sollt euch still verhalten! ");
INSERT INTO deutkw_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Da sprach Jahwe zu Mose: Warum rufst du mich zu Hilfe? Befiehl den Israeliten, weiter zu ziehen. ");
INSERT INTO deutkw_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Du aber hebe deinen Stab empor und recke deine Hand aus über das Meer; so soll es sich zerteilen, und die Israeliten sollen mitten durch das Meer ziehen, als ob sie auf trockenem Lande wären. ");
INSERT INTO deutkw_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Dann will ich die Ägypter verblenden, so daß sie ihnen folgen, und will meine Macht erweisen am Pharao und an seinem ganzen Heer, an seinen Streitwagen und an seinen Reitern, ");
INSERT INTO deutkw_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","damit die Ägypter erkennen, daß ich Jahwe bin, wenn ich meine Macht erweise am Pharao und an seinem ganzen Heer, an seinen Streitwagen und Reitern. ");
INSERT INTO deutkw_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Da änderte der Engel Gottes, der dem Lager der Israeliten vorauszog, seine Stellung und trat hinter sie. Und die Wolkensäule änderte ihre Stellung vorn und trat hinter sie. ");
INSERT INTO deutkw_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Und er kam zwischen das Lager der Ägypter und das der Israeliten, und die Wolke erhellte die Nacht. Da konnten sie sich die ganze Nacht hindurch nicht zu nahe kommen. ");
INSERT INTO deutkw_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Da reckte Mose seine Hand aus über das Meer. Da versetzte Jahwe das Meer die ganze Nacht hindurch durch einen heftigen Ostwind in Bewegung und legte das Meer trocken; die Gewässer traten auseinander. ");
INSERT INTO deutkw_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Die Israeliten aber zogen mitten durch das Meer hindurch, wie auf trockenem Lande, während das Gewässer zu ihrer Rechten und Linken einen Damm bildete. ");
INSERT INTO deutkw_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Die Ägypter aber verfolgten sie und kamen hinter ihnen drein, alle Rosse, Streitwagen und Reiter des Pharao, zwischen die Wassermassen. ");
INSERT INTO deutkw_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","In der letzten Nachtwache aber beugte sich Jahwe in der Feuer- und Wolkensäule gegen den Heereszug der Ägypter hinab und brachte Verwirrung im Heereszuge der Ägypter hervor. ");
INSERT INTO deutkw_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Und er machte, daß die Räder ihrer Wagen absprangen, und daß sie nur mühsam vorwärts kamen. Da sagten die Ägypter: Laßt uns vor den Israeliten fliehen! Denn Jahwe kämpfte für sie gegen die Ägypter. ");
INSERT INTO deutkw_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Da sprach Jahwe zu Mose: Recke deine Hand gegen das Meer aus; so sollen die Gewässer auf die Ägypter, ihre Streitwagen und ihre Reiter zurückfluten. ");
INSERT INTO deutkw_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Und Mose reckte seine Hand gegen das Meer aus; da flutete gegen Morgen das Meer wieder in sein Bette zurück, während die Ägypter ihm gerade entgegen flohen, und Jahwe trieb die Ägypter mitten ins Meer hinein. ");
INSERT INTO deutkw_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Und die Gewässer flossen wieder zusammen und überfluteten die Streitwagen und die Reiter - das ganze Heer des Pharao -, die ihnen ins Meer gefolgt waren; kein einziger von ihnen blieb am Leben. ");
INSERT INTO deutkw_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Die Israeliten aber zogen durch das Meer hindurch wie auf trockenem Lande, während die Gewässer zu ihrer Rechten und Linken einen Damm bildeten. ");
INSERT INTO deutkw_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","So errettete Jahwe an jenem Tage Israel vor den Ägyptern, und die Israeliten sahen die Ägypter tot am Meeresufer liegen. ");
INSERT INTO deutkw_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Da erkannte Israel die große Wunderthat, die Jahwe an den Ägyptern verrichtet hatte. Da fürchtete das Volk Jahwe und glaubte an Jahwe und seinen Diener Mose. ");
INSERT INTO deutkw_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Damals sang Mose mit den Israeliten Jahwe das nachfolgende Lied, und sie sangen also: Ich will Jahwe ein Lied singen, denn hoch erhaben ist er; Rosse und Reiter hat er ins Meer gestürzt. ");
INSERT INTO deutkw_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Meine Stärke und mein Lobgesang ist Jahwe, und von ihm kam mein Heil. Er ist mein Gott; darum will ich ihn preisen - der Gott meines Vaters, darum will ich ihn hoch rühmen. ");
INSERT INTO deutkw_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Jahwe ist ein Kriegsheld; Jahwe ist sein Name. ");
INSERT INTO deutkw_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Die Streitwagen und die Heeresmacht des Pharao hat er ins Meer gestürzt, und die auserlesensten seiner Wagenkämpfer wurden ins Schilfmeer versenkt; ");
INSERT INTO deutkw_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Meeresfluten bedeckten sie; in die Strudel stürzten sie, wie ein Stein. ");
INSERT INTO deutkw_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Deine rechte Hand, o Jahwe! ist herrlich ob ihrer Kraft, Deine recht Hand, o Jahwe! zerschmettert die Feinde, ");
INSERT INTO deutkw_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","und mit deiner gewaltigen Majestät schlägst du deine Gegner zu Boden. Wenn du deinen Grimm loslässest, verzehrt er sie wie Strohhalme. ");
INSERT INTO deutkw_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Durch dein zorniges Schnauben standen die Gewässer, wie ein Damm. Es stand aufrecht wie ein Wall, was strömte, wie geronnen war der Wasserschwall im Meere. ");
INSERT INTO deutkw_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Der Feind dachte: Ich will ihnen nachjagen, sie einholen, will Beute verteilen, mich an ihnen letzen. Das Schwert will ich ziehn; ausrotten soll sie meine Hand! ");
INSERT INTO deutkw_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Du bliesest drein mit deinem Odem, da bedeckte sie das Meer. Sie sanken unter, wie Blei, in gewaltigen Wassermassen. ");
INSERT INTO deutkw_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Wer gleicht dir unter den Göttern, o Jahwe! Wer gleicht dir, du herrlich erhabener, du furchtbarer in Ruhmesthaten, der du Wunder verrichtest! ");
INSERT INTO deutkw_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Da du deine Hand ausrecktest, verschlang sie die Erde. ");
INSERT INTO deutkw_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Du geleitetest mit deiner Huld das Volk, das du befreit hattest; du führtest es mit deiner Macht zu deiner heiligen Wohnstätte. ");
INSERT INTO deutkw_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Als die Nationen davon hörten, erzitterten sie, Angst ergriff die Bewohner Philistäas. ");
INSERT INTO deutkw_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Damals erschraken die Stammesfürsten Edoms, die Anführer Moabs ergriff Beben; es verzagten alle Bewohner Kanaans. ");
INSERT INTO deutkw_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Es befiel sie Schrecken und Angst; über die Großthat deines Arms wurden sie starr wie Stein. So zog nun ein dein Volk, o Jahwe! So zog nun ein das Volk, das du dir zum Eigentum erwählt hast. ");
INSERT INTO deutkw_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Du brachtest sie hin und pflanztest sie an auf dem Berge, deinem Besitztum, der Stätte, die du dir bereitet hast, Jahwe! um daselbst zu wohnen, dem Heiligtum, o Herr, das deine Hände bereitet haben. ");
INSERT INTO deutkw_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Jahwe ist König auf immer und ewig! ");
INSERT INTO deutkw_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Denn als die Rosse des Pharao samt seinen Wagen und Reitern in das Meer gerieten, da ließ Jahwe die Wogen des Meeres über sie zusammenschlagen, während die Israeliten im Trockenen durch das Meer hindurch gezogen waren. ");
INSERT INTO deutkw_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Da nahm die Prophetin Mirjam, Aarons Schwester, die Pauke zur Hand, und alle Weiber zogen hinter ihr drein mit Pauken und im Reigen. ");
INSERT INTO deutkw_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Mirjam aber sang ihnen vor: Singt Jahwe ein Lied, denn hoch erhaben ist er; Rosse und Reiter hat er ins Meer gestürzt! ");
INSERT INTO deutkw_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Hierauf ließ Mose die Israeliten vom Schilfmeer aufbrechen; da zogen sie weiter nach der Wüste Sur und wanderten drei Tage in der Wüste, ohne Wasser zu finden. ");
INSERT INTO deutkw_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","So gelangten sie nach Mara; aber sie konnten das Wasser wegen seiner Bitterkeit nicht trinken. Denn es war bitter; daher hieß der Platz Mara. ");
INSERT INTO deutkw_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Da murrten die Leute gegen Mose und fragten: Was sollen wir trinken? ");
INSERT INTO deutkw_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Er aber rief Jahwe um Hilfe an. Da wies ihm Jahwe eine gewisse Art Holz; das warf er ins Wasser, da wurde es trinkbar. Dort gab er ihm Gesetz und Recht und dort ließ er ihm die Wahl, ");
INSERT INTO deutkw_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","indem er sprach: Wenn du den Worten Jahwes, deines Gottes, treulich gehorchst und thust, was vor seinen Augen recht ist, und seinen Befehlen Folge leistest und alle seine Satzungen beobachtest, so werde ich keines der Leiden, von denen ich die Ägypter befallen ließ, dich befallen lassen, sondern ich, Jahwe, werde dein Arzt sein. ");
INSERT INTO deutkw_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Hierauf gelangten sie nach Elim; dort fanden sich zwölf Quellen mit Wasser nebst siebzig Palmbäumen, und sie lagerten sich daselbst am Wasser. ");
INSERT INTO deutkw_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Sodann brachen sie von Elim auf, und es gelangte die ganze Gemeinde der Israeliten in die Wüste Sin, die zwischen Elim und dem Sinai liegt, am fünfzehnten Tage des zweiten Monats nach ihrem Auszug aus Ägypten. ");
INSERT INTO deutkw_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Da murrte die ganze Gemeinde der Israeliten gegen Mose und Aaron in der Wüste. ");
INSERT INTO deutkw_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Und die Israeliten sprachen zu ihnen: O wären wir doch lieber durch die Hand Jahwes in Ägypten gestorben, wo wir bei unseren Fleischtöpfen saßen und uns am Brot satt essen konnten; statt dessen habt ihr uns in diese Wüste geführt, um diese ganze Gemeinde dem Hungertode preiszugeben. ");
INSERT INTO deutkw_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Da sprach Jahwe zu Mose: Wohlan! ich will euch Brot vom Himmel fallen lassen wie Regen; so sollen dann die Leute hingehen und jeden Tag ihren täglichen Bedarf einsammeln. Damit will ich sie prüfen, ob sie nach meinen Lehren wandeln wollen oder nicht. ");
INSERT INTO deutkw_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Wenn sie dann aber am sechsten Tage zubereiten, was sie heimbringen, so wird es doppelt so viel sein, als was sie sonst alltäglich einsammeln. ");
INSERT INTO deutkw_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Da sprachen Mose und Aaron zu allen Israeliten: Am Abend werdet ihr einsehen, daß Jahwe euch aus Ägypten weggeführt hat. ");
INSERT INTO deutkw_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Morgen früh aber werdet ihr Jahwes Majestät zu sehen bekommen; denn er hat euer Murren wider Jahwe gehört. Was sind aber wir, daß ihr wider uns murrt? ");
INSERT INTO deutkw_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Da sprach Mose: Dadurch, daß euch Jahwe abends Fleisch zu essen geben wird und reichliches Brot am Morgen; dadurch, daß Jahwe euer Murren erhört, das ihr gegen ihn richtet - denn was sind wir? Euer Murren richtet sich nicht gegen uns, sondern gegen Jahwe! ");
INSERT INTO deutkw_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Hierauf sprach Mose zu Aaron: Befiehl der ganzen Gemeinde der Israeliten: Tretet heran vor Jahwe; denn er hat euer Murren vernommen. ");
INSERT INTO deutkw_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Als nun Aaron der ganzen Gemeinde der Israeliten dies befohlen hatte, schauten sie gegen die Wüste hin; da erschien plötzlich Jahwes Herrlichkeit in der Wolke. ");
INSERT INTO deutkw_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Und Jahwe sprach folgendermaßen zu Mose: ");
INSERT INTO deutkw_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Ich habe das Murren der Israeliten vernommen; sprich zu ihnen also: Heute abend werdet ihr Fleisch zu essen bekommen und morgen früh sollt ihr euch an Brot satt essen, und ihr sollt erkennen, daß ich Jahwe, euer Gott, bin! ");
INSERT INTO deutkw_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Als es nun Abend wurde, zog ein Wachtelschwarm heran und fiel überall im Lager nieder. Am folgenden Morgen aber legte sich ein starker Tau rings um das Lager. ");
INSERT INTO deutkw_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Und als der Tauniederschlag verschwand, da lag auf dem Boden der Wüste etwas Feines, Körniges, so fein, wie kleine Reiskörner, auf dem Boden. ");
INSERT INTO deutkw_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Als dies die Israeliten sahen, fragten sie einander: Was ist das? denn sie wußten nicht, was es war. Und Mose sprach zu ihnen: Das ist das Brot, das euch Jahwe als Nahrungsmittel schenkt. ");
INSERT INTO deutkw_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Folgendes hat Jahwe geboten: Sammelt davon ein, jeder nach seinem Bedürfnis und zwar einen Gomer auf den Kopf; je nach der Seelenzahl in eines jeglichen Zelt sollt ihr euch nehmen. ");
INSERT INTO deutkw_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Da thaten die Israeliten so und sammelten ein, der eine viel, der andere weniger. ");
INSERT INTO deutkw_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Als sie es aber mit dem Gomer maßen, hatte der, der viel genommen, nicht zu viel, und der, der weniger genommen, nicht zu wenig gesammelt, sondern jeder hatte nach seinem Bedürfnis gesammelt. ");
INSERT INTO deutkw_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Hierauf befahl ihnen Mose: Niemand soll etwas davon für den folgenden Tag aufheben. ");
INSERT INTO deutkw_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Aber sie gehorchten Mose nicht, und einige hoben etwas davon für den folgenden Tag auf. Da wurde es voll Würmer und verdarb; Mose aber wurde zornig auf sie. ");
INSERT INTO deutkw_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Und sie sammelten es jeden Morgen früh ein, jeder nach seinem Bedürfnis. Wenn aber die Sonne heiß schien, zerschmolz es. ");
INSERT INTO deutkw_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Am sechsten Tag aber hatten sie doppelt so viel Speise gesammelt, je zwei Gomer auf die Person. Da gingen alle Vorstände der Gemeinde hin, um es Mose zu berichten. ");
INSERT INTO deutkw_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Er jedoch sprach zu ihnen: Das geschieht, weil Jahwe gebietet: Morgen soll Ruhetag, ein Jahwe geweihter Sabbat sein. Was ihr backen wollt, das backt, und was ihr kochen wollt, das kocht; alles aber, was übrig bleibt, thut auf die Seite, um es für morgen aufzubewahren. ");
INSERT INTO deutkw_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Da hoben sie es nach Moses Gebot bis zum folgenden Tag auf; und es verdarb nicht und bekam auch keine Würmer. ");
INSERT INTO deutkw_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Hierauf befahl Mose: Nährt euch heute davon! denn heute ist Sabbat Jahwes; heute werde ihr draußen nichts finden. ");
INSERT INTO deutkw_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Sechs Tage hindurch sollt ihr davon einsammeln; aber am siebenten Tag, am Sabbat, wird es keines geben. ");
INSERT INTO deutkw_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Am siebenten Tage jedoch gingen etliche Leute hinaus, um einzusammeln; aber sie fanden nichts. ");
INSERT INTO deutkw_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Da sprach Jahwe zu Mose: Wie lange wollt ihr euch weigern, meine Befehle und Lehren zu beobachten? ");
INSERT INTO deutkw_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Seht doch! Jahwe giebt euch den Sabbat, daher spendet er euch am sechsten Tage Nahrung auf zwei Tage, bleibt ruhig zu Hause; niemand soll am siebenten Tage seine Behausung verlassen. ");
INSERT INTO deutkw_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","So feierte das Volk am siebenten Tage. ");
INSERT INTO deutkw_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Die Israeliten aber nannten es Man. Es war weiß wie Korianderkörner und hatte einen Geschmack wie Kuchen mit Honig. ");
INSERT INTO deutkw_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Hierauf sprach Mose: Folgendes befiehlt Jahwe: Ein ganzer Gomer davon soll aufbewahrt werden von Geschlecht zu Geschlecht, damit sie die Speise sehen, womit ich euch in der Wüste genährt habe, als ich euch aus Ägypten wegführte. ");
INSERT INTO deutkw_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Da sprach Mose zu Aaron: Nimm einen Krug, thue einen ganzen Gomer voll Manna hinein und stelle ihn hin vor Jahwe, daß er aufbewahrt werde von Geschlecht zu Geschlecht, ");
INSERT INTO deutkw_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","wie Jahwe Mose geboten hatte. Und Aaron stellte es nieder vor der Lade mit dem Gesetz zur Aufbewahrung. ");
INSERT INTO deutkw_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Die Israeliten aber aßen Manna vierzig Jahre hindurch, bis sie in bewohntes Land gelangten; Manna aßen sie, bis sie an die Grenze des Landes Kanaan gelangten. ");
INSERT INTO deutkw_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Ein Gomer aber ist der zehnte Teil eines Epha. ");
INSERT INTO deutkw_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Hierauf zog die ganze Gemeinde der Israeliten aus der Wüste Sin stationenweise weiter gemäß dem Befehle Jahwes; dann lagerten sie sich in Raphidim. Es gab aber kein Wasser für das Volk zum Trinken. ");
INSERT INTO deutkw_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Da haderte das Volk mit Mose und verlangte: Schaffe uns Wasser zum Trinken! Mose aber erwiderte ihnen: Warum hadert ihr mit mir? Was versucht ihr Jahwe? ");
INSERT INTO deutkw_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Und das Volk litt daselbst Durst, daher murrte das Volk wider Mose, indem sie sprachen: Wozu hast du uns denn aus Ägypten fortgeführt? Etwa um uns, unsere Kinder und unser Vieh vor Durst umkommen zu lassen? ");
INSERT INTO deutkw_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Da rief Mose Jahwe um Hilfe an, indem er sprach: Was soll ich mit diesen Leuten anfangen? Nur wenig fehlt, so werden sie mich steinigen! ");
INSERT INTO deutkw_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Jahwe aber erwiderte Mose: Gehe vor dem Volke voraus und nimm einige von den Vornehmen der Israeliten mit; auch deinen Stab, womit du in den Nil geschlagen hast, nimm zur Hand und geh! ");
INSERT INTO deutkw_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Dann will ich dort vor deinen Augen auf den Felsen am Horeb treten. Schlage dann auf den Felsen, so soll Wasser aus ihm hervorsprudeln, so daß die Leute zu trinken haben. Da that Mose so im Beisein der Vornehmen der Israeliten. ");
INSERT INTO deutkw_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Und er benannte die Stätte Massa und Meriba, weil die Israeliten gehadert und Jahwe versucht hatten, indem sie fragten: Ist Jahwe unter uns oder nicht? ");
INSERT INTO deutkw_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Hierauf rückten die Amalekiter heran, um die Israeliten in Raphidim zu bekämpfen. ");
INSERT INTO deutkw_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Da befahl Mose Josua: Wähle uns Männer aus und zieh morgen aus, um den Amalekitern eine Schlacht zu liefern; ich aber werde auf dem Gipfel des Hügels stehen mit dem Stabe Gottes in der Hand. ");
INSERT INTO deutkw_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Und Josua that, wie Mose ihm geboten hatte, und zog aus, den Amalekitern eine Schlacht zu liefern; Mose, Aaron und Hur aber stiegen auf den Gipfel des Hügels. ");
INSERT INTO deutkw_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Wenn nun Mose seine Arme erhob, so hatten die Israeliten die Oberhand; wenn er jedoch seine Arme sinken ließ, so hatten die Amalekiter die Oberhand. ");
INSERT INTO deutkw_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Als jedoch die Arme Moses ermüdeten, nahmen sie einen Stein und legten ihm den unter; da setzte er sich darauf. Aaron aber und Hur stützten seine Arme, der eine auf dieser, der andere auf jener Seite; da blieben seine Arme beständig ausgereckt bis zum Sonnenuntergang. ");
INSERT INTO deutkw_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Also brachte Josua den Amalekitern und ihrem Kriegsvolk eine blutige Niederlage bei. ");
INSERT INTO deutkw_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Hierauf befahl Jahwe Mose: Schreibe dies zum Andenken in ein Buch und schärfe es Josua ein: ich will die Amalekiter bis auf den Namen gänzlich von der Erde verschwinden lassen! ");
INSERT INTO deutkw_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Da errichtete Mose einen Altar und benannte ihn: Jahwe ist mein Banner! ");
INSERT INTO deutkw_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Denn er sprach: Hand an das Banner Jah's! ");
INSERT INTO deutkw_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Als aber Jethro, der Priester der Midianiter, der Schwiegervater Moses, die Kunde von alledem vernahm, was Gott an Mose und an seinem Volke Israel gethan hatte, daß Jahwe Israel aus Ägypten weggeführt hatte, ");
INSERT INTO deutkw_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","nahm Jethro, der Schwiegervater Moses, Zipora, das Weib Moses, - er hatte sie zurückgesandt - ");
INSERT INTO deutkw_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","und ihre beiden Söhne - der eine hieß Gersom, weil er gesagt hatte: ein Fremdling bin ich geworden in einem fremden Lande; ");
INSERT INTO deutkw_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","der andere hieß Elieser, denn: der Gott meines Vaters half mir und errettete mich vor dem Schwerte des Pharao. - ");
INSERT INTO deutkw_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Da kam Jethro, der Schwiegervater Moses, mit seinen Söhnen und seinem Weibe zu Mose in die Wüste, woselbst er lagerte am Berge Gottes. ");
INSERT INTO deutkw_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Und er ließ Mose sagen: Ich, dein Schwiegervater Jethro, komme zu dir, nebst deinem Weib und ihren beiden Söhnen, die sie bei sich hat. ");
INSERT INTO deutkw_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Da machte sich Mose auf den Weg, seinem Schwiegervater entgegenzugehen, verneigte sich und küßte ihn; dann fragten sie einander nach ihrem Wohlbefinden und begaben sich zum Zelte. ");
INSERT INTO deutkw_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Mose aber erzählte seinem Schwiegervater alles, was Jahwe dem Pharao und den Ägyptern zu Gunsten der Israeliten angethan hatte, von allen Mühsalen, die ihnen unterwegs zugestoßen waren, und wie Jahwe sie errettet hatte. ");
INSERT INTO deutkw_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Und Jethro freute sich über alle die Wohlthaten, die Jahwe den Israeliten erwiesen hatte, daß er sie aus der Gewalt der Ägypter befreit hatte. ");
INSERT INTO deutkw_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Und Jethro sprach: Gepriesen sei Jahwe, daß er euch aus der Gewalt des Pharao und der Ägypter befreit hat, daß er das Volk aus der Gewalt der Ägypter befreit hat. ");
INSERT INTO deutkw_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Nun erkenne ich, daß Jahwe mächtiger ist als alle Götter! ");
INSERT INTO deutkw_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Hierauf ließ Jethro, der Schwiegervater Moses, Schlachtvieh zu einem Brandopfer und zu einer Opfermahlzeit zu Ehren Gottes herbeischaffen, und es kamen Aaron und alle Vornehmen der Israeliten herbei, um mit dem Schwiegervater Moses ein Mahl vor Gott zu halten. ");
INSERT INTO deutkw_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Des anderen Tages aber setzte sich Mose hin, um dem Volke Recht zu sprechen; da traten Leute vor Mose hin vom Morgen bis zum Abend. ");
INSERT INTO deutkw_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Als nun der Schwiegervater Moses sah, wie er für die Leute zu thun hatte, sagte er: Was machst du dir mit den Leuten zu thun? Warum sitzest du allein zu Gericht, während alle Leute dich überlaufen vom Morgen bis zum Abend? ");
INSERT INTO deutkw_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mose erwiderte seinem Schwiegervater: Ja, die Leute kommen zu mir, um Gott zu befragen! ");
INSERT INTO deutkw_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Wenn sie eine Rechtssache haben, kommen sie zu mir, damit ich entscheide, wer von beiden Recht hat, und verkündige die Rechtssprüche und Entscheide Gottes. ");
INSERT INTO deutkw_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Da sprach der Schwiegervater Moses zu ihm: Daran thust du nicht gut. ");
INSERT INTO deutkw_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Du wirst dich, sowie die Leute, die bei dir sind, aufreiben; denn dieses Geschäft ist zu schwer für dich, du kannst es nicht allein besorgen. ");
INSERT INTO deutkw_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Ich will dir jetzt einen guten Rat geben; folge mir, so wird Gott dir beistehen: bleibe du selbst für das Volk Sachwalter bei Gott und bringe du selbst die Rechtssachen vor Gott. ");
INSERT INTO deutkw_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Und belehre sie über die Rechtssatzungen und Entscheide und weise ihnen den Weg, den sie wandeln sollen, und was sie thun sollen. ");
INSERT INTO deutkw_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Wähle dir aber aus dem ganzen Volke tüchtige, gottesfürchtige, vertrauenswürdige und uneigennützige Männer und bestelle sie zu Vorgesetzten über je tausend, je hundert, je fünfzig und je zehn, ");
INSERT INTO deutkw_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","damit sie den Leuten jederzeit Recht sprechen. Dann soll jede wichtige Sache vor dich gebracht werden, jede minder wichtige aber sollen sie selbst entscheiden; so wirst du dich entlasten und sie werden dich unterstützen. ");
INSERT INTO deutkw_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Wenn du dies so anordnest, und Gott es dir befiehlt, so wirst du es aushalten können, und alle diese Leute werden befriedigt zu ihrer Behausung zurückkehren. ");
INSERT INTO deutkw_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Da folgte Mose den Worten seines Schwiegervaters und führte alles aus, was er geraten hatte. ");
INSERT INTO deutkw_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Und Mose wählte aus der Gesamtheit der Israeliten tüchtige Männer aus und bestellte sie zu Häuptern über das Volk, zu Vorgesetzten über je tausend, je hundert, je fünfzig und je zehn. ");
INSERT INTO deutkw_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Und sie sprachen den Leuten jederzeit Recht; wichtige Sachen brachte man vor Mose, alle minder wichtigen Sachen aber entschieden sie selbst. ");
INSERT INTO deutkw_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Hierauf gab Mose seinem Schwiegervater das Geleite; der aber zog in seine Heimat. ");
INSERT INTO deutkw_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Im dritten Monat nach dem Auszug der Israeliten aus Ägypten, an eben dem Tage kamen sie in die Wüste Sinai. ");
INSERT INTO deutkw_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Und sie brachen auf von Raphidim und gelangten in die Wüste Sinai; da lagerten sie sich in der Wüste. Und die Israeliten lagerten sich daselbst dem Berge gegenüber. ");
INSERT INTO deutkw_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Als nun Mose zu Gott hinaufgestiegen war, rief ihm Jahwe vom Berge herab zu und sprach: So sollst du sprechen zum Hause Jakobs und ankündigen den Söhnen Israels: ");
INSERT INTO deutkw_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Ihr habt gesehen, was ich an den Ägyptern verrichtet, wie ich euch auf Adlersflügeln getragen und euch hierher zu mir gebracht habe. ");
INSERT INTO deutkw_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Wenn ihr nun auf mich hören und die von mir festgesetzten Ordnungen beobachten wollt, so sollt ihr unter allen Völkern mein besonderes Eigentum sein; denn mir gehört die ganze Erde. ");
INSERT INTO deutkw_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Und ihr sollt mir werden ein Königreich von Priestern und ein heiliges Volk! - das sind die Worte, die du den Israeliten ausrichten sollst. ");
INSERT INTO deutkw_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Da ging Mose hin, die Vornehmsten des Volkes zusammen zu rufen, und richtete ihnen alle jene Worte aus, die ihm Jahwe aufgetragen hatte. ");
INSERT INTO deutkw_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Das ganze Volk aber sprach einstimmig: Alles, was Jahwe befiehlt, wollen wir thun! Da überbrachte Mose die Rede des Volks an Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Hierauf sprach Jahwe zu Mose: Ich werde alsbald zu dir kommen in dichtem Gewölk, damit das Volk es höre, wenn ich mit dir rede, sowie auf ewige Zeiten an dich glaube. Mose aber berichtete Jahwe die Rede des Volks. ");
INSERT INTO deutkw_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Da sprach Jahwe zu Mose: Geh zu dem Volk und befiehl, daß sie heute und morgen sich rein halten und ihre Kleider waschen. ");
INSERT INTO deutkw_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Und übermorgen sollen sie bereit sein; denn übermorgen wird Jahwe vor den Augen des ganzen Volks auf den Berg Sinai hinabfahren. ");
INSERT INTO deutkw_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Dem Volk aber sollst du ringsum eine Grenze ziehen, indem du gebietest: Hütet euch davor, den Berg hinanzusteigen oder seinem Fuße zu nahe zu kommen; wer irgend dem Berge zu nahe kommt, der soll getötet werden! ");
INSERT INTO deutkw_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Keines Hand darf ihn berühren; denn ein solcher soll gesteinigt oder erschossen werden, sowohl Mensch als Vieh, und das Leben lassen müssen. Wenn das Widderhorn geblasen wird, sollen sie den Berg hinansteigen. ");
INSERT INTO deutkw_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Da stieg Mose vom Berge zum Volke hinab und befahl dem Volke, sich rein zu halten und die Kleider zu waschen. ");
INSERT INTO deutkw_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Und er sprach zu dem Volke: Seid übermorgen bereit; keiner darf sich einem Weibe nahen! ");
INSERT INTO deutkw_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Am dritten Tag aber, als es Morgen wurde, brachen Donner und Blitze los, indem eine schwere Wolke über dem Berge gelagert war, und es erscholl starkes Geschmetter von Trompeten: Da kam ein Schrecken über alles Volk, das im Lager war. ");
INSERT INTO deutkw_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Mose aber führte das Volk aus dem Lager heraus, Gott entgegen, und sie stellten sich am Fuße des Berges auf. ");
INSERT INTO deutkw_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Der Berg Sinai jedoch war ganz in Rauch eingehüllt, weil Jahwe im Feuer auf ihn herabgefahren war, und Rauch stieg von ihm auf wie von einem Schmelzofen, und alles Volk erbebte heftig. ");
INSERT INTO deutkw_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Und das Schmettern der Trompeten wurde immer stärker: Mose redete und Gott antwortete ihm laut. ");
INSERT INTO deutkw_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Da fuhr Jahwe auf den Berg Sinai, auf den Gipfel des Berges, hinab. Und Jahwe berief Mose auf den Gipfel des Berges; da stieg Mose hinauf. ");
INSERT INTO deutkw_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Da sprach Jahwe zu Mose: Steige hinab und schärfe dem Volke ein, daß sie sich ja nicht unterfangen sollen, zu Jahwe vorzudringen, um ihn zu sehen; sonst würde eine große Zahl von ihnen umkommen. ");
INSERT INTO deutkw_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Auch die Priester, die Jahwe nahe treten, sollen sich der Reinigung unterziehen, daß nicht etwa Jahwe gegen sie losbreche. ");
INSERT INTO deutkw_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Mose aber entgegnete Jahwe: Das Volk kann unmöglich auf den Berg Sinai hinaufsteigen; denn du selbst hast uns ja eingeschärft: Grenze den Berg ein und erkläre ihn für unnahbar! ");
INSERT INTO deutkw_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Da sprach Jahwe zu ihm: Steige nur hinab und komme dann in Begleitung Aarons wieder herauf; die Priester aber und das Volk sollen sich nicht vorwagen, um zu Jahwe emporzusteigen, daß er nicht gegen sie losbreche. ");
INSERT INTO deutkw_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Da stieg Mose zum Volke hinab und sagte es ihnen. ");
INSERT INTO deutkw_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Nun redete Gott alle diese Worte und sprach: ");
INSERT INTO deutkw_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Ich bin Jahwe, dein Gott, der dich aus Ägypten, aus dem Lande, wo ihr Sklaven wart, weggeführt hat. ");
INSERT INTO deutkw_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Du sollst keinen anderen Gott haben neben mir. ");
INSERT INTO deutkw_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Du sollst dir keinen Götzen verfertigen, noch irgend ein Abbild von etwas, was droben im Himmel oder unten auf der Erde oder im Wasser unter der Erde ist. ");
INSERT INTO deutkw_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Du sollst dich vor solchen nicht niederwerfen, noch sie verehren; denn ich Jahwe, dein Gott, bin ein eifersüchtiger Gott, der die Verschuldung der Väter ahndet an den Kindern, den Enkeln und Urenkeln derer, die mich hassen, ");
INSERT INTO deutkw_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","aber Gnade erweist solchen, die mich lieben und meine Befehle beobachten, auf Tausende hinaus. ");
INSERT INTO deutkw_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Du sollst den Namen Jahwes, deines Gottes, nicht freventlich aussprechen; denn Jahwe läßt den nicht ungestraft, der seinen Namen freventlich ausspricht. ");
INSERT INTO deutkw_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Denke daran, den Sabbattag heilig zu halten. ");
INSERT INTO deutkw_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Sechs Tage hindurch sollst du arbeiten und alle deine Geschäfte verrichten. ");
INSERT INTO deutkw_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Aber der siebente Tag ist ein Jahwe, deinem Gotte, geweihter Sabbat; da sollst du gar kein Geschäft verrichten, weder du selbst, noch dein Sohn oder deine Tochter, dein Sklave noch deine Sklavin, noch dein Hausvieh, noch der Fremde, der sich in deinen Ortschaften aufhält. ");
INSERT INTO deutkw_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Denn im Verlaufe von sechs Tagen hat Jahwe den Himmel und die Erde, das Meer und alles, was in ihnen ist, gemacht; hierauf ruhte er am siebenten Tage. Daher hat Jahwe den Sabbattag gesegnet und für heilig erklärt. ");
INSERT INTO deutkw_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Sei ehrerbietig gegen deinen Vater und deine Mutter, damit du lange lebest auf dem Boden, den dir Jahwe, dein Gott, zu eigen geben wird. ");
INSERT INTO deutkw_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Du sollst nicht morden. ");
INSERT INTO deutkw_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Du sollst nicht ehebrechen. ");
INSERT INTO deutkw_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Du sollst nicht stehlen. ");
INSERT INTO deutkw_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Du sollst gegen deinen Nächsten nicht als falscher Zeuge aussagen. ");
INSERT INTO deutkw_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Du sollst nicht Verlangen tragen nach deines Nächsten Hause. Du sollst nicht Verlangen tragen nach deines Nächsten Weibe, noch nach seinem Sklaven, seiner Sklavin, seinem Ochsen, seinem Esel, noch nach irgend etwas, was deinem Nächsten gehört. ");
INSERT INTO deutkw_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Als aber das ganze Volk die Donnerschläge und die Blitze, das Trompetengeschmetter und den rauchenden Berg wahrnahm, da fürchtete sich das Volk und zitterte und blieb in der Ferne stehen. ");
INSERT INTO deutkw_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Und sie sprachen zu Mose: Sprich du mit uns; wir wollen es gern anhören! Gott selbst aber soll lieber nicht mit uns reden, sonst müssen wir sterben. ");
INSERT INTO deutkw_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Mose erwiderte dem Volke: habt keine Angst; denn um euch zu prüfen ist Gott gekommen, und damit Furcht vor ihm euch innewohne, daß ihr nicht sündigt. ");
INSERT INTO deutkw_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Da blieb das Volk in der Ferne stehen, während Mose an das dunkle Gewölk herantrat, in welchem sich Gott befand. ");
INSERT INTO deutkw_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Jahwe aber sprach zu Mose: So sollst du zu den Israeliten sprechen: Ihr habt gesehen, daß ich vom Himmel her mit euch geredet habe. ");
INSERT INTO deutkw_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Verfertigt euch neben mir keine silbernen Götzen; auch goldene Götzen sollt ihr euch nicht verfertigen. ");
INSERT INTO deutkw_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Einen Opferaltar aus Erde sollst du mir errichten und darauf deine Brandopfer und Heilsopfer, deine Schafe und Rinder opfern; an jeder Stätte, die ich dazu bestimmen werde, daß man mich daselbst verehre, werde ich zu dir kommen und dich segnen. ");
INSERT INTO deutkw_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Wenn du mir aber einen Altar aus Steinen errichtest, so darfst du ihn nicht aus behauenen Steinen aufbauen, denn wenn du sie mit eisernen Werkzeugen bearbeitest, entweihst du sie. ");
INSERT INTO deutkw_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Auch darfst du nicht auf Stufen zu meinem Altar heransteigen, daß nicht etwa deine Schamteile vor ihm entblößt werden. ");
INSERT INTO deutkw_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Folgendes sind die Rechtssatzungen, die du ihnen vorlegen sollst: ");
INSERT INTO deutkw_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Wenn du einen Sklaven hebräischen Stammes kaufst, so soll er sechs Jahre lang Sklavendienste verrichten; im siebenten Jahr aber soll er unentgeltlich freigelassen werden. ");
INSERT INTO deutkw_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Wenn er allein eingetreten ist, so soll er auch allein entlassen werden; wenn er ein Weib gehabt hat, so soll auch sein Weib mit ihm zugleich entlassen werden. ");
INSERT INTO deutkw_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Wenn sein Herr ihm ein Weib gegeben und sie ihm Knaben oder Mädchen geboren hat, so soll das Weib nebst ihren Kindern ihrem Herrn gehören, und er soll allein entlassen werden. ");
INSERT INTO deutkw_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Wenn jedoch der Sklave erklären sollte: Ich habe meinen Herrn, mein Weib und meine Kinder lieb und mag nicht frei werden, ");
INSERT INTO deutkw_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","so soll ihn sein Herr vor Gott führen und ihn an die Thüre oder den Thürpfosten stellen, und sein Herr soll ihm das Ohr mit einem Pfriemen durchbohren; so soll er dann für immer sein Sklave sein. ");
INSERT INTO deutkw_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Wenn jemand seine Tochter als Sklavin verkauft, so darf sie nicht entlassen werden, wie die Sklaven. ");
INSERT INTO deutkw_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Wenn sie ihrem Herrn, der sie für sich bestimmt hat, mißfällt, so soll er sie loskaufen lassen; aber an volksfremde Leute darf er sie nicht verkaufen, wenn er ihr sein Wort nicht hält. ");
INSERT INTO deutkw_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Wenn er sie für seinen Sohn bestimmt, so soll er sie wie seine eigene Tochter behandeln. ");
INSERT INTO deutkw_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Wenn er sich eine andere nimmt, darf er jener nichts von dem abbrechen, was sie an Fleischnahrung, Kleidung und Beiwohnung zu beanspruchen hat. ");
INSERT INTO deutkw_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Wenn er ihr diese drei Dinge nicht leistet, so soll sie umsonst, ohne Entgelt, frei werden. ");
INSERT INTO deutkw_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Wer einen anderen schlägt, so daß er stirbt, der soll mit dem Tode bestraft werden. ");
INSERT INTO deutkw_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Wenn er es aber nicht vorsätzlich gethan, sondern Gott es durch ihn so gefügt hat, so will ich dir eine Stätte bestimmen, wohin er flüchten kann. ");
INSERT INTO deutkw_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Wenn aber einer gegen den anderen eine offenbare Frevelthat begeht, indem er ihn auf hinterlistige Weise totschlägt, so sollst du ihn sogar von meinem Altare wegholen, damit er hingerichtet werde. ");
INSERT INTO deutkw_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Wer seinen Vater oder seine Mutter schlägt, soll mit dem Tode bestraft werden. ");
INSERT INTO deutkw_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Wer einen Israeliten raubt, mag er ihn nun verkaufen, oder mag er noch bei ihm vorgefunden werden -, der soll mit dem Tode bestraft werden. ");
INSERT INTO deutkw_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Wer eine Verwünschung über seinen Vater oder seine Mutter ausspricht, soll mit dem Tode bestraft werden. ");
INSERT INTO deutkw_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Wenn ein paar Männer einen Streit haben, und einer den andern mit einem Stein oder mit einem Karst schlägt, so daß er zwar nicht stirbt, aber bettlägerig wird, ");
INSERT INTO deutkw_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","so soll, wenn der Geschlagene wieder aufkommt und auf seinen Stock gestützt im Freien herumgehen kann, der Thäter frei ausgehen; bloß für die Zeit, wo er unthätig bleiben mußte, soll er ihn entschädigen und für seine Heilung Sorge tragen. ");
INSERT INTO deutkw_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Wenn jemand seinen Sklaven oder seine Sklavin mit dem Stocke schlägt, so daß er ihm unter der Hand stirbt, so soll er bestraft werden. ");
INSERT INTO deutkw_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Wenn er dagegen noch einen oder zwei Tage leben bleibt, so soll er nicht bestraft werden; denn er ist ja sein um Geld erkauftes Eigentum. ");
INSERT INTO deutkw_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Wenn aber Leute einen Raufhandel haben und dabei ein schwangeres Weib stoßen, so daß eine Fehlgeburt erfolgt, ohne daß weiterer Schaden geschieht, so soll der Thäter eine Buße entrichten, wie sie ihm der Ehemann des Weibes auferlegt, und er soll sie bezahlen nach dem Ausspruch von Schiedsrichtern. ");
INSERT INTO deutkw_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Geschieht aber ein Schaden, so soll einer lassen Leben um Leben, ");
INSERT INTO deutkw_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Auge um Auge, Zahn um Zahn, Hand um Hand, Fuß um Fuß, ");
INSERT INTO deutkw_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Brandwunde um Brandwunde, Stichwunde um Stichwunde, Hiebwunde um Hiebwunde. ");
INSERT INTO deutkw_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Wenn jemand seinem Sklaven oder seiner Sklavin ins Auge schlägt so daß dasselbe unbrauchbar wird, so soll er ihn zur Entschädigung für das Auge freilassen. ");
INSERT INTO deutkw_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Und wenn er seinem Sklaven oder seiner Sklavin einen Zahn ausschlägt, so soll er ihn zur Entschädigung für den Zahn freilassen. ");
INSERT INTO deutkw_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Wenn ein Rind einen Mann oder eine Frau totstößt, so soll das Rind gesteinigt und darf sein Fleisch nicht gegessen werden; der Besitzer des Rindes aber soll frei ausgehen. ");
INSERT INTO deutkw_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Wenn aber das Rind schon längst stößig gewesen ist, und man dies seinem Besitzer vorgehalten, und er es trotzdem nicht sorgfältig gehütet hat, so soll das Rind, wenn es einen Mann oder eine Frau totstößt, gesteinigt, aber auch sein Besitzer mit dem Tode bestraft werden. ");
INSERT INTO deutkw_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Wenn ihm ein Lösegeld auferlegt wird, soll er als Lösegeld für sein Leben so viel bezahlen, als ihm auferlegt wird. ");
INSERT INTO deutkw_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Wenn ein Knabe oder ein Mädchen gestoßen wird, so soll nach demselben Rechte mit ihm verfahren werden. ");
INSERT INTO deutkw_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Wenn das Rind einen Sklaven oder eine Sklavin stößt, so sollen dem Eigentümer derselben dreißig Sekel Silber bezahlt, das Rind aber gesteinigt werden. ");
INSERT INTO deutkw_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Wenn jemand eine Cisterne offen läßt oder wenn jemand eine Cisterne gräbt, ohne sie zuzudecken, und ein Rind oder ein Esel hineinfällt, ");
INSERT INTO deutkw_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","so soll der Besitzer der Cisterne den Besitzer desselben mit Geld entschädigen; das tote Tier aber soll ihm selbst gehören. ");
INSERT INTO deutkw_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Wenn jemandes Rind das Rind eines andern totstößt, so sollen sie das lebende Rind verkaufen und den Erlös dafür unter sich teilen; auch das tote sollen sie unter sich teilen. ");
INSERT INTO deutkw_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Wenn es aber bekannt war, daß das Rind schon längst stößig war, und sein Besitzer es nicht sorgfältig gehütet hat, soll er als Ersatz für jenes Rind ein Rind hergeben, das tote aber soll ihm zufallen. ");
INSERT INTO deutkw_vpl VALUES ("EX21_37","003_21_37","EXO","21","37","37","Wenn jemand ein Rind oder ein Schaf stiehlt und es schlachtet oder verkauft, soll er fünf Stück Rinder für ein Rind und vier Stück Schafe für ein Schaf als Buße entrichten; ");
INSERT INTO deutkw_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Wenn der Dieb beim nächtlichen Einbruch betroffen und dabei tot geschlagen wird, so erwächst für den Totschläger keine Blutschuld. ");
INSERT INTO deutkw_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Wenn ihm aber die Sonne bereits geschienen hat, so erwächst für ihn Blutschuld, er muß Ersatz leisten, und wenn er nicht hat, soll er als Entgelt für seinen Diebstahl als Sklave verkauft werden. ");
INSERT INTO deutkw_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Wenn das gestohlene, sei es nun ein Rind oder ein Esel oder ein Schaf, lebendig bei ihm vorgefunden wird, so soll er je noch ein zweites Tier als Buße entrichten. ");
INSERT INTO deutkw_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Wenn jemand seinen Acker oder Weinberg beweiden, sein Vieh aber frei laufen läßt, und dasselbe auf einem fremden Acker etwas frißt, so soll er von dem seinigen entsprechend dem Ertrage desselben Ersatz leisten; wenn es aber den ganzen Acker abweidet, soll er das Beste von dem Ertrage seines Ackers oder Weinbergs als Ersatz entrichten. ");
INSERT INTO deutkw_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Wenn Feuer auskommt und das Gestrüpp ergreift, hernach aber ein Getreidehaufen oder das in Halmen stehende Korn oder überhaupt Ackerfrüchte verbrennen, so muß der, welcher den Brand verursacht hat, vollen Ersatz leisten. ");
INSERT INTO deutkw_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Wenn einer dem andern Geld oder Kostbarkeiten zum Aufbewahren übergeben hat, und dies aus dem Hause des Betreffenden gestohlen wird, so muß der Dieb, wenn er ausfindig gemacht wird, das Doppelte als Ersatz entrichten. ");
INSERT INTO deutkw_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Wenn jedoch der Dieb nicht ausfindig gemacht wird, so soll der Besitzer des Hauses vor Gott hintreten, damit entschieden werde, daß er sich am Eigentume des anderen nicht vergriffen habe. ");
INSERT INTO deutkw_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Bei irgend einem Eigentumsverbrechen, mag es sich nun um ein Rind handeln oder um einen Esel, ein Schaf, ein Obergewand oder überhaupt etwas abhanden Gekommenes, von dem einer behauptet: das ist es! soll die Angelegenheit beider vor Gott gebracht werden, und wenn ihn Gott für schuldig erklärt, soll er dem anderen als Ersatz das Doppelte entrichten. ");
INSERT INTO deutkw_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Wenn einer dem anderen einen Esel oder ein Rind oder ein Schaf, überhaupt irgend ein Stück Vieh zum Hüten übergiebt, und dieses umkommt oder Schaden nimmt oder weggeschleppt wird, ohne daß es jemand sieht, ");
INSERT INTO deutkw_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","so soll ein Eid bei Jahwe den Handel entscheiden, ob er sich etwa an dem Eigentume des anderen vergriffen hat; wenn der Besitzer diesen annimmt, braucht jener keinen Ersatz zu leisten. ");
INSERT INTO deutkw_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Wenn es ihm gestohlen worden ist, so soll er es seinem Besitzer ersetzen. ");
INSERT INTO deutkw_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Wenn es von einem wilden Tiere zerrissen worden ist, und er es zum Beweise beibringen kann, braucht er für das Zerrissene keinen Ersatz zu leisten. ");
INSERT INTO deutkw_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Wenn einer von dem anderen ein Stück Vieh entleiht, und dasselbe Schaden nimmt oder umkommt, ohne daß sein Besitzer zugegen gewesen ist, so muß es jener ersetzen. ");
INSERT INTO deutkw_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Wenn aber der Besitzer zugegen gewesen ist, braucht der andere keinen Ersatz zu leisten. Ist er aber ein Löhner, so kommt es auf seinen Lohn. ");
INSERT INTO deutkw_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Wenn jemand eine Jungfrau, die noch unverlobt ist, verführt und ihr beiwohnt, so soll er für sie das Kaufgeld entrichten und sie sich zum Weibe nehmen. ");
INSERT INTO deutkw_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Wenn sich jedoch ihr Vater weigern sollte, sie ihm zur Frau zu geben, so soll er so viel Silber darwägen, als das Kaufgeld für Jungfrauen beträgt. ");
INSERT INTO deutkw_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Eine Zauberin sollst du nicht am Leben lassen. ");
INSERT INTO deutkw_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Jeder, der mit einem Tiere Unzucht treibt, soll mit dem Tode bestraft werden. ");
INSERT INTO deutkw_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Wenn jemand den Götzen opfert, anstatt Jahwe allein, soll er dem Banne verfallen. ");
INSERT INTO deutkw_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Einen Fremdling sollst du nicht drücken noch gewaltthätig behandeln; denn ihr seid auch Fremdlinge gewesen in Ägypten. ");
INSERT INTO deutkw_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Eine Witwe oder Waise sollt ihr nimmermehr bedrücken. ");
INSERT INTO deutkw_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Denn wenn du sie bedrückst, und sie dann um Hilfe zu mir schreit, so werde ich ihren Hilferuf sicher erhören ");
INSERT INTO deutkw_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","und werde in Zorn geraten und euch durch das Schwert umbringen, so daß eure eigenen Weiber Witwen und eure Kinder Waisen werden. ");
INSERT INTO deutkw_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Wenn du jemand aus meinem Volk, einem Armen, der bei dir wohnt, Geld leihst, so behandle ihn nicht wie ein Wucherer; ihr sollt ihm keine Zinsen auferlegen. ");
INSERT INTO deutkw_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Wenn du einem das Obergewand als Pfand wegnimmst, so sollst du es ihm bis Sonnenuntergang zurückgeben. ");
INSERT INTO deutkw_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Denn sein Mantel ist ja seine einzige Körperdecke; womit könnte er sich sonst auf seinem Lager zudecken? Wenn er mich aber um Hilfe anruft, so will ich ihn erhören; denn ich bin barmherzig. ");
INSERT INTO deutkw_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Gott sollst du nicht lästern und einen Vorgesetzten deines Volkes nicht verwünschen. ");
INSERT INTO deutkw_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Deinen Überfluß und das Beste deines Kelterertrags sollst du nicht vorenthalten. Den Erstgeborenen deiner Söhne sollst du mir geben. ");
INSERT INTO deutkw_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Ebenso sollst du es halten mit deinem Rind und deinem Schaf: sieben Tage hindurch soll es bei seiner Mutter bleiben; am achten Tage sollst du es mir darbringen. ");
INSERT INTO deutkw_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Und ihr sollt mir reine Leute sein. Fleisch aber, das im Freien von wilden Tieren zerrissen worden ist, dürft ihr nicht genießen, sondern sollt es den Hunden vorwerfen. ");
INSERT INTO deutkw_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Du sollst kein falsches Gerücht aussprengen. Biete dem, der eine ungerechte Sache hat, nicht die Hand, für ihn Zeugnis abzulgen und so das Recht zu verdrehen. ");
INSERT INTO deutkw_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Du sollst nicht dem großen Haufen folgen, um Böses zu thun. Bei einer Rechtssache sollst du nicht, der Mehrheit dich anschließend, Aussagen machen und so das Recht beugen. ");
INSERT INTO deutkw_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Du sollst nicht die Partei des Angesehenen ergreifen, wenn er eine Rechtssache hat. ");
INSERT INTO deutkw_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Wenn du einen deinem Feinde gehörenden Ochsen oder Esel findest, der sich verirrt hat, so sollst du ihm denselben zurückbringen. ");
INSERT INTO deutkw_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Wenn du siehst, daß der Esel deines Feindes unter seiner Last zusammengebrochen ist, so gehe nicht etwa an ihm vorüber, sondern hilf ihm, den Esel zu befreien. ");
INSERT INTO deutkw_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Du sollst das Recht des Armen, der unter euch ist, nicht beugen, wenn er eine Streitsache hat. ");
INSERT INTO deutkw_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","halte dich fern von einer Sache, bei der Lüge im Spiel ist, und hilf nicht einen Unschuldigen oder der eine gerechte Sache hat, verurteilen; denn ich spreche keinen frei, der schuldig ist. ");
INSERT INTO deutkw_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Und Geschenke nimm nicht an; denn Geschenke machen Sehende blind und verkehren die gerechte Sache. ");
INSERT INTO deutkw_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Einen Fremdling sollst du nicht hart behandeln; ihr wißt ja, wie es dem Fremden zu Mute ist, weil ihr selbst Fremdlinge gewesen seid in Ägypten. ");
INSERT INTO deutkw_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Sechs Jahre hindurch sollst du dein Land bebauen und seinen Ertrag einheimsen; ");
INSERT INTO deutkw_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","im siebenten Jahre aber sollst du es brach liegen lassen und frei geben, so daß die Bedürftigen deines Volks ihre Nahrung holen können, und was sie übrig lassen, mögen die wilden Tiere fressen; ebenso sollst du verfahren mit deinem Weinberg und deinem Ölgarten. ");
INSERT INTO deutkw_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Sechs Tage hindurch magst du deine Arbeit verrichten; am siebenten Tag aber sollst du feiern, damit dein Rind und dein Esel ruhe, und der Sohn deiner Sklavin, sowie der Fremdling einmal aufatme. ");
INSERT INTO deutkw_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Und in Bezug auf alles, was ich euch befohlen habe, nehmt euch wohl in acht! Den Namen anderer Götter erwähnet nicht; er soll dir nicht über die Lippen kommen! ");
INSERT INTO deutkw_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Dreimal im Jahre sollst du mir eine Festfeier abhalten. ");
INSERT INTO deutkw_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Das Fest der ungesäuerten Brote sollst du halten: sieben Tage lang sollst du ungesäuerte Brote essen, wie ich es dir befohlen habe, zur Zeit des Monats Abib; denn in ihm bist du aus Ägypten ausgezogen. Vor mir soll man nicht mit leeren Händen erscheinen. ");
INSERT INTO deutkw_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Und das Fest der Kornernte, der Erstlinge deines Landbaus, den du betreibst, und das Fest der Herbstlese um die Wende des Jahres, wenn du die Bodenerzeugnisse einheimsest. ");
INSERT INTO deutkw_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Dreimal im Jahre soll alles, was männlich ist, vor dem Herrn, Jahwe, erscheinen. ");
INSERT INTO deutkw_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Du sollst mir nicht zu gesäuerten Broten das Blut meines Opfers darbringen, und das Fett meines Festopfers soll nicht bis zum folgenden Tag aufbewahrt werrden. ");
INSERT INTO deutkw_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Das Vorzüglichste, die Erstlinge deines Ackerbodens, sollst du zum Hause Jahwes, deines Gottes, bringen. Du sollst ein Böckchen nicht in der Milch seiner Mutter kochen. ");
INSERT INTO deutkw_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Ich aber will einen Engel vor dir einhergehen lassen um dich unterwegs in meine Hut zu nehmen und dich an die Stätte zu bringen, die ich festgesetzt habe. ");
INSERT INTO deutkw_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Nimm dich vor ihm in acht und gehorche ihm; sei nicht widerspenstig gegen ihn. Denn er wird euch eure Übertretung nicht verzeihen, denn er ist eine Offenbarung meines Wesens! ");
INSERT INTO deutkw_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Wenn du aber seinen Worten gehorchen und alles thun willst, was ich befehle, so will ich befeinden, die dir feind sind, und bedrängen, die dich bedrängen. ");
INSERT INTO deutkw_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Ja mein Engel soll vor dir einherziehen und dich zu den Amoritern, Hethitern, Pheresitern, Kanaanitern, Hevitern und Jebusitern führen, damit ich sie ausrotte. ");
INSERT INTO deutkw_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Bete ihre Götter nicht an und diene ihnen nicht und ahme ihr Thun nicht nach, sondern zerstöre sie von Grund aus und zerschmettere ihre Malsteine. ");
INSERT INTO deutkw_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Verehrt Jahwe, euren Gott, so wird er dir reichlich Speise und Trank gewähren, und Krankheiten will ich von dir fernhalten. ");
INSERT INTO deutkw_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Nichts Kinderloses noch Unfruchtbares wird es in deinem Lande geben, und ich werde dich am Leben erhalten bis ins volle Alter. ");
INSERT INTO deutkw_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Einen Gottes-Schrecken werde ich vor dir hersenden und alle die Völker, unter welche du kommen wirst, in Verwirrung bringen und will machen, daß alle deine Feinde vor dir die Flucht ergreifen. ");
INSERT INTO deutkw_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Und ich werde Hornissen vor dir hersenden, damit sie die Heviter, die Kanaaniter und die Hethiter vor dir her vertreiben. ");
INSERT INTO deutkw_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Ich will sie aber nicht im Verlauf eines Jahres vor dir vertreiben, sonst würde das Land zur Wüste werden, und die wilden Tiere würden zu deinem Schaden überhandnehmen. ");
INSERT INTO deutkw_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Ganz allmählich will ich sie vor dir vertreiben, bis ihr zahlreich genug sein werdet, um euch in den Besitz des Landes zu setzen. ");
INSERT INTO deutkw_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Und ich will dein Gebiet reichen lassen vom Schilfmeer bis zum Meer der Philister und von der Wüste bis zum Euphrat-Strom; ja ich werde die Landesbewohner in eure Gewalt gegeben, und du sollst sie vor dir austreiben. ");
INSERT INTO deutkw_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Du darfst weder mit ihnen noch mit ihren Göttern ein Abkommen schließen. ");
INSERT INTO deutkw_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Sie sollen nicht wohnen bleiben in deinem Lande, daß sie dich nicht zur Versündigung an mir verleiten; denn wenn du ihre Götter verehrst, so wird dir das zum Fallstrick werden. ");
INSERT INTO deutkw_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Und zu Mose sprach er: Steige zu Jahwe hinauf, du und Aaron, Nadab und Abihu, sowie siebzig von den Vornehmen der Israeliten, und bringt ihm, ferne stehend, eure Verehrung dar. ");
INSERT INTO deutkw_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Mose aber soll allein näher zu Jahwe herantreten, während sie nicht herantreten dürfen, und das Volk soll nicht mit ihm hinaufsteigen. ");
INSERT INTO deutkw_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Da ging Mose hin und trug dem Volk alle Gebote und alle Rechtssatzungen Jahwes vor; da antwortete das ganze Volk einmütig: Alle die Gebote, die Jahwe gegeben hat, wollen wir halten. ");
INSERT INTO deutkw_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Da schrieb Mose die Gebote Jahwes auf. Am anderen Morgen früh aber errichtete er einen Altar am Fuß des Berges, sowie zwölf Malsteine nach der Zahl der zwölf Stämme Israels. ");
INSERT INTO deutkw_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Dann gab er den jungen Männern unter den Israeliten den Auftrag, Jahwe Brandopfer darzubringen und als Heilsopfer junge Stiere zu schlachten. ");
INSERT INTO deutkw_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Sodann nahm Mose die Hälfte des Blutes und goß es in die Opferbecken; die andere Hälfte des Blutes aber sprengte er auf den Altar. ");
INSERT INTO deutkw_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Dann nahm er das Buch mit dem Bundesgesetz und las es dem Volke laut vor. Sie aber sprachen: Alles, was Jahwe befohlen hat, wollen wir halten und befolgen. ");
INSERT INTO deutkw_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Hierauf nahm Mose das Blut und besprengte damit das Volk, indem er sprach: Das ist das Blut des Bundes, den Jahwe mit euch geschlossen hat auf Grund aller jener Gebote. ");
INSERT INTO deutkw_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Da stiegen Mose und Aaron, Nadab und Abihu, sowie siebzig von den Vornehmen der Israeliten hinauf ");
INSERT INTO deutkw_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","und sie erblickten den Gott Israels; zu seinen Füßen war ein Boden wie aus Sapphirstein und glänzend hell wie der Himmel selbst. ");
INSERT INTO deutkw_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Wider die Auserwählten der Israeliten aber reckte er seine Hand nicht aus; sie schauten Gott und aßen und tranken. ");
INSERT INTO deutkw_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Da befahl Jahwe Mose: Steige zu mir auf den Berg herauf und verweile daselbst; so will ich dir die Steintafeln mit dem Gesetz und den Geboten geben, die ich aufgeschrieben habe, um sie zu unterweisen. ");
INSERT INTO deutkw_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Und Mose machte sich mit seinem Diener Josua auf; Mose aber stieg auf den Berg Gottes. ");
INSERT INTO deutkw_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Jenen Vornehmen aber befahl er: Wartet hier auf uns, bis wir wieder zu euch kommen; Aaron und Hur sind ja bei euch. Wer eine Rechtssache hat, mag vor sie hintreten. ");
INSERT INTO deutkw_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Als nun Mose auf den Berg gestiegen war, hüllte die Wolke den Berg ein. ");
INSERT INTO deutkw_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Und die Herrlichkeit Jahwes thronte auf dem Berge Sinai. Die Wolke aber hüllte ihn sechs Tage lang ein; am siebenten Tage rief er Mose aus der Wolke zu. ");
INSERT INTO deutkw_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Die Herrlichkeit Jahwes aber auf dem Gipfel des Berges stellte sich den Augen der Israeliten dar wie ein verzehrendes Feuer. ");
INSERT INTO deutkw_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Da begab sich Mose in die Wolke hinein und stieg auf den Berg. Hierauf blieb Mose vierzig Tage und vierzig Nächte auf dem Berge. ");
INSERT INTO deutkw_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Und Jahwe redete zu Mose: ");
INSERT INTO deutkw_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Gebiete den Israeliten, daß sie eine Beisteuer für mich erheben; von einem jeden, den sein Herz dazu treibt, sollt ihr die Beisteuer für mich erheben. ");
INSERT INTO deutkw_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","In den folgenden Dingen soll die Beisteuer bestehen, die ihr von ihnen erheben sollt: in Gold, Silber und Kupfer; ");
INSERT INTO deutkw_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","in blauem Purpur, rotem Purpur, Karmesin, Byssus und Ziegenhaar; ");
INSERT INTO deutkw_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","in rotgefärbten Widderfellen und Seekuhfellen, in Akazienholz, ");
INSERT INTO deutkw_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","in Öl für den Leuchter, Spezereien für das Salböl und das wohlriechende Räucherwerk, ");
INSERT INTO deutkw_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","in Schohamsteinen und in Edelsteinen zum Besetzen des Schulterkleids und des Brustschilds. ");
INSERT INTO deutkw_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Und sie sollen mir ein Heiligtum errichten, daß ich mitten unter ihnen wohne. ");
INSERT INTO deutkw_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Genau nach dem Modell der Wohnung und aller ihrer Geräte, das ich dir zeige, sollt ihr es errichten. ");
INSERT INTO deutkw_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Und zwar sollen sie eine Lade von Akazienholz anfertigen, zwei und eine halbe Elle lang, anderthalbe Elle breit und anderthalbe Elle hoch; ");
INSERT INTO deutkw_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","die sollst du mit gediegenem Gold überziehen - inwendig und auswendig mußt du sie überziehen - und sollst einen ringsumlaufenden goldenen Kranz an ihr anbringen. ");
INSERT INTO deutkw_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Weiter sollst du für sie vier goldene Ringe gießen und diese an ihren vier Füßen befestigen, und zwar zwei Ringe auf ihrer einen Seite und zwei Ringe auf ihrer anderen Seite. ");
INSERT INTO deutkw_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Sodann sollst du Stangen von Akazienholz anfertigen und sie mit Gold überziehen; ");
INSERT INTO deutkw_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","diese Stangen sollst du durch die Ringe ziehen, die an den Seiten der Lade sind, damit man mittels ihrer die Lade tragen kann. ");
INSERT INTO deutkw_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","In den Ringen an der Lade sollen die Stangen bleiben; sie dürfen nicht aus ihnen entfernt werden. ");
INSERT INTO deutkw_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","In die Lade aber sollst du das Gesetz legen, das ich dir übergeben werde. ");
INSERT INTO deutkw_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Sodann sollst du eine Deckplatte aus gediegenem Gold anfertigen, zwei und eine halbe Elle lang und anderthalbe Elle breit. ");
INSERT INTO deutkw_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Und du sollst zwei goldene Kerube anfertigen - in getriebener Arbeit sollst du sie anfertigen - an den beiden Enden der Deckplatte, ");
INSERT INTO deutkw_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","und bringe den einen Kerub an dem einen Ende an und den anderen Kerub an dem anderen Ende. An der Deckplatte sollst du die Kerube anbringen, an ihren beiden Enden. ");
INSERT INTO deutkw_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Es sollen aber die Kerube ihre Flügel nach oben ausgebreitet halten, indem sie mit ihren Flügeln die Deckplatte überdecken, während ihre Gesichter einander zugekehrt sind; gegen die Deckplatte hin sollen die Gesichter der Kerube gerichtet sein. ");
INSERT INTO deutkw_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Sodann sollst du die Deckplatte oben auf die Lade legen; in die Lade aber sollst du das Gesetz legen, das ich dir übergeben werde. ");
INSERT INTO deutkw_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Und dort werde ich mich dir offenbaren und mit dir reden von der Deckplatte aus, von dem Ort zwischen den beiden Keruben, die sich auf der Gesetzeslade befinden, so oft ich dir Befehle an die Israeliten zu übertragen habe. ");
INSERT INTO deutkw_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Sodann sollst du einen Tisch aus Akazienholz anfertigen, zwei Ellen lang, eine Elle breit und anderthalbe Elle hoch. ");
INSERT INTO deutkw_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Den sollst du mit gediegenem Gold überziehen und einen ringsumlaufenden goldenen Kranz an ihm anbringen. ");
INSERT INTO deutkw_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Sodann sollst du eine in Handbreite ringsumlaufende Leiste an ihm anbringen und an dieser Leiste wiederum einen ringsumlaufenden goldenen Kranz. ");
INSERT INTO deutkw_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Weiter sollst du vier goldene Ringe für ihn anfertigen und diese Ringe an den vier Ecken seiner vier Füße befestigen. ");
INSERT INTO deutkw_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Dicht an der Leiste sollen sich die Ringe befinden, zur Aufnahme von Stangen, damit man den Tisch tragen kann. ");
INSERT INTO deutkw_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Die Stangen aber sollst du aus Akazienholz anfertigen und sie mit Gold überziehen; mit ihnen soll dann der Tisch getragen werden. ");
INSERT INTO deutkw_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Und du sollst die zu ihm gehörenden Schüsseln und Schalen, sowie die Kannen und Becher, mit denen das Trankopfer gespendet wird, anfertigen; aus gediegenem Golde sollst du sie anfertigen. ");
INSERT INTO deutkw_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Auf den Tisch aber sollst du beständig Schaubrote vor mich legen. ");
INSERT INTO deutkw_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Ferner sollst du einen Leuchter von gediegenem Gold anfertigen; in getriebener Arbeit soll dieser Leuchter, sein Fußgestell und sein Schaft angefertigt werden, und an ihm sollen sich Blumenkelche - Knollen mit Blüten - befinden. ");
INSERT INTO deutkw_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Von seinen Seiten aber sollen sechs Röhren ausgehen, je drei auf jeder Seite des Leuchters. ");
INSERT INTO deutkw_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","An jeder Röhre sollen sich drei mandelblütenförmige Blumenkelche - je ein Knollen mit Blüte - befinden; so an allen sechs Röhren, die von dem Leuchter ausgehen. ");
INSERT INTO deutkw_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Am Leuchter selbst aber sollen sich vier Blumenkelche befinden, mandelblütenförmige Knollen mit Blüten, ");
INSERT INTO deutkw_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","und zwar jedesmal ein Knollen unter jedem der drei Röhrenpaare an ihm, - der sechs Röhren, die von dem Leuchter ausgehen. ");
INSERT INTO deutkw_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Ihre Knollen und Röhren sollen aus einem Stück mit ihm sein; alles getriebene Arbeit aus einem Stück, von gediegenem Golde. ");
INSERT INTO deutkw_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Du sollst auch sieben Lampen für ihn anfertigen, und man soll ihm die Lampen aufsetzen, damit sie den Platz vor ihm beleuchten. ");
INSERT INTO deutkw_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Die zu ihm gehörenden Lichtscheren und Pfannen sollen aus gediegenem Golde sein. ");
INSERT INTO deutkw_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Ein Talent gediegenen Goldes soll man auf ihn und alle die erwähnten Geräte verwenden. ");
INSERT INTO deutkw_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Und sieh zu, daß du sie genau nach dem Modell anfertigst, das dir auf dem Berge gezeigt wurde. ");
INSERT INTO deutkw_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Die Wohnung aber sollst du anfertigen aus zehn Teppichen aus gezwirntem Byssus, blauem und rotem Purpur und Karmesin; mit Keruben, wie sie der Kunstwirker macht, sollst du sie anfertigen. ");
INSERT INTO deutkw_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Jeder Teppich soll 28 Ellen lang und vier Ellen breit sein; alle Teppiche sollen einerlei Maß haben. ");
INSERT INTO deutkw_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Je fünf Teppiche sollen aneinander gefügt sein. ");
INSERT INTO deutkw_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Sodann sollst du am Saume des äußersten Teppichs der einen Fläche Schleifen von blauem Purpur anbringen und ebenso am Saume des äußersten Teppichs der andern Fläche. ");
INSERT INTO deutkw_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Fünfzig Schleifen sollst du an dem einen Teppich anbringen und fünfzig Schleifen sollst du am Rande des Teppichs anbringen, der zu der anderen Fläche gehört, so daß die Schleifen einander gegenüberstehen. ");
INSERT INTO deutkw_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Sodann sollst du fünfzig goldene Haken anfertigen und die Teppiche mittels der Haken zusammenfügen, so daß die Wohnung ein Ganzes wird. ");
INSERT INTO deutkw_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Weiter sollst du Teppiche aus Ziegenhaar fertigen, zum Zeltdach über der Wohnung; elf Teppiche sollst du dazu anfertigen. ");
INSERT INTO deutkw_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Jeder Teppich soll dreißig Ellen lang und vier Ellen breit sein; 8 alle elf Teppiche sollen einerlei Maß haben. ");
INSERT INTO deutkw_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Fünf von diesen Teppichen sollst du für sich zu einem Ganzen verbinden und ebenso die sechs andern für sich; und zwar sollst du den sechsten Teppich auf der Vorderseite des Zeltes doppelt legen. ");
INSERT INTO deutkw_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Sodann sollst du am Saume des äußersten Teppichs der einen Fläche fünfzig Schleifen anbringen und ebenso fünfzig Schleifen am Saume des äußersten Teppichs der andern Fläche. ");
INSERT INTO deutkw_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Und du sollst fünfzig kupferne Haken anfertigen und die Haken durch die Schleifen ziehen und so das Zeltdach zusammenfügen, so daß es ein Ganzes wird. ");
INSERT INTO deutkw_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Und was das Überhängen des an den Zeltteppichen Überschüssigen betrifft, so soll die Hälfte des überschüssigen Teppichs auf der Rückseite der Wohnung herabhängen. ");
INSERT INTO deutkw_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Und von dem, was an der Länge der übrigen Zeltteppiche überschüssig ist, soll auf beiden Seiten jedesmal eine Elle über die Langseiten der Wohnung überhängen und diese so bedecken. ");
INSERT INTO deutkw_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Sodann sollst du eine Überdecke für das Zeltdach anfertigen aus rotgefärbten Widderfellen und eine Überdecke von Seekuhfellen oben darüber. ");
INSERT INTO deutkw_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Ferner sollst du die Bretter zur Wohnung anfertigen, aufrechtstehende, von Akazienholz. ");
INSERT INTO deutkw_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Jedes Brett soll zehn Ellen lang und anderthalbe Elle breit sein. ");
INSERT INTO deutkw_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Jedes Brett soll zwei Zapfen haben, die untereinander verbunden sind; in dieser Weise sollst du alle Bretter der Wohnung anfertigen. ");
INSERT INTO deutkw_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Und zwar sollst du an Brettern für die Wohnung anfertigen: zwanzig Bretter für die nach Süden gewendete Seite; ");
INSERT INTO deutkw_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","und sollst vierzig silberne Füße unter den zwanzig Brettern anbringen, je zwei Füße unter jedem Brette für die beiden Zapfen desselben. ");
INSERT INTO deutkw_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Ebenso für die andere Seite der Wohnung, in der Richtung nach Norden, zwanzig Bretter ");
INSERT INTO deutkw_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","mit ihren vierzig silbernen Füßen, je zwei Füßen unter jedem Brette. ");
INSERT INTO deutkw_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Für die nach Westen gerichtete Seite der Wohnung aber sollst du sechs Bretter anfertigen. ");
INSERT INTO deutkw_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Und zwei Bretter sollst du anfertigen für die Winkel der Wohnung auf der Hinterseite. Und sie sollen doppelt sein im unteren Teil und ebenso sollen sie doppelt sein am oberen Ende für den einen Ring. ");
INSERT INTO deutkw_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","So sollen beide beschaffen sein; die beiden Winkel sollen sie bilden. ");
INSERT INTO deutkw_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Somit sollen es acht Bretter sein mit ihren silbernen Füßen, - sechszehn Füßen, je zwei Füßen unter jedem Brette. ");
INSERT INTO deutkw_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Weiter sollst du fünf Riegel aus Akazienholz anfertigen für die Bretter der einen Seite der Wohnung, ");
INSERT INTO deutkw_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","fünf Riegel für die Bretter der anderen Seite der Wohnung und fünf Riegel für die Bretter der nach Westen gerichteten Hinterseite der Wohnung. ");
INSERT INTO deutkw_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Und der mittelste Riegel soll in der Mitte der Bretter quer durchlaufen von einem Ende bis zum andern. ");
INSERT INTO deutkw_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Die Bretter aber sollst du mit Gold überziehen; auch die Ringe an ihnen, die zur Aufnahme der Riegel bestimmt sind, sollst du aus Gold anfertigen und auch die Riegel mit Gold überziehen. ");
INSERT INTO deutkw_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","So sollst du die Wohnung aufrichten nach Gebühr, wie es dir auf dem Berge gezeigt wurde. ");
INSERT INTO deutkw_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Ferner sollst du einen Vorhang anfertigen aus blauem und rotem Purpur, Karmesin und gezwirntem Byssus; in Kunstwirker-Arbeit soll man ihn herstellen mit Keruben. ");
INSERT INTO deutkw_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Befestige ihn an vier mit Gold überzogenen Säulen von Akazienholz, die goldene Nägel haben und auf vier silbernen Füßen stehen. ");
INSERT INTO deutkw_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Es soll aber der Vorhang seine Stelle haben unter den Haken; und hinein hinter den Vorhang sollst du die Lade mit dem Gesetze bringen. So soll euch der Vorhang als eine Scheidewand dienen zwischen dem Heiligen und dem Allerheiligsten. ");
INSERT INTO deutkw_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Und du sollst die Deckplatte auf die Gesetzeslade thun, im Allerheiligsten. ");
INSERT INTO deutkw_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Den Tisch aber sollst du außerhalb des Vorhangs aufstellen und den Leuchter gegenüber dem Tisch auf der Südseite der Wohnung, während du den Tisch auf die Nordseite stellst. ");
INSERT INTO deutkw_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Ferner sollst du einen Vorhang anfertigen für die Thüröffnung des Zeltes aus blauem und rotem Purpur, Karmesin und gezwirntem Byssus, in Buntwirker-Arbeit. ");
INSERT INTO deutkw_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Und für diesen Vorhang sollst du fünf Säulen aus Akazienholz anfertigen und sie mit Gold überziehen; auch die zugehörigen Nägel sollen von Gold sein. Und du sollst fünf kupferne Füße für sie gießen. ");
INSERT INTO deutkw_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Den Altar sollst du aus Akazienholz anfertigen, fünf Ellen lang und fünf Ellen breit - viereckig soll der Altar sein - und drei Ellen hoch. ");
INSERT INTO deutkw_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Und die zugehörigen Hörner sollst du an seinen vier Ecken anbringen, so daß die Hörner ein Ganzes mit ihm bilden, und sollst ihn mit Kupfer überziehen. ");
INSERT INTO deutkw_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Und die zugehörigen Töpfe, die man braucht, um ihn vom Fett zu säubern, wie die zugehörigen Schaufeln, Becken, Gabeln und Pfannen, alle zu ihm gehörenden Geräte, sollst du aus Kupfer anfertigen. ");
INSERT INTO deutkw_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Ferner sollst du ein Gitterwerk für ihn anfertigen, ein Netzwerk aus Kupfer, und sollst an dem Netze vier kupferne Ringe anbringen, an den vier Ecken des Altars, ");
INSERT INTO deutkw_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","und sollst es unterhalb des den Altar umlaufenden Simses befestigen, so daß das Netz bis zur Mitte des Altars reicht. ");
INSERT INTO deutkw_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Ferner sollst du Stangen für den Altar anfertigen, Stangen aus Akazienholz, und sie mit Kupfer überziehen. ");
INSERT INTO deutkw_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Diese seine Stangen sollen durch die Ringe gezogen werden, so daß sich die Stangen auf den beiden Seiten des Altars befinden, wenn man ihn trägt. ");
INSERT INTO deutkw_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Aus Brettern, so daß er inwendig hohl ist, sollst du ihn herstellen; wie man es dir auf dem Berge gezeigt hat, so sollen sie es machen. ");
INSERT INTO deutkw_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Und den Vorhof der Wohnung sollst du so herstellen: für die nach Süden gewendete Seite Vorhof-Umhänge aus gezwirntem Byssus, hundert Ellen lang, für die eine Seite; ");
INSERT INTO deutkw_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","dazu zwanzig Säulen nebst ihren zwanzig kupfernen Füßen - die Nägel der Säulen und die zugehörigen Ringe sollen von Silber sein. ");
INSERT INTO deutkw_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Ebenso Umhänge für die nördliche Langseite, hundert Ellen; dazu zwanzig Säulen nebst ihren zwanzig kupfernen Füßen, die Nägel der Säulen und die zugehörigen Ringe von Silber. ");
INSERT INTO deutkw_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Die westliche Breitseite des Vorhofs aber soll Umhänge von fünfzig Ellen haben, dazu zehn Säulen nebst ihren zehn Füßen. ");
INSERT INTO deutkw_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Und die nach Osten gewendete Breitseite des Vorhofs soll fünfzig Ellen betragen; ");
INSERT INTO deutkw_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","und zwar sollen fünfzehn Ellen Umhänge, dazu drei Säulen nebst ihren drei Füßen, auf die eine Seite kommen, ");
INSERT INTO deutkw_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","und ebenso auf die andere Seite fünfzehn Ellen Umhänge, dazu drei Säulen nebst ihren drei Füßen. ");
INSERT INTO deutkw_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Das Thor des Vorhofs aber soll einen Vorhang haben, zwanzig Ellen breit, von blauem und rotem Purpur, Karmesin und gezwirntem Byssus in Buntwirker-Arbeit; dazu vier Säulen nebst ihren vier Füßen. ");
INSERT INTO deutkw_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Alle Säulen des Vorhofs ringsum sollen mit silbernen Ringen versehen sein; auch die Nägel an ihnen sollen von Silber sein, ihre Füße aber von Kupfer. ");
INSERT INTO deutkw_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Die Länge des Vorhofs soll hundert Ellen betragen, die Breite fünfzig Ellen und die Höhe fünf Ellen aus gezwirntem Byssus, mit kupfernen Füßen. ");
INSERT INTO deutkw_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Und alle Geräte der Wohnung, deren man bedarf bei dem gesamten heiligen Dienst an ihr, und alle ihre Pflöcke und alle Pflöcke des Vorhofs sollen aus Kupfer sein. ");
INSERT INTO deutkw_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Du aber gebiete den Israeliten, daß sie dir lauteres Öl aus zerstoßenen Oliven für den Leuchter herbeibringen, damit man beständig Lampen aufstecken kann. ");
INSERT INTO deutkw_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Im Offenbarungszelt, außerhalb des Vorhangs, welcher sich vor dem Gesetze befindet, soll ihn Aaron mit seinen Söhnen herrichten, daß er vom Abend bis zum Morgen vor Jahwe brenne. Solches ist den Israeliten als eine für alle Zeiten und alle Geschlechter geltende Verpflichtung auferlegt. ");
INSERT INTO deutkw_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Du aber laß aus der Gesamtheit der Israeliten deinen Bruder Aaron nebst seinen Söhnen zu dir herantreten, damit er mir Priesterdienst thue, Aaron, Nadab und Abihu, Eleasar und Ithamar, die Söhne Aarons. ");
INSERT INTO deutkw_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Und du sollst für deinen Bruder Aaron heilige Kleider anfertigen, zur Ehre und herrlichen Zier. ");
INSERT INTO deutkw_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Und rede mit allen Kunstverständigen, die ich mit künstlerischem Geist erfüllt habe, daß sie die Kleider Aarons anfertigen sollen, damit man ihn weihen, und er mir Priesterdienst thun kann. ");
INSERT INTO deutkw_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Dies aber sind die Kleider, die sie anfertigen sollen: Tasche, Schulterkleid, Obergewand, Leibrock aus gewürfeltem Zeug, Kopfbund und Gürtel. ");
INSERT INTO deutkw_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Und sie sollen deinem Bruder Aaron und seinen Söhnen heilige Kleider anfertigen, damit er mir Priesterdienst thue. Und zwar sollen sie dazu das Gold, den blauen und roten Purpur, den Karmesin und den Byssus verwenden. ");
INSERT INTO deutkw_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Sie sollen aber das Schulterkleid anfertigen aus Gold, blauem und rotem Purpur, Karmesin und gezwirntem Byssus, in Kunstwirker-Arbeit. ");
INSERT INTO deutkw_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Zwei mit ihm verbundene Schulterstücke soll es haben; an seinen beiden Enden soll es mit ihnen verbunden werden. ");
INSERT INTO deutkw_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Und die Binde, die sich behufs seiner Anlegung an ihm befindet, soll von gleicher Arbeit sein und ein Ganzes mit ihm bilden, aus Gold, blauem und rotem Purpur, Karmesin und gezwirntem Byssus. ");
INSERT INTO deutkw_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Hierauf sollst du die beiden Schohamsteine nehmen und in dieselben die Namen der Israels-Söhne eingraben, ");
INSERT INTO deutkw_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","sechs ihrer Namen auf den einen Stein und die sechs übrigen Namen auf den anderen Stein, nach der Reihenfolge ihrer Geburt. ");
INSERT INTO deutkw_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Mittels Steinschneider-Arbeit - Siegelstecherkunst - sollst du die beiden Steine gravieren, nach Maßgabe der Namen der Israels-Söhne, und sollst sie mit einem Flechtwerk von Golddraht einfassen. ");
INSERT INTO deutkw_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Diese beiden Steine sollst du auf den Schulterstücken des Schulterkleids befestigen, als Steine des gnädigen Gedenkens an die Israeliten; so soll Aaron ihre Namen auf seinen beiden Schultern vor Jahwe tragen, daß ihrer gnädig gedacht werde. ");
INSERT INTO deutkw_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Ferner sollst du Goldgeflechte anfertigen ");
INSERT INTO deutkw_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","und zwei Kettchen von gediegenem Gold; in Gestalt von gedrehten Schnuren sollst du sie herstellen und sollst diese aus Schnuren gefertigten Kettchen an den Geflechten befestigen. ");
INSERT INTO deutkw_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Weiter sollst du eine Orakel-Tasche anfertigen, in Kunstwirker-Arbeit. So wie das Schulterkleid gearbeitet ist, sollst du sie anfertigen; aus Gold, blauem und rotem Purpur, Karmesin und gezwirntem Byssus sollst du sie anfertigen. ");
INSERT INTO deutkw_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Viereckig soll sie sein, doppelt gelegt, je eine Spanne lang und breit. ");
INSERT INTO deutkw_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Und du sollst sie besetzen mit einem Besatze von Edelsteinen in vier Reihen: ein Carneol, ein Topas und ein Smaragd sollen der Reihe nach die erste Reihe bilden; ");
INSERT INTO deutkw_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","die zweite Reihe ein Karfunkel, ein Sapphir und ein Jaspis; ");
INSERT INTO deutkw_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","die dritte Reihe ein Hyacinth, ein Achat und ein Amethyst; ");
INSERT INTO deutkw_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","die vierte Reihe ein Chrysolith, ein Schoham und ein Onyx; umgeben von Goldgeflecht sollen sie den Besatz bilden. ");
INSERT INTO deutkw_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Und der Steine sollen entsprechend den Namen der Israels-Söhne zwölf sein, entsprechend ihren Namen; in einem jeden soll der Name eines der zwölf Stämme mittels Siegelstecherarbeit eingegraben sein. ");
INSERT INTO deutkw_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Sodann sollst du an der Tasche die schnurenartig gedrehten Kettchen von gediegenem Gold anbringen ");
INSERT INTO deutkw_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","und sollst an der Tasche zwei goldene Ringe anbringen, indem du die beiden Ringe an den beiden Enden der Tasche befestigst. ");
INSERT INTO deutkw_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Hierauf sollst du die beiden goldenen Schnuren an den beiden Ringen an den Enden der Tasche befestigen; ");
INSERT INTO deutkw_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","die beiden Enden der beiden Schnuren aber sollst du an den beiden Geflechten befestigen und diese dann an den Schulterstücken des Schulterkleids auf dessen Vorderseite befestigen. ");
INSERT INTO deutkw_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Ferner sollst du zwei goldene Ringe anfertigen und sie an den beiden Enden der Tasche befestigen, an ihrem inneren, dem Schulterkleide zugewendeten Rand. ");
INSERT INTO deutkw_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Weiter sollst du zwei goldene Ringe anfertigen und sie an den beiden Schulterstücken des Schulterkleids ganz unten an seiner Vorderseite befestigen, da, wo es mit den Schulterstücken zusammenhängt, oberhalb der Binde des Schulterkleids. ");
INSERT INTO deutkw_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Und man soll die Tasche mit ihren Ringen mittels Schnuren von blauem Purpur an die Ringe des Schulterkleids anketten, so daß sie über der Binde des Schulterkleids liegt; so wird die Tasche unbeweglich auf dem Schulterkleid aufliegen. ");
INSERT INTO deutkw_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Und Aaron soll die Namen der Israels-Söhne an der Orakel-Tasche auf seiner Brust tragen, wenn er hineingeht ins Heiligtum, im Angesicht Jahwes, damit er ihrer allezeit gnädig gedenke. ");
INSERT INTO deutkw_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","In die Orakel-Tasche aber sollst du die Urim und die Tummim thun, damit sie auf der Brust Aarons liegen, wenn er hineingeht vor Jahwe, und so soll Aaron das Orakel für die Israeliten beständig vor Jahwe auf seiner Brust tragen. ");
INSERT INTO deutkw_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Und das Obergewand zum Schulterkleide sollst du ganz und gar aus blauem Purpur anfertigen, ");
INSERT INTO deutkw_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","so, daß sich eine Öffnung für den Kopf in ihm befindet. Diese seine Öffnung soll rings von einem angewebten Saume eingefaßt sein; eine Öffnung, wie die eines Panzerhemdes, soll es haben, damit es nicht zerreißt. ");
INSERT INTO deutkw_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","An seinem Saume aber sollst du Granatäpfel aus blauem und rotem Purpur und Karmesin anbringen - an seinem Saume ringsum - und inmitten derselben goldene Glöckchen, ");
INSERT INTO deutkw_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","so, daß immer ein goldenes Glöckchen und ein Granatapfel ringsum am Saume des Obergewands miteinander abwechseln. ");
INSERT INTO deutkw_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Und Aaron soll es tragen, um den heiligen Dienst zu verrichten, und man soll es klingen hören, wenn er hineingeht ins Heiligtum vor Jahwe und wenn er herauskommt, damit er nicht sterbe. ");
INSERT INTO deutkw_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Ferner sollst du ein Stirnblatt von gediegenem Gold anfertigen und darauf in Siegelstecher-Arbeit eingraben: “Geheiligt dem Jahwe”, ");
INSERT INTO deutkw_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","und sollst es an einer Schnur von blauem Purpur befestigen, damit es sich am Kopfbund befinde; an der Vorderseite des Kopfbundes soll es sich befinden. ");
INSERT INTO deutkw_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Es soll aber auf der Stirn Aarons liegen, damit Aaron so die Verfehlungen in betreff der heiligen Dinge - aller der geweihten Gaben, welche die Israeliten darbringen werden - auf sich nehme. Beständig soll es auf seiner Stirn liegen, damit es sie wohlgefällig mache vor Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Den Leibrock aber sollst du aus Byssus würfelförmig gemustert weben und sollst einen Kopfbund aus Byssus anfertigen, sowie einen Gürtel in Buntwirker-Arbeit. ");
INSERT INTO deutkw_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Und für die Söhne Aarons sollst du Leibröcke anfertigen und Gürtel für sie anfertigen und hohe Mützen für sie anfertigen, zur Ehre und zur herrlichen Zier. ");
INSERT INTO deutkw_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Und du sollst Aaron und seine Söhne damit bekleiden und sollst sie salben und ihnen die Hand füllen und sie weihen, damit sie mir Priesterdienst thun. ");
INSERT INTO deutkw_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Und fertige ihnen linnene Beinkleider zur Bedeckung der Schamteile; von den Hüften bis zu den Schenkeln sollen sie reichen. ");
INSERT INTO deutkw_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Und Aaron und seine Söhne sollen sie tragen, wenn sie in das Offenbarungszelt hineingehen und wenn sie an den Altar herantreten, um den Dienst im Heiligtum zu verrichten, damit sie nicht Schuld auf sich laden und sterben müssen. Solches gelte ihm und seinen Nachkommen als eine immerwährende Verpflichtung. ");
INSERT INTO deutkw_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Folgendermaßen sollst du mit ihnen verfahren, um sie zu weihen, damit sie mir Priesterdienst thun. Nimm einen jungen Stier und zwei fehllose Widder, ");
INSERT INTO deutkw_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","ungesäuertes Brot und ungesäuerte, mit Öl gemengte Kuchen, sowie ungesäuerte, mit Öl bestrichene Fladen; aus Weizen-Feinmehl sollst du sie herstellen. ");
INSERT INTO deutkw_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Hierauf sollst du sie in einen Korb thun und sie in dem Korbe darbringen, dazu den Farren und die beiden Widder. ");
INSERT INTO deutkw_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Aaron aber und seine Söhne laß an den Eingang zum Offenbarungszelt herantreten und wasche sie mit Wasser. ");
INSERT INTO deutkw_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Sodann nimm die Kleider, bekleide Aaron mit dem Leibrock, dem Obergewand zum Schulterkleid, dem Schulterkleid und der Tasche und binde ihm die Binde des Schulterkleids um; ");
INSERT INTO deutkw_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","setze ihm den Kopfbund auf das Haupt und befestige das heilige Diadem am Kopfbund. ");
INSERT INTO deutkw_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Sodann nimm das Salböl, gieße es ihm aufs Haupt und salbe ihn so. ");
INSERT INTO deutkw_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Seine Söhne aber laß herzutreten, bekleide sie mit Leibröcken, ");
INSERT INTO deutkw_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","umgürte sie mit einem Gürtel und setze ihnen Mützen auf, damit ihnen das Priesteramt zustehe kraft einer für alle Zeiten geltenden Ordnung. Sodann sollst du Aaron und seinen Söhnen die Hand füllen. ");
INSERT INTO deutkw_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Und zwar sollst du den Farren herzubringen vor das Offenbarungszelt, damit Aaron und seine Söhne auf den Kopf des Farren die Hand aufstemmen. ");
INSERT INTO deutkw_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Sodann schlachte den Farren vor Jahwe, am Eingang zum Offenbarungszelte, ");
INSERT INTO deutkw_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","nimm etwas von dem Blute des Farren und streiche es mit dem Finger an die Hörner des Altars; das ganze übrige Blut aber gieße am Altar auf den Boden. ");
INSERT INTO deutkw_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Sodann nimm alles Fett, welches die Eingeweide bedeckt, und das Anhängsel an der Leber, dazu die beiden Nieren samt dem Fett an ihnen und laß es auf dem Altar in Rauch aufgehn. ");
INSERT INTO deutkw_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Das Fleisch des Farren aber, sein Fell und seinen Mist sollst du außerhalb des Lagers verbrennen - ein Sündopfer ist es. ");
INSERT INTO deutkw_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Sodann bringe den einen Widder, damit Aaron und seine Söhne auf den Kopf des Widders die Hand aufstemmen. ");
INSERT INTO deutkw_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Sodann schlachte den Widder, nimm sein Blut und sprenge es ringsum an den Altar. ");
INSERT INTO deutkw_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Den Widder selbst aber zerlege in seine Teile, wasche seine Eingeweide und seine Beine und lege sie zu seinen übrigen Stücken und zu seinem Kopfe. ");
INSERT INTO deutkw_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Sodann laß den ganzen Widder auf dem Altar in Rauch aufgehn - ein Brandopfer für Jahwe ist es, ein lieblicher Geruch, ein Jahwe dargebrachtes Feueropfer. ");
INSERT INTO deutkw_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Sodann bringe den anderen Widder, damit Aaron und seine Söhne auf den Kopf des Widders die Hand aufstemmen; ");
INSERT INTO deutkw_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","alsdann schlachte den Widder, nimm etwas von seinem Blut und streiche es an das rechte Ohrläppchen Aarons und an das rechte Ohrläppchen seiner Söhne, an ihren rechten Daumen und an ihre rechte große Zehe; das übrige Blut sprenge ringsum an den Altar. ");
INSERT INTO deutkw_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Sodann nimm etwas von dem Blute, das auf dem Altar ist, sowie von dem Salböl und sprenge es auf Aaron und seine Kleider, sowie auf seine Söhne und ihre Kleider, damit er und seine Kleider, sowie seine Söhne und ihre Kleider geheiligt seien. ");
INSERT INTO deutkw_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Sodann nimm von dem Widder das Fett, den Fettschwanz samt dem Fett, welches die Eingeweide bedeckt, das Anhängsel an der Leber und die beiden Nieren samt dem Fett an ihnen, dazu die rechte Keule - denn ein Einsetzungs-Widder ist es -, ");
INSERT INTO deutkw_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","ferner einen Laib Brot, einen mit Öl angemachten Brotkuchen und einen Fladen aus dem Korbe mit dem Ungesäuerten, der vor Jahwe steht, ");
INSERT INTO deutkw_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","und gieb dies alles Aaron und seinen Söhnen in die Hände und webe es als Webe vor Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Sodann nimm es ihnen aus den Händen und laß es auf dem Altar über dem Brandopfer in Rauch aufgehn zum lieblichen Geruch vor Jahwe: ein Jahwe dargebrachtes Feueropfer ist es. ");
INSERT INTO deutkw_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Sodann nimm die Brust von dem Einsetzungs-Widder Aarons und webe sie als Webe vor Jahwe; dann soll sie dir als Anteil zufallen. ");
INSERT INTO deutkw_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","So sollst du die Webebrust, welche gewebt, und die Hebekeule, welche als Hebe weggenommen wurde von dem Einsetzungs-Widder Aarons und seiner Söhne, für etwas Geweihtes erklären; ");
INSERT INTO deutkw_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","sie sollen Aaron und seinen Söhnen zufallen kraft einer den Israeliten für alle Zeit auferlegten Verpflichtung. Denn ein Hebeopfer ist es, und als Hebeopfer soll es von den Israeliten abgegeben werden von ihren Heilsopfern, als ihr Hebeopfer an Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Die heiligen Kleider Aarons aber sollen nachmals auf seine Söhne übergehen, damit man sie darin salbe und ihnen die Hand fülle. ");
INSERT INTO deutkw_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Sieben Tage hindurch soll sie derjenige seiner Söhne anziehen, welcher an seiner Statt Priester wird, der in das Offenbarungszelt hineingehen wird, um den Dienst im Heiligtume zu verrichten. ");
INSERT INTO deutkw_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Den Einsetzungs-Widder aber sollst du nehmen und sein Fleisch an heiliger Stätte kochen. ");
INSERT INTO deutkw_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Und Aaron und seine Söhne sollen das Fleisch des Widders samt dem Brote, welches im Korbe ist, am Eingange zum Offenbarungszelte verzehren. ");
INSERT INTO deutkw_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Das, womit Sühne vollzogen wurde, als man ihnen die Hand füllte und sie weihte, sollen sie verzehren; ein Fremder aber darf nicht davon essen, denn es ist heilig. ");
INSERT INTO deutkw_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Und wenn von dem Fleische des Einsetzungsopfers oder von dem Brote etwas übrig bleibt bis zum Morgen, so sollst du das Übriggebliebene mit Feuer verbrennen: es darf nicht gegessen werden, denn es ist heilig. ");
INSERT INTO deutkw_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","So sollst du mit Aaron und seinen Söhnen verfahren, ganz wie ich dir befohlen habe: sieben Tage hindurch sollst du ihnen die Hand füllen ");
INSERT INTO deutkw_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","und sollst für jeden Tag einen Sündopfer-Farren herrichten zum Vollzuge der Sühne und sollst den Altar entsündigen, indem du die Sühnehandlungen an ihm vollziehst, und sollst ihn salben, um ihn zu weihen. ");
INSERT INTO deutkw_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Sieben Tage lang sollst du die Sühnehandlungen an dem Altar vollziehen, um ihn zu weihen; so wird der Altar hochheilig werden: jeder, der den Altar berührt, ist dem Heiligtume verfallen. ");
INSERT INTO deutkw_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Folgendes aber sollst du auf dem Altar herrichten: Tag für Tag zwei einjährige Lämmer als regelmäßiges Brandopfer. ");
INSERT INTO deutkw_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Das eine Lamm sollst du am Morgen herrichten und das andere Lamm sollst du gegen Abend herrichten. ");
INSERT INTO deutkw_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Und ein Zehntel Feinmehl, das mit einem Viertel Hin Öl aus zerstoßenen Oliven gemengt ist, sowie ein Trankopfer, bestehend in einem Viertel Hin Wein, soll zu dem einen Lamme kommen. ");
INSERT INTO deutkw_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Das andere Lamm aber sollst du gegen Abend herrichten - in betreff des Speisopfers und Trankopfers sollst du dabei verfahren, wie am Morgen - zu einem lieblichen Geruch, als eine Jahwe dargebrachte Feuerspeise, ");
INSERT INTO deutkw_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","als euer regelmäßiges Brandopfer von Geschlecht zu Geschlecht, am Eingange zum Offenbarungszelte vor Jahwe, woselbst ich mich dir offenbaren werde, indem ich daselbst mit dir rede. ");
INSERT INTO deutkw_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Und ich werde mich daselbst den Israeliten offenbaren, und es soll geheiligt werden durch meine Herrlichkeit. ");
INSERT INTO deutkw_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","So will ich das Offenbarungszelt und den Altar weihen; auch Aaron und seine Söhne will ich weihen, damit sie mir Priesterdienst thun. ");
INSERT INTO deutkw_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Und ich will unter den Israeliten wohnen und ihr Gott sein; ");
INSERT INTO deutkw_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","so sollen sie dann erkennen, daß ich, Jahwe, ihr Gott bin, der sie weggeführt hat aus Ägypten, um unter ihnen zu wohnen - ich, Jahwe, ihr Gott! ");
INSERT INTO deutkw_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Weiter sollst du einen Altar zum Verbrennen des Räucherwerks anfertigen; aus Akazienholz sollst du ihn anfertigen, ");
INSERT INTO deutkw_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","eine Elle lang und eine Elle breit; viereckig soll er sein und zwei Ellen hoch. Seine Hörner sollen ein Ganzes mit ihm bilden. ");
INSERT INTO deutkw_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Den sollst du mit gediegenem Gold überziehen, seine Platte und seine Wände ringsum, sowie seine Hörner, und sollst einen ringsumlaufenden goldenen Kranz an ihm anbringen. ");
INSERT INTO deutkw_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Unterhalb dieses Kranzes sollst du an seinen beiden Ecken je zwei goldene Ringe anbringen; auf seinen beiden Seiten sollst du sie anbringen, daß sie zur Aufnahme der Stangen dienen, damit man ihn mittels derselben tragen kann. ");
INSERT INTO deutkw_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Die Stangen aber sollst du aus Akazienholz fertigen und mit Gold überziehen. ");
INSERT INTO deutkw_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Und du sollst ihn vor den Vorhang setzen, der sich vor der Lade mit dem Gesetze befindet - vor der Deckplatte, die sich über dem Gesetze befindet, woselbst ich mich dir offenbaren werde. ");
INSERT INTO deutkw_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Und Aaron soll darauf wohlriechendes Räucherwerk verbrennen. Alle Morgen, wenn er die Lampen zurecht macht, soll er es verbrennen; ");
INSERT INTO deutkw_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","auch, wenn er gegen Abend die Lampen aufsteckt, soll es Aaron verbrennen, als regelmäßiges Rauchopfer eurerseits vor Jahwe von Geschlecht zu Geschlecht. ");
INSERT INTO deutkw_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Fremdes Räucherwerk, Brandopfer oder Speisopfer dürft ihr nicht auf ihm darbringen; auch Trankopfer dürft ihr nicht auf ihn ausgießen. ");
INSERT INTO deutkw_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Und Aaron soll einmal im Jahre an seinen Hörnern die Sühne vollziehen; vermittelst des Blutes des Entsündigungs-Sündopfers soll er einmal im Jahre von Geschlecht zu Geschlecht die Sühne an ihm vollziehen - hochheilig ist er dem Jahwe! ");
INSERT INTO deutkw_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Wenn du die Gesamtzahl der Israeliten, soweit sie gemustert werden, aufnimmst, sollen sie Mann für Mann Jahwe ein Lösegeld zur Deckung ihres Lebens geben, wenn man sie mustert, damit nicht eine Plage über sie komme, wenn man sie mustert. ");
INSERT INTO deutkw_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Und zwar soll jeder, der der Musterung unterliegt, einen halben Sekel heiliges Gewicht, den Sekel zu zwanzig Gera gerechnet, entrichten, einen halben Sekel als Hebeopfer für Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Jeder, der der Musterung unterliegt, von zwanzig Jahren an und darüber, soll das Hebeopfer für Jahwe entrichten. ");
INSERT INTO deutkw_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Die Reichen sollen nicht mehr, und die Armen nicht weniger geben, als einen halben Sekel, bei der Entrichtung des Hebeopfers für Jahwe, zur Deckung ihres Lebens. ");
INSERT INTO deutkw_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Und du sollst das Sühngeld von den Israeliten erheben und auf den Dienst am Offenbarungszelte verwenden, damit es den Israeliten ein gnädiges Gedenken bei Jahwe und Deckung ihres Lebens erwirke. ");
INSERT INTO deutkw_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Und Jahwe redete mit Mose also: Fertige ein kupfernes Becken mit einem kupfernen Gestell zum Waschen an, ");
INSERT INTO deutkw_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","stelle es auf zwischen dem Offenbarungszelt und dem Altar und thue Wasser hinein, ");
INSERT INTO deutkw_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","damit sich Aaron und seine Söhne ihre Hände und Füße darin waschen. ");
INSERT INTO deutkw_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Wenn sie hineingehen ins Offenbarungszelt, sollen sie sich abwaschen, damit sie nicht sterben, und ebenso, wenn sie herzutreten zum Altar, um den heiligen Dienst zu verrichten, indem sie Feueropfer für Jahwe in Rauch aufgehen lassen. ");
INSERT INTO deutkw_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Da sollen sie dann ihre Hände und Füße waschen, damit sie nicht sterben, und dies soll ihnen als eine für alle Zeiten geltende Verpflichtung obliegen - für ihn und seine Nachkommen von Geschlecht zu Geschlecht! ");
INSERT INTO deutkw_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Du aber verschaffe dir wohlriechende Stoffe von der besten Sorte, nämlich 500 Sekel vorzüglichsten Balsam, halb so viel wohlriechenden Zimt, also 250 Sekel, ferner 250 Sekel wohlriechenden Kalmus ");
INSERT INTO deutkw_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","und 500 Sekel Cassia, nach heiligem Gewicht, dazu ein Hin Olivenöl, ");
INSERT INTO deutkw_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","und stelle daraus ein heiliges Salböl her, eine würzige Salbe, wie sie der Salbenmischer herstellt, - ein heiliges Salböl soll es sein! ");
INSERT INTO deutkw_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Und du sollst damit salben das Offenbarungszelt und die Lade mit dem Gesetze, ");
INSERT INTO deutkw_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","den Tisch mit allen seinen Geräten, den Leuchter mit seinen Geräten und den Räucheraltar, ");
INSERT INTO deutkw_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","ferner den Brandopferaltar mit allen seinen Geräten und das Becken samt seinem Gestelle. ");
INSERT INTO deutkw_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Und du sollst sie weihen, damit sie hochheilig seien; jeder, der sie berührt, ist dem Heiligtum verfallen. ");
INSERT INTO deutkw_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Auch Aaron und seine Söhne sollst du salben und sie so weihen, damit sie mir Priesterdienst thun. ");
INSERT INTO deutkw_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Den Israeliten aber gebiete folgendes: Als ein mir geheiligtes Salböl soll euch dieses gelten von Geschlecht zu Geschlecht. ");
INSERT INTO deutkw_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Auf keines Menschen Leib darf es gegossen werden, noch dürft ihr welches im gleichen Mischungsverhältnis für euch bereiten: heilig ist es, als heilig soll es euch gelten. ");
INSERT INTO deutkw_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Wenn jemand solches mischt oder etwas davon an einen Fremden bringt, so soll er hinweggetilgt werden aus seinen Volksgenossen. ");
INSERT INTO deutkw_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Und Jahwe gebot Mose: Verschaffe dir Spezereien: Stakte, Räucherklaue und Galbanum - Spezereien und reinen Weihrauch, alles zu gleichen Teilen, ");
INSERT INTO deutkw_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","und bereite daraus Räucherwerk, eine würzige Mischung, wie sie der Salbenmischer bereitet, mit etwas Salz versetzt, rein, zu heiligem Gebrauche bestimmt. ");
INSERT INTO deutkw_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Und du sollst etwas davon zu feinem Pulver zerreiben und sollst davon in die Nähe des Gesetzes ins Offenbarungszelt bringen, woselbst ich mich dir offenbaren werde; als hochheilig soll es euch gelten. ");
INSERT INTO deutkw_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Für euch aber dürft ihr kein Räucherwerk bereiten nach dem Mischungsverhältnis, wie es bei dem stattfindet, welches du bereiten sollst; als etwas Jahwe Geheiligtes soll es dir gelten. ");
INSERT INTO deutkw_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Sollte jemand seinesgleichen bereiten, um sich an seinem Geruche zu ergötzen, so soll er hinweggetilgt werden aus seinen Volksgenossen. ");
INSERT INTO deutkw_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Merke auf! Ich habe Bezaleel, den Sohn Uris, des Sohnes Hurs, vom Stamme Juda, namentlich berufen und ihn erfüllt mit göttlichem Geiste, ");
INSERT INTO deutkw_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","mit Kunstsinn, Einsicht, Wissen und allerlei Fertigkeiten, ");
INSERT INTO deutkw_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","um Kunstwerke zu ersinnen und in Gold, Silber, Kupfer, ");
INSERT INTO deutkw_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","mittels Verarbeitung von Edelsteinen zum Besetzen und mittels Bearbeitung von Holz auszuführen und so in allen Gattungen zu arbeiten. ");
INSERT INTO deutkw_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Zugleich aber habe ich ihm Oholiab, den Sohn Ahisamachs, vom Stamme Dan beigegeben und habe allen Kunstverständigen künstlerischen Sinn verliehen, damit sie alles, was ich dir befohlen habe, anfertigen: ");
INSERT INTO deutkw_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","das Offenbarungszelt, die Lade für das Gesetz, die Deckplatte darauf und alle zum Zelte gehörenden Geräte; ");
INSERT INTO deutkw_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ferner den Tisch mit seinen Geräten, den Leuchter aus gediegenem Golde mit allen seinen Geräten und den Räucheraltar, ");
INSERT INTO deutkw_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","den Brandopferaltar mit allen seinen Geräten und das Becken mit seinem Gestelle, ");
INSERT INTO deutkw_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","die prachtvoll gewirkten Kleider und die übrigen heiligen Kleider Aarons, des Priesters, sowie die Kleider seiner Söhne zum priesterlichen Dienste, ");
INSERT INTO deutkw_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","das Salböl und das wohlriechende Räucherwerk zum heiligen Gebrauche. Ganz wie ich es dir befohlen habe, sollen sie es anfertigen. ");
INSERT INTO deutkw_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Und Jahwe gebot Mose also: ");
INSERT INTO deutkw_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Du aber befiehl den Israeliten Folgendes: Beobachtet nur ja meine Ruhetage! Denn er ist ein Zeichen zwischen mir und euch von Geschlecht zu Geschlecht, damit man erkenne, daß ich, Jahwe, es bin, der euch heiligt. ");
INSERT INTO deutkw_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Darum sollt ihr den Ruhetag beobachten, denn er muß euch heilig sein; wer immer ihn entweiht, soll mit dem Tode bestraft werden. Denn wenn irgend jemand eine Arbeit an ihm verrichtet, ein solcher soll hinweggetilgt werden mitten aus seinen Volksgenossen. ");
INSERT INTO deutkw_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Sechs Tage hindurch darf Arbeit verrichtet werden, aber der siebente Tag ist ein Jahwe geheiligter Tag unbedingter Ruhe; jeder, der am Sabbattage eine Arbeit verrichtet, soll mit dem Tode bestraft werden. ");
INSERT INTO deutkw_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","So sollen also die Israeliten den Sabbat beobachten, indem sie den Sabbat feiern von Geschlecht zu Geschlecht, kraft einer für alle Zeiten geltenden Verpflichtung. ");
INSERT INTO deutkw_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Für alle Zeiten sei er ein Zeichen zwischen mir und den Israeliten. In sechs Tagen hat Jahwe den Himmel und die Erde gemacht; am siebenten Tag aber ruhte er und atmete auf. ");
INSERT INTO deutkw_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Als er nun das Gespräch mit Mose auf dem Berge Sinai beendet hatte, übergab er ihm die beiden Gesetztafeln, steinerne Tafeln, vom Finger Gottes beschrieben. ");
INSERT INTO deutkw_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Als aber das Volk sah, daß sich die Rückkunft Moses vom Berge verzögerte, scharte sich das Volk um Aaron und forderte ihn auf: Wohlan, schaffe uns einen Gott, der vor uns einherziehe; denn wir wissen nicht, was jenem Manne Mose, der uns aus Ägypten weggeführt hat, zugestoßen ist. ");
INSERT INTO deutkw_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Da sprach Aaron zu ihnen: Reißt die goldenen Ringe ab, die eure Weiber, Söhne und Töchter an den Ohren tragen, und bringt sie mir her. ");
INSERT INTO deutkw_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Da rissen sich alle Leute die goldenen Ringe ab, die sie an den Ohren trugen, und brachten sie Aaron. ");
INSERT INTO deutkw_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Der nahm das Gold von ihnen in Empfang, bearbeitete es mit dem Meißel und machte daraus ein gegossenes Kalb. Da riefen sie: Das ist dein Gott, o Israel, der dich aus Ägypten weggeführt hat! ");
INSERT INTO deutkw_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Als dies Aaron sah, errichtete er vor ihm einen Altar; und Aaron ließ ausrufen: Morgen wird Jahwe ein Fest gefeiert! ");
INSERT INTO deutkw_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Des anderen Tages früh opferten sie Brandopfer und brachten Heilsopfer dar, und das Volk setzte sich hin, um zu essen und zu trinken; dann standen sie auf, um sich zu belustigen. ");
INSERT INTO deutkw_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Da befahl Jahwe Mose: Auf! steige hinab, denn dein Volk, das du aus Ägypten weggeführt hast, handelt verderbt! ");
INSERT INTO deutkw_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Gar schnell sind sie von dem Wege abgewichen, den ich ihnen vorgeschrieben habe; sie haben sich ein gegossenes Kalb gemacht und es angebetet, haben ihm Opfer dargebracht und gerufen: Das ist dein Gott, o Israel, der dich aus Ägypten weggeführt hat! ");
INSERT INTO deutkw_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Und Jahwe sprach zu Mose: Ich sehe nun wohl, daß dieses Volk ein halsstarriges Volk ist. ");
INSERT INTO deutkw_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","So laß mich nun, daß mein Zorn gegen sie entbrenne, und ich sie vernichte; dann will ich dich zum Stammvater eines großen Volkes machen. ");
INSERT INTO deutkw_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Mose aber suchte Jahwe, seinen Gott, zu begütigen, indem er sprach: O Jahwe! Warum bist du so sehr zornig über dein Volk, das du doch mit großer Kraft und starker Hand aus Ägypten weggeführt hast? ");
INSERT INTO deutkw_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Es sollen doch nicht etwa die Ägypter sagen: In schlimmer Absicht hat er sie weggeführt, um sie in den Bergen umzubringen und sie vom Erdboden zu vertilgen? Laß ab von deinem heftigen Zorn und laß dich das Unheil gereuen, das du deinem Volke zugedacht hast. ");
INSERT INTO deutkw_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Gedenke deiner Diener Abraham, Isaak und Israel, denen du bei dir selbst zugeschworen und verheißen hast: Ich will eure Nachkommen so zahlreich werden lassen, wie die Sterne am Himmel, und dieses ganze Land, von dem ich gesprochen habe, will ich euren Nachkommen verleihen, damit sie es auf ewige Zeiten besitzen! ");
INSERT INTO deutkw_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Da ließ sich Jahwe das Unheil gereuen, das er seinem Volke angedroht hatte. ");
INSERT INTO deutkw_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Mose aber machte sich auf den Rückweg und stieg vom Berge hinab, mit den beiden Gesetztafeln in der Hand, - Tafeln, die auf beiden Seiten beschrieben waren; vorn und hinten waren sie beschrieben. ");
INSERT INTO deutkw_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Es waren aber die Tafeln von Gott angefertigt und die Schrift Gottesschrift, eingegraben auf die Tafeln. ");
INSERT INTO deutkw_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Als nun Josua das laute Gelärm des Volkes vernahm, sagte er zu Mose: Es ist Kriegslärm im Lager! ");
INSERT INTO deutkw_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Der aber erwiderte: Das ist kein Geschrei, wie es Sieger, und kein Geschrei, wie es Unterliegende anheben; Gesangestöne höre ich! ");
INSERT INTO deutkw_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Als er nun in die Nähe des Lagers kam und das Kalb, sowie die Reihen der Tanzenden erblickte, da entbrannte der Zorn Moses, so daß er die Tafeln wegwarf und sie am Fuße des Berges zerschmetterte. ");
INSERT INTO deutkw_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Dann nahm er das Kalb, das sie gemacht hatten, verbrannte es und zermalmte es zu feinem Staube; den streute er auf Wasser und gab es den Israeliten zu trinken. ");
INSERT INTO deutkw_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Und zu Aaron sprach Mose: Was haben dir diese Leute gethan, daß du eine so schwere Versündigung über sie gebracht hast? ");
INSERT INTO deutkw_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aaron erwiderte: O Herr! zürne nicht; du weißt es ja selbst, daß das Volk zum Bösen geneigt ist. ");
INSERT INTO deutkw_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Sie baten mich: Mache uns einen Gott, der vor uns einherziehe; denn wir wissen nicht, was jenem Manne Mose, der uns aus Ägypten hierher geführt hat, zugestoßen ist. ");
INSERT INTO deutkw_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Da gebot ich ihnen: Wer Gold trägt, der reiße es sich ab! Da gaben sie es mir, und ich warf es ins Feuer; da wurde dieses Kalb daraus! ");
INSERT INTO deutkw_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Als nun Mose sah, daß das Volk aus Rand und Band gekommen war - denn Aaron hatte ihm die Zügel schießen lassen, zur Schadenfreude seiner Feinde -, ");
INSERT INTO deutkw_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","da trat Mose an das Thor des Lagers und rief: Her zu mir, wer Jahwe angehört! Da sammelten sich um ihn alle Leviten. ");
INSERT INTO deutkw_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Er aber sprach zu ihnen: So spricht Jahwe, der Gott Israels: Gürtet ein jeder sein Schwert um, geht im Lager hin und her, von einem Thore zum andern und schlagt tot, wer es sei, Brüder, Freunde und Verwandte! ");
INSERT INTO deutkw_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Die Leviten aber thaten nach dem Befehle Moses, und so fielen an jenem Tage vom Volk ungefähr dreitausend Mann. ");
INSERT INTO deutkw_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Da sprach Mose: Füllt euch heute die Hand für Jahwe - denn ein jeder war wider seinen Sohn und seinen Bruder -, damit fortan Segen auf euch ruhe! ");
INSERT INTO deutkw_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Des andern Tags aber sprach Mose zu dem Volke: Ihr habt euch sehr schwer versündigt! Ich will daher zu Jahwe hinaufsteigen; vielleicht kann ich euch Verzeihung auswirken für eure Sünde. ");
INSERT INTO deutkw_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Da ging Mose wieder zu Jahwe und sprach: Ach! dieses Volk hat sich sehr schwer versündigt und sich einen Gott aus Gold verfertigt. ");
INSERT INTO deutkw_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Und nun vergieb ihnen doch ihre Sünde! Wo nicht, so streiche mich doch lieber aus dem Buche, das du führst! ");
INSERT INTO deutkw_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Jahwe aber entgegnete Mose: Wer irgend sich gegen mich verfehlt, den streiche ich aus meinem Buche. ");
INSERT INTO deutkw_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Aber gehe jetzt nur hin und führe das Volk dorthin, wohin ich dir geboten habe; mein Engel soll vor dir hergehen. Aber wenn die Zeit der Ahndung für mich da ist, will ich ihre Versündigung ahnden. ");
INSERT INTO deutkw_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Und Jahwe verhängte Unheil über das Volk, weil sie das Kalb verfertigt hatten, welches Aaron verfertigt hatte. ");
INSERT INTO deutkw_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Hierauf sprach Jahwe zu Mose: Wohlan! ziehe nun mit dem Volke, daß du aus Ägypten hierher gebracht hast, von hier hinweg in das Land, das ich Abraham, Isaak und Jakob zugeschworen habe, indem ich verhieß: Euren Nachkommen will ich es verleihen! ");
INSERT INTO deutkw_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Ich will aber einen Engel vor euch einherziehen lassen, um die Kanaaniter, Amoriter, Hethiter, Pheresiter, Heviter und Jebusiter vor euch zu vertreiben, - ");
INSERT INTO deutkw_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","in ein Land, das von Milch und Honig überfließt. Denn ich will nicht in eurer Mitte einherziehen, weil ihr ein halsstarriges Volk seid; sonst würde ich euch unterwegs den Garaus machen. ");
INSERT INTO deutkw_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Als aber das Volk diese schlimmen Worte vernahm, da wurden sie sehr betrübt, und niemand legte seinen Schmuck an. ");
INSERT INTO deutkw_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Da sprach Jahwe zu Mose: Sprich zu den Israeliten: Ihr seid ein halsstarriges Volk! Wenn ich auch nur einen Augenblick in eurer Mitte einherzöge, würde ich euch den Garaus machen. So legt nun euren Schmuck ab; dann will ich zusehen, was ich für euch thun kann. ");
INSERT INTO deutkw_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Da entledigten sich die Israeliten ihres Schmuckes vom Berge Horeb ab. ");
INSERT INTO deutkw_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Mose aber nahm jedesmal das Zelt und schlug es außerhalb des Lagers, etwas entfernt vom Lager, auf und nannte es Offenbarungszelt. Wer irgend Jahwe befragen wollte, der begab sich zu dem Offenbarungszelte hinaus vor das Lager. ");
INSERT INTO deutkw_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","So oft sich nun Mose zu dem Zelte hinaus begab, erhoben sich alle Leute und traten ein jeder unter die Thüre seines Zeltes und blickten Mose nach, bis er zum Zelte gelangt war. ");
INSERT INTO deutkw_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","So oft aber Mose zum Zelte kam, senkte sich die Wolkensäule herab und nahm ihren Platz an der Thüre des Zeltes, und dann redete er mit Mose. ");
INSERT INTO deutkw_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Und alle Leute sahen die Wolkensäule an der Thüre des Zeltes stehen; dann erhoben sich alle Leute und warfen sich ein jeder unter der Thüre seines Zeltes zu Boden. ");
INSERT INTO deutkw_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Jahwe aber redete jedesmal persönlich mit Mose, wie jemand mit seinem Freunde redet; hierauf kehrte er ins Lager zurück, während sein Gehilfe Josua, der Sohn Nuns, als Diener beständig im Innern des Zeltes verweilte. ");
INSERT INTO deutkw_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Hierauf sprach Mose zu Jahwe: Du befiehlst mir freilich: Führe dieses Volk hinweg! hast mir aber nicht kund gethan, wen du mir als Begleiter mitsenden willst. Und du hast ja doch gesagt: Ich kenne dich mit Namen; auch hast du Gnade bei mir gefunden! ");
INSERT INTO deutkw_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Wenn ich nun also Gnade bei dir gefunden habe, so weihe mich ein in deine Pläne und laß mich dich erkennen, damit ich Gnade vor dir finde, und bedenke doch, daß diese Leute dein Volk sind! ");
INSERT INTO deutkw_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Da sprach er: Soll ich in Person mitgehen und dich bis zum Bestimmungsorte bringen? ");
INSERT INTO deutkw_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Er antwortete: Wenn du nicht in Person mitgehst, so führe uns lieber nicht von hier hinweg! ");
INSERT INTO deutkw_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Woran sonst soll erkannt werden, daß ich und dein Volk Gnade vor dir gefunden haben, außer indem du mit uns ziehst, und ich und dein Volk dadurch ausgezeichnet werden vor allen Völkern auf Erden? ");
INSERT INTO deutkw_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Da sprach Jahwe zu Mose: Auch das, was du da erbeten hast, will ich thun; denn du hast Gnade vor mir gefunden und ich kenne dich mit Namen. ");
INSERT INTO deutkw_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Da bat er: Laß mich deine Herrlichkeit schauen! ");
INSERT INTO deutkw_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Er erwiderte: Ich will alle meine Schöne an dir vorüberziehen lassen und den Namen Jahwe vor dir ausrufen und will gnädig sein, wem ich will, und mich erbarmen, wessen ich will. ");
INSERT INTO deutkw_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Hierauf sprach er: Du kannst mein Antlitz nicht schauen; denn kein Mensch bleibt am Leben, wenn er mich sieht! ");
INSERT INTO deutkw_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Sodann sprach Jahwe: Es ist eine Stätte in meiner Nähe, da magst du hintreten auf den Felsen. ");
INSERT INTO deutkw_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Wenn dann meine Herrlichkeit vorüberzieht, so will ich dich in eine Höhlung des Felsens stellen und meine Hand über dich decken, bis ich vorüber bin. ");
INSERT INTO deutkw_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Wenn ich dann meine Hand entferne, so wirst du meine Rückseite sehen; aber mein Antlitz darf niemand schauen! ");
INSERT INTO deutkw_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Da befahl Jahwe Mose: haue dir zwei Steintafeln zurecht, wie die früheren waren; dann will ich auf die Tafeln die Gebote schreiben, die auf den früheren Tafeln standen, welche du zerbrochen hast. ");
INSERT INTO deutkw_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Und sei bereit, morgen in aller Frühe auf den Berg Sinai hinaufzusteigen; dann erwarte mich dort auf der Spitze des Berges. ");
INSERT INTO deutkw_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Es darf aber niemand mit dir hinaufsteigen. Ja es darf sich niemand im Bereiche des ganzen Berges blicken lassen; selbst Schafe und Rinder dürfen nirgends in der Nähe dieses Berges weiden. ");
INSERT INTO deutkw_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Da hieb er zwei Steintafeln aus wie die früheren. Und Mose brach des anderen Tages früh auf und stieg auf den Berg Sinai, wie ihm Jahwe befohlen hatte, und nahm zwei Steintafeln mit sich. ");
INSERT INTO deutkw_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Da fuhr Jahwe in einer Wolke hernieder; er aber stellte sich dort neben ihn und rief den Namen Jahwes an. ");
INSERT INTO deutkw_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Da zog Jahwe an ihm vorüber, indem er rief: Jahwe, Jahwe ist ein barmherziger und gnädiger Gott, langsam zum Zorn und reich an Huld und Treue, ");
INSERT INTO deutkw_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","der Huld bewahrt Tausenden, der Missethat, Übertretung und Sünde vergiebt, aber nicht ganz ungestraft läßt, sondern Väterschuld ahndet an den Kindern und an den Enkeln, am dritten und vierten Gliede. ");
INSERT INTO deutkw_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Da neigte sich Mose eilends bis auf den Boden, warf sich nieder ");
INSERT INTO deutkw_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","und sprach: O Herr, wenn ich irgend Gnade vor dir gefunden habe, so wolle doch mitten unter uns einherziehen! Das Volk ist ja halsstarrig; aber verzeihe uns unsere Missethaten und Sünden und mache uns zu deinem Eigentum! ");
INSERT INTO deutkw_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Er antwortete: Wohlan, ich verordne feierlich im Beisein deines ganzen Volkes: Ich will Wunder thun, wie sie nicht verrichtet worden sind auf der ganzen Erde und unter allen Völkern, und das ganze Volk, inmitten dessen du dich befindest, soll das Thun Jahwes gewahren; denn staunenswert ist, was ich an dir thun werde! ");
INSERT INTO deutkw_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Beobachte, was ich dir heute gebiete. Ich will vor dir vertreiben die Amoriter, die Kanaaniter, die Hethiter, die Pheresiter, die Heviter und die Jebusiter. ");
INSERT INTO deutkw_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Hüte dich davor, mit den Bewohnern des Landes, in welches du kommen wirst, ein Abkommen zu treffen; sie könnten euch sonst, wenn sie mitten unter euch wohnen, zum Fallstricke werden. ");
INSERT INTO deutkw_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Vielmehr sollt ihr ihre Altäre zerstören, ihre Malsteine zertrümmern und ihre heiligen Bäume umhauen. ");
INSERT INTO deutkw_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Aber du sollst dich vor keinem anderen Gotte niederwerfen. Denn Jahwe heißt eifersüchtig; ein eifersüchtiger Gott ist er. ");
INSERT INTO deutkw_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Wenn du ein Abkommen mit den Bewohnern des Landes triffst, und sie mit ihren Göttern Abgötterei treiben und ihren Göttern Opfer bringen und dich dazu einladen, so lauft ihr Gefahr, von ihrer Opfergabe zu essen. ");
INSERT INTO deutkw_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Auch würdet ihr ihre Töchter für eure Söhne freien; wenn dann ihre Töchter ihren Göttern dienend Abgötterei trieben, so würden sie auch deine Söhne zu der gleichen Abgötterei verführen. ");
INSERT INTO deutkw_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Du sollst dir nicht ein gegossenes Gottesbild machen. ");
INSERT INTO deutkw_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Das Fest der ungesäuerten Brote sollst du halten; sieben Tage hindurch sollst du ungesäuerte Brote essen, wie ich dir befohlen habe, zur Zeit des Monats Abib; denn im Monat Abib bist du aus Ägypten weggezoggen. ");
INSERT INTO deutkw_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Alle Erstgeburt gehört mir; ebenso all' dein Vieh, soweit es männlich ist, - der erste Wurf von Rindern und Schafen. ");
INSERT INTO deutkw_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Den ersten Wurf eines Esels aber sollst du mit einem Schaf auslösen und wenn du ihn nicht auslösen willst, so mußt du ihm das Genick brechen. Alle Erstgeburt unter deinen Söhnen sollst du auslösen; und vor mir soll man nicht mit leeren Händen erscheinen. ");
INSERT INTO deutkw_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Sechs Tage hindurch magst du arbeiten, aber am siebenten Tage sollst du ruhen; selbst während der Zeit des Pflügens und Erntens sollst du ruhen. ");
INSERT INTO deutkw_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Und das Wochenfest sollst du halten, das Fest der Erstlinge der Weizenernte und das Fest des Einherbstens bei der Wende des Jahres. ");
INSERT INTO deutkw_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Dreimal im Jahre soll alles, was männlich unter euch ist, vor dem Herrn, Jahwe, dem Gott Israels erscheinen. ");
INSERT INTO deutkw_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Denn ich will dir zuliebe Völker ihres Besitzes berauben und deinem Gebiete eine weite Ausdehnung geben; aber niemand soll sich gelüsten lassen nach deinem Lande, während du hinziehst, um vor Jahwe, deinem Gotte, zu erscheinen, dreimal im Jahre. ");
INSERT INTO deutkw_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Du sollst das Blut meiner Opfer nicht zu gesäuertem Brote schlachten, und das Opferfleich des Passahfestes soll nicht bis zum andern Morgen aufbehalten werden. ");
INSERT INTO deutkw_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Die Erstlinge von den ersten Früchten deines Bodens sollst du zum Hause Jahwes, deines Gottes, bringen. Du sollst ein Böckchen nicht in der Milch seiner Mutter kochen. ");
INSERT INTO deutkw_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Und Jahwe befahl Mose: Schreibe dir diese Gebote auf; denn auf Grund dieser Gebote schließe ich mit dir und mit Israel einen Bund. ");
INSERT INTO deutkw_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Er verweilte aber dort bei Jahwe vierzig Tage und vierzig Nächte, ohne Speise und Trank zu sich zu nehmen. Da schrieb er die Bundesgebote, die zehn Gebote, auf die Tafeln. ");
INSERT INTO deutkw_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Als aber Mose vom Berge Sinai herabstieg mit den beiden Gesetztafeln in der Hand, - als er vom Berge herabstieg, wußte Mose nicht, daß die Haut seines Antlitzes glänzend geworden war infolge seiner Unterredung mit ihm. ");
INSERT INTO deutkw_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Als nun Aaron und alle Israeliten an Mose wahrnahmen, daß die Haut seines Antlitzes glänzte, fürchteten sie sich, ihm nahe zu kommen. ");
INSERT INTO deutkw_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Mose aber rief ihnen zu; da wandten sie sich ihm wieder zu, sowohl Aaron, als alle Fürsten in der Gemeinde. Und Mose redete mit ihnen. ");
INSERT INTO deutkw_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Darnach traten alle übrigen Israeliten heran. Da trug er ihnen alle Gebote vor, welche ihm Jahwe auf dem Berge Sinai anbefohlen hatte. ");
INSERT INTO deutkw_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Als aber Mose seine Unterredung mit ihnen beendigt hatte, legte er eine Hülle auf sein Antlitz. ");
INSERT INTO deutkw_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Jedesmal wenn Mose vor Jahwe trat, um mit ihm zu reden, entfernte er die Hülle, bis er wieder herauskam. Und jedesmal wenn er herauskam, richtete er den Israeliten aus, was ihm aufgetragen worden war. ");
INSERT INTO deutkw_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Da sahen dann jedesmal die Israeliten, daß die Haut des Antlitzes Moses glänzte. Dann legte Mose die Hülle wieder auf sein Antlitz, bis er hineinging, mit ihm zu reden. ");
INSERT INTO deutkw_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Hierauf versammelte Mose die ganze Gemeinde der Israeliten und sprach zu ihnen: Dies ist's, was Jahwe zu thun befohlen hat: ");
INSERT INTO deutkw_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Sechs Tage hindurch darf Arbeit verrichtet werden, den siebenten Tag aber sollt ihr heilig halten als einen Jahwe geweihten Tag unbedingter Ruhe. Jeder, der eine Arbeit an ihm verrichtet, soll getötet werden. ");
INSERT INTO deutkw_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Am Sabbattage dürft ihr kein Feuer anzünden in allen euren Wohnungen. ");
INSERT INTO deutkw_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Da gebot Mose der ganzen Gemeinde der Israeliten also: Dies ist's, was Jahwe befohlen hat: ");
INSERT INTO deutkw_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Liefert von eurem Besitz eine Beisteuer für Jahwe! Jeder, den sein Herz dazu treibt, möge sie bringen, die Beisteuer für Jahwe: Gold, Silber, Kupfer, ");
INSERT INTO deutkw_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","blauen und roten Purpur, Karmesin, Byssus und Ziegenhaar, ");
INSERT INTO deutkw_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","rotgefärbte Widderfelle, Seekuhfelle und Akazienholz, ");
INSERT INTO deutkw_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","Öl für den Leuchter, sowie Spezereien zum Salböl und zum wohlriechenden Räucherwerk, ");
INSERT INTO deutkw_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","Schohamsteine und Edelsteine zum Besetzen des Schulterkleids und der Tasche. ");
INSERT INTO deutkw_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Und alle, die kunstverständig sind unter euch, mögen kommen und alles das verfertigen, was Jahwe gefordert hat: ");
INSERT INTO deutkw_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","die Wohnung mit ihren Zeltwänden und ihrer Decke, ihren Haken, Brettern, Riegeln, Säulen und Füßen, ");
INSERT INTO deutkw_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","die Lade mit ihren Stangen, die Deckplatte und den verhüllenden Vorhang; ");
INSERT INTO deutkw_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","den Tisch mit seinen Stangen und allen seinen Geräten und den Schaubroten, ");
INSERT INTO deutkw_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","den Leuchter mit seinen Geräten und seinen Lampen und das Öl für den Leuchter, ");
INSERT INTO deutkw_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","den Räucheraltar mit seinen Stangen, das Salböl, das wohlriechende Räucherwerk und den Thürvorhang für die Thüre der Wohnung, ");
INSERT INTO deutkw_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","den Brandopferaltar mit seinem kupfernen Gitterwerk, seinen Stangen und allen seinen Geräten, das Becken mit seinem Gestelle, ");
INSERT INTO deutkw_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","die Umhänge des Vorhofs, seine Säulen samt ihren Füßen, sowie den Vorhang für das Thor des Vorhofs, ");
INSERT INTO deutkw_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","die Pflöcke zur Befestigung der Wohnung und die Pflöcke zur Befestigung des Vorhofs samt den zugehörigen Stricken, ");
INSERT INTO deutkw_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","die prachtvoll gewirkten Kleider für den Dienst im Heiligtume, die heiligen Kleider für Aaron, den Priester, und die Kleider seiner Söhne zum priesterlichen Dienst. ");
INSERT INTO deutkw_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Hierauf ging die ganze Gemeinde der Israeliten von Mose hinweg. ");
INSERT INTO deutkw_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Sodann aber kam ein jeder, den sein Herz dazu trieb, und jeder, der dazu willig war, und brachte die Beisteuer für Jahwe zur Anfertigung des Offenbarungszeltes und für den gesamten Dienst in ihm und zu den heiligen Kleidern. ");
INSERT INTO deutkw_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Und zwar brachten sowohl Männer als Frauen: alle, die ihr Herz dazu trieb, brachten Spangen, Ohrringe, Fingerringe und Geschmeide, allerlei goldene Schmucksachen; dazu alle die, welche Jahwe eine Gabe an Gold zu weihen beschlossen hatten. ");
INSERT INTO deutkw_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Und alle die, welche blauen und roten Purpur, Karmesin, Byssus und Ziegenhaar, rotgefärbte Widderfelle und Seekuhfelle besaßen, die brachten sie herbei. ");
INSERT INTO deutkw_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Alle die, welche eine Beisteuer an Silber und Kupfer liefern wollten, brachten die Beisteuer für Jahwe herbei; und alle die, welche Akazienholz besaßen, wie es allenthalben bei der Anfertigung zu verwenden war, die brachten es. ");
INSERT INTO deutkw_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Und alle kunstverständigen Frauen spannen eigenhändig und brachten das Gespinst: blauen und roten Purpur, Karmesin und Byssus. ");
INSERT INTO deutkw_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Und alle Frauen, die sich vermöge ihrer Kunstfertigkeit dazu getrieben fühlten, spannen Ziegenhaar. ");
INSERT INTO deutkw_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Die Fürsten aber brachten die Schohamsteine und die Edelsteine zum Besetzen des Schulterkleids und der Tasche, ");
INSERT INTO deutkw_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","dazu die Spezereien und das Öl für den Leuchter und zum Salböl und zum wohlriechenden Räucherwerk. ");
INSERT INTO deutkw_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Alle Männer und Frauen, die sich angetrieben fühlten, für alle die Arbeiten, deren Anfertigung Jahwe durch Mose befohlen hatte, Gaben zu bringen, - als freiwillige Spende an Jahwe brachten die Israeliten ihre Gaben. ");
INSERT INTO deutkw_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Mose aber sprach zu den Israeliten: Merket auf! Jahwe hat Bezaleel, den Sohn Uris, des Sohnes Hurs, vom Stamme Juda, namentlich berufen ");
INSERT INTO deutkw_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","und ihn erfüllt mit göttlichem Geiste, mit Kunstsinn, Einsicht, Wissen und allerlei Kunstfertigkeiten, ");
INSERT INTO deutkw_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","um Kunstwerke zu ersinnen und in Gold, Silber und Kupfer, ");
INSERT INTO deutkw_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","sowie mittels Bearbeitung von Edelsteinen zum Besetzen und mittels Bearbeitung von Holz auszuführen und so in allen Gattungen von Kunstwerken zu arbeiten. ");
INSERT INTO deutkw_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Aber auch die Gabe der Unterweisung hat er ihm verliehen, ihm und Oholiab, dem Sohne Ahisamachs vom Stamme Dan. ");
INSERT INTO deutkw_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Er hat sie erfüllt mit Kunstsinn, allerlei Arbeiten auszuführen, wie sie der Schmied und der Zimmermann, der Kunstweber, der Buntwirker in blauem und rotem Purpur, Karmesin und Byssus, sowie der Weber fertigt, indem sie alle Arbeiten ausführen und Kunstwerke ersinnen. ");
INSERT INTO deutkw_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","So sollen nun Bezaleel, Oholiab und alle Kunstverständigen, denen Jahwe Kunstsinn und Einsicht verliehen hat, so daß sie sich auf die Ausführung verstehen, alle zur Anfertigung des Heiligtums nötigen Arbeiten ausführen. ");
INSERT INTO deutkw_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Hierauf berief Mose Bezaleel, Oholiab und alle Kunstverständigen, denen Jahwe Kunstsinn verliehen hatte, alle, die sich angetrieben fühlten, ans Werk zu gehen, um es auszuführen. ");
INSERT INTO deutkw_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Und sie empfingen von Mose die gesamte Beisteuer, welche die Israeliten zur Ausführung der Arbeiten behufs Anfertigung des Heiligtums gebracht hatten. Diese brachten ihm aber nach wir vor an jedem Morgen freiwillige Gaben. ");
INSERT INTO deutkw_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Da verließen alle Künstler, welche mit allen den Arbeiten für das Heiligtum beschäftigt waren, Mann für Mann die Arbeit, mit der sie gerade beschäftigt waren, ");
INSERT INTO deutkw_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","und sprachen zu Mose: Das Volk bringt viel mehr, als zur Anfertigung der Arbeiten, deren Ausführung Jahwe befohlen hat, erforderlich ist! ");
INSERT INTO deutkw_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Da ließ Mose im Lager den Befehl verbreiten: Niemand, es sei Mann oder Weib, soll fortan noch etwas anfertigen als Beisteuer für das Heiligtum! So wurde dem Volke gewehrt, Gaben zu bringen. ");
INSERT INTO deutkw_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Denn es war genug, ja übergenug Stoff für sie da, um alle Arbeiten auszuführen. ");
INSERT INTO deutkw_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","So verfertigten denn alle Kunstverständigen unter den bei dem Werke Beschäftigten die Wohnung aus zehn Teppichen. Aus gezwirntem Byssus, blauem und rotem Purpur und Karmesin, mit Keruben, wie sie der Kunstwirker macht, verfertigte er sie, ");
INSERT INTO deutkw_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","jeden Teppich 28 Ellen lang und 4 Ellen breit; alle Teppiche hatten einerlei Maß. ");
INSERT INTO deutkw_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Je fünf Teppiche fügte er aneinander; ");
INSERT INTO deutkw_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","hierauf brachte er am Saume des äußersten Teppichs der einen Fläche Schleifen von blauem Purpur an, und ebenso am Saume des äußersten Teppichs der anderen Fläche. ");
INSERT INTO deutkw_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Fünfzig Schleifen brachte er an dem einen Teppich an und fünfzig Schleifen brachte er am Rande des Teppichs an, der zu der anderen Fläche gehörte, so, daß die Schleifen einander gegenüber standen. ");
INSERT INTO deutkw_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Sodann fertigte er fünfzig goldene Haken an und fügte die Teppiche mittels der Haken zusammen, so daß die Wohnung ein Ganzes wurde. ");
INSERT INTO deutkw_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Weiter fertigte er Teppiche aus Ziegenhaar, zum Zeltdach über der Wohnung. Elf Teppiche fertigte er dazu an, ");
INSERT INTO deutkw_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","jeden Teppich dreißig Ellen lang und vier Ellen breit; alle elf Teppiche hatten einerlei Maß. ");
INSERT INTO deutkw_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Fünf von diesen Teppichen verband er zu einem Ganzen für sich und ebenso die sechs anderen für sich. ");
INSERT INTO deutkw_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Sodann brachte er am Saume des äußersten Teppichs der einen Fläche fünfzig Schleifen an und ebenso fünfzig Schleifen am Saume des äußersten Teppichs der anderen Fläche. ");
INSERT INTO deutkw_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Hierauf fertigte er fünfzig kupferne Haken an, um das Zeltdach zusammenzufügen, so daß es ein Ganzes wurde. ");
INSERT INTO deutkw_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Sodann fertigte er aus rotgefärbten Widderfellen eine Überdecke für das Zeltdach an und oben darüber eine Überdecke von Seekuhfellen. ");
INSERT INTO deutkw_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Sodann fertigte er die Bretter zur Wohnung an, aufrechtstehende, von Akazienholz, ");
INSERT INTO deutkw_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","jedes Brett zehn Ellen lang und anderthalbe Elle breit, ");
INSERT INTO deutkw_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","jedes Brett mit zwei untereinander verbundenen Zapfen; in dieser Weise fertigte er alle Bretter der Wohnung an. ");
INSERT INTO deutkw_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Und zwar fertigte er an Brettern für die Wohnung an: zwanzig Bretter für die nach Süden gewendete Seite - ");
INSERT INTO deutkw_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","unter den zwanzig Brettern aber brachte er vierzig silberne Füße an, je zwei Füße unter jedem Brette für die beiden Zapfen desselben -, ");
INSERT INTO deutkw_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","ebenso für die andere Seite der Wohnung, in der Richtung nach Norden, zwanzig Bretter ");
INSERT INTO deutkw_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","mit ihren vierzig silbernen Füßen, je zwei Füßen unter jedem Brette. ");
INSERT INTO deutkw_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Für die nach Westen gerichtete Seite der Wohnung aber fertigte er sechs Bretter an. ");
INSERT INTO deutkw_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Und zwei Bretter fertigte er für die Winkel der Wohnung auf der Hinterseite. ");
INSERT INTO deutkw_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Und sie waren doppelt im unteren Teil und ebenso waren sie doppelt am oberen Ende für den einen Ring. So verfuhr er mit beiden in den beiden Winkeln; ");
INSERT INTO deutkw_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","somit waren es acht Bretter mit ihren silbernen Füßen - sechzehn Füßen, je zwei Füßen unter jedem Brette. ");
INSERT INTO deutkw_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Weiter fertigte er fünf Riegel aus Akazienholz an für die Bretter der einen Seite der Wohnung, ");
INSERT INTO deutkw_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","fünf Riegel für die Bretter der anderen Seite der Wohnung und fünf Riegel für die Bretter der nach Westen gerichteten Hinterseite der Wohnung. ");
INSERT INTO deutkw_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Den mittelsten Riegel aber ließ er in der Mitte der Bretter quer durchlaufen von einem Ende bis zum anderen. ");
INSERT INTO deutkw_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Die Bretter aber überzog er mit Gold; auch die Ringe an ihnen, die zur Aufnahme der Riegel bestimmt waren, fertigte er aus Gold an und überzog auch die Riegel mit Gold. ");
INSERT INTO deutkw_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Sodann fertigte er den Vorhang aus blauem und rotem Purpur, Karmesin und gezwirntem Byssus; in Kunstwirker-Arbeit fertigte der ihn, mit Keruben. ");
INSERT INTO deutkw_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Und er fertigte für ihn vier Säulen von Akazienholz und überzog sie mit Gold; auch ihre Nägel waren aus Gold. Und er goß für sie vier silberne Füße. ");
INSERT INTO deutkw_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Sodann fertigte er einen Vorhang an für die Thüröffnung des Zeltes aus blauem und rotem Purpur, Karmesin und gezwirntem Byssus, in Buntwirkerarbeit, ");
INSERT INTO deutkw_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","nebst den dazu gehörenden fünf Säulen und den Nägeln an denselben; ihre Köpfe und die Ringe an ihnen überzog er mit Gold. Ihre fünf Füße aber fertigte er aus Kupfer. ");
INSERT INTO deutkw_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Weiter fertigte Bezaleel die Lade aus Akazienholz an, zwei und eine halbe Elle lang, anderthalbe Elle breit und anderthalbe Elle hoch. ");
INSERT INTO deutkw_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Und er überzog sie inwendig und auswendig mit gediegenem Gold und brachte einen ringsumlaufenden goldenen Kranz an ihr an. ");
INSERT INTO deutkw_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Sodann goß er für sie vier goldene Ringe für ihre vier Füße, und zwar zwei Ringe auf ihrer einen Seite und zwei Ringe auf ihrer anderen Seite. ");
INSERT INTO deutkw_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Sodann fertigte er Stangen aus Akazienholz und überzog sie mit Gold; ");
INSERT INTO deutkw_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","diese Stangen zog er durch die Ringe an den Seiten der Lade, so daß man die Lade tragen konnte. ");
INSERT INTO deutkw_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Sodann fertigte er eine Deckplatte aus gediegenem Gold an, zwei und eine halbe Elle lang und anderthalbe Elle breit. ");
INSERT INTO deutkw_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Auch fertigte er zwei Kerube aus Gold an; in getriebener Arbeit verfertigte er sie an den beiden Enden der Deckplatte, ");
INSERT INTO deutkw_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","den einen Kerub an dem einen Ende und den anderen Kerub an dem anderen Ende. An der Deckplatte brachte er die Kerube an, an ihren beiden Enden. ");
INSERT INTO deutkw_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Es hielten aber die Kerube ihre Flügel nach oben ausgebreitet, indem sie mit ihren Flügeln die Deckplatte überdeckten, während ihre Gesichter einander zugekehrt waren; gegen die Deckplatte hin waren die Gesichter der Kerube gerichtet. ");
INSERT INTO deutkw_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Sodann fertigte er den Tisch aus Akazienholz an, zwei Ellen lang, eine Elle breit und anderthalbe Elle hoch. ");
INSERT INTO deutkw_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Und er überzog ihn mit gediegenem Gold und brachte einen ringsumlaufenden goldenen Kranz an ihm an. ");
INSERT INTO deutkw_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Sodann brachte er eine in Handbreite ringsumlaufende Leiste an ihm an und an dieser Leiste wiederum einen ringsumlaufenden goldenen Kranz. ");
INSERT INTO deutkw_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Ferner goß er für ihn vier goldene Ringe und befestigte diese Ringe an den vier Ecken seiner vier Füße. ");
INSERT INTO deutkw_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Dicht an der Leiste befanden sich die Ringe zur Aufnahme der Stangen, damit man den Tisch tragen könne. ");
INSERT INTO deutkw_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Die Stangen aber fertigte er aus Akazienholz an und überzog sie mit Gold, damit man den Tisch tragen könne. ");
INSERT INTO deutkw_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Sodann fertigte er die Geräte an, die sich auf dem Tische befinden sollten, die zu ihm gehörenden Schüsseln und Schalen, Becher und Kannen, mit denen das Trankopfer gespendet wird, alles aus gediegenem Golde. ");
INSERT INTO deutkw_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Weiter fertigte er den Leuchter an aus gediegenem Golde. In getriebener Arbeit fertigte er den Leuchter an - sein Fußgestell und seinen Schaft; die dazu gehörenden Blumenkelche - Knollen mit Blüten - befanden sich an ihm. ");
INSERT INTO deutkw_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Von seinen Seiten aber gingen sechs Röhren aus, je drei auf jeder Seite des Leuchters. ");
INSERT INTO deutkw_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","An jeder Röhre befanden sich drei mandelblütenförmige Blumenkelche - je ein Knollen mit Blüte; so an allen sechs Röhren, die von dem Leuchter ausgingen. ");
INSERT INTO deutkw_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Am Leuchter aber befanden sich vier Blumenkelche, mandelblütenförmig mit den zugehörigen Knollen und Blüten, ");
INSERT INTO deutkw_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","und zwar jedesmal ein Knollen unter jedem der drei Röhrenpaare an ihm, - der sechs Röhren, die von ihm ausgingen. ");
INSERT INTO deutkw_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Ihre Knollen und Röhren waren aus einem Stücke mit ihm, alles getriebene Arbeit aus einem Stücke, von gediegenem Golde. ");
INSERT INTO deutkw_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Sodann fertigte er die sieben Lampen an, die zu ihm gehörten, nebst den zu ihm gehörenden Lichtscheren und Pfannen, aus gediegenem Golde. ");
INSERT INTO deutkw_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Ein Talent gediegenen Goldes verwendete er auf ihn und die zu ihm gehörenden Geräte. ");
INSERT INTO deutkw_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Sodann fertigte er den Räucheraltar aus Akazienholz an, eine Elle lang und eine Elle breit, viereckig und zwei Ellen hoch; seine Hörner bildeten ein Ganzes mit ihm. ");
INSERT INTO deutkw_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Und er überzog ihn mit gediegenem Golde, seine Platte und seine Wände ringsum, sowie seine Hörner, und brachte einen ringsumlaufenden goldenen Kranz an ihm an. ");
INSERT INTO deutkw_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Unterhalb dieses Kranzes aber brachte er an seinen beiden Ecken auf seinen beiden Seiten je zwei goldene Ringe an zur Aufnahme der Stangen, damit man ihn mittels derselben tragen könne. ");
INSERT INTO deutkw_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Die Stangen aber fertigte er aus Akazienholz an und überzog sie mit Gold. ");
INSERT INTO deutkw_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Sodann fertigte er das heilige Salböl und das reine, wohlriechende Räucherwerk an, wie es der Salbenmischer herstellt. ");
INSERT INTO deutkw_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Sodann fertigte er den Brandopferaltar aus Akazienholz an, fünf Ellen lang und fünf Ellen breit, viereckig und drei Ellen hoch. ");
INSERT INTO deutkw_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Seine Hörner aber brachte er an seinen vier Ecken an, so, daß seine Hörner ein Ganzes mit ihm bildeten, und überzog ihn mit Kupfer. ");
INSERT INTO deutkw_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Sodann fertigte er alle zum Altar gehörenden Geräte an, die Töpfe, Schaufeln, Becken, Gabeln und Pfannen; alle zu ihm gehörenden Geräte fertigte er aus Kupfer an. ");
INSERT INTO deutkw_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Ferner fertigte er für den Altar ein Gitterwerk an, ein Netzwerk aus Kupfer, unterhalb des um den Altar laufenden Simses bis zu seiner halben Höhe. ");
INSERT INTO deutkw_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Sodann goß er vier Ringe für die vier Ecken des kupfernen Gitterwerks zur Aufnahme der Stangen. ");
INSERT INTO deutkw_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Die Stangen aber fertigte er aus Akazienholz an und überzog sie mit Kupfer; ");
INSERT INTO deutkw_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","sodann zog er die Stangen durch die Ringe an den Seiten des Altars, damit man ihn vermittelst derselben tragen könne. Aus Brettern, so daß er inwendig hohl war, fertigte er ihn an. ");
INSERT INTO deutkw_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Sodann fertigte er das Becken aus Kupfer an und sein Gestelle aus Kupfer - aus den Spiegeln der dienstthuenden Weiber, die am Eingange des Offenbarungszeltes Dienst thaten. ");
INSERT INTO deutkw_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Sodann stellte er den Vorhof her: für die nach Süden gewendete Seite Vorhofumhänge aus gezwirntem Byssus, hundert Ellen lang, ");
INSERT INTO deutkw_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","dazu zwanzig Säulen nebst ihren zwanzig kupfernen Füßen; die Nägel der Säulen und die zugehörigen Ringe waren aus Silber. ");
INSERT INTO deutkw_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Für die Westseite aber Umhänge in der Länge von fünfzig Ellen, dazu zehn Säulen nebst ihren zehn Füßen; die Nägel der Säulen und die zugehörigen Ringe waren aus Silber. ");
INSERT INTO deutkw_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Für die nach Osten gewendete Seite fünfzig Ellen; ");
INSERT INTO deutkw_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Umhänge in der Länge von fünfzehn Ellen für die eine Seite, dazu drei Säulen nebst ihren drei Füßen, ");
INSERT INTO deutkw_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","und ebenso für die andere Seite Umhänge in der Länge von fünfzehn Ellen, dazu drei Säulen nebst ihren drei Füßen, ");
INSERT INTO deutkw_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","und ebenso für die andere Seite Umhänge in der Länge von fünfzehn Ellen, dazu drei Säulen nebst ihren drei Füßen. ");
INSERT INTO deutkw_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Alle Vorhofumhänge ringsum waren aus gezwirntem Byssus, ");
INSERT INTO deutkw_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","die Füße der Säulen aus Kupfer, ihre Nägel aus Silber und der Überzug ihrer Köpfe aus Silber; es waren aber alle Säulen des Vorhofs mit silbernen Ringen versehen. ");
INSERT INTO deutkw_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Der Vorhang aber des Vorhofsthores war Buntwirker-Arbeit aus blauem und rotem Purpur, Karmesin und gezwirntem Byssus, zwanzig Ellen lang und fünf Ellen hoch, entsprechend den Umhängen des Vorhofs. ");
INSERT INTO deutkw_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Die zugehörigen vier Säulen aber nebst ihren vier Füßen waren aus Kupfer, die Nägel daran aus Silber und ebenso der Überzug ihrer Köpfe und die Ringe an ihnen aus Silber. ");
INSERT INTO deutkw_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Alle Pflöcke aber der Wohnung und des Vorhofs ringsum waren aus Kupfer. ");
INSERT INTO deutkw_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Folgendes ist die Berechnung der Kosten der Wohnung, der Wohnung des Gesetzes, welche auf Befehl Moses vorgenommen wurde mittels Dienstleistung der Leviten unter der Leitung Ithamars, des Sohnes Aarons, des Priesters. ");
INSERT INTO deutkw_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bezaleel aber, der Sohn Uris, des Sohnes Hurs aus dem Stamme Juda, fertigte alles an, was Jahwe Mose befohlen hatte, ");
INSERT INTO deutkw_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","und mit ihm Oholiab, der Sohn Ahisamachs vom Stamme Dan, als Schmied und Zimmermann, sowie als Kunstwirker und als Buntwirker in rotem und blauem Purpur, Karmesin und Byssus. ");
INSERT INTO deutkw_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Anlangend das gesamte Gold, das bei der Anfertigung verarbeitet wurde, bei allen Arbeiten zur Anfertigung des Heiligtums, so betrug das als Weihegabe gespendete Gold 29 Talente und 730 Sekel heiliges Gewicht; ");
INSERT INTO deutkw_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","das infolge der Musterung der Gemeinde eingehende Silber 100 Talente und 1775 Sekel heiliges Gewicht, ");
INSERT INTO deutkw_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","je ein Halbsekel, die Hälfte eines Sekels heiliges Gewicht, von jedem Kopfe, von allen, die der Musterung unterlagen, von zwanzig Jahren an und darüber, 603550 Mann. ");
INSERT INTO deutkw_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Die hundert Talente Silber wurden verwendet zum Gießen der Füße des Heiligtums und der Füße des Vorhangs, hundert Talente zu hundert Füßen, zu jedem Fuß ein Talent. ");
INSERT INTO deutkw_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Aus den 1775 Sekeln aber fertigte er Nägel für die Säulen an, überzog ihre Köpfe und versah sie mit Ringen. ");
INSERT INTO deutkw_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Das als Weihegabe gespendete Kupfer betrug siebzig Talente und 2400 Sekel. ");
INSERT INTO deutkw_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Daraus fertigte er die Füße der Thüre des Offenbarungszeltes an, den kupfernen Altar samt dem kupfernen Gitterwerk an ihm und allen Altargeräten, ");
INSERT INTO deutkw_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","dazu die Füße des Vorhofs ringsum und die Füße des Vorhofthores, sowie alle Pflöcke der Wohnung und alle Pflöcke des Vorhofs ringsum. ");
INSERT INTO deutkw_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Aus dem blauen und roten Purpur aber und aus dem Karmesin fertigten sie prachtvoll gewirkte Kleider zum Dienst im Heiligtum; und sie fertigten die heiligen Kleider Aarons, wie Jahwe Mose befohlen hatte. ");
INSERT INTO deutkw_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Und zwar verfertigte er das Schulterkleid aus Gold, blauem und rotem Purpur, Karmesin und gezwirntem Byssus. ");
INSERT INTO deutkw_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Und sie schlugen die Goldplatten breit, so daß er sie in Fäden zerschneiden konnte, um diese mittels Kunstwirker-Arbeit in den blauen Purpur, in den roten Purpur, in den Karmesin und in den Byssus einzuarbeiten. ");
INSERT INTO deutkw_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","An ihm brachen sie mit ihm verbundene Schulterstücke an; an seinen beiden Enden wurde es mit ihnen verbunden. ");
INSERT INTO deutkw_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Die Binde aber, die sich behufs seiner Anlegung an ihm befand, bildete ein Ganzes mit ihm von gleicher Arbeit aus Gold, blauem und rotem Purpur, Karmesin und gezwirntem Byssus, wie Jahwe Mose befohlen hatte. ");
INSERT INTO deutkw_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Sodann richteten sie die Schohamsteine zu, daß sie mit einem Flechtwerke von Golddraht eingefaßt und mittels Siegelstecherkunst graviert waren nach Maßgabe der Namen der Israels-Söhne. ");
INSERT INTO deutkw_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Und er befestigte sie an den Schulterstücken des Schulterkleids als Steine des gnädigen Gedenkens an die Israeliten, wie Jahwe Mose befohlen hatte. ");
INSERT INTO deutkw_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Sodann verfertigte er die Tasche in Kunstwirker-Arbeit, so wie das Schulterkleid gearbeitet war, aus Gold, blauem und rotem Purpur, Karmesin und gezwirntem Byssus. ");
INSERT INTO deutkw_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Viereckig war sie; doppelt gelegt fertigten sie die Tasche, je eine Handbreite lang und breit, doppelt gelegt. ");
INSERT INTO deutkw_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Und sie besetzten sie mit vier Reihen von Edelsteinen: ein Carneol, ein Topas und ein Smaragd bildeten der Reihe nach die erste Reihe; ");
INSERT INTO deutkw_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","die zweite Reihe ein Karfunkel, ein Sapphir und ein Jaspis; ");
INSERT INTO deutkw_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","die dritte Reihe ein Hyacinth, ein Achat und ein Amethyst, ");
INSERT INTO deutkw_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","die vierte Reihe ein Chrysolith, ein Schoham und ein Onyx; umgeben von Goldgeflecht bildeten sie den Besatz. ");
INSERT INTO deutkw_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Es waren aber der Steine entsprechend den Namen der Israels-Söhne ihrer Zwölf, entsprechend ihren Namen, mittels Siegelstecherkunst mit dem Namen je eines der zwölf Stämme versehen. ");
INSERT INTO deutkw_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Sodann brachten sie an der Tasche die schnurenartig gedrehten Kettchen aus gediegenem Gold an. ");
INSERT INTO deutkw_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Weiter verfertigten sie zwei goldene Geflechte und zwei goldene Ringe und befestigten die beiden Ringe an den beiden Enden der Tasche. ");
INSERT INTO deutkw_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Sodann befestigten sie die beiden goldenen Schnuren an den beiden Ringen an den Enden der Tasche. ");
INSERT INTO deutkw_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Die beiden Enden aber der beiden Schnuren befestigten sie an den beiden Geflechten und diese befestigten sie an den beiden Schulterstücken des Schulterkleids auf dessen Vorderseite. ");
INSERT INTO deutkw_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Sodann fertigten sie zwei goldene Ringe an und befestigten sie an den beiden Enden der Tasche, an ihrem inneren, dem Schulterkleide zugewendeten Saume. ");
INSERT INTO deutkw_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Sodann fertigten sie zwei goldene Ringe an und befestigten sie an den beiden Schulterstücken des Schulterkleids ganz unten an seiner Vorderseite, da, wo es mit den Schulterstücken zusammenhängt, oberhalb der Binde des Schulterkleids. ");
INSERT INTO deutkw_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Dann ketteten sie die Tasche mit ihren Ringen mittels Schnuren von blauem Purpur an die Ringe des Schulterkleids an, so daß sie sich oberhalb der Binde des Schulterkleids befand und unbeweglich auf dem Schulterkleid auflag, wie Jahwe Mose befohlen hatte. ");
INSERT INTO deutkw_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Sodann verfertigte er das Obergewand zum Schulterkleid in Weberarbeit, ganz und gar aus blauem Purpur. ");
INSERT INTO deutkw_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Und die Halsöffnung in dem Obergewande glich der Halsöffnung eines Panzerhemdes, mit einem Saume rings um die Öffnung, damit es nicht zerreiße. ");
INSERT INTO deutkw_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Sodann brachten sie am Saume des Obergewands Granatäpfel aus blauem und rotem Purpur, Karmesin und gezwirntem Byssus an, ");
INSERT INTO deutkw_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","fertigten Glöckchen aus gediegenem Gold an und setzten diese Glöckchen zwischen die Granatäpfel hinein, ringsum am Saume des Obergewands zwischen die Granatäpfel hinein, ");
INSERT INTO deutkw_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","so daß immer ein Glöckchen und ein Granatapfel ringsum am Saume des Obergewands miteinander abwechselten, behufs der Verrichtung des Dienstes, wie Jahwe Mose befohlen hatte. ");
INSERT INTO deutkw_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Sodann verfertigten sie die Leibröcke aus Byssus für Aaron und seine Söhne in Weberarbeit, ");
INSERT INTO deutkw_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","dazu den Kopfbund aus Byssus und die turbanartigen Mützen aus Byssus und die linnenen Beinkleider aus gezwirntem Byssus, ");
INSERT INTO deutkw_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","ferner den Gürtel aus gezwirntem Byssus, blauem und rotem Purpur und Karmesin in Buntwirker-Arbeit, wie Jahwe Mose befohlen hatte. ");
INSERT INTO deutkw_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Sodann fertigten sie das Stirnblatt, das heilige Diadem, aus gediegenem Gold und gruben darein mit Siegelstecher-Schrift: “Geheiligt dem Jahwe”. ");
INSERT INTO deutkw_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Und sie befestigten daran eine Schnur von blauem Purpur, um es oben am Kopfbund anzubringen, wie Jahwe Mose befohlen hatte. ");
INSERT INTO deutkw_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","So wurden sämtliche Arbeiten für die Offenbarungszelt-Wohnung vollendet und die Israeliten thaten ganz, wie Jahwe Mose befohlen hatte - so thaten sie. ");
INSERT INTO deutkw_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Und sie brachten die Wohnung zu Mose, das Zelt mit allen seinen Geräten, seinen Haken, Brettern, Riegeln, Säulen und Füßen, ");
INSERT INTO deutkw_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","dazu die Überdecke aus rotgefärbten Widderfellen, die Überdecke aus Seekuhfellen und den verhüllenden Vorhang, ");
INSERT INTO deutkw_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","die Gesetzeslade mit ihren Stangen und der Deckplatte, ");
INSERT INTO deutkw_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","den Tisch mit allen seinen Geräten und den Schaubroten, ");
INSERT INTO deutkw_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","den Leuchter aus gediegenem Golde mit seinen in geordneter Reihe aufgesetzten Lampen und allen seinen Geräten, sowie das Öl für den Leuchter, ");
INSERT INTO deutkw_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","den goldenen Altar, das Salböl, das wohlriechende Räucherwerk und den Vorhang für die Thüre des Zeltes, ");
INSERT INTO deutkw_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","den kupfernen Altar und das kupferne Gitterwerk an ihm, seine Stangen und alle seine Geräte, das Becken samt seinem Gestelle, ");
INSERT INTO deutkw_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","die Umhänge des Vorhofs, seine Säulen und Füße, sowie den Vorhang für das Thor des Vorhofs, seine Seile und Pflöcke, sowie alle Geräte zum Dienst in der Offenbarungszelt-Wohnung, ");
INSERT INTO deutkw_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","die prachtvoll gewirkten Kleider zum Dient im Heiligtum, die heiligen Kleider Aarons, des Priesters, sowie die Kleider seiner Söhne zum priesterlichen Dienste. ");
INSERT INTO deutkw_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Ganz, wie Jahwe Mose befohlen hatte, so führten die Israeliten die gesamte Arbeit aus. ");
INSERT INTO deutkw_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Als aber Mose wahrnahm, daß sie nunmehr die ganze Arbeit ausgeführt hatten - wie Jahwe befohlen hatte, so hatten sie gethan -, da segnete sie Mose. ");
INSERT INTO deutkw_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Und Jahwe gebot Mose also: ");
INSERT INTO deutkw_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","Am zweiten Tage des zweiten Monats sollst du die Offenbarungszelt-Wohnung aufrichten, ");
INSERT INTO deutkw_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","die Gesetzeslade hineinsetzen und die Lade mit dem Vorhang verhüllen; ");
INSERT INTO deutkw_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","sodann sollst du den Tisch hineinbringen und die Schichten darauf zurechtlegen, sollst den Leuchter hineinbringen und ihm seine Lampen aufsetzen. ");
INSERT INTO deutkw_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Den goldenen Räucheraltar aber sollst du vor die Gesetzeslade stellen und den Thürvorhang der Wohnung aufhängen. ");
INSERT INTO deutkw_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Sodann sollst du den Brandopferalter vor der Thüre der Offenbarungszelt-Wohnung aufstellen ");
INSERT INTO deutkw_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","und sollst das Becken zwischen dem Offenbarungszelt und dem Altar aufstellen und Wasser hinein thun. ");
INSERT INTO deutkw_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Weiter sollst du ringsum den Vorhof aufrichten und den Vorhang zum Thore des Vorhofs aufhängen. ");
INSERT INTO deutkw_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Sodann sollst du das Salböl nehmen und die Wohnung samt allem, was sich in ihr befindet, salben und sie so weihen samt allen ihren Geräten, damit sie heilig sei. ");
INSERT INTO deutkw_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Ebenso sollst du den Brandopferaltar samt allen seinen Geräten salben und so den Altar weihen, damit der Altar hochheilig sei. ");
INSERT INTO deutkw_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Ebenso sollst du das Becken mit seinem Gestelle salben und es so weihen. ");
INSERT INTO deutkw_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Sodann sollst du Aaron und seine Söhne herantreten lassen an die Thüre des Offenbarungszeltes und sie mit Wasser waschen ");
INSERT INTO deutkw_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","und sollst Aaron mit den heiligen Kleidern bekleiden, ihn salben und ihn so weihen, daß er mir Priesterdienst thue. ");
INSERT INTO deutkw_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Seine Söhne aber sollst du herantreten lassen und mit Leibröcken bekleiden; ");
INSERT INTO deutkw_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","sodann sollst du sie salben, wie du ihren Vater gesalbt hast, damit sie mir Priesterdienst thun, und kraft ihrer Salbung sollen sie für alle Zeiten Priesterrecht besitzen von Geschlecht zu Geschlecht. ");
INSERT INTO deutkw_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Und Mose that ganz, wie ihm Jahwe befohlen hatte; so that er. ");
INSERT INTO deutkw_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Am zweiten Tage des zweiten Monats im zweiten Jahre wurde die Wohnung aufgerichtet. ");
INSERT INTO deutkw_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Da richtete Mose die Wohnung auf: er stellte ihre Füße hin, setzte die Bretter darauf, fügte die Riegel ein und richtete die Säulen auf. ");
INSERT INTO deutkw_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Er spannte das Zeltdach über der Wohnung aus und legte oben darauf die Überdecke über das Zeltdach, wie Jahwe Mose befohlen hatte. ");
INSERT INTO deutkw_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Sodann nahm er das Gesetz und legte es in die Lade, steckte die Stangen an die Lade und legte die Deckplatte oben auf die Lade. ");
INSERT INTO deutkw_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Hierauf brachte er die Lade hinein in die Wohnung, hängte den verhüllenden Vorhang auf und verhüllte so die Gesetzeslade, wie Jahwe Mose befohlen hatte. ");
INSERT INTO deutkw_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Sodann stellte er den Tisch in das Offenbarungszelt, auf die nach Norden gewendete Seite der Wohnung außerhalb des Vorhangs, ");
INSERT INTO deutkw_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","und legte darauf die Schichten der Brote zurecht vor Jahwe, wie Jahwe Mose befohlen hatte. ");
INSERT INTO deutkw_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Sodann stellte er den Leuchter ins Offenbarungszelt gegenüber dem Tisch, auf die nach Süden gewendete Seite der Wohnung, ");
INSERT INTO deutkw_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","und setzte die Lampen auf vor Jahwe, wie Jahwe Mose befohlen hatte. ");
INSERT INTO deutkw_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Sodann stellte er den goldenen Altar ins Offenbarungszelt vor den Vorhang ");
INSERT INTO deutkw_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","und zündete darauf wohlriechendes Räucherwerk an, wie Jahwe Mose befohlen hatte. ");
INSERT INTO deutkw_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Er hängte den Thürvorhang der Wohnung auf, ");
INSERT INTO deutkw_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","stellte den Brandopferaltar an den Eingang der Offenbarungszelt-Wohnung und opferte darauf das Brandopfer und das Speisopfer, wie Jahwe Mose befohlen hatte. ");
INSERT INTO deutkw_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Er stellte das Becken zwischen das Offenbarungszelt und den Altar und that Wasser hinein zum Waschen, ");
INSERT INTO deutkw_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","und Mose, Aaron und dessen Söhne wuschen sich jedesmal ihre Hände und Füße darin; ");
INSERT INTO deutkw_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","so oft sie ins Offenbarungszelt hineingingen oder an den Altar herantraten, wuschen sie sich, wie Jahwe Mose befohlen hatte. ");
INSERT INTO deutkw_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Sodann richtete er den Vorhof auf rings um die Wohnung und den Altar und hängte den Vorhang des Vorhofthores auf. Als aber Mose mit der Aufrichtung zu Ende gekommen war, ");
INSERT INTO deutkw_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","bedeckte die Wolke das Offenbarungszelt, und die Herrlichkeit Jahwes erfüllte die Wohnung. ");
INSERT INTO deutkw_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Und Mose war nicht imstande, in das Offenbarungszelt hineinzugehen, weil die Wolke darauf lagerte und die Herrlichkeit Jahwes die Wohnung erfüllte. ");
INSERT INTO deutkw_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Und wenn sich die Wolke von der Wohnung hinweg erhob, brachen die Israeliten jedesmal auf während ihres ganzen Zugs. ");
INSERT INTO deutkw_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Erhob sich aber die Wolke nicht, so brachen sie nicht auf, bis sie sich erhob. ");
INSERT INTO deutkw_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Denn tagsüber war die Wolke Jahwes über der Wohnung; des Nachts aber war sie feurig vor den Augen des ganzen Hauses Israel während ihres ganzen Zugs. ");
INSERT INTO deutkw_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Da berief Jahwe Mose und redete zu ihm vom Offenbarungszelte aus wie folgt: ");
INSERT INTO deutkw_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Rede mit den Israeliten und befiehl ihnen: Wenn jemand unter euch Jahwe eine Opfergabe bringen will, so soll die Opfergabe, die ihr bringt, vom Vieh - von den Rindern oder dem Kleinvieh - genommen sein. ");
INSERT INTO deutkw_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Soll seine Opfergabe in einem Rinder-Brandopfer bestehen, so muß es ein männliches fehlloses Tier sein, welches er darbringt. Dieses bringe er hin vor die Thüre des Offenbarungszeltes, damit es ihn wohlgefällig mache vor Jahwe; ");
INSERT INTO deutkw_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","sodann stemme er die Hand auf den Kopf des Brandopfers, so wird es ihn wohlgefällig machen und ihm Sühne schaffen. ");
INSERT INTO deutkw_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Sodann soll er das junge Rind vor Jahwe schlachten; die Söhne Aarons aber, die Priester, sollen das Blut darbringen. Und zwar sollen sie das Blut ringsum an den Altar sprengen, der vor der Thüre des Offenbarungszeltes steht. ");
INSERT INTO deutkw_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Sodann soll er das Brandopfer abhäuten und in seine Teile zerlegen; ");
INSERT INTO deutkw_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","die Söhne Aarons aber, die Priester, sollen Feuer auf den Altar thun und Holzscheite über dem Feuer aufschichten. ");
INSERT INTO deutkw_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Alsdann sollen die Söhne Aarons, die Priester, die Stücke, den Kopf und das Fett auf den Holzscheiten, die über dem Feuer auf dem Altar sind, zurecht legen. ");
INSERT INTO deutkw_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Die Eingeweide aber und die Beine soll man mit Wasser waschen, und der Priester soll alles zusammen auf dem Altar in Rauch aufgehn lassen als Brandopfer, als ein Jahwe dargebrachtes Feueropfer lieblichen Geruchs. ");
INSERT INTO deutkw_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Ist aber die Opfergabe, die er als Brandopfer bringen will, dem Kleinvieh - den Lämmern oder den Ziegen - entnommen, so muß es ein männliches, fehlloses Tier sein, welches er darbringt. ");
INSERT INTO deutkw_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Dieses schlachte er vor Jahwe auf der Nordseite des Altars; die Söhne Aarons aber, die Priester, sollen das Blut ringsum an den Altar sprengen. ");
INSERT INTO deutkw_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Sodann soll er es in seine Teile zerlegen, und der Priester dieselben samt dem Kopf und dem Fett auf den Holzscheiten, die über dem Feuer auf dem Altar sind, zurecht legen. ");
INSERT INTO deutkw_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Die Eingeweide aber und die Beine soll man mit Wasser waschen, und der Priester soll alles zusammen darbringen und auf dem Altar in Rauch aufgehn lassen; ein Brandopfer ist es, ein Jahwe dargebrachtes Feueropfer lieblichen Geruchs. ");
INSERT INTO deutkw_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Soll aber die Opfergabe, die er Jahwe bringen will, in einem Geflügel-Brandopfer bestehen, so müssen es Turteltauben oder junge Tauben sein, die er als Opfergabe darbringt. ");
INSERT INTO deutkw_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Der Priester aber soll es an den Altar bringen, ihm den Kopf einknicken und es auf dem Altar in Rauch aufgehn lassen; das Blut aber ist auszupressen an die Wand des Altars. ");
INSERT INTO deutkw_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Und den Kropf samt den Federn soll er wegnehmen und östlich vom Altar auf den Aschenhaufen werfen. ");
INSERT INTO deutkw_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Alsdann soll er ihm die Flügel einreißen, jedoch ohne sie abzutrennen. Der Priester aber soll es auf dem Altar in Rauch aufgehn lassen, auf den Holzscheiten, die über dem Feuer sind; ein Brandopfer ist es, ein Jahwe dargebrachtes Feueropfer lieblichen Geruchs. ");
INSERT INTO deutkw_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Will jemand Jahwe eine Speisopfergabe darbringen, so muß seine Opfergabe in Feinmehl bestehen; dieses übergieße er mit Öl und thue Weihrauch darauf. ");
INSERT INTO deutkw_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Alsdann bringe er es den Söhnen Aarons, den Priestern; der Priester aber nehme davon eine reichliche Hand voll, von dem Mehl und dem Öl, aus dem es besteht, samt dem ganzen Weihrauch, und lasse diesen Duftteil von ihm auf dem Altar in Rauch aufgehn als ein Jahwe dargebrachtes Feueropfer lieblichen Geruchs. ");
INSERT INTO deutkw_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Alles Übrige aber von dem Speisopfer soll Aaron und seinen Söhnen gehören, als hochheiliger Bestandteil der Feueropfer Jahwes. ");
INSERT INTO deutkw_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Willst du aber im Ofen Gebackenes als Speisopfergabe darbringen, so seien es ungesäuerte Kuchen von Feinmehl, die mit Öl angemacht sind, und ungesäuerte mit Öl bestrichene Fladen. ");
INSERT INTO deutkw_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Soll aber deine Opfergabe in einem Speisopfer auf der Platte bestehen, so muß es aus ungesäuertem, mit Öl angemachtem Feinmehl bereitet sein; ");
INSERT INTO deutkw_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","brich es in einzelne Bissen und übergieße es mit Öl - ein Speisopfer ist es. ");
INSERT INTO deutkw_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Soll aber deine Opfergabe in einem Pfannen-Speisopfer bestehen, so soll es aus Feinmehl mit Öl bereitet werden. ");
INSERT INTO deutkw_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Sodann sollst du das Speisopfer, das daraus bereitet ist, Jahwe hinbringen; und zwar soll man es dem Priester übergeben, damit er es an den Altar bringe. ");
INSERT INTO deutkw_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Es soll aber der Priester von dem Speisopfer den erforderlichen Duftteil hinwegnehmen und auf dem Altar in Rauch aufgehn lassen als ein Jahwe dargebrachtes Feueropfer lieblichen Geruchs. ");
INSERT INTO deutkw_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Alles Übrige aber von dem Speisopfer soll Aaron und seinen Söhnen gehören, als hochheiliger Bestandteil der Feueropfer Jahwes. ");
INSERT INTO deutkw_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Kein Speisopfer, das ihr Jahwe darbringen wollt, darf aus gesäuertem bereitet werden; denn ihr dürft keinerlei Sauerteig oder Honig in Rauch aufgehn lassen als Feueropfer für Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Als Erstlings-Opfergabe mögt ihr sie Jahwe darbringen; auf den Altar aber dürfen sie nicht kommen zum lieblichen Geruch. ");
INSERT INTO deutkw_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Alle deine Speisopfergaben aber mußt du salzen; nie darfst du das Salz des Bundes, den dein Gott angeordnet hat, bei deinem Speisopfer fehlen lassen: zu allen deinen Opfergaben mußt du Salz darbringen. ");
INSERT INTO deutkw_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Willst du aber Jahwe ein Speisopfer von Erstlingsfrüchten darbringen, so mußt du am Feuer geröstete Ähren oder zerriebene Körner von der frischen Frucht als dein Frühfrucht-Speisopfer darbringen. ");
INSERT INTO deutkw_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Du mußt aber Öl darauf thun und Weihrauch darauf legen - ein Speisopfer ist es. ");
INSERT INTO deutkw_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Sodann soll der Priester einen Duftteil von ihm - von den zerriebenen Körnern und dem Öl, woraus es besteht, - samt dem ganzen dazu gehörenden Weihrauch als Feueropfer für Jahwe in Rauch aufgehn lassen. ");
INSERT INTO deutkw_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Ist aber seine Opfergabe ein Heilsopfer, und er will sie von den Rindern darbringen, so muß es ein fehlloses männliches oder weibliches Tier sein, welches er vor Jahwe bringt. ");
INSERT INTO deutkw_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Sodann stemme er die Hand auf den Kopf seines Opfers und schlachte es vor der Thüre des OffenbarungszeItes; die Söhne Aarons aber, die Priester, sollen das Blut ringsum an den Altar sprengen. ");
INSERT INTO deutkw_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Hierauf soll er von dem Heilsopfer Jahwe ein Feueropfer darbringen, nämlich das Fett, das die Eingeweide bedeckt, und alles Fett an den Eingeweiden, ");
INSERT INTO deutkw_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","dazu die beiden Nieren samt dem Fett an ihnen, an den Lendenmuskeln, und das Anhängsel an der Leber; bei den Nieren soll er es wegnehmen. ");
INSERT INTO deutkw_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Die Söhne Aarons aber sollen es auf dem Altar über dem Brandopfer, das auf den Holzscheiten über dem Feuer liegt, in Rauch aufgehn lassen als ein Jahwe dargebrachtes Feueropfer lieblichen Geruchs. ");
INSERT INTO deutkw_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Ist aber die Opfergabe, die er zu einem Heilsopfer für Jahwe bestimmt hat, dem Kleinvieh entnommen, so soll es ein fehlloses männliches oder weibliches Tier sein, welches er darbringt. ");
INSERT INTO deutkw_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Will er ein Lamm als Opfergabe darbringen, so bringe er sie vor Jahwe, ");
INSERT INTO deutkw_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","stemme seine Hand auf den Kopf seine Opfers und schlachte es sodann vor dem Offenbarungszelte; die Söhne Aarons aber sollen das Blut ringsum an den Altar sprengen. ");
INSERT INTO deutkw_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Hierauf soll er von dem Heilsopfer Jahwe ein Feueropfer darbringen, und zwar das Fett desselben: den ganzen Fettschwanz - dicht am Schwanzbein soll er ihn wegnehmen -, dazu das Fett, das die Eingeweide bedeckt, samt allem Fett an den Eingeweiden, ");
INSERT INTO deutkw_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","die beiden Nieren samt dem Fett an ihnen, an den Lendenmuskeln, und das Anhängsel an der Leber; bei den Nieren soll er es wegnehmen. ");
INSERT INTO deutkw_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Und der Priester soll es auf dem AItar in Rauch aufgehn lassen als Feueropferspeise für Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Besteht aber sein Opfer in einer Ziege, so bringe er es vor Jahwe, ");
INSERT INTO deutkw_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","stemme die Hand auf seinen Kopf und schlachte es sodann vor dem Offenbarungszelte; die Söhne Aarons aber sollen das Blut ringsum an den Altar sprengen. ");
INSERT INTO deutkw_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Hierauf bringe er seine Opfergabe davon dar, als Feueropfer für Jahwe, nämlich das Fett, das die Eingeweide bedeckt, und alles Fett an den Eingeweiden, ");
INSERT INTO deutkw_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","die beiden Nieren samt dem Fett an ihnen, an den Lendenmuskeln, und das Anhängsel an der Leber; bei den Nieren soll er es wegnehmen. ");
INSERT INTO deutkw_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Und der Priester soll es auf dem Altar in Rauch aufgehn lassen als eine Jahwe dargebrachte Feueropferspeise lieblichen Geruchs. Alles Fett gehört Jahwe zu! ");
INSERT INTO deutkw_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Das ist eine für alle Zeiten geltende Satzung, die ihr beobachten sollt von Geschlecht zu Geschlecht in allen euren Wohnsitzen: unter keinen Umständen dürft ihr Fett oder Blut genießen! ");
INSERT INTO deutkw_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Und Jahwe sprach zu Mose also: ");
INSERT INTO deutkw_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Rede mit den Israeliten und befiehl ihnen: Wenn sich jemand unvorsätzlich gegen irgend eines der Verbote Jahwes vergeht, so daß er irgend etwas Verbotenes thut: ");
INSERT INTO deutkw_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Wenn sich der gesalbte Priester vergeht, und so Schuld auf das Volk kommt, so soll er für das Vergehen, dessen er sich schuldig gemacht hat, Jahwe einen fehllosen jungen Stier als Sündopfer darbringen. ");
INSERT INTO deutkw_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Und zwar soll er den Farren an die Thüre des Offenbarungszeltes vor Jahwe bringen, die Hand auf den Kopf des Farren aufstemmen und sodann den Farren vor Jahwe schlachten. ");
INSERT INTO deutkw_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Hierauf nehme der gesalbte Priester einen Teil des Blutes des Farren und bringe es hinein ins Offenbarungszelt. ");
INSERT INTO deutkw_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Und der Priester soll seinen Finger in das Blut tauchen und siebenmal etwas von dem Blute vor Jahwe - vor den Vorhang im Heiligtum - hinsprengen. ");
INSERT INTO deutkw_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Sodann soll der Priester etwas von dem Blute an die Hörner des Altars mit dem wohlriechenden Räucherwerk streichen, der vor Jahwe im Offenbarungszelte steht; das ganze übrige Blut des Farren aber soll er am Brandopferaltar, der vor der Thüre des Offenbarungszeltes steht, auf den Boden gießen. ");
INSERT INTO deutkw_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Sodann aber soll er von dem Sündopfer-Farren das ganze Fett abheben - das Fett, welches die Eingeweide bedeckt, und alles Fett an den Eingeweiden, ");
INSERT INTO deutkw_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","die beiden Nieren samt dem Fett an ihnen, an den Lendenmuskeln, sowie das Anhängsel an der Leber; an den Nieren soll er es wegnehmen - ");
INSERT INTO deutkw_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","so, wie es vom Heilsopfer-Stier abgehoben wird. Und der Priester soll es auf dem Brandopferaltar in Rauch aufgehn lassen. ");
INSERT INTO deutkw_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Was aber das Fell des Farren betrifft, sowie sein gesamtes Fleisch nebst seinem Kopf und seinen Beinen, seine Eingeweide und seinen Mist, ");
INSERT INTO deutkw_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","so soll man den ganzen Farren hinaus vor das Lager schaffen an eine reine Stätte - an den Ort, wo man die Asche hinschüttet, - und ihn auf Holzscheiten verbrennen; an dem Orte, wo man die Asche hinschüttet, soll er verbrannt werden. ");
INSERT INTO deutkw_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Wenn sich aber die ganze Gemeinde Israel unvorsätzlich vergeht, ohne daß sich das Volk dessen bewußt wird, und sie irgend eines der Verbote Jahwes übertreten und so in Schuld geraten, ");
INSERT INTO deutkw_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","so soll das Volk, wenn das Vergehen kund geworden ist, dessen sie sich schuldig gemacht haben, einen jungen Stier als Sündopfer darbringen. Und zwar sollen sie ihn vor das Offenbarungszelt bringen; ");
INSERT INTO deutkw_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","die Vornehmsten der Gemeinde sollen vor Jahwe die Hand auf den Kopf des Farren stemmen, und dann soll man den Farren vor Jahwe schlachten. ");
INSERT INTO deutkw_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Hierauf soll der gesalbte Priester einen Teil des Blutes des Farren hinein ins Offenbarungszelt bringen. ");
INSERT INTO deutkw_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Und der Priester soll seinen Finger in das Blut tauchen und siebenmal etwas von dem Blute vor Jahwe - vor den Vorhang - hinsprengen. ");
INSERT INTO deutkw_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Auch soll er etwas von dem Blut an die Hörner des Altars streichen, der vor Jahwe im Offenbarungszelte steht; das ganze übrige Blut aber soll er am Brandopferaltar, der vor der Thüre des Offenbarungszeltes steht, an den Boden gießen. ");
INSERT INTO deutkw_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Das gesamte Fett aber soll er von ihm abheben und auf dem Altar in Rauch aufgehn lassen. ");
INSERT INTO deutkw_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Und mit dem Farren soll er verfahren, wie er mit dem eigenen Sündopfer-Farren verfuhr - so soll er auch mit ihm verfahren. Wenn ihnen so der Priester Sühne geschafft haben wird, wird ihnen vergeben werden. ");
INSERT INTO deutkw_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Den Farren aber soll man hinaus vor das Lager schaffen und ihn verbrennen, wie man den ersterwähnten Stier verbrannt hat. Dies ist das Gemeinde-Sündopfer. ");
INSERT INTO deutkw_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Wenn sich ein Fürst vergeht und unvorsätzlich irgend eines der Verbote Jahwes, seines Gottes, übertritt und so in Schuld gerät, ");
INSERT INTO deutkw_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","und das Vergehen, dessen er sich schuldig gemacht hat, ihm kundgegeben worden ist, so soll er einen fehllosen Ziegenbock als Opfergabe bringen, ");
INSERT INTO deutkw_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","die Hand auf den Kopf des Bockes stemmen und ihn schlachten, da, wo man die Brandopfer vor Jahwe zu schlachten pflegt; ein Sündopfer ist es. ");
INSERT INTO deutkw_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Sodann soll der Priester etwas von dem Blute des Sündopfers mit dem Finger nehmen und an die Hörner des Brandopferaltars streichen; sein übriges Blut aber soll er am Brandopferaltar auf den Boden gießen. ");
INSERT INTO deutkw_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Das gesamte Fett aber soll er auf dem Altar in Rauch aufgehn lassen, wie das Fett des Heilsopfers. Wenn ihm so der Priester Sühne wegen seines Vergehens geschafft haben wird, wird ihm vergeben werden. ");
INSERT INTO deutkw_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Wenn aber einer aus dem gemeinen Volke sich unvorsätzlich vergeht, indem er irgend eines der Verbote Jahwes übertritt und so in Schuld gerät, ");
INSERT INTO deutkw_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","und ihm das Vergehen, dessen er sich schuldig gemacht hat, kundgegeben worden ist, so soll er für das Vergehen, dessen er sich schuldig gemacht hat, ein fehlloses Ziegenweibchen als Opfergabe bringen, ");
INSERT INTO deutkw_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","die Hand auf den Kopf des Sündopfers stemmen und sodann das Sündopfer schlachten, da, wo man die Brandopfer zu schlachten pflegt. ");
INSERT INTO deutkw_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Hierauf soll der Priester etwas von dem Blute mit dem Finger nehmen und an die Hörner des Brandopferaltars streichen; das ganze übrige Blut aber soll er am Altar auf den Boden gießen. ");
INSERT INTO deutkw_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Das gesamte Fett aber soll er hinwegnehmen, wie das Fett vom Heilsopfer weggenommen wurde, und der Priester soll es auf dem Altar in Rauch aufgehn lassen zum lieblichen Geruch für Jahwe. Wenn ihm so der Priester Sühne geschafft haben wird, wird ihm vergeben werden. ");
INSERT INTO deutkw_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Falls aber die Opfergabe, die er als Sündopfer bringt, in einem Schaflamm besteht, so muß es ein weibliches fehlloses Tier sein, das er bringt. ");
INSERT INTO deutkw_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Sodann soll er die Hand auf den Kopf des Sündopfers stemmen und es schlachten als Sündopfer, da, wo man die Brandopfer zu schlachten pflegt. ");
INSERT INTO deutkw_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Hierauf soll der Priester etwas von dem Blute des Sündopfers mit dem Finger nehmen und an die Hörner des Brandopferaltars streichen; das ganze übrige Blut aber soll er am Altar auf den Boden gießen. ");
INSERT INTO deutkw_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Das gesamte Fett aber soll er wegnehmen, wie das Fett des Schaflamms beim Heilsopfer weggenommen zu werden pflegt, und der Priester soll es auf dem Altar über den Feueropfern Jahwes in Rauch aufgehn lassen. Wenn ihm so der Priester Sühne geschafft haben wird wegen des Vergehens, dessen er sich schuldig gemacht hatte, wird ihm vergeben werden. ");
INSERT INTO deutkw_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Wenn sich jemand vergeht, indem er eine laut ausgesprochene Verwünschung anhört und könnte Zeuge sein, mag er nun den Thäter gesehen oder sonst in Erfahrung gebracht haben, hat aber keine Anzeige gemacht und so Schuld auf sich geladen, - ");
INSERT INTO deutkw_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","oder wenn jemand irgend etwas Unreines berührt, sei es nun das Aas eines unreinen wilden Tiers oder das Aas eines unreinen Haustiers; oder das Aas eines unreinen Gewürms, ohne daß er sich dessen bewußt wird, es aber nachher inne wird und in Schuld gerät, - ");
INSERT INTO deutkw_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","oder wenn er mit der Unreinigkeit an einem Menschen in Berührung kommt, mit irgend welcher Unreinigkeit, infolge derer einer unrein sein kann, ohne daß er sich dessen bewußt wird, es aber nachher inne wird und in Schuld gerät, - ");
INSERT INTO deutkw_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","oder wenn jemand Ieichtfertigerweise schwört, daß er irgend etwas thun wolle, worauf man etwa leichtfertigerweise einen Schwur setzt, ohne daß er sich dessen bewußt wird, es aber nachher inne wird und durch irgend etwas Derartiges in Schuld gerät, ");
INSERT INTO deutkw_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","so soll er, wenn er durch irgend etwas Derartiges in Schuld gerät, bekennen, wessen er sich schuldig gemacht hat. ");
INSERT INTO deutkw_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Sodann soll er Jahwe als Buße für das Vergehen, dessen er sich schuldig gemacht hat, ein Stück Kleinvieh, und zwar ein Weibchen, es sei ein Schaf oder eine Ziege, zum Sündopfer bringen, und der Priester soll ihm wegen seines Vergehens Sühne schaffen. ");
INSERT INTO deutkw_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Wenn er aber zur Beschaffung eines Schafs zu arm ist, so soll er Jahwe als Buße für sein Vergehen zwei Turteltauben oder zwei junge Tauben bringen, die eine als Sündopfer, die andere als Brandopfer. ");
INSERT INTO deutkw_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Und zwar soll er sie zum Priester bringen; dieser soll die zum Sündopfer bestimmte zuerst darbringen. Er soll ihr dicht vor dem Genick den Kopf einknicken, ohne ihn abzutrennen. ");
INSERT INTO deutkw_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Sodann soll er etwas von dem Blute des Sündopfers an die Wand des Altars sprengen. Der Rest des Blutes aber soll auf den Grund des Altars ausgedrückt werden; ein Sündopfer ist es. ");
INSERT INTO deutkw_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Die andere aber soll er zum Brandopfer herrichten, so, wie es sich gebührt. Wenn ihm so der Priester Sühne geschafft haben wird wegen des Vergehens, dessen er sich schuldig gemacht hat, wird ihm vergeben werden. ");
INSERT INTO deutkw_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Wenn er aber zur Beschaffung zweier Turteltauben oder zweier junger Tauben zu arm ist, so soll er als Opfergabe für sein Vergehen ein Zehntel Epha Feinmehl zum Sündopfer bringen, doch ohne Öl darauf zu schütten oder Weihrauch darauf zu thun, denn es ist ein Sündopfer. ");
INSERT INTO deutkw_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Und er soll es zum Priester bringen. Der Priester aber soll eine reichliche Hand voll davon nehmen, als Duftteil von ihm, und soll es auf dem Altar über den Feueropfern Jahwes in Rauch aufgehn lassen; ein Sündopfer ist es. ");
INSERT INTO deutkw_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Wenn ihm so der Priester Sühne geschafft haben wird wegen des Vergehens, dessen er sich bei irgend einem jener Anlässe schuldig gemacht hat, wird ihm vergeben werden. Es soll aber wie das Speisopfer dem Priester gehören. ");
INSERT INTO deutkw_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Wenn jemand etwas veruntreut und sich unvorsätzlich an dem vergreift, was Jahwe geheiligt ist, so soll er Jahwe als Buße einen fehllosen Widder aus seiner Klienvieh-Herde, der nach deiner Schätzung einen Wert von mindestens zwei Sekeln heiligen Gewichts hat, zum Schuldopfer bringen. ");
INSERT INTO deutkw_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Und was er sich von dem Geheiligten widerrechtlich angeeignet hat, soll er zurückerstatten und noch ein Fünftel des Betrags darauflegen. Er soll es dem Priester übergeben, und der Priester soll ihm durch den Schuldopfer-Widder Sühne schaffen; so wird ihm vergeben werden. ");
INSERT INTO deutkw_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Und wenn sich jemand vergeht und unbewußt irgend eines der Verbote Jahwes übertritt und so in Schuld gerät und Verschuldung auf sich geladen hat, ");
INSERT INTO deutkw_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","so soll er einen fehllosen Widder aus seiner Kleinvieh-Herde nach deiner Schätzung als Schuldopfer zum Priester bringen, und der Priester soll ihm Sühne schaffen wegen des Vergehens, das er unbewußt begangen hat; so wird ihm vergeben werden. ");
INSERT INTO deutkw_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Ein Schuldopfer ist es; hat er sich doch gegen Jahwe verschuldet. ");
INSERT INTO deutkw_vpl VALUES ("LV5_20","004_5_20","LEV","5","20","20","Und Jahwe redete mit Mose aIso: ");
INSERT INTO deutkw_vpl VALUES ("LV5_21","004_5_21","LEV","5","21","21","Wenn sich jemand vergeht und sich einer Veruntreuung gegen Jahwe schuldig macht, indem er seinem Nächsten etwas Anvertrautes oder Hinterlegtes oder Geraubtes ableugnet oder seinen Nächsten übervorteilt ");
INSERT INTO deutkw_vpl VALUES ("LV5_22","004_5_22","LEV","5","22","22","oder Verlorenes, das er gefunden hat, ableugnet oder indem er einen falschen Eid schwört wegen irgend einer Handlung, durch die sich einer vergehen kann, - ");
INSERT INTO deutkw_vpl VALUES ("LV5_23","004_5_23","LEV","5","23","23","wenn er sich so vergeht und in Schuld gerät, so soll er dasjenige, was er geraubt oder erpreßt hat, oder was ihm anvertraut worden war, oder das Verlorene, das er gefunden, ");
INSERT INTO deutkw_vpl VALUES ("LV5_24","004_5_24","LEV","5","24","24","oder dasjenige, um dessentwillen er betrüglich geschworen hat - was es auch sein mag - zurückerstatten; und zwar soll er es nach seinem vollen Wert ersetzen und noch ein Fünftel des Betrags darauflegen. Dem soll er es geben, dem es zukommt, an dem Tage, wo er seine Buße entrichtet. ");
INSERT INTO deutkw_vpl VALUES ("LV5_25","004_5_25","LEV","5","25","25","Als Buße aber soll er für Jahwe einen fehllosen Widder aus seiner Kleinvieh-Herde nach deiner Schätzung als Schuldopfer zum Priester bringen. ");
INSERT INTO deutkw_vpl VALUES ("LV5_26","004_5_26","LEV","5","26","26","Und der Priester soll ihm Sühne schaffen vor Jahwe; so wird ihm vergeben werden - jedwede Handlung, durch die sich einer verschulden kann. ");
INSERT INTO deutkw_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Gieb Aaron und seinen Söhnen folgende Weisung: Dies sind die Bestimmungen in betreff des Brandopfers. Dieses - das Brandopfer - soll auf dem Altar da, wo es angezündet wurde, die ganze Nacht hindurch verbleiben bis zum Morgen; das Altarfeuer soll damit brennend erhalten werden. ");
INSERT INTO deutkw_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Und der Priester ziehe sein linnenes Gewand an, bedecke seine Scham mit linnenen Beinkleidern, nehme die Asche weg, in welche das Brandopfer vom Feuer auf dem Altar verwandelt ist, und schütte sie neben den Altar. ");
INSERT INTO deutkw_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Hierauf ziehe er seine Kleider aus, lege andere Kleider an und schaffe die Asche hinaus vor das Lager an einen reinen Ort. ");
INSERT INTO deutkw_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Das Feuer auf dem Altar aber soll damit brennend erhalten werden und nie erlöschen. Alle Morgen soll der Priester Holzscheite darauf anzünden, das Brandopfer darauf schichten und die Fettstücke der Heilsopfer über demselben in Rauch aufgehn lassen. ");
INSERT INTO deutkw_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Immerfort soll Feuer auf dem Altar brennen und nie erlöschen. ");
INSERT INTO deutkw_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Und dies sind die Bestimmungen in betreff des Speisopfers. Die Söhne Aarons sollen es vor Jahwe, heran an den Altar, bringen. ");
INSERT INTO deutkw_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Sodann soll er eine Hand voll davon nehmen - von dem Feinmehl und dem Öl, aus welchem das Speisopfer besteht, - dazu den ganzen Weihrauch, der auf dem Speisopfer liegt, und es auf dem Altar in Rauch aufgehn lassen als ein Feueropfer lieblichen Geruchs, als den Duftteil von ihm für Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Und was übrig ist von ihm, das sollen Aaron und seine Söhne essen. Ungesäuert soll es gegessen werden an heiliger Stätte; im Vorhof des Offenbarungszeltes sollen sie es essen. ");
INSERT INTO deutkw_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Es darf nicht mit Sauerteig gebacken werden. Ich verleihe es ihnen als ihren Anteil an meinen Feueropfern; hochheilig ist es, wie das Sündopfer und das Schuldopfer. ");
INSERT INTO deutkw_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Alles, was männlich ist unter den Kindern Aarons, darf es essen, kraft eines für alle Zeiten geltenden Rechtes, das euch gegenüber den Feueropfern Jahwes zusteht von GeschIecht zu Geschlecht. Jeder der sie berührt, ist dem Heiligtume verfallen. ");
INSERT INTO deutkw_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Dies sei die Opfergabe Aarons und seiner Söhne, die sie Jahwe darzubringen haben an dem Tag, an welchem er gesalbt wird: Ein Zehntel Epha Feinmehl als regelmäßiges Speisopfer - die eine Hälfte davon am Morgen, die andere Hälfte am Abend. ");
INSERT INTO deutkw_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Auf einer Platte soll es mit Öl bereitet werden; eingerührt sollst du es bringen. Zu einem Speisopfer in Bissen sollst du es zerbrechen und es darbringen zum lieblichen Geruch für Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Der Priester, der aus der Reihe seiner Söhne an seiner Statt gesalbt ist, soll es verrichten, kraft einer für alle Zeiten geltenden Satzung Jahwes; als Ganzopfer soll es verbrannt werden. ");
INSERT INTO deutkw_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Alle Priester-Speisopfer sollen Ganzopfer sein; sie dürfen nicht gegessen werden. ");
INSERT INTO deutkw_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Sprich zu Aaron und zu seinen Söhnen und gebiete ihnen: Dies sind die Bestimmungen in betreff des Sündopfers: Da, wo das Brandopfer zu schIachten ist vor Jahwe, soll auch das Sündopfer geschlachtet werden; hochheiIig ist es. ");
INSERT INTO deutkw_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Der Priester, der das Sündopfer darbringt, soll es verzehren; an heiliger Stätte muß es gegessen werden, im Vorhofe des Offenbarungszeltes. ");
INSERT INTO deutkw_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Jeder, der das Fleisch von ihm berührt ist dem Heiligtume verfallen; und wenn etwas von seinem Blut ans Kleid spritzt, so mußt du das von ihm bespritzte an heiliger Stätte waschen. ");
INSERT INTO deutkw_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Irdenes Gefäß, in dem es gekocht wurde, muß zerbrochen werden; wurde es aber in einem kupfernen Gefäße gekocht, so muß dieses gescheuert und gehörig ausgespült werden. ");
INSERT INTO deutkw_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Alles, was männlich ist unter den Priestern, darf es essen; hochheilig ist es. ");
INSERT INTO deutkw_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Alle die Sündopfer aber, von denen ein Teil des Blutes ins Offenbarungszelt gebracht worden ist, um die Sühnegebräuche im Heiligtume zu vollziehen, dürfen nicht gegessen werden, sondern sind zu verbrennen. ");
INSERT INTO deutkw_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Und dies sind die Bestimmungen in betreff des Schuldopfers; hochheilig ist es. ");
INSERT INTO deutkw_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Da, wo man das Brandopfer schlachtet, soll man auch das Schuldopfer schlachten, und das Blut desselben soll man ringsum an den Altar sprengen. ");
INSERT INTO deutkw_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Das gesamte Fett aber soll man von ihm darbringen: Den Fettschwanz und das Fett, welches die Eingeweide bedeckt, ");
INSERT INTO deutkw_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","die beiden Nieren samt dem Fett an ihnen, an den Lendenmuskeln, sowie das Anhängsel an der Leber; bei den Nieren soll er es wegnehmen. ");
INSERT INTO deutkw_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Und der Priester soll es auf dem Altar in Rauch aufgehn lassen als ein Jahwe dargebrachtes Feueropfer; ein Schuldopfer ist es. ");
INSERT INTO deutkw_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Alles, was männlich ist unter den Priestern, soll es essen; an heiliger Stätte muß es gegessen werden - hochheilig ist es. ");
INSERT INTO deutkw_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Wie vom Sündopfer, so gilt ganz gleich auch vom Schuldopfer: Dem Priester, der die Sühnegebräuche damit vollzieht, dem soll es gehören! ");
INSERT INTO deutkw_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Und dem Priester, der das Brandopfer jemandes darbringt, demselben soll das Fell des Brandopfers, welches er dargebracht hat, gehören. ");
INSERT INTO deutkw_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Ebenso sollen alle Speisopfer, die im Ofen gebacken, sowie alle, die in der Pfanne und auf der Platte bereitet sind, dem Priester gehören, der sie darbringt. ");
INSERT INTO deutkw_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Alle Speisopfer, die mit Öl angemachten, wie die trockenen, sollen allen Söhnen Aarons gehören, einem wie dem anderen. ");
INSERT INTO deutkw_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Und dies sind die Bestimmungen in betreff der Heilsopfer, die man Jahwe darbringt: ");
INSERT INTO deutkw_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Wenn es einer als Danksagung darbringt, so soll er zu dem Dankopfer ungesäuerte, mit ÖI angemachte Kuchen und ungesäuerte Fladen, die mit Öl bestrichen sind, und eingerührtes Feinmehl - mit Öl angemachte Kuchen darbringen. ");
INSERT INTO deutkw_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Nebst Kuchen von gesäuertem Brote soll er seine Opfergabe darbringen, außer dem Opfertier, in welchem sein Heils-Dankopfer besteht. ");
INSERT INTO deutkw_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Und zwar soll er davon je ein Stück von jeder Art Opfergabe als Hebeopfer für Jahwe darbringen; dem Priester, der das Blut des Heilsopfers sprengt, soll es gehören. ");
INSERT INTO deutkw_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Das Fleisch des Heils-Dankopfers aber muß an demselben Tage gegessen werden, an welchem das Opfer gebracht wird; man darf nichts davon übrig lassen bis zum Morgen. ");
INSERT INTO deutkw_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Beruht aber das Opfer, das er darbringt, auf einem Gelübde oder ist es eine freiwillige Leistung, so soll es an demselben Tage gegessen werden, an welchem das Opfer dargebracht wird; doch mag, was davon übrig geblieben ist, am folgenden Tage gegessen werden. ");
INSERT INTO deutkw_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Was aber am dritten Tage vom Opferfleisch übrig ist, muß verbrannt werden. ");
INSERT INTO deutkw_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Sollte aber auch am dritten Tage noch von dem Heilsopfer-Fleische gegessen werden, so wird dies den, der es dargebracht hat, nicht wohlgefällig machen; es wird ihm nicht angerechnet werden, sondern als Verdorbenes gelten, und derjenige, der davon ißt, wird Verschuldung auf sich laden. ");
INSERT INTO deutkw_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Auch solches Fleisch, welches mit irgend etwas Unreinem in Berührung gekommen ist, darf nicht gegessen werden, sondern ist zu verbrennen. Was aber das Fleisch überhaupt anlangt, so darf jeder, der rein ist, Fleisch essen. ");
INSERT INTO deutkw_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Derjenige aber, der Fleisch von dem Jahwe dargebrachten Heilsopfer ißt, während er mit Unreinigkeit behaftet ist, ein solcher soll hinweggetilgt werden aus seinen Volksgenossen. ");
INSERT INTO deutkw_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Und wenn jemand mit irgend etwas Unreinem in Berührung gekommen ist, sei es nun mit der Unreinigkeit an einem Menschen oder mit einem unreinen Vieh oder irgend einem unreinen Greuel, und ißt von dem Fleische des Jahwe dargebrachten Heilsopfers, ein solcher soll hinweggetilgt werden aus seinen Volksgenossen. ");
INSERT INTO deutkw_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Sprich zu den Israeliten und gebiete ihnen: Ihr dürft keinerlei Fett von Rindern, Schafen oder Ziegen essen. ");
INSERT INTO deutkw_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Das Fett von gefallenen und das Fett von zerrissenen Tieren kann zu allerlei Zwecken verwendet werden, aber essen dürft ihr es nicht. ");
INSERT INTO deutkw_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Denn jeder, der Fett von Tierarten genießt, wie man sie Jahwe als Feueropfer darbringt, - hinwegzutilgen ist ein solcher, der es genießt, aus seinen Volksgenossen! ");
INSERT INTO deutkw_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Ebenso dürft ihr auch kein Blut genießen in allen euren Wohnsitzen, weder von Vögeln noch von vierfüßigen Tieren. ");
INSERT INTO deutkw_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Jeder, der irgend Blut äße, der soll hinweggetilgt werden aus seinen Volksgenossen! ");
INSERT INTO deutkw_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Sprich zu den Israeliten und gebiete ihnen: Wer Jahwe sein Heilsopfer darbringt, der bringe Jahwe von seinem Heilsopfer den Opferanteil, den er ihm schuldet. ");
INSERT INTO deutkw_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Er selbst bringe die Stücke, die Jahwe als Feueropfer gehören: Das Fett nebst der Brust soll er herzubringen; die Brust, damit sie als Webe vor Jahwe gewebt werde. ");
INSERT INTO deutkw_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Und der Priester soll das Fett auf dem Altar in Rauch aufgehn lassen, die Brust aber soll Aaron und seinen Söhnen gehören. ");
INSERT INTO deutkw_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Auch die rechte Keule sollt ihr von euren Heilsopfern dem Priester als Hebe geben. ");
INSERT INTO deutkw_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Derjenige von den Söhnen Aarons, der das Blut und das Fett des Heilsopfers darbringt, dem soll die rechte Keule als Anteil zufallen. ");
INSERT INTO deutkw_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Denn die Webe-Brust und die Hebe-Keule nehme ich von den Heilsopfern der Israeliten in Anspruch und gebe sie Aaron, dem Priester, und seinen Söhnen als eine Gebühr, die allezeit von den Israeliten zu entrichten ist. ");
INSERT INTO deutkw_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Dies ist der Anteil Aarons und seiner Söhne an den Feueropfern Jahwes, an dem Tag, an welchem er sie herzutreten ließ, Jahwe Priesterdienst zu thun, ");
INSERT INTO deutkw_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","den ihnen Jahwe an dem Tag, an welchem er sie salbte, als eine Gabe seitens der Israeliten überwies, als eine Gebühr, die diesen alle Zeit obliegen sollte von Geschlecht zu Geschlecht. ");
INSERT INTO deutkw_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Dies sind die Bestimmungen in betreff des Brandopfers, des Speisopfers, des Sündopfers, des Schuldopfers, des Einsetzungs-Opfers und des Heilsopfers, ");
INSERT INTO deutkw_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","welche Jahwe Mose anbefahl auf dem Berge Sinai, als er die Israeliten anwies, Jahwe ihre Opfergaben darzubringen, in der Steppe am Sinai. ");
INSERT INTO deutkw_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Nimm Aaron samt seinen Söhnen, dazu die Kleider, das Salböl, den Sündopfer-Farren, die beiden Widder, sowie den Korb mit dem Ungesäuerten, ");
INSERT INTO deutkw_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","und versammle die ganze Gemeinde vor der Thüre des Offenbarungszeltes. ");
INSERT INTO deutkw_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Da tat Mose, wie ihm Jahwe befohlen hatte, und die Gemeinde versammelte sich vor der Thüre des Offenbarungszeltes. ");
INSERT INTO deutkw_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Da sprach Mose zu der Gemeinde: Dies ist's, was Jahwe zu thun befohlen hat. ");
INSERT INTO deutkw_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Hierauf ließ Mose Aaron und seine Söhne antreten und wusch sie mit Wasser. ");
INSERT INTO deutkw_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Sodann legte er ihm den Leibrock an, umgürtete ihn mit dem Gürtel, bekleidete ihn mit dem Obergewand und legte ihm das Schulterkleid an; sodann band er ihm die Binde des Schulterkleids um und befestigte es so an ihm. ");
INSERT INTO deutkw_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Hierauf legte er ihm die Tasche an und that in die Tasche die Urim und die Tummim. ");
INSERT INTO deutkw_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Sodann setzte er ihm den Kopfbund aufs Haupt; auf der Vorderseite des Kopfbunds aber befestigte er das goldene Stirnblatt, das heilige Diadem, wie Jahwe Mose befohlen hatte. ");
INSERT INTO deutkw_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Sodann nahm Mose das Salböl, salbte die Wohnung und alles, was sich in ihr befand, und weihte es so. ");
INSERT INTO deutkw_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Auch sprengte er davon auf den Altar, siebenmal, und salbte den Altar samt allen seinen Geräten, sowie das Becken samt seinem Gestelle, um sie so zu weihen. ");
INSERT INTO deutkw_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Sodann goß Mose einen Teil des Salböls auf das Haupt Aarons und salbte ihn, um ihn so zu weihen. ");
INSERT INTO deutkw_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Hierauf ließ Mose die Söhne Aarons herantreten, bekleidete sie mit Leibröcken, umgürtete sie mit einem Gürtel und setzte ihnen Mützen auf, wie Jahwe Mose befohlen hatte. ");
INSERT INTO deutkw_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Sodann brachte er den Sündopfer-Farren herzu, und Aaron und seine Söhne stemmten die Hand auf den Kopf des Sündopfer-Farren. ");
INSERT INTO deutkw_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Dann schlachtete ihn Mose, nahm das Blut, strich es mit dem Finger ringsum an die Hörner des Altars und entsündigte so den Altar; das übrige Blut aber goß er am Altar auf den Boden. So weihte er den Altar, indem er die Sühnehandlungen an ihm vollzog. ");
INSERT INTO deutkw_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Sodann nahm er das ganze Fett, welches die Eingeweide bedeckte, das Anhängsel an der Leber und die beiden Nieren samt dem Fett daran, und Mose ließ es auf dem Altar in Rauch aufgehn. ");
INSERT INTO deutkw_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Den Farren aber samt seinem Fell, seinem Fleisch und seinem Mist verbrannte er außerhalb des Lagers, wie Jahwe Mose befohlen hatte. ");
INSERT INTO deutkw_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Sodann lief er den Widder zum Brandopfer herzubringen, und Aaron und seine Söhne stemmten die Hand auf den Kopf des Widders. ");
INSERT INTO deutkw_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Dann schlachtete ihn Mose und sprengte das Blut ringsum an den Altar. ");
INSERT INTO deutkw_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Den Widder aber zerlegte er in seine Teile; sodann ließ Mose den Kopf, die Stücke und das Fett in Rauch aufgehn. ");
INSERT INTO deutkw_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Die Eingeweide aber und die Beine wusch er mit Wasser; sodann ließ Mose den ganzen Widder auf dem Altar in Rauch aufgehn als ein Brandopfer lieblichen Geruchs, als eine Jahwe dargebrachte Feuerspeise, wie Jahwe Mose befohlen hatte. ");
INSERT INTO deutkw_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Hierauf ließ er den anderen Widder, den Einsetzungswidder, herzubringen, und Aaron und seine Söhne stemmten die Hand auf den Kopf des Widders. ");
INSERT INTO deutkw_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Dann schlachtete ihn Mose, nahm etwas von dem Blut und strich es an das rechte Ohrläppchen Aarons, sowie an seinen rechten Daumen und seine rechte große Zehe. ");
INSERT INTO deutkw_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Sodann ließ Mose die Söhne Aarons herantreten und strich etwas von dem Blut an ihr rechtes Ohrläppchen, sowie an ihren rechten Daumen und ihre rechte große Zehe; das übrige Blut aber sprengte Mose ringsum an den Altar. ");
INSERT INTO deutkw_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Sodann nahm er das Fett, den Fettschwanz samt all' dem Fett an den Eingeweiden, das Anhängsel an der Leber und die beiden Nieren samt ihrem Fette, sowie die rechte Keule. ");
INSERT INTO deutkw_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Dazu nahm er aus dem Korbe mit dem Ungesäuerten, der vor Jahwe stand, einen ungesäuerten Kuchen, einen mit Öl angemachten Brotkuchen und einen Fladen und legte sie zu den Fettstücken und zu der rechten Keule. ");
INSERT INTO deutkw_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Dann gab er alles miteinander Aaron und seinen Söhnen in die Hände und webte es als Webe vor Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Hierauf nahm es ihnen Mose aus den Händen und lies es auf dem Altar über dem Brandopfer in Rauch aufgehn als ein Einsetzungs- Opfer lieblichen Geruchs, als ein Jahwe dargebrachtes Feueropfer. ");
INSERT INTO deutkw_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Sodann nahm Mose die Brust von dem Einsetzungs-Widder und webte sie als Webe vor Jahwe; sie fiel Mose als Anteil zu, wie Jahwe Mose befohlen hatte. ");
INSERT INTO deutkw_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Sodann nahm Mose einen Teil des Salböls und des Blutes, das sich auf dem Altar befand, und sprengte es auf Aaron und seine Kleider, sowie auf seine Söhne und ihre Kleider, und weihte so Aaron und seine Kleider, sowie seine Söhne und ihre Kleider. ");
INSERT INTO deutkw_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Hierauf gebot Mose Aaron und seinen Söhnen: kocht das Fleisch vor der Thüre des Offenbarungszeltes und verzehrt es daselbst samt dem Brote, welches sich in dem zum Einsetzungs-Opfer gehörenden Korbe befindet, wie ich angewiesen wurde durch den Befehl: Aaron und seine Söhne sollen es verzehren! ");
INSERT INTO deutkw_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Was von dem Fleisch und dem Brot übrig bleibt, müßt ihr verbrennen. ");
INSERT INTO deutkw_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Uns sieben Tage lang dürft ihr nicht von der Thüre des Offenbarungszeltes hinweggehen, bis zu dem Tage, wo die zu eurer Einsetzung bestimmte Zeit um ist; denn sieben Tage hindurch soll er euch die Hand füllen. ");
INSERT INTO deutkw_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Wie er heute gethan hat, so hat Jahwe weiter zu tun geboten, um euch Sühne zu schaffen. ");
INSERT INTO deutkw_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Sieben Tage hindurch müßt ihr Tag und Nacht vor der Thüre des Offenbarungszeltes bleiben und die Anordnungen Jahwes befolgen; sonst müßtet ihr sterben - so ist mir's geboten! ");
INSERT INTO deutkw_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Aaron aber und seine Söhne thaten alles, was Jahwe durch Mose befohlen hatte. ");
INSERT INTO deutkw_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Am achten Tag aber berief Mose Aaron und seine Söhne und die Vornehmsten des Volks ");
INSERT INTO deutkw_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","und gebot Aaron: Hole dir ein junges Rind zum Sündopfer und einen Widder zum Brandopfer, beide fehllos, und bringe sie dar vor Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Den Israeliten aber gebiete folgendes: Holt einen Ziegenbock zum Sündopfer, sowie ein Kalb und ein Schaf, beide einjährig und fehllos, zum Brandopfer, ");
INSERT INTO deutkw_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","ferner einen Stier und einen Widder zum Heilsopfer, um sie vor Jahwe zu schlachten, dazu ein mit Öl angemachtes Speisopfer; denn heute wird euch Jahwe erscheinen. ");
INSERT INTO deutkw_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Da brachten sie, was Mose verlangt hatte, hin vor das Offenbarungszelt, und die ganze Gemeinde nahte herzu und trat vor Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Und Mose sprach: Dies ist's, was euch Jahwe zu thun befohlen hat, damit euch die Herrlichkeit Jahwes erscheine. ");
INSERT INTO deutkw_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Sodann gebot Mose Aaron: Tritt heran an den Altar und besorge dein Sündopfer und dein Brandopfer, damit du für dich und das Volk Sühne schaffst; sodann besorge die Opfergabe des Volks, damit du für sie Sühne schaffst, wie Jahwe befohlen hat. ");
INSERT INTO deutkw_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Da trat Aaron an den Altar heran und schlachtete das Kalb, das zum Sündopfer für ihn selbst bestimmt war. ");
INSERT INTO deutkw_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Die Söhne Aarons aber reichten ihm das Blut; da tauchte er seinen Finger in das Blut und strich es an die Hörner des Altars. Das übrige Blut goß er am Altar auf den Boden. ");
INSERT INTO deutkw_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Das Fett des Sündopfers aber samt den Nieren und dem Anhängsel an der Leber ließ er auf dem Altar in Rauch aufgehn, wie Jahwe Mose befohlen hatte. ");
INSERT INTO deutkw_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Das Fleisch und das Fell verbrannte er außerhalb des Lagers. ");
INSERT INTO deutkw_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Sodann schlachtete er das Brandopfer; die Söhne Aarons überreichten ihm das Blut, und er sprengte es ringsum an den Altar. ");
INSERT INTO deutkw_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Das Brandopfer aber reichten sie ihm in Stücke zerlegt samt dem Kopf, und er ließ es auf dem Altar in Rauch aufgehn. ");
INSERT INTO deutkw_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Die Eingeweide und die Beine wusch er mit Wasser und ließ sie auf dem Altar über dem Brandopfer in Rauch aufgehn. ");
INSERT INTO deutkw_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Sodann brachte er die Opfergabe des Volkes dar: Er nahm den Bock, der zum Sündopfer für das Volk bestimmt war, schlachtete ihn und brachte ihn als Sündopfer, wie zuvor. ");
INSERT INTO deutkw_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Hierauf brachte er das Brandopfer dar und besorgte es, wie es sich gebührt. ");
INSERT INTO deutkw_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Sodann brachte er das Speisopfer dar, nahm eine Hand voll davon und ließ sie auf dem Altar in Rauch aufgehn, außer dem Morgen-Brandopfer. ");
INSERT INTO deutkw_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Hierauf schlachtete er das Rind und den Widder als Heilsopfer für das Volk; die Söhne Aarons reichten ihm das Blut, und er sprengte es ringsum an den Altar. ");
INSERT INTO deutkw_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Was aber die Fettstücke des Rindes anlangt, sowie den Fettschwanz des Widders samt dem die Eingeweide bedeckenden Fett, den Nieren und dem Anhängsel an der Leber, ");
INSERT INTO deutkw_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","so legten sie diese Fettstücke auf die Bruststücke, und er ließ die Fettstücke auf dem Altar in Rauch aufgehn. ");
INSERT INTO deutkw_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Die Bruststücke aber und die rechte Keule webte Aaron als Webe vor Jahwe, wie Mose befohlen hatte. ");
INSERT INTO deutkw_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Sodann erhob Aaron seine Hände nach dem Volke zu und segnete sie; und nachdem er so das Sündopfer, das Brandopfer und das Heilsopfer befolgt hatte, stieg er herab. ");
INSERT INTO deutkw_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Hierauf gingen Mose und Aaron hinein ins Offenbarungszelt; und als sie wieder herauskamen, segneten sie das Volk. Da erschien die Herrlichkeit Jahwes dem ganzen Volk, ");
INSERT INTO deutkw_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","und es ging Feuer aus von Jahwe und verzehrte das Brandopfer und die Fettstücke auf dem Altar. Als alles Volk dies wahrnahm, da jubelten sie und fielen auf ihr Antlitz. ");
INSERT INTO deutkw_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Nadab aber und Abihu, die Söhne Aarons, nahmen ihre Kohlenpfannen, thaten Feuer hinein und legten Räucherwerk darauf und brachten so ein ungehöriges Feueropfer, das er ihnen nicht geboten hatte, vor Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Da ging Feuer aus von Jahwe und verzehrte sie, so daß sie dort vor Jahwe starben. ");
INSERT INTO deutkw_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Da sprach Mose zu Aaron: Hier erfüllt sich, was Jahwe angekündigt hat, indem er sprach: An denen, die mir nahe stehen, will ich meine Heiligkeit erweisen. Und vor allem Volke will ich mich verherrlichen. Aaron aber verhielt sich schweigend. ");
INSERT INTO deutkw_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Da rief Mose Misael und Elzaphan, sie Söhne Usiels, des Oheims Aarons, herbei und gebot ihnen: Tretet herzu und tragt eure Verwandten von dem Platze vor dem Heiligtum hinweg hinaus vor das Lager! ");
INSERT INTO deutkw_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Da traten sie herzu und trugen sie in ihren Leibröcken hinaus vor das Lager, wie Mose geboten hatte. ");
INSERT INTO deutkw_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Aaron aber und seinen Söhnen Eleasar und Ithamar gebot Mose: Ihr dürft eure Häupter nicht entblößen und eure Kleider nicht zerreißen; sonst müßtet ihr sterben, und er würde heftig auf die ganze Gemeinde zürnen! Eure Brüder aber, das ganze Haus Israel, mögen den Brand beweinen, den Jahwe angerichtet hat. ");
INSERT INTO deutkw_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Auch dürft ihr nicht zur Thüre des Offenbarungszeltes hinausgehen, damit ihr nicht sterbt; denn das Salböl Jahwes ist auf euch! Sie aber thaten nach Moses Geheiß. ");
INSERT INTO deutkw_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Und Jahwe redete mit Aaron also: ");
INSERT INTO deutkw_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","Wein und berauschendes Getränk dürft ihr - du und deine Söhne - nicht trinken, wenn ihr ins Offenbarungszelt hineingeht, sonst müßt ihr sterben. Das ist eine für alle Zeiten geltende Satzung, die ihr beobachten sollt von Geschlecht zu Geschlecht. ");
INSERT INTO deutkw_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Und ihr sollt unterscheiden zwischen dem, was heilig, und dem, was nicht heilig ist, zwischen dem, was unrein, und dem, was rein ist, ");
INSERT INTO deutkw_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","und sollt die Israeliten alle die Satzungen lehren, die ihnen Jahwe durch Mose verkündigt hat. ");
INSERT INTO deutkw_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Und Mose gebot Aaron, sowie Eleasar und Ithamar, die ihm von seinen Söhnen noch geblieben waren: Nehmt das Speisopfer, das von den Jahwe dargebrachten Feueropfern noch übrig ist, und eßt es ungesäuert neben dem Altar, denn es ist hochheilig. ");
INSERT INTO deutkw_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Darum sollt ihr es an heiliger Stätte essen, denn es ist die Gebühr, die dir und deinen Söhnen von den Feueropfern zufällt - so ist mir's geboten! ");
INSERT INTO deutkw_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Die Webebrust aber und die Hebekeule sollst du neben deinen Söhnen und Töchtern an reiner Stätte essen, denn sie sind verliehen als die Gebühr, die dir und deinen Kindern von den Heilsopfern der Israeliten zufällt. ");
INSERT INTO deutkw_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Die Hebekeule und die Webebrust soll man neben den zu Feueropfern bestimmten Fettstücken bringen, damit sie als Webe vor Jahwe gewebt werden; dann sollen sie dir und deinen Kindern als eine für alle Zeiten feststehende Gebühr zufallen, wie Jahwe befohlen hat. ");
INSERT INTO deutkw_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Als sich nun Mose angelegentlich nach dem Sündopfer-Bock erkundigte, befand sich, daß er verbrannt war. Da zürnte er heftig auf Eleasar und Ithamar, die Söhne Aarons, die diesem noch geblieben waren, und fragte: ");
INSERT INTO deutkw_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Warum habt ihr denn das Sündopfer nicht gegessen an heiliger Stätte? Denn es ist hochheilig, und er hat es euch verliehen, um die Verschuldung der Gemeinde hinwegzuschaffen und ihnen Sühne vor Jahwe zu erwirken. ");
INSERT INTO deutkw_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Ist ja doch sein Blut nicht ins Innere des Heiligtums gebracht worden; somit mußtet ihr es essen im heiligen Bezirke, wie ich befohlen hatte. ");
INSERT INTO deutkw_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Da antwortete Aaron Mose: Bedenke, sie haben heute ihr Sündopfer und ihr Brandopfer vor Jahwe dargebracht, und mich betraf dennoch solches; wenn ich nun heute Sündopferfleisch genießen wollte, würde das wohl Jahwe gefallen? ");
INSERT INTO deutkw_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Als Mose das hörte, ließ er sich's gefallen. ");
INSERT INTO deutkw_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Und Jahwe redete mit Mose und Aaron und gebot ihnen folgendes: ");
INSERT INTO deutkw_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Sprecht zu den Israeliten also: Dies sind die Tiere, die ihr essen dürft von allen Vierfüßlern auf Erden: ");
INSERT INTO deutkw_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","alle Vierfüßler, die gespaltene Klauen haben - und zwar völlig durchgespaltene Klauen - und wiederkäuen, die dürft ihr essen. ");
INSERT INTO deutkw_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Dagegen dürft ihr von den Tieren, welche wiederkäuen und welche gespaltene Klauen haben, die nachfolgenden nicht essen: Das Kamel, denn es ist zwar Wiederkäuer, hat aber keine durchgespaltenen Klauen - als unrein hat es euch zu gelten; ");
INSERT INTO deutkw_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","den Klippdachs, denn er ist zwar Wiederkäuer, hat aber keine durchgespaltenen Klauen - als unrein hat er euch zu gelten; ");
INSERT INTO deutkw_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","den Hasen, denn er ist zwar Wiederkäuer, hat aber keine durchgespaltenen Klauen - als unrein hat er euch zu gelten; ");
INSERT INTO deutkw_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","das Schwein, denn es hat zwar völlig durchgespaltene Klauen, ist aber kein Wiederkäuer - als unrein hat es euch zu gelten. ");
INSERT INTO deutkw_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Ihr dürft weder ihr Fleisch genießen, noch dürft ihr ihr Aas berühren - als unrein haben Sie euch zu gelten. ");
INSERT INTO deutkw_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Folgende dürft ihr essen von allen, die im Wasser leben: Alle Wassertiere sowohl im Meer, als in den Bächen, welche Flossen und Schuppen haben, die dürft ihr essen. ");
INSERT INTO deutkw_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Alles aber, sowohl im Meer, als in den Bächen, was keine Flossen und Schuppen hat, unter allem, was im Wasser wimmelt, und unter allen Lebewesen, die sich im Wasser befinden, soll euch ein Greuel sein. ");
INSERT INTO deutkw_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Ein Greuel sollen sie euch sein: ihr Fleisch dürft ihr nicht genießen und ihr Aas müßt ihr verabscheuen. ");
INSERT INTO deutkw_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Alle Wassertiere, die keine Flossen und Schuppen haben, sollen euch ein Greuel sein. ");
INSERT INTO deutkw_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Von den Vögeln aber sollt ihr folgende verabscheuen - sie dürfen nicht gegessen werden, sondern sind zu verabscheuen -: den Adler, den Bartgeier, den Geier, ");
INSERT INTO deutkw_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","die Weihe und das Geschlecht der Falken, ");
INSERT INTO deutkw_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","das ganze Geschlecht der Raben, ");
INSERT INTO deutkw_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","den Strauß, die Schwalbe, die Möve und das Geschlecht der Habichte; ");
INSERT INTO deutkw_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","das Käuzchen, den Sturzpelikan, den Uhu, ");
INSERT INTO deutkw_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","die Eule, den Pelikan, den Erdgeier, ");
INSERT INTO deutkw_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","den Storch, das Geschlecht der Regenpfeifer, den Wiedehopf und die Fledermaus. ");
INSERT INTO deutkw_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Alle geflügelten kleinen Tiere, die auf vieren gehen, sollen euch ein Greuel sein. ");
INSERT INTO deutkw_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Von allen geflügelten kleinen Tieren, die auf vieren gehen, dürft ihr nur diejenigen essen, welche oberhalb ihrer Füße zwei Hinterschenkel haben, um damit auf der Erde zu hüpfen. ");
INSERT INTO deutkw_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Von diesen dürft ihr die folgenden essen: Die verschiedenen Arten der Zugheuschrecken, die verschiedenen Arten der Solamheuschrecken, die verschiedenen Arten der Chargolheuschrecken und die verschiedenen Arten der Chagabheuschrecken. ");
INSERT INTO deutkw_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Alle übrigen geflügelten kleinen Tiere aber, die vier Füße haben, sollen euch ein Greuel sein. ");
INSERT INTO deutkw_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Durch diese Tiere verunreinigt ihr euch; jeder, der ihr Aas anrührt, wird unrein bis zum Abend. ");
INSERT INTO deutkw_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Und jeder, der eines ihrer Äser trägt, muß seine Kleider waschen und wird unrein bis zum Abend - ");
INSERT INTO deutkw_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","durch jedes Tier, welches gespaltene, aber doch nicht völlig durchgespaltene Klauen hat und nicht wiederkäut. Als unrein sollen sie euch gelten; jeder, der sie berührt, wird unrein. ");
INSERT INTO deutkw_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Auch alle die, welche auf Tatzen gehen, unter allen den Tieren, die auf Vieren gehen, sollen euch als unrein gelten; jeder, der ihr Aas berührt, wird unrein bis zum Abend. ");
INSERT INTO deutkw_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Und wer ihr Aas trägt, muß seine Kleider waschen und wird unrein bis zum Abend - als unrein sollen sie euch gelten. ");
INSERT INTO deutkw_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Diese aber sind es, die euch als unrein gelten sollen unter den kleinen Tieren, die sich auf der Erde tummeln: Das Wiesel, die Maus, die verschiedenen Arten der Eidechse, ");
INSERT INTO deutkw_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","die Anaka, der Koach, die Letaa, der Chomet und die Tinschemeth. ");
INSERT INTO deutkw_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Das sind die, welche euch als unrein gelten sollen unter allen kleinen Tieren; jeder, der sie berührt, wenn sie tot sind, wird unrein bis zum Abend. ");
INSERT INTO deutkw_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Und alles, worauf eines von ihnen im Tode fällt, wird unrein: So jedes hölzerne Gefäß oder Gewand oder Fell oder Sacktuch - alle Gefäße, die zum Gebrauche dienen. Sie sind ins Wasser zu stecken und bleiben unrein bis zum Abend; dann sind sie wieder rein. ");
INSERT INTO deutkw_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Wenn aber eines von ihnen in irgend ein irdenes Gefäß hineinfällt, so wird alles, was darin ist, unrein, und ihr müßt es zerbrechen. ");
INSERT INTO deutkw_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Jede Art Speise, die gegessen zu werden pflegt, an die Wasser kommt, wird unrein; ebenso wird jedes Getränk, das getrunken zu werden pflegt, in jederlei Gefäß unrein. ");
INSERT INTO deutkw_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Und alles, worauf eines ihrer Äser fällt, wird unrein: ein Backtopf oder Kochherd muß eingerissen werden. Unrein sind sie und sollen euch als unrein gelten. ");
INSERT INTO deutkw_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Nur Quellen und Brunnen, also Wasserbehälter, bleiben rein; wer aber ihr Aas berührt, wird unrein. ");
INSERT INTO deutkw_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Und wenn eines ihrer Äser auf irgend welche Sämereien fällt, die ausgesäet werden, so bleiben diese rein. ");
INSERT INTO deutkw_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Wird aber Wasser an die Sämereien gebracht, und es fällt dann eines ihrer Äser darauf, so haben sie euch als unrein zu gelten. ");
INSERT INTO deutkw_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Und wenn eines von den Tieren stirbt, die euch zur Speise dienen, so wird derjenige, der sein Aas berührt, unrein bis zum Abend. ");
INSERT INTO deutkw_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Und wer etwas von seinem Aase genießt, muß seine Kleider waschen und bleibt unrein bis zum Abend; und wer sein Aas trägt, muß seine Kleider waschen und bleibt unrein bis zum Abend. ");
INSERT INTO deutkw_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Alle kleinen Tiere, die sich auf der Erde tummeln, sind als ein Greuel zu betrachten und dürfen nicht gegessen werden. ");
INSERT INTO deutkw_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Alle, die auf dem Bauche kriechen, und alle, die auf vieren gehen, sowie alle die, welche noch mehr Füße haben, von allen den kleinen Tieren, die sich auf der Erde tummeln, die dürft ihr nicht essen, denn sie sind als ein Greuel zu betrachten. ");
INSERT INTO deutkw_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Macht euch nicht selbst abscheulich durch irgend welche kriechenden Tiere und verunreinigt euch nicht durch sie, so daß ihr unrein durch sie werdet. ");
INSERT INTO deutkw_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Denn ich bin Jahwe, euer Gott; so erweist euch denn heilig und seid heilig, denn ich bin heilig! Und verunreinigt euch nicht selbst durch irgend welche kleinen Tiere, von denen es auf Erden wimmelt. ");
INSERT INTO deutkw_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Denn ich bin Jahwe, der euch aus Ägypten hinweggeführt hat, um euer Gott zu sein; darum sollt ihr heilig sein, denn ich bin heilig. ");
INSERT INTO deutkw_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Das sind die Bestimmungen in betreff der Vierfüßler und der Vögel und aller der Lebewesen, die sich im Wasser tummeln, und aller der Wesen, die sich auf der Erde regen, ");
INSERT INTO deutkw_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","damit man unterscheide zwischen dem, was unrein, und dem, was rein ist, sowie zwischen den eßbaren Tieren und den Tieren, welche nicht gegessen werden dürfen. ");
INSERT INTO deutkw_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Sprich zu den Israeliten und gebiete ihnen: Wenn ein Weib niederkommt und einen Knaben gebiert, so bleibt sie sieben Tage unrein; ebenso lange, als ihre Unreinigkeit infolge des Monatsflusses währt, ist sie unrein. ");
INSERT INTO deutkw_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Am achten Tag aber ist seine Vorhaut zu beschneiden. ");
INSERT INTO deutkw_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Sodann muß sie 33 Tage lang im Reinigungsblute bleiben; sie darf nichts Heiliges berühren und nicht ins Heiligtum kommen, bis die Zeit ihrer Reinigung um ist. ");
INSERT INTO deutkw_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Gebiert sie aber ein Mädchen, so bleibt sie auf zwei Wochen unrein, wie bei ihrer monatlichen Unreinigkeit, und 66 Tage muß sie im Reinigungsblute bleiben. ");
INSERT INTO deutkw_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Wenn aber die Zeit ihrer Reinigung um ist - mag es sich nun um einen Sohn oder eine Tochter handeln -, so soll sie ein einjähriges Lamm zum Brandopfer und eine junge Taube oder eine Turteltaube zum Sündopfer an die Thüre des Offenbarungszeltes zum Priester bringen. ");
INSERT INTO deutkw_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Der soll sie vor Jahwe darbringen und ihr Sühne verschaffen, so wird sie rein werden von ihrem Blutflusse. Das sind die Bestimmungen in betreff der Kindbetterinnen, mag es sich nun um einen Knaben oder um ein Mädchen handeln. ");
INSERT INTO deutkw_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Wenn sie aber zur Beschaffung eines Schafes zu arm ist, so nehme sie zwei Turteltauben oder zwei junge Tauben, eine zum Brandopfer und eine zum Sündopfer, und der Priester schaffe ihr Sühne, so wird sie rein werden. ");
INSERT INTO deutkw_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Und Jahwe redete mit Mose und Aaron also: ");
INSERT INTO deutkw_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Wenn sich auf der Haut jemandes ein Grind oder Ausschlag oder heller Fleck zeigt, und sich so eine aussätzige Stelle bildet, so ist er zu Aaron, dem Priester, oder zu einem seiner Söhne, der Priester, zu bringen. ");
INSERT INTO deutkw_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Wenn nun der Priester die betroffene Stelle auf der Haut besieht und findet, daß die Haare an der betroffenen Stelle weiß geworden sind, und daß die betroffene Stelle tiefer liegend erscheint, als die Haut, so ist es wirklicher Aussatz; sobald das der Priester sieht, muß er ihn für unrein erklären. ");
INSERT INTO deutkw_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Findet sich aber ein weißer Fleck an seiner Haut, der nicht tiefer liegend erscheint, als die Haut, und auf dem die Haare nicht weiß geworden sind, so soll der Priester den damit behafteten sieben Tage absperren. ");
INSERT INTO deutkw_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Wenn ihn dann der Priester am siebenten Tage besieht und findet, daß sich die betroffene Stelle in ihrem Aussehen gleich geblieben ist, indem das Übel nicht weiter auf der Haut um sich gegriffen hat, so soll ihn der Priester abermals sieben Tage absperren. ");
INSERT INTO deutkw_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Wenn ihn dann der Priester am siebenten Tag abermals besieht und findet, daß die betroffene Stelle blässer geworden ist, und das Übel auf der Haut nicht weiter um sich gegriffen hat, so soll ihn der Priester für rein erklären - es ist ein Ausschlag; er aber soll seine Kleider waschen, so wird er rein sein. ");
INSERT INTO deutkw_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Wenn aber der Ausschlag nach der Zeit, wo er sich dem Priester gezeigt hat, um rein zu werden, immer weiter auf der Haut um sich greift, und er sich dem Priester abermals zeigt, ");
INSERT INTO deutkw_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","und der Priester wahrnimmt, daß der Ausschlag auf der Haut um sich gegriffen hat, so soll ihn der Priester für unrein erklären: es ist Aussatz. ");
INSERT INTO deutkw_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Wenn sich eine aussätzige Stelle an einem Menschen zeigt, so soll man ihn zum Priester bringen. ");
INSERT INTO deutkw_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Und wenn der Priester wahrnimmt, daß sich ein weißer Grind auf der Haut befindet, an welchem die Haare weiß geworden sind, und daß wildes Fleisch in dem Grinde wuchert, ");
INSERT INTO deutkw_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","so erweist sich das Übel an seiner Haut als ein veralteter Aussatz, und der Priester erkläre ihn für unrein, ohne ihn erst abzusperren, denn er ist unrein. ");
INSERT INTO deutkw_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Wenn aber der Aussatz durchweg auf der Haut ausbricht, so daß der Aussatz die ganze Haut des betroffenen vom Kopfe bis zu den Füßen bedeckt, wohin auch nur der Priester blicken mag, ");
INSERT INTO deutkw_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","und der Priester wahrnimmt, daß der Aussatz den ganzen Leib bedeckt, so erkläre er den betroffenen für rein: er ist ganz und gar rein geworden und ist somit rein. ");
INSERT INTO deutkw_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Sobald sich aber wildes Fleisch an ihm zeigt, wird er unrein, ");
INSERT INTO deutkw_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","und wenn der Priester das wilde Fleisch erblickt, so erkläre er ihn für unrein; denn das wilde Fleisch ist unrein: es ist Aussatz. ");
INSERT INTO deutkw_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Wenn jedoch das wilde Fleisch wieder verschwindet, und er wird weiß, so soll er sich zum Priester begeben. ");
INSERT INTO deutkw_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Wenn ihn dann der Priester besieht und findet, daß die betroffene Stelle weiß geworden ist, so erkläre der Priester den betroffenen für rein; denn er ist rein. ");
INSERT INTO deutkw_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Wenn sich an der Haut jemandes ein Geschwür bildet und wieder heilt, ");
INSERT INTO deutkw_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","dann aber an der Stelle des Geschwürs ein weißer Grind entsteht oder ein weiß-rötlicher Fleck, so zeige er sich dem Priester. ");
INSERT INTO deutkw_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Wenn dann der Priester wahrnimmt, daß er niedriger aussieht, als die Haut, und daß die Haare daran weiß geworden sind, so erkläre ihn der Priester für unrein; es ist wirklicher Aussatz, der in dem Geschwür ausgebrochen ist. ");
INSERT INTO deutkw_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Wenn aber der Priester bei der Besichtigung des Flecks findet, daß sich keine weißen Haare an ihm befinden, daß er nicht niedriger ist, als die Haut, und daß er blässer geworden ist, so soll ihn der Priester sieben Tage lang absperren. ");
INSERT INTO deutkw_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Wenn dann der Fleck immer weiter auf der Haut um sich greift, so erkläre ihn der Priester für unrein; die Stelle ist vom Aussatze betroffen. ");
INSERT INTO deutkw_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Blieb aber der helle Fleck auf dieselbe Stelle beschränkt, ohne weiter um sich zu greifen, so ist es die Narbe des Geschwürs, und der Priester erkläre ihn für rein. ");
INSERT INTO deutkw_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Oder wenn sich an der Haut jemandes eine Brandwunde befindet, und das in der Brandwunde wachsende Fleisch sich als ein weiß-rötlicher oder weißer Fleck erzeigt, ");
INSERT INTO deutkw_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","und der Priester bei dessen Besichtigung findet, daß die Haare an dem hellen Flecke weiß geworden sind, und daß er tiefer liegend erscheint, als die Haut, so ist es der Aussatz, der in der Brandwunde ausgebrochen ist, und der Priester erkläre ihn für unrein; es ist wirklicher Aussatz. ");
INSERT INTO deutkw_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Wenn aber der Priester bei seiner Besichtigung findet, daß sich an dem hellen Flecke keine weißen Haare befinden, daß er nicht niedriger ist, als die Haut, und daß er blässer geworden ist, so sperre ihn der Priester sieben Tage lang ab. ");
INSERT INTO deutkw_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Wenn ihn dann der Priester am siebenten Tage besieht, so muß ihn der Priester, wenn der Fleck immer weiter auf der Haut um sich greift, für unrein erklären - es ist wirklicher Aussatz. ");
INSERT INTO deutkw_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Blieb aber der helle Fleck auf dieselbe Stelle beschränkt, ohne weiter auf der Haut um sich zu greifen, und ist er blässer geworden, so ist es der Grind der Brandwunde, und der Priester mag ihn für rein erklären, denn es ist nur die Narbe der Brandwunde. ");
INSERT INTO deutkw_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Wenn bei einem Mann oder Weib am Kopf oder am Bart ein Mal entsteht, ");
INSERT INTO deutkw_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","und der Priester das Mal besieht und findet, daß es tiefer liegend erscheint, als die Haut, und daß sich dünne, goldgelbe Haare daran befinden, so erkläre ihn der Priester für unrein; es ist der bösartige Grind - der Aussatz des Kopfes oder des Bartes. ");
INSERT INTO deutkw_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Wenn aber der Priester bei der Besichtigung der von dem bösen Grind betroffenen Stelle findet, daß sie zwar nicht tiefer liegend erscheint, als die Haut, daß sich aber keine schwarzen Haare an ihr befinden, so soll der Priester den vom bösen Grinde betroffenen sieben Tage lang absperren. ");
INSERT INTO deutkw_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Wenn nun der Priester die betroffene Stelle am siebenten Tage besieht und findet, daß der böse Grind nicht weiter um sich gegriffen hat, daß keine goldgelben Haare an ihm entstanden sind, und daß der böse Grind nicht tiefer liegend erscheint, als die Haut, ");
INSERT INTO deutkw_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","so soll er sich bescheren - nur den bösen Grind soll er nicht bescheren -; dann soll der Priester den mit dem bösen Grinde behafteten abermals sieben Tage absperren. ");
INSERT INTO deutkw_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Wenn nun der Priester den bösen Grind am siebenten Tage besieht und findet, daß der böse Grind nicht weiter auf der Haut um sich gegriffen hat und daß er nicht tiefer liegend erscheint, als die Haut, so soll ihn der Priester für rein erklären; und er wasche seine Kleider, so wird er rein sein. ");
INSERT INTO deutkw_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Wenn jedoch der böse Grind, nachdem der betreffende für rein erklärt war, immer weiter auf der Haut um sich greift, ");
INSERT INTO deutkw_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","und der Priester besieht ihn und findet, daß der böse Grind weiter auf der Haut um sich gegriffen hat, so braucht der Priester nicht erst nach dem goldgelben Haar zu suchen - er ist unrein. ");
INSERT INTO deutkw_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Wenn sich aber der böse Grind in seinem Aussehen gleich geblieben ist, und schwarze Haare auf ihm gewachsen sind, so ist der böse Grind geheilt: er ist rein, und der Priester soll ihn für rein erklären. ");
INSERT INTO deutkw_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Wenn sich bei einem Mann oder Weib auf der Haut helle Flecken, weiße helle Flecken zeigen, ");
INSERT INTO deutkw_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","und der Priester findet bei der Besichtigung auf ihrer Haut verblaßte helle weiße Flecken, so ist es der gutartige Ausschlag, der auf der Haut ausgebrochen ist: ein solcher ist rein. ");
INSERT INTO deutkw_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Wenn jemandes Haupt kahl wird, so ist er ein Hinter-Glatzkopf: ein solcher ist rein. ");
INSERT INTO deutkw_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Und wenn sein Haupt auf der Vorderseite kahl wird, so ist er ein Vorder-Glatzkopf: ein solcher ist rein. ");
INSERT INTO deutkw_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Wenn sich aber an der Hinterglatze oder an der Vorderglatze ein weiß-rötlicher Ausschlag zeigt, so ist es Aussatz, der an seiner Hinter- oder Vorderglatze ausbricht. ");
INSERT INTO deutkw_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Wenn ihn nun der Priester besieht und findet einen weiß-rötlichen Grind auf seiner Hinter- oder Vorderglatze, der aussieht, wie Aussatz auf der bloßen Haut - ");
INSERT INTO deutkw_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ein solcher ist aussätzig. Er ist unrein; der Priester soll ihn ohne weiteres für unrein erklären: er hat das Übel auf seinem Haupte. ");
INSERT INTO deutkw_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Es soll aber der Aussätzige, der das Übel an sich hat, in zerrissenen Kleidern einhergehen, sein Haupthaar fliegen lassen, den Bart verhüllen und “unrein! unrein!” rufen. ");
INSERT INTO deutkw_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Die ganze Zeit, in der er das Übel an sich hat, bleibt er unrein. Unrein ist er; abgesondert muß er wohnen: außerhalb des Lagers soll er sich aufhalten. ");
INSERT INTO deutkw_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Wenn sich aber an einem Kleid eine aussätzige Stelle zeigt - sei es nun an einem wollenen oder linnenen Kleid -, ");
INSERT INTO deutkw_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","oder an einem linnenen oder wollenen Gewebe oder Gewirke oder an Leder oder an irgend etwas aus Leder Gefertigtem, ");
INSERT INTO deutkw_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","und es ist die betroffene Stelle an dem Kleid oder dem Leder oder dem Gewebe oder dem Gewirke oder an irgend welchem ledernen Gegenstande grünlich oder rötlich, so liegt ein Fall von Aussatz vor, und man zeige es dem Priester. ");
INSERT INTO deutkw_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Und wenn der Priester die betroffene Stelle besichtigt hat, so schließe er das vom Ausschlage betroffene sieben Tage ein. ");
INSERT INTO deutkw_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Wenn er dann am siebenten Tage wahrnimmt, daß der Ausschlag auf dem Kleid oder dem Gewebe oder dem Gewirke oder dem Leder - an irgend etwas, wozu das Leder verarbeitet zu werden pflegt, - weiter um sich gegriffen hat, so ist der Ausschlag ein bösartiger Aussatz. Derartiges ist unrein, ");
INSERT INTO deutkw_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","und man soll das Kleid oder das in Wolle oder Linnen Gewebte oder Gewirkte oder jederlei ledernen Gegenstand, an dem sich der Ausschlag zeigt, verbrennen; denn es ist ein bösartiger Aussatz, verbrannt muß es werden. ");
INSERT INTO deutkw_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Wenn es aber der Priester besieht und findet, daß der Ausschlag auf dem Kleid oder dem Gewebe ober dem Gewirke über irgend welchem ledernen Gegenstande nicht um sich gegriffen hat, ");
INSERT INTO deutkw_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","so gebiete der Priester, daß man das, woran sich der Ausschlag findet, wasche, und schließe es dann abermals sieben Tage ein. ");
INSERT INTO deutkw_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Wenn es dann der Priester, nachdem die betroffene Stelle ausgewaschen worden war, besichtigt und findet, daß sich das Aussehen der betroffenen Stelle nicht verändert hat, wenn auch der Ausschlag nicht weiter um sich gegriffen hat, so ist es unrein; man muß es verbrennen - es ist eine Einfressung, sei es nun an seiner Hinter- oder an seiner Vorderseite. ");
INSERT INTO deutkw_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Wenn aber der Priester bei der Besichtigung findet, daß die betroffene Stelle, nachdem man sie ausgewaschen hat, verblaßt ist, so soll man sie aus dem Kleid oder Leder oder Gewebe oder Gewirke herausreißen. ");
INSERT INTO deutkw_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Und wenn sich an dem Kleid oder Gewebe oder Gewirke oder an irgend welchem ledernen Gegenstand abermals Aussatz zeigt, so ist es ein frisch ausbrechender; man muß das, was mit dem Ausschlage behaftet ist, verbrennen. ");
INSERT INTO deutkw_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Die Kleider aber oder Gewebe oder Gewirke oder ledernen Gegenstände jeder Art, von denen der Ausschlag, nachdem man sie gewaschen hat, verschwunden ist, müssen nochmals gewaschen werden, so werden sie rein sein. ");
INSERT INTO deutkw_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Das sind die Bestimmungen über den Aussatz an einem wollenen oder linnenen Kleid oder Gewebe oder Gewirke oder an irgend einem ledernen Gegenstande, wiefern sie für rein oder unrein zu erklären sind. ");
INSERT INTO deutkw_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Dies sind die Bestimmungen in betreff des Aussätzigen zur Zeit seiner Reinigung: Er soll zum Priester gebracht werden; ");
INSERT INTO deutkw_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","und zwar muß der Priester zu ihm hinaus vor das Lager gehen. Wenn nun der Priester bei der Besichtigung findet, daß die vom Aussatze betroffene Stelle am Aussätzigen heil geworden ist, ");
INSERT INTO deutkw_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","so soll der Priester Befehl geben, daß man für den, der sich reinigen läßt, zwei lebendige reine Vögel, Cedernholz, Karmesin und Ysop bringe. ");
INSERT INTO deutkw_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Sodann soll der Priester Befehl geben, daß man den einen Vogel schlachte, in ein irdenes Gefäß über lebendigem Wasser. ");
INSERT INTO deutkw_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Den lebendigen Vogel aber, das Cedernholz, den Karmesin und Ysop soll er nehmen und es samt dem lebendigen Vogel in das Blut des über dem lebendigen Wasser geschlachteten Vogels eintauchen. ");
INSERT INTO deutkw_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Sodann soll er den, der sich vom Aussatze reinigen läßt, siebenmaI besprengen und ihn so reinigen; den lebendigen Vogel aber lasse er ins freie Feld fliegen. ");
INSERT INTO deutkw_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Und der, welcher sich reinigen läßt, muß seine Kleider waschen, alle seine Haare abscheren und sich baden, so wird er rein werden. Darnach darf er hineingehen ins Lager, muß aber noch sieben Tage außerhalb seines Zeltes bleiben. ");
INSERT INTO deutkw_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Am siebenten Tag aber soll er alle seine Haare abscheren - Haupt, Bart und Augenbrauen, kurz alle seine Haare soll er abscheren; sodann soll er seine Kleider waschen und seinen Leib baden, so wird er rein werden. ");
INSERT INTO deutkw_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Am achten Tag aber soll er zwei fehllose Lämmer nehmen und ein einjähriges, fehlloses weibliches Lamm, nebst drei Zehntel Feinmehl, das mit Öl angemacht ist, zum Speisopfer und einem Log Öl. ");
INSERT INTO deutkw_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Und der Priester, der die Reinigung vollzieht, soll den Mann, der sich reinigen läßt, und diese Dinge Jahwe darstellen an der Thüre des Offenbarungszeltes. ");
INSERT INTO deutkw_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Sodann soll der Priester das eine Lamm nehmen und es zum Schuldopfer darbringen mit dem Log Öl und soll beides als Webe vor Jahwe weben. ");
INSERT INTO deutkw_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Und zwar soll man das Lamm da schlachten, wo man die Sündopfer und die Brandopfer zu schlachten pflegt, an heiliger Stätte; denn wie das Sündopfer, so gehört auch das Schuldopfer dem Priester: hochheilig ist es. ");
INSERT INTO deutkw_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Sodann nehme der Priester etwas von dem Blute des Schuldopfers und der Priester streiche es dem, der sich reinigen läßt, an den rechten Ohrknorpel, den Daumen der rechten Hand und die große Zehe des rechten Fußes. ");
INSERT INTO deutkw_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Alsdann nehme der Priester etwas von dem Log Öl und gieße es auf seine - des Priesters - linke Hand. ");
INSERT INTO deutkw_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Sodann tauche der Priester seinen rechten Finger in das Öl, das in seiner linken Hand ist, und sprenge von dem Öl mit seinem Finger siebenmal vor Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Von dem übrigen Öl aber, das in seiner Hand ist, streiche der Priester dem, der sich reinigen läßt, etwas an den rechten Ohrknorpel, an den Daumen der rechten Hand und die große Zehe des rechten Fußes, oben auf das Blut des Schuldopfers. ");
INSERT INTO deutkw_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Und was noch übrig ist von dem Öl in der Hand des Priesters, das thue er auf das Haupt dessen, der sich reinigen läßt, damit ihm so der Priester Sühne schaffe vor Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Sodann soll der Priester das Sündopfer herrichten, um dem, der sich reinigen läßt, Sühne zu schaffen wegen seiner Unreinigkeit; darnach soll er das Brandopfer schlachten. ");
INSERT INTO deutkw_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Und der Priester soll das Brandopfer samt dem Speisopfer auf dem Altar darbringen; und wenn ihm so der Priester Sühne geschafft hat, wird er rein werden. ");
INSERT INTO deutkw_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Wenn er aber arm ist und nicht so viel zu leisten vermag, so nehme er ein Lamm als Schuldopfer, damit es gewebt und ihm Sühne geschafft werde, dazu ein Zehntel Feinmehl, mit Öl angemacht, zum Speisopfer und ein Log Öl, ");
INSERT INTO deutkw_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","ferner zwei Turteltauben oder zwei junge Tauben - was er zu leisten vermag -, damit die eine als Sündopfer, die andere als Brandopfer diene. ");
INSERT INTO deutkw_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Und zwar soll er sie am achten Tage, nachdem er rein geworden, zum Priester bringen, an die Thüre des Offenbarungszeltes vor Jahwe; ");
INSERT INTO deutkw_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","und der Priester nehme das Schuldopferlamm nebst dem Log Öl und der Priester webe beides als Webe vor Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Sodann schlachte man das Schuldopferlamm, und der Priester nehme etwas von dem Blute des Schuldopfers und streiche es dem, der sich reinigen läßt, an den rechten Ohrknorpel, den Daumen der rechten Hand und die große Zehe des rechten Fußes. ");
INSERT INTO deutkw_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Von dem Öl aber gieße der Priester etwas in seine - des Priesters - linke Hand ");
INSERT INTO deutkw_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","und es sprenge der Priester von dem Öl, das in seiner linken Hand ist, mit seinem rechten Finger siebenmal vor Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Sodann streiche der Priester etwas von dem Öl, das in seiner Hand ist, dem, der sich reinigen läßt, an den rechten Ohrknorpel, den Daumen der rechten Hand und die große Zehe des rechten Fußes, auf die mit dem Blute des Schuldopfers bestrichene Stelle. ");
INSERT INTO deutkw_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Und was noch übrig ist von dem Öl in der Hand des Priesters, das thue er auf das Haupt dessen, der sich reinigen läßt, damit er ihm Sühne schaffe vor Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Sodann soll er die eine von den Turteltauben oder von den jungen Tauben, die er zu leisten vermochte, herrichten, ");
INSERT INTO deutkw_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","- die eine als Sündopfer, die andere als Brandopfer, samt dem Speisopfer, und so soll der Priester dem, der sich reinigen läßt, Sühne schaffen vor Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Das sind die Bestimmungen in betreff dessen, der mit Aussatz behaftet ist, bei seiner Reinigung aber nicht so viel zu leisten vermag. ");
INSERT INTO deutkw_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Und Jahwe redete mit Mose und Aaron also: ");
INSERT INTO deutkw_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","Wenn ihr ins Land Kanaan kommt, das ich euch zu eigen geben will, und ich lasse in dem Lande, das ihr zu eigen habt, an irgend einem Hause eine aussätzige Stelle entstehen, ");
INSERT INTO deutkw_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","so soll der, dem das Haus gehört, hingehen und es dem Priester melden und sprechen: An meinem Hause zeigt sich etwas wie Aussatz! ");
INSERT INTO deutkw_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","So soll dann der Priester Befehl geben, das Haus auszuräumen, bevor der Priester hineingeht, um die betreffende Stelle zu besichtigen, damit nicht etwa alles, was sich im Hause befindet, für unrein erklärt werden muß. Alsdann soll der Priester hineingehen, um das Haus zu besehen. ");
INSERT INTO deutkw_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Wenn er nun bei der Besichtigung der aussätzigen Stellen wahrnimmt, daß sich dieselben an den Wänden des Hauses befinden in Gestalt grünlicher oder rötlicher Grübchen, die tiefer zu liegen scheinen, als die Wandfläche, ");
INSERT INTO deutkw_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","so soll der Priester aus dem Hause heraus an die Thüre des Hauses gehen und das Haus auf sieben Tage verschließen. ");
INSERT INTO deutkw_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Wenn dann der Priester am siebenten Tage wiederkehrt und bei der Besichtigung findet, daß der Aussatz an den Wänden des Hauses weiter um sich gegriffen hat, ");
INSERT INTO deutkw_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","so soll der Priester Befehl geben, daß man die Steine, an denen sich der Aussatz zeigt, herausreißt und draußen vor der Stadt an einen unreinen Ort wirft. ");
INSERT INTO deutkw_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Das Haus selbst aber soll man inwendig ringsum abkratzen und den abgekratzten Lehm draußen vor der Stadt an einen unreinen Ort schütten. ");
INSERT INTO deutkw_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Sodann soll man andere Steine nehmen und an Stelle jener Steine einsetzen; ebenso soll man anderen Lehm nehmen und das Haus bewerfen. ");
INSERT INTO deutkw_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Wenn dann der Aussatz abermals am Hause hervorbricht, nachdem man die Steine herausgerissen, das Haus abgekratzt und neu beworfen hat, ");
INSERT INTO deutkw_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","so soll der Priester hineingehen, und wenn er bei der Besichtigung findet, daß der Aussatz weiter um sich gegriffen hat am Hause, so ist es ein bösartiger Aussatz an dem Hause: dasselbe ist unrein. ");
INSERT INTO deutkw_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Und man soll das Haus abbrechen, die zu ihm gehörenden Steine, Balken und den gesamten Lehmbewurf am Hause, und soll es hinausschaffen an einen unreinen Ort draußen vor der Stadt. ");
INSERT INTO deutkw_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Und wer das Haus betritt, so lange es verschlossen ist, der soll für unrein gelten bis zum Abend. ");
INSERT INTO deutkw_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Und wer in dem Hause geschlafen hat, der muß seine Kleider waschen; und wer in dem Hause gegessen hat, der muß seine Kleider waschen. ");
INSERT INTO deutkw_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Wenn aber der Priester hineinkommen und bei der Besichtigung finden sollte, daß der Aussatz nicht weiter am Hause um sich gegriffen hat, nachdem das Haus neu beworfen war, so soll der Priester das Haus für rein erklären, denn der Schaden ist geheilt. ");
INSERT INTO deutkw_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","So soll er dann, um das Haus zu entsündigen, zwei Vögel, Cedernholz, Karmesin und Ysop nehmen. ");
INSERT INTO deutkw_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Den einen Vogel schlachte er in ein irdenes Gefäß über lebendigem Wasser; ");
INSERT INTO deutkw_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","das Cedernholz aber, den Ysop, den Karmesin und den lebendigen Vogel soll er nehmen und in das Blut des geschlachteten Vogels und in das lebendige Wasser tauchen und das Haus siebenmal besprengen ");
INSERT INTO deutkw_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","und soll so das Haus mit dem Blute des Vogels und mit dem lebendigen Wasser, sowie mit dem lebendigen Vogel, dem Cedernholz, dem Ysop und dem Karmesin entsündigen. ");
INSERT INTO deutkw_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Den lebendigen Vogel aber lasse er hinaus vor der Stadt ins freie Feld fliegen und schaffe so dem Hause Sühne: so wird es rein werden. ");
INSERT INTO deutkw_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Das sind die Bestimmungen in betreff der verschiedenen Arten des Aussatzes und in betreff des Grindes, ");
INSERT INTO deutkw_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","sowie des Aussatzes an Kleidern und Häusern, ");
INSERT INTO deutkw_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","der Hautmale, des Schorfs und der weißen Flecken, ");
INSERT INTO deutkw_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","um darüber zu belehren, wenn etwas unrein oder rein ist. Das sind die Bestimmungen in betreff des Aussatzes. ");
INSERT INTO deutkw_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Und Jahwe redete mit Mose und Aaron also: ");
INSERT INTO deutkw_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Redet mit den Israeliten und sprecht zu ihnen: wenn irgend jemand an seiner Scham einen Fluß hat, so ist solches ein unreiner Fluß. ");
INSERT INTO deutkw_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Und zwar verhält es sich so mit seiner Unreinigkeit infolge seines Flusses: Mag nun der Fluß aus seiner Scham im Gange sein oder seine Scham verstopft sein, so daß nichts ausfließt - es liegt Unreinigkeit bei ihm vor. ");
INSERT INTO deutkw_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Alles Lager, auf dem der Flüssige liegt, wird unrein, und alles Geräte, auf dem er sitzt, wird unrein. ");
INSERT INTO deutkw_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Wer sein Lager berührt, muß seine Kleider waschen und sich baden und bleibt unrein bis zum Abend. ");
INSERT INTO deutkw_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Und wer sich auf das Geräte setzt, auf dem der Flüssige saß, muß seine Kleider waschen und sich baden und bleibt unrein bis zum Abend. ");
INSERT INTO deutkw_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Und wer den Leib des Flüssigen berührt, muß seine Kleider waschen und sich baden und bleibt unrein bis zum Abend. ");
INSERT INTO deutkw_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Und wenn der Flüssige seinen Speichel auf einen Reinen wirft, so muß dieser seine Kleider waschen und sich baden und bleibt unrein bis zum Abend. ");
INSERT INTO deutkw_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Und jeder Sattel, auf dem der Flüssige reitet, wird unrein. ");
INSERT INTO deutkw_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Und wer irgend etwas von dem berührt, was sich unter ihm befindet, der wird unrein bis zum Abend. Und wer es fortträgt, muß seine Kleider waschen und sich baden und bleibt unrein bis zum Abend. ");
INSERT INTO deutkw_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Und jeder, den der Flüssige berührt, ohne zuvor seine Hände mit Wasser abgespült zu haben, der muß seine Kleider waschen und sich baden und bleibt unrein bis zum Abend. ");
INSERT INTO deutkw_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Irdene Gefäße, die der Flüssige berührt, müssen zerbrochen, alle hölzernen Gefäße aber mit Wasser abgespült werden. ");
INSERT INTO deutkw_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Wenn aber der Flüssige rein wird von seinem Flusse, so soll er von da ab, wo er rein wurde, sieben Tage zählen; alsdann soll er seine Kleider waschen und seinen Leib in lebendigem Wasser baden - so wird er rein werden. ");
INSERT INTO deutkw_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Am achten Tag aber nehme er zwei Turteltauben oder zwei junge Tauben, gehe hin vor Jahwe an die Thüre des Offenbarungszeltes und übergebe sie dem Priester. ");
INSERT INTO deutkw_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Der Priester aber soll sie herrichten, die eine als Sündopfer und die andere als Brandopfer; und so soll ihm der Priester Sühne schaffen vor Jahwe wegen seines Flusses. ");
INSERT INTO deutkw_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Wenn jemandem der Same entgeht, so muß er seinen Leib baden und bleibt unrein bis zum Abend. ");
INSERT INTO deutkw_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Und alles Kleid und alles Leder, an das solcher Same kommt, muß gewaschen werden und bleibt unrein bis zum Abend. ");
INSERT INTO deutkw_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Und wenn einer bei einem Weibe liegt und Samenerguß erfolgt, so müssen sie sich baden und bleiben unrein bis zum Abend. ");
INSERT INTO deutkw_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Wenn ein Weib flüssig wird, indem sie ihres Leibes Blutfluß hat, so haftet an ihr die Unreinigkeit sieben Tage lang, und jeder, der Sie berührt, wird unrein bis zum Abend. ");
INSERT INTO deutkw_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Und alles, worauf sie liegt während ihrer Unreinigkeit, wird unrein; und alles, worauf sie sitzt, wird unrein. ");
INSERT INTO deutkw_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Und jeder, der ihr Lager berührt, muß seine Kleider waschen und sich baden und bleibt unrein bis zum Abend. ");
INSERT INTO deutkw_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Und jeder, der irgend ein Geräte berührt, auf dem Sie saß, muß seine Kleider waschen und sich baden und bleibt unrein bis zum Abend. ");
INSERT INTO deutkw_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Und wenn er etwas berührt, was sich auf dem Lager oder auf dem Geräte befindet, auf dem sie sitzt, so wird er unrein bis, zum Abend. ");
INSERT INTO deutkw_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Und wenn einer bei ihr liegen sollte und von ihrer Unreinigkeit an ihn kommt, so bleibt er sieben Tage lang unrein, und alles Lager, auf dem er liegt, wird unrein. ");
INSERT INTO deutkw_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Wenn aber ein Weib lange Zeit hindurch den Blutfluß hat, außer der Zeit ihrer gewöhnlichen Unreinigkeit, oder wenn Sie blutflüssig bleibt über die Zeit ihrer gewöhnlichen Unreinigkeit hinaus, so gilt von ihr die ganze Zeit hindurch, die sie an dem unreinen Flusse leidet, dasselbe, wie zur Zeit ihrer gewöhnlichen Unreinigkeit: Sie ist unrein. ");
INSERT INTO deutkw_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Alles Lager, auf dem sie liegt, so lange Sie an dem Flusse leidet, hat ihr zu gelten, wie das Lager zur Zeit ihrer gewöhnlichen Unreinigkeit, und alles Geräte, auf dem sie sitzt, wird unrein, wie es unrein wird bei ihrer gewöhnlichen Unreinigkeit. ");
INSERT INTO deutkw_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Wer diese Dinge berührt, wird unrein; er muß seine Kleider waschen und sich baden und bleibt unrein bis zum Abend. ");
INSERT INTO deutkw_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Wenn sie aber rein geworden ist von ihrem Fluß, so soll sie noch sieben Tage zählen: darnach soll sie als rein gelten. ");
INSERT INTO deutkw_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Und am achten Tage soll sie zwei Turteltauben oder zwei junge Tauben nehmen und dieselben zum Priester bringen an die Thüre des Offenbarungszeltes. ");
INSERT INTO deutkw_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Und der Priester soll die eine als Sündopfer, die andere als Brandopfer herrichten, und so soll ihr der Priester vor Jahwe Sühne schaffen wegen ihres unreinen Flusses. ");
INSERT INTO deutkw_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","So sollst du die Israeliten verwarnen in betreff ihrer Unreinigkeit, damit Sie nicht sterben infolge ihrer Unreinigkeit, indem Sie meine Wohnung verunreinigen, die unter ihnen ist. ");
INSERT INTO deutkw_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Das sind die Bestimmungen in betreff des Flüssigen und dessen, dem der Same entgeht, so daß er dadurch unrein wird; ");
INSERT INTO deutkw_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","und in betreff derjenigen, die an ihrer gewöhnlichen Unreinigkeit leidet, und dessen, der einen Fluß hat, es sei ein Mann oder ein Weib, sowie dessen, der bei einer Unreinen liegt. ");
INSERT INTO deutkw_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Und Jahwe redete mit Mose nach dem Tode der beiden Söhne Aarons, als sie vor Jahwe getreten waren und sterben mußten. ");
INSERT INTO deutkw_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Und Jahwe sprach zu Mose: Sage deinem Bruder Aaron, daß er nicht zu jeder beliebigen Zeit hineingehen darf in das Heiligtum innerhalb des Vorhangs, vor die Deckplatte hin, die sich über der Lade befindet - sonst muß er sterben! Denn in der Wolke erscheine ich über der Deckplatte. ");
INSERT INTO deutkw_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Nur unter der Bedingung darf Aaron in das Heiligtum hineingehen, daß er einen jungen Stier als Sündopfer und einen Widder als Brandopfer darbringt; ");
INSERT INTO deutkw_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","einen heiligen linnenen Leibrock muß er anhaben, linnene Beinkleider müssen seine Scham bedecken, mit einem linnenen Gürtel muß er sich gürten und einen linnenen Kopfbund umbinden. Heilige Kleider sind es - er soll sie anlegen, nachdem er seinen Leib gebadet hat. ");
INSERT INTO deutkw_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Von der Gemeinde der Israeliten aber soll er zwei Ziegenböcke zum Sündopfer und einen Widder zum Brandopfer nehmen. ");
INSERT INTO deutkw_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Sodann soll Aaron seinen eigenen Sündopfer-Farren herzubringen und sich und seinem Hause Sühne schaffen. ");
INSERT INTO deutkw_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Dann soll er die beiden Böcke nehmen und Sie Jahwe darstellen an der Thüre des OffenbarungszeItes. ");
INSERT INTO deutkw_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Und Aaron soll über die beiden Böcke das Los werfen: ein Los für Jahwe und ein Los für Asasel. ");
INSERT INTO deutkw_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Sodann soll Aaron den Bock, der durch das Los für Jahwe bestimmt worden ist, herzubringen und ihn als Sündopfer herrichten. ");
INSERT INTO deutkw_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Der Bock aber, der durch das Los für Asasel bestimmt ward, ist Jahwe lebendig darzustellen, damit man die Sühnegebräuche über ihm vollziehe und ihn dem Asasel in die Wüste schicke. ");
INSERT INTO deutkw_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","So soll also Aaron seinen eigenen Sündopfer-Farren herzubringen und sich und seinem Hause Sühne schaffen und soll seinen Sündopfer-Farren schlachten. ");
INSERT INTO deutkw_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Sodann aber soll er eine Pfanne voll glühender Kohlen von dem Altar, der vor Jahwe steht, hinwegnehmen und feingestoßenes wohlriechendes Räucherwerk, so viel er mit seinen beiden Händen zu fassen vermag, und soll es hinein hinter den Vorhang bringen. ");
INSERT INTO deutkw_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Sodann soll er das Räucherwerk vor Jahwe auf das Feuer thun, damit die Wolke von dem Räucherwerk die Deckplatte, die sich über dem Gesetze befindet, verhülle, und er nicht sterben müsse. ");
INSERT INTO deutkw_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Sodann nehme er etwas von dem Blute des Farren und sprenge es mit seinem Finger oben auf die Vorderseite der Deckplatte; vor die Deckplatte hin aber sprenge er mit seinem Finger siebenmal von dem Blute. ");
INSERT INTO deutkw_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Sodann schlachte er den Sündopferbock des Volks und bringe sein Blut hinein hinter den Vorhang und verfahre mit seinem Blute so, wie er mit dem Blute des Farren verfuhr, und sprenge es auf die Deckplatte und vor die Deckplatte hin ");
INSERT INTO deutkw_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","und entsündige so das Heiligtum von wegen der Unreinigkeiten der Israeliten und der Übertretungen, die sie irgend begangen haben, und ebenso verfahre er mit dem Offenbarungszelte, das bei ihnen weilt inmitten ihrer Unreinigkeiten. ");
INSERT INTO deutkw_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Es darf aber gar niemand im Offenbarungszelte zugegen sein, wenn er hineingeht, um die Sühnegebräuche im Heiligtum zu vollziehen, bis er wieder hinausgeht, und so soll er sich und seinem Hause und der ganzen Gemeinde Israel Sühne schaffen. ");
INSERT INTO deutkw_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Sodann soll er hinausgehen an den Altar, der vor Jahwe steht, und ihn entsündigen; und zwar soll er etwas von dem Blute des Farren und dem Blute des Bockes nehmen und ringsum an die Hörner des Altars streichen ");
INSERT INTO deutkw_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","und soll mit seinem Finger siebenmal etwas von dem Blut auf ihn sprengen und ihn so reinigen und weihen von wegen der Unreinigkeit der Israeliten. ");
INSERT INTO deutkw_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Wenn er so die Entsündigung des Heiligtums und des Offenbarungszeltes und des Altars vollendet hat, so bringe er den lebendigen Bock herzu. ");
INSERT INTO deutkw_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Und Aaron soll seine beiden Hände auf den Kopf des lebendigen Bockes aufstemmen und über ihm alle Verschuldungen der Israeliten bekennen und alle Übertretungen, die Sie irgend begangen haben, und soll sie auf den Kopf des Bockes legen und diesen durch einen bereitgehaltenen Mann in die Wüste entsenden. ");
INSERT INTO deutkw_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","So soll der Bock alle ihre Verschuldungen auf sich hinwegtragen in eine abgelegene Gegend, und man soll den Bock erst in der Wüste loslassen. ");
INSERT INTO deutkw_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Und Aaron soll hineingehen ins Offenbarungszelt und die linnenen Kleider ausziehen, die er angelegt hatte, als er in das Heiligtum hineinging, und sie dort niederlegen. ");
INSERT INTO deutkw_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Sodann soll er seinen Leib an heiliger Stätte baden und seine Kleider anziehen; dann soll er herauskommen und sein und des Volkes Brandopfer herrichten, um sich und dem Volke Sühne zu schaffen. ");
INSERT INTO deutkw_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Das Fett des Sündopfers aber soll er auf dem Altar in Rauch aufgehen lassen. ");
INSERT INTO deutkw_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Und der, welcher den Bock zu Asasel hinausgeschafft hat, muß seine Kleider waschen und seinen Leib baden; darnach darf er ins Lager kommen. ");
INSERT INTO deutkw_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Den Sündopfer-Farren aber und den Sündopferbock, deren Blut hineingebracht wurde, um im Heiligtume die Sühnegebräuche zu vollziehen, soll man hinaus vor das Lager schaffen und ihr Fleisch und ihren Mist verbrennen. ");
INSERT INTO deutkw_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Und der, welcher sie verbrannt hat, muß seine Kleider waschen und seinen Leib baden; darnach darf er ins Lager kommen. ");
INSERT INTO deutkw_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Und es soll euch als eine Satzung für alle Zeiten gelten: Im siebenten Monat, am zehnten des Monats, müßt ihr euch kasteien und dürft ihr gar kein Geschäft verrichten, der Landeseingeborne, wie der Fremde, der sich unter euch aufhält. ");
INSERT INTO deutkw_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Denn an diesem Tage wird man euch Sühne schaffen, um euch zu reinigen; von allen euren Sünden sollt ihr rein werden vor Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Ein Tag unbedingter Ruhe soll es für euch sein, und ihr sollt euch kasteien kraft einer für alle Zeiten geltenden Satzung. ");
INSERT INTO deutkw_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Es soll aber die Entsündigung vollziehen der Priester, den man salben und dem man die Hand füllen wird, daß er Priesterdienst thue an Stelle seines Vaters. Und er soll die linnenen Kleider, die heiligen Kleider, anlegen ");
INSERT INTO deutkw_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","und das Allerheiligste entsündigen; und das Offenbarungszelt und den Altar soll er entsündigen und den Priestern und allen Gliedern der Gemeinde soll er Sühne schaffen. ");
INSERT INTO deutkw_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Und das soll euch als eine Satzung für alle Zeiten gelten, daß man den Israeliten einmal im Jahre Sühne schaffen soll von wegen aller ihrer Sünden. Und er that, wie Jahwe Mose befohlen hatte. ");
INSERT INTO deutkw_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Rede mit Aaron und mit seinen Söhnen und allen Israeliten und sprich zu ihnen: Dies ist's, was Jahwe geboten hat: ");
INSERT INTO deutkw_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Jedermann aus dem Hause Israel, der ein Rind oder ein Lamm oder eine Ziege schlachtet im Lager oder der sie schlachtet außerhalb des Lagers ");
INSERT INTO deutkw_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","und sie nicht hinbringt zur Thüre des Offenbarungszeltes, um sie Jahwe als Opfergabe darzubringen vor der Wohnung Jahwes, einem solchen soll es als Blutschuld angerechnet werden: Blut hat er vergossen, und ein solcher soll hinweggetilgt werden mitten aus seinen Volksgenossen, ");
INSERT INTO deutkw_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","damit die Israeliten ihre SchIachtopfer, die sie auf freiem Felde zu opfern pflegen, herbringen, und zwar sollen sie sie für Jahwe an die Thüre des Offenbarungszeltes zum Priester bringen und sollen sie als Heilsopfer für Jahwe schlachten. ");
INSERT INTO deutkw_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Und der Priester soll das Blut an den Altar Jahwes sprengen vor der Thüre des Offenbarungszeltes und soll das Fett in Rauch aufgehen lassen zum lieblichen Geruch für Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Und sie sollen ihre Schlachtopfer hinfort nicht mehr den Bocksgestalten opfern, mit denen sie Abgötterei treiben. Solches soll ihnen als eine Satzung für alle Zeiten gelten, die zu beobachten ist von Geschlecht zu Geschlecht. ");
INSERT INTO deutkw_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Und du sollst zu ihnen sprechen: Jedermann vom Hause Israel und von den Fremden, die sich unter ihnen aufhalten, der ein Brandopfer oder SchIachtopfer bringt ");
INSERT INTO deutkw_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","und es nicht hinbringt an die Thüre des Offenbarungszeltes, um es für Jahwe herzurichten, ein solcher soll hinweggetilgt werden aus seinen Volksgenossen. ");
INSERT INTO deutkw_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Und jedermann vom Hause Israel und von den Fremden, die sich unter ihnen aufhalten, der irgend Blut genießt, - gegen einen solchen, der Blut genießt, will ich mein Antlitz richten und ihn hinwegtilgen mitten aus seinen Volksgenossen. ");
INSERT INTO deutkw_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Denn das Leben des Leibes ist im Blute, und ich habe es euch verliehen für den Altar, daß man euch Sühne damit schaffe; denn das Blut bewirkt Sühne mittels des in ihm enthaltenen Lebens. ");
INSERT INTO deutkw_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Darum habe ich den Israeliten geboten: Niemand von euch darf Blut genießen! Auch der Fremde, der sich unter euch aufhält, darf kein Blut genießen. ");
INSERT INTO deutkw_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Und jedermann von den Israeliten und von den Fremden, die sich unter ihnen aufhalten, der ein Stück Wild oder Geflügel erjagt; das gegessen werden darf, der soll sein Blut auslaufen lassen und dann mit Erde bedecken. ");
INSERT INTO deutkw_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Denn das Leben eines jeden Leibes besteht in seinem das Leben enthaltenden Blute. Daher gebot ich den Israeliten: Von keinem Leibe dürft ihr das Blut genießen: Denn das Leben eines jeden Leibes besteht in seinem Blute - jeder, der es genießt, soll hinweggetilgt werden! ");
INSERT INTO deutkw_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Und jeder, der Aas oder von wilden Tieren Zerrissenes genießt, es sei ein Landeseingeborner oder ein Fremder, der muß seine Kleider waschen und sich baden und bleibt unrein bis zum Abend; dann wird er rein. ");
INSERT INTO deutkw_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Wenn er sie aber nicht wäscht und seinen Leib nicht badet, so lädt er Verschuldung auf sich. ");
INSERT INTO deutkw_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Rede mit den Israeliten und sprich zu ihnen: Ich bin Jahwe, euer Gott. ");
INSERT INTO deutkw_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Ihr dürft nicht thun, wie man im Lande Ägypten thut, in welchem ihr gewohnt habt, und ihr dürft nicht thun, wie man im Lande Kanaan thut, wohin ich euch bringen will; nach ihren Satzungen dürft ihr nicht wandeln. ");
INSERT INTO deutkw_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Nach meinen Rechten sollt ihr thun und meine Satzungen sollt ihr beobachten und nach ihnen wandeln; ich bin Jahwe, euer Gott. ");
INSERT INTO deutkw_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Darum sollt ihr meine Satzungen und meine Rechte beobachten: derjenige, der nach ihnen thut, wird durch sie leben; ich bin Jahwe! ");
INSERT INTO deutkw_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Keiner von euch darf seinen nächsten Blutsverwandten nahen, ihre Scham zu entblößen; ich bin Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Die Scham deines Vaters und die Scham deiner Mutter darfst du nicht entblößen; es ist deine Mutter, du darfst ihre Scham nicht entblößen. ");
INSERT INTO deutkw_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Die Scham des Weibes deines Vaters darfst du nicht entblößen, es ist deines Vaters Scham. ");
INSERT INTO deutkw_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Die Scham deiner Schwester, der Tochter deines Vaters oder der Tochter deiner Mutter, mag sie nun im Hause oder mag sie draußen geboren sein - du darfst ihre Scham nicht entblößen. ");
INSERT INTO deutkw_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Die Scham der Tochter deines Sohns oder der Tochter deiner Tochter - du darfst ihre Scham nicht entblößen, denn es ist deine Scham. ");
INSERT INTO deutkw_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Die Scham der Tochter des Weibes deines Vaters, die dein Vater erzeugt hat - du darfst ihre Scham nicht entblößen; sie ist deine Schwester. ");
INSERT INTO deutkw_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Die Scham der Schwester deines Vaters darfst du nicht entblößen, sie ist deines Vaters nächste Blutsverwandte. ");
INSERT INTO deutkw_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Die Scham der Schwester deiner Mutter darfst du nicht entblößen, denn sie ist deiner Mutter nächste Blutsverwandte. ");
INSERT INTO deutkw_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Die Scham des Bruders deines Vaters darfst du nicht entblößen, darfst seinem Weibe nicht nahen; sie ist deine Muhme. ");
INSERT INTO deutkw_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Die Scham deiner Schwiegertochter darfst du nicht entblößen; sie ist das Weib deines Sohns, du darfst ihre Scham nicht entblößen. ");
INSERT INTO deutkw_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Die Scham des Weibes deines Bruders darfst du nicht entblößen, es ist deines Bruders Scham. ");
INSERT INTO deutkw_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Die Scham eines Weibes und ihrer Tochter darfst du nicht entblößen. Die Tochter ihres Sohns und die Tochter ihrer Tochter darfst du nicht nehmen, ihre Scham zu entblößen; sie sind nächste Blutsverwandte - solches ist grobe Unzucht. ");
INSERT INTO deutkw_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Auch darfst du nicht ein Weib zu ihrer Schwester hinzunehmen und so Feindschaft erregen, indem du ihre Scham entblößest neben ihr, bei ihren Lebzeiten. ");
INSERT INTO deutkw_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Du darfst einem Weibe nicht nahen, ihre Scham zu entblößen, während der Zeit ihrer Unreinigkeit. ");
INSERT INTO deutkw_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Mit dem Weibe deines Nächsten darfst du dich nicht fleischlich vermischen und dich dadurch verunreinigen. ");
INSERT INTO deutkw_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Du darfst nicht eines von deinen Kindern hergeben, um es dem Melech zu weihen, daß du nicht entheiligest den Namen deines Gottes; ich bin Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Du darfst nicht bei einem Manne liegen, wie man beim Weibe liegt; solches ist eine Greueltat. ");
INSERT INTO deutkw_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Mit keinem Tiere darfst du dich fleischlich vermischen und dich dadurch verunreinigen, und ein Weib soll sich nicht vor ein Tier hinstellen, daß es sich mit ihr begatte; solches ist eine schwere Schandthat. ");
INSERT INTO deutkw_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Ihr dürft euch nicht durch irgend etwas derartiges verunreinigen; denn durch alles das haben sich die Heiden verunreinigt, die ich vor euch vertreibe. ");
INSERT INTO deutkw_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Da wurde das Land unrein, und ich suchte seine Verschuldung an ihm heim, so daß das Land seine Bewohner ausspie. ");
INSERT INTO deutkw_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","So beobachtet denn ihr meine Satzungen und meine Rechte und verübt nicht irgend eine dieser Greuelthaten, weder der Landeseingeborne, noch der Fremde, der sich unter euch aufhält. ");
INSERT INTO deutkw_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Denn alle diese Greuelthaten haben die Bewohner des Landes verübt, die vor euch waren, und das Land wurde unrein; ");
INSERT INTO deutkw_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","daß nicht etwa das Land euch ausspeie, wenn ihr es verunreinigt, wie es das Volk ausgespieen hat, das vor euch war. ");
INSERT INTO deutkw_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Denn wer irgend eine dieser Greuelthaten verüben wird: solche, die sie verüben, sollen hinweggetilgt werden mitten aus ihren Volksgenossen. ");
INSERT INTO deutkw_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","So befolgt denn meine Anordnungen, daß ihr nicht thut nach den greulichen Sitten, die vor euch geübt wurden, und euch dadurch verunreinigt; ich bin Jahwe, euer Gott! ");
INSERT INTO deutkw_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Rede mit der ganzen Gemeinde der Israeliten und sprich zu ihnen: Ihr sollt heilig sein, denn ich bin heilig, Jahwe, euer Gott. ");
INSERT INTO deutkw_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Ihr sollt ein jeglicher seine Mutter und seinen Vater fürchten und meine Ruhetage sollt ihr beobachten; ich bin Jahwe, euer Gott. ");
INSERT INTO deutkw_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Ihr sollt euch nicht den Götzen zuwenden und dürft euch keine gegossenen Götter machen; ich bin Jahwe, euer Gott. ");
INSERT INTO deutkw_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Und wenn ihr Jahwe ein Heilsopfer schlachtet, sollt ihr es opfern, daß es euch wohlgefällig mache. ");
INSERT INTO deutkw_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","An dem Tag, an welchem ihr es opfert, und Tags darauf muß es gegessen werden; was aber bis zum dritten Tag übrig geblieben ist, muß verbrannt werden. ");
INSERT INTO deutkw_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Sollte aber dennoch am dritten Tage davon gegessen werden, so würde es als Verdorbenes gelten und nicht wohlgefällig aufgenommen werden. ");
INSERT INTO deutkw_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Wer es genießt, lädt Verschuldung auf sich; denn er hat das Jahwe Geheiligte entweiht und ein solcher soll hinweggetilgt werden aus seinen Volksgenossen. ");
INSERT INTO deutkw_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Wenn ihr euer Land aberntet, so sollst du dein Feld nicht bis auf den äußersten Rand abernten und nicht Nachlese halten nach deiner Ernte. ");
INSERT INTO deutkw_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Auch deinen Weinberg sollst du nicht nachlesen und die umhergestreuten Beeren in deinem Weinberge nicht auflesen: den Armen und den Fremden sollst du sie überlassen; ich bin Jahwe, euer Gott. ");
INSERT INTO deutkw_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Ihr sollt nicht stehlen, nichts ableugnen und nicht einer den andern betrügen. ");
INSERT INTO deutkw_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Ihr sollt bei meinem Namen nicht falsch schwören, daß du so den Namen deines Gottes entweihest; ich bin Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Du sollst deinen Nächsten nicht übervorteilen und nicht berauben; der Lohn des Lohnarbeiters soll von dir nicht zurückbehalten werden bis zum andern Morgen. ");
INSERT INTO deutkw_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Du sollst einem Tauben nicht fluchen und einem Blinden nicht ein Hindernis in den Weg legen, sondern sollst dich vor deinem Gotte fürchten; ich bin Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Ihr sollt nicht Unrecht verüben beim Rechtsprechen - du sollst weder für einen Geringen Partei ergreifen, noch auf einen Vornehmen Rücksicht nehmen, sondern du sollst deinen Nächsten recht richten. ");
INSERT INTO deutkw_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Du sollst nicht als Verleumder unter deinen Volksgenossen umgehen, noch auf dem Tode deines Nächsten bestehen; ich bin Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Du sollst gegen deinen Bruder nicht Haß im Herzen tragen, sondern sollst deinen Nächsten freimütig zur Rede stellen, daß du nicht etwa seinetwegen Sünde auf dich ladest. ");
INSERT INTO deutkw_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Du sollst nicht rachgierig noch nachträgerisch sein gegenüber deinen Volksgenossen, sondern sollst deinen Nächsten lieben, wie dich selbst; ich bin Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Meine Satzungen sollt ihr beobachten: du darfst nicht zweierlei Arten deines Viehs sich begatten lassen, noch dein Feld mit zweierlei Arten von Samen besäen, noch darf dir ein Kleid, das aus zweierlei Fäden zusammengewirkt ist, auf den Leib kommen. ");
INSERT INTO deutkw_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Wenn sich einer mit einem Weibe fleischlich vermischt, das als Sklavin unter der Gewalt eines anderen Mannes steht, ohne daß Sie losgekauft oder freigelassen war, so soll eine Strafe verhängt werden; doch sollen sie nicht mit dem Tode bestraft werden, denn sie war nicht freigelassen. ");
INSERT INTO deutkw_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Er soll aber Jahwe als seine Buße einen Widder zum Schuldopfer an die Thüre des Offenbarungszeltes bringen, ");
INSERT INTO deutkw_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","und der Priester soll ihm mit dem Schuldopfer-Widder vor Jahwe Sühne schaffen wegen der Sünde, die er begangen hat; so wird ihm dann die Sünde, die er begangen hat, vergeben werden. ");
INSERT INTO deutkw_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Wenn ihr in das Land kommt und allerlei Fruchtbäume pflanzt, so sollt ihr deren Vorhaut - ihre ersten Früchte - ungestört wachsen lassen. Drei Jahre sollen sie euch als unbeschnitten gelten, und darf nicht von ihnen gegessen werden. ");
INSERT INTO deutkw_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Im vierten Jahre sollen alle ihre Früchte Jahwe zu einer Dankfeier geweiht sein. ");
INSERT INTO deutkw_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Im fünften Jahr aber dürft ihr ihre Früchte essen, daß euch um so reichIicherer Ertrag von ihnen zu teil werde; ich bin Jahwe, euer Gott. ");
INSERT INTO deutkw_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Ihr dürft nichts samt dem Blut essen. Ihr dürft nicht wahrsagen, noch Zauberei treiben. ");
INSERT INTO deutkw_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Ihr dürft den Rand eures Kopfes nicht kreisförmig abscheren, noch sollst du den Rand deines Bartes verstümmeln. ");
INSERT INTO deutkw_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Ihr dürft euch nicht wegen eines Toten Einschnitte an eurem Leibe machen, noch dürft ihr euch Schriftzeichen einätzen; ich bin Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Du sollst deine Tochter nicht entweihen, indem du sie zum Huren anhältst, daß nicht das Land hurerisch und voll grober Unzucht werde. ");
INSERT INTO deutkw_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Meine Ruhetage sollt ihr beobachten und euch vor meinem Heiligtume scheuen; ich bin Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Wendet euch nicht an die Totenbeschwörer- und an die Wahrsagegeister. Befragt sie nicht, daß ihr euch durch sie verunreinigt; ich bin Jahwe, euer Gott. ");
INSERT INTO deutkw_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Vor einem grauen Haupte sollst du aufstehen und die Person eines Greisen ehren und sollst dich fürchten vor deinem Gott; ich bin Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Und wenn sich ein Fremder bei dir aufhält in eurem Lande, so sollt ihr ihn nicht bedrücken. ");
INSERT INTO deutkw_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Wie ein Landeseingeborner aus eurer Mitte soll euch der Fremde gelten, der sich bei euch aufhält, und du sollst ihn lieben, wie dich selbst. Denn ihr seid auch Fremdlinge gewesen in Ägypten; ich bin Jahwe, euer Gott. ");
INSERT INTO deutkw_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Ihr sollt nicht Unrecht verüben beim Rechtsprechen, noch in betreff des Längenmaßes, des Gewichts und des Hohlmaßes. ");
INSERT INTO deutkw_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Richtige Wage, richtige Gewichtsteine, richtiges Epha und richtiges Hin sollt ihr führen; ich bin Jahwe, euer Gott, der euch aus Ägypten weggeführt hat. ");
INSERT INTO deutkw_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","So sollt ihr denn alle meine Satzungen und alle meine Rechte beobachten und nach ihnen thun; ich bin Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Und zu den Israeliten sollst du sprechen: Jedermann von den Israeliten und von den Fremden, die sich in Israel aufhalten, der eines von seinen Kindern dem Melech hingiebt, soll mit dem Tode bestraft werden; die Landesbewohner sollen ihn steinigen. ");
INSERT INTO deutkw_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Und ich selbst will gegen einen solchen mein Antlitz richten und ihn hinwegtilgen mitten aus seinem Volke, darum daß er eines von seinen Kindern dem Melech hingegeben hat, um mein Heiligtum zu verunreinigen und meinen heiligen Namen zu entweihen. ");
INSERT INTO deutkw_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Und wenn etwa die Landesbewohner einem solchen durch die Finger sehen wollten, wenn er eines von seinen Kindern dem Melech hingiebt, daß Sie ihn nicht töten wollen, ");
INSERT INTO deutkw_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","so will doch ich mein Antlitz wider einen solchen richten und wider sein Geschlecht und will ihn und alle, die es ihm in der Abgötterei nachthun, indem sie mit dem Melech Abgötterei treiben, mitten aus ihrem Volk hinwegtilgen. ");
INSERT INTO deutkw_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Derjenige aber, der sich an die Totenbeschwörer- und die Wahrsagegeister wendet und so Abgötterei mit ihnen treibt, wider einen solchen will ich mein Antlitz richten und ihn mitten aus seinem Volk hinwegtilgen. ");
INSERT INTO deutkw_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Und ihr sollt euch heilig erweisen und sollt heilig sein, denn ich bin Jahwe, euer Gott. ");
INSERT INTO deutkw_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Darum sollt ihr meine Satzungen beobachten und nach ihnen thun; ich bin Jahwe der euch heiligt. ");
INSERT INTO deutkw_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Denn jedermann, der seinem Vater und seiner Mutter flucht, soll mit dem Tode bestraft werden; seinem Vater und seiner Mutter hat er geflucht - Blutschuld haftet auf ihm. ");
INSERT INTO deutkw_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Und wenn jemand Ehebruch treibt mit einem Eheweibe, wenn jemand Ehebruch treibt mit dem Weibe seines Nächsten, soll sowohl der Ehebrecher als die Ehebrecherin mit dem Tode bestraft werden. ");
INSERT INTO deutkw_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Und wenn jemand bei dem Weibe seines Vaters liegt, so hat er die Scham seines Vaters entblößt; sie sollen beide mit dem Tode bestraft werden, Blutschuld haftet auf ihnen. ");
INSERT INTO deutkw_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Und wenn jemand bei seiner Schwiegertochter liegt, so sollen beide mit dem Tode bestraft werden; sie haben eine schwere Schandthat verübt, Blutschuld haftet auf ihnen. ");
INSERT INTO deutkw_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Und wenn jemand bei einem Manne liegt, wie man beim Weibe liegt, so haben beide eine Greuelthat verübt; mit dem Tode sollen sie bestraft werden, Blutschuld haftet auf ihnen. ");
INSERT INTO deutkw_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Und wenn jemand ein Weib nimmt und dazu ihre Mutter, so ist dies grobe Unzucht; man soll ihn und sie beide verbrennen, daß nicht Unzucht unter euch im Schwange gehe. ");
INSERT INTO deutkw_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Und wenn sich jemand mit einem Tiere fleischlich vermischt, so soll er mit dem Tode bestraft werden, und auch das Tier sollt ihr töten. ");
INSERT INTO deutkw_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Und wenn sich ein Weib irgend einem Tiere naht, daß es sich mit ihr begatte, so sollst du das Weib samt dem Tiere töten; mit dem Tode sollen sie bestraft werden, Blutschuld haftet auf ihnen. ");
INSERT INTO deutkw_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Und wenn einer seine Schwester, die Tochter seines Vaters oder die Tochter seiner Mutter, nimmt, so daß er ihre Scham sieht, und sie seine Scham sieht, so ist dies Blutschande, und sie sollen hinweggetilgt werden vor den Augen ihrer Volksgenossen; die Scham seiner Schwester hat er entblößt und Verschuldung auf sich geladen. ");
INSERT INTO deutkw_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Und wenn jemand bei einem Weibe liegt zur Zeit ihrer monatlichen Krankheit und ihre Scham entblößt, ihren Brunnen aufgedeckt hat, und sie so den Brunnen ihres Bluts entblößt hat, so sollen beide mitten aus ihrem Volk hinweggetilgt werden. ");
INSERT INTO deutkw_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Die Scham der Schwester deiner Mutter und der Schwester deines Vaters darfst du nicht entblößen; denn wer es thut, der hat seine nächste Blutsverwandte aufgedeckt und sie haben Verschuldung auf sich geladen. ");
INSERT INTO deutkw_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Und wenn jemand bei dem Weibe des Bruders seines Vaters liegt, so hat er die Scham seines Oheims entblößt und sie haben Sünde auf sich geladen - ohne Kinder sollen sie sterben. ");
INSERT INTO deutkw_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Und wenn jemand das Weib seines Bruders nimmt, so ist dies Blutschande; die Scham seines Bruders hat er entblößt - sie sollen ohne Kinder sein. ");
INSERT INTO deutkw_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","So beobachtet denn alle meine Satzungen und alle meine Rechte und thut darnach, daß euch das Land nicht ausspeie, in das ich euch bringen will, daß ihr darin wohnen sollt. ");
INSERT INTO deutkw_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Ihr dürft nicht wandeln nach den Satzungen des Volks, welches ich vor euch ausstoße, weil sie alles das verübt haben, so daß es mich vor ihnen ekelte. ");
INSERT INTO deutkw_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Darum sprach ich zu euch: Ihr sollt ihren Boden zu eigen bekommen, und ich will ihn euch zum Besitze geben - ein Land, das von Milch und Honig überfließt, ich, Jahwe, euer Gott, der euch ausgesondert hat von den Völkern. ");
INSERT INTO deutkw_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","So macht denn einen Unterschied zwischen den reinen und den unreinen Vierfüßlern, sowie zwischen den unreinen und den reinen Vögeln, und macht euch nicht selbst abscheulich durch Vierfüßler oder Vögel oder irgend etwas, das sich auf Erden regt, was ich abgesondert habe, damit es euch als unrein gelte. ");
INSERT INTO deutkw_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Und ihr sollt mir heilig sein, denn ich, Jahwe, bin heilig und habe euch abgesondert von den Völkern, daß ihr mir angehören sollt. ");
INSERT INTO deutkw_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Und wenn sich in einem Mann oder Weib ein Totenbeschwörer- oder Wahrsagegeist befinden wird, so sollen sie mit dem Tode bestraft werden; man soll sie steinigen, Blutschuld lastet auf ihnen. ");
INSERT INTO deutkw_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Und Jahwe sprach zu Mose: Sage den Priestern, den Söhnen Aarons, und sprich zu ihnen: ein Priester darf sich nicht an einer Leiche verunreinigen unter seinen Volksgenossen. ");
INSERT INTO deutkw_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Nur an den Blutsverwandten, die ihm am nächsten stehen, an seiner Mutter und seinem Vater, seinem Sohne, seiner Tochter, seinem Bruder und ");
INSERT INTO deutkw_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","seiner Schwester, die Jungfrau ist und ihm so noch nahe steht, die noch keinem Manne zu teil geworden ist - an der darf er sich verunreinigen. ");
INSERT INTO deutkw_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Er darf sich nicht verunreinigen unter seinen Volksgenossen, daß er sich dadurch entweihe. ");
INSERT INTO deutkw_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Sie dürfen sich auf ihrem Haupte keine Glatze scheren, dürfen den Rand ihres Bartes nicht abscheren und sich an ihrem Leibe keine Einschnitte machen. ");
INSERT INTO deutkw_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Sie sollen ihrem Gotte heilig sein und den Namen ihres Gottes nicht entweihen; denn Sie bringen die Feueropfer Jahwes, die Speise ihres Gottes, dar, darum sollen sie heilig sein. ");
INSERT INTO deutkw_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Eine Hure oder eine Geschwächte dürfen sie nicht zum Weibe nehmen; auch eine von ihrem Manne verstoßene Frau dürfen Sie nicht nehmen, denn der Priester ist seinem Gotte heilig. ");
INSERT INTO deutkw_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Darum sollst du ihn heilig halten, denn er bringt die Speise deines Gottes dar; als heilig soll er dir gelten, denn ich bin heilig, Jahwe, der euch heiligt. ");
INSERT INTO deutkw_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Und wenn sich die Tochter eines Priesters entweiht durch Hurerei, so entweiht sie damit ihren Vater; man soll sie verbrennen. ");
INSERT INTO deutkw_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Der aber Hoherpriester ist unter seinen Brüdern, auf dessen Haupt das Salböl gegossen ward, dem man die Hand gefüllt und die heiligen Kleider angelegt hat, der darf sein Haupthaar nicht wild fliegen lassen und seine Kleider nicht zerreißen. ");
INSERT INTO deutkw_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Er darf zu gar keiner Leiche hineingehen; sogar an seinem Vater und an seiner Mutter darf er sich nicht verunreinigen. ");
INSERT INTO deutkw_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Das Heiligtum darf er nicht verlassen, damit er nicht etwa das Heiligtum seines Gottes entweihe, denn die Weihe des Salböls seines Gottes ruht auf ihm; ich bin Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Eine reine Jungfrau muß er zum Weibe nehmen; ");
INSERT INTO deutkw_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","eine Witwe oder Verstoßene oder Geschwächte oder Hure - diese darf er nicht nehmen; nur eine Jungfrau aus seinen Volksgenossen darf er zum Weibe nehmen, ");
INSERT INTO deutkw_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","daß er nicht seinen Stamm unter seinen Volksgenossen entweihe, denn ich bin Jahwe, der ihn heiligt. ");
INSERT INTO deutkw_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Rede mit Aaron also: wenn jemand von deinen Nachkommen, jetzt und in allen künftigen Zeiten, ein Leibesgebrechen hat, so darf er nicht herzutreten, um die Speise seines Gottes darzubringen. ");
INSERT INTO deutkw_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Denn wer irgend ein Leibesgebrechen hat, darf nicht herzutreten, er sei nun blind oder lahm oder im Gesicht verstümmelt oder mit einem zu langen Gliede behaftet ");
INSERT INTO deutkw_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","oder habe ein gebrochenes Bein oder einen gebrochenen Arm ");
INSERT INTO deutkw_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","oder sei bucklig oder unnatürlich abgemagert oder habe weiße Flecken im Auge oder leide an Krätze oder Flechten oder an einem Hodenbruch. ");
INSERT INTO deutkw_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Keiner von den Nachkommen Aarons, des Priesters, der ein Leibesgebrechen hat, darf herzunahen, um die Feueropfer Jahwes darzubringen; hat er ein Leibesgebrechen, so darf er nicht herzunahen, die Speise seines Gottes darzubringen. ");
INSERT INTO deutkw_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Von der Speise seines Gottes, sowohl den hochheiligen, als den heiligen Gaben, darf er essen. ");
INSERT INTO deutkw_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Nur darf er nicht hineingehn zum inneren Vorhang und zum Altar nicht nahen, weil er ein Leibesgebrechen hat, damit er meine Heiligtümer nicht entweihe; denn ich bin Jahwe, der sie heiligt. ");
INSERT INTO deutkw_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Und Mose redete solches zu Aaron und zu seinen Söhnen und zu allen Israeliten. ");
INSERT INTO deutkw_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Sage Aaron und seinen Söhnen, daß sie sich vorsichtig verhalten sollen gegenüber den heiligen Gaben der Israeliten, die sie mir weihen, damit sie nicht meinen heiligen Namen entweihen; ich bin Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Sprich zu ihnen: Wenn irgend jemand von allen euren Nachkommen, jetzt und in künftigen Zeiten, den heiligen Gaben, welche die Israeliten Jahwe weihen werden, sich nähert, während ihm Unreinigkeit anhaftet, ein solcher soll hinweggetilgt werden aus meinem Angesicht; ich bin Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Wer irgend von den Nachkommen Aarons aussätzig ist oder einen Fluß hat, darf von den heiligen Gaben nicht mit essen, bis er wieder rein ist. Wer irgend einen durch eine Leiche Verunreinigten berührt hat oder wem der Same entgangen ist, ");
INSERT INTO deutkw_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","oder wer irgend ein Gewürm berührt hat, durch das er unrein geworden ist, oder einen Menschen, durch den er unrein geworden ist zufolge irgend welcher Unreinigkeit, die ihm anhaftet, - ");
INSERT INTO deutkw_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","wer solches berührt hat, ein solcher bleibt unrein bis zum Abend und darf nicht von den heiligen Gaben essen, wenn er nicht zuvor seinen Leib gebadet hat. ");
INSERT INTO deutkw_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Sobald die Sonne untergegangen ist, ist er wieder rein; alsdann mag er von den heiligen Gaben essen, denn das ist seine Speise. ");
INSERT INTO deutkw_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Aas und von wilden Tieren Zerrissenes darf er nicht essen, daß er sich dadurch verunreinigt; ich bin Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","So sollen sie denn meine Anordnungen befolgen, daß sie nicht wegen des Geheiligten Sünde auf sich laden und deshalb sterben, weil sie es entweihen; ich bin Jahwe, der sie heiligt. ");
INSERT INTO deutkw_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Kein Fremder aber darf Geheiligtes essen; der Beisaß oder Tagelöhner eines Priesters darf nicht Geheiligtes essen. ");
INSERT INTO deutkw_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Wenn aber ein Priester einen Sklaven für Geld erwirbt, so darf dieser mit davon essen; ebenso der in seinem Hause geborene - sie dürfen mit von seiner Speise essen. ");
INSERT INTO deutkw_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Eine Priesterstochter, die einem Fremden zu teil geworden ist, darf von der Hebe, die von den heiligen Gaben entrichtet wird, nicht mit essen. ");
INSERT INTO deutkw_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Eine Priesterstochter aber, welche Witwe oder von ihrem Manne verstoßen und kinderlos ist und wieder zu ihrer Familie zurückkehrt, wie in ihrer Jugend, die darf von der Speise ihres Vaters essen; dagegen darf durchaus kein Fremder mit davon essen. ");
INSERT INTO deutkw_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Und wenn jemand aus Versehen Geheiligtes ißt, so soll er ein Fünftel des Betrags darauf legen und es dem Priester geben samt dem Geheiligten. ");
INSERT INTO deutkw_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Und die Priester sollen die heiligen Gaben der Israeliten nicht entweihen - was sie als Hebe für Jahwe hinwegnehmen -, ");
INSERT INTO deutkw_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","damit Sie ihnen nicht Schuld aufladen durch ihre Verschuldung, wenn Sie ihre heiligen Gaben verzehren; denn ich bin Jahwe, der Sie heiligt. ");
INSERT INTO deutkw_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Rede mit Aaron und mit seinen Söhnen und allen Israeliten und sprich zu ihnen: Wenn irgend jemand vom Hause Israel oder von den Fremden in Israel seine Opfergabe darbringt - irgend welche gelobte oder freiwillige Gaben, die sie Jahwe als Brandopfer darbringen wollen -, ");
INSERT INTO deutkw_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","sollt ihr sie so darbringen, daß sie euch wohlgefällig mache: ein fehlloses, männliches Tier von den Rindern, den Lämmern oder den Ziegen. ");
INSERT INTO deutkw_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Was irgend einen Makel an sich hat, dürft ihr nicht darbringen; denn es würde euch nicht wohlgefällig machen. ");
INSERT INTO deutkw_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Und wenn jemand Jahwe von den Rindern oder Schafen ein Heilsopfer darbringen will, sei es nun zur Abtragung eines Gelübdes oder als freiwillige Gabe, so muß es fehllos sein, damit es ihn wohlgefällig mache; es darf gar keinen Makel an sich haben. ");
INSERT INTO deutkw_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Was blind ist oder ein gebrochenes Glied oder eine Wunde hat oder mit Geschwüren oder Krätze oder Flechten behaftet ist - solche dürft ihr Jahwe nicht darbringen und kein derartiges Jahwe als Feueropfer auf den Altar legen. ");
INSERT INTO deutkw_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Ein Rind aber oder ein Schaf mit zu langen oder zu kurzen Gliedern darfst du als freiwillige Gabe herrichten; dagegen als Gelübdeopfer würde es euch nicht wohlgefällig machen. ");
INSERT INTO deutkw_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Auch ein solches, dem die Hoden zerquetscht oder zerschlagen oder abgerissen oder ausgeschnitten sind, dürft ihr Jahwe nicht darbringen. Ihr dürft weder irgend welche derart Verstümmelte in eurem Lande machen, ");
INSERT INTO deutkw_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","noch von einem Ausländer erwerben und als Speise eures Gottes darbringen; denn es haftet ihnen ein Schaden an - ein Makel haftet an ihnen -, darum werden sie euch nicht wohlgefällig machen. ");
INSERT INTO deutkw_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","wenn ein Rind oder ein Lamm oder ein Zicklein geboren wird, so soll es sieben Tage von seiner Mutter gesäugt werden; aber vom achten Tage ab und weiterhin wird es wohlgefällig aufgenommen werden, wenn es Jahwe als Feueropfer dargebracht wird. ");
INSERT INTO deutkw_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Ein Rind oder Schaf dürft ihr nicht zusammen mit seinem Jungen an einem und demselben Tage schlachten. ");
INSERT INTO deutkw_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Und wenn ihr Jahwe ein Dankopfer opfern wollt, sollt ihr es so opfern, daß es euch wohlgefällig mache. ");
INSERT INTO deutkw_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","An ebendemselben Tage muß es verzehrt werden: ihr dürft nichts davon übrig lassen bis zum nächsten Morgen; ich bin Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","So beobachtet denn meine Gebote und thut darnach - ich bin Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Und entweiht nicht meinen heiligen Namen, damit ich geheiligt werde inmitten der Israeliten; ich bin Jahwe, der euch heiligt, ");
INSERT INTO deutkw_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","der euch weggeführt hat aus Ägypten, um euer Gott zu sein - ich, Jahwe! ");
INSERT INTO deutkw_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Rede mit den Israeliten und sprich zu ihnen: Die Festzeiten Jahwes, die ihr auszurufen habt als Festversammlungen am Heiligtume - folgende sind meine Festzeiten. ");
INSERT INTO deutkw_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Sechs Tage hindurch darf Arbeit verrichtet werden, aber der siebente Tag ist ein Tag unbedingter Ruhe, mit Festversammlung am Heiligtum; da dürft ihr keinerlei Arbeit verrichten in allen euren Wohnsitzen - es ist ein Ruhetag für Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Dies sind die Festzeiten Jahwes, mit Festversammlungen am Heiligtume, die ihr auszurufen habt, ein jedes zu seiner Zeit. ");
INSERT INTO deutkw_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Im ersten Monat, am vierzehnten des Monats gegen Abend findet Passahfeier für Jahwe statt. ");
INSERT INTO deutkw_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Am fünfzehnten Tage aber desselben Monats ist Jahwe das Fest der ungesäuerten Brote zu feiern; sieben Tage lang müßt ihr ungesäuerte Brote essen. ");
INSERT INTO deutkw_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Am ersten Tage habt ihr Festversammlung am Heiligtume zu halten; da dürft ihr keinerlei Werktagsarbeit verrichten. ");
INSERT INTO deutkw_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Und sieben Tage hindurch habt ihr Jahwe ein Feueropfer darzubringen; am siebenten Tage findet Festversammlung am Heiligtume statt, da dürft ihr keinerlei Werktagsarbeit verrichten. ");
INSERT INTO deutkw_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Rede mit den Israeliten und sprich zu ihnen: Wenn ihr in das Land kommt, das ich euch verleihen werde, und die Ernte in ihm abhaltet, so sollt ihr die Erstlingsgarbe von eurer Ernte zum Priester bringen, ");
INSERT INTO deutkw_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","und er soll die Garbe vor Jahwe weben, daß Sie euch wohlgefällig mache; am Tage nach dem Sabbat soll sie der Priester weben. ");
INSERT INTO deutkw_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Und ihr sollt an dem Tage, an welchem ihr die Garbe webt, ein fehlIoses, einjähriges Lamm zum Brandopfer für Jahwe herrichten, ");
INSERT INTO deutkw_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","dazu als Speisopfer zwei Zehntel Feinmehl, angemacht mit Öl, als ein Feueropfer lieblichen Geruchs für Jahwe, und als Trankopfer dazu ein Viertel Hin Wein. ");
INSERT INTO deutkw_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Brot aber und geröstete oder zerstoßene Körner dürft ihr bis zu eben diesem Tage nicht essen, bis ihr die Opfergabe für euren Gott dargebracht habt. Das ist eine für alle Zeiten geltende Satzung, die ihr beobachten sollt von Geschlecht zu Geschlecht in allen euren Wohnsitzen. ");
INSERT INTO deutkw_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Sodann sollt ihr vom Tage nach dem Sabbat ab - von dem Tage ab, wo ihr die Webegarbe darbrachtet, - sieben volle Wochen zählen, ");
INSERT INTO deutkw_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","bis zum Tage nach dem siebenten Sabbat sollt ihr zählen, fünfzig Tage; alsdann sollt ihr Jahwe ein Speisopfer vom neuen Getreide darbringen. ");
INSERT INTO deutkw_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Aus euren Wohnsitzen sollt ihr zwei Webe-Brote bringen; aus zwei Zehnteln Feinmehl sollen sie bestehen und mit Sauerteig gebacken sein, als Erstlingsopfer für Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Und zu dem Brote sollt ihr darbringen sieben fehllose einjährige Lämmer, einen jungen Stier und zwei Widder - die sollen Jahwe als Brandopfer gebracht werden, nebst dem zugehörigen Speisopfer und den zugehörigen Trankopfern, als ein Feueropfer lieblichen Geruchs für Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Ferner sollt ihr einen Ziegenbock herrichten zum Sündopfer und zwei einjährige Lämmer zum Heilsopfer. ");
INSERT INTO deutkw_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Und der Priester soll sie samt den Erstlingsbroten als Webeopfer vor Jahwe weben samt zwei Lämmern; sie sollen Jahwe geheiligt sein zum Besten des Priesters. ");
INSERT INTO deutkw_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Und ihr sollt an eben diesem Tag ausrufen - ihr sollt Festversammlung am Heiligtum abhalten; da dürft ihr keinerlei Werktagsarbeit verrichten. Das ist eine für alle Zeiten geltende Satzung, die ihr beobachten sollt in allen euren Wohnsitzen von Geschlecht zu Geschlecht. ");
INSERT INTO deutkw_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Und wenn ihr euer Land aberntet, so sollst du dein Feld nicht bis auf den äußersten Rand abernten und sollst nicht Nachlese halten nach deiner Ernte: den Armen und den Fremden sollst du beides überlassen; ich bin Jahwe, euer Gott. ");
INSERT INTO deutkw_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Rede mit den Israeliten also: Im siebenten Monat soll euch der erste des Monats ein Ruhetag sein, mit mahnendem Lärmblasen und Festversammlung am Heiligtum. ");
INSERT INTO deutkw_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Ihr dürft da keinerlei Werktagsarbeit verrichten und habt Jahwe ein Feueropfer darzubringen. ");
INSERT INTO deutkw_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","Dagegen der zehnte desselben siebenten Monats ist der Sühntag; da habt ihr Festversammlung am Heiligtume zu halten und euch zu kasteien und Jahwe ein Feueropfer darzubringen. ");
INSERT INTO deutkw_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Und an eben diesem Tage dürft ihr keinerlei Arbeit verrichten, denn der Sühntag ist es, daß man euch Sühne schaffe vor Jahwe, eurem Gott. ");
INSERT INTO deutkw_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Denn wer irgend an diesem Tage sich nicht kasteit, der soll hinweggetilgt werden aus seinen Volksgenossen. ");
INSERT INTO deutkw_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Und wer immer an diesem Tag irgend welche Arbeit verrichtet, einen solchen will ich hinwegraffen mitten auf seinen Volksgenossen. ");
INSERT INTO deutkw_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Ihr dürft da keinerlei Arbeit verrichten; das ist eine für alle Zeiten geltende Satzung, die ihr beobachten sollt von Geschlecht zu Geschlecht in allen euren Wohnsitzen. ");
INSERT INTO deutkw_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Als ein Tag unbedingter Ruhe soll er euch gelten, und ihr sollt euch kasteien. Am Abend des neunten des Monats - vom Abend bis wieder zum Abend sollt ihr die geforderte Ruhezeit einhalten. ");
INSERT INTO deutkw_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Rede mit den Israeliten also: Am fünfzehnten Tage desselben siebenten Monats soll man Jahwe sieben Tage lang das Hüttenfest feiern. ");
INSERT INTO deutkw_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Am ersten Tag ist Festversammlung am Heiligtume; da dürft ihr keinerlei Werktagsarbeit verrichten. ");
INSERT INTO deutkw_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Sieben Tage hindurch habt ihr Jahwe ein Feueropfer darzubringen; am achten Tage habt ihr Festversammlung am Heiligtume zu halten und Jahwe ein Feueropfer darzubringen - Festversammlung ist es; da dürft ihr keinerlei Werktagsarbeit verrichten. ");
INSERT INTO deutkw_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Das sind die Festzeiten Jahwes, in welchen ihr Festversammlungen am Heiligtum ausrufen sollt, daß man Jahwe Feueropfer darbringe - Brandopfer und Speisopfer, Schlachtopfer und Trankopfer, je nach der Erfordernis des betreffenden Tags, ");
INSERT INTO deutkw_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","abgesehen von den Sabbaten Jahwes und abgesehen von euren Gaben, sowie von allen euren Gelübdeopfern und allen euren freiwilligen Spenden, die ihr Jahwe bringen wollt. ");
INSERT INTO deutkw_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Jedoch am fünfzehnten Tage des siebenten Monats, wenn ihr den Ertrag des Landes einheimst, sollt ihr sieben Tage lang das Fest Jahwes feiern; der erste Tag ist ein Ruhetag und der achte Tag ist ein Ruhetag. ");
INSERT INTO deutkw_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Und ihr sollt euch am ersten Tage Früchte von prächtigen Bäumen, Palmenzweige und Äste von dichtbelaubten Bäumen, sowie von Bachweiden holen und sieben Tage lang vor Jahwe, eurem Gotte, fröhlich sein, ");
INSERT INTO deutkw_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","und sollt es als ein Fest Jahwes feiern jedes Jahr sieben Tage lang; das ist eine für alle Zeiten geltende Satzung, die ihr beobachten sollt von Geschlecht zu Geschlecht: im siebenten Monat sollt ihr es feiern. ");
INSERT INTO deutkw_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Da sollt ihr sieben Tage lang in Hütten wohnen; alle Landeseingebornen in Israel sollen in Hütten wohnen, ");
INSERT INTO deutkw_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","damit eure künftigen Geschlechter erfahren, daß ich die Israeliten habe in Hütten wohnen lassen, als ich sie aus Ägypten hinwegführte, ich, Jahwe, euer Gott. ");
INSERT INTO deutkw_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Und Mose sagte den Israeliten die Festzeiten Jahwes. ");
INSERT INTO deutkw_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Gebiete den Israeliten, daß sie dir lauteres Öl aus zerstoßenen Oliven für den Leuchter herbeibringen, damit man beständig Lampen aufstecken kann. ");
INSERT INTO deutkw_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Außerhalb des Vorhangs vor dem Gesetz im Offenbarungszelte soll ihn Aaron herrichten, daß er beständig vor Jahwe brenne vom Abend bis zum Morgen. Das ist eine für alle Zeiten geltende Satzung, die ihr beobachten sollt von Geschlecht zu Geschlecht. ");
INSERT INTO deutkw_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Auf dem Leuchter von gediegenem Golde soll er die Lampen herrichten, daß sie beständig vor Jahwe brennen. ");
INSERT INTO deutkw_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Ferner sollst du Feinmehl nehmen und daraus zwölf Kuchen backen - zwei Zehntel sollen auf jeden Kuchen kommen - ");
INSERT INTO deutkw_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","und sollst sie in zwei Reihen, je sechs in einer Reihe, auf dem Tisch von gediegenem Golde vor Jahwe auflegen. ");
INSERT INTO deutkw_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Jeder Schicht aber sollst du reinen Weihrauch beigeben; dieser soll dann als Duftteil von dem Brote dienen als ein Jahwe dargebrachtes Feueropfer. ");
INSERT INTO deutkw_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Jedesmal am Sabbattage soll er es beständig vor Jahwe aufschichten, kraft einer den Israeliten obliegenden, für alle Zeiten geltenden Verpflichtung. ");
INSERT INTO deutkw_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Und es soll Aaron und seinen Söhnen zufallen, daß sie es verzehren an heiliger Stätte; denn es gehört ihm als ein Hochheiliges unter den Feueropfern, kraft eines für alle Zeiten geltenden Rechts. ");
INSERT INTO deutkw_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Und der Sohn einer Israelitin - er stammte aber von einem ägyptischen Manne - ging aus mitten unter die Israeliten; da gerieten sie im Lager in Streit, der Sohn der Israelitin und ein israelitischer Mann. ");
INSERT INTO deutkw_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Da lästerte der Sohn der Israelitin den heiligen Namen und fluchte; da brachten sie ihn zu Mose (seine Mutter aber hieß Selomith, die Tochter Dibris, vom Stamme Dan). ");
INSERT INTO deutkw_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Und sie legten ihn in Gewahrsam, bis ihnen Weisung zukäme auf Grund eines Ausspruchs Jahwes. ");
INSERT INTO deutkw_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","Laß den Flucher hinaus vor das Lager führen, und alle, die es gehört haben, sollen ihm die Hände auf daß Haupt aufstemmen, und sodann soll ihn die ganze Gemeinde steinigen. ");
INSERT INTO deutkw_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Zu den Israeliten aber sollst du also sprechen: Wer irgend seinem Gotte flucht, der lädt Sünde auf sich. ");
INSERT INTO deutkw_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Und wer den Namen Jahwes lästert, soll mit dem Tode bestraft werden; die ganze Gemeinde soll ihn unfehlbar steinigen. Es sei ein Fremder oder ein Landeseingeborner - wenn er den heiligen Namen lästert, soll er getötet werden. ");
INSERT INTO deutkw_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Wenn jemand irgend einen Menschen erschlägt, soll er mit dem Tode bestraft werden. ");
INSERT INTO deutkw_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Und wer ein Stück Vieh erschlägt, hat er es zu ersetzen - Leben um Leben. ");
INSERT INTO deutkw_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Wenn jemand seinem Nächsten einen Leibesschaden zufügt, dem soll man thun, wie er gethan hat: ");
INSERT INTO deutkw_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Bruch um Bruch, Auge um Auge, Zahn um Zahn; derselbe Leibesschaden, den er einem andern zufügt, soll ihm zugefügt werden. ");
INSERT INTO deutkw_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Wer ein Stück Vieh erschlägt, hat es zu ersetzen; wer aber einen Menschen erschlägt, der soll getötet werden. ");
INSERT INTO deutkw_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Einerlei Recht soll unter euch gelten, für den Fremden, wie für den Landeseingebornen, denn ich bin Jahwe, euer Gott. ");
INSERT INTO deutkw_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Und Mose redete mit den Israeliten; da führten sie den Flucher hinaus vor das Lager und steinigten ihn. Und die Israeliten thaten, wie Jahwe Mose befohlen hatte. ");
INSERT INTO deutkw_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Und Jahwe redete mit Mose auf dem Berge Sinai also: ");
INSERT INTO deutkw_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Rede mit den Israeliten und sprich zu ihnen: Wenn ihr in das Land kommt, das ich euch verleihen werde, so soll das Land Jahwe eine Ruhezeit halten. ");
INSERT INTO deutkw_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Sechs Jahre hindurch magst du dein Feld besäen und sechs Jahre hindurch deinen Weinberg beschneiden und den Ertrag des Landes einheimsen. ");
INSERT INTO deutkw_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Aber das siebente Jahr soll für das Land eine Zeit unbedingter Ruhe sein, eine Ruhezeit für Jahwe. Da darfst du dein Feld nicht besäen, noch deinen Weinberg beschneiden; ");
INSERT INTO deutkw_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","den Nachwuchs deiner vorigen Ernte darfst du nicht einernten und die Trauben deines unbeschnittenen Weinstocks nicht lesen - es soll ein Ruhejahr sein für das Land. ");
INSERT INTO deutkw_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Was das Land in der Ruhezeit freiwillig trägt, soll euch zur Nahrung dienen - dir, deinem Sklaven und deiner Sklavin, sowie deinem Lohnarbeiter und deinem Beisassen, die sich bei dir aufhalten; ");
INSERT INTO deutkw_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","auch deinem Vieh und dem Wild in deinem Lande soll alles, was es trägt, zur Nahrung dienen. ");
INSERT INTO deutkw_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Weiter sollst du sieben Ruhejahre zählen - siebenmal sieben Jahre - so daß die Zeit der sieben Ruhejahre neunundvierzig Jahren gleichkommt. ");
INSERT INTO deutkw_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Dann aber sollst du im siebenten Monat, am zehnten des Monats die Lärmposaune erschallen Iassen; am Sühntage sollt ihr überall in eurem Lande die Posaune erschallen lassen ");
INSERT INTO deutkw_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","und sollt so das fünfzigste Jahr weihen und im Lande Freiheit ausrufen für alle seine Bewohner. Als ein Halljahr soll es euch gelten; da sollt ihr ein jeder wieder zu seinem Besitz und zu seinem Geschlechte kommen. ");
INSERT INTO deutkw_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Als ein Halljahr soll es euch gelten, das fünfzigste Jahr; in ihm dürft ihr nicht säen und den Nachwuchs nicht einernten, noch von den unbeschnittenen Weinstöcken Trauben lesen. ");
INSERT INTO deutkw_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Denn ein Halljahr ist es und soll euch als geheiligt gelten; vom Felde weg sollt ihr essen, was es trägt. ");
INSERT INTO deutkw_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","In solchem Halljahre sollt ihr ein jeder wieder zu seinem Besitze kommen. ");
INSERT INTO deutkw_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Wenn du deinem Nächsten etwas verkaufst oder von deinem Nächsten kaufst, so sollt ihr nicht einer den andern übervorteilen. ");
INSERT INTO deutkw_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Mit Rücksicht auf die Anzahl der Jahre seit dem letzten Halljahre sollst du deinem Nächsten abkaufen, und mit Rücksicht auf die Anzahl der Erntejahre soll er dir verkaufen. ");
INSERT INTO deutkw_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Für eine größere Zahl von Jahren hast du einen entsprechend höheren Kaufpreis zu zahlen, wie für eine geringere Zahl von Jahren einen entsprechend geringeren; denn eine Anzahl von Ernten verkauft er dir. ");
INSERT INTO deutkw_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","So übervorteilt nun keiner seinen Nächsten, sondern fürchte dich vor deinem Gotte, denn ich bin Jahwe, euer Gott. ");
INSERT INTO deutkw_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Darum sollt ihr nach meinen Satzungen thun und meine Rechte beobachten und nach ihnen thun, damit ihr sicher im Lande wohnt. ");
INSERT INTO deutkw_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Da wird dann das Land seine Frucht hergeben, daß ihr euch satt essen könnt und sicher darin wohnt. ");
INSERT INTO deutkw_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Und falls ihr sprächet: Was sollen wir essen im siebenten Jahre, wenn wir nicht säen und uns keine Früchte einsammeln dürfen? ");
INSERT INTO deutkw_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","So wisset: Ich werde im sechsten Jahre meinen Segen zu euren Gunsten aufbieten, daß es für alle drei Jahre den nötigen Ertrag abwerfen soll. ");
INSERT INTO deutkw_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Und wenn ihr im achten Jahre säet, werdet ihr noch immer von dem Ertrag altes Getreide essen; bis zum neunten Jahre - bis der Ertrag desselben zu Gebote steht - werdet ihr altes essen. ");
INSERT INTO deutkw_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Grund und Boden darf nicht endgiltig verkauft werden, denn mein ist das Land; denn ihr seid nur Fremdlinge und Beisassen bei mir. ");
INSERT INTO deutkw_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Daher sollt ihr in dem Lande, das ihr zu eigen habt, überall eine Wiedereinlösung von Grund und Boden gestatten. ");
INSERT INTO deutkw_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Wenn dein Bruder verarmt und etwas von seinem Besitztume verkauft, so soll sein nächster Verwandter als Löser für ihn eintreten und das, was sein Verwandter verkauft hat, wieder einlösen. ");
INSERT INTO deutkw_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Und wenn jemand keinen Löser hat, aber so viel zu beschaffen vermag, als er zur Wiedereinlösung bedarf, ");
INSERT INTO deutkw_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","so soll er die Jahre, die seit dem Verkaufe verflossen sind, in Anrechnung bringen; was darüber ist, soll er demjenigen, an den er verkauft hat, zurückerstatten, damit er wieder zu seinem Besitztum komme. ");
INSERT INTO deutkw_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Beschafft er aber nicht so viel, als er zur Rückerstattung bedarf, so bleibt das von ihm Verkaufte im Besitze des Käufers bis zum Halljahr; im Halljahr aber soll es unentgeltlich heimfallen, so daß er wieder zu seinem Besitztume kommt. ");
INSERT INTO deutkw_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Und wenn jemand ein Wohnhaus in einer ummauerten Stadt verkauft, so soll er es wieder einlösen dürfen bis zum Abschlusse des Jahres, in welchem er es verkauft hat; für seine Wiedereinlösung ist damit eine Frist gesetzt. ");
INSERT INTO deutkw_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Wenn es aber bis zum Ablauf eines vollen Jahres nicht eingelöst wird, so wird das Haus, das in einer ummauerten Stadt liegt, dem Käufer und seinen Nachkommen endgiltig als Besitz bestätigt und fällt im Halljahre nicht heim. ");
INSERT INTO deutkw_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Dagegen die Häuser in den Dörfern, welche nicht ringsum eine Mauer haben, sind als ein Teil des Ackerbesitzes zu betrachten; sie dürfen wieder eingelöst werden und fallen im Halljahre heim. ");
INSERT INTO deutkw_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Was aber die Häuser der Leviten betrifft - die Häuser in den Städten, die ihr Eigentum sind -, so steht den Leviten jederzeit die Wiedereinlösung zu. ");
INSERT INTO deutkw_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Und wenn jemand von den Leviten seinen Besitz nicht wieder einlöst, so fällt das von ihm - und zwar in der Stadt, wo er seinen Erbbesitz hat - verkaufte Haus im Halljahre heim; denn die Häuser in den Städten der Leviten sind ihr Erbbesitz inmitten der Israeliten. ");
INSERT INTO deutkw_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Das zu ihren Städten gehörende Weideland aber darf nicht verkauft werden; denn es gehört ihnen für alle Zeiten als Erbbesitz. ");
INSERT INTO deutkw_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Und wenn dein Bruder verarmt, daß er sich neben dir nicht halten kann, so sollst du ihn aufrecht erhalten als Fremdling und Beisassen, daß er seinen Unterhalt neben dir habe. ");
INSERT INTO deutkw_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Du darfst nicht Zins und Wucher von ihm nehmen, sondern sollst dich fürchten vor deinem Gotte, daß dein Bruder seinen Unterhalt neben dir habe. ");
INSERT INTO deutkw_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Du darfst ihm dein Geld nicht um Zins geben, noch deine Nahrungsmittel um Wucher. ");
INSERT INTO deutkw_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ich bin Jahwe, euer Gott, der euch aus Ägypten weggeführt hat, um euch das Land Kanaan zu verleihen, um euer Gott zu sein. ");
INSERT INTO deutkw_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Und wenn dein Bruder neben dir verarmt und sich dir verkauft, so sollst du ihn nicht Sklavendienst thun lassen. ");
INSERT INTO deutkw_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Gleich einem Lohnarbeiter, einem Beisassen, soll er bei dir sein; bis zum Halljahre soll er bei dir dienen. ");
INSERT INTO deutkw_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Dann aber soll er samt seinen Kindern frei von dir ausgehen und zu seinem Geschlechte zurückkehren und wieder zu seinem väterlichen Besitztume kommen. ");
INSERT INTO deutkw_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Denn meine Knechte sind sie, die ich aus Ägypten weggeführt habe; sie dürfen nicht verkauft werden, wie man Sklaven verkauft. ");
INSERT INTO deutkw_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Du sollst nicht mit Härte über ihn herrschen, sondern dich fürchten vor deinem Gotte. ");
INSERT INTO deutkw_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Und wenn du Sklaven und Sklavinnen haben willst: Von den Völkern, die euch rings umgeben, - von denen mögt ihr Sklaven und Sklavinnen kaufen. ");
INSERT INTO deutkw_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Auch von den Kindern der Beisassen, die sich bei euch aufhalten, mögt ihr welche kaufen, sowie aus ihrer Sippschaft, die sich bei euch befindet, die in eurem Lande geboren ist; sie sollen euer Besitztum sein, ");
INSERT INTO deutkw_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","und ihr mögt sie auf eure Kinder nach euch vererben, daß sie ihr Eigentum seien, und mögt sie so dauernd zu Sklaven haben. Aber über eure Brüder, die Israeliten, - da darfst du nicht, einer über den andern, mit Härte herrschen. ");
INSERT INTO deutkw_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Und wenn ein Fremdling oder Beisaß neben dir zu Besitz gelangt, dagegen dein Bruder neben ihm verarmt und sich einem Fremdling oder Beisassen oder einem Abkömmling von der Sippschaft eines Fremdlings neben dir verkauft, ");
INSERT INTO deutkw_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","so soll er, nachdem er sich verkauft hat, wieder ausgelöst werden können. Einer seiner Brüder mag ihn auslösen, ");
INSERT INTO deutkw_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","oder sein Oheim oder der Sohn seines Oheims mag ihn auslösen, oder sonst einer von seinen nächsten Blutsverwandten aus seinem Geschlechte mag ihn auslösen; oder, wenn er selbst wieder zu Besitz gelangt, so mag er sich auslösen. ");
INSERT INTO deutkw_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Und zwar soll er mit dem, der ihn gekauft hat, die Zeit berechnen von dem Jahr ab, wo er sich ihm verkaufte, bis zum Halljahr. Der Preis, um den er sich verkauft, soll der Anzahl der Jahre entsprechen; gleich einem Lohnarbeiter ist er eine bestimmte Zeit bei ihm. ");
INSERT INTO deutkw_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Wenn noch viele Jahre fehlen, so hat er zum Behufe seiner Auslösung einen dementsprechenden Betrag von der Kaufsumme zurückzuerstatten. ");
INSERT INTO deutkw_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Wenn aber nur noch wenige Jahre bis zum Halljahre fehlen, so muß er sie ihm auch berechnen; nach seinen Dienstjahren richtet es sich, wie viel er zum Behufe seiner Auslösung zurückzuerstatten hat. ");
INSERT INTO deutkw_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Gleich einem, der Jahr um Jahr für Lohn arbeitet, soll er bei ihm sein; du darfst nicht ruhig mit ansehen, daß er mit Härte über ihn herrscht. ");
INSERT INTO deutkw_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Falls er aber nicht in dieser Weise ausgelöst wird, so soll er samt seinen Kindern im Halljahre frei ausgehen. ");
INSERT INTO deutkw_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Denn die Israeliten gehören mir als Knechte zu; meine Knechte sind sie, der ich sie aus Ägypten weggeführt habe, ich, Jahwe, ihr Gott! ");
INSERT INTO deutkw_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Ihr dürft euch nicht Götzen anfertigen und euch nicht Schnitzbilder und Malsteine aufstellen, noch einen Stein mit Bildwerk in eurem Lande setzen, um euch davor niederzuwerfen, denn ich bin Jahwe, euer Gott. ");
INSERT INTO deutkw_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Meine Ruhetage sollt ihr beobachten und euch vor meinem Heiligtume scheuen; ich bin Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Wenn ihr nach meinen Satzungen wandeln und meine Gebote beobachten und nach ihnen thun wollt, ");
INSERT INTO deutkw_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","so will ich euch jedesmal zur rechten Zeit Regen senden, daß der Boden seinen Ertrag gebe, und die Bäume auf dem Feld ihre Früchte tragen; ");
INSERT INTO deutkw_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","da soll sich bei euch die Dreschzeit bis zur Weinlese hinziehen und die Weinlese bis zur Saatzeit, daß ihr Brot in Fülle zu essen habt und sicher in eurem Lande wohnt. ");
INSERT INTO deutkw_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Und ich will machen, daß Friede im Lande herrscht, das ihr euch niederlegen könnt, ohne daß euch jemand aufschreckt; die reißenden Tiere will ich wegschaffen aus dem Land, und kein Schwert soll in euer Land eindringen. ");
INSERT INTO deutkw_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Ihr werdet eure Feinde in die Flucht schlagen, daß sie auf der Flucht vor euch dem Schwerte verfallen. ");
INSERT INTO deutkw_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Fünf von euch sollen hundert in die Flucht schlagen, und hundert von euch sollen zehntausend in die Flucht schlagen, so daß eure Feinde auf der Flucht vor euch dem Schwerte verfallen. ");
INSERT INTO deutkw_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Und ich werde mich zu euch wenden und will verleihen, daß ihr euch mehrt und zahlreich werdet, und will meinen Bund mit euch in Kraft treten lassen. ");
INSERT INTO deutkw_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Und ihr werdet abgelagertes altes Getreide zu essen haben und das alte hinausschaffen müssen, um das neue unterzubringen. ");
INSERT INTO deutkw_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Und ich werde meinen Wohnsitz unter euch aufschlagen und keinen Widerwillen gegen euch hegen, ");
INSERT INTO deutkw_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","sondern werde unter euch wandeln und will euer Gott sein, und ihr sollt mein Volk sein. ");
INSERT INTO deutkw_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Ich bin Jahwe, euer Gott, der euch aus Ägypten weggeführt hat, damit ihr nicht länger ihre Sklaven wäret; ich zerbrach die Stangen eures Jochs und ließ euch aufrecht einhergehn. ");
INSERT INTO deutkw_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Wenn ihr mir aber nicht gehorcht und nicht durchaus nach diesen Geboten handelt, ");
INSERT INTO deutkw_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","wenn ihr meine Satzungen verachtet und gegen meine Rechte Widerwillen hegt, so daß ihr nicht durchaus nach meinen Geboten handelt und so den Bund mit mir brecht, ");
INSERT INTO deutkw_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","so will auch ich demgemäß mit euch verfahren und will Schreckliches über euch verhängen: Schwindsucht und Fieber, die die Augen erlöschen und das Leben schwinden machen. Da sollt ihr dann vergeblich euren Samen säen, denn eure Feinde werden es verzehren. ");
INSERT INTO deutkw_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Und ich werde mein Angesicht wider euch kehren, daß ihr geschlagen werdet und fliehen müßt vor euren Feinden; und eure Hasser werden euch unterjochen, und ihr werdet fliehen, auch wenn euch niemand verfolgt. ");
INSERT INTO deutkw_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Und wenn ihr mir auch dann noch ungehorsam seid, so will ich euch noch siebenmal härter züchtigen um eurer Sünden willen ");
INSERT INTO deutkw_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","und will euren frechen Stolz brechen und will machen, daß der Himmel über euch wie Eisen und euer Boden wie Erz ist. ");
INSERT INTO deutkw_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Da werdet ihr euch dann nutzlos abquälen: der Boden wird euch keinen Ertrag geben, und die Bäume im Lande werden keine Früchte tragen. ");
INSERT INTO deutkw_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Und wenn ihr mir zuwiderhandelt und mir nicht gehorchen wollt, so will ich euch weiter schlagen siebenmal, wie es eure Sünden verdienen. ");
INSERT INTO deutkw_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Da werde ich die wilden Tiere gegen euch entsenden, daß Sie euch eurer Kinder berauben und euer Vieh würgen und eure Zahl mindern, so daß eure Straßen veröden. ");
INSERT INTO deutkw_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Und wenn ihr euch dadurch nicht von mir warnen laßt, sondern mir zuwiderhandelt, ");
INSERT INTO deutkw_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","so will auch ich euch zuwiderhandeln und will euch meinerseits schlagen siebenmal um eurer Sünden willen ");
INSERT INTO deutkw_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","und will ein Schwert über euch kommen lassen, das Rache nehmen soll für den Bundesbruch. Und wenn ihr euch dann in eure Städte zurückziehen werdet, so will ich die Pest unter euch senden, und ihr sollt in Feindeshand gegeben werden. ");
INSERT INTO deutkw_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Wenn ich euch die Stütze des Brotes zerbreche, so werden dann zehn Weiber in einem Backtopfe Brot für euch backen und euch das Brot abgewogen zurückbringen, und ihr werdet essen, aber nicht satt werden. ");
INSERT INTO deutkw_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Und wenn ihr mir trotzdem ungehorsam seid und mir zuwiderhandelt, ");
INSERT INTO deutkw_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","so will dann auch ich im Grimm euch zuwiderhandeln und euch züchtigen siebenmal um eurer Sünden willen. ");
INSERT INTO deutkw_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Und ihr sollt das Fleisch eurer Söhne verzehren und das Fleisch eurer Töchter sollt ihr verzehren. ");
INSERT INTO deutkw_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Und ich will eure Opferhöhen verwüsten und eure Sonnensäulen zerstören und will eure Leichen auf die Leichen eurer Götzen werfen und werde Abscheu vor euch empfinden. ");
INSERT INTO deutkw_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Eure Städte will ich zu Trümmerhaufen machen und eure Heiligtümer verwüsten und will nicht riechen den lieblichen Geruch eurer Opfer. ");
INSERT INTO deutkw_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Ja, ich selbst will das Land verwüsten, daß sich eure Feinde, die sich darin niederlassen, darüber entsetzen sollen. ");
INSERT INTO deutkw_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Euch aber will ich verstreuen unter den Völkern und will hinter euch her das Schwert zücken; und euer Land soll zur Wüste und eure Städte sollen zu Trümmerhaufen werden. ");
INSERT INTO deutkw_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Da wird dann das Land seine Ruhezeiten ersetzt bekommen die ganze Zeit hindurch, in der es wüste liegt, während ihr im Land eurer Feinde seid; da wird dann das Land Ruhe haben und seine Ruhezeiten abtragen. ");
INSERT INTO deutkw_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Die ganze Zeit hindurch, in der es wüste liegt, wird es Ruhe haben - die Ruhe, die es nicht gehabt hat zu den Ruhezeiten, die euch geboten waren, als ihr noch darin wohntet. ");
INSERT INTO deutkw_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Und die von euch übrig sein werden, die will ich gänzlich verzagt machen in den Ländern ihrer Feinde, daß sie das Rauschen eines verwehten Blattes in die Flucht jagen soll, daß sie fliehen sollen, wie man vor dem Schwerte flieht, und hinstürzen, obschon sie niemand verfolgt. ");
INSERT INTO deutkw_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Und sie sollen übereinander fallen, wie auf der Flucht vor dem Schwert, obschon sie niemand verfolgt; und ihr sollt nicht Stand halten können vor euren Feinden. ");
INSERT INTO deutkw_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Und ihr sollt unter den Heiden zu Grunde gehen, und das Land eurer Feinde soll euch verzehren. ");
INSERT INTO deutkw_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Und die von euch übrig sein werden, sollen infolge ihrer Sündenschuld in den Ländern eurer Feinde dahinsiechen; überdies auch infolge der Verschuldungen ihrer Väter sollen sie dahinsiechen, wie diese. ");
INSERT INTO deutkw_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Wenn Sie dann ihre Sündenschuld und die Schuld ihrer Väter bekennen - die Untreue, die sie gegen mich begangen haben, und wie sie mir zuwidergehandelt haben, ");
INSERT INTO deutkw_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","daher auch ich ihnen zuwiderhandelte und sie in das Land ihrer Feinde verbrachte, - ja, wenn sich dann ihr unbeschnittenes Herz beugt, und Sie alsdann ihre Sündenschuld büßen, ");
INSERT INTO deutkw_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","so will ich an meinen Bund mit Jakob gedenken und auch meines Bundes mit Isaak, sowie meines Bundes mit Abraham will ich gedenken und des Landes will ich gedenken. ");
INSERT INTO deutkw_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Es muß aber das Land von ihnen verlassen werden und seine Ruhezeiten ersetzt bekommen, während es wüste liegt nach ihrer Entfernung; sie selbst aber müssen ihre Sündenschuld büßen, dieweil Sie meine Rechte verworfen und gegen meine Satzungen Widerwillen gehegt haben. ");
INSERT INTO deutkw_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Aber selbst dann, wenn sie im Land ihrer Feinde sind, verwerfe ich sie nicht und verabscheue ich sie nicht, daß ich sie ganz vertilgen und so meinen Bund mit ihnen brechen sollte, denn ich bin Jahwe, euer Gott. ");
INSERT INTO deutkw_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Und ich will zu ihrem Besten gedenken an den Bund mit den Vorfahren, die ich vor den Augen der Heiden aus Ägypten weggeführt habe, um ihr Gott zu sein - ich, Jahwe! ");
INSERT INTO deutkw_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Das sind die Satzungen und Rechte und Weisungen, die Jahwe auf dem Berge Sinai durch Mose gegeben hat, daß sie zwischen ihm und den Israeliten zu Recht bestehen sollten. ");
INSERT INTO deutkw_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Rede mit den Israeliten und sprich zu ihnen: Wenn jemand Jahwe ein Gelübde abträgt, und zwar ein solches von Personen nach dem Schätzungswert, ");
INSERT INTO deutkw_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","so soll der Schätzungswert eines Mannes von zwanzig bis zu sechzig Jahren fünfzig Silbersekel nach dem heiligen Gewichte betragen; ist es aber ein Weib, so soll der Schätzungswert dreißig Sekel betragen. ");
INSERT INTO deutkw_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Ist es jemand von fünf bis zu zwanzig Jahren, ");
INSERT INTO deutkw_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","so soll der Schätzungswert der männlichen Person zwanzig Sekel, der weiblichen zehn SekeI betragen. ");
INSERT INTO deutkw_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Ist es jemand von einem Monat bis zu fünf Jahren, so soll der Schätzungswert des Knaben fünf Silbersekel, der Schätzungswert des Mädchens drei Silbersekel betragen. ");
INSERT INTO deutkw_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Ist es jemand von sechzig Jahren und darüber, so soll der Schätzungswert des Mannes fünfzehn Sekel betragen, der des Weibes zehn Sekel. ");
INSERT INTO deutkw_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Und wenn der Betreffende zu arm ist, um den Schätzungswert zu entrichten, so stelle man ihn vor den Priester, und der Priester möge ihn abschätzen; mit Rücksicht darauf, wie viel der Gelobende zu leisten vermag, soll ihn der Priester abschätzen. ");
INSERT INTO deutkw_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Und wenn es Vieh ist, von welchem man Jahwe Opfer bringen kann, so soll alles, was einer Jahwe davon giebt, als geheiligt gelten. ");
INSERT INTO deutkw_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Er darf es nicht umwechseln, noch vertauschen - ein gutes für ein schlechtes oder ein schlechtes für ein gutes; und wenn er dennoch ein Stück Vieh mit einem anderen vertauschen sollte, so soll das eine wie das andere dem Heiligtume verfallen sein. ");
INSERT INTO deutkw_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Ist es aber irgend welches unreines Vieh, von dem man Jahwe keine Opfer bringen kann, so soll man das Vieh dem Priester darstellen, ");
INSERT INTO deutkw_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","und der Priester soll es abschätzen, je nachdem es schön oder gering ist; bei dem Schätzungswerte, den der Priester festsetzt, soll es verbleiben. ");
INSERT INTO deutkw_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Will er es aber einlösen, so hat er noch ein Fünftel von dem Schätzungswerte darauf zu legen. ");
INSERT INTO deutkw_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Und wenn jemand Jahwe sein Haus als heilige Gabe weiht, so soll es der Priester abschätzen, je nachdem es schön oder gering ist; so, wie es der Priester abschätzt, soll es zu stehen kommen. ");
INSERT INTO deutkw_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Falls aber der, der sein Haus geweiht hat, es wieder einlösen will, so hat er noch ein Fünftel der Schätzungssumme darauf zu legen; dann gehört es ihm. ");
INSERT INTO deutkw_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Wenn jemand etwas von seinem erblichen Grundbesitze Jahwe weiht, so richtet sich der Schätzungswert nach dem Maße der Aussaat; ein Feld von einem Gomer Gerste Aussaat ist auf fünfzig Silbersekel zu schätzen. ");
INSERT INTO deutkw_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Weiht er sein Feld vom Halljahr ab, so soll es nach dem Schätzungswerte zu stehen kommen. ");
INSERT INTO deutkw_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Weiht er aber sein Feld nach dem Halljahr, so muß ihm der Priester den Betrag berechnen mit Rücksicht auf die Zahl der Jahre, die noch bis zum Halljahre fehlen, und es ist dann von dem vollen Schätzungswert ein Abzug zu machen. ");
INSERT INTO deutkw_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Will aber der, der das Feld geweiht hat, es doch wieder einlösen, so hat er ein Fünftel der Schätzungssumme darauf zu legen; dann verbleibt es ihm. ");
INSERT INTO deutkw_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Löst er das Feld nicht ein, verkauft aber trotzdem das Feld an einen anderen, so kann es nicht wiederum eingelöst werden, ");
INSERT INTO deutkw_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","sondern das Feld hat, wenn es im Halljahre frei wird, als etwas Jahwe Geweihtes zu gelten, wie ein dem Banne verfallenes Feld; das Eigentumsrecht daran fällt dem Priester zu. ");
INSERT INTO deutkw_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Weiht er dagegen Jahwe ein von ihm erkauftes Feld, welches nicht zu seinem erblichen Grundbesitze gehört, ");
INSERT INTO deutkw_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","so muß ihm der Priester ausrechnen, wie hoch sich der Schätzungswert für den Zeitraum bis zum Halljahre beläuft, und er soll diesen Schätzungswert am gleichen Tag als eine Jahwe geweihte Gabe entrichten. ");
INSERT INTO deutkw_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Im Halljahr aber kommt das Feld wieder an den, von dem er es gekauft hatte, dem es als Erbbesitz gehörte. ");
INSERT INTO deutkw_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Alle Schätzungen haben nach heiligem Gewichte zu geschehen; zwanzig Gera machen einen Sekel. ");
INSERT INTO deutkw_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Jedoch Erstgeburten unter dem Vieh, die als erstgeborne Jahwe verfallen, darf niemand weihen; es sei Rind oder Schaf - es gehört Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Handelt es sich aber um unreines Vieh, so muß man es loskaufen nach dem Schätzungswert und ein Fünftel des Betrags darauf legen; falls es aber nicht eingelöst wird, ist es nach dem Schätzungswerte zu verkaufen. ");
INSERT INTO deutkw_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Gebanntes jedoch, welches jemand Jahwe mittels des Bannes weiht von allem, was ihm gehört, es seien Menschen oder Vieh oder erblicher Grundbesitz, darf niemals verkauft oder eingelöst werden; alles Gebannte ist Jahwe hochheilig. ");
INSERT INTO deutkw_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Wenn irgend Menschen mit dem Banne belegt werden, so dürfen sie nicht losgekauft werden, sondern müssen getötet werden. ");
INSERT INTO deutkw_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Alle Zehnten vom Boden, von der Saatfrucht, wie von den Baumfrüchten, gehören Jahwe, sind Jahwe geheiligt. ");
INSERT INTO deutkw_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Sollte aber jemand einen Teil seines Zehnten einlösen wollen, so hat er ein Fünftel des Betrags darauf zu legen. ");
INSERT INTO deutkw_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Was aber den Zehnten von den Rindern und Schafen anlangt, so soll von allem, was unter dem Hirtenstab hindurchgeht, das je zehnte Stück Jahwe geheiligt sein. ");
INSERT INTO deutkw_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Man soll nicht untersuchen, ob es gut oder schlecht sei, und darf es nicht mit einem anderen vertauschen. Sollte es einer aber doch vertauschen, so ist das eine wie das andere dem Heiligtume verfallen und darf nicht eingelöst werden. ");
INSERT INTO deutkw_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Das sind die Gebote, die Jahwe Mose auf dem Berge Sinai für die Israeliten auftrug. ");
INSERT INTO deutkw_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Und Jahwe redete mit Mose in der Steppe am Sinai, im Offenbarungszelt, am ersten Tage des zweiten Monats im zweiten Jahre nach ihrem Auszug aus Ägypten, und gebot: ");
INSERT INTO deutkw_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","Nehmt die Gesamtzahl der ganzen Gemeinde der Israeliten auf, Geschlecht für Geschlecht, Familie für Familie samt den einzelnen Namen - alles, was männlich ist, Kopf für Kopf. ");
INSERT INTO deutkw_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Alles, was kriegstüchtig ist in Israel, von zwanzig Jahren an und darüber, sollt ihr mustern, Schar für Schar, du und Aaron. ");
INSERT INTO deutkw_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Und von jedem Stamme soll euch je einer, und zwar das Oberhaupt der zum Stamme gehörenden Familien, zugesellt sein. ");
INSERT INTO deutkw_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Dies sind die Namen der Männer, die euch zur Seite stehen sollen: von Ruben Elizur, der Sohn Sedeurs, ");
INSERT INTO deutkw_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","von Simeon Selumiel, der Sohn Zuri-Sadais, ");
INSERT INTO deutkw_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","von Juda Nahasson, der Sohn Amminadabs, ");
INSERT INTO deutkw_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","von Issachar Nethaneel, der Sohn Zuars, ");
INSERT INTO deutkw_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","von Sebulon Eliab, der Sohn Helons, ");
INSERT INTO deutkw_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","von den Söhnen Josephs: von Ephraim Elisama, der Sohn Ammihuds, von Manasse Gamliel, der Sohn Pedazurs; ");
INSERT INTO deutkw_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","von Benjamin Abidan, der Sohn Gideonis, ");
INSERT INTO deutkw_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","von Dan Ahieser, der Sohn Ammi-Sadais, ");
INSERT INTO deutkw_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","von Asser Pagiel, der Sohn Ochrans, ");
INSERT INTO deutkw_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","von Gad Eliasaph, der Sohn Deguels, ");
INSERT INTO deutkw_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","von Naphthali Ahira, der Sohn Enans. ");
INSERT INTO deutkw_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Das waren die aus der Gemeinde Berufenen, die Fürsten ihrer väterlichen Stämme, die Häupter der Tausendschaften Israels. ");
INSERT INTO deutkw_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Da ließen Mose und Aaron die genannten Männer, die ihnen namentlich bezeichnet worden waren, zu sich kommen ");
INSERT INTO deutkw_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","und versammelten die ganze Gemeinde am ersten Tage des zweiten Monats. Da ließen sie sich in die Geburts-Verzeichnisse eintragen nach ihren Geschlechtern, Familien und einzelnen Namen, von zwanzig Jahren an und darüber, Kopf für Kopf, ");
INSERT INTO deutkw_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","wie Jahwe Mose befohlen hatte; so musterte er sie denn in der Steppe am Sinai. ");
INSERT INTO deutkw_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Es beliefen sich aber die Abkömmlinge der Söhne Rubens, des Erstgebornen Israels, nach ihren Geschlechtern, Familien und einzelnen Namen, Kopf für Kopf gerechnet - alles, was männlich war von zwanzig Jahren an und darüber, alles, was kriegstüchtig war, ");
INSERT INTO deutkw_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","so viele ihrer vom Stamme Ruben gemustert wurden, auf 46500. ");
INSERT INTO deutkw_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Die Abkömmlinge der Söhne Simeons nach ihren Geschlechtern, Familien und einzelnen Namen, Kopf für Kopf gerechnet - alles, was männlich war von zwanzig Jahren an und darüber, alles, was kriegstüchtig war, ");
INSERT INTO deutkw_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","so viele ihrer vom Stamme Simeon gemustert wurden, beliefen sich auf 59300. ");
INSERT INTO deutkw_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Die Abkömmlinge der Söhne Gads nach ihren Geschlechtern, Familien und einzelnen Namen, von zwanzig Jahren an und darüber, alles, was kriegstüchtig war, ");
INSERT INTO deutkw_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","so viele ihrer vom Stamme Gad gemustert wurden, beliefen sich auf 45650. ");
INSERT INTO deutkw_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Die Abkömmlinge der Söhne Judas nach ihren Geschlechtern, Familien und einzelnen Namen, von zwanzig Jahren an und darüber, alles, was kriegstüchtig war, ");
INSERT INTO deutkw_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","so viele ihrer vom Stamme Juda gemustert wurden, beliefen sich auf 74600. ");
INSERT INTO deutkw_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Die Abkömmlinge der Söhne Issachars nach ihren Geschlechtern, Familien und einzelnen Namen, von zwanzig Jahren an und darüber, alles, was kriegstüchtig war, ");
INSERT INTO deutkw_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","so viele ihrer vom Stamme Issachar gemustert wurden, beliefen sich auf 54400. ");
INSERT INTO deutkw_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Die Abkömmlinge der Söhne Sebulons nach ihren Geschlechtern, Familien und einzelnen Namen, von zwanzig Jahren an und darüber, alles, was kriegstüchtig war, ");
INSERT INTO deutkw_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","so viele ihrer vom Stamme Sebulon gemustert wurden, beliefen sich auf 57400. ");
INSERT INTO deutkw_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Was die Söhne Josephs anbelangt, so beliefen sich die Abkömmlinge der Söhne Ephraims nach ihren Geschlechtern, Familien und einzelnen Namen, von zwanzig Jahren an und darüber, alles, was kriegstüchtig war, ");
INSERT INTO deutkw_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","so viele ihrer vom Stamme Ephraim gemustert wurden, auf 40500; ");
INSERT INTO deutkw_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","die Abkömmlinge der Söhne Manasses nach ihren Geschlechtern, Familien und einzelnen Namen, von zwanzig Jahren an und darüber, alles, was kriegstüchtig war, ");
INSERT INTO deutkw_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","so viele ihrer vom Stamme Manasse gemustert wurden, auf 32200. ");
INSERT INTO deutkw_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Die Abkömmlinge der Söhne Benjamins nach ihren Geschlechtern, Familien und einzelnen Namen, von zwanzig Jahren an und darüber, alles, was kriegstüchtig war, ");
INSERT INTO deutkw_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","so viele ihrer vom Stamme Benjamin gemustert wurden, beliefen sich auf 35400. ");
INSERT INTO deutkw_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Die Abkömmlinge der Söhne Dans nach ihren Geschlechtern, Familien und einzelnen Namen, von zwanzig Jahren an und darüber, alles, was kriegstüchtig war, ");
INSERT INTO deutkw_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","so viele ihrer vom Stamme Dan gemustert wurden, beliefen sich auf 62700. ");
INSERT INTO deutkw_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Die Abkömmlinge der Söhne Assers nach ihren Geschlechtern, Familien und einzelnen Namen, von zwanzig Jahren an und darüber, alles, was kriegstüchtig war, ");
INSERT INTO deutkw_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","so viele ihrer vom Stamme Asser gemustert wurden, beliefen sich auf 41500. ");
INSERT INTO deutkw_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Die Abkömmlinge der Söhne Naphthalis nach ihren Geschlechtern, Familien und einzelnen Namen, von zwanzig Jahren an und darüber, alles, was kriegstüchtig war, ");
INSERT INTO deutkw_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","so viele ihrer vom Stamme Naphthali gemustert wurden, beliefen sich auf 53.400. ");
INSERT INTO deutkw_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Das sind die Gemusterten, die Mose und Aaron und die Fürsten Israels musterten; derer waren zwölf, je einer für den zu ihm gehörenden Stamm. ");
INSERT INTO deutkw_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Und es beliefen sich alle, die von den Israeliten nach ihren Familien gemustert waren, von zwanzig Jahren an und darüber, alles, was kriegstüchtig war in Israel, - ");
INSERT INTO deutkw_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","es beliefen sich alle Gemusterten auf 603550. ");
INSERT INTO deutkw_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Die Leviten aber nach ihrem väterlichen Stamme wurden nicht mit unter ihnen gemustert. ");
INSERT INTO deutkw_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","Jedoch den Stamm Levi darfst du nicht mit mustern und ihre Gesamtzahl nicht aufnehmen inmitten der übrigen Israeliten. ");
INSERT INTO deutkw_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Stelle du die Leviten an bei der Wohnung des Gesetzes und allen ihren Geräten und allem, was zu ihr gehört; sie sollen die Wohnung und alle ihre Geräte tragen und sie sollen sie bedienen und sich rings um die Wohnung lagern. ");
INSERT INTO deutkw_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Wenn sich die Wohnung in Bewegung setzt, sollen die Leviten sie abbrechen, und wenn die Wohnung rastet, sollen die Leviten sie aufrichten; ein Fremder aber, der herantritt, soll getötet werden. ");
INSERT INTO deutkw_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Die übrigen Israeliten sollen sich nach ihren Heerscharen ein jeder in seinem Lager und bei seinem Paniere lagern; ");
INSERT INTO deutkw_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","die Leviten aber sollen sich rings um die Wohnung des Gesetzes lagern, daß nicht etwa ein Zorn über die Gemeinde der Israeliten komme. So sollen denn die Leviten des Dienstes an der Wohnung des Gesetzes warten. ");
INSERT INTO deutkw_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Und es thaten die Israeliten ganz, wie Jahwe Mose befohlen hatte, - also thaten sie. ");
INSERT INTO deutkw_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Und Jahwe redete mit Mose und Aaron also: ");
INSERT INTO deutkw_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Die Israeliten haben sich zu Iagern, ein jeder bei seinem Panier, bei den Feldzeichen seines Stammes; gegenüber dem Offenbarungszelte sollen sie sich ringsum lagern. ");
INSERT INTO deutkw_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Und zwar sollen nach vorn, nach Osten zu, lagern: das Panier des Lagers Judas nach seinen Heerscharen, und als Anführer der Söhne Judas Nahasson, der Sohn Amminadabs, ");
INSERT INTO deutkw_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","mit seinem Heer und mit ihren Gemusterten, 74600. ");
INSERT INTO deutkw_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Und neben ihm soll sich lagern der Stamm Issachar, und als Anführer der Söhne Issachars Nethaneel, der Sohn Zuars, ");
INSERT INTO deutkw_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","mit seinem Heer und seinen Gemusterten, 54400; ");
INSERT INTO deutkw_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","ferner der Stamm Sebulon, und als Anführer der Söhne Sebulons Eliab, der Sohn Helons, ");
INSERT INTO deutkw_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","mit seinem Heer und seinen Gemusterten, 57400. ");
INSERT INTO deutkw_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Alle die Gemusterten im Lager Judas nach ihren Heerscharen zählen somit 186400; sie haben zuerst aufzubrechen. ");
INSERT INTO deutkw_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Nach Süden zu soll sich lagern das Panier des Lagers Rubens nach seinen Heerscharen, und als Anführer der Söhne Rubens Elizur, der Sohn Sedeurs, ");
INSERT INTO deutkw_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","mit seinem Heer und seinen Gemusterten, 46500. ");
INSERT INTO deutkw_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Und neben ihm soll sich lagern der Stamm Simeon, und als Anführer der Söhne Simeons Selumiel, der Sohn Zuri-Sadais, ");
INSERT INTO deutkw_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","mit seinem Heer und mit ihren Gemusterten, 59300; ");
INSERT INTO deutkw_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","ferner der Stamm Gad, und als Anführer der Söhne Gads Eliasaph, der Sohn Reguels, ");
INSERT INTO deutkw_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","mit seinem Heer und mit ihren Gemusterten, 45650. ");
INSERT INTO deutkw_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Alle die Gemusterten im Lager Rubens nach ihren Heerscharen zählen somit 151450; diese haben an zweiter Stelle aufzubrechen. ");
INSERT INTO deutkw_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Das Offenbarungszelt aber, das Lager der Leviten, soll aufbrechen inmitten der übrigen Lager; wie sie lagern, so haben Sie aufzubrechen, ein jeder auf seiner Seite, nach ihren Panieren. ");
INSERT INTO deutkw_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Das Panier des Lagers Ephraims nach seinen Heerscharen soll sich lagern nach Westen zu, und als Anführer der Söhne Ephraims Elisama, der Sohn Ammihuds, ");
INSERT INTO deutkw_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","mit seinem Heer und mit ihren Gemusterten, 40500; ");
INSERT INTO deutkw_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","und neben ihm der Stamm Manasse, und als Anführer der Söhne Manasses Gamliel, der Sohn Pedazurs, ");
INSERT INTO deutkw_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","mit seinem Heer und mit ihren Gemusterten, 32200; ");
INSERT INTO deutkw_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","ferner der Stamm Benjamin, und als Anführer der Söhne Benjamins Abidan, der Sohn Gideonis, ");
INSERT INTO deutkw_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","mit seinem Heer und mit ihren Gemusterten, 35 400. ");
INSERT INTO deutkw_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Alle die Gemusterten im Lager Ephraims nach ihren Heerscharen zählen somit 108100. Diese haben an dritter Stelle aufzubrechen. ");
INSERT INTO deutkw_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Das Panier des Lagers Dans nach seinen Heerscharen soll sich lagern nach Norden zu, und als Anführer der Söhne Dans Ahieser, der Sohn Ammi-Sadais, ");
INSERT INTO deutkw_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","mit seinem Heer und mit ihren Gemusterten, 62700. ");
INSERT INTO deutkw_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Und neben ihm soll sich lagern der Stamm Asser, und als Anführer der Söhne Assers Pagiel, der Sohn Ochrans, ");
INSERT INTO deutkw_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","mit seinem Heer und mit ihren Gemusterten, 41500. ");
INSERT INTO deutkw_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Ferner der Stamm Naphthali, und als Anführer der Söhne Naphthalis Ahira, der Sohn Enans, ");
INSERT INTO deutkw_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","mit seinem Heer und mit ihren Gemusterten, 53400. ");
INSERT INTO deutkw_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Alle die Gemusterten im Lager Dans zählen somit 157600. Diese haben zuletzt aufzubrechen nach ihren Panieren. ");
INSERT INTO deutkw_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Das sind die Gemusterten der Israeliten nach ihren Stämmen, sämtliche Gemusterte der verschiedenen Lager nach ihren Heerscharen, 603550. ");
INSERT INTO deutkw_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Die Leviten aber wurden nicht mit gemustert unter den Israeliten, wie Jahwe Mose befohlen hatte. ");
INSERT INTO deutkw_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Und die Israeliten thaten ganz, wie Jahwe Mose befohlen hatte, - also lagerten sie sich nach ihren Panieren und also brachen sie auf, ein jeder nach seinem Geschlechte bei seinem Stamm. ");
INSERT INTO deutkw_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Dies sind die Nachkommen Aarons und Moses, zu der Zeit, wo Jahwe mit Mose auf dem Berge Sinai redete. ");
INSERT INTO deutkw_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Dies sind die Namen der Söhne Aarons: Nadab, der Erstgeborne, und Abihu; Eleasar und Ithamar. ");
INSERT INTO deutkw_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Dies sind die Namen der Söhne Aarons, der gesalbten Priester, denen man die Hand gefüllt hatte, damit sie Priesterdienste thäten. ");
INSERT INTO deutkw_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Es starben aber Nadab und Abihu vor Jahwe, als sie in der Steppe am Sinai ein ungehöriges Feueropfer vor Jahwe brachten; sie hatten aber keine Söhne. So pflegten nun Eleasar und Ithamar unter den Augen ihres Vaters Aaron des Priesteramts. ");
INSERT INTO deutkw_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Laß den Stamm Levi herzutreten und stelle ihn vor Aaron, den Priester, damit sie ihm dienen; ");
INSERT INTO deutkw_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","und sie sollen besorgen, was es für ihn und für die ganze Gemeinde vor dem Offenbarungszelte zu besorgen giebt, und sollen so den Dienst an der Wohnung verrichten. ");
INSERT INTO deutkw_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Und sie sollen die sämtlichen Geräte des Offenbarungszeltes besorgen, sowie alles, was es für die Israeliten zu besorgen giebt, und sollen so den Dienst an der Wohnung verrichten. ");
INSERT INTO deutkw_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Und du sollst die Leviten Aaron und seinen Söhnen übergeben; ganz zu eigen seien sie ihm gegeben von Seiten der Iraeliten. ");
INSERT INTO deutkw_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Aaron aber und seine Söhne sollst du bestellen, damit sie ihres Priesteramts warten; ein Fremder, der herantritt, soll getötet werden. ");
INSERT INTO deutkw_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","Ich selbst habe die Leviten herausgenommen aus den Israeliten an Stelle aller Erstgebornen der Israeliten, derer, die zuerst den Mutterschoß durchbrochen haben, - damit die Leviten mir gehören sollen. ");
INSERT INTO deutkw_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Denn mir gehören alle Erstgebornen; an dem Tag, an welchem ich alle Erstgeburten in Ägypten tötete, habe ich, Jahwe, mir alle Erstgeburten in Israel geweiht, es seien Menschen oder Vieh; mir sollen sie gehören. ");
INSERT INTO deutkw_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Und Jahwe redete mit Mose in der Steppe am Sinai also: ");
INSERT INTO deutkw_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Mustere die Söhne Levis nach ihren Familien und Geschlechtern; alles, was männlich ist, von einem Monat an und darüber, sollst du von ihnen mustern. ");
INSERT INTO deutkw_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Da musterte sie Mose gemäß dem Befehle Jahwes, wie ihm geheißen war. ");
INSERT INTO deutkw_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Und dies sind die Söhne Levis nach ihren Namen: Gerson, Kahath und Merari. ");
INSERT INTO deutkw_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Und dies sind die Namen der Söhne Gersons nach ihren Geschlechtern: Libni und Simei. ");
INSERT INTO deutkw_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Und die Söhne Kahaths nach ihren Geschlechtern: Amram, Jizhar, Hebron und Usiel. ");
INSERT INTO deutkw_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Und die Söhne Meraris nach ihren Geschlechtern: Maheli und Musi. Das sind die GeschIechter der Leviten nach ihrer Abstammung. ");
INSERT INTO deutkw_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Von Gerson stammt das Geschlecht der Libniter und das Geschlecht der Simeiter. Das sind die Geschlechter der Gersoniter. ");
INSERT INTO deutkw_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Die Gesamtzahl der von ihnen Gemusterten - alles, was männlich war, von einem Monat an und darüber, - betrug 7500. ");
INSERT INTO deutkw_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Die Geschlechter der Gersoniter lagerten jedesmal hinter der Wohnung, nach Westen zu, ");
INSERT INTO deutkw_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","und Oberhaupt der Söhne Gersons war Eliasaph, der Sohn Laels. ");
INSERT INTO deutkw_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Am Offenbarungszelt aber hatten die Söhne Gersons zu besorgen: die Wohnung und das Zeltdach; seine Überdecke und den Vorhang vor der Thüre des Offenbarungszeltes, ");
INSERT INTO deutkw_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","die Umhänge des Vorhofs und den Vorhang vor der Thüre des Vorhofs, der die Wohnung und den Altar rings umgiebt, und die zugehörigen Seile - mit allem, was es dabei zu verrichten gab. ");
INSERT INTO deutkw_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Und von Kahath stammte das Geschlecht der Amramiter, das Geschlecht der Jezehariter, das Geschlecht der Hebroniter und das Geschlecht der Osieliter. Das sind die Geschlechter der Kahathiter; ");
INSERT INTO deutkw_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","ihre Zahl - alles, was männlich war, von einem Monat an und darüber, - betrug 8600 solcher, die die Geschäfte am Heiligtume besorgten. ");
INSERT INTO deutkw_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Die Geschlechter der Söhne Kahaths lagerten jedesmal an der Langseite der Wohnung nach Süden zu, ");
INSERT INTO deutkw_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","und Oberhaupt der Geschlechter der Kahathiter war Elizaphan, der Sohn Usiels. ");
INSERT INTO deutkw_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Sie hatten aber zu besorgen: die Lade, den Tisch, den Leuchter, die Altäre, die heiligen Geräte, mit denen sie den Dienst verrichteten, und den Vorhang - mit allem, was es dabei zu verrichten gab. ");
INSERT INTO deutkw_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Und das Oberhaupt der Leviten-Oberhäupter war Eleasar, der Sohn Aarons, des Priesters, mit der Aufsicht über die, welche die Geschäfte am Heiligtume besorgten. ");
INSERT INTO deutkw_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Von Merari stammte das Geschlecht der Maheliter und das Geschlecht der Musiter; das sind die Geschlechter Meraris. ");
INSERT INTO deutkw_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Die Gesamtzahl der von ihnen Gemusterten - alles, was männlich war, von einem Monat an und darüber, - betrug 6200. ");
INSERT INTO deutkw_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Und Oberhaupt über die Geschlechter Meraris war Zuriel, der Sohn Abihails; sie lagerten jedesmal an der Langseite der Wohnung, nach Norden zu. ");
INSERT INTO deutkw_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Es war aber den Söhnen Meraris übertragen die Sorge für die Bretter der Wohnung, ihre Riegel, Säulen und Füße, samt allen ihren Geräten und allem, was es dabei zu verrichten gab; ");
INSERT INTO deutkw_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","ferner für die Säulen des Vorhofs ringsum mit ihren Füßen, Pflöcken und Seilen. ");
INSERT INTO deutkw_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Vor der Wohnung aber nach vorn zu - vor dem Offenbarungszelte nach Osten zu - lagerten Mose und Aaron mit seinen Söhnen, die den Dienst am Heiligtume besorgten, alles, was für die Israeliten zu besorgen war; ein Fremder aber, der herantritt, soll getötet werden. ");
INSERT INTO deutkw_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Sämtliche von den Leviten Gemusterte, die Mose und Aaron gemäß dem Befehle Jahwes Geschlecht für Geschlecht gemustert hatten - alles, was männlich war, von einem Monat an und darüber, - beliefen sich auf 22000. ");
INSERT INTO deutkw_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Und Jahwe gebot Mose: Mustere alle männlichen Erstgebornen der Israeliten, von einem Monat an und darüber, und nimm die Zahl ihrer Namen auf. ");
INSERT INTO deutkw_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Du sollst aber die Leviten für mich, für Jahwe, nehmen an Stelle aller Erstgebornen unter den Israeliten und das Vieh der Leviten an Stelle aller Erstgeburten unter dem Vieh der Israeliten. ");
INSERT INTO deutkw_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Und Mose musterte alle Erstgebornen unter den Israeliten, wie ihm Jahwe befohlen hatte. ");
INSERT INTO deutkw_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Es betrug aber die Zahl der Namen aller männlichen Erstgebornen von einem Monat an und darüber, so viele ihrer gemustert wurden, 22273. ");
INSERT INTO deutkw_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Nimm die Leviten an Stelle aller Erstgebornen unter den Israeliten und das Vieh der Leviten an Stelle ihrer Viehs, daß die Leviten mir gehören; ich bin Jahwe. ");
INSERT INTO deutkw_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Und was die Auslösung der 273 israelitischen Erstgebornen betrifft, die überzählig sind über die Zahl der Leviten, ");
INSERT INTO deutkw_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","so sollst du für jeden Kopf fünf Sekel erheben; nach heiligem Gewichte sollst du sie erheben, den Sekel zu zwanzig Gera gerechnet. ");
INSERT INTO deutkw_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Dieses Geld sollst du Aaron und seinen Söhnen übergeben als Auslösung derer, die unter ihnen überzählig sind. ");
INSERT INTO deutkw_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Da erhob Mose die Auslösungs-Summe von denen, welche überzählig waren über die durch die Leviten Ausgelösten. ");
INSERT INTO deutkw_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Von den Erstgebornen der Israeliten erhob er die Summe, 1365 Sekel heiliges Gewicht. ");
INSERT INTO deutkw_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Und Mose übergab die Auslösungs-Summe Aaron und seinen Söhnen gemäß dem Befehle Jahwes, wie Jahwe Mose befohlen hatte. ");
INSERT INTO deutkw_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Und Jahwe redete mit Mose und Aaron also: ");
INSERT INTO deutkw_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Nehmt unter den Söhnen Levis die Gesamtzahl der Söhne Kahaths auf, Geschlecht für Geschlecht, Familie für Familie, ");
INSERT INTO deutkw_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","von dreißig Jahren an und darüber bis zu fünfzig Jahren, alle, die sich dem Dienst unterziehen und Geschäfte am Offenbarungszelte verrichten. ");
INSERT INTO deutkw_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Dies ist die Verrichtung der Söhne Kahaths am Offenbarungszelte: die hochheiligen Dinge. ");
INSERT INTO deutkw_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Es sollen aber Aaron und seine Söhne, wenn sich das Lager in Bewegung setzt, hineingehen, den verdeckenden Vorhang herabnehmen und mit ihm die Gesetzeslade umhüllen. ");
INSERT INTO deutkw_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Sodann sollen sie eine Decke von Seekuhfell darauf legen und oben darüber ein ganz aus blauem Purpur bestehendes Tuch breiten und die Stangen einstecken. ");
INSERT INTO deutkw_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Über den Schautisch aber sollen sie ein Tuch von blauem Purpur breiten und darauf die Schüsseln, Schalen und Becher, sowie die Kannen zum Trankopfer setzen; auch das ständig aufgelegte Brot soll darauf liegen. ");
INSERT INTO deutkw_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Über alles dieses aber sollen sie ein Tuch von Karmesin breiten, dieses mit einer Decke von Seekuhfell überdecken und sodann die Stangen einstecken. ");
INSERT INTO deutkw_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Weiter sollen sie ein Tuch von blauem Purpur nehmen und damit den Leuchter überdecken samt seinen Lampen, seinen Lichtscheren und Pfannen und allen seinen Ölgefäßen, mit denen man ihn zu besorgen pflegt; ");
INSERT INTO deutkw_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","sodann sollen sie ihn samt allen seinen Geräten in eine Hülle von Seekuhfell thun und auf die Trage legen. ");
INSERT INTO deutkw_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Über den goldenen Altar aber sollen sie ein Tuch von blauem Purpur breiten, ihn mit einer Decke von Seekuhfell überdecken und die Stangen einstecken. ");
INSERT INTO deutkw_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Sodann sollen sie alle für den Dienst erforderlichen Geräte, mit denen man den Dienst im Heiligtume zu besorgen pflegt, nehmen und in ein Tuch von blauem Purpur thun; dann sollen sie sie mit einer Decke von Seekuhfell überdecken und auf die Trage legen. ");
INSERT INTO deutkw_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Weiter sollen sie den Altar von der Asche reinigen und ein Tuch von rotem Purpur über ihn breiten. ");
INSERT INTO deutkw_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Auf dieses sollen sie alle die Geräte legen, mit denen man den Dienst an ihm zu besorgen pflegt, die Pfannen, Gabeln, Schaufeln und Becken, kurz alle zum Altar gehörigen Geräte; darüber sollen sie eine Hülle von Seekuhfell breiten und die Stangen einstecken. ");
INSERT INTO deutkw_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Und wenn Aaron und seine Söhne mit der Einhüllung der heiligen Dinge und aller der heiligen Geräte zu Ende sind, wenn sich das Lager in Bewegung setzt, so sollen darnach die Söhne Kahaths kommen, um sie zu tragen; aber berühren dürfen sie die heiligen Dinge nicht, sonst müssen sie sterben. Das ist's, was die Söhne Kahaths vom Offenbarungszelte zu tragen haben. ");
INSERT INTO deutkw_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Eleasar aber, dem Sohne Aarons, des Priesters, ist übertragen das Öl für den Leuchter, das wohlriechende Räucherwerk, das regelmäßige Speisopfer und das Salböl, sowie die Aufsicht über die ganze Wohnung und alles, was sich in ihr befindet an heiligen Gegenständen und den dazugehörigen Geräten. ");
INSERT INTO deutkw_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Und Jahwe redete mit Mose und Aaron also: ");
INSERT INTO deutkw_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Laßt es nicht geschehen, daß der Stamm der Geschlechter der Kahathiter mitten aus den Leviten weggetilgt werde. ");
INSERT INTO deutkw_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Vielmehr thut das für sie, damit sie am Leben bleiben und nicht sterben müssen, wenn sie sich den hochheiligen Dingen nähern: Aaron und seine Söhne sollen hineingehen und sie Mann für Mann anstellen bei dem, was sie zu verrichten und was sie zu tragen haben, ");
INSERT INTO deutkw_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","daß sie nicht etwa hineingehen, um auch nur einen Augenblick die heiligen Dinge zu sehen, da sie sonst sterben müssen. ");
INSERT INTO deutkw_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","Nimm nun die Gesamtzahl auch der Söhne Gersons auf, Familie für Familie, Geschlecht für Geschlecht; ");
INSERT INTO deutkw_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","von dreißig Jahren an und darüber bis zu fünfzig Jahren sollst du sie mustern, alle, die sich dem unterziehen, Dienst zu thun und Verrichtungen am Offenbarungszelte zu besorgen. ");
INSERT INTO deutkw_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Dies ist die Verrichtung der Geschlechter der Gersoniter - was sie zu verrichten und zu tragen haben. ");
INSERT INTO deutkw_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Sie haben zu tragen die Teppiche der Wohnung und das Offenbarungszelt, seine Decke und die Decke von Seekuhfell, die oben darüber liegt, sowie den Vorhang vor der Thüre des Offenbarungszeltes, ");
INSERT INTO deutkw_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","ferner die Vorhänge des Vorhofs und den Vorhang vor der Thoröffnung des Vorhofs, der die Wohnung und den Altar rings umgiebt, samt seinen Seilen und allen Geräten, die es dabei zu besorgen giebt; und alles, was dabei zu thun ist, das sollen sie besorgen. ");
INSERT INTO deutkw_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Nach dem Befehl Aarons und seiner Söhne sollen alle Verrichtungen der Gersoniter stattfinden, bezüglich alles dessen, was sie zu tragen, und alles dessen, was sie zu verrichten haben; und zwar sollt ihr ihnen alles, was sie zu tragen haben, namentlich anweisen. ");
INSERT INTO deutkw_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Dies ist's, was die Geschlechter der Gersoniter am Offenbarungszelte zu verrichten haben, und zwar stehe ihr Dienst unter der Leitung Ithamars, des Sohnes Aarons, des Priesters. ");
INSERT INTO deutkw_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Auch die Söhne Meraris sollst du mustern, Geschlecht für Geschlecht, Familie für Familie; ");
INSERT INTO deutkw_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","von dreißig Jahren an und darüber bis zu fünfzig Jahren sollst du sie mustern, alle, die sich dem Dienst unterziehen und die Verrichtungen für das Offenbarungszelt besorgen. ");
INSERT INTO deutkw_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Und das ist's, was ihnen zu tragen obliegt, was sie alles vom Offenbarungszelte zu besorgen haben: die Bretter der Wohnung, ihre Riegel, Säulen und Füße; ");
INSERT INTO deutkw_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","ferner die Säulen des Vorhofs ringsum mit ihren Füßen, Pflöcken und Seilen, mit allen ihren Geräten und allem, was es dabei zu besorgen giebt. Und zwar sollt ihr ihnen die Geräte, die zu tragen ihnen obliegt, namentlich anweisen. ");
INSERT INTO deutkw_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Das ist die Verrichtung der Geschlechter der Söhne Meraris, alles, was sie vom Offenbarungszelt unter der Aufsicht Ithamars, des Sohnes Aarons, des Priesters, zu besorgen haben. ");
INSERT INTO deutkw_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Und Mose, Aaron und die Fürsten der Gemeinde musterten die Kahathiter, Geschlecht für Geschlecht und Familie für Familie, ");
INSERT INTO deutkw_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","von dreißig Jahren an und darüber bis zu fünfzig Jahren, alle, die sich dem Dienste - den Verrichtungen am Offenbarungszelt - unterzogen. ");
INSERT INTO deutkw_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Es beliefen sich aber die Geschlecht für Geschlecht aus ihnen Gemusterten auf 2750. ");
INSERT INTO deutkw_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Das sind die aus den Geschlechtern der Kahathiter Gemusterten, alle, die am Offenbarungszelte Dienst thaten, welche Mose und Aaron musterten gemäß dem Befehle Jahwes durch Mose. ");
INSERT INTO deutkw_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Und was die betrifft, die aus den Söhnen Gersons Geschlecht für Geschlecht und Familie für Familie gemustert waren, ");
INSERT INTO deutkw_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","von dreißig Jahren an und darüber bis zu fünfzig Jahren, alle, die sich dem Dienste - den Verrichtungen am Offenbarungszelt - unterzogen, ");
INSERT INTO deutkw_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","so beliefen sich die Geschlecht für Geschlecht, Familie für Familie aus ihnen Gemusterten auf 2630. ");
INSERT INTO deutkw_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Das sind die aus den Geschlechtern der Söhne Gersons Gemusterten, alle, die am Offenbarungszelt Dienst thaten, welche Mose und Aaron musterten gemäß dem Befehle Jahwes. ");
INSERT INTO deutkw_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Und was die betrifft, die aus den Geschlechtern der Söhne Meraris Geschlecht für Geschlecht, Familie für Familie gemustert waren, ");
INSERT INTO deutkw_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","von dreißig Jahren an und darüber bis zu fünfzig Jahren, alle, die sich dem Dienste - den Verrichtungen am Offenbarungszelt - unterzogen, ");
INSERT INTO deutkw_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","so beliefen sich die Geschlecht für Geschlecht aus ihnen Gemusterten auf 3200. ");
INSERT INTO deutkw_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Das sind die aus den Geschlechtern der Söhne Meraris Gemusterten, die Mose und Aaron musterten gemäß dem Befehle Jahwes durch Mose. ");
INSERT INTO deutkw_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Was aber sämtliche Gemusterte betrifft, die Mose, Aaron und die Fürsten Israels Geschlecht für Geschlecht und Familie für Familie unter den Leviten musterten, ");
INSERT INTO deutkw_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","von dreißig Jahren an und darüber bis zu fünfzig Jahren, alle die sich dem unterzogen, am OffenbarungszeIte dienstliche Verrichtungen, sowie den Dienst des Tragens zu besorgen, ");
INSERT INTO deutkw_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","so beliefen sich die aus ihnen Gemusterten auf 8580. ");
INSERT INTO deutkw_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Gemäß dem Befehle Jahwes stellte man sie unter der Aufsicht Moses Mann für Mann bei dem an, was sie zu besorgen und zu tragen hatten, wie Jahwe Mose befohlen hatte. ");
INSERT INTO deutkw_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","Befiehl den Israeliten, daß Sie alle mit dem Aussatz oder einem Flusse Behafteten, sowie alle, die sich an einer Leiche verunreinigt haben, aus dem Lager hinausschaffen. ");
INSERT INTO deutkw_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Sowohl Männer, als Weiber sollt ihr hinausschaffen; hinaus vor das Lager sollt ihr sie schaffen, damit sie ihr Lager nicht verunreinigen, da doch ich unter ihnen wohne. ");
INSERT INTO deutkw_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Und die Israeliten thaten also und schafften sie hinaus vor das Lager; wie Jahwe Mose geboten hatte, also thaten die Israeliten. ");
INSERT INTO deutkw_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Sage den Israeliten: Wenn ein Mann oder ein Weib irgend eine Sünde begehen, wie sie von den Menschen begangen wird, daß sie eine Veruntreuung gegen Jahwe verüben, und der Betreffende so in Schuld gerät, ");
INSERT INTO deutkw_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","so sollen sie die Sünde, die sie begangen haben, bekennen und sollen das von ihnen Veruntreute nach seinem vollen Werte zurückerstatten und noch ein Fünftel des Betrags darauf legen, und sollen es dem geben, gegen den sie sich verschuldet haben. ");
INSERT INTO deutkw_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Wenn aber der Betreffende keinen nächsten Verwandten hinterlassen hat, dem man die Buße entrichten könnte, so fällt die Buße, die zu entrichten ist, Jahwe zu zum Besten der Priester, abgesehen von dem Sühnewidder, mit dem man ihm Sühne schafft. ");
INSERT INTO deutkw_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Und alle Hebe, von allen heiligen Gaben der Israeliten, die sie zum Priester bringen, soll diesem gehören. ");
INSERT INTO deutkw_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Ihm soll gehören, was irgend jemand heiligt; was jemand dem Priester giebt, soll diesem gehören. ");
INSERT INTO deutkw_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","Sage den Israeliten und sprich zu ihnen: wenn irgend jemandes Weib sich vergeht und ihm untreu wird, ");
INSERT INTO deutkw_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","so daß sich einer fleischlich mit ihr vermischt, ihr Mann aber nichts davon erfährt, und sie unentdeckt bleibt, obschon sie sich verunreinigt hat, auch kein Zeuge wider sie vorhanden ist, indem sie nicht auf der That ertappt ward, ");
INSERT INTO deutkw_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","und es kommt über ihn ein Geist der Eifersucht, so daß er eifersüchtig wird auf sein Weib, indem sie sich verunreinigt hat - oder auch, es kommt über ihn ein Geist der Eifersucht, daß er eifersüchtig wird auf sein Weib, obschon sie sich nicht verunreinigt hat -, ");
INSERT INTO deutkw_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","so soll dieser Mann sein Weib zum Priester bringen und das erforderliche Opfer, das um ihretwillen zu bringen ist, mit hinnehmen: ein Zehntel Epha Gerstenmehl; doch darf er nicht Öl darüber gießen, noch Weihrauch darauf thun. Denn es ist ein Eifersuchts-Speisopfer, ein Offenbarungs-Speisopfer, das Verschuldung offenbar macht. ");
INSERT INTO deutkw_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Hierauf soll sie der Priester herantreten lassen und sie vor Jahwe stellen. ");
INSERT INTO deutkw_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Sodann nehme der Priester heiliges Wasser in ein irdenes Gefäß; ferner nehme der Priester etwas Erde, die sich am Boden der Wohnung befindet, und thue sie in das Wasser. ");
INSERT INTO deutkw_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Und der Priester stelle das Weib vor Jahwe, löse dem Weibe die Haare und gebe ihr das Offenbarungs-Speisopfer in die Hände - ein Eiferfuchts-Speisopfer ist es; aber das fluchbringende Wasser des bitteren Wehs behalte der Priester in der Hand. ");
INSERT INTO deutkw_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Sodann nehme der Priester die Beschwörung mit ihr vor und spreche zu dem Weibe: Wenn dir niemand beigewohnt hat und du dich nicht vergangen und verunreinigt und so die Pflicht gegen deinen Mann verletzt hast, so soll dir dieses fluchbringende Wasser des bitteren Wehs nicht schaden. ");
INSERT INTO deutkw_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Wenn du dich aber vergangen und die Pflicht gegen deinen Mann verletzt und dich verunreinigt hast, und sich irgend jemand außer deinem Manne fleischlich mit dir vermischt hat -. ");
INSERT INTO deutkw_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","So beschwöre nun der Priester das Weib mit feierlicher Verwünschung und der Priester spreche zu dem Weibe: Jahwe mache dich für deine Volksgenossen zu einem Beispiele feierlicher Verwünschung, indem Jahwe deine Hüfte schwinden, deinen Bauch aber anschwellen läßt; ");
INSERT INTO deutkw_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","und dieses fluchbringende Wasser soll eindringen in deine Eingeweide, daß der Bauch schwelle und die Hüfte schwinde! Das Weib aber spreche: So geschehe es! So geschehe es! ");
INSERT INTO deutkw_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Hierauf schreibe der Priester diese Verwünschungen auf ein Blatt, wische sie ab in das Wasser des bitteren Wehs hinein ");
INSERT INTO deutkw_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","und gebe dem Weibe das fluchbringende Wasser des bitteren Wehs zu trinken, damit das fluchbringende Wasser in sie eindringe zu bitterem Weh. ");
INSERT INTO deutkw_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Sodann nehme der Priester dem Weibe das Eifersuchts-Speisopfer aus der Hand, webe das Speisopfer vor Jahwe und bringe es hin zum Altar. ");
INSERT INTO deutkw_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Und zwar soll der Priester eine Hand voll von dem Speisopfer als den Duftteil, der von ihm zu entrichten ist, nehmen und auf dem Altar in Rauch aufgehn lassen, darnach gebe er dem Weibe das Wasser zu trinken. ");
INSERT INTO deutkw_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Und wenn er ihr das Wasser zu trinken gegeben hat, so wird, wenn sie sich verunreinigt hat und ihrem Mann untreu geworden ist, das fluchbringende Wasser in sie eindringen zu bitterem Weh: ihr Bauch wird anschwellen und ihre Hüfte schwinden, und so wird das Weib unter ihren Volksgenossen zu einem Beispiele für Verwünschungen werden. ");
INSERT INTO deutkw_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Hat sich aber das Weib nicht verunreinigt, sondern ist rein, so wird sie unversehrt bleiben und dann schwanger werden. ");
INSERT INTO deutkw_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Das sind die Bestimmungen in betreff der Eifersuchtsklagen: wenn ein Weib sich vergeht und die Pflicht gegen ihren Mann verletzt und sich verunreinigt, ");
INSERT INTO deutkw_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","oder auch, wenn über einen Mann ein Geist der Eifersucht kommt und er eifersüchtig wird auf sein Weib, so stelle er das Weib vor Jahwe, und der Priester verfahre mit ihr ganz nach diesen Bestimmungen. ");
INSERT INTO deutkw_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Der Mann wird frei bleiben von Verschuldung; ein solches Weib aber lädt Verschuldung auf sich. ");
INSERT INTO deutkw_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Rede mit den Israeliten und sprich zu ihnen: Wenn ein Mann oder ein Weib das Gelübde eines Gottgeweihten ablegen will, um sich so Jahwe zu weihen, ");
INSERT INTO deutkw_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","so muß er sich des Weins und berauschenden Getränks enthalten. Auch Essig von Wein oder berauschendem Getränke darf er nicht trinken; er darf keinerlei aus Trauben bereitete Flüssigkeit trinken, noch frische oder getrocknete Trauben essen. ");
INSERT INTO deutkw_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","So lange seine Weihezeit dauert, darf er gar nichts von dem essen, was aus dem Weinstock gewonnen wird, weder unreife Trauben, noch die Spitzen der Ranken. ");
INSERT INTO deutkw_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Die ganze Zeit, für die sein Weihe-Gelübde gilt, darf kein Schermesser über sein Haupt kommen. Bis die Zeit um ist, für die er sich Jahwe geweiht hat, soll er als ein Geheiligter gelten; er hat sein Haupthaar frei wachsen zu lassen. ");
INSERT INTO deutkw_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Die ganze Zeit hindurch, während der er sich Jahwe geweiht hat, darf er zu keiner Leiche hineingehen. ");
INSERT INTO deutkw_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Selbst wenn sein Vater oder seine Mutter, sein Bruder oder seine Schwester stirbt, darf er sich nicht an ihnen verunreinigen, denn die Weihe seines Gottes ist auf seinem Haupte. ");
INSERT INTO deutkw_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Während der ganzen Zeit seiner Weihe ist er Jahwe geheiligt. ");
INSERT INTO deutkw_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Falls aber jemand ganz plötzlich in seiner Gegenwart stirbt, und er so sein geweihtes Haupt verunreinigt, so hat er sein Haupt an dem Tag, an welchem er wieder rein wird, zu scheren: am siebenten Tag hat er es zu scheren. ");
INSERT INTO deutkw_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Am achten Tag aber bringe er zwei Turteltauben oder zwei junge Tauben hin zum Priester vor die Thüre des OffenbarungszeItes. ");
INSERT INTO deutkw_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Und der Priester richte die eine her zu einem Sündopfer, die andere zu einem Brandopfer und schaffe ihm Sühne dafür, daß er sich durch die Verunreinigung an der Leiche versündigt hat; sodann soll er am gleichen Tage sein Haupt aufs neue für geheiligt erklären, ");
INSERT INTO deutkw_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","sich Jahwe für die früher von ihm gelobte Zeit weihen und ein einjähriges Lamm als Schuldopfer bringen; die erste Weihezeit aber wird hinfällig, weil seine Weihe verunreinigt ward. ");
INSERT INTO deutkw_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Und dies sind die Bestimmungen in betreff des Gottgeweihten: wenn die von ihm gelobte Weihezeit um ist, soll man ihn vor die Thüre des Offenbarungszeltes bringen. ");
INSERT INTO deutkw_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Als seine Opfergabe aber hat er Jahwe ein fehlloses, einjähriges Lamm zum Brandopfer und ein fehlloses, einjähriges weibliches Lamm zum Sündopfer, sowie einen fehllosen Widder zum Heilsopfer darzubringen, ");
INSERT INTO deutkw_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","ferner einen Korb mit ungesäuerten Kuchen von Feinmehl, die mit Öl angemacht sind, und ungesäuerte mit Öl bestrichene Fladen, nebst dem zugehörigen Speisopfer und den zugehörigen Trankopfern. ");
INSERT INTO deutkw_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Und der Priester bringe sie vor Jahwe und richte das Sündopfer und das Brandopfer für ihn her. ");
INSERT INTO deutkw_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Den Widder aber richte er her als Heilsopfer für Jahwe, samt dem Korbe mit dem Ungesäuerten; auch das Speisopfer und das Trankopfer richte der Priester für ihn her. ");
INSERT INTO deutkw_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Sodann schere der Gottgeweihte vor der Thüre des Offenbarungszeltes sein geweihtes Haupt, nehme sein geweihtes Haupthaar und werfe es in das Feuer, das unter dem Heilsopfer brennt. ");
INSERT INTO deutkw_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Hierauf nehme der Priester den gekochten Bug von dem Widder nebst einem ungesäuerten Kuchen aus dem Korb und einem ungesäuerten Fladen und gebe es dem Gottgeweihten in die Hände, nachdem derselbe sein geweihtes Haar abgeschoren hat. ");
INSERT INTO deutkw_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Sodann webe es der Priester vor Jahwe als Webe, es ist eine dem Priester zufallende heilige Gabe, außer der Webebrust und der Webekeule. Darnach darf der Gottgeweihte Wein trinken. ");
INSERT INTO deutkw_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Das sind die Bestimmungen in betreff des Gottgeweihten, der ein Gelübde thut, - was er zufolge seiner Weihe Jahwe darzubringen hat, abgesehen von dem, was er außerdem noch zu leisten vermag. Wie das Gelübde fordert, das er abgelegt hat, soll er verfahren, nach den für seine Weihe geltenden Bestimmungen. ");
INSERT INTO deutkw_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Rede mit Aaron und mit seinen Söhnen also: So sollt ihr die Israeliten segnen, indem ihr zu ihnen sprecht: ");
INSERT INTO deutkw_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Jahwe segne dich und behüte dich! ");
INSERT INTO deutkw_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Jahwe lasse sein Angesicht über dich leuchten und sei dir gnädig! ");
INSERT INTO deutkw_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Jahwe erhebe sein Angesicht auf dich und schaffe dir Friede! ");
INSERT INTO deutkw_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","So sollen sie meinen Namen auf die Israeliten legen, und ich will ihnen Segen zu teil werden lassen. ");
INSERT INTO deutkw_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Als nun Mose die Wohnung fertig aufgerichtet und sie gesalbt und geweiht hatte samt allen ihren Geräten, dazu auch den Altar mit allen seinen Geräten gesalbt und geweiht hatte, ");
INSERT INTO deutkw_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","da brachten die Fürsten IsraeIs, die Oberhäupter der einzelnen Stämme - das sind die Stammesfürsten, die Vorstände der Gemusterten - Opfer. ");
INSERT INTO deutkw_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Und zwar brachten sie vor Jahwe als ihre Gabe sechs überdeckte Wagen und zwölf Rinder, je einen Wagen von zwei Fürsten und je ein Rind von jedem; die brachten sie hin vor die Wohnung. ");
INSERT INTO deutkw_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Da sprach Jahwe zu Mose also: ");
INSERT INTO deutkw_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","Nimm sie von ihnen an, damit sie zur Besorgung der Verrichtungen für das Offenbarungszelt verwendet werden; und zwar sollst du sie den Leviten übergeben, mit Rücksicht darauf, was der Dienst eines jeden erfordert. ");
INSERT INTO deutkw_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Da nahm Mose die Wagen und die Rinder und übergab sie den Leviten. ");
INSERT INTO deutkw_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Zwei von den Wagen und vier Rinder übergab er den Söhnen Gersons, entsprechend dem, was ihr Dienst erforderte. ");
INSERT INTO deutkw_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Vier von den Wagen und acht Rinder übergab er den Söhnen Meraris, entsprechend dem, was ihr Dienst unter der Leitung Ithamars, des Sohnes Aarons, des Priesters, erforderte. ");
INSERT INTO deutkw_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Den Söhnen Kahaths dagegen gab er nichts. Denn ihnen lag die Besorgung der heiligen Dinge ob; diese hatten sie auf der Schulter zu tragen. ");
INSERT INTO deutkw_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Es brachten aber die Fürsten die Gaben zur Einweihung des Altars an dem Tage dar, an welchem er gesalbt ward; und die Fürsten brachten ihre Opfergabe hin vor den Altar. ");
INSERT INTO deutkw_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Da sprach Jahwe zu Mose: Laß Tag für Tag jedesmal einen der Fürsten seine Opfergabe zur Einweihung des Altars darbringen. ");
INSERT INTO deutkw_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Der, welcher seine Opfergabe am ersten Tage darbrachte, war Rahasson, der Sohn Amminadabs, vom Stamme Juda. ");
INSERT INTO deutkw_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Und seine Opfergabe war eine silberne Schüssel, hundertunddreißig Sekel schwer, ein silbernes Becken, siebzig Sekel schwer nach heiligem Gewichte, beide gefüllt mit Feinmehl, das mit Öl angemacht war, zum Speisopfer, ");
INSERT INTO deutkw_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","eine Schale, zehn Goldsekel schwer, gefüllt mit Räucherwerk, ");
INSERT INTO deutkw_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","ein junger Stier, ein Widder, ein einjähriges männliches Lamm zum Brandopfer, ");
INSERT INTO deutkw_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","ein Ziegenbock zum Sündopfer, ");
INSERT INTO deutkw_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","und zum Heilsopfer zwei Rinder, fünf Widder, fünf Böcke und fünf einjährige männliche Lämmer. Das war die Gabe Rahassons, des Sohnes Amminadabs. ");
INSERT INTO deutkw_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Am zweiten Tage opferte Nethaneel, der Sohn Zuars, der Fürst von Issachar. ");
INSERT INTO deutkw_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Seine Opfergabe war eine silberne Schüssel, hundertunddreißig Sekel schwer, ein silbernes Becken, siebzig Sekel schwer nach heiligem Gewichte, beide gefüllt mit Feinmehl, das mit Öl angemacht war, zum Speisopfer, ");
INSERT INTO deutkw_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","eine Schale, zehn Goldsekel schwer, gefüllt mit Räucherwerk, ");
INSERT INTO deutkw_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","ein junger Stier, ein Widder, ein einjähriges männliches Lamm zum Brandopfer, ");
INSERT INTO deutkw_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","ein Ziegenbock zum Sündopfer, ");
INSERT INTO deutkw_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","und zum Heilsopfer zwei Rinder, fünf Widder, fünf Böcke und fünf einjährige männliche Lämmer. Das war die Gabe Nethaneels, des Sohnes Zuars. ");
INSERT INTO deutkw_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Am dritten Tage der Fürst der Söhne Sebulons, Eliab, der Sohn Helons. ");
INSERT INTO deutkw_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Seine Opfergabe war eine silberne Schüssel, hundertunddreißig Sekel schwer, ein silbernes Becken, siebzig Sekel schwer nach heiligem Gewichte, beide gefüllt mit Feinmehl, das mit Öl angemacht war, zum Speisopfer, ");
INSERT INTO deutkw_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","eine Schale, zehn Goldsekel schwer, gefüllt mit Räucherwerk, ");
INSERT INTO deutkw_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","ein junger Stier, ein Widder, ein einjähriges männliches Lamm zum Brandopfer, ");
INSERT INTO deutkw_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","ein Ziegenbock zum Sündopfer, ");
INSERT INTO deutkw_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","und zum Heilsopfer zwei Rinder, fünf Widder, fünf Böcke und fünf einjährige männliche Lämmer. Das war die Gabe Eliabs, des Sohnes Helons. ");
INSERT INTO deutkw_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Am vierten Tage der Fürst der Söhne Rubens, Elizur, der Sohn Sedeurs. ");
INSERT INTO deutkw_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Seine Opfergabe war eine silberne Schüssel, hundertunddreißig Sekel schwer, ein silbernes Becken, siebzig Sekel schwer nach heiligem Gewichte, beide gefüllt mit Feinmehl, das mit Öl angemacht war, zum Speisopfer, ");
INSERT INTO deutkw_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","eine Schale, zehn Goldsekel schwer, gefüllt mit Räucherwerk, ");
INSERT INTO deutkw_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","ein junger Stier, ein Widder, ein einjähriges männliches Lamm zum Brandopfer, ");
INSERT INTO deutkw_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","ein Ziegenbock zum Sündopfer, ");
INSERT INTO deutkw_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","und zum Heilsopfer zwei Rinder, fünf Widder, fünf Böcke und fünf einjährige männliche Lämmer. Das war die Gabe EIizurs, des Sohnes Sedeurs. ");
INSERT INTO deutkw_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Am fünften Tage der Fürst der Söhne Simeons, Selumiel, der Sohn Zuri Sadais. ");
INSERT INTO deutkw_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Seine Opfergabe war eine silberne Schüssel, hundertunddreißig Sekel schwer, ein silbernes Becken, siebzig Sekel schwer nach heiligem Gewichte, beide gefüllt mit Feinmehl, das mit Öl angemacht war, zum Speisopfer, ");
INSERT INTO deutkw_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","eine Schale, zehn Goldsekel schwer, gefüllt mit Räucherwerk, ");
INSERT INTO deutkw_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","ein junger Stier, ein Widder, ein einjähriges männliches Lamm zum Brandopfer, ");
INSERT INTO deutkw_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","ein Ziegenbock zum Sündopfer, ");
INSERT INTO deutkw_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","und zum Heilsopfer zwei Rinder, fünf Widder, fünf Böcke und fünf einjährige männliche Lämmer. Das war die Gabe Selumiels, der Sohnes Zuri Sadais. ");
INSERT INTO deutkw_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Am sechsten Tage der Fürst der Söhne Gads, Eliasaph, der Sohn Deguels. ");
INSERT INTO deutkw_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Seine Opfergabe war eine silberne Schüssel, hundertunddreißig Sekel schwer, ein silbernes Becken, siebzig Sekel schwer nach heiligem Gewichte, beide gefüllt mit Feinmehl, das mit Öl angemacht war, zum Speisopfer, ");
INSERT INTO deutkw_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","eine Schale, zehn Goldsekel schwer, gefüllt mit Räucherwerk, ");
INSERT INTO deutkw_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","ein junger Stier, ein Widder, ein einjähriges männliches Lamm zum Brandopfer, ");
INSERT INTO deutkw_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","ein Ziegenbock zum Sündopfer, ");
INSERT INTO deutkw_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","und zum Heilsopfer zwei Rinder, fünf Widder, fünf Böcke und fünf einjährige männliche Lämmer. Das war die Gabe Eliasaphs, des Sohnes Deguels. ");
INSERT INTO deutkw_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Am siebenten Tage der Fürst der Söhne Ephraims, Elisama, der Sohn Ammihuds. ");
INSERT INTO deutkw_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Seine Opfergabe war eine silberne Schüssel, hundertunddreißig Sekel schwer, ein silbernes Becken, siebzig Sekel schwer nach heiligem Gewichte, beide gefüllt mit Feinmehl, das mit Öl angemacht war, zum Speisopfer, ");
INSERT INTO deutkw_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","eine Schale, zehn Goldsekel schwer, gefüllt mit Räucherwerk, ");
INSERT INTO deutkw_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","ein junger Stier, ein Widder, ein einjähriges männliches Lamm zum Brandopfer, ");
INSERT INTO deutkw_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","ein Ziegenbock zum Sündopfer, ");
INSERT INTO deutkw_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","und zum Heilsopfer zwei Rinder, fünf Widder, fünf Böcke und fünf einjährige männliche Lämmer. Das war die Gabe Elisamas, des Sohnes Ammihuds. ");
INSERT INTO deutkw_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Am achten Tage der Fürst der Söhne Manasses, Gamliel, der Sohn Pedazurs. ");
INSERT INTO deutkw_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Seine Opfergabe war eine silberne Schüssel, hundertunddreißig Sekel schwer, ein silbernes Becken, siebzig Sekel schwer nach heiligem Gewichte, beide gefüllt mit Feinmehl, das mit Öl angemacht war, zum Speisopfer, ");
INSERT INTO deutkw_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","eine Schale, zehn Goldsekel schwer, gefüllt mit Räucherwerk, ");
INSERT INTO deutkw_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","ein junger Stier, ein Widder, ein einjähriges männliches Lamm zum Brandopfer, ");
INSERT INTO deutkw_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","ein Ziegenbock zum Sündopfer, ");
INSERT INTO deutkw_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","und zum Heilsopfer zwei Rinder, fünf Widder, fünf Böcke und fünf einjährige männliche Lämmer. Das war die Gabe Gamliels, des Sohnes Pedazurs. ");
INSERT INTO deutkw_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Am neunten Tage der Fürst der Söhne Benjamins, Abidan, der Sohn Gideonis. ");
INSERT INTO deutkw_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Seine Opfergabe war eine silberne Schüssel, hundertunddreißig Sekel schwer, ein silbernes Becken, siebzig Sekel schwer nach heiligem Gewichte, beide gefüllt mit Feinmehl, das mit Öl angemacht war, zum Speisopfer, ");
INSERT INTO deutkw_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","eine Schale, zehn Goldsekel schwer, gefüllt mit Räucherwerk, ");
INSERT INTO deutkw_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","ein junger Stier, ein Widder, ein einjähriges männliches Lamm zum Brandopfer, ");
INSERT INTO deutkw_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","ein Ziegenbock zum Sündopfer, ");
INSERT INTO deutkw_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","und zum Heilsopfer zwei Rinder, fünf Widder, fünf Böcke und fünf einjährige männliche Lämmer. Das war die Gabe Abidans, des Sohnes Gideonis. ");
INSERT INTO deutkw_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Am zehnten Tage der Fürst der Söhne Dans, Ahieser, der Sohn Ammisadais. ");
INSERT INTO deutkw_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Seine Opfergabe war eine silberne Schüssel, hundertunddreißig Sekel schwer, ein silbernes Becken, siebzig Sekel schwer nach heiligem Gewichte, beide gefüllt mit Feinmehl, das mit Öl angemacht war, zum Speisopfer, ");
INSERT INTO deutkw_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","eine Schale, zehn Goldsekel schwer, gefüllt mit Räucherwerk, ");
INSERT INTO deutkw_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","ein junger Stier, ein Widder, ein einjähriges männliches Lamm zum Brandopfer, ");
INSERT INTO deutkw_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","ein Ziegenbock zum Sündopfer, ");
INSERT INTO deutkw_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","und zum Heilsopfer zwei Rinder, fünf Widder, fünf Böcke und fünf einjährige männliche Lämmer. Das war die Gabe Ahiesers, des Sohnes Ammisadais. ");
INSERT INTO deutkw_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Am elften Tage der Fürst der Söhne Assers, Pagiel, der Sohn Ochrans. ");
INSERT INTO deutkw_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Seine Opfergabe war eine silberne Schüssel, hundertunddreißig Sekel schwer, ein silbernes Becken, siebzig Sekel schwer nach heiligem Gewichte, beide gefüllt mit Feinmehl, das mit Öl angemacht war, zum Speisopfer, ");
INSERT INTO deutkw_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","eine Schale, zehn Goldsekel schwer, gefüllt mit Räucherwerk, ");
INSERT INTO deutkw_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","ein junger Stier, ein Widder, ein einjähriges männliches Lamm zum Brandopfer, ");
INSERT INTO deutkw_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","ein Ziegenbock zum Sündopfer, ");
INSERT INTO deutkw_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","und zum Heilsopfer zwei Rinder, fünf Widder, fünf Böcke und fünf einjährige männliche Lämmer. Das war die Gabe Pagiels, des Sohnes Ochrans. ");
INSERT INTO deutkw_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Am zwölften Tage der Fürst der Söhne Naphthalis, Ahira, der Sohn Enans. ");
INSERT INTO deutkw_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Seine Opfergabe war eine silberne Schüssel, hundertunddreißig Sekel schwer, ein silbernes Becken, siebzig Sekel schwer nach heiligem Gewichte, beide gefüllt mit Feinmehl, das mit Öl angemacht war, zum Speisopfer, ");
INSERT INTO deutkw_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","eine Schale, zehn Goldsekel schwer, gefüllt mit Räucherwerk, ");
INSERT INTO deutkw_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","ein junger Stier, ein Widder, ein einjähriges männliches Lamm zum Brandopfer, ");
INSERT INTO deutkw_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","ein Ziegenbock zum Sündopfer, ");
INSERT INTO deutkw_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","und zum Heilsopfer zwei Rinder, fünf Widder, fünf Böcke und fünf einjährige männliche Lämmer. Das war die Gabe Ahiras, des Sohnes Enans. ");
INSERT INTO deutkw_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Das war die Spende zur Einweihung des Altars an dem Tag, an welchem er gesalbt ward, von seiten der Fürsten Israels: zwölf silberne Schüsseln, zwölf silberne Becken, zwölf goldene Schalen, ");
INSERT INTO deutkw_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","jede Schüssel hundertunddreißig Silbersekel, jedes Becken siebzig Sekel schwer; das gesamte Silber der Gefäße belief sich somit auf 2400 Sekel heiliges Gewicht; ");
INSERT INTO deutkw_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","zwölf goldene Schalen, gefüllt mit Räucherwerk, jede Schale zehn Sekel schwer nach heiligem Gewichte; das gesamte Gold der Schalen belief sich somit auf hundertundzwanzig Sekel. ");
INSERT INTO deutkw_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Die sämtlichen Rinder zum Brandopfer beliefen sich auf zwölf Farren, dazu zwölf Widder, zwölf einjährige männliche Lämmer nebst dem zugehörigen Speisopfer und zwölf Ziegenböcke zum Sündopfer. ");
INSERT INTO deutkw_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Die sämtlichen Rinder zum Heilsopfer aber beliefen sich auf vierundzwanzig Farren; dazu sechzig Widder, sechzig Böcke und sechzig einjährige männliche Lämmer. Das war die Spende zur Einweihung des AItars, nachdem derselbe gesalbt worden war. ");
INSERT INTO deutkw_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Und wenn Mose hineinging ins Offenbarungszelt, um mit ihm zu reden, so hörte er die Stimme zu sich reden von der Deckplatte aus, die sich auf der Gesetzeslade befindet, von dem Orte zwischen den beiden Keruben; so redete er mit ihm. ");
INSERT INTO deutkw_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Rede mit Aaron und sprich zu ihm: Wenn du die Lampen aufsetzest, so laß die sieben Lampen ihr Licht auf die Vorderseite des Leuchters werfen. ");
INSERT INTO deutkw_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Und Aaron that also; auf der Vorderseite des Leuchters setzte er die Lampen auf, wie Jahwe Mose befohlen hatte. ");
INSERT INTO deutkw_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Der Leuchter aber war in getriebener Arbeit aus Gold gefertigt. Sowohl sein Schaft, als seine Blüten, alles war getriebene Arbeit; wie es dem Bild entsprach, welches Jahwe Mose gezeigt hatte, so fertigte er den Leuchter. ");
INSERT INTO deutkw_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","Nimm die Leviten aus den Israeliten heraus und reinige sie. ");
INSERT INTO deutkw_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Und zwar sollst du so mit ihnen verfahren, um sie zu reinigen: Besprenge sie mit Entsündigungswasser, und sie sollen über ihren ganzen Leib ein Schermesser gehen lassen, ihre Leiber waschen und sich reinigen. ");
INSERT INTO deutkw_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Sodann sollen sie einen jungen Stier nehmen und das zugehörige Speisopfer - mit Öl angemachtes Feinmehl -, und du sollst einen zweiten jungen Stier nehmen zu einem Sündopfer. ");
INSERT INTO deutkw_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Hierauf sollst du die Leviten herantreten lassen vor das Offenbarungszelt und die ganze Gemeinde der Israeliten versammeln. ");
INSERT INTO deutkw_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Sodann sollst du die Leviten herantreten lassen vor Jahwe; die Israeliten sollen ihre Hände auf die Leviten stemmen, ");
INSERT INTO deutkw_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","und Aaron soll die Leviten vor Jahwe weben als Webeopfer von seiten der Israeliten, damit sie sich der Verrichtung des Dienstes für Jahwe unterziehen. ");
INSERT INTO deutkw_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Die Leviten aber sollen ihre Hände auf den Kopf der Farren stemmen; sodann richte den einen als Sündopfer, den andern als Brandopfer für Jahwe her, um den Leviten Sühne zu schaffen. ");
INSERT INTO deutkw_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Und du sollst die Leviten Aaron und seinen Söhnen darstellen und sie als Webeopfer für Jahwe weben ");
INSERT INTO deutkw_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","und sollst die Leviten aussondern aus den Israeliten, damit die Leviten mir gehören. ");
INSERT INTO deutkw_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Darnach aber mögen die Leviten hineingehen, um das Offenbarungszelt zu bedienen; so sollst du sie reinigen und als Webeopfer weben. ");
INSERT INTO deutkw_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Denn sie sind mir ganz zu eigen gegeben aus den Israeliten; an Stelle von allem, was zuerst den Mutterschoß durchbricht, von allen Erstgeborenen unter den Israeliten, habe ich sie für mich genommen. ");
INSERT INTO deutkw_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Denn mir gehören alle Erstgebornen unter den Israeliten, von den Menschen, wie vom Vieh. An dem Tag, an welchem ich alle Erstgebornen in Ägypten tötete, habe ich sie mir geheiligt. ");
INSERT INTO deutkw_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Und ich nahm die Leviten an Stelle aller Erstgebornen unter den Israeliten ");
INSERT INTO deutkw_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","und gab die Leviten Aaron und seinen Söhnen aus den Israeliten zu eigen, damit sie für die Israeliten den Dienst am Offenbarungszelte besorgen und den Israeliten als Deckung dienen, daß nicht eine Plage über die Israeliten kommt, wenn sich die Israeliten dem Heiligtume näherten. ");
INSERT INTO deutkw_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Mose aber und Aaron und die ganze Gemeinde der Israeliten verfuhren so mit den Leviten; genau so, wie es Jahwe Mose in betreff der Leviten befohlen hatte, so verfuhren die Israeliten mit ihnen. ");
INSERT INTO deutkw_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Und die Leviten ließen sich entsündigen und wuschen ihre Kleider; und Aaron webte sie als Webeopfer und Aaron schaffte ihnen Sühne behufs ihrer Reinigung. ");
INSERT INTO deutkw_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Darnach aber gingen die Leviten hinein, um unter der Aufsicht Aarons und seiner Söhne ihren Dienst im Offenbarungszelte zu verrichten; wie es Jahwe Mose in betreff der Leviten befohlen hatte, so verfuhren sie mit ihnen. ");
INSERT INTO deutkw_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","Dies ist's, was in betreff der Leviten gelten soll: von fünfundzwanzig Jahren an und darüber soll er eintreten, um bei der Besorgung des OffenbarungszeItes Dienst zu thun; ");
INSERT INTO deutkw_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","aber von fünfzig Jahren an soll er der Dienstpflicht ledig sein und braucht nicht mehr zu dienen. ");
INSERT INTO deutkw_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Er mag seinen Brüdern im Offenbarungszelte bei der Besorgung der Geschäfte zur Hand gehen, aber Dienst soll er nicht thun. So sollst du mit den Leviten verfahren hinsichtlich ihrer Amtsgeschäfte. ");
INSERT INTO deutkw_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Und Jahwe redete mit Mose in der Steppe am Sinai im zweiten Jahre nach ihrem Auszug aus Ägypten, im ersten Monat, also: ");
INSERT INTO deutkw_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","Es sollen aber die Israeliten das Passah zur festgesetzten Zeit feiern. ");
INSERT INTO deutkw_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Am vierzehnten Tage dieses Monats gegen Abend sollt ihr es feiern zur festgesetzten Zeit; nach allen den Satzungen und allen den Ordnungen, die dafür gelten, sollt ihr es feiern. ");
INSERT INTO deutkw_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Und Mose sagte den Israeliten, daß sie das Passah feiern sollten. ");
INSERT INTO deutkw_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Da feierten sie das Passah im ersten Monat, am vierzehnten Tage des Monats gegen Abend in der Steppe am Sinai; ganz so, wie Jahwe Mose befohlen hatte, also thaten die Israeliten. ");
INSERT INTO deutkw_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Es waren aber Männer vorhanden, die durch eine Leiche unrein geworden waren, so daß sie an selbigem Tage das Passah nicht feiern konnten. Da traten sie an selbigem Tage vor Mose und Aaron, ");
INSERT INTO deutkw_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","und eben diese Männer sprachen zu ihm: Wir sind durch eine Leiche unrein; warum sollen wir verkürzt werden, daß wir die Opfergabe für Jahwe nicht zur festgesetzten Zeit inmitten der Israeliten darbringen dürfen? ");
INSERT INTO deutkw_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Mose antwortete ihnen: Wartet, daß ich höre, was Jahwe eurethalben befiehlt. ");
INSERT INTO deutkw_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Sage den Israeliten und sprich: Wenn irgend jemand von euch oder von euren Nachkommen unrein sein sollte durch eine Leiche oder sich auf einer weiten Reise befinden sollte, so soll er doch Jahwe Passah feiern. ");
INSERT INTO deutkw_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Im zweiten Monat, am vierzehnten Tage gegen Abend sollen sie es feiern; zu ungesäuertem Brot und bitteren Kräutern sollen sie es verzehren. ");
INSERT INTO deutkw_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Sie dürfen nichts davon übrig lassen bis zum Morgen, auch keinen Knochen an ihm brechen; nach allen Satzungen, die für das Passah gelten, sollen Sie es feiern. ");
INSERT INTO deutkw_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Derjenige aber, der rein ist und sich nicht auf einer Reise befindet und dennoch unterläßt, das Passah zu feiern, - ein solcher soll hinweggetilgt werden aus seinen Volksgenossen, denn er hat die Opfergabe für Jahwe nicht dargebracht zur festgesetzten Zeit; ein solcher hat Sünde auf sich geladen. ");
INSERT INTO deutkw_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Und wenn sich ein Fremder bei euch aufhält und Jahwe Passah feiert, soll er so verfahren, wie es die Satzungen und Ordnungen des Passah fordern. Einerlei Satzung soll für euch gelten, sowohl für den Fremden, wie für den Landeseingebornen. ");
INSERT INTO deutkw_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","An dem Tag aber, an welchem man die Wohnung aufrichtete, bedeckte die Wolke die Wohnung - das Zelt mit dem Gesetz - und abends lag sie über der Wohnung wie ein feuriger Schein. ");
INSERT INTO deutkw_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","So war es beständig: die Wolke bedeckte sie und des Nachts ein feuriger Schein bis zum Morgen. ");
INSERT INTO deutkw_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Und so oft sich die Wolke vom Zelt hinweg erhob, brachen die Israeliten jedesmal darnach auf, und da, wo die Wolke sich niederließ, da lagerten sich die Israeliten. ");
INSERT INTO deutkw_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Nach dem Befehle Jahwes brachen die Israeliten auf und nach dem Befehle Jahwes lagerten sie sich; so lange irgend die Wolke auf der Wohnung ruhte, blieben sie gelagert. ");
INSERT INTO deutkw_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Und wenn die Wolke lange Zeit auf der Wohnung verzog, so fügten sich die Israeliten der Anordnung Jahwes und brachen nicht auf. ");
INSERT INTO deutkw_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Es kam auch vor, daß die Wolke nur wenige Tage über der Wohnung blieb; nach dem Befehle Jahwes lagerten sie sich und nach dem Befehle Jahwes brachen sie auf. ");
INSERT INTO deutkw_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Es kam auch vor, daß die Wolke vom Abend bis zum Morgen blieb, und daß sich die Wolke am Morgen erhob; so brachen sie dann auf. Oder daß Sie einen Tag und eine Nacht blieb, und daß sich die Wolke dann erhob; so brachen sie dann auf. ");
INSERT INTO deutkw_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Oder daß sie zwei Tage oder einen Monat oder längere Zeit blieb, indem die Wolke über der Wohnung verzog und auf ihr ruhen blieb; so blieben dann die Israeliten gelagert und brachen nicht auf. Wenn sie sich aber erhob, so brachen sie auf. ");
INSERT INTO deutkw_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Nach dem Befehle Jahwes lagerten sie sich jedesmal und nach dem Befehle Jahwes brachen Sie jedesmal auf; sie fügten sich der Anordnung Jahwes gemäß dem Befehle Jahwes durch Mose. ");
INSERT INTO deutkw_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Fertige dir zwei Trompeten an - in getriebener Arbeit sollst du sie anfertigen -, damit sie dir dienen zur Einberufung der Gemeinde, und wenn die Lager aufbrechen sollen. ");
INSERT INTO deutkw_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Wenn man sie bläst, so hat sich die ganze Gemeinde zu dir zu versammeln vor die Thüre des OffenbarungszeItes. ");
INSERT INTO deutkw_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Wird man aber nur eine blasen, so haben sich die Fürsten, die Stammhäupter IsraeIs, zu dir zu versammeln. ");
INSERT INTO deutkw_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Wenn ihr Lärm blasen werdet, so haben die Lager, die nach Osten zu lagern, aufzubrechen. ");
INSERT INTO deutkw_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Und wenn ihr zum zweiten MaIe Lärm blasen werdet, so haben die Lager, die nach Süden zu lagern, aufzubrechen; Lärm soll man blasen, wenn sie aufbrechen sollen. ");
INSERT INTO deutkw_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Wenn es aber gilt, die Gemeinde zu versammeln, so sollt ihr einfach in die Trompeten stoßen, nicht aber Lärm blasen. ");
INSERT INTO deutkw_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Und zwar sollen die Söhne Aarons, die Priester, die Trompeten blasen, und ihr Gebrauch soll euch als eine für alle Zeit und alle Geschlechter auferlegte Verpflichtung gelten. ");
INSERT INTO deutkw_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Und wenn ihr in eurem Land in Krieg geratet mit dem Feinde, der euch bedrängt, und in die Trompeten stoßt, so wird eurer gedacht werden vor Jahwe, eurem Gotte, daß ihr von euren Feinden errettet werdet. ");
INSERT INTO deutkw_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Auch an euren Freudentagen, sowie an euren Festen und euren Neumonden, sollt ihr die Trompeten blasen zu euren Brandopfern und zu euren Heilsopfern, daß Sie euch ein gnädiges Gedenken von seiten eures Gottes schaffen; ich bin Jahwe, euer Gott. ");
INSERT INTO deutkw_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Im zweiten Jahre, im zweiten Monat, am zwanzigsten des Monats, erhob sich die Wolke von der Wohnung des Gesetzes. ");
INSERT INTO deutkw_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Da brachen die Israeliten nacheinander auf von der Steppe am Sinai, und die Wolke ließ sich nieder in der Steppe Paran. ");
INSERT INTO deutkw_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","So brachen sie zum ersten Mal auf, gemäß dem Befehle Jahwes durch Mose. ");
INSERT INTO deutkw_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Und es brach zuerst auf das Panier des Lagers der Söhne Judas, Heerschar für Heerschar; Anführer des zu ihm gehörenden Heers war Nahasson, der Sohn Amminadabs. ");
INSERT INTO deutkw_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Das Heer des Stammes der Söhne Issachars befehligte Nethaneel, der Sohn Zuars, ");
INSERT INTO deutkw_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","das Heer des Stammes der Söhne Sebulons Eliab, der Sohn Helons. ");
INSERT INTO deutkw_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Und wenn die Wohnung abgebrochen war, so brachen die Söhne Gersons und die Söhne Meraris auf, die die Wohnung zu tragen hatten. ");
INSERT INTO deutkw_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Sodann brach das Panier des Lagers Rubens auf, Heerschar für Heerschar; Anführer des zu ihm gehörenden Heers war Elizur, der Sohn Sedeurs. ");
INSERT INTO deutkw_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Das Heer des Stammes der Söhne Simeons befehligte Selumiel, der Sohn Zuri Sadais, ");
INSERT INTO deutkw_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","das Heer des Stammes der Söhne Gads Eliasaph, der Sohn Deguels. ");
INSERT INTO deutkw_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Sodann brachen die Kahathiter auf, die das Heilige trugen; bis zu ihrer Ankunft hatte man die Wohnung bereits aufgerichtet. ");
INSERT INTO deutkw_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Sodann brach das Panier des Lagers der Söhne Ephraims auf, Heerschar für Heerschar; Anführer des zu ihm gehörenden Heers war Elisama, der Sohn Ammihuds. ");
INSERT INTO deutkw_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Das Heer des Stammes der Söhne Manasses befehligte Gamliel, der Sohn Pedazurs, ");
INSERT INTO deutkw_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","das Heer des Stammes der Söhne Benjamins Abidan, der Sohn Gideonis. ");
INSERT INTO deutkw_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Sodann brach das Panier des Lagers der Söhne Dans auf, das den Beschluß sämtlicher Lager bildete, Heerschar für Heerschar; Anführer des zu ihm gehörenden Heers war Ahieser, der Sohn Ammisadais. ");
INSERT INTO deutkw_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Das Heer des Stammes der Söhne Assers befehligte Pagiel, der Sohn Ochrans, ");
INSERT INTO deutkw_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","das Heer des Stammes der Söhne Naphthalis Ahira, der Sohn Enans. ");
INSERT INTO deutkw_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Das war die Ordnung, in der die Israeliten nacheinander aufbrachen, Heerschar für Heerschar. Als sie nun aufbrachen, ");
INSERT INTO deutkw_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","da sprach Mose zu Hobab, dem Sohne Reguels, dem Midianiter, dem Schwiegervater Moses: Wir brechen jetzt auf nach der Stätte, von der Jahwe verheißen hat: ich will sie euch verleihen; ziehe mit uns, so wollen wir dich reichlich bedenken, denn Jahwe hat den Israeliten reiches Gut verheißen! ");
INSERT INTO deutkw_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Er aber erwiderte. Ich mag nicht mitziehen, sondern will in meine Heimat und zu meiner Verwandtschaft gehen. ");
INSERT INTO deutkw_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Da bat er: Laß uns doch nicht im Stich; denn du weißt nun einmal Bescheid, wo wir in der Steppe ein Lager aufschlagen können, und sollst uns als Wegweiser dienen. ");
INSERT INTO deutkw_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Wenn du mit uns ziehst und uns dann all das reiche Gut zu teil wird, mit dem uns Jahwe beschenken will, so wollen wir dich reichlich bedenken. ");
INSERT INTO deutkw_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Da zogen sie vom Berge Jahwes drei Tagereisen weiter; die Lade mit dem Gesetze Jahwes aber zog ihnen voraus drei Tagereisen weit, um einen Lagerplatz für sie zu erspähen. ");
INSERT INTO deutkw_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Und die Wolke Jahwes schwebte am Tage über ihnen, wenn sie aus dem Lager aufbrachen. ");
INSERT INTO deutkw_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Wenn aber die Lade sich in Bewegung setzte, sprach Mose: Mache dich auf, Jahwe, damit deine Feinde zerstieben, und deine Widersacher vor dir fliehen! ");
INSERT INTO deutkw_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Und wenn sie den Lagerplatz erreichte, sprach er: Kehre wieder, Jahwe, zu den zehntausendmal Tausenden Israels! ");
INSERT INTO deutkw_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Das Volk aber beklagte sich laut gegen Jahwe, daß es ihm schlecht gehe. Als Jahwe dies vernahm, wurde er zornig. Da loderte das von Jahwe gesandte Feuer unter ihnen empor und verzehrte einen Teil des Lagers. ");
INSERT INTO deutkw_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Da schrie das Volk zu Mose um Hilfe; Mose aber betete zu Jahwe, da begann das Feuer zu erlöschen. ");
INSERT INTO deutkw_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Daher heißt jene Örtlichkeit Tabera, weil das Feuer Jahwes unter ihnen emporloderte. ");
INSERT INTO deutkw_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Das hergelaufene Gesindel aber, das sich unter ihnen befand, bekam Gelüste; da begannen auch die Israeliten wiederum zu jammern und sprachen: Wer giebt uns nun Fleisch zu essen! ");
INSERT INTO deutkw_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Wir gedenken der Fische, die wir in Ägypten umsonst zu essen bekamen, der Gurken, der Melonen, des Lauchs, der Zwiebeln und des Knoblauchs! ");
INSERT INTO deutkw_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Jetzt aber verschmachten wir, denn es ist gar nichts da; wir bekommen nichts zu sehen, als das Manna. ");
INSERT INTO deutkw_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Das Manna aber war wie Korianderkörner und sah aus wie Bdolachharz. ");
INSERT INTO deutkw_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Die Leute streiften umher, lasen es auf und mahlten es in der Handmühle oder zerstießen es im Mörser. Dann kochten sie es im Topf und bereiteten daraus Fladen; es schmeckte aber wie Ölkuchen. ");
INSERT INTO deutkw_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Und wenn des Nachts Tau auf das Lager fiel, so fiel auch das Manna darauf. ");
INSERT INTO deutkw_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Als nun Mose das Volk familienweise, einen jeden vor der Thüre seines Zeltes jammern hörte, entbrannte der Zorn Jahwes heftig, und es mißfiel Mose sehr. ");
INSERT INTO deutkw_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Da sprach Mose zu Jahwe: Warum Iässest du es deinem Sklaven so übel ergehn, und warum gelte ich dir nichts mehr, daß du mir die Last der Leitung dieses ganzen Volks auferlegst? ");
INSERT INTO deutkw_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Habe etwa ich dieses ganze Volk empfangen oder ich es geboren, daß du mir nun befiehlst: Trage es an deinem Busen, wie die Wärterin den Säugling, in das Land, das du seinen Vorfahren zugeschworen hast? ");
INSERT INTO deutkw_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Woher soll ich Fleisch nehmen, um es diesem ganzen Volke zu geben? Sie jammern mir vor und rufen: Schaffe uns Fleisch zu essen! ");
INSERT INTO deutkw_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","ich kann die Last, die mir mit diesem ganzen Volk aufliegt, nicht allein tragen; sie ist zu schwer für mich. ");
INSERT INTO deutkw_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Wenn du mir das anthun willst, so töte mich lieber gleich ganz, wenn ich dir etwas gelte, damit ich mein Elend nicht mehr anzusehen brauche. ");
INSERT INTO deutkw_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Da befahl Jahwe Mose: Rufe mir siebzig Männer aus den Vornehmen der Israeliten zusammen, von denen du weißt, daß sie die Vornehmsten unter dem Volk und Aufseher über dasselbe sind; die bringe mit dir zum Offenbarungszelte, damit sie sich dort neben dir aufstellen. ");
INSERT INTO deutkw_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Dann will ich hinabfahren, um daselbst mit dir zu reden, und will etwas von dem Geiste, der auf dir ruht, hinwegnehmen und über sie kommen lassen, damit sie dir die Last der Leitung dieses Volks tragen helfen, und du sie nicht allein zu tragen brauchst. ");
INSERT INTO deutkw_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Zum Volk aber sollst du sprechen: Sorgt dafür, daß ihr morgen rein seid, so sollt ihr Fleisch zu essen bekommen; denn ihr habt laut vor Jahwe gejammert und gesagt: Wer giebt uns nun Fleisch zu essen? Wir hatten es ja in Ägypten besser! So wird euch nun Jahwe Fleisch schaffen, daß ihr zu essen haben sollt. ");
INSERT INTO deutkw_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Nicht bloß einen ober zwei oder fünf oder zehn oder zwanzig Tage sollt ihr es zu essen haben, ");
INSERT INTO deutkw_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","sondern einen ganzen Monat lang, bis ihr es nicht mehr erriechen könnt, und es euch zum Ekel wird; denn ihr habt Jahwe, der unter euch weilt, gering geachtet und ihm vorgejammert und gesagt: Wozu sind wir doch aus Ägypten ausgezogen? ");
INSERT INTO deutkw_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Da entgegnete Mose: Sechshunderttausend Mann zu Fuß zählt das Volk, unter welchem ich weile, und du verheißest: Fleisch will ich ihnen schaffen, daß sie einen ganzen Monat lang zu essen haben? ");
INSERT INTO deutkw_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Können so viele Schafe und Rinder für sie geschlachtet werden, bis es für sie zulangt, oder sollen alle Fische des Meers für sie zusammengebracht werden, bis es für sie zulangt? ");
INSERT INTO deutkw_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Jahwe aber sprach zu Mose: Ist denn Jahwes Macht beschränkt? Nun sollst du erfahren, ob sich meine Verheißung dir erfüllt, oder nicht. ");
INSERT INTO deutkw_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Da ging Mose heraus und berichtete dem Volke die Worte Jahwes; dann rief er siebzig Mann von den Vornehmsten des Volks zusammen und ließ sie rings um das Zelt sich aufstellen. ");
INSERT INTO deutkw_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Da fuhr Jahwe in der Wolke hinab und redete mit ihm. Und er nahm etwas von dem Geiste, der auf ihm ruhte, hinweg und ließ ihn über die siebzig Männer, jene Vornehmsten, kommen. Als nun der Geist sich auf sie niederließ, gerieten sie in prophetische Begeisterung, später aber nicht mehr. ");
INSERT INTO deutkw_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Es waren aber zwei Männer im Lager zurückgeblieben; der eine hieß Eldad, der andere hieß Medad. Auch auf sie ließ sich der Geist nieder, denn sie gehörten zu den Aufgeschriebenen, hatten sich aber nicht hinaus zum Zelte begeben; so gerieten sie denn im Lager in prophetische Begeisterung. ");
INSERT INTO deutkw_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Da lief ein Diener hin und berichtete es Mose mit den Worten: Eldad und Medad sind im Lager in prophetische Begeisterung geraten! ");
INSERT INTO deutkw_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Da antwortete Josua, der Sohn Nuns, der von seiner Jünglingszeit an Moses Diener gewesen war, und sprach: O Herr, wehre es ihnen! ");
INSERT INTO deutkw_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Mose aber erwiderte ihm: Willst du dich für mein Recht ereifern? O bestände doch das ganze Volk Jahwes aus Begeisterten, daß Jahwe seinen Geist über sie kommen ließe! ");
INSERT INTO deutkw_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Hierauf zog sich Mose mit jenen Vornehmsten der Israeliten ins Lager zurück. ");
INSERT INTO deutkw_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Da erhob sich ein von Jahwe gesandter Wind; der trieb Wachteln vom Meer herüber und ließ sie über das Lager hinfliegen, eine Tagereise weit nach dieser und eine Tagereise weit nach jener Richtung rings um das Lager her, in einer Höhe von etwa zwei Ellen über dem Boden. ");
INSERT INTO deutkw_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Da machte sich das Volk jenen ganzen Tag und die ganze Nacht und den ganzen folgenden Tag hindurch ans Werk und sammelte Wachteln ein; wer wenig sammelte, bekam zehn Chomer, und sie breiteten sie weithin rings um das Lager aus. ");
INSERT INTO deutkw_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Noch aber aßen sie von dem Fleische, noch war es nicht aufgezehrt, da entbrannte der Zorn Jahwes über das Volk, und Jahwe brachte dem Volk eine sehr schwere Niederlage bei. ");
INSERT INTO deutkw_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Daher heißt jener Ort Kibrot hattaawa; denn dort begrub man die Leute, die Gelüste gehabt hatten. ");
INSERT INTO deutkw_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Von Kibrot hattaawa aber zog das Volk nach Hazeroth, und sie blieben zu Hazeroth. ");
INSERT INTO deutkw_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Mirjam und Aaron aber redeten übel von Mose wegen des kuschitischen Weibes, das er geheiratet hatte; denn er hatte ein kuschitisches Weib geheiratet. ");
INSERT INTO deutkw_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Und sie sprachen: Hat denn Jahwe bloß mit Mose geredet? Hat er nicht auch mit uns geredet? Und Jahwe vernahm es. ");
INSERT INTO deutkw_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Der Mann Mose aber war ausnehmend sanftmütig, mehr als alle Menschen auf Erden. ");
INSERT INTO deutkw_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Da gebot Jahwe unversehens Mose, Aaron und Mirjam: Begebt euch alle drei hinaus zum Offenbarungszelte! Da begaben sie sich alle drei hinaus. ");
INSERT INTO deutkw_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Da fuhr Jahwe in einer Wolkensäule hinab, trat unter die Thüre des Zeltes und rief Aaron und Mirjam; da gingen die beiden hinaus. ");
INSERT INTO deutkw_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Er aber sprach: Hört, was ich sage! Wenn unter euch ein Prophet ist, so offenbare ich mich ihm durch Gesichte oder rede durch Träume mit ihm. ");
INSERT INTO deutkw_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Nicht so steht es mit meinem Diener Mose; er ist betraut mit meinem ganzen Hauswesen. ");
INSERT INTO deutkw_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Von Mund zu Mund rede ich mit ihm, offenbarlich und nicht in Rätseln, sondern er schaut die Gestalt Jahwes. Warum habt ihr euch da nicht gescheut, von meinem Diener, von Mose, übel zu reden? ");
INSERT INTO deutkw_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Da wurde Jahwe sehr zornig über sie und ging hinweg, ");
INSERT INTO deutkw_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","und die Wolke wich von dem Zelte. Mirjam aber wurde plötzlich aussätzig, weiß wie Schnee. Und als sich Aaron zu ihr hinwandte, war sie plötzlich aussätzig geworden. ");
INSERT INTO deutkw_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Da sprach Aaron zu Mose: Ach, Herr, laß uns nicht dafür büßen, daß wir thöricht gehandelt und uns vergangen haben! ");
INSERT INTO deutkw_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Laß sie nicht werden wie ein totes Kind, dessen Fleisch, wenn es aus dem Mutterleibe kommt, zur Hälfte verfault ist! ");
INSERT INTO deutkw_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Da schrie Mose zu Jahwe um Hilfe und sprach: Ach nein! Laß sie doch wieder gesund werden! ");
INSERT INTO deutkw_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Da sprach Jahwe zu Mose: Wenn ihr Vater ihr ins Gesicht gespieen hätte, würde sie sich da nicht sieben Tage lang schämen müssen? Sieben Tage soll sie außerhalb des Lagers abgesperrt bleiben; nachher mag sie wieder aufgenommen werden. ");
INSERT INTO deutkw_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Da wurde Mirjam sieben Tage lang außerhalb des Lagers abgesperrt. Das Volk aber zog nicht weiter, bis Mirjam wieder aufgenommen war. ");
INSERT INTO deutkw_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Darnach brach das Volk von Hazeroth auf und lagerte sich in der Steppe Paran. ");
INSERT INTO deutkw_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","Entsende Männer, damit sie das Land Kanaan, das ich den Israeliten geben will, auskundschaften; je einen aus jedem Stamme sollt ihr entsenden, lauter solche, die Fürsten unter ihnen sind. ");
INSERT INTO deutkw_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Da entsandte sie Mose aus der Steppe Paran nach dem Befehle Jahwes, lauter Männer, die Häupter der Israeliten waren. ");
INSERT INTO deutkw_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Und dies sind ihre Namen: vom Stamme Ruben Sammua, der Sohn Zakurs; ");
INSERT INTO deutkw_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","vom Stamme Simeon Saphat, der Sohn Horis; ");
INSERT INTO deutkw_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","vom Stamme Juda Kaleb, der Sohn Jephunnes; ");
INSERT INTO deutkw_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","vom Stamme Issachar Igeal, der Sohn Josephs; ");
INSERT INTO deutkw_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","vom Stamme Ephraim Hosea, der Sohn Nuns; ");
INSERT INTO deutkw_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","vom Stamme Benjamin Palti, der Sohn Raphus; ");
INSERT INTO deutkw_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","vom Stamme Sebulon Gadiel, der Sohn Sodis; ");
INSERT INTO deutkw_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","vom Stamme Joseph: vom Stamme Manasse Gaddi, der Sohn Susis; ");
INSERT INTO deutkw_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","vom Stamme Dan Ammiel, der Sohn Gemallis; ");
INSERT INTO deutkw_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","vom Stamme Asser Sethur, der Sohn Michaels; ");
INSERT INTO deutkw_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","vom Stamme Naphthali Rahebi, der Sohn Wophsis; ");
INSERT INTO deutkw_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","vom Stamme Gad Geuel, der Sohn Machis. ");
INSERT INTO deutkw_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Das sind die Namen der Männer, die Mose aussandte, um das Land auszukundschaften. Hosea aber, den Sohn Nuns, nannte Mose Josua. ");
INSERT INTO deutkw_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Und Mose sandte sie, das Land Kanaan auszukundschaften. Und er sprach zu ihnen: Steigt hier hinauf ins Südland und ersteigt das Gebirge; ");
INSERT INTO deutkw_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","seht zu, wie das Land beschaffen ist, und ob die Leute, die es bewohnen, stark oder schwach, gering an Zahl oder zahlreich sind; ");
INSERT INTO deutkw_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","wie das Land beschaffen ist, das sie bewohnen, ob schön oder häßlich; wie die Städte beschaffen sind, die sie bewohnen, ob sie in Lagern oder in Festungen wohnen; ");
INSERT INTO deutkw_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","auch wie der Boden beschaffen ist, ob fett oder mager, ob Bäume darauf stehen oder nicht. So zeigt euch nun tapfer und nehmt etliche Früchte des Landes mit! Es war aber gerade die Zeit der ersten Weintrauben. ");
INSERT INTO deutkw_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Da stiegen sie hinauf und kundschafteten das Land aus von der Steppe Zin an bis Rehob, bis da, wo es nach Hamath hineingeht. ");
INSERT INTO deutkw_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Da stiegen sie hinauf ins Südland und kamen bis Hebron, woselbst sich Ahiman, Sesai und Thalmai, die Sprößlinge Enaks, befanden. Hebron aber war sieben Jahre vor Zoan in Ägypten gebaut. ");
INSERT INTO deutkw_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Als sie nun ins Thal Eskol gelangt waren, schnitten sie dort eine Rebe mit einer Weintraube ab und trugen Sie zu zweien an einer Stange fort; auch einige Granatäpfel und einige Feigen. ");
INSERT INTO deutkw_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Jene Örtlichkeit nennt man Thal Eskol wegen der Traube, die die Israeliten dort abgeschnitten haben. ");
INSERT INTO deutkw_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Nach Verlauf von vierzig Tagen aber, nachdem sie das Land ausgekundschaftet hatten, kehrten sie um. ");
INSERT INTO deutkw_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Und sie zogen hin und gelangten zu Mose und Aaron und zu der ganzen Gemeinde der Israeliten in die Steppe Paran nach Kades. Und sie brachten ihnen und der ganzen Gemeinde Bescheid und zeigten ihnen die Früchte des Landes. ");
INSERT INTO deutkw_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Und sie erzählten ihm und sprachen: Wir sind in das Land gelangt, in das du uns gesandt hast. ");
INSERT INTO deutkw_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Allerdings fließt es über von Milch und Honig, und dies hier sind Früchte von ihm. Aber freilich die Leute, die das Land bewohnen, sind stark und die Städte fest und sehr groß; dazu haben wir dort auch die Sprößlinge Enaks erblickt. ");
INSERT INTO deutkw_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Die Amalekiter bewohnen das Südland, die Hethiter, Jebusiter und Amoriter bewohnen das Gebirge, die Kanaaniter wohnen am Meer und zur Seite des Jordan. ");
INSERT INTO deutkw_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Kaleb aber beschwichtigte das Murren des Volks gegen Mose und rief: Wir wollen dennoch hinaufziehn und es erobern, denn wir können es recht gut bewältigen! ");
INSERT INTO deutkw_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Jedoch die Männer, die mit ihm hinauf gezogen waren, riefen: Wir sind nicht imstande, gegen diese Leute zu Felde zu ziehn, denn sie sind uns zu stark! ");
INSERT INTO deutkw_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Und sie berichteten den Israeliten schlimme Dinge über das Land, das sie ausgekundschaftet hatten, und sprachen: Das Land, das wir durchzogen haben, um es auszukundschaften, das frißt seine Bewohner; und alle die Leute, die wir darin sahen, waren von außerordentlicher Größe. ");
INSERT INTO deutkw_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Auch sahen wir dort die Riesen, die Enakiter, die zu den Riesen gehören, und wir kamen uns vor, wie Heuschrecken, und ebenso kamen wir ihnen vor. ");
INSERT INTO deutkw_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Da erhob die ganze Gemeinde ein lautes Geschrei, und es jammerte das Volk in jener Nacht, ");
INSERT INTO deutkw_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","und sämtliche Israeliten murrten wider Mose und Aaron, und die ganze Gemeinde rief ihnen zu: Ach, wären wir doch in Ägypten gestorben oder wären wir doch hier in der Steppe gestorben! ");
INSERT INTO deutkw_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Warum will uns doch Jahwe in dieses Land bringen, damit mir durch das Schwert fallen? Unsere Weiber und kleinen Kinder aber werden eine Beute der Feinde werden. Wäre es nicht das Beste für uns, wir kehrten nach Ägypten zurück? ");
INSERT INTO deutkw_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Und sie sprachen einer zum andern: Laßt uns einen Anführer wählen und nach Ägypten zurückkehren! ");
INSERT INTO deutkw_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Da fielen Mose und Aaron vor der ganzen versammelten Gemeinde der Israeliten auf ihr Angesicht. ");
INSERT INTO deutkw_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Josua aber, der Sohn Nuns, und Kaleb, der Sohn Jephunnes, die das Land mit ausgekundschaftet hatten, zerrissen ihre Kleider ");
INSERT INTO deutkw_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","und sprachen zur ganzen Gemeinde der Israeliten also: Das Land, das wir durchzogen haben, um es auszukundschaften, ist ein überaus schönes Land. ");
INSERT INTO deutkw_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Wenn uns Jahwe geneigt ist, so wird er uns in dieses Land bringen und es uns geben - ein Land, das von Milch und Honig überfließt! ");
INSERT INTO deutkw_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Nur dürft ihr euch nicht gegen Jahwe empören und dürft euch nicht fürchten vor den Bewohnern des Landes, denn wir werden sie aufzehren. Ihr Schutz ist von ihnen gewichen, während mit uns Jahwe ist; fürchtet sie nicht! ");
INSERT INTO deutkw_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Als nun die ganze Gemeinde nahe daran war, sie zu steinigen, da erschien die Herrlichkeit Jahwes vor allen Israeliten am Offenbarungszelt. ");
INSERT INTO deutkw_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Und Jahwe sprach zu Mose: wie lange soll es währen, daß mich dieses Volk verhöhnt, und daß sie mir nicht Glauben schenken trotz aller der Zeichen, die ich unter ihnen gewirkt habe? ");
INSERT INTO deutkw_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Ich will sie durch die Pest töten und sie hinwegtilgen und will dich zum Stammvater eines Volks machen, das größer und zahlreicher ist als sie! ");
INSERT INTO deutkw_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Da sprach Mose zu Jahwe: Aber die Ägypter werden es hören; denn du hast dieses Volk durch deine Macht aus ihrer Mitte herausgeführt. ");
INSERT INTO deutkw_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Und sie werden sprechen zu den Bewohnern dieses Landes. Sie haben gehört, daß du, Jahwe, inmitten dieses Volkes bist, der sich Auge gegen Auge geoffenbart hat, du, Jahwe, und deine Wolke steht über ihnen, und in einer Wolkensäule schreitest du bei Tage vor ihnen her und in einer Feuersäule des Nachts. ");
INSERT INTO deutkw_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Wenn du nun dieses Volk töten wirst, wie einen Mann, so werden die VöIker, die die Kunde von dir vernommen haben, also sprechen: ");
INSERT INTO deutkw_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Weil Jahwe nicht imstande war, dieses Volk in das Land zu bringen, das er ihnen zugeschworen hatte, darum schlachtete er sie ab in der Steppe. ");
INSERT INTO deutkw_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Möchte sich doch nun deine Macht, o Herr, groß erzeigen, wie du verheißen hast, als du sprachst: ");
INSERT INTO deutkw_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","Jahwe ist langsam zum Zorn und reich an Huld, er vergiebt Missethat und Übertretung; aber er läßt nicht ganz ungestraft, sondern ahndet Väterschuld an den Kindern, am dritten und vierten Glied. ");
INSERT INTO deutkw_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Vergieb doch die Missethat dieses Volks kraft deiner großen Huld und wie du von Ägypten an bis heute diesem Volke vergeben hast! ");
INSERT INTO deutkw_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Jahwe antwortete: Ich vergebe, wie du erbeten hast. ");
INSERT INTO deutkw_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Aber wahrlich: so wahr ich lebe, und so gewiß die ganze Erde der Herrlichkeit Jahwes voll werden soll, ");
INSERT INTO deutkw_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","so gewiß sollen alle die Männer, die meine Herrlichkeit und alle die Zeichen, die ich in Ägypten und in der Steppe gewirkt habe, mit Augen gesehen und mich dennoch nun zehnmal versucht haben und ungehorsam gegen mich gewesen sind, ");
INSERT INTO deutkw_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","das Land nicht zu sehen bekommen, das ich ihren Vätern zugeschworen habe; ja von allen denen, die mich verhöhnt haben, soll es keiner zu sehen bekommen. ");
INSERT INTO deutkw_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Deinen Diener Kaleb aber, der sich von einem anderen Geist erfüllt gezeigt und mir vollen Gehorsam bewiesen hat, den will ich in das Land bringen, in das er gegangen war, und seine Nachkommen werden es in Besitz nehmen. ");
INSERT INTO deutkw_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Die Amalekiter aber und die Kanaaniter wohnen in der Niederung. Morgen wendet euch und zieht in die Steppe in der Richtung nach dem Schilfmeere zu. ");
INSERT INTO deutkw_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Und Jahwe redete mit Mose und Aaron also: ");
INSERT INTO deutkw_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","Wie lange soll es währen, daß diese böse Gemeinde wider mich murrt? Das Murren der Israeliten, das sie wider mich erhoben, habe ich gehört! ");
INSERT INTO deutkw_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Sage ihnen: So wahr ich lebe, ist der Spruch Jahwes: Ganz so, wie ihr es laut vor mir ausgesprochen habt, will ich mit euch verfahren. ");
INSERT INTO deutkw_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","In dieser Steppe sollen eure Leiber fallen, und zwar so viele eurer gemustert wurden - die ganze Zahl, von zwanzig Jahren an und darüber, die ihr wider mich gemurrt habt! ");
INSERT INTO deutkw_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Von euch soll keiner hineinkommen in das Land, das ich euch durch einen Eid zum Wohnsitz angewiesen hatte, außer Kaleb, der Sohn Jephunnes, und Josua, der Sohn Nuns. ");
INSERT INTO deutkw_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Eure kleinen Kinder aber, von denen ihr sagtet, sie würden eine Beute der Feinde werden, - die werde ich hineinbringen, damit sie das Land kennen lernen, das ihr verschmäht habt. ");
INSERT INTO deutkw_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Eure eigenen Leiber aber sollen in dieser Steppe fallen. ");
INSERT INTO deutkw_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Eure Söhne aber sollen vierzig Jahre lang in der Steppe ihre Herden weiden und so eure Auflehnung büßen, bis der letzte von euch in der Steppe gefallen ist. ");
INSERT INTO deutkw_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Entsprechend den vierzig Tagen, in denen ihr das Land ausgekundschaftet habt - jeden Tag zu einem Jahre gerechnet - sollt ihr eure Verschuldungen büßen vierzig Jahre lang, daß ihr inne werdet, was es sei, wenn ich die Hand abziehe! ");
INSERT INTO deutkw_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Ich, Jahwe, habe es gesagt: wahrlich, so will ich verfahren mit dieser ganzen bösen Gemeinde, die sich wider mich zusammengerottet hat; in dieser Steppe sollen sie aufgerieben werden, und da sollen sie sterben. ");
INSERT INTO deutkw_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Die Männer aber, die Mose ausgesandt hatte, das Land auszukundschaften, und die nach ihrer Rückkehr die ganze Gemeinde dazu gebracht hatten, wider ihn zu murren, indem sie schlimme Dinge über das Land berichteten, - ");
INSERT INTO deutkw_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","diese Männer, die schlimme Dinge über das Land berichtet hatten, starben dort vor Jahwe eines plötzlichen Todes. ");
INSERT INTO deutkw_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Nur Josua, der Sohn Nuns, und Kaleb, der Sohn Jephunnes, blieben von den Männern, die zur Auskundschaftung des Landes ausgezogen waren, am Leben. ");
INSERT INTO deutkw_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Als nun Mose allen Israeliten diese Worte überbrachte, da wurde das Volk sehr betrübt. ");
INSERT INTO deutkw_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Und am andern Morgen früh zogen Sie hinauf auf die Höhe des Gebirgs und sprachen: Wir sind bereit, hinaufzuziehen in das Gebiet, von dem Jahwe geredet hat; denn wir haben uns vergangen. ");
INSERT INTO deutkw_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Mose aber erwiderte: Warum wollt ihr doch den Befehl Jahwes übertreten? Das wird nicht gelingen! ");
INSERT INTO deutkw_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Zieht nicht hinauf, denn Jahwe ist nicht in eurer Mitte; ihr werdet sonst geschlagen werden und fliehen müssen vor euren Feinden. ");
INSERT INTO deutkw_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Denn die Amalekiter und Kanaaniter stehen euch dort gegenüber, und ihr werdet durch das Schwert fallen. Nachdem ihr euch einmal von Jahwe abgewendet habt, wird Jahwe nicht mit euch sein! ");
INSERT INTO deutkw_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Sie aber blieben hartnäckig dabei, auf die Höhe des Gebirgs zu ziehn; dagegen kamen die Lade mit dem Gesetze Jahwes und Mose nicht aus dem Lager. ");
INSERT INTO deutkw_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Da kamen die Amalekiter und Kanaaniter, die auf jenem Gebirge wohnten, herab und schlugen sie und zersprengten sie bis Horma. ");
INSERT INTO deutkw_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Rede mit den Israeliten und sprich zu ihnen: Wenn ihr in das Land kommt, das ich euch zum Wohnsitze geben werde, ");
INSERT INTO deutkw_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","und Jahwe ein Feueropfer bereiten wollt, es sei nun ein Brandopfer oder ein Schlachtopfer, um ein Gelübde abzutragen oder als freiwillige Gabe oder bei Gelegenheit eurer Feste, um Jahwe einen lieblichen Geruch zu bereiten durch ein Opfer von den Rindern oder den Schafen, ");
INSERT INTO deutkw_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","so soll der, welcher Jahwe seine Opfergabe darbringt, zugleich ein Zehntel Feinmehl, das mit einem Viertel Hin Öl angemacht ist, als Speisopfer darbringen. ");
INSERT INTO deutkw_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","An Wein zum Trankopfer aber sollst du bei Brandopfern oder Schlachtopfern ein Viertel Hin für jedes Lamm herrichten. ");
INSERT INTO deutkw_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Für einen Widder dagegen sollst du als Speisopfer zwei Zehntel Feinmehl, das mit einem Drittel Hin Öl angemacht ist, herrichten, ");
INSERT INTO deutkw_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","und an Öl zum Speisopfer ein Drittel Hin; so wirst du Jahwe ein Opfer lieblichen Geruchs darbringen. ");
INSERT INTO deutkw_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Wirst du aber einen jungen Stier als Brandopfer oder Schlachtopfer herrichten zur Abtragung eines Gelübdes oder als Heilsopfer für Jahwe, ");
INSERT INTO deutkw_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","so soll man zu dem jungen Rinde drei Zehntel Feinmehl, die mit einem halben Hin Öl angemacht sind, als Speisopfer darbringen. ");
INSERT INTO deutkw_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","An Wein zum Trankopfer aber sollst du ein halbes Hin darbringen, als ein Jahwe dargebrachtes Feueropfer lieblichen Geruchs. ");
INSERT INTO deutkw_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","So soll verfahren werden bei jedem Rinde, bei jedem Widder und bei jedem Lamm von den Schafen oder den Ziegen. ");
INSERT INTO deutkw_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Entsprechend der Anzahl der Stücke, die ihr herrichtet, habt ihr Stück für Stück bei einem jeden so zu verfahren. ");
INSERT INTO deutkw_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Jeder Landeseingeborne hat nach diesen Bestimmungen zu verfahren, wenn er Jahwe ein Feueropfer lieblichen Geruchs darbringt. ");
INSERT INTO deutkw_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Und wenn sich ein Fremder bei euch aufhält oder ein solcher, der für immer unter euch ist, so soll er ebenso verfahren, wie ihr verfahrt. ");
INSERT INTO deutkw_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Einerlei Satzung gilt für jedermann, für euch, wie für den Fremden, der sich bei euch aufhält. Das ist eine für alle Zeiten und Geschlechter geltende Satzung: vor Jahwe gilt für den Fremden dasselbe, wie für euch. ");
INSERT INTO deutkw_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Ein und dieselben Bestimmungen und Ordnungen gelten für euch und für den Fremden, der sich bei euch aufhält. ");
INSERT INTO deutkw_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Rede mit den Israeliten und sprich zu ihnen: Wenn ihr in das Land kommt, in das ich euch bringen werde, ");
INSERT INTO deutkw_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","so sollt ihr, wenn ihr von dem Getreide des Landes eßt, Jahwe eine Hebe abgeben. ");
INSERT INTO deutkw_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Als Erstling eures Schrotmehls sollt ihr einen Kuchen als Hebe abgeben; ebenso, wie die Hebe von der Tenne, sollt ihr sie abgeben. ");
INSERT INTO deutkw_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Von den Erstlingen eures Schrotmehls sollt ihr Jahwe eine Hebe geben, von Geschlecht zu Geschlecht. ");
INSERT INTO deutkw_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Und wenn ihr euch unvorsätzlich vergeht und irgend eines dieser Gebote, die Jahwe Mose aufgetragen hat, zu befolgen unterlaßt, ");
INSERT INTO deutkw_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","irgend etwas von dem, was euch Jahwe durch Mose hat befehlen lassen, von dem Tag an, an welchem Jahwe Gebote gab, und weiterhin, von Geschlecht zu Geschlecht, ");
INSERT INTO deutkw_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","so soll, wenn das Versehen unwissentlich von der Gemeinde begangen worden ist, die ganze Gemeinde einen jungen Stier zum Brandopfer herrichten, zu einem lieblichen Geruch für Jahwe, nebst dem zugehörigen Speisopfer und Trankopfer, wie es sich gebührt, und einen Ziegenbock zum Sündopfer. ");
INSERT INTO deutkw_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Wenn nun der Priester der ganzen Gemeinde der Israeliten Sühne geschafft haben wird, so wird ihnen vergeben werden. Denn es war ein Versehen, und sie haben ihre Opfergabe in Gestalt eines Feueropfers für Jahwe, dazu ihr Sündopfer vor Jahwe wegen ihres Versehens dargebracht. ");
INSERT INTO deutkw_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","So wird dann der ganzen Gemeinde der Israeliten, sowie dem Fremden, der sich unter ihnen aufhält, vergeben werden; denn das Vergehen fiel dem ganzen Volke zur Last. ");
INSERT INTO deutkw_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Wenn sich dagegen ein einzelner unvorsätzlich vergeht, so hat er eine einjährige Ziege als Sündopfer darzubringen. ");
INSERT INTO deutkw_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Und der Priester soll dem, der sich durch sein Versehen unvorsätzlich gegen Jahwe vergangen hat, Sühne schaffen, indem er die Sühnegebräuche für ihn vollzieht, so wird ihm vergeben werden. ");
INSERT INTO deutkw_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Ein und dieselbe Bestimmung gilt für euch, - für den Landeseingebornen unter den Israeliten, wie für den Fremden, der sich unter ihnen aufhält, - wenn jemand unvorsätzlich etwas thut. ");
INSERT INTO deutkw_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Wenn aber jemand vorsätzlich sündigt, er sei ein Landesdeingeborner oder ein Fremder, der lästert Jahwe; ein solcher soll hinweggetilgt werden aus seinen Volksgenossen. ");
INSERT INTO deutkw_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Denn er hat das Wort Jahwes für nichts geachtet und sein Gebot zu nichte gemacht; ein solcher soll unerbittlich weggetilgt werden - seine Verschuldung lastet auf ihm. ");
INSERT INTO deutkw_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Während die Israeliten in der Steppe waren, ertappten sie einen Mann, der am Sabbattage Holz laß. ");
INSERT INTO deutkw_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Da brachten ihn die, welche ihn beim Holzlesen ertappt hatten, zu Mose und Aaron und zu der ganzen Gemeinde. ");
INSERT INTO deutkw_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Und man legte ihn in Gewahrsam; denn es war noch keine Bestimmung darüber vorhanden, was mit ihm zu geschehen habe. ");
INSERT INTO deutkw_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Jahwe aber sprach zu Mose: Der Mann ist mit dem Tode zu bestrafen; die ganze Gemeinde soll ihn außerhalb des Lagers steinigen! ");
INSERT INTO deutkw_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Da führte ihn die ganze Gemeinde hinaus vor das Lager und steinigte ihn zu Tode, wie Jahwe Mose befohlen hatte. ");
INSERT INTO deutkw_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Und Jahwe sprach zu Mose also: ");
INSERT INTO deutkw_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Rede mit den Israeliten und sprich zu ihnen, sie sollen sich Quasten an den Zipfeln ihrer Kleider machen, sie und ihre Nachkommen, und an jeder Zipfelquaste eine Schnur von blauem Purpur anbringen. ");
INSERT INTO deutkw_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Das soll euch ein bedeutsamer Schmuck sein: wenn ihr ihn anseht, so sollt ihr aller Gebote Jahwes gedenken, daß ihr nach ihnen thut und nicht abschweift zu dem, was euer Herz und eure Augen gelüstet, durch die ihr euch zur Abgötterei verführen laßt; ");
INSERT INTO deutkw_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","damit ihr aller meiner Gebote eingedenk seid und nach ihnen thut und so heilig seid vor eurem Gott. ");
INSERT INTO deutkw_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ich bin Jahwe, euer Gott, der euch aus Ägypten weggeführt hat, um euer Gott zu sein, ich, Jahwe, euer Gott! ");
INSERT INTO deutkw_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Es empörte sich aber Korah, der Sohn Jizhars, des Sohnes Kahaths, des Sohnes Levis, und Dathan und Abiram, die Söhne Eliabs, des Sohnes Pallus, des Sohnes Rubens. ");
INSERT INTO deutkw_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Die empörten sich gegen Mose samt zweihundertundfünfzig Männern aus den Israeliten, die Vorsteher der Gemeinde, Ratsherren und hochangesehen waren. ");
INSERT INTO deutkw_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Und sie scharten sich wider Mose und Aaron zusammen und sprachen zu ihnen: Laßt's nun genug sein! Denn die ganze Gemeinde, alle miteinander, sind heilig, und Jahwe ist unter ihnen; warum erhebt ihr euch da über die Gemeinde Jahwes? ");
INSERT INTO deutkw_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Als Mose das hörte, fiel er auf sein Angesicht. ");
INSERT INTO deutkw_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Sodann antwortete er Korah und seiner ganzen Rotte also: Morgen wird Jahwe kund thun, wer ihm angehört und wer heilig ist, daß er ihn zu sich nahen lasse; wer ihm genehm ist, den wird er zu sich nahen lassen! ");
INSERT INTO deutkw_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Thut Folgendes: Nehmt euch Räucherpfannen, Korah und seine ganze Rotte, ");
INSERT INTO deutkw_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","thut Feuer darein und legt morgen vor Jahwe Räucherwerk darauf; und derjenige, zu dem sich Jahwe bekennt, der soll als heilig gelten. Laßt's nun genug sein, ihr Söhne Levis! ");
INSERT INTO deutkw_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Und Mose sprach zu Korah: Hört doch, ihr Söhne Levis! ");
INSERT INTO deutkw_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Ist's euch nicht genug, daß euch der Gott Israels aus der Gemeinde Israels ausgesondert hat, um euch zu sich nahen zu lassen, damit ihr den Dienst an der Wohnung Jahwes verrichtet und euch der Gemeinde zur Verfügung stellt, sie zu bedienen? ");
INSERT INTO deutkw_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Und er ließ dich samt allen deinen Brüdern, den Söhnen Levis, zu sich nahen, und nun verlangt ihr auch noch Priesterrechte? ");
INSERT INTO deutkw_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Somit rottet ihr euch wider Jahwe zusammen, du und deine ganze Rotte, - denn was ist Aaron, daß ihr wider ihn murrt? ");
INSERT INTO deutkw_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Und Mose ließ Dathan und Abiram, die Söhne Eliabs, rufen; sie erwiderten jedoch: Wir kommen nicht! ");
INSERT INTO deutkw_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Ist's nicht genug damit, daß du uns aus einem Lande, das von Milch und Honig überfloß, hergeführt hast, um uns in der Steppe umkommen zu lassen, daß du dich auch noch zum Herrscher über uns aufwerfen willst? ");
INSERT INTO deutkw_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Ja, fein hast du uns in ein Land gebracht, das von Milch und Honig überfließt, und uns Felder und Weinberge zum Besitze gegeben! Meinst du, du könnest die Leute blind machen? Wir kommen nicht! ");
INSERT INTO deutkw_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Da wurde Mose sehr zornig und sprach zu Jahwe: Wende dich nicht zu ihrem Opfer! Keinem von ihnen habe ich auch nur einen Esel genommen, keinem von ihnen etwas zu Leide gethan! ");
INSERT INTO deutkw_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Da sprach Mose zu Korah: Du und deine ganze Rotte mögt euch morgen vor Jahwe einfinden - du und sie und Aaron! ");
INSERT INTO deutkw_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Und nehmt ein jeder seine Räucherpfanne, thut Räucherwerk darauf und bringt dann ein jeder seine Räucherpfanne hin vor Jahwe - zweihundertundfünfzig Räucherpfannen; auch du und Aaron bringt ein jeder seine Räucherpfanne! ");
INSERT INTO deutkw_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Da nahmen sie ein jeder seine Räucherpfanne, thaten Feuer darein und legten Räucherwerk darauf. Sodann stellten sie sich vor der Thüre des OffenbarungszeItes auf, und ebenso Mose und Aaron. ");
INSERT INTO deutkw_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Und Korah versammelte wider sie die ganze Gemeinde vor die Thüre des Offenbarungszeltes. Da erschien der ganzen Gemeinde die Herrlichkeit Jahwes. ");
INSERT INTO deutkw_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Und Jahwe redete mit Mose und Aaron also: ");
INSERT INTO deutkw_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","Sondert euch ab von dieser Gemeinde, daß ich sie im Nu vertilge! ");
INSERT INTO deutkw_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Da fielen sie auf ihr Angesicht und sprachen: O Gott, du Herr des Lebensodems in einem jeglichen Leibe! Willst du, wenn ein Mann sündigt, wider die ganze Gemeinde wüten? ");
INSERT INTO deutkw_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Da redete Jahwe mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","Rede mit der Gemeinde und gebiete ihr: Zieht euch zurück aus dem Bereiche der Wohnung Korahs, Dathans und Abirams! ");
INSERT INTO deutkw_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Hierauf begab sich Mose hin zu Dathan und Abiram, und die Vornehmsten der Israeliten folgten ihm. ");
INSERT INTO deutkw_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Und er redete mit der Gemeinde also: Zieht euch schIeunig zurück von den Zelten dieser gottlosen Männer und berührt nichts von dem, was ihnen gehört, damit ihr nicht mit weggerafft werdet um aller ihrer Sünden willen! ");
INSERT INTO deutkw_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Da zogen sie sich aus dem Bereiche der Wohnung Korahs, Dathans und Abirams zurück. Dathan aber und Abiram waren herausgetreten und hatten sich vor der Thür ihrer Zelte aufgestellt, samt ihren Weibern und ihren großen und kleinen Kindern. ");
INSERT INTO deutkw_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Da sprach Mose: Daran sollt ihr erkennen, daß Jahwe mich gesandt hat, um alle diese Thaten zu verrichten, und daß ich sie nicht von mir aus verrichtet habe. ");
INSERT INTO deutkw_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Wenn diese sterben werden, wie alle Menschen sterben, und ihnen nur widerfährt, was allen Menschen zu widerfahren pflegt, so war es nicht Jahwe, der mich gesandt hat. ");
INSERT INTO deutkw_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Wenn aber Jahwe etwas Unerhörtes schafft, und die Erde ihren Mund aufthut und sie mit allem, was ihnen gehört, verschlingt, so daß sie lebendig in die Unterwelt hinabfahren, - dann werdet ihr erkennen, daß diese Männer Jahwe gelästert haben! ");
INSERT INTO deutkw_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Als er nun mit dieser seiner Rede zu Ende gekommen war, da spaltete sich der Boden unter ihnen, ");
INSERT INTO deutkw_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","und die Erde that ihren Mund auf und verschlang sie samt ihren Behausungen und allen den Leuten, die Korah gehörten, und der gesamten Habe. ");
INSERT INTO deutkw_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","So fuhren sie mit allem, was ihnen gehörte, lebendig hinab in die Unterwelt, und die Erde schloß sich über ihnen, so daß sie mitten aus der Gemeinde verschwunden waren. ");
INSERT INTO deutkw_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Und ganz Israel, das rings um sie her war, floh bei ihrem Geschrei, denn sie dachten: die Erde könnte uns sonst auch verschIingen! ");
INSERT INTO deutkw_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Und es ging Feuer aus von Jahwe und verzehrte die zweihundertundfünfzig Männer, die das Räucherwerk darbrachten. ");
INSERT INTO deutkw_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","Sage Eleasar, dem Sohne Aarons, des Priesters, er soll die Räucherpfannen von der Brandstätte aufheben, und streue das Feuer in einiger Entfernung von hier aus. Denn ");
INSERT INTO deutkw_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","die Räucherpfannen dieser Frevler sind dem Heiligtume verfallen, nachdem sie mit ihrem Leben gebüßt haben; man schlage sie breit zu Blechen und überziehe damit den Altar. Denn sie haben sie hingebracht vor Jahwe, und so sind sie dem Heiligtume verfallen. So mögen sie nun zu einem Wahrzeichen für die Israeliten werden. ");
INSERT INTO deutkw_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Da nahm Eleasar, der Priester, die kupfernen Räucherpfannen, welche die Verbrannten hingebracht hatten, und man schlug sie breit zu einem Überzuge für den Altar, ");
INSERT INTO deutkw_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","als ein Merkzeichen für die Israeliten, daß keiner, der nicht zu den Nachkommen Aarons gehört, herzutreten darf, um vor Jahwe Räucherwerk anzuzünden, daß es ihm nicht ergehe, wie Korah und seiner Rotte, wie ihm Jahwe durch Mose verkündigt hatte. ");
INSERT INTO deutkw_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Am andern Morgen aber murrte die ganze Gemeinde der Israeliten wider Mose und Aaron und rief: Ihr habt die, welche Jahwe angehörten, umgebracht! ");
INSERT INTO deutkw_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Als sich nun die Gemeinde wider Mose und Aaron zusammenrottete, da blickten diese nach dem Offenbarungszelt; und schon bedeckte es die Wolke und die Herrlichkeit Jahwes erschien. ");
INSERT INTO deutkw_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Da begaben sich Mose und Aaron hin vor das Offenbarungszelt. ");
INSERT INTO deutkw_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Hebt euch hinweg aus dieser Gemeinde, damit ich sie im Nu vertilge! Da fielen sie auf ihr Angesicht. ");
INSERT INTO deutkw_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Mose aber sprach zu Aaron: Nimm die Räucherpfanne, thue Feuer vom Altar hinein, lege Räucherwerk auf und trage es schleunig in die Gemeinde hinein, daß du ihnen Sühne schaffst; denn das Wüten ist bereits von Jahwe ausgegangen, die Plage hat begonnen. ");
INSERT INTO deutkw_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Da nahm Aaron, wie Mose geboten hatte, und lief mitten unter die Volksmenge hinein. Schon hatte die Plage unter dem Volke begonnen; da räucherte er und schaffte so dem Volke Sühne. ");
INSERT INTO deutkw_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Als er nun dastand zwischen den Toten und den Lebendigen, da wurde der Plage Einhalt gethan. ");
INSERT INTO deutkw_vpl VALUES ("NU17_14","005_17_14","NUM","17","14","14","Es belief sich aber die Zahl derer, die durch die Plage umgekommen waren, auf 14700; ungerechnet die, welche um Korahs willen umgekommen waren. ");
INSERT INTO deutkw_vpl VALUES ("NU17_15","005_17_15","NUM","17","15","15","Hierauf kehrte Aaron zurück zu Mose vor die Thüre des OffenbarungszeItes, und der Plage war Einhalt gethan. ");
INSERT INTO deutkw_vpl VALUES ("NU17_16","005_17_16","NUM","17","16","16","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("NU17_17","005_17_17","NUM","17","17","17","Rede mit den Israeliten und laß dir von ihnen je einen Stab von jedem Stamme geben, von allen ihren Fürsten, Stamm für Stamm, zusammen zwölf Stäbe. Schreibe den Namen eines jeden auf seinen Stab, ");
INSERT INTO deutkw_vpl VALUES ("NU17_18","005_17_18","NUM","17","18","18","den Namen Aarons aber schreibe auf den Stab Levis; denn ein Stab gehört ihrem Stammhaupte zu. ");
INSERT INTO deutkw_vpl VALUES ("NU17_19","005_17_19","NUM","17","19","19","Sodann lege Sie im Offenbarungszelte nieder vor dem Gesetze, woselbst ich mich dir zu offenbaren pflege. ");
INSERT INTO deutkw_vpl VALUES ("NU17_20","005_17_20","NUM","17","20","20","Und der Stab desjenigen, den ich erwähle, soll ausschlagen; so will ich das Murren der Israeliten, das sie gegen euch erheben, zum Schweigen bringen, daß es mir nicht nochmals lästig falle! ");
INSERT INTO deutkw_vpl VALUES ("NU17_21","005_17_21","NUM","17","21","21","Als Mose dies den Israeliten verkündigt hatte, übergaben ihm alle ihre Fürsten, Stamm für Stamm, jeder Fürst einen Stab, zusammen zwölf Stäbe, und der Stab Aarons war mit unter ihren Stäben. ");
INSERT INTO deutkw_vpl VALUES ("NU17_22","005_17_22","NUM","17","22","22","Sodann legte Mose die Stäbe vor Jahwe im Gesetzeszelte nieder. ");
INSERT INTO deutkw_vpl VALUES ("NU17_23","005_17_23","NUM","17","23","23","Als aber Mose am folgenden Morgen das Gesetzeszelt betrat, da hatte der Stab Aarons, der vom Stamme Levi, ausgeschlagen, hatte Sprossen und Blüten getrieben und trug nun reife Mandeln. ");
INSERT INTO deutkw_vpl VALUES ("NU17_24","005_17_24","NUM","17","24","24","Da brachte Mose die sämtlichen Stäbe aus dem Heiligtum heraus zu allen Israeliten, und sie beschauten sie und nahmen sich ein jeder seinen Stab. ");
INSERT INTO deutkw_vpl VALUES ("NU17_25","005_17_25","NUM","17","25","25","Jahwe aber gebot Mose: lege den Stab Aarons wieder hin vor das Gesetz, damit er aufbewahrt bleibe als ein Wahrzeichen für Widerspenstige, und ihr Murren ein Ende habe und mir nicht nochmals lästig falle; sonst müßten sie sterben! ");
INSERT INTO deutkw_vpl VALUES ("NU17_26","005_17_26","NUM","17","26","26","Da that Mose, wie ihm Jahwe befohlen hatte; also that er. ");
INSERT INTO deutkw_vpl VALUES ("NU17_27","005_17_27","NUM","17","27","27","Die Iraeliten aber sprachen zu Mose: Fürwahr, wir kommen um, wir sind verloren, wir sind alle verloren! ");
INSERT INTO deutkw_vpl VALUES ("NU17_28","005_17_28","NUM","17","28","28","Wer irgend herantritt, wer herantritt an die Wohnung Jahwes, muß sterben; sollen wir denn bis auf den letzten Mann umkommen? ");
INSERT INTO deutkw_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Und Jahwe sprach zu Aaron: Du und deine Söhne und dein väterlicher Stamm sollt die Verfehlungen in betreff der heiligen Dinge auf euch nehmen; du aber und deine Söhne sollt die Verfehlungen gegen eure Priesterpflichten auf euch nehmen. ");
INSERT INTO deutkw_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Aber auch deine Brüder, den Stamm Levi, deinen väterlichen Stamm, laß mit dir herantreten, daß sie sich dir anschließen und dich bedienen, während du mit deinen Söhnen vor dem Gesetzeszelte bist. ");
INSERT INTO deutkw_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Und zwar sollen sie die Geschäfte verrichten, die zu deiner und des ganzen Zeltes Bedienung erforderlich sind. Nur dürfen sie nicht herantreten an die heiligen Geräte und an den Altar, sonst müßten sie und ihr sterben. ");
INSERT INTO deutkw_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Und sie sollen sich an dich anschließen und die Geschäfte am Offenbarungszelte besorgen, den gesamten Dienst am Zelte; ein Fremder dagegen darf nicht zu euch herantreten. ");
INSERT INTO deutkw_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Ihr aber sollt die Geschäfte im Heiligtum und die Geschäfte am Altar besorgen, damit nicht nochmals ein Wüten über die Israeliten komme. ");
INSERT INTO deutkw_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Ich meinerseits habe eure Brüder, die Leviten, aus den Israeliten genommen als ein Geschenk für euch, als solche, die Jahwe zu eigen gegeben sind, damit sie den Dienst am Offenbarungszelte besorgen. ");
INSERT INTO deutkw_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Du aber und deine Söhne sollt eures Priesteramts warten in allen Angelegenheiten des Altars und drinnen hinter dem Vorhang, und sollt Dienst thun. Als einen geschenkweise verliehenen Dienst übergebe ich euch das Priestertum; der Fremde aber, der herantritt, soll mit dem Tode bestraft werden. ");
INSERT INTO deutkw_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Und Jahwe sprach zu Aaron: Ich meinerseits überweise dir, was von meinen Hebeopfern aufzubewahren ist; von allen heiligen Gaben der Israeliten überweise ich sie dir und deinen Söhnen als Anteil, als eine allezeit fällige Gebühr. ");
INSERT INTO deutkw_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Folgendes soll dir von den hochheiligen Gaben - nach Abzug des zu Verbrennenden gehören: alle ihre Opfergaben an Speisopfern, an Sündopfern und an Schuldopfern, die sie mir als Ersatz darbringen; als hochheilige sollen sie dir und deinen Söhnen gehören. ");
INSERT INTO deutkw_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","An hochheiligem Orte sollst du sie verzehren. Alles, was männlich ist, darf sie verzehren; als etwas Heiliges sollen sie dir gelten. ");
INSERT INTO deutkw_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Und dies soll dir als Hebe von ihren übrigen Gaben zufallen, von allen Webeopfern der Israeliten: ich überweise sie dir und deinen Söhnen und Töchtern als eine allezeit fällige Gebühr; jeder, der rein ist in deiner Familie, darf es verzehren. ");
INSERT INTO deutkw_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Alles Beste vom Öl und alles Beste vom Most und Getreide, das Vorzüglichste davon, das sie Jahwe geben, das habe ich dir überwiesen. ");
INSERT INTO deutkw_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Die Erstlinge von allem, was in ihrem Lande ist, die sie Jahwe bringen, sollen dir gehören; jeder, der rein ist in deiner Familie, darf es verzehren. ");
INSERT INTO deutkw_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Alles Gebannte in Israel soll dir gehören. ");
INSERT INTO deutkw_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Alles, was den Mutterschoß durchbricht von allem, was man Jahwe darzubringen pflegt, es sei Mensch oder Vieh, soll dir gehören; nur mußt du die menschliche Erstgeburt auslösen lassen und ebenso mußt du die Erstgeburt eines unreinen Tiers auslösen lassen. ");
INSERT INTO deutkw_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Und was seine Auslösung betrifft, so sollst du ihn im Alter von einem Monat und darüber auf Grund der Schätzung für einen Betrag von fünf Sekeln heiliges Gewicht, den Sekel zu zwanzig Gera gerechnet, auslösen lassen. ");
INSERT INTO deutkw_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Dagegen darfst du die Erstgeburt eines Rindes oder Schafs oder einer Ziege nicht auslösen lassen; sie sind heilig. Ihr Blut sollst du an den Altar sprengen und ihr Fett in Rauch aufgehn lassen als ein Jahwe dargebrachtes Feueropfer lieblichen Geruchs. ");
INSERT INTO deutkw_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Ihr Fleisch aber soll dir gehören; wie die Webebrust und die rechte Keule soll es dir gehören. ");
INSERT INTO deutkw_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Alle Hebeopfer von den heiligen Gaben, welche die Israeliten Jahwe als Hebe abgeben, überweise ich dir und deinen Söhnen und Töchtern als eine allezeit fällige Gebühr: ein für alle Zeiten giltiger Salzbund ist dies vor Jahwe für dich und für deine Nachkommen. ");
INSERT INTO deutkw_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Und Jahwe sprach zu Aaron: Du sollst in ihrem Lande keinen Erbbesitz haben und sollst keinen Anteil unter ihnen besitzen; ich bin dein Anteil und dein Erbbesitz inmitten der Israeliten. ");
INSERT INTO deutkw_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Wohl aber überweise ich den Söhnen Levis alle Zehnten in Israel als Erbbesitz für den Dienst, den sie verrichten, den Dienst am Offenbarungszelt. ");
INSERT INTO deutkw_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Die Israeliten aber dürfen fortan nicht mehr an das Offenbarungszelt herantreten, da sie sonst Sünde auf sich laden und umkommen würden. ");
INSERT INTO deutkw_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Vielmehr die Leviten haben den Dienst am Offenbarungszelte zu verrichten und haben die Verfehlungen jener auf sich zu nehmen, kraft einer allezeit, von Geschlecht zu Geschlecht, für euch giltigen Satzung; aber Erbbesitz sollen sie unter den Israeliten nicht besitzen. ");
INSERT INTO deutkw_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Denn ich überweise den Leviten die Zehnten der Israeliten, die sie an Jahwe als Hebeopfer abgeben, zum Erbbesitz; darum habe ich in Bezug auf sie verordnet, daß sie keinen Erbbesitz unter den Israeliten besitzen sollen. ");
INSERT INTO deutkw_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Den Leviten aber sollst du sagen und sie anweisen: Wenn ihr von den Israeliten den Zehnten in Empfang nehmt, den ich euch als Abgabe von jenen zum Erbbesitz überwiesen habe, so sollt ihr von ihm ein Hebeopfer für Jahwe abgeben, einen Zehnten vom Zehnten. ");
INSERT INTO deutkw_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Dieses euer Hebeopfer wird euch angerechnet werden wie Getreide von der Tenne und Überfluß von der Kelter. ");
INSERT INTO deutkw_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Ebenso sollt auch ihr von allen euch zufallenden Zehnten, die ihr von den Israeliten in Empfang nehmt, ein Hebeopfer für Jahwe abgeben; und zwar sollt ihr davon das für Jahwe bestimmte Hebeopfer Aaron, dem Priester, übergeben. ");
INSERT INTO deutkw_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Von allen euch zufallenden Gaben habt ihr stets ein Hebeopfer für Jahwe abzugeben, und zwar von allem Besten daran, als die von ihm zu entrichtende heilige Gabe. ");
INSERT INTO deutkw_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Sprich zu ihnen: wenn ihr so das Beste von ihm abgebt, so wird es den Leviten angerechnet werden wie Ertrag von der Tenne und Ertrag von der Kelter. ");
INSERT INTO deutkw_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Ihr dürft ihn an jedem Orte verzehren, ihr und eure Familie; denn er ist euer Lohn für euren Dienst am Offenbarungszelt. ");
INSERT INTO deutkw_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Und ihr werdet seinethalben keine Sünde auf euch laden, wenn ihr nur das Beste von ihm abgebt, und werdet die heiligen Gaben der Israeliten nicht entweihen und nicht umkommen. ");
INSERT INTO deutkw_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Und Jahwe redete mit Mose und Aaron also: ");
INSERT INTO deutkw_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","Dies ist die Gesetzesbestimmung, die Jahwe ergehen ließ, indem er verordnete: Sage den Israeliten, daß sie dir eine rotfarbige, fehllose Kuh bringen sollen, an der kein Makel, und auf welche noch nie ein Joch gekommen ist. ");
INSERT INTO deutkw_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Die sollt ihr Eleasar, dem Priester, übergeben; sodann führe man sie hinaus vor das Lager und schlachte sie vor seinen Augen. ");
INSERT INTO deutkw_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Und Eleasar, der Priester, nehme mit seinem Finger etwas von ihrem Blut und sprenge siebenmal etwas von ihrem Blut in der Richtung nach der Vorderseite des Offenbarungszeltes hin. ");
INSERT INTO deutkw_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Sodann verbrenne man die Kuh vor seinen Augen; ihr Fett, ihr Fleisch und ihr Blut soll man verbrennen samt ihrem Mist. ");
INSERT INTO deutkw_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Der Priester aber nehme Cedernholz, Ysop und Karmesin und werfe es hinein in das Feuer, in dem die Kuh brennt. ");
INSERT INTO deutkw_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Sodann wasche der Priester seine Kleider und bade seinen Leib. Darnach darf er ins Lager kommen; doch bleibt der Priester unrein bis zum Abend. ");
INSERT INTO deutkw_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Auch derjenige, der sie verbrannt hat, muß seine Kleider waschen und seinen Leib baden und bleibt unrein bis zum Abend. ");
INSERT INTO deutkw_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Und einer, der rein ist, sammle die Asche der Kuh und lege sie draußen vor dem Lager an einem reinen Orte nieder, damit sie für die Gemeinde des Israeliten zum Reinigungswasser aufbewahrt werde; ein Sündopfer ist es. ");
INSERT INTO deutkw_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Und derjenige, der die Asche der Kuh gesammelt hat, muß seine Kleider waschen und bleibt unrein bis zum Abend. Es soll aber den Israeliten und dem Fremden, der sich unter ihnen aufhält, als eine allezeit zu beobachtende Satzung gelten: ");
INSERT INTO deutkw_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Wer einen Toten, irgendwelche menschliche Leiche, berührt, der wird für sieben Tage unrein. ");
INSERT INTO deutkw_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Ein solcher soll sich damit entsündigen am dritten Tag und am siebenten Tage, so wird er rein werden. Entsündigt er sich aber nicht am dritten Tag und am siebenten Tage, so bleibt er unrein. ");
INSERT INTO deutkw_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Jeder, der einen Toten, die Leiche eines gestorbenen Menschen, berührt und sich nicht entsündigt, der verunreinigt die Wohnung Jahwes, und ein solcher soll hinweggetilgt werden aus Israel. Weil kein Reinigungswasser auf ihn gesprengt ward, bleibt er unrein; seine Unreinigkeit haftet an ihm nach wie vor. ");
INSERT INTO deutkw_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Folgende Bestimmung gilt, wenn jemand in einem Zelte stirbt: jeder, der das Zelt betritt, und jeder, der sich in dem Zelte befindet, wird für sieben Tage unrein. ");
INSERT INTO deutkw_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Und jedes offene Gefäß, auf dem nicht ein mit einer Schnur befestigter Deckel liegt, wird unrein. ");
INSERT INTO deutkw_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Ebenso wird jeder, der auf freiem Felde mit einem Ermordeten oder Gestorbenen oder einem Gerippe oder Grabe in Berührung kommt, für sieben Tage unrein. ");
INSERT INTO deutkw_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Für einen so Verunreinigten nehme man Asche von dem verbrannten Sündopfer und gieße in einem Gefäße lebendiges Wasser darüber. ");
INSERT INTO deutkw_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Sodann nehme einer, der rein ist, Ysop, tauche ihn in das Wasser und besprenge das Zelt samt allen Geräten und den Personen, die darin waren, sowie den, der mit einem Gerippe oder einem Ermordeten oder Gestorbenen oder einem Grabe in Berührung gekommen war. ");
INSERT INTO deutkw_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Und zwar soll der Reine den Unreinen am dritten Tag und am siebenten Tage besprengen; so wird er ihn am siebenten Tag entsündigen. Alsdann hat er seine Kleider zu waschen und sich zu baden, so wird er am Abend rein sein. ");
INSERT INTO deutkw_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Wenn aber jemand unrein wird und sich nicht entsündigt, ein solcher soll hinweggetilgt werden aus der Volksgemeinde; denn er hat das Heiligtum Jahwes verunreinigt: es ist kein Reinigungswasser auf ihn gesprengt worden, darum ist er unrein. ");
INSERT INTO deutkw_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Dies soll euch als eine allezeit zu beobachtende Satzung gelten. Und wer das Reinigungswasser sprengt, hat seine Kleider zu waschen, und wer das Reinigungswasser berührt, wird unrein bis zum Abend. ");
INSERT INTO deutkw_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Und alles, was der unrein Gewordene berührt, wird unrein; ebenso wird jeder, der ihn berührt, unrein bis zum Abend. ");
INSERT INTO deutkw_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Und die ganze Gemeinde der Israeliten gelangte in die Steppe Zin im ersten Monat, und das Volk ließ sich nieder in Kades. Und Mirjam starb daselbst und wurde daselbst begraben. ");
INSERT INTO deutkw_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Es hatte aber die Gemeinde kein Wasser. Da rotteten sie sich wider Mose und Aaron zusammen, ");
INSERT INTO deutkw_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","und das Volk haderte mit Mose und schrie: Ach, wären wir doch nur mit umgekommen, als unsere Brüder vor Jahwe umkamen! ");
INSERT INTO deutkw_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Warum hast du doch die Volksgemeinde Jahwes in diese Steppe gebracht, daß wir hier sterben sollen samt unserem Vieh! ");
INSERT INTO deutkw_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Und warum hast du uns aus Ägypten fortgeführt, um uns an diesen bösen Ort zu bringen, wo man nicht säen kann, und wo es keine Feigen und Weinstöcke und Granatäpfel und kein Trinkwasser giebt! ");
INSERT INTO deutkw_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Mose und Aaron aber wichen vor dem Volk an die Thüre des Offenbarungszeltes und fielen auf ihr Angesicht; da erschien ihnen die Herrlichkeit Jahwes. ");
INSERT INTO deutkw_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Und Jahwe redete mit Mose also: Hole den Stab, versammle die Gemeinde, du und dein Bruder Aaron, und redet vor ihren Augen mit dem Felsen, so wird er Wasser hergeben. ");
INSERT INTO deutkw_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Laß für sie Wasser aus dem Felsen hervorgehn und schaffe der Gemeinde zu trinken samt ihrem Vieh! ");
INSERT INTO deutkw_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Da holte Mose den Stab aus dem Heiligtume, wie ihm Jahwe befohlen hatte. ");
INSERT INTO deutkw_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Hierauf versammelten Mose und Aaron das Volk vor den Felsen. Und er sprach zu ihnen: Hört, ihr Widerspenstigen! Können wir wohl aus diesem Felsen Wasser für euch hervorgehn lassen! ");
INSERT INTO deutkw_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Hierauf erhob Mose seine Hand und schlug mit seinem Stabe zweimal an den Felsen. Da kam viel Wasser herauf, so daß die Gemeinde trinken konnte samt ihrem Vieh. ");
INSERT INTO deutkw_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Jahwe aber sprach zu Mose und Aaron: Weil ihr mir nicht vertraut habt, daß ihr mir als dem Heiligen die Ehre gegeben hättet vor den Augen der Israeliten, so sollt ihr dieses Volk nicht hineinbringen in das Land, das ich ihnen verliehen habe. ");
INSERT INTO deutkw_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Das ist das Haderwasser, wo die Israeliten mit Jahwe haderten, und er sich unter ihnen verherrlichte. ");
INSERT INTO deutkw_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Und Mose sandte von Kades aus Boten an den König von Edom: So spricht dein Bruder Israel: Du kennst alle die Mühsale, die uns betroffen haben, ");
INSERT INTO deutkw_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","wie unsere Vorväter nach Ägypten zogen, und wir lange Zeit in Ägypten wohnen geblieben sind, und daß die Ägypter uns, wie unsere Väter, hart bedrückt haben. ");
INSERT INTO deutkw_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Da schrieen wir zu Jahwe um Hilfe, und er hörte unser Flehen und sandte einen Engel; der führte uns aus Ägypten hinweg. Nun sind wir hier in Kades, einer Stadt an der Grenze deines Gebiets. ");
INSERT INTO deutkw_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Laß uns doch durch dein Land ziehen! Wir wollen nicht durch Äcker oder Weinberge ziehen und kein Wasser aus den Brunnen trinken; auf der Heerstraße wollen wir dahinziehen, ohne nach rechts oder links abzubiegen, bis wir dein Gebiet durchzogen haben. ");
INSERT INTO deutkw_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Edom aber antwortete ihm: Du darfst nicht durch mein Land ziehen, sonst müßte ich dir mit dem Schwert entgegentreten! ");
INSERT INTO deutkw_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Da sprachen die Israeliten zu ihm: Auf der gebahnten Straße wollen wir dahinziehen, und wenn wir von deinem Wasser trinken, wir und unsere Herden, so wollen wir's bezahlen. Es handelt sich ja um nichts weiter, als daß wir einfach durchziehen möchten! ");
INSERT INTO deutkw_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Er aber erwiderte: Du darfst nicht durchziehen! Und Edom trat ihm entgegen mit zahlreichem Kriegsvolk und mit gewaffneter Hand. ");
INSERT INTO deutkw_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Da sich Edom somit weigerte, Israel den Durchzug durch sein Gebiet zu gestatten, so ließ ihn Israel und bog seitwärts ab. ");
INSERT INTO deutkw_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Sodann brachen sie auf von Kades, und die ganze Gemeinde der Israeliten gelangte zum Berge Hor. ");
INSERT INTO deutkw_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Jahwe aber sprach zu Mose und Aaron am Berge Hor, an der Grenze des Landes Edom, also: ");
INSERT INTO deutkw_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Aaron soll nunmehr zu seinen Stammesgenossen versammelt werden; denn er soll das Land, das ich den Israeliten verlieben habe, nicht betreten, weil ihr am Haderwasser meinem Befehl ungehorsam gewesen seid. ");
INSERT INTO deutkw_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Nimm Aaron und seinen Sohn Eleasar und führe sie hinauf auf den Berg Hor. ");
INSERT INTO deutkw_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Ziehe Aaron seine Kleider aus und bekleide damit seinen Sohn Eleasar; Aaron aber soll zu seinen Stammesgenossen versammelt werden und daselbst sterben. ");
INSERT INTO deutkw_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Und Mose that, wie ihm Jahwe befohlen hatte, und sie stiegen vor den Augen der ganzen Gemeinde hinauf auf den Berg Hor. ");
INSERT INTO deutkw_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Und Mose zog Aaron seine Kleider aus und bekleidete damit seinen Sohn Eleasar. Aaron aber starb dort auf dem Gipfel des Berges; sodann stiegen Mose und Eleasar vom Berge herab. ");
INSERT INTO deutkw_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Als aber die ganze Gemeinde sah, daß Aaron verschieden war, da beweinte ganz Israel Aaron dreißig Tage lang. ");
INSERT INTO deutkw_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Als aber der Kanaaniter, der König von Arad, der im Südlande wohnte, vernahm, daß die Israeliten auf dem Wege von Atharim heranzögen, führte er Krieg mit den Israeliten und nahm einige von ihnen gefangen. ");
INSERT INTO deutkw_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Da legten die Israeliten Jahwe ein Gelübde ab des Inhalts: Wenn du diese Leute in unsere Hand fallen lässest, wollen wir ihre Städte dem Banne preisgeben. ");
INSERT INTO deutkw_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Da erhörte Jahwe die Bitte der Israeliten und ließ die Kanaaniter in ihre Hand fallen; da gaben sie sie und ihre Städte dem Banne preis; die Stätte aber hieß fortan Horma. ");
INSERT INTO deutkw_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Da zogen sie vom Berge Hor weiter auf der Straße zum Schilfmeer, um das Land Edom zu umgehen. Unterwegs aber wurde das Volk mißmutig. ");
INSERT INTO deutkw_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Und das Volk führte freche Reden wider Gott, und wider Mose: Habt ihr uns dazu aus Ägypten weggeführt, damit wir in der Steppe umkommen? Es giebt ja weder Brot noch Wasser, und die elende Nahrung widert uns an! ");
INSERT INTO deutkw_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Da entsandte Jahwe wider das Volk die Brandschlangen; die bissen die Leute, so daß viele Leute von den Israeliten starben. ");
INSERT INTO deutkw_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Da kamen die Leute zu Mose und sprachen: Wir haben gesündigt, indem wir wider Jahwe und wider dich redeten; lege doch Fürbitte bei Jahwe ein, daß er uns von den Schlangen befreie! Da legte Mose Fürbitte für das Volk ein. ");
INSERT INTO deutkw_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Jahwe aber befahl Mose: Fertige eine Brandschlange an und befestige sie an einer Stange; wenn dann jemand gebissen wird und sie anschaut, so wird er am Leben bleiben. ");
INSERT INTO deutkw_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Da verfertigte Mose eine eherne Schlange und befestigte sie an einer Stange; wenn dann die Schlangen jemanden bissen, und er die eherne SchIange anschaute, blieb er am Leben. ");
INSERT INTO deutkw_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Hierauf zogen die Israeliten weiter und lagerten sich in Oboth. ");
INSERT INTO deutkw_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Dann zogen sie von Oboth weiter und lagerten sich in Ijje Ha-abarim, in der Steppe, welche östlich vor Moab liegt. ");
INSERT INTO deutkw_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Von dort zogen sie weiter und lagerten sich im Bachthale des Sared. ");
INSERT INTO deutkw_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Von dort zogen sie weiter und lagerten sich jenseits des Arnon, der in der Steppe fließt, der im Gebiete der Amoriter entspringt; denn der Arnon bildet die Grenze Moabs zwischen den Moabitern und den Amoritern. ");
INSERT INTO deutkw_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Daher heißt es im Buche der Kriege Jahwes: Waheb in Supha und die Bachthäler, den Arnon, ");
INSERT INTO deutkw_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","und den Abhang der Bachthäler, der sich bis zur Lage von Ar erstreckt und sich an die Grenze Moabs lehnt. ");
INSERT INTO deutkw_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Und von dort nach Beer; das ist der Brunnen, den Jahwe meinte, als er Mose befahl: Versammle das Volk, damit ich ihnen Wasser gebe! ");
INSERT INTO deutkw_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Damals sangen die Israeliten folgendes Lied: Quelle auf, o Brunnen! Singt ihm zu! ");
INSERT INTO deutkw_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Brunnen, den Fürsten gruben, den die Edelsten des Volkes bohrten mit dem Scepter, mit ihren Stäben! Und aus der Steppe nach Mattana; ");
INSERT INTO deutkw_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","von Mattana nach Nahaliel und von Nahaliel nach Bamoth; ");
INSERT INTO deutkw_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","von Bamoth nach dem Thale, das im Gefilde der Moabiter liegt, zum Gipfel des Pisga, der auf die Wüste herabschaut. ");
INSERT INTO deutkw_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Israel aber sandte Boten an Sihon, den König der Amoriter, und ließ ihm sagen: ");
INSERT INTO deutkw_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","Laß mich durch dein Land ziehen; wir wollen weder auf einen Acker noch auf einen Weinberg abbiegen, noch Wasser aus den Brunnen trinken, sondern auf der Heerstraße ziehen, bis wir dein Gebiet durchzogen haben. ");
INSERT INTO deutkw_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Sihon aber gestattete den Israeliten den Durchzug durch sein Gebiet nicht, vielmehr zog Sihon alle seine Mannschaften zusammen und rückte aus den Israeliten entgegen in die Steppe, und als er bis Jahaz gelangt war, lieferte er den Israeliten eine Schlacht. ");
INSERT INTO deutkw_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Die Israeliten aber besiegten ihn in blutigem Kampf und eroberten sein Land vom Arnon bis an den Jabok, bis zum Gebiete der Ammoniter; denn die Grenze der Ammoniter war fest. ");
INSERT INTO deutkw_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Und die Israeliten nahmen alle Städte, die dort lagen, ein, und die Israeliten setzten sich fest in allen Städten der Amoriter, in Hesbon und allen dazugehörigen Ortschaften. ");
INSERT INTO deutkw_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Denn Hesbon war die Stadt des Amoriterkönigs Sihon; dieser hatte nämlich mit dem früheren Könige der Moabiter Krieg geführt und ihm sein ganzes Land bis an den Arnon entrissen. ");
INSERT INTO deutkw_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Daher singen die Spruchdichter: Kommt nach Hesbon! Aufgebaut und befestigt werde die Stadt Sihons! ");
INSERT INTO deutkw_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Ja ein Feuer ging aus von Hesbon, eine Flamme von der Stadt Sihons; die verzehrte Ar Moab, die Bewohner der Anhöhen des Arnon. ");
INSERT INTO deutkw_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Weh, dir, Moab! Du bist verloren, Volk des Kamos! Er ließ seine Söhne Flüchtlinge werden, seine Töchter Gefangene Sihons, des Königs der Amoriter. ");
INSERT INTO deutkw_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Wir beschossen sie, verloren war Hesbon bis Dibon; wir verwüsteten bis Nophah, mit Feuer bis Medeba. ");
INSERT INTO deutkw_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Und die Israeliten setzten sich im Lande der Amoriter fest. ");
INSERT INTO deutkw_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Sodann schickte Mose Kundschafter gegen Jaezer hin, und sie nahmen es nebst den dazu gehörigen Dörfern ein. So vertrieb er die Amoriter, die daselbst wohnten. ");
INSERT INTO deutkw_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Hierauf wandten sie um und zogen in der Richtung nach Basan. Da rückte Og, der König von Basan, mit seiner ganzen Mannschaft ihnen entgegen, um ihnen bei Edrei eine Schlacht zu liefern. ");
INSERT INTO deutkw_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Jahwe aber sprach zu Mose: Habe keine Angst vor ihm, denn ich gebe ihn nebst seinem ganzen Volk und seinem Land in deine Hand, und du magst mit ihm verfahren, wie du mit dem Amoriterkönige Sihon, der in Hesbon wohnte, verfahren bist. ");
INSERT INTO deutkw_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Da schlugen sie ihn nebst seinen Söhnen und seiner ganzen Mannschaft, so daß sie ihm keinen übrig ließen, der hätte fliehen können, und sie nahmen sein Land in Besitz. ");
INSERT INTO deutkw_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Hierauf zogen die Israeliten weiter und lagerten sich in den Steppen Moabs, jenseits des Jordan gegenüber Jericho. ");
INSERT INTO deutkw_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Balak, der Sohn Zipors, aber sah alles, was die Israeliten den Amoritern zufügten. ");
INSERT INTO deutkw_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Da gerieten die Moabiter in große Furcht vor dem Volke; denn dasselbe war zahlreich, und den Moabitern wurde angst und bange vor den Israeliten. ");
INSERT INTO deutkw_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Da sprachen die Moabiter zu den Vornehmsten der Midianiter: Wie es jetzt steht, wird dieser Haufe alles, was sich in unserer Umgebung findet, aufessen, wie die Stiere alles Grüne auf den Feldern abfressen. Balak, der Sohn Zipors, war aber zu jener Zeit König über die Moabiter. ");
INSERT INTO deutkw_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Da sandte er Boten an Bileam, den Sohn Beors, nach Pethor, das am Euphrat liegt, nach dem Lande seiner Volksgenossen, um ihn herbeizurufen, und ließ ihm sagen: Da ist ein Volk aus Ägypten ausgezogen, das hat das Land weit und breit überflutet und nun lagert es mir gegenüber. ");
INSERT INTO deutkw_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","So komm nun und verfluche mir dieses Volk, denn es ist mir zu mächtig; vielleicht kann ich ihm dann eine Niederlage beibringen und es aus dem Lande vertreiben. Ich weiß ja: wen du segnest, der bleibt gesegnet, und wem du fluchst, der bleibt verflucht! ");
INSERT INTO deutkw_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Da brachen die Vornehmsten der Moabiter und die Vornehmsten der Midianiter auf, indem sie Wahrsagerlohn mitnahmen, gelangten zu Bileam und richteten ihm den Auftrag Balaks aus. ");
INSERT INTO deutkw_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Er aber antwortete ihnen: Bleibt heute Nacht hier, so will ich euch Bescheid geben, je nachdem Jahwe mich anweisen wird. Da blieben die Häuptlinge der Moabiter bei Bileam. ");
INSERT INTO deutkw_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Gott aber kam zu Bileam und fragte ihn: Wer sind die Männer, die da bei dir sind? ");
INSERT INTO deutkw_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Bileam antwortete Gott: Balak, der Sohn Zipors, der König von Moab, hat mir Botschaft gesandt: ");
INSERT INTO deutkw_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Da ist ein Volk, das aus Ägypten ausgezogen ist und das ganze Land weit und breit überflutet hat; so komm nun und verwünsche mir dasselbe; vielleicht bin ich dann imstande, es zu bekämpfen und es zu vertreiben. ");
INSERT INTO deutkw_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Gott aber sprach zu Bileam: Du darfst nicht mit ihnen gehen, du darfst dieses Volk nicht verfluchen, denn es ist ein gesegnetes! ");
INSERT INTO deutkw_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Frühmorgens nun gab Bileam den Häuptlingen Balaks den Bescheid: Zieht nur in euer Land, denn Jahwe, will es mir nicht gestatten, mit euch zu ziehn. ");
INSERT INTO deutkw_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Da brachen die Häuptlinge der Moabiter auf, gelangten wieder zu Balak und berichteten: Bileam hat sich geweigert, mit uns zu ziehn! ");
INSERT INTO deutkw_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Hierauf entsandte Balak nochmals Boten und zwar noch mehr und angesehenere Häuptlinge, als jene. ");
INSERT INTO deutkw_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Als diese zu Bileam gelangt waren, sprachen sie zu ihm: So läßt dir Balak, der Sohn Zipors, sagen: Schlage es nicht ab, zu mir zu kommen! ");
INSERT INTO deutkw_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Ich will dir's überaus reichlich lohnen und will alles thun, was du mich heißest; so komm nun und verwünsche mir dieses Volk! ");
INSERT INTO deutkw_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Bileam aber entgegnete den Untergebenen Balaks: Wenn mir Balak Silber und Gold schenkte, so viel nur in sein Haus geht, so könnte ich doch dem Befehle Jahwes, meines Gottes, nicht zuwiderhandeln, möchte es nun eine geringfügige oder eine wichtige Sache betreffen. ");
INSERT INTO deutkw_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Bleibt also nun auch ihr heute Nacht hier, damit ich erst in Erfahrung bringe, was Jahwe mir diesmal sagt. ");
INSERT INTO deutkw_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Während der Nacht aber kam Gott zu Bileam und sprach zu ihm: Wenn diese Männer gekommen sind, um dich zu berufen, so mache dich auf und geh mit ihnen; nur darfst du nichts anderes thun, als was ich dich heißen werde. ");
INSERT INTO deutkw_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Am andern Morgen früh zäumte Bileam seine Eselin auf und zog mit den Häuptlingen der Moabiter von dannen. ");
INSERT INTO deutkw_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Aber Gott geriet in Zorn darüber, daß er sich auf den Weg gemacht hatte; und der Engel Jahwes trat ihm auf dem Wege feindselig entgegen, während er auf seiner Eselin ritt und seine beiden Diener bei sich hatte. ");
INSERT INTO deutkw_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Als nun die Eselin sah, wie der Engel Jahwes mit dem gezückten Schwert in der Hand auf dem Wege dastand, da bog die Eselin vom Weg ab und ging auf dem Felde; Bileam aber schlug die Eselin, um sie wieder auf den Weg zu bringen. ");
INSERT INTO deutkw_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Da trat der Engel Jahwes in den Hohlweg zwischen den Weinbergen, wo zu beiden Seiten eine Mauer war. ");
INSERT INTO deutkw_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Als nun die Eselin den Engel Jahwes erblickte, drängte sie sich an die Mauerwand und preßte so den Fuß Bileams an die Mauerwand; da schlug er sie abermals. ");
INSERT INTO deutkw_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Der Engel Jahwes aber ging nochmals voraus und trat an eine enge Stelle, wo keine Möglichkeit war, nach rechts oder nach links auszuweichen. ");
INSERT INTO deutkw_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Als nun die Eselin den Engel Jahwes erblickte, legte sie sich unter Bileam auf den Boden. Da geriet Bileam in Zorn und schlug die Eselin mit dem Stocke. ");
INSERT INTO deutkw_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Jahwe aber verlieh der Eselin Sprache; da sagte sie zu Bileam: Was habe ich dir gethan, daß du mich nun schon dreimal geschlagen hast? ");
INSERT INTO deutkw_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Bileam erwiderte der Eselin: Weil du mich zum Narren gehabt hast! Hätte ich nur ein Schwert in der Hand, so hätte ich dich längst umgebracht! ");
INSERT INTO deutkw_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Da sprach die Eselin zu Bileam: Bin ich denn nicht deine Eselin, auf der du geritten bist von jeher bis auf den heutigen Tag? Hatte ich jemals die Gewohnheit, so gegen dich zu handeln? Er erwiderte: Nein! ");
INSERT INTO deutkw_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Da öffnete Jahwe Bileam die Augen, daß er den Engel Jahwes erblickte, wie er mit dem gezückten Schwert in der Hand auf dem Wege dastand. Da verneigte er sich und warf sich zu Boden. ");
INSERT INTO deutkw_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Der Engel Jahwes aber sprach zu ihm: Warum hast du deine Eselin nun schon dreimal geschlagen? Ich bin es ja, der dir entgegengetreten ist, denn der Weg ist abschüssig vor mir. ");
INSERT INTO deutkw_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Die Eselin aber sah mich und wich mir daher nun schon dreimal aus. Wäre sie mir nicht ausgewichen, so hätte ich dich schon längst umgebracht; sie aber hätte ich am Leben gelassen. ");
INSERT INTO deutkw_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Da erwiderte Bileam dem Engel Jahwes: Ich habe gefehlt; ich wußte ja nicht, daß du mir auf dem Weg entgegengetreten warst. Wenn es dir also mißfällig ist, so will ich wieder umkehren! ");
INSERT INTO deutkw_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Der Engel Jahwes aber antwortete Bileam: Zieh nur hin mit den Männern; aber bloß die Worte, die ich dir eingeben werde, darfst du reden! Da zog Bileam mit den Häuptlingen Balaks weiter. ");
INSERT INTO deutkw_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Als nun Balak vernahm, daß Bileam unterwegs sei, zog er ihm entgegen bis nach Ir Moab, das an der Arnongrenze liegt, an der äußersten Grenze. ");
INSERT INTO deutkw_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Da sprach Balak zu Bileam: habe ich denn nicht wiederholt Boten an dich geschickt, um dich rufen zu lassen? Warum bist du nicht zu mir gekommen? Bin ich denn etwa nicht imstande, dir es reichlich zu lohnen? ");
INSERT INTO deutkw_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Bileam antwortete Balak: Wohl bin ich zu dir gekommen. Aber werde ich wirklich irgend etwas reden können? Die Worte, die mir Gott in den Mund legt, die werde ich reden! ");
INSERT INTO deutkw_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Hierauf ging Bileam mit Balak, und sie gelangten nach Kirjath Chuzoth. ");
INSERT INTO deutkw_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balak aber ließ Rinder und Schafe opfern und sandte Stücke davon an Bileam und die Häuptlinge, die bei ihm waren. ");
INSERT INTO deutkw_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Am andern Morgen früh aber nahm Balak Bileam mit und führte ihn hinauf nach Bamoth Baal; von dort konnte er einen Teil des Volkes sehen. ");
INSERT INTO deutkw_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Da sprach Bileam zu Balak: Laß hier sieben Altäre für mich errichten und sieben junge Stiere und sieben Widder hier für mich bereit stellen. ");
INSERT INTO deutkw_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balak that, wie Bileam verlangt hatte, und Balak und Bileam brachten auf jedem Altar einen Farren und einen Widder dar. ");
INSERT INTO deutkw_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Hierauf sprach Bileam zu Balak: Bleibe hier bei deinem Brandopfer; ich will hingehen, vielleicht wird sich Jahwe mir irgendwie offenbaren. Was er mich auch erschauen lassen wird, will ich dir dann mitteilen. Da ging er auf einen kahlen Hügel. ");
INSERT INTO deutkw_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Da offenbarte sich Gott Bileam, und er sprach zu ihm: die sieben Altäre habe ich zugerüstet und auf jedem einen Farren und einen Widder dargebracht. ");
INSERT INTO deutkw_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Da legte Jahwe dem Bileam Worte in den Mund und sprach zu ihm: Kehre zu Balak zurück und sprich also! ");
INSERT INTO deutkw_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Da kehrte er zu ihm zurück; er aber stand noch da bei seinem Brandopfer mit allen Häuptlingen der Moabiter. ");
INSERT INTO deutkw_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Da trug er seinen Spruch vor und sprach: Aus Aram läßt mich Balak holen, aus den Bergen des Ostlands der Moabiter König. Geh, verfluche mir Jakob, ja, geh, verwünsche Israel! ");
INSERT INTO deutkw_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Wie soll ich verfluchen, den Gott nicht verflucht, und wie soll ich verwünschen, den Jahwe nicht verwünscht? ");
INSERT INTO deutkw_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Denn von Felsengipfeln sehe ich ihn und von Anhöhen erblicke ich ihn. Es ist ein Volk, das abgesondert wohnt und sich nicht rechnet unter die Völker. ");
INSERT INTO deutkw_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Wer kann zählen die Erdkrumen Jakobs und wer berechnen die Myriaden Israels? Möchte ich einst sterben, wie Gerechte sterben, und möchte mein Ende sein, wie das seinige! ");
INSERT INTO deutkw_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Da sprach Balak zu Bileam: Was hast du mir da gethan! Um meine Feinde zu verwünschen, habe ich dich kommen lassen; du aber hast nur gesegnet! ");
INSERT INTO deutkw_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Er aber erwiderte: Muß ich nicht genau so reden, wie Jahwe es mir in den Mund legt? ");
INSERT INTO deutkw_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Balak aber sprach zu ihm: komm mit mir an eine andere Stelle, von wo aus du es sehen kannst, - aber nur einen Teil von ihm kannst du sehen, das Ganze kannst du nicht sehen - und verwünsche mir es dort! ");
INSERT INTO deutkw_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Hierauf führte er ihn auf das Gefilde Zophim nach dem Gipfel des Pisga, errichtete sieben Altäre und brachte auf jedem derselben einen Farren und einen Widder dar. ");
INSERT INTO deutkw_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Da sprach er zu Balak: warte hier bei deinem Brandopfer; ich aber will dort eine Offenbarung suchen. ");
INSERT INTO deutkw_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Da offenbarte sich Jahwe Bileam, legte ihm Worte in den Mund und befahl ihm: Kehre zu Balak zurück und sprich also! ");
INSERT INTO deutkw_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Da kam er zu ihm; er aber stand noch da bei seinem Brandopfer mit den Häuptlingen der Moabiter. Da fragte ihn Balak: Was hat Jahwe geredet? ");
INSERT INTO deutkw_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Da trug er seinen Spruch vor und sprach: Wohlan, Balak, horch auf! Höre mir zu, Sohn Zipors! ");
INSERT INTO deutkw_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Gott ist nicht ein Mensch, daß er sein Wort bräche, noch ein Menschenkind, dass ihn etwas reute. SoIlte er etwas ankündigen und nicht ausführen? Sollte er etwas verheißen und nicht ins Werk setzen? ");
INSERT INTO deutkw_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Zu segnen wurde mir aufgetragen: so will ich denn segnen und nehme es nicht zurück! ");
INSERT INTO deutkw_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Nicht erblickt man Unheil in Jakob, noch findet man Leid in Israel. Jahwe, sein Gott, ist mit ihm, und Königsjubel erschallt bei ihm. ");
INSERT INTO deutkw_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Gott führte sie auf Ägypten hinweg, Hörner wie die eines Wildochsen hat es. ");
INSERT INTO deutkw_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Denn keine Beschwörung haftet an Jakob, und keine Bezauberung an Israel. Jetzt kann man von Jakob und Israel nur rufen: wie Großes hat Gott gethan! ");
INSERT INTO deutkw_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Ja, wie eine Löwin macht sich das Volk auf, und wie ein Löwe erhebt es sich. Nicht legt es sich nieder, bevor es Beute verzehrt und Blut Erschlagener getrunken hat. ");
INSERT INTO deutkw_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Da sprach Balak zu Bileam: Du sollst es weder verwünschen, noch segnen. ");
INSERT INTO deutkw_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Bileam aber antwortete Balak: Habe ich es dir nicht gesagt: Alles, was Jahwe verlangt, werde ich thun? ");
INSERT INTO deutkw_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Hierauf sprach Balak zu Bileam: Komm, ich will dich an eine andere Stelle führen; vielleicht willigt Gott ein, daß du mir es dort verwünschest! ");
INSERT INTO deutkw_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Da führte Balak Bileam auf den Gipfel des Peor, der auf die Wüste herabschaut. ");
INSERT INTO deutkw_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Bileam aber sprach zu Balak: Laß hier sieben Altäre für mich errichten und sieben Farren und sieben Widder hier für mich bereit stellen! ");
INSERT INTO deutkw_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balak that, wie Bileam gewünscht hatte, und er brachte auf jedem Altar einen Farren und einen Widder dar. ");
INSERT INTO deutkw_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Als nun Bileam merkte, daß es Jahwe gefiel, Israel zu segnen, ging er nicht, wie die vorigen Male, auf Wahrzeichen aus, sondern wandte sich gegen die Steppe. ");
INSERT INTO deutkw_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Als er nun hinschaute und Israel erblickte, wie es nach seinen Stämmen lagerte, da kam der Geist Gottes über ihn. ");
INSERT INTO deutkw_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Da trug er seinen Spruch vor und sprach: So spricht Bileam, der Sohn Beors; so spricht der Mann, dessen Auge verschlossen ist. ");
INSERT INTO deutkw_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","So spricht der, der göttliche Reden vernimmt, Gesichte des Allmächtigen schaut, hingesunken und enthüllten Auges. ");
INSERT INTO deutkw_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Wie herrlich sind deine Zelte, Jakob, deine Wohnsitze, Israel! ");
INSERT INTO deutkw_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Wie Bachthäler, die sich weithin erstrecken, wie Baumgärten an einem Strom; wie Cardamomen, die Jahwe gepflanzt hat, wie Cedern am Wasser! ");
INSERT INTO deutkw_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Es rinnt Wasser aus seinen Eimern, und seine Saat hat reichliches Wasser. Mächtiger als Agag ist sein König, und seine Herrschaft erhaben. ");
INSERT INTO deutkw_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Gott, der es aus Ägypten hinwegführte, ist für es wie die Hörner eines Wildochsen; Völker, die ihm feind sind, zehrt es aus und zermalmt ihre Knochen und es zerschmettert seine Dränger. ");
INSERT INTO deutkw_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Es hat sich gestreckt, gelagert wie ein Löwe und wie eine Löwin; wer darf es aufreizen? Wer irgend dich segnet, soll gesegnet sein, wer dir aber flucht, der sei verflucht! ");
INSERT INTO deutkw_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Da wurde Balak sehr zornig über Bileam und schlug unwillig die Hände zusammen. Da sprach Balak zu Bileam: Um meine Feinde zu verfluchen, habe ich dich berufen; du aber hast nur gesegnet, nun bereits dreimal! ");
INSERT INTO deutkw_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","So begieb dich nunmehr nur in deine Heimat. Ich gedachte dir's reichlich zu lohnen; aber Jahwe hat dich um den Lohn gebracht. ");
INSERT INTO deutkw_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Bileam antwortete Balak: Habe ich nicht bereits zu deinen Boten, die du an mich abgesandt hast, gesagt: ");
INSERT INTO deutkw_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Wenn mir Balak Silber und Gold schenkte, so viel nur in sein Haus geht, so könnte ich doch dem Befehle Jahwes nicht zuwiderhandeln und irgend etwas aus eigenem Willen thun, sondern muß reden, was Jahwe mir eingiebt. ");
INSERT INTO deutkw_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","So will ich denn nun wieder zu meinen Stammesgenossen ziehen; aber wohlan, ich will dir eröffnen, was dieses Volk deinem Volk in der Folgezeit anthun wird. ");
INSERT INTO deutkw_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Da trug er seinen Spruch vor und sprach: So spricht Bileam, der Sohn Beors, und spricht der Mann, dessen Auge verschlossen ist. ");
INSERT INTO deutkw_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","So spricht der, welcher göttliche Reden vernimmt, der um die Erkenntnis des Höchsten weiß, der Gesichte des Allmächtigen schaut, hingesunken und enthüllten Auges. ");
INSERT INTO deutkw_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Ich sehe ihn, doch nicht schon jetzt, ich erspähe ihn, aber noch nicht nah. Es geht auf ein Stern aus Jakob, und ein Scepter erhebt sich aus Israel; das zerschlägt die Schläfen der Moabiter und den Scheitel aller Söhne Seths. ");
INSERT INTO deutkw_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Und Edom wird Unterthanenland, und Seir, sein Feind, wird Unterthanenland; Israel aber verrichtet große Thaten. ");
INSERT INTO deutkw_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Man wird herrschen von Jakob aus und Entronnene hinwegtilgen aus den Städten. ");
INSERT INTO deutkw_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Als er aber die Amalekiter erblickte, trug er folgenden Spruch vor: Das vorzüglichste der Völker ist Amalek, aber schließlich neigt es sich dem Untergange zu! ");
INSERT INTO deutkw_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Und als er auf die Keniter blickte, trug er folgenden Spruch vor: Fest sind deine Wohnsitze, und auf dem Felsen ist dein Nest gebaut. ");
INSERT INTO deutkw_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Und doch ist Kain dem Untergang verfallen: Wie lange noch, so führt dich Assur in Gefangenschaft! ");
INSERT INTO deutkw_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Dann trug er folgenden Spruch vor: Weh, wer wird leben bleiben, wenn Gott Solches verhängt! ");
INSERT INTO deutkw_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Und Schiffe von der Seite der Kittiter her, die demütigen Assur und demütigen das Land jenseits, und auch dieses verfällt dem Untergang! ");
INSERT INTO deutkw_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Hierauf machte sich Bileam auf, um wieder in seine Heimat zurückzukehren, und auch Balak zog seines Wegs. ");
INSERT INTO deutkw_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Während nun Israel in Sittim verweilte, hob das Volk an, mit den Moabiterinnen zu buhlen. ");
INSERT INTO deutkw_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Diese luden das Volk zu den Opfermahlen ihrer Götter; da aß das Volk und warf sich vor ihren Göttern nieder. ");
INSERT INTO deutkw_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Und Israel hängte sich an den Baal Peor; da wurde Jahwe zornig über Israel. ");
INSERT INTO deutkw_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Und Jahwe sprach zu Mose: Versammle alle Häupter des Volks und setze die Schuldigen Jahwe im Angesichte der Sonne aus, damit der heftige Zorn Jahwes von Israel ablasse! ");
INSERT INTO deutkw_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Da gebot Mose den Befehlshabern des Volks: Ein jeglicher töte die seiner Leute, die sich an den Baal Peor gehängt haben! ");
INSERT INTO deutkw_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Es kam aber einer von den Israeliten herein und brachte eine Midianitin her zu seinen Volksgenossen, vor den Augen Moses und der ganzen Gemeinde der Israeliten, während sie vor der Thüre des Offenbarungszeltes jammerten. ");
INSERT INTO deutkw_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Als das Pinehas, der Sohn Eleasars, des Sohnes Aarons, des Priesters, gewahrte, da trat er aus der Gemeinde hervor und ergriff einen Speer. ");
INSERT INTO deutkw_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","Sodann ging er dem israelitischen Manne nach in das innere Gemach und durchstach beide, den israelitischen Mann und das Weib, durch ihren Bauch. Da ward der Plage unter den Israeliten Einhalt gethan. ");
INSERT INTO deutkw_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Es belief sich aber die Zahl derer, die durch die Plage umgekommen waren, auf 24000. ");
INSERT INTO deutkw_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","Pinehas, der Sohn Eleasars, des Sohnes Aarons, des Priesters, hat gemacht, daß mein Grimm von den Israeliten abließ, indem er den Eifer unter ihnen bewies, den ich zu beweisen pflege, und so habe ich die Israeliten nicht aufgerieben durch mein Eifern. ");
INSERT INTO deutkw_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Darum verkündige: Ich sichere ihm zu, daß ihm Heil von mir widerfahren soll. ");
INSERT INTO deutkw_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Und zwar soll ihm, sowie seinen Nachkommen, für alle Zeiten Priesterrecht zugesichert sein, zum Lohne dafür, daß er für seinen Gott geeifert und den Israeliten Sühne geschafft hat! ");
INSERT INTO deutkw_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Der getötete Israelit aber, der samt der Midianitin getötet ward, hieß Simri, der Sohn Salus, des Vorstehers eines Geschlechts der Simeoniten. ");
INSERT INTO deutkw_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Und das getötete midianitische Weib hieß Kosbi, die Tochter Surs; der war das Haupt einer Sippe, eines Geschlechts, unter den Midianitern. ");
INSERT INTO deutkw_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","Befehdet die Midianiter und bringt ihnen eine Niederlage bei. ");
INSERT INTO deutkw_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","Denn sie haben euch befehdet durch ihre Ränke, die sie gegen euch verübt haben in betreff des Peor und in betreff ihrer Landsmännin Kosbi, der Tochter des midianitischen Fürsten, die am Tage der wegen des Peor verhängten Plage getötet ward. ");
INSERT INTO deutkw_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Nach der Plage aber sprach Jahwe zu Mose und zu Eleasar, dem Sohne Aarons, des Priesters: ");
INSERT INTO deutkw_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","Nehmt die Gesamtzahl der ganzen Gemeinde der Israeliten auf, von zwanzig Jahren an und darüber, Geschlecht für Geschlecht, alle, die heerespflichtig sind in Israel. ");
INSERT INTO deutkw_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Und Mose und Eleasar, der Priester, musterten sie in den Steppen Moabs, am Jordan gegenüber Jericho, ");
INSERT INTO deutkw_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","von zwanzig Jahren an und darüber, wie Jahwe Mose befohlen hatte. Es waren aber die Israeliten, die aus Ägypten ausgezogen waren: ");
INSERT INTO deutkw_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Ruben, der Erstgeborne Israels. Die Söhne Rubens waren: Hanoch, von dem das Geschlecht der Hanochiter kommt; von Pallu das Geschlecht der Palluiter; ");
INSERT INTO deutkw_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","von Hezron das Geschlecht der Hezroniter, von Karmi das Geschlecht der Karmiter. ");
INSERT INTO deutkw_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Das sind die Geschlechter der Rubeniten. Es belief sich aber die Zahl der aus ihnen Gemusterten auf 43730. ");
INSERT INTO deutkw_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Und die Söhne PaIlus waren: Eliab; ");
INSERT INTO deutkw_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","und die Söhne Eliabs: Remuel, Dathan und Abiram. Das sind jene Ratsherren Dathan und Abiram, die unter der Rotte Korahs mit Mose und Aaron haderten, als diese mit Jahwe haderte, ");
INSERT INTO deutkw_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","worauf die Erde ihren Mund auftat und sie und Korah verschlang, während die Rotte umkam, indem das Feuer die 250 Mann verzehrte, so daß sie zu einem Warnungszeichen wurden; ");
INSERT INTO deutkw_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","die Söhne Korahs aber kamen nicht mit um. ");
INSERT INTO deutkw_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Die Geschlechter der Söhne Simeons waren diese: von Remuel das Geschlecht der Remueliter; von Jamin das Geschlecht der Jaminiter, von Jachin das Geschlecht der Jachiniter, ");
INSERT INTO deutkw_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","von Serah das Geschlecht der Serahiter, von Saul das Geschlecht der Sauliter. ");
INSERT INTO deutkw_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Das sind die Geschlechter der Simeoniten: 22200. ");
INSERT INTO deutkw_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Die Geschlechter der Söhne Gads waren diese: von Zephon das Geschlecht der Zephoniter, von Haggi das Geschlecht der Haggiter, von Suni das Geschlecht der Suniter, ");
INSERT INTO deutkw_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","von Osni das Geschlecht der Osniter, von Eri das Geschlecht der Eriter, ");
INSERT INTO deutkw_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","von Arod das Geschlecht der Aroditer, von Areli das Geschlecht der Areliter. ");
INSERT INTO deutkw_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Das sind die Geschlechter der Söhne Gads, so viele ihrer gemustert wurden: 40500. ");
INSERT INTO deutkw_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Die Söhne Judas waren Er und Onan; es starben aber Er und Onan im Lande Kanaan. ");
INSERT INTO deutkw_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Es waren aber die Geschlechter der Söhne Judas: von Sela das Geschlecht der Selaniter, von Perez das Geschlecht der Pereziter, von Serah das Geschlecht der Serahiter. ");
INSERT INTO deutkw_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Und die Söhne Perez waren: von Hezron das Geschlecht der Hezroniter, von Hamul das Geschlecht der Hamuliter. ");
INSERT INTO deutkw_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Das sind die Geschlechter Judas, so viele ihrer gemustert wurden: 76500. ");
INSERT INTO deutkw_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Die Geschlechter der Söhne Issachars waren diese: von Tola das Geschlecht der Tolaiter, von Puwwa das Geschlecht der Puniter, ");
INSERT INTO deutkw_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","von Jasub das Geschlecht der Jasubiter, von Simron das Geschlecht der Simroniter. ");
INSERT INTO deutkw_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Das sind die Geschlechter Issachars, so viele ihrer gemustert wurden: 64300. ");
INSERT INTO deutkw_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Die Geschlechter der Söhne Sebulons waren diese: von Sered das Geschlecht der Serediter, von Elon das Geschlecht der Eloniter, von Jalleel das Geschlecht der Jalleeliter. ");
INSERT INTO deutkw_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Das sind die Geschlechter der Sebuloniten, so viele ihrer gemustert wurden: 60500. ");
INSERT INTO deutkw_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Die Geschlechter der Söhne Josephs waren Manasse und Ephraim. ");
INSERT INTO deutkw_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Die Söhne Manasses: von Machir das Geschlecht der Machiriter. Machir aber erzeugte Gilead; von Gilead kommt das Geschlecht der Gileaditer. ");
INSERT INTO deutkw_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Dies sind die Söhne Gileads: Jeser, von dem das Geschlecht der Jesriter kommt; von Helek das Geschlecht der Helekiter, ");
INSERT INTO deutkw_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","von Asriel das Geschlecht der Asrieliter, von Sichem das Geschlecht der Sichemiter, ");
INSERT INTO deutkw_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","von Semida das Geschlecht der Semidaiter, und von Hepher das Geschlecht der Hepheriter. ");
INSERT INTO deutkw_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Zelophad aber, der Sohn Hephers, hatte keine Söhne, sondern nur Töchter, und die Töchter Zelophhads hießen Mahla, Noa, Hogla, Milka und Thirza. ");
INSERT INTO deutkw_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Das sind die Geschlechter Manasses, so viele ihrer gemustert wurden: 52700. ");
INSERT INTO deutkw_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Dies sind die Geschlechter der Söhne Ephraims: von Suthelah das Geschlecht der Suthelahiter, von Becher das Geschlecht der Becheriter, von Tahan das Geschlecht der Tahaniter. ");
INSERT INTO deutkw_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Und dies waren die Söhne Suthelahs: von Eran das Geschlecht der Eraniter. ");
INSERT INTO deutkw_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Das sind die Geschlechter der Söhne Ephraims, so viele ihrer gemustert wurden, 32500. Das sind die Geschlechter der Söhne Josephs. ");
INSERT INTO deutkw_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Die Geschlechter der Söhne Benjamins waren diese: von Bela das Geschlecht der BeIaiter, von Asbel das Geschlecht der Asbeliter, von Ahiram das Geschlecht der Ahiramiter, ");
INSERT INTO deutkw_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","von Supham das Geschlecht der Suphamiter, von Hupham das Geschlecht der Huphamiter. ");
INSERT INTO deutkw_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Die Söhne BeIas aber waren Ard und Naaman; von Ard kommt das Geschlecht der Arditer, von Naaman das Geschlecht der Naamaniter. ");
INSERT INTO deutkw_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Dies sind die Geschlechter der Söhne Benjamins, so viele ihrer gemustert wurden: 45600. ");
INSERT INTO deutkw_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Dies sind die Geschlechter der Söhne Dans: von Suham das Geschlecht der Suhamiter; das sind die Geschlechter Dans nach ihren Geschlechtern. ");
INSERT INTO deutkw_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Alle Geschlechter der Suhamiter, so viele ihrer gemustert wurden, beliefen sich auf 64400. ");
INSERT INTO deutkw_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Die Geschlechter der Söhne Assers waren diese: von Jimna das Geschlecht der Jimniter, von Jiswi das Geschlecht der Jiswiter, von Bria das Geschlecht der Briiter; ");
INSERT INTO deutkw_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","von den Söhnen Brias: von Heber das Geschlecht der Hebriter, von Malkiel das Geschlecht der Malkieliter. ");
INSERT INTO deutkw_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Und die Tochter Assers hieß Serah. ");
INSERT INTO deutkw_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Dies sind die Geschlechter der Söhne Assers, so viele ihrer gemustert wurden: 53400. ");
INSERT INTO deutkw_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Die Geschlechter der Söhne Naphthalis waren diese: von Jahzeel das Geschlecht der Jahzeeliter, von Guni das Geschlecht der Guniter, ");
INSERT INTO deutkw_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","von Jezer das Geschlecht der Jezeriter, von Sillem das Geschlecht der Sillemiter. ");
INSERT INTO deutkw_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Das sind die Geschlechter Naphthalis nach ihren Geschlechtern, und die aus ihnen Gemusterten beliefen sich auf 45400. ");
INSERT INTO deutkw_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Das sind die von den Israeliten Gemusterten: 601730. ");
INSERT INTO deutkw_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Und Jahwe redete mit Mose also: ");
INSERT INTO deutkw_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","An diese ist das Land nach Verhältnis der Kopfzahl erblich zu verteilen. ");
INSERT INTO deutkw_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Dem, der viele Köpfe zählt, sollst du ausgedehnten Erbbesitz geben, dagegen dem, der wenig zählt, einen kleinen Erbbesitz; einem jeden soll mit Rücksicht auf die aus ihm Gemusterten sein Erbbesitz zugewiesen werden. ");
INSERT INTO deutkw_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Doch soll das Land durch das Los verteilt werden, daß sie es nach den Namen ihrer väterlichen Stämme in Besitz haben. ");
INSERT INTO deutkw_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Nach dem Lose soll der Erbbesitz zwischen dem, der viele, und dem, der wenig Köpfe zählt, verteilt werden. ");
INSERT INTO deutkw_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Und dies sind die aus den Leviten Gemusterten, Geschlecht für Geschlecht: von Gerson das Geschlecht der Gersoniter, von Kahath das Geschlecht der Kahathiter, von Merari das Geschlecht der Merariter. ");
INSERT INTO deutkw_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Dies sind die Geschlechter Levis: das Geschlecht der Libniter, das Geschlecht der Hebroniter, das Geschlecht der Maheliter, das Geschlecht der Musiter, das Geschlecht der Korahiter. Kahath aber erzeugte Amram. ");
INSERT INTO deutkw_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Und das Weib Amrams hieß Jochebed, eine Tochter Levis, die Levi in Ägypten geboren ward; diese gebar dem Amram Aaron und Mose und ihre Schwester Mirjam. ");
INSERT INTO deutkw_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Dem Aaron aber wurden Nadab, Abihu, Eleasar und Ithamar geboren. ");
INSERT INTO deutkw_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nadab aber und Abihu mußten sterben, als sie ein ungehöriges Feueropfer vor Jahwe brachten. ");
INSERT INTO deutkw_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Es beliefen sich aber die aus ihnen Gemusterten auf 23000, alles, was männlich war, von einem Monat an und darüber. Denn sie waren nicht mit den übrigen Israeliten gemustert worden, weil ihnen kein Erbbesitz unter den Israeliten verliehen wurde. ");
INSERT INTO deutkw_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Das sind die von Mose und Eleasar, dem Priester, Gemusterten, welche die Israeliten in den Steppen Moabs am Jordan gegenüber Jericho musterten. ");
INSERT INTO deutkw_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Unter diesen war aber keiner mehr von denen, welche Mose und Aaron, der Priester, gemustert hatten, welche die Israeliten in der Steppe am Sinai musterten. ");
INSERT INTO deutkw_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Denn Jahwe hatte ihnen angekündigt, daß sie in der Steppe sterben müßten; so war denn keiner von ihnen übrig geblieben außer Kaleb, der Sohn Jephunnes, und Josua, der Sohn Nuns. ");
INSERT INTO deutkw_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Da traten herzu die Töchter Zelophhads, des Sohnes Hephers, des Sohnes Gileads, des Sohnes Machirs, des Sohnes Manasses, von den Geschlechtern Manasses, des Sohnes Josephs, und seine Töchter hießen Mahla, Noa, Hogla, Milka und Thirza. ");
INSERT INTO deutkw_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Die traten vor Mose und Eleasar, den Priester, und vor die Fürsten und die ganze Gemeinde vor der Thüre des Offenbarungszeltes und sprachen: ");
INSERT INTO deutkw_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","Unser Vater ist in der Steppe gestorben; er gehörte jedoch nicht zu der Rotte Korah, die sich wider Jahwe zusammenrottete, zu der Rotte Korah, sondern ist um seiner eignen Sünde willen gestorben. Er hatte aber keine Söhne. ");
INSERT INTO deutkw_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Warum soll nun der Name unseres Vaters aus seinem Geschle