﻿USE sofia;
DROP TABLE IF EXISTS sofia.deuelo_vpl;
CREATE TABLE deuelo_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES deuelo_vpl WRITE;
INSERT INTO deuelo_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Im Anfang schuf Gott die Himmel und die Erde. ");
INSERT INTO deuelo_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Und die Erde war wüst und leer, und Finsternis war über der Tiefe; und der Geist Gottes schwebte über den Wassern. ");
INSERT INTO deuelo_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Und Gott sprach: Es werde Licht! und es ward Licht. ");
INSERT INTO deuelo_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Und Gott sah das Licht, daß es gut war; und Gott schied das Licht von der Finsternis. ");
INSERT INTO deuelo_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Und Gott nannte das Licht Tag, und die Finsternis nannte er Nacht. Und es ward Abend und es ward Morgen: erster Tag. ");
INSERT INTO deuelo_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Und Gott sprach: Es werde eine Ausdehnung inmitten der Wasser, und sie scheide die Wasser von den Wassern! ");
INSERT INTO deuelo_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Und Gott machte die Ausdehnung und schied die Wasser, welche unterhalb der Ausdehnung, von den Wassern, die oberhalb der Ausdehnung sind. Und es ward also. ");
INSERT INTO deuelo_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Und Gott nannte die Ausdehnung Himmel. Und es ward Abend und es ward Morgen: zweiter Tag. ");
INSERT INTO deuelo_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Und Gott sprach: Es sammeln sich die Wasser unterhalb des Himmels an einen Ort, und es werde sichtbar das Trockene! Und es ward also. ");
INSERT INTO deuelo_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Und Gott nannte das Trockene Erde, und die Sammlung der Wasser nannte er Meere. Und Gott sah, daß es gut war. ");
INSERT INTO deuelo_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Und Gott sprach: Die Erde lasse Gras hervorsprossen, Kraut, das Samen hervorbringe, Fruchtbäume, die Frucht tragen nach ihrer Art, in welcher ihr Same sei auf der Erde! Und es ward also. ");
INSERT INTO deuelo_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Und die Erde brachte Gras hervor, Kraut, das Samen hervorbringt nach seiner Art, und Bäume, die Frucht tragen, in welcher ihr Same ist nach ihrer Art. Und Gott sah, daß es gut war. ");
INSERT INTO deuelo_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Und es ward Abend und es ward Morgen: dritter Tag. ");
INSERT INTO deuelo_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Und Gott sprach: Es werden Lichter an der Ausdehnung des Himmels, um den Tag von der Nacht zu scheiden, und sie seien zu Zeichen und zur Bestimmung von Zeiten und Tagen und Jahren; ");
INSERT INTO deuelo_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","und sie seien zu Lichtern an der Ausdehnung des Himmels, um auf die Erde zu leuchten! Und es ward also. ");
INSERT INTO deuelo_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Und Gott machte die zwei großen Lichter: das große Licht zur Beherrschung des Tages, und das kleine Licht zur Beherrschung der Nacht, und die Sterne. ");
INSERT INTO deuelo_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Und Gott setzte sie an die Ausdehnung des Himmels, um auf die Erde zu leuchten, ");
INSERT INTO deuelo_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","und um zu herrschen am Tage und in der Nacht und das Licht von der Finsternis zu scheiden. Und Gott sah, daß es gut war. ");
INSERT INTO deuelo_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Und es ward Abend und es ward Morgen: vierter Tag. ");
INSERT INTO deuelo_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Und Gott sprach: Es wimmeln die Wasser vom Gewimmel lebendiger Wesen, und Gevögel fliege über der Erde angesichts der Ausdehnung des Himmels! ");
INSERT INTO deuelo_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Und Gott schuf die großen Seeungeheuer und jedes sich regende, lebendige Wesen, wovon die Wasser wimmeln, nach ihrer Art, und alles geflügelte Gevögel nach seiner Art. Und Gott sah, daß es gut war. ");
INSERT INTO deuelo_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Und Gott segnete sie und sprach: Seid fruchtbar und mehret euch und füllet die Wasser in den Meeren, und das Gevögel mehre sich auf der Erde! ");
INSERT INTO deuelo_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Und es ward Abend und es ward Morgen: fünfter Tag. ");
INSERT INTO deuelo_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Und Gott sprach: Die Erde bringe hervor lebendige Wesen nach ihrer Art: Vieh und Gewürm und Getier der Erde nach seiner Art! Und es ward also. ");
INSERT INTO deuelo_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Und Gott machte das Getier der Erde nach seiner Art, und das Vieh nach seiner Art, und alles, was sich auf dem Erdboden regt, nach seiner Art. Und Gott sah, daß es gut war. ");
INSERT INTO deuelo_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Und Gott sprach: Lasset uns Menschen machen in unserem Bilde, nach unserem Gleichnis; und sie sollen herrschen über die Fische des Meeres und über das Gevögel des Himmels und über das Vieh und über die ganze Erde und über alles Gewürm, das sich auf der Erde regt! ");
INSERT INTO deuelo_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Und Gott schuf den Menschen in seinem Bilde, im Bilde Gottes schuf er ihn; Mann und Weib schuf er sie. ");
INSERT INTO deuelo_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Und Gott segnete sie, und Gott sprach zu ihnen: Seid fruchtbar und mehret euch und füllet die Erde und machet sie euch untertan; und herrschet über die Fische des Meeres und über das Gevögel des Himmels und über alles Getier, das sich auf der Erde regt! ");
INSERT INTO deuelo_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Und Gott sprach: Siehe, ich habe euch gegeben alles samenbringende Kraut, das auf der Fläche der ganzen Erde ist, und jeden Baum, an welchem samenbringende Baumfrucht ist: es soll euch zur Speise sein; ");
INSERT INTO deuelo_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","und allem Getier der Erde und allem Gevögel des Himmels und allem, was sich auf der Erde regt, in welchem eine lebendige Seele ist, habe ich alles grüne Kraut zur Speise gegeben. ");
INSERT INTO deuelo_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Und es ward also. Und Gott sah alles, was er gemacht hatte, und siehe, es war sehr gut. Und es ward Abend und es ward Morgen: der sechste Tag. ");
INSERT INTO deuelo_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","So wurden vollendet der Himmel und die Erde und all ihr Heer. ");
INSERT INTO deuelo_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Und Gott hatte am siebten Tage sein Werk vollendet, das er gemacht hatte; und er ruhte am siebten Tage von all seinem Werk, das er gemacht hatte. ");
INSERT INTO deuelo_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Und Gott segnete den siebten Tag und heiligte ihn; denn an demselben ruhte er von all seinem Werk, das Gott geschaffen hatte, indem er es machte. ");
INSERT INTO deuelo_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Dies ist die Geschichte des Himmels und der Erde, als sie geschaffen wurden, an dem Tage, da Jehova Gott Erde und Himmel machte, ");
INSERT INTO deuelo_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","und ehe alles Gesträuch des Feldes auf der Erde war, und ehe alles Kraut des Feldes sproßte; denn Jehova Gott hatte nicht regnen lassen auf die Erde, und kein Mensch war da, um den Erdboden zu bebauen. ");
INSERT INTO deuelo_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Ein Dunst aber stieg auf von der Erde und befeuchtete die ganze Oberfläche des Erdbodens. ");
INSERT INTO deuelo_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Und Jehova Gott bildete den Menschen, Staub von dem Erdboden, und hauchte in seine Nase den Odem des Lebens; und der Mensch wurde eine lebendige Seele. ");
INSERT INTO deuelo_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Und Jehova Gott pflanzte einen Garten in Eden gegen Osten, und er setzte dorthin den Menschen, den er gebildet hatte. ");
INSERT INTO deuelo_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Und Jehova Gott ließ aus dem Erdboden allerlei Bäume wachsen, lieblich anzusehen und gut zur Speise; und den Baum des Lebens in der Mitte des Gartens, und den Baum der Erkenntnis des Guten und Bösen. ");
INSERT INTO deuelo_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Und ein Strom ging aus von Eden, den Garten zu bewässern; und von dort aus teilte er sich und wurde zu vier Flüssen. ");
INSERT INTO deuelo_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Der Name des ersten ist Pison; dieser ist es, der das ganze Land Hawila umfließt, wo das Gold ist; ");
INSERT INTO deuelo_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","und das Gold dieses Landes ist gut; daselbst ist das Bdellion und der Stein Onyx. ");
INSERT INTO deuelo_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Und der Name des zweiten Flusses: Gihon; dieser ist es, der das ganze Land Kusch umfließt. ");
INSERT INTO deuelo_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Und der Name des dritten Flusses: Hiddekel; dieser ist es, der vor Assyrien fließt. Und der vierte Fluß, das ist der Phrath. ");
INSERT INTO deuelo_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Und Jehova Gott nahm den Menschen und setzte ihn in den Garten Eden, ihn zu bebauen und ihn zu bewahren. ");
INSERT INTO deuelo_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Und Jehova Gott gebot dem Menschen und sprach: Von jedem Baume des Gartens darfst du nach Belieben essen; ");
INSERT INTO deuelo_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","aber von dem Baume der Erkenntnis des Guten und Bösen, davon sollst du nicht essen; denn welches Tages du davon issest, wirst du gewißlich sterben. ");
INSERT INTO deuelo_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Und Jehova Gott sprach: Es ist nicht gut, daß der Mensch allein sei; ich will ihm eine Hilfe machen, seines Gleichen. ");
INSERT INTO deuelo_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Und Jehova Gott bildete aus dem Erdboden alles Getier des Feldes und alles Gevögel des Himmels, und er brachte sie zu dem Menschen, um zu sehen, wie er sie nennen würde; und wie irgend der Mensch ein lebendiges Wesen nennen würde, so sollte sein Name sein. ");
INSERT INTO deuelo_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Und der Mensch gab Namen allem Vieh und dem Gevögel des Himmels und allem Getier des Feldes. Aber für Adam fand er keine Hilfe seines Gleichen. ");
INSERT INTO deuelo_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Und Jehova Gott ließ einen tiefen Schlaf auf den Menschen fallen, und er entschlief. Und er nahm eine von seinen Rippen und verschloß ihre Stelle mit Fleisch; ");
INSERT INTO deuelo_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","und Jehova Gott baute aus der Rippe, die er von dem Menschen genommen hatte, ein Weib, und er brachte sie zu dem Menschen. ");
INSERT INTO deuelo_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Und der Mensch sprach: Diese ist einmal Gebein von meinen Gebeinen und Fleisch von meinem Fleische; diese soll Männin heißen, denn vom Manne ist diese genommen. ");
INSERT INTO deuelo_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Darum wird ein Mann seinen Vater und seine Mutter verlassen und seinem Weibe anhangen, und sie werden ein Fleisch sein. ");
INSERT INTO deuelo_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Und sie waren beide nackt, der Mensch und sein Weib, und sie schämten sich nicht. ");
INSERT INTO deuelo_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Und die Schlange war listiger als alles Getier des Feldes, das Jehova Gott gemacht hatte; und sie sprach zu dem Weibe: Hat Gott wirklich gesagt: Ihr sollt nicht essen von jedem Baume des Gartens? ");
INSERT INTO deuelo_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Und das Weib sprach zu der Schlange: Von der Frucht der Bäume des Gartens essen wir; ");
INSERT INTO deuelo_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","aber von der Frucht des Baumes, der in der Mitte des Gartens ist, hat Gott gesagt, davon sollt ihr nicht essen und sie nicht anrühren, auf daß ihr nicht sterbet. ");
INSERT INTO deuelo_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Und die Schlange sprach zu dem Weibe: Mit nichten werdet ihr sterben! ");
INSERT INTO deuelo_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Sondern Gott weiß, daß, welches Tages ihr davon esset, eure Augen aufgetan werden und ihr sein werdet wie Gott, erkennend Gutes und Böses. ");
INSERT INTO deuelo_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Und das Weib sah, daß der Baum gut zur Speise und daß er eine Lust für die Augen und daß der Baum begehrenswert wäre, um Einsicht zu geben; und sie nahm von seiner Frucht und aß, und sie gab auch ihrem Manne mit ihr, und er aß. ");
INSERT INTO deuelo_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Da wurden ihrer beider Augen aufgetan, und sie erkannten, daß sie nackt waren; und sie hefteten Feigenblätter zusammen und machten sich Schürzen. ");
INSERT INTO deuelo_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Und sie hörten die Stimme Jehovas Gottes, der im Garten wandelte bei der Kühle des Tages. Und der Mensch und sein Weib versteckten sich vor dem Angesicht Jehovas Gottes mitten unter die Bäume des Gartens. ");
INSERT INTO deuelo_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Und Jehova Gott rief den Menschen und sprach zu ihm: Wo bist du? ");
INSERT INTO deuelo_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Und er sprach: Ich hörte deine Stimme im Garten, und ich fürchtete mich, denn ich bin nackt, und ich versteckte mich. ");
INSERT INTO deuelo_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Und er sprach: Wer hat dir kundgetan, daß du nackt bist? Hast du gegessen von dem Baume, von dem ich dir geboten habe, nicht davon zu essen? ");
INSERT INTO deuelo_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Und der Mensch sprach: Das Weib, das du mir beigegeben hast, sie gab mir von dem Baume, und ich aß. ");
INSERT INTO deuelo_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Und Jehova Gott sprach zu dem Weibe: Was hast du da getan! Und das Weib sprach: Die Schlange betrog mich, und ich aß. ");
INSERT INTO deuelo_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Und Jehova Gott sprach zu der Schlange: Weil du dieses getan hast, sollst du verflucht sein vor allem Vieh und vor allem Getier des Feldes! Auf deinem Bauche sollst du kriechen und Staub fressen alle Tage deines Lebens. ");
INSERT INTO deuelo_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Und ich werde Feindschaft setzen zwischen dir und dem Weibe und zwischen deinem Samen und ihrem Samen; er wird dir den Kopf zermalmen, und du, du wirst ihm die Ferse zermalmen. ");
INSERT INTO deuelo_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Zu dem Weibe sprach er: Ich werde sehr mehren die Mühsal deiner Schwangerschaft, mit Schmerzen sollst du Kinder gebären; und nach deinem Manne wird dein Verlangen sein, er aber wird über dich herrschen. ");
INSERT INTO deuelo_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Und zu Adam sprach er: Weil du auf die Stimme deines Weibes gehört und gegessen hast von dem Baume, von dem ich dir geboten und gesprochen habe: Du sollst nicht davon essen, so sei der Erdboden verflucht um deinetwillen: mit Mühsal sollst du davon essen alle Tage deines Lebens; ");
INSERT INTO deuelo_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","und Dornen und Disteln wird er dir sprossen lassen, und du wirst das Kraut des Feldes essen. ");
INSERT INTO deuelo_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Im Schweiße deines Angesichts wirst du dein Brot essen, bis du zurückkehrst zur Erde, denn von ihr bist du genommen. Denn Staub bist du, und zum Staube wirst du zurückkehren! ");
INSERT INTO deuelo_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Und der Mensch gab seinem Weibe den Namen Eva, denn sie war die Mutter aller Lebendigen. ");
INSERT INTO deuelo_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Und Jehova Gott machte Adam und seinem Weibe Röcke von Fell und bekleidete sie. ");
INSERT INTO deuelo_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Und Jehova Gott sprach: Siehe, der Mensch ist geworden wie unser einer, zu erkennen Gutes und Böses; und nun, daß er seine Hand nicht ausstrecke und nehme auch von dem Baume des Lebens und esse und lebe ewiglich! ");
INSERT INTO deuelo_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Und Jehova Gott schickte ihn aus dem Garten Eden hinaus, um den Erdboden zu bebauen, davon er genommen war; ");
INSERT INTO deuelo_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","und er trieb den Menschen aus und ließ lagern gegen Osten vom Garten Eden die Cherubim und die Flamme des kreisenden Schwertes, um den Weg zum Baume des Lebens zu bewahren. ");
INSERT INTO deuelo_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Und der Mensch erkannte Eva, sein Weib, und sie ward schwanger und gebar Kain; und sie sprach: Ich habe einen Mann erworben mit Jehova. ");
INSERT INTO deuelo_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Und sie gebar ferner seinen Bruder, den Abel. Und Abel wurde ein Schafhirt, und Kain wurde ein Ackerbauer. ");
INSERT INTO deuelo_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Und es geschah nach Verlauf einer Zeit, da brachte Kain dem Jehova eine Opfergabe von der Frucht des Erdbodens; ");
INSERT INTO deuelo_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","und Abel, auch er brachte von den Erstlingen seiner Herde und von ihrem Fett. Und Jehova blickte auf Abel und auf seine Opfergabe; ");
INSERT INTO deuelo_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","aber auf Kain und auf seine Opfergabe blickte er nicht. Und Kain ergrimmte sehr, und sein Antlitz senkte sich. ");
INSERT INTO deuelo_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Und Jehova sprach zu Kain: Warum bist du ergrimmt, und warum hat sich dein Antlitz gesenkt? ");
INSERT INTO deuelo_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ist es nicht so, daß es sich erhebt, wenn du wohl tust? Und wenn du nicht wohl tust, so lagert die Sünde vor der Tür. Und nach dir wird sein Verlangen sein, du aber wirst über ihn herrschen. ");
INSERT INTO deuelo_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Und Kain sprach zu seinem Bruder Abel; und es geschah, als sie auf dem Felde waren, da erhob sich Kain wider seinen Bruder Abel und erschlug ihn. ");
INSERT INTO deuelo_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Und Jehova sprach zu Kain: Wo ist dein Bruder Abel? Und er sprach: Ich weiß nicht; bin ich meines Bruders Hüter? ");
INSERT INTO deuelo_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Und er sprach: Was hast du getan! Horch! Das Blut deines Bruders schreit zu mir vom Erdboden her. ");
INSERT INTO deuelo_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Und nun, verflucht seiest du von dem Erdboden hinweg, der seinen Mund aufgetan hat, das Blut deines Bruders von deiner Hand zu empfangen! ");
INSERT INTO deuelo_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Wenn du den Erdboden bebaust, soll er dir hinfort seine Kraft nicht geben; unstet und flüchtig sollst du sein auf der Erde. ");
INSERT INTO deuelo_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Und Kain sprach zu Jehova: Zu groß ist meine Strafe, um sie zu tragen. ");
INSERT INTO deuelo_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Siehe, du hast mich heute von der Fläche des Erdbodens vertrieben, und ich werde verborgen sein vor deinem Angesicht und werde unstet und flüchtig sein auf der Erde; und es wird geschehen: wer irgend mich findet, wird mich erschlagen. ");
INSERT INTO deuelo_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Und Jehova sprach zu ihm: Darum, jeder, der Kain erschlägt siebenfältig soll es gerächt werden. Und Jehova machte an Kain ein Zeichen, auf daß ihn nicht erschlüge, wer irgend ihn fände. ");
INSERT INTO deuelo_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Und Kain ging weg von dem Angesicht Jehovas und wohnte im Lande Nod, östlich von Eden. ");
INSERT INTO deuelo_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Und Kain erkannte sein Weib, und sie ward schwanger und gebar Hanoch. Und er baute eine Stadt und benannte die Stadt nach dem Namen seines Sohnes Hanoch. ");
INSERT INTO deuelo_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Und dem Hanoch wurde Irad geboren; und Irad zeugte Mehujael, und Mehujael zeugte Methusael, und Methusael zeugte Lamech. ");
INSERT INTO deuelo_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Und Lamech nahm sich zwei Weiber; der Name der einen war Ada, und der Name der anderen Zilla. ");
INSERT INTO deuelo_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Und Ada gebar Jabal; dieser war der Vater der Zeltbewohner und Herdenbesitzer. ");
INSERT INTO deuelo_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Und der Name seines Bruders war Jubal; dieser war der Vater aller derer, welche mit der Laute und der Flöte umgehen. ");
INSERT INTO deuelo_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Und Zilla, auch sie gebar Tubalkain, einen Hämmerer von allerlei Schneidewerkzeug aus Erz und Eisen. Und die Schwester Tubalkains war Naama. ");
INSERT INTO deuelo_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Und Lamech sprach zu seinen Weibern: Ada und Zilla, höret meine Stimme; Weiber Lamechs, horchet auf meine Rede! Einen Mann erschlug ich für meine Wunde und einen Jüngling für meine Strieme! ");
INSERT INTO deuelo_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Wenn Kain siebenfältig gerächt wird, so Lamech siebenundsiebzigfältig. ");
INSERT INTO deuelo_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Und Adam erkannte abermals sein Weib, und sie gebar einen Sohn und gab ihm den Namen Seth; denn Gott hat mir einen anderen Samen gesetzt an Stelle Abels, weil Kain ihn erschlagen hat. ");
INSERT INTO deuelo_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Und dem Seth, auch ihm wurde ein Sohn geboren, und er gab ihm den Namen Enos. Damals fing man an, den Namen Jehovas anzurufen. ");
INSERT INTO deuelo_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Dies ist das Buch von Adams Geschlechtern. An dem Tage, da Gott Adam schuf, machte er ihn im Gleichnis Gottes. ");
INSERT INTO deuelo_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Mann und Weib schuf er sie, und er segnete sie und gab ihnen den Namen Mensch, an dem Tage, da sie geschaffen wurden. - ");
INSERT INTO deuelo_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Und Adam lebte hundertdreißig Jahre und zeugte einen Sohn in seinem Gleichnis, nach seinem Bilde, und gab ihm den Namen Seth. ");
INSERT INTO deuelo_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Und die Tage Adams, nachdem er Seth gezeugt hatte, waren achthundert Jahre, und er zeugte Söhne und Töchter. ");
INSERT INTO deuelo_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Und alle Tage Adams, die er lebte, waren neunhundertdreißig Jahre, und er starb. - ");
INSERT INTO deuelo_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Und Seth lebte hundertfünf Jahre und zeugte Enos. ");
INSERT INTO deuelo_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Und Seth lebte, nachdem er Enos gezeugt hatte, achthundertsieben Jahre und zeugte Söhne und Töchter. ");
INSERT INTO deuelo_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Und alle Tage Seths waren neunhundertzwölf Jahre, und er starb. - ");
INSERT INTO deuelo_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Und Enos lebte neunzig Jahre und zeugte Kenan. ");
INSERT INTO deuelo_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Und Enos lebte, nachdem er Kenan gezeugt hatte, achthundertfünfzehn Jahre und zeugte Söhne und Töchter. ");
INSERT INTO deuelo_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Und alle Tage Enos' waren neunhundertfünf Jahre, und er starb. - ");
INSERT INTO deuelo_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Und Kenan lebte siebzig Jahre und zeugte Mahalalel. ");
INSERT INTO deuelo_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Und Kenan lebte, nachdem er Mahalalel gezeugt hatte, achthundertvierzig Jahre und zeugte Söhne und Töchter. ");
INSERT INTO deuelo_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Und alle Tage Kenans waren neunhundertzehn Jahre, und er starb. - ");
INSERT INTO deuelo_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Und Mahalalel lebte fünfundsechzig Jahre und zeugte Jered. ");
INSERT INTO deuelo_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Und Mahalalel lebte, nachdem er Jered gezeugt hatte, achthundertdreißig Jahre und zeugte Söhne und Töchter. ");
INSERT INTO deuelo_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Und alle Tage Mahalalels waren achthundertfünfundneunzig Jahre, und er starb. - ");
INSERT INTO deuelo_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Und Jered lebte hundertzweiundsechzig Jahre und zeugte Henoch. ");
INSERT INTO deuelo_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Und Jered lebte, nachdem er Henoch gezeugt hatte, achthundert Jahre und zeugte Söhne und Töchter. ");
INSERT INTO deuelo_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Und alle Tage Jereds waren neunhundertzweiundsechzig Jahre, und er starb. - ");
INSERT INTO deuelo_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Und Henoch lebte fünfundsechzig Jahre und zeugte Methusalah. ");
INSERT INTO deuelo_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Und Henoch wandelte mit Gott, nachdem er Methusalah gezeugt hatte, dreihundert Jahre und zeugte Söhne und Töchter. ");
INSERT INTO deuelo_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Und alle Tage Henochs waren dreihundertfünfundsechzig Jahre. ");
INSERT INTO deuelo_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Und Henoch wandelte mit Gott; und er war nicht mehr, denn Gott nahm ihn hinweg. - ");
INSERT INTO deuelo_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Und Methusalah lebte hundertsiebenachtzig Jahre und zeugte Lamech. ");
INSERT INTO deuelo_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Und Methusalah lebte, nachdem er Lamech gezeugt hatte, siebenhundertzweiundachtzig Jahre und zeugte Söhne und Töchter. ");
INSERT INTO deuelo_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Und alle Tage Methusalahs waren neunhundertneunundsechzig Jahre, und er starb. - ");
INSERT INTO deuelo_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Und Lamech lebte hundertzweiundachtzig Jahre und zeugte einen Sohn. ");
INSERT INTO deuelo_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Und er gab ihm den Namen Noah, indem er sprach: Dieser wird uns trösten über unsere Arbeit und über die Mühe unserer Hände wegen des Erdbodens, den Jehova verflucht hat. ");
INSERT INTO deuelo_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Und Lamech lebte, nachdem er Noah gezeugt hatte, fünfhundertfünfundneunzig Jahre und zeugte Söhne und Töchter. ");
INSERT INTO deuelo_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Und alle Tage Lamechs waren siebenhundertsiebenundsiebzig Jahre, und er starb. - ");
INSERT INTO deuelo_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Und Noah war fünfhundert Jahre alt; und Noah zeugte Sem, Ham und Japhet. ");
INSERT INTO deuelo_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Und es geschah, als die Menschen begannen sich zu mehren auf der Fläche des Erdbodens, und ihnen Töchter geboren wurden, ");
INSERT INTO deuelo_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","da sahen die Söhne Gottes, daß die Töchter der Menschen schön waren, und sie nahmen sich zu Weibern, welche sie irgend erwählten. ");
INSERT INTO deuelo_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Und Jehova sprach: Mein Geist soll nicht ewiglich mit dem Menschen rechten, da er ja Fleisch ist; und seine Tage seien hundertzwanzig Jahre. ");
INSERT INTO deuelo_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","In jenen Tagen waren die Riesen auf der Erde, und auch nachher, als die Söhne Gottes zu den Töchtern der Menschen eingingen und diese ihnen gebaren. Das sind die Helden, welche von alters her waren, die Männer von Ruhm gewesen sind. ");
INSERT INTO deuelo_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Und Jehova sah, daß des Menschen Bosheit groß war auf Erden und alles Gebilde der Gedanken seines Herzens nur böse den ganzen Tag. ");
INSERT INTO deuelo_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Und es reute Jehova, daß er den Menschen gemacht hatte auf der Erde, und es schmerzte ihn in sein Herz hinein. ");
INSERT INTO deuelo_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Und Jehova sprach: Ich will den Menschen, den ich geschaffen habe, von der Fläche des Erdbodens vertilgen, vom Menschen bis zum Vieh, bis zum Gewürm und bis zum Gevögel des Himmels; denn es reut mich, daß ich sie gemacht habe. ");
INSERT INTO deuelo_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Noah aber fand Gnade in den Augen Jehovas. ");
INSERT INTO deuelo_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Dies ist die Geschichte Noahs: Noah war ein gerechter, vollkommener Mann unter seinen Zeitgenossen; Noah wandelte mit Gott. ");
INSERT INTO deuelo_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Und Noah zeugte drei Söhne: Sem, Ham und Japhet. ");
INSERT INTO deuelo_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Und die Erde war verderbt vor Gott, und die Erde war voll Gewalttat. ");
INSERT INTO deuelo_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Und Gott sah die Erde, und siehe, sie war verderbt; denn alles Fleisch hatte seinen Weg verderbt auf Erden. ");
INSERT INTO deuelo_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Und Gott sprach zu Noah: Das Ende alles Fleisches ist vor mich gekommen; denn die Erde ist voll Gewalttat durch sie; und siehe, ich will sie verderben mit der Erde. ");
INSERT INTO deuelo_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Mache dir eine Arche von Gopherholz; mit Kammern sollst du die Arche machen und sie von innen und von außen mit Harz verpichen. ");
INSERT INTO deuelo_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Und also sollst du sie machen: Dreihundert Ellen sei die Länge der Arche, fünfzig Ellen ihre Breite und dreißig Ellen ihre Höhe. ");
INSERT INTO deuelo_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Eine Lichtöffnung sollst du der Arche machen, und bis zu einer Elle sollst du sie fertigen von oben her; und die Tür der Arche sollst du in ihre Seite setzen; mit einem unteren, zweiten und dritten Stockwerk sollst du sie machen. ");
INSERT INTO deuelo_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Denn ich, siehe, ich bringe die Wasserflut über die Erde, um alles Fleisch unter dem Himmel zu verderben, in welchem ein Hauch des Lebens ist; alles, was auf der Erde ist, soll verscheiden. ");
INSERT INTO deuelo_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Aber mit dir will ich meinen Bund errichten, und du sollst in die Arche gehen, du und deine Söhne und dein Weib und die Weiber deiner Söhne mit dir. ");
INSERT INTO deuelo_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Und von allem Lebendigen, von allem Fleische, zwei von jeglichem sollst du in die Arche bringen, um sie mit dir am Leben zu erhalten; ein Männliches und ein Weibliches sollen sie sein. ");
INSERT INTO deuelo_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Von dem Gevögel nach seiner Art und von dem Vieh nach seiner Art, von allem Gewürm des Erdbodens nach seiner Art: zwei von jeglichem sollen zu dir hineingehen, um sie am Leben zu erhalten. ");
INSERT INTO deuelo_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Und du, nimm dir von aller Speise, die gegessen wird und sammle sie bei dir auf, daß sie dir und ihnen zur Nahrung sei. ");
INSERT INTO deuelo_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Und Noah tat es; nach allem, was Gott ihm geboten hatte, also tat er. ");
INSERT INTO deuelo_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Und Jehova sprach zu Noah: Gehe in die Arche, du und dein ganzes Haus; denn dich habe ich gerecht vor mir erfunden in diesem Geschlecht. ");
INSERT INTO deuelo_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Von allem reinen Vieh sollst du sieben und sieben zu dir nehmen, ein Männchen und sein Weibchen; und von dem Vieh, das nicht rein ist, zwei, ein Männchen und sein Weibchen; ");
INSERT INTO deuelo_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","auch von dem Gevögel des Himmels sieben und sieben, ein Männliches und ein Weibliches: um Samen am Leben zu erhalten auf der Fläche der ganzen Erde. ");
INSERT INTO deuelo_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Denn in noch sieben Tagen, so lasse ich auf die Erde regnen vierzig Tage und vierzig Nächte und werde vertilgen von der Fläche des Erdbodens alles Bestehende, das ich gemacht habe. - ");
INSERT INTO deuelo_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Und Noah tat nach allem, was Jehova ihm geboten hatte. ");
INSERT INTO deuelo_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Und Noah war sechshundert Jahre alt, als die Flut kam, Wasser über die Erde. ");
INSERT INTO deuelo_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Und Noah und seine Söhne und sein Weib und die Weiber seiner Söhne mit ihm gingen in die Arche vor den Wassern der Flut. ");
INSERT INTO deuelo_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Von dem reinen Vieh und von dem Vieh, das nicht rein ist, und von dem Gevögel und von allem, was sich auf dem Erdboden regt, ");
INSERT INTO deuelo_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","kamen zwei und zwei zu Noah in die Arche, ein Männliches und ein Weibliches, wie Gott dem Noah geboten hatte. ");
INSERT INTO deuelo_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Und es geschah nach sieben Tagen, da kamen die Wasser der Flut über die Erde. ");
INSERT INTO deuelo_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Im sechshundertsten Jahre des Lebens Noahs, im zweiten Monat, am siebzehnten Tage des Monats, an diesem Tage brachen auf alle Quellen der großen Tiefe, und die Fenster des Himmels taten sich auf. ");
INSERT INTO deuelo_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Und der Regen fiel auf die Erde vierzig Tage und vierzig Nächte. ");
INSERT INTO deuelo_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","An ebendemselben Tage gingen Noah und Sem und Ham und Japhet, die Söhne Noahs, und das Weib Noahs und die drei Weiber seiner Söhne mit ihnen in die Arche: ");
INSERT INTO deuelo_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","sie und alles Getier nach seiner Art und alles Vieh nach seiner Art und alles Gewürm, das sich auf der Erde regt, nach seiner Art und alles Gevögel nach seiner Art, jeder Vogel von allerlei Gefieder. ");
INSERT INTO deuelo_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Und sie gingen zu Noah in die Arche, je zwei und zwei von allem Fleische, in welchem ein Hauch des Lebens war. ");
INSERT INTO deuelo_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Und die hineingingen, waren ein Männliches und ein Weibliches von allem Fleische, wie Gott ihm geboten hatte. Und Jehova schloß hinter ihm zu. ");
INSERT INTO deuelo_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Und die Flut kam vierzig Tage lang über die Erde. Und die Wasser mehrten sich und hoben die Arche empor; und sie erhob sich über die Erde. ");
INSERT INTO deuelo_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Und die Wasser nahmen überhand und mehrten sich sehr auf der Erde; und die Arche fuhr auf der Fläche der Wasser. ");
INSERT INTO deuelo_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Und die Wasser nahmen gar sehr überhand auf der Erde, und es wurden bedeckt alle hohen Berge, die unter dem ganzen Himmel sind. ");
INSERT INTO deuelo_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Fünfzehn Ellen darüber nahmen die Wasser überhand, und die Berge wurden bedeckt. ");
INSERT INTO deuelo_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Da verschied alles Fleisch, das sich auf der Erde regte, an Gevögel und an Vieh und an Getier und an allem Gewimmel, das auf der Erde wimmelte, und alle Menschen; ");
INSERT INTO deuelo_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","alles starb, in dessen Nase ein Odem des Lebenshauches war, von allem, was auf dem Trockenen war. ");
INSERT INTO deuelo_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Und vertilgt wurde alles Bestehende, das auf der Fläche des Erdbodens war, vom Menschen bis zum Vieh, bis zum Gewürm und bis zum Gevögel des Himmels; und sie wurden vertilgt von der Erde. Und nur Noah blieb übrig und was mit ihm in der Arche war. ");
INSERT INTO deuelo_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Und die Wasser hatten überhand auf der Erde hundertfünfzig Tage. ");
INSERT INTO deuelo_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Und Gott gedachte des Noah und alles Getieres und alles Viehes, das mit ihm in der Arche war; und Gott ließ einen Wind über die Erde fahren, und die Wasser sanken. ");
INSERT INTO deuelo_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Und es wurden verschlossen die Quellen der Tiefe und die Fenster des Himmels, und dem Regen vom Himmel ward gewehrt. ");
INSERT INTO deuelo_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Und die Wasser wichen von der Erde, fort und fort weichend; und die Wasser nahmen ab nach Verlauf von hundertfünfzig Tagen. ");
INSERT INTO deuelo_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Und im siebten Monat, am siebzehnten Tage des Monats, ruhte die Arche auf dem Gebirge Ararat. ");
INSERT INTO deuelo_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Und die Wasser nahmen fort und fort ab bis zum zehnten Monat; im zehnten Monat, am Ersten des Monats, wurden die Spitzen der Berge sichtbar. ");
INSERT INTO deuelo_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Und es geschah nach Verlauf von vierzig Tagen, da öffnete Noah das Fenster der Arche, das er gemacht hatte, und ließ den Raben aus; ");
INSERT INTO deuelo_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","und der flog hin und wieder, bis die Wasser von der Erde vertrocknet waren. ");
INSERT INTO deuelo_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Und er ließ die Taube von sich aus, um zu sehen, ob die Wasser sich verlaufen hätten von der Fläche des Erdbodens; ");
INSERT INTO deuelo_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","aber die Taube fand keinen Ruheplatz für ihren Fuß und kehrte zu ihm in die Arche zurück; denn die Wasser waren noch auf der Fläche der ganzen Erde; und er streckte seine Hand aus und nahm sie und brachte sie zu sich in die Arche. ");
INSERT INTO deuelo_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Und er wartete noch sieben andere Tage und ließ die Taube abermals aus der Arche; ");
INSERT INTO deuelo_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","und die Taube kam zu ihm um die Abendzeit, und siehe, ein abgerissenes Olivenblatt war in ihrem Schnabel. Und Noah erkannte, daß die Wasser sich verlaufen hatten von der Erde. ");
INSERT INTO deuelo_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Und er wartete noch sieben andere Tage und ließ die Taube aus; und sie kehrte hinfort nicht wieder zu ihm zurück. ");
INSERT INTO deuelo_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Und es geschah im sechshundertundersten Jahre, im ersten Monat, am Ersten des Monats, da waren die Wasser von der Erde vertrocknet. Und Noah tat die Decke von der Arche und sah: und siehe, die Fläche des Erdbodens war getrocknet. ");
INSERT INTO deuelo_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Und im zweiten Monat, am siebenundzwanzigsten Tage des Monats, war die Erde trocken. ");
INSERT INTO deuelo_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Und Gott redete zu Noah und sprach: ");
INSERT INTO deuelo_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Gehe aus der Arche, du und dein Weib und deine Söhne und die Weiber deiner Söhne mit dir. ");
INSERT INTO deuelo_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Alles Getier, das bei dir ist, von allem Fleische, an Gevögel und an Vieh und an allem Gewürm, das sich auf der Erde regt, laß mit dir hinausgehen, daß sie wimmeln auf Erden und fruchtbar seien und sich mehren auf Erden. ");
INSERT INTO deuelo_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Und Noah ging hinaus und seine Söhne und sein Weib und die Weiber seiner Söhne mit ihm. ");
INSERT INTO deuelo_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Alles Getier, alles Gewürm und alles Gevögel, alles was sich auf der Erde regt, nach ihren Arten, gingen aus der Arche. ");
INSERT INTO deuelo_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Und Noah baute Jehova einen Altar; und er nahm von allem reinen Vieh und von allem reinen Gevögel und opferte Brandopfer auf dem Altar. ");
INSERT INTO deuelo_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Und Jehova roch den lieblichen Geruch, und Jehova sprach in seinem Herzen: Nicht mehr will ich hinfort den Erdboden verfluchen um des Menschen willen; denn das Dichten des menschlichen Herzens ist böse von seiner Jugend an; und nicht mehr will ich hinfort alles Lebendige schlagen, wie ich getan habe. ");
INSERT INTO deuelo_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Forthin, alle Tage der Erde, sollen nicht aufhören Saat und Ernte, und Frost und Hitze, und Sommer und Winter, und Tag und Nacht. ");
INSERT INTO deuelo_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Und Gott segnete Noah und seine Söhne und sprach zu ihnen: Seid fruchtbar und mehret euch und füllet die Erde; ");
INSERT INTO deuelo_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","und die Furcht und der Schrecken vor euch sei auf allem Getier der Erde und auf allem Gevögel des Himmels! Alles, was sich auf dem Erdboden regt, und alle Fische des Meeres, in eure Hände sind sie gegeben: ");
INSERT INTO deuelo_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","alles, was sich regt, was da lebt, soll euch zur Speise sein; wie das grüne Kraut gebe ich es euch alles. ");
INSERT INTO deuelo_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Nur das Fleisch mit seiner Seele, seinem Blute, sollt ihr nicht essen; ");
INSERT INTO deuelo_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","und wahrlich, euer Blut, nach euren Seelen, werde ich fordern; von jedem Tiere werde ich es fordern, und von der Hand des Menschen, von der Hand eines jeden, seines Bruders, werde ich die Seele des Menschen fordern. ");
INSERT INTO deuelo_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Wer Menschenblut vergießt, durch den Menschen soll sein Blut vergossen werden; denn im Bilde Gottes hat er den Menschen gemacht. ");
INSERT INTO deuelo_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ihr nun, seid fruchtbar und mehret euch, wimmelt auf der Erde und mehret euch auf ihr! ");
INSERT INTO deuelo_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Und Gott sprach zu Noah und zu seinen Söhnen mit ihm und sagte: ");
INSERT INTO deuelo_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Und ich, siehe, ich errichte meinen Bund mit euch und mit eurem Samen nach euch; ");
INSERT INTO deuelo_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","und mit jedem lebendigen Wesen, das bei euch ist, an Gevögel, an Vieh und an allem Getier der Erde bei euch, was irgend von allem Getier der Erde aus der Arche gegangen ist. ");
INSERT INTO deuelo_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Und ich errichte meinen Bund mit euch; und nicht mehr soll alles Fleisch ausgerottet werden durch die Wasser der Flut, und keine Flut soll mehr sein, die Erde zu verderben. ");
INSERT INTO deuelo_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Und Gott sprach: Dies ist das Zeichen des Bundes, den ich stifte zwischen mir und euch und jeder lebendigen Seele, die bei euch ist, auf ewige Geschlechter hin: ");
INSERT INTO deuelo_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Meinen Bogen setze ich in die Wolken, und er soll das Zeichen des Bundes sein zwischen mir und der Erde. ");
INSERT INTO deuelo_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Und es wird geschehen, wenn ich Wolken über die Erde führe, so soll der Bogen in den Wolken erscheinen, ");
INSERT INTO deuelo_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","und ich werde meines Bundes gedenken, der zwischen mir und euch ist und jedem lebendigen Wesen, von allem Fleische; und nicht mehr sollen die Wasser zu einer Flut werden, alles Fleisch zu verderben. ");
INSERT INTO deuelo_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Und der Bogen wird in den Wolken sein; und ich werde ihn ansehen, um zu gedenken des ewigen Bundes zwischen Gott und jedem lebendigen Wesen von allem Fleische, das auf Erden ist. ");
INSERT INTO deuelo_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Und Gott sprach zu Noah: Das ist das Zeichen des Bundes, den ich errichtet habe zwischen mir und allem Fleische, das auf Erden ist. ");
INSERT INTO deuelo_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Und die Söhne Noahs, die aus der Arche gingen, waren Sem und Ham und Japhet; und Ham ist der Vater Kanaans. ");
INSERT INTO deuelo_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Diese drei sind die Söhne Noahs und von diesen aus ist die ganze Erde bevölkert worden. ");
INSERT INTO deuelo_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Und Noah fing an ein Ackersmann zu werden und pflanzte einen Weinberg. ");
INSERT INTO deuelo_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Und er trank von dem Weine und ward trunken, und er entblößte sich in seinem Zelte. ");
INSERT INTO deuelo_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Und Ham, der Vater Kanaans, sah die Blöße seines Vaters und berichtete es seinen beiden Brüdern draußen. ");
INSERT INTO deuelo_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Da nahmen Sem und Japhet das Obergewand und legten es beide auf ihre Schultern und gingen rücklings und bedeckten die Blöße ihres Vaters; und ihre Angesichter waren abgewandt, und sie sahen die Blöße ihres Vaters nicht. ");
INSERT INTO deuelo_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Und Noah erwachte von seinem Weine und erfuhr, was sein jüngster Sohn ihm getan hatte. ");
INSERT INTO deuelo_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Und er sprach: Verflucht sei Kanaan! Ein Knecht der Knechte sei er seinen Brüdern! ");
INSERT INTO deuelo_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Und er sprach: Gepriesen sei Jehova, der Gott Sems; und Kanaan sei sein Knecht! ");
INSERT INTO deuelo_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Weit mache es Gott dem Japhet, und er wohne in den Zelten Sems; und Kanaan sei sein Knecht! ");
INSERT INTO deuelo_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Und Noah lebte nach der Flut dreihundertfünfzig Jahre; ");
INSERT INTO deuelo_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","und alle Tage Noahs waren neunhundertfünfzig Jahre, und er starb. ");
INSERT INTO deuelo_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Und dies sind die Geschlechter der Söhne Noahs, Sem, Ham und Japhet: es wurden ihnen Söhne geboren nach der Flut. ");
INSERT INTO deuelo_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Die Söhne Japhets: Gomer und Magog und Madai und Jawan und Tubal und Mesech und Tiras. ");
INSERT INTO deuelo_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Und die Söhne Gomers: Askenas und Riphat und Togarma. ");
INSERT INTO deuelo_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Und die Söhne Jawans: Elisa und Tarsis, die Kittim und die Dodanim. ");
INSERT INTO deuelo_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Von diesen aus verteilten sich die Bewohner der Inseln der Nationen in ihren Ländern, eine jede nach ihrer Sprache, nach ihren Familien, in ihren Nationen. ");
INSERT INTO deuelo_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Und die Söhne Hams: Kusch und Mizraim und Put und Kanaan. ");
INSERT INTO deuelo_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Und die Söhne Kuschs: Seba und Hawila und Sabta und Raghma und Sabteka. Und die Söhne Raghmas: Scheba und Dedan. ");
INSERT INTO deuelo_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Und Kusch zeugte Nimrod; der fing an, ein Gewaltiger zu sein auf der Erde. ");
INSERT INTO deuelo_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Er war ein gewaltiger Jäger vor Jehova; darum sagt man: Wie Nimrod, ein gewaltiger Jäger vor Jehova! ");
INSERT INTO deuelo_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Und der Anfang seines Reiches war Babel und Erek und Akkad und Kalne im Lande Sinear. ");
INSERT INTO deuelo_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Von diesem Lande zog er aus nach Assur und baute Ninive und Rechobot-Ir und Kalach, ");
INSERT INTO deuelo_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","und Resen zwischen Ninive und Kalach: das ist die große Stadt. - ");
INSERT INTO deuelo_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Und Mizraim zeugte die Ludim und die Anamim und die Lehabim und die Naphtuchim ");
INSERT INTO deuelo_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","und die Pathrusim und die Kasluchim (von welchen die Philister ausgegangen sind,) und die Kaphtorim. ");
INSERT INTO deuelo_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Und Kanaan zeugte Zidon, seinen Erstgeborenen, und Heth, ");
INSERT INTO deuelo_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","und den Jebusiter und den Amoriter und den Girgasiter, ");
INSERT INTO deuelo_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","und den Hewiter und den Arkiter und den Siniter, ");
INSERT INTO deuelo_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","und den Arwaditer und den Zemariter und den Hamathiter. Und nachher haben sich die Familien der Kanaaniter zerstreut. ");
INSERT INTO deuelo_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Und das Gebiet der Kanaaniter erstreckte sich von Zidon nach Gerar hin, bis Gasa; nach Sodom und Gomorra und Adama und Zeboim hin, bis Lescha. - ");
INSERT INTO deuelo_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Das sind die Söhne Hams nach ihren Familien, nach ihren Sprachen, in ihren Ländern, in ihren Nationen. ");
INSERT INTO deuelo_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Und dem Sem, dem Vater aller Söhne Hebers, dem Bruder Japhets, des ältesten, auch ihm wurden Söhne geboren. ");
INSERT INTO deuelo_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Die Söhne Sems: Elam und Assur und Arpaksad und Lud und Aram. ");
INSERT INTO deuelo_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Und die Söhne Arams: Uz und Hul und Gether und Masch. ");
INSERT INTO deuelo_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Und Arpaksad zeugte Schelach, und Schelach zeugte Heber. ");
INSERT INTO deuelo_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Und dem Heber wurden zwei Söhne geboren: der Name des einen war Peleg, denn in seinen Tagen wurde die Erde verteilt; und der Name seines Bruders war Joktan. ");
INSERT INTO deuelo_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Und Joktan zeugte Almodad und Scheleph und Hazarmaweth und Jerach ");
INSERT INTO deuelo_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","und Hadoram und Usal und Dikla ");
INSERT INTO deuelo_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","und Obal und Abimael und Scheba ");
INSERT INTO deuelo_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","und Ophir und Hawila und Jobab; diese alle waren Söhne Joktans. ");
INSERT INTO deuelo_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Und ihr Wohnsitz war von Meschar nach Sephar hin, dem Gebirge des Ostens. - ");
INSERT INTO deuelo_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Das sind die Söhne Sems nach ihren Familien, nach ihren Sprachen, in ihren Ländern, nach ihren Nationen. ");
INSERT INTO deuelo_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Das sind die Familien der Söhne Noahs nach ihren Geschlechtern, in ihren Nationen; und von diesen aus haben sich nach der Flut die Nationen auf der Erde verteilt. ");
INSERT INTO deuelo_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Und die ganze Erde hatte eine Sprache und einerlei Worte. ");
INSERT INTO deuelo_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Und es geschah, als sie nach Osten zogen, da fanden sie eine Ebene im Lande Sinear und wohnten daselbst. ");
INSERT INTO deuelo_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Und sie sprachen einer zum anderen: Wohlan, laßt uns Ziegel streichen und hart brennen! Und der Ziegel diente ihnen als Stein, und das Erdharz diente ihnen als Mörtel. ");
INSERT INTO deuelo_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Und sie sprachen: Wohlan, bauen wir uns eine Stadt und einen Turm, dessen Spitze an den Himmel reiche, und machen wir uns einen Namen, daß wir nicht zerstreut werden über die ganze Erde! ");
INSERT INTO deuelo_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Und Jehova fuhr hernieder, die Stadt und den Turm zu sehen, welche die Menschenkinder bauten. ");
INSERT INTO deuelo_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Und Jehova sprach: Siehe, sie sind ein Volk und haben alle eine Sprache, und dies haben sie angefangen zu tun; und nun wird ihnen nichts verwehrt werden, was sie zu tun ersinnen. ");
INSERT INTO deuelo_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Wohlan, laßt uns herniederfahren und ihre Sprache daselbst verwirren, daß sie einer des anderen Sprache nicht verstehen! ");
INSERT INTO deuelo_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Und Jehova zerstreute sie von dannen über die ganze Erde; und sie hörten auf, die Stadt zu bauen. ");
INSERT INTO deuelo_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Darum gab man ihr den Namen Babel; denn daselbst verwirrte Jehova die Sprache der ganzen Erde, und von dannen zerstreute sie Jehova über die ganze Erde. ");
INSERT INTO deuelo_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Dies sind die Geschlechter Sems: Sem war hundert Jahre alt und zeugte Arpaksad, zwei Jahre nach der Flut. ");
INSERT INTO deuelo_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Und Sem lebte, nachdem er Arpaksad gezeugt hatte, fünfhundert Jahre und zeugte Söhne und Töchter. - ");
INSERT INTO deuelo_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Und Arpaksad lebte fünfunddreißig Jahre und zeugte Schelach. ");
INSERT INTO deuelo_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Und Arpaksad lebte, nachdem er Schelach gezeugt hatte, vierhundertdrei Jahre und zeugte Söhne und Töchter. - ");
INSERT INTO deuelo_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Und Schelach lebte dreißig Jahre und zeugte Heber. ");
INSERT INTO deuelo_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Und Schelach lebte, nachdem er Heber gezeugt hatte, vierhundertdrei Jahre und zeugte Söhne und Töchter. - ");
INSERT INTO deuelo_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Und Heber lebte vierunddreißig Jahre und zeugte Peleg. ");
INSERT INTO deuelo_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Und Heber lebte, nachdem er Peleg gezeugt hatte, vierhundertdreißig Jahre und zeugte Söhne und Töchter. - ");
INSERT INTO deuelo_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Und Peleg lebte dreißig Jahre und zeugte Reghu. ");
INSERT INTO deuelo_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Und Peleg lebte, nachdem er Reghu gezeugt hatte, zweihundertneun Jahre und zeugte Söhne und Töchter. - ");
INSERT INTO deuelo_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Und Reghu lebte zweiunddreißig Jahre und zeugte Serug. ");
INSERT INTO deuelo_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Und Reghu lebte, nachdem er Serug gezeugt hatte, zweihundertsieben Jahre und zeugte Söhne und Töchter. - ");
INSERT INTO deuelo_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Und Serug lebte dreißig Jahre und zeugte Nahor. ");
INSERT INTO deuelo_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Und Serug lebte, nachdem er Nahor gezeugt hatte, zweihundert Jahre und zeugte Söhne und Töchter. - ");
INSERT INTO deuelo_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Und Nahor lebte neunundzwanzig Jahre und zeugte Tarah. ");
INSERT INTO deuelo_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Und Nahor lebte, nachdem er Tarah gezeugt hatte, hundertneunzehn Jahre und zeugte Söhne und Töchter. - ");
INSERT INTO deuelo_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Und Tarah lebte siebzig Jahre und zeugte Abram, Nahor und Haran. ");
INSERT INTO deuelo_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Und dies sind die Geschlechter Tarahs: Tarah zeugte Abram, Nahor und Haran; und Haran zeugte Lot. ");
INSERT INTO deuelo_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Und Haran starb vor dem Angesicht seines Vaters Tarah, in dem Lande seiner Geburt, zu Ur in Chaldäa. ");
INSERT INTO deuelo_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Und Abram und Nahor nahmen sich Weiber; der Name des Weibes Abrams war Sarai, und der Name des Weibes Nahors Milka, die Tochter Harans, des Vaters der Milka und des Vaters der Jiska. ");
INSERT INTO deuelo_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Und Sarai war unfruchtbar, sie hatte kein Kind. ");
INSERT INTO deuelo_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Und Tarah nahm seinen Sohn Abram und Lot, den Sohn Harans, seines Sohnes Sohn, und Sarai, seine Schwiegertochter, das Weib seines Sohnes Abram; und sie zogen miteinander aus Ur in Chaldäa, um in das Land Kanaan zu gehen; und sie kamen bis Haran und wohnten daselbst. ");
INSERT INTO deuelo_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Und die Tage Tarahs waren zweihundertfünf Jahre, und Tarah starb in Haran. ");
INSERT INTO deuelo_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Und Jehova sprach zu Abram: Gehe aus deinem Lande und aus deiner Verwandtschaft und aus deines Vaters Hause, in das Land, das ich dir zeigen werde. ");
INSERT INTO deuelo_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Und ich will dich zu einer großen Nation machen und dich segnen, und ich will deinen Namen groß machen; und du sollst ein Segen sein! ");
INSERT INTO deuelo_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Und ich will segnen, die dich segnen, und wer dir flucht, den werde ich verfluchen; und in dir sollen gesegnet werden alle Geschlechter der Erde! ");
INSERT INTO deuelo_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Und Abram ging hin, wie Jehova zu ihm geredet hatte, und Lot ging mit ihm; und Abram war fünfundsiebzig Jahre alt, als er aus Haran zog. ");
INSERT INTO deuelo_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Und Abram nahm Sarai, sein Weib, und Lot, seines Bruders Sohn, und alle ihre Habe, die sie erworben, und die Seelen, die sie in Haran gewonnen hatten, und sie zogen aus, um in das Land Kanaan zu gehen; und sie kamen in das Land Kanaan. ");
INSERT INTO deuelo_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Und Abram durchzog das Land bis zu dem Orte Sichem, bis zur Terebinthe Mores. Und die Kanaaniter waren damals im Lande. ");
INSERT INTO deuelo_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Und Jehova erschien dem Abram und sprach: Deinem Samen will ich dieses Land geben. Und er baute daselbst Jehova, der ihm erschienen war, einen Altar. ");
INSERT INTO deuelo_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Und er brach auf von dannen nach dem Gebirge ostwärts von Bethel und schlug sein Zelt auf, Bethel gegen Westen und Ai gegen Osten; und er baute daselbst Jehova einen Altar und rief den Namen Jehovas an. ");
INSERT INTO deuelo_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Und Abram zog fort, immer weiter ziehend, nach dem Süden. ");
INSERT INTO deuelo_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Es entstand aber eine Hungersnot im Lande; und Abram zog nach Ägypten hinab, um sich daselbst aufzuhalten, denn die Hungersnot war schwer im Lande. ");
INSERT INTO deuelo_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Und es geschah, als er nahe daran war, nach Ägypten zu kommen, da sprach er zu Sarai, seinem Weibe: Siehe doch, ich weiß, daß du ein Weib, schön von Ansehen, bist; ");
INSERT INTO deuelo_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","und es wird geschehen, wenn die Ägypter dich sehen, so werden sie sagen: Sie ist sein Weib; und sie werden mich erschlagen und dich leben lassen. ");
INSERT INTO deuelo_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Sage doch, du seiest meine Schwester, auf daß es mir wohlgehe um deinetwillen und meine Seele am Leben bleibe deinethalben. ");
INSERT INTO deuelo_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Und es geschah, als Abram in Ägypten ankam, da sahen die Ägypter, daß das Weib sehr schön war. ");
INSERT INTO deuelo_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Und die Fürsten des Pharao sahen sie und priesen sie dem Pharao; und das Weib wurde in das Haus des Pharao geholt. ");
INSERT INTO deuelo_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Und er tat Abram Gutes um ihretwillen; und er bekam Kleinvieh und Rinder und Esel und Knechte und Mägde und Eselinnen und Kamele. ");
INSERT INTO deuelo_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Und Jehova schlug den Pharao und sein Haus mit großen Plagen um Sarais willen, des Weibes Abrams. ");
INSERT INTO deuelo_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Und der Pharao ließ Abram rufen und sprach: Was hast du mir da getan? Warum hast du mir nicht kundgetan, daß sie dein Weib ist? ");
INSERT INTO deuelo_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Warum hast du gesagt: Sie ist meine Schwester, so daß ich sie mir zum Weibe nahm? Und nun siehe, da ist dein Weib, nimm sie und gehe hin. ");
INSERT INTO deuelo_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Und der Pharao entbot seinetwegen Männer, und sie geleiteten ihn und sein Weib und alles, was er hatte. ");
INSERT INTO deuelo_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Und Abram zog herauf aus Ägypten, er und sein Weib und alles, was er hatte, und Lot mit ihm, nach dem Süden. ");
INSERT INTO deuelo_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Und Abram war sehr reich an Vieh, an Silber und an Gold. ");
INSERT INTO deuelo_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Und er ging auf seinen Zügen vom Süden bis Bethel, bis zu dem Orte, wo im Anfang sein Zelt gewesen war, zwischen Bethel und Ai, ");
INSERT INTO deuelo_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","zu der Stätte des Altars, den er zuvor daselbst gemacht hatte. Und Abram rief daselbst den Namen Jehovas an. ");
INSERT INTO deuelo_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Und auch Lot, der mit Abram zog, hatte Kleinvieh und Rinder und Zelte. ");
INSERT INTO deuelo_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Und das Land ertrug es nicht, daß sie beisammen wohnten; denn ihre Habe war groß, und sie konnten nicht beisammen wohnen. ");
INSERT INTO deuelo_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Und es gab Zank zwischen den Hirten von Abrams Vieh und den Hirten von Lots Vieh. Und die Kanaaniter und die Perisiter wohnten damals im Lande. ");
INSERT INTO deuelo_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Da sprach Abram zu Lot: Laß doch kein Gezänk sein zwischen mir und dir und zwischen meinen Hirten und deinen Hirten; denn wir sind Brüder! ");
INSERT INTO deuelo_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ist nicht das ganze Land vor dir? Trenne dich doch von mir! Willst du zur Linken, so will ich mich zur Rechten wenden, und willst du zur Rechten, so will ich mich zur Linken wenden. ");
INSERT INTO deuelo_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Und Lot hob seine Augen auf und sah die ganze Ebene des Jordan, daß sie ganz bewässert war (bevor Jehova Sodom und Gomorra zerstört hatte) gleich dem Garten Jehovas, wie das Land Ägypten, bis nach Zoar hin. ");
INSERT INTO deuelo_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Und Lot erwählte sich die ganze Ebene des Jordan, und Lot zog ostwärts; und sie trennten sich voneinander. ");
INSERT INTO deuelo_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram wohnte im Lande Kanaan, und Lot wohnte in den Städten der Ebene und schlug Zelte auf bis nach Sodom. ");
INSERT INTO deuelo_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Und die Leute von Sodom waren böse und große Sünder vor Jehova. ");
INSERT INTO deuelo_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Und Jehova sprach zu Abram, nachdem Lot sich von ihm getrennt hatte: Hebe doch deine Augen auf und schaue von dem Orte, wo du bist, gegen Norden und gegen Süden und gegen Osten und gegen Westen! ");
INSERT INTO deuelo_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Denn das ganze Land, das du siehst, dir will ich es geben und deinem Samen auf ewig. ");
INSERT INTO deuelo_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Und ich will deinen Samen machen wie den Staub der Erde, so daß, wenn jemand den Staub der Erde zu zählen vermag, auch dein Same gezählt werden wird. ");
INSERT INTO deuelo_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Mache dich auf und durchwandle das Land nach seiner Länge und nach seiner Breite; denn dir will ich es geben. ");
INSERT INTO deuelo_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Und Abram schlug Zelte auf, und kam und wohnte unter den Terebinthen Mamres, die bei Hebron sind; und er baute daselbst Jehova einen Altar. ");
INSERT INTO deuelo_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Und es geschah in den Tagen Amraphels, des Königs von Sinear, Ariochs, des Königs von Ellasar, Kedorlaomers, des Königs von Elam, und Thidhals, des Königs von Gojim, ");
INSERT INTO deuelo_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","daß sie Krieg führten mit Bera, dem Könige von Sodom, und mit Birscha, dem Könige von Gomorra, Schineab, dem Könige von Adama, und Schemeber, dem Könige von Zeboim, und mit dem Könige von Bela, das ist Zoar. ");
INSERT INTO deuelo_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Alle diese verbündeten sich und kamen in das Tal Siddim, das ist das Salzmeer. ");
INSERT INTO deuelo_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Zwölf Jahre hatten sie Kedorlaomer gedient, und im dreizehnten Jahre empörten sie sich. ");
INSERT INTO deuelo_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Und im vierzehnten Jahre kamen Kedorlaomer und die Könige, die mit ihm waren, und schlugen die Rephaim zu Asteroth-Karnaim und die Susim zu Ham und die Emim in der Ebene von Kirjathaim, ");
INSERT INTO deuelo_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","und die Horiter auf ihrem Gebirge Seir bis El-Paran, das an der Wüste liegt. ");
INSERT INTO deuelo_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Und sie wandten sich und kamen nach En-Mischpat, das ist Kades; und sie schlugen das ganze Gefilde der Amalekiter und auch die Amoriter, die zu Hazazon-Tamar wohnten. ");
INSERT INTO deuelo_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Und es zogen aus der König von Sodom und der König von Gomorra und der König von Adama und der König von Zeboim und der König von Bela, das ist Zoar; und sie stellten sich gegen sie in Schlachtordnung auf im Tale Siddim: ");
INSERT INTO deuelo_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","gegen Kedorlaomer, den König von Elam, und Thidhal, den König von Gojim, und Amraphel, den König von Sinear, und Arioch, den König von Ellasar, vier Könige gegen die fünf. ");
INSERT INTO deuelo_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Das Tal Siddim war aber voll von Erdharzquellen; und die Könige von Sodom und Gomorra flohen und fielen daselbst, und die übrigen flohen ins Gebirge. ");
INSERT INTO deuelo_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Und sie nahmen alle Habe von Sodom und Gomorra und alle ihre Speise und zogen davon. ");
INSERT INTO deuelo_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Und sie nahmen Lot, Abrams Bruders Sohn, und seine Habe und zogen davon; denn er wohnte in Sodom. ");
INSERT INTO deuelo_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Und es kam ein Entronnener und berichtete es Abram, dem Hebräer; er wohnte aber unter den Terebinthen Mamres, des Amoriters, des Bruders von Eskol und des Bruders von Aner, und diese waren Abrams Bundesgenossen. ");
INSERT INTO deuelo_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Und als Abram hörte, daß sein Bruder gefangen weggeführt war, ließ er seine Geübten, seine Hausgeborenen, ausrücken, dreihundertachtzehn Mann, und jagte ihnen nach bis Dan. ");
INSERT INTO deuelo_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Und er teilte sich wider sie des Nachts, er und seine Knechte, und schlug sie und jagte ihnen nach bis Hoba, das zur Linken von Damaskus liegt. ");
INSERT INTO deuelo_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Und er brachte alle Habe zurück; und auch Lot, seinen Bruder, und dessen Habe brachte er zurück, und auch die Weiber und das Volk. ");
INSERT INTO deuelo_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Und als er zurückgekehrt war, nachdem er Kedorlaomer und die Könige, die mit ihm gewesen, geschlagen hatte, zog der König von Sodom aus, ihm entgegen, in das Tal Schawe, das ist das Königstal. ");
INSERT INTO deuelo_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Und Melchisedek, König von Salem, brachte Brot und Wein heraus; und er war Priester Gottes, des Höchsten. ");
INSERT INTO deuelo_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Und er segnete ihn und sprach: Gesegnet sei Abram von Gott, dem Höchsten, der Himmel und Erde besitzt! ");
INSERT INTO deuelo_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Und gepriesen sei Gott, der Höchste, der deine Feinde in deine Hand geliefert hat! Und Abram gab ihm den Zehnten von allem. ");
INSERT INTO deuelo_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Und der König von Sodom sprach zu Abram: Gib mir die Seelen, und die Habe nimm für dich. ");
INSERT INTO deuelo_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Und Abram sprach zu dem König von Sodom: Ich hebe meine Hand auf zu Jehova, zu Gott, dem Höchsten, der Himmel und Erde besitzt: ");
INSERT INTO deuelo_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Wenn vom Faden bis zum Schuhriemen, ja, wenn ich irgend etwas nehme von dem, was dein ist...! Auf daß du nicht sagest: Ich habe Abram reich gemacht. ");
INSERT INTO deuelo_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Nichts für mich! Nur was die Knaben verzehrt haben, und das Teil der Männer, die mit mir gezogen sind: Aner, Eskol und Mamre, die mögen ihr Teil nehmen! ");
INSERT INTO deuelo_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Nach diesen Dingen geschah das Wort Jehovas zu Abram in einem Gesicht also: Fürchte dich nicht, Abram; ich bin dir ein Schild, dein sehr großer Lohn. ");
INSERT INTO deuelo_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Und Abram sprach: Herr, Jehova, was willst du mir geben? Ich gehe ja kinderlos dahin, und der Erbe meines Hauses, das ist Elieser von Damaskus. ");
INSERT INTO deuelo_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Und Abram sprach: Siehe, mir hast du keinen Samen gegeben, und siehe, der Sohn meines Hauses wird mich beerben. ");
INSERT INTO deuelo_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Und siehe, das Wort Jehovas geschah zu ihm also: Nicht dieser wird dich beerben, sondern der aus deinem Leibe hervorgehen wird, der wird dich beerben. ");
INSERT INTO deuelo_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Und er führte ihn hinaus und sprach: Blicke doch gen Himmel und zähle die Sterne, wenn du sie zählen kannst! Und er sprach zu ihm: Also wird dein Same sein! ");
INSERT INTO deuelo_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Und er glaubte Jehova; und er rechnete es ihm zur Gerechtigkeit. ");
INSERT INTO deuelo_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Und er sprach zu ihm: Ich bin Jehova, der dich herausgeführt hat aus Ur in Chaldäa, um dir dieses Land zu geben, es zu besitzen. ");
INSERT INTO deuelo_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Und er sprach: Herr, Jehova, woran soll ich erkennen, daß ich es besitzen werde? ");
INSERT INTO deuelo_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Da sprach er zu ihm: Hole mir eine dreijährige Färse und eine dreijährige Ziege und einen dreijährigen Widder und eine Turteltaube und eine junge Taube. ");
INSERT INTO deuelo_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Und er holte ihm diese alle und zerteilte sie in der Mitte und legte die Hälfte eines jeden der anderen gegenüber; aber das Geflügel zerteilte er nicht. ");
INSERT INTO deuelo_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Und die Raubvögel stürzten auf die Äser herab; und Abram scheuchte sie hinweg. ");
INSERT INTO deuelo_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Und es geschah, als die Sonne untergehen wollte, da fiel ein tiefer Schlaf auf Abram; und siehe, Schrecken, dichte Finsternis überfiel ihn. ");
INSERT INTO deuelo_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Und er sprach zu Abram: Gewißlich sollst du wissen, daß dein Same ein Fremdling sein wird in einem Lande, das nicht das ihre ist; und sie werden ihnen dienen, und sie werden sie bedrücken vierhundert Jahre. ");
INSERT INTO deuelo_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Aber ich werde die Nation auch richten, welcher sie dienen werden; und danach werden sie ausziehen mit großer Habe. ");
INSERT INTO deuelo_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Und du, du wirst zu deinen Vätern eingehen in Frieden, wirst begraben werden in gutem Alter. ");
INSERT INTO deuelo_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Und im vierten Geschlecht werden sie hierher zurückkehren; denn die Ungerechtigkeit der Amoriter ist bis hierher noch nicht voll. ");
INSERT INTO deuelo_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Und es geschah, als die Sonne untergegangen und dichte Finsternis geworden war, siehe da, ein rauchender Ofen und eine Feuerflamme, die zwischen jenen Stücken hindurchfuhr. ");
INSERT INTO deuelo_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","An selbigem Tage machte Jehova einen Bund mit Abram und sprach: Deinem Samen gebe ich dieses Land vom Strome Ägyptens bis an den großen Strom, den Strom Phrath: ");
INSERT INTO deuelo_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","die Keniter und die Kenisiter und die Kadmoniter ");
INSERT INTO deuelo_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","und die Hethiter und die Perisiter und die Rephaim, ");
INSERT INTO deuelo_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","und die Amoriter und die Kanaaniter und die Girgasiter und die Jebusiter. ");
INSERT INTO deuelo_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Und Sarai, Abrams Weib, gebar ihm nicht. Und sie hatte eine ägyptische Magd, und ihr Name war Hagar. ");
INSERT INTO deuelo_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Und Sarai sprach zu Abram: Siehe doch, Jehova hat mich verschlossen, daß ich nicht gebäre; gehe doch ein zu meiner Magd, vielleicht werde ich aus ihr erbaut werden. Und Abram hörte auf die Stimme Sarais. ");
INSERT INTO deuelo_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Und Sarai, Abrams Weib, nahm Hagar, die Ägypterin, ihre Magd, nach Verlauf von zehn Jahren, die Abram im Lande Kanaan gewohnt hatte, und gab sie Abram, ihrem Manne, ihm zum Weibe. ");
INSERT INTO deuelo_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Und er ging zu Hagar ein, und sie ward schwanger; und als sie sah, daß sie schwanger war, da wurde ihre Herrin gering in ihren Augen. ");
INSERT INTO deuelo_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Und Sarai sprach zu Abram: Das Unrecht, das mir widerfährt, fällt auf dich! Ich habe meine Magd in deinen Schoß gegeben; und da sie sieht, daß sie schwanger geworden ist, bin ich gering in ihren Augen. Jehova richte zwischen mir und dir! ");
INSERT INTO deuelo_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Und Abram sprach zu Sarai: Siehe, deine Magd ist in deiner Hand; tue ihr, was gut ist in deinen Augen. Und Sarai behandelte sie hart, und sie floh von ihr hinweg. ");
INSERT INTO deuelo_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Und der Engel Jehovas fand sie an einer Wasserquelle in der Wüste, an der Quelle auf dem Wege nach Sur. ");
INSERT INTO deuelo_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Und er sprach: Hagar, Magd Sarais, woher kommst du, und wohin gehst du? Und sie sprach: Ich fliehe hinweg von meiner Herrin Sarai. ");
INSERT INTO deuelo_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Und der Engel Jehovas sprach zu ihr: Kehre zu deiner Herrin zurück und demütige dich unter ihre Hände. ");
INSERT INTO deuelo_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Und der Engel Jehovas sprach zu ihr: Ich will sehr mehren deinen Samen, daß er nicht gezählt werden soll vor Menge. ");
INSERT INTO deuelo_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Und der Engel Jehovas sprach zu ihr: Siehe, du bist schwanger und wirst einen Sohn gebären; und du sollst ihm den Namen Ismael geben, denn Jehova hat auf dein Elend gehört. ");
INSERT INTO deuelo_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Und er, er wird ein Wildesel von Mensch sein; seine Hand wider alle und die Hand aller wider ihn, und angesichts aller seiner Brüder wird er wohnen. ");
INSERT INTO deuelo_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Da nannte sie Jehova, der zu ihr redete: Du bist ein Gott, der sich schauen läßt! Denn sie sprach: Habe ich nicht auch hier geschaut, nachdem er sich hat schauen lassen? ");
INSERT INTO deuelo_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Darum nannte man den Brunnen: Beer-Lachai-Roi; siehe, er ist zwischen Kades und Bered. ");
INSERT INTO deuelo_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Und Hagar gebar dem Abram einen Sohn; und Abram gab seinem Sohne, den Hagar geboren hatte, den Namen Ismael. ");
INSERT INTO deuelo_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Und Abram war sechsundachtzig Jahre alt, als Hagar dem Abram Ismael gebar. ");
INSERT INTO deuelo_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Und Abram war neunundneunzig Jahre alt, da erschien Jehova dem Abram und sprach zu ihm: Ich bin Gott, der Allmächtige; wandle vor meinem Angesicht und sei vollkommen. ");
INSERT INTO deuelo_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Und ich will meinen Bund setzen zwischen mir und dir und will dich sehr, sehr mehren. ");
INSERT INTO deuelo_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Da fiel Abram auf sein Angesicht, und Gott redete mit ihm und sprach: ");
INSERT INTO deuelo_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Ich, siehe, mein Bund ist mit dir, und du wirst zum Vater einer Menge Nationen werden. ");
INSERT INTO deuelo_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Und nicht soll hinfort dein Name Abram heißen, sondern Abraham soll dein Name sein; denn zum Vater einer Menge Nationen habe ich dich gemacht. ");
INSERT INTO deuelo_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Und ich werde dich sehr, sehr fruchtbar machen, und ich werde dich zu Nationen machen, und Könige sollen aus dir hervorkommen. ");
INSERT INTO deuelo_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Und ich werde meinen Bund errichten zwischen mir und dir und deinen Samen nach dir, nach ihren Geschlechtern, zu einem ewigen Bunde, um dir zum Gott zu sein und deinem Samen nach dir. ");
INSERT INTO deuelo_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Und ich werde dir und deinem Samen nach dir das Land deiner Fremdlingschaft geben, das ganze Land Kanaan, zum ewigen Besitztum, und ich werde ihr Gott sein. ");
INSERT INTO deuelo_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Und Gott sprach zu Abraham: Und du, du sollst meinen Bund halten, du und dein Same nach dir, nach ihren Geschlechtern. ");
INSERT INTO deuelo_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Dies ist mein Bund, den ihr halten sollt zwischen mir und euch und deinem Samen nach dir: alles Männliche werde bei euch beschnitten; ");
INSERT INTO deuelo_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","und ihr sollt das Fleisch eurer Vorhaut beschneiden. Und das soll das Zeichen des Bundes sein zwischen mir und euch. ");
INSERT INTO deuelo_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Und acht Tage alt soll alles Männliche bei euch beschnitten werden nach euren Geschlechtern, der Hausgeborene und der für Geld Erkaufte, von allen Fremden, die nicht von deinem Samen sind; ");
INSERT INTO deuelo_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","es soll gewißlich beschnitten werden dein Hausgeborener und der für dein Geld Erkaufte. Und mein Bund soll an eurem Fleische sein als ein ewiger Bund. ");
INSERT INTO deuelo_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Und der unbeschnittene Männliche, der am Fleische seiner Vorhaut nicht beschnitten wird, selbige Seele soll ausgerottet werden aus ihrem Volke; meinen Bund hat er gebrochen! ");
INSERT INTO deuelo_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Und Gott sprach zu Abraham: Sarai, dein Weib, sollst du nicht Sarai nennen, sondern Sara soll ihr Name sein. ");
INSERT INTO deuelo_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Und ich werde sie segnen, und auch von ihr gebe ich dir einen Sohn; und ich werde sie segnen, und sie wird zu Nationen werden; Könige von Völkern sollen aus ihr kommen. ");
INSERT INTO deuelo_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Und Abraham fiel auf sein Angesicht und lachte und sprach in seinem Herzen: Sollte einem Hundertjährigen geboren werden, und sollte Sara, sollte eine Neunzigjährige gebären? ");
INSERT INTO deuelo_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Und Abraham sprach zu Gott: Möchte doch Ismael vor dir leben! ");
INSERT INTO deuelo_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Und Gott sprach: Fürwahr, Sara, dein Weib, wird dir einen Sohn gebären, und du sollst ihm den Namen Isaak geben; und ich werde meinen Bund mit ihm errichten zu einem ewigen Bunde für seinen Samen nach ihm. ");
INSERT INTO deuelo_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Und um Ismael habe ich dich erhört: Siehe, ich habe ihn gesegnet und werde ihn fruchtbar machen und ihn sehr, sehr mehren; zwölf Fürsten wird er zeugen, und ich werde ihn zu einer großen Nation machen. ");
INSERT INTO deuelo_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Aber meinen Bund werde ich mit Isaak errichten, den Sara dir gebären wird um diese bestimmte Zeit im folgenden Jahre. - ");
INSERT INTO deuelo_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Und er hörte auf mit ihm zu reden; und Gott fuhr auf von Abraham. ");
INSERT INTO deuelo_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Und Abraham nahm Ismael, seinen Sohn, und alle seine Hausgeborenen und alle mit seinem Geld Erkauften, alles Männliche unter den Hausleuten Abrahams, und beschnitt das Fleisch ihrer Vorhaut an diesem selbigen Tage, wie Gott zu ihm geredet hatte. ");
INSERT INTO deuelo_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Und Abraham war neunundneunzig Jahre alt, als er am Fleische seiner Vorhaut beschnitten wurde. ");
INSERT INTO deuelo_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Und Ismael, sein Sohn, war dreizehn Jahre alt, als er am Fleische seiner Vorhaut beschnitten wurde. ");
INSERT INTO deuelo_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","An diesem selbigen Tage wurde Abraham beschnitten und Ismael, sein Sohn; ");
INSERT INTO deuelo_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Und alle Männer seines Hauses, der Hausgeborene und der für Geld Erkaufte, von den Fremden, wurden mit ihm beschnitten. ");
INSERT INTO deuelo_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Und Jehova erschien ihm bei den Terebinthen Mamres; und er saß an dem Eingang des Zeltes bei der Hitze des Tages. ");
INSERT INTO deuelo_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Und er hob seine Augen auf und sah: und siehe, drei Männer standen vor ihm; und als er sie sah, lief er ihnen entgegen von dem Eingang des Zeltes und beugte sich nieder zur Erde; ");
INSERT INTO deuelo_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","und er sprach: Herr, wenn ich anders Gnade gefunden habe in deinen Augen, so gehe doch nicht an deinem Knechte vorüber! ");
INSERT INTO deuelo_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Es werde doch ein wenig Wasser geholt, und waschet eure Füße; und lagert euch unter dem Baume, ");
INSERT INTO deuelo_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","und ich will einen Bissen Brot holen, und stärket euer Herz; danach möget ihr weitergehen; da ihr nun einmal vorbeigekommen seid bei eurem Knechte. Und sie sprachen: Tue also, wie du geredet hast. ");
INSERT INTO deuelo_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Da eilte Abraham ins Zelt zu Sara und sprach: Nimm schnell drei Maß Feinmehl, knete und mache Kuchen! ");
INSERT INTO deuelo_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Und Abraham lief zu den Rindern und nahm ein Kalb, zart und gut, und gab es dem Knaben; und der beeilte sich, es zuzubereiten. ");
INSERT INTO deuelo_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Und er holte dicke und süße Milch und das Kalb, das er zubereitet hatte, und setzte es ihnen vor; und er stand vor ihnen unter dem Baume, und sie aßen. ");
INSERT INTO deuelo_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Und sie sprachen zu ihm: Wo ist Sara, dein Weib? Und er sprach: Siehe, im Zelte. ");
INSERT INTO deuelo_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Und er sprach: Gewißlich werde ich übers Jahr wieder zu dir kommen, und siehe, Sara, dein Weib, wird einen Sohn haben. Und Sara horchte am Eingang des Zeltes, der hinter ihm war. ");
INSERT INTO deuelo_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Und Abraham und Sara waren alt, wohlbetagt; es hatte aufgehört, Sara zu ergehen nach der Weiber Weise. ");
INSERT INTO deuelo_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Und Sara lachte in ihrem Innern und sprach: Nachdem ich alt geworden bin, sollte ich Wollust haben? Und mein Herr ist ja alt! ");
INSERT INTO deuelo_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Und Jehova sprach zu Abraham: Warum hat Sara denn gelacht und gesagt: Sollte ich auch wirklich gebären, da ich doch alt bin? ");
INSERT INTO deuelo_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ist für Jehova eine Sache zu wunderbar? Zur bestimmten Zeit übers Jahr werde ich wieder zu dir kommen, und Sara wird einen Sohn haben. ");
INSERT INTO deuelo_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Und Sara leugnete und sprach: Ich habe nicht gelacht! denn sie fürchtete sich. Er aber sprach: Nein, sondern du hast gelacht. ");
INSERT INTO deuelo_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Und die Männer erhoben sich von dannen und blickten hin nach Sodom; und Abraham ging mit ihnen, sie zu geleiten. ");
INSERT INTO deuelo_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Und Jehova sprach: Sollte ich vor Abraham verbergen, was ich tun will? ");
INSERT INTO deuelo_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Wird doch Abraham gewißlich zu einer großen und mächtigen Nation werden, und sollen doch in ihm gesegnet werden alle Nationen der Erde! ");
INSERT INTO deuelo_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Denn ich habe ihn erkannt, auf daß er seinen Kindern und seinem Hause nach ihm befehle, daß sie den Weg Jehovas bewahren, Gerechtigkeit und Recht zu üben, damit Jehova auf Abraham kommen lasse, was er über ihn geredet hat. ");
INSERT INTO deuelo_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Und Jehova sprach: Weil das Geschrei von Sodom und Gomorra groß, und weil ihre Sünde sehr schwer ist, ");
INSERT INTO deuelo_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","so will ich doch hinabgehen und sehen, ob sie nach ihrem Geschrei, das vor mich gekommen ist, völlig getan haben; und wenn nicht, so will ich's wissen. ");
INSERT INTO deuelo_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Und die Männer wandten sich von dannen und gingen nach Sodom; Abraham aber blieb noch vor Jehova stehen. ");
INSERT INTO deuelo_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Und Abraham trat hinzu und sprach: Willst du denn den Gerechten mit dem Gesetzlosen wegraffen? ");
INSERT INTO deuelo_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Vielleicht sind fünfzig Gerechte innerhalb der Stadt; willst du sie denn wegraffen und dem Orte nicht vergeben um der fünfzig Gerechten willen, die darin sind? ");
INSERT INTO deuelo_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Fern sei es von dir, so etwas zu tun, den Gerechten mit dem Gesetzlosen zu töten, so daß der Gerechte sei wie der Gesetzlose; fern sei es von dir! Sollte der Richter der ganzen Erde nicht Recht üben? ");
INSERT INTO deuelo_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Und Jehova sprach: Wenn ich in Sodom, innerhalb der Stadt, fünfzig Gerechte finde, so will ich um ihretwillen dem ganzen Orte vergeben. ");
INSERT INTO deuelo_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Und Abraham antwortete und sprach: Siehe doch, ich habe mich unterwunden zu dem Herrn zu reden, und ich bin Staub und Asche. ");
INSERT INTO deuelo_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Vielleicht mögen an den fünfzig Gerechten fünf fehlen; willst du wegen der fünf die ganze Stadt verderben? Und er sprach: Ich will sie nicht verderben, wenn ich fünfundvierzig daselbst finde. ");
INSERT INTO deuelo_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Und er fuhr fort, weiter zu ihm zu reden, und sprach: Vielleicht mögen vierzig daselbst gefunden werden. Und er sprach: Ich will es nicht tun um der vierzig willen. ");
INSERT INTO deuelo_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Und er sprach: Möge doch der Herr nicht zürnen, und ich will reden. Vielleicht mögen dreißig daselbst gefunden werden. Und er sprach: Ich will es nicht tun, wenn ich dreißig daselbst finde. ");
INSERT INTO deuelo_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Und er sprach: Siehe doch, ich habe mich unterwunden, zu dem Herrn zu reden; vielleicht mögen zwanzig daselbst gefunden werden. Und er sprach: Ich will nicht verderben um der zwanzig willen. ");
INSERT INTO deuelo_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Und er sprach: Möge doch der Herr nicht zürnen, und ich will nur noch diesmal reden. Vielleicht mögen zehn daselbst gefunden werden. Und er sprach: Ich will nicht verderben um der zehn willen. ");
INSERT INTO deuelo_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Und Jehova ging weg, als er mit Abraham ausgeredet hatte; und Abraham kehrte zurück an seinen Ort. ");
INSERT INTO deuelo_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Und die beiden Engel kamen am Abend nach Sodom; und Lot saß im Tore Sodoms. Und als Lot sie sah, stand er auf, ihnen entgegen, und beugte sich nieder, mit dem Angesicht zur Erde; ");
INSERT INTO deuelo_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","und er sprach: Ach siehe, meine Herren! Kehret doch ein in das Haus eures Knechtes und übernachtet und waschet eure Füße; und ihr machet euch früh auf und gehet eures Weges. Aber sie sprachen: Nein, sondern wir wollen auf dem Platze übernachten. ");
INSERT INTO deuelo_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Und er drang sehr in sie; und sie kehrten bei ihm ein und kamen in sein Haus. Und er machte ihnen ein Mahl, und er backte ungesäuerte Kuchen, und sie aßen. ");
INSERT INTO deuelo_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Noch hatten sie sich nicht niedergelegt, da umringten die Männer der Stadt, die Männer von Sodom, das Haus, vom Jüngling bis zum Greise, das ganze Volk insgesamt. ");
INSERT INTO deuelo_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Und sie riefen Lot und sprachen zu ihm: Wo sind die Männer, die diese Nacht zu dir gekommen sind? Führe sie zu uns heraus, daß wir sie erkennen! ");
INSERT INTO deuelo_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Und Lot trat zu ihnen hinaus an den Eingang und schloß die Tür hinter sich zu; ");
INSERT INTO deuelo_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","und er sprach: Tut doch nicht übel, meine Brüder! ");
INSERT INTO deuelo_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Siehe doch, ich habe zwei Töchter, die keinen Mann erkannt haben; laßt mich sie doch zu euch herausbringen, und tut ihnen, wie es gut ist in euren Augen; allein diesen Männern tut nichts, da sie nun einmal unter den Schatten meines Daches gekommen sind. ");
INSERT INTO deuelo_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Aber sie sprachen: Zurück da! Und sie sprachen: Der eine da ist gekommen, als Fremdling hier zu weilen, und will den Richter machen? Nun, wir wollen dir ärger tun als jenen. Und sie drangen hart ein auf den Mann, auf Lot, und traten herzu, die Tür zu erbrechen. ");
INSERT INTO deuelo_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Und die Männer streckten ihre Hand aus und brachten Lot zu sich herein ins Haus und verschlossen die Tür. ");
INSERT INTO deuelo_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Und die Männer, die am Eingang des Hauses waren, schlugen sie mit Blindheit, vom kleinsten bis zum größten; und sie wurden müde, den Eingang zu finden. ");
INSERT INTO deuelo_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Und die Männer sprachen zu Lot: Wen du noch hier hast, einen Schwiegersohn und deine Söhne und deine Töchter und wen irgend du in der Stadt hast, führe hinaus aus diesem Orte! ");
INSERT INTO deuelo_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Denn wir wollen diesen Ort verderben, weil ihr Geschrei groß geworden ist vor Jehova; und Jehova hat uns gesandt, die Stadt zu verderben. ");
INSERT INTO deuelo_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Und Lot ging hinaus und redete zu seinen Schwiegersöhnen, die seine Töchter genommen hatten, und sprach: Machet euch auf, gehet aus diesem Orte; denn Jehova will die Stadt verderben. Aber er war in den Augen seiner Schwiegersöhne wie einer, der Scherz treibt. ");
INSERT INTO deuelo_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Und sowie die Morgenröte aufging, da drangen die Engel in Lot und sprachen: Mache dich auf, nimm dein Weib und deine zwei Töchter, die vorhanden sind, damit du nicht weggerafft werdest in der Ungerechtigkeit der Stadt! ");
INSERT INTO deuelo_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Und als er zögerte, ergriffen die Männer seine Hand und die Hand seines Weibes und die Hand seiner zwei Töchter, weil Jehova sich seiner erbarmte, und führten ihn hinaus und ließen ihn außerhalb der Stadt. ");
INSERT INTO deuelo_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Und es geschah, als sie sie hinausgeführt hatten ins Freie, da sprach er: Rette dich um deines Lebens willen; sieh nicht hinter dich, und bleibe nicht stehen in der ganzen Ebene; rette dich auf das Gebirge, damit du nicht weggerafft werdest! ");
INSERT INTO deuelo_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Und Lot sprach zu ihnen: Nicht doch, Herr! ");
INSERT INTO deuelo_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Siehe doch, dein Knecht hat Gnade gefunden in deinen Augen, und du hast deine Güte groß gemacht, die du an mir erwiesen hast, meine Seele am Leben zu erhalten; aber ich kann mich nicht auf das Gebirge retten, es möchte mich das Unglück erhaschen, daß ich stürbe. ");
INSERT INTO deuelo_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Siehe doch, diese Stadt ist nahe, um dahin zu fliehen, und sie ist klein; laß mich doch dahin mich retten (ist sie nicht klein?), damit meine Seele am Leben bleibe. ");
INSERT INTO deuelo_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Und er sprach zu ihm: Siehe, auch in diesem Stücke habe ich dich angesehen, daß ich die Stadt nicht umkehre, von der du geredet hast. ");
INSERT INTO deuelo_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Eile, rette dich dorthin; denn ich kann nichts tun, bis du dorthin gekommen bist. Daher hat man der Stadt den Namen Zoar gegeben. ");
INSERT INTO deuelo_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Die Sonne ging auf über der Erde, als Lot in Zoar ankam. ");
INSERT INTO deuelo_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Und Jehova ließ auf Sodom und auf Gomorra Schwefel und Feuer regnen von Jehova aus dem Himmel; ");
INSERT INTO deuelo_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","und er kehrte diese Städte um und die ganze Ebene und alle Bewohner der Städte und das Gewächs des Erdbodens. ");
INSERT INTO deuelo_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Und sein Weib sah sich hinter ihm um und ward zu einer Salzsäule. ");
INSERT INTO deuelo_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Und Abraham machte sich des Morgens früh auf an den Ort, wo er vor Jehova gestanden hatte; ");
INSERT INTO deuelo_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Und er blickte hin nach Sodom und Gomorra und nach dem ganzen Lande der Ebene; und er sah: und siehe, ein Rauch stieg auf von der Erde, wie der Rauch eines Schmelzofens. ");
INSERT INTO deuelo_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Und es geschah, als Gott die Städte der Ebene verderbte, da gedachte Gott des Abraham und entsandte Lot mitten aus der Umkehrung, als er die Städte umkehrte, in welchen Lot gewohnt hatte. ");
INSERT INTO deuelo_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Und Lot zog hinauf von Zoar und wohnte im Gebirge, und seine beiden Töchter mit ihm; denn er fürchtete sich, in Zoar zu wohnen. Und er wohnte in einer Höhle, er und seine beiden Töchter. ");
INSERT INTO deuelo_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Und die Erstgeborene sprach zu der Jüngeren: Unser Vater ist alt, und kein Mann ist im Lande, um zu uns einzugehen nach der Weise aller Welt. ");
INSERT INTO deuelo_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Komm, laß uns unserem Vater Wein zu trinken geben und bei ihm liegen, damit wir von unserem Vater Samen am Leben erhalten. ");
INSERT INTO deuelo_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Und sie gaben ihrem Vater Wein zu trinken in selbiger Nacht, und die Erstgeborene ging hinein und lag bei ihrem Vater; und er wußte weder um ihr Niederlegen noch um ihr Aufstehen. ");
INSERT INTO deuelo_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Und es geschah am Morgen, da sprach die Erstgeborene zu der Jüngeren: Siehe, ich habe gestern Nacht bei meinem Vater gelegen; laß uns ihm auch diese Nacht Wein zu trinken geben, und gehe hinein, liege bei ihm, damit wir von unserem Vater Samen am Leben erhalten. ");
INSERT INTO deuelo_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Und sie gaben auch in selbiger Nacht ihrem Vater Wein zu trinken, und die Jüngere stand auf und lag bei ihm; und er wußte weder um ihr Niederlegen noch um ihr Aufstehen. ");
INSERT INTO deuelo_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Und die beiden Töchter Lots wurden schwanger von ihrem Vater. ");
INSERT INTO deuelo_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Und die Erstgeborene gebar einen Sohn, und sie gab ihm den Namen Moab; dieser ist der Vater der Moabiter bis auf diesen Tag. ");
INSERT INTO deuelo_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Und die Jüngere, auch sie gebar einen Sohn, und sie gab ihm den Namen Ben Ammi; dieser ist der Vater der Kinder Ammon bis auf diesen Tag. ");
INSERT INTO deuelo_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Und Abraham brach auf von dannen nach dem Lande des Südens und wohnte zwischen Kades und Sur; und er hielt sich auf zu Gerar. ");
INSERT INTO deuelo_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Und Abraham sagte von Sara, seinem Weibe: Sie ist meine Schwester. Da sandte Abimelech, der König von Gerar, und ließ Sara holen. ");
INSERT INTO deuelo_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Und Gott kam zu Abimelech in einem Traume der Nacht und sprach zu ihm: Siehe, du bist des Todes wegen des Weibes, das du genommen hast; denn sie ist eines Mannes Eheweib. ");
INSERT INTO deuelo_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimelech aber hatte sich ihr nicht genaht; und er sprach: Herr, willst du auch eine gerechte Nation töten? ");
INSERT INTO deuelo_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Hat er nicht zu mir gesagt: Sie ist meine Schwester? Und auch sie selbst hat gesagt: Er ist mein Bruder. In Lauterkeit meines Herzens und in Unschuld meiner Hände habe ich dies getan. ");
INSERT INTO deuelo_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Und Gott sprach zu ihm im Traume: Auch ich weiß, daß du in Lauterkeit deines Herzens dies getan hast, und so habe ich dich auch davon abgehalten, gegen mich zu sündigen; darum habe ich dir nicht gestattet, sie zu berühren. ");
INSERT INTO deuelo_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Und nun gib das Weib des Mannes zurück; denn er ist ein Prophet und wird für dich bitten, und du wirst am Leben bleiben. Wenn du sie aber nicht zurückgibst, so wisse, daß du gewißlich sterben wirst, du und alles, was dein ist! ");
INSERT INTO deuelo_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Und Abimelech stand des Morgens früh auf und rief alle seine Knechte und redete alle diese Worte vor ihren Ohren; und die Männer fürchteten sich sehr. ");
INSERT INTO deuelo_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Und Abimelech rief Abraham und sprach zu ihm: Was hast du uns angetan! Und was habe ich wider dich gesündigt, daß du über mich und über mein Reich eine große Sünde gebracht hast? Dinge, die nicht getan werden sollten, hast du mir angetan. ");
INSERT INTO deuelo_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Und Abimelech sprach zu Abraham: Was hast du beabsichtigt, daß du dies getan hast? ");
INSERT INTO deuelo_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Und Abraham sprach: Weil ich mir sagte: Gewiß ist keine Gottesfurcht an diesem Orte, und sie werden mich töten um meines Weibes willen. ");
INSERT INTO deuelo_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Auch ist sie wahrhaftig meine Schwester, die Tochter meines Vaters, nur nicht die Tochter meiner Mutter; und sie ist mein Weib geworden. ");
INSERT INTO deuelo_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Und es geschah, als Gott mich wandern ließ aus meines Vaters Hause, da sprach ich zu ihr: Dies sei deine Güte, die du mir erweisen mögest; an jedem Orte, wohin wir kommen werden, sage von mir: Er ist mein Bruder. ");
INSERT INTO deuelo_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Da nahm Abimelech Kleinvieh und Rinder und Knechte und Mägde und gab sie dem Abraham; und er gab ihm Sara, sein Weib, zurück. ");
INSERT INTO deuelo_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Und Abimelech sprach: Siehe, mein Land ist vor dir; wohne, wo es gut ist in deinen Augen. ");
INSERT INTO deuelo_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Und zu Sara sprach er: Siehe, ich habe deinem Bruder tausend Silbersekel gegeben; siehe, das sei dir eine Augendecke vor allen, die bei dir sind, und in Bezug auf alles ist die Sache rechtlich geschlichtet. ");
INSERT INTO deuelo_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Und Abraham betete zu Gott; und Gott heilte Abimelech und sein Weib und seine Mägde, so daß sie gebaren. ");
INSERT INTO deuelo_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Denn Jehova hatte um Saras, des Weibes Abrahams, willen jeden Mutterleib im Hause Abimelechs gänzlich verschlossen. ");
INSERT INTO deuelo_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Und Jehova suchte Sara heim, wie er gesagt hatte, und Jehova tat der Sara, wie er geredet hatte. ");
INSERT INTO deuelo_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Und Sara wurde schwanger und gebar dem Abraham einen Sohn in seinem Alter, zu der bestimmten Zeit, von welcher Gott ihm gesagt hatte. ");
INSERT INTO deuelo_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Und Abraham gab seinem Sohne, der ihm geboren worden, welchen Sara ihm gebar, den Namen Isaak. ");
INSERT INTO deuelo_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Und Abraham beschnitt Isaak, seinen Sohn, als er acht Tage alt war, wie Gott ihm geboten hatte. ");
INSERT INTO deuelo_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Und Abraham war hundert Jahre alt, als ihm sein Sohn Isaak geboren wurde. ");
INSERT INTO deuelo_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Und Sara sprach: Gott hat mir ein Lachen bereitet; jeder, der es hört, wird mit mir lachen. ");
INSERT INTO deuelo_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Und sie sprach: Wer hätte Abraham gesagt: Sara säugt Söhne! Denn ich habe ihm einen Sohn geboren in seinem Alter. ");
INSERT INTO deuelo_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Und das Kind wuchs und ward entwöhnt; und Abraham machte ein großes Mahl an dem Tage, da Isaak entwöhnt wurde. ");
INSERT INTO deuelo_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Und Sara sah den Sohn Hagars, der Ägypterin, den sie dem Abraham geboren hatte, spotten. ");
INSERT INTO deuelo_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Und sie sprach zu Abraham: Treibe diese Magd und ihren Sohn hinaus; denn der Sohn dieser Magd soll nicht erben mit meinem Sohne, mit Isaak! ");
INSERT INTO deuelo_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Und die Sache war sehr übel in den Augen Abrahams um seines Sohnes willen. ");
INSERT INTO deuelo_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Aber Gott sprach zu Abraham: Laß es nicht übel sein in deinen Augen wegen des Knaben und wegen deiner Magd; was immer Sara zu dir sagt, höre auf ihre Stimme; denn in Isaak soll dir ein Same genannt werden. ");
INSERT INTO deuelo_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Doch auch den Sohn der Magd werde ich zu einer Nation machen, weil er dein Same ist. ");
INSERT INTO deuelo_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Und Abraham stand des Morgens früh auf, und er nahm Brot und einen Schlauch Wasser und gab es der Hagar, indem er es auf ihre Schulter legte; und er gab ihr den Knaben und entließ sie. Und sie ging hin und irrte umher in der Wüste von Beerseba. ");
INSERT INTO deuelo_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Und als das Wasser im Schlauche ausging, da warf sie das Kind unter einen der Sträucher; ");
INSERT INTO deuelo_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","und sie ging hin und setzte sich gegenüber, einen Bogenschuß weit, denn sie sprach: Daß ich das Sterben des Kindes nicht ansehe! Und sie setzte sich gegenüber und erhob ihre Stimme und weinte. ");
INSERT INTO deuelo_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Und Gott hörte die Stimme des Knaben. Und der Engel Gottes rief der Hagar vom Himmel zu und sprach zu ihr: Was ist dir, Hagar? Fürchte dich nicht! Denn Gott hat auf die Stimme des Knaben gehört, da, wo er ist; ");
INSERT INTO deuelo_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","stehe auf, nimm den Knaben und fasse ihn mit deiner Hand, denn ich will ihn zu einer großen Nation machen. ");
INSERT INTO deuelo_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Und Gott öffnete ihre Augen, und sie sah einen Wasserbrunnen; und sie ging hin und füllte den Schlauch mit Wasser und tränkte den Knaben. ");
INSERT INTO deuelo_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Und Gott war mit dem Knaben, und er wuchs heran; und er wohnte in der Wüste und wurde ein Bogenschütze. ");
INSERT INTO deuelo_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Und er wohnte in der Wüste Paran, und seine Mutter nahm ihm ein Weib aus dem Lande Ägypten. ");
INSERT INTO deuelo_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Und es geschah zu selbiger Zeit, da sprach Abimelech und Pikol, sein Heeroberster, zu Abraham und sagte: Gott ist mit dir in allem, was du tust. ");
INSERT INTO deuelo_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","So schwöre mir nun hier bei Gott, daß du weder an mir noch an meinem Sohne noch an meinem Enkel trüglich handeln wirst! Nach der Güte, die ich dir erwiesen habe, sollst du an mir tun und an dem Lande, in welchem du dich aufhältst. ");
INSERT INTO deuelo_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Und Abraham sprach: Ich will schwören. ");
INSERT INTO deuelo_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Und Abraham stellte Abimelech zur Rede wegen eines Wasserbrunnens, den Abimelechs Knechte mit Gewalt genommen hatten. ");
INSERT INTO deuelo_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Und Abimelech sprach: Ich weiß nicht, wer das getan hat; weder hast du es mir berichtet, noch habe ich davon gehört außer heute. ");
INSERT INTO deuelo_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Da nahm Abraham Kleinvieh und Rinder und gab sie Abimelech, und sie schlossen beide einen Bund. ");
INSERT INTO deuelo_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Und Abraham stellte sieben junge Schafe der Herde besonders. ");
INSERT INTO deuelo_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Und Abimelech sprach zu Abraham: Was sollen diese sieben jungen Schafe, die du besonders gestellt hast? ");
INSERT INTO deuelo_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Und er sprach: Die sieben jungen Schafe sollst du von meiner Hand annehmen, damit es mir zum Zeugnis sei, daß ich diesen Brunnen gegraben habe. ");
INSERT INTO deuelo_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Daher nannte man diesen Ort Beerseba, weil sie beide daselbst geschworen hatten. ");
INSERT INTO deuelo_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","So schlossen sie einen Bund zu Beerseba. Und Abimelech machte sich auf und Pikol, sein Heeroberster, und sie kehrten in das Land der Philister zurück. - ");
INSERT INTO deuelo_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Und Abraham pflanzte eine Tamariske zu Beerseba und rief daselbst den Namen Jehovas, des ewigen Gottes, an. ");
INSERT INTO deuelo_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Und Abraham hielt sich eine lange Zeit auf im Lande der Philister. ");
INSERT INTO deuelo_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Und es geschah nach diesen Dingen, daß Gott den Abraham versuchte; und er sprach zu ihm: Abraham! Und er sprach: Hier bin ich! ");
INSERT INTO deuelo_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Und er sprach: Nimm deinen Sohn, deinen einzigen, den du lieb hast, den Isaak, und ziehe hin in das Land Morija, und opfere ihn daselbst als Brandopfer auf einem der Berge, den ich dir sagen werde. ");
INSERT INTO deuelo_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Und Abraham stand des Morgens früh auf und sattelte seinen Esel und nahm mit sich zwei von seinen Knaben und Isaak, seinen Sohn; und er spaltete Holz zum Brandopfer und machte sich auf und zog hin an den Ort, den Gott ihm gesagt hatte. ");
INSERT INTO deuelo_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Am dritten Tage, da erhob Abraham seine Augen und sah den Ort von ferne. ");
INSERT INTO deuelo_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Und Abraham sprach zu seinen Knaben: Bleibet ihr hier mit dem Esel; ich aber und der Knabe wollen bis dorthin gehen und anbeten und dann zu euch zurückkehren. ");
INSERT INTO deuelo_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Und Abraham nahm das Holz des Brandopfers und legte es auf Isaak, seinen Sohn; und in seine Hand nahm er das Feuer und das Messer; und sie gingen beide miteinander. ");
INSERT INTO deuelo_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Und Isaak sprach zu seinem Vater Abraham und sagte: Mein Vater! Und er sprach: Hier bin ich, mein Sohn. Und er sprach: Siehe, das Feuer und das Holz; wo aber ist das Schaf zum Brandopfer? ");
INSERT INTO deuelo_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Und Abraham sprach: Gott wird sich ersehen das Schaf zum Brandopfer, mein Sohn. Und sie gingen beide miteinander. ");
INSERT INTO deuelo_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Und sie kamen an den Ort, von dem Gott ihm gesagt hatte; und Abraham baute daselbst den Altar und schichtete das Holz; und er band seinen Sohn Isaak und legte ihn auf den Altar oben auf das Holz. ");
INSERT INTO deuelo_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Und Abraham streckte seine Hand aus und nahm das Messer, um seinen Sohn zu schlachten. ");
INSERT INTO deuelo_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Da rief ihm der Engel Jehovas vom Himmel zu und sprach: Abraham, Abraham! Und er sprach: Hier bin ich! ");
INSERT INTO deuelo_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Und er sprach: Strecke deine Hand nicht aus nach dem Knaben, und tue ihm gar nichts! Denn nun weiß ich, daß du Gott fürchtest und deinen Sohn, deinen einzigen, mir nicht vorenthalten hast. ");
INSERT INTO deuelo_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Und Abraham erhob seine Augen und sah, und siehe, da war ein Widder dahinten im Dickicht festgehalten durch seine Hörner; und Abraham ging hin und nahm den Widder und opferte ihn als Brandopfer an seines Sohnes Statt. ");
INSERT INTO deuelo_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Und Abraham gab diesem Orte den Namen: Jehova wird ersehen; daher heutigen Tages gesagt wird: Auf dem Berge Jehovas wird ersehen werden. ");
INSERT INTO deuelo_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Und der Engel Jehovas rief Abraham ein zweites Mal vom Himmel zu ");
INSERT INTO deuelo_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","und sprach: Ich schwöre bei mir selbst, spricht Jehova, daß, weil du dieses getan und deinen Sohn, deinen einzigen, mir nicht vorenthalten hast, ");
INSERT INTO deuelo_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ich dich reichlich segnen und deinen Samen sehr mehren werde, wie die Sterne des Himmels und wie der Sand, der am Ufer des Meeres ist; und dein Same wird besitzen das Tor seiner Feinde; ");
INSERT INTO deuelo_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","und in deinem Samen werden sich segnen alle Nationen der Erde: darum, daß du meiner Stimme gehorcht hast. ");
INSERT INTO deuelo_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Und Abraham kehrte zu seinen Knaben zurück, und sie machten sich auf und zogen miteinander nach Beerseba; und Abraham wohnte zu Beerseba. ");
INSERT INTO deuelo_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Und es geschah nach diesen Dingen, da wurde dem Abraham berichtet: Siehe, Milka, auch sie hat deinem Bruder Nahor Söhne geboren: ");
INSERT INTO deuelo_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uz, seinen Erstgeborenen, und Bus, seinen Bruder, und Kemuel, den Vater Arams, ");
INSERT INTO deuelo_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","und Kesed und Haso und Pildasch und Jidlaph und Bethuel. ");
INSERT INTO deuelo_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","(Und Bethuel zeugte Rebekka.) Diese acht gebar Milka dem Nahor, dem Bruder Abrahams. ");
INSERT INTO deuelo_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Und sein Kebsweib, namens Reuma, auch sie gebar Tebach und Gacham und Tachasch und Maaka. ");
INSERT INTO deuelo_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Und das Leben Saras war hundertsiebenundzwanzig Jahre; das waren die Lebensjahre Saras. ");
INSERT INTO deuelo_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Und Sara starb zu Kirjath-Arba, das ist Hebron, im Lande Kanaan. Und Abraham kam, um über Sara zu klagen und sie zu beweinen. ");
INSERT INTO deuelo_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Und Abraham erhob sich weg von seiner Toten und redete zu den Kindern Heth und sprach: ");
INSERT INTO deuelo_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Ich bin ein Fremdling und Beisasse bei euch; gebet mir ein Erbbegräbnis bei euch, daß ich meine Tote begrabe vor meinem Angesicht hinweg. ");
INSERT INTO deuelo_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Und die Kinder Heth antworteten dem Abraham und sprachen zu ihm: ");
INSERT INTO deuelo_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Höre uns, mein Herr! Du bist ein Fürst Gottes unter uns, begrabe deine Tote in dem auserlesensten unserer Gräber; keiner von uns wird dir sein Grab verwehren, um deine Tote zu begraben. ");
INSERT INTO deuelo_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Da stand Abraham auf und verneigte sich vor dem Volke des Landes, vor den Kindern Heth, ");
INSERT INTO deuelo_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","und redete mit ihnen und sprach: Wenn es euer Wille ist, daß ich meine Tote begrabe vor meinem Angesicht hinweg, so höret mich und leget Fürsprache für mich ein bei Ephron, dem Sohne Zohars, ");
INSERT INTO deuelo_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","daß er mir die Höhle von Machpela gebe, die ihm gehört, die am Ende seines Feldes ist; um das volle Geld gebe er sie mir zu einem Erbbegräbnis in eurer Mitte. ");
INSERT INTO deuelo_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ephron aber saß inmitten der Kinder Heth; und Ephron, der Hethiter, antwortete dem Abraham vor den Ohren der Kinder Heth, vor allen, die zum Tore seiner Stadt eingingen, und sprach: ");
INSERT INTO deuelo_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Nein, mein Herr, höre mich! Das Feld gebe ich dir; und die Höhle, die darin ist, dir gebe ich sie; vor den Augen der Kinder meines Volkes gebe ich sie dir; begrabe deine Tote. ");
INSERT INTO deuelo_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Da verneigte sich Abraham vor dem Volke des Landes; ");
INSERT INTO deuelo_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","und er redete zu Ephron vor den Ohren des Volkes des Landes und sprach: Doch, wenn du nur auf mich hören wolltest! Ich gebe den Preis des Feldes, nimm ihn von mir; und ich will meine Tote daselbst begraben. ");
INSERT INTO deuelo_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Und Ephron antwortete dem Abraham und sprach zu ihm: ");
INSERT INTO deuelo_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Mein Herr, höre mich! Ein Land von vierhundert Sekel Silber, was ist das zwischen mir und dir? So begrabe deine Tote. ");
INSERT INTO deuelo_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Und Abraham hörte auf Ephron; und Abraham wog dem Ephron das Geld dar, wovon er vor den Ohren der Kinder Heth geredet hatte, vierhundert Sekel Silber, gangbar beim Kaufmann. ");
INSERT INTO deuelo_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","So wurde das Feld Ephrons, welches bei Machpela, vor Mamre, lag, das Feld und die Höhle, die darin war, und alle Bäume, die auf dem Felde innerhalb seiner ganzen Grenze ringsum standen, ");
INSERT INTO deuelo_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","dem Abraham zum Besitztum bestätigt vor den Augen der Kinder Heth, vor allen, die zum Tore seiner Stadt eingingen. ");
INSERT INTO deuelo_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Und danach begrub Abraham Sara, sein Weib, in der Höhle des Feldes von Machpela, vor Mamre, das ist Hebron, im Lande Kanaan. ");
INSERT INTO deuelo_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","So wurde das Feld und die Höhle, welche darin war, dem Abraham zum Erbbegräbnis bestätigt von seiten der Kinder Heth. ");
INSERT INTO deuelo_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Und Abraham war alt, wohlbetagt, und Jehova hatte Abraham gesegnet in allem. ");
INSERT INTO deuelo_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Und Abraham sprach zu seinem Knechte, dem ältesten seines Hauses, der alles verwaltete, was er hatte: Lege doch deine Hand unter meine Hüfte, ");
INSERT INTO deuelo_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","und ich werde dich schwören lassen bei Jehova, dem Gott des Himmels und dem Gott der Erde, daß du meinem Sohne nicht ein Weib nehmen wirst von den Töchtern der Kanaaniter, in deren Mitte ich wohne; ");
INSERT INTO deuelo_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","sondern in mein Land und zu meiner Verwandtschaft sollst du gehen und ein Weib nehmen meinem Sohne, dem Isaak. ");
INSERT INTO deuelo_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Und der Knecht sprach zu ihm: Vielleicht wird das Weib mir nicht in dieses Land folgen wollen; soll ich dann deinen Sohn in das Land zurückbringen, aus welchem du weggezogen bist? ");
INSERT INTO deuelo_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Da sprach Abraham zu ihm: Hüte dich, daß du meinen Sohn nicht dorthin zurückbringest! ");
INSERT INTO deuelo_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Jehova, der Gott des Himmels, der mich aus dem Hause meines Vaters und aus dem Lande meiner Verwandtschaft genommen und der zu mir geredet und der mir also geschworen hat: Deinem Samen will ich dieses Land geben! der wird seinen Engel vor dir hersenden, daß du meinem Sohne von dannen ein Weib nehmest. ");
INSERT INTO deuelo_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Wenn aber das Weib dir nicht folgen will, so bist du dieses meines Eides ledig; nur sollst du meinen Sohn nicht dorthin zurückbringen. ");
INSERT INTO deuelo_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Und der Knecht legte seine Hand unter die Hüfte Abrahams, seines Herrn, und schwur ihm über dieser Sache. ");
INSERT INTO deuelo_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Und der Knecht nahm zehn Kamele von den Kamelen seines Herrn, und zog hin; und allerlei Gut seines Herrn hatte er bei sich. Und er machte sich auf und zog nach Mesopotamien, nach der Stadt Nahors. ");
INSERT INTO deuelo_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Und er ließ die Kamele draußen vor der Stadt niederknien beim Wasserbrunnen, zur Abendzeit, zur Zeit, da die Schöpferinnen herauskommen. ");
INSERT INTO deuelo_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Und er sprach: Jehova, Gott meines Herrn Abraham, laß es mir doch heute begegnen, und erweise Güte an meinem Herrn Abraham! ");
INSERT INTO deuelo_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Siehe, ich stehe bei der Wasserquelle, und die Töchter der Leute der Stadt kommen heraus, um Wasser zu schöpfen; ");
INSERT INTO deuelo_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","möge es nun geschehen, daß das Mädchen, zu dem ich sagen werde: Neige doch deinen Krug, daß ich trinke und welches sagen wird: Trinke, und auch deine Kamele will ich tränken, diejenige sei, welche du für deinen Knecht, für Isaak, bestimmt hast; und daran werde ich erkennen, daß du Güte an meinem Herrn erwiesen hast. ");
INSERT INTO deuelo_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Und es geschah, er hatte noch nicht ausgeredet, siehe, da kam Rebekka heraus, die dem Bethuel geboren worden, dem Sohne der Milka, des Weibes Nahors, des Bruders Abrahams, mit ihrem Kruge auf ihrer Schulter. ");
INSERT INTO deuelo_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Und das Mädchen war sehr schön von Ansehen, eine Jungfrau, und kein Mann hatte sie erkannt; und sie stieg zur Quelle hinab und füllte ihren Krug und stieg wieder herauf. ");
INSERT INTO deuelo_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Und der Knecht lief ihr entgegen und sprach: Laß mich doch ein wenig Wasser aus deinem Kruge schlürfen. ");
INSERT INTO deuelo_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Und sie sprach: Trinke, mein Herr. Und eilends ließ sie ihren Krug auf ihre Hand hernieder und gab ihm zu trinken. ");
INSERT INTO deuelo_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Und als sie ihm genug zu trinken gegeben hatte, sprach sie: Ich will auch für deine Kamele schöpfen, bis sie genug getrunken haben. ");
INSERT INTO deuelo_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Und sie eilte und goß ihren Krug aus in die Tränke und lief abermals zum Brunnen, um zu schöpfen; und sie schöpfte für alle seine Kamele. ");
INSERT INTO deuelo_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Und der Mann sah ihr staunend zu und schwieg, um zu erkennen, ob Jehova zu seiner Reise Glück gegeben habe oder nicht. ");
INSERT INTO deuelo_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Und es geschah, als die Kamele genug getrunken hatten, da nahm der Mann einen goldenen Ring, ein halber Sekel sein Gewicht, und zwei Spangen für ihre Arme, zehn Sekel Gold ihr Gewicht; ");
INSERT INTO deuelo_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","und er sprach: Wessen Tochter bist du? Sage mir's doch an. Ist im Hause deines Vaters Raum für uns zu herbergen? ");
INSERT INTO deuelo_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Und sie sprach zu ihm: Ich bin die Tochter Bethuels, des Sohnes der Milka, den sie dem Nahor geboren hat. ");
INSERT INTO deuelo_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Und sie sprach zu ihm: Sowohl Stroh als auch Futter ist bei uns in Menge, auch Raum zu herbergen. ");
INSERT INTO deuelo_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Da verneigte sich der Mann und warf sich nieder vor Jehova und sprach: ");
INSERT INTO deuelo_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Gepriesen sei Jehova, der Gott meines Herrn Abraham, der von seiner Güte und seiner Wahrheit nicht abgelassen hat gegen meinen Herrn! Mich hat Jehova geleitet auf den Weg zum Hause der Brüder meines Herrn. ");
INSERT INTO deuelo_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Und das Mädchen lief und berichtete diese Dinge dem Hause ihrer Mutter. ");
INSERT INTO deuelo_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Und Rebekka hatte einen Bruder, sein Name war Laban; und Laban lief zu dem Manne hinaus zur Quelle. ");
INSERT INTO deuelo_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Und es geschah, als er den Ring sah und die Spangen an den Armen seiner Schwester, und als er die Worte seiner Schwester Rebekka hörte, welche sagte: Also hat der Mann zu mir geredet, da kam er zu dem Manne; und siehe, er stand bei den Kamelen, an der Quelle. ");
INSERT INTO deuelo_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Und er sprach: Komm herein, Gesegneter Jehovas! Warum stehst du draußen? Denn ich habe das Haus aufgeräumt, und Raum ist für die Kamele. ");
INSERT INTO deuelo_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Und der Mann kam in das Haus; und man sattelte die Kamele ab und gab den Kamelen Stroh und Futter, und Wasser, um seine Füße zu waschen und die Füße der Männer, die bei ihm waren. ");
INSERT INTO deuelo_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Und es wurde ihm zu essen vorgesetzt; aber er sprach: Ich will nicht essen, bis ich meine Worte geredet habe. Und er sprach: Rede! ");
INSERT INTO deuelo_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Da sprach er: Ich bin Abrahams Knecht; ");
INSERT INTO deuelo_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","und Jehova hat meinen Herrn sehr gesegnet, so daß er groß geworden ist; und er hat ihm Kleinvieh gegeben und Rinder, und Silber und Gold, und Knechte und Mägde, und Kamele und Esel. ");
INSERT INTO deuelo_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Und Sara, das Weib meines Herrn, hat meinem Herrn einen Sohn geboren, nachdem sie alt geworden war; und er hat ihm alles gegeben, was er hat. ");
INSERT INTO deuelo_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Und mein Herr hat mich schwören lassen und gesagt: Du sollst meinem Sohne nicht ein Weib nehmen von den Töchtern der Kanaaniter, in deren Lande ich wohne; ");
INSERT INTO deuelo_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","sondern zu dem Hause meines Vaters und zu meinem Geschlecht sollst du gehen und meinem Sohne ein Weib nehmen! ");
INSERT INTO deuelo_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Und ich sprach zu meinem Herrn: Vielleicht wird das Weib mir nicht folgen. ");
INSERT INTO deuelo_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Da sprach er zu mir: Jehova, vor dessen Angesicht ich gewandelt habe, wird seinen Engel mit dir senden und Glück zu deiner Reise geben, daß du meinem Sohne ein Weib nehmest aus meinem Geschlecht und aus dem Hause meines Vaters. ");
INSERT INTO deuelo_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Wenn du zu meinem Geschlecht kommst, dann sollst du meines Eides ledig sein; und wenn sie sie dir nicht geben, so bist du meines Eides ledig. ");
INSERT INTO deuelo_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","So kam ich heute zu der Quelle und sprach: Jehova, Gott meines Herrn Abraham, wenn du doch Glück geben wolltest zu meinem Wege, auf dem ich gehe! ");
INSERT INTO deuelo_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Siehe, ich stehe bei der Wasserquelle; möge es nun geschehen, daß die Jungfrau, die herauskommt, um zu schöpfen, und zu der ich sagen werde: Gib mir doch ein wenig Wasser aus deinem Kruge zu trinken! - ");
INSERT INTO deuelo_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","und welche zu mir sagen wird: Trinke du, und auch für deine Kamele will ich schöpfen, daß sie das Weib sei, welches Jehova für den Sohn meines Herrn bestimmt hat. ");
INSERT INTO deuelo_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Ich hatte in meinem Herzen noch nicht ausgeredet, siehe, da kam Rebekka heraus mit ihrem Kruge auf ihrer Schulter; und sie stieg zur Quelle hinab und schöpfte. Da sprach ich zu ihr: Gib mir doch zu trinken! ");
INSERT INTO deuelo_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Und eilends ließ sie ihren Krug von ihrer Schulter hernieder und sprach: Trinke, und auch deine Kamele will ich tränken. Und ich trank, und sie tränkte auch die Kamele. ");
INSERT INTO deuelo_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Und ich fragte sie und sprach: Wessen Tochter bist du? Und sie sprach: Die Tochter Bethuels, des Sohnes Nahors, den Milka ihm geboren hat. Und ich legte den Ring an ihre Nase und die Spangen an ihre Arme; ");
INSERT INTO deuelo_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","und ich verneigte mich und warf mich nieder vor Jehova; und ich pries Jehova, den Gott meines Herrn Abraham, der mich den rechten Weg geleitet hat, um die Tochter des Bruders meines Herrn für seinen Sohn zu nehmen. ");
INSERT INTO deuelo_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Und nun, wenn ihr Güte und Treue an meinem Herrn erweisen wollt, so tut es mir kund; und wenn nicht, so tut es mir kund, und ich werde mich zur Rechten oder zur Linken wenden. ");
INSERT INTO deuelo_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Da antworteten Laban und Bethuel und sprachen: Von Jehova ist die Sache ausgegangen; wir können dir nichts sagen, weder Böses noch Gutes. ");
INSERT INTO deuelo_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Siehe, Rebekka ist vor dir: nimm sie und ziehe hin; und sie sei das Weib des Sohnes deines Herrn, wie Jehova geredet hat. ");
INSERT INTO deuelo_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Und es geschah, als Abrahams Knecht ihre Worte hörte, da beugte er sich zur Erde nieder vor Jehova. ");
INSERT INTO deuelo_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Und der Knecht zog hervor silbernes Geschmeide und goldenes Geschmeide und Kleider und gab sie der Rebekka; und Kostbarkeiten gab er ihrem Bruder und ihrer Mutter. ");
INSERT INTO deuelo_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Und sie aßen und tranken, er und die Männer, die bei ihm waren, und übernachteten. Und des Morgens standen sie auf, und er sprach: Entlasset mich zu meinem Herrn! ");
INSERT INTO deuelo_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Da sprachen ihr Bruder und ihre Mutter: Laß das Mädchen einige Tage oder zehn bei uns bleiben, danach magst du ziehen. ");
INSERT INTO deuelo_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Er aber sprach zu ihnen: Haltet mich nicht auf, da Jehova Glück gegeben hat zu meiner Reise; entlasset mich, daß ich zu meinem Herrn ziehe! ");
INSERT INTO deuelo_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Und sie sprachen: Laßt uns das Mädchen rufen und ihren Mund befragen. ");
INSERT INTO deuelo_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Und sie riefen Rebekka und sprachen zu ihr: Willst du mit diesem Manne gehen? Und sie antwortete: Ich will gehen. ");
INSERT INTO deuelo_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Und sie entließen ihre Schwester Rebekka mit ihrer Amme und den Knecht Abrahams und seine Männer. ");
INSERT INTO deuelo_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Und sie segneten Rebekka und sprachen zu ihr: Du, unsere Schwester, werde zu tausendmal Zehntausenden, und dein Same besitze das Tor seiner Feinde! ");
INSERT INTO deuelo_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Und Rebekka machte sich auf mit ihren Mägden, und sie bestiegen die Kamele und folgten dem Manne; und der Knecht nahm Rebekka und zog hin. ");
INSERT INTO deuelo_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Isaak aber war von einem Gange nach dem Brunnen Lachai-Roi gekommen; er wohnte nämlich im Lande des Südens. ");
INSERT INTO deuelo_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Und Isaak ging aus, um auf dem Felde zu sinnen beim Anbruch des Abends; und er hob seine Augen auf und sah, und siehe, Kamele kamen. ");
INSERT INTO deuelo_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Und Rebekka hob ihre Augen auf und sah Isaak; und sie warf sich vom Kamele herab und sprach zu dem Knechte: ");
INSERT INTO deuelo_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Wer ist der Mann, der uns da auf dem Felde entgegenwandelt? Und der Knecht sprach: Das ist mein Herr. Da nahm sie den Schleier und verhüllte sich. ");
INSERT INTO deuelo_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Und der Knecht erzählte Isaak all die Dinge, die er ausgerichtet hatte. ");
INSERT INTO deuelo_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Und Isaak führte sie in das Zelt seiner Mutter Sara, und er nahm Rebekka, und sie wurde sein Weib, und er hatte sie lieb. Und Isaak tröstete sich nach dem Tode seiner Mutter. ");
INSERT INTO deuelo_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Und Abraham nahm wieder ein Weib, mit Namen Ketura. ");
INSERT INTO deuelo_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Und sie gebar ihm Simran und Jokschan und Medan und Midian und Jischbak und Schuach. ");
INSERT INTO deuelo_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Und Jokschan zeugte Scheba und Dedan; und die Söhne Dedans waren die Assurim und Letuschim und Leummim. ");
INSERT INTO deuelo_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Und die Söhne Midians: Epha und Epher und Hanok und Abida und Eldaba. Diese alle waren Söhne der Ketura. - ");
INSERT INTO deuelo_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Und Abraham gab dem Isaak alles, was er hatte. ");
INSERT INTO deuelo_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Und den Söhnen der Kebsweiber, die Abraham hatte, gab Abraham Geschenke; und er ließ sie, während er noch lebte, von seinem Sohne Isaak wegziehen nach Osten, in das Land des Ostens. - ");
INSERT INTO deuelo_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Und dies sind die Tage der Lebensjahre Abrahams, die er gelebt hat: hundertfünfundsiebzig Jahre. ");
INSERT INTO deuelo_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Und Abraham verschied und starb in gutem Alter, alt und der Tage satt, und wurde versammelt zu seinen Völkern. ");
INSERT INTO deuelo_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Und seine Söhne Isaak und Ismael begruben ihn in der Höhle von Machpela, auf dem Felde Ephrons, des Sohnes Zohars, des Hethiters, das vor Mamre liegt, ");
INSERT INTO deuelo_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","dem Felde, welches Abraham von den Kindern Heth gekauft hatte; dort wurden Abraham und sein Weib Sara begraben. ");
INSERT INTO deuelo_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Und es geschah nach dem Tode Abrahams, da segnete Gott Isaak, seinen Sohn; und Isaak wohnte bei dem Brunnen Lachai-Roi. ");
INSERT INTO deuelo_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Und dies sind die Geschlechter Ismaels, des Sohnes Abrahams, den Hagar, die Ägypterin, die Magd Saras, dem Abraham geboren hat; ");
INSERT INTO deuelo_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","und dies sind die Namen der Söhne Ismaels mit ihren Namen, nach ihren Geschlechtern: Der Erstgeborene Ismaels: Nebajoth, und Kedar und Adbeel und Mibsam ");
INSERT INTO deuelo_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","und Mischma und Duma und Massa, ");
INSERT INTO deuelo_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad und Tema, Jetur, Naphisch und Kedma. ");
INSERT INTO deuelo_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Das sind die Söhne Ismaels, und das ihre Namen in ihren Gehöften und in ihren Zeltlagern; zwölf Fürsten nach ihren Stämmen. ");
INSERT INTO deuelo_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Und dies sind die Lebensjahre Ismaels: hundertsiebenunddreißig Jahre; und er verschied und starb und wurde versammelt zu seinen Völkern. ");
INSERT INTO deuelo_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Und sie wohnten von Hawila bis Sur, das vor Ägypten liegt, nach Assyrien hin. Er ließ sich nieder angesichts aller seiner Brüder. ");
INSERT INTO deuelo_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Und dies sind die Geschlechter Isaaks, des Sohnes Abrahams: Abraham zeugte Isaak. ");
INSERT INTO deuelo_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Und Isaak war vierzig Jahre alt, als er sich Rebekka zum Weibe nahm, die Tochter Bethuels, des Aramäers aus Paddan-Aram, die Schwester Labans, des Aramäers. ");
INSERT INTO deuelo_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Und Isaak bat Jehova für sein Weib, denn sie war unfruchtbar; und Jehova ließ sich von ihm erbitten, und Rebekka, sein Weib, wurde schwanger. ");
INSERT INTO deuelo_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Und die Kinder stießen sich in ihr; und sie sprach: Wenn es so steht, warum bin ich dies? Und sie ging hin, Jehova zu befragen. ");
INSERT INTO deuelo_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Und Jehova sprach zu ihr: Zwei Nationen sind in deinem Leibe, und zwei Völkerschaften werden sich scheiden aus deinem Innern; und eine Völkerschaft wird stärker sein als die andere, und der Ältere wird dem Jüngeren dienen. ");
INSERT INTO deuelo_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Und als ihre Tage erfüllt waren, daß sie gebären sollte, siehe, da waren Zwillinge in ihrem Leibe. ");
INSERT INTO deuelo_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Und der erste kam heraus, rötlich, am ganzen Leibe wie ein härener Mantel; und man gab ihm den Namen Esau. ");
INSERT INTO deuelo_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Und danach kam sein Bruder heraus, und seine Hand hielt die Ferse Esaus; und man gab ihm den Namen Jakob. Und Isaak war sechzig Jahre alt, als sie geboren wurden. ");
INSERT INTO deuelo_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Und die Knaben wuchsen heran. Und Esau wurde ein jagdkundiger Mann, ein Mann des Feldes; Jakob aber war ein sanfter Mann, der in den Zelten blieb. ");
INSERT INTO deuelo_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Und Isaak hatte Esau lieb, denn Wildbret war nach seinem Munde; Rebekka aber hatte Jakob lieb. ");
INSERT INTO deuelo_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Und Jakob kochte ein Gericht; und Esau kam vom Felde und war matt. ");
INSERT INTO deuelo_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Da sprach Esau zu Jakob: Laß mich doch essen von dem Roten, dem Roten da, denn ich bin matt! Darum gab man ihm den Namen Edom. ");
INSERT INTO deuelo_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Und Jakob sprach: Verkaufe mir heute dein Erstgeburtsrecht. ");
INSERT INTO deuelo_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Und Esau sprach: Siehe, ich gehe hin zu sterben, und wozu mir da das Erstgeburtsrecht? ");
INSERT INTO deuelo_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Und Jakob sprach: Schwöre mir heute! Und er schwur ihm und verkaufte sein Erstgeburtsrecht dem Jakob. ");
INSERT INTO deuelo_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Und Jakob gab Esau Brot und ein Gericht Linsen; und er aß und trank und stand auf und ging davon. So verachtete Esau das Erstgeburtsrecht. ");
INSERT INTO deuelo_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Und es entstand eine Hungersnot im Lande, außer der vorigen Hungersnot, die in den Tagen Abrahams gewesen war. Und Isaak zog zu Abimelech, dem Könige der Philister, nach Gerar. ");
INSERT INTO deuelo_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Und Jehova erschien ihm und sprach: Ziehe nicht hinab nach Ägypten; bleibe in dem Lande, von dem ich dir sage. ");
INSERT INTO deuelo_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Halte dich auf in diesem Lande, und ich werde mit dir sein und dich segnen; denn dir und deinem Samen werde ich alle diese Länder geben, und ich werde den Eid aufrecht halten, den ich deinem Vater Abraham geschworen habe. ");
INSERT INTO deuelo_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Und ich werde deinen Samen mehren wie die Sterne des Himmels und deinem Samen alle diese Länder geben; und in deinem Samen werden sich segnen alle Nationen der Erde: ");
INSERT INTO deuelo_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","darum daß Abraham meiner Stimme gehorcht und beobachtet hat meine Vorschriften, meine Gebote, meine Satzungen und meine Gesetze. ");
INSERT INTO deuelo_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","So blieb Isaak in Gerar. ");
INSERT INTO deuelo_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Und die Männer des Ortes erkundigten sich nach seinem Weibe, und er sprach: Sie ist meine Schwester. Denn er fürchtete sich zu sagen: Mein Weib, indem er dachte: Die Männer des Ortes möchten mich sonst töten wegen Rebekka; denn sie ist schön von Ansehen. ");
INSERT INTO deuelo_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Und es geschah, als er längere Zeit daselbst gewesen war, da blickte Abimelech, der König der Philister, durchs Fenster, und er sah, und siehe, Isaak scherzte mit Rebekka, seinem Weibe. ");
INSERT INTO deuelo_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Da rief Abimelech den Isaak und sprach: Siehe, fürwahr, sie ist dein Weib; und wie hast du gesagt: Sie ist meine Schwester? Und Isaak sprach zu ihm: Weil ich mir sagte: Daß ich nicht sterbe ihretwegen. ");
INSERT INTO deuelo_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Und Abimelech sprach: Was hast du uns da getan! Wenig fehlte, so hätte einer aus dem Volke bei deinem Weibe gelegen, und du hättest eine Schuld über uns gebracht. ");
INSERT INTO deuelo_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Und Abimelech gebot allem Volke und sprach: Wer diesen Mann und sein Weib antastet, soll gewißlich getötet werden. ");
INSERT INTO deuelo_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Und Isaak säte in selbigem Lande und gewann in selbigem Jahre das Hundertfältige; und Jehova segnete ihn. ");
INSERT INTO deuelo_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Und der Mann ward groß und wurde fort und fort größer, bis er sehr groß war. ");
INSERT INTO deuelo_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Und er hatte Herden von Kleinvieh und Herden von Rindern und ein großes Gesinde; und die Philister beneideten ihn. ");
INSERT INTO deuelo_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Und alle Brunnen, welche die Knechte seines Vaters in den Tagen seines Vaters Abraham gegraben hatten, verstopften die Philister und füllten sie mit Erde. ");
INSERT INTO deuelo_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Und Abimelech sprach zu Isaak: Ziehe weg von uns, denn du bist viel mächtiger geworden als wir. ");
INSERT INTO deuelo_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Da zog Isaak von dannen und schlug sein Lager auf im Tale Gerar und wohnte daselbst. ");
INSERT INTO deuelo_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Und Isaak grub die Wasserbrunnen wieder auf, welche sie in den Tagen seines Vaters Abraham gegraben und welche die Philister nach dem Tode Abrahams verstopft hatten; und er benannte sie mit denselben Namen, womit sein Vater sie benannt hatte. ");
INSERT INTO deuelo_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Und die Knechte Isaaks gruben im Tale und fanden daselbst einen Brunnen lebendigen Wassers. ");
INSERT INTO deuelo_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Da haderten die Hirten von Gerar mit den Hirten Isaaks und sprachen: Das Wasser ist unser! Und er gab dem Brunnen den Namen Esek, weil sie mit ihm gezankt hatten. ");
INSERT INTO deuelo_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Und sie gruben einen anderen Brunnen, und sie haderten auch über diesen, und er gab ihm den Namen Sitna. ");
INSERT INTO deuelo_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Und er brach auf von dannen und grub einen anderen Brunnen, und über diesen haderten sie nicht; und er gab ihm den Namen Rechoboth und sprach: Denn nun hat Jehova uns Raum gemacht, und wir werden fruchtbar sein im Lande. ");
INSERT INTO deuelo_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Und er zog von dannen hinauf nach Beerseba. ");
INSERT INTO deuelo_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Und Jehova erschien ihm in selbiger Nacht und sprach: Ich bin der Gott Abrahams, deines Vaters; fürchte dich nicht, denn ich bin mit dir, und ich werde dich segnen und deinen Samen mehren um Abrahams, meines Knechtes, willen. ");
INSERT INTO deuelo_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Und er baute daselbst einen Altar und rief den Namen Jehovas an; und er schlug daselbst sein Zelt auf; und die Knechte Isaaks gruben daselbst einen Brunnen. ");
INSERT INTO deuelo_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Und Abimelech zog zu ihm von Gerar mit Achusat, seinem Freunde, und Pikol, seinem Heerobersten. ");
INSERT INTO deuelo_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Und Isaak sprach zu ihnen: Warum kommet ihr zu mir, da ihr mich doch hasset und mich von euch weggetrieben habt? ");
INSERT INTO deuelo_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Und sie sprachen: Wir haben deutlich gesehen, daß Jehova mit dir ist; und wir haben uns gesagt: Möge doch ein Eid sein zwischen uns, zwischen uns und dir, und wir wollen einen Bund mit dir machen, ");
INSERT INTO deuelo_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","daß du uns nichts Übles tuest, so wie wir dich nicht angetastet haben und wie wir dir nur Gutes erwiesen und dich haben ziehen lassen in Frieden. Du bist nun einmal ein Gesegneter Jehovas. ");
INSERT INTO deuelo_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Und er machte ihnen ein Mahl, und sie aßen und tranken. ");
INSERT INTO deuelo_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Und sie standen des Morgens früh auf und schwuren einer dem anderen; und Isaak entließ sie, und sie zogen von ihm in Frieden. - ");
INSERT INTO deuelo_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Und es geschah an selbigem Tage, da kamen Isaaks Knechte und berichteten ihm wegen des Brunnens, den sie gegraben hatten, und sprachen zu ihm: Wir haben Wasser gefunden. ");
INSERT INTO deuelo_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Und er nannte ihn Sibea; daher der Name der Stadt Beerseba bis auf diesen Tag. ");
INSERT INTO deuelo_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Und Esau war vierzig Jahre alt, da nahm er zum Weibe Judith, die Tochter Beeris, des Hethiters, und Basmath, die Tochter Elons, des Hethiters. ");
INSERT INTO deuelo_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Und sie waren ein Herzeleid für Isaak und Rebekka. ");
INSERT INTO deuelo_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Und es geschah, als Isaak alt geworden und seine Augen zu schwach waren, um zu sehen, da rief er Esau, seinen älteren Sohn, und sprach zu ihm: Mein Sohn! Und er sprach zu ihm: Hier bin ich! ");
INSERT INTO deuelo_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Und er sprach: Siehe doch, ich bin alt geworden, ich weiß nicht den Tag meines Todes. ");
INSERT INTO deuelo_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Und nun nimm doch dein Jagdgerät, deinen Köcher und deinen Bogen, und gehe hinaus aufs Feld und erjage mir ein Wildbret; ");
INSERT INTO deuelo_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","und bereite mir ein schmackhaftes Gericht, wie ich es gern habe, und bringe es mir her, daß ich esse, damit meine Seele dich segne, ehe ich sterbe. ");
INSERT INTO deuelo_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Und Rebekka hörte zu, als Isaak zu seinem Sohne Esau redete. Und Esau ging aufs Feld, ein Wildbret zu erjagen, um es heimzubringen. ");
INSERT INTO deuelo_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Und Rebekka sprach zu ihrem Sohne Jakob und sagte: Siehe, ich habe deinen Vater zu deinem Bruder Esau also reden hören: ");
INSERT INTO deuelo_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Bringe mir ein Wildbret und bereite mir ein schmackhaftes Gericht, daß ich esse, und daß ich dich vor Jehova segne vor meinem Tode. ");
INSERT INTO deuelo_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Und nun, mein Sohn, höre auf meine Stimme in dem, was ich dich heiße. ");
INSERT INTO deuelo_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Gehe doch zur Herde und hole mir von dannen zwei gute Ziegenböcklein, und ich will sie zu einem schmackhaften Gericht bereiten für deinen Vater, wie er es gern hat; ");
INSERT INTO deuelo_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","und du sollst es deinem Vater bringen, daß er esse, damit er dich segne vor seinem Tode. ");
INSERT INTO deuelo_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Da sprach Jakob zu Rebekka, seiner Mutter: Siehe, mein Bruder Esau ist ein haariger Mann, und ich bin ein glatter Mann. ");
INSERT INTO deuelo_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Vielleicht wird mein Vater mich betasten, und ich werde in seinen Augen sein wie einer, der Spott mit ihm treibt, und ich werde Fluch auf mich bringen und nicht Segen. ");
INSERT INTO deuelo_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Seine Mutter aber sprach zu ihm: Dein Fluch komme auf mich, mein Sohn! Höre nur auf meine Stimme und gehe, hole mir. ");
INSERT INTO deuelo_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Und er ging und holte und brachte sie seiner Mutter. Und seine Mutter bereitete ein schmackhaftes Gericht, wie sein Vater es gern hatte. ");
INSERT INTO deuelo_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Und Rebekka nahm die Kleider Esaus, ihres älteren Sohnes, die kostbaren, die bei ihr im Hause waren, und zog sie Jakob, ihrem jüngeren Sohne, an; ");
INSERT INTO deuelo_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","und die Felle der Ziegenböcklein zog sie über seine Hände und über die Glätte seines Halses, ");
INSERT INTO deuelo_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","und sie gab das schmackhafte Gericht und das Brot, das sie bereitet hatte, in die Hand ihres Sohnes Jakob. ");
INSERT INTO deuelo_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Und er ging zu seinem Vater hinein und sprach: Mein Vater! Und er sprach: Hier bin ich; wer bist du, mein Sohn? ");
INSERT INTO deuelo_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Und Jakob sprach zu seinem Vater: Ich bin Esau, dein Erstgeborener; ich habe getan, wie du zu mir geredet hast. Stehe doch auf, setze dich und iß von meinem Wildbret, damit deine Seele mich segne. ");
INSERT INTO deuelo_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Und Isaak sprach zu seinem Sohne: Wie hast du es denn so bald gefunden, mein Sohn? Und er sprach: Weil Jehova, dein Gott, es mir begegnen ließ. ");
INSERT INTO deuelo_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Da sprach Isaak zu Jakob: Tritt doch herzu, daß ich dich betaste, mein Sohn, ob du wirklich mein Sohn Esau bist oder nicht. ");
INSERT INTO deuelo_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Und Jakob trat hin zu seinem Vater Isaak; und er betastete ihn und sprach: Die Stimme ist Jakobs Stimme, aber die Hände sind Esaus Hände. ");
INSERT INTO deuelo_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Und er erkannte ihn nicht, denn seine Hände waren haarig wie die Hände seines Bruders Esau; und er segnete ihn. ");
INSERT INTO deuelo_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Und er sprach: Bist du wirklich mein Sohn Esau? Und er sprach: Ich bin's. ");
INSERT INTO deuelo_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Da sprach er: Reiche es mir her, daß ich esse von dem Wildbret meines Sohnes, damit meine Seele dich segne. Und er reichte es ihm hin, und er aß; und er brachte ihm Wein, und er trank. ");
INSERT INTO deuelo_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Und sein Vater Isaak sprach zu ihm: Tritt doch herzu und küsse mich, mein Sohn. Und er trat hinzu und küßte ihn; ");
INSERT INTO deuelo_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","und er roch den Geruch seiner Kleider, und er segnete ihn und sprach: Siehe, der Geruch meines Sohnes ist wie der Geruch eines Feldes, das Jehova gesegnet hat. ");
INSERT INTO deuelo_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Und Gott gebe dir vom Tau des Himmels und von der Fettigkeit der Erde, und Fülle von Korn und Most! ");
INSERT INTO deuelo_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Völker sollen dir dienen und Völkerschaften sich vor dir niederbeugen! Sei Herr über deine Brüder, und vor dir sollen sich niederbeugen die Söhne deiner Mutter! Wer dir flucht, sei verflucht, und wer dich segnet, sei gesegnet! ");
INSERT INTO deuelo_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Und es geschah, sowie Isaak geendet hatte, Jakob zu segnen, ja, es geschah, als Jakob nur eben von seinem Vater Isaak hinausgegangen war, da kam sein Bruder Esau von seiner Jagd. ");
INSERT INTO deuelo_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Und auch er bereitete ein schmackhaftes Gericht und brachte es zu seinem Vater und sprach zu seinem Vater: Mein Vater stehe auf und esse von dem Wildbret seines Sohnes, damit deine Seele mich segne. ");
INSERT INTO deuelo_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Und sein Vater Isaak sprach zu ihm: Wer bist du? Und er sprach: Ich bin dein Sohn, dein Erstgeborener, Esau. ");
INSERT INTO deuelo_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Da erschrak Isaak mit großem Schrecken über die Maßen und sprach: Wer war denn der, welcher ein Wildbret erjagt und mir gebracht hat? Und ich habe von allem gegessen, ehe du kamst, und habe ihn gesegnet; er wird auch gesegnet sein. ");
INSERT INTO deuelo_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Als Esau die Worte seines Vaters hörte, da schrie er mit einem großen und bitterlichen Geschrei über die Maßen und sprach zu seinem Vater: Segne mich, auch mich, mein Vater! ");
INSERT INTO deuelo_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Und er sprach: Dein Bruder ist mit Betrug gekommen und hat deinen Segen weggenommen. ");
INSERT INTO deuelo_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Da sprach er: Ist es nicht, weil man ihm den Namen Jakob gegeben, daß er mich nun zweimal überlistet hat? Mein Erstgeburtsrecht hat er weggenommen, und siehe, nun hat er meinen Segen weggenommen! Und er sprach: Hast du mir keinen Segen aufbehalten? ");
INSERT INTO deuelo_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Da antwortete Isaak und sprach zu Esau: Siehe, ich habe ihn zum Herrn über dich gesetzt und alle seine Brüder ihm zu Knechten gegeben, und mit Korn und Most habe ich ihn versehen, und nun, was könnte ich für dich tun, mein Sohn? ");
INSERT INTO deuelo_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Und Esau sprach zu seinem Vater: Hast du nur diesen einen Segen, mein Vater? Segne mich, auch mich, mein Vater! Und Esau erhob seine Stimme und weinte. ");
INSERT INTO deuelo_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Da antwortete sein Vater Isaak und sprach zu ihm: Siehe, fern von der Fettigkeit der Erde wird dein Wohnsitz sein und ohne den Tau des Himmels von oben her. ");
INSERT INTO deuelo_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Und von deinem Schwerte wirst du leben, und deinem Bruder wirst du dienen; und es wird geschehen, wenn du umherschweifst, wirst du sein Joch zerbrechen von deinem Halse. ");
INSERT INTO deuelo_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Und Esau feindete Jakob an wegen des Segens, womit sein Vater ihn gesegnet hatte; und Esau sprach in seinem Herzen: Es nahen die Tage der Trauer um meinen Vater, dann werde ich meinen Bruder Jakob erschlagen. ");
INSERT INTO deuelo_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Und es wurden der Rebekka die Worte Esaus, ihres älteren Sohnes, berichtet; und sie sandte hin und ließ Jakob, ihren jüngeren Sohn, rufen und sprach zu ihm: Siehe, dein Bruder Esau will sich an dir rächen, indem er dich erschlägt. ");
INSERT INTO deuelo_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Und nun, mein Sohn, höre auf meine Stimme und mache dich auf, fliehe zu meinem Bruder Laban nach Haran; ");
INSERT INTO deuelo_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","und bleibe einige Zeit bei ihm, bis der Grimm deines Bruders sich wendet, ");
INSERT INTO deuelo_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","bis der Zorn deines Bruders sich von dir abwendet, und er vergißt, was du ihm getan hast; dann will ich hinsenden und dich von dort holen lassen. Warum sollte ich euer beider zugleich beraubt werden an einem Tage? ");
INSERT INTO deuelo_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Und Rebekka sprach zu Isaak: Ich bin des Lebens überdrüssig wegen der Töchter Heths; wenn Jakob ein Weib nähme von den Töchtern Heths, wie diese, von den Töchtern des Landes, wozu sollte mir das Leben? ");
INSERT INTO deuelo_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Und Isaak rief Jakob und segnete ihn; und er gebot ihm und sprach zu ihm: Du sollst nicht ein Weib nehmen von den Töchtern Kanaans. ");
INSERT INTO deuelo_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Mache dich auf, gehe nach Paddan-Aram, zum Hause Bethuels, des Vaters deiner Mutter; und nimm dir von dort ein Weib von den Töchtern Labans, des Bruders deiner Mutter. ");
INSERT INTO deuelo_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Und Gott, der Allmächtige, segne dich und mache dich fruchtbar und mehre dich, daß du zu einer Schar von Völkern werdest; ");
INSERT INTO deuelo_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","und er gebe dir den Segen Abrahams, dir und deinem Samen mit dir, auf daß du besitzest das Land deiner Fremdlingschaft, das Gott dem Abraham gegeben hat! ");
INSERT INTO deuelo_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Und Isaak entließ Jakob; und er ging nach Paddan-Aram zu Laban, dem Sohne Bethuels, des Aramäers, dem Bruder Rebekkas, der Mutter Jakobs und Esaus. - ");
INSERT INTO deuelo_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Und als Esau sah, daß Isaak den Jakob gesegnet und ihn nach Paddan-Aram entlassen hatte, um sich von dort ein Weib zu nehmen, indem er ihn segnete und ihm gebot und sprach: Du sollst nicht ein Weib nehmen von den Töchtern Kanaans, ");
INSERT INTO deuelo_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","und daß Jakob seinem Vater und seiner Mutter gehorcht hatte und nach Paddan-Aram gegangen war: ");
INSERT INTO deuelo_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","als Esau sah, daß die Töchter Kanaans übel waren in den Augen seines Vaters Isaak, ");
INSERT INTO deuelo_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","da ging Esau hin zu Ismael und nahm sich zum Weibe Machalath, die Tochter Ismaels, des Sohnes Abrahams, die Schwester Nebajoths, zu seinen anderen Weibern hinzu. ");
INSERT INTO deuelo_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Und Jakob zog aus von Beerseba und ging nach Haran. ");
INSERT INTO deuelo_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Und er gelangte an einen Ort und übernachtete daselbst; denn die Sonne war untergegangen. Und er nahm einen von den Steinen des Ortes und legte ihn zu seinen Häupten und legte sich nieder an selbigem Orte. ");
INSERT INTO deuelo_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Und er träumte: und siehe, eine Leiter war auf die Erde gestellt, und ihre Spitze rührte an den Himmel; und siehe, Engel Gottes stiegen auf und nieder an ihr. ");
INSERT INTO deuelo_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Und siehe, Jehova stand über ihr und sprach: Ich bin Jehova, der Gott Abrahams, deines Vaters, und der Gott Isaaks; das Land, auf welchem du liegst, dir will ich es geben und deinem Samen. ");
INSERT INTO deuelo_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Und dein Same soll werden wie der Staub der Erde, und du wirst dich ausbreiten nach Westen und nach Osten und nach Norden und nach Süden hin; und in dir und in deinem Samen sollen gesegnet werden alle Geschlechter der Erde. ");
INSERT INTO deuelo_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Und siehe, ich bin mit dir, und ich will dich behüten überall, wohin du gehst, und dich zurückbringen in dieses Land; denn ich werde dich nicht verlassen, bis ich getan, was ich zu dir geredet habe. ");
INSERT INTO deuelo_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Und Jakob erwachte von seinem Schlafe und sprach: Fürwahr, Jehova ist an diesem Orte, und ich wußte es nicht! ");
INSERT INTO deuelo_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Und er fürchtete sich und sprach: Wie furchtbar ist dieser Ort! Dies ist nichts anderes als Gottes Haus, und dies die Pforte des Himmels. ");
INSERT INTO deuelo_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Und Jakob stand des Morgens früh auf und nahm den Stein, den er zu seinen Häupten gelegt hatte, und stellte ihn auf als Denkmal und goß Öl auf seine Spitze. ");
INSERT INTO deuelo_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Und er gab selbigem Orte den Namen Bethel; aber im Anfang war Lus der Name der Stadt. ");
INSERT INTO deuelo_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Und Jakob tat ein Gelübde und sprach: Wenn Gott mit mir ist und mich behütet auf diesem Wege, den ich gehe, und mir Brot zu essen gibt und Kleider anzuziehen, ");
INSERT INTO deuelo_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","und ich in Frieden zurückkehre zum Hause meines Vaters, so soll Jehova mein Gott sein. ");
INSERT INTO deuelo_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Und dieser Stein, den ich als Denkmal aufgestellt habe, soll ein Haus Gottes sein; und von allem, was du mir geben wirst, werde ich dir gewißlich den Zehnten geben. ");
INSERT INTO deuelo_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Und Jakob erhob seine Füße und ging nach dem Lande der Kinder des Ostens. ");
INSERT INTO deuelo_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Und er sah: und siehe, ein Brunnen auf dem Felde; und siehe, daselbst waren drei Herden Schafe an demselben gelagert, denn aus diesem Brunnen tränkte man die Herden; und der Stein auf der Öffnung des Brunnens war groß. ");
INSERT INTO deuelo_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Und waren alle Herden dort zusammengetrieben, so wälzte man den Stein von der Öffnung des Brunnens und tränkte die Schafe; und man brachte den Stein wieder auf die Öffnung des Brunnens an seinen Ort. ");
INSERT INTO deuelo_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Und Jakob sprach zu ihnen: Meine Brüder, woher seid ihr? Und sie sprachen: Wir sind von Haran. ");
INSERT INTO deuelo_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Da sprach er zu ihnen: Kennet ihr Laban, den Sohn Nahors? Und sie sprachen: Wir kennen ihn. ");
INSERT INTO deuelo_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Und er sprach zu ihnen: Geht es ihm wohl? Und sie sprachen: Es geht ihm wohl; und siehe, da kommt seine Tochter Rahel mit den Schafen. ");
INSERT INTO deuelo_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Da sprach er: Siehe, es ist noch hoch am Tage, es ist nicht Zeit, das Vieh zusammenzutreiben; tränket die Schafe und gehet hin, weidet. ");
INSERT INTO deuelo_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Und sie sprachen: Wir können nicht, bis alle Herden zusammengetrieben werden; dann wälzt man den Stein von der Öffnung des Brunnens, und wir tränken die Schafe. ");
INSERT INTO deuelo_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Noch redete er mit ihnen, da kam Rahel mit den Schafen, die ihrem Vater gehörten; denn sie war eine Hirtin. ");
INSERT INTO deuelo_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Und es geschah, als Jakob die Rahel sah, die Tochter Labans, des Bruders seiner Mutter, und die Schafe Labans, des Bruders seiner Mutter, da trat Jakob hinzu und wälzte den Stein von der Öffnung des Brunnens und tränkte die Schafe Labans, des Bruders seiner Mutter. ");
INSERT INTO deuelo_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Und Jakob küßte Rahel und erhob seine Stimme und weinte. ");
INSERT INTO deuelo_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Und Jakob tat Rahel kund, daß er ein Bruder ihres Vaters und daß er der Sohn Rebekkas wäre; und sie lief und berichtete es ihrem Vater. ");
INSERT INTO deuelo_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Und es geschah, als Laban die Kunde von Jakob, dem Sohne seiner Schwester, hörte, da lief er ihm entgegen und umarmte ihn und küßte ihn und führte ihn in sein Haus; und er erzählte dem Laban alle diese Dinge. ");
INSERT INTO deuelo_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Und Laban sprach zu ihm: Fürwahr, du bist mein Bein und mein Fleisch. Und er blieb bei ihm einen Monat lang. ");
INSERT INTO deuelo_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Und Laban sprach zu Jakob: Solltest du mir darum, weil du mein Bruder bist, umsonst dienen? Tue mir kund, was soll dein Lohn sein? ");
INSERT INTO deuelo_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Und Laban hatte zwei Töchter; der Name der älteren war Lea und der Name der jüngeren Rahel. ");
INSERT INTO deuelo_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Und die Augen der Lea waren blöde; Rahel aber war schön von Gestalt und schön von Angesicht. ");
INSERT INTO deuelo_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Und Jakob liebte Rahel und sprach: Ich will dir sieben Jahre dienen um Rahel, deine jüngere Tochter. ");
INSERT INTO deuelo_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Und Laban sprach: Es ist besser, ich gebe sie dir, als daß ich sie einem anderen Manne gebe; bleibe bei mir. ");
INSERT INTO deuelo_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Und Jakob diente um Rahel sieben Jahre; und sie waren in seinen Augen wie einzelne Tage, weil er sie liebte. ");
INSERT INTO deuelo_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Und Jakob sprach zu Laban: Gib mir mein Weib; denn meine Tage sind erfüllt, daß ich zu ihr eingehe. ");
INSERT INTO deuelo_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Und Laban versammelte alle Männer des Ortes und machte ein Mahl. ");
INSERT INTO deuelo_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Und es geschah am Abend, da nahm er seine Tochter Lea und brachte sie zu ihm; und er ging zu ihr ein. ");
INSERT INTO deuelo_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Und Laban gab seine Magd Silpa seiner Tochter Lea zur Magd. ");
INSERT INTO deuelo_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Und es geschah am Morgen, siehe, da war es Lea. Da sprach er zu Laban: Was hast du mir da angetan! Habe ich nicht um Rahel bei dir gedient? Und warum hast du mich betrogen? ");
INSERT INTO deuelo_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Und Laban sprach: Es geschieht nicht also an unserem Orte, die Jüngere vor der Erstgeborenen zu geben. ");
INSERT INTO deuelo_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Vollende die Woche mit dieser, so wollen wir dir auch jene geben, um den Dienst, den du bei mir dienen sollst noch andere sieben Jahre. ");
INSERT INTO deuelo_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Und Jakob tat also und vollendete die Woche mit dieser; und er gab ihm seine Tochter Rahel zum Weibe. ");
INSERT INTO deuelo_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Und Laban gab seiner Tochter Rahel seine Magd Bilha zur Magd. ");
INSERT INTO deuelo_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Und er ging auch zu Rahel ein; und er liebte auch Rahel mehr als Lea. Und er diente bei ihm noch andere sieben Jahre. ");
INSERT INTO deuelo_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Und als Jehova sah, daß Lea gehaßt war, da öffnete er ihren Mutterleib; Rahel aber war unfruchtbar. ");
INSERT INTO deuelo_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Und Lea ward schwanger und gebar einen Sohn, und sie gab ihm den Namen Ruben, denn sie sprach: Weil Jehova mein Elend angesehen hat; denn nun wird mein Mann mich lieben. ");
INSERT INTO deuelo_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Und sie ward wiederum schwanger und gebar einen Sohn; und sie sprach: Weil Jehova gehört hat, daß ich gehaßt bin, so hat er mir auch diesen gegeben. Und sie gab ihm den Namen Simeon. ");
INSERT INTO deuelo_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Und sie ward wiederum schwanger und gebar einen Sohn; und sie sprach: Nun, diesmal wird sich mein Mann an mich anschließen, denn ich habe ihm drei Söhne geboren! Darum gab man ihm den Namen Levi. ");
INSERT INTO deuelo_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Und sie ward wiederum schwanger und gebar einen Sohn; und sie sprach: Diesmal will ich Jehova preisen! Darum gab sie ihm den Namen Juda. Und sie hörte auf zu gebären. ");
INSERT INTO deuelo_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Und als Rahel sah, daß sie dem Jakob nicht gebar, da beneidete Rahel ihre Schwester und sprach zu Jakob: Gib mir Kinder! Und wenn nicht, so sterbe ich. ");
INSERT INTO deuelo_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Da entbrannte der Zorn Jakobs wider Rahel, und er sprach: Bin ich an Gottes Statt, der dir die Leibesfrucht versagt hat? ");
INSERT INTO deuelo_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Und sie sprach: Siehe, da ist meine Magd Bilha; gehe zu ihr ein, daß sie auf meine Kniee gebäre und auch ich aus ihr erbaut werde. ");
INSERT INTO deuelo_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Und sie gab ihm ihre Magd Bilha zum Weibe; und Jakob ging zu ihr ein. ");
INSERT INTO deuelo_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Und Bilha ward schwanger und gebar Jakob einen Sohn. ");
INSERT INTO deuelo_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Da sprach Rahel: Gott hat mir Recht verschafft und auch auf meine Stimme gehört und mir einen Sohn gegeben! Darum gab sie ihm den Namen Dan. ");
INSERT INTO deuelo_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Und Bilha, die Magd Rahels, ward wiederum schwanger und gebar dem Jakob einen zweiten Sohn. ");
INSERT INTO deuelo_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Da sprach Rahel: Kämpfe Gottes habe ich mit meiner Schwester gekämpft, habe auch obsiegt! Und sie gab ihm den Namen Naphtali. ");
INSERT INTO deuelo_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Und als Lea sah, daß sie aufhörte zu gebären, da nahm sie ihre Magd Silpa und gab sie Jakob zum Weibe. ");
INSERT INTO deuelo_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Und Silpa, die Magd Leas, gebar dem Jakob einen Sohn. ");
INSERT INTO deuelo_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Da sprach Lea: Zum Glück! Und sie gab ihm den Namen Gad. ");
INSERT INTO deuelo_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Und Silpa, die Magd Leas, gebar dem Jakob einen zweiten Sohn. ");
INSERT INTO deuelo_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Da sprach Lea: Zu meiner Glückseligkeit! Denn glückselig preisen mich die Töchter. Und sie gab ihm den Namen Aser. ");
INSERT INTO deuelo_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Und Ruben ging aus in den Tagen der Weizenernte und fand Dudaim auf dem Felde; und er brachte sie seiner Mutter Lea. Und Rahel sprach zu Lea: Gib mir doch von den Dudaim deines Sohnes. ");
INSERT INTO deuelo_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Und sie sprach zu ihr: Ist es zu wenig, daß du meinen Mann genommen hast, daß du auch die Dudaim meines Sohnes nehmen willst? Da sprach Rahel: So mag er denn diese Nacht bei dir liegen für die Dudaim deines Sohnes. ");
INSERT INTO deuelo_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Und als Jakob am Abend vom Felde kam, da ging Lea hinaus, ihm entgegen, und sprach: Zu mir sollst du eingehen, denn ich habe dich gewißlich gedungen um die Dudaim meines Sohnes. Und er lag bei ihr in selbiger Nacht. ");
INSERT INTO deuelo_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Und Gott hörte auf Lea, und sie ward schwanger und gebar dem Jakob einen fünften Sohn. ");
INSERT INTO deuelo_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Da sprach Lea: Gott hat mir meinen Lohn gegeben, daß ich meine Magd meinem Manne gegeben habe! Und sie gab ihm den Namen Issaschar. ");
INSERT INTO deuelo_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Und Lea ward wiederum schwanger und gebar dem Jakob einen sechsten Sohn. ");
INSERT INTO deuelo_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Da sprach Lea: Mir hat Gott ein schönes Geschenk gegeben; diesmal wird mein Mann bei mir wohnen, denn ich habe ihm sechs Söhne geboren! Und sie gab ihm den Namen Sebulon. ");
INSERT INTO deuelo_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Und danach gebar sie eine Tochter und gab ihr den Namen Dina. ");
INSERT INTO deuelo_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Und Gott gedachte an Rahel, und Gott hörte auf sie und öffnete ihren Mutterleib. ");
INSERT INTO deuelo_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Und sie ward schwanger und gebar einen Sohn; und sie sprach: Gott hat meine Schmach weggenommen! ");
INSERT INTO deuelo_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Und sie gab ihm den Namen Joseph und sprach: Jehova füge mir einen anderen Sohn hinzu! ");
INSERT INTO deuelo_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Und es geschah, als Rahel den Joseph geboren hatte, da sprach Jakob zu Laban: Entlaß mich, daß ich an meinen Ort und in mein Land ziehe. ");
INSERT INTO deuelo_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Gib mir meine Weiber und meine Kinder, um welche ich dir gedient habe, daß ich hinziehe; denn du kennst ja meinen Dienst, womit ich dir gedient habe. ");
INSERT INTO deuelo_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Und Laban sprach zu ihm: Wenn ich doch Gnade gefunden habe in deinen Augen...! Ich habe gespürt, daß Jehova mich um deinetwillen gesegnet hat. ");
INSERT INTO deuelo_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Und er sprach: Bestimme mir deinen Lohn, und ich will ihn geben. ");
INSERT INTO deuelo_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Da sprach er zu ihm: Du weißt ja, wie ich dir gedient habe und was dein Vieh bei mir geworden ist. ");
INSERT INTO deuelo_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Denn wenig war, was du vor mir hattest, und es hat sich ausgebreitet zu einer Menge, und Jehova hat dich gesegnet auf jedem meiner Tritte; und nun, wann soll ich auch für mein Haus schaffen? ");
INSERT INTO deuelo_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Und er sprach: Was soll ich dir geben? Und Jakob sprach: Du sollst mir gar nichts geben; wenn du mir dieses tust, so will ich wiederum deine Herde weiden und hüten: ");
INSERT INTO deuelo_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ich will heute durch deine ganze Herde gehen und daraus absondern jedes gesprenkelte und gefleckte Tier und jedes dunkelfarbige Tier unter den Schafen, und das Gefleckte und Gesprenkelte unter den Ziegen; und das sei mein Lohn. ");
INSERT INTO deuelo_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Und meine Gerechtigkeit wird für mich zeugen am morgenden Tage, wenn sie wegen meines Lohnes vor dich kommt; alles, was nicht gesprenkelt und gefleckt ist unter den Ziegen und dunkelfarbig unter den Schafen, das sei gestohlen bei mir. ");
INSERT INTO deuelo_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Und Laban sprach: Siehe, es geschehe nach deinem Worte! ");
INSERT INTO deuelo_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Und er sonderte an selbigem Tage die gestreiften und gefleckten Böcke ab und alle gesprenkelten und gefleckten Ziegen, alles, woran Weißes war, und alles Dunkelfarbige unter den Schafen, und gab sie in die Hand seiner Söhne. ");
INSERT INTO deuelo_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Und er setzte einen Weg von drei Tagereisen zwischen sich und Jakob; und Jakob weidete die übrige Herde Labans. ");
INSERT INTO deuelo_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Und Jakob nahm sich frische Stäbe von Weißpappel, Mandelbaum und Platane und schälte weiße Streifen daran, indem er das Weiße entblößte, das an den Stäben war. ");
INSERT INTO deuelo_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Und er legte die Stäbe, die er geschält hatte, in die Tränkrinnen, in die Wassertränken, wohin die Herde zum Trinken kam, vor die Herde hin; und sie wurde brünstig, wenn sie zum Trinken kam. ");
INSERT INTO deuelo_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Und die Herde wurde brünstig vor den Stäben, und die Herde gebar gestreifte, gesprenkelte und gefleckte. ");
INSERT INTO deuelo_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Und Jakob schied die Lämmer aus, und er richtete das Gesicht der Herde auf das Gestreifte und alles Dunkelfarbige in der Herde Labans; und so machte er sich Herden besonders und tat sie nicht zu der Herde Labans. ");
INSERT INTO deuelo_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Und es geschah, so oft das kräftige Vieh brünstig wurde, dann legte Jakob die Stäbe vor die Augen der Herde in die Tränkrinnen, damit sie bei den Stäben brünstig würden; ");
INSERT INTO deuelo_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","wenn aber das Vieh schwächlich war, legte er sie nicht hin. Also wurden die schwächlichen dem Laban und die kräftigen dem Jakob. ");
INSERT INTO deuelo_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Und der Mann breitete sich sehr, sehr aus, und er bekam viele Herden, und Mägde und Knechte, und Kamele und Esel. ");
INSERT INTO deuelo_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Und er hörte die Worte der Söhne Labans, welche sprachen: Jakob hat alles genommen, was unserem Vater gehörte; und von dem, was unserem Vater gehörte, hat er sich all diesen Reichtum verschafft. ");
INSERT INTO deuelo_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Und Jakob sah das Angesicht Labans, und siehe, es war nicht gegen ihn wie früher. ");
INSERT INTO deuelo_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Und Jehova sprach zu Jakob: Kehre zurück in das Land deiner Väter und zu deiner Verwandtschaft, und ich will mit dir sein. ");
INSERT INTO deuelo_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Da sandte Jakob hin und ließ Rahel und Lea aufs Feld rufen zu seiner Herde. ");
INSERT INTO deuelo_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Und er sprach zu ihnen: Ich sehe das Angesicht eures Vaters, daß es nicht gegen mich ist wie früher; aber der Gott meines Vaters ist mit mir gewesen. ");
INSERT INTO deuelo_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ihr selbst wisset ja, daß ich mit all meiner Kraft eurem Vater gedient habe. ");
INSERT INTO deuelo_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Und euer Vater hat mich betrogen und hat meinen Lohn zehnmal verändert; aber Gott hat ihm nicht gestattet, mir Übles zu tun. ");
INSERT INTO deuelo_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Wenn er so sprach: Die gesprenkelten sollen dein Lohn sein, dann gebaren alle Herden gesprenkelte; und wenn er so sprach: Die gestreiften sollen dein Lohn sein, dann gebaren alle Herden gestreifte. ");
INSERT INTO deuelo_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Und Gott hat das Vieh eures Vaters genommen und mir gegeben. ");
INSERT INTO deuelo_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Und es geschah zur Brunstzeit der Herde, da hob ich meine Augen auf und sah im Traume: und siehe, die Böcke, welche die Herde besprangen, waren gestreift, gesprenkelt und getüpfelt. ");
INSERT INTO deuelo_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Und der Engel Gottes sprach im Traume zu mir: Jakob! Und ich sprach: Hier bin ich! ");
INSERT INTO deuelo_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Und er sprach: Hebe doch deine Augen auf und sieh: alle Böcke, welche die Herde bespringen, sind gestreift, gesprenkelt und getüpfelt; denn ich habe alles gesehen, was Laban dir tut. ");
INSERT INTO deuelo_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ich bin der Gott von Bethel, wo du ein Denkmal gesalbt, wo du mir ein Gelübde getan hast. Nun mache dich auf, ziehe aus diesem Lande und kehre zurück in das Land deiner Verwandtschaft. ");
INSERT INTO deuelo_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Und Rahel und Lea antworteten und sprachen zu ihm: Haben wir noch ein Teil und ein Erbe im Hause unseres Vaters? ");
INSERT INTO deuelo_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Sind wir nicht als Fremde von ihm geachtet worden? Denn er hat uns verkauft und hat auch unser Geld völlig verzehrt. ");
INSERT INTO deuelo_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Denn aller Reichtum, den Gott unserem Vater entrissen hat, uns gehört er und unseren Kindern. So tue nun alles, was Gott zu dir geredet hat. ");
INSERT INTO deuelo_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Da machte Jakob sich auf und hob seine Kinder und seine Weiber auf die Kamele, ");
INSERT INTO deuelo_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","und führte weg all sein Vieh und all seine Habe, die er erworben, das Vieh seines Eigentums, das er erworben hatte in Paddan-Aram, um zu seinem Vater Isaak zu kommen in das Land Kanaan. ");
INSERT INTO deuelo_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Und Laban war gegangen, um seine Schafe zu scheren; und Rahel stahl die Teraphim, die ihr Vater hatte. ");
INSERT INTO deuelo_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Und Jakob hinterging Laban, den Aramäer, indem er ihm nicht kundtat, daß er fliehe. ");
INSERT INTO deuelo_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Und er floh, er und alles, was er hatte; und er machte sich auf und setzte über den Strom und richtete sein Angesicht nach dem Gebirge Gilead. ");
INSERT INTO deuelo_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Und am dritten Tage wurde dem Laban berichtet, daß Jakob geflohen wäre. ");
INSERT INTO deuelo_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Und er nahm seine Brüder mit sich und jagte ihm sieben Tagereisen nach und ereilte ihn auf dem Gebirge Gilead. ");
INSERT INTO deuelo_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Und Gott kam zu Laban, dem Aramäer, in einem Traume der Nacht und sprach zu ihm: Hüte dich, daß du mit Jakob weder Gutes noch Böses redest! ");
INSERT INTO deuelo_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Und Laban erreichte Jakob, und Jakob hatte sein Zelt auf dem Gebirge aufgeschlagen; und Laban schlug es auf mit seinen Brüdern auf dem Gebirge Gilead. ");
INSERT INTO deuelo_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Und Laban sprach zu Jakob: Was hast du getan, daß du mich hintergangen und meine Töchter wie Kriegsgefangene weggeführt hast? ");
INSERT INTO deuelo_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Warum bist du heimlich geflohen und hast mich hintergangen und hast es mir nicht kundgetan ich hätte dich ja begleitet mit Freude und mit Gesängen, mit Tamburin und mit Laute- ");
INSERT INTO deuelo_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","und hast mir nicht zugelassen, meine Söhne und meine Töchter zu küssen? Nun, du hast töricht gehandelt. ");
INSERT INTO deuelo_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Es wäre in der Macht meiner Hand, euch Übles zu tun; aber der Gott eures Vaters hat gestern Nacht zu mir geredet und gesagt: Hüte dich, mit Jakob weder Gutes noch Böses zu reden! ");
INSERT INTO deuelo_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Und nun, da du einmal weggegangen bist, weil du dich so sehr nach dem Hause deines Vaters sehntest, warum hast du meine Götter gestohlen? ");
INSERT INTO deuelo_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Da antwortete Jakob und sprach zu Laban: Weil ich mich fürchtete; denn ich sagte mir, du möchtest mir etwa deine Töchter entreißen. ");
INSERT INTO deuelo_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Bei wem du deine Götter findest, der soll nicht leben. Erforsche vor unseren Brüdern, was bei mir ist, und nimm es dir. Jakob aber wußte nicht, daß Rahel sie gestohlen hatte. ");
INSERT INTO deuelo_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Und Laban ging in das Zelt Jakobs und in das Zelt Leas und in das Zelt der beiden Mägde und fand nichts; und er ging aus dem Zelte Leas und kam in das Zelt Rahels. ");
INSERT INTO deuelo_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rahel aber hatte die Teraphim genommen und sie in den Kamelsattel gelegt und sich darauf gesetzt. Und Laban durchtastete das ganze Zelt und fand nichts. ");
INSERT INTO deuelo_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Und sie sprach zu ihrem Vater: Mein Herr möge nicht zürnen, daß ich nicht vor dir aufstehen kann; denn es ergeht mir nach der Weiber Weise. Und er durchsuchte alles und fand die Teraphim nicht. ");
INSERT INTO deuelo_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Da entbrannte Jakob und haderte mit Laban. Und Jakob antwortete und sprach zu Laban: Was ist mein Vergehen, was meine Sünde, daß du mir hitzig nachgesetzt bist? ");
INSERT INTO deuelo_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Da du all mein Gerät durchtastet hast, was hast du gefunden von allem Gerät deines Hauses? Lege es hierher vor meine Brüder und deine Brüder, und sie mögen zwischen uns beiden entscheiden! ");
INSERT INTO deuelo_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Zwanzig Jahre bin ich nun bei dir gewesen; deine Mutterschafe und deine Ziegen haben nicht fehlgeboren, und die Widder deiner Herde habe ich nicht gegessen. ");
INSERT INTO deuelo_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Das Zerrissene habe ich nicht zu dir gebracht, ich habe es büßen müssen; von meiner Hand hast du es gefordert, mochte es gestohlen sein bei Tage oder gestohlen bei Nacht. ");
INSERT INTO deuelo_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Es war mit mir also: des Tages verzehrte mich die Hitze und der Frost des Nachts, und mein Schlaf floh von meinen Augen. ");
INSERT INTO deuelo_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Zwanzig Jahre bin ich nun in deinem Hause gewesen; ich habe dir vierzehn Jahre gedient um deine beiden Töchter und sechs Jahre um deine Herde, und du hast meinen Lohn zehnmal verändert. ");
INSERT INTO deuelo_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Wenn nicht der Gott meines Vaters, der Gott Abrahams, und die Furcht Isaaks, für mich gewesen wäre, gewiß, du würdest mich jetzt leer entlassen haben. Gott hat mein Elend und die Arbeit meiner Hände angesehen und hat gestern Nacht entschieden. ");
INSERT INTO deuelo_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Und Laban antwortete und sprach zu Jakob: Die Töchter sind meine Töchter, und die Söhne sind meine Söhne, und die Herde ist meine Herde, und alles, was du siehest, ist mein; aber meinen Töchtern, was könnte ich ihnen heute tun, oder ihren Söhnen, die sie geboren haben? ");
INSERT INTO deuelo_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Und nun komm, laß uns einen Bund machen, ich und du, und er sei zum Zeugnis zwischen mir und dir! ");
INSERT INTO deuelo_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Und Jakob nahm einen Stein und richtete ihn auf als Denkmal. ");
INSERT INTO deuelo_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Und Jakob sprach zu seinen Brüdern: Sammelt Steine! Und sie nahmen Steine und errichteten einen Haufen und aßen daselbst auf dem Haufen. ");
INSERT INTO deuelo_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Und Laban nannte ihn Jegar Sahadutha, und Jakob nannte ihn Galed. ");
INSERT INTO deuelo_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Und Laban sprach: Dieser Haufe sei heute ein Zeuge zwischen mir und dir! Darum gab man ihm den Namen Galed, ");
INSERT INTO deuelo_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","und Mizpa, weil er sprach: Jehova sei Wächter zwischen mir und dir, wenn wir einer vor dem anderen verborgen sein werden! ");
INSERT INTO deuelo_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Wenn du meine Töchter bedrücken, und wenn du noch Weibern nehmen solltest zu meinen Töchtern... kein Mensch ist bei uns; siehe, Gott ist Zeuge zwischen mir und dir. ");
INSERT INTO deuelo_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Und Laban sprach zu Jakob: Siehe, dieser Haufe, und siehe, das Denkmal, das ich errichtet habe zwischen mir und dir: ");
INSERT INTO deuelo_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","dieser Haufe sei Zeuge und das Denkmal ein Zeugnis, daß weder ich über diesen Haufen zu dir hinausgehe, noch daß du über diesen Haufen und dieses Denkmal zu mir hinausgehest zum Bösen. ");
INSERT INTO deuelo_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Der Gott Abrahams und der Gott Nahors richte zwischen uns, der Gott ihres Vaters! Da schwur Jakob bei der Furcht seines Vaters Isaak. ");
INSERT INTO deuelo_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Und Jakob opferte ein Schlachtopfer auf dem Gebirge und lud seine Brüder ein, zu essen; und sie aßen und übernachteten auf dem Gebirge. ");
INSERT INTO deuelo_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Und Laban stand des Morgens früh auf und küßte seine Söhne und seine Töchter und segnete sie; und Laban zog hin und kehrte zurück an seinen Ort. ");
INSERT INTO deuelo_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Und Jakob zog seines Weges, und es begegneten ihm Engel Gottes. ");
INSERT INTO deuelo_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Und Jakob sprach, als er sie sah: Dies ist das Heerlager Gottes. Und er gab jenem Orte den Namen Machanaim. ");
INSERT INTO deuelo_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Und Jakob sandte Boten vor sich her zu seinem Bruder Esau, in das Land Seir, das Gefilde Edom. ");
INSERT INTO deuelo_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Und er gebot ihnen und sprach: So sollt ihr zu meinem Herrn, zu Esau, sprechen: So spricht dein Knecht Jakob: Bei Laban habe ich mich aufgehalten und bin geblieben bis jetzt; ");
INSERT INTO deuelo_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","und ich habe Rinder und Esel, Kleinvieh und Knechte und Mägde erworben; und ich habe gesandt, es meinem Herrn kundzutun, um Gnade zu finden in deinen Augen. ");
INSERT INTO deuelo_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Und die Boten kehrten zu Jakob zurück und sprachen: Wir sind zu deinem Bruder, zu Esau, gekommen, und er zieht dir auch entgegen und vierhundert Mann mit ihm. ");
INSERT INTO deuelo_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Da fürchtete sich Jakob sehr, und ihm ward angst; und er teilte das Volk, das bei ihm war, und das Kleinvieh und die Rinder und die Kamele in zwei Züge. ");
INSERT INTO deuelo_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Und er sprach: Wenn Esau wider den einen Zug kommt und ihn schlägt, so wird der übriggebliebene Zug entrinnen können. ");
INSERT INTO deuelo_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Und Jakob sprach: Gott meines Vaters Abraham und Gott meines Vaters Isaak, Jehova, der du zu mir geredet hast: Kehre zurück in dein Land und zu deiner Verwandtschaft, und ich will dir wohltun! ");
INSERT INTO deuelo_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ich bin zu gering all der Gütigkeiten und all der Treue, die du deinem Knechte erwiesen hast; denn mit meinem Stabe bin ich über diesen Jordan gegangen, und nun bin ich zu zwei Zügen geworden. ");
INSERT INTO deuelo_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Rette mich doch von der Hand meines Bruders, von der Hand Esaus! Denn ich fürchte ihn, daß er etwa komme und mich schlage, die Mutter samt den Kindern. ");
INSERT INTO deuelo_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Du hast ja gesagt: Gewißlich werde ich dir wohltun und werde deinen Samen machen wie den Sand des Meeres, der nicht gezählt wird vor Menge. ");
INSERT INTO deuelo_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Und er übernachtete daselbst in jener Nacht; und er nahm von dem, was in seine Hand gekommen war, ein Geschenk für seinen Bruder Esau: ");
INSERT INTO deuelo_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Zweihundert Ziegen und zwanzig Böcke, zweihundert Mutterschafe und zwanzig Widder, ");
INSERT INTO deuelo_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","dreißig säugende Kamele mit ihren Füllen, vierzig Kühe und zehn Stiere, zwanzig Eselinnen und zehn junge Esel. ");
INSERT INTO deuelo_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Und er gab sie in die Hand seiner Knechte, je eine Herde besonders, und er sprach zu seinen Knechten: Ziehet vor mir her und lasset Raum zwischen Herde und Herde. ");
INSERT INTO deuelo_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Und er gebot dem ersten und sprach: Wenn mein Bruder Esau dir begegnet und dich fragt und spricht: Wem gehörst du an, und wohin gehst du, und wem gehören diese da vor dir? ");
INSERT INTO deuelo_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","so sollst du sagen: Deinem Knechte Jakob; es ist ein Geschenk, gesandt meinem Herrn, dem Esau; und siehe, er selbst ist hinter uns. ");
INSERT INTO deuelo_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Und er gebot auch dem zweiten, auch dem dritten, auch allen, die hinter den Herden hergingen, und sprach: Nach diesem Worte sollt ihr zu Esau reden, wenn ihr ihn findet, ");
INSERT INTO deuelo_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","und sollt sagen: Siehe, dein Knecht Jakob ist selbst hinter uns. Denn er sagte: Ich will ihn versöhnen durch das Geschenk, das vor mir hergeht, und danach will ich sein Angesicht sehen; vielleicht wird er mich annehmen. ");
INSERT INTO deuelo_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Und das Geschenk zog vor ihm her, und er übernachtete in jener Nacht im Lager. ");
INSERT INTO deuelo_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Und er stand in jener Nacht auf und nahm seine zwei Weiber und seine zwei Mägde und seine elf Söhne und zog über die Furt des Jabbok; ");
INSERT INTO deuelo_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","und er nahm sie und führte sie über den Fluß und führte hinüber, was er hatte. ");
INSERT INTO deuelo_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Und Jakob blieb allein übrig; und es rang ein Mann mit ihm, bis die Morgenröte aufging. ");
INSERT INTO deuelo_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Und als er sah, daß er ihn nicht übermochte, da rührte er sein Hüftgelenk an; und das Hüftgelenk Jakobs ward verrenkt, indem er mit ihm rang. ");
INSERT INTO deuelo_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Da sprach er: Laß mich los, denn die Morgenröte ist aufgegangen; und er sprach: Ich lasse dich nicht los, du habest mich denn gesegnet. ");
INSERT INTO deuelo_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Da sprach er zu ihm: Was ist dein Name? Und er sprach: Jakob. ");
INSERT INTO deuelo_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Da sprach er: Nicht Jakob soll hinfort dein Name heißen, sondern Israel; denn du hast mit Gott und mit Menschen gerungen und hast obsiegt. ");
INSERT INTO deuelo_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Und Jakob fragte und sprach: Tue mir doch deinen Namen kund! Da sprach er: Warum doch fragst du nach meinem Namen? Und er segnete ihn daselbst. ");
INSERT INTO deuelo_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Und Jakob gab dem Orte den Namen Pniel: denn ich habe Gott von Angesicht zu Angesicht gesehen, und meine Seele ist gerettet worden! ");
INSERT INTO deuelo_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Und die Sonne ging ihm auf, als er über Pniel hinaus war; und er hinkte an seiner Hüfte. ");
INSERT INTO deuelo_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Darum essen die Kinder Israel nicht die Spannader, die über dem Hüftgelenk ist, bis auf den heutigen Tag, weil er das Hüftgelenk Jakobs, die Spannader, angerührt hat. ");
INSERT INTO deuelo_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Und Jakob hob seine Augen auf und sah: und siehe, Esau kam und mit ihm vierhundert Mann. Und er verteilte die Kinder auf Lea und auf Rahel und auf die beiden Mägde; ");
INSERT INTO deuelo_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","und er stellte die Mägde und ihre Kinder vornan und Lea und ihre Kinder dahinter und Rahel und Joseph zuletzt. ");
INSERT INTO deuelo_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Er aber ging vor ihnen her und beugte sich siebenmal zur Erde nieder, bis er nahe zu seinem Bruder kam. ");
INSERT INTO deuelo_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Und Esau lief ihm entgegen und umarmte ihn und fiel ihm um den Hals und küßte ihn; und sie weinten. ");
INSERT INTO deuelo_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Und er hob seine Augen auf und sah die Weiber und die Kinder und sprach: Wer sind diese bei dir? Und er sprach: Die Kinder, die Gott deinem Knechte beschert hat. ");
INSERT INTO deuelo_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Und die Mägde traten herzu, sie und ihre Kinder, und verneigten sich. ");
INSERT INTO deuelo_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Und auch Lea trat herzu und ihre Kinder, und sie verneigten sich. Und danach traten Joseph und Rahel herzu und verneigten sich. ");
INSERT INTO deuelo_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Und er sprach: Was willst du mit diesem ganzen Zug, dem ich begegnet bin? Und er sprach: Daß ich Gnade fände in den Augen meines Herrn. ");
INSERT INTO deuelo_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Da sprach Esau: Ich habe genug, mein Bruder; es sei dein, was du hast. ");
INSERT INTO deuelo_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Und Jakob sprach: Nicht doch; wenn ich anders Gnade gefunden habe in deinen Augen, so nimm mein Geschenk von meiner Hand, da ich nun einmal dein Angesicht gesehen habe, als hätte ich Gottes Angesicht gesehen, und du Wohlgefallen an mir gehabt hast. ");
INSERT INTO deuelo_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Nimm doch mein Geschenk, das dir überbracht worden ist; denn Gott hat es mir beschert, und ich habe alles. Und er drang in ihn, und er nahm es. ");
INSERT INTO deuelo_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Und Esau sprach: Laß uns aufbrechen und weiterziehen, und ich will vor dir herziehen. ");
INSERT INTO deuelo_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Und er sprach zu ihm: Mein Herr weiß, daß die Kinder zart sind und daß ich säugende Schafe und Kühe bei mir habe; wenn man sie nur einen Tag übertriebe, so würde die ganze Herde sterben. ");
INSERT INTO deuelo_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Mein Herr ziehe doch vor seinem Knechte hin, und ich will einherziehen nach meiner Gemächlichkeit, nach dem Gange des Viehes, das vor mir ist, und nach dem Gange der Kinder, bis ich zu meinem Herrn komme nach Seir. ");
INSERT INTO deuelo_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Und Esau sprach: Ich will doch von dem Volke bei dir zurücklassen, das bei mir ist. Und er sprach: Wozu das? Möchte ich Gnade finden in den Augen meines Herrn! ");
INSERT INTO deuelo_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Und Esau kehrte an selbigem Tage seines Weges zurück nach Seir. ");
INSERT INTO deuelo_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Und Jakob brach auf nach Sukkoth und baute sich ein Haus, und seinem Vieh machte er Hütten; darum gab er dem Orte den Namen Sukkoth. ");
INSERT INTO deuelo_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Und Jakob kam wohlbehalten nach der Stadt Sichem, die im Lande Kanaan ist, als er aus Paddan-Aram kam, und lagerte vor der Stadt. ");
INSERT INTO deuelo_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Und er kaufte das Stück Feld, wo er sein Zelt aufgeschlagen hatte, von der Hand der Söhne Hemors, des Vaters Sichems, um hundert Kesita. ");
INSERT INTO deuelo_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Und er richtete daselbst einen Altar auf und nannte ihn: Gott, der Gott Israels. ");
INSERT INTO deuelo_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Und Dina, die Tochter Leas, die sie dem Jakob geboren hatte, ging aus, die Töchter des Landes zu sehen. ");
INSERT INTO deuelo_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Und es sah sie Sichem, der Sohn Hemors, des Hewiters, des Fürsten des Landes, und er nahm sie und lag bei ihr und schwächte sie. ");
INSERT INTO deuelo_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Und seine Seele hing an Dina, der Tochter Jakobs, und er liebte das Mädchen und redete zum Herzen des Mädchens. ");
INSERT INTO deuelo_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Und Sichem sprach zu Hemor, seinem Vater, und sagte: Nimm mir dieses Mädchen zum Weibe. ");
INSERT INTO deuelo_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Und Jakob hörte, daß er seine Tochter Dina entehrt hatte; seine Söhne aber waren mit seinem Vieh auf dem Felde, und Jakob schwieg, bis sie kamen. ");
INSERT INTO deuelo_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Und Hemor, der Vater Sichems, kam heraus zu Jakob, um mit ihm zu reden. ");
INSERT INTO deuelo_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Und die Söhne Jakobs kamen vom Felde, sobald sie es hörten; und die Männer kränkten sich und ergrimmten sehr, weil er eine Schandtat in Israel verübt hatte, bei der Tochter Jakobs zu liegen; und also sollte nicht geschehen. ");
INSERT INTO deuelo_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Und Hemor redete mit ihnen und sprach: Sichem, mein Sohn, seine Seele hängt an eurer Tochter: Gebet sie ihm doch zum Weibe, ");
INSERT INTO deuelo_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","und verschwägert euch mit uns: gebet uns eure Töchter und nehmet euch unsere Töchter; ");
INSERT INTO deuelo_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","und wohnet bei uns, und das Land soll vor euch sein: wohnet und verkehret darin, und machet euch darin ansässig. ");
INSERT INTO deuelo_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Und Sichem sprach zu ihrem Vater und zu ihren Brüdern: Möge ich Gnade finden in euren Augen! Und was ihr mir sagen werdet, will ich geben. ");
INSERT INTO deuelo_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Leget mir sehr viel auf als Heiratsgabe und Geschenk, und ich will es geben, so wie ihr mir sagen werdet; und gebet mir das Mädchen zum Weibe. ");
INSERT INTO deuelo_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Und die Söhne Jakobs antworteten Sichem und seinem Vater Hemor betrüglich und redeten, weil er ihre Schwester Dina entehrt hatte; ");
INSERT INTO deuelo_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Und sie sprachen zu ihm: Wir können dies nicht tun, unsere Schwester einem unbeschnittenen Manne zu geben, denn das wäre eine Schande für uns. ");
INSERT INTO deuelo_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Nur unter der Bedingung wollen wir euch zu Willen sein, wenn ihr werdet wie wir, indem alles Männliche bei euch beschnitten wird; ");
INSERT INTO deuelo_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","dann wollen wir euch unsere Töchter geben und eure Töchter uns nehmen, und wir wollen bei euch wohnen und ein Volk sein. ");
INSERT INTO deuelo_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Wenn ihr aber nicht auf uns höret, euch beschneiden zu lassen, so nehmen wir unsere Tochter und ziehen weg. ");
INSERT INTO deuelo_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Und ihre Worte waren gut in den Augen Hemors und Sichems, des Sohnes Hemors. ");
INSERT INTO deuelo_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Und der Jüngling zögerte nicht, dies zu tun, denn er hatte Gefallen an der Tochter Jakobs. Und er war geehrt vor allen im Hause seines Vaters. ");
INSERT INTO deuelo_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Und Hemor und Sichem, sein Sohn, kamen in das Tor ihrer Stadt, und sie redeten zu den Männern ihrer Stadt und sprachen: ");
INSERT INTO deuelo_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Diese Männer sind friedlich gegen uns, so mögen sie im Lande wohnen und darin verkehren; und das Land, siehe, weit nach beiden Seiten ist es vor ihnen. Wir wollen uns ihre Töchter zu Weibern nehmen und unsere Töchter ihnen geben. ");
INSERT INTO deuelo_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Nur unter der Bedingung wollen die Männer uns zu Willen sein, bei uns zu wohnen, ein Volk zu sein, wenn bei uns alles Männliche beschnitten werde, so wie sie beschnitten sind. ");
INSERT INTO deuelo_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ihre Herden und ihr Besitz und all ihr Vieh, werden die nicht unser sein? Nur laßt uns ihnen zu Willen sein, und sie werden bei uns wohnen. ");
INSERT INTO deuelo_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Und sie hörten auf Hemor und auf Sichem, seinen Sohn, alle, die zum Tore seiner Stadt ausgingen; und alles Männliche wurde beschnitten, alle, die zum Tore seiner Stadt ausgingen. ");
INSERT INTO deuelo_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Und es geschah am dritten Tage, als sie in Schmerzen waren, da nahmen die zwei Söhne Jakobs, Simeon und Levi, die Brüder Dinas, ein jeder sein Schwert und kamen kühn wider die Stadt und ermordeten alles Männliche; ");
INSERT INTO deuelo_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","auch Hemor und seinen Sohn Sichem ermordeten sie mit der Schärfe des Schwertes und nahmen Dina aus dem Hause Sichems und gingen davon. ");
INSERT INTO deuelo_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Die Söhne Jakobs kamen über die Erschlagenen und plünderten die Stadt, weil sie ihre Schwester entehrt hatten. ");
INSERT INTO deuelo_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ihr Kleinvieh und ihre Rinder und ihre Esel und was in der Stadt und was auf dem Felde war, nahmen sie; ");
INSERT INTO deuelo_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","und all ihr Vermögen und alle ihre Kinder und ihre Weiber führten sie gefangen hinweg und raubten sie und alles, was in den Häusern war. ");
INSERT INTO deuelo_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Da sprach Jakob zu Simeon und zu Levi: Ihr habt mich in Trübsal gebracht, indem ihr mich stinkend machet unter den Bewohnern des Landes, unter den Kanaanitern und unter den Perisitern. Ich aber bin ein zählbares Häuflein, und sie werden sich wider mich versammeln und mich schlagen, und ich werde vertilgt werden, ich und mein Haus. ");
INSERT INTO deuelo_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Und sie sprachen: Sollte man unsere Schwester wie eine Hure behandeln? ");
INSERT INTO deuelo_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Und Gott sprach zu Jakob: Mache dich auf, ziehe hinauf nach Bethel und wohne daselbst, und mache daselbst einen Altar dem Gott, der dir erschienen ist, als du vor deinem Bruder Esau flohest. ");
INSERT INTO deuelo_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Da sprach Jakob zu seinem Hause und zu allen, die bei ihm waren: Tut die fremden Götter hinweg, die in eurer Mitte sind, und reiniget euch und wechselt eure Kleider; ");
INSERT INTO deuelo_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","und wir wollen uns aufmachen und nach Bethel hinaufziehen, und ich werde daselbst einen Altar machen dem Gott, der mir geantwortet hat am Tage meiner Drangsal und mit mir gewesen ist auf dem Wege, den ich gewandelt bin. ");
INSERT INTO deuelo_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Und sie gaben Jakob alle fremden Götter, die in ihrer Hand, und die Ringe, die in ihren Ohren waren, und Jakob vergrub sie unter der Terebinthe, die bei Sichem ist. ");
INSERT INTO deuelo_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Und sie brachen auf. Und der Schrecken Gottes kam über die Städte, die rings um sie her waren, so daß sie den Söhnen Jakobs nicht nachjagten. ");
INSERT INTO deuelo_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Und Jakob kam nach Lus, welches im Lande Kanaan liegt, das ist Bethel, er und alles Volk, das bei ihm war. ");
INSERT INTO deuelo_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Und er baute daselbst einen Altar und nannte den Ort El-Bethel: denn Gott hatte sich ihm daselbst geoffenbart, als er vor seinem Bruder floh. ");
INSERT INTO deuelo_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Und Debora, die Amme Rebekkas, starb, und sie wurde begraben unterhalb Bethel unter der Eiche; und man gab ihr den Namen Allon Bakuth. ");
INSERT INTO deuelo_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Und Gott erschien dem Jakob wiederum, als er aus Paddan-Aram kam, und segnete ihn. ");
INSERT INTO deuelo_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Und Gott sprach zu ihm: Dein Name ist Jakob; dein Name soll hinfort nicht Jakob heißen, sondern Israel soll dein Name sein. Und er gab ihm den Namen Israel. ");
INSERT INTO deuelo_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Und Gott sprach zu ihm: Ich bin Gott, der Allmächtige, sei fruchtbar und mehre dich; eine Nation und ein Haufe von Nationen soll aus dir werden, und Könige sollen aus deinen Lenden hervorkommen. ");
INSERT INTO deuelo_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Und das Land, das ich Abraham und Isaak gegeben habe, dir will ich es geben, und deinem Samen nach dir will ich das Land geben. ");
INSERT INTO deuelo_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Und Gott fuhr von ihm auf an dem Orte, wo er mit ihm geredet hatte. ");
INSERT INTO deuelo_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Und Jakob richtete ein Denkmal auf an dem Orte, wo er mit ihm geredet hatte, ein Denkmal von Stein, und spendete darauf ein Trankopfer und goß Öl darauf. ");
INSERT INTO deuelo_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Und Jakob gab dem Orte, woselbst Gott mit ihm geredet hatte, den Namen Bethel. ");
INSERT INTO deuelo_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Und sie brachen auf von Bethel. Und es war noch eine Strecke Landes, um nach Ephrath zu kommen, da gebar Rahel, und es wurde ihr schwer bei ihrem Gebären. ");
INSERT INTO deuelo_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Und es geschah, als es ihr schwer wurde bei ihrem Gebären, da sprach die Hebamme zu ihr: Fürchte dich nicht, denn auch dieser ist dir ein Sohn! ");
INSERT INTO deuelo_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Und es geschah, als ihre Seele ausging (denn sie starb), da gab sie ihm den Namen Benoni; sein Vater aber nannte ihn Benjamin. ");
INSERT INTO deuelo_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Und Rahel starb und wurde begraben an dem Wege nach Ephrath, das ist Bethlehem. ");
INSERT INTO deuelo_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Und Jakob richtete über ihrem Grabe ein Denkmal auf, das ist das Grabmal Rahels bis auf diesen Tag. ");
INSERT INTO deuelo_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Und Israel brach auf und schlug sein Zelt auf jenseit von Migdal-Heder. ");
INSERT INTO deuelo_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Und es geschah, als Israel in jenem Lande wohnte, da ging Ruben hin und lag bei Bilha, dem Kebsweibe seines Vaters. Und Israel hörte es. Und der Söhne Jakobs waren zwölf. ");
INSERT INTO deuelo_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Die Söhne Leas: Ruben, der Erstgeborene Jakobs, und Simeon und Levi und Juda und Issaschar und Sebulon. ");
INSERT INTO deuelo_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Die Söhne Rahels: Joseph und Benjamin. ");
INSERT INTO deuelo_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Die Söhne Bilhas, der Magd Rahels: Dan und Naphtali. ");
INSERT INTO deuelo_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Und die Söhne Silpas, der Magd Leas: Gad und Aser. Das sind die Söhne Jakobs, welche ihm in Paddan-Aram geboren wurden. ");
INSERT INTO deuelo_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Und Jakob kam zu seinem Vater Isaak nach Mamre, nach Kirjath-Arba, das ist Hebron, woselbst Abraham und Isaak als Fremdlinge geweilt hatten. ");
INSERT INTO deuelo_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Und die Tage Isaaks waren hundertachtzig Jahre. ");
INSERT INTO deuelo_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Und Isaak verschied und starb und wurde versammelt zu seinen Völkern, alt und der Tage satt. Und Esau und Jakob, seine Söhne, begruben ihn. ");
INSERT INTO deuelo_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Und dies sind die Geschlechter Esaus, das ist Edom. ");
INSERT INTO deuelo_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau nahm seine Weiber von den Töchtern Kanaans: Ada, die Tochter Elons, des Hethiters, und Oholibama, die Tochter Anas, der Tochter Zibeons, des Hewiters, ");
INSERT INTO deuelo_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","und Basmath, die Tochter Ismaels, die Schwester Nebajoths. ");
INSERT INTO deuelo_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Und Ada gebar dem Esau Eliphas, und Basmath gebar Reghuel. ");
INSERT INTO deuelo_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Und Oholibama gebar Jeghusch und Jaghlam und Korach. Das sind die Söhne Esaus, welche ihm im Lande Kanaan geboren wurden. ");
INSERT INTO deuelo_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Und Esau nahm seine Weiber und seine Söhne und seine Töchter und alle Seelen seines Hauses, und seine Herden und all sein Vieh und all sein Besitztum, das er im Lande Kanaan erworben hatte, und zog in ein Land, von seinem Bruder Jakob hinweg. ");
INSERT INTO deuelo_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Denn ihre Habe war zu groß, daß sie hätten beieinander wohnen können, und das Land ihres Aufenthaltes vermochte sie nicht zu tragen wegen ihrer Herden. ");
INSERT INTO deuelo_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Und Esau wohnte auf dem Gebirge Seir. Esau, das ist Edom. ");
INSERT INTO deuelo_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Und dies sind die Geschlechter Esaus, des Vaters von Edom, auf dem Gebirge Seir. ");
INSERT INTO deuelo_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Dies sind die Namen der Söhne Esaus: Eliphas, der Sohn Adas, des Weibes Esaus; Reghuel, der Sohn Basmaths, des Weibes Esaus. ");
INSERT INTO deuelo_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Und die Söhne des Eliphas waren: Teman, Omar, Zepho und Gaetam und Kenas. ");
INSERT INTO deuelo_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Und Timna war das Kebsweib des Eliphas, des Sohnes Esaus, und sie gebar dem Eliphas Amalek. Das sind die Söhne Adas, des Weibes Esaus. ");
INSERT INTO deuelo_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Und dies sind die Söhne Reghuels: Nachath und Serach, Schamma und Missa. Das waren die Söhne Basmaths, des Weibes Esaus. ");
INSERT INTO deuelo_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Und dies waren die Söhne Oholibamas, der Tochter Anas, der Tochter Zibeons, des Weibes Esaus: sie gebar dem Esau Jeghusch, Jaghlam und Korach. ");
INSERT INTO deuelo_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Dies sind die Fürsten der Söhne Esaus: Die Söhne Eliphas', des Erstgeborenen Esaus: der Fürst Teman, der Fürst Omar, der Fürst Zepho, der Fürst Kenas, ");
INSERT INTO deuelo_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","der Fürst Korach, der Fürst Gaetam, der Fürst Amalek. Das sind die Fürsten des Eliphas im Lande Edom; das sind die Söhne Adas. ");
INSERT INTO deuelo_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Und dies sind die Söhne Reghuels, des Sohnes Esaus: der Fürst Nachath, der Fürst Serach, der Fürst Schamma, der Fürst Missa. Das sind die Fürsten des Reghuel im Lande Edom; das sind die Söhne Basmaths, des Weibes Esaus. ");
INSERT INTO deuelo_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Und dies sind die Söhne Oholibamas, des Weibes Esaus: der Fürst Jeghusch, der Fürst Jaghlam, der Fürst Korach. Das sind die Fürsten Oholibamas, der Tochter Anas, des Weibes Esaus. ");
INSERT INTO deuelo_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Das sind die Söhne Esaus und das ihre Fürsten; das ist Edom. ");
INSERT INTO deuelo_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Das sind die Söhne Seirs, des Horiters, die Bewohner des Landes: Lotan und Schobal und Zibeon und Ana und Dischon und Ezer und Dischan. ");
INSERT INTO deuelo_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Das sind die Fürsten der Horiter, der Söhne Seirs, im Lande Edom. ");
INSERT INTO deuelo_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Und die Söhne Lotans waren: Hori und Hemam, und die Schwester Lotans: Timna. ");
INSERT INTO deuelo_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Und dies sind die Söhne Schobals: Alwan und Manachath und Ebal, Schepho und Onam. ");
INSERT INTO deuelo_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Und dies sind die Söhne Zibeons: Aja und Ana. Das ist der Ana, welcher die warmen Quellen in der Wüste fand, als er die Esel Zibeons, seines Vaters, weidete. ");
INSERT INTO deuelo_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Und dies sind die Söhne Anas: Dischon, und Oholibama, die Tochter Anas. ");
INSERT INTO deuelo_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Und dies sind die Söhne Dischons: Hemdan und Eschban und Jithran und Keran. ");
INSERT INTO deuelo_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Dies sind die Söhne Ezers: Bilhan und Saawan und Akan. ");
INSERT INTO deuelo_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dies sind die Söhne Dischans: Uz und Aran. ");
INSERT INTO deuelo_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Dies sind die Fürsten der Horiter: der Fürst Lotan, der Fürst Schobal, der Fürst Zibeon, der Fürst Ana, ");
INSERT INTO deuelo_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","der Fürst Dischon, der Fürst Ezer, der Fürst Dischan. Das sind die Fürsten der Horiter, nach ihren Fürsten im Lande Seir. ");
INSERT INTO deuelo_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Und dies sind die Könige, die im Lande Edom regiert haben, ehe ein König über die Kinder Israel regierte: ");
INSERT INTO deuelo_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, der Sohn Beors, wurde König in Edom, und der Name seiner Stadt war Dinhaba. ");
INSERT INTO deuelo_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Und Bela starb; und es ward König an seiner Statt Jobab, der Sohn Serachs, aus Bozra. ");
INSERT INTO deuelo_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Und Jobab starb; und es ward König an seiner Statt Huscham, aus dem Lande der Temaniter. ");
INSERT INTO deuelo_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Und Huscham starb; und es ward König an seiner Statt Hadad, der Sohn Bedads, welcher Midian schlug im Gefilde Moabs; und der Name seiner Stadt war Awith. ");
INSERT INTO deuelo_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Und Hadad starb; und es ward König an seiner Statt Samla aus Masreka. ");
INSERT INTO deuelo_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Und Samla starb; und es ward König an seiner Statt Saul aus Rechoboth am Strome. ");
INSERT INTO deuelo_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Und Saul starb, und es ward König an seiner Statt Baal-Hanan, der Sohn Akbors. ");
INSERT INTO deuelo_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Und Baal-Hanan, der Sohn Akbors, starb; und es ward König an seiner Statt Hadar; und der Name seiner Stadt war Paghu, und der Name seines Weibes Mehetabeel, die Tochter Matreds, der Tochter Mesahabs. ");
INSERT INTO deuelo_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Und dies sind die Namen der Fürsten Esaus, nach ihren Familien, nach ihren Ortschaften, mit ihren Namen: der Fürst Timna, der Fürst Alwa, der Fürst Jetheth, ");
INSERT INTO deuelo_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","der Fürst Oholibama, der Fürst Ela, der Fürst Pinon, ");
INSERT INTO deuelo_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","der Fürst Kenas, der Fürst Teman, der Fürst Mibzar, ");
INSERT INTO deuelo_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","der Fürst Magdiel, der Fürst Iram. Das sind die Fürsten von Edom nach ihren Wohnsitzen, im Lande ihres Eigentums. Das ist Esau, der Vater Edoms. ");
INSERT INTO deuelo_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Und Jakob wohnte in dem Lande, in welchem sein Vater als Fremdling geweilt hatte, im Lande Kanaan. ");
INSERT INTO deuelo_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Dies ist die Geschichte Jakobs: Joseph, siebzehn Jahre alt, weidete die Herde mit seinen Brüdern; und er war als Knabe bei den Söhnen Bilhas und bei den Söhnen Silpas, der Weiber seines Vaters. Und Joseph hinterbrachte ihrem Vater die üble Nachrede von ihnen. ");
INSERT INTO deuelo_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Und Israel hatte Joseph lieber als alle seine Söhne, weil er der Sohn seines Alters war; und er machte ihm einen langen Leibrock. ");
INSERT INTO deuelo_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Und als seine Brüder sahen, daß ihr Vater ihn lieber hatte als alle seine Brüder, da haßten sie ihn und vermochten nicht, ihn zu grüßen. ");
INSERT INTO deuelo_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Und Joseph hatte einen Traum und teilte ihn seinen Brüdern mit; und sie haßten ihn noch mehr. ");
INSERT INTO deuelo_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Und er sprach zu ihnen: Höret doch diesen Traum, den ich gehabt habe: ");
INSERT INTO deuelo_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Siehe, wir banden Garben auf dem Felde, und siehe, meine Garbe richtete sich auf und blieb auch aufrecht stehen; und siehe, eure Garben kamen ringsum und verneigten sich vor meiner Garbe. ");
INSERT INTO deuelo_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Da sprachen seine Brüder zu ihm: Solltest du gar König über uns sein, solltest du gar über uns herrschen? Und sie haßten ihn noch mehr um seiner Träume und um seiner Worte willen. ");
INSERT INTO deuelo_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Und er hatte noch einen anderen Traum und erzählte ihn seinen Brüdern und sprach: Siehe, noch einen Traum habe ich gehabt, und siehe, die Sonne und der Mond und elf Sterne beugten sich vor mir nieder. ");
INSERT INTO deuelo_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Und er erzählte es seinem Vater und seinen Brüdern. Da schalt ihn sein Vater und sprach zu ihm: Was ist das für ein Traum, den du gehabt hast? Sollen wir gar kommen, ich und deine Mutter und deine Brüder, um uns vor dir zur Erde niederzubeugen? ");
INSERT INTO deuelo_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Und seine Brüder waren eifersüchtig auf ihn; aber sein Vater bewahrte das Wort. ");
INSERT INTO deuelo_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Und seine Brüder gingen hin, um die Herde ihres Vaters zu weiden zu Sichem. ");
INSERT INTO deuelo_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Und Israel sprach zu Joseph: Weiden nicht deine Brüder zu Sichem? Komm, daß ich dich zu ihnen sende! Und er sprach zu ihm: Hier bin ich. ");
INSERT INTO deuelo_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Und er sprach zu ihm: Gehe doch hin, sieh nach dem Wohlergehen deiner Brüder und nach dem Wohlergehen der Herde und bringe mir Antwort. Und er sandte ihn aus dem Tale von Hebron, und er kam nach Sichem. ");
INSERT INTO deuelo_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Und ein Mann fand ihn, und siehe, er irrte auf dem Felde umher; und der Mann fragte ihn und sprach: Was suchst du? ");
INSERT INTO deuelo_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Und er sprach: Ich suche meine Brüder; tue mir doch kund, wo sie weiden. ");
INSERT INTO deuelo_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Und der Mann sprach: Sie sind von hier aufgebrochen, denn ich hörte sie sagen: Laßt uns nach Dothan ziehen! Da ging Joseph seinen Brüdern nach und fand sie zu Dothan. ");
INSERT INTO deuelo_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Und sie sahen ihn von ferne; und ehe er ihnen nahte, da ersannen sie gegen ihn den Anschlag, ihn zu töten. ");
INSERT INTO deuelo_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Und sie sprachen einer zum anderen: Siehe, da kommt jener Träumer! ");
INSERT INTO deuelo_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","So kommt nun und laßt uns ihn erschlagen und ihn in eine der Gruben werfen, und wir wollen sagen: Ein böses Tier hat ihn gefressen; und wir werden sehen, was aus seinen Träumen wird. ");
INSERT INTO deuelo_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Und Ruben hörte es und errettete ihn aus ihrer Hand und sprach: Laßt uns ihn nicht totschlagen! ");
INSERT INTO deuelo_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Und Ruben sprach zu ihnen: Vergießet nicht Blut; werfet ihn in diese Grube, die in der Wüste ist, und leget nicht Hand an ihn auf daß er ihn aus ihrer Hand errettete, um ihn wieder zu seinem Vater zu bringen. ");
INSERT INTO deuelo_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Und es geschah, als Joseph zu seinen Brüdern kam, da zogen sie Joseph seinen Leibrock aus, den langen Leibrock, den er anhatte; ");
INSERT INTO deuelo_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","und sie nahmen ihn und warfen ihn in die Grube; die Grube aber war leer, es war kein Wasser darin. ");
INSERT INTO deuelo_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Und sie setzten sich, um zu essen. Und sie hoben ihre Augen auf und sahen: und siehe, ein Zug Ismaeliter kam von Gilead her; und ihre Kamele trugen Tragant und Balsamharz und Ladanum; sie zogen hin, um es nach Ägypten hinabzubringen. ");
INSERT INTO deuelo_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Da sprach Juda zu seinen Brüdern: Was für ein Gewinn ist es, daß wir unseren Bruder erschlagen und sein Blut verhehlen? ");
INSERT INTO deuelo_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Kommt, laßt uns ihn an die Ismaeliter verkaufen; aber unsere Hand sei nicht an ihm, denn unser Bruder, unser Fleisch ist er! Und seine Brüder hörten darauf. ");
INSERT INTO deuelo_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Als nun die midianitischen Männer, die Kaufleute, vorüberkamen, da zogen und holten sie Joseph aus der Grube herauf und verkauften Joseph an die Ismaeliter um zwanzig Silbersekel; und sie brachten Joseph nach Ägypten. ");
INSERT INTO deuelo_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Und als Ruben zur Grube zurückkam, und siehe, Joseph war nicht in der Grube, da zerriß er seine Kleider. ");
INSERT INTO deuelo_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Und er kehrte zu seinen Brüdern zurück und sprach: Der Knabe ist nicht da, und ich, wohin soll ich gehen? ");
INSERT INTO deuelo_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Und sie nahmen den Leibrock Josephs und schlachteten einen Ziegenbock und tauchten den Leibrock in das Blut; ");
INSERT INTO deuelo_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","und sie schickten den langen Leibrock hin und ließen ihn ihrem Vater bringen und sagen: Dieses haben wir gefunden; erkenne doch, ob es der Leibrock deines Sohnes ist oder nicht. ");
INSERT INTO deuelo_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Und er erkannte ihn und sprach: Der Leibrock meines Sohnes! Ein böses Tier hat ihn gefressen, Joseph ist gewißlich zerrissen worden! ");
INSERT INTO deuelo_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Und Jakob zerriß seine Kleider und legte Sacktuch um seine Lenden, und er trug Leid um seinen Sohn viele Tage. ");
INSERT INTO deuelo_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Und alle seine Söhne und alle seine Töchter machten sich auf, um ihn zu trösten; aber er verweigerte es, sich trösten zu lassen, und sprach: Denn leidtragend werde ich zu meinem Sohne hinabfahren in den Scheol! Und sein Vater beweinte ihn. ");
INSERT INTO deuelo_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Und die Midianiter verkauften ihn nach Ägypten, an Potiphar, einen Kämmerer des Pharao, den Obersten der Leibwache. ");
INSERT INTO deuelo_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Und es geschah zu selbiger Zeit, daß Juda von seinen Brüdern hinabzog und zu einem Manne von Adullam einkehrte mit Namen Hira. ");
INSERT INTO deuelo_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Und Juda sah daselbst die Tochter eines kanaanitischen Mannes mit Namen Schua; und er nahm sie und ging zu ihr ein. ");
INSERT INTO deuelo_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Und sie wurde schwanger und gebar einen Sohn, und er gab ihm den Namen Gher. ");
INSERT INTO deuelo_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Und sie wurde abermals schwanger und gebar einen Sohn, und sie gab ihm den Namen Onan. ");
INSERT INTO deuelo_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Und wiederum gebar sie einen Sohn, und sie gab ihm den Namen Schela; Juda war aber zu Kesib, als sie ihn gebar. ");
INSERT INTO deuelo_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Und Juda nahm ein Weib für Gher, seinen Erstgeborenen, und ihr Name war Tamar. ");
INSERT INTO deuelo_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Und Gher, der Erstgeborene Judas, war böse in den Augen Jehovas, und Jehova tötete ihn. ");
INSERT INTO deuelo_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Da sprach Juda zu Onan: Gehe ein zu dem Weibe deines Bruders, und leiste ihr die Schwagerpflicht und erwecke deinem Bruder Samen. ");
INSERT INTO deuelo_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Da aber Onan wußte, daß der Same nicht sein eigen sein sollte, so geschah es, wenn er zu dem Weibe seines Bruders einging, daß er ihn verderbte zur Erde, um seinem Bruder keinen Samen zu geben. ");
INSERT INTO deuelo_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Und es war übel in den Augen Jehovas, was er tat; und er tötete auch ihn. ");
INSERT INTO deuelo_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Da sprach Juda zu Tamar, seiner Schwiegertochter: Bleibe Witwe im Hause deines Vaters, bis mein Sohn Schela groß sein wird. Denn er sagte: Daß nicht auch er sterbe wie seine Brüder! Und Tamar ging hin und blieb im Hause ihres Vaters. ");
INSERT INTO deuelo_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Als der Tage viele geworden, da starb die Tochter Schuas, das Weib Judas. Und als Juda getröstet war, ging er zu seinen Schafscherern hinauf, er und Hira, sein Freund, der Adullamiter, nach Timna. ");
INSERT INTO deuelo_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Und es wurde der Tamar berichtet und gesagt: Siehe, dein Schwiegervater geht nach Timna hinauf, um seine Schafe zu scheren. ");
INSERT INTO deuelo_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Da legte sie die Kleider ihrer Witwenschaft von sich und bedeckte sich mit einem Schleier und verhüllte sich; und sie setzte sich an den Eingang von Enaim, das am Wege nach Timna liegt; denn sie sah, daß Schela groß geworden war und sie ihm nicht zum Weibe gegeben wurde. ");
INSERT INTO deuelo_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Und Juda sah sie und hielt sie für eine Hure, denn sie hatte ihr Angesicht bedeckt. ");
INSERT INTO deuelo_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Und er bog zu ihr ab in den Weg und sprach: Wohlan, laß mich zu dir eingehen! Denn er wußte nicht, daß sie seine Schwiegertochter war. Und sie sprach: Was willst du mir geben, daß du zu mir eingehst? ");
INSERT INTO deuelo_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Da sprach er: Ich will dir ein Ziegenböcklein von der Herde senden. Und sie sprach: Wenn du ein Pfand gibst, bis du es sendest. ");
INSERT INTO deuelo_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Und er sprach: Was für ein Pfand soll ich dir geben? Und sie sprach: Deinen Siegelring und deine Schnur und deinen Stab, der in deiner Hand ist. Da gab er es ihr und ging zu ihr ein, und sie ward schwanger von ihm. ");
INSERT INTO deuelo_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Und sie stand auf und ging hin, und sie legte ihren Schleier von sich und zog die Kleider ihrer Witwenschaft an. ");
INSERT INTO deuelo_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Und Juda sandte das Ziegenböcklein durch die Hand seines Freundes, des Adullamiters, um das Pfand aus der Hand des Weibes zu nehmen; aber er fand sie nicht. ");
INSERT INTO deuelo_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Und er fragte die Leute ihres Ortes und sprach: Wo ist jene Buhlerin, die zu Enaim am Wege war? Und sie sprachen: Hier ist keine Buhlerin gewesen. ");
INSERT INTO deuelo_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Und er kehrte zu Juda zurück und sprach: Ich habe sie nicht gefunden, und auch sagten die Leute des Ortes: Hier ist keine Buhlerin gewesen. ");
INSERT INTO deuelo_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Da sprach Juda: Sie behalte es für sich, daß wir nicht zum Gespött werden; siehe, ich habe dieses Böcklein gesandt, und du hast sie ja nicht gefunden. ");
INSERT INTO deuelo_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Und es geschah nach etwa drei Monaten, da wurde dem Juda berichtet und gesagt: Tamar, deine Schwiegertochter, hat gehurt, und siehe, sie ist auch schwanger von Hurerei. Da sprach Juda: Führet sie hinaus, daß sie verbrannt werde! ");
INSERT INTO deuelo_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Als sie hinausgeführt wurde, da sandte sie zu ihrem Schwiegervater und ließ ihm sagen: Von dem Manne, dem dieses gehört, bin ich schwanger; und sie sprach: Erkenne doch, wem dieser Siegelring und diese Schnur und dieser Stab gehören! ");
INSERT INTO deuelo_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Und Juda erkannte es und sprach: Sie ist gerechter als ich, darum daß ich sie nicht meinem Sohne Schela gegeben habe; und er erkannte sie hinfort nicht mehr. ");
INSERT INTO deuelo_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Und es geschah zur Zeit, als sie gebären sollte, siehe, da waren Zwillinge in ihrem Leibe. ");
INSERT INTO deuelo_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Und es geschah, während sie gebar, da streckte einer die Hand heraus, und die Hebamme nahm sie und band einen Karmesinfaden um seine Hand und sprach: Dieser ist zuerst herausgekommen. ");
INSERT INTO deuelo_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Und es geschah, als er seine Hand zurückzog, siehe, da kam sein Bruder heraus; und sie sprach: Wie bist du durchgebrochen! Auf dir sei der Bruch! Und man gab ihm den Namen Perez. ");
INSERT INTO deuelo_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Und danach kam sein Bruder heraus, um dessen Hand der Karmesinfaden war, und man gab ihm den Namen Serach. ");
INSERT INTO deuelo_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Und Joseph wurde nach Ägypten hinabgeführt; und Potiphar, ein Kämmerer des Pharao, der Oberste der Leibwache, ein ägyptischer Mann, kaufte ihn aus der Hand der Ismaeliter, die ihn dorthin hinabgeführt hatten. ");
INSERT INTO deuelo_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Und Jehova war mit Joseph, und er war ein Mann, dem alles gelang; und er war im Hause seines Herrn, des Ägypters. ");
INSERT INTO deuelo_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Und sein Herr sah, daß Jehova mit ihm war und daß Jehova alles, was er tat, in seiner Hand gelingen ließ. ");
INSERT INTO deuelo_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Und Joseph fand Gnade in seinen Augen und diente ihm; und er bestellte ihn über sein Haus, und alles, was er hatte, gab er in seine Hand. ");
INSERT INTO deuelo_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Und es geschah, seitdem er ihn über sein Haus bestellt und über alles, was er hatte, daß Jehova das Haus des Ägypters segnete um Josephs willen; und der Segen Jehovas war auf allem, was er hatte, im Hause und auf dem Felde. ");
INSERT INTO deuelo_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Und er überließ alles, was er hatte, der Hand Josephs und kümmerte sich um gar nichts bei ihm, außer um das Brot, das er aß. Und Joseph war schön von Gestalt und schön von Angesicht. ");
INSERT INTO deuelo_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Und es geschah nach diesen Dingen, da warf das Weib seines Herrn ihre Augen auf Joseph und sprach: Liege bei mir! ");
INSERT INTO deuelo_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Er aber weigerte sich und sprach zu dem Weibe seines Herrn: Siehe, mein Herr kümmert sich um nichts bei mir im Hause; und alles, was er hat, hat er in meine Hand gegeben. ");
INSERT INTO deuelo_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Niemand ist größer in diesem Hause als ich, und er hat mir gar nichts vorenthalten als nur dich, indem du sein Weib bist; und wie sollte ich dieses große Übel tun und wider Gott sündigen? ");
INSERT INTO deuelo_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Und es geschah, als sie Joseph Tag für Tag ansprach und er nicht auf sie hörte, bei ihr zu liegen, bei ihr zu sein, ");
INSERT INTO deuelo_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","da geschah es an einem solchen Tage, daß er ins Haus ging, um sein Geschäft zu besorgen, und kein Mensch von den Leuten des Hauses war daselbst im Hause; ");
INSERT INTO deuelo_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","und sie ergriff ihn bei seinem Kleide und sprach: Liege bei mir! Er aber ließ sein Kleid in ihrer Hand und floh und lief hinaus. ");
INSERT INTO deuelo_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Und es geschah, als sie sah, daß er sein Kleid in ihrer Hand gelassen hatte und hinausgeflohen war, ");
INSERT INTO deuelo_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","da rief sie den Leuten ihres Hauses und sprach zu ihnen und sagte: Sehet, er hat uns einen hebräischen Mann hergebracht, um Spott mit uns zu treiben. Er ist zu mir gekommen, um bei mir zu liegen, und ich habe mit lauter Stimme gerufen. ");
INSERT INTO deuelo_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Und es geschah, als er hörte, daß ich meine Stimme erhob und rief, da ließ er sein Kleid neben mir und floh und ging hinaus. ");
INSERT INTO deuelo_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Und sie legte sein Kleid neben sich, bis sein Herr nach Hause kam. ");
INSERT INTO deuelo_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Und sie redete zu ihm nach diesen Worten und sprach: Der hebräische Knecht, den du uns hergebracht hast, ist zu mir gekommen, um Spott mit mir zu treiben; ");
INSERT INTO deuelo_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","und es geschah, als ich meine Stimme erhob und rief, da ließ er sein Kleid neben mir und floh hinaus. ");
INSERT INTO deuelo_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Und es geschah, als sein Herr die Worte seines Weibes hörte, die sie zu ihm redete, indem sie sprach: Nach diesen Worten hat mir dein Knecht getan, da entbrannte sein Zorn. ");
INSERT INTO deuelo_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Und Josephs Herr nahm ihn und legte ihn in die Feste, an den Ort, wo die Gefangenen des Königs gefangen lagen; und er war daselbst in der Feste. ");
INSERT INTO deuelo_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Und Jehova war mit Joseph und wandte ihm Güte zu und gab ihm Gnade in den Augen des Obersten der Feste. ");
INSERT INTO deuelo_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Und der Oberste der Feste übergab alle Gefangenen, die in der Feste waren, der Hand Josephs; und alles, was daselbst zu tun war, das tat er. ");
INSERT INTO deuelo_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Der Oberste der Feste sah nicht nach dem Geringsten, das unter seiner Hand war, weil Jehova mit ihm war; und was er tat, ließ Jehova gelingen. ");
INSERT INTO deuelo_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Und es geschah nach diesen Dingen, da versündigten sich der Schenke des Königs von Ägypten und der Bäcker gegen ihren Herrn, den König von Ägypten. ");
INSERT INTO deuelo_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Und der Pharao ward sehr zornig über seine beiden Kämmerer, über den Obersten der Schenken und über den Obersten der Bäcker; ");
INSERT INTO deuelo_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","und er setzte sie in Gewahrsam in das Haus des Obersten der Leibwache, in die Feste, an den Ort, wo Joseph gefangen lag. ");
INSERT INTO deuelo_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Und der Oberste der Leibwache bestellte Joseph zu ihnen, und er bediente sie; und sie waren eine Zeitlang in Gewahrsam. ");
INSERT INTO deuelo_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Und sie hatten beide einen Traum, ein jeder seinen Traum in einer Nacht, ein jeder nach der Deutung seines Traumes, der Schenke und der Bäcker des Königs von Ägypten, die in der Feste gefangen lagen. ");
INSERT INTO deuelo_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Und Joseph kam am Morgen zu ihnen und sah sie, und siehe, sie waren mißmutig. ");
INSERT INTO deuelo_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Und er fragte die Kämmerer des Pharao, die mit ihm im Hause seines Herrn in Gewahrsam waren, und sprach: Warum sind eure Angesichter heute so trübe? ");
INSERT INTO deuelo_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Und sie sprachen zu ihm: Wir haben einen Traum gehabt, und da ist niemand, der ihn deute. Und Joseph sprach zu ihnen: Sind die Deutungen nicht Gottes? Erzählet mir doch. ");
INSERT INTO deuelo_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Da erzählte der Oberste der Schenken dem Joseph seinen Traum und sprach zu ihm: In meinem Traume, siehe, da war ein Weinstock vor mir, ");
INSERT INTO deuelo_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","und an dem Weinstock drei Reben; und sowie er knospte, schoß seine Blüte auf, seine Traubenkämme reiften zu Trauben. ");
INSERT INTO deuelo_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Und der Becher des Pharao war in meiner Hand, und ich nahm die Trauben und preßte sie aus in den Becher des Pharao und gab den Becher in des Pharao Hand. ");
INSERT INTO deuelo_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Und Joseph sprach zu ihm: Dies ist seine Deutung: Die drei Reben sind drei Tage. ");
INSERT INTO deuelo_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","In noch drei Tagen wird der Pharao dein Haupt erheben und dich wieder in deine Stelle einsetzen, und du wirst den Becher des Pharao in seine Hand geben, nach der früheren Weise, da du sein Schenke warst. ");
INSERT INTO deuelo_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Aber gedenke meiner bei dir, wenn es dir wohlgeht, und erweise doch Güte an mir und erwähne meiner bei dem Pharao und bringe mich aus diesem Hause heraus; ");
INSERT INTO deuelo_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","denn gestohlen bin ich aus dem Lande der Hebräer, und auch hier habe ich gar nichts getan, daß sie mich in den Kerker gesetzt haben. ");
INSERT INTO deuelo_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Und der Oberste der Bäcker sah, daß er gut gedeutet hatte, und er sprach zu Joseph: Auch ich sah in meinem Traume, und siehe, drei Körbe mit Weißbrot waren auf meinem Kopfe, ");
INSERT INTO deuelo_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","und im obersten Korbe allerlei Eßwaren des Pharao, Backwerk; und das Gevögel fraß sie aus dem Korbe auf meinem Kopfe weg. ");
INSERT INTO deuelo_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Und Joseph antwortete und sprach: Dies ist seine Deutung: ");
INSERT INTO deuelo_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Die drei Körbe sind drei Tage. In noch drei Tagen wird der Pharao dein Haupt erheben und dich an ein Holz hängen, und das Gevögel wird dein Fleisch von dir wegfressen. ");
INSERT INTO deuelo_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Und es geschah am dritten Tage, dem Geburtstage des Pharao, da machte er allen seinen Knechten ein Mahl; und er erhob das Haupt des Obersten der Schenken und das Haupt des Obersten der Bäcker unter seinen Knechten. ");
INSERT INTO deuelo_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Und er setzte den Obersten der Schenken wieder in sein Schenkamt, daß er den Becher in des Pharao Hand gab; ");
INSERT INTO deuelo_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","und den Obersten der Bäcker ließ er hängen, so wie Joseph ihnen gedeutet hatte. ");
INSERT INTO deuelo_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Aber der Oberste der Schenken gedachte nicht an Joseph und vergaß ihn. ");
INSERT INTO deuelo_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Und es geschah nach Verlauf von zwei vollen Jahren, daß der Pharao träumte: und siehe, er stand am Strome. ");
INSERT INTO deuelo_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Und siehe, aus dem Strome stiegen sieben Kühe herauf, schön von Ansehen und fett an Fleisch, und sie weideten im Riedgrase. ");
INSERT INTO deuelo_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Und siehe, sieben andere Kühe stiegen nach ihnen aus dem Strome herauf, häßlich von Ansehen und mager an Fleisch, und sie standen neben den Kühen am Ufer des Stromes. ");
INSERT INTO deuelo_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Und die Kühe, die häßlich von Ansehen und mager an Fleisch waren, fraßen die sieben Kühe, die schön von Ansehen und fett waren. Und der Pharao erwachte. ");
INSERT INTO deuelo_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Und er schlief ein und träumte zum zweiten Male: und siehe, sieben Ähren wuchsen auf an einem Halme, fett und schön. ");
INSERT INTO deuelo_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Und siehe, sieben Ähren, mager und vom Ostwinde versengt, sproßten nach ihnen auf. ");
INSERT INTO deuelo_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Und die mageren Ähren verschlangen die sieben fetten und vollen Ähren. Und der Pharao erwachte, und siehe, es war ein Traum. ");
INSERT INTO deuelo_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Und es geschah am Morgen, da war sein Geist voll Unruhe, und er sandte hin und ließ alle Schriftgelehrten Ägyptens und alle seine Weisen rufen; und der Pharao erzählte ihnen seine Träume, aber da war keiner, der sie dem Pharao deutete. ");
INSERT INTO deuelo_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Da redete der Oberste der Schenken zum Pharao und sprach: Ich gedenke heute meiner Sünden. ");
INSERT INTO deuelo_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Der Pharao war sehr zornig über seine Knechte und setzte mich in Gewahrsam in das Haus des Obersten der Leibwache, mich und den Obersten der Bäcker. ");
INSERT INTO deuelo_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Und wir hatten einen Traum in einer Nacht, ich und er; wir träumten ein jeder nach der Deutung seines Traumes. ");
INSERT INTO deuelo_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Und daselbst war bei uns ein hebräischer Jüngling, ein Knecht des Obersten der Leibwache, und wir erzählten sie ihm; und er deutete uns unsere Träume, einem jeden deutete er nach seinem Traume. ");
INSERT INTO deuelo_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Und es geschah, wie er uns deutete, also ist es geschehen: mich hat der Pharao wieder in meine Stelle eingesetzt, und ihn hat er gehängt. ");
INSERT INTO deuelo_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Da sandte der Pharao hin und ließ Joseph rufen; und sie ließen ihn eilends aus dem Kerker gehen. Und er schor sich und wechselte seine Kleider und kam zu dem Pharao. ");
INSERT INTO deuelo_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Und der Pharao sprach zu Joseph: Ich habe einen Traum gehabt, und da ist keiner, der ihn deute; ich habe aber von dir sagen hören, du verstehest einen Traum, ihn zu deuten. ");
INSERT INTO deuelo_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Und Joseph antwortete dem Pharao und sprach: Das steht nicht bei mir; Gott wird antworten, was dem Pharao zum Heil ist. ");
INSERT INTO deuelo_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Da sprach der Pharao zu Joseph: In meinem Traume, siehe, da stand ich am Ufer des Stromes. ");
INSERT INTO deuelo_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Und siehe, aus dem Strome stiegen sieben Kühe herauf, fett an Fleisch und schön von Gestalt, und sie weideten im Riedgrase. ");
INSERT INTO deuelo_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Und siehe, sieben andere Kühe stiegen nach ihnen herauf, dürr und sehr häßlich von Gestalt und mager an Fleisch; ich habe wie diese an Häßlichkeit keine gesehen im ganzen Lande Ägypten. ");
INSERT INTO deuelo_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Und die mageren und häßlichen Kühe fraßen die sieben ersten fetten Kühe; ");
INSERT INTO deuelo_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","und sie kamen in ihren Bauch, und man merkte nicht, daß sie in ihren Bauch gekommen waren, und ihr Ansehen war häßlich, wie im Anfang. Und ich erwachte. ");
INSERT INTO deuelo_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Und ich sah in meinem Traume, und siehe, sieben Ähren wuchsen auf an einem Halme, voll und schön. ");
INSERT INTO deuelo_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Und siehe, sieben Ähren, dürftig, mager, vom Ostwinde versengt, sproßten nach ihnen auf; ");
INSERT INTO deuelo_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","und die mageren Ähren verschlangen die sieben schönen Ähren. Und ich habe es den Schriftgelehrten gesagt; aber da war keiner, der es mir kundtat. ");
INSERT INTO deuelo_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Und Joseph sprach zum Pharao: Der Traum des Pharao ist einer; was Gott tun will, hat er dem Pharao kundgetan. ");
INSERT INTO deuelo_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Die sieben schönen Kühe sind sieben Jahre, und die sieben schönen Ähren sind sieben Jahre; ein Traum ist es. ");
INSERT INTO deuelo_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Und die sieben mageren und häßlichen Kühe, die nach ihnen heraufstiegen, sind sieben Jahre, so auch die sieben leeren, vom Ostwinde versengten Ähren: es werden sieben Jahre der Hungersnot sein. ");
INSERT INTO deuelo_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Das ist das Wort, das ich zu dem Pharao geredet habe: Was Gott tun will, hat er den Pharao sehen lassen. ");
INSERT INTO deuelo_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Siehe, sieben Jahre kommen, großer Überfluß wird sein im ganzen Lande Ägypten. ");
INSERT INTO deuelo_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Und nach ihnen werden sieben Jahre der Hungersnot entstehen, und aller Überfluß wird im Lande Ägypten vergessen sein, und die Hungersnot wird das Land verzehren. ");
INSERT INTO deuelo_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Und man wird nichts mehr von dem Überfluß im Lande wissen vor selbiger Hungersnot danach, denn sie wird sehr schwer sein. ");
INSERT INTO deuelo_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Und was die zweimalige Wiederholung des Traumes an den Pharao anlangt, es bedeutet, daß die Sache von seiten Gottes fest beschlossen ist und daß Gott eilt, sie zu tun. ");
INSERT INTO deuelo_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Und nun ersehe sich der Pharao einen verständigen und weisen Mann und setze ihn über das Land Ägypten. ");
INSERT INTO deuelo_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Dies tue der Pharao, daß er Aufseher über das Land bestelle und den Fünften vom Lande Ägypten nehme in den sieben Jahren des Überflusses; ");
INSERT INTO deuelo_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","und man sammle alle Speise dieser kommenden guten Jahre und schütte Getreide auf unter des Pharao Hand zur Speise in den Städten und bewahre es auf. ");
INSERT INTO deuelo_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Und die Speise sei zum Vorrat für das Land für die sieben Jahre der Hungersnot, welche im Lande Ägypten sein werden, daß das Land nicht vertilgt werde durch die Hungersnot. ");
INSERT INTO deuelo_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Und das Wort war gut in den Augen des Pharao und in den Augen aller seiner Knechte. ");
INSERT INTO deuelo_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Und der Pharao sprach zu seinen Knechten: Werden wir einen finden wie diesen, einen Mann, in welchem der Geist Gottes ist? ");
INSERT INTO deuelo_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Und der Pharao sprach zu Joseph: Nachdem Gott dir dies alles kundgetan hat, ist keiner so verständig und weise wie du. ");
INSERT INTO deuelo_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Du sollst über mein Haus sein, und deinem Befehle soll mein ganzes Volk sich fügen; nur um den Thron will ich größer sein als du. ");
INSERT INTO deuelo_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Und der Pharao sprach zu Joseph: Siehe, ich habe dich über das ganze Land Ägypten gesetzt. ");
INSERT INTO deuelo_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Und der Pharao nahm seinen Siegelring von seiner Hand und tat ihn an die Hand Josephs, und er kleidete ihn in Kleider von Byssus und legte die goldene Kette um seinen Hals. ");
INSERT INTO deuelo_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Und er ließ ihn auf dem zweiten Wagen fahren, den er hatte, und man rief vor ihm her: Werfet euch nieder! Und er setzte ihn über das ganze Land Ägypten. ");
INSERT INTO deuelo_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Und der Pharao sprach zu Joseph: Ich bin der Pharao, und ohne dich soll kein Mensch seine Hand oder seinen Fuß aufheben im ganzen Lande Ägypten. ");
INSERT INTO deuelo_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Und der Pharao gab Joseph den Namen: Zaphnath-Pahneach, und gab ihm Asnath, die Tochter Potipheras, des Priesters von On, zum Weibe. Und Joseph zog aus in das Land Ägypten. ");
INSERT INTO deuelo_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Und Joseph war dreißig Jahre alt, als er vor dem Pharao, dem Könige von Ägypten, stand. Und Joseph ging weg von dem Pharao und zog durch das ganze Land Ägypten. ");
INSERT INTO deuelo_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Und das Land trug in den sieben Jahren des Überflusses händevoll. ");
INSERT INTO deuelo_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Und er sammelte alle Speise der sieben Jahre, die im Lande Ägypten waren, und legte die Speise in die Städte; die Speise des Gefildes der Stadt, das um sie her war, legte er darein. ");
INSERT INTO deuelo_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Und Joseph schüttete Getreide auf wie Sand des Meeres, über die Maßen viel, bis man aufhörte zu zählen, denn es war ohne Zahl. ");
INSERT INTO deuelo_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Und dem Joseph wurden zwei Söhne geboren, ehe das Jahr der Hungersnot kam, welche Asnath ihm gebar, die Tochter Potipheras, des Priesters von On. ");
INSERT INTO deuelo_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Und Joseph gab dem Erstgeborenen den Namen Manasse: denn Gott hat mich vergessen lassen all meine Mühsal und das ganze Haus meines Vaters. ");
INSERT INTO deuelo_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Und dem Zweiten gab er den Namen Ephraim: denn Gott hat mich fruchtbar gemacht im Lande meines Elends. ");
INSERT INTO deuelo_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Und es endigten die sieben Jahre des Überflusses, der im Lande Ägypten gewesen war; ");
INSERT INTO deuelo_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","und die sieben Jahre der Hungersnot begannen zu kommen, so wie Joseph gesagt hatte. Und es war Hungersnot in allen Ländern, aber im ganzen Lande Ägypten war Brot. ");
INSERT INTO deuelo_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Und das ganze Land Ägypten hungerte; und das Volk schrie zum Pharao um Brot. Da sprach der Pharao zu allen Ägyptern: Gehet zu Joseph; tut, was er euch sagt! ");
INSERT INTO deuelo_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Und die Hungersnot war auf der ganzen Erde; und Joseph tat alles auf, worin Getreide war, und verkaufte es den Ägyptern; und die Hungersnot war stark im Lande Ägypten. ");
INSERT INTO deuelo_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Und alle Welt kam nach Ägypten zu Joseph, um Getreide zu kaufen; denn die Hungersnot war stark auf der ganzen Erde. ");
INSERT INTO deuelo_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Und Jakob sah, daß Getreide in Ägypten war, und Jakob sprach zu seinen Söhnen: Was sehet ihr einander an? ");
INSERT INTO deuelo_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Und er sprach: Siehe, ich habe gehört, daß Getreide in Ägypten ist; ziehet hinab und kaufet uns von dort Getreide, daß wir leben und nicht sterben. ");
INSERT INTO deuelo_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Und die zehn Brüder Josephs zogen hinab, um Getreide aus Ägypten zu kaufen. ");
INSERT INTO deuelo_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Aber Benjamin, Josephs Bruder, sandte Jakob nicht mit seinen Brüdern; denn er sprach: Daß ihm nicht etwa ein Unfall begegne. ");
INSERT INTO deuelo_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Und so kamen die Söhne Israels unter den Ankommenden, um Getreide zu kaufen; denn die Hungersnot war im Lande Kanaan. ");
INSERT INTO deuelo_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Und Joseph, er war der Gebieter über das Land, er verkaufte das Getreide allem Volke des Landes. Und die Brüder Josephs kamen und beugten sich vor ihm nieder, mit dem Antlitz zur Erde. ");
INSERT INTO deuelo_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Und Joseph sah seine Brüder und erkannte sie; aber er stellte sich fremd gegen sie und redete hart mit ihnen und sprach zu ihnen: Woher kommet ihr? Und sie sprachen: Aus dem Lande Kanaan, um Speise zu kaufen. ");
INSERT INTO deuelo_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Und Joseph erkannte seine Brüder; sie aber erkannten ihn nicht. ");
INSERT INTO deuelo_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Und Joseph gedachte der Träume, die er von ihnen gehabt hatte, und er sprach zu ihnen: Ihr seid Kundschafter; um zu sehen, wo das Land offen ist, seid ihr gekommen. ");
INSERT INTO deuelo_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Da sprachen sie zu ihm: Nein, mein Herr; sondern deine Knechte sind gekommen, um Speise zu kaufen. ");
INSERT INTO deuelo_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Wir alle sind eines Mannes Söhne; wir sind redlich, deine Knechte sind nicht Kundschafter. ");
INSERT INTO deuelo_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Und er sprach zu ihnen: Nein, sondern ihr seid gekommen, um zu sehen, wo das Land offen ist. ");
INSERT INTO deuelo_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Und sie sprachen: Zwölf Brüder sind wir, deine Knechte, Söhne eines Mannes im Lande Kanaan; und siehe, der jüngste ist heute bei unserem Vater, und der eine ist nicht mehr. ");
INSERT INTO deuelo_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Da sprach Joseph zu ihnen: Das ist es, was ich zu euch gesagt habe: Kundschafter seid ihr! ");
INSERT INTO deuelo_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Daran sollt ihr geprüft werden: Beim Leben des Pharao! Wenn ihr von hier weggehet, es sei denn, daß euer jüngster Bruder hierher komme! ");
INSERT INTO deuelo_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Sendet einen von euch hin, daß er euren Bruder hole; ihr aber bleibet gefangen, und eure Worte sollen geprüft werden, ob Wahrheit bei euch ist; und wenn nicht beim Leben des Pharao! so seid ihr Kundschafter. ");
INSERT INTO deuelo_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Und er setzte sie drei Tage zusammen in Gewahrsam. ");
INSERT INTO deuelo_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Und am dritten Tage sprach Joseph zu ihnen: Tut dieses, und ihr sollt leben; ich fürchte Gott: ");
INSERT INTO deuelo_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Wenn ihr redlich seid, so bleibe einer eurer Brüder gefangen im Hause eures Gewahrsams; ihr aber, ziehet hin, bringet Getreide für den Bedarf eurer Häuser; ");
INSERT INTO deuelo_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","und euren jüngsten Bruder sollt ihr zu mir bringen, daß eure Worte sich bewähren, und ihr nicht sterbet. Und sie taten also. ");
INSERT INTO deuelo_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Da sprachen sie einer zum anderen: Fürwahr, wir sind schuldig wegen unseres Bruders, dessen Seelenangst wir sahen, als er zu uns flehte, und wir hörten nicht; darum ist diese Drangsal über uns gekommen. ");
INSERT INTO deuelo_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Und Ruben antwortete ihnen und sprach: Habe ich nicht zu euch gesprochen und gesagt: Versündiget euch nicht an dem Knaben? Aber ihr hörtet nicht; und siehe, sein Blut wird auch gefordert! ");
INSERT INTO deuelo_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Sie aber wußten nicht, daß Joseph es verstand, denn ein Dolmetscher war zwischen ihnen. ");
INSERT INTO deuelo_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Und er wandte sich von ihnen ab und weinte. Und er kehrte zu ihnen zurück und redete zu ihnen; und er nahm Simeon aus ihrer Mitte und band ihn vor ihren Augen. ");
INSERT INTO deuelo_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Und Joseph gebot, daß man ihre Gefäße mit Getreide fülle und ihr Geld zurückgebe, einem jeden in seinen Sack, und ihnen Zehrung gebe auf den Weg. Und man tat ihnen also. ");
INSERT INTO deuelo_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Und sie luden ihr Getreide auf ihre Esel und zogen von dannen. ");
INSERT INTO deuelo_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Und einer öffnete seinen Sack, um seinem Esel in der Herberge Futter zu geben; und er sah sein Geld, und siehe, es war oben in seinem Sacke. ");
INSERT INTO deuelo_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Und er sprach zu seinen Brüdern: Mein Geld ist mir wieder geworden, und siehe, es ist sogar in meinem Sacke. Da entfiel ihnen das Herz, und sie sahen einander erschrocken an und sprachen: Was hat Gott uns da getan! ");
INSERT INTO deuelo_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Und sie kamen in das Land Kanaan zu ihrem Vater Jakob und berichteten ihm alles, was ihnen widerfahren war, und sprachen: ");
INSERT INTO deuelo_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Der Mann, der Herr des Landes, redete hart mit uns und behandelte uns wie Kundschafter des Landes. ");
INSERT INTO deuelo_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Und wir sprachen zu ihm: Wir sind redlich, wir sind nicht Kundschafter; ");
INSERT INTO deuelo_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","zwölf Brüder sind wir, Söhne unseres Vaters; der eine ist nicht mehr, und der jüngste ist heute bei unserem Vater im Lande Kanaan. ");
INSERT INTO deuelo_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Und der Mann, der Herr des Landes, sprach zu uns: Daran werde ich erkennen, daß ihr redlich seid: Einen eurer Brüder lasset bei mir, und nehmet den Bedarf eurer Häuser und ziehet hin; ");
INSERT INTO deuelo_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","und bringet ihr euren jüngsten Bruder zu mir, so werde ich erkennen, daß ihr nicht Kundschafter, sondern redlich seid; euren Bruder werde ich euch zurückgeben, und ihr möget im Lande verkehren. ");
INSERT INTO deuelo_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Und es geschah, als sie ihre Säcke leerten, siehe, da hatte ein jeder sein Geldbündel in seinem Sacke; und sie sahen ihre Geldbündel, sie und ihr Vater, und sie fürchteten sich. ");
INSERT INTO deuelo_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Und ihr Vater Jakob sprach zu ihnen: Ihr habt mich der Kinder beraubt: Joseph ist nicht mehr, und Simeon ist nicht mehr; und Benjamin wollt ihr nehmen! Dies alles kommt über mich! ");
INSERT INTO deuelo_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Und Ruben sprach zu seinem Vater und sagte: Meine beiden Söhne darfst du töten, wenn ich ihn nicht zu dir zurückbringe. Gib ihn in meine Hand, und ich werde ihn zu dir zurückbringen. ");
INSERT INTO deuelo_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Er aber sprach: Mein Sohn soll nicht mit euch hinabziehen; denn sein Bruder ist tot, und er allein ist übriggeblieben, und begegnete ihm ein Unfall auf dem Wege, auf welchem ihr ziehet, so würdet ihr mein graues Haar mit Kummer hinabbringen in den Scheol. ");
INSERT INTO deuelo_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Und die Hungersnot war schwer im Lande. ");
INSERT INTO deuelo_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Und es geschah, als sie das Getreide aufgezehrt hatten, das sie aus Ägypten gebracht, da sprach ihr Vater zu ihnen: Ziehet wiederum hin, kaufet uns ein wenig Speise. ");
INSERT INTO deuelo_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Und Juda sprach zu ihm und sagte: Der Mann hat uns ernstlich bezeugt und gesagt: Ihr sollt mein Angesicht nicht sehen, es sei denn euer Bruder bei euch. ");
INSERT INTO deuelo_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Wenn du unseren Bruder mit uns senden willst, so wollen wir hinabziehen und dir Speise kaufen; ");
INSERT INTO deuelo_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","wenn du ihn aber nicht sendest, so werden wir nicht hinabziehen; denn der Mann hat zu uns gesagt: Ihr sollt mein Angesicht nicht sehen, es sei denn euer Bruder bei euch. ");
INSERT INTO deuelo_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Da sprach Israel: Warum habt ihr mir das Leid angetan, dem Manne kundzutun, daß ihr noch einen Bruder habt? ");
INSERT INTO deuelo_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Und sie sprachen: Der Mann erkundigte sich genau nach uns und unserer Verwandtschaft und sprach: Lebt euer Vater noch? Habt ihr noch einen Bruder? und wir taten es ihm kund nach diesen Worten. Konnten wir denn wissen, daß er sagen würde: Bringet euren Bruder herab? ");
INSERT INTO deuelo_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Und Juda sprach zu Israel, seinem Vater: Sende den Knaben mit mir, und wir wollen uns aufmachen und ziehen, daß wir leben und nicht sterben, sowohl wir als du als auch unsere Kinder. ");
INSERT INTO deuelo_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ich will Bürge für ihn sein, von meiner Hand sollst du ihn fordern; wenn ich ihn nicht zu dir bringe und ihn vor dein Angesicht stelle, so will ich alle Tage gegen dich gesündigt haben; ");
INSERT INTO deuelo_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","denn hätten wir nicht gezögert, gewiß, wir wären jetzt schon zweimal zurückgekehrt. ");
INSERT INTO deuelo_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Und Israel, ihr Vater, sprach zu ihnen: Wenn es denn also ist, so tut dieses: Nehmet von dem Besten des Landes in eure Gefäße und bringet dem Manne ein Geschenk hinab: ein wenig Balsam und ein wenig Traubenhonig, Tragant und Ladanum, Pistazien und Mandeln. ");
INSERT INTO deuelo_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Und nehmet doppeltes Geld in eure Hand, und bringet das Geld, das euch oben in euren Säcken wieder geworden ist, in eurer Hand zurück; vielleicht ist es ein Irrtum. ");
INSERT INTO deuelo_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Und nehmet euren Bruder und machet euch auf, kehret zu dem Manne zurück. ");
INSERT INTO deuelo_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Und Gott, der Allmächtige, gebe euch Barmherzigkeit vor dem Manne, daß er euch euren anderen Bruder und Benjamin loslasse. Und ich, wenn ich der Kinder beraubt bin, so bin ich der Kinder beraubt! ");
INSERT INTO deuelo_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Da nahmen die Männer dieses Geschenk und nahmen doppeltes Geld in ihre Hand und Benjamin, und machten sich auf und zogen nach Ägypten hinab. Und sie traten vor Joseph. ");
INSERT INTO deuelo_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Und als Joseph den Benjamin bei ihnen sah, sprach er zu dem, der über sein Haus war: Führe die Männer ins Haus und schlachte Schlachtvieh und richte zu; denn die Männer sollen mit mir zu Mittag essen. ");
INSERT INTO deuelo_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Und der Mann tat, wie Joseph gesagt hatte; und der Mann führte die Männer in das Haus Josephs. ");
INSERT INTO deuelo_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Da fürchteten sich die Männer, daß sie in das Haus Josephs geführt wurden, und sprachen: Um des Geldes willen, das im Anfang wieder in unsere Säcke gekommen ist, werden wir hineingeführt, daß man über uns herstürze und über uns herfalle und uns zu Knechten nehme, samt unseren Eseln. ");
INSERT INTO deuelo_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Und sie traten zu dem Manne, der über das Haus Josephs war, und redeten zu ihm am Eingang des Hauses ");
INSERT INTO deuelo_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","und sprachen: Bitte, mein Herr! Wir sind im Anfang herabgezogen, um Speise zu kaufen. ");
INSERT INTO deuelo_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Und es geschah, als wir in die Herberge kamen und unsere Säcke öffneten, siehe, da war eines jeden Geld oben in seinem Sacke, unser Geld nach seinem Gewicht; und wir haben es in unserer Hand zurückgebracht. ");
INSERT INTO deuelo_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Und anderes Geld haben wir in unserer Hand herabgebracht, um Speise zu kaufen. Wir wissen nicht, wer unser Geld in unsere Säcke gelegt hat. ");
INSERT INTO deuelo_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Und er sprach: Friede euch! Fürchtet euch nicht! Euer Gott und der Gott eures Vaters hat euch einen Schatz in eure Säcke gegeben; euer Geld ist mir zugekommen. Und er führte Simeon zu ihnen heraus. ");
INSERT INTO deuelo_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Und der Mann führte die Männer in das Haus Josephs und gab ihnen Wasser, und sie wuschen ihre Füße; und er gab ihren Eseln Futter. ");
INSERT INTO deuelo_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Und sie bereiteten das Geschenk zu, bis Joseph am Mittag kam; denn sie hatten gehört, daß sie daselbst essen sollten. ");
INSERT INTO deuelo_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Als Joseph nach Hause kam, da brachten sie ihm das Geschenk, das in ihrer Hand war, ins Haus und beugten sich vor ihm nieder zur Erde. ");
INSERT INTO deuelo_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Und er fragte nach ihrem Wohlergehen und sprach: Geht es eurem Vater wohl, dem Greise, von dem ihr sprachet? Lebt er noch? ");
INSERT INTO deuelo_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Da sprachen sie: Es geht deinem Knechte, unserem Vater, wohl; er lebt noch. Und sie verneigten sich und beugten sich nieder. ");
INSERT INTO deuelo_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Und er erhob seine Augen und sah seinen Bruder Benjamin, den Sohn seiner Mutter, und sprach: Ist das euer jüngster Bruder, von dem ihr zu mir sprachet? Und er sprach: Gott sei dir gnädig, mein Sohn! ");
INSERT INTO deuelo_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Und Joseph eilte (denn sein Innerstes wurde erregt über seinen Bruder) und suchte einen Ort, um zu weinen, und er ging in das innere Gemach und weinte daselbst. ");
INSERT INTO deuelo_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Und er wusch sein Angesicht und kam heraus und bezwang sich und sprach: Traget Speise auf! ");
INSERT INTO deuelo_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Und man trug für ihn besonders auf und für sie besonders und für die Ägypter, die mit ihm aßen, besonders; denn die Ägypter dürfen nicht mit den Hebräern essen, denn das ist den Ägyptern ein Greuel. ");
INSERT INTO deuelo_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Und sie aßen vor ihm, der Erstgeborene nach seiner Erstgeburt und der Jüngste nach seiner Jugend; und die Männer sahen einander staunend an. ");
INSERT INTO deuelo_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Und man trug Ehrengerichte von ihm zu ihnen; und das Ehrengericht Benjamins war fünfmal größer als die Ehrengerichte von ihnen allen. Und sie tranken und tranken sich fröhlich mit ihm. ");
INSERT INTO deuelo_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Und er gebot dem, der über sein Haus war, und sprach: Fülle die Säcke der Männer mit Speise, so viel sie tragen können, und lege das Geld eines jeden oben in seinen Sack. ");
INSERT INTO deuelo_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Und meinen Kelch, den silbernen Kelch, sollst du oben in den Sack des Jüngsten legen mit dem Gelde für sein Getreide. Und er tat nach den Worte Josephs, das er geredet hatte. ");
INSERT INTO deuelo_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Als der Morgen anbrach, da wurden die Männer entlassen, sie und ihre Esel. ");
INSERT INTO deuelo_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Sie waren eben zur Stadt hinausgegangen, sie waren noch nicht weit, da sprach Joseph zu dem, der über sein Haus war: Mache dich auf, jage den Männern nach, und hast du sie erreicht, so sage zu ihnen: Warum habt ihr Böses für Gutes vergolten? ");
INSERT INTO deuelo_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ist es nicht der, aus welchem mein Herr trinkt und aus dem er zu wahrsagen pflegt? Ihr habt übel getan, was ihr getan habt! ");
INSERT INTO deuelo_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Und er erreichte sie und redete diese Worte zu ihnen. ");
INSERT INTO deuelo_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Und sie sprachen zu ihm: Warum redet mein Herr solche Worte? Fern sei es von deinen Knechten, eine solche Sache zu tun! ");
INSERT INTO deuelo_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Siehe, das Geld, das wir oben in unseren Säcken fanden, haben wir dir aus dem Lande Kanaan zurückgebracht, und wie sollten wir aus dem Hause deines Herrn Silber oder Gold stehlen? ");
INSERT INTO deuelo_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Bei welchem von deinen Knechten er gefunden wird, der sterbe; und dazu wollen wir meines Herrn Knechte sein. ");
INSERT INTO deuelo_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Da sprach er: Nun, nach euren Worten, so sei es auch: bei wem er gefunden wird, der sei mein Knecht, ihr aber sollt schuldlos sein. ");
INSERT INTO deuelo_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Und sie eilten und hoben ein jeder seinen Sack auf die Erde herab und öffneten ein jeder seinen Sack. ");
INSERT INTO deuelo_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Und er durchsuchte: beim Ältesten fing er an, und beim Jüngsten hörte er auf; und der Kelch fand sich im Sacke Benjamins. ");
INSERT INTO deuelo_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Da zerrissen sie ihre Kleider, und ein jeder belud seinen Esel, und sie kehrten in die Stadt zurück. ");
INSERT INTO deuelo_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Und Juda und seine Brüder kamen in das Haus Josephs; und er war noch daselbst, und sie fielen vor ihm nieder zur Erde. ");
INSERT INTO deuelo_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Und Joseph sprach zu ihnen: Was ist das für eine Tat, die ihr getan habt! Wußtet ihr nicht, daß solch ein Mann wie ich wahrsagen kann? ");
INSERT INTO deuelo_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Und Juda sprach: Was sollen wir meinem Herrn sagen? Was sollen wir reden und wie uns rechtfertigen? Gott hat die Missetat deiner Knechte gefunden; siehe, wir sind die Knechte meines Herrn, sowohl wir als auch der, in dessen Hand der Kelch gefunden worden ist. ");
INSERT INTO deuelo_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Und er sprach: Fern sei es von mir, solches zu tun! Der Mann, in dessen Hand der Kelch gefunden worden ist, der soll mein Knecht sein; und ihr, ziehet in Frieden hinauf zu eurem Vater. ");
INSERT INTO deuelo_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Da trat Juda zu ihm und sprach: Bitte, mein Herr, laß doch deinen Knecht ein Wort reden zu den Ohren meines Herrn, und es entbrenne nicht dein Zorn gegen deinen Knecht, denn du bist gleich dem Pharao. ");
INSERT INTO deuelo_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Mein Herr fragte seine Knechte und sprach: Habt ihr noch einen Vater oder einen Bruder? ");
INSERT INTO deuelo_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Und wir sprachen zu meinem Herrn: Wir haben einen alten Vater und einen jungen Knaben, der ihm im Alter geboren wurde; und dessen Bruder ist tot, und er allein ist von seiner Mutter übriggeblieben, und sein Vater hat ihn lieb. ");
INSERT INTO deuelo_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Und du sprachst zu deinen Knechten: Bringet ihn zu mir herab, daß ich mein Auge auf ihn richte. ");
INSERT INTO deuelo_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Und wir sprachen zu meinem Herrn: Der Knabe kann seinen Vater nicht verlassen; verließe er seinen Vater, so stürbe er. ");
INSERT INTO deuelo_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Da sprachst du zu deinen Knechten: Wenn euer jüngster Bruder nicht mit euch herabkommt, so sollt ihr mein Angesicht nicht mehr sehen. ");
INSERT INTO deuelo_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Und es geschah, als wir hinaufgezogen waren zu deinem Knechte, meinem Vater, da berichteten wir ihm die Worte meines Herrn. ");
INSERT INTO deuelo_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Und unser Vater sprach: Ziehet wieder hin, kaufet uns ein wenig Speise. ");
INSERT INTO deuelo_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Wir aber sprachen: Wir können nicht hinabziehen. Wenn unser jüngster Bruder bei uns ist, so wollen wir hinabziehen; denn wir dürfen das Angesicht des Mannes nicht sehen, wenn unser jüngster Bruder nicht bei uns ist. ");
INSERT INTO deuelo_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Und dein Knecht, mein Vater, sprach zu uns: Ihr wisset, daß mein Weib mir zwei geboren hat; ");
INSERT INTO deuelo_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","und der eine ist von mir weggegangen, und ich sprach: Fürwahr, er ist gewißlich zerrissen worden; und ich habe ihn nicht mehr gesehen bis jetzt. ");
INSERT INTO deuelo_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Und nehmet ihr auch diesen von mir hinweg, und es begegnet ihm ein Unfall, so werdet ihr mein graues Haar mit Unglück hinabbringen in den Scheol. ");
INSERT INTO deuelo_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Und nun, wenn ich zu deinem Knechte, meinem Vater, komme, und der Knabe ist nicht bei uns und seine Seele hängt an dessen Seele, - ");
INSERT INTO deuelo_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","so wird es geschehen, daß er stirbt, wenn er sieht, daß der Knabe nicht da ist; und deine Knechte werden das graue Haar deines Knechtes, unseres Vaters, mit Kummer hinabbringen in den Scheol. ");
INSERT INTO deuelo_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Denn dein Knecht ist für den Knaben Bürge geworden bei meinem Vater, indem ich sprach: Wenn ich ihn nicht zu dir bringe, so will ich alle Tage gegen meinen Vater gesündigt haben. ");
INSERT INTO deuelo_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Und nun, laß doch deinen Knecht anstatt des Knaben bleiben, als Knecht meines Herrn, und der Knabe ziehe hinauf mit seinen Brüdern; ");
INSERT INTO deuelo_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","denn wie sollte ich zu meinem Vater hinaufziehen, wenn der Knabe nicht bei mir wäre? daß ich nicht das Unglück ansehen müsse, welches meinen Vater treffen würde! ");
INSERT INTO deuelo_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Da konnte Joseph sich nicht mehr bezwingen vor allen, die um ihn standen, und er rief: Laßt jedermann von mir hinausgehen! Und es stand niemand bei ihm, als Joseph sich seinen Brüdern zu erkennen gab. ");
INSERT INTO deuelo_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Und er erhob seine Stimme mit Weinen; und die Ägypter hörten es, und das Haus des Pharao hörte es. ");
INSERT INTO deuelo_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Und Joseph sprach zu seinen Brüdern: Ich bin Joseph. Lebt mein Vater noch? Und seine Brüder konnten ihm nicht antworten, denn sie waren bestürzt vor ihm. ");
INSERT INTO deuelo_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Da sprach Joseph zu seinen Brüdern: Tretet doch zu mir her! Und sie traten herzu. Und er sprach: Ich bin Joseph, euer Bruder, den ihr nach Ägypten verkauft habt. ");
INSERT INTO deuelo_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Und nun betrübet euch nicht, und es entbrenne nicht in euren Augen, daß ihr mich hierher verkauft habt; denn zur Erhaltung des Lebens hat Gott mich vor euch hergesandt. ");
INSERT INTO deuelo_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Denn schon zwei Jahre ist die Hungersnot im Lande, und noch sind fünf Jahre, daß kein Pflügen noch Ernten sein wird. ");
INSERT INTO deuelo_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Und Gott hat mich vor euch hergesandt, um euch einen Überrest zu setzen auf Erden und euch am Leben zu erhalten für eine große Errettung. ");
INSERT INTO deuelo_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Und nun, nicht ihr habt mich hierher gesandt, sondern Gott; und er hat mich zum Vater des Pharao gemacht und zum Herrn seines ganzen Hauses und zum Herrscher über das ganze Land Ägypten. ");
INSERT INTO deuelo_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Eilet und ziehet hinauf zu meinem Vater und sprechet zu ihm: So spricht dein Sohn Joseph: Gott hat mich zum Herrn von ganz Ägypten gemacht; komm zu mir herab, säume nicht! ");
INSERT INTO deuelo_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Und du sollst im Lande Gosen wohnen und nahe bei mir sein, du und deine Söhne und die Söhne deiner Söhne und dein Kleinvieh und deine Rinder und alles, was du hast. ");
INSERT INTO deuelo_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Und ich will dich daselbst versorgen, denn noch fünf Jahre ist Hungersnot; daß du nicht verarmest, du und dein Haus und alles, was du hast. ");
INSERT INTO deuelo_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Und siehe, eure Augen sehen es und die Augen meines Bruders Benjamin, daß mein Mund es ist, der zu euch redet. ");
INSERT INTO deuelo_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Und berichtet meinem Vater alle meine Herrlichkeit in Ägypten und alles, was ihr gesehen habt; und eilet und bringet meinen Vater hierher herab. ");
INSERT INTO deuelo_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Und er fiel seinem Bruder Benjamin um den Hals und weinte; und Benjamin weinte an seinem Halse. ");
INSERT INTO deuelo_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Und er küßte alle seine Brüder und weinte an ihnen; und danach redeten seine Brüder mit ihm. ");
INSERT INTO deuelo_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Und das Gerücht wurde im Hause des Pharao gehört, indem man sprach: Josephs Brüder sind gekommen! Und es war gut in den Augen des Pharao und in den Augen seiner Knechte. ");
INSERT INTO deuelo_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Und der Pharao sprach zu Joseph: Sage deinen Brüdern: Tut dieses: Beladet eure Tiere und ziehet hin, gehet nach dem Lande Kanaan, ");
INSERT INTO deuelo_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","und nehmet euren Vater und eure Haushaltungen und kommet zu mir; und ich will euch das Beste des Landes Ägypten geben, und ihr sollt das Fett des Landes essen. ");
INSERT INTO deuelo_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Und du bist beauftragt: Tut dieses: Nehmet euch aus dem Lande Ägypten Wagen für eure Kinder und für eure Weiber, und holet euren Vater und kommet. ");
INSERT INTO deuelo_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Und laßt es euch nicht leid sein um euren Hausrat, denn das Beste des ganzen Landes Ägypten soll euer sein. ");
INSERT INTO deuelo_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Und die Söhne Israels taten also, und Joseph gab ihnen Wagen nach dem Befehl des Pharao und gab ihnen Zehrung auf den Weg. ");
INSERT INTO deuelo_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Er gab ihnen allen, einem jeden, Wechselkleider, und Benjamin gab er dreihundert Silbersekel und fünf Wechselkleider. ");
INSERT INTO deuelo_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Und seinem Vater sandte er dieses: zehn Esel, beladen mit dem Besten Ägyptens, und zehn Eselinnen, beladen mit Getreide und Brot und Nahrung für seinen Vater auf den Weg. ");
INSERT INTO deuelo_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Und er entließ seine Brüder, und sie zogen hin; und er sprach zu ihnen: Erzürnet euch nicht auf dem Wege! ");
INSERT INTO deuelo_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Und sie zogen aus Ägypten hinauf und kamen in das Land Kanaan zu ihrem Vater Jakob. ");
INSERT INTO deuelo_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Und sie berichteten ihm und sprachen: Joseph lebt noch, und er ist Herrscher über das ganze Land Ägypten. Da erstarrte sein Herz, denn er glaubte ihnen nicht. ");
INSERT INTO deuelo_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Und sie redeten zu ihm alle Worte Josephs, die er zu ihnen geredet hatte; und er sah die Wagen, die Joseph gesandt hatte, ihn zu holen. Und der Geist ihres Vaters Jakob lebte auf; ");
INSERT INTO deuelo_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","und Israel sprach: Genug! Joseph, mein Sohn, lebt noch! Ich will hinziehen und ihn sehen, ehe ich sterbe. ");
INSERT INTO deuelo_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Und Israel brach auf und alles, was er hatte, und kam nach Beerseba; und er opferte Schlachtopfer dem Gott seines Vaters Isaak. ");
INSERT INTO deuelo_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Und Gott sprach zu Israel in den Gesichten der Nacht und sagte: Jakob! Jakob! Und er sprach: Hier bin ich. ");
INSERT INTO deuelo_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Und er sprach: Ich bin Gott, der Gott deines Vaters; fürchte dich nicht, nach Ägypten hinabzuziehen; denn zu einer großen Nation will ich dich daselbst machen. ");
INSERT INTO deuelo_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ich will mit dir nach Ägypten hinabziehen, und ich will dich auch gewißlich heraufführen; und Joseph soll seine Hand auf deine Augen legen. ");
INSERT INTO deuelo_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Da machte sich Jakob von Beerseba auf, und die Söhne Israels führten Jakob, ihren Vater, und ihre Kinder und ihre Weiber auf den Wagen, die der Pharao gesandt hatte, ihn zu holen. ");
INSERT INTO deuelo_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Und sie nahmen ihr Vieh und ihre Habe, die sie im Lande Kanaan erworben hatten, und kamen nach Ägypten, Jakob und all sein Same mit ihm: ");
INSERT INTO deuelo_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","seine Söhne und die Söhne seiner Söhne mit ihm, seine Töchter und die Töchter seiner Söhne, und all seinen Samen brachte er mit sich nach Ägypten. ");
INSERT INTO deuelo_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Und dies sind die Namen der Söhne Israels, die nach Ägypten kamen: Jakob und seine Söhne; der Erstgeborene Jakobs: Ruben. ");
INSERT INTO deuelo_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Und die Söhne Rubens: Hanok und Pallu und Hezron und Karmi. ");
INSERT INTO deuelo_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Und die Söhne Simeons: Jemuel und Jamin und Ohad und Jakin und Zochar und Saul, der Sohn der Kanaaniterin. ");
INSERT INTO deuelo_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Und die Söhne Levis: Gerson, Kehath und Merari. ");
INSERT INTO deuelo_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Und die Söhne Judas: Gher und Onan und Schela und Perez und Serach; Gher und Onan aber starben im Lande Kanaan. Und die Söhne des Perez waren Hezron und Hamul. ");
INSERT INTO deuelo_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Und die Söhne Issaschars: Tola und Puwa und Job und Schimron. ");
INSERT INTO deuelo_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Und die Söhne Sebulons: Sered und Elon und Jachleel. ");
INSERT INTO deuelo_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Das sind die Söhne Leas, welche sie dem Jakob in Paddan-Aram gebar, und Dina, seine Tochter. Aller Seelen seiner Söhne und seiner Töchter waren dreiunddreißig. - ");
INSERT INTO deuelo_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Und die Söhne Gads: Ziphjon und Haggi, Schuni und Ezbon, Eri und Arodi und Areli. ");
INSERT INTO deuelo_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Und die Söhne Asers: Jimna und Jischwa und Jischwi und Beria, und Serach, ihre Schwester. Und die Söhne Berias: Heber und Malkiel. ");
INSERT INTO deuelo_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Das sind die Söhne Silpas, die Laban seiner Tochter Lea gab; und sie gebar diese dem Jakob, sechzehn Seelen. - ");
INSERT INTO deuelo_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Die Söhne Rahels, des Weibes Jakobs: Joseph und Benjamin. ");
INSERT INTO deuelo_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Und dem Joseph wurden im Lande Ägypten Manasse und Ephraim geboren, welche Asnath ihm gebar, die Tochter Potipheras, des Priesters von On. ");
INSERT INTO deuelo_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Und die Söhne Benjamins: Bela und Beker und Aschbel, Gera und Naaman, Echi und Rosch, Muppim und Huppim und Ard. ");
INSERT INTO deuelo_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Das sind die Söhne Rahels, die dem Jakob geboren wurden; aller Seelen waren vierzehn. - ");
INSERT INTO deuelo_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Und die Söhne Dans: Huschim. ");
INSERT INTO deuelo_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Und die Söhne Naphtalis: Jachzeel und Guni und Jezer und Schillem. ");
INSERT INTO deuelo_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Das sind die Söhne Bilhas, die Laban seiner Tochter Rahel gab; und sie gebar diese dem Jakob; aller Seelen waren sieben. - ");
INSERT INTO deuelo_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Aller dem Jakob angehörenden Seelen, die nach Ägypten kamen, die aus seinen Lenden hervorgegangen waren, ausgenommen die Weiber der Söhne Jakobs, aller Seelen waren sechsundsechzig. ");
INSERT INTO deuelo_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Und die Söhne Josephs, die ihm in Ägypten geboren wurden, waren zwei Seelen. Aller Seelen des Hauses Jakob, die nach Ägypten kamen, waren siebzig. ");
INSERT INTO deuelo_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Und er sandte Juda vor sich hin zu Joseph, um vor ihm her zu weisen nach Gosen; und sie kamen in das Land Gosen. ");
INSERT INTO deuelo_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Da spannte Joseph seinen Wagen an und zog hinauf, seinem Vater Israel entgegen nach Gosen; und als er seiner ansichtig wurde, fiel er ihm um den Hals und weinte lange an seinem Halse. ");
INSERT INTO deuelo_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Und Israel sprach zu Joseph: Nunmehr mag ich sterben, nachdem ich dein Angesicht gesehen habe, daß du noch lebst! ");
INSERT INTO deuelo_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Und Joseph sprach zu seinen Brüdern und zum Hause seines Vaters: Ich will hinaufziehen und dem Pharao berichten und zu ihm sagen: Meine Brüder und das Haus meines Vaters, die im Lande Kanaan waren, sind zu mir gekommen. ");
INSERT INTO deuelo_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Und die Männer sind Schafhirten, denn sie haben Viehzucht getrieben; und sie haben ihr Kleinvieh und ihre Rinder und alles, was sie haben, mitgebracht. ");
INSERT INTO deuelo_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Und geschieht es, daß der Pharao euch ruft und spricht: Was ist eure Hantierung? ");
INSERT INTO deuelo_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","so saget: Deine Knechte haben Viehzucht getrieben, von Jugend auf bis jetzt, sowohl wir als auch unsere Väter, auf daß ihr wohnen möget im Lande Gosen; denn alle Schafhirten sind den Ägyptern ein Greuel. ");
INSERT INTO deuelo_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Und Joseph kam und berichtete dem Pharao und sprach: Mein Vater und meine Brüder und ihr Kleinvieh und ihre Rinder und alles, was sie haben, sind aus dem Lande Kanaan gekommen; und siehe, sie sind im Lande Gosen. ");
INSERT INTO deuelo_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Und er nahm aus der Gesamtheit seiner Brüder fünf Männer und stellte sie vor den Pharao. ");
INSERT INTO deuelo_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Und der Pharao sprach zu seinen Brüdern: Was ist eure Hantierung? Und sie sprachen zum Pharao: Deine Knechte sind Schafhirten, sowohl wir als auch unsere Väter. ");
INSERT INTO deuelo_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Und sie sprachen zum Pharao: Wir sind gekommen, um uns im Lande aufzuhalten; denn es gibt keine Weide für das Kleinvieh, das deine Knechte haben, denn die Hungersnot ist schwer im Lande Kanaan; und nun laß doch deine Knechte im Lande Gosen wohnen. ");
INSERT INTO deuelo_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Da sprach der Pharao zu Joseph und sagte: Dein Vater und deine Brüder sind zu dir gekommen. ");
INSERT INTO deuelo_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Das Land Ägypten ist vor dir: laß deinen Vater und deine Brüder in dem besten Teile des Landes wohnen; sie mögen wohnen im Lande Gosen. Und wenn du weißt, daß tüchtige Männer unter ihnen sind, so setze sie als Aufseher über das Vieh, das ich habe. ");
INSERT INTO deuelo_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Und Joseph brachte seinen Vater Jakob und stellte ihn vor den Pharao. Und Jakob segnete den Pharao. ");
INSERT INTO deuelo_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Und der Pharao sprach zu Jakob: Wie viel sind der Tage deiner Lebensjahre? ");
INSERT INTO deuelo_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Und Jakob sprach zum Pharao: Die Tage der Jahre meiner Fremdlingschaft sind hundertdreißig Jahre; wenig und böse waren die Tage meiner Lebensjahre, und sie haben nicht erreicht die Tage der Lebensjahre meiner Väter in den Tagen ihrer Fremdlingschaft. ");
INSERT INTO deuelo_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Und Jakob segnete den Pharao und ging von dem Pharao hinaus. ");
INSERT INTO deuelo_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Und Joseph schaffte seinem Vater und seinen Brüdern Wohnung und gab ihnen ein Besitztum in dem Lande Ägypten, im besten Teile des Landes, im Lande Raemses, so wie der Pharao geboten hatte. ");
INSERT INTO deuelo_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Und Joseph versorgte seinen Vater und seine Brüder und das ganze Haus seines Vaters mit Brot, nach der Zahl der Kinder. ");
INSERT INTO deuelo_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Und es war kein Brot im ganzen Lande, denn die Hungersnot war sehr schwer; und das Land Ägypten und das Land Kanaan verschmachteten vor Hunger. ");
INSERT INTO deuelo_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Und Joseph brachte alles Geld zusammen, das sich im Lande Ägypten und im Lande Kanaan vorfand, für das Getreide, das man kaufte; und Joseph brachte das Geld in das Haus des Pharao. ");
INSERT INTO deuelo_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Und als das Geld im Lande Ägypten und im Lande Kanaan ausging, da kamen alle Ägypter zu Joseph und sprachen: Gib uns Brot! Warum sollen wir denn vor dir sterben? Denn das Geld ist zu Ende. ");
INSERT INTO deuelo_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Und Joseph sprach: Gebet euer Vieh her, und ich will euch Brot geben um euer Vieh, wenn das Geld zu Ende ist. ");
INSERT INTO deuelo_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Da brachten sie ihr Vieh zu Joseph, und Joseph gab ihnen Brot um die Pferde und um das Kleinvieh und um das Rindvieh und um die Esel; und so ernährte er sie mit Brot um all ihr Vieh in selbigem Jahre. ");
INSERT INTO deuelo_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Als selbiges Jahr zu Ende war, da kamen sie im zweiten Jahre zu ihm und sprachen zu ihm: Wir wollen es meinem Herrn nicht verhehlen, daß, da das Geld ausgegangen ist und der Besitz des Viehes an meinen Herrn gekommen, nichts mehr übrigbleibt vor meinem Herrn als nur unser Leib und unser Land. ");
INSERT INTO deuelo_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Warum sollen wir vor deinen Augen sterben, sowohl wir als auch unser Land? Kaufe uns und unser Land um Brot, so wollen wir und unser Land des Pharao Knechte sein; und gib Samen, daß wir leben und nicht sterben und das Land nicht wüst werde! ");
INSERT INTO deuelo_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Und Joseph kaufte das ganze Land Ägypten für den Pharao; denn die Ägypter verkauften ein jeder sein Feld, weil der Hunger sie drängte. Und so ward das Land dem Pharao. ");
INSERT INTO deuelo_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Und das Volk, das versetzte er in die verschiedenen Städte, von einem Ende der Grenze Ägyptens bis zu ihrem anderen Ende. ");
INSERT INTO deuelo_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Nur das Land der Priester kaufte er nicht; denn die Priester hatten ein Bestimmtes von dem Pharao, und sie aßen ihr Bestimmtes, das der Pharao ihnen gab; deshalb verkauften sie ihr Land nicht. ");
INSERT INTO deuelo_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Und Joseph sprach zu dem Volke: Siehe, ich habe euch und euer Land heute für den Pharao gekauft; siehe, da ist Samen für euch, und besäet das Land. ");
INSERT INTO deuelo_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Und es soll geschehen mit dem Ertrage, daß ihr den Fünften dem Pharao gebet, und die vier Teile sollen für euch sein zur Saat des Feldes und zur Speise für euch und für die, welche in euren Häusern sind, und zur Speise für eure Kinder. ");
INSERT INTO deuelo_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Und sie sprachen: Du hast uns am Leben erhalten; möchten wir Gnade finden in den Augen meines Herrn, so wollen wir des Pharao Knechte sein. ");
INSERT INTO deuelo_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Und Joseph legte es dem Lande Ägypten bis auf diesen Tag als Satzung auf, daß dem Pharao der Fünfte gehöre. Nur das Land der Priester allein ward nicht dem Pharao. ");
INSERT INTO deuelo_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Und Israel wohnte im Lande Ägypten, im Lande Gosen; und sie machten sich darin ansässig und waren fruchtbar und mehrten sich sehr. ");
INSERT INTO deuelo_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Und Jakob lebte im Lande Ägypten siebzehn Jahre; und der Tage Jakobs, der Jahre seines Lebens, waren hundertsiebenundvierzig Jahre. ");
INSERT INTO deuelo_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Und als die Tage Israels herannahten, daß er sterben sollte, da rief er seinen Sohn Joseph und sprach zu ihm: Wenn ich doch Gnade gefunden habe in deinen Augen, so lege doch deine Hand unter meine Hüfte und erweise Güte und Treue an mir: begrabe mich doch nicht in Ägypten! ");
INSERT INTO deuelo_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Wenn ich mit meinen Vätern liegen werde, so führe mich aus Ägypten und begrabe mich in ihrem Begräbnis. Und er sprach: Ich werde tun nach deinem Worte. ");
INSERT INTO deuelo_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Da sprach er: Schwöre mir! Und er schwur ihm. Und Israel betete an zu den Häupten des Bettes. ");
INSERT INTO deuelo_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Und es geschah nach diesen Dingen, daß man dem Joseph sagte: Siehe, dein Vater ist krank. Und er nahm seine beiden Söhne, Manasse und Ephraim, mit sich. ");
INSERT INTO deuelo_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Und man berichtete dem Jakob und sprach: Siehe, dein Sohn Joseph kommt zu dir. Und Israel machte sich stark und setzte sich aufs Bett. ");
INSERT INTO deuelo_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Und Jakob sprach zu Joseph: Gott, der Allmächtige, erschien mir zu Lus im Lande Kanaan, und er segnete mich ");
INSERT INTO deuelo_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","und sprach zu mir: Siehe, ich will dich fruchtbar machen und dich mehren und dich zu einem Haufen Völker machen, und ich will dieses Land deinem Samen nach dir zum ewigen Besitztum geben. ");
INSERT INTO deuelo_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Und nun, deine beiden Söhne, welche dir im Lande Ägypten geboren sind, ehe ich zu dir nach Ägypten kam, sollen mein sein; Ephraim und Manasse sollen mein sein wie Ruben und Simeon. ");
INSERT INTO deuelo_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Aber dein Geschlecht, das du nach ihnen gezeugt hast, soll dein sein; nach dem Namen ihrer Brüder sollen sie genannt werden in ihrem Erbteil. ");
INSERT INTO deuelo_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Denn ich, als ich aus Paddan kam, starb Rahel bei mir im Lande Kanaan auf dem Wege, als noch eine Strecke Landes war, um nach Ephrath zu kommen; und ich begrub sie daselbst auf dem Wege nach Ephrath, das ist Bethlehem. ");
INSERT INTO deuelo_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Und Israel sah die Söhne Josephs und sprach: Wer sind diese? ");
INSERT INTO deuelo_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Und Joseph sprach zu seinem Vater: Das sind meine Söhne, die Gott mir hier gegeben hat. Da sprach er: Bringe sie doch zu mir her, daß ich sie segne! ");
INSERT INTO deuelo_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Die Augen Israels aber waren schwer vor Alter, er konnte nicht sehen. Und er führte sie näher zu ihm, und er küßte sie und umarmte sie. ");
INSERT INTO deuelo_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Und Israel sprach zu Joseph: Ich hatte nicht gedacht, dein Angesicht wiederzusehen, und siehe, Gott hat mich sogar deinen Samen sehen lassen! ");
INSERT INTO deuelo_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Und Joseph führte sie von seinen Knien heraus und beugte sich auf sein Angesicht zur Erde nieder. ");
INSERT INTO deuelo_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Und Joseph nahm sie beide, Ephraim mit seiner Rechten, zur Linken Israels, und Manasse mit seiner Linken, zur Rechten Israels, und führte sie näher zu ihm. ");
INSERT INTO deuelo_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Und Israel streckte seine Rechte aus und legte sie auf das Haupt Ephraims er war aber der Jüngere und seine Linke auf das Haupt Manasses; er legte seine Hände absichtlich also, denn Manasse war der Erstgeborene. ");
INSERT INTO deuelo_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Und er segnete Joseph und sprach: Der Gott, vor dessen Angesicht meine Väter, Abraham und Isaak, gewandelt haben, der Gott, der mich geweidet hat, seitdem ich bin bis auf diesen Tag, ");
INSERT INTO deuelo_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","der Engel, der mich erlöst hat von allem Übel, segne die Knaben; und in ihnen werde mein Name genannt und der Name meiner Väter, Abraham und Isaak, und sie sollen sich mehren zu einer Menge inmitten des Landes! ");
INSERT INTO deuelo_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Und als Joseph sah, daß sein Vater seine rechte Hand auf das Haupt Ephraims legte, war es übel in seinen Augen; und er faßte seines Vaters Hand, um sie von dem Haupte Ephraims hinwegzutun auf das Haupt Manasses. ");
INSERT INTO deuelo_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Und Joseph sprach zu seinem Vater: Nicht also, mein Vater! Denn dieser ist der Erstgeborene; lege deine Rechte auf sein Haupt. ");
INSERT INTO deuelo_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Aber sein Vater weigerte sich und sprach: Ich weiß es mein Sohn, ich weiß es. Auch er wird zu einem Volke werden, und auch er wird groß sein; aber doch wird sein jüngerer Bruder größer sein als er, und sein Same wird eine Fülle von Nationen werden. ");
INSERT INTO deuelo_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Und er segnete sie an selbigem Tage und sprach: In dir wird Israel segnen und sprechen: Gott mache dich wie Ephraim und wie Manasse! Und er setzte Ephraim vor Manasse. ");
INSERT INTO deuelo_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Und Israel sprach zu Joseph: Siehe, ich sterbe; und Gott wird mit euch sein und euch in das Land eurer Väter zurückbringen. ");
INSERT INTO deuelo_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Und ich gebe dir einen Landstrich über deine Brüder hinaus, den ich von der Hand der Amoriter genommen habe mit meinem Schwerte und mit meinem Bogen. ");
INSERT INTO deuelo_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Und Jakob rief seine Söhne und sprach: Versammelt euch, und ich will euch verkünden, was euch begegnen wird in künftigen Tagen. ");
INSERT INTO deuelo_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Kommet zusammen und höret, ihr Söhne Jakobs, und höret auf Israel, euren Vater! ");
INSERT INTO deuelo_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, mein Erstgeborener bist du, meine Kraft und der Erstling meiner Stärke! Vorzug an Hoheit und Vorzug an Macht! ");
INSERT INTO deuelo_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Überwallend wie die Wasser, sollst du keinen Vorzug haben, denn du hast das Lager deines Vaters bestiegen; da hast du es entweiht. Mein Bett hat er bestiegen! ");
INSERT INTO deuelo_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon und Levi sind Brüder, Werkzeuge der Gewalttat ihre Waffen. ");
INSERT INTO deuelo_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Meine Seele komme nicht in ihren geheimen Rat, meine Ehre vereinige sich nicht mit ihrer Versammlung! Denn in ihrem Zorn haben sie den Mann erschlagen und in ihrem Mutwillen den Stier gelähmt. ");
INSERT INTO deuelo_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Verflucht sei ihr Zorn, denn er war gewalttätig, und ihr Grimm, denn er war grausam! Ich werde sie verteilen in Jakob und sie zerstreuen in Israel. ");
INSERT INTO deuelo_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Dich Juda, dich werden deine Brüder preisen; deine Hand wird sein auf dem Nacken deiner Feinde, vor dir werden sich niederbeugen die Söhne deines Vaters. ");
INSERT INTO deuelo_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Juda ist ein junger Löwe; vom Raube, mein Sohn, bist du emporgestiegen. Er duckt sich, er legt sich nieder wie ein Löwe und wie eine Löwin; wer will ihn aufreizen? ");
INSERT INTO deuelo_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Nicht weichen wird das Zepter von Juda, noch der Herrscherstab zwischen seinen Füßen hinweg, bis Schilo kommt, und ihm werden die Völker gehorchen. ");
INSERT INTO deuelo_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Er bindet an den Weinstock sein Eselsfüllen und an die Edelrebe das Junge seiner Eselin; er wäscht im Weine sein Kleid und im Blute der Trauben sein Gewand; ");
INSERT INTO deuelo_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","die Augen sind trübe von Wein und weiß die Zähne von Milch. ");
INSERT INTO deuelo_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sebulon, am Gestade der Meere wird er wohnen, und am Gestade der Schiffe wird er sein und seine Seite gegen Sidon hin. ");
INSERT INTO deuelo_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Issaschar ist ein knochiger Esel, der sich lagert zwischen den Hürden. ");
INSERT INTO deuelo_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Und er sieht, daß die Ruhe gut und daß das Land lieblich ist; und er beugt seine Schulter zum Lasttragen und wird zum fronpflichtigen Knecht. ");
INSERT INTO deuelo_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan wird sein Volk richten, wie einer der Stämme Israels. ");
INSERT INTO deuelo_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan wird eine Schlange sein am Wege, eine Hornotter am Pfade, die da beißt in die Fersen des Rosses, und rücklings fällt sein Reiter. ");
INSERT INTO deuelo_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Auf deine Rettung harre ich, Jehova! ");
INSERT INTO deuelo_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad, Scharen werden ihn drängen, und er, er wird ihnen nachdrängen auf der Ferse. ");
INSERT INTO deuelo_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Von Aser kommt Fettes, sein Brot; und er, königliche Leckerbissen wird er geben. ");
INSERT INTO deuelo_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naphtali ist eine losgelassene Hindin; er, der schöne Worte gibt. ");
INSERT INTO deuelo_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Sohn eines Fruchtbaumes ist Joseph, Sohn eines Fruchtbaumes am Quell; die Schößlinge treiben über die Mauer. ");
INSERT INTO deuelo_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Und es reizen ihn und schießen, und es befehden ihn die Bogenschützen; ");
INSERT INTO deuelo_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","aber sein Bogen bleibt fest, und gelenkig sind die Arme seiner Hände durch die Hände des Mächtigen Jakobs. Von dannen ist der Hirte, der Stein Israels: ");
INSERT INTO deuelo_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","von dem Gott deines Vaters, und er wird dir helfen, und dem Allmächtigen, und er wird dich segnen mit Segnungen des Himmels droben, mit Segnungen der Tiefe, die unten liegt, mit Segnungen der Brüste und des Mutterleibes. ");
INSERT INTO deuelo_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Die Segnungen deines Vaters überragen die Segnungen meiner Voreltern bis zur Grenze der ewigen Hügel. Sie werden sein auf dem Haupte Josephs und auf dem Scheitel des Abgesonderten unter seinen Brüdern. ");
INSERT INTO deuelo_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamin ist ein Wolf, der zerreißt; am Morgen verzehrt er Raub, und am Abend verteilt er Beute. ");
INSERT INTO deuelo_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Alle diese sind die zwölf Stämme Israels, und das ist es, was ihr Vater zu ihnen redete und womit er sie segnete; einen jeden nach seinem Segen segnete er sie. ");
INSERT INTO deuelo_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Und er gebot ihnen und sprach zu ihnen: Bin ich versammelt zu meinem Volke, so begrabet mich zu meinen Vätern in der Höhle, die in dem Felde Ephrons, des Hethiters, ist, ");
INSERT INTO deuelo_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","in der Höhle, die in dem Felde Machpela vor Mamre ist, im Lande Kanaan, welche Abraham samt dem Felde von Ephron, dem Hethiter, zum Erbbegräbnis gekauft hat. ");
INSERT INTO deuelo_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Dort haben sie Abraham begraben und sein Weib Sara; dort haben sie Isaak begraben und sein Weib Rebekka; und dort habe ich Lea begraben; ");
INSERT INTO deuelo_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","das Feld und die Höhle, die darin ist, sind erkauft von den Kindern Heth. ");
INSERT INTO deuelo_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Und als Jakob geendet hatte, seinen Söhnen Befehle zu geben, zog er seine Füße aufs Bett herauf und verschied und wurde versammelt zu seinen Völkern. ");
INSERT INTO deuelo_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Und Joseph fiel auf das Angesicht seines Vaters und weinte über ihm und küßte ihn. ");
INSERT INTO deuelo_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Und Joseph gebot seinen Knechten, den Ärzten, seinen Vater einzubalsamieren. Und die Ärzte balsamierten Israel ein. ");
INSERT INTO deuelo_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Und es wurden vierzig Tage für ihn erfüllt, denn also werden erfüllt die Tage des Einbalsamierens. Und die Ägypter beweinten ihn siebzig Tage. ");
INSERT INTO deuelo_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Und als die Tage seines Beweinens vorüber waren, da redete Joseph zum Hause des Pharao und sprach: Wenn ich doch Gnade gefunden habe in euren Augen, so redet doch vor den Ohren des Pharao und saget: ");
INSERT INTO deuelo_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Mein Vater hat mich schwören lassen und gesagt: Siehe, ich sterbe; in meinem Grabe, das ich mir im Lande Kanaan gegraben habe, daselbst sollst du mich begraben. Und nun laß mich doch hinaufziehen, daß ich meinen Vater begrabe und zurückkomme. ");
INSERT INTO deuelo_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Und der Pharao sprach: Ziehe hinauf und begrabe deinen Vater, so wie er dich hat schwören lassen. ");
INSERT INTO deuelo_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Und Joseph zog hinauf, um seinen Vater zu begraben; und mit ihm zogen hinauf alle Knechte des Pharao, die Ältesten seines Hauses, und alle Ältesten des Landes Ägypten, ");
INSERT INTO deuelo_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","und das ganze Haus Josephs und seine Brüder und das Haus seines Vaters; nur ihre Kinder und ihr Kleinvieh und ihre Rinder ließen sie im Land Gosen zurück. ");
INSERT INTO deuelo_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Auch zogen sowohl Wagen als Reiter mit ihm hinauf, und der Zug war sehr groß. ");
INSERT INTO deuelo_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Und sie kamen bis zur Tenne Atad, die jenseit des Jordan liegt, und sie hielten daselbst eine sehr große und schwere Klage; und er stellte um seinen Vater eine Trauer von sieben Tagen an. ");
INSERT INTO deuelo_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Und die Bewohner des Landes, die Kanaaniter, sahen die Trauer bei der Tenne Atad, und sie sprachen: Das ist eine schwere Trauer der Ägypter; daher gab man ihr den Namen Avel-Mizraim, die jenseit des Jordan liegt. ");
INSERT INTO deuelo_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Und seine Söhne taten ihm, so wie er ihnen geboten hatte; ");
INSERT INTO deuelo_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","und seine Söhne führten ihn in das Land Kanaan und begruben ihn in der Höhle des Feldes Machpela, die Abraham samt dem Felde zum Erbbegräbnis gekauft hatte von Ephron, dem Hethiter, vor Mamre. ");
INSERT INTO deuelo_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Und Joseph kehrte wieder nach Ägypten zurück, er und seine Brüder und alle, die mit ihm hinaufgezogen waren, um seinen Vater zu begraben, nachdem er seinen Vater begraben hatte. ");
INSERT INTO deuelo_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Und als die Brüder Josephs sahen, daß ihr Vater gestorben war, da sprachen sie: Wenn nun Joseph uns anfeindete und uns gar all das Böse vergelten würde, das wir ihm angetan haben! ");
INSERT INTO deuelo_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Und sie entboten dem Joseph und sprachen: Dein Vater hat vor seinem Tode befohlen und gesagt: ");
INSERT INTO deuelo_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","So sollt ihr zu Joseph sprechen: Ach, vergib doch die Übertretung deiner Brüder und ihre Sünde! Denn sie haben dir Böses angetan. Und nun vergib doch die Übertretung der Knechte des Gottes deines Vaters! Und Joseph weinte, als sie zu ihm redeten. ");
INSERT INTO deuelo_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Und auch seine Brüder gingen und fielen vor ihm nieder und sprachen: Siehe, wir sind deine Knechte. ");
INSERT INTO deuelo_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Da sprach Joseph zu ihnen: Fürchtet euch nicht; denn bin ich an Gottes Statt? ");
INSERT INTO deuelo_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ihr zwar, ihr hattet Böses wider mich im Sinne; Gott aber hatte im Sinne, es gut zu machen, auf daß er täte, wie es an diesem Tage ist, um ein großes Volk am Leben zu erhalten. ");
INSERT INTO deuelo_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Und nun, fürchtet euch nicht; ich werde euch und eure Kinder versorgen. Und er tröstete sie und redete zu ihrem Herzen. ");
INSERT INTO deuelo_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Und Joseph wohnte in Ägypten, er und das Haus seines Vaters; und Joseph lebte hundertzehn Jahre. ");
INSERT INTO deuelo_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Und Joseph sah von Ephraim Kinder des dritten Gliedes; auch die Söhne Makirs, des Sohnes Manasses, wurden auf die Knie Josephs geboren. ");
INSERT INTO deuelo_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Und Joseph sprach zu seinen Brüdern: Ich sterbe; und Gott wird euch gewißlich heimsuchen und euch aus diesem Lande hinaufführen in das Land, das er Abraham, Isaak und Jakob zugeschworen hat. ");
INSERT INTO deuelo_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Und Joseph ließ die Söhne Israels schwören und sprach: Gott wird euch gewißlich heimsuchen; so führet meine Gebeine von hier hinauf! ");
INSERT INTO deuelo_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Und Joseph starb, hundertzehn Jahre alt; und sie balsamierten ihn ein, und man legte ihn in eine Lade in Ägypten. ");
INSERT INTO deuelo_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Und dies sind die Namen der Söhne Israels, die nach Ägypten kamen; mit Jakob kamen sie, ein jeder mit seinem Hause: ");
INSERT INTO deuelo_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Simeon, Levi und Juda; ");
INSERT INTO deuelo_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Issaschar, Sebulon und Benjamin; ");
INSERT INTO deuelo_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan und Naphtali, Gad und Aser. ");
INSERT INTO deuelo_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Und es waren aller Seelen, die aus den Lenden Jakobs hervorgegangen waren, siebzig Seelen. Und Joseph war in Ägypten. ");
INSERT INTO deuelo_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Und Joseph starb und alle seine Brüder und dasselbige ganze Geschlecht. ");
INSERT INTO deuelo_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Und die Kinder Israel waren fruchtbar und wimmelten und mehrten sich und wurden sehr, sehr stark, und das Land wurde voll von ihnen. ");
INSERT INTO deuelo_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Da stand ein neuer König über Ägypten auf, der Joseph nicht kannte. ");
INSERT INTO deuelo_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Und er sprach zu seinem Volke: Siehe, das Volk der Kinder Israel ist zahlreicher und stärker als wir. ");
INSERT INTO deuelo_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Wohlan, laßt uns klug gegen dasselbe handeln, daß es sich nicht mehre und es nicht geschehe, wenn Krieg eintritt, daß es sich auch zu unseren Feinden schlage und wider uns streite und aus dem Lande hinaufziehe. ");
INSERT INTO deuelo_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Und sie setzten Fronvögte über dasselbe, um es mit ihren Lastarbeiten zu drücken; und es baute dem Pharao Vorratsstädte: Pithom und Raemses. ");
INSERT INTO deuelo_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Aber so wie sie es drückten, also mehrte es sich, und also breitete es sich aus; und es graute ihnen vor den Kindern Israel. ");
INSERT INTO deuelo_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Und die Ägypter hielten die Kinder Israel mit Härte zum Dienst an. ");
INSERT INTO deuelo_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Und sie machten ihnen das Leben bitter durch harten Dienst in Lehm und in Ziegeln, und durch allerlei Dienst auf dem Felde, neben all ihrem Dienst, zu welchem sie sie anhielten mit Härte. ");
INSERT INTO deuelo_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Und der König von Ägypten sprach zu den hebräischen Hebammen, von denen der Name der einen Schiphra und der Name der anderen Pua war, und sagte: ");
INSERT INTO deuelo_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Wenn ihr den Hebräerinnen bei der Geburt helfet und ihr sie auf dem Geburtsstuhl sehet: wenn es ein Sohn ist, so tötet ihn, und wenn eine Tochter, so mag sie leben. ");
INSERT INTO deuelo_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Aber die Hebammen fürchteten Gott und taten nicht, wie der König von Ägypten zu ihnen gesagt hatte, und erhielten die Knäblein am Leben. ");
INSERT INTO deuelo_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Und der König von Ägypten rief die Hebammen und sprach zu ihnen: Warum habt ihr dieses getan und die Knäblein am Leben erhalten? ");
INSERT INTO deuelo_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Und die Hebammen sprachen zum Pharao: Weil die hebräischen Weiber nicht sind wie die ägyptischen, denn sie sind kräftig; ehe die Hebamme zu ihnen kommt, haben sie geboren. ");
INSERT INTO deuelo_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Und Gott tat den Hebammen Gutes; und das Volk mehrte sich und wurde sehr stark. ");
INSERT INTO deuelo_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Und es geschah, weil die Hebammen Gott fürchteten, so machte er ihnen Häuser. ");
INSERT INTO deuelo_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Da gebot der Pharao all seinem Volke und sprach: Jeden Sohn, der geboren wird, sollt ihr in den Strom werfen, jede Tochter aber sollt ihr leben lassen. ");
INSERT INTO deuelo_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Und ein Mann vom Hause Levi ging hin und nahm eine Tochter Levis. ");
INSERT INTO deuelo_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Und das Weib ward schwanger und gebar einen Sohn. Und sie sah, daß er schön war, und verbarg ihn drei Monate. ");
INSERT INTO deuelo_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Und als sie ihn nicht länger verbergen konnte, nahm sie für ihn ein Kästlein von Schilfrohr und verpichte es mit Erdharz und mit Pech und legte das Kind darein, und legte es in das Schilf am Ufer des Stromes. ");
INSERT INTO deuelo_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Und seine Schwester stellte sich von ferne, um zu erfahren, was ihm geschehen würde. ");
INSERT INTO deuelo_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Und die Tochter des Pharao ging hinab, um an dem Strome zu baden, und ihre Mägde gingen an der Seite des Stromes. Und sie sah das Kästlein mitten im Schilf und sandte ihre Magd hin und ließ es holen. ");
INSERT INTO deuelo_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Und sie öffnete es und sah das Kind, und siehe, der Knabe weinte. Und es erbarmte sie seiner, und sie sprach: Von den Kindern der Hebräer ist dieses. ");
INSERT INTO deuelo_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Und seine Schwester sprach zu der Tochter des Pharao: Soll ich hingehen und dir ein säugendes Weib von den Hebräerinnen rufen, daß sie dir das Kind säuge? ");
INSERT INTO deuelo_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Und die Tochter des Pharao sprach zu ihr: Gehe hin. Da ging die Jungfrau hin und rief des Kindes Mutter. ");
INSERT INTO deuelo_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Und die Tochter des Pharao sprach zu ihr: Nimm dieses Kind mit und säuge es mir, und ich werde dir deinen Lohn geben. Und das Weib nahm das Kind und säugte es. ");
INSERT INTO deuelo_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Und als das Kind groß wurde, brachte sie es der Tochter des Pharao, und es wurde ihr zum Sohne; und sie gab ihm den Namen Mose und sprach: denn aus dem Wasser habe ich ihn gezogen. ");
INSERT INTO deuelo_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Und es geschah in selbigen Tagen, als Mose groß geworden war, da ging er aus zu seinen Brüdern und sah ihren Lastarbeiten zu; und er sah einen ägyptischen Mann, der einen hebräischen Mann von seinen Brüdern schlug. ");
INSERT INTO deuelo_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Und er wandte sich dahin und dorthin, und als er sah, daß kein Mensch da war, erschlug er den Ägypter und verscharrte ihn im Sande. ");
INSERT INTO deuelo_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Und er ging am zweiten Tage aus, und siehe, zwei hebräische Männer zankten sich. Da sprach er zu dem Schuldigen: Warum schlägst du deinen Nächsten? ");
INSERT INTO deuelo_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Und er sprach: Wer hat dich zum Obersten und Richter über uns gesetzt? Gedenkst du mich zu töten, wie du den Ägypter getötet hast? Da fürchtete sich Mose und sprach: Fürwahr, die Sache ist kund geworden! ");
INSERT INTO deuelo_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Und der Pharao hörte diese Sache und suchte Mose zu töten. Und Mose floh vor dem Pharao und weilte im Lande Midian. Und er saß an einem Brunnen. ");
INSERT INTO deuelo_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Und der Priester von Midian hatte sieben Töchter; und sie kamen und schöpften und füllten die Tränkrinnen, um die Herde ihres Vaters zu tränken. ");
INSERT INTO deuelo_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Und die Hirten kamen und trieben sie hinweg. Da stand Mose auf und half ihnen und tränkte ihre Herde. ");
INSERT INTO deuelo_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Und sie kamen zu Reghuel, ihrem Vater, und er sprach: Warum seid ihr heute so bald gekommen? ");
INSERT INTO deuelo_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Und sie sprachen: Ein ägyptischer Mann hat uns aus der Hand der Hirten errettet und hat auch sogar für uns geschöpft und die Herde getränkt. ");
INSERT INTO deuelo_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Da sprach er zu seinen Töchtern: Und wo ist er? Warum habt ihr denn den Mann zurückgelassen? Rufet ihn, daß er mit uns esse. - ");
INSERT INTO deuelo_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Und Mose willigte ein, bei dem Manne zu bleiben; und er gab Mose Zippora, seine Tochter. ");
INSERT INTO deuelo_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Und sie gebar einen Sohn, und er gab ihm den Namen Gersom, denn er sprach: Ein Fremdling bin ich geworden in fremdem Lande. ");
INSERT INTO deuelo_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Und es geschah während jener vielen Tage, da starb der König von Ägypten; und die Kinder Israel seufzten wegen des Dienstes und schrieen; und ihr Geschrei wegen des Dienstes stieg hinauf zu Gott. ");
INSERT INTO deuelo_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Und Gott hörte ihr Wehklagen, und Gott gedachte seines Bundes mit Abraham, mit Isaak und mit Jakob; ");
INSERT INTO deuelo_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Und Gott sah die Kinder Israel, und Gott nahm Kenntnis von ihnen. ");
INSERT INTO deuelo_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Und Mose weidete die Herde Jethros, seines Schwiegervaters, des Priesters von Midian. Und er trieb die Herde hinter die Wüste und kam an den Berg Gottes, an den Horeb. ");
INSERT INTO deuelo_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Da erschien ihm der Engel Jehovas in einer Feuerflamme mitten aus einem Dornbusche; und er sah: und siehe, der Dornbusch brannte im Feuer, und der Dornbusch wurde nicht verzehrt. ");
INSERT INTO deuelo_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Und Mose sprach: Ich will doch hinzutreten und dieses große Gesicht sehen, warum der Dornbusch nicht verbrennt. ");
INSERT INTO deuelo_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Und als Jehova sah, daß er herzutrat, um zu sehen, da rief Gott ihm mitten aus dem Dornbusche zu und sprach: Mose! Mose! Und er sprach: Hier bin ich. ");
INSERT INTO deuelo_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Und er sprach: Nahe nicht hierher! Ziehe deine Schuhe aus von deinen Füßen, denn der Ort, auf dem du stehst, ist heiliges Land. ");
INSERT INTO deuelo_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Und er sprach: Ich bin der Gott deines Vaters, der Gott Abrahams, der Gott Isaaks und der Gott Jakobs. Da verbarg Mose sein Angesicht, denn er fürchtete sich, Gott anzuschauen. ");
INSERT INTO deuelo_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Und Jehova sprach: Gesehen habe ich das Elend meines Volkes, das in Ägypten ist, und sein Geschrei wegen seiner Treiber habe ich gehört; denn ich kenne seine Schmerzen. ");
INSERT INTO deuelo_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Und ich bin herabgekommen, um es aus der Hand der Ägypter zu erretten und es aus diesem Lande hinaufzuführen in ein gutes und geräumiges Land, in ein Land, das von Milch und Honig fließt, an den Ort der Kanaaniter und der Hethiter und der Amoriter und der Perisiter und der Hewiter und der Jebusiter. ");
INSERT INTO deuelo_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Und nun siehe, das Geschrei der Kinder Israel ist vor mich gekommen; und ich habe auch den Druck gesehen, womit die Ägypter sie drücken. ");
INSERT INTO deuelo_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Und nun gehe hin, denn ich will dich zu dem Pharao senden, daß du mein Volk, die Kinder Israel, aus Ägypten herausführest. ");
INSERT INTO deuelo_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Und Mose sprach zu Gott: Wer bin ich, daß ich zu dem Pharao gehen und daß ich die Kinder Israel aus Ägypten herausführen sollte? ");
INSERT INTO deuelo_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Und er sprach: Weil ich mit dir sein werde; und dies sei dir das Zeichen, daß ich dich gesandt habe: wenn du das Volk aus Ägypten herausgeführt hast, werdet ihr auf diesem Berge Gott dienen. ");
INSERT INTO deuelo_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Und Mose sprach zu Gott: Siehe, wenn ich zu den Kindern Israel komme und zu ihnen spreche: Der Gott eurer Väter hat mich zu euch gesandt, und sie zu mir sagen werden: Welches ist sein Name? was soll ich zu Ihnen sagen? ");
INSERT INTO deuelo_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Da sprach Gott zu Mose: Ich bin, der ich bin. Und er sprach: Also sollst du zu den Kindern Israel sagen: “Ich bin” hat mich zu euch gesandt. ");
INSERT INTO deuelo_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Und Gott sprach weiter zu Mose: Also sollst du zu den Kindern Israel sagen: Jehova, der Gott eurer Väter, der Gott Abrahams, der Gott Isaaks und der Gott Jakobs, hat mich zu euch gesandt. Das ist mein Name in Ewigkeit, und das ist mein Gedächtnis von Geschlecht zu Geschlecht. ");
INSERT INTO deuelo_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Gehe hin und versammle die Ältesten Israels und sprich zu ihnen: Jehova, der Gott eurer Väter, ist mir erschienen, der Gott Abrahams, Isaaks und Jakobs, und hat gesagt: Angesehen habe ich euch und was euch in Ägypten geschehen ist, ");
INSERT INTO deuelo_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","und ich habe gesagt: Ich will euch aus dem Elend Ägyptens heraufführen in das Land der Kanaaniter und der Hethiter und der Amoriter und der Perisiter und der Hewiter und der Jebusiter, in ein Land, das von Milch und Honig fließt. ");
INSERT INTO deuelo_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Und sie werden auf deine Stimme hören; und du sollst hineingehen, du und die Ältesten Israels, zu dem Könige von Ägypten, und ihr sollt zu ihm sagen: Jehova, der Gott der Hebräer, ist uns begegnet; und nun laß uns doch drei Tagereisen weit in die Wüste ziehen, daß wir Jehova, unserem Gott, opfern. ");
INSERT INTO deuelo_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Aber ich weiß wohl, daß der König von Ägypten euch nicht ziehen lassen wird, auch nicht durch eine starke Hand. ");
INSERT INTO deuelo_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Und ich werde meine Hand ausstrecken und Ägypten schlagen mit allen meinen Wundern, die ich in seiner Mitte tun werde; und danach wird er euch ziehen lassen. ");
INSERT INTO deuelo_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Und ich werde diesem Volke Gnade geben in den Augen der Ägypter, und es wird geschehen, wenn ihr ausziehet, sollt ihr nicht leer ausziehen: ");
INSERT INTO deuelo_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","und es soll jedes Weib von ihrer Nachbarin und von ihrer Hausgenossin silberne Geräte und goldene Geräte und Kleider fordern; und ihr sollt sie auf eure Söhne und auf eure Töchter legen und die Ägypter berauben. ");
INSERT INTO deuelo_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Und Mose antwortete und sprach: Aber siehe, sie werden mir nicht glauben und nicht auf meine Stimme hören; denn sie werden sagen: Jehova ist dir nicht erschienen. ");
INSERT INTO deuelo_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Da sprach Jehova zu ihm: Was ist das in deiner Hand? Und er sprach: Ein Stab. ");
INSERT INTO deuelo_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Und er sprach: Wirf ihn auf die Erde. Da warf er ihn auf die Erde, und er wurde zur Schlange; und Mose floh vor ihr. ");
INSERT INTO deuelo_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Und Jehova sprach zu Mose: Strecke deine Hand aus und fasse sie beim Schwanze. Und er streckte seine Hand aus und ergriff sie, und sie wurde zum Stabe in seiner Hand: - ");
INSERT INTO deuelo_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","auf daß sie glauben, daß Jehova dir erschienen ist, der Gott ihrer Väter, der Gott Abrahams, der Gott Isaaks und der Gott Jakobs. ");
INSERT INTO deuelo_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Und Jehova sprach weiter zu ihm: Stecke doch deine Hand in deinen Busen. Und er steckte seine Hand in seinen Busen; und er zog sie heraus, und siehe, seine Hand war aussätzig wie Schnee. ");
INSERT INTO deuelo_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Und er sprach: Tue deine Hand wieder in deinen Busen. Und er tat seine Hand wieder in seinen Busen; und er zog sie aus seinem Busen heraus, und siehe, sie war wieder wie sein Fleisch. ");
INSERT INTO deuelo_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Und es wird geschehen, wenn sie dir nicht glauben und nicht auf die Stimme des ersten Zeichens hören, so werden sie der Stimme des anderen Zeichens glauben. ");
INSERT INTO deuelo_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Und es wird geschehen, wenn sie selbst diesen zwei Zeichen nicht glauben und nicht auf deine Stimme hören, so sollst du von dem Wasser des Stromes nehmen und es auf das Trockene gießen; und das Wasser, das du aus dem Strome nehmen wirst, es wird zu Blut werden auf dem Trockenen. ");
INSERT INTO deuelo_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Und Mose sprach zu Jehova: Ach, Herr! Ich bin kein Mann der Rede, weder seit gestern noch seit vorgestern, noch seitdem du zu deinem Knechte redest; denn ich bin schwer von Mund und schwer von Zunge. ");
INSERT INTO deuelo_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Da sprach Jehova zu ihm: Wer hat dem Menschen den Mund gemacht? Oder wer macht stumm oder taub oder sehend oder blind? Nicht ich, Jehova? ");
INSERT INTO deuelo_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Und nun gehe hin, und ich will mit deinem Munde sein und dich lehren, was du reden sollst. ");
INSERT INTO deuelo_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Und er sprach: Ach, Herr! Sende doch, durch wen du senden willst! ");
INSERT INTO deuelo_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Da entbrannte der Zorn Jehovas wider Mose, und er sprach: Ist nicht Aaron, der Levit, dein Bruder? Ich weiß, daß er reden kann. Und siehe, er geht auch aus, dir entgegen; und sieht er dich, so wird er sich freuen in seinem Herzen. ");
INSERT INTO deuelo_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Und du sollst zu ihm reden und die Worte in seinen Mund legen, und ich will mit deinem Munde und mit seinem Munde sein und will euch lehren, was ihr tun sollt. ");
INSERT INTO deuelo_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Und er soll für dich zum Volke reden; und es wird geschehen, er wird dir zum Munde sein, und du wirst ihm zum Gott sein. ");
INSERT INTO deuelo_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Und diesen Stab sollst du in deine Hand nehmen, mit welchem du die Zeichen tun sollst. ");
INSERT INTO deuelo_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Und Mose ging hin und kehrte zu Jethro, seinem Schwiegervater, zurück und sprach zu ihm: Laß mich doch gehen und zu meinen Brüdern zurückkehren, die in Ägypten sind, daß ich sehe, ob sie noch leben. Und Jethro sprach zu Mose: Gehe hin in Frieden! ");
INSERT INTO deuelo_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Und Jehova sprach zu Mose in Midian: Gehe hin, kehre nach Ägypten zurück; denn alle die Männer sind gestorben, die nach deinem Leben trachteten. ");
INSERT INTO deuelo_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Und Mose nahm sein Weib und seine Söhne und ließ sie auf Eseln reiten und kehrte in das Land Ägypten zurück; und Mose nahm den Stab Gottes in seine Hand. ");
INSERT INTO deuelo_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Und Jehova sprach zu Mose: Wenn du hinziehst, um nach Ägypten zurückzukehren, so sieh zu, daß du alle die Wunder, die ich in deine Hand gelegt habe, vor dem Pharao tuest. Und ich, ich will sein Herz verhärten, so daß er das Volk nicht ziehen lassen wird. ");
INSERT INTO deuelo_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Und du sollst zu dem Pharao sagen: So spricht Jehova: Mein Sohn, mein erstgeborener, ist Israel; ");
INSERT INTO deuelo_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","und ich sage zu dir: Laß meinen Sohn ziehen, daß er mir diene! Und weigerst du dich, ihn ziehen zu lassen, siehe, so werde ich deinen Sohn, deinen erstgeborenen, töten. ");
INSERT INTO deuelo_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Und es geschah auf dem Wege, in der Herberge, da fiel Jehova ihn an und suchte ihn zu töten. ");
INSERT INTO deuelo_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Da nahm Zippora einen scharfen Stein und schnitt die Vorhaut ihres Sohnes ab und warf sie an seine Füße und sprach: Fürwahr, du bist mir ein Blutbräutigam! ");
INSERT INTO deuelo_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Da ließ er von ihm ab. Damals sprach sie “Blutbräutigam” der Beschneidung wegen. ");
INSERT INTO deuelo_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Und Jehova sprach zu Aaron: Gehe hin, Mose entgegen in die Wüste. Und er ging hin und traf ihn am Berge Gottes und küßte ihn. ");
INSERT INTO deuelo_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Und Mose berichtete dem Aaron alle Worte Jehovas, der ihn gesandt, und alle die Zeichen, die er ihm geboten hatte. ");
INSERT INTO deuelo_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Und Mose und Aaron gingen hin, und sie versammelten alle Ältesten der Kinder Israel. ");
INSERT INTO deuelo_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Und Aaron redete alle die Worte, welche Jehova zu Mose geredet hatte, und er tat die Zeichen vor den Augen des Volkes. ");
INSERT INTO deuelo_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Und das Volk glaubte; und als sie hörten, daß Jehova die Kinder Israel heimgesucht und daß er ihr Elend gesehen habe, da neigten sie sich und beteten an. ");
INSERT INTO deuelo_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Und danach gingen Mose und Aaron hinein und sprachen zu dem Pharao: So spricht Jehova, der Gott Israels: Laß mein Volk ziehen, daß sie mir ein Fest halten in der Wüste! ");
INSERT INTO deuelo_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Da sprach der Pharao: Wer ist Jehova, auf dessen Stimme ich hören soll, Israel ziehen zu lassen? Ich kenne Jehova nicht, und auch werde ich Israel nicht ziehen lassen. ");
INSERT INTO deuelo_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Und sie sprachen: Der Gott der Hebräer ist uns begegnet. Laß uns doch drei Tagereisen weit in die Wüste ziehen und Jehova, unserem Gott, opfern, daß er uns nicht schlage mit der Pest oder mit dem Schwerte. ");
INSERT INTO deuelo_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Und der König von Ägypten sprach zu ihnen: Warum, Mose und Aaron, wollt ihr das Volk von seinen Arbeiten losmachen? Gehet an eure Lastarbeiten! ");
INSERT INTO deuelo_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Und der Pharao sprach: Siehe, das Volk des Landes ist nun zahlreich, und ihr wollt sie von ihren Lastarbeiten feiern lassen! ");
INSERT INTO deuelo_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Und der Pharao befahl selbigen Tages den Treibern des Volkes und seinen Vorstehern und sprach: ");
INSERT INTO deuelo_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Ihr sollt nicht mehr, wie früher, dem Volke Stroh geben, um Ziegel zu streichen; sie sollen selbst hingehen und sich Stroh sammeln. ");
INSERT INTO deuelo_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Und die Anzahl Ziegel, die sie früher gemacht haben, sollt ihr ihnen auflegen; ihr sollt nichts daran mindern, denn sie sind träge; darum schreien sie und sprechen: Wir wollen hinziehen, wir wollen unserem Gott opfern! ");
INSERT INTO deuelo_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Schwer laste der Dienst auf den Männern, daß sie damit zu schaffen haben und nicht achten auf Worte des Trugs. ");
INSERT INTO deuelo_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Und die Treiber des Volkes und seine Vorsteher gingen hinaus und redeten zu dem Volke und sprachen: So spricht der Pharao: Ich werde euch kein Stroh geben; ");
INSERT INTO deuelo_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","gehet ihr selbst hin, holet euch Stroh, wo ihr es findet; doch an eurem Dienste wird nichts gemindert werden. ");
INSERT INTO deuelo_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Und das Volk zerstreute sich im ganzen Lande Ägypten, um Stoppeln zu sammeln zu Stroh. ");
INSERT INTO deuelo_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Und die Treiber drängten sie und sprachen: Vollendet eure Arbeiten, das Tagewerk an seinem Tage, wie früher, als Stroh da war! ");
INSERT INTO deuelo_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Und die Vorsteher der Kinder Israel, welche die Treiber des Pharao über sie gesetzt hatten, wurden geschlagen, indem man sagte: Warum habt ihr euren Satz Ziegel, sowohl gestern als heute, nicht vollendet wie früher? ");
INSERT INTO deuelo_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Da gingen die Vorsteher der Kinder Israel hinein und schrieen zu dem Pharao und sprachen: Warum tust du deinen Knechten also? ");
INSERT INTO deuelo_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Stroh wird deinen Knechten nicht gegeben, und man sagt zu uns: Machet Ziegel! Und siehe, deine Knechte werden geschlagen, und es ist die Schuld deines Volkes. ");
INSERT INTO deuelo_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Und er sprach: Ihr seid träge, träge seid ihr! Darum sprechet ihr: Wir wollen hinziehen, wir wollen Jehova opfern. ");
INSERT INTO deuelo_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Und nun gehet hin, arbeitet! Und Stroh wird euch nicht gegeben werden, und das Maß Ziegel sollt ihr liefern. ");
INSERT INTO deuelo_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Da sahen die Vorsteher der Kinder Israel, daß es übel mit ihnen stand, weil man sagte: Ihr sollt nichts mindern an euren Ziegeln: das Tagewerk an seinem Tage! ");
INSERT INTO deuelo_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Und sie begegneten Mose und Aaron, die ihnen entgegentraten, als sie von dem Pharao herauskamen. ");
INSERT INTO deuelo_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Und sie sprachen zu ihnen: Jehova sehe auf euch und richte, daß ihr unseren Geruch stinkend gemacht habt vor dem Pharao und vor seinen Knechten, so daß ihr ihnen das Schwert in die Hand gegeben habt, uns zu töten. ");
INSERT INTO deuelo_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Da wandte sich Mose zu Jehova und sprach: Herr, warum hast du so übel an diesem Volke getan? Warum doch hast du mich gesandt? ");
INSERT INTO deuelo_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Denn seitdem ich zu dem Pharao hineingegangen bin, um in deinem Namen zu reden, hat er diesem Volke übel getan, und du hast dein Volk durchaus nicht errettet. ");
INSERT INTO deuelo_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Und Jehova sprach zu Mose: Nun sollst du sehen, was ich dem Pharao tun werde; denn durch eine starke Hand gezwungen soll er sie ziehen lassen, und durch eine starke Hand gezwungen soll er sie aus seinem Lande wegtreiben. ");
INSERT INTO deuelo_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Und Gott redete zu Mose und sprach zu ihm: Ich bin Jehova. ");
INSERT INTO deuelo_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Und ich bin Abraham, Isaak und Jakob erschienen als Gott, der Allmächtige; aber mit meinem Namen Jehova habe ich mich ihnen nicht kundgegeben. ");
INSERT INTO deuelo_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Und auch habe ich meinen Bund mit ihnen aufgerichtet, ihnen das Land Kanaan zu geben, das Land ihrer Fremdlingschaft, in welchem sie als Fremdlinge geweilt haben. ");
INSERT INTO deuelo_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Und auch habe ich das Wehklagen der Kinder Israel gehört, welche die Ägypter zum Dienst anhalten, und habe meines Bundes gedacht. ");
INSERT INTO deuelo_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Darum sprich zu den Kindern Israel: Ich bin Jehova, und ich werde euch herausführen unter den Lastarbeiten der Ägypter hinweg und werde euch erretten aus ihrem Dienste und euch erlösen mit ausgestrecktem Arm und durch große Gerichte. ");
INSERT INTO deuelo_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Und ich will euch annehmen mir zum Volke und will euer Gott sein; und ihr sollt erkennen, daß ich Jehova, euer Gott, bin, der euch herausführt unter den Lastarbeiten der Ägypter hinweg. ");
INSERT INTO deuelo_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Und ich werde euch in das Land bringen, welches dem Abraham, Isaak und Jakob zu geben ich meine Hand erhoben habe, und werde es euch zum Besitztum geben, ich, Jehova. ");
INSERT INTO deuelo_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Und Mose redete also zu den Kindern Israel; aber sie hörten nicht auf Mose vor Ungeduld und vor hartem Dienste. ");
INSERT INTO deuelo_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Gehe hinein, rede zu dem Pharao, dem Könige von Ägypten, daß er die Kinder Israel aus seinem Lande ziehen lasse. ");
INSERT INTO deuelo_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Und Mose redete vor Jehova und sprach: Siehe, die Kinder Israel haben nicht auf mich gehört, und wie sollte der Pharao mich hören, zumal ich unbeschnitten an Lippen bin? ");
INSERT INTO deuelo_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Und Jehova redete zu Mose und zu Aaron und gab ihnen Befehl an die Kinder Israel und an den Pharao, den König von Ägypten, um die Kinder Israel aus dem Lande Ägypten hinauszuführen. ");
INSERT INTO deuelo_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Dies sind die Häupter ihrer Vaterhäuser: Die Söhne Rubens, des Erstgeborenen Israels: Hanok und Pallu, Hezron und Karmi; das sind die Geschlechter Rubens. ");
INSERT INTO deuelo_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Und die Söhne Simeons: Jemuel und Jamin und Ohad und Jakin und Zochar und Saul, der Sohn der Kanaaniterin; das sind die Geschlechter Simeons. ");
INSERT INTO deuelo_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Und dies sind die Namen der Söhne Levis nach ihren Geschlechtern: Gerson und Kehath und Merari; und die Lebensjahre Levis waren hundertsiebenunddreißig Jahre. ");
INSERT INTO deuelo_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Die Söhne Gersons: Libni und Simei, nach ihren Familien. ");
INSERT INTO deuelo_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Und die Söhne Kehaths: Amram und Jizhar und Hebron und Ussiel; und die Lebensjahre Kehaths waren hundertdreiunddreißig Jahre. ");
INSERT INTO deuelo_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Und die Söhne Meraris: Machli und Musi; das sind die Familien Levis nach ihren Geschlechtern. ");
INSERT INTO deuelo_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Und Amram nahm Jokebed, seine Muhme, sich zum Weibe, und sie gebar ihm Aaron und Mose; und die Lebensjahre Amrams waren hundertsiebenunddreißig Jahre. ");
INSERT INTO deuelo_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Und die Söhne Jizhars: Korah und Nepheg und Sikri. ");
INSERT INTO deuelo_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Und die Söhne Ussiels: Mischael und Elzaphan und Sithri. ");
INSERT INTO deuelo_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Und Aaron nahm Elischeba, die Tochter Amminadabs, die Schwester Nachschons, sich zum Weibe; und sie gabar ihm Nadab und Abihu, Eleasar und Ithamar. ");
INSERT INTO deuelo_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Und die Söhne Korahs: Assir und Elkana und Abiasaph; das sind die Familien der Korhiter. ");
INSERT INTO deuelo_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Und Eleasar, der Sohn Aarons, nahm eine von den Töchtern Putiels sich zum Weibe, und sie gebar ihm Pinehas; das sind die Häupter der Väter der Leviten nach ihren Geschlechtern. ");
INSERT INTO deuelo_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Dieser Aaron und dieser Mose sind es, zu denen Jehova gesprochen hat: Führet die Kinder Israel aus dem Lande Ägypten hinaus, nach ihren Heeren. ");
INSERT INTO deuelo_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Diese sind es, die zu dem Pharao, dem Könige von Ägypten, redeten, um die Kinder Israel aus Ägypten hinauszuführen: dieser Mose und dieser Aaron. ");
INSERT INTO deuelo_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Und es geschah an dem Tage, da Jehova zu Mose redete im Lande Ägypten, ");
INSERT INTO deuelo_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","da redete Jehova zu Mose und sprach: Ich bin Jehova; rede zu dem Pharao, dem Könige von Ägypten alles, was ich zu dir rede. ");
INSERT INTO deuelo_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Und Mose sprach vor Jehova: Siehe, ich bin unbeschnitten an Lippen, und wie sollte der Pharao auf mich hören? ");
INSERT INTO deuelo_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Und Jehova sprach zu Mose: Siehe, ich habe dich dem Pharao zum Gott gesetzt, und dein Bruder Aaron soll dein Prophet sein. ");
INSERT INTO deuelo_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Du sollst alles reden, was ich dir gebieten werde, und dein Bruder Aaron soll zu dem Pharao reden, daß er die Kinder Israel aus seinem Lande ziehen lasse. ");
INSERT INTO deuelo_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Und ich will das Herz des Pharao verhärten und meine Zeichen und meine Wunder mehren im Lande Ägypten. ");
INSERT INTO deuelo_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Und der Pharao wird nicht auf euch hören; und ich werde meine Hand an Ägypten legen und meine Heere, mein Volk, die Kinder Israel, aus dem Lande Ägypten herausführen durch große Gerichte. ");
INSERT INTO deuelo_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Und die Ägypter sollen erkennen, daß ich Jehova bin, wenn ich meine Hand über Ägypten ausstrecke und die Kinder Israel aus ihrer Mitte herausführe. ");
INSERT INTO deuelo_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Und Mose und Aaron taten es; so wie Jehova ihnen geboten hatte, also taten sie. ");
INSERT INTO deuelo_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Und Mose war achtzig Jahre alt, und Aaron dreiundachtzig Jahre alt, als sie zu dem Pharao redeten. ");
INSERT INTO deuelo_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Und Jehova redete zu Mose und zu Aaron und sprach: ");
INSERT INTO deuelo_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Wenn der Pharao zu euch reden und sagen wird: Tut ein Wunder für euch! so sollst du zu Aaron sagen: Nimm deinen Stab und wirf ihn hin vor dem Pharao; er soll zur Schlange werden. ");
INSERT INTO deuelo_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Und Mose und Aaron gingen zu dem Pharao hinein und taten also, wie Jehova geboten hatte; und Aaron warf seinen Stab hin vor dem Pharao und vor seinen Knechten, und er wurde zur Schlange. ");
INSERT INTO deuelo_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Da berief auch der Pharao die Weisen und die Zauberer; und auch sie, die Schriftgelehrten Ägyptens, taten also mit ihren Zauberkünsten ");
INSERT INTO deuelo_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","und warfen ein jeder seinen Stab hin, und sie wurden zu Schlangen; aber Aarons Stab verschlang ihre Stäbe. ");
INSERT INTO deuelo_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Und das Herz des Pharao verhärtete sich, und er hörte nicht auf sie, so wie Jehova geredet hatte. ");
INSERT INTO deuelo_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Und Jehova sprach zu Mose: Das Herz des Pharao ist verstockt; er weigert sich, das Volk ziehen zu lassen. ");
INSERT INTO deuelo_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Gehe am Morgen zum Pharao siehe, er wird ans Wasser hinausgehen und tritt ihm entgegen an dem Ufer des Stromes, und nimm den Stab, der in eine Schlange verwandelt worden, in deine Hand ");
INSERT INTO deuelo_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","und sprich zu ihm: Jehova, der Gott der Hebräer, hat mich zu dir gesandt und gesagt: Laß mein Volk ziehen, daß sie mir dienen in der Wüste! Aber siehe, du hast bisher nicht gehört. ");
INSERT INTO deuelo_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","So spricht Jehova: Daran sollst du erkennen, daß ich Jehova bin: Siehe, ich will mit dem Stabe, der in meiner Hand ist, auf das Wasser schlagen, das in dem Strome ist, und es wird in Blut verwandelt werden. ");
INSERT INTO deuelo_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Und die Fische, die im Strome sind, werden sterben, und der Strom wird stinken, und die Ägypter wird's ekeln, Wasser aus dem Strome zu trinken. ");
INSERT INTO deuelo_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Und Jehova sprach zu Mose: Sprich zu Aaron: Nimm deinen Stab und strecke deine Hand aus über die Wasser Ägyptens, über seine Flüsse, über seine Kanäle und über seine Teiche und über alle seine Wassersammlungen, daß sie zu Blut werden; und es wird Blut sein im ganzen Lande Ägypten, sowohl in hölzernen als auch in steinernen Gefäßen. ");
INSERT INTO deuelo_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Und Mose und Aaron taten also, wie Jehova geboten hatte; und er erhob den Stab und schlug das Wasser, das im Strome war, vor den Augen des Pharao und vor den Augen seiner Knechte. Da wurde alles Wasser, das im Strome war, in Blut verwandelt; ");
INSERT INTO deuelo_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","und die Fische, die im Strome waren, starben, und der Strom wurde stinkend, und die Ägypter konnten das Wasser aus dem Strome nicht trinken; und das Blut war im ganzen Lande Ägypten. ");
INSERT INTO deuelo_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Und die Schriftgelehrten Ägyptens taten ebenso mit ihren Zauberkünsten; und das Herz des Pharao verhärtete sich, und er hörte nicht auf sie, so wie Jehova geredet hatte. ");
INSERT INTO deuelo_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Und der Pharao wandte sich und ging in sein Haus und nahm auch dies nicht zu Herzen. ");
INSERT INTO deuelo_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Und alle Ägypter gruben rings um den Strom nach Wasser zum Trinken, denn von dem Wasser des Stromes konnten sie nicht trinken. ");
INSERT INTO deuelo_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Und es wurden sieben Tage erfüllt, nachdem Jehova den Strom geschlagen hatte. ");
INSERT INTO deuelo_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Und Jehova sprach zu Mose: Gehe zu dem Pharao hinein und sprich zu ihm: So spricht Jehova: Laß mein Volk ziehen, daß sie mir dienen! ");
INSERT INTO deuelo_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Und wenn du dich weigerst, es ziehen zu lassen, siehe, so will ich dein ganzes Gebiet mit Fröschen schlagen. ");
INSERT INTO deuelo_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Und der Strom wird von Fröschen wimmeln, und sie werden heraufsteigen und in dein Haus kommen und in dein Schlafgemach und auf dein Bett und in die Häuser deiner Knechte und unter dein Volk und in deine Öfen und in deine Backtröge. ");
INSERT INTO deuelo_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Und die Frösche werden heraufkommen über dich und über dein Volk und über alle deine Knechte. ");
INSERT INTO deuelo_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Und Jehova sprach zu Mose: Sprich zu Aaron: Strecke deine Hand mit deinem Stabe aus über die Flüsse, über die Kanäle und über die Teiche, und laß die Frösche über das Land Ägypten heraufkommen. ");
INSERT INTO deuelo_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Da streckte Aaron seine Hand aus über die Wasser in Ägypten, und die Frösche kamen herauf und bedeckten das Land Ägypten. ");
INSERT INTO deuelo_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Und die Schriftgelehrten taten ebenso mit ihren Zauberkünsten und ließen die Frösche über das Land Ägypten heraufkommen. ");
INSERT INTO deuelo_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Und der Pharao rief Mose und Aaron und sprach: Flehet zu Jehova, daß er die Frösche von mir und von meinem Volke wegnehme, so will ich das Volk ziehen lassen, daß sie Jehova opfern. ");
INSERT INTO deuelo_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Und Mose sprach zum Pharao: Bestimme über mich, auf wann ich für dich und für deine Knechte und für dein Volk flehen soll, die Frösche von dir und aus deinen Häusern auszurotten; nur im Strome sollen sie übrigbleiben. ");
INSERT INTO deuelo_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Und er sprach: Auf morgen. Da sprach er: Es sei nach deinem Worte, auf daß du wissest, daß niemand ist wie Jehova, unser Gott. ");
INSERT INTO deuelo_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Und die Frösche werden von dir weichen und von deinen Häusern und von deinen Knechten und von deinem Volke; nur im Strome sollen sie übrigbleiben. ");
INSERT INTO deuelo_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Und Mose und Aaron gingen von dem Pharao hinaus; und Mose schrie zu Jehova wegen der Frösche, die er über den Pharao gebracht hatte. ");
INSERT INTO deuelo_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Und Jehova tat nach dem Worte Moses, und die Frösche starben weg aus den Häusern, aus den Gehöften und von den Feldern. ");
INSERT INTO deuelo_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Und sie sammelten sie haufenweise, und das Land stank. ");
INSERT INTO deuelo_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Und als der Pharao sah, daß Erleichterung geworden war, da verstockte er sein Herz, und er hörte nicht auf sie, so wie Jehova geredet hatte. ");
INSERT INTO deuelo_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Und Jehova sprach zu Mose: Sprich zu Aaron: Strecke deinen Stab aus und schlage den Staub der Erde, und er wird zu Stechmücken werden im ganzen Lande Ägypten. ");
INSERT INTO deuelo_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Und sie taten also; und Aaron streckte seine Hand mit seinem Stabe aus und schlug den Staub der Erde, und die Stechmücken kamen über die Menschen und über das Vieh; aller Staub der Erde wurde zu Stechmücken im ganzen Lande Ägypten. ");
INSERT INTO deuelo_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Und die Schriftgelehrten taten ebenso mit ihren Zauberkünsten, um die Stechmücken hervorzubringen; aber sie konnten es nicht. Und die Stechmücken kamen über die Menschen und über das Vieh. ");
INSERT INTO deuelo_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Da sprachen die Schriftgelehrten zum Pharao: Das ist Gottes Finger! Aber das Herz des Pharao verhärtete sich, und er hörte nicht auf sie, so wie Jehova geredet hatte. ");
INSERT INTO deuelo_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Und Jehova sprach zu Mose: Mache dich des Morgens früh auf und tritt vor den Pharao siehe, er wird ans Wasser hinausgehen und sprich zu ihm: Also spricht Jehova: Laß mein Volk ziehen, daß sie mir dienen! ");
INSERT INTO deuelo_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Denn wenn du mein Volk nicht ziehen lässest, siehe, so werde ich die Hundsfliegen senden über dich und über deine Knechte und über dein Volk und in deine Häuser; und die Häuser der Ägypter werden voll Hundsfliegen sein und auch der Erdboden, auf dem sie sind. ");
INSERT INTO deuelo_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Und ich werde an selbigem Tage das Land Gosen aussondern, in welchem mein Volk weilt, daß daselbst keine Hundsfliegen seien, auf daß du wissest, daß ich, Jehova, in der Mitte des Landes bin. ");
INSERT INTO deuelo_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Und ich werde eine Scheidung setzen zwischen meinem Volke und deinem Volke; morgen wird dieses Zeichen geschehen. ");
INSERT INTO deuelo_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Und Jehova tat also; und es kamen Hundsfliegen in Menge in das Haus des Pharao und in die Häuser seiner Knechte; und im ganzen Lande Ägypten wurde das Land von den Hundsfliegen verderbt. ");
INSERT INTO deuelo_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Und der Pharao rief Mose und Aaron und sprach: Gehet hin und opfert eurem Gott in dem Lande. ");
INSERT INTO deuelo_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Und Mose sprach: Es geziemt sich nicht, also zu tun; denn wir würden Jehova, unserem Gott, der Ägypter Greuel opfern; siehe, opferten wir der Ägypter Greuel vor ihren Augen, würden sie uns nicht steinigen? ");
INSERT INTO deuelo_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Drei Tagereisen weit wollen wir in die Wüste ziehen und Jehova, unserem Gott, opfern, so wie er zu uns geredet hat. ");
INSERT INTO deuelo_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Und der Pharao sprach: Ich will euch ziehen lassen, daß ihr Jehova, eurem Gott, in der Wüste opfert; nur entfernet euch nicht so weit! Flehet für mich! ");
INSERT INTO deuelo_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Da sprach Mose: Siehe, ich gehe von dir hinaus und will zu Jehova flehen; und morgen werden die Hundsfliegen von dem Pharao weichen, von seinen Knechten und von seinem Volke; nur handle der Pharao ferner nicht betrüglich, daß er das Volk nicht ziehen lasse, um Jehova zu opfern. ");
INSERT INTO deuelo_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Und Mose ging von dem Pharao hinaus und flehte zu Jehova. ");
INSERT INTO deuelo_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Und Jehova tat nach dem Worte Moses, und die Hundsfliegen wichen von dem Pharao, von seinen Knechten und von seinem Volke; nicht eine blieb übrig. ");
INSERT INTO deuelo_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Aber der Pharao verstockte sein Herz auch dieses Mal und ließ das Volk nicht ziehen. ");
INSERT INTO deuelo_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Und Jehova sprach zu Mose: Gehe zu dem Pharao hinein und sprich zu ihm: So spricht Jehova, der Gott der Hebräer: Laß mein Volk ziehen, daß sie mir dienen! ");
INSERT INTO deuelo_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Denn wenn du dich weigerst, sie ziehen zu lassen, und du sie noch festhältst, ");
INSERT INTO deuelo_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","siehe, so wird die Hand Jehovas über dein Vieh kommen, das auf dem Felde ist: über die Pferde, über die Esel, über die Kamele, über die Rinder und über das Kleinvieh, eine sehr schwere Pest. ");
INSERT INTO deuelo_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Und Jehova wird einen Unterschied machen zwischen dem Vieh Israels und dem Vieh der Ägypter, und von allem, was den Kindern Israel gehört, wird nichts sterben. ");
INSERT INTO deuelo_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Und Jehova bestimmte eine Zeit und sprach: Morgen wird Jehova dieses tun im Lande. ");
INSERT INTO deuelo_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Und Jehova tat dieses am anderen Tage, und alles Vieh der Ägypter starb, aber von dem Vieh der Kinder Israel starb nicht eines. ");
INSERT INTO deuelo_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Und der Pharao sandte hin, und siehe, von dem Vieh Israels war auch nicht eines gestorben. Aber das Herz des Pharao verstockte sich, und er ließ das Volk nicht ziehen. ");
INSERT INTO deuelo_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Und Jehova sprach zu Mose und zu Aaron: Nehmet eure Fäuste voll Ofenruß, und Mose streue ihn gen Himmel vor den Augen des Pharao; ");
INSERT INTO deuelo_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","und er wird zu Staub werden über dem ganzen Lande Ägypten und wird an Menschen und Vieh zu Geschwüren werden, die in Blattern ausbrechen, im ganzen Lande Ägypten. ");
INSERT INTO deuelo_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Und sie nahmen den Ofenruß und stellten sich vor den Pharao, und Mose streute ihn gen Himmel; und er wurde zu Blattergeschwüren, die an Menschen und Vieh ausbrachen. ");
INSERT INTO deuelo_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Und die Schriftgelehrten vermochten nicht vor Mose zu stehen wegen der Geschwüre; denn die Geschwüre waren an den Schriftgelehrten und an allen Ägyptern. ");
INSERT INTO deuelo_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Und Jehova verhärtete das Herz des Pharao, und er hörte nicht auf sie, so wie Jehova zu Mose geredet hatte. ");
INSERT INTO deuelo_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Und Jehova sprach zu Mose: Mache dich des Morgens früh auf und tritt vor dem Pharao und sprich zu ihm: So spricht Jehova, der Gott der Hebräer: Laß mein Volk ziehen, daß sie mir dienen! ");
INSERT INTO deuelo_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Denn dieses Mal will ich alle meine Plagen in dein Herz senden und über deine Knechte und über dein Volk, auf daß du wissest, daß niemand ist wie ich auf der ganzen Erde. ");
INSERT INTO deuelo_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Denn jetzt hätte ich meine Hand ausgestreckt und hätte dich und dein Volk mit der Pest geschlagen, und du wärest vertilgt worden von der Erde; ");
INSERT INTO deuelo_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","aber eben deswegen habe ich dich bestehen lassen, um dir meine Kraft zu zeigen und damit man meinen Namen verkündige auf der ganzen Erde. ");
INSERT INTO deuelo_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Erhebst du dich noch wider mein Volk, daß du sie nicht ziehen lässest, ");
INSERT INTO deuelo_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","siehe, so will ich morgen um diese Zeit einen sehr schweren Hagel regnen lassen, desgleichen nicht in Ägypten gewesen ist, von dem Tage seiner Gründung an bis jetzt. ");
INSERT INTO deuelo_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Und nun sende hin, und bringe dein Vieh in Sicherheit und alles, was du auf dem Felde hast. Alle Menschen und alles Vieh, die auf dem Felde gefunden und nicht ins Haus aufgenommen werden, auf die fällt der Hagel herab, und sie werden sterben. - ");
INSERT INTO deuelo_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Wer unter den Knechten des Pharao das Wort Jehovas fürchtete, der flüchtete seine Knechte und sein Vieh in die Häuser. ");
INSERT INTO deuelo_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Wer aber das Wort Jehovas nicht zu Herzen nahm, der ließ seine Knechte und sein Vieh auf dem Felde. ");
INSERT INTO deuelo_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Und Jehova sprach zu Mose: Strecke deine Hand aus gen Himmel, daß im ganzen Lande Ägypten Hagel komme auf die Menschen und auf das Vieh und auf alles Kraut des Feldes im Lande Ägypten. ");
INSERT INTO deuelo_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Und Mose streckte seinen Stab aus gen Himmel, und Jehova sandte Donner und Hagel, und Feuer fuhr zur Erde. Und Jehova ließ Hagel auf das Land Ägypten regnen. ");
INSERT INTO deuelo_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Und es kam Hagel, und Feuer, mitten im Hagel sich ineinander schlingend, sehr schwer, desgleichen im ganzen Lande Ägypten nicht gewesen war, seitdem es eine Nation geworden ist. ");
INSERT INTO deuelo_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Und der Hagel schlug im ganzen Lande Ägypten alles, was auf dem Felde war, vom Menschen bis zum Vieh; und alles Kraut des Feldes schlug der Hagel, und alle Bäume des Feldes zerbrach er. ");
INSERT INTO deuelo_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Nur im Lande Gosen, wo die Kinder Israel waren, war kein Hagel. ");
INSERT INTO deuelo_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Und der Pharao sandte hin und ließ Mose und Aaron rufen und sprach zu ihnen: Ich habe dieses Mal gesündigt. Jehova ist der Gerechte, ich aber und mein Volk sind die Schuldigen. ");
INSERT INTO deuelo_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Flehet zu Jehova, und es sei genug des Donners Gottes und des Hagels; so will ich euch ziehen lassen, und ihr sollt nicht länger bleiben. ");
INSERT INTO deuelo_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Da sprach Mose zu ihm: Sowie ich zur Stadt hinausgehe, will ich meine Hände zu Jehova ausbreiten; der Donner wird aufhören, und der Hagel wird nicht mehr sein, auf daß du wissest, daß die Erde Jehova gehört. ");
INSERT INTO deuelo_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Du aber und deine Knechte, ich weiß, daß ihr euch noch nicht vor Jehova Gott fürchten werdet. - ");
INSERT INTO deuelo_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Und der Flachs und die Gerste wurden geschlagen; denn die Gerste war in der Ähre, und der Flachs hatte Knospen. ");
INSERT INTO deuelo_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Aber der Weizen und der Spelt wurden nicht geschlagen, weil sie spätzeitig sind. - ");
INSERT INTO deuelo_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Und Mose ging von dem Pharao zur Stadt hinaus und breitete seine Hände aus zu Jehova; und der Donner und der Hagel hörten auf, und der Regen ergoß sich nicht mehr auf die Erde. ");
INSERT INTO deuelo_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Und als der Pharao sah, daß der Regen und der Hagel und der Donner aufgehört hatten, da fuhr er fort zu sündigen und verstockte sein Herz, er und seine Knechte. ");
INSERT INTO deuelo_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Und das Herz des Pharao verhärtete sich, und er ließ die Kinder Israel nicht ziehen, so wie Jehova durch Mose geredet hatte. ");
INSERT INTO deuelo_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Und Jehova sprach zu Mose: Gehe zu dem Pharao hinein, denn ich habe sein Herz verstockt und das Herz seiner Knechte, um diese meine Zeichen in seiner Mitte zu tun ");
INSERT INTO deuelo_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","und damit du vor den Ohren deiner Kinder und deiner Kindeskinder erzählest, was ich in Ägypten ausgerichtet, und meine Zeichen, die ich unter ihnen getan habe; und ihr werdet wissen, daß ich Jehova bin. ");
INSERT INTO deuelo_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Da gingen Mose und Aaron zu dem Pharao hinein und sprachen zu ihm: So spricht Jehova, der Gott der Hebräer: Bis wann weigerst du dich, dich vor mir zu demütigen? Laß mein Volk ziehen, daß sie mir dienen! ");
INSERT INTO deuelo_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Denn wenn du dich weigerst, mein Volk ziehen zu lassen, siehe, so will ich morgen Heuschrecken in dein Gebiet bringen; ");
INSERT INTO deuelo_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","und sie werden das Angesicht des Landes bedecken, daß man das Land nicht wird sehen können; und sie werden das Übrige fressen, das entronnen, das euch übriggeblieben ist von dem Hagel, und werden alle Bäume fressen, die euch auf dem Felde wachsen; ");
INSERT INTO deuelo_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","und sie werden deine Häuser erfüllen und die Häuser aller deiner Knechte und die Häuser aller Ägypter, wie es deine Väter und die Väter deiner Väter nicht gesehen haben, seit dem Tage, da sie auf Erden gewesen sind, bis auf diesen Tag. Und er wandte sich und ging von dem Pharao hinaus. ");
INSERT INTO deuelo_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Und die Knechte des Pharao sprachen zu ihm: Bis wann soll uns dieser zum Fallstrick sein? Laß die Leute ziehen, daß sie Jehova, ihrem Gott, dienen! Erkennst du noch nicht, daß Ägypten zu Grunde geht? ");
INSERT INTO deuelo_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Und Mose und Aaron wurden wieder zu dem Pharao gebracht, und er sprach zu ihnen: Ziehet hin, dienet Jehova, eurem Gott! Welche alle sind es, die ziehen sollen? ");
INSERT INTO deuelo_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Da sprach Mose: Mit unseren Jungen und mit unseren Alten wollen wir ziehen, mit unseren Söhnen und mit unseren Töchtern, mit unserem Kleinvieh und mit unseren Rindern wollen wir ziehen; denn wir haben ein Fest Jehovas. ");
INSERT INTO deuelo_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Und er sprach zu ihnen: Jehova sei so mit euch, wie ich euch und eure Kinder ziehen lasse! Sehet zu, denn ihr habt Böses vor! ");
INSERT INTO deuelo_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Nicht also! Ziehet doch hin, ihr Männer, und dienet Jehova; denn das ist es, was ihr begehrt habt. Und man trieb sie von dem Pharao hinaus. ");
INSERT INTO deuelo_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Und Jehova sprach zu Mose: Strecke deine Hand aus über das Land Ägypten wegen der Heuschrecken, daß sie über das Land Ägypten heraufkommen und alles Kraut des Landes fressen, alles was der Hagel übriggelassen hat. ");
INSERT INTO deuelo_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Und Mose streckte seinen Stab aus über das Land Ägypten, und Jehova führte einen Ostwind ins Land selbigen ganzen Tag und die ganze Nacht. Als es Morgen wurde, da trieb der Ostwind die Heuschrecken herbei. ");
INSERT INTO deuelo_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Und die Heuschrecken kamen herauf über das ganze Land Ägypten und ließen sich in dem ganzen Gebiet Ägyptens nieder, in gewaltiger Menge; vor ihnen sind nicht derart Heuschrecken gewesen wie diese, und nach ihnen werden nicht derart sein. ");
INSERT INTO deuelo_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Und sie bedeckten das Angesicht des ganzen Landes, so daß das Land verfinstert wurde; und sie fraßen alles Kraut des Landes und alle Früchte der Bäume, die der Hagel übriggelassen hatte; und es blieb nichts Grünes übrig an den Bäumen und am Kraut des Feldes im ganzen Lande Ägypten. ");
INSERT INTO deuelo_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Und der Pharao rief Mose und Aaron eilends und sprach: Ich habe gesündigt gegen Jehova, euren Gott, und gegen euch! ");
INSERT INTO deuelo_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Und nun vergib doch meine Sünde nur dieses Mal, und flehet zu Jehova, eurem Gott, daß er nur diesen Tod von mir wegnehme! ");
INSERT INTO deuelo_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Da ging er von dem Pharao hinaus und flehte zu Jehova. ");
INSERT INTO deuelo_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Und Jehova wandte den Wind in einen sehr starken Westwind, der hob die Heuschrecken auf und warf sie ins Schilfmeer. Es blieb nicht eine Heuschrecke übrig in dem ganzen Gebiet Ägyptens. ");
INSERT INTO deuelo_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Und Jehova verhärtete das Herz des Pharao, und er ließ die Kinder Israel nicht ziehen. ");
INSERT INTO deuelo_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Und Jehova sprach zu Mose: Strecke deine Hand aus gen Himmel, daß eine Finsternis über das Land Ägypten komme, so daß man die Finsternis greifen möge. ");
INSERT INTO deuelo_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Und Mose streckte seine Hand aus gen Himmel; da entstand im ganzen Lande Ägypten eine dichte Finsternis drei Tage lang. ");
INSERT INTO deuelo_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Sie sahen einer den anderen nicht, und keiner stand von seinem Platze auf drei Tage lang; aber alle Kinder Israel hatten Licht in ihren Wohnungen. - ");
INSERT INTO deuelo_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Und der Pharao rief Mose und sprach: Ziehet hin, dienet Jehova; nur euer Kleinvieh und eure Rinder sollen zurückbleiben; auch eure Kinder mögen mit euch ziehen. ");
INSERT INTO deuelo_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Und Mose sprach: Auch Schlachtopfer und Brandopfer mußt du in unsere Hände geben, daß wir Jehova, unserem Gott opfern. ");
INSERT INTO deuelo_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","So muß auch unser Vieh mit uns ziehen, nicht eine Klaue darf zurückbleiben; denn davon werden wir nehmen, um Jehova, unserem Gott, zu dienen; wir wissen ja nicht, womit wir Jehova dienen sollen, bis wir dorthin kommen. ");
INSERT INTO deuelo_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Aber Jehova verhärtete das Herz des Pharao, und er wollte sie nicht ziehen lassen. ");
INSERT INTO deuelo_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Und der Pharao sprach zu ihm: Gehe hinweg von mir; hüte dich, sieh mein Angesicht nicht wieder! Denn an dem Tage, da du mein Angesicht siehst, wirst du sterben. ");
INSERT INTO deuelo_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Und Mose sprach: Du hast recht geredet, ich werde dein Angesicht nicht mehr wiedersehen. ");
INSERT INTO deuelo_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Und Jehova sprach zu Mose: Noch eine Plage will ich über den Pharao und über Ägypten bringen; danach wird er euch von hinnen ziehen lassen. Wenn er euch vollends ziehen lassen wird, so wird er euch sogar von hier wegtreiben. ");
INSERT INTO deuelo_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Rede doch zu den Ohren des Volkes, daß sie ein jeder von seinem Nachbarn und eine jede von ihrer Nachbarin silberne Geräte und goldene Geräte fordern. ");
INSERT INTO deuelo_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Und Jehova gab dem Volke Gnade in den Augen der Ägypter. Auch war der Mann Mose sehr groß im Lande Ägypten, in den Augen der Knechte des Pharao und in den Augen des Volkes. ");
INSERT INTO deuelo_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Und Mose sprach: So spricht Jehova: Um Mitternacht will ich ausgehen mitten durch Ägypten; ");
INSERT INTO deuelo_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","und alle Erstgeburt im Lande Ägypten soll sterben, von dem Erstgeborenen des Pharao, der auf seinem Throne sitzt, bis zum Erstgeborenen der Magd, die hinter der Mühle ist, und alle Erstgeburt des Viehes. ");
INSERT INTO deuelo_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Und es wird ein großes Geschrei sein im ganzen Lande Ägypten, desgleichen nie gewesen ist und desgleichen nicht mehr sein wird. ");
INSERT INTO deuelo_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Aber gegen alle Kinder Israel wird nicht ein Hund seine Zunge spitzen, vom Menschen bis zum Vieh; auf daß ihr wisset, daß Jehova einen Unterschied macht zwischen den Ägyptern und den Israeliten. ");
INSERT INTO deuelo_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Und alle diese deine Knechte werden zu mir herabkommen und sich vor mir niederbeugen und sagen: Ziehe aus, du und alles Volk, das dir folgt! Und danach werde ich ausziehen. Und er ging von dem Pharao hinaus in glühendem Zorn. ");
INSERT INTO deuelo_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Und Jehova hatte zu Mose gesagt: Der Pharao wird nicht auf euch hören, auf daß meine Wunder sich mehren im Lande Ägypten. ");
INSERT INTO deuelo_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Und Mose und Aaron haben alle diese Wunder getan vor dem Pharao; aber Jehova verhärtete das Herz des Pharao, und er ließ die Kinder Israel nicht aus seinem Lande ziehen. ");
INSERT INTO deuelo_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Und Jehova redete zu Mose und Aaron im Lande Ägypten und sprach: ");
INSERT INTO deuelo_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Dieser Monat soll euch der Anfang der Monate sein, er soll euch der erste sein von den Monaten des Jahres. ");
INSERT INTO deuelo_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Redet zu der ganzen Gemeinde Israel und sprechet: Am Zehnten dieses Monats, da nehme sich ein jeder ein Lamm für ein Vaterhaus, ein Lamm für ein Haus. ");
INSERT INTO deuelo_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Und wenn das Haus nicht zahlreich genug ist für ein Lamm, so nehme er es und sein Nachbar, der nächste an seinem Hause, nach der Zahl der Seelen; einen jeden sollt ihr nach dem Maße seines Essens rechnen auf das Lamm. ");
INSERT INTO deuelo_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Ein Lamm ohne Fehl sollt ihr haben, ein männliches, einjährig; von den Schafen oder von den Ziegen sollt ihr es nehmen. ");
INSERT INTO deuelo_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Und ihr sollt es in Verwahrung haben bis auf den vierzehnten Tag dieses Monats; und die ganze Versammlung der Gemeinde Israel soll es schlachten zwischen den zwei Abenden. ");
INSERT INTO deuelo_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Und sie sollen von dem Blute nehmen und es an die beiden Pfosten und an die Oberschwelle tun, an den Häusern, in welchen sie es essen. ");
INSERT INTO deuelo_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Und sie sollen in selbiger Nacht das Fleisch essen, gebraten am Feuer, und ungesäuertes Brot; mit bitteren Kräutern sollen sie es essen. ");
INSERT INTO deuelo_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Ihr sollt nichts roh davon essen und keineswegs im Wasser gesotten, sondern am Feuer gebraten: seinen Kopf samt seinen Schenkeln und samt seinem Eingeweide. ");
INSERT INTO deuelo_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Und ihr sollt nichts davon übriglassen bis an den Morgen; und was davon bis an den Morgen übrigbleibt, sollt ihr mit Feuer verbrennen. ");
INSERT INTO deuelo_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Und also sollt ihr es essen: Eure Lenden gegürtet, eure Schuhe an euren Füßen und euren Stab in eurer Hand; und ihr sollt es essen in Eile. Es ist das Passah Jehovas. ");
INSERT INTO deuelo_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Und ich werde in dieser Nacht durch das Land Ägypten gehen und alle Erstgeburt im Lande Ägypten schlagen vom Menschen bis zum Vieh, und ich werde Gericht üben an allen Göttern Ägyptens, ich, Jehova. ");
INSERT INTO deuelo_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Und das Blut soll euch zum Zeichen sein an den Häusern, worin ihr seid; und sehe ich das Blut, so werde ich an euch vorübergehen; und es wird keine Plage zum Verderben unter euch sein, wenn ich das Land Ägypten schlage. ");
INSERT INTO deuelo_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Und dieser Tag soll euch zum Gedächtnis sein, und ihr sollt ihn feiern als Fest dem Jehova; als ewige Satzung bei euren Geschlechtern sollt ihr ihn feiern. ");
INSERT INTO deuelo_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Sieben Tage sollt ihr Ungesäuertes essen; ja, am ersten Tage sollt ihr den Sauerteig aus euren Häusern wegtun; denn jeder, der Gesäuertes isset, von dem ersten Tage bis zu dem siebten Tage, selbige Seele soll ausgerottet werden aus Israel. ");
INSERT INTO deuelo_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Und am ersten Tage soll euch eine heilige Versammlung und am siebten Tage eine heilige Versammlung sein; keinerlei Arbeit soll an ihnen getan werden; nur was von jeder Seele gegessen wird, das allein soll von euch bereitet werden. ");
INSERT INTO deuelo_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Und so beobachtet das Fest der ungesäuerten Brote; denn an diesem selbigen Tage habe ich eure Heere aus dem Lande Ägypten herausgeführt. Und ihr sollt diesen Tag beobachten bei euren Geschlechtern als ewige Satzung. ");
INSERT INTO deuelo_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Im ersten Monat, am vierzehnten Tage des Monats, am Abend, sollt ihr Ungesäuertes essen bis zu dem einundzwanzigsten Tage des Monats, am Abend. ");
INSERT INTO deuelo_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Sieben Tage soll kein Sauerteig in euren Häusern gefunden werden; denn jeder, der Gesäuertes isset, selbige Seele soll aus der Gemeinde Israel ausgerottet werden, er sei Fremdling oder Eingeborener des Landes. ");
INSERT INTO deuelo_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Nichts Gesäuertes sollt ihr essen; in allen euren Wohnungen sollt ihr Ungesäuertes essen. ");
INSERT INTO deuelo_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Und Mose rief alle Ältesten Israels und sprach zu ihnen: Greifet und nehmet euch Kleinvieh nach euren Familien und schlachtet das Passah; ");
INSERT INTO deuelo_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","und nehmet einen Büschel Ysop und tauchet ihn in das Blut, das in dem Becken ist, und streichet von dem Blute, das in dem Becken ist, an die Oberschwelle und an die beiden Pfosten; ihr aber, keiner von euch soll zur Türe seines Hauses hinausgehen bis an den Morgen. ");
INSERT INTO deuelo_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Und Jehova wird hindurchgehen, die Ägypter zu schlagen; und sieht er das Blut an der Oberschwelle und an den beiden Pfosten, so wird Jehova an der Tür vorübergehen und wird dem Verderber nicht erlauben, in eure Häuser zu kommen, um zu schlagen. ");
INSERT INTO deuelo_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Und ihr sollt dieses beobachten als eine Satzung für dich und deine Kinder ewiglich. ");
INSERT INTO deuelo_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Und es soll geschehen, wenn ihr in das Land kommet, das Jehova euch geben wird, so wie er geredet hat, so sollt ihr diesen Dienst beobachten. ");
INSERT INTO deuelo_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Und es soll geschehen, wenn eure Kinder zu euch sagen werden: Was soll euch dieser Dienst? ");
INSERT INTO deuelo_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","so sollt ihr sagen: Es ist ein Passahopfer dem Jehova, der an den Häusern der Kinder Israel in Ägypten vorüberging, als er die Ägypter schlug und unsere Häuser rettete. Und das Volk neigte sich und betete an. ");
INSERT INTO deuelo_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Und die Kinder Israel gingen hin und taten es; so wie Jehova Mose und Aaron geboten hatte, also taten sie. ");
INSERT INTO deuelo_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Und es geschah um Mitternacht, da schlug Jehova alle Erstgeburt im Lande Ägypten, von dem Erstgeborenen des Pharao, der auf seinem Throne saß, bis zum Erstgeborenen des Gefangenen, der im Kerker war, und alle Erstgeburt des Viehs. ");
INSERT INTO deuelo_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Und der Pharao stand in der Nacht auf, er und alle seine Knechte und alle Ägypter, und es entstand ein großes Geschrei in Ägypten; denn es war kein Haus, worin nicht ein Toter war. ");
INSERT INTO deuelo_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Und er rief Mose und Aaron in der Nacht und sprach: Machet euch auf, ziehet weg aus der Mitte meines Volkes, sowohl ihr als auch die Kinder Israel, und gehet hin, dienet Jehova, wie ihr geredet habt; ");
INSERT INTO deuelo_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","auch euer Kleinvieh und eure Rinder nehmet mit, so wie ihr geredet habt, und gehet hin und segnet mich auch! ");
INSERT INTO deuelo_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Und die Ägypter drängten das Volk, sie eilends aus dem Lande ziehen zu lassen; denn sie sagten: Wir alle sind des Todes! ");
INSERT INTO deuelo_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Und das Volk trug seinen Teig, ehe er gesäuert war, ihre Backschüsseln in ihre Kleider gebunden, auf ihren Schultern. ");
INSERT INTO deuelo_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Und die Kinder Israel taten nach dem Worte Moses und forderten von den Ägyptern silberne Geräte und goldene Geräte und Kleider. ");
INSERT INTO deuelo_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Und Jehova gab dem Volke Gnade in den Augen der Ägypter, und sie gaben ihnen das Geforderte; und sie beraubten die Ägypter. ");
INSERT INTO deuelo_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Und die Kinder Israel brachen auf von Raemses nach Sukkoth, bei sechshunderttausend Mann zu Fuß, die Männer ohne die Kinder. ");
INSERT INTO deuelo_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Und auch viel Mischvolk zog mit ihnen herauf, und Kleinvieh und Rinder, sehr viel Vieh. ");
INSERT INTO deuelo_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Und sie backten den Teig, den sie aus Ägypten gebracht hatten, zu ungesäuerten Kuchen; denn er war nicht gesäuert, weil sie aus Ägypten getrieben worden waren und nicht hatten verziehen können; und sie hatten auch keine Zehrung für sich bereitet. ");
INSERT INTO deuelo_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Und die Wohnzeit der Kinder Israel, die sie in Ägypten zugebracht haben, ist vierhundertdreißig Jahre. ");
INSERT INTO deuelo_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Und es geschah am Ende der vierhundertdreißig Jahre, und es geschah an diesem selbigen Tage, daß alle Heere Jehovas aus dem Lande Ägypten auszogen. ");
INSERT INTO deuelo_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Dies ist eine Nacht, die dem Jehova zu beobachten ist, weil er sie aus dem Lande Ägypten herausführte; diese selbige Nacht gehört dem Jehova, sie ist zu beobachten von allen Kindern Israel bei ihren Geschlechtern. ");
INSERT INTO deuelo_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Und Jehova redete zu Mose und Aaron: Dies ist die Satzung des Passah: Kein Fremdling soll davon essen; ");
INSERT INTO deuelo_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","jedes Mannes Knecht aber, ein für Geld Erkaufter, wenn du ihn beschneidest, dann darf er davon essen. ");
INSERT INTO deuelo_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Ein Beisaß und ein Mietling soll nicht davon essen. ");
INSERT INTO deuelo_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","In einem Hause soll es gegessen werden; du sollst nichts von dem Fleische aus dem Hause hinausbringen, und ihr sollt kein Bein an ihm zerbrechen. ");
INSERT INTO deuelo_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Die ganze Gemeinde Israel soll es feiern. ");
INSERT INTO deuelo_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Und wenn ein Fremdling bei dir weilt und das Passah dem Jehova feiern will, so werde alles Männliche bei ihm beschnitten, und dann komme er herzu, es zu feiern; und er soll sein wie ein Eingeborener des Landes. Aber kein Unbeschnittener soll davon essen. ");
INSERT INTO deuelo_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Ein Gesetz soll sein für den Eingeborenen und für den Fremdling, der in eurer Mitte weilt. ");
INSERT INTO deuelo_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Und alle Kinder Israel taten, wie Jehova Mose und Aaron geboten hatte; also taten sie. ");
INSERT INTO deuelo_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Und es geschah an diesem selbigen Tage, da führte Jehova die Kinder Israel aus dem Lande Ägypten heraus nach ihren Heeren. ");
INSERT INTO deuelo_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","Heilige mir alles Erstgeborene, was irgend die Mutter bricht unter den Kindern Israel, an Menschen und an Vieh; es ist mein. - ");
INSERT INTO deuelo_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Und Mose sprach zu dem Volke: Gedenket dieses Tages, an welchem ihr aus Ägypten gezogen seid, aus dem Hause der Knechtschaft; denn mit starker Hand hat Jehova euch von hier herausgeführt; und es soll nichts Gesäuertes gegessen werden. ");
INSERT INTO deuelo_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Heute ziehet ihr aus, im Monat Abib. ");
INSERT INTO deuelo_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Und es soll geschehen, wenn Jehova dich bringt in das Land der Kanaaniter und der Hethiter und der Amoriter und der Hewiter und der Jebusiter, das er deinen Vätern geschworen hat, dir zu geben, ein Land, das von Milch und Honig fließt, so sollst du diesen Dienst in diesem Monat halten. ");
INSERT INTO deuelo_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Sieben Tage sollst du Ungesäuertes essen, und am siebten Tage ist ein Fest dem Jehova. ");
INSERT INTO deuelo_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Die sieben Tage soll Ungesäuertes gegessen werden; und nicht soll Gesäuertes bei dir gesehen werden, noch soll Sauerteig bei dir gesehen werden in allen deinen Grenzen. ");
INSERT INTO deuelo_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Und du sollst deinem Sohne an selbigem Tage kundtun und sprechen: Es ist um deswillen, was Jehova mir getan hat, als ich aus Ägypten zog. ");
INSERT INTO deuelo_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Und es sei dir zu einem Zeichen an deiner Hand und zu einem Denkzeichen zwischen deinen Augen, damit das Gesetz Jehovas in deinem Munde sei; denn mit starker Hand hat Jehova dich aus Ägypten herausgeführt. ");
INSERT INTO deuelo_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Und du sollst diese Satzung beobachten zu ihrer bestimmten Zeit, von Jahr zu Jahr. ");
INSERT INTO deuelo_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Und es soll geschehen, wenn Jehova dich in das Land der Kanaaniter bringt, wie er dir und deinen Vätern geschworen hat, und es dir gibt, ");
INSERT INTO deuelo_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","so sollst du Jehova alles darbringen, was die Mutter bricht; und alles zuerst Geworfene vom Vieh, das dir zuteil wird, die Männlichen gehören Jehova. ");
INSERT INTO deuelo_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Und jedes Erstgeborene des Esels sollst du mit einem Lamme lösen, und wenn du es nicht lösest, so brich ihm das Genick; und jedes Erstgeborene des Menschen unter deinen Söhnen sollst du lösen. ");
INSERT INTO deuelo_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Und es soll geschehen, wenn dein Sohn dich künftig fragt und spricht: Was ist das? so sollst du zu ihm sagen: Mit starker Hand hat Jehova uns aus Ägypten herausgeführt, aus dem Hause der Knechtschaft. ");
INSERT INTO deuelo_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Und es geschah, da der Pharao sich hartnäckig weigerte, uns ziehen zu lassen, tötete Jehova alle Erstgeburt im Lande Ägypten, vom Erstgeborenen des Menschen bis zum Erstgeborenen des Viehes; darum opfere ich dem Jehova alles, was die Mutter bricht, die Männlichen, und jeden Erstgeborenen meiner Söhne löse ich. ");
INSERT INTO deuelo_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Und es sei zu einem Zeichen an deiner Hand und zu Stirnbändern zwischen deinen Augen; denn mit starker Hand hat Jehova uns aus Ägypten herausgeführt. ");
INSERT INTO deuelo_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Und es geschah, als der Pharao das Volk ziehen ließ, da führte Gott sie nicht den Weg durch das Land der Philister, wiewohl er nahe war; denn Gott sprach: Damit es das Volk nicht gereue, wenn sie den Streit sehen, und sie nicht nach Ägypten zurückkehren. ");
INSERT INTO deuelo_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Und Gott führte das Volk herum, den Weg der Wüste des Schilfmeeres; und die Kinder Israel zogen gerüstet aus dem Lande Ägypten herauf. ");
INSERT INTO deuelo_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Und Mose nahm die Gebeine Josephs mit sich; denn er hatte die Kinder Israel ausdrücklich schwören lassen und gesagt: Gott wird euch gewißlich heimsuchen; so führet denn meine Gebeine mit euch von hier hinauf! ");
INSERT INTO deuelo_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Und sie brachen auf von Sukkoth und lagerten sich in Etham, am Rande der Wüste. ");
INSERT INTO deuelo_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Und Jehova zog vor ihnen her, des Tages in einer Wolkensäule, um sie auf dem Wege zu leiten, und des Nachts in einer Feuersäule, um ihnen zu leuchten, damit sie Tag und Nacht ziehen könnten. ");
INSERT INTO deuelo_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Des Tages wich nicht die Wolkensäule noch des Nachts die Feuersäule vor dem Volke. ");
INSERT INTO deuelo_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Sprich zu den Kindern Israel, daß sie umkehren und sich lagern vor Pi-Hachiroth, zwischen Migdol und dem Meere; vor Baal-Zephon, ihm gegenüber, sollt ihr euch am Meere lagern. ");
INSERT INTO deuelo_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Und der Pharao wird von den Kindern Israel sagen: Verwirrt irren sie im Lande umher, die Wüste hat sie umschlossen. ");
INSERT INTO deuelo_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Und ich will das Herz des Pharao verhärten, daß er ihnen nachjage; und ich will mich verherrlichen an dem Pharao und an seiner ganzen Heeresmacht, und die Ägypter sollen erkennen, daß ich Jehova bin. Und sie taten also. ");
INSERT INTO deuelo_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Und es wurde dem König von Ägypten berichtet, daß das Volk entflohen wäre; da verwandelte sich das Herz des Pharao und seiner Knechte gegen das Volk, und sie sprachen: Was haben wir da getan, daß wir Israel aus unserem Dienste haben ziehen lassen! ");
INSERT INTO deuelo_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Und er spannte seinen Wagen an und nahm sein Volk mit sich. ");
INSERT INTO deuelo_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Und er nahm sechshundert auserlesene Wagen und alle Wagen Ägyptens, und Wagenkämpfer auf jedem derselben. ");
INSERT INTO deuelo_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Und Jehova verhärtete das Herz des Pharao, des Königs von Ägypten, und er jagte den Kindern Israel nach; und die Kinder Israel zogen aus mit erhobener Hand. ");
INSERT INTO deuelo_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Und die Ägypter jagten ihnen nach, alle Rosse, Wagen des Pharao und seine Reiter und seine Heeresmacht, und erreichten sie, als sie sich am Meere gelagert hatten, bei Pi-Hachiroth, vor Baal-Zephon. ");
INSERT INTO deuelo_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Und als der Pharao nahte, da hoben die Kinder Israel ihre Augen auf, und siehe, die Ägypter zogen hinter ihnen her; und die Kinder Israel fürchteten sich sehr und schrieen zu Jehova. ");
INSERT INTO deuelo_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Und sie sprachen zu Mose: Hast du uns darum, weil in Ägypten keine Gräber waren, weggeholt, um in der Wüste zu sterben? Warum hast du uns das getan, daß du uns aus Ägypten herausgeführt hast? ");
INSERT INTO deuelo_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ist dies nicht das Wort, das wir in Ägypten zu dir geredet haben, indem wir sprachen: Laß ab von uns, daß wir den Ägyptern dienen? Denn besser wäre es uns, den Ägyptern zu dienen, als in der Wüste zu sterben. ");
INSERT INTO deuelo_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Und Mose sprach zu dem Volke: Fürchtet euch nicht! Stehet und sehet die Rettung Jehovas, die er euch heute schaffen wird; denn die Ägypter, die ihr heute sehet, die werdet ihr hinfort nicht mehr sehen ewiglich. ");
INSERT INTO deuelo_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Jehova wird für euch streiten, und ihr werdet stille sein. ");
INSERT INTO deuelo_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Und Jehova sprach zu Mose: Was schreiest du zu mir? Rede zu den Kindern Israel, daß sie aufbrechen. ");
INSERT INTO deuelo_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Und du, erhebe deinen Stab und strecke deine Hand aus über das Meer und spalte es, daß die Kinder Israel mitten in das Meer hineingehen auf dem Trockenen. ");
INSERT INTO deuelo_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Und ich, siehe, ich will das Herz der Ägypter verhärten, und sie werden hinter ihnen herkommen; und ich will mich verherrlichen an dem Pharao und an seiner ganzen Heeresmacht, an seinen Wagen und an seinen Reitern. ");
INSERT INTO deuelo_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Und die Ägypter sollen erkennen, daß ich Jehova bin, wenn ich mich verherrlicht habe an dem Pharao, an seinen Wagen und an seinen Reitern. ");
INSERT INTO deuelo_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Und der Engel Gottes, der vor dem Heere Israels herzog, brach auf und trat hinter sie; und die Wolkensäule brach auf von vorn und stellte sich hinter sie. ");
INSERT INTO deuelo_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Und sie kam zwischen das Heer der Ägypter und das Heer Israels, und sie wurde dort Wolke und Finsternis, und erleuchtete hier die Nacht; und so nahte jenes diesem nicht die ganze Nacht. ");
INSERT INTO deuelo_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Und Mose streckte seine Hand aus über das Meer, und Jehova trieb das Meer durch einen starken Ostwind hinweg, die ganze Nacht, und machte das Meer trocken, und die Wasser wurden gespalten. ");
INSERT INTO deuelo_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Und die Kinder Israel gingen mitten in das Meer hinein auf dem Trockenen, und die Wasser waren ihnen eine Mauer zur Rechten und zur Linken. ");
INSERT INTO deuelo_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Und die Ägypter jagten ihnen nach und kamen hinter ihnen her, alle Rosse des Pharao, seine Wagen und seine Reiter, mitten ins Meer. ");
INSERT INTO deuelo_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Und es geschah in der Morgenwache, da schaute Jehova in der Feuer-und Wolkensäule auf das Heer der Ägypter und verwirrte das Heer der Ägypter. ");
INSERT INTO deuelo_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Und er stieß die Räder von seinen Wagen und ließ es fahren mit Beschwerde. Und die Ägypter sprachen: Laßt uns vor Israel fliehen, denn Jehova streitet für sie wider die Ägypter! ");
INSERT INTO deuelo_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Und Jehova sprach zu Mose: Strecke deine Hand aus über das Meer, daß die Wasser über die Ägypter zurückkehren, über ihre Wagen und über ihre Reiter. ");
INSERT INTO deuelo_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Da streckte Mose seine Hand aus über das Meer, und das Meer kehrte beim Anbruch des Morgens zu seiner Strömung zurück; und die Ägypter flohen ihm entgegen; und Jehova stürzte die Ägypter mitten ins Meer. ");
INSERT INTO deuelo_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Und die Wasser kehrten zurück und bedeckten die Wagen und die Reiter der ganzen Heeresmacht des Pharao, die hinter ihnen her ins Meer gekommen waren; es blieb auch nicht einer von ihnen übrig. ");
INSERT INTO deuelo_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Und die Kinder Israel gingen auf dem Trockenen mitten durch das Meer, und die Wasser waren ihnen eine Mauer zur Rechten und zur Linken. ");
INSERT INTO deuelo_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","So rettete Jehova Israel an selbigem Tage aus der Hand der Ägypter, und Israel sah die Ägypter tot am Ufer des Meeres. ");
INSERT INTO deuelo_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Und Israel sah die große Macht, die Jehova an den Ägyptern betätigt hatte; und das Volk fürchtete Jehova, und sie glaubten an Jehova und an Mose, seinen Knecht. ");
INSERT INTO deuelo_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Damals sangen Mose und die Kinder Israel dieses Lied dem Jehova und sprachen also: Singen will ich Jehova, denn hoch erhaben ist er; das Roß und seinen Reiter hat er ins Meer gestürzt. ");
INSERT INTO deuelo_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Meine Stärke und mein Gesang ist Jah, denn er ist mir zur Rettung geworden; dieser ist mein Gott, und ich will ihn verherrlichen, meines Vaters Gott, und ich will ihn erheben. ");
INSERT INTO deuelo_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Jehova ist ein Kriegsmann, Jehova sein Name. ");
INSERT INTO deuelo_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Die Wagen des Pharao und seine Heeresmacht hat er ins Meer gestürzt, und die Auserlesenen seiner Wagenkämpfer sind versunken im Schilfmeer. ");
INSERT INTO deuelo_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Die Fluten bedeckten sie, sie sind hinuntergefahren in die Tiefen wie ein Stein. ");
INSERT INTO deuelo_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Deine Rechte, Jehova, ist herrlich in Macht; deine Rechte, Jehova, hat zerschmettert den Feind. ");
INSERT INTO deuelo_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Und in der Größe deiner Hoheit hast du niedergerissen, die sich wider dich erhoben; du ließest deine Zornglut los: sie hat sie verzehrt wie Stoppeln. ");
INSERT INTO deuelo_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Und durch den Hauch deiner Nase türmten sich die Wasser, es standen die Strömungen wie ein Damm, es gerannen die Fluten im Herzen des Meeres. ");
INSERT INTO deuelo_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Der Feind sprach: Ich will nachjagen, einholen, Beute teilen; meine Gier soll sich sättigen an ihnen; ich will mein Schwert ziehen, meine Hand soll sie vertilgen. ");
INSERT INTO deuelo_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Du hauchtest mit deinem Odem, das Meer bedeckte sie; sie sanken unter wie Blei in die gewaltigen Wasser. ");
INSERT INTO deuelo_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Wer ist dir gleich unter den Göttern, Jehova! Wer ist dir gleich, herrlich in Heiligkeit, furchtbar an Ruhm, Wunder tuend! ");
INSERT INTO deuelo_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Du strecktest deine Rechte aus, die Erde verschlang sie. ");
INSERT INTO deuelo_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Du hast durch deine Güte geleitet das Volk, das du erlöst, hast es durch deine Stärke geführt zu deiner heiligen Wohnung. ");
INSERT INTO deuelo_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Es hörten's die Völker, sie bebten; Angst ergriff die Bewohner Philistäas. ");
INSERT INTO deuelo_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Da wurden bestürzt die Fürsten Edoms; die Starken Moabs, sie ergriff Beben; es verzagten alle Bewohner Kanaans. ");
INSERT INTO deuelo_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Es überfiel sie Schrecken und Furcht; ob der Größe deines Armes verstummten sie gleich einem Stein, bis hindurchzog dein Volk, Jehova, bis hindurchzog das Volk, das du erworben hast. ");
INSERT INTO deuelo_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Du wirst sie bringen und pflanzen auf den Berg deines Erbteils, die Stätte, die du, Jehova, zu deiner Wohnung gemacht, das Heiligtum, Herr, das deine Hände bereitet haben. ");
INSERT INTO deuelo_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Jehova wird König sein immer und ewiglich! - ");
INSERT INTO deuelo_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Denn die Rosse des Pharao mit seinen Wagen und mit seinen Reitern sind ins Meer gekommen, und Jehova hat die Wasser des Meeres über sie zurückgeführt; und die Kinder Israel gingen auf dem Trockenen mitten durchs Meer. ");
INSERT INTO deuelo_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Und Mirjam, die Prophetin, Aarons Schwester, nahm das Tamburin in ihre Hand; und alle Weiber zogen aus, hinter ihr her, mit Tamburinen und in Reigen. ");
INSERT INTO deuelo_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Und Mirjam antwortete ihnen: Singet Jehova, denn hoch erhaben ist er; das Roß und seinen Reiter hat er ins Meer gestürzt! - ");
INSERT INTO deuelo_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Und Mose ließ Israel vom Schilfmeer aufbrechen, und sie zogen aus in die Wüste Sur; und sie wanderten drei Tage in der Wüste und fanden kein Wasser. ");
INSERT INTO deuelo_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Und sie kamen nach Mara; aber sie konnten das Wasser von Mara nicht trinken, denn es war bitter: darum gab man ihm den Namen Mara. ");
INSERT INTO deuelo_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Und das Volk murrte wider Mose und sprach: Was sollen wir trinken? ");
INSERT INTO deuelo_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Und er schrie zu Jehova, und Jehova wies ihm ein Holz; und er warf es in das Wasser, und das Wasser wurde süß. Dort stellte er ihm Satzung und Recht, und dort versuchte er es; ");
INSERT INTO deuelo_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","und er sprach: Wenn du fleißig auf die Stimme Jehovas, deines Gottes, hören wirst, und tun, was recht ist in seinen Augen, und horchen wirst auf seine Gebote und beobachten alle seine Satzungen, so werde ich keine der Krankheiten auf dich legen, die ich auf Ägypten gelegt habe; denn ich bin Jehova, der dich heilt. ");
INSERT INTO deuelo_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Und sie kamen nach Elim, und daselbst waren zwölf Wasserquellen und siebzig Palmbäume; und sie lagerten sich daselbst an den Wassern. ");
INSERT INTO deuelo_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Und sie brachen auf von Elim, und die ganze Gemeinde der Kinder Israel kam in die Wüste Sin, die zwischen Elim und Sinai ist, am fünfzehnten Tage des zweiten Monats nach ihrem Auszuge aus dem Lande Ägypten. ");
INSERT INTO deuelo_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Und die ganze Gemeinde der Kinder Israel murrte wieder Mose und wider Aaron in der Wüste. ");
INSERT INTO deuelo_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Und die Kinder Israel sprachen zu ihnen: Wären wir doch im Lande Ägypten durch die Hand Jehovas gestorben, als wir bei den Fleischtöpfen saßen, als wir Brot aßen bis zur Sättigung! Denn ihr habt uns in diese Wüste herausgeführt, um diese ganze Versammlung Hungers sterben zu lassen. ");
INSERT INTO deuelo_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Da sprach Jehova zu Mose: Siehe, ich werde euch Brot vom Himmel regnen lassen; und das Volk soll hinausgehen und den täglichen Bedarf an seinem Tage sammeln, damit ich es versuche, ob es wandeln wird in meinem Gesetz oder nicht. ");
INSERT INTO deuelo_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Und es soll geschehen, am sechsten Tage, da sollen sie zubereiten, was sie einbringen, und es wird das Doppelte von dem sein, was sie tagtäglich sammeln werden. ");
INSERT INTO deuelo_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Und Mose und Aaron sprachen zu allen Kindern Israel: Am Abend, da werdet ihr erkennen, daß Jehova euch aus dem Lande Ägypten herausgeführt hat; ");
INSERT INTO deuelo_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","und am Morgen, da werdet ihr die Herrlichkeit Jehovas sehen, indem er euer Murren wider Jehova gehört hat; denn was sind wir, daß ihr wider uns murret! ");
INSERT INTO deuelo_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Und Mose sprach: Dadurch werdet ihr's erkennen, daß Jehova euch am Abend Fleisch zu essen geben wird und am Morgen Brot bis zur Sättigung, indem Jehova euer Murren gehört hat, womit ihr wider ihn murret. Denn was sind wir? Nicht wider uns ist euer Murren, sondern wider Jehova. ");
INSERT INTO deuelo_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Und Mose sprach zu Aaron: Sprich zu der ganzen Gemeinde der Kinder Israel: Nahet herzu vor Jehova, denn er hat euer Murren gehört. ");
INSERT INTO deuelo_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Und es geschah, als Aaron zu der ganzen Gemeinde der Kinder Israel redete, da wandten sie sich gegen die Wüste; und siehe, die Herrlichkeit Jehovas erschien in der Wolke. ");
INSERT INTO deuelo_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Ich habe das Murren der Kinder Israel gehört; rede zu ihnen und sprich: Zwischen den zwei Abenden werdet ihr Fleisch essen, und am Morgen werdet ihr von Brot satt werden; und ihr werdet erkennen, daß ich Jehova bin, euer Gott. ");
INSERT INTO deuelo_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Und es geschah am Abend, da kamen Wachteln herauf und bedeckten das Lager; und am Morgen war eine Tauschicht rings um das Lager. ");
INSERT INTO deuelo_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Und die Tauschicht stieg auf, und siehe, da lag's auf der Fläche der Wüste fein, körnig, fein, wie der Reif auf der Erde. ");
INSERT INTO deuelo_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Und die Kinder Israel sahen es und sprachen einer zum anderen: Was ist das? Denn sie wußten nicht, was es war. Und Mose sprach zu ihnen: Dies ist das Brot, das Jehova euch zur Nahrung gegeben hat. ");
INSERT INTO deuelo_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Dies ist das Wort, das Jehova geboten hat: Sammelt davon, ein jeder nach dem Maße seines Essens; einen Ghomer für den Kopf, nach der Zahl eurer Seelen, sollt ihr nehmen, ein jeder für die, welche in seinem Zelte sind. ");
INSERT INTO deuelo_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Und die Kinder Israel taten also und sammelten, der viel und der wenig. ");
INSERT INTO deuelo_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Und sie maßen mit dem Ghomer: da hatte, wer viel gesammelt hatte, nicht übrig, und wer wenig gesammelt hatte, dem mangelte nicht; sie hatten gesammelt, ein jeder nach dem Maße seines Essens. ");
INSERT INTO deuelo_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Und Mose sprach zu ihnen: Niemand lasse davon übrig bis an den Morgen. ");
INSERT INTO deuelo_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Aber sie hörten nicht auf Mose, und etliche ließen davon übrig bis an den Morgen; da wuchsen Würmer darin, und es ward stinkend. Und Mose wurde zornig über sie. ");
INSERT INTO deuelo_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Und sie sammelten es Morgen für Morgen, ein jeder nach dem Maße seines Essens; und wenn die Sonne heiß wurde, so zerschmolz es. ");
INSERT INTO deuelo_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Und es geschah am sechsten Tage, da sammelten sie das Doppelte an Brot, zwei Ghomer für einen; und alle Fürsten der Gemeinde kamen und berichteten es Mose. ");
INSERT INTO deuelo_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Und er sprach zu ihnen: Dies ist es, was Jehova geredet hat: Morgen ist Ruhe, ein heiliger Sabbath dem Jehova; was ihr backen wollt, backet, und was ihr kochen wollt, kochet. Alles aber, was übrigbleibt, leget euch hin zur Aufbewahrung bis an den Morgen. ");
INSERT INTO deuelo_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Und sie legten es hin bis an den Morgen, so wie Mose geboten hatte; und es stank nicht, und es war kein Wurm darin. ");
INSERT INTO deuelo_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Da sprach Mose: Esset es heute, denn heute ist Sabbath dem Jehova; ihr werdet es heute auf dem Felde nicht finden. ");
INSERT INTO deuelo_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Sechs Tage sollt ihr es sammeln; aber am siebten Tage ist Sabbath, an dem wird es nicht sein. ");
INSERT INTO deuelo_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Und es geschah am siebten Tage, daß etliche von dem Volke hinausgingen, um zu sammeln, und sie fanden nichts. ");
INSERT INTO deuelo_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Und Jehova sprach zu Mose: Bis wann weigert ihr euch, meine Gebote und meine Gesetze zu beobachten? ");
INSERT INTO deuelo_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Sehet, weil Jehova euch den Sabbath gegeben hat, darum gibt er euch am sechsten Tage Brot für zwei Tage; bleibet ein jeder an seiner Stelle, niemand gehe am siebten Tage von seinem Orte heraus. ");
INSERT INTO deuelo_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Und das Volk ruhte am siebten Tage. ");
INSERT INTO deuelo_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Und das Haus Israel gab ihm den Namen Man; und es war wie Koriandersamen, weiß, und sein Geschmack wie Kuchen mit Honig. ");
INSERT INTO deuelo_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Und Mose sprach: Dies ist das Wort, das Jehova geboten hat: Ein Ghomer voll davon sei zur Aufbewahrung für eure Geschlechter, damit sie das Brot sehen, womit ich euch in der Wüste gespeist habe, als ich euch aus dem Lande Ägypten herausführte. ");
INSERT INTO deuelo_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Und Mose sprach zu Aaron: Nimm einen Krug und tue Man darein, einen Ghomer voll, und lege es vor Jehova nieder zur Aufbewahrung für eure Geschlechter. ");
INSERT INTO deuelo_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","So wie Jehova Mose geboten hatte, legte Aaron es vor das Zeugnis nieder, zur Aufbewahrung. - ");
INSERT INTO deuelo_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Und die Kinder Israel aßen das Man vierzig Jahre, bis sie in ein bewohntes Land kamen; sie aßen das Man, bis sie an die Grenze des Landes Kanaan kamen. ");
INSERT INTO deuelo_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Der Ghomer aber ist ein Zehntel vom Epha. ");
INSERT INTO deuelo_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Und die ganze Gemeinde der Kinder Israel brach auf aus der Wüste Sin, nach ihren Zügen, nach dem Befehl Jehovas; und sie lagerten sich zu Rephidim; und da war kein Wasser zum Trinken für das Volk. ");
INSERT INTO deuelo_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Und das Volk haderte mit Mose, und sie sprachen: Gebet uns Wasser, daß wir trinken! Und Mose sprach zu ihnen: Was hadert ihr mit mir? Was versuchet ihr Jehova? ");
INSERT INTO deuelo_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Und das Volk dürstete daselbst nach Wasser, und das Volk murrte wider Mose und sprach: Warum doch hast du uns aus Ägypten heraufgeführt, um mich und meine Kinder und mein Vieh vor Durst sterben zu lassen? ");
INSERT INTO deuelo_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Da schrie Mose zu Jehova und sprach: Was soll ich mit diesem Volke tun? Noch ein wenig, und sie steinigen mich. ");
INSERT INTO deuelo_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Und Jehova sprach zu Mose: Gehe hin vor dem Volke, und nimm mit dir von den Ältesten Israels; und deinen Stab, womit du den Strom geschlagen hast, nimm in deine Hand und gehe hin. ");
INSERT INTO deuelo_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Siehe, ich will daselbst vor dir stehen auf dem Felsen am Horeb; und du sollst auf den Felsen schlagen, und es wird Wasser aus demselben herauskommen, daß das Volk trinke. Und Mose tat also vor den Augen der Ältesten Israels. ");
INSERT INTO deuelo_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Und er gab dem Orte den Namen Massa und Meriba, wegen des Haderns der Kinder Israel und weil sie Jehova versucht hatten, indem sie sagten: Ist Jehova in unserer Mitte oder nicht? ");
INSERT INTO deuelo_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Und es kam Amalek und stritt wider Israel in Rephidim. ");
INSERT INTO deuelo_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Und Mose sprach zu Josua: Erwähle uns Männer und ziehe aus, streite wider Amalek; morgen will ich auf dem Gipfel des Hügels stehen, mit dem Stabe Gottes in meiner Hand. ");
INSERT INTO deuelo_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Und Josua tat, wie Mose ihm gesagt hatte, um wider Amalek zu streiten; und Mose, Aaron und Hur stiegen auf den Gipfel des Hügels. ");
INSERT INTO deuelo_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Und es geschah, wenn Mose seine Hand erhob, so hatte Israel die Oberhand, und wenn er seine Hand ruhen ließ, so hatte Amalek die Oberhand. ");
INSERT INTO deuelo_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Und die Hände Moses wurden schwer. Da nahmen sie einen Stein und legten denselben unter ihn, und er setzte sich darauf; und Aaron und Hur unterstützten seine Hände, hier einer und dort einer; und so waren seine Hände fest, bis die Sonne unterging. ");
INSERT INTO deuelo_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Und Josua streckte Amalek und sein Volk nieder mit der Schärfe des Schwertes. - ");
INSERT INTO deuelo_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Und Jehova sprach zu Mose: Schreibe dieses zum Gedächtnis in ein Buch, und lege in die Ohren Josuas, daß ich das Gedächtnis Amaleks gänzlich unter dem Himmel austilgen werde. ");
INSERT INTO deuelo_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Und Mose baute einen Altar und gab ihm den Namen: Jehova, mein Panier! ");
INSERT INTO deuelo_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Und er sprach: Denn die Hand ist am Throne Jahs: Krieg hat Jehova wider Amalek von Geschlecht zu Geschlecht! ");
INSERT INTO deuelo_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Und Jethro, der Priester von Midian, der Schwiegervater Moses, hörte alles, was Gott an Mose und an Israel, seinem Volke, getan, daß Jehova Israel aus Ägypten herausgeführt hatte. ");
INSERT INTO deuelo_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Und Jethro, der Schwiegervater Moses, nahm Zippora, das Weib Moses, nach ihrer Heimsendung, ");
INSERT INTO deuelo_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","und ihre zwei Söhne, von denen der Name des einen Gersom war, denn er sprach: Ein Fremdling bin ich geworden in fremdem Lande, ");
INSERT INTO deuelo_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","und der Name des anderen Elieser: denn der Gott meines Vaters ist meine Hilfe gewesen und hat mich errettet vom Schwerte des Pharao; ");
INSERT INTO deuelo_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","und Jethro, der Schwiegervater Moses, und seine Söhne und sein Weib kamen zu Mose in die Wüste, wo er gelagert war am Berge Gottes. ");
INSERT INTO deuelo_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Und er ließ Mose sagen: Ich, dein Schwiegervater Jethro, bin zu dir gekommen, und dein Weib und ihre beiden Söhne mit ihr. ");
INSERT INTO deuelo_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Da ging Mose hinaus, seinem Schwiegervater entgegen, und beugte sich nieder und küßte ihn; und sie fragten einer den anderen nach ihrem Wohlergehen und gingen ins Zelt. ");
INSERT INTO deuelo_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Und Mose erzählte seinem Schwiegervater alles, was Jehova an dem Pharao und an den Ägyptern getan hatte um Israels willen, all die Mühsal, die sie auf dem Wege getroffen, und daß Jehova sie errettet habe. ");
INSERT INTO deuelo_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Und Jethro freute sich über all das Gute, das Jehova an Israel getan, daß er es errettet hatte aus der Hand der Ägypter. ");
INSERT INTO deuelo_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Und Jethro sprach: Gepriesen sei Jehova, der euch errettet hat aus der Hand der Ägypter und aus der Hand des Pharao, der das Volk errettet hat unter der Hand der Ägypter hinweg! ");
INSERT INTO deuelo_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Nun weiß ich, daß Jehova größer ist als alle Götter; denn in der Sache, worin sie in Übermut handelten, war er über ihnen. ");
INSERT INTO deuelo_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Und Jethro, der Schwiegervater Moses, nahm ein Brandopfer und Schlachtopfer für Gott; und Aaron und alle Ältesten Israels kamen, um mit dem Schwiegervater Moses zu essen vor dem Angesicht Gottes. ");
INSERT INTO deuelo_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Und es geschah am anderen Tage, da setzte sich Mose, um das Volk zu richten; und das Volk stand bei Mose vom Morgen bis zum Abend. ");
INSERT INTO deuelo_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Und der Schwiegervater Moses sah alles, was er mit dem Volke tat, und er sprach: Was ist das, das du mit dem Volke tust? Warum sitzest du allein, und alles Volk steht bei dir vom Morgen bis zum Abend? ");
INSERT INTO deuelo_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Und Mose sprach zu seinem Schwiegervater: Weil das Volk zu mir kommt, um Gott zu befragen. ");
INSERT INTO deuelo_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Wenn sie eine Sache haben, so kommt es zu mir, und ich richte zwischen dem einen und dem anderen und tue ihnen die Satzungen Gottes und seine Gesetze kund. ");
INSERT INTO deuelo_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Da sprach der Schwiegervater Moses zu ihm: Die Sache ist nicht gut, die du tust; ");
INSERT INTO deuelo_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","du wirst ganz erschlaffen, sowohl du, als auch dieses Volk, das bei dir ist; denn die Sache ist zu schwer für dich, du kannst sie nicht allein ausrichten. ");
INSERT INTO deuelo_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Höre nun auf meine Stimme, ich will dir raten, und Gott wird mit dir sein: Sei du für das Volk vor Gott, und bringe du die Sachen zu Gott; ");
INSERT INTO deuelo_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","und erläutere ihnen die Satzungen und die Gesetze, und tue ihnen kund den Weg, auf dem sie wandeln, und das Werk, das sie tun sollen. ");
INSERT INTO deuelo_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Du aber ersieh dir aus dem ganzen Volke tüchtige, gottesfürchtige Männer, Männer der Wahrheit, die den ungerechten Gewinn hassen, und setze sie über sie: Oberste über tausend, Oberste über hundert, Oberste über fünfzig und Oberste über zehn, ");
INSERT INTO deuelo_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","daß sie das Volk richten zu aller Zeit; und es geschehe, daß sie jede große Sache vor dich bringen und daß sie jede kleine Sache selbst richten; so erleichtere es dir, und sie mögen mit dir tragen. ");
INSERT INTO deuelo_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Wenn du dieses tust und Gott es dir gebietet, so wirst du bestehen können, und auch dieses ganze Volk wird in Frieden an seinen Ort kommen. ");
INSERT INTO deuelo_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Und Mose hörte auf die Stimme seines Schwiegervaters und tat alles, was er gesagt hatte. ");
INSERT INTO deuelo_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Und Mose wählte tüchtige Männer aus ganz Israel und setzte sie zu Häuptern über das Volk: Oberste über tausend, Oberste über hundert, Oberste über fünfzig und Oberste über zehn. ");
INSERT INTO deuelo_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Und sie richteten das Volk zu aller Zeit: die schwierige Sache brachten sie vor Mose, und jede kleine Sache richteten sie selbst. ");
INSERT INTO deuelo_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Und Mose ließ seinen Schwiegervater ziehen, und er zog hin in sein Land. ");
INSERT INTO deuelo_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Im dritten Monat nach dem Auszuge der Kinder Israel aus dem Lande Ägypten, an diesem selbigen Tage kamen sie in die Wüste Sinai: ");
INSERT INTO deuelo_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Sie brachen auf von Rephidim und kamen in die Wüste Sinai und lagerten sich in der Wüste; und Israel lagerte sich daselbst dem Berge gegenüber. ");
INSERT INTO deuelo_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Und Mose stieg hinauf zu Gott; und Jehova rief ihm vom Berge zu und sprach: So sollst du zum Hause Jakob sprechen und den Kindern Israel kundtun: ");
INSERT INTO deuelo_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Ihr habt gesehen, was ich an den Ägyptern getan habe, wie ich euch getragen auf Adlers Flügeln und euch zu mir gebracht habe. ");
INSERT INTO deuelo_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Und nun, wenn ihr fleißig auf meine Stimme hören und meinen Bund halten werdet, so sollt ihr mein Eigentum sein aus allen Völkern; denn die ganze Erde ist mein; ");
INSERT INTO deuelo_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","und ihr sollt mir ein Königreich von Priestern und eine heilige Nation sein. Das sind die Worte, die du zu den Kindern Israel reden sollst. ");
INSERT INTO deuelo_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Und Mose kam und rief die Ältesten des Volkes und legte ihnen alle diese Worte vor, die Jehova ihm geboten hatte. ");
INSERT INTO deuelo_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Da antwortete das ganze Volk insgesamt und sprach: Alles, was Jehova geredet hat, wollen wir tun! Und Mose brachte die Worte des Volkes zu Jehova zurück. ");
INSERT INTO deuelo_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Und Jehova sprach zu Mose: Siehe, ich werde zu dir kommen im Dunkel des Gewölks, damit das Volk höre, wenn ich mit dir rede, und dir auch glaube ewiglich. Und Mose tat Jehova die Worte des Volkes kund. ");
INSERT INTO deuelo_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Und Jehova sprach zu Mose: Gehe zum Volke und heilige sie heute und morgen, und daß sie ihre Kleider waschen; ");
INSERT INTO deuelo_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Und sie seien bereit auf den dritten Tag; denn am dritten Tage wird Jehova vor den Augen des ganzen Volkes auf den Berg Sinai herabsteigen. ");
INSERT INTO deuelo_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Und mache eine Grenze um das Volk ringsum und sprich: Hütet euch, auf den Berg zu steigen und sein Äußerstes anzurühren; alles, was den Berg anrührt, soll gewißlich getötet werden- ");
INSERT INTO deuelo_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","keine Hand soll ihn anrühren, denn es soll gewißlich gesteinigt oder erschossen werden; ob Vieh oder Mensch, es darf nicht leben. Wenn das Lärmhorn anhaltend ertönt, sollen sie gegen den Berg hinansteigen. ");
INSERT INTO deuelo_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Und Mose stieg vom Berge zu dem Volke hinab; und er heiligte das Volk, und sie wuschen ihre Kleider. ");
INSERT INTO deuelo_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Und er sprach zu dem Volke: Seid bereit auf den dritten Tag; nahet nicht zum Weibe. ");
INSERT INTO deuelo_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Und es geschah am dritten Tage, als es Morgen war, da waren Donner und Blitze und eine schwere Wolke auf dem Berge und ein sehr starker Posaunenschall; und das ganze Volk zitterte, das im Lager war. ");
INSERT INTO deuelo_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Und Mose führte das Volk aus dem Lager hinaus, Gott entgegen; und sie stellten sich auf am Fuße des Berges. ");
INSERT INTO deuelo_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Und der ganze Berg Sinai rauchte, darum, daß Jehova auf ihn herabstieg im Feuer; und sein Rauch stieg auf, wie der Rauch eines Schmelzofens, und der ganze Berg bebte sehr. ");
INSERT INTO deuelo_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Und der Posaunenschall wurde fort und fort stärker; Mose redete, und Gott antwortete ihm mit einer Stimme. ");
INSERT INTO deuelo_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Und Jehova stieg auf den Berg Sinai herab, auf den Gipfel des Berges; und Jehova rief Mose auf den Gipfel des Berges, und Mose stieg hinauf. ");
INSERT INTO deuelo_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Und Jehova sprach zu Mose: Steige hinab, warne das Volk, daß sie nicht zu Jehova durchbrechen, um zu schauen, und viele von ihnen fallen. ");
INSERT INTO deuelo_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Und auch die Priester, die zu Jehova nahen, sollen sich heiligen, daß Jehova nicht in sie einbreche. ");
INSERT INTO deuelo_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Und Mose sprach zu Jehova: Das Volk wird den Berg Sinai nicht ersteigen können; denn du hast uns ja gewarnt und gesagt: Mache eine Grenze um den Berg und heilige ihn. ");
INSERT INTO deuelo_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Und Jehova sprach zu ihm: Gehe, steige hinab, und du sollst heraufkommen, du und Aaron mit dir; aber die Priester und das Volk sollen nicht durchbrechen, um zu Jehova hinaufzusteigen, daß er nicht in sie einbreche. ");
INSERT INTO deuelo_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Da stieg Mose zu dem Volke hinab und sagte es ihnen. ");
INSERT INTO deuelo_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Und Gott redete alle diese Worte und sprach: ");
INSERT INTO deuelo_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Ich bin Jehova, dein Gott, der ich dich herausgeführt habe aus dem Lande Ägypten, aus dem Hause der Knechtschaft. ");
INSERT INTO deuelo_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Du sollst keine anderen Götter haben neben mir. - ");
INSERT INTO deuelo_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Du sollst dir kein geschnitztes Bild machen, noch irgend ein Gleichnis dessen, was oben im Himmel und was unten auf der Erde und was in den Wassern unter der Erde ist. ");
INSERT INTO deuelo_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Du sollst dich nicht vor ihnen niederbeugen und ihnen nicht dienen; denn ich, Jehova, dein Gott, bin ein eifernder Gott, der die Ungerechtigkeit der Väter heimsucht an den Kindern, am dritten und am vierten Gliede derer, die mich hassen; ");
INSERT INTO deuelo_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","und der Güte erweist, auf Tausende hin, an denen, die mich lieben und meine Gebote beobachten. - ");
INSERT INTO deuelo_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Du sollst den Namen Jehovas, deines Gottes, nicht zu Eitlem aussprechen; denn Jehova wird den nicht für schuldlos halten, der seinen Namen zu Eitlem ausspricht. - ");
INSERT INTO deuelo_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Gedenke des Sabbathtages, ihn zu heiligen. ");
INSERT INTO deuelo_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Sechs Tage sollst du arbeiten und all dein Werk tun; ");
INSERT INTO deuelo_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","aber der siebte Tag ist Sabbath dem Jehova, deinem Gott: du sollst keinerlei Werk tun, du und dein Sohn und deine Tochter, dein Knecht und deine Magd, und dein Vieh, und dein Fremdling, der in deinen Toren ist. ");
INSERT INTO deuelo_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Denn in sechs Tagen hat Jehova den Himmel und die Erde gemacht, das Meer und alles, was in ihnen ist, und er ruhte am siebten Tage; darum segnete Jehova den Sabbathtag und heiligte ihn. - ");
INSERT INTO deuelo_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Ehre deinen Vater und deine Mutter, auf daß deine Tage verlängert werden in dem Lande, das Jehova, dein Gott, dir gibt. - ");
INSERT INTO deuelo_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Du sollst nicht töten. - ");
INSERT INTO deuelo_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Du sollst nicht ehebrechen. - ");
INSERT INTO deuelo_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Du sollst nicht stehlen. - ");
INSERT INTO deuelo_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Du sollst kein falsches Zeugnis ablegen wider deinen Nächsten. - ");
INSERT INTO deuelo_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Du sollst nicht begehren deines Nächsten Haus; du sollst nicht begehren deines Nächsten Weib, noch seinen Knecht, noch seine Magd, noch sein Rind, noch seinen Esel, noch alles, was dein Nächster hat. ");
INSERT INTO deuelo_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Und das ganze Volk gewahrte die Donner und die Flammen und den Posaunenschall und den rauchenden Berg. Und als das Volk es gewahrte, zitterten sie und standen von ferne; ");
INSERT INTO deuelo_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","und sie sprachen zu Mose: Rede du mit uns, und wir wollen hören; aber Gott möge nicht mit uns reden, daß wir nicht sterben! ");
INSERT INTO deuelo_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Da sprach Mose zu dem Volke: Fürchtet euch nicht; denn um euch zu versuchen, ist Gott gekommen, und damit seine Furcht vor eurem Angesicht sei, daß ihr nicht sündiget. ");
INSERT INTO deuelo_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Und das Volk stand von ferne; und Mose nahte sich zum Dunkel, wo Gott war. ");
INSERT INTO deuelo_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Und Jehova sprach zu Mose: Also sollst du zu den Kindern Israel sprechen: Ihr habt gesehen, daß ich vom Himmel her mit euch geredet habe. ");
INSERT INTO deuelo_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Ihr sollt nichts neben mir machen, Götter von Silber und Götter von Gold sollt ihr euch nicht machen. ");
INSERT INTO deuelo_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Einen Altar von Erde sollst du mir machen und darauf opfern deine Brandopfer und deine Friedensopfer, dein Kleinvieh und deine Rinder; an jedem Orte, wo ich meines Namens werde gedenken lassen, werde ich zu dir kommen und dich segnen. ");
INSERT INTO deuelo_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Und wenn du mir einen Altar von Steinen machst, so sollst du ihn nicht von behauenen Steinen bauen; denn hast du deinen Meißel darüber geschwungen, so hast du ihn entweiht. ");
INSERT INTO deuelo_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Und du sollst nicht auf Stufen zu meinem Altar hinaufsteigen, damit nicht deine Blöße an ihm aufgedeckt werde. ");
INSERT INTO deuelo_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Und dies sind die Rechte, die du ihnen vorlegen sollst: ");
INSERT INTO deuelo_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","So du einen hebräischen Knecht kaufst, soll er sechs Jahre dienen, und im siebten soll er frei ausgehen, umsonst. ");
INSERT INTO deuelo_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Wenn er allein gekommen ist, soll er allein ausgehen; wenn er eines Weibes Mann war, soll sein Weib mit ihm ausgehen. ");
INSERT INTO deuelo_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Wenn sein Herr ihm ein Weib gegeben und sie ihm Söhne oder Töchter geboren hat, so sollen das Weib und ihre Kinder ihrem Herrn gehören, und er soll allein ausgehen. ");
INSERT INTO deuelo_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Wenn aber der Knecht etwa sagt: Ich liebe meinen Herrn, mein Weib und meine Kinder, ich will nicht frei ausgehen, ");
INSERT INTO deuelo_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","so soll sein Herr ihn vor die Richter bringen und ihn an die Tür oder an den Pfosten stellen, und sein Herr soll ihm das Ohr mit einer Pfrieme durchbohren; und er soll ihm dienen auf ewig. ");
INSERT INTO deuelo_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Und so jemand seine Tochter zur Magd verkauft, soll sie nicht ausgehen, wie die Knechte ausgehen. ");
INSERT INTO deuelo_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Wenn sie in den Augen ihres Herrn mißfällig ist, die er für sich bestimmt hatte, so lasse er sie loskaufen: er soll nicht Macht haben, sie an ein fremdes Volk zu verkaufen, weil er treulos an ihr gehandelt hat. ");
INSERT INTO deuelo_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Und wenn er sie seinem Sohne bestimmt, so soll er ihr tun nach dem Rechte der Töchter. ");
INSERT INTO deuelo_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Wenn er sich eine andere nimmt, so soll er ihre Nahrung, ihre Kleidung und ihre Beiwohnung nicht vermindern. ");
INSERT INTO deuelo_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Und wenn er ihr diese drei Dinge nicht tut, so soll sie umsonst ausgehen, ohne Geld. ");
INSERT INTO deuelo_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Wer einen Menschen schlägt, daß er stirbt, soll gewißlich getötet werden; ");
INSERT INTO deuelo_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","hat er ihm aber nicht nachgestellt, und Gott hat es seiner Hand begegnen lassen, so werde ich dir einen Ort bestimmen, wohin er fliehen soll. ");
INSERT INTO deuelo_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Und so jemand wider seinen Nächsten vermessen handelt, daß er ihn umbringt mit Hinterlist, von meinem Altar sollst du ihn wegnehmen, daß er sterbe. ");
INSERT INTO deuelo_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Und wer seinen Vater oder seine Mutter schlägt, soll gewißlich getötet werden. ");
INSERT INTO deuelo_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Und wer einen Menschen stiehlt und ihn verkauft, oder er wird in seiner Hand gefunden, der soll gewißlich getötet werden. ");
INSERT INTO deuelo_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Und wer seinem Vater oder seiner Mutter flucht, soll gewißlich getötet werden. ");
INSERT INTO deuelo_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Und wenn Männer hadern, und einer schlägt den anderen mit einem Steine oder mit der Faust, und er stirbt nicht, sondern wird bettlägerig: ");
INSERT INTO deuelo_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","wenn er aufsteht und draußen an seinem Stabe wandelt, so soll der Schläger schuldlos sein; nur soll er sein Versäumnis erstatten und ihn völlig heilen lassen. ");
INSERT INTO deuelo_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Und so jemand seinen Knecht oder seine Magd mit dem Stocke schlägt, daß er unter seiner Hand stirbt, so soll er gewißlich gerächt werden: ");
INSERT INTO deuelo_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","nur wenn er einen Tag oder zwei Tage leben bleibt, soll er nicht gerächt werden, denn er ist sein Geld. ");
INSERT INTO deuelo_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Und wenn Männer sich streiten und stoßen ein schwangeres Weib, daß ihr die Frucht abgeht, und es geschieht kein Schaden, so soll er gewißlich an Geld gestraft werden, jenachdem der Mann des Weibes ihm auferlegen wird, und er soll es geben durch die Richter. ");
INSERT INTO deuelo_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Wenn aber Schaden geschieht, so sollst du geben Leben um Leben, ");
INSERT INTO deuelo_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Auge um Auge, Zahn um Zahn, Hand um Hand, Fuß um Fuß, ");
INSERT INTO deuelo_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Brandmal um Brandmal, Wunde um Wunde, Strieme um Strieme. ");
INSERT INTO deuelo_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Und so jemand in das Auge seines Knechtes oder in das Auge seiner Magd schlägt und verdirbt es, so soll er ihn frei entlassen um sein Auge. ");
INSERT INTO deuelo_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Und wenn er den Zahn seines Knechtes oder den Zahn seiner Magd ausschlägt, so soll er ihn frei entlassen um seinen Zahn. ");
INSERT INTO deuelo_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Und wenn ein Ochse einen Mann oder ein Weib stößt, daß sie sterben, so soll der Ochse gewißlich gesteinigt, und sein Fleisch soll nicht gegessen werden; aber der Besitzer des Ochsen soll schuldlos sein. ");
INSERT INTO deuelo_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Wenn aber der Ochse vordem stößig war, und sein Besitzer ist gewarnt worden, und er hat ihn nicht verwahrt, und er tötet einen Mann oder ein Weib, so soll der Ochse gesteinigt, und auch sein Besitzer soll getötet werden. ");
INSERT INTO deuelo_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Wenn ihm eine Sühne auferlegt wird, so soll er das Lösegeld seines Lebens geben nach allem, was ihm auferlegt wird. ");
INSERT INTO deuelo_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Mag er einen Sohn stoßen oder eine Tochter stoßen, so soll ihm nach diesem Rechte getan werden. ");
INSERT INTO deuelo_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Wenn der Ochse einen Knecht stößt oder eine Magd, so soll sein Besitzer ihrem Herrn dreißig Silbersekel geben, und der Ochse soll gesteinigt werden. ");
INSERT INTO deuelo_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Und wenn jemand eine Grube öffnet, oder wenn jemand eine Grube gräbt und sie nicht zudeckt, und es fällt ein Ochse oder ein Esel hinein, ");
INSERT INTO deuelo_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","so soll es der Besitzer der Grube erstatten: Geld soll er dem Besitzer desselben zahlen, und das tote Tier soll ihm gehören. ");
INSERT INTO deuelo_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Und wenn jemandes Ochse den Ochsen seines Nächsten stößt, daß er stirbt, so sollen sie den lebenden Ochsen verkaufen und den Erlös teilen, und auch den toten sollen sie teilen. ");
INSERT INTO deuelo_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Ist es aber bekannt gewesen, daß der Ochse vordem stößig war, und sein Besitzer hat ihn nicht verwahrt, so soll er gewißlich Ochsen für Ochsen erstatten, und der tote soll ihm gehören. ");
INSERT INTO deuelo_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Wenn jemand einen Ochsen stiehlt oder ein Stück Kleinvieh, und schlachtet es oder verkauft es, so soll er fünf Ochsen erstatten für den Ochsen und vier Stück Kleinvieh für das Stück. - ");
INSERT INTO deuelo_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Wenn der Dieb beim Einbruch betroffen wird, und er wird geschlagen, daß er stirbt, so ist es ihm keine Blutschuld; ");
INSERT INTO deuelo_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","wenn die Sonne über ihm aufgegangen ist, so ist es ihm eine Blutschuld. Er soll gewißlich erstatten; wenn er nichts hat, soll er für seinen Diebstahl verkauft werden. ");
INSERT INTO deuelo_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Wenn das Gestohlene lebend in seiner Hand gefunden wird, es sei ein Ochse oder ein Esel oder ein Stück Kleinvieh, soll er das Doppelte erstatten. ");
INSERT INTO deuelo_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","So jemand ein Feld oder einen Weingarten abweiden läßt und er sein Vieh hintreibt, und es weidet auf dem Felde eines anderen, so soll er es vom Besten seines Feldes und vom Besten seines Weingartens erstatten. ");
INSERT INTO deuelo_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Wenn ein Feuer ausbricht und Dornen erreicht, und es wird ein Garbenhaufen verzehrt, oder das stehende Getreide oder das Feld, so soll der gewißlich erstatten, der den Brand angezündet hat. ");
INSERT INTO deuelo_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","So jemand seinem Nächsten Geld oder Geräte in Verwahrung gibt, und es wird aus dem Hause dieses Mannes gestohlen, wenn der Dieb gefunden wird, so soll er das Doppelte erstatten; ");
INSERT INTO deuelo_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","wenn der Dieb nicht gefunden wird, so soll der Besitzer des Hauses vor die Richter treten, ob er nicht seine Hand nach der Habe seines Nächsten ausgestreckt hat. - ");
INSERT INTO deuelo_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Bei jedem Falle von Veruntreuung betreffs eines Ochsen, eines Esels, eines Stückes Kleinvieh, eines Kleides, betreffs alles Verlorenen, wovon man sagt: “das ist es”, soll beider Sache vor die Richter kommen; wen die Richter schuldig sprechen, der soll seinem Nächsten das Doppelte erstatten. - ");
INSERT INTO deuelo_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","So jemand seinem Nächsten einen Esel oder einen Ochsen oder ein Stück Kleinvieh oder irgend ein Vieh in Verwahrung gibt, und es stirbt oder wird beschädigt oder weggeführt, und niemand sieht es, ");
INSERT INTO deuelo_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","so soll der Eid Jehovas zwischen ihnen beiden sein, ob er nicht seine Hand nach der Habe seines Nächsten ausgestreckt hat; und sein Besitzer soll es annehmen, und jener soll nichts erstatten. ");
INSERT INTO deuelo_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Und wenn es ihm wirklich gestohlen worden ist, so soll er es seinem Besitzer erstatten. ");
INSERT INTO deuelo_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Wenn es aber zerrissen worden ist, so soll er es als Zeugnis bringen; er soll das Zerrissene nicht erstatten. ");
INSERT INTO deuelo_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Und wenn jemand von seinem Nächsten ein Stück Vieh entlehnt, und es wird beschädigt oder stirbt, war sein Besitzer nicht dabei, so soll er es gewißlich erstatten; ");
INSERT INTO deuelo_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","wenn sein Besitzer dabei war, soll er es nicht erstatten. Wenn es gemietet war, so ist es für seine Miete gekommen. ");
INSERT INTO deuelo_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Und so jemand eine Jungfrau betört, die nicht verlobt ist, und liegt bei ihr, so soll er sie gewißlich durch eine Heiratsgabe sich zum Weibe erkaufen. ");
INSERT INTO deuelo_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Wenn ihr Vater sich durchaus weigert, sie ihm zu geben, so soll er Geld darwägen nach der Heiratsgabe der Jungfrauen. - ");
INSERT INTO deuelo_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Eine Zauberin sollst du nicht leben lassen. - ");
INSERT INTO deuelo_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Jeder, der bei einem Vieh liegt, soll gewißlich getötet werden. - ");
INSERT INTO deuelo_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Wer den Göttern opfert außer Jehova allein, soll verbannt werden. ");
INSERT INTO deuelo_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Und den Fremdling sollst du nicht bedrängen und ihn nicht bedrücken, denn Fremdlinge seid ihr im Lande Ägypten gewesen. ");
INSERT INTO deuelo_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Keine Witwe und Waise sollt ihr bedrücken. ");
INSERT INTO deuelo_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Wenn du sie irgend bedrückst, so werde ich, wenn sie irgendwie zu mir schreit, ihr Geschrei gewißlich erhören; ");
INSERT INTO deuelo_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","und mein Zorn wird entbrennen, und ich werde euch mit dem Schwerte töten, und eure Weiber sollen Witwen und eure Kinder Waisen werden. - ");
INSERT INTO deuelo_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Wenn du meinem Volke, dem Armen bei dir, Geld leihst, so sollst du ihm nicht sein wie ein Gläubiger; ihr sollt ihm keinen Zins auferlegen. - ");
INSERT INTO deuelo_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Wenn du irgend deines Nächsten Mantel zum Pfande nimmst, so sollst du ihm denselben zurückgeben, ehe die Sonne untergeht; ");
INSERT INTO deuelo_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","denn es ist seine einzige Decke, sein Kleid für seine Haut; worin soll er liegen? Und es wird geschehen, wenn er zu mir schreit, so werde ich ihn erhören, denn ich bin gnädig. - ");
INSERT INTO deuelo_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Die Richter sollst du nicht lästern, und einem Fürsten deines Volkes sollst du nicht fluchen. ");
INSERT INTO deuelo_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Mit der Fülle deines Getreides und dem Ausfluß deiner Kelter sollst du nicht zögern. Den erstgeborenen deiner Söhne sollst du mir geben. ");
INSERT INTO deuelo_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Desgleichen sollst du mit deinem Ochsen tun und mit deinem Kleinvieh; sieben Tage soll es bei seiner Mutter sein, am achten Tage sollst du es mir geben. - ");
INSERT INTO deuelo_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Und heilige Männer sollt ihr mir sein, und Fleisch, das auf dem Felde zerrissen worden ist, sollt ihr nicht essen; ihr sollt es den Hunden vorwerfen. ");
INSERT INTO deuelo_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Du sollst kein falsches Gerücht aufnehmen; du sollst deine Hand nicht dem Gesetzlosen reichen, um ein ungerechter Zeuge zu sein. ");
INSERT INTO deuelo_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Du sollst der Menge nicht folgen zum Übeltun; und du sollst bei einem Rechtsstreit nicht antworten, indem du dich der Menge nach neigest, das Recht zu beugen. ");
INSERT INTO deuelo_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Und den Armen sollst du in seinem Rechtsstreit nicht begünstigen. - ");
INSERT INTO deuelo_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Wenn du den Ochsen deines Feindes oder seinen Esel umherirrend antriffst, sollst du ihn demselben jedenfalls zurückbringen. ");
INSERT INTO deuelo_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Wenn du den Esel deines Hassers unter seiner Last liegen siehst, so hüte dich, ihn demselben zu überlassen; du sollst ihn jedenfalls mit ihm losmachen. - ");
INSERT INTO deuelo_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Du sollst das Recht deines Armen nicht beugen in seinem Rechtsstreit. ");
INSERT INTO deuelo_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Von der Sache der Lüge sollst du dich fernhalten; und den Unschuldigen und Gerechten sollst du nicht töten, denn ich werde den Gesetzlosen nicht rechtfertigen. ");
INSERT INTO deuelo_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Und kein Geschenk sollst du nehmen; denn das Geschenk blendet die Sehenden und verkehrt die Worte der Gerechten. ");
INSERT INTO deuelo_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Und den Fremdling sollst du nicht bedrücken; ihr selbst wisset ja, wie es dem Fremdling zu Mute ist, denn Fremdlinge seid ihr im Lande Ägypten gewesen. - ");
INSERT INTO deuelo_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Und sechs Jahre sollst du dein Land besäen und seinen Ertrag einsammeln; ");
INSERT INTO deuelo_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","aber im siebten sollst du es ruhen und liegen lassen, daß die Armen deines Volkes davon essen; und was sie übriglassen, soll das Getier des Feldes fressen. Desgleichen sollst du mit deinem Weinberge tun und mit deinem Olivenbaum. - ");
INSERT INTO deuelo_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Sechs Tage sollst du deine Arbeiten tun; aber am siebten Tage sollst du ruhen, damit dein Ochse und dein Esel raste und der Sohn deiner Magd und der Fremdling sich erhole. ");
INSERT INTO deuelo_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Und auf alles, was ich euch gesagt habe, sollt ihr acht haben; und den Namen anderer Götter sollt ihr nicht erwähnen, er soll in deinem Munde nicht gehört werden. ");
INSERT INTO deuelo_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Dreimal im Jahre sollst du mir ein Fest feiern. ");
INSERT INTO deuelo_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Das Fest der ungesäuerten Brote sollst du beobachten: sieben Tage sollst du Ungesäuertes essen, so wie ich dir geboten habe, zur bestimmten Zeit im Monat Abib, denn in demselben bist du aus Ägypten gezogen; und man soll nicht leer vor meinem Angesicht erscheinen; ");
INSERT INTO deuelo_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","und das Fest der Ernte, der Erstlinge deiner Arbeit, dessen, was du auf dem Felde säen wirst; und das Fest der Einsammlung im Ausgang des Jahres, wenn du deine Arbeit vom Felde einsammelst. ");
INSERT INTO deuelo_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Dreimal im Jahre sollen alle deine Männlichen vor dem Angesicht des Herrn Jehova erscheinen. - ");
INSERT INTO deuelo_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Du sollst nicht das Blut meines Schlachtopfers zu Gesäuertem opfern; und nicht soll das Fett meines Festes über Nacht bleiben bis an den Morgen. ");
INSERT INTO deuelo_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Das erste der Erstlinge deines Landes sollst du in das Haus Jehovas, deines Gottes, bringen. Du sollst ein Böcklein nicht kochen in der Milch seiner Mutter. ");
INSERT INTO deuelo_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Siehe, ich sende einen Engel vor dir her, um dich auf dem Wege zu bewahren und dich an den Ort zu bringen, den ich bereitet habe. ");
INSERT INTO deuelo_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Hüte dich vor ihm und höre auf seine Stimme und reize ihn nicht; denn er wird eure Übertretung nicht vergeben, denn mein Name ist in ihm. ");
INSERT INTO deuelo_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Doch wenn du fleißig auf seine Stimme hörst und alles tust, was ich sagen werde, so werde ich deine Feinde befeinden und deine Dränger bedrängen. ");
INSERT INTO deuelo_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Denn mein Engel wird vor dir hergehen und wird dich bringen zu den Amoritern und den Hethitern und den Perisitern und den Kanaanitern, den Hewitern und den Jebusitern; und ich werde sie vertilgen. ");
INSERT INTO deuelo_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Du sollst dich vor ihren Göttern nicht niederbeugen und ihnen nicht dienen, und du sollst nicht tun nach ihren Taten; sondern du sollst sie ganz und gar niederreißen und ihre Bildsäulen gänzlich zerbrechen. ");
INSERT INTO deuelo_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Und ihr sollt Jehova, eurem Gott, dienen: so wird er dein Brot und dein Wasser segnen, und ich werde Krankheit aus deiner Mitte entfernen. ");
INSERT INTO deuelo_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Keine Fehlgebärende und Unfruchtbare wird in deinem Lande sein; die Zahl deiner Tage werde ich voll machen. ");
INSERT INTO deuelo_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Meinen Schrecken werde ich vor dir hersenden und alle Völker verwirren, zu denen du kommst, und dir zukehren den Rücken aller deiner Feinde. ");
INSERT INTO deuelo_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Und ich werde die Hornisse vor dir hersenden, daß sie vor dir vertreibe die Hewiter, die Kanaaniter und die Hethiter. ");
INSERT INTO deuelo_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Nicht in einem Jahre werde ich sie vor dir vertreiben, damit nicht das Land eine Wüste werde und das Getier des Feldes sich wider dich mehre. ");
INSERT INTO deuelo_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Nach und nach werde ich sie vor dir vertreiben, bis du fruchtbar bist und das Land besitzest. ");
INSERT INTO deuelo_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Und ich werde deine Grenze setzen vom Schilfmeer bis an das Meer der Philister, und von der Wüste bis an den Strom; denn ich werde die Bewohner des Landes in deine Hand geben, daß du sie vor dir vertreibest. ");
INSERT INTO deuelo_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Du sollst mit ihnen und mit ihren Göttern keinen Bund machen. ");
INSERT INTO deuelo_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Sie sollen nicht in deinem Lande wohnen, damit sie dich nicht wider mich sündigen machen; denn du würdest ihren Göttern dienen, denn es würde dir zum Fallstrick sein. ");
INSERT INTO deuelo_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Und er sprach zu Mose: Steige zu Jehova herauf, du und Aaron, Nadab und Abihu und siebzig von den Ältesten Israels, und betet an von ferne. ");
INSERT INTO deuelo_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Und Mose allein nahe sich zu Jehova; sie aber sollen sich nicht nahen, und das Volk soll nicht mit ihm heraufsteigen. ");
INSERT INTO deuelo_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Und Mose kam und erzählte dem Volke alle Worte Jehovas und alle Rechte; und das ganze Volk antwortete mit einer Stimme und sprach: Alle Worte, die Jehova geredet hat, wollen wir tun. ");
INSERT INTO deuelo_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Und Mose schrieb alle Worte Jehovas nieder. Und er machte sich des Morgens früh auf und baute einen Altar unten am Berge und zwölf Denksteine nach den zwölf Stämmen Israels. ");
INSERT INTO deuelo_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Und er sandte Jünglinge der Kinder Israel hin, und sie opferten Brandopfer und schlachteten Friedensopfer von Farren dem Jehova. ");
INSERT INTO deuelo_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Und Mose nahm die Hälfte des Blutes und tat es in Schalen, und die Hälfte des Blutes sprengte er an den Altar. ");
INSERT INTO deuelo_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Und er nahm das Buch des Bundes und las es vor den Ohren des Volkes; und sie sprachen: Alles, was Jehova geredet hat, wollen wir tun und gehorchen. ");
INSERT INTO deuelo_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Und Mose nahm das Blut und sprengte es auf das Volk und sprach: Siehe, das Blut des Bundes, den Jehova mit euch gemacht hat über alle diese Worte. ");
INSERT INTO deuelo_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Und es stiegen hinauf Mose und Aaron, Nadab und Abihu, und siebzig von den Ältesten Israels; ");
INSERT INTO deuelo_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","und sie sahen den Gott Israels; und unter seinen Füßen war es wie ein Werk von Saphirplatten und wie der Himmel selbst an Klarheit. ");
INSERT INTO deuelo_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Und er streckte seine Hand nicht aus gegen die Edlen der Kinder Israel; und sie schauten Gott und aßen und tranken. ");
INSERT INTO deuelo_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Und Jehova sprach zu Mose: Steige zu mir herauf auf den Berg und sei daselbst; und ich werde dir die steinernen Tafeln geben und das Gesetz und das Gebot, das ich geschrieben habe, um sie zu belehren. ");
INSERT INTO deuelo_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Und Mose machte sich auf mit Josua, seinem Diener, und Mose stieg auf den Berg Gottes. ");
INSERT INTO deuelo_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Und er sprach zu den Ältesten: Wartet hier auf uns, bis wir zu euch zurückkehren; und siehe, Aaron und Hur sind bei euch: wer irgend eine Sache hat, trete vor sie. ");
INSERT INTO deuelo_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Und Mose stieg auf den Berg, und die Wolke bedeckte den Berg. ");
INSERT INTO deuelo_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Und die Herrlichkeit Jehovas ruhte auf dem Berge Sinai, und die Wolke bedeckte ihn sechs Tage; und am siebten Tage rief er Mose aus der Mitte der Wolke. ");
INSERT INTO deuelo_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Und das Ansehen der Herrlichkeit Jehovas war wie ein verzehrendes Feuer auf dem Gipfel des Berges vor den Augen der Kinder Israel. ");
INSERT INTO deuelo_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Und Mose ging mitten in die Wolke hinein und stieg auf den Berg; und Mose war auf dem Berge vierzig Tage und vierzig Nächte. ");
INSERT INTO deuelo_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Rede zu den Kindern Israel, daß sie mir ein Hebopfer bringen; von einem jeden, der willigen Herzens ist, sollt ihr mein Hebopfer nehmen. ");
INSERT INTO deuelo_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Und dies ist das Hebopfer, das ihr von ihnen nehmen sollt: Gold und Silber und Erz, ");
INSERT INTO deuelo_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","und blauer und roter Purpur und Karmesin und Byssus und Ziegenhaar, ");
INSERT INTO deuelo_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","und rotgefärbte Widderfelle und Dachsfelle und Akazienholz; ");
INSERT INTO deuelo_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","Öl zum Licht, Gewürze zum Salböl und zum wohlriechenden Räucherwerk; ");
INSERT INTO deuelo_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Onyxsteine und Steine zum Einsetzen für das Ephod und für das Brustschild. ");
INSERT INTO deuelo_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Und sie sollen mir ein Heiligtum machen, daß ich in ihrer Mitte wohne. ");
INSERT INTO deuelo_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Nach allem, was ich dir zeige, das Muster der Wohnung und das Muster aller ihrer Geräte, also sollt ihr es machen. ");
INSERT INTO deuelo_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Und sie sollen eine Lade von Akazienholz machen: zwei und eine halbe Elle ihre Länge, und eine und eine halbe Elle ihre Breite, und eine und eine halbe Elle ihre Höhe. ");
INSERT INTO deuelo_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Und du sollst sie überziehen mit reinem Golde: inwendig und auswendig sollst du sie überziehen; und mache einen goldenen Kranz daran ringsum. ");
INSERT INTO deuelo_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Und gieße für dieselbe vier Ringe von Gold und setze sie an ihre vier Ecken, und zwar zwei Ringe an ihrer einen Seite und zwei Ringe an ihrer anderen Seite. ");
INSERT INTO deuelo_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Und mache Stangen von Akazienholz und überziehe sie mit Gold. ");
INSERT INTO deuelo_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Und bringe die Stangen in die Ringe an den Seiten der Lade, um die Lade mit denselben zu tragen. ");
INSERT INTO deuelo_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Die Stangen sollen in den Ringen der Lade sein, sie sollen nicht daraus entfernt werden. ");
INSERT INTO deuelo_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Und lege in die Lade das Zeugnis, das ich dir geben werde. ");
INSERT INTO deuelo_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Und mache einen Deckel von reinem Golde: zwei und eine halbe Elle seine Länge, und eine und eine halbe Elle seine Breite. ");
INSERT INTO deuelo_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Und mache zwei Cherubim von Gold; in getriebener Arbeit sollst du sie machen an beiden Enden des Deckels; ");
INSERT INTO deuelo_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","und mache einen Cherub an dem Ende der einen Seite und einen Cherub an dem Ende der anderen Seite; aus dem Deckel sollt ihr die Cherubim machen an seinen beiden Enden. ");
INSERT INTO deuelo_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Und die Cherubim sollen die Flügel nach oben ausbreiten, den Deckel mit ihren Flügeln überdeckend, und ihre Angesichter einander gegenüber; die Angesichter der Cherubim sollen gegen den Deckel gerichtet sein. ");
INSERT INTO deuelo_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Und lege den Deckel oben über die Lade; und in die Lade sollst du das Zeugnis legen, das ich dir geben werde. ");
INSERT INTO deuelo_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Und daselbst werde ich mit dir zusammenkommen und von dem Deckel herab, zwischen den zwei Cherubim hervor, die auf der Lade des Zeugnisses sind, alles zu dir reden, was ich dir an die Kinder Israel gebieten werde. ");
INSERT INTO deuelo_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Und du sollst einen Tisch von Akazienholz machen: zwei Ellen seine Länge, und eine Elle seine Breite, und eine und eine halbe Elle seine Höhe. ");
INSERT INTO deuelo_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Und überziehe ihn mit reinem Golde und mache ihm einen Kranz von Gold ringsum. ");
INSERT INTO deuelo_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Und mache ihm eine Leiste, eine Hand breit, ringsum, und mache einen Kranz von Gold an seine Leiste ringsum. ");
INSERT INTO deuelo_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Und mache ihm vier Ringe von Gold und setze die Ringe an die vier Ecken, die an seinen vier Füßen sind. ");
INSERT INTO deuelo_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Dicht bei der Leiste sollen die Ringe sein, zu Behältern für die Stangen, um den Tisch zu tragen. ");
INSERT INTO deuelo_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Und mache die Stangen von Akazienholz und überziehe sie mit Gold, und der Tisch soll daran getragen werden. ");
INSERT INTO deuelo_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Und mache seine Schüsseln und seine Schalen und seine Kannen und seine Spendschalen, mit welchen das Trankopfer ausgegossen wird; von reinem Golde sollst du sie machen. ");
INSERT INTO deuelo_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Und auf den Tisch sollst du Schaubrote legen vor meinem Angesicht beständig. ");
INSERT INTO deuelo_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Und du sollst einen Leuchter von reinem Golde machen; in getriebener Arbeit soll der Leuchter gemacht werden, sein Fuß und sein Schaft; seine Kelche, seine Knäufe und seine Blumen sollen aus ihm sein. ");
INSERT INTO deuelo_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Und sechs Arme sollen von seinen Seiten ausgehen: Drei Arme des Leuchters aus seiner einen Seite und drei Arme des Leuchters aus seiner anderen Seite. ");
INSERT INTO deuelo_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Drei Kelche, mandelblütenförmig, an dem einen Arme: Knauf und Blume; und drei Kelche, mandelblütenförmig, an dem anderen Arme: Knauf und Blume; also für die sechs Arme, die von dem Leuchter ausgehen. ");
INSERT INTO deuelo_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Und an dem Leuchter vier Kelche, mandelblütenförmig: seine Knäufe und seine Blumen; ");
INSERT INTO deuelo_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","und zwar ein Knauf unter zwei Armen aus ihm, und wieder ein Knauf unter zwei Armen aus ihm, und wieder ein Knauf unter zwei Armen aus ihm, für die sechs Arme, die von dem Leuchter ausgehen. ");
INSERT INTO deuelo_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Ihre Knäufe und ihre Arme sollen aus ihm sein; der ganze Leuchter eine getriebene Arbeit, von reinem Golde. ");
INSERT INTO deuelo_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Und du sollst seine sieben Lampen machen; und man soll seine Lampen anzünden, so daß sie gerade vor ihm hin scheinen; ");
INSERT INTO deuelo_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","und seine Lichtschneuzen und seine Löschnäpfe von reinem Golde. ");
INSERT INTO deuelo_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Aus einem Talent reinen Goldes soll man ihn machen mit allen diesen Geräten. ");
INSERT INTO deuelo_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Und sieh zu, daß du sie nach ihrem Muster machest, welches dir auf dem Berge gezeigt worden ist. ");
INSERT INTO deuelo_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Und die Wohnung sollst du aus zehn Teppichen machen; von gezwirntem Byssus und blauem und rotem Purpur und Karmesin, mit Cherubim in Kunstweberarbeit sollst du sie machen. ");
INSERT INTO deuelo_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Die Länge eines Teppichs achtundzwanzig Ellen, und vier Ellen die Breite eines Teppichs: ein Maß für alle Teppiche. ");
INSERT INTO deuelo_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Fünf Teppiche sollen zusammengefügt werden, einer an den anderen, und wieder fünf Teppiche zusammengefügt, einer an den anderen. ");
INSERT INTO deuelo_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Und mache Schleifen von blauem Purpur an den Saum des einen Teppichs am Ende, bei der Zusammenfügung; und also sollst du es machen an dem Saume des äußersten Teppichs bei der anderen Zusammenfügung. ");
INSERT INTO deuelo_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Fünfzig Schleifen sollst du an den einen Teppich machen, und fünfzig Schleifen sollst du an das Ende des Teppichs machen, der bei der anderen Zusammenfügung ist, die Schleifen eine der anderen gegenüber. ");
INSERT INTO deuelo_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Und mache fünfzig Klammern von Gold, und füge die Teppiche mit den Klammern zusammen, einen an den anderen, so daß die Wohnung ein Ganzes sei. ");
INSERT INTO deuelo_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Und du sollst Teppiche von Ziegenhaar machen zum Zelte über die Wohnung; elf solcher Teppiche sollst du machen. ");
INSERT INTO deuelo_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Die Länge eines Teppichs dreißig Ellen, und vier Ellen die Breite eines Teppichs: ein Maß für die elf Teppiche. ");
INSERT INTO deuelo_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Und füge fünf Teppiche besonders zusammen und sechs Teppiche besonders, und den sechsten Teppich an der Vorderseite des Zeltes lege doppelt. ");
INSERT INTO deuelo_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Und mache fünfzig Schleifen an den Saum des einen Teppichs, des äußersten, bei der Zusammenfügung, und fünfzig Schleifen an den Saum des Teppichs der anderen Zusammenfügung. ");
INSERT INTO deuelo_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Und mache fünfzig Klammern von Erz, und bringe die Klammern in die Schleifen und füge das Zelt zusammen, so daß es ein Ganzes sei. ");
INSERT INTO deuelo_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Und das Überhangende, das übrig ist an den Teppichen des Zeltes, der halbe Teppich, der übrig ist, soll über die Hinterseite der Wohnung hangen. ");
INSERT INTO deuelo_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Und die Elle diesseits und die Elle jenseits, von dem, was übrig ist an der Länge der Teppiche des Zeltes, soll über die Seiten der Wohnung hangen, diesseits und jenseits, sie zu bedecken. ");
INSERT INTO deuelo_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Und mache für das Zelt eine Decke von rotgefärbten Widderfellen und eine Decke von Dachsfellen oben darüber. ");
INSERT INTO deuelo_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Und die Bretter zu der Wohnung sollst du von Akazienholz machen, aufrechtstehend; ");
INSERT INTO deuelo_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","zehn Ellen die Länge eines Brettes, und eine und eine halbe Elle die Breite eines Brettes; ");
INSERT INTO deuelo_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","zwei Zapfen an einem Brette, einer dem anderen gegenüber eingefügt: also sollst du es machen an allen Brettern der Wohnung. ");
INSERT INTO deuelo_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Und mache die Bretter zu der Wohnung: zwanzig Bretter an der Seite gegen Mittag, südwärts; ");
INSERT INTO deuelo_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","und vierzig Füße von Silber sollst du unter die zwanzig Bretter machen: zwei Füße unter ein Brett für seine zwei Zapfen, und wieder zwei Füße unter ein Brett für seine zwei Zapfen; ");
INSERT INTO deuelo_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","und an der anderen Seite der Wohnung, an der Nordseite, zwanzig Bretter, ");
INSERT INTO deuelo_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","und ihre vierzig Füße von Silber: zwei Füße unter ein Brett, und wieder zwei Füße unter ein Brett; ");
INSERT INTO deuelo_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","und an der Hinterseite der Wohnung gegen Westen sollst du sechs Bretter machen; ");
INSERT INTO deuelo_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","und zwei Bretter sollst du für die Winkel der Wohnung an der Hinterseite machen; ");
INSERT INTO deuelo_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","und sie sollen zweifach sein von unten auf, und sollen an ihrem Oberteil völlig aneinander sein in einem Ringe; also soll es mit ihnen beiden sein, an den beiden Winkeln sollen sie sein. ");
INSERT INTO deuelo_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Und so sollen es acht Bretter sein, und ihre Füße von Silber, sechzehn Füße: zwei Füße unter einem Brette, und wieder zwei Füße unter einem Brette. ");
INSERT INTO deuelo_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Und du sollst Riegel von Akazienholz machen: fünf zu den Brettern der einen Seite der Wohnung, ");
INSERT INTO deuelo_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","und fünf Riegel zu den Brettern der anderen Seite der Wohnung, und fünf Riegel zu den Brettern der Seite der Wohnung an der Hinterseite gegen Westen; ");
INSERT INTO deuelo_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","und den mittleren Riegel in der Mitte der Bretter durchlaufend von einem Ende zum anderen. ");
INSERT INTO deuelo_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Und die Bretter sollst du mit Gold überziehen; und ihre Ringe, die Behälter für die Riegel, sollst du von Gold machen und die Riegel mit Gold überziehen. ");
INSERT INTO deuelo_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Und so richte die Wohnung auf, nach ihrer Vorschrift, wie sie dir auf dem Berge gezeigt worden ist. ");
INSERT INTO deuelo_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Und du sollst einen Vorhang machen von blauem und rotem Purpur und Karmesin und gezwirntem Byssus; in Kunstweberarbeit soll man ihn machen, mit Cherubim. ");
INSERT INTO deuelo_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Und hänge ihn auf an vier Säulen von Akazienholz, überzogen mit Gold, ihre Haken von Gold, auf vier Füßen von Silber; ");
INSERT INTO deuelo_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","und hänge den Vorhang auf unter die Klammern; und bringe dorthin, innerhalb des Vorhanges, die Lade des Zeugnisses. Und der Vorhang soll euch eine Scheidung machen zwischen dem Heiligen und dem Allerheiligsten. ");
INSERT INTO deuelo_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Und lege den Deckel auf die Lade des Zeugnisses im Allerheiligsten. ");
INSERT INTO deuelo_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Und stelle den Tisch außerhalb des Vorhangs und den Leuchter dem Tische gegenüber an die Seite der Wohnung gegen Süden; und den Tisch sollst du an die Nordseite setzen. ");
INSERT INTO deuelo_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Und mache für den Eingang des Zeltes einen Vorhang von blauem und rotem Purpur und Karmesin und gezwirntem Byssus, in Buntwirkerarbeit. ");
INSERT INTO deuelo_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Und mache zu dem Vorhang fünf Säulen von Akazienholz und überziehe sie mit Gold, ihre Haken von Gold, und gieße für sie fünf Füße von Erz. ");
INSERT INTO deuelo_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Und du sollst den Altar von Akazienholz machen: fünf Ellen die Länge, und fünf Ellen die Breite, quadratförmig soll der Altar sein und drei Ellen seine Höhe. ");
INSERT INTO deuelo_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Und mache seine Hörner an seine vier Ecken; aus ihm sollen seine Hörner sein; und überziehe ihn mit Erz. ");
INSERT INTO deuelo_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Und mache seine Töpfe, um ihn von der Fettasche zu reinigen, und seine Schaufeln und seine Sprengschalen und seine Gabeln und seine Kohlenpfannen; für alle seine Geräte sollst du Erz verwenden. ");
INSERT INTO deuelo_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Und mache ihm ein Gitter von Netzwerk aus Erz, und mache an das Netz vier eherne Ringe an seine vier Ecken; ");
INSERT INTO deuelo_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","und setze es unter die Einfassung des Altars, unterwärts, daß das Netz bis zur Hälfte des Altars reiche. ");
INSERT INTO deuelo_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Und mache Stangen für den Altar, Stangen von Akazienholz, und überziehe sie mit Erz. ");
INSERT INTO deuelo_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Und seine Stangen sollen in die Ringe gebracht werden, daß die Stangen an beiden Seiten des Altars seien, wenn man ihn trägt. ");
INSERT INTO deuelo_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Hohl, von Brettern sollst du ihn machen; so wie dir auf dem Berge gezeigt worden ist, also soll man ihn machen. ");
INSERT INTO deuelo_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Und du sollst den Vorhof der Wohnung machen: an der Mittagseite, südwärts, Umhänge für den Vorhof von gezwirntem Byssus, hundert Ellen die Länge auf der einen Seite; ");
INSERT INTO deuelo_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","und seine zwanzig Säulen und ihre zwanzig Füße von Erz, die Haken der Säulen und ihre Bindestäbe von Silber. ");
INSERT INTO deuelo_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Und ebenso an der Nordseite in die Länge: Umhänge, hundert Ellen lang; und seine zwanzig Säulen und ihre zwanzig Füße von Erz, die Haken der Säulen und ihre Bindestäbe von Silber. ");
INSERT INTO deuelo_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Und die Breite des Vorhofs an der Westseite: fünfzig Ellen Umhänge, ihre zehn Säulen und ihre zehn Füße. ");
INSERT INTO deuelo_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Und die Breite des Vorhofs an der Ostseite, gegen Aufgang, fünfzig Ellen: ");
INSERT INTO deuelo_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","fünfzehn Ellen Umhänge auf der einen Seite, ihre drei Säulen und ihre drei Füße; ");
INSERT INTO deuelo_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","und auf der anderen Seite fünfzehn Ellen Umhänge, ihre drei Säulen und ihre drei Füße; ");
INSERT INTO deuelo_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","und für das Tor des Vorhofs einen Vorhang von zwanzig Ellen von blauem und rotem Purpur und Karmesin und gezwirntem Byssus, in Buntwirkerarbeit, ihre vier Säulen und ihre vier Füße. ");
INSERT INTO deuelo_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Alle Säulen des Vorhofs ringsum sollen mit Bindestäben von Silber versehen sein, ihre Haken von Silber und ihre Füße von Erz. ");
INSERT INTO deuelo_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Die Länge des Vorhofs hundert Ellen, und die Breite fünfzig gegen fünfzig, und die Höhe fünf Ellen, von gezwirntem Byssus; und ihre Füße von Erz. ");
INSERT INTO deuelo_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Alle Geräte der Wohnung zu ihrem ganzen Dienst und alle ihre Pflöcke und alle Pflöcke des Vorhofs sollen von Erz sein. ");
INSERT INTO deuelo_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Und du, du sollst den Kindern Israel gebieten, daß sie dir reines, zerstoßenes Olivenöl bringen zum Licht, um die Lampen anzuzünden beständig. ");
INSERT INTO deuelo_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Im Zelte der Zusammenkunft, außerhalb des Vorhangs, der vor dem Zeugnis ist, sollen Aaron und seine Söhne sie zurichten vom Abend bis zum Morgen, vor Jehova. Eine ewige Satzung bei ihren Geschlechtern von seiten der Kinder Israel. ");
INSERT INTO deuelo_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Und du, du sollst zu dir nahen lassen deinen Bruder Aaron und seine Söhne mit ihm, aus der Mitte der Kinder Israel, um mir den Priesterdienst auszuüben: Aaron, Nadab und Abihu, Eleasar und Ithamar, die Söhne Aarons. ");
INSERT INTO deuelo_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Und du sollst heilige Kleider für deinen Bruder Aaron machen zur Herrlichkeit und zum Schmuck. ");
INSERT INTO deuelo_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Und du sollst zu allen reden, die weisen Herzens sind, die ich mit dem Geiste der Weisheit erfüllt habe, daß sie die Kleider Aarons machen, ihn zu heiligen, um mir den Priesterdienst auszuüben. ");
INSERT INTO deuelo_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Und dies sind die Kleider, die sie machen sollen: ein Brustschild und ein Ephod und ein Oberkleid, und einen Leibrock von zellenförmigem Gewebe, einen Kopfbund und einen Gürtel; und sie sollen heilige Kleider machen für deinen Bruder Aaron und für seine Söhne, um mir den Priesterdienst auszuüben. ");
INSERT INTO deuelo_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Und sie sollen das Gold und den blauen und den roten Purpur und den Karmesin und den Byssus nehmen ");
INSERT INTO deuelo_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","und sollen das Ephod machen von Gold, blauem und rotem Purpur, Karmesin und gezwirntem Byssus, in Kunstweberarbeit. ");
INSERT INTO deuelo_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Es soll zwei zusammenfügende Schulterstücke haben an seinen beiden Enden, und so werde es zusammengefügt. ");
INSERT INTO deuelo_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Und der gewirkte Gürtel, mit dem es angebunden wird, der darüber ist, soll von gleicher Arbeit mit ihm sein, von gleichem Stoffe: von Gold, blauem und rotem Purpur und Karmesin und gezwirntem Byssus. ");
INSERT INTO deuelo_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Und du sollst zwei Onyxsteine nehmen und die Namen der Söhne Israels darauf stechen: ");
INSERT INTO deuelo_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","sechs ihrer Namen auf den einen Stein und die sechs übrigen Namen auf den anderen Stein, nach ihrer Geburtsfolge. ");
INSERT INTO deuelo_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","In Steinschneiderarbeit, in Siegelstecherei sollst du die beiden Steine stechen nach den Namen der Söhne Israels; mit Einfassungen von Gold umgeben sollst du sie machen. ");
INSERT INTO deuelo_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Und setze die beiden Steine auf die Schulterstücke des Ephods, als Steine des Gedächtnisses für die Kinder Israel; und Aaron soll ihre Namen auf seinen beiden Schultern tragen vor Jehova zum Gedächtnis. ");
INSERT INTO deuelo_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Und mache Einfassungen von Gold; ");
INSERT INTO deuelo_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","und zwei Ketten von reinem Golde: schnurähnlich sollst du sie machen, in Flechtwerk, und die geflochtenen Ketten an die Einfassungen befestigen. ");
INSERT INTO deuelo_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Und mache das Brustschild des Gerichts in Kunstweberarbeit; gleich der Arbeit des Ephods sollst du es machen: von Gold, blauem und rotem Purpur und Karmesin und gezwirntem Byssus sollst du es machen. ");
INSERT INTO deuelo_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Quadratförmig soll es sein, gedoppelt, eine Spanne seine Länge und eine Spanne seine Breite. ");
INSERT INTO deuelo_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Und besetze es mit eingesetzten Steinen, vier Reihen von Steinen; eine Reihe: Sardis, Topas und Smaragd, die erste Reihe; ");
INSERT INTO deuelo_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","und die zweite Reihe: Karfunkel, Saphir und Diamant; ");
INSERT INTO deuelo_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","und die dritte Reihe: Opal, Achat und Amethyst; ");
INSERT INTO deuelo_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","und die vierte Reihe: Chrysolith und Onyx und Jaspis; mit Gold sollen sie eingefaßt sein in ihren Einsetzungen. ");
INSERT INTO deuelo_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Und der Steine sollen nach den Namen der Söhne Israels zwölf sein, nach ihren Namen; in Siegelstecherei sollen sie sein, ein jeder nach seinem Namen, für die zwölf Stämme. ");
INSERT INTO deuelo_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Und mache an das Brustschild schnurähnliche Ketten in Flechtwerk, von reinem Golde. ");
INSERT INTO deuelo_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Und mache an das Brustschild zwei Ringe von Gold, und befestige die zwei Ringe an die beiden Enden des Brustschildes. ");
INSERT INTO deuelo_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Und befestige die zwei geflochtenen Schnüre von Gold an die beiden Ringe an den Enden des Brustschildes; ");
INSERT INTO deuelo_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","und die beiden anderen Enden der zwei geflochtenen Schnüre sollst du an die beiden Einfassungen befestigen und sie an die Schulterstücke des Ephods befestigen, an seine Vorderseite. ");
INSERT INTO deuelo_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Und mache zwei Ringe von Gold und befestige sie an die beiden Enden des Brustschildes, an seinen Saum, der gegen das Ephod hin ist, einwärts; ");
INSERT INTO deuelo_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","und mache zwei Ringe von Gold und befestige sie an die beiden Schulterstücke des Ephods, unten an seine Vorderseite, gerade bei seiner Zusammenfügung, oberhalb des gewirkten Gürtels des Ephods. ");
INSERT INTO deuelo_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Und man soll das Brustschild mit seinen Ringen an die Ringe des Ephods binden mit einer Schnur von blauem Purpur, daß es über dem gewirkten Gürtel des Ephods sei und das Brustschild sich nicht von dem Ephod verrücke. ");
INSERT INTO deuelo_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Und Aaron soll die Namen der Söhne Israels an dem Brustschilde des Gerichts auf seinem Herzen tragen, wenn er ins Heiligtum hineingeht, zum Gedächtnis vor Jehova beständig. ");
INSERT INTO deuelo_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Und lege in das Brustschild des Gerichts die Urim und die Thummim, daß sie auf dem Herzen Aarons seien, wenn er vor Jehova hineingeht; und Aaron soll das Gericht der Kinder Israel auf seinem Herzen tragen vor Jehova beständig. ");
INSERT INTO deuelo_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Und mache das Oberkleid des Ephods ganz von blauem Purpur. ");
INSERT INTO deuelo_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Und seine Kopföffnung soll in seiner Mitte sein; eine Borte soll es an seiner Öffnung haben ringsum, in Weberarbeit; wie die Öffnung eines Panzers soll daran sein, daß es nicht einreiße. ");
INSERT INTO deuelo_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Und an seinen Saum mache Granatäpfel von blauem und rotem Purpur und Karmesin, an seinen Saum ringsum, und Schellen von Gold zwischen ihnen ringsum: ");
INSERT INTO deuelo_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","eine Schelle von Gold und einen Granatapfel, eine Schelle von Gold und einen Granatapfel an den Saum des Oberkleides ringsum. ");
INSERT INTO deuelo_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Und Aaron soll es anhaben, um den Dienst zu verrichten, daß sein Klang gehört werde, wenn er ins Heiligtum hineingeht vor Jehova und wenn er hinausgeht, daß er nicht sterbe. ");
INSERT INTO deuelo_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Und mache ein Blech von reinem Golde und stich darauf mit Siegelstecherei: Heiligkeit dem Jehova! ");
INSERT INTO deuelo_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Und tue es an eine Schnur von blauem Purpur; und es soll an dem Kopfbunde sein, an der Vorderseite des Kopfbundes soll es sein. ");
INSERT INTO deuelo_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Und es soll auf der Stirn Aarons sein, und Aaron soll die Ungerechtigkeit der heiligen Dinge tragen, welche die Kinder Israel heiligen werden, bei allen Gaben ihrer heiligen Dinge; und es soll beständig an seiner Stirn sein, zum Wohlgefallen für sie vor Jehova. ");
INSERT INTO deuelo_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Und mache den Leibrock von zellenförmigen Gewebe von Byssus, und mache einen Kopfbund von Byssus; und einen Gürtel sollst du machen in Buntwirkerarbeit. ");
INSERT INTO deuelo_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Und den Söhnen Aarons sollst du Leibröcke machen und sollst ihnen Gürtel machen, und hohe Mützen sollst du ihnen machen zur Herrlichkeit und zum Schmuck. ");
INSERT INTO deuelo_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Und du sollst deinen Bruder Aaron damit bekleiden und seine Söhne mit ihm; und du sollst sie salben und sie weihen und sie heiligen, daß sie mir den Priesterdienst ausüben. ");
INSERT INTO deuelo_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Und mache ihnen Beinkleider von Linnen, um das Fleisch der Blöße zu bedecken; von den Hüften bis an die Schenkel sollen sie reichen. ");
INSERT INTO deuelo_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Und Aaron und seine Söhne sollen sie anhaben, wenn sie in das Zelt der Zusammenkunft hineingehen, oder wenn sie dem Altar nahen, um den Dienst im Heiligtum zu verrichten, daß sie nicht eine Ungerechtigkeit tragen und sterben: eine ewige Satzung für ihn und für seinen Samen nach ihm. ");
INSERT INTO deuelo_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Und dies ist es, was du ihnen tun sollst, sie zu heiligen, um mir den Priesterdienst auszuüben: Nimm einen jungen Farren und zwei Widder, ohne Fehl, ");
INSERT INTO deuelo_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","und ungesäuertes Brot, und ungesäuerte Kuchen, gemengt mit Öl, und ungesäuerte Fladen, gesalbt mit Öl: von Feinmehl des Weizens sollst du sie machen. ");
INSERT INTO deuelo_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Und lege sie in einen Korb und bringe sie in dem Korbe dar, und den Farren und die zwei Widder. ");
INSERT INTO deuelo_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Und Aaron und seine Söhne sollst du herzunahen lassen an den Eingang des Zeltes der Zusammenkunft und sie mit Wasser waschen. ");
INSERT INTO deuelo_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Und du sollst die Kleider nehmen und Aaron bekleiden mit dem Leibrock und dem Oberkleide des Ephods und dem Ephod und dem Brustschilde und es ihm anbinden mit dem gewirkten Gürtel des Ephods. ");
INSERT INTO deuelo_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Und setze den Kopfbund auf sein Haupt und lege das heilige Diadem an den Kopfbund. ");
INSERT INTO deuelo_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Und nimm das Salböl und gieße es auf sein Haupt und salbe ihn. ");
INSERT INTO deuelo_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Und seine Söhne sollst du herzunahen lassen und sie mit den Leibröcken bekleiden; ");
INSERT INTO deuelo_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","und umgürte sie mit dem Gürtel, Aaron und seine Söhne, und binde ihnen die hohen Mützen um; und das Priestertum sei ihnen zu einer ewigen Satzung. Und du sollst Aaron und seine Söhne weihen. ");
INSERT INTO deuelo_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Und du sollst den Farren herzubringen vor das Zelt der Zusammenkunft, und Aaron und seine Söhne sollen ihre Hände auf den Kopf des Farren legen. ");
INSERT INTO deuelo_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Und schlachte den Farren vor Jehova, an dem Eingang des Zeltes der Zusammenkunft; ");
INSERT INTO deuelo_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","und nimm von dem Blute des Farren und tue es mit deinem Finger an die Hörner des Altars, und alles Blut sollst du an den Fuß des Altars gießen. ");
INSERT INTO deuelo_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Und nimm alles Fett, welches das Eingeweide bedeckt, und das Netz über der Leber und die beiden Nieren und das Fett, das an ihnen ist, und räuchere es auf dem Altar. ");
INSERT INTO deuelo_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Und das Fleisch des Farren und seine Haut und seinen Mist sollst du mit Feuer verbrennen außerhalb des Lagers: es ist ein Sündopfer. ");
INSERT INTO deuelo_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Und du sollst den einen Widder nehmen, und Aaron und seine Söhne sollen ihre Hände auf den Kopf des Widders legen. ");
INSERT INTO deuelo_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Und du sollst den Widder schlachten und sein Blut nehmen und an den Altar sprengen ringsum. ");
INSERT INTO deuelo_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Und den Widder sollst du in seine Stücke zerlegen und sein Eingeweide und seine Schenkel waschen und sie auf seine Stücke und auf seinen Kopf legen. ");
INSERT INTO deuelo_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Und den ganzen Widder sollst du auf dem Altar räuchern: es ist ein Brandopfer dem Jehova, ein lieblicher Geruch; es ist ein Feueropfer dem Jehova. ");
INSERT INTO deuelo_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Und du sollst den zweiten Widder nehmen, und Aaron und seine Söhne sollen ihre Hände auf den Kopf des Widders legen. ");
INSERT INTO deuelo_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Und du sollst den Widder schlachten und von seinem Blute nehmen und es auf das rechte Ohrläppchen Aarons tun und auf das rechte Ohrläppchen seiner Söhne und auf den Daumen ihrer rechten Hand und auf die große Zehe ihres rechten Fußes; und du sollst das Blut an den Altar sprengen ringsum. ");
INSERT INTO deuelo_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Und nimm von dem Blute, das auf dem Altar ist, und von dem Salböl, und sprenge es auf Aaron und auf seine Kleider und auf seine Söhne und auf die Kleider seiner Söhne mit ihm; und er wird heilig sein und seine Kleider, und seine Söhne und die Kleider seiner Söhne mit ihm. ");
INSERT INTO deuelo_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Und nimm von dem Widder das Fett und den Fettschwanz und das Fett, welches das Eingeweide bedeckt, und das Netz der Leber und die beiden Nieren und das Fett, das an ihnen ist, und den rechten Schenkel, denn es ist ein Widder der Einweihung- ");
INSERT INTO deuelo_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","und einen Laib Brot und einen Kuchen geölten Brotes und einen Fladen aus dem Korbe des Ungesäuerten, der vor Jehova ist; ");
INSERT INTO deuelo_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","und lege das alles auf die Hände Aarons und auf die Hände seiner Söhne, und webe es als Webopfer vor Jehova. ");
INSERT INTO deuelo_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Und nimm es von ihren Händen und räuchere es auf dem Altar, auf dem Brandopfer, zum lieblichen Geruch vor Jehova: es ist ein Feueropfer dem Jehova. ");
INSERT INTO deuelo_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Und nimm die Brust von dem Einweihungswidder, der für Aaron ist, und webe sie als Webopfer vor Jehova; und sie soll dein Anteil sein. ");
INSERT INTO deuelo_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Und heilige die Brust des Webopfers und den Schenkel des Hebopfers, die gewoben und der gehoben worden ist von dem Einweihungswidder, von dem, der für Aaron, und von dem, der für seine Söhne ist; ");
INSERT INTO deuelo_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","und es soll Aaron und seinen Söhnen gehören als eine ewige Gebühr von seiten der Kinder Israel, denn es ist ein Hebopfer; und es soll ein Hebopfer sein von seiten der Kinder Israel, von ihren Friedensopfern: ihr Hebopfer dem Jehova. - ");
INSERT INTO deuelo_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Und die heiligen Kleider Aarons sollen für seine Söhne sein nach ihm, um sie darin zu salben und sie darin zu weihen. ");
INSERT INTO deuelo_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Sieben Tage soll sie anziehen, wer von seinen Söhnen Priester wird an seiner Statt, welcher in das Zelt der Zusammenkunft hineingehen wird, um im Heiligtum zu dienen. - ");
INSERT INTO deuelo_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Und den Einweihungswidder sollst du nehmen und sein Fleisch an heiligem Orte kochen. ");
INSERT INTO deuelo_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Und Aaron und seine Söhne sollen das Fleisch des Widders und das Brot, das in dem Korbe ist, essen an dem Eingang des Zeltes der Zusammenkunft: ");
INSERT INTO deuelo_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","sie sollen die Dinge essen, durch welche Sühnung geschehen ist, um sie zu weihen, um sie zu heiligen; ein Fremder aber soll nicht davon essen, denn sie sind heilig. ");
INSERT INTO deuelo_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Und wenn von dem Fleische der Einweihung und von dem Brote etwas übrigbleibt bis an den Morgen, so sollst du das Übriggebliebene mit Feuer verbrennen; es soll nicht gegessen werden, denn es ist heilig. ");
INSERT INTO deuelo_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Und du sollst Aaron und seinen Söhnen also tun, nach allem, was ich dir geboten habe; sieben Tage sollst du sie einweihen. ");
INSERT INTO deuelo_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Und einen Farren als Sündopfer sollst du täglich zur Sühnung opfern und den Altar entsündigen, indem du Sühnung für ihn tust; und du sollst ihn salben, um ihn zu heiligen. ");
INSERT INTO deuelo_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Sieben Tage sollst du Sühnung tun für den Altar und ihn heiligen; und der Altar soll hochheilig sein: alles, was den Altar anrührt, wird heilig sein. ");
INSERT INTO deuelo_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Und dies ist es, was du auf dem Altar opfern sollst: zwei einjährige Lämmer des Tages beständig. ");
INSERT INTO deuelo_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Das eine Lamm sollst du am Morgen opfern, und das zweite Lamm sollst du opfern zwischen den zwei Abenden, ");
INSERT INTO deuelo_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","und ein Zehntel Feinmehl, gemengt mit einem viertel Hin zerstoßenen Öles, und ein Trankopfer, ein viertel Hin Wein, zu dem einen Lamme. ");
INSERT INTO deuelo_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Und das zweite Lamm sollst du opfern zwischen den zwei Abenden; wie das Morgenspeisopfer und wie dessen Trankopfer, so sollst du zu diesem opfern, zum lieblichen Geruch, ein Feueropfer dem Jehova: ");
INSERT INTO deuelo_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","ein beständiges Brandopfer bei euren Geschlechtern an dem Eingang des Zeltes der Zusammenkunft vor Jehova, wo ich mit euch zusammenkommen werde, um daselbst mit dir zu reden. ");
INSERT INTO deuelo_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Und ich werde daselbst mit den Kindern Israel zusammenkommen, und es wird geheiligt werden durch meine Herrlichkeit. ");
INSERT INTO deuelo_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Und ich werde das Zelt der Zusammenkunft und den Altar heiligen; und Aaron und seine Söhne werde ich heiligen, daß sie mir den Priesterdienst ausüben. ");
INSERT INTO deuelo_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Und ich werde in der Mitte der Kinder Israel wohnen und werde ihr Gott sein. ");
INSERT INTO deuelo_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Und sie werden wissen, daß ich Jehova bin, ihr Gott, der ich sie aus dem Lande Ägypten herausgeführt habe, um in ihrer Mitte zu wohnen; ich bin Jehova, ihr Gott. ");
INSERT INTO deuelo_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Und du sollst einen Altar machen zum Räuchern des Räucherwerks, von Akazienholz sollst du ihn machen; ");
INSERT INTO deuelo_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","eine Elle seine Länge, und eine Elle seine Breite, quadratförmig soll er sein und zwei Ellen seine Höhe; aus ihm sollen seine Hörner sein. ");
INSERT INTO deuelo_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Und überziehe ihn mit reinem Golde, seine Platte und seine Wände ringsum und seine Hörner; und mache ihm einen Kranz von Gold ringsum. ");
INSERT INTO deuelo_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Und mache ihm zwei Ringe von Gold unter seinen Kranz: an seine beiden Seiten sollst du sie machen, an seine beiden Wände; und sie sollen zu Behältern sein für die Stangen, um ihn mit denselben zu tragen. ");
INSERT INTO deuelo_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Und mache die Stangen von Akazienholz und überziehe sie mit Gold. ");
INSERT INTO deuelo_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Und stelle ihn dem Vorhang gegenüber, der vor der Lade des Zeugnisses ist, dem Deckel gegenüber, der über dem Zeugnis ist, woselbst ich mit dir zusammenkommen werde. ");
INSERT INTO deuelo_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Und Aaron soll wohlriechendes Räucherwerk auf ihm räuchern; Morgen für Morgen, wenn er die Lampen zurichtet, soll er es räuchern; ");
INSERT INTO deuelo_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","und wenn Aaron die Lampen anzündet zwischen den zwei Abenden, soll er es räuchern: ein beständiges Räucherwerk vor Jehova bei euren Geschlechtern. ");
INSERT INTO deuelo_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Ihr sollt kein fremdes Räucherwerk auf ihm opfern, noch Brandopfer, noch Speisopfer; und kein Trankopfer sollt ihr auf ihn gießen. ");
INSERT INTO deuelo_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Und Aaron soll einmal im Jahre für dessen Hörner Sühnung tun mit dem Blute des Sündopfers der Versöhnung; einmal im Jahre soll er Sühnung für ihn tun bei euren Geschlechtern: hochheilig ist er dem Jehova. ");
INSERT INTO deuelo_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Wenn du die Summe der Kinder Israel aufnehmen wirst nach ihren Gemusterten, so sollen sie bei ihrer Musterung ein jeder eine Sühne seiner Seele dem Jehova geben, daß keine Plage unter ihnen entstehe bei ihrer Musterung. ");
INSERT INTO deuelo_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Dies sollen sie geben: jeder zu den Gemusterten Übergehende die Hälfte eines Sekels, nach dem Sekel des Heiligtums (zwanzig Gera der Sekel), die Hälfte eines Sekels als Hebopfer dem Jehova. ");
INSERT INTO deuelo_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Jeder zu den Gemusterten Übergehende, von zwanzig Jahren und darüber, soll das Hebopfer Jehovas geben. ");
INSERT INTO deuelo_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Der Reiche soll nicht mehr geben und der Arme nicht weniger als die Hälfte eines Sekels, wenn ihr das Hebopfer Jehovas gebet, um Sühnung zu tun für eure Seelen. ");
INSERT INTO deuelo_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Und du sollst das Sühngeld von seiten der Kinder Israel nehmen und es für die Arbeit des Zeltes der Zusammenkunft geben; und es soll den Kindern Israel zum Gedächtnis sein vor Jehova, um Sühnung zu tun für eure Seelen. ");
INSERT INTO deuelo_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Mache auch ein Becken von Erz und sein Gestell von Erz zum Waschen; und setze es zwischen das Zelt der Zusammenkunft und den Altar und tue Wasser darein. ");
INSERT INTO deuelo_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Und Aaron und seine Söhne sollen ihre Hände und ihre Füße daraus waschen. ");
INSERT INTO deuelo_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Wenn sie in das Zelt der Zusammenkunft hineingehen, sollen sie sich mit Wasser waschen, daß sie nicht sterben, oder wenn sie dem Altar nahen zum Dienst, um Jehova ein Feueropfer zu räuchern. ");
INSERT INTO deuelo_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Und sie sollen ihre Hände und ihre Füße waschen, daß sie nicht sterben; und das soll ihnen eine ewige Satzung sein, ihm und seinem Samen bei ihren Geschlechtern. ");
INSERT INTO deuelo_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Und du, nimm dir die besten Gewürze: von selbst ausgeflossene Myrrhe fünfhundert Sekel, und würzigen Zimmet die Hälfte davon, zweihundertfünfzig, und Würzrohr zweihundertfünfzig, ");
INSERT INTO deuelo_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","und Kassia fünfhundert, nach dem Sekel des Heiligtums, und ein Hin Olivenöl; ");
INSERT INTO deuelo_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","und mache daraus ein Öl der heiligen Salbung, eine Mischung von Gewürzsalbe, ein Werk des Salbenmischers; es soll ein Öl der heiligen Salbung sein. ");
INSERT INTO deuelo_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Und du sollst damit salben das Zelt der Zusammenkunft und die Lade des Zeugnisses ");
INSERT INTO deuelo_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","und den Tisch und alle seine Geräte und den Leuchter und seine Geräte und den Räucheraltar ");
INSERT INTO deuelo_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","und den Brandopferaltar und alle seine Geräte und das Becken und sein Gestell, ");
INSERT INTO deuelo_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","und du sollst sie heiligen; und sie sollen hochheilig sein: alles, was sie anrührt, wird heilig sein. ");
INSERT INTO deuelo_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Und Aaron und seine Söhne sollst du salben und sollst sie heiligen, um mir den Priesterdienst auszuüben. ");
INSERT INTO deuelo_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Und zu den Kindern Israel sollst du also reden: Ein Öl der heiligen Salbung soll mir dieses sein bei euren Geschlechtern. ");
INSERT INTO deuelo_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Auf keines Menschen Fleisch soll man es gießen, und nach dem Verhältnis seiner Bestandteile sollt ihr keines desgleichen machen; es ist heilig, heilig soll es euch sein. ");
INSERT INTO deuelo_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Wer desgleichen mischt, und wer davon auf einen Fremden tut, der soll ausgerottet werden aus seinen Völkern. ");
INSERT INTO deuelo_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Und Jehova sprach zu Mose: Nimm dir wohlriechende Gewürze, Stakte und Räuchermuschel und Galban, wohlriechende Gewürze und reinen Weihrauch; zu gleichen Teilen sollen sie sein. ");
INSERT INTO deuelo_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Und mache Räucherwerk daraus, Würzwerk, ein Werk des Salbenmischers, gesalzen, rein, heilig. ");
INSERT INTO deuelo_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Und zerstoße davon zu Pulver, und lege davon vor das Zeugnis in das Zelt der Zusammenkunft, woselbst ich mit dir zusammenkommen werde; hochheilig soll es euch sein. ");
INSERT INTO deuelo_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Und das Räucherwerk, das du machen sollst, nach dem Verhältnis seiner Bestandteile sollt ihr es euch nicht machen; heilig dem Jehova soll es dir sein. ");
INSERT INTO deuelo_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Wer desgleichen macht, um daran zu riechen, der soll ausgerottet werden aus seinen Völkern. ");
INSERT INTO deuelo_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Siehe, ich habe Bezaleel, den Sohn Uris, des Sohnes Hurs, vom Stamme Juda, mit Namen berufen ");
INSERT INTO deuelo_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","und habe ihn mit dem Geiste Gottes erfüllt, in Weisheit und in Verstand und in Kenntnis und in jeglichem Werk; ");
INSERT INTO deuelo_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","um Künstliches zu ersinnen, zu arbeiten in Gold und in Silber und in Erz, ");
INSERT INTO deuelo_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","und im Schneiden von Steinen zum Einsetzen und im Holzschneiden, um zu arbeiten in jeglichem Werk. ");
INSERT INTO deuelo_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Und ich, siehe, ich habe ihm Oholiab, den Sohn Achisamaks, vom Stamme Dan, beigegeben; und in das Herz eines jeden, der weisen Herzens ist, habe ich Weisheit gelegt, daß sie alles machen, was ich dir geboten habe: ");
INSERT INTO deuelo_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","das Zelt der Zusammenkunft und die Lade des Zeugnisses und den Deckel, der darauf ist, und alle Geräte des Zeltes; ");
INSERT INTO deuelo_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","und den Tisch und alle seine Geräte und den reinen Leuchter und alle seine Geräte und den Räucheraltar ");
INSERT INTO deuelo_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","und den Brandopferaltar und alle seine Geräte, und das Becken und sein Gestell; ");
INSERT INTO deuelo_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","und die Dienstkleider und die heiligen Kleider für Aaron, den Priester, und die Kleider seiner Söhne, um den Priesterdienst auszuüben; ");
INSERT INTO deuelo_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","und das Salböl und das wohlriechende Räucherwerk für das Heiligtum: nach allem, was ich dir geboten habe, sollen sie es machen. ");
INSERT INTO deuelo_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Und du, rede zu den Kindern Israel und sprich: Fürwahr, meine Sabbathe sollt ihr beobachten; denn sie sind ein Zeichen zwischen mir und euch bei euren Geschlechtern, damit ihr wisset, daß ich, Jehova, es bin, der euch heiligt; ");
INSERT INTO deuelo_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","und beobachtet den Sabbath, denn heilig ist er euch; wer ihn entweiht, soll gewißlich getötet werden; denn wer irgend an ihm eine Arbeit tut, selbige Seele soll ausgerottet werden aus der Mitte ihrer Völker. ");
INSERT INTO deuelo_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Sechs Tage soll man Arbeit tun, aber am siebten Tage ist der Sabbath der Ruhe, heilig dem Jehova; wer irgend am Tage des Sabbaths eine Arbeit tut, soll gewißlich getötet werden. ");
INSERT INTO deuelo_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Und die Kinder Israel sollen den Sabbath beobachten, um den Sabbath zu feiern bei ihren Geschlechtern: ein ewiger Bund. ");
INSERT INTO deuelo_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Er ist ein Zeichen zwischen mir und den Kindern Israel ewiglich; denn in sechs Tagen hat Jehova den Himmel und die Erde gemacht, und am siebten Tage hat er geruht und sich erquickt. ");
INSERT INTO deuelo_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Und er gab dem Mose, als er auf dem Berge Sinai mit ihm ausgeredet hatte, die zwei Tafeln des Zeugnisses, Tafeln von Stein, beschrieben mit dem Finger Gottes. ");
INSERT INTO deuelo_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Und als das Volk sah, daß Mose verzog, von dem Berge herabzukommen, da versammelte sich das Volk zu Aaron, und sie sprachen zu ihm: Auf! Mache uns einen Gott, der vor uns hergehe! Denn dieser Mose, der Mann, der uns aus dem Lande Ägypten heraufgeführt hat, wir wissen nicht, was ihm geschehen ist. ");
INSERT INTO deuelo_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Und Aaron sprach zu ihnen: Reißet die goldenen Ringe ab, die in den Ohren eurer Weiber, eurer Söhne und eurer Töchter sind, und bringet sie zu mir. ");
INSERT INTO deuelo_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Und das ganze Volk riß sich die goldenen Ringe ab, die in ihren Ohren waren, und sie brachten sie zu Aaron. ");
INSERT INTO deuelo_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Und er nahm es aus ihrer Hand und bildete es mit einem Meißel und machte ein gegossenes Kalb daraus. Und sie sprachen: Das ist dein Gott, Israel, der dich aus dem Lande Ägypten heraufgeführt hat. ");
INSERT INTO deuelo_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Und als Aaron es sah, baute er einen Altar vor ihm; und Aaron rief aus und sprach: Ein Fest dem Jehova ist morgen! ");
INSERT INTO deuelo_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Und sie standen des folgenden Tages früh auf und opferten Brandopfer und brachten Friedensopfer; und das Volk setzte sich nieder, um zu essen und zu trinken, und sie standen auf, um sich zu belustigen. ");
INSERT INTO deuelo_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Da sprach Jehova zu Mose: Gehe, steige hinab! Denn dein Volk, das du aus dem Lande Ägypten heraufgeführt hast, hat sich verderbt. ");
INSERT INTO deuelo_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Sie sind schnell von dem Wege abgewichen, den ich ihnen geboten habe; sie haben sich ein gegossenes Kalb gemacht und sich vor ihm niedergebeugt und haben ihm geopfert und gesagt: Das ist dein Gott, Israel, der dich aus dem Lande Ägypten heraufgeführt hat. ");
INSERT INTO deuelo_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Und Jehova sprach zu Mose: Ich habe dieses Volk gesehen, und siehe, es ist ein hartnäckiges Volk; ");
INSERT INTO deuelo_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","und nun laß mich, daß mein Zorn wider sie entbrenne und ich sie vernichte; dich aber will ich zu einer großen Nation machen. ");
INSERT INTO deuelo_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Und Mose flehte zu Jehova, seinem Gott, und sprach: Warum, Jehova, sollte dein Zorn entbrennen wider dein Volk, das du aus dem Lande Ägypten herausgeführt hast mit großer Kraft und mit starker Hand? ");
INSERT INTO deuelo_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Warum sollten die Ägypter also sprechen: Zum Unglück hat er sie herausgeführt, um sie im Gebirge zu töten und sie von der Fläche des Erdbodens zu vernichten? Kehre um von der Glut deines Zornes und laß dich des Übels wider dein Volk gereuen. ");
INSERT INTO deuelo_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Gedenke Abrahams, Isaaks und Israels, deiner Knechte, denen du bei dir selbst geschworen hast, und hast zu ihnen gesagt: Mehren will ich euren Samen wie die Sterne des Himmels; und dieses ganze Land, von dem ich geredet habe, werde ich eurem Samen geben, daß sie es als Erbteil besitzen ewiglich. ");
INSERT INTO deuelo_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Und es gereute Jehova des Übels, wovon er geredet hatte, daß er es seinem Volke tun werde. ");
INSERT INTO deuelo_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Und Mose wandte sich und stieg von dem Berge hinab, die zwei Tafeln des Zeugnisses in seiner Hand, Tafeln, beschrieben auf ihren beiden Seiten: auf dieser und auf jener Seite waren sie beschrieben. ");
INSERT INTO deuelo_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Und die Tafeln waren das Werk Gottes, und die Schrift war die Schrift Gottes, eingegraben in die Tafeln. ");
INSERT INTO deuelo_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Und Josua hörte die Stimme des Volkes, als es jauchzte, und sprach zu Mose: Kriegsgeschrei ist im Lager! ");
INSERT INTO deuelo_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Und er sprach: Es ist nicht der Schall von Siegesgeschrei und nicht der Schall von Geschrei der Niederlage; den Schall von Wechselgesang höre ich. ");
INSERT INTO deuelo_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Und es geschah, als er dem Lager nahte und das Kalb und die Reigentänze sah, da entbrannte der Zorn Moses, und er warf die Tafeln aus seinen Händen und zerbrach sie unten am Berge. ");
INSERT INTO deuelo_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Und er nahm das Kalb, das sie gemacht hatten, und verbrannte es im Feuer und zermalmte es, bis es zu Staub wurde; und er streute es auf das Wasser und ließ es die Kinder Israel trinken. ");
INSERT INTO deuelo_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Und Mose sprach zu Aaron: Was hat dir dieses Volk getan, daß du eine große Sünde über dasselbe gebracht hast? ");
INSERT INTO deuelo_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Und Aaron sprach: Es entbrenne nicht der Zorn meines Herrn! Du kennst das Volk, daß es im Bösen ist. ");
INSERT INTO deuelo_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Und sie sprachen zu mir: Mache uns einen Gott, der vor uns hergehe; denn dieser Mose, der Mann, der uns aus dem Lande Ägypten heraufgeführt hat wir wissen nicht, was ihm geschehen ist. ");
INSERT INTO deuelo_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Und ich sprach zu ihnen: Wer hat Gold? Sie rissen es sich ab und gaben es mir, und ich warf es ins Feuer, und dieses Kalb ging hervor. ");
INSERT INTO deuelo_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Und Mose sah das Volk, daß es zügellos war; denn Aaron hatte es zügellos gemacht, zum Gespött unter ihren Widersachern. ");
INSERT INTO deuelo_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Und Mose stellte sich auf im Tore des Lagers und sprach: Her zu mir, wer für Jehova ist! Und es versammelten sich zu ihm alle Söhne Levis. ");
INSERT INTO deuelo_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Und er sprach zu ihnen: Also spricht Jehova, der Gott Israels: Leget ein jeder sein Schwert an seine Hüfte, gehet hin und wieder, von Tor zu Tor im Lager, und erschlaget ein jeder seinen Bruder und ein jeder seinen Freund und ein jeder seinen Nachbar. ");
INSERT INTO deuelo_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Und die Söhne Levis taten nach dem Worte Moses; und es fielen von dem Volke an selbigem Tage bei dreitausend Mann. ");
INSERT INTO deuelo_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Und Mose sprach: Weihet euch heute dem Jehova, ja, ein jeder in seinem Sohne und in seinem Bruder, um heute Segen auf euch zu bringen. ");
INSERT INTO deuelo_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Und es geschah am anderen Tage, da sprach Mose zu dem Volke: Ihr habt eine große Sünde begangen; und nun will ich zu Jehova hinaufsteigen, vielleicht möchte ich Sühnung tun für eure Sünde. ");
INSERT INTO deuelo_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Und Mose kehrte zu Jehova zurück und sprach: Ach, dieses Volk hat eine große Sünde begangen, und sie haben sich einen Gott von Gold gemacht. ");
INSERT INTO deuelo_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Und nun, wenn du ihre Sünde vergeben wolltest! ...Wenn aber nicht, so lösche mich doch aus deinem Buche, das du geschrieben hast. ");
INSERT INTO deuelo_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Und Jehova sprach zu Mose: Wer gegen mich gesündigt hat, den werde ich aus meinem Buche auslöschen. ");
INSERT INTO deuelo_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Und nun gehe hin, führe das Volk, wohin ich dir gesagt habe. Siehe, mein Engel wird vor dir herziehen; und am Tage meiner Heimsuchung, da werde ich ihre Sünde an ihnen heimsuchen. ");
INSERT INTO deuelo_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Und Jehova schlug das Volk, darum daß sie das Kalb gemacht, welches Aaron gemacht hatte. ");
INSERT INTO deuelo_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Und Jehova redete zu Mose: Gehe ziehe hinauf von hinnen, du und das Volk, das du aus dem Lande Ägypten heraufgeführt hast, in das Land, das ich Abraham, Isaak und Jakob zugeschworen habe, indem ich sprach: Deinem Samen werde ich es geben! - ");
INSERT INTO deuelo_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Und ich werde einen Engel vor dir hersenden und vertreiben die Kanaaniter, die Amoriter und die Hethiter und die Perisiter, die Hewiter und die Jebusiter, - ");
INSERT INTO deuelo_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","in ein Land, das von Milch und Honig fließt; denn ich werde nicht in deiner Mitte hinaufziehen, denn du bist ein hartnäckiges Volk, daß ich dich nicht vernichte auf dem Wege. ");
INSERT INTO deuelo_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Und als das Volk dieses böse Wort hörte, da trauerten sie, und keiner legte seinen Schmuck an. ");
INSERT INTO deuelo_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Denn Jehova hatte zu Mose gesagt: Sprich zu den Kindern Israel: Ihr seid ein hartnäckiges Volk; zöge ich nur einen Augenblick in deiner Mitte hinauf, so würde ich dich vernichten. Und nun, lege deinen Schmuck von dir, und ich werde wissen, was ich dir tun will. ");
INSERT INTO deuelo_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Und die Kinder Israel rissen sich ihren Schmuck ab an dem Berge Horeb. ");
INSERT INTO deuelo_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Und Mose nahm das Zelt und schlug es sich auf außerhalb des Lagers, fern vom Lager, und nannte es: Zelt der Zusammenkunft. Und es geschah, ein jeder, der Jehova suchte, ging hinaus zu dem Zelte der Zusammenkunft, das außerhalb des Lagers war. ");
INSERT INTO deuelo_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Und es geschah, wenn Mose zu dem Zelte hinausging, so erhob sich das ganze Volk, und sie standen, ein jeder am Eingang seines Zeltes; und sie schauten Mose nach, bis er in das Zelt trat. ");
INSERT INTO deuelo_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Und es geschah, wenn Mose in das Zelt trat, so stieg die Wolkensäule hernieder und stand am Eingang des Zeltes; und Jehova redete mit Mose. ");
INSERT INTO deuelo_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Und das ganze Volk sah die Wolkensäule am Eingang des Zeltes stehen; und das ganze Volk erhob sich, und sie warfen sich nieder, ein jeder am Eingang seines Zeltes. ");
INSERT INTO deuelo_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Und Jehova redete mit Mose von Angesicht zu Angesicht, wie ein Mann mit seinem Freunde redet; und er kehrte zum Lager zurück. Sein Diener aber, Josua, der Sohn Nuns, ein Jüngling, wich nicht aus dem Innern des Zeltes. ");
INSERT INTO deuelo_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Und Mose sprach zu Jehova: Siehe, du sprichst zu mir: Führe dieses Volk hinauf, aber du hast mich nicht wissen lassen, wen du mit mir senden willst. Und du hast doch gesagt: Ich kenne dich mit Namen, und du hast auch Gnade gefunden in meinen Augen. ");
INSERT INTO deuelo_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Und nun, wenn ich denn Gnade gefunden habe in deinen Augen, so laß mich doch deinen Weg wissen, daß ich dich erkenne, damit ich Gnade finde in deinen Augen; und sieh, daß diese Nation dein Volk ist! ");
INSERT INTO deuelo_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Und er sprach: Mein Angesicht wird mitgehen, und ich werde dir Ruhe geben. ");
INSERT INTO deuelo_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Und er sprach zu ihm: Wenn dein Angesicht nicht mitgeht, so führe uns nicht hinauf von hinnen. ");
INSERT INTO deuelo_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Und woran soll es denn erkannt werden, daß ich Gnade gefunden habe in deinen Augen, ich und dein Volk? Nicht daran, daß du mit uns gehst und wir ausgesondert werden, ich und dein Volk, aus jedem Volke, das auf dem Erdboden ist? ");
INSERT INTO deuelo_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Und Jehova sprach zu Mose: Auch dieses, was du gesagt hast, werde ich tun; denn du hast Gnade gefunden in meinen Augen, und ich kenne dich mit Namen. ");
INSERT INTO deuelo_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Und er sprach: Laß mich doch deine Herrlichkeit sehen! ");
INSERT INTO deuelo_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Und Jehova sprach: Ich werde alle meine Güte vor deinem Angesicht vorübergehen lassen und werde den Namen Jehovas vor dir ausrufen; und ich werde begnadigen, wen ich begnadigen werde, und werde mich erbarmen, wessen ich mich erbarmen werde. ");
INSERT INTO deuelo_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Und er sprach: Du vermagst nicht mein Angesicht zu sehen, denn nicht kann ein Mensch mich sehen und leben. ");
INSERT INTO deuelo_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Und Jehova sprach: Siehe, es ist ein Ort bei mir, da sollst du auf dem Felsen stehen. ");
INSERT INTO deuelo_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Und es wird geschehen, wenn meine Herrlichkeit vorübergeht, so werde ich dich in die Felsenkluft stellen und meine Hand über dich decken, bis ich vorübergegangen bin. ");
INSERT INTO deuelo_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Und ich werde meine Hand hinwegtun, und du wirst mich von hinten sehen; aber mein Angesicht soll nicht gesehen werden. ");
INSERT INTO deuelo_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Und Jehova sprach zu Mose: Haue dir zwei steinerne Tafeln aus wie die ersten, und ich werde auf die Tafeln die Worte schreiben, welche auf den ersten Tafeln waren, die du zerbrochen hast. ");
INSERT INTO deuelo_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Und sei bereit auf den Morgen, und steige am Morgen auf den Berg Sinai und stehe daselbst vor mir auf dem Gipfel des Berges. ");
INSERT INTO deuelo_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Und niemand soll mit dir heraufsteigen, und es soll selbst niemand auf dem ganzen Berge gesehen werden; sogar Kleinvieh und Rinder sollen nicht gegen diesen Berg hin weiden. ");
INSERT INTO deuelo_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Und er hieb zwei steinerne Tafeln aus wie die ersten; und Mose stand des Morgens früh auf und stieg auf den Berg Sinai, so wie Jehova ihm geboten hatte, und nahm, die zwei steinernen Tafeln in seine Hand. ");
INSERT INTO deuelo_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Und Jehova stieg in der Wolke hernieder, und er stand daselbst bei ihm und rief den Namen Jehovas aus. ");
INSERT INTO deuelo_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Und Jehova ging vor seinem Angesicht vorüber und rief: Jehova, Jehova, Gott, barmherzig und gnädig, langsam zum Zorn und groß an Güte und Wahrheit, ");
INSERT INTO deuelo_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","der Güte bewahrt auf Tausende hin, der Ungerechtigkeit, Übertretung und Sünde vergibt, aber keineswegs hält er für schuldlos den Schuldigen, der die Ungerechtigkeit der Väter heimsucht an den Kindern und Kindeskindern, am dritten und am vierten Gliede. ");
INSERT INTO deuelo_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Und Mose neigte sich eilends zur Erde und betete an und sprach: ");
INSERT INTO deuelo_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Wenn ich doch Gnade gefunden habe in deinen Augen, Herr, so ziehe doch der Herr in unserer Mitte denn es ist ein hartnäckiges Volk und vergib unsere Ungerechtigkeit und unsere Sünde, und nimm uns an zum Eigentum. ");
INSERT INTO deuelo_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Und er sprach: Siehe, ich mache einen Bund: Vor deinem ganzen Volke will ich Wunder tun, die nicht gewirkt worden sind auf der ganzen Erde und unter allen Nationen; und das ganze Volk, in dessen Mitte du bist, soll das Werk Jehovas sehen; denn furchtbar ist, was ich mit dir tun werde. ");
INSERT INTO deuelo_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Beobachte, was ich dir heute gebiete. Siehe, ich will vor dir vertreiben die Amoriter und die Kanaaniter und die Hethiter und die Perisiter und die Hewiter und die Jebusiter. ");
INSERT INTO deuelo_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Hüte dich, daß du nicht einen Bund machest mit den Bewohnern des Landes, wohin du kommen wirst, daß sie nicht zum Fallstrick werden in deiner Mitte; ");
INSERT INTO deuelo_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","sondern ihre Altäre sollt ihr niederreißen und ihre Bildsäulen zerbrechen und ihre Ascherim ausrotten, - ");
INSERT INTO deuelo_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","denn du sollst nicht einen anderen Gott anbeten; denn Jehova, dessen Name Eiferer ist, ist ein eifernder Gott; - ");
INSERT INTO deuelo_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","daß du nicht einen Bund machest mit den Bewohnern des Landes und, wenn sie ihren Göttern nachhuren und ihren Göttern opfern, man dich einlade, und du von ihrem Schlachtopfer essest ");
INSERT INTO deuelo_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","und du von ihren Töchtern für deine Söhne nehmest, und ihre Töchter ihren Göttern nachhuren und machen, daß deine Söhne ihren Göttern nachhuren. ");
INSERT INTO deuelo_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Gegossene Götter sollst du dir nicht machen. - ");
INSERT INTO deuelo_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Das Fest der ungesäuerten Brote sollst du beobachten; sieben Tage sollst du Ungesäuertes essen, wie ich dir geboten habe, zur bestimmten Zeit des Monats Abib; denn im Monat Abib bist du aus Ägypten ausgezogen. - ");
INSERT INTO deuelo_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Alles, was die Mutter bricht, ist mein; und all dein Vieh, das männlich geboren wird, das Erstgeborene vom Rind-und Kleinvieh. ");
INSERT INTO deuelo_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Und das Erstgeborene vom Esel sollst du lösen mit einem Lamme; und wenn du es nicht lösest, so brich ihm das Genick. Jeden Erstgeborenen deiner Söhne sollst du lösen. Und man soll nicht leer erscheinen vor meinem Angesicht. - ");
INSERT INTO deuelo_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Sechs Tage sollst du arbeiten, aber am siebten Tage sollst du ruhen; in der Pflügezeit und in der Ernte sollst du ruhen. - ");
INSERT INTO deuelo_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Und das Fest der Wochen, der Erstlinge der Weizenernte, sollst du feiern; und das Fest der Einsammlung beim Umlauf des Jahres. - ");
INSERT INTO deuelo_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Dreimal im Jahre sollen alle deine Männlichen erscheinen vor dem Angesicht des Herrn Jehova, des Gottes Israels. ");
INSERT INTO deuelo_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Denn ich werde die Nationen vor dir austreiben und deine Grenze erweitern; und niemand wird deines Landes begehren, wenn du hinaufziehst, um vor dem Angesicht Jehovas, deines Gottes, zu erscheinen dreimal im Jahre. - ");
INSERT INTO deuelo_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Du sollst nicht das Blut meines Schlachtopfers zu Gesäuertem opfern; und das Schlachtopfer des Passahfestes soll nicht über Nacht bleiben bis an den Morgen. - ");
INSERT INTO deuelo_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Das Erste der Erstlinge deines Landes sollst du in das Haus Jehovas, deines Gottes, bringen. Du sollst ein Böcklein nicht kochen in der Milch seiner Mutter. ");
INSERT INTO deuelo_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Und Jehova sprach zu Mose: Schreibe dir diese Worte auf; denn nach dem Inhalt dieser Worte habe ich mit dir und mit Israel einen Bund gemacht. ");
INSERT INTO deuelo_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Und er war daselbst bei Jehova vierzig Tage und vierzig Nächte; er aß kein Brot und trank kein Wasser. Und er schrieb auf die Tafeln die Worte des Bundes, die zehn Worte. ");
INSERT INTO deuelo_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Und es Geschah, als Mose von dem Berge Sinai herabstieg, -und die zwei Tafeln des Zeugnisses waren in der Hand Moses, als er von dem Berge herabstieg, da wußte Mose nicht, daß die Haut seines Angesichts strahlte, weil er mit ihm geredet hatte. ");
INSERT INTO deuelo_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Und Aaron und alle Kinder Israel sahen Mose an, und siehe, die Haut seines Angesichts strahlte; und sie fürchteten sich, ihm zu nahen. ");
INSERT INTO deuelo_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Und Mose rief ihnen zu, und sie wandten sich zu ihm, Aaron und alle Fürsten in der Gemeinde; und Mose redete zu ihnen. ");
INSERT INTO deuelo_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Und danach nahten sich alle Kinder Israel; und er gebot ihnen alles, was Jehova auf dem Berge Sinai zu ihm geredet hatte. ");
INSERT INTO deuelo_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Und Mose hörte auf, mit ihnen zu reden. Und er hatte eine Decke auf sein Angesicht gelegt. ");
INSERT INTO deuelo_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Und wenn Mose vor Jehova hineinging, um mit ihm zu reden, tat er die Decke ab, bis er hinausging; und er ging hinaus und redete zu den Kindern Israel, was ihm geboten war; ");
INSERT INTO deuelo_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","und die Kinder Israel sahen das Angesicht Moses, daß die Haut des Angesichts Moses strahlte; und Mose tat die Decke wieder auf sein Angesicht, bis er hineinging, um mit ihm zu reden. ");
INSERT INTO deuelo_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Und Mose versammelte die ganze Gemeinde der Kinder Israel und sprach zu ihnen: Dies sind die Worte, die Jehova geboten hat, sie zu tun: ");
INSERT INTO deuelo_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Sechs Tage soll man Arbeit tun, aber am siebten Tage soll euch ein heiliger Tag sein, ein Sabbath der Ruhe dem Jehova; wer irgend an ihm eine Arbeit tut, soll getötet werden. ");
INSERT INTO deuelo_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Ihr sollt am Tage des Sabbaths kein Feuer anzünden in allen euren Wohnungen. ");
INSERT INTO deuelo_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Und Mose sprach zu der ganzen Gemeinde der Kinder Israel und sagte: Dies ist das Wort, das Jehova geboten hat, indem er sprach: ");
INSERT INTO deuelo_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Nehmet von euch ein Hebopfer für Jehova; jeder, der willigen Herzens ist, soll es bringen, das Hebopfer Jehovas: Gold und Silber und Erz ");
INSERT INTO deuelo_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","und blauen und roten Purpur und Karmesin und Byssus und Ziegenhaar ");
INSERT INTO deuelo_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","und rotgefärbte Widderfelle und Dachsfelle und Akazienholz ");
INSERT INTO deuelo_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","und Öl zum Licht und Gewürze zum Salböl und zum wohlriechenden Räucherwerk ");
INSERT INTO deuelo_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","und Onyxsteine und Steine zum Einsetzen für das Ephod und für das Brustschild. ");
INSERT INTO deuelo_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Und alle, die weisen Herzens sind unter euch, sollen kommen und alles machen, was Jehova geboten hat: ");
INSERT INTO deuelo_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","die Wohnung, ihr Zelt und ihre Decke, ihre Klammern und ihre Bretter, ihre Riegel, ihre Säulen und ihre Füße; ");
INSERT INTO deuelo_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","die Lade und ihre Stangen, den Deckel und den Scheidevorhang; ");
INSERT INTO deuelo_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","den Tisch und seine Stangen und alle seine Geräte und die Schaubrote; ");
INSERT INTO deuelo_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","und den Leuchter zum Licht und seine Geräte und seine Lampen und das Öl zum Licht; ");
INSERT INTO deuelo_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","und den Räucheraltar und seine Stangen und das Salböl und das wohlriechende Räucherwerk; und den Eingangsvorhang für den Eingang der Wohnung; ");
INSERT INTO deuelo_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","den Brandopferaltar und das eherne Gitter an demselben, seine Stangen und alle seine Geräte; das Becken und sein Gestell; ");
INSERT INTO deuelo_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","die Umhänge des Vorhofs, seine Säulen und seine Füße, und den Vorhang vom Tore des Vorhofs; ");
INSERT INTO deuelo_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","die Pflöcke der Wohnung und die Pflöcke des Vorhofs und ihre Seile; ");
INSERT INTO deuelo_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","die Dienstkleider zum Dienst im Heiligtum, die heiligen Kleider für Aaron, den Priester, und die Kleider seiner Söhne, um den Priesterdienst auszuüben. ");
INSERT INTO deuelo_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Und die ganze Gemeinde der Kinder Israel ging von Mose hinweg. ");
INSERT INTO deuelo_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Und sie kamen, ein jeder, den sein Herz trieb; und ein jeder, der willigen Geistes war, brachte das Hebopfer Jehovas für das Werk des Zeltes der Zusammenkunft und für all seine Arbeit und für die heiligen Kleider. ");
INSERT INTO deuelo_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Und die Männer kamen mit den Weibern; ein jeder, der willigen Herzens war, brachte Nasenringe und Ohrringe und Fingerringe und Spangen, allerlei goldene Geräte; und jeder, der dem Jehova ein Webopfer an Gold webte. ");
INSERT INTO deuelo_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Und ein jeder, bei dem sich blauer und roter Purpur fand, und Karmesin und Byssus und Ziegenhaar und rotgefärbte Widderfelle und Dachsfelle, brachte es. ");
INSERT INTO deuelo_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Jeder, der ein Hebopfer an Silber und Erz hob, brachte das Hebopfer Jehovas; und jeder, bei dem sich Akazienholz fand zu allerlei Werk der Arbeit, brachte es. ");
INSERT INTO deuelo_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Und alle Weiber, die weisen Herzens waren, spannen mit ihren Händen und brachten das Gespinst: den blauen und den roten Purpur, den Karmesin und den Byssus. ");
INSERT INTO deuelo_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Und alle verständigen Weiber, die ihr Herz trieb, spannen das Ziegenhaar. ");
INSERT INTO deuelo_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Und die Fürsten brachten Onyxsteine und Steine zum Einsetzen für das Ephod und für das Brustschild, ");
INSERT INTO deuelo_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","und das Gewürz und das Öl zum Licht und zum Salböl und zum wohlriechenden Räucherwerk. ");
INSERT INTO deuelo_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Die Kinder Israel, alle Männer und Weiber, die willigen Herzens waren, um zu all dem Werke zu bringen, das Jehova durch Mose zu machen geboten hatte, brachten eine freiwillige Gabe dem Jehova. ");
INSERT INTO deuelo_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Und Mose sprach zu den Kindern Israel: Sehet, Jehova hat Bezaleel, den Sohn Uris, des Sohnes Hurs, vom Stamme Juda, mit Namen berufen ");
INSERT INTO deuelo_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","und hat ihn mit dem Geiste Gottes erfüllt, in Weisheit, in Verstand und in Kenntnis und in jeglichem Werke; ");
INSERT INTO deuelo_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","und zwar um Künstliches zu ersinnen, zu arbeiten in Gold und in Silber und in Erz, ");
INSERT INTO deuelo_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","und im Schneiden von Steinen zum Einsetzen und im Holzschneiden, um zu arbeiten in jeglichem Kunstwerk; ");
INSERT INTO deuelo_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","und zu unterweisen hat er ihm ins Herz gelegt, ihm und Oholiab, dem Sohne Achisamaks, vom Stamme Dan. ");
INSERT INTO deuelo_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Er hat sie mit Weisheit des Herzens erfüllt, um jegliches Werk des Künstlers und des Kunstwebers und des Buntwirkers zu machen, in blauem und rotem Purpur und Karmesin und Byssus, und des Webers; derer, die allerlei Werk machen und Künstliches ersinnen. ");
INSERT INTO deuelo_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Und Bezaleel und Oholiab und alle Männer, die weisen Herzens waren, in welche Jehova Weisheit und Verstand gelegt hatte, damit sie alles Werk der Arbeit des Heiligtums zu machen wüßten, taten nach allem, was Jehova geboten hatte. ");
INSERT INTO deuelo_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Und Mose rief Bezaleel und Oholiab und jeden Mann, der weisen Herzens war, in dessen Herz Gott Weisheit gelegt hatte, jeden, den sein Herz trieb, ans Werk zu gehen, um es zu machen. ");
INSERT INTO deuelo_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Und sie nahmen von Mose das ganze Hebopfer, das die Kinder Israel gebracht hatten zum Werke der Arbeit des Heiligtums, um es zu machen; und diese brachten ihm noch freiwillige Gaben, Morgen für Morgen. ");
INSERT INTO deuelo_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Und es kamen alle weisen Männer, die alles Werk des Heiligtums machten, ein jeder von seinem Werke, das sie machten, ");
INSERT INTO deuelo_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","und sprachen zu Mose und sagten: Das Volk bringt viel, mehr als genug für die Arbeit des Werkes, das Jehova zu machen geboten hat. ");
INSERT INTO deuelo_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Da gebot Mose, und man ließ einen Ruf durchs Lager ergehen also: Weder Mann noch Weib soll ferner ein Werk machen für das Hebopfer des Heiligtums! Und so wurde dem Volke das Bringen gewehrt. ");
INSERT INTO deuelo_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Und des Verfertigten war genug für das ganze Werk, um es zu machen; und es war übrig. ");
INSERT INTO deuelo_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Und alle, die weisen Herzens waren unter den Arbeitern des Werkes, machten die Wohnung aus zehn Teppichen; von gezwirntem Byssus und blauem und rotem Purpur und Karmesin, mit Cherubim in Kunstweberarbeit machte er sie. ");
INSERT INTO deuelo_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Die Länge eines Teppichs war achtundzwanzig Ellen, und vier Ellen die Breite eines Teppichs: ein Maß für alle Teppiche. ");
INSERT INTO deuelo_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Und er fügte fünf Teppiche zusammen, einen an den anderen, und er fügte wieder fünf Teppiche zusammen, einen an den anderen. ");
INSERT INTO deuelo_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Und er machte Schleifen von blauem Purpur an den Saum des einen Teppichs am Ende, bei der Zusammenfügung; also machte er es an dem Saume des äußersten Teppichs bei der anderen Zusammenfügung. ");
INSERT INTO deuelo_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Fünfzig Schleifen machte er an den einen Teppich, und fünfzig Schleifen machte er an das Ende des Teppichs, der bei der anderen Zusammenfügung war, die Schleifen eine der anderen gegenüber. ");
INSERT INTO deuelo_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Und er machte fünfzig Klammern von Gold und fügte die Teppiche zusammen, einen an den anderen, mit den Klammern, so daß die Wohnung ein Ganzes wurde. ");
INSERT INTO deuelo_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Und er machte Teppiche von Ziegenhaar zum Zelte über die Wohnung; elf solcher Teppiche machte er. ");
INSERT INTO deuelo_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Die Länge eines Teppichs war dreißig Ellen, und vier Ellen die Breite eines Teppichs: ein Maß für die elf Teppiche. ");
INSERT INTO deuelo_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Und er fügte zusammen fünf Teppiche besonders und sechs Teppiche besonders. ");
INSERT INTO deuelo_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Und er machte fünfzig Schleifen an den Saum des äußersten Teppichs bei der Zusammenfügung, und fünfzig Schleifen machte er an den Saum des Teppichs der anderen Zusammenfügung. ");
INSERT INTO deuelo_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Und er machte fünfzig Klammern von Erz, um das Zelt zusammenzufügen, so daß es ein Ganzes wurde. ");
INSERT INTO deuelo_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Und er machte für das Zelt eine Decke von rotgefärbten Widderfellen und eine Decke von Dachsfellen oben darüber. ");
INSERT INTO deuelo_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Und er machte die Bretter zu der Wohnung von Akazienholz, aufrechtstehend: ");
INSERT INTO deuelo_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","zehn Ellen die Länge eines Brettes, und eine und eine halbe Elle die Breite eines Brettes; ");
INSERT INTO deuelo_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","zwei Zapfen an einem Brette, einer dem anderen gegenüber eingefügt: also machte er es an allen Brettern der Wohnung. ");
INSERT INTO deuelo_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Und er machte die Bretter zu der Wohnung: zwanzig Bretter an der Seite gegen Mittag, südwärts; ");
INSERT INTO deuelo_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","und er machte vierzig Füße von Silber unter die zwanzig Bretter: zwei Füße unter ein Brett für seine zwei Zapfen, und wieder zwei Füße unter ein Brett für seine zwei Zapfen; ");
INSERT INTO deuelo_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","und an der anderen Seite der Wohnung, an der Nordseite, machte er zwanzig Bretter, ");
INSERT INTO deuelo_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","und ihre vierzig Füße von Silber: zwei Füße unter ein Brett, und wieder zwei Füße unter ein Brett; ");
INSERT INTO deuelo_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","und an der Hinterseite der Wohnung gegen Westen machte er sechs Bretter; ");
INSERT INTO deuelo_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","und zwei Bretter machte er für die Winkel der Wohnung an der Hinterseite; ");
INSERT INTO deuelo_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","und sie waren zweifach von unten auf und waren an ihrem Oberteil völlig aneinander in einem Ringe; also machte er es mit ihnen beiden an den beiden Winkeln. ");
INSERT INTO deuelo_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Und es waren acht Bretter, und ihre Füße von Silber: sechzehn Füße, je zwei Füße unter einem Brette. ");
INSERT INTO deuelo_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Und er machte Riegel von Akazienholz: fünf zu den Brettern der einen Seite der Wohnung, ");
INSERT INTO deuelo_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","und fünf Riegel zu den Brettern der anderen Seite der Wohnung, und fünf Riegel zu den Brettern der Wohnung an der Hinterseite gegen Westen; ");
INSERT INTO deuelo_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","und er machte den mittleren Riegel in der Mitte der Bretter durchlaufend von einem Ende zum anderen. ");
INSERT INTO deuelo_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Und er überzog die Bretter mit Gold; und ihre Ringe, die Behälter für die Riegel, machte er von Gold, und überzog die Riegel mit Gold. ");
INSERT INTO deuelo_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Und er machte den Vorhang von blauem und rotem Purpur und Karmesin und gezwirntem Byssus; in Kunstweberarbeit machte er ihn, mit Cherubim. ");
INSERT INTO deuelo_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Und er machte zu demselben vier Säulen von Akazienholz und überzog sie mit Gold, ihre Haken von Gold, und er goß zu denselben vier Füße von Silber. ");
INSERT INTO deuelo_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Und er machte für den Eingang des Zeltes einen Vorhang von blauem und rotem Purpur und Karmesin und gezwirntem Byssus, in Buntwirkerarbeit; ");
INSERT INTO deuelo_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","und seine fünf Säulen und ihre Haken; und er überzog ihre Köpfe und ihre Bindestäbe mit Gold; und ihre fünf Füße waren von Erz. ");
INSERT INTO deuelo_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Und Bezaleel machte die Lade von Akazienholz: zwei und eine halbe Elle ihre Länge, und eine und eine halbe Elle ihre Breite, und eine und eine halbe Elle ihre Höhe. ");
INSERT INTO deuelo_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Und er überzog sie mit reinem Golde inwendig und auswendig, und machte einen goldenen Kranz daran ringsum. ");
INSERT INTO deuelo_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Und er goß für dieselbe vier Ringe von Gold an ihre vier Ecken, zwei Ringe an ihrer einen Seite und zwei Ringe an ihrer anderen Seite. ");
INSERT INTO deuelo_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Und er machte Stangen von Akazienholz und überzog sie mit Gold. ");
INSERT INTO deuelo_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Und er brachte die Stangen in die Ringe an den Seiten der Lade, um die Lade zu tragen. ");
INSERT INTO deuelo_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Und er machte einen Deckel von reinem Golde: zwei und eine halbe Elle seine Länge, und eine und eine halbe Elle seine Breite. ");
INSERT INTO deuelo_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Und er machte zwei Cherubim von Gold; in getriebener Arbeit machte er sie, an beiden Enden des Deckels: ");
INSERT INTO deuelo_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","einen Cherub an dem Ende der einen Seite und einen Cherub an dem Ende der anderen Seite; aus dem Deckel machte er die Cherubim, aus seinen beiden Enden. ");
INSERT INTO deuelo_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Und die Cherubim breiteten die Flügel aus nach oben, den Deckel mit ihren Flügeln überdeckend, und ihre Angesichter waren einander gegenüber; die Angesichter der Cherubim waren gegen den Deckel gerichtet. ");
INSERT INTO deuelo_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Und er machte den Tisch von Akazienholz: zwei Ellen seine Länge und eine Elle seine Breite, und eine und eine halbe Elle seine Höhe. ");
INSERT INTO deuelo_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Und er überzog ihn mit reinem Golde und machte ihm einen Kranz von Gold ringsum. ");
INSERT INTO deuelo_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Und er machte ihm eine Leiste, eine Hand breit, ringsum und machte einen Kranz von Gold an seiner Leiste ringsum. ");
INSERT INTO deuelo_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Und er goß für denselben vier Ringe von Gold und setzte die Ringe an die vier Ecken, die an seinen vier Füßen waren. ");
INSERT INTO deuelo_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Dicht bei der Leiste waren die Ringe, als Behälter für die Stangen, um den Tisch zu tragen. ");
INSERT INTO deuelo_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Und er machte die Stangen von Akazienholz und überzog sie mit Gold, um den Tisch zu tragen. ");
INSERT INTO deuelo_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Und er machte die Geräte, die auf dem Tische waren: seine Schüsseln und seine Schalen und seine Spendschalen und die Kannen, mit welchen das Trankopfer ausgegossen wird, von reinem Golde. ");
INSERT INTO deuelo_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Und er machte den Leuchter von reinem Golde; in getriebener Arbeit machte er den Leuchter, seinen Fuß und seinen Schaft; seine Kelche, seine Knäufe und seine Blumen waren aus ihm. ");
INSERT INTO deuelo_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Und sechs Arme gingen von seinen Seiten aus: drei Arme des Leuchters aus seiner einen Seite und drei Arme des Leuchters aus seiner anderen Seite. ");
INSERT INTO deuelo_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Drei Kelche, mandelblütenförmig, an dem einen Arme: Knauf und Blume; und drei Kelche, mandelblütenförmig, an dem anderen Arme: Knauf und Blume; also für die sechs Arme, die von dem Leuchter ausgingen. ");
INSERT INTO deuelo_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Und an dem Leuchter vier Kelche, mandelblütenförmig: seine Knäufe und seine Blumen; ");
INSERT INTO deuelo_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","und zwar ein Knauf unter zwei Armen aus ihm, und wieder ein Knauf unter zwei Armen aus ihm, und wieder ein Knauf unter zwei Armen aus ihm, für die sechs Arme, die von ihm ausgingen. ");
INSERT INTO deuelo_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Ihre Knäufe und ihre Arme waren aus ihm; der ganze Leuchter eine getriebene Arbeit von reinem Golde. ");
INSERT INTO deuelo_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Und er machte seine sieben Lampen und seine Lichtschneuzen und seine Löschnäpfe von reinem Golde. ");
INSERT INTO deuelo_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Aus einem Talent reinen Goldes machte er ihn und alle seine Geräte. ");
INSERT INTO deuelo_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Und er machte den Räucheraltar von Akazienholz: eine Elle seine Länge, und eine Elle seine Breite, quadratförmig, und zwei Ellen seine Höhe; aus ihm waren seine Hörner. ");
INSERT INTO deuelo_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Und er überzog ihn mit reinem Golde, seine Platte und seine Wände ringsum und seine Hörner; und er machte ihm einen Kranz von Gold ringsum. ");
INSERT INTO deuelo_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Und er machte ihm zwei Ringe von Gold, unter seinen Kranz, an seine beiden Seiten, an seine beiden Wände, zu Behältern für die Stangen, um ihn mit denselben zu tragen. ");
INSERT INTO deuelo_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Und er machte die Stangen von Akazienholz und überzog sie mit Gold. ");
INSERT INTO deuelo_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Und er machte das heilige Salböl und das reine wohlriechende Räucherwerk, ein Werk des Salbenmischers. ");
INSERT INTO deuelo_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Und er machte den Brandopferaltar von Akazienholz: fünf Ellen seine Länge, und fünf Ellen seine Breite, quadratförmig, und drei Ellen seine Höhe; ");
INSERT INTO deuelo_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","und er machte seine Hörner an seine vier Ecken; aus ihm waren seine Hörner; und er überzog ihn mit Erz. ");
INSERT INTO deuelo_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Und er machte alle die Geräte des Altars: die Töpfe und die Schaufeln und die Sprengschalen, die Gabeln und die Kohlenpfannen; alle seine Geräte machte er von Erz. ");
INSERT INTO deuelo_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Und er machte dem Altar ein Gitter von Netzwerk aus Erz, unter seiner Einfassung, unterwärts, bis zu seiner Hälfte. ");
INSERT INTO deuelo_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Und er goß vier Ringe an die vier Ecken des ehernen Gitters als Behälter für die Stangen. ");
INSERT INTO deuelo_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Und er machte die Stangen von Akazienholz und überzog sie mit Erz. ");
INSERT INTO deuelo_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Und er brachte die Stangen in die Ringe, an die Seiten des Altars, um ihn mit denselben zu tragen; hohl, von Brettern machte er ihn. ");
INSERT INTO deuelo_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Und er machte das Becken von Erz und sein Gestell von Erz, von den Spiegeln der sich scharenden Weiber, die sich scharten am Eingang des Zeltes der Zusammenkunft. ");
INSERT INTO deuelo_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Und er machte den Vorhof: an der Mittagseite, südwärts, die Umhänge des Vorhofs von gezwirntem Byssus, hundert Ellen; ");
INSERT INTO deuelo_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","ihre zwanzig Säulen und ihre zwanzig Füße von Erz, die Haken der Säulen und ihre Bindestäbe von Silber. ");
INSERT INTO deuelo_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Und an der Nordseite hundert Ellen; ihre zwanzig Säulen und ihre zwanzig Füße von Erz, die Haken der Säulen und ihre Bindestäbe von Silber. ");
INSERT INTO deuelo_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Und an der Westseite fünfzig Ellen Umhänge; ihre zehn Säulen und ihre zehn Füße, die Haken der Säulen und ihre Bindestäbe von Silber. ");
INSERT INTO deuelo_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Und an der Ostseite gegen Aufgang, fünfzig Ellen: ");
INSERT INTO deuelo_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","fünfzehn Ellen Umhänge auf der einen Seite, ihre drei Säulen und ihre drei Füße; ");
INSERT INTO deuelo_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","und auf der anderen Seite, diesseit und jenseit vom Tore des Vorhofs fünfzehn Ellen Umhänge, ihre drei Säulen und ihre drei Füße. ");
INSERT INTO deuelo_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Alle Umhänge des Vorhofs ringsum waren von gezwirntem Byssus; ");
INSERT INTO deuelo_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","und die Füße der Säulen von Erz, die Haken der Säulen und ihre Bindestäbe von Silber und der Überzug ihrer Köpfe von Silber; und die Säulen des Vorhofs waren alle mit Bindestäben von Silber versehen. ");
INSERT INTO deuelo_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Und den Vorhang vom Tore des Vorhofs machte er in Buntwirkerarbeit, von blauem und rotem Purpur und Karmesin und gezwirntem Byssus; und zwar zwanzig Ellen die Länge; und die Höhe, in der Breite, fünf Ellen, gerade wie die Umhänge des Vorhofs; ");
INSERT INTO deuelo_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","und ihre vier Säulen und ihre vier Füße waren von Erz, ihre Haken von Silber und der Überzug ihrer Köpfe und ihre Bindestäbe von Silber. ");
INSERT INTO deuelo_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Und alle Pflöcke zur Wohnung und zum Vorhof ringsum waren von Erz. ");
INSERT INTO deuelo_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Dies ist die Berechnung der Wohnung, der Wohnung des Zeugnisses, die berechnet wurde auf Befehl Moses, durch den Dienst der Leviten unter der Hand Ithamars, des Sohnes Aarons, des Priesters; - ");
INSERT INTO deuelo_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","und Bezaleel, der Sohn Uris, des Sohnes Hurs, vom Stamme Juda, machte alles, was Jehova dem Mose geboten hatte; ");
INSERT INTO deuelo_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","und mit ihm Oholiab, der Sohn Achisamaks, vom Stamme Dan, ein Künstler und Kunstweber und Buntwirker in blauem und rotem Purpur und Karmesin und Byssus: - ");
INSERT INTO deuelo_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Alles Gold, das zum Werke verwendet wurde an dem ganzen Werke des Heiligtums, das Gold des Webopfers, betrug neunundzwanzig Talente und siebenhundertdreißig Sekel, nach dem Sekel des Heiligtums. ");
INSERT INTO deuelo_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Und das Silber von den Gemusterten der Gemeinde betrug hundert Talente und tausend siebenhundertfünfundsiebzig Sekel, nach dem Sekel des Heiligtums: ");
INSERT INTO deuelo_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","ein Beka auf den Kopf, die Hälfte eines Sekels, nach dem Sekel des Heiligtums, von einem jeden, der zu den Gemusterten überging, von zwanzig Jahren und darüber, von sechshundert dreitausend fünfhundertfünfzig Mann. ");
INSERT INTO deuelo_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Und die hundert Talente Silber waren zum Gießen der Füße des Heiligtums und der Füße des Vorhanges, hundert Füße auf hundert Talente, ein Talent auf einen Fuß. ");
INSERT INTO deuelo_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Und von den tausend siebenhundertfünfundsiebzig Sekeln machte er die Haken für die Säulen und überzog ihre Köpfe und verband sie mit Stäben. ");
INSERT INTO deuelo_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Und das Erz des Webopfers betrug siebzig Talente und zweitausendvierhundert Sekel. ");
INSERT INTO deuelo_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Und er machte daraus die Füße vom Eingang des Zeltes der Zusammenkunft und den ehernen Altar und sein ehernes Gitter und alle Geräte des Altars; ");
INSERT INTO deuelo_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","und die Füße des Vorhofs ringsum und die Füße vom Tore des Vorhofs und alle Pflöcke der Wohnung und alle Pflöcke des Vorhofs ringsum. ");
INSERT INTO deuelo_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Und aus dem blauen und dem roten Purpur und dem Karmesin machten sie die Dienstkleider zum Dienst im Heiligtum, und sie machten die heiligen Kleider für Aaron, so wie Jehova dem Mose geboten hatte. ");
INSERT INTO deuelo_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Und man machte das Ephod von Gold, blauem und rotem Purpur und Karmesin und gezwirntem Byssus. ");
INSERT INTO deuelo_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Und sie plätteten Goldbleche, und man zerschnitt sie zu Fäden, zum Verarbeiten unter den blauen und unter den roten Purpur und unter den Karmesin und unter den Byssus, in Kunstweberarbeit. ");
INSERT INTO deuelo_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Sie machten zusammenfügende Schulterstücke daran: an seinen beiden Enden wurde es zusammengefügt. ");
INSERT INTO deuelo_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Und der gewirkte Gürtel, mit dem es angebunden wurde, der darüber war, war von gleichem Stoffe, von gleicher Arbeit mit ihm: von Gold, blauem und rotem Purpur und Karmesin und gezwirntem Byssus: so wie Jehova dem Mose geboten hatte. ");
INSERT INTO deuelo_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Und sie machten die Onyxsteine, umgeben mit Einfassungen von Gold, gestochen in Siegelstecherei, nach den Namen der Söhne Israels. ");
INSERT INTO deuelo_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Und man setzte sie auf die Schulterstücke des Ephods, als Steine des Gedächtnisses für die Kinder Israel: so wie Jehova dem Mose geboten hatte. ");
INSERT INTO deuelo_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Und er machte das Brustschild in Kunstweberarbeit, gleich der Arbeit des Ephods: von Gold, blauem und rotem Purpur und Karmesin und gezwirntem Byssus. ");
INSERT INTO deuelo_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Es war quadratförmig; das Brustschild machten sie gedoppelt, eine Spanne seine Länge und eine Spanne seine Breite, gedoppelt. ");
INSERT INTO deuelo_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Und sie besetzten es mit vier Reihen von Steinen; eine Reihe: Sardis, Topas und Smaragd, die erste Reihe; ");
INSERT INTO deuelo_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","und die zweite Reihe: Karfunkel, Saphir und Diamant; ");
INSERT INTO deuelo_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","und die dritte Reihe: Opal, Achat und Amethyst; ");
INSERT INTO deuelo_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","und die vierte Reihe: Chrysolith, Onyx und Jaspis; umgeben mit Einfassungen von Gold in ihren Einsetzungen. ");
INSERT INTO deuelo_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Und der Steine waren nach den Namen der Söhne Israels zwölf, nach ihren Namen; in Siegelstecherei, ein jeder nach seinem Namen, für die zwölf Stämme. ");
INSERT INTO deuelo_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Und sie machten an das Brustschild schnurähnliche Ketten, in Flechtwerk, von reinem Golde. ");
INSERT INTO deuelo_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Und sie machten zwei Einfassungen von Gold und zwei Ringe von Gold und befestigten die zwei Ringe an die beiden Enden des Brustschildes. ");
INSERT INTO deuelo_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Und die zwei geflochtenen Schnüre von Gold befestigten sie an die beiden Ringe an den Enden des Brustschildes; ");
INSERT INTO deuelo_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","und die beiden anderen Enden der zwei geflochtenen Schnüre befestigten sie an die beiden Einfassungen und befestigten sie an die Schulterstücke des Ephods, an seine Vorderseite. ");
INSERT INTO deuelo_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Und sie machten zwei Ringe von Gold und befestigten sie an die beiden Enden des Brustschildes, an seinen Saum, der gegen das Ephod hin war, einwärts; ");
INSERT INTO deuelo_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","und sie machten zwei Ringe von Gold und befestigten sie an die beiden Schulterstücke des Ephods, unten an seine Vorderseite, gerade bei seiner Zusammenfügung, oberhalb des gewirkten Gürtels des Ephods. ");
INSERT INTO deuelo_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Und sie banden das Brustschild mit seinen Ringen an die Ringe des Ephods mit einer purpurblauen Schnur, daß es über dem gewirkten Gürtel des Ephods wäre und das Brustschild sich nicht von dem Ephod verrückte: so wie Jehova dem Mose geboten hatte. ");
INSERT INTO deuelo_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Und er machte das Oberkleid des Ephods in Weberarbeit, ganz von blauem Purpur. ");
INSERT INTO deuelo_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Und die Öffnung des Oberkleides war in seiner Mitte, wie die Öffnung eines Panzers; eine Borte hatte es an seiner Öffnung ringsum, damit es nicht einrisse. ");
INSERT INTO deuelo_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Und sie machten an den Saum des Oberkleides Granatäpfel von blauem und rotem Purpur und Karmesin, gezwirnt. ");
INSERT INTO deuelo_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Und sie machten Schellen von reinem Golde und setzten die Schellen zwischen die Granatäpfel an den Saum des Oberkleides ringsum, zwischen die Granatäpfel: ");
INSERT INTO deuelo_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","eine Schelle und einen Granatapfel, eine Schelle und einen Granatapfel an den Saum des Oberkleides ringsum, um den Dienst zu verrichten: so wie Jehova dem Mose geboten hatte. ");
INSERT INTO deuelo_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Und sie machten die Leibröcke von Byssus, in Weberarbeit, für Aaron und für seine Söhne; ");
INSERT INTO deuelo_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","und den Kopfbund von Byssus, und den Kopfschmuck der hohen Mützen von Byssus, und die leinenen Beinkleider von gezwirntem Byssus, ");
INSERT INTO deuelo_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","und den Gürtel von gezwirntem Byssus und von blauem und rotem Purpur und Karmesin, in Buntwirkerarbeit: so wie Jehova dem Mose geboten hatte. ");
INSERT INTO deuelo_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Und sie machten das Blech, das heilige Diadem, von reinem Golde, und schrieben darauf mit Siegelstecherschrift: Heiligkeit dem Jehova! ");
INSERT INTO deuelo_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Und sie taten daran eine Schnur von blauem Purpur, um es oben an den Kopfbund zu befestigen: so wie Jehova dem Mose geboten hatte. ");
INSERT INTO deuelo_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Und es wurde vollendet die ganze Arbeit der Wohnung des Zeltes der Zusammenkunft; und die Kinder Israel taten nach allem, was Jehova dem Mose geboten hatte, also taten sie. ");
INSERT INTO deuelo_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Und sie brachten die Wohnung zu Mose: Das Zelt und alle seine Geräte, seine Klammern, seine Bretter, seine Riegel und seine Säulen und seine Füße; ");
INSERT INTO deuelo_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","und die Decke von rotgefärbten Widderfellen und die Decke von Dachsfellen und den Scheidevorhang; ");
INSERT INTO deuelo_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","die Lade des Zeugnisses und ihre Stangen und den Deckel; ");
INSERT INTO deuelo_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","den Tisch, alle seine Geräte und die Schaubrote; ");
INSERT INTO deuelo_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","den reinen Leuchter, seine Lampen, die zuzurichtenden Lampen, und alle seine Geräte und das Öl zum Licht; ");
INSERT INTO deuelo_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","und den goldenen Altar und das Salböl und das wohlriechende Räucherwerk; und den Vorhang vom Eingange des Zeltes; ");
INSERT INTO deuelo_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","den ehernen Altar und sein ehernes Gitter, seine Stangen und alle seine Geräte; das Becken und sein Gestell; ");
INSERT INTO deuelo_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","die Umhänge des Vorhofs, seine Säulen und seine Füße; und den Vorhang für das Tor des Vorhofs, seine Seile und seine Pflöcke; und alle Geräte zum Dienst der Wohnung des Zeltes der Zusammenkunft; ");
INSERT INTO deuelo_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","die Dienstkleider zum Dienst im Heiligtum, die heiligen Kleider für Aaron, den Priester, und die Kleider seiner Söhne, um den Priesterdienst auszuüben. ");
INSERT INTO deuelo_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Nach allem, was Jehova dem Mose geboten hatte, also hatten die Kinder Israel die ganze Arbeit gemacht. ");
INSERT INTO deuelo_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Und Mose sah das ganze Werk, und siehe, sie hatten es gemacht; so wie Jehova geboten hatte, also hatten sie es gemacht; und Mose segnete sie. ");
INSERT INTO deuelo_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","Am Tage des ersten Monats, am Ersten des Monats, sollst du die Wohnung des Zeltes der Zusammenkunft aufrichten. ");
INSERT INTO deuelo_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Und du sollst die Lade des Zeugnisses darein stellen und die Lade mit dem Vorhang verdecken. ");
INSERT INTO deuelo_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Und bringe den Tisch hinein und richte zu, was auf ihm zuzurichten ist; und bringe den Leuchter hinein und zünde seine Lampen an. ");
INSERT INTO deuelo_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Und stelle den goldenen Altar zum Räucherwerk vor die Lade des Zeugnisses, und hänge den Vorhang des Eingangs zur Wohnung auf. ");
INSERT INTO deuelo_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Und stelle den Brandopferaltar vor den Eingang der Wohnung des Zeltes der Zusammenkunft. ");
INSERT INTO deuelo_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Und stelle das Becken zwischen das Zelt der Zusammenkunft und den Altar, und tue Wasser darein. ");
INSERT INTO deuelo_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Und richte den Vorhof auf ringsum und hänge den Vorhang vom Tore des Vorhofs auf. ");
INSERT INTO deuelo_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Und nimm das Salböl und salbe die Wohnung und alles, was darin ist, und heilige sie und alle ihre Geräte; und sie soll heilig sein. ");
INSERT INTO deuelo_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Und salbe den Brandopferaltar und alle seine Geräte, und heilige den Altar; und der Altar soll hochheilig sein. ");
INSERT INTO deuelo_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Und salbe das Becken und sein Gestell, und heilige es. ");
INSERT INTO deuelo_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Und laß Aaron und seine Söhne herzunahen an den Eingang des Zeltes der Zusammenkunft und wasche sie mit Wasser. ");
INSERT INTO deuelo_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Und bekleide Aaron mit den heiligen Kleidern und salbe ihn und heilige ihn, daß er mir den Priesterdienst ausübe. ");
INSERT INTO deuelo_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Und seine Söhne sollst du herzunahen lassen und sie mit den Leibröcken bekleiden. ");
INSERT INTO deuelo_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Und du sollst sie salben, so wie du ihren Vater gesalbt hast, daß sie mir den Priesterdienst ausüben. Und ihre Salbung soll geschehen, um ihnen zu einem ewigen Priestertum zu sein bei ihren Geschlechtern. ");
INSERT INTO deuelo_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Und Mose tat es; nach allem, was Jehova ihm geboten hatte, also tat er. ");
INSERT INTO deuelo_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Und es geschah im ersten Monat, im zweiten Jahre, am Ersten des Monats, da wurde die Wohnung aufgerichtet. ");
INSERT INTO deuelo_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Und Mose richtete die Wohnung auf und setzte ihre Füße und stellte ihre Bretter auf und setzte ihre Riegel ein und richtete ihre Säulen auf; ");
INSERT INTO deuelo_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","und er breitete das Zelt über die Wohnung und legte die Decke des Zeltes oben darüber: so wie Jehova dem Mose geboten hatte. ");
INSERT INTO deuelo_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Und er nahm das Zeugnis und legte es in die Lade und tat die Stangen an die Lade und legte den Deckel auf die Lade, oben darauf; ");
INSERT INTO deuelo_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","und er brachte die Lade in die Wohnung und hing den Scheidevorhang auf und verdeckte die Lade des Zeugnisses: so wie Jehova dem Mose geboten hatte. ");
INSERT INTO deuelo_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Und er setzte den Tisch in das Zelt der Zusammenkunft an die Seite der Wohnung gegen Norden, außerhalb des Vorhangs; ");
INSERT INTO deuelo_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","und er richtete darauf eine Brotschicht zu vor Jehova: so wie Jehova dem Mose geboten hatte. ");
INSERT INTO deuelo_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Und er stellte den Leuchter in das Zelt der Zusammenkunft, dem Tische gegenüber, an die Seite der Wohnung gegen Mittag, ");
INSERT INTO deuelo_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","und er zündete die Lampen an vor Jehova: so wie Jehova dem Mose geboten hatte. ");
INSERT INTO deuelo_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Und er stellte den goldenen Altar in das Zelt der Zusammenkunft vor den Vorhang ");
INSERT INTO deuelo_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","und räucherte darauf wohlriechendes Räucherwerk: so wie Jehova dem Mose geboten hatte. ");
INSERT INTO deuelo_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Und er hing den Vorhang des Eingangs zur Wohnung auf. ");
INSERT INTO deuelo_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Und den Brandopferaltar stellte er an den Eingang der Wohnung des Zeltes der Zusammenkunft, und er opferte darauf das Brandopfer und das Speisopfer: so wie Jehova dem Mose geboten hatte. ");
INSERT INTO deuelo_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Und er stellte das Becken zwischen das Zelt der Zusammenkunft und den Altar und tat Wasser darein zum Waschen. ");
INSERT INTO deuelo_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Und Mose und Aaron und seine Söhne wuschen daraus ihre Hände und ihre Füße; ");
INSERT INTO deuelo_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","wenn sie in das Zelt der Zusammenkunft hineingingen und wenn sie dem Altar nahten, wuschen sie sich, so wie Jehova dem Mose geboten hatte. ");
INSERT INTO deuelo_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Und er richtete den Vorhof auf, rings um die Wohnung und um den Altar und hing den Vorhang vom Tore des Vorhofs auf. Und so vollendete Mose das Werk. ");
INSERT INTO deuelo_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Und die Wolke bedeckte das Zelt der Zusammenkunft, und die Herrlichkeit Jehovas erfüllte die Wohnung. ");
INSERT INTO deuelo_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Und Mose konnte nicht in das Zelt der Zusammenkunft hineingehen; denn die Wolke ruhte darauf, und die Herrlichkeit Jehovas erfüllte die Wohnung. ");
INSERT INTO deuelo_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Und wenn die Wolke sich von der Wohnung erhob, so brachen die Kinder Israel auf, auf allen ihren Zügen. ");
INSERT INTO deuelo_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Und wenn die Wolke sich nicht erhob, so brachen sie nicht auf, bis zu dem Tage, da sie sich erhob. ");
INSERT INTO deuelo_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Denn die Wolke Jehovas war des Tages auf der Wohnung, und des Nachts war ein Feuer darin vor den Augen des ganzen Hauses Israel, auf allen ihren Zügen. ");
INSERT INTO deuelo_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Und Jehova rief Mose, und er redete zu ihm aus dem Zelte der Zusammenkunft und sprach: ");
INSERT INTO deuelo_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Rede zu den Kindern Israel und sprich zu ihnen: Wenn ein Mensch von euch dem Jehova eine Opfergabe darbringen will, so sollt ihr vom Vieh, vom Rind-und Kleinvieh, eure Opfergabe darbringen. ");
INSERT INTO deuelo_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Wenn seine Opfergabe ein Brandopfer ist vom Rindvieh, so soll er sie darbringen, ein Männliches ohne Fehl; an dem Eingang des Zeltes der Zusammenkunft soll er sie darbringen, zum Wohlgefallen für ihn vor Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Und er soll seine Hand auf den Kopf des Brandopfers legen, und es wird wohlgefällig für ihn sein, um Sühnung für ihn zu tun. ");
INSERT INTO deuelo_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Und er soll das junge Rind schlachten vor Jehova; und die Söhne Aarons, die Priester, sollen das Blut herzubringen und das Blut ringsum an den Altar sprengen, der an dem Eingang des Zeltes der Zusammenkunft ist. ");
INSERT INTO deuelo_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Und er soll dem Brandopfer die Haut abziehen und es in seine Stücke zerlegen. ");
INSERT INTO deuelo_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Und die Söhne Aarons, des Priesters, sollen Feuer auf den Altar legen und Holz auf dem Feuer zurichten; ");
INSERT INTO deuelo_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","und die Söhne Aarons, die Priester, sollen die Stücke, den Kopf und das Fett auf dem Holze zurichten über dem Feuer, das auf dem Altar ist. ");
INSERT INTO deuelo_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Und sein Eingeweide und seine Schenkel soll er mit Wasser waschen; und der Priester soll das Ganze auf dem Altar räuchern: es ist ein Brandopfer, ein Feueropfer lieblichen Geruchs dem Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Und wenn seine Opfergabe vom Kleinvieh ist, von den Schafen oder von den Ziegen, zum Brandopfer, so soll er sie darbringen, ein Männliches ohne Fehl. ");
INSERT INTO deuelo_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Und er soll es schlachten an der Seite des Altars gegen Norden, vor Jehova; und die Söhne Aarons, die Priester, sollen sein Blut an den Altar sprengen ringsum. ");
INSERT INTO deuelo_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Und er soll es in seine Stücke zerlegen mit seinem Kopf und seinem Fett; und der Priester soll sie auf dem Holze zurichten, über dem Feuer, das auf dem Altar ist. ");
INSERT INTO deuelo_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Und das Eingeweide und die Schenkel soll er mit Wasser waschen; und der Priester soll das Ganze darbringen und auf dem Altar räuchern: es ist ein Brandopfer, ein Feueropfer lieblichen Geruchs dem Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Und wenn ein Brandopfer vom Geflügel seine Opfergabe ist dem Jehova, so soll er von den Turteltauben oder von den jungen Tauben seine Opfergabe darbringen. ");
INSERT INTO deuelo_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Und der Priester bringe sie zum Altar und kneipe ihr den Kopf ein und räuchere sie auf dem Altar, und ihr Blut soll ausgedrückt werden an die Wand des Altars. ");
INSERT INTO deuelo_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Und er trenne ihren Kropf mit seinem Unrat ab und werfe ihn neben den Altar gegen Osten, an den Ort der Fettasche. ");
INSERT INTO deuelo_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Und er soll sie an den Flügeln einreißen, es soll sie nicht zertrennen; und der Priester soll sie auf dem Altar räuchern, auf dem Holze, das über dem Feuer ist: es ist ein Brandopfer, ein Feueropfer lieblichen Geruchs dem Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Und wenn jemand die Opfergabe eines Speisopfers dem Jehova darbringen will, so soll seine Opfergabe Feinmehl sein; und er soll Öl darauf gießen und Weihrauch darauf legen. ");
INSERT INTO deuelo_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Und er soll es zu den Söhnen Aarons, den Priestern, bringen; und er nehme davon seine Hand voll, von seinem Feinmehl und von seinem Öl samt all seinem Weihrauch, und der Priester räuchere das Gedächtnisteil desselben auf dem Altar: es ist ein Feueropfer lieblichen Geruchs dem Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Und das Übrige von dem Speisopfer soll für Aaron und für seine Söhne sein: ein Hochheiliges von den Feueropfern Jehovas. ");
INSERT INTO deuelo_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Und wenn du als Opfergabe eines Speisopfers ein Ofengebäck darbringen willst, so soll es Feinmehl sein, ungesäuerte Kuchen, gemengt mit Öl, und ungesäuerte Fladen, gesalbt mit Öl. ");
INSERT INTO deuelo_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Und wenn deine Opfergabe ein Speisopfer in der Pfanne ist, so soll es Feinmehl sein, gemengt mit Öl, ungesäuert; ");
INSERT INTO deuelo_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","du sollst es in Stücke zerbrechen und Öl darauf gießen: es ist ein Speisopfer. ");
INSERT INTO deuelo_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Und wenn deine Opfergabe ein Speisopfer im Napfe ist, so soll es von Feinmehl mit Öl gemacht werden. ");
INSERT INTO deuelo_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Und du sollst das Speisopfer, das von diesen Dingen gemacht wird, dem Jehova bringen; und man soll es dem Priester überreichen, und er soll es an den Altar tragen. ");
INSERT INTO deuelo_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Und der Priester hebe von dem Speisopfer dessen Gedächtnisteil ab und räuchere es auf dem Altar: es ist ein Feueropfer lieblichen Geruchs dem Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Und das Übrige von dem Speisopfer soll für Aaron und für seine Söhne sein: ein Hochheiliges von den Feueropfern Jehovas. ");
INSERT INTO deuelo_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Alles Speisopfer, das ihr dem Jehova darbringet, soll nicht aus Gesäuertem gemacht werden; denn aller Sauerteig und aller Honig, davon sollt ihr kein Feueropfer dem Jehova räuchern. ");
INSERT INTO deuelo_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Was die Opfergabe der Erstlinge betrifft, so sollt ihr sie Jehova darbringen; aber auf den Altar sollen sie nicht kommen zum lieblichen Geruch. ");
INSERT INTO deuelo_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Und alle Opfergaben deines Speisopfers sollst du mit Salz salzen und sollst das Salz des Bundes deines Gottes nicht fehlen lassen bei deinem Speisopfer; bei allen deinen Opfergaben sollst du Salz darbringen. ");
INSERT INTO deuelo_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Und wenn du ein Speisopfer von den ersten Früchten dem Jehova darbringen willst, so sollst du Ähren, am Feuer geröstet, Schrot von Gartenkorn, darbringen als Speisopfer von deinen ersten Früchten. ");
INSERT INTO deuelo_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Und du sollst Öl darauf tun und Weihrauch darauf legen: es ist ein Speisopfer. ");
INSERT INTO deuelo_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Und der Priester soll das Gedächtnisteil desselben räuchern, von seinem Schrote und von seinem Öle, samt allem seinem Weihrauch: es ist ein Feueropfer dem Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Und wenn seine Opfergabe ein Friedensopfer ist: wenn er sie von den Rindern darbringt, es sei ein Männliches oder ein Weibliches, so soll er sie ohne Fehl vor Jehova darbringen. ");
INSERT INTO deuelo_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Und er soll seine Hand auf den Kopf seines Opfers legen und es schlachten an dem Eingang des Zeltes der Zusammenkunft; und die Söhne Aarons, die Priester, sollen das Blut an den Altar sprengen ringsum. ");
INSERT INTO deuelo_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Und er soll von dem Friedensopfer ein Feueropfer dem Jehova darbringen: das Fett, welches das Eingeweide bedeckt, und alles Fett, das am Eingeweide ist, ");
INSERT INTO deuelo_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","und die beiden Nieren und das Fett, das an ihnen, das an den Lenden ist, und das Netz über der Leber: samt den Nieren soll er es abtrennen. ");
INSERT INTO deuelo_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Und die Söhne Aarons sollen es auf dem Altar räuchern, auf dem Brandopfer, welches auf dem Holze über dem Feuer ist: es ist ein Feueropfer lieblichen Geruchs dem Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Und wenn seine Opfergabe vom Kleinvieh ist zum Friedensopfer dem Jehova, ein Männliches oder ein Weibliches, so soll er sie ohne Fehl darbringen. ");
INSERT INTO deuelo_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Wenn er ein Schaf darbringt als seine Opfergabe, so soll er es vor Jehova herzubringen; ");
INSERT INTO deuelo_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","und er soll seine Hand auf den Kopf seines Opfers legen und es schlachten vor dem Zelte der Zusammenkunft; und die Söhne Aarons sollen sein Blut an den Altar sprengen ringsum. ");
INSERT INTO deuelo_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Und er soll von dem Friedensopfer als Feueropfer dem Jehova darbringen: sein Fett, den ganzen Fettschwanz; dicht beim Rückgrat soll er ihn abtrennen; und das Fett, welches das Eingeweide bedeckt, und alles Fett, das am Eingeweide ist, ");
INSERT INTO deuelo_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","und die beiden Nieren und das Fett, das an ihnen, das an den Lenden ist, und das Netz über der Leber: samt den Nieren soll er es abtrennen. ");
INSERT INTO deuelo_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Und der Priester soll es auf dem Altar räuchern: es ist eine Speise des Feueropfers dem Jehova. - ");
INSERT INTO deuelo_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Und wenn seine Opfergabe eine Ziege ist, so soll er sie vor Jehova herzubringen; ");
INSERT INTO deuelo_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","und er soll seine Hand auf ihren Kopf legen und sie schlachten vor dem Zelte der Zusammenkunft; und die Söhne Aarons sollen ihr Blut an den Altar sprengen ringsum. ");
INSERT INTO deuelo_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Und er soll davon seine Opfergabe als Feueropfer dem Jehova darbringen: das Fett, welches das Eingeweide bedeckt, und alles Fett, das am Eingeweide ist, ");
INSERT INTO deuelo_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","und die beiden Nieren und das Fett, das an ihnen, das an den Lenden ist, und das Netz über der Leber: samt den Nieren soll er es abtrennen. ");
INSERT INTO deuelo_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Und der Priester soll es auf dem Altar räuchern: es ist eine Speise des Feueropfers zum lieblichen Geruch; alles Fett gehört Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Eine ewige Satzung bei euren Geschlechtern in allen euren Wohnsitzen: alles Fett und alles Blut sollt ihr nicht essen. ");
INSERT INTO deuelo_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Und Jehova redete zu Mose und sprach: Rede zu den Kindern Israel und sprich: ");
INSERT INTO deuelo_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Wenn jemand aus Versehen sündigt gegen irgend eines der Verbote Jehovas, die nicht getan werden sollen, und irgend eines derselben tut, - ");
INSERT INTO deuelo_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","wenn der gesalbte Priester sündigt nach einem Vergehen des Volkes, so soll er für seine Sünde, die er begangen hat, einen jungen Farren ohne Fehl dem Jehova darbringen zum Sündopfer. ");
INSERT INTO deuelo_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Und er soll den Farren an den Eingang des Zeltes der Zusammenkunft vor Jehova bringen und seine Hand auf den Kopf des Farren legen und den Farren schlachten vor Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Und der gesalbte Priester nehme von dem Blute des Farren und bringe es in das Zelt der Zusammenkunft; ");
INSERT INTO deuelo_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","und der Priester tauche seinen Finger in das Blut und sprenge von dem Blute siebenmal vor Jehova gegen den Vorhang des Heiligtums hin. ");
INSERT INTO deuelo_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Und der Priester tue von dem Blute an die Hörner des Altars des wohlriechenden Räucherwerks, der im Zelte der Zusammenkunft ist, vor Jehova; und alles Blut des Farren soll er an den Fuß des Brandopferaltars gießen, der an dem Eingang des Zeltes der Zusammenkunft ist. ");
INSERT INTO deuelo_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Und alles Fett von dem Farren des Sündopfers soll er von ihm abheben: das Fett, welches das Eingeweide bedeckt, und alles Fett, das am Eingeweide ist, ");
INSERT INTO deuelo_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","und die beiden Nieren und das Fett, das an ihnen, das an den Lenden ist, und das Netz über der Leber: samt den Nieren soll er es abtrennen, ");
INSERT INTO deuelo_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","so wie es abgehoben wird von dem Rinde des Friedensopfers; und der Priester soll es auf dem Brandopferaltar räuchern. ");
INSERT INTO deuelo_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Und die Haut des Farren und all sein Fleisch samt seinem Kopfe und seinen Schenkeln und seinem Eingeweide und seinem Mist: ");
INSERT INTO deuelo_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","den ganzen Farren soll er hinausbringen außerhalb des Lagers an einen reinen Ort, nach dem Schutthaufen der Fettasche, und soll ihn auf Holzscheiten mit Feuer verbrennen; auf dem Schutthaufen der Fettasche soll er verbrannt werden. ");
INSERT INTO deuelo_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Und wenn die ganze Gemeinde Israel aus Versehen sündigt und die Sache ist verborgen vor den Augen der Versammlung, und sie tun eines von allen Verboten Jehovas, die nicht getan werden sollen, und verschulden sich, ");
INSERT INTO deuelo_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","und die Sünde wird bekannt, die sie wider dasselbe begangen haben, so soll die Versammlung einen jungen Farren darbringen zum Sündopfer und ihn vor das Zelt der Zusammenkunft bringen. ");
INSERT INTO deuelo_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Und die Ältesten der Gemeinde sollen ihre Hände auf den Kopf des Farren legen vor Jehova, und man soll den Farren vor Jehova schlachten. ");
INSERT INTO deuelo_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Und der gesalbte Priester bringe von dem Blute des Farren in das Zelt der Zusammenkunft, ");
INSERT INTO deuelo_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","und der Priester tauche seinen Finger in das Blut und sprenge siebenmal vor Jehova gegen den Vorhang hin. ");
INSERT INTO deuelo_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Und er tue von dem Blute an die Hörner des Altars, der vor Jehova, der im Zelte der Zusammenkunft ist; und alles Blut soll er an den Fuß des Brandopferaltars gießen, der an dem Eingang des Zeltes der Zusammenkunft ist. ");
INSERT INTO deuelo_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Und all sein Fett soll er von ihm abheben und auf dem Altar räuchern. ");
INSERT INTO deuelo_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Und er soll mit dem Farren tun, wie er mit dem Farren des Sündopfers getan hat; also soll er damit tun. Und so tue der Priester Sühnung für sie, und es wird ihnen vergeben werden. ");
INSERT INTO deuelo_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Und er soll den Farren hinausbringen außerhalb des Lagers und ihn verbrennen, so wie er den ersten Farren verbrannt hat: es ist ein Sündopfer der Versammlung. ");
INSERT INTO deuelo_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Wenn ein Fürst sündigt und tut aus Versehen eines von allen den Verboten Jehovas, seines Gottes, die nicht getan werden sollen, und verschuldet sich, ");
INSERT INTO deuelo_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","und seine Sünde wird ihm kundgetan, worin er gesündigt hat, so soll er seine Opfergabe bringen, einen Ziegenbock, ein Männlein ohne Fehl. ");
INSERT INTO deuelo_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Und er soll seine Hand auf den Kopf des Bockes legen und ihn schlachten an dem Orte, wo man das Brandopfer vor Jehova schlachtet: es ist ein Sündopfer. ");
INSERT INTO deuelo_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Und der Priester nehme von dem Blute des Sündopfers mit seinem Finger und tue es an die Hörner des Brandopferaltars; und sein Blut soll er an den Fuß des Brandopferaltars gießen. ");
INSERT INTO deuelo_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Und all sein Fett soll er auf dem Altar räuchern, wie das Fett des Friedensopfers. Und so tue der Priester Sühnung für ihn wegen seiner Sünde, und es wird ihm vergeben werden. ");
INSERT INTO deuelo_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Und wenn jemand vom Volke des Landes aus Versehen sündigt, indem er eines von den Verboten Jehovas tut, die nicht getan werden sollen, und sich verschuldet ");
INSERT INTO deuelo_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","und seine Sünde wird ihm kundgetan, die er begangen hat, so soll er seine Opfergabe bringen, eine Ziege ohne Fehl, ein Weiblein, für seine Sünde, die er begangen hat. ");
INSERT INTO deuelo_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Und er soll seine Hand auf den Kopf des Sündopfers legen und das Sündopfer schlachten an dem Orte des Brandopfers. ");
INSERT INTO deuelo_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Und der Priester nehme von seinem Blute mit seinem Finger und tue es an die Hörner des Brandopferaltars; und all sein Blut soll er an den Fuß des Altars gießen. ");
INSERT INTO deuelo_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Und all sein Fett soll er abtrennen, so wie das Fett von dem Friedensopfer abgetrennt wird; und der Priester soll es auf dem Altar räuchern zum lieblichen Geruch dem Jehova. Und so tue der Priester Sühnung für ihn, und es wird ihm vergeben werden. - ");
INSERT INTO deuelo_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Und wenn er ein Schaf bringt als seine Opfergabe zum Sündopfer, so soll es ein Weiblein ohne Fehl sein, das er bringt. ");
INSERT INTO deuelo_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Und er soll seine Hand auf den Kopf des Sündopfers legen und es zum Sündopfer schlachten an dem Orte, wo man das Brandopfer schlachtet. ");
INSERT INTO deuelo_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Und der Priester nehme von dem Blute des Sündopfers mit seinem Finger und tue es an die Hörner des Brandopferaltars; und all sein Blut soll er an den Fuß des Altars gießen. ");
INSERT INTO deuelo_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Und all sein Fett soll er abtrennen, so wie das Fett des Schafes von dem Friedensopfer abgetrennt wird; und der Priester soll es auf dem Altar räuchern, auf den Feueropfern Jehovas. Und so tue der Priester Sühnung für ihn wegen seiner Sünde, die er begangen hat, und es wird ihm vergeben werden. ");
INSERT INTO deuelo_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Und wenn jemand sündigt, daß er die Stimme des Fluches hört, und er war Zeuge, sei es daß er es gesehen oder gewußt hat, wenn er es nicht anzeigt, so soll er seine Ungerechtigkeit tragen; ");
INSERT INTO deuelo_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","oder wenn jemand irgend etwas Unreines anrührt, sei es das Aas eines unreinen wilden Tieres, oder das Aas eines unreinen Viehes, oder das Aas eines unreinen kriechenden Tieres, ist es ihm auch verborgen, so ist er unrein und schuldig; ");
INSERT INTO deuelo_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","oder wenn er die Unreinigkeit eines Menschen anrührt, was für eine Unreinigkeit von ihm es auch sei, durch welche er unrein wird, und es ist ihm verborgen, erkennt er es, so ist er schuldig; ");
INSERT INTO deuelo_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","oder wenn jemand schwört, indem er unbesonnen mit den Lippen redet, Böses oder Gutes zu tun, nach allem was ein Mensch mit einem Schwur unbesonnen reden mag, und es ist ihm verborgen, erkennt er es, so ist er schuldig in einem von diesen. ");
INSERT INTO deuelo_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Und es soll geschehen, wenn er sich in einem von diesen verschuldet, so bekenne er, worin er gesündigt hat; ");
INSERT INTO deuelo_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","und er bringe sein Schuldopfer dem Jehova für seine Sünde, die er begangen hat: ein Weiblein vom Kleinvieh, ein Schaf oder eine Ziege zum Sündopfer; und der Priester soll Sühnung für ihn tun wegen seiner Sünde. ");
INSERT INTO deuelo_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Und wenn seine Hand das zu einem Stück Kleinvieh Hinreichende nicht aufbringen kann, so soll er für seine Schuld, die er auf sich geladen hat, zwei Turteltauben oder zwei junge Tauben dem Jehova bringen: eine zum Sündopfer und eine zum Brandopfer. ");
INSERT INTO deuelo_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Und er soll sie zu dem Priester bringen; und dieser bringe die zum Sündopfer bestimmte zuerst dar und kneipe ihr den Kopf ein dicht beim Genick; er soll ihn aber nicht abtrennen. ");
INSERT INTO deuelo_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Und er sprenge von dem Blute des Sündopfers an die Wand des Altars, und das Übrige von dem Blute soll ausgedrückt werden an den Fuß des Altars: es ist ein Sündopfer. ");
INSERT INTO deuelo_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Und die andere soll er als Brandopfer opfern nach der Vorschrift. Und so tue der Priester Sühnung für ihn wegen seiner Sünde, die er begangen hat, und es wird ihm vergeben werden. ");
INSERT INTO deuelo_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Und wenn seine Hand zwei Turteltauben oder zwei junge Tauben nicht aufbringen kann, so bringe der, welcher gesündigt hat, als seine Opfergabe ein Zehntel Epha Feinmehl zum Sündopfer; er soll kein Öl darauf tun und keinen Weihrauch darauf legen, denn es ist ein Sündopfer. ");
INSERT INTO deuelo_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Und er soll es zu dem Priester bringen; und der Priester nehme davon seine Hand voll, das Gedächtnisteil desselben, und räuchere es auf dem Altar, auf den Feueropfern Jehovas: es ist ein Sündopfer. ");
INSERT INTO deuelo_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Und so tue der Priester Sühnung für ihn wegen seiner Sünde, die er begangen hat in einem von diesen, und es wird ihm vergeben werden; und es soll dem Priester gehören wie das Speisopfer. ");
INSERT INTO deuelo_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Wenn jemand Untreue begeht und aus Versehen an den heiligen Dingen Jehovas sündigt, so soll er sein Schuldopfer dem Jehova bringen, einen Widder ohne Fehl vom Kleinvieh, nach deiner Schätzung an Sekeln Silber, nach den Sekel des Heiligtums, zum Schuldopfer. ");
INSERT INTO deuelo_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Und was er an dem Heiligen gesündigt hat, soll er erstatten und dessen Fünftel darüber hinzufügen und es dem Priester geben; und der Priester soll Sühnung für ihn tun mit dem Widder des Schuldopfers, und es wird ihm vergeben werden. ");
INSERT INTO deuelo_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Und wenn jemand sündigt und eines von allen den Verboten Jehovas tut, die nicht getan werden sollen, hat er es auch nicht gewußt, so ist er schuldig und soll seine Ungerechtigkeit tragen. ");
INSERT INTO deuelo_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Und er soll einen Widder ohne Fehl vom Kleinvieh nach deiner Schätzung zu dem Priester bringen, zum Schuldopfer; und der Priester soll Sühnung für ihn tun wegen seines Versehens, das er begangen hat, ohne es zu wissen; und es wird ihm vergeben werden. ");
INSERT INTO deuelo_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Es ist ein Schuldopfer; er hat sich gewißlich an Jehova verschuldet. ");
INSERT INTO deuelo_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","(05:20) Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","(05:21) Wenn jemand sündigt und Untreue wider Jehova begeht, daß er seinem Nächsten ein anvertrautes Gut ableugnet oder ein Darlehn oder etwas Geraubtes; oder er hat von seinem Nächsten etwas erpreßt, ");
INSERT INTO deuelo_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","(05:22) oder er hat Verlorenes gefunden, und leugnet es ab; und er schwört falsch über irgend etwas von allem, was ein Mensch tun mag, sich darin zu versündigen: ");
INSERT INTO deuelo_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","(05:23) so soll es geschehen, wenn er gesündigt und sich verschuldet hat, daß er zurückerstatte das Geraubte, das er geraubt, oder das Erpreßte, das er erpreßt hat, oder das Anvertraute, das ihm anvertraut worden ist, oder das Verlorene, das er gefunden hat, ");
INSERT INTO deuelo_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","(05:24) oder alles, worüber er falsch geschworen hat; und er soll es erstatten nach seiner vollen Summe und dessen Fünftel darüber hinzufügen; wem es gehört, dem soll er es geben am Tage seines Schuldopfers. ");
INSERT INTO deuelo_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","(05:25) Und sein Schuldopfer soll er Jehova bringen, einen Widder ohne Fehl vom Kleinvieh, nach deiner Schätzung, zum Schuldopfer, zu dem Priester; ");
INSERT INTO deuelo_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","(05:26) und der Priester soll Sühnung für ihn tun vor Jehova, und es wird ihm vergeben werden wegen irgend etwas von allem, was er getan hat, sich darin zu verschulden. ");
INSERT INTO deuelo_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","(06:1) Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","(06:2) Gebiete Aaron und seinen Söhnen und sprich: Dies ist das Gesetz des Brandopfers. Dieses, das Brandopfer, soll auf seiner Feuerstelle sein, auf dem Altar, die ganze Nacht bis an den Morgen; und das Feuer des Altars soll auf demselben in Brand erhalten werden. ");
INSERT INTO deuelo_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","(06:3) Und der Priester soll sein leinenes Kleid anziehen, und soll seine leinenen Beinkleider anziehen über sein Fleisch; und er soll die Fettasche abheben, zu welcher das Feuer das Brandopfer auf dem Altar verzehrt hat, und soll sie neben den Altar schütten. ");
INSERT INTO deuelo_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","(06:4) Und er soll seine Kleider ausziehen und andere Kleider anlegen und die Fettasche hinaustragen außerhalb des Lagers an einen reinen Ort. ");
INSERT INTO deuelo_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","(06:5) Und das Feuer auf dem Altar soll auf demselben in Brand erhalten werden, es soll nicht erlöschen; und der Priester soll Holz auf ihm anzünden, Morgen für Morgen, und das Brandopfer auf ihm zurichten, und die Fettstücke der Friedensopfer auf ihm räuchern. ");
INSERT INTO deuelo_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","(06:6) Ein beständiges Feuer soll auf dem Altar in Brand erhalten werden, es soll nicht erlöschen. ");
INSERT INTO deuelo_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","(06:7) Und dies ist das Gesetz des Speisopfers: Einer der Söhne Aarons soll es vor Jehova darbringen vor dem Altar. ");
INSERT INTO deuelo_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","(06:8) Und er soll davon seine Hand voll nehmen, vom Feinmehl des Speisopfers und von dessen Öl, und allen Weihrauch, der auf dem Speisopfer ist, und es auf dem Altar räuchern: es ist ein lieblicher Geruch, sein Gedächtnisteil für Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","(06:9) Und das Übrige davon sollen Aaron und seine Söhne essen; ungesäuert soll es gegessen werden an heiligem Orte; im Vorhofe des Zeltes der Zusammenkunft sollen sie es essen. ");
INSERT INTO deuelo_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","(06:10) Es soll nicht gesäuert gebacken werden; als ihren Anteil habe ich es ihnen gegeben von meinen Feueropfern: hochheilig ist es, wie das Sündopfer und wie das Schuldopfer. ");
INSERT INTO deuelo_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","(06:11) Alles Männliche unter den Kindern Aarons soll es essen: Ein für ewig Bestimmtes bei euren Geschlechtern von den Feueropfern Jehovas. Alles, was sie anrührt, wird heilig sein. ");
INSERT INTO deuelo_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","(06:12) Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","(06:13) Dies ist die Opfergabe Aarons und seiner Söhne, welche sie Jehova darbringen sollen an dem Tage, da er gesalbt wird: Ein Zehntel Epha Feinmehl als beständiges Speisopfer, die Hälfte davon am Morgen und die Hälfte davon am Abend. ");
INSERT INTO deuelo_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","(06:14) Es soll in der Pfanne mit Öl bereitet werden, eingerührt mit Öl sollst du es bringen; gebackene Speisopferstücke sollst du darbringen als einen lieblichen Geruch dem Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","(06:15) Und der Priester, der unter seinen Söhnen an seiner Statt gesalbt wird, soll es opfern; eine ewige Satzung: es soll dem Jehova ganz geräuchert werden. ");
INSERT INTO deuelo_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","(06:16) Und jedes Speisopfer des Priesters soll ein Ganzopfer sein; es soll nicht gegessen werden. ");
INSERT INTO deuelo_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","(06:17) Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","(06:18) Rede zu Aaron und zu seinen Söhnen und sprich: Dies ist das Gesetz des Sündopfers. An dem Orte, wo das Brandopfer geschlachtet wird, soll das Sündopfer geschlachtet werden vor Jehova: hochheilig ist es. ");
INSERT INTO deuelo_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","(06:19) Der Priester, der es als Sündopfer opfert, soll es essen; an heiligem Orte soll es gegessen werden, im Vorhofe des Zeltes der Zusammenkunft. ");
INSERT INTO deuelo_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","(06:20) Alles, was sein Fleisch anrührt, wird heilig sein; und wenn von seinem Blute auf ein Kleid spritzt das, worauf es spritzt, sollst du waschen an heiligem Orte. ");
INSERT INTO deuelo_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","(06:21) Und das irdene Gefäß, in welchem es gekocht wird, soll zerbrochen werden, und wenn es in einem ehernen Gefäß gekocht wird, so soll dieses gescheuert und mit Wasser gespült werden. ");
INSERT INTO deuelo_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","(06:22) Alles Männliche unter den Priestern soll es essen: hochheilig ist es. ");
INSERT INTO deuelo_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","(06:23) Aber alles Sündopfer, von dessen Blut in das Zelt der Zusammenkunft gebracht wird, um im Heiligtum Sühnung zu tun, soll nicht gegessen werden; es soll mit Feuer verbrannt werden. ");
INSERT INTO deuelo_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Und dies ist das Gesetz des Schuldopfers; es ist hochheilig. ");
INSERT INTO deuelo_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","An dem Orte, wo man das Brandopfer schlachtet, soll man das Schuldopfer schlachten; und sein Blut soll er an den Altar sprengen ringsum. ");
INSERT INTO deuelo_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Und alles Fett soll er davon darbringen, den Fettschwanz und das Fett, welches das Eingeweide bedeckt, ");
INSERT INTO deuelo_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","und die beiden Nieren und das Fett, das an ihnen, das an den Lenden ist, und das Netz über der Leber: samt den Nieren soll er es abtrennen. ");
INSERT INTO deuelo_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Und der Priester soll es auf dem Altar räuchern als ein Feueropfer dem Jehova: es ist ein Schuldopfer. ");
INSERT INTO deuelo_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Alles Männliche unter den Priestern soll es essen; an heiligem Orte soll es gegessen werden: hochheilig ist es. ");
INSERT INTO deuelo_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Wie das Sündopfer, so das Schuldopfer: ein Gesetz soll für sie sein. Der Priester, der damit Sühnung tut, ihm soll es gehören. - ");
INSERT INTO deuelo_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Und der Priester, der jemandes Brandopfer darbringt: ihm, dem Priester, soll die Haut des Brandopfers gehören, das er dargebracht hat. ");
INSERT INTO deuelo_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Und alles Speisopfer, das im Ofen gebacken, und alles, was im Napfe oder in der Pfanne bereitet wird: dem Priester, der es darbringt, ihm soll es gehören. ");
INSERT INTO deuelo_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Und alles Speisopfer, das mit Öl gemengt oder trocken ist, soll allen Söhnen Aarons gehören, dem einen wie dem anderen. ");
INSERT INTO deuelo_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Und dies ist das Gesetz des Friedensopfers, das man Jehova darbringt: ");
INSERT INTO deuelo_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Wenn man es zum Danke darbringt, so bringe man nebst dem Dankopfer ungesäuerte Kuchen dar, gemengt mit Öl, und ungesäuerte Fladen, gesalbt mit Öl, und Feinmehl, eingerührt mit Öl: Kuchen, gemengt mit Öl. ");
INSERT INTO deuelo_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Nebst den Kuchen soll man gesäuertes Brot als Opfergabe darbringen, nebst seinem Dankfriedensopfer. ");
INSERT INTO deuelo_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Und man soll je eines davon, von der ganzen Opfergabe, dem Jehova als Hebopfer darbringen; dem Priester, der das Blut des Friedensopfers sprengt, ihm soll es gehören. ");
INSERT INTO deuelo_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Und das Fleisch seines Dankfriedensopfers soll am Tage seiner Darbringung gegessen werden; er soll nichts davon liegen lassen bis an den Morgen. ");
INSERT INTO deuelo_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Und wenn das Schlachtopfer seiner Opfergabe ein Gelübde oder eine freiwillige Gabe ist, so soll es an dem Tage, da er sein Schlachtopfer darbringt, gegessen werden; und am anderen Tage soll dann, was davon übrigbleibt, gegessen werden; ");
INSERT INTO deuelo_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","und was vom Fleische des Schlachtopfers am dritten Tage übrigbleibt, soll mit Feuer verbrannt werden. ");
INSERT INTO deuelo_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Und wenn irgendwie vom Fleische seines Friedensopfers am dritten Tage gegessen wird, so wird es nicht wohlgefällig sein; wer es dargebracht hat, dem wird es nicht zugerechnet werden: ein Greuel wird es sein; und die Seele, die davon isset, wird ihre Ungerechtigkeit tragen. ");
INSERT INTO deuelo_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Und das Fleisch, das irgend etwas Unreines berührt, soll nicht gegessen werden, mit Feuer soll es verbrannt werden. Und was das Fleisch betrifft, jeder Reine darf das Fleisch essen; ");
INSERT INTO deuelo_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","aber die Seele, welche Fleisch von dem Friedensopfer isset, das Jehova gehört, und ihre Unreinigkeit ist an ihr, selbige Seele soll ausgerottet werden aus ihren Völkern. ");
INSERT INTO deuelo_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Und wenn eine Seele irgend etwas Unreines anrührt, die Unreinigkeit eines Menschen oder ein unreines Vieh oder irgend ein unreines Scheusal, und sie isset von dem Fleische des Friedensopfers, das Jehova gehört: selbige Seele soll ausgerottet werden aus ihren Völkern. ");
INSERT INTO deuelo_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Rede zu den Kindern Israel und sprich: Kein Fett vom Rindvieh und von Schaf und Ziege sollt ihr essen. ");
INSERT INTO deuelo_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Und das Fett vom Aas und das Fett vom Zerrissenen kann verwendet werden zu allerlei Werk; aber ihr sollt es durchaus nicht essen. ");
INSERT INTO deuelo_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Denn jeder, der Fett isset vom Vieh, wovon man ein Feueropfer dem Jehova darbringt die Seele, die es isset, soll ausgerottet werden aus ihren Völkern. ");
INSERT INTO deuelo_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Und kein Blut sollt ihr essen in allen euren Wohnsitzen, es sei vom Gevögel oder vom Vieh. ");
INSERT INTO deuelo_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Jede Seele, die irgend Blut isset, selbige Seele soll ausgerottet werden aus ihren Völkern. ");
INSERT INTO deuelo_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Rede zu den Kindern Israel und sprich: Wer sein Friedensopfer dem Jehova darbringt, soll von seinem Friedensopfer seine Opfergabe dem Jehova bringen. ");
INSERT INTO deuelo_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Seine Hände sollen die Feueropfer Jehovas bringen; das Fett, samt der Brust soll er es bringen: die Brust, um sie als Webopfer vor Jehova zu weben. ");
INSERT INTO deuelo_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Und der Priester soll das Fett auf dem Altar räuchern, und die Brust soll Aaron und seinen Söhnen gehören. ");
INSERT INTO deuelo_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Und den rechten Schenkel sollt ihr als Hebopfer von euren Friedensopfern dem Priester geben. ");
INSERT INTO deuelo_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Wer von den Söhnen Aarons das Blut des Friedensopfers und das Fett darbringt, dem soll der rechte Schenkel zuteil werden. ");
INSERT INTO deuelo_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Und die Brust des Webopfers und den Schenkel des Hebopfers habe ich von den Kindern Israel genommen, von ihren Friedensopfern, und habe sie Aaron, dem Priester, und seinen Söhnen gegeben als eine ewige Gebühr von seiten der Kinder Israel. - ");
INSERT INTO deuelo_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Das ist das Salbungsteil Aarons und das Salbungsteil seiner Söhne von den Feueropfern Jehovas, an dem Tage, da man sie herzunahen ließ, um Jehova den Priesterdienst auszuüben, ");
INSERT INTO deuelo_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","das Jehova geboten hat, ihnen zu geben von seiten der Kinder Israel, an dem Tage, da man sie salbte: eine ewige Satzung bei ihren Geschlechtern. ");
INSERT INTO deuelo_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Das ist das Gesetz des Brandopfers, des Speisopfers und des Sündopfers und des Schuldopfers und des Einweihungsopfers und des Friedensopfers, ");
INSERT INTO deuelo_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","welches Jehova dem Mose geboten hat auf dem Berge Sinai, an dem Tage, da er den Kindern Israel gebot, ihre Opfergaben dem Jehova darzubringen, in der Wüste Sinai. ");
INSERT INTO deuelo_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Nimm Aaron und seine Söhne mit ihm, und die Kleider und das Salböl und den Farren des Sündopfers und die zwei Widder und den Korb des Ungesäuerten; ");
INSERT INTO deuelo_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","und versammle die ganze Gemeinde am Eingang des Zeltes der Zusammenkunft. ");
INSERT INTO deuelo_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Und Mose tat, so wie Jehova ihm geboten hatte; und die Gemeinde versammelte sich am Eingang des Zeltes der Zusammenkunft. ");
INSERT INTO deuelo_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Und Mose sprach zu der Gemeinde: Dies ist es, was Jehova zu tun geboten hat. ");
INSERT INTO deuelo_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Und Mose ließ Aaron und seine Söhne herzunahen und wusch sie mit Wasser. ");
INSERT INTO deuelo_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Und er legte ihm den Leibrock an und umgürtete ihn mit dem Gürtel; und er bekleidete ihn mit dem Oberkleide und legte ihm das Ephod an und umgürtete ihn mit dem gewirkten Gürtel des Ephods und band es ihm damit an; ");
INSERT INTO deuelo_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","und er setzte das Brustschild darauf und legte in das Brustschild die Urim und die Thummim; ");
INSERT INTO deuelo_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","und er setzte den Kopfbund auf sein Haupt und setzte an den Kopfbund, an seine Vorderseite, das Goldblech, das heilige Diadem: so wie Jehova dem Mose geboten hatte. ");
INSERT INTO deuelo_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Und Mose nahm das Salböl und salbte die Wohnung und alles, was darin war, und heiligte sie. ");
INSERT INTO deuelo_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Und er sprengte davon siebenmal auf den Altar, und er salbte den Altar und alle seine Geräte und das Becken und sein Gestell, um sie zu heiligen. ");
INSERT INTO deuelo_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Und er goß von dem Salböl auf das Haupt Aarons und salbte ihn, um ihn zu heiligen. ");
INSERT INTO deuelo_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Und Mose ließ die Söhne Aarons herzunahen und bekleidete sie mit den Leibröcken und umgürtete sie mit den Gürteln und band ihnen die hohen Mützen um: so wie Jehova dem Mose geboten hatte. ");
INSERT INTO deuelo_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Und er brachte den Farren des Sündopfers herzu; und Aaron und seine Söhne legten ihre Hände auf den Kopf des Farren des Sündopfers. ");
INSERT INTO deuelo_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Und er schlachtete ihn, und Mose nahm das Blut und tat davon mit seinem Finger an die Hörner des Altars ringsum und entsündigte den Altar; und das Blut goß er an den Fuß des Altars und heiligte ihn, indem er Sühnung für ihn tat. ");
INSERT INTO deuelo_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Und er nahm das ganze Fett, das am Eingeweide ist, und das Netz der Leber und die beiden Nieren und ihr Fett, und Mose räucherte es auf dem Altar. ");
INSERT INTO deuelo_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Und den Farren und seine Haut und sein Fleisch und seinen Mist verbrannte er mit Feuer außerhalb des Lagers: so wie Jehova dem Mose geboten hatte. - ");
INSERT INTO deuelo_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Und er brachte den Widder des Brandopfers herzu; und Aaron und seine Söhne legten ihre Hände auf den Kopf des Widders. ");
INSERT INTO deuelo_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Und er schlachtete ihn, und Mose sprengte das Blut an den Altar ringsum. ");
INSERT INTO deuelo_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Und den Widder zerlegte er in seine Stücke, und Mose räucherte den Kopf und die Stücke und das Fett; ");
INSERT INTO deuelo_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","und das Eingeweide und die Schenkel wusch er mit Wasser. Und Mose räucherte den ganzen Widder auf dem Altar: es war ein Brandopfer zum lieblichen Geruch, es war ein Feueropfer dem Jehova, so wie Jehova dem Mose geboten hatte. - ");
INSERT INTO deuelo_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Und er brachte den zweiten Widder, den Widder der Einweihung, herzu; und Aaron und seine Söhne legten ihre Hände auf den Kopf des Widders. ");
INSERT INTO deuelo_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Und er schlachtete ihn, und Mose nahm von seinem Blute und tat es auf das rechte Ohrläppchen Aarons und auf den Daumen seiner rechten Hand und auf die große Zehe seines rechten Fußes. ");
INSERT INTO deuelo_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Und er ließ die Söhne Aarons herzunahen, und Mose tat von dem Blute auf ihr rechtes Ohrläppchen und auf den Daumen ihrer rechten Hand und auf die große Zehe ihres rechten Fußes; und Mose sprengte das Blut an den Altar ringsum. ");
INSERT INTO deuelo_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Und er nahm das Fett und den Fettschwanz und alles Fett, das am Eingeweide ist, und das Netz der Leber und die beiden Nieren und ihr Fett und den rechten Schenkel; ");
INSERT INTO deuelo_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","und er nahm aus dem Korbe des Ungesäuerten, der vor Jehova war, einen ungesäuerten Kuchen und einen Kuchen geölten Brotes und einen Fladen, und legte es auf die Fettstücke und auf den rechten Schenkel; ");
INSERT INTO deuelo_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","und er legte das alles auf die Hände Aarons und auf die Hände seiner Söhne, und webte es als Webopfer vor Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Und Mose nahm es von ihren Händen weg und räucherte es auf dem Altar, auf dem Brandopfer: es war ein Einweihungsopfer zum lieblichen Geruch, es war ein Feueropfer dem Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Und Mose nahm die Brust und webte sie als Webopfer vor Jehova; von dem Einweihungswidder ward sie dem Mose zuteil, so wie Jehova dem Mose geboten hatte. ");
INSERT INTO deuelo_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Und Mose nahm von dem Salböl und von dem Blute, das auf dem Altar war, und sprengte es auf Aaron, auf seine Kleider, und auf seine Söhne und auf die Kleider seiner Söhne mit ihm; und er heiligte Aaron, seine Kleider, und seine Söhne und die Kleider seiner Söhne mit ihm. ");
INSERT INTO deuelo_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Und Mose sprach zu Aaron und zu seinen Söhnen: Kochet das Fleisch an dem Eingang des Zeltes der Zusammenkunft; und ihr sollt es daselbst essen und das Brot, das im Korbe des Einweihungsopfers ist, so wie ich geboten habe und gesagt: Aaron und seine Söhne sollen es essen. ");
INSERT INTO deuelo_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Und das Übrige von dem Fleische und von dem Brote sollt ihr mit Feuer verbrennen. ");
INSERT INTO deuelo_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Und von dem Eingang des Zeltes der Zusammenkunft sollt ihr nicht weggehen sieben Tage lang, bis zu dem Tage, da die Tage eures Einweihungsopfers erfüllt sind; denn sieben Tage sollt ihr eingeweiht werden. ");
INSERT INTO deuelo_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","So wie man an diesem Tage getan, hat Jehova zu tun geboten, um Sühnung für euch zu tun. ");
INSERT INTO deuelo_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Und ihr sollt an dem Eingang des Zeltes der Zusammenkunft Tag und Nacht bleiben, sieben Tage lang, und sollt die Vorschriften Jehovas beobachten, daß ihr nicht sterbet; denn also ist mir geboten worden. ");
INSERT INTO deuelo_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Und Aaron und seine Söhne taten alles, was Jehova durch Mose geboten hatte. ");
INSERT INTO deuelo_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Und es geschah am achten Tage, da rief Mose Aaron und seine Söhne und die Ältesten Israels; ");
INSERT INTO deuelo_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","und er sprach zu Aaron: Nimm dir ein junges Kalb zum Sündopfer und einen Widder zum Brandopfer, ohne Fehl, und bringe sie dar vor Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Und zu den Kindern Israel sollst du reden und sprechen: Nehmet einen Ziegenbock zum Sündopfer und ein Kalb und ein Lamm, einjährige, ohne Fehl, zum Brandopfer; ");
INSERT INTO deuelo_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","und einen Stier und einen Widder zum Friedensopfer, um sie vor Jehova zu opfern; und ein Speisopfer, gemengt mit Öl; denn heute wird Jehova euch erscheinen. ");
INSERT INTO deuelo_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Und sie brachten was Mose geboten hatte, vor das Zelt der Zusammenkunft, und die ganze Gemeinde nahte herzu und stand vor Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Und Mose sprach: Dies ist es, was Jehova geboten hat, daß ihr es tun sollt; und die Herrlichkeit Jehovas wird euch erscheinen. ");
INSERT INTO deuelo_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Und Mose sprach zu Aaron: Nahe zum Altar, und opfere dein Sündopfer und dein Brandopfer, und tue Sühnung für dich und für das Volk; und opfere die Opfergabe des Volkes und tue Sühnung für sie, so wie Jehova geboten hat. ");
INSERT INTO deuelo_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Und Aaron nahte zum Altar und schlachtete das Kalb des Sündopfers, das für ihn war. ");
INSERT INTO deuelo_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Und die Söhne Aarons reichten ihm das Blut dar; und er tauchte seinen Finger in das Blut und tat davon an die Hörner des Altars, und er goß das Blut an den Fuß des Altars. ");
INSERT INTO deuelo_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Und das Fett und die Nieren und das Netz der Leber vom Sündopfer räucherte er auf dem Altar, so wie Jehova dem Mose geboten hatte. ");
INSERT INTO deuelo_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Und das Fleisch und die Haut verbrannte er mit Feuer außerhalb des Lagers. ");
INSERT INTO deuelo_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Und er schlachtete das Brandopfer; und die Söhne Aarons reichten ihm das Blut, und er sprengte es an den Altar ringsum. ");
INSERT INTO deuelo_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Und das Brandopfer reichten sie ihm in seinen Stücken und den Kopf, und er räucherte es auf dem Altar. ");
INSERT INTO deuelo_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Und er wusch das Eingeweide und die Schenkel und räucherte sie auf dem Brandopfer, auf dem Altar. - ");
INSERT INTO deuelo_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Und er brachte herzu die Opfergabe des Volkes und nahm den Bock des Sündopfers, der für das Volk war, und schlachtete ihn und opferte ihn als Sündopfer, wie das vorige. ");
INSERT INTO deuelo_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Und er brachte das Brandopfer herzu und opferte es nach der Vorschrift. ");
INSERT INTO deuelo_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Und er brachte das Speisopfer herzu und füllte seine Hand davon und räucherte es auf dem Altar, außer dem Morgenbrandopfer. ");
INSERT INTO deuelo_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Und er schlachtete den Stier und den Widder, das Friedensopfer, welches für das Volk war. Und die Söhne Aarons reichten ihm das Blut, und er sprengte es an den Altar ringsum; ");
INSERT INTO deuelo_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","und die Fettstücke von dem Stier; und von dem Widder den Fettschwanz, und das Eingeweide bedeckt und die Nieren und das Netz der Leber; ");
INSERT INTO deuelo_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","und sie legten die Fettstücke auf die Bruststücke, und er räucherte die Fettstücke auf dem Altar. ");
INSERT INTO deuelo_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Und die Bruststücke und den rechten Schenkel webte Aaron als Webopfer vor Jehova, so wie Mose geboten hatte. ");
INSERT INTO deuelo_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Und Aaron erhob seine Hände gegen das Volk und segnete sie; und er stieg herab nach der Opferung des Sündopfers und des Brandopfers und des Friedensopfers. ");
INSERT INTO deuelo_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Und Mose und Aaron gingen hinein in das Zelt der Zusammenkunft; und sie kamen heraus und segneten das Volk. Und die Herrlichkeit Jehovas erschien dem ganzen Volke; ");
INSERT INTO deuelo_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","und es ging Feuer aus von Jehova und verzehrte auf dem Altar das Brandopfer und die Fettstücke; und das ganze Volk sah es, und sie jauchzten und fielen auf ihr Angesicht. ");
INSERT INTO deuelo_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Und die Söhne Aarons, Nadab und Abihu, nahmen ein jeder seine Räucherpfanne und taten Feuer hinein und legten Räucherwerk darauf und brachten fremdes Feuer vor Jehova dar, das er ihnen nicht geboten hatte. ");
INSERT INTO deuelo_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Da ging Feuer von Jehova aus und verzehrte sie, und sie starben vor Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Und Mose sprach zu Aaron: Dies ist es, was Jehova geredet hat, indem er sprach: In denen, die mir nahen, will ich geheiligt, und vor dem ganzen Volke will ich verherrlicht werden. Und Aaron schwieg. ");
INSERT INTO deuelo_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Und Mose rief Misael und Elzaphan, die Söhne Ussiels, des Oheims Aarons, und sprach zu ihnen: Tretet herzu, traget eure Brüder von dem Heiligtum hinweg außerhalb des Lagers. ");
INSERT INTO deuelo_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Und sie traten herzu und trugen sie in ihren Leibröcken hinweg außerhalb des Lagers, so wie Mose geredet hatte. - ");
INSERT INTO deuelo_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Und Mose sprach zu Aaron und zu Eleasar und zu Ithamar, seinen Söhnen: Eure Häupter sollt ihr nicht entblößen und eure Kleider nicht zerreißen, damit ihr nicht sterbet, und er nicht erzürne über die ganze Gemeinde; aber eure Brüder, das ganze Haus Israel, sollen diesen Brand beweinen, den Jehova angerichtet hat. ");
INSERT INTO deuelo_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Und von dem Eingang des Zeltes der Zusammenkunft sollt ihr nicht weggehen, daß ihr nicht sterbet; denn das Öl der Salbung Jehovas ist auf euch. Und sie taten nach dem Worte Moses. ");
INSERT INTO deuelo_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Und Jehova redete zu Aaron und sprach: ");
INSERT INTO deuelo_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","Wein und starkes Getränk sollst du nicht trinken, du und deine Söhne mit dir, wenn ihr in das Zelt der Zusammenkunft hineingehet, daß ihr nicht sterbet, eine ewige Satzung bei euren Geschlechtern- ");
INSERT INTO deuelo_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","und damit ihr unterscheidet zwischen dem Heiligen und dem Unheiligen und zwischen dem Reinen und dem Unreinen, ");
INSERT INTO deuelo_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","und damit ihr die Kinder Israel lehret alle die Satzungen, die Jehova durch Mose zu euch geredet hat. ");
INSERT INTO deuelo_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Und Mose redete zu Aaron und zu Eleasar und zu Ithamar, seinen Söhnen, den übriggebliebenen: Nehmet das Speisopfer, das von den Feueropfern Jehovas übrigbleibt, und esset es ungesäuert neben dem Altar; denn hochheilig ist es. ");
INSERT INTO deuelo_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Und ihr sollt es essen an heiligem Orte, denn es ist dein Bestimmtes und das Bestimmte deiner Söhne von den Feueropfern Jehovas; denn also ist mir geboten. ");
INSERT INTO deuelo_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Und die Brust des Webopfers und den Schenkel des Hebopfers sollt ihr essen an reinem Orte, du und deine Söhne und deine Töchter mit dir; denn als dein Bestimmtes und das Bestimmte deiner Söhne sind sie gegeben von den Friedensopfern der Kinder Israel. ");
INSERT INTO deuelo_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Den Schenkel des Hebopfers und die Brust des Webopfers sollen sie nebst den Feueropfern der Fettstücke bringen, um sie als Webopfer vor Jehova zu weben; und sie sollen dir gehören und deinen Söhnen mit dir, als eine ewige Gebühr, so wie Jehova geboten hat. ");
INSERT INTO deuelo_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Und Mose suchte eifrig den Bock des Sündopfers, und siehe, er war verbrannt. Und er erzürnte über Eleasar und über Ithamar, die Söhne Aarons, die übriggeblieben, und sprach: ");
INSERT INTO deuelo_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Warum habt ihr nicht das Sündopfer an heiligem Orte gegessen? Denn es ist hochheilig; und er hat es euch gegeben, um die Ungerechtigkeit der Gemeinde zu tragen, um Sühnung für sie zu tun vor Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Siehe, das Blut desselben ist nicht in das Innere des Heiligtums gebracht worden; ihr sollt es jedenfalls im Heiligtum essen, so wie ich geboten habe. ");
INSERT INTO deuelo_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Und Aaron redete zu Mose: Siehe, heute haben sie ihr Sündopfer und ihr Brandopfer vor Jehova dargebracht; und solches ist mir begegnet; und hätte ich heute das Sündopfer gegessen, würde es gut gewesen sein in den Augen Jehovas? ");
INSERT INTO deuelo_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Und Mose hörte es, und es war gut in seinen Augen. ");
INSERT INTO deuelo_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Und Jehova redete zu Mose und zu Aaron und sprach zu ihnen: ");
INSERT INTO deuelo_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Redet zu den Kindern Israel und sprechet: Dies sind die Tiere, die ihr essen sollt von allen Tieren, die auf der Erde sind. ");
INSERT INTO deuelo_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Alles, was gespaltene Hufe, und zwar ganz gespaltene Hufe hat, und wiederkäut unter den Tieren, das sollt ihr essen. ");
INSERT INTO deuelo_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Nur diese sollt ihr nicht essen von den wiederkäuenden und von denen, die gespaltene Hufe haben: das Kamel, denn es wiederkäut, aber es hat keine gespaltenen Hufe: unrein soll es euch sein; ");
INSERT INTO deuelo_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","und den Klippendachs, denn er wiederkäut, aber er hat keine gespaltenen Hufe: unrein soll er euch sein; ");
INSERT INTO deuelo_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","und den Hasen, denn er wiederkäut, aber er hat keine gespaltenen Hufe: unrein soll er euch sein; ");
INSERT INTO deuelo_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","und das Schwein, denn es hat gespaltene Hufe, und zwar ganz gespaltene Hufe, aber es wiederkäut nicht: unrein soll es euch sein. ");
INSERT INTO deuelo_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Von ihrem Fleische sollt ihr nicht essen und ihr Aas nicht anrühren: unrein sollen sie euch sein. ");
INSERT INTO deuelo_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Dieses sollt ihr essen von allem, was in den Wassern ist: alles, was Floßfedern und Schuppen hat in den Wassern, in den Meeren und in den Flüssen, das sollt ihr essen; ");
INSERT INTO deuelo_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","aber alles, was keine Floßfedern und Schuppen hat in den Meeren und in den Flüssen, von allem Gewimmel der Wasser und von jedem lebendigen Wesen, das in den Wassern ist, sie sollen euch ein Greuel sein; ");
INSERT INTO deuelo_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","ja, ein Greuel sollen sie euch sein: von ihrem Fleische sollt ihr nicht essen, und ihr Aas sollt ihr verabscheuen. ");
INSERT INTO deuelo_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Alles, was nicht Floßfedern und Schuppen hat in den Wassern, soll euch ein Greuel sein. ");
INSERT INTO deuelo_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Und diese sollt ihr verabscheuen von den Vögeln; sie sollen nicht gegessen werden, ein Greuel sind sie: den Adler und den Beinbrecher und den Meeradler, ");
INSERT INTO deuelo_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","und den Falken und die Weihe nach ihrer Art, ");
INSERT INTO deuelo_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","alle Raben nach ihrer Art, ");
INSERT INTO deuelo_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","und die Straußhenne und den Straußhahn und die Seemöve und den Habicht nach seiner Art, ");
INSERT INTO deuelo_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","und die Eule und den Sturzpelikan und die Rohrdommel, ");
INSERT INTO deuelo_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","und das Purpurhuhn und den Pelikan und den Aasgeier, ");
INSERT INTO deuelo_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","und den Storch und den Fischreiher nach seiner Art, und den Wiedehopf und die Fledermaus. ");
INSERT INTO deuelo_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Alles geflügelte Gewürm, das auf Vieren geht, soll euch ein Greuel sein. ");
INSERT INTO deuelo_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Nur dieses sollt ihr essen von allem geflügelten Gewürm, das auf Vieren geht: was Schenkel hat oberhalb seiner Füße, um damit auf der Erde zu hüpfen. ");
INSERT INTO deuelo_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Diese sollt ihr von ihnen essen: den Arbeh nach seiner Art und den Solham nach seiner Art und den Chargol nach seiner Art und den Chagab nach seiner Art. ");
INSERT INTO deuelo_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Aber alles geflügelte Gewürm, das vier Füße hat, soll euch ein Greuel sein. ");
INSERT INTO deuelo_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Und durch diese werdet ihr euch verunreinigen; jeder, der ihr Aas anrührt, wird unrein sein bis an den Abend; ");
INSERT INTO deuelo_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","und jeder, der von ihrem Aase trägt, soll seine Kleider waschen und wird unrein sein bis an den Abend. ");
INSERT INTO deuelo_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Jedes Tier, das gespaltene Hufe, aber nicht ganz gespaltene Hufe hat und nicht wiederkäut: Unrein sollen sie euch sein; jeder, der sie anrührt, wird unrein sein. ");
INSERT INTO deuelo_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Und alles, was auf seinen Tatzen geht, unter allem Getier, das auf Vieren geht, sie sollen euch unrein sein; jeder, der ihr Aas anrührt, wird unrein sein bis an den Abend. ");
INSERT INTO deuelo_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Und wer ihr Aas trägt, soll seine Kleider waschen und wird unrein sein bis an den Abend; sie sollen euch unrein sein. ");
INSERT INTO deuelo_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Und diese sollen euch unrein sein unter dem Gewimmel, das auf der Erde wimmelt: der Maulwurf und die Maus und die Eidechse nach ihrer Art, ");
INSERT INTO deuelo_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","und die Anaka und der Koach und der Letaah und der Chomet und das Chamäleon. ");
INSERT INTO deuelo_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Diese sollen euch unrein sein unter allem Gewimmel; jeder, der sie anrührt, wenn sie tot sind, wird unrein sein bis an den Abend. ");
INSERT INTO deuelo_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Und alles, worauf eines von ihnen fällt, wenn sie tot sind, wird unrein sein: jedes Holzgerät oder Kleid oder Fell oder Sack, jedes Gerät, womit eine Arbeit verrichtet wird, es soll ins Wasser getan werden und wird unrein sein bis an den Abend; dann wird es rein sein. ");
INSERT INTO deuelo_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Und jedes irdene Gefäß, in welches eines von ihnen hineinfällt: alles, was darin ist, wird unrein sein, und es selbst sollt ihr zerbrechen. ");
INSERT INTO deuelo_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Alle Speise, die gegessen wird, auf welche solches Wasser kommt, wird unrein sein; und alles Getränk, das getrunken wird, wird unrein sein in jedem solchen Gefäße. ");
INSERT INTO deuelo_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Und alles, worauf von ihrem Aase fällt, wird unrein sein; Ofen und Herd sollen niedergerissen werden, sie sind unrein, und unrein sollen sie euch sein. ");
INSERT INTO deuelo_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Doch Quelle und Zisterne, Wasserbehälter, werden rein sein; wer aber das Aas darin anrührt, wird unrein sein. ");
INSERT INTO deuelo_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Und wenn von ihrem Aase auf irgend welchen Saatsamen fällt, der gesät wird, so ist er rein; ");
INSERT INTO deuelo_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","wenn aber Wasser auf den Samen getan wurde, und es fällt von ihrem Aase auf denselben, so soll er euch unrein sein. ");
INSERT INTO deuelo_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Und wenn eines von dem Vieh stirbt, das euch zur Nahrung dient: wer dessen Aas anrührt, wird unrein sein bis an den Abend. ");
INSERT INTO deuelo_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Und wer von dessen Aas isset, soll seine Kleider waschen und wird unrein sein bis an den Abend; und wer dessen Aas trägt, soll seine Kleider waschen und wird unrein sein bis an den Abend. ");
INSERT INTO deuelo_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Und alles Gewimmel, das auf der Erde wimmelt, ist ein Greuel; es soll nicht gegessen werden. ");
INSERT INTO deuelo_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Alles was auf dem Bauche kriecht, und alles, was auf Vieren geht, bis zu allem Vielfüßigen von allem Gewimmel, das auf der Erde wimmelt: ihr sollt sie nicht essen; denn sie sind ein Greuel. ");
INSERT INTO deuelo_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Machet euch selbst nicht zum Greuel durch irgend ein kriechendes Gewürm, und verunreiniget euch nicht durch sie, so daß ihr dadurch unrein werdet. ");
INSERT INTO deuelo_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Denn ich bin Jehova, euer Gott; so heiliget euch und seid heilig, denn ich bin heilig. Und ihr sollt euch selbst nicht verunreinigen durch irgend ein Gewürm, das sich auf der Erde regt. ");
INSERT INTO deuelo_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Denn ich bin Jehova, der euch aus dem Lande Ägypten heraufgeführt hat, um euer Gott zu sein: so seid heilig, denn ich bin heilig. ");
INSERT INTO deuelo_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Das ist das Gesetz von dem Vieh und dem Gevögel und von jedem lebendigen Wesen, das sich in den Wassern regt, und von jedem Wesen, das auf der Erde kriecht; ");
INSERT INTO deuelo_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","um zu unterscheiden zwischen dem Unreinen und dem Reinen, und zwischen dem Getier, das gegessen wird, und dem Getier, das nicht gegessen werden soll. ");
INSERT INTO deuelo_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Rede zu den Kindern Israel und sprich: Wenn ein Weib empfängt und ein männliches Kind gebiert, so wird sie unrein sein sieben Tage; wie in den Tagen der Unreinheit ihrer Krankheit wird sie unrein sein. ");
INSERT INTO deuelo_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Und am achten Tage soll das Fleisch seiner Vorhaut beschnitten werden. ");
INSERT INTO deuelo_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Und sie soll dreiunddreißig Tage im Blute der Reinigung bleiben; nichts Heiliges soll sie anrühren, und zum Heiligtum soll sie nicht kommen, bis die Tage ihrer Reinigung erfüllt sind. ");
INSERT INTO deuelo_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Und wenn sie ein weibliches Kind gebiert, so wird sie zwei Wochen unrein sein, wie bei ihrer Unreinheit; und sechsundsechzig Tage soll sie im Blute der Reinigung daheim bleiben. ");
INSERT INTO deuelo_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Und wenn die Tage ihrer Reinigung erfüllt sind für einen Sohn oder für eine Tochter, so soll sie ein einjähriges Lamm bringen zum Brandopfer, und eine junge Taube oder eine Turteltaube zum Sündopfer an den Eingang des Zeltes der Zusammenkunft zu dem Priester. ");
INSERT INTO deuelo_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Und er soll es vor Jehova darbringen und Sühnung für sie tun, und sie wird rein sein von dem Flusse ihres Blutes. Das ist das Gesetz der Gebärenden bei einem männlichen oder bei einem weiblichen Kinde. ");
INSERT INTO deuelo_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Und wenn ihre Hand das zu einem Schafe Hinreichende nicht aufbringen kann, so soll sie zwei Turteltauben oder zwei junge Tauben nehmen, eine zum Brandopfer und eine zum Sündopfer; und der Priester soll Sühnung für sie tun, und sie wird rein sein. ");
INSERT INTO deuelo_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Und Jehova redete zu Mose und zu Aaron und sprach: ");
INSERT INTO deuelo_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Wenn ein Mensch in der Haut seines Fleisches eine Erhöhung oder einen Grind oder einen Flecken bekommt, und es wird in der Haut seines Fleisches zu einem Aussatzübel, so soll er zu Aaron, dem Priester, gebracht werden, oder zu einem von seinen Söhnen, den Priestern. ");
INSERT INTO deuelo_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Und besieht der Priester das Übel in der Haut des Fleisches, und das Haar in dem Übel hat sich in weiß verwandelt, und das Übel erscheint tiefer als die Haut seines Fleisches, so ist es das Übel des Aussatzes; und sieht es der Priester, so soll er ihn für unrein erklären. ");
INSERT INTO deuelo_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Und wenn der Flecken in der Haut seines Fleisches weiß ist, und er nicht tiefer erscheint als die Haut, und sein Haar hat sich nicht in weiß verwandelt, so soll der Priester den, der das Übel hat, sieben Tage einschließen. ");
INSERT INTO deuelo_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Und besieht es der Priester am siebten Tage, und siehe, das Übel ist in seinen Augen stehen geblieben, das Übel hat nicht um sich gegriffen in der Haut, so soll der Priester ihn zum zweiten Male sieben Tage einschließen. ");
INSERT INTO deuelo_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Und besieht es der Priester am siebten Tage zum zweiten Male, und siehe, das Übel ist blaß geworden, und das Übel hat nicht um sich gegriffen in der Haut, so soll der Priester ihn für rein erklären: es ist ein Grind; und er soll seine Kleider waschen, und er ist rein. ");
INSERT INTO deuelo_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Wenn aber der Grind in der Haut um sich greift, nachdem er sich dem Priester gezeigt hat zu seiner Reinigung, so soll er sich dem Priester zum zweiten Male zeigen; ");
INSERT INTO deuelo_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","und besieht ihn der Priester, und siehe, der Grind hat in der Haut um sich gegriffen, so soll der Priester ihn für unrein erklären: es ist der Aussatz. ");
INSERT INTO deuelo_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Wenn ein Aussatzübel an einem Menschen entsteht, so soll er zu dem Priester gebracht werden. ");
INSERT INTO deuelo_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Und besieht ihn der Priester, und siehe, es ist eine weiße Erhöhung in der Haut, und sie hat das Haar in weiß verwandelt, und ein Mal rohen Fleisches ist in der Erhöhung, ");
INSERT INTO deuelo_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","so ist es ein alter Aussatz in der Haut seines Fleisches, und der Priester soll ihn für unrein erklären; er soll ihn nicht einschließen, denn er ist unrein. ");
INSERT INTO deuelo_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Wenn aber der Aussatz in der Haut ausbricht, und der Aussatz die ganze Haut dessen, der das Übel hat, bedeckt, von seinem Kopfe bis zu seinen Füßen, wohin auch die Augen des Priesters blicken; ");
INSERT INTO deuelo_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","und der Priester besieht ihn, und siehe, der Aussatz hat sein ganzes Fleisch bedeckt, so soll er den, der das Übel hat, für rein erklären; hat es sich ganz in weiß verwandelt, so ist er rein. ");
INSERT INTO deuelo_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","An dem Tage aber, da rohes Fleisch an ihm gesehen wird, wird er unrein sein. ");
INSERT INTO deuelo_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Und sieht der Priester das rohe Fleisch, so soll er ihn für unrein erklären; das rohe Fleisch ist unrein: es ist der Aussatz. ");
INSERT INTO deuelo_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Wenn aber das rohe Fleisch sich ändert und in weiß verwandelt wird, so soll er zu dem Priester kommen; ");
INSERT INTO deuelo_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","und besieht ihn der Priester, und siehe, das Übel ist in weiß verwandelt, so soll der Priester den, der das Übel hat, für rein erklären: er ist rein. ");
INSERT INTO deuelo_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Und wenn im Fleische, in dessen Haut, eine Beule entsteht und wieder heilt, ");
INSERT INTO deuelo_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","und es entsteht an der Stelle der Beule eine weiße Erhöhung oder ein weiß-rötlicher Flecken, so soll er sich dem Priester zeigen; ");
INSERT INTO deuelo_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","und besieht ihn der Priester, und siehe, der Flecken erscheint niedriger als die Haut, und sein Haar hat sich in weiß verwandelt, so soll der Priester ihn für unrein erklären; es ist das Übel des Aussatzes, er ist in der Beule ausgebrochen. ");
INSERT INTO deuelo_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Und wenn der Priester ihn besieht, und siehe, es ist kein weißes Haar darin, und der Flecken ist nicht niedriger als die Haut und ist blaß, so soll der Priester ihn sieben Tage einschließen. ");
INSERT INTO deuelo_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Wenn er aber in der Haut um sich greift, so soll der Priester ihn für unrein erklären: es ist das Übel. ");
INSERT INTO deuelo_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Und wenn der Flecken an seiner Stelle stehen bleibt, wenn er nicht um sich gegriffen hat, so ist es die Narbe der Beule; und der Priester soll ihn für rein erklären. ");
INSERT INTO deuelo_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Oder wenn in der Haut des Fleisches eine feurige Entzündung entsteht, und das Mal der Entzündung wird ein weiß-rötlicher oder weißer Flecken, ");
INSERT INTO deuelo_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","und der Priester besieht ihn, und siehe, das Haar ist in weiß verwandelt in dem Flecken, und er erscheint tiefer als die Haut, so ist es der Aussatz; er ist in der Entzündung ausgebrochen, und der Priester soll ihn für unrein erklären: es ist das Übel des Aussatzes. ");
INSERT INTO deuelo_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Und wenn der Priester ihn besieht, und siehe, es ist kein weißes Haar in dem Flecken, und er ist nicht niedriger als die Haut und ist blaß, so soll der Priester ihn sieben Tage einschließen. ");
INSERT INTO deuelo_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Und der Priester soll ihn am siebten Tage besehen; wenn er in der Haut um sich greift, so soll der Priester ihn für unrein erklären: es ist das Übel des Aussatzes. ");
INSERT INTO deuelo_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Und wenn der Flecken an seiner Stelle stehen bleibt, wenn er nicht um sich gegriffen hat in der Haut und ist blaß, so ist es die Erhöhung der Entzündung; und der Priester soll ihn für rein erklären, denn es ist die Narbe der Entzündung. ");
INSERT INTO deuelo_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Und wenn ein Mann oder ein Weib ein Übel am Haupte oder am Barte bekommt, ");
INSERT INTO deuelo_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","und der Priester besieht das Übel, und siehe, es erscheint tiefer als die Haut, und goldgelbes, dünnes Haar ist darin, so soll der Priester ihn für unrein erklären: es ist Schorf, es ist der Aussatz des Hauptes oder des Bartes. ");
INSERT INTO deuelo_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Und wenn der Priester das Übel des Schorfes besieht, und siehe, es erscheint nicht tiefer als die Haut, und es ist kein schwarzes Haar darin, so soll der Priester den, der das Übel des Schorfes hat, sieben Tage einschließen. ");
INSERT INTO deuelo_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Und besieht der Priester das Übel am siebten Tage, und siehe, der Schorf hat nicht um sich gegriffen, und es ist kein goldgelbes Haar darin, und der Schorf erscheint nicht tiefer als die Haut, ");
INSERT INTO deuelo_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","so soll er sich scheren; aber den Schorf soll er nicht scheren; und der Priester schließe den, der den Schorf hat, zum zweiten Male sieben Tage ein. ");
INSERT INTO deuelo_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Und besieht der Priester den Schorf am siebten Tage, und siehe, der Schorf hat nicht um sich gegriffen in der Haut, und er erscheint nicht tiefer als die Haut, so soll der Priester ihn für rein erklären; und er soll seine Kleider waschen, und er ist rein. ");
INSERT INTO deuelo_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Wenn aber, nach seiner Reinigung, der Schorf in der Haut um sich greift, ");
INSERT INTO deuelo_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","und der Priester besieht ihn, und siehe, der Schorf hat in der Haut um sich gegriffen, so soll der Priester nicht nach dem goldgelben Haare forschen; er ist unrein. ");
INSERT INTO deuelo_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Und wenn in seinen Augen der Schorf stehen geblieben ist, und es ist schwarzes Haar darin gewachsen, so ist der Schorf geheilt; er ist rein, und der Priester soll ihn für rein erklären. ");
INSERT INTO deuelo_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Und wenn ein Mann oder ein Weib in der Haut ihres Fleisches Flecken bekommen, weiße Flecken, ");
INSERT INTO deuelo_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","und der Priester besieht sie, und siehe, in der Haut ihres Fleisches sind blasse, weiße Flecken, so ist es ein Ausschlag, der in der Haut ausgebrochen ist: er ist rein. ");
INSERT INTO deuelo_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Und wenn einem Manne das Haupthaar ausfällt, so ist er ein Glatzkopf: er ist rein; ");
INSERT INTO deuelo_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","und wenn ihm das Haupthaar gegen das Gesicht zu ausfällt, so ist er ein Kahlkopf: er ist rein. ");
INSERT INTO deuelo_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Und wenn an der Hinter-oder an der Vorderglatze ein weiß-rötliches Übel ist, so ist es der Aussatz, der an seiner Hinter-oder an seiner Vorderglatze ausgebrochen ist. ");
INSERT INTO deuelo_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Und besieht ihn der Priester, und siehe, die Erhöhung des Übels ist weiß-rötlich an seiner Hinter-oder an seiner Vorderglatze, gleich dem Aussehen des Aussatzes in der Haut des Fleisches, ");
INSERT INTO deuelo_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","so ist er ein aussätziger Mann: Er ist unrein; der Priester soll ihn für gänzlich unrein erklären; sein Übel ist an seinem Haupte. ");
INSERT INTO deuelo_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Und der Aussätzige, an dem das Übel ist, seine Kleider sollen zerrissen, und sein Haupt soll entblößt sein, und er soll seinen Bart verhüllen und ausrufen: Unrein, unrein! ");
INSERT INTO deuelo_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Alle die Tage, da das Übel an ihm ist, soll er unrein sein; er ist unrein: allein soll er wohnen, außerhalb des Lagers soll seine Wohnung sein. ");
INSERT INTO deuelo_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Und wenn an einem Kleide ein Aussatzübel entsteht, an einem Kleide von Wolle oder an einem Kleide von Linnen; ");
INSERT INTO deuelo_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","oder an einer Kette oder an einem Einschlag von Linnen oder von Wolle; oder an einem Felle oder an irgend einem Fellwerk; ");
INSERT INTO deuelo_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","und das Übel ist grünlich oder rötlich am Kleide, oder am Felle, oder an der Kette oder am Einschlag, oder an irgend einem Gerät von Fell, so ist es das Übel des Aussatzes, und man soll es den Priester besehen lassen. ");
INSERT INTO deuelo_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Und der Priester besehe das Übel und schließe das, woran das Übel ist, sieben Tage ein. ");
INSERT INTO deuelo_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Und sieht er das Übel am siebten Tage, daß das Übel um sich gegriffen hat am Kleide, oder an der Kette oder am Einschlag, oder am Felle nach allem, wozu das Fell verarbeitet wird, so ist das Übel ein fressender Aussatz: es ist unrein. ");
INSERT INTO deuelo_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Und man soll das Kleid, oder die Kette oder den Einschlag von Wolle oder von Linnen, oder jedes Gerät von Fell, woran das Übel ist, verbrennen; denn es ist ein fressender Aussatz: es soll mit Feuer verbrannt werden. ");
INSERT INTO deuelo_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Und wenn der Priester es besieht, und siehe, das Übel hat nicht um sich gegriffen am Kleide, oder an der Kette oder am Einschlag, oder an irgend einem Gerät von Fell, ");
INSERT INTO deuelo_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","so soll der Priester gebieten, daß man das wasche, woran das Übel ist; und er soll es zum zweiten Male sieben Tage einschließen. ");
INSERT INTO deuelo_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Und besieht der Priester das Übel nach dem Waschen, und siehe, das Übel hat sein Aussehen nicht geändert, und das Übel hat nicht um sich gegriffen, so ist es unrein; du sollst es mit Feuer verbrennen: es ist eine Vertiefung auf seiner kahlen Hinter-oder Vorderseite. ");
INSERT INTO deuelo_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Und wenn der Priester es besieht, und siehe, das Übel ist blaß geworden nach dem Waschen, so soll er es abreißen vom Kleide, oder vom Felle, oder von der Kette oder vom Einschlag. ");
INSERT INTO deuelo_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Und wenn es noch gesehen wird am Kleide, oder an der Kette oder am Einschlag, oder an irgend einem Gerät von Fell, so ist es ein ausbrechender Aussatz: du sollst mit Feuer verbrennen, woran das Übel ist. ");
INSERT INTO deuelo_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Und das Kleid, oder die Kette oder der Einschlag, oder irgend ein Gerät von Fell, das du wäschest, und das Übel weicht daraus: es soll zum zweiten Male gewaschen werden, und es ist rein. ");
INSERT INTO deuelo_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Das ist das Gesetz des Aussatzübels an einem Kleide von Wolle oder von Linnen, oder an einer Kette oder an einem Einschlag, oder an irgend einem Gerät von Fell, um es für rein oder für unrein zu erklären. ");
INSERT INTO deuelo_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Dies soll das Gesetz des Aussätzigen sein am Tage seiner Reinigung: Er soll zu dem Priester gebracht werden; ");
INSERT INTO deuelo_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","und der Priester soll außerhalb des Lagers gehen; und besieht ihn der Priester, und siehe, das Übel des Aussatzes ist heil geworden an dem Aussätzigen, ");
INSERT INTO deuelo_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","so soll der Priester gebieten, daß man für den, der zu reinigen ist, zwei lebendige, reine Vögel nehme und Cedernholz und Karmesin und Ysop. ");
INSERT INTO deuelo_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Und der Priester soll gebieten, daß man den einen Vogel schlachte in ein irdenes Gefäß über lebendigem Wasser. ");
INSERT INTO deuelo_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Den lebendigen Vogel soll er nehmen, ihn und das Cedernholz und das Karmesin und den Ysop, und dieses und den lebendigen Vogel in das Blut des Vogels tauchen, der geschlachtet worden ist über dem lebendigen Wasser; ");
INSERT INTO deuelo_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","und er soll auf den, der vom Aussatze zu reinigen ist, siebenmal sprengen und ihn für rein erklären; und den lebendigen Vogel soll er ins freie Feld fliegen lassen. ");
INSERT INTO deuelo_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Und der zu reinigen ist, soll seine Kleider waschen und all sein Haar scheren und sich im Wasser baden; und er ist rein. Und danach darf er ins Lager kommen, aber er soll sieben Tage außerhalb seines Zeltes bleiben. ");
INSERT INTO deuelo_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Und es soll geschehen, am siebten Tage soll er all sein Haar scheren, sein Haupt und seinen Bart und seine Augenbrauen; ja, all sein Haar soll er scheren und seine Kleider waschen und sein Fleisch im Wasser baden; und er ist rein. ");
INSERT INTO deuelo_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Und am achten Tage soll er zwei Lämmer nehmen, ohne Fehl, und ein weibliches Lamm, einjährig, ohne Fehl, und drei Zehntel Feinmehl, gemengt mit Öl, zum Speisopfer, und ein Log Öl. ");
INSERT INTO deuelo_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Und der reinigende Priester soll den Mann, der zu reinigen ist, und diese Dinge vor Jehova stellen an den Eingang des Zeltes der Zusammenkunft. ");
INSERT INTO deuelo_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Und der Priester nehme das eine Lamm und bringe es zum Schuldopfer dar mit dem Log Öl und webe sie als Webopfer vor Jehova; ");
INSERT INTO deuelo_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Und er schlachte das Lamm an dem Orte, wo man das Sündopfer und das Brandopfer schlachtet, an heiligem Orte; denn wie das Sündopfer, so gehört das Schuldopfer dem Priester: es ist hochheilig. ");
INSERT INTO deuelo_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Und der Priester nehme von dem Blute des Schuldopfers, und der Priester tue es auf das rechte Ohrläppchen dessen, der zu reinigen ist, und auf den Daumen seiner rechten Hand und auf die große Zehe seines rechten Fußes. ");
INSERT INTO deuelo_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Und der Priester nehme von dem Log Öl und gieße es in seine linke Hand; ");
INSERT INTO deuelo_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","und der Priester tauche seinen rechten Finger in das Öl, das in seiner linken Hand ist, und sprenge von dem Öle mit seinem Finger siebenmal vor Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Und von dem Übrigen des Öles, das in seiner Hand ist, soll der Priester auf das rechte Ohrläppchen dessen tun, der zu reinigen ist, und auf den Daumen seiner rechten Hand und auf die große Zehe seines rechten Fußes, auf das Blut des Schuldopfers. ");
INSERT INTO deuelo_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Und das Übrige des Öles, das in der Hand des Priesters ist, soll er auf das Haupt dessen tun, der zu reinigen ist; und der Priester soll Sühnung für ihn tun vor Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Und der Priester soll das Sündopfer opfern und Sühnung tun für den, der von seiner Unreinheit zu reinigen ist; und danach soll er das Brandopfer schlachten. ");
INSERT INTO deuelo_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Und der Priester soll das Brandopfer und das Speisopfer auf dem Altar opfern. Und so tue der Priester Sühnung für ihn; und er ist rein. ");
INSERT INTO deuelo_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Und wenn er arm ist und seine Hand es nicht aufbringen kann, so soll er ein Lamm als Schuldopfer nehmen zum Webopfer, um Sühnung für ihn zu tun; und ein Zehntel Feinmehl, gemengt mit Öl, zum Speisopfer, und ein Log Öl; ");
INSERT INTO deuelo_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","und zwei Turteltauben oder zwei junge Tauben, die seine Hand aufbringen kann; und die eine soll ein Sündopfer und die andere ein Brandopfer sein. ");
INSERT INTO deuelo_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Und er soll sie am achten Tage seiner Reinigung zu dem Priester bringen an den Eingang des Zeltes der Zusammenkunft vor Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Und der Priester nehme das Lamm des Schuldopfers und das Log Öl, und der Priester webe sie als Webopfer vor Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Und er schlachte das Lamm des Schuldopfers; und der Priester nehme von dem Blute des Schuldopfers und tue es auf das rechte Ohrläppchen dessen, der zu reinigen ist, und auf den Daumen seiner rechten Hand und auf die große Zehe seines rechten Fußes. ");
INSERT INTO deuelo_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Und der Priester gieße von dem Öle in seine linke Hand; ");
INSERT INTO deuelo_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","und der Priester sprenge mit seinem rechten Finger von dem Öle, das in seiner linken Hand ist, siebenmal vor Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Und der Priester tue von dem Öle, das in seiner Hand ist, auf das rechte Ohrläppchen dessen, der zu reinigen ist, und auf den Daumen seiner rechten Hand und auf die große Zehe seines rechten Fußes, auf die Stelle des Blutes des Schuldopfers. ");
INSERT INTO deuelo_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Und das Übrige des Öles, das in der Hand des Priesters ist, soll er auf das Haupt dessen tun, der zu reinigen ist, um Sühnung für ihn zu tun vor Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Und er soll die eine von den Turteltauben oder von den jungen Tauben opfern, von dem, was seine Hand aufbringen kann, - ");
INSERT INTO deuelo_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","das, was seine Hand aufbringen kann: Die eine als Sündopfer und die andere als Brandopfer, nebst dem Speisopfer. Und so tue der Priester Sühnung vor Jehova für den, der zu reinigen ist. ");
INSERT INTO deuelo_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Das ist das Gesetz für den, an welchem das Übel des Aussatzes ist, dessen Hand bei seiner Reinigung nicht aufbringen kann, was vorgeschrieben ist. ");
INSERT INTO deuelo_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Und Jehova redete zu Mose und zu Aaron und sprach: ");
INSERT INTO deuelo_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","Wenn ihr in das Land Kanaan kommet, das ich euch zum Eigentum gebe, und ich ein Aussatzübel an ein Haus setze im Lande eures Eigentums, ");
INSERT INTO deuelo_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","so soll der, dem das Haus gehört, kommen und es dem Priester anzeigen und sprechen: Es sieht mir aus wie ein Übel am Hause. ");
INSERT INTO deuelo_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Und der Priester soll gebieten, daß man das Haus ausräume, ehe der Priester hineingeht, das Übel zu besehen, damit nicht unrein werde alles, was im Hause ist; und danach soll der Priester hineingehen, das Haus zu besehen. ");
INSERT INTO deuelo_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Und besieht er das Übel, und siehe, das Übel ist an den Wänden des Hauses, grünliche oder rötliche Vertiefungen, und sie erscheinen tiefer als die Wand, ");
INSERT INTO deuelo_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","so soll der Priester aus dem Hause hinaus an den Eingang des Hauses gehen und das Haus sieben Tage verschließen. ");
INSERT INTO deuelo_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Und der Priester soll am siebten Tage wiederkommen; und besieht er es, und siehe, das Übel hat um sich gegriffen an den Wänden des Hauses, ");
INSERT INTO deuelo_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","so soll der Priester gebieten, daß man die Steine, an denen das Übel ist, herausreiße, und sie hinauswerfe außerhalb der Stadt an einen unreinen Ort. ");
INSERT INTO deuelo_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Und das Haus soll man inwendig ringsum abkratzen, und den Lehm, den man abgekratzt hat, hinausschütten außerhalb der Stadt an einen unreinen Ort. ");
INSERT INTO deuelo_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Und man soll andere Steine nehmen und sie an die Stelle der Steine bringen, und man soll anderen Lehm nehmen und das Haus bewerfen. ");
INSERT INTO deuelo_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Und wenn das Übel wiederkehrt und am Hause ausbricht nach dem Ausreißen der Steine und nach dem Abkratzen des Hauses und nach dem Bewerfen, ");
INSERT INTO deuelo_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","so soll der Priester kommen; und besieht er es, und siehe, das Übel hat um sich gegriffen am Hause, so ist es ein fressender Aussatz am Hause: es ist unrein. ");
INSERT INTO deuelo_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Und man soll das Haus niederreißen, seine Steine und sein Holz und allen Lehm des Hauses, und es hinausschaffen außerhalb der Stadt an einen unreinen Ort. ");
INSERT INTO deuelo_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Und wer in das Haus hineingeht, so lange es verschlossen ist, wird unrein bis an den Abend; ");
INSERT INTO deuelo_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","und wer in dem Hause schläft, soll seine Kleider waschen; und wer in dem Hause isset, soll seine Kleider waschen. ");
INSERT INTO deuelo_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Wenn aber der Priester hineingeht und es besieht, und siehe, das Übel hat nicht um sich gegriffen am Hause nach dem Bewerfen des Hauses, so soll der Priester das Haus für rein erklären; denn das Übel ist heil geworden. ");
INSERT INTO deuelo_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Und er soll, um das Haus zu entsündigen, zwei Vögel nehmen und Cedernholz und Karmesin und Ysop; ");
INSERT INTO deuelo_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","und er schlachte den einen Vogel in ein irdenes Gefäß über lebendigem Wasser; ");
INSERT INTO deuelo_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","und er nehme das Cedernholz und den Ysop und das Karmesin und den lebendigen Vogel und tauche sie in das Blut des geschlachteten Vogels und in das lebendige Wasser und besprenge das Haus siebenmal; ");
INSERT INTO deuelo_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","und er entsündige das Haus mit dem Blute des Vogels und mit dem lebendigen Wasser und mit dem lebendigen Vogel und mit dem Cedernholz und mit dem Ysop und mit dem Karmesin; ");
INSERT INTO deuelo_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","und den lebendigen Vogel soll er ins freie Feld fliegen lassen außerhalb der Stadt. Und so tue er Sühnung für das Haus; und er wird rein sein. ");
INSERT INTO deuelo_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Das ist das Gesetz für alles Übel des Aussatzes und für den Schorf, ");
INSERT INTO deuelo_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","und für den Aussatz der Kleider und der Häuser, ");
INSERT INTO deuelo_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","und für die Erhöhung und für den Grind und für den Flecken; ");
INSERT INTO deuelo_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","um zu belehren, wann für unrein und wann für rein zu erklären ist: das ist das Gesetz des Aussatzes. ");
INSERT INTO deuelo_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Und Jehova redete zu Mose und zu Aaron und sprach: ");
INSERT INTO deuelo_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Redet zu den Kindern Israel und sprechet zu ihnen: Wenn irgend ein Mann an seinem Fleische flüssig ist, so ist er unrein durch seinen Fluß. ");
INSERT INTO deuelo_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Und dies wird seine Unreinheit sein bei seinem Flusse: Läßt sein Fleisch seinen Fluß triefen, oder hält sein Fleisch seinen Fluß zurück, so ist das seine Unreinheit. ");
INSERT INTO deuelo_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Jedes Lager, worauf der Flüssige liegt, wird unrein sein, und jedes Gerät, worauf er sitzt, wird unrein sein. ");
INSERT INTO deuelo_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Und wer sein Lager anrührt, soll seine Kleider waschen und sich im Wasser baden, und er wird unrein sein bis an den Abend. ");
INSERT INTO deuelo_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Und wer sich auf das Gerät setzt, worauf der Flüssige gesessen hat, soll seine Kleider waschen und sich im Wasser baden, und er wird unrein sein bis an den Abend. ");
INSERT INTO deuelo_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Und wer das Fleisch des Flüssigen anrührt, soll seine Kleider waschen und sich im Wasser baden, und er wird unrein sein bis an den Abend. ");
INSERT INTO deuelo_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Und wenn der Flüssige auf einen Reinen speit, so soll dieser seine Kleider waschen und sich im Wasser baden, und er wird unrein sein bis an den Abend. ");
INSERT INTO deuelo_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Und jeder Wagen, auf welchem der Flüssige fährt, wird unrein sein. ");
INSERT INTO deuelo_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Und jeder, der irgend etwas anrührt, was er unter sich hat, wird unrein sein bis an den Abend; und wer es trägt, soll seine Kleider waschen und sich im Wasser baden, und er wird unrein sein bis an den Abend. ");
INSERT INTO deuelo_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Und jeder, den der Flüssige anrührt, und er hat seine Hände nicht im Wasser abgespült, der soll seine Kleider waschen und sich im Wasser baden, und er wird unrein sein bis an den Abend. ");
INSERT INTO deuelo_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Und das irdene Gefäß, das der Flüssige anrührt, soll zerbrochen werden, und jedes hölzerne Gefäß soll im Wasser gespült werden. ");
INSERT INTO deuelo_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Und wenn der Flüssige rein wird von seinem Flusse, so soll er sich sieben Tage zählen zu seiner Reinigung; und er soll seine Kleider waschen und sein Fleisch in lebendigem Wasser baden, und er wird rein sein. ");
INSERT INTO deuelo_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Und am achten Tage soll er sich zwei Turteltauben oder zwei junge Tauben nehmen und vor Jehova kommen an den Eingang des Zeltes der Zusammenkunft und sie dem Priester geben; ");
INSERT INTO deuelo_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","und der Priester soll sie opfern, die eine als Sündopfer und die andere als Brandopfer. Und so tue der Priester Sühnung für ihn vor Jehova wegen seines Flusses. ");
INSERT INTO deuelo_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Und wenn einem Manne der Samenerguß entgeht, so soll er sein ganzes Fleisch im Wasser baden, und er wird unrein sein bis an den Abend. ");
INSERT INTO deuelo_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Und jedes Kleid und jedes Fell, worauf der Samenerguß kommt, soll im Wasser gewaschen werden, und es wird unrein sein bis an den Abend. ");
INSERT INTO deuelo_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Und ein Weib, bei welchem ein Mann liegt mit Samenerguß, sie sollen sich im Wasser baden, und werden unrein sein bis an den Abend. ");
INSERT INTO deuelo_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Und wenn ein Weib flüssig ist, und ihr Fluß an ihrem Fleische Blut ist, so soll sie sieben Tage in ihrer Unreinheit sein; und jeder, der sie anrührt, wird unrein sein bis an den Abend. ");
INSERT INTO deuelo_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Und alles, worauf sie in ihrer Unreinheit liegt, wird unrein sein, und alles, worauf sie sitzt, wird unrein sein. ");
INSERT INTO deuelo_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Und jeder, der ihr Lager anrührt, soll seine Kleider waschen und sich im Wasser baden, und er wird unrein sein bis an den Abend. ");
INSERT INTO deuelo_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Und jeder, der irgend ein Gerät anrührt, worauf sie gesessen hat, soll seine Kleider waschen und sich im Wasser baden, und er wird unrein sein bis an den Abend. ");
INSERT INTO deuelo_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Und wenn etwas auf dem Lager oder auf dem Gerät ist, worauf sie gesessen hat, wenn er es anrührt, wird er unrein sein bis an den Abend. ");
INSERT INTO deuelo_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Und wenn etwa ein Mann neben ihr liegt, und ihre Unreinigkeit kommt an ihn, so wird er sieben Tage unrein sein; und jedes Lager, worauf er liegt, wird unrein sein. ");
INSERT INTO deuelo_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Und wenn ein Weib ihren Blutfluß viele Tage hat außer der Zeit ihrer Unreinheit, oder wenn sie den Fluß hat über ihre Unreinheit hinaus, so soll sie alle die Tage des Flusses ihrer Unreinigkeit sein wie in den Tagen ihrer Unreinheit: sie ist unrein. ");
INSERT INTO deuelo_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Jedes Lager, worauf sie alle Tage ihres Flusses liegt, soll ihr sein wie das Lager ihrer Unreinheit, und jedes Gerät, worauf sie sitzt, wird unrein sein nach der Unreinigkeit ihrer Unreinheit. ");
INSERT INTO deuelo_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Und jeder, der es anrührt, wird unrein sein; und er soll seine Kleider waschen und sich im Wasser baden, und er wird unrein sein bis an den Abend. ");
INSERT INTO deuelo_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Und wenn sie rein geworden ist von ihrem Flusse, so soll sie sich sieben Tage zählen, und danach wird sie rein sein. ");
INSERT INTO deuelo_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Und am achten Tage soll sie sich zwei Turteltauben oder zwei junge Tauben nehmen und sie zu dem Priester bringen an den Eingang des Zeltes der Zusammenkunft; ");
INSERT INTO deuelo_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","und der Priester soll die eine als Sündopfer und die andere als Brandopfer opfern. Und so tue der Priester Sühnung für sie vor Jehova wegen des Flusses ihrer Unreinigkeit. ");
INSERT INTO deuelo_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Und ihr sollt die Kinder Israel absondern von ihrer Unreinigkeit, daß sie nicht in ihrer Unreinigkeit sterben, indem sie meine Wohnung verunreinigen, die in ihrer Mitte ist. ");
INSERT INTO deuelo_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Das ist das Gesetz für den Flüssigen und für den, dem der Samenerguß entgeht, so daß er durch ihn unrein wird; ");
INSERT INTO deuelo_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","und für die, welche krank ist in ihrer Unreinheit, und für den, der seinen Fluß hat, es sei Mann oder Weib, und für den Mann, der neben einer Unreinen liegt. ");
INSERT INTO deuelo_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Und Jehova redete zu Mose nach dem Tode der beiden Söhne Aarons, als sie vor Jehova nahten und starben; ");
INSERT INTO deuelo_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","und Jehova sprach zu Mose: Rede zu deinem Bruder Aaron, daß er nicht zu aller Zeit in das Heiligtum hineingehe innerhalb des Vorhangs, vor den Deckel, der auf der Lade ist, damit er nicht sterbe; denn ich erscheine in der Wolke über dem Deckel. ");
INSERT INTO deuelo_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Auf diese Weise soll Aaron in das Heiligtum hineingehen: mit einem jungen Farren zum Sündopfer und einem Widder zum Brandopfer. ");
INSERT INTO deuelo_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Er soll einen heiligen Leibrock von Linnen anziehen, und Beinkleider von Linnen sollen auf seinem Fleische sein, und mit einem Gürtel von Linnen soll er sich umgürten, und einen Kopfbund von Linnen sich umbinden: das sind heilige Kleider; und er soll sein Fleisch im Wasser baden und sie anziehen. ");
INSERT INTO deuelo_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Und von der Gemeinde der Kinder Israel soll er zwei Ziegenböcke nehmen zum Sündopfer und einen Widder zum Brandopfer. ");
INSERT INTO deuelo_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Und Aaron soll den Farren des Sündopfers, der für ihn ist, herzubringen und Sühnung tun für sich und für sein Haus. ");
INSERT INTO deuelo_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Und er soll die zwei Böcke nehmen und sie vor Jehova stellen an den Eingang des Zeltes der Zusammenkunft. ");
INSERT INTO deuelo_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Und Aaron soll Lose werfen über die zwei Böcke, ein Los für Jehova und ein Los für Asasel. ");
INSERT INTO deuelo_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Und Aaron soll den Bock herzubringen, auf welchen das Los für Jehova gefallen ist, und ihn opfern als Sündopfer. ");
INSERT INTO deuelo_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Und der Bock, auf welchen das Los für Asasel gefallen ist, soll lebendig vor Jehova gestellt werden, um auf ihm Sühnung zu tun, um ihn als Asasel fortzuschicken in die Wüste. ");
INSERT INTO deuelo_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Und Aaron bringe den Farren des Sündopfers, der für ihn ist, herzu und tue Sühnung für sich und für sein Haus, und schlachte den Farren des Sündopfers, der für ihn ist. ");
INSERT INTO deuelo_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Und er nehme eine Pfanne voll Feuerkohlen von dem Altar, vor Jehova, und seine beiden Hände voll wohlriechenden, kleingestoßenen Räucherwerks, und bringe es innerhalb des Vorhangs. ");
INSERT INTO deuelo_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Und er lege das Räucherwerk auf das Feuer vor Jehova, damit die Wolke des Räucherwerks den Deckel bedecke, der auf dem Zeugnis ist, und er nicht sterbe. ");
INSERT INTO deuelo_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Und er nehme von dem Blute des Farren und sprenge mit seinem Finger auf die Vorderseite des Deckels gegen Osten; und vor den Deckel soll er von dem Blute siebenmal sprengen mit seinem Finger. ");
INSERT INTO deuelo_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Und er schlachte den Bock des Sündopfers, der für das Volk ist, und bringe sein Blut innerhalb des Vorhangs, und tue mit seinem Blute, so wie er mit dem Blute des Farren getan hat, und sprenge es auf den Deckel und vor den Deckel; ");
INSERT INTO deuelo_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Und er tue Sühnung für das Heiligtum wegen der Unreinigkeiten der Kinder Israel und wegen ihrer Übertretungen, nach allen ihren Sünden; und ebenso soll er für das Zelt der Zusammenkunft tun, das bei ihnen weilt, inmitten ihrer Unreinigkeiten. ");
INSERT INTO deuelo_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Und kein Mensch soll in dem Zelte der Zusammenkunft sein, wenn er hineingeht, um Sühnung zu tun im Heiligtum, bis er hinausgeht. Und so tue er Sühnung für sich und für sein Haus und für die ganze Versammlung Israels. ");
INSERT INTO deuelo_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Und er soll hinausgehen zu dem Altar, der vor Jehova ist, und Sühnung für ihn tun; und er nehme von dem Blute des Farren und von dem Blute des Bockes und tue es an die Hörner des Altars ringsum, ");
INSERT INTO deuelo_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","und sprenge von dem Blute mit seinem Finger siebenmal an denselben und reinige ihn und heilige ihn von den Unreinigkeiten der Kinder Israel. ");
INSERT INTO deuelo_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Und hat er die Sühnung des Heiligtums und des Zeltes der Zusammenkunft und des Altars vollendet, so soll er den lebendigen Bock herzubringen. ");
INSERT INTO deuelo_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Und Aaron lege seine beiden Hände auf den Kopf des lebendigen Bockes und bekenne auf ihn alle Ungerechtigkeiten der Kinder Israel und alle ihre Übertretungen nach allen ihren Sünden; und er lege sie auf den Kopf des Bockes und schicke ihn durch einen bereitstehenden Mann fort in die Wüste, ");
INSERT INTO deuelo_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","damit der Bock alle ihre Ungerechtigkeiten auf sich trage in ein ödes Land; und er schicke den Bock fort in die Wüste. ");
INSERT INTO deuelo_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Und Aaron soll in das Zelt der Zusammenkunft hineingehen und die Kleider von Linnen ausziehen, die er anzog, als er in das Heiligtum hineinging, und sie dort niederlegen; ");
INSERT INTO deuelo_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","und er soll sein Fleisch im Wasser baden an heiligem Orte und seine Kleider anziehen; und er soll hinausgehen und sein Brandopfer und das Brandopfer des Volkes opfern und Sühnung tun für sich und für das Volk. ");
INSERT INTO deuelo_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Und das Fett des Sündopfers soll er auf dem Altar räuchern. ");
INSERT INTO deuelo_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Und wer den Bock als Asasel fortführt, soll seine Kleider waschen und sein Fleisch im Wasser baden; und danach darf er ins Lager kommen. ");
INSERT INTO deuelo_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Und den Farren des Sündopfers und den Bock des Sündopfers, deren Blut hineingebracht worden ist, um Sühnung zu tun im Heiligtum, soll man hinausschaffen außerhalb des Lagers, und ihre Häute und ihr Fleisch und ihren Mist mit Feuer verbrennen. ");
INSERT INTO deuelo_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Und der sie verbrennt, soll seine Kleider waschen und sein Fleisch im Wasser baden; und danach darf er ins Lager kommen. ");
INSERT INTO deuelo_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Und dies soll euch zur ewigen Satzung sein: Im siebten Monat, am Zehnten des Monats, sollt ihr eure Seelen kasteien und keinerlei Arbeit tun, der Eingeborene und der Fremdling, der in eurer Mitte weilt; ");
INSERT INTO deuelo_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","denn an diesem Tage wird man Sühnung für euch tun, um euch zu reinigen: von allen euren Sünden werdet ihr rein sein vor Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Ein Sabbath der Ruhe soll er euch sein, und ihr sollt eure Seelen kasteien, eine ewige Satzung. ");
INSERT INTO deuelo_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Und es soll Sühnung tun der Priester, den man salben und den man weihen wird, um den Priesterdienst auszuüben an seines Vaters Statt; und er soll die Kleider von Linnen anziehen, die heiligen Kleider; ");
INSERT INTO deuelo_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","und er soll Sühnung tun für das heilige Heiligtum und für das Zelt der Zusammenkunft, und für den Altar soll er Sühnung tun, und für die Priester und für das ganze Volk der Gemeinde soll er Sühnung tun. ");
INSERT INTO deuelo_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Und das soll euch zur ewigen Satzung sein, um für die Kinder Israel Sühnung zu tun wegen aller ihrer Sünden einmal im Jahre. Und er tat, so wie Jehova dem Mose geboten hatte. ");
INSERT INTO deuelo_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Rede zu Aaron und zu seinen Söhnen und zu allen Kindern Israel und sprich zu ihnen: Dies ist es, was Jehova geboten und gesagt hat: ");
INSERT INTO deuelo_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Jedermann aus dem Hause Israel, der ein Rind oder ein Schaf oder eine Ziege im Lager schlachtet, oder der außerhalb des Lagers schlachtet, ");
INSERT INTO deuelo_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","und es nicht an den Eingang des Zeltes der Zusammenkunft gebracht hat, um es Jehova als Opfergabe darzubringen vor der Wohnung Jehovas, selbigem Manne soll Blut zugerechnet werden: Blut hat er vergossen, und selbiger Mann soll ausgerottet werden aus der Mitte seines Volkes; ");
INSERT INTO deuelo_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","auf daß die Kinder Israel ihre Schlachtopfer bringen, die sie auf freiem Felde schlachten, daß sie sie Jehova bringen an den Eingang des Zeltes der Zusammenkunft zu dem Priester und sie als Friedensopfer dem Jehova schlachten. ");
INSERT INTO deuelo_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Und der Priester soll das Blut an den Altar Jehovas sprengen vor dem Eingang des Zeltes der Zusammenkunft und das Fett räuchern zum lieblichen Geruch dem Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Und sie sollen nicht mehr ihre Schlachtopfer den Dämonen schlachten, denen sie nachhuren. Das soll ihnen eine ewige Satzung sein bei ihren Geschlechtern. ");
INSERT INTO deuelo_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Und du sollst zu ihnen sagen: Jedermann aus dem Hause Israel und von den Fremdlingen, die in ihrer Mitte weilen, der ein Brandopfer oder Schlachtopfer opfert ");
INSERT INTO deuelo_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","und es nicht an den Eingang des Zeltes der Zusammenkunft bringt, um es Jehova zu opfern, selbiger Mann soll ausgerottet werden aus seinen Völkern. ");
INSERT INTO deuelo_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Und jedermann aus dem Hause Israel und von den Fremdlingen, die in ihrer Mitte weilen, der irgend Blut essen wird, wider die Seele, die das Blut isset, werde ich mein Angesicht richten und sie ausrotten aus der Mitte ihres Volkes. ");
INSERT INTO deuelo_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Denn die Seele des Fleisches ist im Blute, und ich habe es euch auf den Altar gegeben, um Sühnung zu tun für eure Seelen; denn das Blut ist es, welches Sühnung tut durch die Seele. ");
INSERT INTO deuelo_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Darum habe ich zu den Kindern Israel gesagt: Niemand von euch soll Blut essen; auch der Fremdling, der in eurer Mitte weilt, soll nicht Blut essen. ");
INSERT INTO deuelo_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Und jedermann von den Kindern Israel und von den Fremdlingen, die in eurer Mitte weilen, der ein Wildbret oder einen Vogel erjagt, die gegessen werden, soll ihr Blut ausfließen lassen und es mit Erde bedecken. ");
INSERT INTO deuelo_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Denn die Seele alles Fleisches: sein Blut, das ist seine Seele; und ich habe zu den Kindern Israel gesagt: Das Blut irgend welches Fleisches sollt ihr nicht essen, denn die Seele alles Fleisches ist sein Blut; jeder, der es isset, soll ausgerottet werden. - ");
INSERT INTO deuelo_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Und jeder, der ein Aas oder Zerrissenes isset, er sei Eingeborener oder Fremdling, der soll seine Kleider waschen und sich im Wasser baden, und er wird unrein sein bis an den Abend; dann wird er rein sein. ");
INSERT INTO deuelo_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Und wenn er sie nicht wäscht und sein Fleisch nicht badet, so wird er seine Ungerechtigkeit tragen. ");
INSERT INTO deuelo_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Rede zu den Kindern Israel und sprich zu ihnen: Ich bin Jehova, euer Gott. ");
INSERT INTO deuelo_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Nach dem Tun des Landes Ägypten, in welchem ihr gewohnt habt, sollt ihr nicht tun; und nach dem Tun des Landes Kanaan, wohin ich euch bringe, sollt ihr nicht tun; und in ihren Satzungen sollt ihr nicht wandeln. ");
INSERT INTO deuelo_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Meine Rechte sollt ihr tun und meine Satzungen sollt ihr beobachten, darin zu wandeln. Ich bin Jehova, euer Gott. ");
INSERT INTO deuelo_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Und meine Satzungen und meine Rechte sollt ihr beobachten, durch welche der Mensch, wenn er sie tut, leben wird. Ich bin Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Kein Mensch soll sich irgend einer seiner Blutsverwandten nahen, um ihre Blöße aufzudecken. Ich bin Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Die Blöße deines Vaters und die Blöße deiner Mutter sollst du nicht aufdecken; sie ist deine Mutter, du sollst ihre Blöße nicht aufdecken; ");
INSERT INTO deuelo_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Die Blöße des Weibes deines Vaters sollst du nicht aufdecken; es ist die Blöße deines Vaters. ");
INSERT INTO deuelo_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Die Blöße deiner Schwester, der Tochter deines Vaters, oder der Tochter deiner Mutter, daheim geboren oder draußen geboren, ihre Blöße sollst du nicht aufdecken. ");
INSERT INTO deuelo_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Die Blöße der Tochter deines Sohnes oder der Tochter deiner Tochter ihre Blöße sollst du nicht aufdecken, denn es ist deine Blöße. ");
INSERT INTO deuelo_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Die Blöße der Tochter des Weibes deines Vaters, von deinem Vater gezeugt, sie ist deine Schwester, ihre Blöße sollst du nicht aufdecken. ");
INSERT INTO deuelo_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Die Blöße der Schwester deines Vaters sollst du nicht aufdecken: sie ist die Blutsverwandte deines Vaters. ");
INSERT INTO deuelo_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Die Blöße der Schwester deiner Mutter sollst du nicht aufdecken, denn sie ist die Blutsverwandte deiner Mutter. ");
INSERT INTO deuelo_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Die Blöße des Bruders deines Vaters sollst du nicht aufdecken: zu seinem Weibe sollst du nicht nahen, sie ist deine Muhme. ");
INSERT INTO deuelo_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Die Blöße deiner Schwiegertochter sollst du nicht aufdecken; sie ist das Weib deines Sohnes, ihre Blöße sollst du nicht aufdecken. ");
INSERT INTO deuelo_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Die Blöße des Weibes deines Bruders sollst du nicht aufdecken; es ist die Blöße deines Bruders. ");
INSERT INTO deuelo_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Die Blöße eines Weibes und ihrer Tochter sollst du nicht aufdecken; die Tochter ihres Sohnes und die Tochter ihrer Tochter sollst du nicht nehmen, um ihre Blöße aufzudecken; sie sind Blutsverwandte: es ist eine Schandtat. ");
INSERT INTO deuelo_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Und du sollst nicht ein Weib zu ihrer Schwester nehmen, sie eifersüchtig zu machen, indem du ihre Blöße neben derselben aufdeckst bei ihrem Leben. - ");
INSERT INTO deuelo_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Und einem Weibe in der Unreinheit ihrer Unreinigkeit sollst du nicht nahen, um ihre Blöße aufzudecken. ");
INSERT INTO deuelo_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Und bei dem Weibe deines Nächsten sollst du nicht liegen zur Begattung, daß du durch sie unrein werdest. - ");
INSERT INTO deuelo_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Und von deinen Kindern sollst du nicht hingeben, um sie dem Molech durch das Feuer gehen zu lassen, und du sollst den Namen Jehovas, deines Gottes, nicht entweihen. Ich bin Jehova. - ");
INSERT INTO deuelo_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Und bei einem Manne sollst du nicht liegen, wie man bei einem Weibe liegt: es ist ein Greuel. ");
INSERT INTO deuelo_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Und bei keinem Vieh sollst du liegen, so daß du dich an ihm verunreinigst; und ein Weib soll sich nicht vor ein Vieh hinstellen, um mit ihm zu schaffen zu haben: es ist eine schändliche Befleckung. ");
INSERT INTO deuelo_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Verunreiniget euch nicht durch alles dieses; denn durch alles dieses haben die Nationen sich verunreinigt, die ich vor euch vertreibe. ");
INSERT INTO deuelo_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Und das Land wurde verunreinigt, und ich suchte seine Ungerechtigkeit an ihm heim, und das Land spie seine Bewohner aus. ");
INSERT INTO deuelo_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Ihr aber, ihr sollt meine Satzungen und meine Rechte beobachten, und ihr sollt nichts tun von allen diesen Greueln, der Eingeborene und der Fremdling, der in eurer Mitte weilt, - ");
INSERT INTO deuelo_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","denn alle diese Greuel haben die Leute dieses Landes getan, die vor euch waren, und das Land ist verunreinigt worden, - ");
INSERT INTO deuelo_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","damit das Land euch nicht ausspeie, wenn ihr es verunreiniget, so wie es die Nation ausgespieen hat, die vor euch war: ");
INSERT INTO deuelo_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","denn jeder, der einen von allen diesen Greueln tut, die Seelen, die ihn tun, sollen ausgerottet werden aus der Mitte ihres Volkes. ");
INSERT INTO deuelo_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Und ihr sollt meine Vorschriften beobachten, daß ihr keine der greulichen Bräuche übet, die vor euch geübt worden sind, und euch nicht durch dieselben verunreiniget. Ich bin Jehova, euer Gott. ");
INSERT INTO deuelo_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Rede zu der ganzen Gemeinde der Kinder Israel und sprich zu ihnen: Ihr sollt heilig sein; denn ich, Jehova, euer Gott, bin heilig. ");
INSERT INTO deuelo_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Ihr sollt ein jeder seine Mutter und seinen Vater fürchten; und meine Sabbathe sollt ihr beobachten. Ich bin Jehova, euer Gott. - ");
INSERT INTO deuelo_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Ihr sollt euch nicht zu den Götzen wenden, und gegossene Götter sollt ihr euch nicht machen. Ich bin Jehova, euer Gott. ");
INSERT INTO deuelo_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Und wenn ihr ein Friedensopfer dem Jehova opfert, so sollt ihr es zum Wohlgefallen für euch opfern. ");
INSERT INTO deuelo_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","An dem Tage, da ihr es opfert, und am anderen Tage soll es gegessen werden; und was bis zum dritten Tage übrigbleibt, soll mit Feuer verbrannt werden. ");
INSERT INTO deuelo_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Und wenn es irgend am dritten Tage gegessen wird, so ist es ein Greuel, es wird nicht wohlgefällig sein; ");
INSERT INTO deuelo_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","und wer es isset, wird seine Ungerechtigkeit tragen, denn das Heilige Jehovas hat er entweiht; und selbige Seele soll ausgerottet werden aus ihren Völkern. ");
INSERT INTO deuelo_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Und wenn ihr die Ernte eures Landes erntet, so sollst du den Rand deines Feldes nicht gänzlich abernten und sollst keine Nachlese deiner Ernte halten. ");
INSERT INTO deuelo_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Und in deinem Weinberge sollst du nicht nachlesen, und die abgefallenen Beeren deines Weinberges sollst du nicht auflesen: für den Armen und für den Fremdling sollst du sie lassen. Ich bin Jehova, euer Gott. ");
INSERT INTO deuelo_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Ihr sollt nicht stehlen; und ihr sollt nicht lügen und nicht trüglich handeln einer gegen den anderen. ");
INSERT INTO deuelo_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Und ihr sollt nicht falsch schwören bei meinem Namen, daß du den Namen deines Gottes entweihest. Ich bin Jehova. - ");
INSERT INTO deuelo_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Du sollst deinen Nächsten nicht bedrücken und sollst ihn nicht berauben; der Lohn des Tagelöhners soll nicht bei dir über Nacht bleiben bis an den Morgen. ");
INSERT INTO deuelo_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Du sollst einem Tauben nicht fluchen und vor einen Blinden keinen Anstoß legen, und du sollst dich fürchten vor deinem Gott. Ich bin Jehova. - ");
INSERT INTO deuelo_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Ihr sollt nicht unrecht tun im Gericht; du sollst nicht die Person des Geringen ansehen und nicht die Person des Großen ehren; in Gerechtigkeit sollst du deinen Nächsten richten. ");
INSERT INTO deuelo_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Du sollst nicht als ein Verleumder unter deinen Völkern umhergehen. Du sollst nicht wider das Blut deines Nächsten auftreten. Ich bin Jehova. - ");
INSERT INTO deuelo_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Du sollst deinen Bruder nicht hassen in deinem Herzen. Du sollst deinen Nächsten ernstlich zurechtweisen, damit du nicht seinetwegen Schuld tragest. ");
INSERT INTO deuelo_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Du sollst dich nicht rächen und den Kindern deines Volkes nichts nachtragen, und sollst deinen Nächsten lieben wie dich selbst. Ich bin Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Meine Satzungen sollt ihr beobachten. Dein Vieh von zweierlei Art sollst du sich nicht begatten lassen; dein Feld sollst du nicht mit zweierlei Samen besäen, und ein Kleid, aus zweierlei Stoff gewebt, soll nicht auf dich kommen. ");
INSERT INTO deuelo_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Und wenn ein Mann bei einem Weibe liegt zur Begattung, und sie ist eine Magd, einem Manne verlobt, und sie ist keineswegs losgekauft, noch ist ihr die Freiheit geschenkt, so soll Züchtigung stattfinden; sie sollen nicht getötet werden, denn sie ist nicht frei gewesen. ");
INSERT INTO deuelo_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Und er soll sein Schuldopfer dem Jehova bringen an den Eingang des Zeltes der Zusammenkunft, einen Widder als Schuldopfer; ");
INSERT INTO deuelo_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","und der Priester soll vor Jehova Sühnung für ihn tun mit dem Widder des Schuldopfers für seine Sünde, die er begangen hat; und seine Sünde, die er begangen hat, wird ihm vergeben werden. ");
INSERT INTO deuelo_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Und wenn ihr in das Land kommet und allerlei Bäume zur Speise pflanzet, so sollt ihr ihre erste Frucht als ihre Vorhaut achten; drei Jahre sollen sie euch als unbeschnitten gelten, es soll nichts von ihnen gegessen werden; ");
INSERT INTO deuelo_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","und im vierten Jahre soll all ihre Frucht heilig sein, Jehova zum Preise; ");
INSERT INTO deuelo_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","und im fünften Jahre sollt ihr ihre Frucht essen, um euch ihren Ertrag zu mehren. Ich bin Jehova, euer Gott. ");
INSERT INTO deuelo_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Ihr sollt nichts mit Blut essen. Ihr sollt nicht Wahrsagerei noch Zauberei treiben. ");
INSERT INTO deuelo_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Ihr sollt nicht den Rand eures Haupthaares rund scheren, und den Rand deines Bartes sollst du nicht zerstören. ");
INSERT INTO deuelo_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Und Einschnitte wegen eines Toten sollt ihr an eurem Fleische nicht machen; und Ätzschrift sollt ihr an euch nicht machen. Ich bin Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Du sollst deine Tochter nicht entweihen, sie der Hurerei hinzugeben, daß das Land nicht Hurerei treibe und das Land voll Schandtaten werde. ");
INSERT INTO deuelo_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Meine Sabbathe sollt ihr beobachten, und mein Heiligtum sollt ihr fürchten. Ich bin Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Ihr sollt euch nicht zu den Totenbeschwörern und zu den Wahrsagern wenden; ihr sollt sie nicht aufsuchen, euch an ihnen zu verunreinigen. Ich bin Jehova, euer Gott. ");
INSERT INTO deuelo_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Vor grauem Haare sollst du aufstehen und die Person eines Greises ehren, und du sollst dich fürchten vor deinem Gott. Ich bin Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Und wenn ein Fremdling bei dir weilt in eurem Lande, so sollt ihr ihn nicht bedrücken. ");
INSERT INTO deuelo_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Wie ein Eingeborener unter euch soll euch der Fremdling sein, der bei euch weilt, und du sollst ihn lieben wie dich selbst; denn Fremdlinge seid ihr gewesen im Lande Ägypten. Ich bin Jehova, euer Gott. ");
INSERT INTO deuelo_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Ihr sollt nicht unrecht tun im Gericht, im Längenmaß, im Gewicht und im Hohlmaß; ");
INSERT INTO deuelo_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","gerechte Waage, gerechte Gewichtsteine, gerechtes Epha und gerechtes Hin sollt ihr haben. Ich bin Jehova, euer Gott, der ich euch aus dem Lande Ägypten herausgeführt habe. ");
INSERT INTO deuelo_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Und so sollt ihr alle meine Satzungen und alle meine Rechte beobachten und sie tun. Ich bin Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Und zu den Kindern Israel sollst du sprechen: Jedermann von den Kindern Israel und von den Fremdlingen, die in Israel weilen, der von seinen Kindern dem Molech gibt, soll gewißlich getötet werden; das Volk des Landes soll ihn steinigen. ");
INSERT INTO deuelo_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Und ich werde mein Angesicht wider selbigen Mann richten und ihn ausrotten aus der Mitte seines Volkes, weil er von seinen Kindern dem Molech gegeben hat, mein Heiligtum zu verunreinigen und meinen heiligen Namen zu entweihen. ");
INSERT INTO deuelo_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Und wenn das Volk des Landes seine Augen irgend verhüllt vor selbigem Manne, wenn er von seinen Kindern dem Molech gibt, so daß es ihn nicht tötet, ");
INSERT INTO deuelo_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","so werde ich mein Angesicht wider selbigen Mann richten und wider sein Geschlecht, und werde ihn und alle, die ihm nachhuren, um dem Molech nachzuhuren, ausrotten aus der Mitte ihres Volkes. ");
INSERT INTO deuelo_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Und die Seele, die sich zu den Totenbeschwörern und zu den Wahrsagern wendet, um ihnen nachzuhuren, wider selbige Seele werde ich mein Angesicht richten und sie ausrotten aus der Mitte ihres Volkes. - ");
INSERT INTO deuelo_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","So heiliget euch und seid heilig, denn ich bin Jehova, euer Gott; ");
INSERT INTO deuelo_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","und beobachtet meine Satzungen und tut sie. Ich bin Jehova, der euch heiligt. ");
INSERT INTO deuelo_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Jedermann, der seinem Vater oder seiner Mutter flucht, soll gewißlich getötet werden; er hat seinem Vater oder seiner Mutter geflucht, sein Blut ist auf ihm. ");
INSERT INTO deuelo_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Und wenn ein Mann Ehebruch treibt mit dem Weibe eines Mannes, wenn er Ehebruch treibt mit dem Weibe seines Nächsten, so sollen der Ehebrecher und die Ehebrecherin gewißlich getötet werden. ");
INSERT INTO deuelo_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Und wenn ein Mann bei dem Weibe seines Vaters liegt: er hat die Blöße seines Vaters aufgedeckt; beide sollen gewißlich getötet werden, ihr Blut ist auf ihnen. ");
INSERT INTO deuelo_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Und wenn ein Mann bei seiner Schwiegertochter liegt, so sollen beide gewißlich getötet werden; sie haben eine schändliche Befleckung verübt, ihr Blut ist auf ihnen. ");
INSERT INTO deuelo_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Und wenn ein Mann bei einem Manne liegt, wie man bei einem Weibe liegt, so haben beide einen Greuel verübt; sie sollen gewißlich getötet werden, ihr Blut ist auf ihnen. ");
INSERT INTO deuelo_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Und wenn ein Mann ein Weib nimmt und ihre Mutter, das ist eine Schandtat; man soll ihn und sie mit Feuer verbrennen, daß keine Schandtat in eurer Mitte sei. ");
INSERT INTO deuelo_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Und wenn ein Mann bei einem Vieh liegt, so soll er gewißlich getötet werden, und das Vieh sollt ihr umbringen. ");
INSERT INTO deuelo_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Und wenn ein Weib sich irgend einem Vieh naht, um mit ihm zu schaffen zu haben, so sollst du das Weib und das Vieh umbringen; sie sollen gewißlich getötet werden, ihr Blut ist auf ihnen. ");
INSERT INTO deuelo_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Und wenn ein Mann seine Schwester nimmt, die Tochter seines Vaters oder die Tochter seiner Mutter, und er sieht ihre Blöße, und sie sieht seine Blöße: das ist eine Schande, und sie sollen ausgerottet werden vor den Augen der Kinder ihres Volkes; er hat die Blöße seiner Schwester aufgedeckt, er soll seine Ungerechtigkeit tragen. ");
INSERT INTO deuelo_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Und wenn ein Mann bei einem Weibe liegt in ihrer Krankheit und ihre Blöße aufdeckt, so hat er ihre Quelle enthüllt, und sie hat die Quelle ihres Blutes aufgedeckt; sie sollen beide ausgerottet werden aus der Mitte ihres Volkes. ");
INSERT INTO deuelo_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Und die Blöße der Schwester deiner Mutter und der Schwester deines Vaters sollst du nicht aufdecken; denn wer das tut, hat seine Blutsverwandte entblößt: sie sollen ihre Ungerechtigkeit tragen. ");
INSERT INTO deuelo_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Und wenn ein Mann bei dem Weibe seines Oheims liegt, so hat er die Blöße seines Oheims aufgedeckt; sie sollen ihre Sünde tragen, kinderlos sollen sie sterben. ");
INSERT INTO deuelo_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Und wenn ein Mann das Weib seines Bruders nimmt: das ist eine Unreinigkeit; Er hat die Blöße seines Bruders aufgedeckt, sie sollen kinderlos sein. ");
INSERT INTO deuelo_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Und ihr sollt alle meine Satzungen und alle meine Rechte beobachten und sie tun, damit euch das Land nicht ausspeie, wohin ich euch bringe, um darin zu wohnen. ");
INSERT INTO deuelo_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","und ihr sollt nicht wandeln in den Satzungen der Nationen, die ich vor euch vertreibe; denn alle jene Dinge haben sie getan, und sie sind mir zum Ekel geworden; ");
INSERT INTO deuelo_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Und ich habe zu euch gesagt: Ihr sollt ihr Land besitzen, und ich werde es euch zum Besitz geben, ein Land, das von Milch und Honig fließt. Ich bin Jehova euer Gott, der ich euch von den Völkern abgesondert habe. ");
INSERT INTO deuelo_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Und ihr sollt unterscheiden zwischen dem reinen Vieh und dem unreinen, und zwischen dem unreinen Gevögel und dem reinen, und sollt euch selbst nicht zu einem Greuel machen durch das Vieh und durch das Gevögel und durch alles, was sich auf dem Erdboden regt, welches ich euch als unrein ausgesondert habe. ");
INSERT INTO deuelo_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Und ihr sollt mir heilig sein, denn ich bin heilig, ich, Jehova; und ich habe euch von den Völkern abgesondert, um mein zu sein. ");
INSERT INTO deuelo_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Und wenn in einem Manne oder einem Weibe ein Totenbeschwörer-oder Wahrsagergeist ist, so sollen sie gewißlich getötet werden; man soll sie steinigen, ihr Blut ist auf ihnen. ");
INSERT INTO deuelo_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Und Jehova sprach zu Mose: Rede zu den Priestern, den Söhnen Aarons, und spricht zu ihnen: Keiner von ihnen soll sich wegen einer Leiche verunreinigen unter seinen Völkern: ");
INSERT INTO deuelo_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","außer wegen seines Blutsverwandten, der ihm nahe steht: wegen seiner Mutter und wegen seines Vaters und wegen seines Sohnes und wegen seiner Tochter und wegen seines Bruders; ");
INSERT INTO deuelo_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","und wegen seiner Schwester, der Jungfrau, sie ihm nahe steht, die noch keines Mannes geworden ist: wegen dieser darf er sich verunreinigen. ");
INSERT INTO deuelo_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Er soll sich nicht verunreinigen als Herr unter seinen Völkern, sich zu entweihen. ");
INSERT INTO deuelo_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Sie sollen keine Glatze auf ihrem Haupte machen, und den Rand ihres Bartes sollen sie nicht abscheren, und an ihrem Fleische sollen sie keine Einschnitte machen. ");
INSERT INTO deuelo_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Sie sollen ihrem Gott heilig sein, und den Namen ihres Gottes, sollen sie nicht entweihen, denn die Feueropfer Jehovas, das Brot ihres Gottes bringen sie dar; und sie sollen heilig sein. ");
INSERT INTO deuelo_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Eine Hure und eine Entehrte sollen sie nicht zum Weibe nehmen, und ein von ihrem Manne verstoßenes Weib sollen sie nicht nehmen; denn heilig ist er seinem Gott. ");
INSERT INTO deuelo_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Und du sollst ihn für heilig achten, denn das Brot deines Gottes bringt er dar; er soll dir heilig sein; denn heilig bin ich Jehova, der euch heiligt. ");
INSERT INTO deuelo_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Und wenn die Tochter eines Priesters sich durch Hurerei entweiht, so entweiht sie ihren Vater: sie soll mit Feuer verbrannt werden. - ");
INSERT INTO deuelo_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Und der Hohepriester unter seinen Brüdern, auf dessen Haupt das Salböl gegossen worden, und der geweiht ist, um die heiligen Kleider anzulegen, soll sein Haupt nicht entblößen und soll seine Kleider nicht zerreißen. ");
INSERT INTO deuelo_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Und er soll zu keiner Leiche kommen; wegen seines Vaters und wegen seiner Mutter soll er sich nicht verunreinigen. ");
INSERT INTO deuelo_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Und aus dem Heiligtum soll er nicht hinausgehen und nicht entweihen das Heiligtum seines Gottes; denn die Weihe des Salböls seines Gottes ist auf ihm. Ich bin Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Und derselbe soll ein Weib in ihrer Jungfrauschaft nehmen. ");
INSERT INTO deuelo_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Eine Witwe und eine Verstoßene und eine Entehrte, eine Hure, diese soll er nicht nehmen; sondern eine Jungfrau aus seinen Völkern soll er zum Weibe nehmen. ");
INSERT INTO deuelo_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Und er soll seinen Samen nicht entweihen unter seinen Völkern; denn ich bin Jehova, der ihn heiligt. ");
INSERT INTO deuelo_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Rede zu Aaron und sprich: Jemand von deinem Samen bei ihren Geschlechtern, an dem ein Gebrechen ist, soll nicht herzunahen, um das Brot seines Gottes darzubringen; ");
INSERT INTO deuelo_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","denn jedermann, an dem ein Gebrechen ist, soll nicht herzunahen, es sei ein blinder Mann oder ein lahmer oder ein stumpfnasiger, oder der ein Glied zu lang hat, ");
INSERT INTO deuelo_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","oder ein Mann, der einen Bruch am Fuße oder einen Bruch an der Hand hat, ");
INSERT INTO deuelo_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","oder ein Höckeriger oder ein Zwerg, oder der einen Flecken an seinem Auge hat, oder der die Krätze oder Flechte, oder der zerdrückte Hoden hat. ");
INSERT INTO deuelo_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Jedermann vom Samen Aarons, des Priesters, der ein Gebrechen hat, soll nicht herzutreten, die Feueropfer Jehovas darzubringen; ein Gebrechen ist an ihm, er soll nicht herzutreten, das Brot seines Gottes darzubringen. ");
INSERT INTO deuelo_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Das Brot seines Gottes von dem Hochheiligen und von dem Heiligen mag er essen; ");
INSERT INTO deuelo_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","allein zum Vorhang soll er nicht kommen, und zum Altar soll er nicht nahen, denn ein Gebrechen ist an ihm, daß er nicht meine Heiligtümer entweihe; denn ich bin Jehova, der sie heiligt. ");
INSERT INTO deuelo_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Und so redete Mose zu Aaron und zu seinen Söhnen und zu allen Kindern Israel. ");
INSERT INTO deuelo_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Rede zu Aaron und zu seinen Söhnen, daß sie sich enthalten von den heiligen Dingen der Kinder Israel, die sie mir heiligen, und meinen heiligen Namen nicht entweihen. Ich bin Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Sprich zu ihnen: Wer irgend von all eurem Samen, bei euren Geschlechtern, sich den heiligen Dingen naht, welche die Kinder Israel Jehova heiligen, und seine Unreinigkeit ist an ihm, selbige Seele soll ausgerottet werden vor meinem Angesicht hinweg. Ich bin Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Jedermann vom Samen Aarons, der aussätzig oder flüssig ist, soll nicht von den heiligen Dingen essen, bis er rein ist. Und wer irgend einen anrührt, der durch eine Leiche verunreinigt ist, oder jemanden, dem der Samenerguß entgeht; ");
INSERT INTO deuelo_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","oder wer irgend ein kriechendes Tier anrührt, durch welches er unrein wird, oder einen Menschen, durch den er unrein wird nach irgend welcher Unreinigkeit, die er hat: ");
INSERT INTO deuelo_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Einer, der solches anrührt, der wird unrein sein bis an den Abend; und er soll nicht von den heiligen Dingen essen, sondern soll sein Fleisch im Wasser baden; ");
INSERT INTO deuelo_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","und ist die Sonne untergegangen, so ist er rein; und danach darf er von den heiligen Dingen essen, denn es ist sein Brot. ");
INSERT INTO deuelo_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Aas und Zerrissenes soll er nicht essen, daß er sich dadurch verunreinige. Ich bin Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Und sie sollen meine Vorschriften beobachten, damit sie nicht deswegen Sünde auf sich laden und dadurch sterben, weil sie es entweihen. Ich bin Jehova, der sie heiligt. ");
INSERT INTO deuelo_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Und kein Fremder soll Heiliges essen; der Beisasse und der Tagelöhner eines Priesters sollen Heiliges nicht essen. ");
INSERT INTO deuelo_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Wenn aber ein Priester eine Seele für Geld kauft, so darf diese davon essen; und seine Hausgeborenen, sie dürfen von seinem Brote essen. ");
INSERT INTO deuelo_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Und wenn die Tochter eines Priesters das Weib eines fremden Mannes wird, so soll sie nicht von dem Hebopfer der heiligen Dinge essen. ");
INSERT INTO deuelo_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Und wenn die Tochter eines Priesters Witwe oder verstoßen wird, und keine Kinder hat und in das Haus ihres Vaters zurückkehrt, wie in ihrer Jugend, so darf sie von dem Brote ihres Vaters essen. Aber kein Fremder soll davon essen. ");
INSERT INTO deuelo_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Und wenn jemand aus Versehen Heiliges isset, so soll er das Fünftel davon hinzufügen und dem Priester das Heilige erstatten. ");
INSERT INTO deuelo_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Und man soll die heiligen Dinge der Kinder Israel nicht entweihen, die sie dem Jehova heben, ");
INSERT INTO deuelo_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","und ihnen so die Ungerechtigkeit einer Schuld aufladen, wenn sie ihre heiligen Dinge essen; denn ich bin Jehova, der sie heiligt. ");
INSERT INTO deuelo_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Rede zu Aaron und zu seinen Söhnen und zu allen Kindern Israel und sprich zu ihnen: Jedermann vom Hause Israel und von den Fremdlingen in Israel, der seine Opfergabe darbringt, nach allen ihren Gelübden und nach allen ihren freiwilligen Gaben, welche sie Jehova als Brandopfer darbringen, - ");
INSERT INTO deuelo_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","zum Wohlgefallen für euch soll es sein, ohne Fehl, männlich, von den Rindern, von den Schafen oder von den Ziegen. ");
INSERT INTO deuelo_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Alles, woran ein Gebrechen ist, sollt ihr nicht darbringen, denn es wird nicht zum Wohlgefallen für euch sein. ");
INSERT INTO deuelo_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Und wenn jemand dem Jehova ein Friedensopfer darbringt, um ein Gelübde zu erfüllen, oder als freiwillige Gabe vom Rind-oder Kleinvieh: ohne Fehl soll es sein, zum Wohlgefallen; keinerlei Gebrechen soll an ihm sein. ");
INSERT INTO deuelo_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Ein blindes oder verletztes oder verstümmeltes Tier, oder eines, das Geschwüre oder die Krätze oder die Flechte hat, diese sollt ihr Jehova nicht darbringen, und sollt Jehova keine Feueropfer davon auf den Altar geben. ");
INSERT INTO deuelo_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Und ein Stück Rind-oder Kleinvieh, an welchem ein Glied zu lang oder zu kurz ist, das magst du als freiwillige Gabe opfern; aber zu einem Gelübde wird es nicht wohlgefällig sein. ");
INSERT INTO deuelo_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Und dem die Hoden zerquetscht oder zerstoßen oder ausgerissen oder ausgeschnitten sind, sollt ihr Jehova nicht darbringen; und in eurem Lande sollt ihr dergleichen nicht tun. ");
INSERT INTO deuelo_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Und aus der Hand eines Fremden sollt ihr das Brot eures Gottes aus allen diesen nicht darbringen; denn ihr Verderben ist an ihnen, ein Gebrechen ist an ihnen; sie werden nicht wohlgefällig für euch sein. ");
INSERT INTO deuelo_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","Wenn ein Rind oder ein Schaf oder eine Ziege geboren wird, so soll es sieben Tage unter seiner Mutter sein; und vom achten Tage an und weiterhin wird es wohlgefällig sein zur Opfergabe eines Feueropfers dem Jehova. - ");
INSERT INTO deuelo_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Und ein Stück Rind-oder Kleinvieh, es selbst und sein Junges, sollt ihr nicht schlachten an einem Tage. ");
INSERT INTO deuelo_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Und wenn ihr dem Jehova ein Dankopfer opfert, so sollt ihr es zum Wohlgefallen für euch opfern: ");
INSERT INTO deuelo_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","An demselben Tage soll es gegessen werden; ihr sollt nichts davon übriglassen bis an den Morgen. Ich bin Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Und ihr sollt meine Gebote beobachten und sie tun. Ich bin Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Und ihr sollt meinen heiligen Namen nicht entweihen, damit ich geheiligt werde in der Mitte der Kinder Israel. ");
INSERT INTO deuelo_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Ich bin Jehova, der euch heiligt, der euch aus dem Lande Ägypten herausgeführt hat, um euer Gott zu sein. Ich bin Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Rede zu den Kindern Israel und sprich zu ihnen: Die Feste Jehovas, die ihr als heilige Versammlungen ausrufen sollt, meine Feste sind diese: ");
INSERT INTO deuelo_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Sechs Tage soll man Arbeit tun; aber am siebten Tage ist ein Sabbath der Ruhe, eine heilige Versammlung; keinerlei Arbeit sollt ihr tun; es ist ein Sabbath dem Jehova in allen euren Wohnsitzen. ");
INSERT INTO deuelo_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Dies sind die Feste Jehovas, heilige Versammlungen, die ihr ausrufen sollt zu ihrer bestimmten Zeit: ");
INSERT INTO deuelo_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Im ersten Monat, am Vierzehnten des Monats, zwischen den zwei Abenden, ist Passah dem Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Und am fünfzehnten Tage dieses Monats ist das Fest der ungesäuerten Brote dem Jehova; sieben Tage sollt ihr Ungesäuertes essen. ");
INSERT INTO deuelo_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Am ersten Tage soll euch eine heilige Versammlung sein, keinerlei Dienstarbeit sollt ihr tun. ");
INSERT INTO deuelo_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Und ihr sollt Jehova ein Feueropfer darbringen sieben Tage; am siebten Tage ist eine heilige Versammlung, keinerlei Dienstarbeit sollt ihr tun. ");
INSERT INTO deuelo_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Rede zu den Kindern Israel und sprich zu ihnen: Wenn ihr in das Land kommet, das ich euch gebe, und ihr seine Ernte erntet, so sollt ihr eine Garbe der Erstlinge eurer Ernte zu dem Priester bringen; ");
INSERT INTO deuelo_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","und er soll die Garbe vor Jehova weben zum Wohlgefallen für euch; am anderen Tage nach dem Sabbath soll sie der Priester weben. ");
INSERT INTO deuelo_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Und ihr sollt an dem Tage, da ihr die Garbe webet, ein Lamm opfern, ohne Fehl, einjährig, zum Brandopfer dem Jehova; ");
INSERT INTO deuelo_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","und sein Speisopfer: zwei Zehntel Feinmehl, gemengt mit Öl, ein Feueropfer dem Jehova, ein lieblicher Geruch; und sein Trankopfer: ein viertel Hin Wein. ");
INSERT INTO deuelo_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Und Brot und geröstete Körner und Gartenkorn sollt ihr nicht essen bis zu diesem selbigen Tage, bis ihr die Opfergabe eures Gottes gebracht habt: eine ewige Satzung bei euren Geschlechtern in allen euren Wohnsitzen. ");
INSERT INTO deuelo_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Und ihr sollt euch zählen vom anderen Tage nach dem Sabbath, von dem Tage, da ihr die Webegarbe gebracht habt: es sollen sieben volle Wochen sein. ");
INSERT INTO deuelo_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Bis zum anderen Tage nach dem siebten Sabbath sollt ihr fünfzig Tage zählen; und ihr sollt Jehova ein neues Speisopfer darbringen. ");
INSERT INTO deuelo_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Aus euren Wohnungen sollt ihr Webebrote bringen, zwei von zwei Zehnteln Feinmehl sollen es sein, gesäuert sollen sie gebacken werden, als Erstlinge dem Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Und ihr sollt zu dem Brote darbringen sieben einjährige Lämmer ohne Fehl, und einen jungen Farren und zwei Widder (sie sollen ein Brandopfer dem Jehova sein) und ihr Speisopfer und ihre Trankopfer: ein Feueropfer lieblichen Geruchs dem Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Und ihr sollt einen Ziegenbock zum Sündopfer opfern und zwei einjährige Lämmer zum Friedensopfer. ");
INSERT INTO deuelo_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Und der Priester soll sie weben samt dem Brote der Erstlinge als Webopfer vor Jehova, samt den zwei Lämmern: sie sollen Jehova heilig sein für den Priester. ");
INSERT INTO deuelo_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Und ihr sollt an diesem selbigen Tage einen Ruf ergehen lassen, eine heilige Versammlung soll euch sein; keinerlei Dienstarbeit sollt ihr tun: eine ewige Satzung in allen euren Wohnsitzen bei euren Geschlechtern. - ");
INSERT INTO deuelo_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Und wenn ihr die Ernte eures Landes erntet, sollst du den Rand deines Feldes nicht gänzlich abernten, und sollst keine Nachlese deiner Ernte halten; für den Armen und für den Fremdling sollst du sie lassen. Ich bin Jehova, euer Gott. ");
INSERT INTO deuelo_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Rede zu den Kindern Israel und sprich: Im siebten Monat, am Ersten des Monats, soll euch Ruhe sein, ein Gedächtnis des Posaunenhalls, eine heilige Versammlung. ");
INSERT INTO deuelo_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Keinerlei Dienstarbeit sollt ihr tun, und ihr sollt Jehova ein Feueropfer darbringen. ");
INSERT INTO deuelo_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","Doch am Zehnten dieses siebten Monats ist der Versöhnungstag; eine heilige Versammlung soll euch sein, und ihr sollt eure Seelen kasteien, und sollt Jehova ein Feueropfer darbringen. ");
INSERT INTO deuelo_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Und keinerlei Arbeit sollt ihr tun an diesem selbigen Tage; denn es ist der Versöhnungstag, um Sühnung für euch zu tun vor Jehova, eurem Gott. ");
INSERT INTO deuelo_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Denn jede Seele, die sich nicht kasteit an diesem selbigen Tage, die soll ausgerottet werden aus ihren Völkern; ");
INSERT INTO deuelo_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","und jede Seele, die irgend eine Arbeit tut an diesem selbigen Tage, selbige Seele werde ich vertilgen aus der Mitte ihres Volkes. ");
INSERT INTO deuelo_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Keinerlei Arbeit sollt ihr tun: eine ewige Satzung bei euren Geschlechtern in allen euren Wohnsitzen. ");
INSERT INTO deuelo_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Ein Sabbath der Ruhe soll er für euch sein, und ihr sollt eure Seelen kasteien; am Neunten des Monats, am Abend, vom Abend bis zum Abend sollt ihr euren Sabbath feiern. ");
INSERT INTO deuelo_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Rede zu den Kindern Israel und sprich: Am fünfzehnten Tage dieses siebten Monats ist das Fest der Laubhütten sieben Tage dem Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Am ersten Tage soll eine heilige Versammlung sein, keinerlei Dienstarbeit sollt ihr tun. ");
INSERT INTO deuelo_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Sieben Tage sollt ihr Jehova ein Feueropfer darbringen; am achten Tage soll euch eine heilige Versammlung sein, und ihr sollt Jehova ein Feueropfer darbringen: es ist eine Festversammlung, keinerlei Dienstarbeit sollt ihr tun. ");
INSERT INTO deuelo_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Das sind die Feste Jehovas, die ihr ausrufen sollt als heilige Versammlungen, um Jehova darzubringen Feueropfer, Brandopfer und Speisopfer, Schlachtopfer und Trankopfer, die Gebühr des Tages an seinem Tage: ");
INSERT INTO deuelo_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","außer den Sabbathen Jehovas und außer euren Gaben und außer allen euren Gelübden und außer allen euren freiwilligen Gaben, die ihr Jehova gebet. ");
INSERT INTO deuelo_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Doch am fünfzehnten Tage des siebten Monats, wenn ihr den Ertrag des Landes eingesammelt habt, sollt ihr das Fest Jehovas feiern sieben Tage; am ersten Tage soll Ruhe sein, und am achten Tage soll Ruhe sein. ");
INSERT INTO deuelo_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Und ihr sollt euch am ersten Tage Frucht von schönen Bäumen nehmen, Palmzweige und Zweige von dichtbelaubten Bäumen und von Bachweiden, und sollt euch vor Jehova, eurem Gott, freuen sieben Tage. ");
INSERT INTO deuelo_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Und ihr sollt dasselbe sieben Tage im Jahre als Fest dem Jehova feiern: eine ewige Satzung bei euren Geschlechtern; im siebten Monat sollt ihr dasselbe feiern. ");
INSERT INTO deuelo_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","In Laubhütten sollt ihr wohnen sieben Tage; alle Eingeborenen in Israel sollen in Laubhütten wohnen; ");
INSERT INTO deuelo_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","auf daß eure Geschlechter wissen, daß ich die Kinder Israel in Laubhütten habe wohnen lassen, als ich sie aus dem Lande Ägypten herausführte. Ich bin Jehova, euer Gott. - ");
INSERT INTO deuelo_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Und Mose sagte den Kindern Israel die Feste Jehovas. ");
INSERT INTO deuelo_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Gebiete den Kindern Israel, daß sie dir reines, zerstoßenes Olivenöl bringen zum Licht, um die Lampen anzuzünden beständig. ");
INSERT INTO deuelo_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Außerhalb des Vorhangs des Zeugnisses, im Zelte der Zusammenkunft, soll Aaron sie zurichten, vom Abend bis zum Morgen, vor Jehova beständig: eine ewige Satzung bei euren Geschlechtern. ");
INSERT INTO deuelo_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Auf dem reinen Leuchter soll er die Lampen beständig vor Jehova zurichten. ");
INSERT INTO deuelo_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Und du sollst Feinmehl nehmen und daraus zwölf Kuchen backen: von zwei Zehnteln soll ein Kuchen sein. ");
INSERT INTO deuelo_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Und du sollst sie in zwei Schichten legen, sechs in eine Schicht, auf den reinen Tisch vor Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Und du sollst auf jede Schicht reinen Weihrauch legen, und er soll dem Brote zum Gedächtnis sein, ein Feueropfer dem Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Sabbathtag für Sabbathtag soll es beständig vor Jehova zurichten: ein ewiger Bund von seiten der Kinder Israel. ");
INSERT INTO deuelo_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Und es soll Aaron und seinen Söhnen gehören, und sie sollen es essen an heiligem Orte; denn als ein Hochheiliges von den Feueropfern Jehovas soll es ihm gehören: eine ewige Satzung. ");
INSERT INTO deuelo_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Und der Sohn eines israelitischen Weibes, er war aber der Sohn eines ägyptischen Mannes, ging aus unter die Kinder Israel; und der Sohn der Israelitin und ein israelitischer Mann zankten sich im Lager. ");
INSERT INTO deuelo_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Und der Sohn des israelitischen Weibes lästerte den Namen Jehovas und fluchte ihm; und sie brachten ihn zu Mose. Der Name seiner Mutter aber war Schelomith, die Tochter Dibris, vom Stamme Dan. ");
INSERT INTO deuelo_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Und sie legten ihn in Gewahrsam, damit ihnen nach dem Munde Jehovas beschieden werde. ");
INSERT INTO deuelo_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","Führe den Flucher außerhalb des Lagers; und alle, die es gehört haben, sollen ihre Hände auf seinen Kopf legen, und die ganze Gemeinde soll ihn steinigen. ");
INSERT INTO deuelo_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Und zu den Kindern Israel sollst du reden und sprechen: Wenn irgend jemand seinem Gott flucht, so soll er seine Sünde tragen. ");
INSERT INTO deuelo_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Und wer den Namen Jehovas lästert, soll gewißlich getötet werden, steinigen soll ihn die ganze Gemeinde; wie der Fremdling, so der Eingeborene: wenn er den Namen lästert, soll er getötet werden. ");
INSERT INTO deuelo_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Und wenn jemand irgend einen Menschen totschlägt, so soll er gewißlich getötet werden. ");
INSERT INTO deuelo_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Und wer ein Vieh totschlägt, soll es erstatten: Leben um Leben. ");
INSERT INTO deuelo_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Und wenn jemand seinem Nächsten eine Verletzung zufügt: wie er getan hat, also soll ihm getan werden: ");
INSERT INTO deuelo_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Bruch um Bruch, Auge um Auge, Zahn um Zahn; wie er einem Menschen eine Verletzung zufügt, also soll ihm zugefügt werden. ");
INSERT INTO deuelo_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Und wer ein Vieh totschlägt, soll es erstatten; wer aber einen Menschen totschlägt, soll getötet werden. ");
INSERT INTO deuelo_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Einerlei Recht sollt ihr haben: wie der Fremdling, so soll der Eingeborene sein; denn ich bin Jehova, euer Gott. - ");
INSERT INTO deuelo_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Und Mose redete zu den Kindern Israel, und sie führten den Flucher vor das Lager hinaus und steinigten ihn; und die Kinder Israel taten, wie Jehova dem Mose geboten hatte. ");
INSERT INTO deuelo_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Und Jehova redete zu Mose auf dem Berge Sinai und sprach: ");
INSERT INTO deuelo_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Rede zu den Kindern Israel und sprich zu ihnen: Wenn ihr in das Land kommet, das ich euch geben werde, so soll das Land dem Jehova einen Sabbath feiern. ");
INSERT INTO deuelo_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Sechs Jahre sollst du dein Feld besäen und sechs Jahre deinen Weinberg beschneiden und den Ertrag des Landes einsammeln. ");
INSERT INTO deuelo_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Aber im siebten Jahre soll ein Sabbath der Ruhe für das Land sein, ein Sabbath dem Jehova; dein Feld sollst du nicht besäen und deinen Weinberg nicht beschneiden; ");
INSERT INTO deuelo_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","den Nachwuchs deiner Ernte sollst du nicht einernten, und die Trauben deines unbeschnittenen Weinstocks sollst du nicht abschneiden: Es soll ein Jahr der Ruhe für das Land sein. ");
INSERT INTO deuelo_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Und der Sabbath des Landes soll euch zur Speise dienen, dir und deinem Knechte und deiner Magd und deinem Tagelöhner und deinem Beisassen, die sich bei dir aufhalten; ");
INSERT INTO deuelo_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","und deinem Vieh und dem wilden Getier, das in deinem Lande ist, soll all sein Ertrag zur Speise dienen. ");
INSERT INTO deuelo_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Und du sollst dir sieben Jahrsabbathe zählen, siebenmal sieben Jahre, so daß die Tage von sieben Jahrsabbathen dir neunundvierzig Jahre ausmachen. ");
INSERT INTO deuelo_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Und du sollst im siebten Monat, am Zehnten des Monats, den Posaunenschall ergehen lassen; an dem Versöhnungstage sollt ihr die Posaune ergehen lassen durch euer ganzes Land. ");
INSERT INTO deuelo_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Und ihr sollt das Jahr des fünfzigsten Jahres heiligen und sollt im Lande Freiheit ausrufen für alle seine Bewohner. Ein Jubeljahr soll es euch sein, und ihr werdet ein jeder wieder zu seinem Eigentum kommen, und ein jeder zurückkehren zu seinem Geschlecht. ");
INSERT INTO deuelo_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Ein Jubeljahr soll dasselbe, das Jahr des fünfzigsten Jahres, euch sein; ihr sollt nicht säen und seinen Nachwuchs nicht ernten und seine unbeschnittenen Weinstöcke nicht lesen; ");
INSERT INTO deuelo_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","denn ein Jubeljahr ist es: es soll euch heilig sein; vom Felde weg sollt ihr seinen Ertrag essen. ");
INSERT INTO deuelo_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","In diesem Jahre des Jubels sollt ihr ein jeder wieder zu seinem Eigentum kommen. ");
INSERT INTO deuelo_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Und wenn ihr eurem Nächsten etwas verkaufet oder von der Hand eures Nächsten etwas kaufet, so soll keiner seinen Bruder bedrücken. ");
INSERT INTO deuelo_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Nach der Zahl der Jahre seit dem Jubeljahre sollst du von deinem Nächsten kaufen, nach der Zahl der Erntejahre soll er dir verkaufen. ");
INSERT INTO deuelo_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Nach Verhältnis der größeren Zahl von Jahren sollst du ihm den Kaufpreis mehren, und nach Verhältnis der geringeren Zahl von Jahren sollst du ihm den Kaufpreis mindern; denn eine Zahl von Ernten verkauft er dir. ");
INSERT INTO deuelo_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Und so soll keiner von euch seinen Nächsten bedrücken, und du sollst dich fürchten vor deinem Gott; denn ich bin Jehova, euer Gott. ");
INSERT INTO deuelo_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Und so tut meine Satzungen, und beobachtet meine Rechte und tut sie, so werdet ihr sicher wohnen in eurem Lande. ");
INSERT INTO deuelo_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Und das Land wird seine Frucht geben, und ihr werdet essen bis zur Sättigung und sicher in demselben wohnen. ");
INSERT INTO deuelo_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Und wenn ihr sprechet: Was sollen wir im siebten Jahre essen? Siehe, wir säen nicht, und unseren Ertrag sammeln wir nicht ein: - ");
INSERT INTO deuelo_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Ich werde euch ja im sechsten Jahre meinen Segen entbieten, daß es den Ertrag für drei Jahre bringe; ");
INSERT INTO deuelo_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","und wenn ihr im achten Jahre säet, werdet ihr noch vom alten Ertrage essen; bis ins neunte Jahr, bis sein Ertrag einkommt, werdet ihr Altes essen. ");
INSERT INTO deuelo_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Und das Land soll nicht für immer verkauft werden, denn mein ist das Land; denn Fremdlinge und Beisassen seid ihr bei mir. ");
INSERT INTO deuelo_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Und im ganzen Lande eures Eigentums sollt ihr dem Lande Lösung gestatten. ");
INSERT INTO deuelo_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Wenn dein Bruder verarmt und von seinem Eigentum verkauft, so mag sein Löser, sein nächster Verwandter, kommen und das Verkaufte seines Bruders lösen. ");
INSERT INTO deuelo_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Und wenn jemand keinen Löser hat, und seine Hand erwirbt und findet, was zu seiner Lösung hinreicht, ");
INSERT INTO deuelo_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","so soll er die Jahre seines Verkaufs berechnen und das Übrige dem Manne zurückzahlen, an den er verkauft hat, und so wieder zu seinem Eigentum kommen. ");
INSERT INTO deuelo_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Und wenn seine Hand nicht gefunden hat, was hinreicht, um ihm zurückzuzahlen, so soll das von ihm Verkaufte in der Hand des Käufers desselben bleiben bis zum Jubeljahre; und im Jubeljahre soll es frei ausgehen, und er soll wieder zu seinem Eigentum kommen. ");
INSERT INTO deuelo_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Und wenn jemand ein Wohnhaus in einer ummauerten Stadt verkauft, so soll sein Lösungsrecht bestehen bis zum Ende des Jahres seines Verkaufs; ein volles Jahr soll sein Lösungsrecht bestehen. ");
INSERT INTO deuelo_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Wenn es aber nicht gelöst wird, bis ihm ein ganzes Jahr voll ist, so soll das Haus, das in der ummauerten Stadt ist, für immer dem Käufer desselben verbleiben, bei seinen Geschlechtern; es soll im Jubeljahre nicht frei ausgehen. ");
INSERT INTO deuelo_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Aber die Häuser der Dörfer, welche keine Mauer ringsum haben, sollen dem Felde des Landes gleichgeachtet werden; es soll Lösungsrecht für sie sein, und im Jubeljahre sollen sie frei ausgehen. ");
INSERT INTO deuelo_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Und was die Städte der Leviten, die Häuser der Städte ihres Eigentums betrifft, so soll ein ewiges Lösungsrecht für die Leviten sein. ");
INSERT INTO deuelo_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Und wenn jemand von einem der Leviten löst, so soll das verkaufte Haus in der Stadt seines Eigentums im Jubeljahre frei ausgehen; denn die Häuser der Städte der Leviten sind ihr Eigentum unter den Kindern Israel. ");
INSERT INTO deuelo_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Aber das Feld des Bezirks ihrer Städte soll nicht verkauft werden, denn es gehört ihnen als ewiges Eigentum. ");
INSERT INTO deuelo_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Und wenn dein Bruder verarmt und seine Hand bei dir wankend wird, so sollst du ihn unterstützen; wie der Fremdling und der Beisasse soll er bei dir leben. ");
INSERT INTO deuelo_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Du sollst nicht Zins und Wucher von ihm nehmen, und sollst dich fürchten vor deinem Gott, damit dein Bruder bei dir lebe. ");
INSERT INTO deuelo_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Dein Geld sollst du ihm nicht um Zins geben und deine Nahrungsmittel nicht um Wucher geben. ");
INSERT INTO deuelo_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ich bin Jehova, euer Gott, der ich euch aus dem Lande Ägypten herausgeführt habe, um euch das Land Kanaan zu geben, um euer Gott zu sein. ");
INSERT INTO deuelo_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Und wenn dein Bruder bei dir verarmt und sich dir verkauft, so sollst du ihn nicht Sklavendienst tun lassen; wie ein Tagelöhner, ");
INSERT INTO deuelo_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","wie ein Beisasse soll er bei dir sein; bis zum Jubeljahre soll er bei dir dienen. ");
INSERT INTO deuelo_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Dann soll er frei von dir ausgehen, er und seine Kinder mit ihm, und zu seinem Geschlecht zurückkehren und wieder zu dem Eigentum seiner Väter kommen. ");
INSERT INTO deuelo_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Denn sie sind meine Knechte, die ich aus dem Lande Ägypten herausgeführt habe; sie sollen nicht verkauft werden, wie man Sklaven verkauft. ");
INSERT INTO deuelo_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Du sollst nicht mit Härte über ihn herrschen, und sollst dich fürchten vor deinem Gott. ");
INSERT INTO deuelo_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Was aber deinen Knecht und deine Magd betrifft, die du haben wirst: von den Nationen, die rings um euch her sind, von ihnen möget ihr Knecht und Magd kaufen. ");
INSERT INTO deuelo_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Und auch von den Kindern der Beisassen, die sich bei euch aufhalten, von ihnen möget ihr kaufen und von ihrem Geschlecht, das bei euch ist, das sie in eurem Lande gezeugt haben; und sie mögen euch zum Eigentum sein, ");
INSERT INTO deuelo_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","und ihr möget sie euren Söhnen nach euch vererben, um sie als Eigentum zu besitzen. Diese möget ihr auf ewig dienen lassen; aber über eure Brüder, die Kinder Israel, sollt ihr nicht einer über den anderen herrschen mit Härte. ");
INSERT INTO deuelo_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Und wenn die Hand eines Fremdlings oder eines Beisassen bei dir etwas erwirbt, und dein Bruder bei ihm verarmt und sich dem Fremdling, dem Beisassen bei dir, oder einem Sprößling aus dem Geschlecht des Fremdlings verkauft, ");
INSERT INTO deuelo_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","so soll, nachdem er sich verkauft hat, Lösungsrecht für ihn sein; einer von seinen Brüdern mag ihn lösen. ");
INSERT INTO deuelo_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Entweder sein Oheim oder der Sohn seines Oheims mag ihn lösen, oder einer von seinen nächsten Blutsverwandten aus seinem Geschlecht mag ihn lösen; oder hat seine Hand etwas erworben, so mag er sich selbst lösen. ");
INSERT INTO deuelo_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Und er soll mit seinem Käufer rechnen von dem Jahre an, da er sich ihm verkauft hat, bis zum Jubeljahre; und der Preis, um den er sich verkauft hat, soll der Zahl der Jahre gemäß sein; nach den Tagen eines Tagelöhners soll er bei ihm sein. ");
INSERT INTO deuelo_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Wenn der Jahre noch viele sind, so soll er nach ihrem Verhältnis seine Lösung von seinem Kaufgelde zurückzahlen; ");
INSERT INTO deuelo_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","und wenn wenig übrig ist an den Jahren bis zum Jubeljahre, so soll er es ihm berechnen: nach Verhältnis seiner Jahre soll er seine Lösung zurückzahlen. ");
INSERT INTO deuelo_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Wie ein Tagelöhner soll er Jahr für Jahr bei ihm sein; er soll nicht vor deinen Augen mit Härte über ihn herrschen. ");
INSERT INTO deuelo_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Und wenn er nicht in dieser Weise gelöst wird, so soll er im Jubeljahre frei ausgehen, er und seine Kinder mit ihm. ");
INSERT INTO deuelo_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Denn mir sind die Kinder Israel Knechte; meine Knechte sind sie, die ich aus dem Lande Ägypten herausgeführt habe. Ich bin Jehova, euer Gott. ");
INSERT INTO deuelo_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Ihr sollt euch keine Götzen machen und sollt euch kein geschnitztes Bild und keine Bildsäule aufrichten, und keinen Stein mit Bildwerk sollt ihr in eurem Lande setzen, um euch davor niederzubeugen; denn ich bin Jehova, euer Gott. ");
INSERT INTO deuelo_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Meine Sabbathe sollt ihr beobachten, und mein Heiligtum sollt ihr fürchten. Ich bin Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Wenn ihr in meinen Satzungen wandelt und meine Gebote beobachtet und sie tut, ");
INSERT INTO deuelo_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","so werde ich eure Regen geben zu ihrer Zeit, und das Land wird seinen Ertrag geben, und die Bäume des Feldes werden ihre Frucht geben; ");
INSERT INTO deuelo_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","und die Dreschzeit wird bei euch reichen bis an die Weinlese, und die Weinlese wird reichen bis an die Saatzeit; und ihr werdet euer Brot essen bis zur Sättigung und werdet sicher in eurem Lande wohnen. ");
INSERT INTO deuelo_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Und ich werde Frieden im Lande geben, daß ihr euch niederleget und niemand sei, der euch aufschreckt; und ich werde die bösen Tiere aus dem Lande vertilgen, und das Schwert wird nicht durch euer Land gehen. ");
INSERT INTO deuelo_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Und ihr werdet eure Feinde jagen, und sie werden vor euch fallen durchs Schwert; ");
INSERT INTO deuelo_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","und fünf von euch werden hundert jagen, und hundert von euch werden zehntausend jagen, und eure Feinde werden vor euch fallen durchs Schwert. ");
INSERT INTO deuelo_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Und ich werde mich zu euch wenden und euch fruchtbar machen und euch mehren und meinen Bund mit euch aufrechthalten; ");
INSERT INTO deuelo_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","und ihr werdet das altgewordene Alte essen, und das Alte wegräumen vor dem Neuen. ");
INSERT INTO deuelo_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Und ich werde meine Wohnung in eure Mitte setzen, und meine Seele wird euch nicht verabscheuen; ");
INSERT INTO deuelo_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","und ich werde in eurer Mitte wandeln und werde euer Gott sein und ihr werdet mein Volk sein. ");
INSERT INTO deuelo_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Ich bin Jehova, euer Gott, der ich euch aus dem Lande Ägypten herausgeführt habe, daß ihr nicht ihre Knechte sein solltet; und ich habe die Stäbe eures Joches zerbrochen und euch aufrecht wandeln lassen. ");
INSERT INTO deuelo_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Wenn ihr mir aber nicht gehorchet und nicht alle diese Gebote tut, ");
INSERT INTO deuelo_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","und wenn ihr meine Satzungen verachtet, und eure Seele meine Rechte verabscheut, so daß ihr nicht alle meine Gebote tut, und daß ihr meinen Bund brechet, ");
INSERT INTO deuelo_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","so werde auch ich euch dieses tun: Ich werde Schrecken über euch bestellen, Schwindsucht und Fieberglut, welche machen werden, daß die Augen erlöschen und die Seele verschmachtet; und ihr werdet vergeblich euren Samen säen, denn eure Feinde werden ihn verzehren; ");
INSERT INTO deuelo_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","und ich werde mein Angesicht wider euch richten, daß ihr vor euren Feinden geschlagen werdet; und eure Hasser werden über euch herrschen, und ihr werdet fliehen, obwohl niemand euch jagt. ");
INSERT INTO deuelo_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Und wenn ihr auf dieses hin mir nicht gehorchet, so werde ich euch siebenmal mehr züchtigen wegen eurer Sünden. ");
INSERT INTO deuelo_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Und ich werde euren starren Hochmut brechen, und werde euren Himmel wie Eisen machen und eure Erde wie Erz; ");
INSERT INTO deuelo_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","und eure Kraft wird sich umsonst verbrauchen, und euer Land wird seinen Ertrag nicht geben, und die Bäume des Feldes werden ihre Frucht nicht geben. ");
INSERT INTO deuelo_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Und wenn ihr mir entgegen wandelt und mir nicht gehorchen wollt, so werde ich euch noch siebenmal mehr schlagen, nach euren Sünden. ");
INSERT INTO deuelo_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Und ich werde das Getier des Feldes unter euch senden, daß es euch eurer Kinder beraube und euer Vieh ausrotte und euer weniger mache; und eure Straßen sollen öde werden. ");
INSERT INTO deuelo_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Und wenn ihr euch durch dieses nicht von mir zurechtweisen laßt und mir entgegen wandelt, ");
INSERT INTO deuelo_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","so werde auch ich euch entgegen wandeln, und auch ich werde euch siebenfach schlagen wegen eurer Sünden. ");
INSERT INTO deuelo_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Und ich werde das Schwert über euch bringen, das die Rache des Bundes vollzieht; und ziehet ihr euch in eure Städte zurück, so werde ich die Pest in eure Mitte senden, und ihr werdet in die Hand des Feindes gegeben werden. ");
INSERT INTO deuelo_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Indem ich euch die Stütze des Brotes zerbreche, werden zehn Weiber euer Brot backen in einem Ofen, und sie werden euch das Brot zurückgeben nach dem Gewicht; und ihr werdet essen und nicht satt werden. ");
INSERT INTO deuelo_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Und wenn ihr bei alledem mir nicht gehorchet und mir entgegen wandelt, ");
INSERT INTO deuelo_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","so werde auch ich euch entgegen wandeln im Grimm, und werde euch siebenfach züchtigen wegen eurer Sünden. ");
INSERT INTO deuelo_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Und ihr werdet das Fleisch eurer Söhne essen, und das Fleisch eurer Töchter werdet ihr essen. ");
INSERT INTO deuelo_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Und ich werde eure Höhen vertilgen und eure Sonnensäulen ausrotten und werde eure Leichname auf die Leichname eurer Götzen werfen, und meine Seele wird euch verabscheuen. ");
INSERT INTO deuelo_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Und ich werde eure Städte zur Öde machen und eure Heiligtümer verwüsten, und werde euren lieblichen Geruch nicht riechen. ");
INSERT INTO deuelo_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Und ich werde das Land verwüsten, daß eure Feinde, die darin wohnen, sich darüber entsetzen sollen. ");
INSERT INTO deuelo_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Euch aber werde ich unter die Nationen zerstreuen, und ich werde das Schwert ziehen hinter euch her; und euer Land wird eine Wüste sein und eure Städte eine Öde. ");
INSERT INTO deuelo_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Dann wird das Land seine Sabbathe genießen alle die Tage seiner Verwüstung, während ihr im Lande eurer Feinde seid; dann wird das Land ruhen und seine Sabbathe genießen; ");
INSERT INTO deuelo_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","alle die Tage seiner Verwüstung wird es ruhen, was es nicht geruht hat in euren Sabbathen, als ihr darin wohntet. ");
INSERT INTO deuelo_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Und die Übriggebliebenen von euch, in ihr Herz werde ich Feigheit bringen in den Ländern ihrer Feinde: Und es wird sie jagen das Rauschen eines verwehten Blattes, und sie werden fliehen, wie man vor dem Schwerte flieht, und fallen, obwohl niemand sie jagt; ");
INSERT INTO deuelo_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","und sie werden einer über den anderen hinstürzen, wie vor dem Schwerte, obwohl niemand sie jagt; und ihr werdet nicht standhalten können vor euren Feinden. ");
INSERT INTO deuelo_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Und ihr werdet umkommen unter den Nationen, und das Land eurer Feinde wird euch fressen. ");
INSERT INTO deuelo_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Und die Übriggebliebenen von euch werden in den Ländern eurer Feinde hinschwinden in ihrer Ungerechtigkeit, und auch in den Ungerechtigkeiten ihrer Väter mit ihnen hinschwinden. ");
INSERT INTO deuelo_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Und sie werden ihre Ungerechtigkeit bekennen und die Ungerechtigkeit ihrer Väter infolge ihrer Treulosigkeit, die sie gegen mich begangen haben, und auch daß, weil sie mir entgegen gewandelt sind, ");
INSERT INTO deuelo_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","auch ich ihnen entgegen wandelte und sie in das Land ihrer Feinde brachte. Wenn alsdann ihr unbeschnittenes Herz sich demütigt und sie dann die Strafe ihrer Ungerechtigkeit annehmen, ");
INSERT INTO deuelo_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","so werde ich meines Bundes mit Jakob gedenken; und auch meines Bundes mit Isaak und auch meines Bundes mit Abraham werde ich gedenken, und des Landes werde ich gedenken. ");
INSERT INTO deuelo_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Denn das Land wird von ihnen verlassen sein, und es wird seine Sabbathe genießen, in seiner Verwüstung ohne sie; und sie selbst werden die Strafe ihrer Ungerechtigkeit annehmen, darum, ja darum, daß sie meine Rechte verachtet und ihre Seele meine Satzungen verabscheut hat. ");
INSERT INTO deuelo_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Aber selbst auch dann, wenn sie in dem Lande ihrer Feinde sind, werde ich sie nicht verachten und sie nicht verabscheuen, ihnen den Garaus zu machen, meinen Bund mit ihnen zu brechen; denn ich bin Jehova, ihr Gott. ");
INSERT INTO deuelo_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Und ich werde ihnen meines Bundes mit den Vorfahren gedenken, die ich aus dem Lande Ägypten vor den Augen der Nationen herausgeführt habe, um ihr Gott zu sein. Ich bin Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Das sind die Satzungen und die Rechte und die Gesetze, welche Jehova zwischen ihm und den Kindern Israel auf dem Berge Sinai durch Mose gegeben hat. ");
INSERT INTO deuelo_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Rede zu den Kindern Israel und sprich zu ihnen: Wenn jemand ein Gelübde erfüllt, so sollen die Seelen nach deiner Schätzung für Jehova sein. ");
INSERT INTO deuelo_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Und es sei deine Schätzung eines Mannes von zwanzig Jahren alt bis zu sechzig Jahren alt, und zwar sei deine Schätzung fünfzig Sekel Silber, nach dem Sekel des Heiligtums; ");
INSERT INTO deuelo_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Und wenn es ein Weib ist, so sei deine Schätzung dreißig Sekel. ");
INSERT INTO deuelo_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Und wenn es von fünf Jahren alt bis zu zwanzig Jahren alt ist, so sei deine Schätzung einer männlichen Person zwanzig Sekel, und einer weiblichen zehn Sekel; ");
INSERT INTO deuelo_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Und wenn es von einem Monat alt bis zu fünf Jahren alt ist, so sei deine Schätzung eines Knaben fünf Sekel Silber, und deine Schätzung eines Mädchens drei Sekel Silber; ");
INSERT INTO deuelo_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","und wenn es von sechzig Jahren alt und darüber ist, so sei deine Schätzung, wenn es ein Mann ist, fünfzehn Sekel, und eines Weibes zehn Sekel. ");
INSERT INTO deuelo_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Und wenn der Gelobende zu arm ist für deine Schätzung, so soll man ihn vor den Priester stellen, und der Priester soll ihn schätzen; nach Verhältnis dessen, was die Hand des Gelobenden aufbringen kann, soll der Priester ihn schätzen. ");
INSERT INTO deuelo_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Und wenn es ein Vieh ist, wovon man Jehova eine Opfergabe darbringt, so soll alles, was man Jehova davon gibt, heilig sein. ");
INSERT INTO deuelo_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Man soll es nicht auswechseln noch vertauschen, ein gutes um ein schlechtes, oder ein schlechtes um ein gutes; und wenn man dennoch Vieh um Vieh vertauscht, so wird dasselbe heilig und das eingetauschte heilig sein. ");
INSERT INTO deuelo_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Und wenn es irgend ein unreines Vieh ist, wovon man Jehova keine Opfergabe darbringt, so soll man das Vieh vor den Priester stellen, ");
INSERT INTO deuelo_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","und der Priester soll es schätzen, ob es gut oder schlecht sei; nach deiner, des Priesters, Schätzung, also soll es sein. ");
INSERT INTO deuelo_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Wenn man es aber lösen will, so soll man zu deiner Schätzung ein Fünftel hinzufügen. ");
INSERT INTO deuelo_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Und wenn jemand sein Haus heiligt, daß es Jehova heilig sei, so soll es der Priester schätzen, ob es gut oder schlecht sei; so wie der Priester es schätzt, also soll es festgestellt sein. ");
INSERT INTO deuelo_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Und wenn der Heiligende sein Haus lösen will, so soll er das Fünftel des Geldes deiner Schätzung darüber hinzufügen, und es soll ihm gehören. ");
INSERT INTO deuelo_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Und wenn jemand von dem Felde seines Eigentums Jehova heiligt, so soll deine Schätzung nach Verhältnis seiner Aussaat sein: ein Homer Gerste Aussaat zu fünfzig Sekel Silber. ");
INSERT INTO deuelo_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Wenn er vom Jubeljahre an sein Feld heiligt, so soll es nach deiner Schätzung festgestellt sein; ");
INSERT INTO deuelo_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","und wenn er nach dem Jubeljahre sein Feld heiligt, so soll der Priester ihm das Geld berechnen nach dem Verhältnis der Jahre, die bis zum Jubeljahre übrig sind, und es soll von deiner Schätzung abgezogen werden. ");
INSERT INTO deuelo_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Wenn aber der Heiligende das Feld lösen will, so soll er das Fünftel des Geldes deiner Schätzung darüber hinzufügen, und es soll ihm verbleiben. ");
INSERT INTO deuelo_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Und wenn er das Feld nicht löst, oder wenn er das Feld einem anderen Manne verkauft, so kann es nicht wieder gelöst werden; ");
INSERT INTO deuelo_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","und das Feld soll, wenn es im Jubeljahre frei ausgeht, Jehova heilig sein, wie ein verbanntes Feld; es soll dem Priester als Eigentum gehören. ");
INSERT INTO deuelo_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Und wenn er ein von ihm erkauftes Feld, das nicht zum Felde seines Eigentums gehört, Jehova heiligt, ");
INSERT INTO deuelo_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","so soll ihm der Priester den Betrag deiner Schätzung berechnen bis zum Jubeljahre; und er soll deine Schätzung am gleichen Tage, als ein dem Jehova Heiliges, entrichten. ");
INSERT INTO deuelo_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Im Jubeljahre soll das Feld wieder an den kommen, von welchem er es gekauft hatte, an den, welchem das Land eigentümlich gehörte. ");
INSERT INTO deuelo_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Und all deine Schätzung soll nach dem Sekel des Heiligtums geschehen; zwanzig Gera soll der Sekel sein. ");
INSERT INTO deuelo_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Nur das Erstgeborene unter dem Vieh, das als Erstgeburt Jehova gehört, das soll kein Mensch heiligen; sei es ein Stück Rind-oder Kleinvieh, es gehört Jehova. ");
INSERT INTO deuelo_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Wenn es aber vom unreinen Vieh ist, so soll man es lösen nach deiner Schätzung und dessen Fünftel darüber hinzufügen; und wenn es nicht gelöst wird, so soll es verkauft werden nach deiner Schätzung. - ");
INSERT INTO deuelo_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Jedoch alles Verbannte, das jemand dem Jehova verbannt, von allem, was sein ist, es seien Menschen oder Vieh oder Feld seines Eigentums, soll nicht verkauft und nicht gelöst werden; alles Verbannte ist dem Jehova hochheilig. ");
INSERT INTO deuelo_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Alles, was an Menschen verbannt wird, soll nicht gelöst werden: es soll gewißlich getötet werden. ");
INSERT INTO deuelo_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Und aller Zehnte des Landes, vom Samen des Landes, von der Frucht der Bäume, gehört Jehova; er ist Jehova heilig. ");
INSERT INTO deuelo_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Wenn aber jemand von seinem Zehnten lösen will, so soll er dessen Fünftel hinzufügen. ");
INSERT INTO deuelo_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Und aller Zehnte vom Rind-und Kleinvieh, von allem, was unter dem Stabe vorüberzieht, das Zehnte soll Jehova heilig sein; ");
INSERT INTO deuelo_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","man soll nicht untersuchen, ob es gut oder schlecht sei, und soll es nicht vertauschen; und wenn man es dennoch vertauscht, so wird dasselbe heilig und das eingetauschte heilig sein; es soll nicht gelöst werden. ");
INSERT INTO deuelo_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Das sind die Gebote, welche Jehova dem Mose auf dem Berge Sinai an die Kinder Israel aufgetragen hat. ");
INSERT INTO deuelo_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Und Jehova redete zu Mose in der Wüste Sinai im Zelte der Zusammenkunft, am Ersten des zweiten Monats, im zweiten Jahre nach ihrem Auszuge aus dem Lande Ägypten und sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","Nehmet auf die Summe der ganzen Gemeinde der Kinder Israel nach ihren Geschlechtern, nach ihren Vaterhäusern, nach der Zahl der Namen, alle Männlichen nach ihren Köpfen; ");
INSERT INTO deuelo_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","von zwanzig Jahren und darüber, jeden, der zum Heere auszieht in Israel, die sollt ihr mustern nach ihren Heeren, du und Aaron. ");
INSERT INTO deuelo_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Und je ein Mann für den Stamm soll bei euch sein, ein Mann, der das Haupt von seinem Vaterhause ist. ");
INSERT INTO deuelo_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Und dies sind die Namen der Männer, die euch beistehen sollen: für Ruben: Elizur, der Sohn Schedeurs; ");
INSERT INTO deuelo_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","für Simeon: Schelumiel, der Sohn Zurischaddais; ");
INSERT INTO deuelo_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","für Juda: Nachschon, der Sohn Amminadabs; ");
INSERT INTO deuelo_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","für Issaschar: Nethaneel, der Sohn Zuars; ");
INSERT INTO deuelo_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","für Sebulon: Eliab, der Sohn Helons; ");
INSERT INTO deuelo_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","für die Söhne Josephs: für Ephraim: Elischama, der Sohn Ammihuds; für Manasse: Gamliel, der Sohn Pedazurs; ");
INSERT INTO deuelo_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","für Benjamin: Abidan, der Sohn Gideonis; ");
INSERT INTO deuelo_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","für Dan: Achieser, der Sohn Ammischaddais; ");
INSERT INTO deuelo_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","für Aser: Pagiel, der Sohn Okrans; ");
INSERT INTO deuelo_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","für Gad: Eljasaph, der Sohn Deghuels; ");
INSERT INTO deuelo_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","für Naphtali: Achira, der Sohn Enans. ");
INSERT INTO deuelo_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Das waren die Berufenen der Gemeinde, die Fürsten der Stämme ihrer Väter; sie waren die Häupter der Tausende Israels. ");
INSERT INTO deuelo_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Und Mose und Aaron nahmen diese mit Namen bezeichneten Männer, ");
INSERT INTO deuelo_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","und sie versammelten die ganze Gemeinde am ersten des zweiten Monats. Und sie ließen sich in die Geburtsverzeichnisse eintragen nach ihren Geschlechtern, nach ihren Vaterhäusern, nach der Zahl der Namen, von zwanzig Jahren und darüber, nach ihren Köpfen; ");
INSERT INTO deuelo_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","wie Jehova dem Mose geboten hatte. Und so musterte er sie in der Wüste Sinai. ");
INSERT INTO deuelo_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Und es waren die Söhne Rubens, des Erstgeborenen Israels: ihre Geschlechter nach ihren Familien, nach ihren Vaterhäusern, nach der Zahl der Namen, nach ihren Köpfen, alle Männlichen von zwanzig Jahren und darüber, jeder, der zum Heere auszog, ");
INSERT INTO deuelo_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","ihre Gemusterten vom Stamme Ruben, sechsundvierzigtausend fünfhundert. ");
INSERT INTO deuelo_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Von den Söhnen Simeons: ihre Geschlechter nach ihren Familien, nach ihren Vaterhäusern, seine Gemusterten nach der Zahl der Namen, nach ihren Köpfen, alle Männlichen von zwanzig Jahren und darüber, jeder, der zum Heere auszog, ");
INSERT INTO deuelo_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","ihre Gemusterten vom Stamme Simeon, neunundfünfzigtausend dreihundert. ");
INSERT INTO deuelo_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Von den Söhnen Gads: ihre Geschlechter nach ihren Familien, nach ihren Vaterhäusern, nach der Zahl der Namen, von zwanzig Jahren und darüber, jeder, der zum Heere auszog, ");
INSERT INTO deuelo_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","ihre Gemusterten vom Stamme Gad, fünfundvierzigtausend sechshundertfünfzig. ");
INSERT INTO deuelo_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Von den Söhnen Judas: ihre Geschlechter nach ihren Familien, nach ihren Vaterhäusern, nach der Zahl der Namen, von zwanzig Jahren und darüber, jeder, der zum Heere auszog, ");
INSERT INTO deuelo_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","ihre Gemusterten vom Stamme Juda, vierundsiebzigtausend sechshundert. ");
INSERT INTO deuelo_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Von den Söhnen Issaschars: ihre Geschlechter nach ihren Familien, nach ihren Vaterhäusern, nach der Zahl der Namen, von zwanzig Jahren und darüber, jeder, der zum Heere auszog, ");
INSERT INTO deuelo_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","ihre Gemusterten vom Stamme Issaschar, vierundfünfzigtausend vierhundert. ");
INSERT INTO deuelo_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Von den Söhnen Sebulons: ihre Geschlechter nach ihren Familien, nach ihren Vaterhäusern, nach der Zahl der Namen, von zwanzig Jahren und darüber, jeder, der zum Heere auszog, ");
INSERT INTO deuelo_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","die Gemusterten vom Stamme Sebulon, siebenundfünfzigtausend vierhundert. ");
INSERT INTO deuelo_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Von den Söhnen Josephs: von den Söhnen Ephraims: ihre Geschlechter nach ihren Familien nach ihren Vaterhäusern, nach der Zahl der Namen, von zwanzig Jahren und darüber, jeder, der zum Heere auszog, ");
INSERT INTO deuelo_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","ihre Gemusterten vom Stamme Ephraim, vierzigtausend fünfhundert. ");
INSERT INTO deuelo_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Von den Söhnen Manasses: ihre Geschlechter nach ihren Familien, nach ihren Vaterhäusern, nach der Zahl der Namen, von zwanzig Jahren und darüber, jeder, der zum Heere auszog, ");
INSERT INTO deuelo_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","ihre Gemusterten vom Stamme Manasse, zweiunddreißigtausend zweihundert. ");
INSERT INTO deuelo_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Von den Söhnen Benjamins: ihre Geschlechter nach ihren Familien, nach ihren Vaterhäusern, nach der Zahl der Namen, von zwanzig Jahren und darüber, jeder, der zum Heere auszog, ");
INSERT INTO deuelo_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","ihre Gemusterten vom Stamme Benjamin, fünfunddreißigtausend vierhundert. ");
INSERT INTO deuelo_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Von den Söhnen Dans: ihre Geschlechter nach ihren Familien, nach ihren Vaterhäusern, nach der Zahl der Namen, von zwanzig Jahren und darüber, jeder, der zum Heere auszog, ");
INSERT INTO deuelo_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","ihre Gemusterten vom Stamme Dan, zweiundsechzigtausend siebenhundert. ");
INSERT INTO deuelo_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Von den Söhnen Asers: ihre Geschlechter nach ihren Familien, nach ihren Vaterhäusern, nach der Zahl der Namen, von zwanzig Jahren und darüber, jeder, der zum Heere auszog, ");
INSERT INTO deuelo_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","ihre Gemusterten vom Stamme Aser, einundvierzigtausend fünfhundert. ");
INSERT INTO deuelo_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Die Söhne Naphtalis: ihre Geschlechter nach ihren Familien, nach ihren Vaterhäusern, nach der Zahl der Namen, von zwanzig Jahren und darüber, jeder, der zum Heere auszog, ");
INSERT INTO deuelo_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","ihre Gemusterten vom Stamme Naphtali, dreiundfünfzigtausend vierhundert. ");
INSERT INTO deuelo_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Das sind die Gemusterten, welche Mose und Aaron und die Fürsten Israels musterten, die zwölf Männer: es waren je ein Mann für sein Vaterhaus. ");
INSERT INTO deuelo_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Und es waren alle Gemusterten der Kinder Israel, nach ihren Vaterhäusern, von zwanzig Jahren und darüber, jeder, der zum Heere auszog in Israel: ");
INSERT INTO deuelo_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","es waren alle die Gemusterten sechshundertunddreitausend fünfhundertfünfzig. ");
INSERT INTO deuelo_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Aber die Leviten nach dem Stamme ihrer Väter wurden nicht unter ihnen gemustert. ");
INSERT INTO deuelo_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Denn Jehova hatte zu Mose geredet und gesagt: ");
INSERT INTO deuelo_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","Nur den Stamm Levi sollst du nicht mustern und ihre Summe nicht aufnehmen unter den Kindern Israel, ");
INSERT INTO deuelo_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","sondern bestelle du die Leviten über die Wohnung des Zeugnisses und über all ihr Gerät und über alles, was zu ihr gehört: Sie sollen die Wohnung und all ihr Gerät tragen, und sie sollen sie bedienen und sich rings um die Wohnung lagern. ");
INSERT INTO deuelo_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Und wenn die Wohnung aufbricht, sollen die Leviten sie abnehmen; und wenn die Wohnung sich lagert, sollen die Leviten sie aufrichten. Der Fremde aber, der herzunaht, soll getötet werden. ");
INSERT INTO deuelo_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Und die Kinder Israel sollen sich lagern, ein jeder in seinem Lager und ein jeder bei seinem Panier, nach ihren Heeren. ");
INSERT INTO deuelo_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Die Leviten aber sollen sich rings um die Wohnung des Zeugnisses lagern, daß nicht ein Zorn über die Gemeinde der Kinder Israel komme; und die Leviten sollen der Hut der Wohnung des Zeugnisses warten. ");
INSERT INTO deuelo_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Und die Kinder Israel taten nach allem was Jehova dem Mose geboten hatte; also taten sie. ");
INSERT INTO deuelo_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Und Jehova redete zu Mose und zu Aaron und sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Die Kinder Israel sollen sich lagern, ein jeder bei seinem Panier, bei den Zeichen ihrer Vaterhäuser; dem Zelte der Zusammenkunft gegenüber sollen sie sich ringsum lagern. ");
INSERT INTO deuelo_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Und zwar die gegen Osten, gegen Sonnenaufgang Lagernden: das Panier des Lagers Judas, nach ihren Heeren; und der Fürst der Söhne Judas, Nachschon, der Sohn Amminadabs; ");
INSERT INTO deuelo_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","und sein Heer und ihre Gemusterten, vierundsiebzigtausend sechshundert. ");
INSERT INTO deuelo_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Und die neben ihm Lagernden: der Stamm Issaschar; und der Fürst der Söhne Issaschars, Nethaneel, der Sohn Zuars; ");
INSERT INTO deuelo_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","und sein Heer und dessen Gemusterte, vierundfünfzigtausend vierhundert. ");
INSERT INTO deuelo_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Der Stamm Sebulon; und der Fürst der Söhne Sebulons, Eliab, der Sohn Helons; ");
INSERT INTO deuelo_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","und sein Heer und dessen Gemusterte, siebenundfünfzigtausend vierhundert. ");
INSERT INTO deuelo_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Alle Gemusterten vom Lager Judas: hundertsechsundachtzigtausend vierhundert, nach ihren Heeren; sie sollen zuerst aufbrechen. ");
INSERT INTO deuelo_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Das Panier des Lagers Rubens gegen Süden, nach ihren Heeren; und der Fürst der Söhne Rubens, Elizur, der Sohn Schedeurs; ");
INSERT INTO deuelo_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","und sein Heer und dessen Gemusterte, sechsundvierzigtausend fünfhundert. ");
INSERT INTO deuelo_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Und die neben ihm Lagernden: der Stamm Simeon; und der Fürst der Söhne Simeons, Schelumiel, der Sohn Zurischaddais; ");
INSERT INTO deuelo_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","und sein Heer und ihre Gemusterten, neunundfünfzigtausend dreihundert. ");
INSERT INTO deuelo_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Und der Stamm Gad; und der Fürst der Söhne Gads, Eljasaph, der Sohn Reghuels; ");
INSERT INTO deuelo_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","und sein Heer und ihre Gemusterten, fünfundvierzigtausend sechshundertfünfzig. ");
INSERT INTO deuelo_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Alle Gemusterten vom Lager Rubens: hunderteinundfünfzigtausend vierhundertfünfzig nach ihren Heeren; und als die zweiten sollen sie aufbrechen. ");
INSERT INTO deuelo_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Und dann soll das Zelt der Zusammenkunft aufbrechen, das Lager der Leviten in der Mitte der Lager; so wie sie lagern, also sollen sie aufbrechen, ein jeder an seiner Stelle, nach ihren Panieren. ");
INSERT INTO deuelo_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Das Panier des Lagers Ephraims, nach ihren Heeren, gegen Westen; und der Fürst der Söhne Ephraims, Elischama, der Sohn Ammihuds; ");
INSERT INTO deuelo_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","und sein Heer und ihre Gemusterten, vierzigtausend fünfhundert. ");
INSERT INTO deuelo_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Und neben ihm der Stamm Manasse; und der Fürst der Söhne Manasses, Gamliel, der Sohn Pedazurs; ");
INSERT INTO deuelo_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","und sein Heer und ihre Gemusterten, zweiunddreißigtausend zweihundert. ");
INSERT INTO deuelo_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Und der Stamm Benjamin; und der Fürst der Söhne Benjamins, Abidan, der Sohn Gideonis; ");
INSERT INTO deuelo_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","und sein Heer und ihre Gemusterten, fünfunddreißigtausend vierhundert. ");
INSERT INTO deuelo_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Alle Gemusterten vom Lager Ephraims: hundertachttausend einhundert, nach ihren Heeren; und als die dritten sollen sie aufbrechen. ");
INSERT INTO deuelo_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Das Panier des Lagers Dans gegen Norden, nach ihren Heeren; und der Fürst der Söhne Dans, Achieser, der Sohn Ammischaddais; ");
INSERT INTO deuelo_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","und sein Heer und ihre Gemusterten, zweiundsechzigtausend siebenhundert. ");
INSERT INTO deuelo_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Und die neben ihm Lagernden: der Stamm Aser; und der Fürst der Söhne Asers, Pagiel, der Sohn Okrans; ");
INSERT INTO deuelo_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","und sein Heer und ihre Gemusterten, einundvierzigtausend fünfhundert. ");
INSERT INTO deuelo_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Und der Stamm Naphtali; und der Fürst der Söhne Naphtalis, Achira, der Sohn Enans; ");
INSERT INTO deuelo_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","und sein Heer und ihre Gemusterten, dreiundfünfzigtausend vierhundert. ");
INSERT INTO deuelo_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Alle Gemusterten vom Lager Dans: hundertsiebenundfünfzigtausend sechshundert; sie sollen zuletzt aufbrechen nach ihren Panieren. ");
INSERT INTO deuelo_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Das sind die Gemusterten der Kinder Israel nach ihren Vaterhäusern. Alle Gemusterten der Lager, nach ihren Heeren, waren sechshundertdreitausend fünfhundertfünfzig. ");
INSERT INTO deuelo_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Aber die Leviten wurden nicht unter den Kindern Israel gemustert, so wie Jehova dem Mose geboten hatte. ");
INSERT INTO deuelo_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Und die Kinder Israel taten nach allem, was Jehova dem Mose geboten hatte: also lagerten sie sich nach ihren Panieren, und also brachen sie auf, ein jeder nach seinen Geschlechtern, nach seinem Vaterhause. ");
INSERT INTO deuelo_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Und dies sind die Geschlechter Aarons und Moses, an dem Tage, da Jehova auf dem Berge Sinai mit Mose redete. ");
INSERT INTO deuelo_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Und dies sind die Namen der Söhne Aarons: der Erstgeborene Nadab, und Abihu, Eleasar und Ithamar. ");
INSERT INTO deuelo_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Das sind die Namen der Söhne Aarons, der gesalbten Priester, die geweiht worden waren, um den Priesterdienst auszuüben. ");
INSERT INTO deuelo_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Und Nadab und Abihu starben vor Jehova, als sie in der Wüste Sinai fremdes Feuer vor Jehova darbrachten; und sie hatten keine Söhne. Und Eleasar und Ithamar übten den Priesterdienst vor ihrem Vater Aaron aus. ");
INSERT INTO deuelo_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Laß den Stamm Levi herzunahen und stelle ihn vor Aaron, den Priester, daß sie ihm dienen; ");
INSERT INTO deuelo_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","und sie sollen seiner Hut warten und der Hut der ganzen Gemeinde vor dem Zelte der Zusammenkunft, um den Dienst der Wohnung zu verrichten; ");
INSERT INTO deuelo_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","und sie sollen warten aller Geräte des Zeltes der Zusammenkunft und der Hut der Kinder Israel, um den Dienst der Wohnung zu verrichten. ");
INSERT INTO deuelo_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Und du sollst die Leviten dem Aaron und seinen Söhnen geben; ganz zu eigen sind sie ihm gegeben von seiten der Kinder Israel. ");
INSERT INTO deuelo_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Und Aaron und seine Söhne sollst du bestellen, daß sie ihres Priestertums warten. Der Fremde aber, der herzunaht, soll getötet werden. ");
INSERT INTO deuelo_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","Und ich, siehe, ich habe die Leviten aus der Mitte der Kinder Israel genommen, anstatt aller Erstgeburt, welche die Mutter bricht unter den Kindern Israel; und die Leviten sollen mir gehören. ");
INSERT INTO deuelo_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Denn mein ist alle Erstgeburt: an dem Tage, da ich alle Erstgeburt im Lande Ägypten schlug, habe ich mir alle Erstgeburt in Israel geheiligt vom Menschen bis zum Vieh; mir sollen sie gehören, mir, Jehova. ");
INSERT INTO deuelo_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Und Jehova redete zu Mose in der Wüste Sinai und sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Mustere die Söhne Levis nach ihren Vaterhäusern, nach ihren Familien; alle Männlichen von einem Monat und darüber sollst du sie mustern. ");
INSERT INTO deuelo_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Und Mose musterte sie nach dem Befehl Jehovas, so wie ihm geboten war. ");
INSERT INTO deuelo_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Und dies waren die Söhne Levis nach ihren Namen: Gerson und Kehath und Merari. ");
INSERT INTO deuelo_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Und dies sind die Namen der Söhne Gersons nach ihren Familien: Libni und Simei. ");
INSERT INTO deuelo_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Und die Söhne Kehaths nach ihren Familien: Amram und Jizhar, Hebron und Ussiel. ");
INSERT INTO deuelo_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Und die Söhne Meraris nach ihren Familien: Machli und Muschi. Das sind die Familien Levis nach ihren Vaterhäusern. ");
INSERT INTO deuelo_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Von Gerson die Familie der Libniter und die Familie der Simeiter; das sind die Familien der Gersoniter. ");
INSERT INTO deuelo_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Ihre Gemusterten nach der Zahl aller Männlichen von einem Monat und darüber, ihre Gemusterten: siebentausend fünfhundert. ");
INSERT INTO deuelo_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Die Familien der Gersoniter lagerten hinter der Wohnung gegen Westen. ");
INSERT INTO deuelo_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Und der Fürst des Vaterhauses der Gersoniter war Eljasaph, der Sohn Laels. ");
INSERT INTO deuelo_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Und die Hut der Söhne Gersons am Zelte der Zusammenkunft war: die Wohnung und das Zelt, seine Decke, und der Vorhang vom Eingang des Zeltes der Zusammenkunft, ");
INSERT INTO deuelo_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","und die Umhänge des Vorhofs und der Vorhang vom Eingang des Vorhofs, der rings um die Wohnung und um den Altar ist, und seine Seile zu all seinem Dienst. ");
INSERT INTO deuelo_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Und von Kehath die Familie der Amramiter und die Familie der Jizhariter und die Familie der Hebroniter und die Familie der Ussieliter; das sind die Familien der Kehathiter. ");
INSERT INTO deuelo_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Nach der Zahl aller Männlichen von einem Monat und darüber, achttausend sechshundert, welche der Hut des Heiligtums warteten. ");
INSERT INTO deuelo_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Die Familien der Söhne Kehaths lagerten an der Seite der Wohnung gegen Süden. ");
INSERT INTO deuelo_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Und der Fürst des Vaterhauses der Familien der Kehathiter war Elizaphan, der Sohn Ussiels. ");
INSERT INTO deuelo_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Und ihre Hut war: die Lade und der Tisch und der Leuchter und die Altäre, und die Geräte des Heiligtums, mit welchen man den Dienst verrichtet, und der Vorhang, und dessen ganzer Dienst. ");
INSERT INTO deuelo_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Und der Fürst der Fürsten Levis war Eleasar, der Sohn Aarons, des Priesters; er war Aufseher über die, welche der Hut des Heiligtums warteten. ");
INSERT INTO deuelo_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Von Merari die Familie der Machliter und die Familie der Muschiter: das sind die Familien Meraris. ");
INSERT INTO deuelo_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Und ihre Gemusterten nach der Zahl aller Männlichen von einem Monat und darüber: sechstausend zweihundert. ");
INSERT INTO deuelo_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Und der Fürst des Vaterhauses der Familien Meraris war Zuriel, der Sohn Abichails. Sie lagerten an der Seite der Wohnung gegen Norden. ");
INSERT INTO deuelo_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Und die Hut der Söhne Meraris war: die Bretter der Wohnung, und ihre Riegel und ihre Säulen und ihre Füße und alle ihre Geräte und ihr ganzer Dienst, ");
INSERT INTO deuelo_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","und die Säulen des Vorhofs ringsum und ihre Füße und ihre Pflöcke und ihre Seile. ");
INSERT INTO deuelo_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Und die vor der Wohnung gegen Osten, vor dem Zelte der Zusammenkunft gegen Sonnenaufgang Lagernden waren Mose und Aaron und seine Söhne, welche der Hut des Heiligtums warteten, betreffs desjenigen, was den Kindern Israel oblag. Der Fremde aber, der herzunaht, soll getötet werden. ");
INSERT INTO deuelo_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Aller gemusterten Leviten, welche Mose und Aaron nach dem Befehl Jehovas nach ihren Familien musterten, aller Männlichen von einem Monat und darüber, waren zweiundzwanzigtausend. ");
INSERT INTO deuelo_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Und Jehova sprach zu Mose: Mustere alle männlichen Erstgeborenen der Kinder Israel, von einem Monat und darüber, und nimm die Zahl ihrer Namen auf. ");
INSERT INTO deuelo_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Und du sollst die Leviten für mich, Jehova nehmen, anstatt aller Erstgeborenen unter den Kindern Israel, und das Vieh der Leviten anstatt alles Erstgeborenen unter dem Vieh der Kinder Israel. ");
INSERT INTO deuelo_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Und Mose musterte, so wie Jehova ihm geboten hatte, alle Erstgeborenen unter den Kindern Israel. ");
INSERT INTO deuelo_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Und es waren aller männlichen Erstgeborenen, nach der Zahl der Namen, von einem Monat und darüber, nach ihren Gemusterten, zweiundzwanzigtausend zweihundertdreiundsiebzig. ");
INSERT INTO deuelo_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Nimm die Leviten anstatt aller Erstgeborenen unter den Kindern Israel und das Vieh der Leviten anstatt ihres Viehes; und mir, sollen die Leviten gehören, mir, Jehova. ");
INSERT INTO deuelo_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Und was die Lösung der zweihundertdreiundsiebzig betrifft, welche von den Erstgeborenen der Kinder Israel überzählig sind über die Leviten, ");
INSERT INTO deuelo_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","so sollst du je fünf Sekel auf den Kopf nehmen; nach dem Sekel des Heiligtums sollst du sie nehmen, zwanzig Gera der Sekel. ");
INSERT INTO deuelo_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Und das Geld sollst du als Lösung der Überzähligen unter ihnen Aaron und seinen Söhnen geben. ");
INSERT INTO deuelo_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Und Mose nahm das Lösegeld von denen, welche überzählig waren über die durch die Leviten Gelösten; ");
INSERT INTO deuelo_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","von den Erstgeborenen der Kinder Israel nahm er das Geld, tausend dreihundertfünfundsechzig Sekel, nach dem Sekel des Heiligtums. ");
INSERT INTO deuelo_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Und Mose gab das Geld der Lösung Aaron und seinen Söhnen, nach dem Befehl Jehovas, so wie Jehova dem Mose geboten hatte. ");
INSERT INTO deuelo_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Und Jehova redete zu Mose und zu Aaron und sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Nehmet auf die Summe der Söhne Kehaths aus der Mitte der Söhne Levis, nach ihren Familien, nach ihren Vaterhäusern, ");
INSERT INTO deuelo_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","von dreißig Jahren und darüber bis zu fünfzig Jahren, alle, welche in die Arbeit treten, um das Werk am Zelte der Zusammenkunft zu verrichten. ");
INSERT INTO deuelo_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Dies ist der Dienst der Söhne Kehaths am Zelte der Zusammenkunft: das Hochheilige. ");
INSERT INTO deuelo_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Und Aaron und seine Söhne sollen beim Aufbruch des Lagers hineingehen und den Scheidevorhang abnehmen und die Lade des Zeugnisses damit bedecken; ");
INSERT INTO deuelo_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","und sie sollen eine Decke von Dachsfell darüber legen und ein Tuch, ganz von blauem Purpur, oben darüber breiten und ihre Stangen daran tun. ");
INSERT INTO deuelo_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Und über den Tisch der Schaubrote sollen sie ein Tuch von blauem Purpur breiten und darauf stellen die Schüsseln und Schalen und Spendschalen und die Kannen zum Trankopfer; und das beständige Brot soll auf demselben sein; ");
INSERT INTO deuelo_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Und hierüber sollen sie ein Tuch von Karmesin breiten und es mit einer Decke von Dachsfell bedecken; und sie sollen seine Stangen daran tun. ");
INSERT INTO deuelo_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Und sie sollen ein Tuch von blauem Purpur nehmen und den Leuchter des Lichts bedecken und seine Lampen und seine Lichtschneuzen und seine Löschnäpfe und alle seine Ölgefäße, womit man den Dienst an ihm verrichtet; ");
INSERT INTO deuelo_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Und sie sollen ihn und alle seine Geräte in eine Decke von Dachsfell tun und auf die Trage legen. ");
INSERT INTO deuelo_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Und über den goldenen Altar sollen sie ein Tuch von blauem Purpur breiten und ihn mit einer Decke von Dachsfell bedecken und seine Stangen daran tun. ");
INSERT INTO deuelo_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Und sie sollen alle Geräte des Dienstes nehmen, womit man den Dienst im Heiligtum verrichtet, und sie in ein Tuch von blauem Purpur legen und sie mit einer Decke von Dachsfell bedecken und auf die Trage legen. ");
INSERT INTO deuelo_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Und sie sollen den Altar von der Fettasche reinigen und ein Tuch von rotem Purpur über ihn breiten, ");
INSERT INTO deuelo_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","und darauf legen alle seine Geräte, womit man den Dienst auf ihm verrichtet: die Kohlenpfannen und die Gabeln und die Schaufeln und die Sprengschalen, alle Geräte des Altars; und sie sollen eine Decke von Dachsfell darüber breiten und seine Stangen daran tun. ");
INSERT INTO deuelo_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Und wenn Aaron und seine Söhne beim Aufbruch des Lagers das Bedecken des Heiligtums und aller Geräte des Heiligtums vollendet haben, so sollen danach die Söhne Kehaths kommen, um es zu tragen, damit sie das Heilige nicht anrühren und sterben. Das ist es, was die Söhne Kehaths vom Zelte der Zusammenkunft zu tragen haben. ");
INSERT INTO deuelo_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Und Eleasar, der Sohn Aarons, des Priesters, hat die Aufsicht über das Öl zum Licht und das wohlriechende Räucherwerk und das beständige Speisopfer und das Salböl, die Aufsicht über die ganze Wohnung und alles, was darin ist, über das Heiligtum wie über seine Geräte. ");
INSERT INTO deuelo_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Und Jehova redete zu Mose und zu Aaron und sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Ihr sollt den Stamm der Familien der Kehathiter nicht ausgerottet werden lassen aus der Mitte der Leviten; ");
INSERT INTO deuelo_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","sondern dies sollt ihr ihnen tun, damit sie leben und nicht sterben, wenn sie dem Allerheiligsten nahen: Aaron und seine Söhne sollen hineingehen und jeden einzelnen von ihnen an seinen Dienst und an seine Traglast stellen; ");
INSERT INTO deuelo_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","aber sie sollen nicht hineingehen, daß sie auch nur einen Augenblick das Heilige sehen und sterben. ");
INSERT INTO deuelo_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","Nimm auch die Summe der Söhne Gersons auf, nach ihren Vaterhäusern, nach ihren Familien; ");
INSERT INTO deuelo_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","von dreißig Jahren und darüber bis zu fünfzig Jahren sollst du sie mustern, alle, welche in die Arbeit treten, um den Dienst am Zelte der Zusammenkunft zu verrichten. ");
INSERT INTO deuelo_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Dies ist der Dienst der Familien der Gersoniter im Dienen und im Tragen: ");
INSERT INTO deuelo_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Sie sollen die Teppiche der Wohnung tragen und das Zelt der Zusammenkunft, seine Decke und die Decke von Dachsfell, die oben darüber ist, und den Vorhang vom Eingang des Zeltes der Zusammenkunft, ");
INSERT INTO deuelo_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","und die Umhänge des Vorhofs und den Vorhang vom Eingang des Tores des Vorhofs, welcher rings um die Wohnung und um den Altar ist, und ihre Seile, und alle Geräte ihres Dienstes; und alles, was an ihnen zu tun ist, sollen sie verrichten. ");
INSERT INTO deuelo_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Nach dem Befehl Aarons und seiner Söhne soll aller Dienst der Söhne der Gersoniter sein hinsichtlich all ihrer Traglast und all ihres Dienstes; und ihr sollt ihnen die Hut alles dessen auftragen, was sie zu tragen haben. ");
INSERT INTO deuelo_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Das ist der Dienst der Familien der Söhne der Gersoniter am Zelte der Zusammenkunft; und ihre Hut sei unter der Hand Ithamars, des Sohnes Aarons, des Priesters. ");
INSERT INTO deuelo_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Die Söhne Meraris, nach ihren Familien, nach ihren Vaterhäusern sollst du sie mustern; ");
INSERT INTO deuelo_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","von dreißig Jahren und darüber bis zu fünfzig Jahren sollst du sie mustern, alle, welche in die Arbeit treten, um den Dienst am Zelte der Zusammenkunft zu verrichten. ");
INSERT INTO deuelo_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Und dies ist es, was ihnen zu tragen obliegt, nach ihrem ganzen Dienst am Zelte der Zusammenkunft: die Bretter der Wohnung und ihre Riegel und ihre Säulen und ihre Füße, ");
INSERT INTO deuelo_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","und die Säulen des Vorhofs ringsum und ihre Füße und ihre Pflöcke und ihre Seile, nach allen ihren Geräten und nach all ihrem Dienst; und mit Namen sollt ihr ihnen die Geräte zuzählen, die ihnen zu tragen obliegen. ");
INSERT INTO deuelo_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Das ist der Dienst der Familien der Söhne Meraris, nach all ihrem Dienst am Zelte der Zusammenkunft, unter der Hand Ithamars, des Sohnes Aarons, des Priesters. ");
INSERT INTO deuelo_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Und Mose und Aaron und die Fürsten der Gemeinde musterten die Söhne der Kehathiter nach ihren Familien und nach ihren Vaterhäusern, ");
INSERT INTO deuelo_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","von dreißig Jahren und darüber bis zu fünfzig Jahren, alle, welche in die Arbeit traten zum Dienst am Zelte der Zusammenkunft. ");
INSERT INTO deuelo_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Und es waren ihrer Gemusterten, nach ihren Familien, zweitausend siebenhundertfünfzig. ");
INSERT INTO deuelo_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Das sind die Gemusterten der Familien der Kehathiter, alle, welche am Zelte der Zusammenkunft dienten, die Mose und Aaron musterten nach dem Befehl Jehovas durch Mose. ");
INSERT INTO deuelo_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Und die Gemusterten der Söhne Gersons, nach ihren Familien und nach ihren Vaterhäusern, ");
INSERT INTO deuelo_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","von dreißig Jahren und darüber bis zu fünfzig Jahren, alle, welche in die Arbeit traten zum Dienst am Zelte der Zusammenkunft: ");
INSERT INTO deuelo_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","es waren ihrer Gemusterten, nach ihren Familien, nach ihren Vaterhäusern, zweitausend sechshundertdreißig. ");
INSERT INTO deuelo_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Das sind die Gemusterten der Familien der Söhne Gersons, alle, welche am Zelte der Zusammenkunft dienten, die Mose und Aaron musterten nach dem Befehl Jehovas. ");
INSERT INTO deuelo_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Und die Gemusterten der Familien der Söhne Meraris, nach ihren Familien, nach ihren Vaterhäusern, ");
INSERT INTO deuelo_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","von dreißig Jahren und darüber bis zu fünfzig Jahren, alle, welche in die Arbeit traten zum Dienst am Zelte der Zusammenkunft: ");
INSERT INTO deuelo_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","es waren ihrer Gemusterten, nach ihren Familien, dreitausend zweihundert. ");
INSERT INTO deuelo_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Das sind die Gemusterten der Familien der Söhne Meraris, die Mose und Aaron musterten nach dem Befehl Jehovas durch Mose. ");
INSERT INTO deuelo_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Aller Gemusterten, welche Mose und Aaron und die Fürsten Israels musterten, der Leviten nach ihren Familien und nach ihren Vaterhäusern, ");
INSERT INTO deuelo_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","von dreißig Jahren und darüber bis zu fünfzig Jahren, aller, welche antraten, um den Dienst der Bedienung und den Dienst des Tragens am Zelte der Zusammenkunft zu verrichten: ");
INSERT INTO deuelo_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","ihrer Gemusterten waren achttausend fünfhundertachtzig. ");
INSERT INTO deuelo_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Nach dem Befehl Jehovas musterte man sie durch Mose, jeden einzelnen zu seinem Dienst und zu seiner Traglast; und sie wurden von ihm gemustert, wie Jehova dem Mose geboten hatte. ");
INSERT INTO deuelo_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","Gebiete den Kindern Israel, daß sie alle Aussätzigen und alle Flüssigen und alle wegen einer Leiche Verunreinigten aus dem Lager hinauszutun; ");
INSERT INTO deuelo_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","sowohl Mann als Weib sollt ihr hinaustun, vor das Lager sollt ihr sie hinaustun, damit sie nicht ihre Lager verunreinigen, in deren Mitte ich wohne. ");
INSERT INTO deuelo_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Und die Kinder Israel taten also und taten sie vor das Lager hinaus; so wie Jehova zu Mose geredet hatte, also taten die Kinder Israel. ");
INSERT INTO deuelo_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Rede zu den Kindern Israel: Wenn ein Mann oder ein Weib irgend eine von allen Sünden der Menschen tun, so daß sie eine Untreue gegen Jehova begehen, und selbige Seele sich verschuldet, ");
INSERT INTO deuelo_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","so sollen sie ihre Sünde bekennen, die sie getan haben; und der Täter soll seine Schuld erstatten nach ihrer vollen Summe und soll das Fünftel davon hinzufügen und es dem geben, an welchem er sich verschuldet hat. ");
INSERT INTO deuelo_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Und wenn der Mann keinen Blutsverwandten hat, um diesem die Schuld zu erstatten, so soll die Schuld, welche Jehova erstattet wird, dem Priester gehören außer dem Widder der Versöhnung, womit man Sühnung für ihn tut. - ");
INSERT INTO deuelo_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Und jedes Hebopfer von allen heiligen Dingen der Kinder Israel, welche sie dem Priester darbringen, soll ihm gehören. ");
INSERT INTO deuelo_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Ja, ihm sollen eines jeden heilige Dinge gehören; was jemand dem Priester gibt, soll ihm gehören. ");
INSERT INTO deuelo_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","Rede zu den Kindern Israel und sprich zu ihnen: Wenn irgend eines Mannes Weib ausschweift und Untreue gegen ihn begeht, ");
INSERT INTO deuelo_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","und ein Mann liegt bei ihr zur Begattung, und es ist verborgen vor den Augen ihres Mannes, und sie hat sich im geheimen verunreinigt, und es ist kein Zeuge gegen sie, und sie ist nicht ertappt worden; ");
INSERT INTO deuelo_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","und der Geist der Eifersucht kommt über ihn, und er wird eifersüchtig auf sein Weib, und sie hat sich verunreinigt; oder der Geist der Eifersucht kommt über ihn, und er wird eifersüchtig auf sein Weib, und sie hat sich nicht verunreinigt: ");
INSERT INTO deuelo_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","so soll der Mann sein Weib zu dem Priester bringen und ihre Opfergabe ihrethalben bringen, ein Zehntel Epha Gerstenmehl; er soll kein Öl darauf gießen und keinen Weihrauch darauf legen; denn es ist ein Speisopfer der Eifersucht, ein Speisopfer des Gedächtnisses, welches Ungerechtigkeit ins Gedächtnis bringt. ");
INSERT INTO deuelo_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Und der Priester soll sie herzunahen lassen und sie vor Jehova stellen. ");
INSERT INTO deuelo_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Und der Priester nehme heiliges Wasser in einem irdenen Gefäße; und der Priester nehme von dem Staube, der auf dem Fußboden der Wohnung ist, und tue ihn in das Wasser. ");
INSERT INTO deuelo_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Und der Priester stelle das Weib vor Jehova und entblöße das Haupt des Weibes, und lege auf ihre Hände das Speisopfer des Gedächtnisses; es ist ein Speisopfer der Eifersucht; und das fluchbringende Wasser der Bitterkeit soll in der Hand des Priesters sein. ");
INSERT INTO deuelo_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Und der Priester soll sie beschwören und zu dem Weibe sagen: Wenn kein Mann bei dir gelegen hat, und wenn du, unter deinem Manne seiend, nicht ausgeschweift bist in Unreinigkeit, so bleibe unversehrt von diesem fluchbringenden Wasser der Bitterkeit; ");
INSERT INTO deuelo_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","wenn du aber, unter deinem Manne seiend, ausgeschweift bist und dich verunreinigt hast, und ein Mann bei dir gelegen hat außer deinem Manne, - ");
INSERT INTO deuelo_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","und zwar soll der Priester das Weib beschwören mit dem Schwure des Fluches, und der Priester soll zu dem Weibe sagen: So mache dich Jehova zum Fluche und zum Schwure in der Mitte deines Volkes, indem Jehova deine Hüfte schwinden und deinen Bauch schwellen mache, ");
INSERT INTO deuelo_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","und es komme dieses fluchbringende Wasser in deine Eingeweide, um den Bauch schwellen und die Hüfte schwinden zu machen! Und das Weib soll sagen: Amen, Amen! ");
INSERT INTO deuelo_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Und der Priester soll diese Flüche in ein Buch schreiben und sie in das Wasser der Bitterkeit auslöschen; ");
INSERT INTO deuelo_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","und er soll das Weib das fluchbringende Wasser der Bitterkeit trinken lassen, damit das fluchbringende Wasser in sie komme zur Bitterkeit. ");
INSERT INTO deuelo_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Und der Priester nehme aus der Hand des Weibes das Speisopfer der Eifersucht und webe das Speisopfer vor Jehova und bringe es zum Altar; ");
INSERT INTO deuelo_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","und der Priester nehme eine Handvoll von dem Speisopfer als dessen Gedächtnisteil und räuchere es auf dem Altar; und danach soll er das Weib das Wasser trinken lassen. ");
INSERT INTO deuelo_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Und hat er sie das Wasser trinken lassen, so wird es geschehen, wenn sie sich verunreinigt und Untreue begangen hat gegen ihren Mann, daß das fluchbringende Wasser in sie kommen wird zur Bitterkeit, und ihr Bauch wird schwellen und ihre Hüfte schwinden; und das Weib wird zum Fluche werden in der Mitte ihres Volkes. ");
INSERT INTO deuelo_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Wenn aber das Weib sich nicht verunreinigt hat und rein ist, so wird sie unversehrt bleiben und Samen empfangen. ");
INSERT INTO deuelo_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Das ist das Gesetz der Eifersucht: Wenn ein Weib, unter ihrem Manne seiend, ausschweift und sich verunreinigt, ");
INSERT INTO deuelo_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","oder wenn über einen Mann der Geist der Eifersucht kommt, und er wird eifersüchtig auf sein Weib, so soll er das Weib vor Jehova stellen, und der Priester soll ihr tun nach diesem, ganzen Gesetz. ");
INSERT INTO deuelo_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Und der Mann wird frei sein von Schuld; selbiges Weib aber soll ihre Missetat tragen. ");
INSERT INTO deuelo_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Rede zu den Kindern Israel und sprich zu ihnen: Wenn ein Mann oder ein Weib sich weiht, indem er das Gelübde eines Nasirs gelobt, um sich für Jehova abzusondern, ");
INSERT INTO deuelo_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","so soll er sich des Weines und des starken Getränks enthalten: Essig von Wein und Essig von starkem Getränk soll er nicht trinken; und keinerlei Traubensaft soll er trinken, und Trauben, frische oder getrocknete, soll er nicht essen. ");
INSERT INTO deuelo_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Alle die Tage seiner Absonderung soll er von allem, was vom Weinstock bereitet wird, von den Kernen bis zur Hülse, nicht essen. ");
INSERT INTO deuelo_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Alle die Tage des Gelübdes seiner Absonderung soll kein Schermesser über sein Haupt gehen; bis die Tage erfüllt sind, die er sich für Jehova absondert, soll er heilig sein; er soll das Haar seines Hauptes frei wachsen lassen. ");
INSERT INTO deuelo_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Alle die Tage, die er sich für Jehova absondert, soll er zu keiner Leiche kommen. ");
INSERT INTO deuelo_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Wegen seines Vaters und wegen seiner Mutter, wegen seines Bruders und wegen seiner Schwester, ihretwegen soll er sich nicht verunreinigen, wenn sie sterben; denn die Weihe seines Gottes ist auf seinem Haupte. ");
INSERT INTO deuelo_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Alle die Tage seiner Absonderung ist er dem Jehova heilig. ");
INSERT INTO deuelo_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Und wenn jemand unversehens, plötzlich, bei ihm stirbt, und er das Haupt seiner Weihe verunreinigt, so soll er sein Haupt an dem Tage seiner Reinigung scheren; am siebten Tage soll er es scheren. ");
INSERT INTO deuelo_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Und am achten Tage soll er zwei Turteltauben oder zwei junge Tauben zu dem Priester bringen an den Eingang des Zeltes der Zusammenkunft. ");
INSERT INTO deuelo_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Und der Priester soll eine zum Sündopfer und eine zum Brandopfer opfern, und Sühnung für ihn tun deswegen, daß er sich an der Leiche versündigt hat; und er soll sein Haupt an selbigem Tage heiligen. ");
INSERT INTO deuelo_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Und er soll die Tage seiner Absonderung nochmals für Jehova absondern und ein einjähriges Lamm zum Schuldopfer bringen; die vorigen Tage aber sind verfallen, denn seine Weihe ist verunreinigt worden. ");
INSERT INTO deuelo_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Und dies ist das Gesetz des Nasirs: An dem Tage, an welchem die Tage seiner Absonderung erfüllt sind, soll man ihn an den Eingang des Zeltes der Zusammenkunft bringen. ");
INSERT INTO deuelo_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Und er soll Jehova seine Opfergabe darbringen: ein einjähriges Lamm ohne Fehl zum Brandopfer, und ein einjähriges weibliches Lamm ohne Fehl zum Sündopfer; und einen Widder ohne Fehl zum Friedensopfer, ");
INSERT INTO deuelo_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","und einen Korb mit Ungesäuertem: Feinmehlkuchen, gemengt mit Öl, und ungesäuerte Fladen, gesalbt mit Öl; nebst ihrem Speisopfer und ihren Trankopfern. ");
INSERT INTO deuelo_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Und der Priester soll sie vor Jehova darbringen und sein Sündopfer und sein Brandopfer opfern. ");
INSERT INTO deuelo_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Und den Widder soll er als Friedensopfer dem Jehova opfern samt dem Korbe des Ungesäuerten; und der Priester soll dessen Speisopfer und dessen Trankopfer opfern. ");
INSERT INTO deuelo_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Und der Nasir soll an dem Eingang des Zeltes der Zusammenkunft das Haupt seiner Weihe scheren und das Haar des Hauptes seiner Weihe nehmen und es auf das Feuer legen, das unter dem Friedensopfer ist. ");
INSERT INTO deuelo_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Und der Priester nehme den gekochten Bug von dem Widder und einen ungesäuerten Kuchen und einen ungesäuerten Fladen aus dem Korbe und lege sie auf die Hände des Nasirs, nachdem er das Zeichen seiner Weihe geschoren hat. ");
INSERT INTO deuelo_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Und der Priester webe sie als Webopfer vor Jehova; es ist dem Priester heilig nebst der Brust des Webopfers und nebst dem Schenkel des Hebopfers. Und danach mag der Nasir Wein trinken. ");
INSERT INTO deuelo_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Das ist das Gesetz des Nasirs, der ein Gelübde tut, und das seine Opfergabe dem Jehova wegen seiner Weihe, außer dem, was seine Hand aufbringen kann. Gemäß seinem Gelübde, das er getan hat, also soll er tun nach dem Gesetz seiner Weihe. ");
INSERT INTO deuelo_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Rede zu Aaron und zu seinen Söhnen und sprich: So sollt ihr die Kinder Israel segnen; sprechet zu ihnen: ");
INSERT INTO deuelo_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Jehova segne dich und behüte dich! ");
INSERT INTO deuelo_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Jehova lasse sein Angesicht über dir leuchten und sei dir gnädig! ");
INSERT INTO deuelo_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Jehova erhebe sein Angesicht auf dich und gebe dir Frieden! ");
INSERT INTO deuelo_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Und so sollen sie meinen Namen auf die Kinder Israel legen, und ich werde sie segnen. ");
INSERT INTO deuelo_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Und es geschah an dem Tage, da Mose das Aufrichten der Wohnung vollendet und sie gesalbt und sie geheiligt hatte mit allen ihren Geräten, sowie den Altar und alle seine Geräte, und er sie gesalbt und sie geheiligt hatte, ");
INSERT INTO deuelo_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","da brachten die Fürsten Israels, die Häupter ihrer Vaterhäuser, sie, die Fürsten der Stämme, die Vorsteher der Gemusterten, ");
INSERT INTO deuelo_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","sie brachten ihre Opfergabe dar vor Jehova: sechs bedeckte Wagen und zwölf Rinder, einen Wagen für zwei Fürsten und ein Rind für einen; und sie brachten sie dar vor der Wohnung. ");
INSERT INTO deuelo_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","Nimm sie von Ihnen, und sie seien zum Verrichten des Dienstes des Zeltes der Zusammenkunft, und gib sie den Leviten, einem jeden nach Verhältnis seines Dienstes. ");
INSERT INTO deuelo_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Und Mose nahm die Wagen und die Rinder und gab sie den Leviten. ");
INSERT INTO deuelo_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Zwei Wagen und vier Rinder gab er den Söhnen Gersons nach Verhältnis ihres Dienstes; ");
INSERT INTO deuelo_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","und vier Wagen und acht Rinder gab er den Söhnen Meraris nach Verhältnis ihres Dienstes: unter der Hand Ithamars, des Sohnes Aarons, des Priesters. ");
INSERT INTO deuelo_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Aber den Söhnen Kehaths gab er nichts; denn ihnen lag der Dienst des Heiligtums ob: auf der Schulter trugen sie. ");
INSERT INTO deuelo_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Und die Fürsten brachten die Einweihungsgabe des Altars dar an dem Tage, da er gesalbt wurde; und die Fürsten brachten ihre Opfergabe dar vor dem Altar. ");
INSERT INTO deuelo_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Und Jehova sprach zu Mose: Je ein Fürst auf einen Tag sollen sie ihre Opfergabe zur Einweihung des Altars darbringen. ");
INSERT INTO deuelo_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Und es geschah, der am ersten Tage seine Opfergabe darbrachte, war Nachschon, der Sohn Amminadabs, vom Stamme Juda. ");
INSERT INTO deuelo_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Und seine Opfergabe war: eine silberne Schüssel, hundertdreißig Sekel ihr Gewicht, eine silberne Sprengschale, siebzig Sekel, nach dem Sekel des Heiligtums, beide voll Feinmehl, gemengt mit Öl, zum Speisopfer; ");
INSERT INTO deuelo_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","eine Schale, zehn Sekel Gold, voll Räucherwerk; ");
INSERT INTO deuelo_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","ein junger Farre, ein Widder, ein einjähriges Lamm, zum Brandopfer; ");
INSERT INTO deuelo_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","ein Ziegenbock zum Sündopfer; ");
INSERT INTO deuelo_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","und zum Friedensopfer zwei Rinder, fünf Widder, fünf Böcke, fünf einjährige Lämmer. Das war die Opfergabe Nachschons, des Sohnes Amminadabs. ");
INSERT INTO deuelo_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Am zweiten Tage brachte Nethaneel dar, der Sohn Zuars, der Fürst von Issaschar; ");
INSERT INTO deuelo_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","er brachte seine Opfergabe dar: eine silberne Schüssel, hundertdreißig Sekel ihr Gewicht, eine silberne Sprengschale, siebzig Sekel, nach dem Sekel des Heiligtums, beide voll Feinmehl, gemengt mit Öl, zum Speisopfer; ");
INSERT INTO deuelo_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","eine Schale, zehn Sekel Gold, voll Räucherwerk; ");
INSERT INTO deuelo_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","einen jungen Farren, einen Widder, ein einjähriges Lamm, zum Brandopfer; ");
INSERT INTO deuelo_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","einen Ziegenbock zum Sündopfer; ");
INSERT INTO deuelo_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","und zum Friedensopfer zwei Rinder, fünf Widder, fünf Böcke, fünf einjährige Lämmer. Das war die Opfergabe Nethaneels, des Sohnes Zuars. ");
INSERT INTO deuelo_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Am dritten Tage der Fürst der Söhne Sebulons, Eliab, der Sohn Helons. ");
INSERT INTO deuelo_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Seine Opfergabe war: eine silberne Schüssel, hundertdreißig Sekel ihr Gewicht, eine silberne Sprengschale, siebzig Sekel, nach dem Sekel des Heiligtums, beide voll Feinmehl, gemengt mit Öl, zum Speisopfer; ");
INSERT INTO deuelo_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","eine Schale, zehn Sekel Gold, voll Räucherwerk; ");
INSERT INTO deuelo_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","ein junger Farre, ein Widder, ein einjähriges Lamm, zum Brandopfer; ");
INSERT INTO deuelo_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","ein Ziegenbock zum Sündopfer; ");
INSERT INTO deuelo_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","und zum Friedensopfer zwei Rinder, fünf Widder, fünf Böcke, fünf einjährige Lämmer. Das war die Opfergabe Eliabs, des Sohnes Helons. ");
INSERT INTO deuelo_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Am vierten Tage der Fürst der Söhne Rubens, Elizur, der Sohn Schedeurs. ");
INSERT INTO deuelo_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Seine Opfergabe war: eine silberne Schüssel, hundertdreißig Sekel ihr Gewicht, eine silberne Sprengschale, siebzig Sekel, nach dem Sekel des Heiligtums, beide voll Feinmehl, gemengt mit Öl, zum Speisopfer; ");
INSERT INTO deuelo_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","eine Schale, zehn Sekel Gold, voll Räucherwerk; ");
INSERT INTO deuelo_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","ein junger Farre, ein Widder, ein einjähriges Lamm, zum Brandopfer; ");
INSERT INTO deuelo_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","ein Ziegenbock zum Sündopfer; ");
INSERT INTO deuelo_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","und zum Friedensopfer zwei Rinder, fünf Widder, fünf Böcke, fünf einjährige Lämmer. Das war die Opfergabe Elizurs, des Sohnes Schedeurs. ");
INSERT INTO deuelo_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Am fünften Tage der Fürst der Söhne Simeons, Schelumiel, der Sohn Zurischaddais. ");
INSERT INTO deuelo_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Seine Opfergabe war: eine silberne Schüssel, hundertdreißig Sekel ihr Gewicht, eine silberne Sprengschale, siebzig Sekel, nach dem Sekel des Heiligtums, beide voll Feinmehl, gemengt mit Öl, zum Speisopfer; ");
INSERT INTO deuelo_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","eine Schale, zehn Sekel Gold, voll Räucherwerk; ");
INSERT INTO deuelo_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","ein junger Farre, ein Widder, ein einjähriges Lamm, zum Brandopfer; ");
INSERT INTO deuelo_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","ein Ziegenbock zum Sündopfer; ");
INSERT INTO deuelo_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","und zum Friedensopfer zwei Rinder, fünf Widder, fünf Böcke, fünf einjährige Lämmer. Das war die Opfergabe Schelumiels, des Sohnes Zurischaddais. ");
INSERT INTO deuelo_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Am sechsten Tage der Fürst der Söhne Gads, Eljasaph, der Sohn Deghuels. ");
INSERT INTO deuelo_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Seine Opfergabe war: eine silberne Schüssel, hundertdreißig Sekel ihr Gewicht, eine silberne Sprengschale, siebzig Sekel, nach dem Sekel des Heiligtums, beide voll Feinmehl, gemengt mit Öl, zum Speisopfer; ");
INSERT INTO deuelo_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","eine Schale, zehn Sekel Gold, voll Räucherwerk; ");
INSERT INTO deuelo_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","ein junger Farre, ein Widder, ein einjähriges Lamm, zum Brandopfer; ");
INSERT INTO deuelo_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","ein Ziegenbock zum Sündopfer; ");
INSERT INTO deuelo_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","und zum Friedensopfer zwei Rinder, fünf Widder, fünf Böcke, fünf einjährige Lämmer. Das war die Opfergabe Eljasaphs, des Sohnes Deghuels. ");
INSERT INTO deuelo_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Am siebten Tage der Fürst der Söhne Ephraims, Elischama, der Sohn Ammihuds. ");
INSERT INTO deuelo_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Seine Opfergabe war: eine silberne Schüssel, hundertdreißig Sekel ihr Gewicht, eine silberne Sprengschale, siebzig Sekel, nach dem Sekel des Heiligtums, beide voll Feinmehl, gemengt mit Öl, zum Speisopfer; ");
INSERT INTO deuelo_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","eine Schale, zehn Sekel Gold, voll Räucherwerk; ");
INSERT INTO deuelo_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","ein junger Farre, ein Widder, ein einjähriges Lamm, zum Brandopfer; ");
INSERT INTO deuelo_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","ein Ziegenbock zum Sündopfer; ");
INSERT INTO deuelo_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","und zum Friedensopfer zwei Rinder, fünf Widder, fünf Böcke, fünf einjährige Lämmer. Das war die Opfergabe Elischamas, des Sohnes Ammihuds. ");
INSERT INTO deuelo_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Am achten Tage der Fürst der Söhne Manasses, Gamliel, der Sohn Pedazurs. ");
INSERT INTO deuelo_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Seine Opfergabe war: eine silberne Schüssel, hundertdreißig Sekel ihr Gewicht, eine silberne Sprengschale, siebzig Sekel, nach dem Sekel des Heiligtums, beide voll Feinmehl, gemengt mit Öl, zum Speisopfer; ");
INSERT INTO deuelo_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","eine Schale, zehn Sekel Gold, voll Räucherwerk; ");
INSERT INTO deuelo_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","ein junger Farre, ein Widder, ein einjähriges Lamm, zum Brandopfer; ");
INSERT INTO deuelo_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","ein Ziegenbock zum Sündopfer; ");
INSERT INTO deuelo_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","und zum Friedensopfer zwei Rinder, fünf Widder, fünf Böcke, fünf einjährige Lämmer. Das war die Opfergabe Gamliels, des Sohnes Pedazurs. ");
INSERT INTO deuelo_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Am neunten Tage der Fürst der Söhne Benjamins, Abidan, der Sohn Gideonis. ");
INSERT INTO deuelo_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Seine Opfergabe war: eine silberne Schüssel, hundertdreißig Sekel ihr Gewicht, eine silberne Sprengschale, siebzig Sekel, nach dem Sekel des Heiligtums, beide voll Feinmehl, gemengt mit Öl, zum Speisopfer; ");
INSERT INTO deuelo_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","eine Schale, zehn Sekel Gold, voll Räucherwerk; ");
INSERT INTO deuelo_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","ein junger Farre, ein Widder, ein einjähriges Lamm, zum Brandopfer; ");
INSERT INTO deuelo_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","ein Ziegenbock zum Sündopfer; ");
INSERT INTO deuelo_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","und zum Friedensopfer zwei Rinder, fünf Widder, fünf Böcke, fünf einjährige Lämmer. Das war die Opfergabe Abidans, des Sohnes Gideonis. ");
INSERT INTO deuelo_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Am zehnten Tage der Fürst der Söhne Dans, Achieser, der Sohn Ammischaddais. ");
INSERT INTO deuelo_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Seine Opfergabe war: eine silberne Schüssel, hundertdreißig Sekel ihr Gewicht, eine silberne Sprengschale, siebzig Sekel, nach dem Sekel des Heiligtums, beide voll Feinmehl, gemengt mit Öl, zum Speisopfer; ");
INSERT INTO deuelo_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","eine Schale, zehn Sekel Gold, voll Räucherwerk; ");
INSERT INTO deuelo_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","ein junger Farre, ein Widder, ein einjähriges Lamm, zum Brandopfer; ");
INSERT INTO deuelo_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","ein Ziegenbock zum Sündopfer; ");
INSERT INTO deuelo_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","und zum Friedensopfer zwei Rinder, fünf Widder, fünf Böcke, fünf einjährige Lämmer. Das war die Opfergabe Achiesers, des Sohnes Ammischaddais. ");
INSERT INTO deuelo_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Am elften Tage der Fürst der Söhne Asers, Pagiel, der Sohn Okrans. ");
INSERT INTO deuelo_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Seine Opfergabe war: eine silberne Schüssel, hundertdreißig Sekel ihr Gewicht, eine silberne Sprengschale, siebzig Sekel, nach dem Sekel des Heiligtums, beide voll Feinmehl, gemengt mit Öl, zum Speisopfer; ");
INSERT INTO deuelo_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","eine Schale, zehn Sekel Gold, voll Räucherwerk; ");
INSERT INTO deuelo_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","ein junger Farre, ein Widder, ein einjähriges Lamm, zum Brandopfer; ");
INSERT INTO deuelo_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","ein Ziegenbock zum Sündopfer; ");
INSERT INTO deuelo_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","und zum Friedensopfer zwei Rinder, fünf Widder, fünf Böcke, fünf einjährige Lämmer. Das war die Opfergabe Pagiels, des Sohnes Okrans. ");
INSERT INTO deuelo_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Am zwölften Tage der Fürst der Söhne Naphtalis, Achira, der Sohn Enans. ");
INSERT INTO deuelo_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Seine Opfergabe war: eine silberne Schüssel, hundertdreißig Sekel ihr Gewicht, eine silberne Sprengschale, siebzig Sekel, nach dem Sekel des Heiligtums, beide voll Feinmehl, gemengt mit Öl, zum Speisopfer; ");
INSERT INTO deuelo_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","eine Schale, zehn Sekel Gold, voll Räucherwerk; ");
INSERT INTO deuelo_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","ein junger Farre, ein Widder, ein einjähriges Lamm, zum Brandopfer; ");
INSERT INTO deuelo_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","ein Ziegenbock zum Sündopfer; ");
INSERT INTO deuelo_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","und zum Friedensopfer zwei Rinder, fünf Widder, fünf Böcke, fünf einjährige Lämmer. Das war die Opfergabe Achiras, des Sohnes Enans. ");
INSERT INTO deuelo_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Dies war die Einweihungsgabe des Altars, seitens der Fürsten Israels, an dem Tage, da er gesalbt wurde: zwölf silberne Schüsseln, zwölf silberne Sprengschalen, zwölf goldene Schalen; ");
INSERT INTO deuelo_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","hundertdreißig Sekel eine silberne Schüssel, und siebzig eine Sprengschale: alles Silber der Gefäße zweitausend vierhundert Sekel, nach dem Sekel des Heiligtums; ");
INSERT INTO deuelo_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","zwölf goldene Schalen voll Räucherwerk, je zehn Sekel eine Schale, nach dem Sekel des Heiligtums: alles Gold der Schalen hundertzwanzig Sekel. ");
INSERT INTO deuelo_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Aller Rinder zum Brandopfer waren zwölf Farren; dazu zwölf Widder, zwölf einjährige Lämmer, nebst ihrem Speisopfer; und zwölf Ziegenböcke zum Sündopfer. ");
INSERT INTO deuelo_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Und aller Rinder zum Friedensopfer waren vierundzwanzig Farren; dazu sechzig Widder, sechzig Böcke, sechzig einjährige Lämmer. Das war die Einweihungsgabe des Altars, nachdem er gesalbt worden war. ");
INSERT INTO deuelo_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Und wenn Mose in das Zelt der Zusammenkunft hineinging, um mit ihm zu reden, so hörte er die Stimme zu ihm reden von dem Deckel herab, der auf der Lade des Zeugnisses war, zwischen den beiden Cherubim hervor; und er redete zu ihm. ");
INSERT INTO deuelo_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Rede zu Aaron und sprich zu ihm: Wenn du die Lampen anzündest, so sollen die sieben Lampen gerade vor dem Leuchter hinscheinen. ");
INSERT INTO deuelo_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Und Aaron tat also: er zündete seine Lampen an, so daß sie gerade vor dem Leuchter hinschienen, so wie Jehova dem Mose geboten hatte. ");
INSERT INTO deuelo_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Und dies war die Arbeit des Leuchters: getriebene Arbeit von Gold; von seinem Fuße bis zu seinen Blumen, alles war getriebene Arbeit; nach dem Bilde, das Jehova dem Mose gezeigt, also hatte man den Leuchter gemacht. ");
INSERT INTO deuelo_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","Nimm die Leviten aus der Mitte der Kinder Israel und reinige sie. ");
INSERT INTO deuelo_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Und also sollst du mit ihnen tun, um sie zu reinigen: Sprenge Entsündigungswasser auf sie, und sie sollen das Schermesser über ihr ganzes Fleisch gehen lassen und ihre Kleider waschen und sich reinigen. ");
INSERT INTO deuelo_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Und sie sollen einen jungen Farren nehmen, und sein Speisopfer: Feinmehl, gemengt mit Öl; und einen anderen jungen Farren sollst du nehmen zum Sündopfer. ");
INSERT INTO deuelo_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Und du sollst die Leviten vor das Zelt der Zusammenkunft herzutreten lassen und die ganze Gemeinde der Kinder Israel versammeln. ");
INSERT INTO deuelo_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Und du sollst die Leviten vor Jehova herzutreten lassen, und die Kinder Israel sollen ihre Hände auf die Leviten legen. ");
INSERT INTO deuelo_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Und Aaron soll die Leviten als Webopfer von seiten der Kinder Israel vor Jehova weben, damit sie zum Verrichten des Dienstes Jehovas seien. ");
INSERT INTO deuelo_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Und die Leviten sollen ihre Hände auf den Kopf der Farren legen; und den einen sollst du als Sündopfer und den anderen als Brandopfer dem Jehova opfern, um für die Leviten Sühnung zu tun. ");
INSERT INTO deuelo_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Und so sollst du die Leviten vor Aaron und vor seine Söhne stellen und sie dem Jehova als Webopfer weben; ");
INSERT INTO deuelo_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","und du sollst die Leviten aus der Mitte der Kinder Israel aussondern, daß die Leviten mir gehören. ");
INSERT INTO deuelo_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Und danach sollen die Leviten kommen, um das Zelt der Zusammenkunft zu bedienen. So sollst du sie reinigen und sie als Webopfer weben. ");
INSERT INTO deuelo_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Denn sie sind mir ganz zu eigen gegeben aus der Mitte der Kinder Israel; anstatt alles dessen, was die Mutter bricht, anstatt jedes Erstgeborenen aus den Kindern Israel habe ich sie mir genommen. ");
INSERT INTO deuelo_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Denn mein ist alles Erstgeborene unter den Kindern Israel an Menschen und an Vieh. An dem Tage, da ich alle Erstgeburt im Lande Ägypten schlug, habe ich sie mir geheiligt. ");
INSERT INTO deuelo_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Und ich habe die Leviten genommen anstatt aller Erstgeborenen unter den Kindern Israel; ");
INSERT INTO deuelo_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","und ich habe die Leviten dem Aaron und seinen Söhnen als Gabe aus der Mitte der Kinder Israel gegeben, um den Dienst der Kinder Israel am Zelte der Zusammenkunft zu verrichten und um für die Kinder Israel Sühnung zu tun, damit unter den Kindern Israel keine Plage dadurch entstehe, daß die Kinder Israel dem Heiligtum nahen. ");
INSERT INTO deuelo_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Und Mose und Aaron und die ganze Gemeinde der Kinder Israel taten so mit den Leviten; nach allem, was Jehova dem Mose geboten hatte wegen der Leviten, also taten die Kinder Israel mit ihnen. ");
INSERT INTO deuelo_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Und die Leviten entsündigten sich und wuschen ihre Kleider; und Aaron webte sie als Webopfer vor Jehova; und Aaron tat Sühnung für sie zu ihrer Reinigung. ");
INSERT INTO deuelo_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Und danach kamen die Leviten, um ihren Dienst am Zelte der Zusammenkunft zu verrichten vor Aaron und vor seinen Söhnen. So wie Jehova dem Mose betreffs der Leviten geboten hatte, also taten sie mit ihnen. ");
INSERT INTO deuelo_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","Dies ist es, was die Leviten betrifft: Von fünfundzwanzig Jahren an und darüber soll er eintreten, um die Arbeit zu tun im Dienste des Zeltes der Zusammenkunft. ");
INSERT INTO deuelo_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Aber von fünfzig Jahren an soll er aus der Arbeit des Dienstes austreten und nicht mehr dienen; ");
INSERT INTO deuelo_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","er mag seinen Brüdern helfen am Zelte der Zusammenkunft, um der Hut zu warten; aber Dienst soll er nicht tun. So sollst du mit den Leviten tun in ihren Obliegenheiten. ");
INSERT INTO deuelo_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Und Jehova redete zu Mose in der Wüste Sinai, im zweiten Jahre nach ihrem Auszug aus dem Lande Ägypten, im ersten Monat, und sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","Die Kinder Israel sollen das Passah feiern zu seiner bestimmten Zeit; ");
INSERT INTO deuelo_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","am vierzehnten Tage in diesem Monat, zwischen den zwei Abenden, sollt ihr es feiern zu seiner bestimmten Zeit; nach allen seinen Satzungen und nach allen seinen Vorschriften sollt ihr es feiern. ");
INSERT INTO deuelo_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Und Mose redete zu den Kindern Israel, daß sie das Passah feiern sollten. ");
INSERT INTO deuelo_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Und sie feierten das Passah im ersten Monat, am vierzehnten Tage des Monats, zwischen den zwei Abenden, in der Wüste Sinai; nach allem, was Jehova dem Mose geboten hatte, also taten die Kinder Israel. ");
INSERT INTO deuelo_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Und es waren Männer da, die unrein waren wegen der Leiche eines Menschen und an jenem Tage das Passah nicht feiern konnten; und sie traten an jenem Tage vor Mose und vor Aaron. ");
INSERT INTO deuelo_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Und diese Männer sprachen zu ihm: Wir sind unrein wegen der Leiche eines Menschen; warum sollen wir verkürzt werden, daß wir die Opfergabe Jehovas nicht zur bestimmten Zeit in der Mitte der Kinder Israel darbringen? ");
INSERT INTO deuelo_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Und Mose sprach zu ihnen: Bleibet stehen, und ich will hören, was Jehova eurethalben gebieten wird. - ");
INSERT INTO deuelo_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Rede zu den Kindern Israel und sprich: Wenn irgend jemand von euch oder von euren Geschlechtern unrein ist wegen einer Leiche oder ist auf einem fernen Wege, so soll er dem Jehova Passah feiern; ");
INSERT INTO deuelo_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","im zweiten Monat, am vierzehnten Tage, zwischen den zwei Abenden, sollen sie es feiern; mit Ungesäuertem und bitteren Kräutern sollen sie es essen; ");
INSERT INTO deuelo_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","sie sollen nichts davon übrig lassen bis an den Morgen, und sollen kein Bein an ihm zerbrechen; nach allen Satzungen des Passah sollen sie es feiern. ");
INSERT INTO deuelo_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Der Mann aber, der rein und nicht auf dem Wege ist, und es unterläßt, das Passah zu feiern, selbige Seele soll ausgerottet werden aus ihren Völkern; denn er hat die Opfergabe Jehovas nicht zur bestimmten Zeit dargebracht; selbiger Mann soll seine Sünde tragen. ");
INSERT INTO deuelo_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Und wenn ein Fremdling bei euch weilt und dem Jehova Passah feiern will, so soll er es feiern nach der Satzung des Passah und nach seiner Vorschrift. Eine Satzung soll für euch sein, sowohl für den Fremdling als auch für den Eingeborenen des Landes. ");
INSERT INTO deuelo_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Und an dem Tage, da die Wohnung aufgerichtet wurde, bedeckte die Wolke die Wohnung des Zeltes des Zeugnisses; und am Abend war es über der Wohnung wie das Ansehen eines Feuers bis an den Morgen. ");
INSERT INTO deuelo_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","So war es beständig: die Wolke bedeckte sie, und des Nachts war es wie das Ansehen eines Feuers. ");
INSERT INTO deuelo_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Und so wie die Wolke sich von dem Zelte erhob, brachen danach die Kinder Israel auf; und an dem Orte, wo die Wolke sich niederließ, daselbst lagerten sich die Kinder Israel. ");
INSERT INTO deuelo_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Nach dem Befehl Jehovas brachen die Kinder Israel auf, und nach dem Befehl Jehovas lagerten sie sich; alle die Tage, da die Wolke auf der Wohnung ruhte, lagerten sie. ");
INSERT INTO deuelo_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Und wenn die Wolke viele Tage auf der Wohnung verweilte, so warteten die Kinder Israel der Hut Jehovas und brachen nicht auf. ");
INSERT INTO deuelo_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Und geschah es, daß die Wolke wenige Tage auf der Wohnung war, nach dem Befehl Jehovas lagerten sie sich, und nach dem Befehl Jehovas brachen sie auf. ");
INSERT INTO deuelo_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Und geschah es, daß die Wolke da war vom Abend bis an den Morgen, und die Wolke erhob sich am Morgen, so brachen sie auf; oder einen Tag und eine Nacht, und die Wolke erhob sich, so brachen sie auf; ");
INSERT INTO deuelo_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","oder zwei Tage oder einen Monat oder eine geraume Zeit, wenn die Wolke auf der Wohnung verweilte, indem sie darauf ruhte, so lagerten die Kinder Israel und brachen nicht auf; und wenn sie sich erhob, so brachen sie auf. ");
INSERT INTO deuelo_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Nach dem Befehl Jehovas lagerten sie sich, und nach dem Befehl Jehovas brachen sie auf; sie warteten der Hut Jehovas nach dem Befehl Jehovas durch Mose. ");
INSERT INTO deuelo_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Und Jehova redete zu Mose sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Mache dir zwei Trompeten von Silber; in getriebener Arbeit sollst du sie machen; und sie sollen dir dienen zur Berufung der Gemeinde und zum Aufbruch der Lager. ");
INSERT INTO deuelo_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Und stößt man in dieselben, so soll die ganze Gemeinde sich zu dir versammeln an den Eingang des Zeltes der Zusammenkunft. ");
INSERT INTO deuelo_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Und wenn man in eine stößt, so sollen die Fürsten sich zu dir versammeln, die Häupter der Tausende Israels. ");
INSERT INTO deuelo_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Und blaset ihr Lärm, so sollen die Lager aufbrechen, die gegen Osten lagern; ");
INSERT INTO deuelo_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","und blaset ihr Lärm zum zweiten Male, so sollen die Lager aufbrechen, die gegen Süden lagern: zu ihrem Aufbruch sollen sie Lärm blasen. ");
INSERT INTO deuelo_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Aber um die Versammlung zu versammeln, sollt ihr hineinstoßen und nicht Lärm blasen. ");
INSERT INTO deuelo_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Und die Söhne Aarons, die Priester, sollen in die Trompeten stoßen. Und sie sollen euch zu einer ewigen Satzung sein bei euren Geschlechtern. ");
INSERT INTO deuelo_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Und wenn ihr in eurem Lande in den Streit ziehet wider den Bedränger, der euch bedrängt, so sollt ihr mit den Trompeten Lärm blasen; und es wird eurer gedacht werden vor Jehova, eurem Gott, und ihr werdet gerettet werden vor euren Feinden. ");
INSERT INTO deuelo_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Und an euren Freudentagen und an euren Festen und an euren Neumonden, da sollt ihr in die Trompeten stoßen bei euren Brandopfern und bei euren Friedensopfern; und sie sollen euch zum Gedächtnis sein vor eurem Gott. Ich bin Jehova, euer Gott. ");
INSERT INTO deuelo_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Und es geschah im zweiten Jahre, im zweiten Monat, am Zwanzigsten des Monats, da erhob sich die Wolke von der Wohnung des Zeugnisses. ");
INSERT INTO deuelo_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Und die Kinder Israel brachen auf aus der Wüste Sinai nach ihren Zügen; und die Wolke ließ sich nieder in der Wüste Paran. ");
INSERT INTO deuelo_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Und sie brachen zum ersten Male auf nach dem Befehl Jehovas durch Mose. ");
INSERT INTO deuelo_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Und das Panier des Lagers der Kinder Juda brach zuerst auf nach ihren Heeren; und über sein Heer war Nachschon, der Sohn Amminadabs. ");
INSERT INTO deuelo_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Und über das Heer des Stammes der Kinder Issaschar war Nethaneel, der Sohn Zuars; ");
INSERT INTO deuelo_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","und über das Heer des Stammes der Kinder Sebulon war Eliab, der Sohn Helons. ");
INSERT INTO deuelo_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Und die Wohnung wurde abgenommen, und es brachen auf die Söhne Gersons und die Söhne Meraris, welche die Wohnung trugen. ");
INSERT INTO deuelo_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Und das Panier des Lagers Rubens brach auf nach seinen Heeren; und über sein Heer war Elizur, der Sohn Schedeurs. ");
INSERT INTO deuelo_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Und über das Heer des Stammes der Kinder Simeon war Schelumiel, der Sohn Zurischaddais; ");
INSERT INTO deuelo_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","und über das Heer des Stammes der Kinder Gad war Eljasaph, der Sohn Deghuels. ");
INSERT INTO deuelo_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Und die Kehathiter brachen auf, welche das Heiligtum trugen; und jene richteten die Wohnung auf, bis diese kamen. ");
INSERT INTO deuelo_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Und das Panier des Lagers der Kinder Ephraim brach auf nach ihren Heeren; und über sein Heer war Elischama, der Sohn Ammihuds. ");
INSERT INTO deuelo_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Und über das Heer des Stammes der Kinder Manasse war Gamliel, der Sohn Pedazurs; ");
INSERT INTO deuelo_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","und über das Heer des Stammes der Kinder Benjamin war Abidan, der Sohn Gideonis. ");
INSERT INTO deuelo_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Und das Panier des Lagers der Kinder Dan, welches die Nachhut aller Lager bildete, brach auf nach ihren Heeren; und über sein Heer war Achieser, der Sohn Ammischaddais. ");
INSERT INTO deuelo_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Und über das Heer des Stammes der Kinder Aser war Pagiel, der Sohn Okrans; ");
INSERT INTO deuelo_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","und über das Heer des Stammes der Kinder Naphtali war Achira, der Sohn Enans. - ");
INSERT INTO deuelo_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Das war die Marschordnung der Kinder Israel nach ihren Heeren; und so brachen sie auf. ");
INSERT INTO deuelo_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Und Mose sprach zu Hobab, dem Sohne Reghuels, des Midianiters, des Schwiegervaters Moses: Wir brechen auf nach dem Orte, von welchem Jehova gesagt hat: Ich will ihn euch geben. Ziehe mit uns, so werden wir dir Gutes tun; denn Jehova hat Gutes über Israel geredet. ");
INSERT INTO deuelo_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Und er sprach zu ihm: Ich will nicht mitziehen, sondern in mein Land und zu meiner Verwandtschaft will ich gehen. ");
INSERT INTO deuelo_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Und er sprach: Verlaß uns doch nicht! Denn du weißt ja, wo wir in der Wüste lagern sollen; und du wirst unser Auge sein. ");
INSERT INTO deuelo_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Und es soll geschehen, wenn du mit uns ziehst, und uns jenes Gute geschieht, das Jehova an uns tun will, so werden wir dir auch Gutes tun. ");
INSERT INTO deuelo_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Und sie brachen auf von dem Berge Jehovas, drei Tagereisen weit, und die Lade des Bundes Jehovas zog drei Tagereisen vor ihnen her, um ihnen einen Ruheort zu erkunden; ");
INSERT INTO deuelo_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","und die Wolke Jehovas war über ihnen des Tages, wenn sie aus dem Lager zogen. ");
INSERT INTO deuelo_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Und es geschah, wenn die Lade aufbrach, so sprach Mose: Stehe auf, Jehova, daß deine Feinde sich zerstreuen, und deine Hasser vor dir fliehen! ");
INSERT INTO deuelo_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Und wenn sie ruhte, so sprach er: Kehre wieder, Jehova, zu den Myriaden der Tausende Israels! ");
INSERT INTO deuelo_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Und es geschah, als das Volk sich beklagte, daß es übel war in den Ohren Jehovas; und als Jehova es hörte, da erglühte sein Zorn, und ein Feuer Jehovas brannte unter ihnen und fraß am Ende des Lagers. ");
INSERT INTO deuelo_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Und das Volk schrie zu Mose; und Mose betete zu Jehova, da legte sich das Feuer. ");
INSERT INTO deuelo_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Und man gab selbigem Orte den Namen Tabhera, weil ein Feuer Jehovas unter ihnen gebrannt hatte. ");
INSERT INTO deuelo_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Und das Mischvolk, das in ihrer Mitte war, wurde lüstern, und auch die Kinder Israel weinten wiederum und sprachen: Wer wird uns Fleisch zu essen geben? ");
INSERT INTO deuelo_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Wir gedenken der Fische, die wir in Ägypten umsonst aßen, der Gurken und der Melonen und des Lauchs und der Zwiebeln und des Knoblauchs; ");
INSERT INTO deuelo_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","und nun ist unsere Seele dürre; gar nichts ist da, nur auf das Man sehen unsere Augen. ");
INSERT INTO deuelo_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Das Man aber war wie Koriandersamen, und sein Ansehen wie das Ansehen des Bdellion. ");
INSERT INTO deuelo_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Das Volk lief umher, und sie sammelten und mahlten es mit Handmühlen oder zerstießen es in Mörsern; und sie kochten es in Töpfen, auch machten sie Kuchen daraus; und sein Geschmack war wie der Geschmack von Ölkuchen. ");
INSERT INTO deuelo_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Und wenn des Nachts der Tau auf das Lager herabfiel, so fiel das Man auf dasselbe herab. ");
INSERT INTO deuelo_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Und als Mose das Volk nach seinen Geschlechtern, einen jeden am Eingang seines Zeltes, weinen hörte, und der Zorn Jehovas heftig entbrannte, da war es übel in den Augen Moses. ");
INSERT INTO deuelo_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Und Mose sprach zu Jehova: Warum hast du an deinem Knechte übel getan, und warum habe ich nicht Gnade gefunden in deinen Augen, daß du die Last dieses ganzen Volkes auf mich legst? ");
INSERT INTO deuelo_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Bin ich mit diesem ganzen Volke schwanger gegangen, oder habe ich es geboren, daß du zu mir sprichst: Trage es in deinem Busen, gleichwie der Wärter den Säugling trägt, in das Land, das du ihren Vätern zugeschworen hast? ");
INSERT INTO deuelo_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Woher soll ich Fleisch haben, um es diesem ganzen Volke zu geben? Denn sie weinen gegen mich und sagen: Gib uns Fleisch, daß wir essen! ");
INSERT INTO deuelo_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Ich allein vermag nicht dieses ganze Volk zu tragen, denn es ist mir zu schwer. ");
INSERT INTO deuelo_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Und wenn du also mit mir tust, so bringe mich doch um, wenn ich Gnade gefunden habe in deinen Augen, damit ich mein Unglück nicht ansehe. ");
INSERT INTO deuelo_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Und Jehova sprach zu Mose: Versammle mir siebzig Männer aus den Ältesten Israels, von denen du weißt, daß sie die Ältesten des Volkes und seine Vorsteher sind, und führe sie zu dem Zelte der Zusammenkunft, daß sie sich daselbst mit dir hinstellen. ");
INSERT INTO deuelo_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Und ich werde herniederkommen und daselbst mit dir reden, und ich werde von dem Geiste nehmen, der auf dir ist, und auf sie legen, daß sie mit dir an der Last des Volkes tragen, und du sie nicht allein tragest. ");
INSERT INTO deuelo_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Und zu dem Volke sollst du sagen: Heiliget euch auf morgen, und ihr werdet Fleisch essen; denn ihr habt vor den Ohren Jehovas geweint und gesprochen: Wer wird uns Fleisch zu essen geben? Denn in Ägypten ging es uns wohl; und Jehova wird euch Fleisch geben, und ihr werdet essen. ");
INSERT INTO deuelo_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Nicht einen Tag sollt ihr essen, und nicht zwei Tage und nicht fünf Tage und nicht zehn Tage und nicht zwanzig Tage: ");
INSERT INTO deuelo_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","bis zu einem ganzen Monat, bis es euch zur Nase herauskommt, und es euch zum Ekel wird; weil ihr Jehova, der in eurer Mitte ist, verachtet und vor ihm geweint und gesprochen habt: Warum doch sind wir aus Ägypten herausgezogen? ");
INSERT INTO deuelo_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Und Mose sprach: Sechshunderttausend Mann zu Fuß ist das Volk, in dessen Mitte ich bin, und du sprichst: Fleisch will ich ihnen geben, daß sie einen ganzen Monat essen! ");
INSERT INTO deuelo_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Soll Klein-und Rindvieh für sie geschlachtet werden, daß es für sie ausreiche? Oder sollen alle Fische des Meeres für sie gesammelt werden, daß es für sie ausreiche? ");
INSERT INTO deuelo_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Und Jehova sprach zu Mose: Ist die Hand Jehovas zu kurz? Jetzt sollst du sehen, ob mein Wort dir eintrifft oder nicht. ");
INSERT INTO deuelo_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Da ging Mose hinaus und redete zu dem Volke die Worte Jehovas; und er versammelte siebzig Männer aus den Ältesten des Volkes und stellte sie rings um das Zelt. ");
INSERT INTO deuelo_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Und Jehova kam in der Wolke hernieder und redete zu ihm und nahm von dem Geiste, der auf ihm war, und legte ihn auf die siebzig Männer, die Ältesten. Und es geschah, sobald der Geist auf sie kam, weissagten sie; aber sie fuhren nicht fort. ");
INSERT INTO deuelo_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Und zwei Männer blieben im Lager zurück, der Name des einen war Eldad, und der Name des anderen Medad; und auch auf sie kam der Geist (sie waren nämlich unter den Aufgeschriebenen, waren aber nicht zum Zelte hinausgegangen), und sie weissagten im Lager. ");
INSERT INTO deuelo_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Da lief ein Jüngling hin und berichtete es Mose und sprach: Eldad und Medad weissagen im Lager. ");
INSERT INTO deuelo_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Und Josua, der Sohn Nuns, der Diener Moses, einer von seinen Jünglingen, antwortete und sprach: Mein Herr Mose, wehre ihnen! ");
INSERT INTO deuelo_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Aber Mose sprach zu ihm: Eiferst du für mich? Möchte doch das ganze Volk Jehovas Propheten sein, daß Jehova seinen Geist auf sie legte! ");
INSERT INTO deuelo_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Und Mose zog sich in das Lager zurück, er und die Ältesten Israels. ");
INSERT INTO deuelo_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Und ein Wind fuhr von Jehova aus und trieb Wachteln vom Meere herbei und warf sie auf das Lager, bei einer Tagereise hier und bei einer Tagereise dort, rings um das Lager, und bei zwei Ellen hoch über der Oberfläche der Erde. ");
INSERT INTO deuelo_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Und das Volk machte sich auf, denselben ganzen Tag und die ganze Nacht und den ganzen folgenden Tag, und sie sammelten die Wachteln; wer wenig gesammelt, hatte zehn Homer gesammelt; und sie breiteten sich dieselben aus rings um das Lager her. ");
INSERT INTO deuelo_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Das Fleisch war noch zwischen ihren Zähnen, es war noch nicht zerkaut, da entbrannte der Zorn Jehovas wider das Volk, und Jehova richtete unter dem Volke eine sehr große Niederlage an. ");
INSERT INTO deuelo_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Und man gab selbigem Orte den Namen Kibroth-Hattaawa, weil man daselbst das Volk begrub, das lüstern gewesen war. ");
INSERT INTO deuelo_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Von Kibroth-Hattaawa brach das Volk auf nach Hazeroth; und sie waren zu Hazeroth. ");
INSERT INTO deuelo_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Und Mirjam und Aaron redeten wider Mose wegen des kuschitischen Weibes, das er genommen hatte; denn er hatte eine kuschitisches Weib genommen. ");
INSERT INTO deuelo_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Und sie sprachen: Hat Jehova nur mit Mose allein geredet? Hat er nicht auch mit uns geredet? Und Jehova hörte es. ");
INSERT INTO deuelo_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Der Mann Mose aber war sehr sanftmütig, mehr als alle Menschen, die auf dem Erdboden waren. ");
INSERT INTO deuelo_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Da sprach Jehova plötzlich zu Mose und zu Aaron und zu Mirjam: Gehet hinaus, ihr drei, zum Zelte der Zusammenkunft! Und sie gingen hinaus, sie drei. ");
INSERT INTO deuelo_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Und Jehova kam in der Wolkensäule hernieder und stand an dem Eingang des Zeltes; und er rief Aaron und Mirjam, und die beiden traten hinaus. ");
INSERT INTO deuelo_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Und er sprach: Höret denn meine Worte! Wenn ein Prophet unter euch ist, dem will ich, Jehova, in einem Gesicht mich kundtun, in einem Traume will ich mit ihm reden. ");
INSERT INTO deuelo_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Nicht also mein Knecht Mose. Er ist treu in meinem ganzen Hause; ");
INSERT INTO deuelo_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","mit ihm rede ich von Mund zu Mund, und deutlich und nicht in Rätseln, und das Bild Jehovas schaut er. Und warum habt ihr euch nicht gefürchtet, wider meinen Knecht, wider Mose, zu reden? ");
INSERT INTO deuelo_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Und der Zorn Jehovas entbrannte wider sie, und er ging weg. ");
INSERT INTO deuelo_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Und die Wolke wich von dem Zelte, und siehe, Mirjam war aussätzig wie Schnee; und Aaron wandte sich zu Mirjam, und siehe, sie war aussätzig. ");
INSERT INTO deuelo_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Da sprach Aaron zu Mose: Ach, mein Herr! Lege doch nicht die Sünde auf uns, durch welche wir töricht gehandelt und uns versündigt haben! ");
INSERT INTO deuelo_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Möge sie doch nicht sein wie ein totes Kind, dessen Fleisch, wenn es aus seiner Mutter Leibe hervorkommt, zur Hälfte verwest ist! ");
INSERT INTO deuelo_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Und Mose schrie zu Jehova und sprach: O Gott, bitte, heile sie doch! ");
INSERT INTO deuelo_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Und Jehova sprach zu Mose: Hätte ihr Vater ihr etwa ins Angesicht gespieen, sollte sie sich nicht sieben Tage lang schämen? Sie soll sieben Tage außerhalb des Lagers eingeschlossen werden, und danach mag sie wieder aufgenommen werden. ");
INSERT INTO deuelo_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Und Mirjam wurde sieben Tage außerhalb des Lagers eingeschlossen; und das Volk brach nicht auf, bis Mirjam wieder aufgenommen war. ");
INSERT INTO deuelo_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Danach aber brach das Volk von Hazeroth auf; und sie lagerten sich in der Wüste Paran. ");
INSERT INTO deuelo_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","Sende dir Männer aus, daß sie das Land Kanaan auskundschaften, welches ich den Kindern Israel gebe; je einen Mann für den Stamm seiner Väter sollt ihr aussenden, jeder ein Fürst unter ihnen. ");
INSERT INTO deuelo_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Und Mose sandte sie aus der Wüste Paran nach dem Befehl Jehovas, allesamt Männer, welche Häupter der Kinder Israel waren. ");
INSERT INTO deuelo_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Und dies sind ihre Namen: für den Stamm Ruben, Schammua, der Sohn Sakkurs; ");
INSERT INTO deuelo_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","für den Stamm Simeon, Schaphat, der Sohn Choris; ");
INSERT INTO deuelo_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","für den Stamm Juda, Kaleb, der Sohn Jephunnes; ");
INSERT INTO deuelo_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","für den Stamm Issaschar, Jigal, der Sohn Josephs; ");
INSERT INTO deuelo_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","für den Stamm Ephraim, Hosea, der Sohn Nuns; ");
INSERT INTO deuelo_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","für den Stamm Benjamin, Palti, der Sohn Raphus; ");
INSERT INTO deuelo_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","für den Stamm Sebulon, Gaddiel, der Sohn Sodis; ");
INSERT INTO deuelo_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","für den Stamm Joseph, für den Stamm Manasse, Gaddi, der Sohn Susis; ");
INSERT INTO deuelo_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","für den Stamm Dan, Ammiel, der Sohn Gemallis; ");
INSERT INTO deuelo_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","für den Stamm Aser, Sethur, der Sohn Michaels; ");
INSERT INTO deuelo_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","für den Stamm Naphtali, Nachbi, der Sohn Waphsis; ");
INSERT INTO deuelo_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","für den Stamm Gad, Geuel, der Sohn Makis. ");
INSERT INTO deuelo_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Das sind die Namen der Männer, welche Mose aussandte, um das Land auszukundschaften. Und Mose nannte Hosea, den Sohn Nuns, Josua. ");
INSERT INTO deuelo_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Und Mose sandte sie, um das Land Kanaan auszukundschaften, und sprach zu ihnen: Ziehet hier hinauf an der Südseite, und steiget auf das Gebirge, ");
INSERT INTO deuelo_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","und besehet das Land, wie es ist; und das Volk, das darin wohnt, ob es stark oder schwach, ob es gering oder zahlreich ist; ");
INSERT INTO deuelo_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","und wie das Land ist, in welchem es wohnt, ob es gut oder schlecht ist; und wie die Städte sind, in denen es wohnt, ob es in Lagern oder in Festungen wohnt; ");
INSERT INTO deuelo_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","und wie das Land ist, ob es fett oder mager ist, ob Bäume darin sind oder nicht. Und fasset Mut und nehmet von der Frucht des Landes. Die Tage aber waren die Tage der ersten Trauben. ");
INSERT INTO deuelo_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Und sie zogen hinauf und kundschafteten das Land aus, von der Wüste Zin bis Rechob, wenn man nach Hamath geht. ");
INSERT INTO deuelo_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Und sie zogen an der Südseite hinauf und kamen bis Hebron, und daselbst waren Achiman, Scheschai und Talmai, die Kinder Enaks. Hebron aber war sieben Jahre vor Zoan in Ägypten erbaut worden. ");
INSERT INTO deuelo_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Und sie kamen bis in das Tal Eskol und schnitten daselbst eine Rebe mit einer Weintraube ab und trugen sie zu zweien an einer Stange, auch Granatäpfel und Feigen. ");
INSERT INTO deuelo_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Jenen Ort nannte man Tal Eskol wegen der Traube, welche die Kinder Israel daselbst abgeschnitten hatten. ");
INSERT INTO deuelo_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Und sie kehrten nach Verlauf von vierzig Tagen vom Auskundschaften des Landes zurück. ");
INSERT INTO deuelo_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Und sie gingen und kamen zu Mose und zu Aaron und zu der ganzen Gemeinde der Kinder Israel in die Wüste Paran nach Kades; und sie brachten ihnen und der ganzen Gemeinde Bescheid und zeigten ihnen die Frucht des Landes. ");
INSERT INTO deuelo_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Und sie erzählten ihm und sprachen: Wir sind in das Land gekommen, wohin du uns gesandt hast; und wirklich, es fließt von Milch und Honig, und dies ist seine Frucht. ");
INSERT INTO deuelo_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Nur daß das Volk stark ist, welches in dem Lande wohnt, und die Städte befestigt, sehr groß; und auch die Kinder Enaks haben wir dort gesehen. ");
INSERT INTO deuelo_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amalek wohnt im Lande des Südens, und die Hethiter und die Jebusiter und die Amoriter wohnen auf dem Gebirge, und die Kanaaniter wohnen am Meere und an der Seite des Jordan. ");
INSERT INTO deuelo_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Und Kaleb beschwichtigte das Volk gegen Mose und sprach: Laßt uns nur hinaufziehen und es in Besitz nehmen, denn wir werden es gewißlich überwältigen. ");
INSERT INTO deuelo_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Aber die Männer, die mit ihm hinaufgezogen waren, sprachen: Wir vermögen nicht gegen das Volk hinaufzuziehen, denn es ist stärker als wir. ");
INSERT INTO deuelo_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Und sie brachten unter die Kinder Israel ein böses Gerücht über das Land aus, das sie ausgekundschaftet hatten, und sprachen: Das Land, welches wir durchzogen haben, um es auszukundschaften, ist ein Land, das seine Bewohner frißt; und alles Volk, das wir darin gesehen haben, sind Leute von hohem Wuchse; ");
INSERT INTO deuelo_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","auch haben wir dort die Riesen gesehen, die Kinder Enaks, von den Riesen; und wir waren in unseren Augen wie Heuschrecken, und also waren wir auch in ihren Augen. ");
INSERT INTO deuelo_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Da erhob die ganze Gemeinde ihre Stimme und schrie, und das Volk weinte in selbiger Nacht. ");
INSERT INTO deuelo_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Und alle Kinder Israel murrten wider Mose und wider Aaron, und die ganze Gemeinde sprach zu ihnen: O wären wir doch im Lande Ägypten gestorben, oder wären wir doch in dieser Wüste gestorben! ");
INSERT INTO deuelo_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Und warum bringt uns Jehova in dieses Land, daß wir durchs Schwert fallen und unsere Weiber und unsere Kindlein zur Beute werden? Wäre es nicht besser für uns, nach Ägypten zurückzukehren? ");
INSERT INTO deuelo_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Und sie sprachen einer zum anderen: Laßt uns ein Haupt über uns setzen und nach Ägypten zurückkehren! - ");
INSERT INTO deuelo_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Da fielen Mose und Aaron auf ihr Angesicht vor der ganzen Versammlung der Gemeinde der Kinder Israel. ");
INSERT INTO deuelo_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Und Josua, der Sohn Nuns, und Kaleb, der Sohn Jephunnes, von denen, die das Land ausgekundschaftet hatten, zerrissen ihre Kleider, ");
INSERT INTO deuelo_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","und sie sprachen zu der ganzen Gemeinde der Kinder Israel und sagten: Das Land, das wir durchzogen haben, um es auszukundschaften, das Land ist sehr, sehr gut. ");
INSERT INTO deuelo_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Wenn Jehova Gefallen an uns hat, so wird er uns in dieses Land bringen und es uns geben, ein Land, das von Milch und Honig fließt. ");
INSERT INTO deuelo_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Nur empöret euch nicht wider Jehova; und fürchtet ja nicht das Volk des Landes, denn unser Brot werden sie sein. Ihr Schirm ist von ihnen gewichen, und Jehova ist mit uns; fürchtet sie nicht! ");
INSERT INTO deuelo_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Und die ganze Gemeinde sagte, daß man sie steinigen solle. Da erschien die Herrlichkeit Jehovas an dem Zelte der Zusammenkunft allen Kindern Israel. ");
INSERT INTO deuelo_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Und Jehova sprach zu Mose: Wie lange will mich dieses Volk verachten, und wie lange wollen sie mir nicht glauben bei all den Zeichen, die ich in ihrer Mitte getan habe? ");
INSERT INTO deuelo_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Ich will es mit der Pest schlagen und es vertilgen; und ich will dich zu einer Nation machen, größer und stärker als sie. ");
INSERT INTO deuelo_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Und Mose sprach zu Jehova: So werden die Ägypter es hören; denn durch deine Macht hast du dieses Volk aus ihrer Mitte heraufgeführt; ");
INSERT INTO deuelo_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","und man wird es den Bewohnern dieses Landes sagen, welche gehört haben, daß du, Jehova, in der Mitte dieses Volkes bist, daß du, Jehova, Auge in Auge dich sehen läßt, und daß deine Wolke über ihnen steht, und du in einer Wolkensäule vor ihnen hergehst bei Tage und in einer Feuersäule bei Nacht. ");
INSERT INTO deuelo_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Und tötest du dieses Volk wie einen Mann, so werden die Nationen, die deinen Ruf gehört haben, sprechen und sagen: ");
INSERT INTO deuelo_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Weil Jehova nicht vermochte, dieses Volk in das Land zu bringen, das er ihnen zugeschworen hatte, so hat er sie in der Wüste hingeschlachtet. ");
INSERT INTO deuelo_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Und nun möge doch die Macht des Herrn sich groß erweisen, so wie du geredet hast, indem du sprachst: ");
INSERT INTO deuelo_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","Jehova ist langsam zum Zorn und groß an Güte, der Ungerechtigkeit und Übertretung vergibt, aber keineswegs hält er für schuldlos den Schuldigen, der die Ungerechtigkeit der Väter heimsucht an den Kindern am dritten und am vierten Gliede. ");
INSERT INTO deuelo_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Vergib doch die Ungerechtigkeit dieses Volkes nach der Größe deiner Güte, und so wie du diesem Volke verziehen hast von Ägypten an bis hierher! ");
INSERT INTO deuelo_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Und Jehova sprach: Ich habe vergeben nach deinem Worte. ");
INSERT INTO deuelo_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Doch aber, so wahr ich lebe, soll von der Herrlichkeit Jehovas erfüllt werden die ganze Erde; ");
INSERT INTO deuelo_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","denn alle die Männer, die meine Herrlichkeit und meine Zeichen gesehen haben, welche ich in Ägypten und in der Wüste getan, und mich nun zehnmal versucht und nicht gehört haben auf meine Stimme- ");
INSERT INTO deuelo_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","wenn sie das Land sehen werden, das ich ihren Vätern zugeschworen habe! Ja, alle, die mich verachtet haben, sollen es nicht sehen. ");
INSERT INTO deuelo_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Aber meinen Knecht Kaleb, weil ein anderer Geist in ihm gewesen und er mir völlig nachgefolgt ist, ihn werde ich in das Land bringen, in welches er gekommen ist; und sein Same soll es besitzen. ");
INSERT INTO deuelo_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Die Amalekiter aber und die Kanaaniter wohnen in der Niederung; morgen wendet euch und brechet auf nach der Wüste, des Weges zum Schilfmeer. ");
INSERT INTO deuelo_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Und Jehova redete zu Mose und zu Aaron und sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","Wie lange soll es mit dieser bösen Gemeinde währen, daß sie wider mich murrt? Das Murren der Kinder Israel, das sie wider mich murren, habe ich gehört. ");
INSERT INTO deuelo_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Sprich zu ihnen: So wahr ich lebe, spricht Jehova, wenn ich euch nicht also tun werde, wie ihr vor meinen Ohren geredet habt! ");
INSERT INTO deuelo_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","In dieser Wüste sollen eure Leichname fallen, ja, alle eure Gemusterten nach eurer ganzen Zahl, von zwanzig Jahren und darüber, die ihr wider mich gemurrt habt. ");
INSERT INTO deuelo_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Wenn ihr in das Land kommen werdet, darinnen euch wohnen zu lassen ich meine Hand erhoben habe, außer Kaleb, dem Sohne Jephunnes, und Josua, dem Sohne Nuns! ");
INSERT INTO deuelo_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Und eure Kindlein, von denen ihr gesagt habt: Sie werden zur Beute werden! die will ich hineinbringen, und sie sollen das Land kennen lernen, das ihr verschmäht habt. ");
INSERT INTO deuelo_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Ihr aber, eure Leichname sollen in dieser Wüste fallen; ");
INSERT INTO deuelo_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","und eure Kinder sollen vierzig Jahre lang in der Wüste weiden und eure Hurereien tragen, bis eure Leichname in der Wüste aufgerieben sind. ");
INSERT INTO deuelo_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Nach der Zahl der Tage, die ihr das Land ausgekundschaftet habt, vierzig Tage, je einen Tag für ein Jahr, sollt ihr vierzig Jahre lang eure Ungerechtigkeiten tragen, und ihr sollt erfahren, was es ist, wenn ich mich abwende! ");
INSERT INTO deuelo_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Ich, Jehova, habe es geredet; wenn ich dies nicht tun werde an dieser ganzen bösen Gemeinde, die sich wider mich zusammengerottet hat! In dieser Wüste sollen sie aufgerieben werden, und daselbst sollen sie sterben! ");
INSERT INTO deuelo_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Und die Männer, welche Mose ausgesandt hatte, um das Land auszukundschaften, und die zurückkehrten und die ganze Gemeinde wider ihn murren machten, indem sie ein böses Gerücht über das Land ausbrachten, ");
INSERT INTO deuelo_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","jene Männer, die ein böses Gerücht über das Land ausgebracht hatten, starben durch eine Plage vor Jehova. ");
INSERT INTO deuelo_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Aber Josua, der Sohn Nuns, und Kaleb, der Sohn Jephunnes, blieben am Leben von jenen Männern, welche gegangen waren, das Land auszukundschaften. ");
INSERT INTO deuelo_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Und als Mose jene Worte zu allen Kindern Israel redete, da trauerte das Volk sehr. ");
INSERT INTO deuelo_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Und sie machten sich des Morgens früh auf, um auf den Gipfel des Gebirges hinaufzuziehen, und sprachen: Hier sind wir und wollen an den Ort hinaufziehen, von welchem Jehova geredet hat; denn wir haben gesündigt. ");
INSERT INTO deuelo_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Aber Mose sprach: Warum übertretet ihr doch den Befehl Jehovas? Es wird ja nicht gelingen! ");
INSERT INTO deuelo_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Ziehet nicht hinauf, denn Jehova ist nicht in eurer Mitte, daß ihr nicht vor euren Feinden geschlagen werdet, ");
INSERT INTO deuelo_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","denn die Amalekiter und die Kanaaniter sind dort vor euch, und ihr werdet durchs Schwert fallen. Weil ihr euch von der Nachfolge Jehovas abgewandt habt, wird Jehova nicht mit euch sein. ");
INSERT INTO deuelo_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Doch sie vermaßen sich, auf den Gipfel des Gebirges hinaufzuziehen; aber die Lade des Bundes Jehovas und Mose wichen nicht aus der Mitte des Lagers. ");
INSERT INTO deuelo_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Da kamen die Amalekiter und die Kanaaniter, die auf jenem Gebirge wohnten, herab und schlugen und zersprengten sie bis Horma. ");
INSERT INTO deuelo_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Rede zu den Kindern Israel und sprich zu ihnen: Wenn ihr in das Land eurer Wohnsitze kommet, das ich euch geben werde, ");
INSERT INTO deuelo_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","und ihr dem Jehova ein Feueropfer opfert, ein Brandopfer oder ein Schlachtopfer, um ein Gelübde zu erfüllen, oder eine freiwillige Gabe, oder an euren Festen, um Jehova einen lieblichen Geruch zu bereiten, vom Rind-oder vom Kleinvieh: ");
INSERT INTO deuelo_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","so soll der, welcher Jehova seine Opfergabe darbringt, als Speisopfer darbringen ein Zehntel Feinmehl, gemengt mit einem viertel Hin Öl; ");
INSERT INTO deuelo_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Und als Trankopfer sollst du ein viertel Hin Wein opfern zu dem Brandopfer oder zu dem Schlachtopfer, bei jedem Schafe. ");
INSERT INTO deuelo_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Oder bei einem Widder sollst du als Speisopfer zwei Zehntel Feinmehl opfern, gemengt mit einem drittel Hin Öl; ");
INSERT INTO deuelo_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","und als Trankopfer sollst du ein drittel Hin Wein darbringen: ein lieblicher Geruch dem Jehova. ");
INSERT INTO deuelo_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Und wenn du ein junges Rind als Brandopfer oder als Schlachtopfer opferst, um ein Gelübde zu erfüllen, oder als Friedensopfer für Jehova, ");
INSERT INTO deuelo_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","so soll man zu dem jungen Rinde als Speisopfer darbringen drei Zehntel Feinmehl, gemengt mit einem halben Hin Öl; ");
INSERT INTO deuelo_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","und als Trankopfer sollst du ein halbes Hin Wein darbringen: ein Feueropfer lieblichen Geruchs dem Jehova. ");
INSERT INTO deuelo_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Also soll getan werden bei jedem Rinde oder bei jedem Widder oder bei jedem Schafe oder bei jeder Ziege; ");
INSERT INTO deuelo_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","nach der Zahl, die ihr opfert, sollt ihr also tun bei einem jeden nach ihrer Zahl. ");
INSERT INTO deuelo_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Jeder Eingeborene soll dieses also tun, wenn er ein Feueropfer lieblichen Geruchs dem Jehova darbringt. ");
INSERT INTO deuelo_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Und wenn ein Fremdling bei euch weilt, oder wer in eurer Mitte ist bei euren Geschlechtern, und er opfert dem Jehova ein Feueropfer lieblichen Geruchs, so soll er ebenso tun, wie ihr tut. - ");
INSERT INTO deuelo_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Was die Versammlung betrifft, so soll einerlei Satzung für euch sein und für den Fremdling, der bei euch weilt; eine ewige Satzung bei euren Geschlechtern: wie ihr, so soll der Fremdling sein vor Jehova. ");
INSERT INTO deuelo_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Einerlei Gesetz und einerlei Recht soll für euch sein und für den Fremdling, der bei euch weilt. ");
INSERT INTO deuelo_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Rede zu den Kindern Israel und sprich zu ihnen: Wenn ihr in das Land kommet, wohin ich euch bringen werde, ");
INSERT INTO deuelo_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","so soll es geschehen, wenn ihr von dem Brote des Landes esset, so sollt ihr Jehova ein Hebopfer heben: ");
INSERT INTO deuelo_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","als Erstling eures Schrotmehls sollt ihr einen Kuchen als Hebopfer heben; ");
INSERT INTO deuelo_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Wie das Hebopfer der Tenne, also sollt ihr dieses heben. Von dem Erstling eures Schrotmehls sollt ihr Jehova ein Hebopfer geben, bei euren Geschlechtern. ");
INSERT INTO deuelo_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Und wenn ihr aus Versehen sündiget und nicht tut alle diese Gebote, die Jehova zu Mose geredet hat, ");
INSERT INTO deuelo_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","alles, was Jehova euch durch Mose geboten hat, von dem Tage an, da Jehova Gebote gab, und fernerhin bei euren Geschlechtern, ");
INSERT INTO deuelo_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","so soll es geschehen, wenn es vor den Augen der Gemeinde verborgen, aus Versehen geschehen ist, so soll die ganze Gemeinde einen jungen Farren als Brandopfer opfern zum lieblichen Geruch dem Jehova, nebst seinem Speisopfer und seinem Trankopfer, nach der Vorschrift, und einen Ziegenbock zum Sündopfer. ");
INSERT INTO deuelo_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Und der Priester soll Sühnung tun für die ganze Gemeinde der Kinder Israel, und es wird ihnen vergeben werden; denn es war eine Sünde aus Versehen, und sie haben ihre Opfergabe, ein Feueropfer dem Jehova, und ihr Sündopfer vor Jehova gebracht wegen ihrer Sünde aus Versehen. ");
INSERT INTO deuelo_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Und es wird der ganzen Gemeinde der Kinder Israel vergeben werden und dem Fremdling, der in ihrer Mitte weilt; denn von dem ganzen Volke ist es geschehen aus Versehen. ");
INSERT INTO deuelo_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Und wenn eine einzelne Seele aus Versehen sündigt, so soll sie eine einjährige Ziege zum Sündopfer darbringen. ");
INSERT INTO deuelo_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Und der Priester soll Sühnung tun für die Seele, die ein Versehen begangen hat durch eine Sünde aus Versehen vor Jehova, um Sühnung für sie zu tun; und es wird ihr vergeben werden. ");
INSERT INTO deuelo_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Für den Eingeborenen unter den Kindern Israel und für den Fremdling, der in ihrer Mitte weilt, sollt ihr ein Gesetz haben, für den, der aus Versehen etwas tut. ");
INSERT INTO deuelo_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Aber die Seele, welche mit erhobener Hand etwas tut, von den Eingeborenen und von den Fremdlingen, die schmäht Jehova; und selbige Seele soll ausgerottet werden aus der Mitte ihres Volkes, ");
INSERT INTO deuelo_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","denn das Wort Jehovas hat sie verachtet und sein Gebot gebrochen; selbige Seele soll gewißlich ausgerottet werden: ihre Ungerechtigkeit ist auf ihr. ");
INSERT INTO deuelo_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Und als die Kinder Israel in der Wüste waren, da fanden sie einen Mann, der am Sabbathtage Holz auflas. ");
INSERT INTO deuelo_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Und die ihn, Holz auflesend, gefunden hatten, brachten ihn zu Mose und zu Aaron und zu der ganzen Gemeinde. ");
INSERT INTO deuelo_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Und sie legten ihn in Gewahrsam, denn es war nicht genau bestimmt, was ihm getan werden sollte. ");
INSERT INTO deuelo_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Da sprach Jehova zu Mose: Der Mann soll gewißlich getötet werden; die ganze Gemeinde soll ihn außerhalb des Lagers steinigen. ");
INSERT INTO deuelo_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Da führte ihn die ganze Gemeinde vor das Lager hinaus, und sie steinigten ihn, daß er starb, so wie Jehova dem Mose geboten hatte. ");
INSERT INTO deuelo_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Und Jehova sprach zu Mose und sagte: ");
INSERT INTO deuelo_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Rede zu den Kindern Israel und sprich zu ihnen, daß sie sich eine Quaste an den Zipfeln ihrer Oberkleider machen, bei ihren Geschlechtern, und daß sie an die Quaste des Zipfels eine Schnur von blauem Purpur setzen; ");
INSERT INTO deuelo_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","und es soll euch zu einer Quaste sein, daß ihr, wenn ihr sie ansehet, aller Gebote Jehovas gedenket und sie tuet, und daß ihr nicht umherspähet eurem Herzen und euren Augen nach, denen ihr nachhuret; ");
INSERT INTO deuelo_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","damit ihr aller meiner Gebote gedenket und sie tuet, und heilig seiet eurem Gott. ");
INSERT INTO deuelo_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ich bin Jehova, euer Gott, der ich euch aus dem Lande Ägypten herausgeführt habe, um euer Gott zu sein; ich bin Jehova, euer Gott. ");
INSERT INTO deuelo_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Und Korah, der Sohn Jizhars, des Sohnes Kehaths, des Sohnes Levis, unternahm es, und mit ihm Dathan und Abiram, die Söhne Eliabs, und On, der Sohn Pelets, die Söhne Rubens, ");
INSERT INTO deuelo_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","und sie standen auf gegen Mose, mit zweihundertfünfzig Männern von den Kindern Israel, Fürsten der Gemeinde, Berufene der Versammlung, Männer von Namen. ");
INSERT INTO deuelo_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Und sie versammelten sich wider Mose und wider Aaron und sprachen zu ihnen: Laßt es genug sein! Denn die ganze Gemeinde, sie allesamt, sind heilig, und Jehova ist in ihrer Mitte! Und warum erhebet ihr euch über die Versammlung Jehovas? ");
INSERT INTO deuelo_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Als Mose es hörte, fiel er auf sein Angesicht. ");
INSERT INTO deuelo_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Und er redete zu Korah und zu seiner ganzen Rotte und sprach: Morgen, da wird Jehova kundtun, wer sein ist und wer heilig ist, daß er ihn zu sich nahen lasse; und wen er erwählt, den wird er zu sich nahen lassen. ");
INSERT INTO deuelo_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Dieses tut: Nehmet euch Räucherpfannen, Korah und seine ganze Rotte, ");
INSERT INTO deuelo_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","und morgen tut Feuer darein und leget Räucherwerk darauf vor Jehova; und es soll geschehen, der Mann, den Jehova erwählen wird, der sei der Heilige. Laßt es genug sein, ihr Söhne Levis! ");
INSERT INTO deuelo_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Und Mose sprach zu Korah: Höret doch, ihr Söhne Levis! ");
INSERT INTO deuelo_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Ist es euch zu wenig, daß der Gott Israels euch aus der Gemeinde Israel ausgesondert hat, um euch zu sich nahen zu lassen, damit ihr den Dienst der Wohnung Jehovas verrichtet, und vor der Gemeinde stehet, um sie zu bedienen, ");
INSERT INTO deuelo_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","daß er dich und alle deine Brüder, die Söhne Levis, mit dir hat herzunahen lassen? Und ihr trachtet auch nach dem Priestertum! ");
INSERT INTO deuelo_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Darum rottet ihr euch zusammen, du und deine ganze Rotte, wider Jehova; denn Aaron, was ist er, daß ihr wider ihn murret? ");
INSERT INTO deuelo_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Und Mose sandte hin, um Dathan und Abiram, die Söhne Eliabs, zu rufen. Aber sie sprachen: Wir kommen nicht hinauf! ");
INSERT INTO deuelo_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Ist es zu wenig, daß du uns aus einem Lande, das von Milch und Honig fließt, heraufgeführt hast, um uns in der Wüste sterben zu lassen, daß du dich auch gar zum Herrscher über uns aufwirfst? ");
INSERT INTO deuelo_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Du hast uns keineswegs in ein Land gebracht, das von Milch und Honig fließt, noch uns Äcker und Weinberge als Erbteil gegeben! Willst du diesen Leuten die Augen ausstechen? Wir kommen nicht hinauf! ");
INSERT INTO deuelo_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Da ergrimmte Mose sehr und sprach zu Jehova: Wende dich nicht zu ihrer Opfergabe! Nicht einen Esel habe ich von ihnen genommen, und keinem einzigen unter ihnen ein Leid getan. ");
INSERT INTO deuelo_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Und Mose sprach zu Korah: Du und deine ganze Rotte, ihr sollt morgen vor Jehova erscheinen, du und sie und Aaron. ");
INSERT INTO deuelo_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Und nehmet ein jeder seine Räucherpfanne und leget Räucherwerk darauf, und bringet ein jeder seine Räucherpfanne dar vor Jehova, zweihundertfünfzig Räucherpfannen; und du und Aaron, ein jeder seine Räucherpfanne. ");
INSERT INTO deuelo_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Und sie nahmen ein jeder seine Räucherpfanne und taten Feuer darauf und legten Räucherwerk darauf; und sie traten hin an den Eingang des Zeltes der Zusammenkunft, auch Mose und Aaron. ");
INSERT INTO deuelo_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Und Korah versammelte wider sie die ganze Gemeinde an den Eingang des Zeltes der Zusammenkunft. Da erschien die Herrlichkeit Jehovas vor der ganzen Gemeinde. ");
INSERT INTO deuelo_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Und Jehova redete zu Mose und zu Aaron und sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","Sondert euch ab aus der Mitte dieser Gemeinde, und ich will sie vernichten in einem Augenblick! ");
INSERT INTO deuelo_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Und sie fielen auf ihr Angesicht und sprachen: Gott, du Gott der Geister alles Fleisches! Der eine Mann sündigt, und du solltest über die ganze Gemeinde zürnen? ");
INSERT INTO deuelo_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","Rede zu der Gemeinde und sprich: Hebet euch ringsum weg von der Wohnung Korahs, Dathans und Abirams. ");
INSERT INTO deuelo_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Da stand Mose auf und ging zu Dathan und Abiram, und ihm nach gingen die Ältesten Israels. ");
INSERT INTO deuelo_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Und er redete zu der Gemeinde und sprach: Weichet doch von den Zelten dieser gesetzlosen Männer und rühret nichts an, was ihnen gehört, daß ihr nicht weggerafft werdet in allen ihren Sünden! ");
INSERT INTO deuelo_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Und sie hoben sich ringsum weg von der Wohnung Korahs, Dathans und Abirams. Und Dathan und Abiram traten heraus und standen am Eingang ihrer Zelte mit ihren Weibern und ihren Söhnen und ihren Kindlein. ");
INSERT INTO deuelo_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Und Mose sprach: Daran sollt ihr erkennen, daß Jehova mich gesandt hat, alle diese Taten zu tun, daß ich nicht aus meinem Herzen gehandelt habe: ");
INSERT INTO deuelo_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Wenn diese sterben, wie alle Menschen sterben, und mit der Heimsuchung aller Menschen heimgesucht werden, so hat Jehova mich nicht gesandt; ");
INSERT INTO deuelo_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","wenn aber Jehova ein Neues schafft und der Erdboden seinen Mund auftut und sie verschlingt mit allem was ihnen angehört, und sie lebendig in den Scheol hinabfahren, so werdet ihr erkennen, daß diese Männer Jehova verachtet haben. - ");
INSERT INTO deuelo_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Und es geschah, als er alle diese Worte ausgeredet hatte, da spaltete sich der Erdboden, der unter ihnen war, ");
INSERT INTO deuelo_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","und die Erde tat ihren Mund auf und verschlang sie und ihre Familien und alle Menschen, die Korah angehörten, und die ganze Habe. ");
INSERT INTO deuelo_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Und sie fuhren, sie und alles, was ihnen angehörte, lebendig in den Scheol hinab; und die Erde bedeckte sie, und sie wurden mitten aus der Versammlung vertilgt. ");
INSERT INTO deuelo_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Und ganz Israel, das rings um sie her war, floh bei ihrem Geschrei; denn sie sprachen: Daß die Erde uns nicht verschlinge! ");
INSERT INTO deuelo_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Und Feuer ging aus von Jehova und fraß die zweihundertfünfzig Männer, die das Räucherwerk dargebracht hatten. ");
INSERT INTO deuelo_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","Sprich zu Eleasar, dem Sohne Aarons, dem Priester, daß er die Räucherpfannen aus dem Brande herausnehme; und streue das Feuer hinweg, denn sie sind heilig. ");
INSERT INTO deuelo_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Die Räucherpfannen dieser Männer, welche wider ihre Seele gesündigt haben, man mache daraus breitgeschlagene Bleche zum Überzug für den Altar; denn sie haben sie vor Jehova dargebracht, und so sind sie heilig; und sie sollen den Kindern Israel zum Zeichen sein. ");
INSERT INTO deuelo_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Und Eleasar, der Priester, nahm die ehernen Räucherpfannen, welche die Verbrannten dargebracht hatten, und man schlug sie breit zum Überzug für den Altar, ");
INSERT INTO deuelo_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","als ein Gedächtnis für die Kinder Israel, auf daß kein Fremder, der nicht vom Samen Aarons ist, herzunahe, um Räucherwerk vor Jehova zu räuchern, und es ihm nicht ergehe wie Korah und seiner Rotte, so wie Jehova durch Mose zu ihm geredet hatte. ");
INSERT INTO deuelo_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Und die ganze Gemeinde der Kinder Israel murrte am anderen Morgen wider Mose und wider Aaron und sprach: Ihr habt das Volk Jehovas getötet! ");
INSERT INTO deuelo_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Und es geschah, als die Gemeinde sich wider Mose und wider Aaron versammelte, da wandten sie sich zu dem Zelte der Zusammenkunft, und siehe, die Wolke bedeckte es, und die Herrlichkeit Jehovas erschien. ");
INSERT INTO deuelo_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Da gingen Mose und Aaron vor das Zelt der Zusammenkunft. ");
INSERT INTO deuelo_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","Hebet euch weg aus der Mitte dieser Gemeinde, und ich will sie vernichten in einem Augenblick! Da fielen sie auf ihr Angesicht. ");
INSERT INTO deuelo_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Und Mose sprach zu Aaron: Nimm die Räucherpfanne und tue Feuer vom Altar darauf und lege Räucherwerk auf, und bringe es eilends zu der Gemeinde und tue Sühnung für sie; denn der Zorn ist ausgegangen von Jehova, die Plage hat begonnen. ");
INSERT INTO deuelo_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Und Aaron nahm die Räucherpfanne, so wie Mose geredet hatte, und lief mitten unter die Versammlung, und siehe, die Plage hatte unter dem Volke begonnen; und er legte das Räucherwerk auf und tat Sühnung für das Volk. ");
INSERT INTO deuelo_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Und er stand zwischen den Toten und den Lebendigen, und der Plage ward gewehrt. ");
INSERT INTO deuelo_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Und es waren derer, die an der Plage starben, vierzehntausend siebenhundert, außer denen, die Korahs wegen gestorben waren. ");
INSERT INTO deuelo_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Und Aaron kam wieder zu Mose an den Eingang des Zeltes der Zusammenkunft, als der Plage gewehrt war. ");
INSERT INTO deuelo_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","Rede zu den Kindern Israel und nimm von ihnen je einen Stab für ein Vaterhaus, von allen ihren Fürsten, nach ihren Vaterhäusern, zwölf Stäbe; du sollst den Namen eines jeden auf seinen Stab schreiben. ");
INSERT INTO deuelo_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Und den Namen Aarons sollst du auf den Stab Levis schreiben; denn ein Stab soll für jedes Haupt ihrer Vaterhäuser sein. ");
INSERT INTO deuelo_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Und du sollst sie in das Zelt der Zusammenkunft vor das Zeugnis niederlegen, woselbst ich mit euch zusammenkomme. ");
INSERT INTO deuelo_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Und es wird geschehen: der Mann, den ich erwählen werde, dessen Stab wird sprossen; und so werde ich vor mir stillen das Murren der Kinder Israel, das sie wider euch murren. ");
INSERT INTO deuelo_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Und Mose redete zu den Kindern Israel, und alle ihre Fürsten gaben ihm je einen Stab für einen Fürsten, nach ihren Vaterhäusern, zwölf Stäbe; und der Stab Aarons war unter ihren Stäben. ");
INSERT INTO deuelo_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Und Mose legte die Stäbe vor Jehova nieder in das Zelt des Zeugnisses. ");
INSERT INTO deuelo_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Und es geschah des anderen Tages, als Mose in das Zelt des Zeugnisses hineinging, siehe, da hatte der Stab Aarons, vom Hause Levi, gesproßt: er hatte Sprossen getrieben und Blüten gebracht und Mandeln gereift. ");
INSERT INTO deuelo_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Und Mose brachte alle die Stäbe heraus vor Jehova weg zu allen Kindern Israel, und sie sahen sie und nahmen ein jeder seinen Stab. ");
INSERT INTO deuelo_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Und Jehova sprach zu Mose: Bringe den Stab Aarons vor das Zeugnis zurück, um ihn als ein Zeichen für die Widerspenstigen aufzubewahren, so daß du ihrem Murren vor mir ein Ende machest, und sie nicht sterben. ");
INSERT INTO deuelo_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Und Mose tat es; so wie Jehova ihm geboten hatte, also tat er. ");
INSERT INTO deuelo_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Und die Kinder Israel sprachen zu Mose und sagten: Siehe, wir vergehen, wir kommen um, wir alle kommen um! ");
INSERT INTO deuelo_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Jeder, der irgend zur Wohnung Jehovas naht, der stirbt: sollen wir denn allzumal vergehen? ");
INSERT INTO deuelo_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Und Jehova sprach zu Aaron: Du und deine Söhne und das Haus deines Vaters mit dir, ihr sollt die Ungerechtigkeit des Heiligtums tragen; und du und deine Söhne mit dir, ihr sollt die Ungerechtigkeit eures Priestertums tragen. ");
INSERT INTO deuelo_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Und auch deine Brüder, den Stamm Levi, den Stamm deines Vaters, laß mit dir herzunahen, daß sie sich dir anschließen und dir dienen; du aber und deine Söhne mit dir, ihr sollt vor dem Zelte des Zeugnisses dienen. ");
INSERT INTO deuelo_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Und sie sollen deiner Hut warten und der Hut des ganzen Zeltes; nur den Geräten des Heiligtums und dem Altar sollen sie nicht nahen, daß sie nicht sterben, sowohl sie als auch ihr. ");
INSERT INTO deuelo_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Und sie sollen sich dir anschließen und der Hut des Zeltes der Zusammenkunft warten nach allem Dienste des Zeltes; aber kein Fremder soll euch nahen. ");
INSERT INTO deuelo_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Und ihr sollt der Hut des Heiligtums und der Hut des Altars warten, daß kein Zorn mehr über die Kinder Israel komme. ");
INSERT INTO deuelo_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Und ich, siehe, ich habe eure Brüder, die Leviten, aus der Mitte der Kinder Israel genommen; euch als Geschenk sind sie dem Jehova gegeben, um den Dienst des Zeltes der Zusammenkunft zu verrichten. ");
INSERT INTO deuelo_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Du aber und deine Söhne mit dir, ihr sollt eures Priestertums warten, in allem was den Altar betrifft und innerhalb des Vorhangs, und so den Dienst tun; als einen geschenkten Dienst gebe ich euch das Priestertum. Der Fremde aber, der herzunaht, soll getötet werden. ");
INSERT INTO deuelo_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Und Jehova redete zu Aaron: Und ich, siehe, ich habe dir die Hut meiner Hebopfer gegeben; von allen heiligen Dingen der Kinder Israel habe ich sie dir und deinen Söhnen gegeben, als Salbungsteil, als eine ewige Gebühr. ");
INSERT INTO deuelo_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Dies soll dir gehören von dem Hochheiligen, das nicht verbrannt wird: alle ihre Opfergaben nach allen ihren Speisopfern und nach allen ihren Sündopfern und nach allen ihren Schuldopfern, die sie mir darbringen, als ein Hochheiliges soll es dir und deinen Söhnen gehören. ");
INSERT INTO deuelo_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","An hochheiligem Orte sollst du es essen, alles Männliche soll es essen; es soll dir heilig sein. ");
INSERT INTO deuelo_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Und dies soll dir gehören: die Hebopfer ihrer Gaben, nach allen Webopfern der Kinder Israel; dir und deinen Söhnen und deinen Töchtern mit dir habe ich sie gegeben als eine ewige Gebühr; jeder Reine in deinem Hause soll es essen. ");
INSERT INTO deuelo_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Alles Beste vom Öl und alles Beste vom Most und Getreide, ihre Erstlinge, die sie Jehova geben, dir habe ich sie gegeben. ");
INSERT INTO deuelo_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Die ersten Früchte von allem, was in ihrem Lande wächst, die sie Jehova bringen, sollen dir gehören; jeder Reine in deinem Hause soll davon essen. ");
INSERT INTO deuelo_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Alles Verbannte in Israel soll dir gehören. ");
INSERT INTO deuelo_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Alles, was die Mutter bricht, von allem Fleische, das sie Jehova darbringen, an Menschen und an Vieh, soll dir gehören; nur sollst du den Erstgeborenen vom Menschen jedenfalls lösen, und das Erstgeborene vom unreinen Vieh sollst du lösen. ");
INSERT INTO deuelo_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Und die zu Lösenden unter ihnen sollst du von einem Monat an lösen, nach deiner Schätzung, um fünf Sekel Silber, nach dem Sekel des Heiligtums, der zwanzig Gera ist. ");
INSERT INTO deuelo_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Aber das Erstgeborene vom Rinde oder das Erstgeborene von den Schafen oder das Erstgeborene von den Ziegen sollst du nicht lösen; sie sind heilig. Ihr Blut sollst du an den Altar sprengen, und ihr Fett sollst du als Feueropfer räuchern zum lieblichen Geruch für Jehova. ");
INSERT INTO deuelo_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Und ihr Fleisch soll dir gehören; wie die Brust des Webopfers und wie der rechte Schenkel soll es dir gehören. ");
INSERT INTO deuelo_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Alle Hebopfer der heiligen Dinge, welche die Kinder Israel dem Jehova heben, habe ich dir gegeben, und deinen Söhnen und deinen Töchtern mit dir, als eine ewige Gebühr; es ist ein ewiger Salzbund vor Jehova für dich und für deinen Samen mit dir. ");
INSERT INTO deuelo_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Und Jehova sprach zu Aaron: In ihrem Lande sollst du nichts erben und sollst kein Teil in ihrer Mitte haben; ich bin dein Teil und dein Erbe inmitten der Kinder Israel. ");
INSERT INTO deuelo_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Und siehe, den Kindern Levi habe ich allen Zehnten in Israel zum Erbteil gegeben für ihren Dienst, den sie verrichten, den Dienst des Zeltes der Zusammenkunft. ");
INSERT INTO deuelo_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Und die Kinder Israel sollen nicht mehr dem Zelte der Zusammenkunft nahen, um Sünde auf sich zu laden, daß sie sterben; ");
INSERT INTO deuelo_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","die Leviten vielmehr sollen den Dienst des Zeltes der Zusammenkunft verrichten, und sie sollen ihre Ungerechtigkeit tragen: eine ewige Satzung bei euren Geschlechtern. Aber inmitten der Kinder Israel sollen sie kein Erbteil besitzen; ");
INSERT INTO deuelo_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","denn den Zehnten der Kinder Israel, welchen sie Jehova als Hebopfer heben, habe ich den Leviten zum Erbteil gegeben; darum habe ich von ihnen gesagt, daß sie inmitten der Kinder Israel kein Erbteil besitzen sollen. ");
INSERT INTO deuelo_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Und zu den Leviten sollst du reden und zu ihnen sprechen: Wenn ihr von den Kindern Israel den Zehnten nehmet, den ich euch von ihnen als euer Erbteil gegeben habe, so sollt ihr davon ein Hebopfer für Jehova heben, den Zehnten von dem Zehnten. ");
INSERT INTO deuelo_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Und euer Hebopfer wird euch gerechnet werden wie das Getreide von der Tenne und wie die Fülle von der Kelter. ");
INSERT INTO deuelo_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Also sollt auch ihr ein Hebopfer für Jehova heben von allen euren Zehnten, die ihr von den Kindern Israel nehmet, und davon das Hebopfer für Jehova Aaron, dem Priester, geben. ");
INSERT INTO deuelo_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Von allem euch Gegebenen sollt ihr alles Hebopfer Jehovas heben, von allem Besten desselben das Geheiligte davon. ");
INSERT INTO deuelo_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Und du sollst zu ihnen sagen: Wenn ihr das Beste davon hebet, so soll es den Leviten gerechnet werden wie der Ertrag der Tenne und wie der Ertrag der Kelter. ");
INSERT INTO deuelo_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Und ihr möget ihn essen an jedem Orte, ihr und euer Haus; denn das ist euer Lohn für euren Dienst am Zelte der Zusammenkunft. ");
INSERT INTO deuelo_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Und ihr werdet seinethalben keine Sünde auf euch laden, wenn ihr das Beste davon hebet, und werdet die heiligen Dinge der Kinder Israel nicht entweihen und nicht sterben. ");
INSERT INTO deuelo_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Und Jehova redete zu Mose und zu Aaron und sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","Dies ist die Satzung des Gesetzes, das Jehova geboten hat, indem er sprach: Rede zu den Kindern Israel, daß sie dir eine rote junge Kuh bringen, ohne Fehl, an der kein Gebrechen, auf welche kein Joch gekommen ist; ");
INSERT INTO deuelo_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","und ihr sollt sie Eleasar, dem Priester, geben, und er soll sie vor das Lager hinausführen, und man soll sie vor ihm schlachten. ");
INSERT INTO deuelo_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Und Eleasar, der Priester, nehme von ihrem Blute mit seinem Finger und sprenge von ihrem Blute siebenmal gegen die Vorderseite des Zeltes der Zusammenkunft hin. ");
INSERT INTO deuelo_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Und man soll die junge Kuh vor seinen Augen verbrennen: ihre Haut und ihr Fleisch und ihr Blut samt ihrem Mist soll man verbrennen. ");
INSERT INTO deuelo_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Und der Priester soll Cedernholz und Ysop und Karmesin nehmen und es mitten in den Brand der jungen Kuh werfen. ");
INSERT INTO deuelo_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Und der Priester soll seine Kleider waschen und sein Fleisch im Wasser baden, und danach soll er in das Lager gehen; und der Priester wird unrein sein bis an den Abend. ");
INSERT INTO deuelo_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Und der sie verbrennt, soll seine Kleider mit Wasser waschen und sein Fleisch im Wasser baden, und er wird unrein sein bis an den Abend. ");
INSERT INTO deuelo_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Und ein reiner Mann soll die Asche der jungen Kuh sammeln und sie außerhalb des Lagers an einen reinen Ort schütten, und sie soll für die Gemeinde der Kinder Israel aufbewahrt werden zum Wasser der Reinigung; es ist eine Entsündigung. ");
INSERT INTO deuelo_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Und der die Asche der jungen Kuh gesammelt hat, soll seine Kleider waschen, und er wird unrein sein bis an den Abend. Und es soll den Kindern Israel und dem Fremdling, der in ihrer Mitte weilt, zur ewigen Satzung sein. ");
INSERT INTO deuelo_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Wer einen Toten anrührt, irgend eine Leiche eines Menschen, der wird sieben Tage unrein sein. ");
INSERT INTO deuelo_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Selbiger soll sich am dritten Tage damit entsündigen, und am siebten Tage wird er rein sein; und wenn er sich nicht entsündigt am dritten Tage, so wird er am siebten Tage nicht rein sein. ");
INSERT INTO deuelo_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Jeder, der einen Toten anrührt, die Leiche irgend eines Menschen, der gestorben ist, und sich nicht entsündigt, hat die Wohnung Jehovas verunreinigt; und selbige Seele soll ausgerottet werden aus Israel. Weil das Wasser der Reinigung nicht auf ihn gesprengt wurde, ist er unrein; seine Unreinigkeit ist noch an ihm. ");
INSERT INTO deuelo_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Dies ist das Gesetz, wenn ein Mensch im Zelte stirbt: Jeder, der ins Zelt geht, und jeder, der im Zelte ist, wird sieben Tage unrein sein. ");
INSERT INTO deuelo_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Und jedes offene Gefäß, auf dem kein festgebundener Deckel ist, wird unrein sein. - ");
INSERT INTO deuelo_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Und jeder, der auf freiem Felde einen mit dem Schwerte Erschlagenen oder einen Gestorbenen oder das Gebein eines Menschen oder ein Grab anrührt, wird sieben Tage unrein sein. ");
INSERT INTO deuelo_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Und man soll für den Unreinen von dem Staube des zur Entsündigung Verbrannten nehmen und lebendiges Wasser darauf tun in ein Gefäß; ");
INSERT INTO deuelo_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","und ein reiner Mann soll Ysop nehmen und ihn in das Wasser tauchen, und soll auf das Zelt sprengen und auf alle Geräte und auf die Personen, die daselbst sind, und auf den, der das Gebein oder den Erschlagenen oder den Gestorbenen oder das Grab angerührt hat. ");
INSERT INTO deuelo_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Und zwar soll der Reine auf den Unreinen sprengen am dritten Tage und am siebten Tage, und ihn am siebten Tage entsündigen; und er soll seine Kleider waschen und sich im Wasser baden, und am Abend wird er rein sein. - ");
INSERT INTO deuelo_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Und wenn jemand unrein wird, und sich nicht entsündigt, selbige Seele soll ausgerottet werden aus der Mitte der Versammlung; denn er hat das Heiligtum Jehovas verunreinigt: das Wasser der Reinigung ist nicht auf ihn gesprengt worden, er ist unrein. ");
INSERT INTO deuelo_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Und es soll ihnen zur ewigen Satzung sein. Und wer das Wasser der Reinigung sprengt, soll seine Kleider waschen; und wer das Wasser der Reinigung anrührt, wird unrein sein bis an den Abend. ");
INSERT INTO deuelo_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Und alles, was der Unreine anrührt, wird unrein sein; und wer ihn anrührt, wird unrein sein bis an den Abend. ");
INSERT INTO deuelo_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Und die Kinder Israel, die ganze Gemeinde, kamen in die Wüste Zin, im ersten Monat; und das Volk blieb zu Kades; und Mirjam starb daselbst und wurde daselbst begraben. ");
INSERT INTO deuelo_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Und es war kein Wasser da für die Gemeinde, und sie versammelten sich wider Mose und wider Aaron. ");
INSERT INTO deuelo_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Und das Volk haderte mit Mose, und sie sprachen und sagten: Wären wir doch umgekommen, als unsere Brüder vor Jehova umkamen! ");
INSERT INTO deuelo_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Und warum habt ihr die Versammlung Jehovas in diese Wüste gebracht, daß wir daselbst sterben, wir und unser Vieh? ");
INSERT INTO deuelo_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Und warum habt ihr uns aus Ägypten heraufgeführt, um uns an diesen bösen Ort zu bringen? Es ist kein Ort der Aussaat und der Feigenbäume und der Weinstöcke und der Granatbäume, und kein Wasser ist da zu trinken. ");
INSERT INTO deuelo_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Und Mose und Aaron gingen von der Versammlung hinweg zum Eingang des Zeltes der Zusammenkunft und fielen auf ihr Angesicht; und die Herrlichkeit Jehovas erschien ihnen. ");
INSERT INTO deuelo_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Nimm den Stab und versammle die Gemeinde, du und dein Bruder Aaron, und redet vor ihren Augen zu dem Felsen, so wird er sein Wasser geben; und du wirst ihnen Wasser aus dem Felsen hervorbringen und die Gemeinde tränken und ihr Vieh. ");
INSERT INTO deuelo_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Und Mose nahm den Stab vor Jehova weg, so wie er ihm geboten hatte. ");
INSERT INTO deuelo_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Und Mose und Aaron versammelten die Versammlung vor dem Felsen; und er sprach zu ihnen: Höret doch, ihr Widerspenstigen! Werden wir euch Wasser aus diesem Felsen hervorbringen? ");
INSERT INTO deuelo_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Und Mose erhob seine Hand und schlug den Felsen mit seinem Stabe zweimal; da kam viel Wasser heraus, und die Gemeinde trank und ihr Vieh. ");
INSERT INTO deuelo_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Da sprach Jehova zu Mose und zu Aaron: Weil ihr mir nicht geglaubt habt, mich vor den Augen der Kinder Israel zu heiligen, deswegen sollt ihr diese Versammlung nicht in das Land bringen, das ich ihnen gegeben habe. ");
INSERT INTO deuelo_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Das ist das Wasser von Meriba, wo die Kinder Israel mit Jehova haderten, und er sich an ihnen heiligte. ");
INSERT INTO deuelo_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Und Mose sandte Boten aus Kades an den König von Edom: So spricht dein Bruder Israel: Du kennst all das Ungemach, das uns betroffen hat: ");
INSERT INTO deuelo_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Unsere Väter zogen nach Ägypten hinab, und wir haben eine lange Zeit in Ägypten gewohnt; und die Ägypter behandelten uns und unsere Väter übel. ");
INSERT INTO deuelo_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Da schrieen wir zu Jehova, und er hat unsere Stimme gehört und einen Engel gesandt und uns aus Ägypten herausgeführt; und siehe, wir sind zu Kades, einer Stadt am Äußersten deines Gebiets. ");
INSERT INTO deuelo_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Laß uns doch durch dein Land ziehen! Wir wollen nicht durch die Äcker und durch die Weinberge ziehen und wollen kein Wasser aus den Brunnen trinken; auf der Straße des Königs wollen wir ziehen und nicht ausbiegen zur Rechten noch zur Linken, bis wir durch dein Gebiet gezogen sind. ");
INSERT INTO deuelo_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Aber Edom sprach zu ihm: Du sollst nicht bei mir durchziehen, daß ich dir nicht mit dem Schwerte entgegenrücke. ");
INSERT INTO deuelo_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Und die Kinder Israel sprachen zu ihm: Auf der Landstraße wollen wir hinaufziehen; und wenn wir von deinem Wasser trinken, ich und mein Vieh, so will ich den Preis dafür geben; mit meinen Füßen will ich durchziehen, weiter nichts. ");
INSERT INTO deuelo_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Und er sprach: Du sollst nicht durchziehen! Und Edom zog aus, ihm entgegen, mit zahlreichem Volk und mit starker Hand. ");
INSERT INTO deuelo_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Und so weigerte sich Edom, Israel zu gestatten, durch sein Gebiet zu ziehen; und Israel bog von ihm ab. ");
INSERT INTO deuelo_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Und sie brachen auf von Kades; und die Kinder Israel, die ganze Gemeinde, kamen an den Berg Hor. ");
INSERT INTO deuelo_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Und Jehova redete zu Mose und zu Aaron am Berge Hor, an der Grenze des Landes Edom, und sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Aaron soll zu seinen Völkern versammelt werden; denn er soll nicht in das Land kommen, das ich den Kindern Israel gegeben habe, weil ihr meinem Befehle widerspenstig gewesen seid bei dem Wasser von Meriba. ");
INSERT INTO deuelo_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Nimm Aaron und Eleasar, seinen Sohn, und laß sie hinaufsteigen auf den Berg Hor; ");
INSERT INTO deuelo_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","und ziehe Aaron seine Kleider aus und lege sie seinem Sohne Eleasar an; und Aaron soll versammelt werden und daselbst sterben. ");
INSERT INTO deuelo_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Und Mose tat, so wie Jehova geboten hatte, und sie stiegen auf den Berg Hor, vor den Augen der ganzen Gemeinde. ");
INSERT INTO deuelo_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Und Mose zog Aaron seine Kleider aus und legte sie seinem Sohne Eleasar an; und Aaron starb daselbst auf dem Gipfel des Berges; und Mose und Eleasar stiegen von dem Berge herab. ");
INSERT INTO deuelo_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Und als die ganze Gemeinde sah, daß Aaron verschieden war, da beweinte das ganze Haus Israel Aaron dreißig Tage lang. ");
INSERT INTO deuelo_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Und der Kanaaniter, der König von Arad, der im Süden wohnte, hörte, daß Israel des Weges nach Atharim kam, und er stritt wider Israel und führte Gefangene von ihm hinweg. ");
INSERT INTO deuelo_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Da tat Israel Jehova ein Gelübde und sprach: Wenn du dieses Volk gewißlich in meine Hand gibst, so werde ich seine Städte verbannen. ");
INSERT INTO deuelo_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Und Jehova hörte auf die Stimme Israels und gab die Kanaaniter in seine Hand; und es verbannte sie und ihre Städte. Und man gab dem Orte den Namen Horma. ");
INSERT INTO deuelo_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Und sie brachen auf vom Berge Hor, des Weges zum Schilfmeer, um das Land Edom zu umgehen. Und die Seele des Volkes wurde ungeduldig auf dem Wege; ");
INSERT INTO deuelo_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","und das Volk redete wider Gott und wider Mose: Warum habt ihr uns aus Ägyten heraufgeführt, daß wir in der Wüste sterben? Denn da ist kein Brot und kein Wasser, und unsere Seele ekelt vor dieser elenden Speise. ");
INSERT INTO deuelo_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Da sandte Jehova feurige Schlangen unter das Volk, und sie bissen das Volk; und es starb viel Volks aus Israel. ");
INSERT INTO deuelo_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Da kam das Volk zu Mose, und sie sprachen: Wir haben gesündigt, daß wir wider Jehova und wider dich geredet haben; flehe zu Jehova, daß er die Schlangen von uns wegnehme. Und Mose flehte für das Volk. ");
INSERT INTO deuelo_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Und Jehova sprach zu Mose: Mache dir eine feurige Schlange und tue sie auf eine Stange; und es wird geschehen, jeder, der gebissen ist und sie ansieht, der wird am Leben bleiben. ");
INSERT INTO deuelo_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Und Mose machte eine Schlange von Erz und tat sie auf die Stange; und es geschah, wenn eine Schlange jemand gebissen hatte, und er schaute auf zu der ehernen Schlange, so blieb er am Leben. ");
INSERT INTO deuelo_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Und die Kinder Israel brachen auf und lagerten sich zu Oboth. ");
INSERT INTO deuelo_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Und sie brachen auf von Oboth und lagerten sich zu Ijje-Abarim, in der Wüste, die vor Moab gegen Sonnenaufgang ist. ");
INSERT INTO deuelo_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Von dort brachen sie auf und lagerten sich am Bache Sered. ");
INSERT INTO deuelo_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Von dort brachen sie auf und lagerten sich jenseit des Arnon, der in der Wüste ist, der aus dem Gebiete der Amoriter hervorgeht. Denn der Arnon ist die Grenze von Moab, zwischen Moab und den Amoritern. ");
INSERT INTO deuelo_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Darum heißt es in dem Buche der Kämpfe Jehovas: Waheb in Sufa und die Bäche des Arnon; ");
INSERT INTO deuelo_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","und die Ergießung der Bäche, die sich erstreckt nach dem Wohnsitze Ars, und sich lehnt an die Grenze von Moab. ");
INSERT INTO deuelo_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Und von dort zogen sie nach Beer; das ist der Brunnen, von welchem Jehova zu Mose sprach: Versammle das Volk, und ich will ihnen Wasser geben. ");
INSERT INTO deuelo_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Damals sang Israel dieses Lied: ");
INSERT INTO deuelo_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Herauf, Brunnen! Singet ihm zu! Brunnen, den Fürsten gegraben, den die Edlen des Volkes, mit dem Gesetzgeber, gehöhlt haben mit ihren Stäben! ");
INSERT INTO deuelo_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Und aus der Wüste zogen sie nach Mattana; und von Mattana nach Nachaliel, und von Nachaliel nach Bamoth; ");
INSERT INTO deuelo_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","und von Bamoth nach dem Tale, das im Gefilde Moabs ist, nach dem Gipfel des Pisga, der emporragt über die Fläche der Wildnis. ");
INSERT INTO deuelo_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Und Israel sandte Boten zu Sihon, dem Könige der Amoriter, und ließ ihm sagen: ");
INSERT INTO deuelo_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","Laß mich durch dein Land ziehen! Wir wollen nicht in die Äcker und in die Weinberge ausbiegen, wir wollen kein Wasser aus den Brunnen trinken; auf der Straße des Königs wollen wir ziehen, bis wir durch dein Gebiet gezogen sind. ");
INSERT INTO deuelo_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Aber Sihon gestattete Israel nicht, durch sein Gebiet zu ziehen; und Sihon versammelte all sein Volk und zog aus, Israel entgegen in die Wüste, und kam nach Jahaz und stritt wider Israel. ");
INSERT INTO deuelo_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Und Israel schlug ihn mit der Schärfe des Schwertes und nahm sein Land in Besitz, vom Arnon bis an den Jabbok, bis zu den Kindern Ammon; denn die Grenze der Kinder Ammon war fest. ");
INSERT INTO deuelo_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Und Israel nahm alle diese Städte, und Israel wohnte in allen Städten der Amoriter, in Hesbon und in allen seinen Tochterstädten. ");
INSERT INTO deuelo_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Denn Hesbon war die Stadt Sihons, des Königs der Amoriter; und dieser hatte wider den früheren König von Moab gestritten und hatte sein ganzes Land bis an den Arnon aus seiner Hand genommen. ");
INSERT INTO deuelo_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Daher sagen die Dichter: Kommet nach Hesbon; aufgebaut und befestigt werde die Stadt Sihons! ");
INSERT INTO deuelo_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Denn Feuer ging aus von Hesbon, eine Flamme von der Stadt Sihons; es fraß Ar-Moab, die Herren der Höhen des Arnon. ");
INSERT INTO deuelo_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Wehe dir, Moab; du bist verloren, Volk des Kamos! Er hat seine Söhne zu Flüchtlingen gemacht und seine Töchter in die Gefangenschaft Sihons geführt, des Königs der Amoriter. ");
INSERT INTO deuelo_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Da haben wir auf sie geschossen; Hesbon ist verloren bis Dibon; da haben wir verwüstet bis Nophach, Feuer bis Medeba! ");
INSERT INTO deuelo_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Und Israel wohnte im Lande der Amoriter. ");
INSERT INTO deuelo_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Und Mose sandte Männer aus, um Jaser auszukundschaften; und sie nahmen seine Tochterstädte ein, und er trieb die Amoriter aus, die daselbst waren. ");
INSERT INTO deuelo_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Und sie wandten sich und zogen hinauf des Weges nach Basan; und Og, der König von Basan, zog aus, ihnen entgegen, er und all sein Volk, zum Streite nach Edrei. ");
INSERT INTO deuelo_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Und Jehova sprach zu Mose: Fürchte ihn nicht! Denn in deine Hand habe ich ihn gegeben und all sein Volk und sein Land; und tue ihm, so wie du Sihon, dem Könige der Amoriter, getan hast, der zu Hesbon wohnte. ");
INSERT INTO deuelo_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Und sie schlugen ihn und seine Söhne und all sein Volk, bis ihm kein Entronnener übrigblieb; und sie nahmen sein Land in Besitz. ");
INSERT INTO deuelo_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Und die Kinder Israel brachen auf und lagerten sich in den Ebenen Moabs, jenseit des Jordan von Jericho. ");
INSERT INTO deuelo_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Und Balak, der Sohn Zippors, sah alles, was Israel den Amoritern getan hatte. ");
INSERT INTO deuelo_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Und Moab fürchtete sich sehr vor dem Volke, weil es groß war, und es graute Moab vor den Kindern Israel. ");
INSERT INTO deuelo_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Und Moab sprach zu den Ältesten von Midian: Nun wird dieser Haufe alle unsere Umgebungen abfressen, wie das Rind das Grüne des Feldes abfrißt. Und Balak, der Sohn Zippors, war zu jener Zeit König von Moab. ");
INSERT INTO deuelo_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Und er sandte Boten zu Bileam, dem Sohne Beors, nach Pethor, das am Strome ist, in das Land der Kinder seines Volkes, um ihn zu rufen, und er ließ ihm sagen: Siehe, ein Volk ist aus Ägypten gezogen; siehe, es bedeckt die Fläche des Landes, und es liegt mir gegenüber. ");
INSERT INTO deuelo_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Und nun, komm doch, verfluche mir dieses Volk, denn es ist stärker als ich. Vielleicht gelingt es mir, daß wir es schlagen und ich es aus dem Lande vertreibe; denn ich weiß, wen du segnest, der ist gesegnet, und wen du verfluchst, der ist verflucht. ");
INSERT INTO deuelo_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Und die Ältesten von Moab und die Ältesten von Midian zogen hin mit dem Wahrsagerlohn in der Hand. Und sie kamen zu Bileam und redeten zu ihm die Worte Balaks. ");
INSERT INTO deuelo_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Und er sprach zu ihnen: Übernachtet hier diese Nacht, und ich werde euch Antwort bringen, so wie Jehova zu mir reden wird. Und die Fürsten von Moab blieben bei Bileam. ");
INSERT INTO deuelo_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Und Gott kam zu Bileam und sprach: Wer sind diese Männer bei dir? ");
INSERT INTO deuelo_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Und Bileam sprach zu Gott: Balak, der Sohn Zippors, der König von Moab, hat zu mir gesandt: ");
INSERT INTO deuelo_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Siehe, das Volk, das aus Ägypten gezogen ist, es bedeckt die Fläche des Landes; komm nun, verwünsche es mir, vielleicht vermag ich wider dasselbe zu streiten und es zu vertreiben. ");
INSERT INTO deuelo_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Und Gott sprach zu Bileam: Du sollst nicht mit ihnen gehen; du sollst das Volk nicht verfluchen, denn es ist gesegnet. ");
INSERT INTO deuelo_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Und Bileam stand des Morgens auf und sprach zu den Fürsten Balaks: Ziehet in euer Land; denn Jehova hat sich geweigert, mir zu gestatten, mit euch zu gehen. ");
INSERT INTO deuelo_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Und die Fürsten von Moab machten sich auf und kamen zu Balak und sprachen: Bileam hat sich geweigert, mit uns zu gehen. ");
INSERT INTO deuelo_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Da sandte Balak noch einmal Fürsten, mehr und geehrtere als jene. ");
INSERT INTO deuelo_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Und sie kamen zu Bileam und sprachen zu ihm: So spricht Balak, der Sohn Zippors: Laß dich doch nicht abhalten, zu mir zu kommen; ");
INSERT INTO deuelo_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","denn sehr hoch will ich dich ehren, und alles, was du mir sagen wirst, will ich tun; so komm doch, verwünsche mir dieses Volk! ");
INSERT INTO deuelo_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Und Bileam antwortete und sprach zu den Knechten Balaks: Wenn Balak mir sein Haus voll Silber und Gold gäbe, so vermöchte ich nicht den Befehl Jehovas, meines Gottes, zu übertreten, um Kleines oder Großes zu tun. ");
INSERT INTO deuelo_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Und nun bleibet doch hier, auch ihr, diese Nacht, und ich werde erfahren, was Jehova ferner mit mir reden wird. ");
INSERT INTO deuelo_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Da kam Gott des Nachts zu Bileam und sprach zu ihm: Wenn die Männer gekommen sind, um dich zu rufen, so mache dich auf, gehe mit ihnen; aber nur dasjenige, was ich dir sagen werde, sollst du tun. ");
INSERT INTO deuelo_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Und Bileam machte sich am Morgen auf und sattelte seine Eselin und zog mit den Fürsten von Moab. ");
INSERT INTO deuelo_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Da entbrannte der Zorn Gottes, daß er hinzog; und der Engel Jehovas stellte sich in den Weg, ihm zu widerstehen. Er aber ritt auf seiner Eselin, und seine beiden Jünglinge waren mit ihm. ");
INSERT INTO deuelo_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Und die Eselin sah den Engel Jehovas auf dem Wege stehen mit seinem gezückten Schwert in seiner Hand, und die Eselin bog vom Wege ab und ging ins Feld; und Bileam schlug die Eselin, um sie wieder auf den Weg zu lenken. ");
INSERT INTO deuelo_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Da trat der Engel Jehovas in einen Hohlweg zwischen den Weinbergen: eine Mauer war auf dieser, und eine Mauer auf jener Seite. ");
INSERT INTO deuelo_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Und die Eselin sah den Engel Jehovas und drängte sich an die Wand und drückte den Fuß Bileams an die Wand; und er schlug sie noch einmal. ");
INSERT INTO deuelo_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Da ging der Engel Jehovas nochmals weiter und trat an einen engen Ort, wo kein Weg war auszubiegen, weder zur Rechten noch zur Linken. ");
INSERT INTO deuelo_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Und als die Eselin den Engel Jehovas sah, legte sie sich nieder unter Bileam; und es entbrannte der Zorn Bileams, und er schlug die Eselin mit dem Stabe. ");
INSERT INTO deuelo_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Da tat Jehova den Mund der Eselin auf, und sie sprach zu Bileam: Was habe ich dir getan, daß du mich nun dreimal geschlagen hast? ");
INSERT INTO deuelo_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Und Bileam sprach zu der Eselin: Weil du Spott mit mir getrieben hast; wäre doch ein Schwert in meiner Hand, so hätte ich dich jetzt totgeschlagen! ");
INSERT INTO deuelo_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Und die Eselin sprach zu Bileam: Bin ich nicht deine Eselin, auf der du geritten bist von jeher bis auf diesen Tag? War ich je gewohnt, dir also zu tun? Und er sprach: Nein. ");
INSERT INTO deuelo_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Da enthüllte Jehova die Augen Bileams, und er sah den Engel Jehovas auf dem Wege stehen, mit seinem gezückten Schwert in seiner Hand; und er neigte sich und warf sich nieder auf sein Angesicht. ");
INSERT INTO deuelo_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Und der Engel Jehovas sprach zu ihm: Warum hast du deine Eselin nun dreimal geschlagen? Siehe, ich bin ausgegangen, dir zu widerstehen, denn der Weg ist verderblich vor mir. ");
INSERT INTO deuelo_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Und die Eselin sah mich und bog vor mir aus nun dreimal; wenn sie nicht vor mir ausgebogen wäre, so hätte ich dich jetzt auch erschlagen, sie aber am Leben gelassen. ");
INSERT INTO deuelo_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Und Bileam sprach zu dem Engel Jehovas: Ich habe gesündigt, denn ich wußte nicht, daß du mir auf dem Wege entgegenstandest; und nun, wenn es übel ist in deinen Augen, so will ich umkehren. ");
INSERT INTO deuelo_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Und der Engel Jehovas sprach zu Bileam: Gehe mit den Männern; aber nur dasjenige, was ich dir sagen werde, sollst du reden. Und Bileam zog mit den Fürsten Balaks. ");
INSERT INTO deuelo_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Und als Balak hörte, daß Bileam käme, da ging er aus, ihm entgegen, nach der Stadt Moabs, an der Grenze des Arnon, der an der äußersten Grenze fließt. ");
INSERT INTO deuelo_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Und Balak sprach zu Bileam: Habe ich nicht ausdrücklich zu dir gesandt, um dich zu rufen? Warum bist du nicht zu mir gekommen? Fürwahr, vermag ich nicht dich zu ehren? ");
INSERT INTO deuelo_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Und Bileam sprach zu Balak: Siehe, ich bin zu dir gekommen; vermag ich nun wohl irgend etwas zu reden? Das Wort, das Gott mir in den Mund legt, das werde ich reden. ");
INSERT INTO deuelo_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Und Bileam ging mit Balak; und sie kamen nach Kirjath-Chuzoth. ");
INSERT INTO deuelo_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Und Balak opferte Rind-und Kleinvieh und schickte davon dem Bileam und den Fürsten, die bei ihm waren. ");
INSERT INTO deuelo_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Und es geschah am Morgen, da nahm Balak den Bileam und führte ihn hinauf nach den Höhen des Baal, und er sah von dort aus das Äußerste des Volkes. ");
INSERT INTO deuelo_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Und Bileam sprach zu Balak: Baue mir hier sieben Altäre, und stelle mir hier bereit sieben Farren und sieben Widder. ");
INSERT INTO deuelo_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Und Balak tat, so wie Bileam gesagt hatte; und Balak und Bileam opferten einen Farren und einen Widder auf jedem Altar. ");
INSERT INTO deuelo_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Und Bileam sprach zu Balak: Stelle dich neben dein Brandopfer, und ich will gehen; vielleicht wird Jehova mir entgegenkommen, und was er mich sehen lassen wird, das werde ich dir kundtun. Und er ging auf eine kahle Höhe. ");
INSERT INTO deuelo_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Und Gott kam dem Bileam entgegen; und dieser sprach zu ihm: Die sieben Altäre habe ich zugerichtet und auf jedem Altar einen Farren und einen Widder geopfert. ");
INSERT INTO deuelo_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Und Jehova legte ein Wort in den Mund Bileams und sprach: Kehre zu Balak zurück, und so sollst du reden. ");
INSERT INTO deuelo_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Und er kehrte zu ihm zurück; und siehe, er stand neben seinem Brandopfer, er und alle Fürsten von Moab. ");
INSERT INTO deuelo_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Da hob er seinen Spruch an und sprach: Aus Aram hat Balak mich hergeführt, der König von Moab von den Bergen des Ostens: Komm, verfluche mir Jakob; ja, komm, verwünsche Israel! ");
INSERT INTO deuelo_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Wie soll ich verfluchen, den Gott nicht verflucht, und wie verwünschen, den Jehova nicht verwünscht hat? ");
INSERT INTO deuelo_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Denn vom Gipfel der Felsen sehe ich es, und von den Höhen herab schaue ich es: siehe, ein Volk, das abgesondert wohnt und unter die Nationen nicht gerechnet wird. ");
INSERT INTO deuelo_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Wer könnte zählen den Staub Jakobs und, der Zahl nach, den vierten Teil Israels? Meine Seele sterbe den Tod der Rechtschaffenen, und mein Ende sei gleich dem ihrigen! ");
INSERT INTO deuelo_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Da sprach Balak zu Bileam: Was hast du mir getan! Meine Feinde zu verwünschen habe ich dich holen lassen, und siehe, du hast sie sogar gesegnet! ");
INSERT INTO deuelo_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Und er antwortete und sprach: Muß ich nicht darauf achten, das zu reden, was Jehova in meinen Mund legt? ");
INSERT INTO deuelo_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Und Balak sprach zu ihm: Komm doch mit mir an einen anderen Ort, von wo aus du es sehen wirst; nur sein Äußerstes wirst du sehen, und ganz wirst du es nicht sehen; und verwünsche es mir von dort aus. ");
INSERT INTO deuelo_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Und er nahm ihn mit nach dem Felde der Wächter, auf den Gipfel des Pisga; und er baute sieben Altäre und opferte einen Farren und einen Widder auf jedem Altar. ");
INSERT INTO deuelo_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Und er sprach zu Balak: Stelle dich hier neben dein Brandopfer, und ich, ich will dort entgegengehen. ");
INSERT INTO deuelo_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Und Jehova kam dem Bileam entgegen und legte ein Wort in seinen Mund und sprach: Kehre zu Balak zurück, und so sollst du reden. ");
INSERT INTO deuelo_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Und er kam zu ihm, und siehe, er stand neben seinem Brandopfer, und die Fürsten von Moab mit ihm. Und Balak sprach zu ihm: Was hat Jehova geredet? ");
INSERT INTO deuelo_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Da hob er seinen Spruch an und sprach: Stehe auf, Balak, und höre! Horche auf mich, Sohn Zippors! ");
INSERT INTO deuelo_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Nicht ein Mensch ist Gott, daß er lüge, noch ein Menschensohn, daß er bereue. Sollte er gesprochen haben und es nicht tun, und geredet haben und es nicht aufrecht halten? ");
INSERT INTO deuelo_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Siehe, zu segnen habe ich empfangen; und er hat gesegnet, und ich kann es nicht wenden. ");
INSERT INTO deuelo_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Er erblickt keine Ungerechtigkeit in Jakob und sieht kein Unrecht in Israel; Jehova, sein Gott, ist mit ihm, und Jubelgeschrei wie um einen König ist in seiner Mitte. ");
INSERT INTO deuelo_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Gott hat ihn aus Ägypten herausgeführt; sein ist die Stärke des Wildochsen. ");
INSERT INTO deuelo_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Denn da ist keine Zauberei wider Jakob, und keine Wahrsagerei wider Israel. Um diese Zeit wird von Jakob und von Israel gesagt werden, was Gott gewirkt hat. ");
INSERT INTO deuelo_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Siehe, ein Volk: gleich einer Löwin steht es auf, und gleich einem Löwen erhebt es sich! Es legt sich nicht nieder, bis es den Raub verzehrt und das Blut der Erschlagenen getrunken hat. ");
INSERT INTO deuelo_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Da sprach Balak zu Bileam: Du sollst es gar nicht verwünschen, und du sollst es gar nicht segnen. ");
INSERT INTO deuelo_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Und Bileam antwortete und sprach zu Balak: Habe ich nicht zu dir geredet und gesagt: Alles, was Jehova reden wird, das werde ich tun? ");
INSERT INTO deuelo_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Und Balak sprach zu Bileam: Komm doch, ich will dich an einen anderen Ort mitnehmen; vielleicht wird es in den Augen Gottes recht sein, daß du es mir von dort aus verwünschest. ");
INSERT INTO deuelo_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Und Balak nahm den Bileam mit auf den Gipfel des Peor, der emporragt über die Fläche der Wildnis. ");
INSERT INTO deuelo_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Und Bileam sprach zu Balak: Baue mir hier sieben Altäre, und stelle mir hier bereit sieben Farren und sieben Widder. ");
INSERT INTO deuelo_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Und Balak tat, so wie Bileam gesagt hatte; und er opferte einen Farren und einen Widder auf jedem Altar. ");
INSERT INTO deuelo_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Und als Bileam sah, daß es gut war in den Augen Jehovas, Israel zu segnen, so ging er nicht, wie die anderen Male, auf Wahrsagerei aus, sondern richtete sein Angesicht nach der Wüste hin. ");
INSERT INTO deuelo_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Und Bileam erhob seine Augen und sah Israel, gelagert nach seinen Stämmen; und der Geist Gottes kam über ihn. ");
INSERT INTO deuelo_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Und er hob seinen Spruch an und sprach: Es spricht Bileam, der Sohn Beors, und es spricht der Mann geöffneten Auges. ");
INSERT INTO deuelo_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Es spricht, der da hört die Worte Gottes, der ein Gesicht des Allmächtigen sieht, der hinfällt und enthüllter Augen ist: ");
INSERT INTO deuelo_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Wie schön sind deine Zelte, Jakob, deine Wohnungen, Israel! ");
INSERT INTO deuelo_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Gleich Tälern breiten sie sich aus, gleich Gärten am Strome, gleich Aloebäumen, die Jehova gepflanzt hat, gleich Zedern am Gewässer! ");
INSERT INTO deuelo_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Wasser wird fließen aus seinen Eimern, und sein Same wird in großen Wassern sein; und sein König wird höher sein als Agag, und sein Königreich wird erhaben sein. ");
INSERT INTO deuelo_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Gott hat ihn aus Ägypten herausgeführt; sein ist die Stärke des Wildochsen. Er wird die Nationen, seine Feinde, fressen und ihre Gebeine zermalmen und mit seinen Pfeilen sie zerschmettern. ");
INSERT INTO deuelo_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Er duckt sich, er legt sich nieder wie ein Löwe und wie eine Löwin; wer will ihn aufreizen? Die dich segnen, sind gesegnet, und die dich verfluchen, sind verflucht! ");
INSERT INTO deuelo_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Da entbrannte der Zorn Balaks wider Bileam, und er schlug seine Hände zusammen; und Balak sprach zu Bileam: Meine Feinde zu verwünschen, habe ich dich gerufen, und siehe, du hast sie sogar gesegnet, nun dreimal! ");
INSERT INTO deuelo_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Und nun fliehe an deinen Ort. Ich hatte gesagt, ich wolle dich hoch ehren; und siehe, Jehova hat dir die Ehre verwehrt. ");
INSERT INTO deuelo_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Und Bileam sprach zu Balak: Habe ich nicht auch zu deinen Boten, die du zu mir gesandt hast, geredet und gesagt: ");
INSERT INTO deuelo_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Wenn Balak mir sein Haus voll Silber und Gold gäbe, so vermöchte ich nicht den Befehl Jehovas zu übertreten, um aus meinem eigenen Herzen Gutes oder Böses zu tun; was Jehova reden wird, das werde ich reden? ");
INSERT INTO deuelo_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Und nun siehe, ich gehe zu meinem Volke. Komm, ich will dir anzeigen, was dieses Volk deinem Volke tun wird am Ende der Tage. ");
INSERT INTO deuelo_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Und er hob seinen Spruch an und sprach: Es spricht Bileam, der Sohn Beors, und es spricht der Mann geöffneten Auges. ");
INSERT INTO deuelo_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Es spricht, der da hört die Worte Gottes, und der die Erkenntnis des Höchsten besitzt, der ein Gesicht des Allmächtigen sieht, der hinfällt und enthüllter Augen ist: ");
INSERT INTO deuelo_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Ich sehe ihn, aber nicht jetzt, ich schaue ihn, aber nicht nahe; es tritt hervor ein Stern aus Jakob, und ein Zepter erhebt sich aus Israel und zerschlägt die Seiten Moabs und zerschmettert alle Söhne des Getümmels. ");
INSERT INTO deuelo_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Und Edom wird ein Besitz sein und Seir ein Besitz, sie, seine Feinde; und Israel wird Mächtiges tun. ");
INSERT INTO deuelo_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Und einer aus Jakob wird herrschen, und er wird aus der Stadt den Überrest vertilgen. - ");
INSERT INTO deuelo_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Und er sah Amalek und hob seinen Spruch an und sprach: Die erste der Nationen war Amalek, aber sein Letztes wird dem Untergang verfallen. - ");
INSERT INTO deuelo_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Und er sah die Keniter und hob seinen Spruch an und sprach: Fest ist dein Wohnsitz, und auf den Felsen gesetzt dein Nest; ");
INSERT INTO deuelo_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","doch der Keniter soll vertilgt werden, bis Assur dich gefangen wegführt. - ");
INSERT INTO deuelo_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Und er hob seinen Spruch an und sprach: Wehe! Wer wird am Leben bleiben, sobald Gott dieses herbeiführt? ");
INSERT INTO deuelo_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Und Schiffe werden kommen von der Küste von Kittim und werden Assur demütigen, und Heber demütigen, und auch er wird dem Untergang verfallen. - ");
INSERT INTO deuelo_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Und Bileam machte sich auf und ging und kehrte zurück an seinen Ort; und auch Balak zog seines Weges. ");
INSERT INTO deuelo_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Und Israel blieb in Sittim. Und das Volk fing an zu huren mit den Töchtern Moabs; ");
INSERT INTO deuelo_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","und diese luden das Volk zu den Opfern ihrer Götter, und das Volk aß und beugte sich nieder vor ihren Göttern. ");
INSERT INTO deuelo_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Und Israel hängte sich an den Baal-Peor; und der Zorn Jehovas entbrannte wider Israel. ");
INSERT INTO deuelo_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Da sprach Jehova zu Mose: Nimm alle Häupter des Volkes und hänge sie dem Jehova auf vor der Sonne, damit die Glut des Zornes Jehovas sich von Israel abwende. ");
INSERT INTO deuelo_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Und Mose sprach zu den Richtern Israels: Erschlaget ein jeder seine Leute, die sich an den Baal-Peor gehängt haben! ");
INSERT INTO deuelo_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Und siehe, ein Mann von den Kindern Israel kam und brachte eine Midianitin zu seinen Brüdern, vor den Augen Moses und vor den Augen der ganzen Gemeinde der Kinder Israel, als diese an dem Eingang des Zeltes der Zusammenkunft weinten. ");
INSERT INTO deuelo_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Und als Pinehas, der Sohn Eleasars, des Sohnes Aarons, des Priesters, es sah, da stand er auf aus der Mitte der Gemeinde und nahm eine Lanze in seine Hand; ");
INSERT INTO deuelo_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","und er ging dem israelitischen Manne nach in das Innere des Zeltes und durchstach sie beide, den israelitischen Mann und das Weib, durch ihren Bauch. Da ward die Plage von den Kindern Israel abgewehrt. ");
INSERT INTO deuelo_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Und es waren der an der Plage Gestorbenen vierundzwanzigtausend. ");
INSERT INTO deuelo_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","Pinehas, der Sohn Eleasars, des Sohnes Aarons, des Priesters, hat meinen Grimm von den Kindern Israel abgewendet, indem er in meinem Eifer in ihrer Mitte geeifert hat, so daß ich die Kinder Israel nicht in meinem Eifer vertilgt habe. ");
INSERT INTO deuelo_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Darum sprich: Siehe, ich gebe ihm meinen Bund des Friedens; ");
INSERT INTO deuelo_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","und er wird ihm und seinem Samen nach ihm ein Bund ewigen Priestertums sein, darum daß er für seinen Gott geeifert und für die Kinder Israel Sühnung getan hat. - ");
INSERT INTO deuelo_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Und der Name des erschlagenen israelitischen Mannes, der mit der Midianitin erschlagen wurde, war Simri, der Sohn Salus, der Fürst eines Vaterhauses der Simeoniter; ");
INSERT INTO deuelo_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","und der Name des erschlagenen midianitischen Weibes war Kosbi, die Tochter Zurs; er war Stammhaupt eines Vaterhauses unter den Midianitern. ");
INSERT INTO deuelo_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","Befeindet die Midianiter und schlaget sie; ");
INSERT INTO deuelo_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","denn sie haben euch befeindet durch ihre List, womit sie euch überlistet haben in der Sache des Peor und in der Sache der Kosbi, der Tochter eines Fürsten von Midian, ihrer Schwester, welche am Tage der Plage wegen des Peor erschlagen wurde. ");
INSERT INTO deuelo_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Und es geschah nach der Plage, da sprach Jehova zu Mose und zu Eleasar, dem Sohne Aarons, dem Priester, und sagte: ");
INSERT INTO deuelo_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","Nehmet auf die Summe der ganzen Gemeinde der Kinder Israel, von zwanzig Jahren und darüber, nach ihren Vaterhäusern, einen jeden, der zum Heere auszieht in Israel. ");
INSERT INTO deuelo_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Und Mose und Eleasar, der Priester, redeten zu ihnen in den Ebenen Moabs, am Jordan von Jericho, und sprachen: ");
INSERT INTO deuelo_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","Von zwanzig Jahren und darüber..., so wie Jehova dem Mose geboten hatte. Und es waren die Kinder Israel, die aus dem Lande Ägypten ausgezogen waren: ");
INSERT INTO deuelo_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Ruben, der Erstgeborene Israels; die Söhne Rubens: von Hanok das Geschlecht der Hanokiter; von Pallu das Geschlecht der Palluiter; ");
INSERT INTO deuelo_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","von Hezron das Geschlecht der Hezroniter; von Karmi das Geschlecht der Karmiter. ");
INSERT INTO deuelo_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Das sind die Geschlechter der Rubeniter; und ihre Gemusterten waren dreiundvierzigtausend siebenhundertdreißig. ");
INSERT INTO deuelo_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Und die Söhne Pallus: Eliab. ");
INSERT INTO deuelo_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Und die Söhne Eliabs: Nemuel und Dathan und Abiram; das ist der Dathan und der Abiram, Berufene der Gemeinde, welche wider Mose und wider Aaron haderten in der Rotte Korahs, als sie wider Jehova haderten. ");
INSERT INTO deuelo_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Und die Erde tat ihren Mund auf und verschlang sie und Korah, als die Rotte starb, indem das Feuer die zweihundertfünfzig Männer verzehrte, und sie zu einem Zeichen wurden. ");
INSERT INTO deuelo_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Aber die Söhne Korahs starben nicht. ");
INSERT INTO deuelo_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Die Söhne Simeons nach ihren Geschlechtern: von Nemuel das Geschlecht der Nemueliter; von Jamin das Geschlecht der Jaminiter; von Jakin das Geschlecht der Jakiniter; ");
INSERT INTO deuelo_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","von Serach das Geschlecht der Sarchiter; von Saul das Geschlecht der Sauliter. ");
INSERT INTO deuelo_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Das sind die Geschlechter der Simeoniter: zweiundzwanzigtausend zweihundert. ");
INSERT INTO deuelo_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Die Söhne Gads nach ihren Geschlechtern: von Zephon das Geschlecht der Zephoniter; von Haggi das Geschlecht der Haggiter; von Schuni das Geschlecht der Schuniter; ");
INSERT INTO deuelo_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","von Osni das Geschlecht der Osniter; von Eri das Geschlecht der Eriter; ");
INSERT INTO deuelo_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Von Arod das Geschlecht der Aroditer; von Areli das Geschlecht der Areliter. ");
INSERT INTO deuelo_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Das sind die Geschlechter der Söhne Gads, nach ihren Gemusterten, vierzigtausend fünfhundert. ");
INSERT INTO deuelo_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Die Söhne Judas: Gher und Onan; Gher und Onan aber starben im Lande Kanaan. ");
INSERT INTO deuelo_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Und es waren die Söhne Judas nach ihren Geschlechtern: von Schela das Geschlecht der Schelaniter; von Perez das Geschlecht der Parziter; von Serach das Geschlecht der Sarchiter. ");
INSERT INTO deuelo_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Und die Söhne Perez' waren: Von Hezron das Geschlecht der Hezroniter; von Hamul das Geschlecht der Hamuliter. ");
INSERT INTO deuelo_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Das sind die Geschlechter Judas nach ihren Gemusterten: sechsundsiebzigtausend fünfhundert. ");
INSERT INTO deuelo_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Die Söhne Issaschars nach ihren Geschlechtern: von Tola das Geschlecht der Tolaiter; von Puwa das Geschlecht der Puniter; ");
INSERT INTO deuelo_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","von Jaschub das Geschlecht der Jaschubiter; von Schimron das Geschlecht der Schimroniter. ");
INSERT INTO deuelo_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Das sind die Geschlechter Issaschars, nach ihren Gemusterten: vierundsechzigtausend dreihundert. ");
INSERT INTO deuelo_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Die Söhne Sebulons nach ihren Geschlechtern: von Sered das Geschlecht der Sarditer; von Elon das Geschlecht der Eloniter; von Jachleel das Geschlecht der Jachleeliter. ");
INSERT INTO deuelo_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Das sind die Geschlechter der Sebuloniter, nach ihren Gemusterten: sechzigtausend fünfhundert. ");
INSERT INTO deuelo_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Die Söhne Josephs nach ihren Geschlechtern: Manasse und Ephraim. ");
INSERT INTO deuelo_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Die Söhne Manasses: von Makir das Geschlecht der Makiriter (und Makir zeugte Gilead); von Gilead das Geschlecht der Gileaditer. ");
INSERT INTO deuelo_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Dies sind die Söhne Gileads: von Jieser das Geschlecht der Jieseriter; von Helek das Geschlecht der Helkiter; ");
INSERT INTO deuelo_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","und von Asriel das Geschlecht der Asrieliter; und von Sichem das Geschlecht der Sikmiter; ");
INSERT INTO deuelo_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","und von Schemida das Geschlecht der Schemidaiter; und von Hepher das Geschlecht der Hephriter. - ");
INSERT INTO deuelo_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Und Zelophchad, der Sohn Hephers, hatte keine Söhne, sondern nur Töchter; und die Namen der Töchter Zelophchads waren: Machla und Noa, Chogla, Milka und Tirza. - ");
INSERT INTO deuelo_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Das sind die Geschlechter Manasses; und ihrer Gemusterten waren zweiundfünfzigtausend siebenhundert. ");
INSERT INTO deuelo_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Dies sind die Söhne Ephraims nach ihren Geschlechtern: von Schuthelach das Geschlecht der Schuthalchiter; von Beker das Geschlecht der Bakriter; von Tachan das Geschlecht der Tachaniter. ");
INSERT INTO deuelo_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Und dies sind die Söhne Schuthelachs: von Eran das Geschlecht der Eraniter. ");
INSERT INTO deuelo_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Das sind die Geschlechter der Söhne Ephraims, nach ihren Gemusterten: zweiunddreißigtausend fünfhundert. Das sind die Söhne Josephs nach ihren Geschlechtern. ");
INSERT INTO deuelo_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Die Söhne Benjamins nach ihren Geschlechtern: von Bela das Geschlecht der Baliter; von Aschbel das Geschlecht der Aschbeliter; von Achiram das Geschlecht der Achiramiter; ");
INSERT INTO deuelo_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","von Schephupham das Geschlecht der Schuphamiter; von Hupham das Geschlecht der Huphamiter. ");
INSERT INTO deuelo_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Und die Söhne Belas waren: Ard und Naaman; von Ard das Geschlecht der Arditer, von Naaman das Geschlecht der Naamaniter. ");
INSERT INTO deuelo_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Das sind die Söhne Benjamins nach ihren Geschlechtern; und ihrer Gemusterten waren fünfundvierzigtausend sechshundert. ");
INSERT INTO deuelo_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Dies sind die Söhne Dans nach ihren Geschlechtern: von Schucham das Geschlecht der Schuchamiter; ");
INSERT INTO deuelo_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Das sind die Geschlechter Dans nach ihren Geschlechtern. Alle Geschlechter der Schuchamiter, nach ihren Gemusterten: Vierundsechzigtausend vierhundert. ");
INSERT INTO deuelo_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Die Söhne Asers nach ihren Geschlechtern: von Jimna das Geschlecht der Jimna; von Jischwi das Geschlecht der Jischwiter; von Beria das Geschlecht der Beriiter. ");
INSERT INTO deuelo_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Von den Söhnen Berias: von Heber das Geschlecht der Hebriter; von Malkiel das Geschlecht der Malkieliter. ");
INSERT INTO deuelo_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Und der Name der Tochter Asers war Serach. ");
INSERT INTO deuelo_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Das sind die Geschlechter der Söhne Asers, nach ihren Gemusterten: dreiundfünfzigtausend vierhundert. ");
INSERT INTO deuelo_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Die Söhne Naphtalis nach ihren Geschlechtern: von Jachzeel das Geschlecht der Jachzeeliter; von Guni das Geschlecht der Guniter; ");
INSERT INTO deuelo_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","von Jezer das Geschlecht der Jizriter; von Schillem das Geschlecht der Schillemiter. ");
INSERT INTO deuelo_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Das sind die Geschlechter Naphtalis nach ihren Geschlechtern; und ihrer Gemusterten waren fünfundvierzigtausend vierhundert. ");
INSERT INTO deuelo_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Das sind die Gemusterten der Kinder Israel: sechshunderteintausend siebenhundertdreißig. ");
INSERT INTO deuelo_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","Diesen soll das Land nach der Zahl der Namen als Erbteil verteilt werden. ");
INSERT INTO deuelo_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Den Vielen sollst du ihr Erbteil mehren und den Wenigen ihr Erbteil mindern; einem jeden soll nach Verhältnis seiner Gemusterten sein Erbteil gegeben werden. ");
INSERT INTO deuelo_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Doch soll das Land durchs Los verteilt werden; nach den Namen der Stämme ihrer Väter sollen sie erben; ");
INSERT INTO deuelo_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","nach der Entscheidung des Loses soll jedem Stamme sein Erbteil zugeteilt werden, sowohl den Vielen, als auch den Wenigen. ");
INSERT INTO deuelo_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Und dies sind die Gemusterten Levis nach ihren Geschlechtern: von Gerson das Geschlecht der Gersoniter; von Kehath das Geschlecht der Kehathiter; von Merari das Geschlecht der Merariter. ");
INSERT INTO deuelo_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Dies sind die Geschlechter Levis: das Geschlecht der Libniter, das Geschlecht der Hebroniter, das Geschlecht der Machliter, das Geschlecht der Muschiter, das Geschlecht der Korhiter. Und Kehath zeugte Amram. ");
INSERT INTO deuelo_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Und der Name des Weibes Amrams war Jokebed, eine Tochter Levis, die dem Levi in Ägypten geboren wurde; und sie gebar dem Amram Aaron und Mose und Mirjam, ihre Schwester. ");
INSERT INTO deuelo_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Und dem Aaron wurden geboren Nadab und Abihu, Eleasar und Ithamar. ");
INSERT INTO deuelo_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Und Nadab und Abihu starben, als sie fremdes Feuer vor Jehova darbrachten. ");
INSERT INTO deuelo_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Und ihrer Gemusterten, aller Männlichen von einem Monat und darüber, waren dreiundzwanzigtausend; denn sie wurden nicht unter den Kindern Israel gemustert, weil ihnen kein Erbteil unter den Kindern Israel gegeben wurde. ");
INSERT INTO deuelo_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Das sind die durch Mose und Eleasar, den Priester, Gemusterten, welche die Kinder Israel in den Ebenen Moabs, am Jordan von Jericho, musterten. ");
INSERT INTO deuelo_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Und unter diesen war kein Mann von denen, welche durch Mose und Aaron, den Priester, gemustert worden waren, welche die Kinder Israel in der Wüste Sinai musterten. ");
INSERT INTO deuelo_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Denn Jehova hatte von ihnen gesagt: Sie sollen gewißlich in der Wüste sterben! Und kein Mann von ihnen war übriggeblieben außer Kaleb, dem Sohne Jephunnes, und Josua, dem Sohne Nuns. ");
INSERT INTO deuelo_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Und es nahten herzu die Töchter Zelophchads, des Sohnes Hephers, des Sohnes Gileads, des Sohnes Makirs, des Sohnes Manasses, von den Geschlechtern Manasses, des Sohnes Josephs; und dies waren die Namen seiner Töchter: Machla, Noa und Chogla und Milka und Tirza. ");
INSERT INTO deuelo_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Und sie traten vor Mose und vor Eleasar, den Priester, und vor die Fürsten und die ganze Gemeinde an den Eingang des Zeltes der Zusammenkunft und sprachen: ");
INSERT INTO deuelo_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","Unser Vater ist in der Wüste gestorben; er war aber nicht unter der Rotte derer, die sich in der Rotte Korahs wider Jehova zusammenrotteten, sondern er ist in seiner Sünde gestorben; und er hatte keine Söhne. ");
INSERT INTO deuelo_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Warum soll der Name unseres Vaters abgeschnitten werden aus der Mitte seines Geschlechts, weil er keinen Sohn hat? Gib uns ein Eigentum unter den Brüdern unseres Vaters! ");
INSERT INTO deuelo_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Und Mose brachte ihre Rechtssache vor Jehova. ");
INSERT INTO deuelo_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","Die Töchter Zelophchads reden recht; du sollst ihnen sicherlich ein Erbbesitztum unter den Brüdern ihres Vaters geben, und sollst das Erbteil ihres Vaters auf sie übergehen lassen. ");
INSERT INTO deuelo_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Und zu den Kindern Israel sollst du reden und sprechen: Wenn ein Mann stirbt und keinen Sohn hat, so sollt ihr sein Erbteil auf seine Tochter übergehen lassen. ");
INSERT INTO deuelo_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Und wenn er keine Tochter hat, so sollt ihr sein Erbteil seinen Brüdern geben. ");
INSERT INTO deuelo_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Und wenn er keine Brüder hat, so sollt ihr sein Erbteil den Brüdern seines Vaters geben. ");
INSERT INTO deuelo_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Und wenn sein Vater keine Brüder hat, so sollt ihr sein Erbteil seinem Blutsverwandten geben, dem ihm am nächsten stehenden aus seinem Geschlecht, daß er es erbe. Und das soll den Kindern Israel zu einer Rechtssatzung sein, so wie Jehova dem Mose geboten hat. ");
INSERT INTO deuelo_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Und Jehova sprach zu Mose: Steige auf dieses Gebirge Abarim und sieh das Land, das ich den Kindern Israel gegeben habe. ");
INSERT INTO deuelo_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Und hast du es gesehen, so wirst auch du zu deinen Völkern versammelt werden, so wie dein Bruder Aaron versammelt worden ist; ");
INSERT INTO deuelo_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Weil ihr in der Wüste Zin, beim Hadern der Gemeinde, widerspenstig gewesen seid gegen meinen Befehl, mich durch das Wasser vor ihren Augen zu heiligen. (Das ist das Haderwasser von Kades in der Wüste Zin.) ");
INSERT INTO deuelo_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Und Mose redete zu Jehova und sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","Es bestelle Jehova, der Gott der Geister alles Fleisches, einen Mann über die Gemeinde, ");
INSERT INTO deuelo_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","der vor ihnen her aus-und einziehe, und der sie aus-und einführe; damit die Gemeinde Jehovas nicht sei wie Schafe, die keinen Hirten haben. ");
INSERT INTO deuelo_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Und Jehova sprach zu Mose: Nimm dir Josua, den Sohn Nuns, einen Mann, in dem der Geist ist, und lege deine Hand auf ihn; ");
INSERT INTO deuelo_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","und stelle ihn vor Eleasar, den Priester, und vor die ganze Gemeinde, und gib ihm Befehl vor ihren Augen, ");
INSERT INTO deuelo_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","und lege von deiner Würde auf ihn, damit die ganze Gemeinde der Kinder Israel ihm gehorche. ");
INSERT INTO deuelo_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Und er soll vor Eleasar, den Priester, treten, und der soll für ihn das Urteil der Urim vor Jehova befragen: Nach seinem Befehle sollen sie ausziehen, und nach seinem Befehle sollen sie einziehen, er und alle Kinder Israel mit ihm, ja, die ganze Gemeinde. ");
INSERT INTO deuelo_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Und Mose tat, so wie Jehova ihm geboten hatte, und nahm Josua und stellte ihn vor Eleasar, den Priester, und vor die ganze Gemeinde, ");
INSERT INTO deuelo_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","und er legte seine Hände auf ihn und gab ihm Befehl, so wie Jehova durch Mose geredet hatte. ");
INSERT INTO deuelo_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Und Jehova redete zu Mose und sprach: ");
INSERT INTO deuelo_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","Gebiete den Kindern Israel und sprich zu ihnen: Meine Opfergabe, meine Speise zu meinen Feueropfern, mir zum lieblichen Geruch, sollt ihr acht haben mir darzubringen zu ihrer bestimmten Zeit. ");
INSERT INTO deuelo_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Und sprich zu ihnen: Dies ist das Feueropfer, das ihr Jehova darbringen sollt: zwei einjährige Lämmer ohne Fehl, täglich, als beständiges Brandopfer. ");
INSERT INTO deuelo_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Das eine Lamm sollst du am Morgen opfern, und das zweite Lamm sollst du opfern zwischen den zwei Abenden; ");
INSERT INTO deuelo_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","und zum Speisopfer ein zehntel Epha Feinmehl, gemengt mit einem viertel Hin zerstoßenen Öles, ");
INSERT INTO deuelo_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","(ein beständiges Brandopfer, das am Berge Sinai eingesetzt wurde, zum lieblichen Geruch, ein Feueropfer dem Jehova); ");
INSERT INTO deuelo_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","und sein Trankopfer, ein viertel Hin zu dem einen Lamme; im Heiligtum sollst du das Trankopfer von starkem Getränk dem Jehova spenden. ");
INSERT INTO deuelo_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Und das zweite Lamm sollst du opfern zwischen den zwei Abenden; wie das Morgenspeisopfer und sein Trankopfer, so sollst du zu diesem opfern, ein Feueropfer lieblichen Geruchs dem Jehova. ");
INSERT INTO deuelo_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Und am Sabbathtage zwei einjährige Lämmer ohne Fehl, und als Speisopfer zwei Zehntel Feinmehl, gemengt mit Öl, und sein Trankopfer. ");
INSERT INTO deuelo_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Es ist das Brandopfer des Sabbaths an jedem Sabbath nebst dem beständigen Brandopfer und seinem Trankopfer. ");
INSERT INTO deuelo_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Und im Anfang eurer Monate sollt ihr Jehova ein Brandopfer darbringen: zwei junge Farren und einen Widder, sieben einjährige Lämmer ohne Fehl; ");
INSERT INTO deuelo_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","und zu jedem Farren drei Zehntel Feinmehl, gemengt mit Öl, als Speisopfer; und zu dem einen Widder zwei Zehntel Feinmehl, gemengt mit Öl, als Speisopfer; ");
INSERT INTO deuelo_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","und zu jedem Lamme je ein Zehntel Feinmehl, gemengt mit Öl, als Speisopfer. Es ist ein Brandopfer, ein lieblicher Geruch, ein Feueropfer dem Jehova. ");
INSERT INTO deuelo_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Und ihre Trankopfer: ein halbes Hin Wein soll zu einem Farren sein, und ein drittel Hin zu dem Widder, und ein viertel Hin zu einem Lamme. Das ist das monatliche Brandopfer in jedem Monat, nach den Monaten des Jahres. ");
INSERT INTO deuelo_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Und ein Ziegenbock zum Sündopfer dem Jehova soll nebst dem beständigen Brandopfer und seinem Trankopfer geopfert werden. ");
INSERT INTO deuelo_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Und im ersten Monat, am vierzehnten Tage des Monats, ist Passah dem Jehova. ");
INSERT INTO deuelo_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Und am fünfzehnten Tage dieses Monats ist das Fest; sieben Tage soll Ungesäuertes gegessen werden. ");
INSERT INTO deuelo_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Am ersten Tage soll eine heilige Versammlung sein; keinerlei Dienstarbeit sollt ihr tun. ");
INSERT INTO deuelo_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Und ihr sollt dem Jehova ein Feueropfer, ein Brandopfer darbringen: zwei junge Farren und einen Widder und sieben einjährige Lämmer; ohne Fehl sollen sie euch sein; ");
INSERT INTO deuelo_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","und ihr Speisopfer, Feinmehl, gemengt mit Öl: drei Zehntel sollt ihr opfern zu einem Farren, und zwei Zehntel zu dem Widder; ");
INSERT INTO deuelo_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","je ein Zehntel sollst du opfern zu jedem Lamme, zu den sieben Lämmern; ");
INSERT INTO deuelo_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","und einen Bock als Sündopfer, um Sühnung für euch zu tun. ");
INSERT INTO deuelo_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Außer dem Morgenbrandopfer, das zum beständigen Brandopfer ist, sollt ihr das opfern. ");
INSERT INTO deuelo_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Solches sollt ihr täglich opfern, sieben Tage lang, als Speise eines Feueropfers lieblichen Geruchs dem Jehova; nebst dem beständigen Brandopfer und seinem Trankopfer soll es geopfert werden. ");
INSERT INTO deuelo_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Und am siebten Tage soll euch eine heilige Versammlung sein; keinerlei Dienstarbeit sollt ihr tun. ");
INSERT INTO deuelo_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Und am Tage der Erstlinge, wenn ihr dem Jehova ein neues Speisopfer darbringet, an eurem Wochenfeste, soll euch eine heilige Versammlung sein; keinerlei Dienstarbeit sollt ihr tun. ");
INSERT INTO deuelo_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Und ihr sollt ein Brandopfer darbringen zum lieblichen Geruch dem Jehova: zwei junge Farren, einen Widder, sieben einjährige Lämmer; ");
INSERT INTO deuelo_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","und ihr Speisopfer, Feinmehl, gemengt mit Öl: drei Zehntel zu jedem Farren, zwei Zehntel zu dem einen Widder, ");
INSERT INTO deuelo_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","je ein Zehntel zu jedem Lamme, zu den sieben Lämmern; ");
INSERT INTO deuelo_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","und einen Ziegenbock, um Sühnung für euch zu tun. ");
INSERT INTO deuelo_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Außer dem beständigen Brandopfer und seinem Speisopfer sollt ihr sie opfern (ohne Fehl sollen sie euch sein) nebst ihren Trankopfern. ");
INSERT INTO deuelo_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Und im siebten Monat, am Ersten des Monats, soll euch eine heilige Versammlung sein; keinerlei Dienstarbeit sollt ihr tun; ein Tag des Posaunenhalls soll es euch sein. ");
INSERT INTO deuelo_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Und ihr sollt ein Brandopfer opfern zum lieblichen Geruch dem Jehova: einen jungen Farren, einen Widder, sieben einjährige Lämmer, ohne Fehl; ");
INSERT INTO deuelo_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","und ihr Speisopfer, Feinmehl, gemengt mit Öl: drei Zehntel zu dem Farren, zwei Zehntel zu dem Widder, ");
INSERT INTO deuelo_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","und ein Zehntel zu jedem Lamme, zu den sieben Lämmern; ");
INSERT INTO deuelo_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","und einen Ziegenbock als Sündopfer, um Sühnung für euch zu tun; ");
INSERT INTO deuelo_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","außer dem monatlichen Brandopfer und seinem Speisopfer und dem beständigen Brandopfer und seinem Speisopfer und ihren Trankopfern, nach ihrer Vorschrift, zum lieblichen Geruch, ein Feueropfer dem Jehova. ");
INSERT INTO deuelo_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Und am Zehnten dieses siebten Monats soll euch eine heilige Versammlung sein, und ihr sollt eure Seelen kasteien; keinerlei Arbeit sollt ihr tun. ");
INSERT INTO deuelo_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Und ihr sollt dem Jehova ein Brandopfer darbringen als lieblichen Geruch: einen jungen Farren, einen Widder, sieben einjährige Lämmer; ohne Fehl sollen sie euch sein; ");
INSERT INTO deuelo_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","und ihr Speisopfer, Feinmehl, gemengt mit Öl: drei Zehntel zu dem Farren, zwei Zehntel zu dem einen Widder, ");
INSERT INTO deuelo_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","je ein Zehntel zu jedem Lamme, zu den sieben Lämmern; ");
INSERT INTO deuelo_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","und einen Ziegenbock als Sündopfer; außer dem Sündopfer der Versöhnung und dem beständigen Brandopfer und seinem Speisopfer und ihren Trankopfern. ");
INSERT INTO deuelo_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Und am fünfzehnten Tage des siebten Monats soll euch eine heilige Versammlung sein; keinerlei Dienstarbeit sollt ihr tun, und ihr sollt dem Jehova ein Fest feiern sieben Tage. ");
INSERT INTO deuelo_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Und ihr sollt ein Brandopfer darbringen, ein Feueropfer lieblichen Geruchs dem Jehova: dreizehn junge Farren, zwei Widder, vierzehn einjährige Lämmer; ohne Fehl sollen sie sein; ");
INSERT INTO deuelo_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","und ihr Speisopfer, Feinmehl, gemengt mit Öl: drei Zehntel zu jedem Farren, zu den dreizehn Farren, zwei Zehntel zu jedem Widder, zu den zwei Widdern, ");
INSERT INTO deuelo_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","und je ein Zehntel zu jedem Lamme, zu den vierzehn Lämmern; ");
INSERT INTO deuelo_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","und einen Ziegenbock als Sündopfer; außer dem beständigen Brandopfer, seinem Speisopfer und seinem Trankopfer. ");
INSERT INTO deuelo_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Und am zweiten Tage zwölf junge Farren, zwei Widder, vierzehn einjährige Lämmer ohne Fehl; ");
INSERT INTO deuelo_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","und ihr Speisopfer und ihre Trankopfer, zu den Farren, zu den Widdern und zu den Lämmern, nach ihrer Zahl, nach der Vorschrift; ");
INSERT INTO deuelo_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","und einen Ziegenbock als Sündopfer; außer dem beständigen Brandopfer und seinem Speisopfer und ihren Trankopfern. ");
INSERT INTO deuelo_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Und am dritten Tage elf Farren, zwei Widder, vierzehn einjährige Lämmer, ohne Fehl; ");
INSERT INTO deuelo_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","und ihr Speisopfer und ihre Trankopfer, zu den Farren, zu den Widdern und zu den Lämmern, nach ihrer Zahl, nach der Vorschrift; ");
INSERT INTO deuelo_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","und einen Bock als Sündopfer; außer dem beständigen Brandopfer und seinem Speisopfer und seinem Trankopfer. ");
INSERT INTO deuelo_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Und am vierten Tage zehn Farren, zwei Widder, vierzehn einjährige Lämmer, ohne Fehl; ");
INSERT INTO deuelo_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","ihr Speisopfer und ihre Trankopfer, zu den Farren, zu den Widdern und zu den Lämmern, nach ihrer Zahl, nach der Vorschrift; ");
INSERT INTO deuelo_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","und einen Ziegenbock als Sündopfer; außer dem beständigen Brandopfer, seinem Speisopfer und seinem Trankopfer. ");
INSERT INTO deuelo_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Und am fünften Tage neun Farren, zwei Widder, vierzehn einjährige Lämmer, ohne Fehl; ");
INSERT INTO deuelo_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","und ihr Speisopfer und ihre Trankopfer, zu den Farren, zu den Widdern und zu den Lämmern, nach ihrer Zahl, nach der Vorschrift; ");
INSERT INTO deuelo_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","und einen Bock als Sündopfer; außer dem beständigen Brandopfer und seinem Speisopfer und seinem Trankopfer. ");
INSERT INTO deuelo_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Und am sechsten Tage acht Farren, zwei Widder, vierzehn einjährige Lämmer, ohne Fehl; ");
INSERT INTO deuelo_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","und ihr Speisopfer und ihre Trankopfer, zu den Farren, zu den Widdern und zu den Lämmern, nach ihrer Zahl, nach der Vorschrift; ");
INSERT INTO deuelo_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","und einen Bock als Sündopfer; außer dem beständigen Brandopfer, seinem Speisopfer und seinen Trankopfern. ");
INSERT INT